﻿USE sofia;
DROP TABLE IF EXISTS sofia.tocNT_vpl;
CREATE TABLE tocNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tocNT_vpl WRITE;
INSERT INTO tocNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Xalak­maká̠n xli̠­ta­la­ka­pasni Jesu­cristo huá xca̠­ma̠­la­ca­tzu­qui̠ni̠t Abraham xa̠hua rey David, pus antá nac u̠má libro tatzok­ta­hui­lani̠t xta­cu­hui­nicán. Uma̠­kó̠lh lac­chix­cu­huí̠n chiné xca̠­hua­nicán: ");
INSERT INTO tocNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Amá ko̠lu­tzí̠n Abraham xuí cha̠tum xka­huasa hua̠nti̠ xuanicán Isaac, y chi̠nchú xka­huasa Isaac xuanicán Jacob, xka­huasa Jacob xuanicán Judá xa̠hua maka­pi­tzí̠n xna­ta̠lán. ");
INSERT INTO tocNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Xla­ka­huasán Judá xca̠­hua­nicán Fares chu Zara (xtzicán xuanicán Tamar). Xka­huasa Fares xuanicán Esrom, xka­huasa Esrom xuanicán Aram. ");
INSERT INTO tocNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Xka­huasa Aram xuanicán Ami­nadab, xka­huasa Ami­nadab xuanicán Naasón, xka­huasa Naasón xuanicán Salmón. ");
INSERT INTO tocNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Xka­huasa Salmón xuanicán Booz (xtzí xuanicán Rut), xka­huasa Booz xuanicán Obed, xka­huasa Obed xuanicán Isaí. ");
INSERT INTO tocNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Xka­huasa Isaí xuanicán David, y chi̠nchú xlá rey David, tita̠­táhui xpusca̠t Urías y chuná tila­cá­chilh cha̠tum xka­hua­sacán hua̠nti̠ xuanicán Salo­món. ");
INSERT INTO tocNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Xka­huasa Salo­món xuanicán Roboam, xka­huasa Roboam xuanicán Abías, xka­huasa Abías xuanicán Asá. ");
INSERT INTO tocNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Xka­huasa Asá xuanicán Josafat, chi̠nchú xlá xka­huasa Josafat xuanicán Joram, xka­huasa Joram xuanicán Uzías. ");
INSERT INTO tocNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Xka­huasa Uzías xuanicán Jotam, xka­huasa Jotam xuanicán Acaz, xka­huasa Acaz xuanicán Eze­quías. ");
INSERT INTO tocNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Xka­huasa Eze­quías xuanicán Manasés, xka­huasa Manasés xuanicán Amón, xka­huasa Amón xuanicán Josías. ");
INSERT INTO tocNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Xka­huasa Josías xuanicán Jecon­ías xa̠huá xna­ta̠lán acxni­tiyá amá quilh­ta­macú acxni̠ xamaká̠n tica̠­chi̠­lé̠n­calh cumu la̠ tachí̠n la̠qui̠ antá natas­cu­ja̠chá israel­itas nac xaca̠­chi­quí̠n Babi­lonia. ");
INSERT INTO tocNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Acxni̠ chú antá xta­hui­la̠­nanchá anta­nícu xca̠­le̠n­cani̠t tila­cá­chilh xka­huasa Jecon­ías hua̠nti̠ xuanicán Sala­tiel, xka­huasa Sala­tiel xuanicán Zoro­babel. ");
INSERT INTO tocNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Xka­huasa Zoro­babel xuanicán Abiud, xka­huasa Abiud xuanicán Elia­quim, xka­huasa Elia­quim xuanicán Azor. ");
INSERT INTO tocNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Chi̠nchú xlá xka­huasa Azor xuanicán Sadoc, xka­huasa Sadoc xuanicán Aquim, xka­huasa Aquim xuanicán Eliud. ");
INSERT INTO tocNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Xka­huasa Eliud xuanicán Elea­zar, xka­huasa Elea­zar xuanicán Matán, xka­huasa Matán xuanicán Jacob. ");
INSERT INTO tocNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Xka­huasa Jacob xuanicán José, pus huá chú eé José hua̠nti̠ tita̠­ta­ma­káx­tokli María y na̠ hua­tiyá chú eé María hua̠nti̠ ma̠la­ka­tun­cú­hui̠lh Jesús y makás­tacli; hua­tiyá eé Jesús hua̠nti̠ li̠ma̠­pa̠­cu­hui̠cán Cristo porque huá quin­ca̠­lak­ma̠x­tuyá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Pus hasta la̠ta xamaká̠n xlama ko̠lu­tzí̠n Abraham, quilh­mac­cu̠­ta̠ti pu̠tá­hui̠lh hua̠nti̠ tati̠­la­tá­ma̠lh hasta acxni laca­chilh Rey David, y hasta a̠quilh­ma­cu­ta̠ti pu̠tá­hui̠lh acxni̠ israel­itas tachí̠n tica̠­lé̠n­calh nac Babi­lonia, pero na̠chuna li̠túm quilh­mac­cu̠­ta̠ti pu̠tá­hui̠lh qui̠­táx­tulh acxni̠ xca̠­chi̠­cani̠t israel­itas hasta acxni̠ lacá­chilh Cristo. ");
INSERT INTO tocNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Chú cámaj ma̠la­ca­pu̠­tun­cu­hui̠y la̠ta lácu qui̠­táx­tulh acxni̠ tila­cá­chilh Quim­pu̠­chi­nacán Jesús: Amá María hua̠nti̠ xtzi huá Jesús xlá aya csquin­cani̠t, y aya xli̠­kalh­ti̠ni̠t xla­cata nata̠­ta­maka­xtoka José. Pero acxni̠ nia̠ xla̠­ta̠­ta­huilay, y nia̠ cxa­katli̠y tuncán José, huata xlá niaj sacstu xlama porque chú aya xkalh­ka­lhi̠ma cha̠tum skata, pero huá xlá xli̠­maka­tli­hueke Espíri­tu Santo hua̠nti̠ chuná xtla­huani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Acxni̠ José cátzi̠lh pi̠ María hua̠nti̠ xtas­quín xuani̠t niaj sacstu xlama, y cumu huata xlá tla̠n xta­pu­huá̠n xuani̠t huata ni̠ ma̠la­ca­pu̠­pú­tulh xla­cata ni̠ nama̠­ma̠­xani̠y, huata mejor xlá caj tze̠k xak­xte­kuili̠­putún y chuná chú nalac­tla­huay xta­chu­huí̠n hua̠ntu̠ xqui̠­mak­xtekni̠t nac xchic xtas­quín pero xlá ni̠ xla­cas­quín nata­ca­tzi̠y xli̠­lhu̠hua cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Luu acxni̠ chuná xla­ca­pa̠s­tacma, cha̠tum xángel Quim­pu̠­chi­nacán Dios tasi­yú­nilh nac ca̠ta­ma̠­nixni y chiné huá­nilh: —José, xli̠­ta­la­ka­pasni rey David, ni̠ cali̠­ma̠­xá­nanti xla­cata namaka­maklhti̠­nana y nata̠­ta­hui­laya María cumu la̠ mim­pusca̠t, porque a̠má skata hua̠ntu̠ xlá kalh­ka­lhi̠ma huá xli̠t­li­hueke Espíri­tu Santo ma̠squi chuná xlá lani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Acxni̠ chú nala­ca­chín a̠má actzu kahuasa, huix nali̠­ma̠­pa̠­cu­hui̠ya Jesús. Huá xlá chuná nali̠­hua­nicán porque naca̠­lac­xa­paniy naca̠­ma̠­ta­ke̠­nu̠niy xta­la̠­ka­lhi̠ncán xli̠­hua̠k hua̠nti̠ nata­li̠­pa̠­huán. ");
INSERT INTO tocNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Huá chuná xlá lí̠lalh la̠qui̠ María nama̠­kan­taxti̠y xta­chu­huí̠n Dios hua̠ntu̠ xamaká̠n tima̠­lac­pu­huá̠­ni̠lh pro­feta Isaías xla­cata natzoka nac xlibro acxni̠ chiné huá: ");
INSERT INTO tocNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Cha̠tum tzuma̠t hua̠nti̠ ni̠ti̠ a̠xakatli̠y chixcú, chú niaj sacstu lama porque ámaj ma̠la­ka­tun­cu­hui̠y cha̠tum skata; xlá nali̠­ma̠­pa̠­cu­hui̠cán Eman­uel, porque eé tachu­huí̠n Ema­nuel huam­putún: Dios quinca̠ta̠lamá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Acxni̠ José laka­huanchá la̠ta xma̠­nix­nima pus chuná xlá tlá­hualh cumu la̠ huá­nilh xángel Quim­pu̠­chi­nacán y ta̠ta­ma­káx­tokli María cumu la̠ xpusca̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero ne̠c­xnicú lak­xtum ta̠lh­tá­talh la̠ta xta­táhui hasta lacá­chilh actzu̠ xka­huasa María, y José chuná li̠ma̠­pa̠­cú­hui̠lh Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús tila­ka­tun­cú­huilh nac aktum actzu ca̠chi­quí̠n hua­nicán Belén, huá a̠má pu̠la­tama̠n hua̠ntu̠ xma̠­peksi̠y xamu­ni­cipio Judea, y na̠ acxni̠ a̠má ca̠ta acxni̠ rey Herodes xuí li̠ma̠­pek­si̠ná nac a̠má lanca pu̠la­tama̠n. Ni̠ xli̠­maka̠s tachilh nac xaca̠­chi­quí̠n Jeru­salén maka­pi­tzí̠n lak­ska­lalán lac­chix­cu­huí̠n hua̠nti̠ xta­ma̠­lak­cha̠ni̠y hua̠ntu̠ nalay acxni̠ xlacán xtaucxilha stacu hua̠ntu̠ tahui­lá̠­nalh nac akapú̠n, y u̠ma̠ko̠lh lac­chix­cu­huí̠n xca̠­hua­nicán magos. Xa̠huachí xlacán luu mákat antaní xta­mi­ni̠­tanchá pekán pa̠kalhú anta­nícu pulha̠chá chi­chiní. ");
INSERT INTO tocNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Xlacán chiné taka­lhas­qui­ní̠­nalh: —¿Nícu huí a̠má actzu rey hua̠nti̠ la̠nchú laca­chini̠t xla­cata xlá natzu­cuyá̠n ca̠ma̠­pek­si̠yá̠n uú nac mim­pu̠­la­ta­ma̠ncán? Porque hasta nac quim­pu̠­la­ta­ma̠ncán cuc­xilh­chá̠hu la̠ta tzú­culh lak­skoy cstacu, y hasta uú aquinín cmi­ni̠­táhu la̠qui̠ nac­la­ka­chix­cu­hui̠­yá̠hu. ");
INSERT INTO tocNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Acxni̠ rey Herodes cátzi̠lh hua̠ntu̠ xta­lak­mini̠t a̠ma̠ko̠lh lac­chix­cu­huí̠n xlá luu aka­tiyuj tamák­xtekli, y na̠chuná xli̠­lhu̠hua cris­tianos hua̠nti̠ xta­hui­lá̠­nalh nac Jeru­salén. ");
INSERT INTO tocNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herodes laca­pala ca̠ma̠­mac­xtú­mi̠lh xana­puxcun xcu­rajcán judíos xa̠huá xma̠­kalh­ta­hua­ke̠­nacán, y chiné ca̠ka­lhás­quilh: —Pus cumu hui­xinín catzi̠­yá̠tit, caqui­la̠­hua­níhu, ¿xatú­cuya̠ ca̠chi­quí̠n luu napu̠­la­ca­chín Cristo hua̠nti̠ hua­ná̠tit pi̠ naca̠­lak­ma̠x­tuyá̠n? ");
INSERT INTO tocNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Xlacán chiné tahuá­nilh: —Tamá Cristo antá amaj laca­chín nac Belén xmu­ni­cipio Judea, porque chuná títzokli cha̠tum pro­feta nac li̠kalh­ta­huaka anta­nícu chiné huán: ");
INSERT INTO tocNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Chi̠nchú huix actzu ca̠chi­quí̠n Belén, ni̠ cali̠­pú­huanti para huix lac­pu­huana pi̠ ni̠tu̠ li̠ma­cuana cumu la̠ maka­pi­tzí̠n lac­lanca ca̠chi­qui̠ní̠n hua̠ntu̠ tahui­lá̠­nalh nac Judea; porque antá nac eé actzu ca̠chi­quí̠n amaj laca­chín cha̠tum hua̠nti̠ naca̠­pux­culé̠n y naca̠­mak­ta­kalha quin­ca­maná̠n xalac Israel. ");
INSERT INTO tocNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Aca­li̠stá̠n rey Herodes tze̠k ca̠ta­sá­nilh a̠ma̠ko̠lh lak­ska­lalán lac­chi­xcu­huí̠n y ca̠ka­lhás­quilh túcuya̠ quilh­ta­macú tzú­culh taucxilha a̠má stacu. ");
INSERT INTO tocNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Acxni̠ xlacán tahua­ni­ko̠lh xlá ca̠ma̠­la­ká­cha̠lh nac Belén, y chiné ca̠huá­nilh: —Pus la̠li̠­huán capim­pítit nac Belén y li̠huana̠ cali̠­ka­lhas­qui­ni̠­nántit xla­cata a̠má actzu kahuasa; y acxni̠ chú namac­la­yá̠tit la̠li̠­huán naqui­la̠­ma̠­ca­tzi̠­ni̠­yá̠hu xanícu luu huí la̠qui̠ na̠ nacán laka­chix­cu­hui̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Acxni̠ rey Herodes chuná ca̠hua­ni­ko̠lh eé tachu­huí̠n, a̠ma̠ko̠lh lac­chix­cu­huí̠n la̠li̠­huán táalh. Y caj li̠puntzú a̠má stacu hua̠ntu̠ xtaucxilh­ni̠­tanchá nac xpu̠­la­ta­ma̠ncán aya xca̠­pu̠­la­ni­ti̠­lhay nac tiji y hasta antá tachó­kolh xma̠­la­ka­tancs nac amá chiqui anta­nícu xuí a̠má actzu skata. ");
INSERT INTO tocNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Acxni̠ a̠ma̠ko̠lh lak­ska­lalán lac­chix­cu­huí̠n taúcxilhli anta­nícu tachó­kolh a̠má stacu, luu xli̠­ca̠na tapa̠­xú­hualh. ");
INSERT INTO tocNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Acxni̠ chú tatá­nu̠lh nac chiqui y acxni̠ taúcxilhli a̠má actzu kahuasa pi̠ xchexni̠t María, la̠li̠­huán tata­tzo­kós­talh nac ca̠ti­yatni y tala­ka­chix­cú­hui̠lh. Aca­li̠stá̠n chú tama̠­ká­ke̠lh xca­jacán hua̠ntu̠ xpu̠­ma­ju̠ni̠t hua̠ntu̠ xlacán xtalé̠n y tatá̠i̠lh oro, sien­sus chu xala­cuán per­fumes hua­nicán mirra. ");
INSERT INTO tocNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Y aca­li̠stá̠n chú acxni̠ aya talh­tá­talh ca̠tzi̠sní, nac ca̠ta­ma̠­nixni ca̠ma̠­ca­tzí̠­ni̠lh xángel Quim­pu̠­chi­nacán xla­cata pi̠ niaj antá catáalh nac Jeru­salén anta­nícu hui­lachá Herodes. Pus xlacán chuná tat­lá­hualh y huata túnuj tiji tachí­palh hua̠ntu̠ ti̠tum an hasta nac xca̠­chi­qui̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Acxni̠ aya najata xtaanko̠ni̠t a̠ma̠ko̠lh lak­ska­lalán lac­chix­cu­huí̠n cha̠tum xángel Quim­pu̠­chi­nacán nac ca̠ta­ma̠­nixni tasi­yú­nilh José y chiné huá­nilh: —La̠li̠­huán cata̠qui y caca̠­ta̠­tá­ca̠xti tamá actzu kahuasa xa̠hua xtzí y mákat catza̠­látit hasta nac xapu̠­la­tama̠n Egipto. Antá chú nata­mak­xte­ka̠­pítit hasta acxni̠ aquit nacuaniyá̠n hua̠ntu̠ mili̠t­lá­huat, porque rey Herodes nama̠­pu­tzi̠nán tamá actzu kahuasa la̠qui̠ namakni̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","José y María la̠li̠­huán tas­ca­ca­tá̠­qui̠lh y laca­pala tamá̠­ca̠xli a̠má actzu kahuasa y antá chú alh tahuilay nac xapu̠­la­tama̠n Egipto. ");
INSERT INTO tocNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Pus antá chú xlacán xta­hui­la̠­nanchá hasta acxni̠ ni̠lh rey Herodes. Chuná tancs li̠kan­táx­tulh xta­chu­huí̠n Quim­pu̠­chi­nacán Dios hua̠ntu̠ tima̠­lac­pu­huá̠­ni̠lh xla­cata natzoka pro­feta Oseas nac xlibro anta­nícu chiné huán: “Aquit cli̠­ma̠­pek­sí̠­nalh xla­cata cali̠­mín­calh quin­ka­huasa anta­nícu xuilachá nac Egipto.” ");
INSERT INTO tocNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Acxni̠ rey Herodes cátzi̠lh pi̠ a̠ma̠ko̠lh lak­ska­lalán lac­chix­cu­huí̠n xta­li̠­kalh­ka­ma̠­nani̠t xlá luu li̠pe̠cua la̠ta sí̠tzi̠lh y ma̠pek­sí̠­nalh xla­cata naca̠­mak­ni̠cán xli̠­hua̠k lactzu laka­huasán hua̠nti̠ nia̠ xma̠­ka­tzi̠ko̠y aka­tiyú̠n ca̠ta hua̠nti̠ xta­hui­lá̠­nalh nac xaca̠­chi­quí̠n Belén chu antá laca­tzuní̠n. Huá chuná li̠t­lá­hualh porque a̠ma̠ko̠lh lak­ska­lalán lac­chix­cu­huí̠n tali̠­ta̠­chu­huí̠­nalh pi̠ xka­lhi̠y cumu aktiy ca̠ta la̠ta xlacán titaúcxilhli a̠má cstacu Cristo. ");
INSERT INTO tocNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Hua̠ntu̠ tlá­hualh Herodes la̠ta ca̠ma̠­mak­ni̠­ní̠­nalh lactzu camán chuná li̠kan­táx­tulh hua̠ntu̠ maká̠n quilh­ta­macú títzokli pro­feta Jerem­ías nac xlibro anta­nícu chiné huán: ");
INSERT INTO tocNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Nac xaca̠­chi­quí̠n Ramá takax­mata la̠m­para tícu ma̠rí li̠pu­huama y tasax­ni̠ma. Pus huata huá a̠ma̠ko̠lh lac­chaján hua̠nti̠ antá tahui­lá̠­nalh nac a̠má ca̠chi­quí̠n hua̠nti̠ ma̠rí tali̠­pu­hua­má̠­nalh y tata­sa­má̠­nalh, y ni̠ laca­squin­ko̠lh para tícu naca̠­ma̠­ko­xu­mixiy, porque huá xlacán talak­ta­sa­má̠­nalh y talak­ca­tza­má̠­nalh xca­mancán hua̠nti̠ aya ca̠mak­ni̠­ni­cani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pero maka̠s laca­tzá̠­lalh quilh­ta­macú y acxni̠ ni̠lh Herodes cha̠tum xángel Quim­pu̠­chi­nacán nac ca̠ta­ma̠­nixni tasi­yú­nilh José nac Egipto y chiné huá­nilh: ");
INSERT INTO tocNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Chú la̠li̠­huán cata̠­quí̠tit caca̠­má̠­ca̠xti actzu kahuasa xa̠hua xtzí, y antá chú catas­pit­pa­rátit nac mim­pu̠­la­ta­ma̠ncán Israel, porque chú aya tani̠ni̠t hua̠k a̠ma̠ko̠lh lac­chix­cu­huí̠n hua̠nti̠ xta­mak­ni̠­putún tamá actzu kahuasa. ");
INSERT INTO tocNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","José la̠li̠­huán tá̠qui̠lh y quilh­ta̠­yapá xtiji ca̠tá̠alh a̠má actzu kahuasa chu xtzí antá nac pekán xpu̠­la­ta­ma̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Acxni̠ nia̠ xcha̠n José cátzi̠lh pi̠ huá chú xma̠­pek­si̠­nama nac Judea Arquelao xka­huasa Herodes xpa̠­lak­xoko xtla̠t. Huata José juerza tzinú laca­pu­huá­nilh y ni̠ cha̠lh, pero cumu ma̠ca­tzi̠­ni̠­pa­ráca nac ca̠ta­ma̠­nixni huata mejor xlá antá alh nac xapu̠­la­tama̠n Gali­lea. ");
INSERT INTO tocNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Acxni̠ chú antá cha̠lh huata alh tahuilay nac aktum actzu ca̠chi­quí̠n hua­nicán Naza­ret. Huá chuná qui̠­li̠­táx­tulh la̠qui̠ nakan­taxtuy nac xla­táma̠t Jesús hua̠ntu̠ xta­tzok­ta­hui­lani̠t nac xlib­rojcán pro­feta pi̠ nali̠­ta­pa̠­cu­hui̠y naza­reno. ");
INSERT INTO tocNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Acxni̠ chú tilák­cha̠lh quilh­ta­macú xla­cata Juan Bau­tista nama̠­tzu­qui̠y xta­scújut, antá tíalh nac desierto hua̠ntu̠ huí nac xapu̠­la­tama̠n Judea. ");
INSERT INTO tocNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Xlá antá tzú­culh ca̠ma̠­kalh­chu­hui̠ni̠y cris­tianos y chiné xca̠­huaniy: —¡Luu cat­la­huátit li̠tlá̠n, calak­pa­lí̠tit xali̠xcáj­nit min­ta­la­ca­pa̠s­tac­nicán, y chuná cala­ta­pá̠tit cumu la̠ Dios lacas­quín! Porque chú aya lak­cha̠ni̠t quilh­ta­macú acxni̠ xlá ámaj ma̠tzu­qui̠y xasa̠sti xta­péksi̠t nac ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Hua­tiyá chú tamá Juan Bau­tista hua̠nti̠ pro­feta Isaías tili̠­chu­huí̠­nalh xamaká̠n quilh­ta­macú acxni̠ chiné titzók­nulh nac xlibro: Takax­ma­ta̠chá aktum tachu­huí̠n nac desierto anta­nícu ni̠tícu lama cris­tianos y chiné huán: “Caca̠x­tla­hua­nítit tiji anta­nícu luu tla̠n nalacmín Quim­pu̠­chi­nacán; caca̠x­tla­hua­nítit kantum tiji hua̠ntu̠ luu statua.” ");
INSERT INTO tocNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Amá lháka̠t hua̠ntu̠ xli̠­lha­ka̠nán Juan huá xli̠t­la­hua­cani̠t xmac­chíxit camello, xtam­pu̠­lak­ta­huilay kantum cin­turón xla xu̠hua, y huá xlá xca̠­li̠­hua̠yán lactzu xtuqui xa̠hua táxca̠t hua̠ntu̠ xlá xmaclay nac ca̠qui­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Lhu̠hua cris­tianos xala mákat xtamín takax­matniy xta­chu­huí̠n, y na̠chuná hua̠nti̠ xta­hui­lá̠­nalh nac xaca̠­chi­quí̠n Jeru­salén, xa̠hua hua̠nti̠ xta­la­má̠­nalh xli̠­ca̠­lanca nac xapu̠­la­tama̠n Judea y na̠chuná chú a̠ma̠ko̠lh cris­tianos hua̠nti̠ antá xta­hui­lá̠­nalh nac xca̠­quilh­tu̠ní̠n kalh­tu̠­choko hua­nicán Jordán. ");
INSERT INTO tocNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Y acxni̠ chú xlacán maktum xta­huán pi̠ xli̠­ca̠na xta­lak­pa­li̠­putún xali̠xcáj­nit xta­la­ca­pa̠s­tac­nicán, Juan xca̠ak­munuy nac kalh­tu̠­choko. ");
INSERT INTO tocNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pero acxni̠ Juan ca̠úcxilhli pi̠ na̠chuná fariseos chu sadu­ceos xta­lakmín xla­cata na̠ nata­ta̠k­munuy huata xlá chiné ca̠huá­nilh: —Chú hui­xinín luu xta̠­chuná lapá̠tit cumu lá talay a̠ma̠ko̠lh lac­li̠xcáj­nit xca­naní̠n lu̠hua acxni̠ tatzucuy tatza̠­laniy lhcúya̠t acxni̠ ca̠x­ko­yu­má̠­calh. ¿Tícu ca̠ma̠­ca­tzi̠ní̠n hui­xinín para caj la̠ nataakmu­nu­yá̠tit chú aya tla̠n napu̠­tax­tu­yá̠tit xla­cata a̠má tapa̠tí̠n hua̠ntu̠ la̠nchú Dios naca̠­ma­ca­mi­niyá̠n? ");
INSERT INTO tocNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Pus tla̠n nahuán, pero luu aksti̠tum cala­ta­pá̠tit la̠qui̠ chuná sta­lanca nali̠­ta­si­yu­yá̠tit pi̠ xli̠­ca̠na aya lak­pa­li̠­ni̠­tátit xali̠xcáj­nit min­ta­la­ca­pa̠s­tac­nicán. ");
INSERT INTO tocNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Y ni̠ huata caj cali̠­la­ca­ta̠­qui̠­nántit xla­cata pi̠ cumu xli̠­ta­la­ka­pasni Abraham hui­xinín chú ni̠lay túcu cati­ca̠ak­spulán. Porque xli̠­ca̠na pi̠ ni̠chuná cati­qui̠­táx­tulh porque para hui­xinín caj xma̠nhuá li̠mac­la­ca­pi­ná̠tit pus aquit laca­tancs cca̠­hua­niyá̠n pi̠ para Dios chuná xla­cás­quilh u̠ma̠ko̠lh chí­huix xlá tla̠n xca̠­li̠­má̠x­tulh xli̠­ta­la­ka­pasni Abraham. ");
INSERT INTO tocNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Dios xta̠­chuná ca̠li̠­ma̠x­tuyá̠n cumu la̠ qui­huí̠n, y xa̠huachí xlá aya cha̠­ca­tzi̠yaj chi­pani̠t xhacha la̠qui̠ naca̠­tan­ca̠mi̠y a̠ma̠ko̠lh quihui hua̠ntu̠ ni̠tu̠ li̠ma­cuán. Y la̠tachá túcuya̠ quihui hua̠ntu̠ ni̠ tahuacay tlan xta­huácat ca̠mi̠cán y ma̠pu̠cán nac lhcúya̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Xli̠­ca̠na xlá pi̠ caj chú­chut aquit cca̠­liakmu­numá̠n la̠qui̠ chuná nali̠­ca­tzi̠cán pi̠ xli̠­ca̠na lak­pa­li̠­ni̠­tátit xali̠xcáj­nit min­ta­la­ca­pa̠s­tac­nicán; pero chú amajá chin cha̠tum hua̠nti̠ aquit cpu̠­la­ni­ti̠­lhay huata xlá naca̠­liakmu­nuyá̠n xli̠t­li­hueke Espíri­tu Santo chu lhcúya̠t. Pero xlá a̠tzinú lanca xla­ca­tzúcut ni̠ xachuná aquit, xa̠huachí aquit ni̠para tzinú qui­mi­ni̠niy nac­li̠­taxtuy cumu lá xta­sa̠cua nacuán la̠qui̠ nac­xcutniy xata­síhu xtu̠­xu̠hua. ");
INSERT INTO tocNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Xlá luu aya li̠huana̠ laca­pa̠s­tacni̠t la̠ta lácu naca̠­ma̠­paj­pi­tziy cris­tianos, luu xta̠­chuná xlá naca̠t­la­huay cumu la̠ a̠má cha̠tum chixcú hua̠nti̠ cha̠­ca­tzi̠yaj chi­pani̠t xli̠­lac­su­nucán xtrigo la̠qui̠ namakaniy xapalhma, y acxni̠ chú aya lac­su­nu­ko̠ni̠t nahuán a̠má trigo li̠huana̠ nama̠­qui̠y nac xpú̠­cuxi, y chi̠nchú xapalhma antá nalaclhcuyuhuili̠y nac lhcúya̠t antanícu ne̠cxnicú lakmixa. ");
INSERT INTO tocNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ni̠ li̠maka̠s quilh­ta­macú Jesús taca̠xchá nac xca̠­chi­quí̠n hua̠ntu̠ huí nac xapu̠­la­tama̠n Gali­lea y antá chú chilh nac kalh­tu̠­choko hua̠ntu̠ hua­nicán Jordán anta­nícu xak­mu­nu̠­numa Juan la̠qui̠ xlá na̠ naakmu­nucán. ");
INSERT INTO tocNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Acxni̠ xlá lák­chilh, Juan ni̠ xak­mu­nu­putún, y chiné huá­nilh: —Huata aquit qui­mi­ni̠niy naquiakmu­nuya, ¿chi̠nchú huata huix qui­lak­tana xla­cata aquit nacak­mu­nuyá̠n? ");
INSERT INTO tocNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesús chiné huá­nilh: —Luu xli̠­ca̠na cat­lahua hua̠ntu̠ cuanimá̠n porque xla­ca­squinca pi̠ chuná quin­ca̠­mi­ni̠­niyá̠n nama̠­kan­tax­ti̠­yá̠hu xli̠­hua̠k hua̠ntu̠ Dios laclh­ca̠­hui­li̠ni̠t. Y Juan tla̠n tlá­hualh. ");
INSERT INTO tocNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Acxni̠ Jesús taakmu­nu­ko̠lh y aya xta­cutma nac xquilhtú̠n chú­chut, ¡caj xamaktum talá­qui̠lh akapú̠n y Jesús úcxilhli Xes­pí­ritu Dios xta̠c­ta­ma̠chi cumu la̠ actzu paloma y antá ti̠tum xlak­mima! ");
INSERT INTO tocNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Y na̠ luu acxni­tiyá a̠má takáx­matli aktum tachu­huí̠n hua̠ntu̠ minchá nac akapú̠n y chiné huá: —Huá u̠má Quin­ka­huasa hua̠nti̠ aquit luu cpa̠x­qui̠y, luu xli̠­ca̠na cli̠­pa̠­xu­huay hua̠ntu̠ xla­cata. ");
INSERT INTO tocNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Aca­li̠stá̠n acxni̠ taakmu­nu­ko̠lh, a̠má Espíri­tu Santo ma̠lac­pu­huá̠­ni̠lh Jesús xla­cata naán nac desierto antá nac a̠má pu̠la­tama̠n ní ni̠tícu lama cris­tianos la̠qui̠ antá nata̠­la̠­tzak­sa­ya̠chá akska­huiní. ");
INSERT INTO tocNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","La̠ta antá xla­ma̠chá ti̠puxam quilh­ta­macú tan­tacú tan­tas­caca ni̠tu̠cu huá̠­yalh, y aca­li̠stá̠n chú tzu­culhá tzincsa. ");
INSERT INTO tocNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Huata akska­huiní la̠li̠­huán lák­milh la̠qui̠ nata̠­la̠­tzaksay y chuná nama̠t­la­hui̠y tala̠­ka­lhí̠n, y chiné huá­nilh: —Cumu para xli̠­ca̠na huix Xka­huasa Dios, pus chú la̠nchú cali̠­ma̠­pek­sí̠­nanti xla­cata pi̠ u̠ma̠ko̠lh chí­huix cax­ti­lá̠n­chahu nahuán. ");
INSERT INTO tocNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesús kálh­ti̠lh: —Xta­chu­huí̠n Dios hua̠ntu̠ tatzok­ta­hui­lani̠t nac li̠kalh­ta­huaka chiné huan: “Ni̠ luu caj xma̠n xtahuá cati­li̠­la­tá­ma̠lh cha̠tum cris­tiano, pus na̠ luu xla­ca­squinca nali̠­la­tama̠y a̠má xta­chu­huí̠n Dios hua̠ntu̠ xlá li̠ma̠­peksi̠y.” ");
INSERT INTO tocNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Y aca­li̠stá̠n a̠má akska­huiní le̠lh nac xaca̠­chi­quí̠n Jeru­salén anta­nícu xyá lanca xpu̠­si­culan Dios, tahuá­calh nac xak­stí̠n, ");
INSERT INTO tocNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","y antá chiné huá­nilh: —Para xli̠­ca̠na huix Xka­huasa Dios la̠nchú uú lhken capit hasta nac ca̠ti­yatni, porque nac xta­chu­huí̠n Dios hua̠ntu̠ tatzok­ta­hui­lani̠t nac li̠kalh­ta­huaka, chiné huán: Dios naca̠­li̠­ma̠­peksi̠y xán­geles la̠qui̠ nacuentaj­tat­la­huayá̠n, nata­li̠­chi­pa­pa̠x­toká̠n xmacancán la̠qui̠ min­tantú̠n ni̠para aktum chí­huix nali̠­ta­ka̠­hui̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús chiné kálh­ti̠lh: —Pero na̠ luu mili̠­cá­tzi̠t pi̠ hua̠ntu̠ tatzok­ta­hui­lani̠t xta­chu­huí̠n Dios na̠ chiné huán: “Ni̠ caj chu­natá cali̠­kalh­ka­má̠­nanti Mim­pu̠­chi­nacán Dios la̠qui̠ nat­la­huay hua̠ntu̠ huix laka­ti̠ya cat­lá­hualh hua̠ntu̠ ni̠para tzinú mini̠­niyá̠n.” ");
INSERT INTO tocNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Aca­li̠s­ta̠n­li̠túm chú a̠má akska­huiní ta̠ampá nac aktum lanca ke̠stí̠n y caj ucu ma̠ucxilh­ni̠­ko̠lh xli̠­hua̠k lac­lanca ca̠chi­qui̠ní̠n hua̠ntu̠ tahui­lá̠­nalh nac ca̠ti­yatni, y na̠chuná la̠ta túcua kalhi̠ko̠y xli̠­li̠­la­káti̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Y chiné huá­nilh: —Para huix naqui­la­ka­ta­tzo­kos­taya y naqui­la­ka­chix­cu­hui̠ya cumu la̠ mim­pu̠­chiná, aquit nac­ma̠x­qui̠yá̠n pu̠tum hua̠ntu̠ ucxílhpa̠t la̠nchú. ");
INSERT INTO tocNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Y acxni­tiyá Jesús chiné huá­nilh: —Huix akska­huiní, luu xli̠­ca̠na cat­lahua li̠tlá̠n caquin­ta­ke̠­nu̠ni, porque nac xta­chu­huí̠n Dios chiné huán: “Xma̠nhuá Mim­pu̠­chi­nacán Dios cala­ka­chix­cuhui y caka­lha­káx­patti hua̠ntu̠ xlá li̠ma̠­pek­si̠má̠n.” ");
INSERT INTO tocNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Amá akska­huiní mák­xtekli Jesús y la̠li̠­huán támilh ángeles xalac akapú̠n la̠qui̠ nata­mak­ta­kalha. ");
INSERT INTO tocNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Acxni̠ Jesús cátzi̠lh pi̠ Juan Bau­tista tamac­nú̠­calh nac pu̠la̠­chi̠n huata xlá ampá nac Gali­lea y cha̠lh nac Naza­ret. ");
INSERT INTO tocNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pero ni̠ maka̠s tamák­xtekli antá, huata mejor antá alh tahuilay nac Caper­naum. Umá ca̠chi­quí̠n huí nac xquilhtú̠n xapu­punú Gali­lea, huá u̠má pu̠la­tama̠n anta­nícu maká̠n quilh­ta­macú xta­ma̠­pek­si̠ni̠t xapu̠­la­tama̠n Zabulón y Nef­talí. ");
INSERT INTO tocNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Chuná li̠kan­táx­tulh hua̠ntu̠ pro­feta Isaías títzokli nac xlibro anta­nícu chiné huán: ");
INSERT INTO tocNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Hua̠nti̠ tahui­lá̠­nalh nac a̠ma̠ko̠lh pu̠la­tama̠n hua̠ntu̠ ca̠hua­nicán Zabulón chu Nef­talí, anta­nícu ti̠taxtuy lan­ca̠­tiji hua̠ntu̠ cha̠n hasta nac pupunú; a̠ma̠ko̠lh cris­tianos hua̠nti̠ tahui­lá̠­nalh nac a̠má mákat pu̠la­tama̠n anta­nícu tzu­cu­ma̠chá xakalh­tu̠­choko Jordán, antá nac Gali­lea anta­nícu lhu̠hua tahui­lá̠­nalh hua̠nti̠ ni̠ judíos; ");
INSERT INTO tocNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ma̠squi xlacán xala­ka­ca̠­pucsua xta­la­má̠­nalh pero nataucxilha aktum lanca tax­káket, y hua̠nti̠ chú aya xtaamá̠­nalh talak­tzanka̠y nac ca̠li̠ní̠n, nata­li̠­la­ca­hua̠nán lanca tax­káket. ");
INSERT INTO tocNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Hasta la̠ta antá tícha̠lh Jesús xlá tzú­culh akchu­hui̠nán y chiné xca̠­huaniy cris­tianos: —Calak­pa­lí̠tit xali̠xcáj­nit min­ta­la­ca­pa̠s­tac­nicán y chuná cala­ta­pá̠tit cumu la̠ Dios lacas­quín, porque chú aya tala­ca­tzu­hui̠ma quilh­ta­macú acxni̠ xlá nama̠­tzu­qui̠y xasa̠sti xta­péksi̠t nac ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Maktum quilh­ta­macú Jesús xquilh­tu̠t­la̠­huama xapu­punú Gali­lea acxni̠ ca̠úcxilhli cha̠tiy lac­chix­cu­huí̠n li̠na­ta̠lán, cha̠tum xuanicán Simón hua̠nti̠ aca­li̠stá̠n li̠ma̠­pa̠­cú­hui̠lh Pedro, y chi̠nchú cha̠tum xuanicán Andrés. Xlacán caj squi̠­ti̠­naní̠n xta­huani̠t y xta­ma­ju̠­má̠­nalh xtza̠lhcán nac chú­chut. ");
INSERT INTO tocNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Pero Jesús chiné ca̠huá­nilh: —Hui­xinín caqui­la̠s­ta̠­la­níhu porque chuná cumu lá saka­ju̠­nu­ná̠tit xla­cata nachi­pa­yá̠tit squi̠ti, aquit nac­ca̠­ma̠­si­yu­niyá̠n la̠nchú lácu naca̠­pu­tza­yá̠tit a̠ma̠ko̠lh cris­tianos hua̠nti̠ taaktzan­ka̠­ta­ma̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Acxni̠ chuná ca̠hua­ni­ko̠lh, a̠ma̠ko̠lh squi̠­ti̠­naní̠n taak­xtek­mi̠­ko̠lh xtza̠lhcán y ta­sta̠­lá­nilh. ");
INSERT INTO tocNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Caj li̠puntzú Jesús akchú tla̠­huampá y ca̠úcxilhli cha̠­tiy­li̠tum lac­chix­cu­huí̠n na̠ li̠na­ta̠lán, San­tiago y Juan xcamán Zebedeo. Xlacán antá xta­ta­ju̠­má̠­nalh nac aktum barco xta­la­ca­chi̠­má̠­nalh xtza̠lhcán; na̠ antá xta­ju̠ma ko̠lu­tzí̠n Zebedeo hua̠nti̠ xtla̠tcán. Jesús ca̠ta­sá­nilh y ca̠huá­nilh xla­cata pi̠ cata­sta̠­lá­nilh. ");
INSERT INTO tocNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Huata xlacán na̠ la̠li̠­huán taak­xte­kuíli̠lh xtza̠lhcán xa̠hua xtla̠tcán y ta­sta̠­lá­nilh Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús xca̠­la­ka­tza̠­lat­la̠­huán lactzu ca̠chi­qui̠ní̠n la̠ta xli̠­ca̠­lanca nac xapu̠­la­tama̠n Gali­lea, xca̠­ma̠­kalh­chu­hui̠ni̠y cris­tianos nac xpu̠­si­cu­lancán judíos anta­nícu xchá̠n, xlá xca̠­li̠­ta̠­chu­hui̠nán a̠má xasa̠sti xta­péksi̠t hua̠ntu̠ Dios xma̠­tzu­qui̠­putún nac ca̠quilh­ta­macú y na̠chuna li̠túm xca̠­ma̠t­la̠nti̠y ti̠pa̠­katzi tajátat hua̠ntu̠ xca̠­ka­lhi̠y a̠ma̠ko̠lh cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Xli̠­ca̠­lanca nac xapu̠­la­tama̠n Siria catzí̠­calh hua̠ntu̠ xtla­huama Jesús y lhu̠hua cris­tianos tzú­culh tali̠mín ta̠tat­laní̠n hua̠nti̠ catu̠huá xta­li̠­pa̠­ti̠­má̠­nalh ti̠pa̠­katzi tajátat, na̠ chuná catu̠hua̠ taca­tza­ná­juat, na̠chuná hua̠nti̠ xca̠­maka­tla­jani̠t xes­pí­ritu akska­huiní, y na̠ pacs hua̠nti̠ xca̠s­noka uú̠n, na̠chuná hua̠nti̠ xta­lac­lu̠n­tu̠­hua­nani̠t y ni̠lay xtat­la̠­huán. Pus Jesús hua̠k ca̠ma̠t­lá̠n­ti̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","La̠tachá nícu xán Jesús, lhu̠hua cris­tianos cani̠hua xalaní̠n xta­sta̠­laniy para xalac Gali­lea, Decá­polis, Jeru­salén, Judea y na̠ xa̠huá hua̠nti̠ xta­la­ma̠­nanchá hasta pekán nac kalh­tu̠­choko hua̠ntu̠ hua­nicán Jordán. ");
INSERT INTO tocNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Maktum quilh­ta­macú acxni̠ Jesús úcxilhli pi̠ luu lhu̠hua cris­tianos xta­sta̠­la­nini̠t, xlá la̠li̠­huán tala­ca̠c­xtu­táhui nac aktum lanca ke̠stí̠n, acxni̠ cha̠lh anta­nícu juerza ca̠xtum huata antá culucs táhui, y acxni̠ xdis­cí­pulos na̠ quilh­pu̠xtum tata̠­ta­hui­lachá, ");
INSERT INTO tocNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","xlá tzú­culh ca̠ma̠­kalh­chu­hui̠ni̠y, y chiné ca̠huá­nilh: ");
INSERT INTO tocNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Luu li̠pa̠­xúhu cali̠­pu̠lh­cá̠­calh hua̠nti̠ taca­tzi̠y pi̠ xli̠­ca̠na huí pu̠lactum hua̠ntu̠ ca̠tzan­ka̠niy y luu tamac­la­cas­quín, pus hua̠nti̠ chuná kalhi̠y xta­la­ca­pa̠s­tacni xli̠­ca̠na pi̠ huá nata­maka­maklhti̠nán hua̠ntu̠ Dios ca̠ma̠x­qui̠­putún xca­maná̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Luu ca̠na̠ lac­li̠­pa̠­xúhu caca̠­li̠­pu̠lh­cá̠­calh hua̠nti̠ la̠nchú tali̠­pu­huax­ni̠­má̠­nalh y tata­sa­má̠­nalh, porque namín quilh­ta­macú acxni̠ Dios naca̠­ma̠­ko­xu­mixiy. ");
INSERT INTO tocNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Luu lac­li̠­pa̠­xúhu caca̠­li̠­pu̠lh­cá̠­calh hua̠nti̠ nac xna­cujcán ni̠ lac­lu̠cu ca̠maklh­ca­tzi̠cán, porque hua­tuní̠n xlacán nata­mak­lhti̠nán a̠má pu̠la­tama̠n hua̠ntu̠ Dios ca̠ma̠x­qui̠­putún xca­maná̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Luu ca̠na̠ lac­li̠­pa̠­xúhu caca̠­li̠­pu̠lh­cá̠­calh hua̠nti̠ la̠nchú xli̠­hua̠k xna­cujcán talac­pu­tza­má̠­nalh la̠ta lácu luu aksti̠tum nata­la­tama̠y, porque xli̠­ca̠na pi̠ huá Dios amaj ca̠ma̠x­qui̠y hua̠ntu̠ xlacán tapu­tzay. ");
INSERT INTO tocNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Luu xli̠­ca̠na lac­li̠­pa̠­xúhu caca̠­li̠­pu̠lh­cá̠­calh hua̠nti̠ tala­ka­lhamán xa̠maka­pi­tzí̠n xta̠­cris­tianoscán, porque Dios na̠chuná naca̠­la­ka­lhamán. ");
INSERT INTO tocNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Luu ca̠na̠ lac­li̠­pa̠­xúhu caca̠­li̠­pu̠lh­cá̠­calh hua̠nti̠ ni̠ caj tali̠­huán sinoque xli̠­hua̠k xli̠t­li­hueke taca­tzi̠­putún lácu lacas­quín Dios cala­tá­ma̠lh la̠qui̠ luu aksti̠tum nata­la­tama̠y, porque hua­tuní̠n u̠ma̠ko̠lh cris­tianos nataucxi­lha̠chá nac akapú̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Luu ca̠na̠ lac­li̠­pa̠­xúhu hua̠nti̠ tali̠­taaka­tzan­ke̠­má̠­nalh y tali̠s­cuj­má̠­nalh xla­cata pi̠ anka­lhi̠ná caánalh tacác­suat nac xlak­sti̠­pa̠ncán xli̠­hua̠k cris­tianos y ni̠ caj cata­la̠­ma­ka­sí̠­tzi̠lh, y chuná xlá Dios naca̠­li̠­ma̠xtuy cumu la̠ xli̠­ca̠na xca­maná̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Na̠chuná luu ca̠na̠ lac­li̠­pa̠­xúhu caca̠­li̠­pu̠lh­cá̠­calh a̠ma̠ko̠lh cris­tianos hua̠nti̠ ca̠li̠­pu­tza­sta̠­la­má̠­calh y ca̠si̠­tzi̠­ni­má̠­calh caj xpa̠­la­cata pi̠ tat­la­hua­putún hua̠ntu̠ tla̠n xta­scújut Dios porque xli̠­ca̠na pi̠ huá u̠ma̠ko̠lh hua̠nti̠ nata­maka­maklhti̠nán hua̠ntu̠ Dios kalhi̠y nac xta­péksi̠t nac akapú̠n xla­cata nata­ta̠­li̠­pa̠­xu­huay. ");
INSERT INTO tocNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Y na̠chuná luu lac­li̠­pa̠­xúhu caca̠­li̠­pu̠lh­ca̠­cántit hui­xinín acxni̠ caj quim­pa̠­la­cata li̠xcáj­nit tachu­huí̠n naca̠­hua­ni­ca­ná̠tit, naca̠­pu­tza­sta̠­la­ca­ná̠tit, naca̠­ma̠x­tu­ni­ca­ná̠tit ta̠k­saní̠n hua̠ntu̠ hui­xinín naca̠­li̠­ya̠­hua­ca­ná̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Pus a̠má quilh­ta­macú hui­xinín cali̠­pa̠­xu­huátit hua̠ntu̠ ca̠ok­spu­lamá̠n y ni̠ caj cali̠­li̠­pu­huántit, porque luu lhu̠hua hua̠ntu̠ naca̠­li̠­ma̠s­ka­hui̠­ca­ná̠tit nac akapú̠n, xa̠huachí na̠ cala­ca­pa̠s­táctit pi̠ na̠chuná ca̠t­la­hua­cani̠t a̠ma̠ko̠lh pro­fetas hua̠nti̠ Dios tica̠­ma­cá­milh xamaká̠n quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Pus cumu la̠ hui­xinín catzi̠­yá̠tit pi̠ mátzat luu xli̠­ca̠na li̠ma­cuán porque li̠ma̠s­ko­ke̠­nancán, pus chú hui­xinín cca̠­li̠­ma̠x­tuyá̠n cumu la̠ mátzat nac xlak­sti̠­pa̠ncán cris­tianos hua̠nti̠ nama̠s­ko­ke̠­yá̠tit la̠qui̠ ni̠ nata­lak­tzanka̠y. Pero para huá mátzat naani̠­niko̠y xli̠s­koko, ¿lácu chú lac­pu­hua­ná̠tit pi̠ tla̠n cahuá nali̠­ma̠s­ko­ke̠­nancán? Xli̠­ca̠na pi̠ niaj tu̠ li̠ma­cuán huata mejor caj namakan­cán nac quilhtí̠n la̠qui̠ cati̠hua cris­tianos nata­lac­ta̠­yami̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Y na̠chuna li̠túm hui­xinín nac xlak­sti̠­pa̠ncán cris­tianos li̠tax­tu­yá̠tit cumu la̠ tax­káket hua̠ntu̠ naca̠­mak­skoniy nac ca̠quilh­ta­macú. Pus aktum ca̠chi­quí̠n hua̠ntu̠ hui­lachá nac xok­spú̠n lanca ke̠stí̠n xli̠­ca̠na pi̠ ni̠lay tahuilay para ni̠ juerza naucxilhcán. ");
INSERT INTO tocNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Na̠ luu xta̠­chuná qui̠­taxtuy cumu la̠ nac aktum chiqui, ne̠c­xnicú ma̠pa­si̠cán aktum li̠maksko la̠qui̠ chú naliakpu­lon­kxuili̠cán aktum cajón, huata acxni̠ ma̠pa­si̠cán li̠maksko ta̠lhmá̠n hui­li̠cán la̠qui̠ xli̠­hua̠k hua̠nti̠ tahui­lá̠­nalh nac a̠má chiqui nata­li̠­la­ca­hua̠nán a̠má tax­káket. ");
INSERT INTO tocNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Pus na̠chuná chú hui­xinín cali̠­ma̠­si­yútit mila­ta­ma̠tcán pi̠ xli̠­ca̠na anka­lhi̠ná pasama mili̠­maks­kocán nac xlak­sti̠­pa̠ncán cris­tianos la̠qui̠ acxni̠ xlacán nataucxilha hua̠ntu̠ hui­xinín lacuán min­tas­cu­jutcán tla­hua­pá̠tit pus chuná nata­li̠­la­ka­chix­cu­hui̠y Quin­tla̠­ticán hua̠nti̠ hui­lachá nac akapú̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Xa̠huachí hui­xinín ni̠ calac­pu­huántit para aquit cmini̠t lac­tla­huay hua̠ntu̠ timák­xtekli xli̠­ma̠­peksí̠n Moisés xa̠huá hua̠ntu̠ tita­qui̠­ma̠­si­yuchi xalak­maká̠n pro­fetas; aquit ni̠tu̠ caj cmini̠t lac­tla­huay, huata caj cmini̠t ma̠la­ca­pu̠­tun­cu­hui̠y hua̠ntu̠ luu hua­ni­putún. ");
INSERT INTO tocNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Porque aquit xli̠­ca̠na cca̠­hua­niyá̠n pi̠ li̠huán la̠nchú tla̠ncú lamaj nahuán ca̠quilh­ta­macú xa̠huá akapú̠n, ni̠para cha̠tum cris­tiano anán hua̠nti̠ tla̠n nama̠­ta­ke̠­nu̠niy ca̠na̠ caj aktum letra osuchí aktum punto hua̠ntu̠ maká̠n tatzok­ta­hui­lani̠t xli̠­ma̠­peksí̠n Dios nac li̠kalh­ta­huaka sinoque hasta caní nakan­tax­tuko̠y hua̠ntu̠ antá huan pi̠ xli̠­kan­táxtut. ");
INSERT INTO tocNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Huá xpa̠­la­cata cca̠­li̠­hua­niyá̠n pi̠ hua̠nti̠ kalha­kax­mat­makán y ni̠ ma̠kan­tax­ti̠­putún nac xla­táma̠t la̠tachá túcuya̠ li̠ma̠­peksí̠n hua̠ntu̠ tatzok­ta­hui­lani̠t nac xli̠­má­peksí̠n Dios ma̠squi la̠m­para ni̠tu̠cu xkásat la̠ta hua̠ntu̠ xlá li̠ma̠­pek­si̠nán, y para xlá ni̠ naca̠­li̠­taaka­tzanke̠y xa̠maka­pi­tzí̠n xla­cata nata­ma̠­kan­taxti̠y, pus xli̠­ca̠na pi̠ na̠chuná ni̠tu̠cu xkásat cati­li̠­tax­tuchá nac xta­péksi̠t Dios. Pero hua̠nti̠ kalha­kax­mata y ma̠kan­taxti̠y nac xla­táma̠t hua̠ntu̠ tatzokni̠t nac xli̠­ma̠­peksí̠n Dios y na̠chuná ca̠li̠­taaka­tzanke̠y xa̠maka­pi­tzí̠n cris­tianos, ca̠ma̠­si­yuniy la̠qui̠ xlacán na̠ nata­ma̠­kan­taxti̠y, pus xli̠­ca̠na pi̠ u̠má chixcú luu tali̠­pa̠hu nali̠­ma̠x­tu­ca­ná̠chá nac xta­péksi̠t Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Porque aquit xli̠­ca̠na cca̠­hua­niyá̠n para hui­xinín na̠ ni̠ nama̠­kan­tax­ti̠­yá̠tit xli̠­ma̠­peksí̠n Dios y na̠ caj chuná nat­la­hua­yá̠tit cumu la̠ tat­la­huay xma̠­kalh­ta­hua­ke̠­nacán judíos xa̠huá fariseos, pus na̠ ni̠para hui­xinín ni̠lay cati­ta­pek­sí̠tit nac a̠má xasa̠sti xta­péksi̠t Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Hui­xinín sta­lanca catzi̠­yá̠tit la̠ta lácu huan a̠má li̠ma̠­peksí̠n hua̠ntu̠ maká̠n tica̠­ma̠x­qui̠­cántit, chiné huán: “Ni̠ camakni min­ta̠­cris­tiano, porque hua̠nti̠ mak­ni̠nán xli̠­ca̠na pi̠ amaj lak­tzanka̠y nac xla­catí̠n Dios.” ");
INSERT INTO tocNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero chú aquit camá̠n ca̠hua­niyá̠n hua̠ntu̠ a̠tzinú tlak xatlá̠n tachu­huí̠n, pi̠ hua̠nti̠ ma̠squi caj nasi̠­tzi̠niy xta̠­cris­tiano y ni̠ nata̠­pa̠ti̠y xlá na̠ luu mini̠niy nalak­tzanka̠y nac xla­catí̠n Dios. Y na̠chuná hua̠nti̠ cala̠huá naak­tla­ka­xa­katli̠y y nali̠­quilh­pa̠­taxtuy xta̠­cris­tiano, tamá chixcú mini̠niy cama̠­la­ca­pú̠­calh nac xla­ca­ti̠ncán ma̠pek­si̠­naní̠n la̠qui̠ antá nama̠­ka­lha­pa­li̠cán xpa̠­la­cata hua̠ntu̠ hua­nini̠t. Pero aquit cca̠­hua­niyá̠n pi̠ hua̠nti̠ ni̠tu̠ liucxilha cha̠tum xta̠­cris­tiano y xa̠hua chí nahuaniy pi̠ xlá tantum tas­nokxtu, tamá cris­tiano luu mini̠niy pi̠ na̠ naán pa̠ti̠nán nac ca̠lh­cu­ya̠tni anta­nícu ca̠x­tla­huani̠t Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Pus huá xpa̠­la­cata cca̠­li̠­hua­niyá̠n para huix li̠pímpa̠t mili̠­la­ka­chix­cu­huí̠n nac pu̠si­culan, y acxni̠ chú luu pímpa̠t laka­chix­cu­hui̠ya Dios, xamaktum nala­ca­pa̠s­taca pi̠ huí cha̠tum min­ta̠­cris­tiano hua̠nti̠ tzinú ta̠la̠­ma­ka­si̠­tzi̠­ni̠ta, ");
INSERT INTO tocNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","pus huata mejor antá cahui­li̠­ke̠ya mili̠­la­ka­chix­cu­huí̠n nac xpa̠xtú̠n altar antaní laka­chix­cu­hui̠­nancán, y la̠li̠­huán capit ta̠la̠­ma̠­ko­xu­mi­xiya a̠má min­ta̠­cris­tiano, y aca­li̠stá̠n chú capim­para nac pu̠si­culan y chú xli̠­hua̠k min­ta­la­ca­pa̠s­tacni cala­ka­chix­cuhui Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Na̠chu­na­li̠túm para cha̠tum min­ta̠­cris­tiano catzi̠ya pi̠ si̠tzi̠­niyá̠n y catzi̠ya pi̠ amá̠n ma̠la­ca­pu̠yá̠n nac xla­catí̠n ma̠pek­si̠­naní̠n, huata mejor laca­ti̠tum cata̠­la­ca̠xla li̠huán ni̠tu̠ a̠ ma̠la­ca­pu̠yá̠n, la̠qui̠ chuná ni̠ nama­ca­ma̠s­ta̠yá̠n nac xla­ca­ti̠ncán poli­cías y chú xlacán nata­ta­mac­nu̠yá̠n nac pu̠la̠­chi̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Y para antá nama̠­nu̠­cana, aquit laca­tancs cuaniyá̠n pi̠ ni̠ cati­ta­mac­xtú­canti hasta caní juerza naxo­ko­ko̠ya mimu̠lhta hua̠ntu̠ antá nas­qui­ni­cana. ");
INSERT INTO tocNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Hui­xinín catzi̠­yá̠tit lácu huan a̠má li̠ma̠­peksí̠n hua̠ntu̠ tica̠­ma̠x­quí̠­calh xalak­maká̠n mili̠­ta­la­ka­pas­nicán, chiné huán: “Ni̠ caxa­katli tunuj pusca̠t para huí mim­pusca̠t.” ");
INSERT INTO tocNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero chú aquit cca̠­hua­niyá̠n pi̠ hua̠nti̠ ma̠squi caj naucxilha cha̠tum pusca̠t y xlá nalac­pu­huán pi̠ tuncán xlá xtlá­hualh, pus tamá chixcú aya tla­huani̠t tala̠­ka­lhí̠n nac xnacú, porque luu xta̠­chuná qui̠­taxtuy cumu la̠ a̠ caxa­kát­li̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Pus na̠ huá xpa̠­la­cata cca̠­li̠­hua­niyá̠n pi̠ para huá xalac mim­pek­stácat mila­kas­tapu ma̠t­la­hui̠­pu­tuná̠n tala̠­ka­lhí̠n, huata mejor tuncán cala­ca­ma̠x­tú­canti y mákat camaca­pi; porque xali̠­huaca tla̠n para caj pu̠lactum nama̠­lak­tzan­ke̠ya xalac mimacni y ni̠ mili̠­lanca nata­mac­pu̠­cana nac pu̠pa̠tí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Chu­na­li̠túm para huá mimaca­stácat juerza ma̠t­la­hui̠yá̠n tala̠­ka­lhí̠n, mejor cachu­cúacti y mákat camaca­pi; porque xali̠­huaca tla̠n caj pu̠lactum xalac mimacni nama̠­lak­tzan­ke̠ya y ni̠ mili̠­lanca cati­ta­mac­pú̠­canti nac pu̠pa̠tí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Na̠chu­na­li̠tum ma̠x na̠ catzi̠­yá̠tit la̠ta lácu huán nac pu̠lactum li̠ma̠­peksí̠n hua̠ntu̠ xamaká̠n tica̠­mak­xtek­ni­cántit, chiné huan: “Para cha̠tum chixcú mak­xtek­putún xpusca̠t, pus huata luu xla­ca­squinca pi̠ nama̠x­qui̠y mactum cáp­snat li̠huana̠ xala­ca̠xlán hua̠ntu̠ naca̠t­la­hua­nicán nac pu̠chu­huí̠n, la̠qui̠ antá nahuán nac cáp­snat pi̠ maktum nata­la̠­mak­xteka.” ");
INSERT INTO tocNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero huata chú aquit cca̠­hua­niyá̠n aktum tachu­huí̠n hua̠ntu̠ luu a̠tzinú xatancs: para cha̠tum chixcú namak­xteka xpusca̠t ma̠squi xla̠ ni̠tu̠ tla­huani̠t hua̠ntu̠ ni̠tlá̠n para xakat­li̠ni̠t a̠tunuj chixcú, pus huata xlá caj amaj ma̠t­la­hui̠y tala̠­ka­lhí̠n para napu­tza­paray hua̠nti̠ nata̠­ta­hui­la­paray, y na̠chuná a̠má chixcú hua̠nti̠ nata̠­ta­huilay a̠má pusca̠t hua̠nti̠ mak­xtek­cani̠t na̠chuná lhu̠hua tala̠­ka­lhí̠n tla­huay nac xla­catí̠n Dios porque xlá maktum pi̠ lac­tla­huako̠y a̠má tamaka­xtókot. ");
INSERT INTO tocNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Xa̠huachí aya catzi̠­yá̠tit lácu huán a̠má li̠ma̠­peksí̠n hua̠ntu̠ xamaká̠n quilh­ta­macú tica̠­ma̠x­qui̠­cántit: “Juerza cama̠­kán­taxti a̠má min­ta­chu­huí̠n hua̠ntu̠ li̠ma̠­lac­nu̠ya nac xta­cu­huiní Mim­pu̠­chiná MiDios xla­cata nat­la­huaya.” ");
INSERT INTO tocNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero huata aquit laca­tancs cca̠­hua­niyá̠n: Ne̠c­xnicú tu̠ cali̠­ta̠­yátit nat­la­hua­yá̠tit y huá nali̠­quilh­pi­ná̠tit para la̠ta túcu. Ne̠c­xnicú cali̠­quilh­pítit akapú̠n para túcu nali̠­ta̠­ya­yá̠tit porque luu xta̠­chuná qui̠­taxtuy cumu la̠m­para huá Dios li̠quilh­pim­pá̠tit, porque antá nac akapú̠n hui­lachá xpu̠­ma̠­peksí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Y na̠ ni̠para ca̠ti­yatni cali̠­quilh­pítit xla­cata para túcu nama̠­lac­nu̠ya, porque antá uú nac ca̠ti­yatni li̠ma̠xtuy Dios cumu la̠ anta­nícu ma̠jaxay xtantú̠n. Na̠ ni̠para huá a̠má lanca xaca̠­chi­quí̠n Jeru­salén cali̠­quilh­pítit para túcu nama̠­lac­nu̠­yá̠tit porque antá nac eé ca̠chi­quí̠n huí xpu̠­ma̠­peksí̠n Dios nac ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ni̠para huá cali̠­quilhpi miakxa̠ka para túcu nama̠­lac­nu̠ya porque ni̠ huix ma̠pek­si̠ya, y xa̠hua chí huix ni̠lay lak­pa­li̠­niya la̠ta xli̠­tzi­tzeke kantum min­chíxit para sna­papa nat­la­huaya. ");
INSERT INTO tocNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Pus acxni̠ para túcu nali̠­kalh­ti̠­nana pi̠ nat­la­huaya caj xma̠n cahuanti: “Tla̠n nactlahuay”, osuchi laca­tancs catzi̠ya pi̠ ni̠lay cati­ma̠­kán­taxti huata caj xma̠n cahuanti: “Ni̠ ctitláhualh”. Porque la̠tachá tícu luu li̠huana̠ ma̠ca­tzi̠­ni̠­nam­putún pi̠ nama̠­kan­taxti̠y pus hasta huá chú li̠ma̠­lacnu̠y li̠qui­lhán hua̠ntu̠ xlá li̠pa̠­huán, pus antá chú ca̠maka­tla­jayá̠n xali̠xcáj­nit tala­ca­pa̠s­tacni. ");
INSERT INTO tocNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Hui­xinín na̠ catzi̠­yá̠tit lácu huam­paray a̠má pu̠lactum li̠ma̠­peksí̠n hua̠ntu̠ xamaká̠n quilh­ta­macú tica̠­mak­xtek­ni­cántit: “Para tícu nata̠­la̠­hui­li̠niy xta̠­cris­tiano y nama̠x­tuniy xla­kas­tapu, osuchi nama̠c­ti̠­niko̠y xta­tzán, pus na̠ luu chuná cat­la­huá­calh cumu la̠ xlá ma̠ta­ka̠­hui̠­nani̠t la̠qui̠ nama­ka­xo­kocán.” ");
INSERT INTO tocNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero chú aquit laca­tancs cca̠­hua­niyá̠n: Ni̠ cata̠­la̠­la­ca­ta­hua­cátit cha̠tum chixcú hua̠nti̠ li̠xcáj­nit li̠ca­tzi̠y. Hua̠nti̠ nala­ka­ka­xiyá̠n nac milak­xtí̠n huata mejor calak­xti̠­pi­ni­para a̠lak­xti̠tu calak­xti̠­ka­xi­parán para luu chuná lac­pu­huán. ");
INSERT INTO tocNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Para caj luu chuná catzi̠y nama̠­la­ca­pu̠yá̠n y chú namak­chi­pa­pu­tuná̠n min­ta­maknu, pus huix ni̠ juerza casa­ká­maklhti, huata mejor na̠ cama̠xqui tala­cas­quín xla­cata na̠ nalé̠n min­cha­marra. ");
INSERT INTO tocNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Para tícu xafuerza nama̠­cu­qui̠yá̠n xla­cata cali̠­pini xta­cuca ca̠na̠ caj aktum kiló­metro xli̠­la­ka­mákat, huata huix cama̠­li̠­hua­qui̠ni tlak cat­la­huani li̠tlá̠n y cali̠­pini ca̠na̠ caj aktiy kiló­metro. ");
INSERT INTO tocNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","La̠tachá tícu nas­qui­niyá̠n hua̠ntu̠ mac­la­cas­quima cama̠xqui, y ne̠c­xnicú caj cakax­patni hua̠nti̠ mac­la­cas­quimá̠n y hua̠nti̠ mak­sa̠­cuanam­pu­tuná̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Hui­xinín na̠ laka­pa­sá̠tit ehe li̠ma̠­peksí̠n hua̠ntu̠ maká̠n quilh­ta­macú tica̠­ma̠x­qui̠­cántit hua̠ntu̠ chiné huán: “Capa̠xqui miamigo hua̠nti̠ pa̠x­qui̠yá̠n, y chi̠nchú hua̠nti̠ si̠tzi̠­niyá̠n na̠ casi̠­tzi̠ni.” ");
INSERT INTO tocNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero chú aquit laca­tancs cca̠­hua­niyá̠n pi̠ caca̠­pa̠x­quí̠tit hua̠nti̠ ca̠si̠­tzi̠­niyá̠n y cakalh­ta­hua­ka­nítit Dios xpa̠­la­cata hua̠nti̠ ni̠ ca̠ucxilh­pu­tuná̠n xla­cata xlá camak­tá̠­yalh. ");
INSERT INTO tocNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Para xli̠­ca̠na chuná nat­la­hua­yá̠tit pus Quin­tla̠­ticán Dios hua̠nti̠ hui­lachá nac akapú̠n xlá naca̠­li̠­pu̠lh­ca̠yá̠n cumu la̠ xli̠­ca̠na xca­maná̠n. Porque xlá hua̠k acxtum tla̠n ca̠ca­tzi̠niy cris­tianos y li̠pu̠tum ca̠ma̠x­qui̠y xtax­káket chi­chiní hasta ma̠squi huá a̠ma̠ko̠lh lac­chix­cu­huí̠n hua̠nti̠ lac­li̠xcáj­nit xta­pu­hua̠ncán, na̠ xa̠hua hua̠nti̠ lacuán xta­pu­hua̠ncán cris­tianos, y na̠ huá macamín si̠n nac xok­spu̠ncán hua̠nti̠ lac­li̠xcáj­nit tali̠­ca­tzi̠y lac­chix­cu­huí̠n xa̠hua hua̠nti̠ lacuán xta­pu­hua̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Pero para hui­xinín caj xma̠nhuá ca̠pa̠x­qui̠­yá̠tit hua̠nti̠ na̠ ca̠pa̠x­qui̠yá̠n, pus ¿túcu chú ya̠ tas­káhu namak­lhti̠­na­ná̠tit nac xla­catí̠n Dios caj xpa̠­la­cata cumu chuná nat­la­hua­yá̠tit? Porque hasta ma̠squi hua̠nti̠ lac­li̠xcáj­nit xta­pu­hua̠ncán na̠chuná xlacán tala̠­ta̠lay. ");
INSERT INTO tocNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Y na̠chuna li̠túm para caj xma̠n huá li̠pa̠­xúhu ca̠xa­kat­li̠­yá̠tit hua̠nti̠ catzi̠­yá̠tit na̠ ca̠pa̠x­qui̠yá̠n, ¿túcu chú xli̠tlá̠n tla­hua­pá̠tit la̠qui̠ naca̠­ma̠s­ka­hui̠­ca­ná̠tit nac xla­catí̠n Dios? Porque hasta ma̠squi a̠ma̠ko̠lh lac­chix­cu­huí̠n hua̠nti̠ ni̠ tala­ka­pasa Dios na̠chuná tat­la­huay. ");
INSERT INTO tocNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pus huata mejor luu xli̠­ca̠na hui­xinín tla̠n caka­lhí̠tit min­ta­la­ca­ca­pa̠s­tac­nicán chuná cumu la̠ Quin­tla̠­ticán hua̠nti̠ hui­lachá nac akapú̠n luu xli̠­ca̠na xlá aksti̠tum kalhi̠y xta­la­ca­pa̠s­tacni. ");
INSERT INTO tocNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Luu xli̠­ca̠na cuentaj cat­la­huátit, ni̠tu̠ tilak­tzak­sa­yá̠tit min­ta­la­ka­lha­ma­ni̠ncán nac xla­ca­ti̠ncán xli̠­lhu̠hua lac­chix­cu­huí̠n caj la̠qui̠ chuná hui­xinín luu lacuán cris­tianos naca̠­li̠­pu̠lh­ca̠­ca­ná̠tit caj xpa̠­la­cata hua̠ntu̠ tla­hua­yá̠tit. Porque para chuná nat­la­hua­yá̠tit, a̠má Min­tla̠­ticán hua̠nti̠ hui­lachá nac akapú̠n, cumu xlá hua̠k laka­pasa min­ta­la­ca­pa̠s­tac­nicán pus ni̠ cati­ca̠­ma̠x­quí̠n min­tas­kahucán. ");
INSERT INTO tocNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","’Por eso acxni̠ huix naca̠­mak­ta̠­yaya a̠ma̠ko̠lh cris­tianos hua̠nti̠ xli̠­ca̠na tamac­la­cas­quix­ni̠má̠n pus ni̠ caca̠­li̠­ta̠­chu­huí̠­nanti xli̠­hua̠k cris­tianos cumu la̠ tat­la­huay hua̠nti̠ caj luu tala­kati̠y taaksa­ni̠nán y antá xlacán tzucuy tali̠­chu­hui̠nán nac mim­pu̠­si­cu­lancán la̠qui̠ hui­xinín nali̠­ma­ca­pi­ná̠tit luu tla̠n chixcú osuchi nac ca̠ti­ji̠ní̠n. Huá chuná xlacán tali̠t­la­huay la̠qui̠ cris­tianos nata­li̠­macá̠n cumu la̠ lacuán cris­tianos, pero chú aquit laca­tancs cca̠­hua­niyá̠n pi̠ caj huá xpa̠­la­cata hua̠ntu̠ xlacán tat­la­huay pus chuná chú aya tamac­lani̠t hua̠ntu̠ luu xta­pu­tza­má̠­nalh xla­cata naca̠c­ni̠­na­nicán, pero pacsá ca̠ma̠s­ka­hui­cani̠t nahuán. ");
INSERT INTO tocNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pus huata acxni̠ huix naca̠­mak­ta̠­yaya hua̠nti̠ xli̠­ca̠na luu tamac­la­cas­qui­má̠­nalh pus ni̠para cali̠­ta̠­chu­huí̠­nanti hasta ma̠squi hua̠nti̠ luu a̠tzinú tali̠­pa̠hu miamigo, ");
INSERT INTO tocNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","huata caj xma̠n huix me̠cstu cali̠­catzi hua̠ntu̠ tla̠n laka­tze̠k tla­hua­ni̠ta. Pero Quin­tla̠­ticán hua̠nti̠ hui­lachá nac akapú̠n xlá ucxilhmá̠n y hua̠k catzi̠y hua̠ntu̠ xaya̠ laka­tze̠k tla­huápa̠t pus huata xlá luu lhu̠hua nama̠x­qui̠yá̠n hua̠ntu̠ nali̠­xo­ko̠­nu­niyá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Y na̠chuna li̠túm acxni̠ hui­xinín nakalh­ta­hua­ka­ni­yá̠tit Dios ni̠ chuná cat­la­huátit cumu la̠ tat­la­huay hua̠nti̠ caj taak­ska­hui­mi̠nán. Xlacán tala­kati̠y takalh­ta­hua­ka­ta̠yay nac mim­pu̠­si­cu­lancán xa̠hua nac xca̠­cha̠s­tu̠ní̠n tiji anta­nícu luu lhu̠hua tza­macán la̠qui̠ a̠ma̠ko̠lh cris­tianos mat nataucxilha hua̠ntu̠ xlá tla­huama. Huata aquit xli̠­ca̠na laca­tancs cca̠­hua­niyá̠n pi̠ caj xpa̠­la­cata hua̠ntu̠ xlacán tat­la­huay pus chuná chú aya tamac­lani̠t hua̠ntu̠ xta­pu­tza­má̠­nalh xla­cata pi̠ naca̠­ca̠c­ni̠­na­nicán, y aya ca̠ma̠s­ka­hui­cani̠t nahuán porque niaj tu̠ cati­ta­maka­maklhtí̠­nalh nac xla­catí̠n Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pero acxni̠ huix nakalh­ta­hua­ka­niya Dios huata mejor me̠cstu catanu nac mín­chic, li̠huana̠ cama̠­lac­chuhua mimá̠­lacchi, y antá chú cakalh­ta­hua­kani Quin­tla̠­ticán Dios porque antá xlá lac­xtum ta̠huilán ma̠squi ni̠ tasiyuy. Y cumu Quin­tla̠­ticán ucxilhma pi̠ tla̠n hua̠ntu̠ huix tla­huápa̠t, pus luu xli̠­ca̠na pi̠ huá nama̠x­qui̠yá̠n min­tas­kahu hua̠ntu̠ lak­cha̠ná̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Pero acxni chú nakalh­ta­hua­ka­niya Dios ni̠ pi̠hua pi̠huá cahuanti min­ta­chu­huí̠n hua̠ntu̠ ni̠ li̠ma­cuán chuná cumu lá tat­la­huay hua̠nti̠ ni̠ tala­ka­pasa Dios y xlacán talac­pu­huán pi̠ Dios naca̠­kax­matniy porque luu lhu̠hua hua̠ntu̠ taqui­lhuamá̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Pus hui­xinín ni̠ chuná cali̠­ca­tzí̠tit cumu la̠ xlacán, porque Quin­tla̠­ticán xlá aya catzi̠y hua̠ntu̠ hui­xinín mac­la­cas­quim­pá̠tit ma̠squi nia̠ squi­ni­yá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Acxni̠ hui­xinín nakalh­ta­hua­ka­ni­yá̠tit Dios mejor chiné nahua­ni­yá̠tit: Huix Quin­tla̠­ticán Dios hua̠nti̠ hui­lapi nac akapú̠n, caj xma̠n huix mini̠­niyá̠n nac­ca̠­la­ka­chix­cu­hui̠­niyá̠n min­ta­cu­huiní. ");
INSERT INTO tocNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Camilh mili̠­ma̠­peksí̠n uú nac qui­lak­sti̠­pa̠ncán. Hua̠k cakan­táx­tulh hua̠ntu̠ min­ta­pa̠­xu­huá̠n uú nac ca̠quilh­ta­macú, chuná cumu la̠ kan­tax­tu­ma̠chá nac akapú̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Hua̠ntu̠ la̠nchú cmac­la­cas­qui­ma̠­náhu quin­ta­huajcán caqui­la̠­ma̠x­quí̠hu. ");
INSERT INTO tocNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Caqui­la̠­ma̠­tzan­ke̠­na­níhu xli̠­hua̠k hua̠ntu̠ ni̠tlá̠n cca̠t­la­hua­ni­ni̠tán, na̠chuná cumu la̠ aquinín cma̠­tzan­ke̠­na­ni­yá̠hu hua̠nti̠ quin­ca̠­ta̠­ra̠t­la­hua­ni̠tán. ");
INSERT INTO tocNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ni̠ caqui­la̠­mak­xtekui xla­cata naquin­ca̠­tzak­sayá̠n akska­huiní, huata mejor caqui­la̠­ma̠­ta­pa̠­nu̠­níhu xli̠­hua̠k hua̠ntu̠ xquin­ca̠­ma̠t­la­huí̠n tala̠­ka­lhí̠n. Porque hua̠k milá lanca li̠ma̠­peksí̠n, xa̠huá xli̠­hua̠k li̠t­li­hueke, na̠ chuná hua̠ntu̠ xli̠­lanca mili̠­cá̠cni̠t xli̠anka­lhi̠ná quilh­ta­macú cane̠c­xni­cahuá. ");
INSERT INTO tocNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Pus para hui­xinín nama̠­tzan­ke̠­na­ni­yá̠tit xa̠maka­pi­tzí̠n min­ta̠­cris­tianoscán hua̠nti̠ xca̠­ta̠­ra̠t­la­hua­ni̠tán, na̠chuná Quin­tla̠­ticán hua̠nti̠ hui­lachá nac akapú̠n na̠ naca̠­ma̠­tzan­ke̠­na­niyá̠n xli̠­hua̠k hua̠ntu̠ ni̠tlá̠n tla­hua­ni̠­tátit. ");
INSERT INTO tocNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero para hui­xinín ni̠ nama̠­tzan­ke̠­na­ni­yá̠tit xa̠maka­pi­tzí̠n min­ta̠c­ris­tianujcán hua̠ntu̠ ni̠tlá̠n ca̠t­la­hua­ni­ni̠tán, pus na̠ chuná Quin­tla̠­ticán hua̠nti̠ hui­lachá nac akapú̠n ni̠ cati­ca̠­ma̠­tzan­ke̠­nanín min­ta­la̠­ka­lhi̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Acxni̠ hui­xinín nakalh­xtek­ni­ná̠tit xla­cata nala­ka­chix­cu­hui̠­yá̠tit Dios, pus ni̠ cali̠­ma̠­si­yútit cumu la̠m­para luu laca­li̠­pu­huam­pá̠tit caj nac mila­cancán chuná cumu la̠ tat­la­huay hua̠nti̠ caj taak­ska­hui­mi̠nán. Huá chuná xlacán tali̠t­la­huay la̠qui̠ xli̠­hua̠k cris­tianos nata­ca­tzi̠y pi̠ mat takalh­xtek­ni­má̠­nalh. Aquit xli̠­ca̠na cca̠­hua­niyá̠n pi̠ caj xpa̠­la­cata hua̠ntu̠ xlacán tat­la­huay nac xla­ca­ti̠ncán cris­tianos pus aya tamaka­maklhti̠­nani̠t xtas­kahucán hua̠ntu̠ xta­pu­tza­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pero acxni̠ huix nakalh­xtek­nina xla­cata nala­ka­chix­cu­hui̠ya Dios, li̠huana̠ cala­ka­chá­kanti y catác­xquitti ");
INSERT INTO tocNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","la̠qui̠ xli̠­lhu̠hua cris­tianos ni̠ nata­ca­tzi̠y para huix kalh­xtek­nímpa̠t. Huata caj xma̠n huá Quin­tla̠­ticán hua̠nti̠ hua̠k catzi̠y hua̠ntu̠ huix tla­huápa̠t, y cumu xlá acxtum ta̠lamá̠n pus nama̠x­qui̠yá̠n min­tas­kahu hua̠ntu̠ lak­cha̠ná̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Ni̠ ca̠ta catu̠huá cama̠ak­sto­kuilí̠tit hua̠ntu̠ xta­palh tumi̠n hua̠ntu̠ anán uú nac ca̠quilh­ta­macú, porque antá uú catu̠huá hua̠k ma̠lak­sputuy xalu̠hua y hua̠k lak­tzan­ka̠ko̠y, xa̠huachí uú tzamay kalha̠­naní̠n hua̠nti̠ tla̠n nata­ka­lhán. ");
INSERT INTO tocNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Huata mejor luu xatlá̠n pi̠ caj luu lhu̠hua hua̠ntu̠ lacuán ta­scújut caca̠t­la­huátit y luu xta̠­chuná cumu la̠ a̠ cama̠ak­sto­kuili̠pi min­tumi̠n nac akapú̠n anta­nícu ni̠lay ne̠cxni pasay xalu̠hua, y ni̠tu̠cu ma̠lak­tzanke̠y, xa̠huachí na̠ ni̠para kalha̠ná antá ni̠lay lak­chá̠n xla­cata naka­lhán. ");
INSERT INTO tocNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Porque anta­nícu hui­xinín nama̠ak­sto­kuili̠­yá̠tit min­tas­cu­jutcán pus na̠ antá hui­lachá nahuán mili̠s­tac­nicán. ");
INSERT INTO tocNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Mila­kas­tapu xta̠­chuná cumu la̠ li̠maksko hua̠ntu̠ mak­skolé̠n xli̠­hua̠k min­tan­tu­mi̠­nica, pus para huá tla̠n mila­kas­tapu xli̠­lanca nac min­tan­tu­mi̠­nica naka­lhi̠ya tax­káket. ");
INSERT INTO tocNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero para huá mila­kas­tapu ni̠tlá̠n li̠la­ca­hua̠­nana, pus xli̠­ca̠­lanca min­tan­tu­mi̠­nica xala­ka­ca̠­pucsua lamaj nahuán. Pus para hua̠ntu̠ li̠la­ca­hua̠­nana ni̠ kalhi̠y hua̠ntu̠ tla̠n tax­káket xli̠­ca̠na pi̠ xalak­tzanká̠n lápa̠t nahuán nac mila­táma̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Ni̠para cha̠tum chixcú tla̠n ca̠ta̠s­cuja cha̠tiy patrón aktumá quilh­ta­macú, porque acxni̠ nata̠s­cuja y naka­lha­kax­mata cha̠tum pus huá chú cha̠­tum­li̠tum juerza naka­lha­kax­mat­makán y nasi̠­tzi̠niy; xa̠huachí ni̠lay cati­tá̠s­cujli porque ni̠ catit­lá­hualh hua̠ntu̠ nali̠­ma̠­pek­si̠cán. Pus aquit cla­cas­quín pi̠ luu li̠huana̠ caaka­tá̠k­stit hua̠ntu̠ cuani­putún: Cha̠tum chixcú ni̠lay li̠pa̠­huán Dios cumu lá xpu̠­chiná y nat­la­huay hua̠ntu̠ li̠ma̠­peksi̠y, y para na̠ hua­tiyá a̠má quilh­ta­macú nali̠­pa̠­huam­paray xtumi̠n cumu lá xpu̠­chiná hua̠nti̠ naka­lha­kax­mata hua̠ntu̠ nali̠­ma̠­peksi̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Pus na̠chuna li̠túm luu cla­cas­quín pi̠ caaka­tá̠k­stit hua̠ntu̠ camá̠n ca̠hua­niyá̠n: Ni̠ picutá luu aka­tiyuj cali̠­la­ta­pá̠tit hua̠ntu̠ nali̠­hua̠­ya­ná̠tit cha̠li cha̠lí la̠qui̠ tla̠n nala­ta­pa̠­yá̠tit, y na̠ ni̠para huá xpa̠­la­cata milha­ka̠tcán hua̠ntu̠ nali̠­lha­ka̠­na­ná̠tit cali̠­taaka­tzan­ké̠tit. ¿Lácu pi̠ ni̠ catzi̠­yá̠tit pi̠ a̠tzinú li̠ma­cuán qui­la­ta­ma̠tcán porque huá Dios quin­ca̠­ma̠x­qui̠­ni̠tán, ni̠xa­chuná quin­ta­huajcán; y na̠chuna li̠túm qui­mac­nicán luu li̠ma­cuán ni̠ xachuná qui­lha­ka̠tcán? ");
INSERT INTO tocNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Caj luu caca­tzí̠tit, a̠ma̠ko̠lh lactzu spu̠n hua̠ntu̠ takosa nac ca̠u̠ní̠n xlacán ni̠ tacha­na̠nán, ni̠ tama­ka­la­na̠nán y ni̠para tat­la­huay xpu̠­cu­xicán anta­nícu nata­ma̠­qui̠y para xcu­xicán osuchi hua̠ntu̠ nata­mac­la­cas­quín. Pero huata huá Quin­tla̠­ticán hua̠nti̠ hui­lachá nac akapú̠n xlá cha̠li cha̠lí ca̠ma̠x­qui̠y xta­huajcán hua̠ntu̠ tla̠n nata­li̠­la­tama̠y, y sta­lanca catzi̠­yá̠tit pi̠ hui­xinín a̠tzinú luu lac­ta­li̠­pa̠hu ni̠ xachuná cumu la̠ a̠ma̠ko̠lh lactzu spu̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Pus luu caj caqui­la̠­hua­níhu, ¿tícu la̠ hui­xinín para ma̠rí liaka­ti­yuncán y li̠taaka­tzan­ke̠cán hua̠ntu̠ caj sacstu xla­cata, pi̠ tla̠n cahuá chú nama̠­li̠­hua­qui̠y ca̠na̠ caj aktum hora xla­táma̠t para aya amajá ni̠y? ");
INSERT INTO tocNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Pus cumu para chuná, ¿túcu xpa̠­la­cata hui­xinín picuta ma̠rí li̠ta̠­ka­tzan­ke̠­ta­pa̠­yá̠tit xpa̠­la­cata milha­ka̠tcán hua̠ntu̠ nali̠­lha­ka̠­na­ná̠tit? Huata luu cuentaj caca̠t­la­huátit a̠ma̠ko̠lh lactzu xánat hua̠ntu̠ sac­stucán tas­tac­ta­pu̠li̠y nac ca̠tu­huá̠n, xlacán ni̠ tas­cuja y ni̠para tat­la­huay hua̠ntu̠ xlacán nata­li̠­lha­ka̠nán. ");
INSERT INTO tocNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pero aquit laca­tancs cca̠­hua­niyá̠n pi̠ ni̠para huá a̠má chixcú hua̠nti̠ xamaká̠n quilh­ta­macú rey xuani̠t hua̠nti̠ xuanicán Salo­món, ma̠squi xli̠­ca̠na pi̠ luu lhu̠hua ca̠ta lac­li̠­pe̠­cuánit xala­cuán lháka̠t hua̠ntu̠ xlá xca̠­lhaka̠y, ne̠c­xnicú lay maca­tá̠x­tucli xla­cata chuná nalha­ka̠nán luu li̠la­káti̠t cumu la̠ a̠ma̠ko̠lh lactzu xánat. ");
INSERT INTO tocNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Cumu para huá Dios chuná lak­li̠­la­káti̠t li̠huana̠ ca̠ca̠x­ya̠­huay a̠ma̠ko̠lh lactzu li̠cúxtut hua̠ntu̠ la̠nchú li̠la­káti̠t tayá̠­nalh nac ca̠tu­huá̠n, pero caj cha̠lí o tu̠xama nax­nekko̠y, naca̠cán y nata­mac­pu̠cán nac ca̠lh­cu­ya̠tni, ¿lac­pu­hua­ná̠tit chú pi̠ huata hui­xinín ni̠ luu cati­ca̠­li̠­ta̠­ka­tzanké̠n? ¡Xli̠­ca̠na luu lani̠­tátit porque ni̠lay aksti̠tum li̠pa̠­hua­ná̠tit! ");
INSERT INTO tocNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Huá xpa̠­la­cata cca̠­li̠­hua­niyá̠n, ni̠ luu aka­tiyuj cali̠­látit xa̠huachí ni̠ luu cali̠­taaka­tzan­ké̠tit hua̠ntu̠ tla̠n nali̠­hua̠­ya­ná̠tit osuchí hua̠ntu̠ nali̠­lha­ka̠­na­ná̠tit cha̠li tu̠xama. ");
INSERT INTO tocNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Porque lhu̠hua cris­tianos hua̠nti̠ ni̠ tala­ka­pasa Dios caj luu xma̠nhuá tali̠­taaka­tzan­ke̠­ta­ma̠­má̠­nalh hua̠ntu̠ tamac­la­cas­quín, pero ni̠chuná caca̠­maca­sta̠­látit hua̠ntu̠ xlacán tat­la­hua­má̠­nalh, porque hui­xinín kalhi̠­yá̠tit cha̠tum Min­tla̠­ticán hua̠nti̠ hui­lachá nac akapú̠n hua̠nti̠ naca̠­mak­ta­ka­lhá̠n, xlá aya catzi̠y hua̠ntu̠ hui­xinín mac­la­cas­quim­pá̠tit cha̠li cha̠lí. ");
INSERT INTO tocNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pus huata hui­xinín mejor huá calak­pu­hua­la­ca­pítit la̠ta huí xli̠­ma̠­peksí̠n Dios xa̠huachí calak­tzak­sátit hua̠ntu̠ xlá lakati̠y; para chuná nat­la­hua­yá̠tit aca­li̠stá̠n xlá naca̠­ma̠x­qui̠yá̠n la̠ta túcua hui­xinín mac­la­cas­quim­pá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ni̠ huá caucxilh­la­ca­chi­pítit hua̠ntu̠ namac­la­cas­qui­ná̠tit xala cha̠li quilh­ta­macú o xala tu̠xama, porque la̠ta cha̠­liyá̠n xka­ka­ti̠­lhay acxnicú tasiyuy xatú­cuya̠ taaklhú̠­hui̠t li̠mín eé quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Ne̠cxni capu­tza̠­nani xta­la̠­ka­lhí̠n hua̠ntu̠ tla­huani̠t min­ta̠­cris­tiano xla­cata huix tla̠n nali̠­hua­niya, la̠qui̠ aca­li̠stá̠n Dios na̠ ni̠chuná napu­tza̠­na­ni­ko̠yá̠n xli̠­hua̠k hua̠ntu̠ tit­la­hua­ni̠ta min­ta­la̠­ka­lhí̠n y chuná chú nama̠­xo­ko̠­ni̠yá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Porque Dios na̠chuná naca̠­pu­tza̠­na­niyá̠n min­ta­la̠­ka­lhí̠n chuná cumu la̠ huix xca̠­pu­tza̠­na­niya xta­la̠­ka­lhi̠ncán min­ta̠­cris­tianoscán; y chuná cumu la̠ ca̠ma̠x­qui̠ya xta­xo­ko̠ncán min­ta̠­cris­tianoscán xlá na̠chuná nama̠x­qui̠yá̠n min­ta­xokó̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Pus, ¿lácu chú tla̠n liucxilh­niya xta­la̠­ka­lhí̠n cha̠tum min­ta̠­cris­tiano, xta̠­chuná cumu la̠ a̠ cata­la­kax­ta­puchá y laca­ta­nu̠ma nac xla­kas­tapu actzu pokxni, pero para huata huix chú ni̠para tzinú maklh­ca­tzi̠ya pi̠ na̠ tala­kax­ta­pu­ni̠ta y huix tlak lanca palh­qui̠m hua̠ntu̠ laca­ta­nu̠má̠n nac mila­kas­tapu? ");
INSERT INTO tocNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Y na̠chuna li̠túm para huix ni̠ catzi̠ya pi̠ na̠ tala­kax­ta­pu­ni̠ta, ¿lácu chú tla̠n li̠ca­tzi̠ya hua­niya min­ta̠­cris­tiano: “Caka­lhi̠­ke̠ya tzinú, pala u̠cla­ca­ma̠x­tuyá̠n tamá actzu pokxni hua̠ntu̠ laca­ta­nu̠má̠n nac milakastapu”? ");
INSERT INTO tocNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Aksa­ni̠ná! Mejor huata pu̠lh huix cala­ca­ma̠x­tú­canti tamá tlak lanca palh­qui̠m hua̠ntu̠ laca­ta­nu̠má̠n nac mila­kas­tapu la̠qui̠ chuná luu tla̠n nala­ca­hua̠­nana y luu tla̠n nala­ca­ma̠x­tuya a̠má actzu pokxni hua̠ntu̠ laca­ta­nu̠ma min­ta̠­cris­tiano. ");
INSERT INTO tocNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Ni̠ caca̠­ma̠x­quí̠tit chi­chí̠n hua̠ntu̠ xata­si­cu­la­na̠t­lahu cax­ti­lá̠n­chahu chi̠m­para xamaktum caj nata­si̠­tzi̠y y naca̠­li̠­kos­pa­sayá̠n; y na̠ ni̠para huá paxni caca̠­lak­ma­ca­pítit xalac­ta­pa­ra̠xlá y lacuán perlas xla­cata xlacán caj nata­lac­ta̠­yami̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ca̠hua­nipá Jesús: —Anka­lhi̠ná cas­qui­nítit Dios hua̠ntu̠ mac­la­cas­quim­pá̠tit y xlá naca̠­ma̠x­qui̠yá̠n; hua̠ntu̠ xatlá̠n tala­ca­pa̠s­tacni capu­tzátit y namac­la­yá̠tit, cala­kat­láktit má̠lacchi y chuná naca̠­ma̠­la­qui̠­ni­ca­ná̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Porque hua̠nti̠ squín ma̠x­qui̠cán, hua̠nti̠ putzay maclay, y hua̠nti̠ lakat­laka má̠lacchi ma̠la­qui̠­nicán. ");
INSERT INTO tocNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Chi̠nchú para hui­xinín huí min­ka­hua­sacán, ¿pi̠ huata nalac­pu­huana nama̠x­qui̠ya aktum chí­huix acxni̠ xlá nas­qui­niyá̠n mactum cax­ti­lá̠n­chahu? ");
INSERT INTO tocNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Osuchi para squi­nimá̠n cama̠xqui squi̠ti, ¿pi̠ naliak­ska­huiya tantum lu̠hua? ");
INSERT INTO tocNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Pus cumu hui­xinín cris­tianos xalac ca̠quilh­ta­macú luu li̠xcáj­nit li̠ca­tzi̠­yá̠tit, pero na̠ catzi̠­yá̠tit lácu nama̠x­qui̠­yá̠tit hua̠ntu̠ lacuán xta­huajcán min­ca­mancán, ¿pi̠ li̠huaca chú Quin­tla̠­ticán Dios hua̠nti̠ hui­lachá nac akapú̠n ni̠ cati­ca̠­ma̠x­quí̠n xala­cuán tala­ca­pa̠s­tacni acxni̠ hui­xinín nas­qui­ni­yá̠tit? ");
INSERT INTO tocNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Pus laca­tancs cca̠­hua­niyá̠n pi̠ xlianka­lhi̠ná caca̠t­la­hua­nítit li̠tlá̠n xa̠maka­pi­tzí̠n cris­tianos chuná cumu la̠ hui­xinín xla­cas­quíntit xlacán xtat­la­huanín li̠tlá̠n. Porque xli̠­ca̠na pi̠ huá u̠má kam­pu̠tum qui̠­tax­tu­ko̠lh hua̠ntu̠ tili̠­ma̠­pek­sí̠­nalh Moisés xamaká̠n quilh­ta­macú xa̠hua hua̠ntu̠ tita­tzo­kuíli̠lh nac xlib­rojcán pro­fetas. ");
INSERT INTO tocNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Hua̠nti̠ luu xli̠­ca̠na lak­ma̠x­tu­putún xli̠s­tacni luu juerza cat­la­huá­nilh calak­tzák­salh xla­cata antá nalac­tanu̠y nac xapi̠tzu má̠lacchi. Porque na̠ huí xapi̠­lanca má̠lacchi anta­nícu ni̠para tzinú tuhua lac­ta­nu̠cán y na̠chuná ca̠lak­mákat tiji anta­nícu ni̠ tuhua lac­tla̠­huancán, y luu lhu̠hua cris­tianos antá talac­tla̠­huán, pero hua̠nti̠ antá nataán pus laca­tancs pi̠ caj nac pu̠lak­tzanka̠n tala­ca­yá̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero huata a̠má pi̠tzu̠ má̠lacchi anta­nícu luu tuhua lac­ta­nu̠cán, xa̠hua a̠má tiji anta­nícu luu ca̠laktzú y ni̠ lhu̠hua talac­tla̠­huán porque antá luu tuhua lac­tla̠­huancán, xlá ti̠tum naca̠­li̠­cha̠ná̠n anta­nícu namaka­maklhti̠­na­ná̠tit latáma̠t nac akapú̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Luu xli̠­ca̠na cuentaj cat­la­huátit xla­cata ni̠tu̠ naca̠ak­ska­huiyá̠n a̠ma̠ko̠lh lac­chix­cu­huí̠n hua̠nti̠ caj taak­ska­hui­mi̠nán xlacán tahuán pi̠ mat huá tali̠­chu­hui̠­na­má̠­nalh, xta­chu­huí̠n Dios. Luu tlán la̠ta tama̠­kalh­chu­hui̠­ni̠nán xta̠­chuná cumu la̠ lac­ma̠ntzu bor­rego tali̠­taxtuy la̠ta tata­siyuy xla­cata pi̠ tla̠n naca̠­ma̠­la­ca­tzu­hui̠yá̠n, pero nac xpu̠­lac­nicán xta̠­chuná cumu la̠ xalac­lu̠cu la̠páni̠t hua̠nti̠ tahuanán. ");
INSERT INTO tocNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Hui­xinín huá tuncán naca̠­li̠­la­ka­pa­sá̠tit xta̠­yatcán caj xpa̠­la­cata li̠xcáj­nit hua̠ntu̠ tat­la­huay nac xla­ta­ma̠tcán. Pus hui­xinín sta­lanca catzi̠­yá̠tit pi̠ ni̠ maka­lacán uvas nac ca̠lh­tu­cuní̠n, na̠ ni̠para huá higo puxcán nac ca̠kajní̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Akatum quihui para tla̠n huá nali̠­ta­la­ka­pasa xta­huácat porque luu lacuán nata­huacay, y hua̠ntu̠ ni̠tlá̠n quihui pus na̠ huá xta­huácat nali̠­ta­la­ka­pasa pi̠ ni̠tlá̠n porque ni̠ lacuán cati­ta­huá­calh xta­huácat. ");
INSERT INTO tocNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ni̠para akatum quihui anán hua̠ntu̠ luu xli̠­ca̠na tla̠n y para chú natzucuy tahuacay xta­huácat hua̠ntu̠ ni̠ lacuán, y ni̠para akatum quihui hua̠ntu̠ ni̠ xatlá̠n chú natzucuy tahuacay hua̠ntu̠ luu xala­cuán xta­huácat. ");
INSERT INTO tocNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Xli̠­hua̠k quihui hua̠ntu̠ ni̠ lacuán tahuacay xta­huácat ca̠tan­ca̠­mi̠cán y tamac­pu̠cán nac lhcúya̠t la̠qui̠ antá nalac­lhcu­tapu̠y, y na̠chuná chú u̠ma̠ko̠lh lac­chix­cu­huí̠n naca̠ok­spulay. ");
INSERT INTO tocNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Xa̠huachí hui­xinín huá naca̠­li̠­la­ka­pa­sá̠tit hua̠ntu̠ xlacán tat­la­huay, porque luu xta̠­chuná cumu la̠ akatum quihui huá xta­huácat li̠ta­la­ka­pasa para tla̠n osu ni̠tlá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Ni̠ xli̠­hua̠k a̠ma̠ko̠lh cris­tianos hua̠nti̠ caj xquilh­nicán quin­ta­li̠­huaniy pi̠ quin­ta­li̠­pa̠­huán cumu lá xpu̠­chi­nacán taamá̠­nalh tata­pek­si̠niy Dios, huata caj xma̠nhuá hua̠nti̠ xli̠­ca̠na nata­ma̠­kan­taxti̠y nac xla­ta­ma̠tcán hua̠ntu̠ xta­pa̠­xu­huá̠n Quin­tla̠t hua̠nti̠ hui­lachá nac akapú̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Amá quilh­ta­macú acxni̠ naca̠­ma̠­xo­ko̠­ni̠cán cris­tianos nac xla­catí̠n Dios, lhu̠hua hua̠nti̠ naquin­ta­huaniy: “Quim­pu̠­chi­nacán, aquinín xac­li̠­chu­hui̠­na­ná̠hu min­ta­chu­huí̠n, caj min­ta­cu­huiní xac­li̠­qui­lha­ná̠hu tlán xac­ca̠t­la­kax­tu­yá̠hu xes­pí­ritu akska­huiní, xa̠huachí caj min­ta­cu­huiní tla̠n xac­ca̠­li̠t­la­hua­yá̠hu lac­lanca li̠cá̠cni̠t ta­scújut.” ");
INSERT INTO tocNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pero aquit chiné nac­ca̠­kalhti̠y: “Cata­ke̠­nú̠tit anta­nícu aquit cyá pu̠tum hui­xinín hua̠nti̠ xli̠­scuj­pá̠tit hua̠ntu̠ ni̠tlá̠n porque aquit ne̠cxni cca̠­la­ka­pas­ni̠tán para xqui­la̠­li̠­pa̠­hua­ná̠hu.” ");
INSERT INTO tocNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Hua̠nti̠ quin­ka­lha­kax­mata y lak­tzaksay nat­la­huay hua̠ntu̠ aquit cuán luu xta̠­chuná li̠taxtuy cumu la̠ cha̠tum ska­lala chixcú hua̠nti̠ tlá­hualh xchic y li̠huana̠ li̠lak­xket­yá̠­hualh chí­huix xta­la­yá̠hu. ");
INSERT INTO tocNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Acxni̠ chú milh li̠pe̠cua sí̠n, la̠n stac­ná̠­nalh nac kalh­tu̠­choko, y la̠n ú̠nulh anta­nícu xyá a̠má chiqui; pero ma̠squi chuná lalh a̠má chiqui ni̠para tzinú lac­pá̠alh porque xata­la­yá̠hu li̠huana̠ xma̠­ti̠­ju̠­cani̠t nac xlak­sti̠pá̠n chí­huix. ");
INSERT INTO tocNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero na̠chuna li̠túm, tala­ma̠­nampá cris­tianos hua̠nti̠ na̠ quin­ta­kax­matniy hua̠ntu̠ aquit cuan, pero cumu ni̠ talak­tzaksay hua̠ntu̠ cca̠­li̠­ma̠­peksi̠y pus xlacán luu xta̠­chuná tali̠­taxtuy cumu la̠ cha̠tum tonto chixcú hua̠nti̠ tla­huay xchic nac ca̠mun­tzayá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Acxni̠ chú la̠n milh sí̠n, la̠n stacli kalhu̠­choko, y luu li̠pe̠cua la̠ta ú̠nulh, pus cumu la̠n milh uú̠n, ¡a̠má chiqui ma̠k­pu̠s­pít­calh y maktum lac­la­ta­ma̠­ko̠lh! ");
INSERT INTO tocNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Acxni̠ Jesús chu­hui̠­nan­ko̠lh, a̠ma̠ko̠lh cris­tianos luu cacs tala­ca­huan­ko̠lh caj xpa̠­la­cata xta­kalh­chu­huí̠n hua̠ntu̠ xlá xma̠­si­yuni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Porque xlá xca̠­ma̠­kalh­chu­hui̠ni̠y cumu la̠ ti̠ xli̠­ca̠na kalhi̠y li̠ma̠­peksí̠n y ni̠ xta̠­chuná cumu lá xma̠­kalh­ta­hua­ke̠­nacán judíos. ");
INSERT INTO tocNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Acxni̠ Jesús tala­ka­ka­lhu̠­ta­hui­lachi nac a̠má ke̠stí̠n luu lhu̠hua cris­tianos ta­sta̠­lá­nilh. ");
INSERT INTO tocNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Antá nac tiji lak­ta­la­ca­tzú­hui̠lh cha̠tum chixcú hua̠nti̠ xli̠­ta­ja­tatlay pu̠lactum tzitzi hua­nicán lepra. Acxni̠ lák­chilh laka­ta­tzo­kós­talh nac xla­catí̠n y chiné huá­nilh: —Para huix chuná laca­squina caqui­ma̠­pac­sani la̠ta cka­lhi̠y quin­tzitzi. ");
INSERT INTO tocNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús laka­lhá­malh li̠mac­chí­palh xmacán nac xmacni y chiné huá­nilh: —Chuná cla­cas­quín, la̠n­chuj­tuncán capacsti. Acxni̠ chuná huan­ko̠lh a̠má ta̠tatlá tuncán pacsli. ");
INSERT INTO tocNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Aca­li̠stá̠n Jesús chiné huá­nilh: —Luu xli̠­ca̠na cat­lahua li̠tlá̠n ni̠tícu cali̠­ta̠­chu­huí̠­nanti. Huata caj xma̠n calak­pimpi cha̠tum cura, huá cama̠xqui mili­mosna hua̠ntu̠ tili̠­ma̠­pek­sí̠­nalh Moisés xamaká̠n quilh­ta­macú la̠qui̠ acxni̠ xlá naucxi­lhá̠n xlá nama̠­lu­loka y xli̠­pu̠tum naca­tzi̠cán pi̠ huix aya pac­sni̠ta a̠má min­ta­játat hua̠ntu̠ xka­lhi̠ya. ");
INSERT INTO tocNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Acxni̠ Jesús cha̠lh nac aktum ca̠chi­quí̠n hua­nicán Caper­naum la̠li̠­huán lak­ta­la­ca­tzú­hui̠lh cha̠tum capitán romano; xlá tzú­culh li̠ma̠­ka­tzanke̠y, ");
INSERT INTO tocNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","y chiné huá­nilh: —Quim­pu̠­chi­nacán Jesús, nac quín­chic ke̠tama cha̠tum quin­ta­sa̠cua lu̠n­tu̠­hua­nani̠t y luu li̠pe̠cua la̠ta maca­tzaj huí nac xli̠­lanca xmacni. ");
INSERT INTO tocNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús huá­nilh: —Aquit nacán ma̠t­la̠nti̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pero a̠má capitán chiné kálh­ti̠lh: —Ma̠kalh­ta­hua­ke̠ná, xli̠­ca̠na pi̠ huix luu tla̠n catzi̠ya, pero aquit ni̠para tzinú qui­mi­ni̠niy xla­cata pi̠ huix nata­nu̠­yá̠pi nac quín­chic. Huata mejor caj kalhtum tachu­huí̠n cahuanti cama̠­pek­sí̠­nanti y a̠má quin­ta­sa̠cua natat­la̠ntí̠y, porque cli̠­pa̠­huaná̠n y cca­tzi̠y pi̠ hua̠ntu̠ huix nali̠­ma̠­pek­si̠­nana chuná nalay. ");
INSERT INTO tocNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Huá chuná cli̠­hua­nimá̠n porque aquit sol­dado y na̠ huí hua̠nti̠ quin­ta­ma̠­peksi̠y lac­lanca qui­na­puxcún. Xa̠huachí chú aquit na̠ tahui­lá̠­nalh quin­tropa hua̠nti̠ cca̠­ma̠­peksi̠y; acxni̠ cuaniy cha̠tum para nícu caalh pus xlá án, y acxni̠ cuani­paray cha̠tum xla­cata pi̠ camilh xlá namín; y acxni̠ chú cli̠­ma̠­peksi̠y quin­ta­sa̠cua para túcu cat­lá­hualh xlá la̠li̠­huán tla­huay. ");
INSERT INTO tocNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Acxni̠ Jesús káx­matli hua̠ntu̠ xlá huá­nilh luu cacs li̠la­cahua y chiné ca̠huá­nilh hua̠nti̠ xta­sta̠­la­ni­má̠­nalh: —Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ la̠ta xli̠­ca̠­lanca nac xapu̠­la­tama̠n Israel ni̠tícu a̠ cma̠­nok­lhuy hua̠nti̠ luu xli̠­ca̠na naqui­li̠­pa̠­huán cumu la̠ qui­li̠­pa̠­huán eé chixcú. ");
INSERT INTO tocNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Pus chú luu laca­tancs camá̠n ca̠hua­niyá̠n hua̠ntu̠ amaj qui̠­taxtuy aca­li̠stá̠n: la̠ta xli̠­ca̠­lanca ca̠quilh­ta­macú lhu̠hua cris­tianos hua̠nti̠ ni̠tu̠cu xka­satcán ca̠li̠­ma̠x­tucán porque xlacán ni̠ judíos, pero hua­tuní̠n tla̠n nata­lak­chá̠n anta­nícu hui­lachá Dios nac akapú̠n; xlacán antá quilh­xtum nata­mak­ta­huilay nac a̠má mesa anta­nícu pu̠tum nata­ta̠­hua̠yán xalak­maká̠n qui­li̠­ta­la­ka­pas­nicán Abraham, Isaac y Jacob. ");
INSERT INTO tocNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Y lhu̠hua cris­tianos israel­itas hua̠nti̠ xca̠­ma̠­lac­nu̠­ni­cani̠t pi̠ naca̠­lak­ma̠x­tucán y xli̠­ta­hui­latcán xuani̠t nac xpu̠­ta­hui̠lhcán antá nac xpa̠xtú̠n Dios, caj xpa̠­la­cata cumu ni̠ tama̠­kan­táx­ti̠lh nac xla­ta­ma̠tcán hua̠ntu̠ xca̠­li̠­ma̠­pek­si̠­cani̠t, pus xlacán naca̠­ta­mac­xtucán nac quilhtí̠n anta­nícu luu ca̠púcsua. ¡Koxu­taní̠n xlacán, porque antá nata­tasay y nata­ma̠­lac­sa̠ni̠y xta­tzancán caj cumu li̠pe̠cua la̠ta nata­pa̠­ti̠nán! ");
INSERT INTO tocNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Acxni­tiyá Jesús chiné huá­nilh a̠má capitán: —La̠nchú capittá nac mín­chic, niaj caaka­ti­yújlat pus huata chuná cakan­táx­tulh cumu la̠ huix ca̠naj­la­ni̠ta. Xli̠­ca̠na xlá pi̠ acxni­tiyá a̠má quilh­ta­macú a̠má xta­sa̠cua capitán tat­lá̠n­ti̠lh la̠ta xta̠­tatlay. ");
INSERT INTO tocNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Maktum quilh­ta­macú acxni̠ Jesús alh nac xchic Pedro antá xlá úcxilhli xpu̠­ti­ya̠tzi Pedro pi̠ xke̠­tama nac xpu̠­tama porque xli̠­lama palha lhcúya̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Huata Jesús maca­chí­palh nac xmacán y acxni­tuncán mák­xtekli a̠má lhcúya̠t hua̠ntu̠ luu xmak­ni̠ma; y a̠má pusca̠t la̠li̠­huán tá̠qui̠lh, tzú­culh ca̠x­tla­huay xtahuá hua̠ntu̠ naca̠­ta̠­li̠­hua̠yán. ");
INSERT INTO tocNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Aca­li̠stá̠n acxni̠ aya ca̠puc­suanko̠lh, luu lhu̠hua ta̠tat­laní̠n li̠mi­ní­calh anta­nícu xuí Jesús; huí ti̠ xca̠akchi­pa­nini̠t xta­la­ca­pa̠s­tac­nicán xes­pí­ritu akska­huiní pero cumu xlá kalhi̠y li̠t­li­hueke caj maka­tunu xca̠­xa­katli̠y y xca̠­pu̠t­la­kaxtuy a̠ma̠ko̠lh akska­hui­niní̠n. Xa̠huachí hua̠k ca̠ma̠t­lá̠n­ti̠lh ti̠pa̠­katzi ta̠tat­laní̠n hua̠nti̠ antá xca̠­li̠­mi­ni­cani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jesús chuná ca̠ma̠t­lá̠n­ti̠lh a̠ma̠ko̠lh ta̠tat­laní̠n y chuná li̠ma̠­kan­táx­ti̠lh nac xla­táma̠t hua̠ntu̠ xamaká̠n quilh­ta­macú xli̠­chu­hui̠­na­ni̠ttá pro­feta Isaías acxni̠ chiné huá: “Hua̠k xlá tla­hua­ko̠lh quin­ta­ja­tatcán.” ");
INSERT INTO tocNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Acxni̠ Jesús úcxilhli pi̠ luu lhu̠hua cris­tianos xta­chi­má̠­malh anta­nícu xuí xlá, ca̠huá­nilh xta­ma̠­kalh­ta­huaké̠n pi̠ cata­tá­ca̠xli xla­cata nata­pa̠­ta­cuta a̠li̠quilh­tu̠tu chú­chut. ");
INSERT INTO tocNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Cha̠tum xma̠­kalh­ta­hua­ke̠­nacán judíos lak­ta­la­ca­tzú­hui̠lh y chiné huá­nilh: —Ma̠kalh­ta­hua­ke̠ná, aquit na̠ csta̠­la­ni­pu­tuná̠n la̠tachá nícu huix napina lata­pa̠ya. ");
INSERT INTO tocNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús kálh­ti̠lh: —Aquit ni̠tu̠ cka­lhi̠y, ni̠chuná cumu la̠ a̠ma̠ko̠lh lactzu hue̠kni xlacán taka­lhi̠y clhu­cucán anta­nícu talh­tatay, xa̠huá a̠ma̠ko̠lh lactzu spu̠n hua̠k taka­lhi̠y xma̠­se­kecán; pero aquit Xata­lac­sacni Chixcú ni̠ cka­lhi̠y anta­nícu cma̠­jaxay quiakxa̠ka acxni̠ ctla­kuán. ");
INSERT INTO tocNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Cha̠­tum­li̠túm hua̠nti̠ na̠ xta­ma̠­kalh­ta­huaké̠n xuamputún chiné huá­nilh: —Quim­pu̠­chiná, aquit na̠ nac­sta̠­la­niyá̠n pero caquin­ti­ma̠xqui quilh­ta­macú hasta acxni̠ nani̠y quin­tla̠t la̠qui̠ nac­ma̠c­nu̠­ta̠­qui̠y y nac­sta̠­la­niyá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús huá­nilh: —Para xli̠­ca̠na huix quis­ta̠­la­ni­pu­tuna, la̠n­chuj­tuncán caquis­ta̠­lani y caca̠­mák­xtekti a̠ma̠ko̠lh maka­pi­tzí̠n cris­tianos hua̠nti̠ tali̠­taxtuy cumu la̠ xaní̠n tala­má̠­nalh xla­cata pi̠ huá cata­má̠c­nu̠lh xta̠­ni̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesús la̠li̠­huán ca̠ta̠­tá­ju̠lh xta­ma̠­kalh­ta­huaké̠n nac aktum barco la̠qui̠ antá nata­chá̠n nac a̠li̠quilh­tú̠tu pupunú. ");
INSERT INTO tocNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ni̠ naj para mákat a̠ xtat­la̠­huán nac chú­chut acxni̠ li̠pe̠cua la̠ta tzú­culh u̠nún y na̠chuná tzú­culh ta̠ke­ya̠­huay pupunú a̠tzinú xuani̠t aya xma̠k­tzi̠­pu­tuncán barco. Jesús na̠ antá xta­ju̠ma cbarco pero xlá xmá y clhta­tama. ");
INSERT INTO tocNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Xta­ma̠­kalh­ta­huaké̠n Jesús la̠li̠­huán tama̠­la­ka­huá­ni̠lh y chiné tahuá­nilh: —Quim­pu̠­chi­nacán, ¡cat­lahua li̠tlá̠n, caqui­la̠­mak­ta̠­yáhu porque la̠nchú ama̠­náhu mu̠x­tu­yá̠hu! ");
INSERT INTO tocNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Pero huata xlá chiné ca̠kálh­ti̠lh: —¿Túcu xpa̠­la­cata ma̠rí li̠pe̠­cuampá̠tit? ¡Xli̠­ca̠na pi̠ hui­xinín ni̠ luu qui­la̠­li̠­pa̠­hua­ná̠hu! ¿Nícu chi̠nchú huí min­ta­ca̠­naj­latcán? Huata xlá la̠li̠­huán tá̠qui̠lh, ca̠la­ca­quílh­ni̠lh uú̠n xa̠hua pupunú xla­cata pi̠ cata­tá­cacsli, y tuncán ca̠tzi­yanca huan­ko̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Acxni̠ xlacán taúcxilhli la̠ta ca̠ma̠­pék­si̠lh uú̠n chu pupunú luu cacs tala­ca­huan­ko̠lh y chiné tzú­culh tala̠­ka­lhas­quín: —¿Túcu ya̠ta li̠t­li­hueke kalhi̠y eé chixcú, porque hasta ma̠squi uú̠n xa̠hua pupunú taka­lha­kax­mata acxni xlá ca̠ma̠­peksi̠y? ");
INSERT INTO tocNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Acxni̠ Jesús tacutchá a̠li̠quilh­tu̠tu pupunú antá cha̠lh nac aktum pu̠la­tama̠n hua­nicán Gadara, y nac ca̠pú̠­sa̠ntu tatax­tuchi cha̠tiy lac­chix­cu­huí̠n hua̠nti̠ xca̠­maka­tla­jani̠t xta­la­ca­pa̠s­tac­nicán akska­huiní porque xca̠­mac­ta­nu̠ma. Uma̠­kó̠lh lac­chix­cu­huí̠n luu lac­lu̠cu xta­huani̠t y hasta nac a̠má tiji ni̠tícu luu xlac­tla̠­huán porque xta­pe̠­cuaniy. ");
INSERT INTO tocNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Y la̠ta xta­ta­la­ca­tzu­hui̠­má̠­nalh antá xlá nícu xyá Jesús, caj xalán tzú­culh taqui­lhaniy: —¡Jesús! ¿Túcu xpa̠­la­cata qui­la̠­li̠­pek­ta­nu̠­yá̠hu? Caj luu chuná catzi̠ya a̠li̠sok tani̠ta qui­la̠­ma̠­pa̠­ti̠­ni̠­yá̠hu porque huix Xka­huasa Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Cumu antá lacatzú xta­pu­tzua̠ya­má̠­nalh lhu̠hua paxni ");
INSERT INTO tocNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","huata a̠ma̠ko̠lh xes­pi­ri­tucán akska­huiní chiné tahuá­nilh Jesús: —Para naqui­la̠t­la­kax­tu­yá̠hu la̠ u̠cmac­ta­nu̠­ma̠­náhu eé chixcú, pus luu cat­lahua li̠tlá̠n caqui­la̠­ma̠x­quí̠hu tala­cas­quín nac­ca̠­mac­ta­nu̠­yá̠hu tama̠­ko̠lh paxni. ");
INSERT INTO tocNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesús ca̠huá­nilh: —Pus tla̠n, antá cata­nú̠tit. Xes­pi­ri­tucán akska­huiní tamák­xtekli a̠ma̠ko̠lh lac­chix­cu­huí̠n y huá tamac­tá­nu̠lh paxni. Ama̠­ko̠lh paxni la̠n tape̠­cuáxni̠lh, tzú­culh takosnún hasta tácha̠lh nac aktum talhpá̠n, antá lhken táalh y hasta nac pupunú tata­ju̠chá, hua̠k antá tajic­suanko̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ama̠­ko̠lh lac­chix­cu­huí̠n hua̠nti̠ xta­mak­ta­kalh­má̠­nalh paxni, caj la̠ta xta­pe̠­cuacán tokosú̠n tatzá̠­lalh hasta tácha̠lh nac ca̠chi­quí̠n; y acxni̠ antá tácha̠lh xlacán tzú­culh tali̠­chu­hui̠nán hua̠ntu̠ taak­spú­lalh xpax­nicán, y na̠chuná tali̠­chu­huí̠­nalh hua̠ntu̠ xca̠­qui̠­tax­tu­nini̠t a̠ma̠ko̠lh lac­chix­cu­huí̠n hua̠nti̠ xapu̠lh xca̠­mac­ta­nu̠ma xes­pí­ritu akska­huiní. ");
INSERT INTO tocNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Xli̠­pu̠tum cris­tianos hua̠nti̠ xta­hui­lá̠­nalh nac a̠má ca̠chi­quí̠n la̠li̠­huán ta̠lh anta nícu xla­ya̠chá Jesús. Acxni xlacán taúcxilhli tahuá­nilh xla­cata pi̠ cat­lá­hualh li̠tlá̠n cata­tam­pú̠x­tulh nac xpu̠­la­ta­ma̠ncán hua̠ntu̠ xlacán xta­ma̠­peksi̠y y mákat caalh. ");
INSERT INTO tocNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Pus huata Jesús táju̠lh nac barco y tacut­pa­rachá a̠li̠quilh­tu̠tu pupunú, y antá tácha̠lh nac xca̠­chi­quí̠n anta­nícu luu xlama xuanicán Caper­naum. ");
INSERT INTO tocNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Antá xlá xuilachá acxni̠ li̠cha̠­ní­calh cha̠tum chixcú hua̠nti̠ xlu̠n­tu̠­hua­nani̠t, a̠má ta̠tatlá pu̠chexni xpu̠­le̠ncán. Acxni̠ Jesús ca̠úcxilhli pi̠ a̠ma̠ko̠lh lac­chix­cu­huí̠n xta­li̠­pa̠­huán xla­cata pi̠ tla̠n xlá nama̠t­la̠nti̠y chiné huá­nilh a̠má ta̠tatlá: —Catu̠x­ca̠ni ta̠ta, porque xli̠­hua̠k min­ta­la̠­ka­lhí̠n aya cma̠­tzan­ke̠­na­ni­ni̠tán. ");
INSERT INTO tocNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Pero maka­pi­tzí̠n xma̠­kalh­ta­hua­ke̠­nacán judíos hua̠nti̠ antá xta­la­yá̠­nalh xlacán chiné talac­púhua: “Umá chixcú caj xpa̠­la­cata xta­chu­huí̠n li̠kalh­ka­ma̠­nama y ta̠la̠­la­ca­ta̠­qui̠ma Dios.” ");
INSERT INTO tocNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pero cumu Jesús cátzi̠lh hua̠ntu̠ xlacán xta­lac­pu­hua­má̠­nalh chiné ca̠huá­nilh: —¿Túcu xpa̠­la­cata hui­xinín luu li̠xcáj­nit li̠ka­lhi̠­yá̠tit min­ta­la­ca­pa̠s­tac­nicán? ");
INSERT INTO tocNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Pus caqui­la̠­hua­níhu, ¿xatúcu a̠tzinú ni̠para tuhua ma̠kan­tax­ti̠cán, pi̠ acxni̠ nahua­niya cha̠tum ta̠tatlá: “Min­ta­la̠­ka­lhí̠n hua̠k cma̠tzanke̠naniyá̠n”, osuchí para nahua­niya: “La̠li̠­huán cata̠qui y catlá̠huanti”? ");
INSERT INTO tocNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pus la̠nchú camá̠n ca̠ma̠­si­yu­niyá̠n pi̠ aquit Xata­lac­sacni Chixcú y na̠chuna li̠túm pi̠ xli̠­ca̠na cka­lhi̠y li̠t­li­hueke uú nac ca̠quilh­ta­macú y caj quin­ta­chu­huí̠n tla̠n cli̠­ma̠­tzan­ke̠­na­ni̠nán tala̠­ka­lhí̠n. Xlá xakát­li̠lh a̠má chixcú hua̠nti̠ xlu̠n­tu̠­hua­nani̠t y chiné huá­nilh: —Huix cuanimá̠n, la̠li̠­huán cata̠qui, casacti mim­pu̠­chexni y capit nac mín­chic. ");
INSERT INTO tocNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Amá chixcú hua̠nti̠ xlu̠n­tu̠­hua­nani̠t la̠li̠­huán tá̠qui̠lh, táx­tulh y alh nac xchic. ");
INSERT INTO tocNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Acxni̠ a̠ma̠ko̠lh cris­tianos taúcxilhli hua̠ntu̠ xlá xtla­huani̠t la̠n tapé̠­cualh caj xpa̠­la­cata tacá̠c­ni̠lh xta­scújut y tzú­culh tapa̠x­cat­ca­tzi̠niy Dios caj xpa̠­la­cata cumu xlá xma̠x­qui̠ni̠t lanca li̠t­li­hueke eé chixcú. ");
INSERT INTO tocNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Aca­li̠stá̠n Jesús alh a̠laca­tunu ca̠chi­quí̠n y maktum acxni̠ xtla̠­huama nac tiji úcxilhli cha̠tum chixcú xuanicán Mateo, antá xlá xuí nac mesa nac xquilhtí̠n ofic­ina antaní xma̠­la­ka­xo­ke̠nán im­pues­tos hua̠ntu̠ xma̠­ta̠­ji̠­na­ni­má̠­calh Roma; xlá chiné huá­nilh: —Huix na̠ caquis­ta̠­lani. Amá Mateo la̠li̠­huán huakaj tá̠yalh, akxte­kuili̠­ko̠lh xta­scújut y sta̠­lá­nilh. ");
INSERT INTO tocNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Aca­li̠stá̠n Jesús antá alh hua̠yán nac xchic Mateo y na̠ luu lhu̠hua lac­chix­cu­huí̠n hua̠nti̠ judíos xta­lac­pu­huaniy pi̠ hua̠k xalak­tzanká̠n xta­la­má̠­nalh, xa̠hua xma̠­ta̠­ji̠­naní̠n im­pues­tos hua̠nti̠ ni̠tu̠ xca̠­liucxilhcán xlacán na̠ antá xtaani̠t tama­kua̠yán, y na̠ antá quilh­xtum tamak­tahui nac mesa antaní xuí Jesús xa̠hua xdis­cí­pulos. ");
INSERT INTO tocNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pero a̠ma̠ko̠lh lac­chix­cu­huí̠n hua̠nti̠ xca̠­hua­nicán fariseos acxni̠ xlacán taúcxilhli la̠ta xta­hui­lá̠­nalh xlacán taka­lhás­quilh xdis­cí­pulos Jesús: —¿Túcu xpa̠­la­cata mima̠­kalh­ta­hua­ke̠­nacán lac­xtum ca̠li̠­ta̠­hua̠yán hua̠nti̠ tama̠­la­ka­xo­ke̠nán im­pues­tos, xa̠huá hua̠nti̠ luu lac­li̠xcáj­nit mak­la̠­ka­lhi̠­naní̠n lac­chix­cu­huí̠n? ");
INSERT INTO tocNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Cumu Jesús káx­matli hua̠ntu̠ xlacán xta­qui­lhuamá̠­nalh chiné ca̠huá­nilh: —Ni̠tu̠ mac­la­cas­quima doctor hua̠nti̠ tla̠n lama y ni̠tu̠ kalhi̠y tajátat, pero hua̠nti̠ tata­ja­tatlay tamac­la­cas­qui­má̠­nalh pi̠ naca̠­ma̠t­la̠nti̠y doctor. ");
INSERT INTO tocNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ luu li̠huana̠ caaka­tá̠k­stit hua̠ntu̠ hua­ni­putún xta­chu­huí̠n Dios anta­nícu chiné tatzok­ta­hui­lani̠t nac li̠kalh­ta­huaka: “Aquit ni̠ cma̠t­la̠nti̠y caj xma̠n naqui­la̠­li̠­la­ka­chix­cu­hui̠­yá̠hu min­ta­ka­lhi̠ncán hua̠ntu̠ ca̠mak­ni̠­yá̠tit, pus huata aquit cla­cas­quín pi̠ na̠ caca̠­la­ka­lha­mántit xa̠maka­pi­tzí̠n hua̠nti̠ na̠ talak­tzan­ka̠­ta̠­ya­má̠­nalh nac xla­ta­ma̠tcán.” Y na̠chuná li̠tum aquit ni̠ huá cmini̠t ca̠huaniy xla­cata nata­lak­pali̠y xta­la­ca­pa̠s­tac­nicán hua̠nti̠ luu xli̠­ca̠na lacuán cris­tianos, huata huá cmini̠t ca̠ta­saniy hua̠nti̠ luu mak­la̠­ka­lhi̠­naní̠n la̠qui̠ aquit nac­ca̠­lak­ma̠xtuy. ");
INSERT INTO tocNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Mak­tum­li̠túm maka­pi­tzí̠n xdis­cí­pulos Juan Bau­tista talak­ta­la­ca­tzú­hui̠lh Jesús y chiné tahuá­nilh: —Aquinín chu maka­pi­tzín fariseos anka­lhi̠ná ckalh­xtek­ni­ná̠hu xla­cata cla­ka­chix­cu­hui̠­yá̠hu Dios, ¿túcu chú xpa̠­la­cata min­ta­ma̠­kalh­ta­huaké̠n ni̠ tali̠­kalh­xteknín? ");
INSERT INTO tocNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús chiné ca̠kálh­ti̠lh: —Hua̠nti̠ ca̠pu­tza­cani̠t xla­cata nataán tamak­pa̠x­cuajnán nac aktum pu̠ta­maka­xtokni, ¿lácu pi̠ mini̠niy xlacán caj ya̠ tali̠­pu­huá̠n antá nata­mak­la­ta­hui­la­ya̠chá li̠huán antá ca̠ta̠­láhui a̠má kahuasa hua̠nti̠ tamaka­xtokma? Pero nalak­chá̠n quilh­ta­macú acxni̠ nas­puta pu̠pa̠xcua y a̠má kahuasa hua̠nti̠ tama­káx­tokli mákat naán, chuná cumu la̠ aquit amaj quiok­spulay, acxnicú chú xlacán nata­li̠­pu­huán y nata­kalh­xteknín. ");
INSERT INTO tocNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Xli̠­hua̠k hua̠ntu̠ aquit cca̠­li̠­ma̠­kalh­chu­hui̠­ni̠má̠n xasa̠sti li̠ma̠­peksí̠n, pus huá xpa̠­la­cata cca̠­li̠­hua­niyá̠n pi̠ ni̠para cha̠tum tícu mini̠niy nalak­tzapay mactum xala­kuán xves­tido y huá chú nama̠­hua­caniy pi̠tzu̠ xasa̠sti lháka̠t, porque a̠má xasa̠sti lháka̠t acxni̠ nache­ke̠cán naactzu̠­huanán y a̠tzinú lanca nahuán hua̠ntu̠ natax­ti̠ta ni̠xa­chuná la̠ xapu̠lh xtax­ti̠tni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Y na̠chuna li̠túm ni̠ pu̠ma­ju̠cán xas­kata pulque hua̠ntu̠ aya lakuama xmak­xu̠hua bor­rego, porque para chuná nat­la­huacán, a̠má xmak­xu̠hua bor­rego napanka, chuná xu̠hua cumu la̠ pulque caj pá̠xcat nahuanko̠y porque lac­xtum nalak­tzanka̠y. Pus huá xpa̠­la­cata pi̠ li̠huaca tla̠n maju̠cán xas­kata pulque nac xasa̠sti xmak­xu̠hua bor­rego la̠qui̠ luu lac­xtum nata­catlán y nata­ta̠­yaniy y ni̠tu̠ cati­ta­lá­nilh. ");
INSERT INTO tocNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Acxni̠ Jesús chuná xca̠­li̠­ma̠­kalh­chu­hui̠­ni̠ma eé tachu­huí̠n cha̠tum chixcú hua̠nti̠ xca̠­pux­cuniy judíos chilh anta­nícu xlá xlaya, laka­ta­tzo­kós­talh nac xla­catí̠n y chiné huá­nilh: —Quin­tzuma̠t ucu ni̠lh pero para huix nalak­pina y nali̠­xa­maya mimacán nac xmacni xlá luu tla̠n nala­ta­ma̠­paray. ");
INSERT INTO tocNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesús táca̠xli y la̠li̠­huán tá̠alh nac xchic, y na̠ hua̠k ca̠tá̠alh xdis­cí­pulos. ");
INSERT INTO tocNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Pero na̠ ca̠s­ta̠­lá­nilh cha̠tum pusca̠t hua̠nti̠ aya xle̠ma xliakcu̠tiy ca̠ta la̠ta xta̠­tatlay cstaj­makama xkalhni. Xlá tze̠k lak­ta­la­ca­tzú­hui̠lh Jesús nac xke̠n y tam­pek­sta̠­xa­má­nilh clháka̠t, ");
INSERT INTO tocNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","porque xlá xlac­pu­huán: “Hua­tiyá para tla̠n xac­xa­má­nilh tzinú clháka̠t aquit tuncán nac­tat­la̠nti̠y.” ");
INSERT INTO tocNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Acxni̠ chú xama­ni­ko̠lh clháka̠t, Jesús la̠li̠­huán tala­kás­pitli úcxilhli a̠má pusca̠t y chiné huá­nilh: —Na̠na, huix la̠nchú tat­la̠n­ti̠­ni̠ta porque qui­li̠­pá̠­huanti xa̠huachí ca̠najla pi̠ aquit tla̠n nac­ma̠t­la̠n­ti̠yá̠n. Acxni­tiyá chú a̠má pusca̠t tat­lá̠n­ti̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pero acxni̠ Jesús cha̠lh nac xchic a̠má xapuxcu judío xuanicán Jairo, xlá ca̠úcxilhli hua̠nti̠ xta­ma̠­ta­si̠­má̠­nalh lí̠spek xla­cata aya naancán ma̠c­nu̠­nuncán, na̠chuná xli̠­lhu̠hua cris­tianos xta­ta­sa­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Xlá chiné ca̠huá­nilh: —Luu xli̠­ca̠na cat­la­huátit li̠tlá̠n la̠li̠­huán catax­tútit porque u̠má tzuma̠t ni̠tu̠ ni̠ma huata xlá caj lhta­tama. Pero a̠ma̠ko̠lh cris­tianos caj tzú­culh tali̠­li̠­tziyán hua̠ntu̠ xlá huá. ");
INSERT INTO tocNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jesús juerza ca̠t­la­káx­tulh, aca­li̠stá̠n xlá tánu̠lh, chi­pá­nilh xmacán y a̠má tzuma̠t tuncán tá̠qui̠lh; ");
INSERT INTO tocNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","y la̠ta xli̠­ca̠­lanca a̠má pu̠la­tama̠n tala­ka­pun­tú­mi̠lh tachu­huí̠n hua̠ntu̠ xlá xtla­huani̠t Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Acxni̠ Jesús táx­tulh nac ca̠chi­quí̠n y alhá, cha̠tiy laka­xo̠kó̠n lac­chix­cu­huí̠n tzú­culh ta­sta̠­laniy xta­ma̠­ta­si̠­má̠­nalh y chiné xta­hua­ni­má̠­nalh: —Xli̠­ta­la­ka­pasni xamaká̠n rey David, cat­lahua li̠tlá̠n, caqui­la̠­la­ka­lha­máhu. ");
INSERT INTO tocNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesús ni̠ tachó­kolh y acxni̠ chú cha̠lh nac chiqui anta­nícu xlá xlak­tun­cu­huiy, a̠ma̠ko̠lh laka­xo̠ko na̠ tatá­nu̠lh, talak­ta­la­ca­tzú­hui̠lh anta­nícu xlá xuí y chiné ca̠ka­lhás­quilh: —¿Ca̠naj­la­yá̠tit hui­xinín pi̠ aquit tla̠n nac­tla­huay hua̠ntu̠ hui­xinín qui­la̠­li̠­ma̠­ka­tzan­ke̠­ma̠­náhu? Xlacán takalh­tí̠­nalh: —Quim­pu̠­chi­nacán, aquinín xli̠­ca̠na cca̠­naj­la­yá̠hu. ");
INSERT INTO tocNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Pus Jesús ca̠la­ca­xá­malh nac xla­kas­ta­pucán y chiné ca̠huá­nilh: —Cumu para chuná pus cakan­táx­tulh hua̠ntu̠ hui­xinín ca̠naj­la­ni̠­tátit. ");
INSERT INTO tocNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Xla­kas­ta­pucán a̠ma̠ko̠lh lac­chix­cu­huí̠n li̠huana̠ tat­la̠n­ti̠­ko̠lh y tla̠n tala­ca­huá̠­nalh. Jesús ca̠huá­nilh: —Luu xli̠­ca̠na cat­la­huátit li̠tlá̠n ni̠ti̠ cali̠­ta̠­chu­hui̠­nántit la̠qui̠ ni̠tícu naca­tzi̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero caj la̠ta xlacán tatáx­tulh, tuncán tzú­culh tali̠­chu­hui̠nán hua̠ntu̠ Jesús xtla­huani̠t nac xla­ta­ma̠tcán y la̠ta xli̠­ca̠­lanca a̠má pu̠la­tama̠n hua̠k catzí̠­calh. ");
INSERT INTO tocNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Acxni̠ a̠ma̠ko̠lh lac­chix­cu­huí̠n hua̠nti̠ ca̠ma̠­la­cat­la̠n­tí̠­calh aya xta­tax­tu­má̠­nalh nac chiqui, tachimpá maka­pi­tzí̠n lac­chix­cu­huí̠n y tali̠­mí­nilh Jesús cha̠tum chixcú ko̠ko porque huá xes­pí­ritu akska­huiní xma̠­ko̠­ke̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesús li̠ma̠­pék­si̠lh a̠má akska­huiní xla­cata camac­táx­tulh a̠má chixcú, y acxni̠ chú mak­xtek­ko̠lh, a̠má ko̠ko tla̠n tzú­culh chu­hui̠nán. La̠ta xli̠­lhu̠hua cris­tianos tzú­culh tapa̠­xu­huay y chiné xta­huán: —Ne̠c­xnicú a̠ xta­siyuy nac xapu̠­la­tama̠n Israel hua̠ntu̠ la̠nchú tasi­yuma. ");
INSERT INTO tocNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero maka­pi­tzí̠n fariseos chiné xta­huán: —Umá chixcú tla̠n ca̠ta­mac­xtuy xes­pi­ri­tucán akska­huiní porque huá li̠pa̠­huán y ta̠s­cujma xapuxcu akska­huiní, y huá chú ma̠x­qui̠ni̠t xli̠t­li­hueke. ");
INSERT INTO tocNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús tzu­cupaj ca̠la­ka­pa­xia̠lhnán lactzu ca̠chi­qui̠ní̠n hua̠ntu̠ xta­hui­lá̠­nalh nac a̠má pu̠la­tama̠n; la̠ta nícu xcha̠n xtanu̠y nac xpu̠­si­cu­lancán judíos y antá xca̠­ma̠­kalh­chu­hui̠ni̠y cris­tianos. Huá xca̠­li̠­ma̠­kalh­chu­hui̠ni̠y la̠ta lácu xuili̠­putún xasa̠sti xli̠­ma̠­peksí̠n Dios la̠qui̠ tla̠n nata­lak­taxtuy cris­tianos, xa̠huachí xlá hua̠k xca̠­ma̠t­la̠nti̠y la̠tachá túcuya̠ tajátat chu taca­tza­ná­juat. ");
INSERT INTO tocNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Acxni̠ xca̠ucxilha lhu̠hua cris­tianos la̠ta lácua xlacán xta­la­má̠­nalh, xlá luu xli̠­ca̠na snu̠n ca̠la­ka­lhá­malh porque lhu̠hua hua̠nti̠ ni̠ xta­ka­lhi̠y xta­pa̠­xu­huá̠n y ni̠ti̠ xanán hua̠nti̠ naca̠­mak­ta̠yay. Luu xta̠­chuná xta­la­má̠­nalh cumu la̠ bor­regos hua̠nti̠ ni̠ti̠ ca̠cuentajlay y ni̠ti̠ ca̠mak­ta­kalha. ");
INSERT INTO tocNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jesús chiné ca̠huá­nilh xta­ma̠­kalh­ta­huaké̠n: —Lhúhua cris­tianos tala­má̠­nalh hua̠nti̠ xli̠­ca̠na taaktzan­ka̠­ta­ma̠ni̠t y luu xta̠­chuná qui̠­taxtuy cumu la̠ aktum lanca ca̠tu­huá̠n anta­nícu la̠n huí li̠x­ká̠nat, pero hua̠nchú tasa̠­cuá̠n hua̠nti̠ tax­ka̠­na­má̠­nalh luu ni̠para clhu̠­huacán. ");
INSERT INTO tocNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Huá xpa̠­la­cata cca̠­li̠­hua­niyá̠n pi̠ cali̠­ma̠­ka­tzan­ké̠tit xpu̠­chiná eé tachaná̠n y cahua­nítit pi̠ cama­cá­milh maka­pi­tzí̠n tasa̠­cuá̠n la̠qui̠ laca­pala nata­ma̠­mac­xtu­mi̠ko̠y hua̠ntu̠ aka­huanij lama. ");
INSERT INTO tocNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Maktum quilh­ta­macú Jesús ca̠ta­sá­nilh la̠qui̠ nata­ta­mac­xtumi̠y kalha­cu̠tiy xta­ma̠­kalh­ta­huaké̠n hua̠nti̠ luu anka­lhi̠ná xca̠­ta̠­la­ta­pu̠l­qai̠y. Xlá ca̠má̠x­qui̠lh li̠t­li­hueke la̠qui̠ tla̠n nata­ta­mac­xtuy xes­pi­ri­tucán akska­huiní y la̠qui̠ tla̠n nata­ma̠t­la̠nti̠y ta̠tat­laní̠n xa̠huá hua̠nti̠ xca̠­ka­lhi̠y catu̠­huaj taca­tza­ná­juat. ");
INSERT INTO tocNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Huá u̠ma̠ko̠lh xta­cu­hui­nicán hua̠nti̠ ca̠li̠­ma̠­pa̠­cú­hui̠lh xapós­toles nata­huán: Xapu̠lh Simón hua̠nti̠ na̠ xli̠­ma̠­pa̠­cu­hui̠cán Pedro, chu xta̠Andrés; San­tiago xa̠hua Juan, huá u̠ma̠ko̠lh xca­maná̠n Zebedeo; ");
INSERT INTO tocNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bar­to­lomé chu Tomás; Mateo hua̠nti̠ xma̠­la­ka­xo­ke̠nán im­pues­tos, xa̠huá San­tiago hua̠nti̠ xka­huasa Alfeo; Labeo hua̠nti̠ na̠ xli̠­ma̠­pa̠­cu­hui̠cán Tadeo; ");
INSERT INTO tocNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón hua̠nti̠ xapu̠lh xca̠­ta̠­ta­peksi̠y a̠ma̠ko̠lh lac­chix­cu­huí̠n hua̠nti̠ xca̠­hua­nicán celotes; Judas Isca­riote hua̠nti̠ aca­li̠stá̠n maca­má̠s­ta̠lh Quim­pu̠­chi­nacán Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Aca­li̠stá̠n Jesús ca̠má̠­ca̠xli kalha­cu̠tiy xapós­toles; acxni̠ nia̠ xtaán xlá chiné ca̠huá­nilh: —Ni̠ capítit ca̠ma̠­kalh­chu­hui̠­ni̠­yá̠tit hua̠nti̠ ni̠ judíos, na̠ni̠­para capítit nac xpu̠­la­ta­ma̠ncán samari­tanos. ");
INSERT INTO tocNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Huata mejor huá caca̠­lak­pítit a̠ma̠ko̠lh hua̠nti̠ cumu lá xataaktzan­ka̠­ta­pu̠lí̠n bor­regos tala­má̠­nalh uú nac xapu̠­la­tama̠n Israel. ");
INSERT INTO tocNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Hui­xinín huá caliakchu­hui̠­nan­ti̠­lhátit pi̠ aya tala­ca­tzu­hui̠ma quilh­ta­macú acxni̠ Dios nama̠­tzu­qui̠y xasa̠sti xta­péksi̠t nac ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Xli̠­hua̠k ta̠tat­laní̠n caca̠­ma̠t­la̠n­tí̠tit, caca̠­ma̠­la­kas­ta­cuaní̠tit hua̠nti̠ a̠cu tani̠­má̠­nalh cris­tianos, na̠chuná a̠ma̠ko̠lh hua̠nti̠ ca̠li̠­lama lepraj tzitzi caca̠­ma̠t­la̠n­tí̠tit, na̠ caca̠­mac­ma̠x­tútit hua̠nti̠ ca̠maka­tla­jani̠t xes­pí­ritu akska­huiní. Hui­xinín caj chu­natá mak­lhti̠­na­ni̠­tátit y ni̠tu̠ xoko­ni̠­tátit tamá li̠t­li­hueke, pus na̠chuná chú hui­xinín caj chu­natá caca̠­ma̠t­la̠n­tí̠tit hua̠nti̠ naca̠­cu­chi̠­yá̠tit y ni̠tu̠ caca̠­ma̠­ta̠­jí̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Ni̠túcu cali̠­pítit tumi̠n, ni̠para xla plata, xla oro y na̠ ni̠para xla cobre. ");
INSERT INTO tocNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Na̠ ni̠para huá bolsa cali̠­pítit, na̠ ni̠ cali̠­pítit maca­tiyú̠n milha­ka̠tcán hua̠ntu̠ napu̠­ta­lak­xtu­nu­na̠­pítit, huata caj xma̠n huá cali̠­pítit hua̠ntu̠ lha­ka̠­ni̠­tátit y na̠chuná min­ta­tu̠­nu̠ncán. Na̠ ni̠para huá cali̠­pítit mili̠x­tokcán, caj huá xlá ni̠ tzanka̠y tícu cati­ca̠­ma̠x­quí̠n; porque hua̠nti̠ xli̠­ca̠na scujma juerza mini̠niy pi̠ nama̠­hui̠cán. ");
INSERT INTO tocNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Xa̠huachi anta­nícu nachi­pi­ná̠tit nac aktum ca̠chi­quí̠n capu­tzátit cha̠tum chixcú hua̠nti̠ luu tla̠n xta­pu­huá̠n y antá chú cata­mak­xtéktit nac xchic hasta acxni̠ hui­xinín napi­ná̠tit a̠laca­tunuj ca̠chi­quí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Acxni̠ namac­la­yá̠tit aktum chiqui anta­nícu nata­hui­la­yá̠tit, cachu­hui̠­nántit y caca̠­hua­nítit hua̠nti̠ xalac chiqui xla­cata pi̠ cata­ká­lhi̠lh tapa̠­xu­huá̠n hua̠ntu̠ ma̠sta̠y Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Para antá nac a̠má chiqui tahui­lá̠­nalh hua̠nti̠ tla̠n taca­tzi̠y cris­tianos y ca̠mi­ni̠niy pi̠ nata­ka­lhi̠y a̠má tapa̠­xu­huá̠n, pus cali̠s­qui­nítit Dios xla­cata pi̠ antá caca̠­ta̠­ta­mák­xtekli. Pero para a̠ma̠ko̠lh cris­tianos hua̠nti̠ tahui­lá̠­nalh nac a̠má chiqui ni̠ ca̠mi­ni̠niy nata­ka­lhi̠y tapa̠­xu­huá̠n, pus hui­xinín calac­tla­huátit tamá min­ta­chu­hui̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Para nac aktum chiqui osuchí nac aktum ca̠chi­quí̠n ni̠tlá̠n naca̠t­la­hua­ca­ná̠tit y na̠ ni̠para ca̠kax­pat­ni­pu­tun­ca­ná̠tit a̠má tachu­huí̠n hua̠ntu̠ hui­xinín li̠chu­hui̠­nam­pá̠tit, pus huata hui­xinín la̠li̠­huán catax­tútit nac a̠má chiqui o nac ca̠chi­quí̠n, y acxni̠ natax­tu­yá̠tit caca̠­lac­tin­c­xcántit a̠má pokxni hua̠ntu̠ ca̠lac­ta­huacán nac min­tan­tu̠ncán la̠qui̠ xlacán nataucxilha pi̠ hui­xinín niaj min­cuentajcán para nata­lak­tzanka̠y tama̠­ko̠lh lac­chix­cu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ acxni̠ nalak­chá̠n quilh­ta­macú la̠ta Dios naca̠­ma̠­xo­ko̠ni̠y xli̠­hua̠k cris­tianos, pero hua̠nti̠ tahui­lá̠­nalh nac a̠má ca̠chi­quí̠n a̠tzinú luu lhu̠hua la̠ta nata­pa̠­ti̠nán ni̠xa­chuná a̠ma̠ko̠lh lac­li̠xcáj­nit cris­tianos hua̠nti̠ xta­hui­lá̠­nalh xamaká̠n quilh­ta­macú nac a̠ma̠ko̠lh ca̠chi­quí̠n hua̠ntu̠ xca̠­hua­nicán Sodoma y Go­morra. ");
INSERT INTO tocNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’¡Luu li̠huana̠ cakax­pátit! Aquit cca̠­ma­ca̠má̠n cumu lá lactzu bor­regos nac xlak­sti̠­pa̠ncán lac­li̠­pe̠­cuánit hua­naní̠n la̠páni̠t. Pus huata hui­xinín luu ska­lalh cala­ta­pu̠­lí̠tit chuná cumu la̠ talat­la̠­huán lu̠hua, pero na̠chuna li̠túm xacacsua cumu lá lac­ma̠ntzu paloma. ");
INSERT INTO tocNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Luu cuentaj cat­la­huátit porque caj quim­pa̠­la­cata naca̠­ma­ca­ma̠s­ta̠­ca­ná̠tit nac pu̠ma̠­peksí̠n, hui­xinín naca̠­ke̠s­nok­ca­ná̠tit nac xpu̠­si­cu­lancán judíos. ");
INSERT INTO tocNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Xa̠huachí caj quim­pa̠­la­cata naca̠­li̠­pin­ca­ná̠tit nac xla­ca­ti̠ncán gober­nador osuchí nac xla­catí̠n gobier­no. Huá chuná naqui̠­li̠­taxtuy la̠qui̠ hui­xinín tla̠n naqui­la̠­li̠­chu­hui̠­na­ná̠hu nac xla­ca­ti̠ncán hua̠nti̠ ni̠ judíos. ");
INSERT INTO tocNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Acxni̠ hui­xinín naca̠­ma­ca­ma̠s­ta̠­ca­ná̠tit nac xla­ca­ti̠ncán ma̠pek­si̠­naní̠n ni̠ luu caliaka­ti­yúntit xla­cata lácu nakalh­ti̠­na­ná̠tit osuchi lácu nahua­ná̠tit acxni̠ nata­mak­ta̠­ya­yá̠tit. Porque acxni̠ nalak­chá̠n hora la̠ta lácu hui­xinín nachu­hui̠­na­ná̠tit, Dios naca̠­ma̠x­qui̠yá̠n lacuán tachu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Porque xli̠­ca̠na pi̠ ni̠ hui­xinín cati­chu­hui̠­nántit, huata huá xes­pí­ritu Quin­tla̠­ticán hua̠nti̠ naca̠­pa̠­la­ca­chu­hui̠­naná̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Amá quilh­ta­macú lac­chix­cu­huí̠n nata­la̠­ma­ka­si̠­tzi̠y caj quim­pa̠­la­cata, y hasta nata­ma­ca­ma̠sta̠y xna­ta̠­lancán la̠qui̠ naca̠­mak­ni̠cán; y na̠chuná hua̠nti̠ tahui­lá̠­nalh xca­mancán na̠ nata­ma­ca­ma̠sta̠y la̠qui̠ na̠chuná naca̠t­la­huay; na̠chuná laka­huasán nata­ta̠­la̠­ma­ka­si̠­tzi̠y xtla̠tcán y hasta ma̠n nata­ma­ca­ma̠sta̠y la̠qui̠ naca̠­mak­ni̠cán. ");
INSERT INTO tocNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Xli̠­hua̠k cris­tianos naca̠­si̠­tzi̠­niyá̠n caj quim­pa̠­la­cata, pero hua̠nti̠ luu aksti̠tum naqui­li̠­pa̠­huán hasta la̠tachá ni̠n­co̠cxni pus huá xlá tamá amaj lak­ma̠xtuy xli̠s­tacni. ");
INSERT INTO tocNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Acxni̠ hui­xinín naca̠­pu­tza­sta̠­la­ca­ná̠tit nac aktum ca̠chi­quí̠n huata mejor catza̠­látit y antá capítit nac aktum­li̠túm ca̠chi­quí̠n. Porque laca­tancs cca̠­hua­niyá̠n pi̠ aquit Xata­lac­sacni Chixcú nac­mim­paray acxni̠ hui­xinín nia̠ laka­tza̠­la­ko̠­yá̠tit nahuán a̠ma̠ko̠lh lactzu ca̠chi­qui̠ní̠n hua̠ntu̠ tahui­lá̠­nalh nac xapu̠­la­tama̠n Israel. ");
INSERT INTO tocNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Porque ni̠para cha̠tum hua̠nti̠ caj li̠ma̠­kalh­ta­huáke̠t nalac­pu­huán pi̠ a̠tzinú xlá tali̠­pa̠hu ni̠ xachuná xma̠­kalh­ta­hua­ke̠ná, y ni̠para cha̠tum tasa̠cua nalac­pu­huán pi̠ a̠tzinú xlá tali̠­pa̠hu ni̠xa­chuná xpatrón. ");
INSERT INTO tocNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Amá hua̠nti̠ caj li̠ma̠­kalh­ta­huáke̠t caj xma̠n huá xlá capa̠x­cat­cá­tzi̠lh pi̠ maca­sta̠­lama xma̠­kalh­ta­hua­ke̠ná, y na̠chuná a̠má hua̠nti̠ caj tasa̠cua capa̠x­cat­cá­tzi̠lh pi̠ hua̠ntu̠ lak­cha̠ma xpatrón nac xla­táma̠t juerza na̠ nalak­chá̠n. Huá cca̠­li̠­hua­niyá̠n, para cha̠tum xpu̠­china chiqui li̠ma̠­pa̠­cu­hui̠cán Beel­zebú o xapuxcu akska­huiní, ¿lac­pu­hua­ná̠tit chú hui­xinín pi̠ li̠huaca ni̠ cala̠huá cati­ca̠­hua­ní­calh hua̠nti̠ xlá xli̠­ta­la­ka­pasni? ");
INSERT INTO tocNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Pero hui­xinín ni̠ caca̠­pe̠­cuanítit la̠ta túcu naca̠t­la­hua­niyá̠n cati̠hua cris­tianos caj xpa̠­la­cata ni̠ nata­ma̠t­la̠nti̠y hua̠ntu̠ hui­xinín nahua­ná̠tit, porque ni̠para pu̠lactum tachu­huí̠n hua̠ntu̠ aquit cca̠­hua­ni­ni̠tán caj chu­natá tze̠k cati­táhui para ni̠ juerza naca­tzi̠cán. ");
INSERT INTO tocNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Para acxni̠ ca̠pucsua xuani̠t aquit cca̠­hua­ni­ni̠tán aktum tachu­huí̠n, pus acxni̠ chú ca̠cu­huiní hui­xinín caliakchu­hui̠­nam­pítit; y na̠chuná hua̠ntu̠ caj tze̠k cca̠­hua­ni­ni̠tán, hui­xinín xli̠­ca̠na luu palha la̠ta cali̠­ca̠­ta­sátit nac xca̠ak­sti̠ní̠n ta̠lh­ma̠ná chiqui. ");
INSERT INTO tocNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ni̠ caca̠­pe̠­cuanítit a̠ma̠ko̠lh lac­chix­cu­huí̠n hua̠nti̠ ma̠squi tla̠n naca̠­mak­ni̠yá̠n porque xlacán ni̠lay ca̠ma̠­pa̠­ti̠ni̠y mili̠s­tac­nicán. Huata mejor huá cape̠­cuanítit Dios porque xlá la̠ namak­ni̠ko̠y mimacni kalhi̠­paray li̠t­li­hueke la̠qui̠ aca­li̠stá̠n na̠ tla̠n namacá̠n mili̠s­tacni nac pu̠pa̠tí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Caj luu caca̠ucxílhtit la̠ta ca̠ma̠s­ta̠cán tantiy lactzu spu̠n y ni̠para tzinú tapa­ra̠­xalá li̠s­ta̠cán, pero ma̠squi chuná ni̠para tantum xaní̠n cati­ta­ma̠chá nac tíyat para ni̠ huá chuná nala­cas­quín Quin­tla̠­ticán. ");
INSERT INTO tocNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Huá chuná cca̠­li̠­hua­nimá̠n porque xlá hua̠k catzi̠y, y xa̠huachí hasta ma̠squi miacchi­xitcán hua̠ntu̠ tayá̠­nalh nac miakxa̠­kacán hua̠k tapu̠t­le­ke­ta̠­yani̠t la̠ta kana­tunu. ");
INSERT INTO tocNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Por eso huá chú xpa̠­la­cata cca̠­li̠­hua­niyá̠n ni̠ cape̠­cuántit, Dios naca̠­mak­ta̠­yayá̠n porque a̠tzinú hui­xinín lhu̠hua min­ta­palhcán ni̠xa­chuná hua̠k a̠ma̠ko̠lh lactzu spu̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Huá a̠má chixcú hua̠nti̠ nali̠­ta̠yay nac xlak­sti̠­pa̠ncán cris­tianos pi̠ xli̠­ca̠na qui­li̠­pa̠­huán pus na̠chuná chú aquit na̠ nac­li̠­ta̠­ya­ya̠chá pi̠ xli̠­ca̠na huá qui­lac­scujni nac xla­catí̠n Quin­tla̠t hua̠nti̠ hui­lachá nac akapú̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero hua̠nti̠ ni̠ nali̠­ta̠yay nac xla­ca­ti̠ncán cris­tianos pi̠ xli̠­ca̠na qui­li̠­pa̠­huán pus na̠chuná chú aquit na̠ ni̠ cac­ti­hua­nichá Quin­tla̠t xla­cata pi̠ luu tla̠n qui­lac­scujni xuani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Ni̠ luu calac­pu­huántit hui­xinín para caj xma̠nhuá luu cmini̠t huili̠y tapa̠x­qui̠t nac ca̠quilh­ta­macú, pus aquit ni̠ luu xma̠nhuá cli̠­mini̠t tapa̠x­qui̠t huata na̠ caj cmini̠t huili̠y tala̠­ma­ka­si̠­tzí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Aquit caj la̠m­para cmini̠t la̠ma̠­chipi̠y cris­tianos, huá chuná cli̠­qui­lhuama porque caj quim­pa̠­la­cata cha̠tum kahuasa nata̠­la̠­ma­ka­si̠­tzi̠y xtla̠t, cha̠tum tzuma̠t nata̠­la̠­ma­ka­si̠­tzi̠y xtzí, y cha̠tum pusca̠t nata̠­la̠­ma­ka­si̠­tzi̠y xpu̠­ti­ya̠tzí. ");
INSERT INTO tocNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","La̠ta cha̠­tunu cris­tianos mismo ma̠n xli̠­ta­la­ka­pas­nicán xta̠­la̠­ma­ka­si̠­tzi̠­nacán nahuán y ni̠ cati­la̠ucxilh­pú­tulh. ");
INSERT INTO tocNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Na̠chu­na­li̠tum, para cha̠tum chixcú a̠tzinú ca̠pa̠x­qui̠y xtzí osuchí xtla̠t ni̠xa­chuná cumu la̠ aquit xla­cata aktum catzi̠y naqui­li̠­pa̠­huán, pus huata xlá ni̠lay aquit quin­ta­pek­si̠niy; y na̠chuna li̠túm a̠má hua̠nti̠ a̠tzinú pa̠x­qui̠y xka­huasa osuchí xtzuma̠t ni̠xa­chuná cumu la̠ aquit, xlá ni̠lay quin­ta­pek­si̠niy. ");
INSERT INTO tocNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Y na̠chuná hua̠nti̠ ni̠ aktum catzi̠y nacucay xcruz xla­cata naquis­ta̠­laniy ma̠squi xma­ca­má̠s­ta̠lh xla­táma̠t caj quim­pa̠­la­cata, xlá ni̠lay quin­ta­pek­si̠niy cumu la̠ hua̠nti̠ xli̠­ca̠na qui­lac­scujni. ");
INSERT INTO tocNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Porque a̠má chixcú hua̠nti̠ lak­ma̠x­tu­putún xla­táma̠t uú nac ca̠quilh­ta­macú huata xlá amaj ma̠lak­tzanke̠y, pero hua̠nti̠ nama̠­lak­tzanke̠y xla­táma̠t caj quim­pa̠­la­cata huata xlá amaj ma̠aka­pu̠­taxti̠y nac xla­catí̠n Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Hua̠nti̠ hui­xinín tla̠n naca̠t­la­huayá̠n nac xchic y naca̠­ma­ka­maklh­ti̠­naná̠n pus luu xta̠­chu­na­tiyá cumu la̠m­para aquit qui­maka­maklhti̠­nama; hua̠nchú ti̠ aquit tla̠n quin­tla­huay y qui­maka­maklhti̠nán pus na̠ luu chu­na­tiyá qui̠­taxtuy cumu la̠m­para huá maka­mak­lhti̠­nama Quin­tla̠t hua̠nti̠ qui­ma­ca­mini̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Para tícuya̠ chixcú xta̠­lak­tun­cú­hui̠lh nac xchic cha̠tum pro­feta caj cumu catzi̠y pi̠ huá lac­scuj­nima Dios, xli̠­ca̠na xlá pi̠ na̠ chu­na­tiyá namak­lhti̠nán xtas­káhu nac xla­catí̠n Dios chuná cumu la̠ lak­chá̠n cha̠tum pro­feta. Na̠chu­na­li̠túm hua̠nti̠ nata̠­lak­tun­cu­hui̠y nac xchic cha̠tum chixcú hua̠nti̠ luu tla̠n xta­pu­huá̠n, y cumu xlá chuná nat­la­huay na̠chu­na­tiyá namak­lhti̠nán xtas­káhu cumu la̠ lak­chá̠n cha̠tum chixcú hua̠nti̠ luu tla̠n xta­pu­huá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Y la̠tachá tícuya̠ cris­tiano xca̠­má̠x­qui̠lh ca̠na̠caj pektum má̠ko̠t xas­ka­huihui chú­chut u̠ma̠ko̠lh hua̠nti̠ luu ni̠para túcu xka­satcán tata­siyuy, pero cumu xlacán aquit quin­ta­li̠­pa̠­huán y quin­ta­sta̠­la­ni­má̠­nalh, xli̠­ca̠na cca̠­hua­niyá̠n pi̠ ni̠ caj chu­natá cati­ta­ta­mák­xtekli para ni̠ juerza naca̠­ma̠x­qui̠cán xtas­kahucán nac xla­catí̠n Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Acxni̠ Jesús ca̠ma̠­kalh­chu­hui̠­ni̠­ko̠lh xaka­lha­cu̠tiy xdis­cí­pulos, xlá na̠ la̠li̠­huán táca̠xli y antá alh liakchu­hui̠nán xta­chu­huí̠n Dios nac lactzu ca̠chi­qui̠ní̠n hua̠ntu̠ xca̠­ma̠­peksi̠y a̠má pu̠la­tama̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Cumu Juan Bau­tista chu­nacú xta­nu̠ma nac pu̠la̠­chi̠n, antá xlá catzi̠chá la̠ta lac­lanca li̠cá̠cni̠t ta­scújut xca̠t­la­huama Cristo. Huata xlá ma̠la­ká­cha̠lh maka­pi­tzí̠n xta­ma̠­kalh­ta­huaké̠n anta­nícu xla­ma̠chá, ");
INSERT INTO tocNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","y taka­lhá̠s­quilh: —¿Lácu pi̠ xli̠­ca̠na huix Cristo hua̠nti̠ xli̠­mínit xuani̠t, osuchí nac­ti­ka­lhi̠­ya̠hucú para a̠cu namín hua̠nti̠ luu xax­li̠­ca̠na? ");
INSERT INTO tocNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús chiné ca̠kálh­ti̠lh: —La̠li̠­huán calak­pim­pítit y cahua­nítit Juan hua̠ntu̠ hui­xinín ucxilh­pá̠tit ctla­huama chu hua̠ntu̠ kax­pat­pá̠tit cli̠­chu­hui̠­nama. ");
INSERT INTO tocNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Na̠ cali̠­ta̠­chu­hui̠­nántit pi̠ hua̠nti̠ laka­xo̠kó̠n xta­huani̠t chú aya tla̠n tala­ca­hua̠nán, na̠chuná hua̠nti̠ xta­lu̠n­tu̠­hua­nani̠t chú aya tla̠n tat­la̠­huán, xa̠hua hua̠nti̠ xca̠­ka­lhi̠y a̠má li̠xcáj­nit tzitzi hua­nicán lepra chú hua̠k tatat­la̠n­ti̠­má̠­nalh; na̠chuná hua̠nti̠ xaaka­ta̠pa xta­la­má̠­nalh cris­tianos chú aya tla̠n takax­mata. Y hasta na̠chuná maka­pi­tzí̠n hua̠nti̠ aya xta­ni̠ni̠t chú cca̠­ma̠­la­cas­ta­cuani̠ma nac ca̠li̠ní̠n, y chi̠nchú hua̠nti̠ lak­li̠­ma̠x­kení̠n tala­má̠­nalh cris­tianos pus xlacán cca̠­liakchu­hui̠­na­ni­ma̠­náhu pu̠lactum xasa̠sti tala­ca­pa̠s­tacni hua̠ntu̠ naca̠­lak­ma̠xtuy. ");
INSERT INTO tocNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Pero na̠ cahua­nítit Juan pi̠ luu ca̠na li̠pa̠­xúhu nala­tama̠y a̠má chixcú hua̠nti̠ ni̠ naqui­li̠­lac­la­ta̠yay acxni̠ chú aya li̠huana̠ catzi̠­ni̠ttá tícu aquit. ");
INSERT INTO tocNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Acxni̠ aya taanko̠lh xlac­scujni Juan, huata Jesús huá tzú­culh li̠chu­hui̠nán Juan nac xla­ca­ti̠ncán cris­tianos y chiné ca̠huá­nilh: —Acxni̠ chicá tiqui̠­látit nac desierto, ¿túcu tiqui̠­pu­tzátit, osu túcu qui̠ucxílhtit? ¿Lácu pi̠ qui̠ucxílhtit hui­xinín cha̠tum chixcú hua̠nti̠ xta̠­chuná cumu la̠ kantum ká̠ti̠t hua̠ntu̠ la̠n akxmu̠t­ya̠­huani̠t uú̠n? ");
INSERT INTO tocNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Pus cumu para ni̠huá, ¿túcu chi̠nchú qui̠ucxílhtit? Osuchí, ¿pi̠ qui̠ucxílhtit cha̠tum chixcú hua̠nti̠ luu lacuán lháka̠t li̠lha­ka̠­nani̠t? Porque hui­xinín sta­lanca catzi̠­yá̠tit pi̠ hua̠nti̠ tali̠­lha­ka̠nán lacuán li̠ta­ca̠xta̠y lháka̠t antá xlacán tahui­lá̠­nalh nac xchiccán lac­lanca ma̠pek­si̠­naní̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Bueno, ¿pero túcu chi̠nchú luu qui̠ucxílhtit? ¿Lácu pi̠ xuc­xilh­pu­tu­ná̠tit cha̠tum pro­feta? Cumu para huá qui̠­pu­tzátit pus li̠huaca tla̠n porque aquit luu laca­tancs cca̠­hua­niyá̠n pi̠ xli̠­ca̠na tamá chixcú hua̠nti̠ hui­xinín qui̠ucxílhtit a̠tzinú tlak lanca ma̠x­qui̠­cani̠t xli̠­ta­scújut ni̠xa­chuná cumu la̠ xca̠­ma̠x­qui̠­cani̠t xli̠­tas­cu­jutcán xli̠­hua̠k xalak­maká̠n pro­fetas. ");
INSERT INTO tocNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Porque hua­tiyá tamá Juan Bau­tista hua̠nti̠ li̠chu­hui̠nán Dios nac xta­chu­huí̠n hua̠ntu̠ tatzok­ta­hui­lani̠t nac li̠kalh­ta­huaka anta­nícu chiné huán: Aquit cmacá̠n qui­lac­scujni hua̠nti̠ napu̠­la­niyá̠n, la̠qui̠ xlá naca̠x­tla­hua­ni­ti̠­lhayá̠n min­tiji. ");
INSERT INTO tocNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ la̠ta xli̠­pu̠tum pro­fetas hua̠nti̠ tita­qui̠­lachi nac ca̠quilh­ta­macú ni̠m­para cha̠tum tícu anani̠t hua̠nti̠ a̠tzinú lanca xta­scújut xma̠x­qui̠­cani̠t cumu la̠ xlá Juan Bau­tista. Pero ma̠squi chuná, chú na̠ mili̠­ca­tzi̠tcán pi̠ cati̠hua cris­tiano ma̠squi ni̠tu̠cu xkásat hua̠nti̠ Dios namaka­maklhti̠nán nac xasa̠sti xta­péksi̠t hua̠ntu̠ xli̠­chu­hi̠nán Juan, pus huata namaka­tla­ja­pa­racán Juan porque xlá hasta a̠tzinú liactay naka­lhi̠y xta­scújut. ");
INSERT INTO tocNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Hasta la̠ta titzú­culh akmu­nu̠nún Juan Bau­tista hasta lá ca̠lacchú lhu̠hua hua̠nti̠ talak­tzak­sa­má̠­nalh xla­cata pi̠ juerza nata­ma̠­kan­taxti̠y a̠má lak­táxtut y tata­nu̠­má̠­nalh nac xta­péksi̠t Dios, porque xlacán juerza tat­la­hua­ni­má̠­nalh ni̠ tata­chokoy hasta tla̠n nata­ta­nu̠­ya̠chá. ");
INSERT INTO tocNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Xli̠­hua̠k hua̠nti̠ aya tati̠­tax­tuni̠t pro­fetas xa̠huá a̠má li̠ma̠­peksí̠n hua̠ntu̠ tima̠x­quí̠­calh Moisés, luu acxtum hua̠k hua­tiyá xta­li̠­chu­hui̠­na­má̠­nalh la̠ta lácu Dios xamaj huili̠y xasa̠sti xta­péksi̠t uú nac ca̠quilh­ta­macú, hua̠k chu­na­tiyá timin­ko̠­chitá hasta la̠ u̠tímilh Juan. ");
INSERT INTO tocNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ma̠squi hui­xinín ni̠ luu caca̠­naj­la­pu­tútit quin­ta­chu­huí̠n pero aquit laca­tancs cca̠­hua­niyá̠n pi̠ tamá Juan Bau­tista hua­tiyá a̠má pro­feta Elías hua̠nti̠ tihua­ní­calh o tima̠­lac­nú̠­calh pi̠ namim­paray a̠maktum. ");
INSERT INTO tocNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Hua̠nti̠ taka­lhi̠y xta­ke̠ncán pus cataaká­ta̠ksli eé tachu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Caj túcu xta̠­chuná tla̠n nac­ta̠­ma̠­lac­xtumi̠y u̠ma̠ko̠lh cris­tianos hua̠nti̠ ca̠lacchú quilh­ta­macú tala­má̠­nalh? Pus caj luu xta̠­chuná tali̠­taxtuy cumu la̠ a̠ma̠ko̠lh lactzu camán hua̠nti̠ taka­ma̠­nan­ta­huilay nac plaza y tzucuy talak­qui­lhán xcompañeros: ");
INSERT INTO tocNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Pus ¿túcu luu lacas­qui­ná̠tit? ¡Aquinín aya cca̠­li̠s­ko­li­ni­ni̠tán lac­li̠­pa̠­xúhu tat­lakni xlacan tan­tli̠ní̠n, pero hui­xinín ni̠ tan­tlí̠tit, y na̠ aya cca̠­li̠­quilh­tli̠nín xaya̠ tali̠­pu­huá̠n taquilh­tlí̠n, pero na̠ ni̠para chuná tasátit!” ");
INSERT INTO tocNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Luu xli̠­ca̠na pi̠ chuná li̠tax­tu­yá̠tit hui­xinín hua̠nti̠ ca̠lacchú quilh­ta­macú lapá̠tit, porque aya qui̠­lachi Juan Bau­tista hua̠nti̠ ni̠ lac­xtum xca̠­ta̠­hua̠yán y ni̠ lac­xtum xca̠­ta̠­kotnún cati̠hua cris­tianos la̠qui̠ naca̠­ta̠­pa̠­xu­huay, pero huata hui­xinín kalhtum xuaná̠tit pi̠ huá xka­lhi̠y xta­la­ca­pa̠s­tacni akska­huiní. ");
INSERT INTO tocNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Chú aca­li̠stá̠n cmimpá aquit Xata­lac­sacni Chixcú, aquit lac­xtum ctzú­culh ca̠ta̠­hua̠yán y ca̠ta̠­kotnún cati̠hua cris­tianos la̠qui̠ chuná pu̠tum nac­ca̠­ta̠­pa̠­xu­huay, pero huata chú hui­xinín huam­pa­ra­yá̠tit pi̠ mat luu lanca xakotni y mat luu caj xma̠nhuá cliaka­tiyún la̠ta lácu nacua̠yán, xa̠huachí mat hua̠k quiamigos cca̠t­la­huay hua̠nti̠ tama̠­la­ka­xo­ke̠nán im­pues­tos xa̠huá cati̠hua mak­la̠­ka­lhi̠­naní̠n lac­chix­cu­huí̠n. Pero aquit cca̠­hua­niyá̠n pi̠ la̠ta huí xli̠s­ka­lala Dios antá laca­tancs li̠ta­si­yuma xta­scújut nac xla­táma̠t hua̠nti̠ xli̠­ca̠na aka­ta̠ksma. ");
INSERT INTO tocNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Pus huata Jesús tzú­culh ca̠la­ca­quilh­ni̠­lacá̠n a̠ma̠ko̠lh ca̠chi­qui̠ní̠n anta­nícu xlá xca̠t­la­huani̠t lac­lanca li̠cá̠cni̠t xta­scújut porque a̠ma̠ko̠lh cris­tianos hua̠nti̠ antá xta­hui­lá̠­nalh xlacán ni̠ xta­lak­pa­li̠­má̠­nalh xta­la­ca­pa̠s­tac­nicán xla­cata pi̠ nata­li̠­pa̠­huán Dios y xlá chiné huá: ");
INSERT INTO tocNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Koxu­tacu tihua­ná̠tit hui­xinín cris­tianos hua̠nti̠ la̠nchú hui­látit nac xaca̠­chi­quí̠n Corazín, y na̠chuná hui­xinín hua̠nti̠ hui­látit nac Bet­saida! Porque para a̠má lac­lanca li̠cá̠cni̠t quin­ta­scújut hua̠ntu̠ aquit cca̠t­la­huani̠t nac milak­sti̠­pa̠ncán chuná xti­ca̠t­la­huá­calh xamaká̠n quilh­ta­macú nac xaca̠­chi­quí̠n Tiro y Sidón pus xlacán aya maka̠sá cahuá la̠ta xti­ta­lak­pá­li̠lh xali̠xcáj­nit xta­la­ca­pa̠s­tacni xa̠huachí aya xti­ta­li̠­ma̠­sí­yulh pi̠ tali̠­pu­huani̠t caj xpa̠­la­cata xta­li̠­lha­ká̠­nalh xatzi­tzeke lháka̠t y na̠ xca̠­liac­tla­hua­pu̠x­tú­calh lhcaca. ");
INSERT INTO tocNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pus aquit laca­tancs cca̠­hua­niyá̠n pi̠ acxni̠ nalak­chá̠n quilh­ta­macú la̠ta hua̠k naca̠­ma̠­xo­ko̠­ni̠cán cris­tianos, hui­xinín a̠tzinú luu li̠pe̠cua la̠ta naca̠­ma̠­pa̠­ti̠­ni̠­ca­ná̠tit ni̠xa­chuná a̠ma̠ko̠lh cris­tianos hua̠nti̠ tahui­lá̠­nalh nac xaca̠­chi­quí̠n Tiro y Sidón. ");
INSERT INTO tocNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Y chi̠nchú hui­xinín cris­tianos hua̠nti̠ hui­látit nac xaca̠­chi­quí̠n Caper­naum, ¿hui­xinín ma̠x lac­pu­hua­ná̠tit pi̠ Dios ca̠li̠­ka­lhi̠má̠n lanca mim­pu̠­ta­hui̠lhcán nac akapú̠n? Pus aquit laca­tancs cca̠­hua­niyá̠n pi̠ ni̠chuná, huata mejor anta­nícu luu xapu̠lhmá̠n nac pu̠pa̠tí̠n naca̠­ma­ca­pin­ca­ná̠tit la̠qui̠ antá naxo­ko̠­nu­ná̠tit. Porque para antá nac a̠má ca̠chi­quí̠n hua̠ntu̠ hua­nicán Sodoma xac­ti­ca̠t­lá­hualh lac­lanca li̠cá̠cni̠t quin­ta­scújut hua̠ntu̠ aya lani̠t nac milak­sti̠­pa̠ncán, a̠má lanca ca̠chi­quí̠n luu tla̠n cahuá lama hasta la̠ la̠nchú. ");
INSERT INTO tocNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pero chú laca­tancs cca̠­hua­niyá̠n pi̠ acxni̠ nalak­chá̠n quilh­ta­macú la̠ta naca̠­ma̠­xo­ko̠­ni̠cán xli̠­hua̠k cris­tianos, hui­xinín a̠tzinú lanca tapa̠tí̠n naca̠­lak­cha̠ná̠n ni̠xa­chuná a̠ma̠ko̠lh cris­tianos hua̠nti̠ xalac Sodoma. ");
INSERT INTO tocNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Amá quilh­ta­macú Jesús kalh­ta­hua­ká­nilh Dios y chiné huá: —Papá Dios, cla­ka­chix­cu­hui̠yá̠n porque huix xpu̠­chiná akapú̠n chu ca̠ti­yatni, y cpa̠x­cat­ca­tzi̠­niyá̠n porque huix ca̠ma̠aktze̠­kuili̠ni xatlá̠n min­ta­la­ca­pa̠s­tacni hua̠nti̠ luu lac­ta­li̠­pa̠hu chu hua̠nti̠ lak­ska­lalán lac­chix­cu­huí̠n la̠qui̠ xlacán ni̠ nataaka­ta̠ksa y huata huá ca̠ma̠aka­ta̠k­sni̠tta a̠ma̠ko̠lh lac­chix­cu­huí̠n hua̠nti̠ luu ni̠tu̠cu tuncán xka­satcán la̠qui̠ xlacán nata­ka­lha­kax­matá̠n, ");
INSERT INTO tocNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Papá, luu cli̠­pa̠­xu­huay porque huix chuná lacás­quinti xla­cata pi̠ chuná naqui̠­taxtuy. ");
INSERT INTO tocNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Aca­li̠stá̠n ca̠ta̠­chu­huí̠­nalh cris­tianos y chiné ca̠huá­nilh: —La̠ta túcua kalhi̠y Quin­tla̠t hua̠k qui­ma­ca­ma̠x­qui̠ni̠t. Aquit Xka­huasa Dios y ni̠tícu luu qui­la­ka­pasa tícu aquit huata caj xma̠nhuá Dios catzi̠y pi̠ aquit Xka­huasa. Y na̠chuna li̠túm ni̠tícu luu catzi̠y lácu luu xta­la­ca­pa̠s­tacni Quin­tla̠t Dios huata caj xma̠n que̠cstu aquit cca­tzi̠y cumu aquit Xka­huasa, y na̠ caj xma̠nhuá nala­ka­pasa hua̠nti̠ aquit nac­ma̠­la­ka­pas­ni̠­putún. ");
INSERT INTO tocNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Y chi̠nchú hui­xinín hua̠nti̠ aya ca̠maka­tla­kuani̠tán mila­ta­ma̠tcán luu tuhua maklh­ca­tzi̠­yá̠tit lapá̠tit xta̠­chuná cumu la̠ a̠ cacu­ca­li̠­pítit aktum tzinca tacuca, huata mejor caqui­la̠­lak­míhu aquit la̠qui̠ chuná nac­ca̠­ma̠­ja­xayá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Luu li̠pa̠­xúhu camaka­maklhti̠­nántit quin­ta­scújut hua̠ntu̠ aquit cma̠sta̠y, y na̠ luu tla̠n camaca­sta̠­látit qui­la­táma̠t, porque aquit xli̠­ca̠na pi̠ luu tla̠n cca­tzi̠y y luu xli̠­ca̠na tza­tata qui­nacú; para chuná nala­ta­pa̠­yá̠tit hui­xinín xli̠­ca̠na naca̠­ma̠­ja­xa­yá̠tit mili̠s­tac­nicán. ");
INSERT INTO tocNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Porque a̠má ta­scújut hua̠ntu̠ aquit cca̠­ma̠x­qui̠yá̠n ni̠para tzinú tuhua tla­huacán, y na̠chuná a̠má tacuca hua̠ntu̠ aquit nac­ca̠­ma̠x­qui̠yá̠n ni̠para tzinú tzinca le̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Maktum quilh­ta­macú acxni̠ hua̠k judíos xta­jaxa Jesús chu hua̠nti̠ xta­sta̠­la­ni­má̠­nalh xta­ti̠­pun­tax­tu­má̠­nalh anta­nícu la̠n xchan­cani̠t trigo. Ama̠­ko̠lh xdis­cí­pulos Jesús taúcxilhli a̠má trigo pero cumu aya xta­tzin­c­sni̠y xlacán tzú­culh tai̠y xta­huácat, xta­lak­pekxa y xta­hua­ni̠niy xtalhtzi. ");
INSERT INTO tocNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Maka­pi­tzí̠n fariseos hua̠nti̠ na̠ antá xta­mak­sta̠­la­má̠­nalh xlacán taúcxilhli hua̠ntu̠ a̠ma̠ko̠lh dis­cí­pulos xtat­la­hua­má̠­nalh y chiné tahuá­nilh Jesús: —¿Túcu xpa̠­la­cata la̠ a̠má min­ta­ma̠­kalh­ta­huaké̠n ni̠tu̠cu taliucxilh­ni̠nán porque xlacán tat­la­hua­má̠­nalh aktum ta­scújut hua̠ntu̠ ni̠ xli̠t­la­huatcán la̠nchú eé quilh­ta­macú? ");
INSERT INTO tocNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesús chiné ca̠kálh­ti̠lh: —¿Lácu pi̠ ne̠cxni a̠li̠kalh­ta­hua­ka­yá̠tit hui­xinín xta­chu­huí̠n Dios anta­nícu li̠chu­hui̠nán hua̠ntu̠ tit­lá­hualh rey David acxni̠ xlá xca̠­ta̠­tzin­csni̠ma xcompañeros? ");
INSERT INTO tocNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Antá huán pi̠ tamá rey tánu̠lh nac xpu̠­si­culan Dios y hualh a̠má xata­si­cu­la­na̠t­láhu cax­ti­lá̠n­chahu hua̠ntu̠ ni̠para tzinú xlí̠­huat xuani̠t na̠ ni̠para huá xcompañeros, pero xlá acxtum ca̠tá̠­hualh, huata caj xma̠nhuá xli̠­huatcán xuani̠t cura. ");
INSERT INTO tocNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Osuchí, ¿na̠ nia̠ li̠kalh­ta­hua­ka­yá̠tit nac xlibro Moisés anta­nícu huan pi̠ a̠ma̠ko̠lh cura hua̠nti̠ tas­cuj­má̠­nalh nac xpu̠­si­culan Dios xlacán ni̠ tajaxa ma̠squi lak­cha̠ni̠t quilh­ta­macú la̠ta jaxcán, pero tamá ni̠ li̠huancán? ");
INSERT INTO tocNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pus aquit laca­tancs cca̠­hua­niyá̠n cumu para hua­tuní̠n ca̠li̠­mak­xteka Dios catás­cujli ma̠squi acxni̠ lak­cha̠ni̠t quilh­ta­macú la̠ta jaxcán, pus xali̠­huacá aquit cka­lhi̠y li̠ma̠­peksí̠n para la̠ta túcu nac­tla­huay eé quilh­ta­macú y ni̠xa­chuná hua̠nti̠ tas­cuja nac pu̠si­culan. ");
INSERT INTO tocNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Luu xli̠­ca̠na pi̠ hui­xinín nia̠ aka­ta̠k­sá̠tit hua̠ntu̠ huam­putún xli̠­ma̠­peksí̠n Dios anta­nícu chiné tatzok­ta­hui­lani̠t nac li̠kalh­ta­huaka: “Ni̠ cla­cas­quín pi̠ caj xma̠nhuá naqui­la̠­li̠­la­ka­chix­cu­hui̠­yá̠hu min­ta­ka­lhi̠ncán hua̠ntu̠ hui­xinín ca̠mak­ni̠­yá̠tit, pus huata a̠tzinú luu tla̠n naqui­la̠­li̠­la­ka­chix­cu­hui̠­yá̠hu xla­cata pi̠ nala̠­la­ka­lha­ma­ná̠tit cha̠tum a̠cha̠tum.” Cumu para xli̠­ca̠na xaka­tá̠k­stit xta­chu­huí̠n Dios ni̠tu̠ xca̠­li̠­hua­nítit y ni̠ xca̠­ma̠­xo­ko̠­ni̠­pu­túntit a̠ma̠ko̠lh koxu­taní̠n cris­tianos hua̠nti̠ ni̠tu̠ le̠nko̠y cuenta. ");
INSERT INTO tocNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Y na̠chuna li̠túm luu mili̠­ca­tzi̠tcán pi̠ aquit Xata­lac­sacni Chixcú cka­lhi̠y li̠ma̠­peksí̠n la̠qui̠ nac­ca̠­huaniy cris­tianos la̠ta túcu tla̠n natat­la­huay nac eé quilh­ta­macú acxni̠ jaxcán. ");
INSERT INTO tocNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesús la̠li̠­huán alh y antá cha̠lh nac xpu̠­si­cu­lancán judíos hua̠ntu̠ xuí nac a̠má actzu ca̠chi­quí̠n y antá xlá tánu̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Na̠ antá xta­nu̠ma cha̠tum chixcú hua̠nti̠ csca̠c­ni­ko̠ni̠t xmacán. Cumu hua̠nti̠ luu ma̠rí xta­si̠­tzi̠niy Jesús xlacán xta­mac­la­ni­putún hua̠ntu̠ tla̠n nata­li̠­ya̠­huay y nata­ma̠­la­capu̠y, y cha̠tum chiné kalhás­quilh: —¿Lácu huix huana, pi̠ lak­chá̠n para nama̠t­la̠n­ti̠cán cha̠tum ta̠tatlá acxni̠ lak­cha̠ni̠t quilh­ta­macú la̠ta jaxcán? ");
INSERT INTO tocNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Xlá chiné ca̠kálh­ti̠lh: —Chi̠nchú para hui­xinín kalhi̠­yá̠tit tantum mibor­re­gojcán, para xlá na̠ pokx tamo­kosa nac aktum pozo, ma̠squi luu lak­cha̠ni̠t quilh­ta­macú la̠ta jaxcán, ¿lácu pi̠ antá cahuá namak­xte­ká̠tit pi̠ ni̠ la̠li̠­huán cati­ma̠­cu­tútit? ");
INSERT INTO tocNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pus aquit laca­tancs cca̠­hua­niyá̠n pi̠ a̠tzinú kalhi̠y lhu̠hua xta­palh cha̠tum cris­tiano ni̠xa­chuná tantum bor­rego. Pus huá chú xpa̠­la­cata cca̠­li̠­hua­niyá̠n pi̠ lak­chá̠n nat­la­hua­yá̠tit hua̠ntu̠ tla̠n ma̠squi lak­cha̠ni̠t quilh­ta­macú la̠ta jaxcán. ");
INSERT INTO tocNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jesús huá­nilh a̠má chixcú hua̠nti̠ csca̠c­ni­ko̠ni̠t xmacán: —Huix cuanimá̠n, cas­tonkti mimacán. Acxni̠ xlá stonkli xmacán xli̠­ca̠na pi̠ li̠huana̠ tat­la̠n­tí̠­nilh chuná cumu la̠ makatu. ");
INSERT INTO tocNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ama̠­ko̠lh fariseos tasí̠­tzi̠lh y tzú­culh tali̠­lac­chu­hui̠nán la̠ta lácu natat­la­huay la̠qui̠ nata­makni̠y Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús cátzi̠lh hua̠ntu̠ xta­la­ca­pa̠s­tac­má̠­nalh fariseos huata xlá tatam­pú̠x­tulh y alh a̠laca­tunu. Luu lhu̠hua cris­tianos ta­sta̠­lá­nilh y xli̠­hua̠k hua̠nti̠ xca̠­ka­lhi̠y tajátat xlá xca̠­ma̠t­la̠nti̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Acxni̠ xlá xca̠­ma̠t­la̠nti̠y xca̠­huaniy xla­cata pi̠ ni̠tícu cata­li̠­ta̠­chu­huí̠­nalh tícuya̠ chixcú xla̠ xuani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Umá hua̠ntu̠ xqui̠­tax­tuma nac xla­táma̠t Jesús huá chuná lí̠lalh la̠qui̠ li̠kan­táx­tulh hua̠ntu̠ tili̠­chu­huí̠­nalh xamaká̠n quilh­ta­macú pro­feta Isaías acxni̠ chiné huá: ");
INSERT INTO tocNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Aquit cca̠­ma̠­la­ka­cha̠­nimá̠n qui­lac­scujni hua̠nti̠ clac­sacni̠t. Aquit luu cpa̠x­qui̠y y luu xli̠­ca̠na cli̠­pa̠­xu­huay caj hua̠ntu̠ xla­cata. Aquit nac­ma̠x­qui̠y xli̠­hua̠k xli̠t­li­hueke quiespí­ritu chu quin­ta­la­ca­pa̠s­tacni la̠qui̠ xlá chuná naliakchu­hui̠nán pi̠ hua̠ntu̠ tla̠n cla­cas­quín nata­la­tama̠y xli̠­hua̠k cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Xlá ni̠ la̠n­túcu catiaklhu̠­huá̠t­nalh, na̠ ni̠para ma̠rí cati­ma̠­ca̠­tá­si̠lh, y ni̠ palha catiakchu­hui̠­nan­tá̠­yalh nac ca̠ti­ji̠ní̠n xla­cata hua̠k cris­tianos nata­kax­matniy. ");
INSERT INTO tocNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Xlá li̠pa̠­xúhu namak­ta̠­yalé̠n hua̠nti̠ ni̠ kalhi̠y li̠t­li­hueke xta̠­chuná cumu la̠ kantum ká̠ti̠t hua̠ntu̠ talac­chun­ta­ta­hui­lani̠t y lak­tzan­ka̠ni̠t xla­táma̠t, y na̠ ni̠para cati­lac­tla­huá­nilh xta­la­ca­pa̠s­tacni a̠má hua̠nti̠ a̠takalá li̠pa̠­huán, juerza nat­la­huaniy pi̠ li̠huana̠ cata­ca̠x­táhui hua̠ntu̠ xatlá̠n xta­la­ca­pa̠s­tacni Dios uú nac ca̠quilh­ta­macú, ");
INSERT INTO tocNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","y xa̠huachí xli̠­hua̠k cris­tianos xala cani̠hua ca̠chi­qui̠ní̠n nata­li̠­pa̠­huán y nata­kalh­ka­lhi̠­ta­huilay, porque nata­ca­tzi̠y pi̠ huá naca̠­lak­ma̠xtuy. ");
INSERT INTO tocNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Maktum quilh­ta­macú Jesús li̠mi­ní­calh cha̠tum chixcú ko̠ko y laka­xo̠ko xuani̠t; huá xlá chuná xlani̠t porque xmaka­tla­jani̠t xes­pí­ritu akska­huiní. Jesús ma̠t­lá̠n­ti̠lh; acxni̠ chú xlá cuchi̠­ko̠lh a̠má chixcú tla̠n laca­huá̠­nalh y na̠ tla̠n chu­huí̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Xli̠­hua̠k cris­tianos cacs tali̠­la­cáhua hua̠ntu̠ xlá tlá­hualh y chiné táhua: —¿Pi̠ huá cahuá eé chixcú a̠má tali̠­pa̠hu xli̠­ta­la­ka­pasni rey David hua̠nti̠ xli̠­mínit xuani̠t? ");
INSERT INTO tocNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pero acxni̠ a̠ma̠ko̠lh fariseos taka­lha­káx­matli hua̠ntu̠ xlacán xta­qui­lhuamá̠­nalh xlacán chiné táhua: —Eé chixcú tla̠n ca̠ta­mac­xtuy xes­pi­ri­tucán akska­huiní porque xlá huá ta̠s­cujma y li̠pa̠­huán Beel­zebú hua̠nti̠ xapuxcu diablo, y huá ma̠x­qui̠ni̠t xli̠t­li­hueke. ");
INSERT INTO tocNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Cumu Jesús hua̠k xca­tzi̠y hua̠ntu̠ xlacán xta­lac­pu­hua­má̠­nalh xlá chiné ca̠huá­nilh: —Hui­xinín catzi̠­yá̠tit pi̠ la̠tachá tícuya̠ xana­puxcún ma̠pek­si̠­naní̠n xalac aktum lanca pu̠la­tama̠n para xlacán caj nata­ta­paj­pi­tziy hua̠nti̠ ta­sta̠­la­ni­má̠­nalh y sac­stucán natzucuy tala̠­la­ca­ta­huacay, pus chuná ni̠lay tapa­lhi̠y a̠má pu̠ma̠­peksí̠n huata caj nata­la̠­lac­tla­hua­ya̠­huáy. Y na̠chuná para aktum ca̠chi­quí̠n osuchí nac aktum chiqui para hua­tiyá la̠ma­ka­si̠­tzi̠­hui­lá­calh, ni̠lay maka̠s cati­ta­ta­pá­lhi̠lh huata caj nata­lac­la­ta̠yay. ");
INSERT INTO tocNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Pus na̠chuná chú cumu para huá diablo ta̠la̠­ta­mac­xtuy akska­huiní, ¿lácu chú tla̠n maka̠s nali̠­ta­pa­lhi̠y xli̠­ma̠­peksí̠n akska­huiní? ");
INSERT INTO tocNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Hui­xinín huántit pi̠ aquit cca̠­ta­mac­xtuy xes­pi­ri­tucán akska­huiní porque mat huá qui­ma̠x­qui̠ni̠t xli̠t­li­hueke Beel­zebú hua̠nti̠ luu xapuxcu diablo. Pus cumu para xli̠­ca̠na chuná, chi̠nchú a̠ma̠ko̠lh hua̠nti̠ min­ta­ma̠­kalh­ta­hua­ke̠ncán y hua̠nti̠ ca̠ta̠­la­pu̠­layá̠n, ¿tícu xlá ca̠ma̠x­qui̠y li̠t­li­hueke la̠qui̠ na̠ tla̠n nata­ta­mac­xtuy xes­pi­ri­tucán akska­huiní? Pus caj huá xpa̠­la­cata xlacán tali̠­ma̠­siyuy pi̠ hui­xinín xli̠­ca̠na luu mákat aktzan­ka̠­yá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pero huata aquit cca̠­ta­mac­xtuy xes­pi­ri­tucán akska­huiní porque huá Dios qui­ma̠x­qui̠ni̠t xes­pí­ritu chu xli̠t­li­hueke, y na̠ huá chú u̠má laca­tancs li̠ta­siyuy pi̠ a̠má xasa̠sti xli̠­ma̠­peksí̠n Dios hua̠ntu̠ nahuili̠y uú nac ca̠quilh­ta­macú aya tzu­cu­ni̠ttá kan­taxtuy nac mila­ta­ma̠tcán. ");
INSERT INTO tocNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Na̠chu­na­li̠túm, ¿lácu nat­la­huacán nata­nu̠­ca­na̠chá nac xchic cha̠tum tli­hueke chixcú la̠qui̠ namak­ka­lha̠nán para ni̠ pu̠lh namaka­tla­jacán y li̠huana̠ nachi̠­hui­li̠cán? Cumu para chuná nat­la­huacán pus chuná namak­ka­lhan­ko̠cán pu̠tum hua̠ntu̠ xlá kalhi̠y. Pus luu xta̠­chuná chú cumu la̠ aquit cmaka­tla­jani̠t akska­huiní. ");
INSERT INTO tocNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Na̠ chuná chú hua̠nti̠ ni̠ aquit quin­ta̠­ta̠yay tamá caj qui­lak­si̠­tzi̠niy hua̠ntu̠ aquit cli̠s­cujma, y na̠chuná hua̠nti̠ ni̠ acxtum quin­ta̠­ma̠­macx­tumi̠y cris­tianos la̠qui̠ aquit nac­ca̠­lak­ma̠xtuy pus huata tamá xlá caj ca̠ma̠­paj­pi­tzima la̠qui̠ li̠huaca nata­lak­tzanka̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Pus huá xpa̠­la­cata cca̠­li̠­hua­niyá̠n pi̠ xli̠­hua̠k cris­tianos tla̠n naca̠­ma̠­tzan­ke̠­na­nicán xli̠­lhu̠hua xta­la̠­ka­lhi̠ncán y na̠chuná pu̠tum hua̠ntu̠ ni̠tlá̠n tati­chu­hui̠­nani̠t, pero hua̠nti̠ cala̠huá nali̠­kalh­ka­ma̠nán hua̠ntu̠ laca­tancs li̠ma̠­la­ca­hua̠­ni̠ma Espíri­tu Santo pus hua̠nti̠ chuná nat­la­huay ni̠lay cati­ma̠­tzan­ke̠­na­ní­calh. ");
INSERT INTO tocNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Y na̠chuná a̠má chixcú hua̠nti̠ cala̠huá xqui­li̠­kalh­ka­má̠­nalh aquit Xata­lac­sacni Chixcú, juerza ma̠x tla̠n nama̠­tzan­ke̠­na­nicán xta­la̠­ka­lhí̠n cumu caj ni̠ catzi̠y, pero hua̠nti̠ cala̠huá li̠­xcájnit tachu­huí̠n nali̠­kalh­ka­ma̠nán hua̠ntu̠ xlá luu laca­tancs catzi̠y pi̠ huá xta­scújut Espíri­tu Santo, xlá ni̠lay cati­ma̠­tzan­ke̠­na­ní­calh antá uú nac ca̠quilh­ta­macú y na̠ ni̠para antá nac a̠má ca̠quilh­ta­macú hua̠ntu̠ timi­majcú. ");
INSERT INTO tocNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Para akatum quihui tla̠n, pus tuncán tala­ka­pasa porque na̠ luu lacuán tahuacay xta­huácat; pero para akatum quihui ni̠tlá̠n, na̠chuná ni̠tlán o ni̠ lacuán tahuacay xta­huácat; porque akatum quihui huá li̠ta­la­ka­pasa xta­huácat. ");
INSERT INTO tocNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Aquit luu laca­tancs cca̠­la­ka­pasá̠n porque hui­xinín ma̠ri akska­hui­na­ná̠tit, ¡luu xta̠­chuná min­ka­satcán cumu lá lac­li̠­xcájnit lu̠hua hua̠ntu̠ tze̠k tax­canán! ¿Lácu chú nala­yá̠tit nali̠­chu­hui̠­na­ná̠tit lacuán tachu­huí̠n para antá nac mina­cujcán luu xli̠­ca̠na li̠xcáj­nit li̠ca­tzi̠­yá̠tit? Porque cha̠tum chixcú huá li̠chu­hui̠nán nac xquilhni hua̠ntu̠ xta­la­ca­pa̠s­tacni kalhi̠y nac xnacú. ");
INSERT INTO tocNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Amá chixcú hua̠nti̠ luu tla̠n xta­pu­huá̠n huá xlá li̠chu­hui̠nán hua̠ntu̠ lacuán tachu­huí̠n porque hua̠k huá huí nac xnacú; pero hua̠nti̠ luu li̠xcáj­nit xta­pu­huá̠n huá xlá li̠chu­hui̠nán hua̠ntu̠ lac­li̠xcáj­nit porque hua̠k huá tu̠ li̠xcáj­nit huí nac xnacú. ");
INSERT INTO tocNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pero aquit laca­tancs cca̠­hua­niyá̠n pi̠ acxni̠ nalak­chá̠n quilh­ta­macú la̠ta naca̠­ma̠­xo­ko̠­ni̠cán cris­tianos, xli̠­hua̠k la̠ta cha̠­tunu cris­tianos nata­ma̠sta̠y cuenta la̠ta lácu tati­kalh­pa­la­chu­hui̠­nani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Porque caj xpa̠­la­cata la̠ta kalha­tunu min­ta­chu­hui̠ncán hua̠ntu̠ naca̠­ma̠­ka­lha­pa­li̠­ca­ná̠tit hui­xinín naca̠­pu­tza̠­na­ni­ca­ná̠tit, y chuná chú naca̠­li̠lh­ca̠­ca­ná̠tit para ni̠tu̠ li̠pi­ná̠tit cuenta osuchí juerza naxo­ko̠­nu­ná̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Maktum quilh­ta­macú maka­pi­tzí̠n fariseos chu xma̠­kalh­ta­hua­ke̠­nacán judíos chiné tahuá­nilh Jesús: —Ma̠kalh­ta­hua­ke̠ná, aquinín cla­cas­qui­ná̠hu pi̠ huix xtlahua aktum lanca li̠cá̠cni̠t ta­scújut la̠qui̠ xac­liucxilhwi pi̠ xli̠­ca̠na Dios maca­mi­ni̠tán. ");
INSERT INTO tocNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús chiné ca̠kálh­ti̠lh: —Pa̠x­ca­tacu tihua­ná̠tit hui­xinín cris­tianos hua̠nti̠ la̠nchú lapá̠tit eé quilh­ta­macú porque xli̠­ca̠na pi̠ luu lac­li̠xcáj­nit min­ta­pu­hua̠ncán, hui­xinín lacas­qui­ná̠tit cac­tlá­hualh aktum lanca li̠cá̠cni̠t ta­scújut la̠qui̠ mat naqui­la̠­li̠­pa̠­hua­ná̠hu. Pero aquit ni̠tu̠ cac­ti­ca̠­li̠­ma̠­la­kas­ta̠ní̠n hua̠ntu̠ hui­xinín ucxilh­pu­tu­ná̠tit, huata mejor caj huá nac­ca̠­li̠­ma̠­la­ca­hua̠­ni̠yá̠n aktum ta­scújut xta̠­chuná hua̠ntu̠ Dios tit­lá­hualh nac xla­táma̠t pro­feta Jonás. ");
INSERT INTO tocNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Pus chuná cumu la̠ Jonás táju̠lh aktutu quilh­ta­macú y aktutu tzi̠sní nac xpu̠­lacni a̠má lanca squi̠ti, na̠chuná chú aquit Xata­lac­sacni Chixcú aktutu quilh­ta­macú y aktutu tzi̠sní nac­taju̠y nac xtampú̠n tíyat. ");
INSERT INTO tocNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Acxni̠ nalak­chá̠n quilh­ta­macú la̠ta Dios naca̠­ma̠­xo­ko̠ni̠y cris­tianos, a̠ma̠ko̠lh cris­tianos hua̠nti̠ xamaká̠n quilh­ta­macú xta­hui­lá̠­nalh nac xaca̠­chi­quí̠n Nínive xlacán nata­ta̠yay nac xla­catí̠n Dios y naca̠­ma̠­la­ca­pu̠yá̠n hui­xinín, porque acxni̠ xlá Jonás ca̠liakchu­hui̠­ná­nilh xta­chu­huí̠n Dios xlacán tita­lak­pá­li̠lh xali̠xcáj­nit xta­la­ca­pa̠s­tac­nicán; huá chú hua̠ntu̠ hui­xinín ni̠lay tla­hua­yá̠tit ma̠squi xli̠­ca̠na la̠nchú uú ca̠ta̠­layá̠n cha̠tum hua̠nti̠ a̠tzinú lanca xla­ca­tzúcut ni̠xa­chuná la̠ Jonás. ");
INSERT INTO tocNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Na̠ chuná a̠má lanca reina hua̠nti̠ xma̠­pek­si̠nán nac Sur na̠ nata̠yay nac xla­catí̠n Dios acxni̠ naca̠­ma̠­xo­ko̠­ni̠cán xli̠­hua̠k cris­tianos hua̠nti̠ tala­má̠­nalh ca̠lacchú eé quilh­ta­macú, a̠má reina na̠ naca̠­ma̠­la­ca­pu̠yá̠n porque ma̠squi luu mákat xuani̠t nac xca̠­chi­quí̠n xlá juerza tímilh la̠qui̠ nakax­matniy xta­chu­huí̠n la̠ta xka­lhi̠y xli̠s­ka­lala xamaká̠n rey Salo­món, pero hui­xinín ni̠para tzinú qui­la̠­kax­mat­ni­pu­tu­ná̠hu ma̠squi uú ca̠ta̠­chu­hui̠­namá̠n cha̠tum hua̠nti̠ a̠tzinú lanca xla­ca­tzúcut ni̠xa­chuná cumu la̠ a̠má rey Salo­món. ");
INSERT INTO tocNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Acxni̠ xes­pí­ritu akska­huiní ma̠mak­xte­kecán cha̠tum chixcú xlá an putzay a̠laca­tunu anta­nícu tla̠n nata­huilay y an lata̠k­chokoy anta­nícu mákat la̠qui̠ antá najaxa. Pero huata acxni̠ ni̠ maclay chiné lac­pu­huán: ");
INSERT INTO tocNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Huata mejor nac­tas­pit­paray nac quín­chic anta nícu ctax­tu­ni̠­tanchá.” Acxni̠ chú xlá chim­paray, ma̠nok­lhuy a̠má chixcú cumu la̠ aktum chiqui hua̠ntu̠ caj chu­natá yá y ni̠tu̠ hui­lá­calh xa̠huachí li̠huana̠ ma̠ca̠­qui̠­cani̠t y palh­nan­cani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Huata xlá la̠li̠­huán an ca̠tiyay a̠kalha­tujún xcompañeros hua̠nti̠ a̠tzinú luu lac­li̠xcáj­nit tali̠­ca­tzi̠y y antá pu̠tum tata­huilay nac xla­táma̠t a̠má chixcú. Huá chú a̠má chixcú hua̠nti̠ xtat­la̠n­ti̠ni̠t, chú a̠tzinú luu li̠xcáj­nit huan xta­pu­huá̠n ni̠chuná la̠ xapu̠lh. Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ na̠ hua̠k chuná naak­spu­la­yá̠tit hui­xinín hua̠nti̠ la̠nchú lapá̠tit eé quilh­ta­macú porque xli̠­ca̠na pi̠ ni̠lay qui­la̠­li̠­pa̠­hua­ná̠hu. ");
INSERT INTO tocNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús chu­nacú xca̠­ma̠­kalh­chu­hui̠­ni̠ma cris­tianos acxni̠ tachilh xtzí chu maka­pi­tzí̠n xli̠­ta­la­ka­pasni xlacán xta­ta̠­chu­hui̠­nam­putún y antá tata̠­yachá nac quilhtí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Cha̠tum chixcú huá­nilh Jesús: —Mintzí chu maka­pi­tzí̠n mili̠­ta­la­ka­pasni uú tala­yá̠­nalh nac quilhtí̠n, mat tata̠­chu­hui̠­nam­pu­tuná̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pero huata xlá chiné kálh­ti̠lh hua̠nti̠ chuná ma̠ca­tzí̠­ni̠lh: —¿Tícu quintzí, y tícu qui­li̠­ta­la­ka­pasni? ");
INSERT INTO tocNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Huata xlá huá ca̠lak­lá­ca̠lh xdis­cí­pulos y chiné huá: —Huá u̠ma̠ko̠lh quintzí xa̠huá qui­li̠­ta­la­ka­pasni. ");
INSERT INTO tocNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Porque la̠tachá tícuya̠ cris­tiano hua̠nti̠ natat­la­huay xta­pa̠­xu­huá̠n Quin­tla̠t hua̠nti̠ hui­lachá nac akapú̠n xli̠­ca̠na pi̠ huá tama̠­ko̠lh qui­li̠­ta­la­ka­pasni xa̠huá quintzí. ");
INSERT INTO tocNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Hua­tiyá a̠má quilh­ta­macú Jesús táca̠xli y alh nac pupunú la̠qui̠ antá naca̠­ma̠­kalh­chuhu­hui̠ni̠y cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Pero cumu luu lhu̠hua la̠ta tata­mac­xtú­mi̠lh anta­nícu xlá xuí mejor táju̠lh nac aktum barco; antá culucs táhui y xa̠maka­pi­tzí̠n la̠ta xli̠­lhu̠hua antá tatá̠­yalh nac xquilhtú̠n chú­chut la̠qui̠ nata­kax­matniy xta­chu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jesús lhu̠hua hua̠ntu̠ ca̠li̠­ma̠­kalh­chu­huí̠­ni̠lh, y na̠ ca̠huá­nilh eé takalh­chu­huí̠n: —Maktum quilh­ta­macú cha̠tum cha­na̠ná alh chan xatalhtzi xli̠­chánat. ");
INSERT INTO tocNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Acxni̠ xlá xcha­na̠­nan­ti̠­lhay maka­pi­tzí̠n xli̠­chánat tata­ma̠chá nac tiji; caj li̠puntzú taminchá lactzu spu̠n y tasa­cuaqui̠­ko̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Maka­pi­tzí̠n xli̠­chánat tata­ma̠chá nac ca̠chi­huixni anta­nícu ni̠tu̠cu xka­lhi̠y tíyat. Ama̠­ko̠lh li̠chánat pala pulhli porque ni̠ lhu̠hua xuani̠t tíyat, ");
INSERT INTO tocNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","pero acxni̠ tax­tuchi chi­chiní y li̠pe̠cua tzú­culh akchi­chín pala sca̠cli porque ni̠tu̠cu xma̠­ti̠­ju̠ni̠t xtan­káxe̠k. ");
INSERT INTO tocNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Maka­pi­tzí̠n xli̠­chánat tata­ma̠chá nac ca̠lh­tu­cuní̠n; a̠má lhtucú̠n la̠li̠­huán stacli y ma̠lan­ka̠­ko̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pero huata maka­pi­tzí̠n xli̠­chánat tata­ma̠chá nac xatlá̠n tíyat y acxni̠ tás­tacli luu lhu̠hua tahuá­calh xta­huácat; maka­pi­tzí̠n tachaná̠n huí tu̠ xka­lhi̠y ma̠x cumu aktum ciento xtalhtzi caj la̠ta akatum xaquihui, maka­pi­tzí̠n cumu tutum­puxám y maka­pi­tzí̠n ma̠x cumu puxa­ma­cá̠hu caj la̠ta aka­tunu tachaná̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","¡Para hui­xinín kalhi̠­yá̠tit min­ta­ke̠ncán pus li̠huana̠ cakax­páttit la̠qui̠ naaka­ta̠k­sá̠tit hua̠ntu̠ cuani­putún! ");
INSERT INTO tocNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Caj li̠puntzú a̠ma̠ko̠lh xta­ma̠­kalh­ta­huaké̠n Jesús talak­ta­la­ca­tzú­hui̠lh anta­nícu xlá xuí y chuné taka­lhás­quilh: —Ma̠kalh­ta­hua­ke̠ná, ¿túcu xpa̠­la­cata acxni̠ huix ca̠ma̠­kalh­chu­hui̠­ni̠ya cris­tianos catu̠huá ca̠ta̠­ma̠­la­cas­tuc­niya min­ta­chu­huí̠n, porque huix catzi̠ya pi̠ tzinú tuhua naaka­ta̠k­scán? ");
INSERT INTO tocNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Xlá chiné ca̠kálh­ti̠lh: —Hui­xinín xli̠­ca̠na pi̠ Dios ca̠ma̠­ca­tzi̠­ni̠­pu­tuná̠n la̠qui̠ naaka­ta̠k­sá̠tit la̠ta lácu xlá laca­pa̠s­tacni̠t nahuili̠y xasa̠sti xta­péksi̠t uú nac ca̠quilh­ta­macú, pero huá la̠ta xli̠­hua̠k hua̠nti̠ ni̠ quin­ta­sta̠­laniy, xlacán ni̠lay taaka­ta̠ksa lácu luu naqui̠­taxtuy. ");
INSERT INTO tocNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Porque hua̠nti̠ lak­tzaksay aka­ta̠ksa a̠má xatlá̠n tala­ca­pa̠s­tacni hua̠ntu̠ kalhi̠y a̠tzinú nama̠x­qui̠­cancú y a̠tzinú hua̠k naka­lhi̠y; pero hua̠nti̠ ni̠ lak­tzak­sa­putún aka­ta̠ksa hua̠ntu̠ kalhi̠y xlá namak­lhti̠­ko̠cán hasta ma̠squi caj xma̠n huá hua̠ntu̠ kalhi̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Pus huá xpa̠­la­cata cca̠­li̠­ta̠­ma̠­la­cas­tucniy catu̠huá hua̠ntu̠ tzinú tuhua nata­liaka­ta̠ksa acxni̠ aquit cca̠­ma̠­kalh­chu­hui̠ni̠y, y ma̠squi takax­mata quin­ta­chu­huí̠n chu­na­tiyá tata­mak­xteka cumu la̠m­para ni̠tu̠ takax­mat­má̠­nalh; ma̠squi xlacán taucxilh­má̠­nalh hua̠ntu̠ aquit cma̠­kan­tax­ti̠ma, chu­na­tiyá tata­mak­xteka cumu la̠m­para ni̠tu̠ taucxilh­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Pus antá chú nac xla­ta­ma̠tcán u̠ma̠ko̠lh cris­tianos li̠kan­taxtuy hua̠ntu̠ xamaká̠n quilh­ta­macú tili̠­chu­huí̠­nalh pro­feta Isaías acxni̠ chiné huá: Ma̠squi cris­tianos takáx­matli hua̠ntu̠ lacuán tas­tac­ya̠hu ni̠tu̠cu cati­taaká­ta̠ksli; ma̠squi na̠ cataúcxilhli lac­lanca li̠cá̠cni̠t ta­scújut, pero chu­na­tiyá nata­ta­mak­xteka cumu la̠m­para ni̠tu̠cu taca­tzi̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Xna­cujcán u̠ma̠ko̠lh cris­tianos luu xli̠­ca̠na tama̠­pa­lhi̠ni̠t; ma̠squi xlacán takax­mata pero ni̠lay taaka­ta̠ksa, ma̠squi luu kalhi̠ko̠y xla­kas­ta­pucán chu­na­tiyá cumu la̠ laka­tzí̠n tala­má̠­nalh la̠qui̠ chuná ni̠ nata­li̠­la­ca­hua̠nán xla­kas­ta­pucán y na̠ ni̠para huá xta­ke̠ncán nata­li̠­kax­mata, ni̠m­para huá xna­cujcán nata­liaka­ta̠ksa; y chuná ni̠ caquin­ti­ta­li̠­pá̠hua xla­cata pi̠ aquit nac­ca̠­ma̠t­la̠nti̠y y nac­ca̠­lak­ma̠x­tuniy xli̠s­tac­nicán. ");
INSERT INTO tocNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Pero luu ca̠na̠ li̠pa̠­xúhu hui­xinín porque kalhi̠­yá̠tit mila­kas­ta­pucán y liucxi­lhá̠tit hua̠ntu̠ ctla­huay, na̠ kalhi̠­yá̠tit min­ta­ke̠ncán y li̠kax­pa­tá̠tit quin­ta­chu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Porque aquit laca­tancs cca̠­hua­niyá̠n pi̠ lhu̠hua pro­fetas y lacuán cris­tianos hua̠nti̠ maká̠n quilh­ta­macú tati­la­ta­ma̠ni̠t huata xlacán na̠ luu xtaucxilh­putún hua̠ntu̠ hui­xinín la̠nchú ucxilh­pá̠tit pero xlacán ni̠ taúcxilhli; na̠ xta­kax­mat­putún hua̠ntu̠ hui­xinín la̠nchú kax­pat­pá̠tit pero huata xlacán ni̠ ca̠ma̠x­quí̠­calh quilh­ta­macú nata­kax­mata. ");
INSERT INTO tocNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Hui­xinín luu li̠huana̠ cakax­páttit y caaka­tá̠k­stit hua̠ntu̠ hua­ni­putún a̠má xata­kalh­chu­huí̠n cha­na̠ná: ");
INSERT INTO tocNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ama̠­ko̠lh li̠chánat hua̠ntu̠ tata­ma̠chá nac tiji y tasa­cuaqui̠­ko̠lh lactzu spu̠n, huá cca̠­ta̠­ma̠­la­cas­tuca a̠ma̠ko̠lh cris­tianos hua̠nti̠ takax­mata xta­chu­huí̠n Dios la̠ta lácu xlá lacas­quín nata­la­tama̠y nac xasa̠sti xta­péksi̠t; xlacán takax­mata pero aca­li̠stá̠n mina̠chá akska­huiní y ca̠ma̠­ta­pa̠­nu̠niy a̠má lacuán tachu­huí̠n hua̠ntu̠ xchan­cani̠t nac xna­cujcán. ");
INSERT INTO tocNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ama̠­ko̠lh li̠chánat hua̠ntu̠ tata­ma̠chá nac ca̠lak­chi­huixni, huá cca̠­ta̠­ma̠­la­cas­tuca a̠ma̠ko̠lh cris­tianos hua̠nti̠ takax­mata xta­chu­huí̠n Dios, xli̠­ca̠na luu ya̠ tapa̠­xu­huá̠n tala­kati̠y y tla̠n tat­la­huay. ");
INSERT INTO tocNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero cumu ni̠ luu xli̠­ca̠na hua̠k xta­hui­li̠ni̠t nac xna­cujcán cumu la̠ a̠ ni̠ cama̠­ti̠­ju̠chá xtan­káxe̠k, ni̠ luu maka̠s tamaka­palay y acxni̠ chú xlacán tamaklh­ca­tzi̠y pi̠ ca̠tzak­sa­má̠­calh osuchí ca̠li̠­pu­tza­sta̠­la­má̠­calh caj xpa̠­la­cata cumu tali̠­pa̠­huán xta­chu­huí̠n Dios, huata tu̠ xlacán tat­la­huay mejor caj tali̠­pu­huán y taak­xtek­makán. ");
INSERT INTO tocNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ama̠­ko̠lh li̠chánat hua̠ntu̠ tata­ma̠chá nac ca̠lh­tu­cuní̠n xlacán huá tali̠­taxtuy a̠ma̠ko̠lh cris­tianos hua̠nti̠ takax­mata xta­chu­huí̠n Dios pero huata a̠tzinú tali̠­taaka­tzanke̠y catu̠huá hua̠ntu̠ huí xala ca̠quilh­ta­macú para la̠ta lácu nata­ka­lhi̠y lhu̠hua tumi̠n y lácu li̠pa̠­xúhu nata­la­tama̠y, y chuná tali̠­taak­ska­hui­tama̠y pu̠tum hua̠ntu̠ xlacán tala­kati̠y, y na̠chuná chú tali̠­ma̠­lan­kako̠y xta­péksi̠t Dios y antá ni̠lay ma̠sta̠y xta­huácat nac xla­ta­ma̠tcán. ");
INSERT INTO tocNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Y huata a̠má tachaná̠n hua̠ntu̠ tata­ma̠chá nac xatlá̠n tíyat huá xlacán tali̠­taxtuy a̠ma̠ko̠lh cris­tianos hua̠nti̠ takax­mata xta­chu­huí̠n Dios, xlacán tat­la­huay hua̠ntu̠ antá ca̠li̠­ma̠­peksi̠y y chuná xlacán lhu̠hua hua̠ntu̠ tali̠­ma̠­siyuy xta­hua­catcán. Maka­pi­tzí̠n xta̠­chuná a̠ma̠ko̠lh li̠chánat hua̠ntu̠ tamá̠s­ta̠lh aktum cientu xtalhtzi caj la̠ta akatum, y maka­pi­tzí̠n xta̠­chuná cumu la̠ ti̠ tamá̠s­ta̠lh puxa­ma­cá̠hu. ");
INSERT INTO tocNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús ca̠li̠­ta̠­kalh­chu­hui̠­nampá eé takalh­chu­huí̠n: —Amá xasa̠sti xta­péksi̠t Dios hua̠ntu̠ ma̠tzu­qui̠ma uú nac ca̠quilh­ta­macú luu xta̠­chuná qui̠­taxtuy cumu la̠ lacuán li̠chánat hua̠ntu̠ cha̠tum chixcú chalh nac xca̠­tu­huá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Y li̠huán xtalh­ta­ta­má̠­nalh a̠ma̠ko̠lh cha­na̠­naní̠n ca̠tzi̠sní tze̠k tanu̠chi cha̠tum hua̠nti̠ csi̠­tzi̠niy xpu̠­chiná a̠má pú̠cuxtu y antá xlá tzú­culh xpu­yu­makán catu̠huá hua̠ntu̠ ni̠ lacuán li̠cúxtut nac xlak­sti̠­pa̠ncán trigo; acxni̠ chuná tla­hua­ko̠lh la̠li̠­huán alh. ");
INSERT INTO tocNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Acxni̠ a̠má trigo stacli y tzú­culh tahuacay xta­huácat na̠ hasta acxnicú tzú­culh tasiyuy xaní­cuma̠ caj li̠xcáj­nit li̠cúxtut. ");
INSERT INTO tocNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ama̠­ko̠lh tasa̠­cuá̠n hua̠nti̠ antá xtas­cuj­má̠­nalh la̠li̠­huán táalh tahuaniy xpat­roncán: “Patrón, nac min­ca̠­tu­huá̠n anta­nícu huix ticha­ná̠­nanti luu lacuán xuani̠t mili̠­chánat, ¿nícu chi̠nchú minchá a̠má xali̠xcáj­nit li̠cúxtut?” ");
INSERT INTO tocNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Xpu̠­chiná a̠má tachaná̠n chiné ca̠huá­nilh: “Cha̠­ca­tzi̠ya pi̠ hua̠nti̠ luu quin­ca̠­si̠­tzi̠­niyá̠n chuná quin­ca̠t­la­hua­ni̠tán.” Xlacán tahua­nipá: “¿Lácu chi̠nchú huana, pi̠ caná̠hu pulhu­ma­ka­ná̠hu tamá li̠xcáj­nit li̠cúxtut?” ");
INSERT INTO tocNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Pero xlá ca̠huá­nilh: “Ni̠chuná cat­la­huátit, chicá para xamaktum acxni̠ hui­xinín pulhu­pá̠tit nahuán li̠cúxtut na̠ napu­lhu­yá̠tit a̠má trigo. ");
INSERT INTO tocNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Huata mejor xatlá̠n lacx­tum catas­tac­ke̠lh hasta acxni̠ nalak­chá̠n quilh­ta­macú la̠ta pu̠tum nata­ma̠­mac­xtumi̠y quin­ta­chaná̠n xla­cata pi̠ pu̠lh huá napu­lhucán hua̠ntu̠ xali̠xcáj­nit li̠cúxtut y tunuj napa̠­chi̠cán la̠qui̠ naca̠­lac­lhcu­yu­hui­li̠cán, y aca­li̠stá̠n chú nama̠­mac­xtu­mi̠cán trigo y antá nama̠­qui̠cán nac quim­pú̠­cuxi.” ");
INSERT INTO tocNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús na̠ ca̠hua­nipá eé takalh­chu­huí̠n: —Amá xasa̠sti xta­péksi̠t Dios hua̠ntu̠ ma̠tzu­qui̠ma nac ca̠quilh­ta­macú luu xta̠­chuná naqui̠­taxtuy cumu la̠ staca a̠má aktum xali̠­chánat quihui hua̠ntu̠ hua­nicán mos­taza acxni̠ cha̠tum chixcú chan nac xpar­cela. ");
INSERT INTO tocNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Xli̠­ca̠na pi̠ huá u̠má xtalhtzi quihui hua̠ntu̠ a̠tzinú luu actzú la̠ta xli̠­hua̠k li̠cúxtut hua̠ntu̠ lac­lanca tas­taca, pero ma̠squi chuná acxni̠ xlá li̠huana̠ pún luu laca­pala tzucuy staca, hasta caní lanca quihui huán; y luu lhu̠hua kalhi̠y xmak­xpi̠ní̠n, y hasta lactzu spu̠n hua̠ntu̠ takosa nac ca̠u̠ní̠n antá xlacán tla̠n tla­huay xma̠­se­kecán nac xca̠­mak­xpi̠ní̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Na̠ ca̠li̠­ma̠­kalh­chu­hui̠­ni̠pá eé takalh­chu­huí̠n: —Amá xasa̠sti xta­péksi̠t Dios hua̠ntu̠ ma̠tzu­qui̠ma uú nac ca̠quilh­ta­macú luu xta̠­chuná ámaj tala­ka­pun­tumi̠y cumu la̠ lay actzu leva­dura acxni̠ cha̠tum pusca̠t ta̠lak­ko­chi­pa̠s­pita pa̠tutu tapu̠lhca harina; a̠má leva­dura laka­siyu tzucuy tla­huay xta­scújut hasta caní nama̠­ko­nuko̠y xli̠­hua̠k xli̠­lanca a̠má xata­lakmún harina. ");
INSERT INTO tocNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Y Jesús acxni̠ xca̠­ma̠­kalh­chu­hui̠ni̠y cris­tianos anka­lhí̠n caj catu̠huá xca̠­ta̠­ma̠­la­cas­tucniy, y ni̠tu̠ xca̠­li̠­ma̠­kalh­chu­hui̠ni̠y para ni̠ juerza huí tu̠ naca̠­ta̠­ma̠­la­cas­tucniy. ");
INSERT INTO tocNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Pus huá chuná li̠t­lá­hualh la̠qui̠ nama̠­kan­taxti̠y hua̠ntu̠ tili̠­chu­huí̠­nalh pro­feta Isaías nac li̠kalh­ta­huaka acxni̠ chiné tzók­nulh: Acxni̠ aquit nac­chu­hui̠nán, catu̠huá hua̠ntu̠ nac­ca̠­ta̠­ma̠­la­cas­tucniy quin­ta­chu­huí̠n; lhu̠hua hua̠ntu̠ lacuán tala­ca­pa̠s­tacni nacuán hua̠ntu̠ xtaaktze̠k­ta­hui­lani̠t hasta la̠ta Dios tima̠­la­ca­tzú­qui̠lh ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Acxni̠ Jesús ca̠huá­nilh a̠ma̠ko̠lh cris­tianos xla­cata pi̠ cataalhá nac xchiccán xlá na̠ alh nac chiqui anta­nícu nata­mak­xteka. Acxni̠ tácha̠lh, xta­ma̠­kalh­ta­huaké̠n chiné tahuá­nilh: —Xtlahua lanca li̠tlá̠n xqui­la̠­hua­níhu hua̠ntu̠ hua­ni­putún a̠má xata­kalh­chu­huí̠n li̠xcáj­nit li̠cúxtut hua̠ntu̠ xpulhni̠t nac xlak­sti̠pá̠n xala­cuán li̠chánat hua̠ntu̠ xchan­cani̠t nac ca̠tu­huá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Huata xlá chiné ca̠huá­nilh: —Amá chixcú hua̠nti̠ chalh xatlá̠n li̠chánat pus hua­tiyá aquit Xata­lac­sacni Chixcú. ");
INSERT INTO tocNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Y chi̠nchú a̠má ca̠tu­huá̠n pus huá la̠ta xli̠­ca̠­lanca ca̠quilh­ta­macú. Amá xatlá̠n li̠chánat huá tali̠­taxtuy hua̠nti̠ taca̠­naj­lani̠t quin­ta­chu­huí̠n y tata­pek­si̠niy Dios; y chi̠nchú a̠ma̠ko̠lh hua̠nti̠ xali̠xcáj­nit li̠cúxtut huá xlacán tali̠­taxtuy hua̠nti̠ tata­pek­si̠niy akska­huiní. ");
INSERT INTO tocNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Y chi̠nchú a̠má hua̠nti̠ luu ma̠rí si̠tzi̠niy xpu̠­chiná tachaná̠n pus hua­tiyá tamá akska­huiní. Amá li̠x­ká̠nat huá hua­ni­putún la̠ta lácu nas­puta xli̠­ca̠­lanca ca̠quilh­ta­macú; y a̠ma̠ko̠lh xka̠­naní̠n hua̠nti̠ naca̠­ma­ca­mincán xla­cata nata­ma̠­mac­xtumi̠y hua̠ntu̠ aya xalí̠xka̠t pus xlacán huá ángeles. ");
INSERT INTO tocNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Chuná cumu la̠ tla­huacán a̠má li̠cúxtut acxni̠ xka̠­nancán, pu̠lh huá li̠cúxtut pulhucán, li̠huana̠ ma̠mac­xtu­mi̠cán y lhcu­yucán, pus na̠chuná chú naqui̠­taxtuy acxni̠ nas­putcán nac ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Aquit Xata­lac­sacni Chixcú nac­ca̠­macá̠n quiángeles la̠qui̠ nata­ma̠­mac­xtumi̠y xli̠­hua̠k a̠ma̠ko̠lh lac­chix­cu­huí̠n hua̠nti̠ tama̠t­la­hui̠y tala̠­ka­lhí̠n xa̠maka­pi­tzí̠n xta̠­cris­tianoscán, y xli̠­hua̠k hua̠nti̠ luu lac­li̠xcáj­nit xta­pu­hua̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Xlacán antá naca̠­ta­mac­pu̠cán nac lanca lhcúya̠t hua̠ntu̠ huí nac pu̠pa̠tí̠n la̠qui̠ antá nata­tasay y nata­ma̠­lac­sa̠ni̠y xta­tzancán caj xpa̠­la­cata xta­pa̠­ti̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Y chi̠nchú a̠ma̠ko̠lh cris­tianos hua̠nti̠ talak­tzak­sa­má̠­nalh juerza tat­la­hua­má̠­nalh hua̠ntu̠ Dios lakati̠y xlacán luu li̠pe̠cua la̠ta nata­maca­xka­ke̠­na­na̠chá nac xpu̠­ma̠­peksí̠n Quin­tla̠­ticán Dios xta̠­chuná cumu la̠ chi­chiní. ¡Para hui­xinín kalhi̠­yá̠tit min­ta­ke̠ncán pus cakax­páttit! ");
INSERT INTO tocNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Hua̠nti̠ huacu kax­mata pi̠ li̠chu­hui̠­nancán xasa̠sti xli̠­ma̠­peksí̠n Dios y luu lakati̠y pus xlá luu xta̠­chuná li̠taxtuy cumu la̠ a̠má chixcú hua̠nti̠ maclay lhu̠hua tumi̠n hua̠k xla oro hua̠ntu̠ xma̠c­nu̠­cani̠t ctíyat nac aktum par­cela. Acxni̠ chú cátzi̠lh pi̠ chuná huata xlá la̠li̠­huán ma̠c­nu̠­paray a̠má tumi̠n y luu ya̠ tapa̠­xu­huá̠n naán nac xchic y nas­ta̠ko̠y hua̠ntu̠ xlá xka­lhi̠y la̠qui̠ chú tla̠n nata­ma̠­huay a̠má par­cela. ");
INSERT INTO tocNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Na̠chu­na­li̠túm a̠má hua̠nti̠ huacu kax­mata la̠ta li̠chu­hui̠­nancán xasa̠sti xta­péksi̠t Dios y xlá luu lakati̠y, luu xta̠­chuná qui̠­taxtuy cumu la̠ cha̠tum chixcú hua̠nti̠ sta̠nán y tama̠­huanán y putzat­la̠­huán lacuán perlas, pero hua̠ntu̠ luu xli̠­ca̠na xala­cuán. ");
INSERT INTO tocNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pero para chú naqui̠­maclay aktum hua̠ntu̠ luu xatlá̠n y xlá tancs catzi̠y pi̠ ni̠tu̠ anán hua̠ntu̠ xta̠­chuná xli̠­li̠­la­káti̠t, huata xlá la̠li̠­huán an nac xchic, ca̠s­ta̠ko̠y la̠tachá túcua kalhi̠y la̠qui̠ chú chuná tla̠n nata­ma̠­huay a̠má xatlá̠n perla. ");
INSERT INTO tocNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Amá xasa̠sti xta­péksi̠t Dios na̠ luu xta̠­chuná amaj qui̠­taxtuy cumu la̠ pu̠sa­kajú̠n acxni̠ maju̠cán nac kalh­tu̠­choko y ti̠pa̠­katzi la̠tachá túcuya̠ squi̠ti hua̠k ti̠tiyay. ");
INSERT INTO tocNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Acxni̠ chú aya tatzamay pu̠sa­kajú̠n la̠ta lhu̠hua squi̠ti xta­hua­ca­ni̠­tanchá a̠ma̠ko̠lh squi̠­ti̠­naní̠n tasa­ka­cutuy nac xquilhtú̠n chú­chut, antá chú xlacán culucs tala­ka­ta­huilay tzucuy talac­saca squi̠ti. Hua̠ntu̠ xala­cuán squi̠ti li̠huana̠ tapu̠­ma̠­qui̠y can­astas, y hua̠ntu̠ ni̠ xala­cuán xlacán ni̠ talén huata caj tamakán. ");
INSERT INTO tocNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Pus na̠chuná naqui̠­taxtuy acxni̠ nas­puta ca̠quilh­ta­macú, a̠ma̠ko̠lh ángeles nata­mi­na̠chá nac akapú̠n la̠qui̠ naca̠­ma̠­paj­pi­tzicán hua̠nti̠ lac­li̠xcáj­nit tali̠­ca­tzi̠y nac xlak­sti̠­pa̠ncán hua̠nti̠ lacuán xta­pu­hua̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Huá chú a̠ma̠ko̠lh cris­tianos hua̠nti̠ luu lac­li̠xcáj­nit taka­lhi̠y xta­pu­hua̠ncán pus huá naca̠­ma­ca̠ncán nac lhcúya̠t la̠qui̠ antá nata­tasay y nata­ma̠­lac­sa̠ni̠y xta­tzancán caj xpa̠­la­cata a̠má li̠pe̠cua tapa̠tí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesús chiné ca̠ka­lhás­quilh a̠ma̠ko̠lh cris­tianos: —¿Pi̠ hua̠k aka­ta̠k­sá̠tit hua̠ntu̠ aquit cca̠­hua­nimá̠n? Xlacán takalh­tí̠­nalh: —¡Jéje, hua̠k caka­ta̠k­sá̠hu! ");
INSERT INTO tocNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Huata xlá chiné ca̠hua­nipá: —Cumu para chuná pus mili̠­ca­tzi̠tcán pi̠ cha̠tum cris­tiano hua̠nti̠ luu li̠huana̠ li̠kalh­ta­hua­kani̠t hua̠ntu̠ la̠ta xuí xamaká̠n xli̠­ma̠­peksí̠n Dios y la̠qui̠ chú tancs naaka­ta̠ksa la̠ta lácu Dios lacas­quín nala­ta­pa̠­yá̠tit nac xasa̠sti xta­péksi̠t mili̠­ca­tzi̠tcán pi̠ cha̠tum xma̠­kalh­ta­hua­ke̠­nacán cris­tianos hua̠nti̠ luu li̠huana̠ li̠kalh­ta­hua­kama y laka­pasma xli̠­hua̠k hua̠ntu̠ Dios lac­lhca̠­hui­li̠ni̠t xli̠­ma̠­peksí̠n la̠qui̠ akstítum nali̠­la­ta­ma̠­yá̠hu xasa̠sti xta­péksi̠t. Pus luu xta̠­chuná li̠taxtuy cumu la̠ cha̠tum rico chixcú hua̠nti̠ xpu̠­chiná aktum chiqui hua̠nti̠ catzi̠y lácu ca̠li̠­ma̠­kalh­chu­hui̠ni̠y xa̠maka­pi­tzí̠n hua̠ntu̠ xamaká̠n tala­ca­pa̠s­tacni y acxtum ta̠ma̠­la­cas­tuca hua̠ntu̠ la̠nchú huí xasa̠sti tala­ca­pa̠s­tacni. ");
INSERT INTO tocNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Acxni̠ Jesús chuná ca̠li̠­ta̠­kalh­chu­hui̠­nan­ko̠lh u̠má takalh­chu­huí̠n xlá na̠ acxni­tiyá alh a̠laca­tunu. ");
INSERT INTO tocNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Y antá cha̠lh nac xca̠­chi­quí̠n anta­nícu xlá cstacni̠t. Antá chú tzú­culh ca̠ma̠­kalh­chu­hui̠ni̠y cris­tianos nac xpu̠­si­cu­lancán judíos hua̠ntu̠ xuí antá, y la̠ta xli̠­lhu̠hua cris­tianos caj cacs xta­li̠­la­ca­huán xta­chu­huí̠n y chiné xta­huán: —¿Nícu cahuá catzí̠­nilh pu̠tum a̠má lanca tala­ca­pa̠s­tacni hua̠ntu̠ catzi̠y eé chixcú? ¿Lácu cahuá li̠ka­lhi̠y tamá li̠t­li­hueke xla­cata pi̠ tla̠n naca̠t­la­huay lac­lanca li̠cá̠cni̠t ta­scújut hua̠ntu̠ xlá ca̠t­la­huay? ");
INSERT INTO tocNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Pus huá eé xka­huasa tamá car­pin­tero José xuani̠t, y chi̠nchú xtzí hua­nicán María, xa̠huachí na̠ ca̠la­ka­pa­sá̠hu xli̠­ta­la­ka­pasni ca̠hua­nicán San­tiago, José, Simón xa̠huá Judas. ");
INSERT INTO tocNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Y na̠ chuná maka­pi­tzí̠n xna­ta̠lán lac­tzu­maján na̠ antá uú tahui­lá̠­nalh y ca̠la­ka­pa­sá̠hu. ¿Tícu chi̠nchú ma̠x­qui̠ni̠t cahuá xli̠s­ka­lala hua̠ntu̠ xlá quin­ca̠­li̠­ma̠­kalh­chu­hui̠­ni̠yá̠n? ");
INSERT INTO tocNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Pus caj huá tamá xpa̠­la­cata xna­ta̠­chi­quí̠n ni̠ xta­li̠­ca̠­naj­laniy. Huata Jesús chiné ca̠huá­nilh: —Cha̠tum pro­feta la̠tachá nícu an hua̠k ca̠naj­la­nicán y li̠pa̠­huancán, pero acxni̠ chú cha̠n nac xca̠­chi­quí̠n xa̠huá nac xchic, antá ni̠para tzinú ca̠naj­la­nicán hua̠ntu̠ xlá li̠chu­hui̠nán. ");
INSERT INTO tocNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Pus caj huá u̠má xpa̠­la­cata ni̠ lhu̠hua ca̠li̠t­lá­hualh lac­lanca li̠cá̠cni̠t ta­scújut antá nac xlak­sti̠­pa̠ncán porque xlacán ni̠ xta­li̠­pa̠­huán. ");
INSERT INTO tocNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Rey Herodes hua̠nti̠ xuí li̠go­ber­nador nac Gali­lea acxni̠ xlá lák­cha̠lh tachu­huí̠n la̠ta xli̠­chu­hui̠­nancán Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Huata xlá chiné ca̠huá­nilh hua̠nti̠ antá xta­ta̠s­cuj­má̠­nalh: —Tamá hua̠nti̠ hua­nicán Jesús cha̠­ca­tzi̠ya pi̠ huá Juan Bau­tista, ma̠x lacas­ta­cuánalh nac ca̠li̠ní̠n y mimpá nac ca̠quilh­ta­macú, pus por eso chuná ca̠li̠t­la­huay lac­lanca li̠cá̠cni̠t ta­scújut. ");
INSERT INTO tocNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Huá chuná xlá xli̠­huán porque tamá Herodes huá xma̠­chi­pi̠­nani̠t Juan y tachí̠n tilé̠n­calh nac pu̠la̠­chi̠n. Huá chuná li̠t­lá­hualh caj xpa̠­la­cata Herod­ías hua̠nti̠ xpusca̠t xuani̠t xta̠Felipe, ");
INSERT INTO tocNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","porque xlá ni̠tlá̠n tlá­hualh hua̠ntu̠ maktum quilh­ta­macú tihuá­nilh Juan: —Ni̠tlá̠n la̠n­tamá lápa̠t, ni̠ mili̠­ta̠­ta­huílat miya̠stá. ");
INSERT INTO tocNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Huata rey Herodes xmak­ni̠­putún Juan pero xlak­lhpe̠­cuamparay chú porque la̠ta xli̠­lhu̠hua cris­tianos xca­tzi̠cán pi̠ Juan huá xli̠­chu­hui̠nán xta­chu­huí̠n Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pero acxni̠ ma̠ká­tzi̠lh xca̠ta la̠ta xla­ca­chini̠t a̠má Herodes, huá chú xtzuma̠t Herod­ías alh tan­tli̠y antá nac xla­ca­ti̠ncán pu̠tum hua̠nti̠ quilh­xtum xta­hui­lá̠­nalh nac mesa hua̠nti̠ xta­ma­kua̠ya­má̠­nalh y huata Herodes luu laká­ti̠lh la̠ta xlá tán­tli̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Hasta ma̠lac­nú̠­nilh xla­cata pi̠ nama̠x­qui̠y la̠tachá túcu xlá nas­quiniy hua̠ntu̠ xlá nala­kati̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Pero cumu a̠má tzuma̠t aya li̠huana̠ xakas­tac­ya̠­huani̠t xtzí, chiné huá­nilh Herodes: —Aquit cla­cas­quín pi̠ la̠n­chuj­tuncán xqui­ma̠xqui nac pektum pula̠tu xak­xa̠ka Juan Bau­tista. ");
INSERT INTO tocNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Acxni̠ chuná káx­matli a̠má rey Herodes hua̠ntu̠ xla­cas­quín a̠má tzuma̠t xlá luu snu̠n li̠púhua. Pero cumu aya xapu̠lhá xli̠­ta̠­ya­nini̠t pi̠ nama̠x­qui̠y la̠tachá túcu nas­quiniy, y na̠chuna li̠túm hua̠k xta­kax­mat­nini̠t hua̠nti̠ antá mac­xtum xca̠­tá̠hui hua̠nti̠ xca̠­pu­tza­cani̠t pus huata xlá li̠ma̠­pek­sí̠­nalh xla­cata pi̠ cama̠x­quí̠­calh; ");
INSERT INTO tocNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","y na̠ ma̠pek­sí̠­nalh pi̠ capix­ca̠c­tí̠­calh xak­xa̠ka Juan Bau­tista nac pu̠la̠­chi̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Y aca­li̠stá̠n chú pu̠li̠­mínca pektum pula̠tu, maca­ma̠x­quí̠­calh a̠má tzuma̠t, y a̠má tzuma̠t maca­ma̠x­qui̠pá xlá xtzí. ");
INSERT INTO tocNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Y caj li̠puntzú tachilh hua̠nti̠ xta­li̠­pa̠­huán Juan, tále̠lh xti­yat­li̠hua y tamá̠c­nu̠lh. Aca­li̠stá̠n chú talá­kalh Jesús y tali̠­ta̠­kalh­chu­huí̠­nalh hua̠ntu̠ xlá xak­spu­lani̠t Juan. ");
INSERT INTO tocNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Acxni̠ Jesús cátzi̠lh hua̠ntu̠ xak­spu­lani̠t Juan huata xlá na̠ tatam­pú̠x­tulh anta­nícu xlama y táju̠lh nac aktum barco, alh sacstu anta­nícu luu ca̠tzi­yanca. Pero lhu̠hua cris­tianos xala cani̠hua ca̠chi­qui̠ní̠n acxni̠ tacá­tzi̠lh anta­nícu xamaj cha̠n a̠má barco xlacán táalh tapu­tzay pero caj tat­la̠­huaalh. ");
INSERT INTO tocNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Acxni̠ chú Jesús tacutli nac barco úcxilhli pi̠ luu lhu̠hua cris­tianos xta­kalh­ka­lhi̠­má̠­nalh. Xlá ca̠la­ka­lhá­malh y ca̠cu­chí̠­nilh xli̠­hua̠k hua̠nti̠ xta­li̠­mini̠t xta̠­tat­lacán. ");
INSERT INTO tocNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Hua­tiyá a̠má quilh­ta­macú acxni̠ aya xamaj ca̠puc­suán xta­ma̠­kalh­ta­huaké̠n Jesús talák­milh y chiné tahuá­nilh: —La̠nchú aya ko̠ta­nu̠­ko̠lh y amajá tzi̠­suán, xa̠huachí uú lacatzú ni̠tícu hui­la­kó̠­calh. Huata mejor caca̠­huani u̠ma̠ko̠lh cris­tianos xla­cata pi̠ cataalhá nac xchiccán osuchí anta­nícu tahui­lá̠­nalh lactzu ca̠chi­qui̠ní̠n la̠qui̠ antá nata­ta­ma̠­huay hua̠ntu̠ nata­li̠­hua̠yán. ");
INSERT INTO tocNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Huata Jesús ca̠huá­nilh: —Pus ni̠ luu xla­ca­squinca para nícu nataán huata hui­xinín ma̠n caca̠­ma̠­huí̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Xlacán takalh­tí̠­nalh: —Pero, ¿lácu chú aquinín nac­ca̠­li̠­ma̠­hui̠­yá̠hu? Porque ni̠ lhu̠hua cka­lhi̠­yá̠hu cax­ti­lá̠n­chahu caj xma̠n mac­qui­tzis xa̠hua tantiy squi̠ti. ");
INSERT INTO tocNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesús ca̠hua­nipá: —Pus aver, uú cali̠­tátit hua̠ntu̠ kalhi̠­yá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jesús ca̠li̠­ma̠­pék­si̠lh cris­tianos xla­cata pi̠ antá cata­táhui nac ca̠se­ketni. Aca­li̠stá̠n chú xlá ca̠tí­yalh a̠má mac­qui­tzis cax­ti­lá̠n­chahu xa̠huá tantiy squi̠ti, xlá tala­ca­yá̠­hualh nac akapú̠n, pa̠x­cat­ca­tzí̠­nilh Dios a̠má tahuá y ca̠má̠x­qui̠lh xdis­cí­pulos, xlacán tama̠akpi­tzí­nilh xli̠­hua̠k cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Hua̠k tahuá̠­yalh y la̠n tákasli, pero aca­li̠stá̠n xlacán tama̠­tza­mapá pa̠cu̠tiy cana̠sta xata­lak­che­ke­tamá̠n cax­ti­lá̠n­chahu xa̠huá squi̠ti hua̠ntu̠ aka­tá̠x­tulh. ");
INSERT INTO tocNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ama̠­ko̠lh cris­tianos hua̠nti̠ tahuá̠­yalh ma̠x cumu akqui­tzis mi̠lh cris­tianos caj la̠ta maya̠ lac­chix­cu­huí̠n, tunuj cuenta lac­chaján y lactzu camán. ");
INSERT INTO tocNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Aca­li̠stá̠n Jesús ca̠huá­nilh xdis­cí­pulos xla­cata pi̠ cata­tá­ju̠lh nac aktum barco la̠qui̠ xlacán pu̠lh huá nata­pa̠­ta­cu­ta̠chá chú­chut, y hasta aca­li̠stá̠n xlá xámaj ca̠lak­chá̠n porque a̠cu xca̠­hua­nima a̠ma̠ko̠lh cris­tianos pi̠ cataalhá nac xchiccán. ");
INSERT INTO tocNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Acxni̠ chú pu̠tum taanko̠lh a̠ma̠ko̠lh cris­tianos, xlá tala­ca̠c­xtu­táhui nac aktum ke̠stí̠n la̠qui̠ antá sacstu nakalh­ta­hua­kaniy Quin­tla̠­ticán Dios. Acxni̠ chú luu aya li̠huana̠ ca̠tzi̠­suanko̠lh antacú xlá xlaya sacstu. ");
INSERT INTO tocNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Chi̠nchú a̠má barco hua̠ntu̠ xta­pu̠amá̠­nalh xdis­cí­pulos aya xke̠ita̠t­lani̠t pupunú, pero caj xamaktum li̠pe̠cua la̠ta tzú­culh u̠nún y a̠má barco li̠pe̠cua la̠ta xma̠­la­kas­pit­putún xli̠t­li­hueke ta̠ke­ya̠­huaná porque luu antá xma̠­la­ka­tancs xta­hui­la­ma̠chi palha uú̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Acxni̠ chú aya cxka­ka­ti̠­lhako̠y Jesús tzú­culh ca̠ma̠­la­ca­tzu­hui̠niy xbarco, pero huata xlá antá xkalh­tla̠­huan­ti̠­lhay chú­chut nac pupunú. ");
INSERT INTO tocNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Acxni̠ a̠ma̠ko̠lh dis­cí­pulos taúcxilhli pi̠ xlá xkalh­tla̠­huama chú­chut xlacán la̠n tapé̠­cualh y chiné tzú­culh tahuán: —Tamá xlá ma̠x caj ni̠n quin­ca̠­ma̠­la­ca­hua̠­ni̠má̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero Jesús ca̠xa­kát­li̠lh y chiné ca̠huá­nilh: —¡Cata­ca­májtit, ni̠ cape̠­cuántit, porque aquit Jesús hua̠nti̠ cca̠­la­ka­ma̠­chá̠n! ");
INSERT INTO tocNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pedro xakát­li̠lh y chiné qui­lhá­nilh: —Quim­pu̠­chi­nacán Jesús, cumu para xli̠­ca̠na huix hua̠nti̠ támpa̠t pus chú na̠ caquin­ta­sa­nipi la̠qui̠ na̠ tla̠n nac­tla̠­huán nac xkalhni chú­chut hasta anta­nícu huix ya̠pi. ");
INSERT INTO tocNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesús chiné huá­nilh: —Pus catu̠x­ca̠ni, la̠li̠­huán cala­ca­pala y catat. Amá Pedro la̠li̠­huán tacutli nac barco y na̠chuná tzú­culh kalh­tla̠­huán chú­chut la̠qui̠ namín ta̠la̠­pa̠x­toka Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero acxni̠ xlá maklh­cá­tzi̠lh pi̠ luu tli­hueke la̠ta xmima uú̠n juerza lak­lhpé̠­cualh tzinú, y cumu tzú­culh lak­tzanka̠y nac chú­chut xlá chiné qui­lhá­nilh: —¡Quim­pu̠­chiná Jesús, cat­lahua li̠tlá̠n caqui­mak­ta̠ya! ");
INSERT INTO tocNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Acxni­tiyá chú Jesús maca­chí­palh, y chiné huá­nilh: —¡Cará kahua! Chi̠nchú cumu huana qui­li̠­pa̠­huana, ¿lácu chú li̠lac­pú­huanti pi̠ aquit ni̠ cac­ti­mak­ta̠yán? ");
INSERT INTO tocNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Acxni̠ chú xlacán tatá­ju̠lh nac barco a̠má uú̠n tuncán tácacsli. ");
INSERT INTO tocNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Y chi̠nchú a̠ma̠ko̠lh maka­pi­tzí̠n dis­cí­pulos hua̠nti̠ xta­ta­ju̠­má̠­nalh nac barco la̠li̠­huán tala­ka­ta­tzo­kós­talh nac xla­catí̠n Jesús y chiné tahuá­nilh: —¡Xli̠­ca̠na la̠n­chujcú aquinín cta­lu­lo­ká̠hu pi̠ huix Xka­huasa Dios! ");
INSERT INTO tocNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Acxni­tiyá chú la̠li̠­huán tzú­culh tapa̠­ta­cuta a̠má pupunú y antá tácha̠lh nac xapu̠­la­tama̠n hua̠ntu̠ hua­nicán Gene­saret. ");
INSERT INTO tocNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Acxni̠ a̠ma̠ko̠lh cris­tianos antá xalaní̠n tala­ká­pasli pi̠ huá Jesús hua̠nti̠ xchini̠t xlacán tuncán tali̠­chu­huí̠­nalh nac xli̠­ca̠­lanca a̠má pu̠la­tama̠n y la̠li̠­huán tali̠­mí­nilh xli̠­hua̠k xta̠­tat­lacán anta­nícu xlaya Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Maka­pi­tzí̠n tas­quí­nilh li̠tlá̠n xla­cata pi̠ caca̠­má̠x­qui̠lh tala­cas­quín ca̠na̠caj xtam­pek­stá̠n clháka̠t nata­xa­maniy a̠ma̠ko̠lh ta̠tat­laní̠n, y xli̠­hua̠k hua̠nti̠ taxa­má­nilh clháka̠t Jesús hua̠k tatat­lá̠n­ti̠lh ma̠squi la̠tachá túcuya̠ tajátat xca̠­ka­lhi̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Maktum quilh­ta­macú talak­ta­la­ca­tzú­hui̠lh Jesús maka­pi­tzí̠n fariseos chu xma̠­kalh­ta­hua­ke̠­nacán judíos hua̠nti̠ xta­mi­ni̠­tanchá nac Jeru­salén, y chiné taka­lhás­quilh: ");
INSERT INTO tocNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Túcu xpa̠­la­cata tama̠­ko̠lh min­ta­ma̠­kalh­ta­huaké̠n caj luu taka­lha­kax­mat­makán hua̠ntu̠ mini̠­tan­chitá xtas­ma­ni̠ncán xalak­maká̠n qui­li̠­ta­la­ka­pas­nicán? Porque xlacán ni̠ xli̠­ca̠na taca̠c­ni̠­naniy Dios cumu ni̠ tat­la­huay hua̠ntu̠ cli̠s­ma­ni̠­ni̠­táhu ctla­hua­yá̠hu xla­cata pi̠ luu li̠huana̠ nama­ca­ma̠­hua­ca­cana chú­chut acxni̠ nia̠ hua̠­yana. ");
INSERT INTO tocNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Pero Jesús na̠ chuná ca̠ka­lhás­quilh aktum tachu­huí̠n: —Y chi̠nchú hui­xinín, ¿túcu xpa̠­la­cata li̠ka­lha­kax­pat­ma­ka­ná̠tit hua̠ntu̠ Dios ca̠li̠­ma̠­pek­si̠­ni̠tán nama̠­kan­tax­ti̠­yá̠tit y huata caj xma̠nhuá tla­hua­yá̠tit hua̠ntu̠ caj me̠c­stucán min­tas­ma­ni̠ncán? ");
INSERT INTO tocNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Porque hasta la̠ta xamaká̠n quilh­ta­macú Dios chiné tíhua: “Capa̠xqui y cala­ka­lhá­manti min­tla̠t chu mintzí, pero hua̠nti̠ nata̠­la̠­la­ca­ta̠­qui̠y xtla̠t osuchí xtzí y para cala̠huá nahuaniy, tamá chixcú luu mini̠niy pi̠ maktum cani̠lh.” ");
INSERT INTO tocNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero chi̠nchú hui­xinín kalhtum ma̠lu­lo­ká̠tit pi̠ ni̠ tla­huay tala̠­ka­lhí̠n acxni̠ hua­ná̠tit xla­cata pi̠ cha̠tum chixcú tla̠n nahuaniy xtla̠t osuchí xtzí: “La̠nchú ni̠lay cmak­ta̠­yayá̠n ma̠squi xac­mak­ta̠­ya­putún porque xli̠­hua̠k hua̠ntu̠ cka­lhi̠y actzú hua̠k huá cma̠­lac­nu̠­nini̠t Dios xla­cata nac­li̠­la­ka­chix­cu­hui̠y y huá chú nacma̠xqui̠y”; ");
INSERT INTO tocNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","y xli̠­hua̠k cris­tianos hua̠nti̠ chuná tahuán luu laca­tancs tahuam­putún pi̠ tla̠n niaj ne̠c­xnicú cati­ta­mak­tá̠­yalh xtla̠tcán xa̠huá xtzicán. ");
INSERT INTO tocNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Xli̠­ca̠na xlá pi̠ hui­xinín luu xaaksa­ni̠­naní̠n! Luu laca­tancs ma̠lu­lokni̠t pro­feta Isaías acxni̠ chiné titzók­nulh nac li̠kalh­ta­huaka caj mim­pa̠­la­ca­tacán: ");
INSERT INTO tocNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Uma̠­ko̠lh cris­tianos caj luu xma̠n xquilh­nicán tali̠­chu­hui̠nán acxni̠ tahuán pi̠ mat quin­ta­li̠­pa̠­huán y quin­ta­la­ka­chix­cu­hui̠y, pero huata antá nac xna­cujcán luu tunuj tala­ca­pa̠s­tacni tahui­li̠ni̠t, y chuná chú quin­ta­li̠­ma̠­la­ka­maka­tli̠niy. ");
INSERT INTO tocNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Pus luu laca­tancs pi̠ ni̠tu̠ li̠ma­cuán ma̠squi quin­ta­la­ka­chix­cú­hui̠lh, porque xli̠­hua̠k hua̠ntu̠ xlacán tali̠­ma̠­pek­si̠nán catat­lá­hualh cris­tianos, hua̠k caj xtas­ma­ni̠ncán lac­chix­cu­huí̠n y ni̠huá hua̠ntu̠ aquit cca̠­li̠­ma̠­pek­si̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Aca­li̠stá̠n chú Jesús hua̠k ca̠ta­sá­nilh cris­tianos y chiné ca̠huá­nilh: —Cakax­páttit u̠má quin­ta­chu­huí̠n y li̠huana̠ caaka­tá̠k­stit: ");
INSERT INTO tocNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ni̠ huá hua̠ntu̠ quilh­tanu̠y y kotuay cha̠tum cris­tiano ma̠t­la­hui̠y tala̠­ka­lhí̠n y xca­jua̠lay xli̠s­tacni, sinoque hua̠ntu̠ tax­tu­ya̠chi nac xquilhni acxni̠ chu­hui̠nán, pus huá xlá ma̠x­ca­jua̠li̠y xli̠s­tacni porque ni̠ lakati̠y Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Aca­li̠stá̠n a̠ma̠ko̠lh xdis­cí­pulos talak­ta­la­ca­tzú­hui̠lh y chiné tahuá­nilh: —Ama̠­ko̠lh fariseos ni̠tlá̠n tat­lá­hualh acxni̠ takax­mat­ko̠lh min­ta­chu­huí̠n huata caj taliaka­sí̠­tzi̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Huata xlá chiné ca̠kálh­ti̠lh: —Xli̠­hua̠k a̠má tachaná̠n hua̠ntu̠ ni̠ huá chani̠t Quin­tla̠t hua̠nti̠ hui­lachá nac akapú̠n, luu laca­tancs pi̠ amá̠­calh ca̠pu­lhu­makan­cán pu̠tum xtan­káxe̠k. ");
INSERT INTO tocNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ni̠tu̠ caca̠­hua­nítit, cata­la­ke̠lh, porque xlacán caj xta̠­chuná tali̠­taxtuy cumu la̠ laka­tzí̠n hua̠nti̠ tape­ke­chi­pa­le̠­má̠­nalh a̠maka­pi­tzi̠n­li̠túm xta̠­la­ka­tzi̠ncán. Pero para cha̠tum laka­xo̠ko peke­chi­pa­le̠m­putún hua̠nti̠ na̠ laka­xo̠ko, luu laca­tancs pi̠ ni̠para mákat cati­tat­lá̠­hualh y xlac­xtumcán xcha̠­tiycán nata­ta­mo­kosa anta­nícu luu tan­quilh­ta̠lhmá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedro chiné huá­nilh Jesús: —Xtlahua li̠tlá̠n, xqui­la̠­ma̠­la­ca­pu̠­tun­cu­hui̠­níhu hua̠ntu̠ hua­ni­putún tamá takalh­chu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús ca̠huá­nilh: —¡Já! ¿Lácu pi̠ na̠ ni̠para hui­xinín aka­ta̠k­spá̠tit hua̠ntu̠ cca̠­hua­ni­pu­tuná̠n? ");
INSERT INTO tocNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Lácu pi̠ ni̠ catzi̠­yá̠tit pi̠ xli̠­hua̠k a̠má tahuá hua̠ntu̠ quilh­tanu̠y nac xquilhni cha̠tum cris­tiano antá ti̠tum an nac xpoko, y aca­li̠stá̠n chú makam­paray? Y ni̠ huá ma̠t­la­hui̠y tala̠­ka­lhi̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero hua̠ntu̠ tax­tu­ya̠chi nac xquilhni cha̠tum cris­tiano antá ti̠tum mina̠chá nac xnacú, xli̠­ca̠na chú xlá pi̠ huá ma̠t­la­hui̠y tala̠­ka­lhí̠n y ma̠x­ca­jua̠li̠y xla­táma̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Porque xli̠­ca̠na pi̠ antá nac xnacú cha̠tum cris­tiano mina̠chá xalac­li̠xcáj­nit tala­ca­pa̠s­tacni, antá mina̠chá xta­la­ca­pa̠s­tacni la̠ta lácu namakni̠y xta̠­cris­tiano, antá lac­pu­huán la̠ naxa­katli̠y tunuj pusca̠t o chixcú, o la̠ nala­ka­mak­lhti̠y xpusca̠t xta̠­chixcú, na̠chuná para taka­lhá̠n, taquic­lhcatza xa̠huá taaksaní̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Xli̠­ca̠na pi̠ huá u̠má li̠xcáj­nit tla­huaniy xli̠s­tacni cha̠tum cris­tiano y ni̠ lakati̠y Dios chuná nala­tama̠y. Pero para caj nahua̠­yana y ni̠chuná nama̠­kan­tax­ti̠ya hua̠ntu̠ huí tas­maní̠n xla­cata pi̠ li̠huana̠ nama­ca­ma̠­hua­ca­cana chú­chut, pus tamá ni̠ huá ma̠x­caj­hua̠li̠y xla­táma̠t cha̠tum cris­tiano para napu­huana chú pi̠ Dios ni̠ lakati̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Acxni̠ chú antá Jesús taca̠xpá, chú luu mákat alh hasta nac xapu̠­la­tama̠n Tiro y Sidón. ");
INSERT INTO tocNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Antá xuí cha̠tum pusca̠t hua̠nti̠ na̠ caj antá xmini̠t mak­ta­huilay porque xala mákat xuani̠t hasta nac aktum ca̠chi­quí̠n hua­nicán Canaan. Xlá tokosú̠n lák­milh Jesús y chiné xqui­lha­nima: —¡Quim­pu̠­chi­nacán, aquit cca­tzi̠y pi̠ huix xli̠­ta­la­ka­pasni xamaká̠n rey David, luu xli̠­ca̠na cat­lahua li̠tlá̠n caqui­la­ka­lhá­manti! Porque koxutá quin­tzuma̠t akchi­pa­ni­ko̠ni̠t xta­la­ca­pa̠s­tacni xes­pí­ritu akska­huiní y luu li̠pe̠cua la̠ta pa̠ti̠­nama. ");
INSERT INTO tocNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero Jesús ni̠tu̠cu kálh­ti̠lh; huata la̠li̠­huán taminchá xdis­cí­pulos y chiné tali̠­ma̠aka­tzán­ke̠lh: —Cat­lahua li̠tlá̠n, cahuani tamá pusca̠t pi̠ caalhá porque luu li̠pe̠cua quin­ca̠akax­cu­li­ti̠­lhayá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesús tachó­kolh y chiné huá­nilh a̠má pusca̠t: —Dios qui­ma­ca­mini̠t uú nac xapu̠­la­tama̠n Israel la̠qui̠ aquit nacmín ca̠pu­tzay a̠ma̠ko̠lh xca­maná̠n hua̠nti̠ xta̠­chuná tali̠­taxtuy cumu la̠ xaaktzanká̠n bor­regos, pus caj xma̠n huá hua̠nti̠ israel­itas nac­ca̠­mak­ta̠yay. ");
INSERT INTO tocNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Amá pusca̠t lak­ta­la­ca­tzú­hui̠lh, laka­ta­tzo­kós­talh nac xla­catí̠n y chiné huá­nilh: —¡Quim­pu̠­chiná, cat­lahua li̠tlá̠n caqui­mak­ta̠ya! ");
INSERT INTO tocNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesús chiné huá­nilh: —Ma̠x chuná, pero ni̠tlá̠n qui̠­taxtuy para naca̠­mak­lhti̠­yá̠hu xta­huajcán lactzu camán xla­cata naca̠­li̠­ma̠­hui̠­yá̠hu lactzu chi­chí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pero a̠má pusca̠t aká­ta̠ksli hua̠ntu̠ xuani­putún y chiné kálh­ti̠lh: —Quim­pu̠­chiná, xli̠­ca̠na xlá la̠ huana, pero hasta lactzu chi­chí̠n tla̠n tasa­cuaqui̠y lactzu xata­lak­che­ke­tamá̠n cax­ti­lá̠n­chahu hua̠ntu̠ tamak­xtek­ta­huilay y tamo­kosa nac xme­sajcán hua̠nti̠ xpu̠­chiná. ");
INSERT INTO tocNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesús chiné huá­nilh: —Pusca̠t, xli̠­ca̠na pi̠ huix luu qui­li̠­pa̠­huana xli̠­hua̠k minacú, pus huata chuná cakan­táx­tulh la̠ta lácu huix lac­pu­huana. Pus hua­tiyá a̠má hora y hua­tiyá quilh­ta­macú a̠má tzuma̠t hua̠nti̠ xta̠­tatlay tuncán tat­lá̠n­ti̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús taca̠xpá y antá ti̠táx­tulh nac xquilhtú̠n xapu­punú Gali­lea, aca­li̠stá̠n chú tala­ca̠c­xtu­táhui nac aktum ke̠stí̠n y antá culucs tahui­lachá. ");
INSERT INTO tocNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Luu lhu̠hua cris­tianos tácha̠lh anta­nícu xlá xuilachá xa̠huachí xta­li̠mín lhu̠hua ta̠tat­laní̠n; huí ti̠ xlé̠n lu̠ntu, laka­xo̠ko, ko̠ko, huí ti̠ maka­putu xuani̠t, antá chú tali̠­mí­nilh nac xla­catí̠n Jesús xlá hua̠k ca̠ma̠t­lá̠n­ti̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Xli̠­hua̠k cris­tianos cacs tali̠­la­cáhua acxni̠ taúcxilhli la̠ta tla̠n xta­chu­hui̠nán hua̠nti̠ ko̠ko xta­huani̠t, y a̠ma̠ko̠lh lac­chix­cu­huí̠n hua̠nti̠ maka­putu xta­huani̠t xlacán hua̠k xta­ta­maca­tla̠n­ti̠ni̠t, na̠chuná hua̠nti̠ xta­la­ka­xo̠­ko̠ni̠t chú hua̠k tla̠n xta­la­ca­hua̠nán. Y acxni­tiyá a̠má quilh­ta­macú luu lhu̠hua cris­tianos tzú­culh tapa̠x­cat­ca­tzi̠niy a̠má lanca tali̠­pa̠hu Dios hua̠nti̠ xta­li̠­pa̠­huán israel­itas caj xpa̠­la­cata hua̠ntu̠ xlá xtla­huani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesús ca̠ta­sá­nilh xdis­cí­pulos y chiné ca̠huá­nilh: —Xli̠­ca̠na aquit luu kayaj cca̠­lak­ca­tzán u̠ma̠ko̠lh cris­tianos porque chú aya le̠ma xliaktutu quilh­ta­macú la̠ta tachini̠t uú y ni̠para túcu taka­lhi̠y hua̠ntu̠ nata­li̠­hua̠yán, y ni̠ cla­cas­quín xapa̠­lak­chu­natá nataán nac xchiccán, chicá para nata­la­ka­hui­ti­ta̠yay nac tiji caj xpa̠­la­cata cumu aya tatzin­c­sni̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Huata a̠ma̠ko̠lh xdis­cí­pulos chiné takálh­ti̠lh: —Pero chi̠nchú aquinín, ¿nícu naca̠­ti­ya­yá̠hu lhu̠hua cax­ti­lá̠n­chahu hua̠ntu̠ naca̠­li̠­ma̠­hui̠­yá̠hu u̠ma̠ko̠lh cris­tianos porque xli̠­ca̠na pi̠ luu clhu̠­huacán, xa̠huachí uú lacatzú ni̠tícu hui­la­ko̠lh cris­tianos? ");
INSERT INTO tocNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús ca̠kálh­ti̠lh: —Pero chi̠nchú hui­xinín, ¿nícu macli̠t cax­ti­lá̠n­chahu kalhi̠­yá̠tit? —Aquinín cka­lhi̠­yá̠hu mac­tujún cax­ti­lá̠n­chahu y tan­c­stiy squi̠ti —takalh­tí̠­nalh xlacán. ");
INSERT INTO tocNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Xlá ca̠huá­nilh xla­cata pi̠ cata­táhui cris­tianos nac ca̠se­ketni. ");
INSERT INTO tocNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Aca­li̠stá̠n ca̠chí­palh a̠má mac­tujún cax­ti­lá̠n­chahu xa̠huá a̠ma̠ko̠lh squi̠ti, xlá pa̠x­cat­ca­tzí̠­nilh Dios aca­li̠stá̠n chú ca̠ma­ca­má̠x­qui̠lh xdis­cí­pulos y hua­tuní̠n chú tama̠akpi­tzí­nilh cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Xpu̠­tumcán hua̠k tahuá̠­yalh y la̠n tákasli, aca­li̠stá̠n chú tama̠­tza­mapá pa̠tujún can­a̠stas la̠ta tu̠ aka­tá̠x­tulh xata­lak­che­ke­tamá̠n cax­ti­lá̠n­chahu. ");
INSERT INTO tocNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ma̠x cumu akta̠ti mi̠lh lac­chix­cu­huí̠n hua̠nti̠ tahuá̠­yalh, tunuj cuenta lac­chaján xa̠huá lactzu camán. ");
INSERT INTO tocNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Aca­li̠stá̠n chú Jesús ca̠huá­nilh a̠ma̠ko̠lh cris­tianos xla­cata pi̠ cataalhá nac xchiccán, xlá na̠ táju̠lh nac aktum barco y antá alh nac púla­tama̠n hua̠ntu̠ xuanicán Mag­dala. ");
INSERT INTO tocNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Maka­pi­tzí̠n fariseos xa̠huá sadu­ceos táalh anta­nícu xla­ma̠chá Jesús la̠qui̠ xlacán nata­tzaksay y nata­ma̠­mo­ko­si̠­ya̠­huay; xlacán tahuá­nilh pi̠ cat­lá­hualh aktum lanca li̠cá̠cni̠t ta­scújut hua̠ntu̠ nata­siyuy la̠qui̠ xlacán nataucxilha y nata­ca̠­najlay para xli̠­ca̠na huá Dios xma­ca­mini̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pero huata xlá chiné ca̠kálh­ti̠lh: —Acxni̠ ko̠ta­nu̠­majá aya tzan­ka̠ma chi­chiní y ucxi­lhá̠tit pi̠ luu ca̠huán tasiyuy nac akapú̠n hua­ná̠tit: “Chú cha̠lí luu tla̠n huij nahuán quilh­ta­macú porque luu ca̠tzu­tzoko nac akapú̠n.” ");
INSERT INTO tocNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Y chi̠nchú para laca­tzi̠sa luu tata­puni̠t y ma̠rí lhca̠cnán, hua­ná̠tit: “Chú ma̠x ni̠ luu tla̠n cati­chi­chíni eé quilh­ta­macú porque luu tzu­tzoko akapú̠n xa̠huachí tapuc­sni̠t.” ¡Xli̠­ca̠na pi̠ luu mákat aktzan­ká̠tit! ¿Lácu chú tla̠n li̠ma̠­lak­chi­pi­ni̠­yá̠tit y aka­ta̠k­sá̠tit hua̠ntu̠ tasiyuy nac akapú̠n, pero chi̠nchú ni̠lay aka­ta̠k­sá̠tit hua̠ntu̠ la̠nchú ca̠li̠­ma̠­la­ca­hua̠­ni̠má̠n Dios eé quilh­ta­macú? ");
INSERT INTO tocNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","¡Koxu­taní̠n hui­xinín cris­tianos hua̠nti̠ lapá̠tit ca̠lacchú quilh­ta­macú porque xli̠­ca̠na pi̠ luu li̠xcáj­nit min­ta­pu­hua̠ncán, hui­xinín anka­lhi̠ná qui­la̠­mak­squi­ma̠­náhu xla­cata pi̠ cac­ca̠­li̠­ma̠­la­ca­hua̠ní̠n aktum lanca li̠cá̠cni̠t ta­scújut! Pero aquit laca­tancs cca̠­hua­niyá̠n pi̠ ni̠tu̠ cac­ti­ca̠­la­ca̠x­tlanín hua̠ntu̠ luu ucxilh­pu­tu­ná̠tit, huata mejor huá nac­ca̠­li̠­ma̠­la­ca­hua̠­ni̠yá̠n aktum ta­scújut cumu la̠ tu̠ Dios tit­lá­hualh nac xla­táma̠t pro­feta Jonás. Acxni̠ chuná ca̠hua­ni­ko̠lh xla̠ ca̠ak­xtek­yá̠­hualh y alhá. ");
INSERT INTO tocNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Maktum quilh­ta­macú acxni̠ dis­cí­pulos tapa̠­ta­cut­ko̠chá a̠li̠quilh­tu̠án chú­chut xlacán ni̠ tapá̠s­tacli para natalé̠n cax­ti­lá̠n­chahu hua̠ntu̠ nata­hua­ya̠chá acxni̠ nata­hua̠yán. ");
INSERT INTO tocNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Na̠ acxni­tiyá chú Jesús chiné ca̠huá­nilh: —Aquit cca̠­hua­niyá̠n pi̠ hui­xinín luu cuentaj cat­la­huátit xla­cata ni̠tu̠ naca̠­ma̠­pa­si̠yá̠n xle­va­du­rajcán fariseos y sadu­ceos. ");
INSERT INTO tocNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ama̠­ko̠lh dis­cí­pulos chiné tzú­culh tala̠­huaniy sac­stucán: —Ma̠x huá quin­ca̠­li̠­hua­nimá̠n porque ni̠ li̠mi­ná̠hu cax­ti­lá̠n­chahu. ");
INSERT INTO tocNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús tuncán cátzi̠lh hua̠ntu̠ xta­qui­lhuamá̠­nalh y chiné ca̠huá­nilh: —¿Túcu xpa̠­la­cata la̠n­tamá li̠hua­ná̠tit pi̠ ni̠tu̠ li̠ta­ná̠tit cax­ti­lá̠n­chahu? ¡Xli̠­ca̠na pi̠ ni̠lay ca̠naj­la­yá̠tit hua̠ntu̠ aquit ctla­huay! ");
INSERT INTO tocNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Lácu pi̠ nia̠ tiaka­ta̠k­sá̠tit y niaj pa̠s­ta­cá̠tit acxni̠ lá a̠ cti­ca̠­ma̠k­pi­tzí­nilh mac­qui­tzis cax­ti­lá̠n­chahu acxni̠ la̠ a̠ tita­huá̠­yalh ma̠x cumu akqui­tzis mi̠lh cris­tianos? Pus chú caqui­la̠­hua­níhu, ¿nícu pa̠li̠t can­a̠stas aka­tá̠x­tulh hua̠ntu̠ ni̠ tahua­ko̠lh? ");
INSERT INTO tocNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Na̠chu­na­li̠túm ma̠x na̠ niaj pa̠s­ta­cá̠tit acxni̠ la̠ a̠ cti­ca̠­li̠­má̠­hui̠lh caj mac­tujún cax­ti­lá̠n­chahu acxni̠ pu̠tum xta­hui­lá̠­nalh akta̠ti mi̠lh cris­tianos, chi̠nchú acxni̠ a̠má lá u̠cuanima, ¿nícu pa̠li̠t can­a̠stas aka­tá̠x­tulh hua̠ntu̠ ni̠ tahua­ko̠lh? ");
INSERT INTO tocNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Túcu chi̠nchú xpa̠­la­cata ni̠ liaka­tá̠k­stit pi̠ ni̠ huá aquit cli̠­chu­huí̠­nalh a̠má cax­ti­lá̠n­chahu hua̠ntu̠ nali̠­hua̠­ya­ná̠tit? Acxni̠ cli̠­chu­huí̠­nalh a̠má leva­dura, aquit xac­ca̠­hua­ni­pu­tuná̠n pi̠ luu cuentaj cat­la­huátit ni̠tu̠ tica̠­ma̠­pa­si̠yá̠n xta̠­yatcán fariseos y sadu­ceos porque luu xta̠­chuná xli̠­la­manka cumu lá leva­dura. ");
INSERT INTO tocNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Acxnicú chú xlacán taaká­ta̠ksli xla­cata pi̠ Jesús ni̠ huá xli̠­chu­hui̠­nama a̠má leva­dura hua̠ntu̠ ta̠t­la­huacán cax­ti­lá̠n­chahu hua̠ntu̠ huacán, huata huá xlá xli̠­chu­hui̠­nama la̠ta lácu xlacán xta­ma̠­kalh­chu­hui̠ni̠y cris­tianos a̠ma̠ko̠lh fariseos y sadu­ceos, porque huá u̠ma̠ko̠lh lac­chi­xcu­huí̠n ni̠ luu aksti̠tum xta­le̠­má̠­nalh xta­la­ca­pa̠s­tac­nicán. ");
INSERT INTO tocNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Acxni̠ chú Jesús ca̠tá̠­cha̠lh xdis­cí­pulos nac xapu̠­la­tama̠n hua̠ntu̠ xuanicán Cesarea de Filipo xlá chiné ca̠ka­lhás­quilh: —Acxni̠ cris­tianos quin­taucxilha, ¿tícuya̠ chixcú quin­ta­li̠­macá̠n? ");
INSERT INTO tocNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Xlacán takalh­tí̠­nalh: —Maka­pi­tzí̠n tahuán pi̠ mat huix Juan Bau­tista, hui̠ntí huam­paray pi̠ mat huix pro­feta Elías, osuchi mat huix a̠má pro­feta Jerem­ías, o la̠tachá tícuya̠ pro­feta tali̠­ma­ca̠ná̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Huata xlá chiné ca̠ka­lhas­quimpá: —Y chi̠nchú hui­xinín, ¿tícu luu lac­pu­hua­ná̠tit aquit? ");
INSERT INTO tocNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Pedro tuncán kálh­ti̠lh: —¡Huix Cristo Xka­huasa Dios hua̠nti̠ xli̠­ca̠na lama xas­tacná! ");
INSERT INTO tocNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesús chiné huá­nilh: —Luu ca̠na̠ li̠pa̠­xúhu cala­tapa Simón xka­huasa Jonás porque ni̠para caj cha̠tum chixcú ma̠ca­tzi̠­ni̠­ni̠tán hua̠ntu̠ huix aya catzi̠ya, sinoque huá Quin­tla̠t hua̠nti̠ hui­lachá nac akapú̠n ma̠ca­tzi̠­ni̠­ko̠­ni̠tán. ");
INSERT INTO tocNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Aquit laca­tancs cuaniyá̠n la̠nchú pi̠ huix nali̠­ma̠­pa̠­cu­hui̠­cana Pedro (huam­putún lanca chí­huix) y antá nac xok­spú̠n eé lanca chí­huix nac­ma̠­la­ca­tzu­qui̠y a̠ma̠ko̠lh cris­tianos hua̠nti̠ luu xli̠­ca̠na naquin­ta­li̠­pa̠­huán; y hua̠nchú ti̠ aquit nac­ca̠­ma̠­qui­lha­qui̠y ni̠para huá xli̠­maka­tli­hueke ca̠li̠ní̠n cati­maka­tlá­jalh. ");
INSERT INTO tocNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Xa̠huachí aquit nac­ma̠x­qui̠yá̠n a̠má xal­lave xta­péksi̠t Dios hua̠nti̠ huí nac akapú̠n. Aquit laca­tancs cuaniyá̠n pi̠ hua̠ntu̠ huix nachi̠ya uú nac ca̠quilh­ta­macú na̠chuná xata­chí̠n nata­hui­la­ya̠chá nac akapú̠n, y na̠chuná hua̠ntu̠ huix nax­cuta uú nac ca̠quilh­ta­macú na̠ xatax­cutni nahuán nac akapú̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Acxni̠ chú ta̠chu­hui̠­nan­ko̠lh Pedro, hua̠k ca̠li̠­ma̠­pék­si̠lh xdis­cí­pulos xla­cata pi̠ ni̠tícu cata­li̠­ta̠­chu­huí̠­nalh pi̠ xli̠­ca̠na huá Cristo hua̠nti̠ xmimaj ca̠lak­ma̠xtuy. ");
INSERT INTO tocNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Acxni­tiyá a̠má quilh­ta­macú Jesús luu tzú­culh ca̠ma̠­la­ca­pu̠­tun­cu­hui̠niy xdis­cí­pulos hua̠ntu̠ xamaj akspulay, xlá ca̠huá­nilh xla­cata pi̠ juerza xliánat xuani̠t nac xaca̠­chi­quí̠n Jeru­salén, xa̠huachí xana­puxcún cura xa̠huá xma̠­kalh­ta­hua­ke̠­nacán judíos xlacán la̠n xtaamá̠­nalh tama̠­pa̠­ti̠ni̠y. Xlá luu laca­tancs ca̠huá­nilh pi̠ namak­ni̠cán pero na̠ ca̠huá­nilh pi̠ caj xliaktutu quilh­ta­macú xama̠paj lacas­ta­cuanán nac ca̠li̠ní̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Huata Pedro tzinú ta̠ta­tam­pú̠x­tulh y antá chiné tzú­culh huaniy: —Quim­pu̠­chiná, ¡ni̠ cala­cás­quilh Dios para chuná huix naak­spu­layá̠n hua̠ntu̠ qui­lhuámpa̠t! Porque ni̠tlá̠n cati­qui̠­táx­tulh para túcu nala­niya. ");
INSERT INTO tocNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pero huata Jesús tala­kás­pitli y chiné huá­nilh Pedro: —¡Luu xli̠­ca̠na cat­lahua li̠tlá̠n cata­tam­pu̠xtu anta­nícu aquit cyá porque huix xta̠­chuná akska­huiní y caj qui­sa­ka̠­li̠ya! Xli̠­ca̠na pi̠ huix ni̠chuná kalhi̠ya min­ta­la­ca­pa̠s­tacni cumu lá laca­pa̠s­tacnán Dios huata huix chuná laca­pa̠s­tac­nana cumu lá tala­ca­pa̠s­tacnán cati̠hua lac­chi­xcu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Y aca­li̠stá̠n xlá pu̠tum ca̠huá­nilh xdis­cí­pulos: —Para tícu luu xli̠­ca̠na li̠tax­tu­putún cumu lá quin­ta­ma̠­kalh­ta­huaké̠n, pus huata luu xla­ca­squinca capa̠­tzán­ka̠lh hua̠ntu̠ caj sacstu lakati̠y li̠pa̠­xu­huay, mejor cacú­calh xcruz la̠qui̠ napa̠­ti̠nán caj quim­pa̠­la­cata y caquis­ta̠­lá­nilh. ");
INSERT INTO tocNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Porque hua̠nti̠ lak­ma̠x­tu­putún xla­táma̠t uú nac ca̠quilh­ta­macú ámaj ma̠lak­tzanke̠y; pero hua̠nti̠ nama̠­lak­tzan­ke̠­ya̠­huay xla­táma̠t caj quim­pa̠­la­cata, huata xla̠ luu laca­tancs pi̠ ama̠paj maka­mak­lhti̠nán nac xla­catí̠n Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Porque ¿túcu li̠ma­cuaniy cha̠tum chixcú para la̠n xká­lhi̠lh la̠ta túcu anán nac ca̠quilh­ta­macú y para antá nac xla­catí̠n Dios ámaj ma̠lak­tzanke̠y xla­táma̠t? ¿Osuchí nícu chulá tla̠n cxo­kóx­tulh xla­táma̠t cha̠tum chixcú xla­cata ni̠ napa̠­ti̠nán? ");
INSERT INTO tocNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Porque xli̠­ca̠na pi̠ ámaj cha̠n quilh­ta­macú acxni̠ aquit Xata­lac­sacni Chixcú nac­mim­paray y nac­li̠mín xli̠­hua̠k xli̠­lanca xli̠t­li­hueke hua̠ntu̠ kalhi̠y Quin­tla̠t, y na̠ hua̠k nac­ca̠­ta̠mín xán­geles la̠qui̠ aquit nac­ca̠­ma̠­xo­ko̠ni̠y xcuentajcán xli̠­hua̠k cris­tianos y cha̠­tunu cha̠­tunu nac­ca̠­ma̠­ka­lha­pali̠y la̠tachá túcu tatit­la­huani̠t nac ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Aquit laca­tancs cca̠­hua­niyá̠n pi̠ maka­pi­tzí̠n hua̠nti̠ uú tayá̠­nalh hasta nia̠ tani̠y nahuán acxni̠ nalak­chá̠n a̠má quilh­ta­macú acxni̠ xlacán naquin­taucxilha pi̠ nacmín xta̠­chuná cumu la̠ lanca rey hua̠nti̠ luu xli̠­ca̠na nama̠­pek­si̠nán. ");
INSERT INTO tocNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Li̠tzi̠­maya quilh­ta­macú xla­ca­tza̠­lani̠t la̠ta xca̠­li̠­ta̠­kalh­chu­hui̠­nani̠t xdis­cí­pulos huá la̠ta túcu xlá xámaj okspulay, Jesús ca̠ta̠­tá­ca̠xli Pedro, San­tiago y Juan, y antá ca̠ta̠­ta­la­cá̠c­xtulh nac aktum lanca ke̠stí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Acxni̠ chú aya xta­cha̠ni̠t nac xok­spún ke̠stí̠n caj sac­stucán xta­la­yá̠­nalh antá chú nac xla­ca­ti̠ncán a̠ma̠ko̠lh kalha­tutu xdis­cí­pulos xlá luu caj tunu tasí­yulh talak­pa­li̠­ko̠lh la̠ta lácu xta­siyuy anka­lhi̠ná. La̠ta nac xlacán luu li̠pe̠cua xma̠­la­ka­chi­xi̠nán cumu la̠ chi­chiní, y na̠chuná clháka̠t hua̠ntu̠ xlá clha­ka̠ni̠t luu slipua xta­siyuy xta̠­chuná cumu la̠ tax­káket. ");
INSERT INTO tocNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Na̠ acxni­tiyá chú taúcxilhli Moisés xa̠huá pro­feta Elías hua̠nti̠ maká̠n xta­la­ta­ma̠ni̠t xlacán xta­ta̠­chu­hui̠­na­má̠­nalh Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Huata Pedro tzú­culh chu­hui̠nán y chiné huá­nilh Jesús: —Quim­pu̠­chi­nacán, huata ma̠x xalí̠­huaca tla̠n antiyá uú luu xta­mak­xtekui. Para huix chuná laca­squina u̠ctla­hua­yá̠hu aktutu lactzu chiqui, aktum milá, aktum xlá Moisés y aktum xlá Elías. ");
INSERT INTO tocNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Chu­nacú xchu­hui̠­nama Pedro caj xamaktum tatu̠­tzú­hui̠lh aktum sna­papa puc­lhni y antá pu̠tum ca̠akmi­li­ko̠lh, y nac xlacni puc­lhni takáx­matli pi̠ tax­tuchi aktum tachu­huí̠n hua̠ntu̠ chiné huá: —Huá eé Quin­ka­huasa hua̠nti̠ aquit clac­sacni̠t y luu cpa̠x­qui̠y, y xma̠n huá luu caka­lha­kax­páttit. ");
INSERT INTO tocNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Acxni̠ xlacán takáx­matli eé tachu­huí̠n la̠li̠­huánta tatzo­kós­talh lí̠cha̠lh xla­cancán hasta nac ca̠ti­yatni caj la̠ta xta­pe̠­cuaxni̠­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesús ca̠lak­ta­la­ca­tzú­hui̠lh, ca̠quí̠­tok­lhli y chiné ca̠huá­nilh: —La̠li̠­huán cata̠­yátit, y ni̠ cape̠­cuántit. ");
INSERT INTO tocNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Acxni̠ talak­lá­ca̠lh niaj ti̠ taúcxilhli hua̠nti̠ xta­ta̠­chu­hui̠­na­má̠­nalh huata ca̠ta caj sacstu xláya Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Y acxni̠ aya xta­qui̠­tas­pit­má̠­nalh li̠huán xta­ta­la­ka­ka­lhu̠­ma̠­nanchi nac ke̠stí̠n, Jesús chiné ca̠li̠­ma̠­pék­si̠lh: —Ni̠tícu cali̠­ta̠­kalh­chu­hui̠­nántit u̠má tala­ca­huá̠n hua̠ntu̠ hui­xinín la̠nchú ucxilh­ni̠­tátit, hasta acxni̠ aquit Xata­lac­sacni Chixcú cla­cas­ta­cuanani̠t nahuán nac ca̠li̠ní̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Y a̠ma̠ko̠lh dis­cí­pulos taka­lhás­quilh Jesús: —¿Túcu xpa̠­la­cata tali̠­huán xma̠­kalh­ta­hua­ke̠­nacán judíos xla­cata pi̠ pu̠lh huá xli̠­mínit pro­feta Elías y aca­li̠stá̠n chú namín Cristo? ");
INSERT INTO tocNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús chiné ca̠kálh­ti̠lh: —Xli̠­ca̠na xlá pi̠ pu̠lh huá Elías mima y huá xlá amaj ca̠x­tla­huay tiji. ");
INSERT INTO tocNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero huata aquit laca­tancs cca̠­hua­niyá̠n xla­cata pi̠ pro­feta Elías aya qui̠­la­ni̠­tanchi, pero huata a̠ma̠ko̠lh cris­tianos hua̠nti̠ xala eé ca̠quilh­ta­macú ni̠para tzinú tala­ká­pasli para huá, huata caj catu̠huá hua̠ntu̠ xlacán talac­pu­huá­nilh y chuná chú tat­la­huá­nilh. Pus na̠chuná chú aquit Xata­lac­sacni Chixcú na̠ la̠n taamá̠­nalh quin­ta­ma̠­pa̠­ti̠ni̠y acxni̠ naquin­ta­chipay. ");
INSERT INTO tocNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ama̠­ko̠lh xdis­cí­pulos taaká­ta̠ksli pi̠ huá xlá xca̠­li̠­ta̠­kalh­chu­hui̠­nama Juan Bau­tista. ");
INSERT INTO tocNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Acxni̠ tácha̠lh anta­nícu xta­ta­mac­xtu­mi̠ni̠t lhu̠hua cris­tianos, cha̠tum chixcú lak­ta­la­ca­tzú­hui̠lh Jesús, laka­ta­tzo­kós­talh nac xla­catí̠n y chiné huá­nilh: ");
INSERT INTO tocNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Quim­pu̠­chi­nacán, cat­lahua li̠tlá̠n caqui­la­ka­lhá­manti, porque cli̠mín cha̠tum quin­ka­huasa hua̠nti̠ anka­lhi̠ná snoka uú̠n, y luu li̠pe̠cua la̠ta ma̠pa̠­ti̠ni̠y. Aca­tunu antá tapu̠­ya̠chá nac lhcúya̠t osuchí nac chú­chut. ");
INSERT INTO tocNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Aquit najatá cti­ca̠­li̠­mí­nilh min­ta­ma̠­kalh­ta­huaké̠n pero xlacán ni̠lay tama̠t­lá̠n­ti̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús chiné kalh­tí̠­nalh: —Koxu­taní̠n hui­xinín cris­tianos hua̠nti̠ ni̠lay maktum qui­la̠­li̠­pa̠­hua­ná̠hu, porque xli̠­ca̠na luu lani̠­tátit; ¿hasta ni̠n­co̠cxni nac­ti­ca̠­ta̠­la­ta­ma̠­ya̠ncú y nac­ca̠­ta̠­pa̠­ti̠yá̠n hua̠ntu̠ kalhi̠­yá̠tit min­ta̠­yatcán? La̠li̠­huán uú cali̠­tátit tamá kahuasa. ");
INSERT INTO tocNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Acxni̠ chú li̠chín­calh, Jesús laca­quílh­ni̠lh xes­pí­ritu akska­huiní y tla­káx­tulh nac xmacni a̠má kahuasa, acxni­tiyá chú a̠má kahuasa luu li̠huana̠ tat­lá̠n­ti̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Aca­li̠stá̠n a̠ma̠ko̠lh dis­cí­pulos tunuj tata̠­chu­huí̠­nalh Jesús y chiné taka­lhás­quilh: —¿Túcu xpa̠­la­cata aquinín ni̠lay ctla­kax­túhu a̠má xes­pí­ritu akska­huiní? ");
INSERT INTO tocNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Jesús chiné ca̠kálh­ti̠lh: —Hui­xinín ni̠ kalhi̠­yá̠tit li̠t­li­hueke nac min­ta­ca̠­naj­latcán xla­cata li̠huana̠ nali̠­pa̠­hua­ná̠tit Dios. Aquit laca­tancs cca̠­hua­niyá̠n pi̠ para hui­xinín caj xtzu­cútit kalhi̠­yá̠tit min­ta­ca̠­naj­latcán ca̠na̠ caj la̠ xliactzuná cumu la̠ xatalhtzi acula, y caj la̠ta hui­xinín xuanítit eé ke̠stí̠n: “Cata­ke̠nu antá la̠ta huila y capit tahui­laya a̠lacatunu”, pus a̠má ke̠stí̠n xli̠­ca̠na xlá pi̠ xta­ké̠­nu̠lh. Y ni̠para pu̠lactum xtahui hua̠ntu̠ hui­xinín ni̠lay xtla­huátit cumu para xli̠­ca̠na xli̠­pa̠­huántit Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Maktum quilh­ta­macú acxni̠ luu mac­xtum xta­lat­la̠­huán nac xapu̠­la­tama̠n Gali­lea, Jesús chiné ca̠huá­nilh xta­ma̠­kalh­ta­huaké̠n: —Xli̠­ca̠na pi̠ aquit Xata­lac­sacni Chixcú huí cha̠tum hua̠nti̠ ámaj qui­ma­ca­ma̠sta̠y nac xla­ca­ti̠ncán hua̠nti̠ quin­ta­si̠­tzi̠niy y ni̠ quin­taucxilh­putún. ");
INSERT INTO tocNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Xlacán naquin­ta­makni̠y, pero caj xliaktutu quilh­ta­macú nac­la­cas­ta­cuanam­paray nac ca̠li̠ní̠n. Acxni̠ xlacán takáx­matli la̠ta lácu namak­ni̠cán luu snu̠n tali̠­púhua. ");
INSERT INTO tocNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Acxni̠ Jesús chu xdis­cí­pulos tácha̠lh nac xaca̠­chi­quí̠n Caper­naum maka­pi­tzí̠n lac­chix­cu­huí̠n hua̠nti̠ ca̠ta ca̠ta xta­ma̠­la­ka­xo­ke̠nán im­pues­tos xalac pu̠si­culan tata̠­tá­nok­lhli Pedro nac tiji y chiné taka­lhás­quilh: —Chi̠nchú mima̠­kalh­ta­hua­ke̠­nacán, ¿lácu pi̠ ni̠ mak­la­ka­xo­ko̠nún nac pu̠si­culan xalac Jeru­salén? ");
INSERT INTO tocNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro kalh­tí̠­nalh: —Oh, na̠ mak­la­ka­xo­ko̠nún xlá. Acxni̠ chú cha̠lh Pedro nac chiqui la̠li̠­huán tánu̠lh la̠qui̠ nata̠­chu­hui̠nán Jesús, pero huata pu̠lh huá chiné huá­nilh: —Simón, ¿lácu huix lac­pu­huana? Ama̠­ko̠lh lac­lanca lac­ta­li̠­pa̠hu ma̠pek­si̠­naní̠n xala eé ca̠quilh­ta­macú, ¿pi̠ huá luu tama̠­la­ka­xoke̠y im­pues­tos hua̠nti̠ xta̠­chi­quicán, osuchí hua̠nti̠ tata­peksi̠y nac a̠laca­túnuj pu̠la­tama̠n hua̠ntu̠ taakchi­pa­hui­li̠ni̠t? ");
INSERT INTO tocNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro kalh­tí̠­nalh: —Xlacán huá tama̠­la­ka­xoke̠y hua̠nti̠ tama̠­peksi̠y xala a̠laca­tunu pu̠la­tama̠n. Jesús huampá: —Pus xli̠­ca̠na pi̠ huata hua̠nchú ti̠ xta̠­chi­quicán ni̠ xajuerza nala­ka­xo­ko̠nún. ");
INSERT INTO tocNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero huata la̠qui̠ ni̠tícu naquin­ca̠­li̠­hua­niyá̠n para ni̠ mak­la­ka­xo­ko̠­nu­ná̠hu, la̠li̠­huán huix capimpi nac pupunú, antá camaca­pi mili̠­ma̠s­lo­kuí̠n huá chú tu̠ pu̠lh napa̠ti̠y squi̠ti tuncán cama̠­cutu. Antá chú nac xquilhni namac­laya okxtum tumi̠n hua̠ntu̠ naacchá̠n nali̠­xo­koya a̠má li̠la­ka­xokó̠n xalac pu̠si­culan, naxo­koya quilá, chu milá. ");
INSERT INTO tocNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Na̠ acxni­tiyá chú a̠má quilh­ta­macú xdis­cí­pulos Jesus talak­ta­la­ca­tzú­hui̠lh y chiné taka­lhás­quilh: —La̠ta qui­li̠­lhu̠­huacán, ¿xatícu cahuá a̠tzinú tlak tali̠­pa̠hu nac xla­catí̠n Dios? ");
INSERT INTO tocNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesús tasá­nilh cha̠tum actzu kahuasa, íta̠t yá̠hualh ");
INSERT INTO tocNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","y chiné ca̠huá­nilh: —Xli̠­ca̠na aquit laca­tancs cca̠­hua­niyá̠n, para pi̠ hui­xinín ni̠ nalak­pa­li̠­yá̠tit min­ta­la­ca­pa̠s­tac­nicán y ni̠ nali̠­tax­tu­yá̠tit cumu la̠ lactzu camán hua̠nti̠ tla̠n ca̠ma̠­pek­si̠cán, pus ni̠lay cati­ta­nu̠­pítit nac xta­péksi̠t Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Pus hua̠nti̠ a̠tzinú tali̠­pa̠hu li̠tax­tu­putún nac xla­catí̠n Dios xma̠nhuá nama̠t­la̠nti̠y hua̠nti̠ luu ni̠para tzinú túcu xkásat namaklh­ca­tzi̠cán y nali̠­taxtuy cumu la̠ eé actzu kahuasa. ");
INSERT INTO tocNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Y chi̠nchú hua̠nti̠ pa̠xqui̠y y tla̠n nacatzi̠niy cha̠tum actzu kahuasa cumu la̠ eé caj xpa̠lacata cumu catzi̠y pi̠ aquit cpa̠xqui̠y pus luu xta̠chuná cumu la̠mpara aquit quimpa̠xqui̠ma y tla̠n quincatzi̠nima. ");
INSERT INTO tocNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Para tícuya̠ cris­tiano xca̠­ma̠t­lá­hui̠lh tala̠­ka­lhí̠n u̠ma̠ko̠lh lactzu camán hua̠nti̠ aya quin­ta­li̠­pa̠­huán ma̠squi luu ni̠para lac­li̠­ca̠na, huata tlan a̠má chixcú luu ma̠t­la̠nti̠y pu̠lh xpix­chi̠­nú̠­calh aktum lanca xachí­huix molino y antá lhken xma­cá̠n­calh nac xtampú̠n pupunú. ");
INSERT INTO tocNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Luu xli̠­ca̠na pi̠ ni̠para tzinú tla̠n la̠ta lama̠­náhu nac ca̠quilh­ta­macú, porque la̠tachá túcu anán hua̠k li̠lak­tzan­ka̠­ta̠­yacán; xlianka­lhí̠n chuná lámaj nahuán, pero ¡koxu­tacu tihuán a̠má chixcú hua̠nti̠ nama̠­tzu­qui̠y hua̠ntu̠ nata­li̠­lak­tzan­ka̠­ta̠yay xa̠maka­pi­tzí̠n! ");
INSERT INTO tocNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Pus huá xpa̠­la­cata cli̠­hua­niyá̠n pí para huá mimacán osuchí min­tantú̠n ma̠t­la­hui̠yá̠n tala̠­ka­lhí̠n, mejor caca̠cti y mákat camá­kanti; porque a̠tzinú lí̠huaca tla̠n nata­nu̠­ya̠pi nac xla­catí̠n Dios macalh­tulu y tan­tú̠­putu, y luu ni̠para tzinú tla̠n para acchá̠n kalhi̠ya makatiy mimacán y tan­tu̠tiy min­tantú̠n para antá chú nama­ca­pin­cana nac pu̠pa̠tí̠n anta­nícu la̠n huí lhcúya̠t cane̠c­xni­cahuá quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Y chi̠nchú para huá mila­kas­tapu ma̠t­la­hui̠yá̠n tala̠­ka­lhí̠n, mejor cala­ca­ta­mac­xtú­canti porque xalí̠­huaca tlá̠n nata­nu̠­ya̠pi nac xla­catí̠n Dios laka­xo̠ko y luu ni̠para tzinú tla̠n para acchá̠n kalhi̠ya lakati̠y mila­kas­tapu para antá chú nama­ca­pin­cana nac pu̠pa̠tí̠n anta­nícu la̠n huí lhcúya̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Ne̠c­xnicú tilak­ma­ka­ná̠tit u̠ma̠ko̠lh hua̠nti̠ aya quin­ta­li̠­pa̠­huani̠t ma̠squi ni̠para lac­li̠­ca̠na, porque aquit laca­tancs cca̠­hua­niyá̠n pi̠ xlacán taka­lhi̠y cha̠­tunu xán­geles hua̠nti̠ tamak­ta­kalh­má̠­nalh, y antá xlacán nac akapú̠n anka­lhi̠ná tali̠­ma­cuani­má̠­nalh Quin­tla̠­ticán Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Porque aquit Xata­lac­sacni Chixcú cmini̠t lak­ma̠xtuy hua̠nti̠ aya xta­lak­tzan­ka̠­ta̠­yani̠t uú nac ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’Pus para cha̠tum chixcú kalhi̠y aktum ciento xbor­regos y para xamaktum nama­ka­tzanka̠y tantum, ¿túcu hui­xinín lac­pu­hua­ni­yá̠tit nat­la­huay? Aquit clac­pu­huán pi̠ para xli̠­ca̠na pa̠x­qui̠y naca̠­mak­xteka xa̠maka­pi­tzí̠n ta̠ti­pu­xa­ma­cu̠­na­ja̠tza xla­cata sac­stucán nata­put­swa̠yán nac ca̠tu­huá̠n la̠qui̠ la̠li̠­huán naán putzay a̠má koxutá bor­rego hua̠ntu̠ maka­tzan­ka̠ni̠t, y ni̠ cati­tás­pitli hasta caní nata­maclay. ");
INSERT INTO tocNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Y para juerza naqui̠­maclay luu a̠tzinú li̠pa̠­xu­huay porque tasí­yulh a̠má tantum xbor­rego hua̠ntu̠ xma­ka­tzan­ka̠ni̠t, y ni̠ luu xta̠­chuná ca̠ta̠­pa̠­xu­huay a̠ma̠ko̠lh xa̠maka­pi­tzí̠n xbor­regos hua̠nti̠ ni̠tu̠ xta­tzan­ka̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Pus na̠ chuná chú Quin­tla̠t hua̠nti̠ hui­lachá nac akapú̠n xlá ni̠ lacas­quín ni̠para cha̠tum nalak­tzanka̠y hua̠nti̠ aquit quin­ta­li̠­pa̠­huán ma̠squi luu ni̠tu̠cu xkásat tasiyuy. ");
INSERT INTO tocNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Para huí cha̠tum min­ta̠­cris­tiano hua̠nti̠ tla­hua­ni­ni̠tán hua̠ntu̠ ni̠tlá̠n, luu laca­ti̠tum cata̠­chu­huí̠­nanti sacstu y cahuani xla­cata pi̠ luu cuentaj cat­lá­hualh porque ni̠tlá̠n hua̠ntu̠ tla­hua­ni­ni̠tán. Para xlá nakax­mat­niyá̠n hua̠ntu̠ huix nahua­niya, pus chú qui̠­taxtuy pi̠ huix aya ma̠aka­ta̠k­sni̠­ni̠ta cha̠tum hua̠nti̠ li̠taxtuy cumu la̠ min­ta̠lá. ");
INSERT INTO tocNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero para ni̠ nat­la­hua­niyá̠n cuenta y ni̠ tla̠n nat­la­hua­niyá̠n hua̠ntu̠ huix nahua­niya, pus huix la̠li̠­huán caca̠­ta­sani cha̠tum osuchí cha̠tiy tes­tigos hua̠nti̠ nata­kax­mata y nata­ma̠­lu­loka hua̠ntu̠ huix nali̠­ma̠­kalh­chu­hui̠­ni̠ya a̠má cris­tiano. ");
INSERT INTO tocNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Pero para na̠ ni̠para huá naca̠­kax­matniy hua̠ntu̠ xlacán nata­li̠­ta̠­chu­hui̠nán, pus huata chú tuncán caca̠­ma̠­ca­tzi̠ni hua̠nti̠ anka­lhi̠ná tata­mac­xtumi̠y takalh­ta­hua­kaniy Dios nac pu̠si­culan la̠qui̠ xlacá̠n huá nata­ma̠­kalh­chu­hui̠ni̠y. Cumu para chú xlá na̠ ni̠tlá̠n naca̠t­la­huaniy xta­chu­hui̠ncán hua̠ntu̠ nata­li̠­ma̠­kalh­chu­hui̠ni̠y hua̠nti̠ tata­mac­xtumi̠y nac pu̠si­culan, pus huata chú huix tla̠n nali̠­ma̠x­tuya a̠má chixcú cumu lá cha̠tum hua̠nti̠ niaj li̠pa̠­huán Dios, o cumu la̠ hua̠nti̠ niaj ca̠ta̠­ta­pek­si̠yá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Aquit laca­tancs cca̠­hua­niyá̠n xla­cata pi̠ hua̠ntu̠ hui­xinín nachi̠­yá̠tit uú nac ca̠quilh­ta­macú, pus na̠chuná tachí̠n hui­lachá nahuán nac akapú̠n; pero na̠chuná hua̠ntu̠ hui­xinín nax­cu­tá̠tit uú nac ca̠quilh­ta­macú na̠ xatax­cutni hui­lachá nahuán nac akapú̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Aquit laca­tancs cca̠­hua­niyá̠n pi̠ para hui­xinín ma̠squi min­cha̠­tiycán luu lac­xtum nali̠­ca­tzi̠­yá̠tit xla­cata para túcu nas­qui­ni­yá̠tit Dios acxni̠ nakalh­ta­hua­ka­ni­yá̠tit xli̠­ca̠na pi̠ huá Quin­tla̠t hua̠nti̠ hui­lachá nac akapu̠n naca̠­ma̠x­qui̠yá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Porque para nícu li̠cha̠tiy o li̠ka­lha­tutu tata­mac­xtumi̠y hua̠nti̠ quin­ta­li̠­pa̠­huán antá aquit íta̠t cca̠­lak­sti̠­pa̠­láyaj nahuán. ");
INSERT INTO tocNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pedro lak­ta­la­ca­tzú­hui̠lh Jesús y chiné kalhás­quilh: —Quim­pu̠­chiná, chi̠nchú para cha̠tum quin­ta̠­cris­tiano anka­lhi̠ná quin­ta̠­ra̠t­la­huay, ¿nícu luu makli̠t nac­ta̠­pa̠ti̠y y nac­ma̠­tzan­ke̠­naniy? ¿Lácu pi̠ hasta mak­tujún? ");
INSERT INTO tocNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús kálh­ti̠lh: —Aquit ni̠tu̠ cuanimá̠n para caj mak­tujún nata̠­pa̠­ti̠ya y nama̠­tzan­ke̠­na­niya, huata huix tla̠n nama̠­tzan­ke̠­na­niya y nata̠­pa̠­ti̠ya hasta ma̠squi akta̠ti ciento a̠ta̠ti­pu­xa­ma­cá̠hu para chuná nata­la­cas­quín y na̠chuná para namak­la̠­ka­lhi̠yá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Amá xta­péksi̠t Dios hua̠ntu̠ ma̠la­ca­tzu­qui̠ma uú nac ca̠quilh­ta­macú xta̠­chuná qui̠­taxtuy cumu la̠ cha̠tum rey hua̠nti̠ tica̠­ta̠t­la­hua­pú­tulh cuenta la̠qui̠ naca­tzi̠y nícu chulá tala­ka­hui­lá­nilh xta­sa̠­cuá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Aya xtzu­cu­ni̠ttá ca̠ta̠t­la­huay cuenta acxni̠ li̠chi­ní­calh cha̠tum xta­sa̠cua hua̠nti̠ xla­ka­hui­lá­nilh lhu̠hua tumi̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pero cumu a̠má chixcú ni̠tu̠ xka­lhi̠y hua̠ntu̠ nali̠­xo­ko̠nún, a̠má rey ma̠pek­sí̠­nalh xla­cata pi̠ cas­tá̠­calh a̠má chixcú cumu lá cha̠tum tachí̠n xa̠huá xpusca̠t chu xca­maná̠n, y pu̠tum la̠tachá túcu xlá xka­lhi̠y actzú nac xchic la̠qui̠ chú chuná nali̠­ta­xo­ko̠nún hua̠ntu̠ xlá xla­kahui. ");
INSERT INTO tocNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Huata a̠má tasa̠cua laka­ta­tzo­kós­talh nac xla­catí̠n xpatrón y chiné huá­nilh: “Patrón, xli̠­ca̠na luu cli̠­ma̠aka­tzan­ke̠yá̠n cat­lahua lanca li̠tlá̠n caquin­ta̠­pa̠ti a̠tzínu. Aquit hua̠k nac­xo­ko­niyá̠n hua̠ntu̠ cla­ka­hui­lanín, pero ni̠ caqui­la̠s­tá̠hu.” ");
INSERT INTO tocNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Amá rey laka­lhá­malh ma̠tzan­ke̠­ná­nilh y niaj ma̠tá̠­ji̠lh hua̠ntu̠ xla­ka­hui­lá­nilh y aca­li̠stá̠n mák­xtekli la̠qui̠ caalhá nac xchic. ");
INSERT INTO tocNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Pero caj la̠ta tax­tuchá nac tiji a̠má tasa̠cua xlá ta̠tá­nok­lhli cha̠tum xta̠­ta­sa̠cua hua̠nti̠ na̠ xlac­le̠niy actzu cin­tavu. Xlá ma̠chó­kolh y li̠pix­chí­palh xmacán tzú­culh pix­pitay y chiné huá­nilh: “La̠n­chuj­tuncán cla­cas­quín caqui­lak­xo­koni a̠má quin­tumi̠n hua̠ntu̠ qui­la­ka­hui­lani osuchí naquin­ti­la­ka­pa­sacú tícu aquit.” ");
INSERT INTO tocNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Pero huata a̠má xta̠­ta­sa̠cua laka­ta­tzo­kós­talh nac xla­catí̠n y chiné li̠ma̠­ka­tzán­ke̠lh: “Luu xli̠­ca̠na cat­lahua lanca li̠tlá̠n caj a̠tzinú caquin­ta̠­pa̠ti, pero hua̠k nac­la­ka­xo­ko­niyá̠n hua̠ntu̠ cla­ka­hui­lanín.” ");
INSERT INTO tocNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero a̠má chixcú xlá ni̠ ta̠pá̠­ti̠lh, mejor ma̠ta­mac­nu̠­ní̠­nalh nac pu̠la̠­chi̠n y ni̠ mak­xték­calh hasta caní afuerza ma̠xo­ko̠­ni̠­ko̠lh a̠má actzu tumi̠n hua̠ntu̠ xlá xla­ka­hui­lá­nilh. ");
INSERT INTO tocNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Acxni̠ xa̠maka­pi­tzí̠n xta̠­ta­sa̠­cuá̠n tacá­tzi̠lh hua̠ntu̠ xlá xtla­huani̠t a̠má xta̠­ta­sa̠­cuacán xlacán luu xli̠­ca̠na tali̠­sí̠­tzi̠lh huata la̠li̠­huán táalh tahuaniy xpat­roncán. ");
INSERT INTO tocNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Acxni̠ chú hua­ni­kó̠­calh, a̠má rey tuncán alh ma̠ta­sa­ni̠nán a̠má chixcú y chiné huá­nilh acxni̠ laca­quílh­ni̠lh: “Pa̠x­ca­tacu tihuana huix chixcú. Xli̠­ca̠na pi̠ ni̠para tzinú mini̠­niyá̠n nati­la­ta­pa̠­yacú maka̠s nac ca̠quilh­ta­macú. Aquit cma̠­tzan­ke̠­nanín y cta̠­pa̠tí̠n hua̠ntu̠ huix xqui­la­ka­hui­lani porque luu hasta xli̠­ca̠na li̠tlá̠n quis­quini xla­cata pi̠ cac­ma­ka­ka­lhí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Pus huix na̠chuná xti­la­ka­lhá­manti a̠má koxutá min­ta̠­ta­sa̠cua chuná cumu la̠ aquit cla­ka­lha­ma­ni̠tán y cta̠­pa̠­ti̠­ni̠tán.” ");
INSERT INTO tocNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Y luu li̠pe̠cua la̠ta sí̠tzi̠lh a̠má patrón y ma̠pek­sí̠­nalh xla­cata la̠n cama̠­pa̠­ti̠­ní̠­calh hasta caní naxo­koko̠y hua̠ntu̠ xla­kahui. ");
INSERT INTO tocNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Acxni Jesús chuná chu­hui̠­nan­ko̠lh chiné ca̠huá­nilh: —Pus na̠chuná naca̠t­la­huayá̠n Quin­tla̠t hua̠nti̠ hui­lachá nac akapú̠n para ni̠ ya̠ tapa̠­xu­huá̠n nama̠­tzan­ke̠­na­ni­yá̠tit min­ta̠­cris­tianojcán hua̠nti̠ naca̠­ta̠­ra̠t­la­huayá̠n y catu̠huá naca̠t­la­hua­niyá̠n hua̠ntu̠ ni̠tlá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Acxni̠ Jesús chuná ca̠ma̠­kalh­chu­hui̠­ni̠­ko̠lh xlá antá cha̠lh nac xapu̠­la­tama̠n Judea lacatzú hua̠ntu̠ xta̠­pek­xtokui kalh­tu̠­choko hua̠ntu̠ hua­nicán Jordán. ");
INSERT INTO tocNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Luu lhu̠hua cris­tianos ta­sta̠­lá­nilh y antá xlá ca̠ma̠t­la̠n­ti̠chá xli̠­hua̠k ta̠tat­laní̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Maka­pi­tzí̠n fariseos talak­ta­la­ca­tzú­hui̠lh la̠qui̠ chicá para túcu ni̠ tancs nakalh­ti̠nán y chuná tla̠n nata­li̠­ma̠­mo­ko­si̠­ya̠­huay, y chiné taka­lhás­quilh: —¿Lácu huix huana, pi̠ kalhi̠y dere­cho namak­xteka xpusca̠t cha̠tum chixcú ma̠squi ni̠tu̠ le̠n cuenta? ");
INSERT INTO tocNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús ca̠kálh­ti̠lh: —¿Lácu pi̠ nia̠ li̠kalh­ta­hua­ka­yá̠tit hui­xinín hua̠ntu̠ tatzok­ta­hui­lani̠t nac xta­chu­huí̠n Dios? Antá huan xla­cata pi̠ acxni̠ Dios ma̠la­ca­tzú­qui̠lh ca̠quilh­ta­macú xlá tlá­hualh cha̠tum chixcú y cha̠tum pusca̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Y na̠ chiné li̠ma̠­pek­sí̠­nalh: “Huá xpa̠­la­cata, cha̠tum kahuasa acxni̠ nata­maka­xtoka tla̠n akxtek­makán xtla̠t chu xtzí la̠qui̠ xlá nata̠­ta­lak­xtumi̠y xpusca̠t, y a̠má kahuasa chu tzuma̠t hua̠nti̠ xcha̠­tiycán xta­huani̠t chú luu cha̠­tumá nata­li̠­taxtuy.” ");
INSERT INTO tocNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Pus qui̠­taxtuy pi̠ acxni̠ nata­maka­xtoka niaj xcha̠­tiycán huata cha̠­tumá nata­huán. Hua̠ cca̠­li̠­hua­niyá̠n, ni̠ anán cris­tiano hua̠nti̠ mini̠niy nama̠­paj­pi­tziy hua̠ntu̠ Dios ma̠la­cas­tucni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Xlacán taka­lhas­quimpá: —Bueno, pero ¿túcu chú xpa̠­la­cata nac xli̠­ma̠­peksí̠n Moisés huan pi̠ cha̠tum chixcú tla̠n namak­xteka xpusca̠t pero pu̠lh nata̠­la­ca̠xlay nac pu̠chu­huí̠n y nama­ca­ma̠x­qui̠y mactum xata­la­ca̠xlán cáp­snat, nafir­mar­tla­huaniy y antá nahuán hua̠ntu̠ xpa̠­la­cata la̠li̠­mak­xtekma? ");
INSERT INTO tocNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús ca̠huá­nilh: —Moisés ma̠t­lá̠n­ti̠lh pi̠ nata­la̠­mak­xteka hua̠nti̠ tata­maka­xtokni̠t caj huá xpa̠­la­cata pi̠ hui­xinín luu xli̠­ca̠na snu̠n lani̠­tátit y ni̠lay aka­ta̠k­sá̠tit hua̠ntu̠ xatlá̠n tala­ca­pa̠s­tacni; pero la̠ta Dios ma̠la­ca­tzú­qui̠lh a̠má xapu̠lh chixcú xa̠huá xapu̠lh pusca̠t xlá ne̠c­xnicú tla̠n tla­huani̠t nata­la̠­mak­xteka hua̠nti̠ tata­maka­xtokni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Aquit laca­tancs cca̠­hua­niyá̠n pi̠ para cha̠tum chixcú namak­xteka xpusca̠t ma̠squi xlá a̠má pusca̠t ni̠tu̠ xakatli̠y a̠tunuj chixcú, y a̠má chixcú nata̠­ta­maka­xtoka túnuj pusca̠t, xli̠­ca̠na pi̠ luu lhu̠hua tala̠­ka­lhí̠n tla­huay porque xlá caj lac­tla­hua­ya̠­huay aktum tamaka­xtókot, y na̠chuná a̠má chixcú hua̠nti̠ nata̠­ta­maka­xtoka a̠má pusca̠t hua̠nti̠ mak­xtek­cani̠t xlá na̠ luu lhu̠hua tala̠­ka­lhí̠n tla­huay porque xlá maktum pi̠ lac­tla­huako̠y a̠má tamaka­xtókot hua̠ntu̠ Dios tisi­cu­la­na̠t­lá­hualh. ");
INSERT INTO tocNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Xdis­cí­pulos chiné tahuá­nilh: —Pus para xli̠­ca̠na chuná qui̠­tax­tuniy cha̠tum chixcú hua̠ntu̠ huix qui­lhuámpa̠t xla­cata pi̠ ni̠ xli̠­mak­xtéket xpusca̠t, pus luu ni̠para tzinú li̠ta­maka­xtok­putu. ");
INSERT INTO tocNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús ca̠huá­nilh: —Xli̠­ca̠na pi̠ huá eé tala­ca­pa̠s­tacni xla­cata lácu xli̠­la­ta­ma̠tcán hua̠nti̠ tamaka­xtoka ni̠lay taaka­ta̠ksa xli̠­hua̠k cris­tianos huata caj xma̠n huá taaka­ta̠ksa hua̠nti̠ Dios ca̠ma̠x­qui̠y tala­cas­quín pi̠ cataaká­ta̠ksli. ");
INSERT INTO tocNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Xa̠huá uú nac ca̠quilh­ta­macú tala­má̠­nalh maka­pi­tzí̠n lac­chi­xcu­huí̠n hua̠nti̠ chuná taka­lhi̠y xmac­nicán pi̠ ni̠lay cati­ta­ta­ma­káx­tokli, y maka­pi­tzí̠n hua­tuní̠n lac­chix­cu­huí̠n hua̠nti̠ caj chuná lac­tla­hua­ya̠­hua­ni­cani̠t xla­ta­ma̠tcán xla­cata niaj ne̠c­xnicú nata­ta­maka­xtoka, pero chú na̠ tala­má̠­nalh maka­pi­tzí̠n hua̠nti̠ tla̠n tata­maka­xtoka pero ni̠ tata­maka­xtok­putún caj cumu xlacán taca­tzi̠y pi̠ chuná a̠tzinú tla̠n natat­la­huay hua̠ntu̠ Dios lakati̠y y hua̠ntu̠ xlá ca̠li̠­lac­sacni̠t. Pus hua̠nti̠ ma̠t­la̠nti̠y pi̠ chuná nala­tama̠y cumu la̠ cca̠­hua­ni­ni̠tán ucú, pus xli̠­ca̠na pi̠ chuná calak­tzák­salh. ");
INSERT INTO tocNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Maka­pi­tzí̠n cris­tianos tali̠­mí­nilh lactzu xca­mancán anta nícu xuí Jesús la̠qui̠ xlá nakalh­ta­hua­kaniy Dios xpa̠­la­ca­tacán y naca̠­si­cu­la­na̠t­la­huay. Pero huata xdis­cí­pulos tzú­culh tala­ca­quilhni̠y hua̠nti̠ xta­li̠­mi­má̠­nalh a̠ma̠ko̠lh lactzu camán. ");
INSERT INTO tocNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Y Jesús chiné ca̠huá­nilh: —Luu xli̠­ca̠na cat­la­huátit li̠tlá̠n ni̠ caca̠­li̠­hua­nítit tama̠­ko̠lh lactzu camán xla­cata naquin­ta­lakmín anta­nícu aquit cuí, porque xli̠­ca̠na pi̠ caj xma̠nhuá hua̠nti̠ kalhi̠y xta­la­ca­pa̠s­tacni cumu la̠ actzu kahuasa xlá luu lak­chá̠n pi̠ namaka­maklhti̠nán hua̠ntu̠ Dios ca̠ma̠x­qui̠­pu­tuná̠n y tla̠n nata­ta­nu̠­ya̠chá nac xta­péksi̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Aca­li̠stá̠n chú xlá ca̠liacchí­palh xmacán y ca̠si­cu­la­na̠t­lá­hualh a̠ma̠ko̠lh lactzu camán. Acxni̠ chú chuná ca̠t­la­hua­ko̠lh Jesús tatam­pú̠x­tulh y alh a̠laca­tunu. ");
INSERT INTO tocNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Maktum quilh­ta­macú cha̠tum kahuasa luu rico xuani̠t qui̠­lák­lalh Jesús y chiné kalhás­quilh: —Ma̠kalh­ta­hua­ke̠ná, ¿túcu luu qui­li̠t­lá­huat la̠qui̠ tla̠n nac­ka­lhi̠y a̠má latáma̠t hua̠ntu̠ ne̠c­xnicú lak­sputa? ");
INSERT INTO tocNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús kálh­ti̠lh: —¿Túcu xla­cata qui­li̠­hua­niya para aquit luu tla̠n cca­tzi̠y? Caj xma̠n cha̠tum anán hua̠nti̠ xli̠­ca̠na tla̠n catzi̠y, caj xma̠n huá Dios hua̠nti̠ aquit cuanima. Pus cumu para xli̠­ca̠na huix kalhi̠­pu­tuna a̠má latáma̠t hua̠ntu̠ ne̠cxni lak­sputa, aquit cuaniyá̠n pi̠ calak­tzaksa cat­lahua xli̠­ma̠­peksí̠n Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Amá kahuasa huá­nilh: —¿Xatú­cuya̠ li̠ma̠­peksí̠n hua̠ntu̠ huix hua­nípa̠t? Jesús kálh­ti̠lh: —Ne̠c­xnicú timak­ni̠­nana, ni̠ caxa­katli tunuj pusca̠t para huí mim­pusca̠t, ni̠tu̠ tika­lha̠­nana, ne̠c­xnicú tima̠x­tu­niya taaksaní̠n min­ta̠­cris­tiano, ");
INSERT INTO tocNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","caca̠­pa̠xqui min­tla̠t chu mintzí, y na̠ caca̠­la­ka­lhá­manti xli̠­hua̠k min­ta̠­cris­tianos chuná cumu la̠ pa̠x­qui̠­cana me̠cstu. ");
INSERT INTO tocNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Amá kahuasa huá­nilh: —Pu̠tum hua̠ntu̠ huix qui­hua­nípa̠t aquit hua̠­katá ctla­huani̠t hasta la̠ta actzu̠cú xacuani̠t ctzu­cuni̠t ma̠kan­taxti̠y. ¿Túcu chi̠nchú quin­tzan­ka̠niy hua̠ntu̠ qui­li̠t­lá­huat? ");
INSERT INTO tocNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús huá­nilh: —Para xli̠­ca̠na luu aksti̠tum lata­pa̠­pu­tuna, pus la̠li̠­huán capimpi nac mín­chic y casta̠t xli̠­hua̠k hua̠ntu̠ kalhi̠ya, y a̠má min­tumi̠n hua̠ntu̠ namak­lhti̠­nana caca̠­ma̠akpi­tzini hua̠nti̠ lak­li̠­ma̠x­kení̠n la̠qui̠ chuná huix naka­lhi̠ya cumu la̠ min­tumi̠n antá nac akapú̠n. Acxni̠ chú chuná nat­la­hua­ko̠ya la̠li̠­huán natam­pa­raya la̠qui̠ huix na̠ naquis­ta̠­la­niya. ");
INSERT INTO tocNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pero acxni̠ a̠má kahuasa káx­matli hua̠ntu̠ hua­ní­calh luu xli̠­ca̠na cha̠­li̠­pu­hua̠na̠ alh porque xlá luu rico xuani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesús chiné ca̠huá­nilh xdis­cí­pulos: —Aquit laca­tancs cca̠­hua­niyá̠n pi̠ luu tuhua xla­cata lac­rrico nata­ta­nu̠­ya̠chá nac xta­péksi̠t Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Huata ni̠ xatuhua xtá­nu̠lh tantum camello nac xtzan li̠tzapan, pero hua̠ntu̠ xla­ca­tacán lac­rrico ni̠lay cati­ta­ta­nu̠chá nac xta­péksi̠t Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Acxni̠ a̠ma̠ko̠lh xdis­cí­pulos takáx­matli xta­chu­huí̠n luu cacs tali̠­la­cáhua y tzú­culh tala̠­ka­lhas­quín sac­stucán: —¿Tícu chi̠nchú luu nalak­ma̠xtuy xli̠s­tacni? ");
INSERT INTO tocNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús ca̠lak­lá­ca̠lh y chiné ca̠huá­nilh: —Xli̠­ca̠na pi̠ hua̠ntu̠ xla­ca­tacán lac­chix­cu­huí̠n ni̠lay tama̠t­la̠nti̠y hua̠ntu̠ aquit cqui­lhuama, pero hua̠ntu̠ xla­cata Dios ni̠para pu̠lactum huí hua̠ntu̠ nalac­pu­hua­ná̠tit para ni̠lay tla­huay. ");
INSERT INTO tocNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pedro chiné huá­nilh: —Ma̠kalh­ta­hua­ke̠ná, aquinín hua̠k cak­xtek­ma­ka­ni̠­táhu hua̠ntu̠ xac­ka­lhi̠­yá̠hu caj xpa̠­la­cata cumu huix cca̠s­ta̠­la­ni­ni̠tán, pus ¿túcu chi̠nchú naquin­ca̠­ma̠x­qui̠­caná̠n aca­li̠stá̠n? ");
INSERT INTO tocNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús ca̠kálh­ti̠lh: —Aquit xli̠­ca̠na cca̠­hua­niyá̠n pi̠ acxni̠ nalak­chá̠n quilh­ta­macú acxni̠ xli̠­hua̠k hua̠ntu̠ anán uú nac ca̠quilh­ta­macú hua̠k nali̠­taxtuy cumu la̠ xasa̠sti, acxni̠ chú aquit Xata­lac­sacni Chixcú nac­ta­hui­la­ya̠chá nac xali̠­la­káti̠t qui­lac­tá­hui̠lh hua̠ntu̠ huí nac quim­pu̠­ma̠­peksí̠n, y chi̠nchú hui­xinín hua̠nti̠ anka­lhi̠ná qui­la̠s­ta̠­la­ni­ma̠­náhu pus hui­xinín na̠ naka­lhi̠­yá̠tit milac­ta­hui̠lhcán hua̠ntu̠ huí akcu̠tiy lac­tá­hui̠lh la̠qui̠ chuná hui­xinín namak­ma̠­pek­si̠­yá̠tit a̠má pu̠lac­cu̠tiy xapu̠­la­tama̠n Israel hua̠ntu̠ luu pu̠lh tica̠­ma̠­la­ca­tzu­quí̠­calh. ");
INSERT INTO tocNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Y xli̠­pu̠tum hua̠nti̠ taak­xtek­makani̠t xchiccán, osuchí xna­ta̠­lancán, para xtla̠tcán xa̠huá xtzicán, chuná para xpusca̠t osuchí xca­maná̠n, na̠chuná para taak­xtek­makani̠t xpu̠­cux­tucán caj xpa̠­la­cata pi̠ aquit quin­ta­sta̠­la­nini̠t y quin­ta­li̠­pa̠­huani̠t, la̠ta pu̠la­ca­tunu hua̠ntu̠ akxtek­makani̠t qui̠­taxtuy napu̠­xo­ko­nicán y hasta aka­tunu ciento li̠huacay la̠ta namak­lhti̠­nam­paray, y xa̠huachí a̠má cris­tianos namak­lhti̠nán a̠má latáma̠t hua̠ntu̠ ne̠c­xnicú lak­sputa. ");
INSERT INTO tocNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pus lhu̠hua lac­ta­li̠­pa̠hu cris­tianos hua̠nti̠ la̠nchú luu tama­ca­pu̠­la­má̠­nalh, aca­li̠stá̠n huata xlacán a̠huatá tahui­lá̠­nalh nahuán; y lhu̠hua hua̠nti̠ la̠nchú ni̠tu̠cu xka­satcán tali̠­taxtuy luu a̠huatá taqui̠­tax­tu­má̠­nalh, pero acxni̠ chú a̠má quilh­ta­macú huata pu̠lh huá naca̠­ma̠x­qui̠cán xpu̠­ta­hui̠lhcán nac akapú̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Amá xasa̠sti xta­péksi̠t Dios hua̠ntu̠ ma̠la­ca­tzu­qui̠ma, luu xta̠­chuná qui̠­taxtuy cumu la̠ cha̠tum chixcú xpu̠­chiná aktum lanca pú̠cuxtu hua̠nti̠ alh ca̠pu­tzay laca­tzi̠sa xta­sa̠­cuá̠n la̠qui̠ nataán tapuxniy xachá̠n xuvas. ");
INSERT INTO tocNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Xlá ca̠qui̠­mác­lalh maka­pi­tzí̠n hua̠nti̠ xtas­cuj­putún y ca̠ta̠­la­cá̠x­lalh xla­cata naca̠­li̠­ma̠s­ka­hui̠y aktum denario tumi̠n caj la̠ta tan­tacú natas­cuja, aca­li̠stá̠n chú ca̠má­ca̠lh nac xca̠­tu­huá̠n la̠qui̠ antá natas­cuja. ");
INSERT INTO tocNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Caj li̠puntzú tax­tupá a̠má chixcú ma̠x cumu ca̠mak­na­ja̠tza hora, y na̠chuná ca̠ucxilhpá maka­pi­tzí̠n lac­chix­cu­huí̠n hua̠nti̠ na̠ caj chu­natá xta­la­hui­lá̠­nalh nac plaza y ni̠tu̠ xta­li̠s­cuj­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Xlá ca̠huá­nilh: “¡Kahua, hui­xinín na̠ capim­pítit nac quin­ca̠­tu­huá̠n y antá cas­cújtit, ni̠tu̠ capu­huántit aquit nac­ca̠­ma̠x­qui̠yá̠n min­tas­kahucán hua̠ntu̠ lak­chá̠n!” Pus xlacán na̠ táalh tas­cuja. ");
INSERT INTO tocNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Amá patrón taca̠xpá ma̠x cumu tas­túnut y aca­li̠stá̠n chú na̠ ampá cumu ca̠mak­tutu hora, y na̠chuná ca̠qui̠­pu­tzapá xta­sa̠­cuá̠n hua̠nti̠ natas­cuja nac xca̠­tu­huá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Acxni̠ chú lak­cha̠mpá ca̠mak­qui­tzis hora la̠ta aya ko̠ta­nu̠ko̠y xla̠ ampá nac plaza y na̠chuna li̠túm ca̠ucxilhpá maka­pi­tzí̠n lac­chix­cu­huí̠n hua̠nti̠ caj chu­natá xta­hui­lá̠­nalh y ni̠tu̠ xta­li̠s­cuj­má̠­nalh. Xlá ca̠huá­nilh: “¿Túcu la̠n­tamá xpa̠­la­cata caj luu chu­natá lahui­látit tan­tacú y ni̠tu̠ li̠­scuj­pá̠tit?” ");
INSERT INTO tocNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Xlacán takalh­tí̠­nalh: “Porque eé quilh­ta­macú ni̠ti̠ quin­ca̠­ma̠x­qui̠­ni̠tán li̠ta­scújut.” Amá patrón chiné ca̠huá­nilh: “Cumu para luu xli̠­ca̠na scuj­pu­tu­ná̠tit la̠li̠­huán capim­pítit nac quin­ca̠­tu­huá̠n la̠qui̠ antá nas­cu­já̠tit, y ni̠tu̠ capu­huántit porque aquit nac­ca̠­ma̠s­ka­hui̠yá̠n hua̠ntu̠ ca̠lak­cha̠ná̠n mili̠­tas­cu­jutcán.” ");
INSERT INTO tocNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Acxni̠ chú aya ca̠puc­suanko̠lh, a̠má patrón chiné huá­nilh hua̠nti̠ xca̠­ma̠­mak­ta­kalhni̠y xta­sa̠­cuá̠n: “La̠li̠­huán caca̠­ta­sani quin­ta­sa̠­cuá̠n y caca̠­ma̠s­kahui, pero pu̠lh huá caca̠­ma̠s­kahui hua̠nti̠ a̠huatá tachini̠t la̠qui̠ chú a̠huatá naca̠­ma̠s­ka­hui̠ya hua̠nti̠ aya tan­tacuá tas­cuj­má̠­nalh.” ");
INSERT INTO tocNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Acxni̠ tata­la­ca­tzú­hui̠lh a̠máko̠lh tasa̠­cuá̠n hua̠nti̠ xta­tzu­cuni̠t tas­cuja ma̠x cumu a las cinco de la tarde pus la̠ta cha̠­tunu tasa̠­cuá̠n tzú­culh tamaklh­ti̠nán aka­tunu denario tumi̠n hua̠ntu̠ xca̠­li̠­ma̠s­ka­hui̠­má̠­calh tan­tacú xla­cata. ");
INSERT INTO tocNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Y chi̠nchú acxni̠ xaa̠hua­tiyá tzú­culh tata­la­ca­tzu­hui̠y a̠ma̠ko̠lh tasa̠­cuá̠n hua̠nti̠ tzi̠saj tuncán xta­tzu­cuni̠t tas­cuja xlacán tzú­culh talac­pu­huán pi̠ ma̠x a̠tzinú luu lhu̠hua naca̠­ma̠x­qui̠cán xtas­kahucán, pero ni̠tu̠ ca̠ma̠­li̠­hua­qui̠­ní­calh huata na̠ chu­na­tiyá aka­tunu denario ca̠ma̠x­quí̠­calh xtas­kahucán. ");
INSERT INTO tocNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Acxni̠ chú xlacán tamaklh­ti̠­nan­ko̠lh taúcxilhli pi̠ na̠ chu­na­tiyá, tzú­culh tali̠­ma̠aklhu̠­hui̠y xpat­roncán. ");
INSERT INTO tocNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Chiné tahuá­nilh: “Uma̠­ko̠lh maka­pi­tzí̠n hua̠nti̠ a̠huatá tachilh y caj xma̠n aktum hora tás­cujli, ¿túcu chú xpa̠­la­cata na̠ chu­na­tiyá ca̠ma̠s­ka­huí̠pa̠t cumu lá̠ aquinín qui­la̠­ma̠s­ka­hui̠­ma̠­náhu ma̠squi aquinín tan­tacú xacak­sti̠­pu̠ani̠­ni̠­táhu chi­chiní, la̠n ckalh­pu̠­tí̠hu y na̠ luu la̠n clhca̠cui?” ");
INSERT INTO tocNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Amá patrón chiné kálh­ti̠lh cha̠tum tasa̠cua hua̠nti̠ luu xma̠aklhu̠­hui̠ma: “Amigo, aquit ni̠tu̠ cak­ska­hui­mak­lhti̠má̠n min­tas­kahu. ¿Lácu pi̠ niaj pa̠s­taca pi̠ hua­tiyá aktum denario cta̠­la­ca̠x­la­ni̠tán nac­ma̠s­ka­hui̠yá̠n? ¿Túcu chi̠nchú luu hua­nípa̠t la̠ta aklhu̠­hua̠t­námpa̠t? ");
INSERT INTO tocNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Pus huata mejor caj cachi­patá min­tumi̠n y capittá nac mín­chic. Porque aquit na̠chuná cca̠­ma̠s­ka­hui̠­putún u̠ma̠ko̠lh cris­tianos hua̠nti̠ a̠huatá tachilh chuná cumu la̠ huix cma̠s­ka­hui̠­ni̠tán. ");
INSERT INTO tocNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Lácu huix lac­pu­huana pi̠ ni̠lay cli̠t­la­huay quin­tumi̠n hua̠ntu̠ aquit tla̠n clac­pu­huán? ¿Osuchí huá qui­li̠­si̠­tzi̠­niya caj qui­lak­ca­tza­niya cumu aquit tla̠n cca̠­ca­tzi̠niy cris­tianos?” ");
INSERT INTO tocNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","’Aquit laca­tancs cca̠­hua­niyá̠n pi̠ chuná naqui̠­taxtuy nac xla­catí̠n Dios, lhu̠hua hua̠nti̠ la̠nchú tama­ca­pu̠­la­má̠­nalh huata aca­li̠stá̠n xlacán a̠huatá tamaca­sta̠­la­má̠­nalh nahuán, y lhu̠hua hua̠nti̠ la̠nchú a̠huatá taqui̠­tax­tu­má̠­nalh, a̠má quilh­ta­macú huata xlacán luu tama­ca­pu̠­la­má̠­nalh nahuán. ");
INSERT INTO tocNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Acxni̠ Jesús aya xtla̠­huama nac tiji xama nac Jeru­salén xlá tunuj cá̠le̠lh xdis­cí­pulos tzinú laka­mákat y chiné ca̠huá­nilh: ");
INSERT INTO tocNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Hui­xinín catzi̠­yá̠tit pi̠ ama̠­náhu nac Jeru­salén; pus na̠ luu caca­tzí̠tit pi̠ antá aquit naquin­chi­pacán naqui­ma­ca­ma̠s­ta̠cán nac xla­ca­ti̠ncán xana­puxcun cura xa̠huá xma̠­kalh­ta­hua­ke̠­nacán judíos y chuná chú nata­li̠­lac­chu­hui̠nán la̠ta lácu naqui­mak­ni̠cán. ");
INSERT INTO tocNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Aca­li̠stá̠n chú xlacán naquin­ta­ma­ca­ma̠s­ta̠­paray nac xla­ca­ti̠ncán a̠ma̠ko̠lh lac­chix­cu­huí̠n hua̠nti̠ uú tama̠­pek­si̠nán hua̠nti̠ tata­peksi̠y nac Roma y ni̠ judíos, huata chú xlacán la̠n naquin­ta­li̠­ka­ma̠nán, naquin­ta­hui­li̠niy y hasta naquin­ta­pe­kex­to­ko­huacay nac cruz; pero ma̠squi chuná caj xliaktutu quilh­ta­macú aquit nac­la­cas­ta­cuanam­paray nac ca̠li̠ní̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Huata na̠ acxni­tiyá chú a̠má quilh­ta­macú xpusca̠t Zebedeo ca̠ta̠­ta­la­ca­tzú­hui̠lh anta­nícu xyá Jesús a̠má cha̠tiy xla­ka­huasán hua̠nti̠ xca̠­hua­nicán San­tiago y Juan. Xlá laka­ta­tzo­kós­talh nac xla­catí̠n la̠qui̠ nas­quiniy aktum lanca li̠tlá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesús kalhás­quilh: —¿Túcu huix laca­squina xac­tlá­hualh caj hua̠ntu̠ mila­cata? Xlá chiné huá­nilh: —Cat­lahua aktum lanca li̠tlá̠n, acxni̠ huix natzu­cuya ma̠pek­si̠­nana cumu la̠ lanca rey, xtáhui cha̠tum quin­ka­huasa nac mim­pek­stácat y cha̠tum nac mim­pek­xuqui la̠qui̠ lac­xtum nata­ta̠­ma̠­pek­si̠­naná̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Huata Jesús chiné kálh­ti̠lh: —Xli̠­ca̠na pi̠ ni̠para tzinú catzi̠ya hua̠ntu̠ ca̠ta̠s­químpa̠t min­camán. ¿Lácu pi̠ tla̠n hui­xinín nata̠­ya­ni­yá̠tit nac a̠má lanca tapa̠tí̠n hua̠ntu̠ aquit cámaj pa̠ti̠y? Xlacán takalh­tí̠­nalh: —Clac­pu­hua­ná̠hu pi̠ ma̠x tla̠n nac­ta̠­ya­ni­yá̠hu. ");
INSERT INTO tocNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús ca̠kálh­ti̠lh: —Xli̠­ca̠na xlá pi̠ tla̠n nata̠­ya­ni­yá̠tit porque hui­xinín juerza antá pim­pá̠tit ti̠tax­tu­ni­yá̠tit eé tapa̠tí̠n hua̠ntu̠ aquit cámaj pa̠ti̠y; pero hua̠nchú la̠ta hui­xinín lacas­qui­ná̠tit nac­ca̠­ma̠x­qui̠yá̠n milac­ta­hui̠lhcán nac quim­pa̠xtú̠n antá nac quim­pu̠­ma̠­peksí̠n la̠qui̠ nata­hui­la­yá̠tit cha̠­tunu pa̠x­tu̠tu, pus aquit laca­tancs cca̠­hua­niyá̠n pi̠ ni̠ que̠cstu cca­tzi̠y xla­cata nac­ca̠­ma̠x­qui̠yá̠n, huata huá xlá catzi̠y Quin­tla̠t hua̠nti̠ xlá ca̠lac­sacni̠t naca̠­ma̠x­qui̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Acxni̠ chú a̠ma̠ko̠lh xa̠ka­lha­cá̠hu xta̠­dis­cí­pu­loscán takáx­matli hua̠ntu̠ xlacá̠n xtas­qui­má̠­nalh huata mejor caj tasi̠­tzí̠­nilh a̠ma̠ko̠lh cha̠tiy li̠na­ta̠lán. ");
INSERT INTO tocNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pero Jesús ca̠ta­sá­nilh y chiné ca̠huá­nilh: —Hui­xinín catzi̠­yá̠tit xla­cata pi̠ hua̠nti̠ tapuxcún nac aktum ca̠chi­quí̠n xlacán antá tama̠­pek­si̠nán ca̠ta cumu la̠m­para huá xpu̠­chi­nacán hua̠ntu̠ antá anán, y hua̠nchú ti̠ lac­lanca lac­ta­li̠­pa̠hu ma̠pek­si̠­naní̠n xlacán luu tli­hueke tahuili̠y xli̠­ma̠­pek­si̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero hua̠ntu̠ mila­ca­tacán ni̠chuná cati­qui̠­táx­tulh. Porque hua̠nti̠ luu tali̠­pa̠hu li̠tax­tu­putún mejor huata caj caca̠­li̠­ma­cuánilh xa̠maka­pi­tzí̠n y cat­lá­hualh hua̠ntu̠ xlacán nata­li̠­ma̠­peksi̠y xcompañeros. ");
INSERT INTO tocNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Y na̠chuná para tax­tu­ya̠chá cha̠tum la̠ hui­xinín hua̠nti̠ ca̠ma̠­pek­si̠­putún xa̠maka­pi­tzí̠n xcompañeros xta̠­chuná cumu lá xapuxcu, huata xlá luu mini̠niy nali̠­taxtuy cumu la̠ cha̠tum tasa̠cua hua̠nti̠ na̠ caj naka­lha­kax­mat­ni̠nán hua̠ntu̠ nali̠­ma̠­pek­si̠cán. ");
INSERT INTO tocNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Xta̠­chuná cumu la̠ aquit Xata­lac­sacni Chixcú ni̠ huá clak­mini̠t nac ca̠quilh­ta­macú la̠qui̠ caj naqui­li̠­ma­cuanicán, huata huá clak­mini̠t la̠qui̠ chuná nac­ca̠­li̠­ma­cuaniy xa̠maka­pi­tzí̠n, y na̠chuna li̠túm la̠qui̠ aquit nac­ma­ca­ma̠sta̠y qui­la­táma̠t xpa̠­la­cata pi̠ tla̠n nac­ca̠­pa̠­la­ka­xo­ko̠nún xla­ta­ma̠tcán lhu̠hua cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Acxni̠ aya xta­cha̠ni̠t nac xaca̠­chi­quí̠n Jericó y aya xta­ti̠­pun­tax­tu­má̠­nalh luu lhu̠hua cris­tianos ta­sta̠­lá­nilh Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Y antá luu nac xquilhpá̠n tiji xta­hui­lá̠­nalh cha̠tiy laka­xo̠ko. Acxni̠ u̠ma̠ko̠lh lac­chix­cu­huí̠n takáx­matli pi̠ hua̠ Jesús xti̠­tax­tuma xlacán chiné taqui­lhá­nilh: —¡Quim­pu̠­chi­nacán Jesús, huix xli̠­ta­la­ka­pasni rey David, luu cat­lahua li̠tlá̠n caqui­la̠­la­ka­lha­máhu! ");
INSERT INTO tocNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Maka­pi­tzí̠n cris­tianos tala­ca­quílh­ni̠lh la̠qui̠ cacs cata­táhui y ni̠ ma̠rí cataakax­cu­lí­nilh, pero xlacán ni̠ cuentaj tat­lá­hualh hua̠ntu̠ xca̠­hua­ni­má̠­calh huata li̠huaca palha tzú­culh taqui­lhaniy Jesús: —¡Jesús xli̠­ta­la­ka­pasni rey David, cat­lahua li̠tlá̠n caqui­la̠­la­ka­lha­máhu! ");
INSERT INTO tocNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesús tachó­kolh y ca̠ta­sá­nilh a̠ma̠ko̠lh cha̠tiy laka­xo̠kó̠n lac­chix­cu­huí̠n y chiné ca̠ka­lhás­quilh: —¿Túcu lacas­qui­ná̠tit aquit nac­tla­huay caj mim­pa̠­la­ca­tacán? ");
INSERT INTO tocNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Xlacán takalh­tí̠­nalh: —Quim­pu̠­chi­nacán, aquinín cla­cas­qui­ná̠hu pi̠ na̠ tla̠n xac­la­ca­hua̠­na­náhu. ");
INSERT INTO tocNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús luu xli̠­ca̠na ca̠la­ka­lhá­malh y caj la̠ta ca̠li̠­la­ca­chí­palh xmacán nac xla­kas­ta­pucán acxni­tiyá chú luu li̠huana̠ cá̠x­lalh xla­kas­ta­pucán y tla̠n tala­ca­huá̠­nalh. Aca­li̠stá̠n chú xlacán na̠ ta­sta̠­lá­nilh Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Acxni̠ chú aya xta­cha̠­má̠­nalh nac xaca̠­chi­quí̠n Jeru­salén, pu̠lh antá tácha̠lh nac aktum ca̠chi­quí̠n hua̠ntu̠ hua­nicán Bet­fagé, y antá chú tamak­xtek­ke̠lh nac aktum ke̠stí̠n hua̠ntu̠ hua­nicán Cerro de los Olivos. Acxni̠ chú antá xta­hui­la̠­nanchá, Jesús ca̠má­ca̠lh cha̠tiy xdis­cí­pulos ");
INSERT INTO tocNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","y chiné ca̠huá­nilh: —La̠li̠­huán capim­pítit nac a̠má actzu ca̠chi­quí̠n hua̠ntu̠ a̠tasi­yu­ya̠chá y antá nama̠­nok­lhu­yá̠tit pi̠ chi̠­ya̠­hua­cani̠t tantum xatzí burro nac xtan­quilhtí̠n chiqui, y na̠ antá chú ta̠láyaj nahuán cskata a̠má burro. Pus hui­xinín la̠li̠­huán nax­cu­tá̠tit tamá burro y nali̠­ta­ná̠tit antá la̠ u̠cuí. ");
INSERT INTO tocNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Y para tícu naca̠­hua­niyá̠n: “¿Túcu li̠la­yá̠tit xcu­tá̠tit?”, hui­xinín cahua­nítit pi̠ Mim­pu̠­chi­nacán mac­la­cas­quim­putún, pero palaj tuncán napu̠s­pit­paray. ");
INSERT INTO tocNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Huá u̠má chuná lí̠lalh la̠qui̠ chuná hua̠k li̠kan­táx­tulh hua̠ntu̠ títzokli cha̠tum pro­feta nac xlibro anta­nícu chiné huán: ");
INSERT INTO tocNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Cahua­nítit xli̠­hua̠k cris­tianos hua̠nti̠ tahui­lá̠­nalh nac xaca̠­chi­quí̠n Jeru­salén: “Caucxílhtit mireycán porque la̠nchú ca̠lak­mimá̠n, pero xli̠­ca̠na pi̠ ni̠para tzinú xlá lanca maklh­ca­tzi̠cán, y na̠ ni̠para laca­ta̠­qui̠nán, porque caj tantum actzu burro pu̠mima, xli̠­ca̠na pi̠ huá pu̠mima tantum burro cskata tantum xatzí burro hua̠ntu̠ ma̠cu­ca̠­ni̠cán.” ");
INSERT INTO tocNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ama̠­ko̠lh dis­cí­pulos táalh y chuná xlacán tat­lá­hualh hua̠ntu̠ xca̠­hua­nini̠t Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Caj li̠puntzú talí̠­milh a̠má xatzí burro xa̠huá cskata; acxni̠ chú tali̠­ke̠t­la­pá­nilh clha­ka̠tcán Jesús ke̠táhui. ");
INSERT INTO tocNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Luu lhu̠hua cris­tianos xta­mini̠t tapa̠x­toka y maka­pi­tzí̠n hasta tzú­culh tata­rami̠y clha­ka̠tcán nac tiji, y maka­pi­tzí̠n xta­ca̠­má̠­nalh xmak­xpi̠ní̠n quihui y na̠ tata­rá­mi̠lh nac tiji. ");
INSERT INTO tocNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Xli̠­hua̠k cris­tianos hua̠nti̠ xta­pu̠­la­má̠­nalh xa̠huá hua̠nti̠ xta­sta̠­la­má̠­nalh chiné tzú­culh tama̠­ca̠­tasi̠y: —¡Cama̠x­quí̠hu cá̠cni̠t eé xli̠­ta­la­ka­pasni xamaká̠n rey David! ¡Cala­ka­chix­cu­huí̠hu Dios caj xpa̠­la­cata hua̠ntu̠ xlá tla­huama! ");
INSERT INTO tocNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Acxni̠ Jesús tanu̠chá nac Jeru­salén lhu̠hua cris­tianos tzú­culh talak­lhpe̠­cuán y tzú­culh tala̠­ka­lhas­quín: —¿Tícu u̠má chixcú hua̠nti̠ chilh la̠nchú? ");
INSERT INTO tocNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Maka­pi­tzí̠n cris­tianos chiné xta­kalh­tí̠nán: —Huá eé pro­feta Jesús hua̠nti̠ xalac Naza­ret cxmu­ni­cipio Gali­lea. ");
INSERT INTO tocNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Aca­li̠stá̠n chú Jesús tanu̠chá nac lanca xpu̠­si­culan Dios y acxni̠ xlá úcxilhli pi̠ xtza­macán tzú­culh ca̠pu̠t­la­kaxtuy hua̠nti̠ antá xta­sta̠­na­má̠­nalh chu hua̠nti̠ xta­ta­ma̠­hua­na­má̠­nalh nac pu̠si­culan. Ca̠ma̠k­pu̠s­pít­nilh xme­sajcán hua̠nti̠ xta­lak­pa­li̠­má̠­nalh xtu­mi̠ncán cris­tianos, y na̠chuná ca̠t­la­huá­nilh csil­lajcán hua̠nti̠ xta­sta̠­má̠­nalh pa­lomas. ");
INSERT INTO tocNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Acxni̠ chuná ca̠t­la­hua­ko̠lh chiné ca̠huá­nilh: —Nac xta­chu­huí̠n Dios hua̠ntu̠ tatzok­ta­hui­lani̠t nac li̠kalh­ta­huaka chiné huán lacatum: “Umá quín­chic luu caj huá nali̠­ma̠x­tucán pi̠ antá naquinkalhtahuakanicán”; pero huata hui­xinín aya li̠ma̠x­tu­ni̠­tátit cumu la̠ xpu̠­ta­tzek­nicán kalha̠­naní̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Antá chú nac pu̠si­culan tuncán tzú­culh talak­ta­la­ca­tzu­hui̠y antaní xyá Jesús maka­pi­tzí̠n lac­chix­cu­huí̠n hua̠nti̠ xta­la­ka­xo̠kó̠n, chu hua̠nti̠ xta­lac­lu̠n­tu̠­hua­nani̠t la̠qui̠ Jesús naca̠­ma̠t­la̠nti̠y, y xli̠­ca̠na pi̠ hua̠k ca̠ma̠t­lá̠n­ti̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Huá chú eé xta­scújut hua̠ntu̠ tlá­hualh Jesús acxni̠ taúcxilhli xana­puxcún cura xa̠huá xma̠­kalh­ta­hua­ke̠­nacán judíos, y na̠chuná chú xta­kax­mata la̠ta lácu lactzu camán xta­ma̠­ca̠­ta­si̠­má̠­nalh nac pu̠si­culan y chiné xta­huán: “¡Cama̠x­quí̠hu cá̠cni̠t eé xli̠­ta­la­ka­pasni xamaká̠n rey David hua̠nti̠ mini̠t la̠nchú!”, a̠ma̠ko̠lh lac­chix­cu­huí̠n ni̠para tzinú tama̠t­lá̠n­ti̠lh y luu li̠pe̠cua la̠ta tasí̠­tzi̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Pus huá xpa̠­la­cata tali̠­lák­milh Jesús y chiné tahuá­nilh: —¡Kahua! ¿Lácu pi̠ ni̠ kax­pátpa̠t hua̠ntu̠ u̠ma̠ko̠lh lactzu camán taqui­lhuamá̠­nalh? Jesús ca̠kálh­ti̠lh: —¡Pero lácu chú ni̠ nac­kax­mata, pus ckax­matma! Pero lácu pi̠ nia̠ li̠kalh­ta­hua­ka­yá̠tit hui­xinín hua̠ntu̠ tatzok­ta­hui­lani̠t xta­chu­huí̠n Dios nac li̠kalh­ta­huaka anta­nícu chiné huán: Huix chuná ca̠ma̠x­qui̠­ni̠ta tala­ca­pa̠s­tacni hua̠nti̠ cajcu lactzu camán xa̠huá hua̠nti̠ tatzi­qui̠ycú, la̠qui̠ xlacán tla̠n nata­li̠­quilh­tli̠­niyá̠n kam­pa̠tum li̠la­káti̠t taquilh­tlí̠n hua̠ntu̠ nata­li̠­la­ka­chix­cu­hui̠yá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Acxni̠ chuná ca̠hua­ni­ko̠lh xlá ca̠ak­xtek­yá̠­hualh y antá alh nac aktum ca̠chi­quí̠n hua̠ntu̠ hua­nicán Betania, antá chú lak­tun­cu­huichá a̠má tzi̠sní. ");
INSERT INTO tocNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Li̠cha̠lí luu laca­tzi̠sa acxni̠ Jesús xama̠pá nac Jeru­salén xlá tzú­culh tzincsa. ");
INSERT INTO tocNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Juerza laka­mákat tzinú la̠ta nac tiji úcxilhli pi̠ xya̠chá akatum xaquihui higo xlá la̠li̠­huán lak­ta­la­ca­tzú­hui̠lh pero ni̠tu̠cu mac­lá­nilh xta­huácat a̠má quihui huata caj xma̠nhuá xapalhma ke̠tum xta̠ya. Jesús chiné huá­nilh: —¡Aquit cla­cas­quín pi̠ niajpara maktum cati­ta­huá­calh min­ta­huácat! Acxni̠ chuná hua­ni­ko̠lh a̠má quihui tuncán sca̠cli. ");
INSERT INTO tocNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Acxni̠ xdis­cí­pulos taúcxilhli hua̠ntu̠ xlá tlá­hualh luu xli̠­ca̠na cacs tali̠­la­cáhua y chiné taka­lhás­quilh Jesús: —Ma̠kalh­ta­hua­ke̠ná, ¿lácu la̠ a̠má tlahua xla­cata pi̠ tuncán sca̠cli a̠má xaquihui higo hua̠ntu̠ laca­quilhni? ");
INSERT INTO tocNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús ca̠huá­nilh: —Aquit xli̠­ca̠na laca­tancs cca̠­hua­niyá̠n pi̠ para hui­xinín xli̠­ca̠na luu xli̠­pa̠­huántit Dios y ni̠ aka­tiyuj xlátit para xlac­pu­huántit pi̠ túcu ni̠lay tla­huay Dios nac mila­ta­ma̠tcán, pus ni̠ caj xma̠nhuá xtla­huátit hua̠ntu̠ la̠nchú ctla­hua­nini̠t eé xaquihui higo huata hasta na̠ tla̠n xuanítit a̠má ke̠stí̠n: “Cata­ke̠nu antá la̠ huila y antá capit taju̠ya nac pupunú”, luu xli̠­ca̠na pi̠ chuná xqui̠­táx­tulh. ");
INSERT INTO tocNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Y la̠tachá túcu hui­xinín nas­qui­ni­yá̠tit Dios acxni̠ nat­la­hua­yá̠tit ora­ción, luu laca­tancs cca̠­hua­niyá̠n pi̠ hua̠k namak­lhti̠­na­ná̠tit cumu para luu xli̠­ca̠na li̠pa̠­hua­ná̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesús tanu̠­pa­rachá nac lanca xpu̠­si­culan Dios nac Jeru­salén y acxni̠ xlá xca̠­ma̠­kalh­chu­hui̠­ni̠ma cris­tianos talak­ta­la­ca­tzú­hui̠lh maka­pi­tzí̠n xana­puxcún cura xa̠huá lak­ko̠­lu­tzi̠nni judíos hua̠nti̠ xta­ma̠­pek­si̠nán; y chiné taka­lhás­quilh: —Xli̠­hua̠k hua̠ntu̠ huix tlahua uú nac pu̠si­culan acxni̠ ca̠pu̠t­la­kax­tu­ko̠ya sta̠­naní̠n, ¿tícu ma̠x­qui̠­ni̠tán li̠ma̠­peksí̠n chuná nat­la­huaya? ");
INSERT INTO tocNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús chiné ca̠kálh­ti̠lh: —Aquit na̠ cka­lhi̠y aktum tachu­huí̠n hua̠ntu̠ cca̠­ka­lhas­quim­pu­tuná̠n, pus para hui­xinín tancs naqui­la̠­kalh­ti̠­yá̠hu hua̠ntu̠ nac­ca̠­ka­lhas­quiná̠n pus na̠chuná chú aquit nac­ca̠­hua­niyá̠n tícu qui­ma̠x­qui̠ni̠t li̠ma̠­peksí̠n caj xpa̠­la­cata hua̠ntu̠ ctla­huay. ");
INSERT INTO tocNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Pus caqui­la̠­hua­níhu, ¿tícu li̠ma̠­pék­si̠lh Juan Bau­tista xla­cata naca̠akmunuy cris­tianos? ¿Pi̠ huá Dios, osuchí huá lac­chix­cu­huí̠n? Xlacán ni̠naj tuncán takalh­tí̠­nalh, huata caj sac­stucán tzú­culh tala̠­huaniy: —Para nahua­ni­yá̠hu pi̠ huá Dios tili̠­ma̠­pék­si̠lh, pus huata xlá naquin­ca̠­hua­niyá̠n: “¿Túcu xpa̠­la­cata chi̠nchú ni̠ li̠ca̠­naj­la­nítit?” ");
INSERT INTO tocNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Y para nahua­ni­yá̠hu pi̠ huá lac­chix­cu­huí̠n tita­li̠­ma̠­pék­si̠lh, na̠ni̠­para chuná ni̠lay, porque luu xli̠­ca̠na la̠n nata­si̠­tzi̠y xli̠­lhu̠hua cris­tianos caj huá tuncán caca̠­li̠­pe̠­cuaníhu, porque xli̠­hua̠k catzi̠cán y ca̠naj­lacán pi̠ Juan huá xli̠­chu­hui̠­nama xta­chu­huí̠n Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Huata chiné tahuá­nilh Jesús: —Aquinín ni̠ cca­tzi̠­yá̠hu tícu li̠ma̠­pék­si̠lh xla­cata naakmu­nu̠nún. Jesús na̠ chiné ca̠huá­nilh: —Pus na̠ni­para aquit cac­ti­ca̠­huanín tícu qui­ma̠x­qui̠ni̠t li̠ma̠­peksí̠n caj xpa̠­la­cata hua̠ntu̠ cca̠t­la­huay. ");
INSERT INTO tocNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús chiné ca̠hua­nipá: —Na̠ cakax­pat­pa­rátit hui­xinín eé aktum­li̠túm takalh­chu­huí̠n: Maktum quilh­ta­macú xuí cha̠tum chixcú xlá xta­hui­lá̠­nalh cha̠tiy xla­ka­huasán. Y maktum quilh­ta­macú chiné huá­nilh cha̠tum: “Ta̠ta, la̠li̠­huán capimpi scuja nac quin­ca̠­tu­hua̠ncán anta­nícu la̠n lac­cha̠­ta­hua­cama uvas.” ");
INSERT INTO tocNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Amá kahuasa kalh­tí̠­nalh: “¡Oh que, ni̠ cam­putún!” Pero aca­li̠stá̠n laca­pá̠s­tacli pi̠ ni̠tlá̠n la̠ kálh­ti̠lh xtla̠t y alh scuja nac ca̠tu­huá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Aca­li̠stá̠n chú a̠má ko̠lu­tzí̠n hua­nipá cha̠­tum­li̠túm xka­huasa xla­cata pi̠ na̠ caalh scuja. Amá kahuasa kalh­tí̠­nalh: “¡Oh, ni̠tu̠ capú­huanti papá, aquit xlá nacán scuja!” Pero ma̠squi chuná huá, huata xlá ni̠ alh. ");
INSERT INTO tocNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Aca­li̠stá̠n chú Jesús ca̠ka­lhás­quilh a̠ma̠ko̠lh cris­tianos: —¿Xatícu hui­xinín lac­pu­hua­ná̠tit la̠ta xli̠­cha̠­tiycán a̠ma̠ko̠lh laka­huasán tlá­hualh hua̠ntu̠ xla­cas­quín nali̠s­cujcán a̠má ko̠lu­tzí̠n? Cris­tianos takalh­tí̠­nalh: —Hua̠nti̠ pu̠lh hua­ní­calh caalh scuja. Jesús chiné ca̠huá­nilh: —Luu xli̠­ca̠na pi̠ chuná chú qui̠­tax­tuma nac mila­ta­ma̠tcán, porque aquit laca­tancs cca̠­hua­niyá̠n pi̠ huata huá hua̠nti̠ hui­xinín ni̠tu̠ ca̠liucxi­lhá̠tit cumu la̠ a̠ma̠ko̠lh xma̠­la­ka­xo­ke̠­naní̠n im­pues­tos xa̠huá tama̠­ko̠lh hua̠nti̠ caj xala­ka­hui­tiní̠n lac­pus­ca̠tní̠n, laca­tancs pi̠ pu̠lh huá nata­ta­nu­ya̠chá nac xta­péksi̠t Dios y ni̠xa­chuná hui­xinín. ");
INSERT INTO tocNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Porque qui̠­lachi Juan Bau­tista nac ca̠quilh­ta­macú la̠qui̠ naca̠­hua­niyá̠n la̠ta lácu hui­xinín nala­ta­pa̠­yá̠tit uú nac ca̠quilh­ta­macú, pero ma̠squi chuná hui­xinín ni̠ ca̠naj­la­nítit xta­chu­huí̠n. Pero hua̠nchú ti̠ takáx­matli xta­chu­huí̠n y talak­pá­li̠lh xali̠xcáj­nit xla­ta­ma̠tcán pus huá tama̠­ko̠lh xma̠­la­ka­xo­ke̠­naní̠n im­pues­tos xa̠huá hua̠nti̠ aya xta­lak­tzan­ka̠­ta̠­yani̠t lac­chaján. Ma̠squi hui­xinín na̠ ucxílhtit la̠ta lácu xlacán xta­li̠­pu­hua­má̠­nalh xpa̠­la­cata xta­la̠­ka­lhi̠ncán y xta­lak­pa­li̠­má̠­nalh xla­ta­ma̠tcán hui­xinín ni̠para tzinú lak­pa­lí̠tit xali̠xcáj­nit min­ta­la­ca­pa̠s­tac­nicán xla­cata na̠ naca̠­naj­la­ni­yá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Na̠ cakax­pat­pa­rátit eé aktum­li̠túm takalh­chu­huí̠n: Maktum quilh­ta­macú cha̠tum chixcú xpu̠­chiná aktum lanca pú̠cuxtu chalh nac xca̠­tu­huá̠n lhu̠hua xali̠­chánat uvas. Luu li̠huana̠ sti­lim­pá­calh, antá lacatzú tlá­hualh aktum xpu̠­chitni hua̠ntu̠ napu̠­lak­chita xuvas acxni̠ nacha̠y, y aca­li̠stá̠n tlá­hualh aktum lanca torre la̠qui̠ antá tla̠n namak­ta­kalhko̠y xli̠­lanca xta­chaná̠n. Acxni̠ chú luu li̠huana̠ li̠s­cuj­ko̠lh xlá ca̠ma̠­cuentáj­li̠lh maka­pi­tzí̠n tasa̠­cuá̠n a̠má lanca xta­chaná̠n, porque xlá alh mákat nac a̠laca­tunu ca̠chi­quí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Acxni̠ chú lák­cha̠lh quilh­ta­macú la̠ta tzú­culh cha̠y xuvas, a̠má xpu̠­chiná pú̠cuxtu ca̠má­ca̠lh maka­pi­tzí̠n li̠tum xta­sa̠­cuá̠n la̠qui̠ nataán tatiyay a̠má xata­chitni uvas hua̠ntu̠ xlak­chá̠n porque chuná xca̠­ta̠­la­ca̠x­lani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero a̠ma̠ko̠lh tasa̠­cuá̠n hua̠nti̠ xta­pu̠s­cuj­má̠­nalh a̠má pú̠cuxtu tachí­palh cha̠tum y la̠n tahui­lí̠­nilh, cha̠tum mak­ní̠­calh y cha̠tum la̠n taliactá­lalh chí­huix. ");
INSERT INTO tocNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Hua̠nti̠ xpu̠­chiná a̠má tachaná̠n xlá ca̠ma­ca̠mpá tlak lhu̠hua xta­sa̠­cuá̠n pero a̠ma̠ko̠lh hua̠nti̠ ni̠ lacuán tasa̠­cuá̠n na̠chuná tat­la­huachá cumu la̠ xca̠t­la­hua­cani̠t maka­pi­tzí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Huata mejor chú ma̠n máca̠lh xka­huasa, porque xlá chiné xlac­pu­huán: “Cumu para huá quin­ka­huasa nac­macá̠n ma̠x juerza nata­la­ca­pu­huaniy y nata­ka­lha­kax­mata hua̠ntu̠ naca̠­huaniy.” ");
INSERT INTO tocNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero acxni̠ a̠ma̠ko̠lh tasa̠­cuá̠n taúcxilhli pi̠ huá xka­huasa xpu̠­chiná a̠má pú̠cuxtu, xlacán chiné tzú­culh tala̠­huaniy: “Cha̠­ca­tzi̠ya pi̠ huá eé kahuasa hua̠nti̠ namaka­maklhti̠nán pu̠tum u̠má hua̠ntu̠ aquinín li̠s­cuj­ma̠­náhu, huata mejor camak­ní̠hu la̠qui̠ aquinín naquin­ca̠­ta­mak­xtek­ni­ko̠yá̠n u̠má pú̠cuxtu.” ");
INSERT INTO tocNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","La̠li̠­huán huakaj tachí­palh, mákat nac xqui­lhapá̠n pú̠cuxtu tata­mác­xtulh y antá tamák­ni̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’Chi̠nchú acxni̠ namín xpu̠­chiná pú̠cuxtu, ¿túcu hui­xinín lac­pu­hua­ná̠tit naca̠t­la­huaniy a̠ma̠ko̠lh tasa̠­cuá̠n hua̠nti̠ ni̠tlá̠n xta­pu­hua̠ncán? ");
INSERT INTO tocNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","La̠ta xli̠­lhu̠hua cris­tianos takálh­ti̠lh: —Pus aquinín clac­pu­hua­ná̠hu pi̠ ni̠ cati­ca̠­ta̠­la­ka­pú­tzalh y naca̠­mak­ni̠ko̠y a̠ma̠ko̠lh tasa̠­cuá̠n hua̠nti̠ ni̠tlá̠n xta­pu­hua̠ncán, y tunu hua̠nti̠ naca̠­ma̠­cuentajli̠y xpu̠­cuxtu hua̠nti̠ tla̠n xta­pu­hua̠ncán tasa̠­cuá̠n hua̠nti̠ nata­ma­ca­ma̠sta̠y xata­chitni uvas acxni̠ natzucuy cha̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Y Jesús chiné ca̠huá­nilh: —Hui­xinín ma̠x aya li̠kalh­ta­hua­ka­ni̠­tátit xta­chu­huí̠n Dios hua̠ntu̠ tatzok­ta­hui­lani̠t nac li̠kalh­ta­huaka lacatum chiné huán: Amá lanca chí­huix hua̠ntu̠ tita­lak­má­kalh tzap­snaní̠n porque tita­lac­púhua pi̠ ni̠tu̠ li̠ma­cuán, huata la̠nchú huá luu li̠ma­cuama porque huá ani̠t li̠jaxko̠y la̠ta xli̠­lanca chiqui. Pero huá Quim­pu̠­chi­nacán hua̠nti̠ lac­lhca̠ni̠t xla­cata chuná naqui̠­taxtuy, la̠qui̠ aquinín caj cacs nali̠­la­ca­hua­ná̠hu la̠ta túcu tla­huani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Pus huá xpa̠­la­cata cca̠­li̠­hua­niyá̠n pi̠ a̠má mim­pu̠­ta­hui̠lhcán hua̠ntu̠ Dios xca̠­ca̠x­tla­hua­ni­ni̠tán y xca̠­li̠­ka­lhi̠má̠n, naca̠­mak­lhti̠­ca­ná̠tit la̠qui̠ huá chú naca̠­ma̠x­qui̠cán a̠ma̠ko̠lh cris­tianos hua̠nti̠ ni̠chuná tali̠­ca­tzi̠y cumu la̠ a̠ma̠ko̠lh tasa̠­cuá̠n hua̠nti̠ ni̠tlá̠n xta­pu­hua̠ncán y xa̠huachí la̠qui̠ xlacán nata­ma­ca­ma̠sta̠y nac xla­catí̠n Dios hua̠ntu̠ tali̠s­cujni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","¡Ah! Y hua̠nchú xpa̠­la­cata a̠má chí­huix, pus cca̠­hua­ni­pu­tuná̠n pi̠ para cha̠tum chixcú naliakchek­xnín, pus luu maktum pi̠ nalac­tuc­xta­huilay, y chi̠nchú para huata huá chí­huix xatícu naacta­ma̠­ya̠chi luu xli̠­ca̠na pi̠ ámaj lak­chi­tami̠y y cumu la̠ pokxni nat­la­huako̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Acxni̠ takax­mat­ko̠lh eé takalh­chu­huí̠n hua̠ntu̠ Jesús xli̠­chu­hui̠­nama, a̠ma̠ko̠lh xana­puxcun cura xa̠huá fariseos tacá­tzi̠lh pi̠ caj xpa̠­la­ca­tacán ma̠squi chuná xlá xli̠­chu­hui̠­nani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Xlacán xta­chi̠­le̠m­putún Jesús pero ni̠ juerza tat­la­huá­nilh porque xta­pe̠­cuaniy la̠ta xli̠­lhu̠hua cris­tianos cumu luu lhu̠hua hua̠nti̠ xta­ca̠­najlay pi̠ xli̠­ca̠na Jesús huá xli̠­chu­hui̠­nama xta­chu­huí̠n Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús tzu­cupaj ca̠li̠­ta̠­kalh­chu­hui̠nán túnuj takalh­chu­huí̠n y chiné ca̠huá­nilh: ");
INSERT INTO tocNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Amá xta­péksi̠t Dios hua̠ntu̠ ma̠la­ca­tzu­qui̠ma uú nac ca̠quilh­ta­macú luu xta̠­chuná qui̠­taxtuy cumu la̠ cha̠tum rey hua̠nti̠ tlá­hualh aktum pu̠pa̠xcua porque xma̠­maka­xtokma xka­huasa. ");
INSERT INTO tocNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Xlá ca̠má­ca̠lh maka­pi­tzí̠n xta­sa̠­cuá̠n xla­cata nataán tahuaniy hua̠nti̠ xca̠­pu­tza­cani̠t xla­cata pi̠ cata­milhá nac pu̠pa̠xcua porque aya xámaj tamaka­xtoka xka­huasa. Pero huata a̠ma̠ko̠lh lac­chix­cu­huí̠n hua̠nti̠ xca̠­pu­tza­cani̠t nata­mak­pa̠x­cuajnán ni̠ tamim­pú­tulh. ");
INSERT INTO tocNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Pero cumu a̠má rey luu xca̠­li̠­pa̠­huán xlá ca̠ma­ca̠mpá tunuj­li̠túm xlac­scujni xla­cata chiné naca̠­hua­nicán: “Caca̠­hua­nítit tama̠­ko̠lh quin­ta­putza xla­cata pi̠ catat­lá­hualh li̠tlá̠n la̠li̠­huán caquin­ta­lák­milh porque aya accha̠ná la̠ta huí tahuá uú nac pu̠ta­maka­xtokni. Aquit aya cca̠­mak­ni̠ni̠t qui­huá̠cax chu xalakkón quin­ta­ka­lhí̠n, y xa̠huachí aya li̠huana̠ ca̠x­tla­hua­cani̠t xala­cuán tahuá.” ");
INSERT INTO tocNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero ma̠squi chuná ca̠hua­ní­calh a̠ma̠ko̠lh lac­chix­cu­huí̠n hua̠nti̠ xca̠­pu­tza­cani̠t ni̠ taka­lha­chix­cú­hui̠lh y ni̠ táalh nac pu̠pa̠xcua. Cha̠tum alh nac xca̠­tu­huá̠n y cha̠­tum­li̠túm alh nac xpu̠stá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Y maka­pi­tzí̠n caj tali̠­sí̠­tzi̠lh la̠ta xca̠­la­ka­lat­la̠­huancán, huata huakaj tachi­pachá xlac­scujni rey, la̠n tahui­lí̠­nilh, maka­pi­tzí̠n hasta ca̠mak­ní̠­calh. ");
INSERT INTO tocNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Acxni̠ chú a̠má rey cátzi̠lh hua̠ntu̠ xca̠t­la­hua­ni­cani̠t xta­sa̠­cuá̠n xlá luu li̠pe̠cua la̠ta sí̠tzi̠lh y ca̠li̠­ma̠­pék­si̠lh maka­pi­tzí̠n tropa xla­cata pi̠ caca̠­mak­ní̠­calh a̠ma̠ko̠lh lac­li̠xcáj­nit lac­chix­cu­huí̠n y na̠ caca̠lh­cu­yu­ní­calh xca̠­chi­qui̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Aca­li̠stá̠n chú ca̠huá­nilh xa̠maka­pi­tzí̠n xta­sa̠­cuá̠n: “Chú luu xaaccha̠ná hui­la̠­náhu xla­cata nata­maka­xtoka quin­ka­huasa y napa̠­xcuajna­ná̠hu, porque aya li̠huana̠ ca̠ca̠x­ya̠­hua­cani̠t mesa y ca̠x­tla­hua­cani̠t tahuá; pero huata a̠ma̠ko̠lh hua̠nti̠ aquit xac­la­cas­quín naquin­ta­lakmín hua̠nti̠ xac­ca̠­pu­tzani̠t xlacán chú niaj ca̠mi­ni̠niy natamín porque caj xpa̠­la­cata xali̠xcáj­nit xta­pu­hua̠ncán tali̠­lak­tzan­ka̠­ta̠­yani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Pus huata mejor capim­pítit hui­xinín nac ca̠ti­ji̠ní̠n xa̠huá nac xli̠­lanca ca̠chi­quí̠n, y caca̠­hua­nítit xli̠­hua̠k hua̠nti̠ nata̠­ta­nok­lhá̠tit xla­cata pi̠ catá­milh nac xpu̠­ta­maka­xtokni quin­ka­huasa la̠qui̠ nata­ma­kua̠yán.” ");
INSERT INTO tocNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ama̠­ko̠lh tasa̠­cuá̠n táalh nac ca̠ti­ji̠ní̠n y pu̠tum tama̠­ké̠s­tokli xli̠­hua̠k hua̠nti̠ xlacán tama̠­nók­lhulh y pa̠tum tanú̠­calh nac a̠má chiqui anta­nícu xpa̠x­cuajna­má̠­calh, la̠tachá tícuya̠ cris­tianos xta­mini̠t hua̠nti̠ tla̠n xta­ca­tzi̠ni̠t chu hasta hua̠nti̠ xta­lak­tzan­ka̠­ta̠­yani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Acxni̠ a̠má rey alh ca̠ucxilha hua̠nti̠ xta­mini̠t nac pu̠pa̠xcua, pero xlá ni̠para tzinú ma̠t­lá̠n­ti̠lh acxni̠ úcxilhli cha̠tum chixcú pi̠ ni̠tu̠ clha­ka̠ni̠t a̠má la̠n lháka̠t hua̠ntu̠ ca̠ma̠x­quí̠­calh acxni̠ tatá­nu̠lh nac pu̠ta­maka­xtokni. ");
INSERT INTO tocNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Xakát­li̠lh a̠má chixcú y chiné huá­nilh: “Amigo, ¿túcu xpa̠­la­cata ni̠ li̠lhaka huix a̠má la̠n lháka̠t hua̠ntu̠ ca̠ma̠x­qui̠­cántit acxni̠ tanu̠­chi­tátit uú nac pu̠ta­maka­xtokni?” Pero huata a̠má chixcú ni̠ cátzi̠lh lácu nakalh­ti̠nán y cacs lacáhua. ");
INSERT INTO tocNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Entonces a̠má rey ca̠huá­nilh hua̠nti̠ xta­maca­scuj­má̠­nalh: “La̠li̠­huán huakaj cachi­pátit, cama­ca­chí̠tit, na̠ li̠huana̠ calac­chí̠tit y cata­mac­xtútit nac quilhtí̠n anta­nícu luu ca̠pucsua la̠qui̠ antá natasay y nalac­sa̠nán xta­tzán caj xpa̠­la­cata pi̠ la̠n napa̠­ti̠nán.” ");
INSERT INTO tocNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Y Jesús chiné ca̠huá­nilh a̠ma̠ko̠lh cris­tianos: —Xli̠­ca̠na pi̠ luu lhu̠hua hua̠nti̠ ca̠ta­sa­ni­cani̠t xla­cata nata­tanu̠y nac xta­péksi̠t Dios, pero ni̠ luu lhu̠hua hua̠nti̠ luu ca̠lac­sac­cani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Aca­li̠stá̠n a̠ma̠ko̠lh fariseos luu lac­xtum tali̠­lac­chu­huí̠­nalh xla­cata nata­ka­lhas­quín Jesús aktum tachu­huí̠n la̠qui̠ chicá para túcu ni̠ tancs nakalh­ti̠nán chuná chú huij nahuán hua̠ntu̠ nata­li̠­ma̠­la­capu̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Pus huata xlacán tama̠­la­ká­cha̠lh maka­pi­tzí̠n xcom­pa­ñe­roscán chu maka­pi­tzí̠n hua̠nti̠ xta­ta̠­ta̠yay rey Herodes. Acxni̠ xlacán talák­cha̠lh chiné taka­lhás­quilh: —Ma̠kalh­ta­hua­ke̠ná, aquinín cca­tzi̠­yá̠hu pi̠ huix xli̠­ca̠na li̠chu­hui̠­nana hua̠ntu̠ talu­lóktat y ma̠si­yuya la̠ta lácu Dios lacas­quín nata­la­tama̠y xcamán uú nac ca̠quilh­ta­macú, xa̠huachí huix ni̠tícu li̠quilh­pu­huana y hua­niya hua̠ntu̠ ni̠tlá̠n tla­huama y ni̠ huá li̠la­ca­pina ma̠squi calak­sí̠­tzi̠lh, porque huix ni̠ cuentaj ca̠t­la­hua­niya la̠ta túcu tali̠­ma̠x­tuyá̠n cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Pus cla­cas­qui­ná̠hu pi̠ la̠nchú xqui­la̠­hua­níhu: ¿Pi̠ lak­chá̠n la̠ta cla­ka­xo­ko̠­nu­ni­ma̠­náhu a̠má xapuxcu gobier­no xalac Roma, osuchí ni̠ lak­chá̠n? ");
INSERT INTO tocNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero cumu Jesús cátzi̠lh pi̠ caj chu­natá xta­li̠­ka­lhas­qui­má̠­nalh la̠qui̠ para chuná tla̠n nata­ma̠­mo­ko­si̠­ya̠­huay, huata xlá chiné ca̠huá­nilh: —Akska­hui­naní̠n lac­chix­cu­huí̠n hui­xinín, ¿túcu xpa̠­la­cata hua­tiyá chuná qui­la̠­lac­pu­tza̠­na­ni­ma̠­náhu hua̠ntu̠ tla̠n naqui­la̠­li̠­ma̠­mo­o­si̠­ya̠­hua­yá̠hu? ");
INSERT INTO tocNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Aver, caqui­la̠­ma̠­si­yu­níhu okxtum tumi̠n hua̠ntu̠ li̠la­ka­xo­ko̠­nu­ná̠tit acxni̠ ca̠ma̠­ta̠­ji̠­ca­ná̠tit xla­cata im­pues­tos. Acxni̠ chú tamá̠x­qui̠lh okxtum tumi̠n hua̠ntu̠ xuanicán denario, ");
INSERT INTO tocNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesús chiné ca̠ka­lhás­quilh: —¿Tícu u̠má xla­capú̠n chu xta­cu­huiní hua̠ntu̠ talh­ca̠­ta­hui­lani̠t nac eé tumi̠n? ");
INSERT INTO tocNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Huá tamá xla­capú̠n lanca ma̠pek­si̠ná gobier­no —takalh­tí̠­nalh xlacán. Jesús ca̠huá­nilh: —Pus huata huá cama­ca­ma̠x­quí̠tit gobier­no hua̠ntu̠ ma̠peksi̠y lak­chá̠n gobier­no; y na̠chuna li̠túm huá cama­ca­ma̠x­quí̠tit Dios hua̠ntu̠ lak­chá̠n nama­ca­ma̠x­qui̠­yá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Acxni̠ xlacán takáx­matli hua̠ntu̠ ca̠hua­ní­calh cacs tala­cáhua y niaj tacá­tzi̠lh lácu nata­huaniy Jesús, huata mejor caj taak­xtek­yá̠­hualh y taalhá. ");
INSERT INTO tocNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Hua­tiyá a̠má quilh­ta­macú maka­pi­tzí̠n lac­chix­cu­huí̠n hua̠nti̠ xca̠­hua­nicán sadu­ceos talá­kalh anta­nícu xuilachá Jesús la̠qui̠ nata­ta̠­chu­hui̠nán. Porque u̠ma̠ko̠lh lac­chix­cu­huí̠n xlacán xta­huán pi̠ ni̠ xli̠­ca̠na tala­cas­ta­cuanán ni̠n nac ca̠li̠ní̠n, pus hua̠ xpa̠­la­cata chiné tali̠­huá­nilh: ");
INSERT INTO tocNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Ma̠kalh­ta­hua­ke̠ná, Moisés quin­ca̠­mak­xtek­ni­ni̠tán aktum li̠ma̠­peksí̠n anta­nícu huan xla­cata pi̠ para tícu nani̠y y para huí xpusca̠t hua̠nti̠ tita̠­ta­ma­káx­tokli, y para ni̠tícu ta̠ká­lhi̠lh xca­mancán pus para huí chú xta̠lá kahuasa a̠má chixcú, xlá tla̠n nata̠­ta­huilay xya̠stá la̠qui̠ chuná huij nahuán xcamán a̠má chixcú hua̠nti̠ aya ni̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Pus maktum quilh­ta­macú uú nac qui­lak­sti̠­pa̠ncán xta­hui­lá̠­nalh kalha­tujún li̠na­ta̠lán. Hua̠nti̠ xapuxcu tama­káx­tokli pero ni̠ li̠maka̠s quilh­ta­macú ni̠lh y akxtek­má­kalh xpusca̠t, y cumu acxni̠ xla̠­tá̠hui ni̠tu̠ ta̠ká­lhi̠lh xca­mancán pus hua̠nti̠ xli̠­cha̠tiy xta̠lá ta̠ta­ma­káx­tokli a̠má pusca̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pero a̠má xatajú kahuasa hua̠nti̠ na̠ ta̠táhui a̠má pusca̠t xlá na̠ ni̠lh, y na̠chuná akspú­lalh xli̠­ka­lha­tutu y pu̠tum tali̠­ta­ká­tzi̠lh xli̠­ka­lha­tu­juncán hua̠k li̠na­ta̠lán y hua̠k táni̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Y ni̠ ni̠maka̠s chú a̠má pusca̠t na̠ ni̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Pus chú caqui­la̠­hua­níhu, chi̠nchú acxni̠ nata­la­cas­ta­cuanán ni̠n nac ca̠li̠ní̠n, ¿xatícu luu nata̠­ta­peksi̠y a̠má pusca̠t porque xka­lha­tu­tucán hua̠k tati­ta̠­táhui? ");
INSERT INTO tocNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús ca̠kálh­ti̠lh: —Xli̠­ca̠na pi̠ luu mákat aktzan­ka̠­yá̠tit, porque ni̠ catzi̠­yá̠tit y ni̠ aka­ta̠k­sá̠tit hua̠ntu̠ hua­ni­putún xta­chu­huí̠n Dios hua̠ntu̠ tatzok­ta­hui­lani̠t nac li̠kalh­ta­huaka, y na̠ni̠­para catzi̠­yá̠tit la̠ta lácu kalhi̠y xli̠t­li­hueke Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Acxni̠ nata­la­cas­ta­cuanán ni̠n nac ca̠li̠ní̠n, a̠ma̠ko̠lh lac­chix­cu­huí̠n xa̠huá lac­pus­ca̠tní̠n niaj cati­ta­ta­ma­káx­tokli porque xta̠­chuná nata­li̠­taxtuy cumu la̠ ángeles hua̠nti̠ tahui­lá̠­nalh nac akapú̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Xa̠huachí hui­xinín luu mákat aktzan­ka̠­yá̠tit para lac­pu­hua­ná̠tit pi̠ ni̠ cati­ta­la­cas­ta­cuánalh ni̠n nac ca̠li̠ní̠n, porque ni̠ aka­ta̠k­sá̠tit hua̠ntu̠ hua­ni­putún xta­chu­huí̠n Dios hua̠ntu̠ tatzok­ta­hui­lani̠t nac li̠kalh­ta­huaka anta­nícu chiné huán: ");
INSERT INTO tocNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Aquit a̠má xDios Abraham, xDios Isaac, xa̠huá xDios Jacob.” Antá huam­putún pi̠ hua̠nti̠ tala­má̠­nalh xas­tacná nac ca̠quilh­ta­macú chu hua̠nti̠ aya tani̠ni̠t lac­xtum lá̠m­para xas­tac­nacú tala­má̠­nalh, porque Dios ni̠ huá xDioscán ni̠n sinoque hua̠nti̠ tala­má̠­nalh xas­tacná. ");
INSERT INTO tocNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Acxni̠ xlacán takáx­matli hua̠ntu̠ Jesús ca̠huá­nilh, luu xli̠­ca̠na tacá̠c­ni̠lh la̠ta xka­lhi̠y xli̠s­ka­lala. ");
INSERT INTO tocNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Acxni̠ a̠ma̠ko̠lh fariseos tacá­tzi̠lh pi̠ cacs ca̠ma­ka­qui­lhuáncalh sadu­ceos acxni̠ taqui̠­lák­lalh Jesús xlacán la̠li̠­huán tata­mac­xtú­mi̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Y acxni̠ chú luu li̠huana̠ tali̠­lac­chu­hui̠­nan­ko̠lh lácu natat­la­huay, tamá­ca̠lh cha̠tum xma̠­kalh­ta­hua­ke̠­nacán judíos antaní xuilachá Jesús la̠qui̠ xlá nakalh­pu­tzay aktum tachu­huí̠n la̠qui̠ para túcu nítlán nahuán chuná chú tlán nata­ma̠­la­capu̠y. Xlá chiné kalhás­quilh eé tachu­huí̠n: ");
INSERT INTO tocNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Ma̠kalh­ta­hua­ke̠ná, ¿xaní­cuma̠ xli̠­ma̠­peksí̠n Dios hua̠ntu̠ luu a̠tzinú qui­li̠­ma̠­kan­tax­ti̠tcán nac qui­la­ta­ma̠tcán? ");
INSERT INTO tocNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","Jesús chiné huá­nilh: —Hua̠ntu̠ luu mili̠­ma̠­kan­tax­ti̠tcán xli̠­ma̠­peksí̠n Dios chiné huán: “Capa̠xqui y cali̠­pá̠­huanti Mim­pu̠­chiná Dios xli̠­hua̠k minacú y xli̠­hua̠k mili̠s­tacni y xli̠­hua̠k min­ta­la­ca­pa̠s­tacni.” ");
INSERT INTO tocNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Y chi̠nchú xli̠­pu̠­lactiy na̠ a̠huayu xta̠­chuná huam­putún y chiné huán: “Cala­ka­lhá­manti min­ta̠­cris­tiano chuná cumu lá me̠cstu laka­lha­man­cana.” ");
INSERT INTO tocNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Xli̠­hua̠k hua̠ntu̠ tili̠­chu­huí̠­nalh Moisés xamaká̠n quilh­ta­macú xa̠huá hua̠ntu̠ titá­tzokli xalak­maká̠n pro­fetas nac xlib­rojcán pus huá xta­ma̠­si­yu­putún xatlá̠n xli̠­ma̠­peksí̠n Dios, pus huá chú tu̠ aquit caj kam­pa̠tiy ctla­huani̠t la̠qui̠ nama̠­kan­tax­ti̠­yá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ama̠­ko̠lh fariseos antacú xta­la­yá̠­nalh, ");
INSERT INTO tocNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesús chiné ca̠ka­lhás­quilh: —Hui­xinín ma̠x catzi̠­yá̠tit, xtla­huátit li̠tlá̠n xqui­la̠­hua­níhu, ¿nícu lac­pu­hua­ná̠tit nami­na̠chá Cristo hua̠nti̠ naca̠­lak­ma̠x­tuyá̠n? Xa̠huachi, ¿tícu xli̠­ta­la­ka­pasni ámaj huán? Xlacán takalh­tí̠­nalh: —Aquinín cca­tzi̠­yá̠hu pi̠ acxni̠ xlá nala­ca­chín huá xli̠­ta­la­ka­pasni xamaká̠n rey David ámaj li̠taxtuy. ");
INSERT INTO tocNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Huata Jesús ca̠hua­nipá: —Pero para xli̠­ca̠na chú chuná cahuá, entonces ¿túcu xpa̠­la­cata acxni̠ rey David ma̠lac­pu­huá̠­ni̠lh Espíri­tu Santo xlá na̠ li̠ma̠­pa̠­cú­hui̠lh Xpu̠­chiná? Porque lacatum nac Salmos chiné tzokli: ");
INSERT INTO tocNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Quim­pu̠­chiná Dios chiné huá­nilh cha̠tum li̠túm ti̠ na̠ Quim­pu̠­chiná: “Cata­huila nac quim­pa̠xtú̠n la̠qui̠ naquin­ta̠­ma̠­pek­si̠­nana, hasta caní aquit nac­ca̠­maka­tla­jako̠y pu̠tum hua̠nti̠ tasi̠­tzi̠­niyá̠n la̠qui̠ hua̠k nata­la­ka­chix­cu­hui̠yá̠n.” ");
INSERT INTO tocNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Pus, ¿lácu chú li̠lac­pu­hua­ná̠tit xla­cata pi̠ Cristo xli̠­ta­la­ka­pasni nahuán rey David, si hasta mismo David ca̠c­ni̠­naniy y li̠ma̠­pa̠­cu­hui̠y Quimpu̠chiná? ");
INSERT INTO tocNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Acxni̠ chuná ca̠hua­ni­ko̠lh a̠ma̠ko̠lh lac­chix­cu­huí̠n ni̠para tzinú tacá­tzi̠lh lácu nata­kalh­ti̠nán, y a̠má quilh­ta­macú niaj tícu kalhás­quilh para túcu. ");
INSERT INTO tocNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Aca­li̠stá̠n chú Jesús tzú­culh ca̠ta̠­kalh­chu­hui̠nán xdis­cí­pulos xa̠huá xli̠­lhu̠hua cris­tianos y chiné ca̠huá­nilh: ");
INSERT INTO tocNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Xli̠­hua̠k xma̠­kalh­ta­hua­ke̠­nacán judíos xa̠huá fariseos huá xlacán tala­ka­yá̠­nalh xla­cata nata­ma̠­la­ca­pu̠­tun­cu­hui̠y hua̠ntu̠ hua­ni­putún xta­péksi̠t Moisés. ");
INSERT INTO tocNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Cumu huá mima̠­kalh­ta­hua­ke̠­nacán luu xli̠­ca̠na pi̠ tla̠n naca̠­kax­pat­ni­yá̠tit hua̠ntu̠ xlacán naca̠­hua­niyá̠n y cama̠­kan­tax­tí̠tit hua̠ntu̠ naca̠­li̠­ma̠­pek­si̠yá̠n; pero ni̠chuná hui­xinín caca̠­maca­sta̠­látit hua̠ntu̠ xlacán tat­la­hua­má̠­nalh, porque tama̠­ko̠lh lac­chix­cu­huí̠n luu tla̠n hua̠ntu̠ tali̠­chu­hui̠nán, pero caj a̠nu̠chá anta­nícu caj sac­stucán tunu tat­la­hua­má̠­nalh hua̠ntu̠ ni̠tlá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Xlacán tahuaniy cris­tianos xla­cata juerza cata­ma̠­kan­táx­ti̠lh lactzu lactzú li̠ma̠­peksí̠n hua̠ntu̠ xlacán na̠ ni̠ tama̠­kan­tax­ti̠­má̠­nalh nac xla­ta­ma̠tcán; u̠má li̠ma̠­peksí̠n xta̠­chuná qui̠­taxtuy cumu la̠ lac­tzinca tacuca y tama̠­cu­qui̠y a̠túnuj cris­tianos hasta ma̠squi niajlay le̠ncán. Pero hua­tuní̠n u̠ma̠ko̠lh fariseos ni̠para tzinú tali̠­lac­chex­putún ca̠na̠caj xtzu̠­pi̠­macancán. ");
INSERT INTO tocNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Acxni̠ xlacán tat­la­huay aktum li̠tlá̠n tamakta̠y luhuatá tat­la­huay taán anta­nícu tza­macán la̠qui̠ naca̠ucxilhcán, y naca̠­li̠­ma̠x­tucán cumu la̠ lacuán cris­tianos. Xlacán tala­kati̠y ca̠s­la­ma­hua­ca­nicán nac xmu̠x­ti̠ncán chu nac xmacx­pa̠ncán clháka̠t lac­pi̠tzu̠ cáp­snat anta­nícu tatzokni̠t xta­chu­huí̠n Dios, y na̠chuna li̠túm luu tala­kati̠y li̠huana̠ tata­ca̠x­ta̠yay xla­cata clha­ka̠tcán, porque luu lac­pu̠lhmá̠n talha­ka̠nán y lhu̠hua hua̠ntu̠ tama̠­hua­caniy xli̠­ta­ca̠x­ta̠ycán la̠qui̠ tuncán naca̠­la­ka­pascán la̠tachá nícu nataán. ");
INSERT INTO tocNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Antá­nícu pa̠x­cuajna­má̠­calh xlacán tala­kati̠y caca̠­ma̠x­quí̠­calh hua̠ntu̠ a̠tzinú lacuán pu̠tá­hui̠lh la̠qui̠ naca̠­ma̠­hui̠cán, y na̠chuná tali̠­ca­tzi̠y acxni̠ taán nac xpu̠­si­cu­lancán luu lacán tata­hui­la­ya̠chá la̠qui̠ luu lac­ta­li̠­pa̠hu y lak­ska­lalán lac­chix­cu­huí̠n naca̠­li̠­ma̠x­tucán, ");
INSERT INTO tocNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","y na̠chuna li̠túm xlacán luu tala­cas­quín pi̠ caca̠­ca̠c­ni̠­na­ní­calh la̠tachá nícu naca̠­xa­kat­li̠­pa̠x­tokcán nac tiji y tala­kati̠y caca̠­li̠­ma̠­pa̠­cu­huí̠­calh lac­ta­li̠­pa̠hu ma̠kalh­ta­hua­ke̠­naní̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Pero huata hui­xinín ni̠ luu cali̠­la­ca­chix­cuj­núntit cumu lá xlacán tala­kati̠y pi̠ xli̠­hua̠k cris­tianos cata­li̠­ma̠­pa̠­cú­hui̠lh lac­ta­li̠­pa̠hu maes­tros, huá chuná cca̠­li̠­hua­niyá̠n porque hui­xinín caj li̠na­ta̠lán y caj xma̠n cha̠tum kalhi̠­yá̠tit mima̠­kalh­ta­hua­ke̠­nacán y huá aquit Cristo. ");
INSERT INTO tocNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Y na̠chuna li̠túm ni̠para cha̠tum tícu cali̠­ma̠­pa̠­cu­huí̠tit min­tla̠­ticán uú nac ca̠quilh­ta­macú, porque caj xma̠n cha̠tum kalhi̠­yá̠tit Min­tla̠­ticán caj xma̠nhuá Dios hua̠nti̠ hui­lachá nac akapú̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Y na̠ni̠­para huá tla̠n cat­la­huátit xla­cata naca̠­hua­ni­ca­ná̠tit puxcu, porque caj xma̠n cha̠tum kalhi̠­yá̠tit hua̠nti̠ luu Mim­pux­cucán caj xma̠nhuá aquit Cristo. ");
INSERT INTO tocNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Hua̠nti̠ luu tali̠­pa̠hu li̠tax­tu­putún nac milak­sti̠­pa̠ncán pus huata huá ma̠t­la̠nti̠y caca̠­lí̠s­cujli xa̠maka­pi­tzí̠n xta̠­cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Huá chuná cca̠­li̠­hua­nimá̠n porque hua̠nti̠ caj sacstu luu tali̠­pa̠hu maklh­ca­tzi̠cán ni̠ maka̠s tama̠­xani̠y y nama̠­tu̠­tzu­hui̠cán; pero hua̠nti̠ luu ni̠tu̠cu xkásat maklh­ca­tzi̠cán huata huá chú luu tali̠­pa̠hu li̠taxtuy aca­li̠stá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Koxu­tacu tihua­ná̠tit hui­xinín xma̠­kalh­ta­hua­ke̠­nacán judíos chu hui­xinín fariseos porque hui­xinín luu xaaksa­ni̠­naní̠n! La̠n pim­pá̠tit pa̠ti̠­na­ná̠tit porque hui­xinín ca̠ma̠­lac­chu­hua­ni­yá̠tit xamá̠­lacchi hua̠nti̠ tata­nu̠­putún nac xta­péksi̠t Dios la̠qui̠ ni̠tícu natanu̠y. Hui­xinín ni̠ tanu̠­pu­tu­ná̠tit nac xta­péksi̠t Dios, y na̠ni̠­para ca̠mak­xte­ká̠tit xla­cata nata­ta­nu̠­ya̠chá hua̠nti̠ xli̠­ca̠na tata­nu̠­putún. ");
INSERT INTO tocNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Koxu­tacú tihua­ná̠tit hui­xinín fariseos chu xma̠­kalh­ta­hua­ke̠­naní̠n judíos, porque hui­xinín luu xaaksa­ni̠­naní̠n! Porque tze̠k ca̠ak­ska­hui­mak­lhti̠­yá̠tit xchiccán hua̠nti̠ ca̠ni̠­makan­cani̠t lac­pus­ca̠tní̠n, y la̠qui̠ ni̠ naca̠­ca­tzi̠­ni­ca­ná̠tit min­ta̠­yatcán luu ma̠rí kalh­ta­hua­ka­yá̠tit acxni̠ tla­hua­yá̠tit ora­ción. Pus huá xpa̠­la­cata cca̠­li̠­hua­niyá̠n pi̠ a̠tzinú hui­xinín luu lhu̠hua kalhi̠­yá̠tit min­cuentajcán y la̠n napa̠­tí­na­ná̠tit ni̠xa­chuná maka­pi­tzí̠n cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Koxu­tacu tihua­ná̠tit hui­xinín fariseos chu xma̠­kalh­ta­hua­ke̠­nacán judíos, porque hui­xinín luu xaaksa­ni̠­naní̠n! Xli̠­ca̠na pi̠ cani̠huá piná̠tit ca̠la­ka­tza̠­la­yá̠tit la̠tachá túcuya̠ pu̠la­tama̠n hasta acxni̠ naqui̠­ta̠k­sá̠tit cha̠tum chixcú hua̠nti̠ tla̠n judío nat­la­hua­yá̠tit, pero acxni̠ tzu­cu­yá̠tit maka­ca̠­naj­la­yá̠tit chuná cumu la̠ hui­xinín ca̠naj­la­yá̠tit hasta a̠tzinú xalak­tzanká̠n latáma̠t ma̠x­qui̠­ni̠­tátit hua̠ntu̠ nali̠­chá̠n nac lhcúya̠t nac pu̠pa̠tí̠n ni̠xa­chuná cumu lá hua̠ntu̠ hui­xinín kalhi̠­yá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Koxu­tacu tihua­ná̠tit hui­xinín la̠ laka­xo̠ko̠n lac­chix­cu­huí̠n hua̠nti̠ ca̠pu̠­la­li̠­pim­pá̠tit xa̠maka­pi­tzí̠n cris­tianos! Hui­xinín hua­ná̠tit: “Acxni̠ para tícu li̠ta̠yay hua̠ntu̠ nama̠­kan­taxti̠y y para caj huá nali̠­qui­lhán a̠ma̠ lanca xpu̠­si­culan Dios ni̠tu̠ tla­huay tala̠­ka­lhí̠n ma̠squi ni̠ cama̠­kan­táx­ti̠lh. Pero para huá nali̠­qui­lhán a̠má oro hua̠ntu̠ tanu̠ma nac pu̠si­culan, xli̠­ca̠na pi̠ luu xli̠­ma̠­kan­táxti̠t a̠má xta­chu­huí̠n hua̠ntu̠ nali̠­ta̠yay porque nat­la­huay tala̠­ka­lhí̠n para ni̠ nama̠­kan­taxti̠y.” ");
INSERT INTO tocNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Xli̠­ca̠na pi̠ hui­xinín luu xala­ka­xo̠ko̠n y xalac­tonto! Porque caj caqui­la̠­hua­níhu: ¿túcu a̠tzinú luu li̠ma­cuán, pi̠ huá oro osuchí huá pu̠si­culan? Pus hui­xinín mili̠­ca­tzi̠tcán pi̠ caj huá xpa̠­la­cata pu̠si­culan ma̠squi chú sicu­la­na̠­lani̠t oro. ");
INSERT INTO tocNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Hui­xinín na̠chuná hua­ná̠tit pi̠ para tícu nat­la­huay aktum xpro­mesa xla­cata túcu nat­la­huay y para huá nali̠­qui­lhán a̠má altar hua̠ntu̠ huí nac pu̠si­culan ni̠ tla­huay tala̠­ka­lhí̠n ma̠squi ni̠ cama̠­kan­táx­ti̠lh hua̠ntu̠ xli̠­ta̠­yani̠t, pero para huá nali̠­qui­lhán a̠má li̠la­ka­chix­cu­hui̠n hua̠ntu̠ huí nac xok­spú̠n pu̠santu luu juerza xli̠­ma̠­kan­táxti̠t hua̠ntu̠ nali̠­ta̠yay, porque para ni̠ nama̠­kan­taxti̠y aya tla­huanít tala̠­ka­lhí̠n porque xka­lhi̠y xcom­pro­miso. ");
INSERT INTO tocNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Luu lac­tonto hui­xinín! Pus caj caqui­la̠­hua­níhu, ¿túcu a̠tzinú luu li̠ma­cuán puhua­ná̠tit, pi̠ huá li̠la­ka­chix­cu­hui̠n osuchí huá altar antaní hui­li̠cán a̠má li̠la­ka­chix­cu­hui̠n la̠qui̠ chuná nasi­cu­la­na̠lay? ");
INSERT INTO tocNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Aquit laca­tancs cca̠­hua­niyá̠n pi̠ hua̠nti̠ li̠ta̠yay para túcu nama̠­kan­taxtíy y huá li̠qui­lhán a̠má altar hua̠ntu̠ huí nac pu̠si­culan, ni̠ caj xma̠n huá li̠qui­lhama pu̠santu, huata na̠ hua̠k li̠qui­lhama la̠ta tu̠ huí nac xok­spú̠n pu̠santu. ");
INSERT INTO tocNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Y na̠chuna li̠túm hua̠nti̠ tla­huay aktum xpro­mesa y huá chú li̠qui­lhán a̠má lanca xpu̠­si­culan Dios xalac Jeru­salén xla­cata pi̠ juerza nama̠­kan­taxti̠y, pus ni̠ caj xma̠nhuá li̠qui­lhán pu̠si­culan, pus na̠ huá li̠qui­lhama Dios porque xlá antá anka­lhi̠ná huí. ");
INSERT INTO tocNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Y na̠chuna li̠túm a̠má hua̠nti̠ tla­huay aktum xpro­mesa y huá li̠qui­lhán akapú̠n xla­cata pi̠ nama̠­kan­taxti̠y, pus xli̠­ca̠na cca̠­hua­niyá̠n pi̠ huá li̠qui­lhama xpu̠­ma̠­peksí̠n Dios, y na̠ hua̠k li̠qui­lhama Dios porque antá xlá tahuilay. ");
INSERT INTO tocNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Koxu­tacu tihua­ná̠tit hui­xinín xma̠­kalh­ta­hua­ke̠­nacán judíos chu hui­xinín fariseos, porque xli̠­ca̠na pi̠ luu xaaksa­ni̠­naní̠n hui­xinín! Hui­xinín ne̠c­xnicú ca̠la­ca­tza̠­layá̠n xla­cata pi̠ anka­lhi̠ná li̠la­ka­chix­cu­huí̠­yá̠tit Dios cumu lá mili­mos­najcán a̠má lactzu lactzú hua̠ntu̠ maka­la­yá̠tit nac min­ca̠­tu­hua̠ncán, cumu la̠ menta, anís chu comino; pero huata pa̠tzan­ka̠­yá̠tit y ni̠ ma̠kan­tax­ti̠­pá̠tit a̠má xli̠­ma̠­peksí̠n Dios hua̠ntu̠ luu xli̠­ca̠na mili̠­ma̠­kan­tax­ti̠tcán nac mila­ta­ma̠tcán xla­cata xli̠­ca̠na pi̠ xca̠­pa̠x­quí̠tit min­ta̠­cris­tianoscán, xca̠­li̠­taaka­tzan­ké̠tit xa̠maka­pi­tzí̠n y hua̠ntu̠ tla̠n xca̠t­la­hua­nítit, na̠chuna li̠túm luu aktumá tala­ca­pa̠s­tacni xka­lhí̠tit xla­cata nali̠­pa̠­hua­ná̠tit Dios. Aquit ni̠tu̠ cca̠­hua­nimá̠n para niaj cama̠s­tá̠tit mili̠­mos­najcán hua̠ntu̠ ma̠s­tá̠­yá̠tit, pero huata cca̠­hua­ni­pu­tuná̠n pi̠ na̠ luu xla­ca­squinca pi̠ pu̠lh huá nama̠­kan­tax­ti̠­yá̠tit xta­peksi̠t Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Koxu­tacu tihua­ná̠tit hui­xinín porque xli̠­ca̠na luu mákat aktzan­ka̠­ni̠­tátit y la̠m­para laka­xo̠ko li̠tax­tu­yá̠tit! Porque luu cuentaj tla­hua­yá̠tit xla­cata ni̠ nata̠­hua­yá̠tit tantum actzu xima̠hua a̠má chú­chut hua̠ntu̠ li̠kot­nu­ná̠tit y luu li̠huana̠ lac­tzi­qui̠­yá̠tit, pero ni̠para tzinú catzi̠­yá̠tit acxni̠ hua­yá̠tit tantum lanca camello. ");
INSERT INTO tocNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Pa̠x­ca­tacu tihua­ná̠tit hui­xinín xma̠­kalh­ta­hua­ke̠­nacán judíos y fariseos, porque luu xaaksa­ni̠­naní̠n hui­xinín! Hui­xinín luu li̠taaka­tzan­ke̠­yá̠tit li̠huana̠ ca̠lak­che­ke̠­pi̠­yá̠tit mim­pu­la̠­tucán chu miva­sucán hua̠ntu̠ pu̠hua̠­ya­ná̠tit chu hua̠ntu̠ pu̠kot­nu­ná̠tit, pero huata nac mim­pu̠­lac­nicán antá nac mina­cujcán luu lhu̠hua huí hua̠ntu̠ ni̠tlá̠n, porque chuná li̠ma̠ak­sto­kuili̠­ni̠­tátit la̠ta catu̠huá hua̠ntu̠ kalha­ni̠­tátit, chu min­taaksa­ni̠ncán liak­ska­hui­ni­ni̠­tátit hua̠ntu̠ ni̠ milacán. ");
INSERT INTO tocNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Aksa­ni̠­naní̠n fariseos, xli̠­ca̠na cca̠­hua­niyá̠n pi̠ luu aktzan­ka̠­ni̠­tátit! Huata mejor hua̠ntu̠ tla̠n nahuán pu̠lh huá nac xpu̠­lacni anta­nícu ni̠ tasiyuy cache­ke̠­nítit mim­pu̠­hua̠ycán, y acxni̠ chú nalak­che­ke̠­yá̠tit nac xmacni luu xli̠­ca̠na xata­cheké̠n nahuán. ");
INSERT INTO tocNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Aksa­ni̠­naní̠n! Xma̠­kalh­ta­hua­ke̠­nacán judíos y fariseos, pa̠x­ca­tacu tihua­ná̠tit porque mila­ta­ma̠tcán luu xta̠­chuná qui̠­taxtuy cumu la̠ a̠ma̠ko̠lh pan­teón hua̠ntu̠ tahui­lá̠­nalh nac ca̠pú̠­sa̠ntu. Xli̠­ca̠na pi̠ luu lak­li̠­la­káti̠t tasiyuy nac xmac­nicán porque ca̠ma­ni̠­cani̠t, pero antá nac xpu̠­lacni luu li̠xcáj­nit xlac­lúcut ni̠n taju̠ma. ");
INSERT INTO tocNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Xli̠­ca̠na pi̠ chuná hui­xinín tasi­yu­yá̠tit nac xla­ca­ti̠ncán cris­tianos; caj la̠ta nac mimac­nicán la̠m­para luu lacuán cris­tianos tasi­yu­yá̠tit y chuná li̠tax­tu­yá̠tit, pero antá nac mina­cujcán luu li̠xcáj­nit xtá̠yat porque lhu̠hua hua̠ntu̠ ni̠tlá̠n tala­ca­pa̠s­tacni kalhi̠­yá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Pa̠x­ca­tacu tihua­ná̠tit xma̠­kalh­ta­hua­ke̠­naní̠n judíos y fariseos, porque a̠ma̠ko̠lh pro­fetas hua̠nti̠ tica̠­mák­ni̠lh xalak­maká̠n mili̠­ta­la­ka­pas­nicán, hui­xinín chú ca̠ca̠x­tla­hua­ni­yá̠tit xalak­li̠­la­káti̠t xpan­teoncán, y ca̠ca̠x­tla­hua­ni­yá̠tit xab­ronce xla­ca­pu̠ncán y ta̠lhmá̠n ca̠ya̠­hua­yá̠tit la̠qui̠ chuná naca̠­li̠­la­ca­pa̠s­taccán a̠ma̠ko̠lh lacuán lac­chix­cu­huí̠n! ");
INSERT INTO tocNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Acxni̠ chú kalh­chu­hui̠­na­ná̠tit hua­ná̠tit: “Para na̠ acxni̠ xac­ti­la­ta­má̠hu a̠má maká̠n quilh­ta­macú acxni̠ xta­la­má̠­nalh xalak­maká̠n qui­li̠­ta­la­ka­pas­nicán hua̠nti̠ tita­mák­ni̠lh pro­fetas, aquinín ni̠ xac­ti­mak­ta­nú̠hu xla­cata nac­ca̠­mak­mak­ni̠­yá̠hu a̠ma̠ko̠lh pro­fetas hua̠nti̠ ca̠mak­ní̠­calh.” ");
INSERT INTO tocNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Acxni̠ chuná hua­ná̠tit luu ma̠n laca­tancs li̠ta̠­ya­yá̠tit pi̠ xli̠­ca̠na huá xalak­maká̠n mili̠­ta­la­ka­pas­nicán hua̠nti̠ tita­mák­ni̠lh pro­fetas hua̠nti̠ xta­la­má̠­nalh xamaká̠n quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Pus luu xli̠­ca̠na pi̠ huá tama̠­ko̠lh mili̠­ta­la­ka­pas­nicán xta­huani̠t, pus la̠li̠­huán cat­la­huátit y cama̠­ta̠s­pu­tútit hua̠ntu̠ xlacán tita­ma̠­tzu­qui̠­chitá xamaká̠n quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Pa̠x­ca­tacu tihua­ná̠tit, luu xta̠­chuná li̠tax­tu­yá̠tit cumu la̠ lu̠hua hua̠ntu̠ tze̠k tax­canán! Pus caj tzinú caka­lhí̠tit, ¿lácu chú nala­yá̠tit lac­pu­hua­ná̠tit xla­cata tla̠n natax­tu­ni­yá̠tit a̠má lanca tapa̠tí̠n hua̠ntu̠ tala­ca­tzu­hui̠ma xala ca̠lh­cu­ya̠tni? ");
INSERT INTO tocNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Pus cumu para hui­xinín ni̠ luu ca̠naj­la­yá̠tit hua̠ntu̠ cca̠­hua­nimá̠n, pus nac­ca̠­ma­ca­mi­niyá̠n lhu̠hua pro­fetas xa̠hua lak­ska­lalán ma̠kalh­ta­hua­ke̠­naní̠n; pero huata hui­xinín naca̠­mak­ni̠­yá̠tit, maka­pi­tzí̠n naca̠­pe­kex­to­ko­hua­ca­yá̠tit nac cruz, na̠chuná maka­pi­tzí̠n la̠n naca̠­hui­li̠­ni­yá̠tit nac mim­pu̠­si­cu­lancán, y hasta naca̠­pu­tza­sta̠­la­yá̠tit la̠tachá nícuya̠ ca̠chi­quí̠n xlacán nata­la­ta­ma̠­putún ma̠squi luu makattá. ");
INSERT INTO tocNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Pero laca­tancs cca̠­hua­niyá̠n pi̠ antá chú nac mila­ta­ma̠tcán amá̠n ca̠ta­hua­ca­ni­ko̠yá̠n xli̠­hua̠k a̠má li̠ka­lha­pálat xa̠hua li̠xokó̠n hua̠ntu̠ luu xli̠­lak­cha̠nat xuani̠t xalak­maká̠n mili̠­ta­la­ka­pas­nicán caj xla­cata hua̠ntu̠ tatit­la­huani̠t la̠ta tamak­ni̠­nani̠t, acxni̠ ca̠mak­ni̠­cani̠t a̠ma̠ko̠lh lacuán xta­pu­hua̠nca̠n cris­tianos hasta la̠ta ti̠ pu̠lh timak­ní̠­calh xamaká̠n, hasta púlh huá mak­ni̠­cani̠t a̠má tla̠n chixcú hua̠nti̠ xuanicán Abel, y na̠ xli̠­hua̠k hua̠nti̠ tica̠­mak­ní̠­calh hasta acxni̠ xlama a̠má akchu­hui̠na chixcú Zaca­rías hua̠nti̠ xka­huasa xuani̠t Bere­quías, hua̠ eé hua̠nti̠ tamák­ni̠lh mili̠­ta­la­ka­pas­nicán lacatzú altar hua̠ntu̠ huí nac lanca pu̠si­culan cJerusalén. ");
INSERT INTO tocNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Aquit laca­tancs cca̠­hua­niyá̠n pi̠ xli̠­hua̠k eé tala̠­ka­lhí̠n hua̠ntu̠ tatit­la­huani̠t xa̠maka­pi­tzí̠n, pus hua̠k huá chú naca̠­ta­hua­ca­niyá̠n xli̠­hua̠k hui­xinín judíos hua̠nti̠ lapá̠tit ca̠lacchú xla­cata naca̠­ma̠­xo­ko̠­ni̠­ca­ná̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jesús tzú­culh li̠pu­huán hasta nac xnacú y chiné chu­huí̠­nalh: —Jeru­salén, ¡koxuta huix quin­ca̠­chi­quí̠n Jeru­salén! Antá uú ca̠mak­ni̠­cani̠t hua̠nti̠ luu lac­ta­li̠­pa̠hu xpro­fetas Dios, na̠ antá ca̠acta­la­mak­ni̠­cani̠t lhu̠hua xlac­scujní̠n hua̠nti̠ Dios tica̠­ma­cá­milh. Aquit mak­lhu̠hua ctzak­sani̠t cca̠­ma̠­mac­xtu­mi̠­putún xli̠­hua̠k hua̠nti̠ uú tahui­lá̠­nalh chuná cumu la̠ lactzú xalak­skata xti̠la̠n ca̠ma̠­mac­xtumi̠y xtzí y luu li̠huana̠ ca̠tam­pi̠­tanu̠y, pero huata hui­xinín ni̠tlá̠n tla­hua­yá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Pero chú luu laca­tancs pi̠ aya lak­tzan­ka̠­ni̠ta, porque aya tala­ca­tzu­hui̠ma quilh­ta­macú acxni̠ xli̠­hua̠k aka­tunu chiqui hua̠ntu̠ uú ca̠t­la­hua­cani̠t ca̠ta caj chu­natá nata­ta̠yay porque niaj ti̠ cati­táhui xpu̠­chiná. ");
INSERT INTO tocNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Huá chuná cca̠­li̠­hua­nimá̠n porque chú niaj caquin­ti­la̠ucxi­lhui hui­xinín hua̠nti̠ uú hui­látit hasta acxni̠ nalak­chá̠n quilh­ta­macú acxni̠ hui­xinín nahua­ná̠tit: “¡Luu ca̠na̠ li̠pa̠­xúhu cmaka­maklhti̠­na­ma̠­náhu hua̠nti̠ mima nac xta­cu­huiní Quin­tla̠­ticán Dios!” ");
INSERT INTO tocNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Aca­li̠stá̠n Jesús táx­tulh nac lanca xpu̠­si­culan Dios, aya xtaamá̠­nalh acxni̠ a̠ma̠ko̠lh xdis­cí­pulos tzú­culh taucxilha a̠má lak­li̠­la­káti̠t chí­huix hua̠ntu̠ li̠huana̠ xca̠­li̠­ca̠x­tla­hua­cani̠t xapá̠­tzaps pu̠si­culan; caj la̠ta xtaucxilh­má̠­nalh luu xta­la­ka­ti̠­la­ca̠­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Cumu ca̠kax­mát­nilh Jesús la̠ta xta­la̠­li̠­ta̠­kalh­chu­hui̠­na­má̠­nalh xlá chiné ca̠huá­nilh: —Xli̠­ca̠na pi̠ luu li̠la­káti̠t tasiyuy hua̠ntu̠ hui­xinín ucxilh­pá̠tit, pero aquit laca­tancs cca̠­hua­niyá̠n pi̠ amaj lak­chá̠n quilh­ta­macú acxni̠ niaj para aktum chí­huix cati­táhui anta­nícu xca̠­hui­li̠­cani̠t porque hua̠k nalac­tilh­mi̠­ko̠cán y niaj tu̠ catiánalh. ");
INSERT INTO tocNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Acxni̠ chú tácha̠lh nac a̠má ke̠stí̠n hua̠ntu̠ hua­nicán Cerro de los Olivos Jesús culucs táhui y talak­ta­la­ca­tzú­hui̠lh xdis­cí­pulos, chiné tze̠k taka­lhás­quilh: —Aquinín cla­cas­qui­ná̠hu pi̠ xqui­la̠­ma̠­la­ca­pu̠­tun­cu­hui̠­níhu túcuya̠ quilh­ta­macú amaj lak­chá̠n xla­cata nakan­taxtuy hua̠ntu̠ huix qui­la̠­li̠­ta̠­kalh­chu­hui̠­na­ma̠­náhu acxni̠ nalac­tilh­mi̠­ko̠cán pu̠si­culan. Y na̠chuna li̠túm, ¿túcu nata­siyuy la̠qui̠ nac­ca­tzi̠­yá̠hu aquinín pi̠ aya tam­pa̠­para nahuán uú nac ca̠quilh­ta­macú, y na̠ acxni­tiyá chú nas­putcán? ");
INSERT INTO tocNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús ca̠kálh­ti̠lh: —Luu xli̠­ca̠na cuentaj cat­la­huátit xla­cata pi̠ ni̠ti̠ naca̠ak­ska­hui­mi̠yá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Porque aquit laca­tancs cca̠­hua­niyá̠n pi̠ lhu̠hua hua̠nti̠ xta̠­chuná nata­li̠­tax­tu­putún cumu la̠ aquit xa̠huachí nata­huán: “Aquit Cristo hua̠nti̠ naca̠lakma̠xtuyá̠n”, luu lhu̠hua cris­tianos nataak­ska­huimi̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Xa̠huachí hui­xinín nakax­pa­tá̠tit la̠ta nali̠­chu­hui̠­nancán pi̠ li̠pe̠cua la̠ta lama guerra lacatzú, y na̠chuná lama guerra anta­nícu luu mákat, pero huata hui­xinín ni̠ cape̠­cuántit porque luu xla­ca­squinca pi̠ chuná pu̠lh nalay, pero ni̠naj a̠ lak­chá̠n nahuán quilh­ta­macú la̠ta nas­putcán. ");
INSERT INTO tocNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Acxni̠ chú nalak­chá̠n a̠má quilh­ta­macú, la̠ta xli̠­lhu̠hua tú tahui­lá̠­nalh pu̠la­tama̠n natzucuy tala̠­la­ca­ta̠­qui̠y y natat­la­huay guerra, aka­tunu ca̠chi­quí̠n nata̠­la̠­la­ca­ta­huacay a̠túnuj ca̠chi­quí̠n, xa̠huachí luu li̠pe̠cua nalay tatzín­c­stat y lacaxtum ámaj tachi­quiy tíyat hasta huí ní napu̠­tzan­ka̠nán. ");
INSERT INTO tocNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pero acxni̠ chuná nalay cajcu luu quilh­tzu­cuma nahuán la̠ta ámaj min xli̠­lhu̠hua tapa̠tí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Hui­xinín naca̠­ma­ca­ma̠s­ta̠­ca­ná̠tit la̠qui̠ la̠n naca̠­hui­li̠­ni­ca­ná̠tit; la̠n naca̠­ma̠­pa̠­ti̠­ni̠­ca­ná̠tit, hasta maka­pi­tzí̠n hui­xinín naca̠­mak­ni̠­ca­ná̠tit, xli̠­lhu̠hua cris­tianos naca̠­si̠­tzi̠­niyá̠n caj quim­pa̠­la­cata cumu hui­xinín qui­la̠­li̠­pa̠­hua­ná̠hu. ");
INSERT INTO tocNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Acxni̠ nalak­chá̠n a̠má quilh­ta­macú luu lhu̠hua hua̠nti̠ nata­ta­chokoy y niaj caquin­ti­ta­li̠­pá̠hua, hasta mejor ma̠n nata­tzucuy tala̠­ma­ca­ma̠sta̠y xla­cata pi̠ catu̠huá hua̠ntu̠ ni̠tlá̠n nata­la̠t­la­huaniy. ");
INSERT INTO tocNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Lhu̠hua aksa­ni̠­naní̠n nata­tzucuy tahuán pi̠ huá xta­chu­huí̠n Dios tali̠­chu­hui̠­na­má̠­nalh, y luu lhu̠hua cris­tianos hua̠nti̠ nata­taak­ska­huiy. ");
INSERT INTO tocNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Xli̠­lhu̠hua cris­tianos nata­tzucuy tamaca­sta̠lay hua̠ntu̠ tat­la­huay a̠ma̠ko̠lh cris­tianos hua̠nti̠ ni̠tlá̠n xta­pu­hua̠ncán, y niaj tícu cati­ta̠­la̠­la­ka­lhá­malh. ");
INSERT INTO tocNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Sola­mente hua̠nti̠ ni̠ nata­cho­koniy y chu­na­tiyá aksti̠tum naqui­li̠­pa̠­huán hasta acxni̠ nati̠­tax­tuko̠y hua̠ntu̠ ni̠ xala­cuán quilh­ta­macú, xli̠­ca̠na pi̠ huá chú tla̠n nalak­ma̠xtuy xla­táma̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pero huá u̠má xasa̠sti xta­péksi̠t Dios hua̠ntu̠ aquit cmini̠t ma̠la­ca­tzu­qui̠y xli̠­ca̠­lanca nama̠­la­ka­pun­tu­mi̠cán nac ca̠quilh­ta­macú la̠qui̠ xli̠­hua̠k cris­tianos nata­la­ka­pasa, pus acxni­tiyá aya laka­pas­ko̠­cani̠t nahuán na̠ aya nas­putcán nac ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Acxni̠ chú hui­xinín naucxi­lhá̠tit pi̠ kan­tax­tuma hua̠ntu̠ xamaká̠n quilh­ta­macú tili̠­chu­huí̠­nalh pro­feta Daniel acxni̠ tzokli la̠ta lácu nali̠­ka­ma̠­nancán a̠má lanca pu̠si­culan xalac Jeru­salén —hua̠nti̠ li̠kalh­ta­huakay eé libro pus caaká­ta̠ksli hua̠ntu̠ li̠chu­hui̠­nama Jesús—, ");
INSERT INTO tocNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","aquit cca̠­hua­niyá̠n pi̠ hua̠nti̠ tahui­la̠­nanchá nahuán nac Judea huata mejor cata­tzá̠­lalh nac ca̠si­pijni. ");
INSERT INTO tocNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Hua̠nti̠ lahua­cachá nahuán nac xak­stí̠n xchic niaj capá̠s­tacli para túcu namín tamac­xtuy huata mejor caj catzá̠­lalh. ");
INSERT INTO tocNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Y chi̠nchú hua̠nti̠ ani̠t nahuán nac xca̠­tu­huá̠n niaj catás­pitli nac xchic xla­cata namín tiyay clháka̠t huata mejor na̠ caj catzá̠­lalh. ");
INSERT INTO tocNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Koxu­taní̠n a̠ma̠ko̠lh lac­chaján hua̠nti̠ luu acxni̠ a̠má quilh­ta­macú tata̠­tatlay y niaj sacstu tala­má̠­nalh nahuán osuchí hua̠nti̠ tama̠­tzi­qui̠y nahuán cska­tacán! ");
INSERT INTO tocNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Luu xli̠­ca̠na cali̠s­qui­nítit li̠tlá̠n Dios xla­cata pi̠ ni̠ acxni̠ nalak­chá̠n u̠má tapa̠tí̠n acxni̠ luu li̠pe̠cua lon­knuma nahuán osuchí acxni̠ luu lak­cha̠ni̠t quilh­ta­macú sábado acxni̠ hui­xinín jax­pá̠tit nahuán. ");
INSERT INTO tocNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Porque a̠má quilh­ta­macú luu xli̠­ca̠na pi̠ huij nahuán lanca tapa̠tí̠n cumu la̠ ne̠c­xnicú chuná a̠ lay hasta la̠ta Dios tima̠­la­ca­tzú­qui̠lh ca̠quilh­ta­macú, y niajpara chuná cati­ca̠­ma̠­pa̠­tí̠­ni̠lh cris­tianos aca­li̠stá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Pero huá Dios catzi̠y túcu tla­huama porque xlá aya li̠ma̠c­ti̠ni̠t quilh­ta­macú y ni̠ luu maka̠s cati­maka­pá­lalh, porque para xlá ni̠ chuná xtlá­hualh niajpara cha̠tum cris­tiano xaka­tá̠x­tulh; pero huá xlá chuná li̠t­la­huani̠t la̠qui̠ tla̠n nataaka­pu̠­taxtuy xli̠­hua̠k hua̠nti̠ xlá ca̠lac­sacni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Acxni̠ a̠má quilh­ta­macú para tícu naca̠­hua­niyá̠n: “Anú lama̠chá Cristo”, osuchí nahuancán: “Huá u̠má Cristo”, hui­xinín ni̠ caca̠­naj­látit. ");
INSERT INTO tocNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Porque luu lhu̠hua hua̠nti̠ natzucuy tali̠­taxtuy cumu lá Cristo, y na̠chuná luu lhu̠hua hua̠nti̠ nataakchu­hui̠nán y nata­huán pi̠ huá xta­chu­huí̠n Dios tali̠­chu­hui̠­na­má̠­nalh pero ni̠ xli̠­ca̠na. Xlacán tla̠n natat­la­huay lac­lanca li̠cá̠cni̠t ta­scújut la̠qui̠ chuná tla̠n nata­ma­ka­ca̠­najlay cris­tianos, y hasta xlacán nataak­ska­hui­mi̠­putún hua̠nti̠ luu ma̠n Dios ca̠lac­sacni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Aquit a̠li̠sok cca̠­hua­nimá̠n la̠qui̠ hui­xinín aya li̠ca­tzi̠­hui­látit nahuán. ");
INSERT INTO tocNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Pus huá xpa̠­la­cata acxni̠ hui­xinín naca̠­hua­ni­ca­ná̠tit: “Anú lama̠chá Cristo nac desierto”, osuchí naca̠­hua­ni­ca­ná̠tit: “Anú tze̠k tanúma nac chiqui”, hui­xinín ni̠ caca̠­naj­látit. ");
INSERT INTO tocNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Pus luu li̠huana̠ nac­ca̠­hua­niyá̠n pi̠ xta̠­chuná cumu lá acxni̠ jiliy y mak­lipa y xli̠­ca̠­lanca ca̠quilh­ta­macú macax­ka­ke̠­nanko̠y, pus na̠ luu xta̠­chuná cani̠huá naquiucxilhcán acxni̠ aquit nac­mim­paray xli̠­maktiy nac ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Cumu la̠ hui­xinín catzi̠­yá̠tit anta­nícu ni̠y tantum taka­lhí̠n hua̠k antá tata­mac­xtumi̠y chu̠n, pus na̠chuná chú nalay a̠má quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Acxni̠ chuná nati̠­tax­tuko̠y a̠má quilh­ta­macú la̠ta la̠n napa̠­ti̠­nancán hua̠ntu̠ aquit cca̠­li̠­ta̠­chu­hui̠­na­ni̠tán, chi­chiní niaj cati­maca­xka­ké̠­nalh ca̠cu­huiní, na̠chuná papá niaj cati­ta­sí­yulh ca̠tzi̠sní, y chi̠nchú stacu natzucuy tata­mo­kosa nac ca̠tu̠tzú, y hasta hua̠k la̠ta lac­lanca li̠t­li­hueke hua̠ntu̠ hui­la­ko̠lh nac akapú̠n nata­chi­quiko̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Acxni­tiyá chú a̠má quilh­ta­macú nata­siyuy aktum lanca liucxilhni la̠qui̠ naca­tzi̠cán pi̠ aquit cmi­majá nahuán. Acxni­tiyá chú naqui­la̠ucxi­lhá̠hu aquit Xata­lac­sacni Chixcú pi̠ cta̠c­ta­ma̠chi nahuán nac akapú̠n cmímaj nahuán nac xlacni puc­lhni y cli̠­mímaj nahuán xli̠­hua̠k qui­li̠t­li­hueke hua̠ntu̠ cka­lhi̠y. Y xli̠­hua̠k cris­tianos xala ca̠quilh­ta­macú acxni̠ naquin­taucxilha cta̠c­ta­ma̠chi nac akapú̠n natzucuy tatasay caj xpa̠­la­cata xta­li̠­pu­hua̠ncán cumu taca­tzi̠y pi̠ nata­pa̠­ti̠nán caj xpa̠­la­cata ni̠tlá̠n tu̠ tat­la­huani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Y chi̠nchú aquit nac­ca̠­li̠­ma̠­peksi̠y quiángeles xla­cata pi̠ acxni̠ nata­kax­mata pi̠ nama̠­sa̠­ni̠cán lanca xtrom­peta Dios cata­ma̠­mac­xtú­mi̠lh xli̠­hua̠k xca­maná̠n Dios hua̠nti̠ xlá ca̠lac­sacni̠t la̠ta nac xli̠­ca̠­lanca ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Hui­xinín luu catzi̠­yá̠tit xla­cata acxni̠ ucxi­lhá̠tit tzucuy aka­yuja maka­pi­tzí̠n quihui y tzucuy akas­ka­tam­paray pi̠ aya tala­ca­tzu­hui̠ma quilh­ta­macú la̠ta natzucuy lhca̠cnán, ");
INSERT INTO tocNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","pus na̠chuna li̠túm acxni̠ chuná hui­xinín naucxi­lhá̠tit pi̠ aya kan­tax­tuma nahuán hua̠ntu̠ la̠nchú cca̠­hua­nimá̠n, pus caca­tzí̠tit pi̠ aya lak­cha̠ni̠t hora acxni̠ aquit nac­mim­paray nac ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Aquit laca­tancs cca̠­hua­niyá̠n xla­cata pi̠ hua̠ntu̠ cca̠­li̠­ta̠­chu­hui̠­namá̠n la̠nchú, hasta nia̠ tani̠ko̠y nahuán u̠ma̠ko̠lh cris­tianos hua̠nti̠ tala­má̠­nalh la̠ ca̠lacchú quilh­ta­macú acxni̠ hua̠k nakan­tax­tuko̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","La̠ta xli̠­lanca ca̠quilh­ta­macú chu akapú̠n juerza ámaj lak­tzanka̠y, pero huá quin­ta­chu­huí̠n ni̠ ámaj lak­tzanka̠y hasta caní nakan­tax­tuko̠y la̠ta pu̠la­ca­tunu hua̠ntu̠ cca̠­li̠­ta̠­kalh­chu­hui̠­na­ni̠tán. ");
INSERT INTO tocNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Hua̠nchú xla­cata quilh­ta­macú acxni̠ nalak­chá̠n xla­cata nakan­taxtuy hua̠ntu̠ cca̠­hua­nimá̠n la̠nchú, tamá xlá ni̠para cha̠tum tícu catzi̠y, ni̠para huá xán­geles Dios, na̠ ni̠para aquit, caj xma̠n catzi̠y Quin­tla̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Chuná cumu la̠ ti̠tax­tuni̠t xamaká̠n quilh­ta­macú acxni̠ xlama Noé, ni̠tícu xca̠­najlay pi̠ namín spútut, pus na̠chuná chú naqui̠­taxtuy acxni̠ aquit nac­mim­paray xli̠­maktiy nac ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Amá maká̠n quilh­ta­macú acxni̠ nia̠ xlay mun­cá̠ctat y Noé nia̠ xtanu̠y nac a̠má lanca barco hua̠ntu̠ hua­nicán arca, la̠ta xli̠­lhu̠hua cris­tianos ni̠para tzinú xta­li̠­púhua para ni̠tlá̠n hua̠ntu̠ xtat­la­hua­má̠­nalh huata chu­na­tiyá xta­pa̠­xu­hua­má̠­nalh hua̠ntu̠ xta­ka­lhi̠y y xta­ta­maka­xtok­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Pero acxni̠ ni̠para tzinú xta­li̠a̠ca­tzi̠­hui­lá̠­nalh tahui­lachi chú­chut, lalh mun­cá̠ctat y pu̠tum ca̠mák­ni̠lh. Na̠chuná chú naqui̠­taxtuy acxni̠ aquit Xata­lac­sacni Chixcú nac­mim­paray xli̠­maktiy. ");
INSERT INTO tocNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Amá quilh­ta­macú para cha̠tiy lac­chix­cu­huí̠n lac­xtum tas­cuj­má̠­nalh nahuán nac xca̠­tu­hua̠ncán, cha̠tum nale̠ncán y cha̠tum namak­xtekcán. ");
INSERT INTO tocNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Cha̠tiy lac­chaján lac­xtum tas­qui­ti­má̠­nalh nahuán, cha̠tum nale̠ncán y cha̠tum namak­xtekcán. ");
INSERT INTO tocNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Pero xma̠nhuá cca̠­hua­niyá̠n xla­cata pi̠ luu ská­lalh cata­hui­látit porque ni̠para tzinú catzi̠­yá̠tit túcuya̠ quilh­ta­macú aquit nac­ca̠­lak­chiná̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Xli̠­cána hui­xinín luu ská­lalh cala­ta­pá̠tit xta̠­chuná cumu la̠ cha̠tum chixcú hua̠nti̠ luu ská­lalh tama̠y lhtatay la̠qui̠ ni̠ nata­lak­tanu̠y kalha̠­naní̠n, porque para xlá ni̠ ská­lalh nata­huilay ni̠para tzinú xali̠­ta­ca­tzí̠n acxni̠ nata­lak­ta­nu̠­ya̠chá̠ kalha̠­naní̠n y namak­ka­lha̠­nan­ko̠cán la̠tachá túcu xlá xka­lhi̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Pus na̠chuná chú hui­xinín cumu ni̠ catzi̠­yá̠tit túcuya̠ hora y quilh­ta­macú nacmín xli̠­maktiy, huata luu ca̠mi­ni̠­niyá̠n anka­lhi̠ná ská­lalh cala­ta­pá̠tit, porque acxni̠ ni̠para tzinú li̠a̠ca­tzi̠­hui­látit nahuán aquit nac­mim­paray. ");
INSERT INTO tocNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Aquit cla­cas­quín pi̠ hui­xinín huá xmaca­sta̠­látit cha̠tum tasa̠cua hua̠nti̠ tla̠n xta­pu­huá̠n y xpatrón ma̠cuentajli̠y xchic la̠qui̠ xlá naca̠­mak­ta­kalha xli̠­hua̠k hua̠ntu̠ kalhi̠y y na̠ naca̠­ma̠­hui̠y xa̠maka­pi­tzí̠n xta̠­ta­sa̠­cuá̠n acxni̠ nalak­chá̠n hora la̠ta nata­hua̠yán. ");
INSERT INTO tocNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Luu xli̠­ca̠na tzu­cucán ta̠pa̠­xu­huacán a̠má tasa̠cua acxni̠ nalak­chín xpatrón y chuná ma̠kan­tax­ti̠ma a̠má li̠ta­scújut hua̠ntu̠ tili̠­ma̠­pek­sí̠­calh. ");
INSERT INTO tocNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Cumu para nama̠­nok­lhucán pi̠ xli̠­ca̠na scujma a̠má tasa̠cua huata xpatrón hua̠k huá nama̠­cuentaj­li̠ko̠y la̠ta túcua kalhi̠y, luu laka­lha­mancán hua̠nti̠ tla̠n xta­pu­huá̠n tasa̠cua. ");
INSERT INTO tocNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero para huata tamá tasa̠cua nalac­pu­huán pi̠ ni̠ pála catí­chilh xpatrón, ");
INSERT INTO tocNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","huata caj natzucuy ca̠ma̠­pa̠­ti̠ni̠y xa̠maka­pi­tzí̠n xta̠­ta­sa̠­cuán, y caj amigos naca̠­ta̠lay hua̠nti̠ na̠ luu lac­li̠xcáj­nit xta­pu­hua̠ncán y huá tzucuy ca̠ta̠­ka­chi̠­tama̠y y la̠n ca̠ta̠­hua̠yán. ");
INSERT INTO tocNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Pero huata acxni̠ ni̠ ska­lalh huí xla­cata naka­lhíy xpatrón para aya nachín, acxni̠ ni̠ li̠a̠ca­tzi̠hui nalak­chín xpatrón. ");
INSERT INTO tocNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tancs cca̠­hua­niyá̠n pi̠ a̠má patrón la̠n nama̠­pa̠­ti̠ni̠y, nama­ca̠ncán nac pu̠pa̠tí̠n anta­nícu ca̠ma­ca̠ncán hua̠nti̠ xaaksa­ni̠­naní̠n. Antá chú natasay nalac­sa̠nán xta­tzán y la̠n nali̠­pu­huán caj xpa̠­la­cata xta­pa̠tí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Acxni̠ nalak­chá̠n a̠má quilh­ta­macú acxni̠ aquit nac­mim­paray xli̠­maktiy uú nac ca̠quilh­ta­macú, lhu̠hua cris­tianos chuná naca̠ak­spulay cumu la̠ tica̠ak­spú­lalh a̠ma̠ko̠lh kalha­cá̠hu lac­tzu­maján hua̠nti̠ tica̠­li̠­pu­tzá­calh xla­cata pi̠ nataán tamak­sko­tiyay a̠má kahuasa acxni̠ nachín porque xta­maka­xtokma. ");
INSERT INTO tocNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Kalha­qui­tzis lac­tzu­maján luu ni̠para tzinú xta­li̠­taaka­tzanke̠y xla­cata para natalé̠n hua̠ntu̠ nata­mac­la­cas­qui­na̠chá, pero xa̠maka­pi­tzí̠n kalha­qui­tzis xlacán luu ská­lalh xtaán. ");
INSERT INTO tocNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ama̠­ko̠lh lac­tzu­maján hua̠nti̠ ni̠tu̠cu xta­li̠­taaka­tzanke̠y para túcu, xlacán tále̠lh xli̠­mak­skocán pero caj xma̠nhuá tu̠ xta­ju̠ma gas, y ni̠tu̠ túnuj tále̠lh gas hua̠ntu̠ xta­ma­jú̠­nilh xli̠­mak­skocán acxni̠ clhcu­ni­ko̠lh hua̠ntu̠ xta­ju̠­nima. ");
INSERT INTO tocNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pero a̠ma̠ko̠lh maka­pi­tzí̠n hua̠nti̠ ská­lalh xtaán xlacán stap tama̠­tzá­malh xli̠­mak­skocán y túnuj lame̠ta xta­pu̠­le̠m­paray gas hua̠nchú tu̠ nata­ma­ju̠niy xli̠­mak­skocán acxni̠ nalh­cu­niko̠y hua̠ntu̠ xta­ju̠­nima. ");
INSERT INTO tocNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Pero cumu a̠má kahuasa hua̠nti̠ xta­maka­xtokma luu maka̠s la̠ta xmaka­pa­la­ma̠chá, a̠ma̠ko̠lh lac­tzu­maján punchú la̠ta talh­tá­talh. ");
INSERT INTO tocNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Pero ma̠x luu íta̠t tzi̠sa xuani̠t acxni̠ cha̠tum chixcú ma̠ca̠­ta­sí̠­nalh y chiné huá: “¡Catu̠x­ca̠­ní̠tit chú aya chima kahuasa hua̠nti̠ tamaka­xtokma, la̠li̠­huán catátit pa̠x­to­ká̠tit!” ");
INSERT INTO tocNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ama̠­ko̠lh kalha­cá̠hu lac­tzu­maján la̠li̠­huán tatá̠­qui̠lh y tzú­culh taca̠x­ma̠­pasi̠y xli̠­mak­skocán. ");
INSERT INTO tocNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Pero a̠ma̠ko̠lh kalha­qui­tzis lac­tzu­maján hua̠nti̠ ni̠tu̠ túnuj xtalé̠n xgascán xlacán tahuá­nilh xa̠maka­pi­tzí̠n hua̠nti̠ xta­pu̠lé̠n lame̠ta gas: “Cat­la­huátit li̠tlá̠n caqui­la̠­ta̠s­qui­huíhui aca­tzuní̠n migascán porque aya mix­putún qui­li̠­mak­skocán.” ");
INSERT INTO tocNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Y a̠ma̠ko̠lh kalha­qui­tzis lac­tzu­maján chiné tala̠­kálh­ti̠lh: “Para nac­ca̠­ta̠s­qui­huayá̠n aca­tzuní̠n ni̠ caquin­ti­ca̠accha̠nín porque acxni̠ chú nalh­cu­niko̠y niaj túcu catíhua; huata mejor caqui̠­ta­ma̠­hua­pítit anta­nícu sta̠cán la̠qui̠ ma̠n nata­ma̠­hua­yá̠tit hua̠ntu̠ naca̠accha̠­niyá̠n.” ");
INSERT INTO tocNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ama̠­ko̠lh kalha­qui­tzis lac­tzu­maján hua̠nti̠ ni̠tu̠ xtalé̠n gas la̠li̠­huán táalh tapu­tzay anta­nícu sta̠cán la̠qui̠ nata­ta­ma̠­huay, pero nia̠ xta­qui̠­tas­pita acxni̠ chilh a̠má kahuasa hua̠nti̠ xta­maka­xtokma; y xa̠maka­pi­tzí̠n kalha­qui­tzis lac­tzu­maján hua̠nti̠ cha̠­ca­tzi̠ya xtalé̠n gas xlacán li̠huana̠ taca̠x­ma̠­pá­si̠lh xli̠­mak­skocán y táalh tamak­sko­tiyay a̠má kahuasa y tata̠­tá­nu̠lh nac xpu̠­lacni chiqui anta­nícu xpa̠x­cuajna­má̠­calh, y aca­li̠stá̠n chú li̠huana̠ ma̠lac­chu­huá­calh. ");
INSERT INTO tocNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Caj li̠punchú tachilh xa̠maka­pi­tzí̠n lac­tzu­maján, xlacán tzú­culh tala­kat­laka má̠lacchi y chiné xta­huán: “Tle̠n, tlé̠n, cat­lahua li̠tlá̠n caqui­la̠­ma̠­la­qui̠­níhu.” ");
INSERT INTO tocNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pero a̠má kahuasa hua̠nti̠ xta­maka­xtokma chiné ca̠kálh­ti̠lh: “Aquit laca­tancs cca̠­hua­niyá̠n pi̠ ni̠lay cca̠­ma̠­la­qui̠­niyá̠n porque ni̠ cca̠­la­ka­pasá̠n.” ");
INSERT INTO tocNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Acxni̠ Jesús chuná ca̠li̠­ma̠­kalh­chu­hui̠­ni̠­ko̠lh eé takalh­chu­huí̠n xlá ca̠hua­nipá: —Xli̠­ca̠na cca̠­hua­niyá̠n xla­cata pi̠ luu ská­lalh cala­ta­pá̠tit, porque ni̠ catzi̠­yá̠tit túcuya̠ quilh­ta­macú y túcuya̠ hora acxni̠ aquit nac­mim­paray xli̠­maktiy. ");
INSERT INTO tocNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Amá xasa̠sti xta­péksi̠t Dios hua̠ntu̠ aquit cmini̠t ma̠la­ca­tzu­qui̠y luu xta̠­chuná qui̠­taxtuy cumu la̠ cha̠tum patrón acxni̠ xta­ca̠xma xla­cata naán paxia̠lhnán nac mákat a̠laca­túnuj ca̠chi­quí̠n. Acxni̠ aya xta­ca̠xma ca̠ta­sá­nilh xta­sa̠­cuá̠n y cha̠­tunu cha̠­tunu ca̠má̠x­qui̠lh xtumi̠n la̠qui̠ xlacán nata­ma̠s­cu­juniy y nata­ma̠s­kati̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Cha̠tum xta­sa̠cua má̠x­qui̠lh akqui­tzis mi̠lh, y cha̠­tum­li̠túm má̠x­qui̠lh aktiy mi̠lh, y tunu hua̠nti̠ má̠x­qui̠lh aktum mi̠lh; huá ca̠li̠­má̠x­qui̠lh la̠qui̠ xlacán nata­ma̠s­cujuy y nata­ma̠s­kati̠y a̠má tumi̠n, porque xlá aya xca̠­la­ka­pasa la̠ta xli̠s­ka­la­lacán cha̠­tunu cha̠­tunu. Acxni̠ chú chuná ca̠ta̠­la­ca̠x­la­ko̠lh a̠má patrón juerza alh paxia̠lhnán mákat cumu la̠ xli̠­lac­pu̠lh­ca̠­ni̠ttá. ");
INSERT INTO tocNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Amá tasa̠cua hua̠nti̠ ma̠x­quí̠­calh akqui­tzis mi̠lh xlá tzú­culh tama̠­huanán y tlá­hualh negocio, chuná chú ma̠t­lá­ji̠lh akqui­tzis mi̠lh caj la̠ta ma̠s­ká­ti̠lh a̠má tumi̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Na̠chuná a̠má tasa̠cua hua̠nti̠ mak­lhtí̠­nalh aktiy mi̠lh xlá na̠ ma̠s­cúju tumi̠n y li̠huacay aktiy mi̠lh caj la̠ta tu̠ ma̠s­ká­ti̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero huata a̠má hua̠nti̠ caj aktum mi̠lh mak­lhtí̠­nalh xlá ni̠ ma̠s­cú­julh a̠má tumi̠n, huata caj cá̠huaxli nac ca̠ti­yatni y antá má̠c­nu̠lh xtumi̠n xpatrón la̠qui̠ ni̠ natzanka̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Maka̠s kam­pá̠alh quilh­ta­macú, caj xamaktum chilh xpat­roncán a̠ma̠ko̠lh tasa̠­cuá̠n, xlá qui̠­tás­pitli la̠ta mákat qui̠­pa­xiá̠lhnalh y tuncán ca̠ta­sá­nilh a̠ma̠ko̠lh tasa̠­cuá̠n la̠qui̠ naca̠­ta̠t­la­huay cuenta la̠ta lácu xta­ma̠s­ka­ti̠ni̠t xtumi̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Pu̠lh huá chilh a̠má ti̠ xmak­lhti̠­nani̠t akqui­tzis mi̠lh y maca­má̠s­ta̠lh akqui­tzis mi̠lh hua̠ntu̠ ma̠s­ká­ti̠lh la̠ta xma̠s­cu­juma, y chiné huá­nilh xpatrón: “Patrón, huix quin­ti­ma̠xqui akqui­tzis mi̠lh, y chi̠nchú cumu aquit chuná cscujli la̠ta huix quin­ti­li̠­ma̠­peksi, pus huí chú a̠akqui­tzis mi̠lh hua̠ntu̠ aquit cma̠t­la­ji̠ni̠t min­tumi̠n.” ");
INSERT INTO tocNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Amá patrón huá­nilh: “Xli̠­cána luu cla­kati̠y min­ta­scújut. Cumu huix cuentaj tlahua ma̠squi ni̠ luu lhu̠hua hua̠ntu̠ cti­ma̠x­quí̠n pus huata chú nac­ma̠­cuentaj­li̠yá̠n hua̠ntu̠ tlak lhu̠hua la̠qui̠ namak­ta­kalha. Pero xa̠huachí la̠li̠­huán catanu la̠qui̠ luu lac­xtum napa̠­xu­hua­yá̠hu xpa̠­la­cata min­ta­scújut hua̠ntu̠ ma̠kan­tax­ti̠­ni̠ta.” ");
INSERT INTO tocNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Caj li̠punchú chilh a̠má tasa̠cua hua̠nti̠ xmak­lhti̠­nani̠t aktiy mi̠lh. Acxni̠ xlá chilh chiné huá­nilh xpatrón: “Patrón, huix quin­ti­ma̠­cuentajli aktiy mi̠lh min­tumi̠n, pero hui­lapá chú aktiy mi̠lh hua̠ntu̠ aquit cma̠s­ka­ti̠ni̠t min­tumi̠n caj la̠ta xac­ma̠s­cu­juma.” ");
INSERT INTO tocNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Amá patrón huá­nilh: “Xli̠­ca̠na pi̠ na̠ luu cla­kati̠y min­ta­scújut, huix luu tla̠n tasa̠cua, pus cumu huix luu cuentaj tlahua ma̠squi ni̠ luu lhu̠hua hua̠ntu̠ xac­ma̠x­qui̠­ni̠tán la̠nchú nac­ma̠x­qui̠yá̠n hua̠ntu̠ tlak lhu̠hua la̠qui̠ huix naqui­ma̠s­cu­ju­niya. Pero la̠li̠­huán catanu nac quín­chic y lac­xtum cali̠­pa̠­xu­huahu caj xpa̠­la­cata min­ta­scújut hua̠ntu̠ huix aya ma̠kan­tax­ti̠­ni̠ta.” ");
INSERT INTO tocNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Pero acxni̠ chú chilh a̠má tasa̠cua hua̠nti̠ xma̠­cuentaj­li̠­cani̠t aktum mi̠lh xla­cata na̠ nama̠s­cujuy xlá chiné huá­nilh xpatrón: “Patrón, aquit aya maka̠sá ccá­tzi̠lh pi̠ luu snún lani̠ta huix akchi­pa­hui­li̠ya y milá tla­huaya hua̠ntu̠ ni̠ huix li̠s­cuj­ni̠ta y ma̠squi para xac­ti­ma̠s­cú­julh min­tumi̠n xli̠­hua̠k hua̠ntu̠ xac­ti­ma̠s­ká­ti̠lh hua̠k huix xquin­ti­mak­lhti̠­ko̠ya. ");
INSERT INTO tocNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Pero na̠chuna li̠túm aquit clak­lhpé̠­cualh xla­cata para nac­ma­ka­tzanka̠y huata caj li̠huana̠ cmá̠­qui̠lh, antá cti­má̠c­nu̠lh nac xtampí̠n tíyat. Pero ni̠ cali̠­pú­huanti, huí min­tumi̠n hua̠ntu̠ huix quin­ti­ma̠xqui.” ");
INSERT INTO tocNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Amá patrón chiné kálh­ti̠lh: “Huata huix luu lanca laka­yá̠­canti ni̠tlá̠n min­ta­pu­huá̠n y luu xalh­quítit huix. Pus cumu para ca̠na̠ xca­tzi̠ya pi̠ aquit cak­chi­pa­huili̠y y quilá ctla­huay hua̠ntu̠ ni̠ aquit cli̠s­cujni̠t, ");
INSERT INTO tocNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿túcu chi̠nchú xpa̠­la­cata ni̠ pit li̠hui­li̠ya quin­tumi̠n nac banco la̠qui̠ acxni̠ aquit xac­tí­chilh antá xac­tíalh timak­lhti̠nán quin­tumi̠n porque antá juerza xquin­tiakxo­ko­ní­calh?” ");
INSERT INTO tocNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Pus a̠má patrón ca̠li̠­ma̠­pék­si̠lh hua̠nti̠ antá xta­la­yá̠­nalh: “Camak­lhtí̠tit eé chixcú a̠má tumi̠n hua̠ntu̠ xlá li̠mín aktum mi̠lh y huá cama̠x­quí̠tit hua̠nti̠ kalhi̠y akcá̠hu mi̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Porque hua̠nti̠ lhu̠hua kalhi̠y hua̠ntu̠ mac­la­cas­quín a̠tzinú nama̠x­qui̠cán la̠qui̠ naaka­ta̠x­tuniy, pero hua̠nti̠ ni̠tu̠cu kalhi̠y hua̠ntu̠ mac­la­cas­quín hasta namak­lhti̠­ko̠cán ma̠squi caj xma̠nhuá tu̠ xka­lhi̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Y chi̠nchú u̠má lhquítit tasa̠cua hua̠nti̠ ni̠tu̠cu li̠s­cuj­putún, la̠li̠­huán cata­mac­xtútit cquilhtí̠n anta­nícu luu ca̠pucsua la̠qui̠ antá naxo­ko̠nún caj xpa̠­la­cata cumu luu lanca laka­yá̠­calh, antá nalac­sa̠nán xta­tzán caj xpa̠­la­cata lanca tapa̠tí̠n hua̠ntu̠ namaklh­ca­tzi̠y.” ");
INSERT INTO tocNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Amá quilh­ta­macú acxni̠ aquit Xata­lac­sacni Chixcú nac­mim­paray xli̠­maktiy nac ca̠quilh­ta­macú, aquit nac­ta­huilay nac quim­pu̠­ma̠­peksí̠n cumu la̠ lanca rey y xa̠huachí xli̠­hua̠k ángeles nac­ca̠­ta̠mín. ");
INSERT INTO tocNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Xli̠­hua̠k cris­tianos xala ca̠quilh­ta­macú naquin­ta­li̠­ta­mac­xtumi̠y la̠tachá nícu xalaní̠n; huata aquit nac­tzucuy ca̠ma̠­paj­pi­tziy cumu la̠ pastor acxni̠ ca̠ma̠­paj­pi­tziy xta­ka­lhí̠n, tunuj ca̠ya̠­huay bor­regos y laca­tunu chivos sa­má̠­nalh xla­cata nata­ma̠­kan­taxti̠y, pus antá nac­ca̠­huili̠y nac quim­pek. ");
INSERT INTO tocNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ama̠­ko̠lh cris­tianos hua̠nti̠ xta­kax­mata quin­ta­chu­huí̠n y xta­lak­tzak­stácat, y a̠ma̠ko̠lh xa̠maka­pi­tzí̠n hua̠nti̠ caj chu­natá takax­mat­mákan quin­ta­chu­huí̠n y ni̠ talak­tzák­salh, pus antá nac­ca̠­huili̠y nac quim­pek­xuqui. ");
INSERT INTO tocNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Entonces aquit nac­ca̠­huaniy hua̠nti̠ tahui­lá̠­nalh nahuán nac quim­pek­stácat: “¡Luu xli̠­ca̠na capa̠­xu­huátit hui­xinín hua̠nti̠ ca̠lac­sac­ni̠tán Quin­tla̠t! La̠li̠­huán cata­hui­látit nac a̠má mim­pu̠­ta­hui̠lhcán hua̠ntu̠ xlá ca̠li̠­ka­lhi̠má̠n hasta la̠ta tima̠­la­ca­tzú­qui̠lh ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Porque acxni̠ aquit xac­tzin­c­sni̠ma hui­xinín quin­ti­la̠­ma̠­huí̠hu, acxni̠ aquit xac­kalh­pu̠­ti̠x­ni̠ma hui­xinín quin­ti­la̠­ma̠­kot­ní̠hu, xac­la­pu̠lay nac min­ca̠­chi­qui̠ncán ni̠tu̠ xac­ka­lhi̠y quín­chic hui­xinín qui­la̠­ma̠­la­qui̠­níhu cmin­chiccán xla­cata antá nac­lak­tun­cu­hui̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Acxni̠ xac­lama ni̠tu̠ xuani̠t qui­lháka̠t hui­xinín quin­ti­la̠­ta̠s­quihu hua̠ntu̠ nac­lhaka̠y, acxni xac­ta̠­tatlay y acxni̠ xac­ta­núma nac pu̠la̠­chi̠n hui­xinín quin­ti­la̠­qui̠­la­ka­ta̠­yáhu.” ");
INSERT INTO tocNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ama̠­ko̠lh hua̠nti̠ Dios naca̠­lak­ma̠xtuy nata­ka­lhas­qui­ni̠nán: “Pero ¿ní̠n­co̠cxni cti­ca̠ucxilhni para xtzin­c­sní̠pa̠t y aquinín cti­ca̠­ta̠­hua̠yán? Osuchí ¿ní̠n­co̠cxni xkalh­pu̠­ti̠x­ní̠pa̠t y aquinín cti­ca̠­ma̠­kotní̠n? ");
INSERT INTO tocNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Osuchi ¿ní̠n­co̠cxni xla­pu̠­laya nac quin­ca̠­chi­qui̠ncán para ni̠ní xlak­tun­cu­huíya y aquinín cti­ca̠­ta̠­lak­tun­cu­huí̠n nac quin­chiccán, osu para ni̠tu̠ xuani̠t milháka̠t y aquinín cti­ca̠­ma̠x­quí̠n? ");
INSERT INTO tocNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Osuchí ¿nícu makli̠t para xta̠­tat­laya o xta­nú̠pa̠t nac pu̠la̠­chi̠n y aquinín chú cti­ca̠­qui̠­lak­la­chá̠n?” ");
INSERT INTO tocNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Huata aquit chiné nac­ca̠­kalhti̠y: “Xli̠­ca̠na aquit cca̠­hua­niyá̠n pi̠ la̠tachá túcuya̠ li̠tlá̠n hui­xinín ca̠t­la­hua­nítit y hua̠ntu̠ xta­mac­la­cas­quix­ni̠­má̠­nalh u̠ma̠ko̠lh cris­tianos hua̠nti̠ aquit cca̠­li̠­macá̠n qui­na­ta̠lán ma̠squi luu ni̠para tzinú lac­li̠­ca̠na tata­siyuy, pus chuná qui̠­tax­tuni̠t cumu la̠m­para aquit qui­la̠­li̠s­cuj­ni̠­táhu.” ");
INSERT INTO tocNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Aca­li̠stá̠n chú aquit nac­ca̠­lak­ta­la­kas­pita a̠ma̠ko̠lh cris­tianos hua̠nti̠ ni̠ xquin­ta­li̠­pa̠­huán hua̠nti̠ tayá̠­nalh nahuán nac quim­pek­xuqui y chiné nac­ca̠­huaniy: “Cat­la­huátit li̠tlá̠n, caqui­la̠­ta­pa̠­nu̠­níhu y ni̠ caqui­la̠­ma̠­la­ca­tzu­huí̠hu. Hui­xinín aya lak­tzan­ka̠­ni̠­tátit caj xpa̠­la­cata hua̠ntu̠ ni̠tlá̠n tla­hua­ni̠­tátit. Huata mejor capim­pítit nac pu̠pa̠tí̠n anta­nícu hui­xinín ca̠lak­cha̠­ni̠tán nac ca̠lh­cu­ya̠tni hua̠ntu̠ tica̠x­tla­hua­ní­calh akska­huiní chu xli̠­hua̠k hua̠nti̠ xta­ta̠s­cuj­má̠­nalh la̠qui̠ antá nata­pa̠­ti̠nán xlianka­lhí̠n quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Porque acxni̠ aquit xac­tzin­c­sta­makama, hui­xinín ni̠ qui­la̠­ma̠­huí̠hu, acxni̠ xac­kalh­pu̠­ti̠x­ni̠ma hui­xinín ni̠ qui­la̠­ma̠­kot­ní̠hu. ");
INSERT INTO tocNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Acxni̠ xac­la­pu̠lay y ni̠ní xac­lak­tun­cu­huíy hui­xinín ni̠para tzinú xlac­pu­huántit para naqui­la̠­ta̠­lak­tun­cu­hui̠­yá̠hu nac min­chiccán. Acxni̠ lak­sput­ko̠lh qui­lháka̠t hua̠ntu̠ xac­lha­ka̠ni̠t hui­xinín ni̠tu̠ qui­la̠­ma̠x­quí̠hu hua̠ntu̠ nac­lhaka̠y; acxni̠ cta­ma̠chá nac ca̠ta­játat o quin­ti­ta­mac­nú̠­calh nac pu̠la̠­chi̠n hui­xinín ni̠para xlac­pu­huántit para naqui­la̠­la­ka­ta̠­ya­yá̠hu.” ");
INSERT INTO tocNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Huata a̠ma̠ko̠lh cris­tianos naquin­ta­ka­lhas­quín: “Quim­pu̠­chi­nacán, pero aquinín ni̠para maktum xac­ca̠ucxilhni para xtzin­c­sní̠pa̠t y ni̠ cca̠­ta̠­hua̠yán, o para xkalh­pu̠­ti̠x­ní̠pa̠t y ni̠ cca̠­ta̠­hua̠yán, para xla­pu̠­laya ni̠ní xlak­tun­cu­huiya, o para xtzan­ka̠­niyá̠n milháka̠t, chuná para xta̠­tat­laya o xta­nú̠pa̠t nac pu̠la̠­chi̠n y aquinín ni̠tu̠ cca̠ucxilh­ni̠­tan­chá̠n.” ");
INSERT INTO tocNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Pero aquit chiné nac­ca̠­kalhti̠y: “Aquit laca­tancs cca̠­hua­niyá̠n pi̠ la̠ta maka­tunu ni̠ ca̠mak­ta̠­yátit a̠ma̠ko̠lh ni̠ lac­ta­li̠­pa̠hu cris­tianos cumu ni̠ lac­li̠­ca̠na tata­siyuy acxni̠ xlacán catu̠huá xca̠­tzan­ka̠­nima, pus luu chuná cli̠­ma̠xtuy pi̠ aquit qui­la̠­lak­ma­ka­ni̠­táhu y ni̠ qui­la̠­mak­ta̠­yáhu.” ");
INSERT INTO tocNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Hua­tuní̠n u̠ma̠ko̠lh cris­tianos hua̠nti̠ lac­li̠xcáj­nit xta­pu­hua̠ncán xuani̠t, antá naca̠­ma­ca̠ncán nac pu̠pa̠ti̠n anta­nícu taxo­ko̠­nu­má̠­nalh nahuán cane̠c­xni­cahuá quilh­ta­macú; y chi̠nchú a̠ma̠ko̠lh hua̠nti̠ Dios ca̠lac­sacni̠t antá nata­chá̠n nac akapú̠n anta­nícu tapa̠­xu­hua­má̠­nalh nahuán cane̠c­xni­cahuá quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Acxni̠ chuná ca̠li̠­ma̠­kalh­chu­hui̠­ni̠­ko̠lh eé tachu­huí̠n Jesús chiné ca̠huá­nilh xdis­cí­pulos: ");
INSERT INTO tocNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Hui­xinín catzi̠­yá̠tit pi̠ hua­tiyá la̠ tu̠xama natzucuy xpa̠x­cuajcán judíos xla taak­spun­tza̠lí̠n, na̠ acxni­tiyá a̠má quilh­ta­macú naquin­chi­pacán y naqui­ma­ca­ma̠s­ta̠cán nac xla­ca­ti̠ncán hua̠nti̠ quin­ta­si̠­tzi̠niy la̠qui̠ naquim­pe­kex­to­ko­hua­cacán nac cruz. ");
INSERT INTO tocNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Luu xli̠­ca̠na hua̠ntu̠ Jesús xli̠­chu­hui̠­nama porque na̠ hua­tiyá a̠má quilh­ta­macú xta­ta­mac­xtu­mi̠ni̠t xana­puxcun cura xa̠hua lak­ko̠­lu­tzi̠nni hua̠nti̠ xta­ma̠­pek­si̠nán nac xlak­sti̠­pa̠ncán judíos, antá xta­ta­mac­xtu­mi̠ni̠t nac xchic Caifás porque xlá xapuxcu cura hua̠nti̠ xca̠­ma̠­peksi̠y hua̠k xa̠maka­pi­tzí̠n xta̠­cu­rajni. ");
INSERT INTO tocNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Xlacán tali̠­lac­chu­huí̠­nalh pi̠ ma̠squi caj taaksaní̠n nata­ma̠x­tuniy Jesús la̠qui̠ tla̠n nachi­pacán y namak­ni̠cán. ");
INSERT INTO tocNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pero huata sac­stucán xta­la̠­hua­ni­paray: —Huata mejor ni̠ chi­pa­ma̠­náhu acxni̠ luu xquilh­ta­macú pa̠xcua porque nata­si̠­tzi̠y hua̠nti̠ tali̠­pa̠­huán. ");
INSERT INTO tocNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús antá xláhui nac xchic Simón nac Betania, huá eé chixcú hua̠nti̠ tat­la̠n­ti̠ni̠t acxni̠ xka­lhi̠y aktum li̠xcáj­nit tzitzi hua̠ntu̠ hua­nicán lepra. ");
INSERT INTO tocNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Luu acxni̠ Jesús xua̠yama chilh cha̠tum pusca̠t xlá lak­ta­la­ca­tzú­hui̠lh nac mesa anta­nícu maca­huácaj xuí; a̠má pusca̠t xli̠­mini̠t pa̠tum lame̠ta xatlá̠n per­fume hua̠ntu̠ luu xata­pa­ra̠xlá. Acxni̠ chú lák­cha̠lh acma̠­huá­calh nac xak­xa̠ka Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Acxni̠ a̠ma̠ko̠lh dis­cí­pulos taúcxilhli xlacán tzú­culh tasi̠­tzi̠y y chiné tala̠­huá­nilh: —¿Túcu xpa̠­la­cata caj luu chu­natá li̠lac­tla­hua­mi̠­cani̠t eé xata­pa­ra̠xlá per­fume? ");
INSERT INTO tocNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Huata mejor tla̠n caj luu lhu̠hua tumi̠n xti­li̠s­tá̠­calh, y hua̠ntu̠ xti­tás­tokli xatumi̠n xti­ca̠­li̠­mak­ta̠­yá­calh lak­li̠­ma̠x­kení̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Cumu Jesús ca̠ka­lha­káx­matli hua̠ntu̠ xlacán xta­qui­lhuamá̠­nalh xlá chiné ca̠huá­nilh: —¿Túcu xpa̠­la­cata li̠la­ca­si̠­tzi̠­ni­pá̠tit u̠má koxutá pusca̠t? Ni̠ cala­ca­si̠­tzi̠­nítit, porque hua̠ntu̠ xlá tla­huani̠t xli̠­ca̠na pi̠ luu tla̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Huá chuná cca̠­li̠­hua­nimá̠n porque a̠ma̠ko̠lh cris­tianos hua̠nti̠ lak­li̠­ma̠x­kení̠n anka­lhi̠ná tala­má̠­nalh nahuán nac milak­sti̠­pa̠ncán, pero aquit ni̠ anka­lhí̠n cca̠­ta̠­lamá̠n nac milak­sti̠­pa̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Xla­cata pi̠ eé pusca̠t quiacma̠­hua­cani̠t per­fume nac quiakxa̠ka xli̠­ca̠na luu tlán, porque chuná a̠li̠sok qui­ma̠­mu̠c­si̠­nini̠t qui­macni la̠qui̠ chu­na­tiyá aya cca̠xui nahuán xla­cata acxni̠ naqui­ma̠c­nu̠cán nac quin­ta­huaxni. ");
INSERT INTO tocNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Aquit laca­tancs cca̠­hua­niyá̠n pi̠ xli̠­ca̠­lanca ca̠quilh­ta­macú la̠tachá nícu naqui­li̠­chu­hui̠­nancán y la̠ta lácu cmini̠t ca̠lak­ma̠xtuy cris­tianos, na̠ chuná nali̠­chu­hui̠­nancán hua̠ntu̠ xlá quin­tla­hua­nini̠t eé pusca̠t acxni̠ qui­li̠t­lá­hualh per­fume y chuná xlianka­lhí̠n nali̠­la­ca­pa̠s­taccán. ");
INSERT INTO tocNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","La̠ta kalha­cu̠tiy xca̠­lac­sacni̠t xdis­cí­pulos Jesús, cha̠tum tax­tuchá hua̠nti̠ xuanicán Judas Isca­riote, xlá ca̠qui̠­lák­lalh xana­puxcún cura ");
INSERT INTO tocNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","y chiné ca̠huá­nilh: —Para aquit nac­ca̠­ma­ca­ma̠x­qui̠yá̠n Jesús, ¿nícu chulá naqui­la̠­ma̠s­ka­hui̠­yá̠hu? Xlacán tamá̠x­qui̠lh puxa­ma­cá̠hu tumi̠n la̠ta xaokxu­tunu hua̠k xla plata, ");
INSERT INTO tocNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","pus hasta acxni­tiyá a̠má quilh­ta­macú Judas tzú­culh lac­pu­tzay lácu nat­la­huay y túcuya̠ quilh­ta­macú tla̠n nama­ca­ma̠sta̠y Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Amá quilh­ta­macú xapa̠xcua taak­spun­tza̠lí̠n luu acxni̠ xli̠­hua̠k judíos xta­la­ka­chix­cu­hui̠nán y xta­huay cax­ti­lá̠n­chahu hua̠ntu̠ ni̠tu̠ kalhi̠y leva­dura, a̠ma̠ko̠lh dis­cí­pulos talak­ta­la­ca­tzú­hui̠lh Jesús y chiné tahuá­nilh: —¿Nícu laca­squina naca­ná̠hu ca̠x­tla­hua­yá̠hu quin­ta­huajcán hua̠ntu̠ nali̠­la­ka­chix­cu­hui̠­na­ná̠hu u̠má ko̠ta­nu̠ma xapa̠xcua taak­spun­tza̠lí̠n? ");
INSERT INTO tocNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesús ca̠kálh­ti̠lh: —Capim­pítit nac ca̠chi­quí̠n antá nachi­pi­ná̠tit nac xchic cha̠tum chixcú hua̠nti̠ aquit aya cta̠­la­ca̠x­lani̠t y chiné nahua­ni­yá̠tit: “Huán qui­ma̠­kalh­ta­hua­ke̠­nacán: Chú aya tala­ca­tzu­hui̠ma quilh­ta­macú la̠ta nac­ma̠s­putuy quin­ta­scújut, huá xpa̠­la­cata cca̠­li̠­ta̠ama̠chá quin­ta­ma̠­kalh­ta­huaké̠n la̠qui̠ antá nac mín­chic nac­ca̠­ta̠­hua̠yán a̠má tahuá hua̠ntu̠ li̠la­ka­chix­cu­hui̠­nancán nac xapa̠xcua taak­spun­tza̠lí̠n.” ");
INSERT INTO tocNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ama̠­ko̠lh dis­cí­pulos chuná tat­lá­hualh cumu la̠ Jesús xca̠­li̠­ma̠­pek­si̠ni̠t y antá taca̠x­tla­huachá xta­huajcán xala ca̠ko̠­tanú̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Acxni̠ chú luu li̠huana̠ tzi̠­suanko̠lh, Jesús aya xca̠­ta̠­cha̠ni̠t y antá chú quilh­pu̠xtum xca̠­ta̠hui kalha­cu̠tiy xdis­cí­pulos nac mesa. ");
INSERT INTO tocNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Y li̠huán xca̠­ta̠­hua̠­yama chiné ca̠huá­nilh: —Aquit laca­tancs cca̠­hua­niyá̠n pi̠ la̠ta mili̠­ka­lha­cu̠­tiycán caj xma̠n cha̠tum natax­tu­ya̠chá hua̠nti̠ naqui­ma­ca­ma̠sta̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ama̠­ko̠lh dis­cí­pulos luu snu̠n tali̠­púhua y cha̠­tunu tzú­culh taka­lhas­quín: —Quim­pu̠­chi­nacán, ¿para aquit camá̠n maca­ma̠s­ta̠yá̠n? ");
INSERT INTO tocNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Huata Jesús ca̠kálh­ti̠lh: —Huá ámaj qui­ma­ca­ma̠sta̠y hua̠nti̠ la̠nchú lac­xtum quin­ta̠­hua̠­yama nac quim­pu­la̠tu. ");
INSERT INTO tocNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Cumu aquit Xata­lac­sacni Chixcú juerza nac­ma̠­kan­taxti̠y hua̠ntu̠ tatzok­ta­hui­lani̠t nac li̠kalh­ta­huaka caj quim­pa̠­la­cata; pero ¡pa̠x­ca­tacu tihuán a̠má chixcú hua̠nti̠ ámaj qui­ma­ca­ma̠sta̠y! Huata luu xatlá̠n xtíhua pi̠ ni̠ xti­la­cá­chilh tuncán nac ca̠quilh­ta­macú hua̠nti̠ chuná ámaj quin­tla­huay. ");
INSERT INTO tocNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Y hua̠nchú Judas hua̠nti̠ xliak­ska­hui­nima Jesús chiné kalhás­quilh: —Ma̠kalh­ta­hua­ke̠ná, ¿ma̠x aquit camá̠n maca­ma̠s­ta̠yá̠n? Jesús kálh­ti̠lh: —Pus luu laca­tancs cuaniyá̠n pi̠ xli̠­ca̠na huix tamá chixcú hua̠nti̠ naqui­ma­ca­ma̠sta̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Acxni̠ chú luu xta­hua̠­ya­má̠­nalh, Jesús tíyalh mactum cax­ti­lá̠n­chahu, pa̠x­cat­ca­tzí̠­nilh Dios, lak­ché­kelh y ca̠má̠x­qui̠lh xdis­cí­pulos y chiné ca̠huá­nilh: —Mac­xtum cahuátit eé cax­ti­lá̠n­chahu porque xli̠­ca̠na pi̠ huá qui­li̠hua. ");
INSERT INTO tocNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Aca­li̠stá̠n tiyapá pa̠tum vaso, pa̠x­cat­ca­tzí̠­nilh Dios, na̠chuná ca̠má̠x­qui̠lh y chiné ca̠huá­nilh: —Mim­pu̠­tumcán na̠ cahuátit hua̠ntu̠ taju̠ma nac eé vaso. ");
INSERT INTO tocNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Porque aquit laca­tancs cca̠­hua­niyá̠n pi̠ huá eé quin­kalhni hua̠ntu̠ nama̠­lu­loka xla­cata pi̠ Dios ca̠ta̠t­la­huani̠t cris­tianos aktum xasa̠sti tala­ca̠xlán la̠ta lácu naca̠­lak­ma̠xtuy, y ma̠squi nas­taj­ta­makán la̠qui̠ lhu̠hua hua̠nti̠ naca̠­li̠­ma­cuaniy porque chuná tla̠n naca̠­li̠­ma̠­tzan­ke̠­na­nicán xta­la̠­ka­lhi̠ncán cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Xa̠huachí aquit laca­tancs cca̠­hua­niyá̠n pi̠ niaj para maktum cac­ti­li̠­kót­nulh xchú­chut uva, hasta acxni̠ nalak­chá̠n quilh­ta­macú acxni̠ antá nac xpu̠­ma̠­peksí̠n Quin­tla̠t aquit pu̠tum nac­ca̠­ta̠­li̠­kot­nu­na̠­chá̠n tunu xasa̠sti xchú­chut uva ni̠ xta̠­chuná cumu la̠ eé. ");
INSERT INTO tocNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Aca­li̠stá̠n chú acxni̠ xlacán tali̠­quilh­tli̠­ko̠lh aktum salmo táalh nac aktum ke̠stí̠n hua̠ntu̠ hua­nicán Monte de los Olivos. ");
INSERT INTO tocNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Antá Jesús chiné ca̠huá­nilh: —Umá tzi̠sní hui­xinín pim­pá̠tit qui­la̠­li̠­lac­la­ta̠­ya­yá̠hu y nata̠­ka­hua­ni̠­ko̠­yá̠tit, porque chú amaj kan­taxtuy hua̠ntu̠ tatzok­ta­hui­lani̠t nac xta­chu­huí̠n Dios anta­nícu chiné huán: “Aquit nac­ma̠sta̠y quilh­ta­macú xla­cata pi̠ camak­ní̠­calh xmak­ta­kalhná bor­regos y xli̠­hua̠k xbor­regos nataaka­hua­ni̠ko̠y.” ");
INSERT INTO tocNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero acxni̠ aquit nac­la­cas­ta­cuanán nac ca̠li̠ní̠n huata pu̠lh aquit nac­ca̠­pu̠­la­niyá̠n xla­cata pi̠ nacán nac Gali­lea la̠qui̠ antá nata­nok­lha̠­chá̠hu. ");
INSERT INTO tocNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedro chiné huá­nilh: —Ma̠squi xli̠­hua̠k u̠ma̠ko̠lh cata­tza̠­la­makán, aquit ni̠ cac­tiak­xtek­makán huata chu­nacú nac­li̠­pa̠­huaná̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús kálh­ti̠lh: —Pedro, ni̠para tzinú catzi̠ya hua̠ntu̠ huix qui­lhuámpa̠t, porque aquit laca­tancs cuaniyá̠n pi̠ hua­tiyá eé tzi̠sní acxni̠ nia̠ tasay nahuán pu̠yu, huix aya hua­ni̠­tatá nahuán xli̠­mak­tutu xla­cata pi̠ ni̠ qui­la­ka­pasa. ");
INSERT INTO tocNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro hua­nipá: —Ma̠squi hasta xqui­li̠­mak­ní̠­calh caj la̠ta mim­pa̠­la­cata pero ni̠ cha̠lí cuán para ni̠ cla­ka­pasá̠n. Xli̠­hua̠k xa̠maka­pi­tzí̠n dis­cí­pulos hua̠k chuná tahuá­nilh pi̠ ni̠ cati­ta­tzá̠­lalh. ");
INSERT INTO tocNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Aca­li̠stá̠n Jesús ca̠tá̠alh xdis­cí­pulos anta nícu tzinú tlak laka­mákat lacatum anta­nícu xuanicán Get­se­maní. Acxni̠ antá xta­hui­la̠­nanchá chiné ca̠huá­nilh: —Uú cata­hui­látit, caqui­la̠­ka­lhí̠hu, porque aquit camaj kalh­ta­hua­kaniy Quin­tla̠­ticán Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Xma̠nhuá ca̠tá̠alh Pedro chu a̠ma̠ko̠lh cha̠tiy xla­ka­huasán Zebedeo, San­tiago y Juan. Caj xamaktum tzú­culh maklh­ca­tzi̠y tali̠­pu­huá̠n y juerza xla­ka­pú­tzama xlak­lhpe̠­cuán caj xpa̠­la­cata hua̠ntu̠ xamaj akspulay. ");
INSERT INTO tocNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Huata chiné ca̠huá­nilh xdis­cí­pulos: —Niajlay cpa̠ti̠y eé tali̠­pu­huá̠n nac quin­cuxmú̠n, luu li̠pe̠cua la̠ta pa̠ti̠ma qui­nacú; la̠m­para aya cni̠ma cmaklh­ca­tzi̠y. Huata uú hui­xinín cata­mak­xtéktit y ni̠ calh­ta­tátit. ");
INSERT INTO tocNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jesús alh tzinú laka­mákat, antá tatzo­kós­talh lí̠cha̠lh xlacán hasta nac ca̠ti­yatni y chiné kalh­ta­hua­ká­nilh Dios: —Papá Dios, para huix chuná laca­squina, cat­lahua li̠tlá̠n ni̠ xqui­lák­cha̠lh a̠má lanca tapa̠tí̠n hua̠ntu̠ ámaj quiok­spulay. Pero ni̠huá calalh hua̠ntu̠ caj aquit quin­ta­pa̠­xu­huá̠n, huata mejor huá cakan­táx­tulh min­ta­pu­huá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Aca­li̠stá̠n chú tás­pitli anta­nícu xta­hui­lá̠­nalh xdis­cí­pulos, pero acxni̠ xlá ca̠lák­cha̠lh xlacán xtalh­ta­ta­má̠­nalh. Entonces huá­nilh Pedro: —¡Pedro! ¿Lácu pi̠ luu lhta­ta­pu­tux­ni̠­yá̠tit? ¿Hasta ni̠lay laca­ta̠­ya­nítit talh­tata ca̠na̠caj aktum hora? ");
INSERT INTO tocNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ni̠ calh­ta­tátit, la̠li̠­huán cala­ca­hua̠­nántit xa̠huachí cakalh­ta­hua­ka­nítit Dios la̠qui̠ ni̠ naca̠­maka­tla­jayá̠n akska­huiní. Porque ma̠squi tli­hueke kalhi̠­yá̠tit min­ta­la­ca­pa̠s­tacni, huá mimac­nicán xli̠­ca̠na pi̠ ni̠ kalhi̠y li̠ca­mama. ");
INSERT INTO tocNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Xli̠­maktiy ampá kalh­ta­hua­kaniy Dios, y chiné hua­nipá: —Papá Dios, para ni̠lay lac­pu­huana xla­cata pi̠ ni̠ xac­pá̠­ti̠lh xli̠­hua̠k amá tapa̠tí̠n hua̠ntu̠ ámaj quiok­spulay, pus caj xma̠nhuá cakan­táx­tulh min­ta­pa̠­xu­huá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Acxni̠ qui̠­tas­pitpá, pi̠ chu­na­li̠túm xalh­tatán ca̠ma̠­nok­lhupá xdis­cí­pulos porque niajlay xta­la­ca­ta̠­yaniy xla­kas­ta­pucán caj xpa̠­la­cata talh­tata. ");
INSERT INTO tocNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Antá xlá ca̠ak­xte­kuili̠pá y ampá kalh­ta­hua­kaniy Dios xli̠­mak­tutu, pi̠ chuná hua­nipá cumu la̠ xuanini̠t xapu̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Acxni̠ chú ca̠lak­chimpá anta­nícu xlacán xta­hui­lá̠­nalh chiné ca̠huá­nilh: —¿Lácu pi̠ chu­nacú hui­xinín tilh­ta­ta­pá̠tit y jax­pá̠tit? Pus chú la̠nchú aya lak­cha̠ni̠t hora la̠ta acxni̠ aquit Xata­lac­sacni Chixcú naqui­ma­ca­ma̠s­ta̠cán nac xla­ca­ti̠ncán hua̠nti̠ luu mak­la̠­ka­lhi̠­naní̠n lac­chix­cu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","La̠li̠­huán cata̠­quí̠tit y ca̠huá porque chú aya tala­ca­tzu­hui̠ma hua̠nti̠ qui­liak­ska­hui­nima. ");
INSERT INTO tocNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Chu­nacú xchu­hui̠­nama Jesús acxni̠ Judas Isca­riote hua̠nti̠ na̠ xdis­cí­pulo xuani̠t, pu̠tum ca̠tá̠­chilh lhu̠hua lac­chix­cu­huí̠n xlacán xta­li̠mín xma̠­chi̠­tajcán chu quihui, u̠ma̠ko̠lh lac­chix­cu­huí̠n huá xta­ma̠­la­ka­cha̠ni̠t xana­puxcún cura xa̠hua lak­ko̠­lu­tzi̠nni Judíos hua̠nti̠ xta­ma̠­pek­si̠nán. ");
INSERT INTO tocNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas xca̠­hua­nini̠t xla­cata pi̠ xma̠­kalh­ta­hua­ke̠ná hua̠nti̠ xamaj maca­ma̠sta̠y pu̠lh nala­ca­tzu̠ca la̠qui̠ chuná nata­la­ka­pasa y nachi­pacán. ");
INSERT INTO tocNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Pus acxni̠ li̠huana̠ lak­ta­la­ca­tzú­hui̠lh anta­nícu xyá Jesús chiné huá­nilh: —¡Tlé̠n, ma̠kalh­ta­hua­ke̠ná, hasta a̠cu clak­chimá̠n! Acxni̠ chuná hua­ni­ko̠lh lacá­tzu̠cli. ");
INSERT INTO tocNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús kálh­ti̠lh: —Amigo, hua̠ntu̠ huix tani̠ta ma̠kan­tax­ti̠ya, pus la̠li̠­huán cat­lahua. Huata xa̠maka­pi­tzí̠n la̠li̠­huán talak­ta­la­ca­tzú­hui̠lh, huakaj tachí­palh Jesús y tachi̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Y cha̠tum xdis­cí­pulo Jesús xtat tlá­hualh xma̠­chi̠ta y ca̠c­tí̠­nilh xtaké̠n cha̠tum xta­sa̠cua xapuxcu cura. ");
INSERT INTO tocNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Pero Jesús chiné huá­nilh: —Cará kahuasa, cata­mac­nu̠­para mima̠­chi̠ta nac xpu̠­tanú̠n, porque xli̠­hua̠k hua̠nti̠ ma̠chi̠ta li̠mak­ni̠nán, na̠ huá ma̠chi̠ta nali̠­mak­ni̠cán. ");
INSERT INTO tocNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Lácu pi̠ ni̠ catzi̠ya huix xla­cata pi̠ para aquit xac­li̠s­quí­nilh Quin­tla̠t pi̠ xqui­ma­ca­mí­nilh lhu̠hua ángeles xla­cata naquin­ta­mak­ta̠yay, xlá la̠n­chuj­tuncán xtlá­hualh? ");
INSERT INTO tocNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero para chuná aquit xac­tlá­hualh ni̠ xkan­táx­tulh hua̠ntu̠ tatzok­ta­hui­lani̠t xta­chu­huí̠n Dios antaní huán xla­cata pi̠ juerza chuná xli̠­kan­táxtut hua̠ntu̠ aquit naquiok­spulay. ");
INSERT INTO tocNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Acxni̠ chuná ca̠hua­ni­ko̠lh, Jesús ca̠huá­nilh a̠ma̠ko̠lh lac­chix­cu­huí̠n: —¿Lácu pi̠ qui­la̠­li̠­ma­ca̠­ná̠hu cumu la̠ cha̠tum li̠pe̠­cuánit mak­ni̠na chixcú? ¿Túcu chi̠nchú li̠la­yá̠tit li̠ta­ná̠tit ma̠chi̠ta chu quihui? Aquit anka­lhi̠ná y cha̠li cha̠lí xac­ca̠­ma̠­kalh­chu­hui̠­ni̠ma cris­tianos nac milak­sti̠­pa̠ncán antá nac lanca xpu̠­si­culan Dios, pero ni̠para maktum xuántit para naqui­la̠­chi­pa­yá̠hu. ");
INSERT INTO tocNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero huá chuná li̠t­la­hua­pá̠tit xla­cata pi̠ ma̠kan­tax­ti̠­pá̠tit hua̠ntu̠ tita­li̠­chu­huí̠­nalh xalak­maká̠n pro­fetas acxni̠ chiné tátzokli nac li̠kalh­ta­huaka. Acxni̠ xlá chuná xca̠­hua­nima, a̠ma̠ko̠lh xdis­cí­pulos tatza̠­la­má­kalh Jesús y ca̠ta caj sacstu taak­xtek­yá̠­hualh xma̠­kalh­ta­hua­ke̠­nacán. ");
INSERT INTO tocNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ama̠­ko̠lh lac­chix­cu­huí̠n hua̠nti̠ tachí̠­le̠lh Jesús anta­ti̠túm talí̠­cha̠lh nac xchic Caifás cumu huá xapuxcu cura xuani̠t y xa̠huachí porque hua̠k antá xta­ta­mac­xtu­mi̠ni̠t xma̠­kalh­ta­hua­ke̠­nacán judíos xa̠hua lak­ko̠­lu­tzi̠nni. ");
INSERT INTO tocNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","La̠ta tun­tiji Pedro tze̠k csta̠­la­ni­ti̠­lhani̠t hasta li̠chá̠n­calh nac xchic Caifás. Xlá tánu̠lh y antá culucs táhui ní xta­hui­lá̠­nalh poli­cías la̠qui̠ hua̠k naucxilha hua̠ntu̠ nat­la­hua­nicán xma̠­kalh­ta­hua­ke̠­nacán. ");
INSERT INTO tocNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ama̠­ko̠lh lac­chix­cu­huí̠n hua̠nti̠ xta­ta­mac­xtu­mi̠ni̠t xana­puxcun cura xa̠hua lac­ta­li̠­pa̠hu lac­chix­cu­huí̠n hua̠nti̠ xca̠­li̠­ma̠­pa̠­cu­hui̠cán La Junta Sup­rema, xlacán xta­lac­pu­tza­má̠­nalh la̠ta túcu nata­li̠­ya̠­huay Jesús la̠qui̠ chuná tla̠n namak­ni̠cán. ");
INSERT INTO tocNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero ma̠squi lhu̠hua hua̠ntu̠ xta­li̠­ya̠­hua­má̠­nalh ni̠tu̠cu lay xta­ma̠­lu­lokniy, xa̠huachí lhu̠hua hua̠nti̠ tata­lác­nu̠lh xla­cata nata­ma̠x­tuniy taaksaní̠n, ma̠squi luu chuná tat­lá­hualh ni̠tu̠ tama̠t­lá̠n­ti̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Pero aca­li̠stá̠n tachilh cha̠tiy lac­chix­cu­huí̠n hua̠nti̠ luu xta­ma̠­lu­lok­má̠­nalh acxni̠ chiné xta­qui­lhuamá̠­nalh: —¡Maktum quilh­ta­macú aquinín ckax­mat­ni̠­táhu pi̠ eé chixcú xqui­lhuama: “Aquit tla̠n nac­lac­tla­huay xpu̠­si­culan Dios pero caj xliaktutu quilh­ta­macú nac­tla­hua­paray tunu xasa̠sti”! ");
INSERT INTO tocNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Amá xapuxcu cura huakaj tá̠yalh y kalhás­quilh Jesús: —¿Pi̠ xli̠­ca̠na hua̠ntu̠ taqui­lhuamá̠­nalh u̠ma̠ko̠lh lac­chix­cu­huí̠n? ¿Pi̠ ni̠ kax­pátpa̠t hua̠ntu̠ tali̠­ya̠­huamá̠n? ");
INSERT INTO tocNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero huata Jesús cacs tá̠yalh cumu la̠m­para ni̠ káx­matli, y amá xapuxcu cura kalhas­quimpá: —Nac xta­cu­huiní Dios hua̠nti̠ lama xas­tacná, aquit cli̠­ma̠­pek­si̠yá̠n xla­cata caqui­la̠­hua­níhu para xli̠­ca̠na huix Cristo hua̠nti̠ Xka­huasa Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús kálh­ti̠lh: —Xli̠­ca̠na xlá pi̠ aquit Cristo, pero na̠ luu laca­tancs cca̠­hua­niyá̠n pi̠ hui­xinín naqui­la̠ucxi­lhá̠hu acxni̠ aquit Xata­lac­sacni Chixcú cuilachá nahuán nac xpek­stácat xpu̠­ma̠­peksí̠n Dios hua̠nti̠ hui­lachá nac akapu̠n, y na̠ naqui­la̠ucxi­lhá̠hu acxni̠ antá nac­mim­pa­ra­ya̠chá xli̠­maktiy antá cmímaj nahuán nac xlacni puc­lhni. ");
INSERT INTO tocNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Amá xapuxcu cura maktum xti̠t pa̠t­lá­hualh clháka̠t caj xta­si̠tzi y chiné ca̠huá­nilh xa̠maka­pi­tzí̠n xcompañeros: —Xli̠­ca̠na pi̠ caj xpa̠­la­cata hua̠ntu̠ chu­hui̠­nani̠t eé chixcú ta̠la̠­la­ca­ta̠­qui̠ni̠t Dios, ¿túcuya̠ tes­tigo tila­cas­qui­ná̠hu? Pus mismo hui­xinín ma̠n kax­pat­ni̠­tátit hua̠ntu̠ xlá chu­hui̠­nani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Lácu chi̠nchú hui­xinín hua­ná̠tit? ¿Túcu nat­la­hua­ni­yá̠hu? Maka­pi­tzí̠n takalh­tí̠­nalh: —Tamá chixcú ma̠x juerza mini̠niy pi̠ nani̠y porque la̠n kalhi̠y xta­la̠­ka­lhí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Acxni̠ chuná tahuan­ko̠lh caj tzú­culh tali̠­ka­ma̠nán, tala­ca­chuj­má­ni̠lh, tala­ka­ká­xilh, y maka­pi­tzí̠n caj taakká­xilh. ");
INSERT INTO tocNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Y chiné xta­huaniy: —Cumu para xli̠­ca̠na huix Cristo, pus chú cama̠­lak­chi­pini xatícu luu hui­li̠nín. ");
INSERT INTO tocNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro antá culucs xuí nac xma̠­la­ka­tancs má̠lacchi antiyá nícu xta­mak­xtekni̠t acxni̠ antá cha̠lh, caj li̠puntzú lak­ta­la­ca­tzú­hui̠lh cha̠tum squi­ti­hui̠ná y chiné huá­nilh: —¡Já! Huix na̠ xta̠­la­pu̠­laya Jesús xalac Gali­lea. ");
INSERT INTO tocNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Cumu luu lhu̠hua xtza­macán Pedro ma̠lák­tze̠kli ni̠ li̠tá̠­yalh, y chiné huá­nilh: —¡Ma̠x caj laka­hui­típa̠t huix! Aquit ni̠ cca­tzi̠y hua̠ntu̠ huix qui­li̠­ya̠­huápa̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pedro antá xpe­kama nac xamá̠­lacchi a̠má li̠pacan, pero antá ucxilh­pa­rachá cha̠­tum­li̠túm squi­ti­hui̠ná y chiné ca̠huá­nilh hua̠nti̠ antá xta­la­yá̠­nalh: —Xli̠­ca̠na xlá pi̠ eé chixcú na̠ huá xta̠­la­pu̠lay Jesús xalac Naza­ret. ");
INSERT INTO tocNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Huata Pedro catu̠huá hua̠ntu̠ tzú­culh li̠qui­lhán la̠qui̠ chuná mat naca̠­naj­la­nicán hua̠ntu̠ xlá xqui­lhuama y chiné huá­nilh: —¡Curu­mentu, ni̠ cla­ka­pasa tamá chixcú hua̠nti̠ huix hua­nípa̠t! ");
INSERT INTO tocNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Pero caj li̠puntzú a̠ma̠ko̠lh lac­chix­cu­huí̠n hua̠nti̠ antá xta­la­yá̠­nalh xlacán talak­ta­la­ca­tzú­hui̠lh Pedro y chiné tahuá­nilh: —¿Lácu cuán? Xli̠­ca̠na xlá pi̠ na̠ huá mincompañero a̠má chixcú hua̠nti̠ tachí̠n li̠mín­calh najatá, porque caj min­ta­chu­huí̠n li̠ta­kalh­la­ka­pasa porque luu xta̠­chuná chu­hui̠­nana cumu la̠ chu­hui̠nán xlá. ");
INSERT INTO tocNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Huata Pedro ma̠lak­tze̠kpá y hasta Dios xli̠­qui­lhán xla­cata pi̠ caca̠­naj­la­ní­calh pi̠ mat ni̠ laka­pasa y chiné huá: —¡TeDios, tancs cuaniyá̠n pi̠ ni̠ cla­ka­pasa tamá chixcú hua̠nti̠ huix hua­nípa̠t! Acxni­tiyá chú tásalh tantum pu̠yu, ");
INSERT INTO tocNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","y Pedro na̠ acxnicú laca­pá̠s­tacli xta­chu­huí̠n Jesús hua̠ntu̠ xuanini̠t: “Acxni̠ nia̠ tasay nahuán pu̠yu, huix aya hua­ni̠­tatá nahuán xli̠­mak­tutu xla­cata pi̠ ni̠ qui­la­ka­pasa.” Acxni̠ chú laca­pa̠s­tac­ko̠lh la̠li̠­huán táx­tulh nac quilhtí̠n y antá tzú­culh tasay caj xta­li̠­pu­huá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Acxni̠ xka­ka­ko̠lh a̠ma̠ko̠lh xana­puxcún cura xa̠hua lak­ko̠­lu­tzi̠nni ma̠pek­si̠­naní̠n luu lac­xtum tali̠­cá­tzi̠lh xla­cata pi̠ nata­makni̠y Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Xlacán li̠huana̠ tama­cá­chi̠lh, antá talé̠­nilh nac xla­catí̠n gober­nador romano hua̠nti̠ xuanicán Pilato. ");
INSERT INTO tocNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Amá Judas acxni̠ chú xlá cátzi̠lh pi̠ aya xli̠lh­ca̠­cani̠t Jesús xla­cata pi̠ namak­ni̠cán huata tzú­culh li̠pu­huán y laka­pú­tzalh, la̠li̠­huán ca̠lá­kalh xana­puxcún cura xa̠hua lak­ko̠­lu­tzi̠nni ma̠pek­si̠­naní̠n, ");
INSERT INTO tocNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","acxni̠ ca̠lák­cha̠lh chiné ca̠huá­nilh: —Aquit cca̠­lak­mimá̠n cmimá̠n ca̠pu̠s­pit­niyá̠n min­tumi̠n, porque ctla­huani̠t tala̠­ka­lhí̠n xla­cata pi̠ cca̠­ma­ca­ma̠x­qui̠­ni̠tán cha̠tum chixcú hua̠nti̠ ni̠tu̠ lé̠n xcuenta la̠qui̠ hui­xinín namak­ni̠­yá̠tit. Pero huata xlacán chiné takálh­ti̠lh: —La̠ta túcu naok­spu­layá̠n o para túcu nala­niya, tamá aquinín ni̠ quin­cuentajcán. ");
INSERT INTO tocNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Pero cumu Judas luu li̠pe̠cua csi̠­tzi̠ni̠t xlá tilak­xcut­pú­tulh xta­la̠­ka­lhí̠n hua̠ntu̠ xtla­huani̠t, maktum la̠ta lhken ma̠kó­sulh a̠má tumi̠n nac xla­catí̠n pu̠santu hua̠ntu̠ huí nac xpu̠­lacni pu̠si­culan, y la̠li̠­huán táx­tulh anta­ti̠tum alh anta­nícu sacstu qui̠­ta­pix­chi̠­ta­huá­calh. ");
INSERT INTO tocNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ama̠­ko̠lh xana­puxcún cura tzú­culh tasa­qui̠y a̠má tumi̠n y chiné tala̠­huá­nilh: —Umá túmi̠n li̠xo­ko­cani̠t xla­táma̠t cha̠tum chixcú la̠qui̠ namak­ni̠cán por eso ni̠ cama­jú̠hu nac xpu̠­ma̠­qui̠cán limos­na porque ni̠tlá̠n cati­qui̠­táx­tulh xa̠huachí ni̠ lak­chá̠n para nama­ju̠­yá̠hu. ");
INSERT INTO tocNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Huata mejor luu lac­xtum tala̠­li̠­ta̠­chu­huí̠­nalh xla­cata nata­li̠­ta­ma̠­huay aktum pú̠cuxtu la̠qui̠ antá naca̠­ma̠c­nu̠cán hua̠nti̠ caj antá nani̠­ta­makán y hua̠nti̠ ni̠ antá xalaní̠n y chuná nata­li̠­ma̠xtuy xca̠­pu̠­sa̠n­tucán. Hua̠k tla̠n tat­lá­hualh y tali̠­ta­má̠­hualh xpu̠­cuxtu cha̠tum lhta­maná. ");
INSERT INTO tocNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Pus huá xpa̠­la­cata a̠má pú̠cuxtu li̠ma̠­pa̠­cu­hui̠cán hasta la̠ ca̠lacchú Campo de Sangre. ");
INSERT INTO tocNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Chuná xlacán tali̠­ma̠­kan­táx­ti̠lh hua̠ntu̠ maká̠n quilh­ta­macú títzokli pro­feta Jerem­ías nac li̠kalh­ta­huaka anta­nícu chiné huán: “Ama̠­ko̠lh cris­tianos xalac Israel caj xma̠n huá tali̠­xó­kolh puxa­ma­cá̠hu tumi̠n xla plata a̠má tali̠­pa̠hu chixcú hua̠nti̠ xli̠­ca̠na luu lhu̠hua xka­lhi̠y xta­palh, ");
INSERT INTO tocNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","pero chú aca­li̠stá̠n tati­yapá y huá tali̠­ta­má̠­hualh xpu̠­cuxtu cha̠tum lhta­maná; porque xli̠­ca̠na pi̠ chuná qui­li̠­ma̠­pek­si̠ni̠t Quim­pu̠­chi­nacán nac­tzoka.” ");
INSERT INTO tocNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús li̠chá̠n­calh nac xla­catí̠n gober­nador y xlá chiné kalhás­quilh: —¿Pi̠ xli̠­ca̠na huix xreycán judíos? —Xli̠­ca̠na xlá, luu laca­tancs la̠ huana —kalh­tí̠­nalh Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Acxni̠ chú a̠ma̠ko̠lh lac­chix­cu­huí̠n catu̠huá hua̠ntu̠ tzú­culh tali̠­ya̠­huay taaksaní̠n Jesús nac xla­catí̠n Pilato. Pero xla̠ ni̠para kalhtum tachu­huí̠n xkalh­tí̠­nalh hua̠ntu̠ xli̠­ya̠­hua­má̠­calh. ");
INSERT INTO tocNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pus huá xpa̠­la­cata Pilato chiné kalhás­quilh: —¿Lácu pi̠ ni̠ kax­pátpa̠t? Cakalh­tí̠­nanti porque u̠ma̠ko̠lh lac­chi­xcu­huí̠n lhúhua hua̠ntu̠ tali̠­ma̠­la­ca­pu̠yá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero huata Jesús a̠tzinú luu caj cacs tá̠yalh y ni̠ túcu kalh­tí̠­nalh. Huata Pilato luu caj cacs li̠la­cáhua acxni̠ úcxilhli pi̠ a̠má chixcú ni̠tu̠ xkalh­ti̠nán y niaj xca­tzi̠y hua̠ntu̠ naka­lhas­quín. ");
INSERT INTO tocNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Xlianka­lhi̠ná Pilato xli̠s­ma­ni̠ni̠t xmak­xteka cha̠tum tachí̠n acxni̠ xlak­cha̠ná xapa̠xcua taak­spun­tza̠lí̠n, la̠tachá xatícu nata­lac­saca xli̠­lhu̠hua cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Pus luu acxni̠ a̠má quilh­ta­macú xta­nu̠ma nac pu̠la̠­chi̠n cha̠tum li̠pe̠­cuánit chixcú hua̠nti̠ xuanicán Bar­rabás. ");
INSERT INTO tocNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Cumu chú aya mac­xtum xta­hui­lá̠­nalh cris­tianos pus Pilato ca̠ka­lhás­quilh: —¿Xatícu hui­xinín lacas­qui­ná̠tit nac­ca̠­mak­xtek­niyá̠n nac eé quilh­ta­macú xapa̠xcua taak­spun­tza̠lí̠n, pi̠ huá Bar­rabás osuchí huá Jesús hua̠nti̠ hui­xinín li̠ma̠­pa̠­cu­hui̠­yá̠tit Cristo? ");
INSERT INTO tocNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Huá chuná ca̠li̠­huá­nilh Pilato porque xlá laca­tancs xca­tzi̠y pi̠ cumu caj xta­quic­lhca­tzaniy Jesús huá xta­li̠­ma­ca­ma̠s­ta̠ni̠t nac xla­catí̠n xpu̠­ma̠­peksí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Acxni̠ Pilato ni̠tu̠ a̠ xla­ca̠x­tla­huay xlá xuí nac silla xalac xpu̠­ma̠­peksí̠n acxni̠ chilh cha̠tum chixcú hua̠nti̠ xmima huaniy xta­chu­huí̠n xpusca̠t hua̠ntu̠ xma­ca­mi­nima y chiné xuanima: “¡Luu xli̠­ca̠na cat­lahua li̠tlá̠n ni̠ capek­tanu huix tamá chixcú hua̠nti̠ ni̠tu̠ kalhi̠y xcuenta para túcu nali̠­ya̠­huaya! Porque u̠má tzi̠sní aquit luu li̠pe̠cua la̠ta cli̠­ma̠­níx­nilh caj xpa̠­la­cata.” ");
INSERT INTO tocNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Acxni̠ a̠ma̠ko̠lh xana­puxcún cura xa̠hua lak­ko̠­lu­tzi̠nni takáx­matli hua̠ntu̠ xca̠­ka­lhas­quima Pilato, xlacán tama̠aka­tá­ni̠lh xli̠­lhu̠hua cris­tianos xla­cata pi̠ huá catás­quilh camak­xték­calh Bar­rabás, y na̠ catáhua pi̠ maktum camak­ní̠­calh Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gober­nador Pilato ca̠ka­lhas­quimpá xli̠­maktiy xla­cata xli̠­cha̠­tiycán xatícu luu namak­xtekcán: —¿Pi̠ huá Bar­rabás o huá Jesús? Xlacán takalh­tí̠­nalh: —¡Huá camák­xtekti Bar­rabás! ");
INSERT INTO tocNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato ca̠ka­lhas­quimpá: —Y chi̠nchú Jesús hua̠nti̠ hui­xinín li̠ma̠­pa̠­cu­hui̠­yá̠tit Cristo, ¿túcu chú aquit nac­tla­huaniy? Li̠mac­xtum takalh­tí̠­nalh: —¡Cape­kex­to­ko­huaca nac cruz! ");
INSERT INTO tocNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Xlá ca̠hua­nipá: —Pero caqui­la̠­hua­níhu, ¿túcu tla­huani̠t hua̠ntu̠ ni̠tlá̠n? Huata xlacán caj tzu­cupá taqui­lhaniy: —¡Cape­kex­to­ko­huaca nac cruz! ");
INSERT INTO tocNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Acxnicú Pilato luu li̠huana̠ cátzi̠lh pi̠ ni̠lay xma̠t­la̠nti̠y xla­cata namak­xteka Jesús, porque xli̠­lhu̠hua cris­tianos li̠huaca xta­ma̠­ta­si̠­má̠­nalh xla­cata namak­ni̠cán, pus huá xpa̠­la­cata li̠ma̠­ti­yá̠­nalh pektum actzu ban­deja chú­chut y acxni̠ tzú­culh maka­chakán chiné ca̠huá­nilh: —¡La̠ta túcu nat­la­hua­ni­yá̠tit tamá chixcú aquit ni̠ quin­cuenta! Xa̠huachi hui­xinín naxo­ko̠­nu­ná̠tit xla­cata pi̠ namak­ni̠­yá̠tit, aquit ni̠tu̠ cxo­ko̠­numa porque ni̠tu̠ cli̠­ma̠­la­capu̠y aquit, xlá ni̠ kalhi̠y xta­la̠­ka­lhí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Huata xli̠­lhu̠hua cris­tianos taquilh­minchá y chiné takalh­tí̠­nalh: —¡Pus ma̠squi aquinín xa̠hua quin­ca­mancán caquin­ca̠­ta­hua­ca­ni­chá̠n tala̠­ka­lhí̠n y li̠xokó̠n xpa̠­la­cata pi̠ nac­mak­ni̠­yá̠hu eé chixcú! ");
INSERT INTO tocNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilato ca̠mak­xték­nilh Bar­rabás y li̠ma̠­pek­sí̠­nalh xla­cata pi̠ cas­nók­calh Jesús. Aca­li̠stá̠n chú ca̠ma­ca­má̠x­qui̠lh a̠ma̠ko̠lh tropa la̠qui̠ xlacán nata­pe­kex­to­ko­huacay nac cruz. ");
INSERT INTO tocNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ama̠­ko̠lh tropa tále̠lh Jesús nac xtan­quilhtí̠n xpu̠­ma̠­peksí̠n gober­nador y antá pu̠tum tata­mac­xtú­mi̠lh sol­dados nac xla­catí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Xlacán tama̠­lák­xtulh clháka̠t Jesús y tama̠­lhá­ke̠lh mactum xapu̠s­ta­pu̠hua lháka̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Cha̠tum tropa hui­lí̠­nilh nac xak­xa̠ka aktum corona xla lhtucú̠n, na̠ tama̠­chí­pi̠lh kantum lasasa quihui nac xmaca­stácat; aca­li̠stá̠n chú tzú­culh tali̠­ka­ma̠nán, tala­ka­ta­tzo­kós­talh y chiné tzu̠­culh tahuaniy: —¡Cane̠c­xni­cahuá cala­tá­ma̠lh xreycán judíos! ");
INSERT INTO tocNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Maka­pi­tzí̠n xta­la­ca­chuj­mani̠y, xta­mak­lhti̠y a̠má lasasa hua̠ntu̠ xta­ma̠­chi­pi̠ni̠t y pi̠ hua­tiyá xli̠t xta­liak­snoka nac xak­xa̠ka. ");
INSERT INTO tocNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Acxni̠ chú tali̠t­lákua la̠ta tali̠­ka­má̠­nalh a̠ma̠ko̠lh sol­dados pus tama̠­lak­xtupá a̠má xapu̠s­ta­pu̠hua lháka̠t hua̠ntu̠ xta­ma̠­lha­ke̠ni̠t y huá tama̠­lha­ke̠pá clháka̠t Jesús. Acxni­tiyá chú lé̠n­calh la̠qui̠ nape­kex­to­ko­hua­cacán nac cruz. ");
INSERT INTO tocNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ama̠­ko̠lh sol­dados tama̠­cú­qui̠lh Jesús kantum cruz y antá xle̠­má̠­calh ní nape­kex­to­ko­hua­cacán. Aya xta­pun­tax­tu­ma̠­nan­ko̠lh ca̠chi­quí̠n acxni̠ tapá̠x­tokli cha̠tum chixcú xalac Cirene xuani̠t, acxni̠ xlacán taúcxilhli huakaj tachí­palh y juerza tama̠­lé̠­ni̠lh xcruz Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Acxni̠ chú tácha̠lh nac lacatum antaní hua­nicán Gól­gota (eé tachu­huí̠n huam­putún xpu̠­la­tama̠n xac­lúcut ní̠n), ");
INSERT INTO tocNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","antá tita­ma̠­hui̠­pú­tulh vinagre hua̠ntu̠ xlak­ma­ca̠n­cani̠t xu̠n li̠cuchu, pero acxni̠ Jesús kalhuá̠nalh xlá ni̠ hua­pú­tulh. ");
INSERT INTO tocNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Acxni̠ chú aya xta­pe­kex­to­ko­hua­cani̠t nac cruz a̠ma̠ko̠lh tropa tzú­culh tali̠­macá̠n suerte la̠qui̠ chuná pu̠tum nata­li̠­ta­ka­tzi̠y nata­ka­lhi̠y clháka̠t Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Acxni̠ chuná tat­la­hua­ko̠lh antá chú tatáhui la̠qui̠ nata­mak­ta­kalha Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Y nac xacpú̠n xcruz Jesús xtzok­cani̠t pi̠tzu̠ páklh­a̠t anta­nícu xuán túcu xpa̠­la­cata chuná xli̠t­la­hua­cani̠t, y nac pák­lha̠t chiné xta­tzokni̠t: “Huá eé Jesús xreycán judíos.” ");
INSERT INTO tocNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Na̠ luu lac­xtum ca̠ta̠­pe­kex­to­ko­hua­cá­calh cha̠tiy kalha̠­naní̠n, cha̠tum xuaca nac xpek­stácat y cha̠­tum­li̠túm nac xpek­xuqui. ");
INSERT INTO tocNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Xli̠­hua̠k cris­tianos hua̠nti̠ antá xta­ti̠­taxtuy ma̠rí xta­li̠­kalh­ka­ma̠nán y chuná xta­ta­la­calh­cata, ");
INSERT INTO tocNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","y chiné xta­huaniy: —¡Chi̠nchú cumu huix huana pi̠ tla̠n nalac­x­tla­huaya lanca xpu̠­si­culan Dios y caj xliaktutu quilh­ta­macú nali̠t­la­hua­pa­raya tunu xasa̠sti, pus chú cata̠cta nac cruz para ca̠na̠ huana la̠qui̠ aquinín nac­ca­tzi̠­yá̠hu para xli̠­ca̠na huix xka­huasa Dios! ");
INSERT INTO tocNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Na̠chuná xta­li̠­kalh­ka­ma̠nán a̠ma̠ko̠lh xana­puxcún cura xa̠hua xma̠­kalh­ta­hua­ke̠­nacán judíos chu lak­ko̠­lu­tzi̠nni ma̠pek­si̠­naní̠n y chiné xta­huaniy: ");
INSERT INTO tocNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—¡Xli̠­ca̠na luu tla̠n xlá ca̠ma̠t­lá̠n­ti̠lh xa̠maka­pi­tzí̠n cris­tianos, pero sacstu ni̠lay lak­ma̠x­tucán! Pus para xli̠­ca̠na pi̠ huá chú xreycán judíos pus la̠li̠­huán catá̠c­talh nac cruz la̠qui̠ aquinín na̠ nali̠­pa̠­hua­ná̠hu y naca̠­naj­la­ni­yá̠hu. ");
INSERT INTO tocNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Xlá huán pi̠ mat xli̠­ca̠na li̠pa̠­huán Dios porque mat huá Xka­huasa, pus chú camilh mak­ta̠yay Dios cumu para xli̠­ca̠na xlá luu laka­lhamán, cumu la̠ta quin­ca̠­hua­ni­ni̠tán pi̠ xli̠­ca̠na huá Xka­huasa Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Y hasta a̠ma̠ko̠lh kalha̠­naní̠n hua̠nti̠ lac­xtum xca̠­ta̠­pe­kex­to­ko­hua­ca­cani̠t na̠chuná xta­li̠­kalh­ka­ma̠­na­má̠­nalh hasta xta­la­ca­quilhni̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Amá quilh­ta­macú ma̠x cumu luu tas­túnut xuani̠t acxni̠ chu­natá la̠ta ca̠puc­suanko̠lh nac a̠má pu̠la­tama̠n y hasta ca̠mak­tutu hora xalac ca̠ko̠­tanú̠n a̠cu ca̠x­ka­kapá. ");
INSERT INTO tocNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Y na̠ luu acxni­tiyá chú a̠má hora Jesús luu palha chiné ca̠tá­salh: —Elí, Elí, ¿lema sabac­tani? —eé tachu­huí̠n huam­putún: Papá Dios, ¿túcu xpa̠­la­cata qui­liak­xtek­ma­ka­ni̠ta? ");
INSERT INTO tocNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Maka­pi­tzí̠n lac­chix­cu­huí̠n hua̠nti̠ antá xta­la­yá̠­nalh takáx­matli hua̠ntu̠ Jesús xqui­lhuama y chiné xta­huán: —Umá chixcú tasa­nima xamaká̠n pro­feta Elías. ");
INSERT INTO tocNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Cha̠tum la̠li̠­huán alh putzay actzu panáma̠c, xlá li̠huana̠ lí̠lupli xax­cuta vinagre, antá chú ma̠lák­nu̠lh nac kantum lasasa, y huá chú li̠chéx­nilh hasta nac xquilhni Jesús la̠qui̠ nahuay. ");
INSERT INTO tocNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero huata xa̠maka­pi­tzí̠n tahuá­nilh: —¡Ni̠chuná cat­lahua la̠n­tamá! Cata­hua­ca­ké̠lh, cala­ke̠lh chú para namín lak­ma̠xtuy pro­feta Elías. ");
INSERT INTO tocNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesús a̠maktum palha ma̠ca̠­tá­si̠lh y acxni­tiyá ni̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Na̠ luu acxni̠ chú a̠má velo hua̠ntu̠ xli̠­la­kat­la­pa̠­nancán nac lanca pu̠si­culan xalac Jeru­salén, pu̠maka­tiy huá la̠ta sacstu talác­xti̠tli tzu­cuchá ta̠lhmá̠n hasta tu̠tzú. Xli̠­ca̠­lanca tíyat tachi­qui­ko̠lh y na̠chuná lac­lanca chí­huix pu̠maka­tiy huá la̠ta tatás­ka̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Lhu̠hua cris­tianos hua̠nti̠ xamaká̠n quilh­ta­macú xta­li̠­pa̠­huani̠t Dios y hua̠nti̠ aya xta­ni̠­ni̠ttá, acxni̠ chú chuná kan­táx­tulh xlacán tala­cas­ta­cuánalh nac ca̠li̠ní̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ama̠­ko̠lh tahuaxni chu pan­teón tata­lá­qui̠lh anta­nícu xlacán xca̠­ma̠c­nu̠­cani̠t, y acxni̠ chú lacas­ta­cuánalh Jesús nac ca̠li̠ní̠n pus na̠ acxnicú xlacán tatáx­tulh nac ca̠pú̠­sa̠ntu y táalh nac xaca̠­chi­quí̠n Jeru­salén y luu lhu̠hua cris­tianos taúcxilhli pi̠ xta­la­cas­ta­cuanani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Amá capitán xa̠hua maka­pi­tzí̠n tropa hua̠nti̠ xta­mak­ta­kalh­má̠­nalh Jesús, acxni̠ xlacán taúcxilhli la̠ta xta­chi­quima tíyat y xpu̠­tzan­ka̠­nama xlacán la̠n tapé̠­cualh y chiné táhua: —¡Xli̠­ca̠na eé chixcú huá Xka­huasa Dios xuani̠t! ");
INSERT INTO tocNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Antá tzinú laka­mákat xta­la­yá̠­nalh maka­pi­tzí̠n lac­chaján hua̠nti̠ a̠huatá xta­sta̠­la­ni­ni̠­tanchá Jesús nac Gali­lea y xta­mak­ta̠­yani̠t acxni̠ xlá xli̠­chu­hui̠­nama xta­chu­huí̠n Dios. ");
INSERT INTO tocNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Antá xmak­laya María Mag­da­lena, xa̠hua María hua̠nti̠ xtzí San­tiago y José, y na̠ antá xlaya xpusca̠t Zebedeo. ");
INSERT INTO tocNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Acxni̠ aya xca̠­lak­pok­xuama a̠má quilh­ta­macú, cha̠tum chixcú rico xuanicán José xalac Ari­matea, cumu xlá eé chixcú na̠ xli̠­pa̠­huán xta­chu­huí̠n Jesús, ");
INSERT INTO tocNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","huata xlá alh ta̠chu­hui̠nán gober­nador Pilato, huá­nilh xla­cata pi̠ camá̠x­qui̠lh tala­cas­quín la̠qui̠ nama̠cti̠y y nama̠cnu̠y xti­yat­li̠hua Jesús. Pilato tla̠n tla̠­hualh hua̠ntu̠ hua­ní­calh y ma̠pek­sí̠­nalh xla­cata pi̠ cama̠x­quí̠­calh xti­yat­li̠hua Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","José la̠li̠­huán alh y má̠c­ti̠lh Jesús, xlá li̠huana̠ li̠mák­suitli mactum lanca sábana, ");
INSERT INTO tocNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","y antá chú má̠c­nu̠lh nac aktum xasa̠sti tahuaxni hua̠ntu̠ ma̠n xma̠­la­ca­huax­ni̠­nanít nac xlacán sipi. Acxni̠ chú ca̠x­ta­ra­mi̠­ko̠lh Jesús li̠huana̠ li̠la­ka­tá­lalh antaní xlac­ta­nu̠cán nac a̠má tahuaxni aktum lanca chí­huix. Acxni̠ chú chuná tla­hua­ko̠lh aya alhá nac xchic. ");
INSERT INTO tocNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Pero huata a̠ma̠ko̠lh cha̠tiy lac­chaján María Mag­da­lena y cha̠­tum­li̠túm María, antá xlacán tatáhui lacatzú nac tahuaxni y hua̠k xtaucxilh­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Li̠cha̠lí chú sábado acxni̠ xlak­cha̠ni̠t quilh­ta­macú la̠ta jaxcán, a̠ma̠ko̠lh xana­puxcun cura xa̠hua fariseos mac­xtum talá­kalh Pilato, ");
INSERT INTO tocNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","y chiné tahuá­nilh: —Señor gober­nador, a̠má aksa­ni̠ná chixcú hua̠nti̠ aya mak­ni̠­ni̠­táhu xlá xca̠­li̠­ma̠­kalh­chu­hui̠ni̠y cris­tianos acxni̠ xla­majcú xla­cata pi̠ xliaktutu quilh­ta­macú xlá xámaj lacas­ta­cuanán nac ca̠li̠ní̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Huá cmimá̠n ca̠li̠­hua­niyá̠n xla­cata pi̠ xca̠­ma̠­peksi min­tropa la̠qui̠ xtáalh tamak­ta­kalhnán aktutu quilh­ta­macú, chicá para xamaktum natas­ca­camín xta­ma̠­kalh­ta­huaké̠n y tze̠k natalé̠n xti­yat­li̠hua xma̠­kalh­ta­hua­ke̠­nacán, aca­li̠stá̠n chú nata­quilh­tzu­cu­paray nac xla­ca­ti̠ncán xli̠­lhu̠hua cris­tianos xla­cata pi̠ lacas­ta­cuánalh nac ca̠li̠ní̠n. Pus aca­li̠stá̠n chú eé taaksaní̠n luu lanca naqui̠­taxtuy ni̠xa­chuná cumu lá xca̠­li̠­ma̠­kalh­chu­hui̠ni̠y cris­tianos xapu̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato ca̠kálh­ti̠lh: —Pus la̠li̠­huán caca̠­ma̠­cá̠xtit tropa y hui­xinín ma̠n caca̠x­tla­huátit la̠ta lácu lacas­qui­ná̠tit nata­mak­ta­kalhnán xla­cata ni̠tu̠ naka­lhancán nac tahuaxni. ");
INSERT INTO tocNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ama̠­ko̠lh lac­chix­cu­huí̠n ma̠n taquí̠­lalh anta­nícu xma̠c­nu̠­cani̠t Jesús, luu li̠huana̠ tasel­lar­tlá­hualh nac xlacán a̠má tahuaxni anta­nícu xuí a̠má chí­huix hua̠ntu̠ xli̠­la­ka­ta­la­cani̠t. Y antá chú ca̠mak­xték­calh a̠ma̠ko̠lh tropa la̠qui̠ xlacán nata­mak­ta­kalhnán tan­tacú y tan­tas­caca. ");
INSERT INTO tocNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Acxni̠ ti̠tax­tu­ko̠lh a̠má quilh­ta­macú la̠ta xjaxcán y aya cxka­ka­ti̠­lhako̠y laca­tzi̠sa domingo, María Mag­da­lena y cha̠­tum­li̠túm María taquí̠­lalh anta­nícu xma̠c­nu̠­cani̠t Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Pero acxni̠ nia̠ xta­chá̠n caj xamaktum li̠pe̠cua tzú­culh tachi­quiy tíyat, porque cha̠tum xángel Dios ta̠c­tachi nac ca̠ti­yatni y antá chilh ní xma̠c­nu̠­cani̠t Jesús. Xlá tala­ca­tzú­hui̠lh nac tahuaxni y ma̠ta­ké̠­nu̠lh a̠má lanca chí­huix hua̠ntu̠ xli̠­la­ka­ta­la­cani̠t, aca­li̠stá̠n chú antá culucs lac­táhui nac xok­spú̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Amá ángel slipua xta­siyuy cumu la̠ mak­lipni, y chi̠nchú clháka̠t luu sna­papa xta­siyuy cumu la̠ xaseda lháka̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Acxni̠ a̠ma̠ko̠lh tropa taúcxilhli xli̠­ca̠na luu la̠n tapé̠­cualh caj xpa̠­la­cata hua̠ntu̠ xtaucxilh­má̠­nalh, hasta caj xta­pe̠­cuacán tzú­culh talh­pipiy y la̠m­para xaní̠n tata­mák­xtekli. ");
INSERT INTO tocNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Amá ángel chiné ca̠huá­nilh lac­chaján: —Ni̠ cape̠­cuántit, aquit cca­tzi̠y pi̠ hui­xinín huá putza­yá̠tit Jesús hua̠nti̠ tipe­kex­to­ko­hua­cá­calh nac cruz. ");
INSERT INTO tocNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Pero uú niaj ti̠ tanu̠ma huata xlá lacas­ta­cuánalh nac ca̠li̠ní̠n chuná cumu la̠ tica̠­li̠­ma̠­kalh­chu­hui̠ní̠n. Para ni̠ ca̠naj­la­yá̠tit hasta ma̠squi catátit ucxi­lhá̠tit anta­nícu xta­ra­mi̠­cani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Huata la̠li̠­huán capim­pítit ca̠hua­ni­yá̠tit xa̠maka­pi­tzí̠n xdis­cí­pulos xla­cata pi̠ lacas­ta­cuanani̠t y lama xas­tacná; chú xlá ca̠pu̠­la­nimá̠n y aya amajá nac Gali­lea la̠qui̠ na̠ napi­ná̠tit hui­xinín y antá ma̠n naucxi­lha̠­pítit. Xma̠nhuá eé tachu­huí̠n hua̠ntu̠ aquit xac­mi­ni̠tán ca̠hua­niyá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ama̠­ko̠lh lac­chaján caj xta­pe̠­cuacán y xta­pa̠­xu­hua̠ncán tokosú̠n táalh tama̠­ca­tzi̠­ni̠nán hua̠ntu̠ xkan­tax­tuni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Pero acxni̠ nia̠ xta­chá̠n chu­nacú xta­kos­nu­má̠­nalh nac tiji caj xamaktum antá ca̠ta­si­yú­nilh Jesús y ca̠xa­kát­li̠lh. Xlacán la̠li̠­huán talak­ta­la­ca­tzú­hui̠lh, tala­ka­ta­tzo­kós­talh nac xla­catí̠n y snat tat­lá­hualh nac xtantú̠n y tzú­culh tala­ka­chi­xcu­huí̠y. ");
INSERT INTO tocNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Y Jesús chiné ca̠huá­nilh: —Cata­ca­májtit y ni̠ cape̠­cuántit, huata mejor caca̠­qui̠­hua­ni­pítit tama̠­ko̠lh qui­na­ta̠lán xla­cata pi̠ antá cama nac Gali­lea la̠qui̠ antá pu̠tum naqui­la̠ucxi­lha̠­chá̠hu. ");
INSERT INTO tocNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Acxni̠ a̠ma̠ko̠lh lac­chaján nia̠ xta­chá̠n a̠ma̠ko̠lh sol­dados hua̠nti̠ xta­mak­ta­kalh­na­má̠­nalh nac tahuaxni tácha̠lh nac ca̠chi­quí̠n, y acxni̠ talák­cha̠lh xana­puxcún cura tzú­culh tali̠­ta̠­chu­hui̠nán la̠ta túcua xkan­tax­tuni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Huata u̠ma̠ko̠lh lac­chix­cu­huí̠n la̠li̠­huán tama̠­mac­xtú­mi̠lh a̠ma̠ko̠lh lak­ko̠­lu­tzi̠nni ma̠pek­si̠­naní̠n la̠qui̠ lac­xtum nata­li̠­chu­hui̠nán, y luu lac­xtum tali̠­cá­tzi̠lh xla­cata nata­ma̠x­qui̠y lhúhua tumi̠n a̠ma̠ko̠lh sol­dados, ");
INSERT INTO tocNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","y chiné ca̠hua­ní­calh: —Hui­xinín kalhtum cahuántit pi̠ acxni̠ aclhta­ta­ta­hui­látit ca̠tzi̠sní, tachilh xta­ma̠­kalh­ta­huaké̠n Jesús y tze̠k taka­lhá­le̠lh xti­yat­li̠hua. ");
INSERT INTO tocNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Y para xamaktum naca­tzi̠y gober­nador eé tachu­huí̠n, hui­xinín ni̠ cali̠­pu­huántit porque aquinín nac­ma̠aka­tan­csa­yá̠hu, pero hui­xinín ni̠tu̠ cati­ca̠­lak­chá̠n taaklhú̠­hui̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Amá­ko̠lh sol­dados tamak­lhtí̠­nalh tumi̠n y xlacán chuná tat­lá­hualh cumu la̠ xca̠­li̠­ma̠­pek­si̠­cani̠t. Y caj hua̠ eé xpa̠­la­cata ma̠squi hasta la̠ ca̠lacchú quilh­ta­macú a̠ma̠ko̠lh judíos chuná xlacán tahuán. ");
INSERT INTO tocNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ama̠­ko̠lh kalha­ca̠­huitu dis­cí­pulos la̠li̠­huán táalh nac Gali­lea y antá tácha̠lh nac a̠má ke̠stí̠n hua̠ntu̠ Jesús xca̠­hua­nini̠t. ");
INSERT INTO tocNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Acxni̠ chú xlacán taúcxilhli Jesús tala­ka­chix­cú­hui̠lh, ma̠squi maka­pi­tzí̠n ni̠ luu lay xta­ca̠­najlay para luu xli̠­ca̠na hua̠ntu̠ xtaucxilh­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús ca̠lak­ta­la­ca­tzú­hui̠lh y chiné ca̠huá­nilh: —Dios qui­ma̠x­qui̠ni̠t xli̠­hua̠k xli̠­ma̠­peksí̠n la̠qui̠ aquit nac­ma̠­pek­si̠nán uú nac ca̠quilh­ta­macú chu nac akapú̠n. ");
INSERT INTO tocNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Aquit cca̠­li̠­ma̠­pek­si̠yá̠n y hui­xinín capítit nac xli̠­ca̠­lanca ca̠quilh­ta­macú, xli̠­hua̠k cris­tianos caca̠­li̠­ta̠­chu­hui̠­nántit la̠ta lácu luu xli̠­ca̠na aksti̠tum naquin­ta­li̠­pa̠­huán. Y caca̠­liakmu­nútit nac xta­cu­huiní Quin­tla̠t, nac xta­cu­huiní Xka­huasa, y nac xta­cu­huiní Espíri­tu Santo. ");
INSERT INTO tocNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Y hui­xinín luu li̠huana̠ caca̠­ma̠­si­yu­nítit la̠ta lácu nata­ma̠­kan­taxti̠y xli̠­hua̠k hua̠ntu̠ aquit cca̠­li̠­ma̠­pek­si̠­ni̠tán. Xa̠huachí hui­xinín ni̠ cali̠­pu­huántit porque aquit anka­lhi̠ná nac­ca̠­mak­ta­ka­lhá̠n y nac­ca̠­ta̠­la­ta­ma̠yá̠n cha̠li cha̠lí hasta acxni̠ nas­puta ca̠quilh­ta­macú.");
INSERT INTO tocNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Eé libro li̠chu­hui̠nán hua̠ntu̠ li̠kan­táx­tulh xla­táma̠t Jesu­cristo Xka­huasa Dios la̠ta lácu milh ma̠sta̠y lak­táxtut. ");
INSERT INTO tocNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Chuná li̠tzú­culh cumu la̠ pro­feta Isaías xamaká̠n quilh­ta­macú titzók­nulh xpa̠­la­cata, chiné xuán: Cmacá̠n quiakchu­hui̠ná napu̠­la­niyá̠n la̠qui̠ naca̠x­tla­hua­niyá̠n min­tiji. ");
INSERT INTO tocNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Caj lá̠m­para tícu quilh­mi­ma̠chá nac desierto antaní ni̠ti̠cu lama cris­tianos y chiné huán: “Caca̠x­tla­hua­nítit tiji anta­nícu luu tla̠n nalacmín Quim­pu̠­chi­nacán; cama̠x­tu­nítit kantum tiji ni̠ma̠ statua.” ");
INSERT INTO tocNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Pus chuná timin­chitá Juan Bau­tista xca̠akmu­numa cris­tianos nac desierto, xca̠­huaniy pi̠ cata­lak­pá­li̠lh xali̠xcáj­nit xta­pu­hua̠ncán y nata­taakmunuy la̠qui̠ Dios naca̠­ma̠­tzan­ke̠­naniy xta­la̠­ka­lhi̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Xtamín takax­matniy cris­tianos hua̠nti̠ xta­la­má̠­nalh nac Judea, chu xalac Jeru­salén; y acxni̠ xlacán xta­li̠­ta̠yay xali̠xcáj­nit xla­ta­ma̠tcán, maktum xta­huán pi̠ xli̠­ca̠na xta­lak­pa­li̠­putún, Juan xca̠akmunuy nac kalh­tu̠­choko Jordán. ");
INSERT INTO tocNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Hua̠ntu̠ clhaka̠y Juan xli̠t­la­huani̠t xmac­chíxit camello, xtam­pu̠­lak­ta­huilay kantum cin­turón xla xu̠hua, y xli̠­hua̠yán lactzu xtuqui chu táxca̠t hua̠ntu̠ xmaclay nac ca̠qui­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Acxni̠ xca̠­ma̠­kalh­chu­hui̠ni̠y cris­tianos chiné xca̠­huaniy: —Niaj maka̠s quilh­ta­macú mima a̠cha̠tum ti̠ a̠tzinú lanca xla­ca­tzúcut hua̠nti̠ ni̠para tzinú cma­ka­lak­chá̠n nac­li̠­tanu̠y cumu la̠ xta­sa̠cua nac­xcutniy xacorrea xta­tu̠nú̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Aquit caj chú­chut cca̠­liakmu­nu­ni̠tán, pero xlá naca̠­liakmu­nuyá̠n xli̠t­li­hueke Espíri­tu Santo. ");
INSERT INTO tocNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ni̠ li̠maka̠s quilh­ta­macú Jesús táca̠xli nac xca̠­chi­quí̠n Naza­ret hua̠ntu̠ huí nac xmu­ni­cipio Gali­lea, y Juan akmú­nulh nac xakalh­tu̠­choko Jordán. ");
INSERT INTO tocNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Acxni̠ tacutli nac chú­chut Jesús úcxilhli pi̠ talá­qui̠lh akapú̠n y Espíri­tu Santo xta̠c­ta­ma̠chi nac xok­spú̠n caj la̠ actzu paloma. ");
INSERT INTO tocNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Na̠ acxni­tiyá takáx­matli aktum tachu­huí̠n minchá nac akapú̠n, chiné huá­nilh: —Huix Quin­ka­huasa ti̠ luu cpa̠x­qui̠y, luu cli̠­pa̠­xu­huay caj mim­pa̠­la­cata. ");
INSERT INTO tocNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Acxni­tuncán la̠ ta̠k­mu­nu­ko̠lh, a̠má Espíri­tu Santo le̠lh nac desierto antaní ni̠ti̠cu anán cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Antá xla­ma̠chá Jesús ti̠puxám quilh­ta­macú sacstu, xma̠n huá qui­tzis­tancá̠n xala ca̠qui­huí̠n xta­ta̠­la­má̠­nalh. Akska­huiní na̠ antá xma̠t­la­hui̠­putún tala̠­ka­lhí̠n pero Jesús makat­lá­jalh, y aca­li̠stá̠n támilh xán­geles Dios, tamak­tá­kalhli. ");
INSERT INTO tocNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ni̠ xli̠­maka̠s quilh­ta­macú Juan Bau­tista tamac­nú̠­calh nac pu̠la̠­chi̠n, acxni̠ Jesús tas­pitpa̠ nac Gali­lea y antá tzú­culh ca̠ma̠­kalh­chu­hui̠ni̠y cris­tianos lácu Dios xca̠­ma̠­lac­nu̠­nima túnuj tla̠n latáma̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Y chiné xca̠­huaniy: —Aya lak­cha̠ni̠t quilh­ta­macú acxni̠ Dios nama̠­tzu­qui̠y xasa̠sti xta­péksi̠t nac ca̠quilh­ta­macú. Calak­pa­lí̠tit xali̠xcáj­nit min­ta­la­ca­pa̠s­tac­nicán y caca̠­naj­látit u̠má xasa̠sti xta­ma̠­ca­tzi̠ní̠n hua̠ntu̠ ma̠sta̠y lak­táxtut. ");
INSERT INTO tocNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Maktum quilh­ta­macú acxni̠ Jesús xtla̠­huama nac xquilhtú̠n xapu­punú Gali­lea ca̠úcxilhli cha̠tiy squi̠­ti̠­naní̠n xta­ma­ju̠­má̠­nalh xtza̠lhcán nac chú­chut, cha̠tum hua­nicán Simón y xta̠lá hua­nicán Andrés. ");
INSERT INTO tocNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Pero Jesús ca̠huá­nilh: —Hui­xinín xchi­pa­naní̠n squi̠ti, qui­la̠s­ta̠­la­níhu y aquit nac­ca̠­ma̠­si­yu­niyá̠n la̠ ca̠chi­pacán cris­tianos ti̠ ta̠k­tzan­ka̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Xlacán tuncán tamák­xtekli xtza̠lhcán y ta­sta̠­lá­nilh. ");
INSERT INTO tocNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Caj a̠ctzú tla̠­huampá Jesús úcxilhli San­tiago xka­huasa Zebedeo xa̠hua xta̠lá xuanicán Juan; xlacán xta­ta­ju̠­má̠­nalh nac aktum barco xta­la­ca­chi̠­má̠­nalh xtza̠lhcán. ");
INSERT INTO tocNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesús na̠ ca̠huá­nilh cata­sta̠­lá­nilh y xlacán taak­xték­mi̠lh xtla̠tcán Zebedeo nac barco chu xmak­ta̠­ya­naní̠n y ta­sta̠­lá­nilh Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tácha̠lh nac aktum ca̠chi­quí̠n hua­nicán Caper­naum y acxni̠ lák­cha̠lh quilh­ta­macú acxni̠ hua̠k judíos xta­jaxa, Jesús tánu̠lh nac xpu̠­si­cu­lancán hua̠ntu̠ hua­nicán sina­goga y antá tzú­culh ca̠ma̠­kalh­chu­hui̠ni̠y lac­chix­cu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Pu̠tum cacs xta­la­ca­huán acxni̠ xta­kax­matniy hua̠ntu̠ xlá xli̠­chu­hui̠­nama porque xlá la̠ta tu̠ xca̠­li̠­ma̠­peksi̠y xca̠­huaniy la̠ ti̠ xli̠­ca̠na kalhi̠y li̠ma̠­peksí̠n y ni̠ caj la̠ xma̠­kalh­ta­hua­ke̠­nacán judíos. ");
INSERT INTO tocNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Y acxni­tiyá a̠má quilh­ta­macú na̠ antá tánu̠lh cha̠tum chixcú ti̠ xak­chi­pa­nini̠t xta­la­ca­pa̠s­tacni akska­huiní xlá chiné qui­lhá­nilh: ");
INSERT INTO tocNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Huix Jesús xalac Naza­ret, ¿túcu xpa̠­la­cata qui­la̠­pek­ta­nu̠­yá̠hu? Huix caj tani̠ta qui­la̠­ma̠s­pu­tu­yá̠hu, porque aquit cla­ka­pasá̠n y cca­tzi̠y pi̠ huix hua̠nti̠ Dios lac­sacni̠t la̠qui̠ nas­cuj­na­niya. ");
INSERT INTO tocNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Pero Jesús laca­quílh­ni̠lh a̠má xes­pí­ritu akska­huiní y chiné huá­nilh: —¡Cacs caquí­lhuanti y camák­xtekti tamá chixcú! ");
INSERT INTO tocNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Amá xes­pí­ritu akska­huiní ma̠s­nók­ni̠lh u̠n y li̠pe̠cua tásalh pero juerza mac­táx­tulh a̠má chixcú. ");
INSERT INTO tocNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Putum hua̠nti̠ antá xta­la­yá̠­nalh tapé̠­cualh y chiné tzú­culh tala̠­ka­lhas­quín: —¿Lácu eé qui̠­taxtuy? ¿Túcuya̠ sa̠sti taca­tzí̠n? ¡Eé chixcú kalhi̠y li̠t­li­hueke tla̠n ca̠ma̠­peksi̠y xes­pí­ritu akska­huiní y xlacán taka­lha­kax­mata! ");
INSERT INTO tocNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Pu̠tum lac­chix­cu­huí̠n xalac Gali­lea xta­li̠­chu­hui̠nán la̠ta tu̠ xlá xtla­huay Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Acxni̠ tatáx­tulh nac pu̠si­culan Jesús ca̠tá̠alh San­tiago chu Juan nac xchic Simón chu Andrés. ");
INSERT INTO tocNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Li̠ta̠­chu­hui̠­nán­calh Jesús pi̠ xpu̠­ti­ya̠tzí Simón xta̠­tatlay y xke̠­tama nac xtícat porque xka­lhi̠y palha lhcúya̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesús lak­ta­la­ca­tzú­hui̠lh antaní xmá, maca­chí­palh y laka­siyu má̠qui̠lh, acxni­tuncán mák­xtekli lhcúya̠t. Amá pusca̠t tá̠qui̠lh y tzú­culh ca̠x­tla­huay para túcu naca̠­ta̠­huay. ");
INSERT INTO tocNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Acxni̠ tzú­culh tzi̠­suán a̠má quilh­ta­macú li̠mi­ní­calh Jesús lhu̠hua ta̠tat­laní̠n, na̠chuná ti̠ xca̠akchi­pani̠t xta­la­ca­pa̠s­tacni xes­pí­ritu akska­huiní. ");
INSERT INTO tocNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Y xli̠­hua̠k cris­tianos hua̠nti̠ xta­hui­lá̠­nalh nac a̠má ca̠chi­quí̠n tata­mac­xtú­mi̠lh hasta niaj lay xta­ta­nu̠ko̠y xchic Simón. ");
INSERT INTO tocNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús ca̠ma̠t­lá̠n­ti̠lh la̠ta túcuya̠ tajátat xta­ka­lhi̠y, na̠chuná ti̠ xca̠­mac­ta­nu̠ma xes­pí­ritu akska­huiní xlá ca̠ta­mác­xtulh. Acxni̠ xca̠t­la­kaxtuy xlá ni̠ xca̠­ma̠x­qui̠y quilh­ta­macú nata­chu­hui̠nán a̠má akska­hui­naní̠n porque xlacán xta­ca­tzi̠y tícuya̠ chixcú xuani̠t Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Acxni̠ nia̠ cxka­kako̠y a̠má tzi̠sní chu­nacú ca̠pucsua xuani̠t Jesús tá̠qui̠lh y alh kalh­ta­hua­kaniy Dios nac xqui­lhapá̠n a̠má ca̠chi­quí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Acxni̠ tala­káhua Simón Pedro chu xa̠maka­pitzi xta­ma̠­kalh­ta­huaké̠n tzú­culh tapu­tzay. ");
INSERT INTO tocNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Y acxni̠ taqui̠­mác­lalh tahuá­nilh: —Lhu̠hua cris­tianos tapu­tzamá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Pero xlá ca̠kálh­ti̠lh: —Chú naaná̠hu a̠laca­tunu ca̠chi­quí̠n ni̠ma̠ tlak lacatzú tahui­lá̠­nalh la̠qui̠ naca̠­li̠­ta̠­chu­hui̠­na­ná̠hu cris­tianos lácu Dios lacas­quín nata­la­tama̠y porque caj huá xla­cata qui­li̠­ma­ca­mini̠t Dios. ");
INSERT INTO tocNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Pus Jesús chuná ca̠la­ka­tzá̠­lalh lactzu ca̠chi­qui̠ní̠n hua̠ntu̠ xca̠­ma̠­peksi̠y Gali­lea. Acxni̠ xcha̠n nac aktum ca̠chi­quí̠n xlá xtanu̠y nac xpu̠­si­cu­lancán judíos la̠qui̠ antá naca̠­li̠­ma̠­kalh­chu­hui̠ni̠y cris­tianos xta­chu­huí̠n Dios y hua̠nti̠ xka­lhi̠y xes­pí­ritu akska­huiní xca̠­ma̠t­la̠nti̠y. ");
INSERT INTO tocNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Maktum quilh­ta­macú lak­ta­la­ca­tzú­hui̠lh Jesús cha̠tum chixcú ti̠ xka­lhi̠y li̠pe̠­cuánit tajátat hua­nicán lepra. Xlá laka­ta­tzo­kós­talh y chiné huá­nilh: —Aquit cca­tzi̠y pi̠ huix tla̠n naqui­ma̠­pac­saya, para huix chuná laca­squina caqui­ma̠­pac­sani eé quin­ta­játat. ");
INSERT INTO tocNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús laka­lhá­malh, xamá­nilh nac xmacni y chiné huá­nilh: —Chuná cla­cas­quín, la̠nchú tuncán capacsti. ");
INSERT INTO tocNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Acxni̠ chuná hua­ni­ko̠lh a̠má ta̠tatlá tuncán pacsli. ");
INSERT INTO tocNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesús huá­nilh pi̠ caalh nac xchic, pero li̠ma̠­pék­si̠lh: ");
INSERT INTO tocNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Ni̠ti̠ cahuani lácu huix pac­sni̠ta; caj xma̠n caputza cha̠tum cura la̠qui̠ naucxi­lhá̠n y cama̠xqui mili­mosna hua̠ntu̠ Moisés tili̠­ma̠­pek­sí̠­nalh nata­ma̠sta̠y acxni̠ tapacsa hua̠nti̠ xta­ka­lhi̠y u̠má tajátat, la̠qui̠ acxni̠ xlá naucxi­lhá̠n nama̠­lu­loka y chuná pu̠tum naca­tzi̠­ko̠cán pi̠ aya pac­sni̠ta a̠má min­ta­játat hua̠ntu̠ xka­lhi̠ya. ");
INSERT INTO tocNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero a̠má chixcú cati̠huá tzú­culh ca̠li̠­ta̠­chu­hui̠nán hua̠ntu̠ xlá xtla­huani̠t Dios y lácu xma̠­pac­sani̠t. Pus caj huá xla­cata Jesús niajlay xta­nu̠­ya̠chá nac aktum ca̠chi­quí̠n anta­nícu lhu̠hua xtza­macán, pus huata caj xca̠­macní̠n xtla̠­huán anta­nícu ni̠ti̠ tala­yá̠­nalh cris­tianos. Pero ma̠squi chuná, xtamín cani̠huá xalaní̠n xla­cata nata­kax­matniy xta­chu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ni̠ li̠maka̠s quilh­ta­macú Jesús ampá nac xaca̠­chi­quí̠n Caper­naum y lhu̠hua catzí̠­calh pi̠ antá xlá xcha̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","La̠li̠­huán tata­mac­xtú­mi̠lh lhu̠hua cris­tianos hasta niajlay xta­nu̠­ko̠cán nac chiqui; Jesús tzú­culh ca̠ma̠­lac­ti̠­tu­mi̠niy xta­péksi̠t Dios lácu xlá lacas­quín nata­la­tama̠y. ");
INSERT INTO tocNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Chu­nacú xca̠­ta̠­chu­hui̠­nama acxni̠ tachilh kalha­ta̠ti lac­chix­cu­huí̠n xta­pu̠­li̠­mi­má̠­nalh pu̠chexni cha̠tum chixcú hua̠nti̠ ni̠lay xtla̠­huán porque xli̠­lanca xlu̠n­tu̠­hua­nani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero cumu ni̠lay xta­lak­chá̠n anta­nícu xuí Jesús porque xtza­macán huata tata­huá­calh nac xak­stí̠n chiqui y tama̠­ta­ké̠­nu̠lh pek­stiy teja xma̠­la­ka­tancs antaní xuí Jesús y antá talac­má̠c­ti̠lh pu̠chexni hua̠ntu̠ xlacma a̠má ta̠tatlá. ");
INSERT INTO tocNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Acxni̠ ca̠úcxilhli Jesús pi̠ luu xta­li̠­pa̠­huán xla­cata tla̠n nama̠t­la̠nti̠y chiné huá­nilh ta̠tatlá: —Luu snu̠n cla­ka­lha­maná̠n y la̠ta xli̠­hua̠k min­ta­la̠­ka­lhí̠n cma̠­tzan­ke̠­na­niyá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Pero antá xta­la­yá̠­nalh maka­pi­tzí̠n xma̠­kalh­ta­hua­ke̠­nacán judíos, xlacán chiné tzú­culh talac­pu­huán: ");
INSERT INTO tocNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Túcu xpa̠­la­cata chuná li̠kalh­chu­hui̠nán eé chixcú? Pus ta̠la̠­la­ca­ta̠­qui̠ma Dios; porque ni̠ti̠ anán tícu tla̠n ma̠tzan­ke̠­na­ni̠nán tala̠­ka­lhí̠n sino xma̠n Dios.” ");
INSERT INTO tocNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pero cumu Jesús xca­tzi̠y túcu xlacán xta­lac­pu­hua­má̠­nalh chiné ca̠huá­nilh: —¿Túcu xpa̠­la­cata lá̠n­tamá chuná li̠lac­pu­hua­ná̠tit hui­xinín? ");
INSERT INTO tocNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Pus caqui­la̠­hua­níhu, ¿xatúcu a̠tzinú ni̠para tuhua ma̠kan­tax­ti̠cán, pi̠ acxni̠ nahua­niya cha̠tum ta̠tatlá: “Min­ta­la̠­ka­lhí̠n hua̠k cma̠tzanke̠naniyá̠n”, osuchí para nahua­niya: “La̠li̠­huán cata̠qui y catlá̠huanti”? ");
INSERT INTO tocNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pus la̠nchú camá̠n ca̠ma̠­si­yu­niyá̠n pi̠ aquit Xata­lac­sacni Chixcú y na̠chuna li̠túm pi̠ xli̠­ca̠na cka­lhi̠y li̠t­li­hueke uú nac ca̠quilh­ta­macú y caj quin­ta­chu­huí̠n tla̠n cli̠­ma̠­tzan­ke̠­na­ni̠nán tala̠­ka­lhí̠n. Y chiné huá­nilh a̠má ta̠tatlá: ");
INSERT INTO tocNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Huix cuaniyá̠n, cata̠qui, casacti mim­pu̠­chexni y capit nac mín­chic. ");
INSERT INTO tocNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Amá ta̠tatlá pála suacaj tá̠qui̠lh, sacli xpu̠­chexni y táx­tulh. Lhu̠hua hua̠nti̠ antá xta­yá̠­nalh hua̠k taúcxilhli luu xta­li̠­pa̠­xu­hua­má̠­nalh xta­ca̠c­ni̠­na­ni­má̠­nalh Dios, y chiné xta­huán: —Ne̠cxni a̠ xuc­xi­lhá̠hu la̠ta tu̠ ucxilh­ma̠­náhu la̠nchú. ");
INSERT INTO tocNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Aca­li̠stá̠n Jesús ampá nac xquilhtú̠n pupunú xalac Gali­lea, antá talák­cha̠lh lhu̠hua cris­tianos y xlá tzú­culh ca̠ma̠­kalh­chu­hui̠ni̠y. ");
INSERT INTO tocNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Acxni̠ aya xqui̠­tas­pitma úcxilhli xka­huasa Alfeo xuanicán Leví, xlá xuí nac xtan­quilhtí̠n chiqui xca̠­ma̠­ta̠ji̠y hua̠nti̠ xta­la­ka­xo­ko̠­nuniy gobier­no xalac Roma, y chiné huá­nilh: —Caquis­ta̠­lani. Leví la̠li̠­huán suacaj tá̠yalh y sta̠­lá­nilh. ");
INSERT INTO tocNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Aca­li̠stá̠n Jesús alh hua̠yán nac xchic Leví xlá ca̠tá̠alh xdis­cí­pulos; antaní ca̠ma̠­huí̠­calh na̠ támilh tahua̠yán lhu̠hua xma̠­ta̠­ji̠­naní̠n im­pues­tos xa̠hua a̠maka­pi­tzí̠n hua̠nti̠ xta­lac­pu­huaniy judíos pi̠ maktum xta­lak­tzan­ka̠­ta̠­yani̠t, y ni̠tu̠ xca̠­liucxilhcán; porque cani̠huá antaní xla­pu̠lay Jesús huá eé lac­chix­cu­huí̠n hua̠n­ti̠cu xta­sta̠­laniy. ");
INSERT INTO tocNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Maka­pi­tzí̠n xma̠­kalh­ta­hua­ke̠­nacán judíos xa̠hua fariseos acxni̠ taúcxilhli pi̠ Jesús pu̠tum xca̠­ta̠­hua̠­yama a̠ma̠ko̠lh lac­chix­cu­huí̠n chiné tahuá­nilh xta­ma̠­kalh­ta­huaké̠n: —Chí la̠ a̠má mima̠­kalh­ta­hua­ke̠­nacán, ¿lácu ca̠li̠­ta̠­hua̠­yama xma̠­ta̠­ji̠­naní̠n im­pues­tos xa̠hua mak­la̠­ka­lhi̠­naní̠n lac­chix­cu­huí̠n? ");
INSERT INTO tocNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Acxni̠ ca̠ka­lha­káx­matli Jesús hua̠ntu̠ xta­qui­lhuamá̠­nalh ca̠huá­nilh: —Ni̠ tamac­la­cas­quín doctor hua̠nti̠ ni̠ ta̠tatlay sino hua̠nti̠ taja­tatlay. Aquit ni̠ cmini̠t ca̠huaniy nata­lak­pali̠y xla­ta­ma̠tcán hua̠nti̠ tapu­huá̠n lac­tlá̠n cris­tianos sino hua̠nti̠ mak­la̠­ka­lhi̠­naní̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Maktum quilh­ta­macú acxni̠ xta­ma̠­kalh­ta­huaké̠n Juan xa̠hua xlacán fariseos xta­la­ka­chix­cu­hui̠­má̠­nalh Dios y xta­kalh­xtek­nini̠t, maka­pi­tzí̠n cris­tianos talák­milh Jesús y chiné taka­lhás­quilh: —¿Túcu xpa̠­la­cata hua̠nti̠ ca̠ma̠­kalh­ta­hua­ke̠ni̠t Juan Bau­tista xa̠hua xta­ma̠­kalh­ta­hua­ke̠ncán fariseos anka­lhi̠ná takalh­xteknín la̠qui̠ nata­la­ka­chix­cu­hui̠y Dios, chi̠nchú hua̠nti̠ huix ca̠ma̠­kalh­ta­hua­ké̠pa̠t ni̠ takalh­xteknín xla­cata nata­la­ka­chix­cu­hui̠nán? ");
INSERT INTO tocNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús ca̠kálh­ti̠lh: —¿Lac­pu­hua­ná̠tit hui­xinín pi̠ tla̠n nata­kalh­xteknín hua̠nti̠ ca̠hua­ni­cani̠t nataán nac aktum pu̠ta­maka­xtokni li̠huán antá ca̠ta̠­láhui a̠má kahuasa hua̠nti̠ tamaka­xtokma? Para ca̠ta̠­láhui tamaka­xtokni ni̠lay nata­kalh­xteknín o ni̠ nata­hua̠yán. ");
INSERT INTO tocNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero nachá̠n quilh­ta­macú acxni̠ nas­puta pu̠pa̠xcua y a̠má kahuasa naán mákat a̠laca­tunu cumu la̠ aquit cama okspulay, entonces xlacán taamá̠­nalh takalh­xteknín ma̠squi ni̠ti̠ caca̠­li̠­ma̠­pék­si̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Porque hua̠nti̠ takax­mata hua̠ntu̠ aquit cli̠­chu­hui̠nán y qui­li̠­pa̠­huán chiné qui̠­taxtuy; ni̠ anán cris­tianos ti̠ nalak­tzapay mactum lakuán ves­tido y nali̠­lak­tzapay actzú xasa̠sti lháka̠t, porque acxni̠ nache­ke̠cán a̠má lháka̠t, xasa̠sti nataaktumi̠y y li̠huaca nax­ti̠ta xala­kuán y a̠tzinú tlak lanca natax­ti̠ta y ni̠chuná la̠ xuani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Y na̠chuna li̠túm ni̠ti̠ pu̠maju̠y xas­kata pulque nac xala­kuán xmak­xu̠hua bor­rego, porque xasa̠sti pulque tzucuy catlán y ma̠pankay xmak­xu̠hua bor­rego, pus caj lak­tzanka̠y pulque xa̠hua xu̠hua. Por eso maju̠cán xas­kata pulque nac xasa̠sti xmak­xu̠hua bor­rego. ");
INSERT INTO tocNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Maktum quilh­ta­macú acxni̠ ni̠ti̠ cscuja Jesús xti̠­pun­tax­tuma aktum ca̠tu­huá̠n anta­nícu chan­cani̠t trigo, y xdis­cí­pulos tzú­culh tai̠ti̠­lhay xta­huácat. ");
INSERT INTO tocNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Acxni̠ xta­ti̠­pun­tax­tu­má̠­nalh maka­pi­tzí̠n lac­chix­cu­huí̠n ca̠hua­nicán fariseos chiné tali̠­huá­nilh: —Amá, ¿túcu xpa̠­la­cata tali̠i̠má̠­nalh trigo min­ta­ma̠­kalh­ta­huaké̠n acxni̠ ni̠ti̠cu scuja? ");
INSERT INTO tocNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Pero Jesús chiné ca̠kálh­ti̠lh: —¿Pi̠ ne̠cxni a̠li̠kalh­ta­hua­ka­yá̠tit hui­xinín nac li̠kalh­ta­huaka pi̠ maká̠n acxni̠ xapuxcu cura xuani̠t Abiatar, maktum quilh­ta­macú rey David xca̠­ta̠­tzin­c­sni̠ma xcompañeros pus xlá tánu̠lh nac pu̠si­culan y ca̠tá̠­hualh xcompañeros xta­si­cu­la­na̠t­láhu cax­ti­lá̠n­chahu hua̠ntu̠ ni̠ xli̠­huatcán xuani̠t, porque caj xma̠n curajni xli̠­huatcán xuani̠t? ");
INSERT INTO tocNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesús chiné ca̠hua­nipá: —Eé quilh­ta­macú acxni̠ jaxcán ca̠li̠­ma̠x­qui̠­cani̠t cris­tianos la̠qui̠ naca̠­li̠­ma­cuaniy, y ni̠ huá̠ ca̠li̠­ma̠x­qui̠­cani̠t xla­cata caj nata­li̠­pa̠­ti̠nán. ");
INSERT INTO tocNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Por eso aquit Xata­lac­sacni Chixcú nac­ca̠­huaniy cris­tianos hua̠ntu̠ tlak naca̠­li̠­ma­cuaniy eé quilh­ta­macú acxni̠ jaxcán. ");
INSERT INTO tocNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Maktum quilh­ta­macú Jesús tanu̠pá nac aktum xpu̠­ta­mak­stok­nicán judíos hua̠ntu̠ hua­nicán sina­goga, antá xlahui cha̠tum chixcú ti̠ csca̠c­ni­ko̠ni̠t xmacán. ");
INSERT INTO tocNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Pero maka­pi­tzí̠n fariseos luu xta­quic­lhca­tzaniy Jesús y xlacán xtas­ka­laj­má̠­nalh para tícu nama̠t­la̠nti̠y a̠má quilh­ta­macú acxni̠ li̠huancán para tícu nas­cuja, la̠qui̠ huij nahuán tu̠ nata­li̠­ya̠­huay y tla̠n nata­ma̠­la­capu̠y. ");
INSERT INTO tocNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Pero Jesús aya xca­tzi̠y túcu xlacán xta­la­ca­pa̠s­tac­má̠­nalh y chiné huá­nilh a̠má chixcú hua̠nti̠ csca̠c­ko̠ni̠t xmacán: —Catat y uú cala­can­ta̠ya. ");
INSERT INTO tocNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Y chiné ca̠ka­lhás­quilh xa̠maka­pi­tzí̠n hua̠nti̠ xta­quic­lhca­tzaniy: —¿Túcu hui­xinín puhua­ná̠tit a̠tzinú tla̠n tla­huacán eé quilh­ta­macú acxni̠ li̠huancán tícu nas­cuja, pi̠ hua̠ntu̠ tla̠n osuchí hua̠ntu̠ ni̠tlá̠n? Para cha̠tum chixcú amajá ni̠y, ¿pi̠ tla̠n mak­ta̠­ya­nicán xli̠s­tacni, osuchí calak­tzan­ka̠­ke̠lh ma̠squi ni̠ti̠ camak­tá̠­yalh? ");
INSERT INTO tocNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Pero xlacán cacs tatá̠­yalh ni̠tu̠ takalh­tí̠­nalh. Jesús sí̠tzi̠lh pero xca̠­lak­li̠­pu­hua­la­ca̠ma porque xlacán ni̠ xtaaka­ta̠k­sputún pi̠ a̠tzinú li̠mac­uán naca̠­mak­ta̠­yacán cris­tianos la̠ta túcuya̠ quilh­ta­macú. Chiné hua­nipá a̠má chixcú: —Cas­tonkti mimacán. Amá chixcú stonkli xmacán y tuncán cá̠x­lalh la̠ta xmaca­sca̠cni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Fari­seos pála tatáx­tulh y tzú­culh tali̠­ta̠­lac­chu­hui̠nán a̠ma̠ko̠lh hua̠nti̠ xta­ta̠­yá̠­nalh Herodes lácu natat­la­huay la̠quí̠ nata­makni̠y Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Pero Jesús tatam­pú̠x­tulh ca̠tá̠alh xdis­cí­pulos nac xquilhtú̠n pupunú, lhu̠hua lac­chix­cu­huí̠n xalac Gali­lea ta­sta̠­lá­nilh. ");
INSERT INTO tocNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Acxni̠ catzí̠­calh la̠ta xlá xca̠­ma̠t­la̠nti̠y ta̠tat­laní̠n y lácu xtla­huay lac­lanca li̠cá̠cni̠t ta­scújut, lhu̠hua cris­tianos talák­milh xalac Judea, xalac Jeru­salén, xalac Idumea, chu hua̠nti̠ xta­la­ma̠­nanchá a̠li̠quilh­tu̠án kalh­tu̠­choko Jordán, chu xalac Tiro y Sidón, támilh takax­matniy hua̠ntu̠ xlá nahuán y hua̠ntu̠ nat­la­huay xta­scújut. ");
INSERT INTO tocNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Y Jesús ca̠huá­nilh xta­ma̠­kalh­ta­huaké̠n xla­cata nali̠­ka­lhi̠cán aktum barco nac xquilhtú̠n chú­chut antaní nataju̠y para taji̠ nata­toklha xli̠­lhu̠hua cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Porque lhu̠hua ta̠tat­laní̠n hua̠nti̠ xlá xca̠­ma̠t­la̠n­ti̠ni̠t y pu̠tum xta­lak­ta­la­ca­tzu­hui̠­putún la̠qui̠ nata­qui̠­xamay. ");
INSERT INTO tocNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Y hua̠nti̠ xca̠­ka­lhi̠y xes­pí­ritu akska­huiní, acxni̠ xtaucxilha Jesús xlacán xta­la­ka­ta­tzo­kostay y chiné xta­tasay: —Huix Xka­huasa Dios. ");
INSERT INTO tocNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero Jesús xca̠­ma̠­quilh­cacsay la̠qui̠ ni̠ nata­huán tícuya̠ chixcú xuani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Aca­li̠stá̠n Jesús tala­ca̠c­xtu­táhui nac aktum ke̠stí̠n y antá ca̠ta­sá­nilh ca̠ma̠­ké̠s­tokli maka­pi­tzí̠n lac­chix­cu­huí̠n hua̠nti̠ xlá xla­cas­quín, y hua̠nti̠ talák­milh ");
INSERT INTO tocNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ca̠lí̠lh­ca̠lh kalha­cu̠tiy hua̠nti̠ luu naca̠­ta̠­la­ta­pu̠li̠y y naán ca̠ma̠s­cujuy nata­li̠­chu­hui̠nán lácu Dios lacas­quín nata­la­tama̠y cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Y xlá ca̠má̠x­qui̠lh li̠ma̠­peksí̠n chu li̠t­li­hueke la̠qui̠ tla̠n nata­ta­mac­xtuy xes­pí­ritu akska­huiní hua̠nti̠ ca̠maka­tla­jani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Huá u̠ma̠ko̠lh xta­cu­hui­nicán hua̠nti̠ ca̠lac­sác­calh: Simón hua̠nti̠ xlá li̠ma̠­pa̠­cú­hui̠lh Pedro; xawa xtala Andrés, ");
INSERT INTO tocNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","San­tiago xa̠hua Juan xca­maná̠n Zebedeo, hua̠nti̠ xlá ca̠li̠­ma̠­pa̠­cú­hui̠lh Boanerges, eé tachu­huí̠n huam­putún Xcamán Jili; ");
INSERT INTO tocNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bar­to­lomé, Mateo chu Tomás; San­tiago xka­huasa Alfeo; chu Tadeo; Xa̠hua Simón, eé chixcú xapu̠lh xca̠­ta̠­ta­peksi̠y maka­pi­tzí̠n lac­chix­cu­huí̠n xca̠­hua­nicán cana­nistas; ");
INSERT INTO tocNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","xa̠hua Judas Isca­riote hua̠nti̠ aca­li̠stá̠n maca­má̠s­ta̠lh Quim­pu̠­chi­nacán Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Aca­li̠stá̠n Jesús alh ca̠ta̠­lak­tun­cu­huiy xdis­cí­pulos nac aktum chiqui antaní xta­ta­mak­xteka, luu lhu̠hua li̠tum tas­tok­pa­raca y niaj xta­ka­lhi̠y quilh­ta­macú nata­hua̠yán. ");
INSERT INTO tocNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Acxni̠ tacá­tzi̠lh xli̠­ta­la­ka­pasni Jesús hua̠ntu̠ xtla­huama talák­milh xla­cata natalé̠n, porque xuancán pi̠ caj xla­ka­hui­tima. ");
INSERT INTO tocNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Y na̠chuná xma̠­kalh­ta­hua­ke̠­nacán judíos hua̠nti̠ xta­mi­ni̠­tanchá nac Jeru­salén chiné xta­huán: —Eé chixcú huá ta̠s­cujma Beel­zebú xapuxcu diablo, y caj xli̠t­li­hueke Beel­zebú ca̠li̠­ta­mac­xtuy xes­pi­ri­tucán akska­huiní. ");
INSERT INTO tocNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Pero Jesús ca̠huá­nilh cata­ta­la­ca­tzú­hui̠lh y tzú­culh ca̠li̠­xa­katli̠y aktum takalh­chu­huí̠n y chiné ca̠huá­nilh: —¿Lácu hui­xinín lac­pu­hua­ná̠tit pi̠ hua̠nti̠ ta̠s­cujma akska­huiní pi̠ tla̠n ta̠la̠­ma­ka­si̠­tzi̠y hua­ti­ya­li̠túm akska­huiní? ");
INSERT INTO tocNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","La̠ta tu̠ aquit qui­la̠­li̠­ya̠­hua­yá̠hu chiné qui̠­taxtuy: para aktum ca̠chi­quí̠n pu̠tum cris­tianos caj tzucuy tala̠­ma­ka­si̠­tzi̠­ta­huilay y tala̠­ta̠­ra̠t­la­huay, a̠má ca̠chi­quí̠n ni̠lay maka̠s cati­ta­pá­lhi̠lh porque cris­tianos nata­ta̠­ka­hua­niko̠y. ");
INSERT INTO tocNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Y chu­na­li̠tum para nac aktum chiqui antaní pu̠tum tahui­lá̠­nalh xla­ka­huasán cha̠tum chixcú, pero xlacán caj natzucuy tala̠­ma­ka­si̠­tzi̠­ta­huilay, pus xlacán ni̠lay cati­ta­ta­pá­lhi̠lh porque pálaj nata­la̠­ta­mac­xtuy. ");
INSERT INTO tocNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Pus huá cca̠­li̠­hua­niyá̠n para akska­huiní nata­ta­paj­pi­tziy y nata­tzucuy la̠la­ca­ta̠­qui̠y sac­stucán ni̠lay maka̠s cati­ta­ta­pá­lhi̠lh sinoque antá nata­lak­sputa. ");
INSERT INTO tocNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Ni̠lay mak­ka­lha̠­nancán cha̠tum tli­hueke chixcú para ni̠ pu̠lh namaka­tla­jacán y nachi̠­hui­li̠cán y acxni̠ aya makat­la­ja­cani̠t tla̠n tanu̠cán nac xchic y mak­ka­lhan­ko̠cán la̠ta tu̠ kalhi̠y, y na̠chuná la̠ ctla­huani̠t akska­huiní. ");
INSERT INTO tocNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ Dios tla̠n ca̠ma̠­tzan­ke̠­naniy cris­tianos hua̠k xta­la̠­ka­lhi̠ncán, y na̠chuná para túcu tali̠­qui­lhán ni̠ lac­tlá̠n tachu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero hua̠nti̠ cala̠huá nali̠­kalh­ka­ma̠nán hua̠ntu̠ xlá luu laca­tancs catzi̠y pi̠ hua̠ xta­scújut Espíri­tu Santo xlá ni̠lay cati­ma̠­tzan­ke̠­na­ní­calh xta­la̠­ka­lhí̠n sinoque cane̠c­xni­cahuá xlá le̠n xcuenta. ");
INSERT INTO tocNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Huá chuná ca̠li̠­huá­nilh porque xlacán xta­qui­lhuamá̠­nalh pi̠ xlá xka­lhi̠y xes­pí­ritu akska­huiní. ");
INSERT INTO tocNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Y na̠ acxni­tiyá tachilh xtzí Jesús xa̠hua xna­ta̠lán, pero xlacán quilhtí̠n tatá̠­yalh y caj tama̠­ta­sa­ní̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Y hua̠nti̠ antá acxtum xta­ta̠­hui­lá̠­nalh antaní xlá xuí Jesús chiné tahuá­nilh: —Tapu­tzamá̠n mintzí xa̠hua mili̠­ta­la­ka­pasni, antá taya̠­nanchá quilhtí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pero xlá chiné ca̠huá­nilh: —¿Tícu quintzí, y tícu qui­na­ta̠lán? ");
INSERT INTO tocNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Y pu̠tum ca̠la­caucxilh­ko̠lh hua̠nti̠ antá xta­hui­lá̠­nalh, chiné chu­hui̠­nampá: —Huá u̠ma̠ko̠lh quintzí xa̠hua qui­na­ta̠lán. ");
INSERT INTO tocNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Porque la̠ta tícuya̠ cris­tiano hua̠nti̠ tat­la­huay xta­pa̠­xu­huá̠n Dios huá tama̠­ko̠lh quintzí xa̠hua qui­na­ta̠lán. ");
INSERT INTO tocNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesús tzu­cupá ca̠ma̠­kalh­chu­hui̠ni̠y cris­tianos nac xquilhtú̠n pupunú y luu lhu̠hua tas­tók­calh antaní xlá xuí. Pus huá Jesús li̠tá­ju̠lh nac aktum barco hua̠ntu̠ antá xuí nac xquilhtú̠n chú­chut, xlá antá culucs táhui y pu̠tum cris­tianos tatáhui nac xquilhtú̠n chú­chut. ");
INSERT INTO tocNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Xlá tzú­culh ca̠li̠­ma̠­kalh­chu­hui̠ni̠y cris­tianos caj la̠ lactzu cuento la̠qui̠ hua̠k nataaka­ta̠ksa hua̠ntu̠ xca̠­huaniy, chiné ca̠ta̠­chu­huí̠­nalh: ");
INSERT INTO tocNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Luu caaka­tá̠k­stit hua̠ntu̠ nac­ca̠­li̠­xa­kat­li̠yá̠n: Maktum quilh­ta­macú xuí cha̠tum cha­na̠ná xlá alh chan xatalhtzi xli̠­chánat. ");
INSERT INTO tocNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Y acxni̠ cxpu­yu­ti̠­lhay xtalhtzi xli̠­chánat maka­pitzi tama̠chá nac tiji, taminchá lactzu spitu y tasa­cuaqui̠­ko̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Hua̠ntu̠ tama̠chá xli̠­chánat nac ca̠chi­huixni anta­nícu ni̠ lhu̠hua xka­lhi̠y tíyat pálaj pulhli. ");
INSERT INTO tocNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pero acxni̠ táx­tulh chi­chiní na̠ pálaj sca̠cli porque ni̠ pu̠lhmá̠n xta­ma̠­tzan­ke̠ni̠t xtan­ka­xe̠kcán. ");
INSERT INTO tocNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Lhu̠hua xli̠­chánat tata­ma̠chá nac ca̠lh­tu­cuní̠n y ni̠ maka̠s quilh­ta­macú a̠má tachaná̠n lak­pun­ko̠lh, pero a̠tzinú lhtucú̠n pálaj stacli, aklhtu­lu­mi̠­ko̠lh y ni̠ má̠x­qui̠lh quilh­ta­macú natas­taca. ");
INSERT INTO tocNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pero maka­pi­tzí̠n xli̠­chánat tata­ma̠chá nac xatlá̠n tíyat y luu tla̠n tás­tacli lactzu li̠chánat y lhu̠hua tamá̠s­ta̠lh xta­hua­catcán. Huí tu̠ má̠s­ta̠lh puxa­ma­cá̠hu xtalhtzi caj akatum, y huí tu̠ má̠s­ta̠lh tutum­puxám, y maka­pitzi aktum ciento. ");
INSERT INTO tocNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Entonces xlá chiné ca̠huá­nilh: —Hua̠nti̠ taka­lhi̠y xta­ke̠ncán cata­káx­matli quin­ta­chu­huí̠n y cataaká­ta̠ksli. ");
INSERT INTO tocNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Acxni̠ ca̠ta sac­stucán tata­mák­xtekli Jesús xa̠hua xdis­cí­pulos y maka­pi­tzí̠n hua̠nti̠ anka­lhi̠ná xca̠­ta̠­lat­la̠­huán xlacán talak­ta­la­ca­tzú­hui̠lh y taka­lhás­quilh túcu xuamputún a̠má takalh­chu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesús chiné ca̠huá­nilh: —Xli̠­ca̠na, hui­xinín Dios ca̠ma̠aka­ta̠k­sni̠­pu­tuná̠n lácu xlá lacas­quín cata­la­tá­ma̠lh cris­tianos hua̠nti̠ nata­pek­si̠niy, pero huá la̠ta xli̠­maka­pi­tzí̠n cris­tianos ma̠squi cca̠­ta̠­ma̠­la­cas­tucniy hua̠ntu̠ xlacán tala­ka­pasa ni̠para chuná cati­ta­lac­pú­tzalh la̠ta nataaka­ta̠ksa. ");
INSERT INTO tocNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Y chuná ma̠squi lhu̠hua hua̠ntu̠ cataúcxilhli tu̠ aquit cca̠t­la­huay, nata­ta­mak­xteka caj lá̠m­para ni̠tu̠ taúcxilhli; ma̠squi caquin­ta­ka­lha­káx­matli hua̠ntu̠ cchu­hui̠­nama ni̠tu̠cu cati­taaká­ta̠ksli. Y para ni̠ nata­ca̠­najlay la̠ta lácu Dios ca̠li̠­xa­katli̠y xta­la­ka­lha­maní̠n xlá ni̠lay cati­ca̠­ma̠­tzan­ke̠­ná­nilh xta­la̠­ka­lhi̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Y Jesús ca̠hua­nipá hua̠nti̠ taka­lhás­quilh: —Para hui­xinín ni̠ aka­ta̠k­sá̠tit eé xata­kalh­chu­huí̠n cha­na̠ná hua̠ntu̠ ni̠para tuhua, ¿pi̠ li̠huacá chú naaka­ta̠k­sá̠tit xa̠maka­pitzi takalh­chu­huí̠n hua̠ntu̠ nac­ti­ca̠­hua­ni­ya̠ncú aca­li̠stá̠n? ");
INSERT INTO tocNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Amá chixcú hua̠nti̠ alh chan xli̠­chánat xta̠­chuná qui̠­taxtuy hua̠nti̠ liakchu­hui̠nán xta­chu­huí̠n Dios. ");
INSERT INTO tocNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Amá tachaná̠n hua̠ntu̠ tata­ma̠chá nac tiji tali̠­taxtuy cumu la̠ cris­tianos hua̠nti̠ takax­mata xta­chu­huí̠n Dios, pero mina̠chá akska­huiní y ma̠ta­ke̠­nu̠ko̠y a̠má tachu­huí̠n hua̠ntu̠ xchan­cani̠t nac xna­cujcán. ");
INSERT INTO tocNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Amá li̠chánat hua̠ntu̠ tata­ma̠chá nac ca̠chi­huixni na̠chuná tali̠­taxtuy cris­tianos acxni̠ takax­mata xta­chu­huí̠n Dios, luu tala­kati̠y y tali̠­pa̠­huán Dios. ");
INSERT INTO tocNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero cumu ni̠ pu̠lhmá̠n xka­lhi̠y xtan­káxe̠k ni̠ ta̠yá­nilh acxni̠ para túcu ca̠liok­spulay osuchí ca̠liaksancán pi̠ tali̠­pa̠­huán Dios o ca̠li̠­pu­tza­sta̠­lacán, xlacán tali̠­pu­huán y tali̠­mak­xtek­ta̠yay. ");
INSERT INTO tocNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Amá li̠chánat hua̠ntu̠ tata­ma̠chá nac ca̠lh­tu­cuní̠n, na̠chuná tali̠­taxtuy cris­tianos hua̠nti̠ takax­mata xta­chu­huí̠n Dios, ");
INSERT INTO tocNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pero cumu tla̠n cxla­ta­ma̠tcán a̠tzinú taliaka­tiyún xtu­mi̠ncán y la̠ta túcu tala­kati̠y, chuná taliak­lhtu­lumi̠y xta­ca̠­naj­latcán y ni̠ ca̠ma̠x­qui̠y quilh­ta­macú nata­ma̠sta̠y xta­hua­catcán. ");
INSERT INTO tocNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Amá li̠chánat hua̠ntu̠ tata­ma̠chá nac xatlá̠n tíyat y tamá̠s­ta̠lh xta­hua­catcán tali̠­taxtuy cris­tianos hua̠nti̠ takax­mata xta­chu­huí̠n Dios, taca̠­najlay, tali̠­pa̠­huán y talak­tzaksay tali̠s­cuja nac xla­ta­ma̠tcán, chuná tama̠sta̠y xta­hua­catcán: hui̠ntú tama̠sta̠y puxa­ma­cá̠hu y hui̠ntú tama̠sta̠y tutum­puxam osu aktum ciento caj la̠ta cha̠­tunu cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Y Jesús ca̠hua­nipá: —¿Lácu hui­xinín catzi̠­yá̠tit, pi̠ hua̠nti̠ kalhi̠y aktum lám­para pi̠ caj la̠ nama̠­pasi̠y nata­macnu̠y nac xtampí̠n xpu̠­tama? ¿Osuchí naliakpu­lon­kxuili̠y aktum cajón? Pus hua̠nti̠ kalhi̠y aktum lám­para huata huili̠y ta̠lhmá̠n la̠qui̠ mákat namak­skoy. ");
INSERT INTO tocNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Na̠chuná ni̠lay túcu tze̠k tla­huacán para ni̠ juerza nata­siyuy laka­siyu, y hua̠ntu̠ caj tze̠k li̠ca­tzi̠cán para ni̠ ca̠la­kuá̠n nata­mak­xteka. Para aktum quin­ta­chu­huí̠n ni̠lay aka­ta̠k­sá̠tit namín quilh­ta­macú acxni hua̠k naaka­ta̠k­sá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Huá xpa̠­la­cata cca̠­li̠­hua­niyá̠n, para hui­xinín kalhi̠­yá̠tit min­ta­ke̠ncán caaka­tá̠k­stit quin­ta­chu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesús ca̠hua­nipá: —Li̠huana̠ caaka­tá̠k­stit hua̠ntu̠ kax­pat­pá̠tit porque chuná la̠ lacas­qui­ná̠tit xtat­lá­hualh cris­tianos mila­ca­tacán na̠chuná la̠ la̠mak­ta̠­ya­yá̠tit, pus na̠chuná Dios ca̠li̠­ka­lhi̠má̠n hui­xinín hua̠nti̠ kax­pat­pá̠tit xta­chu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Pus hua̠nti̠ lak­tzaksay aka­ta̠ksa a̠má xatlá̠n tala­ca­pa̠s­tacni hua̠ntu̠ kalhi̠y a̠tzinú nama̠x­qui̠­cancú; pero hua̠nti̠ ni̠ lak­tzak­sa­putún aka­ta̠ksa hua̠ntu̠ kalhi̠y xlá namak­lhti̠­ko̠cán hasta ma̠squi caj xma̠nhuá hua̠ntu̠ kalhi̠y. ");
INSERT INTO tocNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesús chiné ca̠hua­nipá: —Xta­péksi̠t Dios na̠ chiné qui̠­taxtuy cumu la̠ cha̠tum chixcú ti̠ án chán xtalhtzi xli̠­chánat nac xpu̠­cuxtu. ");
INSERT INTO tocNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Aca­li̠stá̠n xlá án nac xchic la̠qui̠ najaxa y nalh­tatay. Maka̠s quilh­ta­macú nala­ca­tza̠lay y a̠má li̠chánat lakpún, pulha, pero xlá ni̠ catzi̠y lácu stacma porque huá tíyat ma̠s­ta­cama. ");
INSERT INTO tocNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Amá li̠chánat lakpún, pulha, tax­tuniy xtan­káxe̠k, staca, xana̠y y aca­li̠stá̠n ma̠sta̠y xta­huácat. Pero eé tachaná̠n hua̠k ctíyat tíyalh hua̠ntu̠ lí̠s­tacli osu li̠la­tama̠y. ");
INSERT INTO tocNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Pero acxni̠ lak­chá̠n xquilh­ta­macú la̠ta cat­lani̠t huata án í̠y xta­huácat xta­chaná̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesús huampá: —¿Lácu lac­pu­hua­ná̠tit ámaj tzucuy xta­péksi̠t Dios uú nac ca̠quilh­ta­macú? Osuchí ¿túcuya̠ takalh­chu­huí̠n tla̠n ta̠ma̠­lacx­tu­mi̠­yá̠hu? ");
INSERT INTO tocNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Xta̠­chuná ámaj tzucuy cumu la̠ xtalhtzi mos­taza acxni̠ chancán nac tíyat. Eé li̠chánat huá a̠tzinú tlak lactzú xatalhtzi quihui nícuma̠ laca­pálaj staca y lanca quihui huan. ");
INSERT INTO tocNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero acxni̠ chancán xlá tzucuy staca y luu ta̠lhmá̠n huan; y ni̠tu̠cu maka­lak­chá̠n, y hasta luu lac­lhmá̠n xmak­xpi̠ní̠n tax­tuniy, pus hasta lactzu spitu tla̠n tat­la­huay antá xma̠­se­kecán nac xakán y catu̠­huaj lactzu spu̠n antá tajaxa. ");
INSERT INTO tocNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Y Jesús anka­lhí̠n xca̠­li̠­ma̠­kalh­chu­hui̠ni̠y cris­tianos caj la̠ cuento nac xta­kalh­chu­huí̠n la̠qui̠ hua̠k nataaka­ta̠ksa hua̠ntu̠ xca̠­hua­ni­putún. ");
INSERT INTO tocNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Xlá ni̠tu̠ xca̠­li̠­ta̠­chu­hui̠nán para ni̠ juerza naca̠­ta̠­ma̠­lac­xtu­mi̠niy hua̠ntu̠ xlacán xta­la­ka­pasa; y para xdis­cí­pulos ni̠ hua̠k xtaaka­ta̠ksa aca­li̠stá̠n xlá xca̠­ma̠­lac­ti̠­tu­mi̠niy hua̠ntu̠ xca̠­hua­ni­putún. ");
INSERT INTO tocNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Amá quilh­ta­macú acxni̠ aya tzí̠­sualh chiné ca̠huá­nilh xdis­cí­pulos: —Caáhu a̠li̠quilh­tu̠tu pupunú. ");
INSERT INTO tocNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Pero lhu̠hua cris­tianos tata­mák­xtekli nac xquilhtú̠n chú­chut, xta­ma̠­kalh­ta­huaké̠n tatá­ju̠lh nac barco antaní xta­ju̠ma Jesús hua̠ntu̠ aya xli̠­kalh­ka­lhi̠­má̠­calh. Maka­pitzi barcos na̠ ta­sta̠­lá­nilh antaní xama Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Xlá alh nac xtanké̠n barco y tíyalh aktum acxtícat y antá táma̠lh la̠qui̠ nalh­tatay. Pero caj li̠puntzú také̠­talh palha u̠n, tzú­culh ta̠ke­ya̠­huay pupunú, taju̠­ko̠lh chú­chut nac barco a̠actzú ni̠ tatzá­malh. Entonces xdis­cí­pulos táalh tama̠­la­ka­hua̠ni̠y y chiné tahuá­nilh: —Ma̠kalh­ta­hua­ke̠ná, cata̠qui. ¿Lácu pi̠ ni̠ min­cuenta huix xla­cata ama̠­náhu mu̠x­tu­yá̠hu? ");
INSERT INTO tocNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesús tá̠qui̠lh, li̠ma̠­pék­si̠lh catá­cacsli u̠n y chiné huá­nilh pupunú: —¡Cacs cata­huila y niaj cata̠­ke­ya̠hua! Amá u̠n xa̠hua pupunú cacs tata­hui­la­ko̠lh y ca̠tzi­yan­csuanan­ko̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesús chiné ca̠huá­nilh xta­ma̠­kalh­ta­huaké̠n: —¿Túcu xpa̠­la­cata ma̠rí li̠pe̠­cuaná̠tit? ¿Nícu chú álh mili̠­ca­ma­macán, chi̠nchú hua­ná̠tit pi̠ qui­la̠­li̠­pa̠­hua­ná̠hu? ");
INSERT INTO tocNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pero xlacán caj cacs xta­la­ca­huan­ko̠ni̠t porque luu la̠n xca̠­ma­ke̠k­lhani̠t hua̠ntu̠ xtla­huani̠t Jesús y xma̠n huá tla̠n chiné xta­la̠­huaniy sac­stucán: —¿Tícu cahuá eé chixcú hua̠nti̠ ta̠la­pu̠­la­yá̠hu, pus hasta ca̠ma̠­peksi̠y u̠n xa̠hua pupunú y xlacán taka­lha­kax­mata? ");
INSERT INTO tocNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ni̠ xli̠­maka̠s tácha̠lh nac aktum ca̠chi­quí̠n hua­nicán Gadara a̠li̠quilh­tu̠tu pupunú. ");
INSERT INTO tocNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Lá tacutli Jesús nac barco lák­milh cha̠tum chixcú hua̠nti̠ xak­chi­pa­ni­ko̠ni̠t xta­la­ca­pa̠s­tacni akska­huiní. ");
INSERT INTO tocNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Amá chixcú xlá xca̠­ta­sa­pu̠lay nac ca̠pú̠­sa̠ntu y luu li̠xcáj­nit xli̠­ca­tzi̠y ni̠ti̠ lay xmaka­tlajay xla­cata nachi̠­hui­li̠cán. ");
INSERT INTO tocNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mak­lhu̠hua tzak­sá­calh li̠lac­chí̠­calh cadena nac xtantú̠n xa̠hua cxmacán pero xlac­putxa y ni̠tu̠ xca̠­liucxilha. ");
INSERT INTO tocNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tan­tacú tan­tas­caca xta­sa­ta­pu̠li̠y nac ca̠ke̠s­ti̠ní̠n xa̠hua ca̠pú̠­sa̠ntu, y sacstu xli̠­ma̠­ta­ke̠­hui̠cán chí­huix. ");
INSERT INTO tocNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Makatcú xmima Jesús acxni̠ úcxilhli, tokosú̠n lák­milh y acxni̠ cha̠lh nícu xuí laka­ta­tzo­kós­talh. ");
INSERT INTO tocNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Pero Jesús li̠ma̠­pék­si̠lh: —Huix xes­pí­ritu akska­huiní, camac­taxtu tamá chixcú. La̠ta xe̠k tásalh chiné kálh­ti̠lh: —Jesús Xka­huasa Dios xala ta̠lhmá̠n, ¿túcu xpa̠­la­cata qui­la̠­li̠­pek­ta­nu̠­yá̠hu? Lanca li̠tlá̠n cca̠s­qui­niyá̠n ni̠ naqui­la̠­ma̠­pa̠­ti̠­ni̠­yá̠hu. ");
INSERT INTO tocNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesús kalhás­quilh: —¿Túcu hua­ni­cana? Amá xes­pí­ritu akska­huiní chiné kalh­tí̠­nalh: —Cli̠­ta­pa̠­cu­hui̠­yá̠hu Legión porque qui­lhu̠­huacán hua̠nti̠ cmac­ta­nu̠­ma̠­náhu eé chixcú. ");
INSERT INTO tocNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Luu lanca li̠tlá̠n tas­quí­nilh Jesús xla­cata ni̠ naca̠­macá̠n a̠laca­tunu pu̠la­tama̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Y antá lacatzú nac ke̠stí̠n xta­la­pu̠lay ma̠x cumu aktiy mi̠lh paxni, ");
INSERT INTO tocNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","acxni̠ taúcxilhli a̠ma̠ko̠lh xes­pí­ritu akska­huiní luu lanca li̠tlá̠n tas­quí­nilh Jesús y chiné tahuá­nilh: —Caqui­la̠­ma̠x­quí̠hu quilh­ta­macú nac­ta­nu̠­yá̠hu nac a̠ma̠ko̠lh paxni tala­yá̠­nalh tanú lacatzú. ");
INSERT INTO tocNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesús ca̠má̠x­qui̠lh quilh­ta­macú, y a̠ma̠ko̠lh xes­pí­ritu akska­huiní antá tamac­tá­nu̠lh. Pero a̠ma̠ko̠lh paxni tzú­culh takosnún, táalh nac aktum talhpá̠n, tata­ju̠chá nac chú­chut y antá tajic­suako̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ama̠­ko̠lh hua̠nti̠ xta­mak­ta­kalh­má̠­nalh paxni acxni̠ taúcxilhli lácu tani̠­ko̠lh paxni, tape̠­cuáxni̠lh, takosú̠n tatzá̠­lalh y cani̠huá nac tiji chu nac ca̠chi­quí̠n tali̠­chu­huí̠­nalh hua̠ntu̠ xca̠ok­spu­lani̠t, y lhúhua cris­tianos támilh taucxilha hua̠ntu̠ xlani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Acxni̠ tachilh antaní xyá Jesús, taúcxilhli a̠má chixcú hua̠nti̠ xapu̠lh xka­lhi̠y xes­pí­ritu akska­huiní, antá xlá culucs xuí y niaj xka­lhi̠y li̠xcáj­nit xta­la­ca­pa̠s­tacni. Pero xlacán xta­pe̠­cuaniy. ");
INSERT INTO tocNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Maka­pi­tzí̠n cris­tianos hua̠nti̠ xtaucxilhni̠t a̠má chixcú acxni̠ tamac­táx­tulh xes­pí­ritu akska­huiní y acxni̠ tani̠­ko̠lh a̠má paxni antaní tatá­nu̠lh, tzú­culh tali̠­chu­hui̠nán. ");
INSERT INTO tocNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Pero acxni̠ tla̠n taaká­ta̠ksli hua̠ntu̠ xtla­huani̠t Jesús tzú­culh tahuaniy xla­cata cat­lá­hualh li̠tlá̠n cata­tam­pú̠x­tulh nac xca̠­chi­qui̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Acxni̠ Jesús táju̠lh nac barco, a̠má chixcú hua̠nti̠ xapu̠lh xka­lhi̠y xta­la­ca­pa̠s­tacni akska­huiní chiné huá­nilh: —Cat­lahua li̠tlá̠n, qui­ma̠xqui quilh­ta­macú nac­sta̠­la­niyá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero Jesús ni̠ tla̠n tla­huá­nilh hua̠ntu̠ xmak­squima huata chiné huá­nilh: —Caca̠­lakpi mili̠­ta­la­ka­pasni nac mín­chic, caca̠­li̠­ma̠­kalh­chu­hui̠ni lácu Dios laka­lha­ma­ni̠tán y ma̠pac­sa­ni̠tán. ");
INSERT INTO tocNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Amá chixcú alh, xlá tzú­culh li̠chu­hui̠nán lácu Dios xmak­ta̠­yani̠t, y hua̠nti̠ xta­kax­mata luu xta­ca̠cni̠y Jesús caj xpa̠­la­cata xta­scújut hua̠ntu̠ xlá xca̠t­la­huay, cani̠huá xli̠­chu­hui̠­nancán Jesús antá nac a̠má akcá̠hu ca̠chi­quí̠n xca̠­hua­nicán Decá­polis. ");
INSERT INTO tocNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Acxni̠ Jesús qui̠­tás­pitli a̠li̠quilh­tu̠tu pupunú y tacutli cbarco lhu̠hua cris­tianos tata­mac­xtú­mi̠lh nac xquilhtú̠n chú­chut anta­nícu xlá xlaya, y antá xlá tzú­culh ca̠ma̠­kalh­chu­hui̠ni̠y. ");
INSERT INTO tocNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Caj li̠puntzú chilh cha̠tum xapuxcu ma̠pek­si̠ná xalac xpu̠­si­cu­lancán judíos xuanicán Jairo. Acxni̠ úcxilhli Jesús alh laka­ta­tzo­kostay, ");
INSERT INTO tocNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","y chiné huá­nilh: —Quin­tzuma̠t luu snu̠n ta̠tatlay y amajá ni̠y, cat­lahua li̠tlá̠n caquin­ta̠pi nac quín­chic la̠qui̠ huix naliacchi­paya mimacán, nama̠­pac­saya y li̠pa̠­xúhu nala­tama̠y. ");
INSERT INTO tocNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Pus Jesús tá̠alh pero luu xtza­macán nac tiji hasta xla̠­lak­xqui­ti­ti̠­lhacán. ");
INSERT INTO tocNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Y nac xlak­sti̠pá̠n cris­tianos xmak­mima cha̠tum pusca̠t hua̠nti̠ aya xka­lhi̠y akcu̠tiy ca̠ta la̠ta xta̠­tatlay cstaj­makama kalhni y ne̠cxni cxun­cniy antaní xta­ka̠­hui̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Y lhu̠hua doc­tores xta­cu­chi̠ni̠t pero caj la̠n xta­ma̠­pa̠­ti̠­ni̠ni̠t porque ni̠tu̠cu xtat­la­hua­nini̠t, caj la̠n xta­mak­lhti̠ni̠t xtumi̠n hua̠ntu̠ xlá xka­lhi̠y y li̠huaca xtas­nu̠­ni̠ma. ");
INSERT INTO tocNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Huá xpa̠­la­cata acxni̠ káx­matli la̠ta xli̠­chu­hui̠­nancán Jesús xlá chiné lac­púhua: “Hua­tiyá para xac­qui̠­xa­má­nilh tzinú clháka̠t eé quin­ta­játat ámaj pacsa.” Cumu luu xtza­macán xlá laka­siyu lak­ta­la­ka­tzú­hui̠lh y tze̠k xamá­nilh clháka̠t Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tuncán tachó­kolh xkalhni y mak­lhcá­tzi̠lh pi̠ aya xpac­sni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pero Jesús cátzi̠lh pi̠ xli̠t­li­hueke hua̠ntu̠ xka­lhi̠y xmacni xli̠­pacs­ni̠t cha̠tum. Xlá tala­kás­pitli, tzú­culh laca­pu­tza̠nán antaní xta­yá̠­nalh cris­tianos, y chiné kalhas­qui­ní̠­nalh: —¿Tícu xámalh qui­lháka̠t? ");
INSERT INTO tocNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Xdis­cí­pulos takálh­ti̠lh: —Huix ucxílhpa̠t pi̠ lhu̠hua tza­macán y cati̠huá qui̠­tok­lhmá̠n, todavía kalhas­qui­ni̠­nana: “¿Tícu xámalh qui­lháka̠t?” ");
INSERT INTO tocNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero Jesús lacaxtum xla­ca­pu­tza̠­nama xla­cata nala­ca­maclay tícu cxa­ma­nini̠t clháka̠t y xma̠­pac­sani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Amá pusca̠t xca­tzi̠y pi̠ huá xma̠­pac­sa­cani̠t por eso tzú­culh li̠pe̠­cuán, clhpi­pima tala­ca­tzú­hui̠lh antaní xyá Jesús, tala­ka­ta­tzo­kós­talh nac xla­catí̠n, huá­nilh pi̠ huá cxa­ma­nini̠t clháka̠t y xma̠­pac­sani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús huá­nilh: —Huix pac­sni̠ta porque ca̠naj­la­ni̠ta pi̠ aquit tla̠n nac­ma̠­pac­sayá̠n, li̠pa̠­xúhu capit nac mín­chic porque la̠nchú aya pac­sni̠t min­ta­játat. ");
INSERT INTO tocNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesús chu­nacú xchu­hui̠­nama acxni̠ tachilh maka­pi­tzí̠n cris­tianos xlacán taminchá nac xchic Jairo. Chiné tahuá­nilh xtla̠t a̠má tzuma̠t: —Pun­tzujcú ni̠lh min­tzuma̠t, huata ma̠squi niaj cata̠pi ma̠kalh­ta­hua­ke̠ná Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pero Jesús ni̠ li̠ta̠­ka­tzán­ke̠lh hua̠ntu̠ xlacán xta­qui­lhuamá̠­nalh y chiné huá­nilh Jairo: —Huix chu­nacú caqui­li̠­pá̠­huanti y ni̠ capé̠­cuanti. ");
INSERT INTO tocNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ni̠ lacás­quilh pu̠tum nata­sta̠­laniy sino caj xma̠n Pedro, San­tiago xa̠hua Juan xta̠San­tiago. ");
INSERT INTO tocNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Acxni̠ tácha̠lh nac xchic Jairo, úcxilhli pi̠ lhu̠hua xtza­macán y hua̠k xta­sa­ma̠­kó̠­calh y xta­li̠­pu­hua­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesús tánu̠lh nac chiqui y ca̠huá­nilh: —¿Túcu xpa̠­la­cata li̠ta­sa­pá̠tit y li̠pu­huam­pá̠tit? Pus tamá tzuma̠t caj lhta­tama, ni̠ xaní̠n cumu la̠ hui­xinín lac­pu­hua­ná̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Y huata caj tzú­culh tali̠­li̠­tziyán xta­chu­huí̠n. Jesús ca̠huá­nilh xla­cata pu̠tum cata­táx­tulh, caj xma̠n xtzí xa̠hua xtla̠t a̠má tzuma̠t y hua̠nti̠ xca̠­ta̠­mini̠t ca̠ta̠­tá­nu̠lh antaní xmá a̠má tzuma̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jesús maca­chí­palh a̠má tzuma̠t y huá­nilh: —Talita cumi —u̠má tachu­huí̠n huam­putún: Huix cuanimá̠n, tzuma̠t, cata̠qui. ");
INSERT INTO tocNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Y a̠má tzuma̠t cajcu xak­cu̠tiy ca̠ta xuani̠t, tuncán tá̠qui̠lh y xlá tzú­culh tla̠­huán. Y hua̠nti̠ xtaucxilh­má̠­nalh cris­tianos tzú­culh tapa̠­xu­huay. ");
INSERT INTO tocNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Aca­li̠stá̠n Jesús ca̠li̠­ma̠­pék­si̠lh xnat­la̠tni xla­cata ni̠ nata­li̠­chu­hui̠nán la̠ ma̠la­cas­ta­cuáni̠lh xtzu­ma̠tcán y na̠ ca̠huá­nilh cata­má̠­hui̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Aca­li̠stá̠n Jesús tatam­pu̠x­tupá y ca̠tá̠alh xdis­cí­pulos nac xca̠­chi­quí̠n antaní xlá cstacni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Maktum quilh­ta­macú acxni̠ hua̠k judíos xta­jaxa, Jesús tánu̠lh nac xpu̠­si­cu­lancán y tzú­culh ca̠ma̠­si­yuniy cris­tianos xta­péksi̠t Dios. Hua̠nti̠ xta­kax­mata caj cacs xta­li̠­la­ca­huán xta­chu­huí̠n porque ni̠ xtaaka­ta̠ksa nícu xti­yani̠t tala­ca­pa̠s­tacni. Maka­pitzi chiné tzú­culh tala̠­huaniy: —¿Nícu cahuá catzí̠­nilh pu̠tum a̠má lanca tala­ca­pa̠s­tacni hua̠ntu̠ catzi̠y eé chixcú? ¿Tícu má̠x­qui̠lh li̠s­ka­lala y lácu kálhi̠lh li̠t­li­hueke nali̠t­la­huay lac­lanca ta­scújut hua̠ntu̠ ca̠t­la­huay? ");
INSERT INTO tocNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Pus huá eé car­pin­tero xka­huasa María, y xli̠­ta­la­ka­pasni San­tiago chu José xa̠hua Judas chu Simón, y xli̠­ta­la­ka­pasni lac­tzu­maján na̠ cca̠­la­ka­pa­sá̠hu y antá na̠ uú tahui­lá̠­nalh. Antá nac xca̠­chi­quí̠n chuná xta­lac­pu­huaniy por eso lhu̠hua ti̠ ni̠ taca̠­naj­lá­nilh hua̠ntu̠ xlá xli̠­chu­hui̠­nama. ");
INSERT INTO tocNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesús ca̠huá­nilh: —Pu̠tum cris­tianos tali̠­pa̠­huán cha̠tum chixcú xla­cata naca̠akchu­hui̠­naniy para xala a̠laca­tunu ca̠chi­quí̠n, pero antá xalac xca̠­chi­quí̠n hua̠nti̠ xta̠­chiqui y xli̠­ta­la­ka­pasni ni̠ tali̠­pa̠­huán hua̠ntu̠ li̠chu­hui̠nán. ");
INSERT INTO tocNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jesús ni̠lay ca̠li̠­ma̠­la­ca­huá̠­ni̠lh lanca ta­scújut porque xna­ta̠­chi­quí̠n ni̠ xta­ca̠­naj­laniy, caj xma̠n cha̠stiy ca̠acuíli̠lh xmacán y ca̠ma̠­pac­sá­nilh xta­ja­tatcán. ");
INSERT INTO tocNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesús luu snu̠n laka­pú­tzalh y li̠púhua porque xlacán ni̠ xta­ca̠­naj­la­ni­putún. Huata alh a̠laca­tunu lactzu̠ ca̠chi­quí̠n xla­cata antá naliakchu­hui̠nán xta­chu­huí̠n Dios. ");
INSERT INTO tocNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Maktum quilh­ta­macú ca̠ma̠­ké̠s­tokli kalha­cu̠tiy xdis­cí­pulos, ca̠huá­nilh xla­cata nataán li̠cha̠­tiyú̠n nata­ma̠akpun­tumi̠y xta­chu­huí̠n Dios, ca̠ma̠x­qui̠lh li̠t­li­hueke xla­cata tla̠n nata­mac­xtuy xes­pí­ritu akska­huiní. ");
INSERT INTO tocNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Y ca̠li̠­ma̠­pék­si̠lh xla­cata ni̠tu̠ natalé̠n xalac xti­jicán hua̠ntu̠ naca̠­li̠­ma­cuaniy cumu la̠ múr­ralh, osuchí cax­ti­lá̠n­chahu, osu tumi̠n hua̠ntu̠ nata­li̠­hua̠yán. ");
INSERT INTO tocNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ca̠huá­nilh xla­cata tla̠n natalé̠n xta­tu̠­nu̠ncán pero xma̠n hua̠ntu̠ xta­ta­tu̠­nu̠ni̠t, xa̠hua clha­ka̠tcán caj hua̠ntu̠ xta­lha­ka̠ni̠t, y kan­tumá xli̠x­tokcán. ");
INSERT INTO tocNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Chiné ca̠huá­nilh: —Acxni̠ hui­xinín nata­nu̠­ya̠­pítit nac aktum ca̠chi­quí̠n, capu­tzátit aktum chiqui, antá nata­hui­la­yá̠tit hasta acxni̠ napim­pa­ra­yá̠tit a̠laca­tunu ca̠chi­quí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Para nac aktum ca̠chi­quí̠n ni̠tlá̠n naca̠t­la­hua­ca­ná̠tit y ni̠ nata­kax­mat­putun hua̠ntu̠ hui­xinín li̠chu­hui̠­nam­pá̠tit, la̠li̠­huán catax­tútit y cxla­ca­ti̠ncán caca̠­tan­tu̠­tin­c­xcántit pokxni hua̠ntu̠ antá ca̠lac­ta­huacán la̠qui̠ xlacán nata­ca­tzi̠y pi̠ hui­xinín ni̠ laka­ti̠­yá̠tit hua̠ntu̠ xlacán xka­satcán. ");
INSERT INTO tocNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ama̠­ko̠lh dis­cí­pulos tatá­ca̠xli y táalh nac lactzu̠ ca̠chi­qui̠ní̠n, tzú­culh tama̠­kalh­chu­hui̠ni̠y cris­tianos xla­cata nata­lak­pali̠y li̠xcáj­nit xta­la­ca­pa̠s­tac­nicán hua̠ntu̠ xta­ka­lhi̠y. ");
INSERT INTO tocNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Lhu̠hua ta̠tat­laní̠n tama̠­pác­salh caj aceite xta­li̠t­la­huay, na̠ tata­mác­xtulh xes­pí­ritu akska­huiní. ");
INSERT INTO tocNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Acxni̠ rey Herodes cátzi̠lh la̠ta xli̠­chu­hui̠­nancán xta­scújut Jesús porque cani̠huá xta­la­ka­pun­tu­mi̠ma xta­chu­huí̠n, chiné huá: —Huá tamá chixcú, Juan Bau­tista, lacas­ta­cuánalh nac ca̠li̠ní̠n, por eso tla̠n li̠t­la­huay lac­lanca ta­scújut y kalhi̠y li̠t­li­hueke. ");
INSERT INTO tocNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Maka­pi­tzí̠n cris­tianos chiné xta­huán: —Tamá chixcú ma̠x huá pro­feta Elías, osu tzanká tícuya̠ pro­feta hua̠nti̠ xta­liakchu­hui̠nán Dios maká̠n quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pero acxni̠ káx­matli eé rey Herodes, chiné xlá xuan: —Tamá chixcú luu laca­tancs pi̠ huá Juan Bau­tista hua̠nti̠ aquit cma̠­pix­ca̠c­ti̠­ní̠­nalh xak­xa̠ka y la̠nchú xlá aya lacas­ta­cuanani̠t ca̠li̠ní̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Porque chiné ti̠tax­tuni̠t acxni̠ ma̠mak­ni̠­ní̠­nalh rey Herodes. Maktum quilh­ta­macú Juan Bau­tista huá­nilh rey Herodes. —Ni̠tlá̠n la̠n­tamá lápa̠t, ni̠ mili̠­ta̠­ta­huílat xpusca̠t min­ta̠lá. Pus huá xla­cata rey Herodes li̠ma̠­ta­mac­nu̠­ní̠­nalh cpu̠­la̠­chi̠n y li̠ma̠­pek­sí̠­nalh cali̠­chi̠­hui­lí̠­calh cadena, porque ni̠tlá̠n tla̠­hualh acxni̠ li̠huá­nilh xla­cata xtá̠hui xpusca̠t xta̠Felipe. ");
INSERT INTO tocNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Y na̠chuná a̠má pusca̠t xuanicán Herod­ías ni̠ xuc­xilh­putún Juan porque xca̠­li̠­hua­nini̠t la̠ta xtá̠hui xya̠stá, anka­lhi̠ná xlac­pu­tzama lácu nat­la­huay tla̠n namakni̠y, pero ni̠lay xmaclay lácu nat­la­huay. ");
INSERT INTO tocNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Xa̠huachí Herodes xca­tzi̠y pi̠ Juan Bau­tista luu tla̠n cris­tiano xuani̠t y xca­tzi̠y pi̠ Dios xma­ca­mini̠t, aca­tunu hasta xla­kati̠y xkax­matniy xta­chu­huí̠n ma̠squi ni̠ hua̠k xaka­ta̠ksa. Por eso xli̠­pe̠­cuaniy tzinú, ni̠ xma̠x­qui̠y quilh­ta­macú Herod­ías para túcu nat­la­huaniy. ");
INSERT INTO tocNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pero maktum quilh­ta­macú Herod­ías mác­lalh lácu nat­la­huay namakni̠y Juan porque rey Herodes ca̠t­la­huá­nilh aktum pa̠xcua pu̠tum hua̠nti̠ xana­puxcún ma̠pek­si̠­naní̠n y xco­man­dantes xa̠hua hua̠nti̠ luu lac­ta­li̠­pa̠hu lac­chix­cu­huí̠n antá xalac Gali­lea. ");
INSERT INTO tocNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Y a̠má xtzuma̠t Herod­ías caj li̠puntzú tánu̠lh antaní xpa̠x­cuajna­má̠­calh, xlá tzú­culh tan­tli̠y y pu̠tum ti̠ antá xta­hui­lá̠­nalh tala­ká­ti̠lh la̠ tán­tli̠lh. Rey Herodes chiné huá­nilh a̠má tzuma̠t: —Huix caquis­quini hua̠ntu̠ a̠tzinú laka­ti̠ya y aquit nac­ma̠x­qui̠yá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ma̠squi luu lhu̠hua tíyat xquis­quini hua̠ntu̠ aquit cma̠­peksi̠y xac­ma̠x­quí̠n, huá­nilh. Xli̠­hua̠k hua̠nti̠ antá xta­hui­lá̠­nalh takáx­matli acxni̠ chuná huá pi̠ nama̠x­qui̠y la̠tachá túcu nas­quiniy. ");
INSERT INTO tocNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Amá tzuma̠t pálaj táx­tulh y kalhás­quilh xtzí: —¿Túcu cahuá xac­squí­nilh quin­tú̠tla̠t, pus huan pi̠ la̠ta túcu nac­squiniy xlá naqui­ma̠x­qui̠y? Xtzí chiné huá­nilh: —Cas­quini xak­xa̠ka Juan Bau­tista. ");
INSERT INTO tocNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","La̠li̠­huán tánu̠lh a̠má tzuma̠t antaní xuí rey y chiné huá­nilh: —Cla­cas­quín la̠n­chuj tuncán quim­pu̠­ma̠xqui pektum pula̠tu xak­xa̠ka Juan Bau­tista. ");
INSERT INTO tocNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herodes cacs lacáhua y li̠púhua tzinú, pero ni̠lay lácu nahuán para ni̠ cati­má̠x­qui̠lh hua̠ntu̠ xmak­squima porque aya xli̠­ta̠­ya­nini̠t, xa̠huachí pu̠tum xta­putza xta­kax­matni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Xlá ma̠la­ká­cha̠lh cha̠tum tropa xla­cata tuncán nali̠­miniy xak­xa̠ka Juan. Amá tropa alh nac pu̠la̠­chi̠n, pix­cá̠c­ti̠lh xak­xa̠ka Juan, pu̠lí̠­milh pula̠tu cumu la̠ xli̠­ma̠­pek­si̠­cani̠t y alh ma̠x­qui̠y rey Herodes. ");
INSERT INTO tocNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Xlá maca­má̠x­qui̠lh a̠má tzuma̠t, y a̠má tzuma̠t maca­má̠x­qui̠lh xtzí. ");
INSERT INTO tocNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Acxni̠ xlacán tacá­tzi̠lh hua̠nti̠ luu xta­sta̠­la­ni­pu̠lay Juan y xta­kax­matniy xta­chu­huí̠n xlacán táalh tatiyay xti­yat­li̠hua la̠qui̠ nata­ma̠cnu̠y. ");
INSERT INTO tocNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Aca­li̠stá̠n ni̠ li̠maka̠s, xapós­toles Jesús taqui̠­tás­pitli y tzú­culh tali̠­ta̠­kalh­chu­hui̠nán la̠ta túcu xlacán xtat­la­huani̠t y la̠ta xta­ma̠­kalh­chu­hui̠­ni̠ni̠t cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Aca­li̠stá̠n Jesús ca̠huá­nilh: —Catátit caáhu jaxá̠hu anta­nícu tlak ca̠tze̠k la̠qui̠ ni̠ti̠ naquin­ca̠akax­cu­liyá̠n. Porque niajlay aka­tzi­yanca xta­hua̠yán pus lhu̠hua xtamín taucxilha Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jesús ca̠ta̠­tá­ju̠lh xdis­cí­pulos nac aktum barco y táalh anta­nícu ni̠ti̠ lama cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero lhu̠hua cris­tianos taúcxilhli acxni̠ táca̠xli barco y tala­ká­pasli tícu antá xta­ta­ju̠­má̠­nalh, y cani̠hua̠ xalaní̠n tuncán tacá­tzi̠lh nícu xcha̠ma y pu̠lh huá tácha̠lh nia̠ xta­chá̠n Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Acxni̠ tacutli Jesús nac barco úcxilhli pi̠ lhu̠hua cris­tianos xta­hui­lá̠­nalh cumu la̠ xaaktzanká̠n bor­regos hua̠nti̠ ni̠ti̠ ca̠cuentajlay; Jesús ca̠la­ka­lhá­malh y lhu̠hua hua̠ntu̠ tzú­culh ca̠li̠­ma̠­kalh­chu­hui̠ni̠y. ");
INSERT INTO tocNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Acxni̠ tzú­culh ca̠s­ma­lankán xta­ma̠­kalh­ta­huaké̠n talák­milh antaní xlá xuí y chiné tahuá­nilh: —Aya amajá tzi̠­suán y nac u̠má pu̠la­tama̠n ca̠tzi­yanca, ni̠ti̠ hui­la­kó̠­calh. ");
INSERT INTO tocNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Caca̠­huani tama̠­ko̠lh cris­tianos catáalh nac lactzu̠ ca̠chi­quí̠n osu nac xchiccán hua̠nti̠ tapu̠­la­hui­lá̠­nalh lacatzú y antá cata­ta­má̠­hualh cax­ti­lá̠n­chahu hua̠ntu̠ nata­huay porque ni̠tu̠ tali̠mín tu̠ nata­huay. ");
INSERT INTO tocNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pero Jesús ca̠kálh­ti̠lh: —Mejor hui­xinín caca̠­ma̠­huí̠tit. Xlacán chiné takalh­tí̠­nalh: —Pero ¿nícu chú nac­ti­ya­yá̠hu lhu̠hua tumi̠n la̠qui̠ nac­li̠­ta­ma̠­hua­yá̠hu cax­ti­lá̠n­chahu la̠qui̠ nac­ca̠­ma̠­hui̠­yá̠hu? ");
INSERT INTO tocNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús ca̠ka­lhás­quilh: —¿Nícu macli̠t cax­ti­lá̠n­chahu kalhi̠­yá̠tit hui­xinín? Caqui̠ucxílhtit. Acxni taqui̠ucxilh­ko̠lh tahuá­nilh: —Huí mac­qui­tzis cax­ti­lá̠n­chahu xa̠hua tantiy squi̠ti. ");
INSERT INTO tocNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesús ca̠huá­nilh cris­tianos pu̠tunu pu̠tunu cata­táhui nac ca̠se­ketni. ");
INSERT INTO tocNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Pus tatáhui pu̠tunu para aka­tunu ciento, maka­pi­tzí̠n ita̠tni ciento cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesús ca̠chí­palh a̠má mac­qui­tzis cax­ti­lá̠n­chahu xa̠hua tantiy squi̠ti, láca̠lh ta̠lhmá̠n nac akapú̠n, pa̠x­cat­ca­tzí̠­nilh Dios a̠má tahuá. Aca­li̠stá̠n lak­ché­kelh a̠má cax­ti­lá̠n­chahu y ca̠má̠x­qui̠lh xdis­cí­pulos la̠qui̠ nata­ma̠akpi­tziniy pu̠tum ti̠ antá xta­hui­lá̠­nalh, na̠chuna li̠túm ca̠ma̠akpí­tzilh a̠má tantiy squi̠ti. ");
INSERT INTO tocNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Pu̠tum la̠n tahuá̠­yalh y tákasli. ");
INSERT INTO tocNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Aca­li̠stá̠n xdis­cí­pulos tama̠­mac­xtu­mi̠pá pa̠cu̠tiy canasta cax­ti­lá̠n­chahu chu xata­lak­cheke squi̠ti hua̠ntu̠ ni̠ tahua­ko̠lh a̠má cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Caj xma̠n lac­chix­cu­huí̠n ma̠x cumu akqui­tzis mi̠lh tahuá̠­yalh, tunuj cuenta lac­chaján xa̠hua lactzu̠ camán. ");
INSERT INTO tocNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Aca­li̠stá̠n Jesús ca̠huá­nilh xdis­cí­pulos cata­tá­ju̠lh nac barco la̠quí̠ nataán a̠li̠quilh­tu̠tu chú­chut nac aktum ca̠chi­quí̠n hua­nicán Bet­saida; y Jesús aca­li̠stá̠n xámaj ca̠lak­chá̠n porque xca̠­hua­nima cris­tianos xla­cata na̠ cataalhá nac xchiccán. ");
INSERT INTO tocNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Acxni̠ taanko̠lh pu̠tum cris­tianos, Jesús tala­ca̠c­xtu­táhui nac aktum ke̠stí̠n la̠qui̠ nakalh­ta­hua­kaniy Dios. ");
INSERT INTO tocNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Acxni̠ chú la̠n tzí̠­sualh a̠má barco xana̠­chitá nac xke̠íta̠t pupunú y Jesús sacstu xta­mak­xtekni̠t nac xquilhtú̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Xlá úcxilhli pi̠ xta­ta̠k­lhu̠­hui̠­má̠­nalh porque niajlay xta­ma̠t­la̠­huani̠y barco porque u̠n ni̠ antá xpe­kama antaní xlacán xtaamá̠­nalh. Y luu aya cxka­ka­ti̠­lhay acxni̠ Jesús ca̠lak­ta­la­ca­tzú­hui̠lh nac xbar­cojcán xlá xkalh­tla̠­huama chú­chut, aya xámaj ca̠ti̠aka­pu̠lay. ");
INSERT INTO tocNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Acxni̠ taúcxilhli xdis­cí­pulos xlacán xta­lac­pu­hua­má̠­nalh pi̠ ma̠x caj ni̠n xtaucxilh­má̠­nalh, tzú­culh taqui­lhán. ");
INSERT INTO tocNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Pero Jesús ca̠xa­kát­li̠lh chiné ca̠huá­nilh: —¡Caka­lhí̠tit hui­xinín li̠ca­mama, ni̠ cape̠­cuántit; porque aquit hua̠nti̠ cca̠­la­ka­ma̠­chá̠n Jesús! ");
INSERT INTO tocNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Aca­li̠stá̠n ca̠lak­tá­ju̠lh nac barco y tuncán tachó­kolh u̠n; xdis­cí­pulos Jesús cacs xta­la­ca­huani̠t ni̠ xta­ca­tzi̠y túcu nata­lac­pu­huán ");
INSERT INTO tocNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","porque ni̠ xtaaka­ta̠k­sni̠t a̠má lanca ta­scújut ni̠ma xca̠­ma̠­si­yu­nini̠t, y ma̠squi aya xtaucxilh­pa­rani̠t xta­scújut acxni̠ ca̠má̠­hui̠lh cax­ti­lá̠n­chahu, xna­cujcán ni̠lay xtaaka­ta̠ksa lácu luu nata­li̠­pa̠­huán. ");
INSERT INTO tocNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Y acxni̠ tapa̠­ta­cut­ko̠lh a̠má pupunú xalac Gali­lea tácha̠lh nac aktum ca̠chi­quí̠n hua­nicán Gene­saret, y antá tachi̠­huí­li̠lh xbar­cojcán. ");
INSERT INTO tocNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Y acxni̠ tatá­cutli, lhu̠hua cris­tianos tala­ká­pasli Jesús y tuncán talák­milh. ");
INSERT INTO tocNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Pu̠tum ta̠tat­laní̠n ti̠ antá xta­la­má̠­nalh ca̠li̠­minca antaní xchu­hui̠­nama Jesús la̠qui̠ naca̠­ma̠­pacsay; ");
INSERT INTO tocNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","y na̠chuná ctiji, osu nac ca̠tu­huá̠n, osu nac ca̠chi­quí̠n antaní xlacán xta­lac­pu­huán pi̠ antá nati̠­taxtuy Jesús. Maka­pi­tzí̠n cris­tianos xtas­quiniy li̠tlá̠n xla­cata caca̠­má̠x­qui̠lh quilh­ta­macú cata­xa­má­nilh clháka̠t, y lhúhua ta̠tat­laní̠n hua̠k ca̠ma̠­pác­salh. ");
INSERT INTO tocNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Maktum quilh­ta­macú talak­ta­la­ca­tzú­hui̠lh Jesús maka­pitzi fariseos xa̠hua xma̠­kalh­ta­hua­ke̠­nacán judíos xlacán xta­mi­ni̠­tanchá nac Jeru­salén. ");
INSERT INTO tocNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Cumu aya xtas­ka­laj­má̠­nalh xla­cata nata­mac­laniy hua̠ntu̠ nata­li̠­ya̠­huay taúcxilhli xla­cata maka­pi­tzí̠n xdis­cí­pulos acxni̠ xta­hua̠yán ni̠ xta­ma­ka­chakán cumu la̠ xta­li̠s­ma­ni̠ni̠t judíos xta­li̠­ca̠c­ni̠­naniy Dios, huá xla­cata tzu­cú­calh ca̠liaksancán. ");
INSERT INTO tocNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ama̠­ko̠lh fariseos xa̠hua pu̠tum judíos xta­li̠s­ma­ni̠ni̠t tat­la­huay la̠ta tu̠ lactzu̠ lactzú xta­li̠­hui­lá̠­nalh xapu̠lh xli̠­ta­la­ka­pas­nicán. Acxni̠ xlacán xta­hua̠yán pu̠lh la̠n nata­ma­ca­ta­huacay chú­chut caj lá̠m­para ca̠li̠­ma­ca­si­cu­la­na̠t­la­huacán la̠qui̠ mat xta­la­ka­chix­cu­hui̠y Dios. ");
INSERT INTO tocNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Y acxni̠ xta­qui̠­ta­ma̠­hua­nanko̠y nac plaza ni̠ cati­ta­huá̠­yalh para ni̠ pu̠lh nali̠­ma­ka­chakán tzinú chú­chut. Na̠chuná para xva­socán osu cxa̠­lujcán, o la̠ta túcu xta­mac­la­cas­quín nac xcu­si̠­najcán, hasta xpu̠­ta­macán hua̠k la̠n xta­che­ke̠­makaniy xcuenta xala ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ama̠­ko̠lh fariseos xa̠hua xma̠­kalh­ta­hua­ke̠­nacán judíos talák­milh Jesús y taka­lhás­quilh: —Chí a̠ma̠ko̠lh min­ta­ma̠­kalh­ta­huaké̠n, ¿túcu xpa̠­la­cata ni̠ tali̠t­la­huay hua̠ntu̠ mini̠­tanchá xtas­ma­ni̠ncán qui­li̠­ta­la­ka­pas­nicán? Xlacán ni̠ tama­ka­chakán. ");
INSERT INTO tocNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús chiné ca̠kálh­ti̠lh: —Xli̠­ca̠na tu̠ tíhua pro­feta Isaías, chiné tzók­nulh acxni̠ xlá aya xuc­xilh­la­ca­cha̠ma la̠ta tu̠ hui­xinín min­ka­satcán, porque xlá chiné tíhua: Uma̠­ko̠lh cris­tianos caj luu xma̠n xquilh­nicán tali̠­chu­hui̠nán acxni̠ tahuán pi̠ mat quin­ta­li̠­pa̠­huán y quin­ta­la­ka­chix­cu­hui̠y, pero huata antá nac xna­cujcán luu túnuj tala­ca­pa̠s­tacni tahui­li̠ni̠t, y chuná chú quin­ta­li̠­ma̠­la­ka­maka­tli̠niy. ");
INSERT INTO tocNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Pus luu laca­tancs pi̠ ni̠tu̠ li̠ma­cuán ma̠squi xquin­ta­la­ka­chix­cú­hui̠lh, porque xli̠­hua̠k hua̠ntu̠ xlacán tali̠­ma̠­pek­si̠nán catat­lá­hualh cris­tianos hua̠k huá caj xtas­ma­ni̠ncán lac­chix­cu­huí̠n y ni̠ huá hua̠ntu̠ aquit cca̠­li̠­ma̠­pek­si̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Porque hui­xinín mak­xtek­ta̠­ya­yá̠tit xta­péksi̠t Dios xla­cata sta̠­la­ni­yá̠tit xtas­ma­ni̠ncán lac­chix­cu­huí̠n y tzu­cu­yá̠tit ca̠lak­che­ke̠­pi̠­yá̠tit miva­sucán, chu mixa̠­lujcán xa̠hua la̠ta túcu mac­la­cas­qui­ná̠tit mim­pu̠­kot­nicán, y la̠ta túcua hui­xinín tla­hua­yá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Na̠ ca̠huá­nilh: —La̠ta tla­hua­yá̠tit min­tas­ma­ni̠ncán aca­tunu hasta ni̠tu̠ xta­palh li̠ma̠x­tu­yá̠tit xta­péksi̠t Dios. ");
INSERT INTO tocNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Maka̠n quilh­ta­macú Moisés chiné ma̠lac­pu­huá̠­ni̠lh Dios catzók­nilh xli̠­ma̠­peksí̠n: “Capa̠xqui y cala­ka­lhá­manti min­tla̠t chu mintzí. Para cha̠tum cris­tiano nata̠­la̠­la­ca­ta̠­qui̠y xtla̠t osuchí xtzí y para cala̠huá nahuaniy, tamá cris­tiano luu mini̠niy pi̠ maktum cani̠lh.” ");
INSERT INTO tocNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero chi̠nchú hui­xinín kalhtum ma̠lu­lo­ká̠tit pi̠ ni̠ tla­huay tala̠­ka­lhí̠n acxni̠ ca̠mac­la­cas­quimá̠n min­tla̠tcán o lacas­quín naca̠­mak­ta̠­ya­yá̠tit y hui­xinín chiné naca̠­hua­ni­yá̠tit: “La̠nchú ni̠lay cca̠­mak­ta̠­yayá̠n ma̠squi xac­ca̠­mak­ta̠­ya­putún porque xli̠­hua̠k hua̠ntu̠ cka­lhi̠y actzú, hua̠k hua̠ cma̠­lac­nu̠­nini̠t Dios xla­cata nac­li̠­la­ka­chix­cu­hui̠y y huá chú nac­ma̠x­qui̠y.” ");
INSERT INTO tocNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Acxni̠ chuná hui­xinín hua­ná̠tit luu laca­tancs huam­pu­tu­ná̠tit pi̠ niaj ne̠cxni cati­mak­ta̠­yátit min­tla̠tcán osuchí min­tzicán. ");
INSERT INTO tocNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Pus chuná hui­xinín ni̠tu̠ xta­palh tla­hua­yá̠tit xta­péksi̠t Dios hua̠ntu̠ huán la̠ nala­ta­pa̠­yá̠tit caj xpa̠­la­cata li̠s­ma­ni̠­ni̠­tátit tla­hua­yá̠tit maka­pitzi tala­ca­pa̠s­tacni hua̠ntu̠ mini̠­tanchá xtas­maní̠n mili̠­ta­la­ka­pas­nicán. Na̠ lhu̠hua la̠ta tu̠ xta̠­chuná ni̠tlá̠n tapu­huá̠n kalhi̠­yá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","La̠n­chuná ca̠hua­ni­ko̠lh ca̠ta­sá­nilh pu̠tum cris­tianos xla­cata actzú tu̠ xca̠­hua­ni­putún, chiné ca̠huá­nilh: —Li̠huana̠ cakax­pátit y caaka­tá̠k­stit hua̠ntu̠ camá̠n ca̠li̠­ta̠­chu­hui̠­naná̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Hui­xinín catzi̠­yá̠tit hua̠ntu̠ huay cha̠tum chixcú án hasta nac xpu̠­lacni y ni̠ mak­la̠­ka­lhi̠y xli̠s­tacni, hua̠ntu̠ mak­la̠­ka­lhi̠y xli̠s­tacni hua̠ntu̠ mina̠chá nac xpu̠­lacni xnacú. ");
INSERT INTO tocNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Para hui­xinín kalhi̠­yá̠tit min­ta­ke̠ncán, tancs cakax­páttit hua̠ntu̠ mili̠t­la­huatcán. ");
INSERT INTO tocNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesús ca̠ak­xtek­yá̠­hualh pu̠tum cris­tiano y ca̠ta̠­tá­nu̠lh xdis­cí­pulos nac xchic; acxni̠ a̠ma̠ko̠lh dis­cí­pulos taka­lhás­quilh túcu xuani­putún a̠má takalh­chu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesús chiné ca̠huá­nilh: —¿Lácu pi̠ ni̠ aka­ta̠k­sá̠tit hui­xinín hua̠ntu̠ cca̠­hua­ni­pu­tuná̠n? Ni̠ catzi̠­yá̠tit xla­cata hua̠ntu̠ huay cha̠tum chixcú ni̠lay cati­ma̠x­ca­juá̠li̠lh xli̠s­tacni, ");
INSERT INTO tocNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","porque ni̠ antá cha̠n nac xnacú sino taju̠­ya̠chá nac xpa̠­lu̠hua y aca­li̠stá̠n makam­paray. Xlá xuamputún xla­cata la̠tachá túcuya̠ tahuá hua̠k tla̠n huacán y ni̠ cati­ma̠x­ca­juá̠li̠lh xla­tama̠t cha̠tum cris­tiano. ");
INSERT INTO tocNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Y chiné ca̠hua­nipá: —Pero ma̠x­ca­jua̠li̠y xli̠s­tacni cha̠tum cris­tiano hua̠ntu̠ mina̠chá xta­pu­huá̠n nac xnacú. ");
INSERT INTO tocNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Porque antá mina̠chá nac xpu̠­lacni xnacú cha̠tum cris­tiano ni̠ lacuán tapu­huá̠n, antá lac­pu­huán la̠ nala­ka­maklh­ti̠y xpusca̠t xta̠­chixcú, la̠ naxa­katli̠y túnuj pusca̠t o chixcú, ");
INSERT INTO tocNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","la̠ namak­ni̠nán, la̠ naka­lha̠nán, la̠ naaksa­ni̠nán, la̠ nalak­ca­tzán catu̠huá tu̠ ni̠ xlá, la̠ nala̠­quic­lhca­tzaniy, la̠ nala̠­ma­ka­si̠­tzi̠y, y catu̠huá tu̠ ni̠ lacuán tapu­huá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Hua̠k eé tapu­huá̠n mina̠chá nac xnacú y ma̠x­ca­jua̠li̠y xli̠s­tacni nac xla­catí̠n Dios. ");
INSERT INTO tocNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesús alh lata­pu̠li̠y lacatzú nac ca̠chi­quí̠n hua­nicán Tiro y Sidón, y tánu̠lh nac aktum chiqui anta­nícu nata­mak­xteka. Ni̠ xla­cas­quín tícu naca­tzi̠y pi̠ antá xuí pero ni̠lay tátze̠kli ");
INSERT INTO tocNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","porque cha̠tum pusca̠t ni̠ antá xalac Israel xuani̠t xlá xchu­hui̠nán griego xala­ca­chín xuani̠t nac Siro­fen­icia luu mákat ca̠chi­quí̠n. Xlá xuí cha̠tum xtzuma̠t hua̠nti̠ xmaka­tla­ja­nini̠t xta­la­ca­pa̠s­tacni xes­pí­ritu akska­huiní. Xlá cátzi̠lh pi̠ antá xuí Jesús, acxni̠ lák­chilh laka­ta­tzo­kós­talh nac xla­catí̠n, huá­nilh xla­cata cama̠­pác­salh y cata­mac­xtú­nilh xes­pí­ritu akska­huiní hua̠ntu̠ xka­lhi̠y xtzuma̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pero Jesús chiné kálh­ti̠lh: —Caca̠­ma̠xqui quilh­ta­macú pu̠lh cac­ca̠­mak­tá̠­yalh xcamán Dios uú xalac Israel, porque ni̠tlá̠n ca̠mak­lhti̠cán xta­huajcán camán xla­cata naca̠­ma̠x­qui̠cán chi­chí̠n hua̠nti̠ ni̠ nata­pa̠x­cat­ca­tzi̠niy. ");
INSERT INTO tocNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pero a̠má pusca̠t aká­ta̠ksli tu̠ xuani­putún y chiné kálh­ti̠lh: —Quim­pu̠­chiná, xli̠­ca̠na xlá la̠ huana, pero hasta lactzu̠ chi­chí̠n ni̠ma tata­huilay nac xtampí̠n mesa tasa­cuaqui̠y hua̠ntu̠ ni̠ tahuako̠y xta­huajcán camán. ");
INSERT INTO tocNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesús chiné huá­nilh: —Luu cla­ká­ti̠lh la̠ chu­huí̠­nanti, tla̠n li̠pa̠­xúhu napina cmín­chic porque a̠má xes­pí­ritu akska­huiní aya mak­xtekni̠t min­tzuma̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Amá pusca̠t pálaj alh nac xchic y acxni̠ cha̠lh xli̠­ca̠na ma̠nók­lhulh xtzuma̠t niaj xka­lhi̠y xes­pí­ritu akska­huiní, lacas­ta­lanca xuani̠t y clhta­tama nac xpu̠­tama. ");
INSERT INTO tocNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús taca̠xpá nac Tiro alh laka­tza̠lay cxa­pu̠­la­tama̠n Sidón, hua̠k ca̠la­ka­tzá̠­lalh maka­pitzi lactzu̠ ca̠chi­quí̠n hua̠ntu̠ xta­peksi̠y nac Decá­polis y chuná cha̠lh nac xapu­punú Gali­lea. ");
INSERT INTO tocNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Antá li̠mi­ní­calh cha̠tum chixcú ko̠ko y aka­ta̠pa xuani̠t. Maka­pitzi cris­tianos tahuá­nilh Jesús xla­cata cat­lá­hualh li̠tlá̠n cali̠­tan­ka­pi̠­xá­malh xmacán la̠qui̠ napacsa y tla̠n nakax­mata. ");
INSERT INTO tocNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesús laca­tunu tá̠alh a̠má chixcú anta­nícu ni̠ luu lhu̠hua xta­la­yá̠­nalh cris­tianos la̠qui̠ ni̠ti̠ naca̠ucxilha. Antá aka­má̠­nu̠lh lactzu xmacán nac xtaké̠n, aca­li̠stá̠n chujli y hui­lí̠­nilh xchújut nac csi̠­máka̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Láca̠lh nac akapú̠n, jalh­pá̠­ni̠lh y chiné huá­nilh: —¡Efata! —u̠má tachu­huí̠n huam­putún: ¡Cata­káx­matli min­také̠n! ");
INSERT INTO tocNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tuncán takáx­matli xtaké̠n a̠má chixcú xa̠hua csi̠­máka̠t cá̠x­lalh y tla̠n tzú­culh chu­hui̠nán. ");
INSERT INTO tocNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","La̠tachá tícu xma̠­pacsay Jesús xca̠­huaniy xla­cata ni̠ nata­li̠­chu­hui̠nán, pero acxni̠ chuná xca̠­huaniy, a̠tzinú xlacán xtzucuy tali̠­chu­hui̠nán. ");
INSERT INTO tocNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Xli̠­hua̠k ti̠ xta­ca­tzi̠ni̠t hua̠ntu̠ xca̠t­la­huani̠t Jesús cacs xta­la­ca­huán y chiné xta­huán: —Catu̠huá hua̠k tla̠n ca̠t­la­huay y hasta ma̠squi ko̠ko hua̠k tla̠n ca̠ma̠­chu­hui̠ni̠y y aka­ta̠pa ca̠ma̠akat­la̠nti̠y. ");
INSERT INTO tocNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Maktum quilh­ta­macú luu lhu̠hua xta­ta­mak­stokni̠t cris­tianos xlacán ni̠ xta­li̠mín hua̠ntu̠ nata­huay. Jesús ca̠ta­sá­nilh xta­ma̠­kalh­ta­huaké̠n y ca̠huá­nilh: ");
INSERT INTO tocNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Luu cca̠­la­ka­lhamán eé cris­tianos porque aya tu̠xa­matá la̠ta quin­ta­ta̠­la­pu̠lay y xlacán ni̠tu̠ tali̠mín hua̠ntu̠ nata­li̠­hua̠yán. ");
INSERT INTO tocNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ni̠para lay cca̠­huaniy cataalhá nac xchiccán, para ni̠ tahua̠­yan­ta̠­qui̠ni̠t nata­la­ka­hui­ti­ta̠yay nac tiji porque maka­pi­tzí̠n mákat ní tami­ni̠­tanchá. ");
INSERT INTO tocNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Xdis­cí­pulos takálh­ti̠lh: —Pero, ¿lácu chú nat­la­hua­yá̠hu naca̠­ma̠­hui̠­yá̠hu pu̠tum eé cris­tianos anta­nícu ni̠ti̠ lama̠­ko̠lh cris­tianos? ");
INSERT INTO tocNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús ca̠ka­lhás­quilh: —Chi̠nchú hui­xinín, ¿nícu macli̠t cax­ti­lá̠n­chahu li̠ta­ná̠tit? Xlacán takalh­tí̠­nalh: —Mac­tujún. ");
INSERT INTO tocNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ca̠ma̠­pék­si̠lh xla­cata pu̠tum cris­tianos cata­táhui nac ca̠ti­yatni, Jesús tíyalh a̠má mac­tujún cax­ti­lá̠n­chahu, pa̠x­cat­ca­tzí̠­nilh Dios xtahuá, aca­li̠stá̠n lak­ché­kelh y ca̠má̠x­qui̠lh xta­ma̠­kalh­ta­huaké̠n, xlacán tama̠akpi­tzí­nilh pu̠tum cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Y na̠chuná xta­ka­lhi̠y tan­c­stiy squi̠ti, Jesús na̠ ca̠si­cu­la­na̠t­lá­hualh y ca̠ma̠akpi­tzi­ní­calh pu̠tum cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Hua̠k tahuá̠­yalh y la̠n tákasli, aca­li̠stá̠n tama̠­tza­mapá pa̠tujún cana̠sta xata­lak­che­ke­tamá̠n cax­ti­lá̠n­chahu hua̠ntu̠ ni̠ tahua­ko̠lh a̠ma̠ko̠lh cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Hua̠nti̠ tahuá̠­yalh ma̠x cumu akta̠ti mi̠lh cris­tianos. Aca­li̠stá̠n Jesús ca̠huá­nilh xla­cata cataalhá nac xchiccán. ");
INSERT INTO tocNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Y ca̠ta̠­tá­ju̠lh xdis­cí­pulos nac aktum barco y táalh nac aktum ca̠chi­quí̠n hua­nicán Dal­ma­nuta. ");
INSERT INTO tocNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Maktum quilh­ta­macú talák­milh antaní xlaya Jesús maka­pitzi Fari­seos y tzú­culh tata̠­la̠­huaniy, aca­li̠stá̠n tahuá­nilh xla­cata cat­lá­hualh aktum lanca li̠cá̠cni̠t ta­scújut hua̠ntu̠ xlacán nata­li̠­la­ca­hua̠nán para xli̠­ca̠na Dios xma­ca­mini̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús luu maka̠s jalh­pá̠­ni̠lh li̠puhua y chiné ca̠kálh­ti̠lh: —¿Túcu xla­cata hui­xinín li̠s­qui­ná̠tit aktum li̠cá̠cni̠t ta­scújut hua̠ntu̠ caj nali̠­la­ka­sta̠­na­ná̠tit? Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ ni̠tu̠ cac­ti­ca̠t­la­huanín hua̠ntu̠ hui­xinín lacas­qui­ná̠tit y ni̠ ca̠mi­ni̠­niyá̠n naucxi­lhá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Entonces Jesús ca̠ak­xtek­yá̠­hualh y ca̠ta̠­tá­ju̠lh xdis­cí­pulos nac barco, táalh a̠li̠quilh­tu̠tu pupunú. ");
INSERT INTO tocNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Xdis­cí­pulos Jesús xta­pa̠­tzan­ka̠ni̠t natalé̠n hua̠ntu̠ nata­huay y caj xma̠n mactum cax­ti­lá̠n­chahu xtalé̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesús caj xamaktum chiné ca̠huá­nilh: —Cuentaj cat­la­huátit xla­cata ni̠ naca̠­ma̠­pa­si̠yá̠n xle­va­du­rajcán fariseos xa̠hua xle­va­dura rey Herodes. ");
INSERT INTO tocNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ama̠­ko̠lh dis­cí­pulos ni̠ taaká­ta̠ksli hua̠ntu̠ xlá xli̠­chu­hui̠­nama, xlacán tzú­culh tala̠­huaniy: —Ma̠x huá chuná quin­ca̠­li̠­hua­nimá̠n cumu ni̠tu̠ li̠mi­ná̠hu cax­ti­lá̠n­chahu hua̠ntu̠ nahua­yá̠hu. ");
INSERT INTO tocNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús cátzi̠lh hua̠ntu̠ xlacán xta­qui­lhuamá̠­nalh y chiné ca̠huá­nilh: —¿Túcu xla­cata la̠n­tamá li̠hua­ná̠tit pi̠ ni̠tu̠ li̠ta­ná̠tit cax­ti­lá̠n­chahu hua̠ntu̠ nahua­yá̠tit? ¿Luu xli̠­ca̠na ni̠lay aka­ta̠k­sá̠tit hua̠ntu̠ aquit cca̠­ma̠­si­yu­ni­pu­tuná̠n? ¿Xli̠­ca̠na mina­cujcán chu­nacú ni̠lay ca̠najlay hua̠ntu̠ aquit tla̠n cca̠t­la­huay? ");
INSERT INTO tocNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ma̠squi kalhi̠­yá̠tit mila­kas­ta­pucán la̠m­para ni̠tu̠ li̠la­ca­hua̠­na­ná̠tit; ma̠squi kalhi̠­yá̠tit min­ta­ke̠ncán la̠m­para ni̠tu̠ li̠kax­pa­tá̠tit. ¿Lácu pi̠ niaj pa̠s­ta­cá̠tit hua̠ntu̠ aquit ctla­huani̠t? ");
INSERT INTO tocNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Acxni̠ cca̠­má̠­hui̠lh akqui­tzis mi̠lh cris­tianos caj mac­qui­tzis cax­ti­lá̠n­chahu xka­lhi̠­yá̠tit ¿y nícu pa̠li̠t cana̠sta ma̠s­tóktit hua̠ntu̠ xlacán ni̠ tahua­ko̠lh? Xlacán takalh­tí̠­nalh: —Pa̠cu̠tiy cana̠sta. ");
INSERT INTO tocNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Y chi̠nchú acxni̠ cca̠­má̠­hui̠lh akta̠ti mi̠lh cris­tianos hui­xinín xli̠­ta­ná̠tit caj mac­tujún cax­ti­lá̠n­chahu, ¿nícu pa̠li̠t cana̠sta ma̠s­tóktit hua̠ntu̠ ni̠ tahua­ko̠lh hua̠nti̠ tahuá̠­yalh? Xlacán takalh­ti̠­nampá: —Pa̠tujún cana̠sta. ");
INSERT INTO tocNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jesús ca̠huá­nilh: —¿Y hasta ni̠naj aka­ta̠k­sá̠tit xla­cata pi̠ tunu tu̠ cca̠­li̠­ma̠­si­yu­ni­pu­tuná̠n xata­kalh­chu­huí̠n leva­dura? ");
INSERT INTO tocNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ni̠ xli̠­maka̠s tácha̠lh nac aktum ca̠chi­quí̠n hua­nicán Bet­saida; acxni̠ tacutli Jesús nac barco li̠mi­ní­calh cha̠tum laka­tzí̠n tas­quí­nilh li̠tlá̠n xla­cata ca̠na̠caj caxá­malh y cama̠t­lá̠n­ti̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Pus Jesús le̠lh a̠má laka­tzí̠n nac xqui­lhapá̠n ca̠chi­quí̠n, antá li̠la­cat­lá­hualh xchújut nac xla­kas­tapu y kalhás­quilh para tla̠n tzinú laca­hua̠nán. ");
INSERT INTO tocNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Amá laka­tzí̠n laca­huá̠­nalh tzinú y chiné huá­nilh: —Cca̠ucxilha lac­chix­cu­huí̠n cumu la̠ akatum quihui, a̠huatá cumu tat­la̠­huán. ");
INSERT INTO tocNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesús hui­li̠pá xmacán nac xla­kas­tapu a̠má chixcú, caj puntzú cacs tá̠yalh y aya tancs tala­cat­lá̠n­ti̠lh porque luu tla̠n laca­huá̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesús huá­nilh caalhá nac xchic y chiné li̠ma̠­pék­si̠lh: —Huata ni̠naj capit nac xpu̠íta̠t ca̠chi­quí̠n, y ni̠ti̠ cali̠­ta̠­chu­huí̠­nanti lácu huix tala­cat­la̠n­ti̠­ni̠ta. ");
INSERT INTO tocNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Aca­li̠stá̠n Jesús ca̠tá̠alh xdis­cí­pulos nac lactzu̠ pu̠la­tama̠n xca̠­ma̠­peksi̠y Cesarea de Felipo, y acxni̠ xta­la­ti̠­lhay nac tiji tzú­culh ca̠kalh­pu­tzay y ca̠huá­nilh: —¿Tícuya̠ chixcú quin­ta­li̠­macá̠n aquit acxni̠ quin­ta­li̠­chu­hui̠nán cris­tianos? ");
INSERT INTO tocNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Xlacán takálh­ti̠lh: —Hui̠nti̠ hua̠n pi̠ mat huix Juan Bau­tista, y hui̠ntí huan pi̠ mat huix pro­feta Elías mat lacas­ta­cuánanti nac ca̠li̠ní̠n y tam­pa­ra­ni̠ta nac ca̠quilh­ta­macú, y maka­pi­tzí̠n cris­tianos tahuán pi̠ mat huix tzanká tícuya̠ pro­feta hua̠nti̠ xta­la­má̠­nalh xapu̠lh ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesús ca̠ka­lhás­quilh: —Chi̠nchú hui­xinín, ¿tícuya̠ chixcú qui­la̠­li̠­ma̠x­tu­yá̠hu aquit? Pedro luu tancs kálh­ti̠lh: —Huix Cristo hua̠nti̠ maca­minít Dios xla­cata naquin­ca̠­lak­ma̠x­tuyá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Acxni̠ chuná káx­matli Jesús hua̠ntu̠ xlá xuanini̠t Pedro, ca̠huá­nilh xla­cata ni̠ti̠ nata­li̠­ta̠­chu­hui̠nán hua̠ntu̠ xlacán xta­ca­tzi̠y. ");
INSERT INTO tocNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Entonces aca­li̠stá̠n tzú­culh ca̠li̠­ta̠­chu­hui̠nán lácu la̠n ámaj pa̠ti̠y y chiné ca̠huá­nilh: —Aquit Xata­lac­sacni Chixcú taamá̠­nalh quin­ta­lak­makán lak­ko̠lún ma̠pek­si̠­naní̠n xa̠hua xana­puxcun cura, chu fariseos, xa̠hua xma̠­kalh­ta­hua­ke̠­nacán judíos porque ni̠ tala­kati̠y hua̠ntu̠ cma̠­siyuy. Aca­li̠stá̠n taamá̠­nalh quin­ta­makni̠y, pero xliaktutu quilh­ta­macú aquit cámaj lacas­ta­cuanán nac ca̠li̠ní̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Xlá luu laca­tancs ca̠huá­nilh hua̠ntu̠ xamaj okspulay; entonces Pedro le̠lh tzinú laka­mákat y tzú­culh li̠huaniy túcu xla­cata chuná xli̠­chu­hui̠­nama. ");
INSERT INTO tocNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesús huitek talák­spitli, láca̠lh pekán antaní xta­hui­lá̠­nalh xa̠maka­pi­tzí̠n xdis­cí­pulos y chiné huá­nilh Pedro: —Cat­lahua li̠tlá̠n, huix akska­huiní, cata­tam­pu̠xtu antaní cyá porque huix ni̠ laca­pa̠s­tac­nana cumu la̠ Dios sino cumu la̠ tala­ca­pa̠s­tacnán lac­chix­cu­huí̠n uú xalac ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Aca­li̠stá̠n ca̠ta­sá­nilh xdis­cí­pulos xa̠hua xli̠­hua̠k cris­tianos hua̠nti̠ antá xta­la­yá̠­nalh y chiné ca̠huá­nilh: —Para tícu luu qui­li̠­pa̠­huán y quis­ta̠­la­ni­putún capa̠­tzán­ka̠lh la̠ta tu̠ xkásat, caquis­ta̠­lá­nilh ma̠squi cali̠­pa̠­tí̠­nalh caj quim­pa̠­la­cata y cama­ca­má̠s­ta̠lh xla­táma̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Porque hua̠nti̠ luu mak­li̠­huán para nama­ka­tzanka̠y xla­táma̠t ámaj maka­tzanka̠y tu̠ lak­ca­tzán, pero hua̠nti̠ nama̠­lak­tzanke̠y xla­táma̠t caj quim­pa̠­la­cata, osu caj xpa̠­la­cata nali̠­chu­hui̠nán xta­chu­huí̠n Dios, xlá ámaj lak­ma̠xtuy nac xla­catí̠n Dios. ");
INSERT INTO tocNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Porque, ¿túcu li̠ma­cuaniy cha̠tum chixcú para la̠n xká­lhi̠lh la̠ta túcu anán nac ca̠quilh­ta­macú y para antá nac xla­catí̠n Dios ámaj ma̠lak­tzanke̠y xla­táma̠t? ");
INSERT INTO tocNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Porque, ¿nícu chulá cahuá tla̠n cxo­kóx­tulh xla­táma̠t cha̠tum chixcú xla­cata ní napa̠­ti̠nán? ");
INSERT INTO tocNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Y na̠chuna li̠túm para tícu la̠ hui­xinín naqui­li̠­ma̠­xanán osuchí nali̠­ma̠­xanán quin­ta­chu­huí̠n nac xla­ca­ti̠ncán a̠ma̠ko̠lh cris­tianos hua̠nti̠ ni̠tlá̠n xta­pu­hua̠ncán uú xalac ca̠quilh­ta­macú, pus aquit Xata­lac­sacni Chixcú na̠ nac­li̠­ma̠­xanán acxni̠ nac­mim­paray a̠maktum y nac­ca̠­ta̠mín ángeles xla­cata xli̠­hua̠k pu̠tum cris­tianos nataucxilha lácu kalhi̠y xli̠t­li­hueke xta­péksi̠t Dios. ");
INSERT INTO tocNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús chiné ca̠hua­nipá: —Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ maka­pi­tzí̠n cris­tianos uú tayá̠­nalh hasta nia̠ tani̠y nahuán acxni̠ nataucxilha la̠ natzucuy lay xta­péksi̠t Dios nac ca̠quilh­ta­macú y lácu lanca li̠t­li­hueke nali̠mín. ");
INSERT INTO tocNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Li̠tzi̠má quilh­ta­macú Jesús alh nac aktum lanca ke̠stí̠n y caj xma̠nhuá ca̠tá̠alh Pedro, San­tiago xa̠hua Juan; acxni̠ aya xta­cha̠ni̠t, nac xla­ca­ti̠ncán, Jesús tzú­culh tata­nuja niaj chuná la̠ anka­lhí̠n xta­siyuy. ");
INSERT INTO tocNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","La̠ta clháka̠t luu sna­papa huan­ko̠lh y luu slipua, ni̠ti̠cu anán cris­tiano ma̠squi luu la̠n cha­kanán xla­cata nama̠­lak­cha̠níy la̠ xli̠s­na­papa a̠má clháka̠t hua̠ntu̠ taúcxilhli xta­ma̠­kalh­ta­huaké̠n Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Caj xamaktum taúcxilhli pro­feta Elías, chu pro­feta Moisés xta­ta̠­chu­hui̠­na­má̠­nalh Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedro chiné huá­nilh Jesús: —Ma̠kalh­ta­hua­ke̠ná, huata ma̠x xali̠­huaca tla̠n antiyá uú xta­mak­xtekui, para huix chuná laca­squina u̠ctla­hua­yá̠hu aktutu lactzu chiqui, aktum milá, aktum xlá Moisés xa̠hua aktum xlá Elías. ");
INSERT INTO tocNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ama̠­ko̠lh xta­ma̠­kalh­ta­huaké̠n Jesús xta­pe̠­cuaxni̠ni̠t, y Pedro caj niaj xca­tzi̠y túcu xqui­lhuama. ");
INSERT INTO tocNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Caj li̠puntzú taúcxilhli la̠ také̠­talh puc­lhni nac xlak­sti̠­pa̠ncán, ca̠akmi­li­ko̠lh, y takáx­matli xta­chu­huí̠n Dios minchá nac akapú̠n: —Huá eé Quin­ka­huasa hua̠nti̠ luu cpa̠x­qui̠y, xma̠nhuá cakax­pat­nítit y cat­la­huátit hua̠ntu̠ xlá ca̠li̠­ma̠­pek­si̠yá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Acxni̠ xlacán tala­ca̠mpá, tzú­culh tala­ca­pu­tza̠nán, niaj tu̠ xta­la­yá̠­nalh a̠ma̠ko̠lh pro­fetas hua̠nti̠ xta­ta̠­chu­hui̠­na­má̠­nalh, huata ca̠ta caj sacstu xlaya Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Aca­li̠stá̠n acxni̠ aya xta­qui̠­tas­pit­ma̠na xta­ta­la­ka­ka­lhu̠­ma̠­nanchi nac ke̠stí̠n Jesús ca̠huá­nilh xka­lha­tu­tucán xla­cata ni̠ti̠ cata­li̠­ta̠­chu­huí̠­nalh hua̠ntu̠ xtaucxilhni̠t hasta acxni̠ xlá Xata­lac­sacni Chixcú nala­cas­ta­cuanán ca̠li̠ní̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Y xlacán ni̠tu̠ tali̠­chu­huí̠­nalh la̠ta tu̠ xtaucxilhni̠t, huata caj tzú­culh tala̠­ka­lhas­quín túcu cahuá xuamputún, o lácu cahuá tamá lacas­ta­cuanancán ca̠li̠ní̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Y chiné taka­lhás­quilh Jesús: —¿Túcu xla­cata xma̠­kalh­ta­hua­ke̠­nacán judíos tali̠­huán pi̠ pu̠lh ámaj min ca̠quilh­ta­macú Elías y aca­li̠stá̠n namín Cristo? ");
INSERT INTO tocNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Jesús chiné ca̠kálh­ti̠lh: —Xli̠­ca̠na tu̠ tahuán, ni̠ caj tali̠­huán, porque Elías pu̠lh ámaj min, xlá ámaj ca̠x­tla­huay xtiji. Pero aquit xli̠­cána cca̠­hua­niyá̠n pi̠ Elías aya qui̠­lachi nac ca̠quilh­ta­macú pero lhu̠hua cris­tianos ni̠ tala­ká­pasli, xlá pá̠ti̠lh la̠ta túcu tla­hua­ni­pu­tún­calh chuná la̠ xta­tzokni̠t nac xta­chu­huí̠n Dios xla­cata hua̠ntu̠ xámaj pa̠x­toka. Pero chú aquit na̠ cca̠­ka­lhas­quiná̠n: ¿Túcu huan nac xta­chu­huí̠n Dios ámaj quim­pa̠x­toka aquit Xata­lac­sacni Chixcú? ¿Lácu pi̠ ni̠ catzi̠­yá̠tit la̠ta lácu huan cámaj pa̠ti̠nán y lhu̠hua cris­tianos taamá̠­nalh quin­ta­lak­makán? ");
INSERT INTO tocNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Acxni̠ tatás­pitli antaní xta­hui­lá̠­nalh xa̠maka­pi­tzí̠n xta­ma̠­kalh­ta­huaké̠n taúcxilhli pi̠ lhúhua cris­tianos xta­ta­mak­stokni̠t xa̠hua xma̠­kalh­ta­hua­ke̠­nacán judíos xlacán xta­ta̠­la̠­li̠­ta­mak­spit­má̠­nalh y xta­ta̠­la̠­hua­ni­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pero maka­pi­tzí̠n cris­tianos acxni̠ taúcxilhli Jesús luu la̠n tapa̠­xú­hualh, tokosú̠n táalh tapa̠x­toka la̠qui̠ nata­ta̠­chu­hui̠nán. ");
INSERT INTO tocNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesús chiné ca̠ka­lhás­quilh: —¿Túcu xli̠­chu­hui̠­nam­pá̠tit? ");
INSERT INTO tocNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Cha̠tum hua̠nti̠ antá lacatzú xlaya chiné kálh­ti̠lh: —Ma̠kalh­ta­hua­ke̠ná, cli̠mín quin­ka­huasa xlá akchi­pa­ni­ko̠ni̠t xta­la­ca­pa̠s­tacni xes­pí­ritu akska­huiní y hasta niajlay chu­hui̠nán. ");
INSERT INTO tocNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Pus la̠ta nícu xlá lapu̠lay nama̠­la­ka­huitiy y tara­mi̠­ya̠chá nac ca̠ti­yatni; tzucuy kalh­pupuy y tzucuy la̠lac­xcay xta­tzán, caj huá xla­cata aya li̠s­ca̠c­ta­makanko̠y. Aya ca̠huá­nilh midis­cí­pulos cata­ta­mac­xtú­nilh, pero ni̠lay tama̠t­lá̠n­ti̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús chiné ca̠huá­nilh: —Koxu­taní̠n hui­xinín cris­tianos hua̠nti̠ ni̠ ca̠naj­la­pu­tu­ná̠tit quin­ta­chu­huí̠n. ¿Hasta ni̠n­co̠cxni camá̠n tica̠­ta̠­la­ta­ma̠yá̠n y camá̠n ca̠ta̠­pa̠­ti̠yá̠n xla­cata ni̠lay qui­la̠­li̠­pa̠­hua­ná̠hu? Y chiné huá: —Cali̠­tátit tamá kahuasa. ");
INSERT INTO tocNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Li̠mi­nica a̠má kahuasa antaní xyá Jesús. Y a̠má xes­pí­ritu akska­huiní acxni̠ úcxilhli Jesús ma̠la­ka­huí­tilh, tama̠chá nac ca̠ti­yatni, tzú­culh tapiliy y kalh­pupuy. ");
INSERT INTO tocNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús kalhás­quilh xtla̠t a̠má kahuasa: —¿Pi̠ maka̠sá chuná la̠ eé lay? Xatla̠t kalh­tí̠­nalh: —Hasta acxni̠ actzu̠cú xuani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Y mak­lhu̠­huatá tamá xes­pí­ritu akska­huiní tla­kapu̠y nac lhcúya̠t osuchi nac chú­chut xla­cata mak­ni̠­putún. Huá xla­cata cli̠­hua­niyá̠n, para tla̠n ma̠t­la̠n­ti̠ya pus caqui­la̠­la­ka­lha­máhu y caqui­la̠­mak­ta̠­yáhu. ");
INSERT INTO tocNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús chiné kálh­ti̠lh: —Aquit tla̠n cma̠­pacsay, pero xma̠n tzan­ka̠­niyá̠n pi̠ huix naca̠­naj­laya, porque la̠ta tícu ca̠najlay chuná lay la̠ta lácu lac­pu­huán. ");
INSERT INTO tocNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Xtla̠t a̠má kahuasa kalh­tí̠­nalh: —Cca̠­najlay pero caqui­mak­ta̠ya la̠qui̠ tlak nac­li̠­pa̠­huaná̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Acxni̠ úcxilhli Jesús pi̠ luu lhu̠hua tzú­culh tata­mak­stoka cris­tianos, huá­nilh a̠má akska­huiní: —Aquit cli̠­ma̠­pek­si̠yá̠n, camák­xtekti tamá kahuasa y niaj ne̠cxni camac­tanu porque huix ma̠ko̠­ke̠ná. ");
INSERT INTO tocNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Amá xes­pí­ritu akska­huiní ma̠tá­si̠lh y ma̠la­ka­hui­tipá a̠má kahuasa pero mac­táx­tulh, a̠má kahuasa cumu la̠ xaní̠n xmá; lhu̠hua cris­tianos hua̠nti̠ antá xta­la­yá̠­nalh taquilh­tzú­culh pi̠ xaní̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero Jesús maca­chí­palh y laka­siyu má̠qui̠lh, a̠má kahuasa tá̠yalh. ");
INSERT INTO tocNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Aca­li̠stá̠n Jesús alh nac chiqui antaní xta­ta­mak­xteka y antá xta­ma̠­kalh­ta­huaké̠n taka­lhás­quilh: —¿Túcu xla­cata la̠ a̠má aquinín ni̠lay ctla­kax­túhu a̠má xes­pí­ritu akska­huiní? ");
INSERT INTO tocNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesús ca̠kálh­ti̠lh: —Porque tamá xes­pí­ritu akska­huiní xma̠nhuá li̠t­la­kax­tucán para hui­xinín luu xli̠­ca̠na li̠pa̠­hua­ná̠tit Dios, anka­lhi̠ná kalh­ta­hua­ka­ni­yá̠tit y kalh­xtek­ni­ná̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Acxni̠ aya ca̠tá̠alh xdis­cí­pulos a̠laca­tunu tati̠­pun­táx­tulh antaní xma̠­peksi̠y Gali­lea, pero ni̠ní tata­chó­kolh porque ni̠ xla­cas­quín tícu naca­tzi̠y para antá xlá xlac­tla̠­huama. ");
INSERT INTO tocNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Porque xlá lhu̠hua tu̠ xca̠­li̠­ta̠­chu­hui̠­nam­putún xdis­cí­pulos nac tiji. Y ca̠li̠­ta̠­kalh­chu­huí̠­nalh xla­cata pi̠ xlá Xata­lac­sacni Chixcú xama̠ca maca­ma̠s­ta̠cán nac xmacanca̠n lac­chix­cu­huí̠n hua̠nti̠ ni̠ xtaucxilh­putún, xlacán xtaamá̠­nalh tamakníy pero caj xliaktutu quilh­ta­macú xlá xama̠paj lacas­ta­cuanán ca̠li̠ní̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ama̠­ko̠lh xdis­cí­pulos ni̠ xtaaka­ta̠ksa lácu luu xama qui̠­taxtuy pero cumu juerza xta­ma̠­xa­naníy niaj tu̠ xta­ka­lhas­quín. ");
INSERT INTO tocNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Acxni̠ tácha̠lh nac Caper­naum tatá­nu̠lh nac chiqui nícu nata­mak­xteka, y ca̠ka­lhás­quilh Jesús: —¿Túcu xla̠­li̠­ma̠aklhu̠­hui̠­ti̠­lha­yá̠tit nac tiji? ");
INSERT INTO tocNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Xlacán ni̠ takalh­tí̠­nalh porque nac tiji xta­li̠­chu­hui̠­nan­ti̠­lhay xatícu cahuá xta­ma̠­kalh­ta­huaké̠n Jesús luu a̠tzinú xli̠­pa̠­huán. ");
INSERT INTO tocNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Pero cumu Jesús hua̠k xca­tzi̠y túcu xlacán xta­li̠­chu­hui̠­nani̠t nac tiji, aca­li̠stá̠n culucs táhui y ca̠ta­sá­nilh kalha­cu̠tiy xta­ma̠­kalh­ta­huaké̠n, chiné ca̠huá­nilh: —Para xatícu hui­xinín a̠tzinú tlak xata­li̠­pa̠hu huam­putún pus xlá a̠tzinú tlak xaa̠huatá sta̠­lama naqui̠­taxtuy xla­cata naca̠­li̠­ma­cuaniy xa̠maka­pi­tzí̠n o cumu la̠ cha̠tum tasa̠cua ti̠ caj nama̠­pek­si̠cán y la̠tachá túcuya̠ ta­scújut nata­ma̠t­la­hui̠y. ");
INSERT INTO tocNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Aca­li̠stá̠n tasá­nilh cha̠tum actzu̠ kahuasa hua̠nti̠ antá lacatzú xlama, íta̠t ca̠ya̠­huá­nilh, chexli, y chiné ca̠huá­nilh: ");
INSERT INTO tocNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Hua̠nti̠ ni̠ nalak­makán cha̠tum actzu̠ kahuasa la̠ eé y napa̠x­qui̠y caj xpa̠­la­cata catzi̠y pi̠ aquit cpa̠x­qui̠y pus cliucxilha la̠ aquit quim­pa̠x­qui̠ma, na̠chuná hua̠nti̠ aquit quim­pa̠x­qui̠y na̠ qui̠­taxtuy la̠ hua­tiyá Dios pa̠x­qui̠ma hua̠nti̠ qui­ma­ca­mini̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Caj li̠puntzú Juan chiné huá­nilh Jesús: —Ma̠kalh­ta­hua­ke̠ná, cuc­xi­lhui cha̠tum chixcú hua̠nti̠ caj min­ta­cu­huiní xli̠­qui­lhán y xca̠­ma̠t­la̠nti̠y hua̠nti̠ xta­ka­lhi̠y xes­pí­ritu akska­huiní, pero cumu ni̠ acxtum quin­ca̠­ta̠­la­pu̠­layá̠n pus cli̠­hua­níhu xla­cata niaj ti̠ cama̠­pác­salh. ");
INSERT INTO tocNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesús huá­nilh: —Ni̠ xti­li̠­hua­nítit porque ni̠para cha̠tum chixcú tla̠n catit­lá­hualh lac­lanca xta­scújut Dios nac quim­pa̠­lák­xoko para aca­li̠stá̠n cala̠huá naqui­li̠­chu­hui̠nán. ");
INSERT INTO tocNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Porque para la̠ta tícuya̠ cris­tiano ni̠ quin­ca̠­lak­makaná̠n pus huata lakati̠y hua̠ntu̠ li̠s­cuj­ma̠­náhu. ");
INSERT INTO tocNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Porque xli̠­ca̠na cca̠­hua­niyá̠n pi̠ para tícuya̠ cris­tiano naca̠­ta̠s­qui­huayá̠n ca̠na̠caj pek­stum má̠ko̠t chú­chut xla­cata catzi̠y pi̠ aquit qui­la̠­lac­scuj­ni­ma̠­náhu, mima quilh­ta­macú acxni̠ xlá namak­lhtínán xtas­káhu. ");
INSERT INTO tocNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Para cha̠tum cris­tiano akas­tac­ya̠­huay xla­cata cat­lá­hualh tala̠­ka­lhí̠n y caquin­ta­li̠­lak­tzan­ka̠­tá̠­yalh cha̠tum actzú̠ camán hua̠nti̠ aya tzu­cuni̠t qui­li̠­pa̠­huán, li̠huán nia̠ tla­huay, a̠tzinú tla̠n xuá pu̠lh xpix­chi̠­nú̠­calh aktum chí­huix y xma­ca̠nca nac pupunú la̠quí̠ antá xjíc­sualh. ");
INSERT INTO tocNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Xli̠­ca̠na cca̠­hua­niyá̠n para mimacán ma̠t­la­hui̠yá̠n tala̠­ka­lhí̠n mejor caca̠cti y camá­kanti, porque a̠tzinú tla̠n nachi­pina nac akapú̠n maka­putu y ni̠tlá̠n para kalhi̠ya makatiy mimacán y napina cpu̠­pa̠tí̠n, ");
INSERT INTO tocNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ca̠lh­cu­ya̠tni anta­nícu ne̠cxní lak­sputa tapa̠tí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Para min­tantú̠n le̠ná̠n xla­cata nat­la­huaya tala̠­ka­lhí̠n mejor catan­tu̠­ca̠c­tí̠­canti porque a̠tzinú tla̠n nachi­pina nac akapú̠n tan­tu̠lh­túlu ni̠xa­chuná para acchá̠n kalhi̠ya tan­tu̠tiy min­tantú̠n y nama­ca­pin­cana nac pu̠pa̠tí̠n ");
INSERT INTO tocNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","anta­nícu ne̠cxní mixa lhcúya̠t y anka­lhi̠ná pa̠ti̠­námpa̠t nahuán. ");
INSERT INTO tocNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Para mila­kas­tapu ma̠t­la­hui̠yá̠n tala̠­ka­lhí̠n, mejor cata­macxtu porque a̠tzinú tla̠n nachi­pina nac akapú̠n lakatu laka­xo̠ko, y ni̠tlá̠n para acchá̠n lakati̠y mila­kas­tapu y caj xpa̠­la­cata huá huix napina cpu̠­pa̠tí̠n ");
INSERT INTO tocNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","nac ca̠lh­cu­ya̠tni anta­nícu ne̠cxni mixa lhcúya̠t y min­ta­pa̠tí̠n ne̠cxni cati­lák­sputli. ");
INSERT INTO tocNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Porque xli̠­hua̠k cris­tianos amá̠­calh ca̠liucxilhcán nac lhcúya̠t para xli̠­ca̠na taka­lhi̠y mátzat. ");
INSERT INTO tocNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Pus xli̠­ca̠na, mátzat luu snún tla̠n, pero mátzat para cspút­nilh xli̠s­koko, ¿túcu nali̠­ma̠s­ko­ke̠­nam­pa­raya? Anka­lhi̠ná hui­xinín nac mila­ta­ma̠tcán caka­lhí̠tit mátzat, ni̠ti̠ cata̠­la̠­si̠­tzi̠­nítit y cala̠­pa̠x­quí̠tit li̠mac­xtum cha̠tum a̠cha̠tum min­ta̠­cris­tianoscán. ");
INSERT INTO tocNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús taca̠xpá nac Caper­naum cha̠lh nac Judea y ca̠ti̠­lak­táx­tulh hua̠nti̠ xta­la­má̠­nalh nac a̠li̠quilh­tu̠án kalh­tu̠­choko Jordán. Lhu̠hua cris­tianos tata­mák­stokli antaní xuí Jesús, xlá tzú­culh ca̠ma̠­kalh­chu­hui̠ni̠y chuná cumu la̠ xlá xli̠s­ma­ni̠ni̠t tla­huay. ");
INSERT INTO tocNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Caj xamaktum támilh maka­pi­tzí̠n fariseos xla­cata nata­kalh­pu­tzay para túcu xlá ni̠ tancs nahuán. Y taka­lhás­quilh xla­cata para kalhi̠y dere­cho cha̠tum chixcú namak­xteka xpusca̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesús chiné ca̠kálh­ti̠lh: —¿Túcuya̠ tapéksi̠t ca̠ma̠x­quí̠n Moisés? ");
INSERT INTO tocNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Xlacán chiné takalh­tí̠­nalh: —Moisés li̠ma̠­pek­sí̠­nalh xla­cata cha̠tum chixcú tla̠n namak­xteka xpusca̠t pero nata̠­la­ca̠xlay nac pu̠ma̠­peksí̠n y nama̠x­qui̠y mactum xala­ca̠xlán cáp­snat. ");
INSERT INTO tocNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesús ca̠hua­nipá: —Moisés má̠s­ta̠lh tamá tapéksi̠t porque hui­xinín snu̠n lani̠t mina­cujcán. ");
INSERT INTO tocNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero acxni̠ Dios ma̠la­ca­tzú­qui̠lh la̠ta túcu ananko̠y nac ca̠quilh­ta­macú pus xlá tlá­hualh cha̠tum chixcú y cha̠tum pusca̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Por eso huá xla­cata cha̠tum kahuasa acxni̠ nata­maka­xtoka tla̠n akxtek­makán xtla̠t chu xtzí la̠qui̠ xlá nata̠­ta­lak­xtumi̠y xpusca̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Y a̠má kahuasa chu tzuma̠t hua̠nti̠ xcha̠­tiycán xta­huani̠t, chú luu cha̠­tumá nata­li̠­taxtuy. ");
INSERT INTO tocNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Pus huá xpa̠­la­cata cca̠­li̠­hua­niyá̠n pi̠ ni̠para cha̠tum cris­tiano mini̠niy nama̠­paj­pi­tziy hua̠ntu̠ Dios ma̠la­cas­tucni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Acxni̠ ca̠ta̠­chu­hui̠­nan­ko̠lh a̠má fariseos, Jesús tánu̠lh nac chiqui antaní xlaca̠n xta­ta­mak­xteka, y xdis­cí­pulos taka­lhás­quilh túcu xuani­putún a̠má takalh­chu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús ca̠huá­nilh: —Para tícu namak­xteka xpusca̠t caj xla­cata nata̠­ta­maka­xtoka túnuj pusca̠t luu lhu̠hua tala̠­ka­lhí̠n kalhi̠y xla­catí̠n Dios xa̠hua xla­catí̠n xapu̠lh xma̠­hui̠ná. ");
INSERT INTO tocNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Na̠chu­na­li̠túm hua̠nti̠ mak­xteka xta̠­ko̠lú xla­cata nata̠án tunuj chixcú a̠má pusca̠t kalhi̠y lhu̠hua tala̠­ka­lhí̠n xla­catí̠n Dios xa̠hua xla­catí̠n xapu̠lh xta̠­ko̠lu. ");
INSERT INTO tocNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Aca­li̠stá̠n li̠mi­ní­calh Jesús lactzu̠ camán la̠qui̠ naca̠­si­cu­la­na̠t­la­huay, pero xta­ma̠­kalh­ta­huaké̠n tzú­culh tala­ca­quilhni̠y hua̠nti̠ xta­li̠­mi­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","15","Pero acxni̠ ca̠úcxilhli Jesús hua̠ntu̠ xtat­la­hua­má̠na ca̠si̠­tzí̠­nilh tzinú y chiné ca̠huá­nilh: —Luu xli̠­ca̠na cat­la­huátit li̠tlá̠n ni̠ caca̠­li̠­hua­nítit tama̠­ko̠lh lactzu̠ camán xla­cata naquin­ta­lakmín anta­nícu aquit cuí, porque xli̠­ca̠na pi̠ caj xma̠nhuá hua̠nti̠ kalhi̠y xta­la­ca­pa̠s­tacni cumu la̠ actzu̠ kahuasa xlá luu lak­chá̠n pi̠ namaka­maklhti̠nán hua̠ntu̠ Dios ca̠ma̠x­qui̠­pu­tuná̠n y tla̠n nata­ta­nu̠­ya̠chá nac xta­péksi̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Y aca­li̠stá̠n cá̠chexli a̠má lactzu̠ camán y ca̠si­cu­la­na̠t­lá­hualh. ");
INSERT INTO tocNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Acxni̠ Jesús aya xama a̠laca­tunu y xtla̠­hua­majá, tokosú̠n lák­milh cha̠tum kahuasa, laka­ta­tzo­kós­talh nac xla­catí̠n y chiné huá­nilh: —Ma̠kalh­ta­hua­ke̠ná, xli̠­ca̠na huix luu tla̠n catzi̠ya, ¿túcu qui­li̠t­lá­huat la̠quí̠ tla̠n nac­ka­lhi̠y a̠má latáma̠t nac akapú̠n hua̠ntu̠ ne̠c­xnicú lak­sputa? ");
INSERT INTO tocNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús kálh­ti̠lh: —¿Túcu xla­cata qui­li̠­hua­niya pi̠ aquit luu tla̠n cca­tzi̠y? Porque uú ni̠ti̠cu anán hua̠nti̠ xli̠­ca̠na tla̠n huata caj xma̠n cha̠tum y huá Dios. ");
INSERT INTO tocNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Huix catzi̠ya la̠ huí kam­pa̠­cá̠hu xli̠­ma̠­peksí̠n Dios hua̠ntu̠ ma̠s­ta̠ni̠t Moisés: “Ni̠ caxa­katli túnuj pusca̠t para huí mim­pusca̠t; ni̠ camakni min­ta̠­cris­tiano; ni̠ camak­ka­lhá̠­nanti min­ta̠­cris­tiano; ni̠ti̠ caak­skahui min­ta̠­cris­tiano; ne̠c­xnicú tima̠x­tu­niya ta̠k­saní̠n min­ta̠­cris­tiano; caca̠­ma̠xqui cá̠cni̠t mintzí xa̠hua min­tla̠t.” ");
INSERT INTO tocNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Amá kahuasa chiné kálh­ti̠lh: —Quim­pu̠­chiná, hasta la̠ta tlak actzu̠cú xacuani̠t ctzu­cuni̠t ma̠kan­taxti̠y hua̠ntu̠ hua­nípa̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús hua­nipá: —Pero huí a̠kam­pa̠tum hua̠ntu̠ tzan­ka̠­niyá̠n mili̠t­lá­huat: castá̠t la̠ta tu̠ kalhi̠ya y caca̠­ma̠­paj­pi­tzini lak­li̠­ma̠x­kení̠n min­tumi̠n, aca­listá̠n caqui­lakta y caquis­ta̠­lani; chuná xli̠­ca̠na luu lhu̠hua min­ta­pa̠­xu­huá̠n pímpa̠t li̠ma̠s­toka cumu la̠ min­tumi̠n nac akapú̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Acxni̠ káx­matli a̠má tachu­huí̠n hua̠ntu̠ huá­nilh Jesús a̠má kahuasa cha̠­li̠­pu­hua̠na̠ alh porque luu rico xuani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesús ca̠lak­lá­ca̠lh antaní xta­yá̠­nalh xta­ma̠­kalh­ta­huaké̠n y chiné ca̠huá­nilh: —Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ luu tuhua ámaj ca̠qui̠­tax­tuniy lac­rrico xla­cata nata­maka­maklhti̠nán xta­péksi̠t Dios. ");
INSERT INTO tocNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ama̠­ko̠lh xta­ma̠­kalh­ta­huaké̠n ni̠ xtaaka­ta̠k­sni̠t hua̠ntu̠ xca̠­hua­nini̠t y cacs xta­li̠­la­ca­huán, pero Jesús ca̠hua­nipá: —Hui­xinín quin­ca­maná̠n, aquit cca̠­hua­niyá̠n xla­cata pi̠ luu tuhua naca̠­qui̠­tax­tuniy a̠ma̠ko̠lh cris­tianos hua̠nti̠ tali̠­pa̠­huán xtu­mi̠ncán y catu̠huá tali̠­lac­tla­hua­yá̠­huay xta­la­ca­pa̠s­tac­nicán xla­cata tla̠n nata­maka­maklhti̠nán xta­péksi̠t Dios. ");
INSERT INTO tocNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Y huata ni̠ xatuhua xtá­nu̠lh tantum camello nac xtzan kantum li̠tzápan que huata rico nata­tanu̠y nac xta­péksi̠t Dios y nachá̠n nac xpa̠xtú̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Acxni̠ xta­ma̠­kalh­ta­huaké̠n takax­mat­ko̠lh, cacs tala­cáhua y tzú­culh tala̠­ka­lhas­quín: —Pus para chuná, ¿tícu chi̠nchú luu nalak­ma̠xtuy xli̠s­tacni nac akapú̠n? ");
INSERT INTO tocNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús ca̠ka­lha­káx­matli y ca̠huá­nilh: —Para caj sacstu cha̠tum chixcú luu lac­pu­huán xla­cata tla̠n nalak­ma̠xtuy xli̠s­tacni, xlá ni̠lay túcu tama̠t­la̠nti̠y; pero Dios hua̠k tla̠n ma̠t­la̠nti̠y la̠ta túcu lac­pu­huán, ni̠tu̠ tuhua xpa̠­la­cata. ");
INSERT INTO tocNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Entonces Pedro chiné huá­nilh: —Quim­pu̠­chi­nacán, aquinín cak­xtek­ma­ka­ni̠­táhu la̠ta túcu xac­ka­lhi̠­yá̠hu xla­cata cca̠s­ta̠­la­ni­ni̠tán, ¿túcu chi̠nchú amá̠n quin­ca̠­lak­cha̠ná̠n? ");
INSERT INTO tocNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús ca̠kálh­ti̠lh: —Xli̠­ca̠na cca̠­hua­niyá̠n, para tícu cris­tiano naak­xtek­makán la̠ta túcu kalhi̠y, para xchic o xnat­la̠tni, o xpusca̠t xa̠hua xcamán, osuchí xpar­cela caj xla­cata naquis­ta̠­laniy osuchí caj xla­cata nama̠­kalh­chu­hui̠ni̠y cris­tianos la̠qui̠ tla̠n naca̠­ma̠­tzan­ke̠­naniy Dios xta­la̠­ka­lhi̠ncán, ");
INSERT INTO tocNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","aquit cca̠­hua­niyá̠n xla­cata a̠má chixcú luu lhu̠hua chiqui ámaj kalhi̠y la̠ta nícu nachá̠n, lhu̠hua cumu la̠ xna­ta̠lán, cumu la̠ xnat­la̠tni, osuchí cumu la̠ xca­maná̠n, o cumu la̠ xpar­cela, luu xli̠­ca̠na lhu̠hua ámaj maclay, y ma̠squi luu la̠n cali̠aksanca y ca̠li̠­pu­tza­sta̠­laca caj quim­pa̠­la­cata; porque xlacán a̠ma̠ko̠lh cris­tianos taamá̠­nalh tamaklh­ti̠nán lanca tapa̠­xu­huá̠n hua̠ntu̠ ne̠cxni lak­sputa nac akapú̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Y a̠má quilh­ta­macú lhu̠hua lac­ta­li̠­pa̠hu cris­tianos hua̠nti̠ la̠nchú luu tama­ca­pu̠­la­má̠­nalh aca­li̠stá̠n huata xlacán a̠huatá tahui­lá̠­nalh nahuán; y lhu̠hua hua̠nti̠ la̠nchú ni̠tu̠cu xka­satcán tali̠­taxtuy luu a̠huatá taqui̠­tax­tu­má̠­nalh pero acxni̠ chú a̠má quilh­ta­macú huata pu̠lh huá naca̠­ma̠x­qui̠cán xpu̠­ta­hui̠lhcán nac akapú̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Maktum quilh­ta­macú Jesús chu xta­ma̠­kalh­ta­huaké̠n xtat­la̠­hua­má̠­nalh nac tiji xtaamá̠­nalh nac ca̠chi­quí̠n Jeru­salén; Jesús xca̠­pu̠­la­nima xlacán caj xta­sta̠­la­ti̠­lhay, ni̠ xtaamputún y xta­la­ca­li̠­pu­huan­ti̠­lhay porque xta­pe̠­cuán túcu tla̠n cahuá xpá̠x­tokli Jesús antá. Xamaktum Jesús túnuj ca̠ma̠­mac­xtu­mi̠pá xka­lha­cu̠­tiycán y tzú­culh ca̠li̠­ta̠­chu­hui̠nán la̠ta túcu xlá xámaj okspulay. ");
INSERT INTO tocNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Chiné ca̠huá­nilh: —Lá eé hui­xinín ucxilh­pá̠tit ama̠­náhu nac Jeru­salén antaní amá̠­calh qui­ma­ca­ma̠s­ta̠cán aquit Xata­lac­sacni Chixcú nac xmacancán xana­puxcun cura y xma̠­kalh­ta­hua­ke̠­nacán judíos; xlacán naquin­ta­li̠lhca̠y naqui­mak­ni̠cán y naquin­ta­ma̠­la­capu̠y nac xla­ca­ti̠ncán ma̠pek­si̠­naní̠n ro­manos. ");
INSERT INTO tocNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Xlacán la̠n naquin­ta­li̠­ka­ma̠nán, naquin­ta­hui­li̠niy, naquin­ta­la­ca­chuj­mani̠y y aca­li̠stá̠n naquin­ta­makni̠y; pero aquit xliaktutu quilh­ta­macú cámaj lacas­ta­cuanán nac ca̠li̠ní̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Aca­li̠stá̠n xla­ka­huasán Zebedeo xca̠­hua­nicán San­tiago y Juan talak­ta­la­ca­tzú­hui̠lh Jesús y tahuá­nilh: —Quim­pu̠­chi­nacán, cla­cas­qui­ná̠hu xqui­la̠t­la­hua­níhu aktum li̠tlá̠n hua̠ntu̠ cca̠­mak­squim­pu­tuná̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesús ca̠huá­nilh: —¿Túcu lacas­qui­ná̠tit nac­tla­huay caj mila­ca­tacán? ");
INSERT INTO tocNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Xlacán tahuá­nilh: —Acxni̠ huix naca̠­maka­tla­ja­ko̠ya xli̠­hua̠k hua̠nti̠ tasi̠­tzi̠­niyá̠n y natzu­cuya ma̠pek­si̠­nana antá nac li̠pa̠­xúhu mim­pu̠­ma̠­peksí̠n, xqui­la̠­ma̠x­quí̠hu quilh­ta­macú xac­ta­hui­la­chá̠hu nac mim­pa̠xtú̠n xla­cata nac­ca̠­ta̠­ma̠­pek­si̠­naná̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesús ca̠kálh­ti̠lh: —Hui­xinín ni̠para tzinú catzi̠­yá̠tit hua̠ntu̠ squim­pá̠tit. ¿Lac­pu­hua­ná̠tit pi̠ tla̠n nata̠­ya­ni­yá̠tit nac a̠má lanca tapa̠tí̠n hua̠ntu̠ aquit cámaj pa̠ti̠y? ");
INSERT INTO tocNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Xlacán takalh­tí̠­nalh: —Nac­pa̠­ti̠­yá̠hu. Jesús ca̠hua­nipá: —Xli̠­ca̠na pim­pá̠tit li̠pa̠­ti̠­yá̠tit tapa̠tí̠n hua̠ntu̠ aquit ámaj quiok­spulay, y na̠chuna li̠túm pim­pá̠tit pa̠ti̠­yá̠tit hua̠ntu̠ aquit cámaj pa̠ti̠y, y juerza pim­pá̠tit ta̠ya­ni­yá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero huá la̠ hui­xinín lacas­qui­ná̠tit nac­ca̠­hui­li̠yá̠n nac quim­pa̠xtú̠n acxni̠ nac­tzucuy ma̠pek­si̠nán, ni̠ aquit cca­tzi̠y sino xma̠n huá Quin­tla̠t Dios ámaj ca̠ma̠x­qui̠y hua̠nti̠ ca̠mi­ni̠niy y ca̠li̠­ka­lhi̠­má̠­calh. ");
INSERT INTO tocNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Acxni̠ tacá­tzi̠lh xa̠maka­pi­tzí̠n xta­ma̠­kalh­ta­huaké̠n hua̠ntu̠ xta­la­cas­quín Juan chu San­tiago, tasi̠­tzí̠­nilh. ");
INSERT INTO tocNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesús hua̠k ca̠ta­sá­nilh nata­ta­la­ca­tzu­hui̠y y chiné ca̠huá­nilh: —Hui­xinín catzi̠­yá̠tit xla­cata hua̠nti̠ xana­puxcun ma̠pek­si̠­naní̠n xalac aktum pu̠la­tama̠n xlacán hua̠k taakchipay la̠ta tu̠ huí nac ca̠chi­quí̠n y luu tli­hueke tahuili̠y xli̠­ma̠­peksí̠n, na̠chuná hua̠nti̠ xalac­ta­li̠­pa̠hu taak­ska­hui­mak­lhti̠y hua̠ntu̠ taka­lhi̠y ni̠ lac­ta­li̠­pa̠hu cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero hui­xinín hua̠nti̠ qui­la̠­ta̠­la­pu̠­la­yá̠hu ni̠chuná cati­ca̠­qui̠­tax­tunín, porque hua̠nti̠ luu tali̠­pa̠hu li̠tax­tu­putún nac milak­sti̠­pa̠ncán mejor huata caj caca̠­li̠­ma­cuánilh xa̠maka­pi­tzí̠n y cat­lá­hualh hua̠ntu̠ xlacán nata­li̠­ma̠­peksi̠y xcompañeros. ");
INSERT INTO tocNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Y na̠chuná para tax­tu­ya̠chá cha̠tum la̠ hui­xinín hua̠nti̠ ca̠ma̠­pek­si̠­putún xa̠maka­pi­tzí̠n compañeros xta̠­chuná cumu la̠ xapuxcu, huata xlá luu mini̠niy nali̠­taxtuy cumu la̠ cha̠tum tasa̠cua hua̠nti̠ na̠ caj naka­lha­kax­mat­ni̠nán hua̠ntu̠ nali̠­ma̠­pek­si̠cán. ");
INSERT INTO tocNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Xta̠­chuná cumu la̠ aquit Xata­lac­sacni Chixcú ni̠ huá clak­mini̠t nac ca̠quilh­ta­macú la̠qui̠ caj naqui­li̠­ma­cuanicán, huata huá clak­mini̠t la̠qui̠ chuná nac­ca̠­li̠­ma­cuaniy xa̠maka­pi­tzí̠n, y na̠chuna li̠túm la̠qui̠ aquit nac­ma­ca­ma̠sta̠y qui­la­táma̠t xpa̠­la­cata pi̠ tla̠n nac­ca̠­pa̠­la­ka­xo­ko̠nún xla­ta­ma̠tcán lhu̠hua cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tácha̠lh nac aktum ca̠chi­quí̠n hua­nicán Jericó, caj xta­ti̠­pun­tax­tu­má̠­nalh luu lhu̠hua cris­tianos xta­sta̠­la­ni­má̠­nalh Jesús. Acxni̠ aya xta­tax­tu­má̠­nalh nac a̠má ca̠chi­quí̠n cha̠tum laka­tzí̠n hua­nicán Bar­timeo xka­huasa xuani̠t Timeo, antá xuí nac xquilhpá̠n tiji csquima limos­na. ");
INSERT INTO tocNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Acxni̠ xlá káx­matli pi̠ xta­la­ca­tzu­hui̠ma Jesús xalac Naza­ret a̠má laka­tzí̠n tzú­culh qui­lhaniy: —¡Jesús xli̠­ta­la­ka­pasni David, cat­lahua li̠tlá̠n caqui­ma̠­la­cát­la̠nti! ");
INSERT INTO tocNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Lhu̠hua ti̠ tala­ca­quílh­ni̠lh xla­cata cacs caqui­lhua, pero xlá li̠huaca tzú­culh qui­lhaniy: —¡Jesús xli̠­ta­la­ka­pasni David, cat­lahua li̠tlá̠n caqui­ma̠­la­cát­la̠nti! ");
INSERT INTO tocNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesús chókoj lalh y ca̠huá­nilh xa̠maka­pi­tzí̠n cris­tianos: —Cahua­nítit camilh tamá laka­tzí̠n. Y cha̠tum alh tasaniy y chiné huá­nilh: —Catu̠x­ca̠ni, kahua; cata̠ya porque Jesús tasa­nimá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Xlá lhken ma̠kó­sulh xmac­ta­huaca nac tíyat, la̠li̠­huán tá̠yalh y tala­ca­tzú­hui̠lh antaní xyá Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús kalhás­quilh: —¿Túcu laca­squina cac­tlá­hualh mila­cata? Amá laka­tzí̠n chiné kalh­tí̠­nalh: —Quim­pu̠­chiná, aquit clac­pu­huán xac­la­ca­huá̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús huá­nilh: —Tla̠ná li̠pa̠­xúhu napina nac mín­chic. Huix aya pímpa̠t laca­hua̠­nana porque qui­li̠­pa̠­hua­ni̠ta. Amá laka­tzí̠n acxni­tuncán laca­huá̠­nalh y na̠ sta̠­lá­nilh Jesús antaní xlá xama. ");
INSERT INTO tocNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Acxni̠ tácha̠lh nac aktum ke̠stí̠n hua­nicán Monte de los Olivos, xma̠­la­ka­tancs aktiy ca̠chi­quí̠n ca̠hua­nicán Bet­fagé y Betania, u̠ma̠ko̠lh ca̠chi­quí̠n ta̠pek­sto­kuila­ko̠lh Jeru­salén, Jesús ca̠má­ca̠lh cha̠tiy xdis­cí­pulos ");
INSERT INTO tocNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","y ca̠huá­nilh: —Capim­pítit nac a̠má ca̠chi­quí̠n hua̠ntu̠ hui­lachi tuncán, acxni̠ nachi­pi­ná̠tit nac aktum chiqui hui­xinín naucxi­lhá̠tit pi̠ chi̠­ya̠­hua­cani̠t tantum burro hua̠ntu̠ ni̠ti̠ a̠ ke̠ta­huilay, la̠li̠­huán nax­cu­tá̠tit y nali̠­ta­ná̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Y para tícu naca̠­hua­niyá̠n túcu li̠la­yá̠tit, hui­xinín cahua­nítit: “Quim­pu̠­chi­nacán mac­la­cas­quim­putún y pálaj napu̠s­pit­paray.” ");
INSERT INTO tocNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Xlacán táalh y xli̠­ca̠na tama̠­nók­lhulh tantum burro xchi̠­ya̠­hua­cani̠t nac xtan­quilhtí̠n aktum chiqui lacatzú cmá̠­lacchi. Xlacán táx­cutli ");
INSERT INTO tocNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","y hua̠nti̠ antá xta­la­yá̠­nalh lacatzú taúcxilhli hua̠ntu̠ xtat­la­hua­má̠­nalh, chiné ca̠hua­níca: —¿Túcu tla­hua­pu­tu­ná̠tit? ¿Túcu li̠la­yá̠tit xcu­tá̠tit tamá burro? ");
INSERT INTO tocNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ama̠­ko̠lh dis­cí­pulos chuná takalh­tí̠­nalh la̠ xca̠­hua­nini̠t Jesús y niaj tu̠ ca̠hua­ní­calh, ca̠ma̠x­quí̠­calh tala­cas­quín natalé̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tali̠­mí­nilh a̠má burro antaní xuí Jesús y tali̠­ke̠t­la­pá­nilh clha­ka̠tcán, Jesús ke̠táhui ");
INSERT INTO tocNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","y la̠li̠­huán táalh pekán cJerusalén. Lhu̠hua ti̠ tzú­culh tata­rami̠y clha­ka̠tcán nac tiji antaní xla­cama y maka­pi­tzí̠n tzú­culh taca̠y lactzú xmakx­pi̠ní̠n ke̠ske y na̠ xta­ta­rami̠y nac tiji. ");
INSERT INTO tocNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Y lhu̠hua cris­tianos ti̠ xta­pu̠­la­má̠­nalh xa̠hua ti̠ xta­sta̠­la­ni­ti̠­lhay chiné tzú­culh tama̠­tasi̠y: —¡Cama̠x­quí̠hu cá̠cni̠t Dios! ¡Dios casi­cu­la­na̠t­lá­hualh eé chixcú hua̠nti̠ xlá maca­mima! ");
INSERT INTO tocNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Dios casi­cu­la­na̠t­lá­hualh xli̠­ma̠­peksí̠n hua̠ntu̠ xlá ma̠la­ka­cha̠ni̠t xla­cata naquin­ca̠­ma̠­pek­si̠yá̠n na̠chuná la̠ ma̠pek­sí̠­nalh xamaká̠n quin­quilh­tzu­cutcán rey David! ¡Cala­ka­chix­cu­huí̠hu Dios caj xpa̠­la­cata tu̠ tla­huama! ");
INSERT INTO tocNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pus chuná tanu̠chá Jesús nac Jeru­salén, aca­li̠stá̠n alh nac lanca pu̠si­culan xalac Jeru­salén. Y acxni̠ ko̠ta­nu̠­ko̠lh ca̠ta̠ampá xdis­cí­pulos nac Betania porque aya xca̠s­ma­lan­kama. ");
INSERT INTO tocNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Li̠cha̠lí tzi̠sa Jesús taca̠xpá nac Betania y la̠ta xtla̠­huama xlá tzú­culh tzincsa. ");
INSERT INTO tocNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ali̠­mákat úcxilhli akatum suji luu stakni̠t xtá̠ya xapalhma, alh ucxilha para xka­lhi̠y xta­huácat pero ni̠tu̠ mac­lá­nilh acxni̠ lák­cha̠lh porque ni̠ xquilh­ta­macú xuani̠t la̠ nata­huacay xta­huácat. ");
INSERT INTO tocNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesús chiné huá­nilh a̠má suji: —Aquit cla­cas­quín pi̠ niaj para cha̠tum cris­tiano nahua­paray min­ta­huácat. Y xta­ma̠­kalh­ta­huaké̠n hua̠k takáx­matli hua̠ntu̠ huá­nilh a̠má suji. ");
INSERT INTO tocNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Caj li̠puntzú tácha̠lh nac Jeru­salén, Jesús tuncán ta̠nu̠lh nac lanca pu̠si­culan y tzú­culh ca̠ta­mac­xtuy hua̠nti̠ antá xta­sta̠­na­má̠­nalh xa̠hua ti̠ xta­ta­ma̠­hua­na­má̠­nalh nac xtan­quilhtí̠n pu̠si­culan, ca̠ma̠k­pu̠s­pít­nilh xme­sajcán hua̠nti̠ xta­lak­pa­li̠­má̠­nalh tumi̠n xa̠hua ti̠ xta­ka­lhi̠y xpa̠­lo­ko­yucán ca̠na̠spu̠n y xtasta̠y. ");
INSERT INTO tocNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Niajti̠ má̠x­qui̠lh quilh­ta­macú xla­cata nata̠­ta­nu̠­ya̠chá xlí̠sta̠t nac xtan­quilhtí̠n pu̠si­culan. ");
INSERT INTO tocNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Y chiné ca̠huá­nilh a̠ma̠ko̠lh lac­chix­cu­huí̠n: —Nac xta­chu­huí̠n Dios hua̠ntu̠ tatzok­ta­hui­lani̠t nac li̠kalh­ta­huaka chiné huan: “Umá quín­chic luu cajhuá nali̠­ma̠x­tucán pi̠ antá naquin­ta­kalh­ta­hua­kaniy xli̠­hua̠k cris­tianos cani̠huá xalaní̠n”, pero hui­xinín aya li̠ma̠x­tu­ni̠­tátit cumu la̠ xpu̠­ta­tze̠k­nicán kalha̠­naní̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Maka­pi­tzí̠n xma̠­kalh­ta­hua­ke̠­nacán judíos xa̠hua xana­puxcun cura takáx­matli hua̠ntu̠ xlá xqui­lhuama huata tzú­culh talac­pu­tzay lácu natat­la­huay xla­cata tze̠k nata­makni̠y, porque xta­pe̠­cuaniy la̠ta xca̠­ma̠­kalh­chu­hui̠ni̠y cris­tianos y xli̠­hua̠k xta­ca̠­naj­laniy hua̠ntu̠ xlá xca̠­li̠­ta̠­chu­hui̠nán. ");
INSERT INTO tocNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Acxni̠ aya tzú­culh ca̠s­ma­lankán Jesús ca̠ta̠­ta­ca̠xpá xdis­cí­pulos y ca̠ta̠ampá cBetania. ");
INSERT INTO tocNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Li̠cha̠lí laca­tzi̠sa lacatzú tati̠­táx­tulh antaní xyá a̠má suji hua̠ntu̠ tila­ca­quílh­ni̠lh Jesús y taúcxilhli pi̠ hua̠k csca̠c­ko̠ni̠t la̠ta xakán hasta xtan­káxe̠k. ");
INSERT INTO tocNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedro laca­pa̠s­tac­tá̠­yalh y chiné huá­nilh Jesús: —Quim­pu̠­chi­nacán, caúcxilhti a̠má suji hua̠ntu̠ tila­ca­quilhni ko̠tán, aya acsca̠c­ta̠­ya­ko̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús chiné kálh­ti̠lh: —Huá lí̠lalh xla­cata nali̠­pa̠­hua­ná̠tit Dios. ");
INSERT INTO tocNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Pus luu xli̠­ca̠na cca̠­hua­niyá̠n para tícu nahuaniy eé ke̠stí̠n: “Cata­ke̠nu la̠ tahuila y capit taju̠ya nac pupunú”, para xlá ca̠najlay y catzi̠y pi̠ chuná naqui̠­taxtuy xli̠­ca̠na chuná ámaj qui̠­tax­tuniy. ");
INSERT INTO tocNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Na̠chu­na­li̠túm para túcu namaks­qui­ná̠tit Dios acxni̠ hui­xinín nakalh­ta­hua­ka­ni­yá̠tit, para li̠pa̠­hua­ná̠tit y catzi̠­yá̠tit pi̠ xlá amá̠n ca̠ma̠x­qui̠yá̠n xli̠­ca̠na chuná naca̠­qui̠­tax­tu­niyá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Na̠chu­na­li̠túm acxni̠ hui­xinín nakalh­ta­hua­ka­ni­yá̠tit Dios, para tícu min­ta̠­cris­tiano ta̠ra̠t­la­hua­ni̠tán y ta̠la̠­ma­ka­si̠­tzi̠­ni̠tán, pus huata pu̠lhá cata̠­pa̠ti y cama̠­tzan­ke̠­nani laquimpi Min­tla̠­ticán hua̠nti̠ hui­lachá nac akapú̠n na̠ naca̠­ma̠­tzan­ke̠­na­niyá̠n min­ta­la̠­ka­lhi̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pero para hui­xinín ni̠ nala̠­ma̠­tzan­ke̠­na­ni­yá̠tit hua̠ntu̠ ca̠t­la­hua­ni­ni̠tán min­ta̠­cris­tiano, pus na̠chuná Min­tla̠­ticán Dios hua̠nti̠ hui­lachá nac akapú̠n na̠ ni̠ cati­ca̠­ma̠­tzan­ke̠­nanín min­ta­la̠­ka­lhi̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tatas­pitpá nac Jeru­salén y acxni̠ xta­lak­cho­ko­pu̠lay Jesús nac pu̠si­culan talak­ta­la­ca­tzú­hui̠lh xana­puxcun cura chu xma̠­kalh­ta­hua­ke̠­nacán judíos, xa̠hua lak­ko̠­lu­tzi̠nni ma̠pek­si̠­naní̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Chiné taka­lhás­quilh: —¿Túcu xpa̠­la­cata huix li̠si̠­tzi̠ya la̠ta tu̠ lama nac pu̠si­culan? ¿Tícu ma̠x­qui̠­ni̠tán li̠ma̠­peksí̠n xla­cata chuná nat­la­huaya? ");
INSERT INTO tocNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Pero Jesús ca̠kálh­ti̠lh: —Pus aquit na̠ huí hua̠ntu̠ camá̠n ca̠kalh­pu­tzayá̠n, para hui­xinín naqui­la̠­kalh­ti̠­yá̠hu pus aquit na̠ nac­ca̠­hua­niyá̠n tícu qui­ma̠x­qui̠ni̠t li̠ma̠­peksí̠n xla­cata hua̠ntu̠ ctla­huay. ");
INSERT INTO tocNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","La̠n­chuj tuncán caqui­la̠­hua­níhu, ¿tícu má̠x­qui̠lh li̠ma̠­peksí̠n Juan Bau­tista xla­cata naakmu­nu̠nún, pi̠ huá Dios osuchí lac­chix­cu­huí̠n? ");
INSERT INTO tocNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Xlacán tzú­culh tala̠­li̠­ta̠­kalh­chu­hui̠nán, xta­la̠­ka­lhas­quín y xta­la̠­huaniy: —Para nahua­ni­yá̠hu pi̠ Dios ma̠la­ká­cha̠lh naquin­ca̠­hua­niyá̠n: “¿Lácu chi̠nchú ni̠ li̠ca̠­naj­la­nítit hua̠ntu̠ ca̠li̠­ta̠­chu­hui̠nán?” ");
INSERT INTO tocNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Y para nahua­ni­yá̠hu pi̠ huá cris­tianos li̠ma̠­pék­si̠lh na̠ ni̠lay. Pus ni̠chuná xta­li̠­kalh­ti̠­nam­putún porque xta­ca­tzi̠y pi̠ luu lhu̠hua xca̠­naj­la­ni­cani̠t xla­cata pi̠ Dios xli̠­ca̠na xma̠­la­ka­cha̠ni̠t Juan Bau­tista naliakchu­hui̠nán xta­la­ca­pa̠s­tacni, huá xta­li̠­pe̠­cuaniy xli̠­lhu̠hua cris­tianos; y xlacán ni̠ tacá­tzi̠lh lácu nata­kalh­ti̠nán. ");
INSERT INTO tocNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Chiné tali̠­huá­nilh Jesús: —Ni̠ cca­tzi̠­yá̠hu. Jesús ca̠kálh­ti̠lh: —Pus na̠ ni̠para aquit cac­ti­ca̠­huanín tícu qui­ma̠x­qui̠ni̠t li̠ma̠­peksí̠n xla­cata la̠ta tu̠ aquit tla̠n ctla­huay. ");
INSERT INTO tocNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Caj li̠puntzú Jesús tzú­culh ca̠ma̠­kalh­chu­hui̠ni̠y cris­tianos, caj ca̠li̠­ta̠­chu­huí̠­nalh aktum takalh­chu­huí̠n, chiné ca̠huá­nilh: —Maktum quilh­ta­macú xuí cha̠tum chixcú chalh nac xpu̠­cuxtu lhu̠hua xali̠­chánat uva. Xlá li̠huana̠ sti­lim­pá­calh, aca­li̠stá̠n tlá­hualh aktum lanca torre antaní nata­huacay ti̠ namak­ta­kalha xta­chaná̠n. Y na̠ tlá­hualh xpu̠­chitni la̠qui̠ antá nalak­chita xuvas acxni̠ nacha̠y. Ni̠ maka̠s quilh­ta­macú xlá ca̠ma̠­cuentáj­li̠lh maka­pi­tzí̠n tasa̠­cuá̠n xca̠­ta­cuxtu, xlá alh latama̠y mákat ca̠chi­quí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Acxni̠ lák­cha̠lh quilh­ta­macú la̠ta tzucuy cha̠y y lak­chitcán uvas, xlá ma̠la­ká­cha̠lh cha̠tum xta­sa̠cua xla­cata naca̠s­qui­nicán hua̠ntu̠ xlak­chá̠n xlá nachipay xata­chitni uvas. ");
INSERT INTO tocNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero xlacán tachí­palh, la̠n taakka­xí­mi̠lh, caj chu­natá tama­ca̠mpá y ni̠tu̠ tamá̠x­qui̠lh tachitni. ");
INSERT INTO tocNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Amá xapu̠­chiná pú̠cuxtu ma̠la­ka­cha̠pá tunuj­li̠túm xta­sa̠cua, pero xla̠ taliacta­lan­chí­palh chí­huix, taákpak­lhli y cala̠huá tahuá­nilh. ");
INSERT INTO tocNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Xapu­chiná ca̠ta­cuxtu ma̠la­ka­cha̠pá a̠cha̠tum xta­sa̠cua, pero xlá mak­ni̠­canchá. Na̠chuná lhu̠hua ca̠ma̠­la­ka­cha̠pá xta­sa̠­cuá̠n; hui̠ntí ca̠mak­ní̠­calh y maka­pi­tzí̠n ca̠lak­ka­xi­mí̠­calh. ");
INSERT INTO tocNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Amá ko̠lu­tzí̠n a̠hua­tiyá chú xka­lhi̠y cha̠tum xka­huasa luu xli̠­ca̠na xpa̠x­qui̠y; xlac­pu­huán: “Para nac­ma̠­la­ka­cha̠y quin­ka­huasa, ma̠x a̠huayu nata­kax­matniy hua̠ntu̠ naca̠­huaniy.” Xli̠­ca̠na ma̠la­ká­cha̠lh xka­huasa. ");
INSERT INTO tocNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Y acxni̠ ca̠lák­cha̠lh a̠má kahuasa, a̠ma̠ko̠lh tasa̠­cuá̠n chiné tzú­culh tala̠­huaniy: “Huá tamá kahuasa ti̠ nata­mak­xtek­niko̠y pu̠tum u̠má pú̠cuxtu, huata mejor camak­ní̠hu la̠qui̠ aquinín naquin­ca̠­ta­mak­xtek­ni­ko̠yá̠n.” ");
INSERT INTO tocNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Amá xka­huasa xapu̠­chiná a̠má pú̠cuxtu tachí­palh tamák­ni̠lh y tata­mác­xtulh xti­yat­li̠hua, táalh tamakán nac xqui­lhapá̠n pú̠cuxtu. ");
INSERT INTO tocNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jesús ca̠ka­lhás­quilh a̠ma̠ko̠lh lac­chix­cu­huí̠n hua̠nti̠ xta­kax­mat­ni­má̠­nalh: —¿Túcu hui­xinín lac­pu­hua­ná̠tit nat­la­huay a̠má xpu̠­china pú̠cuxtu? Pus eé xapu̠­chiná ámaj min y naca̠­mak­ni̠ko̠y a̠ma̠ko̠lh ni̠ lacuán tasa̠­cuá̠n y xlá naca̠­ma̠x­qui̠y xpu̠­chaná̠n tunuj tasa̠­cuá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’Hui­xinín, ¿Pi̠ nia̠ li̠kalh­ta­hua­ka­yá̠tit la̠ tatzokni̠t xta­chu­huí̠n Dios nac li̠kalh­ta­huaka? Lacatum chiné tatzokni̠t: Amá lanca chí­huix hua̠ntu̠ tita­lak­má­kalh tzap­snaní̠n porque tita­lac­púhua pi̠ ni̠tu̠ li̠ma­cuán, huata la̠nchú huá luu li̠ma­cuama porque huá ani̠t li̠jaxko̠y la̠ta xli̠­lanca chiqui. ");
INSERT INTO tocNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Pero huá Quim­pu̠­chi­nacán Dios hua̠nti̠ lac­lhca̠ni̠t xla­cata chuná naqui̠­taxtuy la̠qui̠ aquinín caj cacs nali̠­la­ca­hua­ná̠hu la̠ta túcu tla­huani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Pus xlacán xta­chi̠­le̠m­putún Jesús porque xtaaka­ta̠k­sni̠t pi̠ caj xlac­sacni̠t u̠má takalh­chu­huí̠n xla­cata naca̠­li̠­ma̠­la­ca­hua̠ni̠y. Pero cumu lhu̠hua cris­tianos xta­la­yá̠­nalh hua̠nti̠ xta­ca̠­naj­la­nini̠t xta­chu­huí̠n pus tapé̠­cualh chicá nata­si̠­tzi̠niy, y huata mejor caj taak­xtek­yá̠­hualh y taalhá. ");
INSERT INTO tocNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Caj li̠puntzú hua̠nti̠ xta­si̠­tzi̠niy Jesús tama̠­la­ká­cha̠lh maka­pi­tzí̠n fariseos xa̠hua ti̠ xta­ta̠­yá̠­nalh rey Herodes, caj xta­ma̠­kalh­pu­tza̠­ni̠­putún chicá para túcu ni̠tlá̠n naca̠­li̠­chu­hui̠nán ma̠pek­si̠­naní̠n la̠qui̠ chuná nata­ma̠­la­capu̠y. ");
INSERT INTO tocNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Acxni̠ talák­chilh chiné taka­lhás­quilh: —Ma̠kalh­ta­hua­ke̠ná, cca­tzi̠­yá̠hu xla­cata hua̠ntu̠ huix huana luu huá talu­lóktat, y huix ni̠ti̠cu li̠quilh­pu­huana y hua­niya hua̠ntu̠ ni̠tlá̠n tla­huama, ma̠squi lhu̠hua hua̠nti̠ ni̠ taliucxilh­pu­tuná̠n, huata laca­squina xli̠­pu̠tum cris­tianos nata­la­ka­pasa la̠ta lácu Dios lacas­quín nata­la­tama̠y. Pus caqui­la̠­hua­níhu, ¿pi̠ lak­chá̠n la̠ta cla­ka­xo­ko̠­nu­ni­yá̠hu a̠má xapuxcu gobier­no xalac Roma? ¿Pi̠ tla̠n cla­ka­xo­ko̠­nu­ni­yá̠hu o ni̠tlá̠n la̠ cla­ka­xo­ko̠­nu­ma̠­náhu? ");
INSERT INTO tocNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesús xca­tzi̠y pi̠ caj xta­kalh­pu­tza­má̠­nalh y chiné ca̠huá­nilh: —¿Túcu xpa̠­la­cata hua­tiyá chú qui­la̠­lac­pu­tza̠­na­ni­má̠hu hua̠ntu̠ tla̠n naqui­la̠­li̠­ma̠­ma­ko­si̠­ya̠­hua­yá̠hu? Cali̠­tátit okxtum tumi̠n la̠qui̠ nacuc­xilha. ");
INSERT INTO tocNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Li̠mi­nica okxtum tumi̠n, acxni̠ úcxilhli Jesús ca̠ka­lhás­quilh: —¿Tícu xla­capú̠n talh­ca̠ni̠t eé, y tícu xta­cu­huiní tatzok­ta­hui­lani̠t nac eé tumi̠n? Xlacán takalh­tí̠­nalh: —Huá xla­capú̠n xapuxcu ma̠pek­si̠ná romano. ");
INSERT INTO tocNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesús ca̠huá­nilh: —Pus cama­ca­ma̠x­quí̠tit gobier­no hua̠ntu̠ lak­chá̠n gobier­no, y na̠chuná cama­ca­ma̠x­quí̠tit Dios hua̠ntu̠ lak­chá̠n nama­ca­ma̠x­qui̠­yá̠tit. Xlacán caj cacs tala­cáhua y niaj xta­ca­tzi̠y túcu nata­ka­lhas­quim­paray. ");
INSERT INTO tocNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Aca­li̠stá̠n táalh tata̠­chu­hui̠nán Jesús maka­pi­tzí̠n sadu­ceos. Uma̠­kó̠lh cris­tianos xta­huán pi̠ xli̠s­tacni cha̠tum cris­tiano ni̠ cati­la­cas­ta­cuánalh acxni̠ nani̠y, pus huá xpa̠­la­cata tali̠­ka­lhás­quilh: ");
INSERT INTO tocNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Ma̠kalh­ta­hua­ke̠ná, Moisés quin­ca̠­mak­xtek­ni­ni̠tán aktum tapéksi̠t, para cha̠tum chixcú nani̠y naak­xtek­makán xpusca̠t y ni̠tu̠ ta̠ká­lhi̠lh xca­mancán, tla̠n hua­tiyá cha̠tum xta̠lá nata̠­ta­maka­xtoka xya̠stá y nata̠­ka­lhi̠y xca­mancán la̠qui̠ ni̠ nalak­sputa xta­cu­huiní xta̠lá hua̠nti̠ ni̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Pus maktum quilh­ta­macú xta­hui­lá̠­nalh kalha­tujún laka­huasán li̠na­ta̠lán, xapuxcu tama­káx­tokli, y ni̠ li̠maka̠s ni̠lh pero ni̠ taká­lhi̠lh xca­mancán. ");
INSERT INTO tocNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Xli̠­cha̠tiy xta̠lá ta̠ta­ma­káx­tokli xya̠stá, y ni̠ li̠maka̠s quilh­ta­macú xlá na̠ ni̠pá y ni̠para huá ta̠ká­lhi̠lh xca­mancán. Na̠ chuná okspú­lalh xli̠­ka­lha­tutu. ");
INSERT INTO tocNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Y pu̠tum xli̠­ka­lha­tu­juncán hua̠k tata̠­ta­ma­káx­tokli a̠má pusca̠t, y ni̠para cha̠tum ta̠ká­lhi̠lh xca­mancán. Y ni̠ li̠maka̠s a̠má pusca̠t na̠ ni̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Chi̠nchú acxni̠ xli̠s­tac­nicán nata­la­cas­ta­cuanán nac ca̠li̠ní̠n y nata­la­ta­ma̠­paray, ¿tícuya̠ chixcú luu xpusca̠t ámaj huán, pus hua̠k tata̠­ta­ma­káx­tokli xka­lha­tu­juncán? ");
INSERT INTO tocNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesús ca̠kálh­ti̠lh: —Hui­xinín luu xli̠­ca̠na aktzan­ka̠­ni̠­tátit porque ni̠ catzi̠­yá̠tit y ni̠ aka­ta̠k­sá̠tit lácu huan xta­chu­huí̠n Dios hua̠ntu̠ tatzok­ta­hui­lani̠t nac li̠kalh­ta­huaka, y na̠ ni̠para catzi̠­yá̠tit lácu kalhi̠y xli̠t­li­hueke Dios, lácu xlá ca̠li̠­ka­lhi̠­ma̠chá xli̠s­tac­nicán ní̠n nac akapú̠n acxni̠ xlá naca̠­ma̠­laca­stac­uani̠y nac ca̠li̠ní̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Porque acxni̠ ni̠n nata­la­cas­ta­cuanán nac ca̠li̠ní̠n a̠ma̠ko̠lh lac­chix­cu­huí̠n xa̠hua lac­pus­ca̠tní̠n niaj ti̠ cati­ta­ma­káx­tokli, ni̠para cati­ta­ká­lhi̠lh xlac­tzu­ma­jancán hua̠nti̠ nata­ma̠­maka­xtoka, porque chuná nata­li̠­taxtuy cumu la̠ xán­geles Dios hua̠nti̠ tahui­la̠­nanchá nac akapú̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Chú xla­cata para nata­la­cas­ta­cuanán ni̠n, osuchí ni̠ nata­la­cas­ta­cuanán, ¿pi̠ ni̠ aka­ta̠k­sá̠tit lácu huam­putún li̠kalh­ta­huaka hua̠ntu̠ tzokli Moisés acxni̠ xlá tzokli la̠ ta̠chu­huí̠­nalh Dios nac akatum actzu̠ quihui acxni̠ xak­xko­ta̠­yama? Chiné huá­nilh: “Aquit xDios Abraham xa̠hua xlá Isaac chu xlá Jacob.” ");
INSERT INTO tocNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Antá huam­putún pi̠ hua̠nti̠ tala­má̠­nalh xas­tacná nac ca̠quilh­ta­macú chu hua̠nti̠ aya tani̠ni̠t lac­xtum lá̠m­para xas­tac­nacú tala­má̠­nalh, porque Dios ni̠ huá xDioscán ni̠n sinoque hua̠nti̠ tala­má̠­nalh xas­tacná. ");
INSERT INTO tocNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Cha̠tum xma̠­kalh­ta­hua­ke̠­nacán judíos xlá xka­lha­kax­matma la̠ xca̠­ta̠­la̠­hua­nima Jesús a̠má lac­chix­cu­huí̠n, y cumu aká­ta̠ksli pi̠ tla̠n xkalh­ti̠­nani̠t, na̠ tala­ca­tzú­hui̠lh xla­cata nakalh­pu­tzay, chiné kalhás­quilh: —La̠ta xli̠­pacs li̠ma̠­peksí̠n hua̠ntu̠ Dios ma̠s­ta̠ni̠t nat­la­hua­yá̠hu, ¿xatú­cuya̠ tlak xla­ca­squinca? ");
INSERT INTO tocNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús kálh­ti̠lh: —Hua̠ntu̠ tlak xla­ca­squinca li̠ma̠­peksí̠n la̠ta xli̠­pacs chiné huan: “Cakax­páttit cha̠­tunu hui­xinín xalac Israel, huá Quim­pu̠­chi­nacán Dios xta̠stum huá Dios, ni̠ti̠ a̠cha̠tum anán, y xma̠nhuá Mim­pu̠­chiná nat­la­huaya. ");
INSERT INTO tocNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Huá capa̠xqui y cali̠­pá̠­huanti Mim­pu̠­chiná Dios xli̠­hua̠k minacú, xli̠­hua̠k mili̠s­tacni, xli̠­hua̠k min­ta­la­ca­pa̠s­tacni y xli̠­hua̠k mili̠t­li­hueke.” ");
INSERT INTO tocNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Y xli̠­kam­pa̠tiy li̠ma̠­peksí̠n hua̠ntu̠ na̠ caj xta̠­chuná, chiné huan: “Cala­ka­lhá­manti min­ta̠­cris­tiano xta̠­chuná cumu la̠ me̠cstu laka­lha­man­cana.” Huá la̠ta u̠ma̠ko̠lh kam­pa̠tiy li̠ma̠­peksí̠n ni̠ anán a̠kam­pa̠tum hua̠ntu̠ tlak xla­ca­squinca o hua̠ntu̠ Dios lacas­quín nama̠­kan­tax­ti̠­yá̠hu. ");
INSERT INTO tocNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Amá xma̠­kalh­ta­hua­ke̠­nacán judíos huá­nilh Jesús: —Ma̠kalh­ta­hua­ke̠ná, luu cma̠t­la̠nti̠y tu̠ huana, pus xli̠­ca̠na hua̠ntu̠ huana, caj xma̠n cha̠tum Dios kalhi̠­yá̠hu y ni̠ti̠ anán a̠cha̠tum. ");
INSERT INTO tocNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Pus xli̠­cána luu qui­li̠­pa̠x­qui̠tcán Dios xli̠­hua̠k qui­na­cujcán, xli̠­hua̠k quin­ta­la­ca­pa̠s­tac­nicán, xli̠­hua̠k qui­li̠s­tac­nicán y xli̠­hua̠k qui­li̠t­li­hue­kecán. Pus hua̠nti̠ tla­huay eé kam­pa̠tiy li̠ma̠­peksí̠n nac xla­táma̠t a̠tzinú maka­pa̠­xu­huay Dios ni̠xa­chuná la̠ta túcu nahui­li̠­nicán nac pu̠si­culan, osuchí namak­ni̠­nicán qui­tzis­tancá̠n xla­cata nali̠­la­ka­chix­cu­hui̠­yá̠hu. ");
INSERT INTO tocNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Acxni̠ káx­matli Jesús la̠ aksti̠tum kálh­ti̠lh a̠má chixcú, chiné huá­nilh: —Pus huix aka­tá̠k­spa̠t la̠ Dios ma̠pek­si̠­nam­putún nac mila­táma̠t, y la̠m­para niaj mákat nata­nu̠­ya̠pi nac xta­péksi̠t Dios. Aca­li̠stá̠n niaj tícu kalhás­quilh para túcu. ");
INSERT INTO tocNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Antacú xlama Jesús nac pu̠si­culan y tzu­cupaj ca̠ma̠­kalh­chu­hui̠ni̠y cris­tianos, chiné ca̠ka­lhás­quilh: —¿Túcu xla­cata tali̠­huán xma̠­kalh­ta­hua­ke̠­nacán judíos xla­cata pi̠ Cristo hua̠nti̠ namín ca̠lak­ma̠x­tuyá̠n mat xli̠­ta­la­ka­pasni xamaká̠n rey David nahuán? ");
INSERT INTO tocNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Porque maktum quilh­ta­macú hua­tiyá rey David acxni̠ Espíri­tu Santo ma̠lac­pu­huá̠­ni̠lh chiné tili̠­chu­huí̠­nalh Cristo: Quim­pu̠­chiná Dios chiné huá­nilh cha̠tum li̠túm ti̠ na̠ Quim­pu̠­chiná: “Cata­huila nac quim­pa̠xtú̠n xla­cata naquin­ta̠­ma̠­pek­si̠­nana, hasta acxni̠ aquit nac­ca̠­maka­tla­jako̠y pu̠tum hua̠nti̠ tasi̠­tzi̠­niyá̠n li̠mac­xtum nata­la­ka­chix­cu­hui̠yá̠n.” ");
INSERT INTO tocNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Pus, ¿lácu chú lac­pu­hua­ná̠tit xla­cata Cristo xli̠­ta­la­ka­pasni nahuán rey David para hua­tiyá David xca̠c­ni̠­naniy xli̠­ma̠­pa̠­cu­hui̠y, Quim­pu̠china? Amá quilh­ta­macú luu lhu̠hua xta­kax­matniy xta­chu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","La̠ta Jesús xca̠­ma̠­kalh­chu­hui̠ni̠y cris­tianos chiné ca̠hua­nipá: —Ská­lalh cata­hui­látit ni̠ naca̠ak­ska­hui­mi̠yá̠n a̠má mima̠­kalh­ta­hua­ke̠­nacán hua̠nti̠ tama̠­siyuy xley Moisés. Xlacán tapu̠­la­ta­ma̠­putún lac­pu̠lhmá̠n clha­ka̠tcán y na̠ tala­kati̠y hua̠k naca̠c­ni̠­na­nicán antaní naca̠­xa­kat­li̠­pa̠x­tokcán nac tiji. ");
INSERT INTO tocNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Acxni̠ taán nac pu̠si­culan tala­cas­quín naca̠­li̠­ka­lhi̠cán tlak lacuán pu̠tá­hui̠lh anta­nícu nata­ta­huilay, y na̠chuná tat­la­huay anta­nícu huí pu̠pa̠xcua. ");
INSERT INTO tocNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Y hua̠nti̠ ca̠ni̠­makan­cani̠t lac­chaján taak­ska­hui­mak­lhti̠y xchiccán, la̠qui̠ ni̠ti̠ mat naca­tzi̠y lácu xta̠­yatcán maka̠s takalh­ta­hua­kaniy Dios. Pero ni̠para tzinú taca­tzi̠y xla­cata pi̠ a̠tzinú xlacán la̠n a̠ma̠ko̠lh tapa̠­ti̠nán. ");
INSERT INTO tocNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Maktum quilh­ta­macú Jesús xuí lacatzú antaní hui­la­ko̠lh cajas xla limos­nas, xlá caj xca̠ucxilhma cris­tianos la̠ xta­ma­ju̠­má̠­nalh tumi̠n; y lac­rrico xta­maju̠y lhu̠hua tumi̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Caj li̠puntzú chilh cha̠tum pu̠ni̠na pusca̠t luu xli̠­ca̠na li̠ma̠xken xuani̠t, y nac aktum caja xlá máju̠lh okxtiy tumi̠n xla cobre nitúcu tuncán xta­palh xuani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesús ca̠ta­sá­nilh xta­ma̠­kalh­ta­huaké̠n, chiné ca̠huá­nilh: —Xli̠­ca̠na cca̠­hua­niyá̠n, eé li̠ma̠xken viuda a̠tzinú lhu̠hua maju̠ni̠t tumi̠n nac caja ni̠xa­chuná a̠ma̠ko̠lh lac­rrico hua̠nti̠ tama­ju̠­ko̠ni̠t lhu̠hua tumi̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Pus xlacán tama̠s­ta̠ni̠t hua̠ntu̠ aya xca̠aka­ta̠x­tu­nini̠t, pero xlá tamá pusca̠t caj la̠ta xca̠­ta­pobre ma̠s­ta̠­ko̠ni̠t hua̠ntu̠ xka­lhi̠y tu̠ xti­li̠­mac­uánilh. ");
INSERT INTO tocNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesús aya xtax­tu­ma̠chi nac lanca pu̠si­culan xalac Jeru­salén y cha̠tum xdis­cí­pulo chiné huá­nilh: —Ma̠kalh­ta­hua­ke̠ná, caca̠úcxilhti lak­li̠­la­káti̠t chí­huix hua̠ntu̠ li̠ca̠x­tla­hua­cani̠t u̠má pá̠tzaps xla pu̠si­culan. ");
INSERT INTO tocNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús kálh­ti̠lh: —Luu tla̠n ucxílhpa̠t u̠ma̠ko̠lh chí­huix hua̠ntu̠ li̠ca̠x­tla­hua­cani̠t eé pu̠si­culan, pero ni̠ catzi̠ya xla­cata niaj maka̠s quilh­ta­macú eé pu̠si­culan niaj cati­ta­sí­yulh porque amá̠­calh lac­tilh­mi̠cán y niaj para aktum chí­huix cati­tahui antaní xca̠­hui­li̠­cani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Y aca­li̠stá̠n ca̠tá̠alh xdis­cí­pulos nac aktum ke̠stí̠n hua­nicán Monte de los Olivos. Umá ke̠stí̠n luu xma̠­la­ka­tancs lanca pu̠si­culan nac Jeru­salén xuilachá. Acxni̠ antá tácha̠lh Jesús culucs táhui, y entonces Pedro, San­tiago, Juan xa̠hua Andrés talá­kalh y chiné tze̠k taka­lhás­quilh: ");
INSERT INTO tocNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Cla­cas­qui­ná̠hu xqui­la̠­hua­níhu túcuya̠ quilh­ta­macú chuná amaj lak­chá̠n xla­cata nalak­pon­ka­mi̠cán a̠má pu̠si­culan. ¿Túcu nali̠­ta­siyuy hua̠ntu̠ naliucxilh­ti­ya­yá̠hu xla­cata naca­tzi̠­yá̠hu aquinín pi̠ aya kan­tax­tuma hua̠ntu̠ la̠nchú qui­la̠­li̠­ta̠­chu­hui̠­na­ma̠­náhu? ");
INSERT INTO tocNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús ca̠kálh­ti̠lh: —Cuentaj cat­la­huátit ni̠ti̠ naca̠ak­ska­huiyá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Porque lhu̠hua ti̠ natamín xta̠­chuná cumu la̠ aquit nata­li̠­tax­tu­putún, y nata­huán: “Aquit Cristo”, lhu̠hua hua̠nti̠ nata­taak­ska­huiy y nata­ca̠­naj­laniy xta­chu­hui̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Na̠chu­na­li̠túm hui­xinín pim­pá̠tit kax­pa­tá̠tit la̠ta nali̠­chu­hui̠­nancán cani̠huá tala­má̠­nalh guerras, pero hui­xinín ni̠ cape̠­cuántit porque tala­cas­quín pi̠ pu̠lh chuná nalay. Pero pu̠tum eé cajcu xquilh­tzúcut la̠ta tu̠ ámaj lay aca­li̠stá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Xli̠­lhu̠hua lac­lanca pu̠la­tama̠n ámaj ta̠la̠­la­ca­ta­huacay tunu pu̠la­tama̠n, y xli̠­lhu̠hua ca̠chi­quí̠n ámaj ta̠la̠­ma­ka­si̠­tzi̠y tunu ca̠chi­quí̠n. Tíyat lacaxtum amaj tachi­quiy nac ca̠quilh­ta­macú y nalay tatzín­c­stat. Pero pu̠tum u̠má cajcu li̠quilh­tzu­cuma nahuán la̠ta tu̠ ámaj min lanca tapa̠tí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Pero hui­xinín catat­li­huék­lhtit xpa̠­la­cata tu̠ naca̠ok­spu­layá̠n porque pim­pa̠­cántit ca̠ma­ca­ma̠s­ta̠­ca­ná̠tit nac xpu̠­ma̠­pek­si̠ncán lac­lanca napuxcún, y naca̠­ma̠­pa̠­ti̠­ni̠­ca­ná̠tit nac xpu̠­si­cu­lancán judíos, naca̠­li̠­pin­ca­ná̠tit nac xla­ca­ti̠ncán reyes caj quim­pa̠­la­cata; chuná hui­xinín tla̠n naqui­la̠­li̠­chu­hui̠­na­ná̠hu pi̠ xli̠­ca̠na qui­la̠­li̠­pa̠­hua­ná̠hu. ");
INSERT INTO tocNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pus la̠ta nia̠ lak­chá̠n nahuán quilh­ta­macú la̠ nakan­taxtuy hua̠ntu̠ cca̠­hua­nimá̠n u̠má quin­ta­chu­huí̠n hua̠ntu̠ ma̠sta̠y lak­táxtut amá̠­calh li̠chu­hui̠­nan­ko̠cán xli̠­ca̠­lanca ca̠quilh­ta­macú y hua̠k amá̠­calh laka­pascán. ");
INSERT INTO tocNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Y acxni̠ hui­xinín naca̠­li̠­pin­ca­ná̠tit, ni̠ cali̠­pu­huántit xla­cata lácu nahua­ná̠tit, ni̠para a̠li̠sok cala­ca­pa̠s­táctit. Hui­xinín chuná nahua­ná̠tit hua̠ntu̠ Dios naca̠­ma̠­ca­tzi̠­ni̠yá̠n a̠má quilh­ta­macú, pus ni̠ hui­xinín cati­chu­hui̠­nántit sino huá a̠má Espíri­tu Santo ámaj chu­hui̠nán mim­pa̠­la­ca­tacán. ");
INSERT INTO tocNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Amá quilh­ta­macú sacstu li̠na­ta̠lán taamá̠­nalh tala̠­ma­ca­ma̠sta̠y xla­cata naca̠­mak­ni̠cán, y maka­pi­tzí̠n nata­liak­ska­huinín hasta ma̠squi xca­mancán la̠qui̠ naca̠­mak­ni̠cán, y maka­pi­tzí̠n laka­huasán nata­liak­ska­huinín hasta ma̠squi xtla̠tcán la̠qui̠ na̠ naca̠­mak­ni̠cán. ");
INSERT INTO tocNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Hua̠k cris­tianos ámaj ca̠si̠­tzi̠­niyá̠n caj xpa̠­la­cata ca̠naj­la­yá̠tit quin­ta­chu­huí̠n, pero hua̠nti̠ nata̠­yaniy y ni̠ nali̠­mak­xtek­ta̠yay xla­cata pi̠ qui­li̠­pa̠­huán hasta la̠ta nati̠­tax­tuko̠y u̠má ni̠lac­tlá̠n quilh­ta­macú pus huá tamá ámaj ma̠aka­pu̠­taxti̠y xli̠s­tacni. ");
INSERT INTO tocNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Acxni̠ hui­xinín naucxi­lhá̠tit pi̠ kan­tax­tuma hua̠ntu̠ títzokli pro­feta Daniel acxni̠ tili̠­chu­huí̠­nalh la̠ta lácu nali̠­ka­ma̠­nancán y li̠xcáj­nit nali̠­ma̠x­tucán amá lanca xpu̠­si­culan Dios xalac Jeru­salén, y antá nac xpu̠­lacni naya̠­huacán tzincun; acxnicú hui­xinín hua̠nti̠ tala­ma̠­nanchá nahuán nac xapu̠­la­tama̠n Judea cata­tzá̠­lalh tuncán nac ca̠lac­si­pijni. —Hua̠nti̠ li̠kalh­ta­huakay eé libro caaká­ta̠ksli hua̠ntu̠ li̠chu­hui̠­nama Jesús—. ");
INSERT INTO tocNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Y hua̠nti̠ lahua­cachá nahuán nac xak­stí̠n xchic, acxni̠ nata̠ctay xla­cata natza̠lay, mejor ni̠ catá­nu̠lh xla­cata nama̠xtuy para túcu nalé̠n hua̠ntu̠ kalhi̠y nac xchic. ");
INSERT INTO tocNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Na̠chuná hua̠nti̠ ani̠t nahuán nac xca̠­tu­huá̠n, mejor ni̠ catás­pitli cxchic xla­cata namín tiyay clháka̠t, mejor chu­natá catzá̠­lalh. ");
INSERT INTO tocNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Koxu­taní̠n a̠ma̠ko̠lh lac­chaján hua̠nti̠ luu acxni̠ amá quilh­ta­macú tata̠­tatlay y niaj sacstu tala­má̠­nalh nahuán, osuchí hua̠nti̠ tama̠­tzi­qui̠y nahuán cska­tacán! ");
INSERT INTO tocNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Cali̠s­qui­nítit Dios xla­cata ni̠tu̠ tica̠­pu̠t­la­ka­ca­ná̠tit acxni̠ luu xquilhta lonkni, ");
INSERT INTO tocNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","porque lhu̠hua tapa̠tí̠n ámaj lay a̠má quilh­ta­macú cumu ne̠c­xnicú chuná a̠ lay hasta la̠ta Dios tit­lá­hualh ca̠tu­xá̠­huat, y niaj para cati­lapá aca­li̠stá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Pero para Dios ni̠ nama̠­chokoy a̠má quilh­ta­macú la̠ ámaj lay tapa̠tí̠n ni̠para cha̠stum catiaka­pu̠­táx­tulh; pero xlá catzi̠y hua̠ntu̠ tla­huama y nama̠­chokoy porque ca̠la­ka­lhamán cris­tianos hua̠nti̠ xlá ca̠lac­sacni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Y a̠má quilh­ta­macú para tícu naca̠­hua­niyá̠n: “Eé caucxílhtit, a̠má chixcú huá Cristo”, osuchí tunu ti̠ nahuán: “Umá chixcú huá Cristo”, hui­xinín ni̠ caca̠­naj­látit. ");
INSERT INTO tocNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Porque natamín hua̠nti̠ nataak­ska­huinán y nata­huán pi̠ huá Cristo, y tunu ti̠ nata­huán pi̠ Dios ca̠ma̠­la­ka­cha̠ni̠t xla­cata nata­li̠­chu­hui̠nán xta­la­ca­pa̠s­tacni. Xlacán natat­la­huay lac­lanca li̠cá̠cni̠t ta­scújut hua̠ntu̠ naliucxilhcán xla­cata taka­lhíy li̠t­li­hueke, y la̠qui̠ tla̠n nata­tak­ska­hui­nanko̠y; y na̠ naca̠ak­ska­hui­putún hasta hua̠nti̠ Dios ca̠lac­sacni̠t para tla̠n cahuá nata­ma̠t­la̠nti̠y. ");
INSERT INTO tocNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Huá xla­cata cca̠­hua­niyá̠n, luu ská­lalh cata­hui­látit porque a̠li̠sok cca̠­hua­nimá̠n hua̠ntu̠ ámaj qui̠­taxtuy aca­li̠stá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Pero a̠má quilh­ta­macú acxni̠ aya ti̠tax­tu­ko̠ni̠t nahuán tapa̠tí̠n, niaj cati­ta­sí­yulh chi­chiní nala­ca̠­puc­suanko̠y; y papá niaj cati­ma̠x­ka­ké­nalh ca̠tzi̠sní. ");
INSERT INTO tocNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Amá stacu hua̠ntu̠ tahui­lá̠­nalh nac akapú̠n nata­ta­mo­kosa y hua̠k la̠ta tu̠ huí nac akapú̠n nata­lac­chi­quiko̠y y hui­lhaj nalako̠y. ");
INSERT INTO tocNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Entonces pu̠tum cris­tianos naquin­taucxilha aquit Xata­lac­sacni Chixcú y cmímaj nahuán nac xlacni puc­lhni y nata­siyuy lanca qui­li̠t­li­hueke xa̠hua qui­li̠­cá̠cni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Y aquit nac­ca̠­ma̠­la­ka­cha̠y ángeles xli̠­ca̠­lanca ca̠quilh­ta­macú hasta tlak xatan­ke̠nu̠y, y na̠chuná hasta antaní qui̠akas­puta akapú̠n xla­cata naca̠­ma̠­mac­xtu­mi̠cán xli̠­hua̠k xcamán Dios hua̠nti̠ ca̠lac­sacni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Acán ucxi­lhá̠tit tzucuy aka­yuja maka­pi­tzí̠n quihui y tzucuy akas­ka­tam­paray, hui­xinín catzi̠­yá̠tit xla­cata pi̠ aya tala­ca­tzu­hui̠ma quilh­ta­macú la̠ta lhca̠cnán. ");
INSERT INTO tocNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Pus na̠chuna li̠túm acxni̠ naucxi­lhá̠tit pi̠ aya kan­tax­tuma hua̠ntu̠ la̠nchú cca̠­li̠­ta̠­chu­hui̠­namá̠n, pus caca­tzí̠tit pi̠ aya tala­ca­tzu­hui̠ma quilh­ta­macú la̠ta amá̠­calh sputcán. ");
INSERT INTO tocNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ hasta nia̠ tani̠ko̠y nahuán maka­pi­tzí̠n hua̠nti̠ la̠nchú tala­ma̠­nalhcú acxni̠ nakan­taxtuy hua̠ntu̠ la̠nchú cca̠­li̠­ta̠­chu­hui̠­namá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Luu laca­tancs cca̠­hua­niyá̠n xla­cata hua̠k akapú̠n chu ca̠quilh­ta­macú ma̠squi calak­tzán­ka̠lh, pero quin­ta­chu­huí̠n ni̠lay cati­lak­tzán­ka̠lh hasta nakan­tax­tuko̠y hua̠k la̠ta tu̠ cli̠­chu­hui̠­nani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Pero huá la̠ta túcuya̠ quilh­ta­macú osuchí túcuya̠ hora amaj lak­chá̠n ni̠ti̠ catzi̠y, na̠ ni̠para aquit Xata­lac­sacni Chixcú, ni̠para ángeles xalac akapú̠n, huata caj xma̠n Quin­tla̠t Dios catzi̠y. ");
INSERT INTO tocNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Pus huá xpa̠­la­cata cca̠­li̠­hua­niyá̠n luu ska­lalh y cha̠­ca­tzi̠ya cata­hui­látit porque ni̠ catzi̠­yá̠tit túcuya̠ quilh­ta­macú ámaj lak­chá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Na̠chuná ámaj qui̠­taxtuy cumu la̠ cha̠tum chixcú hua̠nti̠ an paxia̠lhnán mákat, pero acxni̠ nia̠ an, ca̠ma̠­cuentajli̠y xta­sa̠­cuá̠n nac xchic y ca̠ma­ca­ma̠x­qui̠y cha̠­tunu xtas­cu­jutcán, y ya̠huay cha̠tum nac lanca má̠lacchi la̠qui̠ nama̠­la­qui̠niy xpu̠­chiná acán namim­paray. ");
INSERT INTO tocNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Pus na̠chuná hui­xinín ská­lalh cata­hui­látit porque ni̠ catzi̠­yá̠tit túcuya̠ quilh­ta­macú cámaj min aquit, para acán tzi̠­suama, osuchí la̠ naita̠tlay tzi̠sní, o acxni̠ natasay pu̠yu, osuchí acxni̠ nas­palh­ca̠­huanko̠y, o acxni̠ ca̠cu­hui­nitá. ");
INSERT INTO tocNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Pus luu ská­lalh cata­hui­látit porque, ¿chí para xamaktum ni̠ li̠ca­tzi̠­hui­látit nahuán acxni̠ nac­tax­tu­ya̠chi y lhta­ta­pá̠tit nahuán? ");
INSERT INTO tocNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Eé hua̠ntu̠ cca̠­hua­nimá̠n hui­xinín na̠chuná cla­cas­quín cata­cá­tzi̠lh hua̠k a̠maka­pi­tzí̠n cris­tianos hua̠nti̠ naquin­ta­kalh­ka­lhíy acán nacmín, xla­cata ská­lalh cata­táhui. ");
INSERT INTO tocNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Aktiy quilh­ta­macú xtzanka̠y xla­cata nalak­chá̠n xpa̠x­cuajcán judíos xla taak­spun­tza̠lí̠n acxni̠ xli̠­hua̠k cris­tianos xalac Israel xta­huay cax­ti­lá̠n­chahu hua̠ntu̠ ni̠tu̠ kalhi̠y leva­dura. Ama̠­ko̠lh xana­puxcun cura xa̠hua xma̠­kalh­ta­hua­ke̠­nacán judíos tzú­culh tali̠­lac­chu­hui̠nán xla­cata lácu tla̠n nata­chipay Jesús, nata­liak­ska­huinín y aca­li̠stá̠n nata­makni̠y. ");
INSERT INTO tocNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pero xlacán xta­qui­lhuamá̠­nalh: —Ni̠ cachi­páhu acxni̠ luu xquilh­ta­macú xapa̠x­cuaj taak­spun­tza̠lí̠n porque lhu̠hua cris­tianos nata­si̠­tzi̠y hua̠nti̠ tapa̠x­qui̠y. ");
INSERT INTO tocNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús xani̠t laka­pa­xia̠lhnán Simón a̠má chixcú hua̠nti̠ xma̠­pac­sani̠t acxni̠ xka­lhi̠y aktum li̠xcáj­nit tajátat hua­nicán lepra, xlá antá xuilachá nac Betania. Jesús xuí nac mesa xua̠yama acxni̠ chilh cha̠tum pusca̠t xli̠mín pa̠tum lameta xatlá̠n per­fume xla nardo xánat luu tapa­ra̠xlá xuani̠t xta­palh a̠má quilh­ta­macú. Ma̠kálh­ke̠lh lameta y liakpa­xi̠­ko̠lh per­fume nac xak­xa̠ka Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Hua̠nti̠ antá xta­hui­lá̠­nalh lacatzú tzú­culh tasi̠­tzi̠niy a̠má pusca̠t y chiné tzú­culh tala̠­huaniy: —¿Túcu xpa̠­la­cata luu caj pá̠xcat tlá­hualh eé xatlá̠n per­fume? ");
INSERT INTO tocNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Pus tla̠n xti­li̠s­tá̠­calh li̠huacay aktutu ciento denario tumi̠n, y hua̠ntu̠ xti­tás­tokli xatumi̠n xti­ca̠­li̠­mak­ta̠­yá­calh lak­li̠­ma̠x­kení̠n. Jesús ca̠ka­lha­káx­matli hua̠ntu̠ xlacán xta­qui­lhuamá̠­nalh ");
INSERT INTO tocNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","y chiné ca̠huá­nilh: —¿Túcu xpa̠­la­cata li̠ma̠aklhu̠­hui̠­yá̠tit eé pusca̠t? Porque hua̠ntu̠ xlá tla­huani̠t luu xli̠­ca̠na tla̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Pus hua̠nti̠ lak­li̠­ma̠x­kení̠n tala­má̠­nalh cris­tianos anka­lhi̠ná ca̠ta̠­lamá̠n nahuán nac milak­sti̠­pa̠ncán, y tla̠n naca̠­mak­ta̠­ya­yá̠tit acxni̠ hui­xinín nalac­pu­hua­ná̠tit, pero aquit niaj maka̠s quilh­ta­macú cac­ti­ca̠­ta̠­la­tamá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Hua̠ntu̠ xlá tla̠n lac­pú­hualh pus chuná tlá­hualh, y ma̠squi ni̠ catzi̠y xlá a̠li̠sok qui­li̠t­la­hua­pú̠x­tulh per­fumes la̠qui̠ acxni̠ naqui­ma̠c­nu̠cán ma̠squi niaj tu̠ caqui­li̠t­la­huá­calh. ");
INSERT INTO tocNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ la̠ta chá nícu nali̠­chu­hui̠­nancán xta­chu­huí̠n Dios xli̠­ca̠­lanca ca̠quilh­ta­macú na̠ nali̠­chu­hui̠­nancán hua̠ntu̠ tlá­hualh eé pusca̠t la̠qui̠ hua̠k nali̠­la­ca­pa̠s­taccán. ");
INSERT INTO tocNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Isca­riote hua̠nti̠ xta̠­ta­peksi̠y a̠má xka­lha­cu̠tiy xdis­cí­pulos Jesús alh ca̠ta̠­chu­hui̠nán hua̠nti̠ xta­si̠­tzi̠niy Jesús xana­puxcun cura la̠qui̠ naca̠­ta̠­la­ca̠xlay y naca̠­ma­ca­ma̠x­qui̠y. ");
INSERT INTO tocNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Acxni̠ xlacán takáx­matli hua̠ntu̠ xca̠­ma̠­lac­nu̠­ni­má̠­calh xlacán tapa̠­xu­hua­ko̠lh, tali̠­ta̠­yá­nilh pi̠ nata­ma̠x­qui̠y tumi̠n; Judas tzú­culh lac­pu­tzay lácu nat­la­huay xla­cata nama­ca­ma̠sta̠y Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Acxni̠ lák­cha̠lh a̠má quilh­ta­macú xta­ma̠­ko̠­taní̠n xpa̠x­cuajcán judíos xla taak­spun­tza̠lí̠n acxni̠ xlacán tahuay cax­ti­lá̠n­chahu hua̠ntu̠ ni̠tu̠ kalhí̠y leva­dura y acxni̠ ca̠mak­ni̠cán xalactzu bor­rego hua̠ntu̠ li̠la­ka­chix­cu­hui̠­nancán nac a̠má pa̠xcua, xta­ma̠­kalh­ta­huaké̠n Jesús chiné taka­lhás­quilh: —¿Nícu laca­squina naca­ná̠hu ca̠x­tla­hua­yá̠hu hua̠ntu̠ nahua­yá̠hu eé xta­ma̠­ko̠­taní̠n pa̠xcua? ");
INSERT INTO tocNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Pus Jesús ca̠ma̠­la­ká­cha̠lh cha̠tiy xdis­cí­pulos xla­cata nata­ca̠x­tla­huay a̠má tahuá, y chiné ca̠huá­nilh: —Capim­pítit nac ca̠chi­quí̠n y antá hui­xinín naucxi­lhá̠tit cha̠tum chixcú cuca­le̠ma pa̠tum stu̠n chú­chut. Ca­sta̠­la­nítit ");
INSERT INTO tocNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","y antaní nata­nu̠­ya̠chá na̠ antá cata­nú̠tit, cahua­nítit xpu̠­china chiqui: “Huan qui­ma̠­kalh­ta­hua­ke̠­nacán: ¿Nícu huí amá pu̠lactum chiqui antaní nac­ca̠­ta̠­huay quin­ta­ma̠­kalh­ta­huaké̠n tahuá xla taak­spun­tza̠lí̠n eé tzi̠sní?” ");
INSERT INTO tocNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Xlá naca̠­le̠ná̠n, nac xli̠­quilh­mactiy chiqui naca̠­ma̠­si­yu­niyá̠n pu̠lactum chiqui juerza tzinú ca̠lak­lanca y pacsa kalhi̠y tu̠ tamac­la­cas­quín, antá hui­xinín caca̠x­tla­huátit quin­ta­huajcán hua̠ntu̠ nahua­yá̠hu eé tzi̠sní. ");
INSERT INTO tocNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Y a̠ma̠ko̠lh dis­cí­pulos táalh nac ca̠chi­quí̠n, xli̠­ca̠na chuná tama̠­nóklh­ulh la̠ta tu̠ xca̠­hua­nini̠t Jesús, xlacán antá taca̠x­tlá­hualh tahuá hua̠ntu̠ nata­li̠­la­ka­chix­cu­hui̠nán xapa̠xcua taak­spun­tza̠lí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Acxni̠ aya tzí̠­sualh, Jesús ca̠tá̠­chilh xa̠maka­pi­tzí̠n xdis­cí­pulos ");
INSERT INTO tocNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","y pu̠tum tatáhui xla­cata nata­hua̠yán. Acxni̠ luu xquilhta xta­hua̠­ya­má̠­nalh Jesús ca̠huá­nilh: —Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ chá̠tum natax­tu­ya̠chá mili̠­pu̠­tumcán hua̠nti̠ naqui­ma­ca­ma̠sta̠y nac xmacancán hua̠nti̠ quin­ta­si̠­tzi̠niy. ");
INSERT INTO tocNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Xlacán luu snu̠n tali̠­púhua y tzú­culh tala̠­ka­lhas­quín cha̠tum a̠cha̠tum: —¿Ma̠x aquit cámaj maca­ma̠sta̠y? Y cha̠tum huampá: —¿Ahuayu ma̠x aquit cámaj liak­ska­huinín? ");
INSERT INTO tocNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús ca̠kálh­ti̠lh: —La̠ta mili̠­ka­lha­cu̠­tiycán cha̠tum natax­tu­ya̠chá hua̠nti̠ lak­xtum quin­ta̠­ta­ma­ka­ju̠ma nac quim­pu­la̠­tucán. ");
INSERT INTO tocNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Pus chuná li̠kan­tax­tuma hua̠ntu̠ tatzok­ta­hui­lani̠t nac li̠kalh­ta­huaka hua̠ntu̠ naquiak­spulay aquit Xata­lac­sacni Chixcú; pero koxutá a̠má chixcú hua̠nti̠ ámaj qui­ma­ca­ma̠sta̠y. ¡Xatlá̠n xtíhua pi̠ ni̠ xti­la­cá­chilh! ");
INSERT INTO tocNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Y li̠huán xta­hua̠­ya­má̠­nalh Jesús tíyalh mactum cax­ti­lá̠n­chahu, pa̠x­cat­ca­tzí̠­nilh Dios xtahuá, y acxni̠ lak­ché­kelh ca̠má̠x­qui̠lh xdis­cí­pulos y chiné ca̠huá­nilh: —Cati­yátit y cahuátit eé cax­ti­lá̠n­chahu porque huá li̠taxtuy quin­ti­yat­li̠hua. ");
INSERT INTO tocNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Aca­li̠stá̠n tiyapá pa̠tum vaso xchú­chut uva, pa̠x­cat­ca­tzí̠­nilh Dios, ca̠má̠x­qui̠lh xta­ma̠­kalh­ta­huaké̠n; y hua̠k tali̠­kót­nulh aca­tzuní̠n hua̠ntu̠ xta­ju̠ma cvaso. ");
INSERT INTO tocNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Y chiné ca̠huá­nilh: —Huá eé xchú­chut uva li̠taxtuy quin­kalhni hua̠ntu̠ nas­taj­ta­makán xpa̠­la­ca­tacán pu̠tum cris­tianos la̠qui̠ naca­tzi̠cán li̠pu̠tum pi̠ Dios tla­huani̠t xasa̠sti xta­la­ca̠xlán la̠ naca̠­lak­ma̠xtuy. ");
INSERT INTO tocNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ niaj maktum cac­ti­li̠­kót­nulh xchú­chut uva hasta acxni̠ nama̠­lak­cha̠níy quilh­ta­macú la̠ nac­li̠­kotnún tunu xasa̠sti xchú­chut uva nac xpa̠xtú̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Acxni̠ la̠ taquilh­tli̠­ko̠lh kam­pa̠tum salmo taampá nac amá ke̠stí̠n hua­nicán Monte de los Olivos. ");
INSERT INTO tocNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Y antá ca̠huá­nilh Jesús: —Eé tzi̠sní pu̠tum hui­xinín naqui­la̠­tza̠­la­ma­ka­ná̠hu. Pus chuná ámaj kan­taxtuy la̠ titzók­nulh cha̠tum pro­feta acxni̠ ma̠lac­pu­huá̠­ni̠lh Dios: “Aquit nac­ma̠sta̠y quilh­ta­macú camak­ní̠­calh xma̠­pu­tzua̠yi̠ná bor­regos y pu̠tum bor­regos nata­ta̠­ka­hua­ni̠ko̠y.” ");
INSERT INTO tocNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero acxni̠ aquit nac­la­cas­ta­cuanán nac ca̠li̠ní̠n pu̠lh nacam­paray nac Gali­lea la̠qui̠ antá nata­nok­lha̠­chá̠hu. ");
INSERT INTO tocNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro huá­nilh: —Ma̠squi pu̠tum cata­tza̠­la­makán, aquit ni̠ cac­tiak­xtek­makán. ");
INSERT INTO tocNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Pero Jesús huá­nilh: —Xli̠­ca̠na cuaniyá̠n pi̠ eé tzi̠sní acxni̠ nia̠ tasay nahuán xli̠­maktiy pu̠yu, huix hua­ni̠­tatá nahuán mak­tutu pi̠ ni̠ qui­la­ka­pasa. ");
INSERT INTO tocNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero xlá chiné hua­nipá: —Ma̠squi na̠ acxtum xquin­ta̠­mak­ní̠­canti, pero ni̠ cac­tíhua pi̠ ni̠ cla­ka­pasá̠n. Y xa̠maka­pi­tzí̠n dis­cí­pulos hua̠k chuná tahuánilh. ");
INSERT INTO tocNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Acxni̠ tácha̠lh nac aktum ca̠qui­huí̠n hua­nicán Get­se­maní, Jesús chiné ca̠huá­nilh xdis­cí­pulos: —Uú cata­hui­la­ké̠tit li̠huán u̠cámaj kalh­ta­hua­kaniy Dios. ");
INSERT INTO tocNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Xma̠n huá ca̠tá̠alh Pedro, San­tiago y Juan a̠laca­tunu cá̠le̠lh. Antá caj xamaktum tzú­culh liaka­tiyún y li̠li̠­pu­huán tu̠ xámaj akspulay. ");
INSERT INTO tocNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Y chiné ca̠huá­nilh: —Luu xli̠­ca̠na cmaklh­ca­tzi̠y aktum tali̠­pu­huá̠n nac qui­nacú, la̠m­para cámaj ni̠y. Uú cata­hui­látit pero ni̠ calh­ta­tátit. ");
INSERT INTO tocNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jesús alh tzinú antaní tlak laka­mákat, tatzo­kós­talh nac ca̠ti­yatni, huá­nilh Dios para tla̠n ni̠ xmá̠x­qui̠lh tapa̠tí̠n hua̠ntu̠ xámaj lak­chá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Y chiné kalh­ta­hua­ká­nilh Dios: —Quin­tla̠t Dios, huix hua̠k tla̠n catu̠huá tla­huaya, pus para huix laca­squina ni̠ caqui­ma̠xqui eé tapa̠tí̠n, pero ni̠ calalh hua̠ntu̠ aquit cla­cas­quín sinoque huá calalh min­ta­pa̠­xu­huá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tas­pitpá antaní xta­hui­lá̠­nalh xta­ma̠­kalh­ta­huaké̠n pero xlacán pu̠tum xtalh­ta­ta­má̠­nalh. Chiné huá­nilh Pedro: —Simón, ¿lácu pi̠ lhta­tápa̠t? ¿Lácu pi̠ ni̠lay laca­ta̠­yani ca̠na̠caj aktum hora talh­tata? ");
INSERT INTO tocNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ská­lalh cata­hui­látit y cakalh­ta­hua­ka­nítit Dios la̠qui̠ ni̠ natat­la­ji̠­yá̠tit acxni̠ naca̠­tzak­sa­ca­ná̠tit. Pus ma̠squi mili̠s­tac­nicán luu xli̠­ca̠na aksti̠tum li̠pi­ná̠tit xta­la­ca­pa̠s­tacni, min­ti­yat­li̠­huacán ni̠ ta̠yaniy porque ni̠ kalhi̠y li̠t­li­hueke. ");
INSERT INTO tocNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jesús ampá kalh­ta­hua­kaniy Dios y chu­na­li̠túm qui̠­li̠­xa­kát­li̠lh cumu la̠ xapu̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Aca­li̠stá̠n ampá antaní xta­hui­lá̠­nalh xdis­cí­pulos pero xlacán xtalh­ta­ta­ma̠­nampá porque niajlay xta­la­ca­ta̠­yaniy xla­kas­ta­pucán talh­tata. Y acxni̠ tzú­culh ca̠xa­katli̠y Jesús, xlacán ni̠ xta­ca­tzi̠y lácu nata­kalh­ti̠nán. ");
INSERT INTO tocNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Xlá ampaj kalh­ta­hua­kaniy Dios xli̠­mak­tutu, y acxni̠ qui̠­tás­pitli chiné ca̠huá­nilh: —¿Pi̠ chu­nacú lhta­ta­pá̠tit y jax­pá̠tit? Niaj chuná cat­la­huátit porque aya lak­cha̠ni̠t quilh­ta­macú la̠ naqui­ma­ca­ma̠s­ta̠cán aquit Xata­lac­sacni Chixcú nac xmacancán hua̠nti̠ quin­ta­si̠­tzi̠niy. ");
INSERT INTO tocNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","La̠li̠­huán cata̠­quí̠tit porque aya mima hua̠nti̠ naqui­ma­ca­ma̠sta̠y. ");
INSERT INTO tocNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús xchu­hui̠­na­majcú acxni̠ talák­chilh lhu̠hua cris­tianos huá xca̠­pu̠­la­ni­ti̠­lhay xdis­cí­pulo hua­nicán Judas Isca­riote. Catu̠huá xta­li̠mín, hui̠ntí xli̠mín espada, maka­pi­tzí̠n ya̠ quihui. Uma̠­kó̠lh lac­chix­cu­huí̠n huá xta­ma̠­la­ka­cha̠ni̠t xana­puxcún cura, xa̠hua xma̠­kalh­ta­hua­ke̠­nacán judíos y lak­ko̠­lu­tzi̠nni hua̠nti̠ xta­ma̠­pek­si̠nán. ");
INSERT INTO tocNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas hua̠nti̠ maca­má̠s­ta̠lh xca̠­hua­nini̠t lácu nata­li̠­la­ka­pasa la̠qui̠ natalé̠n: —Hua̠nti̠ quit nac­la­ca­tzu̠ca huá cachi­pátit y cali̠­pítit. ");
INSERT INTO tocNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Acxni̠ lák­cha̠lh, lak­ta­la­ca­tzú­hui̠lh y chiné huá­nilh: —Uú clak­mimá̠n, ma̠kalh­ta­hua­ke̠ná. La̠n­chuná hua­ni­ko̠lh lacá­tzu̠cli. ");
INSERT INTO tocNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Y maka­pi­tzí̠n tachí­palh Jesús la̠qui̠ natalé̠n cumu la̠ cha̠tum tachí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Cha̠tum xdis­cí­pulo xtat má̠x­tulh xes­pada y ca̠c­tí̠­nilh xtaké̠n cha̠tum xta­sa̠­cuacán hua̠nti̠ xta­ma̠­la­ka­cha̠ni̠t xana­puxcun cura. ");
INSERT INTO tocNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesús ca̠huá­nilh a̠ma̠ko̠lh lac­chix­cu­huí̠n: —¿Túcu xpa̠­la­cata hui­xinín tani̠­tátit qui­la̠­chi­pa­yá̠hu cumu la̠ cha̠tum kalha̠ná y hasta li̠ta­ni̠­tátit espada xa̠hua quihui? ");
INSERT INTO tocNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Cha̠li cha̠lí aquit antá xqui­la̠ucxi­lhá̠hu acxni̠ xac­ca̠­ma̠­kalh­chu­hui̠ni̠y cris­tianos, pero ne̠cxni xqui­la̠­chi̠­lé̠hu; pero juerza huá chuná qui̠­li̠­táx­tulh xla­cata nakan­taxtuy hua̠ntu̠ tatzokni̠t nac li̠kalh­ta­huaka tu̠ ámaj quiak­spulay. ");
INSERT INTO tocNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Y pu̠tum xdis­cí­pulos tatza̠­la­má­kalh, sacstu taak­xtek­yá̠­hualh Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pero cha̠tum xdis­cí­pulo csta̠­la­nima antaní xlac­le̠­ma̠ca Jesús nac pu̠ma̠­peksí̠n; acxni̠ ucxílhca na̠ xamá̠­calh chi­pacán. ");
INSERT INTO tocNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Chi­pa­níca clháka̠t, pero cumu caj xamactum caj la̠ sábana, huata xlá tapú̠x­tulh clháka̠t y xalh­tan­tala tzá̠­lalh. ");
INSERT INTO tocNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","54","Huata Pedro na̠ tis­ta̠­lá­nilh tlak tzinú laka­mákat hasta li̠chá̠n­calh Jesús nac xpu̠­ma̠­pek­si̠ncán cura y antá xlá tamák­xtekli antaní xta­hui­lá̠­nalh poli­cías y tzú­culh ca̠ta̠skón. Pu̠tum xana­puxcun cura xa̠hua lak­ko̠­lu­tzi̠nni hua̠k tata­mac­xtú­mi̠lh xa̠hua xma̠­kalh­ta­hua­ke̠­nacán judíos. Caj li̠puntzú li̠mínca Jesús nac xla­catí̠n xapuxcu cura. ");
INSERT INTO tocNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Maka­pi­tzí̠n xana­puxcun cura xa̠hua hua̠nti̠ xalac­ta­li̠­pa̠hu ma̠pek­si̠­naní̠n tzú­culh talac­pu­tzay lácu tla̠n nata­makni̠y Jesús, pero ni̠tu̠ tamac­lá­nilh hua̠ntu̠ nata­li̠­ya̠­huay. ");
INSERT INTO tocNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ma̠squi maka­pi­tzí̠n cris­tianos catu̠huá tzú­culh tahuán hua̠ntu̠ xta­li̠­ya̠­huay pero aca­li̠stá̠n xtzu­cu­paray tala̠­li̠­ma̠aklhu̠­hui̠y porque ni̠ acxtum xta­li̠­ca­tzi̠y hua̠ntu̠ xtaaksa­ni̠­na­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Y maka­pi­tzí̠n tatá̠­yalh, chiné taliak­ska­huí­nalh: ");
INSERT INTO tocNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Aquinín ckax­mat­ni̠­táhu pi̠ chiné huá tamá chixcú: “Aquit nac­lac­tla­huay eé xpu̠­si­culan Dios hua̠ntu̠ taca̠x­tla­huani̠t lac­chix­cu­huí̠n pero caj xliaktutu quilh­ta­macú aquit nac­tla­huay aktum pero a̠tzinú xatlá̠n ni̠xa­chuná hua̠ntu̠ tla­huani̠t lac­chix­cu­huí̠n.” ");
INSERT INTO tocNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero ni̠para chuná acxtum xta­li̠­ca­tzi̠y hua̠ntu̠ xta­liaksa­ni̠­na­má̠­nalh y ni̠tu̠ xta­ma̠t­la̠nti̠y hua̠ntu̠ xta­li̠­ya̠­hua­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Acxni̠ tá̠yalh hua̠nti̠ luu xapuxcu cura, chiné huá­nilh Jesús: —¿Lácu pi̠ ni̠tu̠ cati­kalh­tí̠­nanti? ¿Pi̠ ni̠ kax­pátpa̠t la̠ta túcu tali̠­ya̠­huamá̠n u̠ma̠ko̠lh lac­chix­cu­huí̠n? ");
INSERT INTO tocNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús ni̠tu̠ kalh­tí̠­nalh, caj xma̠n cacs tá̠yalh. Pero a̠má xapuxcu cura a̠maktum kalhas­quimpá y huá­nilh: —¿Pi̠ xli̠­ca̠na huix Cristo hua̠nti̠ Xka­huasa Dios? ");
INSERT INTO tocNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús huá­nilh: —Xli̠­ca̠na aquit Cristo. Y namín quilh­ta­macú acxni̠ hui­xinín naucxi­lhá̠tit la̠ aquit Xata­lac­sacni Chixcú cuilachá nahuán nac xpa̠xtú̠n Dios, y na̠chuná la̠ aquit cmi­ma̠­pa­rachá nahuán nac xlacni puc­lhni. ");
INSERT INTO tocNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Amá xapuxcu cura xti̠tli clháka̠t la̠qui̠ pu̠tum naca­tzi̠cán pi̠ sí̠tzi̠lh, y ca̠huá­nilh xcompañeros: —¿Túcuajya̠ tes­tigos tila­cas­qui­ná̠hu? ");
INSERT INTO tocNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Caj xpa̠­la­cata xta­chu­huí̠n eé chixcú ta̠la̠­la­ca­ta̠­qui̠ni̠t Dios, aya kax­páttit. ¿Túcu nat­la­hua­ni­yá̠hu, hui­xinín lac­pu­hua­ná̠tit? Xli̠­hua̠k hua̠nti̠ antá xta­hui­lá̠­nalh takalh­tí̠­nalh: —¡Mejor camak­ní̠­calh! ");
INSERT INTO tocNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Maka­pi­tzí̠n tzú­culh tala­ca­chuj­mani̠y, tali̠­la­ká­chi̠lh mactum lháka̠t, tala­ka­ká­xilh y chiné tzú­culh tahuaniy: —Cama̠­lak­chi­pini, ¿tícu laka­kaxín? La̠n­chuná tat­la­hua­ko̠lh ca̠ma­ca­ma̠x­quí̠­calh poli­cías y xlacán na̠chuná tzú­culh tala­ka­kaxiy. ");
INSERT INTO tocNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Antaní xca̠­ta̠s­koma Pedro maka­pitzi poli­cías chilh cha̠tum csqui­ti­hui̠ná xapuxcu cura. ");
INSERT INTO tocNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Acxni̠ úcxilhli pi̠ antá cskoma, cacs laca­cá̠c­ni̠lh y chiné huá­nilh: —Huix na̠ xta̠­la­pu̠­laya Jesús xalac Naza­ret. ");
INSERT INTO tocNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedro ni̠ li̠tá̠­yalh y kálh­ti̠lh: —Ni̠ aquit, ni̠ cla­ka­pasa tamá chixcú hua̠nti̠ huix hua­nípa̠t. Táx­tulh nac quilhtí̠n antaní lac­ta­nu̠cán acxni­tiyá tásalh tantum pu̠yu. ");
INSERT INTO tocNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Amá squi­ti­hui̠ná cacs lacaucxilhpá Pedro y tzú­culh ca̠huaniy hua̠nti̠ antá xta­la­yá̠­nalh: —Xli̠­ca̠na huá eé chixcú na̠ xta­ma̠­kalh­ta­huaké̠n Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedro ni̠ li̠ta̠­yapá para ca̠na laka­pasa, y caj li̠puntzú a̠ma̠ko̠lh poli­cías hua̠nti̠ antá xta­hui­lá̠­nalh lacatzú tzú­culh tahuaniy: —Xli̠­ca̠na huix na̠ xta̠­la­pu̠­laya Jesús porque huix xalac Gali­lea, caj huá tuncán min­ta­chu­huí̠n tlán li̠la­ka­pas­cana. ");
INSERT INTO tocNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pedro tzú­culh liaklhu̠­hua̠tnán y chiné ca̠huá­nilh: —Te Dios ni̠ cla­ka­pasa aquit tamá chixcú, y hasta ni̠ cca­tzi̠y tícu li̠chu­hui̠­nam­pá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Acxni̠ káx­matli pi̠ tásalh xli̠­maktiy pu̠yu xlá laca­pá̠s­tacli hua̠ntu̠ xuanini̠t Jesús: “Acxni̠ nia̠ tasay nahuán xli̠­maktiy pu̠yu huix pímpa̠t huana mak­tutu pi̠ ni̠ qui­la­ka­pasa.” Pedro luu xli̠­ca̠na li̠púhua acxni̠ laca­pa̠s­tac­ko̠lh pi̠ xli̠­ca̠na kan­táx­tulh hua̠ntu̠ xuanini̠t Jesús y tzú­culh tasay. ");
INSERT INTO tocNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Acxni̠ xka­ka­ko̠lh amá tzi̠sní tata­mac­xtu­mi̠pá xana­puxcun cura chu xma̠­kalh­ta­hua­ke̠­nacán judíos xa̠hua lak­ko̠­lu­tzi̠nni, y tachí̠n tále̠lh Jesús nac xla­catí̠n ma̠pek­si̠ná Pilato. ");
INSERT INTO tocNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Xlá ma̠ka­lha­pá­li̠lh Jesús y kalhás­quilh: —¿Pi̠ xli̠­ca̠na huix xreycán judíos? Jesús kálh­ti̠lh: —Xli̠­ca̠na hua̠ntu̠ qui­lhuámpa̠t porque aquit xli̠­ca̠na rey —huá­nilh. ");
INSERT INTO tocNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Y hua̠nti̠ xta­si̠­tzi̠niy catu̠huá tzú­culh tali̠­ya̠­huay taaksaní̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato tá̠yalh y huá­nilh Jesús: —¿Lácu pi̠ ni̠tu̠ cati­kalh­tí̠­nanti? ¿Pi̠ ni̠ kax­pata pi̠ catuhuá tali̠­ya̠­huamá̠n u̠ma̠ko̠lh lac­chix­cu­huí̠n? ");
INSERT INTO tocNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero Jesús ni̠tu̠ kalh­tí̠­nalh y huá xla­cata niaj cátzi̠lh Pilato túcu naka­lhas­quín. ");
INSERT INTO tocNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Acxni̠ xlak­chá̠n xapa̠xcua taak­spun­tza̠lí̠n xli̠s­ma­ni̠ni̠t Pilato xmak­xtéka cha̠tum tachí̠n porque chuná xta­li̠s­quiniy pu̠tum lac­chix­cu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Y nac pu̠la̠­chi̠n xta­nu̠ma cha̠tum tachí̠n xuanicán Bar­rabás chu xcompañeros hua̠nti̠ xta­ma̠­la­ca­tzu­qui̠ni̠t tasi̠tzi nac xca̠­chi­qui̠ncán y lhu̠hua cris­tianos xta­mak­ni̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Y caj li̠puntzú tachilh lhu̠hua cris­tianos, tzú­culh tas­quiniy Pilato xla­cata naca̠­mak­xtekniy cha̠tum tachí̠n cumu la̠ xta­li̠s­ma­ni̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pero Pilato ca̠ka­lhás­quilh: —¿Pi̠ lacas­qui­ná̠tit hui­xinín cac­mák­xtekli xreycán judíos? ");
INSERT INTO tocNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Porque Pilato xca­tzi̠y pi̠ caj xta­quic­lhca­tzán xana­puxcun cura por eso xta­li̠­ma­ca­ma̠x­qui̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pero xana­puxcun cura la̠li̠­huán tzú­culh tama̠­kalh­chu­hui̠ni̠y cris­tianos la̠qui̠ mejor catás­quilh xla­cata camak­xtékca Bar­rabás. ");
INSERT INTO tocNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato ca̠ka­lhas­quimpá: —¿Y túcu lacas­qui­ná̠tit nac­tla­huaniy a̠má chixcú hua̠nti̠ hui­xinín hua­ni­yá̠tit xreycán judíos? ");
INSERT INTO tocNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Xli̠­pu̠tum cris­tianos tzú­culh taqui­lhán: —¡Cape­kex­to­ko­huaca nac cruz! ");
INSERT INTO tocNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato ca̠hua­nipá: —¿Pero túcu ni̠tlá̠n tla­huani̠t? Pero xlacán caj tzu­cupaj taqui­lhán: —¡Cape­kex­to­ko­hua­cá­calh nac cruz! ");
INSERT INTO tocNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Cumu Pilato ni̠ xla­cas­quín tícu nasi̠­tzi̠niy pus huá li̠mák­xtekli Bar­rabás y ma̠pek­sí̠­nalh xla­cata nake̠s­nokcán Jesús, aca­li̠stá̠n ca̠ma­ca­má̠x­qui̠lh tropa la̠qui̠ xlacán nata­pe­kex­to­ko­huacay nac cruz. ");
INSERT INTO tocNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ama̠­ko̠lh tropa tále̠lh ca̠la­kuá̠n pero cxpu­lacni xpu̠­ma̠­peksí̠n Pilato anta­nícu pu̠tum tropa xta­ta­mac­xtú­mi̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Xlacán tama̠­lák­xtulh clháka̠t Jesús y tama̠­lhá­ke̠lh mactum xapu̠s­ta­pu̠hua lháka̠t cumu la̠ xla rey, y taacuíli̠lh nac xak­xa̠ka aktum corona xla lhtucú̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Y tzú­culh tama̠­tasi̠y: —¡Cane̠c­xni­cahuá cala­tá­ma̠lh xreycán judíos! ");
INSERT INTO tocNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tzú­culh taliak­snokmi̠y kantum lasasa y tala­ca­chuj­má­ni̠lh, tala­ka­ta­quilh­pú̠­talh y tata­tzo­kos­tá­nilh xta̠­chuná cumu la̠ tla­huacán nac xla­catí̠n cha̠tum rey. ");
INSERT INTO tocNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Acxni̠ tali̠­ka­ma̠­nan­ko̠lh, tama̠­lák­xtulh a̠má xapu̠s­ta­pu̠hua lháka̠t y huá tama̠­lhá­ke̠lh hua̠ntu̠ luu clháka̠t Jesús. Aca­li̠stá̠n tata­mác­xtulh nac quilhtí̠n y tále̠lh antaní nape­kex­to­ko­hua­cacán nac cruz. ");
INSERT INTO tocNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Cha̠tum chixcú xalac Cirene xuanicán Simón xla­ka­huasán xca̠­hua­nicán Ale­jandro y Rufo, xlá xqui̠­tas­pitma nac xca̠­tu­huá̠n y antá xti̠­tax­tuma antaní xta­la­yá̠­nalh tropa acxni̠ tachi­pa­pá̠x­tokli maka­pi­tzí̠n tropa y akchú tama̠­lé̠­ni̠lh xcruz Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Antá lé̠n­calh Jesús nac aktum ke̠stí̠n xuanicán Gól­gota. Eé tachu­huí̠n huam­putún: Cxac­lúcut Ni̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Acxni̠ antá li̠chá̠n­calh Jesús, ma̠x­quí̠­calh nahuay cuchu hua̠ntu̠ xlak­ma­ca̠n­cani̠t lí̠cuchu la̠qui̠ ni̠ namaklh­ca­tzi̠y hua­nicán mirra. Xlá caj ma̠ka­lhua̠ní̠­calh y ni̠ hualh. ");
INSERT INTO tocNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Ca̠mak­na­ja̠tza hora xuani̠t acxni̠ pekex­to­ko­hua­cá­calh nac cruz. Ama̠­ko̠lh tro­pajni tzú­culh tali̠­macá̠n suerte clháka̠t Jesús la̠qui̠ xatícu nalak­chá̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nac xacpú̠n cruz xto­ko­hua­cá­calh pi̠tzu̠ pák­lha̠t antá xuan túcu xpa̠­la­cata xli̠­mak­ni̠­cani̠t, y nac pák­lha̠t chiné xta­tzokni̠t: “Huá eé chixcú xreycán judíos.” ");
INSERT INTO tocNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Y na̠ antá xca̠­pe­kex­to­ko­hua­ca­cani̠t cha̠tiy kalha̠­naní̠n, cha̠tum xpek­stácat Jesús y cha̠tum xpek­xuqui. ");
INSERT INTO tocNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Pus chuná li̠kan­táx­tulh hua̠ntu̠ xta­tzok­ta­hui­lani̠t nac li̠kalh­ta­huaka la̠ta tu̠ xámaj pa̠x­toka Cristo: “Cumu la̠ cha̠tum kalha̠ná li̠ma̠x­tú­calh.” ");
INSERT INTO tocNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Cati̠huá ti̠ antá xta­ti̠­taxtuy ma̠rí xta­li̠­kalh­ka­ma̠nán, xta­ta­la­calh­cata y chiné xta­huaniy: —¡Chi̠nchú cumu huana pi̠ nalac­tla­huaya lanca quim­pu̠­si­cu­lancán y caj liaktutu quilh­ta­macú naya̠­huaya tunu a̠tzinú xatlá̠n! ");
INSERT INTO tocNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¿Túcu chú lani? ¿Lácu pi̠ ni̠lay chú ta̠c­taya nac cruz y calak­ma̠x­tú­canti me̠cstu? ");
INSERT INTO tocNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Maka­pi­tzí̠n xana­puxcun cura xa̠hua xma̠­kalh­ta­hua­ke̠­nacán judíos, na̠chuná xta­li̠­kalh­ka­ma̠nán, chiné xta­huán: —¡Chi̠nchú cumu tla̠n ca̠ma̠­pác­salh a̠tunu cris­tianos pus chú calak­ma̠x­tú­calh sacstu! ");
INSERT INTO tocNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Para xlá xli̠­ca̠na huá Cristo osuchí xreycán judíos sacstu catá̠c­talh nac cruz xla­cata naliucxi­lhá̠hu y chuná chú naca̠­naj­la­ni­yá̠hu. Ama̠­ko̠lh kalha̠­naní̠n na̠chuná xta­li̠­kalh­ka­ma̠nán. ");
INSERT INTO tocNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Amá quilh­ta­macú, ma̠x cumu luu tas­túnut xuani̠t, acxni̠ chu­natá la̠ta ca̠puc­suanko̠lh nac a̠má pu̠la­tama̠n y hasta ca̠mak­tutu hora xalac ca̠ko̠­tanú̠n a̠cu ca̠x­ka­kapá. ");
INSERT INTO tocNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Y na̠ luu acxni­tiyá chú a̠má hora Jesús luu palha chiné ca̠tá­salh: —Eloi, Eloi, ¿lama sabac­tani? —eé tachu­huí̠n huam­putún: “Papá Dios, ¿túcu xla­cata qui­liak­xtek­ma­ka­ni̠ta eé quilh­ta­macú?” ");
INSERT INTO tocNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Maka­pi­tzí̠n lac­chix­cu­huí̠n hua̠nti̠ antá xta­la­yá̠­nalh takáx­matli y chiné tzú­culh tala̠­huaniy: —¡Jó! Cakax­páttit, tasa­nima pro­feta Elías. ");
INSERT INTO tocNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Cha̠tum tokosú̠n alh li̠lupa xax­cuta vinagre caj la̠ panáma̠c y ma̠aká­nu̠lh nac kantum lasasa quihui, li̠ta­ma­ca­yá̠­hualh la̠qui̠ nahuay Jesús. Y chiné ca̠huá­nilh maka­pi­tzí̠n: —Cala­ke̠lh para namín ma̠cti̠y pro­feta Elías. ");
INSERT INTO tocNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Amaktum luu palha tásalh Jesús y aya tuncán ni̠lh. ");
INSERT INTO tocNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Acxni̠ ni̠lh Jesús a̠má lanca lháka̠t xlí­la­kat­la­pa­nancán nac lanca pu̠si­culan xalac Jeru­salén pu̠maka­tiy huá la̠ta sacstu talác­xti̠tli tzu­cuchá ta̠lhmá̠n hasta tu̠tzú. ");
INSERT INTO tocNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Cha̠tum capitán romano antá xlaya lacatzú antaní xuaca Jesús, xlá hua̠k káx­matli lácu chu­huí̠­nalh y úcxilhli acxni̠ ni̠lh. Xlá chiné huá: —Xli̠­ca̠na, eé chixcú Xka­huasa Dios xuani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Y antá na̠ caj mákat xta­la­ca­mi­yá̠­nalh maka­pi­tzí̠n lac­chaján, na̠ antá xlaya María Mag­da­lena, María xtzí San­tiago xatajú y José, xa̠hua Salomé. ");
INSERT INTO tocNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Uma̠­kó̠lh lac­chaján xta­sta̠­la­nit­la̠­huani̠t Jesús acán cani̠huá xan, y xlacán xta­mak­ta̠­yani̠t acxni̠ xla­ma̠chá nac Gali­lea. Xa̠hua antá xta­yá̠­nalh a̠maka­pi­tzí̠n lhu̠hua lac­chaján hua̠nti̠ lac­xtum xta­ta̠­mini̠t Jesús nac Jeru­salén. ");
INSERT INTO tocNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Acxni̠ xko̠­ta­nu̠yá a̠má a̠hua­tiyá quilh­ta­macú acán tla̠n scujcán porque xta­ma̠­ko̠­taní̠n quilh­ta­macú acxni̠ pu̠tum judíos xta­jaxa, ");
INSERT INTO tocNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","milh cha̠tum tali̠­pa̠hu chixcú hua̠nti̠ na̠ xmak­ta­peksi̠y nac xpu̠­ma̠­pek­si̠ncán judíos nac Jeru­salén xuanicán José xlá xalac Ari­matea. Eé tla̠n chixcú xuani̠t, xli̠­pa̠­huán Dios y xkalh­ka­lhi̠ma acxni̠ Dios nali̠mín lak­táxtut. José kálhi̠lh li̠ca­mama y tánu̠lh nac xpu̠­ma̠­peksí̠n Pilato, huá­nilh xla­cata camá̠x­qui̠lh quilh­ta­macú naán ma̠cti̠y xti­yat­li̠hua Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato cacs lacáhua acxni̠ cátzi̠lh pi̠ aya xni̠ni̠t Jesús y tasá­nilh capitán xla­cata naka­lhas­quín para xli̠­ca̠na aya xni̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Acxni̠ huá­nilh capitán pi̠ xli̠­ca̠na aya xni̠ni̠t xlá má̠x­qui̠lh tala­cas­quín José xla­cata cale̠lh xti­yat­li̠hua Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","José tamá̠­hualh mactum sábana y alh ma̠cti̠y nac cruz xti­yat­li̠hua Jesús, huá li̠pu̠­mák­suitli, y aca­li̠stá̠n má̠c­nu̠lh nac aktum tahuaxni hua̠ntu̠ aya xuaxcani̠t nac xlacán sipi y li̠huana̠ li̠la­ka­tá­lalh aktum lanca chí­huix antaní xlac­ta­nu̠cán. ");
INSERT INTO tocNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Mag­da­lena y María xtzí José xlacán taúcxilhli antaní ma̠c­nú̠­calh. ");
INSERT INTO tocNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ti̠tax­tu­ko̠lh sábado acxni̠ ni̠ti̠ cscuja, y acxni̠ tzí̠­sualh hua­tiyá a̠má quilh­ta­macú, María Mag­da­lena, María xtzí José y San­tiago, xa̠hua Salomé, xlacán táalh tata­ma̠­huay xala­cuán per­fumes la̠qui̠ nataán tali̠t­la­hua­pu̠xtuy xti­yat­li̠hua Jesús. ");
INSERT INTO tocNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Li̠cha̠lí domingo luu laca­tzi̠sa tatá̠­qui̠lh y táalh antaní xma̠c­nu̠­cani̠t Jesús cajcu xtax­tu­ma̠chi chi­chiní. ");
INSERT INTO tocNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Sac­stucán chiné xta­la̠­hua­ni­ti̠­lhay: —¿Tícu chú nama̠­ta­ke̠nu̠y cahuá a̠má lanca chí­huix hua̠ntu̠ laca­hui­li̠­cani̠t a̠má lhucu? ");
INSERT INTO tocNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero acxni̠ tácha̠lh taúcxilhli pi̠ ta̠má lanca chí­huix hua̠ntu̠ xli̠­la­ka­ta­la­cani̠t nac lhucu aya xma̠­ta­ke̠­nu̠­cani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tatá­nu̠lh tzinú nac xpu̠­lacni lhucu y antá taúcxilhli pi̠ xuí cha̠tum kahuasa, pero luu sna­papa xlháka̠t y pu̠lhmá̠n hua̠ntu̠ clha­ka̠ni̠t, xlacán luu la̠n tape̠­cualh. ");
INSERT INTO tocNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pero xlá chiné ca̠huá­nilh: —Ni̠ cape̠­cuántit. Hui­xinín putza­yá̠tit Jesús xalac Naza­ret hua̠nti̠ pekex­to­ko­hua­cá­calh nac cruz. Pero xlá aya lacas­ta­cuánalh nac ca̠li̠ní̠n. Ma̠squi luu caucxílhtit uú ni̠ti̠ antaní xta­ra­mi̠­cani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Xa̠huachí capi­tittá y caca̠­hua­ni­pítit xdis­cí­pulos xa̠hua Pedro xla­cata pi̠ naca̠­pu̠­la­niyá̠n naán a̠má nac Gali­lea y antá naucxi­lha̠­pítit porque chuná tica̠­huanín. ");
INSERT INTO tocNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ama̠­ko̠lh lac­chaján xta­pe̠­cuacán tzú­culh talh­pipiy; la̠li̠­huán tatáx­tulh y tokosú̠n táalh. Pero ni̠ti̠ tuncán tali̠­ta̠­chu­huí̠­nalh hua̠ntu̠ xtaucxilhni̠t porque xta­pe̠­cuaxni̠­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Acxni̠ nia̠ cxka­kako̠y a̠má quilh­ta­macú domingo Jesús xla­cas­ta­cuana­ni̠ttá nac ca̠li̠ní̠n; pero pu̠lh María Mag­da­lena tasi­yú­nilh la̠qui̠ xlá naucxilha pi̠ lama xas­tacná. Huá eé pusca̠t hua̠nti̠ xta­mac­xtu­nini̠t kalha­tujún xes­pí­ritu akska­huiní. ");
INSERT INTO tocNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Acxni̠ xlá úcxilhli Jesús xlá ca̠lá­kalh a̠ma̠ko̠lh xcompañeros Jesús hua̠nti̠ maka̠s quilh­ta­macú xta­ta̠­la­ta­pu̠­li̠ni̠t y ca̠huá­nilh lácu xuc­xilhni̠t, xlacán xta­li̠­pu­hua­má̠­nalh y xta­ta­sax­ni̠­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pero acxni̠ xlacán ca̠hua­ní­calh pi̠ Jesús xla­cas­ta­cuanani̠t y xlama xas­tacná, ni̠ taca̠­náj­lalh. ");
INSERT INTO tocNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Caj li̠puntzú na̠ ca̠ta­si­yú­nilh cha̠­tiy­li̠tum xta­ma̠­kalh­ta­huaké̠n xlacán xta­yá̠­nalh nac tiji xtaamá̠­nalh nac aktum ca̠chi­quí̠n; ca̠ta­si­yú­nilh la̠qui̠ nataucxilha pi̠ xlama xas­tacná. ");
INSERT INTO tocNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Acxni̠ taucxilh­ko̠lh, xlacán la̠li̠­huán tatás­pitli y táalh tali̠­ta̠­chu­hui̠nán xa̠maka­pi­tzí̠n dis­cí­pulos pi̠ xli̠­ca̠na xla­cas­ta­cuanani̠t. Pero xlacán ni̠para chuná taca̠­náj­lalh. ");
INSERT INTO tocNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Y aca­li̠sta̠n li̠túm Jesús ca̠ta­si­yú­nilh pacs kalha­ca̠­huitu xdis­cí­pulos la̠qui̠ nata­ca̠­najlay pi̠ xli̠­ca̠na lama xas­tacná. Xlacán xta­hui­lá̠­nalh nac mesa xta­hua̠­ya­má̠­nalh; xlá ca̠la­ca­quílh­ni̠lh tzinú porque luu ni̠ xta­ca̠­naj­la­putún para xli̠­ca̠na xlama xas­tacná, porque caj taliaklhu̠­huá̠t­nalh acxni̠ xli̠­chu­hui̠­nan­cani̠t pi̠ xla­cas­ta­cuanani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Aca­li̠stá̠n acxni̠ xlacán lacatum xta­ta­mac­xtu­mi̠ni̠t chiné ca̠huá­nilh: —Capítit xli̠­hua̠k ca̠chi­quí̠n hua̠ntu̠ tahui­lá̠­nalh xli̠­ca̠­lanca ca̠quilh­ta­macú y caca̠­li̠­ma̠­kalh­chu­hui̠­ní̠tit xli̠­hua̠k cris­tianos eé quin­ta­chu­huí̠n hua̠ntu̠ ma̠sta̠y lak­táxtut. ");
INSERT INTO tocNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Hua̠nti̠ naquin­ta­li̠­pa̠­huán y nata­taakmunuy nata­lak­ma̠xtuy xli̠s­tac­nicán, pero hua̠nti̠ ni̠ naqui­li̠­pa̠­huán pus ámaj ma̠lak­tzanke̠y xli̠s­tacni nac xla­catí̠n Dios acxni̠ naca̠­ma̠­xo­ko̠­ni̠cán hua̠ntu̠ tatit­la­huani̠t. ");
INSERT INTO tocNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Y xla­cáta nata­ca­tzi̠y pi̠ Dios lama nac mila­ta­ma̠tcán maka­pi­tzí̠n hua̠nti̠ naquin­ta­li̠­pa̠­huán naca̠­ma̠x­qui̠cán li̠t­li­hueke xla­cata tla̠n nata­ma̠­pacsay hua̠nti̠ ca̠maka­tla­jani̠t xes­pí­ritu akska­huiní y tla̠n nata­li̠­chu­hui̠nán ti̠pa̠­katzi tachu­huí̠n hua̠ntu̠ xlacán nia̠ xta­ca­tzi̠y. ");
INSERT INTO tocNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Hasta tla̠n nata­chipay lu̠hua y ni̠tu̠ cati­ca̠t­la­huá­nilh, y para túcu nata­huay hua̠ntu̠ kalhi̠y veneno ni̠tu̠ cati­ta­li̠­lá­nilh, y caj xmacán tla̠n nata­li̠­ma̠­pacsay ta̠tat­laní̠n. ");
INSERT INTO tocNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","La̠ chuná ca̠ta̠­chu­hui̠­nan­ko̠lh Quim­pu̠­chi­nacán Jesús tzú­culh tata̠lh­ma̠ni̠y y alh nac akapú̠n antaní hui­lachá Dios. ");
INSERT INTO tocNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Y aca­li̠stá̠n a̠ma̠ko̠lh xta­ma̠­kalh­ta­huaké̠n tatá­ca̠xli y táalh antaní tahui­lá̠­nalh lactzu̠ ca̠chi­quí̠n, tzú­culh tama̠­kalh­chu­hui̠ni̠y cris­tianos xta­chu­huí̠n Cristo hua̠ntu̠ ma̠sta̠y lak­táxtut. Y cumu Dios xca̠­mak­ta̠­yama xlacán xtat­la­huay lhu̠hua lac­lanca li̠cá̠cni̠t ta­scújut la̠qui̠ chuná naca­tzi̠cán pi̠ Dios xlama nac xla­ta­ma̠tcán y xli̠­ca̠na xta­li̠­chu­hui̠­na­má̠­nalh xta­la­ca­pa̠s­tacni.");
INSERT INTO tocNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Amigo Teófilo: Luu xli̠­ca̠na li̠pa̠­xúhu ctzok­niyá̠n a̠má tachu­huí̠n hua̠ntu̠ lhu̠hua cris­tianos tatzak­sani̠t li̠huana̠ xta­tzok­putún la̠ta túcu kan­táx­tulh nac xla­táma̠t Jesu­cristo y luu li̠huana̠ xta­ma̠­lac­ti̠­tu­mi̠­putún, ");
INSERT INTO tocNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","chuná cumu la̠ quin­ca̠­li̠­ta̠­chu­hui̠­na­ni̠tán hua̠nti̠ luu ma̠n taucxilhní̠t la̠ta lácu titzu­cuchá, y aca­li̠stá̠n xlacán na̠ tzú­culh taliakchu­hui̠nán eé tachu­huí̠n porque xta­ca­tzi̠y pi̠ xli̠­cána hua̠ntu̠ xta­li̠­chu­hui̠nán. ");
INSERT INTO tocNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Aquit na̠ luu li̠huana̠ cpu­tza̠­nani̠t y cka­lhas­qui­ni̠­nani̠t xli̠­hua̠k hua̠ntu̠ qui̠­táx­tulh hasta la̠ta lácu luu titzu­cuchá, y lá̠m­para luu tla̠n clac­pu­huán pi̠ nac­tzok­niyá̠n y nac­ma̠­lac­ti̠­tu­mi̠­niyá̠n pu̠tum hua̠ntu̠ qui̠­tax­tuni̠t nac xla­táma̠t Quim­pu̠­chi­nacán, ");
INSERT INTO tocNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","la̠qui̠ na̠chuná huix naca­tzi̠ya li̠huana̠ hua̠ntu̠ aya li̠ma̠­kalh­chu­hui̠­ni̠­ca­ni̠ta. ");
INSERT INTO tocNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Pus la̠nchú nacuaniyá̠n lácu luu mini̠­tanchá eé tachu­huí̠n: Amá maká̠n quilh­ta­macú acxni̠ Herodes gober­nador xuani̠t nac Judea, na̠ acxni̠ xlama cha̠tum cura xuanicán Zaca­rías xlá antá xca̠­ta̠­ta­peksi̠y maka­pi­tzí̠n cura hua̠ntu̠ maká̠n quilh­ta­maxcú tima̠­la­ca­tzu­qui̠chá Abías. Xpusca̠t Zaca­rías xuanicán Isabel, xlá na̠ xli̠­ta­la­ka­pasni xuani̠t a̠má hua̠nti̠ luu xapu̠lh cura xuanicán Aarón. ");
INSERT INTO tocNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zaca­rías chu Isabel luu aksti̠tum xta­la­má̠­nalh nac xla­catí̠n Dios y xta­lak­tzak­sa­má̠­nalh hua̠k tla̠n nata­ma̠­kan­taxti̠y xli̠­ma̠­peksí̠n Quim­pu̠­chi­nacán, xli̠­ca̠na luu tla̠n xta­ca­tzi̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Xlacán ni̠ xta­ka­lhi̠y xcamán, xa̠huachí luu xlac­xtumcán xcha̠­tiycán aya xta­ko̠­lu­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Maktum quilh­ta­macú acxni̠ lák­cha̠lh la̠ta lácu nata­la­ka­chix­cu­hui̠nán a̠ma̠ko̠lh cura anta­nícu xmak­ta­peksi̠y Zaca­rías, pus huata antá alh nac lanca xpu­si­culan Dios xalac Jeru­salén. ");
INSERT INTO tocNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Y cumu luu chuná xta­li̠s­ma­ni̠ni̠t cura nata­macá̠n suerte la̠qui̠ nata­ca­tzi̠y xatícu nalak­chá̠n la̠qui̠ pu̠lh natanu̠y y nala­ka­chix­cu­hui̠nán, pus huata huá lák­cha̠lh Zaca­rías natanu̠y anta­nícu xla­ka­chix­cu­hui̠cán Dios hua̠ntu̠ hui­lachá nac xpu̠­lacni lanca pu̠si­culan la̠qui̠ antá nalh­cuyuy ciensus. ");
INSERT INTO tocNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Li̠huán clhcuma ciensus xa̠maka­pi­tzí̠n xli̠­lhu̠hua cris­tianos xta­kalh­ta­hua­ka­ni­má̠­nalh Dios nac xaquilhtí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Y caj xamaktum xángel Quim­pu̠­chi­nacán tasi­yú­nilh Zaca­rías y úcxilhli pi̠ antá nac xpek­stácat xlaya altar anta­nícu clhcuma ciensus. ");
INSERT INTO tocNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Acxni̠ Zaca­rías úcxilhli a̠má ángel pé̠cualh y niaj para xca­tzi̠y túcu nat­la­huay. ");
INSERT INTO tocNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero ángel chiné huá­nilh: —Ni̠ capé̠­cuanti Zaca­rías, porque luu lakati̠y Dios la̠ kalh­ta­hua­ka­niya, xlá aya kax­matni̠t hua̠ntu̠ huix mak­squina y mim­pusca̠t Isabel ámaj ma̠la­ka­tun­cu­hui̠y cha̠tum actzu̠ skata y huix nali̠­ma̠­pa̠­cu­hui̠ya Juan. ");
INSERT INTO tocNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Huix luu xli̠­ca̠na nali̠­pa̠­xu­huaya min­ka­huasa y na̠chuná xa̠maka­pi­tzí̠n xli̠­lhu̠hua cris­tianos nata­li̠­pa̠­xu­huay acxni̠ xlá nala­ca­chín, ");
INSERT INTO tocNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","porque a̠má min­ka­huasa luu xli̠­ca̠na lanca ta­scújut naka­lhi̠y nac xla­catí̠n Dios. Xlá ni̠ catí­hualh cuchu, y kalhi̠y nahuán xli̠t­li­hueke Espíri­tu Santo hasta acxni̠ nia̠ laca­chín nahuán. ");
INSERT INTO tocNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Y lhu̠hua cris­tianos xalac Israel hua̠nti̠ taka­lha­kax­mat­makani̠t Quim­pu̠­chi­nacán xlá naca̠­ma̠aka­ta̠k­sni̠y pi̠ xma̠n huá Dios nakax­matko̠y y chuná xlacán nata­li̠­pa̠­huam­paray. ");
INSERT INTO tocNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Amá min­ka­huasa Juan napu̠­laniy Quim­pu̠­chi­nacán hua̠nti̠ mima, y na̠chuná naka­lhíy xta­la­ca­pa̠s­tacni chú xli̠t­li­hueke hua̠ntu̠ xka­lhi̠y xamaká̠n pro­feta Elías la̠qui̠ naca̠­lak­pa­li̠niy xta­la­ca­pa̠s­tac­nicán xna­cujcán xanat­la̠tni la̠qui̠ nata­pa̠x­qui̠y xca­mancán, y hua̠nti̠ luu lac­li̠­pe̠­cuánit xta­la­ca­pa̠s­tac­nicán xlá naca̠­ma̠­si­yuniy lácu nata­ka­lha­kax­mat­ni̠nán hua̠ntu̠ Dios ca̠li̠­ma̠­pek­si̠­putún. Y chuná xlá naca̠­ma̠­kalh­chu­hui̠ni̠y cris­tianos la̠qui̠ cha̠­ca­tzi̠ya nata­kalh­ka­lhi̠y Quim­pu̠­chi­nacán hua̠nti̠ namín. ");
INSERT INTO tocNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zaca­rías kalhás­quilh a̠má ángel: —¿Pero lácu chú nac­li̠­ca­tzi̠y para xli̠­ca̠na hua̠ntu̠ qui­hua­nípa̠t? Porque aquit aya ko̠lutá y na̠chuná quim­pusca̠t na̠ aya tzi­caná. ");
INSERT INTO tocNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Amá ángel chiné kálh­ti̠lh: —Aquit qui­hua­nicán Gab­riel, y aquit cta̠s­cujma Dios, xlá qui­ma­ca­mini̠t la̠qui̠ nac­ta̠­chu­hui̠­naná̠n y nac­ma̠­ca­tzi̠­ni̠yá̠n u̠má xasa̠sti tama̠­ca­tzi̠ní̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pero cumu huix ni̠ ca̠najla hua̠ntu̠ cuanín pus huix la̠nchú pímpa̠t ko̠ko̠na, y ni̠lay cati­chu­huí̠­nanti hasta acxni̠ nakan­tax­tuko̠y hua̠ntu̠ cuani­ni̠tán y nala­ca­chín min­ka­huasa. ");
INSERT INTO tocNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Y nac xaquilhtí̠n a̠má lanca pu̠si­culan anta­nícu xla­ka­chix­cu­hui̠­nancán, xli̠­lhu̠hua cris­tianos xta­ka­lhi̠­má̠­nalh la̠qui̠ natax­tu­ya̠chi Zaca­rías, pero xlacán aka­tiyuj xta­la­má̠­nalh porque ni̠ pála xtax­tu­ma̠chi nac pu̠si­culan. ");
INSERT INTO tocNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pero acxni̠ tax­tuchi Zaca­rías xko̠­ko̠ni̠t y ni̠lay xchu­hui̠nán huata caj xca̠­ma­ca­huaniy acxni̠ xca̠­kalh­ti̠­putún hua̠ntu̠ xta­huaniy; pus acxnicú tacá­tzi̠lh a̠ma̠ko̠lh cris­tianos pi̠ ma̠x tzanká túcu xli̠­ma̠­la­ca­hua̠­ni̠­cani̠t nac xpu̠­lacni pu̠si­culan anta­nícu xla­ka­chix­cu­hui̠­nama. ");
INSERT INTO tocNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Acxni̠ lák­cha̠lh quilh­ta­macú la̠ta tama̠­ká­tzi̠lh xtas­cu­jutcán li̠la­ka­chix­cu­huí̠nat nac lanca pu̠si­culan xalac Jeru­salén Zaca­rías tás­pitli nac xca̠­chi­quí̠n nac xchic. ");
INSERT INTO tocNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Chi̠nchú Isabel hua̠nti̠ xpusca̠t Zaca­rías acxni­tiyá tzú­culh maklh­ca­tzi̠y pi̠ niaj sacstu xlama, y ma̠x a̠huayu akqui­tzis papá niaj ni̠ nícu alh; y xlá chiné xlac­pu­huán: ");
INSERT INTO tocNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Huá chuná qui­li̠t­la­huani̠t Quim­pu̠­chi­nacán la̠nchú la̠qui̠ cris­tianos niaj pucutá naquin­ta­li̠­kalh­ka­ma̠nán.” ");
INSERT INTO tocNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Xliakcha̠xán papá Dios maca̠mpá ángel Gab­riel nac aktum ca̠chi­quí̠n xuanicán Naza­ret cxa­pu̠­la­tama̠n Gali­lea ");
INSERT INTO tocNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","la̠qui̠ naán laka­pa­xia̠lhnán cha̠tum tzuma̠t xuanicán María, u̠má tzuma̠t aya xli̠­kalh­ti̠ni̠t José la̠qui̠ nata̠­ta­maka­xtoka; a̠má José na̠ xli̠­ta­la­ka­pasni xuani̠t xamaká̠n rey David. ");
INSERT INTO tocNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Amá ángel lak­ta­nu̠chá anta­nícu xuí María y chiné huá­nilh: —¡Luu ca̠na li̠pa̠­xúhu clak­chimá̠n huix tzuma̠t hua̠nti̠ Dios lac­sac­ni̠tán! Dios Quim­pu̠­chi­nacán huix anka­lhi̠ná ta̠huilán, y xa̠huachí a̠tzinú huix sicu­la­na̠t­la­hua­ni̠tán ni̠ xachuná xa̠maka­pi­tzí̠n lac­chaján. ");
INSERT INTO tocNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Acxni̠ María úcxilhli ángel xlá xli̠­ca̠na cacs li̠la­cáhua la̠ta tu̠ xli̠­xa­kat­li̠ma, y xlá xlac­pu­huama túcu cahuá chuná xli̠­hua­nima. ");
INSERT INTO tocNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Pero ángel tuncán hua­nipá: —María, ni̠ capé̠­cuanti porque Dios lac­sac­ni̠tán la̠qui̠ nama̠­kan­tax­ti̠ya hua̠ntu̠ xlá lac­lhca̠­hui­li̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Huix la̠nchú pímpa̠t kalh­ka­lhi̠ya cha̠tum actzu̠ skata, y acxni̠ nala­ca­chín huix nali̠­ma̠­pa̠­cu­hui̠ya Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Xlá luu xli̠­ca̠na tali̠­pa̠hu chixcú nahuán nac xlak­sti̠­pa̠ncán cris­tianos y luu nami­ni̠niy nali̠­ta­pa̠­cu­hui̠y Xka­huasa Dios hua̠nti̠ luu lanca xla­ca­tzúcut. Xa̠huachí Dios nali̠­ma̠xtuy lanca rey cumu la̠ xamaká̠n xli̠­ta­la­ka­pasni rey David, ");
INSERT INTO tocNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","la̠qui̠ nama̠­pek­si̠nán nac xli̠­ca̠­lanca xpu̠­la­tama̠n Israel cane̠c­xni­cahuá quilh­ta­macú, xa̠huachí xli̠­ma̠­peksí̠n ne̠cxni cati­lák­sputli nac ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","María kalhás­quilh a̠má ángel: —¿Pero lácu chú luu naqui̠­taxtuy porque aquit ni̠ti̠ cta̠hui chixcú? ");
INSERT INTO tocNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Xlá kálh­ti̠lh: —Espíri­tu Santo nalak­miná̠n y xli̠t­li­hueke Dios naakmi­liyá̠n cumu lá puc­lhni, pus huá xpa̠­la­cata a̠má kahuasa hua̠nti̠ nala­ca­chín xla Dios nahuán y luu Xka­huasa Dios nali̠­ma̠­pa̠­cu­hui̠cán. ");
INSERT INTO tocNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Na̠chuná cacatzi pi̠ min­ta̠­pux­nímit Isabel na̠ nama̠­la­ka­tun­cu­huiy cha̠tum actzu̠ skata ma̠squi aya tzi­caná. Pus ma̠squi chuná huancán pi̠ xlá ni̠lay kalhi̠y xcamán pus chú aya le̠ma xliakcha̠xán papá la̠ta niaj sacstu lama. ");
INSERT INTO tocNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Porque xli̠­hua̠k hua̠ntu̠ xta­la­cas­quín Dios ni̠lay cati­ta­mák­xtekli para ni̠ nakan­taxtuy. ");
INSERT INTO tocNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Acxni­tiyá María chiné huá: —Aquit cli̠­taxtuy cumu la̠ xta­sa̠cua Quim­pu̠­chi­nacán, pus chuná cat­lá­hualh Dios nac qui­la­táma̠t la̠ta hua̠ntu̠ huix qui­hua­ni­ni̠ta. Acxni̠ chuná huan­ko̠lh María, a̠má ángel na̠ alhá. ");
INSERT INTO tocNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ni̠ li̠maka̠s quilh­ta­macú María la̠li̠­huán alh nac xapu̠­la­tama̠n Judea hasta nac aktum ca̠chi­quí̠n hua̠ntu̠ xuilachá nac ca̠si­pijni. ");
INSERT INTO tocNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Acxni̠ cha̠lh nac xchic Zaca­rías tuncán tánu̠lh y xakát­li̠lh xta̠­pux­nímit Isabel, ");
INSERT INTO tocNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","y acxni̠ káx­matli Isabel pi̠ xakát­li̠lh María tuncán maklh­cá­tzi̠lh pi̠ tasa­ká̠­li̠lh cskata nac xpu­lacni y lák­chilh xli̠t­li­hueke Espíri­tu Santo. ");
INSERT INTO tocNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Y palha chiné huá: —¡Dios a̠tzinú huix sicu­la­na̠t­la­hua­ni̠tán ni̠ xachuná xa̠maka­pi­tzí̠n lac­chaján, y na̠chuná sicu­la­na̠t­la­huani̠t min­ka­huasa hua̠nti̠ nala­ca­chín! ");
INSERT INTO tocNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Túcu aquit quin­kásat la̠qui̠ namín qui­la­ka­pa­xia̠lhnán hua̠nti̠ xtzí Quim­pu̠­chiná? ");
INSERT INTO tocNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Porque caj la̠ ckáx­matli pi̠ qui­xa­katli, a̠má quis­kata caj la̠ta pa̠xú­hualh tasa­ká̠­li̠lh nac quim­pu̠­lacni. ");
INSERT INTO tocNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Xli̠­ca̠na luu li̠pa̠­xúhu huix lápa̠t nahuán porque ca̠najla xta­chu­huí̠n hua̠ntu̠ huanín; pus luu xli̠­ca̠na pi̠ chuná nakan­taxtuy hua̠ntu̠ ma̠ca­tzi̠­ni̠­ni̠tán Quim­pu̠­chi­nacán. ");
INSERT INTO tocNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Aca­li̠stá̠n María na̠ chiné tzú­culh chu­hui̠nán: Qui­li̠s­tacni maka­pa̠­xu­huay Quim­pu̠­chiná; ");
INSERT INTO tocNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","chi̠nchú qui­nacú luu li̠pa̠­xu­huay quiDios hua̠nti̠ qui­ma̠aka­pu̠­tax­ti̠ná. ");
INSERT INTO tocNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Porque xlá quiucxilh­la­ca­chini̠t aquit koxuta li̠ma̠xken xta­sa̠cua, hasta la̠ la̠nchú eé quilh­ta­macú xli̠­hua̠k cris­tianos naquin­ta­li̠­chu­hui̠nán lácu Dios xli̠­ca̠na qui­ma̠x­qui̠ni̠t lanca tapa̠­xu­huá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Porque Dios hua̠nti̠ lanca xla­ca­tzúcut lac­lanca li̠cá̠cni̠t ta­scújut tla­huani̠t nac qui­la­táma̠t. ¡Luu xli̠­ca̠na pi̠ xma̠n huá tla̠n catzi̠y xta­pu­huá̠n! ");
INSERT INTO tocNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Anka­lhi̠ná naca̠­la­ka­lhamán hua̠nti̠ luu xli̠­ca̠na aksti̠tum tale̠m­putún xla­ta­ma̠tcán nac xla­catí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Uú nac ca̠quilh­ta­macú lac­lanca ta­scújut xlá ca̠t­la­huani̠t, y hua̠nti̠ luu lac­lanca y lac­ta­li̠­pa̠hu xta­li̠­taxtuy xlá ca̠maka­tla­ja­ko̠lh y ca̠ma̠actzu­hui̠­ko̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Y na̠chuná hua̠nti̠ luu lac­ta­li̠­pa̠hu ma̠pek­si̠­naní̠n na̠ ca̠ma̠actzu­hui̠­ko̠lh, y huata hua̠nti̠ ni̠tu̠ xka­satcán xta­huani̠t lac­ta­li̠­pa̠hu ca̠t­lá­hualh. ");
INSERT INTO tocNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Hua̠nti̠ lak­li̠­ma̠x­kení̠n xta­tzin­c­sni̠­má̠­nalh xlá ca̠má̠x­qui̠lh hua̠ntu̠ xlacán xta­mac­la­cas­qui­má̠­nalh, y hua̠nti̠ lac­rrico ca̠mak­lhti̠­ko̠lh hua̠ntu̠ xta­ka­lhi̠y y caj chu­natá ca̠má­ca̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ca̠mak­tá̠­yalh xca­maná̠n xalac Israel porque xca̠­lac­sacni̠t natas­cujniy, y ne̠cxni chu­natá ca̠mák­xtekli huata juerza ca̠la­ka­lhá­malh. ");
INSERT INTO tocNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Porque chuná xca̠­li̠­ta̠­ya­nini̠t Abraham chu xa̠maka­pi­tzí̠n lak­maká̠n qui­li̠­ta­la­ka­pas­nicán, tica̠­ma̠­lac­nú̠­nilh xla­cata naca̠ucxilh­la­ca­chá̠n hua̠nti̠ xli̠­ta­la­ka­pas­nicán Abraham cane̠cxni cahuá quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ma̠x cumu aktutu papá ta̠ta­mak­xtekchá xta̠­pux­nímit Isabel y aca­li̠stá̠n María tas­pitpá nac xchic. ");
INSERT INTO tocNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ni̠ li̠maka̠s quilh­ta­macú taká­tzi̠lh acxni̠ Isabel nata̠­tatlay y ma̠la­ka­tun­cú­huilh actzu̠ skata. ");
INSERT INTO tocNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Xli̠­hua̠k hua̠nti̠ xli̠­ta­la­ka­pasni chu hua̠nti̠ xta̠­la­ca­tzuní̠n acxni̠ tacá­tzi̠lh lácua Quim­pu̠­chi­nacán xla­ka­lha­mani̠t y xma̠x­qui̠ni̠t cha̠tum cskata xlacán taqui̠­la­ka­pa­xiá̠lhnalh y acxtum tata̠­pa̠­xú­hualh. ");
INSERT INTO tocNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Li̠tzi̠má áncalh cir­cun­ci­dar­tla­huacán ámá skata chuná cumu lá xta­li̠s­ma­ni̠ni̠t judíos xtat­la­huay xla­ka­huasán, y na̠chuná xta­li̠­ma̠­pa̠­cu­hui̠­putún cumu la̠ hua­nicán Zaca­rías porque cumu mat huá xtla̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero xtzí chiné huá: —Tamá kahuasa nahua­nicán Juan. ");
INSERT INTO tocNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Pero maka­pi­tzí̠n cris­tianos tahuá­nilh: —¿Túcu xla­cata chuná nali̠­ma̠­pa̠­cu­hui̠ya min­ka­huasa, pus ni̠para cha̠tum mili̠­ta­la­ka­pasni chuná hua­nicán? ");
INSERT INTO tocNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Pero cumu Zaca­rías aka­ta̠pa y ko̠ko xuani̠t caj tzú­culh tama­ca­huaniy acxni̠ xta­ka­lhas­qui­má̠­nalh túcu xlá xli̠­ma̠­pa̠­cu­hui̠­putún actzu̠ kahuasa. ");
INSERT INTO tocNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zaca­rías squilh pi̠tzu̠ pák­lha̠t la̠qui̠ antá natzoknún, y antá chiné tzók­nulh: “Tamá kahuasa nali­ta­pa̠­cu­hui̠y Juan.” Y xli̠­pu̠tum cris­tianos hua̠nti̠ antá xta­la­yá̠­nalh luu cacs tala­cáhua acxni̠ tacá­tzi̠lh pu̠tum hua̠ntu̠ xkan­tax­tuma. ");
INSERT INTO tocNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Acxni­tiyá a̠má quilh­ta­macú cá̠x­lalh csi̠­máka̠t Zaca­rías y tla̠n chu­hui̠­nampá y tzú­culh laka­chix­cu­hui̠y Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Xli̠­hua̠k cris­tianos hua̠nti̠ antá lacatzú xta­hui­lá̠­nalh cacs xta­li̠­la­ca­huán porque ni̠ xtaaka­ta̠ksa a̠má hua̠ntu̠ xqui̠­tax­tuma, y xli̠­ca̠­lanca nac a̠má xpu̠­la­tama̠n Judea hua̠k xli̠­chu­hui̠­nancán la̠ta lácu xla­ca­chini̠t a̠má skata. ");
INSERT INTO tocNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Pu̠tum hua̠nti̠ xta­ca­tzi̠y lácu qui̠­tax­tuni̠t xtzucuy tala­ca­pa̠s­taca y chiné xta­li̠­chu­hui̠nán: —¿Túcu cahuá nali̠­taxtuy eé actzu̠ kahuasa? Huá chuná xta­li̠­huán porque xli̠­ca̠na xta­siyuy lácu Quim­pu̠­chi­nacán csi­cu­la­na̠t­la­huama a̠má skata. ");
INSERT INTO tocNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Espíri­tu Santo akchi­pa­ni­ko̠lh xta­la­ca­pa̠s­tacni Zaca­rías hua̠nti̠ xtla̠t a̠má skata y chuná xlá tzú­culh chu­hui̠nán cumu lá Espíri­tu Santo xma̠­lac­pu­hua̠­ni̠ma, y chiné huá: ");
INSERT INTO tocNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Cane̠c­xni­cahuá cala­ka­chix­cu­huí̠­calh Quim­pu̠­chi­nacán Dios hua̠nti̠ xma̠nhuá li̠pa̠­hua­ná̠hu aquinín xalac Israel, porque chú xlá quin­ca̠ucxilh­la­ca­chi­ni̠tán aquinín xca­maná̠n la̠qui̠ naquin­ca̠­lak­ma̠x­tuyá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Xlá niaj maka̠s aya amajá macamín cha̠tum luu tali̠­pa̠hu chixcú hua̠nti̠ tla̠n naquin­ca̠­ma̠­ka­pu̠­tax­ti̠yá̠n, a̠má chixcú hua̠nti̠ namín xli̠­ta­la­ka­pasni nahuán rey David hua̠nti̠ na̠chuná scuj­nini̠t nac xla­táma̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Pus hasta la̠ta maka̠sá quilh­ta­macú chuná tali̠­chu­hui̠­nani̠t a̠ma̠ko̠lh pro­fetas hua̠nti̠ xlá tica̠­lác­sacli la̠qui̠ naquin­ca̠­hua­niyá̠n, ");
INSERT INTO tocNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","pi̠ xli̠­ca̠na naquin­ca̠­lak­ma̠x­tuyá̠n nac xlak­sti̠­pa̠ncán hua̠nti̠ quin­ca̠­si̠­tzi̠­niyá̠n, y xli̠­pacs hua̠nti̠ ni̠ quin­ca̠ucxilh­pu­tuná̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Pus la̠nchú Dios ma̠kan­tax­ti̠ni̠t hua̠ntu̠ tíhua pi̠ juerza naca̠­la­ka­lhamán xalak­maká̠n qui­li̠­ta­la­ka­pas­nicán, y ni̠para maktum cati­pa̠­tzán­ka̠lh pi̠ ca̠ta̠t­la­huani̠t aktum tala­ca̠xlán. ");
INSERT INTO tocNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Porque Dios tima̠­lac­nú̠­nilh xamaká̠n qui­li̠­ta­la­ka­pas­nicán Abraham hua̠ntu̠ la̠nchú juerza ma̠kan­tax­ti̠ma. ");
INSERT INTO tocNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Xlá tihuá­nilh Abraham pi̠ naquin­ca̠­lak­ma̠x­tuyá̠n aquinín judíos nac xlak­sti̠­pa̠ncán hua̠nti̠ quin­ca̠­si̠­tzi̠­niyá̠n, la̠qui̠ chuná tla̠n xma̠n huá nac­li̠­ma­cuani­yá̠hu y ni̠ti̠ cati­la­ca­pu­hua­níhu, ");
INSERT INTO tocNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","y na̠chuná la̠qui̠ cane̠c­xni­cahuá aksti̠tum nali̠­la­ta­ma̠­yá̠hu xli̠­ma̠­peksí̠n, y chuná tla̠n nali̠­ma­cuani­yá̠hu xma̠nhuá Quim­pu̠­chi­nacán. ");
INSERT INTO tocNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Chi̠nchú huix koxutá actzu̠ quin­ka­huasa, pímpa̠t li̠tax­tuya lanca xpro­feta Quin­tla̠­ticán Dios, porque huix pu̠la­ni­ti̠­lhaya nahuán a̠má Quim­pu̠­chi­nacán hua̠nti̠ namín la̠qui̠ huix naca̠x­tla­hua­niya xtiji. ");
INSERT INTO tocNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Porque huix naca̠­ma̠­ca­tzi̠­ni̠ya hua̠nti̠ luu ca̠lac­sacni̠t Dios pi̠ lak­cha̠­ni̠ttá quilh­ta­macú acxni̠ naca̠­ma̠­tzan­ke̠­na­nicán xta­la̠­ka­lhi̠ncán y la̠qui̠ chuná tla̠n nata­ma̠aka­pu̠­taxti̠y xli̠s­tac­nicán. ");
INSERT INTO tocNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Porque xli̠­ca̠na Dios quin­ca̠­pa̠x­qui̠yá̠n y quin­ca̠­la­ka­lha­maná̠n, pus nama­ca­mi­na̠chá nac akapú̠n cha̠tum hua̠nti̠ li̠taxtuy cumu la̠ xtax­káket chi­chiní hua̠nti̠ nama̠­tzu­qui̠y aktum xasa̠sti quilh­ta­macú nac qui­la­ta­ma̠tcán. ");
INSERT INTO tocNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","La̠qui̠ xli̠­hua̠k hua̠nti̠ xta­lak­tzan­ka̠­ta̠­ya­ni̠ttá, y hua̠nti̠ tala­má̠­nalh nac xaca̠­pucsua, xlá naca̠­ma̠­la­ca­tzu­hui̠y anta­nícu huí tax­káket, y chuná xlá naquin­ca̠­ma̠­si­yu­niyá̠n a̠má tiji hua̠ntu̠ luu xli̠­ca̠na xaak­sti̠tum. ");
INSERT INTO tocNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kampá̠a quilh­ta­macú y a̠má kahuasa Juan la̠li̠­huán xla­ca­ca­tzi̠ma, cstacma xti­yat­li̠hua y na̠chuná xta­la­ca­pa̠s­tacni. Aca­li̠stá̠n acxni̠ cstac­ni̠ttá xlá alh latama̠y nac aktum pu̠la­tama̠n hua­nicán desierto anta­nícu ni̠tu̠ staca y na̠ ni̠ti̠cu lama cris­tianos, y acxni̠ lák­cha̠lh quilh­ta­macú xlá tzú­culh ca̠ma̠­kalh­chu­hui̠ni̠y cris­tianos xalac Israel. ");
INSERT INTO tocNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Na̠ acxni­tiyá a̠má quilh­ta­macú acxni̠ xuí cha̠tum gobier­no nac Roma xuanicán Augusto, luu ma̠pek­sí̠­nalh la̠qui̠ nalay aktum censo y nata­ta­tzok­tanu̠y xli̠­hua̠k cris­tianos hua̠nti̠ xlá xca̠­ma̠­peksi̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Huá u̠má censo luu huacu pu̠lh tla­hua­cani̠t acxni̠ Cirenio gober­nador xuani̠t nac Siria. ");
INSERT INTO tocNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Cha̠­tunu cris­tianos xliánat xuani̠t nac xca̠­chi­qui̠ncán anta­nícu xta­ta­peksi̠y la̠qui̠ antá nata­ta­tzok­tanu̠y nac censo. ");
INSERT INTO tocNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Pus huá xpa̠­la­cata José táca̠xli nac Naza­ret, u̠má pu̠la­tama̠n xta­peksi̠y nac Gali­lea, y alh nac aktum actzu̠ ca̠chi­quí̠n xuanicán Belén xmu­ni­cipio Judea y anta­nícu xla­ca­chini̠t rey David, porque tamá José xli̠­ta­la­ka­pasni xuani̠t xamaká̠n rey David, pus na̠ anta̠ xta­peksi̠y nac Belén. ");
INSERT INTO tocNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","José lac­xtum tá̠alh María huá a̠má tzuma̠t hua̠nti̠ aya xli̠­kalh­ti̠ni̠t pi̠ nata̠­ta­maka­xtoka, pero chú xlá niaj sacstu xlama. ");
INSERT INTO tocNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Y luu acxni̠ antá xta­la­ma̠­nanchá nac Belén lák­cha̠lh quilh­ta­macú la̠ta María nama̠­la­ka­tun­cu­hui̠nán. ");
INSERT INTO tocNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Cumu ni̠ xta­mac­lani̠t xanícu nata­lak­tun­cu­hui̠y nac mesón huata antá ma̠la­ka­tun­cú­hui̠lh a̠má xka­huasa anta­nícu xca̠­ma̠­nu̠cán taka­lhí̠n, y li̠pá̠­chi̠lh pá̠hui̠t y antá tará­mi̠lh nac xpu̠­hua̠y cahua̠yu. ");
INSERT INTO tocNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Lacatzú nac Belén nac ca̠la­kuá̠n xta­lak­tun­cu­hui­má̠­nalh maka­pi­tzí̠n xmak­ta­kalh­nacán bor­regos nac ca̠tu­huá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Caj xamaktum ca̠ta­si­yú­nilh cha̠tum xángel Quim­pu̠­chi­nacán y xli̠­ca̠­lanca anta­nícu xta­hui­lá̠­nalh tasí­yulh xtax­káket Quin­tla̠­ticán Dios. Xlacán luu la̠n tapé̠­cualh. ");
INSERT INTO tocNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pero a̠má ángel chiné ca̠huá­nilh: —Ni̠ cape̠­cuántit porque cmimá̠n ca̠hua­niyá̠n aktum tachu­huí̠n hua̠ntu̠ la̠n nali̠­pa̠­xu­hua­yá̠tit hui­xinín chu xli̠­pu̠tum lac­chix­cu­huí̠n hua̠nti̠ tahui­lá̠­nalh nac ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Pus la̠nchú nac Belén anta­nícu xca̠­chi­quí̠n xuani̠t a̠má xamaká̠n rey David lacá­chilh Cristo hua̠nti̠ luu xli̠­ca̠na Mim­pu̠­chi­nacán hua̠nti̠ naca̠­ma̠aka­pu̠­tax­ti̠yá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Y la̠qui̠ hui­xinín luu laca­tancs naca̠­naj­la­yá̠tit hua̠ntu̠ cca̠­hua­nimá̠n antá nama̠­nok­lhu­yá̠tit actzu̠ skata tara­mi̠­cani̠t nahuán nac xpu̠­hua̠y cahua̠yu y li̠pa̠­chi̠­cani̠t xpá̠­hui̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Caj li̠puntzú lhu̠hua maka­pi­tzí̠n li̠túm ángeles xalac akapú̠n támilh anta­nícu xlacán xta­hui­lá̠­nalh y luu li̠pa̠­xúhu tzú­culh taquilh­tli̠y, xta­la­ka­chix­cu­hui̠­má̠­nalh Dios, chiné xta­qui­lhuamá̠­nalh: ");
INSERT INTO tocNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Cama̠x­quí̠hu cá̠cni̠t Dios hua̠nti̠ hui­lachá nac akapú̠n! Na̠chuná uú nac ca̠quilh­ta­macú caánalh tapa̠­xu­huá̠n nac xlak­sti̠­pa̠ncán cris­tianos hua̠nti̠ xlá ca̠lac­sacni̠t naca̠­lak­ma̠xtuy. ");
INSERT INTO tocNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Acxni̠ taanko̠lh ángeles nac akapú̠n, a̠ma̠ko̠lh xmak­ta­kalh­naní̠n bor­regos chiné tzú­culh tala̠­huaniy: —La̠li̠­huán caáhu nac Belén, caáhu ucxi­lhá̠hu túcu chí mat kan­tax­tuni̠t hua̠ntu̠ quin­ca̠­qui̠­ma̠­ca­tzi̠­ni̠­chín Quim­pu̠­chi­nacán. ");
INSERT INTO tocNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Y a̠ma̠ko̠lh lac­chix­cu­huí̠n la̠li̠­huán táalh y caj puntzú tácha̠lh, y xli̠­ca̠na taúcxilhli María chu José xa̠hua a̠má actzu̠ skata pi̠ xli̠­ca̠na antá xmá nac xpu̠­hua̠y cahua̠yu. ");
INSERT INTO tocNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Acxni̠ xlacán taúcxilhli pi̠ xli̠­ca̠na, pus xlacán tzú­culh tali̠­chu­hui̠nán hua̠ntu̠ ángeles xca̠­hua­nini̠t la̠ta lácu xla­ca­chini̠t a̠má skata. ");
INSERT INTO tocNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ama̠­ko̠lh cris­tianos hua̠nti̠ takáx­matli cacs tali̠­la­cáhua hua̠ntu̠ xlacán xta­qui­lhuamá̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Na̠chuná María luu hua̠k xla­ca­pa̠s­tacma hua̠ntu̠ xkan­tax­tuma, y hua̠k xma̠­químa nac xnacú. ");
INSERT INTO tocNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Aca­li̠stá̠n a̠ma̠ko̠lh xmak­ta­kalh­naní̠n bor­regos tatás­pitli anta­nícu xlacán xta­mi­ni̠­tanchá, xta­ca̠c­ni̠­na­ni­má̠­nalh y na̠chuná xta­pa̠x­cat­ca­tzi̠­ni­má̠­nalh caj xpa̠­la­cata cumu xli̠­ca̠na hua̠k chuná xqui̠­tax­tuni̠t hua̠ntu̠ xca̠­hua­nini̠t ángeles. ");
INSERT INTO tocNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Li̠tzi̠má áncalh cir­cun­ci­dar­tla­huacán a̠má actzu̠ kahuasa y acxni̠ li̠ma̠­pa̠­cu­huí̠ca xta­cu­huiní Jesús porque ángel chuná xuanini̠t María acxni tzu­ma̠tcú xlama. ");
INSERT INTO tocNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Acxni̠ taká­tzi̠lh quilh­ta­macú la̠ta lácu xuí xli̠­ma̠­peksí̠n Moisés xla­cata acxni̠ nala­ca­chín cha̠tum skata cale̠­ní­calh Dios aktum li̠la­ka­chix­cu­hui̠n la̠qui̠ chuná nache­ke̠­makán xtzí hua̠ntu̠ xli̠x­ca­jua̠lani̠t uú xala ca̠quilh­ta­macú. La̠qui̠ na̠ nata­ma̠­kan­taxti̠y hua̠ntu̠ xta­li̠s­ma­ni̠ni̠t pus na̠chuná tat­lá­hualh José chu María táalh nac xaca̠­chi­quí̠n Jeru­salén y na̠ tále̠lh a̠má actzu̠ kahuasa la̠qui̠ nama­ca­ma̠x­qui̠cán Quim­pu̠­chi­nacán nac lanca pu̠si­culan antá. ");
INSERT INTO tocNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Huá chuná tali̠t­lá­hualh porque nac xli̠­ma̠­peksí̠n Dios chiné tatzokni̠t: “Amá kahuasa hua̠nti̠ luu pu̠lh nala­ca­chín xlá Dios nali̠­pu̠lh­ca̠cán.” ");
INSERT INTO tocNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Pus ni̠ lhu̠hua hua̠ntu̠ xlacán tále̠lh caj xma̠nhuá actzú hua̠ntu̠ nata­li̠­la­ka­chix­cu­hui̠nán chuná cumu la̠ talh­ca̠ni̠t nac xli̠­ma̠­peksí̠n Dios nale̠­nicán para tantiy ca̠na̠spu̠n osuchí tantiy paloma. ");
INSERT INTO tocNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na̠ acxni̠ a̠má quilh­ta­macú xlama nac Jeru­salén cha̠tum chixcú xuanicán Simeón. Amá chixcú luu tla̠n xca­tzi̠y y luu aksti̠tum xlama y xma̠nhuá Dios xli̠­pa̠­huán, xa̠huachí xlá na̠ xka­lhi̠ma a̠má quilh­ta­macú la̠ta lácu Dios nama­camín hua̠nti̠ nalak­ma̠x­tunún nac xapu̠­la­tama̠n Israel. Espíri­tu Santo xuí nac xla­táma̠t Simeón ");
INSERT INTO tocNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","y huá xlá xma̠­ca­tzi̠­ni̠ni̠t pi̠ xlá ni̠ catí­ni̠lh hasta caní luu ma̠n xla­kas­tapu naliucxilha a̠má Cristo hua̠nti̠ Dios nama­camín la̠qui̠ naca̠­lak­ma̠xtuy. ");
INSERT INTO tocNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Maktum quilh­ta­macú Espíri­tu Santo ma̠lac­pu­huá̠­ni̠lh xla­cata caalh nac lanca pu̠si­culan, y acxni­tiyá a̠má quilh­ta­macú acxni̠ a̠má actzu̠ kahuasa Jesús xli̠­min­cani̠t nac Jeru­salén la̠qui̠ na̠chuná natat­la­huaniy Dios hua̠ntu̠ xlá xla­cas­quín cumu la̠ xtalh­ca̠ni̠t nac xli̠­ma̠­peksí̠n Moisés. ");
INSERT INTO tocNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Acxni̠ Simeón úcxilhli a̠má actzu̠ kahuasa chexli y tzú­culh laka­chix­cu­hui̠y Dios, chiné xqui­lhuama: ");
INSERT INTO tocNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Quin­tla̠­ticán Dios, chú aya tla̠n li̠pa̠­xúhu naqui­ma­ca­ma̠s­ta̠ya ma̠squi cac­ni̠lh, porque huix aya ma̠kan­tax­ti̠­ni̠ta la̠nchú hua̠ntu̠ tima̠­lac­nu̠ni eé koxutá li̠ma̠xken min­ta­sa̠cua. ");
INSERT INTO tocNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Aquit luu xli̠­ca̠na ma̠n qui­la­kas­tapu cliucxilhni̠t hua̠nti̠ huix maca­mi­ni̠ta la̠qui̠ naca̠­lak­ma̠xtuy ");
INSERT INTO tocNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","xli̠­hua̠k cris­tianos cani̠hua̠ xalaní̠n hua̠nti̠ nata­li̠­pa̠­huán. ");
INSERT INTO tocNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Huá u̠má kahuasa li̠taxtuy cumu la̠ tax­káket hua̠nti̠ naca̠­mak­skoniy xli̠­hua̠k cris­tianos hua̠nti̠ ni̠ tala­ka­pasá̠n, la̠qui̠ chuná naca̠c­ni̠­na­nicán a̠ma̠ko̠lh min­ca­maná̠n xalac Israel hua̠nti̠ huix ca̠lac­sac­ni̠ta. ");
INSERT INTO tocNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José y María luu cacs xta­kax­mat­má̠­nalh hua̠ntu̠ Simeón xqui­lhuama xpa̠­la­cata a̠má skata. ");
INSERT INTO tocNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Y Simeón ca̠si­cu­la­na̠t­lá­hualh, y aca­li̠stá̠n chiné huá­nilh xtzí a̠má skata: —María, eé actzu̠ min­ka­huasa li̠pu̠lh­ca̠­cani̠t xla­cata lhu̠hua hua̠nti̠ uú xalac Israel nata­lak­makán y chuná nata­li̠­lak­tzanka̠y, pero na̠chuna li̠túm lhu̠hua hua̠nti̠ nata­li̠­pa̠­huán y chuná xlacán nata­lak­taxtuy. ");
INSERT INTO tocNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Chuná nata­li̠­ta­siyuy cha̠­tunu a̠cha̠­tunu cris­tianos lácu tala­ca­pa̠s­tacnán nac xna­cujcán; pero hua̠nchú tu̠ huix mila­cata luu lanca tali̠­pu­huá̠n nahuán porque chuná ámaj qui̠­tax­tu­niyá̠n cumu lá aktum espada hua̠ntu̠ nama̠­lak­tax­ti̠ko̠y mili̠s­tacni. ");
INSERT INTO tocNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Na̠ antá xlaya nac lanca pu̠si­culan cha̠tum pusca̠t hua̠nti̠ na̠ luu xaka­ta̠ksa xta­la­ca­pa̠s­tacni Dios, u̠má pusca̠t xuanicán Ana; xtla̠t xuanicán Fanuel, u̠má chixcú antá xta­peksi̠y nac aktum ca̠chi­quí̠n hua̠ntu̠ xma̠­quilh­tzu­qui̠ni̠t a̠má xamaká̠n chixcú xuanicán Aser. Ana luu tzi­caná xuani̠t, acxni̠ luu tzu­ma̠tcú xuani̠t xlá tita­ma­káx­tokli, luu tla̠n aktujún ca̠ta ta̠la­tá­ma̠lh xta̠­ko̠lú, pero xlá ni̠lh y chu­natá ca̠ta caj sacstu xlama. ");
INSERT INTO tocNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Chú aya xle̠ma ta̠ti­pu­xa­ma­ta̠ti ca̠ta la̠ta xni̠­makan­cani̠t y anka­lhi̠ná xan nac pu̠si­culan ma̠squi ca̠cu­huiní chu ca̠tzi̠sa xla­ka­chix­cu­hui̠y Quim­pu̠­chi­nacán Dios y anka­lhí̠n xkalh­xteknín y xkalh­ta­hua­kaniy Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na̠ acxni­tiyá chilh Ana anta­nícu xlacán xta­la­yá̠­nalh y na̠ tzú­culh pa̠x­cat­ca­tzi̠niy Dios caj xpa̠­la­cata a̠má skata. Aca­li̠stá̠n cani̠huá la̠ta­nícu xca̠­ma̠­nok­lhuy hua̠nti̠ xta­ka­lhi̠­má̠­nalh lácu Dios naca̠­lak­ma̠xtuy xca­maná̠n xalac Jeru­salén huá tuncán xca̠­li̠­xa­katli̠y a̠má actzu̠ skata Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Y aca­li̠stá̠n la̠ tama̠­kan­tax­ti̠­ko̠lh hua̠ntu̠ xlacán xta­li̠s­ma­ni̠ni̠t cumu la̠ xtalh­ca̠ni̠t nac xli̠­ma̠­peksí̠n Dios xlacán la̠li̠­huán tatas­pitpá nac Naza­ret hua̠ntu̠ xma̠­peksi̠y Gali­lea porque antá xalá xta­huani̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Y a̠má actzu̠ kahuasa la̠li̠­huán xla­ca­ca­tzi̠ma y skala xuama porque Dios csi­cu­la­na̠t­la­huama. ");
INSERT INTO tocNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Xtla̠t Jesús xa̠hua xtzí luu chuná xta­li̠s­ma­ni̠ni̠t xtaa̠n ca̠ta cá̠ta nac Jeru­salén la̠qui̠ nata­la­ka­chix­cu­hui̠nán nac xapa̠xcua taak­spun­tza̠lí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Pus acxni̠ Jesús ma̠ká­tzi̠lh xak­cu̠tiy ca̠ta pu̠tum táalh antá chuná la̠ xta­li̠s­ma­ni̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Acxni̠ la̠ sput­ko̠lh pa̠xcua xlacán la̠li̠­huán tatás­pitli pero Jesús tamak­xtekchá nac Jeru­salén y María ni̠ xca­tzi̠y ni̠para José. ");
INSERT INTO tocNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Pus cumu xli̠­hua̠k cris­tianos xta­tas­pit­má̠­nalh nac xca̠­chi­qui̠ncán xlacán xta­lac­pu­huán pi̠ ma̠x antá xmak­mima Jesús nac xlak­sti̠­pa̠ncán cris­tianos, tan­tacú tali̠t­lá̠­hualh pero ca̠ko̠­tanú̠n acxni̠ tapú­tzalh y taka­lhás­quilh hua̠nti̠ xli̠­ta­la­ka­pas­nicán chu hua̠nti̠ xta̠­la­ca­tzujcán, ");
INSERT INTO tocNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ni̠para cha̠tum tícu xkalh­ta­si­yú­nilh. Cumu ni̠ tamácla huata la̠li̠­huán tatas­pitpá nac Jeru­salén la̠qui̠ antá nata­pu­tza­ya̠chá. ");
INSERT INTO tocNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Xli̠aktutu quilh­ta­macú la̠ta xta­pu­tza­má̠­nalh acxni̠ taqui̠­mác­lalh antá xlá xlahui nac lanca pu̠si­culan xca̠­ta̠­kalh­chu­hui̠­nama xma̠­kalh­ta­hua­ke̠­nacán judíos, xlacán luu cacs xta­kax­matniy y xta­ka­lhas­quín hua̠ntu̠ xlacán xta­ca­tzi̠­putún. ");
INSERT INTO tocNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Xli̠­pu̠tum hua̠nti̠ xta­kax­mat­ni­má̠­nalh xta­chu­huí̠n luu xli̠­ca̠na cacs xta­li̠­la­ca­huán porque xli̠­ca̠na xka­lhi̠y lanca li̠s­ka­lala, xa̠huachí hua̠ntu̠ xka­lhas­quincán luu tancs xkalh­ti̠nán. ");
INSERT INTO tocNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Antá talák­cha̠lh xtzí Jesús chu xtla̠t, luu cacs tala­cáhua caj xpa̠­la­cata hua̠ntu̠ xtaucxilh­má̠­nalh, pero xtzí chiné huá­nilh: —Ta̠ta, ¿túcu xpa̠­la­cata la̠ eé chuná qui­la̠­li̠t­la­hua­yá̠hu? Chí xlá min­tla̠t chu aquit cca̠­pu­tzat­la̠­huaná̠n porque cca̠­mak­li̠­huamá̠n chicá para túcu lánilh clac­pu­hua­ma̠­náhu aquinín. ");
INSERT INTO tocNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Pero Jesús chiné ca̠huá­nilh: —Pero ¿túcu chú xqui­la̠­li̠­pu­tza­ma̠­náhu? ¿Lácu pi̠ ni̠ catzi̠­yá̠tit pi̠ aquit huá nac­li̠­taaka­tzanke̠y xta­scújut quin­tla̠t? ");
INSERT INTO tocNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero xlacán ni̠ taaká­ta̠ksli hua̠ntu̠ xlá ca̠kálh­ti̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Xlá ni̠ aklhu̠­huá̠t­nalh y la̠li̠­huán ca̠ta̠­tás­pitli y ca̠ta̠­minchá nac Naza­ret. La̠tachá túcu xli̠­ma̠­pek­si̠cán xlá hua̠k xca̠­ka­lha­kax­mata. Pero María hua̠k xma̠­qui̠ma nac xnacú hua̠ntu̠ xqui̠­tax­tu­nima nac xla­táma̠t a̠má actzu̠ kahuasa. ");
INSERT INTO tocNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús la̠li̠­huán cstacma xa̠huachí xka­lhi̠ma tla̠n tala­ca­pa̠s­tacni y Dios csi­cu­la­na̠t­la­huama, y na̠chuná cris­tianos luu xta­li̠­pa̠­xu­huay porque xlá xka­lhi̠y xatlá̠n xta­la­ca­pa̠s­tacni. ");
INSERT INTO tocNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Acxni̠ aya xle̠ma xliakcu̠­qui­tzis ca̠ta la̠ta xuí li̠go­ber­nador nac Roma lanca ma̠pek­si̠ná Tiberio, Poncio Pilato gober­nador xuani̠t nac Judea, chi̠nchú xlá Herodes gober­nador xuani̠t nac Gali­lea, xta̠Felipe gober­nador xuani̠t nac Iturea chu nac Trac­o­nite, y chi̠nchú xlá Lisa­nias gober­nador xuani̠t nac Abi­linia, ");
INSERT INTO tocNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","na̠ acxni­tiyá a̠má quilh­ta­macú acxni̠ Anás chu Caifás lac­xtum xana­puxcun cura xta­huani̠t nac Jeru­salén la̠qui̠ natas­cujniy Dios, na̠ acxni­tiyá ni̠maka̠s quilh­ta­macú Dios ma̠ca­tzí̠­ni̠lh hua̠ntu̠ xli̠t­lá­huat Juan xka­huasa Zaca­rías acxni̠ xlá antá xla­ma̠chá nac desierto. ");
INSERT INTO tocNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Y chuná xlá Juan ca̠la­ka­tza̠­la­ko̠lh lactzu̠ ca̠chi­quí̠n hua̠ntu̠ xta­hui­lá̠­nalh lacatzú nac xquilhtú̠n kalh­tu̠­choko hua­nicán Jordán, y xlá xca̠­liakchu­hui̠­na­nima cris­tianos y xca̠­hua­nima pi̠ nata­lak­pali̠y xali̠xcáj­nit xla­ta­ma̠tcán y nata­ta̠k­munuy la̠qui̠ chuná tla̠n naca̠­ma̠­tzan­ke̠­na­nicán xta­la̠­ka­lhi̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Huá chuná li̠kan­táx­tulh hua̠ntu̠ xtzokni̠t nac xlibro pro­feta Isaías acxni̠ chiné huá: Takax­mata aktum tachu­huí̠n nac desierto y chiné huan: “Caca̠x­tla­hua­nítit tiji anta­nícu luu tla̠n nalacmín Quim­pu̠­chi­nacán; cama̠x­tu­nítit kantum tiji hua̠ntu̠ statua. ");
INSERT INTO tocNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","La̠ta nícu tapon­ka­nani̠t hua̠k nata­ca̠x­tumi̠y, y na̠chuná anta­nícu hui­la­ko̠lh ke̠stí̠n hua̠k naca̠­pon­kacán, y anta­nícu talh­ka­huini̠t tiji hua̠k nama̠­tan­csa­yá̠tit, y na̠chuná anta­nícu ni̠ ca̠xtum hua̠k nama̠­ca̠x­tu­pi̠­yá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Y chuná xli̠­ca̠­lanca ca̠quilh­ta­macú naca­tzi̠cán pi̠ huí lak­táxtut hua̠ntu̠ ma̠sta̠y Dios.” ");
INSERT INTO tocNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Luu lhu̠hua cris­tianos xta­lakmín Juan la̠qui̠ nata­taakmunuy, y maka­pi­tzí̠n chiné xlá xca̠­huaniy: —¡Hui­xinín luu xta̠­chuná lapá̠tit cumu la̠ talay a̠ma̠ko̠lh lac­li̠xcáj­nit xca­naní̠n lu̠hua acxni̠ tatzucuy tatza̠­laniy lhcúya̠t acxni̠ ca̠x­ko­yu­má̠­calh! ¿Tícu chú ca̠ma̠­ca­tzi̠ní̠n para caj la̠ nataakmu­nu­yá̠tit aya tla̠n napu̠­tax­tu­yá̠tit a̠má lanca tapa̠tí̠n hua̠ntu̠ Dios naca̠­ma­ca­mi­niyá̠n? ");
INSERT INTO tocNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Huata tu̠ tla̠n nahuán pero aksti̠tum cala­ta­pá̠tit la̠qui̠ chuná sta­lanca nali̠­ta­si­yu­yá̠tit pi̠ xli̠­ca̠na aya lak­pa­li̠­ni̠­tátit xali̠xcáj­nit min­ta­la­ca­pa̠s­tac­nicán. Porque para hui­xinín lac­pu­hua­ná̠tit pi̠ cumu xli̠­ta­la­ka­pasni Abraham hui­xinín ni̠lay túcu cati­ca̠ak­spulán, pus niaj chuná calac­pu­huántit; pus para hui­xinín huá li̠pa̠­hua­ná̠tit, aquit laca­tancs cca̠­hua­niyá̠n pi̠ u̠ma̠ko̠lh chí­huix Dios tla̠n naca̠­li̠­ma̠xtuy xli̠­ta­la­ka­pasni Abraham para lacas­quín. ");
INSERT INTO tocNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Dios ca̠li̠­pu̠lh­ca̠yá̠n cumu la̠ akatum quihui, xlá aya cha̠­ca­tzi̠ya chi­pani̠t xhacha la̠qui̠ naca̠­tan­ca̠mi̠y a̠ma̠ko̠lh quihui hua̠ntu̠ niaj tu̠ li̠ma­cuán. Porque akatum quihui hua̠ntu̠ ni̠ lacuán tahuacay xta­huácat tan­ca̠­mi̠cán y ma̠pu̠cán nac lhcúya̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Acxni̠ takáx­matli eé tachu­huí̠n lhu̠hua cris­tianos hua̠nti̠ chiné taka­lhás­quilh: —¿Túcu chi̠nchú aquinín qui­li̠t­la­huatcán? ");
INSERT INTO tocNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Y Juan chiné xca̠­kalhti̠y: —Hua̠nti̠ kalhi̠y mactiy xta­maknu catá̠i̠lh mactum hua̠nti̠ ni̠tu̠cu kalhi̠y ni̠para mactum; y hua̠nti̠ aka­ta̠x­tu­nima hua̠ntu̠ huama pus cata̠hua hua̠nti̠ ni̠tu̠cu kalhi̠y hua̠ntu̠ nahuay. ");
INSERT INTO tocNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Y na̠chuná maka­pi­tzí̠n lac­chix­cu­huí̠n hua̠nti̠ xta­ma̠­ta̠­ji̠nán im­pues­tos na̠ támilh la̠qui̠ na̠ nata­taakmunuy, xlacán chiné taka­lhás­quilh Juan: —Ma̠kalh­ta­hua­ke̠ná, ¿túcu aquinín qui­li̠t­la­huatcán? ");
INSERT INTO tocNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan chiné ca̠huá­nilh: —Ni̠ luu tapa­ra̠xlá cama̠­ta̠­ji̠­nántit, y ni̠ cala­ca­tza̠­látit li̠ma̠­peksí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Maka­pi­tzí̠n sol­dados xlacán na̠ chiné taka­lhás­quilh: —Chi̠nchú aquinín, ¿túcu qui­li̠t­la­huatcán? Juan chiné ca̠kálh­ti̠lh: —Para túcu kalhi̠y cha̠tum chixcú ni̠ afuerza camak­lhtí̠tit, xa̠huachí ni̠ caca̠­ma­ke̠k­lhátit; na̠chuna li̠túm ni̠tu̠ cali̠­ya̠­huátit taaksaní̠n xla­cata chuná tla̠n nama̠­la­ca­pu̠­yá̠tit, na̠chuná min­tas­kahucán mejor cali̠­pa̠x­cat­ca­tzi̠­tittá hua̠ntu̠ ca̠ma̠x­qui̠­ca­ná̠tit. ");
INSERT INTO tocNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Cumu xli̠­hua̠k cris­tianos xta­kalh­ka­lhi̠­má̠­nalh a̠má quilh­ta­macú acxni̠ namín Cristo hua̠nti̠ naca̠­lak­ma̠xtuy, xlacán xtzu­cu­ni̠ttá talac­pu­huán pi̠ a̠huayu ma̠x Juan Bau­tista huá Cristo. ");
INSERT INTO tocNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Juan chiné ca̠huá­nilh a̠ma̠ko̠lh cris­tianos: —Xli̠­ca̠na xlá pi̠ aquit caj chú­chut cca̠­liakmu­numá̠n, pero niaj maka̠s quilh­ta­macú mima cha̠tum chixcú hua̠nti̠ naca̠­liakmu­nuyá̠n xli̠t­li­hueke Espíri­tu Santo chu lhcúya̠t. Xlá a̠tzinú lanca xla­ca­tzúcut ni̠ xachuná aquit, pus aquit ni̠para tzinú qui­mi­ni̠niy nac­li̠­taxtuy xta­sa̠cua nacuán la̠qui̠ nac­xcutniy xata­síhu xtu̠­xu̠hua. ");
INSERT INTO tocNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Xlá aya li̠huana̠ laca­pa̠s­tacni̠t lácu naca̠­ma̠­paj­pi­tziy cris­tianos, chuná xlá naca̠t­la­huay cumu la̠ a̠má hua̠nti̠ cha̠­ca­tzi̠ya chi­pani̠t xli̠­lac­su­nucán xtrigo la̠qui̠ namakaniy xapalhma, y acxni̠ aya lac­su­nu­ko̠ni̠t nahuán y a̠má xlakstu xatalhtzi trigo antá nama̠­qui̠y nac xchic, y a̠má xapalhma antá nama̠pu̠y nac lhcúya̠t hua̠ntu̠ ne̠cxni lak­mixa. ");
INSERT INTO tocNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Y na̠chuná lhu̠hua maka­pi­tzí̠n tachu­huí̠n hua̠ntu̠ Juan xca̠­li̠­xa­katli̠y a̠ma̠ko̠lh cris­tianos la̠qui̠ chuná nataaka­ta̠ksa a̠má xasa̠sti tama̠­ca­tzi̠ní̠n lácu Dios xca̠­ma̠­lac­nu̠­nima xta­pá̠x­qui̠t y tla̠n naca̠­lak­ma̠xtuy. ");
INSERT INTO tocNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Pero milh maktum quilh­ta­macú acxni̠ Juan tamac­nú̠­calh nac pu̠la̠­chi̠n caj xpa̠­la­cata cumu xlá li̠huá­nilh a̠má gober­nador xuanicán Herodes pi̠ ni̠tlá̠n la̠ a̠má xta̠hui Herod­ías xpusca̠t xta̠Felipe y na̠chuná li̠huá­nilh xli̠­hua̠k hua̠ntu̠ xlá ni̠tlá̠n xtla­huani̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pero a̠má Herodes ni̠para tzinú kalha­káx­matli hua̠ntu̠ huá­nilh, huata xlá tla­hualhcú hua̠ntu̠ ni̠tlá̠n porque caj la̠ta maka­sí̠­tzi̠lh ma̠ta­mac­nu̠­ní̠­nalh nac pu̠la̠­chi̠n Juan Bau­tista. ");
INSERT INTO tocNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Maktum quilh­ta­macú acxni̠ Juan nia̠ xta­mac­nu̠cán nac pu̠la̠­chi̠n y acxni̠ lhu̠hua cris­tianos xca̠akmu­numa, Jesús na̠ lák­milh la̠qui̠ na̠ nataakmunuy; y acxni̠ taakmu­nu­ko̠lh tzú­culh kalh­ta­hua­kaniy Dios. Caj xamaktum talá­qui̠lh akapú̠n ");
INSERT INTO tocNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","y Espíri­tu Santo ta̠c­tachi nac xok­spú̠n cumu la̠ actzu̠ paloma xla­cata hua̠k naucxilhcán y takáx­matli aktum tachu­huí̠n hua̠ntu̠ minchá nac akapú̠n y chiné huá: —Huix Quin­ka­huasa hua̠nti̠ luu cpa̠x­qui̠yá̠n, luu cpa̠­xu­huay caj mila­cata. ");
INSERT INTO tocNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús xka­lhi̠y puxa­ma­cá̠hu ca̠ta acxni̠ ma̠tzú­qui̠lh xta­scújut. Cumu xpu­huancán pi̠ huá xtla̠t xuani̠t José xlá xca̠­ka­lhi̠y xalak­maká̠n xli̠­ta­la­ka­pasni y chiné xca̠­hua­nicán: Xtla̠t José xuanicán Elí, ");
INSERT INTO tocNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","xtla̠t Elí xuanicán Matat, xtla̠t Matat xuanicán Leví, xtla̠t Leví xuanicán Melqui, xtla̠t Melqui xuanicán Jana, a̠má xtla̠t Jana xuanicán José, ");
INSERT INTO tocNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","xtla̠t José xuanicán Mata­tías, eé xtla̠t Mata­tías xuanicán Amós, xtla̠t Amós xuanicán Nahum, xtla̠t Nahum xuanicán Esli, xtla̠t Esli xuanicán Nagai, ");
INSERT INTO tocNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","xtla̠t Nagai xuanicán Maat, xtla̠t Maat xuanicán Mata­tías, xtla̠t Mata­tías xuanicán Semei, xtla̠t Semei xuanicán José, xtla̠t José xuanicán Judá, ");
INSERT INTO tocNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","xtla̠t Judá xuanicán Joanán, xtla̠t Joanán xuanicán Resa, xtla̠t Resa xuanicán Zoro­babel, xtla̠t Zoro­babel xuanicán Sala­tiel, xtla̠t Sala­tiel xuanicán Neri, ");
INSERT INTO tocNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","xtla̠t Neri xuanicán Melqui, xtla̠t Melqui xuanicán Adi, xtla̠t Adi xuanicán Cosam, xtla̠t Cosam xuanicán Elma­dam, xtla̠t Elma­dam xuanicán Er, ");
INSERT INTO tocNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","xtla̠t Er xuanicán Josué, xtla̠t Josué xuanicán Eliezer, xtla̠t Elie­zer xuanicán Jorim, xtla̠t Jorim xuanicán Matat, ");
INSERT INTO tocNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","xtla̠t Matat xuanicán Leví, xtla̠t Leví xuanicán Simeón, xtla̠t Simeón xuanicán Judá, xtla̠t Judá xuanicán José, xtla̠t José xuanicán Jonán, xtla̠t Jonán xuanicán Elia­quim, ");
INSERT INTO tocNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","xtla̠t Elia­quim xuanicán Melia, xtla̠t Melia xuanicán Mainán, xtla̠t Mainán xuanicán Matata, xtla̠t Matata xuanicán Natán, ");
INSERT INTO tocNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","xtla̠t Natán xuanicán David, xtla̠t David xuanicán Isaí, xtla̠t Isaí xuanicán Obed, xtla̠t Obed xuanicán Booz, xtla̠t Booz xuanicán Salmón, xtla̠t Salmón xuanicán Naasón, ");
INSERT INTO tocNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","xtla̠t Naasón xuanicán Ami­nadab, xtla̠t Ami­nadab xuanicán Aram, xtla̠t Aram xuanicán Esrom, xtla̠t Esrom xuanicán Fares, xtla̠t Fares xuanicán Judá, ");
INSERT INTO tocNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","xtla̠t Judá xuanicán Jacob, xtla̠t Jacob xuanicán Isaac, xtla̠t Isaac xuanicán Abraham, xtla̠t Abraham xuanicán Taré, xtla̠t Taré xuanicán Nacor, ");
INSERT INTO tocNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","xtla̠t Nacor xuanicán Serug, xtla̠t Serug xuanicán Ragau, xtla̠t Ragau xuanicán Peleg, xtla̠t Peleg xuanicán Heber, xtla̠t Heber xuanicán Sala, ");
INSERT INTO tocNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","xtla̠t Sala xuanicán Cainán, xtla̠t Cainán xuanicán Arfaxad, xtla̠t Arfaxad xuanicán Sem, xtla̠t Sem xuanicán Noé, xtla̠t Noé xuanicán Lamec, ");
INSERT INTO tocNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","xtla̠t Lamec xuanicán Matu­salén, xtla̠t Matu­salén xuanicán Enoc, xtla̠t Enoc xuanicán Jared, xtla̠t Jared xuanicán Maha­la­leel, xtla̠t Maha­la­leel xuanicán Cainán, ");
INSERT INTO tocNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","xtla̠t Cainán xuanicán Enoc, xtla̠t Enoc xuanicán Set, xtla̠t Set xuanicán Adán, xtla̠t Adán huá Dios porque huá Adán xapu̠lh chixcú ti̠ tlá­hualh. ");
INSERT INTO tocNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Acxni̠ Jesús taakmu­nu­ko̠lh kálhi̠lh xli̠t­li­hueke Espíri­tu Santo y táca̠xli nac xquilhtú̠n kalh­tu̠­choko hua̠ntu̠ xuanicán Jordán y antá alh nac desierto anta­nícu ni̠ti̠ lama cris­tianos, porque chuná xma̠­lac­pu­hua̠­ni̠ma Espíri­tu Santo. ");
INSERT INTO tocNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Antá xla­ma̠chá ti̠puxam quilh­ta­macú sacstu y ni̠tu̠cu huá̠­yalh, pero acxni̠ tzú­culh tzincsa. ");
INSERT INTO tocNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Minchá akska­huiní y tzú­culh ta̠la̠­tzaksay y chiné huá­nilh: —Cumu para xli̠­ca̠na huix Xka­huasa Dios, pus chú la̠nchú catiya eé chí­huix y cali̠­ma̠­pek­sí̠­nanti xla­cata cax­ti­lá̠n­chahu cahuá. ");
INSERT INTO tocNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús chiné kálh­ti̠lh: —Nac xta­chu­huí̠n Dios hua̠ntu̠ tatzok­ta­hui­lani̠t nac li̠kalh­ta­huaka chiné huan: “Ni̠ luu caj xma̠n xtahuá cati­li̠­la­tá­ma̠lh cha̠tum chixcú, pus na̠ luu xla­ca­squinca nali̠­la­tama̠y a̠má xta­chu­huí̠n Dios hua̠ntu̠ xlá li̠ma̠­peksi̠y.” ");
INSERT INTO tocNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Aca­li̠stá̠n a̠má akska­huiní tá̠alh nac aktum lanca ke̠stí̠n y antá caj puntzú ma̠ucxilh­ni̠­ko̠lh xli̠­hua̠k lac­lanca pu̠ma̠­peksí̠n hua̠ntu̠ tahui­lá̠­nalh nac ca̠ti­yatni. ");
INSERT INTO tocNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Y antá a̠má akska­huiní chiné huá­nilh Jesús: —Xli̠­hua̠k u̠má lac­lanca pu̠ma̠­peksí̠n hua̠ntu̠ la̠nchú ucxílhpa̠t aquit qui­ma̠x­qui̠­cani̠t, y na̠chuná cka­lhi̠y li̠ma̠­peksí̠n y tla̠n nac­ma­ca­ma̠x­qui̠y hua̠nti̠ aquit chuná nac­lac­pu­huaniy. ");
INSERT INTO tocNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Pus para huix xqui­la­ka­ta­quilh­pu̠ta y xqui­la­ka­chix­cuhui cumu la̠ mim­pu̠­chiná hua̠k milá nahuanko̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pero Jesús chiné kálh­ti̠lh: —Huix akska­huiní luu xli̠­ca̠na cat­lahua li̠tlá̠n caquin­ta­ke̠­nu̠ni, porque nac xta­chu­huí̠n Dios hua̠ntu̠ tatzokni̠t nac li̠kalh­ta­huaka chiné huán: “Xma̠nhuá Mim­pu̠­china Dios cala­ka­chix­cuhui y caka­lha­káx­patti hua̠ntu̠ li̠ma̠­pek­si̠má̠n.” ");
INSERT INTO tocNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Y aca­li̠s­ta̠n­li̠túm a̠má akska­huiní tá̠alh Jesús nac xaca̠­chi­quí̠n Jeru­salén y antá ta̠ta­huá­calh nac xak­stí̠n xatorre lanca pu̠si­culan y chiné huá­nilh: —Pus para luu xli̠­ca̠na huix Xka­huasa Dios la̠nchú uú lhken capit hasta nac ca̠ti­yátni, ");
INSERT INTO tocNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","porque nac xta­chu­huí̠n Dios hua̠ntu̠ tatzok­ta­hui­lani̠t nac li̠kalh­ta­huaka chiné huan: Dios naca̠­ma̠­peksi̠y xán­geles la̠qui̠ nacuentaj­tat­la­huayá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Xlacán li̠huana̠ nata­li̠­chi­pa­pa̠x­toká̠n xmacancán la̠qui̠ min­tantú̠n ni̠para aktum chí­huix nali̠­ta­ka̠­hui̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús tuncán kálh­ti̠lh: —Pero na̠ luu mili̠­cá­tzi̠t pi̠ hua̠ntu̠ tatzok­ta­hui­lani̠t xta­chu­huí̠n Dios na̠ chiné huan: “Ne̠cxni caj chu­natá cali̠­kalh­ka­má̠­nanti Mim­pu̠­chiná Dios la̠qui̠ nat­la­huay hua̠ntu̠ huix laca­squina cat­lá­hualh min­ta­pa̠­xu­huá̠n hua̠ntu̠ ni̠para tzinú mini̠­niyá̠n.” ");
INSERT INTO tocNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pus cumu a̠má akska­huiní niaj cátzi̠lh túcu luu nati­li̠t­la­huaniy tatzaksá̠n Jesús pus huata mejor caj tatam­pú̠x­tulh y luu maka̠s quilh­ta­macú laca­tzá̠­lalh y niaj tzák­salh xla­cata nama̠t­la­hui̠y tala̠­ka­lhí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Acxni̠ Jesús qui̠­tás­pitli nac desierto alh nac Gali­lea, pero luu xli̠­ca̠na xka­lhi̠y xli̠t­li­hueke Espíri­tu Santo y cani̠huá lacaxtum nac xli̠­ca̠­lanca a̠má pu̠la­tama̠n xli̠­chu­hui̠­nancán xta­scújut hua̠ntu̠ xlá xca̠t­la­huay. ");
INSERT INTO tocNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","La̠ta nícu xlá xcha̠n xta­nu̠­ya̠chá nac xpu̠­si­cu­lancán judíos y antá xtzucuy ca̠ma̠­kalh­chu­hui̠ni̠y cris­tianos, y xli̠­pu̠tum hua̠nti̠ xta­kax­matniy luu xta­li̠­pa̠­xu­huay hua̠ntu̠ xuan. ");
INSERT INTO tocNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ni̠ li̠maka̠s quilh­ta­macú Jesús alh paxia̠lhnán nac Naza­ret huá a̠má xca̠­chi­quí̠n anta­nícu xlá cstac­ni̠­tanchá. Y a̠má quilh­ta­macú luu sábado acxni̠ ni̠ti̠cu cscuja judíos, xlá tánu̠lh nac xpu­si­cu­lancán cumu xlá luu chuná xli̠s­ma­ni̠ni̠t xtla­huay. Caj li̠puntzú tá̠yalh la̠qui̠ nali̠­kalh­ta­huakay xta­chu­huí̠n Dios hua̠ntu̠ tatzokni̠t nac li̠kalh­ta­huaka. ");
INSERT INTO tocNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Pus ma̠x­quí̠­calh mactum libro hua̠ntu̠ xtzokni̠t pro­feta Isaías, y acxni̠ ma̠la­ka­pí­tzilh luu antá ma̠nók­lhulh anta­nícu chiné tatzokni̠t: ");
INSERT INTO tocNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Xes­pí­ritu Dios huí nac qui­la­táma̠t, xlá qui­lac­sacni̠t la̠qui̠ nac­ca̠­li̠­xa­katli̠y hua̠nti̠ lak­li̠­ma̠x­kení̠n a̠má li̠pa̠­xúhu xasa̠sti xta­ma̠­ca­tzi̠ní̠n; na̠ luu huá qui­li̠­ma­ca­mini̠t la̠qui̠ nac­ca̠­huaniy pi̠ huí xlak­tax­tutcán hua̠nti̠ cumu la̠ tachí̠n tala­má̠­nalh caj xpa̠­la­cata xta­la̠­ka­lhi̠ncán, y na̠chuna li̠túm la̠qui̠ nac­ca̠­ma̠­la­ca­hua̠ni̠y hua̠nti̠ laka­tzí̠n tala­má̠­nalh, y la̠qui̠ tla̠n nac­ca̠­ma̠­lak­taxti̠y hua̠nti̠ tapa̠­ti̠­na­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Aquit luu qui­ma­ca­mini̠t la̠qui̠ nac­ca̠­maka­pa̠­xu­huay cris­tianos porque nac­ca̠­huaniy lácu Dios xli̠­ca̠na ca̠la­ka­lhamán. ");
INSERT INTO tocNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Acxni̠ li̠kalh­ta­hua­ka­ko̠lh a̠má tachu­huí̠n ma̠la­ka­chú­hualh libro y maca­má̠x­qui̠lh a̠má chixcú hua̠nti̠ antá xmak­ta̠­ya­ni̠nán nac pu̠si­culan y culucs táhui. Pero cumu xli̠­lhu̠hua cris­tianos hua̠nti̠ antá xta­hui­lá̠­nalh luu cacs xta­lak­la­ca̠ni̠t, ");
INSERT INTO tocNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","xlá tzú­culh ca̠ma̠­kalh­chu­hui̠ni̠y y chiné tzú­culh ca̠huaniy: —La̠nchú luu nac mila­ca­ti̠ncán kan­tax­tuni̠t eé xta­chu­huí̠n Dios hua̠ntu̠ aquit cca̠­li̠­kalh­ta­hua­ka­ni­ni̠tán. ");
INSERT INTO tocNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","La̠ta xli̠­pu̠tum cris­tianos hua̠nti̠ xta­kax­mat­ni­má̠­nalh xta­chu­huí̠n luu xli̠­ca̠na xta­la­kati̠y hua̠ntu̠ xlá xuan, y cacs xta­li̠­la­ca­huán porque a̠má xta­chu­huí̠n hua̠ntu̠ xlá xuan luu xli̠­ca̠na tla̠n. Pero maka­pi­tzí̠n luu caj xta­liaklhu̠­hua̠tnán y chiné xta­la̠­huaniy: —¿Lácu la̠ eé? ¿Lácu pi̠ ni̠ huá tamá xka­huasa José? ");
INSERT INTO tocNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús chiné ca̠huá­nilh a̠ma̠ko̠lh lac­chix­cu­huí̠n: —Aquit cca­tzi̠y pi̠ cha̠­ca­tzi̠ya hui­xinín naqui­la̠­hua­ni­yá̠hu a̠má tachu­huí̠n hua̠ntu̠ chiné huan: “Huix hua̠nti̠ tla̠n cuchi̠­nana pus na̠ cacu­chí̠­canti me̠cstu.” Y na̠chuna li̠túm naqui­la̠­hua­ni­pa­ra­yá̠hu: “Pus para xli̠­ca̠na ca̠t­la­hua­ni̠ta lac­lanca ta­scújut nac Caper­naum, pus chú na̠chuná cat­lahua uú nac min­ca̠­chi­quí̠n.” ");
INSERT INTO tocNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Xlá chu­nacú xchu­hui̠­nama y chiné ca̠huá­nilh: —Luu xli̠­ca̠na cca̠­hua­niyá̠n pi̠ ni̠para cha̠tum pro­feta hua̠nti̠ li̠chu­hui̠­nama xta­chu­huí̠n Dios luu xli̠­ca̠na li̠pa̠­huancán nac xca̠­chi­quí̠n a̠má xta­chu­huí̠n hua̠ntu̠ xlá qui­lhuama. ");
INSERT INTO tocNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Xa̠huachí luu caj cala­ca­pa̠s­táctit pi̠ na̠chuná akspú­lalh xamaká̠n pro­feta Elías acxni̠ uú nac quim­pu̠­la­ta­ma̠ncán Israel luu aktutu ca̠ta a̠íta̠t ni̠para tzinú milh si̠n y luu la̠n lalh tatzín­c­stat nac xli̠­ca̠­lanca eé pu̠la­tama̠n, y antá xta­la­má̠­nalh lhu̠hua lac­chaján hua̠nti̠ xca̠­ni̠­makani̠t xta̠­ko̠­lucán, xlacán luu li̠pe̠cua xta­pa̠­ti̠­má̠­nalh porque ni̠ xta­ka­lhi̠y hua̠ntu̠ nata­huay, ");
INSERT INTO tocNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","pero Dios ni̠tu̠ li̠ma̠­pék­si̠lh Elías xla­cata naán ca̠mak­ta̠yay a̠ma̠ko̠lh lac­chaján, pus huata Dios lak­ma­cá­cha̠lh Elías cha̠tum pusca̠t pu̠ni̠ná hua̠nti̠ xuilachá nac Sarepta lacatzú nac a̠má mákat ca̠chi­quí̠n hua̠ntu̠ hua­nicán Sidón. ");
INSERT INTO tocNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Na̠chu­na­li̠túm cala­ca­pa̠s­táctit acxni̠ xlama pro­feta Eliseo, anta­li̠túm nac Israel xta­la­má̠­nalh lhu̠hua cris­tianos hua̠nti̠ xca̠­ka­lhi̠y a̠má luu li̠xcáj­nit tzitzi hua­nicán lepra, pero a̠má Eliseo ni̠para cha̠tum ca̠ma̠­pác­salh a̠ma̠ko̠lh ta̠tat­laní̠n, pus huata xlá ma̠pác­salh cha̠tum chixcú xuanicán Naamán luu xala mákat ca̠chi­quí̠n hua̠ntu̠ hua­nicán Siria. ");
INSERT INTO tocNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Acxni̠ chuná takax­mat­ko̠lh a̠má tachu­huí̠n hua̠ntu̠ xlá xquilh­uama, a̠ma̠ko̠lh cris­tianos hua̠nti̠ xta­ta­nu̠­má̠­nalh nac xpu̠­si­cu­lancán judíos luu li̠pe̠cua tzú­culh tasi̠­tzi̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Huákaj tatá̠­yalh y tachí­palh Jesús, tále̠lh nac xqui­lhapá̠n ca̠chi­quí̠n la̠qui̠ antá nata­ma̠­kosuy nac talhpá̠n y la̠qui̠ chuná tla̠n nata­makni̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero Jesús ca̠mak­táx­tulh, xlá ca̠lak­sti̠­pa̠­tá­nu̠lh xli̠­lhu̠hua cris­tianos, antá ca̠ak­xtek­yá̠­hualh y alh. ");
INSERT INTO tocNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Aca­li̠stá̠n Jesús cha̠lh nac aktum ca̠chi­quí̠n hua­nicán Caper­naum, eé ca̠chi­quí̠n huá xta­pek­si̠niy a̠má pu̠la­tama̠n hua­nicán Gali­lea. Maktum quilh­ta­macú sábado acxni̠ hua̠k judíos tajaxa xlá alh ca̠ma̠­kalh­chu­hui̠ni̠y nac xpu̠­si­cu­lancán. ");
INSERT INTO tocNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Y pu̠tum xli̠­lhu̠hua cris­tianos hua̠nti̠ xta­kax­mat­ni­má̠­nalh luu cacs xta­li̠­la­ca­huán porque la̠ta túcu xlá xca̠­li̠­ma̠­kalh­chu­hui̠­ni̠ma chuná xca̠­huaniy cumu la̠ hua̠nti̠ xli̠­ca̠na kalhi̠y li̠ma̠­peksí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Anta­nícu pu̠tum xta­ta­mak­stokni̠t cris­tianos hua̠nti̠ xta­kax­mat­ni­má̠­nalh xta­chu­huí̠n Jesús na̠ antá xuí cha̠tum chixcú hua̠nti̠ xak­chi­pa­nini̠t xta­la­ca­pa̠s­tacni akska­huiní. Xlá chiné qui­lhá­nilh: ");
INSERT INTO tocNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Jesús xalac Naza­ret, ¿túcu xla­cata qui­la̠­li̠­pek­ta­nu̠­yá̠hu anta­nícu aquinín cla­ma̠­náhu? ¿Huix caj tani̠ta qui­la̠­ma̠s­pu­tu­yá̠hu? Cat­lahua li̠tlá̠n caqui­la̠­mak­xtekui y ni̠tu̠ caqui­la̠t­la­hua­níhu, porque aquit cla­ka­pasá̠n, xa̠huachí aquit cca­tzi̠y pi̠ huix hua̠nti̠ Dios lac­sacni̠t la̠qui̠ nas­cuj­na­niya. ");
INSERT INTO tocNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús kálh­ti̠lh a̠má xes­pí­ritu akska­huiní y chiné huá­nilh: —¡Cacs caquí­lhuanti, xa̠huachí camák­xtekti tamá chixcú! Amá akska­huiní ma̠s­nók­ni̠lh u̠n a̠má chixcú y li̠ca̠­tá­lalh nac ca̠ti­yatni y la̠ta pu̠tum xtaucxilh­má̠­nalh mac­táx­tulh a̠má chixcú pero ni̠para tzinú xma̠­ta­ka̠­hui̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Xli̠­pu̠tum cris­tianos tapé̠­cualh y chiné xta­la̠­huaniy: —¿Túcuya̠ li̠t­li­hueke cahuá kalhi̠y xta­chu­huí̠n? Pus tamá chixcú ca̠ma̠­peksi̠y xes­pi­ri­tucán akska­huiní y cumu xlá kalhi̠y li̠t­li­hueke xlacán tataxtuy. ");
INSERT INTO tocNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","La̠ta túcuya̠ ta­scújut xtla­huay Jesús cani̠huá xli̠­chu­hui̠­nancán xli̠­ca̠­lanca nac a̠má pu̠la­tama̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Acxni̠ Jesús qui̠­táx­tulh nac xpu̠­si­cu­lancán judíos alh nac xchic Simón. Pero xpu̠­ti­ya̠tzí Simón Pedro xta̠­tatlay luu palha lhcúya̠t xuani̠t, y tahuá­nilh Jesús xla­cata xlá cama̠t­lá̠n­ti̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesús lak­ta­la­ca­tzú­hui̠lh taquilh­pú̠­talh nac ca̠tu̠tzú anta­nícu xlá xmá y huá­nilh a̠má tajátat xla­cata camák­xtekli. Y xli̠­ca̠na a̠má lhcúya̠t pálaj mák­xtekli, a̠má pusca̠t la̠li̠­huán tá̠qui̠lh y xlá tzú­culh ca̠x­tla­huay xtahuá hua̠ntu̠ naca̠­ta̠­li̠­huay. ");
INSERT INTO tocNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Acxni̠ ko̠ta­nu̠­ko̠lh a̠má quilh­ta­macú xli̠­hua̠k cris­tianos hua̠nti̠ xta­hui­lá̠­nalh xta̠­tat­lacán ma̠squi ti̠pa̠­katzi tajátat hua̠ntu̠ xlacán xca̠­ka­lhi̠y pero hua̠k tali̠­mí­nilh anta­nícu xuí Jesús. Xlá ca̠liacchí­palh xmacán y pu̠tum hua̠k ca̠ma̠t­la̠n­ti̠­ko̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Pero na̠chuna li̠túm lhu̠hua ta̠tat­laní̠n xca̠­ma̠t­la̠nti̠y hua̠nti̠ xca̠akchi­pa­ni­ko̠ni̠t xta­la­ca­pa̠s­tac­nicán akska­huiní. Maka­pi­tzí̠n xes­pi­ri­tucán akska­hui­niní̠n acxni̠ xta­mac­tax­tuniy cha̠tum cris­tiano xtzucuy taca̠­tasay y chiné xta­huaniy: —¡Huix Xka­huasa Dios! Pero Jesús xca̠­ma̠­quilh­cacsay y ni̠ xca̠­ma̠x­qui̠y quilh­ta­macú nata­chu­hui̠nán porque xlacán xta­ca­tzi̠y pi̠ Jesús xli̠­ca̠na huá Cristo hua̠nti̠ xmini̠t ca̠lak­ma̠xtuy cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Acxni̠ xka­ka­ko̠lh a̠má tzi̠sní Jesús alh nac xqui­lhapá̠n a̠má ca̠chi­quí̠n anta­nícu luu ca̠tze̠k, pero cumu luu lhu̠hua cris­tianos hua̠nti̠ xta­pu­tza­má̠­nalh juerza talák­cha̠lh anta­nícu xlá xcha̠ni̠t y luu juerza xta­hua­ni­má̠­nalh xla­cata cata­chó­kolh antá y ni̠ caalh a̠laca­túnuj ca̠chi­quí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero Jesús chiné ca̠huá­nilh: —Pero na̠chuna li̠túm na̠ luu xla­ca­squinca aquit nacán ca̠li̠­xa­katli̠y xa̠maka­pi­tzí̠n cris­tianos hua̠nti̠ tahui­lá̠­nalh nac a̠laca­túnuj ca̠chi­quí̠n u̠má luu li̠pa̠­xúhu xta­chu­huí̠n Dios lácu xlá ma̠tzu­qui̠­putún xasa̠sti xta­péksi̠t nac ca̠quilh­ta­macú, porque luu caj huá tamá quin­ta­scújut qui­li̠­ma­ca­mini̠t Quin­tla̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Pus chuná Jesús xlat­la̠­huán xliakchu­hui̠­nam­pu̠lay xta­chu­huí̠n Dios xli̠­hua̠k nac xpu̠­si­cu­lancán judíos hua̠ntu̠ xta­hui­lá̠­nalh nac a̠ma̠ko̠lh lactzu̠ ca̠chi­quí̠n hua̠ntu̠ xca̠­ma̠­peksi̠y Gali­lea. ");
INSERT INTO tocNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Maktum quilh­ta­macú Jesús antá xla­ya̠chá xak­chu­hui̠­nama nac xquilhtú̠n pupunú hua­nicán Gene­saret, caj li̠puntzú tachilh lhu̠hua cris­tianos xlacán hasta tzú­culh talak­xqui­ti­ya̠­huay porque xta­kax­mat­putún xta­chu­huí̠n Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesús úcxilhli nac xquilhtú̠n pupunú pi̠ antá xta­hui­lá̠­nalh aktiy barco pero xpu̠­chi­nacán ni̠ti̠ xta­ta­ju̠­má̠­nalh, pus xlacán xta­la­ka­che­ke̠­má̠­nalh xtza̠lhcán. ");
INSERT INTO tocNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Antá xlá táju̠lh nac aktum barco, xpu̠­chiná a̠má barco xuanicán Simón y huá­nilh xla­cata cama̠­la­ka­ma­kát­li̠lh tzinú nac xquilhtú̠n. Y antá culucs táhui y tzú­culh ca̠ma̠­kalh­chu­hui̠ni̠y cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Acxni̠ ca̠ma̠­kalh­chu­hui̠­ni̠­ko̠lh chiné huá­nilh Simón: —Chú anta­nícu tlak xapu̠lhmá̠n huí chú­chut cali̠pi mibarco la̠qui̠ nama­ju̠­yá̠tit min­tza̠lhcán y nachi­pa­yá̠tit squi̠ti. ");
INSERT INTO tocNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón chiné kálh­ti̠lh: —Ma̠kalh­ta­hua­ke̠ná, tan­tas­ca­catá csa­ka­ju̠­nu­ma̠­náhu y ni̠tu̠cu a̠ cchi­pa­yá̠hu; pero cumu huix qui­la̠­hua­ni­ma̠­náhu pus nac­li̠­tzak­sa­yá̠hu nac­ma­ju̠­pa­ra­yá̠hu quin­tza̠lhcán. ");
INSERT INTO tocNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Acxni̠ tamá­ju̠lh tza̠lh, lhu̠hua squi̠ti tahua­cachá y a̠tzinú xuani̠t aya xta­la­cax­ti̠t­putún xtza̠lhcán caj la̠ta xli̠­tzinca squi̠ti. ");
INSERT INTO tocNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Xlacán tzú­culh tama­ca­huaniy xa̠maka­pi­tzí̠n xta̠s­qui̠­ti̠­na­ni̠ncán hua̠nti̠ xta­ta­ju̠­má̠­nalh nac aktum­li̠tum barco la̠qui̠ namincán ca̠mak­ta̠­yacán. Xlacán la̠li̠­huán talí̠­milh xbar­cucán y tali̠­ma̠­tzá­malh squi̠ti pa̠tiy barco, pero aya xta­lak­tzan­ka̠­putún nac chú­chut caj la̠ta xli̠­tzin­cacán. ");
INSERT INTO tocNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Acxni̠ Simón Pedro úcxilhli hua̠ntu̠ xtla­huani̠t laka­ta­tzo­kós­talh Jesús y chiné huá­nilh: —Quim­pu̠­chiná, luu cat­lahua li̠tlá̠n capit porque aquit luu xli̠­ca̠na mak­la̠­ka­lhi̠ná chixcú. ");
INSERT INTO tocNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Huá chuná li̠huán porque xlá xpe̠­cuaxni̠ni̠t na̠chuná xa̠maka­pi­tzí̠n xcom­pa­ñeros xta­pe̠­cuani̠t caj xpa̠­la­cata cumu ca̠li̠­ma̠­la­ca­huá̠­ni̠lh aktum lanca li̠cá̠cni̠t ta­scújut. ");
INSERT INTO tocNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Na̠chuná xta­pe̠­cuamá̠­nalh maka­pi­tzí̠n li̠tum xta̠s­qui̠­ti̠­naní̠n Simón Pedro hua̠nti̠ xca̠­hua­nicán San­tiago y Juan xca­maná̠n Zebedeo, pero Jesús chiné hua­nipá: —Ni̠ cape̠­cuántit porque chuná cumu hui­xinín saka­ju̠­nu­ná̠tit xla­cata nachi­pa­yá̠tit squi̠ti, la̠nchú aquit nac­ca̠­ma̠­si­yu­niyá̠n lácu naca̠­pu­tza­yá̠tit a̠ma̠ko̠lh cris­tianos hua̠nti̠ taaktzan­ka̠­ta­ma̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ama­ko̠lh saka­ju̠­nuní̠n acxni̠ talí̠­chilh xbar­cucán nac xquilhtú̠n pupunú pu̠tum la̠ta túcu xta­ka­lhi̠y hua̠k taak­xtek­huí­li̠lh y ta­sta̠­lá­nilh Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Maktum quilh­ta­macú acxni̠ Jesús xcha̠ni̠t nac aktum ca̠chi­quí̠n caj li̠puntzú chilh cha̠tum chixcú xlá xta­ja­tatlay y xka­lhi̠y aktum li̠pe̠­cuánit tzitzi hua­nicán lepra. Acxni̠ a̠má chixcú úcxilhli Jesús xlá lak­ta­la­ca­tzú­hui̠lh y laka­ta­tzo­kós­talh hasta nac ca̠ti­yatni, y chiné li̠ma̠aka­tzán­ke̠lh: —Quim­pu̠­chiná, para huix chuná laca­squina pus caqui­ma̠­pac­sani eé li̠xcáj­nit quin­tzitzi. ");
INSERT INTO tocNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesús li̠chí­palh xmacán nac xmacni a̠má chixcú y chiné huá­nilh: —Chuná cla­cas­quín, la̠n­chuj tuncán capacsti. Acxni̠ chuná huan­ko̠lh Jesús, a̠má chixcú tuncán pác­snilh xtzitzi. ");
INSERT INTO tocNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Aca­li̠stá̠n Jesús ma̠aka­pék­si̠lh a̠má chixcú la̠qui̠ ni̠ti̠cu nahuaniy lácu pacsli, pero chiné huá­nilh hua̠ntu̠ xlá xli̠t­lá­huat: —Caj xma̠nhuá tu̠ cuaniyá̠n, la̠li̠­huán calak­pimpi cha̠tum cura la̠qui̠ xlá naca­tzi̠y pi̠ niaj tu̠ kalhi̠yá̠n min­ta­játat, xa̠huachí cama̠xqui mili­mosna cumu la̠ tili̠­ma̠­pek­sí̠­nalh Moisés nata­ma̠sta̠y hua̠nti̠ nata­pacsa ti̠ xka­lhi̠ko̠y tamá tajátat, y la̠qui̠ chuná pu̠tum naca­tzi̠cán pi̠ xli̠­ca̠na aya pac­sni̠ta. ");
INSERT INTO tocNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero xli̠­ca̠­lanca nac a̠má pu̠la­tama̠n xtaakpun­tu­mi̠ma la̠ta xli̠­chu­hui̠­nancán xta­scújut Jesús, y luu lhu̠hua cris­tianos xta­lakmín la̠qui̠ nata­kax­matniy xta­chu­huí̠n y la̠qui̠ naca̠­ma̠t­la̠nti̠y hua̠nti̠ xca̠­ka­lhi̠y tajátat. ");
INSERT INTO tocNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pero Jesús anka­lhí̠n xca̠­ta­tam­pu̠x­tuniy y antá xan anta­nícu ni̠ti̠ lama cris­tianos la̠qui̠ chuná xlá tla̠n nakalh­ta­hua­kaniy Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Maktum quilh­ta­macú Jesús xca̠­ma̠­kalh­chu­hui̠­ni̠ma cris­tianos y na̠ antá xta­hui­la̠na maka­pi­tzí̠n fariseos chu xma̠­kalh­ta­hua­ke̠­nacán judíos, u̠ma̠ko̠lh lac­chix­cu­huí̠n xta­mi­ni̠­tanchá nac lactzu̠ ca̠chi­quí̠n hua̠ntu̠ xca̠­ma̠­peksi̠y Gali­lea chu Judea y hasta maka­pi­tzí̠n xta­mini̠t xalac Jeru­salén. Y caj la̠ta xca̠­ma̠t­la̠nti̠y ta̠tat­laní̠n Jesús pus antá xli̠­ta­siyuy xli̠­hua̠k xli̠­maka­tli­hueke Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Y na̠ acxni­tiyá tachilh maka­pi­tzí̠n lac­chix­cu­huí̠n xlacán xta­pu̠­le̠­má̠­nalh pu̠chexni cha̠tum chixcú porque xli̠­lanca xlu̠n­tu̠­hua­nani̠t y ni̠lay xtla̠­huán. Xlacán luu xta­ta­mac­nu̠­putún nac chiqui la̠qui̠ nata­li̠­chá̠n anta­nícu xuilachá Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero xlacán ni̠lay tatá­nu̠lh porque luu lhu̠hua xtza­macán nac má̠lacchi, huata tu̠ tat­lá­hualh la̠li̠­huán tata­huá­calh nac xak­stí̠n chiqui, tama̠­ta­ké̠­nu̠lh pek­stiy teja y antá talac­má̠c­ti̠lh xpu̠­chexni a̠má ta̠tatlá ma̠squi lhu̠hua xtza­macán, y luu antá xma̠­la­ka­tancs anta­nícu xuí Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Acxni̠ Jesús ca̠úcxilhli pi̠ luu xli̠­ca̠na xta­li̠­pa̠­huán pi̠ xlá tla̠n nama̠t­la̠nti̠y, chiné huá­nilh a̠má ta̠tatlá: —¡Amigo, la̠ta xli̠­hua̠k min­ta­la̠­ka­lhí̠n cma̠­tzan­ke̠­na­niyá̠n! ");
INSERT INTO tocNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pero a̠ma̠ko̠lh xma̠­kalh­ta­hua­ke̠­nacán judíos xa̠hua fariseos chiné tzú­culh talac­pu­huán: “¿Túcu xkásat tamá chixcú? Pus caj xta­chu­huí̠n li̠la­ca­ta̠­qui̠ma Dios, porque ni̠para cha̠tum cris­tiano anán hua̠nti̠ tla̠n nama̠­tzan­ke̠­na­ni̠nán tala̠­ka­lhí̠n, porque xma̠nhuá Dios tla̠n nama̠­tzan­ke̠­na­ni̠nán.” ");
INSERT INTO tocNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pero Jesús hua̠k xca­tzi̠y la̠ta túcu xlacán xta­lac­pu­hua­má̠­nalh, y chiné ca̠huá­nilh: —¿Túcu xpa̠­la­cata chuná la̠n­tamá hui­xinín li̠lac­pu­hua­ná̠tit? ");
INSERT INTO tocNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Qui­la̠­hua­níhu, ¿túcu a̠tzinú ni̠para tuhua ma̠kan­tax­ti̠cán, pi̠ acxni̠ nahua­niya cha̠tum ta̠tatlá: “Min­ta­la̠­ka­lhí̠n hua̠k cma̠tzanke̠naniyá̠n”, osuchí para nahua­niya: “La̠li̠­huán cata̠qui, y catlá̠huanti”? ");
INSERT INTO tocNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pus la̠nchú hui­xinín naca­tzi̠­yá̠tit pi̠ aquit Xata­lac­sacni Chixcú y qui­ma̠x­qui̠­cani̠t li̠ma̠­peksí̠n chu li̠maka­tli­hueke la̠qui̠ caj quin­ta­chu­huí̠n tla̠n nac­li̠­ma̠­tzan­ke̠­na­ni̠nán tala̠­ka­lhí̠n uú nac ca̠quilh­ta­macú. Pus xlá xakát­li̠lh a̠má chixcú hua̠nti̠ ni̠lay xtla̠­huán y chiné huá­nilh: —Huix cuanimá̠n, la̠li̠­huán cata̠qui, casacti mim­pu̠­chexni y capittá nac mín­chic. ");
INSERT INTO tocNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Amá chixcú laca­pálaj tá̠qui̠lh, sacli xpu̠­chexni hua̠ntu̠ xlá xlacma, y alh nac xchic xpa̠x­cat­ca­tzi̠­ni­ti̠­lhama Dios caj xpa̠­la­cata cumu xma̠t­la̠n­ti̠ni̠t, li̠pu̠tum hua̠nti̠ antá xta­yá̠­nalh hua̠k taúcxilhli. ");
INSERT INTO tocNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Cacs tala­ca­huan­ko̠lh y na̠ tzú­culh tapa̠x­cat­ca­tzi̠niy Dios, y cumu luu la̠n xta­pe̠­cuani̠t chiné tzú­culh tala̠­huaniy: —Xli̠­ca̠na la̠nchú ca̠ucxilh­ni̠­táhu lac­lanca li̠cá̠cni̠t xta­scújut Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Aca­li̠stá̠n Jesús táx­tulh nac a̠má chiqui, y la̠ta xtla̠­huama nac tiji xlá ma̠nók­lhulh cha̠tum chixcú hua̠nti̠ xca̠­ma̠­ta̠ji̠y cris­tianos la̠qui̠ nata­la­ka­xo­ko̠­nuniy gobier­no xalac Roma. Amá chixcú xuanicán Leví, antá xlá culucs xuí nac aktum chiqui anta­nícu luu xla­ka­xo­ko̠­nuncán. Jesús chiné huá­nilh: —Huix na̠ caquis­ta̠­lani. ");
INSERT INTO tocNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Amá Leví la̠li̠­huán suacaj tá̠yalh, pu̠tum la̠ta hua̠ntu̠ xlá xla­káhui akxte­kuili̠­ko̠lh y sta̠­lá­nilh Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Aca­li̠stá̠n Leví tlá­hualh nac xchic aktum pu̠pa̠xcua la̠qui̠ chuná nali̠­maka­pa̠­xu­huay Jesús, pero na̠chuná lhu̠hua xcom­pa­ñeros támilh hua̠nti̠ na̠ xta­ma̠­ta̠ji̠y cris­tianos nata­la­ka­xo­ko̠nún, y lhu̠hua maka­pi­tzí̠n cris­tianos hua̠nti̠ judíos xta­lac­pu­huán pi̠ hua̠k xta­lak­tzan­ka̠­ni̠ttá y ni̠tu̠cu xca̠­liucxilhcán, xlacán na̠ antá pu̠tum tamak­tahui nac mesa. ");
INSERT INTO tocNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pero a̠ma̠ko̠lh fariseos xa̠hua xma̠­kalh­ta­hua­ke̠­nacán judíos acxni̠ taúcxilhli pu̠tum hua̠nti̠ xlá xca̠­ta̠­hua̠­yama Jesús xlacán tzú­culh taaksán y chiné tahuá­nilh xta­ma̠­kalh­ta­huaké̠n Jesús: —¿Túcu xpa̠­la­cata hui­xinín ca̠li̠­ta̠­ta­lak­xtu­pi̠­yá̠tit y lac­xtum ca̠ta̠­hua̠­ya­ná̠tit tama̠­ko̠lh xma̠­ta̠­ji̠­naní̠n im­pues­tos xa̠hua tama̠­ko̠lh maka­pi­tzí̠n lac­lanca mak­la̠­ka­lhi̠­naní̠n lac­chix­cu­huí̠n? ");
INSERT INTO tocNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Pero cumu Jesús káx­matli hua̠ntu̠ xlacán xta­qui­lhuamá̠­nalh xlá chiné ca̠kálh­ti̠lh: —Ni̠tu̠ tamac­la­cas­qui­má̠­nalh doctor hua̠nti̠ tla̠n tala­má̠­nalh hua̠nti̠ ni̠tu̠ kalhi̠y tajátat, pus huata huá tamac­la­cas­quín doctor hua̠nti̠ tata̠­tatlay. ");
INSERT INTO tocNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Pus aquit ni̠ cmini̠t ca̠huaniy nata­lak­pali̠y xta­la­ca­pa̠s­tac­nicán hua̠nti̠ talac­pu­huán lacuán cris­tianos, pus huata huá cmini̠t ca̠ta­saniy hua̠nti̠ luu mak­la̠­ka­lhi̠­naní̠n la̠qui̠ aquit nac­ca̠­lak­ma̠xtuy. ");
INSERT INTO tocNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Xlacán chiné tahua­nipá: —¿Túcu xla­cata hua̠nti̠ xta­ma̠­kalh­ta­huaké̠n Juan Bau­tista xa̠hua xta­ma̠­kalh­ta­hua­ke̠ncán fariseos anka­lhí̠n takalh­xteknín y lhu̠hua tat­la­huay xora­ción li̠huaná̠ nata­la­ka­chix­cu­hui̠y Dios, pero chi̠nchú hua̠nti̠ huix min­ta­ma̠­kalh­ta­huaké̠n anka­lhi̠ná tahua̠­ya­má̠­nalh y ni̠ takalh­xteknín la̠qui̠ nata­la­ka­chix­cu­hui̠y Dios? ");
INSERT INTO tocNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús chiné ca̠kálh­ti̠lh: —¿Lac­pu­hua­ná̠tit hui­xinín pi̠ tla̠n nata­kalh­xteknín osuchí ni̠ nata­hua̠yán hua̠nti̠ ca̠pu­tza­cani̠t nac aktum pu̠ta­maka­xtokni, para antá ca̠ta̠­láhui a̠má kahuasa hua̠nti̠ tamaka­xtokma? ");
INSERT INTO tocNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero ámaj lak­chá̠n quilh­ta­macú acxni̠ nas­puta pu̠pa̠xcua y a̠má kahuasa nama̠­ta­pa̠­nu̠cán cumu la̠ aquit ámaj quiok­spulay y acxni̠ xlacán nata­kalh­xteknín ma̠squi ni̠ti̠ caca̠­li̠­ma̠­pék­si̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Na̠chu­na­li̠túm ca̠li̠­xa­kat­li̠pá u̠má takalh­chu­huí̠n la̠qui̠ naca̠­li̠­ma̠­la­ca­pu̠­tun­cu­hui̠niy hua̠ntu̠ xlá xca̠­hua­ni­putún, y chiné ca̠huá­nilh: —Ni̠para cha̠tum cris­tiano lama hua̠nti̠ xti̠ta mactum xasa̠sti lháka̠t la̠qui̠ nali̠­lak­tzapay mactum xala­kuán ves­tido, porque para chuná nat­la­huay caj nama̠­lak­tzanke̠y xala­kuán ves­tido, xa̠huachí a̠má xasa̠sti lháka̠t naactzu̠­huanán y luu ni̠tlá̠n cati­ta­sí­yulh hua̠ntu̠ nalak­tza­pacán. ");
INSERT INTO tocNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Na̠chu­na­li̠túm ni̠ti̠ pu̠maju̠y xas­kata pulque nac xala­kuán xmak­xu̠hua bor­rego, porque a̠má pulque natzucuy catlán y nama̠­pankay a̠má xala­kuán xu̠hua, pus caj nalak­tzanka̠y xu̠hua y na̠chuná pulque. ");
INSERT INTO tocNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pus huata xatlá̠n maju̠cán xas­kata pulque nac xasa̠sti xmak­xu̠hua bor­rego y chuná lac­xtum nata­ta̠­yaniy. ");
INSERT INTO tocNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Y na̠chuna li̠túm hua̠nti̠ li̠s­ma­ni̠ni̠t anka­lhi̠ná huay xacatla pulque pus aca­li̠stá̠n niaj hua­putún xas­kata pulque, y chiné huan: “Luu a̠tzinú tla̠n xacatla pulque.” ");
INSERT INTO tocNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Maktum quilh­ta­macú sábado xuani̠t acxni̠ hua̠k judíos xta­jaxa, Jesús xti̠­pun­tax­tuma anta­nícu luu la̠n xchan­cani̠t trigo, pero xta­ma̠­kalh­ta­huaké̠n tzú­culh tai̠ti̠­lhay xta­huácat, li̠huana̠ xta­lak­pekxa y xta­hua­ni̠niy xatalhtzi. ");
INSERT INTO tocNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Maka­pitzi fariseos taúcxilhli y chiné taka­lhás­quilh: —¿Túcu xla­cata hui­xinín ni̠tu̠cu liucxilh­ni̠­na­ná̠tit porque tla­hua­pá̠tit tamá ta­scújut acxni̠ pu̠tum cris­tianos xli̠­ja­xatcán? ");
INSERT INTO tocNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús ca̠kálh­ti̠lh: —¿Lácu pi̠ ne̠cxni a̠ li̠kalh­ta­hua­ka­yá̠tit hui­xinín hua̠ntu̠ tatzokni̠t nac li̠kalh­ta­huaka la̠ta lácu ti̠tax­tuni̠t xamaká̠n quilh­ta­macú, luu mili̠­ca­tzi̠tcán pi̠ maktum quilh­ta­macú acxni̠ rey David xa̠hua xcom­pa­ñeros xta­tzin­c­sni̠­má̠­nalh, ");
INSERT INTO tocNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","David xlá tánu̠lh nac lanca xpu̠­si­culan Dios y ca̠tí­yalh xata­si­cu­la­na̠t­láhu cax­ti­lá̠n­chahu y pu̠tum ca̠tá̠­hualh xcom­pa­ñeros ma̠squi a̠má cax­ti­lá̠n­chahu ni̠ xli̠­huatcán xuani̠t porque xma̠nhuá cura xca̠­mi­ni̠niy nata­huay? ");
INSERT INTO tocNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesús chiné ca̠hua­nipá a̠ma̠ko̠lh lac­chix­cu­huí̠n: —Y na̠chuná mili̠­ca­tzi̠tcán pi̠ aquit Xata­lac­sacni Chixcú cka­lhi̠y li̠ma̠­peksí̠n la̠qui̠ nac­ca̠­huaniy cris­tianos hua̠ntu̠ xli̠t­la­huatcán acxni̠ lak­cha̠ni̠t sábado acxni̠ hua̠k jaxcán. ");
INSERT INTO tocNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ni̠ xli̠­maka̠s li̠túm lak­cha̠mpá a̠má quilh­ta­macú sábado acxni̠ xli̠­huancán para tícu nas­cuja, Jesús tanu̠chá nac xpu̠­si­cu­lancán judíos, antá xlá tzú­culh ca̠ma̠­kalh­chu­hui̠ni̠y cris­tianos. Na̠ antá xta­nu̠ma cha̠tum chixcú hua̠nti̠ csca̠c­ni­ko̠ni̠t nac xas­tácat xmacán. ");
INSERT INTO tocNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Pero na̠ antá xta­nu̠­má̠­nalh maka­pi­tzí̠n fariseos xa̠hua xma̠­kalh­ta­hua­ke̠­nacán judíos xlacán xtas­ka­laj­má̠­nalh Jesús la̠qui̠ nataucxilha chicá para nama̠­pacsay a̠má chixcú acxni̠ xli̠­huancán para tícu nas­cuja y la̠qui̠ chuná huijá nahuán hua̠ntu̠ nata­li̠­ma̠­la­capu̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero cumu Jesús hua̠k xca­tzi̠y hua̠ntu̠ xlacán xta­la­ca­pa̠s­tac­má̠­nalh pus huá xpa̠­la­cata chiné li̠huá­nilh a̠má hua̠nti̠ csca̠c­ni­ko̠ni̠t xmacán: —¡Uú cata­la­ca­tzuhui! Amá chixcú la̠li̠­huán suácaj tá̠yalh y tala­ca­tzú­hui̠lh anta­nícu xlaya Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesús chiné ca̠huá­nilh maka­pi­tzí̠n cris­tianos: —Chú aquit la̠nchú camá̠n ca̠ka­lhas­quiná̠n aktum tachu­huí̠n: ¿Túcu puhua­ná̠tit tlak tla̠n tla­huacán sábado acxni̠ jaxcán? ¿Pi̠ hua̠ntu̠ tla̠n ta­scújut, osuchí hua̠ntu̠ ni̠tlá̠n? ¿Pi̠ tla̠n cahuá namak­ta̠­ya­yá̠hu para tícu luu mac­la­cas­quix­ni̠ma, osuchí ma̠squi ni̠ camak­ta̠­yáhu y ma̠squi cani̠lh? ");
INSERT INTO tocNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesús cacs ca̠la­caúcxilhli pu̠tum hua̠nti̠ antá xta­ta­nu̠­má̠­nalh nac a̠má pu̠si­culan, y aca­li̠stá̠n chiné huá­nilh a̠má chixcú: —Cas­tonkti mimacán. Amá chixcú chuná stonkli, y acxni­tiyá ca̠x­la­ní̠­nilh xmacán. ");
INSERT INTO tocNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pero a̠ma̠ko̠lh lac­chix­cu­huí̠n ni̠ tama̠t­lá̠n­ti̠lh y luu la̠n tasí̠­tzi̠lh y tzú­culh tala̠­huaniy para túcu cahuá tla̠n natat­la­huaniy Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ni̠ li̠maka̠s li̠túm maktum quilh­ta­macú Jesús alh nac aktum ke̠stí̠n la̠qui̠ antá nat­la­huay ora­ción, y tan­tas­caca antá kalh­ta­hua­ká­nilh Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Acxni̠ xka­ka­ko̠lh a̠má tzi̠sní Jesús ca̠ma̠­ké̠s­tokli pu̠tum hua̠nti̠ xta­sta̠­la­ni­má̠­nalh y acxni̠ pu̠tum támilh antá xlá ca̠lác­sacli kalha­cu̠tiy hua̠nti̠ ca̠li̠­ma̠­pa̠­cú­hui̠lh xapós­toles. ");
INSERT INTO tocNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ama̠­ko̠lh kalha­cu̠tiy após­toles hua̠nti̠ xlá ca̠lí̠lh­ca̠lh chiné xca̠­hua­nicán: Simón hua̠nti̠ Jesús li̠ma̠­pa̠­cú­hui̠lh Pedro; Andrés xta̠Simón; San­tiago y Juan; Felipe xa̠hua Bar­to­lomé; ");
INSERT INTO tocNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo chu Tomás; San­tiago xka­huasa Alfeo; Simón hua̠nti̠ xca̠­ta̠­ta­peksi̠y maka­pi­tzí̠n lac­chix­cu­huí̠n xca̠­hua­nicán cana­nistas; ");
INSERT INTO tocNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas hua̠nti̠ xta̠San­tiago; chu Judas hua̠nti̠ aca­li̠stá̠n liak­ska­huí­nalh Quim­pu̠­chi­nacán Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Acxni̠ Jesús tala­ka­ka­lhu̠­ta­hui­lachi nac a̠má ke̠stí̠n, pu̠tum ca̠tá̠­milh xta­ma̠­kalh­ta­huaké̠n nac aktum pu̠scan, pero lhu̠hua cris­tianos cani̠hua̠ xalaní̠n antá xta­mini̠t: maka­pi­tzí̠n xalac Judea, xalac Jeru­salén, xa̠hua hua̠nti̠ xta­la­má̠­nalh xquilhtú̠n pupunú nac a̠má ca̠chi­quí̠n hua̠ntu̠ xca̠­hua­nicán Tiro y Sidón. Ama̠­ko̠lh cris­tianos caj xta­mini̠t takax­matniy xta­chu­huí̠n y xa̠huachí la̠qui̠ naca̠­ma̠­pac­sa­nicán xta­ja­tatcán. ");
INSERT INTO tocNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jesús na̠ xca̠­ma̠t­la̠nti̠y xli̠­hua̠k hua̠nti̠ xca̠akchi­pa­nini̠t xta­la­ca­pa̠s­tac­nicán akska­huiní. ");
INSERT INTO tocNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Pero na̠chuna li̠túm cumu Jesús xka­lhi̠y li̠t­li­hueke nac xmacni xli̠­hua̠k cris­tianos xta­xa­ma­ni­putún clháka̠t, y a̠ma̠ko̠lh ta̠tat­laní̠n hua̠nti̠ tamac­xá­malh hua̠k tápacsli. ");
INSERT INTO tocNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Aca­li̠stá̠n Jesús cacs ca̠la­ca­cá̠c­ni̠lh pu̠tum xta­ma̠­kalh­ta­huaké̠n y chiné ca̠huá­nilh: —Luu li̠pa̠­xúhu caca̠­li̠­pu̠lh­ca̠­cántit hui­xinín hua̠n­ti̠cu lac­pobre porque chuná namaka­maklhti̠­na­ná̠tit pu̠tum hua̠ntu̠ Dios xlá ca̠li̠­ka­lhi̠má̠n y ca̠ma̠x­qui̠­pu­tuná̠n nac xta­péksi̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Li̠pa̠­xúhu caca̠­li̠­pu̠lh­ca̠­cántit hui­xinín hua̠nti̠ la̠nchú tzin­c­sta­makam­pá̠tit porque namín quilh­ta­macú acxni̠ hui­xinín la̠n naka­sá̠tit. ’Y na̠chuná luu li̠pa̠­xúhu caca̠­li̠­pu̠lh­ca̠­cántit hui­xinín hua̠nti̠ la̠nchú tasa­pá̠tit porque aca­li̠stá̠n luu la̠n nali̠­tzi­ya­ná̠tit. ");
INSERT INTO tocNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Luu li̠pa̠­xúhu hui­xinín camaklh­ca­tzí̠tit acxni̠ cris­tianos naca̠­si̠­tzi̠­niyá̠n, acxni̠ luu naca̠t­la­kax­tu­ca­ná̠tit nac aktum ca̠chi­quí̠n, acxni̠ cala̠huá naca̠­hua­ni­ca­ná̠tit y naca̠­lak­makan­ca­ná̠tit cumu lá̠m­para hua̠nti̠ luu lac­li̠xcáj­nit cris­tianos hui­xinín caj xpa̠­la­cata cumu luu qui­la̠­li̠­pa̠­hua­ná̠hu aquit Xata­lac­sacni Chixcú. ");
INSERT INTO tocNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Hui­xinín luu capa̠­xu­huátit a̠má quilh­ta­macú acxni̠ chuná naca̠t­la­hua­ca­ná̠tit y ni̠ cali̠­pu­huántit, porque nac akapú̠n hui­xinín naca̠­ma̠s­ka­hui̠­ca­ná̠tit; pus luu caj cala­ca­pa̠s­táctit pi̠ na̠chuná tatit­la­huani̠t xalak­maká̠n xli̠­ta­la­ka­pas­nicán u̠ma̠ko̠lh cris­tianos, la̠n tama̠­pa̠­tí̠­ni̠lh a̠ma̠ko̠lh pro­fetas hua̠nti̠ tica̠­ma­cá­milh Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Pero koxu­tacu tihua­ná̠tit hui­xinín hua̠nti̠ lac­rricu porque xma̠n huá uú nac ca̠quilh­ta­macú tla̠n luu li̠pa̠­xu­hua­yá̠tit min­tu­mi̠ncán, pero caj antiyá naqui̠­ta̠yay min­ta­pa̠­xu­hua̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Koxu­tacu tihua­ná̠tit hui­xinín hua̠nti̠ la̠nchú li̠pa̠­xu­hua­yá̠tit pi̠ kas­pá̠tit porque aca­li̠stá̠n natzin­csá̠tit. ’Koxu­taní̠n hui­xinín hua̠nti̠ la̠nchú li̠pa̠­xu­hua­yá̠tit pi̠ luu tla̠n li̠tzi­ya­ná̠tit porque aca­li̠stá̠n hui­xinín caj xpa̠­la­cata min­ta­li̠­pu­hua̠ncán la̠n nata­sa­yá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Koxu­tacu tihua­ná̠tit hui­xinín hua̠n­ti̠cu laka­ti̠­yá̠tit hua̠k luu lac­tlá̠n cris­tianos naca̠­li̠­pu̠lh­ca̠­ca­ná̠tit acxni̠ ni̠chuná li̠tax­tu­yá̠tit, porque cala­ca­pa̠s­táctit pi̠ hua̠nti̠ xalak­maká̠n mili̠­ta­la­ka­pas­nicán na̠chuná xta­li̠­pu̠lhca̠y a̠ma̠ko̠lh maka­pi­tzí̠n akska­hui­naní̠n pro­fetas. ");
INSERT INTO tocNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Xli̠­hua̠k hui­xinín hua̠nti̠ kax­pat­pá̠tit quin­ta­chu­huí̠n pus luu caaka­tá̠k­stit hua̠ntu̠ nac­ca̠­hua­niyá̠n: Hui­xinín luu caca̠­pa̠x­quí̠tit hua̠nti̠ ca̠si̠­tzi̠­niyá̠n, tla̠n caca̠­ca­tzi̠­nítit ma̠squi hua̠nti̠ ni̠ naca̠ucxilh­pu­tuná̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Luu ya̠ tapa̠­xu­huá̠n caca̠­xa­kat­lí̠tit hua̠nti̠ cala̠huá naca̠­hua­niyá̠n y cakalh­ta­hua­ka­nítit Dios la̠qui̠ camak­tá̠­yalh a̠má hua̠nti̠ naca̠­li̠­kalh­ka­ma̠­naná̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Para tícu huix nalak­xti̠­ka­xiyá̠n ni̠ cata­maka­pu̠s­pitni huata mejor calak­xti̠­pi­ni­para a̠lak­xti̠tu la̠qui̠ nalak­xti̠­ka­xi­pa­rayá̠n para luu chuná lac­pu­huán. Y na̠chuna li̠túm para tícu namak­lhti̠yá̠n min­cha­marra pus na̠ cama̠xqui quilh­ta­macú na̠ cale̠lh min­ta­maknu. ");
INSERT INTO tocNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","La̠tachá túcu nas­qui­niyá̠n cha̠tum cris­tiano, pus para kalhi̠ya cama̠xqui; y para tícu namak­lhti̠yá̠n hua̠ntu̠ milá ni̠ cali̠­huani. ");
INSERT INTO tocNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Pus laca­tancs cca̠­hua­niyá̠n pi̠ xlianka­lhi̠ná caca̠t­la­hua­nítit li̠tlá̠n xa̠maka­pi­tzí̠n cris­tianos chuná cumu la̠ hui­xinín xla­cas­quíntit xlacán xtat­la­huanín li̠tlá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Caqui­la̠­hua­níhu, para hui­xinín caj xma̠nhuá ca̠pa̠x­qui̠­yá̠tit hua̠nti̠ na̠ ca̠pa̠x­qui̠yá̠n, ¿túcu chú ya̠ li̠tlá̠n tla­hua­pá̠tit? Pus hasta ma̠squi hua̠nti̠ luu lac­li̠xcáj­nit xta­pu­hua̠ncán na̠chuná tat­la­huay. ");
INSERT INTO tocNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Osuchí para hui­xinín caj xma̠nhuá tlán ca̠ca­tzi̠­ni­yá̠tit hua̠nti̠ na̠ tla̠n ca̠ca­tzi̠­niyá̠n, ¿túcu chú ya̠ li̠tlá̠n tla­hua­pá̠tit? Pus na̠chuná tala̠­ta̠lay hua̠nti̠ luu lac­li̠xcáj­nit xta­pu­hua̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Na̠chu­na­li̠túm para hui­xinín xma̠nhuá ca̠ma̠­sa̠­cuani̠­yá̠tit tumi̠n hua̠nti̠ luu catzi̠­ni­yá̠tit pi̠ naca̠­la­ka­xo­ko­niyá̠n, ¿túcu chú ya̠ li̠tlá̠n tla­hua­pá̠tit? Pus na̠chuná xlacán tala̠­ma̠­sa̠­cuani̠y tumi̠n hua̠nti̠ luu lac­li̠xcáj­nit xta­pú­hua̠ncán porque laca­tancs catzi̠y pi̠ hui̠ntú nama̠x­qui̠cán aca­li̠stá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pero hui­xinín caca̠­pa̠x­quí̠tit ma̠squi hua̠n­ti̠cu luu ca̠si̠­tzi̠­niyá̠n y luu tla̠n caca̠­ca­tzi̠­nítit, y la̠ta túcu cama̠­sa̠­cuaní̠tit pero ni̠ huá cala­ca­pa̠s­tac­nítit para túcu luu naca̠­li̠­xo­ko̠­nu­ni­ca­ná̠tit. Pus chuná hui­xinín tla̠n namaka­maklhti̠­na­ná̠tit min­tas­kahucán nac akapú̠n, y Quin­tla̠­ticán Dios naca̠­li̠­pu̠lh­ca̠yá̠n cumu la̠ xli̠­ca̠na xca­maná̠n. Porque Dios luu tla̠n ca̠ca­tzi̠niy cris­tianos hasta ma̠squi hua̠nti̠ ne̠cxni tapa̠x­cat­ca­tzi̠niy hua̠ntu̠ xlá ca̠ma̠x­qui̠y, y na̠chuná hua̠nti̠ luu lac­li̠xcáj­nit xta­pu­hua̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Pus na̠chuná hui­xinín luu tla̠n caca̠­ca­tzi̠­nítit xli̠­hua̠k cris­tianos chuná cumu la̠ Min­tla̠­ticán Dios luu tla̠n ca̠ca­tzi̠niy cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Ne̠c­xnicú luu anka­lhi̠ná capu­tza­nítit xcuentajcán hua̠ntu̠ tla̠n nali̠­ya̠­hua­yá̠tit cha̠tum min­ta̠­cris­tiano la̠qui̠ aca­li̠stá̠n Dios na̠ ni̠chuná napu­tza­ni­ko̠yá̠n hua̠ntu̠ nali̠­ya̠­huayá̠n min­cuenta. Ni̠ anka­lhi̠ná caáksanti min­ta̠­cris­tiano para túcu ni̠tlá̠n tla­huama, la̠qui̠ Dios ni̠ hua̠k naaksa­ni­ko̠yá̠n xli̠­hua̠k hua̠ntu̠ huix tla­hua­ni̠ta ni̠tlá̠n. Cala̠­ma̠­tzan­ke̠­na­nítit la̠ta túcu ni̠tlá̠n la̠t­la­hua­ni­yá̠tit la̠qui̠ Dios na̠ naca̠­ma̠­tzan­ke̠­na­niyá̠n min­ta­la̠­ka­lhi̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Para cha̠tum min­ta̠­cris­tianojcán huí tu̠ mac­la­cas­quima y para huix kalhi̠ya pus cama̠xqui, y chuná Dios na̠ naca̠­ma̠x­qui̠yá̠n hua̠ntu̠ hui­xinín mac­la­cas­quim­pá̠tit. Xlá amá̠n ca̠pu̠­ma̠x­qui̠yá̠n hua̠ntu̠ lanca mim­bol­sajcán, la̠n naca̠aka­tzap­sya̠­hua­niyá̠n y naca̠­chi­qui­ju̠­niyá̠n, porque chuná la̠ta túcu xli̠­lhu̠hua nama̠x­qui̠­yá̠tit min­ta̠­cris­tianojcán acxni̠ túcu mac­la­cas­quima, Dios na̠chuná naca̠­ma̠x­qui̠yá̠n hua̠ntu̠ ca̠lak­cha̠ná̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús ca̠li̠­xa­kat­li̠pá aktum tala­ca­pa̠s­tacni y chiné ca̠huá­nilh: —¿Lácu hui­xinín lac­pu­hua­ná̠tit? ¿Pi̠ tla̠n cahuá cha̠tum laka­tzí̠n nape­ke­chi­palé̠n cha̠tum xta̠­la­ka­tzí̠n? ¿Lácu pi̠ ni̠ acxtum cahuá cati­ta­ta­mó­kosli para nataakchekxa anta­nícu ca̠li̠xcáj­nit? ");
INSERT INTO tocNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Na̠chu­na­li̠túm cha̠tum hua̠nti̠ kalh­ta­hua­ka­majcú ni̠lay a̠tzinú li̠huacay kalhi̠y xli̠s­ka­lala ni̠ xachuná hua̠nti̠ xma̠­kalh­ta­hua­ke̠ná, ma̠squi luu xli̠­ca̠na acxni̠ xlá nakalh­ta­hua­kako̠y a̠huayu xta̠­chuná naka­lhi̠y xli̠s­ka­lala cumu la̠ xma̠­kalh­ta­hua­ke̠ná. ");
INSERT INTO tocNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’Pus na̠chuná chú, ¿lácu chú tla̠n liucxilh­niya a̠má actzu̠ pokxni hua̠ntu̠ laca­ta­nu̠ma nac xla­kas­tapu cha̠tum min­ta̠­cris­tiano y para huata huix ni̠para tzinú maklh­ca­tzi̠ya para nac mila­kas­tapu laca­ta­nu̠má̠n tzinú tlak lanca quihui? ");
INSERT INTO tocNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Pus cumu ni̠para tzinú catzi̠ya para na̠ huí hua̠ntu̠ laca­ta­nu̠má̠n nac mila­kas­tapu, ¿lácu chú tla̠n li̠hua­niya cha̠tum min­ta̠­cris­tiano: “Caqui­ma̠xqui tala­cas­quín nac­la­ca­ma̠x­tuyá̠n tamá actzu̠ pokxni hua̠ntu̠ laca­ta­nu̠má̠n nac milakastapu”? ¡Pus huix luu aksa­ni̠ná chixcú! Huata xatlá̠n pu̠lh huix cala­ca­ma̠x­tú­canti hua̠ntu̠ laca­ta­nu̠má̠n nac mila­kas­tapu la̠qui̠ chuná luu li̠huana̠ naucxilha y chuná tla̠n nala­ca­ma̠x­tuya a̠má pokxni hua̠ntu̠ laca­ta­nu̠ma min­ta̠­cris­tiano. ");
INSERT INTO tocNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Pus na̠chuna li̠túm caj cali̠­la­ca­pa̠s­táctit xta­hua­catcán aka­tunu quihui: ni̠para akatum quihui anán hua̠ntu̠ luu xli̠­ca̠na tla̠n y para chú natzucuy tahuacay xta­huácat hua̠ntu̠ ni̠ lacuán; y ni̠para akatum quihui hua̠ntu̠ ni̠ xatlá̠n chú natzucuy tahuacay hua̠ntu̠ luu xala­cuán xta­huácat. ");
INSERT INTO tocNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Pus caj la̠ta aka­tunu quihui li̠ta­la­ka­pasko̠y xta­hua­catcán; porque ni̠para maktum tahuacay higo nac ca̠lh­tu­cuní̠n, ni̠para ca̠puxcán uvas nac ca̠kajní̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Pus na̠chuná chú cris­tianos: hua̠nti̠ tla̠n xta­pu­huá̠n cha̠tum chixcú pus huá li̠chu­hui̠nán hua̠ntu̠ lacuán tachu­huí̠n porque hua̠k huá huí nac xnacú; pero hua̠nti̠ ni̠tlá̠n xta­pu­huá̠n huá xlá li̠chu­hui̠nán hua̠ntu̠ luu lac­li̠xcáj­nit xta­chu­huí̠n porque hua̠k huá tu̠ li̠xcáj­nit huí nac xnacú. Porque hua̠ntu̠ li̠xcáj­nit huí nac xnacú cha̠tum chixcú juerza nali̠­chu­hui̠nán nac xquilhni. ");
INSERT INTO tocNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Túcu chú li̠ma­cuán caj min­quilh­nicán ma̠rí qui­la̠­hua­ni­yá̠hu, “Huix Quimpu̠chiná”, cumu para ni̠para tzinú tla­hua­yá̠tit hua̠ntu̠ aquit cca̠­li̠­ma̠­pek­si̠yá̠n? ");
INSERT INTO tocNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Chú nac­ca̠­hua­niyá̠n hua̠ntu̠ xta̠­chuná a̠má chixcú hua̠nti̠ quis­ta̠­laniy y tzaksay hua̠ntu̠ cuaniy: ");
INSERT INTO tocNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","pus luu xta̠­chuná qui̠­taxtuy cumu la̠ cha̠tum chixcú hua̠nti̠ tla­huay xchic, pu̠lh huáx­nalh pu̠lhmá̠n y li̠huana̠ li̠lak­xket­yá̠­hualh chí­huix xta­la­yá̠hu y acxni̠ stacli luu xali̠­pe̠cua kalh­tu̠­choko a̠má chiqui ni̠para tzinú lac­pa̠­lé̠nca, pus ni̠lay nala­ca­chi­quiy cumu hua̠k chí­huix xli̠­lak­xtek­ya̠­huani̠t xta­la­yá̠hu. ");
INSERT INTO tocNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero na̠ tahui­la̠­nampá maka­pi­tzí̠n cris­tianos hua̠nti̠ na̠ takax­mata hua̠ntu̠ cuan pero cumu ni̠ talak­tzaksay, xlacán luu xta̠­chuná qui̠­taxtuy cumu la̠ a̠má chixcú hua̠nti̠ tlá­hualh xchic y ni̠para tlak pu̠lhmá̠n ma̠tí̠­ju̠lh xta­la­yá̠hu, pero acxni̠ milh luu xali̠­pe̠cua si̠n, stacli kalh­tu̠­choko a̠má chiqui talak­pon­ka­tá̠­yalh y niaj para huá tzinú tasí­yulh para antá xyá chiqui. ");
INSERT INTO tocNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Acxni̠ Jesús chuná ca̠ma̠­kalh­chu­hui̠­ni̠­ko̠lh a̠ma̠ko̠lh cris­tianos xlá la̠li̠­huán alh nac Caper­naum. ");
INSERT INTO tocNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Antá nac a̠má ca̠chi­quí̠n xlama cha̠tum capitán hua̠nti̠ xpux­cucán tropa; huá u̠má tropa xuí cha̠tum xta­sa̠cua hua̠nti̠ luu xpa̠x­qui̠y pero chú a̠má tasa̠cua luu xta̠­tatlay snún xuani̠t a̠huayu aya xni̠­putún. ");
INSERT INTO tocNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Acxni̠ a̠má tropa cátzi̠lh pi̠ ma̠rí xli̠­chu­hui̠­nancán hua̠ntu̠ xca̠t­la­huay xta­scújut Jesús xlá la̠li̠­huán ca̠má­ca̠lh maka­pi­tzí̠n lak­ko̠­lu­tzí̠n judíos la̠qui̠ nata­huaniy Jesús xla­cata luu cat­lá­hualh li̠tlá̠n calák­milh. ");
INSERT INTO tocNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ama̠­ko̠lh lak­ko̠­lu­tzi̠nni talak­ta­la­ca­tzú­hui̠lh Jesús y chiné tahuá­nilh: —Cat­lahua li̠tlá̠n calakpi, porque tamá xapuxcu tropa luu mini̠niy pi̠ namak­ta̠­yaya. ");
INSERT INTO tocNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Porque xlá luu akli̠­huán quim­pu̠­la­ta­ma̠ncán, y xa̠huachí xlá hasta ma̠t­la­huí̠­nalh aktum quim­pu̠­si­cu­lancán anta­nícu nala­ka­chix­cu­hui̠­na­ná̠hu aquinín judíos. ");
INSERT INTO tocNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesús tla̠n tlá­hualh hua̠ntu̠ tahuá­nilh y ca̠s­ta̠­lá­nilh. Pero acxni̠ aya xta­cha̠n­ti̠­lhayá nac chiqui, a̠má xapuxcu tropa ca̠má­ca̠lh maka­pi­tzí̠n xamigos la̠qui̠ chiné nata­huaniy Jesús: —Quim­pu̠­chi­nacán, xli̠­ca̠na huix luu tla̠n catzi̠ya pero aquit ni̠para tzinú qui­mi­ni̠niy nata­nu̠­ya̠pi nac quín­chic. ");
INSERT INTO tocNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Pus hasta luu caj huá xpa̠­la­cata ni̠ aquit ma̠n cla­kan­chá̠n. Para luu xli̠­ca̠na qui­mak­ta̠­ya­pu­tuna huata caj xma̠n cali̠­ma̠­pek­sí̠­nanti la̠qui̠ u̠má quin­ta­sa̠cua natat­la̠nti̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Porque hasta luu aquit cka­lhíy lac­lanca qui­na­puxcún hua̠nti̠ cca̠­ka­lha­kax­mata hua̠ntu̠ quin­ta­li̠­ma̠­peksi̠y, pero na̠chuná chú aquit na̠ tahui­lá̠­nalh quin­tropa hua̠nti̠ cca̠­ma̠­peksi̠y. Acxni̠ cuaniy cha̠tum: “Capimpi a̠nú”, xlá naán; y para cha̠tum nacuani­paray: “La̠li̠­huán uú catat”, xlá namín; y para túcu nac­li̠­ma̠s­cujuy cha̠tum quin­ta­sa̠cua xlá chuná nat­la­huay. Huá cli̠­hua­niyá̠n aquit cli̠­pa̠­huán min­ta­chu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Acxni̠ Jesús kax­mat­ko̠lh a̠má tachu­huí̠n cacs lacáhua y cacs ca̠la­caúcxilhli pu̠tum cris­tianos hua̠nti̠ xta­sta̠­la­ni­má̠­nalh y chiné ca̠huá­nilh: —Luu laca­tancs pi̠ la̠ta xli̠­ca̠­lanca eé xpu̠­la­tama̠n Israel nia̠ cma̠­nok­lhuy cha̠tum hua̠nti̠ luu xli̠­ca̠na naqui­li̠­pa̠­huán cumu la̠ qui­li̠­pa̠­huán eé chixcú. ");
INSERT INTO tocNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ama̠­ko̠lh lac­chix­cu­huí̠n hua̠nti̠ xca̠­ma̠­lac­scu­ju­cani̠t tatás­pitli nac xchic xapuxcu tropa, pero acxni̠ tácha̠lh taúcxilhli pi̠ aya xtat­la̠n­ti̠ni̠t a̠má ta̠tatlá. ");
INSERT INTO tocNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Aca­li̠stá̠n Jesús xama nac aktum ca̠chi­quí̠n hua­nicán Naín pu̠tum xca̠­ta̠ama xta­ma̠­kalh­ta­huaké̠n y na̠chuná xta­sta̠­la­ni­má̠­nalh lhu̠hua cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Acxni̠ aya xta­cha̠n­ti̠­lhay lacatzú nac ca̠chi­quí̠n úcxilhli pi̠ xamá̠­calh ma̠c­nu̠cán cha̠tum ni̠n. Hua̠nti̠ xtzí a̠má ni̠n pu̠ni̠ná xuani̠t, xa̠huachí a̠má pusca̠t caj luu xma̠n huá cha̠tum xka­huasa xuani̠t. Luu lhu̠hua cris­tianos nac xala a̠má ca̠chi­quí̠n xta­sta̠­la­ni­má̠­nalh a̠má pusca̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Acxni̠ Quim­pu̠­chi­nacán Jesús úcxilhli xli̠­ca̠na luu snu̠n laka­lhá­malh y chiné huá­nilh: —Ni̠ catasa. ");
INSERT INTO tocNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jesús tala­ca­tzú­hui̠lh anta­nícu xle̠­ma̠ca a̠má ca̠xa y xámalh; y hua̠nti̠ xta­cu­cani̠t tata­chó­kolh. Jesús xakát­li̠lh a̠má ni̠n y chiné huá­nilh: —Kahuasa, aquit cuanimá̠n: ¡Cala­cas­ta­cuánanti! ");
INSERT INTO tocNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Amá kahuasa hua̠nti̠ xni̠ni̠t táhui nac xca̠xa y tzú­culh chu­hui̠nán. Aca­li̠stá̠n Jesús qui̠­pe­ke­tí­yalh y maca­má̠x­qui̠lh xtzí. ");
INSERT INTO tocNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Acxni̠ hua̠k cris­tianos taúcxilhli hua̠ntu̠ tlá­hualh Jesús la̠n tape̠­cuáxni̠lh y tzú­culh tapa̠x­cat­ca­tzi̠niy Dios, maka­pi­tzí̠n chiné xta­huán: —Cha̠tum lanca tali̠­pa̠hu pro­feta quin­ca̠­lak­ma­ca­mi­ni̠tán Dios. Pero maka­pi­tzí̠n chiné xta­huán: —Dios mini̠t ca̠lak­ma̠xtuy xca­maná̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Y xli̠­hua̠k xli̠­ca̠­lanca nac xapu̠­la­tama̠n Judea catzí̠­calh hua̠ntu̠ Jesús xtla­huani̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan Bau­tista cátzi̠lh la̠ta xli̠­chu­hui̠­nancán xta­scújut Jesús porque huá xta­ma̠­kalh­ta­huaké̠n chuná xta­li̠­chu­hui̠nán. Xlá xta­núma nac pu̠la̠­chi̠n y ca̠ta­sá­nilh cha̠tiy hua̠nti̠ xca̠­ta̠­la­ta­pu̠­li̠ni̠t ");
INSERT INTO tocNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","y ca̠má­ca̠lh anta­nícu xla­ma̠chá Jesús la̠qui̠ nata­ka­lhas­quín para luu xli̠­ca̠na huá Cristo hua̠nti̠ xli̠­mínit xuani̠t, osuchí nati­ta­ka­lhi̠ycú para namincú a̠cha̠tum. ");
INSERT INTO tocNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ama̠­ko̠lh lac­chix­cu­huí̠n acxni̠ talák­cha̠lh Jesús chiné taka­lhás­quilh: —Quin­ca̠­ma­ca­mimá̠n Juan Bau­tista la̠qui̠ nac­ca̠­ka­lhas­quiná̠n para mat xli̠­ca̠na huix Cristo hua̠nti̠ namín quin­ca̠­lak­ma̠x­tuyá̠n, o nati­mincú aca­li̠stá̠n hua̠nti̠ luu xax­li̠­ca̠na Cristo. ");
INSERT INTO tocNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Hua­tiyá a̠má quilh­ta­macú acxni̠ xlacán tachilh, xlacán xtaucxilh­má̠­nalh la̠ta Jesús xca̠­ma̠t­la̠n­ti̠ma lhu̠hua ta̠tat­laní̠n, y na̠chuná hua̠nti̠ xta­si­pa̠­ni̠­ko̠ni̠t xa̠hua hua̠nti̠ xca̠­maka­tla­jani̠t xta­la­ca­pa̠s­tacni xes­pí­ritu akska­huiní, y chu­na­li̠túm la̠ xca̠­ma̠­la­ca­hua̠­ni̠ma lhu̠hua laka­tzí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Acxni̠ taucxilh­ko̠lh xta­scújut Jesús pus ca̠huá­nilh hua̠nti̠ luu xta­ca­tzi̠­putún y chiné ca̠huá­nilh: —La̠li̠­huán capim­pítit y cali̠­ta̠­chu­hui̠­nántit Juan hua̠ntu̠ hui­xinín ucxílhtit y hua̠ntu̠ kax­páttit. Luu hua̠k cali̠­ma̠­kalh­chu­hui̠­ní̠tit pi̠ hua̠nti̠ laka­tzí̠n xta­la­má̠­nalh chú tla̠n tala­ca­hua̠nán, y hua̠nti̠ lu̠ntu xuani̠t hua̠k tla̠n tat­la̠­huán. Hua̠nti̠ xca̠­ka­lhi̠y a̠má lac­li̠xcáj­nit tzitzi hua­nicán lepra chú hua̠k tapac­smá̠­nalh, na̠chuná hua̠nti̠ aka­ta̠pa xta­la­má̠­nalh hua̠k tla̠n takax­mata, y hasta maka­pi­tzí̠n hua̠nti̠ aya xta­ni̠ni̠t tala­cas­tac­uana­má̠­nalh nac ca̠li̠ní̠n, y hua̠nti̠ lak­li̠­ma̠x­kení̠n tala­má̠­nalh ca̠liakchu­hui̠­na­ni­má̠­calh xta­chu­huí̠n Dios hua̠ntu̠ naca̠­lak­ma̠x­tuniy xli̠s­tac­nicán. ");
INSERT INTO tocNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Pero na̠ cahua­nítit pi̠ luu li̠pa̠­xúhu nala­tama̠y a̠má chixcú hua̠nti̠ ni̠ naqui­lac­la­ta̠yay acxni̠ aya catzi̠y tícu aquit. ");
INSERT INTO tocNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Acxni̠ taanko̠lh a̠ma̠ko̠lh lac­chix­cu­huí̠n hua̠nti̠ Juan Bau­tista xca̠­ma­ca­mini̠t, Jesús tzú­culh li̠chu­hui̠nán Juan y chiné ca̠huá­nilh cris­tianos: —Qui­la­hua­níhu, ¿túcu qui̠ucxílhtit hui­xinín acxni̠ qui̠­látit nac desierto? ¿Lácu pi̠ qui̠ucxílhtit hui­xinín cha̠tum chixcú hua̠nti̠ xta̠­chuná cumu la̠ kantum ká̠ti̠t hua̠ntu̠ akxmu̠t­ya̠­huani̠t u̠n? ");
INSERT INTO tocNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Pus ni̠para huá qui̠ucxílhtit. ¿Túcu chi̠nchú qui̠ucxílhtit? ¿Osuchí qui̠ucxílhtit cha̠tum chixcú hua̠nti̠ luu lacuán lháka̠t ca̠lha­ka̠ni̠t? Porque mismo hui­xinín catzi̠­yá̠tit pi̠ hua̠nti̠ xalac­ta­pa­ra̠xlá y lacuán lháka̠t ca̠lhaka̠y y luu lak­li̠­la­káti̠t tata­siyuy pus xlacán antá tahui­lá̠­nalh nac xchiccán lac­lanca ma̠pek­si̠­naní̠n anta­nícu ca̠tlá̠n nata­la­tamá̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Bueno pero ¿túcu chi̠nchú luu qui̠­pu­tzátit? ¿Lácu pi̠ xuc­xilh­pu­tu­ná̠tit cha̠tum pro­feta? Para huá qui̠­pu­tzátit pus li̠huaca tla̠n porque aquit luu laca­tancs cca̠­hua­niyá̠n pi̠ xli̠­ca̠na tamá chixcú hua̠nti̠ hui­xinín qui̠ucxílhtit a̠tzinú tlak lanca ma̠x­qui̠­cani̠t xta­scújut ni̠ xahua la̠ xca̠­ma̠x­qui̠­cani̠t xtas­cu­jutcán xli̠­hua̠k xalak­maká̠n pro­fetas. ");
INSERT INTO tocNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Pus hua­tiyá tamá Juan Bau­tista hua̠nti̠ li̠chu­hui̠nán Dios nac xta­chu­huí̠n hua̠ntu̠ tatzok­ta­hui­lani̠t nac li̠kalh­ta­huaka anta­nícu chiné huan: Pu̠lh nac­macá̠n cha̠tum hua̠nti̠ napu̠­la­niyá̠n la̠qui̠ xlá naca̠x­tla­hua­ni­ti̠­lhayá̠n min­tiji. ");
INSERT INTO tocNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Luu xli̠­ca̠na aquit cca̠­hua­niyá̠n pi̠ la̠ta xli̠­pu̠tum pro­fetas hua̠nti̠ tita­qui̠­lachi nac ca̠quilh­ta­macú ni̠para cha̠tum anani̠t hua̠nti̠ a̠tzinú lanca xta­scújut xma̠x­qui̠­cani̠t cumu la̠ xla Juan Bau­tista; pero ma̠squi chuná chú, na̠ mili̠­ca­tzi̠tcán pi̠ cati̠hua̠ cris­tiano ma̠squi ni̠tu̠cu xkásat hua̠nti̠ Dios namaka­maklhti̠nán nac xasa̠sti xta­péksi̠t pus huata namaka­tla­ja­pa­racán Juan porque xlá a̠tzinú luu liactay naka­lhi̠y xta­scújut. ");
INSERT INTO tocNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","La̠ta xli̠­lhu̠hua cris­tianos hasta ma̠squi xma̠­ta̠­ji̠­naní̠n im­pues­tos hua̠nti̠ takax­mát­nilh xta­chu­huí̠n Juan y tala­cás­quilh pi̠ naca̠akmunuy, chuná tali̠­ma̠­sí­yulh pi̠ hua̠ntu̠ Dios xla­cas­quín xpa̠­la­ca­tacán snu̠n xlí̠lat. ");
INSERT INTO tocNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero a̠ma̠ko̠lh fariseos chu xma̠­kalh­ta­hua­ke̠­nacán judíos hua̠nti̠ ni̠ xta­la­cas­quín naca̠akmu­nucán xlacán ni̠ tama̠t­lá̠n­ti̠lh hua̠ntu̠ Dios xca̠­ma̠­lac­nu̠­nima. ");
INSERT INTO tocNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","—¿Túcu cahuá tla̠n nac­ca̠­ta̠­ma̠­lac­xtumi̠y u̠ma̠ko̠lh cris­tianos hua̠nti̠ ca̠lacchú quilh­ta­macú tala­má̠­nalh? Osuchí ¿túcu xta̠­chuná qui̠­taxtuy? ");
INSERT INTO tocNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Xlacán caj xta̠­chuná tali̠­taxtuy cumu la̠ a̠ma̠ko̠lh lactzu̠ camán hua̠nti̠ ni̠ taka­lha­kax­mat­ni̠nán y hua̠nti̠ ma̠rí taka­ma̠­nan­ta­huilay nac plaza y chiné taqui­lhaniy xcom­pa­ñe­roscán: “Pus ¿túcu luu lacas­qui­ná̠tit? Aquinín aya cca̠­li̠s­ko­li­ninín lí̠spek xtat­lak­nicán hua̠ntu̠ luu lac­li̠­pa̠­xúhu tan­tli̠ní̠n, pero hui­xinín ni̠ tan­tli̠­yá̠tit; cca̠­li̠­quilh­tli̠nín xaya̠ tali̠­pu­huá̠n taquilh­tlí̠n, pero hui­xinín ni̠ tasátit.” ");
INSERT INTO tocNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Pus luu xta̠­chuná tali̠­taxtuy u̠ma̠ko̠lh cris­tianos, porque qui̠­lachi Juan Bau­tista nac milak­sti̠­pa̠ncán, xlá luu xli̠s­ma­ni̠ni̠t xkalh­xteknín maka̠s quilh­ta­macú y ni̠para tzinú xuay cuchu, pero hui­xinín xuaná̠tit pi̠ xak­chi­pa­nini̠t xta­la­ca­pa̠s­tacni akska­huiní. ");
INSERT INTO tocNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ni̠ li̠maka̠s quilh­ta­macú cmimpá aquit Xata­lac­sacni Chixcú, aquit lac­xtum ctzú­culh ca̠ta̠­hua̠yán y ca̠ta̠­kotnún cris­tianos la̠qui̠ pu̠tum naca̠­ta̠­pa̠­xu­huay, pero huata chú hui­xinín huam­pa­ra­yá̠tit pi̠ mat luu lanca xakotni y mat caj luu xma̠nhuá cliaka­tiyún cla­ca­pa̠s­tacnán lácu nacua̠yán, xa̠hua mat hua̠k quiamigos cca̠t­la­huay hua̠nti̠ tama̠­la­ka­xo­ke̠nán im­pues­tos chu maka­pi­tzí̠n hua̠nti̠ mat luu mak­la̠­ka­lhi̠­naní̠n lac­chix­cu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero aquit cca̠­hua­niyá̠n pi̠ la̠ta huí xli̠s­ka­lala Dios, antá laca­tancs li̠ta­si­yuma xta­scújut nac xla­táma̠t hua̠nti̠ xli̠­ca̠na aka­ta̠ksma. ");
INSERT INTO tocNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Maktum quilh­ta­macú cha̠tum fariseo huá­nilh Jesús xla­cata caalh nac xchic la̠qui̠ antá nata̠­hua̠­ya­na̠chá; Jesús alh y acxni̠ cha̠lh xlá táhui nac mesa. ");
INSERT INTO tocNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na̠ antá nac a̠má ca̠chi­quí̠n xlama cha̠tum pusca̠t pero luu mak­la̠­ka­lhi̠ná xuani̠t. Acxni̠ xlá cátzi̠lh pi̠ Jesús xani̠t laka­pa­xia̠lhnán a̠má fariseo, a̠má pusca̠t la̠li̠­huán má̠ca̠xli pa̠tum lame̠ta xatlá̠n per­fume lí̠cha̠lh anta­nícu xuí Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Amá koxutá pusca̠t laka­ta­tzo­kós­talh nac xtantú̠n Jesús y tzú­culh laka­tasay caj la̠ta xta­li̠­pu­huá̠n, y la̠ta xta­sama xla­kax­tájat xli̠­lac­pa­xi̠ma y xchíxit xli̠­ma̠­lac­sca̠­cama, y tzú­culh tu̠tzu̠ca; y aca­li̠stá̠n li̠lac­tla­hua­pú̠x­tulh nac xlacni a̠má xatlá̠n per­fume. ");
INSERT INTO tocNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Amá fariseo hua̠nti̠ xla­kan­canít nac xchic xlá xuc­xilhma hua̠ntu̠ xtla­huama a̠má pusca̠t, chiné xlá laca­pá̠s­tacli: “Para xli̠­ca̠na cahuá Jesús huá Dios maca­mini̠t, xlá aya xcá­tzi̠lh tícuya̠ cris­tiano u̠má pusca̠t hua̠nti̠ ma̠rí tu̠xa­mama, porque tamá pusca̠t luu xmak­la̠­ka­lhi̠ná y cati̠­huaj chixcú ca̠xa­katli̠y.” ");
INSERT INTO tocNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Pero Jesús chiné huá­nilh a̠má fariseo: —Simón, huí actzu̠ tachu­huí̠n hua̠ntu̠ cuani­pu­tuná̠n. —Pus caqui­huani, ma̠kalh­ta­hua­ke̠ná —kalh­tí̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús chiné huá­nilh: —Maktum quilh­ta­macú xuí cha̠tum chixcú rico hua̠nti̠ xma̠­sa̠­cuani̠nán tumi̠n, y cha̠tiy lac­chix­cu­huí̠n xca̠­ma̠­sa̠­cuani̠ni̠t xtumi̠n; cha̠tum xla­ka­hui­lá­nilh akqui­tzis mi̠lh y cha̠tum xla­ka­hui­la­nipá aykqui­tzis ciento. ");
INSERT INTO tocNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pero cumu a̠ma̠ko̠lh lac­chix­cu­huí̠n ni̠tu̠ xta­li̠­xo­ko̠­nuni, a̠má rico ca̠ma̠­tzan­ke̠­ná­nilh y niaj ca̠ma̠­tá̠­ji̠lh. Chú huix caqui­huani, ¿xatícu cahuá a̠tzinú tlak napa̠x­qui̠y napa̠x­cat­ca­tzi̠niy a̠má chixcú caj xpa̠­la­cata ca̠ma̠­tzan­ke̠­ná­nilh? ");
INSERT INTO tocNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón chiné kálh­ti̠lh: —Aquit clac­pu­huán pi̠ ma̠x huá a̠má chixcú hua̠nti̠ a̠tzinú luu lhu̠hua xla­ka­hui­lá­nilh y ma̠tzan­ke̠­ná­nilh. —Simón, luu xli̠­ca̠na la̠ta huana —kálh­ti̠lh Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jesús cacs lak­lá­ca̠lh a̠má pusca̠t y chiné hua­nipá Simón. —Cumu la̠ huix ucxílhpa̠t u̠má pusca̠t, la̠ta aquit cti­ta­nu̠chi nac mín­chic huix ni̠para tzinú quin­ta̠s­quihua min­chú­chut la̠qui̠ nac­li̠­lak­chakán, pero xlá aya qui­li̠­lak­che­ke̠ni̠t xla­kax­tájat y qui­li̠­lac­xa­cani̠t xac­chíxit. ");
INSERT INTO tocNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Huix ni̠para tzinú lac­pú­huanti para naquin­tzu̠ca acxni̠ cchilh, pero la̠ta xlá tanu̠­ni̠­tanchi nac mín­chic tzu­cuni̠t qui­lac­tzu̠ca nac quin­tantú̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Huix ni̠tu̠ qui­liac­tla­huápa̠t aceite nac quiakxa̠ka, pero xlá qui­li̠­lac­tla­hua­pú̠x­tulh xala­cuán per­fume nac quin­tantú̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Pus huá xpa̠­la­cata cli̠­hua­niyá̠n pi̠ la̠ta xli̠­pu̠­lac­lhu̠hua hua̠ntu̠ xlá li̠ma̠­si­yuma xta­pa̠x­quí̠n pus na̠chuná li̠ta­si­yuma pi̠ la̠ta xli̠­lhu̠hua xta­la̠­ka­lhí̠n hua̠k ma̠tzan­ke̠­na­ni­cani̠t; pero hua̠nti̠ ni̠ luu lhu̠hua xta­la̠­ka­lhí̠n ma̠tzan­ke̠­na­nicán ni̠ luu lhu̠hua laka­lhamán y li̠pa̠x­cat­ca­tzi̠niy hua̠nti̠ ma̠tzan­ke̠­ná­nilh. ");
INSERT INTO tocNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jesús chiné huá­nilh a̠má pusca̠t: —Xli̠­hua̠k min­ta­la̠­ka­lhí̠n aquit cma̠­tzan­ke̠­na­niyá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Xli̠­hua̠k hua̠nti̠ antá xta­ma­kua̠ya­má̠­nalh nac mesa xlacán chiné tzú­culh tala̠­huaniy sac­stucán: —¿Tícuya̠ chixcú cahuá eé, pus hasta ma̠squi tala̠­ka­lhí̠n hua̠k tla̠n ma̠tzan­ke̠­na­ni̠nán? ");
INSERT INTO tocNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pero Jesús hua­nipá a̠má pusca̠t: —Luu xli̠­ca̠na cuaniyá̠n huix aya ma̠aka­pu̠­tax­ti̠­ni̠ta mili̠s­tacni porque qui­li̠­pa̠­hua­ni̠ta, pus la̠nchú luu li̠pa̠­xúhu capit nac mín­chic. ");
INSERT INTO tocNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Aca­li̠stá̠n Jesús alh lata­pu̠li̠y nac lactzu̠ ca̠chi­qui̠ní̠n hua̠ntu̠ xta­hui­lá̠­nalh nac a̠má pu̠la­tama̠n, xliakchu­hui̠­nam­pu̠lay lácu Dios xuili̠­putún xasa̠sti xta­péksi̠t nac ca̠quilh­ta­macú, y hua̠k xca̠­ta̠­la­pu̠lay xka­lha­cu̠­tiycán xapós­toles. ");
INSERT INTO tocNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Pero na̠ xca̠­ta̠­la­pu̠lay maka­pi­tzí̠n lac­chaján hua̠nti̠ xlá xca̠­ma̠­pac­sa­nini̠t xta­ja­tatcán, y maka­pi­tzí̠n xca̠­ma̠t­la̠n­ti̠ni̠t acxni̠ xca̠­mac­ta­nu̠ma xes­pí­ritu akska­huiní. Antá xmak­lat­la̠­huán María hua̠nti̠ xli̠­ma̠­pa̠­cu­hui̠cán Mag­da­lena, huá eé pusca̠t xmac­ta­nu̠ni̠t pu̠lac­tujún xes­pí­ritu akska­huiní, pero Jesús xmac­ma̠x­tuni̠t; ");
INSERT INTO tocNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","chu Juana hua̠nti̠ xpusca̠t xuani̠t Cusa, eé chixcú huá luu xta̠s­cuja gober­nador Herodes; xa̠hua Susana y lhu̠hua maka­pi­tzí̠n lac­chaján hua̠nti̠ xlacán xta­li̠­mak­ta̠­ya­ni̠nán la̠ta túcu xlacán xta­ka­lhi̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Cani̠hua̠ xalaní̠n cris­tianos tata­mac­xtú­mi̠lh la̠qui̠ nataucxilha Jesús, pero acxni̠ luu lhu̠­huatá xta­tas­tokni̠t xlá ca̠li̠­xa­kát­li̠lh aktum takalh­chu­huí̠n y chiné ca̠huá­nilh: ");
INSERT INTO tocNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Maktum quilh­ta­macú cha̠tum cha­na̠ná alh chan xatalhtzi xli̠­chánat. Acxni̠ xlá cxpu­yu­makama xli̠­chánat maka­pi­tzí̠n tata­ma̠chá nac tiji, pero cumu luu lhu̠hua cris­tianos xtat­la̠­huán la̠n talac­ta̠­yá­mi̠lh, y na̠ tamim­pa­rachá xlacán lactzu̠ spu̠n tasa­cuaqui̠­ko̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Maka­pi­tzí̠n xli̠­chánat tata­ma̠chá nac ca̠lak­chi­huixni, acxni̠ xlacán tápulhli ni̠ tata̠­yá­nilh pálaj tás­ca̠cli porque ni̠ xta­ka­lhi̠y chú­chut hua̠ntu̠ nata­li̠­kotnún la̠qui̠ tla̠n natas­taca. ");
INSERT INTO tocNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Maka­pi­tzí̠n xli̠­chánat tata­ma̠chá nac ca̠lh­tu­cuní̠n, pero acxni̠ xlá pulhli lhtucú̠n ma̠lan­ka̠­ko̠lh porque luu lhu̠hua a̠má lhtucú̠n hua̠ntu̠ tápulhli. ");
INSERT INTO tocNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pero maka­pi­tzí̠n xli̠­chánat tata­ma̠chá nac xatlá̠n tíyat, y acxni̠ tástacli a̠má tachaná̠n luu lhu̠hua tahuácalh xtahuacatcán, huí tu̠ xkalhi̠y hasta aktum ciento caj la̠ta akatum xaquihui. Acxni̠ huan­kó̠lh eé tachu­huí̠n Jesús chiné ca̠huá­nilh a̠ma̠ko̠lh cris­tianos: —¡Para hui­xinín kax­pat­pá̠tit quin­ta­chu­huí̠n pus caaka­tá̠k­stit hua̠ntu̠ cuani­putún! ");
INSERT INTO tocNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Caj li̠puntzú xta­ma̠­kalh­ta­huaké̠n Jesús taka­lhás­quilh túcu luu xuani­putún a̠má takalh­chu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Xlá chiné ca̠kálh­ti̠lh: —Hui­xinín xli̠­ca̠na pi̠ Dios ca̠ma̠­ca­tzi̠­ni̠­pu­tuná̠n la̠qui̠ naaka­ta̠k­sá̠tit la̠ta lácu xlá laca­pa̠s­tacni̠t nahuili̠y xasa̠sti xta­péksi̠t uú nac ca̠quilh­ta­macú, pero huá la̠ta xli̠­maka­pi­tzí̠n cris­tianos caj cca̠­ta̠­ma̠­la­cas­tucniy hua̠ntu̠ tzinú tuhua aka­ta̠k­scán pero hua̠ntu̠ xlacán tala­ka­pasa, pero ma̠squi cataúcxilhli hua̠ntu̠ nakan­taxtuy chu­na­tiyá nata­ta­mak­xteka cumu lá̠m­para ni̠tu̠ taucxilh­má̠­nalh, y acxni̠ nata­kax­matko̠y quin­ta­chu­huí̠n ni̠ti̠cu cati­taaká­ta̠ksli. ");
INSERT INTO tocNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Pus chú luu li̠huana̠ cuentaj cat­la­huátit, huá eé hua­ni­putún a̠má takalh­chu­huí̠n hua̠ntu̠ cca̠­huanín: Amá li̠chánat huá hua­ni­putún xta­chu­huí̠n Dios; ");
INSERT INTO tocNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","y a̠ma̠ko̠lh li̠chánat hua̠ntu̠ tata­ma̠chá nac tiji huá li̠tax­tuko̠y cris­tianos hua̠nti̠ takax­mata xta­chu­huí̠n Dios pero acxni̠ mina̠chá akska­huiní ma̠ta­pa̠­nu̠ko̠y a̠má tachu­huí̠n hua̠ntu̠ xuí nac xna­cujcán la̠qui̠ ni̠ nata­ca̠­najlay y chuná ni̠ nata­lak­taxtuy xli̠s­tac­nicán. ");
INSERT INTO tocNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Y a̠ma̠ko̠lh li̠chánat hua̠ntu̠ tata­ma̠chá nac ca̠chi­huixni huá tali̠­taxtuy a̠ma̠ko̠lh cris­tianos hua̠nti̠ takax­mata xta­chu­huí̠n Dios, luu xli̠­ca̠na aktum tapa̠­xu­huá̠n taca̠­najlay, pero cumu ni̠ lhu̠hua taka­lhi̠y xtan­káxe̠k y acxni̠ ca̠li̠­tzak­sacán para luu xli̠­ca̠na taca̠­najlay huata mejor caj taak­xtek­makán. ");
INSERT INTO tocNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Y a̠má li̠chánat hua̠ntu̠ tata­ma̠chá nac ca̠lh­tu­cuní̠n huá tali̠­taxtuy a̠ma̠ko̠lh cris­tianos hua̠nti̠ takax­mata xta­chu­huí̠n Dios, pero cumu chu­na­tiyá la̠ta xlacán tala­má̠­nalh y tzucuy taliaka­tiyún hua̠ntu̠ uú xala ca̠quilh­ta­macú para xtu­mi̠ncán osuchí la̠ta lácu xlacán a̠tzinú luu tla̠n tapa̠­xu­huay tamaklh­ca­tzi̠y, y chuná tali̠­ma̠­lan­kako̠y xta­ca̠­naj­latcán y ni̠tu̠cu tama̠sta̠y xta­hua­catcán. ");
INSERT INTO tocNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pero a̠ma̠ko̠lh li̠chánat hua̠ntu̠ tata­ma̠chá nac xatlá̠n tíyat pus xlacán huá tali̠­taxtuy a̠ma̠ko̠lh cris­tianos hua̠nti̠ luu xli̠­hua̠k xna­cujcán tali̠­ca̠­najlay xta­chu­huí̠n Dios, pero na̠chuna li̠túm luu maktum tali̠­tanu̠y pi̠ nata­ma̠­kan­taxti̠y y chuná tzucuy talak­tzaksay y cumu tla̠n xta­la­ca­pa̠s­tac­nicán pus chuná tali̠­ma̠sta̠y lhu̠hua xta­hua­catcán. ");
INSERT INTO tocNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Y na̠chuna li̠túm cumu la̠ hui­xinín catzi̠­yá̠tit, ni̠para cha̠tum anán cris­tiano hua̠nti̠ para la̠ nama̠­pasi̠y aktum li̠maksko chú la̠li̠­huán naliakpu­lon­kxuili̠y para túcu, osuchí para nata­ma̠cnu̠y nac xtampí̠n xpu̠­tama; pus huata mejor tu̠ nat­la­huay nahuili̠y anta­nícu ta̠lhmá̠n la̠qui̠ xli̠­hua̠k hua̠nti̠ nata­tanu̠y nac chiqui nataucxilha tax­káket. ");
INSERT INTO tocNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Y na̠chuna li̠túm ni̠tu̠cu anán para túcu caj tze̠k huí para ni̠ juerza naca­tzi̠cán, y na̠chuná para aktum tachu­huí̠n hua̠ntu̠ caj tze̠k huan­cani̠t ni̠ chu­natá cati­ta­mák­xtekli para ni̠ juerza ca̠la­kuá̠n nata­huilay. ");
INSERT INTO tocNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Pus huá cca̠­li̠­hua­niyá̠n, luu xli̠­ca̠na cuentaj cat­la­huátit hua̠ntu̠ la̠nchú cca̠­hua­nimá̠n porque hua̠nti̠ kalhi̠y tla̠n tala­ca­pa̠s­tacni a̠tzinú luu lhu̠hua nama̠x­qui̠­cancú, pero hua̠nti̠ luu ni̠para lhu̠hua tuncán kalhi̠y, namak­lhti̠­ko̠cán hasta ma̠squi xma̠nhuá hua̠ntu̠ xlá kalhi̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Caj li̠puntzú tachilh xtzí Jesús xa̠hua xli̠­ta­la­ka­pasni anta­nícu xlá xca̠­ma̠­kalh­chu­hui̠­ni̠ma cris­tianos, xlacán ni̠lay xta­ta­nu̠­ya̠chá porque luu lhu̠hua xtza­macán. ");
INSERT INTO tocNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Pero maka­pi­tzí̠n cris­tianos chiné tahuá­nilh Jesús: —Mintzí xa̠hua mili̠­ta­la­ka­pasni tapu­tzamá̠n porque mat tata̠­chu­hui̠­nam­pu­tuná̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesús chiné ca̠huá­nilh hua̠nti̠ antá xta­la­yá̠­nalh: —Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ xli̠­hua̠k cris­tianos hua̠nti̠ takax­mata xta­chu­huí̠n Dios y talak­tzaksay hua̠ntu̠ xlá ca̠li̠­ma̠­peksi̠y, pus xli̠­ca̠na huá tama̠­ko̠lh quintzí xa̠hua qui­na­ta̠lán. ");
INSERT INTO tocNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Maktum quilh­ta­macú Jesús ca̠ta̠­tá­ju̠lh xta­ma̠­kalh­ta­huaké̠n nac aktum barco porque xlá ca̠huá­nilh pi̠ xam­putún a̠li̠quilh­tu̠tu pupunú, y la̠li̠­huán tatá­ca̠xli y táalh. ");
INSERT INTO tocNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Pero acxni̠ xta­pa̠­ta­cut­má̠­nalh a̠má chú­chut Jesús lhta­ta­tá­ma̠lh nac barco. Y acxni̠ aya xta­la­qui­ta̠t­lani̠t pupunú luu palha u̠n tahui­lachi hasta tzú­culh taju̠y chú­chut y a̠tzinú xuani̠t aya xtas­tapay y xlak­tzan­ka̠­putún nac chú­chut. ");
INSERT INTO tocNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ama̠­ko̠lh xta­ma̠­kalh­ta­huaké̠n la̠li̠­huán táalh tama̠­la­ka­hua̠ni̠y Jesús y chiné tahuá­nilh: —¡Ma̠kalh­ta­hua­ke̠ná, chú xlá ama̠­náhu mu̠x­tu­yá̠hu! Jesús la̠li̠­huán tá̠qui̠lh y ca̠li̠­ma̠­pék­si̠lh a̠má u̠n chu pupunú xla­cata catá­cacsli; pu̠tum tacac­sko̠lh y hasta luu ca̠tzi­yanca huan­ko̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jesús chiné ca̠huá­nilh xta­ma̠­kalh­ta­huaké̠n: —¿Nícu chú huí min­ta­ca̠­naj­latcán cumu hui­xinín hua­ná̠tit pi̠ xli̠­ca̠na qui­la̠­li̠­pa̠­hua­ná̠hu? Pero cumu xlacán luu la̠n xta­pe̠­cuaxni̠ni̠t, cacs xta­li̠­la­ca­huán y sac­stucán chiné xta­la̠­ka­lhas­quín: —¿Tícu cahuá eé chixcú? Pus hasta ma̠squi u̠n xa̠hua pupunú ca̠ma̠­peksi̠y y xlacán hua̠k taka­lha­kax­mata. ");
INSERT INTO tocNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Acxni̠ tapa̠­ta­cut­ko̠lh pupunú tácha̠lh nac aktum ca̠chi­quí̠n hua­nicán Gerasa, luu xma̠­la­ka­tancs xta̠­la­kax­tokui Gali­lea. ");
INSERT INTO tocNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Acxni̠ Jesús tacutli nac barco la̠li̠­huán lák­milh cha̠tum chixcú antá xalá nac a̠má ca̠chi­quí̠n. Amá chixcú maka̠sá la̠ta xak­chi­pa­ni­ko̠ni̠t xta­la­ca­pa̠s­tacni xes­pí­ritu akska­huiní, xa̠huachí xlá ni̠ clha­ka̠nán y ni̠para maktum lacatum xta­huilay nac aktum chiqui huata mejor caj xca̠­ta­sa­ta­pu̠li̠y nac ca̠pú­sa̠ntu. ");
INSERT INTO tocNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Mak­lhu̠hua tatzák­salh cris­tianos xta­chi̠­hui­li̠­putún a̠má chixcú la̠qui̠ lacatum nata­huilay y xta­li̠­chi̠­huili̠y cadenas nac xca̠­macaní̠n xa̠hua nac xca̠­tan­tu̠ní̠n, pero cumu a̠má akska­huiní xma̠x­qui̠y xli̠t­li­hueke hua̠k xca̠­lac­putxa y mákat xtza̠lay antá xan nac desierto anta­nícu ni̠ti̠ lama cris­tianos. Acxni̠ xlá lák­cha̠lh Jesús xlá tuncán huá­nilh a̠má xes­pí­ritu akska­huiní xla­cata camák­xtekli a̠má chixcú, pero xlá laka­ta­tzo­kós­talh Jesús y chiné huá­nilh: —¿Túcu xpa̠­la­cata qui­la̠­pek­ta­nu̠­yá̠hu? Aquit cca­tzi̠y pi̠ huix Jesús xka­huasa lanca li̠cá̠cni̠t Dios, xa̠huachí huix caj qui­ma̠­pa̠­ti̠­ni̠­pu­tuna. Pus luu cat­lahua lanca li̠tlá̠n ni̠ caqui­ma̠­pa̠­ti̠ni. ");
INSERT INTO tocNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús chiné kalhás­quilh a̠má xes­pí­ritu akska­huiní: —¿Túcu hua­ni­cana? Xlá kalh­tí̠­nalh: —Quin­ca̠­li̠­ma̠­pa̠­cu­hui̠­caná̠n Legión. Huá chuná xlá li̠kalh­tí̠­nalh porque a̠má xes­pí­ritu akska­huiní luu clhu̠­huacán xta­huani̠t hua̠nti̠ xta­mac­ta­nu̠­má̠­nalh a̠má chixcú. ");
INSERT INTO tocNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ama̠­ko̠lh xes­pi­ri­tucán akska­huiní tas­quí­nilh li̠tlá̠n Jesús la̠qui̠ ni̠ naca̠­macá̠n nac pu̠pa̠tí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Antá lacatzú nac ke̠stí̠n xta­put­swa̠­yan­tla̠­huán lhu̠hua paxni, pus xlacán tahuá­nilh xla­cata caca̠­má̠x­qui̠lh quilh­ta­macú nata­mac­tanu̠y a̠ma̠ko̠lh paxni. Jesús ca̠má̠x­qui̠lh tala­cas­quín. ");
INSERT INTO tocNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ama̠­ko̠lh xes­pi­ri­tucán akska­huiní tamák­xtekli a̠má chixcú y huata huá tamac­tá­nu̠lh a̠ma̠ko̠lh paxni. Pero cumu a̠ma̠ko̠lh paxni luu la̠n tape̠­cuáxni̠lh antá xlacán pu̠tum táalh nac aktum talhpá̠n y tajic­suako̠lh nac pupunú. ");
INSERT INTO tocNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ama̠­ko̠lh lac­chix­cu­huí̠n hua̠nti̠ xta­mak­ta­kalh­má̠­nalh paxni acxni̠ xlacán taúcxilhli hua̠ntu̠ xlani̠t, caj la̠ta xta­pe̠­cuacán tokosú̠n tatzá̠­lalh y cati̠huá tzú­culh tata̠­li̠­chu­hui̠nán la̠ta tícu xlacán xta­ma̠­nok­lhuy nac ca̠tu­huá̠n xa̠hua nac ca̠chi­quí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Y lhu̠hua cris­tianos táalh taucxilha hua̠ntu̠ xqui̠­tax­tuni̠t. Acxni̠ xlacán tácha̠lh anta­nícu xlaya Jesús taúcxilhli pi̠ antá culucs xuí a̠má chixcú hua̠nti̠ xmac­ta­nu̠ma xes­pí­ritu akska­huiní; pero chú aya lacas­ta­lanca xuí y clha­ka̠­nani̠t. Pus acxni̠ xlacán taúcxilhli tape̠­cuánilh. ");
INSERT INTO tocNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Pero maka­pi­tzí̠n lac­chix­cu­huí̠n hua̠nti̠ xtaucxilhni̠t lácu xma̠t­la̠n­ti̠­cani̠t a̠má chixcú hua̠nti̠ xmaka­tla­jani̠t xes­pí­ritu akska­huiní, xlacán tzú­culh tali̠­ta̠­chu­hui̠nán. ");
INSERT INTO tocNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Pus huá xpa̠­la­cata a̠ma̠ko̠lh cris­tianos hua̠nti̠ xta­hui­lá̠­nalh nac a̠má ca̠chi­quí̠n hua­nicán Gerasa tas­quí­nilh li̠tlá̠n Jesús xla­cata cata­tam­pú̠x­tulh nac xpu̠­la­ta­ma̠ncán porque ma̠rí xta­pe̠­cuaniy. Jesús juerza táju̠lh nac barco y alh a̠laca­tunu. ");
INSERT INTO tocNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Amá chixcú hua̠nti̠ xmac­tax­tuni̠t xes­pí­ritu akska­huiní huá­nilh Jesús xla­cata camá̠x­qui̠lh tala­cas­quín na̠ na­sta̠­laniy, pero Jesús li̠ma̠­pék­si̠lh xla­cata cata­mák­xtekli y chiné huá­nilh: ");
INSERT INTO tocNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Huata mejor huix catás­pitti nac mín­chic y cati̠huá caca̠­li̠­ta̠­kalh­chu­huí̠­nanti lácu Dios laka­lha­ma­ni̠tán. Amá chixcú xlá alh y cati̠huá ca̠li̠­ta̠­kalh­chu­huí̠­nalh lácu Jesús xma̠­pac­sani̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Acxni̠ Jesús tacut­pa­rachá a̠li̠quilh­tu̠tu pupunú la̠ta xli̠­lhu̠hua cris­tianos, luu li̠pa̠­xúhu taqui̠­pá̠x­tokli porque xlacán aya xta­ka­lhi̠­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Na̠ acxni­tiyá chilh cha̠tum chixcu xuanicán Jairo, eé chixcú luu tali̠­pa̠hu xuani̠t y na̠ luu xca̠­pux­cuniy nac xpu̠­si­cu­lancán judíos hua̠ntu̠ xuí nac a̠má ca̠chi­quí̠n. Acxni̠ xlá lák­cha̠lh, laka­ta­tzo­kós­talh nac xtantú̠n Jesús y huá­nilh pi̠ cat­lá­hualh li̠tlá̠n calá­kalh nac xchic, ");
INSERT INTO tocNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","porque xuí caj xma̠n cha̠stum xtzuma̠t xlá cajcu akcu̠tiy ca̠ta xka­lhi̠y pero chú xta̠­tatlay y luu snu̠n xuani̠t a̠huayu aya xni̠­putún. Acxni̠ Jesús xla­ka­majá, luu lhu̠hua cris­tianos ta­sta̠­lá­nilh nac tiji y hasta xta­la̠­lak­xqui­ti­ti̠­lhay. ");
INSERT INTO tocNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Y na̠ antá csta̠­lama cha̠tum pusca̠t, pero xlá xka­lhi̠y aktum tajátat y ma̠rí cstaj­makama kalhni ma̠x cumu aya xle̠ma xliakcu̠tiy ca̠ta la̠ta xlá chuná xtzu­cuni̠t, y la̠ta xka­lhi̠y xtumi̠n aya xlac­tla­hua­mi̠­ko̠ni̠t caj la̠ta xta­cu­chi̠­má̠­nalh doc­tores; pero ni̠para cha̠­tumá tícu luu xma̠­pac­salhá. ");
INSERT INTO tocNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Amá pusca̠t xak­lhchá̠n tze̠k mini̠­nichá Jesús y xamá­nilh clháka̠t, acxni­tiyá tuncán tachó­kolh la̠ta xlá cstaj­makama kalhni. ");
INSERT INTO tocNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesús tachó­kolh y chiná kalhas­qui­ní̠­nalh: —¿Tícu xámalh qui­lháka̠t? Pero cumu ni̠para cha̠tum kalh­ta­si­yú­nilh para tícu xámalh, Pedro chu maka­pi­tzí̠n xcom­pa­ñeros chiné tahuá­nilh: —Ma̠kalh­ta­hua­ke̠ná, huix ucxílhpa̠t pi̠ luu ma̠rí tza­macán y la̠ta xli̠­lhu̠hua cris­tianos lacatum lacatum tatok­lhmá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pero Jesús chiné huá: —Pero huí cha̠tum hua̠nti̠ tze̠k qui­xá­malh porque aquit tla̠n cmaklh­cá­tzi̠lh pi̠ huí hua̠nti̠ cli̠­ma̠­pác­xalh qui­li̠t­li­hueke la̠nchú. ");
INSERT INTO tocNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Amá pusca̠t acxni̠ xlá cátzi̠lh pi̠ xma̠­nok­lhu­cani̠t la̠li̠­huán lak­ta­la­ca­tzú­hui̠lh, pero caj la̠ta xta­pe̠cua xlá clhpi­pi­ti̠­lhay laka­ta­tzo­kós­talh nac xla­catí̠n Jesús y talak­si­yú­nilh nac xla­ca­ti̠ncán xli̠­pu̠tum cris­tianos túcu xpa̠­la­cata xli̠­xa­ma­nini̠t clháka̠t; y huá­nilh pi̠ la̠ xamá­nilh clháka̠t tuncán tat­lá̠n­ti̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesús chiné huá­nilh: —Na̠na, huix aya tat­la̠n­ti̠­ni̠ta porque luu xli̠­ca̠na qui­li̠­pá̠­huanti, pus chú luu li̠pa̠­xúhu capit nac mín­chic. ");
INSERT INTO tocNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesús chu­nacú xchu­hui̠­nama acxni̠ chilh cha̠tum chixcú xlá antá minchá nac xchic Jairo, y chiné huá­nilh: —Huata ma̠x xatlá̠n niaj xma̠­maka­pali Quim­pu̠­chi­nacán, porque min­tzuma̠t aya ni̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pero Jesús káx­matli hua̠ntu̠ xqui­lhuama y chiné huá­nilh Jairo: —Huix luu xli̠­ca̠na caqui­li̠­pá̠­huanti y ni̠ capé̠­cuanti, porque a̠má min­tzuma̠t natat­la̠nti̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Acxni̠ tácha̠lh nac chiqui ni̠ti̠cu má̠x­qui̠lh tala­cas­quín na̠ pu̠tum tatanu̠y huata caj xma̠nhuá cata­tá­nu̠lh Pedro, San­tiago y Juan xa̠hua xtzí chu xtla̠t a̠má tzuma̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","La̠ta xli̠­lhu̠hua cris­tianos hua̠k xta­ta­sa­má̠­nalh y xta­li̠­pu­hua­má̠­nalh, pero Jesús chiné ca̠huá­nilh: —Ni̠ cata­sátit, porque tamá tzuma̠t ni̠tu̠ ni̠ma pus xlá caj lhta­tama. ");
INSERT INTO tocNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pero xlacán caj tali̠­li̠­tzí­yalh hua̠ntu̠ ca̠huá­nilh porque xlacán laca­tancs xta­ca­tzi̠y pi̠ xni̠ni̠t a̠má tzuma̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Acxni̠ cha̠lh anta­nícu xlá xmá a̠má tzuma̠t, xlá maca­chí­palh y palha chiné huá­nilh: —¡Tzuma̠t, la̠li̠­huán cata̠qui! ");
INSERT INTO tocNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Caj la̠ xakát­li̠lh, a̠má tzuma̠t lacas­ta­cuánalh y tuncán tá̠qui̠lh. Aca­li̠stá̠n Jesús ca̠huá­nilh pi̠ cama̠­huí̠­calh. ");
INSERT INTO tocNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Xtzí chu xtla̠t a̠má tzuma̠t caj luu cacs xta­li̠­la­ca­huán hua̠ntu̠ xtla­huani̠t, pero Jesús ca̠li̠­ma̠­pék­si̠lh xla­cata ni̠ti̠cu nata­li̠­ta̠­chu­hui̠nán hua̠ntu̠ xlá xtla­huani̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Maktum quilh­ta­macú Jesús ca̠ma̠­ké̠s­tokli kalha­cu̠tiy xapós­toles y ca̠ma­ca­má̠x­qui̠lh li̠t­li­hueke chu li̠ma̠­peksí̠n la̠qui̠ tla̠n nata­ma̠t­la̠nti̠y ti̠pa̠­katzi tajátat y na̠chuná hua̠nti̠ xca̠­mac­ta­nu̠ma xes­pí­ritu akska­huiní. ");
INSERT INTO tocNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Huá luu ca̠li̠­má­ca̠lh la̠qui̠ nata­liakchu­hui̠nán lácu Dios xma̠­tzu­qui̠­putún xasa̠sti xta­péksi̠t nac ca̠quilh­ta­macú, y la̠qui̠ nata­ma̠t­la̠nti̠y hua̠nti̠ tata­ja­tat­lako̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Acxni̠ nia̠ xtaán chiné ca̠huá­nilh: —Ni̠tu̠ cali̠­pítit hua̠ntu̠ namac­la­cas­qui­ná̠tit nac tiji cumu la̠ mili̠x­tokcán osuchí mimur­ralhcán, ni̠para hua̠ntu̠ nahua­yá̠tit, ni̠para tumi̠n. Caj xma̠n huá cali̠­pítit milha­ka̠tcán hua̠ntu̠ lha­ka̠­ni̠­tátit y ni̠ cali̠­pítit maca­tiyú̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Y anta­nícu nachi­pi­ná̠tit nac aktum ca̠chi­quí̠n capu­tzátit hui­xinín aktum chiqui anta­nícu nata­mak­xte­ká̠tit chu­natá la̠ nachi­pi­ná̠tit hasta acxni̠ natam­pa­ra­ya̠­pítit. ");
INSERT INTO tocNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Pero anta­nícu ni̠ naca̠­ma­ka­maklh­ti̠­nan­ca­ná̠tit la̠li̠­huán cata­cá̠xtit nac a̠má ca̠chi­quí̠n y acxni̠ natax­tu­yá̠tit caca̠­lac­tin­c­xcántit pokxni hua̠ntu̠ ca̠lac­ta­huacán nac min­tan­tu̠ncán la̠qui̠ chuná nataucxilha a̠ma̠ko̠lh cris­tianos pi̠ niaj min­cuentajcán para nata­lak­tzanka̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ama̠­ko̠lh dis­cí­pulos tatá­ca̠xli y lacaxtum táalh nac lactzu̠ ca̠chi­qui̠ní̠n xlacán xta­liakchu­hui̠­nam­pu̠lay xta­chu­huí̠n Dios lácu xlá xca̠­lak­ma̠x­tu­putún cris­tianos, y na̠chuná xta­ma̠t­la̠nti̠y cati̠huá hua̠nti̠ xca̠­ka­lhi̠y la̠tachá túcuya̠ tajátat. ");
INSERT INTO tocNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Maktum quilh­ta­macú a̠má gober­nador xuanicán Herodes cátzi̠lh la̠ta túcua xlá xli̠s­cujma Jesús, pero xlá ni̠ xca­tzi̠y xatúcu luu naca̠­najlay porque huí ti̠ xuan pi̠ mat Juan xla­cas­ta­cuanani̠t nac ca̠li̠ní̠n, ");
INSERT INTO tocNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","pero maka­pi­tzí̠n huí ti̠ xta­huán pi̠ mat huá pro­feta Elías xmim­pa­rani̠t nac ca̠quilh­ta­macú, y maka­pi­tzí̠n xta­huam­paray pi̠ mat tzanká tícuya̠ pro­feta hua̠nti̠ xta­la­má̠­nalh xamaká̠n quilh­ta­macú pero chú mat xlá xla­cas­ta­cuanani̠t nac ca̠li̠ní̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pero a̠má Herodes chiné xuan: —Pus ¿tícu cahuá tamá chixcú hua̠nti̠ huancán pi̠ mat luu ca̠t­la­huay lac­lanca y li̠cá̠cni̠t ta­scújut? Porque a̠má Juan Bau­tista aquit luu ma̠n cma̠­pix­chu­qui̠­nani̠t xak­xa̠ka. Y cumu Herodes ni̠ xla­ka­pasa Jesús luu juerza xla­ka­pas­putún. ");
INSERT INTO tocNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Acxni̠ a̠ma̠ko̠lh após­toles taqui̠­tás­pitli tzú­culh tali̠­ta̠­kalh­chu­hui̠nán Jesús la̠ta lácua xlacán taqui̠­táx­tulh, pero xlá laca­tunu cá̠le̠lh anta­nícu luu ca̠tzi­yanca y antá tácha̠lh lacatzú nac aktum ca̠chi­quí̠n hua­nicán Bet­saida. ");
INSERT INTO tocNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pero cumu la̠ta xli̠­lhu̠hua cris­tianos tacá­tzi̠lh nícu xama pu̠tum ta­sta̠­lá­nilh; Jesús luu li̠pa̠­xúhu ca̠xa­kát­li̠lh y tzú­culh ca̠li̠­ta̠­chu­hui̠nán lácu Dios xla­cas­quín cala­tá­ma̠lh cris­tianos nac xasa̠sti xta­péksi̠t hua̠ntu̠ xámaj huili̠y nac ca̠quilh­ta­macú, y la̠ta xli̠­pu̠tum hua̠nti̠ talák­milh ta̠tat­laní̠n xlá ca̠ma̠t­lá̠n­ti̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Acxni̠ aya tzú­culh ko̠tanu̠y a̠ma̠ko̠lh xka­lha­cu̠­tiycán após­toles talak­ta­la­ca­tzú­hui̠lh y chiné tahuá­nilh: —Antá la̠ uú hui­la̠­náhu ni̠tu̠cu ya̠ko̠lh lactzu̠ chiqui huata mejor caca̠­huani u̠ma̠ko̠lh cris­tianos cataalhá nac xchiccán osuchí anta­nícu tahui­lá̠­nalh lactzu̠ ca̠chi­qui̠ní̠n la̠qui̠ antá nata­mak­lak­tun­cu­huiy y antá nata­pu­tzay para túcu nata­huay. ");
INSERT INTO tocNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pero Jesús chiné ca̠huá­nilh: —Huata mejor hui­xinín caca̠­ma̠­huí̠tit. —Pero na̠ ni̠para aquinín ni̠tu̠ cka­lhi̠­yá̠hu lhu̠hua cax­ti­lá̠n­chahu caj xma̠n mac­qui­tzis xa̠hua tantiy squi̠ti, sola­mente para naca­na̠huá tama̠­hua­yá̠hu hua̠ntu̠ naca̠­ta̠­hua­yá̠hu u̠ma̠ko̠lh cris­tianos —takalh­tí̠­nalh xlacán. ");
INSERT INTO tocNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Huá chuná xlacán tali̠­huá­nilh porque luu lhu̠hua cris­tianos xuani̠t, ma̠x cumu akqui­tzis mi̠lh. Pero Jesús chiné ca̠huá­nilh xta­ma̠­kalh­ta­huaké̠n: —La̠li̠­huán caca̠­hua­nítit cris­tianos la̠qui̠ na̠ pu̠tunu tata­huilay para ya̠ ita̠tni ciento pu̠la­ca­tunu. ");
INSERT INTO tocNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Pus xlacán chuná tat­lá­hualh y pu̠tum tatáhui. ");
INSERT INTO tocNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesús tíyalh a̠má mac­qui­tzis cax­ti­lá̠n­chahu chu tantiy squi̠ti, láca̠lh nac akapú̠n, pa̠x­cat­ca­tzí̠­nilh Dios xpa̠­la­ca­tacán a̠ma̠ko̠lh cris­tianos, y acxni̠ ca̠lak­che­ke­ko̠lh ca̠ma­ca­má̠x­qui̠lh xdis­cí­pulos la̠qui̠ xlacán nata­ma̠akpi­tziniy cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Xlacán pu̠tum tahuá̠­yalh y la̠n tákasli; aca­li̠stá̠n tama̠­mac­xtu­mi̠pá hua̠ntu̠ aka­tá̠x­tulh, tama̠­tzá­malh pa̠cu̠tiy cana̠sta xata­lak­che­ke­tamá̠n cax­ti­lá̠n­chahu chu squi̠ti. ");
INSERT INTO tocNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Maktum quilh­ta­macú acxni̠ Jesús xani̠t kalh­ta­hua­kaniy Dios lacatum anta­nícu luu ca̠tza­yanca, y na̠ antá xta­ta̠­la­ya̠­nanchá xdis­cí­pulos, pero xlá chiné ca̠ka­lha̠s­quilh: —La̠ta xli̠­lhu̠hua cris­tianos hua̠nti̠ quin­taucxilha, ¿tícuya̠ chixcú aquit quin­ta­li̠­macá̠n? ");
INSERT INTO tocNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Xlacán chiné takálh­ti̠lh: —Huí ti̠ huan pi̠ mat huix Juan Bau­tista, maka­pi­tzí̠n tahuán pi̠ mat huix pro­feta Elías, pero maka­pi­tzí̠n tahuam­paray pi̠ a̠huayu mat huix tzanká tícuya̠ pro­feta hua̠nti̠ xta­la­má̠­nalh xamaká̠n quilh­ta­macú pero chú mat lacas­ta­cuanani̠t nac ca̠li̠ní̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—Bueno, pero chi̠nchú hui­xinín, ¿tícu luu lac­pu­hua­ná̠tit aquit? —ca̠ka­lhás­quilh Jesús. Pedro chiné kálh­ti̠lh: —Huix Cristo hua̠nti̠ maca­mini̠t Dios xla­cata naquin­ca̠­lak­ma̠x­tuyá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesús ca̠li̠­ma̠­pék­si̠lh xta­ma̠­kalh­ta­huaké̠n xla­cata ni̠ nata­li̠­chu­hui̠nán hua̠ntu̠ Pedro xuani̠t, ");
INSERT INTO tocNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","y chiné xlá ca̠hua­nipá: —Hui­xinín na̠ caca­tzí̠tit pi̠ aquit Xata­lac­sacni Chixcú xli̠­ca̠na pi̠ luu la̠n cámaj pa̠ti̠nán, y a̠ma̠ko̠lh lak­ko̠­lu­tzi̠nni judíos luu maktum xli̠­ca̠na naquin­ta­lak­makán xa̠hua xana­puxcun cura chu xma̠­kalh­ta­hua­ke̠­nacán judíos. Naqui­mak­ni̠cán, pero xliaktutu quilh­ta­macú aquit nac­la­cas­ta­cuanán nac ca̠li̠ní̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Aca­li̠stá̠n xpu̠­tumcán chiné ca̠huá­nilh: —Pus para tícu luu xli̠­ca̠na maktum quis­ta̠­la­ni­putún, capa̠­tzán­ka̠lh hua̠ntu̠ xlá xka­lhi̠y xta­la­ca­pa̠s­tacni y la̠ta cale̠nchá xcruz cha̠li cha̠lí y caquis­ta̠­lá­nilh hasta ma̠squi chuná tla̠n cali̠­ma­ca­má̠s­ta̠lh xla­táma̠t caj quim­pa̠­la­cata. ");
INSERT INTO tocNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Porque hua̠nti̠ lak­ma̠x­tu­putún xla­táma̠t uú nac ca̠quilh­ta­macú pus huata luu laca­tancs pi̠ ámaj ma̠lak­tzanke̠y; pero para tícu nama̠­lak­tzanke̠y xla­táma̠t caj quim­pa̠­la­cata huata xlá cha̠­ca­tzi̠ya ámaj lak­ma̠xtuy nac xla­catí̠n Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Pus chu­na­li̠túm, ¿túcu xli̠­ma­cuánilh cha̠tum cris­tiano para tla̠n xká­lhi̠lh la̠ta túcua anán nac ca̠quilh­ta­macú pero cumu para ámaj ma̠lak­tzanke̠y xla­táma̠t nac xla­catí̠n Dios? ");
INSERT INTO tocNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Pus na̠chuna li̠túm para tícu naqui­li̠­ma̠­xanán osuchí nali̠­ma̠­xanán quin­ta­chu­huí̠n, na̠chuná aquit Xata­lac­sacni Chixcú na̠ nac­li̠­ma̠­xanán acxni̠ nac­mim­paray cumu la̠ lanca rey, cli̠­mímaj nahuán xli̠­hua̠k xli̠­maka­tli­hueke Quin­tla̠­ticán Dios xa̠hua xán­geles. ");
INSERT INTO tocNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Luu xli̠­cána laca­tancs cca̠­hua­niyá̠n pi̠ maka­pi­tzí̠n cris­tianos hua̠nti̠ tala­má̠­nalh la̠nchú y hua̠nti̠ uú tala­yá̠­nalh, hasta nia̠ tani̠y nahuán acxni̠ xli̠­ca̠na nataucxilha lácu Dios ámaj huili̠y xasa̠sti xta­péksi̠t nac ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ma̠x cumu li̠tzi̠má quilh­ta­macú xla­ca­tza̠­lani̠t la̠ta chuná xca̠­ta̠­kalh­chu­hui̠­nani̠t Jesús ca̠ta̠­ta­la­cá̠c­xtulh kalha­tutu xta­ma̠­kalh­ta­huaké̠n nac aktum ke̠stí̠n la̠qui̠ antá nakalh­ta­hua­kaniy Dios, xma̠nhuá ca̠tá̠alh Pedro, San­tiago y Juan. ");
INSERT INTO tocNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Li̠huán xkalh­ta­hua­kama la̠ta nac xlacán luu xli̠­ca̠na túnuj huan­ko̠lh cumu lá̠m­para xlak­skoma, xa̠huachí la̠ta xli̠­lanca clháka̠t sna­papa huan­ko̠lh y luu sta­lanka. ");
INSERT INTO tocNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Acxni­tiyá talák­milh cha̠tiy lac­chix­cu­huí̠n hua̠nti̠ xta­ta̠­chu­hui̠­na­má̠­nalh, cha̠tum Moisés xuani̠t y cha̠tum pro­feta Elías. ");
INSERT INTO tocNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Anta­nícu xlacán xta­la­yá̠­nalh xca̠­li̠s­ti­lini̠t aktum li̠la­káti̠t tax­káket, huá xlacán xta­li̠­chu­hui̠­na­má̠­nalh la̠ta lácu xámaj pa̠ti̠nán Jesús nac Jeru­salén y la̠ta lácu xamá̠­calh mak­ni̠cán. ");
INSERT INTO tocNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ma̠squi Pedro chu xa̠maka­pi­tzí̠n luu xtalh­ta­ta­pu­tux­ni̠yá, juerza tala­ca­ta̠­yá­nilh porque xtaucxilh­má̠­nalh la̠ta lácu xka­lhi̠y li̠maka­tli­hueke Jesús xa̠hua xa̠maka­pi­tzí̠n hua̠nti̠ xta­ta̠­la­yá̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Acxni̠ a̠ma̠ko̠lh lac­chix­cu­huí̠n aya xtaamá̠­nalh, Pedro chiné huá­nilh Jesús: —Ma̠kalh­ta­hua­ke̠ná Jesús, ¡luu xali̠­huaca tla̠n pi̠ uú mac­xtum hui­la̠­náhu! Mejor u̠ctla­hua­yá̠hu aktutu lactzu̠ chiqui, aktum milá, aktum xla Moisés, y aktum xla Elías. Huá chuná xlá lí̠hua Pedro porque caj la̠ta xta­pe̠­cuaxni̠ni̠t ni̠ xca­tzi̠y túcu xqui­lhuama. ");
INSERT INTO tocNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Chu­nacú xchu­hui̠­nama acxni̠ minchá nac akapú̠n luu lanca puc­lhni hua̠ntu̠ ca̠akmi­li­ko̠lh; acxni̠ xlacán tacá­tzi̠lh pi̠ xta­ta­nu̠­má̠­nalh nac xlacni puc­lhni la̠n tapé̠­cualh. ");
INSERT INTO tocNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Y antá nac xlacni puc­lhni takáx­matli xta­chu­huí̠n Dios, chiné huá: —Huá eé Quin­ka­huasa hua̠nti̠ aquit cpa̠x­qui̠y, xma̠nhuá caka­lha­kax­pátit. ");
INSERT INTO tocNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Acxni̠ chuná takax­mat­ko̠lh a̠má tachu­huí̠n taúcxilhli pi̠ ca̠ta sacstu Jesús xla­ca­huáya. La̠ta laca­tzá̠­lalh quilh­ta­macú a̠ma̠ko̠lh dis­cí­pulos ni̠ti̠cu tali̠­ta̠­chu­huí̠­nalh hua̠ntu̠ xlacán xtaucxilhni̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Li̠cha̠li li̠túm acxni̠ taqui̠­tás­pitli nac a̠má ke̠stí̠n, luu lhu̠hua cris­tianos támilh tapa̠x­toka Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Y cha̠tum chixcú hua̠nti̠ antá xmak­mima luu palha tzú­culh qui­lhán y chiné huá­nilh Jesús: —Ma̠kalh­ta­hua­ke̠ná, luu xli̠­ca̠na cat­lahua li̠tlá̠n, camak­ta̠ya quin­ka­huasa porque caj xma̠n huá cha̠stum; ");
INSERT INTO tocNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","pero xes­pí­ritu akska­huiní akchi­pa­ni­ko̠ni̠t xta­la­ca­pa̠s­tacni, anka­lhí̠n maka­tasay, ma̠s­nokni̠y u̠n y tzucuy kalh­pupuy; anka­lhi̠ná chuná ma̠pa̠­ti̠­ni̠ma y ni̠ mak­xtekma. ");
INSERT INTO tocNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Aquit aya cca̠­huá­nilh min­ta­ma̠­kalh­ta­huaké̠n pi̠ cata­ta­mac­xtú­nilh tamá xes­pí­ritu akska­huiní pero xlacán ni̠lay tama̠­mak­xté­kelh. ");
INSERT INTO tocNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús chiné kalh­tí̠­nalh: —Koxu­taní̠n hui­xinín cris­tianos hua̠nti̠ ni̠ luu lay ca̠naj­la­yá̠tit pi̠ aquit cka­lhi̠y li̠t­li­hueke, ¿nícu acxni̠ luu nac­ti­ca̠­ta̠­pa̠­ti̠yá̠n la̠qui̠ hui­xinín tla̠n nat­la­hua­yá̠tit aktum ta­scújut? La̠li̠­huán huix cali̠ta min­ka­huasa. ");
INSERT INTO tocNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Acxni̠ a̠má kahuasa tzú­culh tala­ca­tzu­hui̠y, xes­pí­ritu akska­huiní li̠cá̠s­nokli nac ca̠ti­yatni y snokli u̠n, pero Jesús li̠ma̠­pék­si̠lh a̠má akska­huiní xla­cata camák­xtekli, y a̠má kahuasa tat­lá̠n­ti̠lh y chuná chú maca­má̠x­qui̠lh xtla̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","La̠ta xli̠­lhu̠hua cris­tianos tapa̠­xu­hua­ko̠lh porque xlacán xtaucxilhni̠t la̠ta tu̠ xka̠­lhi̠y xli̠­maka­tli­hueke Dios. Chu­nacú luu cacs xta­li̠­ta­mak­xtekni̠t la̠ta tu̠ xtla­huani̠t Jesús acxni̠ xlá chiné ca̠huá­nilh xta­ma̠­kalh­ta­huaké̠n: ");
INSERT INTO tocNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Luu li̠huana̠ cakax­páttit hua̠ntu̠ nac­ca̠­hua­niyá̠n y ne̠cxni napa̠­tzan­ka̠­yá̠tit, xla­cata pi̠ aquit Xata­lac­sacni Chixcú amá̠­calh qui­ma­ca­ma̠s­ta̠cán nac xla­ca­ti̠ncán hua̠nti̠ naquin­ta­makni̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero a̠ma̠ko̠lh xta­ma̠­kalh­ta­huaké̠n ni̠tu̠cu xtaaka­ta̠ksa hua̠ntu̠ xlá xca̠­hua­nima, cumu huá Dios nia̠ xca̠­ma̠x­qui̠y xta­la­ca­pa̠s­tacni hua̠ntu̠ nata­liaka­ta̠ksa, xa̠huachí xta­pe̠­cuaniy xla­cata nata­ka­lhas­quim­paray túcu luu xca̠­hua­ni­putún. ");
INSERT INTO tocNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Maktum quilh­ta­macú sac­stucán xta­ma̠­kalh­ta­huaké̠n Jesús tzú­culh tali̠­chu­hui̠nán xatícu cahuá a̠tzinú tlak tali̠­pa̠hu. ");
INSERT INTO tocNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Cumu Jesús cátzi̠lh hua̠ntu̠ xlacán xta­la­ca­pa̠s­tac­má̠­nalh, hua̠ntu̠ xlá tlá­hualh tasá­nilh cha̠tum actzu̠ kahuasa y antá yá̠hualh nac xpa̠xtú̠n, ");
INSERT INTO tocNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","y chiné ca̠huá­nilh: —Hua̠nti̠ nala­ka­lhamán cha̠tum actzu̠ kahuasa cumu la̠ eé y luu xli̠­ca̠na napa̠x­qui̠y caj xla­cata cumu catzi̠y pi̠ aquit cpa̠x­qui̠y, pus chuná li̠taxtuy cumu lá̠m­para aquit quim­pa̠x­qui̠ma, y na̠chuna li̠túm hua̠nti̠ aquit quim­pa̠x­qui̠y pus na̠chuná pa̠x­qui̠ma Dios hua̠nti̠ qui­ma­ca­mini̠t. Porque hua̠nti̠ ma̠t­la̠nti̠y pi̠ a̠tzinú luu ni̠tu̠cu xkásat nali̠­taxtuy nac milak­sti̠­pa̠ncán pus hua̠n­tamá a̠tzinú lanca y tlak tali̠­pa̠hu li̠taxtuy nac xla­catí̠n Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Caj li̠puntzú Juan chiné huá­nilh: —Ma̠kalh­ta­hua­ke̠ná, xacuc­xilh­ma̠­náhu cha̠tum chixcú hua̠nti̠ caj min­ta­cu­huiní xli̠­qui­lhán y tla̠n xca̠­ta­mac­xtuy xes­pí­ritu akska­huiní; pero cumu ni̠ acxtum quin­ca̠­ta̠­la­pu̠­layá̠n aquinín, pus cli̠­hua­níhu xla­cata niaj ti̠ cama̠­pác­salh. ");
INSERT INTO tocNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús chiné ca̠huá­nilh: —Ni̠ xti­li̠­hua­nítit, porque hua̠nti̠ quin­ca̠­maca­sta̠­layá̠n pus huata na̠ lakati̠y hua̠ntu̠ li̠s­cuj­ma̠­náhu. ");
INSERT INTO tocNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Acxni̠ aya xla­ca­tzu̠­hua­nama quilh­ta­macú la̠ta lácu Jesús xli̠ánat xuani̠t nac akapú̠n xlá ni̠para tzinú lak­lhpé̠­cualh, huata xlá kálhi̠lh li̠ca­mama y alh laka­ta̠yay nac Jeru­salén hua̠ntu̠ xlac­lhca̠­hui­li̠­ni­cani̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ca̠ma̠­la­ká­cha̠lh maka­pi­tzí̠n xlac­scujni la̠qui̠ nata­pu̠­laniy y nataán nac aktum actzu̠ ca̠chi­quí̠n hua̠ntu̠ xma̠­peksi̠y Samaria la̠qui̠ antá nata­pu­tzay nícu nata­lak­tun­cu­huiy. ");
INSERT INTO tocNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero a̠ma̠ko̠lh lac­chix­cu­huí̠n samari­tanos acxni̠ tacá­tzi̠lh pi̠ Jesús judío cumu xama nac Jeru­salén pus ni̠ tamá̠x­qui̠lh tala­cas­quín antá nata­lak­tun­cu­huiy nac xca̠­chi­qui̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Acxni̠ tacá­tzi̠lh lácu xta­kalh­ti̠­na­ni̠­tanchá a̠ma̠ko̠lh samari­tanos, San­tiago y Juan chiné tahuá­nilh Jesús: —Quim­pu̠­chi­nacán, ¿pi̠ laca­squina para nac­li̠­ma̠­pek­si̠­na­ná̠hu catá̠c­talh lhcúya̠t nac akapú̠n la̠qui̠ huá naca̠­ma̠s­putuy chuná cumu la̠ tit­lá­hualh pro­feta Elías? ");
INSERT INTO tocNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesús cacs ca̠la­caúcxilhli y ca̠la­ca­quí̠lh­ni̠lh porque chiné ca̠huá­nilh: —Koxu­taní̠n hui­xinín, ni̠para tzinú catzi̠­yá̠tit tícu luu scuj­ni­pá̠tit y ca̠ma̠x­qui̠yá̠n min­ta­la­ca­pa̠s­tac­nicán. ");
INSERT INTO tocNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Porque aquit ni̠ caj cmini̠t ca̠ma̠­lak­tzan­ke̠niy xli̠s­tac­nicán cris­tianos, pus huata caj cmini̠t ca̠lak­ma̠x­tuniy. Pus huata mejor tu̠ tat­lá­hualh táalh a̠laca­túnuj ca̠chi­quí̠n anta­nícu nata­ta­mak­xteka. ");
INSERT INTO tocNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Acxni̠ xtat­la̠­hua­má̠­nalh nac tiji, cha̠tum chixcú lák­milh Jesús y chiné huá­nilh: —Quim­pu̠­chiná, aquit na̠ csta̠­la­ni­pu­tuná̠n la̠tachá nícu huix napina. ");
INSERT INTO tocNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús chiné kálh­ti̠lh: —Xli̠­hua̠k hue̠kni hua̠ntu̠ tala­má̠­nalh nac ca̠qui­huí̠n taka­lhi̠y clhu­cucán anta­nícu talh­tatay, y lactzu̠ spu̠n na̠ taka­lhi̠y xma̠­se­kecán; pero aquit Xata­lac­sacni Chixcú ni̠tu̠ cka­lhi̠y anta­nícu nac­ma̠­jaxay quiakxa̠ka acxni̠ ctla­kuán. ");
INSERT INTO tocNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Caj li̠puntzú Jesús chiné huá­nilh cha̠tum chixcú: —Huix na̠ caquis­ta̠­lani. Pero xlá chiné kálh­ti̠lh: —Quim­pu̠­chiná, aquit na̠ nac­sta̠­la­niyá̠n pero caqui­ma̠xqui quilh­ta­macú hasta acxni̠ nani̠y quin­tla̠t la̠qui̠ nac­ma̠c­nu̠­ta̠­qui̠y y nac­sta̠­la­niyá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús chiné kálh­ti̠lh: —Caca̠­mák­xtekti hua̠nti̠ la̠ xaní̠n tala­má̠­nalh la̠qui̠ huá nata­ma̠cnu̠y xta̠­ni̠ncán, pero huix luu mini̠­niyá̠n naca̠­ma̠­kalh­chu­hui̠­ni̠ya cris­tianos naca̠­ma̠­ca­tzi̠­ni̠ya lácu Dios nama̠­tzu­qui̠y xasa̠sti xta­péksi̠t nac ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Cha̠tum chixcú na̠ chiné huá­nilh: —Quim­pu̠­chiná, aquit xlá luu xli̠­ca̠na csta̠­la­ni­pu­tuná̠n, pero caqui­ma̠xqui quilh­ta­macú pu̠lh nacán ca̠huaniy qui­li̠­ta­la­ka­pasni hua̠nti̠ tahui­lá̠­nalh nac quín­chic xla­cata pi̠ luu maktum tu̠ cama. ");
INSERT INTO tocNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús chiné huá­nilh: —Hua̠nti̠ laka­ta̠­ya­ni̠ttá xta­scújut hua̠ntu̠ Dios ma̠x­qui̠ni̠t, xlá ni̠ mini̠niy nalak­ca­tza­lacá̠n hua̠ntu̠ xli̠­lama xapu̠lh xla­táma̠t, porque pus chuná li̠taxtuy cumu la̠ ti̠ li̠pon­ka­nama arado, y para puntzu puntzú tala­kas­pita ni̠lay lacaxtum catís­cujli, cumu tunu tu̠ luu li̠ta̠­ka­tzan­ke̠­putún ni̠lay cati­ma̠­kan­táx­ti̠lh a̠má ta­scújut hua̠ntu̠ ma̠x­qui̠­cani̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Aca­li̠stá̠n Quim­pu̠­chi­nacán Jesús ca̠lác­sacli tutum­pu­xa­ma­cu̠tiy lac­chix­cu­huí̠n hua̠nti̠ luu xli̠­ca̠na xta­li̠­pa̠­huán, y ca̠má­ca̠lh li̠cha̠­tiyú̠n nac lactzu̠ ca̠chi­qui̠ní̠n anta­nícu xlá xliánat xuani̠t aca­li̠stá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Y chiné ca̠huá­nilh: —Xli̠­cána cca̠­hua­niyá̠n pi̠ u̠má min­tas­cu­jutcán xta̠­chuná li̠taxtuy cumu la̠ lanca li̠x­ká̠nat, pero huá chú ti̠ tas­cuj­má̠­nalh luu ni̠para tzinú clhu̠­huacán; huata mejor cas­qui­nítit Dios hua̠nti̠ xpu̠­chiná u̠má hua̠ntu̠ xali̠­má̠­qui̠t xla­cata xlá cama­cá­milh lhúhua xta­sa̠­cuá̠n la̠qui̠ hua̠k nama̠­mac­xtu­mi̠cán xlí̠xka̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Y chi̠nchú hui­xinín capítit anta­nícu cca̠­ma̠­la­ka­cha̠má̠n, pero na̠ caca­tzí̠tit pi̠ cca̠­ma­ca̠má̠n cumu la̠ lac­ma̠ntzu bor­regos nac xlak­sti̠­pa̠ncán lac­lanca hua­naní̠n coyotes. ");
INSERT INTO tocNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ni̠ cali̠­pítit mimur­ralhcán, ni̠para anta­nícu ma̠qui̠­yá̠tit min­tu­mi̠ncán, ni̠para min­tu̠­xu̠­huacán; y luu ti̠tum cachi­pítit anta­nícu pim­pá̠tit y ni̠tu̠ nata­cho­ko­yá̠tit nac tiji para tícu nata̠­chu­hui̠­na­ná̠tit. ");
INSERT INTO tocNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Acxni̠ nachi­pi­ná̠tit nac aktum chiqui anta­nícu hui­xinín nata­hui­la­yá̠tit y acxni̠ nata­nu̠­ya̠­pítit y naxa­kat­li̠­yá̠tit hua̠nti̠ xpu̠­chiná chiqui, chiné nahua­ni­yá̠tit: “Dios caca̠­si­cu­la­na̠t­la­huán hui­xinín hua̠nti̠ hui­látit nac eé chiqui.” ");
INSERT INTO tocNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Para nac a̠má chiqui tahui­lá̠­nalh hua̠nti̠ tla̠n natat­la­huay min­ta­chu­hui̠ncán pus xli̠­ca̠na Dios naca̠­si­cu­la­na̠t­la­huay chuná cumu la̠ hui­xinín naca̠­hua­ni­yá̠tit, pero para ti̠cu ni̠ tla̠n xta­pu­hua̠ncán huata mejor cama̠­ta­pa̠­nú̠tit a̠má tasi­cu­la­na̠t­láhu hua̠ntu̠ tali̠­chi­pítit. ");
INSERT INTO tocNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Anta­nícu tla̠n naca̠t­la­hua­ca­ná̠tit nac aktum chiqui, pus antá cata­mak­xtéktit, ni̠ lacatum lacatum capítit nac aka­tunu chiqui; y la̠ta túcu naca̠­ta̠­hua­ca­ná̠tit cahuátit hua̠ntu̠ xlacán taka­lhi̠y porque hua̠nti̠ scujma juerza lak­chá̠n pi̠ nas­ka­hualay. ");
INSERT INTO tocNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Acxni̠ nachi­pi­ná̠tit nac aktum ca̠chi­quí̠n anta­nícu naca̠­maka­maklhti̠­nan­ca­ná̠tit tla̠n cat­la­huátit la̠ta túcu naca̠­ta̠­hua­ca­ná̠tit. ");
INSERT INTO tocNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Hua̠k caca̠­ma̠t­la̠n­ti̠­ní̠tit ta̠tat­laní̠n hua̠nti̠ antá tahui­lá̠­nalh; y chiné caca̠­li̠­ma̠­kalh­chu­hui̠­ní̠tit cris­tianos: “Chú aya lak­cha̠ni̠t quilh­ta­macú la̠ta lácu Dios nama̠­tzu­qui̠y xasa̠sti xta­péksi̠t nac milak­sti̠­pa̠ncán.” ");
INSERT INTO tocNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero para nachi­pi­ná̠tit nac aktum ca̠chi­quí̠n y ni̠ naca̠­maka­maklhti̠­nan­ca­ná̠tit, la̠li̠­huán catax­tútit nac xca̠­ti­ji̠ní̠n a̠má ca̠chi­quí̠n la̠qui̠ hua̠k nata­kax­mata y chiné naca̠­hua­ni­yá̠tit: ");
INSERT INTO tocNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Xli̠­hua̠k hui­xinín caucxílhtit la̠ta lácu quin­ca̠­lac­tin­c­xcaná̠n a̠má pokxni hua̠ntu̠ quin­ca̠­lac­ta­huacán nac min­ca̠­chi­qui̠ncán, la̠quí hui­xinín naca­tzi̠­yá̠tit pi̠ niaj quin­cuentajcán la̠ta túcu naca̠ok­spu­layá̠n. Pero ma̠squi chuná luu caaka­tá̠k­stit hui­xinín pi̠ luu caj huá cli̠­mi­ni̠­táhu la̠qui̠ nac­ca̠­hua­niyá̠n pi̠ aya lak­cha̠ni̠t quilh­ta­macú la̠ta lácu Dios nama̠­tzu­qui̠y xasa̠sti xta­péksi̠t nac milak­sti̠­pa̠ncán.” ");
INSERT INTO tocNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ a̠má quilh­ta­macú acxni̠ hua̠k cris­tianos nata­ma̠sta̠y cuenta cxla­catí̠n Dios a̠má ca̠chi­quí̠n anta­nícu ni̠ naca̠­maka­maklhti̠­nan­ca­ná̠tit, pus a̠tzinú luu lanca xta­pa̠tí̠n nalak­chá̠n ni̠ xachuná hua̠ntu̠ naca̠­lak­chá̠n a̠ma̠ko̠lh lac­li̠xcáj­nit cris­tianos hua̠nti̠ maká̠n xta­hui­lá̠­nalh nac a̠má li̠xcáj­nit ca̠chi­quí̠n Sodoma. ");
INSERT INTO tocNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Koxu­tacu tihua­ná̠tit hui­xinín cris­tianos hua̠nti̠ hui­látit chú nac xaca̠­chi­quí̠n Corazín, y na̠chuná hui­xinín hua̠nti̠ hui­látit nac Bet­saida! Porque para a̠má lac­lanca quin­ta­scújut hua̠ntu̠ cca̠t­la­huani̠t nac milak­sti̠­pa̠ncán chuná xti­ca̠t­la­huáca xamaká̠n quilh­ta­macú nac xaca̠­chi­quí̠n Tiro y Sidón, pus xlacán aya talak­pa­li̠ni̠t cahuá xali̠xcáj­nit xta­la­ca­pa̠s­tac­nicán y aya xta­li̠­ma̠­sí­yulh nac xla­ta­ma̠tcán porque xta­lhá­ka̠lh xalac cur­riente lháka̠t y xca̠­liac­tla­hua­pu̠x­tú­calh lhcaca caj la̠ta xta­li̠­pu­hua̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pero acxni̠ nalak­chá̠n quilh­ta­macú la̠ta lácu Dios naca̠­ta̠t­la­huay cuenta xli̠­hua̠k cris­tianos pus hui­xinín a̠tzinú luu la̠n pim­pá̠tit pa̠ti̠­na­ná̠tit ni̠ xachuná a̠ma̠ko̠lh cris­tianos hua̠nti̠ maká̠n xta­hui­lá̠­nalh nac Tiro y Sidón. ");
INSERT INTO tocNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Y chi̠nchú hui­xinín hua̠nti̠ hui­látit nac xaca̠­chi­quí̠n Caper­naum, para luu lac­pu­hua­ná̠tit pi̠ Dios ca̠li̠­ka­lhi̠má̠n lanca mim­pu̠­ta­hui̠lhcán nac akapú̠n, pus luu aktzan­ka̠­ni̠­tátit porque hui­xinín naca̠­ma­ca­pin­ca­ná̠tit nac pu̠pa̠tí̠n la̠qui̠ antá naxo­ko̠­nu­ná̠tit. ");
INSERT INTO tocNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesús chiné ca̠hua­nipá xta­ma̠­kalh­ta­huaké̠n: —Hua̠nti̠ hui­xinín naca̠­ca̠­naj­la­niyá̠n min­ta­chu­hui̠ncán, pus na̠ aquit quin­ca̠­naj­la­nima; pero para tícu caj naca̠­lak­makaná̠n pus na̠ aquit qui­lak­makama; y hua̠nti̠ aquit naqui­lak­makán pus na̠ lak­makama Quin­tla̠t hua̠nti̠ qui­ma­ca­mini̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ni̠ li̠maka̠s quilh­ta­macú a̠ma̠ko̠lh hua̠nti̠ xca̠­ma­ca̠ni̠t Jesús tutum­pu­xa­ma­cu̠tiy xta­ma̠­kalh­ta­huaké̠n, luu xta­pa̠­xu­hua­ti̠­lhay xlacán acxni̠ taqui̠­tás­pitli, y chiné tahuá­nilh Jesús: —Quim­pu̠­chi­nacán, luu xli̠­ca̠na hasta ma̠squi xes­pí­ritu akska­huiní hua̠k xquin­ca̠­ka­lha­kax­matá̠n acxni̠ nac min­ta­cu­huiní xac­ca̠­li̠­ma̠­pek­si̠­yá̠hu xla­cata catáx­tulh. ");
INSERT INTO tocNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús chiné ca̠kálh­ti̠lh: —Xli̠­ca̠na, porque aquit cúc­xilhli acxni̠ huitek ta̠k­pu̠s­pitchá nac akapú̠n akska­huiní y maktum tamó­kosli cumu la̠ mak­lipni. ");
INSERT INTO tocNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Pus aquit cca̠­ma̠x­qui̠­ni̠tán li̠t­li­hueke la̠qui̠ tla̠n namaka­tla­ja­yá̠tit xli̠t­li­hueke akska­huiní hua̠nti̠ luu ca̠si̠­tzi̠­niyá̠n y xlá ni̠tu̠cu cati­ca̠t­la­huanín. ");
INSERT INTO tocNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero ni̠ caj huá luu cali̠­pa̠­xu­huátit porque ca̠ka­lha­kax­matni xes­pi­ri­tucán akska­huiní, huata mejor huá cali̠­pa̠­xu­huátit porque nac akapú̠n aya talh­ca̠­ni̠­tan­chitá min­ta­cu­hui­nicán. ");
INSERT INTO tocNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Acxni­tiyá tuncán Espíri­tu Santo má̠x­qui̠lh Jesús aktum lanca tapa̠­xu­huá̠n y chiné kalh­ta­hua­ká­nilh Dios: —Papá Dios, cla­ka­chix­cu­hui̠yá̠n porque huix xpu̠­chiná akapú̠n chu ca̠ti­yatni, y cpa̠x­cat­ca­tzi̠­niyá̠n porque huix ca̠ma̠aktze̠­kuili̠ni xatlá̠n min­ta­la­ca­pa̠s­tacni hua̠nti̠ luu lac­ta­li̠­pa̠hu y lak­ska­lalán lac­chix­cu­huí̠n la̠qui̠ xlacán ni̠ nataaka­ta̠ksa, y huata huá ca̠ma̠­si­yu­ni­ni̠ta a̠ma̠ko̠lh cris­tianos hua̠nti̠ luu ni̠para túcu xka­satcán la̠qui̠ huá nata­ka­lha­kax­matá̠n. Aquit luu cli̠­pa̠­xu­huay porque huix chuná lacás­quinti y chuná lalh. ");
INSERT INTO tocNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Aca­li̠stá̠n chiné ca̠huá­nilh cris­tianos: —La̠ta túcu anán, Quin­tla̠t hua̠k qui­ma­ca­ma̠x­qui̠ni̠t; aquit Xka­huasa Dios y ni̠ti̠cu luu qui­la­ka­pasa tícu aquit huata caj xma̠nhuá Dios catzi̠y pi̠ xli̠­ca̠na aquit Xka­huasa; y na̠chuna li̠túm Quin­tla̠t Dios ni̠ti̠cu luu catzi̠y lácu xlá xta­la­ca­pa̠s­tacni caj xma̠n aquit cca­tzi̠y porque aquit Xka­huasa, y caj xma̠nhuá tla̠n nala­ka­pasa hua̠nti̠ aquit nac­ma̠­la­ka­pas­ni̠­putún. ");
INSERT INTO tocNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Caj xma̠nhuá cacs ca̠lak­lá­ca̠lh xta­ma̠­kalh­ta­huaké̠n y chiné ca̠huá­nilh: —Luu li̠pa̠­xúhu hui­xinín caj xla­cata a̠má lac­lanca ta­scújut hua̠ntu̠ la̠nchú liucxilh­pá̠tit mila­kas­ta­pucán. ");
INSERT INTO tocNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ lhu̠hua xalak­maká̠n pro­fetas chú lac­lanca reyes xtaucxilh­putún hua̠ntu̠ la̠nchú hui­xinín ucxilh­pá̠tit pero xlacán ni̠ taúcxilhli; xta­kax­mat­putún hua̠ntu̠ la̠nchú hui­xinín kax­pat­pá̠tit pero xlacán ni̠ takáx­matli. ");
INSERT INTO tocNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Cha̠tum xma̠­kalh­ta­hua­ke̠­nacán judíos lak­ta­la­ca­tzú­hui̠lh la̠qui̠ nata̠­chu­hui̠nán pero caj xli̠­kalh­tzak­sama porque chiné kalhás­quilh: —Ma̠kalh­ta­hua­ke̠ná, ¿túcu luu qui­li̠t­lá­huat la̠qui̠ tla̠n nacán tata­huilay cane̠cxni cahuá quilh­ta­macú nac akapú̠n? ");
INSERT INTO tocNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús chiné kálh­ti̠lh: —¿Lácu chí tatzokni̠t nac xli̠­ma̠­peksí̠n Dios? ¿Lácu aka­ta̠ksa acxni̠ li̠kalh­ta­hua­kaya? ");
INSERT INTO tocNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Amá xma̠­kalh­ta­hua­ke̠­nacán judíos chiné kálh­ti̠lh: —Antá chiné tatzokni̠t: “Capa̠xqui Mim­pu̠­chiná MiDios xli̠­hua̠k minacú, xli̠­hua̠k mili̠s­tacni, xli̠­hua̠k mili̠t­li­hueke, chu xli̠­hua̠k min­ta­la­ca­pa̠s­tacni; y na̠chuná capa̠xqui min­ta̠­cris­tiano cumu la̠ me̠cstu pa̠x­qui̠­cana.” ");
INSERT INTO tocNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús chiné huá­nilh: —Luu laca­tancs la̠ huana. Para huix chuná nat­la­huaya hua̠ntu̠ chu­huí̠­nanti pus huix naka­lhi̠ya latáma̠t cane̠c­xni­cahuá quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero cumu a̠má chixcú caj luu chuná xca­tzi̠y y juerza kalhas­quimpá Jesús: —¿Xatícu quin­ta̠­cris­tiano luu qui­li̠­pá̠x­qui̠t? ");
INSERT INTO tocNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesús chiné kálh­ti̠lh: —Luu cuentaj cat­lahua u̠má takalh­chu­huí̠n hua̠ntu̠ camá̠n hua­niyá̠n: Maktum quilh­ta­macú cha̠tum chixcú minchá nac Jeru­salén xpe­kama nac Jericó, pero nac tiji tali̠­pa̠­táx­tulh maka­pi­tzí̠n kalha̠­naní̠n. Tamak­ka­lhan­ko̠lh la̠ta túcu xlá xle̠n, hasta ma̠squi clháka̠t hua̠ntu̠ xlá clha­ka̠ni̠t hua̠k tamák­lhti̠lh; la̠n taakka­xí­mi̠lh y tama̠­la­ka­huí­tilh, a̠tzinú xuani̠t aya xta­makni̠y a̠cu tamák­xtekli y táalh. ");
INSERT INTO tocNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Pero na̠ antiyá nac a̠má tiji xlac­mima cha̠tum cura, pero acxni̠ xlá úcxilhli huata ti̠tum alh. ");
INSERT INTO tocNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Pero caj li̠puntzu̠ li̠túm na̠ antá lác­milh cha̠tum chixcú hua̠nti̠ xca̠­ta̠­ta­peksi̠y levitas; acxni̠ na̠ xlá ucxilhpá huata na̠ ti̠tum alh. ");
INSERT INTO tocNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pero cha̠tum chixcú xalac Samaria na̠ antá xlá xlac­tla̠­huama nac a̠má tiji; acxni̠ xlá úcxilhli luu kayaj cátzalh y laka­lhá­malh. ");
INSERT INTO tocNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","La̠li̠­huán lak­ta­la­ca­tzú­hui̠lh anta­nícu xmá a̠má chixcú hua̠nti̠ xma̠­ta­ka̠­hui̠­cani̠t, li̠huana̠ cuchí̠­nilh anta­nícu xta­ka̠­hui̠ni̠t li̠t­la­huá­nilh aceite chu cuchu. Y aca­listá̠n pú̠le̠lh xca­hua̠yu, lí̠cha̠lh nac aktum chiqui hua̠ntu̠ xlá sá̠cualh y antá li̠huana̠ mak­tá­kalhli. ");
INSERT INTO tocNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Li̠cha̠lí acxni̠ xka­ka­ko̠lh, a̠má samari­tano acxni̠ aya xamajá, ma̠cú­tulh okxtiy tumi̠n xla plata, má̠x­qui̠lh xpu̠­chiná a̠má chiqui y chiné huá­nilh: “Luu cuentaj cat­lahua eé koxutá chixcú, y para túcu huix nali̠­ma­kas­pu­tacú, ni̠ cali̠­pú­huanti porque aquit nac­xo­ko­niyá̠n acxni̠ nac­mim­paray.” ");
INSERT INTO tocNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Pus chuná a̠má tit­lá­hualh; chú huix luu caj caqui­huani, la̠ta xli̠­ka­lha­tu­tucán a̠ma̠ko̠lh lac­chix­cu­huí̠n, ¿xatícu cahuá chú luu liúcxilhli cumu la̠ xta̠­cris­tiano hua̠nti̠ luu xli̠­pá̠x­qui̠t a̠má chixcú hua̠nti̠ tali̠­pa̠­táx­tulh kalha̠­naní̠n? ");
INSERT INTO tocNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Amá xma̠­kalh­ta­hua­ke̠­nacán judíos chiné kalh­tí̠­nalh: —Pus aquit clac­pu­huán pi̠ ma̠x hua̠nti̠ laka­lhá­malh y mak­tá̠­yalh. —Pus huix na̠chuná cat­lahua y caca̠­mak­ta̠ya ma̠squi cati̠hua̠ min­ta̠­cris­tianos hua̠nti̠ tamac­la­cas­quimá̠n —huá­nilh Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús taca̠xpá y tzú­culh tla̠­huán nac tiji y cha̠lh nac aktum actzu̠ ca̠chi­quí̠n, antá xuí cha̠tum pusca̠t xlá luu li̠pa̠­xúhu maka­mak­lhtí̠­nalh nac xchic, a̠má pusca̠t xuanicán Marta. ");
INSERT INTO tocNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Amá Marta xuí cha̠tum xta̠lá xuanicán María, y anta­nícu xlá táhui Jesús na̠ antá lacatzú nac xtantú̠n táhui María la̠qui̠ xlá nakax­matniy xta­chu­huí̠n hua̠ntu̠ xlá nali̠­chu­hui̠nán. ");
INSERT INTO tocNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero Marta luu xliaka­ti­yuma xli̠­ta­scújut xalac xcu­si̠na, xlá huata lak­ta­la­ca­tzú­hui̠lh Jesús y chiné huá­nilh: —Quim­pu̠­chiná, ¿lácu pi̠ ni̠para tzinú lac­pu­huana pi̠ aquit ctla­hua­ni­ma̠­ko̠lh xli̠­ta­scújut hua̠ntu̠ xli̠t­lá­huat quinta̠ María? Pus luu cat­lahua li̠tlá̠n cahuani pi̠ caqui­mak­tá̠­yalh. ");
INSERT INTO tocNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pero Jesús chiné kálh­ti̠lh: —Marta, koxutá huix Marta, huix xli̠­ca̠na luu aka­tiyuj li̠lápa̠t catu̠huá hua̠ntu̠ mili̠­ta­scújut. ");
INSERT INTO tocNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pero caj xma̠n pu̠lactum huí hua̠ntu̠ luu a̠tzinú li̠ma­cuán y huá xlá lac­sacni̠t María y ni̠ti̠ cati­ma̠­lac­tlá­hui̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Maktum quilh­ta­macú Jesús xkalh­ta­hua­ka­nima Dios y acxni̠ kalh­ta­hua­ka­ko̠lh cha̠tum xdis­cí­pulo chiné huá­nilh: —Quim­pu̠­chi­nacán, caqui­la̠­ma̠­si­yu­níhu lácu nac­kalh­ta­hua­ka­ni­yá̠hu Dios na̠chuná cumu la̠ Juan Bau­tista ca̠ma̠­si­yú­nilh hua̠nti̠ xta­kax­matniy xta­chu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús chiné ca̠huá­nilh: —Acxni̠ hui­xinín nakalh­ta­hua­ka­ni­yá̠tit Dios chiné nahua­ni­yá̠tit: Quin­tla̠­ticán Dios hua̠nti̠ huix hui­lapi nac akapú̠n, caj xma̠n huix mini̠­niyá̠n nac­ca̠­la­ka­chix­cu­hui̠­niyá̠n min­ta­cu­huiní. Camilh mili̠­ma̠­peksí̠n uú nac cqui­lak­sti̠­pa̠ncán. Y chuná uú nac ca̠quilh­ta­macú cakan­táx­tulh min­ta­pa̠­xu­huá̠n cumu la̠ kan­tax­tu­ma̠chá nac akapú̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Caqui­la̠­ma̠x­quí̠hu quin­ta­huajcán hua̠ntu̠ nac­li̠­la­ta­ma̠­yá̠hu cha̠li cha̠lí. ");
INSERT INTO tocNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Caqui­la̠­ma̠­tzan­ke̠­na­níhu xli̠­hua̠k hua̠ntu̠ ni̠tlá̠n cca̠t­la­hua­ni­ni̠tán, porque aquinín na̠ cca̠­ma̠­tzan­ke̠­na­ni­yá̠hu quin­ta̠­cris­tianojcán hua̠nti̠ quin­ca̠t­la­hua­niyá̠n ni̠tlá̠n. Ni̠ caqui­la̠­mak­xtekui xla­cata nata­mo­ko­sá̠hu acxni̠ naquin­ca̠­tzak­sa­caná̠n huata mejor caqui­la̠­ma̠­ta­pa̠­nu̠­níhu hua̠ntu̠ xquin­ca̠­ma̠t­la­huí̠n tala̠­ka­lhí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesús ca̠hua­nipá eé takalh­chu­huí̠n: —Pus para tícu la̠ uú layá̠tit hui­xinín kalhi̠y cha̠tum xamigo, y nalak­chá̠n íta̠t tzi̠sa nac xchic y chiné nahuaniy: “Amigo, cat­lahua li̠tlá̠n caqui­ma̠­pa̠­huani mac­tutu min­cax­ti­la̠n­chahu, ");
INSERT INTO tocNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","porque qui­lák­chilh cha̠tum quiamigo y antá chú xlá naqui­mak­lak­tun­cu­huiy, pero chú aquit ni̠tu̠cu cka­lhi̠y hua̠ntu̠ nac­ta̠­huay.” ");
INSERT INTO tocNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Aquit clac­pu­huán pi̠ a̠má xamigo hua̠nti̠ ancani̠t mak­pa̠­huacán cax­ti­lá̠n­chahu, cumu xlá antá tanu̠ma nac xchic chiné nakalh­ti̠nán nac xpu̠­lacni chiqui: “Luu xli̠­cána cat­lahua li̠tlá̠n ni̠ caqui­ma̠­ka­tzanke, porque qui­má̠­lacchi luu li̠huana̠ lac­chu­huay, xa̠huachí aquit cca̠­ma̠lh­ta­ti̠ma lactzu̠ quin­camán nac pu̠tama y ni̠lay nac­ta̠­qui̠y la̠qui̠ nac­ma̠x­qui̠yá̠n hua̠ntu̠ huix quis­qui­nípa̠t.” ");
INSERT INTO tocNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Pero para a̠má chixcú hua̠nti̠ pa̠hua­nama ni̠ aka­tza­yanca mak­xteka chu­na­tiyá li̠ma­ka­tzan­ke̠ma xamigo, aquit cca̠­hua­niyá̠n pi̠ ma̠squi ni̠ xta̠­qui̠­pútu xla­cata nama̠x­qui̠y hua̠ntu̠ mac­la­cas­quima xamigo, pus juerza nata̠­qui̠y y nama̠x­qui̠y la̠qui̠ niaj pucutá nama̠­ka­tzanke̠y, y nama̠x­qui̠ko̠y pu̠tum hua̠ntu̠ xlá namac­la­cas­quín. ");
INSERT INTO tocNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Aquit cca̠­hua­niyá̠n pi̠ na̠chuná hui­xinín cat­la­huátit: Cas­qui­nítit Dios hua̠ntu̠ mac­la­cas­quim­pá̠tit, xlá naca̠­ma̠x­qui̠yá̠n; capu­tzátit hua̠ntu̠ mac­la­cas­qui­ná̠tit y namac­la­yá̠tit; cala­kat­láktit má̠lacchi y xlá naca̠­ma̠­la­qui̠­niyá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Porque para tícu squin hua̠ntu̠ mac­la­cas­quima, nama̠x­qui̠cán; y hua̠nti̠ putzay hua̠ntu̠ maka­tzan­ka̠ni̠t, maclay; y hua̠nti̠ lakat­laka má̠lacchi, ma̠la­qui̠­nicán. ");
INSERT INTO tocNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Na̠chu­na­li̠túm para tícu hui­xinín hua̠nti̠ taka­lhi̠y xca­mancán y para nas­quiniy xka­huasa mactum cax­ti­lá̠n­chahu, ¿lácu pi̠ huata mejor nama̠x­qui̠y aktum chí­huix? Osuchí acxni̠ nas­quiniy tantum squi̠ti, ¿pi̠ naliak­ska­huiy tantum lu̠hua? ");
INSERT INTO tocNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Osuchí acxni̠ nas­quiniy aktum ká̠lhua̠t, ¿lácu pi̠ huata nama̠x­qui̠y tantum sta̠­cúlut? ");
INSERT INTO tocNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pus cumu hui­xinín xala ca̠quilh­ta­macú luu xli̠­ca̠na ni̠tlá̠n catzi̠­yá̠tit, pero min­ca­mancán luu tla̠n ma̠x­qui̠­yá̠tit hua̠ntu̠ ca̠s­qui­niyá̠n, ¿pi̠ li̠huaca chú Min­tla̠­ticán Dios hua̠nti̠ hui­lachá nac akapú̠n ni̠ cati­ca̠­má̠x­qui̠lh xli̠t­li­hueke Espíri­tu Santo hua̠nti̠ natas­quiniy? ");
INSERT INTO tocNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Maktum quilh­ta­macú Jesús xmac­ta­mac­xtuma xes­pí­ritu akska­huiní cha̠tum chixcú hua̠nti̠ luu xmaka­tla­jani̠t y xma̠­ko̠­ke̠ni̠t. Acxni̠ a̠má xes­pí­ritu akska­huiní mac­táx­tulh, a̠má chixcú hua̠nti̠ xko̠­ko̠ni̠t tla̠n tzú­culh chu­hui̠nán. Xli̠­hua̠k cris­tianos luu cacs tali̠­la­cáhua hua̠ntu̠ Jesús xlá xtla­huani̠t, ");
INSERT INTO tocNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","pero maka­pi­tzí̠n chiné tzú­culh tahuán: —Eé chixcú huá ca̠li̠­ta­mac­xtuy xes­pí­ritu akska­huiní porque xlá kalhi̠y xli̠t­li­hueke Beel­zebú hua̠nti̠ luu xapuxcu diablo. ");
INSERT INTO tocNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Y a̠maka­pi­tzí̠n na̠ caj xta­tzak­sa­má̠­nalh xtas­qui­ni­má̠­nalh xla­cata cat­lá­hualh aktum lanca li̠cá̠cni̠t ta­scújut hua̠ntu̠ nataucxilha. ");
INSERT INTO tocNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero cumu xlá xca­tzi̠y hua̠ntu̠ xlacán xta­lac­pu­hua­má̠­nalh chiné ca̠huá­nilh: —La̠tachá tícuya̠ gobier­no, para xlá caj tzucuy tala̠­ma­ka­si̠­tzi̠y sac­stucán y nata­ta­paj­pi­tziy, pus sac­stucán nata­la̠­lac­tla­hua­ya̠­huay. Y na̠chuna li̠túm para nac aktum chiqui anta­nícu huí cha̠tum chixcú y tahui­lá̠­nalh xcamán y para caj natzucuy tala̠­la­ca­ta̠­qui̠y pus ni̠lay cati­ta­pá­lhi̠lh huata caj pu̠tum nala̠­lac­tla­hua­ya̠­huay. ");
INSERT INTO tocNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Pus na̠chuná chú para akska­huiní chu hua̠nti̠ ca̠ta̠s­cujma nata­ta­paj­pi­tziy y natzucuy la̠la­ca­ta­huacay, ¿pi̠ tla̠n cahuá chú maka̠s naka­lhi̠y xli̠t­li­hueke? Huá chuná cli̠­qui­lhuama porque hui­xinín hua­ná̠tit pi̠ aquit cca̠­ta­mac­xtuy xes­pí­ritu akska­huiní porque mat aquit cta̠s­cujma y cka­lhi̠y xli̠t­li­hueke Beel­zebú y mat huá xli̠t­li­hueke cca̠­li̠­ta­mac­xtuy xes­pí­ritu akska­huiní. ");
INSERT INTO tocNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Pus para xli̠­ca̠na aquit cka­lhi̠y xli̠t­li­hueke Beel­zebú, y chi̠nchú hua̠nti̠ min­ta̠­chi­quicán na̠ tata­mac­xtuy xes­pi­ri­tucán akska­hui­niní̠n, ¿lácu pi̠ na̠ huá taka­lhi̠y xli̠t­li­hueke Beel­zebú? Poreso anta­tuncán li̠taaka­ta̠ksa pi̠ ni̠para tzinú catzi̠­yá̠tit hua̠ntu̠ hua­ná̠tit. ");
INSERT INTO tocNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pus aquit huá xli̠t­li­hueke Dios cca̠­li̠­ta­mac­xtuy xes­pi­ri­tucán akska­hui­ninín la̠qui̠ chuná hui­xinín nali̠­ca­tzi̠­yá̠tit pi̠ a̠má xasa̠sti xta­péksi̠t Dios hua̠ntu̠ nahuili̠y uú nac ca̠quilh­ta­macú aya tzu­cuni̠t kan­taxtuy nac mila­ta­ma̠tcán. ");
INSERT INTO tocNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Porque cumu la̠ hui­xinín catzi̠­yá̠tit, para cha̠tum chixcú ni̠ pe̠cuán y luu xli̠­ca̠na tli­hueke y kalhi̠y luu xatlá̠n xli̠­ta­la̠tni pus chuná tla̠n mak­ta­kalha xchic y ni̠ mak­li̠­huán la̠ta túcu kalhi̠y hua̠ntu̠ xlá ma̠qui̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero para nalak­chín cha̠­tum­li̠túm chixcú hua̠nti̠ a̠tzinú luu tli­hueke ni̠ xachuná xlá, y para namaka­tlajay pus chuná tla̠n namak­ka­lhankóy hua̠ntu̠ xlá xka­lhi̠y; pus na̠ xta̠­chuná cumu la̠ aquit ctla­huani̠t akska­huiní. ");
INSERT INTO tocNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Pus na̠chuná chú, hua̠nti̠ ni̠ lakati̠y hua̠ntu̠ cli̠s­cujma caj qui­lak­si̠­tzi̠niy hua̠ntu̠ aquit cli̠s­cujma, y hua̠nti̠ ni̠ lac­xtum quin­ta̠­ma̠­macx­tumi̠y cris­tianos la̠qui̠ aquit nac­ca̠­lak­ma̠xtuy, pus huata tamá xlá caj ca̠ma̠­paj­pi­tzima la̠qui̠ li̠huaca nata­lak­tzanka̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Acxni̠ xes­pí­ritu akska­huiní ma̠mak­xte­kecán cha̠tum chixcú, mákat an lata­pu̠li̠y y laca­pu­tzay xanícu luu najaxa; pero cumu ni̠ namaclay chiné nalac­pu­huán: “Huata mejor nac­tas­pit­paray nac quín­chic anta­nícu ctax­tuchá.” ");
INSERT INTO tocNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Acxni̠ xlá nachín ma̠nok­lhuy a̠má chixcú cumu la̠ aktum chiqui hua̠ntu̠ li̠huana̠ ca̠x­ya̠­hua­cani̠t y li̠huana̠ ca̠palh­cani̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Y la̠li̠­huán xlá naán ca̠tiyay a̠kalha­tujún li̠túm akska­hui­niní̠n hua̠nti̠ na̠ luu lac­li̠xcáj­nit tali̠­ca­tzi̠y, y pu̠tum tamac­tanu̠y a̠má chixcú hua̠nti̠ xlá aya xtat­la̠n­ti̠ni̠t, pus a̠má chixcú a̠tzinú luu li̠xcáj­nit huan xta­pu­huá̠n ni̠ xachuná cumu la̠ xapu̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús chu­nacú xchu­hui̠­nama acxni̠ cha̠tum pusca̠t palha chiné quilh­minchá: —¡Li̠pa̠­xúhu lama a̠má pusca̠t hua̠nti̠ ma̠la­ka­tun­cu­huí̠n y ma̠tzi­quí̠n! ");
INSERT INTO tocNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pero xlá chiné kalh­tí̠­nalh: —Atzinú luu lac­li̠­pa̠­xúhu cata­la­tá­ma̠lh cris­tianos hua̠nti̠ takax­mata xta­chu­huí̠n Dios y talak­tzaksay tama̠­kan­taxti̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Cumu luu lhu̠hua cris­tianos xta­mac­xtu­mi̠ma anta­nícu xláya Jesús xlá chiné tzú­culh ca̠ma̠­kalh­chu­hui̠ni̠y: —Koxu­taní̠n a̠ma̠ko̠lh cris­tianos hua̠nti̠ tala­má̠­nalh la̠nchú eé quilh­ta­macú porque luu lac­li̠xcáj­nit xta­pu­hua̠ncán, y anka­lhi̠ná quin­tas­qui­ni­má̠­nalh cac­tlá­hualh aktum lanca li̠cá̠cni̠t ta­scújut la̠qui̠ naquin­ta­li̠­ca̠­naj­laniy para xli̠­cána aquit hua̠nti̠ naca̠­lak­ma̠xtuy. Pero xli̠­ca̠na cca̠­hua­niyá̠n pi̠ ni̠tu̠ cac­ti­ca̠­li̠­ma̠­la­kas­tá̠­ni̠lh hua̠ntu̠ xlacán taucxilh­putún, huata mejor nac­ca̠­li̠­ma̠­la­ca­hua̠ni̠y aktum ta­scújut cumu la̠ tu̠ Dios tit­lá­hualh maká̠n nac xla­táma̠t pro­feta Jonás. ");
INSERT INTO tocNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Xlá caj xla­táma̠t ca̠li̠­ma̠­la­ca­huá̠­ni̠lh a̠ma̠ko̠lh xalak­maká̠n cris­tianos hua̠nti̠ xta­la­má̠­nalh nac Nínive, pi̠ xli̠­ca̠na Dios xma­ca­mini̠t; pus na̠chuná chú aquit Xata­lac­sacni Chixcú nac­ca̠­li̠­ma̠­la­ca­hua̠ni̠y qui­la­táma̠t a̠ma̠ko̠lh cris­tianos hua̠nti̠ tala­má̠­nalh la̠nchú eé quilh­ta­macú pi̠ xli̠­ca̠na Dios qui­ma­ca­mini̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Acxni̠ nalak­chá̠n quilh­ta­macú la̠ta lácu Dios naca̠­ta̠t­la­huay cuenta xli̠­hua̠k cris­tianos, a̠má pusca̠t hua̠nti̠ xma̠­pek­si̠nán xamaká̠n nac Sur, xlá nata̠yay la̠qui̠ naca̠­ma̠­la­ca­pu̠yá̠n nac xla­catí̠n Dios hui­xinín cris­tianos hua̠nti̠ hui­látit ca̠lacchú quilh­ta­macú; porque xlá ma̠squi luu mákat xuani̠t nac xpu̠­la­tama̠n milh kax­matniy xta­chu­huí̠n ska­lala rey Salo­món, pero hui­xinín ni̠ qui­la̠­kax­mat­ni­yá̠hu ma̠squi uú ca̠ta̠­chu­hui̠­namá̠n cha̠tum hua̠nti̠ tlak ska­lala ni̠ xachuná rey Salo­món. ");
INSERT INTO tocNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ama̠­ko̠lh cris­tianos hua̠nti̠ tala­má̠­nalh nac Nínive na̠ naca̠­ma̠­la­ca­pu̠yá̠n nac xla­catí̠n Dios acxni̠ nalak­chá̠n quilh­ta­macú la̠ta lácu xlá naca̠­ma̠­xo­ko̠ni̠y cris­tianos, porque xlacán xli̠­ca̠na talak­pá­li̠lh xali̠xcáj­nit xta­la­ca­pa̠s­tac­nicán acxni̠ Jonás ca̠li̠­xa­kát­li̠lh xli̠­ma̠­peksí̠n Dios, pero hui­xinín ni̠para tzinú qui­la̠­ca̠­naj­la­ni­pu­tu­ná̠hu ma̠squi la̠nchú ca̠ta̠­chu­hui̠­namá̠n cha̠tum ti̠ a̠tzinú lanca xla­ca­tzúcut ni̠ xachuná pro­feta Jonás. ");
INSERT INTO tocNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesús chiné huampá: —Pus cumu la̠ hui­xinín catzi̠­yá̠tit ni̠ti̠cu anán cris­tianos hua̠nti̠ nama̠­pasi̠y aktum li̠maksko y caj lá nama̠­pa­si̠ko̠y chú nama̠­tze̠ka, osuchí naliakpu­lon­kxuili̠y aktum cajón; huata mejor hui­li̠cán anta­nícu ta̠lhmá̠n la̠qui̠ hua̠nti̠ nata­tanu̠y nac a̠má chiqui nataucxilha tax­káket. ");
INSERT INTO tocNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Min­ti­yat­li̠­huacán na̠ kalhi̠y xli̠­maksko pus huá mila­kas­ta­pucán. Para mila­kas­tapu tla̠n laca­hua̠nán xli̠­pu̠tum min­ti­yat­li̠hua hua̠k tla̠n porque kalhi̠y tax­káket, pero para mila­kas­tapu ni̠tlá̠n laca­hua̠nán xli̠­hua̠k tu̠ huí nac min­ti­yat­li̠hua xala­ka­ca̠­pucsua lama. ");
INSERT INTO tocNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Pus luu cuentaj cat­la­huátit a̠má tax­káket hua̠ntu̠ li̠la­ca­hua̠­na­ná̠tit la̠qui̠ ni̠ xamaktum xala­ka­ca̠­pucsua nahuán. ");
INSERT INTO tocNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Pus para mimacni kalhi̠y tax­káket, ni̠ xala­ka­ca̠­pucsua lama, y chuná tla̠n sta­lanca catu̠huá naucxilha, xta̠­chuná cumu la̠ aktum lám­para acxni̠ ma̠pa­si̠cán, lacaxtum li̠mak­skoy xli̠­hua̠k xtax­káket. ");
INSERT INTO tocNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Acxni̠ Jesús akchu­hui̠­nan­ko̠lh, cha̠tum fariseo huá­nilh xla­cata naán ta̠hua̠yán nac xchic. Jesús alh, tanu̠chá nac chiqui y tuncán táhui anta­nícu xyá mesa. ");
INSERT INTO tocNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Amá fariseo luu xli̠­ca̠na caj cacs li̠la­cáhua acxni̠ úcxilhli pi̠ ni̠ chuná xma̠­kan­tax­tíma la̠ta lácu xli̠s­ma­ni̠­cani̠t xtla­huacán, porque xlacán pu̠lh la̠n xca̠­li̠­ma­ca­pux­ma­ni̠cán chú­chut acxni̠ nia̠ tahua̠yán. ");
INSERT INTO tocNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pero Quim­pu̠­chi­nacán chiné ca̠huá­nilh: —Hui­xinín fariseos luu caj xma̠n ca̠che­ke̠­yá̠tit nac xmacni miva­sucán chu mim­pu­la̠­tucán, pero nac mim­pu̠­lac­nicán antá nac mina­cujcán luu li̠xcáj­nit hui­lachá caj xpa̠­la­cata hua̠ntu̠ tla­hua­yá̠tit para taka­lhá̠n osuchí para lac­li̠xcáj­nit tala­ca­pa̠s­tacni. ");
INSERT INTO tocNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Xli̠­ca̠na pi̠ luu lani̠­tátit, ¿lácu pi̠ ni̠ catzi̠­yá̠tit pi̠ hua̠nti̠ tla­huani̠t hua̠ntu̠ che­ke̠­ma­ka­ná̠tit xalac mimac­nicán na̠ huá tla­huani̠t xalac mim­pu̠­lac­nicán mina­cujcán y xalá ucxilhma la̠ta túcu antá kalhi̠­yá̠tit? ");
INSERT INTO tocNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Huata tu̠ mili̠t­la­huatcán xapu̠lh nache­ke̠­yá̠tit tu̠ huí nac mim­pu̠­lac­nicán hasta nac mina­cujcán y huá nama­ca­ma̠x­qui̠­yá̠tit Dios cumu la̠ mili̠­mosna o mili̠­la­ka­chix­cu­huí̠n, y xli̠­hua̠k hua̠ntu̠ kalhi̠­yá̠tit nac mimac­nicán xata­cheké̠n nahuán nac xla­catí̠n Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Koxu­tacu tihua­ná̠tit hui­xinín fariseos! Porque ma̠squi xli̠­ca̠na ma̠paj­pi­tzi­yá̠tit y li̠la­ka­chix­cu­hui̠­yá̠tit Dios hua̠ntu̠ hui­xinín maka­la­yá̠tit para menta, ruda y ti̠pa̠­lhu̠hua a̠má lactzu̠ tachaná̠n y mat huá mili̠­mos­najcán, pero cumu ni̠para tzinú cuentaj tla­hua­yá̠tit hua̠ntu̠ Dios ca̠li̠­ma̠­pek­si̠­pu­tuná̠n la̠ta lácu luu aksti̠tum nala­ta­pa̠­yá̠tit, pus huata huá tamá luu xli̠­ca̠na mili̠t­la­huatcán y ma̠squi na̠ cama̠s­tá̠tit mili̠­mos­najcán. ");
INSERT INTO tocNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Koxu­tacu tihua­ná̠tit hui­xinín fariseos! Porque anta­nícu hui­xinín tas­to­ká̠tit, lacas­qui­ná̠tit naca̠­ma̠x­qui̠­ca­ná̠tit xala­cuán lac­tá­hui̠lh, y xa̠huachí lacas­qui­ná̠tit pi̠ luu tla̠n naca̠­xa­kat­li̠­pa̠x­tok­ca­ná̠tit nac tiji anta­nícu hui­xinín tla̠­hua­ná̠tit cumu la̠ lac­ta­li̠­pa̠hu lac­chix­cu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Koxu­taní̠n hui­xinín xma̠­kalh­ta­hua­ke̠­nacán judíos chu fariseos! Porque luu xaaksa­ni̠­naní̠n, xta̠­chuná qui̠­taxtuy cumu la̠ aktum tahuaxni anta­nícu ma̠c­nu̠­cani̠t cha̠tum ni̠n, pero cumu ni̠ tasiyuy, cris­tianos ni̠ taca­tzi̠y lácu antá tati̠­lac­tla̠­huán y taak­lhtam­pusa hua̠ntu̠ ni̠tlá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Cha̠tum xma̠­kalh­ta­hua­ke̠­nacán judíos chiné huá­nilh: —Ma̠kalh­ta­hua­ke̠ná, tamá hua̠ntu̠ huix qui­lhuámpa̠t lá̠m­para na̠ hua̠k aquinín qui­la̠­la­ca­hua­ni­ma̠­náhu. ");
INSERT INTO tocNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús chiné kálh­ti̠lh: —¡Na̠chuná hui­xinín xma̠­kalh­ta­hua­ke̠­nacán judíos, koxu­tacu tihua­ná̠tit! Porque hui­xinín juerza ca̠ma̠t­la­hui̠­pu­tu­ná̠tit cris­tianos hua̠ntu̠ na̠ hui­xinín mili̠t­la­huatcán, y ca̠hua­ni­yá̠tit cata­ma̠­kan­táx­ti̠lh lactzu̠ lactzu̠ xli̠­ma̠­peksí̠n y hui­xinín ni̠para ma̠kan­tax­ti̠­pá̠tit nac mila­ta­ma̠tcán y qui̠­taxtuy lac­tzinca tacuca hua̠ntu̠ hui­xinín ni̠ lac­chex­pu­tu­ná̠tit. ");
INSERT INTO tocNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Koxu­tacu tihua­ná̠tit hui­xinín! Porque ma̠n ca̠ca̠x­tla­hua̠­na­ni­yá̠tit nac xpan­teoncán a̠ma̠ko̠lh pro­fetas hua̠nti̠ tica̠­ma­cá­milh Dios, y hua̠nti̠ tamak­ni̠ni̠t xalak­maká̠n mili̠­ta­la­ka­pas­nicán. ");
INSERT INTO tocNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Pus chuná hui­xinín li̠ta­si­yu­yá̠tit pi̠ na̠ luu mak­li̠­ca­tzi̠­yá̠tit hua̠ntu̠ xlacán tatit­la­huani̠t; huá xlacán tamák­ni̠lh y chi̠nchú hui­xinín ca̠t­la­hua­ni­pá̠tit xpan­teoncán. ");
INSERT INTO tocNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Caj la̠ta cumu Dios makaacchá̠n xta­la­ca­pa̠s­tacni xlá chiné tima̠­tzok­ní̠­nalh nac libro: “Aquit nac­ca̠­ma­ca̠niy pro­fetas chu após­toles hua̠nti̠ naca̠­ma̠­kalh­chu­hui̠ni̠y, pero xlacán maka­pi­tzí̠n naca̠­mak­ni̠cán, y maka­pi­tzí̠n naca̠­pu­tza­sta̠­lacán.” ");
INSERT INTO tocNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ Dios chú naca̠­ma̠­xo­ko̠­ni̠yá̠n hui­xinín cris­tianos hua̠nti̠ lapá̠tit la̠ ca̠lacchú eé quilh­ta­macú caj xpa̠­la­cata xli̠s­tac­nicán xli̠­hua̠k pro­fetas hua̠nti̠ ca̠mak­ni̠­cani̠t hasta la̠ta tzu­cuni̠t ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Hui­xinín naca̠­ma̠­xo­ko̠­ni̠­ca­ná̠tit xli̠s­tacni la̠ta mak­ni̠­cani̠t Abel y xli̠­hua̠k pro­fetas hasta la̠ta mak­ní̠­calh xli̠s­tacni Zaca­rías porque xlá antá mak­ní̠­calh nac xla­catí̠n a̠má altar hua̠ntu̠ huí nac xpu̠­lacni lanca xpu̠­si­culan Dios. Pus huá cca̠­li̠­hua­niyá̠n pi̠ Dios naca̠­ma̠­xo­ko̠ni̠y cris­tianos hua̠nti̠ la̠nchú tala­má̠­nalh caj xpa̠­la­cata xli̠s­tac­nicán hua̠k a̠ma̠ko̠lh lac­chix­cu­huí̠n hua̠nti̠ ca̠mak­ni̠­cani̠t xalak­maká̠n quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Koxu­tacu tihua­ná̠tit hui­xinín xma̠­kalh­ta­hua­ke̠­nacán judíos! Porque hui­xinín ca̠ma̠­lac­chu­hua­ni­yá̠tit má̠lacchi a̠ma̠ko̠lh hua̠nti̠ tapu­tzay lácu luu nata­la­ka­pasa xta­la­ca­pa̠s­tacni Dios; na̠ ni̠para hui­xinín ma̠kan­tax­ti̠­pá̠tit, y ni̠ lacas­qui­ná̠tit para tícu luu nalak­tzaksay y nama̠­kan­taxti̠y a̠túnuj cris­tiano. ");
INSERT INTO tocNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Acxni̠ Jesús chuná huan­ko̠lh eé tachu­huí̠n, a̠ma̠ko̠lh fariseos chu xma̠­kalh­ta­hua­ke̠­naní̠n judíos tasi̠­tzí̠­nilh y catu̠huá tzú­culh taka­lhas­quín la̠qui̠ caj nata­li̠­tzaksay. ");
INSERT INTO tocNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Caj xtaucxilh­putún chicá para túcu ni̠tlá̠n nahuán y chuná nata­ma̠­la­capu̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Amá quilh­ta­macú luu lhu̠hua cris­tianos tata­mac­xtú­mi̠lh la̠qui̠ nata­kax­matniy xta­chu­huí̠n Jesús, luu lhu̠hua ni̠ caj ma̠x aktum mi̠lh y hasta xta­la̠­lak­xqui­ti­ya̠­hua­má̠­nalh. Pero Jesús ca̠ta­sá­nilh xta­ma̠­kalh­ta­huaké̠n porque huí tu̠ xca̠­hua­ni­putún y chiné ca̠huá­nilh: —Luu xli̠­ca̠na cuentaj cat­la­huátit ni̠tu̠ naca̠­ma̠­pa­si̠yá̠n ni̠tlá̠n xta̠­yatcán fariseos porque luu xta̠­chuná caj la̠ leva­dura acxni̠ cajcu actzú y lak­ma­ca̠ncán xas­quítit harina hua̠k ma̠x­cuti̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pero la̠tachá túcu tze̠k ma̠qui̠cán xla­cata xli̠­maka̠s juerza mac­lacán; y para aktum tachu­huí̠n hua̠ntu̠ caj tze̠k huancán caj xla­cata xli̠­maka̠s juerza catzi̠cán. ");
INSERT INTO tocNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Y chi̠nchú hua̠ntu̠ hui­xinín tze̠k li̠chu­hui̠­na­ná̠tit catzi̠sní xli̠­ca̠na pi̠ na̠ nali̠­chu­hui̠­nancán acxni̠ ca̠cu­huiní; y para túcu caj luu laka­siyu xli̠­chu­hui̠­nan­ta­nu̠­pá̠tit aktum tachu­huí̠n nac aktum chiqui, pus aca­li̠stá̠n namín quilh­ta­macú nali̠akta­si̠cán nac xca̠ak­sti̠ní̠n lac­lanca ta̠lh­ma̠ná chiqui. ");
INSERT INTO tocNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jesús ca̠hua­nipá: —Xli̠­ca̠na cca̠­hua­niyá̠n hui­xinín, ni̠ caca̠­pe̠­cuanítit a̠ma̠ko̠lh lac­chix­cu­huí̠n hua̠nti̠ ca̠mak­ni̠­pu­tuná̠n, porque xlacán tla̠n tamakni̠y xti­yat­li̠hua cha̠tum cris­tiano, pero ni̠lay túcua ma̠lak­sputuy. ");
INSERT INTO tocNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pero aquit nac­ca̠­hua­niyá̠n hua̠nti̠ luu qui­li̠­pe̠­cuanitcán: huat huá cape̠­cuanítit Dios porque xlá la̠ namak­ni̠ko̠y mimacni kalhi̠­paray li̠t­li­hueke la̠qui̠ namacá̠n mili̠s­tac­nicán nac pu̠pa̠ti̠n para xlá chuná nala­cas­quín, pus huata huá luu cape̠­cuanítit. ");
INSERT INTO tocNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Caj luu caqui­la̠­hua­níhu, ¿lácu pi̠ ni̠ catzi̠­yá̠tit pi̠ li̠s­ta̠cán tan­qui­tzis lactzu̠ spitu caj okxtiy tumi̠n? ¿Lácu pi̠ a̠tzinú chú lhu̠hua xta­palhcán? Pero ma̠squi chuná, ni̠para tantum actzu̠ spitu pa̠tzanka̠y Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Pus huá chú cca̠­li̠­hua­niyá̠n, ni̠ cape̠­cuántit porque hasta min­chi­xitcán hua̠ntu̠ tayá̠­nalh nac miakxa̠­kacán Dios hua̠k ca̠pu̠t­le­ke­ya̠­huani̠t la̠ta kana­tunu, y cumu hui­xinín xcamán ni̠ cali̠­pu­huántit porque hui­xinín luu lhu̠hua min­ta­palhcán ni̠ xachuná a̠ma̠ko̠lh lactzu̠ spu̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ a̠ma̠ko̠lh cris­tianos hua̠nti̠ tali̠­ta̠yay pi̠ aquit quin­ta­li̠­pa̠­huán nac xlak­sti̠­pa̠ncán xli̠­lhu̠hua cris­tianos, pus na̠chuná chú aquit Xata­lac­sacni Chixcú na̠ nac­li̠­ta̠­ya­ya̠chá pi̠ xli̠­ca̠na huá qui­lac­scujni nac xla­catí̠n ángeles hua̠nti̠ tata̠­la­ma̠­nanchá Dios nac akapú̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero a̠má chixcú hua̠nti̠ ni̠ nali̠­ta̠yay nac xla­ca­ti̠ncán cris­tianos pi̠ xli̠­ca̠na qui­li̠­pa̠­huán, pus na̠chuná chú aquit Xata­lac­sacni Chixcú na̠ ni̠ cac­tíhua para qui­lac­scujni nac xla­catí̠n ángeles hua̠nti̠ tata̠­hui­la̠­nanchá Dios nac akapú̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Pus la̠tachá tícuya̠ cris­tiano hua̠nti̠ cala̠huá naqui­li̠­chu­hui̠nán aquit Xata­lac­sacni Chixcú juerza tla̠n nama̠­tzan­ke̠­na­nicán xta­la̠­ka­lhí̠n, pero hua̠nti̠ cala̠huá nali̠­kalh­ka­ma̠nán xta­scújut Espíri­tu Santo a̠má cris­tiano ni̠lay cati­ma̠­tzan­ke̠­na­ní­calh xta­la̠­ka­lhí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Acxni̠ hui­xinín naca̠­li̠­pin­ca­ná̠tit nac xpu̠­si­cu­lancán judíos, osuchí nac xla­ca­ti̠ncán jueces, osuchí nac xla­ca­ti̠ncán gober­na­dores, ni̠ cali̠­pu­huántit xla­cata lácu luu nahua­ná̠tit acxni̠ nata­kalh­mak­ta̠­ya­yá̠tit, ");
INSERT INTO tocNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","porque a̠má quilh­ta­macú Espíri­tu Santo naca̠­ma̠­ca­tzi̠­ni̠yá̠n lácu luu nakalh­ti̠­na­ná̠tit. ");
INSERT INTO tocNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","La̠ta xtza­macán cha̠tum chixcú chiné huá­nilh: —Ma̠kalh­ta­hua­ke̠ná, cahuani quin­ta̠lá luu lac­xtum caquin­ta̠­ta­paj­pí­tzilh a̠má herencia hua̠ntu̠ quin­ca̠­mak­xtek­ni­ni̠tán quin­tla̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Pero Jesús chiné kálh­ti̠lh: —Kahua, ¿túcu xpa̠­la­cata qui­li̠­pu­tzaya aquit? Osuchí ¿tícu qui­hui­li̠ni̠t li̠juez nac milak­sti̠­pa̠ncán la̠qui̠ nac­ca̠­ma̠­paj­pi­tzi­niyá̠n hua̠ntu̠ kalhi̠­yá̠tit? ");
INSERT INTO tocNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Xlá chiné ca̠hua­nipá: —Luu cuentaj cat­la­huátit ni̠tu̠ naaktzan­ka̠­yá̠tit y nala­ka­ti̠­yá̠tit naka­lhi̠­pu­tu­ná̠tit luu lhu̠hua tumi̠n; porque a̠má li̠pa̠­xúhu xla­táma̠t cha̠tum, ni̠ antá li̠quilh­tzucuy para la̠ta xli̠­lhu̠hua xtumi̠n hua̠ntu̠ kalhi̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Y chiné ca̠huá­nilh eé takalh­chu­huí̠n: —Maktum quilh­ta­macú xuí cha̠tum chixcú pero luu xli̠­ca̠na rico xuani̠t, xka­lhi̠y lakatum xca̠­qui­huí̠n pero luu tla̠n xla­na̠nán, y antá chalh lhu̠hua cuxi y luu la̠n maká­lalh. ");
INSERT INTO tocNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Cumu luu lhu̠hua hua̠ntu̠ xma­ka­la­na̠­nani̠t a̠má rico chiné tzú­culh laca­pa̠s­taca: “¿Túcu cahuá nac­tla­huay, porque chú niaj ni̠ ní cma̠­qui̠y quin­cuxi?” ");
INSERT INTO tocNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Y chiné lac­púhua: “Huata mejor nac­lac­tilha hua̠ntu̠ xyá actzu̠ quim­pú̠­cuxi y tunu nac­tla­huay hua̠ntu̠ tlak lanca la̠qui̠ hua̠k antá nac­ma̠­qui̠y quin­cuxi y pu̠tum hua̠ntu̠ cka­lhi̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Y aca­li̠stá̠n chiné nacuaniy qui­li̠s­tacni: Chú luu lhu̠hua kalhi̠­yá̠hu tumi̠n hua̠ntu̠ namac­la­cas­qui­ná̠hu aklhu̠hua ca̠ta porque la̠n ca̠ma̠s­to­kuili̠­ni̠­táhu. Ni̠tu̠ cali̠­taaka­tzanke, huata mejor chú caj cajaxui, li̠huana̠ cahua̠­yáhu, cakot­núhu y luu capa̠­xu­huáhu.” ");
INSERT INTO tocNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero Dios xakát­li̠lh a̠má chixcú y chiné huá­nilh: “Xaaktzan­ka̠­tamá̠n chixcú huix, ni̠para tzinú catzi̠ya hua̠ntu̠ amá̠n okspu­layá̠n, la̠nchú eé ca̠tzi̠sní pímpa̠t ni̠ya, y chi̠nchú la̠ta xli̠­lhu̠hua hua̠ntu̠ ma̠qui̠­ni̠ta, ¿tícu xlá nahuán?” ");
INSERT INTO tocNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Pus xli̠­ca̠na chuná okspulay cha̠tum chixcú hua̠nti̠ luu lhu̠hua ma̠ak­sto­kuili̠y xtumi̠n uú nac ca̠quilh­ta­macú, pero nac xla­catí̠n Dios ni̠tu̠cu kalhi̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Aca­li̠stá̠n Jesús chiné ca̠huá­nilh xdis­cí­pulos: —Luu caaka­tá̠k­stit hua̠ntu̠ camá̠n ca̠hua­niyá̠n: Ni̠ luu cali̠­taaka­tzan­ké̠tit hua̠ntu̠ nahua­yá̠tit cha̠li cha̠lí xla­cata tla̠n nali̠­la­ta­pa̠­yá̠tit, ni̠para huá milha­ka̠tcán cali̠­taaka­tzan­ké̠tit hua̠ntu̠ nalha­ka̠­yá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Porque a̠tzinú luu lhu̠hua xta­palh qui­li̠s­tac­nicán ni̠ xachuná quin­ta­huajcán, y a̠tzinú luu lhu̠hua xta­palh quin­ti­yat­li̠­huacán ni̠ xachuná qui­lha­ka̠tcán. ");
INSERT INTO tocNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Caj luu caca̠ucxílhtit lactzu̠ spu̠n hua̠ntu̠ takosa ta̠lhmá̠n nac ca̠u̠ní̠n, xlacán ni̠ tacha­na̠nán, y ni̠para tax­ka̠nán, ni̠tu̠ taka­lhi̠y xpu̠­cu­xicán anta­nícu tama̠­qui̠y hua̠ntu̠ tamac­la­cas­quín; pero ma̠squi chuná Dios anka­lhi̠ná ca̠mak­ta̠­yama y ca̠ma̠­hui̠y. ¡Pus a̠tzinú hui­xinín mili̠s­tac­nicán luu lhu̠hua xta­palh ni̠ xachuná a̠ma̠ko̠lh lactzu̠ spu̠n! ");
INSERT INTO tocNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Caqui­la̠­hua­níhu, ¿tícu cahuá la̠ hui­xinín para ma̠rí liaka­ti­yuncán pi̠ tla̠n cahuá nama̠­li̠­hua­qui̠y ca̠na caj nícu akli̠t ca̠ta la̠ta lácu nala­tama̠y? ");
INSERT INTO tocNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Pero cumu ni̠lay ma̠t­la̠n­ti̠­yá̠tit hua̠ntu̠ luu ni̠para lhu̠hua tuncán, ¿túcu chú luu li̠la­yá̠tit li̠taaklhu̠­hui̠­ta­pa̠­yá̠tit ca̠ta catu̠huá? ");
INSERT INTO tocNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Caj luu caca̠ucxílhtit lak­li̠­la­káti̠t xánat lácua tas­taca. Xlacán ni̠ tas­cuja ni̠para tat­la­huay hua̠ntu̠ nata­li̠­lha­ka̠nán, pero luu laca­tancs cca̠­hua­niyá̠n pi̠ ni̠para a̠má xamaká̠n rey Salo­món ma̠squi luu lhu̠hua hua̠ntu̠ xka­lhi̠y lak­li̠­la­káti̠t xli̠­ta­ca̠xta̠y, ne̠cxni chuná li̠la­káti̠t lha­ká̠­nalh cumu la̠ tata­siyuy a̠ma̠ko̠lh xánat. ");
INSERT INTO tocNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Pus chú luu calac­pu­huántit, para Dios chuná ca̠ca̠x­ya̠­huay xánat chu xli̠­hua̠k li̠cúxtut hua̠ntu̠ taanán nac ca̠tu­huá̠n, ma̠squi xlá catzi̠y pi̠ la̠nchú luu lak­li̠­la­káti̠t ya̠ko̠lh pero caj li̠cha̠lí nax­nekko̠y y naca̠­ma̠­pu̠cán nac lhcúya̠t, ¿lácu pi̠ li̠huaca chú hui­xinín hua̠nti̠ xca­maná̠n ni̠ cati­ca̠­ma̠x­quí̠n hua̠ntu̠ nali̠­lha­ka̠­na­ná̠tit? ¿Túcu luu xpa̠­la­cata ni̠lay li̠pa̠­hua­ná̠tit? ");
INSERT INTO tocNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Pus luu laca­tancs cca̠­hua­niyá̠n pi̠ ni̠ luu cali̠­taaklhu̠­huí̠tit xla­cata hua̠ntu̠ nahua­yá̠tit, osuchí hua̠ntu̠ nali̠­kot­nu­ná̠tit cha̠li cha̠lí y ni̠ caj huá cali̠­li̠­pu­huántit. ");
INSERT INTO tocNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Porque xli̠­hua̠k cris­tianos hua̠nti̠ uú tala­má̠­nalh nac ca̠quilh­ta­macú y ni̠ tali̠­pa̠­huán Dios xlacán caj luu xma̠n huá tali̠­taaka­tzan­ke̠­má̠­nalh; pero ni̠ huá hui­xinín caca̠­maca­sta̠­látit hua̠ntu̠ xlacán tat­la­huay, porque hui­xinín kalhi̠­yá̠tit cha̠tum Min­tla̠­ticán hua̠nti̠ ca̠mak­ta­ka­lhá̠n xa̠huachí xlá aya catzi̠y hua̠ntu̠ hui­xinín mac­la­cas­quim­pá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Huata mejor tu̠ cca̠­hua­niyá̠n, pu̠lh huá calac­pu­tzátit y calak­tzak­sátit lácu Dios lacas­quín nala­ta­pa̠­yá̠tit y xlá catzi̠y lácu naca̠­mak­ta­ka­lhá̠n y naca̠­ma̠x­qui̠yá̠n hua̠ntu̠ mac­la­cas­quim­pá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Chiné ca̠hua­nipá: —Koxu­taní̠n hui­xinín quiamigos, ni̠ cape̠­cuántit, ma̠squi ni̠ milhu̠­huacán pero Dios hua̠nti̠ min­tla̠­ticán luu li̠pa̠­xu­huay pi̠ huá naca̠­ma̠­pek­si̠yá̠n xlianka­lhí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","La̠ta túcu kalhi̠­yá̠tit cas­tá̠tit y xatumi̠n caca̠­li̠­mak­ta̠­yátit hua̠nti̠ luu tamac­la­cas­qui­má̠­nalh; y chuná chú hui­xinín naca̠­li̠t­la­hua­yá̠tit hua̠ntu̠ xta̠­chuná cumu la̠ anta­nícu nama̠­qui̠­yá̠tit min­tu­mi̠ncán hua̠ntu̠ ne̠cxni lakuán, y chuná hui­xinín naka­lhi̠­yá̠tit cumu la̠ min­tu­mi̠ncán hua̠ntu̠ nali̠­pa̠­xu­hua­yá̠tit nac akapú̠n, xa̠huachí ne̠cxni cati­lák­sputli y ni̠para kalha̠ná tla̠n cati­maklh­tí̠n, ni̠para xalu̠hua cati­pá­salh hua̠ntu̠ nama̠­lak­sputuy. ");
INSERT INTO tocNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Porque anta­nícu hui­xinín nahui­li̠­yá̠tit min­ta­pa̠­xu­hua̠ncán cumu la̠ aktum min­tu­mi̠ncán pus na̠ antá nata­hui­la­ya̠chá mili̠s­tac­nicán. ");
INSERT INTO tocNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Luu xli̠­ca̠na ská­lalh cata̠­ta­hui­látit xapasán mili̠­mak­skocán. ");
INSERT INTO tocNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Xta̠­chuná cali̠­tax­tútit cumu la̠ a̠ma̠ko̠lh lacuán tasa̠cwá̠n hua̠nti̠ taka­lhi̠­má̠­nalh xpat­roncán acxni̠ naqui̠­tas­pita nac aktum pu̠ta­maka­xtokni, y la̠li̠­huán nata­ma̠­la­qui̠niy acxni̠ xlá nachín y natzucuy lakat­laka má̠lacchi. ");
INSERT INTO tocNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Luu xli̠­ca̠na taamá̠­nalh tamaka­pa̠­xu­huay xpat­roncán a̠ma̠ko̠lh tasa̠­cuá̠n hua̠nti̠ chu­na­tiyá tala­ca­hua̠­na­má̠­nalh y ni̠tu̠ talh­ta­ta­má̠­nalh naca̠­lak­chincán; y huata huá xpat­roncán naca̠­huaniy xla­cata cata­táhui anta­nícu yá mesa y natzucuy ca̠li̠s­cuja y acxtum naca̠­ta̠­hua̠yán. ");
INSERT INTO tocNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Porque ma̠squi luu íta̠t tzi̠sa osuchí acxni̠ aya xka­ka­ti̠­lhay cachilh, pero cumu ni̠tu̠ talh­ta­ta­má̠­nalh pus luu xli̠­ca̠na cata­pa̠­xú­hualh a̠ma̠ko̠lh tasa̠­cuá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Y na̠chuna li̠túm luu caca­tzí̠tit, para cha̠tum chixcú xcá­tzi̠lh túcuya̠ quilh­ta­macú ámaj lak­tanu̠y kalha̠ná, xli̠­ca̠na pi̠ luu ská­lalh xtáhui, chu­na­tiyá xla­ca­hua̠­nan­táhui y ni̠ clhtá­talh la̠quí ni̠ xmá̠s­ta̠lh tala­cas­quín nalak­ta­nu̠cán y namak­ka­lha̠­nancán. ");
INSERT INTO tocNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Pus na̠chuná chú hui­xinín luu ská­lalh cata­hui­látit, porque acxni luu ni̠ lia̠ca­tzi̠­hui­látit nac­mim­paray aquit Xata­lac­sacni Chixcú. ");
INSERT INTO tocNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Acxni̠ Jesús chu­hui̠­nan­ko̠lh, Pedro chiné kalhás­quilh: —Quim­pu̠­chi­nacán, a̠má takalh­chu­huí̠n hua̠ntu̠ huix hua̠nti̠, ¿pi̠ xli̠­hua̠k cris­tianos xala ca̠quilh­ta­macú ca̠hua­nípa̠t, osuchí caj xma̠n aquinín qui­la̠­hua­ni­ma̠­náhu hua̠nti̠ cca̠­ta̠­la­pu̠­layá̠n? ");
INSERT INTO tocNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Quim­pu̠­chi­nacán chiné kálh­ti̠lh: —Pus aquit pu̠tum cca̠­hua­nima hua̠nti̠ tla̠n xta­pu­hua̠ncán y hua̠nti̠ tas­cuj­ni­má̠­nalh Dios, na̠ luu xta̠­chuná cumu la̠ cha̠tum patrón acxni̠ ma̠pux­qui̠y cha̠tum xta­sa̠cua la̠qui̠ xlá naca̠­mak­ta­kalha y naca̠­ma̠­hui̠y acxni̠ nata­tzincsa xa̠maka­pi­tzí̠n xta­sa̠­cuá̠n porque xlá mákat anta­nícu ani̠t paxia̠lhnán. ");
INSERT INTO tocNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Pero xli̠­ca̠na luu li̠pa̠­xúhu naqui̠­tax­tuniy a̠má tasa̠cua acxni̠ nachín xpatrón y chuná xlá ma̠kan­tax­ti̠ma a̠má ta­scújut hua̠ntu̠ tili̠­ma̠­pek­sí̠­calh. ");
INSERT INTO tocNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Pus luu laca­tancs cca̠­hua­niyá̠n pi̠ a̠má patrón huata huá nama̠­cuentaj­li̠ko̠y xli̠­hua̠k hua̠ntu̠ xlá kalhi̠y nac xchic. ");
INSERT INTO tocNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero luu ni̠para tzinú tla̠n hua̠ntu̠ naok­spulay hua̠nti̠ ni̠tlá̠n xta­pu­huá̠n cha̠tum tasa̠cua, xlá nalac­pu­huán pi̠ ni̠naj pála catí­chilh xpatrón porque ma̠x namaka­palay; huata tu̠ xlá nat­la­huay caj natzucuy ca̠ma̠­pa̠­ti̠ni̠y maka­pi­tzí̠n tasa̠­cuá̠n, na̠chuná hua̠nti̠ antá tas­qui­ti­hui̠­na­má̠­nalh lac­pus­ca̠tní̠n, xa̠huachí caj natzucuy li̠huana̠ hua̠yán y natzucuy kota y la̠n naka­chi̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Cumu a̠má tasa̠cua chuná xlá lama, a̠má patrón caj xamaktum acxni̠ xlá nachín, pero cumu xlá ni̠para tzinú xlac­pu­huán para naminá, xlá ni̠tu̠ xka­lhi̠ma y ni̠ xli̠a̠ca­tzí̠hui para aya nalak­chincán, pus chuná xlá nama̠­pa̠­ti̠­ni̠cán cumu la̠ ca̠ma̠­pa̠­ti̠­ni̠cán hua̠k hua̠nti̠ taka­lha­kax­mat­makán Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Amá cris­tiano hua̠nti̠ catzi̠y hua̠ntu̠ lakati̠y xpatrón, pero cumu ni̠ ská­lalh huí, xa̠huachí cumu ni̠ li̠s­cuj­putún hua̠ntu̠ xlá li̠ma̠­pek­si̠cán pus la̠n nama̠­pa̠­ti̠­ni̠cán y nalak­sno­kuili̠cán. ");
INSERT INTO tocNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero a̠má tasa̠cua hua̠nti̠ ni̠ catzi̠y para ni̠tlá̠n hua̠ntu̠ tla­huama, y nat­la­huay hua̠ntu̠ mini̠niy nali̠­ma̠­pa̠­ti̠­ni̠cán, pus ni̠ luu xta̠­chuná cati­lak­sno­kuilí̠­calh. Porque a̠má cris­tiano hua̠nti̠ a̠tzinú lhu̠hua ma̠x­qui̠­cani̠t tala­ca­pa̠s­tacni la̠qui̠ tla̠n lhu̠hua nama̠­mak­ta­kalh­ni̠cán hua̠ntu̠ xlá nacuentajlay, pus na̠ a̠tzinú luu lhu̠hua amá̠­calh mak­pu­tzacán hua̠ntu̠ xlá nama­ca­ma̠sta̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jesús chiné ca̠hua­nipá: —Aquit cmini̠t ma̠lak­pasi̠y lhcúya̠t nac ca̠quilh­ta­macú, porque caj xpa̠­la­cata quin­ta­chuí̠n chú quin­ta­péksi̠t ámaj li̠tzucuy tasi̠tzi, y luu cla­cas­quín xlak­pa­salhá eé lhcúya̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pero pu̠lh amá̠­calh qui­liucxilhcán aktum tapa̠tí̠n para xli̠­ca̠na nac­ta̠­yaniy, pero luu xli̠­ca̠na cli̠­pu­huán xla­cata túcuya̠ quilh­ta­macú nalak­chá̠n acxni̠ hua̠k nakan­tax­tuko̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Hui­xinín ma̠x lac­pu­hua­ná̠tit pi̠ aquit cmini̠t mak­xteka tacác­suat chu tapa̠­xu­huá̠n nac ca̠quilh­ta­macú, pus huata luu cca̠­hua­niyá̠n pi̠ ni̠chuná porque caj quim­pa̠­la­cata nali̠­tzucuy tasi̠tzi, y nata­ta­paj­pi­tziy cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Porque nac aktum chiqui anta­nícu hui­lá­calh, li̠ka­lha­qui­tzis pu̠lactiy nata­taxtuy nata­ta­paj­pi­tziy caj quim­pa̠­la­cata, pu̠lactum li̠cha̠tiy y pu̠lactum li̠ka­lha­tutu y natzucuy tala̠­ma­ka­si̠­tzi̠y y nala̠­la­ca­ta̠­qui̠y sac­stucán. ");
INSERT INTO tocNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Cha̠tum kahuasa nata̠­la̠­ma­ka­si̠­tzi̠y xtla̠t, y na̠ xatla̠t na̠ nata̠­la̠­la­ca­ta­huacay xka­huasa; na̠chuná cha̠tum pusca̠t nata̠­la̠­ma­ka­si̠­tzi̠y xtzuma̠t, y a̠má tzuma̠t na̠ nata̠­la̠­la­ca­ta­huacay xtzí; y cha̠tum pusca̠t nata̠­la̠­ma­ka­si̠­tzi̠y xpusca̠t xka­huasa, y a̠má xapu̠­huiti na̠ nata̠­la̠­la­ca­ta̠­qui̠y xpu̠­ti­ya̠tzí. ");
INSERT INTO tocNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús ca̠hua­nipá cris­tianos: —Acxni̠ hui­xinín ucxi­lhá̠tit pi̠ tzucuy tapuc­sa̠chá pekán anta­nícu pulha̠chá chi­chiní, chiné hua­ná̠tit: “Chú la̠n namín si̠n”, y xli̠­ca̠na pi̠ chuná qui̠­taxtuy. ");
INSERT INTO tocNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Y acxni̠ suancaca mina̠chá u̠n pekán nac pa̠kalhú, hua­ná̠tit: “Chú luu la̠n nalh­ca̠cnán”, y ca̠na chuná qui̠­taxtuy. ");
INSERT INTO tocNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Aksa­ni̠­naní̠n! Para xli̠­ca̠na hui­xinín tla̠n ma̠lak­chi­pi­ni­yá̠tit lácu nata­huilay tan­tacú quilh­ta­macú acxni̠ tala­ca­ya̠­hua­yá̠tit y ucxi­lhá̠tit lácu tasiyuy akapú̠n chu ca̠quilh­ta­macú; cumu para xli̠­ca̠na tla̠n ucxi­lhá̠tit u̠má quilh­ta­macú ca̠li̠­ma̠­la­ca­hua̠­ni̠­pu­tuná̠n la̠nchú, ¿lácu chú ni̠ li̠ca­tzi̠­yá̠tit li̠huana̠ naaka­ta̠k­sá̠tit hua̠ntu̠ aya naca̠­lak­chiná̠n? ");
INSERT INTO tocNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Jesús ca̠hua­nipá a̠ma̠ko̠lh cris­tianos: —¿Túcu chi̠nchú xpa̠­la­cata ni̠ li̠lac­pu­tza­yá̠tit hui­xinín hua̠ntu̠ luu xli̠­ca̠na tla̠n nac mila­ta­ma̠tcán? ");
INSERT INTO tocNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Pus para cha̠tum min­ta̠­cris­tiano hua̠nti̠ ni̠ ta̠la̠ucxilh­pu­tuná̠n y chú amá̠n ma̠la­ca­pu̠yá̠n nac pu̠ma̠­peksí̠n, huata mejor laca­ti̠tum cata̠­la­ca̠xla nac tiji y cama̠­ko­xu­mixi la̠qui̠ ni̠ nama­ca­ma̠s­ta̠yá̠n nac xmacán juez; porque a̠má juez nama­ca­ma̠s­ta̠yá̠n nac xmacán policia, y policia nata­mac­nu̠yá̠n nac pu̠la̠­chi̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Y acxni̠ nata­nu̠­ya̠pi nac pu̠la̠­chi̠n antá ni̠ cati­taxtu hasta caní naxo­koya mimu̠lhta hua̠ntu̠ nas­qui­ni­cana. ");
INSERT INTO tocNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Caj li̠puntzú talak­ta­la­ca­tzú­hui̠lh anta­nícu xyá Jesús maka­pi­tzí̠n lac­chix­cu­huí̠n y tzú­culh tali̠­ta̠­kalh­chu­hui̠nán la̠ta lácu Pilato xca̠­ma̠­mak­ni̠­ni̠­nani̠t maka­pi­tzí̠n lac­chix­cu­huí̠n xalac Gali­lea; xlacán ca̠mak­ní̠­calh luu acxni̠ xta­mak­ni̠­má̠­nalh lactzu̠ taka­lhí̠n hua̠ntu̠ nata­li̠­la­ka­chix­cu­hui̠nán nac lanca pu̠si­culan xalac Jeru­salén, y luu lac­xtum tama̠s­tá­jalh xkalh­nicán la̠ xlá a̠ma̠ko̠lh lac­chix­cu­huí̠n chu xla lactzu̠ taka­lhí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús chiné ca̠kálh­ti̠lh: —¿Hui­xinín ma̠x lac­pu­hua­ná̠tit pi̠ Dios huá chuná ca̠li̠­ma̠ok­spú­li̠lh a̠ma̠ko̠lh lac­chix­cu­huí̠n xalac Gali­lea cumu a̠tzinú xlacán luu lhu̠hua xta­ka­lhi̠y xta­la̠­ka­lhi̠ncán ni̠ xachuná maka­pi­tzí̠n hua̠nti̠ na̠ antá tahui­lá̠­nalh? ");
INSERT INTO tocNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Pus luu xli̠­ca̠na pi̠ ni̠ huá xpa̠­la­cata, pero hui­xinín para ni̠ nalak­pa­li̠­yá̠tit xali̠xcáj­nit min­ta­la­ca­pa̠s­tac­nicán na̠chuná naca̠ok­spu­layá̠n napa̠­ti̠­na­ná̠tit mim­pu̠­tumcán nac xla­catí̠n Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Hui­xinín na̠ catzi̠­yá̠tit lácu táni̠lh a̠ma̠ko̠lh kalha­cu̠­tzayán lac­chix­cu­huí̠n acxni̠ ca̠actá­ma̠lh a̠má torre xalac Siloé; ¿na̠ ma̠x lac­pu­hua­ná̠tit pi̠ chuná ca̠ma̠ok­spú­li̠lh Dios porque xlacán a̠tzinú luu lhu̠hua xta­ka­lhi̠y xta­la̠­ka­lhi̠ncán y ni̠ xachuná maka­pi­tzí̠n xta̠­chi­quicán hua̠nti̠ xta­hui­lá̠­nalh nac Jeru­salén? ");
INSERT INTO tocNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Pus ni̠ huá chuná taliok­spú­lalh, pero para hui­xinín na̠ ni̠ nalak­pa­li̠­yá̠tit xali̠xcáj­nit min­ta­la­ca­pa̠s­tac­nicán, pus mim­pu̠­tumcán na̠chuná napa̠­ti̠­na­ná̠tit nac xla­catí̠n Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Y chiné ca̠huá­nilh eé takalh­chu­huí̠n: —Maktum quilh­ta­macú cha̠tum chixcú xchani̠t nac xpu̠­cuxtu akatum xaquihui higo y ca̠ta ca̠ta xan ucxilha chicá para aya huaca xta­huácat, pero acxni̠ xlá xqui̠­chá̠n ni̠tu̠cu xmac­laniy. ");
INSERT INTO tocNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Maktum quilh­ta­macú chiné huá­nilh xta­sa̠cua hua̠nti̠ xmak­ta­kalha a̠má pú̠cuxtu: “Kahua, chú aya xliaktutu ca̠ta la̠ta ctí­chalh eé quihui y tas­tuca cmin mak­pu­tzay para huaca xta­huácat, pero ne̠cxni a̠ cmac­laniy; huata mejor maktum catan­ca̠pi. ¿Túcu chú li̠ma­cuán caj xma̠n chuná akchi­pani̠t ca̠ti­yatni?” ");
INSERT INTO tocNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pero a̠má chixcú hua̠nti̠ xmak­ta­kalhma a̠má pú̠cuxtu chiné kálh­ti̠lh: “Patrón, huata mejor camak­xtek­ke̠ya ca̠na caj a̠huatá eé ca̠ta la̠qui̠ aquit nac­lak­pon­kaniy tíyat y na̠ nacuili̠niy abono. ");
INSERT INTO tocNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Chicá para xamaktum chuná nata­huacay xta­huácat, y a̠ca̠ta para ni̠ nata­huacay xta­huácat entonces tuncán nac­tan­ca̠mi̠y.” ");
INSERT INTO tocNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Maktum quilh­ta­macú sábado acxni̠ hua̠k judíos xta­jaxa, Jesús xca̠­ma̠­kalh­chu­hui̠­ni̠ma cris­tianos nac xpu̠­si­cu­lancán. ");
INSERT INTO tocNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Na̠ antá xta­nu̠ma cha̠tum pusca̠t, xlá aya xka­lhi̠yá akcu̠­tzayán ca̠ta la̠ta xma̠­chi­pi̠ni̠t tajátat xes­pí­ritu akska­huiní, y chu­na­tiyá xlama ni̠lay xtaactzaja aya lhko­nu̠tua xuanko̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Acxni̠ Jesús úcxilhli, tasá­nilh y chiné huá­nilh: —Na̠na, xli̠­hua̠k min­ta­játat la̠nchú aquit nac­ma̠t­la̠n­ti̠­niyá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Li̠mac­chí­palh xmacán, y acxni tuncán a̠má pusca̠t tla̠n taáctzajli y tat­lá̠n­ti̠lh, xlá tzú­culh pa̠x­cat­ca­tzi̠niy Dios hua̠ntu̠ xli̠t­la­huani̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero a̠má chixcú hua̠nti̠ xak­chu­hui̠nán nac xpu̠­si­cu­lancán judíos sí̠tzi̠lh porque Jesús xma̠t­la̠n­ti̠­nani̠t a̠má quilh­ta­macú acxni̠ xli̠­hua̠k judíos xta­jaxa, y chiné ca̠huá­nilh cris­tianos: —Kalhi̠­yá̠tit akcha̠xán quilh­ta­macú la̠ta lácu hua̠k tla̠n nas­cu­já̠hu, huata mejor acxni̠ nata­ná̠tit la̠qui̠ tla̠n naca̠­ma̠t­la̠n­ti̠­ni­ca­ná̠tit min­ta­ja­tatcán, y ni̠ huata acxni̠ nata­ná̠tit acxni̠ lak­cha̠ni̠t quilh­ta­macú la̠ta lácu jaxcán. ");
INSERT INTO tocNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Pero Quim­pu̠­chi­nacán Jesús chiné kálh­ti̠lh: —¡Aksa­ni̠­naní̠n lac­chix­cu­huí̠n hui­xinín! Chú caqui­la̠­hua­níhu, ¿Pi̠ ni̠ xcu­tá̠tit hui­xinín mibur­rujcán osuchí mihua̠­caxcán acxni̠ lak­cha̠ni̠t quilh­ta­macú sábado acxni̠ ni̠ti̠cu scuja la̠qui̠ nama̠­kot­ni̠­yá̠tit? ");
INSERT INTO tocNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Pus chú li̠huana̠ cala­ca­pa̠s­táctit, porque eé pusca̠t na̠ huá xli̠­ta­la­ka­pasni xamaká̠n Abraham na̠chuná cumu la̠ hui­xinín, pero xlá aya xka­lhi̠y akcu̠­tzayán ca̠ta la̠ta xes­pí­ritu akska­huiní xma̠­tzu­qui̠ni̠t xta­pa̠tí̠n, ¿lácu pi̠ ni̠tlá̠n chú aquit nac­xcut­makaniy xli̠t­li­hueke akska­huiní eé quilh­ta­macú acxni̠ li̠huancán para tícu nas­cuja? ");
INSERT INTO tocNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Acxni̠ chuná huan­ko̠lh eé tachu­huí̠n a̠ma̠ko̠lh lac­chix­cu­huí̠n hua̠nti̠ xta­si̠­tzi̠niy Jesús luu la̠n tala­ca­ma̠­xá­nalh; pero la̠ta xli̠­lhu̠hua cris­tianos luu tzú­culh tali̠­pa̠­xu­huay hua̠ntu̠ xlá xca̠t­la­huama lac­lanca xta­scújut. ");
INSERT INTO tocNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Chiné xlá ca̠hua­nipá: —¿Túcu xta̠­chuná tla̠n nata̠­ma̠­la­cas­tu­cá̠hu xasa̠sti xta­páksi̠t Dios hua̠ntu̠ ma̠tzu­qui̠­putún nac ca̠quilh­ta­macú, osuchí túcu xta̠­chuná? ");
INSERT INTO tocNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Xta̠­chuná naqui̠­taxtuy cumu la̠ acxni̠ cha̠tum chixcú an chan nac xca̠­tu­huá̠n aktum xatalhtzi mos­taza. La̠ta xli̠­hua̠k qui­huí̠n huá xlá a̠tzinú luu actzú ma̠sta̠y xtalhtzi, pero xlá acxni̠ tzucuy staca luu lanca quihui huan y xli̠­hua̠k lactzu̠ spu̠n hua̠ntu̠ takosa nac ca̠u̠ní̠n, nac xakaní̠n tla̠n tat­la­huay xma̠­se­kecán. ");
INSERT INTO tocNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesús chiné ca̠hua­nipá: —¿Túcu cahuá tla̠n nata̠­ma­lac­xtu­mi̠­yá̠hu xasa̠sti xta­pe̠ksi̠t Dios hua̠ntu̠ xlá ma̠tzu­qui̠ma? ");
INSERT INTO tocNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ma̠x xta̠­chuná qui̠­taxtuy cumu la̠ a̠má leva­dura, acxni̠ cha̠tum pusca̠t ta̠lak­ko­chi­pa̠s­pita pa̠tutu tapu̠lhca harina, a̠má leva­dura laka­siyu tzucuy scuja hasta acxni̠ nama̠­ko­nuko̠y xli̠­pu̠tum squítit. ");
INSERT INTO tocNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Acxni̠ Jesús xtla̠­huama nac tiji xama pekán nac Jeru­salén, xlá xca̠­ma̠­kalh­chu­hui̠ni̠y cris­tianos la̠ta nac aka­tunu ca̠chi­quí̠n chu anta­nícu xuila­ko̠lh lactzu̠ ca̠tu­huá̠n anta­nícu xlá xlac­tla̠­huama. ");
INSERT INTO tocNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Y cha̠tum chixcú chiné kalhás­quilh: —Quim­pu̠­chi­nacán, ¿pi̠ ni̠ luu lhu̠hua hua̠nti̠ cati­ta­lak­má̠x­tulh xli̠s­tac­nicán nac xla­catí̠n Dios? Jesús chiné ca̠huá­nilh: ");
INSERT INTO tocNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Luu laca­tancs cca̠­hua­niyá̠n pi̠ hua̠nti̠ lak­ma̠x­tu­putún xli̠s­tacni luu juerza cat­la­huá­nilh catzák­salh antá nalac­tanu̠y nac xapi̠tzu̠ má̠lacchi. Porque xli̠­ca̠na cca̠­hua­niyá̠n pi̠ lhu̠hua hua̠nti̠ nata­ta­nu̠­putún pero ni̠lay cati­ta­ma̠t­lá̠n­ti̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Porque acxni̠ Mim­pu̠­chi­nacán nama̠­lac­chu­huay má̠lacchi niaj lay cati­ta­nú̠tit. Y hui­xinín hua̠nti̠ layá̠tit nahuán nac quilhtí̠n nala­kat­la­ká̠tit má̠lacchi y chiné nahua­ná̠tit: “Quim­pu̠­chi­nacán, cat­lahua li̠tlá̠n caqui­la̠­ma̠­la­qui̠­níhu.” Pero xlá chiné naca̠­kalh­ti̠yá̠n: “Aquit ni̠para tzinú cca̠­la­ka­pasá̠n tícu hui­xinín.” ");
INSERT INTO tocNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Y hui­xinín chiné natzu­cu­yá̠tit hua­ni­yá̠tit: “Aquinín lac­xtum cca̠­ta̠­hua̠­ya­ni̠tán y na̠ xac­kax­ma­tá̠hu min­ta­chu­huí̠n acxni̠ huix xca̠­ma̠­kalh­chu­hui̠­ní̠pa̠t cris­tianos nac quin­ca̠­chi­qui̠ncán.” ");
INSERT INTO tocNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Xlá chiné naca̠­kalh­ti̠yá̠n: “¡Cata­tam­pu̠x­tútit uú pu̠tum hui­xinín hua̠nti̠ li̠­scuj­pá̠tit hua̠ntu̠ ni̠tlá̠n! Aya cca̠­huanín pi̠ ni̠ cca̠­la­ka­pasá̠n para qui­la̠­li̠­pa̠­hua­ná̠hu.” ");
INSERT INTO tocNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Anta­nícu hui­xinín naca̠­ma­ca­chi­pin­ca­ná̠tit nalac­sa̠nán min­ta­tzancán caj xpa̠­la­cata lanca tapa̠tí̠n, y antá pu̠tum nata­sa­yá̠tit acxni̠ a̠li̠mákat naucxi­lhá̠tit a̠ma̠ko̠lh xalak­maká̠n mili̠­ta­la­ka­pas­nicán Abraham, Isaac, Jacob chu xli̠­hua̠k pro­fetas, xlacán antá tahui­la̠­nanchá nahuán nac xpa̠xtú̠n Dios nac akapú̠n, pero chi̠nchú hui­xinín ca̠ta­mac­xtu­ca­ni̠­tántit nahuán nac quilhtí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Y na̠chuná nali̠­pu­hua­ná̠tit acxni̠ hui­xinín naucxi­lhá̠tit nac akapú̠n ti̠pa̠­katzi cris­tianos xala cani̠huá xli̠­ca̠­lanca ca̠quilh­ta­macú tacha̠ni̠t nahuán la̠qui̠ antá quilh­xtum nata­mak­ta­huilay nac xmesa Dios y hua̠k nata­ma­kua̠yán. ");
INSERT INTO tocNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Antacú luu lhu̠hua cris­tianos hua̠nti̠ la̠nchú ni̠tu̠cu xka­satcán nac ca̠quilh­ta­macú luu lac­ta­li̠­pa̠huá nata­li̠­taxtuy nac xla­catí̠n Dios, y na̠chuna li̠túm lhu̠hua hua̠nti̠ la̠nchú luu lac­ta­li̠­pa̠hu nac ca̠quilh­ta­macú pero nac xla­catí̠n Dios ni̠tu̠cu xka­satcán cati­ta­li̠­táx­tulh. ");
INSERT INTO tocNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Caj li̠puntzú tachilh maka­pi­tzí̠n fariseos y chiné tahuá­nilh Jesús: —Huata mejor xatlá̠n nahuán cata­tam­pu̠xtu capit a̠laca­tunu ca̠chi­quí̠n porque rey Herodes mak­ni̠­pu­tuná̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Pero xlá chiné ca̠kálh­ti̠lh: —Huata mejor caqui̠­hua­ni­pítit tamá mañoso chixcú pi̠ la̠nchú aquit nac­ca̠­mak­ta̠yay cris­tianos hua̠nti̠ ca̠maka­tla­jani̠t xes­pí­ritu akska­huiní y na̠chuná nac­ca̠­ma̠t­la̠nti̠y hua̠nti̠ tata̠­tatlay xli̠­makua la̠nchú tla̠n, porque a̠huayu cha̠lí o tu̠xama lako̠ni̠t nahuán pu̠tum quin­ta­scújut. ");
INSERT INTO tocNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Cumu juerza nac­chá̠n anta­nícu cama, pus huá xpa̠­la­cata la̠nchú chu cha̠lí y hasta ma̠x tu̠xama ctla̠­huan­ti̠­lhay nahuán la̠qui̠ nac­chá̠n nac Jeru­salén, porque ni̠ lak­chá̠n namak­ni̠cán cha̠tum pro­feta cumu la̠ aquit para ni̠ juerza antá. ");
INSERT INTO tocNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jesús tzú­culh li̠pu­huán nac xnacú y chiné chu­huí̠­nalh: —¡Jeru­salén, koxu­tacú quin­ca̠­chi­quí̠n Jeru­salén! Antá uú ca̠mak­ni̠­cani̠t lhu̠hua luu lac­ta­li̠­pa̠hu pro­fetas y na̠ ca̠acta­lan­chi­pa­cani̠t lhu̠hua akchu­hui̠­naní̠n hua̠nti̠ Dios ca̠ma­ca­mini̠t. Aquit mak­lhu̠hua ctzak­sani̠t cca̠­ma̠­mac­xtu­mi̠­putún xli̠­hua̠k min­ca­mancán, cumu la̠ lactzú xalak­skata xti̠la̠n ca̠ma̠­mac­xtumi̠y xtzí nac xtampí̠n xpeke, pero xlacán ni̠ tala­cás­quilh. ");
INSERT INTO tocNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Pus chú niaj maka̠s quilh­ta­macú huata nac lanca pusi­culan antá xala, ca̠ta caj chu­natá nata­ta­mak­xteka y niaj ti̠ tanu̠maj catíhua antá. Pero aquit laca­tancs cca̠­hua­niyá̠n pi̠ niaj caquin­ti­la̠ucxi­lhui hasta acxni̠ nalak­chá̠n quilh­ta­macú la̠ hui­xinín naqui­la̠­maka­maklhti̠­na­ná̠hu y nahua­ná̠tit: “¡Luu li̠pa̠­xúhu hua̠nti̠ mima nac xta­cu­huiní Quim­pu̠­chi­nacán la̠qui̠ huá nama̠­kan­taxti̠y xta­scújut!” ");
INSERT INTO tocNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Maktum quilh­ta­macú acxni̠ hua̠k xjaxcán Jesús alh makua̠yán nac xchic cha̠tum xapuxcu fariseo; pero maka­pi­tzí̠n fariseos xtas­ka­laj­má̠­nalh chicá para nama̠t­la̠n­ti̠nán a̠má quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Na̠ antá xuí cha̠tum chixcú hua̠nti̠ xka­lhi̠y aktum tajátat y xli̠­lanca nac xmacni xcun­ko̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Cumu Jesús xca­tzi̠y hua̠ntu̠ xlacán xta­lac­pu­hua­má̠­nalh chiné ca̠ka­lhás­quilh fariseos chu xma̠­kalh­ta­hua­ke̠­nacán judíos hua̠nti̠ antá xta­la­má̠­nalh: —¿Lácu hui­xinín hua­ná̠tit, pi̠ lak­chá̠n cahuá xla­cata tla̠n nama̠­pac­sacán cha̠tum ta̠tatlá acxni̠ lak­cha̠ni̠t quilh­ta­macú la̠ta jaxcán, osuchí ni̠tlá̠n? ");
INSERT INTO tocNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pero a̠ma̠ko̠lh fariseos cacs taqui­lhua niaj tachu­huí̠­nalh huata xlá li̠mac­xá­malh xmacán a̠má ta̠tatlá acxni tuncán xlá pacsli. Aca­li̠stá̠n huá­nilh pi̠ caalhá nac xchic. ");
INSERT INTO tocNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Y a̠ma̠ko̠lh fariseos chiné ca̠huá­nilh: —Chú caqui­la̠­hua­níhu, para hui­xinín kalhi̠­yá̠tit miburro osuchí mihuá̠cax y para nata­ju̠­ya̠chá nac aktum pozo, ¿lácu pi̠ ni̠ la̠li̠­huán tuncán cati­ma̠­cu­tútit la̠qui̠ ni̠ najic­suay y nani̠y, ma̠squi luu lak­cha̠ni̠t quilh­ta­macú sábado acxni̠ li̠huancán para tícu nas­cuja? ");
INSERT INTO tocNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pero xlacán ni̠ tacá­tzi̠lh lácu nata­kalh­ti̠nán. ");
INSERT INTO tocNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Acxni̠ Jesús ca̠úcxilhli xa̠maka­pi­tzí̠n taputza la̠ta lácua xlacán xta­lac­sac­má̠­nalh xala­cuán pu̠tá­hui̠lh anta­nícu xya̠­hua­cani̠t mesa la̠qui̠ nata­ma­kua̠yán, xlá chiné ca̠li̠­ma̠­kalh­chu­huí̠­ni̠lh eé takalh­chu­huí̠n: ");
INSERT INTO tocNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Aquit luu laca­tancs cca̠­hua­niyá̠n, acxni̠ hui­xinín naca̠­pu­tza­ca­ná̠tit la̠qui̠ napi­ná̠tit nac aktum pu̠pa̠xcua anta­nícu tamaka­xtok­ma̠ca, huix ni̠ lacán camak­ta­huila anta­nícu hui­la­ko̠lh xala­cuán pu̠tá­hui̠lh, porque chicá para xamaktum nachín cha̠­tum­li̠túm taputza hua̠nti̠ a̠tzinú luu tlak li̠la­ka­pascán ni̠ xachuná huix. ");
INSERT INTO tocNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Amá chixcú hua̠nti̠ hua­ni­ni̠tán nalak­pina, aya nami­na̠­chá̠n hua­niyá̠n: “Cat­lahua li̠tlá̠n cata̠ya la̠ta huila y cama̠xqui milac­tá­hui̠lh u̠má cha̠­tum­li̠túm quin­ta­putza.” Y huata huix cha̠­ma̠­xanaj nata̠­yaya, juerza napina lac­ta­hui­laya hua̠ntu̠ a̠huatá hui­lachá lac­tá­hui̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Huata mejor acxni̠ hui­xinín naca̠­hua­ni­ca­ná̠tit xla­cata capítit mak­pa̠x­cuajna­ná̠tit, huata mejor a̠huata capit tahui­laya hua̠ntu̠ mákat tahui­la̠­nanchá lac­tá­hui̠lh la̠qui̠ acxni̠ namín hua̠nti̠ hua­ni­ni̠tán xla­cata nalak­pina nac pu̠pa̠xcua, y chiné nahua­niyá̠n: “Amigo, cat­lahua li̠tlá̠n cata­la­ca­tzuhui nac mesa antá la̠ a̠tahui­lá̠­nalh maka­pi­tzí̠n.” Pus huata huix na̠ luu tali̠­pa̠hu nata­li̠­ma̠x­tuyá̠n hua̠nti̠ tahui­lá̠­nalh nac mesa. ");
INSERT INTO tocNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Porque aquit laca­tancs cca̠­hua­niyá̠n pi̠ hua̠nti̠ sacstu maklh­ca­tzi̠cán pi̠ luu tali̠­pa̠hu sacstu taak­ska­hui­tama̠y mákat ma̠tu̠­tzu­hui̠cán; pero hua̠nti̠ ni̠tu̠cu xkásat li̠taxtuy pus huata huá tlak tali̠­pa̠hu li̠taxtuy y ma̠x­qui̠cán xala­cuán pu̠tá­hui̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Y a̠má xapuxcu fariseo hua̠nti̠ xuanini̠t nalakán nac xchic chiné li̠ma̠­kalh­chu­huí̠­ni̠lh: —Acxni̠ huix nat­la­huaya aktum pu̠pa̠xcua y huij nahuán lhu̠hua tahuá nac mín­chic, ni̠ huá caca̠­huani cata­lakmín caj xma̠n miamigos, osu para mina­ta̠lán, osuchí para mili̠­ta­la­ka­pasni, o hua̠nti̠ min­ta̠­la­ca­tzuní̠n y hua̠nti̠ na̠ lac­rrico; porque acxni̠ xlacán natat­la­huay aktum pu̠pa̠xcua pus na̠ nata­hua­niyá̠n pi̠ caca̠­lakpi y chuná chú huix nama­ka­xo­ko­cana. ");
INSERT INTO tocNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pus huata acxni̠ huix nat­la­huaya aktum pu̠pa̠xcua xatlá̠n huá caca̠­huani hua̠nti̠ lac­pobre, hua̠nti̠ lak­li̠­ma̠x­kení̠n, hua̠nti̠ ni̠lay tas­cuja, chu hua̠nti̠ talu̠n­tu̠­hua­nani̠t, xa̠hua xli̠­pacs hua̠nti̠ laka­tzí̠n tala­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Pus chuná chú huix luu li̠pa̠­xúhu lápa̠t nahuán porque xlacán ni̠lay cati­ta­xo­ko̠­nunín, pero Dios ucxilhmá̠n y huá nama̠x­qui̠yá̠n min­tas­kahu acxni̠ nalak­chá̠n a̠má quilh­ta­macú lácu xlá naca̠­ma̠­laca­stac­uani̠y nac ca̠li̠ní̠n xli̠­hua̠k xca­maná̠n hua̠nti̠ tla̠n xta­pu­hua̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Cha̠tum chixcú hua̠nti̠ antá mac­xtum xta­hui­lá̠­nalh nac mesa acxni̠ chuná kax­mat­ko̠lh eé tachu­huí̠n chiné huá­nilh Jesús: —Pero luu ca̠na li̠pa̠­xúhu a̠má chixcú hua̠nti̠ tla̠n nama­kua̠ya­na̠­chá̠n nac xpa̠xtú̠n Dios nac akapú̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Pero Jesús chiné ca̠huá­nilh: —Maktum quilh­ta­macú cha̠tum chixcú tlá­hualh aktum lanca pu̠pa̠xcua y ánca ca̠ma̠­ca­tzi̠­ni̠cán xta­putza hua̠nti̠ nata­lakmín. ");
INSERT INTO tocNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Acxni̠ aya accha̠ná xuí tahuá ca̠má­ca̠lh maka­pi­tzí̠n xlac­scujni y ca̠huá­nilh xla­cata naán ca̠huaniy a̠ma̠ko̠lh taputza pi̠ la̠li̠­huán cata­milhá porque xaaccha̠ná xuí tahuá. ");
INSERT INTO tocNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero hua̠nti̠ ca̠qui̠­lak­lá­ca̠lh tzú­culh tas­quín xma̠­tzan­ke̠­na­ni­cacán. Cha̠tum hua̠nti̠ pu̠lh lak­chá̠n­calh chiné huá: “Luu xli̠­ca̠na cahua­nipi pi̠ cat­lá­hualh li̠tlá̠n caqui­ma̠­tzan­ke̠­ná­nilh, pero a̠cu cta­ma̠­hua­ko̠lh aktum par­cela, pus la̠nchú juerza nacán ucxilha.” ");
INSERT INTO tocNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Cha̠­tum­li̠túm chiné huampá: “Pun­tzu̠cú cca̠­ta­má̠hua tan­qui­tzis qui­huá̠cax, la̠nchú cámaj ca̠li̠­tzaksay nacuc­xilha para tla̠n tapon­ka̠nán; luu hasta li̠tlá̠n csqui­niyá̠n xla­cata caqui­ma̠­tzan­ke̠­nani porque ni̠lay cana̠chá.” ");
INSERT INTO tocNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Y cha̠tum chi̠né huampá: “Na̠ la̠n­chujcú cta­ma­káx­tokli y xli̠­ca̠na ni̠lay chú cla­ka­na̠­chá̠n, pus caqui­ma̠­tzan­ke̠­nani.” ");
INSERT INTO tocNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Acxni̠ tás­pitli a̠má lac­scujni hua̠k hua­ni­ko̠lh xpatrón lácua hua­ni­canchá. Amá chixcú la̠n sí̠tzi̠lh y chiné huá­nilh xta­sa̠cua: “La̠li̠­huán capimpi nac xli̠­ca̠­lanca ca̠chi­quí̠n, chu nac tiji y caca̠­hua­nítit catá­milh hua̠nti̠ lac­pobre, chu hua̠nti̠ ni̠lay tas­cuja, hua̠nti̠ talu̠n­tu̠­hua­nani̠t, chu hua̠nti̠ laka­xo̠kó̠n.” ");
INSERT INTO tocNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Caj li̠puntzú acxni̠ a̠má tasa̠cua qui̠­tás­pitli, chiné huá­nilh xpatrón: “Patrón, chuná chú ctlá­hualh la̠ huix qui­huani, pero luu lhu̠­huacú tzanka̠y hua̠nti̠ tla̠n xta­huá̠­yalh.” ");
INSERT INTO tocNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Amá patrón chiné hua­nipá: “Pus capim­pa­rapi nac ca̠ti­ji̠ní̠n chu nac xqui­lhapá̠n ca̠chi­quí̠n, juerza caca̠­hua­nítit xa̠maka­pi­tzí̠n cati̠hua̠ cris­tianos xla­cata pi̠ catá­milh láqui̠ chuná hua̠k nala­ta­hui­la­ko̠cán nac xli̠­ca̠­lanca nac quín­chic. ");
INSERT INTO tocNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Porque xli̠­ca̠na cca̠­hua­niyá̠n pi̠ niaj cla­cas­quín ni̠para cha̠tum hua̠nti̠ aquit xac­ca̠­hua­nini̠t xla­cata naquin­ta­lakmín, y niaj cati­tá­hualh u̠má quin­tahuá hua̠ntu̠ aquit la̠nchú cca̠x­tla­huani̠t.” ");
INSERT INTO tocNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Cumu luu lhu̠hua cris­tianos xta­sta̠­la­ni­má̠­nalh Jesús huata maktum xlá laca­tancs ca̠huá­nilh: ");
INSERT INTO tocNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Para tícu luu quis­ta̠­la­ni­putún y ni̠ aktum ca̠pa̠x­tek­putún para xtla̠t chu xtzí, osuchí xpusca̠t, o xcamán, osuchí xna­ta̠lán, y xa̠huachí para ni̠ aktum catzi̠y napa̠x­teka xla­táma̠t, ni̠lay cati­li̠­tá­nu̠lh cumu la̠ quin­ta­ma̠­kalh­ta­huaké̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Y hua̠nti̠ ni̠ aktum catzi̠y nacucay xcruz y naquis­ta̠­laniy ma̠squi cali̠­ma­ca­má̠s­ta̠lh xla­táma̠t, xlá ni̠lay li̠ta­pu̠lhca̠y cumu la̠ quin­ta­ma̠­kalh­ta­huaké̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Huata pu̠lh la̠n cala­ca­pá̠s­tacli a̠má cris­tiano hua̠nti̠ quis­ta̠­la­ni­putún, na̠ luu xta̠­chuná qui̠­taxtuy cumu la̠ acxni̠ cha̠tum chixcú la̠ hui­xinín tla­hua­putún aktum lanca xchic, huata pu̠lh caj cúlucs nata­huilay la̠qui̠ nat­la­huay xcuenta para nama­kaacchá̠n xtumí̠n hua̠ntu̠ naca̠­li̠­ta­ma̠­huay la̠ta túcua namac­la­cas­quín y xa̠huachí para na̠ nama­kaacchá̠n xtumi̠n hua̠ntu̠ nali̠­ma̠akas­putuy. ");
INSERT INTO tocNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Huá chuná li̠t­la­huay la̠qui̠ ni̠ aca­li̠stá̠n acxni̠ aya ma̠pu­lhu­ni̠ttá nahuán xpá̠­tzaps niaj lay cati­ma̠akas­pú­tulh, y xli̠­hua̠k hua̠nti̠ nataucxilha caj nata­li̠­kalh­ka­ma̠nán, ");
INSERT INTO tocNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","y chiné nata­huán: “Tamá chixcú ma̠x caj laka­hui­tima, luu tla̠n tima̠­tzú­qui̠lh xpá̠­tzaps pero chú niaj lay ma̠akas­putuy xchic.” ");
INSERT INTO tocNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Y na̠chuna li̠túm para cha̠tum gobier­no amá̠­calh ta̠t­la­huacán guerra y mima cha̠­tum­li̠túm gobier­no a̠laca­túnuj xalá, ¿lácu pi̠ ni̠ huata pu̠lh tla̠n nala­ca­pa̠s­taca para tla̠n nali̠­maka­tlajay caj akcá̠hu mi̠lh tropa hua̠ntu̠ xlá kalhi̠y, porque hua̠nti̠ mima xlá li̠mín akpuxam mi̠lh? ");
INSERT INTO tocNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Y para xlá laca­tancs naca­tzi̠y pi̠ ni̠lay cati­maka­tlá­jalh, pus acxni̠ makatcú mima̠chá nahuán hua̠nti̠ mímaj laca­ta̠­qui̠y tasi̠tzi, huata a̠má gobier­no naca̠­macá̠n xlac­scujni la̠qui̠ naancán hua­nicán hua̠nti̠ mima: “Huata mejor calác­lalh tasi̠tzi acxtum cala­ca̠x­láhu y ni̠ cala̠­si̠­tzi̠­níhu.” ");
INSERT INTO tocNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Pus na̠chuná chú hui­xinín hua̠nti̠ xli̠­ca̠na quis­ta̠­la­ni­putún, pu̠lh laca­tancs caca­tzí̠tit pi̠ hua̠nti̠ ni̠ namak­xteka hua̠ntu̠ kalhi̠y uú nac ca̠quilh­ta­macú pus ni̠lay li̠ta­pa̠­cu­hui̠y luu xli̠­ca̠na quin­ta­ma̠­kalh­ta­huaké̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Hui­xinín catzi̠­yá̠tit pi̠ mátzat li̠ma­cuán porque li̠ma̠s­ko­ke̠­nancán, pero para tamá mátzat cspút­nilh xli̠s­koko niaj tu̠ cati­li̠­mácua, ¿lácu pi̠ tla̠n cahuá chú nati­li̠­ma̠s­ko­ke̠­nancán? ");
INSERT INTO tocNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Pus niaj tícu li̠ma­cuaniy ma̠squi luu tíyat niaj tu̠ li̠lay, y na̠chuná ma̠squi luu xlak­ma­cá̠n­calh abono. Pus cumu niaj tu̠ li̠ma­cuán luu laca­tancs pi̠ caj namakan­cán. ¡Hui­xinín hua̠nti̠ li̠kax­pat­pá̠tit min­ta­ke̠ncán, luu caaka­tá̠k­stit quin­ta­chu­huí̠n! ");
INSERT INTO tocNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Anta­nícu xak­chu­hui̠nán Jesús lhu̠hua hua̠nti̠ xtamín takax­matniy xta­chu­huí̠n, xma̠­la­ka­xo­ke̠­naní̠n im­pues­tos xa̠hua maka­pi­tzí̠n lac­chix­cu­huí̠n hua̠nti̠ judíos xta­lac­pu­huán pi̠ luu a̠tzinú mak­la̠­ka­lhi̠­naní̠n xta­huani̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Caj luu huá xpa̠­la­cata a̠ma̠ko̠lh fariseos chu xma̠­kalh­ta­hua­ke̠­nacán judíos ma̠rí xtaaksán y chiné xta­huán: —Eé chixcú hua̠k ca̠ta̠­ta­lak­xtumi̠y ma̠squi hua̠nti̠ mak­la̠­ka­lhi̠­naní̠n xa̠huachí xlá acxtum ca̠ta̠­hua̠yán. ");
INSERT INTO tocNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Y la̠qui̠ nataaka­ta̠ksa túcu xpa̠­la­cata xlá suluj xca̠­ta̠lay a̠ma̠ko̠lh cris­tianos, Jesús ca̠li̠­ma̠­kalh­chu­huí̠­ni̠lh eé takalh­chu­huí̠n: ");
INSERT INTO tocNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Para cha̠tum chixcú kalhi̠y aktum ciento xbor­regos y para xamaktum nama­ka­tzanka̠y tantum, ¿túcu cahuá nat­la­huay? ¿Lácu pi̠ ni̠ cati­ca̠­mák­xtekli nac ca̠tu­huá̠n xa̠maka­pi­tzí̠n ta̠ti­pu­xa­ma­cu̠­na­ja̠tza la̠qui̠ tuncán la̠li̠­huán naán putzay a̠má koxutá bor­rego hua̠nti̠ maka­tzan­ka̠ni̠t y ni̠ cati­tás­pitli nac xchic hasta caní namaclay? ");
INSERT INTO tocNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Acxni̠ naqui̠­maclay, nahuili̠y nac xak­lhtam­pixni caj la̠ta xta­pa̠­xu­huá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Y acxni̠ nachá̠n nac xchic pu̠tum naca̠­ma̠­ke̠s­toka xamigos chu hua̠nti̠ xta̠­la­ca­tzuní̠n y chiné naca̠­huaniy: “Cat­la­huátit li̠tlá̠n caqui­la̠­ta̠­pa̠­xu­huáhu la̠nchú porque aya cmac­lani̠t a̠má qui­bor­rego hua̠ntu̠ aquit xac­ma­ka­tzan­ka̠ni̠t.” ");
INSERT INTO tocNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Pus xli̠­ca̠na aquit cca̠­hua­niyá̠n pi̠ na̠chuná qui̠­taxtuy nac akapú̠n acxni̠ tala­má̠­nalh nac ca̠quilh­ta­macú aktum ciento cris­tianos, y para cha̠tum nachipay hua̠ntu̠ ni̠ xatlá̠n tiji anta­nícu nalak­tzanka̠y, y acxni̠ lak­pali̠y xta­la­ca­pa̠s­tacni y li̠pa̠­huam­paray Dios. Pus nac akapú̠n luu lhu̠hua anán tapa̠­xu­huá̠n caj xpa̠­la­cata eé chixcú hua̠nti̠ qui̠­tás­pitli anta­nícu ni̠tlá̠n y ni̠ xachuná caj xla­ca­tacán a̠ma̠ko̠lh cris­tianos hua̠nti̠ xata̠­ti­pu­xa­ma­cu̠­na­ja̠tza cumu xlacán tla̠na xta­pu­hua̠ncán y ni̠tu̠ talak­pa­li̠­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Pus na̠chuna li̠túm acxni̠ cha̠tum pusca̠t kalhi̠y okxcá̠hu tumi̠n xla plata y para nama­ka­tzanka̠y okxtum, ¿lácu lac­pu­hua­ná̠tit? ¿Pi̠ ni̠ cati­ma̠­pá­si̠lh cahuá xli̠­maksko y luu li̠huana̠ napalhnán y napu­tzay nac xli̠­ca̠­lanca chiqui hasta caní naqui̠­maclay? ");
INSERT INTO tocNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Acxni̠ namaclay pu̠tum naca̠­ma̠­ke̠s­toka xamigas xa̠hua hua̠nti̠ xta̠­la­ca­tzuní̠n, y chiné naca̠­huaniy: “Luu cat­la­huátit li̠tlá̠n, caqui­la̠­ta̠­pa̠­xu­huáhu la̠nchú porque aya cmac­lani̠t a̠má okxtum quin­tumi̠n hua̠ntu̠ xac­ma­ka­tzan­ka̠ni̠t.” ");
INSERT INTO tocNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Pus aquit cca̠­hua­niyá̠n pi̠ na̠chuná xán­geles Dios taka­lhi̠y aktum lanca tapa̠­xu­huá̠n acxni̠ cha̠tum mak­la̠­ka­lhi̠ná chixcú lak­pali̠y xali̠xcáj­nit xta­la­ca­pa̠s­tacni. ");
INSERT INTO tocNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús ca̠li̠­xa­kat­li̠pá aktum takalh­chu­huí̠n y chiné ca̠huá­nilh: —Cha̠tum chixcú xca̠­ka­lhi̠y cha̠tiy xla­ka­huasán. ");
INSERT INTO tocNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Maktum quilh­ta­macú xataju xka­huasa chiné huá­nilh xtla̠t: “Papá, huata cumu la̠nchú tla̠ncú lápa̠t, mejor caqui­ma̠x­quitá qui­he­rencia hua̠ntu̠ qui­lak­chá̠n naqui­ma̠x­qui̠ya.” Amá ko̠lu­tzí̠n ma̠t­lá̠n­ti̠lh hua̠ntu̠ huá­nilh y ca̠ma̠­paj­pi­tzí̠­nilh xla­ka­huasán la̠ta hua̠ntu̠ xlá xka­lhi̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ni̠ li̠maka̠s quilh­ta­macú a̠má xataju xka­huasa sta̠­makan­kólh hua̠ntu̠ xma̠x­qui̠­cani̠t xhe­rencia, y a̠má tumi̠n hua̠ntu̠ xlá maka­mak­lhtí̠­nalh acxni̠ stá̠­nalh alh li̠la­ca­huan­ta­pu̠li̠y mákat nac a̠laca­túnuj ca̠chi­quí̠n; antá lac­tla­hua­mi̠­ko̠lh porque luu caj xali̠xcáj­nit tapu­huá̠n chí­palh. ");
INSERT INTO tocNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Acxni̠ aya xlac­tla­hua­mi̠­ko̠ni̠t xtumi̠n hua­tiyá nac a̠má ca̠chi­quí̠n anta­nícu xlá xcha̠ni̠t milh aktum lanca tatzín­c­stat y sput­ko̠lh hua̠ntu̠ xuacán, y a̠má kahuasa na̠ tzú­culh pa̠ti̠nán porque niaj tu̠ xka­lhi̠y hua̠ntu̠ nali̠­hua̠yán. ");
INSERT INTO tocNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Huata xlá alh putzay li̠ta­scújut y lák­cha̠lh cha̠tum chixcú antá xalá nac a̠má ca̠chi­quí̠n, huata xlá ma̠la­ká­cha̠lh nac xca̠­tu­huá̠n la̠qui̠ namak­ta­kalhniy xpaxni. ");
INSERT INTO tocNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Cumu xlá aya xtzin­c­sni̠y xlac­pu­huán caj u̠cu xlí̠­kasli xli̠­huatcán paxni hua̠ntu̠ xca̠­ma̠x­qui̠cán, pero xlá ni̠para túcu xta̠­huacán. ");
INSERT INTO tocNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Pus a̠má kahuasa chiné tzú­culh laca­pa̠s­taca: “Nac xchic quin­tla̠t lhu̠hua tahui­lá̠­nalh xta­sa̠­cuá̠n, xlacán taka­lhi̠y hua̠ntu̠ tahuay y hasta ca̠aka­ta̠x­tu­nima, ¡y chi̠nchú aquit uú ctzin­c­sta­makama hasta ni̠tu̠ cuay! ");
INSERT INTO tocNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Huata mejor nacam­paray nac xchic quin­tla̠t, y acxni̠ nac­chá̠n chiné nacuaniy: Papá, luu lhu̠hua quin­ta­la̠­ka­lhí̠n hua̠ntu̠ cli̠­ma­ka­li̠­pu­huani̠t Dios y na̠chuná huix na̠ cma­ka­li̠­pu­hua­ni̠tán. ");
INSERT INTO tocNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Caj huá xpa̠­la­cata aquit niaj qui­ma̠t­la̠nti̠y naqui­li̠­pu̠lh­ca̠ya cumu la̠ min­ka­huasa, huata mejor la̠nchú caqui­ma̠s­cuju y caqui­li̠­pu̠lhca cumu la̠ cha̠tum min­ta­sa̠cua.” ");
INSERT INTO tocNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Xli̠­ca̠na a̠má kahuasa la̠li̠­huán táca̠xli y ampá nac xchic xtla̠t. ’Acxni̠ a̠má kahuasa juerza makatcú xla­ti̠­lhay, a̠má ko̠lu­tzí̠n úcxilhli pi̠ mima xka­huasa. Xli̠­ca̠na luu laka­lhá­malh y tokosú̠n alh pa̠x­toka; acxni̠ lák­cha̠lh aklhtam­pí̠s­natli y lacá­tzu̠cli. ");
INSERT INTO tocNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Pero a̠má kahuasa chiné huá­nilh xtla̠t: “Papá, luu lhu̠hua quin­ta­la̠­ka­lhí̠n hua̠ntu̠ cli̠­ma­ka­li̠­pu­huani̠t Dios, y na̠chuná huix na̠ cma­ka­li̠­pu­hua­ni̠tán; pus aquit niaj qui­ma̠t­la̠nti̠y naqui­li̠­pu̠lh­ca̠ya cumu la̠ min­ka­huasa.” ");
INSERT INTO tocNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero a̠má ko̠lu­tzí̠n chiné ca̠huá­nilh xta­sa̠­cuá̠n: “La̠li̠­huán cama̠­cu­tútit a̠tzinú xatlá̠n lháka̠t y cama̠­lha­ké̠tit quin­ka­huasa. Na̠ cama̠­ma­ka­nú̠tit aktum ani̠lu nac xmacán, y na̠ cama̠­tu̠­nú̠tit csa­pa̠tu. ");
INSERT INTO tocNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Xa̠huachí la̠li̠­huán cali̠­tátit xakón qui­huá̠cax, camak­ní̠tit, ¡porque la̠nchú nahua̠­ya­ná̠hu y napa̠x­cuajna­ná̠hu! ");
INSERT INTO tocNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Porque u̠má quin­ka­huasa aquit xac­li̠­pu̠lhca̠y cumu lá̠m­para xni̠ni̠t y chú aya lacas­ta­cuanani̠t, y mim­pa­rani̠t nac ca̠quilh­ta­macú; porque xac­ma­ka­tzan­ka̠ni̠t y la̠nchú aya cmac­lani̠t.” Y ni̠para maka̠s tzu­cú­calh pa̠x­cuajnancán nac xchic a̠má ko̠lu­tzí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Y a̠má xapuxcu xka­huasa xlá cscuj­ma̠chá nac ca̠tu­huá̠n, acxni̠ aya xtas­pitma y xcha̠ma nac xchic, káx­matli pi̠ luu li̠pa̠­xúhu xtlak­na­ma̠ca y xtan­tli̠­ma̠­kó̠­calh. ");
INSERT INTO tocNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","La̠li̠­huán tasá­nilh cha̠tum tasa̠cua y kalhás­quilh: “¿Túcu xla­cata li̠t­la­hua­má̠­calh pu̠pa̠xcua nac quín­chic?” ");
INSERT INTO tocNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Amá tasacua chiné kálh­ti̠lh: “Huá li̠pa̠x­cuajna­má̠­calh porque luu chu­na­tiyá tla̠n qui̠­tás­pitli min­ta̠lá hua̠nti̠ xak­tzan­ka̠­ta­ma̠ni̠t ni̠tu̠cu lanini̠t, y caj huá xpa̠­la­cata li̠ma̠­pek­sí̠­nalh min­tla̠t la̠qui̠ namak­ni̠cán xakón xuá̠cax.” ");
INSERT INTO tocNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Pero a̠má xapuxcu xka­huasa luu li̠pe̠cua sí̠tzi̠lh y cumu ni̠ xta­nu̠­putún nac chiqui juerza tax­tuchi xtla̠t y mak­lhu̠hua huá­nilh xla­cata catá­nu̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Huata a̠má kahuasa chiné huá­nilh xtla̠t: “Huix sta­lanca catzi̠ya la̠ta nícu akli̠t ca̠ta cta̠s­cujmá̠n, y ni̠para maktum caj chu­natá xac­ka­lha­kax­mat­makán, pero huix ni̠para maktum xqui­ma̠xqui ca̠na caj tantum xas­kata mibor­rego la̠qui̠ nac­makni̠y y nac­ca̠­ta̠­huay quiamigos. ");
INSERT INTO tocNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pero cumu la̠nchú lak­chi­ni̠tán quin­tajú hua̠nti̠ lac­tla­hua­mi̠­ko̠lh min­tumi̠n y huá acxtum ca̠ta̠­lac­tlá­hualh cati̠hua̠ laka­hui­tiní̠n lac­chaján huata chú huix pála ma̠mak­ni̠­ní̠­nanti xakón mihuá̠cax y tla­huápa̠t pu̠pa̠xcua.” ");
INSERT INTO tocNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","’Pero a̠má ko̠lu­tzí̠n chiné huá­nilh xka­huasa: “Ta̠ta, huix anka­lhi̠ná uú lac­xtum quin­ta̠­huila, y la̠ta túcua aquit cka­lhi̠y na̠ hua̠k milá. ");
INSERT INTO tocNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero la̠nchú luu xli̠­ca̠na xla­ca­squinca pi̠ juerza napa̠­xu­hua­yá̠hu y napa̠x­cuajna­ná̠hu, porque tamá min­tajú qui̠­taxtuy cumu lá̠m­para xni̠ni̠t y chú aya lacas­ta­cuanani̠t; lá̠m­para xma­ka­tzan­ka̠­ni̠­táhu pero la̠nchú aya mac­la­ni̠­táhu.” ");
INSERT INTO tocNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús ca̠li̠­ma̠­kalh­chu­hui̠­ni̠pá xdis­cí­pulos eé takalh­chu­huí̠n: —Maktum quilh­ta­macú xuí cha̠tum chixcú pero luu rico xuani̠t. Huá u̠má chixcú xka­lhi̠y cha̠tum xapuxcu xta­sa̠cua hua̠nti̠ luu xli̠­pa̠­huán, y hua̠k huá xma̠­mak­ta­kalhni̠y xli̠­hua̠k hua̠ntu̠ xlá xka­lhi̠y. Pero maktum quilh­ta­macú áncalh hua­nicán pi̠ a̠má xapuxcu xta­sa̠cua lhu̠hua antá xak­ska­huix­tu­nima xtumi̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Pus a̠má chixcú tasá­nilh xta­sa̠cua y ciné huá­nilh: “¿Pi̠ xli̠­ca̠na hua̠ntu̠ qui­hua­ni­má̠ca xla­cata hmat huix akska­huix­túpa̠t quin­tumi̠n? Pus la̠nchú caqui­ma̠x­qui̠­ko̠ca cuenta la̠ta lácu huí quin­ta­scújut y hua̠nti̠ quin­ta­la­ka­hui­lá­nilh porque chú niaj cac­ti­ma̠x­quí̠n li̠ta­scújut xla­cata huix nacuentaj­laya pu̠tum cumu la̠ xapuxcu tasa̠cua.” ");
INSERT INTO tocNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Eé tasa̠cua chiné tzú­culh lac­pu­huán: “¿Túcu cahuá chú nac­tla­huay cumu quim­patrón ámaj qui­mak­lhti̠y quin­ta­scújut? Porque aquit ni̠ cka­lhi̠y li̠t­li­hueke xla­cata nac­scuja nac ca̠tu­huá̠n, y na̠chuna li̠túm luu ma̠rí cma̠­xanán para caj nac­squi­hua̠­yan­ta̠k­chokoy. ");
INSERT INTO tocNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","¡Ah, aya ccá­tzi̠lh hua̠ntu̠ nac­tla­huay! Nac­ca̠­ta̠­la­ca̠xlay hua̠nti̠ laka­hui­la­ni­ko̠lh quim­patrón la̠qui̠ xlacán naquin­ta­mak­ta̠yay acxni̠ aquit naqui­mak­lhti̠cán a̠má qui­li̠­ta­scújut.” ");
INSERT INTO tocNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Pus chuná xlá tlá­hualh y cha̠­tunu cha̠­tunu tzú­culh ca̠ta­saniy hua̠nti̠ xta­la­ka­hui­lá­nilh xpatrón. Hua̠nti̠ pu̠lh milh kalhás­quilh: “¿Lácu chuná laka­hui­lani quim­patrón?” ");
INSERT INTO tocNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Xlá kalh­tí̠­nalh: “Pus aquit cla­ka­hui­lani aktum ciento barril aceite.” Amá xapuxcu tasa̠cua chiné huá­nilh: “Xli̠­ca̠na, porque chuná talh­ca̠ni̠t nac mire­cibo hua̠ntu̠ firmar tla­hua­ni̠ta, huata mejor calác­xti̠tti hua̠ntu̠ aya firmar tla­hua­ni̠ta y tunu cat­lahua anta­nícu nahuán pi̠ caj íta̠t ciento barril laka­hui­lani.” ");
INSERT INTO tocNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Y aca­li̠stá̠n kalhas­quimpá cha̠tum: “Chi̠nchú huix, ¿nícu chulá laka­hui­lani?” Amá chixcú kalh­tí̠­nalh: “Aktum ciento cúx­ta̠lh trigo.” Amá xapuxcu tasa̠cua huá­nilh: “Xli̠­cána, porque hui­lachá mire­cibo, la̠li̠­huán calác­xti̠tti y tunu cat­lahua la̠qui̠ antá nahuán pi̠ caj ta̠ti­pu­xa­ma­cá̠hu cúx­ta̠lh laka­hui­lani.” ");
INSERT INTO tocNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Acxni̠ cátzi̠lh xpatrón hua̠ntu̠ xtla­huama xli̠­ca̠na hasta luu cacs li̠la­cáhua caj la̠ta lácu xlá xka­lhi̠ni̠t li̠s­ka­lala y lac­pú­tzalh lácu tla̠n nala­tama̠y aca­li̠stá̠n a̠má mañoso tasa̠cua. Pus xli̠­ca̠na lhu̠hua cris­tianos hua̠nti̠ uú xala nac ca̠quilh­ta­macú luu lak­ska­lalán tahuán acxni̠ lácu talac­pu­tzay para túcu natat­la­huay hasta luu ca̠maka­tla­jacán hua̠nti̠ luu aksti̠tum tas­cuj­má̠­nalh nac xla­catí̠n Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Pus Jesús chiné na̠ ca̠huá­nilh xta­ma̠­kalh­ta­huaké̠n: —Hui­xinín na̠ ca̠ma­ca­ma̠x­qui̠­ca­ni̠­tátit hua̠ntu̠ namak­ta­ka­lhá̠tit uú nac ca̠quilh­ta­macú anta­nícu tahui­lá̠­nalh lhu̠hua cris­tianos hua̠nti̠ ni̠ tala­ka­pasa Dios; pus uú nac ca̠quilh­ta­macú la̠ta túcu kalhi̠­yá̠tit caca̠­li̠­pu­tzátit hui­xinín la̠qui̠ tla̠n naka­lhi̠­yá̠tit miami­goscán pero hua̠ntu̠ luu aksti̠tum, la̠qui̠ acxni̠ hui­xinín nani̠­yá̠tit y niaj kalhi̠­yá̠tit nahuán hua̠ntu̠ xta­palh tumi̠n naca̠­mak­ta̠­yayá̠n xlacán nata­maka­maklhti̠­naná̠n nac a̠má xasa̠sti pu̠tá­hui̠lh hua̠ntu̠ ne̠cxni lak­sputa. ");
INSERT INTO tocNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Porque hua̠nti̠ ma̠cuentaj­li̠cán hua̠ntu̠ ni̠ luu lhu̠hua ta­scújut y para xlá luu cuentaj nat­la­huay chuná li̠ma̠­siyuy pi̠ tali̠­pa̠hu la̠qui̠ acxni̠ nama̠­mak­ta­kalh­ni̠cán hua̠ntu̠ luu lhu̠hua li̠ta­scújut pus na̠ huá luu cuentaj nat­la­huay; pero hua̠nti̠ luu ni̠ cuentaj tla­huay hua̠ntu̠ ni̠ lhu̠hua li̠ta­scújut hua̠ntu̠ ma̠mak­ta­kalh­ni̠cán, pus na̠chuná ni̠ li̠huana̠ cati­mak­tá­kalhli acxni̠ para nama̠x­qui̠cán lhu̠hua xli̠­mak­ta­ká­lhat. ");
INSERT INTO tocNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Pus para hui­xinín ni̠ li̠huana̠ mak­ta­ka­lhá̠tit hua̠ntu̠ ca̠ma̠­cuentaj­li̠­ca­ná̠tit uú nac ca̠quilh­ta­macú ma̠squi hua̠ntu̠ ni̠ luu lhu̠hua, ¿pi̠ li̠huaca chú namak­ta­ka­lhá̠tit hua̠ntu̠ Dios naca̠­ma̠x­qui̠yá̠n xta­la­ca­pa̠s­tacni? ");
INSERT INTO tocNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Chu­na­li̠túm, para hui­xinín ni̠tlá̠n namak­ta­ka­lhá̠tit hua̠ntu̠ Dios ca̠ma̠­cuentaj­li̠­ni̠tán y ni̠ milacán, ¿pi̠ li̠huaca chú naca̠­ma̠x­qui̠yá̠n hua̠ntu̠ xlá aya lac­lhca̠­hui­li̠ni̠t xla­cata naca̠­ma̠x­qui̠yá̠n cha̠­tunu hui­xinín? ");
INSERT INTO tocNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Hui­xinín catzi̠­yá̠tit pi̠ ni̠para cha̠tum tasa̠cua ma̠t­la̠nti̠y naca̠­ta̠s­cuja cha̠tiy xpatrón aktumá quilh­ta­macú, porque acxni̠ naka­lha­kax­mata cha̠tum, hua̠nchú cha̠­tum­li̠túm juerza nalak­makán; osuchí acxni̠ nat­la­hua­putún hua̠ntu̠ nali̠­ma̠­paksi̠y cha̠tum juerza que naka­lha­kax­mat­makán cha̠tum. Pus aquit cla­cas­quín luu li̠huana̠ caaka­tá̠k­stit hua̠ntu̠ cuani­putún: cha̠tum chixcú ni̠lay li̠pa̠­huán Dios xli̠­hua̠k xnacú y na̠ hua­tiyá a̠má quilh­ta­macú luu nali̠­pa̠­huán xtumi̠n xla­cata pi̠ huá tla̠n catu̠huá li̠ma̠t­la̠nti̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Maka­pi­tzí̠n fariseos hua̠nti̠ na̠ antá xta­la­yá̠­nalh hua̠k xta­kax­mat­má̠­nalh hua̠ntu̠ xlá xqui­lhuama, huata tzú­culh tali̠­kalh­ka­ma̠nán Jesús porque xlacán luu xta­la­kati̠y nata­ka­lhi̠y lhu̠hua tumi̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Huata xlá chiné ca̠huá­nilh: —Hui­xinín hua̠nti̠ nac xla­ca­ti̠ncán cris­tianos li̠ta­si­yu­pu­tu­ná̠tit cumu la̠ hua̠nti̠ luu lac­tlá̠n lac­chix­cu­huí̠n, pero Dios hua̠k laka­pasa hua̠ntu̠ xali̠xcáj­nit huí nac mina­cujcán. Porque na̠ luu mili̠­ca­tzi̠tcán pi̠ hua̠ntu̠ hui­xinín lac­chix­cu­huí̠n puhua­ná̠tit pi̠ luu lhu̠hua xta­palh nac xlak­sti̠­pa̠ncán cris­tianos, xli̠­ca̠na cca̠­hua­niyá̠n pi̠ Dios ni̠ ucxilh­putún, huata xlá lak­makán. ");
INSERT INTO tocNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Acxni̠ Juan Bau­tista nia̠ xma̠­tzu­qui̠y xli̠­ta­scújut caj xma̠n huá tla̠n nakax­pa­tá̠tit y nama̠­kan­tax­ti̠­yá̠tit xli̠­ma̠­peksí̠n Moisés chu hua̠ntu̠ xta­tzokni̠t nac xlib­rojcán xalak­maká̠n pro­fetas; pero acxni̠ Juan tzú­culh li̠chu­hui̠nán a̠má xasa̠sti xta­ma̠­ca­tzi̠ní̠n Dios la̠ta lácu xlá xámaj ma̠tzu­qui̠y xasa̠sti xta­peksi̠t nac ca̠quilh­ta­macú, y acxni­tiyá a̠má quilh­ta­macú lhu̠hua cris­tianos juerza tatzak­sa­má̠­nalh nata­mak­lhti̠nán a̠má lak­táxtut hua̠ntu̠ xlá ma̠lacnu̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pero aquit luu laca­tancs cca̠­hua­niyá̠n xla­cata pi̠ akapú̠n chu ca̠quilh­ta­macú tla̠n xlak­tzán­ka̠lh, pero hua̠ntu̠ xamaká̠n tatzok­ta­hui­la­ni̠ttá xta­chu­huí̠n Dios nac li̠kalh­ta­huaka ni̠para pu̠lactum caj chu­natá cati­ta­mák­xtekli para ni̠ juerza nakan­taxtuy. ");
INSERT INTO tocNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Para cha̠tum chixcú namak­xteka xpusca̠t caj xpa̠­la­cata cumu tunu hua̠nti̠ nata̠­ta­maka­xtoka, pus tamá chixcú tla­huay lanca tala̠­ka­lhí̠n nac xla­catí̠n Dios; y a̠má chixcú hua̠nti̠ chú nata̠­ta­maka­xtoka a̠má pusca̠t hua̠nti̠ mak­xtek­cani̠t na̠chuná luu lhu̠hua tala̠­ka­lhí̠n tla­huay. ");
INSERT INTO tocNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesús na̠ ca̠huá­nilh eé takalh­chu­huí̠n: —Maktum quilh­ta­macú xuí cha̠tum chixcú pero luu rico xuani̠t. Ni̠túcu xtzan­ka̠niy para túcu namac­la­cas­quín, y hua̠ntu̠ luu xala­cuán lháka̠t xlá xli̠­lha­ka̠nán, y anka­lhi̠ná xcha̠­liyá̠n xtla­huay pu̠pa̠xcua pero hua̠k xala­cuán tahuá hua̠ntu̠ xlá xta̠­hua­ni̠nán. ");
INSERT INTO tocNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Na̠ antiyá nac a̠má ca̠chi­quí̠n xlama cha̠tum chixcú pero xlá luu snu̠n pobre xuani̠t xlá xuanicán Lázaro. Umá koxutá chixcú xli̠­pu̠nu̠y nac xli̠­lanca nac xmacni xtzitzi, antá xlá xan lata­huilay nac xtan­quilhtí̠n xchic a̠má ricu. ");
INSERT INTO tocNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Caj u̠cú la̠n xlí̠­kasli xlac­pu­huán hua̠ntu̠ xta­mo­kosa nac xmesa a̠má ricu la̠ta túcu xlá xkalh­ta̠x­tuma, pero ni̠tu̠ xta̠­huacán ca̠na caj actzú, pus hasta huata mejor chi­chí̠n xtamín tamac­slipiy la̠ta xka­lhi̠y xtzitzi. ");
INSERT INTO tocNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Maktum quilh­ta­macú a̠má koxutá li̠ma̠xken Lázaro ni̠lh, huata xán­geles Dios luu li̠pa̠­xúhu tále̠lh nac xpa̠xtú̠n Abraham anta­nícu xlá hui­lachá nac akapú̠n, y ni̠ li̠maka̠s quilh­ta­macú a̠má rico na̠ ni̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","’Acxni̠ antá xuilachá nac xpu̠­la­ta­ma̠ncán ni̠n luu li̠pe̠cua la̠ xpa̠­ti̠­nama, tala­ca­yá̠­hualh nac akapú̠n úcxilhli xuí nac xpu̠­tá­hui̠lh Abraham chu Lázaro antá xuí nac xpa̠xtú̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Huata palha xlá ma̠tá­si̠lh y chiné qui­lhá­nilh: “Quin­tla̠­ticán Abraham, luu cat­lahua li̠tlá̠n, caqui­la­ka­lhá­manti, cama­ca­tampi Lázaro la̠qui̠ nama̠s­tajay xok­spú̠n xmacán y napi̠­munuy qui­si̠­máka̠t la̠qui̠ tzinú nama̠s­ka­hui­hui̠y porque uú nac ca̠lh­cu­ya̠tni luu li̠pe̠cua la̠ cpa̠­ti̠­nama.” ");
INSERT INTO tocNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero Abraham chiné kálh­ti̠lh: “Luu xli̠­ca̠na cala­ca­pá̠s­tacti xla­cata pi̠ luu tla̠n huix xlápa̠t nac ca̠quilh­ta­macú y ni̠tu̠cu xtzan­ka̠­niyá̠n hua̠ntu̠ xmac­la­ca­squina y chi̠nchú u̠má koxutá Lázaro luu xli̠­ca̠na xlá ni̠tu̠cu xka­lhi̠y; pus la̠nchú xlá luu li̠pa̠­xúhu lama y li̠huán la̠nchú huix pa̠ti̠­námpa̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Xa̠hua chi̠nchú ma̠squi chuná, huí aktum lanca pu̠lhmá̠n hua̠ntu̠ quin­ca̠­ma̠­paj­pi­tziyá̠n; pus caj huá xla­cata ni̠lay taana̠chá hua̠nti̠ uú tahui­lá̠­nalh, y na̠ ni̠para hua̠nti̠ tahui­la̠­nanchá tanú ni̠lay tamín uú.” ");
INSERT INTO tocNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","’Amá chixcú hua̠nti̠ ricu xuani̠t chiné hua­nipá: “Cumu para ni̠lay lac­pu­huana hua̠ntu̠ cmak­squimá̠n, pus ca̠na caj camaca­pi Lázaro nac xchic quin­tla̠t, ");
INSERT INTO tocNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","la̠qui̠ naán ca̠xa­katli̠y hua̠nti̠ tahui­la̠­nanchá kalha­qui­tzis qui­na­ta̠lán, y luu naca̠­ma̠aka­ta̠k­sni̠y la̠qui̠ xlacán ni̠tu̠ natamín uú, porque luu xli̠­ca̠na li̠pé̠cua la̠ huí tapa̠tí̠n.” ");
INSERT INTO tocNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham chiné kalh­ti̠pá: “Xlacán aya taka­lhi̠y xli̠­ma̠­peksí̠n hua̠ntu̠ títzokli Moisés chu maka­pi­tzí̠n pro­fetas nac li̠kalh­ta­huaka, pus huata mejor huá cata­ma̠­kan­tax­ti̠chá.” ");
INSERT INTO tocNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Quin­tla̠­ticán Abraham, luu xli̠­ca̠na hua̠ntu̠ huix qui­lhuámpa̠t, pero para tícu naca̠­lakán hua̠nti̠ aya qui̠­tas­pit­ni̠ttá nac ca̠li̠ní̠n, cha̠­ca­tzi̠ya xlacán nata­kax­matniy y nata­lak­pali̠y xali̠xcáj­nit xta­la­ca­pa̠s­tac­nicán.” ");
INSERT INTO tocNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Cumu para xlacán ni̠ taka­lha­kax­mata hua̠ntu̠ tatzokni̠t Moisés chu xli̠­hua̠k pro­fetas, ¿pi̠ li̠huaca chú nata­kax­matniy para nala­cas­ta­cuanán cha̠tum ni̠n nac ca̠li̠ní̠n?”, kálh­ti̠lh Abraham. ");
INSERT INTO tocNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Maktum quilh­ta­macú Jesús chiné ca̠huá­nilh xta­ma̠­kalh­ta­huaké̠n: —Uú nac ca̠quilh­ta­macú anka­lhi̠ná tala­má̠­nalh nahuán cris­tianos hua̠nti̠ nata­ma̠t­la­hui̠nán tala̠­ka­lhí̠n, pero koxu­tacú tihuán a̠má chixcú hua̠nti̠ naca̠­ma̠t­la­hui̠y tala̠­ka­lhí̠n u̠ma̠ko̠lh cris­tianos hua̠nti̠ aya quin­ta­li̠­pa̠­huán. ");
INSERT INTO tocNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Huata luu xali̠­huaca tla̠n xuá li̠huán ni̠ a̠ ma̠t­la­hui̠y tala̠­ka­lhi̠n xta̠­cris­tianos, mejor xpix­chi̠­nú̠­calh aktum lanca xachí­huix molino y xma­cá̠n­calh nac pupunú. ");
INSERT INTO tocNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Pus luu cuentaj cat­la­huátit la̠qui̠ ni̠chuná nat­la­hua­yá̠tit! ’Pus para cha̠tum cris­tiano nat­la­hua­niyá̠n hua̠ntu̠ ni̠tlá̠n, acxni­tuncán cali̠­huani; y para nahuán pi̠ niaj ne̠cxni chuná catit­lá­hualh pus huix cama̠­tzan­ke̠­nani hua̠ntu̠ tla­huanín. ");
INSERT INTO tocNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ma̠squi hasta mak­tujún la̠ta caj tan­tacú cat­la­huanín hua̠ntu̠ ni̠tlá̠n, y para mak­tujún naminá̠n hua­niyá̠n: “Chú niaj ne̠cxni chuná cactitláhualh”, huix cama̠­tzan­ke̠­nani hua̠ntu̠ tla­huanín. ");
INSERT INTO tocNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Maktum quilh­ta­macú após­toles chiné tahuá­nilh Quim­pu̠­chi­nacán Jesús: —Quim­pu̠­chi­nacán, xqui­la̠­ma̠­li̠­hua­qui̠­níhu la̠ta lácu tla̠n nac­ca̠­naj­la­yá̠hu xli̠­hua̠k hua̠ntu̠ tla̠n tla­huay Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jesús chiné ca̠huá­nilh: —Para xli̠­ca̠na hui­xinín ca̠naj­la­yá̠tit cahuá hua̠ntu̠ xli̠­ca̠na tla̠n tla­huay Dios, ma̠squi chuná xka­lhí̠tit taca̠­nájlat ca̠na caj la̠ xliactzuná cumu la̠ actzú xatalhtzi acúla, hui­xinín hasta tla̠n xuanítit a̠má akatum lanca quihui: “Cata­pulhu la̠ u̠yá̠t y capit tati̠­ju̠­ta̠­yaya nac xla­quíta̠t pupunú”, y aquit tancs cca̠­hua­niyá̠n pi̠ a̠má quihui xca̠­ka­lha­kax­matni hua̠ntu̠ xli̠­ma̠­pek­sí̠tit. ");
INSERT INTO tocNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Para tícu la̠ hui­xinín kalhi̠y cha̠tum tasa̠cua y la̠ naqui̠­tas­pita nac ca̠tu­huá̠n para antá xpon­ka­nama osuchí xmak­ta­kalh­nima xuá̠cax xpatrón, acxni̠ xlá nachín, ¿lac­pu­hua­ná̠tit hui­xinín pi̠ chiné nahuaniy: “La̠li̠­huán catanu, cata­huila la̠ u̠yá mesa y cahuá̠­yanti”? ");
INSERT INTO tocNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Pus aquit luu laca­tancs cca̠­hua­niyá̠n pi̠ ni̠chuná cati­huá­nilh, huata mejor chiné nahuaniy: “La̠li̠­huán catanu y caca̠x­tlahua quin­tahuá porque aya nacua̠yán xala ca̠ko̠­tanú̠n, y acxni̠ chú aquit nacua̠yanko̠y pus chú aca­li̠stá̠n na̠ nahua̠­yana huix.” ");
INSERT INTO tocNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ma̠squi xli̠­ca̠na tamá tasa̠cua luu la̠n scujni̠t tan­tacú, pero ni̠ calac­pu­huántit para amá̠­calh pa̠x­cat­ca­tzi̠­nicán hua̠ntu̠ xlá qui̠­lí̠s­cujli, porque xlá luu caj xma̠nhuá tlán ma̠kan­tax­ti̠ni̠t hua̠ntu̠ xli̠t­lá­huat xuani̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Pus na̠chuná chú hui­xinín acxni̠ nat­la­hua­ko̠­yá̠tit aktum ta­scújut hua̠ntu̠ Dios naca̠­ma̠t­la­hui̠yá̠n na̠ chiné cahuántit: “Aquinín caj tasa̠­cuá̠n hua̠nti̠ ni̠para tzinú quin­ca̠­mi­ni̠­niyá̠n naquin­ca̠­pa̠x­cat­ca­tzi̠­ni­caná̠n hua̠ntu̠ cli̠s­cuj­ma̠­náhu, caj xma̠nhuá cma̠­kan­tax­ti̠­ni̠­táhu hua̠ntu̠ qui­li̠t­la­huatcán xuani̠t.” ");
INSERT INTO tocNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Acxni̠ Jesús xtla̠­huama nac tiji ti̠tum xama nac Jeru­salén, y ca̠ti̠­pun­táx­tulh laca­lhu̠hua lactzu̠ ca̠chi­quí̠n hua̠ntu̠ ca̠ma̠­peksi̠y Samaria chu Gali­lea. ");
INSERT INTO tocNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Acxni̠ cha̠lh nac aktum actzu̠ ca̠chi­quí̠n taúcxilhli kalha­cá̠hu lac­chix­cu­huí̠n hua̠nti̠ xca̠­pa­sani̠t pu̠lactum li̠xcáj­nit tzitzi hua­nicán lepra, xlacán juerza tzinú laka­mákat tata̠­yachá. ");
INSERT INTO tocNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Huata caj taqui­lhá­nilh y chiné tahuá­nilh: —¡Luu xli̠­ca̠na cat­lahua lanca li̠tlá̠n caqui­la̠­la­ka­lha­máhu! ");
INSERT INTO tocNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Acxni̠ xlá ca̠úcxilhli chiné ca̠huá­nilh: —Tla̠n, pero la̠li̠­huán chú capítit ma̠si­yu­ni­yá̠tit mimac­nicán cha̠tum cura la̠qui̠ xlá nama̠­lu­loka pi̠ aya pac­sni̠­tátit min­ta­ja­tatcán. Acxni̠ xlacán takáx­matli hua̠ntu̠ ca̠hua­ní­calh la̠li̠­huán táalh, pero acxni̠ xtat­la̠­hua­má̠­nalh nac tiji ca̠pac­sni­ko̠lh a̠má xta­ja­tatcán hua̠ntu̠ xca̠­ka­lhi̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Y cha̠tum chixcú hua̠nti̠ xalac Samaria xlá ni̠ judío xuani̠t, acxni̠ xlá mak­lhcá­tzi̠lh pi̠ aya xtat­la̠n­ti̠ni̠t huata la̠li̠­huán talák­spitli y luu palha la̠ta xca̠­ta­sa­ti̠­lhay xla­ka­chix­cu­hui̠ma y xpa̠x­cat­ca­tzi̠­nima Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Amá samari­tano acxni̠ cha̠lh nac xla­catí̠n Jesús la̠li̠­huán laka­ta­tzo­kós­talh la̠qui̠ chuná napa̠x­cat­ca­tzi̠niy y taquilh­pú̠­talh hasta caní lí̠cha̠lh xlacán nac ca̠ti­yatni. ");
INSERT INTO tocNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Pero Jesús chiné chu­huí̠­nalh: —¿Ja, lácu pi̠ ni̠ kalha­cá̠hu xta­huani̠t hua̠nti̠ xca̠­ka­lhi̠y a̠má li̠xcáj­nit tzitzi y hua̠k tápacsli? ¿Nícu chi̠nchú tayá̠­nalh xa̠maka­pi­tzí̠n kalha­na­ja̠tza? ");
INSERT INTO tocNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Lácu pi̠ caj xma̠nhuá eé chixcú hua̠nti̠ ni̠ judío huata huá tás­pitli la̠qui̠ napa̠x­cat­ca­tzi̠niy Dios? ");
INSERT INTO tocNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Aca­li̠stá̠n chiné li̠ma̠­pék­si̠lh a̠má chixcú: —La̠li̠­huán cata̠ya y capittá li̠pa̠­xúhu nac mín­chic. Huix luu xli̠­ca̠na tat­la̠n­ti̠­ni̠ta cumu chuná qui­li̠­pá̠­huanti. ");
INSERT INTO tocNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ama̠­ko̠lh fariseos taka­lhás­quilh Jesús nícu acxni̠ luu nachín a̠má xta­péksi̠t Dios hua̠ntu̠ nama̠­tzu­qui̠y. Xlá chiné ca̠kálh­ti̠lh: —Acxni̠ nachín xta­péksi̠t Dios ni̠ calac­pu­huántit para tícu tla̠n naucxilha. ");
INSERT INTO tocNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Y ni̠para tícu catíhua: “Uú huí”, osuchí “Ahuilachá”; porque a̠má xta­péksi̠t Dios hua̠ntu̠ cli̠­chu­hui̠­nani̠t aya antiyá lama nac milak­sti̠­pa̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Aca­li̠stá̠n xlá chiné ca̠huá­nilh xta­ma̠­kalh­ta­huaké̠n: —Na̠ nalak­chá̠n quilh­ta­macú acxni̠ hui­xinín naucxilh­pu­tu­ná̠tit la̠ta lácu aquit Xata­lac­sacni Chixcú nac­mim­paray la̠qui̠ nac­tzucuy ma̠pek­si̠nán, pero ni̠lay catiucxílhtit. ");
INSERT INTO tocNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Y hui­xinín naca̠­li̠­ta̠­chu­hui̠­nan­ca­ná̠tit: “Uú huí”, osuchí naca̠­hua­ni­ca­ná̠tit: “Anú huilachá.” Pero hui­xinín ni̠ capítit y ni̠ caca̠­naj­látit. ");
INSERT INTO tocNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Porque na̠ xta̠­chuná cumu la̠ tasiyuy mak­lipni lacatum lacatúm nac akapú̠n, pus na̠chuná chú aquit Xata­lac­sacni Chixcú chuná ámaj lak­chá̠n quilh­ta­macú acxni̠ nac­mim­paray. ");
INSERT INTO tocNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero pu̠lh la̠n nac­pa̠ti̠y uú nac ca̠quilh­ta­macú, porque u̠ma̠ko̠lh cris­tianos hua̠nti̠ tala­má̠­nalh la̠ ca̠lacchú quilh­ta­macú maktum naquin­ta­lak­makán. ");
INSERT INTO tocNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Na̠chuná cumu la̠ taak­spú­lalh cris­tianos a̠má quilh­ta­macú acxni̠ xlama Noé y spút­calh nac ca̠quilh­ta­macú, pus na̠ luu chuná nalak­chá̠n a̠má quilh­ta­macú acxni̠ nac­mim­paray. ");
INSERT INTO tocNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ama̠­ko̠lh cris­tianos luu li̠pa̠­xúhu xta­la­má̠­nalh, xta­hua̠­ya­má̠­nalh, maka­pi­tzí̠n xta­pa̠x­cuajna­má̠­nalh, xta­ta­maka­xtok­má̠­nalh, y xta­ma­ca­ma̠s­ta̠­má̠­nalh xlac­tzu­ma­jancán, hasta acxni̠ lák­cha̠lh quilh­ta­macú la̠ta lácu Noé táju̠lh nac a̠má lanca barco hua̠ntu̠ hua­nicán arca, y chuná tílalh mun­cá̠ctat y pu̠tum cris­tianos táni̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Na̠chuná tilapá acxni̠ xlama Lot: li̠pu̠tum hua̠nti̠ xta­la­má̠­nalh nac Sodoma luu li̠pa̠­xúhu xta­la­má̠­nalh, xta­hua̠­ya­má̠­nalh, xta­kot­má̠­nalh, xta­ta­ma̠­huanán, xtat­la­hua­má̠­nalh xchiccán, y xta­cha­na̠nán. ");
INSERT INTO tocNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero acxni̠ Lot tax­tuchá nac xaca̠­chi­quí̠n Sodoma, porque chuná xuanini̠t Dios cat­lá­hualh, pus ta̠c­tachi lhcúya̠t nac akapú̠n chu azufre hua̠ntu̠ clhcuma, y pu̠tum hua̠k ca̠mák­ni̠lh cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Pus na̠chuná chú ni̠ cha̠­ca­tzi̠ya nata­la­tama̠y cris­tianos a̠má quilh­ta­macú acxni̠ aquit nac­mim­paray. ");
INSERT INTO tocNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Acxni̠ nalak­chá̠n a̠má quilh­ta­macú para tícu hui­lachá nahuán nac xak­stí̠n ta̠lh­ma̠ná chiqui, y para antá hui­li̠ni̠t nahuán nac xpu̠­lacni xchic xmac­la­cas­quínit, niaj capá̠s­tacli para túcu namín tamac­xtuy huata mejor caj catzá̠­lalh; y para tícu lama̠chá nahuán nac ca̠tu­huá̠n niaj catás­pitli nac xchic. ");
INSERT INTO tocNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Caj luu cala­ca­pa̠s­táctit hua̠ntu̠ lánilh xpusca̠t Lot caj xpa̠­la­cata cumu xlak­li̠­pu­huán hua̠ntu̠ xak­xtek­makani̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Porque hua̠nti̠ lak­li̠­pu­huán y luu nalak­ma̠x­tu­putún xla­táma̠t uú nac ca̠quilh­ta­macú pus huata nama̠­lak­tzanke̠y, pero hua̠nti̠ nama̠­lak­tzanke̠y xla­táma̠t huata huá nalak­ma̠xtuy. ");
INSERT INTO tocNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Aquit xli̠­ca̠na cca̠­hua­niyá̠n pi̠ a̠má tzi̠sní cha̠tiy hua̠nti̠ talh­ta­ta­má̠­nalh nahuán nac aktumá lac­tama, cha̠tum nale̠ncán y cha̠tum namak­xtekcán. ");
INSERT INTO tocNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Cha̠tiy lac­pus­ca̠tní̠n lac­xtum tas­qui­ti­má̠­nalh nahuán, cha̠tum nale̠ncán y cha̠tum namak­xtekcán. ");
INSERT INTO tocNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Cha̠tiy lac­chix­cu­huí̠n lac­xtum tas­cuj­má̠­nalh nahuán nac aktumá ca̠tu­huá̠n, cha̠tum nale̠ncán y cha̠tum namak­xtekcán. ");
INSERT INTO tocNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ama̠­ko̠lh após­toles acxni̠ chuná takax­mat­ko̠lh a̠má tachu­huí̠n hua̠ntu̠ Jesús huá, chiné taka­lhás­quilh: —¿Nícu chuná nakan­taxtuy hua̠ntu̠ qui­lhuámpa̠t? Xlá chiné ca̠kálh­ti̠lh: —Pus anta­nícu má xaní̠n, antá juerza natzucuy tata­ke̠s­toka chu̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús na̠ ca̠li̠­xa­kát­li̠lh aktum takalh­chu­huí̠n la̠qui̠ chuná naca̠­li̠­ma̠­la­ca­pa̠s­tacni̠y pi̠ luu xla­ca­squinca anka­lhi̠ná nata­kalh­ta­hua­kaniy Dios y ne̠cxni nata­la­ka­cha̠niy. ");
INSERT INTO tocNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Xlá chiné ca̠huá­nilh: —Maktum quilh­ta­macú nac aktum ca̠chi­quí̠n xuí cha̠tum juez, xlá ni̠para tzinú xla­ca­pu­huaniy Dios, xa̠huachí xlá ni̠ti̠cu xla­ka­lhamán. ");
INSERT INTO tocNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na̠ antiya li̠túm nac a̠má ca̠chi­quí̠n xlama cha̠tum pu̠ni̠na̠ pusca̠t, xlá anka­lhi̠ná xlakán a̠má juez la̠qui̠ nat­la­huaniy jus­ticia, porque xlá xka­lhi̠y aktum xtaaklhú̠­hui̠t, pus huata xla­cas­quín nakalh­mak­ta̠­yacán nac xla­catí̠n hua̠nti̠ xta̠­la̠­si̠­tzi̠niy. ");
INSERT INTO tocNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","La̠ta nícu xli̠­makli̠t xqui̠­lak­la­ca­ni̠ttá a̠má juez ni̠ xtla­hua­putún hua̠ntu̠ xli̠­ma̠aka­tzan­ke̠ma; pero aca­li̠stá̠n xlá chiné laca­pá̠s­tacli: “Ma̠squi xli̠­ca̠na ni̠para tzinú cpe̠­cuaniy Dios, y ni̠para quin­cuenta hua̠ntu̠ ca̠ak­spulay cris­tianos, ");
INSERT INTO tocNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pero cumu eé pusca̠t anka­lhi̠ná qui­ma̠aka­tzan­ke̠t­la̠­huán, huata mejor nac­mak­ta̠yay la̠qui̠ chuná niaj ne̠cxni namín qui­ma̠aklhu̠­hui̠y y naqui­ma̠­ka­tzanke̠y.” ");
INSERT INTO tocNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jesús chiné ca̠huá­nilh xapós­toles: —Ma̠squi a̠má juez luu ni̠para tzinú tla̠n xta­pu­huá̠n, juerza chuná tla­huá­nilh a̠má pusca̠t la̠qui̠ niaj nama̠aklhu̠­hui̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Pus para tamá juez mak­tá̠­yalh a̠má pusca̠t tla­huá­nilh jus­ticia, ¿lácu pi̠ ni̠lay chú ca̠naj­la­yá̠tit xla­cata pi̠ Dios naca̠­mak­ta̠yay xca­maná̠n hua̠nti̠ xlá ca̠lac­sacni̠t y lac­pu­hua­ná̠tit pi̠ naca̠­ma̠­ma­ka­ka­lhi̠ni̠y a̠ma̠ko̠lh hua̠nti̠ anka­lhi̠ná takalh­ta­hua­ka­ni­má̠­nalh ma̠squi ca̠cu­huiní o ca̠tzi̠sní? ");
INSERT INTO tocNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Pus aquit luu laca­tancs cca̠­hua­niyá̠n pi̠ naca̠­mak­ta̠yay y ni̠ cati­ca̠­ma̠­maka­pá­li̠lh. Pero chi̠nchú acxni̠ aquit Xata­lac­sacni Chixcú nac­mim­paray, ¿pi̠ nac­mac­laycú cahuá hua̠nti̠ xli̠­ca̠na taca̠­najlay nahuán la̠nchú cca̠­hua­nimá̠n? ");
INSERT INTO tocNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Cumu luu lhu̠hua lac­chix­cu­huí̠n hua̠nti̠ xta­kax­mat­ni­má̠­nalh xta­chu­huí̠n antá xta­la­yá̠­nalh, xlacán xta­lac­pu­huán pi̠ luu tla̠n xta­pu­hua̠ncán y huata xta­lak­makán hua̠nti̠ ni̠tu̠cu xka­satcán, pus caj huá xpa̠­la­cata Jesús ca̠li̠­ma̠­kalh­chu­huí̠­ni̠lh eé takalh­chu­huí̠n: ");
INSERT INTO tocNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Maktum quilh­ta­macú cha̠tiy lac­chix­cu­huí̠n táalh takalh­ta­hua­kaniy Dios nac lanca pu̠si­culan; cha̠tum fariseo xuani̠t hua̠nti̠ luu xli̠­ca̠na li̠huana̠ xta­la­ka­pasa y xta­ma̠­kan­taxti̠y xley Moisés, y cha̠­tum­li̠túm caj xma̠­la­ka­xo­ke̠ná im­púes­tos y xlac­pu­hua­nicán pi̠ xlá ni̠tu̠cu xkásat xli̠­taxtuy. ");
INSERT INTO tocNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Amá fariseo antá xla­ca­huáya lacatzú anta­nícu luu laka­chix­cu­huí̠­nancán y chiné xkalh­ta­hua­ka­nima Dios: “Quim­pu̠­chiná Dios, luu cpa̠x­cat­ca­tzi̠­niyá̠n porque aquit luu tla̠n chixcú y ni̠chuná cli̠­ca­tzi̠y cumu la̠ a̠ma̠ko̠lh hua̠nti̠ taka­lha̠nán, chu hua̠nti̠ luu lac­li̠xcáj­nit xta­pu­hua̠ncán, osuchí cumu la̠ a̠ma̠ko̠lh hua̠nti̠ taxa­katli̠y túnuj lac­pus­ca̠tní̠n, xa̠huachí aquit ni̠ li̠xcáj­nit clama ni̠ xta̠­chuná cumu la̠ u̠láya xma̠­la­ka­xo­ke̠ná im­pues­tos. ");
INSERT INTO tocNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Aquit maktiy ckalh­xteknín aktum xama̠na la̠qui̠ chuná cli̠­la­ka­chix­cu­hui̠yá̠n, y aquit cma̠sta̠y qui­li­mosna lhu̠hua quin­tumi̠n hua̠ntu̠ ctlajay.” ");
INSERT INTO tocNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Y a̠má cha̠­tum­li̠túm chixcú hua̠nti̠ xma̠­la­ka­xo­ke̠ná im­pues­tos, huata xlá mákat quilh­pu̠tay tá̠yalh y ni̠para tzinú xta­la­ca­ya̠­hua­putún ta̠lhmá̠n, mejor xlá xcux­mu̠­ka­xi­má̠­calh y chiné xkalh­ta­hua­kama xqui­lhuama: “Quim­pu̠­chiná Dios, cat­lahua li̠tlá̠n caqui­la­ka­lhá­manti y caqui­ma̠­tzan­ke̠­nani porque luu lhu̠hua hua̠ntu̠ ctla­huani̠t quin­ta­la̠­ka­lhí̠n.” ");
INSERT INTO tocNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Y Jesús ca̠huá­nilh a̠ma̠ko̠lh cris­tianos: —Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ a̠má chixcú hua̠nti̠ xma̠­la­ka­xo­ke̠ná im­pues­tos acxni̠ a̠má quilh­ta­macú xlá chilh nac xchic, Dios aya xma̠­tzan­ke̠­na­nini̠t xli̠­hua̠k xta­la̠­ka­lhí̠n hua̠ntu̠ xlá xtit­la­huani̠t, y ni̠ xachuná a̠má fariseo hua̠nti̠ luu tla̠n xta­pu­huá̠n maklh­ca­tzi̠cán. Porque hua̠nti̠ luu xli̠­ca̠na tla̠n cris­tianos li̠ma̠x­tucán sacstu huata xlá amá̠­calh lak­makan­cán; pero hua̠nti̠ li̠ta̠yay pi̠ ni̠tu̠cu xkásat y kalha­palay pi̠ luu mak­la̠­ka­lhi̠ná huata xlá namá­lan­qui̠cán. ");
INSERT INTO tocNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Maka­pi­tzí̠n cris­tianos xta­li̠mín xca­mancán la̠qui̠ Jesús naca̠­si­cu­la­na̠t­la­huay; pero a̠ma̠ko̠lh xta­ma̠­kalh­ta­huaké̠n acxni̠ xlacán taúcxilhli tzú­culh tala­ca­quilhni̠y hua̠nti̠ xta­li̠­mi­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesús ca̠ta­sá­nilh y chiné ca̠huá­nilh: —Luu xli̠­ca̠na cat­la­huátit li̠tlá̠n ni̠ caca̠­li̠­hua­nítit tama̠­ko̠lh lactzu̠ camán xla­cata naquin­ta­lakmín; porque Dios caj xma̠nhuá ca̠ma̠x­qui̠y quilh­ta­macú nata­mak­lhti̠nán xta­péksi̠t hua̠nti̠ la̠ lactzu̠ camán taka­lhi̠y xta­la­ca­pa̠s­tac­nicán. ");
INSERT INTO tocNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ hua̠nti̠ ni̠ nata­li̠­taxtuy cumu la̠ lactzu̠ camán hua̠nti̠ tla̠n tat­la­huay naca̠­ma̠­pek­si̠cán, pus ni̠lay xlacán cati­ta­tá­nu̠lh nac xta­péksi̠t Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Maktum quilh­ta­macú cha̠tum luu tali̠­pa̠hu chixcú kalhás­quilh Jesús: —Ma̠kalh­ta­hua­ke̠ná, huix luu xli̠­ca̠na tla̠n catzi̠ya, ¿túcu qui­li̠t­lá­huat la̠qui̠ tla̠n nac­ka­lhi̠y a̠má li̠pa̠­xúhu latáma̠t hua̠ntu̠ ne̠cxni lak­sputa? ");
INSERT INTO tocNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús huá­nilh: —¿Túcu xpa̠­la­cata qui­li̠­hua­niya pi̠ aquit luu tla̠n cca­tzi̠y? Porque uú ni̠ti̠cu anán hua̠nti̠ xli̠­ca̠na tla̠n catzi̠y, huata caj xma̠n cha̠tum y huá Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","¿Túcu chi̠nchú xpa̠­la­cata qui­li̠­ka­lhas­quina? Porque huix catzi̠­yatá lácu huí kam­pa̠­cá̠hu tapéksi̠t hua̠ntu̠ Dios maca­má̠x­qui̠lh Moisés, chiné huan: “Ni̠ caxa­katli túnuj pusca̠t para huí mim­pusca̠t; ni̠ namak­ni̠ya min­ta̠­cris­tiano; ni̠ naka­lha̠­nana; ni̠ti̠cu caca̠áksanti min­ta̠­cris­tianos; caca̠­pa̠xqui mintzí chu min­tla̠t.” ");
INSERT INTO tocNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Amá chixcú chiné kalh­tí̠­nalh, huá: —Pu̠tum tamá hua̠ntu̠ huix qui­hua­nípa̠t hasta la̠ta actzu̠cú xacuani̠t ctzu­cuni̠t ma̠kan­taxti̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesús luu li̠pa̠­xúhu laca­cá̠c­ni̠lh y chiné huá­nilh: —Pero huí a̠kam­pa̠tum hua̠ntu̠ tzan­ka̠­nimá̠n mili̠t­lá­huat: cas­ta̠ko la̠ta túcua kalhi̠ya y caca̠­ma̠xqui min­tumi̠n hua̠nti̠ lak­li̠­ma̠x­kení̠n, la̠qui̠ chuná huix naka­lhi̠ya lhu̠hua cumu la̠ min­tumi̠n nac akapú̠n. Acxni̠ chú chuná nat­la­hua­ko̠ya la̠li̠­huán natana la̠qui̠ anka­lhi̠ná naquis­ta̠­la­niya. ");
INSERT INTO tocNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pero acxni̠ xlá káx­matli hua̠ntu̠ huá­nilh Jesús, a̠má chixcú luu li̠púhua porque luu rico xuani̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Acxni̠ Jesús úcxilhli pi̠ li̠púhua chiné ca̠huá­nilh cris­tianos: —Pero xli̠­ca̠na luu tuhua xla­cata para hua̠nti̠ lac­rrico nata­tanu̠y nac xta­péksi̠t Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Huata ni̠ xatuhua xtá­nu̠lh tantum camello nac xtzan li̠tzapan, ni̠ caj la̠ rico para tla̠n natanu̠y nac xta­péksi̠t Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","La̠ta tícua takáx­matli hua̠ntu̠ xlá huá, chiné taquilh­tzú­culh: —¿Xatícu chi̠nchú nalak­ma̠xtuy xli̠s­tacni? ");
INSERT INTO tocNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús chiné ca̠huá­nilh: —Hua̠ntu̠ hui­xinín lac­chix­cu­huí̠n ni̠lay tla­hua­yá̠tit, pero Dios hua̠k tla̠n tla­huay hua̠ntu̠ xlá lacas­quín. ");
INSERT INTO tocNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedro chiné huá­nilh: —Quim­pu̠­chi­nacán, aquinín hua̠k cak­xtek­ma­ka­ni̠­táhu la̠ta túcua xac­ka­lhi̠­yá̠hu caj xpa̠­la­cata cumu huix cca̠s­ta̠­lanín. ");
INSERT INTO tocNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesús chiné kálh­ti̠lh: —Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ la̠tachá tícu naak­xtek­makán xchic, osuchí xtla̠t, chu xtzí, o xna­ta̠lán, osuchí xpusca̠t, o para xcamán caj xpa̠­la­cata kalha­kax­mat­putún Dios nac xta­péksi̠t, ");
INSERT INTO tocNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","pus huata a̠tzinú luu lhu̠hua hua̠ntu̠ nama̠x­qui̠cán ni̠ xachuná la̠ta tu̠ xka­lhi̠y uú nac ca̠quilh­ta­macú, y na̠ nama̠x­qui̠cán a̠má latáma̠t hua̠ntu̠ ne̠cxni lak­sputa. ");
INSERT INTO tocNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús caj tunu ca̠tá̠alh kalha­cu̠tiy xapós­toles y chiné ca̠huá­nilh: —Hui­xinín catzi̠­yá̠tit pi̠ la̠nchú ama̠­náhu nac Jeru­salén la̠qui̠ antá nakan­tax­tu­ya̠chá pu̠tum hua̠ntu̠ tita­li̠­chu­huí̠­nalh pro­fetas acxni̠ titá­tzokli hua̠ntu̠ naquiok­spulay aquit Xata­lac­sacni Chixcú. ");
INSERT INTO tocNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Pus antá naqui­ma­ca­ma̠s­ta̠cán nac xmacancán lac­chix­cu­huí̠n hua̠nti̠ a̠laca­túnuj xalaní̠n hua̠nti̠ ni̠ judíos; xlacán la̠n naquin­ta­li̠­kalh­ka­ma̠nán, y cala̠huá naquin­ta­huaniy hasta naquin­ta­la­ca­chuj­mani̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","La̠n naquin­ta­hui­li̠niy, y aca­li̠stá̠n naquin­ta­makni̠y; pero caj xliaktutu quilh­ta­macú nac­la­cas­ta­cuanán nac ca̠li̠ní̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ama̠­ko̠lh após­toles ni̠para tzinú taaká­ta̠ksli, xa̠huachí hasta ni̠para tzinú xta­ca­tzi̠y hua̠ntu̠ xlá xli̠­chu­hui̠­nama, porque a̠má takalh­chu­huí̠n hua̠ntu̠ xca̠­hua­ni­má̠­calh ni̠lay xtaaka­ta̠ksa. ");
INSERT INTO tocNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Acxni̠ Jesús laca­tzu̠huá xla­ti̠­lhay nac xaca̠­chi­quí̠n Jericó, cha̠tum laka­xo̠ko xuí nac xquilhpá̠n tiji la̠qui̠ naca̠s­quiniy limos­na hua̠nti̠ antá xta­lac­tla̠­huán. ");
INSERT INTO tocNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Acxni̠ xlá káx­matli pi̠ luu lhu̠hua cris­tianos xtat­la̠­hua­má̠­nalh kalhas­qui­ní̠­nalh para túcu xlama. ");
INSERT INTO tocNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Pus hua­ní­calh pi̠ Jesús xalac Naza­ret antá xlac­tla̠­huama. ");
INSERT INTO tocNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Acxni̠ xlá káx­matli hua̠ntu̠ hua­ní­calh chiné qui­lhá­nilh: —¡Jesús, xli̠­ta­la­ka­pasni rey David! ¡Cat­lahua li̠tlá̠n caqui­la­ka­lhá­manti! ");
INSERT INTO tocNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Hua̠nti̠ xta­pu̠­la­ti̠­lhay nac tiji tzú­culh tala­ca­quilhni̠y la̠qui̠ mat nacac­squi­lhuán; pero xlá a̠tzinú luu li̠huaca tzú­culh qui­lhaniy: —¡Jesús, xli̠­ta­la­ka­pasni xamaká̠n rey David, cat­lahua li̠tlá̠n caqui­la­ka­lhá­manti! ");
INSERT INTO tocNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesús tachó­kolh y ma̠ta­sa­ní̠­nalh. Acxni̠ antiyá lacatzú xla­ka­láya chiné kalhás­quilh: ");
INSERT INTO tocNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Túcu laca­squina aquit nac­tla­huay mim­pa̠­la­cata? Xlá chiné huá­nilh: —Quim­pu̠­chiná, aquit cla­cas­quín xac­la­ca­huá̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús chiné huá­nilh: —¡Pus la̠n­chuj tuncán cala­ca­huá̠­nanti! Huix aya tala­cat­la̠n­ti̠­ni̠ta porque xli̠­ca̠na ca̠najla y qui­li̠­pá̠­huanti pi̠ tla̠n nac­ma̠­la­cat­la̠n­ti̠yá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Acxni tuncán a̠má laka­xo̠ko tla̠n laca­huá̠­nalh y sta̠­lá­nilh Jesús, xpa̠x­cat­ca­tzi̠­ni­ti̠­lhay Dios. Xli̠­pu̠tum cris­tianos taúcxilhli xta­scújut Jesús na̠chuná xta­pa̠x­cat­ca­tzi̠­ni­má̠­nalh Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesús cha̠lh nac Jericó y antá xti̠­pu̠­lac­pun­tax­tuma ca̠chi­quí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Na̠ antá nac a̠má ca̠chi­quí̠n xuí cha̠tum chixcú luu rico xuani̠t xuanicán Zaqueo. Huá xlá xapuxcu xuani̠t hua̠nti̠ xta­ma̠­la­ka­xo­ke̠nán im­pues­tos. ");
INSERT INTO tocNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Xlá luu xla­ka­pas­putún Jesús pero ni̠lay xuc­xilha porque luu lhu̠hua xtza­macán, xa̠huachí Zaqueo actzu̠ chixcú xuani̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Huata la̠qui̠ tla̠n xlá naucxilha, tokosú̠n pú̠lalh y la̠li̠­huán tahuá­calh nac akatum quihui anta­nícu xlá xámaj ti̠lac­taxtuy Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Acxni̠ luu antá xlá xti̠­tax­tuma tala­ca­yá̠­hualh nac xakán quihui, li̠ma̠­pá̠­cu­hui̠lh xta­cu­hui̠ní y chiné huá­nilh: —Zaqueo, la̠li̠­huán cata̠cta porque la̠nchú nac mín­chic nac­ta­mak­xteka. ");
INSERT INTO tocNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Xlá la̠li̠­huán tá̠c­talh y luu cha̠­pa̠­xu­hua̠na̠ tá̠alh Jesús nac xchic. ");
INSERT INTO tocNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Maka­pi­tzí̠n cris­tianos acxni̠ taúcxilhli tzú­culh taaksán Jesús y chiné xta­huán: —Ani̠t laka­pa­xia̠lhnán a̠má li̠xcáj­nit chixcú hua̠nti̠ luu la̠n kalhi̠y xta­la̠­ka­lhí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Pero nac xchic Zaqueo xlá huákaj tá̠yalh y chiné huá­nilh Quim­pu̠­chi­nacán: —Quim­pu̠­chiná, hua̠nti̠ lak­li̠­ma̠x­kení̠n íta̠t nac­ca̠­ma̠x­qui̠y la̠ta túcua aquit cka­lhi̠y; y para tícu ca̠ta catu̠huá cak­ska­hui­mak­lhti̠ni̠t xtumi̠n, la̠nchú mak­ta̠ti nacak­xo­ko­le̠niy. ");
INSERT INTO tocNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Y Jesús huá­nilh: —La̠nchú nac eé chiqui chini̠t lak­táxtut, porque eé chixcú na̠ cli̠­ma̠xtuy cumu la̠ xli̠­ca̠na xli̠­ta­la­ka­pasni Abraham caj xpa̠­la­cata cumu qui­li̠­pa̠­huán. ");
INSERT INTO tocNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Pus aquit Xata­lac­sacni Chixcú cmini̠t putzay y cmini̠t lak­ma̠xtuy hua̠nti̠ aya xta­lak­tzan­ka̠­ta̠­yani̠t cumu la̠ eé chixcú. ");
INSERT INTO tocNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Acxni̠ chuná hua­ni­ko̠lh Zaqueo, la̠ta xli̠­lhu̠hua cris­tianos ca̠li̠­xa­kát­li̠lh aktum takalh­chu­huí̠n. Pus cumu aya xta­la­ca­tzu­hui̠ma nac xaca̠­chi­quí̠n Jeru­salén xlacán xta­lac­pu­huán pi̠ ma̠x a̠huayu antá xámaj ma̠la­ca­tzu­qui̠y xta­péksi̠t Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Huata xlá ca̠huá­nilh eé takalh­chu­huí̠n la̠qui̠ nataaka­ta̠ksa la̠ta lácu luu naqui̠­taxtuy: —Maktum quilh­ta­macú xuí cha̠tum chixcú nac aktum pu̠la­tama̠n. Xlá luu tali̠­pa̠hu xuani̠t, y maktum maca­chi­ní­calh cáp­snat la̠qui̠ naán nac a̠má lanca ca̠chi­quí̠n anta­nícu xta­peksi̠y xpu̠­la­tama̠n la̠qui̠ nali̠­ma­ca̠ncán li̠go­bierno, y aca­li̠stá̠n natas­pit­paray. ");
INSERT INTO tocNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Acxni̠ aya xamajá an ca̠ta­sá­nilh kalha­cá̠hu xta­sa̠­cuá̠n, y cha̠­tunu ca̠má̠x­qui̠lh lhu̠hua tumi̠n la̠qui̠ xlacán nata­ma̠s­cujuy y chiné ca̠huá­nilh: “Cama̠s­cu­jútit eé tumi̠n y cama̠s­ka­tí̠tit hasta acxni̠ aquit nac­mim­paray.” ");
INSERT INTO tocNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pero lhu̠hua cris­tianos hua̠nti̠ xta̠­chiqui ni̠ xtaucxilh­putún luu xta­si̠­tzi̠niy, acxni̠ xlá alh na̠ pu̠tum táalh nac a̠má ca̠chi­quí̠n anta­nícu xta­peksi̠y xpu̠­la­ta­ma̠ncán la̠qui̠ nata­huán: “Ni̠ cla­cas­qui­ná̠hu huá nalak­chá̠n li̠go­bierno la̠qui̠ naquin­ca̠­ma̠­pek­si̠yá̠n.” ");
INSERT INTO tocNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pero xlá ni̠tu̠cu li̠maka­tla­já­calh y huá juerza lák­cha̠lh li̠go­bierno; y ni̠ li̠maka̠s xlá tás­pitli nac xca̠­chi­quí̠n. Y acxni̠ xlá chilh ca̠ma̠­ta­sa­ní̠­nalh a̠ma̠ko̠lh xta­sa̠­cuá̠n hua̠nti̠ xca̠­ma̠x­qui̠ni̠t xtumi̠n la̠qui̠ xlá naca­tzi̠y nícu chulá xta­ma̠t­la­ji̠ni̠t la̠ta cha̠­tunu. ");
INSERT INTO tocNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Hua̠nti̠ pu̠lh chilh ti̠tum lák­cha̠lh y chiné huá­nilh: “Patrón, a̠má min­tumi̠n hua̠ntu̠ quin­ti­ma̠xqui, la̠nchú ma̠x mak­ca̠hu xla­cata la̠ta cma̠s­ka­wi̠ni̠t.” ");
INSERT INTO tocNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Amá gobier­no chiné huá­nilh: “Li̠huaca tla̠n, huix luu xli̠­ca̠na tla̠n tasa̠cua; pus cumu luu cuentaj tlahua hua̠ntu̠ ni̠ luu lhu̠hua, pus la̠nchú aquit nacuili̠yá̠n li̠go­ber­nador la̠qui̠ naca̠­ma̠­pek­si̠ya akcá̠hu ca̠chi­quí̠n.” ");
INSERT INTO tocNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Na̠ mimpá xli̠­cha̠tiy xta­sa̠cua y chiné huá­nilh: “Patrón, min­tumi̠n hua̠ntu̠ quin­ti­ma̠xqui, mak­qui­tzis a̠chuná cma̠s­ka­ti̠ni̠t.” ");
INSERT INTO tocNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Amá gobier­no chiné huá­nilh: “Pus huix na̠ nacuili̠yá̠n li̠go­ber­nador naca̠­ma̠­pek­si̠ya akqui­tzis ca̠chi­quí̠n.” ");
INSERT INTO tocNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","’Mimpá cha̠tum y chiné huá­nilh: “Patrón, u̠huí chú min­tumi̠n hua̠ntu̠ quin­ti­ma̠xqui. Aquit ni̠tu̠ cma̠s­cu­juni̠t huata caj li̠huana̠ cmá̠­qui̠lh, la̠qui̠ ni̠ natzanka̠y nac quim­pa̠yu li̠huana̠ xac­chi̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Pus aquit cla­ca­pu­huanín porque cca­tzi̠y pi̠ huix luu tam­pa̠xtum tla­huaya taxokó̠n, y cca­tzi̠y la̠ta lácu ca̠akchi­paya hua̠ntu̠ ni̠ milá y ca̠mak­lhti̠ya xta­cha­na̠ncán xa̠maka­pi­tzí̠n hua̠nti̠ tali̠s­cujni̠t.” ");
INSERT INTO tocNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Amá gobier­no chiné huá­nilh: “Huix luu xli̠­ca̠na ni̠tlá̠n tasa̠cua, caj hua tuncán min­ta­chu­huí̠n me̠cstu li̠ta­la­ca­pu̠ya, pus para xli̠­ca̠na xca­tzi̠ya pi̠ aquit luu lanca qui­la­ka­yá̠­calh, y para xca­tzi̠ya pi̠ cak­chipay hua̠ntu̠ ni̠ quilá y cxka̠nán anta­nícu aquit ni̠tu̠ cha­na̠­nani̠t, ");
INSERT INTO tocNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿lácu chi̠nchú ni̠ huata mejor pit li̠hui­li̠ya quin­tumi̠n nac banco la̠qui̠ acxni̠ aquit xac­tí­milh xquin­tiakxo­ko­ní­calh acxni̠ xac­tíalh ti̠tiyay?” ");
INSERT INTO tocNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Amá rey chiné ca̠huá­nilh hua̠nti̠ antá xta­la­yá̠­nalh: “La̠li̠­huán camak­lhtí̠tit tumi̠n, y huata huá cama̠x­quí̠tit hua̠nti̠ kalhi̠y okxcá̠hu.” ");
INSERT INTO tocNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Xlacán chiné tahuá­nilh: “Patrón, pero xlá aya kalhi̠y okxcá̠hu tumi̠n.” ");
INSERT INTO tocNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Amá gobier­no chiné kalh­tí̠­nalh: “Pus xli̠­cána cca̠­hua­niyá̠n pi̠ hua̠nti̠ lhu̠hua kalhi̠y hua̠ntu̠ mac­la­cas­quín, a̠tzinú li̠huaca nama̠x­qui̠cán; pero hua̠nti̠ ni̠ lhu̠hua kalhi̠y hua̠ntu̠ mac­la­cas­quín namak­lhti̠­ko̠cán hasta ma̠squi ni̠ lhu̠hua hua̠ntu̠ xlá kalhi̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Xa̠huachí a̠ma̠ko̠lh lac­chix­cu­huí̠n hua̠nti̠ quin­ta­si̠­tzi̠niy hua̠nti̠ ni̠ xta­la­cas­quín aquit nac­ta­huilay li̠go­bierno, la̠li̠­huán caca̠­li̠­tátit y anta uú nac qui­la­catí̠n caca̠­mak­ní̠tit.” ");
INSERT INTO tocNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Acxni̠ chuná huan­ko̠lh eé tachu­huí̠n Jesús la̠li̠­huán taca̠xpá xla­cata ti̠tum nachá̠n nac xaca̠­chi­quí̠n Jeru­salén. ");
INSERT INTO tocNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Acxni̠ aya xta­ma̠­la­ca­tzu­hui̠ni̠t a̠ma̠ko̠lh aktiy ca̠chi­quí̠n ca̠hua­nicán Bet­fagé y Betania lacatzú nac a̠má ke̠stí̠n hua̠ntu̠ xuanicán Monte de los Olivos, xlá ca̠má­ca̠lh cha̠tiy xdis­cí­pulos, ");
INSERT INTO tocNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","y chiné ca̠huá­nilh: —Capim­pítit nac tamá ca̠chi­quí̠n hua̠ntu̠ tahui­lachi tuncán, y acxni̠ antá nachi­pi­ná̠tit naucxi­lhá̠tit tantum burru xlá antá chi̠­ya̠­hua­cani̠t y ni̠para cha̠tum chixcú a̠ ke̠ta­huilay. Hui­xinín nax­cu­tá̠tit y nali̠­ta­ná̠tit. ");
INSERT INTO tocNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Y para tícu naca̠­ka­lhas­quiná̠n: “¿Túcu li̠la­yá̠tit xcu­tá̠tit?” hui­xinín cahua­nítit pi̠ huá Mim­pu̠­chi­nacán mac­la­cas­quim­putún. ");
INSERT INTO tocNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ama̠­ko̠lh diesí­pulos táalh y xli̠­ca̠na chuná tama̠­nók­lhulh cumu la̠ Jesús xca̠­hua­nini̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Acxni̠ luu xtax­cut­má̠­nalh a̠má burru tax­tuchi hua̠nti̠ xpu̠­chiná y chiné ca̠ka­lhás­quilh: —¿Túcu xpa̠­la­cata li̠x­cut­pá̠tit tamá qui­burru? ");
INSERT INTO tocNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","—Porque Quim­pu̠­chi­nacán mac­la­cas­quim­putún —takalh­tí̠­nalh xlacán. ");
INSERT INTO tocNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Amá xpu̠­chiná burru niaj tu̠ ca̠huá­nilh y xlacán talé̠­nilh anta­nícu xuilachá Jesús, tali̠­ke̠t­lá­palh clha­ka̠tcán y tahui­lá­nilh Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Acxni̠ tzú­culh tala­ka­ka­lhu̠y a̠má ke̠stí̠n hua­nicán Monte de los Olivos lhu̠hua cris­tianos hua̠nti̠ xta­ta­ra­mi̠­má̠­nalh clha­ka̠tcán nac tiji la̠qui̠ antá nalac­tla̠­huán Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Y xli̠­hua̠k hua̠nti̠ xta­ca̠­naj­la­nini̠t Jesús tzú­culh tala­ka­chix­cu­hui̠y Dios caj xpa̠­la­cata lac­lanca xta­scújut hua̠ntu̠ xlacán xtaucxilhni̠t y xlacán tzú­culh taquilh­tli̠niy, ");
INSERT INTO tocNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","y chiné xta­huán: —¡Dios casi­cu­la­na̠t­lá­hualh u̠má lanca quim­pux­cucán hua̠nti̠ la̠nchú mima nac xta­cu­huiní Quim­pu̠­chi­nacán Dios! Caánalh tapa̠­xu­huá̠n nac akapú̠n y xli̠­hua̠k cala­ka­chix­cu­huí̠­calh Dios xpa̠­la­cata hua̠ntu̠ xlá tla­huani̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Maka­pi­tzí̠n fariseos hua̠nti̠ na̠ antá xta­mak­sta̠­la­má̠­nalh nac xlak­sti̠­pa̠ncán cris­tianos, chiné tzú­culh tahuaniy Jesús: —Ma̠kalh­ta­hua­ke̠ná, cat­lahua li̠tlá̠n caca̠­huani min­ta­ma̠­kalh­ta­huaké̠n cacs cata­qui­lhua. ");
INSERT INTO tocNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Xlá chiné ca̠kálh­ti̠lh: —Xli̠­ca̠na cca̠­hua­niyá̠n, para hua­tuní̠n nata­kalh­xteka, u̠ma̠ko̠lh chí­huix hua̠ntu̠ tamá̠­nalh nac xpa̠xtú̠n tiji natzucuy quin­ta­la­ka­chix­cu­hui̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Acxni̠ tancs lak­la­cá­cha̠lh Jeru­salén, úcxilhli a̠má lanca ca̠chi­quí̠n Jesús luu snu̠n li̠púhua y tzú­culh tasay. ");
INSERT INTO tocNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","La̠ta xta­sama chiné huá: —¡Koxutá huix Jeru­salén! ¡Para aka­ta̠ksa cahuá ca̠na caj xma̠n huá la̠ u̠má quilh­ta­macú pi̠ lak­chi­ni̠tán hua̠ntu̠ xli̠­ca̠na xma̠x­quí̠n xacacsua latáma̠t hua̠ntu̠ Dios ma̠x­qui̠­pu­tuná̠n! Pero cumu huix ni̠ xuc­xilh­pu­tuna hua̠ntu̠ Dios xma̠­cu­xilh­ni̠­pu­tuná̠n, niaj naucxi­lhá̠tit huata caj tala­ka­tze̠k­niya nahuán cane̠c­xni­cahuá. ");
INSERT INTO tocNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Pero amá̠n lak­cha̠ná̠n quilh­ta­macú acxni̠ huix luu li̠pe̠cua la̠ nama̠­pa̠­ti̠­ni̠­cana caj luu mim­pa̠­la­cata, porque hua̠nti̠ luu tasi̠­tzi̠­niyá̠n natas­ti­li­hui­li̠yá̠n la̠qui̠ ni̠ti̠cu natza̠lay, xlá cani̠huá nata­tax­tu­ya̠chi la̠qui̠ maktum nata­ma̠s­pu­tuyá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Y hua̠n­ta­ma̠­ko̠lh hua̠nti̠ ni̠ taucxilh­pu­tuná̠n ca̠tu̠tzú nata­ma­ca̠ná̠n, y nata­makni̠y pu̠tum min­ca­mancán hua̠nti̠ uú tahui­lá̠­nalh nac ca̠chi­quí̠n; y ni̠para aktum chí­huix cati­ta­mák­xtekli anta­nícu xca̠­hui­li̠­cani̠t hua̠ntu̠ xca̠­li̠t­la­hua­cani̠t chiqui. Pero ma̠squi chuná hua̠k huix li̠pina cuenta porque ni̠ aka­ta̠k­spu­tuna pi̠ Dios maca­mi­ni­ni̠tán la̠nchú hua̠nti̠ nalak­ma̠x­tuyá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Acxni̠ luu cha̠lh nac Jeru­salén tanu̠chá nac lanca pu̠si­culan y cha̠lh lacatum anta­nícu xta­hui­lá̠­nalh hua̠nti̠ xta­sta̠­na­má̠­nalh; xlá ca̠t­la­kax­tu­ko̠lh a̠ma̠ko̠lh cris­tianos hua̠nti̠ xta­sta̠­na­má̠­nalh chu hua̠nti̠ xta­ta­ma̠­hua­na­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Y chiné xlá ca̠ma̠­kalh­chu­huí̠­ni̠lh: —Nac li̠kalh­ta­huaka anta­nícu tatzokni̠t xta­chu­huí̠n Dios chiné huan: “Nac quín­chic caj luu huá nali̠­ma̠x­tucán naquin­ta­kalh­ta­hua­kaniy xli̠­hua̠k cristianos”; pero chi̠nchú hui­xinín aya li̠ma̠x­tu­ni̠­tátit cumu la̠ xpu̠­ta­tze̠k­nicán kalha̠­naní̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesús cha̠li cha̠lí xmin ca̠ma̠­kalh­chu­hui̠ni̠y cris­tianos nac lanca pu̠si­culan; pero a̠ma̠ko̠lh xana­puxcun cura chu xma̠­kalh­ta­hua­ke̠­nacán judíos, y na̠ xa̠hua hua̠nti̠ xta­ma̠­pek­si̠nán nac a̠má ca̠chi­quí̠n, xlacán aya xta­lac­pu­tza­má̠­nalh lácu natat­la­huay la̠quí tla̠n nata­makni̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero ma̠squi chuná xlacán ni̠lay xta­ma̠t­la̠nti̠y lácu natat­la­huay porque luu lhu̠hua cris­tianos xta­pa̠x­qui̠y y xta­kax­matniy hua̠ntu̠ xlá xli̠­chu­hui̠nán. ");
INSERT INTO tocNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Maktum quilh­ta­macú Jesús xca̠­ma̠­kalh­chu­hui̠­ni̠ma cris­tianos nac lanca pu̠si­culan, xlá xca̠­li̠­ma̠­kalh­chu­hui̠­ni̠ma la̠ta lácu tla̠n nata­ma̠aka­pú­taxti̠y xli̠s­tac­nicán, y na̠ acxni̠ tachilh xana­puxcun cura xa̠hua xma̠­kalh­ta­hua­ke̠­nacán judíos. ");
INSERT INTO tocNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Xlacán chiné taka­lhás­quilh: —Luu xli̠­ca̠na cat­lahua li̠tlá̠n caqui­la̠­hua­níhu túcu xpa̠­la­cata huix uú li̠ta­nu̠­ni̠­tan­chita nac pu̠si­culan y ca̠t­la­kax­tu­ko̠­ni̠ta hua̠nti̠ tas­ta̠nán. ¿Túcuya̠ li̠ma̠­peksí̠n huix kalhi̠ya? Osuchí ¿tícu ma̠x­qui̠­ni̠tán tamá li̠ma̠­peksí̠n? ");
INSERT INTO tocNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesús chiné ca̠kálh­ti̠lh: —Tla̠n nac­ca̠­hua­niyá̠n, pero pu̠lh na̠ huí hua̠ntu̠ cca̠­ka­lhas­quim­pu­tuná̠n, chú hui­xinín caqui­la̠­hua­níhu. ");
INSERT INTO tocNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Tícu li̠ma̠­pék­si̠lh Juan Bau­tista xla­cata xlá naakmu­nu̠nún, pi̠ huá Dios, osuchí huá cris­tianos? ");
INSERT INTO tocNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Xlacán chiné tzú­culh talac­pu­huán y tzú­culh tala̠­huaniy: —¿Lácu chú nahua­ni­yá̠hu nakalh­ti̠­yá̠hu? Porque para nahua­ni­yá̠hu pi̠ huá Dios macá­milh xlá naquin­ca̠­hua­niyá̠n: “¿Túcu chi̠nchú xpa̠­la­cata ni̠ li̠ca̠­naj­látit?” ");
INSERT INTO tocNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Y chi̠nchú para nahua­ni­yá̠hu pi̠ huá lac­chix­cu­huí̠n xta­li̠­ma̠­pek­si̠ni̠t, la̠ta xli̠­lhu̠hua cris­tianos naquin­ca̠acta­lan­chi­payá̠n y naquin­ca̠­mak­ni̠yá̠n. Porque xlacán taca­tzi̠y pi̠ Juan Bau­tista huá xliakchu­hui̠­nan­tla̠­huán xta­chu­huí̠n Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Pero huata mejor xlacán takalh­tí̠­nalh pi̠ ni̠ xta­ca­tzi̠y tícu xli̠­ma̠­pek­si̠ni̠t Juan la̠qui̠ naakmu­nu̠nún. ");
INSERT INTO tocNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Y Jesús chiné ca̠huá­nilh: —Pus para hui­xinín ni̠ catzi̠­yá̠tit hua̠ntu̠ cca̠­ka­lhas­quimá̠n, pus na̠ ni̠para aquit cac­ti­ca̠­huanín tícu qui­ma̠x­qui̠ni̠t li̠ma̠­peksí̠n caj xpa̠­la­cata hua̠ntu̠ aquit cca̠t­la­huay. ");
INSERT INTO tocNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Aca­li̠stá̠n Jesús tzu­cupaj ca̠ta̠­kalh­chu­hui̠nán cris­tianos y chiné ca̠li̠­ma̠­kalh­chu­huí̠­ni̠lh eé tachu­huí̠n: —Maktum quilh­ta­macú xuí cha̠tum chixcú hua̠nti̠ la̠n chalh nac xpú̠­cuxtu lhu̠hua xali̠­chánat uvas, y aca­li̠stá̠n xlá a medias ca̠r­ren­taj­má̠x­qui̠lh maka­pi­tzí̠n tasa̠­cuá̠n, porque xlá alh latama̠y mákat nac a̠laca­túnuj ca̠chi­quí̠n y luu maka̠s antá xla­ma̠chá. ");
INSERT INTO tocNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Acxni̠ lák­cha̠lh quilh­ta­macú la̠ta lácu cha̠y uvas, a̠má xpu̠­chiná máca̠lh cha̠tum tasa̠cua la̠qui̠ naancán ca̠s­qui­nicán a̠ma̠ko̠lh tasa̠­cuá̠n hua̠ntu̠ xlá xlak­chá̠n nachipay xata­huácat xta­chaná̠n. Pero xlacán huata caj tachí­palh y la̠n tahui­lí̠­nilh, caj chu­natá tamá­ca̠lh y ni̠tu̠ tama̠­lé̠­ni̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Y hua̠nti̠ xpu̠­chiná a̠má tachaná̠n maca̠mpá a̠cha̠­tum­li̠tum xta­sa̠cua, xlá na̠chuná tat­lá­hualh cala̠­huaj cala̠huá tahuá­nilh y na̠ tahui­lí̠­nilh y ni̠tu̠ tama̠­lé̠­ni̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Y a̠má chixcú juerza maca̠mpá a̠cha̠tum xta­sa̠cua, pero a̠ma̠ko̠lh tasa̠­cuá̠n hua̠nti̠ antá xtas­cuj­má̠­nalh nac a̠má par­cela tama̠­ta­ká̠­hui̠lh lhken tata­mác­xtulh y ni̠tu̠ tamá̠x­qui̠lh hua̠ntu̠ xlak­mini̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Y hua̠nti̠ xpu̠­chiná a̠má ca̠tu­huá̠n xlá chiné lac­púhua: “¿Túcu cahuá nac­tla­huay? Huata mejor nac­macá̠n quin­ka­huasa hua̠nti̠ luu cpa̠x­qui̠y la̠qui̠ acxni̠ xlacán nataucxilha ma̠x a̠huayu para tzinú nata­la­ca­pu­huaniy y nata­ka­lha­kax­mata hua̠ntu̠ naca̠­huaniy.” ");
INSERT INTO tocNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pus máca̠lh xka­huasa, pero a̠ma̠ko̠lh tasa̠­cuá̠n acxni̠ taúcxilhli a̠má kahuasa chiné tzú­culh tala̠­huaniy: “Huá eé xka­huasa hua̠nti̠ xpu̠­chiná eé tachaná̠n, pus huá naaka­ta̠x­tu­nicán pu̠tum hua̠ntu̠ aquinín la̠nchú li̠s­cuj­ma̠­náhu; huata mejor camak­ní̠hu la̠qui̠ hua̠k aquinín naquin­ca̠­ta­mak­xtek­ni­ko̠yá̠n.” ");
INSERT INTO tocNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Pus chuná tat­lá­hualh, tata­mác­xtulh nac xqui­lhapá̠n pu̠cuxcu y antá tamák­ni̠lh. Jesús chiné ca̠ka­lhás­quilh hua̠nti̠ xta­kax­mat­má̠­nalh: —¿Túcu hui­xinín lac­pu­hua­ná̠tit naca̠t­la­huaniy xpu̠­chiná pú̠cuxtu a̠ma̠ko̠lh hua̠nti̠ ni̠tlá̠n xta­pu­hua̠ncán tasa̠­cuá̠n? ");
INSERT INTO tocNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Pus luu xli̠­ca̠na xlá pi̠ namín y naca̠­mak­ni̠ko̠y pu̠tum a̠ma̠ko̠lh hua̠nti̠ ni̠ lacuán tasa̠­cuá̠n, y huata huá naca̠­ma­ca­ma̠x­qui̠y xpu̠­cuxtu a̠maka­pi­tzí̠n tasa̠­cuá̠n hua̠nti̠ aksti̠tum tas­cuja. Maka­pi­tzí̠n hua̠nti̠ xtaaka­ta̠k­smá̠­nalh acxni̠ takax­mat­ko̠lh eé tachu­huí̠n chiné tzú­culh tahuaniy: —¡Ni̠ cala­cás­quilh Dios para chuná naqui̠­taxtuy! ");
INSERT INTO tocNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesús cacs ca̠la­caúcxilhli y chiné ca̠huá­nilh: —Pus cumu para hui­xinín ni̠ ca̠naj­la­yá̠tit xla­cata pi̠ chuná naqui̠­taxtuy, caqui­la̠­hua­níhu, ¿túcu chinchú hua­ni­putún nac li̠kalh­ta­huaka? Porque lacatum anta­nícu tatzokni̠t chiné huan: Amá chí­huix hua̠ntu̠ tzap­snaní̠n talak­má­kalh, tilac­púhua pi̠ ni̠tu̠ li̠ma­cuán, la̠nchú huata huá a̠tzinú luu li̠ma­cuama porque huá li̠jax­ko̠ni̠t la̠ta xli̠­lanca chiqui. ");
INSERT INTO tocNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Para cha̠tum chixcú naliakchek­xnín eé chí­huix maktum nata­lac­tuc­xta­huilay; y para huata huá chí­huix naacta­ma̠­ya̠chi maktum nalak­chi­tami̠y y cumu la̠ pokxni nat­la­huako̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ama̠­ko̠lh xana­puxcun cura chu xma̠­kalh­ta­hua­ke̠­nacán judíos xta­chi̠­le̠m­putún Jesús cumu xlacán xtaaka­ta̠k­sni̠t pi̠ caj huá xpa̠­la­ca­tacán ma̠squi chuná xlá xca̠­li̠­xa­kat­li̠ni̠t a̠má takalh­chu­huí̠n. Pero ni̠tu̠ tat­la­hua­nipá chú porque xta­pe̠­cuaniy la̠ta xli̠­lhu̠hua cris­tianos, chicá xamaktum nata­lak­si̠­tzi̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Cumu xlacán ni̠ xta­ma̠t­la̠n­ti̠ni̠t pus tamá­ca̠lh maka­pi­tzí̠n lac­chix­cu­huí̠n hua̠nti̠ luu lacuán cris­tianos xta­li̠­tax­tu­putún la̠qui̠ nata­ma̠­kalh­pu­tza̠ni̠y y para túcu ni̠ tancs nakalh­ti̠nán chuná chú nata­ma̠­la­capu̠y nac xla­catí̠n gober­nador romano. ");
INSERT INTO tocNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Acxni̠ talák­cha̠lh chiné taka­lhás­quilh: —Ma̠kalh­ta­hua­ke̠ná, aquinín cca­tzi̠­yá̠hu pi̠ huix ma̠si­yuya hua̠ntu̠ luu xli̠­ca̠na aksti̠tum tala­ca­pa̠s­tacni, y ni̠para tzinú li̠taaklhu̠­hui̠ya ma̠squi lhu̠hua hua̠nti̠ ni̠ taliucxilh­pu­tuná̠n, huata huix laca­squina xli̠­pu̠tum cris­tianos nata­la­ka­pasa la̠ta lácu Dios lacas­quín nata­la­tama̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Pus cla­cas­qui­ná̠hu la̠nchú xqui­la̠­hua­níhu, ¿pi̠ tla̠n cahuá la̠ta la̠ cla­ka­xo­ko̠­nu­ni­ma̠­náhu xapuxcu ma̠pek­si̠ná romano, osuchí ni̠tlá̠n? ");
INSERT INTO tocNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesús cátzi̠lh pi̠ caj chu­natá xta­li̠­kalh­pu­tza­má̠­nalh y chiné ca̠huá­nilh: —¿Túcu xpa̠­la­cata hua­tiyá chuná qui­la̠­li̠­tzak­sat­la̠­hua­ná̠hu? ");
INSERT INTO tocNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Aver, caqui­la̠­ma̠­si­yu­níhu okxtum tumi̠n. ¿Tícu u̠má xla­capú̠n, y tícu xta­cu­huiní eé hua̠ntu̠ tatzok­ta­hui­lani̠t nac tumi̠n? Xlacán chiné takalh­tí̠­nalh —Huá tamá xla­capú̠n lanca ma̠pek­si̠ná gobier­no romano. ");
INSERT INTO tocNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesús ca̠hua­nipá: —Pus huata huá cama­ca­ma̠x­quí̠tit gobier­no hua̠ntu̠ ma̠peksi̠y gobier­no; y na̠chuna li̠túm huá cama­ca­ma̠x­quí̠tit Dios hua̠ntu̠ lak­chá̠n nama­ca­ma̠x­qui̠­yá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ama̠­ko̠lh lac­chix­cu­huí̠n cacs tala­cáhua y ni̠lay catu̠huá túcu nata­li̠­ka­lhas­quín porque hua̠ntu̠ xlá xka­lhas­quincán Jesús luu tancs hua̠ntu̠ xkalh­ti̠nán. Y la̠ta xli̠­lhu̠hua cris­tianos caj xta­li̠­pa̠­xu­huay hua̠ntu̠ xlá xca̠­li̠­xa­katli̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Aca­li̠stá̠n táalh anta­nícu xlaya Jesús maka­pi­tzí̠n lac­chix­cu­huí̠n hua̠nti̠ xca̠­hua­nicán sadu­ceos, xlacán ni̠ xta­ca̠­najlay para xli̠­ca̠na tala­cas­ta­cuanán ni̠n nac ca̠li̠ní̠n; y chiné tahuá­nilh: ");
INSERT INTO tocNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Ma̠kalh­ta­hua­ke̠ná, Moisés quin­ca̠­mak­xtek­ni­ni̠tán nac xli̠­ma̠­peksí̠n xla­cata para cha̠tum chixcú nani̠y naak­xtek­makán xpusca̠t y para ni̠tu̠ ta̠ká­lhi̠lh xca­mancán pus para huí chú xta̠lá kahuasa a̠má chixcú, xlá tla̠n nata̠­ta­huilay xya̠stá pu̠ni̠na̠ pusca̠t la̠qui̠ chuná ne̠cxni nalak­sputa xta­cu­huiní xta̠lá hua̠nti̠ aya ni̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pus maktum quilh­ta­macú xta­hui­lá̠­nalh kalha­tujún laka­huasán hua̠k li̠na­ta̠lán. Hua̠nti̠ xapuxcu tama­káx­tokli, pero ni̠ li̠maka̠s quilh­ta­macú ni̠lh y akxtek­má­kalh xpusca̠t, y ni̠para cha̠tum ta̠ká­lhi̠lh xca­mancán. ");
INSERT INTO tocNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Hua̠nti̠ xli̠­cha̠tiy xta̠lá ta̠ta­ma­káx­tokli xya̠stá, na̠ ni̠ maka̠s li̠tum xlá na̠ ni̠pá y na̠ ni̠para huá ta̠ká­lhi̠lh xca­mancán. ");
INSERT INTO tocNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Xli̠­ka­lha­tutu xtalá a̠má chixcú na̠chuná ta̠ta­ma­káx­tokli xya̠stá y la̠ta xa̠maka­pi­tzí̠n hua̠k chuná tat­lá­hualh, y pu̠tum táni̠lh xka­lha­tu­juncán y ni̠para cha̠tum tícu luu ta̠ká­lhi̠lh xca­mancán. ");
INSERT INTO tocNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Y ni̠ li̠maka̠s quilh­ta­macú a̠má pusca̠t na̠ ni̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Bueno, chi̠nchú acxni̠ nata­la­cas­ta­cuanán nac ca̠li̠ní̠n, ¿xatícu cahuá luu xpusca̠t nahuán cumu hua̠k xka­lha­tu­juncán tata̠­ta­ma­káx­tokli a̠má pusca̠t? ");
INSERT INTO tocNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesús chiné ca̠kálh­ti̠lh: —Cumu la̠ hui­xinín catzi̠­yá̠tit, uú nac ca̠quilh­ta­macú lac­chix­cu­huí̠n chu lac­pus­ca̠tní̠n tata­maka­xtoka. ");
INSERT INTO tocNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero chú hua̠nti̠ Dios ca̠lac­sacni̠t la̠qui̠ nata­ka­lhi̠y a̠má xasa̠sti latáma̠t acxni̠ nata­la­cas­ta­cuanán nac ca̠li̠ní̠n, xlacán niaj cati­ta­ta­ma­káx­tokli, y ni̠para cati­ta­ká­lhi̠lh xlac­tzu­ma­jancán hua̠nti̠ nata­ma̠sta̠y la̠qui̠ nata­ta­maka­xtoka. ");
INSERT INTO tocNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Huata xlacán nata­la­tama̠y cane̠c­xni­cahuá quilh­ta­macú cumu la̠ ángeles, porque xli̠­ca̠na huá xcamán Dios nata­huán cumu huá naca̠­ma̠­laca­stac­uani̠y nac ca̠li̠ní̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Hua̠nchú caj xpa̠­la­cata para nata­la­cas­ta­cuanán ni̠n, pus luu cala­ca­pa̠s­táctit pi̠ hasta huá Moisés ma̠lú­lokli acxni̠ xlá tzokli la̠ ta̠chu­huí̠­nalh Dios anta­nícu xak­xko­ta̠­yama actzu̠ quihui porque xlá li̠chu­huí̠­nalh Dios pi̠ huá xDios Abraham, xa̠huá xla Isaac, chu xla Jacob, chu xli̠­hua̠k xa̠maka­pi­tzí̠n hua̠nti̠ tani̠­ni̠ttá. ");
INSERT INTO tocNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Pus antá hua­ni­putún pi̠ Dios xca̠­li̠­ma̠xtuy a̠ma̠ko̠lh lac­chix­cu­huí̠n cumu la̠ xas­tacná xta­la­má̠­nalh ma̠squi aya xta­ni̠­ni̠ttá; pus caj hua̠ntu̠ xlá xla­cata ni̠tu̠cu lama para ni̠ hua̠k xas­tacná. ");
INSERT INTO tocNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Y cha̠tum xma̠­kalh­ta­hua­ke̠­nacán judíos chiné huá­nilh: —Ma̠kalh­ta­hua­ke̠ná, luu laca­tancs hua̠ntu̠ huix qui­lhuámpa̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Huata niaj tícu tla­huá­nilh takalh­pu­tzá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús chiné ca̠huá­nilh xli̠­hua̠k cris­tianos: —¿Lácu chú li̠hua­ná̠tit xla­cata pi̠ Cristo hua̠nti̠ naminá̠n ca̠lak­ma̠x­tuyá̠n mat huá xli̠­ta­la­ka­pasni nahuán xamaká̠n rey David? ");
INSERT INTO tocNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Y chi̠nchú lacatum nac li̠kalh­ta­huaka anta­nícu tata̠ksa Salmos hua̠ntu̠ rey David títzokli chiné huan: Quim­pu̠­chiná Dios chiné huá­nilh cha̠­tum­li̠túm ti̠ na̠ Quim­pu̠­chiná: “Cata­huila nac quim­pa̠xtú̠n la̠qui̠ naquin­ta̠­ma̠­pek­si̠­nana, ");
INSERT INTO tocNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","y hasta caní nac­ti­ca̠­maka­tla­jako̠y pu̠tum hua̠nti̠ tasi̠­tzi̠­niyá̠n.” ");
INSERT INTO tocNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Lácu chú hui­xinín lac­pu­hua­ná̠tit xla­cata pi̠ Cristo huá xli̠­ta­la­ka­pasni nahuán rey David, porque mismo huá David xpu̠­chiná tla­hua­paray? ");
INSERT INTO tocNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","La̠ta xli̠­lhu̠hua cris­tianos xta­kax­mat­má̠­nalh xta­chu­huí̠n, xlá chiné ca̠huá­nilh xdis­cí­pulos: ");
INSERT INTO tocNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Luu cuentaj cat­la­huátit ni̠chuná hui­xinín natzak­sa­yá̠tit cumu la̠ tali̠­ca­tzi̠y xma̠­kalh­ta­hua­ke̠­nacán judíos, xlacán luu tala­kati̠y talhaka̠y lac­pu̠lhmá̠n clha­ka̠tcán, y na̠ tala­cas­quín luu naca̠­ca̠c­ni̠­na­nicán nac tiji anta­nícu xlacán tala­ta̠k­chokoy. Acxni̠ taán nac xpu̠­ta­mak­stok­nicán tzucuy talac­saca la̠qui̠ huá nata­lac­ta­huilay xala­cuán pu̠tá­hui̠lh, y hua̠ntu̠ lacán tahui­lá̠­nalh; na̠chuna li̠túm acxni̠ taán anta­nícu ca̠hua­ni­cani̠t nata­mak­pa̠x­cuajnán, tala­cas­quín pi̠ pu̠lh huá naca̠­ma̠­hui̠cán. ");
INSERT INTO tocNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Pero taak­ska­hui­mak­lhti̠y xchiccán hua̠nti̠ ca̠ni̠­makan­cani̠t lac­chaján, y la̠qui̠ ni̠ti̠cu nata­ca­tzi̠y la̠ta lácu xlacán xta̠­yatcán pus luu maka̠s la̠ta takalh­ta­hua­kaniy Dios. Pero ni̠para tzinú taca­tzi̠y para huá a̠tzinú luu la̠n naca̠­ma̠­pa̠­ti̠­ni̠cán. ");
INSERT INTO tocNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Maktum quilh­ta­macú acxni̠ Jesús xlama nac lanca xpu̠­si­culan Dios hua̠ntu̠ huí nac Jeru­salén xlá xuc­xilhma láta lácua xta­ma­ju̠­má̠­nalh tumi̠n hua̠nti̠ luu lac­rricu nac a̠ma̠ko̠lh cajas hua̠ntu̠ pu̠taju̠y limos­nas. ");
INSERT INTO tocNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Caj li̠puntzú na̠ chilh cha̠tum li̠ma̠xken pu̠ni̠na̠ pusca̠t xlá na̠ máju̠lh nac cajas okxtiy tumi̠n xla cobre. ");
INSERT INTO tocNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesús chiné ca̠huá­nilh xdis­cí­pulos: —Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ nac xla­catí̠n Dios u̠má koxutá li̠ma̠xken pusca̠t a̠tzinú tlak lhu̠hua maju̠ni̠t xtumi̠n ni̠ xachuná maka­pi­tzí̠n hua̠nti̠ luu lhu̠hua tama­ju̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Porque maka­pi­tzí̠n huá tama̠s­ta̠­má̠­nalh xli­mos­najcán hua̠ntu̠ aya xca̠aka­ta̠x­tu­nini̠t, pus huata xlá ma̠s­ta̠ni̠t a̠má actzu̠ tumi̠n hua̠ntu̠ xti­li̠­ma­cuánilh la̠qui̠ tla̠n nala­tama̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Maktum quilh­ta­macú a̠ma̠ko̠lh xta­ma̠­kalh­ta­huaké̠n Jesús xta­li̠­chu­hui̠­na­má̠­nalh la̠ta lácua xuila­ko̠lh lacuán chí­huix chu lhu̠­hua­wa̠ntu̠ xta­ta̠i̠ni̠­nani̠t cris­tianos la̠qui̠ luu li̠la­káti̠t nali̠­ca̠x­ya̠­huacán a̠má lanca xpu̠­si­culan Dios xalac Jeru­salén. Pero huata Jesús chiné ca̠huá­nilh: ");
INSERT INTO tocNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Xli̠­hua̠k a̠má lak­li̠­la­káti̠t chí­huix chu pá̠tzaps hua̠ntu̠ hui­xinín ucxilh­pá̠tit, aya tala­ca­tzu­hui̠ma quilh­ta­macú acxni̠ nalak­pon­ka­mi̠cán y niaj para aktum chí­huix cati­táhui anta­nícu xuili̠­cani̠t porque nalac­tla­hua­ko̠cán. ");
INSERT INTO tocNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Huata xlacán chiné taka­lhás­quilh: —Ma̠kalh­ta­hua­ke̠ná, ¿níco̠cxni luu nakan­taxtuy hua̠ntu̠ qui­la̠­hua­ni­ma̠­náhu la̠nchú? ¿Tícu luu nata­siyuy la̠qui̠ naca­tzi̠cán pi̠ aya kan­tax­tuma hua̠ntu̠ qui­la̠­hua­ni­ma̠­náhu? ");
INSERT INTO tocNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús chiné ca̠kálh­ti̠lh: —Hui­xinín xli̠­ca̠na luu ská­lalh cala­ta­pá̠tit y ni̠ti̠cu naca̠ak­ska­huiyá̠n, porque luu lhu̠hua natamín hua̠nti̠ nataak­ska­huinín y nata­li̠­taxtuy cumu lá̠m­para aquit y nata­huán: “Aquit hua̠nti̠ naca̠lakma̠xtuyá̠n.” osuchí nata­huán: “La̠nchú aya lak­cha̠ni̠t quilh­ta­macú la̠ta lácu nalak­tax­tu­yá̠tit.” Pero hui­xinín ni̠ nataak­ska­hui­yá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Y acxni̠ hui­xinín naca­tzi̠­yá̠tit pi̠ cani̠huá lama guerra, y la̠ta lácua la̠mak­ni̠ma cris­tianos, hui­xinín ni̠ cape̠­cuántit, porque ni̠naj acxni̠ catis­pút­calh. ");
INSERT INTO tocNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesús chiné ca̠hua­nipá: —Cris­tianos hua̠nti̠ tahui­lá̠­nalh nac aktum lanca ca̠chi­quí̠n ámaj ta̠la̠­makni̠y hua̠nti̠ tahui­lá̠­nalh a̠tunuj ca̠chi­quí̠n, y la̠ta xli̠­lhu̠hua ca̠chi­qui̠ní̠n nata­la̠­ma­ka­si̠­tzi̠y y natat­la­huay guerra. ");
INSERT INTO tocNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Uú nac ca̠quilh­ta­macú luu laca­lhu̠hua anta­nícu nata­chi­quiy tíyat y napu̠­tzan­ka̠nán, y lacaxtum nalay tatzín­c­stat chu ti̠pa̠­katzi tajátat hua̠ntu̠ namín. Y chi̠nchú nac akapú̠n catu̠huá hua̠ntu̠ lac­li̠­pe̠­cuánit nata­siyuy, y na̠ lhu̠hua hua̠ntu̠ ni̠para tzinú li̠ca̠­naj­la­putu nata­siyuy. ");
INSERT INTO tocNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Pero acxni̠ nia̠ ti̠taxtuy hua̠ntu̠ la̠nchú cca̠­hua­nimá̠n, hui­xinín naca̠­pu­tza­sta̠­la­ca­ná̠tit y naca̠­chi­pa­ca­ná̠tit, antá naca̠­ma̠­ka­lha­pa­li̠­ca­ná̠tit nac xpu̠­ta­mak­stok­nicán judíos, naca̠­ta­mac­nu̠­ca­ná̠tit nac pu̠la̠­chi̠n, y caj quim­pa̠­la­cata naca̠­li̠­pin­ca­ná̠tit nac xla­ca­ti̠ncán ma̠pek­si̠­naní̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Y chuná chú hui­xinín nali̠­ka­lhi̠­yá̠tit quilh­ta­macú la̠qui̠ tla̠n naqui­la̠­li̠­chu­hui̠­na­ná̠hu pi̠ xli̠­ca̠na qui­la̠­li̠­pa̠­hua­ná̠hu. ");
INSERT INTO tocNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Xa̠huachí hui­xinín ni̠ a̠li̠sok cali̠­taaka­tzan­ké̠tit xla­cata lácu nakalh­ti̠­na­ná̠tit acxni̠ naca̠­ma̠­ka­lha­pa­li̠­ca­ná̠tit, ");
INSERT INTO tocNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","porque aquit nac­ca̠­ma̠x­qui̠yá̠n tala­ca­pa̠s­tacni la̠quí hua̠ntu̠ hui­xinín nali­chu­hui̠­na­ná̠tit ni̠ti̠cu lay cati­ca̠­kalh­ti̠­pa̠x­tokni, osuchí naca̠­ta̠­la̠­hua­niyá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Y maka­pi­tzí̠n la̠ hui­xinín hua̠nti̠ qui­la̠­li̠­pa̠­hua­ná̠hu naca̠­liak­ska­hui­nin­ca­ná̠tit, hasta ma̠squi min­tla̠tcán naca̠­ma­ca­ma̠s­ta̠yá̠n osuchí hua̠nti̠ min­ta̠­lacán, o hua̠nti̠ mili̠­ta­la­ka­pasni, osuchí miamigo; y hui̠ntí namak­ni̠cán la̠ hui­xinín. ");
INSERT INTO tocNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Xli̠­hua̠k cris­tianos naca̠­si̠­tzi̠­niyá̠n caj quim­pa̠­la­cata. ");
INSERT INTO tocNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero ni̠ cali̠­pu­huántit porque Dios hua̠k catzi̠y hua̠ntu̠ akspu­la­ya̠tit y ni̠para kantum miacchi­xitcán hua̠ntu̠ yá nac miakxa̠­kacán cati­tzán­ka̠lh para xlá ni̠ nala­cas­quín. ");
INSERT INTO tocNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Pus acxni̠ a̠má quilh­ta­macú aksti̠tum cali̠­pa̠­huántit Dios la̠qui̠ chuná tla̠n natax­tu­ni­yá̠tit a̠má lanca tala­ka­pú­tzi̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Acxni̠ naucxi­lhá̠tit pi̠ luu lhu̠hua tropa sti­li­hui­li̠ni̠t nahuán Jeru­salén, pus luu laca­tancs chú caca­tzí̠tit pi̠ acxni̠ amá̠­calh ma̠s­pu­tucán. ");
INSERT INTO tocNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ama̠­ko̠lh cris­tianos hua̠nti̠ tala­má̠­nalh nahuán nac Judea cata­tzá̠­lalh y catáalh nac ca̠ke̠s­tí̠ní̠n; y maka­pi­tzí̠n hua̠nti̠ tala­má̠­nalh nahuán nac xaca̠­chi­quí̠n Jeru­salén huata xatlá̠n na̠ cata­tzá̠­lalh, y hua̠nti̠ tas­cuj­má̠­nalh nahuán nac xca̠­tu­hua̠ncán mejor niaj cata­tás­pitli nac xchiccán. ");
INSERT INTO tocNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Porque acxni̠ a̠má quilh­ta­macú Dios naca̠­ma̠­pa̠­ti̠ni̠y cris­tianos la̠qui̠ nata­xo­ko̠nún xli̠­hua̠k hua̠ntu̠ tat­la­huani̠t, y na̠ acxni̠ nakan­taxtuy xta­chu­huí̠n Dios hua̠ntu̠ tatzok­ta­hui­lani̠t nac li̠kalh­ta­huaka caj hua̠ntu̠ xpa̠­la­cata Jeru­salén. ");
INSERT INTO tocNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Koxu­taní̠n a̠ma̠ko̠lh lac­chaján hua̠nti̠ acxni̠ a̠má quilh­ta­macú tata̠­tatlay nahuán osuchí tama̠­tzi­qui̠nán nahuán! Porque acxni̠ xli̠­ca̠na naanán lhu̠hua tapa̠tí̠n nac eé pu̠la­tama̠n, y acxni̠ la̠n naca̠­ma̠­pa̠­ti̠­ni̠cán cris­tianos hua̠nti̠ tala­má̠­nalh nahuán uú nac ca̠chi­quí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Lhu̠hua xala uú cris­tianos naca̠­li̠­mak­ni̠cán espada, y maka­pi­tzí̠n naca̠­chi­pacán y tachí̠n naca̠­le̠ncán cani̠huá nac a̠laca­tunu ca̠chi­quí̠n; a̠ma̠ko̠lh lac­chix­cu­huí̠n a̠laca­túnuj xalaní̠n hua̠nti̠ ni̠ judíos y ni̠ taca̠­naj­laniy Dios la̠n nata­li̠­ka­ma̠nán xaca̠­chi­quí̠n Jeru­salén hasta acxni̠ nakan­tax­tuko̠y la̠ta lácua lac­lhca̠­hui­li̠ni̠t Dios nata­pa̠­ti̠nán. ");
INSERT INTO tocNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Amá quilh­ta­macú acxni̠ nac­mim­paray, catu̠huá nata­siyuy nac chi­chiní hua̠ntu̠ ne̠cxni tasi­yuni̠t chú nac papá xa̠huá nac stacu; y xli̠­pu̠tum cris­tianos hua̠nti̠ tahui­lá̠­nalh nac xli̠­ca̠­lanca ca̠quilh­ta­macú nala­naj­talay y nata­pe̠­cuán, porque pupunú li̠pe̠cua la̠ natzucuy maca­sa̠nán y catu̠huá hua̠ntu̠ nataucxilha. ");
INSERT INTO tocNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Lhu̠hua cris­tianos caj la̠ta xta­pe̠­cuacán nata­la­ka­huitiy acxni̠ nata­ca­tzi̠y pi̠ lhu̠hua tapa̠tí̠n namín nac ca̠quilh­ta­macú; pus hasta xli̠­hua̠k hua̠ntu̠ huí nac akapú̠n nata­chi­quiy. ");
INSERT INTO tocNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Y xli̠­pu̠tum cris­tianos hua̠nti̠ tala­má̠­nalh nahuán nac ca̠quilh­ta­macú naquin­taucxilha aquit Xata­lac­sacni Chixcú pi̠ cta̠c­ta­ma̠chi nahuán nac akapú̠n nac xlacni puc­lhni, y na̠ nataucxilha pi̠ cli̠­mímaj nahuán xli̠­hua̠k qui­li̠­maka­tli­hueke, chu qui­li̠­ma̠­peksí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Acxni̠ chuná natzucuy kan­taxtuy hua̠ntu̠ cca̠­hua­nimá̠n, hui­xinín ni̠ cali̠­pu­huántit huata cala̠­ma̠uxca̠­ní̠tit y li̠pa̠­xúhu cata­la­ca­ya̠­huátit, porque acxni­tiyá lak­cha̠ni̠t nahuán quilh­ta­macú la̠ta lácu nac­miná̠n ca̠ti­yayá̠n la̠qui̠ nac­ca̠­lak­ma̠x­tuyá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesús ca̠li̠­ta̠­kalh­chu­hui̠­nampá aktum tala­ca­pa̠s­tacni y chiné ca̠huá­nilh: —Pus caj luu caca̠ucxílhtit la̠ta túcuya̠ quihui. ");
INSERT INTO tocNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Acxni̠ ucxi­lhá̠tit aka­yuja maka­pi­tzí̠n quihui y tzucuy akas­ka­tam­paray hui­xinín catzi̠­yá̠tit pi̠ aya tala­ca­tzu­hui̠ma quilh­ta­macú la̠ta natzucuy lhca̠cnán. ");
INSERT INTO tocNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Pus na̠chuna li̠túm acxni̠ chuná hui­xinín naucxi­lhá̠tit pi̠ kan­tax­tuma nahuán hua̠ntu̠ la̠nchú cca̠­hua­nimá̠n, pus caca­tzí̠tit pi̠ aya lak­cha̠ni̠t quilh­ta­macú la̠ta lácu Dios lac­lhca̠­hui­li̠ni̠t naca̠­lak­ma̠x­tuyá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Xli̠­cána cca̠­hua­niyá̠n pi̠ maka­pi­tzí̠n cris­tianos hua̠nti̠ la̠nchú tala­má̠­nalh nia̠ tani̠y cati­táhua acxni̠ nakan­taxtuy hua̠ntu̠ la̠nchú cca̠­hua­nimá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Caj la̠ta túcua anán nac akapú̠n chu nac ca̠quilh­ta­macú tla̠n nata­lak­tzanka̠y, pero quin­ta­chu­huí̠n ni̠ chu­natá cati­ta­mák­xtekli para ni̠ juerza nakan­taxtuy. ");
INSERT INTO tocNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Luu xli̠­ca̠na cuentaj cat­la­huátit min­quilh­ta­ma­cujcán ni̠tu̠ tili̠­mak­xte­ká̠tit mina­cujcán xla­cata huá naca̠­maka­tla­jayá̠n hua̠ntu̠ xalac­li̠xcáj­nit tapu­huá̠n, ni̠ caj naakkot­ta­pa̠­yá̠tit, y xa̠huachí ni̠ ca̠ta catu̠huá cala­ka­tí̠tit hua̠ntu̠ uú xala ca̠quilh­ta­macú, la̠qui̠ acxni̠ aquit nac­mim­páray ni̠tu̠ nac­ca̠­lak­chiná̠n acxni̠ ni̠ lia̠ca­tzi̠­hui­látit. ");
INSERT INTO tocNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Porque hui­xinín chuná amá̠n ca̠qui̠­tax­tu­niyá̠n a̠má quilh­ta­macú cumu la̠ akspulay tantum taka­lhí̠n acxni̠ tahua­ca­ya̠chá nac aktum trampa acxni̠ tica­tzi̠y aya pa̠ti̠ni̠t, pus na̠chuná nac xli̠­ca̠­lanca ca̠quilh­ta­macú ni̠ talia̠ca­tzi̠­hui­lá̠­nalh nahuán cris­tianos acxni̠ nalak­chá̠n a̠má quilh­ta­macú la̠ aquit nac­mim­paray. ");
INSERT INTO tocNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Pus hui­xinín luu ská­lalh cata­hui­látit y anka­lhi̠ná cakalh­ta­hua­ka­nítit Dios la̠qui̠ chuná tla̠n naka­lhi̠­yá̠tit li̠ca­mama chu li̠t­li­hueke, y tla̠n natax­tu­ni­yá̠tit a̠má lanca tapa̠tí̠n hua̠ntu̠ namín, y xa̠huachí la̠qui̠ tla̠n naqui­la̠­ma̠­la­ca­tzu­hui̠­yá̠hu acxni̠ aquit nac­mim­paray. ");
INSERT INTO tocNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesús anka­lhí̠n acxni̠ ca̠cu­huiní xca̠­ma̠­kalh­chu­hui̠ni̠y cris­tianos nac lanca pu̠si­culan, y ca̠tzi̠sa xán lak­tun­cu­huiy nac ke̠stí̠n hua̠ntu̠ hua­nicán Monte de los Olivos. ");
INSERT INTO tocNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Y cha̠li cha̠lí laca­tzi̠sa xta­chín nac lanca pu̠si­culan lhu̠hua cris­tianos la̠qui̠ nata­kax­matniy xta­chu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Aya xla­ca­tzu̠­hua­nama quilh­ta­macú la̠ta nalak­chá̠n xapa̠xcua taak­spun­tza̠lí̠n acxni̠ xli̠­pu̠tum judíos xta­huay cax­ti­lá̠n­chahu hua̠ntu̠ ni̠tu̠ kalhi̠y leva­dura. ");
INSERT INTO tocNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ama̠­ko̠lh xana­puxcun cura xa̠hua xma̠­kalh­ta­hua­ke̠­nacán judíos aya xta­lac­pu­tza­má̠­nalh lácu natat­la­huay la̠qui̠ tla̠n nata­chipay y nata­makni̠y Jesús. Pero cumu luu lhu̠hua cris­tianos xta­li̠­pa̠­huá̠n xlacán xta­pe̠­cuaniy chicá para nata­si̠­tzi̠niy. ");
INSERT INTO tocNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Pero akska­huiní tánu̠lh nac xta­la­ca­pa̠s­tacni Judas Isca­riote; huá u̠má Judas na̠ xca̠­ta̠­ta­peksi̠y xli̠­ka­lha­cu̠tiy após­toles. ");
INSERT INTO tocNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Xlá la̠li̠­huán alh ca̠ta̠­chu­hui̠nán xana­puxcun cura chu hua̠nti̠ xta­ma̠­pek­si̠nán nac lanca pu̠si­culan la̠qui̠ naca̠­ta̠­la­ca̠xlay y naca̠­ma­ca­ma̠x­qui̠y Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Acxni̠ xlacán tacá­tzi̠lh hua̠ntu̠ xca̠­ma̠­lac­nu̠­ni­má̠­calh luu tali̠­pa̠­xu­hua­ko̠lh y tahuá­nilh pi̠ nata­ma̠x­qui̠y tumi̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas na̠ tla̠n tlá­hualh y pu̠tum tzú­culh talac­pu­tzay la̠ta lácu tla̠n naca̠­ma­ca­ma̠x­qui̠y Jesús acxni̠ ni̠ luu lhu̠hua tala­yá̠­nalh nahuán cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Acxni̠ lák­cha̠lh quilh­ta­macú cxa­pa̠xcua taak­spun­tza̠lí̠n, acxni̠ pu̠tum judíos xta­huay cax­ti­lá̠n­chahu hua̠ntu̠ ni̠tu̠ kalhi̠y leva­dura, y na̠ acxni̠ xca̠­mak­ni̠cán xalactzu bor­regos hua̠ntu̠ nahuacán la̠qui̠ chuná nali̠­la­ka­chix­cu­hui̠­nancán nac a̠má pa̠xcua, ");
INSERT INTO tocNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesús ca̠má­ca̠lh Pedro chu Juan y chiné ca̠huá­nilh: —La̠li̠­huán capim­pítit caqui̠­ca̠x­tla­huátit quin­ta­huajcán hua̠ntu̠ nahua­yá̠hu la̠nchú nac xapa̠xcua taak­spun­tza̠lí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","—¿Nícu laca­squina naca­na̠huá ca̠x­tla­hua­yá̠hu? —takalh­tí̠­nalh xlacán. ");
INSERT INTO tocNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús chiné ca̠kálh­ti̠lh: —Acxni̠ hui­xinín nachi­pi­ná̠tit nac ca̠chi­quí̠n, naucxi­lhá̠tit cha̠tum chixcú cuca­le̠ma pa̠tum stu̠n chú­chut. Hui­xinín ca­sta̠­la­nítit hasta nac chiqui anta­nícu xlá nata­nu̠­ya̠chá, ");
INSERT INTO tocNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","y chiné nahua­ni­yá̠tit xpu̠­chiná chiqui: “Huan Quim­pu̠­chi­nacán: ¿Nícu huí a̠má pu̠lactum cuarto anta­nícu nac­ca̠­ta̠­hua̠yán quin­ta­ma̠­kalh­ta­huaké̠n eé ca̠tzi̠sní nac xapa̠xcua taak­spun­tza̠lí̠n?” ");
INSERT INTO tocNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Y antá naca̠­ma̠­si­yu­ni­ca­ná̠tit pu̠lactum cuarto tzinú tlak ca̠lak­lanca nac xli̠­quilh­mactiy chiqui, antá aya li̠huana̠ ma̠ca̠­qui̠­cani̠t; pus antá caca̠x­tla­huátit quin­ta­huajcán. ");
INSERT INTO tocNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Xlacán la̠li̠­huán táalh y xli̠­cána chuná tama̠­nók­lhulh cumu la̠ Jesús xca̠­hua­nini̠t, y antá taca̠x­tlá­hualh tahuá hua̠ntu̠ nata­li̠­la­ka­chix­cu­hui̠nán xapa̠xcua taak­spun­tza̠lí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ca̠ko̠­tanú̠n lák­cha̠lh hora Jesús chu xapós­toles pu̠tum tácha̠lh; y acxni̠ tatáhui nac mesa, ");
INSERT INTO tocNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","pus Jesús chiné ca̠huá­nilh: —Mak­lhu̠­huatá clac­pu­huani̠t xla­cata pu̠tum lac­xtum nac­ca̠­ta̠­hua̠­yaná̠n nac eé xapa̠xcua taak­spun­tza̠lí̠n li̠huán nia̠ cni̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Porque xli̠­ca̠na laca­tancs cca̠­hua­niyá̠n pi̠ niaj maktum chuná cac­ti­huá̠­yalh hasta acxni̠ nakan­tax­tuko̠y hua̠ntu̠ Dios lac­lhca̠­hui­li̠ni̠t nac xta­péksi̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Aca­li̠stá̠n tíyalh pa̠tum vasu xchú­chut uva, pa̠x­cat­ca­tzí̠­nilh Dios, y chiné ca̠huá­nilh: —Cahua­pítit eé aca­tzuní̠n y mili̠­hua̠kcán cali̠­ta­ka­tzí̠tit. ");
INSERT INTO tocNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Porque xli̠­cána cca̠­hua­niyá̠n pi̠ niaj cac­ti­li̠­kót­nulh xchú­chut uva hasta acxni̠ nalak­chá̠n quilh­ta­macú acxni̠ luu nalay nac xli̠­ca̠­lanca xta­pa̠­xu­huá̠n Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Aca­li̠stá̠n tíyalh cax­ti­lá̠n­chahu, pa̠x­cat­ca­tzí̠­nilh Dios y lak­ché­kelh, ca̠má̠x­qui̠lh xta­ma̠­kalh­ta­huaké̠n y chiné ca̠huá­nilh: —Huá eé cax­ti­lá̠n­chahu li̠taxtuy quin­ti­yat­li̠hua hua̠ntu̠ cma­ca­ma̠sta̠y caj mim­pa̠­la­ca­tacán la̠qui̠ chuná tla̠n nac­ca̠­lak­ma̠x­tuyá̠n. Chuná hui­xinín cat­la­hua­pítit hua̠ntu̠ la̠nchú ctla­huama la̠qui̠ anka­lhi̠ná naqui­la̠­li̠­la­ca­pa̠s­ta­cá̠hu. ");
INSERT INTO tocNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Y na̠chuná tla­huapá acxni̠ tahua̠­yan­ko̠lh, tíyalh a̠má vasu hua̠ntu̠ xpu̠­ta­ju̠ma xchú­chut uva, y chiné ca̠huá­nilh: —Huá u̠má xchú­chut uva anka­lhí̠n naca̠­ma̠­la­ca­pa̠s­ta­cayá̠n pi̠ Dios ca̠ta̠t­la­hua­ni̠tán aktum xasa̠sti tala­ca̠xlán la̠ta lácu naca̠­lak­ma̠xtuy cris­tianos, porque a̠má quin­kalhni hua̠ntu̠ nas­taj­ta­makán caj mim­pa̠­la­ca­tacán luu nama̠­lu­loka pi̠ xli̠­ca̠na. ");
INSERT INTO tocNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pero laca­tancs caca­tzí̠tit pi̠ a̠má chixcú hua̠nti̠ ámaj qui­ma­ca­ma̠sta̠y la̠nchú lac­xtum maca­huácaj quin­ta̠hui nac mesa. ");
INSERT INTO tocNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Porque aquit cámaj ni̠y chuná cumu la̠ Dios lac­lhca̠­hui­li̠ni̠t caj quim­pa̠­la­cata, pero koxu­tacú tihuán a̠má chixcú hua̠nti̠ naqui­liak­ska­huinín. ");
INSERT INTO tocNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ama̠­ko̠lh xta­ma̠­kalh­ta­huaké̠n tzú­culh tala̠­ka­lhas­quín sac­stucán y chiné xta­la̠­huaniy: —¿Xatícu cahuá ámaj maca­ma̠sta̠y? ");
INSERT INTO tocNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Aca­li̠stá̠n xlacán tzú­culh tala̠­li̠­ma̠aklhu̠­hui̠y caj xla­cata xatícu a̠tzinú tlak tali̠­pa̠huá nali̠­taxtuy y naca̠­ma̠­peksi̠y xa̠maka­pi­tzí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesús chiné ca̠ma̠­kalh­chu­huí̠­ni̠lh: —Cumu la̠ hui­xinín catzi̠­yá̠tit xla­cata hua̠nti̠ tama̠­pek­si̠nán nac aktum ca̠chi­quí̠n catu̠huá tat­la­huaniy hua̠ntu̠ antá anán cumu lá̠m­para luu xlacán, y hua̠nti̠ tapuxcún la̠qui̠ nata­ma̠­pek­si̠nán, xlacán tali̠­taxtuy cumu lá̠m­para luu lacuán cris­tianos hua̠nti̠ xli̠­ca̠na tat­la­huay li̠tlá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero hui­xinín hua̠nti̠ qui­la̠­li̠­pa̠­hua­ná̠hu ni̠chuná cati­ca̠­qui̠­tax­tunín porque hua̠nti̠ tlak le̠ná̠hu quilh­ta­macú y luu a̠tzinú tlak tali̠­pa̠huá maklh­ca­tzi̠cán huata mejor xlá cali̠­táx­tulh cumu lá̠m­para ni̠tu̠cu xkásat; y hua̠nti̠ luu ma̠pek­si̠nán huata xlá cali̠­táx­tulh cumu la̠ hua̠nti̠ naka­lha­kax­mat­ni̠nán hua̠ntu̠ nali̠­ma̠­pek­si̠cán. ");
INSERT INTO tocNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Na̠chuná cumu la̠ hui­xinín catzi̠­yá̠tit, hua̠nti̠ a̠má chixcú tlak tali̠­pa̠hu y ma̠pek­si̠nán, pus huata huá tahuilay nac mesa la̠qui̠ nahua̠yán y la̠ta xli̠­lhu̠hua xta­sa̠cua antá tayá̠­nalh y tali̠s­cuj­má̠­nalh. Pero huata tu̠ aquit qui­la­cata ni̠chuná qui̠­tax­tuma porque aquit clama nac milak­sti̠­pa̠ncán cumu la̠ hua̠nti̠ xli̠­ca̠na ca̠li̠­scuj­má̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Y la̠ta túcua aquit quiok­spu­lama y hua̠ntu̠ cli̠­li̠­pu­huán hui­xinín anka­lhi̠ná qui­la̠­ta̠­la­pu̠­la­yá̠hu y na̠ qui­la̠­ta̠­pa̠­ti̠­ma̠­náhu. ");
INSERT INTO tocNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Huá xpa̠­la­cata cca̠­li̠­hua­niyá̠n, cumu la̠ Quin­tla̠t qui­ma̠x­qui̠y aktum pu̠tá­hui̠lh anta­nícu nac­li̠­ma̠­pek­si̠nán pus na̠chuná nac­ca̠­ma̠x­qui̠yá̠n mim­pu̠­ta­hui̠lhcán hua̠ntu̠ hui­xinín naka­lhi̠­yá̠tit, ");
INSERT INTO tocNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","la̠qui̠ antá lac­xtum naqui­la̠­ta̠­hua̠­ya­ná̠hu y naqui­la̠­ta̠­pa̠­xu­hua­yá̠hu nac qui­mesa, y la̠qui̠ nata­hui­la­yá̠tit nac mim­pu̠­ma̠­pek­si̠ncán anta­nícu namak­ma̠­pek­si̠­yá̠tit a̠ma̠ko̠lh pu̠lac­cu̠tiy xapu̠­la­tama̠n Israel hua̠ntu̠ pu̠lh ma̠la­ca­tzu­qui̠­cani̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Quim­pu̠­chi­nacán Jesús chiné huá­nilh chú Pedro: —Simón, huix luu cakáx­patti hua̠ntu̠ cuanimá̠n porque akska­huiní aya ma̠x­qui̠­cani̠t quilh­ta­macú la̠qui̠ chú naliucxi­lhá̠n nac mila­táma̠t para ca̠na qui­li̠­pa̠­huana, y la̠n naca̠­lac­tin­cxá̠n mili̠­pac­scán cumu la̠ a̠ tla­huacán acula. ");
INSERT INTO tocNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero aquit aya cca̠­mak­chu­hui̠­na­ni̠tán nac xla­catí̠n Quin­tla̠t la̠qui̠ a̠má min­ta­ca̠­naj­latcán ne̠cxni natat­laji̠y, y chi̠nchú acxni̠ huix aya tax­tu­ni­ni̠ta nahuán hua̠ntu̠ liaktzanka, pus chú huata caca̠­mak­ta̠ya xa̠maka­pi­tzí̠n min­ta̠­cris­tianos acxni̠ xlacán na̠ naca̠­tzak­sacán nac xla­ta­ma̠tcán cumu la̠ huix tzak­sa­ca­ni̠ta nahuán. ");
INSERT INTO tocNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simón chiné huá­nilh: —Ma̠kalh­ta­hua­ke̠ná, aquit luu aktum cca­tzi̠y ma̠squi lac­xtum caquin­ta̠­li̠­pín­canti nac pu̠la̠­chi̠n y ma̠squi lac­xtum quin­ta̠­mak­ní̠­canti. ");
INSERT INTO tocNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús chiné kálh­ti̠lh: —Pedro, huata luu laca­tancs cuani­pu­tuná̠n la̠nchú pi̠ acxni̠ nia̠ tasay nahuán pu̠yu huix aya hua­ni̠­tatá nahuán xli̠­mak­tutu pi̠ ni̠ qui­la­ka­pasa acxni̠ naka­lhas­quin­cana. ");
INSERT INTO tocNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesús chiné ca̠ka­lhás­quilh xta­ma̠­kalh­ta­huaké̠n: —Chicá cuan la̠ a̠ cti­ca̠­macá̠n li̠cha̠­tiyú̠n acxni̠ qui̠­lac­scújtit li̠chu­hui̠­nántit xta­chu­huí̠n Dios, la̠ a̠ ni̠tu̠ xli̠­pi­ná̠tit mimur­ra̠lhcán, ni̠para min­tu­mi̠ncán, ni̠para min­tu̠­xu̠­huacán, pero ¿túcu xca̠­tzan­ka̠­nimá̠n? —Ni̠tu̠ quin­ca̠­tzan­ka̠­ni­ni̠tán —takalh­tí̠­nalh xlacán. ");
INSERT INTO tocNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Xlá chiné ca̠huá­nilh: —Pus chú la̠nchú hua̠nti̠ kalhi̠y xmúr­ra̠lh cale̠lh; y hua̠nti̠ kalhi̠y xpu̠­ma̠­qui̠cán xtumi̠n pus huata na̠ cale̠lh; y hua̠nti̠ ni̠tu̠ kalhi̠y xes­pada cata­má̠­hualh, hasta ma̠squi luu xla­ca­squinca cas­ta̠lh xta­maknu la̠qui̠ chuná naka­lhi̠y tumi̠n y nata­ma̠­huay hua̠ntu̠ tzan­ka̠­nima. ");
INSERT INTO tocNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Porque laca­tancs cca̠­hua­niyá̠n pi̠ la̠nchú nakan­taxtuy nac qui­la­táma̠t hua̠ntu̠ tatzok­ta­hui­lani̠t nac li̠kalh­ta­huaka anta­nícu chiné huan: “Chuná li̠ma̠x­tú­calh cumu la̠ cha̠tum mak­ni̠ná chixcú y ma̠la­ca­pú̠­calh.” Pus chuná hua̠k nakan­taxtuy hua̠ntu̠ tatzok­ta­hui­lani̠t nac xta­chu­huí̠n Dios caj quim­pa̠­la­cata. ");
INSERT INTO tocNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Xlacán chiné takalh­tí̠­nalh: —Quim­pu̠­chi­nacán, uú huí aktiy espada. Huata xlá ca̠kálh­ti̠lh: —Aya tla̠n cahuan­tama. ");
INSERT INTO tocNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Aca­li̠stá̠n Jesús táx­tulh nac xaca̠­chi­quí̠n Jeru­salén y antá alh nac Monte de los Olivos cumu la̠ mak­lhu̠­huatá chuná xlá xli̠s­ma­ni̠ni̠t y na̠ ta­sta̠­lá­nilh xta­ma̠­kalh­ta­huaké̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Acxni̠ antá tácha̠lh chiné ca̠huá­nilh: —Hua̠k cakalh­ta­hua­ka­nítit Dios la̠qui̠ ni̠ natat­la­ji̠­yá̠tit acxni̠ naca̠­tzak­sa­ca­ná̠tit. ");
INSERT INTO tocNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jesús tatam­pú̠x­tulh tzinú alh tlak laka­mákat y antá tatzo­kós­talh la̠qui̠ nakalh­ta­hua­kaniy Dios, ");
INSERT INTO tocNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","y chiné kalh­ta­hua­ká­nilh huá­nilh: —Papá Dios, para huix chuná laca­squina pus huata cat­lahua li̠tlá̠n caqui­ma̠­ta­pa̠­nu̠ni u̠má tapa̠tí̠n hua̠ntu̠ aquit ámaj quim­pa̠x­toka. Pero ni̠ huá calalh quin­ta­pa̠­xu­huá̠n huata mejor huá cakan­táx­tulh min­ta­pa̠­xu­huá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Y acxni­tiyá tasi­yú­nilh cha̠tum ángel xalac akapú̠n la̠qui̠ xlá nama̠x­qui̠y li̠ca­mama. ");
INSERT INTO tocNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Y acxni̠ luu li̠pe̠cua la̠ xli̠­pu­huama a̠tzinú tlak li̠t­li­hueke xkalh­ta­hua­kaniy Dios y cxúnut a̠huayu la̠ kalhni lank lank xta̠c­tama hasta nac ca̠ti­yatni. ");
INSERT INTO tocNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Acxni̠ chuná kalh­ta­hua­ka­ni­ko̠lh Dios ca̠lá­kalh xta­ma̠­kalh­ta­huaké̠n y hua̠k xalh­tatán ca̠ma̠­nók­lhulh, porque xlacán luu snu̠n xta­li̠­pu­hua­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Huata xlá chiné ca̠huá­nilh: —¿Túcu xpa̠­la­cata li̠lh­ta­ta­pá̠tit? La̠li̠­huán cata̠­quí̠tit y cakalh­ta­hua­ka­nítit Dios la̠qui̠ ni̠ natat­la­ji̠­yá̠tit acxni̠ ca̠tzak­sa­ca­ná̠tit. ");
INSERT INTO tocNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Chu­nacú xchu­hui̠­nama Jesús acxni̠ pu̠tum tachilh lhu̠hua cris­tianos. Huá xca̠­pu̠­la­ni­ti̠­lhay Judas hua̠nti̠ na̠ xca̠­ta̠­ta­peksi̠y xli̠­ka­lha­cu̠­tiycán dis­cí­pulos. Xlá lak­ta­la­ca­tzú­hui̠lh la̠qui̠ naxa­katli̠y y tla̠n nala­ca­tzu̠ca. ");
INSERT INTO tocNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Acxni̠ chuná tla­hua­ko̠lh, Jesús chiné huá­nilh: —Judas, ¿caj la̠ta huix qui­la­cá­tzu̠cti huá chuná qui­li̠­ma­ca­ma̠s­tá̠pa̠t aquit Xata­lac­sacni Chixcú? ");
INSERT INTO tocNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Y hua̠nti̠ antá pu̠tum xta­ta̠­yá̠­nalh Jesús acxni̠ xlacán taúcxilhli hua̠ntu̠ xlama chiné tahuá­nilh: —Quim­pu̠­chi­nacán, ¿lácu huana, pi̠ cli̠­ma­ca­hua­ná̠hu quiespa­dajcán? ");
INSERT INTO tocNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Xlá nia̠ xkalh­ti̠nán acxni̠ cha̠tum la̠li̠­huán xtat má̠x­tulh xes­pada y ca̠c­tí̠­nilh xtaké̠n cha̠tum xta­sa̠­cuacán xapuxcu cura. ");
INSERT INTO tocNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pero Jesús chiné ca̠huá­nilh: —Aya tla̠n ni̠chuná caca̠t­la­huátit. Aca­li̠stá̠n xlá xamá­nilh xtaké̠n a̠má xta­sa̠­cuacán cura y ma̠akat­lá̠n­ti̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesús cacs ca̠la­caúcxilhli a̠ma̠ko̠lh xana­puxcun cura chu xana­puxcún hua̠nti̠ xta­mak­ta­kalhnán nac lanca pu̠si­culan xa̠hua lak­ko̠­lu­tzi̠nni ma̠pek­si̠­naní̠n hua̠nti̠ xta­mini̠t tachipay, y chiné ca̠huá­nilh: —¿Túcu xpa̠­la­cata hui­xinín uú li̠ta­ni̠­tátit ya̠ quihui chu ya̠ ma̠chi̠ta la̠qui̠ naqui­la̠­chi̠­le̠­ná̠hu cumu la̠ cha̠tum kalha̠ná? ");
INSERT INTO tocNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Acxni̠ aquit pu̠tum xac­ca̠­ta̠­lamá̠n cha̠li cha̠lí nac lanca pu̠si­culan hui­xinín ni̠para maktum xqui­la̠­chi­páhu, pero la̠nchú ca̠lak­chi­ni̠tán quilh­ta­macú acxni̠ nala­ka­ca̠­puc­suanan­ko̠­yá̠tit porque huá chú naca̠­ma̠­pek­si̠yá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Y chi­pá­calh Jesús, tachí̠n lé̠n­calh antá nac xchic xapuxcu cura, y Pedro csta̠­la­ni­ti̠­lhay tzinú tlak laka­mákat. ");
INSERT INTO tocNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Acxni̠ antá tácha̠lh nac pu̠chu­huí̠n antá ma̠lh­cu­yú­calh nac xtan­quilhtí̠n chiqui y pu̠tum poli­cías tatáhui nac xli̠­kalh­lanca a̠má lhcúya̠t, y na̠ antá mak­táhui Pedro. ");
INSERT INTO tocNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Caj puntzú aya milh cha̠tum squi­ti­hui̠ná; acxni̠ xlá úcxilhli pi̠ antá xmak­lahui anta­nícu xma̠lh­cu­yu­cani̠t, cacs lacaúcxilhli puntzú y chiné ca̠huá­nilh xa̠maka­pi­tzí̠n: —Huá chicá eé chixcú na̠ xta̠­lat­la̠­huán Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Huata Pedro ni̠ ca̠kalh­ta­si­yú­nilh y chiné huá­nilh: —Pusca̠t, aquit laca­tancs cuaniyá̠n pi̠ ni̠para tzinú cla­ka­pasa hua̠nti̠ huix hua­nípa̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Caj li̠pun­tzu̠­li̠túm cha̠tum hua̠nti̠ ucxilhpá y na̠ laká­pasli, chiné huá­nilh: —Xli̠­ca̠na cuan huix na̠ min­com­pa­ñero a̠má chixcú. Pedro chiné huá­nilh: —Cará kahua, xli̠­ca̠na cuaniyá̠n pi̠ ni̠ aquit. ");
INSERT INTO tocNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Y alh quilh­ta­macú ma̠x cumu aktum hora acxni̠ cha̠tum luu laca­tancs ca̠ma̠­lu­lók­nilh xa̠maka­pi­tzí̠n y chiné ca̠huá­nilh: —Xli̠­ca̠na cuan, u̠má chixcú na̠ lac­xtum xta̠­la­pu̠lay Jesús, pus mákat tuncán tala­ka­pasa porque xlá na̠ chu­hui̠nán cumu la̠ ti̠ xalac Gali­lea. ");
INSERT INTO tocNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Y Pedro chiné huá­nilh: —Pero xli̠­ca̠na cuaniyá̠n pi̠ ni̠para tzinú cca­tzi̠y hua̠ntu̠ li̠chu­hui̠­námpa̠t. Acxni­tiyá a̠má acxni̠ Pedro xchu­hui̠­na­majcú tásalh tantum pu̠yu. ");
INSERT INTO tocNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Quim­pu̠­chi­nacán Jesús lak­ta­la­kás­pitli anta­nícu xyá y la̠ta xli̠­la­ka­mákat lacaúcxilhli Pedro, y huata xlá laca­pá̠s­tacli hua̠ntu̠ xlá xuanini̠t: “Acxni̠ nia̠ tasay nahuán pu̠yu huix aya hua­ni̠­tatá nahuán mak­tutu pi̠ ni̠ qui­la­ka­pasa.” ");
INSERT INTO tocNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pedro la̠li̠­huán táx­tulh nac quilhtí̠n y caj la̠ta xta­li̠­pu­huá̠n antá tzú­culh tasay. ");
INSERT INTO tocNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ama̠­ko̠lh lac­chix­cu­huí̠n hua̠nti̠ xta­mak­ta­kalh­má̠­nalh Jesús la̠n tali̠­ka­má̠­nalh y la̠n tahui­lí̠­nilh. ");
INSERT INTO tocNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tali̠­la­ká­chi̠lh mactum lháka̠t y tzú­culh tala­kas­noka nac xlacán y chiné xta­huaniy: —Cama̠­lak­chi­pini tícu hui­li̠nín. ");
INSERT INTO tocNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Y lhu̠hua catu̠huá hua̠ntu̠ xta­huaniy caj la̠ta xta­li̠­kalh­ka­ma̠nán. ");
INSERT INTO tocNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Acxni̠ spalh ca̠x­ka­ka­ko̠lh pu̠tum tata­mac­xtú­mi̠lh xalak­ko̠­lu­tzi̠nni ma̠pek­si̠­naní̠n chu xana­puxcún cura, xa̠huá xma̠­kalh­ta­hua­ke̠­nacán judíos nac xpu̠­ma̠­pek­si̠ncán y antá lé̠n­calh Jesús nac xla­ca­ti̠ncán, y xlacán chiné taka­lhás­quilh: ");
INSERT INTO tocNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Caqui­la̠­hua­níhu, ¿pi̠ xli̠­ca̠na huix qui­ma̠aka­pu̠­tax­ti̠­nacán aquinín judíos hua̠nti̠ xli̠­mínit xuani̠t nac ca̠quilh­ta­macú? Xlá chiné ca̠kálh­ti̠lh: —Para nac­ca̠­hua­niyá̠n pi̠ xli̠­ca̠na, hui­xinín ni̠ cati­ca̠­naj­látit. ");
INSERT INTO tocNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Y para aquit nac­ca̠t­la­hua­niyá̠n aktum taka­lhas­quiní̠n hua̠ntu̠ aquit xac­li̠­ta­mak­tá̠­yalh, hui­xinín ni̠ caquin­ti­la̠­kalh­tí̠hu, y ni̠para quin­ti­la̠­mak­xtekui. ");
INSERT INTO tocNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero aya tala­ca­tzu­hui̠ma quilh­ta­macú acxni̠ aquit Xata­lac­sacni Chixcú cuilachá nahuán nac xpa̠xtú̠n Quin­tla̠­ticán Dios hua̠nti̠ lanca xla­ca­tzúcut la̠qui̠ lac­xtum nac­ta̠­ma̠­pek­si̠nán. ");
INSERT INTO tocNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Y xpu̠­tumcán chiné taka­lhás­quilh: —¿Lácu pi̠ xli̠­ca̠na chi̠nchú huix Xka­huasa Dios? —Xli̠­ca̠na aquit Xka­huasa Dios chuná cumu la̠ hui­xinín quilh­uampá̠tit —ca̠kálh­ti̠lh Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Xlacán chiné táhua: —¿Túcuaj ya̠ tes­tigo tila­cas­qui­ná̠hu? Porque mismo chú aquinín ma̠n kalha­kax­mat­ni̠­táhu lácu li̠kalh­ka­ma̠­nani̠t Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Aca­li̠stá̠n pu̠tum hua̠k tatá̠­yalh y tále̠lh Jesús nac xla­catí̠n ma̠pek­si̠ná Pilato. ");
INSERT INTO tocNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Acxni̠ antá tácha̠lh catu̠huá tzú­culh tali̠­ya̠­huay y chiné xta­huán: —Aquinín cma̠­nok­lhu­ni̠­táhu eé chixcú acxni̠ xlá xca̠­ma̠­la­kas­pitma cris­tianos, xlá huan pi̠ mat ni̠tlá̠n la̠ cla­ka­xo­ko̠­nu­ni­ma̠­náhu gobier­no xalac Roma, y xa̠huachí huam­paray pi̠ mat huá ma̠lak­tax­ti̠ná, huá li̠tax­tu­putún a̠má rey hua̠nti̠ namín quin­ca̠­ma̠­pek­si̠yá̠n aquinín judíos. ");
INSERT INTO tocNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Y Pilato chiné kalhás­quilh: —¿Lácu pi̠ xli̠­ca̠na chi̠nchú huix xreycán judíos? —Xli̠­ca̠na tla̠n para chuná cahuá cumu la̠ huix huana —kálhti̠lh Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato ca̠huá­nilh xana­puxcun cura chu xli̠­hua̠k cris­tianos: —Aquit ni̠ cmac­laniy xcuenta hua̠ntu̠ nac­li̠­ya̠­huay eé chixcú. ");
INSERT INTO tocNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Huata xlacán a̠tzinú luu li̠huana̠ palha tzú­culh taqui­lhaniy: —Pero tamá chixcú ma̠rí ca̠ma̠­la­kas­pitma cris­tianos caj xpa̠­la­cata hua̠ntu̠ xlá ca̠liakchu­hui̠­na­nima, chu­natá la̠ta tima̠­tzu­qui̠chá nac Gali­lea, y chú aya chini̠t uú. ");
INSERT INTO tocNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Acxni̠ Pilato káx­matli hua̠ntu̠ xlacán xta­qui­lhuamá̠­nalh kalhas­qui­ní̠­nalh para xli̠­ca̠na a̠má chixcú antá xalac Gali­lea xuani̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Y acxni̠ hua­ní­calh pi̠ xli̠­ca̠na Jesús xalac Gali­lea xuani̠t, huata xlá huá ma̠la­ka­chá̠­nilh rey Herodes la̠qui̠ huata huá nama̠­ka­lha­pali̠y porque huá xlá xuí li̠go­ber­nador nac Gali­lea, pero acxni̠ a̠má quilh­ta­macú xlá xmini̠t paxia̠lhnán nac Jeru­salén. ");
INSERT INTO tocNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Amá rey Herodes aya xkax­matni̠t la̠ta lácu xli̠­chu­hui̠­nancán xta­scújut Jesús y acxni̠ chú úcxilhli pa̠xu­hua­ko̠lh porque xlá xla­cas­quín pi̠ antá nac xla­catí̠n nat­la­huay aktum lanca li̠cá̠cni̠t ta­scújut. ");
INSERT INTO tocNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Catu̠huá hua̠ntu̠ xlá kalhás­quilh pero Jesús ni̠tu̠cu kálh­ti̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Y na̠ antá xta­hui­lá̠­nalh xana­puxcun cura xa̠hua xma̠­kalh­ta­hua­ke̠­nacán judíos hua̠nti̠ ca̠ta catu̠huá xta­li̠­ma̠­la­ca­pu̠­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Chi̠nchú a̠má Herodes luu li̠pe̠cua tzú­culh si̠tzi̠niy, y huata na̠ tzú­culh tali̠­kalh­ka­ma̠nán, xa̠hua xli̠­pu̠tum xtropa, caj la̠ta tali̠­ka­má̠­nalh tama̠­lhá­ke̠lh mactum xatlá̠n lháka̠t cumu la̠ xla rey; y aca­li̠stá̠n Herodes ma̠la­ka­cha̠­nipá Pilato. ");
INSERT INTO tocNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Amá quilh­ta­macú rey Herodes chu gober­nador Pilato luu xli̠­ca̠na amigos tala̠t­la­huapá porque xapu̠lh luu xla̠­ma­ka­si̠­tzi̠y y ni̠ xla̠ucxilh­putún. ");
INSERT INTO tocNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato pu̠tum ca̠ma̠­ké̠s­tokli xana­puxcun cura xa̠huá hua̠nti̠ xta­ma̠­pek­si̠nán chu xli̠­hua̠k cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Y chiné ca̠huá­nilh: —Hui­xinín qui­la̠­li̠­mi­ni­ni̠­táhu eé chixcú porque hua­ná̠tit pi̠ ma̠rí ca̠ma̠­la­kas­pitma cris­tianos; pero aquit aya cma̠­kalh­pu­tzá̠­ni̠lh nac mila­ca­ti̠ncán y ni̠tu̠cu cmac­lá­nilh xcuenta la̠ta túcua hui­xinín li̠ma̠­la­ca­pu̠­yá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Pus na̠chuná Herodes na̠ ni̠tu̠ mac­lá­nilh xcuenta hua̠ntu̠ nali̠­ya̠­huay, pus huá quin­ca̠­li̠­ma̠­la­ka­cha̠­ni­parán. Pus antá chú laca­tancs li̠ta­siyuy pi̠ u̠má chixcú ni̠tu̠ tla­huani̠t hua̠ntu̠ ni̠tlá̠n y hua̠ntu̠ mini̠niy nac­li̠­ma̠­mak­ni̠­ni̠nán. ");
INSERT INTO tocNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Huata tu̠ nac­tla­huay nac­ma̠­pa̠­ti̠ni̠y tzinú y acxni̠ nake̠s­nok­ko̠cán chú nac­mak­xteka. ");
INSERT INTO tocNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Acxni̠ xlay xpa̠x­cuajcán judíos xla taak­spun­tza̠lí̠n gober­nador Pilato anka­lhi̠ná ca̠ta ca̠ta xmak­xteka cha̠tum tachí̠n porque luu chuná xta­li̠s­quiniy judíos. ");
INSERT INTO tocNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pero acxni̠ xlacán takáx­matli pi̠ namak­xteka Jesús xli̠­pu̠­tumcán tzú­culh taqui­lhaniy: —¡Tamá chixcú camakni! ¡Huata mejor xatlá̠n camák­xtekti Bar­rabás! ");
INSERT INTO tocNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Amá Bar­rabás xlá xta­mac­nu̠­cani̠t nac pu̠la̠­chi̠n porque huá xma̠­la­ca­tzu­qui̠ni̠t aktum taaklhú̠­hui̠t nac xca̠­chi­quí̠n y na̠ ma̠k­ni̠ná xuani̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato juerza xmak­xtek­putún Jesús y ca̠ta̠­chu­hui̠­nampá a̠maktum cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero huata xlacán a̠tzinú palha tzú­culh taqui­lhaniy: —¡Cape­kex­to­ko­huaca nac cruz! ¡Cape­kex­to­ko­huaca nac cruz! ");
INSERT INTO tocNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Xli̠­mak­tutu Pilato chiné ca̠hua­nipá: —¿Pero túcuya̠ tala̠­ka­lhí̠n tla­huani̠t? Porque aquit ni̠tu̠ cmac­laniy para túcu nac­li̠­ma̠­lu­lokniy xla­cata tla̠n nac­makni̠y. Huata caj nac­ma̠­pa̠­ti̠niy puntzú y aca­li̠stá̠n chú nac­mak­xteka. ");
INSERT INTO tocNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero xlacán ni̠tlá̠n tat­lá­hualh y li̠huaca palha taqui­lhá­nilh xta­li̠s­qui­ni­má̠­nalh xla­cata pi̠ Jesús cape­kex­to­ko­hua­cá­calh nac cruz; y na̠chuná xta­qui­lha­ni­má̠­nalh xana­puxcun cura xa̠hua xma̠­kalh­ta­hua­ke̠­nacán judíos la̠qui̠ tla̠n cakan­táx­tulh hua̠ntu̠ xlacán xta­la­cas­quín. ");
INSERT INTO tocNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Huata Pilato tla̠n ca̠t­la­huá­nilh hua̠ntu̠ xlacán xtas­qui­ni­má̠­nalh; ");
INSERT INTO tocNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","y huata huá ca̠mak­xték­nilh a̠má chixcú hua̠nti̠ xta­nu̠ma nac pu̠la̠­chi̠n xuanicán Bar­rabás, caj kalha̠ná xuani̠t y xmak­ni̠­nani̠t, y huata ca̠ma­ca­má̠x­qui̠lh Jesús la̠qui̠ nata­li̠t­la­huay la̠ta túcua xta­la­ca­pa̠s­tacniy. ");
INSERT INTO tocNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Acxni̠ xta­le̠­má̠­nalh Jesús la̠qui̠ nata­pe­kex­to­ko­huacay, nac tiji tapá̠x­tokli cha̠tum chixcú xalac Cirene xuanicán Simón, xlá quí­lalh nac xca̠­tu­huá̠n y ajuerza tat­la­huá­nilh tropa tama̠­cú­qui̠lh xcruz Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Lhu̠hua cris­tianos xta­sta̠­la­má̠­nalh anta­nícu xamá̠­calh mak­ni̠cán Jesús, y lhu̠hua lac­chaján xta­ta­sa­má̠­nalh caj la̠ta xta­lak­li̠­pu­hua­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesús cacs ca̠lak­lá­ca̠lh y chiné ca̠huá­nilh: —Hui­xinín lac­chaján xalac Jeru­salén, ni̠ caqui­la̠­lak­ta­sáhu, huata mejor me̠c­stucán caca̠­lak­li̠­pu­huan­cántit chu min­ca­mancán caj xpa̠­la­cata hua̠ntu̠ amá̠n ca̠ok­spu­layá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Porque namín quilh­ta­macú acxni̠ nahuancán: “Li̠pa̠­xúhu cata­la­tá­ma̠lh hua̠nti̠ ni̠lay taka­lhi̠y xca­mancán, a̠ma̠ko̠lh lac­chaján hua̠nti̠ luu xka­satcán y ni̠lay tama̠­la­ka­tun­cu­hui̠nán, y na̠chuná a̠ma̠ko̠lh hua̠nti̠ ne̠cxni tama̠­tzi­quí̠­nalh.” ");
INSERT INTO tocNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Porque a̠má quilh­ta­macú lhu̠hua hua̠nti̠ nata­huán: “Huata xatlá̠n xquin­ca̠akta­lamín ke̠s­ti̠ní̠n osuchí caquin­ca̠akta­punú̠n talhpá̠n la̠qui̠ ni̠ naquin­ca̠­lak­cha̠ná̠n a̠má tapa̠tí̠n hua̠ntu̠ tala­ca­tzu­hui̠ma.” ");
INSERT INTO tocNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Pus luu caj caucxílhtit, aquit cli̠­taxtuy xas­taka quihui y caucxílhtit hua̠ntu̠ quin­tla­hua­ni­má̠­calh, ¿lácu pi̠ li̠huaca chú ni̠ chuná catit­la­hua­ní­calh hua̠ntu̠ luu xas­ca­huahua? ");
INSERT INTO tocNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Na̠ lac­xtum xca̠­ta̠­le̠­má̠­calh cha̠tiy mak­ni̠­naní̠n la̠qui̠ lac­xtum naca̠­ta̠­pe­kex­to­ko­hua­cacán Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Antá ca̠li̠­chá̠n­calh nac aktum ke̠stí̠n hua­nicán La Cala­vera, antá pekex­to­ko­hua­cá­calh Jesús xa̠hua a̠ma̠ko̠lh cha̠tiy lac­chix­cu­huí̠n, cha̠tum nac xpek­stácat y cha̠tum nac xpek­xuqui. ");
INSERT INTO tocNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Acxni̠ luu xpe­kex­to­ko­hua­ca­má̠­calh Jesús, xlá chiné huá: —Papá Dios, huix hua̠nti̠ hui­lapi nac akapú̠n, caca̠­ma̠­tzan­ke̠­nani hua̠ntu̠ quin­tat­la­hua­ni­má̠­nalh porque xlacán ni̠ taca­tzi̠y hua̠ntu̠ la̠nchú tama̠­kan­tax­ti̠­má̠­nalh. Ama̠­ko̠lh tropa tzú­culh tamacá̠n suerte la̠qui̠ xatícu luu nalak­chá̠n nalé̠n clháka̠t Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Lhu̠hua cris­tianos antá xtaucxilh­má̠­nalh, y hasta na̠chuná a̠ma̠ko̠lh xana­puxcun judíos xta­mini̠t tali̠­kalh­ka­ma̠nán y chiné xta­huán: —Luu lhu̠hua hua̠nti̠ ca̠mak­tá̠­yalh a̠maka­pi­tzí̠n cris­tianos y ca̠lak­ma̠x­tú­nilh xli̠s­tac­nicán, ¡pus huata chú sacstu calak­ma̠x­tú­calh y catá̠c­talh nac cruz para xli̠­ca̠na chú huá Cristo hua̠nti̠ lac­sacni̠t Dios! ");
INSERT INTO tocNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Na̠chuná tropa xta­li̠­kalh­ka­ma̠nán y xta­lak­ta­la­ca­tzu­hui̠y la̠qui̠ nata­li̠­kalh­toklha nata­ma̠­hui̠y xax­cuta vinagre. ");
INSERT INTO tocNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Y chiné xta­huaniy: —Para xli̠­ca̠na huix xreycán judíos pus chú la̠nchú me̠cstu calak­ma̠x­tú­canti. ");
INSERT INTO tocNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nac xacpú̠n cruz anta­nícu xuaca Jesús cxto­ko­hua­ca­cani̠t pi̠tzu̠ pák­lha̠t, antá xli̠­ta­tzokni̠t xata­chu­huí̠n hebreo, latín y griego, y chiné xuan: “Huá eé chixcú xreycán judíos.” ");
INSERT INTO tocNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Cha̠tum mak­ni̠ná hua̠nti̠ antá lac­xtum xca̠­ta̠­pe­kex­to­ko­hua­ca­cani̠t xla­ca­quilh­ni̠­hua­cama y chiné xuanima: —¡Para xli̠­ca̠na huix Cristo hua̠nti̠ namín quin­ca̠­lak­ma̠x­tuyá̠n pus chú me̠cstu calak­ma̠x­tú­canti y na̠ caqui­la̠­lak­ma̠x­túhu aquinín! ");
INSERT INTO tocNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero cha̠­tum­li̠túm tzú­culh ta̠la̠­la­ca­quilhni̠y xcom­pa­ñero y chuné huá­nilh: —Xli̠­ca̠na huix ni̠para tzinú laca­pu­hua­niya Dios, ¿lácu pi̠ ni̠ catzi̠ya pi̠ na̠chuná huix pa̠ti̠­námpa̠t? ");
INSERT INTO tocNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Aquinín ma̠squi chuná pa̠ti̠­na­ma̠­náhu luu laca­tancs pi̠ chuná quin­ca̠­mi­ni̠­niyá̠n, porque chuná li̠xo­ko̠­nu­ma̠­náhu hua̠ntu̠ tla­hua­ni̠­táhu, pero u̠má chixcú ni̠tu̠ tla­huama para túcu ni̠tlá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Xlá lak­lá­ca̠lh Jesús y chiné huá­nilh: —Quim­pu̠­chiná Jesús, xtlahua lanca li̠tlá̠n xqui­la­ca­pa̠s­tacpi acxni̠ huix natzu­cuya ma̠pek­si̠­nana nac akapú̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús kálh­ti̠lh: —Xli̠­ca̠na cuaniyá̠n pi̠ la̠nchú u̠má quilh­ta­macú lac­xtum quin­ta̠­hui­lapi nahuán nac a̠má ca̠li̠­la­káti̠t pu̠la­tama̠n anta­nícu huí Dios. ");
INSERT INTO tocNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ma̠x cumu aya tas­túnut xuani̠t acxni̠ xli̠­ca̠­lanca ca̠ti­yatni ca̠puc­suanan­ko̠lh y hasta ca̠mak­tutu hora a̠cú ca̠x­ka­kapá. ");
INSERT INTO tocNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Amá chi­chiní laka­ca̠­puc­suanan­ko̠lh y a̠má lanca lháka̠t hua̠ntu̠ xli̠­la­kat­la­pa̠­nancán nac pu̠si­culan pektiy huá la̠ta talác­xti̠tli sacstu. ");
INSERT INTO tocNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Y luu acxni̠ Jesús chiné tásalh: —¡Papá Dios, chú nac mimacán cmak­xteka qui­li̠s­tacni! Acxni̠ chuná huan­ko̠lh aya ni̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Amá capitán romano acxni̠ úcxilhli hua̠ntu̠ xqui̠­tax­tuni̠t xlá laca­pá̠s­tacli Dios y chiné huá: —Xli̠­ca̠na eé chixcú ni̠tu̠ xka­lhi̠y xcuenta. ");
INSERT INTO tocNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Xli̠­hua̠k cris­tianos hua̠nti̠ antá xta­la­yá̠­nalh y hua̠nti̠ taúcxilhli la̠ta túcua xkan­tax­tuni̠t, la̠li̠­huán táalh y caj la̠ta xta­li̠­pu­hua̠ncán xca̠­cux­mu̠­ka­xi­ti̠­lhacán. ");
INSERT INTO tocNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pero hua̠nti̠ xli̠­ta­la­ka­pasni Jesús, chu maka­pi­tzí̠n lac­chaján hua̠nti̠ lac­xtum xca̠­ta̠­mi­ni̠­tanchá nac Gali­lea, xlacán ni̠ táalh huata caj antá tzinú tlak laka­mákat xta­la­ca­yá̠­nalh y xtaucxilh­má̠­nalh hua̠ntu̠ xqui̠­tax­tuma. ");
INSERT INTO tocNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Antá xlama cha̠tum chixcú hua̠nti̠ na̠ xca̠­ta̠­ma̠­pek­si̠nán judíos nac Jeru­salén, xlá luu tla̠n xca­tzi̠y y luu aksti̠tum xlama nac xla­catí̠n Dios, xlá xuanicán José xalac Ari­matea, u̠má ca̠chi­quí̠n antá xta­peksi̠y nac Judea. ");
INSERT INTO tocNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Umá chixcú xlá ni̠tlá̠n tlá­hualh hua̠ntu̠ akspú­lalh Jesús porque xlá na̠ aya xkalh­ka­lhi̠ma acxni̠ lácu Dios nama̠­tzu­qui̠y xasa̠sti xta­péksi̠n nac ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Xlá la̠li̠­huán lákalh Pilato y squí­nilh li̠tlá̠n xla­cata cama­ca­má̠x­qui̠lh xti­yat­li̠hua Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pilato tla̠n tláhua hua̠ntu̠ huá­nilh y xlá alh anta­nícu cxto­ko­hua­ca­cani̠t y acxni̠ ma̠c­ti̠­ko̠lh nac cruz, li̠huana̠ pu̠mák­suitli sábana y le̠lh nac aktum tahuaxni anta­nícu ni̠ti̠ a̠ xma̠c­nu̠cán ni̠n; a̠má tahuaxni nac xlacán chí­huix xpaklh­cani̠t y antá má̠c­nu̠lh xti­yat­li̠hua Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Amá quilh­ta­macú acxni̠ chuná ti̠táx­tulh viernes xuani̠t ca̠ko̠­tanu̠n acxni̠ aya xlak­cha̠ma quilh­ta­macú la̠ta jaxcán. ");
INSERT INTO tocNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ama̠­ko̠lh lac­chaján hua̠nti̠ xta­ta̠­mi­ni̠­tanchá Jesús nac Gali­lea xlacán ta­sta̠­lá­nilh José y taúcxilhli anta­nícu ma̠c­nú̠­calh xti­yat­li̠hua Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Y acxni̠ taqui̠­tás­pitli, tachilh nac chiqui y antá talak­ca̠x­tlá­hualh xala­cuán per­fumes y li̠cha̠lí tájaxli porque luu chuná xuí li̠ma̠­peksí̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Laca­tzi̠sa domingo, maka­pi­tzí̠n lac­chaján la̠li̠­huán táalh nac tahuaxni anta­nícu xma̠c­nu̠­cani̠t Jesús y xta­le̠­má̠­nalh xala­cuán per­fumes hua̠ntu̠ xlacán xta­ta­ma̠­huani̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Acxni̠ antá tácha̠lh nac tahuaxni taúcxilhli pi̠ antaní xuili̠­cani̠t niaj antá xuí a̠má chí­huix hua̠ntu̠ xli̠­la­ka­ta­la­cani̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Xlacán la̠li̠­huán tatá­nu̠lh pero ni̠tu̠ taúcxilhli xti­yat­li̠hua Quim­pu̠­chi­nacán Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Xlacán xta­pe̠­cuaxni̠ni̠t, y hasta ni̠ xta­ca­tzi̠y túcu luu xlani̠t, acxni̠ ni̠para xali̠­ta­ca­tzí̠n lácu ca̠la­ka­ta̠­yachi cha̠tiy lac­chix­cu­huí̠n, pero luu lak­sna­papán y lak­sta­lankán clha­ka̠tcán hua̠ntu̠ xta­lha­ka̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Caj la̠ta xlacán xta­pe̠­cuacán tala­ka­ta­tzo­kós­talh hasta nac ca̠ti­yatni, pero a̠ma̠ko̠lh lac­chix­cu­huí̠n chiné ca̠huá­nilh: —¿Túcu xpa̠­la­cata li̠pu­tza­yá̠tit nac xpu̠­la­ta­ma̠ncán ni̠n hua̠nti̠ lama xas­tacná? ");
INSERT INTO tocNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Jesús uú xlá ni̠ti̠ acnu̠y porque lacas­ta­cuánalh nac ca̠li̠ní̠n. ¿Lácu pi̠ niaj pa̠s­ta­cá̠tit hua̠ntu̠ xlá tica̠­huanín acxni̠ lac­xtum xca̠­ta̠­lamá̠n nac Gali­lea? ");
INSERT INTO tocNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Xlá tica̠­huanín pi̠ cumu huá xlá Xata­lac­sacni Chixcú xamá̠­calh maca­ma̠s­ta̠cán nac xmacancán lac­li̠xcáj­nit lac­chix­cu­huí̠n. Xlacán xtaamá̠­nalh tape­kex­to­ko­huacay nac cruz, pero caj xliaktutu quilh­ta­macú xlá xámaj lacas­ta­cuanán nac ca̠li̠ní̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ama̠­ko̠lh lac­chaján acxnicú tala­ca­pá̠s­tacli xta­chu­huí̠n Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Acxni̠ xlacán taqui̠­tás­pitli nac tahuaxni tzú­culh tali̠­ta̠­chu­hui̠nán xka­lha­ca̠­hui­tucán após­toles chu xa̠maka­pi­tzí̠n xta­ma̠­kalh­ta­huaké̠n la̠ta túcu xta­qui̠ucxilhni̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ama̠­ko̠lh lac­chaján hua̠nti̠ táalh tama̠­ca­tzi̠ni̠y após­toles hua̠ntu̠ xlacán xta­qui̠ucxilhni̠t chiné xca̠­hua­nicán: María Mag­da­lena, Juana, María xtzí San­tiago, y a̠maka­pi­tzí̠n lac­chaján. ");
INSERT INTO tocNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero huata xapós­toles Jesús ni̠para tzinú taca̠­náj­lalh hua̠ntu̠ xlacán xta­qui­lhuamá̠­nalh porque xta­lac­pu­huán pi̠ ma̠x caj xta­kalh­chi­ya̠t­na­má̠­nalh caj la̠ta xta­pe̠­cuacán. ");
INSERT INTO tocNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Huata Pedro la̠li̠­huán táx­tulh y tokosú̠n alh anta­nícu xma̠c­nu̠­cani̠t Jesús; y acxni̠ tala­cá­nu̠lh nac tahuaxni ni̠tu̠ úcxilhli xmacni Jesús, caj xma̠nhuá xta­má̠­nalh sábanas hua̠ntu̠ xli̠­mak­suitcani̠t. Y huata luu cacs li̠la­cáhua tas­pitpá nac chiqui luu xla­ca­pa̠s­tac­ti̠­lhay hua̠ntu̠ xkan­tax­tuni̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Hua­tiyá a̠má quilh­ta­macú cha̠tiy hua̠nti̠ xta­li̠­pa̠­huán Jesús xtaamá̠­nalh nac aktum ca̠chi­quí̠n hua­nicán Emaús, juerza tzinú laka­mákat xuani̠t ma̠x cumu akca̠­huitu kiló­metro hasta la̠ta nac Jeru­salén. ");
INSERT INTO tocNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Xlacán huá xta­li̠­kalh­chu­hui̠­nan­ti̠­lhay la̠ta túcua xqui̠­tax­tu­nini̠t Jesús y la̠ta xmak­ni̠­cani̠t nac Jeru­salén. ");
INSERT INTO tocNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Cumu la̠ta xlacán luu xta­kalh­chu­hui̠­nan­ti̠­lhay ni̠para tzinú xali̠­ta­ca­tzí̠n lácu ca̠ma̠­tá̠x­tucli cha̠tum chixcú y lac­xtum tzú­culh ca̠ta̠t­la̠­huán, huá Jesús xas­tacná ca̠ta­si­yú­nilh. ");
INSERT INTO tocNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pero ma̠squi xtaucxilh­má̠­nalh, Dios ni̠ xca̠­ma̠x­qui̠y tala­cas­quín nataucxilha para huá. ");
INSERT INTO tocNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Pus Jesús chiné ca̠ka­lhás­quilh: —¿Túcu hui­xinín li̠chu­hui̠­nan­ti̠­lha­yá̠tit li̠huán tla̠­huam­pá̠tit nac tiji? ¿Túcu li̠li̠­pu­huam­pá̠tit? ");
INSERT INTO tocNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Cha̠tum hua̠nti̠ xuanicán Cleo­fas chiné kálh­ti̠lh: —Xli̠­hua̠k cris­tianos taca­tzi̠y hua̠ntu̠ lani̠t u̠má xama̠na nac Jeru­salén. ¿Lácu pi̠ ca̠ta caj me̠cstu chú antá tampi y ni̠ catzi̠ya hua̠ntu̠ antá li̠chu­hui̠­na­ma̠­kó̠­calh? ");
INSERT INTO tocNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesús ca̠huá­nilh: —Pero caqui­la̠­hua­níhu, ¿túcu chi̠nchú lani̠t? Xlacán chiné tahuá­nilh: —Hua̠ntu̠ akspú­lalh Jesús xalac Naza­ret. Aquinín xac­li̠­pu̠lh­ca̠­yá̠hu cumu la̠ xli̠­ca̠na lanca y tali̠­pa̠hu xak­chu­hui̠ná Dios caj xpa̠­la­cata pi̠ luu laca­tancs xchu­hui̠nán y na̠ xka­lhi̠y li̠t­li­hueke y tla̠n xca̠t­la­huay lac­lanca li̠cá̠cni̠t ta­scújut nac xla­ca­ti̠ncán cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pero xana­puxcun cura chu qui­ma̠­pek­si̠­nacán tama̠­la­cá­pu̠lh la̠qui̠ nama̠­pa̠­ti̠­ni̠cán y chuná namak­ni̠cán, y hasta tu̠xa­matá viernes la̠ta pekex­to­ko­hua­cá­calh nac cruz. ");
INSERT INTO tocNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Aquinín luu xac­li̠­pa̠­hua­ná̠hu porque xac­lac­pu­hua­ná̠hu pi̠ huá Cristo hua̠nti̠ naquin­ca̠­lak­ma̠x­tuyá̠n xli̠­hua̠k aquinín judíos hua̠nti̠ cla­ma̠­náhu nac xapu̠­la­tama̠n Israel; pero chú aya lac­la­ko̠lh hua̠ntu̠ xacuc­xilh­la­ca­cha̠­ni̠­táhu porque aya le̠ma xliaktiy chi­chiní la̠ta timak­ní̠­calh. ");
INSERT INTO tocNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pero hua­tiyá eé quilh­ta­macú acxni̠ spalh ca̠x­ka­ka­ko̠lh maka­pi­tzí̠n lac­chaján la̠n quin­ca̠­ma­ke̠k­lhán porque xlacán taquí̠­lalh anta­nícu xma̠c­nu̠­cani̠t Jesús, ");
INSERT INTO tocNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","y acxni̠ taqui̠­tás­pitli quin­ca̠­huanín pi̠ mat ni̠tu̠ xta­nu̠ma xti­yat­li̠hua Jesús, y xa̠huachí mat cha̠tiy ángeles xca̠­ta­si­yu­nini̠t y chiné ca̠huá­nilh pi̠ mat xlama xas­tacná Jesús. ");
INSERT INTO tocNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Y caj li̠puntzú na̠ taquí̠­lalh maka­pi­tzí̠n lac­chix­cu­huí̠n hua̠nti̠ na̠ quin­com­pa­ñe­roscán hasta nac tahuaxni, pero xli̠­ca̠na chuná tama̠­nók­lhulh cumu la̠ xta­huani̠t a̠ma̠ko̠lh lac­chaján, pero huá chú Jesús ni̠ti̠ taúcxilhli. ");
INSERT INTO tocNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Y Jesús chiné ca̠huá­nilh a̠ma̠ko̠lh xta­ma̠­kalh­ta­huaké̠n: —¡Koxu­taní̠n hui­xinín cris­tianos, luu xli̠­ca̠na lhu̠hua ca̠tzan­ka̠­niyá̠n tala­ca­pa̠s­tacni, xli̠­ca̠na pi̠ ni̠lay ca̠naj­la­yá̠tit hua̠ntu̠ tita­li̠­chu­huí̠­nalh xalak­maká̠n pro­fetas hua̠ntu̠ xámaj okspulay tamá chixcú! ");
INSERT INTO tocNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Lácu pi̠ ni̠ catzi̠­yá̠tit xla­cata pi̠ juerza chuná xlak­chá̠n a̠má Cristo hua̠nti̠ namíná̠n ca̠lak­ma̠x­tuyá̠n? Porque chuná xlac­lhca̠­hui­li̠­cani̠t pi̠ xlá pu̠lh napa̠ti̠y hua̠ntu̠ aya pá̠ti̠lh chú, la̠qui̠ chuná tla̠n nama­ca­ma̠x­qui̠cán a̠má lanca pu̠tá­hui̠lh nac akapú̠n hua̠ntu̠ naka­lhi̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Y tzú­culh ca̠ma̠­lac­ti̠­tu­mi̠niy hua̠ntu̠ huan nac li̠kalh­ta­huaka anta­nícu li̠chu­hui̠nán xla­táma̠t Cristo, ca̠ma̠­tzu­quí̠­nilh nac xlibro Moisés y ca̠li̠­ma̠s­pu­tú­nilh hua̠ntu̠ tahuán nac xlib­rojcán pro­fetas. ");
INSERT INTO tocNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Acxni̠ tácha̠lh nac Emaús, Jesús luutá ca̠t­la­huá­nilh cumu lá̠m­para ti̠tum xama. ");
INSERT INTO tocNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero xlacán juerza taliakax­cú­lilh xla­cata caca̠­ta̠­ta­mák­xtekli y chiné tahuá­nilh: —Cat­lahua li̠tlá̠n, caqui­la̠­ta̠­ta­mak­xtekui uú nac ca̠chi­quí̠n, porque la̠nchú aya ko̠ta­nu̠ko̠y a̠huayu aya tzi̠­suán. Pus xlá ca̠ta̠­tá­nu̠lh nac chiqui anta­nícu xtaamá̠­nalh talak­tun­cu­huiy. ");
INSERT INTO tocNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Y acxni̠ aya xta­hui­lá̠­nalh nac mesa la̠qui̠ nata­hua̠yá̠n, Jesús tíyalh mactum cax­ti­lá̠n­chahu, pa̠x­cat­ca­tzí̠­nilh Dios, lak­ché­kelh y ca̠má̠x­qui̠lh. ");
INSERT INTO tocNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Luu acxni­tiyá xla­kas­ta­pucán li̠huana̠ tili̠­la­ca­huá̠­nalh y tala­ká­pasli pi̠ huá Jesús; pero acxni­tiyá xlá lák­scupli y niaj tasí­yulh. ");
INSERT INTO tocNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Sac­stucán chiné tzú­culh tala̠­huaniy cha̠tum a̠cha̠tum: —Luu xli̠­ca̠na pi̠ nac qui­na­cujcán hasta scayaj xca­tzán acxni̠ xlá xquin­ca̠­ma̠­la­ca­pu̠­tun­cu­hui­nimá̠n hua̠ntu̠ tatzok­ta­hui­lani̠t xta­chu­huí̠n Dios nac li̠kalh­ta­huaka. ");
INSERT INTO tocNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Huata xlacán ni̠tu̠cu tama­ka­ká­lhi̠lh la̠li̠­huán tatá­ca̠xli y taampá nac Jeru­salén y antá talák­cha̠lh xaka­lha­ca̠­huitu após­toles chu maka­pi­tzí̠n xcom­pa­ñe­roscán. ");
INSERT INTO tocNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Huata xlacán chiné tahuá­nilh: —Xli̠­ca̠na pi̠ lacas­ta­cuanani̠t nac ca̠li̠ní̠n Quim­pu̠­chi­nacán porque mismo Simón Pedro ucxilhni̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Y a̠ma̠ko̠lh hua̠nti̠ a̠cú tácha̠lh nac Jeru­salén na̠ tzú­culh tahuán lácu tata̠­tá­nok­lhli nac tiji cha̠tum chixcú, y na̠ táhua lácu tala­ká­pasli Jesús acxni̠ xlá lak­ché­kelh cax­ti­lá̠n­chahu. ");
INSERT INTO tocNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Xlacán chu­nacú xta­chu­hui̠­na­má̠­nalh acxni̠ Jesús íta̠t ca̠la­ka­ta̠­yachá y chiné ca̠xa­kát­li̠lh: —Caka­lhí̠tit hui­xinín tapa̠­xu­huá̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Cumu xlacán xta­pe̠­cuaxni̠­má̠­nalh xta­lac­pu­huán pi̠ ma̠x caj xca̠­ma̠­la­ca­hua̠­ni̠ma xes­pí­ritu ni̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pero Jesús chiné ca̠huá­nilh: —¿Túcu xpa̠­la­cata hui­xinín li̠pe̠­cuaná̠tit? ¿Túcu xpa̠­la­cata ni̠lay li̠ca̠­naj­la­yá̠tit nac mina­cujcán pi̠ aquit clama xas­tacná? ");
INSERT INTO tocNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Xa̠huachí, eé caucxílhtit qui­macán chu quin­tantú̠n y caca­tzí̠tit pi̠ xli̠­ca̠na aquit. Ma̠squi luu caqui­la̠­xa­máhu y caqui­la̠ucxi­lhui porque cha̠tum ni̠n ni̠tu̠ kalhi̠y xli̠hua ni̠para xlúcut cumu la̠ aquit cka­lhi̠y. ");
INSERT INTO tocNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Acxni̠ chuná ca̠hua­ni­ko̠lh ca̠ma̠­si­yú­nilh xmacán chu xtantú̠n la̠qui̠ nata­ca̠­najlay pi̠ xli̠­ca̠na xas­tacná. ");
INSERT INTO tocNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pero caj la̠ta xlacán xta­pa̠­xu­hua­má̠­nalh ni̠lay xta­ca̠­najlay hua̠ntu̠ xtaucxilh­má̠­nalh. Jesús ca̠ka­lhás­quilh: —¿Ni̠túcu kalhi̠­yá̠tit para túcu actzu̠ min­ta­huajcán? ");
INSERT INTO tocNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Y cha̠tum má̠x­qui̠lh actzu̠ xatax­pupu squi̠ti chu xchú­chut cera. ");
INSERT INTO tocNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Xlá mak­lhtí̠­nalh y antá nac xla­ca­ti̠ncán hualh. ");
INSERT INTO tocNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Aca­li̠stá̠n chiné ca̠huá­nilh: —Eé hua̠ntu̠ aquit quiak­spu­lani̠t pus hasta hua­tiyá a̠má hua̠ntu̠ cti­ca̠­huanín acxni̠ lac­xtum xac­ca̠­ta̠­la­pu̠­layá̠n, xla­cata pi̠ juerza xli̠­kan­táxtut xuani̠t hua̠ntu̠ tatzok­ta­hui­lani̠t caj quim­pa̠­la­cata nac xlibro Moisés, chu nac xlib­rojcán pro­fetas xa̠hua nac salmos. ");
INSERT INTO tocNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Y chuná hua̠k ca̠ma̠aka­tá̠k­sni̠lh hua̠ntu̠ xta­tzok­ta­hui­lani̠t nac li̠kalh­ta­huaka xpa̠­la­cata. ");
INSERT INTO tocNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Aca­li̠stá̠n chiné ca̠huá­nilh: —Pus chuná tatzok­ta­hui­lani̠t nac li̠kalh­ta­huaka xla­cata pi̠ aquit Cristo juerza qui­lí̠ni̠t xuani̠t, pero caj xliaktutu quilh­ta­macú xacámaj lacas­ta­cuanán nac ca̠li̠ní̠n, ");
INSERT INTO tocNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","y na̠chuná tatzokni̠t pi̠ amá̠­calh ma̠la­ka­pun­tu­mi̠cán quin­ta­chu­huí̠n nac xli̠­ca̠­lanca ca̠quilh­ta­macú, nama̠­tzu­qui̠cán nac Jeru­salén; naliakchu­hui̠­nancán pi̠ xla­ca­squinca hua̠k xcris­tianos nata­lak­pali̠y xali̠xcáj­nit xta­la­ca­pa̠s­tac­nicán la̠qui̠ chuná tla̠n naca̠­ma̠­tzan­ke̠­na­nicán xta­la̠­ka­lhi̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Hui­xinín tes­tigos y nama̠­lu­lo­ká̠tit pi̠ xli̠­ca̠na chuná qui̠­tax­tuni̠t. ");
INSERT INTO tocNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Xa̠huachí aquit nac­ma­camín nac mila­ta­ma̠tcán hua̠ntu̠ Quin­tla̠t ma̠lac­nu̠ni̠t; pero ni̠tu̠ napi­ná̠tit a̠laca­tunu ca̠chi­quí̠n, antá uú nac Jeru­salén nata­mak­xte­ká̠tit hasta caní namak­lhti̠­na­ná̠tit a̠má lanca li̠t­li­hueke hua̠ntu̠ nami­na̠chá nac akapú̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Acxni̠ chuná ca̠hua­ni­ko̠lh, Jesús cá̠le̠lh nac Betania, y acxni̠ antá tácha̠lh xlá cá̠chexli xmacán la̠qui̠ naca̠­si­cu­la­na̠t­la­huay. ");
INSERT INTO tocNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Y acxni̠ ca̠si­cu­la­na̠t­la­hua­ko̠lh tzú­culh tata̠lh­ma̠ni̠y y lé̠n­calh nac akapú̠n. ");
INSERT INTO tocNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Aca­li̠stá̠n acxni̠ xlacán taca̠c­ni̠­na­ni­ko̠lh tatás­pitli nac Jeru­salén pero luu xta­pa̠­xu­hua­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Anka­lhí̠n xtaán nac lanca pu̠si­culan la̠qui̠ antá nata­tas­toka y lac­xtum nata­kalh­ta­hua­kaniy Dios.");
INSERT INTO tocNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Acxni̠ ni̠najtu̠ xanán a̠má hua̠nti̠ hua­nicán Tachu­huí̠n na̠ xla­majá, pus a̠má Tachu­huí̠n na̠ lac­xtum xta̠­lama Quin­tla̠­ticán Dios porque xlá na̠ Dios. ");
INSERT INTO tocNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Pus acxnicú hua̠k pu̠tum quilh­tzú­culh xlá antiyá lac­xtum xta̠­lama Dios. ");
INSERT INTO tocNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Xlá hua̠k mak­tla­huani̠t la̠ta túcu anán, y ni̠tu̠ anán para xlá ni̠ mak­tla­huani̠t hua̠ntu̠ ma̠la­ca­tzu­qui̠ni̠t Dios. ");
INSERT INTO tocNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Huá tamá Tachu­huí̠n caj huá xpa̠­la­cata ma̠squi taká­lhi̠lh latáma̠t la̠ta túcu xanán, y hua­tiyá tamá tí má̠s­ta̠lh aktum li̠s­tacni li̠táx­tulh tax­káket hua̠nti̠ naca̠­mak­skoniy cris­tianos la̠qui̠ tlán nata­la­ka­pasa Dios. ");
INSERT INTO tocNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Xlá milh ca̠ta̠­la­tama̠y cris­tianos hua̠nti̠ xta­la­má̠­nalh nac xaca̠­pucsua la̠qui̠ naca̠­mak­skoniy xtax­káket, huata xlacán tatzák­salh xta­ma̠­mi­xi­putún, pero ni̠lay tama̠­mí­xilh. ");
INSERT INTO tocNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Dios macá­milh cha̠tum chixcú xuanicán Juan hua̠nti̠ milh li̠chu­hui̠nán a̠má tax­káket la̠qui̠ xli̠­hua̠k cris­tianos nata­ca̠­naj­laniy hua̠ntu̠ naca̠­huaniy, y lhu̠hua hua̠nti̠ ca̠ma̠­tan­csá­nilh xla­ta­ma̠tcán. ");
INSERT INTO tocNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan ni̠ huá xka­lhi̠y tax­káket, pus xlá caj xma̠­la­ka­cha̠­cani̠t la̠qui̠ nali̠­chu­hui̠nán a̠má tax­káket hua̠nti̠ xámaj min la̠qui̠ hua̠k nala­ka­pas­ko̠cán. ");
INSERT INTO tocNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Huá tamá Tachu­huí̠n hua̠nti̠ xma­ca­mini̠t nac u̠má ca̠quilh­ta­macú, xli̠­ca̠na xka­lhi̠y tax­káket porque huá ca̠mak­skó­nilh xli̠­hua̠k cris­tianos la̠qui̠ tla̠n nata­la­ka­pasa Dios. ");
INSERT INTO tocNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Pus a̠má Tachu­huí̠n milh nac ca̠quilh­ta­macú la̠qui̠ nala­tama̠y nac ca̠quilh­ta­macú hua̠ntu̠ lac­xtum xta̠­ma̠­la­ca­tzu­qui̠ni̠t Dios; pero hua̠nti̠ xta­la­má̠­nalh nac ca̠quilh­ta­macú a̠ma̠ko̠lh cris­tianos ni̠ tala­ká­pasli. ");
INSERT INTO tocNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Y a̠má pu̠la­tama̠n hua̠ntu̠ xlac­sacni̠t la̠qui̠ antá nala­ca­chín, hua̠nti̠ antá xta­hui­lá̠­nalh hua̠nti̠ xna­ta̠­chi­quí̠n ni̠ tali̠­pá̠­hualh xta­chu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero maka­pi­tzí̠n cris­tianos hua̠nti̠ tali̠­pá̠­hualh xta­chu­huí̠n y ca̠qui̠­tax­tú­nilh cumu lá̠m­para tala­ca­chimpá a̠maktum y xca­maná̠n Dios ca̠li̠­má̠x­tulh. ");
INSERT INTO tocNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Huá u̠ma̠ko̠lh hua̠nti̠ tala­cá­chilh xli̠­maktiy la̠qui̠ xca­maná̠n Dios nata­huán, huá chuná tali̠­la­cá­chilh xli̠­maktiy porque huá Dios ca̠ma̠x­qui̠lh aktum xasa̠sti xla­ta­ma̠tcán hua̠ntu̠ chú taka­lhi̠y pero ni̠ xta̠­chuná qui̠­táx­tulh cumu la̠ acxni̠ xtzí chu xtla̠tcán ca̠má̠x­qui̠lh xla­ta­ma̠tcán hua̠ntu̠ xala u̠má ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Amá Tachu­huí̠n milh laca­chín cumu la̠ cha̠tum skata y nac qui­lak­sti̠­pa̠ncán qui̠­la­ta­ma̠chi cumu la̠ cati̠hua̠ chixcú, xlá qui̠­li̠­chu­hui̠­nánchi xta­la­ka­lha­maní̠n Dios y hua̠ntu̠ xlá xta­la­ca­pa̠s­tacni. Aquinín cuc­xilh­ni̠­táhu pi̠ lanca xla­ca­tzúcut y cca­tzi̠­yá̠hu pi̠ huá Dios ma̠x­qui̠ni̠t xli̠­maka­tli­hueke porque xma̠nhuá ta̠stum Xka­huasa. ");
INSERT INTO tocNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan li̠chu­huí̠­nalh nac xla­ca­ti̠ncán cris­tianos y chiné huá: —Huá eé chixcú hua̠nti̠ xac­li̠­chu­hui̠­nama acxni̠ chiné cuá: Aca­li̠stá̠n mima a̠cha̠tum ti̠ a̠tzinú lanca xla­ca­tzúcut ni̠ xachuná aquit, porque xlá aya xlama hasta acxni̠ aquit ni̠najtí xac­lama. ");
INSERT INTO tocNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Caj hua̠ntu̠ qui­la­ca­tacán pu̠tum quin­ca̠­ma̠x­qui̠­ni̠tán xta­pa̠x­quí̠n y ni̠ caj maktum porque caj xpa̠­la­cata lanca xta­la­ka­lha­maní̠n quin­ca̠­si­cu­la­na̠t­la­hua­ni̠tán cane̠c­xni­cahuá. ");
INSERT INTO tocNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Pro­feta Moisés quin­ca̠­ma̠x­quí̠n a̠má li̠pe̠­cuánit xta­péksi̠t Dios la̠qui̠ aquinín li̠huana̠ nama̠­kan­tax­ti̠­yá̠hu, pero tla̠n xta­la­ca­pa̠s­tacni xa̠hua xta­la­ka­lha­maní̠n Dios huá kalhi̠­yá̠hu porque Jesu­cristo quin­ca̠­ma̠­si­yu­ni­ni̠tán. ");
INSERT INTO tocNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ni̠para cha̠tum cris­tiano a̠ ucxilha Dios, pero hui̠ntí quin­ca̠­ma̠­la­ka­pas­ni̠­ni̠tán huá tamá cha̠stum Xka­huasa porque xlá na̠ Dios y luu lac­xtum xlá ta̠ma̠­la­cas­tucni̠t xta­la­ca­pa̠s­tacni Quin­tla̠­ticán. ");
INSERT INTO tocNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ama̠­ko̠lh xana­púxcun judíos xalac Jeru­salén tama̠­la­ká­cha̠lh maka­pi­tzí̠n cura xa̠hua hua̠nti̠ ca̠hua­nicán levitas xla­cata nata­ka­lhas­quín Juan túcu xlá xli̠­taxtuy. ");
INSERT INTO tocNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Xlá ni̠tu̠ ma̠lák­tze̠kli huata luu laca­tancs ca̠huá­nilh: —Aquit ni̠ huá Cristo hua̠nti̠ hui­xinín kalhi̠­pá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Xlacán taka­lhas­quimpá: —Entonces, ¿tícu chi̠nchú huix? ¿Pi̠ huix a̠má pro­feta Elías hua̠nti̠ namim­paray? Juan chiné ca̠huá­nilh: —Pus aquit ni̠ Elías. Xlacán taka­lhas­quimpá: —Entonces, ¿pi̠ huix a̠má pro­feta hua̠nti̠ xli̠­mínit xuani̠t? Juan ca̠kálh­ti̠lh: —Ni̠ aquit. ");
INSERT INTO tocNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Chiné tahua­nipá: —¿Tícu chi̠nchú huix? Pus hua̠nti̠ quin­ca̠­ma̠­la­ka­cha̠­ni̠tán nata­ca­tzi̠­putún tícu huix. ¿Túcu naqui­la̠­hua­ni­yá̠hu caj la̠ta tu̠ mila­cata? ");
INSERT INTO tocNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan ca̠kálh­ti̠lh: —Aquit a̠má hua̠nti̠ tili̠­chu­huí̠­nalh pro­feta Isaías acxni̠ chiné huá: “Nata­kax­mata nac desierto la̠ naakchu­hui̠nán cha̠tum chixcú y chiné nahuán: Caca̠x­tla­hua­nítit kantum tiji hua̠ntu̠ luu statua antaní nalac­tla̠­huán Quim­pu̠­chi­nacán.” ");
INSERT INTO tocNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ama̠­ko̠lh lac­chix­cu­huí̠n hua̠nti̠ xta­ma̠­la­ka­cha̠ni̠t fariseos, acxni̠ takax­mat­ko̠lh xta­chu­huí̠n Juan, ");
INSERT INTO tocNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","taka­lhas­quimpá: —Para ni̠ huix Cristo, ni̠para Elías y ni̠para a̠má pro­feta hua̠nti̠ namín, ¿lácu chi̠nchú ca̠liakmu­núpa̠t cris­tianos? ");
INSERT INTO tocNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan chiné ca̠huá­nilh: —Aquit caj chú­chut cliakmu­nu̠nún, pero uú nac mim­pu̠­la­ta­ma̠ncán ca̠ta̠­lamá̠n cha̠tum chixcú hua̠nti̠ ni̠ laka­pa­sá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Xlá a̠cú nama̠­tzu­qui̠y xta­scújut y tlak a̠tzinú lanca xla­ca­tzúcut ni̠ xachuná aquit; pus aquit ni̠ qui­mi­ni̠niy nac­li̠­taxtuy xta­sa̠cua nacuán hua̠nti̠ nax­cutniy xacorrea xta­tu̠nú̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Pu̠tum eé qui̠­táx­tulh nac aktum pu̠la­tama̠n hua­nicán Betá­bara, a̠li̠quilh­tu̠án kalh­tu̠­choko Jordán anta­nícu xca̠akmu­numa cris­tianos Juan. ");
INSERT INTO tocNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Li̠cha̠lí a̠má quilh­ta­macú Juan úcxilhli Jesús pi̠ xta­la­ca­tzu­hui̠ma, chiné huá: —Caucxílhtit, huá eé chixcú li̠taxtuy cumu la̠ xbor­rego Dios hua̠nti̠ naxo­ko̠nún nac xla­catí̠n y chuná naca̠­li̠­lac­xa­caniy cris­tianos xala ca̠quilh­ta­macú xli̠­hua̠k xta­la̠­ka­lhi̠ncán hua̠ntu̠ tatit­la­huani̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Huá tamá chixcú hua̠nti̠ aquit xac­li̠­chu­hui̠­nama acxni̠ chiné cuá: “Aca­li̠stá̠n mima a̠chatum hua̠nti̠ tlak kalhi̠y lanca xla­ca­tzúcut ni̠ xachuná aquit, porque xlá aya xlama acxni̠ aquit ni̠najti̠ xac­lama.” ");
INSERT INTO tocNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Na̠ ni̠para aquit xac­ca­tzi̠y túcu a̠má hua̠nti̠ namín, ma̠squi aquit qui­ma­ca­mínca xla­cata nac­liakmu­nu̠nún chú­chut la̠qui̠ a̠ma̠ko̠lh cris­tianos xalac Israel nata­la­ka­pasa acxni̠ nalak­chá̠n quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Y Juan chiné huampá: —Pero la̠nchú tla̠n nac­ca̠­hua­niyá̠n pi̠ aquit cuc­xilhni̠t Espíri­tu Santo la̠ xta̠c­ta­ma̠chi nac akapú̠n cumu la̠ actzu̠ paloma y antá tahui­lachi nac xok­spú̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Aquit na̠ ni̠naj xac­ca­tzi̠y tícu xlá, pero hua̠nti̠ qui­ma­cá­milh la̠qui̠ nac­liakmu­nu̠nún chú­chut chiné qui­huá­nilh: “Acxni̠ naucxilha Espíri­tu Santo ta̠c­ta­ma̠chi nac xok­spú̠n cha̠tum chixcú y antá nata­mak­xteka, pus huá tamá ti̠ naliakmu­nu̠nún Espíri­tu Santo.” ");
INSERT INTO tocNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Pus aquit aya cuc­xilhni̠t y cma̠­lu­loka pi̠ xli̠­ca̠na huá Xka­huasa Dios. ");
INSERT INTO tocNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Li̠cha̠­li­li̠túm Juan xca̠­ta̠­láya cha̠tiy xta­ma̠­kalh­ta­huaké̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Antá lacatzú ti̠táx­tulh Jesús, Juan cacs lak­lá­ca̠lh y chiné ca̠huá­nilh: —Caucxílhtit, huá a̠má chixcú li̠taxtuy cumu la̠ xbor­rego Dios hua̠nti̠ naxo­ko̠nún xpa̠­la­cata tala̠­ka­lhí̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Amá cha̠tiy xta­ma̠­kalh­ta­huaké̠n Juan acxni̠ takáx­matli hua̠ntu̠ xlá huá pus la̠li̠­huán ta­sta̠­lá­nilh. ");
INSERT INTO tocNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Y acxni̠ Jesús tala­kás­pitli úcxilhli pi̠ csta̠­la­ni­má̠­calh, chiné ca̠huá­nilh: —¿Túcu putza­pá̠tit? Xlacán takalh­tí̠­nalh: —Ma̠kalh­ta­hua­ke̠ná, ¿nícu hui­lapi? ");
INSERT INTO tocNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesús ca̠kálh­ti̠lh: —Catátit, caáhu la̠qui̠ nala­ka­pas­na­ná̠tit. Xlacán tatá̠alh Jesús y cumu ko̠ta­nu̠yá xuani̠t acxni̠ tácha̠lh ma̠x cumu aya ca̠mak­ta̠ti hora, a̠ma̠ko̠lh lac­chix­cu­huí̠n antá tata­mak­xtekchá. ");
INSERT INTO tocNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ama̠­ko̠lh lac­chix­cu­huí̠n hua̠nti̠ takax­mát­nilh xta­chu­huí̠n Juan y hua̠nti̠ ta­sta̠­lá­nilh Jesús, cha̠tum xuanicán Andrés xta̠lá Simón Pedro. ");
INSERT INTO tocNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Huata Andrés pu̠lh alh putzay xta̠Simón y chiné huá­nilh: —Cmac­la­ni̠­táhu Mesías —u̠má tachu­huí̠n huam­putún Cristo o ma̠lak­tax­ti̠ná. ");
INSERT INTO tocNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andrés la̠li̠­huán le̠lh Simón antaní xuilachá Jesús y acxni̠ Jesús úcxilhli, chiné huá­nilh: —Huix hua­ni­cana Simón xka­huasa Juan, pero aquit nac­li̠­ma̠­pa̠­cu­hui̠yá̠n Cefas —u̠má tachu­huí̠n huam­putún Pedro o chí­huix. ");
INSERT INTO tocNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Li̠cha̠lí Jesús alh nac xapu̠­la­tama̠n Gali­lea y antá ta̠ta­nok­lhchá Felipe, y chiné huá­nilh: —Caquis­ta̠­lani. ");
INSERT INTO tocNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Amá Felipe xalac Bet­saida xuani̠t antá na̠ ní xta­hui­la̠­nanchá Andrés y Pedro. ");
INSERT INTO tocNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe la̠li̠­huán alh putzay Nata­nael y chiné huá­nilh: —Cuc­xilh­ni̠­táhu a̠má chixcú hua̠nti̠ tita­li̠­chu­huí̠­nalh xalak­maká̠n pro­fetas xa̠hua Moisés, xlá hua­nicán Jesús xka­huasa José xalac Naza­ret. ");
INSERT INTO tocNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nata­nael kalh­tí̠­nalh: —Ni̠para tzinú cca̠­najlay. ¿Lácu pi̠ tla̠n natax­tu­ya̠chá cha̠tum tali̠­pa̠hu chixcú nac Naza­ret? Pero Felipe chiné hua­nipá: —Pus catat ucxilha la̠qui̠ naca̠­naj­laya. ");
INSERT INTO tocNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Acxni̠ úcxilhli Jesús pi̠ xlak­ta­la­ca­tzu­hui̠ma Nata­nael, chiné huá: —Anú min cha̠tum chixcú hua̠nti̠ xli̠­cána luu mini̠niy li̠ta­pa̠­cu­hui̠y israel­ita porque ni̠para caj chu­natá li̠ma̠­si­yuma. ");
INSERT INTO tocNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Entonces Nata­nael kalhás­quilh: —¿Lácu qui­li̠­la­ka­pasa? Jesús huá­nilh: —Aquit pu̠lh cuc­xilhni acxni̠ xyá̠t nac xtampí̠n xaquihui higo, acxni̠ nia̠ xta­sa­niyá̠n Felipe. ");
INSERT INTO tocNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Entonces Nata­nael huá­nilh: —Ma̠kalh­ta­hua­ke̠ná, ¡xli̠­ca̠na huix Xka­huasa Dios, huix a̠má rey hua̠nti̠ xli̠­mínit xuani̠t la̠qui̠ naca̠­ma̠­peksi̠y hua̠nti̠ xalac Israel! ");
INSERT INTO tocNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús kálh­ti̠lh: —Huix quin­ca̠­naj­la­niya caj xla­cata cumu cuanín pi̠ pu̠lh aquit cuc­xilhni acxni̠ xyá̠t nac xtampí̠n xaquihui higo. Pus namín quilh­ta­macú acxni̠ naucxilha huix a̠tzinú lac­lanca ta­scújut hua̠ntu̠ nac­tla­huay ni̠ xachuná hua̠ntu̠ káx­patti la̠nchú. ");
INSERT INTO tocNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesús chiné huampá: —Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ nalak­chá̠n quilh­ta­macú acxni̠ hui­xinín naucxi­lhá̠tit pi̠ laqui̠ nahuán akapú̠n y xán­geles Dios tata̠c­ta­ma̠­nanchi y tata­hua­ca­ma̠­nampá nahuán xla­cata naquin­ta­la­ka­chix­cu­hui̠y aquit Xata­lac­sacni Chixcú. ");
INSERT INTO tocNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Li̠tu̠­xama nac ca̠chi­quí̠n hua­nicán Caná xmu­ni­cipio Gali­lea tla­huá­calh aktum pu̠ta­maka­xtokni. Xtzí Jesús na̠ xani̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Nac pu̠ta­maka­xtokni na̠ xca̠­pu­tza­cani̠t Jesús xa̠hua xta­ma̠­kalh­ta­huaké̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Acxni̠ tama­kás­putli xvi­nujcán hua̠ntu̠ xta­li̠­kot­nu­má̠­nalh, xtzí Jesús chiné huá­nilh: —Niajtu̠ xvi­nujcán hua̠ntu̠ nata­huay. ");
INSERT INTO tocNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesús chiné kálh­ti̠lh: —Mamá, ¿túcu xla­cata aquit qui­li̠­hua­niya? Pus aquit ni̠lay túcu nac­tla­huay xla­ca­tacán porque nia̠ lak­chá̠n quilh­ta­macú la̠ta nac­tzucuy scuja. ");
INSERT INTO tocNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Pero xtzí Jesús chiné ca̠huá­nilh hua̠nti̠ xta­maca­scuj­má̠­nalh: —Para la̠ta túcu xlá naca̠­li̠­ma̠s­cu­juyá̠n, hua̠k caka­lha­kax­páttit. ");
INSERT INTO tocNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Antá lacatzú xta­hui­lá̠­nalh pa̠cha̠xán caj la̠ tlá­manclh xla chí­huix hua̠ntu̠ xta­mac­la­cas­quín judíos acxni̠ xta­la­ka­chix­cu­hui̠nán; a̠má tlá­manclh xtaju̠y ma̠x cumu ochenta osuchí cien litros chú­chut pa̠tunu. ");
INSERT INTO tocNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús chiné ca̠huá­nilh macas­cujni: —Caca̠­li̠­ma̠s­ta­pátit chú­chut tama̠­ko̠lh tlá­manclh. Y xlacán tali̠­ma̠s­tá­palh. ");
INSERT INTO tocNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jesús ca̠hua­nipá: —Chú cama̠­cu­tútit actzú y cali̠­pi­ni­pítit hua̠nti̠ ma̠pux­qui̠­cani̠t nac eé pu̠pa̠xcua. Xlacán chuná tat­lá­hualh, ");
INSERT INTO tocNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","y acxni̠ kalhuá̠nalh a̠má chú­chut la̠ xatlá̠n vino xuani̠t, ni̠ xca­tzi̠y nícu xli̠­min­ca­ni̠­tanchá caj xma̠nhuá macas­cujní̠n xta­ca­tzi̠y, porque huá xlacán xta­ma̠­cu­tuni̠t a̠má chú­chut. Y a̠má chixcú hua̠nti̠ xapuxcu tasa̠cua tasá­nilh hua̠nti̠ xta­maka­xtokma, ");
INSERT INTO tocNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","y chiné huá­nilh: —Cani̠huá anta­nícu pa̠x­cuajnancán pu̠lh huá xatlá̠n vino ta̠hua­ni̠­nancán, y acxni̠ taputza lhu̠­huatá tahuani̠t, entonces a̠huatá ta̠hua­ni̠­nancán a̠má vino hua̠ntu̠ ni̠ luu xatlá̠n. Pero chi̠nchú huix a̠huatá ca̠ma̠x­quí̠pa̠t a̠má vino hua̠ntu̠ tlak xatlá̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Huá eé chú­chut hua̠ntu̠ lak­pá­li̠lh Jesús nac Caná cxmu­ni­cipio Gali­lea, hua̠ntu̠ luu pu̠lh tlá­hualh lanca xta­scújut, y huá u̠má tzú­culh li̠ma̠­siyuy pi̠ lanca xla­ca­tzúcut y a̠ma̠ko̠lh xta­ma̠­kalh­ta­huaké̠n taca̠­naj­lá­nilh pi̠ xli̠­cána xlá Cristo hua̠nti̠ xmini̠t ca̠lak­ma̠xtuy. ");
INSERT INTO tocNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Aca­li̠stá̠n Jesús ca̠tá̠alh xtzí, chu xli̠­ta­la­ka­pasni xa̠hua xta­ma̠­kalh­ta­huaké̠n nac aktum ca̠chi­quí̠n xuanicán Caper­naum pero ni̠ luu maka̠s quilh­ta­macú antá xta­la­ma̠­nanchá. ");
INSERT INTO tocNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Cumu aya xta­la­ca­tzu­hui̠ma xpa̠x­cuajcán judíos xla taak­spun­tza̠lí̠n, Jesús alh nac xaca̠­chi­quí̠n Jeru­salén. ");
INSERT INTO tocNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Acxni̠ tanu̠chá nac lanca pu̠si­culan ca̠ma̠­nók­lhulh nac xtan­quilhtí̠n hua̠nti̠ xta­sta̠­má̠­nalh huá̠cax chu bor­regos y pa­lomas, xa̠hua hua̠nti̠ antá xta­hui­lá̠­nalh tí xta­lak­pa­li̠niy xtu­mi̠ncán cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Acxni̠ ca̠úcxilhli Jesús li̠huana̠ ca̠x­tlá­hualh kantum tasíhu y huá tzú­culh ca̠li̠t­la­kaxtuy pu̠tum sta̠­naní̠n, na̠chuná xbor­re­goscán, chu xua̠caxcán; y hua̠nti̠ xta­lak­pali̠y tumi̠n ca̠ma̠akpu̠s­pít­nilh xme­sajcán y nac ca̠ti­yatni ca̠ta­ra­mí̠­nilh xtu­mi̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Hua̠nti̠ xta­sta̠­má̠­nalh pa­lomas chiné ca̠huá­nilh: —Pu̠tum tamá caca̠­ta­mac­xtútit uú y ni̠ cali̠­ma̠x­tútit xchic Quin­tla̠t cumu la̠ aktum pu̠stá̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ama̠­ko̠lh xta­ma̠­kalh­ta­huaké̠n tala­ca­pá̠s­tacli hua̠ntu̠ huan lacatum nac li̠kalh­ta­huaka anta­nícu chiné huan: “Xli̠­hua̠k qui­nacú cli̠­lak­ca­tzán mim­pu̠­si­culan y ni̠ cma̠t­la̠nti̠y la̠ta túcu ni̠tlá̠n antá tla­huacán.” ");
INSERT INTO tocNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Maka­pi­tzí̠n xana­puxcún judíos taka­lhás­quilh: —¿Túcuya̠ lanca ta­scújut tla̠n nat­la­huaya hua̠ntu̠ nacuc­xi­lhá̠hu la̠qui̠ nac­ca­tzi̠­yá̠hu pi̠ xli̠­ca̠na kalhi̠ya li̠ma̠­peksí̠n xla­cata hua̠ntu̠ tlahua? ");
INSERT INTO tocNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús ca̠kálh­ti̠lh: —Calac­tla­huátit eé pu̠si­culan y caj aktutu quilh­ta­macú aquit nac­tla­hua­paray tunu xasa̠sti. ");
INSERT INTO tocNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Entonces a̠ma̠ko̠lh judíos tahuá­nilh: —Ti̠pu­xa­ma­cha̠xán ca̠ta li̠maka­pa­la­ca­ni̠ttá la̠ta tla­hua­má̠­calh eé lanca xpu̠­si­culan Dios, ¿nícu chú huix natzu­cu­niya xla­cata caj aktutu quilh­ta­macú nali̠t­la­huaya tunu xasa̠sti? ");
INSERT INTO tocNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero xlacán ni̠ taaká­ta̠ksli porque a̠má pu̠si­culan hua̠ntu̠ xlá xli̠­chu­hui̠­nama Jesús pus xlá xti­yat­li̠hua xuanima. ");
INSERT INTO tocNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Pus acxnicú Jesús ni̠lh y lacas­ta­cuánalh nac ca̠li̠ní̠n xta­ma̠­kalh­ta­huaké̠n tala­ca­pá̠s­tacli eé xta­chu­huí̠n y taca̠­náj­lalh porque luu chuná xqui̠­kan­tax­tuni̠t cumu la̠ xca̠­hua­nini̠t y na̠chuná la̠ huan nac li̠kalh­ta­huaka hua̠ntu̠ tatzok­ta­hui­lani̠t xpa̠­la­cata. ");
INSERT INTO tocNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Acxni̠ Jesús xla­ma̠­chicú nac Jeru­salén cxa­pa̠xcua taak­spun­tza̠lí̠n lhu̠hua cris­tianos taca̠­naj­lá­nilh cumu taúcxilhli lac­lanca xta­scújut hua̠ntu̠ xlá xca̠t­la­huama. ");
INSERT INTO tocNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero cumu xlá xca̠­la­ka­pasa cha̠­tunu la̠ta lácu xta­pu­hua̠ncán ni̠ hua̠k xca̠­najlay la̠ta túcu xlacán xta­huaniy. ");
INSERT INTO tocNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Xlá hua̠k xca̠­la­ka­pasa la̠ta lácu xlacán xta̠­yatcán cha̠­tunu cris­tianos y pus Jesús ni̠ xla­cas­quima para tícu nali̠­ta̠­chu­hui̠nán la̠ta lácu xlacán xta­pu­hua̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Xlama cha̠tum chixcú fariseo xuanicán Nico­demo, xlá luu tali̠­pa̠hu chixcú xuani̠t nac xlak­sti̠­pa̠ncán judíos. ");
INSERT INTO tocNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Maktum tzi̠sní Nico­demo alh laka­pa­xia̠lhnán Jesús y chiné huá­nilh: —Ma̠kalh­ta­hua­ke̠ná, aquinín cca­tzi̠­yá̠hu pi̠ Dios maca­mi­ni̠tán xla­cata naqui­la̠­ma̠­kalh­chu­hui̠­ni̠­yá̠hu, porque ni̠para cha̠tum tícu tla̠n ma̠siyuy lac­lanca li̠cá̠cni̠t ta­scújut cumu la̠ huix ca̠t­la­huaya para ni̠ huá Dios nama̠x­qui̠y xli̠­maka­tli­hueke. ");
INSERT INTO tocNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús huá­nilh: —Xli̠­ca̠na cuaniyá̠n que para tícu ni̠ nala­ca­chín a̠maktum ni̠lay catiúcxilhli lácu Dios ma̠tzu­qui̠ma xasa̠sti xta­péksi̠t nac ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nico­demo kalhás­quilh: —Pero, ¿lácu nalay nala­ca­chín cha̠tum chixcú para aya ko̠lutá? ¿Lácu pi̠ tla̠n nata­nu̠­paray nac xpu̠­lacni xtzí la̠qui̠ nala­ca­chim­paray a̠maktum? ");
INSERT INTO tocNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús kalh­ti̠pá: —Xli̠­cána cuaniyá̠n, hua̠nti̠ ni̠ nali̠­la­ca­chín chú­chut xa̠hua Espíri­tu Santo, ni̠lay cati­mak­ta­pék­si̠lh hua̠ntu̠ Dios tla­huama. ");
INSERT INTO tocNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Porque a̠má cris­tiano hua̠nti̠ laca­chín caj xla­cata cumu xtzí y xtla̠t tama̠x­qui̠y xti­yat­li̠hua, pus xlá chuná kalhi̠y xta­la­ca­pa̠s­tacni cumu la̠ uú xala ca̠quilh­ta­macú, pero hua̠nti̠ li̠la­ca­chín Espíri­tu Santo pus xlá chuná kalhi̠y xta­la­ca­pa̠s­tacni cumu la̠ tu̠ kalhi̠y Espíri­tu Santo. ");
INSERT INTO tocNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ni̠ cali̠­pé̠­cuanti hua̠ntu̠ cuanimá̠n pero mili̠­ca­tzi̠tcán pi̠ Dios luu lacas­quín pi̠ hua̠k cris­tianos nata­la­ca­chín a̠maktum. ");
INSERT INTO tocNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Eé hua̠ntu̠ cuanimá̠n xta̠­chuná qui̠­taxtuy acxni̠ huix kax­pata ma̠rí macaacsa̠nán u̠n, pero ni̠ catzi̠ya nícu pekama ni̠para nícu mima̠chá porque ni̠ tasiyuy, pus na̠chuná a̠ma̠ko̠lh cris­tianos hua̠nti̠ Dios ca̠ma̠x­qui̠y Xes­pí­ritu xa̠hua xta­la­ca­pa̠s­tacni, ni̠ tasiyuy pero sa̠sti cris­tianos tahuán porque xli̠­ca̠na tala­ca­chín a̠maktum. ");
INSERT INTO tocNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nico­demo kalhas­quimpá: —Luu ni̠ caka­ta̠ksa lácu luu naqui̠­taxtuy tamá. ");
INSERT INTO tocNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús huá­nilh: —Huix luu ska­lala y tali̠­pa̠hu chixcú uú xalac Israel, ¿y ni̠ aka­ta̠ksa hua̠ntu̠ cuanimá̠n? ");
INSERT INTO tocNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Xli̠­ca̠na cuaniyá̠n, aquit cli̠­ta̠­chu­hui̠­namá̠n hua̠ntu̠ cca­tzi̠y y cma̠­lu­loka hua̠ntu̠ cuc­xilhni̠t, pero huix ni̠ ca̠naj­laya hua̠ntu̠ aquit cuanimá̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Para hui­xinín ni̠ ca̠naj­la­yá̠tit acxni̠ cca̠­li̠­ta̠­kalh­chu­hui̠­naná̠n hua̠ntu̠ anán uú nac ca̠quilh­ta­macú, ¿pi̠ li̠huaca chú naca̠­naj­la­yá̠tit para nac­ca̠­li̠­ta̠­kalh­chu­hui̠­naná̠n hua̠ntu̠ anán nac akapú̠n? ");
INSERT INTO tocNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nac akapú̠n ni̠ti̠ catzi̠y túcu anán, caj xma̠n aquit Xata­lac­sacni Chixcú cca­tzi̠y túcu anán porque nac akapú̠n cmi­ni̠­tanchá. ");
INSERT INTO tocNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Hui­xinín catzi̠­yá̠tit xla­cata maktum quilh­ta­macú nac desierto Moisés xto­ko­huá­calh nac kantum quihui tantum lu̠hua xla bronce y aka­chex­yá̠­hualh la̠qui̠ hua̠nti̠ nataucxilha ni̠ catí­ni̠lh, pus na̠chuná chú aquit Xata­lac­sacni Chixcú amá̠­calh quix­to­ko­hua­cacán, ");
INSERT INTO tocNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","la̠qui̠ xli̠­pacs hua̠nti̠ naqui­li̠­pa̠­huán ni̠ cati­lak­tzán­ka̠lh huata luu tla̠n naquin­ta̠­la­tama̠y cane̠c­xni­cahuá quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Porque Dios luu snu̠n ca̠pá̠x­qui̠lh cris­tianos xala ca̠quilh­ta­macú, pus huá xpa̠­la­cata li̠ma­ca­má̠s­ta̠lh xma̠n cha̠stum xka­huasa la̠qui̠ naca̠­pa̠­la­caníy cris­tianos y chuná cati̠huá hua̠nti̠ nali̠­pa̠­huán ni̠ cati­lak­tzán­ka̠lh, huata naka­lhi̠y a̠má li̠pa̠­xúhu latáma̠t hua̠ntu̠ ne̠cxni cati­lák­sputli. ");
INSERT INTO tocNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Porque Dios ni̠ huá li̠ma­cá­milh Xka­huasa para caj nama̠­lak­tzan­ke̠nán, pus huá li̠ma­cá­milh la̠qui̠ nalak­ma̠x­tunún. ");
INSERT INTO tocNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Hua̠nti̠ li̠pa̠­huán Xka­huasa Dios ne̠cxni cati­lak­tzán­ka̠lh, pero hua̠nti̠ ni̠ ca̠naj­laniy xta­chu­huí̠n ámaj pa̠ti̠nán porque ni̠ li̠pa̠­huán a̠má hua̠nti̠ xma̠n huá cha̠stum Xka­huasa Dios. ");
INSERT INTO tocNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Hua̠nti̠ ni̠ taca̠­naj­laniy xta­chu­huí̠n ámaj pa̠ti̠nán porque milh tax­káket nac ca̠quilh­ta­macú y xlacán a̠tzinú tala­ká­ti̠lh tala­ta­pu̠li̠y nac xaca̠­pucsua ni̠ xachuná nac xaca̠x­ka­kaná, la̠qui̠ ni̠ti̠ naca­tzi̠y para li̠xcáj­nit hua̠ntu̠ xtat­la­hua­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Pu̠tum hua̠nti̠ ni̠tlá̠n xta­la­ca­pa̠s­tac­nicán ni̠ taucxilh­putún tax­káket la̠qui̠ ni̠ nata­li̠­ta­siyuy xka­satcán y ni̠ talak­ta­la­ca­tzu­hui̠y. ");
INSERT INTO tocNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero hua̠nti̠ tla̠n xta­la­ca­pa̠s­tac­nicán talak­ta­la­ca­tzu­hui̠y tax­káket la̠qui̠ nata­li̠­ta­siyuy pi̠ Dios ca̠ta̠­lama y tla̠n hua̠ntu̠ tat­la­hua­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Aca­li̠stá̠n Jesús ca̠tá̠alh xta­ma̠­kalh­ta­huaké̠n nac xamu­ni­cipio Judea y juerza maka̠s tzinú antá xta­la­ma̠­nanchá y antá xca̠akmu­numa cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan na̠ antá xak­mu­nu̠­numa nac Enón lacatzú nac Salim, porque antá lhu̠hua xuí chú­chut. Antá xtamín lhu̠hua cris­tianos y xca̠akmu­nucán. ");
INSERT INTO tocNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Pu̠tum eé chuná qui̠­táx­tulh acxni̠ nia̠ xta­mac­nu̠cán nac pu̠la̠­chi̠n Juan. ");
INSERT INTO tocNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Amá quilh­ta­macú xta­ma̠­kalh­ta­huaké̠n Juan y cha̠tum judío tzú­culh taliaklhu̠­hua̠tnán xatícu a̠tzinú tla̠n xapay xta­la̠­ka­lhí̠n acxni̠ akmu­nu̠nún, pi̠ huá cahuá Jesús. ");
INSERT INTO tocNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Xlacán talá­kalh Juan y chiné tahuá­nilh: —Ma̠kalh­ta­hua­ke̠ná, a̠má chixcú hua̠nti̠ qui̠­laklán a̠li̠quilh­tu̠tu kalh­tu̠­choko Jordán hua̠nti̠ huix xli̠­chu­hui̠­námpa̠t pi̠ mini̠tán quin­ca̠­lak­ma̠x­tuyá̠n, chú na̠ aya akmu­nu̠­numa y lhu̠hua cris­tianos ta­sta̠­la­ni­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Entonces Juan chiné ca̠huá­nilh: —Ni̠para cha̠tum cris­tianos lay túcu kalhi̠y para ni̠ huá Dios nama̠x­qui̠y. ");
INSERT INTO tocNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Porque hui­xinín luu laca­tancs kax­pat­ni̠­tátit acxni̠ chiné cuá: “Aquit ni̠ Cristo hua̠nti̠ kalhi̠­pa̠­nántit.” Pus aquit a̠má chixcú hua̠nti̠ ma̠la­ka­chá̠­calh la̠qui̠ nac­pu̠­laniy Cristo y a̠li̠sok nac­ca̠­ma̠­ca­tzi̠ni̠y cris­tianos pi̠ mimajá. ");
INSERT INTO tocNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Cumu la̠ hui­xinín catzi̠­yá̠tit, nac aktum pu̠ta­maka­xtokni a̠má kahuasa hua̠nti̠ ta̠láhui tzuma̠t pus huá tamaka­xtokma, y a̠má cha̠­tum­li̠túm hua̠nti̠ antá lacatzú láhui, xlá caj xamigo, y luu li̠pa̠­xúhu kalha­kax­mata hua̠ntu̠ xlá li̠chu­hui̠­nama; pus na̠chuná chú aquit luu cli̠­pa̠­xu­huay cumu hua̠k huá ta­sta̠­la­ni­má̠­nalh Jesús. ");
INSERT INTO tocNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Cha̠li cha̠lí xlá a̠tzinú lhu̠hua amá̠­calh li̠pa̠­huancán y luu a̠tzinú tali̠­pa̠hu nahuán, y aquit niaj tu̠ cac­ti­li̠­táx­tulh, huata cha̠li cha̠lí cámaj li̠ta­tu̠­tzu­hui̠y. ");
INSERT INTO tocNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Ama̠­ko̠lh cris­tianos hua̠nti̠ uú tala­ca­chini̠t nac ca̠quilh­ta­macú, pus xlacán xma̠nhuá tla̠n tali̠­chu­hui̠nán hua̠ntu̠ anán uú nac ca̠quilh­ta­macú y hua̠ntu̠ tala­ka­pasa. Pero hua̠nti̠ mini̠­tanchá nac akapú̠n xlá a̠tzinú kalhi̠y li̠ma̠­peksí̠n y xta­la­ca­pa̠s­tacni, y huá li̠chu­hui̠nán hua̠ntu̠ anán nac akapú̠n porque xlá ni̠ xta̠­chuná cumu la̠ cati̠hua̠ cris­tiano, ");
INSERT INTO tocNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","y huá xlá li̠chu­hui̠nán hua̠ntu̠ ucxilhni̠t y hua̠ntu̠ kax­matni̠t; y ma̠squi chuná la̠ta túcu xlá li̠chu­hui̠nán ni̠ti̠ ca̠naj­laniy. ");
INSERT INTO tocNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pero maka­pi­tzí̠n cris­tianos hua̠nti̠ taca̠­naj­laniy chuná xlacán tama̠­lu­loka nac xla­ta­ma̠tcán pi̠ xli̠­cána xta­la­ca­pa̠s­tacni Dios hua̠ntu̠ xlá li̠chu­hui̠­nama. ");
INSERT INTO tocNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Pus a̠má chixcú hua̠nti̠ Dios macá­milh nac ca̠quilh­ta­macú la̠qui̠ xlá naquin­ca̠­li̠­ma̠­kalh­chu­hui̠­ni̠yá̠n xta­chu­huí̠n, xma̠nhuá xlá tla̠n li̠chu­hui̠nán xta­la­ca­pa̠s­tacni, porque Dios ni̠ caj cha̠­lak­ca­tzaj ma̠x­qui̠ni̠t Xes­pí­ritu. ");
INSERT INTO tocNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Quin­tla̠­ticán Dios pa̠x­qui̠y Xka­huasa Jesu­cristo y la̠ta túcu anán xlá hua̠k maca­ma̠x­qui̠ni̠t xla­cata naca̠­ma̠­peksi̠y. ");
INSERT INTO tocNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Hua̠nti̠ li̠pa̠­huán Xka­huasa Dios mak­lhti̠nán a̠má li̠pa̠­xúhu latáma̠t hua̠ntu̠ anka­lhi̠ná cahuá naka­lhi̠y, pero hua̠nti̠ ni̠ kalha­kax­mat­putún xla­cata nali̠­pa̠­huán, xlá ne̠cxni cati­ká­lhi̠lh a̠má latáma̠t sinoque fuerza ámaj pa̠ti̠y a̠má li̠pe̠­cuánit tapa̠tí̠n chuná la̠ Dios lac­lhca̠­hui­li̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ni̠ li̠maka̠s quilh­ta­macú a̠ma̠ko̠lh fariseos tacá­tzi̠lh pi̠ a̠tzinú lhu̠hua cris­tianos xta­sta̠­la­ni­má̠­nalh Jesús, xa̠huachí a̠tzinú lhu̠hua xak­mu­nu̠­numa ni̠ xachuná Juan, ");
INSERT INTO tocNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(ma̠squi xli̠­ca̠na pi̠ ni̠ huá Jesús xca̠akmunuy cris­tianos, pus huata xta­ma̠­kalh­ta­huaké̠n xtaakmu­nu̠nún). ");
INSERT INTO tocNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Pero cumu Jesús xca­tzi̠y pi̠ xta­si̠­tzi̠niy y cátzi̠lh pi̠ chuná xta­li̠­lac­chu­hui̠­na­má̠­nalh fariseos, huata mejor táca̠xli nac Judea la̠qui̠ naán nac Gali­lea. ");
INSERT INTO tocNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Pero a̠má tiji hua̠ntu̠ xan nac Gali­lea antá xti̠­tax­tucán nac xapu̠­la­tama̠n Samaria. ");
INSERT INTO tocNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Jesús cha̠lh nac aktum ca̠chi­quí̠n xalac a̠má muni­cipio xuanicán Sicar, lacatzú nac a̠má pú̠cuxtu hua̠ntu̠ xma̠­peksi̠y xamaká̠n ko̠lu­tzí̠n Jacob hua̠ntu̠ xaka­ta̠x­tu­nini̠t xka­huasa José. ");
INSERT INTO tocNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Antá nac a̠má pú̠cuxtu xuí aktum pozo hua̠ntu̠ xpu̠­huaxni̠t ko̠lu­tzí̠n Jacob. Ma̠x cumu luu tas­túnut xuani̠t y cumu luu ma̠rí xchi­chi­nima Jesús xmaka­tla­kuani̠ttá tiji, pus huata xlá antá táhui nac xquilhpá̠n pozo. ");
INSERT INTO tocNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ama̠­ko̠lh xdis­cí­pulos Jesús xtaani̠t nac ca̠chi­quí̠n la̠qui̠ nata­ta­ma̠­huay hua̠ntu̠ nata­huay, y caj li̠puntzú chilh nac pozo cha̠tum pusca̠t xalac Samaria la̠qui̠ nama̠­cutuy chú­chut. Y Jesús chiné huá­nilh: —Xquin­ta̠hua actzu̠ min­chú­chut. ");
INSERT INTO tocNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Pero a̠má pusca̠t samari­tana chiné kálh­ti̠lh: —¿Túcu xla­cata aquit qui­li̠s­qui­niya chú­chut lácu pi̠ na̠ judía aquit? Pus aquit antá xalac Samaria. Huá chuná li̠huá­nilh porque judíos ni̠ xta­ta̠­la̠lé̠n Sama­ri­tanos. ");
INSERT INTO tocNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesús chiné kálh­ti̠lh: —Xli̠­ca̠na para catzi̠ya cahuá hua̠ntu̠ Dios ma̠sta̠y y xa̠huachí para xcatzi tícuya̠ chixcú hua̠nti̠ squi­nimá̠n chú­chut, tancs cuaniyá̠n pi̠ huata xquis­quini chú­chut y aquit xac­ma̠x­quí̠n chú­chut hua̠ntu̠ xli̠­ca̠na ma̠sta̠y latáma̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Amá pusca̠t chiné huá­nilh: —Pero ni̠para xli̠­ma̠­cu­tucán chú­chut kalhi̠ya y chi̠nchú u̠má pozo luu pu̠lhmá̠n, ¿lácu chú nat­la­huaya la̠qui̠ tla̠n naqui­ma̠x­qui̠ya a̠má chú­chut hua̠ntu̠ xli̠­ca̠na ma̠sta̠y latáma̠t? ");
INSERT INTO tocNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Umá chú­chut hua̠ntu̠ taju̠ma nac eé pozo xli̠­ca̠na pi̠ luu tla̠n porque huá xamaká̠n qui­li̠­ta­la­ka­pas­nicán Jacob hua̠nti̠ quin­ca̠­mak­xtek­ni­ni̠tán; antá xlá xkotnún xa̠hua xli̠­pacs xca­maná̠n chu xli̠­hua̠k xta­ka­lhí̠n antá xca̠­ma̠­kotni̠y. ¿Chi̠nchú huix pi̠ a̠tzinú luu tlak tali̠­pa̠hu li̠tax­tu­pu­tuna ni̠ xachuná xlá? ");
INSERT INTO tocNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús chiné kálh­ti̠lh: —Xli̠­pu̠tum hua̠nti̠ tali̠­kotnún eé chú­chut ni̠ li̠maka̠s tzu­cu­paray takalh­pu̠ti̠y, ");
INSERT INTO tocNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","pero hua̠nti̠ nali̠­kotnún a̠má chú­chut hua̠ntu̠ aquit cma̠sta̠y niaj ne̠c­xnicú cati­kalh­pú̠­ti̠lh. Porque a̠má chú­chut hua̠ntu̠ aquit cma̠sta̠y, antá nac xnacú natzucuy musnún la̠qui̠ chuná naka­lhi̠y xasa̠sti latáma̠t cane̠c­xni­cahuá quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Amá pusca̠t chiné huá­nilh: —Pus luu cat­lahua li̠tlá̠n caquin­ta̠­li̠­kót­nunti tamá chú­chut la̠qui̠ niaj nac­kalh­pu̠ti̠y y la̠qui̠ niaj nacmín tiyay chú­chut uú nac pozo. ");
INSERT INTO tocNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús chiné hua­nipá: —Huata mejor pu̠lh caqui̠­ta­sani min­ta̠­ko̠lú y acxtum nata̠­tana. ");
INSERT INTO tocNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Amá pusca̠t chiné huá­nilh: —Aquit ni̠ti̠ quin­ta̠­ko̠lú. Y Jesús kálh­ti̠lh: —Luu xli̠­ca̠na la̠ huana pi̠ ni̠ti̠ min­ta̠­ko̠lú, ");
INSERT INTO tocNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","porque aya xli̠­ka­lha­qui­tzis lac­chix­cu­huí̠n hua̠nti̠ huix ca̠ti­ta̠­ta­huila, y hua̠nti̠ ta̠huilán la̠nchú ni̠ min­ta̠­ko̠lú. Poreso luu xli̠­ca̠na hua̠ntu̠ huix chu­hui̠­na­ni̠ta. ");
INSERT INTO tocNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Acxni̠ a̠má pusca̠t káx­matli eé tachu­huí̠n chiné huá­nilh: —Pus hasta la̠nchú cca­tzi̠ma pi̠ huix luu lanca tali̠­pa̠hu pro­feta. ");
INSERT INTO tocNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Pus xtlahua li̠tlá̠n xqui­huani aktum tachu­huí̠n hua̠ntu̠ aquit cca­tzi̠­putún; xalak­maká̠n qui­li̠­ta­la­ka­pas­nicán samari­tanos xtamín tala­ka­chix­cu­hui̠y Dios nac eé ke̠stí̠n, pero hui­xinín judíos hua­ná̠tit pi̠ antá nac Jeru­salén nala­ka­chix­cu­hui̠­yá̠hu Dios. ");
INSERT INTO tocNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús kálh­ti̠lh: —Pusca̠t, cacatzi huix la̠nchú pi̠ tala­ca­tzu­hui̠ma quilh­ta­macú acxni̠ hui­xinín tla̠n nala­ka­chix­cu­hui̠­yá̠tit Quin­tla̠­ticán Dios ma̠squi ni̠ catátit uú nac ke̠stí̠n y ma̠squi ni̠ capítit nac Jeru­salén. ");
INSERT INTO tocNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Hui­xinín samari­tanos ni̠para tzinú catzi̠­yá̠tit tícu luu laka­chix­cu­hui̠­yá̠tit pero aquinín judíos cca­tzi̠­yá̠hu hua̠nti̠ cla­ka­chix­cu­hui̠­ma̠­náhu, porque hua̠nti̠ naca̠­lak­ma̠x­tuyá̠n antá mima̠chá nac xlak­sti̠­pa̠ncán judíos. ");
INSERT INTO tocNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pero ámaj lak­chá̠n quilh­ta­macú y la̠nchú aya lak­cha̠ni̠t acxni̠ hua̠nti̠ xli̠­ca̠na tala­ka­chix­cu­hui̠­putún Dios tla̠n cani̠huá natat­la­huay, pero hua̠ntu̠ luu xli̠­ca̠na aksti̠tum cumu lá naca̠­ma̠­la­ca­pa̠s­tacni̠y Espíri­tu Santo, porque Dios ca̠pu­tzama hua̠nti̠ nata­la­ka­chix­cu­hui̠y cumu la̠ cuanimá̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios caj Espíri­tu y ni̠ caj lacatum huí cumu la̠ hui­xinín lac­pu­hua­ná̠tit, y a̠má cris­tiano hua̠nti̠ nala­ka­chix­cu­hui̠y mini̠niy nali̠­la­ka­chix­cu­hui̠y xli̠­hua̠k aktum xatlá̠n tala­ca­pa̠s­tacni y hua̠ntu̠ luu aksti̠tum cumu la̠ Xes­pí­ritu Dios nama̠­la­ca­pa̠s­tacni̠y nac xnacú. ");
INSERT INTO tocNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Amá pusca̠t chiné huá­nilh: —Aquit cca­tzi̠y pi̠ ámaj min cha̠tum hua̠nti̠ quin­ca̠­ma̠­lac­nu̠­ni­ni̠tán Dios la̠qui̠ naquin­ca̠­lak­ma̠x­tuyá̠n hua̠nti̠ hua­nicán Cristo, y acxni̠ xlá namín hua̠k naquin­ca̠­ma̠­la­ca­pu̠­tun­cu­hui̠­niyá̠n hua̠ntu̠ luu qui­li̠­ca­tzi̠tcán. ");
INSERT INTO tocNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús hua­nipá a̠má pusca̠t: —Pus la̠nchú luu laca­tancs cuaniyá̠n pi̠ aquit a̠má chixcú hua̠nti̠ huix li̠chu­hui̠­námpa̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Acxni­tiyá chuná xta­chu­hui̠­na­má̠­nalh tachilh xdis­cí­pulos, xlacán cacs tala­cáhua acxni̠ taúcxilhli Jesús pi̠ xta̠­chu­hui̠­nama a̠má pusca̠t samari­tana. Pero ni̠para cha̠tum xka­lhás­quilh túcu xla­cas­quín osuchí túcu xta­li̠­chu­hui̠­na­má̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Y a̠má pusca̠t antá akxte­kuíli̠lh xak­sá̠­huat y la̠li̠­huán alh nac ca̠chi­quí̠n, y antá chiné ca̠huá­nilh cris­tianos: ");
INSERT INTO tocNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Catátit ucxi­lhá̠tit cha̠tum chixcú, xlá luu laca­tancs qui­hua­nini̠t la̠ta túcu aquit ctit­la­hua­ni̠ttá nac qui­la­táma̠t. ¿Lácu hua­ná̠tit, ni̠ huá cahuá Cristo hua̠nti̠ namín quin­ca̠­lak­ma̠x­tuyá̠n? ");
INSERT INTO tocNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ama̠­ko̠lh cris­tianos la̠li̠­huán taminchá nac ca̠chi­quí̠n y táalh anta­nícu xuilachá Jesús. ");
INSERT INTO tocNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Y antá nac pozo xdis­cí­pulos Jesús tzú­culh tali̠­ma̠­ka­tzanke̠y la̠qui̠ nahua̠yán y chiné xta­hua­ni­ma̠na: —Ma̠kalh­ta­hua­ke̠ná, cahuá̠­yanti ma̠squi ca̠na caj actzú. ");
INSERT INTO tocNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pero xlá chiné ca̠kálh­ti̠lh: —Aquit aya cka­lhi̠y hua̠ntu̠ nacuay y hui­xinín ni̠ laka­pa­sá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Y xdis­cí­pulos sac­stucán chiné tzú­culh tala̠­huaniy: —¿Ma̠x tzanká tícu li̠mí­nilh para túcu nahuay? ");
INSERT INTO tocNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Pero Jesús ca̠huá­nilh: —Acxni̠ aquit ctla­huay xta­pa̠­xu­huá̠n Dios lá̠m­para quin­ta­huaj cli̠­ma̠xtuy hasta acxni̠ nac­ma̠s­putuy. ");
INSERT INTO tocNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Acxni̠ hui­xinín ucxi­lhá̠tit xta­huácat tachaná̠n hua­ná̠tit: “Ma̠squi ni̠ luu cala­ca­pa­láhu porque tzan­ka̠ycú akta̠ti papá la̠ta tla̠n naxka̠nancán”; pero aquit cca̠­hua­niyá̠n pi̠ cala­ca­pítit y na̠ caca̠ucxílhtit anta­nícu hui­la­ko̠lh a̠túnuj tachaná̠n, antá aya lhmu­cu­cu­ma̠­ko̠lh y tla̠ná natzu­cu­yá̠tit xka̠­na­ná̠tit. ");
INSERT INTO tocNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Pus hui­xinín hua̠nti̠ namak­xka̠­na­ná̠tit nac eé ca̠tu­huá̠n na̠ naca̠­ma̠s­ka­hui̠­ca­ná̠tit y a̠má hua̠ntu̠ nama̠­mac­xtu­pi̠­yá̠tit huá xli̠s­tac­nicán cris­tianos hua̠nti̠ anka­lhi̠ná cahuá taka­lhi̠y li̠pa̠­xúhu latáma̠t. Huí tunu hua̠nti̠ tachani̠t eé tachaná̠n y hui­xinín chú pim­pá̠tit ma̠mac­xtu­pi̠­yá̠tit la̠qui̠ acxtum nali̠­pa̠­xu­hua­yá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Y luu laca­tancs chuná ca̠qui̠­tax­tu­nimá̠n a̠má tachu­huí̠n hua̠ntu̠ chiné huan: “Túnuj chixcú hua̠nti̠ cha­na̠nán y tunu hua̠nti̠ xka̠nán.” ");
INSERT INTO tocNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Aquit cca̠­ma̠­la­ka­cha̠má̠n hui­xinín la̠qui̠ nama̠­mac­xtu­pi̠­yá̠tit xta­huácat a̠má tachaná̠n hua̠ntu̠ tachani̠t a̠túnuj lac­chix­cu­huí̠n; pus tunu hua̠nti̠ tali̠s­cujni̠t y chi̠nchú hui­xinín ca̠ta caj ma̠mac­xtu­pi̠­yá̠tit hua̠ntu̠ xlacán tali̠s­cujni̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Lhu̠hua cris­tianos hua̠nti̠ xta­hui­lá̠­nalh nac a̠má ca̠chi­quí̠n hua­nicán Sicar talák­milh antaní xuí Jesús porque taca̠­naj­lá­nilh caj xpa̠­la­cata hua̠ntu̠ xuanini̠t a̠má pusca̠t acxni̠ xlá ca̠huá­nilh xla­cata pi̠ xuanini̠t xli̠­hua̠k hua̠ntu̠ xlá xtit­la­hua­ni̠ttá nac xla­táma̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Acxni̠ a̠ma̠ko̠lh samari­tanos talák­chilh Jesús tata̠­chu­huí̠­nalh y tahuá­nilh xla­cata caca̠­ta̠­ta­mák­xtekli nac xca̠­chi­qui̠ncán ca̠na caj nícu akli̠t quilh­ta­macú. Xlá ma̠t­lá̠n­ti̠lh y ca̠ta̠­ta­mák­xtekli aktiy quilh­ta­macú, ");
INSERT INTO tocNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","y luu lhu̠hua cris­tianos tali̠­pá̠­hualh acxni̠ takax­mát­nilh xta­chu­huí̠n hua̠ntu̠ xlá xli̠­chu­hui̠­náma. ");
INSERT INTO tocNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Aca­li̠stá̠n chiné tahuá­nilh a̠má pusca̠t: —Chú aquinín na̠ cca̠­naj­la­yá̠hu ni̠ xla­cata cumu para caj huix qui­la̠­li̠­ta̠­chu­hui̠­na­ni̠­táhu sino porque mismo ma̠n quin­ta­ke̠ncán aquinín cli̠­kax­mat­ni̠­táhu y chú aquinín cta­lu­lo­ká̠hu pi̠ xli̠­ca̠na huá Cristo xma̠aka­pu̠­tax­ti̠­nacán cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ali̠aktiy quilh­ta­macú acxni̠ aya taca̠xli Jesús nac a̠má ca̠chi­quí̠n hua̠ntu̠ xma̠­peksi̠y Samaria y quilh­ta̠­yapá xtiji la̠qui̠ nachá̠n nac xapu̠­la­tama̠n Gali­lea. ");
INSERT INTO tocNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ma̠squi xapu̠lh chuná tíhua Jesús xla­cata pi̠ cha̠tum pro­feta ni̠ li̠pa̠­huancán hua̠ntu̠ li̠chu­hui̠nán nac xca̠­chi­quí̠n, ");
INSERT INTO tocNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","pero xli̠­ca̠na pi̠ ni̠ anka­lhí̠n chuná qui̠­taxtuy porque acxni̠ cha̠lh nac lactzu̠ ca̠chi­qui̠ní̠n hua̠ntu̠ xca̠­ma̠­peksi̠y Gali­lea cani̠huá luu li̠pa̠­xúhu tamaka­maklhtí̠­nalh, porque lhu̠hua xlacán na̠ xta­qui̠­lani̠t nac xapa̠xcua taak­spun­tza̠lí̠n nac Jeru­salén, y a̠ma̠ko̠lh cris­tianos hua̠k xtaucxilhni̠t hua̠ntu̠ antá Jesús xca̠t­la­huani̠t lac­lanca li̠cá̠cni̠t ta­scújut. ");
INSERT INTO tocNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Pero huata Jesús ampá nac aktum ca̠chi­quí̠n hua­nicán Caná, antá nac u̠má ca̠chi­quí̠n caj chú­chut luu xatlá̠n vino li̠t­la­huani̠t. Y antá ma̠nók­lhulh cha̠tum luu tali̠­pa̠hu chixcú hua̠nti̠ na̠ luu lac­xtum xta̠­ma̠­pek­si̠nán rey, xlá antá xuilachá nac Caper­naum y xka­lhi̠y cha̠tum xka­huasa hua̠nti̠ luu xta̠­tatlay. ");
INSERT INTO tocNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Acxni̠ cátzi̠lh a̠má chixcú pi̠ Jesús xmi­ni̠­tanchá nac Judea y xchini̠t nac Gali­lea, la̠li̠­huán alh li̠ma̠aka­tzanke̠y xla­cata catá̠alh nac xchic y cama̠t­la̠n­tí̠­nilh xka­huasa porque a̠tzinú aya xni̠­putún. ");
INSERT INTO tocNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesús chiné huá­nilh: —Hui­xinín ni̠ luu qui­la̠­li̠­pa̠­hua­ná̠hu para ni̠ pu̠lh naucxi­lhá̠tit aktum luu li̠cá̠cni̠t ta­scújut hua̠ntu̠ ctla­huay. ");
INSERT INTO tocNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pero a̠má tali̠­pa̠hu chixcú chiné huá­nilh: —Ma̠kalh­ta­hua­ke̠ná, luu xli̠­ca̠na cat­lahua li̠tlá̠n, pála caquin­ta̠pi nac quín­chic li̠huán nia̠ ni̠y quin­ka­huasa. ");
INSERT INTO tocNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Pero huata Jesús chiné huá­nilh: —Luu li̠pa̠­xúhu capit nac mín­chic porque a̠má min­ka­huasa aya tat­la̠n­ti̠ni̠t. Amá chixcú ca̠náj­lalh hua̠ntu̠ huá­nilh Jesús y la̠li̠­huán alh nac xchic. ");
INSERT INTO tocNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Acxni̠ aya xcha̠n­ti̠­lhay nac xchic la̠li̠­huán támilh tapa̠x­toka maka­pi­tzí̠n xta­sa̠­cuá̠n, y chiné tahuá­nilh: —Min­ka­huasa aya tat­la̠n­ti̠ni̠t y luu tla̠n má. ");
INSERT INTO tocNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Xlá ca̠ka­lhás­quilh cumu túcuya̠ hora tzu­cuni̠t tat­la̠nti̠y a̠má kahuasa; xlacán chiné tahuá­nilh: —Ko̠tán, ma̠x cumu ca̠maktum hora xuani̠t acxni̠ mák­xtekli lhcúya̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Amá chixcú na̠ laca­pá̠s­tacli pi̠ hua­tiyá a̠má hora acxni̠ Jesús huá­nilh: “Min­ka­huasa aya tatla̠nti̠ni̠t.” Y a̠má chixcú li̠pá̠­hualh Jesús xa̠hua xli̠­pu̠tum hua̠nti̠ xalac xchic na̠ tali̠­ca̠­naj­lá­nilh caj xpa̠­la­cata hua̠ntu̠ tlá­hualh. ");
INSERT INTO tocNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Pus huá chú eé xliaktiy lac­lanca li̠cá̠cni̠t xta­scújut hua̠ntu̠ tlá­hualh Jesús acxni̠ qui̠­ta­lák­spitli nac Judea y chimpá nac Gali­lea. ");
INSERT INTO tocNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ni̠ li̠maka̠s quilh­ta­macú a̠ma̠ko̠lh judíos tat­la­huapá aktum pa̠xcua nac Jeru­salén y Jesús na̠ alh nac pa̠xcua. ");
INSERT INTO tocNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nac lacatum má̠lacchi anta­nícu xlac­ta­nu̠cán nac a̠má ca̠chi­quí̠n xuanicán Puerta de las Ovejas, antá lacatzú xuí aktum musni nac xata­chu­huí̠n hebreo xuanicán Betzata, y antaní xlac­ta­nu̠cán kan­qui­tzis arco hua̠ntu̠ li̠huana̠ xlak­chi­pa­ya̠­huani̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Antá nac xtampí̠n xta­má̠­nalh lhu̠hua cris­tianos hua̠nti̠ xta­ka­lhi̠y la̠tachá túcuya̠ tajátat: hui̠nti̠ laka­tzí̠n, maka­pi­tzí̠n ni̠lay xtat­la̠­huán y na̠chuná hua̠nti̠ xta­lac­lu̠n­tu̠­hua­nani̠t; xlacán xta­ka­lhi̠­má̠­nalh acxni̠ nata­nan­katla chú­chut. ");
INSERT INTO tocNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Porque huancán pi̠ mat ni̠ xma­ka̠sni xta̠c­ta­ya̠chi cha̠tum ángel nac a̠má musni y xlak­nan­katla chú­chut y huá chú ti̠ pu̠lh nata­ju̠­ya̠chá nac chú­chut pálaj tuncán natat­la̠nti̠y ma̠squi la̠tachá túcuya̠ tajátat xka­lhi̠y. ");
INSERT INTO tocNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Pus antá xuí cha̠tum chixcú xlá aya xle̠ma xli̠­pu­xa­ma­cu̠­tzayán ca̠ta la̠ta xta̠­tatlay. ");
INSERT INTO tocNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Acxni̠ úcxilhli Jesús pi̠ antá xmá a̠má chixcú y cátzi̠lh pi̠ maka̠sá quilh­ta­macú la̠ta xlá xpa̠­ti̠ma, pus huá chiné li̠ka­lhás­quilh: —¿Lácu pi̠ tat­la̠n­ti̠­pu­tuna? ");
INSERT INTO tocNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Amá ta̠tatlá kalh­tí̠­nalh: —Pero ni̠ti̠ hua̠nti̠ naqui­maju̠y nac musni acxni̠ tanan­katla chú­chut. La̠ta maka­tunu cta­ju̠­putún túnuj tuncán hua̠nti̠ taju̠­paray. ");
INSERT INTO tocNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Pero Jesús huá­nilh: —Cata̠qui, casacti mix­tícat y cat­lá̠­huanti. ");
INSERT INTO tocNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Acxni tuncán a̠má chixcú tat­lá̠n­ti̠lh la̠li̠­huán, sacli xpu̠­tama y tzú­culh tla̠­huán. Pero cumu sábado xuani̠t a̠má quilh­ta­macú xli̠­huancán para tícu nas­cuja, ");
INSERT INTO tocNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","y nac tiji maka­pi­tzí̠n judíos hua̠nti̠ taúcxilhli pi̠ xcu­cani̠t cxtícat chiné tahuá­nilh: —La̠nchú eé quilh­ta­macú caj luu jaxcán y ni̠ mili̠­cúcat mix­tícat. ");
INSERT INTO tocNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Pero a̠má chixcú chiné ca̠kálh­ti̠lh: —Hua̠nti̠ qui­ma̠t­lá̠n­ti̠lh qui­huá­nilh: “Casacti mix­tícat y cat­lá̠­huanti.” ");
INSERT INTO tocNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Xlacán taka­lhas­quimpá: —¿Tícu a̠má chixcú hua̠nti̠ huanín: “Casacti mix­tícat y catlá̠huanti”? ");
INSERT INTO tocNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Cumu a̠má chixcú ni̠ xca­tzi̠y tícu xma̠t­la̠n­ti̠ni̠t, porque Jesús xca̠­lak­sti̠­pa̠­ta­nu̠ni̠t anta­nícu luu lhu̠hua xta­la­yá̠­nalh cris­tianos, ni̠tu̠ kalh­tí̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Aca­li̠stá̠n Jesús ma̠nok­lhuchá nac lanca pu̠si­culan y chiné huá­nilh: —Chú luu tla̠n cumu aya tat­la̠n­ti̠­ni̠ta, pero chú niaj cat­lahua tala̠­ka­lhí̠n cumu la̠ xtla­huaya xapu̠lh la̠qui̠ niaj nachi­payá̠n a̠má luu a̠tzinú xali̠­pe̠­cuánit tajátat. ");
INSERT INTO tocNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Cumu a̠má chixcú aya xca­tzi̠y tícuya̠ chixcú hua̠nti̠ xma̠t­la̠n­ti̠ni̠t huata xlá la̠li̠­huán alh ca̠huaniy xana­puxcun judíos pi̠ huá Jesús xuanicán a̠má chixcú hua̠nti̠ xma̠t­la̠n­ti̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Caj huá xpa̠­la­cata a̠ma̠ko̠lh ma̠pek­si̠­naní̠n judíos xta­pu­tza­má̠­nalh Jesús xta­mak­ni̠­putún cumu xlá xca̠t­la­huay lac­lanca li̠cá̠cni̠t ta­scújut acxni̠ xlak­cha̠ni̠t quilh­ta­macú sábado y ni̠tícu scuja. ");
INSERT INTO tocNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero para tícu xka­lhas­quín Jesús túcu xla­cata chuná xtla­huay, chiné xkalhti̠y: —Dios hua̠nti̠ luu xli̠­ca̠na Quin­tla̠t, anka­lhi̠ná scujma y ni̠para aktum quilh­ta­macú jaxa, y na̠chuná chú aquit anka­lhi̠ná cscujma. ");
INSERT INTO tocNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Huá xla­cata a̠ma̠ko̠lh judíos luu xta­li̠­mak­ni̠­putún, ni̠ caj cumu para ni̠ xca̠c­ni̠­naniy a̠má quilh­ta­macú acxni̠ jaxcán, sinoque porque xlá na̠ luu Dios xli̠­ta­pu̠lhca̠y acxni̠ xuan pi̠ huá luu xtla̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesús na̠ chiné ca̠huá­nilh a̠ma̠ko̠lh xana­puxcun judíos: —Xli̠­cána aquit Xka­huasa Dios y luu laca­tancs cca̠­hua­niyá̠n pi̠ ni̠lay túcu ctla­huay hua̠ntu̠ caj que̠cstu qui­la­cata, huata caj xma̠nhuá ctla­huay hua̠ntu̠ cuc­xilha tla­huay Dios porque huá quin­tla̠t. Xli̠­hua̠k hua̠ntu̠ tla­huay Dios, cumu aquit Xka­huasa, pus na̠ huá ctla­huay. ");
INSERT INTO tocNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Dios luu xli̠­ca̠na quim­pa̠x­qui̠y porque aquit Xka­huasa y qui­ma̠­si­yuniy la̠ta túcu xlá tla­huama, y naquin­ti­ma̠­si­yu­niycú a̠tzinú tlak lac­lanca ta­scújut hua̠ntu̠ aquit nac­tla­huay y hui­xinín luu naca̠­ma­ke̠k­lhayá̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Pus chuná cumu la̠ Dios ca̠ma̠­laca­stac­uani̠y ni̠n y ca̠ma̠x­qui̠y latáma̠t, pus na̠chuná chú aquit na̠ nac­ma̠x­qui̠y latáma̠t hua̠nti̠ aquit nac­ma̠x­qui̠­putún. ");
INSERT INTO tocNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Dios quin­tla̠t ni̠ti̠ ma̠xo­ko̠ni̠y xta­la̠­ka­lhí̠n sino aquit Xka­huasa qui­ma̠x­qui̠ni̠t li̠ma̠­peksí̠n xla­cata aquit nac­ca̠s­quiniy cuentaj xpa̠­la­cata xta­la̠­ka­lhi̠ncán cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Y cumu chuná lac­lhca̠­hui­li̠ni̠t xla­cata xli̠­pacs cris­tianos naquin­ta­ca̠c­ni̠­naniy aquit Xka­huasa cumu la̠ ca̠c­ni̠­na­nicán Dios hua̠nti̠ luu quin­tla̠t, hua̠nti̠ ni̠ quin­ca̠c­ni̠­naniy aquit Xka­huasa Dios na̠ ni̠ xli̠­ca̠na ca̠c­ni̠­na­nima quin­tla̠t hua̠nti̠ qui­ma̠­la­ka­cha̠ni̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ hua̠nti̠ quin­kax­matniy hua̠ntu̠ cliakchu­hui̠­nama y na̠chuna li̠túm chú li̠pa̠­huán hua̠nti̠ qui­ma̠­la­ka­cha̠ni̠t, xlá mak­lhti̠nán latáma̠t xasa̠sti hua̠ntu̠ anka­lhi̠ná cahuá naka­lhi̠y, y niaj ne̠cxni cati­ma̠­pa̠­ti̠­ni̠ca xpa̠­la­cata xta­la̠­ka­lhí̠n, pus xlá ti̠tax­tuni̠t nac xatiji ca̠li̠ní̠n y aya tzu­cuni̠t chú lac­tla̠­huán nac xatiji latáma̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ lak­cha̠ma quilh­ta­macú y la̠n­chujá aya lak­cha̠ni̠t acxni̠ a̠ma̠ko̠lh hua̠nti̠ aya tani̠ni̠t nata­kax­mata xta­chu­huí̠n Xka­huasa Dios, y hua̠nti̠ nata­kax­matniy hua̠ntu̠ xlá nahuán nata­ka­lhi̠y latáma̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Porque chuná cumu la̠ Quin­tla̠t Dios sacstu kalhi̠y li̠t­li­hueke xlá ma̠sta̠y látama̠t porque lanca xla­ca­tzúcut, pus na̠chuná chú cumu aquit Xka­huasa qui­ma̠x­qui̠ni̠t li̠t­li­hueke la̠qui̠ nac­ma̠sta̠y eé latáma̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na̠chu­na­li̠túm qui­ma̠x­qui̠ni̠t a̠má li̠t­li­hueke la̠qui̠ aquit nac­ca̠­ta̠t­la­huay taxokó̠n cris­tianos caj xpa̠­la­cata xta­la̠­ka­lhi̠ncán, porque aquit xli̠­ca̠na Xata­lac­sacni Chixcú. ");
INSERT INTO tocNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ni̠ cali̠­li̠­pu­huántit caj xpa̠­la­cata hua̠ntu̠ cca̠­hua­nimá̠n, porque luu xli̠­ca̠na ámaj lak­chá̠n quilh­ta­macú acxni̠ xli̠­pu̠tum ni̠n naquin­ta­kax­matniy quin­ta­chu­huí̠n, ");
INSERT INTO tocNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","y cha̠­tunu cha̠­tunu nata­ta̠c­xtu­ya̠chi anta­nícu xca̠­ma̠c­nu̠­cani̠t. Hua̠nti̠ tla̠n xuani̠t xta­pu­hua̠ncán nata­la­cas­ta­cuanán nac ca̠li̠ní̠n la̠qui̠ nata­ka­lhi̠y li̠pa̠­xúhu latáma̠t, pero hua̠nti̠ luu ni̠tlá̠n xta­pu­hua̠ncán xta­huani̠t xlacán nata­la­cas­ta­cuanán nac ca̠li̠ní̠n la̠qui̠ naca̠­ma̠­xo­ko̠­ni̠cán xli̠­hua̠k hua̠ntu̠ ni̠tlá̠n tatit­la­huani̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Aquit ni̠lay túcu ctla­huay hua̠ntu̠ caj que̠cstu qui­la­cata, huata acxni̠ aquit cca̠­pu­tza̠­naniy cris­tianos hua̠ntu̠ ni̠tlá̠n tat­la­huani̠t luu xta­lu­lóktat quin­ta­pu­tzá̠n porque chuná ctla­huay cumu la̠ qui­li̠­ma̠­pek­si̠ni̠t Quin­tla̠t hua̠nti̠ qui­ma­ca­mini̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Pus para aquit caj que̠cstu xac­ta­lán­qui̠lh nac xla­catí̠n cris­tianos, luu laca­tancs pi̠ ni̠tu̠ xli̠­macua quin­ta­chu­huí̠n y tla̠n ni̠ xca̠­naj­látit. ");
INSERT INTO tocNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero huí cha̠tum hua̠nti̠ qui­ma̠­lan­qui̠y y quin­ta̠­ta̠yay y aquit sta­lanca cca­tzi̠y pi̠ hua̠ntu̠ xlá huan caj quim­pa̠­la­cata li̠ca̠­nájlat porque xli̠­ca̠na. ");
INSERT INTO tocNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Hui­xinín qui̠­ma̠­ka­lhas­qui­ni̠­nántit Juan Bau­tista caj quim­pa̠­la­cata y hua̠ntu̠ xlá kalh­ti̠­nanchá luu laca­tancs. ");
INSERT INTO tocNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pero aquit ni̠ cli̠­lacá̠n para túcu nahuán cha̠tum chixcú caj qui­la­cata, osuchí para túcu nama̠­siyuy; huata aquit caj cca̠­ma̠­la­ca­pa̠s­ta­camá̠n Juan la̠qui̠ tla̠n naqui­la̠­li̠­pa̠­hua­ná̠hu y nama̠aka­pu̠­tax­ti̠­yá̠tit mili̠s­tac­nicán. ");
INSERT INTO tocNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Amá xta­chu­huí̠n Juan Bau­tista li̠táx­tulh cumu la̠ li̠maksko la̠qui̠ xlá naca̠­mak­sko­niyá̠n, y hui­xinín luu aktum tapa̠­xu­huá̠n maka­mak­lhti̠­nántit xtax­káket, pero ni̠ luu maka̠s quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Juan má̠s­ta̠lh talu­lóktat xla­cata pi̠ Dios qui­ma­ca­mini̠t pero hui­lapá chú hua̠ntu̠ a̠tzinú naca̠­ma̠­lu­lok­niyá̠n ni̠ xachuná xta­chu­huí̠n Juan, pus huá cuanima a̠má quin­ta­scújut hua̠ntu̠ aquit cca̠t­la­huay. Pus pu̠tum eé hua̠k hua­tiyá hua̠ntu̠ qui­li̠­ma̠s­cu­juni̠t Quin­tla̠t la̠qui̠ nac­ma̠­kan­taxti̠y, pus caj eé ta­scújut xli̠­ca̠na li̠ta­siyuy pi̠ huá Quin­tla̠t Dios qui­ma­ca­mini̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Y na̠chuna li̠túm hua­tiyá a̠má Quin­tla̠t hua̠nti̠ qui­ma­ca­mini̠t aya ma̠s­ta̠ni̠t talu­lóktat caj qui­la­cata, ma̠squi chá hui­xinín ne̠cxni a̠ kax­pa­tá̠tit xta­chu­huí̠n y ni̠para maktum a̠ ucxi­lhá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Pero huá li̠lay cumu xta­chu­huí̠n nia̠ cha̠n nac mina­cujcán, y porque ni̠ qui­la̠­ca̠­naj­la­ni­yá̠hu pi̠ xli̠­ca̠na huá Quin­tla̠t Dios y huá qui­ma­ca­mini̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Hui­xinín luu anka­lhi̠ná li̠huana̠ li̠kalh­ta­hua­ka­yá̠tit xta­chu­huí̠n Dios hua̠ntu̠ tatzok­ta­hui­lani̠t nac li̠kalh­ta­huaka porque hui­xinín lac­pu­hua­ná̠tit pi̠ antá tla̠n namac­la­yá̠tit xlak­táxtut mili̠s­tac­nicán, pero ni̠lay aka­ta̠k­sá̠tit pi̠ aquit a̠má hua̠nti̠ li̠chu­hui̠­nama xta­chu­huí̠n Dios hua̠nti̠ naca̠­ma̠x­qui̠yá̠n hua̠ntu̠ putza­pá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Huá chú xpa̠­la­cata hui­xinín ni̠ qui­la̠­lak­ta­la­ca­tzu­hui̠­pu­tu­ná̠hu la̠qui̠ naka­lhi̠­yá̠tit a̠má lak­táxtut nac mili̠s­tac­nicán. ");
INSERT INTO tocNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Aquit ni̠ cpu­tzay para tícu xqui­huá­nilh pi̠ xli̠­ca̠na qui­li̠­pa̠­huán, ");
INSERT INTO tocNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","porque aquit cca̠­la­ka­pasá̠n y cca­tzi̠y pi̠ ni̠ kalhi̠­yá̠tit xta­pá̠x­qui̠t Dios nac mina­cujcán. ");
INSERT INTO tocNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Aquit cmi­ni̠­tanchá nac xpa̠xtú̠n Quin­tla̠t la̠qui̠ chuná tla̠n nac­li̠­chu­hui̠nán xta­chu­huí̠n, pero huata hui­xinín ni̠ qui­la̠­li̠­pa̠­hua­ná̠hu; pero para tícu xca̠­lakmín hua̠nti̠ caj sacstu xli̠­chu­hui̠­nánca huata huá luu pála xca̠­naj­la­nítit y xmaka­maklhti̠­nántit. ");
INSERT INTO tocNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Hui­xinín luu laka­ti̠­yá̠tit para tícu naca̠­ma̠t­la̠n­ti̠­niyá̠n hua̠ntu̠ tla­hua­pá̠tit, pero ni̠para tzinú lac­pu­tza­yá̠tit lácu nalak­tzak­sa­yá̠tit xta­péksi̠t Dios. Hui­xinín ni̠lay ca̠naj­la­yá̠tit quin­ta­chu­huí̠n porque caj luu xma̠nhuá putza­pá̠tit hua̠ntu̠ cca̠­hua­nimá̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Pero ni̠ calac­pu­huántit para aquit nac­ca̠­ma̠­la­ca­pu̠yá̠n nac xla­catí̠n Dios, huí xlá tunu hua̠nti̠ chuná nat­la­huay, huá Moisés porque hui­xinín hua­ná̠tit pi̠ huá li̠pa̠­hua­ná̠tit xta­chu­huí̠n pero ni̠ xli̠­ca̠na. ");
INSERT INTO tocNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Pus para xli̠­ca̠na hui­xinín xca̠­naj­látit hua̠ntu̠ Moisés tichu­huí̠­nalh y títzokli nac xlibro, na̠ xqui­la̠­ca̠­naj­la­níhu aquit, porque nac xlibro chuná tzokli la̠ta lácu aquit xacámaj latama̠y. ");
INSERT INTO tocNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pero cumu ni̠ luu xli̠­ca̠na ca̠naj­la­yá̠tit hua̠ntu̠ xlá tzokni̠t, ¿pi̠ li̠huaca chú naca̠­naj­la­yá̠tit hua̠ntu̠ aquit cca̠­hua­nimá̠n? ");
INSERT INTO tocNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Aca­li̠stá̠n Jesús alh a̠li̠quilh­tu̠tu pupunú xalac Gali­lea, osuchí xalac Tibe­rías porque hui̠ntí chuná xta­li̠­ma̠­pa̠­cu­hui̠y. ");
INSERT INTO tocNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","3","Y acxni̠ antá cha̠lh tala­ca̠c­xtu­táhui nac aktum ke̠stí̠n y antá culucs ca̠ta̠­táhui xdis­cí­pulos. Pero anta­nícu xan Jesús luu lhu̠hua cris­tianos xta­sta̠­laniy porque xta­la­kati̠y xtaucxilha lac­lanca xta­scújut hua̠ntu̠ xlá xca̠­li̠­ma̠­la­ca­hua̠ni̠y acxni̠ xca̠­ma̠t­la̠nti̠y ta̠tat­laní̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Xa̠huachí niaj luu maka̠s quilh­ta­macú xtzanka̠y la̠ta nalak­chá̠n xpa̠x­cuajcán judíos xla taak­spun­tza̠lí̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Huata acxni̠ Jesús ca̠lak­lá­ca̠lh úcxilhli pi̠ luu lhu̠hua cris­tianos xta­ta­la­ca­tzu­hui̠­má̠­nalh anta­nícu xlá xuí. Entonces chiné huá­nilh Felipe: —Felipe, ¿nícu nata­ma̠­hua­yá̠hu lhu̠hua cax­ti­lá̠n­chahu la̠qui̠ naca̠­ta̠­hua̠­ya­ná̠hu pu̠tum u̠ma̠ko̠lh cris­tianos? ");
INSERT INTO tocNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesús caj chu­natá huá­nilh la̠qui̠ naliucxilha lácu xlá nahuán, porque xlá luu laca­tancs xca­tzi̠yá hua̠ntu̠ xámaj tla­huay. ");
INSERT INTO tocNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe chiné kálh­ti̠lh: —Ma̠squi luu aktiy ciento denario tumi̠n xli̠­ta­ma̠­huáhu cax­ti­lá̠n­chahu ni̠ catiáccha̠lh la̠qui̠ naca̠­li̠­ma̠­hui̠­yá̠hu pu̠tum u̠ma̠ko̠lh cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Cha̠­tum­li̠túm xdis­cí­pulo xuanicán Andrés xta̠Simón chiné huá­nilh: ");
INSERT INTO tocNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Uú na̠ mini̠t cha̠tum kahuasa, xlá li̠mín mac­qui­tzis cax­ti­lá̠n­chahu xa̠hua tantiy squi̠ti, pero ¿túcu chú nata­liucxilha pu̠tum u̠ma̠ko̠lh cris­tianos? ");
INSERT INTO tocNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Pero Jesús chiné ca̠huá­nilh: —Caca̠­hua­nítit a̠ma̠ko̠lh cris­tianos la̠qui̠ hua̠k nata­ta­huilay. Cumu nac a̠má ke̠stí̠n la̠n xuí li̠cúxtut antá tatáhui ma̠x cumu akqui­tzis mi̠lh cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesús ca̠chí­palh cax­ti­lá̠n­chahu, pa̠x­cat­ca­tzí̠­nilh Dios, lak­ché­kelh, y ca̠má̠x­qui̠lh xdis­cí­pulos la̠qui̠ xlacán naca̠­ma̠akpi­tziniy xli̠­pu̠tum cris­tianos hua̠nti̠ antá xta­hui­lá̠­nalh. Y na̠chuna li̠túm ca̠t­lá­hualh a̠ma̠ko̠lh tantiy squi̠ti, y hua̠k ca̠ma̠x­quí̠­calh la̠ta lácua xlacán tahua­pú­tulh. ");
INSERT INTO tocNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Acxni̠ aya la̠n xta­kasni̠t, Jesús chiné ca̠huá­nilh xta­ma̠­kalh­ta­huaké̠n: —Chú cama̠­mac­xtu­pí̠tit cax­ti­lá̠n­chahu hua̠ntu̠ aka­tá̠x­tulh la̠qui̠ ni̠túcu nalak­tzanka̠y. ");
INSERT INTO tocNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Xlacán tama̠­mac­xtú­mi̠lh y tama̠­tzá­malh pa̠cu̠tiy canasta xata­lak­che­ke­tamá̠n cax­ti­lá̠n­chahu. ");
INSERT INTO tocNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Xli̠­hua̠k cris­tianos acxni̠ taúcxilhli eé lanca li̠cá̠cni̠t ta­scújut hua̠ntu̠ Jesús tlá­hualh, chiné taquilh­tzú­culh: —Xli̠­ca̠na huá eé pro­feta hua̠nti̠ xli̠­mínit xuani̠t nac ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pero cumu Jesús cátzi̠lh hua̠ntu̠ xlacán tze̠k xta­qui­lhuamá̠­nalh xla­cata natalé̠n a̠li̠fuerza la̠qui̠ xreycán natat­la­huay hua̠nti̠ naca̠­pux­culé̠n huata mejor xlá tatam­pu̠x­tupá y sacstu tala­ca̠c­xtupá a̠tzinú xata̠lhmá̠n a̠má ke̠stí̠n la̠qui̠ ni̠tícu nama̠aka­tzanke̠y. ");
INSERT INTO tocNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Acxni̠ aya tzú­culh ca̠s­ma­lankán, xdis­cí­pulos Jesús tata­ka­lhu̠­ta­hui­lachi nac xquilhtú̠n pupunú. Pero cumu chú aya xca̠­puc­suani̠t y Jesús ni̠naj a̠ xqui̠­tas­pita, huata xlacán tatá­ju̠lh nac aktum barco y tzú­culh tama̠t­la̠­huani̠y la̠qui̠ antá nata­chá̠n nac Caper­naum. ");
INSERT INTO tocNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Pero ni̠para maka̠s tzú­culh u̠nún y li̠pe̠cua tzú­culh ta̠ke­ya̠­huay pupunú. ");
INSERT INTO tocNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ma̠x aya xtaani̠ttá cumu akqui­tzis osuchí akcha̠xán kiló­metro acxni̠ taúcxilhli pi̠ Jesús xlak­ta­la­ca­tzu­hui̠ma barco xlá xkalh­tla̠­huan­ti̠­lhay pupunú; huata xdis­cí­pulos ni̠ xta­la­ka­pas­má̠­nalh y luu la̠n tape̠­cuáxni̠lh. ");
INSERT INTO tocNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pero xlá chiné ca̠huá­nilh: —¡Ni̠ cape̠­cuántit, porque aquit Jesús taca­ma̠chá! ");
INSERT INTO tocNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Xlacán taká­lhi̠lh li̠ca­mama y tata̠­tá­ju̠lh nac barco; luu acxni­tiyá aya tácha̠lh anta­nícu xtaamá̠­nalh. ");
INSERT INTO tocNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Li̠cha̠lí laca­tzi̠sa, a̠ma̠ko̠lh cris­tianos hua̠nti̠ xta­ta­mak­xtek­ni̠­tanchá a̠li̠quilh­tu̠tu pupunú xta­ca­tzi̠y pi̠ xdis­cí­pulos xta­pu̠ani̠t xma̠n hua̠ntu̠ xuí aktum barco pero na̠ xta­ca­tzi̠y pi̠ Jesús ni̠ xca̠­ta̠ani̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ma̠squi aca­li̠stá̠n túnuj barco antá taminchá nac aktum ca̠chi­quí̠n hua­nicán Tibe­rías y antá xta­hui­lá̠na nac chú­chut lacatzú antaní Jesús xma̠­lhu̠­hui̠nít cax­ti­lá̠n­chahu acxni̠ pu̠lh pa̠x­cat­ca­tzí̠­nilh Dios a̠má xtahuá. ");
INSERT INTO tocNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Acxni̠ a̠ma̠ko̠lh cris­tianos taúcxilhli pi̠ ni̠ti̠ xlama antá Jesús ni̠para xdis­cí­pulos, huata la̠li̠­huán tatá­ju̠lh nac barco y táalh tapu­tzay nac Caper­naum. ");
INSERT INTO tocNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Acxni̠ xlacán tácha̠lh a̠li̠quilh­tu̠án pupunú antá tama̠­nók­lhulh Jesús y chiné taka­lhás­quilh: —Ma̠kalh­ta­hua­ke̠ná, ¿níco̠cxni chitá uú? ");
INSERT INTO tocNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús ca̠kálh­ti̠lh: —Li̠huana̠ cakax­páttit hua̠ntu̠ nac­ca̠­hua­niyá̠n: hui­xinín qui­la̠­pu­tza­ma̠­náhu porque ko̠tán la̠n hua̠­yántit y la̠n kástit, pero ni̠ huá qui­la̠­li̠­pu­tza­ma̠­náhu la̠qui̠ naqui­la̠­li̠­pa̠­hua­ná̠hu acxni̠ úcxi­lhá̠tit cca̠t­la­huay lac­lanca quin­ta­scújut. ");
INSERT INTO tocNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ni̠ caj luu huá cali̠s­cuj­ta­ma­kántit xtahuá mimac­nicán hua̠ntu̠ lak­sputa, huata mejor huá cali̠s­cújtit xtahuá mili̠s­tac­nicán hua̠ntu̠ ne̠cxni lak­sputa la̠qui̠ chuná nali̠­la­ta­pa̠­yá̠tit cxpa̠xtú̠n Dios cane̠c­xni­cahuá quilh­ta­macú. Aquit Xata­lac­sacni Chixcú tla̠n nac­ma̠x­qui̠yá̠n a̠má tahuá, porque Quin­tla̠t Dios luu caj huá qui­li̠­lac­sacni̠t la̠qui̠ chuná nac­ca̠­ma̠x­qui̠yá̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Xlacán chiné taka­lhás­quilh: —¿Túcu qui­li̠t­la­huatcán la̠qui̠ nac­ma̠­kan­tax­ti̠­yá̠hu hua̠ntu̠ Dios lacas­quín nac­tla­hua­yá̠hu? ");
INSERT INTO tocNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús ca̠kálh­ti̠lh: —Hua̠ntu̠ xlá lacas­quín Dios nat­la­hua­yá̠tit, caj xma̠n caca̠­naj­la­nítit hua̠nti̠ xlá maca­mini̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Pero xlacán taka­lhas­quimpá: —¿Túcuya̠ li̠cá̠cni̠t ta­scújut nat­la­huaya la̠quí nac­li̠ucxi­lhá̠hu pi̠ xli̠­ca̠na Dios maca­mi­ni̠tán, y la̠qui̠ chuná tla̠n nac­ca̠­ca̠­naj­la­niyá̠n? ¿Lácu pi̠ tla̠n maca­ta̠x­tuca a̠má lac­lanca ta­scújut hua̠ntu̠ tit­lá­hualh Moisés? ");
INSERT INTO tocNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Porque xalak­maká̠n qui­li̠­ta­la­ka­pas­nicán titá­hualh a̠má tahuá hua­nicán maná antá nac desierto chuná cumu la̠ tatzokni̠t nac li̠kalh­ta­huaka: “Dios ca̠má̠x­qui̠lh la̠qui̠ nata­huay cax­ti­lá̠n­chahu xalac akapú̠n.” ");
INSERT INTO tocNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús chiné ca̠kálh­ti̠lh: —Luu xli̠­ca̠na tancs cca̠­hua­niyá̠n pi̠ ni̠ huá Moisés ca̠ma̠x­quí̠n a̠má cax­ti­lá̠n­chahu xalac akapú̠n, huá Quin­tla̠t xuani̠t, y huata huá Quin­tla̠t hua̠nti̠ tla̠n naca̠­ma̠x­qui̠yá̠n hua̠ntu̠ luu xax­li̠­ca̠na cax­ti­lá̠n­chahu xalac akapú̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Porque a̠má cax­ti­lá̠n­chahu hua̠ntu̠ Dios ma̠sta̠y pus huá a̠má hua̠nti̠ ta̠c­ta­ni̠­tanchi nac akapú̠n la̠qui̠ naca̠­ma̠x­qui̠y latáma̠t cris­tianos hua̠ntu̠ ne̠cxni lak­sputa. ");
INSERT INTO tocNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ama̠­ko̠lh lac­chix­cu­huí̠n chiné tahuá­nilh: —Quim­pu̠­chi­nacán, cat­lahua li̠tlá̠n xlianka­lhi̠ná caqui­la̠­ma̠x­quí̠hu a̠má cax­ti­lá̠n­chahu. ");
INSERT INTO tocNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús chiné ca̠huá­nilh: —Aquit a̠má cax­ti­lá̠n­chahu hua̠ntu̠ ma̠sta̠y xax­li̠­ca̠na latáma̠t. Amá cris­tiano hua̠nti̠ qui­lakmín y qui­li̠­hua̠yán, niaj ne̠cxni catí­tzin­csli, y hua̠nti̠ luu quin­ca̠­naj­laniy niaj ne̠cxni cati­kalh­pú̠­ti̠lh. ");
INSERT INTO tocNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero cumu chuná la̠ cca̠­hua­niná, hui­xinín ni̠ qui­la̠­ca̠­naj­la­ni­pu­tu­ná̠hu ma̠squi aya ucxilh­ni̠­tátit hua̠ntu̠ aquit ctla­huay. ");
INSERT INTO tocNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","La̠ta xli̠­hua̠k cris­tianos hua̠nti̠ qui­ma̠x­qui̠ni̠t Quin­tla̠t la̠qui̠ naquin­ta­li̠­pa̠­huán hua̠k quin­ta­lak­chín la̠qui̠ anka­lhi̠ná naquin­ta­sta̠­laniy; y la̠tachá tícu aquit naquin­ta­lakmín ni̠ cac­ti­lak­má­kalh. ");
INSERT INTO tocNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Xa̠huachí aquit cmini̠t nac ca̠quilh­ta­macú la̠qui̠ nac­tla­huaniy xta­pa̠­xu­huá̠n Quin­tla̠t hua̠nti̠ qui­ma­ca­mini̠t, y ni̠ caj huá cli̠­mini̠t la̠qui̠ nac­tla­huay hua̠ntu̠ caj que̠cstu quin­ta­pa̠­xu­huá̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Hua̠ntu̠ xlá xta­pa̠­xu­huá̠n Quin­tla̠t hua̠nti̠ qui­ma­ca­mini̠t, xlá lacas­quín li̠huana̠ nac­ca̠­mak­ta­kalha la̠qui̠ ni̠para cha̠tum nalak­tzanka̠y hua̠nti̠ xlá qui­ma­ca­ma̠x­qui̠ni̠t naqui­li̠­pa̠­huán, la̠qui̠ acxni̠ nalak­chá̠n quilh­ta­macú la̠ta xlá lac­lhca̠­hui­li̠ni̠t aquit hua̠k nac­ca̠­ma̠­laca­stac­uani̠y nac ca̠li̠ní̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Pus xli̠­ca̠na huá luu xta­pa̠­xu­huá̠n Quin­tla̠t pi̠ xli̠­hua̠k la̠ta tícu naquin­ta­kax­matniy y naquin­ta­ca̠­naj­laniy pi̠ aquit Xka­huasa, nata­ka­lhi̠y li̠pa̠­xúhu latáma̠t cane̠c­xni­cahuá quilh­ta­macú y huá xlacán hua̠nti̠ nac­ca̠­ma̠­laca­stac­uani̠y acxni̠ nalak­chá̠n a̠huatá quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Acxni̠ a̠ma̠ko̠lh judíos takax­mat­ko̠lh eé tachu­huí̠n tzú­culh taaksán Jesús porque xlá chiné huá: “Aquit a̠má cax­ti­lá̠n­chahu hua̠ntu̠ ta̠c­ta­ni̠­tanchi nac akapú̠n.” ");
INSERT INTO tocNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Xlacán chiné táhua: —¿Lácu pi̠ ni̠ huá eé Jesús xka­huasa José? Pus aquinín cla­ka­pa­sá̠hu xtzí chu xtla̠t. ¿Lácu chi̠nchú li̠huán para antá mini̠­tanchá nac akapú̠n? ");
INSERT INTO tocNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesús chiné ca̠huá­nilh: —Luu xli̠­ca̠na niaj cali̠­taaklhu̠­huí̠tit quin­ta­chu­huí̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Porque ni̠para cha̠tum cris­tiano tla̠n natzu­cu­putún quin­ta­li̠­pa̠­huán para ni̠ pu̠lh huá nama̠­lac­pu­hua̠ni̠y Quin­tla̠t hua̠nti̠ qui­ma­ca­mini̠t. Y hua̠nti̠ naquin­ta­li̠­pa̠­huán, xlacán ma̠squi natani̠y aquit nac­ca̠­ma̠­laca­stac­uani̠y acxni̠ nalak­chá̠n a̠huatá quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Lacatum nac li̠kalh­ta­huaka hua̠ntu̠ tatzokni̠t pro­fetas chiné huan: “Xli̠­hua̠k cris­tianos Dios naca̠­ma̠­si­yuniy xta­la­ca­pa̠s­tacni.” Eé tachu­huí̠n huam­putún pi̠ xli̠­hua̠k hua̠nti̠ takax­matniy Quin­tla̠t hua̠ntu̠ xlá ca̠hua­nima y antá nacha̠n nac xna­cujcán a̠má tachu­huí̠n, pus huá chú xlacán naquin­ta­li̠­pa̠­huán. ");
INSERT INTO tocNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Pero ni̠ huá huam­putún para tícu ucxilhni̠t Dios; huata caj xma̠n aquit cuc­xilhni̠t porque huá xlá qui­ma̠­la­ka­cha̠ni̠t uú y antá aquit cmi­ni̠­tanchá nac xpa̠xtú̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Xli̠­cána cca̠­hua­niyá̠n pi̠ hua̠nti̠ quin­ca̠­naj­laniy, xlá aya kalhi̠y a̠má li̠pa̠­xúhu latáma̠t hua̠ntu̠ ne̠cxni nalak­sputa. ");
INSERT INTO tocNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Porque aquit a̠má cax­ti­lá̠n­chahu hua̠ntu̠ ma̠sta̠y latáma̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Xalak­maká̠n mili̠­ta­la­ka­pas­nicán tahuani̠t a̠má cax­ti­lá̠n­chahu hua­nicán maná antá nac desierto, pero ma̠squi chuná juerza táni̠lh. ");
INSERT INTO tocNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pero ni̠chuná a̠má cax­ti­lá̠n­chahu hua̠ntu̠ cli̠­chu­hui̠­nama, xlá ta̠c­ta­ni̠­tanchi nac akapú̠n y hua̠nti̠ nahuay niaj ne̠cxni catí­ni̠lh. ");
INSERT INTO tocNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Pus aya cca̠­huanín pi̠ aquit a̠má cax­ti­lá̠n­chahu hua̠ntu̠ ta̠c­ta­ni̠­tanchi nac akapú̠n y ma̠sta̠y latáma̠t; hua̠nti̠ nahuay eé cax­ti­lá̠n­chahu cane̠c­xni­cahuá nala­tama̠y. Amá cax­ti­lá̠n­chahu hua̠ntu̠ aquit cca̠­ma̠­lac­nu̠­niyá̠n pus huata huá quin­ti­yat­li̠hua nac­ma̠sta̠y aquit nacni̠y xpa̠­la­ca­tacán cris­tianos xala ca̠quilh­ta­macú la̠qui̠ chuná nata­ka­lhi̠y latáma̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ama̠­ko̠lh judíos sac­stucán tzú­culh tala̠­li̠­ma̠aklhu̠­hui̠y y chiné tzú­culh tahuán: —¿Lácu chú nat­la­huay la̠qui̠ tla̠n naquin­ca̠­ma̠­hui̠yá̠n xti­yat­li̠hua? ");
INSERT INTO tocNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús chiné ca̠huá­nilh: —Luu xli̠­ca̠na cca̠­hua­niyá̠n pi̠ aquit Xata­lac­sacni Chixcú y para hui­xinín ni̠ nali̠­hua̠­ya­ná̠tit quin­ti­yat­li̠hua, y para ni̠ nali̠­kot­nu­ná̠tit quin­kalhni, ni̠ cati­ka­lhí̠tit a̠má latáma̠t hua̠ntu̠ cli̠­chu­hui̠nán. ");
INSERT INTO tocNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Hua̠nti̠ nahuay quin­ti­yat­li̠hua y nali̠­kotnún quin­kalhni naka­lhi̠y a̠má latáma̠t hua̠ntu̠ ne̠cxni nalak­sputa, y chuná aquit nac­ma̠­laca­stac­uani̠y acxni̠ nalak­chá̠n xli̠a̠huatá a̠má quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Porque huá quin­ti­yat­li̠hua luu xax­li̠­ca̠na tahuá y quin­kalhni luu xax­li̠­ca̠na li̠kot­nuncán. ");
INSERT INTO tocNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Hua̠nti̠ nali̠­hua̠yán quin­ti­yat­li̠hua y nali̠­kotnún quin­kalhni, xlá anka­lhí̠n quin­ta̠­lámaj nahuán y aquit na̠ antá nac­ta­huilay nac xnacú. ");
INSERT INTO tocNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Aquit luu tla̠n clama porque huá Quin­tla̠t hua̠nti̠ qui­ma­ca­mini̠t xas­tacná lama y xlá qui­ma̠x­qui̠y xli̠t­li­hueke, pus na̠chuná chú hua̠nti̠ naqui­li̠­hua̠yán y naqui­li̠­kasa aquit nac­ma̠x­qui̠y latáma̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Huá luu cca̠­hua­ni­pu­tuná̠n pi̠ aquit a̠má cax­ti­lá̠n­chahu hua̠ntu̠ ta̠c­ta­ni̠­tanchi nac akapú̠n. Eé cax­ti­lá̠n­chahu ni̠ xta̠­chuná cumu la̠ a̠má maná hua̠ntu̠ titá­hualh xalak­maká̠n mili̠­ta­la­ka­pas­nicán nac desierto, sa̠mpi̠ táni̠lh; pero hua̠nti̠ nahuay eé cax­ti­lá̠n­chahu cani̠c­xni­cahuá quilh­ta­macú nala­tama̠y. ");
INSERT INTO tocNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús chuná ca̠ma̠­kalh­chu­huí̠­ni̠lh a̠ma̠ko̠lh cris­tianos acxni̠ xta­nu̠ma nac xpu̠­si­cu­lancán judíos xalac Caper­naum. ");
INSERT INTO tocNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Acxni̠ takax­mat­ko̠lh hua̠ntu̠ ca̠hua­ní­calh, lhu̠hua cris­tianos hua̠nti̠ xta­sta̠­la­ni­putún Jesús chiné táhua: —Eé hua̠ntu̠ xlá qui­lhuama luu xli̠­ca̠na luu tuhua lacai̠cán, ¿tícu chá luu tla̠n nat­la­huaniy, y tícu chá luu nakax­matniy xta­chu­huí̠n? ");
INSERT INTO tocNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Pero cumu Jesús cátzi̠lh pi̠ xlacán xta­liaklhu̠­hua̠t­na­má̠­nalh a̠má tachu­huí̠n, hua̠ntu̠ xlá xca̠­hua­nini̠t y chiné ca̠ka­lhás­quilh: —Para u̠má hua̠ntu̠ cca̠­huanín ca̠ma̠aklhu̠­huí̠n, ");
INSERT INTO tocNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿lácu chú luu xqui̠­táx­tulh para xqui­la̠ucxi­lhui aquit Xata­lac­sacni Chixcú cta­la­ca̠c­xtu­ma̠pá cahuá nac akapú̠n anta­nícu pu̠lh xacuilachá? ");
INSERT INTO tocNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Xma̠nhuá xEspíritu Dios tla̠n naca̠­ma̠x­qui̠yá̠n a̠má xax­li̠­ca̠na latáma̠t; la̠ta xli̠­hua̠k min­ti­yat­li̠­huacán osuchí mili̠t­li­hue­kecán ni̠tu̠ li̠ma­cuán, pero la̠ta túcua aquit cca̠­hua­ni­ni̠tán hua̠k huá xta­la­ca­pa̠s­tacni xEspíritu Dios y chuná tla̠n ma̠sta̠y latáma̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero maka­pi­tzí̠n hui­xinín ni̠ ca̠naj­la­yá̠tit. Huá chuná Jesús ca̠li̠­huá­nilh porque xlá xca­tzi̠y tuncán hua̠nti̠ ni̠ xca̠­naj­laniy, y na̠chuná xca­tzi̠y hua̠nti̠ xámaj sta̠­huay. ");
INSERT INTO tocNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Aca­li̠stá̠n chiné huá: —Pus huá xpa̠­la­cata aquit cca̠­li̠­hua­ni­ni̠tán pi̠ ni̠para cha̠tum cris­tiano tla̠n naquin­ta­li̠­pa̠­huam­putún para ni̠ huá quin­tla̠t pu̠lh nama̠­lac­pu­hua̠ni̠y. ");
INSERT INTO tocNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Acxni­tiyá a̠má quilh­ta­macú lhu̠hua hua̠nti̠ xta­sta̠­la­ni­má̠­nalh Jesús, taak­xtek­má­kalh y niaj acxtum xta­ta̠­lat­la̠­huán. ");
INSERT INTO tocNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Hua̠nchú xpa̠­la­cata Jesús ca̠ka­lhás­quilh a̠ma̠ko̠lh kalha­cu̠tiy xdis­cí­pulos: —¿Chi̠nchú hui­xinín, na̠ qui­la̠ak­xtek­makam­pu­tu­ná̠hu? ");
INSERT INTO tocNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Pero huata Simón Pedro chiné kálh­ti̠lh: —Quim­pu̠­chi­nacán, ¿tícu chú a̠tunu luu nac­ti­la­ka­ná̠hu? Porque xma̠nhuá min­ta­chu­huí̠n ma̠lacnu̠y a̠má xax­li̠­ca̠na latáma̠t hua̠ntu̠ anka­lhi̠ná cahuá naka­lhi̠­yá̠hu. ");
INSERT INTO tocNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Aquinín aya cca̠­naj­la­ni̠tán porque cca­tzi̠­yá̠hu pi̠ huix xata­lac­sacni Xka­huasa Dios hua̠nti̠ naquin­ca̠­lak­ma̠x­tuyá̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús chiné ca̠kálh­ti̠lh: —¿Lácu pi̠ ni̠ aquit cca̠­lac­sac­ni̠tán min­ka­lha­cu̠­tiycán la̠qui̠ qui­dis­cí­pulos nahua­ná̠tit? Pero ma̠squi chuná, nac milak­sti̠­pa̠ncán huí cha̠tum hua̠nti̠ makat­la­janít xta­la­ca­pa̠s­tacni akska­huiní. ");
INSERT INTO tocNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Acxni̠ chuná huá Jesús, huá xlá xli̠­chu­hui̠­nama Judas Isca­riote xka­huasa Simón, porque huá Judas xámaj sta̠­huay ma̠squi xlá acxtum xca̠­ta̠­ta­peksi̠y xli̠­ka­lha­cu̠tiy xdis­cí­pulos. ");
INSERT INTO tocNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Aca­li̠stá̠n Jesús antá xla­pu̠lay nac xapu̠­la­tama̠n Gali­lea. Xlá ni̠ xta­hui­la­pu­tu­na̠chá nac Judea porque xana­puxcun judíos xta­mak­ni̠­putún. ");
INSERT INTO tocNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Pero cumu aya xta­la­ca­tzu­hui̠ma xpa̠x­cuajcán judíos acxni̠ xtat­la­huay aktum paxcua xuanicán fiesta de las chozas, ");
INSERT INTO tocNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","hua̠nti̠ xli̠­ta­la­ka­pasni Jesús chiné tahuá­nilh: —Niaj cata­mák­xtekti uú, huata mejor capit nac Judea la̠qui̠ hua̠nti̠ antá tahui­lá̠­nalh y hua̠nti̠ antá tata̠­ta̠­yayá̠n xlacán na̠ nataucxilha hua̠ntu̠ huix tla­huaya. ");
INSERT INTO tocNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Cumu para laca­squina huix nala­ka­pas­cana, pus ni̠tu̠ caj laka­tze̠k cat­lahua. Pus cumu huix tla̠n ca̠t­la­huaya lac­lanca li̠cá̠cni̠t ta­scújut, pus chuná antá caca̠t­lahua nac xla­ca­ti̠ncán xli̠­lhu̠hua cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Huá chuná tali̠­huá­nilh porque hasta mismo xli̠­ta­la­ka­pasni ni̠ xta­ca­tzi̠y tícuya̠ chixcú xuani̠t xla­cata xli̠­ca̠na nata­ca̠­naj­laniy. ");
INSERT INTO tocNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesús chiné ca̠huá­nilh: —Ni̠ naj a̠ lak­chá̠n quilh­ta­macú acxni̠ antá nacán, pero hua̠ntu̠ hui­xinín mila­ca­tacán catu̠huá quilh­ta­macú hua̠k tla̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ama̠­ko̠lh cris­tianos hua̠nti̠ ni̠ quin­ta­li̠­pa̠­huán hui­xinín ni̠lay ca̠si̠­tzi̠­niyá̠n; pero aquit luu lhu̠hua hua̠nti̠ ni̠ quin­taucxilh­putún porque aquit ni̠ cca̠­li̠­quilh­puwán y laca­tancs cca̠­ma̠­lak­si­yuniy cca̠­huaniy hua̠ntu̠ ni̠tlá̠n tat­la­huay. ");
INSERT INTO tocNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Huata capim­pítit hui­xinín nac pa̠xcua, aquit ni̠naj cama porque nia̠ lak­chá̠n quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Acxni̠ chuná ca̠ta̠­chu­hui̠­nan­ko̠lh, xlacán táalh nac pa̠xcua y Jesús tamák­xtekli nac Gali­lea. ");
INSERT INTO tocNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pero acxni̠ taanko̠lh xli̠­ta­la­ka­pasni, Jesús na̠ alh nac pa̠xcua, ma̠squi xlá ni̠ ca̠ta­si­yú­nilh xli̠­lhu̠hua cris­tianos huata caj tze̠k xla­pu̠lay. ");
INSERT INTO tocNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Xana­puxcun judíos xta­la­ca­pu­tza­má̠­nalh nac pa̠xcua chicá para na̠ xani̠t, xlacán xta­ka­lhas­qui­ni̠nán chicá para tícu xuc­xilhni̠t, y chiné xta­huán: —¿Ni̠cu láma cahuá chú a̠má chixcú? ");
INSERT INTO tocNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Luu lhu̠hua cris­tianos hua̠nti̠ catu̠huá xta­liaksa­má̠­nalh, y chiné xta­huán: “Tamá chixcú luu tla̠n xtapuhuá̠n”, pero maka­pi­tzí̠n chiné xta­huán: “Tamá chixcú ni̠ xli̠­ca̠na luu tla̠n catzi̠y, porque caj ca̠ak­ska­huimi̠y cris­tianos.” ");
INSERT INTO tocNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero luu caj laka­tze̠k chuná xta­li̠­chu­hui̠nán porque xta­pe̠­cuaniy xana­puxcún judíos. ");
INSERT INTO tocNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Acxni̠ aya xita̠t­lani̠t pa̠xcua Jesús tánu̠lh nac lanca pu̠si­culan xalac Jeru­salén y tzú­culh ca̠ma̠­kalh­chu­hui̠ni̠y cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ama̠­ko̠lh xana­puxcun judíos luu cacs xta­li̠­la­ca­huán y chiné xta­huán: —¿Nícu xlá luu catzí̠­nilh pu̠tum hua̠ntu̠ ma̠siyuy porque xlá ni̠ kalh­ta­hua­kani̠t? ");
INSERT INTO tocNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Cumu Jesús ca̠ka­lha­káx­matli chiné ca̠kálh­ti̠lh: —Eé quin­ta­chu­hui̠n hua̠ntu̠ aquit cma̠­si­yuma ni̠ caj que̠cstu quin­ta­la­ca­pa̠s­tacni, pus huá xta­la­ca­pa̠s­tacni a̠má hua̠nti̠ qui­ma­ca­mini̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Pus para tícu hui­xinín xtla­hua­pú­tulh xta­pa̠­xu­huá̠n Dios hua̠ntu̠ xlá lacas­quín, pus huata xlá naaka­ta̠ksa a̠má tala­ca­pa̠s­tacni hua̠ntu̠ aquit cqui­lhuama para huá xla Dios osuchí caj que̠cstu quin­ta­la­ca­pa̠s­tacni. ");
INSERT INTO tocNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Amá chixcú hua̠nti̠ li̠chu­hui̠nán hua̠ntu̠ caj sacstu xta­la­ca­pa̠s­tacni, huá xlá chuná li̠t­la­huay la̠qui̠ luu nata­ca̠c­ni̠­naniy cris­tianos; pero hua̠nti̠ li̠taaka­tzanke̠y la̠qui̠ naca̠c­ni̠­na­nicán Dios hua̠nti̠ maca­mini̠t, pus chuná li̠ma̠­siyuy pi̠ talu­lóktat hua̠ntu̠ qui­lhuama y ni̠tu̠ caj aksa­ni̠­nama. ");
INSERT INTO tocNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿Lácu pi̠ ni̠ xli̠­ca̠na pi̠ huá Moisés tica̠­ma̠x­quí̠n a̠má xta­péksi̠t Dios la̠qui̠ hui­xinín nama̠­kan­tax­ti̠­yá̠tit? Pero ni̠para cha̠tum tícu luu lak­tzak­sama la̠qui̠ nama̠­kan­taxti̠y. Porque cumu para chuná cahuá, ¿túcu chi̠nchú xpa̠­la­cata qui­la̠­li̠­mak­ni̠­pu­tu­ná̠hu? ");
INSERT INTO tocNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ama̠­ko̠lh cris­tianos chiné takálh­ti̠lh: —Ma̠x caj laka­hui­típa̠t huix. ¿Lácu li̠huana pi̠ camá̠n ca̠mak­ni̠yá̠n? ¿Tícu mak­ni̠­pu­tuná̠n? ");
INSERT INTO tocNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús chiné ca̠huá­nilh: —Maktum quilh­ta­macú acxni̠ hua̠k jaxcán aquit ctlá­hualh aktum luu tla̠n ta­scújut y hui­xinín chu­nacú tiliaklhu̠­hua̠t­nam­pá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Hui­xinín huá ca̠li̠­cir­cun­ci­dar­tla­huacán lactzu̠ milak­ka­hua­sacán porque chuná tica̠­li̠­ma̠­peksí̠n Moisés (ma̠squi luu xli̠­ca̠na pi̠ ni̠ huá Moisés ma̠quilh­tzu­qui̠­ni̠­tanchá eé hua̠ntu̠ li̠la­ka­chix­cu­hui̠­yá̠tit Dios sinoque huá xamaká̠n mili̠­ta­la­ka­pas­nicán Abraham), pero hui­xinín fuerza ca̠cir­cun­ci­dar­tla­hua­yá̠tit lactzu̠ lak­skatá̠n ma̠squi acxni̠ lak­cha̠ni̠t quilh­ta­macú la̠ li̠huancán para tícu nas­cuja. ");
INSERT INTO tocNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Pus cumu hui­xinín ni̠ laca­tza̠­la­pu­tu­ná̠tit xli̠­ma̠­peksí̠n Moisés pus ca̠cir­cun­ci­dar­tla­hua­yá̠tit lactzu̠ laka­huasán ma̠squi sábado acxni̠ ni̠tícu scuja, ¿huá chi̠nchú luu qui­la̠­li̠­si̠­tzi̠­ni­yá̠hu cumu cma̠t­lán­ti̠lh cha̠tum ta̠tatlá acxni̠ a̠má quilh­ta­macú li̠huancán para tícu nas­cuja? ");
INSERT INTO tocNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ni̠ luu caj aklakuá caqui­la̠­pu­tza̠­na­níhu hua̠ntu̠ ctla­huay. Acxni̠ para naqui­la̠­pu­tza̠­na­ni­pu­tu­ná̠hu hua̠ntu̠ ctla­huani̠t pero hua̠ntu̠ luu aksti̠tum cat­la­huátit. ");
INSERT INTO tocNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Y maka­pi­tzí̠n cris­tianos hua̠nti̠ xta­hui­la̠­nanchá nac Jeru­salén chiné tzú­culh taka­lhas­qui­ni̠nán: —¿Lácu pi̠ ni̠ huá eé chixcú hua̠nti̠ putza­má̠­calh la̠qui̠ namak­ni̠cán? ");
INSERT INTO tocNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Chi̠nchú pi̠ pu̠tum ca̠hui­li̠ni̠t cris­tianos, ca̠ma̠­kalh­chu­hui̠­ni̠ma y ni̠ti̠ para tícu xma̠aklhú̠­hui̠lh. Ma̠x a̠huayu taca̠­naj­lá­nilh qui­ma̠­pek­si̠­nacán pi̠ xli̠­ca̠na eé chixcú huá Cristo ti̠ naquin­ca̠­lak­ma̠x­tuyá̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero aquinín catzi̠­yá̠hu nícu xlá mini̠­tanchá y na̠ catzi̠­ya̠huá anta­nícu laca­chini̠t; y ni̠chuná cati­qui̠­táx­tulh acxni̠ Cristo namín nac ca̠quilh­ta­macú, porque ni̠tícu cati­cá­tzi̠lh nícu xlá minchá nahuán. ");
INSERT INTO tocNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesús xca̠­ma̠­kalh­chu­hui̠­ni̠ma cris­tianos nac lanca pu̠si­culan y acxni̠ xlá káx­matli hua̠ntu̠ xta­qui­lhuamá̠­nalh luu palha chiné ca̠huá­nilh: —¡Hui­xinín hua­ná̠tit pi̠ qui­la̠­la­ka­pa­sá̠hu y catzi̠­yá̠tit anta­nícu cmi­ni̠­tanchá! Pero huí kam­pa̠tum hua̠ntu̠ ni̠ catzi̠­yá̠tit, aquit ni̠ caj que̠cstu qui­la­cata ma̠squi cmini̠t, porque huí cha̠tum hua̠nti̠ qui­ma­ca­mini̠t y huá xlá ma̠sta̠y xatlá̠n tala­ca­pa̠s­tacni, pero hui­xinín ni̠ laka­pa­sá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Aquit xlá cla­ka­pasa porque antá nac xpa̠xtú̠n cminchá, y xa̠huachí cumu huá xlá qui­ma­ca­mini̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ama̠­ko̠lh lac­chix­cu­huí̠n xta­chi­pa­putún la̠qui̠ nata­chi̠lé̠n, pero ni̠tícu chí­palh cumu nia̠ xlak­chá̠n xquilh­ta­macú la̠ta xlá namak­ni̠cán. ");
INSERT INTO tocNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pero na̠ luu lhu̠hua cris­tianos taca̠­naj­lá­nilh y chiné xta­huán: —Bueno, chi̠nchú acxni̠ namín Cristo qui­ma̠­ka­pu̠­tax­ti̠­nacán, ¿lácu pi̠ a̠tzinú lac­lanca li̠cá̠cni̠t ta­scújut xlá nat­la­huay ni̠ xachuná ca̠t­la­huay eé chixcú? ");
INSERT INTO tocNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ama̠­ko̠lh lac­chix­cu­huí̠n hua̠nti̠ xca̠­hua­nicán fariseos chu xana­puxcun cura, xlacán tzú­culh takax­mata la̠ta xta­li̠­chu­hui̠nán cris­tianos hua̠ntu̠ xlá xtla­huay Jesús, huata xlacán tamá­ca̠lh maka­pi­tzí̠n poli­cías hua̠nti̠ xta­mak­ta­kalhnán nac lanca pu̠si­culan la̠qui̠ tachí̠n natalé̠n Jesús. ");
INSERT INTO tocNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Xlacán táalh pero Jesús chiné ca̠huá­nilh: —Niaj luu maka̠s quilh­ta­macú cca̠­ta̠­lamá̠n aquit porque nac­tas­pit­paray nac xpa̠xtú̠n hua̠nti̠ qui­ma­ca­mini̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Amá quilh­ta­macú hui­xinín naqui­la̠­pu­tza­yá̠hu pero niaj caquin­ti­la̠­mac­láhu porque hui­xinín ni̠lay cati­pítit anta­nícu aquit nac­ta­hui­la­ya̠chá. ");
INSERT INTO tocNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ama̠­ko̠lh judíos sac­stucán tzú­culh tala̠­ka­lhas­quín: —¿Nícu xlá naán la̠qui̠ aquinín niajlay cati­mac­láhu? ¿Lácu pi̠ huá cahuá naca̠­lakán a̠ma̠ko̠lh judíos hua̠nti̠ tahui­la̠­nanchá nac xpu̠­la­ta­ma̠ncán griegos la̠qui̠ huá naca̠­ma̠­kalh­chu­hui̠ni̠y hua̠nti̠ antá mákat tahui­la̠­nanchá? ");
INSERT INTO tocNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Túcu chú luu hua­ni­putún acxni̠ chiné quin­ca̠­huanín: “Hui­xinín naqui­la̠­pu­tza­yá̠hu pero niaj caquin­ti­la̠­mac­láhu, porque hui­xinín ni̠lay cati­pítit anta­nícu aquit nac­ta­hui­la­ya̠chá”? ");
INSERT INTO tocNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Acxni­tiyá a̠má quilh­ta­macú xliakas­putni pa̠xcua acxni̠ a̠tzinú luu lhu̠hua xta­tza­macán, Jesús tá̠yalh nac xla­ca­ti̠ncán cris­tianos y chiné ca̠huá­nilh: —Para tícu kalh­pu̠­ti̠ma nac xla­táma̠t, caqui­lák­milh y aquit nac­ma̠­kotni̠y. ");
INSERT INTO tocNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Pus chuná nali̠­kan­taxtuy hua̠ntu̠ tatzok­ta­hui­lani̠t xta­chu­huí̠n Dios nac li̠kalh­ta­huaka anta­nícu chiné huán pi̠ nac xnacú a̠má cris­tianos hua̠nti̠ naqui­li̠­pa̠­huán ámaj tahuilay cumu la̠ aktum musni anta­nícu natax­tu­ti̠­lhay a̠má chú­chut hua̠ntu̠ nali̠­la­tama̠y xli̠s­tacni. ");
INSERT INTO tocNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Caj xpa̠­la­cata eé xta­chu­huí̠n Jesús xta̠­ma̠­la­cas­tucma a̠má musni chu Espíri­tu Santo, huá xlá xuani­putún xla­cata hua̠nti̠ nali̠­pa̠­huán namak­lhti̠nán xli̠t­li­hueke Espíri­tu Santo; ma̠squi a̠má quilh­ta­macú nia̠ xmin Espíri­tu Santo porque Jesús nia̠ xni̠y la̠qui̠ nacha̠m­paray nac akapú̠n anta­nícu xapu̠lh xuí. ");
INSERT INTO tocNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Maka­pi­tzí̠n cris­tianos acxni̠ takáx­matli xta­chu­huí̠n, chiné tzú­culh tahuán: —Xli̠­ca̠na huá tamá pro­feta hua̠nti̠ xli̠­mínit xuani̠t nac ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Pero maka­pi­tzí̠n chiné xta­huán: —Ni̠ xli̠­ca̠na huá Cristo hua̠nti̠ mini̠tán quin­ca̠­ma̠aka­pu̠­tax­ti̠yá̠n. Hui̠nti̠ xta­huam­paray: —Pero, ¿lácu pi̠ xalac Gali­lea nahuán hua̠nti̠ luu xli̠­ca̠na Cristo? ");
INSERT INTO tocNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Nac xta­chu­huí̠n Dios hua̠ntu̠ tatzokni̠t huan pi̠ tamá Cristo xli̠­ta­la­ka­pasni nahuán a̠má xamaká̠n rey David, y xa̠huachí xalac Belén nahuán porque antá xca̠­chi­quí̠n xuani̠t David. ");
INSERT INTO tocNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Y caj xpa̠­la­cata Jesús a̠ma̠ko̠lh cris­tianos tata­paj­pi­tzi­ko̠lh. ");
INSERT INTO tocNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Huata maka­pi­tzí̠n poli­cías xta­le̠m­putún Jesús nac pu̠la̠­chi̠n pero ni̠ cha̠tum hua̠nti̠ chí­palh. ");
INSERT INTO tocNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ama̠­ko̠lh poli­cías tatas­pitpá y antá taampá antaní xta­hui­la̠­nanchá fariseos chu xana­puxcun cura, y acxni̠ tácha̠lh chiné ca̠ka­lhas­quinca: —¿Lácu ni̠ li̠tátit? ");
INSERT INTO tocNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Xlacán takalh­tí̠­nalh: —La̠tachá xlá chu­hui̠nán a̠má chixcú ni̠para cha̠tum tícu chixcú a̠ chu­hui̠nán cumu la̠ xlá. ");
INSERT INTO tocNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Huata a̠ma̠ko̠lh fariseos chiné tahuá­nilh: —¿Lácu pi̠ na̠ aya taak­ska­hui­tittá hui­xinín? ");
INSERT INTO tocNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Lácu pi̠ na̠ aya taca̠­naj­la­nini̠t maka­pi­tzí̠n quim­pux­cucán osuchí quin­ta̠­fa­ri­seoscán? ");
INSERT INTO tocNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pero a̠ma̠ko̠lh cris­tianos hua̠nti̠ takax­matniy xta­chu­huí̠n, xlacán ni̠ taaka­ta̠ksa hua̠ntu̠ huam­putún xta­chu­huí̠n Dios hua̠ntu̠ tatzok­ta­hui­lani̠t nac li̠kalh­ta­huaka, pus caj huá xpa̠­la­cata xlacán taamá̠­nalh tali̠­lak­tzanka̠y. ");
INSERT INTO tocNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Chi̠nchú Nico­demo hua̠nti̠ maktum ca̠tzi̠sní tiqui̠­la­ka­pa­xiá̠lhnalh Jesús xlá na̠ fariseo xuani̠t, chiné ca̠huá­nilh: ");
INSERT INTO tocNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Pus la̠ta tatzok­ta­hui­lani̠t xli̠­ma̠­peksí̠n Moisés huan pi̠ ni̠para cha̠tum chixcú tla̠n cati­ma̠­la­ca­pú̠hu para ni̠ pu̠lh cati­pu­tza̠­na­níhu y li̠huana̠ naca­tzi̠­yá̠hu hua̠ntu̠ xlá tla­huani̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Pero huata xlacán caj tali̠­kalh­ka­má̠­nalh y chiné takalh­tí̠­nalh: —¿Lácu pi̠ na̠ xalac Gali­lea huix? Pus huata luu li̠huana̠ cali̠­kalh­ta­huaka a̠ma̠ko̠lh libros anta­nícu tatzok­ta­hui­lani̠t xta­chu­huí̠n Dios y ne̠cxni cati­mac­lalh anta­nícu huan para cha̠tum pro­feta mini̠­tanchá nac Gali­lea. ");
INSERT INTO tocNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Acxni̠ chuná tachu­hui̠­nan­ko̠lh a̠ma̠ko̠lh fariseos cha̠­tunu cha̠­tunu alh nac xchic. ");
INSERT INTO tocNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Huata Jesús alh nac ke̠stí̠n hua̠ntu̠ hua­nicán Cerro de los Olivos, ");
INSERT INTO tocNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","y li̠cha̠li li̠túm acxni̠ xka­ka­ko̠lh xlá ampá nac lanca pu̠si­culan. Pero luu lhu̠hua cris­tianos talak­ta­la­ca­tzú­hui̠lh, xlá táhui y tzú­culh ca̠ma̠­kalh­chu­hui̠ni̠y. ");
INSERT INTO tocNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Y maka­pi­tzí̠n xma̠­kalh­ta­hua­ke̠­nacán judíos xa̠hua fariseos talí̠­milh cha̠tum pusca̠t hua̠nti̠ xta­ma̠­nok­lhuni̠t cxa­kat­li̠ma túnuj chixcú. Antá xlacán tayá̠­hualh nac xla­ca­ti̠ncán xli̠­hua̠k cris­tianos. ");
INSERT INTO tocNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Xlacán chiné tahuá­nilh Jesús: —Ma̠kalh­ta­hua­ke̠ná, eé pusca̠t cma̠­nok­lhu­ni̠­táhu acxni̠ luu cxa­kat­li̠ma túnuj chixcú y xak­ska­huima xta̠­ko̠lú. ");
INSERT INTO tocNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nac xli̠­ma̠­peksí̠n Moisés quin­ca̠­li̠­ma̠­pek­si̠yá̠n para tícu chuná pusca̠t nac­ma̠­nok­lhu­yá̠hu tla̠n nac­liacta­la­mak­ni̠­yá̠hu chí­huix. Chi̠nchú huix, ¿lácu huana pi̠ tla̠n chuná nac­tla­hua­yá̠hu? ");
INSERT INTO tocNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Xlacán caj chu­natá xta­li̠­kalh­pu­tza­má̠­nalh la̠qui̠ para túcu xlá ni̠ tancs nakalh­ti̠nán y chuná chú nata­li̠­ma̠­la­capu̠y. Huata Jesús taquilh­pú̠­talh y tzú­culh li̠tzoknún kantum actzu̠ xmacán nac ca̠ti­yatni. ");
INSERT INTO tocNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Y a̠ma̠ko̠lh lac­chix­cu­huí̠n chu­nacú xta­li̠­ma̠­ka­tzan­ke̠­má̠­nalh, pus huata Jesús taáctzajli y chiné ca̠huá­nilh: —La̠ta mac­xtum yá̠tit, para tax­tu­ya̠chá cha̠tum hua̠nti̠ ni̠túcu tit­la­huani̠t tala̠­ka­lhí̠n, pus huata huá xlá luu mini̠niy casacli aktum chí­huix y cama­ca­pú̠­lalh la̠qui̠ naacta­la­mak­ni̠­yá̠tit tamá pusca̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jesús taquilh­pu̠­tapá y tzu­cupaj tzoknún nac tíyat. ");
INSERT INTO tocNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Acxni̠ xlacán takáx­matli a̠má tachu­huí̠n ni̠tu̠ takalh­tí̠­nalh huata laka­siyu tzú­culh tatza̠lay, cha̠­tunu tzú­culh taán, pu̠lh tapú̠­lalh hua̠nti̠ aya lak­ko̠lún y aca­li̠stá̠n táalh hua̠nti̠ tlakcu laka­huasán. Acxni̠ taanko̠lh ca̠ta sacstu Jesús tamák­xtekli chu a̠má pusca̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Acxni̠ chú taquilh­pú̠­qui̠lh Jesús niaj tícu úcxilhli ca̠ta caj sacstu a̠má pusca̠t xyá, xlá chiné huá­nilh: —Pusca̠t, ¿nícu tayá̠­nalh hua̠nti̠ xta­ma̠­la­ca­pu̠má̠n? ¿Lácu pi̠ niaj ti̠ ma̠la­ca­pu̠má̠n? ");
INSERT INTO tocNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Xlá chiné kalh­tí̠­nalh: —Quim­pu̠­chiná, niaj ti̠ qui­ma̠­la­ca­pu̠ma. Y Jesús chiné huá­nilh: —Pus na̠ ni̠para aquit cla­cas­quín nac­ma̠­pa̠­ti̠­ni̠yá̠n caj xpa̠­la­cata hua̠ntu̠ ni̠tlá̠n tit­la­hua­ní̠ta min­ta­la̠­ka­lhí̠n. La̠nchú capittá nac mín­chic, y niaj cat­lahua tala̠­ka­lhí̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús tzu­cupaj ca̠ma̠­kalh­chu­hui̠ni̠y cris­tianos y chiné ca̠huá­nilh: —Aquit cli̠­taxtuy tax­káket hua̠ntu̠ macax­ka­ke̠nán nac ca̠quilh­ta­macú. Hua̠nti̠ naqui­li̠­pa̠­huán y naquis­ta̠­laniy naka­lhi̠y tax­káket nac xla­táma̠t y ne̠cxni cati­la­tá­ma̠lh xala­ka­ca̠­pucsua. ");
INSERT INTO tocNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Maka­pi­tzí̠n fariseos chiné tahuá­nilh: —Huix caj luu me̠cstu li̠chu­hui̠­nam­pá̠­canti, caj huá xpa̠­la­cata tamá min­ta­chu­huí̠n ni̠tu̠ li̠ma­cuán y ni̠lay cca̠­naj­la­yá̠hu. ");
INSERT INTO tocNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús chiné ca̠kálh­ti̠lh: —Aquit ni̠ cak­ska­huinán, ma̠squi luu caj que̠cstu caqui­li̠­chu­hui̠­nán­calh pero quin­ta­chu­huí̠n li̠ma­cuán porque aquit cca­tzi̠y nícu cminchá, y na̠ cca­tzi̠y nícu cpe­kama. Pero hui­xinín ni̠ catzi̠­yá̠tit nícu cminchá y na̠ ni̠para catzi̠­yá̠tit nícu cpe­kama. ");
INSERT INTO tocNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Hui­xinín qui­la̠­li̠­ya̠­hua­ma̠­náhu hua̠ntu̠ lacas­qui­ná̠tit porque cumu la̠ cati̠hua̠ chixcú xala ca̠quilh­ta­macú qui­la̠­li̠­ma­ca̠­náhu. Aquit ni̠tu̠ cca̠­li̠­ya̠­huayá̠n, ");
INSERT INTO tocNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","pero para xac­ca̠­ma̠­la­cá­pu̠lh min­ka­satcán, hua̠ntu̠ xac­ca̠­huanín hua̠k xli̠­ca̠na porque aquit ni̠ que̠cstu para tícu cpu­tza̠­naniy xcuentaj huata huá Quin­tla̠t hua̠nti̠ qui­ma­ca­mini̠t qui­ma̠x­qui̠y xta­la­ca­pa̠s­tacni túcu nac­li̠­ya̠­huanán. ");
INSERT INTO tocNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nac a̠má li̠ma̠­peksí̠n hua̠ntu̠ Moisés tica̠­mak­xteknín, antá tatzokni̠t pi̠ acxni̠ cha̠tiy tes­tigos luu acxtum nata­chu­hui̠nán, pus naca̠­ca̠­naj­la­nicán. ");
INSERT INTO tocNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Pus cca̠­hua­niyá̠n pi̠ huí cha̠tiy hua̠nti̠ tama̠­lu­loka xla­cata pi̠ xli̠­ca̠na hua̠ntu̠ cli̠­chu­hui̠nán, aquit cha̠tum, chu Quin­tla̠t xli̠­cha̠tiy hua̠nti̠ qui­ma­ca­mini̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Xlacán chiné taka­lhás­quilh: —¿Nícu hui­lachá min­tla̠t? Jesús ca̠huá­nilh: —Hui­xinín ni̠ qui­la̠­la­ka­pa­sá̠hu aquit y ni̠para huá Quin­tla̠t laka­pa­sá̠tit. Para aquit xqui­la̠­la­ka­pasui, pus na̠ xla­ka­pástit Quin­tla̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús chuná ca̠ta̠­chu­huí̠­nalh a̠ma̠ko̠lh fariseos acxni̠ xlá xak­chu­hui̠­nama nac lacatzú xamá̠­lacchi lanca pu̠si­culan antaní xta­hui­lá̠­nalh cajón hua̠ntu̠ xpu̠­taju̠y limos­nas. Pero ni̠tícu chí­palh la̠qui̠ nale̠ncán nac pu̠la̠­chi̠n porque nia̠ xlak­chá̠n xquilh­ta­macú la̠ nama­ca­ma̠s­ta̠cán. ");
INSERT INTO tocNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Caj li̠puntzú Jesús ca̠hua­nipá eé takalh­chu­huí̠n: —Aquit cama a̠laca­tunu y naqui­la̠­pu­tza­yá̠hu, pero hui­xinín ni̠ caquin­ti­la̠­mac­láhu; pus anta­nícu aquit nac­chá̠n hui­xinín ni̠lay cati­pítit porque kalhi̠­yá̠tit lhu̠hua tala̠­ka­lhí̠n y acxni̠ nani̠­yá̠tit huá nali̠­lak­tzan­ka̠­yá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Y a̠ma̠ko̠lh judíos chiné tzú­culh la̠huaniy: —Eé chixcú ma̠x a̠huayu caj amá̠­calh mak­ni̠cán sacstu, huá chuná li̠huán pi̠ ni̠lay cati­chá̠hu anta­nícu xlá ámaj cha̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesús ca̠huá­nilh: —Hui­xinín mim­pu̠­la­ta­ma̠ncán antá uú huí ca̠tu̠tzú, pero quim­pu̠­la­tama̠n huí ta̠lhmá̠n; hui­xinín uú xala ca̠quilh­ta­macú, pero aquit ni̠ antá uú xala ca̠quilh­ta­macú. ");
INSERT INTO tocNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Pus huá xpa̠­la­cata cca̠­li̠­huanín pi̠ hui­xinín kalhi̠­yá̠tit lhu̠hua tala̠­ka­lhí̠n y acxni̠ nani̠­yá̠tit huá nali̠­lak­tzan­ka̠­yá̠tit. Cumu para ni̠ naca̠­naj­la­yá̠tit pi̠ aquit a̠má hua̠nti̠ naca̠­lak­ma̠x­tuyá̠n, pus acxni̠ nani̠­yá̠tit pim­pá̠tit li̠lak­tzan­ka̠­yá̠tit min­ta­la̠­ka­lhi̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Xlacán chiné tahuá­nilh: —Xli̠­ca̠na, ¿tícuya̠ chixcú huix? Jesús ca̠kálh­ti̠lh: —Hui­xinín catzi̠­yá̠tit pi̠ hasta la̠ta xapu̠lh tuncán cca̠­hua­ni­ni̠tán tícu aquit. ");
INSERT INTO tocNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Aquit tla̠n lhu̠hua xac­ca̠­li̠­chu­hui̠nán y xac­ca̠­li̠­ya̠­huán hua̠ntu̠ ni̠tlá̠n tla­hua­yá̠tit, pero huata huá nac­ma̠­siyuy uú nac ca̠quilh­ta­macú hua̠ntu̠ lacas­quín hua̠nti̠ qui­ma­ca­mini̠t y hua̠ntu̠ ckax­mat­nini̠t; pus xlá luu aksti̠tum xta­la­ca­pa̠s­tacni. ");
INSERT INTO tocNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero xlacán ni̠ taaká­ta̠ksli pi̠ Jesús xca̠­li̠­ta̠­chu­hui̠­nama Dios hua̠nti̠ Xtla̠t, ");
INSERT INTO tocNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","y huá chiné ca̠li̠­hua­nipá: —Hasta acxni̠ hui­xinín naqui­la̠­ma̠­ta̠lh­ma̠­ni̠­yá̠hu nac cruz, pus acxnicú luu naaka­ta̠k­sá̠tit tícu aquit; y na̠ acxnicú naca­tzi̠­yá̠tit pi̠ aquit ni̠tu̠ ctla­huay hua̠ntu̠ caj que̠cstu qui­la­cata, huata caj xma̠nhuá cuan hua̠ntu̠ qui­ma̠­si­yu­nini̠t Quin­tla̠t. ");
INSERT INTO tocNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Porque Dios hua̠nti̠ aquit qui­ma­ca­mini̠t anka­lhi̠ná quin­ta̠­la­pu̠lay, Quin­tla̠t ne̠cxni a̠ quiak­xtek­makán porque anka­lhí̠n aquit ctla­huay hua̠ntu̠ xlá lakati̠y. ");
INSERT INTO tocNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Acxni̠ chuná chu­hui̠­nan­ko̠lh Jesús, luu lhu̠hua cris­tianos xta­li̠­pa̠­huam­putún y xta­sta̠­la­ni­putún. ");
INSERT INTO tocNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesús chiné ca̠huá­nilh judíos hua̠nti̠ aya xta­sta̠­la­ni­putún: —Pus para hui­xinín luu aksti̠­tumá nama̠­kan­tax­ti̠­yá̠tit hua̠ntu̠ cca̠­li̠­ma̠­pek­si̠yá̠n pus chuná tla̠n nali̠­tax­tu­yá̠tit cumu la̠ xax­li̠­ca̠na quin­ta­ma̠­kalh­ta­huaké̠n, ");
INSERT INTO tocNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","y chuná hui­xinín tla̠n nala­ka­pa­sá̠tit xta­la­ca­pa̠s­tacni Dios, y huá a̠má tala­ca­pa̠s­tacni naca̠­ma̠x­qui̠yá̠n lak­táxtut porque caj la̠ tachí̠n hui­xinín lapá̠tit. ");
INSERT INTO tocNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Maka­pi­tzí̠n chiné takálh­ti̠lh: —Amá Abraham hua̠nti̠ maká̠n quilh­ta­macú xlama qui­li̠­ta­la­ka­pas­nicán xuani̠t aquinín, y ne̠cxni a̠ quin­ca̠­chi̠­caná̠n la̠qui̠ para tícu caj chuná nac­scuj­ni­yá̠hu. ¿Túcu chú xpa̠­la­cata huix li̠huana pi̠ nac­ka­lhi̠­yá̠hu lak­táxtut? ");
INSERT INTO tocNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús ca̠huá­nilh: —Xli̠­ca̠na cca̠­hua­niyá̠n pi̠ xli̠­hua̠k hua̠nti̠ tat­la­huay tala̠­ka­lhí̠n xlacán tali̠­taxtuy cumu la̠ xta­sa̠­cuacán tala̠­ka­lhí̠n, osuchí cumu la̠ xta­chi̠ncán. ");
INSERT INTO tocNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Cha̠tum tasa̠cua hua̠nti̠ caj la̠ tachí̠n ma̠s­cu­jucán, xlá ni̠lay tla­huay tu̠ lacas­quín huata huá tla­huay hua̠ntu̠ huaniy xpatrón, pero aquit Xka­huasa Dios ni̠ tachí̠n. ");
INSERT INTO tocNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Huá cca̠­li̠­hua­niyá̠n, p