﻿USE sofia;
DROP TABLE IF EXISTS sofia.tnp_vpl;
CREATE TABLE tnp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tnp_vpl WRITE;
INSERT INTO tnp_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ilah mɨn u nərgɨ tɨpɨ Iesu Krɨsto tərah mɨn nəuvein. Kig Tefɨt in tɨpɨn tərah asoli kəti. Kəni tɨpɨn tərah asoli mɨn kəti u tətaupən in Epraham. ");
INSERT INTO tnp_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Epraham in tatə rəha Aisək, kəni Aisək in tatə rəha Jekəp, kəni Jekəp in tatə rəha Juta mɨne pian mɨn, ");
INSERT INTO tnp_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","kəni Juta in tatə rəha Peres mɨne Serə, rəhalau mamə u Temar, kəni Peres in tatə rəha Hesron, kəni Hesron in tatə rəha Ram, ");
INSERT INTO tnp_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","kəni Ram in tatə rəha Aminatap, kəni Aminatap in tatə rəha Nason, kəni Nason in tatə rəha Salmon, ");
INSERT INTO tnp_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","kəni Salmon in tatə rəha Poas u rəhan mamə Rehap, kəni Poas in tatə rəha Opet u rəhan u mamə Rut, kəni Opet in tatə rəha Jese, ");
INSERT INTO tnp_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","kəni Jese in tatə rəha Kig Tefɨt. Kəni Kig Tefɨt in tatə rəha Solomən u rəhan mamə in pətan rəha Uraiə aupən, ");
INSERT INTO tnp_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","kəni Solomən in tatə rəha Rehopom, kəni Rehopom in tatə rəha Apia kəni Apia in tatə rəha Asa, ");
INSERT INTO tnp_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","kəni Asa in tatə rəha Jehosəfat, kəni Jehosəfat in tatə rəha Jehorəm, kəni Jehorəm in kəha tərah rəha Usaiə, ");
INSERT INTO tnp_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","kəni Usaiə in tatə rəha Jotəm, kəni Jotəm in tatə rəha Ahas, kəni Ahas in tatə rəha Hesɨkaiə, ");
INSERT INTO tnp_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","kəni Hesɨkaiə in tatə Mənase, kəni Mənase in tatə rəha Amon, kəni Amon in tatə rəha Josaiə, ");
INSERT INTO tnp_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","kəni Josaiə in tatə rəha Jekonaiə mɨne pian mɨn, kəni uərisɨg lan, tɨkɨmɨr mɨn rəha nəuanɨləuɨs mɨn rəha Isrel kəmotəmki ilah məhuvən Papilon məmə ilah okəhuva slef mɨn rəhalah. ");
INSERT INTO tnp_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kəni inu nərgɨ kəha mɨn iətəm təmətuəuin e nian nəuanɨləuɨs mɨn rəha Isrel kəməhuvən Papilon. Jekonaiə in tatə rəha Sealtiel, kəni Sealtiel in kəha rəha Serupapel, ");
INSERT INTO tnp_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","kəni Serupapel in tatə rəha Apiut, kəni Apiut in tatə rəha Eliakim, kəni Eliakim in tatə rəha Asor, ");
INSERT INTO tnp_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","kəni Asor in tatə rəha Satok, kəni Satok in tatə rəha Akim, kəni Akim in tatə rəha Eliut, ");
INSERT INTO tnp_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","kəni Eliut, in tatə rəha Eleasar, kəni Eleasar in tatə rəha Matən, kəni Matən in tatə rəha Jekəp, ");
INSERT INTO tnp_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","kəni Jekəp in tatə rəha Josɨp u iərman rəha Meri. Kəni Meri təmələs Iesu, kəni kətauɨn lan məmə Krɨsto iətəm Uhgɨn təməni məmə otahli=pa. ");
INSERT INTO tnp_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Təmətuəuin e Epraham mətəuarus=pən Kig Tefɨt, kəha tərah mɨn əmə u nəuvein kəmətei rəkɨs nərgɨlah, ilah fotin. Kəni təmətuəuin mɨn e Kig Tefɨt mətəuarus=pən nəuanɨləuɨs mɨn rəha Isrel kəməhuvən Papilon, kəha tərah mɨn ilah rəfin fotin. Kəni təmətuəuin mɨn e nəuanɨləuɨs mɨn rəha Isrel kəməhuvən Papilon mətəuarus=pən Krɨsto iətəm Uhgɨn təməni məmə otahli=pa, kəha tərah mɨn ilah rəfin fotin. ");
INSERT INTO tnp_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Inu nanusiən təuvɨr rəha nairiən rəha Iesu Krɨsto. Mamə rəha Iesu, nərgɨn u Meri, kɨnəni rəkɨs məmə okos rəhan kətɨm kan məmə otɨtəu=pən suah kəti, nərgɨn u Josɨp. Mətəu e nian kəsiəuva əhanəhiən muatɨg pəti kətiəh, kəni Josɨp təsuvən əhanəhiən meruh, mətəu Narmɨn Rəha Uhgɨn tɨnol məmə Meri, iəpəou tɨnatɨg rəkɨs lan. ");
INSERT INTO tnp_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kəni rəhan iauəhli Josɨp in iətəmi əhruahru, kəni tətəlɨg lan məmə otəpəh Meri, mətəu in təsolkeikeiən məmə otol Meri taulɨs, kəni nɨkin təhti məmə otəsəni pətɨgəmiən kəm nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mətəu nian nɨkin təmatəhti məmə in otol nətəlɨgiən əha, kəni agelo kəti rəha Iərmənɨg tuva ohni e nəməhlairiən məni=pən kəm in məmə, “Josɨp, mipɨ Tefɨt tərah. Onəsəgɨniən məmə onəkit Meri məmə in rəham pətan, mətəu-inu suakəku əha tətatɨg lan, in təmsɨpən əmə e Narmɨn Rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kəni in otələs nətɨn kəti iərman, kəni onəkauɨn e nərgɨn məmə Iesu mətəu-inu in otosmiəgəh rəhan mɨn nətəmimi e noliən tərah mɨn rəhalah.” ");
INSERT INTO tnp_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Natimnati mɨn rəfin əha kəməhuva motol əmə nɨpəhriəniən e nəghatiən rəha Iərmənɨg iətəm rəhan kəti iəni təməni aupən ikɨn məmə, ");
INSERT INTO tnp_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Pətan mɨtə kəti iətəm iərman təsuvən əhanəhiən ohni, otəpəh məuɨg, kəni məpanələs nətɨn kəti iərman, kəni okauɨn e nərgɨn məmə Imaniuel,” inu nɨpətɨn təni məmə, “Uhgɨn tətatɨg kitah min.” ");
INSERT INTO tnp_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kəni nian Josɨp təmair, kəni təmɨtəu=pən əmə nəghatiən rəha agelo rəha Iərmənɨg. Kəni təmuvən mit Meri muva e rəhan lahuənu məmə rəhan pətan, ");
INSERT INTO tnp_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","mətəu in təməsuvən əhanəhiən meh matuvən mətəuarus=pən Meri tələs nətɨn iərman. Kəni Josɨp təmauɨn e nərgɨn məmə Iesu. ");
INSERT INTO tnp_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Iesu təmair əpəha nɨtəni Jutiə e taun Petlehem e nian Kig Herot Asoli in təmətarmənɨg lan. Kəni uərisɨg lan, nətəmi asoli mɨn nəuvein kəmotsɨpari isəu məhuva Jerusɨləm. Koteinatɨg vivi e nəniən nɨpətɨ məhau mɨn. Kəni məhuva motətapuəh məmə, ");
INSERT INTO tnp_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“?Suakəku u in iə, iətəm təmair məmə in kig rəha nətəm Isrel? Iəmoteh rəhan məhau təməri əpəha pari, kəni iəkəhuva məmə iəkotəfən nɨsiaiən kəm in.” ");
INSERT INTO tnp_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nian Kig Herot Asoli təmətəu nəghatiən əha, ilah nətəm Jerusɨləm nɨkilah rəfin təmərah. ");
INSERT INTO tnp_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kəni tuhapumɨn pris asoli mɨn mɨne nəgətun mɨn rəha Lou rəha nəfakiən rəha nətəm Isrel, kəni mətapuəh o lah məmə, “?Krɨsto iətəm Uhgɨn təməni rəkɨs məmə otahli=pa, in otair iə?” ");
INSERT INTO tnp_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Kəni kəmotəni=pən kəm in məmə, “In otair əpəha taun Petlehem e nɨtəni rəha Jutiə. Mətəu-inu iəni kəti rəha Uhgɨn aupən, təmətei tol lanu lan məmə, ");
INSERT INTO tnp_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ik Petlehem əpəha e nɨtəni Juta, ko kəsəniən məmə ik nati əpnapɨn e nətəmi asoli mɨn əpəha ikɨn Juta, mətəu-inu iətəmi asoli kəti otsɨpən lam, kəni in otateh vivi rəhak mɨn nətəm Isrel təhmen=pən e iətəmi tətəsal vivi o rəhan mɨn sipsip mɨn.’” ");
INSERT INTO tnp_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kəni Kig Herot Asoli təmauɨn e nətəmi mɨn u koteinatɨg vivi e nəniən nɨpətɨ məhau mɨn kəhuva tuhapumɨn oneuən ilah, mətapuəh o lah məmə məhau əha təməri əhruahru e nian nak, kəni kəmotəni=pən nian rəha məhau kəm in. ");
INSERT INTO tnp_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kəni in təməni=pən kəm lah məmə, “Əhuvən Petlehem motəsal vivi e suakəku. Nian onəkoteruh, kəni nəkotos nəghatiən lan məhuva məmə iəu mɨn iəkuvən məfən mɨn nɨsiaiən kəm in.” ");
INSERT INTO tnp_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Nian kəmotətəu nəghatiən əha, kəmohiet məhuvən, kəni moteh məhau əpələ iətəm kəmoteh əpəha pari, kəni nɨkilah təmagiən təmagiən ohni. Kəni məhau u təmaupən e lah muvən məhtul əhruahru əha suakəku əpələ tətapɨli ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kəni kəməhuvən əha imə, moteh suakəku ilau rəhan mamə Meri. Kəni kəmotasiəulɨn mautəfən nɨsiaiən kəm suakəku əha. Kəni kəmotiəlgi nautə e rəhalah kətɨm mɨn iətəm nəhmtɨlah tiəkɨs, motəfən kəm in. Kəmotəfən aiən u kol toraip-oraip, mɨne nati kəti mɨn iətəm nəmiəvɨn təuvɨr nian kuvan e nɨgəm, nərgɨn u frankɨnsens, mɨne fomat iətəm nəmiəvɨn təuvɨr, nərgɨn u mɨr. ");
INSERT INTO tnp_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kəni Uhgɨn təməniəhu ilah e nəməhlairiən məmə okəsohtəlɨg-pəniən o Kig Herot Asoli. Kəni inəha ilah kəmotauvlək e Kig Herot məhuvən=pən e suaru pɨsɨn mautəhuvən imalah ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nian nətəm koteinatɨg vivi mɨn u kəmohiet rəkɨs mɨnautəhuvən, kəni agelo kəti rəha Uhgɨn təmuva miet pətɨgəm o Josɨp e nəməhlairiən mətəni=pən kəm in məmə, “Əhtul uəhai, mələs suakəku ilau rəhan məmə, onəklagɨm mɨhluvən əpəha Ijɨp. Kəni onəklatɨg əha ikɨn mɨlətəuarus=pən iəu əmə iəkəni=pɨnə mɨn kəm ik məmə onəklɨtəlɨg=pa mɨn, mətəu-inu otəsuvəhiən, Kig Herot Asoli otəsal e suakəku u məmə otohamu.” ");
INSERT INTO tnp_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kəni əmeiko e nian əmə əha lapɨn, Josɨp təməhtul mələs suakəku ilau rəhan məmə mɨhlagɨm mɨhluvən əpəha Ijɨp. ");
INSERT INTO tnp_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Kəni kəməhlatɨg e nɨtəni əha mɨlətəuarus Kig Herot Asoli tɨmɨs. Nati u tɨnuva məmə otol nɨpəhriəniən e nəghatiən iətəm Iərmənɨg təməni rəkɨs aupən e nəghatiən rəha iəni kəti tətəni lanu lan məmə, “Iəmauɨn e nətɨk iərman məmə otiet rəkɨs Ijɨp.” ");
INSERT INTO tnp_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kəni e nian Kig Herot Asoli təməhrun məmə nətəm koteinatɨg vivi e məhau mɨn kəməsotoliən nəuian motauvlək e suaru pɨsɨn motagɨm, kəni nɨkin təmahmə pɨk agɨn. Kəni in təmahli=pən rəhan mɨn soldiə mɨn məmə okəhuvən Petlehem mɨne ikɨn mɨn rəfin tɨtəlau lan, məmə okotəsal e nəpəou mɨn nəman rəhalah nu təsapirəkɨsiən nu keiu, kəni okotohamu rəfin ilah. In təmɨtəpɨn nu keiu lanəha mətəu-inu nɨkin təməhti məmə nian əhruahru əha iətəm nətəm koteinatɨg kəmoteh məhau lan. ");
INSERT INTO tnp_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Natimnati mɨn u təmol nəghatiən u tuva mol nɨpəhriəniən lan iətəm iəni Jerɨmaiə təməni rəkɨs aupən ikɨn məmə, ");
INSERT INTO tnp_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Nətəm Ramə kəmotətəu pətan kəti tətasək mətasək mətəu-inu tətətəu tərah agɨn. Pətan əha in Reijel, in tətasək o nenətɨn mɨn. Kəni məsolkeikeiən məmə iətəmi kəti otuva məghati məfəri mɨn rəhan nətəlɨgiən mətəu-inu nenətɨn mɨn kɨnohmɨs rəfin.” ");
INSERT INTO tnp_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Uərisɨg e nian Kig Herot Asoli təmɨmɨs, mətəu Josɨp mɨne Meri mɨne suakəku kəhlatɨg əhanəh əpəha Ijɨp, kəni agelo kəti rəha Uhgɨn təmuva o Josɨp e nəməhlairiən kəti mətəni=pən kəm in məmə, ");
INSERT INTO tnp_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Josɨp. Əhtul mələs suakəku mɨne rəhan mamə kəni mɨhlɨtəlɨg=pən e nɨtəni Isrel, mətəu-inu nətəmi mɨn u kəmotolkeikei məmə okotohamu suakəku, ilah kɨnohmɨs rəkɨs.” ");
INSERT INTO tnp_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kəni Josɨp təməhtul mələs suakəku əha mɨne rəhan mamə, kəni mɨhlɨtəlɨg=pən mɨn e nɨtəni əha Isrel. ");
INSERT INTO tnp_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mətəu nian Josɨp təmətəu məmə Akeleas təmos nɨmei rəhan tatə Kig Herot Asoli mətarmənɨg e Jutiə, kəni in təməgɨn e nɨtəlɨg-pəniən Jutiə. Kəni Uhgɨn təməghati kəm Josɨp e nəməhlairiən kəti mɨn məmə in otəsuvəniən Jutiə, kəni təmiet muvən ikɨn pɨsɨn e nɨtəni asoli Kaləli. ");
INSERT INTO tnp_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kəni kəmhluvən məhlatɨg e nɨtəni əha Kaləli e taun u Nasərɨt. Nati u tɨnuva məmə otol nəghatiən rəha iəni mɨn rəha Uhgɨn aupən otuva mol nɨpəhriəniən. Ilah kəmotəni=pən məmə, “Okotəni məmə in iətəm Nasərɨt.” ");
INSERT INTO tnp_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nu mɨn nəuvein tɨnuva mɨnuvən rəkɨs, kəni Jon Bəptais təmiet pətɨgəm, kəni mətəni pətɨgəm nəghatiən rəha Uhgɨn əpəha Jutiə ikɨn təpiə-məpiə ikɨn, ");
INSERT INTO tnp_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","mətəni məmə, “Otəuhlin itəmah e rəhatəmah noliən tərah mɨn, kəni məhuvən o Uhgɨn, mətəu-inu, nian iətəm Uhgɨn otarmənɨg e nətəmimi rəfin tɨnuva iuəkɨr.” ");
INSERT INTO tnp_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon Bəptais u, iətəm Aiseə, iəni rəha Uhgɨn aupən, təmətəghati lan məmə, “Suah kəti tətauɨn əpəha təpiə-məpiə ikɨn mətəni məmə, ‘Itəmah, otol əpenə-penə e suaru rəha Iərmənɨg, kəni motol rəhan suaru təhruahru.’” ");
INSERT INTO tnp_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon tatuvən e napən iətəm kəmol e nɨmeimei nati miəgəh kəti kətəni məmə kaməl, kəni rəhan kətəuti kəmol e nɨlosɨ kau, kəni nɨgɨn nauəniən, tatun pitu mɨne nəhu sukəpak. ");
INSERT INTO tnp_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kəni nətəmimi tepət kəmotsɨpən Jerusɨləm, mɨne ikɨn mɨn e nɨtəni Jutiə, mɨne ikɨn mɨn iuəkɨr o nəhu əha Jotən, kəməhuva məmə okoteruh Jon. ");
INSERT INTO tnp_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kəni kəmotəni pətɨgəm rəhalah noliən tərah mɨn, kəni in təmol bəptais e lah e nəhu əha Jotən. ");
INSERT INTO tnp_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mətəu nian Jon təmafu məmə Farəsi mɨn mɨne Satusi mɨn tepət kəməhuva məmə otol bəptais e lah, kəni təməni=pən kəm lah məmə, “!Itəmah nəkotəhmen e təgəluə mɨn! Rəhatəmah noliən tekəu-ekəu. Nɨkitəmah təsəhtiən məmə, nəmə nautol əmə bəptais u, kəni onəkotagɨm rəkɨs e nalpɨniən mɨne niəməha rəha Uhgɨn iətəm otuva. !Kəpə! ");
INSERT INTO tnp_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Otol natimnati iətəm kautəgətun məmə nəmotəlali e nətəlɨgiən rəhatəmah, motəpəh pəhriən noliən tərah mɨn, kəni məhuvən o Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","“Kəni sotəni aruiən kəm təmah e nəfəriən məmə itəmah nəkotəhruahru əmə mətəu-inu itəmah nəuanɨləuɨs mɨn rəha Epraham. !Kəpə! Inu nati əpnapɨn əmə. Iətəni kəm təmah məmə nati əpnapɨn kəpiel mɨn əmə, mətəu Uhgɨn təhrun nəuhliniən ilah kəhuva nəuanɨləuɨs mɨn rəha Epraham. ");
INSERT INTO tnp_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mətəu-inu rəueiu mɨne, Uhgɨn tɨnəhtul maru rəkɨs məmə otəuahli nɨgi iətəm təsəuəiən e nəuan iətəm təuvɨr. Kəni in otəuahli=pən nɨgi əpəha e nəukətɨn məraki=pən lan e nɨgəm. ");
INSERT INTO tnp_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Rəueiu, iatol bəptais e təmah e nəhu mətəu-inu, itəmah nəmotəuhlin rəhatəmah nətəlɨgiən e noliən tərah mɨn rəhatəmah. Mətəu iətəmimi kəti otuva iətəm rəhan nəsanəniən mɨne nepətiən tapirəkɨs iəu. Kəni iəu ləhtəni agɨn, iəsəhmen-pəniən məmə iəkos rəhan put təhmen e iol əhruin. Kəni suah kəha, in otol bəptais e təmah e Narmɨn Rəha Uhgɨn mɨne nɨgəm. ");
INSERT INTO tnp_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","In tətəhtul maru o nakiliən noliən rəha nətəmimi məmə otəuəri nətəmimi, təhmen=pən e iətəmi tətasum mətəuəri rəkɨs nəua wit təuvɨr mɨne nɨlosɨ wit tərah. Tatos nəua wit təuvɨr matuvən lahuənu. Mətəu tətəraki=pən e nɨlosɨ wit tərah e nɨgəm asoli iətəm tatuəu naunun tɨkə.” ");
INSERT INTO tnp_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kəni Iesu təmiet e nɨtəni Kaləli muva e nəhu Jotən məmə Jon otol bəptais lan. ");
INSERT INTO tnp_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Mətəu Jon tətəniəhu əskasɨk in məni=pən məmə, “Təhruahru əmə məmə ik onəkol bəptais lak. ?Təhro nətuva məmə iəkol bəptais lam?” ");
INSERT INTO tnp_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mətəu Iesu təməni=pən kəm in məmə, “Kəpə. Pəh otol lan u rəueiu. E noliən əha, kilau okuol nati kəti iətəm Uhgɨn tolkeikei.” Kəni Jon təmegəhan lan. ");
INSERT INTO tnp_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kəni Jon təmol bəptais e Iesu, kəni rəueiu agɨn Iesu təməri e nəhu, kəni əmeiko negəu e neai təməuag, kəni təmeruh Narmɨn Rəha Uhgɨn təmeiuaiu=pa təhmen e mak, kəni məharəg-pəri lan. ");
INSERT INTO tnp_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kəni nəuia Uhgɨn təmsɨpəri e neai mətəni məmə, “Inu nətɨk keikei iətəm iəkolkeikei pɨk, kəni nɨkik tagiən pɨk ohni.” ");
INSERT INTO tnp_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kəni Narmɨn Rəha Uhgɨn təməghati=pən e nɨki Iesu məmə in otuvən əpəha ikɨn təpiə-məpiə ikɨn məmə Setən otəfən-əfən kəm in. Kəni Iesu təmuvən ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kəni Iesu təməpəh nauəniən o nian fote, e nərauiə mɨne lapɨn, kəni uərisɨg lan nəumɨs təmus pɨk. ");
INSERT INTO tnp_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kəni Setən təmuva mɨnatəfən-əfən kəm Iesu məni=pən kəm in məmə, “Nəmə ik Nətɨ Uhgɨn, əni=pən kəm kəpiel mɨn pəh kotəuhlin ilah məhuva motol pɨret lan.” ");
INSERT INTO tnp_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mətəu Iesu təmuhalpɨn nəghatiən rəha Setən məmə, “Kəmətei e Nauəuə Rəha Uhgɨn məmə, ‘Nətəmimi ko kəsotəmiəgəhiən e nauəniən əmə, mətəu okotatɨg e nəghatiən mɨn rəfin iətəm tatsɨpən o Uhgɨn.’” ");
INSERT INTO tnp_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kəni Setən təmit Iesu mian əpəha Jerusɨləm, e nəhue nimə əpəha ilɨs agɨn e Nimə Rəha Uhgɨn, ");
INSERT INTO tnp_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","kəni məni=pən kəm Iesu məmə, “Nəmə ik Nətɨ Uhgɨn, iuvɨg pətɨgəm, mətəu-inu Nauəuə Rəha Uhgɨn tətəni məmə, ‘Uhgɨn otəni=pən kəm rəhan nagelo mɨn məmə okotəsal vivi lam, kəni motələs ik əpə ilɨs e nəhlmɨlah məmə nəsoriniən nəhlkəm nəuvetɨn e kəpiel.’” ");
INSERT INTO tnp_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Kəni Iesu təmuhalpɨn nəghatiən rəha Setən məmə, “Nauəuə Rəha Uhgɨn tətəni mɨn məmə, ‘Ko nəsəfən-əfəniən kəm rəhatəmah Iərmənɨg Uhgɨn matol məmə in tətatɨg itəmah min, uə kəpə.’” ");
INSERT INTO tnp_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kəni Setən təmit mɨn Iesu mian əpəha ilɨs e nɨtəuət asoli, kəni məgətun in e nɨtənimtəni mɨn rəfin, mɨne nepətiən rəhalah, mɨne natimnati təuvɨr agɨn mɨn rəfin iətəm kəutatɨg lan, ");
INSERT INTO tnp_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","kəni təməni=pən kəm Iesu məmə, “Natimnati mɨn rəfin mɨn əha, iəkəfɨnə kəm ik məmə onətarmənɨg e lah, nəmə nəkasiəulɨn=pa kəni məfaki=pa kəm iəu.” ");
INSERT INTO tnp_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kəni Iesu təmuhalpɨn rəhan nəghatiən məmə, “!Amərəkɨs muvən isəu, Setən! Nauəuə Rəha Uhgɨn tətəni məmə, ‘Onəkotəfaki əmə kəm rəhatəmah Iərmənɨg Uhgɨn, kəni in əmə, onautol əmə rəhan nətəlɨgiən.’” ");
INSERT INTO tnp_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kəni Setən təmagɨm məpəh Iesu, kəni nagelo mɨn kəməhuva motasiru lan. ");
INSERT INTO tnp_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kəni e nian əha, kəmaskəlɨm Jon Bəptais kləfən e kaləpus. Kəni nian Iesu təmətəu nəghatiən lan, kəni in təmiet muvən e taun Nasərɨt e nɨtəni Kaləli. ");
INSERT INTO tnp_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kəni ko uərisɨg, təməpəh natɨgiən Nasərɨt, kəni miet muvən əpəha ləuahtəni e taun kəti, nərgɨn u Kapeniəm, iuəkɨr o nəhu Lek Kaləli, kəni mətatɨg ikɨn əha e nɨtəni asoli rəha nəuanɨləuɨs mɨn rəha Sepulun mɨne Naptali aupən. ");
INSERT INTO tnp_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Təmuvən ikɨn əha məmə nəghatiən rəha iəni Aiseə otuva mol nɨpəhriəniən lan iətəm təməni aupən məmə, ");
INSERT INTO tnp_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Nɨftəni rəha nəuanɨləuɨs rəha Sepulun, mɨne nɨftəni rəha nəuanɨləuɨs rəha Naptali tətəməhli e suaru tatuvən e nəhu Lek Kaləli, nəven=pən e nəhu Jotən. Inu nɨtəni asoli Kaləli, ima Nanihluə mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nətəmi ikɨn kəmotatɨg e napinəpuiən, mətəu kəmoteruh nəhagəhagiən asoli kəti. Kəni tɨnatian, kəni nəhagəhagiən asoli təmasiəgəpɨn ilah nətəm kəmotatɨg e napinəpuiən rəha nɨmɨsiən u tətəhtərain ilah nian rəfin.” ");
INSERT INTO tnp_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kəni mətuəuin e nian əha, Iesu təmətəni pətɨgəm nəghatiən rəha Uhgɨn mətəni məmə, “Otəuhlin itəmah e rəhatəmah noliən tərah mɨn, kəni mohtəlɨg=pən o Uhgɨn, mətəu-inu Narmənɨgiən Rəha Uhgɨn tɨnatuva iuəkɨr.” ");
INSERT INTO tnp_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iesu təmətaliuək e nɨkalɨ nəhu Lek Kaləli, kəni meruh suah mil keiu ilau pian, Antɨru mɨne Saimon, u nərgɨn kəti mɨn u Pitə. Ilau kətuatu e net e nəhu Lek Kaləli mətəu-inu ilau iətəmimi mil rəha niuviən nəmu mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Kəni təməni=pən kəm lau məmə, “Iəuva, muɨtəu=pa iəu, miəuva rəhak iətəmimi mil, kəni iəu iəkol itəlau nəkiəuva iətəmimi mil rəha niuviən nətəmimi məmə okəhuva rəhak mɨn nətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kəni rəueiu agɨn, ilau kəmuəpəh rəhalau net, kəni muɨtəu=pən. ");
INSERT INTO tnp_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kəni Iesu təmaliuək muvən nəuan nəuvetɨn mɨn, kəni meruh suah mil keiu mɨn ilau pian, nərgɨlau u Jemɨs mɨne Jon, nətɨ Səpəti mil. Kətuəharəg e nɨpəgnəua bot ilahal rəhalau tatə mətuəhli vivi rəhalau mɨn net. Kəni Iesu təmauɨn e lau məmə okiəuva miauərisɨg lan. ");
INSERT INTO tnp_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kəni rəueiu agɨn, ilau kəmuəhtul muəpəh bot mɨne tatə rəhalau, kəni miatəu=pən Iesu. ");
INSERT INTO tnp_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kəni Iesu təmaliuək ikɨn mɨn rəfin e nɨtəni Kaləli, mətəgətun nətəmimi əpəha e nimə mɨn rəha nuhapumɨniən, kəni mətəni pətɨgəm nanusiən təuvɨr rəha Uhgɨn kəm nətəmimi, kəni matol vivi nətəmimi nətəm kautohmɨs e nɨmɨsiən rəfin, mɨne nətəmimi nətəm nɨpətɨlah tərah o nɨmɨsiən rəfin. ");
INSERT INTO tnp_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kəni nanusiən e Iesu təmɨtəlau rəfin e profens ikɨn Sɨriə, kəni nətəmimi kəmotos nətəmimi rəfin nətəm kautohmɨs məhuva o Iesu, rəhalah nɨmɨsiən tol mɨn lanu: nəuvein kautohmɨs, nəuvein nɨpətɨlah tətahmə, nəuvein narmɨn tərah tətatɨg e lah, nəuvein kautos nɨmɨsiən rəha mənɨg məutauɨt, kəni nəuvein nɨpətɨlah nəuvetɨn təmɨmɨs. Mətəu Iesu təmol vivi ilah. ");
INSERT INTO tnp_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kəni nɨmənin nətəmimi kəmohiet e ikɨn mɨn rəfin. Mohiet e nɨtəni Kaləli, mɨne ikɨn Tekapolɨs, mɨne Jerusɨləm əpəha Jutiə, mɨne ikɨn pɨsɨn mɨn nəuvein əpəha Jutiə, mɨne ikɨn mɨn nəven=pən e nəhu Jotən kəni ilah rəfin kəməhuarisɨg e Iesu. ");
INSERT INTO tnp_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nian Iesu təmeruh nɨmənin nətəmimi nətəm kəutohtəu=pən in, kəni in təmuvən əpəha ilɨs e nɨtəuət, kəni mətəharəg, kəni rəhan nətəmimi nətəm kautəhuərisɨg lan, ilah kəməhuva. ");
INSERT INTO tnp_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Kəni mɨnətuəuin mətəgətun ilah. Iesu təməni məmə, ");
INSERT INTO tnp_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Nəkəutatɨg e nəuvɨriən pəhriən nian nautosiahu itəmah, məutəni e nɨkitəmah məmə nəutəhtul=pən əmə e Uhgɨn. In nəuvɨriən pəhriən mətəu-inu, itəmah nətəmimi rəha Uhgɨn, kəni in tətarmənɨg e təmah. ");
INSERT INTO tnp_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nəkotatɨg e nəuvɨriən pəhriən nian nəutasək kəni nɨkitəmah tətahmə. In nəuvɨriən pəhriən mətəu-inu, Uhgɨn otosiahu nɨkitəmah. ");
INSERT INTO tnp_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nəkotatɨg e nəuvɨriən pəhriən nian nəsotəfəri aruiən itəmah. In nəuvɨriən pəhriən mətəu-inu, o nian kəti Uhgɨn otəfɨnə nəhue nɨftəni kəm təmah u rəhan mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nəkotatɨg e nəuvɨriən pəhriən nian nəkotolkeikei pɨk e nɨkitəmah rəfin agɨn məmə nəmiəgəhiən rəhatəmah otəhruahru e nəhmtɨ Uhgɨn. In nəuvɨriən pəhriən mətəu-inu, Uhgɨn otol itəmah nəkotəhruahru. ");
INSERT INTO tnp_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nəkotatɨg e nəuvɨriən pəhriən nian nəkotasəkəhruin nətəmimi. In nəuvɨriən pəhriən mətəu-inu, Uhgɨn otasəkəhruin itəmah. ");
INSERT INTO tnp_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nəkotatɨg e nəuvɨriən pəhriən nian nɨkitəmah təhruahru məuvɨr. In nəuvɨriən pəhriən mətəu-inu, onəkoteruh Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nəkotatɨg e nəuvɨriən pəhriən nian itəmah nətəmimi rəha nələhuiən nəməlinuiən. In nəuvɨriən pəhriən mətəu-inu, okauɨn e təmah məmə nenətɨ Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nəkotatɨg e nəuvɨriən pəhriən nian nautol natimnati iətəm kotəhruahru e nəhmtɨ Uhgɨn, kəni nətəmimi kautol tərah kəm təmah ohni. In nəuvɨriən pəhriən mətəu-inu, itəmah nətəmimi rəha Uhgɨn, kəni in tətarmənɨg e təmah. ");
INSERT INTO tnp_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Nəkotatɨg e nəuvɨriən pəhriən nian nətəmimi kautol natimnati mɨn tərah kəm təmah mətəu-inu itəmah nətəmimi rəhak, inəha kəutəni rah itəmah, kəni məutərəkɨn itəmah, kəni məuteiuə e təmah məutəni nəghatiən tərah mɨn məutərəkɨn itəmah lan. ");
INSERT INTO tnp_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nɨpəhriəniən, nətəmimi kəmautol noliən əhmen mɨn əmə kəm iəni mɨn aupən ikɨn iətəm ilah kautol kəm təmah. Kəni otagiən pɨk, mətəu-inu nətəouiən asoli rəhatəmah tətatɨg əpah e negəu e neai. ");
INSERT INTO tnp_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Itəmah nəkotəhmen e sol o nətəmimi rəfin e nəhue nɨftəni. Mətəu nəmə rəhan nətəhiən tɨnɨkə, otəhro muva mətəhiən mɨn? !Təsəuvɨr mɨniən o nati kəti mɨn! Okəraki lan, kəni nətəmimi okotaliuək lan. ");
INSERT INTO tnp_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Itəmah nəhagəhagiən rəha nətəmimi e nəhue nɨftəni. Taun iətəm kəmol əpəha ilɨs e nɨtəuət, ko təsəhluaigiən. ");
INSERT INTO tnp_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kəni iətəmimi kəti tɨkə məmə otasiəpən e lait, kəni masuəpəpɨm lan e bəkɨt. Kəpə, nian tasiəpən e lait, kəni in otəkeikei maharu-pəri ilɨs, ikɨn lait tətəharəg ikɨn məmə lait otasiəgəpɨn rəfin nɨpəgnəua nimə o nətəmimi rəfin. ");
INSERT INTO tnp_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kəni e noliən əhmen mɨn əmə, otol rəhatəmah lait e nəmiəgəhiən rəhatəmah tasiə məmə nətəmimi okoteruh uək təuvɨr mɨn iətəm itəmah nautol, kəni ilah okotəfəri nərgɨ tatə Uhgɨn iətəm tətatɨg e negəu e neai.” ");
INSERT INTO tnp_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Kəni Iesu təmətəkeikei mətəni=pən kəm lah məmə, “Məta nɨkitəmah təhti məmə iəmuva məmə iəkərəkɨn Lou iətəm Uhgɨn təməfən kəm Mosɨs mɨne iəni mɨn aupən. !Kəpə! Iəməsuvaiən məmə iəkərəkɨn ilah, mətəu iəmuva məmə iəkol nɨpətɨ nəghatiən pəhriən mɨn əha okəhuva motol nɨpəhriəniən. ");
INSERT INTO tnp_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Pəhriən, iatəni kəm təmah məmə nian nɨftəni mɨne neai kətuatɨg, kəni Lou, in mɨn otətatɨg. Kəni ko nati kəti otəsɨkəiən lan, nati əpnapɨn in letə əkəku agɨn, kəni Lou otəhtul matol uək mətəuarus=pa nəghatiən mɨn rəfin rəha Lou kəhuva motol nɨpəhriəniən lan. ");
INSERT INTO tnp_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kəni, o nati əha inəha, iətəmi kəti iətəm təpəh Lou mətəgətun nətəmimi mɨn məmə ilah mɨn okotəpəh, nati əpnapɨn in Lou kəti ləhtəni agɨn, kəni okotauɨn e iətəmi əha məmə in ləhtəni agɨn e Narmənɨgiən Rəha Uhgɨn. Mətəu iətəmi kəti iətəm tatol Lou mɨn əha, mətəgətun nətəmimi lan, kəni okotauɨn e iətəmi əha məmə in ilɨs agɨn e Narmənɨgiən Rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Iatəni lanəha kəm təmah mətəu-inu, rəhatəmah noliən otəkeikei məhruahru vivi agɨn e nəhmtɨ Uhgɨn, tapirəkɨs noliən mɨn rəha Farəsi mɨn mɨne nəgətun mɨn rəha Lou nətəm nɨkilah əmə təhti məmə kotəhruahru vivi. Nəmə rəham noliən təsəhruahru viviən lanəha lan, kəni ko nəsuvəniən matɨg ahgəl Narmənɨgiən Rəha Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Kəni Iesu təməni mɨn məmə, “Itəmah nəmotətəu rəkɨs nəghatiən iətəm nəgətun mɨn kəmotəni kəm kəha mɨn rəhatəmah aupən. Ilah kəmotəni məmə, ‘Sotohamuiən itəmi,’ kəni ‘Iətəmimi iətəm təmohamu iətəmi, otəkeikei məhtul e nəhmtɨ kot mos nalpɨniən.’ ");
INSERT INTO tnp_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mətəu iəu iətəni kəm təmah məmə, nəmə iətəmi kəti niəməha tatol əmə o nati kəti pian təmol, kəni təhruahru məmə iətəmi əha iətəm niəməha təmol, otəhtul e nəhmtɨ kot. Kəni nəmə iətəmi kəti tətəni rah pian, kəni təhruahru məmə in otəhtul e nəhmtɨ kaunsɨl asoli. Kəni nəmə iətəmi kəti təuiakən e iətəmi kəti, kəni təhruahru məmə iətəmi təməni nəghatiən əha otuvən e nɨgəm asoli. ");
INSERT INTO tnp_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Kəni o nati əha inəha, nəmə nian natuvən e oltə e Nimə Rəha Uhgɨn məmə onəkəfən nati kəm Uhgɨn, mətəu ikɨn əha, nɨkim tɨnəhti piam iətəm tatol niəməha kəm ik o nati kəti nəmol lan təsəhmeniən, ");
INSERT INTO tnp_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","əpəh pɨpɨm rəham nati əha, kəni muvən meruh piam muələhu əhruahru nətəlɨgiən rəhatəlau, muəpəh noliən tɨkɨmɨr, miəuva matuol kətiəh, kəni uərisɨg nəpanɨtəlɨg muvən məfən nati kəti rəham kəm Uhgɨn e oltə əpəha e Nimə Rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Kəni nəmə nəmol nati kəti təsəhmeniən e iətəmimi kəti, kəni iətəmi u tolkeikei məmə otələs ik nəkian e kot, təuvɨr məmə nəkuvən uəhai əmə, nian nəsian əhanəhiən e kot, kəni muələhu əhruahru pɨpɨm nɨpəgnəmtɨn rəhatəlau. Nəmə nəkəpəh, iətəmimi u otləfən ik e nəhlmɨ iətəm tətakil nəghatiən, kəni iətəm tətakil nəghatiən otləfən ik e nəhlmɨ polɨs, kəni polɨs otləfən ik e kaləpus. ");
INSERT INTO tnp_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nɨpəhriəniən iatəni kəm təmah məmə, nəmə tol lanəha, ko nəsietiən e kaləpus mətəuarus nəkəkeikei mətəou e məni rəfin agɨn o nalpɨniən rəham.” ");
INSERT INTO tnp_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Kəni Iesu tətəkeikei mətəni=pən kəm lah məmə, “Itəmah nəmotətəu rəkɨs nəghatiən u məmə, ‘Itəmah nətəm nəmotol rəkɨs marɨt, nəsotakləhiən e nɨpətan pɨsɨn mɨn.’ ");
INSERT INTO tnp_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mətəu iəu, iəu iətəni kəm təmah məmə nian suah kəti iətəm tɨnol rəkɨs marɨt tateruh pətan pɨsɨn kəti matolkeikei məmə otakləh lan, kəni in tɨnol rəkɨs təfagə tərah e nɨkin, təhmen əmə məmə in tɨnakləh pəhriən lan. ");
INSERT INTO tnp_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nəmə nəhmtəm tol ik natol təfagə, kəni təuvɨr məmə nəkələs rəkɨs məraki lan. Təməuvɨr məmə nɨpətɨm nəuvetɨn tɨkə, tapirəkɨs agɨn nəmə nɨpətɨm rəfin okəraki=pən e nɨgəm asoli u naunun tɨkə. ");
INSERT INTO tnp_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kəni nəmə nəhlməm tol ik natol təfagə, kəni təuvɨr məmə nəkətahtuv rəkɨs məraki lan. Təməuvɨr məmə nɨpətɨm nəuvetɨn tɨkə, tapirəkɨs agɨn məmə nɨpətɨm rəfin okəraki=pən lan e nɨgəm asoli u naunun tɨkə.” ");
INSERT INTO tnp_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Kəni Iesu təməni mɨn məmə, “Itəmah nəmotətəu rəkɨs nəghatiən u məmə, ‘Iətəmimi iətəm otəpəh rəhan pətan, in otəkeikei məfən nauəuə kəti kəm in iətəm tətəgətun məmə in tɨnəpəh.’ ");
INSERT INTO tnp_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mətəu iəu, iəu iətəni kəm təmah məmə, nəmə iərman kəti iətəm təmol marɨt tatol tifos mətəpəh rəhan pətan, mətəu pətan u təsapɨliən ilau suah pɨsɨn kəti, kəni rəhan iərman tatol təfagə tərah. Kəni nəmə pətan əha tatɨtəu=pən suah pɨsɨn, kəni pətan əha tatol təfagə, mətəu nəmkarəpəniən rəha iərman rəhan aupən. Kəni suah u iətəm tatit pətan əha, in mɨn tatol təfagə.” ");
INSERT INTO tnp_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Kəni Iesu təməni mɨn məmə, “Nəmotətəu rəkɨs nəghatiən kəti mɨn iətəm nəgətun mɨn kəmotəni kəm rəhatah kəha mɨn aupən məmə, ‘Nəsotatgəhliən nonauvɨl mɨn rəhatəmah iətəm nəmotos, mətəu nəkotəkeikei motol nati nak nəmotos nonauvɨl lan kəm Uhgɨn məmə nəkotol.’ ");
INSERT INTO tnp_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mətəu iəu, iəu iətəni kəm təmah məmə, sotos əməiən nonauvɨl e nati kəti məmə otol rəhatəmah nəghatiən təskasɨk. Sotosiən nonauvɨl e negəu e neai mətəu inu ikɨn əha Uhgɨn tətarmənɨg lan, kəni noliən əha təhmen məmə nautos nonauvɨl e Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kəni sotosiən nonauvɨl e nəhue nɨftəni mətəu-inu ikɨn əha Uhgɨn tətarmənɨg lan, kəni noliən əha təhmen məmə nautos nonauvɨl e Uhgɨn. Kəni sotosiən nonauvɨl e Jerusɨləm mətəu-inu ikɨn əha in taun rəha Uhgɨn, u in Kig asoli ikɨn, kəni noliən əha təhmen məmə nautos nonauvɨl e Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kəni sotosiən nonauvɨl e rəhn-kapə təmah, mətəu-inu rəhatəmah nəsanəniən tɨkə lan. Nəkotəruru nəuhliniən nəuanutəmah kətiəh əmə tuva məruən uə mapɨn. Uhgɨn əmə tətarmənɨg e natimnati e nəmiəgəhiən rəhatəmah. Kəni noliən əha təhmen məmə nautos nonauvɨl e Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mətəu nian rəfin onəkotəni əmə nɨpəhriəniən, nati kəti mɨn tɨkə. Kəni nəmə rəhatəmah nətəlɨgiən e nati kəti in ‘əuəh,’ kəni nəkotəni əmə məmə, ‘əuəh.’ Kəni nəmə rəhatəmah nətəlɨgiən e nati kəti in ‘kəpə,’ kəni nəkotəni əmə məmə, ‘kəpə.’ Nəghatiən mɨn iətəm kotapirəkɨs ‘əuəh’ uə ‘kəpə,’ kautsɨpən e Setən.” ");
INSERT INTO tnp_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Kəni Iesu təmətəkeikei mətəni məmə, “Nəmotətəu rəkɨs nəghatiən kəti məmə, ‘Nəmə iətəmi kəti tərəkɨn nəhmtəm kəti, kəni nətəmimi okotərəkɨn mɨn nəhmtɨn kəti. Kəni nəmə iətəmi kəti tərəkɨn nəhluvm kəti, kəni nətəmimi okotərəkɨn mɨn nəhluvn kəti.’ ");
INSERT INTO tnp_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mətəu iəu, iəu iətəni kəm təmah məmə, nəsalpɨniən nərahiən iətəm iətəmimi kəti təmol kəm ik. Nəmə iətəmi kəti tahi ik mem nɨkapɨm maru, kəni nəkəkeikei malelin=pən mɨn nɨkapɨm məuɨl pəh tem mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kəni nəmə iətəmi kəti tələs ik nəkian e kot, kəni mətəkeikei ohnik məmə nəkəfən rəham sot əkəku kəm in məmə otol vivi rəhatəlau nərahiən, kəni nəkəkeikei məfən mɨn rəham sot asoli. ");
INSERT INTO tnp_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kəni nəmə soldiə kəti rəha nətəm Rom tətəkeikei ohnik məmə nəkələs rəhan kətɨm muvən kilomitə kətiəh, mətəu ik nəkəkeikei mələs mɨn muvən kilomitə kəti mɨn tol keiu. ");
INSERT INTO tnp_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nəmə iətəmi kəti təteasiə ohnik, kəni ik nəkəkeikei məfən kəm in. Kəni nəmə iətəmi kəti tolkeikei məmə in otos rəham nati kəti muvən konu mos mɨtəlɨg mɨn muva, kəni nəsəniən məmə nəkəpəh. Nəkəkeikei məfən.” ");
INSERT INTO tnp_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Kəni Iesu təməni mɨn məmə, “Nəmotətəu rəkɨs məmə, ‘Onəkotolkeikei nətəmi mɨn u iuəkɨr o təmah, kəni mətəməki e tɨkɨmɨr mɨn rəhatəmah.’ ");
INSERT INTO tnp_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mətəu iəu, iəu iətəni kəm təmah məmə onəkotolkeikei rəhatəmah tɨkɨmɨr mɨn, kəni motəfaki o nətəmimi mɨn u nətəm kautol nərahiən kəm təmah, ");
INSERT INTO tnp_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","kəni noliən əha otəgətun məmə itəmah nenətɨ Uhgɨn rəhatəmah iətəm tətatɨg ilɨs e negəu e neai. Kəni otol lanəha mətəu-inu rəhatəmah Uhgɨn tatol mɨtɨgar tətasiəgəpɨn nətəmimi nətəm kotəuvɨr mɨne nətəmimi nətəm kotərah, kəni in mətahli=pa nuhuən kəm nətəmimi mɨn u nətəm rəhalah nəmiəgəhiən təhruahru, mɨne nətəmimi mɨn u nətəm rəhalah nəmiəgəhiən təsəhruahruiən. ");
INSERT INTO tnp_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","“?Nəmə nəkotolkeikei əmə nətəmimi mɨn u nətəm kotolkeikei itəmah, kəni nɨkitəmah təhti məmə Uhgɨn otətəou itəmah o noliən kəti iətəm təuvɨr? !Kəpə! !Nətəmimi mɨn u nətəm kautos məni rəha takɨs, iətəm kətəni məmə nətəmimi ilah kotərah, ilah mɨn kotolkeikei ilah mɨn! ");
INSERT INTO tnp_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","“?Kəni nəmə nəkotos əmə itəmah mɨn nəuvein məutəghati kəm lah mɨn, mətəu təhro? ?Nɨkitəmah təhti məmə nautol nati kəti iətəm təuvɨr tapirəkɨs nətəmimi əpnapɨn? Kəpə. Nətəmimi mɨn nətəm kəsotəhruniən Uhgɨn, ilah mɨn kautol lanəha. ");
INSERT INTO tnp_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tol lanəha, itəmah nenətɨ Uhgɨn nəkotəkeikei motol noliən iətəm in təuvɨr məhruahru nian rəfin, təhmen=pən əmə məmə rəhatəmah Tatə Uhgɨn in tatol.” ");
INSERT INTO tnp_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Kəni Iesu təməni mɨn məmə, “Sotoliən məmə nəkotol noliən təuvɨr mɨn məmə nətəmimi okoteruh itəmah ohni. Nəmə nəkotol məmə nətəmimi okoteh, kəni Uhgɨn əpəha e negəu e neai otəsətəouiən itəmah ohni. ");
INSERT INTO tnp_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Tol lanəha, nəmə nəkotəfən nati kəti kəm nanrah mɨn məmə nəkotasiru e lah, nəsotahliən təui lan məmə nətəmimi okotəhrun. Inu təhmen e noliən rəha nəfaki eiuə mɨn. Nian ilah kotasiru e nanrah mɨn, rəhalah noluək mɨn kəutəni pətɨgəm e nimə rəha nuhapumɨniən mɨne ihluə e suaru asoli. Kautol lanəha məmə nətəmimi okotɨsiai ilah. Nɨpəhriəniən iətəni kəm təmah məmə, ilah kɨnotos rəkɨs nətəouiən rəhalah, inəha nɨsiaiən rəha nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mətəu itəmah, nəmə nəkotəfən nati kəti kəm nanrah mɨn məmə nəkotasiru e lah, nəkotəkeikei motol məmə nətəmimi okəsoteruhiən, nati əpnapɨn rəhatəmah mɨn nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Otol lanəha məmə nətəmimi okotəruru rəhatəmah noliən təuvɨr mɨn, kəni rəhatəmah Tatə iətəm tateruh rəhatəmah noliən təuvɨr mɨn nati əpnapɨn nətəmimi kəsoteruhiən, in otətəou itəmah o noliən mɨn əha.” ");
INSERT INTO tnp_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Kəni Iesu təmətəkeikei mətəni məmə, “Nian nəkotəghati kəm Uhgɨn e nəfakiən, kəni sotoliən e noliən rəha nəfaki eiuə mɨn. Nətəmimi mɨn əha, ilah kotolkeikei məmə okotəhtul əpəha e nimə rəha nuhapumɨniən, mɨne ihluə e suaru asoli, kəni motəfaki məmə nətəmimi okotafu motətəu ilah. Nɨpəhriəniən iətəni kəm təmah məmə ilah kɨnotos rəkɨs nətəouiən rəhalah, inəha nɨsiaiən rəha nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mətəu nian nəkotəghati kəm Uhgɨn e nəfakiən, nəkəhuvən əpəha e nɨpəgnəua nimə rəhatəmah, kəni motahtɨpəsɨg, kəni motəfaki kəm Uhgɨn iətəm tətatɨg ikɨn əha iətəm nətəmimi kəsoteruhiən itəmah. Kəni rəhatəmah Tatə iətəm tateh rəhatəmah noliən oneuən mɨn, in otətəou itəmah o rəhatəmah noliən təuvɨr mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Kəni nian nəkotəghati kəm Uhgɨn e nəfakiən, sotoriaruniən nəghatiən mɨn tepət pɨk u nɨpətɨn tɨkə, təhmen e nətəm kotəruru Uhgɨn. Nɨkilah təhti məmə rəhalah uhgɨn mɨn okotətəu ilah o nəghatiən mɨn tepət iətəm kəutəfaki məutəni. ");
INSERT INTO tnp_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Sotoliən məmə ilah mɨne, mətəu-inu uərisɨg nəkotətapuəh ohni, mətəu rəhatəmah Tatə Uhgɨn tɨnəhrun rəkɨs nati nak iətəm nəkotolkeikei. ");
INSERT INTO tnp_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Kəni tol mɨn lanəha, nian nəkotəghati kəm Uhgɨn e nəfakiən, kəni nəkotəfaki lanu lan: ‘Tatə rəhatɨmah iətəm nətatɨg e negəu e neai, pəh nətəmimi kotɨsiai ik. ");
INSERT INTO tnp_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Pəh narmənɨgiən rəham tuva, kəni pəh nati iətəm ik nəkolkeikei in otuva mol nɨpəhriəniən lan u ikɨnu e nəhue nɨftəni, təhmen=pən əmə mə inko ilɨs e negəu e neai. ");
INSERT INTO tnp_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Əfa-to nauəniən kəm tɨmah təhmen o nian rəueiu. ");
INSERT INTO tnp_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kəni alu məsalpɨniən, noliən tərah mɨn rəhatɨmah, təhmen=pən əmə məmə itɨmah iəsotalpɨniən motalu lan kəni məsotaskəlɨm əskasɨkiən e nɨkitɨmah noliən tərah mɨn rəha nətəmimi nətəm kautol nərahiən kəm tɨmah. ");
INSERT INTO tnp_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kəni segəhaniən e tɨmah iəkəhuvən ima nəfeifeiən, məta oiəkotəkeikei motol noliən tərah. Mətəu os rəkɨs itəmah e nəhlmɨ Setən.’ ");
INSERT INTO tnp_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Nəmə itəmah nəkotalu e noliən tərah mɨn rəha nətəmimi iətəm kautol e təmah məsotaskəlɨm iəkɨsiən e nɨkitəmah məsotalpɨniən, kəni rəhatəmah Tatə Uhgɨn e negəu e neai, in otalu məsalpɨniən rəhatəmah noliən tərah mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mətəu nəmə itəmah nəsotaluiən, motaskəlɨm iəkɨs e nɨkitəmah noliən tərah mɨn rəha nətəmimi iətəm kautol e təmah, motalpɨn, kəni ko rəhatəmah Tatə Uhgɨn otəsaluiən kəni malpɨn noliən tərah mɨn rəhatəmah.” ");
INSERT INTO tnp_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Kəni Iesu təmətəni mɨn məmə, “Nian nəkotətuakəm motəpəh nauəniən motəfaki kəm Uhgɨn, sotoliən nəhmtɨtəmah təpəou təhmen=pən e nəfaki eiuə mɨn. Ilah kautol nəhmtɨlah tol pɨsɨn, məmə nətəmimi okoteruh ilah məmə nəumɨs tɨnus ilah, kəni nətəmimi okotɨsiai ilah. Nɨpəhriəniən iətəni kəm təmah məmə ilah kɨnotos rəkɨs nətəouiən rəhalah, inəha nɨsiaiən rəha nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mətəu nian nəkotətuakəm motəpəh nauəniən məutəfaki kəm Uhgɨn, onəkoteikuas e nəhmtɨtəmah, kəni motol məmə okeruh məmə nəkotəuvɨr. ");
INSERT INTO tnp_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Nautol lanəha məmə nətəmimi okəsoteruhiən məmə nəutətuakəm məutəpəh nauəniən mautəfaki kəm Uhgɨn. Kəni rəhatəmah Tatə iətəm tateruh rəhatəmah noliən oneuən mɨn, in otətəou itəmah o rəhatəmah noliən təuvɨr mɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Kəni Iesu təmətəni mɨn məmə, “Təsəuvɨriən məmə nəkotoriarun rəhatəmah natimnati təuvɨr mɨn e nəhue nɨftəni u məmə rəhatəmah nautə otepət, mətəu-inu e nəhue nɨftəni u, uvni mɨn kotəhrun noarehreiən, kəni namrəiən təhrun nərəkɨniən natimnati mɨn əha, kəni nakləh mɨn kotəhrun nəhapuiən nimə məhuvən imə motakləh e rəhatəmah natimnati. ");
INSERT INTO tnp_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mətəu təuvɨr məmə nəkotoriarun rəhatəmah natimnati təuvɨr mɨn əpəha e negəu e neai. Ikɨn əha uvni mɨn kəsotoarehreiən, kəni namrəiən ko təsərəkɨniən natimnati mɨn əha, kəni nakləh mɨn ko kəsotakləhiən lan. ");
INSERT INTO tnp_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nəukətɨ nətəlɨgiən u məmə onəsotaluiən lan məmə, ikɨn pəhruvən rəhatəmah natimnati təuvɨr mɨn kəutəməhli ikɨn, mətəu nian rəfin nɨkitəmah otəkeikei mətəhti natimnati mɨn əha ikɨn əha. ");
INSERT INTO tnp_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Nəhmtəm in təhmen e lait iətəm tətəfɨnə nəhagəhagiən kəm nɨpətɨm. Nəmə nəhmtəm mil kuəuvɨr, təhmen əmə məmə nɨpətɨm təriauəh e nəhagəhagiən. ");
INSERT INTO tnp_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mətəu nəmə nəhmtəm mil kuərah, təhmen əmə məmə nɨpətɨm in təriauəh e napinəpuiən. !Kəni nəmə nəhagəhagiən e nɨpətɨm in napinəpuiən əmə, təhmen əmə məmə ik nətatɨg e napinəpuiən asoli agɨn! ");
INSERT INTO tnp_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Iətəmimi tɨkə iətəm təhrun nuvaiən in slef rəha iətəmi asoli keiu. Nəmə in tətalkut məmə otol lanəha, kəni otolkeikei kəti mol nəuian, kəni məməki e kəti məsoliən nəuian. Ko nəsoliən slef rəha Uhgɨn mɨne məni e nian kətiəh əmə.” ");
INSERT INTO tnp_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Kəni Iesu təməni məmə, “Kəni o natimnati mɨn əha, iəu iətəni kəm təmah məmə, təsəuvɨriən məmə nəkotətəlɨg pɨk e rəhatəmah nəmiəgəhiən məmə onəkotun nak, kəni motəmnɨm nak. Kəni təsəuvɨriən məmə nəkotətəlɨg pɨk e nɨpətɨtəmah məmə onəkotos iə rəhatəmah napən. ?Nəukətɨ nəmiəgəhiən rəhatəmah tətəmiəgəh əmə e nauəniən, uə kəpə? Kəpə. ?Kəni nati nak in nati asoli o nɨpətɨtəmah? ?Napən, uə kəpə? Kəpə. ");
INSERT INTO tnp_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Oteruh-to mənɨg mɨn iətəm kautiuvɨg məutan. Ilah kəsotasumiən, kəni məsotəuləkiən, kəni ilah kəsotələhu viviən nauəniən e nɨpəgnəua nimə, mətəu Tatə rəhatəmah e negəu e neai, in tətəfən nauəniən kəm lah. ?Kəni e nəhmtɨn, nɨkitəmah təhti məmə in tolkeikei pɨk itəmah tapirəkɨs mənɨg mɨn? !Əuəh! ");
INSERT INTO tnp_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","?Nɨkitəmah təhti məmə rəhatəmah nətəlɨg pɨkiən təhrun noliən rəhatəmah nəmiəgəhiən təfəməh? !Kəpə! Noliən rəha nətəlɨg pɨkiən təsəfɨnəiən auə kətiəh mɨn e rəhatəmah nəmiəgəhiən. ");
INSERT INTO tnp_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“?Kəni təhro nɨkitəmah tətəhti pɨk napən onəkəhuvən lan? Nɨkitəmah təhti-to nəugɨ nɨgi mɨn iətəm kauteviə əpnapɨn əmə. Ilah kəsotol pɨkiən uək o nəhliən rəhalah napən. ");
INSERT INTO tnp_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mətəu iəkəni kəm təmah məmə aupən Kig Solomən, in iətəmimi rəhan nautə tepət, kəni rəhan napən iətəm tatuvən lan, ilah kotəuvɨr motapirəkɨs. Mətəu nəugɨ nɨgi əpnapɨn mɨn kotəuvɨr tapirəkɨs agɨn rəhan napən. ");
INSERT INTO tnp_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Uhgɨn təmol nɨmanuvehli əpnapɨn əmə təuvɨr pɨk e nəugɨ nɨgi mɨn əha. Mətəu nɨmanuvehli əha in rəha nian kətiəh əmə, kəni olauɨg kuvan e nɨgəm. ?Kəni nəmə Uhgɨn tatol vivi nɨmanuvehli əha, kəni nɨkitəmah təhti məmə Uhgɨn otəfɨnə napən iətəm nəkotəkeikei məhuvən lan? !Əuəh! In otol lanəha. !Ei, rəhatəmah nəhatətəiən in təkəku agɨn! ");
INSERT INTO tnp_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Tol lanəha, təsəuvɨriən məmə itəmah nəkotətəlɨg pɨk məmə, ‘?Iəkotun nak?’ uə ‘?Iəkotəmnɨm nak?’ uə ‘?Iəkotos iə napən məhuvən lan?’ ");
INSERT INTO tnp_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Sotətəlɨg pɨkiən. Nətəmimi nətəm kotəruru Uhgɨn, ilah kautətəlɨg pɨk e natimnati iətəm tol lanəha. Mətəu itəmah nenətɨ Uhgɨn mɨn, kəni rəhatəmah Tatə əpəha e negəu e neai, in təhrun məmə nəkotəkeikei motos natimnati mɨn əha. ");
INSERT INTO tnp_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mətəu pəh onəkotol Narmənɨgiən Rəha Uhgɨn, mɨne nəmiəgəhiən əhruahru iətəm Uhgɨn tolkeikei, ilau okuəhtul aupən e nəmiəgəhiən rəhatəmah. Nian nəkotol lanəha, kəni Uhgɨn otəfɨnə mɨn natimnati mɨn əha kəm təmah o natɨgiən. ");
INSERT INTO tnp_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tol lanəha, təsəuvɨriən məmə nəkotətəlɨg pɨk e natimnati iətəm onəkotəkeikei motos olauɨg, mətəu-inu natimnati mɨn rəha olauɨg, ilah rəha olauɨg. Nərahiən rəha nian kətiəh, in tɨnəhmen rəkɨs rəha nian kətiəh. ");
INSERT INTO tnp_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Nəmə nəutakil rah nətəmimi, kəni Uhgɨn otələhu nəghatiən rəha nalpɨniən rəhatəmah. ");
INSERT INTO tnp_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tol lanəha mətəu-inu, nəghatiən əskasɨk iətəm nəutəni məmə iətəmi kəti in iətəmi tərah, kəni Uhgɨn otɨtəu=pən əmə o nəniən rəhatəmah noliən tərah mɨn. Nəmə nəkotakil iətəmimi e noliən iətəm təhruahru, kəni Uhgɨn otakil itəmah e noliən iətəm təhruahru. Mətəu nəmə nəkotakil rah nətəmimi e noliən əskasɨk, kəni Uhgɨn otakil itəmah e noliən əhmen mɨn əmə. ");
INSERT INTO tnp_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","?Təhro nəutəni nɨpɨspɨsɨ nɨgi iətəm tətatɨg e nəhmtɨ piatəmah mɨn, mətəu itəmah nəsoteruhiən nɨgi asoli iətəm tətatɨg e nəhmtɨtəmah? ");
INSERT INTO tnp_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","?Kəni təhro nəutəni məmə, ‘Ei piak, pəh iəkos rəkɨs nɨpɨspɨsɨ nɨgi e nəhmtəm,’ mətəu nəsoteruhiən nɨgi asoli e nəhmtɨtəmah? ");
INSERT INTO tnp_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","!Itəmah nəfaki eiuə mɨn! Otaupən, motos rəkɨs nɨgi asoli e nəhmtɨtəmah, kəni nəkotəhrun neruh viviən noh rəkɨsiən nɨpɨspɨsɨ nɨgi iətəm tətatɨg e nəhmtɨ piatəmah mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Sotəfəniən natimnati rəha Uhgɨn kəm kuri mɨn, kəni sotəraki-pəniən natimnati təuvɨr mɨn kəm pɨkəh mɨn. Okəmə nəkotol lanəha, kəni pɨkəh mɨn okotaliuək lan kəni motəlali motus itəmah.” ");
INSERT INTO tnp_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Kəni Iesu təmətəkeikei mətəni məmə, “Iəkəni kəm təmah məmə, otətapuəh=pən kəm Uhgɨn o natimnati, kəni in otəfɨnə kəm təmah. Kəni otəsal lan kəni onəkoteruh. Kəni otəhti-əhti doə, kəni doə oterəh o təmah. ");
INSERT INTO tnp_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Iəkəni lanu mətəu-inu nətəmimi rəfin nətəm kəutətapuəh, ilah okotos. Kəni nətəmimi mɨn u nətəm kəutəsal, ilah okoteruh. Kəni nətəmimi mɨn u kəutəhti-əhti doə, kəni doə oterəh o lah. ");
INSERT INTO tnp_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“?Itəmah pəh, nian nətɨn tətapuəh o pɨret, mətəu in tətəfən kəpiel? !Kəpə! ");
INSERT INTO tnp_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","?Uə, nian in tətapuəh e nəmu, mətəu in tətəfən sɨneik? !Kəpə! ");
INSERT INTO tnp_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nati əpnapɨn itəmah nətəmimi nəkotərah, mətəu nəutəfən natimnati təuvɨr mɨn kəm nenətɨtəmah mɨn. !Mətəu Tatə Uhgɨn e negəu e neai, noliən rəhan in təuvɨr pɨk mapirəkɨs agɨn noliən rəhatəmah, kəni nɨpəhriəniən, in otəfən natimnati təuvɨr mɨn kəm nətəmimi mɨn u ilah kəutətapuəh ohni! ");
INSERT INTO tnp_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Kəni tol lanəha, otol təuvɨr kəm nətəmimi rəfin e noliən mɨn rəfin iətəm nəkotolkeikei məmə nətəmimi okotol kəm təmah. Inu nɨpətɨ Lou iətəm Uhgɨn təməfən kəm Mosɨs, mɨne nəukətɨ nəghatiən iətəm təməfən kəm iəni mɨn aupən.” ");
INSERT INTO tnp_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Iesu təməni mɨn məmə, “Itəmah onəkotəkeikei məhuvən=pən e ket iətəm təkəku, mətəu-inu ket iətəm iahgin mɨne suaru iətəm tɨmətɨg əmə tatuvən o nərəkɨniən, kəni nətəmimi tepət kautəhuvən=pən e ket əha. ");
INSERT INTO tnp_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mətəu ket iətəm təkəku, mɨne suaru iətəm tiəkɨs tatuvən o nəmiəgəhiən, kəni nətəmimi nəuan nəuvein əmə okoteruh kəni motohtəu=pən.” ");
INSERT INTO tnp_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Kəni Iesu təməni məmə, “Autətəu vivi itəmah o iəni eiuə mɨn. Ilah kəutəhuva məutəghati mətɨg e noliən əpəou təhmen e sipsip, mətəu əpəha imə e nɨkilah, ilah kotəhmen e kuri arpɨn. ");
INSERT INTO tnp_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kəni e nəmiəgəhiən rəhalah, nəkoteruh nəuan, kəni nəkotəhrun nak tətatɨg e nɨkilah. Nətəmimi ko kəsəhuvəniən motəhli nəua krep e nɨləuɨs arfu, uə nəua fik e təliluə. ");
INSERT INTO tnp_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tol mɨn lanu, nɨgi iətəm təuvɨr tətəuə e nəuan iətəm təuvɨr, mətəu nɨgi iətəm tərah tətəuə e nəuan iətəm tərah. ");
INSERT INTO tnp_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kəni nɨgi iətəm təuvɨr ko təsəuəiən e nəuan iətəm tərah, kəni nɨgi iətəm tərah, ko təsəuəiən e nəuan iətəm təuvɨr. ");
INSERT INTO tnp_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nɨgi mɨn rəfin iətəm kəsotəuəiən e nəualah iətəm təuvɨr, okətei rəkɨs ilah, kəraki=pən e lah e nɨgəm. ");
INSERT INTO tnp_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Tol lanəha, e nəmiəgəhiən rəha iəni eiuə mɨn əha, onəkoteruh nəua lah, kəni nəkotəhrun nak tətatɨg e nɨkilah. ");
INSERT INTO tnp_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Səniəmə nətəmimi rəfin nətəm kəutauɨn lak məutəni məmə, ‘Iərmənɨg, Iərmənɨg,’ nətəm ilah kotəhrun nuvəniən motatɨg ahgəl Narmənɨgiən Rəha Uhgɨn, mətəu ilah mɨn əmə u, nətəm kautol nəuia rəhak Tatə iətəm tətatɨg e negəu e neai. ");
INSERT INTO tnp_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","E nian Uhgɨn otakil nətəmimi rəfin, nətəmimi tepət okotəni=pən kəm in məmə, ‘!Iərmənɨg, Iərmənɨg! ?Təhro? ?Nəkəhrun uə kəpə məmə, itɨmah iəmautəni pətɨgəm nəghatiən rəham iətəm nəməfa kəm tɨmah, kəni motəhgi pətɨgəm narmɨn tərah mɨn e nərgəm, kəni mautol natimnati apɨspɨs mɨn e nərgəm?’ ");
INSERT INTO tnp_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kəni oiəkəni=pən əhruahru kəm lah məmə, ‘Aupən iəkəruru, kəni rəueiu mɨn iəkəruru itəmah. Itəmah səniəmə rəhak mɨn nətəmimi. !Əhuvən isəu ohniəu, itəmah nətəm nautol noliən tərah!’” ");
INSERT INTO tnp_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Kəni Iesu təmol naunun e rəhan nəghatiən məmə, “Nəmə itəmah u nətəm nəmotətəu nəghatiən mɨn u rəhak mautol, kəni onəkotəhmen e iətəmimi iətəm teinatɨg, təmuvləkɨn rəhan nimə təskasɨk, mel pos mɨn kəuteiuaiu məhuvən isəu məgərain tiəkɨs. ");
INSERT INTO tnp_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kəni nuhuən təməfuv, kəni naruəh taiu, kəni nɨmətagi asoli talɨfu moh nimə. Mətəu nimə təsəmeiən mətəu-inu təmuvləkɨn rəhan nimə təskasɨk. ");
INSERT INTO tnp_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nəmə itəmah u nətəm nəmotətəu nəghatiən mɨn u rəhak kəni məsotoliən, kəni onəkotəhmen e iətəmimi iətəm təsətəlɨg viviən e noliən natimnati, kəni in ialməli, təməseliən rəhan pos mɨn kəhuvən əpəha isəu, maharu rəkɨs əmə əpə ilɨs, kəni rəhan nimə təsəskasɨkiən. ");
INSERT INTO tnp_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kəni nuhuən təməfuv, kəni naruəh taiu, kəni nɨmətagi asoli talɨfu moh nimə. Kəni nimə təməmei. E nian təməmei, kəni mərah agɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kəni nian Iesu təmol naunun e nəghatiən rəhan, kəni nətəmimi narmɨlah təmiuvɨg pɨk ohni, ");
INSERT INTO tnp_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","mətəu-inu nian tətəgətun, səniəmə təhmen e rəhalah nəgətun mɨn rəha Lou, mətəu rəhan nəghatiən təfɨgəm, nepətiən əha ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nian Iesu təmeiuaiu=pa e nɨtəuət, nətəmimi tepət kəmohtəu=pən. ");
INSERT INTO tnp_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kəni suah kəti nɨmɨsiən u leprosi təmol təmuva ohni, masiəulɨn=pən o Iesu, kəni məni məmə, “Iərmənɨg, nəmə nəkolkeikei, kəni nəkəhrun nol viviən iəu kəni mafəl rəkɨs namɨkmɨkiən lak.” ");
INSERT INTO tnp_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kəni Iesu təmuahru e nəhlmɨn mələhu=pən lan, məni məmə, “Əuəh. Iəkolkeikei. !Əuvɨr-tə!” Kəni rəueiu agɨn mɨn, nɨmɨsiən u leprosi təmɨkə lan. ");
INSERT INTO tnp_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kəni Iesu təməni=pən kəm in məmə, “Səni pətɨgəmiən natimnati mɨn u kəm nətəmimi, mətəu uvən əmə meruh pris kəti pəh in teruh məmə nɨpətɨm tɨnəuvɨr lankonu lan, kəni əfən kəm in nati u iətəm Lou rəha Mosɨs təməni o iətəmi kəti iətəm rəhan leprosi tɨnɨkə, kəni nətəmimi okotəhrun məmə nɨpəhriəniən nɨnəuvɨr, kəni rəham namɨkmɨkiən tɨnɨkə.” ");
INSERT INTO tnp_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kəni Iesu təmuvən miet pətɨgəm əpəha e taun Kapeniəm, kəni iətəmi asoli kəti rəha soldiə mɨn rəha nətəm Rom təmuva meruh Iesu, kəni mətasək=pən ohni mətəni məmə, ");
INSERT INTO tnp_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Iərmənɨg, rəhak ioluək tatɨmɨs, kəni mətapɨli əpəha e nimə rəhak, nɨpətɨn rəfin təmɨmɨs, kəni tətətəu tərah pɨk.” ");
INSERT INTO tnp_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Kəni Iesu təməni=pən kəm in məmə, “Oiəkuvnə mol in təuvɨr mɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kəni iətəmi asoli rəha soldiə mɨn təməni=pən kəm in məmə, “Iərmənɨg, iəu iətəmi kəti iətəm iəsəhruahruiən, kəni iəsəhmeniən məmə ik onəkuva e rəhak nɨpəgnəua nimə. Əni əmə nəghatiən kəti, kəni iəkəhrun məmə in otətəu təuvɨr mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Iəkəhrun məmə ik natos narmənɨgiən məmə nɨmɨsiən otəkeikei mol nəuiam. Iəkəhrun mətəu-inu iəu mɨn, rəhak nətəmi asoli mɨn kəutarmənɨg lak, kəni iatol nəuialah. Kəni soldiə mɨn nəuvein əha ikɨn nətəm iəu iətarmənɨg e lah. Nəmə iəkəni kəm kəti məmə, ‘Uvən,’ kəni tuvən. Kəni nəmə iəkəni kəm kəti məmə, ‘Va,’ kəni tuva. Kəni nəmə iəkəni kəm rəhak slef məmə, ‘Ol nati u,’ kəni tol nati əha.” ");
INSERT INTO tnp_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nian Iesu təmətəu nəghatiən əha, kəni narmɨn təmiuvɨg pɨk ohni, mətəu-inu nati əpnapɨn səniəmə in iətəm Isrel, mətəu rəhan nəhatətəiən təskasɨk e Uhgɨn. Kəni təməni=pən kəm nətəmimi nətəm kautəhuərisɨg lan məmə, “Nɨpəhriəniən iətəni kəm təmah məmə, iətəmi u səniəmə iətəm Isrel, mətəu in rəhan nəhatətəiən e Uhgɨn in təskasɨk. Kəni nati əpnapɨn nəuanɨləuɨs mɨn rəha Isrel, mətəu iəsehiən ilah kəti iətəm rəhan nəhatətəiən təskasɨk təhmen=pən lan. ");
INSERT INTO tnp_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Iatəni kəm təmah məmə nətəmimi tepət okotsɨpən e nɨkalɨn mɨn rəfin rəha nəhue nɨftəni, məhuva motauən kətiəh e tepɨl ilah Epraham, mɨne Aisək, mɨne Jekəp əpəha e narmənɨgiən əpəha e negəu e neai. ");
INSERT INTO tnp_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Mətəu itəmah nəuanɨləuɨs rəha Isrel tepət nətəm Uhgɨn təmaupən mɨtəpɨn itəmah məmə in otarmənɨg e təmah, in otəraki=pən e təmah ihluə e napinəpuiən, kəni ikɨn əha, nətəmimi okotasək kəni motətəu tərah, kəni mautɨgət-ərain nəhluvlah mɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kəni Iesu təməni=pən kəm iətəmi asoli rəha soldiə mɨn məmə, “Atuvən. Rəham ioluək otəuvɨr tol əmə məmə inu mɨne nəməhatətə məmə Uhgɨn otol lanko.” Kəni e nian əhruahru əha, nɨpətɨ ioluək rəha iətəmi asoli rəha soldiə mɨn təmuva məuvɨr mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kəni təmuvən e nimə rəha Pitə, kəni muvən imə meruh uhu Pitə tətətəpu ətəpu mətapɨli. ");
INSERT INTO tnp_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kəni təmuahru e nəhlmɨn mek nəhlmɨ pətauəhli u, kəni nətəpu ətəpuiən tɨkə rəkɨs lan magɨm, kəni təhtul. Kəni mɨnatol nauəniən nɨg Iesu. ");
INSERT INTO tnp_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tɨnapinəpu mɨtɨgar tɨnatiuvɨg, nətəmimi kəmotos nətəmimi tepət nətəm narmɨn tərah tətatɨg e lah məhuva o Iesu, kəni Iesu təməhgi pətɨgəm narmɨn tərah mɨn e nəghatiən əmə rəhan, kəni mol vivi nətəmimi rəfin nətəm kautohmɨs. ");
INSERT INTO tnp_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Natimnati mɨn əha təmol lanəha məmə otol nəghatiən rəha iəni Aiseə tuva mol nɨpəhriəniən lan, iətəm təməni aupən ikɨn məmə, “In təmos rəkɨs nɨmɨsiən mɨn rəhatah, kəni mol nɨpətɨtah mɨn u kəutahmə, kotəuvɨr.” ");
INSERT INTO tnp_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kəni nian Iesu təməsal=pən meruh nɨmənin nətəmimi kautəhuərisɨg məhuva mohtəlau lan, kəni təməni=pən kəm rəhan mɨn nətəmimi məmə okəhuvən e nɨkalɨ lek e nɨtəni=pən. ");
INSERT INTO tnp_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kəni iəgətun kəti rəha Lou təmuva məni=pən kəm in məmə, “Iəgətun. Onəkuvən=pən iə ikɨn, iəkɨtəu=pən ik.” ");
INSERT INTO tnp_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Kəni Iesu təməni=pən kəm in məmə, “Kuri rarpɨn mɨn, rəhalah nɨpəg tatɨg məmə okotapɨli ikɨn. Kəni mənɨg mɨn, nimaalah tatɨg məmə okotapɨli ikɨn. Mətəu iəu Nətɨ Iətəmimi, nimə rəhak tɨkə o napɨliən.” ");
INSERT INTO tnp_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kəni iətəmimi kəti mɨn rəha Iesu təmuva məni=pən kəm in məmə, “Iərmənɨg. Oiəkɨtəu=pən ik mətəu, pəh iəkuvən pɨpɨm mɨtənɨm rəhak tatə.” ");
INSERT INTO tnp_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Mətəu Iesu təməni=pən kəm in məmə, “Ɨtəu=pa iəu. Nətəmimi nətəm kəsotoliən nəuia Uhgɨn, təhmen əmə məmə ilah kɨnohmɨs rəkɨs e nɨkilah. Pəh ilah okəhuvən mohtənɨm rəhalah nətəmimi nətəm kəmohmɨs.” ");
INSERT INTO tnp_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kəni Iesu təmuvən e bot, kəni rəhan mɨn nətəmimi kəhuvən ilah min. ");
INSERT INTO tnp_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kəni təsuvəhiən, nɨmətagi asoli kəti təhtul kəni mɨnol peau-peau asoli mɨn e lek, kəni nəhu tətəri=pən e bot, iuəkɨr əmə bot tətamnɨm, mətəu Iesu tətapɨli. ");
INSERT INTO tnp_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kəni kəməhuvən motəhgi-pəri Iesu motəni=pən məmə, “!Iərmənɨg! !Osmiəgəh itah! !Otəsuvəhiən kotamnɨm!” ");
INSERT INTO tnp_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kəni Iesu təməni=pən kəm lah məmə, “?Təhro nəutəgɨn pɨk? Rəhatəmah nəhatətəiən təkəku agɨn.” Kəni təməhtul məniəhu nɨmətagi mɨne peau-peau asoli mɨn. Kəni nɨmətagi təmeiuaiu, kəni mol nəməlinuiən asoli. ");
INSERT INTO tnp_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kəni nətəmimi rəha Iesu narmɨlah təmiuvɨg pɨk mautəni məmə, “!Ei! ?Iətəmimi nak u? Nati əpnapɨn nɨmətagi mɨne nəhu, mətəu ilau kəmuol nəuian.” ");
INSERT INTO tnp_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kəni nian Iesu təmuva miet=pa e nɨtəni=pən e lek, ikɨn Katara, kəni iətəmimi keiu narmɨn tərah mɨn kəutatɨg e lau kəmiaiet pətɨgəm=pa məmə okueruh Iesu. Ilau kəmiasɨpən e nɨpəg kəpiel mɨn, ikɨn katɨtənɨm nətəmimi ikɨn. Ilau kuəsanən matuoh nətəmimi, kəni nətəmimi kəutəgɨn e nuvən-pəniən ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Kəni əmeiko narmɨn tərah mɨn u kəutatɨg e lau kəmotagət əfəməh motəni məmə, “!Ik Nətɨ Uhgɨn! ?Nəmuva məmə nəkəhro itɨmah? ?Nəmuva məmə nəkol uəhai əmə nalpɨniən kəm tɨmah iətəm təsol əhanəhiən nian əhruahru rəhan?” ");
INSERT INTO tnp_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Iuəkɨr əmə o lah, pɨkəh mɨn tepət əha ikɨn kəutauən, ");
INSERT INTO tnp_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","kəni narmɨn tərah mɨn kotasək=pən o Iesu motəni məmə, “Nəmə nəkəhgi pətɨgəm itɨmah, ahli=pən itɨmah iəkəhuvən e pɨkəh mɨn əha.” ");
INSERT INTO tnp_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kəni Iesu təməni=pən kəm lah məmə, “Əhuvən.” Kəni narmɨn tərah mɨn kəmohiet e lau, motaiu məhuvən e pɨkəh mɨn. Kəni pɨkəh mɨn ilah rəfin kəmotaiu məuteiuaiu e nɨpatu, kəni motiuvɨg=pən e nəhu motamnɨm. ");
INSERT INTO tnp_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kəni nətəmimi nətəm kəutaugɨn pɨkəh mɨn, kəmotagɨm məhuvən e taun motəni pətɨgəm natimnati rəfin, mɨne natimnati iətəm Iesu təmol e suah mil u narmɨn tərah mɨn kəutatɨg e lau. ");
INSERT INTO tnp_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kəni əmeiko nətəmimi rəfin rəha taun kəməhuva məmə okotafu Iesu. Kəni nian kəmoteruh in, kəni kəməutəkeikei əskasɨk kəm in məmə otəkeikei miet əha ikɨn əha. ");
INSERT INTO tnp_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kəni Iesu təmuvən e bot muvən e nɨtəni=pən e lek, kəni miet pətɨgəm iman ikɨn, e taun Kapeniəm. ");
INSERT INTO tnp_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kəni nətəmimi nəuvein kəmotələs iətəmimi kəti məhuva ohni. Nɨpətɨn nəuvetɨn təmɨmɨs, kəni tətapɨli e rəhan nɨmahan. Kəni nian Iesu təmeruh rəhalah nəhatətəiən, kəni təməni=pən kəm iətəmimi əha məmə, “Nətɨk, səgɨniən. Rəham noliən tərah mɨn iəmos rəkɨs rəkɨs.” ");
INSERT INTO tnp_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kəni nian kəmotətəu nəghatiən əha, nəgətun mɨn nəuvein rəha Lou kotəni=pən kəm lah mɨn məmə, “Nəghatiən əha tərah. Suah kəha tətəghati təhmen məmə in Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Mətəu Iesu təhrun nətəlɨgiən rəhalah kəni təməni=pən kəm lah məmə, “?Təhro itəmah nəutos nətəlɨgiən iətəm tərah mɨn lanu lan? ");
INSERT INTO tnp_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","?In pəhruvən tɨmətɨg məmə oiəkəni, məmə, ‘Iəmafəl rəkɨs rəham noliən tərah mɨn,’ uə ‘Əhtul maliuək’? ");
INSERT INTO tnp_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kəni rəueiu iəkol nati kəti məmə nəkotəhrun məmə Nətɨ Iətəmimi tatos nepətiən ikɨnu e nəhue nɨftəni məmə otafəl rəkɨs təfagə tərah mɨn.” Kəni in təməni=pən kəm suah kəha tatɨmɨs məmə, “Əhtul mos rəham nɨmahan maliuək matuvən lahuənu.” ");
INSERT INTO tnp_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kəni suah u tatɨmɨs təməhtul maliuək matuvən lahuənu. ");
INSERT INTO tnp_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kəni nian nɨmənin nətəmimi kəmotafu nati əha, kəni kəmotəgɨn, kəni motəni-vivi nərgɨ Uhgɨn iətəm təməfən nepətiən kəm iətəmimi məmə otol lanəha. ");
INSERT INTO tnp_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kəni Iesu təmaliuək muvən nəuvetɨn mɨn, mafu suah kəti, nərgɨn u Matiu. In iətəmimi iətəm tatos məni rəha takɨs, kəni tətəharəg ikɨn kətətəou=pən takɨs ikɨn. Kəni Iesu təməni=pən kəm in məmə, “Uərisɨg lak, muva iətəmimi rəhak.” Kəni in təməhtul muərisɨg e Iesu. ");
INSERT INTO tnp_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kəni Iesu təmuvən mətauən e nimə rəha Matiu, kəni nətəmimi tepət rəha nosiən məni rəha takɨs kəməhuva, kəni nətəmimi tepət nətəm kautol təfagə tərah kəməhuva, kəni ilah kəməhuva motəharəg motauən ilah Iesu mɨne rəhan mɨn nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kəni nian Farəsi mɨn kəmotafu nati əha, kəni kəmotəni=pən kəm nətəmimi rəha Iesu məmə, “?Təhro rəhatəmah iəgətun tətauən pəti ilah nətəm kautos məni rəha takɨs mɨne nətəm kautol təfagə?” ");
INSERT INTO tnp_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Mətəu Iesu təmətəu rəhalah nəghatiən kəni təməni=pən kəm lah məmə, “Iətəmimi iətəm təsɨmɨsiən təsuvəniən o toktə. Mətəu iətəmi u iətəm tatɨmɨs, in otəkeikei muvən o toktə. ");
INSERT INTO tnp_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Əhuvən moteruh-to kəni motətəlɨg əhruahru lan məmə nɨpətɨ nəghatiən u iətəm Nauəuə Rəha Uhgɨn tətəni məmə, ‘Nati kəti tatol nɨkik tətagiən, inu məmə onəkotasəkəhruin nətəmimi, mətəu səniəmə rəhatəmah sakrifais mɨn iətəm nautol məutəfa kəm iəu iətəm tatol nɨkik tətagiən.’ Iətəni tol lanu lan mətəu iəu iəməsuvaiən məmə iəkauɨn e nətəmimi mɨn u kotəni məmə kɨnotəhruahru rəkɨs. Mətəu iəmuva məmə iəkauɨn e nətəmimi mɨn u kotəhrun əmə məmə ilah kautol noliən tərah mɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kəni nətəmimi rəha Jon Bəptais kəməhuva moteruh Iesu motəni=pən kəm in məmə, “Eruh-to. Itɨmah iəutətuakəm məutəpəh nauəniən məutəfaki kəm Uhgɨn, kəni Farəsi mɨn, ilah mɨn kautol lanəha. ?Mətəu təhro rəham nətəmimi kəsotoliən lanəha?” ");
INSERT INTO tnp_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Kəni Iesu təməni=pən kəm lah məmə, “?Nian nətəmimi kautol marɨt rəha suah kəti, kəni in tətan e nauəniən rəhan ilah in mɨn nəuvein, nɨkitəmah təhti məmə in mɨn nəuvein okotasək? !Kəpə! Mətəu nian əha ikɨn iətəm tətuva məmə nətəmimi okotələs rəkɨs iətəmimi iətəmi katol nauəniən rəhan. Kəni e nian əha, in mɨn nəuvein kotəhrun nəpəhiən nauəniən. ");
INSERT INTO tnp_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Kəni iətəmimi kəti tɨkə məmə otos nəuvetɨ napən vi kəti, kəni məhli-ərain=pən e napən əmnəmɨt rəhan iətəm təməhapu, mətəu-inu nəmə tol lanəha, kəni nəuvetɨ napən vi təhrun nauvɨniən məhapuiən napən əmnəmɨt, kəni ikɨn təməhapu ikɨn aupən təhrun nuvaiən mol iahgin pɨk agɨn. ");
INSERT INTO tnp_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Kəni iətəmimi kəti tɨkə məmə otos wain iətəm kəmol vi, kəni miuvi=pən e pətəl əuas u təskasɨk iətəm kəmol e nɨlosɨ nəni. Nəmə tol lanu lan, kəni nahgi wain otahlɨfu, kəni pətəl otəhapu, kəni wain otauvəregɨn, kəni pətəl otərah. Mətəu wain kəmol vi okəkeikei kiuvi=pən e pətəl iətəm kəmol tɨmətmətɨg, kəni wain mɨne pətəl kətuəməhli vivi.” ");
INSERT INTO tnp_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nian Iesu tətəni=pən natimnati mɨn əha kəm lah, iətəmi asoli kəti tuva masiəulɨn=pən nəulɨn o Iesu məmə, “Nətɨk pətəkəku təmɨmɨs rəueiu əmə. Mətəu va, mələhu=pən nəhlməm lan, kəni otəmiəgəh mɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kəni Iesu təməhtul mɨne rəhan mɨn nətəmimi, məhuərisɨg e suah u məhuvən. ");
INSERT INTO tnp_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kəni əmeiko pətan kəti əha ikɨn iətəm tatos nɨmɨsiən rəhalah nɨpətan nian rəfin əmə, mɨnos nu tueləf. Kəni pətan əha təmsɨpən e nəmtah Iesu ikɨn, kəni meapən mek nɨfɨfɨ napən rəhan, ");
INSERT INTO tnp_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","təmol lanəha mətəu-inu tətəni aru əmə kəm in məmə, “Nəmə iəkek əmə nɨfɨfɨ napən rəhan, kəni rəhak nɨmɨsiən otol naunun.” ");
INSERT INTO tnp_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kəni Iesu təmeirair meruh pətan əha, kəni məni=pən kəm in məmə, “Nətɨk pətan, səgɨniən. E rəham nəhatətəiən lak, nɨnuva mɨnəuvɨr.” Kəni e nian əha, rəhan nɨmɨsiən təmɨkə. ");
INSERT INTO tnp_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kəni nian Iesu təmuva miet pətɨgəm=pa e nimə rəha iətəmi asoli əha, kəni təmuvən imə meruh nətəmimi kautahli nau məutani nəpuən lan rəha nɨmɨsiən, kəni nətəmimi kəməutasək pɨk. ");
INSERT INTO tnp_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Kəni Iesu təməni=pən məmə, “Ohiet məhuvən isəu, mətəu-inu pətəkəku u təsɨmɨsiən, mətəu in tətapɨli əmə.” Kəni ilah kəmotaləh əuvsan lan. ");
INSERT INTO tnp_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mətəu nian nətəmimi kəmohiet məhuvən ihluə, kəni tuvən imə, maskəlɨm nəhlmɨ pətəkəku, kəni pətəkəku u təməhtul. ");
INSERT INTO tnp_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kəni nanusiən rəha nati u təmaiu mɨtəlau rəfin e nɨtəni əha. ");
INSERT INTO tnp_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kəni nian Iesu təmiet ikɨn əha, mətəu iəmnəu mil tərah keiu kəmuɨtəu=pən in, kəni mətuagət əfəməh məmə, “!Mipɨ Kig Tefɨt, asəkəhruin itɨmlau!” ");
INSERT INTO tnp_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nian Iesu tɨnuvən əpəha imə, kəni iəmnəu tərah mil kiəuva ohni. Kəni Iesu təməni=pən kəm lau məmə, “?Itəlau nətuəhatətə məmə iəkəhrun nol viviən nəhmtɨtɨmlau, uə kəpə?” Kəni ilau kuəni=pən məmə, “Əuəh, Iərmənɨg.” ");
INSERT INTO tnp_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kəni Iesu təmələhu=pən nəhlmɨn e nəhmtɨlau məni=pən məmə, “Uhgɨn otol vivi nəhmtɨtəlau mətəu-inu nəmuəhatətə lan.” ");
INSERT INTO tnp_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kəni nəhmtɨlau təuvɨr kəni kɨnatueruh nati. Kəni Iesu təməni=pən əskasɨk kəm lau məmə, “Onəsuəni pətɨgəmiən natimnati mɨn u kəm nətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mətəu ilau kəmiaiet mian, kəni muəni pətɨgəm nanusiən rəha Iesu tuvən mɨtəlau ikɨn mɨn rəfin e nɨtəni u. ");
INSERT INTO tnp_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nian suah mil u kəmiaiet, nətəmimi kotələs iətəmi kəti təruru nəghatiən məhuva o Iesu. Suah kəha in təruru nəghatiən mətəu-inu narmɨn tərah tətatɨg lan. ");
INSERT INTO tnp_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kəni Iesu təməhgi pətɨgəm narmɨn tərah e suah kəha, kəni tɨnətəghati. Kəni nɨmənin nətəmimi narmɨlah təmiuvɨg pɨk ohni, kəni motəni məmə, “Suah kəti təsehiən nati kəti tol lanu u ikɨnu Isrel nian kəti mɨne.” ");
INSERT INTO tnp_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mətəu Farəsi mɨn kəmotəni məmə, “Tatos nəsanəniən o iətəmi asoli rəha narmɨn tərah mɨn məmə otəhgi pətɨgəm narmɨn tərah mɨn lan.” ");
INSERT INTO tnp_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Kəni Iesu təmaliuək matuvən e taun mɨne lahuənu mɨn rəfin, kəni mətəgətun əpəha e nɨpəgnəua nimə mɨn rəha nuhapumɨniən, mətəni pətɨgəm nanusiən təuvɨr rəha Narmənɨgiən Rəha Uhgɨn, kəni matol vivi nətəmimi rəfin nətəm kautohmɨs, mɨne nətəmimi rəfin nətəm nɨpətɨlah tərah kautəuvɨr. ");
INSERT INTO tnp_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nian təmeruh nɨmənin nətəmimi tɨnepət pɨk, kəni nɨkin təmepət pɨk o lah mətəu-inu kɨnotos pɨk nahməiən, kəni motəruru nasiru aruiən e rəhalah nəmiəgəhiən, kɨnotəhmen e sipsip mɨn rəhalah iətəmimi tɨkə o neruh viviən ilah. ");
INSERT INTO tnp_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kəni Iesu təməni=pən kəm rəhan mɨn nətəmimi məmə, “!Oteruh-to! Nauəniən tepət əpəha e nasumiən tɨnɨməhtə, mətəu noluək mɨn təkəku əmə kəutəulək lan. ");
INSERT INTO tnp_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Otətapuəh o iətəmi asoli rəha nasumiən məmə otahli=pa noluək mɨn tepət məmə okəhuvən motəulək e nasumiən rəhan.” ");
INSERT INTO tnp_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Kəni Iesu təmauɨn e nətəmi tueləf rəhan kəhuva kətiəh, kəni məfən nəsanəniən kəm lah məmə ilah kəhuvən motəhgi pətɨgəm narmɨn tərah mɨn e nətəmimi, kəni motəhrun nol viviən nɨmɨsiən mɨn rəfin, mɨne nətəmimi mɨn u nɨpətɨlah təmərah. ");
INSERT INTO tnp_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kəni inu nərgɨ nətəmi tueləf rəha Iesu: in aupən Saimon, u nərgɨn kəti mɨn u Pitə; mɨne notəhan Antɨru; mɨne Jemɨs mɨne pian Jon, nətɨ Səpəti mil; ");
INSERT INTO tnp_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","mɨne Fɨlɨp mɨne Patolomiu; mɨne Toməs mɨne Matiu, iətəmimi rəha nosiən məni rəha takɨs; mɨne Jemɨs nətɨ Alfiəs; mɨne Tateas; ");
INSERT INTO tnp_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","mɨne Saimon u kətauɨn lan məmə Selot; mɨne Jutəs Iskariot u təmegəhan=pən e Iesu tuvən e nəhlmɨ rəhan mɨn tɨkɨmɨr. ");
INSERT INTO tnp_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Kəni nian Iesu təmahli pətɨgəm rəhan nətəmimi tueləf məmə okəhuvən motol rəhan uək, təmaupən məghati kəm lah məmə, “Itəmah onəsəhuvəniən o nətəmi mɨn u səniəmə nəuanɨləuɨs mɨn rəha Isrel, kəni məsəhuvəniən e taun kəti rəha nətəm Səmeriə, ");
INSERT INTO tnp_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","mətəu onəkəhuvən o nəuanɨləuɨs mɨn rəha Isrel nətəm kotəhmen e sipsip mɨn kəutəluei. ");
INSERT INTO tnp_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kəni nian nəkəhuvən, nəkotəkeikei motəni pətɨgəm məmə, ‘Nian iətəm Uhgɨn otarmənɨg e nətəmimi rəfin lan, tɨnuva iuəkɨr.’ ");
INSERT INTO tnp_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","“Kəni itəmah nəkotəkeikei motol nətəm kautohmɨs kotəuvɨr mɨn. Kəni itəmah nəkotəkeikei motol nətəm kəmohmɨs kotəmiəgəh mɨn. Kəni nətəmimi nətəm leprosi tatol ilah, nəkotəkeikei motol nɨpətɨlah tuva məuvɨr mɨn. Kəni nətəmimi nətəm narmɨn tərah tətatɨg e lah, itəmah nəkotəkeikei motəhgi pətɨgəm narmɨn tərah mɨn kəhuvən isəu o lah. Kəni nəsanəniən iətəm nəmotos, nəməsotosiən nəhmtɨn. Kəni onəkotəkeikei motol əmə uək, nətəmimi okəsotətəouiən itəmah lan. ");
INSERT INTO tnp_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nian nəkəhuvən, nəsotosiən məni e rəhatəmah pauɨs. ");
INSERT INTO tnp_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kəni məsotəmkiən rəhatəmah kətɨm mɨn. Kəni napən iətəm nautəhuvən lan, in əmə ko, məsotosiən inəuau kəti mɨn. Kəni məsotosiən put, mɨne kasɨkɨn rəhatəmah mɨn. Iətəni lanu lan mətəu-inu təhruahru əmə məmə kətəfən kəm noluək mɨn natimnati iətəm təhruahru o natɨgiən rəhalah. ");
INSERT INTO tnp_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Nian nəkəhuvən e taun kəti uə lahuənu kəti, nəkotəkeikei moteh iətəmimi kəti iətəm nɨkin tagiən məmə nəkəhuvən motatɨg itəmah min, kəni nəutatɨg ikɨn əha mətəuarus=pən nian nəkohiet mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nian nəkəhuvən motatɨg e nimə kəti, nəkotəkeikei motəghati vivi kəm lah məmə, ‘Nəməlinuiən tətatɨg o təmah.’ ");
INSERT INTO tnp_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kəni nəmə nətəmimi e nɨpəgnəua nimə u, nɨkilah tagiən məmə okotos itəmah, kəni pəh rəhatəmah nəghatiən rəha nəməlinuiən tətatɨg o lah. Mətəu nəmə nɨkilah təsagiəniən o təmah, nəkotəkeikei motos nəghatiən rəha nəməlinuiən mautəhuvən. ");
INSERT INTO tnp_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","“Kəni nəmə nətəmimi nəuvein kəsotolkeikeiən məmə okotit itəmah nəkəhuvən e rəhalah nɨpəgnəua nimə, uə kəsotətəlɨgiən e rəhatəmah nəghatiən, kəni nian nautohiet e nimə rəhalah, uə rəhalah lahuənu, nəkotəkeikei motohrapɨspɨs rəkɨs nɨməulul e nəhlkɨtəmah məmə ilah okotəhrun məmə nəmotəuhlin=pən pəhriən nəmtahtəmah o lah motəpəh agɨn ilah. ");
INSERT INTO tnp_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nɨpəhriəniən iətəni kəm təmah, e nian iətəm Uhgɨn otakil nətəmimi, nalpɨniən rəha nətəmi mɨn əha in otəskasɨk pɨk mapirəkɨs nalpɨniən rəha nətəm kotərah aupən e taun mil əha, Sotəm mɨne Kəmorə.” ");
INSERT INTO tnp_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Kəni Iesu təmətəkeikei mətəni məmə, “Otətəlɨg-to. Iətahli=pən itəmah nautəhuvən təhmen e sipsip mɨn iətəm kəməhuvən e nəlugɨ kuri rarpɨn mɨn. Onəkotəkeikei moteinatɨg vivi təhmen e məlɨkɨm, kəni itəmah motan mətɨg təhmen e mənɨg mak. ");
INSERT INTO tnp_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Onəutətəu vivi itəmah o nətəmimi. Ilah okotələs itəmah məhuvən məmə nəkotəhtul e nəhmtɨ kaunsɨl rəhalah mətəu-inu itəmah nətəmimi rəhak. Kəni okotalis itəmah əpəha e nimə rəha nuhapumɨniən. ");
INSERT INTO tnp_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","“Kəni okoteikəpan itəmah nəkəhuven motəhtul e nəhmtɨ nətəmi asoli mɨn rəha kəpmən mɨn, mɨne kig mɨn məmə onəkotəni pətɨgəm nəghatiən təuvɨr rəhak e nəhmtɨlah, kəni mɨne e nəhmtɨ Nanihluə mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nian ilah okəhuva motələs itəmah, kəni nɨkitəmah təsəhti pɨkiən məmə onəkəhuvən motəni məmə nak, uə nəkotəhro lanu lan motəghati. Nəsotəgɨniən mətəu-inu Narmɨn Rəha Uhgɨn, in otəfɨnə nəghatiən iətəm onəkotəni e nian əhruahru əha. ");
INSERT INTO tnp_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nəsotəgɨniən mətəu-inu səniəmə itəmah onəkotəghati, mətəu Narmɨn Rəha rəhatəmah Tatə Uhgɨn, otəfɨnə nəghatiən kəm təmah məmə nəkotəni pətɨgəm. ");
INSERT INTO tnp_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Nətəmimi okotegəhan=pən e pialah əhruahru mɨn kəm rəhalah tɨkɨmɨr mɨn məmə okotohamu ilah, kəni tatə mɨn okotol mɨn lanəha kəm nenətɨlah əhruahru mɨn, kəni kəlkələh mɨn okotəhtul motol noliən əhmen mɨn əmə kəm rəhalah tatə mɨn mɨne mamə mɨn məmə okotohamu ilah. ");
INSERT INTO tnp_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nətəmimi rəfin okotəməki e təmah o nərgək. Mətəu iətəmi otəhtul əskasɨk mətəuarus=pən natimnati mɨn u okotol naunun, kəni Uhgɨn otosmiəgəh. ");
INSERT INTO tnp_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nian okotol tərah kəm təmah e taun kəti, kəni nəkohiet motagɨm məhuvən e taun pɨsɨn kəti mɨn. Iətəni pəhriən kəm təmah məmə ko nəsəhuvən rəfiniən e taun mɨn rəha Isrel mətəuarus=pən Nətɨ Iətəmimi in otuva mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Nətəmimi nətəm kətəgətun ilah, ko kəsotapirəkɨsiən rəhalah iəgətun. Kəni noluək mɨn, ko kəsotapirəkɨsiən rəhalah iətəmi asoli. ");
INSERT INTO tnp_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nətəm kətəgətun ilah, kotəkeikei motagiən məmə okəhuva motəhmen e iəgətun rəhalah, kəni noluək mɨn kotəkeikei motagiən məmə okəhuva motəhmen e iətəmi asoli rəhalah. Iəu, iəu iətəmi asoli rəha nimə. Nəmə nətəmimi nəuvein kotəni rah iəu məmə iəu Pielsepul, u nərgɨn kəti rəha Setən, kəni ko təhmen mɨn əmə e noluək mɨn rəha nimə rəhak. Inəha, nətəmimi okotəni rah ilah mɨn tapirəkɨs.” ");
INSERT INTO tnp_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Kəni Iesu təməni məmə, “Tol lanəha, sotəgɨniən e nətəmimi. Natimnati iətəm nətəmimi kautəht-ərain, Uhgɨn otəfətɨgəm ikɨn təhagəhag ikɨn, kəni natimnati iətəm nətəmimi kəutəhluaig lan, Uhgɨn otəfətɨgəm, nətəmimi rəfin okotafu. ");
INSERT INTO tnp_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Natimnati iətəm iətəni kəm təmah əmə əha rəueiu, itəmah onəkotəkeikei motəni pətɨgəm mɨn təhagəhag kəm nətəmimi rəfin. Kəni təhmen əmə, natimnati iətəm iətəni oneuən, itəmah onəkotəkeikei motəni pətɨgəm e nəhmtɨ nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Sotəgɨniən e nətəmimi nətəm kotəhrun nohamuiən nɨpətɨtəmah, mətəu ko kotəruru nohamuiən narmɨtəmah. Mətəu nəkotəgɨn e Uhgɨn iətəm təhrun nərəkɨniən nɨpətɨtəmah mɨne narmɨtəmah e nɨgəm asoli. ");
INSERT INTO tnp_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Oteruh-to. Nɨmənɨg əlkələh mɨn, nətəmimi kautos nəhmtɨlah e məni əkəku əmə. Mətəu nəmə rəhatəmah Tatə Uhgɨn təsegəhaniən e lah, ko kəti təsɨmɨsiən. ");
INSERT INTO tnp_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kəni Uhgɨn təhrun vivi agɨn itəmah mɨne. Kəni nati əpnapɨn nəuanutəmah ko e rəhn-kapə təmah in səniəmə nati agɨn kəti, mətəu Uhgɨn in tətafin rəfin ilah. ");
INSERT INTO tnp_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","!Tol lanəha, sotəgɨniən! Uhgɨn tolkeikei pɨk itəmah tapirəkɨs mənɨg əlkələh mɨn əha. ");
INSERT INTO tnp_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Tol lanəha, nəmə iətəmimi otəni pətɨgəm nərgək e nəhmtɨ nətəmimi, kəni iəu mɨn, iəkəni pətɨgəm nərgɨn e nəhmtɨ rəhak Tatə e negəu e neai. ");
INSERT INTO tnp_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mətəu nəmə iətəmimi otəni pətɨgəm e nəhmtɨ nətəmimi məmə in səniəmə rəhak, kəni iəkəni pətɨgəm e nəhmtɨ rəhak Tatə e negəu e neai məmə in səniəmə rəhak. ");
INSERT INTO tnp_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Nɨkitəmah təsəhtiən məmə iəmuva məmə iəkələhu nəməlinuiən e nəhue nɨftəni. Iəməsuvaiən məmə iəkələhu nəməlinuiən, mətəu iəmuva məmə iəkol nətəmimi kotərgəhu. ");
INSERT INTO tnp_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Iətəni lanəha mətəu-inu iəmuva məmə iəkol iərman mɨne rəhan tatə okətuərah o lau mɨn, kəni pətan mɨne uhun okətuərah o lau mɨn, ");
INSERT INTO tnp_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","kəni iətəmimi otol tɨkɨmɨr ilah aru rəhan mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Kəni iətəmimi iətəm tolkeikei pɨk rəhan tatə mɨne mamə tapirəkɨs iəu, in təsəhmeniən məmə otuva rəhak iətəmimi. Kəni iətəmimi iətəm tolkeikei pɨk nətɨn iərman uə pətan tapirəkɨs iəu, in təsəhmeniən məmə otuva rəhak iətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kəni iətəmimi iətəm təsələsiən rəhan nɨgi kəməluau muərisɨg lak, in təsəhmeniən məmə otuva rəhak iətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kəni iətəmimi iətəm tatol pɨk uək əmə məmə rəhan nəmiəgəhiən e nəhue nɨftəni u in otəuvɨr, otəmkarəpən e nəmiəgəhiən pəhriən. Mətəu iətəmimi iətəm otɨmɨs o nərgək, in otos nəmiəgəhiən itulɨn. ");
INSERT INTO tnp_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Kəni iətəmimi iətəm tatos itəmah e nɨkin agiən kəni təhmen əmə məmə tatos iəu e nɨkin agiən. Kəni iətəmimi iətəm tatos iəu e nɨkin agiən, kəni təhmen əmə məmə tatos iətəmi u iətəm təmahli=pa iəu. ");
INSERT INTO tnp_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kəni iətəmimi iətəm təhrun məmə suah kəti in iəni kəti rəha Uhgɨn, kəni tatos e nɨkin agiən, in otos nətəouiən lan, təhmen əmə e iətəm iəni mɨn kautos. Kəni iətəmimi iətəm tatos e nɨkin agiən iətəmi əhruahru, in otos nətəouiən lan, təhmen e iətəmi əhruahru. ");
INSERT INTO tnp_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kəni nəmə iətəmimi kəti tətəfən nati kəti kəm suah kəti mətəu-inu təhrun məmə in rəhak iətəmimi, nɨpəhriəniən Uhgɨn otətəou in o rəhan noliən təuvɨr u, nati əpnapɨn rəhan nəfəniən in nati əkəku əmə təhmen e nəhu ətəpu nəuan nəuvetɨn əmə, uə rəhak iətəmimi in ləhtəni agɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nian Iesu tɨnol naunun nəgətuniən rəhan nətəmimi tueləf, təmiet ikɨn əha muvən e taun mɨn e nɨtəni Kaləli, mətəgətun nətəmimi kəni mətəni pətɨgəm nəghatiən rəha Uhgɨn kəm lah. ");
INSERT INTO tnp_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","E nian əha, Jon Bəptais tətatɨg e kaləpus, kəni in təmətəu nanusiən e uək iətəm Iesu tatol. Kəni təmahli=pən rəhan nəuvein nətəmimi kəhuvən motətapuəh ohni məmə, ");
INSERT INTO tnp_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“?Təhro? ?Ik u iətəm kəmətəni aupən məmə suah kəti otuva, uə itɨmah iəutəhtahnin iətəmimi kəti mɨn məmə otəpanuva mɨn?” ");
INSERT INTO tnp_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Kəni Iesu təməni=pən kəm lah məmə, “Əhuvən moteruh Jon motəni=pən nati nak iətəm nəməhuva motətəu kəni moteruh: ");
INSERT INTO tnp_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","nətəmi nəhmtɨlah təpɨs kɨnauteruh nati. Kəni nətəmimi nətəm nəhlkɨlah tərah kɨnotətəu təuvɨr kəni mɨnəutaliuək. Kəni nətəmimi mɨn u kəmotos nɨmɨsiən leprosi, nɨlosɨlah tɨnəuvɨr. Kəni nətəmimi mɨn u nɨpəgtəlgɨlah təmalu, rəueiu əha kɨnautətəu nati. Kəni nətəmimi mɨn u kəmohmɨs, kɨnotəmiəgəh mɨn. Kəni rəueiu, iətəmi kəti tɨnatəni pətɨgəm nanusiən təuvɨr kəm nanrah mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Iətəmimi otatɨg e nəuvɨriən pəhriən nəmə in təsəhlmaniən e nəhatətəiən lak o natimnati mɨn iətəm iəu iatol uə iəsoliən.” ");
INSERT INTO tnp_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nian nətəmimi rəha Jon kautohtəlɨg, kəni Iesu tɨnətuəuin mətəghati e Jon kəm nətəmimi mɨn u kəutəharəg əha ikɨn, mətəni məmə, “?Aupən, nəmautəhuvən ikɨn təpiə-məpiə ikɨn məmə nəkoteh nak? ?Nəməhuvən məmə nəkotafu iətəmi əpnapɨn əmə kəti təhmen e nɨmanuvehli əfəməh iətəm nɨmətagi tətalɨfu alɨfu əpnapɨn əmə? Kəpə. ");
INSERT INTO tnp_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","?Kəni təhro itəmah nəmohiet, məmə nəkotafu iətəmi kəti iətəm tatuvən e napən təuvɨr nəhmtɨn tiəkɨs? Kəpə. Nətəmimi kautəhuvən e napən təuvɨr tol lanəha, nian rəfin kəutatɨg e nimə rəha kig. ");
INSERT INTO tnp_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","?Mətəu nati nak əha nəməhuvən məmə nəkoteruh, iəni kəti, uə? Əuəh, pəhriən, mətəu iətəni kəm təmah məmə in ilɨs tapirəkɨs iəni. ");
INSERT INTO tnp_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Suah u inu Nauəuə Rəha Uhgɨn təmətəghati lan. Uhgɨn təməni məmə, ‘Otafu-to. Iətahli=pɨnə iahləpis iətəm otos rəhak nəghatiən. In otaupən lam məmə otol əpenə-penə e rəham suaru.’ ");
INSERT INTO tnp_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nɨpəhriəniən iətəni kəm təmah məmə, nətəmi u kəmotair e nɨftəni u, kəti təsapirəkɨsiən suah kəha Jon Bəptais. Kəni mətəu iətəmi in ləhtəni agɨn e Narmənɨgiən Rəha Uhgɨn, in ilɨs tapirəkɨs Jon. ");
INSERT INTO tnp_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","E nian Jon Bəptais təmətuəuin mətəni pətɨgəm nəghatiən rəha Uhgɨn mətəuarus=pa rəueiu, Narmənɨgiən Rəha Uhgɨn in təskasɨk məmə otol uək matuvən. Kəni nətəmimi nətəm kotəskasɨk kotalkut pɨk məmə okəhuvən motatɨg ahgəl. ");
INSERT INTO tnp_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Iətəni lanəha mətəu-inu, aupən agɨn mətəuarus=pa nian rəha Jon, nəghatiən mɨn rəha Lou iətəm Uhgɨn təməfən kəm Mosɨs, mɨne nəghatiən mɨn rəha iəni mɨn rəha Uhgɨn, kautəni pətɨgəm Narmənɨgiən Rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kəni nəmə nɨkitəmah tagiən məmə nəkotos nətəlɨgiən u, iəkəni məmə Jon in Elaijə iətəm in iəni kəti aupən kəmətəni məmə otuva mol əpenə-penə e suaru rəha Məsaiə. ");
INSERT INTO tnp_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Itəmah rəfin matəlgɨtəmah tatɨg, otətəlɨg vivi, kəni motəhrun nəghatiən mɨn u. ");
INSERT INTO tnp_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“?Nətəmimi mɨn u nətəm kəutatɨg rəueiu, ilah kotəhro lanu lan? Ilah kotəhmen=pən e kəlkələh mɨn kəutəharəg ikɨn katol makɨt ikɨn məutahkul məutauɨn e lah mɨn nəuvein məmə, ");
INSERT INTO tnp_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Itɨmah iəmotahli nau kəm təmah məmə onəkautol danɨs rəha nagiəniən lan, mətəu itəmah nəsotoliən danɨs. Kəni itɨmah iəməutasək eiuə rəha nɨmɨsiən, mətəu nəsotasəkiən kitah min itəmah.’ ");
INSERT INTO tnp_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Kəni təhmen əhmen əmə, itəmah nəsotolkeikeiən Jon, kəni məsoltolkeikeiən iəu. Iətəni lanəha lan mətəu-inu Jon təmuva, kəni mətətuakəm mətəpəh nauəniən mətəfaki kəm Uhgɨn, kəni məsəmnɨmiən wain. Kəni nəmotəpəh in motəni məmə, ‘Suah kəha narmɨn tərah kəti tətatɨg lan.’ ");
INSERT INTO tnp_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","“Mətəu nian iəu, Nətɨ Iətəmimi, iəmuva kəni mətauən kəni mətəmnɨm wain, mətəu nəmotəpəh mɨn iəu motəni məmə, ‘Otafu-to, suah kəha in iətəmimi rəha nauən pɨkiən mɨne iətəmimi rəha napɨsiən, kəni mətan pəti ilah nətəmimi rəha nosiən məni rəha takɨs, mɨne nətəmimi nətəm nol təfagə tərah.’ Mətəu nətəmimi mɨn u kəutətəlɨg e noliən rəhak mɨne rəha Jon, kotəhrun nehiən məmə nati iətəm iəmuol təhmen vivi pəhriən.” ");
INSERT INTO tnp_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kəni Iesu təməghati əskasɨk e natɨgiən rəha nətəmimi e taun mɨn əha iətəm in təmol nati apɨspɨs tepət ikɨn e nəhmtɨlah. Təməghati lanəha mətəu-inu ilah kəməsotəuhliniən nətəlɨgiən rəhalah o rəhalah noliən tərah mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Təməni məmə, “Itəmah nətəm Korasin, kəsi, nərahiən asoli otuva o təmah! !Itəmah nətəm Petsaitə, kəsi, nərahiən asoli otuva o təmah! Mətəu-inu iəmol pau nati apɨspɨs tepət e taun mil rəhatəmah mətəu itəmah nəsotəuhliniən nətəlɨgiən rəhatəmah! Kəni nəmə iəmol natimnati mɨn əha əpəha Taea mɨne Saedon aupən, ko nətəmimi əha ikɨn əha kəmotəuhlin rəhalah nətəlɨgiən e noliən tərah mɨn, kəni ilah məhuvən e napən əuas mɨn məhuvən məutəharəg e nəhmtahu e nɨgəm məutəgətun məmə kautətəu tərah agɨn o noliən tərah mɨn rəhalah. ");
INSERT INTO tnp_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","“Mətəu iətəni kəm təmah məmə e nian əha iətəm Uhgɨn otol nalpɨniən kəm nətəmimi, nalpɨniən rəhatəmah otəskasɨk, mapirəkɨs nalpɨniən rəha nətəm Taea mɨne Saedon u aupən. ");
INSERT INTO tnp_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","?Kəni itəmah nətəm Kapeniəm, nɨkitəmah təhti məmə Uhgɨn otəfəri=pən itəmah əha ima nɨsiaiən əpəha e negəu e neai? !Kəpə! Mətəu Uhgɨn otəhlman e təmah nəkoteiuaiu ləhtəni agɨn, ima naulɨsiən, mətəu-inu iəmol nati apɨspɨs tepət e taun rəhatəmah. Kəni nəmə iəmol natimnati mɨn u əpəha Sotəm, iətəm taun əha təfagə tərah mɨn tepət ikɨn, kəni nətəm ikɨn kəmotəuhlin rəhalah nətəlɨgiən, kəni nəmə Uhgɨn təməsərəkɨniən Sotəm, kəni təmətatɨg əmə mətəuarus=pa u rəueiu. ");
INSERT INTO tnp_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mətəu iətəni kəm təmah məmə e nian əha iətəm Uhgɨn otol nalpɨniən kəm nətəmimi, nalpɨniən rəhatəmah otəskasɨk, mapirəkɨs nalpɨniən rəha nətəm Sotəm aupən ikɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kəni e nian əha, Iesu təmətəfaki mətəni məmə, “Tatə Uhgɨn, ik Iərmənɨg rəha natimnati rəfin ilɨs e neai mɨne ləhtəni e nəhue nɨftəni. Iətəni-vivi ik mətəu-inu nəməhluaig e nɨpətɨ natimnati mɨn u e nəhmtɨ nətəmimi nətəm koteinatɨg motəhrun vivi nati. Kəni nəmol əpu kəm nətəmimi nətəm kotəhmen=pən əmə e kəlkələh mɨn məmə okotəhrun vivi. ");
INSERT INTO tnp_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Əuəh, Tatə, inu nati kəti iətəm ik nəkolkeikei.” ");
INSERT INTO tnp_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kəni Iesu təmətəkeikei mətəni kəm lah məmə, “Rəhak Tatə təmegəhan=pa rəkɨs natimnati rəfin e nəhlmək. Kəni iətəmi kəti tɨkə iətəm təhrun vivi iəu u Nətɨ Uhgɨn, məmə iəu pəh əhruahru. Mətəu Tatə Uhgɨn əmə təhrun. Kəni iətəmi kəti tɨkə iətəm təhrun vivi Uhgɨn, mətəu iəu pɨsɨn əmə u Nətɨ Uhgɨn, iəkəhrun, mɨne nətəmimi nətəm iəu iəmɨtəpɨn məmə iəkol pətɨgəm Tatə Uhgɨn kəm lah. ");
INSERT INTO tnp_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Əhuva ohniəu, itəmah nətəm nahgitəmah nɨkə kəni nɨnotəpəou e natipəiən e katipə fɨgəm mɨn, kəni iəkəfɨnə nəmeigiən. ");
INSERT INTO tnp_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Itəmah otos uək iətəm iəkəfɨnə kəm təmah, kəni pəh iəkaupən məgətun itəmah lan. Iətəni lanəha mətəu-inu iəu iətəmi mətɨg, kəni rəhak nətəlɨgiən in ləhtəni. Kəni onəkotos nəmeigiən e nɨkitəmah. ");
INSERT INTO tnp_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tol lanəha mətəu-inu rəhak uək iəkəfɨnə kəm təmah in tɨmətɨg, kəni rəhak katipə in təhvevɨg.” ");
INSERT INTO tnp_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kəni e nian əha e Sapət kəti, Iesu mɨne rəhan mɨn nətəmimi kəməutaliuək məutohapumɨn e nasumiən rəha wit, kəni rəhan mɨn nətəmimi nəumɨs təmus ilah, kəni kəmautəhli nəua wit kəni mautun. ");
INSERT INTO tnp_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mətəu nian Farəsi mɨn kəmotafu ilah, kəni kəmotəni=pən kəm Iesu məmə, “!Ei, afu-to! Rəham nətəmimi kautol nati kəti iətəm kəutatgəhli Lou rəha Sapət.” ");
INSERT INTO tnp_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Kəni Iesu təməni=pən kəm lah məmə, “?Nəmotafin uə kəpə, nati nak iətəm Kig Tefɨt təmol aupən, nian in mɨne rəhan mɨn nətəmimi nəumɨs təmus ilah? ");
INSERT INTO tnp_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","In təmuvən imə e Nima Tapolɨn Rəha Uhgɨn, kəni mos pɨret mun iətəm pris mɨn kɨnotəfən rəkɨs kəm Uhgɨn. Kəni noliən əha tətatgəhli Lou, mətəu-inu pɨret əha, Lou tətəni məmə pris mɨn əmə kotəhrun nuniən. ");
INSERT INTO tnp_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","?Kəni nəmotafin e Lou uə kəpə, məmə nian rəfin e Sapət, pris mɨn əpəha e Nimə Rəha Uhgɨn, ilah kautol uək rəhalah iətəm tətatgəhli Lou rəha Sapət? Mətəu Uhgɨn tateruh məmə nati əha in təhruahru əmə. ");
INSERT INTO tnp_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mətəu iətəni kəm təmah məmə iətəmi kəti u ikɨnu in ilɨs tapirəkɨs Nimə Rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","E Nauəuə Rəha Uhgɨn, in tətəni məmə, ‘Nati kəti tatol nɨkik tətagiən, inu məmə onəkotasəkəhruin nətəmimi, mətəu səniəmə rəhatəmah sakrifais mɨn iətəm nautol məutəfa kəm iəu iətəm tatol nɨkik tətagiən.’ Nəmə nəkotəhrun nɨpətɨ nəghatiən u, kəni nətəmimi mɨn u nətəm kotəhruahru, ko nəsotakiliən ilah motəni məmə ilah kautol noliən tərah. ");
INSERT INTO tnp_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Iətəni lanu lan mətəu-inu iəu, Nətɨ Iətəmimi, iəu iətarmənɨg e nian rəha Sapət.” ");
INSERT INTO tnp_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kəni Iesu təmiet ikɨn əha, maliuək matuvən əpəha imə e nimə rəha nuhapumɨniən rəhalah. ");
INSERT INTO tnp_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kəni əmeiko ikɨn əha, iətəmi kəti əha ikɨn nəhlmɨn təmɨmɨs, təsuahruiən lan. Kəni kəmotətapuəh o Iesu məmə, “?Təhro? ?In təhruahru e Lou məmə e Sapət, iətəmi təhrun nol viviən iətəmimi iətəm tatɨmɨs?” Ilah kəmotətapuəh ohni mətəu-inu kəutəsal e nətəlɨgiən tərah kəti rəha Iesu uə noliən kəti rəhan təhmen e nol viviən iətəmi e Sapət, iətəm ilah okotləfən in e kot ohni. ");
INSERT INTO tnp_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Kəni Iesu təməni=pən kəm lah məmə, “?Okəmə itəmah kəti rəhan kəti sipsip, kəni sipsip u tiuvɨg=pən e nɨmɨl e Sapət, nɨkitəmah təhti məmə iətəmi əha otuvən miuvi-pəri=pa mɨn? !Əuəh! Otəkeikei muvən miuvi-pəri. ");
INSERT INTO tnp_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","!Mətəu iətəmimi, in nati keikei tapirəkɨs sipsip! Konu, in təhruahru əmə e Lou məmə natol nati təuvɨr mɨn əmə kəm nətəmimi e Sapət.” ");
INSERT INTO tnp_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kəni təməni=pən kəm iətəmi nəhlmɨn təmɨmɨs məmə, “Uahru-to e nəhlməm.” Kəni təmuahru e nəhlmɨn, kəni nəhlmɨn tuva mɨnəuvɨr agɨn mɨn, məhmen e nəhlmɨn u kəti mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mətəu Farəsi mɨn kəmohiet məhuvən ihluə mɨnəutətei nəuə ohni məmə okotohamu Iesu. ");
INSERT INTO tnp_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Kəni Iesu təməhrun nətəlɨgiən rəhalah, kəni təmiet ikɨn əha. Kəni nətəmimi tepət kəmohuərisɨg lan. Kəni in təmol vivi nɨmɨsiən rəfin rəhalah kəutəhuva məutəuvɨr mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Kəni təməniəhu ilah məmə okəsotəni pətɨgəmiən in kəm nətəmimi mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Natimnati mɨn əha kəmohiet məmə nəghatiən rəha Nauəuə Rəha Uhgɨn otuva mol nɨpəhriəniən lan. Uhgɨn təməfən kəm iəni Aiseə u aupən o nəni pətɨgəmiən məmə, ");
INSERT INTO tnp_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Inu ioluək rəhak iətəm iəu inɨtəpɨn rəkɨs, iəkolkeikei pɨk in, kəni nɨkik tagiən pɨk ohni. Kəni iəu iəkol məmə Narmɨn Rəhak otuva məriauəh lan. Kəni in otəni pətɨgəm noliən əhruahru rəhak mɨne nosmiəgəhiən rəhak e nəhmtɨ nətəmimi e nɨtəni pɨsɨn pɨsɨn mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ko in təsorgəhuiən kəni məsagət əfəməhiən, məsəghati pɨkiən ikɨn nətəmimi kəutuhapumɨn ilah mɨn ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","In iətəmi mətɨg, kəni in otol təuvɨr kəm nətəmimi nətəm kəutəpəou kəni rəhalah nəsanəniən tɨkə. In otol lanəha mətəuarus=pa noliən iətəm in təhruahru otol win e noliən iətəm tərah. ");
INSERT INTO tnp_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kəni nətəmimi mɨn u səniəmə nəuanɨləuɨs mɨn rəha Isrel, ilah okotələhu=pən əskasɨk rəhalah nətəlɨgiən tətatɨg lan, məmə in otosmiəgəh ilah.” ");
INSERT INTO tnp_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kəni nətəmimi kəmotos iətəmi kəti məhuva kəm Iesu iətəm nəhmtɨn təpɨs kəni təsəghatiən mətəu-inu narmɨn tərah kəti tətatɨg lan. Kəni Iesu təmol vivi mɨn, kəni iətəmi kəha tɨnateruh nati kəni mɨnətəghati. ");
INSERT INTO tnp_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kəni nətəmimi rəfin narmɨlah təmiuvɨg motəni məmə, “?Nəmə təhro suah u in Mipɨ Kig Tefɨt iətəm Uhgɨn təməni məmə otahli=pa?” ");
INSERT INTO tnp_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kəni nian Farəsi mɨn kəmotətəu nati əha mɨne nəghatiən lan, kəni kəmotəni məmə, “Suah kəha tətəhgi pətɨgəm narmɨn tərah mɨn e nəsanəniən əmə rəha Pielsepul u iətəmi asoli rəha narmɨn tərah mɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Mətəu Iesu təhrun nətəlɨgiən rəhalah, kəni təməni=pən kəm lah məmə, “Nəmə nətəmimi e kəntri kəti kautəhapu ilah mɨn, kəni okotərəkɨn rəhalah kəntri. Kəni təhmen=pən əmə e taun kəti uə lahuənu kəti, nəmə nətəmimi kautəhapu ilah mɨn, kəni okotərəkɨn taun u uə lahuənu u. ");
INSERT INTO tnp_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","“Kəni nəmə Setən tətəhgi pətɨgəm narmɨn tərah mɨn rəhan e nətəmimi, kəni tatol aru əmə tɨkɨmɨr kəm in. ?Kəni otəhro lanu, rəhan narmənɨgiən otəhtul? ");
INSERT INTO tnp_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","?Kəni nəmə iəu iətəhgi pətɨgəm narmɨn tərah mɨn e nəsanəniən rəha Pielsepul, kəni təhro e rəhatəmah mɨn nətəmimi? Ilah kautəhgi pətɨgəm narmɨn tərah mɨn e nəsanəniən rəha pəh? ?Rəha Setən? Kəpə. Kəni tərah məmə nautəni məmə iəu iatol lanəha. Tol lanəha, rəhatəmah nətəmimi okotakil nəghatiən mɨn rəhatəmah, motəni məmə in neiuəiən. ");
INSERT INTO tnp_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Mətəu nəmə iətəhgi pətɨgəm narmɨn tərah mɨn e nəsanəniən rəha Narmɨn Rəha Uhgɨn, kəni Narmənɨgiən Rəha Uhgɨn tɨnuvnə rəkɨs o təmah. ");
INSERT INTO tnp_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Kəni iəkəni e suaru kəti mɨn tol lanəha məmə, iətəmimi kəti tɨkə məmə təhrun nuvəniən e nimə rəha iətəmimi kəti iətəm nahgin tepət təhmen e Setən məmə otəmki rəhan natimnati. Mətəu iətəmimi kəti iətəm nahgin tepət agɨn otaupən məlis-ərain iətəmimi u iətəm nahgin tepət, uərisɨg təpanuvən imə məmki rəkɨs rəhan natimnati. ");
INSERT INTO tnp_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Iətəmi u in təsuərisɨgiən lak, in rəhak tɨkɨmɨr. Kəni iətəmi u in təsoriaruniən sipsip mɨn, in tatol ilah kəutagɨm atiti. ");
INSERT INTO tnp_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Tol lanəha iətəni kəm təmah məmə, Uhgɨn otafəl rəkɨs noliən tərah pɨsɨn pɨsɨn mɨn rəfin, mɨne nəghatiən tərah pɨsɨn pɨsɨn mɨn rəfin iətəm nətəmimi kəutəni lan, mətəu otol nalpɨniən, kəni məsaluiən e nəghatiən tərah mɨn iətəm nətəmimi kautəni e Narmɨn Rəhan. ");
INSERT INTO tnp_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kəni nəmə iətəmimi tətəni rah iəu, Nətɨ Iətəmimi, kəni Uhgɨn otalu kəni məsalpɨniən. Mətəu iətəmimi iətəm tətəni rah Narmɨn Rəha Uhgɨn, Uhgɨn ko təsaluiən lan e nian kəti, e nəhue nɨftəni u, mɨne e nian iətəm tətuva. ");
INSERT INTO tnp_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Nəmə nɨgi in təuvɨr, kəni nəuan in otəuvɨr; nəmə nɨgi in tərah, kəni nəuan in otərah. Tol lanəha mətəu-inu itəmah nəkoteruh əmə e nəua nɨgi məmə nɨgi in təuvɨr uə nɨgi in tərah. ");
INSERT INTO tnp_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","!Itəmah nəkotəhmen e sɨneik! Itəmah nautol noliən ekəu-ekəu, kəni itəmah nətəm nəkotərah. Ko nəsotəniən nati təuvɨr kəti, mətəu-inu nian iətəmimi tətəghati, tətəni əmə nati nak iətəm təriauəh e nɨkin. ");
INSERT INTO tnp_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Iətəmimi iətəm nətəlɨgiən təuvɨr təriauəh e nɨkin, nian rəfin in tətəni nati iətəm in təuvɨr. Kəni iətəmimi iətəm nətəlɨgiən tərah təriauəh e nɨkin, nian rəfin in tətəni nati iətəm tərah. ");
INSERT INTO tnp_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Iətəni kəm təmah məmə e nian Uhgɨn otakil nətəmimi lan, nətəmimi okotəkeikei motəni pətɨgəm kəm in məmə təhro ilah kəmautəni nəghatiən tərah əpnapɨn mɨn rəfin agɨn rəhalah. ");
INSERT INTO tnp_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tol lanəha, in otakil rəfin nəghatiən pɨsɨn mɨn rəhatəmah, məmə itəmah nətəm nəkotəhruahru uə nətəm nəkotərah.” ");
INSERT INTO tnp_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kəni nəgətun mɨn nəuvein rəha Lou mɨne Farəsi mɨn kəmotəni=pən kəm in məmə, “Iəgətun. Iəkotolkeikei məmə iəkoteruh nəmtətiən kəti iətəm tapɨspɨs ik onəkol.” ");
INSERT INTO tnp_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Mətəu təməni=pən kəm lah məmə, “Itəmah nətəmimi rəueiu mɨne, nəkotərah, nəmotəpəh rəhatəmah nəhatətəiən e Uhgɨn, təhmen e pətan kəti tətəpəh rəhan iərman mətɨtəu=pən suah pɨsɨn. Kəni rəueiu nəkotolkeikei məmə iəkol nəmtətiən kəti iətəm otəgətun məmə iəmsɨpən e Uhgɨn. Mətəu Uhgɨn otəfɨnə əmə nəmtətiən kətiəh əmə, kəni inəha nəmtətiən rəha iəni əha Jonə. ");
INSERT INTO tnp_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Təhmen əmə məmə Jonə təməməhli o nian kɨsɨl lapɨn mɨne lənian e nərfɨ nəmu asoli təfla, kəni Nətɨ Iətəmimi, in otəməhli o nian kɨsɨl lapɨn mɨne lənian əpəha e nɨki nɨftəni. ");
INSERT INTO tnp_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“E nian əha iətəm Uhgɨn otakil nətəmimi rəfin, kəni nətəm Ninivə aupən, ilah okotəhtul motəni pətɨgəm məmə itəmah nəuanɨləuɨs rəha Isrel nəkotərah. Okotəhrun nəniən lanəha mətəu-inu nian ilah kəmotətəu nəghatiən rəha iəni əha Jonə, ilah kəmotəuhlin rəhalah nətəlɨgiən e rəhalah noliən tərah mɨn. Kəni oteruh-to, iətəmi kəti iətəm ilɨs tapirəkɨs Jonə tɨnuva, mətəu itəmah nəsotəuhliniən rəhatəmah nətəlɨgiən e rəhatəmah noliən tərah mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kəni e nian əha Uhgɨn otakil nətəmimi rəfin, kəni kwin rəha nɨtəni pesi ikɨn, otəhtul məni pətɨgəm məmə itəmah nətəm nəkotərah. Otəhrun nəniən lanəha mətəu-inu, in təmiet e nɨkalɨ nɨtəni əpəha isəu agɨn, kəni maliuək muva məmə otətəu nəghatiən rəha Kig Solomən u iətəm teinatɨg pɨk. Kəni oteruh-to, suah kəti iətəm in ilɨs agɨn mapirəkɨs Kig Solomən tɨnuva, mətəu itəmah nəsotətəlɨgiən. ");
INSERT INTO tnp_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Nian narmɨn tərah tiet e iətəmimi, kəni in otuvən maliuək mətan əpəha ikɨn nɨgi mɨne nian mɨtə tɨkə ikɨn, kəni nəhu tɨkə ikɨn, mətəsal ikɨn otatɨg məmeig ikɨn, mətəu təsehiən. ");
INSERT INTO tnp_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Kəni təni aru əmə kəm in məmə, ‘Iəkɨtəlɨg=pən e rəhak nimə iətəm iəmsɨpən ikɨn.’ Kəni nian tuva meruh nimə, iətəmimi tɨkə ikɨn, kəni kəmafəl, kəni kəməlɨn vivi natimnati. ");
INSERT INTO tnp_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kəni tuvən mit narmɨn tərah səpɨn mɨn u kotərah pɨk motapirəkɨs in, kəni məhuvən imə motatɨg. Kəni natɨgiən rəha iətəmi əha rəueiu tərah pɨk tapirəkɨs rəhan natɨgiən iətəm aupən. Kəni kotəhmen əmə e təmah nətəm nəkotərah nətəm nəutatɨg rəueiu.” ");
INSERT INTO tnp_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nian Iesu tətəghati əhanəh kəm nətəmimi, kəni rəhan mamə mɨne pian mɨn kautəhtul əpəha ihluə məutətapuəh lan məmə okotəghati kəm in. ");
INSERT INTO tnp_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kəni iətəmimi kəti təməni=pən kəm Iesu məmə, “Rəham mamə mɨne piam mɨn əpəha ihluə kəutəhtul. Ilah kotolkeikei məmə okotəghati kəm ik.” ");
INSERT INTO tnp_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Kəni Iesu təməni=pən kəm iətəmi təməni pətɨgəm məmə, “?Pəh u rəhak mamə, kəni pəh u piak mɨn?” ");
INSERT INTO tnp_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kəni muahru=pən e nəhlmɨn məgətun=pən rəhan nətəmimi, kəni məni məmə, “!Inu rəhak mamə mɨne piak mɨn! ");
INSERT INTO tnp_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Iatəni lanəha lan mətəu-inu pəh u tatol nəuia rəhak Tatə əpəha ilɨs e negəu e neai, in piak, mɨne nəuvɨnɨk, mɨne rəhak mamə.” ");
INSERT INTO tnp_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","E nian əmə kəha, Iesu təmiet e nimə muvən mətəharəg əpəha iuəkɨr e nɨkalɨ nəhu Lek Kaləli. ");
INSERT INTO tnp_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mətəu-inu nətəmimi tepət kəməhuva motəhtul tɨtəlau lan, kəni in təmuvən e bot kəti u tətəhtul iuəkɨr əmə o nɨpəkɨl, kəni mətəharəg. Kəni nətəmimi kəmautəhtul ipari. ");
INSERT INTO tnp_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kəni in təməni=pən natimnati mɨn tepət kəm lah e nəghatiən əuhlin mɨn. Təməni məmə, “Iətəmimi kəti təmuvən məmə otearəgrəg nɨkɨtɨ wit rəhan əpəha e rəhan nasumiən. ");
INSERT INTO tnp_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kəni nian təmətearəgrəg nɨkɨtɨ wit rəhan, nəuvein kəmotəmei=pən e suaru, kəni mənɨg mɨn kəməhuva motun rəfin ilah. ");
INSERT INTO tnp_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kəni nɨkɨtɨ wit nəuvein kəmohmərəgrəg=pən e nɨftəni iətəm kəpiel iuəkɨr əmə. Kəmoteviə uəhai əmə mətəu-inu nɨftəni nəuan nəuvetɨn əmə. ");
INSERT INTO tnp_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nian mɨtɨgar təri, kəni məhgi ilah kotaukei-aukei mətəu-inu nokɨlah təseiuaiu pɨkiən. ");
INSERT INTO tnp_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kəni nɨkɨtɨ wit nəuvein kəmotəmei=pən e nɨki nɨləuɨs u tol nihlɨn, kəni nian nɨkɨtɨ wit mɨn koteviə mətəu nɨləuɨs tətatu-atu ilah kəni kohmɨs. ");
INSERT INTO tnp_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kəni nɨkɨtɨ wit nəuvein mɨn kəmotəmei=pən e nɨftəni iətəm təuvɨr, kəni kəmotəuə e nəualah. Nəuvein nəualah tate, nəuvein nəualah sikɨste, nəuvein nəualah uan-hanrɨt. ");
INSERT INTO tnp_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Itəmah rəfin matəlgɨtəmah tatɨg, otətəlɨg vivi, kəni motəhrun nəghatiən mɨn u.” ");
INSERT INTO tnp_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kəni nətəmimi rəha Iesu kəməhuva motətapuəh ohni məmə, “?Təhro nətəghati kəm nətəmimi e nəghatiən əuhlin mɨn?” ");
INSERT INTO tnp_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Kəni Iesu təməni=pən kəm lah məmə, “Iətəni lanəha mətəu-inu itəmah u, Uhgɨn təmerəh e suaru o təmah məmə itəmah onəkotəhrun nəghatiən oneuən mɨn rəha Narmənɨgiən Rəha Uhgɨn. Mətəu ilah, Uhgɨn təməserəhiən e suaru lanu o lah. ");
INSERT INTO tnp_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tol lanəha mətəu-inu, iətəmi u iətəm rəhan əha ikɨn nəhruniən, Uhgɨn otəfən mɨn nəhruniən kəm in, kəni rəhan nəhruniən in otepət pɨk. Mətəu iətəmi u iətəm rəhan nəhruniən tɨkə, Uhgɨn otos rəkɨs rəfin rəhan nəhruniən iətəm nɨkin təhti məmə in tatos. ");
INSERT INTO tnp_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Iətəghati e nəghatiən əuhlin kəm lah mətəu-inu ilah kautafu pau mətəu kəsotəhruniən, kəni ilah kautətəu pau mətəu kəsotəhrun viviən. ");
INSERT INTO tnp_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nəmiəgəhiən rəhalah tatol nəghatiən rəha iəni Aiseə tətuva matol nɨpəhriəniən lan. In təməni məmə, ‘Okautətəu, mautətəu, mautətəu, mətəu ko kəsotəhruniən. Kəni okauteruh, mauteruh, mauteruh, mətəu ko kəsotəhruniən nian kəti. ");
INSERT INTO tnp_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","In tol lanəha mətəu-inu nɨkilah tɨniəkɨs rəkɨs. Kəmotasisɨg e matəlgɨlah mɨne nəhmtɨlah. Mətəu kəmautol lanəha məmə, okəsoteruhiən e nəhmtɨlah, kəni okəsotətəuiən e matəlgɨlah, kəni nɨkilah təruru nəhruniən. Kəni məsəhuvaiən ohniəu məmə iəkosmiəgəh ilah.’ ");
INSERT INTO tnp_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Mətəu itəmah u, Uhgɨn təməfɨnə rəhan nəuvɨriən kəm təmah, kəni nian nəkoteruh, motəhrun, kəni nian nəkotətəu motəhrun. ");
INSERT INTO tnp_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nɨpəhriəniən iətəni kəm təmah məmə, iəni mɨn tepət mɨne nətəm kotəhruahru mɨn tepət kəmotolkeikei pɨk məmə okoteruh nati nak iətəm nauteruh, mətəu kəməsoteruhiən. Kəni motolkeikei pɨk məmə okotətəu nati nak iətəm nautətəu, mətəu kəməsotətəuiən.” ");
INSERT INTO tnp_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Kəni Iesu təmətəkeikei mətəni məmə, “Itəmah otətəlɨg vivi-to məmə nəkotəhrun nɨpətɨ nəghatiən əuhlin rəha iətəmi u iətəm təmearəgrəg nɨkɨtɨ wit. ");
INSERT INTO tnp_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nɨkɨtɨ wit iətəm təməmei e suaru, tətəgətun=pən iətəmimi iətəm tətəu nəghatiən rəha Narmənɨgiən Rəha Uhgɨn, mətəu in təsəhruniən. Kəni Setən tuva mos rəkɨs uəhai əmə nəghatiən əha iətəm təmuvən e nɨkin. ");
INSERT INTO tnp_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“Kəni nɨkɨtɨ wit iətəm təməmei=pən e nɨftəni iətəm kəpiel iuəkɨr əmə, tətəgətun=pən iətəmimi iətəm tətətəu nəghatiən rəha Uhgɨn, kəni mos e nɨkin agiən, ");
INSERT INTO tnp_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","mətəu nokɨn təseiuaiu pɨkiən, kəni tətəhtul o nian əkuəkɨr əmə. Nian nəsəsauiən, uə nərahiən tuva e nəmiəgəhiən rəhan o nəghatiən əha, kəni təmei uəhai əmə e rəhan nəhatətəiən. ");
INSERT INTO tnp_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Kəni nɨkɨtɨ wit iətəm təməmei=pən e nɨki nɨləuɨs tol nihlɨn, tətəgətun=pən iətəmimi iətəm tətəu nəghatiən rəha Uhgɨn, mətəu rəhan nətəlɨgiən tatuvən pɨk o natimnati rəha nəhue nɨftəni, kəni in tolkeikei məmə rəhan nautə otepət; kəni nətəlɨgiən mɨn əha kotatu-atu nəghatiən rəha Uhgɨn, kəni nəghatiən əha təsəuəiən e nəuan. ");
INSERT INTO tnp_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Mətəu nɨkɨtɨ wit iətəm təməmei=pən e nɨftəni təuvɨr, tətəgətun=pən iətəmimi iətəm tətəu nəghatiən rəha Uhgɨn kəni məhrun nɨpətɨn. Kəni e nəmiəgəhiən rəhan, in otəuə e nəuan, nian nəuvein nəuan tate, nian nəuvein nəuan sikɨste, kəni nian nəuvein nəuan uan-hanrɨt.” ");
INSERT INTO tnp_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Kəni Iesu təməni nəghatiən əuhlin kəti mɨn kəm lah mətəni məmə, “Nəghatiən əuhlin u tətəgətun=pən Narmənɨgiən Rəha Uhgɨn. Iətəmimi kəti təmearəgrəg e nɨkɨtɨ wit təuvɨr e rəhan nasumiən. ");
INSERT INTO tnp_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mətəu nian in mɨne rəhan mɨn nətəmimi kəmautapɨli, rəhan kəti tɨkɨmɨr təmuvən məraki e nɨkɨtɨ nɨmanuvehli tərah mɨn e rəhan nasumiən, kəni magɨm. ");
INSERT INTO tnp_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kəni nɨkɨtɨ wit təuvɨr mɨne nɨkɨtɨ manuvehli tərah koteviə kəni kotəhmen əhmen əmə. Mətəu wit təmaupən mol nəuan, kəni e nian əha, noluək mɨn kotəhrun neruhiən məmə manuvehli tərah, ilah mɨn əha ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Kəni noluək mɨn rəha iətəmimi əha, kəməhuva moteruh in, motəni məmə, ‘Iətəmi asoli. ?Nɨkɨtɨ wit mɨn iətəm nəmearəgrəg e rəham nasumiən, ilah nɨkɨtɨ wit təuvɨr mɨn əmə, uə kəpə? ?Mətəu təhro nɨkɨtɨ manuvehli tərah mɨn kɨnotəri?’ ");
INSERT INTO tnp_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Kəni təməni=pən kəm lah məmə, ‘Tɨkɨmɨr kəti təmol nati əha.’ “Kəni rəhan mɨn noluək mɨn kotəni=pən kəm in məmə, ‘?Mətəu təhro? ?Nəkolkeikei məmə itɨmah iəkəhuvən moteuvi rəkɨs manuvehli tərah mɨn əha?’ ");
INSERT INTO tnp_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Mətəu təməni=pən kəm lah məmə, ‘Kəpə. Otəpəh. Nəmə itəmah nəkəhuvən moteuvi rəkɨs manuvehli tərah mɨn, kəni məta nəkoteuvi rəkɨs mɨn wit təuvɨr mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pəh kotəri pəti əmə mətəuarus=pən wit tɨməhtə. Kəni iəkəni=pən kəm nətəmimi nətəm okotəulək e wit məmə ilah okotaupən moteuvi rəkɨs manuvehli iətəm tərah motəlis o nəraki-pəniən e nɨgəm. Uərisɨg okotəulək e wit təuvɨr mɨn motəmki məhuvən e nimə rəhak iətəm kətəlɨn nauəniən ikɨn.’” ");
INSERT INTO tnp_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Kəni Iesu təməni nəghatiən əuhlin mɨn kəti kəm lah məmə, “Narmənɨgiən Rəha Uhgɨn in otəkeikei mepət təhmɨn, təhmen e nɨkɨtɨ mastət iətəm iətəmimi təmos muvən mərfei e rəhan nasumiən. ");
INSERT INTO tnp_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nɨkɨtɨ mastət əha in natiəkəku agɨn, mətəu nian in oteviə, in otuva iahgin təhmen e nɨgi kəti, kəni mənɨg mɨn iətəm kautiuvɨg ilɨs okəhuva motol nimaalah e nəhlmɨn mɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Kəni Iesu təməni nəghatiən əuhlin kəti mɨn məmə, “Narmənɨgiən Rəha Uhgɨn in otəkeikei mepət təhmɨn, təhmen=pən e is nəuan nəuvetɨn iətəm pətan kəti tətalkin e flauə tepət iətəm kəmol=pən e pesɨn asoli, kəni təhgi flauə rəfin tətasisi matol iahgin.” ");
INSERT INTO tnp_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Natimnati mɨn rəfin əha, Iesu təməghati əuhlin lan kəm nətəmimi. In təmatəgətun əmə nətəmimi e nəghatiən əuhlin. ");
INSERT INTO tnp_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Noliən əha təmol nəghatiən rəha iəni aupən tətuva matol nɨpəhriəniən lan. Təməni məmə, “Iəkəni pətɨgəm rəhak nəghatiən e nəghatiən əuhlin mɨn. Iəkəni pətɨgəm natimnati iətəm iəməhluaig e lah e nian iəmətuəuin matol nɨftəni mətəuarus=pa u rəueiu.” ");
INSERT INTO tnp_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kəni Iesu təmiet rəkɨs e nətəmimi, kəni muvən mɨn e nɨpəgnəua nimə kəti. Kəni rəhan mɨn nətəmimi kəməhuva ohni motətapuəh məmə, “Əni-to kəm tɨmah nɨpətɨ nəghatiən əuhlin e manuvehli iətəm təməri e nasumiən.” ");
INSERT INTO tnp_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kəni Iesu təməni=pən məmə, “Iətəmimi iətəm təmearəgrəg nɨkɨtɨ wit təuvɨr mɨn e nasumiən, tətəgətun=pən iəu, Nətɨ Iətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kəni nasumiən, tətəgətun=pən nəhue nɨftəni. Kəni nɨkɨtɨ wit təuvɨr mɨn, ilah u kəutəgətun=pən nətəmimi rəha Uhgɨn nətəm tətarmənɨg e lah. Kəni manuvehli tərah mɨn, ilah kəutəgətun=pən nətəmimi rəha Setən. ");
INSERT INTO tnp_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kəni tɨkɨmɨr iətəm təmuvən mearəgrəg manuvehli tərah, tətəgətun=pən Setən. Kəni nian okəulək e nasumiən, tətəgətun=pən naunun nian, kəni nətəmimi nətəm kautəulək e nasumiən, kəutəgətun=pən nagelo mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Okotəmki manuvehli tərah motuvan əhtuv e nɨgəm, noliən əha təhmen e naunun nian. ");
INSERT INTO tnp_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","“Iəu Nətɨ Iətəmimi, iəkahli=pən nagelo mɨn rəhak okəhuvən ikɨn iətarmənɨg ikɨn, motos rəkɨs natimnati rəfin mɨne nətəmimi rəfin nətəm kautiuvi=pən nətəmimi o noliən təfagə tərah mɨn mɨne nətəmimi rəfin nətəm kautol noliən tərah mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ilah okotəraki=pən e lah e nɨgəm asoli, kəni ikɨn əha nətəmimi okotasək kəni mautɨgət-ərain nəhluvlah mɨn ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kəni nətəm kotəhruahru okotasiə təhmen e mɨtɨgar e narmənɨgiən rəha rəhalah Tatə Uhgɨn. Itəmah rəfin matəlgɨtəmah tatɨg, otətəlɨg vivi, kəni motəhrun nəghatiən mɨn u.” ");
INSERT INTO tnp_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Kəni Iesu təmətəkeikei mətəni məmə, “Nəghatiən əuhlin u tətəgətun=pən Narmənɨgiən Rəha Uhgɨn. Bokɨs məni kəti tətəhluaig e nɨftəni kəti. Kəni iətəmimi kəti təmətan mafu bokɨs məni əha, kəni tatɨg mɨtənɨm mɨn. Nɨkin təmagiən pɨk, kəni təmuvən mol səlɨm e natimnati rəfin rəhan, kəni mos nəhmtɨ nɨftəni əha.” ");
INSERT INTO tnp_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kəni Iesu təməni məmə, “Nəghatiən əuhlin u tətəgətun=pən Narmənɨgiən Rəha Uhgɨn. Iətəmimi kəti tətəsal e natimnati, kəni matol səlɨm mɨn lan. Kəni in tətəsal e kəpiel təuvɨr mɨn nəhmtɨlah tiəkɨs, kətəni məmə perəl. ");
INSERT INTO tnp_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nian təmeruh perəl kəti iətəm təuvɨr pɨk agɨn, kəni in təmuvən mol səlɨm e rəhan natimnati mɨn rəfin, kəni muvən mos nəhmtɨ perəl əha, kəni mələs rəhan.” ");
INSERT INTO tnp_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Kəni Iesu təmətəkeikei mətəni məmə, “Nəghatiən əuhlin u tətəgətun=pən Narmənɨgiən Rəha Uhgɨn. Nətəmimi kəutəraki=pən e net əpəha itəhi mautos nəmu pɨsɨn pɨsɨn mɨn lan. ");
INSERT INTO tnp_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nian net tɨnəriauəh e nəmu, kəni kotiuvi-pari net, kəni motəuəri nəmu mɨn motaipei=pən nəmu təuvɨr mɨn e kətɨm asoli mɨn rəhalah, mətəu okotəraki e nəmu mɨn iətəm kotərah. ");
INSERT INTO tnp_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kəni e naunun nian, nagelo mɨn okəhuva motos rəkɨs nətəmimi nətəm kotərah e nətəmimi nətəm kotəhruahru, ");
INSERT INTO tnp_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","kəni motəraki=pən e nətəmimi kotərah e nɨgəm asoli, kəni ikɨn əha nətəmimi okotasək mautɨgət-ərain nəhluvlah ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“?Itəmah nəkotəhrun natimnati mɨn u, uə kəpə?” Kəni ilah kəmotəni kəm in məmə, “Əuəh.” ");
INSERT INTO tnp_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kəni təməni=pən kəm lah məmə, “Tol lanəha, nəgətun mɨn rəfin rəha Lou iətəm kəməgətun vivi ilah e Narmənɨgiən Rəha Uhgɨn, kotəhmen e iətəmi asoli rəha nimə iətəm rəhan nautə tepət. Kəni nian kəti in tatos rəkɨs nati vi e rəhan nautə, kəni nian kəti mɨn tatos rəkɨs nati əuas.” ");
INSERT INTO tnp_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nian Iesu tɨnol naunun nəghatiən e nəghatiən əuhlin mɨn əha, kəni təmiet ikɨn əha, ");
INSERT INTO tnp_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","muvən iman ikɨn. Kəni təmətəgətun nətəmimi əpəha e nimə rəha nuhapumɨniən, kəni narmɨlah təmiuvɨg, kəni kotəni məmə, “Suah u təmos iə neinatɨgiən əha mɨne nəsanəniən əha o noliən nati apɨspɨs mɨn? ");
INSERT INTO tnp_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Suah kəha, kitah kotəhrun vivi in. ?In nətɨ iətəmimi iətəm tatol nimə, uə kəpə? ?Kəni rəhan mamə, in Meri, kəni pian mɨn ilah Jemɨs, mɨne Josɨp, mɨne Saimon, mɨne Jutəs, uə kəpə? ");
INSERT INTO tnp_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","?Kəni rəhan kakə mɨn kitah min ilah, uə kəpə? ?Təmos iə nəhruniən o noliən natimnati mɨn əha?” ");
INSERT INTO tnp_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kəni nɨkilah təsagiəniən ohni kəni motəuhlin nəmtahlah ohni. Mətəu Iesu təməni=pən kəm lah məmə, “Nəmə iətəmi kəti in iəni, nətəmimi rəfin kautɨsiai. Mətəu rəhan mɨn nətəmimi əpəha lahuənu mɨne rəhan mɨn nətəmimi e nɨpəgnəua nimə rəhan, ilah əmə kəsotɨsiaiən.” ");
INSERT INTO tnp_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kəni təməsoliən nati apɨspɨs tepət ikɨn əha, mətəu-inu ilah kəsotəhatətəiən lan. ");
INSERT INTO tnp_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","E nian əha, Kig Herot Antipas u tətarmənɨg e nɨtəni Kaləli, təmətəu nanusiən rəha Iesu. ");
INSERT INTO tnp_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Kəni təməni=pən kəm rəhan mɨn nətəmimi asoli məmə, “Suah u in Jon Bəptais iətəm təməmiəgəh mɨn e nɨmɨsiən. Tol lanəha tatos nəsanəniən əha o noliən nati apɨspɨs mɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Herot Antipas təməghati lanəha mətəu-inu in təmohamu rəkɨs Jon Bəptais. Inu nanusiən e nɨmɨsiən rəha Jon Bəptais, tol lanu lan. Aupən ikɨn, Kig Herot Antipas təmakləh e Herotiəs u pətauəhli rəha pia Herot u, Fɨlɨp Kətiəh. Kəni Jon təməni=pən kəm in məmə, “Təsəhruahruiən məmə nəkos pətan u, mətəu-inu nətatgəhli Lou.” Kəni Herot Antipas təmaskəlɨm Jon o Herotiəs, məlis-ərain, mɨləfən e kaləpus. ");
INSERT INTO tnp_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herot Antipas tolkeikei məmə in otohamu Jon, mətəu təməsoliən mətəu-inu tətəgɨn e nətəmimi. Ilah kautɨsiai Jon məutəni məmə in iəni kəti. ");
INSERT INTO tnp_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mətəu nian kəti, Herot Antipas təmol lafet kəti rəha nian təmair lan, kəni pətan mɨtə, nətɨ Herotiəs, təmol danɨs aupən e nəhmtɨ nətəmimi rəfin. Kəni rəhan noliən danɨs təmol Herot Antipas nɨkin təmuvən pɨk lan, ");
INSERT INTO tnp_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","kəni tol lanəha, in təməni əskasɨk mos nonauvɨl məmə in otəfən nati nak iətəm pətan mɨtə əha tolkeikei. ");
INSERT INTO tnp_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kəni Herotiəs təməghati kəm nətɨn, kəni nətɨn təməni=pən nəghatiən rəha Herotiəs kəm Herot Antipas məmə, “Os rəhn-kapə Jon Bəptais e pɨlet kəti muva u ikɨnu məfa kəm iəu rəueiu.” ");
INSERT INTO tnp_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kəni kig, nɨkin təpəou. Mətəu təməni=pən kəm rəhan nətəmimi məmə ilah okotol nəuia nətɨ Herotiəs, mətəu-inu o rəhan nonauvɨl mɨne nəniəskasɨkiən iətəm təmol e nəhmtɨ nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kəni təmahli=pən nətəmimi nəuvein kəhuvən e kaləpus, kəni ilah kəmotəuahtuv rəkɨs rəhn-kapə Jon ikɨn əha, ");
INSERT INTO tnp_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","motələhu=pən e pɨlet kəti, motos məhuva, motəfən kəm nətɨ Herotiəs, kəni in təməfən kəm rəhan mamə. ");
INSERT INTO tnp_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kəni nətəmimi rəha Jon kəməhuvən motos nɨpətɨn məhuvən mohtənɨm, kəni məhuvən motəni=pən kəm Iesu. ");
INSERT INTO tnp_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nian Iesu təmətəu nanusiən əha, kəni təmuvən e bot kəti muvən əpəha ikɨn nətəmimi kohkə ikɨn. Mətəu nian nɨmənin nətəmimi kəmotəhrun ikɨn təmuvən ikɨn, kəni ilah kəmohiet e rəhalah lahuənu mɨn motaliuək ipari məhuərisɨg e Iesu. ");
INSERT INTO tnp_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nian Iesu təmuvari, mafu məmə nɨmənin nətəmimi tepət, kəni nɨkin təmepət o lah, molkeikei ilah, kəni mol vivi nɨmɨsiən mɨn rəhalah. ");
INSERT INTO tnp_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kəni ləhnaiuv iuəkɨr o napinəpuiən, rəhan mɨn nətəmimi kəməhuva ohni mautəni məmə, “Ikɨnu, ikɨn nətəmimi kohkə ikɨn, kəni otəsuvəhiən tapinəpu. Ahli=pən nɨmənin nətəmimi məmə okəhuvən lahuənu mɨn motos nəhmtɨ nɨglah nəuvein nauəniən.” ");
INSERT INTO tnp_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Kəni Iesu təməni=pən məmə, “Kəpə. Otəpəh əmə ilah kautol u ikɨnu, kəni itəmah əmə otaugɨn ilah.” ");
INSERT INTO tnp_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Mətəu kotəni=pən kəm in məmə, “Itɨmah iautos əmə pɨret faif mɨne nəmu keiu.” ");
INSERT INTO tnp_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Kəni təni məmə, “Otos məhuva kəm iəu.” ");
INSERT INTO tnp_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kəni məni=pən kəm nətəmimi məmə okotəharəg ləhtəni e nɨmanuvehli. Kəni təmos pɨret faif mɨne nəmu keiu əha, məsal-pəri əpəha e neai, məfaki=pən lan, kəni məhapu pɨret. Kəni məfən kəm rəhan mɨn nətəmimi, kəni kotəfən kəm nɨmənin nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kəni ilah rəfin kəmotauən, nərfɨlah tasisi. Kəni nɨpɨspɨsɨ nauəniən iətəm kəmotəpəh, nətəmimi rəha Iesu kəmotaipei=pən e kətɨm asoli ilah tueləf kotəri vivi. ");
INSERT INTO tnp_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kəni nətəmimi nətəm kəmotauən, nəman əmə təhmen e faif-tausɨn, mətəu kəsafiniən nɨpətan mɨne kəlkələh mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kəni Iesu təməni kəm rəhan nətəmimi məmə ilah okəhuvən e bot məhuvən e nəven=pən əpəha e lek, mətəu in otahli=pən nətəmimi kohtəlɨg=pən imalah mɨn ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nian tɨnahli=pən rəkɨs nətəmimi, kəni muvən əpəha ilɨs e nɨtəuət kəti in pɨsɨn əmə, məmə otəfaki. Nian tɨnapinəpu, Iesu pɨsɨn əmə əha ikɨn, ");
INSERT INTO tnp_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","mətəu bot tɨnuvən rəkɨs e nəlugɨ lek, kəni mɨnətələs pɨkɨn nɨmətagi, kəni peau-peau mɨn kɨnəutoh bot. ");
INSERT INTO tnp_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kəni lapɨn iuəkɨr o nianiən, Iesu təmaliuək e nəhue nəhu mətuva o lah. ");
INSERT INTO tnp_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Mətəu nian nətəmimi rəha Iesu kəmotafu in tətaliuək e nəhue nəhu, kəni kəmotəgɨn pɨk mautəni məmə, “!Ei, narmɨ iətəmimi kəti!” Kəni kəmotasək əfəməh mətəu-inu kəutəgɨn. ");
INSERT INTO tnp_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Mətəu uəhai əmə, Iesu təməghati kəm lah məmə, “!Ei, nɨkitəmah təhtul məha-məha. Mə iəu əpə. Sotəgɨniən!” ");
INSERT INTO tnp_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Kəni Pitə təni məmə, “Iərmənɨg, nəmə ik pəhriən, kəni auɨn lak iəkaliuək e nəhue nəhu muvnə.” ");
INSERT INTO tnp_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Kəni Iesu təməni=pən kəm in məmə, “Va.” Kəni Pitə təmeiuaiu e nəhue bot, kəni maliuək e nəhue nəhu matuvən o Iesu. ");
INSERT INTO tnp_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mətəu nian nɨkin təməhti nɨmətagi asoli, kəni nɨkin təməgɨn pɨk, kəni mɨnətamnɨm mətasək=pən o Iesu mətəni məmə, “!Iərmənɨg, asiru lak!” ");
INSERT INTO tnp_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kəni rəueiu agɨn Iesu təmeapən maskəlɨm Pitə, kəni məni=pən kəm in məmə, “Ik rəham nəhatətəiən təkəku agɨn. ?Təhro rəham nəhatətəiən təkəku ohniəu?” ");
INSERT INTO tnp_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kəni nian kəmuəri=pən e bot, kəni nɨmətagi təmeiuaiu. ");
INSERT INTO tnp_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kəni ilah əha e nəhue bot kəmotəfən nɨsiaiən asoli kəm in mautəni məmə, “Pəhriən, ik Nətɨ Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nian kɨnəhuvən e nəve nɨtəni=pən, kəməhuvari=pən e nɨtəni Kenesəret. ");
INSERT INTO tnp_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kəni nian nətəmimi əha ikɨn əha kinotəhrun Iesu, motahli=pən nəghatiən tuvən mɨtəlau o nətəmimi e lahuənu mɨn rəfin əha ikɨn. Kəni kəmotos rəhalah mɨn nətəmimi nətəm kautohmɨs məhuva o Iesu, ");
INSERT INTO tnp_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","kəni kəmotəkeikei o Iesu məmə ilah nətəm kautohmɨs okotek əmə nɨfɨfɨ napən rəhan. Kəni ilah rəfin nətəm kəmotek nɨfɨfɨ napən rəhan, rəhalah nɨmɨsiən təmɨkə, kəni kəmotəuvɨr. ");
INSERT INTO tnp_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kəni Farəsi mɨn nəuvein mɨne nəgətun mɨn nəuvein rəha Lou kəmotsɨpən Jerusɨləm məhuva o Iesu. Kəni motətapuəh ohni məmə, ");
INSERT INTO tnp_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“?Təhro rəham mɨn nətəmimi kəutatgəhli kastɨm rəhatah iətəm rəhatah kəha mɨn aupən kəmotəgətun itah lan? Ilah kəutauən mətəu kəsotaupəniən moteikuas e nəhlmɨlah.” ");
INSERT INTO tnp_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Kəni Iesu təməni=pən kəm lah məmə, “?Mətəu təhro itəmah mɨn nəutatgəhli Lou rəha Uhgɨn o naskəlɨm əskasɨkiən kastɨm pɨsɨn pɨsɨn mɨn rəhatəmah? ");
INSERT INTO tnp_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Iətəni lanəha mətəu-inu, Uhgɨn təməni məmə, ‘Nəkotɨsiai rəhatəmah tatə mɨne mamə,’ kəni təməni mɨn məmə, ‘Iətəmimi iətəm otəghati rah e rəhan tatə uə mamə, okəkeikei kohamu.’ ");
INSERT INTO tnp_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mətəu itəmah nəkotəni məmə, nəmə iətəmi kəti rəhan kəti məni əha ikɨn iətəm in təhrun nasiruiən e rəhan tatə mɨne mamə, in təhrun nəniən kəm lau məmə, ‘Kəsi, iəmələhu pɨsɨn məni u məmə rəha Uhgɨn,’ ");
INSERT INTO tnp_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","kəni təsəfəniən məni u kəm rəhan tatə, kəni noliən əha tətəgətun məmə ko in təsɨsiaiən in. E noliən əha, itəmah nautol nəghatiən rəha Uhgɨn tatol nati əpnapɨn lan, mətəu-inu itəmah nəkotolkeikei məmə nəkotaskəlɨm kastɨm mɨn əmə rəhatəmah. ");
INSERT INTO tnp_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","!Itəmah nəfaki eiuə mɨn. Nəkotəhmen e kəhvitei. Inu ihluə nəkotəuvɨr, mətəu nəkəutamɨkmɨk e nɨkitəmah. Iəni Aiseə təməghati əhruahru e təmah nian təməni pətɨgəm nəghatiən rəha Uhgɨn iətəm tətəni məmə, ");
INSERT INTO tnp_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Nətəmimi mɨn u kautɨsiai iəu e nohlɨlah əmə, mətəu nɨkilah isəu ohniəu, ");
INSERT INTO tnp_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Rəhalah noliən rəha nəfakiən kəm iəu in nati əpnapɨn əmə, kəni nian kəutəgətun, kəutəni məmə nəghatiən mɨn rəhak, mətəu in nəghatiən mɨn rəha nətəmimi əmə.’” ");
INSERT INTO tnp_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kəni Iesu təmauɨn e nətəmimi məmə okəhuva ohni, kəni məni=pən kəm lah məmə, “Otətəlɨg-to, kəni motəhrun nati u. ");
INSERT INTO tnp_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nati nak iətəm nətəfən e nohlɨm matun, təsoliən ik nəkamɨkmɨk e nəhmtɨ Uhgɨn, mətəu nati nak iətəm tatiet e nohlɨm, in tatol ik nəkamɨkmɨk e nəhmtɨ Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kəni rəhan mɨn nətəmimi kəməhuva ohni məutətapuəh məmə, “?Nəkəhrun məmə Farəsi mɨn, nɨkilah tərah nian kəmotətəu nəghatiən əha?” ");
INSERT INTO tnp_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Kəni təməni=pən məmə, “Nɨgi mɨn rəfin iətəm rəhak Tatə əpəha e negəu e neai təməsərfeiən, okeuvi-pəri ilah nokɨn. ");
INSERT INTO tnp_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Əpəh ilah. Ilah kautit nətəmimi, mətəu nəhmtɨlah təpɨs. Nəmə iətəmimi, iətəm nəhmtɨn təpɨs tit iətəmimi kəti iətəm nəhmtɨn təpɨs, kəni ilau pəti okiauvɨg=pən e nɨmɨl.” ");
INSERT INTO tnp_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kəni Pitə təməni=pən kəm in məmə “Əni-to nɨpətɨ nəghatiən əuhlin u kəm tɨmah.” ");
INSERT INTO tnp_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Kəni Iesu təməni=pən kəm lah məmə, “?Itəmah rəhak mɨn nətəmimi, mətəu itəmah mɨn nəsotəhrun əhanəhiən? ");
INSERT INTO tnp_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","?Nəkotəhrun uə kəpə məmə, nati nak iətəm tatuvən e nohlɨ iətəmimi meiuaiu e nərfɨn, kəni miet mɨn e nɨpətɨ iətəmimi? ");
INSERT INTO tnp_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Mətəu natimnati mɨn iətəm kautohiet e nohlɨ iətəmimi, ilah kautsɨpən e nɨki iətəmimi. Kəni natimnati mɨn tərah əpəha e nɨki iətəmimi kautol iətəmimi u tətamɨkmɨk e nəhmtɨ Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tol lanəha mətəu-inu, natimnati iətəm kautsɨpən e nɨki iətəmimi kotol lanu lan: nətəlɨgiən tərah mɨn; nohamuiən iətəmimi; nakləhiən e pətan; nɨpətan mɨne nəman mɨne, kautit oneuən ilah mɨn; nakləhiən; nəghati eiuəiən e nətəmimi; nəni rahiən nərgɨ iətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Inu natimnati iətəm tol iətəmimi tətamɨkmɨk e nəhmtɨ Uhgɨn. Mətəu nəmə iətəmi kəti təseikuasiən e nəhlmɨn kəni mauən, inu təsoliən in tamɨkmɨk e nəhmtɨ Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kəni Iesu təmiet ikɨn əha, kəni muvən ikɨn iətəm taun keiu əha, Taea mɨne Saedon kətuəməhli ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kəni pətan kəti əha ikɨn, Ianihluə pətan Kenan, təmuva ohni mətasək əfəməh məmə, “Iərmənɨg, Mipɨ Tefɨt, asiru lak. Narmɨn tərah kəti təskasɨk tətatɨg e nətɨk pətan mətərəkɨn in.” ");
INSERT INTO tnp_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mətəu Iesu təsəni=pən agɨniən nəghatiən kəti kəm in. Kəni rəhan nətəmimi kəməhuva mautəkeikei ohni, motəni məmə, “Ahli=pən in isəu, mətəu-inu tətasək əfəməh matuərisɨg e tah.” ");
INSERT INTO tnp_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Kəni Iesu təməni=pən kəm lah məmə, “Kəmahli=pa əmə iəu o sipsip mɨn rəha nəuanɨləuɨs rəha Isrel nətəm kəmotəluei.” ");
INSERT INTO tnp_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mətəu pətan əha təmuva mɨsin nəulɨn aupən e Iesu mətəni məmə, “Iərmənɨg, asiru lak.” ");
INSERT INTO tnp_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kəni Iesu təməni=pən məmə, “Təsəhruahruiən məmə iəkos nauəniən nɨg kəlkələh mɨn, kəni məraki=pən kəm kuri mɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kəni pətan u təməni=pən məmə, “Əuəh, Iərmənɨg. Mətəu kuri mɨn kautun nɨpɨspɨsɨ nauəniən iətəm tətəmei e tepɨl rəha narmənɨg mɨn rəhalah.” ");
INSERT INTO tnp_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kəni Iesu təməni=pən məmə, “Ei, pətan. !Rəham nəhatətəiən in iahgin! Nati nak iətəm nəkolkeikei, otuva mol nɨpəhriəniən.” Kəni rəueiu agɨn, nətɨn pətan təuvɨr mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kəni Iesu təmiet ikɨn əha maliuək e nɨkalɨ nəhu Lek Kaləli. Kəni məri muvən əpəha ilɨs e nɨtəuət kəti kəni mətəharəg. ");
INSERT INTO tnp_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nɨmənin nətəmimi kəməhuva ohni, mautos nətəmi mɨn u nətəm nəhlkɨlah təməpaiu-əpaiu, mɨne nətəmi mɨn u nəhmtɨlah təpɨs, mɨne nətəmi mɨn u nɨpətɨlah nəuvetɨn təmɨmɨs, mɨne nətəmi mɨn u kotəruru nəghatiən, mɨne nɨmɨsiən pɨsɨn pɨsɨn mɨn. Kəni motəlɨn=pən ilah iuəkɨr o Iesu, kəni tol vivi ilah. ");
INSERT INTO tnp_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kəni nɨmənin nətəmimi narmɨlah təmiuvɨg nian kəmotafu nətəmimi kotəruru nəghatiən kəmotəghati, mɨne nətəm nɨpətɨlah nəuvetɨn təmɨmɨs kotəuvɨr, mɨne nətəm nəhlkɨlah təməpaiu-əpaiu kotaliuək, mɨne nətəm nəhmtɨlah təpɨs koteruh nati. Kəni mautəni-vivi Uhgɨn rəha Isrel. ");
INSERT INTO tnp_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kəni Iesu təmauɨn e rəhan mɨn nətəmimi kəhuva ohni, təməni=pən kəm lah məmə, “Nɨkik nahmə pɨk o nətəmimi mɨn u. Kitah min ilah o nian kɨsɨl əha rəueiu, kəni nati tɨkə məmə okotun. Iəsolkeikeiən məmə iəkahli=pən ilah kautəhuvən, nəumɨs tus ilah, məta nəuvein kohmɨseah e suaru.” ");
INSERT INTO tnp_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kəni rəhan nətəmimi kotəni=pən kəm in məmə, “?Okotos iə pɨret u ikɨnu, ikɨn təpiə-məpiə ikɨn iətəm təhmen məmə okotaugɨn nɨmənin nətəmimi lan?” ");
INSERT INTO tnp_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Kəni Iesu təməni=pən kəm lah məmə, “?Pɨret ko kuvəh u nautos?” Kəni kotəni=pən məmə, “Iautos pɨret səpɨn mɨne nəmu əkəku nəuan nəuvein əmə.” ");
INSERT INTO tnp_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kəni Iesu təməni=pən kəm nɨmənin nətəmimi məmə okotəharəg e nɨftəni. ");
INSERT INTO tnp_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kəni təmos pɨret ilah səpɨn, mɨne nəmu əlkələh, kəni məfaki məni tagkiu kəm Uhgɨn ohni, kəni məhapu ilah, məfən kəm rəhan mɨn nətəmimi, kəni kotəfən kəm nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kəni ilah rəfin kəmotun nərfɨlah tasisi. Kəni nətəmimi rəha Iesu kəmotaipei=pən nɨpɨspɨsɨ nauəniən iətəm kəmotun motəpəh e kətɨm asoli ilah səpɨn, kəmotəri vivi. ");
INSERT INTO tnp_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nətəmimi nətəm kəmotun, nəman ilah fo-tausɨn, mətəu kəsafiniən nɨpətan mɨne kəlkələh mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kəni Iesu tahli=pən nɨmənin nətəmimi kautəhuvən, kəni in təmuvən e bot muvən ikɨn Makatən. ");
INSERT INTO tnp_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Kəni Farəsi mɨn mɨne Satusi mɨn kəməhuva o Iesu, kəni kəmotəghati əuhlin kəm in məmə otol kəm lah nəmtətiən kəti rəha negəu e neai, inu nati apɨspɨs asoli iətəm otəgətun məmə Uhgɨn təmahli=pa in. ");
INSERT INTO tnp_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kəni təməni=pən kəm lah məmə, “Nian tɨnəhnaiuv, nəkotəni məmə, ‘olauɨg tərauiə, mətəu-inu nəpuə tətərəuvarəuv.’ ");
INSERT INTO tnp_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kəni ləplapɨn nəkotəni məmə, ‘Nuhuən otəfuv, mətəu-inu nəpuə tɨnərəuvarəuv mɨtəlau.’ Nəkotəhrun nəniən məmə nɨpətɨ nəmtətiən mɨn e nɨmalɨ nəpuə iətəm tatiet, mətəu nəkotəruru nəniən nɨpətɨ nəmtətiən iətəm nəuteruh əha rəueiu, inəha nati agɨn mɨn iətəm kəutəhuva e nəmiəgəhiən rəhatəmah rəueiu. ");
INSERT INTO tnp_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","“Itəmah nətəmimi rəueiu mɨne, nəkotərah, itəmah nətəm Isrel nəmotəpəh rəhatəmah nəhatətəiən e Uhgɨn, təhmen e pətan kəti tətəpəh rəhan iərman mətɨtəu=pən suah pɨsɨn. Kəni rəueiu nəkotolkeikei məmə iəkol nəmtətiən kəti iətəm otəgətun məmə iəmsɨpən e Uhgɨn. Mətəu Uhgɨn otəfɨnə əmə nəmtətiən kətiəh əmə, kəni inəha nəmtətiən rəha iəni Jonə.” Kəni in təməpəh ilah matuvən. ");
INSERT INTO tnp_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nian Iesu mɨne rəhan mɨn nətəmimi kəmautəhuvən e nəve nəhu=pən e nəhu Lek Kaləli, rəhan nətəmimi kəmotalu məmə okotos pɨret nəuvein. Kəni nian kɨnəhuvən e nəve nəhu=pən, ");
INSERT INTO tnp_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","kəni təməni=pən kəm rəhan nətəmimi məmə, “Onəutətəu itəmah o is rəha Farəsi mɨn mɨne Satusi mɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kəni nəruruiən tɨnos ilah, kəni kəmotəni=pən kəm lah mɨn məmə, “Tətəghati lanəha mətəu-inu kəmotalu e nəmkiən pɨret nəuvein.” ");
INSERT INTO tnp_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Mətəu Iesu tɨnəhrun rəhalah nətəlɨgiən, kəni təməni=pən kəm lah məmə. “Ei, rəhatəmah nəhatətəiən təkəku agɨn. ?Təhro nəutəni=pən kəm təmah mɨn məmə pɨret tɨkə o təmah? Mətəu təhro nəutətəlɨg pɨk məmə pɨret tɨkə? ");
INSERT INTO tnp_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","?Nəsotəhrun əhanəhiən, uə kəpə? ?Nɨnotalu e pɨret faif u iətəm iəmaugɨn nətəmimi faif-tausɨn lan, kəni uərisɨg, nauəniən tepət əha ikɨn kəməpəh, kəni nəməhuveipei=pən nɨpɨspɨsɨ nauəniən e kətɨm asoli tepət? ");
INSERT INTO tnp_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","?Kəni nɨnotalu e pɨret səpɨn u iətəm iəmaugɨn nətəmimi fo-tausɨn? Kəni kəpəh nɨpɨspɨsɨ nauəniən tepət əha ikɨn, kəni nəmotaipei=pən e kətɨm asoli tepət. ");
INSERT INTO tnp_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","?Təhro itəmah nəsotəhruniən məmə iəu iəsəghatiən e pɨret? Autətəu itəmah o is rəha Farəsi mɨn mɨne Satusi mɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Təməni lan əha, kəni e nian əha, ilah kəmotəhrun məmə in təsəghatiən e is rəha noliən pɨret məmə okautətəu ilah ohni, mətəu okotətəu ilah o nəghatiən mɨn iətəm Farəsi mɨn mɨne Satusi mɨn kautəgətun nətəmimi lan. ");
INSERT INTO tnp_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nian Iesu təmuva ikɨn Sisəriə Fɨlɨpai, məni=pən kəm rəhan mɨn nətəmimi məmə, “?Nətəmimi kautəni iəu məmə iəu pəh, Nətɨ Iətəmimi?” ");
INSERT INTO tnp_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kəni kotəni=pən məmə, “Nəuvein kautəni məmə ik Jon Bəptais, nəuvein kautəni məmə ik iəni Elaijə, kəni nəuvein kautəni məmə ik iəni Jerɨmaiə, uə iəni kəti aupən ikɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Kəni təməni=pən kəm lah məmə, “?Mətəu təhro e təmah? ?Nəkotəni məmə pəh u iəu?” ");
INSERT INTO tnp_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Kəni Saimon Pitə təməni=pən məmə, “Ik Krɨsto iətəm Uhgɨn təməni məmə otahli=pa. Ik Nətɨ Uhgɨn iətəm tətatɨg mətəmiəgəh.” ");
INSERT INTO tnp_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Kəni Iesu təməni=pən məmə, “Uhgɨn təməfɨnə rəhan nəuvɨriən kəm ik, Saimon nətɨ Jonə, mətəu-inu səniəmə iətəmimi əmə təmol pətɨgəm nati u kəm ik, mətəu rəhak Tatə əpəha e negəu e neai iətəm təmol əpu nati u kəm ik. ");
INSERT INTO tnp_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kəni iəkəni=pɨnə kəm ik Pitə, u nɨpətɨn təni məmə kəpiel. Kəni iəkuvləkɨn rəhak niməfaki e kəpiel u, kəni ko nəsanəniən rəha nɨmɨsiən otəsapirəkɨsiən. ");
INSERT INTO tnp_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Iəkəfɨnə kəm ik nepətiən iətəm tatsɨpən o Uhgɨn əpəha e negəu e neai. Kəni əpəha e negəu e neai, Uhgɨn tɨnegəhan rəkɨs e nəuiam iətəm onəkəni e nəhue nɨftəni. Nian onəkahtɨpəsɨg e nati kəti, uə nəkegəhan e nati kəti, kəni otol.” ");
INSERT INTO tnp_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kəni məni=pən əskasɨk kəm rəhan nətəmimi məmə okəsotəni-pəniən kəm iətəmi kəti məmə in Krɨsto iətəm Uhgɨn təməni məmə otahli=pa. ");
INSERT INTO tnp_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","E nian əha, Iesu təmətuəuin mətəni pətɨgəm kəm rəhan nətəmimi məmə in otəkeikei muvən Jerusɨləm, kəni pris asoli mɨn, mɨne nəgətun mɨn rəha Lou, mɨne nətəmi asoli mɨn rəfin rəha nətəm Isrel okotol in tətəu nahməiən e nərahiən tepət, kəni okotohamu in. Kəni uərisɨg e nian kɨsɨl lan, in otəmiəgəh mɨn e nɨmɨsiən. ");
INSERT INTO tnp_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kəni Pitə tos pɨsɨn Iesu, kəni mətuəuin mətəniəhu mətəni məmə, “Iərmənɨg, Uhgɨn otəkeikei mahtɨpəsɨg e nati əha. !Nati əha ko təsuvaiən mol nɨpəhriəniən lan!” ");
INSERT INTO tnp_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kəni Iesu təlali məni=pən kəm Pitə məmə, “!Setən! !Uvən isəu ohniəu! Ik nətəhtul-pəsɨg lak. Rəham nətəlɨgiən səniəmə nətəlɨgiən rəha Uhgɨn, mətəu in nətəlɨgiən rəha nətəmimi əmə.” ");
INSERT INTO tnp_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kəni Iesu təməni=pən kəm rəhan nətəmimi məmə, “Iətəmimi iətəm tolkeikei məmə otuərisɨg lak, otəkeikei malu aru lan, kəni mələs rəhan nɨgi kəməluau mɨtəu=pa iəu. ");
INSERT INTO tnp_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tol lanəha mətəu-inu, iətəmimi iətəm tatol pɨk uək əmə məmə rəhan nəmiəgəhiən e nəhue nɨftəni u in otəuvɨr, otəmkarəpən e nəmiəgəhiən pəhriən. Mətəu iətəmimi iətəm otɨmɨs o nərgək, in otos nəmiəgəhiən itulɨn. ");
INSERT INTO tnp_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","?Nəmə iətəmimi kəti tatos rəfin natimnati e nəhue nɨftəni, mətəu təsosiən nəmiəgəhiən itulɨn, in təmol win e nati təuvɨr, uə kəpə? Kəpə. Ko iətəmi əha təsəfəniən nati kəti rəha nəhue nɨftəni kəm Uhgɨn məmə Uhgɨn otəfən nəmiəgəhiən itulɨn kəm in. ");
INSERT INTO tnp_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tol lanəha mətəu-inu, iəu Nətɨ Iətəmimi iəpanuva itɨmah nagelo mɨn e nəsanəniən mɨne nepətiən əhagəhag asoli rəha Tatə rəhak, kəni iəkəfən nətəouiən kəm nətəmimi rəfin e uək əhruahru iətəm kəmotol. ");
INSERT INTO tnp_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Iətəni=pɨnə nɨpəhriəniən məmə nətəmimi nəuvein kautəhtul u ikɨnu nətəm kəsohmɨsiən motəmiəgəh əmə moteruh Nətɨ Iətəmimi u in kig, nian tətuva e narmənɨgiən rəhan.” ");
INSERT INTO tnp_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nian sikɨs tɨnuva mɨnuvən rəkɨs, Iesu tit Pitə, mɨne Jemɨs, mɨne Jon u pia Jemɨs, mit ilahal məhuvən əpəha ilɨs e nɨtəuət əfəməh, ilah pɨsɨn əmə. ");
INSERT INTO tnp_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kəni ikɨn əha, nɨpətɨ Iesu təməuhlin muva mol pɨsɨn. Rəhn-kapə təmasiə məhagəhag təhmen e mɨtɨgar, kəni rəhan napən tɨnuva məruən məhagəhag. ");
INSERT INTO tnp_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Rəueiu agɨn, Mosɨs mɨne Elaijə kəmiaietɨgəm=pa məhləghati ilahal Iesu. ");
INSERT INTO tnp_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kəni Pitə təməni=pən kəm Iesu məmə, “!Iərmənɨg! Təuvɨr məmə itɨmahal u iəmluva u ikɨnu. Nəmə nəkolkeikei, iəkol nɨmauvluvl kəti u ikɨnu, rəham kəti, rəha Mosɨs kəti, kəni rəha Elaijə kəti.” ");
INSERT INTO tnp_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nian Pitə təmətəghati əhanəh, nəpuə əhagəhag kəti təmuva məuveg ilah, kəni kəmotətəu nəuia iətəmi kəti təmiet e nəpuə mətəni məmə, “Inu nətɨk iətəm iəkolkeikei pɨk. Nɨkik tagiən pɨk ohni. !Nəklətəlɨg lan!” ");
INSERT INTO tnp_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nian suah milahal əha kəmhlətəu nəghatiən əha, mɨhləmei=pən mɨhlɨtənɨm=pən rəhn-kapə lahal e nɨftəni məhləgɨn pɨk. ");
INSERT INTO tnp_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Mətəu Iesu təmuva mek ilahal mətəni məmə, “Ləhtul. Sləgɨniən.” ");
INSERT INTO tnp_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nian kəmhləsal-pəri, məsleruh mɨniən iətəmi kəti, mətəu Iesu pɨsɨn əmə. ");
INSERT INTO tnp_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nian kəmoteiuaiu=pa e nɨtəuət, Iesu təni kəm lahal məmə, “Nəsləniən kəm iətəmimi kəti nati nak iətəm nəmhleruh mətəuarus=pən Nətɨ Iətəmimi otəmiəgəh mɨn e nɨmɨsiən.” ");
INSERT INTO tnp_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kəni kɨhləni=pən məmə, “?Mətəu təhro nəgətun mɨn rəha Lou kəutəni məmə Elaijə otəkeikei maupən muva mɨn?” ");
INSERT INTO tnp_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Kəni Iesu təməni=pən məmə, “Nɨpəhriəniən məmə Elaijə otəkeikei maupən muva məmə otol vivi mɨn natimnati rəfin. ");
INSERT INTO tnp_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mətəu iəkəni=pɨnə kəm təmahal məmə, Elaijə tɨnuva rəkɨs, mətəu nətəmimi kəsotəhruniən in, kəni motol tərah lan. E noliən əhmen mɨn əmə, Nətɨ Iətəmimi otətəu nahməiən e nəhlmɨlah.” ");
INSERT INTO tnp_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kəni rəhan nətəmimi kɨnotəhrun məmə tətəghati e Jon Bəptais kəm lah nian tətəghati e iəni Elaijə. ");
INSERT INTO tnp_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nian kɨnohiet=pa o nɨmənin nətəmimi, suah kəti tuva mɨsin nəulɨn aupən e Iesu, ");
INSERT INTO tnp_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","kəni məni məmə, “Iərmənɨg, asiru e nətɨk. Tətauɨt, kəni mətətəu pɨk nahməiən lan. Nian tepət tətəmei=pən e nɨgəm, mətəmei=pən e nəhu. ");
INSERT INTO tnp_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Iəmələs muvən o rəham mɨn nətəmimi, mətəu kotəruru nol viviən.” ");
INSERT INTO tnp_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Kəni Iesu təməni=pən məmə, “!Ei! Itəmah nətəmi rəueiu nəsotəhatətəiən, kəni nɨnəhuvən isəu o suaru rəha Uhgɨn. !?Kərmə oiəkatɨg kitah min itəmah mətəuarus=pən nian nak nəmanotəhatətə lak!? !?Kəni kərmə onəhgɨn iəpanəmeig e təmah!? !Otit suakəku ko məhuva kəm iəu!” ");
INSERT INTO tnp_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Kəni Iesu təməghati əskasɨk kəm narmɨn tərah, kəni tiet e suakəku, kəni rəueiu agɨn suakəku təməuvɨr. ");
INSERT INTO tnp_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kəni rəhan nətəmimi kəməhuva motəhtul pɨsɨn ilah Iesu, kəni motətapuəh ohni məmə, “?Təhro itɨmah iəkotəruru nəhgi pətɨgəmiən narmɨn tərah?” ");
INSERT INTO tnp_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Kəni Iesu təməni=pən kəm lah məmə, “Mətəu-inu rəhatəmah nəhatətəiən təkəku əmə, təsəhmeniən. Mətəu iətəni pəhriən kəm təmah məmə, nəmə rəhatəmah nəhatətəiən əha ikɨn, nati əpnapɨn təhmen e nɨkɨtɨ mastət u təkəku agɨn, kəni nəkotəhrun nəni-pəniən kəm nɨtəuət u məmə, ‘Iet u e nɨmeim, muvən ikɨn əha,’ kəni nɨtəuət otiet, kəni nati kəti tɨkə iətəm itəmah nəkotəruru noliən.” ");
INSERT INTO tnp_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nian kəməhuva kətiəh əpəha Kaləli, Iesu təməni=pən kəm lah məmə, “Iəu Nətɨ Iətəmimi, suah kəti otegəhan=pən lak e nəhlmɨ tɨkɨmɨr mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nətəmimi okotohamu iəu, kəni uərisɨg e nian kɨsɨl, Uhgɨn otosmiəgəh mɨn iəu e nɨmɨsiən.” Kəni rəhan mɨn nətəmimi kəmotətəu tərah pɨk agɨn o nəghatiən əha. ");
INSERT INTO tnp_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nian Iesu mɨne rəhan nətəmimi kəməhuva Kapeniəm, nətəmimi rəha nosiən məni rəha takɨs rəha Nimə Rəha Uhgɨn, kəməhuva o Pitə motəni məmə, “?Təhro? ?Rəham iəgətun tatətəou takɨs u, uə kəpə?” ");
INSERT INTO tnp_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Kəni Pitə təməni=pən məmə, “Əuəh, tatətəou.” Nian Pitə təmuvən e nɨpəgnəua nimə, kəni Iesu təmaupən məghati mətəni kəm in məmə “?Saimon, nɨkim təhti məmə nak? ?Kig mɨn rəha nəhue nɨftəni kautos takɨs o pəh, kautos o rəhalah mɨn nətəmimi, uə nətəmimi pɨsɨn mɨn?” ");
INSERT INTO tnp_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pitə təməni=pən məmə, “Kautos o nətəmimi pɨsɨn mɨn.” Kəni Iesu təməni=pən məmə, “Kəni tol lanəha, nətəmimi rəha kig kəsotətəouiən. ");
INSERT INTO tnp_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mətəu kitah kəsotolkeikeiən məmə kotol ilah kotətəu tərah o tah. Kəni tol lanəha, təuvɨr məmə ik onəkuvən əpəha ləuahtəni e lek, məraki rəham nɨpien o niuviən nəmu. Nəmu iətəm nəkaupən miuvi, məhapu nɨpəgnəuan, kəni meruh məni silfə kəti təhmen o nətəouiən takɨs. Mos muvən məfən kəm lah o nətəouiən rəhalau takɨs.” ");
INSERT INTO tnp_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","E nian əha, nətəmimi rəha Iesu kəməhuva ohni motətapuəh ohni məmə, “?Pəh u in iətəmi asoli e Narmənɨgiən Rəha Uhgɨn?” ");
INSERT INTO tnp_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kəni Iesu tauɨn e suakəku kəti tuva məhtul e nəlugɨn e lah, ");
INSERT INTO tnp_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","kəni məni məmə, “Pəhriən iətəni kəm təmah məmə nəmə nəsotəuhliniən itəmah məhuva motəhmen e kəlkələh mɨn, ko nəsəhuvəniən motatɨg ahgəl Narmənɨgiən Rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tol lanəha, pəh u otosiahu in təhmen e suakəku u, in iətəmi asoli e Narmənɨgiən Rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Nəmə iətəmi kəti in ləhtəni təhmen e suakəku u, kəni iətəmimi kəti nɨkin tagiən o nosiən iətəmimi u muvən e nɨpəgnəuan nimə rəhan, kəni nəmə tatol e nərgək, kəni in təhmen məmə tatos iəu mɨn e nɨkin agiən. ");
INSERT INTO tnp_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Rəhak iətəmimi u tətəhatətə lak təhmen e suakəku əha. Kəni nəmə iətəmimi kəti tatiuvi=pən suakəku kəti əha məmə tatol təfagə tərah, kəni iətəmimi əha, Uhgɨn otol nalpɨniən asoli kəm in. Kəni nalpɨniən əha otəskasɨk tapirəkɨs nəmə kətu=pən kəpiel kəti e nentəui, kəni kəraki=pən lan əpəha ləuantəhi lokamnɨm təmnɨm. ");
INSERT INTO tnp_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Kəsi, nahməiən asoli otuva o nətəmimi rəha nəhue nɨftəni, nətəm kautəfən-əfən kəm nətəmimi məmə okotol təfagə tərah. Nəfən-əfəniən mɨn əha okotəkeikei məhuva. Mətəu kəsi, nahməiən asoli otuva o iətəmimi u iətəm in suaru rəha nərahiən əha. ");
INSERT INTO tnp_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nəmə nəhlməm uə nəhlkəm tol ik natol təfagə, kəni nəkətei rəkɨs məraki lan. Mətəu-inu təuvɨr pɨk məmə nian nəkuvən e negəu e neai, nəhlkəm kəti uə nəhlməm kəti tɨkə, tapirəkɨs agɨn məmə ik nətaskəlɨm nəhlməm pəti mil mɨne nəhlkəm pəti mil əha ikɨn, kəni kəraki=pən lam e nɨgəm iətəm tatuəu naunun tɨkə. ");
INSERT INTO tnp_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nəmə nəhmtəm tol ik natol təfagə, kəni ɨsul rəkɨs məraki lan. Mətəu-inu təuvɨr pɨk məmə nian nəkuvən e negəu e neai, nəhmtəm kəti tɨkə, tapirəkɨs agɨn inu məmə ik nətaskəlɨm nəhmtəm pəti mil, kəni kəraki=pən lam e nɨgəm asoli iətəm tatuəu naunun tɨkə.” ");
INSERT INTO tnp_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Kəni Iesu təməni=pən məmə, “Nəkotəkeikei motəhrun vivi məmə nəsotehauiən nətəmimi rəhak mɨn nətəm kotəhmen e kəlkələh mɨn, mətəu-inu iətəni kəm təmah məmə nagelo mɨn nətəm kauteh ilah, nian rəfin ilah kautəhtul e nəhmtɨ rəhak Tatə u tətatɨg əpəha e negəu e neai məmə okotəni pətɨgəm ilah kəm in. ");
INSERT INTO tnp_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“?Nɨkitəmah təhti məmə nak? ?Nəmə iətəmimi kəti rəhan sipsip uan-hanrɨt, kəni kətiəh təluei mətan, kəni iətəmi əha otol nak? In otəpəh nainti-nain əpəha nɨtəuət, kəni muvən məsal e inu iətəm təməluei. ");
INSERT INTO tnp_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kəni nəmə təmeruh, iətəni pəhriən kəm təmah məmə, nɨkin otagiən o sipsip u kətiəh əmə, tapirəkɨs mɨn ilah u nainti-nain u kəməsotəlueiən. ");
INSERT INTO tnp_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","E noliən əhmen mɨn əmə, rəhatəmah Tatə əpəha e negəu e neai, in təsolkeikeiən məmə nətɨn kəti otuvən məluei.” ");
INSERT INTO tnp_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Kəni Iesu təməni məmə, “Nəmə piam kəti tol noliən tərah kəti kəm ik, uvən meruh itəlau pɨsɨn əmə, kəni nəkəni=pən nati nak iətəm təmol təsəhruahruiən. Nəmə tətətəlɨg lam, rəham nəghatiən otol in tɨtəlɨg=pa mɨn muəuvɨr o təlau mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mətəu nəmə təsətəlɨgiən lam, os iətəmimi kətiəh uə keiu mɨhluvən mɨn mɨhleruh məmə nəghatiən mɨn rəfin onəkotəni, okotəhrun məmə ilah rəfin nɨpəhriəniən əmə. ");
INSERT INTO tnp_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mətəu nəmə təsətəlɨg mɨniən e təmah, nəkəni=pən kəm niməfaki kəni pəh iətəmi kəti rəha niməfaki otəghati kəm in. Mətəu nəmə təsətəlɨgiən e niməfaki, kəni niməfaki otol in məmə Ianihluə uə iətəmimi rəha nosiən məni rəha takɨs. ");
INSERT INTO tnp_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Iətəni pəhriən kəm təmah məmə, əpəha e negəu e neai, Uhgɨn tɨnegəhan rəkɨs məmə nəuiatəmah iətəm nəkotəni e nəhue nɨftəni. Nian nəkautahtɨpəsɨg e nati kəti uə nəkautegəhan e nati kəti, kəni otol məmə inu mɨne. ");
INSERT INTO tnp_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Kəni iətəni pəhriən mɨn kəm təmah məmə, nəmə itəlau keiu nəkuəni əskasɨk nəghatiən kəti o nati kəti kəni muətapuəh ohni e nəfakiən kəm Uhgɨn, kəni rəhak Tatə əpəha e negəu e neai otol nati nak iətəm nəkotətapuəh ohni. ");
INSERT INTO tnp_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tol lanəha mətəu-inu, ikɨn pəhruvən iətəmimi keiu uə kɨsɨl kɨhluva kətiəh e nərgək, iəu əha ikɨn e nəlugɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kəni Pitə təmuva o Iesu kəni mətapuəh ohni məmə, “Iərmənɨg. ?Nəmə piak kəti tatol tərah kəm iəu, kəni oiəkalu məsalpɨniən e noliən tərah rəhan mau kuvəh? ?Mau səpɨn?” ");
INSERT INTO tnp_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Kəni Iesu təməni=pən məmə, “Iəkəni=pɨnə kəm ik məmə, səniəmə mau səpɨn əmə, mətəu mau səpɨnte-səpɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Nəkəkeikei mol lanəha mətəu-inu Narmənɨgiən Rəha Uhgɨn təhmen e nəghatiən əuhlin u. Kig kəti tolkeikei məmə oteruh-to kauɨn mɨn iətəm rəhan nətəmimi kəmotol kəm in məmə ilah okotətəou. ");
INSERT INTO tnp_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nian tɨnətuəuin uək əha, kotələs rəhan kəti ioluək məhuva ohni iətəm təmol rəhan kauɨn iahgin agɨn, təhmen e fifti-tausɨn-miliən vatu (50,000,000,000 vatu). ");
INSERT INTO tnp_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mətəu suah kəha tɨnəruru nətəouiən, kəni tol lanəha, kig təməni məmə okotol səlɨm lan, mɨne rəhan pətan, mɨne rəhan mɨn kəlkələh mɨn, mɨne rəhan natimnati mɨn rəfin məmə otətəou rəhan kauɨn. ");
INSERT INTO tnp_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Kəni rəhan ioluək təmeiuaiu mɨsin nəulɨn aupən lan. Kəni mətəkeikei ohni mətəni=pən kəm in məmə, ‘Pale. ?Nəkəhrun nəfaiən nian əkuəkɨr nəuvetɨn kəm iəu məmə iəkətəou rəfin rəhak kauɨn?’ ");
INSERT INTO tnp_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kəni rəhan iətəmi asoli təmasəkəhruin in, kəni məpəh rəfin rəhan kauɨn məmə otəsətəouiən nian kəti mɨne, kəni megəhan lan məmə tuvən. ");
INSERT INTO tnp_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Mətəu nian ioluək u təmuvən, kəni meruh iətəmimi kəti u təmol kauɨn kəm in, təhmen e uan-hanrɨt tausɨn vatu (100,000 vatu). Ilau pəti ioluək mil katuol uək kətiəh əmə rəha iətəmi asoli u. Kəni ioluək iətəm iətəmi asoli təmalu e rəhan kauɨn, in təmaskəlɨm iətəmimi u kəti kəmatuol pəti uək, kəni mətəmkəhtuv nentəui, mətəni məmə, ‘!Ətəou=pa rəham kauɨn iətəm nəmol kəm iəu!’ ");
INSERT INTO tnp_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Kəni ioluək əha iətəm təmol kauɨn kəm in, teiuaiu mɨsin nəulɨn mətəkeikei ohni mətəni məmə, ‘Pale. ?Nəkəhrun nəfaiən nian əkuəkɨr nəuvetɨn kəm iəu məmə iəkətəou rəhak kauɨn?’ ");
INSERT INTO tnp_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Mətəu in təni məmə, kəpə. Kəni təmuvən məni məmə okələs suah u kan kləfən e kaləpus mətəuarus otətəou rəfin rəhan kauɨn iətəm təmol. ");
INSERT INTO tnp_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mətəu noluək mɨn nəuvein mɨn kəmoteruh nati əha, nɨkilah təmahmə pɨk ohni, kəni məhuvən motəni=pən kəm iətəmi asoli natimnati rəfin iətəm kəmoteruh. ");
INSERT INTO tnp_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Kəni iətəmi asoli təmauɨn e ioluək əha tuva təni=pən kəm in məmə, ‘Ik ioluək tərah agɨn. Iəməpəh rəfin rəham kauɨn mətəu-inu nəmatəkeikei ohniəu. ");
INSERT INTO tnp_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","?Təhro nəsasəkəhruiniən iətəmi u natuol pəti uək itəlau min, təhmen=pən əmə e iətəm iəmol kəm ik?’ ");
INSERT INTO tnp_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","?Kəni niəməha təmol iətəmi asoli, kəni təni məmə okələs kan kləfən e kaləpus məmə iətəm tətəhtul o kaləpus otaskəlɨm in mətəuarus=pən otətəou rəfin rəhan kauɨn iətəm təmol.” ");
INSERT INTO tnp_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Kəni nian Iesu təmol naunun e nəghatiən əuhlin, təməni=pən kəm lah məmə, “Kəni e suaru kətiəh əmə, rəhak Tatə əpəha e negəu e neai, otol kəm təmah rəfin, nəmə nəutalpɨn məsotalu pəhriəniən e nərahiən iətəm piatəmah mɨn kautol kəm təmah.” ");
INSERT INTO tnp_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nian Iesu təmol naunun e nəniən natimnati mɨn u, kəni miet Kaləli muvən e nɨtəni Jutiə e nɨtəni=pən e nɨkalɨ nəhu Jotən. ");
INSERT INTO tnp_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kəni nɨmənin nətəmimi kəmautəhuərisɨg lan məhuvən əha ikɨn əha, kəni təmol vivi ilah e nɨmɨsiən mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Kəni Farəsi mɨn nəuvein kəmotol nəniən ekəu-ekəu məmə otiuvi=pən Iesu e nəghatiən kəti iətəm təsəhruahruiən. Kəməhuva o Iesu motəni məmə, “?Lou tətəni məmə iərman təhrun nəpəhiən rəhan pətan mol difos lan o nati əpnapɨn əmə kəti uə kəpə?” ");
INSERT INTO tnp_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Kəni təmol aulɨs ilah məni=pən məmə, “?Nəmotafin uə kəpə məmə, e nətuəuiniən nian muva mətəuarus=pa u rəueiu, Uhgɨn u iətəm təmol nətəmimi rəfin, təmol iərman mɨne pətan? ");
INSERT INTO tnp_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kəni Uhgɨn u inu, u təməni məmə, ‘O nati əha in əha, iərman otəpəh rəhan tatə mɨne mamə, kəni mətuatɨg ilau rəhan pətan. Kəni ilau okiəuva nɨpətɨlau kətiəh.’ ");
INSERT INTO tnp_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kəni rəueiu, ilau səniəmə keiu, mətəu kətiəh əmə. Uhgɨn tɨnɨlpɨn ilau kɨniəuva mɨnuol kətiəh, kəni o nati əha, pəh iətəmimi əpnapɨn əmə kəti ko təsətahtuviən rəhalau natɨgiən.” ");
INSERT INTO tnp_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kəni Farəsi mɨn kotəni=pən məmə, “?Mətəu təhro Mosɨs təməni məmə iətəmimi təhrun nəfəniən nauəuə kəti kəm rəhan pətan o nəpəhiən mol difos lan, kəni mahli=pən tatuvən?” ");
INSERT INTO tnp_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Kəni Iesu təməni=pən məmə, “Mosɨs təmegəhan e təmah nətəm Isrel məmə onəkotəpəh rəhatəmah nɨpətan mɨn motol difos e lah mətəu-inu rəhn-kapə təmah təskasɨk pɨk. Mətəu aupən, e nətuəuiniən nian muva mətəuarus=pa u rəueiu təməsoliən lanu. ");
INSERT INTO tnp_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mətəu iətəni kəm təmah məmə, nəmə suah kəti tatol tifos mətəpəh rəhan pətan mətəu pətan u təsapɨliən ilau suah pɨsɨn kəti, kəni suah u in mit pətan pɨsɨn, təhmen əmə məmə in tatol təfagə mətakləh e pətan əha.” ");
INSERT INTO tnp_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kəni nətəmimi rəha Iesu kotəni məmə, “Nəmə natɨgiən rəha iərman mɨne pətan təskasɨk pɨk lanu, təuvɨr məmə iərman mɨne pətan okəsuoliən marɨt.” ");
INSERT INTO tnp_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Kəni Iesu təməni=pən məmə, “Səniəmə nətəmimi rəfin okotəhrun nosiən nəghatiən u, mətəu nətəmimi əmə mɨn konu nətəm kəməfən nəghatiən u kəm lah, məmə rəhalah əmə. ");
INSERT INTO tnp_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tol lanəha mətəu-inu, nətəmimi nəuvein okəsotoliən marɨt o nati pɨsɨn pɨsɨn mɨn. Kəti ko təsoliən marɨt mətəu-inu nɨpətɨn nəuvetɨn tərah nian təmair. Kəti ko təsoliən marɨt mətəu-inu nətəmimi kəmotərəkɨn nɨpətɨn nəuvetɨn. Kəni kəti tətəni aru məmə in otəsoliən marɨt məmə otol uək rəha Narmənɨgiən Rəha Uhgɨn. Iətəmimi iətəm təhrun nosiən nəghatiən u, in təkeikei mos.” ");
INSERT INTO tnp_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kəni nətəmimi kəmotos kəlkələh mɨn məhuva o Iesu məmə otələhu=pən nəhlmɨn e lah, kəni məfaki o lah. Mətəu nətəmimi rəha Iesu kəmotəniəhu ilah. ");
INSERT INTO tnp_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Mətəu Iesu təməni=pən kəm lah məmə, “Pəh kəlkələh mɨn kəhuva ohniəu, sotəniəhuiən ilah, mətəu-inu Narmənɨgiən Rəha Uhgɨn in rəha nətəmimi mɨn u kotol lanu.” ");
INSERT INTO tnp_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kəni təmələhu=pən nəhlmɨn e lah məfaki o lah, kəni miet ikɨn əha. ");
INSERT INTO tnp_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kəni suah kəti təmuva o Iesu məni=pən məmə, “Iəgətun. ?Iəu oiəkəkeikei mol uək nak iətəm in təuvɨr məmə iəkos nəmiəgəhiən itulɨn?” ");
INSERT INTO tnp_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Kəni Iesu təməni=pən məmə, “?Təhro nətətapuəh ohniəu o nati nak iətəm təuvɨr? Iətəmi kətiəh əmə iətəm in təuvɨr. Nəmə nəkolkeikei məmə nəkos nəmiəgəhiən itulɨn, ɨtəu=pən nəghatiən mɨn rəha Lou.” ");
INSERT INTO tnp_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Kəni suah u təməni=pən məmə, “?Lou mɨn pəhruvən?” Kəni Iesu təməni=pən məmə, “Sohamuiən iətəmimi, kəni məsakləhiən e pətan, kəni məsakləhiən, kəni məseiuəiən e kot, ");
INSERT INTO tnp_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","kəni mɨsiai rəham tatə mɨne mamə, kəni molkeikei ik kəti təhmen əmə məmə nəkolkeikei aru ik.” ");
INSERT INTO tnp_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kəni iətəm aluə u təməni=pən məmə, “Natimnati rəfin ko iatol. ?Nati nak mɨn əha ikɨn iətəm iəsoliən?” ");
INSERT INTO tnp_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Kəni Iesu təməni=pən məmə, “Nəmə nəkolkeikei məmə rəham noliən otəhruahru agɨn, uvən mol nətəmimi kotos nəhmtɨ rəham nautə, kəni məfən məni lan kəm nanrah mɨn. Kəni ik onəkos nəuvɨriən tepət əpəha e negəu e neai. Kəni muva, muərisɨg lak, mol məmə rəhak iətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nian iətəm aluə təmətəu nəghatiən əha, kəni təmagɨm matuvən. Nɨkin təpəou mətəu-inu rəhan nautə tepət. ");
INSERT INTO tnp_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kəni Iesu təməni=pən kəm rəhan mɨn nətəmimi məmə, “Iətəni pəhriən məmə, tiəkɨs o iətəmimi iətəm rəhan nautə tepət məmə otuvən matɨg ahgəl Narmənɨgiən Rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kəni iətəni mɨn kəm təmah məmə, tiəkɨs məmə kaməl otuvən=pən e nɨpəg nitɨl, mətəu tiəkɨs pɨk məmə iətəmimi rəhan nautə tepət otuvən matɨg ahgəl Narmənɨgiən Rəha Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nian nətəmimi rəha Iesu kəmotətəu nəghatiən əha, narmɨlah təmiuvɨg pɨk, mətəu nɨkilah təhti məmə ilah u nətəm rəhalah nautə tepət, konu Uhgɨn tolkeikei pɨk agɨn ilah, mətəu in tətasiru e lah. Kəni motəni=pən məmə, “?Kəni pəh təhrun nosiən nəmiəgəhiən itulɨn?” ");
INSERT INTO tnp_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Kəni Iesu təməsal=pən əhruahru meruh ilah kəni məni məmə, “Nati u, ko iətəmimi təsoliən. Mətəu Uhgɨn, in təhrun noliən natimnati rəfin.” ");
INSERT INTO tnp_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kəni Pitə təməni=pən məmə, “Iəmotəpəh natimnati rəfin məmə iəkotohtəu=pɨnə ik. ?Nati nak u, o nian kəti in rəhatəmah?” ");
INSERT INTO tnp_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Kəni Iesu təməni=pən kəm lah məmə, “Iətəni pəhriən kəm təmah məmə, e nian iətəm natimnati rəfin okotəuhlin məhuva motiuvi, kəni Nətɨ Iətəmimi otəharəg e rəhan jeə rəha kig iətəm in təhagəhag məuvɨr agɨn, kəni itəmah ko nətəm nəmotohtəu=pa iəu, onəkotəharəg mɨn e jeə rəha kig ilah tueləf, kəni məutakil məutarmənɨg e nəuanɨləuɨs mɨn ilah tueləf rəha Isrel. ");
INSERT INTO tnp_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kəni nətəmimi rəfin u nətəm kəmotəpəh rəhalah nimə mɨn, uə pialah mɨn, uə nəuvɨnɨlah mɨn, uə rəhalah tatə uə məmə, uə nenətɨlah mɨn, uə rəhalah nɨpətan mɨn o nərgək, Uhgɨn otəfən natimnati mɨn əha tepət pɨk agɨn kəm lah, kəni məfən nəmiəgəhiən itulɨn kəm lah. ");
INSERT INTO tnp_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mətəu nətəmimi tepət nətəm kautəhtul aupən e nəhue nɨftəni rəueiu, okəhuva motəhtul uərisɨg e nəmiəgəhiən iətəm otuva. Kəni nətəmimi tepət kautəhtul uərisɨg e nəhue nɨftəni rəueiu, okəhuva motəhtul aupən e nəmiəgəhiən iətəm otuva.” ");
INSERT INTO tnp_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Tol lanəha mətəu-inu Narmənɨgiən Rəha Uhgɨn təhmen e nəghatiən əuhlin u. Iətəmi asoli kəti rəha nasumiən təmiet ləplapɨn agɨn məmə otəsal e nətəmimi məmə okəhuva motol uək e rəhan nasumiən. ");
INSERT INTO tnp_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kəni in təməni məmə otətəou ilah kətiəh kətiəh uan tənariəs e nian kətiəh, kəni mahli=pən ilah kəhuvən e rəhan nasumiən. ");
INSERT INTO tnp_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Iuəkɨr o nain klok ləplapɨn, təmiet muvən e makɨt meruh nətəmimi nəuvein kəutəhtul məsotoliən nati kəti. ");
INSERT INTO tnp_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kəni təməni=pən kəm lah məmə, ‘Itəmah mɨn, əhuvən motol uək əpəha e rəhak nasumiən, kəni iəkətəou itəmah e məni iətəm təhruahru.’ ");
INSERT INTO tnp_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kəni kəməhuvən. “Kəni iuəkɨr o tinə, təmiet muvən mol nati kətiəh əmə, kəni mol mɨn e tri klok ləhnaiuv. ");
INSERT INTO tnp_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kəni iuəkɨr e faif klok ləhnaiuv, təmiet muvən meruh nətəmimi nəuvein mɨn kautəhtul əpnapɨn əmə. Kəni təməni=pən kəm lah məmə, ‘?Təhro nəutəhtul u ikɨnu nian apiəpiə kəti, məsotoliən nati kəti?’ ");
INSERT INTO tnp_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Kəni kotəni=pən məmə, ‘Mətəu-inu iətəmi kəti təsəsaliən e tɨmah məmə iəkotol uək rəhan.’ Kəni təməni=pən kəm lah məmə, ‘Itəmah mɨn əhuvən motol uək e rəhak nasumiən.’ Kəni ilah kəməhuvən. ");
INSERT INTO tnp_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Nian tɨnəhnaiuv, iətəmi asoli rəha nasumiən təməni=pən kəm rəhan iətəmimi iətəm tətəsal o noluək mɨn məmə, ‘Auɨn e noluək mɨn kəhuva, nəkəfən rəhalah məni. Nəkətuəuin mətəou nətəmimi nətəm kəməhuva uərisɨg muvən mətəuarus nətəmimi kəmotaupən motol uək.’ ");
INSERT INTO tnp_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Kəni noluək mɨn nətəm kəməhuva motol uək e faif klok, kəməhuva kəni təmətəou ilah uan tənariəs kətiəh kətiəh. ");
INSERT INTO tnp_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tol lanəha, nətəmimi mɨn u nətəm kəmotaupən motol uək, nɨkilah təhti məmə okotos məni tapirəkɨs nətəmi mɨn u kəmotol uək uərisɨg. Mətəu ilah kətiəh kətiəh kəmotos mɨn əmə uan tənariəs. ");
INSERT INTO tnp_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nian kəmotos məni, kəni nɨkilah tɨnərah mɨnəutəni nɨkalɨ iətəmi asoli rəha nasumiən, kəni motəni=pən kəm in məmə, ");
INSERT INTO tnp_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Nətəmimi mɨn u nətəm kəmotol uək uərisɨg, kəmotol uək əmə e auə kətiəh əmə, mətəu ik nəmətəou itɨmah təhmen-əhmen əmə. Mətəu itɨmah iəmotol uək asoli e nərauiə əskasɨk e nian apiəpiə.’ ");
INSERT INTO tnp_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Mətəu iətəmi asoli təməni=pən kəm lah məmə, ‘Iəu kəti. Iəsakləhiən kəm ik. ?Nəməni məmə nəkol uək o uan tənariəs, uə kəpə? ");
INSERT INTO tnp_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Os rəham məni matuvən. Iəkolkeikei məmə iəkətəou iətəmimi u iətəm təmol uək uərisɨg təhmen əmə lam. ");
INSERT INTO tnp_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Rəhak u məni. ?Iəkəhrun noliən lanəha nati nak iətəm iəkolkeikei, uə kəpə? ?Nətəməki lak mətəu-inu iatol təuvɨr?’” ");
INSERT INTO tnp_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Kəni nian Iesu təmol naunun e nəghatiən əuhlin, təməni=pən kəm lah məmə, “Tol lanəha, iətəmi tatuərisɨg otaupən, kəni iətəmi tətaupən otuərisɨg.” ");
INSERT INTO tnp_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kəni nian Iesu təmatuvən Jerusɨləm, təmos rəhan nətəmimi tueləf motəhtul pɨsɨn, kəni təməni=pən kəm lah məmə, ");
INSERT INTO tnp_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Kautəhuvən əpəha ilɨs Jerusɨləm, kəni iəu Nətɨ Iətəmimi, okegəhan=pən lak kəm pris asoli mɨn mɨne nəgətun mɨn rəha Lou. Kəni okotiuvi pətɨgəm iəu məmə iəkɨmɨs, ");
INSERT INTO tnp_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","kəni motəfən iəu kəm Nanihluə mɨn məmə okotəuvsan lak, kəni motalis motoh, kəni motətu-pəri iəu e nɨgi kəməluau məmə iəkɨmɨs. Kəni uərisɨg e nian kɨsɨl, kəni Uhgɨn otosmiəgəh mɨn iəu e nɨmɨsiən.” ");
INSERT INTO tnp_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kəni pətan rəha Səpəti, tos nətɨlau mil muva mɨsin=pən nəulɨn o Iesu, mətətapuəh e nati kəti ohni. (Ilau iətəmimi mil rəha Iesu.) ");
INSERT INTO tnp_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kəni Iesu təməni=pən məmə, “?Nəkolkeikei nak?” Kəni pətan təməni=pən məmə, “Pəh nəkegəhan lan məmə nətɨk mil u, ilau pəti kəti otəharəg e nɨkalɨm maru, kəni kəti təharəg e nɨkalɨm məuɨl, ikɨn ima nəsanəniən mɨne nɨsiaiən, nian onəkarmənɨg lan.” ");
INSERT INTO tnp_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Kəni Iesu təməni=pən kəm lau məmə, “Nəkuəruru nati iətəm nətuətapuəh ohniəu. ?Təhro? ?Itəlau, nɨkitəlau təhti məmə nəkuəhrun məmə ko nəkuos nahməiən u oiəkos məmə oiəkətəu tərah?” Kəni kuəni=pən kəm Iesu məmə, “Əuəh, iəkuəhrun.” ");
INSERT INTO tnp_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Kəni Iesu təməni=pən kəm lau məmə, “Pəhriən, onəkuəmnɨm=pən e rəhak kap rəha nətəuiən nahməiən. Mətəu o nəharəgiən e nɨkalɨk maru mɨne məuɨl, səniəmə rəhak məmə iəkəni. Ikɨn mil əha, ilau rəha nətəmimi mɨn u iətəm Uhgɨn təmol əpenə-penə o lah.” ");
INSERT INTO tnp_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nian nətəmimi ten mɨn rəha Iesu kəmotətəu nəghatiən əha, kəni niəməha təmol pɨk ilah o suah mil ilau pian mətəu ilah mɨn kotolkeikei məmə kəhuva motepət. ");
INSERT INTO tnp_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Mətəu Iesu təmauɨn e lah kəhuva kətiəh, kəni məni=pən kəm lah məmə, “Nəkotəhrun rəkɨs noliən rəha nətəmi asoli rəha Nanihluə mɨn. Ilah kautol təskasɨk pɨk kəm rəhalah mɨn nətəmimi. Kəni rəhalah kəpmən mɨn kautol ilah kəutəməhli ləhtəni e narmənɨgiən rəhalah. ");
INSERT INTO tnp_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mətəu itəmah, ko nəsotoliən lanəha. Mətəu nəmə itəmah kəti tolkeikei məmə otuva in iətəmi asoli kəti rəhatəmah, in otəkeikei muva məhmen e ioluək kəti rəhatəmah, ");
INSERT INTO tnp_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","kəni nəmə itəmah kəti tolkeikei məmə otəhtul aupən e təmah, in otəkeikei muva slef rəhatəmah. ");
INSERT INTO tnp_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Noliən əha təhmen əmə lak, Nətɨ Iətəmimi. Iəməsuvaiən məmə nətəmimi okotol uək rəhak, mətəu iəmuva məmə iəkol uək rəhalah, kəni iəkəfən rəhak nəmiəgəhiən məmə iəkɨtɨs ilah e rəhalah noliən tərah mɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nian Iesu mɨne rəhan mɨn nətəmimi kəmohiet e taun Jeriko, nɨmənin nətəmimi kəmohtəu=pən. ");
INSERT INTO tnp_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kəni iəmnəu mil keiu kətuəharəg e nɨkalɨ suaru, kəni nian kəmuətəu məmə Iesu tətaliuək e suaru mətuva, kəni kəmuagət əfəməh muəni məmə, “!Iərmənɨg, Mipɨ Kig Tefɨt, asəkəhruin itɨmlau!” ");
INSERT INTO tnp_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kəni mətəu, nɨmənin nətəmimi kautəniəhu ilau, motəni=pən məmə kəsuagət pɨkiən, mətəu ilau kuagət pɨk agɨn mɨn məmə, “!Iərmənɨg, Mipɨ Tefɨt, asəkəhruin masiru itɨmlau!” ");
INSERT INTO tnp_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kəni Iesu təhtul mauɨn e lau, məni=pən məmə, “?Nəkuolkeikei məmə iəkol nak kəm təlau?” ");
INSERT INTO tnp_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kəni kuəni=pən məmə, “Iərmənɨg, iəkuolkeikei məmə iəkueruh nati.” ");
INSERT INTO tnp_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Kəni Iesu təmasəkəhruin ilau, kəni mek nəhmtɨlau. Kəni rəueiu agɨn, kɨnatueruh nati, kəni matuɨtəu=pən Iesu. ");
INSERT INTO tnp_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nian kɨnəhuva iuəkɨr o Jerusɨləm, mɨnəhuva Petfas e Nɨtəuət Rəha Nɨgi U Olif, kəni Iesu təmahlirəkɨs rəhan mil iətəmimi keiu, ");
INSERT INTO tnp_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","kəni məni=pən kəm lau məmə, “Ian əpəha e lahuənu aupən e tah, kəni ikɨn əha nəkueruh uəhai əmə togki kəti kəmohrain ilau nətɨn. Kəni nəkiatɨs ilau muasɨg miəuva kəm iəu. ");
INSERT INTO tnp_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nəmə iətəmi kəti təni nati kəti kəm təlau, nəkuəni=pən kəm in məmə Iərmənɨg tolkeikei ilau, kəni otəpanahli=pa uəhai əmə ilau.” ");
INSERT INTO tnp_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nati u təmuva məmə otol nəghatiən nak iətəm iəni təməni otuva mol nɨpəhriəniən. Iəni təməni məmə, ");
INSERT INTO tnp_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Otəni=pən kəm nətəmimi əha Jerusɨləm məmə, ‘Oteruh-to, rəhatəmah kig tətuva o təmah, rəhan nətəlɨgiən in ləhtəni, kəni mətasuə e togki, mɨne togki u in nətɨn əmə.’” ");
INSERT INTO tnp_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kəni iətəmimi mil rəha Iesu kəmian muol nati nak iətəm Iesu təməni məmə okuol. ");
INSERT INTO tnp_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Kəmuasɨg togki mɨne nətɨn, kəni muələhu-pəri rəhalau kot mɨn e togki mil, kəni Iesu təməharəg-pəri lan. ");
INSERT INTO tnp_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nɨmənin nətəmimi tepət kautepin rəhalah mɨn kot əpəha e suaru, kəni nəuvein kotətei nɨmalɨ nɨgi mɨn, kəni motepin ilah e suaru e nɨsiaiən. ");
INSERT INTO tnp_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kəni nɨmənin nətəmimi nətəm kəutaupən e Iesu, mɨne nɨmənin nətəmimi nətəm kautəhuərisɨg e Iesu, kəutagət əfəməh mautəni məmə, “!Hosanə o Mipɨ Tefɨt! !Iərmənɨg Uhgɨn tətatɨg ilau iətəmimi u iətəm tətuva e nərgɨn! !Hosanə o Uhgɨn əpəha ilɨs e negəu e neai!” ");
INSERT INTO tnp_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nian Iesu təmiet=pən Jerusɨləm, nətəmimi rəfin əha ikɨn nɨkilah təmauɨt, kəni mautəni nəghatiən tepət məutətapuəh məmə, “?Pəh u?” ");
INSERT INTO tnp_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kəni nɨmənin nətəmimi kotəni məmə, “Inu iəni Iesu, rəha Nasərɨt, əpəha e nɨtəni Kaləli.” ");
INSERT INTO tnp_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kəni Iesu təmuvən əpəha imə e Nimə Rəha Uhgɨn, kəni məhgi pətɨgəm nətəmimi nətəm kautol səlɨm mɨne mautos nəhmtɨn natimnati əha ikɨn məmə okotol sakrifais lan. Kəni mahuvihin tepɨl mɨn iətəm kətəuhlin məni ikɨn, kəni mahuvihin jeə mɨn rəha nətəmimi mɨn u kautol səlɨm e iəuein mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kəni məni=pən kəm lah məmə, “Kəmətei e Nauəuə Rəha Uhgɨn məmə, ‘Rəhak nimə, okauɨn lan məmə nimə rəha nəfakiən kəm Uhgɨn,’ mətəu itəmah nəmotol məmə in ‘nimə rəha iakləh mɨn.’” ");
INSERT INTO tnp_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kəni nətəmimi nətəm nəhmtɨlah tərah mɨne nətəmimi nəhlkɨlah təməpaiu-əpaiu kəməhuva ohni əpəha e Nimə Rəha Uhgɨn, kəni tol vivi ilah. ");
INSERT INTO tnp_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kəni pris asoli mɨn mɨne nəgətun mɨn rəha Lou kəmoteruh nati təuvɨr mɨn iətəm in təmol, kəni moteruh mɨn kəlkələh mɨn kəutagət əfəməh əpəha e Nimə Rəha Uhgɨn, mautəni məmə, “!Hosanə o Mipɨ Tefɨt!” Mətəu nətəmi asoli əha, niəməha təmol ilah. ");
INSERT INTO tnp_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kəni kotəni=pən kəm Iesu məmə, “?Nətətəu nati nak kəlkələh mɨn kəutəni, uə kəpə?” Kəni Iesu təməni=pən kəm lah məmə, “Əuəh. Nəmotafin, uə kəpə, nəghatiən iətəmi kəti təməni kəm Uhgɨn iətəm tətəni lanu lan məmə, ‘E nohlɨ kəlkələh agɨn mɨn mɨne nəpəou mɨn agɨn, nəmol məmə ilah okotəni-vivi ik’.” ");
INSERT INTO tnp_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kəni təməpəh ilah miet Jerusɨləm muvən e taun Petəni, mapɨli ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ləplapɨn agɨn, Iesu təmɨtəlɨg=pən mɨn Jerusɨləm, kəni nəumɨs tɨnus. ");
INSERT INTO tnp_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kəni təmafu nɨgi u fik e nɨkalɨ suaru, kəni təmuvən ohni mətəu təsehiən nəuan kəti, mafu əmə nɨmalɨn. Kəni təni=pən kəm nɨgi u məmə, “!Ko nəsəuə mɨniən!” Kəni rəueiu agɨn, nɨgi təmaukei-aukei. ");
INSERT INTO tnp_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nian rəhan nətəmimi kəmoteruh nati əha, kəni narmɨlah təmiuvɨg, kəni motəni=pən kəm Iesu məmə, “?Təhro nɨgi əha fik təmaukei-aukei uəhai əmə lanəha?” ");
INSERT INTO tnp_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Mətəu Iesu təməni=pən məmə, “Iətəni=pɨnə nɨpəhriəniən məmə nəmə nautos nəhatətəiən, kəni rəhatəmah nətəlɨgiən təsoliən keiu, nəkotəhrun noliən nati nak iətəm iəmol e nɨgi u fik. Mətəu səniəmə in əmə əha, nəkotəhrun nəni-pəniən kəm nɨtəuət əha məmə ‘Uvən miuvɨg mamnɨm əpəha ləuantəhi,’ kəni otol nəuiatəmah. ");
INSERT INTO tnp_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nəmə nəkotəhatətə, kəni onəkotos nati nak iətəm nəutətapuəh lan e nəfakiən.” ");
INSERT INTO tnp_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iesu təmuvən e Nimə Rəha Uhgɨn, kəni nian təmətəgətun, pris asoli mɨn mɨne nətəmi asoli rəha nətəm Isrel, kəhuva ohni motəni=pən məmə, “?Natol natimnati mɨn u e nepətiən rəha pəh? ?Kəni pəh təməfɨnə nepətiən ko?” ");
INSERT INTO tnp_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Kəni Iesu təməni=pən məmə, “Iəkətapuəh=pɨnə mɨn e nəghatiən kəti kəm təmah. Nəmə nəkotəfa nəghatiən kəti, kəni iəkəni=pɨnə kəm təmah məmə nepətiən nak iətəm iatol natimnati mɨn u lan. ");
INSERT INTO tnp_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","?Nepətiən rəha Jon təmsɨpən iə o noliən bəptais? ?Təmsɨpən e negəu e neai, uə rəha nətəmimi əmə?” Kəni kəmotəni=pən kəm lah mɨn məmə, “Nəmə kotəni məmə, ‘Nepətiən rəha Jon təmsɨpən e negəu e neai,’ kəni otəni məmə, ‘?Mətəu təhro nəsotəniən nɨpəhriəniən lan?’ ");
INSERT INTO tnp_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mətəu nəmə kotəni məmə, ‘Rəha nətəmimi əmə,’ kitah kəutəgɨn e nɨmənin nətəmimi ikɨnu rəueiu mətəu-inu nɨkilah təhti məmə Jon in iəni kəti rəha Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tol lanəha, kəmotəni=pən kəm Iesu məmə, “Itɨmah iəkotəruru.” Kəni Iesu təməni=pən kəm lah məmə, “Kəni iəu mɨn, ko iəsəniən kəm təmah məmə e nepətiən nak iatol natimnati mɨn u lan.” ");
INSERT INTO tnp_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kəni Iesu təməni=pən məmə, “?Təhro? ?Nɨkitəmah tətəhti məmə nak? Suah kəti, nətɨn iərman keiu. Kəni təmuvən məni=pən kəm iətəm iahgin lan məmə, ‘Nətɨk, uvən mol uək rəueiu əpəha e nasumiən.’ ");
INSERT INTO tnp_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mətəu nətɨn təməni=pən məmə, ‘Iəkəpəh.’ Kəni matɨg məuhlin mɨn rəhan nətəlɨgiən, kəni muvən e nasumiən. ");
INSERT INTO tnp_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Kəni tatə təmuvən o nətɨn iətəm təkəku, məni=pən mɨn kəm in nati kətiəh əmə. Kəni nətɨn təməni=pən məmə, ‘Əuəh, tatə, iəkuvən,’ mətəu təməpəh=pən e nasumiən. ");
INSERT INTO tnp_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“?Otəni-to məmə suakəku mil u in pəhruvən, təmol nəuia rəhan tatə?” Kəni kəmotəni=pən məmə, “Suakəku iətəm iahgin lan.” Kəni Iesu təməni=pən kəm lah məmə, “Əuəh, in əhruahru. Kəni iətəni=pɨnə nɨpəhriəniən məmə, nətəmi kautos məni rəha takɨs, mɨne nɨpətan rəha suaru kautəhuvən e Narmənɨgiən Rəha Uhgɨn aupən e təmah, ");
INSERT INTO tnp_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","mətəu-inu Jon təmuva o təmah məmə otəgətun suaru rəha noliən əhruahru, kəni mətəu itəmah nəsotəniən nɨpəhriəniən lan. Nətɨ suah u iətəm təkəku tətəgətun=pən itəmah. Mətəu nətəm kautos məni rəha takɨs, mɨne nɨpətan rəha suaru kəmotəni nɨpəhriəniən lan. Nətɨ suah iətəm tepət lan tətəgətun=pən ilah. Kəni nəmoteruh pau nati əha, mətəu nəməsotəuhliniən itəmah e rəhatəmah noliən tərah mɨn, kəni məsotəniən nɨpəhriəniən lan.” ");
INSERT INTO tnp_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Kəni Iesu tətəkeikei mətəni məmə, “Otətəlɨg-to e nəghatiən əuhlin kəti mɨn. Iətəmi asoli kəti rəha nasumiən, təmol nasumiən kəti e nɨləuɨs kəti kətəni məmə krep, u katol wain lan. Kəni mol kəlkəl e kəpiel muvən mɨtəlau lan. Kəni mol ikɨn kəti o noliən nɨmei nevɨg-evɨgiən e nəua krep məmə nəhu krep otaiu kəni mol wain lan. Kəni mol nimə kəti iətəm in ilɨs məmə iətəmi otəri lan mətəsal vivi o nasumiən o nati miəgəh mɨn mɨne nətəmimi. “Kəni təmegəhan=pən e nasumiən kəm nətəmimi məmə okotasum lan, kəni məuəri nəua krep, nəuvein rəhan, nəuvein rəhalah. Kəni miet muvən e naliuəkiən ikɨn pɨsɨn pɨsɨn kəti. ");
INSERT INTO tnp_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Nian krep tɨnɨmarəg, kəni tahli=pən rəhan ioluək mɨn məmə okəhuvən e nasumiən rəha krep, motətapuəh o nətəmimi nətəm kautol uək e nasumiən məmə okotəfən rəhan krep nəuvetɨn kəm lah. ");
INSERT INTO tnp_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Mətəu nətəm kautol uək e nasumiən kəmotaskəlɨm rəhan ioluək mɨn, kəni motoh kəti, motohamu kəti, motəhti e kəpiel iətəm tatol kɨsɨl lan. ");
INSERT INTO tnp_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kəni tahli=pən mɨn ioluək mɨn nəuvein kəhuvən o lah, ilah tepət tapirəkɨs in mɨn aupən. Kəni nətəmimi nətəm kautol uək e nasumiən kotol tərah e lah e noliən əhmen mɨn əmə məmə kəmotol e in mɨn aupən. ");
INSERT INTO tnp_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Naunun agɨn, tahli=pən nətɨn iərman tuvən o lah, kəni məni məmə, ‘Ilah okotəkeikei motɨsiai nətɨk.’ ");
INSERT INTO tnp_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Mətəu nian nətəmimi mɨn kautol uək e nasumiən kəmotafu nətɨn, kəni kotəni=pən kəm lah mɨn məmə, ‘Inu nətɨ iətəmi asoli iətəm otarmənɨg e nasumiən nian rəhan tatə otɨmɨs. Pəh kəhuvən motohamu mɨn, kəni motos nasumiən məmə rəhatəmah motarmənɨg lan.’ ");
INSERT INTO tnp_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kəni kəmotaskəlɨm motatu pətɨgəm lan e nasumiən, kəni motohamu.” ");
INSERT INTO tnp_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Kəni nian Iesu təmol naunun e nəghatiən əuhlin, kəni məni məmə, “?Tol lanu lan, nian iətəmi asoli rəha nasumiən otuva, kəni otol nak e nətəmimi nətəm təmegəhan=pən e nasumiən kəm lah?” ");
INSERT INTO tnp_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Kəni kəmotəni=pən məmə, “Otərəkɨn agɨn nətəm kotərah mɨn əha, mohamu ilah. Kəni uərisɨg, təpanegəhan e rəhan nasumiən əha tuvən e nəhlmɨ nətəmimi pɨsɨn nəuvein, kəni e nian əhruahru iətəm krep tatɨmarəg, ilah okotəfən nəuvetɨn rəhan.” ");
INSERT INTO tnp_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kəni Iesu təməni=pən kəm lah məmə, “?Nəmotafin e Nauəuə Rəha Uhgɨn u, uə kəpə? Tətəni məmə, ‘Pos u iətəm nətəmimi rəha nuvləkɨniən nimə kəsotolkeikeiən motəpəh, in tɨnuva pos iətəm tol nəhgɨn o noliən nimə. Iərmənɨg təmol nati u, kəni in nati təuvɨr agɨn e nəhmtɨtah.’ ");
INSERT INTO tnp_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Tol lan əha, iətəni kəm təmah məmə Narmənɨgiən Rəha Uhgɨn okos rəkɨs o təmah, kəni kəfən kəm nətəmimi mɨn u nətəm okotol nəuialah. ");
INSERT INTO tnp_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nəmə iətəmi kəti otaiu mələs pɨkɨn pos u, nɨkɨlkɨlin tɨtəgɨt əgɨt. Uə nəmə pos u otəmei məməhli-ərain in, otauvtəuvtə mərah agɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nian pris asoli mɨn mɨne Farəsi mɨn kəmotətəu nəghatiən əuhlin iətəm Iesu təməni, kəni kəmotəhrun məmə tətəghati e lah. ");
INSERT INTO tnp_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kəni kɨnəutəsal e suaru kəti məmə okotaskəlɨm Iesu motləfən e kaləpus, mətəu kautəgɨn e nɨmənin nətəmimi, mətəu-inu nətəmimi kəutəni məmə in iəni kəti. ");
INSERT INTO tnp_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Kəni Iesu təməni mɨn nəghatiən əuhlin kəti mɨn məmə, ");
INSERT INTO tnp_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Nəghatiən əuhlin u tətəgətun=pən Narmənɨgiən Rəha Uhgɨn. Kig kəti iətəm təmol əpenə-penə e nauəniən asoli o marɨt rəha nətɨn. ");
INSERT INTO tnp_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kəni mahli=pən rəhan noluək mɨn məmə okəhuvən o nətəmimi mɨn u nətəm təmahli=pən rəkɨs nəghatiən o lah məmə okəhuva o nauəniən rəha marɨt. Mətəu kotəni məmə ko kəsəhuvaiən. ");
INSERT INTO tnp_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Kəni tahli=pən rəhan noluək nəuvein mɨn, məni=pən kəm lah məmə, ‘Əhuvən motəni=pən kəm nətəmimi mɨn u nətəm iəmahli=pən rəkɨs nəghatiən o lah məmə, inol əpenə-penə rəkɨs e rəhak nauəniən. Rəhak kau mɨn mɨne nətɨ kau mɨn u kotasisi vivi, iəmoh rəkɨs ilah, kəni natimnati rəfin tɨnəhmen. Əhuva e nauəniən rəha marɨt.’ ");
INSERT INTO tnp_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Mətəu kəsotətəlɨgiən e noluək mɨn, kəni motaiu atiti, kəti tatuvən e rəhan nasumiən, kəti tatuvən e rəhan bɨsnɨs. ");
INSERT INTO tnp_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Kəni nəuvein kotaskəlɨm noluək mɨn rəhan, motol tərah e lah, kəni motohamu ilah. ");
INSERT INTO tnp_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kəni kig, niəməha təmol pɨk. Kəni tahli=pən rəhan soldiə mɨn kəhuvən, kəni motohamu nətəmimi mɨn u nətəm kəmotohamu rəhan noluək mɨn, kəni motasiəpən e rəhalah taun asoli. ");
INSERT INTO tnp_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Kəni məni=pən kəm rəhan noluək mɨn məmə, ‘Kɨnol əpenə-penə rəkɨs e nauəniən rəha marɨt, mətəu nətəmimi mɨn u iəmahli=pən rəkɨs nəghatiən o lah, noliən rəhalah təsəhmeniən məmə okəhuva. ");
INSERT INTO tnp_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tol lanəha, əhuvən əpəha e suaru asoli mɨn kəni motəni=pən kəm nətəmimi əpnapɨn rəfin nətəm nəkoteruh məmə okəhuva e nauəniən rəha marɨt.’ ");
INSERT INTO tnp_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kəni noluək mɨn kəməhuvən əpəha e suaru asoli mɨn, kəmotuhapumɨn nətəmimi rəfin u kəmoteruh ilah, nətəmimi nətəm kotəuvɨr mɨne nətəmimi mɨn u nətəm kotərah, kəni ikɨn kətauən ikɨn təməriauəh e nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Mətəu nian kig təmuva meruh nətəmimi, təmeruh mɨn iətəmimi kəti əha ikɨn iətəm təsuvəniən e napən rəha marɨt. ");
INSERT INTO tnp_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kəni kig təməni=pən məmə, ‘?Iəu kəti, nəməhro? ?Nəmuva imə mətəu nəməsuvəniən e napən rəha marɨt?’ Kəni suah u tɨnəruru nuhalpɨniən nəghatiən rəhan. ");
INSERT INTO tnp_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Kəni kig təməni=pən kəm rəhan mɨn nətəmimi məmə, ‘Otəlis-ərain nəhlmɨn mɨne nəhlkɨn, kəni motəraki pətɨgəm əpəha e napinəpuiən ikɨn kətasək ikɨn, kəni katɨgət-ərain nəhluvtəmi ikɨn.’” ");
INSERT INTO tnp_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kəni Iesu təmətəkeikei mətəni məmə, “Tol lanəha mətəu-inu nətəmimi tepət, kətahli=pən nəghatiən o lah, mətəu nəuan nəuvein əmə nətəm katɨtəpɨn ilah.” ");
INSERT INTO tnp_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kəni Farəsi mɨn kəmohiet məhuvən motol nəghatiən ekəu-ekəu mɨn məmə otiuvi=pən Iesu o nəniən nəghatiən kəti iətəm təsəhruahruiən. ");
INSERT INTO tnp_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kəni kotahli=pən rəhalah nətəmimi kəhuvən o Iesu ilah nətəmimi rəha pati rəha Herot. Kəni motəni=pən məmə, “Iəgətun. Iəkotəhrun məmə ik iətəmi əhruahru, kəni mətəgətun pəhriən suaru əhruahru rəha Uhgɨn. Nəsoliən məmə nətəlɨgiən rəha nətəmimi okotiuvi rəkɨs rəham nətəlɨgiən, mətəu-inu natol təhmen-əhmen əmə kəm nətəmimi rəfin, nəmə in iətəmi asoli uə iətəmi əpnapɨn əmə. ");
INSERT INTO tnp_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kəni əni-to kəm tɨmah rəham nətəlɨgiən e nati u. ?Təhruahru məmə okətəou=pən takɨs kəm Kig Sisə, uə kəpə?” ");
INSERT INTO tnp_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Mətəu Iesu tɨnəhrun rəhalah nətəlɨgiən tərah mɨn, kəni təməni=pən kəm lah məmə, “!Itəmah kəuɨt kəsuə mɨn! ?Təhro nəutalkut məmə nəkotol kekəu-ekəu ohni iəu? ");
INSERT INTO tnp_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Otəgətun-to məni iətəm katətəou takɨs lan.” Kəni kotos məni məhuva kəm in, ");
INSERT INTO tnp_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","kəni təməni=pən kəm lah məmə, “?Narmɨ pəh u, kəni nərgɨ pəh u e məni u?” ");
INSERT INTO tnp_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Kəni kəmotəni=pən məmə, “Kig Sisə.” Kəni Iesu təməni=pən kəm lah məmə, “Narmɨn tətəgətun məmə inu in nati kəti rəhan pəhriən. Kəni tol lanko, nak u rəha Kig Sisə, otəfən kəm Kig Sisə. Kəni nak u rəha Uhgɨn, otəfən kəm Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nian kəmotətəu nəghatiən əha, narmɨlah təmiuvɨg. Kəni kəmotəpəh Iesu motagɨm. ");
INSERT INTO tnp_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","E nian əha inəha, Satusi mɨn kəməhuva o Iesu. Ilah kəutəni məmə nətəmimi okəsotəmiəgəh mɨniən e nɨmɨsiən. Kəni kotəni=pən kəm Iesu məmə, ");
INSERT INTO tnp_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Iəgətun. Mosɨs təməni kəm tah məmə, nəmə iərman kəti otɨmɨs, kəni məpəh rəhan pətan, kəni məsuələsiən nətɨlau kəti mɨne, kəni pian otəkeikei mit pətalɨmɨs əha, məmə okuələs nətɨlau kəti ko, kəni suakəku u otos nɨmei rəhan tatə asoli əpəha tɨnɨmɨs rəkɨs. ");
INSERT INTO tnp_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","“Kəni ikɨn əha imatɨmah ikɨn, nəman ilah səpɨn, u rəhalah tatə kətiəh. Kəni iətəm tepət e lah təmaupən mit pətan kəti, kəni məsuələsiən nətɨlau kəti, kəni mɨmɨs. Kəni pian iətəm tatol keiu lan tit pətalɨmɨs. ");
INSERT INTO tnp_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kəni in mɨn təmɨmɨs məsələsiən nətɨn kəti, kəni iətəm tatol kɨsɨl lan mɨne ilah rəfin məhuvən mətəuarus=pən iətəm tatol səpɨn, kəmotol nati kətiəh əmə. ");
INSERT INTO tnp_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kəni əmeiko, pətalɨmɨs tɨmɨs. ");
INSERT INTO tnp_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","?Tol lanəha, əni-to kəm tɨmah məmə, e nian iətəm Uhgɨn otosmiəgəh nətəmimi lan e nɨmɨsiən, pətan əha in rəha pəh, mətəu-inu ilah rəfin əha səpɨn kəmotol marɨt e pətan əha?” ");
INSERT INTO tnp_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Kəni Iesu təməni=pən kəm lah məmə, “Itəmah nəmotəni arəpən rəhatəmah nəghatiən mətəu-inu nəsotəhruniən Nauəuə Rəha Uhgɨn mɨne nəsanəniən rəhan. ");
INSERT INTO tnp_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nian Uhgɨn otosmiəgəh nətəmimi e nɨmɨsiən, kəni nətəmimi okəsotoliən marɨt, okotəhmen e nagelo mɨn əpəha e negəu e neai. ");
INSERT INTO tnp_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","?Nəmotafin uə kəpə, Nauəuə Rəha Uhgɨn iətəm tətəghati e nian Uhgɨn otosmiəgəh nətəmimi e nɨmɨsiən? Tətəni məmə, ");
INSERT INTO tnp_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Iəu Uhgɨn rəha Epraham, iəu Uhgɨn rəha Aisək, kəni iəu Uhgɨn rəha Jekəp.’ In səniəmə Uhgɨn rəha nətəm kəmohmɨs, mətəu in Uhgɨn rəha nətəmimi nətəm kəutəmiəgəh, təhmen=pən mɨn e suah milahal, u nati əpnapɨn nɨpətɨlahal təmɨmɨs nuvəh rəkɨs, mətəu narmɨlahal tətatɨg əhanəh u rəueiu.” ");
INSERT INTO tnp_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nian nɨmənin nətəmimi kəmotətəu nəghatiən əha, narmɨlah təmiuvɨg o nəgətuniən rəhan. ");
INSERT INTO tnp_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nian Farəsi mɨn kəmotətəu məmə Iesu təmasisɨg e nohlɨ Satusi mɨn e rəhan nəghatiən, kəni Farəsi mɨn kəməhuva kətiəh. ");
INSERT INTO tnp_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Kəni kəti iətəm təhrun pɨk Lou, təməni=pən nəghatiən kəti kəm Iesu məmə Iesu otəni nəghatiən kəti təsəhruahruiən, məmə ");
INSERT INTO tnp_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Iəgətun. ?Lou pəhruvən rəha Uhgɨn u in ilɨs pɨk?” ");
INSERT INTO tnp_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Kəni Iesu təməni=pən məmə, “Nəkəkeikei molkeikei Iərmənɨg Uhgɨn rəham e nɨkim rəfin rəham, mɨne nətəlɨgiən rəfin rəham, mɨne nəmiəgəhiən rəfin rəham. ");
INSERT INTO tnp_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Inu in Lou iətəm tətaupən kəni in ilɨs pɨk. ");
INSERT INTO tnp_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kəni Lou iətəm tatol keiu lan, in iuəkɨr təhmen əmə, məmə, ‘Nəkəkeikei molkeikei ik kəti təhmen əmə məmə nəkolkeikei aru ik.’ ");
INSERT INTO tnp_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kəni Lou mil u keiu, ilau nəukətɨ Lou rəfin, mɨne nauəuə rəha iəni mɨn rəfin aupən.” ");
INSERT INTO tnp_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Kəni e nian Farəsi mɨn kəutuhapumɨn ilah mɨn, Iesu təməni=pən məmə, ");
INSERT INTO tnp_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“?Nɨkitəmah təhti məmə nak, e Krɨsto iətəm Uhgɨn təməni məmə otahli=pa? ?In tatsɨpən e nəuanɨləuɨs rəha pəh?” Kəni ilah kotəni=pən məmə, “In mipɨ Kig Tefɨt.” ");
INSERT INTO tnp_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Kəni Iesu təməni=pən məmə, “Mətəu təhro e Tefɨt, iətəm tətəghati e Narmɨn Rəha Uhgɨn, tətauɨn e Krɨsto məmə ‘Iərmənɨg.’ Mətəu-inu tətəni məmə, ");
INSERT INTO tnp_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Iərmənɨg Uhgɨn təməni=pən kəm rəhak Iərmənɨg məmə, “Əharəg u e rəhak maru, ikɨn ima nəsanəniən mɨne nɨsiaiən, mətəuarus=pən iəu iəkələs iahu rəham tɨkɨmɨr mɨn məlɨn=pən ilah əpəha ləhtəni e nəhlkəm, məmə nətarmənɨg e lah.” ’ ");
INSERT INTO tnp_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","?Kəni nəmə Tefɨt tətauɨn e Krɨsto məmə ‘rəhak Iərmənɨg,’ kəni otəhro məmə Krɨsto in mipɨ Tefɨt tərah?” ");
INSERT INTO tnp_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kəni iətəmimi kəti təruru nuhalpɨniən nəghatiən rəha Iesu. Kəni e nian əha matuvən, kəmotəgɨn e nətapuəhiən e nəghatiən kəti mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kəni Iesu təməni=pən kəm nɨmənin nətəmimi, mɨne rəhan mɨn nətəmimi məmə, ");
INSERT INTO tnp_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Nəgətun mɨn rəha Lou mɨne Farəsi mɨn kautos nepətiən məmə okotəni pətɨgəm Lou rəha Mosɨs kəm təmah. ");
INSERT INTO tnp_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tol lanəha, nəkotəkeikei motohtəu=pən kəni motol natimnati mɨn rəfin iətəm kəutəni kəm təmah. Mətəu nəsotoliən kəmə ilah u kəutəni əmə nati, mətəu ilah kəsotoliən nati iətəm kəutəni pətɨgəm. ");
INSERT INTO tnp_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kautəkeikei o nətəmimi məmə okotohtəu=pən lou əskasɨk mɨn iətəm kotəhmen e katipə fɨgəm, mətəu ko ilah kəsotəfəniən nəuanəhlmɨlah məmə okotasiru e lah. ");
INSERT INTO tnp_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Natimnati rəfin iətəm ilah kautol, kautol əmə məmə nətəmimi okoteruh. Nəkotəhrun pauɨs kəti kətəni məmə failaktri iətəm nətəmimi kəmotaipei=pən nəghatiən rəha Nauəuə Rəha Uhgɨn ikɨn, konu motəlis rəhn-kapə lah mɨne nəhlmɨlah lan. Mətəu rəha nəgətun mɨn rəha Lou mɨne Farəsi mɨn, rəhalah pauɨs in iahgin tapirəkɨs. Kəni nəkotəhrun nɨləuɨs əlkələh mɨn iətəm kəutəhkul=pən e nɨpəgnəmtɨ kot mɨn, iətəm tətəgətun məmə iətəmimi in tətəhtul əskasɨk o nɨtəu-pəniən Lou. Mətəu rəha nəgətun mɨn rəha Lou mɨne Farəsi mɨn, rəhalah nɨləuɨs təfəməh pɨk. ");
INSERT INTO tnp_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kəni e lafet mɨn, ilah kotolkeikei ima nɨsiaiən, kəni e nimə rəha nuhapumɨniən, ilah kotolkeikei məmə okotəharəg e jeə aupən. ");
INSERT INTO tnp_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kəni e ikɨn katol makɨt ikɨn, ilah kotolkeikei məmə nətəmimi kotəni təuvɨr kəm lah, kəni məutauɨn e lah məmə ‘Rapai’ u nɨpətɨn təni məmə ‘iəgətun katɨsiai.’ ");
INSERT INTO tnp_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Mətəu sotoliən məmə nətəmimi okotauɨn e təmah məmə ‘Rapai,’ mətəu-inu rəhatəmah Iəgətun katɨsiai kətiəh əmə, kəni itəmah piatəmah mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kəni sotauɨniən e iətəmi kəti u e nəhue nɨftəni məmə, ‘Tatə, iətəm katɨsiai,’ mətəu-inu Tatə rəhatəmah kətiəh əmə əpəha ilɨs e negəu e neai. ");
INSERT INTO tnp_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kəni sotoliən məmə nətəmimi okotauɨn e təmah məmə, ‘Iəgətun,’ mətəu-inu rəhatəmah Iəgətun kətiəh əmə, Krɨsto iətəm Uhgɨn təməni məmə otahli=pa. ");
INSERT INTO tnp_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Iətəmimi u in tepət e təmah, in təkeikei muva ioluək rəhatəmah. ");
INSERT INTO tnp_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tol lanəha mətəu-inu, iətəmimi iətəm otəfəri aru in, Uhgɨn otosiahu, kəni iətəmimi iətəm otosiahu aru in, Uhgɨn otəfəri. ");
INSERT INTO tnp_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“!Kəsi, itəmah mɨn u nəgətun mɨn rəha Lou mɨne Farəsi mɨn, nərahiən asoli otuva o təmah! !Itəmah nəfaki eiuə mɨn! Nəutasisɨg e suaru o nətəmimi o nuvəniən matɨg ahgəl Narmənɨgiən Rəha Uhgɨn. Mətəu itəmah nəsəhuvəniən, kəni nəsotegəhaniən məmə nətəmimi kəhuvən ikɨn, nati əpnapɨn ilah kotolkeikei məmə okəhuvən. ");
INSERT INTO tnp_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“!Kəsi, itəmah mɨn u nəgətun mɨn rəha Lou mɨne Farəsi mɨn, nərahiən asoli otuva o təmah! !Itəmah nəfaki eiuə mɨn! Nɨkitəmah tagiən əmə məmə nəkəhuvən isəu e negəu, uə e naliuəkiən əmə o nuvəniən e nɨftəni pɨsɨn pɨsɨn mɨn məmə nəkotiuvi=pa iətəmimi kətiəh əmə e nəfakiən rəhatəmah. Mətəu nian iətəmimi kəti tatos noliən mɨn əha rəhatəmah, kəni tətuva iətəmi tərah tapirəkɨs itəmah, kəni nəmotol məmə in otəkeikei mos nalpɨniən e nɨgəm asoli tapirəkɨs itəmah. ");
INSERT INTO tnp_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“!Kəsi, nərahiən asoli otuva o təmah nətəm nautit nətəmimi mətəu nəhmtɨtəmah təpɨs! Itəmah nəutəni məmə, ‘Nəmə iətəmi kəti tatos nonauvɨl e Nimə Rəha Uhgɨn məmə otol rəhan nəghatiən tətəhtul əskasɨk, nəmə təsoliən, mətəu in nati əpnapɨn əmə. Mətəu nəmə iətəmi kəti tatos nonauvɨl e aiən u kol tətoraip-oraip rəha Nimə Rəha Uhgɨn, kəni in otəkeikei mol nəuian iətəm təmos nonauvɨl ohni.’ ");
INSERT INTO tnp_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","!Itəmah nətəm nəkotalməli, nəhmtɨtəmah təpɨs! ?Naku u in ilɨs, aiən u kol tətoraip-oraip, uə Nimə Rəha Uhgɨn iətəm tatol aiən u tətasim? ");
INSERT INTO tnp_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kəni nəkotəni mɨn məmə, ‘Nəmə iətəmi kəti tatos nonauvɨl e oltə, in nati əpnapɨn əmə. Mətəu nəmə iətəmi kəti tatos nonauvɨl e sakrifais iətəm tətəharəg lan, kəni in otəkeikei mol nəuian iətəm təmos nonauvɨl ohni.’ ");
INSERT INTO tnp_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","!Itəmah nətəm nəkotalməli, nəhmtɨtəmah təpɨs! ?Nak u in ilɨs, sakrifais uə oltə iətəm tatol sakrifais tətasim? ");
INSERT INTO tnp_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tol lanəha, iətəm tatos nonauvɨl e oltə, pəhriən, tatos nonauvɨl e oltə mɨne natimnati rəfin iətəm tətəharəg lan. ");
INSERT INTO tnp_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kəni iətəm tatos nonauvɨl e Nimə Rəha Uhgɨn, pəhriən tatos nonauvɨl e Nimə Rəha Uhgɨn mɨne Suah u tətatɨg ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kəni iətəmi tatos nonauvɨl e negəu e neai, pəhriən tatos nonauvɨl e jeə rəha kig u in rəha Uhgɨn, kəni tatos nonauvɨl e Suah u tətəharəg-pəri lan. ");
INSERT INTO tnp_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“!Kəsi, itəmah mɨn u nəgətun mɨn rəha Lou mɨne Farəsi mɨn, nərahiən asoli otuva o təmah! !Itəmah nəfaki eiuə mɨn! Nautəfən tait rəhatəmah e natimnati rəfin muvən mətəuarus=pən e nɨmalɨ nɨgi əlkələh mɨn agɨn nəmiəvɨlah tətəpien u kətəfən e nauəniən, kətəni məmə mɨnɨt, mɨne til, mɨne kumɨn. Mətəu nəutəpəh nati asoli e Lou, inu iətəmimi tatol təhruahru kəni məhmen-əhmen əmə kəm nətəmimi, kəni mətasəkəhruin nətəmimi, kəni tatol nian rəfin nati iətəm təkeikei matol. Təuvɨr nautol lou əlkələh mɨn, mətəu nəkotəkeikei mautol lou asoli mɨn, mətəu kəpə, nəsotoliən. ");
INSERT INTO tnp_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","!Itəmah nautit nətəmimi mətəu nəhmtɨtəmah təpɨs! !Itəmah nətəmimi nəutəsal e mənman e rəhatəmah kap məmə o nəsotərgeiən, mətəu nautərgei nati miəgəh asoli u kau! ");
INSERT INTO tnp_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“!Kəsi, itəmah mɨn u nəgətun mɨn rəha Lou mɨne Farəsi mɨn, nərahiən asoli otuva o təmah! !Itəmah nəfaki eiuə mɨn! Nautol noliən mɨn nəuvein məmə nətəmimi nɨkilah otəhti məmə itəmah nəkotəhruahru kəni rəhatəmah noliən mɨn kotəuvɨr. Mətəu əpəha imə e nɨkitəmah, itəmah nəumɨs mɨn, kəni nian rəfin nautol əmə natimnati tərah mɨn iətəm tətatɨg e rəhatəmah nətəlɨgiən. Itəmah nəkotəhmen e kap mɨne pɨlet mɨn. Nəutafəl vivi ihluə e kap mɨne pɨlet, mətəu əpəha imə tamɨkmɨk məriauəh e nəpieniən rəha nəmnəmɨtiən. ");
INSERT INTO tnp_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","!Itəmah Farəsi mɨn, nəhmtɨtəmah təpɨs! Otaupən motafəl əpəha imə e kap mɨne pɨlet, kəni ihluə mɨn e kap mɨne pɨlet, in təuvɨr təsamɨkmɨkiən, u nɨpətɨn tol lanu lan. Otaupən motol nɨkitəmah təhruahru, kəni uərisɨg, rəhatəmah noliən mɨn otəhruahru mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“!Kəsi, itəmah mɨn u nəgətun mɨn rəha Lou mɨne Farəsi mɨn, nərahiən asoli otuva o təmah! !Itəmah nəfaki eiuə mɨn! Nəkotəhmen e suvət rəha nətəm kəmohmɨs iətəm kəmuh e pen ruən. Ihluə nətəmimi koteruh məmə təuvɨr, mətəu əpəha imə təriauəh e nɨkɨlkɨli nətəm kəmohmɨs, mɨne natimnati rəfin iətəm tamɨkmɨk. ");
INSERT INTO tnp_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","E noliən əhmen mɨn əmə, ihluə, e noliən rəhatəmah, nətəmimi, nɨkilah tətəhti məmə itəmah nəkotəhruahru. Mətəu imə, e nɨkitəmah, nəkotəriauəh e nəghatiən nəkotəni məsotoliən, mɨne noliən tərah agɨn mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“!Kəsi, itəmah mɨn u nəgətun mɨn rəha Lou mɨne Farəsi mɨn, nərahiən asoli otuva o təmah! !Itəmah nəfaki eiuə mɨn! Nəutuvləkɨn nimə e kəpiel rəha suvət rəha iəni aupən mɨne nətəm kotəhruahru, kəni mautol nahlu e kəpiel, kəni mautol malə-malə lan. ");
INSERT INTO tnp_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kəni nəkotəni=pən məmə, ‘Nəmə itɨmah iəmotatɨg e nian mɨn rəha tɨpɨtah mɨn, ko itɨmah iəməsotasiruiən e lah motohamu iəni mɨn.’ ");
INSERT INTO tnp_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","E nəghatiən əha, nautəni pətɨgəm məmə itəmah nəuanɨləuɨs əhruahru rəha tɨpɨtəmah mɨn aupən nətəm kəmotohamu iəni mɨn əha, kəni nəkotəhmen əhmen əmə e lah. ");
INSERT INTO tnp_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kəni təuvɨr əmə, itəmah nəkotəkeikei motol naunun e uək iətəm tɨpɨtəmah mɨn kəmotətuəuin. ");
INSERT INTO tnp_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“!Itəmah sɨneik mɨn, mɨne nətɨ sɨneik mɨn! ?Nɨkitəmah təhti məmə ko nəkotagɨm e nalpɨniən e nɨgəm asoli? !Kəpə! ");
INSERT INTO tnp_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Tol lanəha, iəkahli=pɨnə iəni mɨn, mɨne nətəm koteinatɨg, mɨne nəgətun mɨn. Nəuvein, itəmah onəkotohamu ilah motətu-pəri ilah e nɨgi kəməluau, nəuvein onəkotalis motoh ilah əpəha e nimə rəha nuhapumɨniən rəhatəmah, kəni nəuvein nəkotəgəu rəkɨs ilah kohiet e taun kəti mohiet məhuvən e kəti. ");
INSERT INTO tnp_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kəni tol lanəha, itəmah onəkotos nalpɨniən rəha nətəmimi nətəm kəmotohamu nətəmimi rəfin nətəm kotəhruahru, iətəm tətuəuin e Epɨl iətəm təhruahru, muvən mətəuarus=pən Səkaraea, nətɨ Perekaea, iətəm tɨpɨtəmah mɨn kəmotohamu e Nimə Rəha Uhgɨn nəlugɨn e oltə mɨne nimə. ");
INSERT INTO tnp_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Iətəni pəhriən kəm təmah məmə, nalpɨniən rəfin u otuva o nətəm Isrel nətəm kəutatɨg u rəueiu. ");
INSERT INTO tnp_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“!Əui, kəsi, nətəm Jerusɨləm! Itəmah nəutohamu iəni mɨn rəha Uhgɨn, kəni nətəmimi nətəm Uhgɨn təmahli=pa kəm təmah, nəutahtɨmu ilah e kəpiel apɨn, inəha nətəmimi u rəha Uhgɨn nətəm kautos nəghatiən rəhan. Nian tepət iətigaru əfəməh e nəhlmək məmə iəkos vivi itəmah, təhmen=pən e mənɨg iətəm tatuu nenətɨn mɨn e nɨkəuvkəuvɨn, mətəu nɨkitəmah təsagiəniən, kəni məutəpəh iəu. ");
INSERT INTO tnp_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Otafu-to. Uhgɨn tɨnəpəh itəmah, rəhatəmah nimə nərahiən otələs, kəni nati tɨkə ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kəni iəkəni kəm təmah məmə, nati əha in nɨpəhriəniən mətəu-inu onəsoteruh mɨniən iəu mətəuarus nəkotəni məmə, ‘!Iərmənɨg Uhgɨn tətatɨg ilau suah u iətəm tətuva e nərgɨn.’” ");
INSERT INTO tnp_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesu təmiet e Nimə Rəha Uhgɨn maliuək matuvən, kəni rəhan mɨn nətəmimi kəhuva motəni=pən kəm in məmə oteruh-to nimə mɨn u kəmol e kəpiel mɨn əpəha e Nimə Rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Kəni Iesu təməni=pən məmə, “Əuəh, oteruh-to nimə mɨn əha. Nɨpəhriəniən iətəni kəm təmah məmə nimə mɨn əha nətəmimi okotoharəg-rəg kəpiel mɨn e lah. Ko kəpiel kəti təsəməhliən e nɨmein.” ");
INSERT INTO tnp_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kəni uərisɨg lan, Iesu təmaliuək ilah rəhan mɨn nətəmimi məhuvən əpəha e Nɨtəuət Rəha Nɨgi U Olif kəni mətəharəg. Kəni rəhan mɨn nətəmimi kotagɨm rəkɨs e nətəmimi məhuva pɨsɨn əmə ohni motəni=pən məmə, “?Əni-to məmə natimnati mɨn u okəhuva e nian nak, kəni nəmtətiən nak otol əpu məmə rəham nuvaiən mɨne naunun nian tɨnuva iuəkɨr?” ");
INSERT INTO tnp_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Kəni Iesu təməni=pən kəm lah məmə, “Oteh vivi itəmah məmə iətəmimi kəti otəseiuəiən e təmah, ");
INSERT INTO tnp_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","mətəu-inu nətəmimi tepət okəhuva motos nərgək motəni məmə, ‘Iəu Krɨsto iətəm Uhgɨn təməni məmə otahli=pa,’ kəni okoteiuə e nətəmimi tepət. ");
INSERT INTO tnp_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Onəkotətəu nanusiən mɨn rəha nəluagɨniən mɨn, kəni onəkotətəu nəghatiən əpnapɨn mɨn məmə nətəmimi kəutəluagɨn. Mətəu onauteh vivi itəmah məmə nəsotəgɨniən. Natimnati mɨn əha okotəkeikei məhuva motol nɨpəhriəniən lan, mətəu naunun nian otəpanuva. ");
INSERT INTO tnp_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Negəu mɨn okotoh negəu mɨn, kəni nɨtəni mɨn okotoh nɨtəni mɨn. Nəumɨs otan, kəni nəmig otəlauəl e ikɨn mɨn tepət. ");
INSERT INTO tnp_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Natimnati mɨn əha, ilah nətuəuiniən əmə rəha nərahiən, təhmen e pətan iətəm tɨnətuəuin mətətəu nahməiən o neməkiən. ");
INSERT INTO tnp_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“E nian mɨn əha, nətəmimi okotegəhan=pən e təmah məmə okol nərahiən kəm təmah, kəni kohamu itəmah, kəni nətəmimi rəha nɨtəni mɨn rəfin okotəməki e təmah mətəu-inu o nərgək. ");
INSERT INTO tnp_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kəni e nian mɨn əha, nətəmimi tepət okotəpəh rəhalah nəhatətəiən, kəni okotegəhan=pən e lah mɨn e nəhlmɨ tɨkɨmɨr mɨn rəhalah, kəni motəməki e lah mɨn, ");
INSERT INTO tnp_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","kəni iəni eiuə mɨn tepət okəhuva moteiuə e nətəmimi tepət. ");
INSERT INTO tnp_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mətəu-inu nərahiən tɨnepət, iuəkɨr nətəmimi rəfin rəhalah nolkeikeiən o Uhgɨn otɨkə, ");
INSERT INTO tnp_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","mətəu iətəmimi iətəm tətəhtul əskasɨk mətəuarus naunun nian, Uhgɨn otosmiəgəh in. ");
INSERT INTO tnp_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kəni nanusiən təuvɨr əha rəha Narmənɨgiən Rəha Uhgɨn, okəni pətɨgəm ikɨn mɨn rəfin e nəhue nɨftəni, məmə suaru əha ikɨn rəha nɨtəni mɨn rəfin o nətəlɨgiən, kəni naunun nian otuva. ");
INSERT INTO tnp_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Iəni u Daniəl təməghati e nati kəti kətəni məmə, ‘nati iətəm Uhgɨn təsolkeikeiən, kəni matol Nimə Rəha Uhgɨn təsasimiən’ (nian iətəmi kəti tafin nati u, pəh otətəlɨg e nɨpətɨn). Tol lanəha, nian nati tərah əha tətəhtul e Nimə Rəha Uhgɨn, ");
INSERT INTO tnp_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","kəni itəmah nətəm nəutatɨg Jutiə, nəkotaiu motagɨm məhuvən motəhluaig e nɨtəuət mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nəmə iətəmimi tətəmeig ihluə e rəhan nimə, ko təsuvəniən imə mos mɨn rəhan natimnati. ");
INSERT INTO tnp_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nəmə iətəmimi əpəha e nasumiən rəhan, ko təsɨtəlɨg-pəniən lahuənu mos rəhan kot. ");
INSERT INTO tnp_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","!Kəsi! Nahməiən asoli o nɨpətan nətəm kəmotol nərfɨlah mɨne nɨpətan kəutəfən nah kəm nəpəou mɨn. E nian əha okotos pɨk nahməiən. ");
INSERT INTO tnp_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Təuvɨr nəkotəfaki məmə onəsotagɨmiən e nərahiən əha e nian rəha nətəpuiən, uə e nian rəha Sapət, ");
INSERT INTO tnp_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","mətəu-inu e nian əha, nərahiən asoli otuva iətəm iətəmimi təsafuiən tol lanəha aupən mətəuarus=pa u rəueiu, kəni ko nərahiən asoli kəti mɨn tol lanəha otəsuva mɨniən nian kəti təhmen e inəha. ");
INSERT INTO tnp_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kəni nəmə Uhgɨn təsətei əkuəkɨriən nian rəha nərahiən əha, ko iətəmimi kəti təsəmiəgəhiən. Mətəu Uhgɨn təmətei əkuəkɨr rəkɨs nian əha o rəhan mɨn nətəmimi nətəm tɨnɨtəpɨn rəkɨs ilah. ");
INSERT INTO tnp_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“E nian əha, nəmə iətəmi kəti otəni=pɨnə kəm təmah məmə, ‘!Otafu-to, inu Krɨsto iətəm Uhgɨn təməni məmə otəpanahli=pa!’ uə ‘!In əpəha!’ sotəniən nɨpəhriəniən lan, ");
INSERT INTO tnp_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","mətəu-inu nətəmimi nəuvein okəhuva motəni məmə ilah Krɨsto, mɨne iəni eiuə mɨn okəhuva, kəni ilah okotol nəmtətiən asoli mɨn, mɨne nati apɨspɨs mɨn məmə okoteiuə e nətəmimi nətəm Uhgɨn təmɨtəpɨn rəkɨs ilah, nəmə ilah kotəhrun noliən. ");
INSERT INTO tnp_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nɨkitəmah otəkeikei mətəhti vivi nəghatiən mɨn u iətəm iəməni rəkɨs kəm təmah, uərisɨg natimnati mɨn u okəhuva motol nɨpəhriəniən lan. ");
INSERT INTO tnp_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Tol lanəha, nəmə iətəmi kəti təni kəm təmah məmə, ‘In əpəha, ikɨn təpiə-məpiə ikɨn,’ səhuvəniən. Uə iətəmi kəti təni məmə, ‘In əpə imə,’ nəsotəniən nɨpəhriəniən lan, ");
INSERT INTO tnp_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","mətəu-inu nian Nətɨ Iətəmimi otɨtəlɨg=pa mɨn, otuva uəhai əmə, kəni nətəmimi rəfin okoteruh in, təhmen e noraipiən iətəm təmoraip masiə mɨsɨpesi muva məsəu-pahav rəfin əpə ilɨs e nɨmagəuagəu. ");
INSERT INTO tnp_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Nian tiapɨn mɨn tepət kɨnotəri, kəni nəkotafu mənɨg mɨn ləuantəhi kəhuva. E noliən əhmen mɨn əmə, nian nəkoteruh nəmtətiən mɨn əha, nəkotəhrun məmə otəsuvəhiən iəkuva mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Nian əhruahru nərahiən əha otol naunun, kəni ‘mɨtɨgar otəpɨs agɨn, kəni məuɨg otəsasiə mɨniən, kəni məhau mɨn okotəmei e neai, kəni Uhgɨn otəlauəl e nəsanəniən e nati iəkɨs mɨn əpəha e neai.’ ");
INSERT INTO tnp_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“E nian əha, nəmtətiən rəha Nətɨ Iətəmimi okeruh pətɨgəm əmə e neai, nətəmimi e negəu mɨn rəfin e nəhue nɨftəni okotasək e nəgɨniən. Kəni okoteruh iəu, Nətɨ Iətəmimi iəkuva e nəpuə e neai e nəsanəniən mɨne nepətiən əhagəhag asoli rəha Uhgɨn iətəm otasiə mɨtəlau lak. ");
INSERT INTO tnp_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kəni iəkahli=pən rəhak nagelo mɨn kohiet nian okotətəu təui otasək əfəməh, kəni ilah okəhuvən ikɨn mɨn rəfin e nəhue nɨftəni, motos rəkɨs rəhak mɨn nətəmimi nətəm Uhgɨn təmɨtəpɨn rəkɨs ilah, kəni motuhapumɨn ilah kətiəh. ");
INSERT INTO tnp_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Nɨkitəmah otəkeikei mətəhti nɨgi u fik. Nian əhruahru iətəm nəhlmɨn mɨn kɨnəutətuəuin mauteviə, kəni nɨmalɨn mɨn kɨnəutapɨlpɨl, itəmah nəkotəhrun məmə nian əha inəha iətəm nəkotasum lan rəhatəmah. ");
INSERT INTO tnp_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kəni e noliən əhmen mɨn əmə, nian nəkoteruh nəmtətiən mɨn əha, onəkotəhrun məmə otəsuvəh agɨniən iəkuva mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Iatəni pəhriən kəm təmah məmə nətəmimi nətəm kəutatɨg u rəueiu, ko kəsohmɨs rəfiniən mətəuarus natimnati mɨn əha okəhuva motol nɨpəhriəniən lan. ");
INSERT INTO tnp_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Neai mɨne nɨftəni okiakə, mətəu nəghatiən mɨn rəhak ko kəsohkəiən.” ");
INSERT INTO tnp_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Kəni Iesu təmətəkeikei mətəni məmə, “Iətəmimi kəti təsəhruniən nian uə auə əhruahru rəha natimnati mɨn əha. Nagelo mɨn əpəha e neai kotəruru, kəni iəu mɨn Nətɨ Iətəmimi iəkəruru. Mətəu Tatə Uhgɨn əmə in təhrun nian əhruahru əha. ");
INSERT INTO tnp_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","E nian iəu, Nətɨ Iətəmimi, iəkuva lan, otəhmen=pən əmə e nian rəha Noa aupən, iətəm nətəmimi kəmotol natimnati mɨn məsotəhruniən məmə Uhgɨn otol nati kəti lan, məsotol əpenə-penəiən. ");
INSERT INTO tnp_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","E nian əha, iətəm naruəh təsaiu əhanəhiən, nətəmimi kəutauən, məutəmnɨm, mautol marɨt, inəha natimnati mɨn rəfin kəmautol e nəmiəgəhiən rəhalah, mətəuarus=pən nian Noa təmuvən imə e nɨpəgnəua negəu asoli rəhan, ");
INSERT INTO tnp_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","kəni ilah məsotəhruniən nati nak otuva mətəuarus=pa naruəh təmaiu məmki ilah rəfin. In əha otol təhmen əmə e nian Nətɨ Iətəmimi otuva lan. ");
INSERT INTO tnp_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Iətəmimi keiu e nasumiən, kəni okos kətiəh, kəpəh kətiəh. ");
INSERT INTO tnp_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Pətan keiu kətuəharəg pəti matuol nauəniən, kəni okos kətiəh, kəpəh kəti. ");
INSERT INTO tnp_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Tol lanəha, nəkotəkeikei motair, mətəu-inu nəkotəruru nian nak rəhatəmah Iərmənɨg otuva lan. ");
INSERT INTO tnp_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mətəu nəkotəkeikei motəhrun nati u. Nəmə iətəmi asoli rəha nimə təhrun nian əhruahru lapɨn iətəm iakləh otuva lan, kəni in otəkeikei mətair mateh vivi rəhan nimə məmə iakləh otəsəhapuiən muvən imə. ");
INSERT INTO tnp_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kəni itəmah mɨn onəkotəkeikei mautəhtul maru, mətəu-inu Nətɨ Iətəmimi otuva e auə əmə iətəm nɨkitəmah təsəhtiən. ");
INSERT INTO tnp_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Nɨkitəmah otəkeikei mətəhti vivi noliən rəha ioluək iətəm in teinatɨg kəni tətaskəlɨm vivi uək rəhan kəni məsəpəhiən. Iətəmi asoli təmələhu məmə ioluək əha otarmənɨg e rəhan mɨn rəfin noluək mɨn məmə in otəfən nauəniən kəm lah e nian əhruahru. ");
INSERT INTO tnp_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kəni nəmə iətəmi asoli otuva meruh iətəm tətarmənɨg e noluək mɨn rəhan, kəni matol vivi rəhan uək, kəni otəfən nətəouiən kəti kəm iətəmi əha. ");
INSERT INTO tnp_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nɨpəhriəniən iəkəni kəm təmah məmə, iərmənɨg in otəfəri ioluək əha tuva mol iətəmi asoli lan məmə in otarmənɨg e natimnati rəfin rəhan. ");
INSERT INTO tnp_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mətəu nəmə ioluək əha, in iətəmi tərah, kəni nɨkin otəhti məmə, ‘Rəhak iətəmi asoli təsuvaiən nuvəh,’ ");
INSERT INTO tnp_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","kəni mətuəuin matoh noluək mɨn nəuvein, kəni muvən mətauən mətəmnɨm ilah nətəm kəutapɨs. ");
INSERT INTO tnp_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kəni iətəmi asoli rəha noluək mɨn əha otuva e nian mɨne auə iətəm ioluək nɨkin təsəhtiən məmə rəhan iətəmi asoli otuva lan. ");
INSERT INTO tnp_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Iətəmi asoli əha otol nalpɨniən asoli kəm ioluək əha kəni məraki=pən lan ima nəfaki eiuə mɨn. Ikɨn əha, nətəmimi okotasək mautɨgət-ərain nəhluvlah ikɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Kəni Iesu təməni=pən kəm lah məmə, “Nəghatiən əuhlin u tətəgətun=pən Narmənɨgiən Rəha Uhgɨn e nian iətəm rəhatəmah Iərmənɨg otuva mɨn lan. Nɨpətan mɨtə ilah ten kəmohiet lapɨn məmə okəhuvən e marɨt kəti, kəni məutəhtahnin iətəmi otol marɨt otuva mos rəhan pətan muvən e rəhan nimə, əpəha ikɨn katol lafet ikɨn. Ilah ten kəmotos rəhalah lait. ");
INSERT INTO tnp_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Faif kotalməli, kəni faif koteinatɨg. ");
INSERT INTO tnp_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nɨpətan mɨn u ilah faif nətəm kotalməli kəmotos rəhalah lait mɨn, mətəu kəsotosiən kərəsin nəuvetɨn mɨn o niuvi-pəniən e lait. ");
INSERT INTO tnp_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Mətəu nɨpətan mɨn u ilah faif nətəm koteinatɨg kəmotos rəhalah lait mɨn, kəni motos mɨn kərəsin nəuvetɨn mɨn o niuvi-pəniən e rəhalah lait. ");
INSERT INTO tnp_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kəni iətəmi otol marɨt təsuva uəhaiən, kəni napɨliən tɨnos ilah, kəni mɨnəutapɨli. ");
INSERT INTO tnp_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Kəni lapɨn agɨn, iətəmi təmagət əfəməh məmə, ‘!Iətəmimi iətəm tatol marɨt tɨnatuva əha rəueiu! !Əhuva moteruh!’ ");
INSERT INTO tnp_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Kəni nɨpətan mɨtə mɨn u ilah ten kəmotair motuerin asoli rəhalah mɨn lait. ");
INSERT INTO tnp_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kəni nɨpətan nətəm kotalməli kotəni=pən kəm nɨpətan nətəm koteinatɨg məmə, ‘!Əui! Otəfa rəhatɨmah nəuvetɨn kərəsin mətəu-inu rəhatɨmah kərəsin e rəhatɨmah lait kɨnotamɨr, okotəpɨs rəueiu.’ ");
INSERT INTO tnp_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Mətəu nɨpətan nətəm koteinatɨg kotəni=pən kəm lah məmə, ‘!Kəpə! Kərəsin mɨn u kəsotəhmeniən e tah rəfin. Mətəu ohtəlɨg məhuvən motos nəhmtɨ rəhatəmah kətɨ kərəsin əpəha e stəuə.’ ");
INSERT INTO tnp_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Mətəu nian nɨpətan nətəm kotalməli kəmohtəlɨg məhuvən o kərəsin, kəni iətəmi iətəm otol marɨt təmuva. Kəni nɨpətan mɨtə nətəm kautəhtul maru, kəməhuvən ilah min e nauəniən rəha marɨt, kəni məhuvən imə. Kəni kasisɨg e doə. ");
INSERT INTO tnp_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Uərisɨg, nɨpətan mɨtə nətəm kotalməli kəmohtəlɨg=pa motauɨn motəni məmə, ‘!Iətəmi asoli, iətəmi asoli! !Egəhan e tɨmah iəkəhuvnə imə!’ ");
INSERT INTO tnp_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Mətəu iətəmi otol marɨt təməni=pən kəm lah məmə, ‘Iətəni=pɨnə pəhriən məmə, iəu iəkəruru itəmah.’” ");
INSERT INTO tnp_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kəni nian Iesu təmol naunun e nəghatiən əuhlin, təməni=pən kəm lah məmə, “Tol lanu lan, itəmah nəkotəkeikei məutair, mətəu-inu nəkotəruru nian mɨne auə rəha rəhatəmah Iərmənɨg otuva lan.” ");
INSERT INTO tnp_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Kəni Iesu təməni nəghatiən əuhlin kəti mɨn məmə, “Iəkəni mɨn nəghatiən əuhlin u tətəgətun=pən Narmənɨgiən Rəha Uhgɨn e nian iətəm rəhatəmah Iərmənɨg otuva mɨn lan. Iətəmi asoli kəti təmol əpenə-penə məmə otaliuək muvən isəu e nɨtəni pɨsɨn kəti. Kəni mauɨn e rəhan noluək mɨn kəhuva, kəni tələhu=pən e nəhlmɨlah rəhan məni məmə okotol nati kəti lan. ");
INSERT INTO tnp_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Təməfən tɨtəu=pən rəhalah nəhruniən məmə okotol uək lan. Iətəmimi kətiəh təfən faif-miliən vatu. Kəni kəti mɨn təməfən tu-miliən vatu. Kəni naunun lanko təməfən uan-miliən vatu. Kəni iətəmi asoli təmiet muvən e rəhan naliuəkiən. ");
INSERT INTO tnp_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Kəni ioluək iətəm təmos faif-miliən vatu təmuvən uəhai əmə mol bɨsnɨs tepət lan, kəni mos mɨn faif-miliən vatu. ");
INSERT INTO tnp_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kəni təhmen əmə e iətəm təmos tu-miliən vatu, təmuvən mol bɨsnɨs tepət mɨn lan, kəni mos mɨn tu-miliən vatu. ");
INSERT INTO tnp_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mətəu ioluək iətəm təmos uan-miliən vatu, in təmuvən mil nɨmɨl məhluaig=pən e məni rəha rəhan iətəmi asoli ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Kəni nu tepət tɨnuva mɨnuvən, kəni iətəmi asoli rəha noluək mɨn u təmɨtəlɨg=pa, kəni mauɨn e rəhan noluək mɨn məmə oteruh-to məmə ilah kəmotol nak e məni mɨn iətəm təməfən kəm lah. ");
INSERT INTO tnp_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ioluək iətəm təmos faif-miliən vatu, təmos mɨn faif-miliən vatu muva məhtul e nəhmtɨ iətəmi asoli kəni məni məmə, ‘Iətəmi asoli. Aupən nəmələhu=pa faif-miliən e nəhlmək. Kəni iəmol bɨsnɨs lan, kəni mos mɨn inəuau faif-miliən u.’ ");
INSERT INTO tnp_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Kəni iətəmi asoli təməni=pən kəm in məmə, ‘Nəmol təuvɨr, kəni ik ioluək təuvɨr iətəm nətaskəlɨm vivi uək rəham kəni məsəpəhiən. Nəmol təuvɨr lanu e natimnati mɨn əha nəuan nəuvetɨn, kəni iəkələhu ik nəkarmənɨg e natimnati tepət. !Va imə matɨg ahgəl nagiəniən rəha iətəmi asoli rəham!’ ");
INSERT INTO tnp_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ioluək iətəm təməfən tu-miliən vatu kəm in, təmuva məni=pən məmə, ‘Iətəmi asoli. Aupən nəmələhu=pa-tu miliən vatu e nəhlmək. Kəni iəmol bɨsnɨs lan, kəni mos mɨn inəuau tu-miliən u.’ ");
INSERT INTO tnp_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Kəni iətəmi asoli təməni=pən kəm in məmə, ‘Nəmol təuvɨr, kəni ik ioluək təuvɨr iətəm nətaskəlɨm vivi uək rəham kəni məsəpəhiən. Nəmol təuvɨr lanu lan e natimnati mɨn əha nəuan nəuvein, kəni iəkələhu ik nəkarmənɨg e natimnati tepət. !Va imə matɨg ahgəl nagiəniən rəha iətəmi asoli rəham! ");
INSERT INTO tnp_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ioluək iətəm kəməfən uan-miliən vatu kəm in, təmuva məni=pən məmə, ‘Iətəmi asoli. Ik iətəmi nətəkeikei pɨk kəm nətəmimi. Kəni ik natos nauəniən e nasumiən iətəm nəməsasumiən lan, kəni mətəhli nəua nɨgi e nɨgi iətəm nəməsərfeiən. ");
INSERT INTO tnp_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kəni iəməgɨn lam, məmə nəmə iəmərəkɨn rəham məni, kəni onəkol nalpɨniən asoli kəm iəu, kəni iəmos rəham məni muvən məhluaig e nɨftəni. Ah, inu rəham məni.’ ");
INSERT INTO tnp_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Kəni rəhan iətəmi asoli təməni=pən məmə, ‘!Ik ioluək tərah, ik iəlpah! Ik nɨnəhrun rəkɨs məmə iatos nauəniən e nasumiən iətəm iəsasumiən lan, kəni mətəhli nəua nɨgi e nɨgi iətəm iəsərfeiən. ");
INSERT INTO tnp_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","?Təhro nəsuvəniən əmə mələhu=pən rəhak məni e bank? Nəmə nəmol lanəha, nian iəmɨtəlɨg=pa, iəkuvən mos rəhak məni, kəni iəkos məni nəuvetɨn mɨn iətəm bank otəfa.’ ");
INSERT INTO tnp_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Kəni iətəmi asoli təməni=pən kəm rəhan ioluək pɨsɨn məmə, ‘Os rəkɨs məni ohni məfən kəm ioluək u iətəm təmos faif-miliən, ");
INSERT INTO tnp_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","mətəu-inu iətəmimi u iətəm tɨnos rəkɨs nati kəti mol uək lan tuva mepət, kəni okəfən mɨn nəuvein mɨn, rəhan natimnati tepət. Mətəu iətəmimi iətəm təsoliən uək e rəhan natimnati tuva mepət, okos rəkɨs rəfin natimnati ohni. ");
INSERT INTO tnp_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kəni ioluək u iəlpah iətəm təruru noliən nati təuvɨr kəti, əraki=pən lan ihluə e napinəpuiən, ikɨn əha kətasək ikɨn katɨgət-ərain nəhluvtəmi ikɨn.’” ");
INSERT INTO tnp_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Kəni Iesu təməni=pən məmə, “Nətɨ Iətəmimi otuva e nepətiən əhagəhag mɨne nəsanəniən rəhan, ilah nagelo mɨn rəfin. In Kig, kəni in otəharəg e rəhan jeə rəha Kig mətarmənɨg e nəsanəniən mɨne nepətiən əhagəhag rəhan. ");
INSERT INTO tnp_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nətəmimi rəfin e nəuanɨləuɨs mɨn rəfin e nəhue nɨftəni, okotuhapumɨn ilah min e nəhmtɨn, kəni in otəuəri nətəmimi təhmen e iətəmimi iətəm tateh sipsip mɨn tatəuəri sipsip mɨn mɨne nəni mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","In otəuəri sipsip mɨn kəhuva e nəhlmɨn maru, kəni nəni mɨn okəhuvən e nəhlmɨn məuɨl. ");
INSERT INTO tnp_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Kəni Kig otəni=pən kəm nətəmimi mɨn əha e nəhlmɨn maru məmə, ‘Əhuva-tə, itəmah u nətəm rəhak Tatə Uhgɨn təməfɨnə rəkɨs nəuvɨriən rəhan kəm təmah. Əhuva-tə motos nati nak u iətəm Uhgɨn təmələhu pɨsɨn rəhatəmah. Əhuva motatɨg ahgəl narmənɨgiən rəhan iətəm təmol əpenə-penə lan uərisɨg təmanol nɨtəni. ");
INSERT INTO tnp_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Əhuva motos, mətəu-inu nian nəumɨs təmatus iəu, nəkotəfa nauəniən iəkun; kəni iəmətəuauə, nəkotəfa nəhu iəkəmnɨm; kəni iəu iapɨspɨs, nəmotit iəu kəhuvən e rəhatəmah lahuənu; ");
INSERT INTO tnp_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","kəni rəhak napən tɨkə, kəni nəkotəfa napən kəm iəu; kəni matɨmɨs, nəkoteh vivi iəu; kəni iəmətatɨg e kaləpus, nəkəhuva motəsal=pa lak.’ ");
INSERT INTO tnp_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Kəni nətəmimi nətəm kotəhruahru okotəni=pən kəm in məmə, ‘?Iərmənɨg, nian nak iəmoteruh ik nəumɨs təmus ik, kəni iəkotaugɨn ik; uə nəməuauə, kəni iəkotəfɨnə nəhu məmə nəkəmnɨm? ");
INSERT INTO tnp_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","?Nian nak iəmoteruh ik iapɨspɨs, kəni iəkotit ik məhuvən lahuənu; uə rəham napən tɨkə, kəni iəkotəfɨnə napən kəm ik? ");
INSERT INTO tnp_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","?Nian nak iəmoteruh ik natɨmɨs, uə nətatɨg e kaləpus, kəni iəkəhuvnə motəsal=pɨnə lam?’ ");
INSERT INTO tnp_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Kəni Kig otəni=pɨnə məmə, ‘Iətəni=pɨnə nɨpəhriəniən məmə nati nak iətəm nəmotol kəm piak mɨn u kəti, nati əpnapɨn in ianrah, mətəu nəmotol kəm iəu.’ ");
INSERT INTO tnp_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Kəni in otəni=pən kəm nətəmimi mɨn u e nəhlmɨn məuɨl məmə, ‘Əhuvən isəu ohniəu. Uhgɨn tɨnələhu rəkɨs rəhatəmah nalpɨniən. Əhuvən e nɨgəm asoli iətəm tatuəu naunun tɨkə u Uhgɨn təmol rəha Setən mɨn nagelo mɨn rəhan. ");
INSERT INTO tnp_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Əhuvən isəu mətəu-inu nian nəumɨs təmus iəu, nəsotəfaiən nauəniən kəti məmə iəkun; kəni iəmətəuauə, nəsotəfaiən nəhu məmə iəkəmnɨm; ");
INSERT INTO tnp_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","kəni iəu iapɨspɨs, nəsotauɨniən lak məmə iəkuva lahuənu; kəni rəhak napən tɨkə, nəsotəfaiən napən kəti rəhak; kəni iəmatɨmɨs, mətatɨg e kaləpus, nəsotuvaiən motəsal=pa lak.’ ");
INSERT INTO tnp_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Kəni ilah mɨn okotəni=pən məmə, ‘!Iərmənɨg! ?Nian nak iətəm iəmoteruh ik nəumɨs təmus ik, uə mətəuauə, uə ik iapɨspɨs, uə rəham napən tɨkə, uə nəmatɨmɨs, uə nəmətatɨg e kaləpus kəni iəsəhuvnəiən motəsal=pɨnə lam? ");
INSERT INTO tnp_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Kəni in otəni=pən kəm lah məmə, ‘Iətəni=pɨnə pəhriən kəm təmah məmə, nəmə nəməsotasiruiən e piak mɨn u kəti, nati əpnapɨn in ianrah, mətəu nəməsoliən kəm iəu.’ ");
INSERT INTO tnp_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Kəni ilah okəhuvən motos nalpɨniən iətəm naunun tɨkə. Mətəu nətəmimi nətəm kotəhruahru okotos nəmiəgəhiən itulɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nian Iesu təmol naunun e nəghatiən mɨn əha kəm rəhan nətəmimi, kəni məni=pən kəm lah məmə, ");
INSERT INTO tnp_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nəkotəhrun məmə lafet rəha Pasova otuva, nian keiu əmə əha ikɨn. Kəni iəu, Nətɨ Iətəmimi, okegəhan=pən lak məmə okətu-pəri iəu e nɨgi kəməluau.” ");
INSERT INTO tnp_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kəni pris asoli mɨn mɨne nətəmi asoli rəha nəuanɨləuɨs rəha Isrel kəmotuhapumɨn ilah mɨn e nimə rəha pris asoli agɨn u nərgɨn u Kaiəfəs. ");
INSERT INTO tnp_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Kəni motəlpəkau məmə okotaskəlɨm Iesu e noliən ekəu-ekəu, məmə okotohamu in. ");
INSERT INTO tnp_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Mətəu kəmotəni məmə, “Səniəmə e nian rəha lafet rəha Pasova, okotol məta nətəmimi kotoh ilah mɨn motoh mɨn itah.” ");
INSERT INTO tnp_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nian Iesu əpəha Petəni e nimə rəha iətəmi əha, nərgɨn u Saimon u aupən leprosi təmol, ");
INSERT INTO tnp_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","kəni pətan kəti təmuva ohni mos səntə kəti u nəhmtɨn tiəkɨs, kəmiuvi=pən e pətəl kəmol e kəpiel iətəm nəhmtɨn tiəkɨs, kətəni məmə alapastə. Nian Iesu tətəharəg e tepɨl mətauən, kəni pətan u təməueiu rəhn-kapə e səntə əha. ");
INSERT INTO tnp_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nian nətəmimi rəha Iesu kəmotafu nati əha, niəməha təmol ilah, kotəni məmə, “?Təhro katərəkɨn nati u? ");
INSERT INTO tnp_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Səntə u, kəhrun noliən səlɨm lan, kəni kos məni asoli lan, kəfən kəm nanrah mɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Mətəu Iesu tɨnəhrun nəghatiən iətəm kəutəni, kəni təni=pən kəm lah məmə, “?Təhro nəutəni rah pətan u? In təmol nati təuvɨr agɨn kəm iəu. ");
INSERT INTO tnp_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nanrah mɨn nian rəfin kəutatɨg itəmah min ilah. Mətəu iəu, iəsatɨgiən kitah min itəmah nian rəfin. ");
INSERT INTO tnp_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nian təməueiu nɨpətɨk, təmol məmə otol əpenə-penə o nɨtənɨmiən iəu. ");
INSERT INTO tnp_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Iətəni pəhriən kəm təmah məmə, ikɨn mɨn rəfin e nəhue nɨftəni iətəm okəni pətɨgəm nanusiən təuvɨr u, kəni okəkeikei kəni pətɨgəm mɨn nati nak iətəm pətan u təmol, kəni nɨkilah otətəhti mɨn in.” ");
INSERT INTO tnp_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kəni iətəmimi tueləf u kəti rəha Iesu, nərgɨn u Jutəs Iskariot, təmuvən meruh pris asoli mɨn, ");
INSERT INTO tnp_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","kəni məni=pən məmə, “?Onəkotəfa nak kəm iəu nəmə iəkegəhan=pɨnə e Iesu kəm təmah?” Kəni kəmotafin məni ilah rəfin tate iətəm kəmol e sɨlfə. ");
INSERT INTO tnp_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kəni tətuəuin e nian əha, Jutəs təmətəsal e suaru məmə otegəhan=pən Iesu e nəhlmɨ rəhan mɨn tɨkɨmɨr mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","E nian əha e nətuəuiniən nian iətəm lafet rəha Pɨret u Is Tɨkə Lan, nətəmimi rəha Iesu kəməhuva motəni=pən kəm in məmə, “?Nəkolkeikei məmə itɨmah iəkotol əpenə-penə iə rəham nauəniən rəha lafet rəha Pasova məmə nəkauən ikɨn?” ");
INSERT INTO tnp_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kəni Iesu təməni=pən məmə, “Əhuvən əpəha e taun. Iətəmi kəti əha ikɨn inɨtəpɨn rəkɨs, kəni onəkoteruh in. Kəni nəkotəni=pən kəm in məmə, ‘Iəgətun tətəni məmə: Nian iətəm Uhgɨn təmɨtəpɨn rəkɨs məmə rəhak, tɨnuva iuəkɨr. Kəni iəkol lafet rəha Pasova kitah min itɨmah rəhak mɨn nətəmimi e rəham nimə.’” ");
INSERT INTO tnp_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tol lanəha rəhan nətəmimi kəmotol nati nak iətəm Iesu təməni məmə okotol o nol əpenə-penəiən o nauəniən rəha lafet rəha Pasova. ");
INSERT INTO tnp_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nian tɨnapinəpu, Iesu tətəharəg ilah rəham nətəmimi tueləf əpəha e tepɨl. ");
INSERT INTO tnp_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kəni nian kəməutauən, kəni təməni=pən kəm lah məmə, “Iatəni pəhriən kəm təmah məmə itəmah kəti otegəhan=pən lak e nəhlmɨ tɨkɨmɨr mɨn rəhak.” ");
INSERT INTO tnp_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kəni nɨkilah tɨnəpəou, kəni ilah rəfin kətiəh kətiəh kəmotəni=pən kəm Iesu məmə, “?Eh, Iərmənɨg, pəh u? ?Iəu?” ");
INSERT INTO tnp_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kəni Iesu təməni=pən məmə, “Iətəmimi iətəm otegəhan=pən lak e nəhlmɨ tɨkɨmɨr mɨn rəhak, in rəhak kəti iətəm tatos nɨgɨn pɨret məfən məuveri e pɨlet pəti əmə itɨmlau min. ");
INSERT INTO tnp_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Kəni iəu Nətɨ Iətəmimi oiəkəkeikei mɨmɨs məmə inu Nauəuə Rəha Uhgɨn təməni lak mɨne. !Mətəu kəsi, nərahiən asoli o iətəmi u iətəm otegəhan=pən e Nətɨ Iətəmimi e nəhlmɨ rəhan tɨkɨmɨr mɨn! Təuvɨr pɨk agɨn nəmə təməsair əməiən.” ");
INSERT INTO tnp_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Kəni Jutəs u iətəmi otegəhan=pən e Iesu e nəhlmɨ rəhan tɨkɨmɨr mɨn təməni=pən məmə, “Iəgətun. ?Pəh kəha? ?Iəu?” Mətəu Iesu təməni=pən kəm in məmə, “Əuəh, ik. Ik aru nəməni.” ");
INSERT INTO tnp_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nian kəməutauən, Iesu təmos pɨret, məfaki məni tagkiu ohni, məhapu, məfən kəm rəhan mɨn nətəmimi, məni=pən məmə, “Otos motun, inu nɨpətɨk.” ");
INSERT INTO tnp_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kəni mos kap wain, məfaki məni tagkiu ohni, məfən kəm rəhan mɨn nətəmimi, məni=pən məmə, “Otəmnɨm, itəmah rəfin. ");
INSERT INTO tnp_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Inu nɨrak iətəm tatol məmə nəniəskasɨkiən rəha nasiruiən in tətəhtul mətəmiəgəh. Nɨrak u otaiu o nɨmənin nətəmimi tepət məmə otafəl rəkɨs rəhalah noliən tərah mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Iətəni pəhriən kəm təmah məmə iəsəmnɨm mɨniən wain u mətəuarus=pən nian iətəm iəkəmnɨm wain vi kitah min itəmah əpəha e negəu rəha Tatə rəhak.” ");
INSERT INTO tnp_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kəni kəmotani nəpuən əfaki kəti, uərisɨg kohiet məhuvən əpəha e Nɨtəuət Rəha Nɨgi U Olif. ");
INSERT INTO tnp_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kəni Iesu təməni=pən kəm lah məmə, “O lapɨn əmə u, nəkotəhlman e rəhatəmah nəhatətəiən lak o nati iətəm okol lak. Nauəuə Rəha Uhgɨn iətəm təkeikei mol nɨpəhriəniən, təməni məmə, ‘Iəu iəkohamu iətəmimi iətəm tətəsal o sipsip mɨn, kəni sipsip mɨn okotaiu kətiəh kətiəh.’ ");
INSERT INTO tnp_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Mətəu nian iəkəmiəgəh mɨn e nɨmɨsiən, iəkaupən muvən əpəha Kaləli, kəni itəmah nəmanəhuərisɨg.” ");
INSERT INTO tnp_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Kəni Pitə təməni=pən məmə, “Məta, ilah rəfin okotəpəh rəhalah nəhatətəiən lam, mətəu iəu, kəpə, iəsəpəhiən rəhak nəhatətəiən lam nian kəti mɨne.” ");
INSERT INTO tnp_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Kəni Iesu təməni=pən kəm Pitə məmə, “Iətəni=pɨnə pəhriən kəm ik məmə, lapɨn əmə u, mənɨg otəsəkakə əhanəhiən, onəkəni mau kɨsɨl məmə nəkəruru iəu.” ");
INSERT INTO tnp_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Mətəu Pitə təməni məmə, “!Nati əpnapɨn iəkəkeikei mɨmɨs kilau mɨn ik, ko iəsəniən məmə iəkəruru ik!” Kəni rəhan mɨn rəfin nətəmimi kəmotəni mɨn təhmen e Pitə. ");
INSERT INTO tnp_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kəni Iesu mɨne rəhan mɨn nətəmimi kəməhuvən ikɨn kəti kətəni kəmə Ketsəməni, kəni təməni=pən kəm lah məmə, “Əutəharəg u ikɨn u, pəh iəu iəkuvən ikɨn əha məfaki=pən kəm Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kəni təmit Pitə mɨne nətɨ Səpəti mil ilah min, nɨkin tɨnahmə pɨk, kəni tɨnətəu tərah. ");
INSERT INTO tnp_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kəni təməni=pən kəm lahal məmə, “Iəkətəu nɨkik tɨnahmə pɨk, iuəkɨr iəkɨmɨs lan. Itəmahal ələharəg u ikɨn u, məhlair kitah min iəu.” ");
INSERT INTO tnp_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kəni muvən nəuan nəuvetɨn əmə, meiuaiu mɨsin=pən rəhan kapə e nɨftəni mətəfaki, mətəni məmə, “Rəhak Tatə, nəmə suaru kəti mɨn əha ikɨn o rəham nəlpəkauiən, pəh nəkoh rəkɨs ohniəu nərahiən iətəm tətuva.” Matəkeikei məmə, “Mətəu səniəmə nəkol nəuiak, mətəu nəkol nəuiam.” ");
INSERT INTO tnp_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kəni təmɨtəlɨg=pa meruh ilahal kəhlapɨli. Kəni təməni=pən kəm Pitə məmə, “!?Təhro nəslairiən kitah min iəu o auə kətiəh əmə mɨne!? ");
INSERT INTO tnp_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ɨhlair kəni mɨhləfaki məmə nəhləhtul əskasɨk nian nəfən-əfəniən tuva o təmahal. Nɨkitəmahal tolkeikei, mətəu nɨpətɨtəmahal təpəou.” ");
INSERT INTO tnp_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kəni mɨtəlɨg=pən mɨn mətəfaki mau keiu, mətəni məmə, “Rəhak Tatə, nəmə iəkəkeikei mos nərahiən iətəm tətuva, kəni pəh nəkol nəuiam.” ");
INSERT INTO tnp_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kəni nian təmɨtəlɨg=pa, təmeruh ilahal kɨnlapɨli mətəu napɨliən təmos ilahal. ");
INSERT INTO tnp_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kəni təpəh ilahal mɨtəlɨg=pən mɨn mətəfaki mau kɨsɨl, mətəni əmə nəghatiən kətiəh əmə. ");
INSERT INTO tnp_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kəni mɨtəlɨg=pa məni=pən kəm lahal məmə, “?Nəhlapɨli əhanəh məhləmeig? Lahfu-to, nian tɨnuva iuəkɨr əha rəueiu, kəni iəu Nətɨ Iətəmimi, okegəhan=pən lak e nəhlmɨ nətəm nol təfagə tərah. ");
INSERT INTO tnp_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","!Ɨhləhtul-tə, kautəhuvən! Lahfu-to, iətəmimi u tətegəhan=pən lak e nəhlmɨ tɨkɨmɨr mɨn, əpəha tətuva.” ");
INSERT INTO tnp_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nian Iesu təmətəghati əhanəh, Jutəs, in iətəmi tueləf kəti rəha Iesu, təmietɨgəm=pa ilah nɨmənin nətəmimi nətəm kautəmki nau asoli rəha nəluagɨniən mɨne neim. Pris asoli mɨn mɨne nətəmi asoli rəha nəuanɨləuɨs mɨn rəha Isrel kəmotahli=pa ilah. ");
INSERT INTO tnp_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jutəs təməni=pən rəkɨs nəghatiən kəm lah məmə, “Pəh u iətəm iəkol nəmtətiən kəti rəha nolkeikeiən lan, kəni nəkotaskəlɨm.” ");
INSERT INTO tnp_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kəni rəueiu agɨn, Jutəs təmaliuək muvən o Iesu məni=pən kəm in məmə, “!Təuvɨr, Iəgətun!” Kəni təmol nəmtətiən rəha nolkeikeiən kəm in. ");
INSERT INTO tnp_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Kəni Iesu təməni=pən kəm in məmə, “Iəu kəti, ol nati nak iətəm nəmuva ohni.” Kəni nətəmimi kəməhuva motaskəlɨm Iesu məmə okotləfən e kaləpus. ");
INSERT INTO tnp_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kəni iətəmimi kəti rəha Iesu təmeapən meuvi rəkɨs nau rəha nəluagɨniən, kəni mauəh lan mohatuv rəkɨs matəlgɨ ioluək rəha pris asoli agɨn. ");
INSERT INTO tnp_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kəni Iesu təməni=pən kəm in məmə, “Əfən rəham nau e nɨmein, mətəu nətəmi mɨn kəutauəh e nau, okohmɨs e nau. ");
INSERT INTO tnp_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","?Nəkəhrun uə kəpə məmə iəkəhrun nauɨniən e rəhak Tatə, kəni rəueiu agɨn mɨn otahli=pa nagelo mɨn tausɨn tepət tepət məmə okotasiru lak? ");
INSERT INTO tnp_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mətəu nəmə iəkol lanəha, ko Nauəuə Rəha Uhgɨn otəsuvaiən mol nɨpəhriəniən lan, iətəm tətəni məmə otuva tol lanu lan.” ");
INSERT INTO tnp_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","E nian əha, Iesu təməni=pən kəm nɨmənin nətəmimi məmə, “?Təhro nəməhuva motəmki nau asoli mɨn mɨne neim mɨn? ?Nɨkitəmah təhti məmə iəu iohamu itəmi kəti matol nəluagɨniən o nələs iahuiən kəpmən, uə? !Kəpə! Nian rəfin iətəharəg əpəha e Nimə Rəha Uhgɨn mətəgətun nətəmimi, kəni nəsəhuvaiən motaskəlɨm iəu. ");
INSERT INTO tnp_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mətəu natimnati rəfin mɨn u tɨnuva mɨnol nɨpəhriəniən lan məmə Nauəuə Rəha Uhgɨn iətəm iəni mɨn aupən kəmotətei otuva mol nɨpəhriəniən lan.” Kəni rəhan mɨn nətəmimi kəmotəpəh in motagɨm. ");
INSERT INTO tnp_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nətəmimi mɨn u kəmotaskəlɨm Iesu, kəmotələs məhuvən o Kaiəfəs u in pris asoli agɨn. Ikɨn əha, iəgətun mɨn rəha Lou mɨne nətəmi asoli rəha nəuanɨləuɨs rəha Isrel, kəutəhuva motohapumɨn ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Mətəu Pitə tətan təlɨg-təlɨg matuərisɨg e Iesu, muvən əpəha lahuənu rəha pris asoli agɨn. Kəni təmuvən əpəha e iat mətəharəg ilah soldiə mɨn məmə oteruh-to məmə okol nak e Iesu. ");
INSERT INTO tnp_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pris asoli mɨn mɨne nətəmimi rəfin rəha kaunsɨl kəutəsal e nəghatiən eiuə mɨn e Iesu məmə okohamu o nəghatiən mɨn əha. ");
INSERT INTO tnp_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mətəu kəsoteruhiən noliən tərah kəti rəhan e nəghatiən eiuə mɨn rəha nətəmimi, nati əpnapɨn nəghatiən eiuə mɨn tepət kəmohiet. Kəni əmeiko, iətəmimi keiu kiəuva aupən, ");
INSERT INTO tnp_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","kəni muəni pətɨgəm məmə, “Suah u təmətəni məmə təhrun nərəkɨniən Nimə Rəha Uhgɨn, kəni muvləkɨn mɨn e nian kɨsɨl əmə.” ");
INSERT INTO tnp_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kəni pris asoli agɨn təhtul məni=pən kəm Iesu məmə, “?Təhro nəsəghatiən? ?Təhro e nəghatiən mɨn əha iətəm kətəni pətɨgəm tətələs pɨkɨn ik?” ");
INSERT INTO tnp_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mətəu Iesu təpnapɨn əmə məsəghatiən. Kəni pris asoli agɨn təməni=pən kəm in məmə, “Onəkəkeikei mos nonauvɨl kəti e Uhgɨn iətəm tətəmiəgəh, kəni məni pətɨgəm nɨpəhriəniən kəm tɨmah məmə ik Nətɨ Uhgɨn mɨne Krɨsto iətəm Uhgɨn təməni məmə otahli=pa, uə kəpə.” ");
INSERT INTO tnp_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Kəni Iesu təməni=pən məmə, “Əuəh, tol əmə məmə inu nəməni mɨne. Mətəu iəkəni=pɨnə kəm təmah rəfin məmə, e nian iətəm otuva, onəkoteruh iəu Nətɨ Iətəmimi iəkəharəg e nɨkalɨn maru e Uhgɨn u iətəm rəhan nəsanəniən iahgin, kəni məteiuaiu=pa e neai e nəpuə.” ");
INSERT INTO tnp_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kəni pris asoli agɨn tearɨs rəhan napən mətəu-inu niəməha təmol o nəghatiən rəha Iesu, kəni məni məmə, “!Tətəghati rah e Uhgɨn! ?Təhro məmə suah kəti mɨn təkeikei məghati mɨn lan? Otətəlɨg-to, nəmotətəu nəghatiən tərah kəha. ");
INSERT INTO tnp_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","?Nɨkitəmah təhti məmə nak?” Kəni kəmotəni=pən məmə, “Otəkeikei mɨmɨs.” ");
INSERT INTO tnp_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kəni kəmotagəh əpnapɨn əmə nəhmtɨn, kəni motəhti e nəhlmɨlah. Nəuvein kotem e nəhlmɨlah, ");
INSERT INTO tnp_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","kəni motəni=pən məmə, “Ei, Krɨsto. ?Əni pətɨgəm e nəsanəniən rəha Uhgɨn məmə pəh təmoh ik?” ");
INSERT INTO tnp_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","E nian əha, Pitə tətəharəg ihluə e iat rəha nimə, kəni pətan mɨtə kəti u in ioluək tuva ohni məni=pən kəm in məmə, “Ik mɨn u, nəmatuərisɨg e Iesu, iətəm Kaləli.” ");
INSERT INTO tnp_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mətəu Pitə təmeiuə e lah rəfin məmə, “Iəkəruru nati ko iətəm nətəni.” ");
INSERT INTO tnp_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kəni maliuək muvən e ket rəha iat, kəni ikɨn əha pətan mɨtə kəti mɨn təmeruh in, kəni təməni=pən kəm nətəmimi ikɨn əha məmə, “suah u kəti u təmatuərisɨg e Iesu Iətəm Nasərɨt.” ");
INSERT INTO tnp_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Mətəu Pitə təmeiuə əskasɨk mɨn mos nonauvɨl məmə, “!Iəkəruru suah kəha!” ");
INSERT INTO tnp_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Təsuvəhiən, nətəmimi mɨn u kautəhtul ikɨn əha kəməhuvən o Pitə motəni=pən məmə, “Pəhriən məmə ik kəti əha, mətəu-inu noliən rəha nəghatiən rəham təhmen əmə e lah.” ");
INSERT INTO tnp_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Kəni təni məmə nəmə təteiuə pəh nərahiən rəha Uhgɨn otuva ohni. Kəni təmos nonauvɨl məmə, “!Iəkəruru suah kəha!” Kəni rəueiu agɨn, mənɨg təkakə. ");
INSERT INTO tnp_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kəni Pitə nɨkin təhti nəghatiən iətəm Iesu təməni kəm in məmə, “Uərisɨg mənɨg təkakə, onəkəni mau kɨsɨl məmə nəkəruru iəu.” Kəni Pitə təmiet muvən ihluə, nɨkin tɨtəgɨt kəni təmasək pɨk. ");
INSERT INTO tnp_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ləplapɨn agɨn, pris asoli mɨn rəfin mɨne nətəmi asoli mɨn rəha nətəmimi kəmotuhapumɨn mɨn motətei nəuə məmə okotohtəu=pən suaru nak o nohamuiən Iesu. ");
INSERT INTO tnp_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kəmotəlis in, kəni motələs məhuvən motəhlman=pən lan e nəhlmɨ Pailət, kəpmən rəha Rom. ");
INSERT INTO tnp_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nian Jutəs u iətəm təmegəhan=pən e Iesu e nəhlmɨ rəhan mɨn tɨkɨmɨr, təmafu məmə kəmotiuvi pətɨgəm Iesu məmə otɨmɨs, nɨkin tɨnahmə pɨk o nati iətəm təmol, kəni təmki məni əha kəmol e silfə ilah tate, məmə otəfən kəm pris asoli mɨn mɨne nətəmimi asoli mɨn rəha nətəm Isrel. ");
INSERT INTO tnp_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kəni məni=pən məmə, “Inol təfagə tərah mətəu-inu iəmegəhan=pən e nəhlmɨ tɨkɨmɨr mɨn iətəmi kəti iətəm təsoliən nati kəti tərah.” Kəni kotəni=pən məmə, “Inu nati əpnapɨn əmə o tɨmah. !In nati kəti rəham əmə!” ");
INSERT INTO tnp_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tol lanəha, Jutəs təməmki məni morin=pən əpəha e Nimə Rəha Uhgɨn, kəni in miet magɨm muvən marin aru in. ");
INSERT INTO tnp_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kəni pris asoli mɨn kəməhuvən motəuəri-əuəri məni, kəni motəni məmə, “Təsəhruahru-pəniən e rəhatah Lou məmə okotələhu=pən məni u ilah məni rəha Nimə Rəha Uhgɨn, mətəu-inu kəmotos nəhmtɨ nɨra iətəmimi lan.” ");
INSERT INTO tnp_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kəni kautəni məmə okotos məni kəha məhuvən motos nəhmtɨ nɨftəni kəti u aupən kətəni məmə, “nɨftəni rəha iətəmi kəti iətəm tatol sospən e nɨftəni,” kəni kautəni məmə okatɨtənɨm napɨspɨs mɨn ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tol lanəha, muva mətəuarus=pa u rəueiu, nətəmimi kəutauɨn e nɨftəni əha məmə, “Nɨftəni E Nɨrə.” ");
INSERT INTO tnp_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kəni nəghatiən nak iətəm iəni Jerɨmaiə təməni aupən, təmuva mol nɨpəhriəniən lan. Təməni məmə, “Kəmotos məni tate əha iətəm kəmol e silfə, inu nəhmtɨn iətəm nətəm Isrel kəmotəni o iətəmi u, ");
INSERT INTO tnp_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","kəni kautos məni əha məmə okotos nəhmtɨn ‘nɨftəni o noliən sospən,’ təhmen əmə məmə Iərmənɨg təməni kəm iəu.” ");
INSERT INTO tnp_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Kəni Iesu təmuvən məhtul e nəhmtɨ Pailət, kəni Pailət təmətapuəh ohni məmə, “Ik kig rəha nətəm Isrel?” Kəni Iesu təməni=pən məmə, “Əuəh, tol əmə məmə inu nəməni mɨne.” ");
INSERT INTO tnp_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nian pris asoli mɨn mɨne nətəmi asoli mɨn rəha Isrel kautəni pətɨgəm nəghatiən mɨn e Iesu, mətəu Iesu təsuhalpɨniən rəhalah nəghatiən. ");
INSERT INTO tnp_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kəni Pailət təməni=pən kəm in məmə, “?Natətəu nəghatiən mɨn iətəm kəutəni tatələs pɨkɨn ik, uə kəpə?” ");
INSERT INTO tnp_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mətəu Iesu təpnapɨn əmə məsəghatiən, kəni məsuhalpɨn mɨniən nəghatiən kəti ilah kəutəni, kəni Pailət, narmɨn təmiuvɨg pɨk. ");
INSERT INTO tnp_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kəni e nian rəha lafet rəha Pasova, in noliən rəha kəpmən məmə otahli pətɨgəm iətəmimi kəti e kaləpus iətəm nɨmənin nətəmimi kəmotəni. ");
INSERT INTO tnp_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","E nian əha, iətəmi kəti tətəməhli e kaləpus, nərgɨn u Parəpəs. Kəni nətəmimi rəfin kotəhrun məmə in təmol tərah pɨk agɨn. ");
INSERT INTO tnp_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kəni nian nɨmənin nətəmimi kɨnəhuva, kəni Pailət təmətapuəh o lah məmə, “?Nəkotolkeikei məmə iəkahli pətɨgəm pəh e kaləpus tiet matuvən, Parəpəs, uə Iesu, kətauɨn lan məmə Krɨsto?” ");
INSERT INTO tnp_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Təməni lanəha mətəu-inu in təhrun məmə kəmotegəhan=pən e Iesu e nəhlmɨn mətəu-inu kautetet Iesu. ");
INSERT INTO tnp_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nian Pailət tətəharəg e jeə rəha nakiliən nəghatiən, rəhan pətan tahli=pən nəghatiən kəm in məmə, “Suah konu təsoliən nati tərah kəti. Soliən nati kəti lan, mətəu iəməməhlair lan, kəni rəueiu iətətəu tərah agɨn ohni.” ");
INSERT INTO tnp_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mətəu pris asoli mɨn mɨne nətəmi asoli rəha nətəm Isrel kəmotəghati kəm nɨmənin nətəmimi məmə okotəuhlin nətəlɨgiən rəhalah. Kəni ilah kəmotətapuəh o Pailət məmə otahli pətɨgəm Parəpəs, kəni kotohamu Iesu. ");
INSERT INTO tnp_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kəni Pailət təmətapuəh o lah məmə, “?Suah mil u, in pəhruvən lan iəkahli pətɨgəm?” Mətəu nɨmənin nətəmimi kəmotəni=pən məmə, “Parəpəs.” ");
INSERT INTO tnp_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Kəni Pailət təməni=pən məmə, “?Kəni oiəkəhro Iesu u kətəni məmə Krɨsto?” Kəni nɨmənin nətəmimi rəfin kəmotəni=pən məmə, “!Okətu-pəri e nɨgi kəməluau otɨmɨs!” ");
INSERT INTO tnp_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kəni Pailət təməni=pən kəm lah məmə, “?O nak? ?Təmol nati tərah nak?” Mətəu nɨmənin nətəmimi kəmotagət əfəməh, motəni məmə, “!Okətu-pəri in e nɨgi kəməluau otɨmɨs!” ");
INSERT INTO tnp_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kəni nian Pailət təmeruh məmə ko təsələhuiən nəghatiən rəhalah, kəni ilah kɨnəutəhtul maru o norgəhuiən, kəni tos nəhu meikuas e nəhlmɨn e nəhmtɨ nɨmənin nətəmimi, kəni məni=pən kəm lah məmə, “Nəghatiən kəti rəhak tɨkə o suah u, məmə nɨran otəməhli=pa lak. !Nɨmɨsiən rəhan tətəməhli=pɨnə e nəhlmɨtəmah!” ");
INSERT INTO tnp_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Kəni nətəmimi rəfin kəmotəni məmə, “!Pəh nɨran təməhli=pa o tɨmah mɨne kəlkələh mɨn rəhatɨmah mɨn!” ");
INSERT INTO tnp_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kəni Pailət təmahli pətɨgəm megəhan=pən e Parəpəs kəm lah. Mətəu təməni məmə okalis Iesu, kəni təmegəhan=pən lan məmə okətu-pəri e nɨgi kəməluau məmə otɨmɨs. ");
INSERT INTO tnp_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kəni soldiə mɨn rəha Pailət kotələs Iesu məhuvən əpəha imə e nimə asoli rəha kəpmən, kətəni məmə Praetoriəm. Kəni kəmotauɨn rəfin e soldiə mɨn kəhuva mohtəlau lan. ");
INSERT INTO tnp_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kəni motəmkirəkɨs rəhan natimnati, məhuvən=pən e kot ərarəuv kəti kəm in, təhmen e kot rəha kig kəti. ");
INSERT INTO tnp_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Kəni motol nɨləuɨs iətəm nihlɨn əha ikɨn motol kəfəfau lan, motəfəfau=pən e rəhn-kapə Iesu motaləh əuvsan lan məmə in hat rəha kig kəti. Kəni motələhu=pən nəuanɨgi kəti e nəhlmɨn maru məmə in nɨgi rəha kig, kəni motɨsin nəulɨlah aupən lan, motaləh əuvsan, motəni=pən kəm in məmə, “!Iəkotɨsiai ik, kig rəha nətəm Isrel!” ");
INSERT INTO tnp_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Kəni motagəh lan, kəni motələs nəuanɨgi motoh rəhn-kapə lan motau tepət. ");
INSERT INTO tnp_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nian kɨnotol əuvsan rəkɨs lan, kəni motəpeg rəkɨs kot ərarəuv, məhuvən=pən mɨn e rəhan natimnati. Kəni motələs məhuvən məmə okotətu-pəri e nɨgi kəməluau məmə otɨmɨs. ");
INSERT INTO tnp_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nian kəmautəhuvən, motafu iətəm Sairəni kəti, nərgɨn u Saimon, kəni kəmotəni=pən əskasɨk ohni məmə otələs nɨgi kəməluau. ");
INSERT INTO tnp_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kəməhuva ikɨn kəti kətəni məmə, Kolkotə, u nɨpətɨn tətəni məmə Louipɨl-uipɨl. ");
INSERT INTO tnp_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ikɨn əha kəmotəfən wain kəm Iesu iətəm kəmalkin ilau nati tarfu. Mətəu nian Iesu təməmnɨm askəuvɨn, kəni məpəh nəmnɨmiən. ");
INSERT INTO tnp_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nian kəmətu-pəri e nɨgi kəməluau, kəni moturin tais o rəhan napən. ");
INSERT INTO tnp_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kəni məutəharəg mauteruh Iesu ikɨn əha məmə otɨmɨs agɨn. ");
INSERT INTO tnp_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ilɨs e rəhn-kapə, kəmətei=pən nɨpəgnəmtɨ nəniən tətəni məmə, Inu Iesu, kig rəha nətəm Isrel. ");
INSERT INTO tnp_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Kəni iətəmimi keiu iətəm katuoh nətəmimi mətuakləh e rəhalah natimnati, kəmətu-pəri ilau e nɨgi kəməluau, kəti e nɨkalɨn maru, kəti e nɨkalɨn məuɨl. ");
INSERT INTO tnp_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kəni nətəmimi mɨn u kəməutaliuək məutəhuva mautəhuvən, məutəni=pən nəghatiən tərah kəm Iesu, mauturin-urin rəhn-kapə lah, ");
INSERT INTO tnp_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","mautəni məmə, “Nəmətəni məmə onəkərəkɨn Nimə Rəha Uhgɨn kəni ik pɨsɨn əmə muvləkɨn o nian kɨsɨl. !Osmiəgəh aru ik! !Kəni eiuaiu e nɨgi kəməluau nəmə ik Nətɨ Uhgɨn pəhriən!” ");
INSERT INTO tnp_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","E noliən əhmen mɨn əmə, pris asoli mɨn, mɨne iəgətun asoli mɨn rəha Lou, mɨne nətəmimi asoli mɨn rəha nətəm Isrel kotol əuvsan, ");
INSERT INTO tnp_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","motəni məmə, “Təmosmiəgəh nətəmimi, mətəu ko təruru nosmiəgəh aruiən in. In kig rəha Isrel. Nəmə teiuaiu aru e nɨgi kəməluau, kəni okotəni nɨpəhriəniən lan. ");
INSERT INTO tnp_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tətəhatətə e Uhgɨn. Təməni məmə in Nətɨ Uhgɨn, kəni pəh Uhgɨn tos rəkɨs in əha rəueiu nəmə in tolkeikei.” ");
INSERT INTO tnp_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","E noliən əhmen mɨn əmə, iakləh mil iətəm kəmətu-pəri ilau ilahal min e nɨgi kəməluau, kətuəni=pən nəghatiən tərah tepət kəm in. ");
INSERT INTO tnp_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kəni e tueləf klok mətəuarus=pən tri klok, napinəpuiən təmeiuaiu mɨrəuei rəfin natimnati. ");
INSERT INTO tnp_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kəni iuəkɨr e tri klok ləhnaiuv, Iesu təmasək əfəməh e rəhan nəghatiən məni məmə, “!Eli, Eli! ?Lema sapaktəni?” Nɨpətɨ rəhan nəghatiən təni məmə, “!Uhgɨn rəhak, Uhgɨn rəhak! ?Təhro nətəpəh iəu?” ");
INSERT INTO tnp_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nian nətəmimi nəuvein nətəm kəmautəhtul əha ikɨn kəmotətəu təmasək əfəməh lanəha, kəni kotəni məmə, “In tətauɨn e Elaijə.” ");
INSERT INTO tnp_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kəni rəueiu agɨn mɨn, kəti təmaiu muvən mələs nati kəti təhmen e kotɨn, kəni məueiu wain u tarfu, məu e nɨgi, kəni məfən məmə Iesu otəmnɨm. ");
INSERT INTO tnp_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kəni ilah mɨn nəuvein kotəni=pən məmə, “Əpəh əmə. Pəh kauteh-to nəmə Elaijə otuva mosmiəgəh in, uə kəpə.” ");
INSERT INTO tnp_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kəni Iesu təmasək əfəməh mɨn, megəhan aru lan məmə otɨmɨs, kəni rəhan nehagiən tiet. ");
INSERT INTO tnp_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","E nian əhruahru əha, napən iətəm tətəhkul e Nimə Rəha Uhgɨn təməhapu mol nəuvetɨn keiu, təmətuəuin əpəha ilɨs muva mol naunun əpəha ləhtəni. Nəmig təməlauəl, kəni kəpiel mɨn kəmotəhapu. ");
INSERT INTO tnp_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Kəni suvət mɨn u kəmol e nɨpəg kəpiel kəmotəuag, kəni nətəmimi nətəm kotəhruahru tepət nətəm kəmohmɨs rəkɨs, kəmotəmiəgəh mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Kəmohiet e suvət mɨn, kəni uərisɨg Iesu təmanəmiəgəh mɨn e nɨmɨsiən, kəni ilah kəməhuvən əpəha Jerusɨləm mohiet=pən o nətəmimi tepət. ");
INSERT INTO tnp_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kəni iətəmi asoli rəha soldiə mɨn rəha nətəm Rom ilah rəhan soldiə mɨn nətəm kəmoteruh Iesu, kəmotafu nəmig mɨne natimnati mɨn əha. Kəni kəmotəgɨn pɨk, kəni motəni əfəməh məmə, “!Nɨpəhriəniən, inu Nətɨ Uhgɨn pəhriən!” ");
INSERT INTO tnp_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nɨpətan tepət kəmautəhtul isəu məutarfu. Ilah kəmotsɨpən ikɨn Kaləli mautohtəu=pən Iesu məutasiru lan e nati pɨsɨn pɨsɨn mɨn. ");
INSERT INTO tnp_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ilah mɨn nəuvein u Meri Maktələ, kəni Meri u mamə rəha Jemɨs mɨne Josɨs, kəni mamə rəha nətɨ Səpəti mil. ");
INSERT INTO tnp_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Iətəm Aramatiə u rəhan nautə tepət, nərgɨn u Josɨp, in iətəmimi kəti rəha Iesu. Nian tɨnətuva iuəkɨr o napinəpuiən, ");
INSERT INTO tnp_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","təmuvən meruh Pailət, kəni mətapuəh o nɨpətɨ Iesu, kəni Pailət təmegəhan e nɨpətɨ Iesu kəm in. ");
INSERT INTO tnp_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kəni Josɨp təmos nɨpətɨ Iesu muvən məuveg e napən ruən vi kəti, nərgɨn u linən, ");
INSERT INTO tnp_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","kəni mələs muvən mələhu=pən e suvət vi kəmol e nɨpəg kəpiel. Suvət u rəha Josɨp. Kəni mɨsuə=pən e kəpiel asoli kəti mahtɨpəsɨg e nɨpəg kəpiel lan, kəni matuvən. ");
INSERT INTO tnp_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meri Maktələ, mɨne Meri kəti mɨn kətuəharəg əha iuəkɨr o suvət. ");
INSERT INTO tnp_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nian əha, in nian katol əpenə-penə o Sapət lan, kəni kəməni lauɨg lan e Sapət, pris asoli mɨn mɨne Farəsi mɨn kəməhuvən moteruh Pailət. ");
INSERT INTO tnp_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Motəni=pən məmə, “Iətəmi asoli. Nɨkitɨmah tɨnəhti məmə, nian suah kəha, iətəmi rəha neiuəiən, təmətəmiəgəh əhanəh, mətəni məmə, ‘Nian kɨsɨl otuva muvən, kəni Uhgɨn otosmiəgəh mɨn iəu e nɨmɨsiən.’ ");
INSERT INTO tnp_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tol lanəha, ahli=pən rəham nəuvein soldiə okəhuvən məuteh nɨpəg kəpiel suvət motətəuarus=pən nian kɨsɨl tuva muvən. Məta rəhan mɨn okəhuva motakləh e nɨpətɨn, kəni motəni=pən kəm nətəmimi məmə təməmiəgəh mɨn e nɨmɨsiən. Kəni neiuəiən u, in otərah tapirəkɨs iətəm aupən.” ");
INSERT INTO tnp_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Kəni Pailət təməni=pən məmə “Otos soldiə mɨn, kəni məhuvən motol natimnati rəfin iətəm nəkotolkeikei məmə okotol e neh viviən suvət e nɨpəg kəpiel.” ");
INSERT INTO tnp_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kəni soldiə mɨn kəməhuvən mauteh vivi nɨpəg kəpiel, motələhu=pən nəmtətiən kəti e kəpiel. Kəni kəmotələhu soldiə mɨn məmə okauteh ikɨn əha. ");
INSERT INTO tnp_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","E Sante ləplapɨn agɨn, təmətian məsian viviən, Meri Maktələ mɨne Meri kəti mɨn kəmian məmə okuəsal=pən e suvət e nɨpəg kəpiel. ");
INSERT INTO tnp_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kəni əmeiko, nəmig asoli kəti təməlauəl mətəu-inu agelo kəti rəha Iərmənɨg təmsɨpəri e negəu e neai muvən e nɨpəg kəpiel, kəni mɨsuə rəkɨs e kəpiel, kəni mətəharəg-pəri lan. ");
INSERT INTO tnp_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","In tətasiə təhmen e noraipiən, kəni rəhan napən mɨn kotəruən təhmen e nəuaui nɨtəhi. ");
INSERT INTO tnp_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Soldiə mɨn kəmotəgɨn pɨk, kəni motərəmrumɨn, narmɨlah təmɨkə təhmen e nətəm kəmohmɨs. ");
INSERT INTO tnp_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kəni agelo təməni=pən kəm pəta mil məmə, “Suəgɨniən, mətəu-inu iəkəhrun məmə nətuəsal e Iesu iətəm kəmətu-pəri e nɨgi kəməluau. ");
INSERT INTO tnp_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tɨkə u ikɨn inu. In təməmiəgəh mɨn e nɨmɨsiən təhmen əmə e inu təməni mɨne aupən. Iəuva mueruh ikɨn təmətəməhli ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kəni ian uəhai, kəni muəni=pən kəm rəhan mɨn nətəmimi məmə, ‘In təməmiəgəh mɨn e nɨmɨsiən, kəni in tətaupən e təmah matuvən əpəha Kaləli. Kəni ikɨn əha, onəkoteruh in ikɨn.’ Intələh, rəhak u nəghatiən inəni kəm təlau.” ");
INSERT INTO tnp_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kəni pəta mil kəmuagɨm uəhai əmə e suvət e nɨpəg kəpiel, mətuəgɨn, mətəu nɨkilau tagiən, mətian məmə okuəni=pən kəm nətəmimi mɨn rəha Iesu. ");
INSERT INTO tnp_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kəni əmeiko, Iesu tiet pətɨgəm o lau, məni=pən kəm lau məmə, “Təuvɨr.” Kəni kəmiəuva o Iesu, muaskəlɨm nəhlkɨn, kəni muəfaki kəm in. ");
INSERT INTO tnp_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kəni Iesu təməni=pən kəm lau məmə, “Suəgɨniən. Ian muəni=pən kəm piak mɨn məmə okəhuvən Kaləli. Ikɨn əha okoteruh iəu ikɨn.” ");
INSERT INTO tnp_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nian pəta mil kəmualiuək mətian, kəni soldiə mɨn əha nəuvein kəməhuvən e taun, kəni motəni=pən kəm pris asoli mɨn natimnati rəfin iətəm kəmoteruh. ");
INSERT INTO tnp_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nian pris asoli mɨn kəməhuvən moteruh nətəmimi asoli rəha nətəm Isrel, kəni motol nəuə kəti motəlis nəghatiən lan. Kəni motəfən məni asoli kəm soldiə mɨn, ");
INSERT INTO tnp_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","motəni=pən kəm lah məmə, “Nəkotəni=pən kəm nətəmimi məmə, ‘Rəhan mɨn nətəmimi kəməhuva lapɨn nian itɨmah iəmotapɨli, motakləh e nɨpətɨn motələs motagɨm.’ ");
INSERT INTO tnp_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nəmə kəpmən otətəu nanusiən u, kəni itɨmah iəkəhuvən motəni nəghatiən kəti kəm in. Kəni itɨmah onəsotosiən nərahiən kəti lan.” ");
INSERT INTO tnp_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tol lanəha, soldiə mɨn kəmotos məni, kəni motol təhmen=pən əmə məmə kəməni mɨne kəm lah. Kəni nəghatiən eiuə u təmuvən mɨtəlau e nətəm Isrel muva mətəuarus=pa rəueiu. ");
INSERT INTO tnp_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kəni nətəmi lepɨn rəha Iesu kəməhuvən Kaləli, məhuvən e nɨtəuət iətəm Iesu təməni kəm lah məmə okəhuvən ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nian kəmoteruh in, kəni kəmotəfaki kəm in, mətəu nəuvein rəhalah nətəlɨgiən tatol keiu. ");
INSERT INTO tnp_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kəni Iesu tuva o lah, kəni məni=pən kəm lah məmə, “Nepətiən rəfin rəha negəu e neai mɨne nəhue nɨftəni o narmənɨgiən, Uhgɨn təməfa kəm iəu. ");
INSERT INTO tnp_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tol lanu, onəkəhuvən motiuvi nətəmimi e nəuanɨləuɨs mɨn rəfin e nɨtəni mɨn rəfin məmə okəhuva rəhak nətəmimi, kəni motol bəptais e lah e nərgɨ Tatə Uhgɨn, mɨne Nətɨn, mɨne Narmɨn, ");
INSERT INTO tnp_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","kəni motəgətun ilah məmə okotohtəu=pən rəfin nəghatiən mɨn iətəm iəməni kəm təmah. Kəni nɨpəhriəniən, iətatɨg kitah min itəmah nian mɨn rəfin mətəuarus naunun nian.” ");
INSERT INTO tnp_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Inu nətuəuiniən rəha Nanusiən Təuvɨr rəha Iesu Krɨsto, Nətɨ Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Iəni rəha Uhgɨn, nərgɨn u Aiseə təmətei lanu e nauəuə aupən. Uhgɨn təməni məmə, “Otafu-to. Iətahli=pɨnə iahləpis iətəm otos rəhak nəghatiən. In otaupən lam məmə otol əpenə-penə e rəham suaru.” ");
INSERT INTO tnp_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Iətəmimi u tətauɨn əpəha ikɨn təpiə-məpiə ikɨn mətəni məmə, ‘Itəmah, otol əpenə-penə e suaru rəha Iərmənɨg, kəni motol rəhan suaru təhruahru.’” ");
INSERT INTO tnp_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kəni iahləpis u in Jon Bəptais. Tol lanəha, təmiet=pa ikɨn təpiə-məpiə ikɨn matol bəptais e nətəmimi, kəni mətəni pətɨgəm nəghatiən rəha Uhgɨn kəm lah məmə okotəkeikei motəuhlin nəmtahlah o noliən tərah mɨn rəhalah, kəni məhuvən o Uhgɨn, məmə in otafəl noliən tərah mɨn rəhalah. Kəni nəmtətiən kəti o nati u, okol bəptais e lah. ");
INSERT INTO tnp_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nətəmimi tepət pɨk e nɨtəni Jutiə mɨne taun əha Jerusɨləm, kəməhuva motətəlɨg e rəhan nəghatiən, kəni motəni pətɨgəm rəhalah noliən tərah mɨn, kəni Jon təmol bəptais e lah əpəha e nəhu Jotən. ");
INSERT INTO tnp_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon təməsuvəniən e napən təuvɨr. Rəhan napən təhmen əmə e rəha iəni u Elaijə aupən. Rəhan napən kəmol e nɨmeimei kaməl, kəni rəhan kətəuti kəmol e nɨlosɨ kau, kəni matun əmə pitu mɨne nəhu sukəpak e nɨkinati. ");
INSERT INTO tnp_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kəni təməni pətɨgəm kəm nətəmimi məmə, “Iətəmi kəti u tatuərisɨg lak, rəhan nəsanəniən mɨne nepətiən tapirəkɨs iəu. Kəni iəu ləhtəni agɨn, iəsəhmen mɨniən məmə iəkeiuaiu mɨtɨs rəkɨs nɨləuɨs e rəhan put. ");
INSERT INTO tnp_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Iatol bəptais e təmah e nəhu, mətəu in otəpanol bəptais e təmah e Narmɨn Rəha Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","E nian əha, Iesu təmiet əpəha Nasərɨt, lahuənu kəti əpəha Kaləli muva. Kəni Jon təmol bəptais lan əpəha e nəhu Jotən. ");
INSERT INTO tnp_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nian Iesu təməri əpəha e nəhu, kəni məsal-pəri mafu negəu e neai təməuag, kəni Narmɨn Rəha Uhgɨn təmeiuaiu=pa ohni təhmen=pən e mak. ");
INSERT INTO tnp_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kəni nəuia Uhgɨn təmsɨpəri əpəha e negəu e neai mətəni lanu lan məmə, “Ik nətɨk keikei, iəkolkeikei pɨk ik, kəni nɨkik tagiən pɨk agɨn ohnik.” ");
INSERT INTO tnp_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kəni rəueiu agɨn mɨn, Narmɨn Rəha Uhgɨn təmiti=pən Iesu əpəha ikɨn təpiə-məpiə ikɨn, ");
INSERT INTO tnp_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ima nati rarpɨn mɨn. Təmatɨg ikɨn mos nian fote. E nian mɨn əha Setən tətəfən-əfən kəm in. Kəni nagelo mɨn kəmotasiru lan. ");
INSERT INTO tnp_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nian kɨnləfən rəkɨs Jon e kaləpus, Iesu təmuvən əpəha Kaləli mətəni pətɨgəm Nanusiən Təuvɨr rəha Uhgɨn kəm nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Təməni məmə, “!Nian tɨnuva əhruahru əha rəueiu! !Rəhan nian tɨnuva! !Nian rəha Narmənɨgiən Rəha Uhgɨn tɨnatuva iuəkɨr! !Otəuhlin nətəlɨgiən rəhatəmah, motəpəh pəhriən noliən tərah mɨn, kəni məhuvən o Uhgɨn, kəni motəhatətə e Nanusiən Təuvɨr!” ");
INSERT INTO tnp_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nian Iesu təmətaliuək e nɨkalɨ nəhu Lek Kaləli, kəni meruh suah mil keiu, rəha niuviən nəmu mɨn, nərgɨlau u Saimon mɨne pian Antɨru. Kətuatu e net. ");
INSERT INTO tnp_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Kəni Iesu təməni=pən kəm lau məmə, “Iəuva, muɨtəu=pa iəu, miəuva rəhak iətəmimi mil, kəni iəu iəkol itəlau nəkiəuva iətəmimi mil rəha niuviən nətəmimi məmə okəhuva rəhak mɨn nətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kəni əmeiko kuəpəh rəhalau net, kəni muɨtəu=pən. ");
INSERT INTO tnp_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kəni Iesu təmaliuək muvən təhmɨn mɨn nəuvetɨn, kəni meruh nətɨ Səpəti mil Jemɨs mɨne pian Jon kətuəharəg e rəhalau bot mətuəhli vivi rəhalau net. ");
INSERT INTO tnp_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kəni e nian əmə kəha inəha, Iesu təmauɨn e lau lan, kəni kuəhtul muəpəh rəhalau tatə Səpəti mɨne rəhan noluək mɨn kəutəharəg e nɨpəg nəua bot, kəni muɨtəu=pən Iesu. ");
INSERT INTO tnp_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kəni Iesu mɨne rəhan mɨn nətəmimi kəməhuvən əpəha lahuənu Kapeniəm. Kəni e nian rəha Sapət, Iesu təmuvən əpəha e nimə rəha nuhapumɨniən mətəgətun nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kəni nətəmimi kəmotətəu rəhan nəghatiən, narmɨlah təmiuvɨg pɨk ohni mətəu-inu rəhan nəghatiən təfɨgəm, nepətiən əha ikɨn, kəni mapirəkɨs rəha nəgətun mɨn rəha Lou. ");
INSERT INTO tnp_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kəni e nian əha, iətəmi kəti narmɨn tərah tətatɨg lan təmuva imə mətagət əfəməh məmə, ");
INSERT INTO tnp_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“!Ik Iesu iətəm Nasərɨt! ?Nəmuva məmə onəkəhro e tɨmah? !Nəmə təhro nəmuva məmə onəkərəkɨn itɨmah! Iəu inəhrun rəkɨs ik, ik Iətəmi Asim rəha Uhgɨn!” ");
INSERT INTO tnp_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Kəni mətəu Iesu təməni=pən əskasɨk kəm narmɨn tərah kəha məmə, “!Ah! Səghatiən, miet e suah u.” ");
INSERT INTO tnp_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kəni narmɨn tərah təmol nɨpətɨ suah kəha tərəmrumɨn, magət əfəməh miet lan. ");
INSERT INTO tnp_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kəni nətəmimi kəmotauɨt motəni=pən kəm lah mɨn məmə, “!Ei, nak u! Nəgətuniən vi kəti u. !Suah u tatos nəsanəniən o nəghatiən kəm narmɨn tərah mɨn, kəni kautətəlɨg lan mautol nəuian!” ");
INSERT INTO tnp_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kəni kəmanus ueiuəhai əmə Iesu, tuvən mapəkol əpəha e nɨtəni Kaləli. ");
INSERT INTO tnp_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nian Iesu mɨne Jemɨs, Jon, Saimon, mɨne Antɨru kəmohiet e nimə rəha nuhapumɨniən, kəni motaiu əhruahru məhuvən əpəha lahuənu ima Saimon mɨne Antɨru ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nian kəməhuvən, mətəu uhu Saimon tətətəpu-ətəpu, kəni mətapɨli pəri e rəhan pet, kəni kəmotəni=pən kəm Iesu məmə pətan əha tatɨmɨs. ");
INSERT INTO tnp_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Kəni Iesu təmuvən meapən o nəhlmɨn kəni masiru lan təhtul. Kəni nətəpu-ətəpuiən tagɨm lan. Kəni tuvən matol nɨglah nauəniən. ");
INSERT INTO tnp_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tɨnapinəpu mɨtɨgar tɨnatiuvɨg, nian rəha Sapət tɨnol naunun, kəni nətəmimi mɨn u kautohmɨs, mɨne nətəmimi narmɨn tərah tətatɨg e lah, pialah mɨn kəmotos ilah məhuva o Iesu. ");
INSERT INTO tnp_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nətəmimi rəfin e lahuənu əha kəməhuva motuhapumɨn əmə ilah mɨn əpəha e namtɨhluə e nimə əha rəha Saimon mɨne Antɨru. ");
INSERT INTO tnp_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kəni Iesu təmol vivi nətəmimi tepət u kautos nɨmɨsiən pɨsɨn pɨsɨn mɨn kotəuvɨr, kəni məhgi pətɨgəm narmɨn tərah tepət e nətəmimi, mətəu təməniəhu narmɨn tərah mɨn məmə okəsotəghatiən, mətəu-inu kɨnotəhrun rəkɨs məmə pəh u Iesu. ");
INSERT INTO tnp_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kəni ləplapɨn agɨn, fətukai təsəri əhanəhiən, Iesu təmiet muvən əpəha ikɨn nətəmimi kohkə ikɨn mətəfaki. ");
INSERT INTO tnp_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kəni Saimon mɨne in mɨn nəuvein kəməhuvən məutəsal lan. ");
INSERT INTO tnp_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nian kəmoteruh, kəni kəmotəni=pən kəm in məmə, “Nətəmimi rəfin kəutəsal lam.” ");
INSERT INTO tnp_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Mətəu Iesu təməni=pən kəm lah məmə, “Kəpə. Pəh kəhuvən əpəha e lahuənu pɨsɨn mɨn nəuvein, iəkanus pətɨgəm rəhak nəghatiən kəm nətəmimi mapəkol mətəu-inu, nati u inu iəmuva ohni məmə iəkol.” ");
INSERT INTO tnp_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kəni muvən mapəkol rəfin e nɨtəni əpəha Kaləli, mətanus pətɨgəm rəhan nəghatiən əpəha e nimə rəha nuhapumɨniən mɨn, kəni məhgi pətɨgəm narmɨn tərah mɨn e nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Suah kəti leprosi təmol, təmuva mɨsin=pən nəulɨn o Iesu mətasək=pən e nəuvɨriən ohni məmə, “Nəmə nəkolkeikei, kəni nəkəhrun nol viviən iəu kəni mafəl rəkɨs namɨkmɨkiən lak.” ");
INSERT INTO tnp_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kəni Iesu nɨkin təmahmə pɨk ohni, kəni təmuahru e nəhlmɨn mələhu=pən lan, məni məmə, “Əuəh. Iəkolkeikei. !Əuvɨr-tə!” ");
INSERT INTO tnp_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kəni rəueiu agɨn mɨn, nɨmɨsiən leprosi təmagɨm mɨkə lan, kəni nɨpətɨn təuvɨr, namɨkmɨkiən tɨkə. ");
INSERT INTO tnp_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Kəni Iesu təməni=pən əskasɨk kəm suah kəha məmə, “Nəsəni pətɨgəmiən natimnati mɨn u kəm nətəmimi, mətəu uvən əmə meh pris kəti pəh in teh məmə nɨpətɨm tɨnol lanu lan, kəni əfən kəm in nati u iətəm Lou rəha Mosɨs təməni o suah kəti iətəm rəhan leprosi tɨnɨkə, kəni nətəmimi okotəhrun məmə nɨpəhriəniən nɨnəuvɨr, kəni rəham namɨkmɨkiən tɨnɨkə.” Kəni mahli=pən tatuvən. ");
INSERT INTO tnp_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mətəu suah u təmuvən kəni məni pətɨgəm nati u kəm nətəmimi mɨn rəfin mol məmə Iesu təsuvəniən e lahuənu mɨn məghati mətəu-inu nɨmənin nətəmimi tepət pɨk kautəhtul pəsɨg lan. Kəni o nati əha inəha, təmətan ikɨn nətəmimi kohkə ikɨn. Kəni nətəmimi kotsɨpən ikɨn mɨn rəfin məutəhuva ohni. ");
INSERT INTO tnp_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nian nəuvein kɨnəhuva rəkɨs mɨnəhuvən, Iesu təmɨtəlɨg=pən mɨn əpəha Kapeniəm, kəni nəghatiən təmaiu muvən kəm nətəmimi mɨn məmə Iesu əpəha e rəhan nimə. ");
INSERT INTO tnp_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kəni nətəmimi tepət kəməhuva motəriauəh vivi əpəha imə, mɨne ihluə mɨne, kəni nəua nɨmahan kəti tɨkə o iətəmimi kəti mɨn. Kəni Iesu tətəni pətɨgəm rəhan nəghatiən kəm lah. ");
INSERT INTO tnp_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Kəni nətəmimi kuvət kəmotəlis pialah kəti məhuva o Iesu iətəm nɨpətɨn nəuvetɨn təmɨmɨs mətapɨli-pəri əmə e rəhan nɨmahan. ");
INSERT INTO tnp_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nian kəməhuva, mətəu nətəmimi nəri əpəha imə, kəni ko kəsəhuvəniən imə moteruh Iesu. Kəni kotələs məhuvən əpəha ilɨs e nəhue nimə motos rəkɨs nəhgɨ nimə nəuvetɨn əhruahru əmə əha Iesu tətəhtul ikɨn imə, kəni motəhlman-əhlman e iətəmi u teiuaiu e nɨmahan rəhan muvən iuəkɨr əmə o Iesu. ");
INSERT INTO tnp_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nian Iesu təmeruh nəhatətəiən rəhalah, kəni təni=pən kəm iətəm tatɨmɨs əha məmə, “Nətɨk, iəu inos rəkɨs rəkɨs noliən tərah rəham.” ");
INSERT INTO tnp_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mətəu nəgətun mɨn nəuvein rəha Lou kəutəharəg əpəha imə, kəni nɨkilah təməhti məmə, ");
INSERT INTO tnp_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“?Təhro suah u tətəni rah Uhgɨn? Nəghatiən əha tərah. Uhgɨn əmə təhrun nos rəkɨsiən noliən tərah rəha iətəmimi. !Pəh mɨn təhrun nos rəkɨsiən!” ");
INSERT INTO tnp_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kəni rəueiu agɨn mɨn, Iesu təhrun rəhalah nətəlɨgiən, kəni məni məmə, “?Təhro nɨkitəmah tətəhti pɨk natimnati mɨn lanu lan? ");
INSERT INTO tnp_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","?In pəhruvən tɨmətɨg, iətəm inu məmə iəkəni=pən kəm suah u məmə, ‘Inos rəkɨs rəkɨs rəham noliən tərah,’ uə inu tɨmətɨg məmə, ‘Əhtul, mələs rəham nɨmahan matuvən’? ");
INSERT INTO tnp_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Mətəu iəkol nati kəti məmə onəkotəhrun məmə iəu Nətɨ Iətəmimi, iatos nepətiən u ikɨnu e nəhue nɨftəni o nos rəkɨsiən noliən tərah rəha nətəmimi.” Kəni məni=pən kəm suah kəha məmə, ");
INSERT INTO tnp_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Iətəni=pɨnə kəm ik məmə, əhtul, mələs rəham nɨmahan matuvən imam ikɨn.” ");
INSERT INTO tnp_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Kəni əmeiko suah u təməhtul, mələs rəhan nɨmahan, maliuək matuvən, kəni ilah rəfin kəmoteruh, motauɨt, narmɨlah təmiuvɨg ohni, kəni motəni-vivi Uhgɨn motəni məmə, “Iəsoteh əhanəhiən nati kəti tol lanu lan nian kəti mɨne.” ");
INSERT INTO tnp_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesu təmuvən mɨn mətaliuək əpəha e nɨkalɨ nəhu Lek Kaləli, kəni nɨmənin nətəmimi kəməhuva ohni, kəni tətəgətun ilah. ");
INSERT INTO tnp_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kəni təmaliuək matuvən kəni meruh Lifai nətɨ Alfiəs, in iətəmimi rəha nosiən məni rəha takɨs, tətəharəg imə matol uək. Kəni Iesu təməni=pən kəm in məmə, “Ɨtəu=pa iəu, muva rəhak iətəmimi.” Kəni əmeiko təhtul muərisɨg lan. ");
INSERT INTO tnp_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kəni nian kəti, Iesu təmuvən mətauən əpəha ima Lifai ikɨn ilah nətəmimi rəha nosiən məni rəha takɨs, mɨne nətəmi kətəni məmə nol təfagə tərah nəuvein. Məutauən pəti ilah Iesu mɨne rəhan mɨn nətəmimi mətəu-inu nətəmimi tepət kotol təfagə tərah lanəha mautəhuərisɨg e Iesu. ");
INSERT INTO tnp_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Iəgətun mɨn nəuvein rəha Lou, ilah Farəsi mɨn. Kəni nəuvein kəmoteh məmə Iesu tətauən pəti əmə ilah nol təfagə mɨn əha, mɨne nətəmimi rəha nosiən məni rəha takɨs, kəni kotətapuəh o nətəmimi rəhan mɨn məmə, “?Təhro Iesu tətauən pəti əmə ilah nətəm kautol lanəha?” ");
INSERT INTO tnp_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kəni Iesu təmətəu rəhalah nəghatiən kəni təməni=pən kəm lah məmə, “Nətəmimi mɨn u kəsohmɨs-ohmɨsiən kəsəhuvəniən o toktə, mətəu nətəmimi mɨn u kautohmɨs-ohmɨs, toktə təkeikei muvən meruh ilah. Iəu iəməsuvaiən məmə iəkauɨn e nətəmimi mɨn u kotəni məmə kɨnotəhruahru rəkɨs. Mətəu iəmuva məmə iəkauɨn e nətəmimi mɨn u kotəhrun əmə məmə ilah kautol noliən tərah mɨn.” ");
INSERT INTO tnp_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Kəni e nian əha, nətəmimi mɨn rəha Jon Bəptais mɨne Farəsi mɨn kəmotəpəh nauəniən məutətuakəm o nəfakiən kəm Uhgɨn. Kəni nətəmimi nəuvein kəməhuva motəni=pən kəm Iesu məmə, “Afu-to, nətəmimi rəha Jon Bəptais mɨnə Farəsi mɨn kəutətuakəm o nəfakiən. ?Mətəu təhro rəham mɨn kəsotoliən lanəha?” ");
INSERT INTO tnp_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Kəni Iesu təməni=pən kəm lah məmə, “?Nian katol lafet lan rəha iətəm tatol marɨt, kəni iərman u otol marɨt tətatɨg əhanəh ilah in mɨn nəuvein mautol lafet, nɨkitəmah təhti məmə otətuakəm məpəh nauəniən? !Kəpə! Nian tətatɨg əhanəhiən ilah min, kəni nɨkilah tətagiən, məutauən əmə. ");
INSERT INTO tnp_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mətəu nian əpəha ikɨn məmə okəpanələs rəkɨs suah kəha lan, kəni e nian əha in əha, in mɨn nəuvein nɨkilah otahmə ohni, kəni kəpanotətuakəm motəpəh nauəniən lan.” ");
INSERT INTO tnp_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Kəni təmatɨg məni məmə, “Suah kəti mɨn ko təsəhli-pəniən nəuvetɨ napən vi kəti e napən əmnəmɨt iətəm təməhapu. Nəmə otəhli=pən, kəni napən vi u təhrun nəhapu asoliən napən əmnəmɨt u. ");
INSERT INTO tnp_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Iətəmi kəti mɨn ko təsiuvi-pəniən wain vi kəti e nɨlosɨ nati əuas kəti, mətəu-inu nəmə otiuvi=pən wain vi e nɨlosɨ nəni əuas iətəm təskasɨk, kəni wain otahlɨfu kəni nɨlosɨ nəni əuas u otasisi kəni məhapu, kəni wain mɨne nɨlosɨ nəni u okuərah. Mətəu wain vi okiuvi=pən əmə e nɨlosɨ nəni vi iətəm tɨmətmətɨg.” ");
INSERT INTO tnp_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","E nian kəti e Sapət, Iesu mɨne rəhan mɨn nətəmimi kəməutaliuək məutohapumɨn e nɨki nasumiən rəha wit, kəni nətəmimi mɨn rəha Iesu kəmotəhli wit məmə okotun. ");
INSERT INTO tnp_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kəni Farəsi mɨn u kəutaskəlɨm əskasɨk Lou rəha Mosɨs kəmotəni=pən kəm Iesu məmə, “!Ei, afu-to! E Sapət, kəsəuləkiən e nasumiən mɨne kəsoliən natimnati mɨn lanəha kotərəkɨn Lou. ?Təhro rəham mɨn nətəmimi kautol lanəha?” ");
INSERT INTO tnp_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Iesu təmuhalpɨn rəhalah nəghatiən məmə, “Nəmə təhro itəmah nəsotafin əhanəhiən nati u Tefɨt təmol aupən nian Apiətə in pris asoli agɨn rəha Uhgɨn. Itəmah nɨnotafin rəkɨs məmə Tefɨt nəumɨs təmus, kəni tuvən əpəha e Nima Tapolɨn rəha Uhgɨn, kəni mələs pɨret asim u pris mɨn əmə kautun, kəni in mələs muva mun ilah in mɨn nəuvein.” ");
INSERT INTO tnp_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kəni təmatɨg məni=pən mɨn kəm lah məmə, “!Kəməsoliən Sapət məmə in nati fɨgəm kəm nətəmimi, mətəu kəmol Sapət məmə otasiru e lah kotəmeig! ");
INSERT INTO tnp_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tol lanəha, iəu Nətɨ Iətəmimi iətarmənɨg rəfin e natimnati mɨn, kəni mətarmənɨg mɨn e Sapət.” ");
INSERT INTO tnp_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","E Sapət kəti mɨn, Iesu təmɨtəlɨg=pən mɨn əpəha e nimə rəha nuhapumɨniən kəni meruh suah kəti nəhlmɨn təmɨmɨs, təsuahruiən lan. ");
INSERT INTO tnp_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nian Iesu təmuvən imə, kəni nətəmimi nəuvein kəmauteruh vivi məmə otol vivi iətəmi u e Sapət, uə kəpə. Nəmə in tatol, kəni okotəni məmə in tətərəkɨn Lou rəha Sapət. ");
INSERT INTO tnp_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kəni Iesu təməni=pən kəm suah u məmə, “Əhtul muva u aupən,” kəni təhtul muvən əpəha aupən. ");
INSERT INTO tnp_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kəni Iesu təmahi ilah məmə, “Iəkolkeikei məmə iəkətapuəh nati kəti o təmah. ?Təhro? ?E nian rəha Sapət, noliən nak in təhruahru e Lou məmə okol, kəhrun noliən nati təuvɨr uə kəhrun noliən nati tərah? ?Okosmiəgəh iətəmi, uə okuhamu itəmi?” Mətəu kotəpnapɨn əmə. ");
INSERT INTO tnp_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kəni Iesu təməsal=pən meruh ilah, kəni niəməha tol, kəni nɨkin tahmə o lah mətəu-inu rəhn-kapə lah tiəkɨs pɨk. Kəni məni=pən kəm suah u məmə, “Uahru-to e nəhlməm.” Kəni suah u təmuahru e nəhlmɨn, əmeiko nəhlmɨn təuvɨr. ");
INSERT INTO tnp_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kəni Farəsi mɨn əha kəmohiet motaiu əhruahru əmə məhuvən moteruh rəhalah tɨkɨmɨr mɨn e pati rəha Herot, motol məhuva əmə kətiəh motəsal e suaru məmə okotələs Iesu motohamu. ");
INSERT INTO tnp_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesu mɨne rəhan mɨn nətəmimi kəmohiet moteiuaiu məhuvən əpəha e nəhu Lek Kaləli. Nɨmənin nətəmimi kəmautəhuərisɨg e lah. Nətəmimi mɨn u nəuvein kəmotsɨpən e lahuənu rəhalah e nɨtəni Kaləli, ");
INSERT INTO tnp_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","nəuvein kotsɨpən əpəha e lahuənu əlkələh mɨn e nɨtəni əpəha Jutiə; nəuvein kotsɨpən Jerusɨləm. Nəuvein mɨn kəmotsɨpən e nəuvetɨn mɨn əpəha nɨtəni Itumiə mɨne nəve nəhu Jotən e nɨtəni=pən matuvən. Nəuvein mɨn kəmotsɨpən pahav əpəha ikɨn mɨn e taun mil u Taea mɨne Saedon. Nətəmimi mɨn u kɨnotətəu rəkɨs natimnati mɨn u Iesu tatol ilah, kəni kəməhuva məmə okoteruh. ");
INSERT INTO tnp_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kəni nɨmənin nətəmimi kəməhuva pɨk, kəni Iesu təməni=pən kəm rəhan mɨn nətəmimi məmə okotol əpenə-penə e bot kəti məmə otuvən məharəg lan, məmə nɨmənin nətəmimi okəsotəhgi-əhgi pɨkiən in. ");
INSERT INTO tnp_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mətəu-inu tɨnol vivi rəkɨs nətəmimi tepət, kəni nətəmimi mɨn u kautohmɨs əhanəh kəutəhgi-əhgi ilah mɨn məmə okəhuva iuəkɨr motek Iesu. ");
INSERT INTO tnp_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kəni nian nətəmimi nətəm narmɨn tərah mɨn kəutatɨg e lah kəmotafu Iesu, kəmotaiu aupən lan motəmei=pən ohni motagət əfəməh məmə, “Ik Nətɨ Uhgɨn!” ");
INSERT INTO tnp_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mətəu Iesu təməniəhu əskasɨk narmɨn tərah mɨn u məmə kəsotəni pətɨgəmiən in kəm nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kəni Iesu mɨne kəməhuvən əpəha e nəhue nɨtəuət, kəni tətauɨn e nətəmimi nəuvein əmə okəhuva ohni. ");
INSERT INTO tnp_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nian kəməhuvən, kəni təmɨtəpɨn rəkɨs ilah tueləf kəni məfəri ilah məmə aposɨl mɨn. In təməni mɨn məmə nətəmimi mɨn əha, ilah əha okotaliuək ilah min, kəni in otahli rəkɨs ilah kəhuvən motəni pətɨgəm nanusiən təuvɨr kəm nətəmimi əpəha ikɨn mɨn, ");
INSERT INTO tnp_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","kəni okotos nepətiən mɨne nəsanəniən o nəhgi pətɨgəmiən narmɨn tərah mɨn e nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nətəmi mɨn u ilah u təmɨtəpɨn ilah, ilah u, Saimon u Iesu təmauɨn=pən mɨn nərgɨn kəti mɨn məmə Pitə, ");
INSERT INTO tnp_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","mɨne Jemɨs mɨne pian Jon nətɨ Səpəti mil u Iesu təməfən mɨn nərgɨlau notəhan məmə, “Poanejes,” nɨpətɨ nəghatiən əha təni məmə nətɨ kaluəluə mil, mətəu-inu niəməha tatol uəhai ilau. ");
INSERT INTO tnp_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","19","Kəni mɨne Antɨru, Fɨlɨp, Patolomiu, Matiu, Toməs, Jemɨs u nətɨ Alfiəs, Taitəs, Saimon u kətauɨn lan məmə, Selot, mɨne Jutəs Iskariot u otegəhan=pən e Iesu e nəhlmɨ tɨkɨmɨr mɨn. Nətəmi mɨn əha ilah kəha tueləf, Iesu təməfəri ilah. ");
INSERT INTO tnp_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Uərisɨg, təmɨtəlɨg=pən mɨn lahuənu, kəni nɨmənin nətəmimi kəməhuva mɨn ohni, kəni Iesu mɨne rəhan mɨn nətəmimi kɨnotəruru nəmeigiən mɨne nauəniən mɨne. ");
INSERT INTO tnp_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nian rəhan mamə mɨne kəmotətəu nəghatiən u kətəni e Iesu, kəni məhuva məmə okotit rəkɨs o nətəmimi, mətəu-inu nətəmimi nəuvein kəutəni məmə Iesu in nətalməli. ");
INSERT INTO tnp_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nəgətun mɨn nəuvein rəha Lou kəmotsɨpən əpəha Jerusɨləm məhuva kəni motəni məmə Pielsepul (nərgɨn kəti mɨn rəha Setən), u in iətəmi asoli rəha narmɨn tərah mɨn, in tətatɨg e Iesu, kəni motəni məmə in tətəfən nəsanəniən kəm Iesu məmə otəhgi pətɨgəm narmɨn tərah mɨn e nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kəni Iesu təmauɨn e lah kəhuva iuəkɨr ohni kəni məni nəghatiən əuhlin kəti kəm lah, məmə, “?Nɨkitəmah tətəhti məmə ko Setən təhgi pətɨgəm aru Setən? !Kəpə! ");
INSERT INTO tnp_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nəmə nətəmimi e kəntri kəti kəutəhapu ilah mɨn, kəni okotərəkɨn rəhalah kəntri, kəni narmənɨgiən rəhan otəmei mɨkə. ");
INSERT INTO tnp_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kəni təhmen=pən əmə, e lahuənu kəti, nəmə nətəmimi lan kəutəhapu ilah mɨn, kəni okotərəkɨn agɨn lahuənu u. ");
INSERT INTO tnp_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kəni nəmə Setən tətəhgi pətɨgəm narmɨn tərah mɨn rəhan e nətəmimi, kəni tatol aru əmə tɨkɨmɨr kəm in. ?Kəni otəhro lanu, rəhan narmənɨgiən otəhtul? Uək rəhan otəmei mɨkə. ");
INSERT INTO tnp_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Kəni ko iakləh kəti təsuvən əpnapɨniən e nimə rəha iətəmi kətəgɨn lan kəti, mə takləh e natimnati rəhan, mətəu otəkeikei məlis e nɨləuɨs, mələhu, kəni ko məpanuvən makləh e rəhan natimnati. ");
INSERT INTO tnp_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Iətəni pəhriən kəm təmah məmə təfagə tərah rəfin rəha nətəmimi, mɨne nəghatiən tərah mɨn iətəm ilah kautəni, Uhgɨn təhrun nos rəkɨsiən. ");
INSERT INTO tnp_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mətəu iətəmi tətəni rah Narmɨn Rəha Uhgɨn, ko Uhgɨn təsos rəkɨsiən rəhan təfagə tərah. Təfagə tərah əha otətatɨg kətiəh lan mətatɨg, ko təsɨkəiən.” ");
INSERT INTO tnp_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesu təməni lanəha mətəu-inu kəmotaupən motəni məmə narmɨn tərah kəti tətatɨg lan. ");
INSERT INTO tnp_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kəni e nian əha, mamə rəha Iesu mɨne pian mɨn kəməhuva, kəni mautəhtul əmə əpəha ihluə kəni motahli=pən nəghatiən o Iesu məmə tuva-to meh ilah. ");
INSERT INTO tnp_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Kəni nɨmənin nətəmimi kəmotəharəg kan kekəu e Iesu, kəni motəni=pən kəm Iesu məmə, “Ei, mamə rəham mɨne piam mɨn əpəha ihluə, kotolkeikei məmə okoteh-to ik.” ");
INSERT INTO tnp_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Kəni Iesu təməni=pən kəm lah məmə, “?Pəh u rəhak mamə mɨne piak mɨn?” ");
INSERT INTO tnp_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kəni məsal=pən meruh rəfin ilah kəni məni məmə, “Oteruh-to. Itəmah u piak mɨn mɨne rəhak mamə əhruahru mɨn. ");
INSERT INTO tnp_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nətəmimi mɨn u kautol nəuia Uhgɨn, ilah u piak mɨn, mɨne rəhak kakə mɨn, mɨne rəhak mamə.” ");
INSERT INTO tnp_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Kəni Iesu təmɨtəlɨg=pən mɨn əpəha e nəhu Lek Kaləli mətəgətun nətəmimi, mətəu nɨmənin nətəmimi kəməhuva ohni, motol məmə Iesu tuvən e bot. Kəni bot u tətəməhli=pən e lek, ipari əmə o nɨpəkɨl, kəni Iesu tətəharəg=pən lan. Kəni nɨmənin nətəmimi kəmotəharəg əpəha ipari e nɨkalɨ lek. ");
INSERT INTO tnp_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kəni Iesu təməghati e nəghatiən əuhlin kəm lah mətəgətun ilah e natimnati tepət. ");
INSERT INTO tnp_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Təməni=pən kəm lah məmə, “Otətəlɨg-to. Suah kəti təmuvən məmə otearəgrəg rəhan nɨkɨtɨ natimnati əpəha e rəhan nasumiən. ");
INSERT INTO tnp_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nian təmətearəgrəg rəhan nɨkɨtɨ natimnati, kəni nəuvein kotəmei=pən ikɨn kətaliuək ikɨn, kəni mənɨg mɨn kəhuva motun rəkɨs. ");
INSERT INTO tnp_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","“Kəni nɨkɨtɨ wit nəuvein kəmohmərəgrəg=pən e nɨftəni iətəm kəpiel iuəkɨr əmə. Kəmoteviə uəhai əmə mətəu-inu nɨftəni nəuan nəuvetɨn əmə. ");
INSERT INTO tnp_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nian mɨtɨgar təri, kəni məhgi ilah kotaukei-aukei mətəu-inu nokɨlah təseiuaiu pɨkiən. ");
INSERT INTO tnp_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","“Kəni nɨkɨtɨ wit nəuvein kəmotəmei=pən e nɨki nɨləuɨs u tol nihlɨn, kəni nian nɨkɨtɨ wit mɨn koteviə mətəu nɨləuɨs tətatu-atu ilah kəni kohmɨs məsotəuəiən. ");
INSERT INTO tnp_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","“Kəni nəuvein mɨn kəmotəmei=pən e nɨftəni təuvɨr, kəni moteviə vivi motol iahgin, kəni motəuə e nəualah, nəuvein nəualah tate, nəuvein nəualah sikɨste, nəuvein nəualah uan hanrɨt.” ");
INSERT INTO tnp_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kəni Iesu təmatɨg məni=pən mɨn kəm lah məmə, “Itəmah rəfin matəlgɨtəmah tatɨg, otətəlɨg vivi, kəni motəhrun nəghatiən mɨn u.” ");
INSERT INTO tnp_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nian Iesu pɨsɨn əmə mɨne rəhan nətəmimi tueləf mɨne nətəmimi nətəm kautəhuərisɨg lan, kəmotətapuəh ohni o nəghatiən əuhlin mɨn. ");
INSERT INTO tnp_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kəni Iesu təməni=pən kəm lah məmə, “Itəmah u, Uhgɨn tətəni=pɨnə nəghatiən oneuən rəhan kəm təmah məmə in tətuva məmə otarmənɨg e rəhan mɨn nətəmimi. Mətəu nətəmi mɨn u nanihluə mɨn, kəutətəu əmə nəghatiən rəha Uhgɨn e nəghatiən əuhlin. ");
INSERT INTO tnp_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Noliən u tol lanu lan məmə, ‘Kəutafu pau mətəu kəsotehiən, mautətəu pau, mətəu kəsotəhruniən, rəhn-kapə lah tiəkɨs, mətəu-inu ko kəsotolkeikei agɨniən məmə okotəuhlin ilah e rəhalah nətəlɨgiən motəpəh noliən təfagə tərah mɨn rəhalah, məmə Uhgɨn otos rəkɨs rəhalah təfagə tərah.’” ");
INSERT INTO tnp_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kəni Iesu təməni=pən kəm lah məmə, “?Nəmə təhro itəmah nəkotəruru əhanəh nəghatiən u? ?Onəkotəhra motəhrun mɨn nɨpətɨ nəghatiən pɨsɨn pɨsɨn mɨn rəfin? Otətəlɨg vivi-to məmə nəkotəhrun. ");
INSERT INTO tnp_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Nɨpətɨ nəghatiən əuhlin u məmə, nɨkɨtɨ natimnati əha tətəgətun=pən nəghatiən rəha Uhgɨn iətəm kətəni pətɨgəm kəm nətəmimi. Kəni nɨftəni tətəgətun=pən nɨki nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","“Nɨkɨtɨ natimnati u təməmei=pən e suaru tətəgətun=pən nətəmimi nəuvein nətəm kautətəu nəghatiən rəha Uhgɨn. Nian kəutətəu, mətəu Setən tuva mos rəkɨs uəhai əmə o lah. ");
INSERT INTO tnp_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","“Nɨkɨtɨ natimnati u tətəmei=pən e nɨki kəpiel nokɨlah təseiuaiu pɨkiən tətəgətun=pən nətəmimi nəuvein nətəm kəutətəu nəghatiən rəha Uhgɨn, mautos uəhai əmə e nagiəniən, mətəu təsatɨgiən tuvəh e nɨkilah. Nian kotatɨg rah, uə nətəmimi kautol tərah e lah o nəghatiən rəha Uhgɨn, kəni kəutəmei uəhai əmə e rəhalah nəmiəgəhiən. ");
INSERT INTO tnp_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Kəni nɨkɨtɨ natimnati u təməmei=pən e nɨki nɨləuɨs tətəgətun=pən nətəmimi nəuvein mɨn nətəm kautətəu nəghatiən rəha Uhgɨn, mətəu nian kautətəu, ");
INSERT INTO tnp_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","rəhalah nətəlɨgiən tatuvən pɨk o natimnati rəha nəhue nɨftəni, kəni nautə mɨne natimnati təuvɨr mɨn rəha nəhue nɨftəni kotiuvi rəkɨs rəhalah nətəlɨgiən, motatu-atu e nɨkilah, mol kotəpəou e noliən nəghatiən rəha Uhgɨn, kəni məsotəuəiən e nəualah təuvɨr e nəmiəgəhiən rəhalah. ");
INSERT INTO tnp_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Kəni nɨkɨtɨ natimnati u təməmei=pən e nɨftəni təuvɨr tətəgətun=pən nətəmimi nəuvein mɨn nətəm kautətəu nəghatiən rəha Uhgɨn, kəni mautos e nɨkilah pəhriən, kəni motəuə e nəualah təuvɨr e nəmiəgəhiən rəhalah, nəuvein tate, nəuvein sikɨste, kəni nəuvein uan-hanrɨt.” ");
INSERT INTO tnp_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kəni Iesu təməni=pən kəm lah məmə, “?Pəh tətasiəpən e lait kəni masuəpəpɨm lan e bəkɨt, uə tətəfən e nɨpəg pet? !Kəpə! Kəsoliən lan əha. Nian nəkotasiəpən e lait, kəni motələhu-pəri e tepɨl məmə nətəmimi okoteh nati lan. ");
INSERT INTO tnp_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nati kətəhtərain okəkeikei kauvɨs, kəni nati tətəhluaig otəkeikei miet=pa ikɨn təhagəhag ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Itəmah rəfin matəlgɨtəmah tatɨg, otətəlɨg vivi, kəni motəhrun nəghatiən mɨn u.” ");
INSERT INTO tnp_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kəni matɨg məni=pən mɨn kəm lah məmə, “Otətəlɨg vivi-to. Iətəmimi iətəm tətalkut məmə otəhrun rəhak nəghatiən, Uhgɨn otegəhan məmə otəhrun. Kəni otegəhan məmə in otəhrun pɨk. ");
INSERT INTO tnp_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tol lanəha mətəu-inu, iətəmi u iətəm rəhan əha ikɨn nəhruniən, kəni in tatɨtəu=pən molkeikei mɨn məmə otəhrun pɨk, kəni Uhgɨn otəfən mɨn nəhruniən kəm in, kəni rəhan nəhruniən otepət pɨk. Mətəu iətəmi u iətəm rəhan nəhruniən tɨkə məsolkeikeiən məmə otəhrun, Uhgɨn otos rəkɨs rəfin rəhan nəhruniən iətəm nɨkin təhti məmə in tatos.” ");
INSERT INTO tnp_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kəni Iesu təməni mɨn məmə, “Nəghatiən əuhlin u tətəgətun=pən Narmənɨgiən Rəha Uhgɨn. Iətəmi kəti təmɨsuv nɨkɨtɨ natimnati əpəha e rəhan nasumiən. ");
INSERT INTO tnp_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","28","Lapɨn mɨn tuvən mətapɨli, kəni e nərauiə mɨn tuvən maliuək mətan, kəni məsol mɨniən nati kəti lan mɨne, mətəu-inu nɨftəni əmə tətəfən neamtəiən kəm in məmə otəuə e nəuan. Mətəu nɨkɨtɨ nati u tɨneviə mɨnuva mɨnol iahgin, mətəu suah u təruru məmə təməhro lanu lan meviə. Kəni təməgeiət mol iahgin, kəni mol=pən nɨmalɨn, kəni məuə mətuvən matuvən, kəni mɨnɨməhtə. ");
INSERT INTO tnp_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kəni nian tɨnɨməhtə, e nian əmə kəha inəha, iətəmi əha tuvən mələs rəhan nisə muvən matətei rəkɨs mətəulək lan, mətəu-inu nian əhruahru rəhan tɨnuva.” ");
INSERT INTO tnp_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kəni Iesu təməni mɨn məmə, “Pəh iəkəni nəghatiən əuhlin kəti məmə otəgətun itəmah e Narmənɨgiən Rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nɨkɨtɨ mastət tətəgətun=pən Narmənɨgiən Rəha Uhgɨn. Mastət u in nɨgi kəti nɨkɨtɨn təkəku agɨn uəha. In təkəku e nɨkɨtɨ nɨgi mɨn rəfin. ");
INSERT INTO tnp_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mətəu nian kəmərfei, kəni teviə mol iahgin mapirəkɨs nɨgi mɨn iətəm katərfei e nasumiən, mol nəhlmɨn iahgin mɨn, kəni mənɨg ilɨs mɨn kəhuva motol=pən nimaalah e nɨkəmkəmɨn.” ");
INSERT INTO tnp_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iesu təmatəgətun lanəha nətəmimi e nəghatiən əuhlin tepət, mətəu təmatəni əmə təhmen o nəhruniən. ");
INSERT INTO tnp_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","In təmatəgətun əmə nətəmimi e nəghatiən əuhlin tepət. Mətəu nian kotan pɨsɨn əmə ilah rəhan mɨn nətəmimi, kəni tətəni pətɨgəm nɨpətɨ nəghatiən əuhlin kəm lah. ");
INSERT INTO tnp_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Tɨnəhnaiuv, kəni Iesu təməni=pən kəm rəhan mɨn nətəmimi məmə, “Pəh-to kəhuvən-to e nɨkalɨ lek e nɨtəni=pən.” ");
INSERT INTO tnp_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kəni kəmotəpəh nətəmimi, kəni rəhan mɨn nətəmimi kəməhuvən e bot mətəu Iesu tɨnuvən rəkɨs mətəharəg. Kəni kəmotələs Iesu e bot məhuvən ilah bot nəuvein mɨn kautəhuərisɨg e lah. ");
INSERT INTO tnp_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kəmautəhuvən əmeiko nɨmətagi asoli kəti nahgin təhmen e nəliu təmuva. Kəni peau-peau asoli mɨn kɨnəutorasɨlig=pən e nɨpəgnəua bot, kəni nəhu tɨnətəri=pən e bot, kəni bot tɨnatol o namnɨmiən. ");
INSERT INTO tnp_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Mətəu Iesu əpəha uərisɨg təmapɨli alu mətəsauə. Kəni rəhan mɨn nətəmimi kəmotaiu məhuva motəhgi-pəri, motəni məmə, “!Ei, Iəgətun! !Təhro nɨkim təsəhtiən itɨmah mɨne, iuəkɨr əmə iəkohmɨs!” ");
INSERT INTO tnp_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Kəni Iesu təmair məhtul mətəniəhu nɨmətagi mɨne nəhu məmə, “!Nəhmen! !Uəmeig-tə!” Kəni nɨmətagi təmohrahli nəhlmɨn, kəni peau-peau asoli mɨn əha kəmohkə, kəni təməməlinu asoli. ");
INSERT INTO tnp_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kəni Iesu təməni=pən kəm rəhan mɨn nətəmimi məmə, “?Təhro nəutəgɨn pɨk lanəha? Nəmə təhro rəhatəmah nəhatətəiən tɨkə əhanəh lak.” ");
INSERT INTO tnp_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Mətəu rəhan mɨn nətəmimi kɨnotəgɨn pɨk, kəni motəni=pən kəm lah mɨn məmə, “!Ei nəman! ?Iətəmimi nak u? Nati əpnapɨn nɨmətagi mɨne nəhu, mətəu ilau katuol nəuian.” ");
INSERT INTO tnp_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Iesu mɨne rəhan mɨn nətəmimi kəməhuvən məhuvari əpəha e nɨtəni=pən e nəhu Lek Kaləli, əpəha ima nətəm Kerasa. ");
INSERT INTO tnp_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nian Iesu təmeiuaiu e bot, kəni meruh suah kəti təmsɨpən əpəha e nɨpəg kəpiel mɨn, ikɨn katɨtənɨm nətəmimi ikɨn. Suah u narmɨn tərah tətatɨg lan. ");
INSERT INTO tnp_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Suah u tətatɨg əmə əpəha e suvət. Ko kəsaskəlɨmiən, kəni kəruru mɨn nəlisiən e nɨləuɨs uə sen. ");
INSERT INTO tnp_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nian tepət kotəlis nəhlmɨn mɨne nəhlkɨn mɨne e sen. Mətəu nian rəfin təteatuv-eatuv sen, kəni matohratuv-ohratuv sen e nəhlmɨn mɨne nəhlkɨn mɨne, kəni məsanən pɨk məsəhmeniən e iətəmi kəti məmə otaskəlɨm. ");
INSERT INTO tnp_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kəni lapɨn mɨne nərauiə mɨn mɨne nian rəfin, in tətan əpəha e suvət, mɨne əpəha e nɨtəuət mɨn, in pɨsɨn əmə, mətagət əfəməh, kəni matətei aru in e kəpiel asɨlə mɨn. ");
INSERT INTO tnp_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nian suah u təmafu Iesu əpəha isəu tətuva əhanəh, kəni təmaiu muvən meiuaiu mɨsin=pən nəulɨn ohni. ");
INSERT INTO tnp_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Iesu təni məmə, “!Ik narmɨn tərah, iet e suah u!” Mətəu narmɨn tərah kəha təmagət əfəməh məmə, “!Iesu, ik Nətɨ Uhgɨn Ilɨs! ?Nəmuva məmə onəkəhro lak? !Upəh əmə iəu! !Iatɨsiai ik e nərgɨ Uhgɨn məmə onəsoliən nalpɨniən kəm iəu!” ");
INSERT INTO tnp_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kəni Iesu təmətapuəh ohni məmə, “?Ik nərgəm pəh?” Mətəu təni məmə, “Nərgək u, Nɨmənin Tepət, mətəu-inu itɨmah tepət.” ");
INSERT INTO tnp_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kəni kəmotəni=pən əskasɨk kəm Iesu motɨsimaru motɨsimaru məmə otəsahli pətɨgəmiən ilah əha ikɨn əha. ");
INSERT INTO tnp_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ikɨn əha, pɨkəh mɨn tepət pɨk kəutahlu əpəha e nɨkalɨ nɨtəuət u. ");
INSERT INTO tnp_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kəni narmɨn tərah mɨn əha kəməutasək=pən o Iesu məmə, “Kəsi, ahli=pən-to itɨmah iəkəhuvən o pɨkəh mɨn əpəha, megəhan e tɨmah iəkəhuvən motatɨg əpəha e lah.” ");
INSERT INTO tnp_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kəni Iesu təmegəhan e lah məmə okəhuvən, kəni narmɨn tərah mɨn əpəha kəmohiet e suah kəha məhuvən əpəha e pɨkəh mɨn. Pɨkəh mɨn əha kotəhmen e tu-tausɨn. Kəni pɨkəh mɨn ilah rəfin kəmotaiu məuteiuaiu e nɨpatu, kəni motiuvɨg=pən e nəhu motamnɨm. ");
INSERT INTO tnp_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kəni nətəmimi nətəm kəutaugɨn pɨkəh mɨn u, kəmotaiu məhuvən motəni pətɨgəm nati u kəm nətəmimi mɨn əpəha e taun rəhalah, kəni motəni tuvən mapəkol əpəha lahuənu mɨn. Kəni nətəmimi tepət kəməhuva məmə okotafu-to nati u məmə kəməhro lanu. ");
INSERT INTO tnp_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nian kəməhuva o Iesu, kəni motafu suah u narmɨn tərah mɨn kəmautatɨg lan aupən, tɨnəpəh nalməliən kəni mɨnuvən e napən mətəharəg, kəni narmɨlah təmiuvɨg ohni kəni motəgɨn. ");
INSERT INTO tnp_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kəni nətəmimi mɨn u kəmoteh nati əhruahru e nəhmtɨlah, kəmotanus kəm ilah mɨn nəuvein nati u kəmoteh Iesu təmol e suah u mɨne pɨkəh mɨn. ");
INSERT INTO tnp_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Mətəu nətəmimi mɨn u e nɨtəni u kəmotəni=pən əskasɨk kəm Iesu məmə otatuvən məsatɨgiən əha imalah ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kəni nian Iesu tɨnɨtəlɨg=pən mɨn məmə otuvən e bot, mətəu suah u narmɨn tərah mɨn kəməutatɨg lan, təmolkeikei pɨk məmə otuvən ilah Iesu mɨne, kəni mətəni=pən kəm Iesu məmə, “Egəhan lak, pəh iəkuvnə kitah min itəmah.” ");
INSERT INTO tnp_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mətəu Iesu təməsegəhaniən, mətəu təməni=pən kəm in məmə, “Ɨtəlɨg=pən imam ikɨn, kəni manus kəm nətəmi imam ikɨn nati nak iətəm Uhgɨn ilɨs agɨn təmol kəm ik, kəni məmə in təmasəkəhruin ik.” ");
INSERT INTO tnp_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kəni təmuvən əpəha ikɨn Tekapolɨs mətəni pətɨgəm natimnati iətəm Iesu təmol kəm in. Kəni nian nətəmimi kəmotətəu, kəni kəmotauɨt pɨk ohni. ");
INSERT INTO tnp_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kəni Iesu mɨne kəməhuvən mɨn e bot mohtəlɨg=pən e nəve nɨtəni=pa e lek, mətəu nɨmənin nətəmimi kəməhuva ohni mohtəlau lan e nɨkalkalɨ lek. ");
INSERT INTO tnp_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kəni iətəmi kəti, nərgɨn u Jaerəs, in iətəmi asoli kəti rəha nimə rəha nuhapumɨniən, təmeruh Iesu kəni tuva mɨsin=pən nəulɨn ohni. ");
INSERT INTO tnp_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Kəni mətapuəh o Iesu mətəkeikei kəm in o nasiruiən məmə, “Nətɨk pətəkəku tatɨmɨs pɨk otəsuvəhiən tɨmɨs. !Pale, va-to kian nəkələhu=pən nəhlməm lan pəh təsanən” ");
INSERT INTO tnp_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kəni Iesu təmɨtəu=pən suah u mian, kəni nɨmənin nətəmimi tepət kəmohuərisɨg mohtəlau lan məutəhgi ilah mɨn. ");
INSERT INTO tnp_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kəni pətan kəti təmuva o Iesu iətəm tatos nɨmɨsiən rəhalah nɨpətan nian rəfin əmə, mɨnos nu tueləf. ");
INSERT INTO tnp_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Kəni təmuvən o toktə tepət, kəni mərəkɨn rəfin rəhan məni e lah, mətəu uək rəhalah kəmotol tətəu pɨk nahməiən. Mətəu rəhan nɨmɨsiən təməseiuaiuiən, nɨmɨsiən təməri nəuvetɨn mɨn. ");
INSERT INTO tnp_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","In təmos nəghatiən e Iesu, kəni nɨkin təməhti məmə, “Nəmə iəkek əmə rəhan nɨfɨfɨ napən, kəni rəhak nɨmɨsiən otol naunun.” Kəni tol lanəha, təmuva maliuək muərisɨg e lah, mɨsɨpən e nəmtah Iesu ikɨn, kəni meapən mek rəhan nɨfɨfɨ napən. ");
INSERT INTO tnp_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nian təmek nɨfɨfɨ napən rəha Iesu lanəha, kəni rəueiu agɨn mɨn rəhan nɨmɨsiən təməhtul, kəni təmətəu əmə e nɨpətɨn məmə in tɨnəuvɨr. ");
INSERT INTO tnp_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Kəni rəueiu agɨn mɨn əmə, Iesu təmətəu məmə nəsanəniən nəuvetɨn təmiet lan, kəni təmeirair mətapuəh məmə, “?Pəh təmek rəhak napən?” ");
INSERT INTO tnp_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Mətəu rəhan mɨn nətəmimi kotəni məmə, “Ei, afu-to. Nətəmimi kəutəhgi-əhgi rəkɨs pɨkɨn ik. ?Təhro nətəni lanko məmə ‘pəh təmek iəu’?” ");
INSERT INTO tnp_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mətəu Iesu təmətəsal məmə oteh-to məmə pəh təmek. ");
INSERT INTO tnp_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kəni əmeiko pətan u tɨnəhrun məmə nian in təmek napən rəha Iesu, rəhan nɨmɨsiən tɨnɨkə. Kəni tɨnəhrun məmə Iesu tətəsal lan. Tol lanəha, tɨnatəgɨn mətərəmrumɨn muva meiuaiu mɨsin=pən nəulɨn o Iesu mətəni=pən natimnati rəfin kəm in. ");
INSERT INTO tnp_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kəni Iesu təməni=pən kəm in məmə, “Nətɨk pətan, e rəham nəhatətəiən lak, nɨnuva mɨnəuvɨr. Kəni atuvən, pəh nəməlinuiən rəha Uhgɨn tətatɨg ohnik. Rəham nɨmɨsiən tɨnɨkə!” ");
INSERT INTO tnp_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nian Iesu təmətəghati əhanəh kəm pətan u, kəni nətəmimi nəuvein kəmotsɨpən əpəha ima Jaerəs ikɨn məhuva motəni=pən kəm Jaerəs məmə, “Nətɨm pətəkəku tɨnɨmɨs rəkɨs. Mə iəgətun təsuvaiən, məsoliən namuliən kəm in.” ");
INSERT INTO tnp_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mətəu Iesu təməsətəlɨgiən e rəhalah nəghatiən, kəni məni=pən kəm Jaerəs məmə, “Səgɨniən, məsoliən nɨkim tərah. Əhatətə əmə lak.” ");
INSERT INTO tnp_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kəni Iesu təməniəhu nətəmimi məmə okəsohuərisɨgiən e lau, kəni mit əmə Pitə mɨne Jemɨs mɨne pian Jon məhuvən. ");
INSERT INTO tnp_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kəni kəməhuvən əpəha ima Jaerəs ikɨn motafu nətəmimi tepət kəməhuva məutasək əuɨləuɨl. ");
INSERT INTO tnp_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Kəni Iesu təmuvən əpəha imə məni=pən kəm lah məmə, “?Nəutagət pɨk lanu o nak? ?Kəni məutasək pɨk o nak? Pətəkəku u təsɨmɨsiən, tətapɨli əmə.” ");
INSERT INTO tnp_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kəni nətəmimi kəmotaləh əuvsan lan. Mətəu Iesu tətahli pətɨgəm ilah məmə okohiet məhuvən əpəha ihluə. Kəni mit əmə rəhan iətəmimi milahal mɨne mamə mɨne tatə rəha pətəkəku u məhuvən əha tətapɨli ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kəni Iesu təmos nəhlmɨn, məni e rəhalah nəghatiən məmə, “Talitə kum.” Nɨpətɨ nəghatiən u təni məmə, “!Pətəkəku, iətəni=pɨnə kəm ik məmə onəkəhtul!” ");
INSERT INTO tnp_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kəni rəueiu mɨn əmə, pətəkəku əha təməhtul mɨnətaliuək. (Pətəkəku u tɨnos nu tueləf.) Nian kəmotafu nati u Iesu təmol, kəni narmɨlah təmiuvɨg pɨk ohni. ");
INSERT INTO tnp_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kəni Iesu təməni=pən əskasɨk kəm nətəmi mɨn u məmə, “Onəsotəni pətɨgəmiən nati u kəm iətəmi kəti.” Kəni matɨg məni=pən mɨn kəm lah məmə okotəfən nauəniən kəti kəm pətəkəku u tun. ");
INSERT INTO tnp_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesu təmiet ikɨn əha kəni rəhan mɨn nətəmimi kəməhuərisɨg lan məhuvən əpəha iman ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kəni e nian rəha Sapət, Iesu təmuvən əpəha e nimə rəha nuhapumɨniən mətəgətun nətəmimi. Kəni nətəmimi tepət nətəm kəmotətəu rəhan nəghatiən, kəmotauɨt pɨk ohni motəni məmə, “?Ei nəman, kəruru məmə suah əpəha təmos iə natimnati mɨn əpəha? ?Kəruru məmə təmos iə neinatɨgiən tol lanəha? ?Uə kəruru məmə təməhro lanəha matol nati apɨspɨs mɨn əpəha? ");
INSERT INTO tnp_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kitah kotəhrun əmə məmə suah kəha iol əmə nimə. In nətɨ Meri, pia Jemɨs, Josɨs, Jutəs mɨne Saimon. Kəni kitah rəhan mɨn kakə mɨn kəutan.” Kəni nɨkilah təsagiəniən ohni kəni motəuhlin nəmtahlah ohni. ");
INSERT INTO tnp_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Mətəu Iesu təni məmə, “Iəni rəha Uhgɨn kətɨsiai pɨk in ikɨn mɨn rəfin. Mətəu rəhan mɨn əmə, mɨne nətəmi iman ikɨn kəsotɨsiaiən.” ");
INSERT INTO tnp_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kəni ikɨn əha, ko təsoliən nati apɨspɨs kəti ikɨn, mətəu təmələhu=pən əmə nəhlmɨn e nətəm kautohmɨs nəuvein, kəni kotəmiəgəh mɨn. ");
INSERT INTO tnp_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kəni Iesu narmɨn təmiuvɨg pɨk o nətəm iman ikɨn mətəu-inu kəsotolkeikeiən məmə okotəni nɨpəhriəniən lan. Kəni təmaliuək muvən lahuənu mɨn rəfin, mətəgətun nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kəni matɨg mauɨn mɨn e rəhan tueləf nətəmimi kəhuva ohni, kəni mahli=pən ilah keiu-keiu. Təməfən nəsanəniən kəm lah o nəhgi pətɨgəmiən narmɨn tərah mɨn e nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Kəni məni=pən nəghatiən u kəm lah məmə, “Onəsotosiən nati kəti e rəhatəmah naliuəkiən, mətəu onəkotos əmə kasɨkɨn rəhatəmah. Onəsotosiən məni kəti e pauɨs rəhatəmah, kəni məsotosiən pɨret, uə kətɨm, uə nati kəti. ");
INSERT INTO tnp_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Onəkəhuvən e put, mətəu onəsotosiən sot keiu. ");
INSERT INTO tnp_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nəmə onəkəhuvən əpəha ima iətəmi kəti ikɨn, kəni otapɨli əmə e rəhan nimə motatɨg motətəuarus mohiet lahuənu əha. ");
INSERT INTO tnp_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kəni nəmə onəkəhuvən e lahuənu kəti, mətəu nətəmimi nəuvein kəsotolkeikeiən məmə okotit itəmah nəkəhuvən e rəhalah nɨpəgnəua nimə, uə okəsotətəlɨgiən e rəhatəmah nəghatiən, kəni nian nautohiet e rəhalah lahuənu, nəkotəkeikei motohrapɨspɨs rəkɨs nɨməulul e nəhlkɨtəmah məmə ilah okotəhrun məmə nəmotəuhlin=pən pəhriən nəmtahtəmah o lah motəpəh agɨn ilah.” ");
INSERT INTO tnp_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kəni kəmohiet məhuvən motəni=pən kəm nətəmimi məmə okotəuhlin nətəlɨgiən rəhalah, motəpəh pəhriən noliən tərah mɨn, kəni məhuvən o Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kəni motəhgi pətɨgəm narmɨn tərah mɨn tepət e nətəmimi, kəni motol=pən oiel e nətəmimi mɨn u kautohmɨs, kəni motol vivi ilah. ");
INSERT INTO tnp_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kəni Kig Herot Antipas təmətəu nəghatiən rəha Iesu tɨnuvən mɨnapəkol e nɨtəni mɨn rəfin. Kəni nətəmimi nəuvein kotəni məmə in Jon Bəptais əpə tɨnair=pa mɨn mol tatos nəsanəniən o noliən nati apɨspɨs mɨn. ");
INSERT INTO tnp_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mətəu nətəmimi nəuvein mɨn kotəni məmə in Elaijə, nəuvein mɨn kotəni məmə in iəni kəti rəha Uhgɨn mətəu təhmen e iəni mɨn rəha Uhgɨn aupən. ");
INSERT INTO tnp_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mətəu Kig Herot Antipas təmətəu, kəni məni məmə, “!Jon Bəptais əpəha! Iəməuahtuv rəkɨs rəhn-kapə, mətəu tɨnəmiəgəh mɨn.” ");
INSERT INTO tnp_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Kig Herot Antipas təməni lanəha mətəu-inu in təmol nati kəti təsəhmeniən. Pian Fɨlɨp təmatit pətan kəti nərgɨn u Herotiəs muol marɨt, kəni Kig Herot Antipas titirəkɨs pətan u ohni muol mɨn marɨt. Kəni Jon təmətəni=pən kəm in məmə, “Nətatgəhli Lou. Təsəhmeniən məmə onəkit pətan rəha piam.” Kəni Herotiəs təmətəu nəghatiən u kəni mətəməki e Jon ohni, kəni molkeikei məmə okohamu, mətəu kəpə, Kig Herot təsegəhaniən. Mətəu təmolkeikei məmə otol rəhan pətauəhli nɨkin tagiən, kəni mahli=pən rəhan mɨn nətəmimi kəhuvən motaskəlɨm Jon motəlis-ərain, kəni motələs məhuvən motləfən e kaləpus. ");
INSERT INTO tnp_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Mətəu Kig Herot Antipas tatɨsiai Jon məhrun məmə in iətəmi asim, kəni in iətəmi əhruahru kəti mol tateh vivi kəni məsohamuiən. Nian tepət tətəu nəghatiən rəha Jon, kəni tɨnəruru əfəməh, mətəu tolkeikei məmə otətəlɨg lan. ");
INSERT INTO tnp_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Matuvən matuvən Herotiəs tɨnos rəhn maru Jon e nian kəmatol lafet lan rəha Kig Herot Antipas e nian təmair lan. Kig təmauɨn ərəfin e nətəmi asoli rəhan mɨn, mɨne nətəmi asoli rəha rəhan soldiə mɨn, mɨne nətəmi asoli rəha nətəm Kaləli, məmə okəhuva moteh motauən. ");
INSERT INTO tnp_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kəni e nian əha, pətan mɨtə u nətɨ Herotiəs təmuva imə matol danɨs e nəhmtɨlah. Kəmoteruh təmol danɨs kəni nɨkilah təmagiən pɨk ohni. Kəni kig əha təməni=pən kəm pətan mɨtə əha məmə, “Nəmə nəkolkeikei nak, nəkətapuəh lan ohniəu, kəni iəkəfɨnə kəm ik.” ");
INSERT INTO tnp_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","In təməni əskasɨk kəni mos nonauvɨl ohni məmə, “Nati nak nəkolkeikei kəni nəkeasiə lan ohniəu, iəkəfɨnə. Nati əpnapɨn nəmə iahgin təhmen e nɨpɨlga rəhak natimnati, mətəu iəkəkeikei məfɨnə.” ");
INSERT INTO tnp_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kəni pətan mɨtə əha təmuvən əpəha ihluə mətapuəh o rəhan mamə məmə, “?Mamə, oiəkeasiə o nak e kig?” Mətəu rəhan mamə təni məmə, “Uvən measiə o rəhn-kapə Jon Bəptais.” ");
INSERT INTO tnp_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kəni pətan mɨtə əha təmaiu ueiuəhai əmə muvən əpəha imə o kig kəni məni məmə, “Iəkolkeikei rəhn-kapə Jon Bəptais u rəueiu əmə, kələhu=pən e pɨlet kəti.” ");
INSERT INTO tnp_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kəni nati u təmol kig nɨkin təpəou pɨk, mətəu ko təsəpəhiən, mətəu-inu təmos rəkɨs nonauvɨl e nəhmtɨ nətəmimi u kəməhuva o lafet. ");
INSERT INTO tnp_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kəni mahli=pən rəhan kəti soldiə məmə otaiu əmə muvən mələs rəhn-kapə Jon Bəptais muva. Kəni soldiə əha təmuvən əpəha e kaləpus, kəni mohatuv rəhn-kapə Jon Bəptais, ");
INSERT INTO tnp_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","kəni mələhu=pən e pɨlet kəti mələs muva, kəni məfən kəm pətan mɨtə kəha, kəni tələs muvən kəm rəhan mamə. ");
INSERT INTO tnp_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nian nətəmimi mɨn rəha Jon Bəptais kəmotətəu nətəmimi kəmotanus nati u kəmol e Jon, kəni kəməhuvən motələs nɨpətɨn məhuvən mohtənɨm e nɨpəg kəpiel kəti. ");
INSERT INTO tnp_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Kəni aposɨl mɨn rəha Iesu kəmohtəlɨg=pa mɨn ohni, kəni motəni=pən natimnati rəfin iətəm kəmotol, mɨne nəghatiən mɨn iətəm kəmotəgətun nətəmimi lan. ");
INSERT INTO tnp_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mətəu nətəmimi tepət kəutəhuva mautəhuvən, kəni Iesu mɨne rəhan mɨn nətəmimi kɨnotəruru nauəniən mɨne nəmeigiən mɨne. Kəni Iesu təni=pən kəm lah məmə, “Pəh-to kəhuvən-to əpəha ikɨn kəti nətəmimi kohkə ikɨn, kəni nəkotəmeig nəuvetɨn.” ");
INSERT INTO tnp_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kəni ilah əmə məhuvən e bot kəti mɨnautəhuvən əpəha ikɨn nətəmimi kohkə ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mətəu nətəmimi tepət kəmotafu ilah nian kəmohiet, kəni motəhrun ilah. Kəni kəmohiet e lahuənu mɨn motaiu motaupən e lah, məhuvən əpəha kautəhuvən ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nian Iesu təmuvari e bot mafu nɨmənin nətəmimi tepət kəməhuva rəkɨs, kəni nɨkin təmepət pɨk o lah, mətəu-inu kotəhmen əmə e sipsip mɨn nətəm iətəmimi tɨkə o neruh viviən ilah. Kəni təməhtul mətəgətun ilah e natimnati tepət. ");
INSERT INTO tnp_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kəni mətəuarus tɨnəhnaiuv, kəni nətəmimi rəha Iesu kəməhuva motəni=pən kəm in məmə, “Napinəpu, kəni ikɨnu ikɨn nətəmimi kohkə ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Təuvɨr məmə onəkahli=pən-tə nətəmimi kautəhuvən e lahuənu mɨn, mɨne əpəha ikɨn mɨn, məmə okotos nəhmtɨ nɨglah nauəniən.” ");
INSERT INTO tnp_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mətəu in təməni=pən kəm lah məmə, “Kəpə, itəmah əmə. Nəkotaugɨn nətəmimi mɨn əha.” Mətəu kotəni məmə, “!Nak! ?Nəkəmə oiəkəhuvən motəraki e məni asoli agɨn u tu-hanrɨt tənariəs o nosiən pɨret lan u o naugɨniən nɨmənin nətəmimi u?” ");
INSERT INTO tnp_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Mətəu Iesu təni məmə, “?Nautos pɨret kuvəh? Əhuvən-to moteh-to.” Kəməhuvən moteh məmə, “Pɨret faif, kəni nəmu keiu.” ");
INSERT INTO tnp_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kəni Iesu təni=pən kəm rəhan mɨn nətəmimi məmə okotol nətəmimi kotəharəg e nɨmanuvehli fifti-fifti mɨne uan-hanrɨt-uan-hanrɨt, ");
INSERT INTO tnp_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","kəni kəmotəharəg lanəha fifti-fifti mɨne uan-hanrɨt-uan-hanrɨt. ");
INSERT INTO tnp_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kəni Iesu təmos pɨret faif mɨne nəmu mil u keiu, kəni məsal-pəri əpəha e neai məfaki=pən lan, kəni məhapu pɨret u məfən kəm rəhan mɨn nətəmimi məmə okotəuəri e nətəmimi. Kəni matɨg mos mɨn nəmu mil u keiu məhapu məuəri kəm nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kəni nətəmimi rəfin kəmotauən nərfɨlah tasisi, ");
INSERT INTO tnp_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","kəni motəpəh nɨpɨspɨsɨ pɨret u mɨne nəmu mil u, kəni nətəmimi mɨn rəha Iesu kəmotaipei=pən e kətɨm asoli tueləf kotəri vivi. ");
INSERT INTO tnp_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Kəni nətəmimi mɨn u kəmotauən, nəman e lah kotəhmen e faif-tausɨn. ");
INSERT INTO tnp_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kəni rəueiu agɨn mɨn, Iesu təməni=pən kəm rəhan mɨn nətəmimi məmə okotələs bot kəti motaupən məhuvən e nəve nɨtəni=pən əpəha ikɨn kəti nərgɨn u Petsaitə, mətəu in otatɨg mahli=pən pɨpɨm nətəmimi kautəhuvən imalah mɨn ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nian tɨnauiəhruin rəkɨs nətəmimi, mahli=pən ilah kautəhuvən, kəni muvən əpəha e nɨtəuət məmə otəfaki. ");
INSERT INTO tnp_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kəni tɨnapinəpu, bot tɨnuvən əpəha e nəlugɨn əhruahru əpəha e lek, mətəu Iesu tətan pɨsɨn əmə əpəha ipari. ");
INSERT INTO tnp_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kəni mafu ilah kəutasuə məutasuə mətəu kɨnotəpəou mətəu-inu nɨmətagi tatoh ilah. Kəni lapɨn iuəkɨr o nianiən, kəni taliuək e nəhue nəhu mətuva. Təmaliuək muva, məmə otapirəkɨs ilah. ");
INSERT INTO tnp_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Kəni nian nətəmimi mɨn rəha Iesu kəmotafu tətaliuək e nəhue nəhu mətuva, kəni nɨkilah təhti məmə narmɨ iətəmi kəti. Kəni ilah rəfin kəmoteruh, kəni motəgɨn məutearəg əfəməh. Mətəu rəueiu agɨn əmə, Iesu təməni=pən kəm lah məmə, “!Ei, nɨkitəmah təhtul məha-məha. Iəu əmə u. Sotəgɨniən!” ");
INSERT INTO tnp_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kəni məri e bot ilah min ilah, kəni nɨmətagi təmeiuaiu, kəni kəmotauɨt pɨk ohni, ");
INSERT INTO tnp_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","mətəu-inu rəhn-kapə lah tiəkɨs. Kəmotafu pau Iesu təmaugɨn nətəmimi tepət e pɨret nəuan nəuvetɨn əmə, mətəu ilah kotəruru əhanəh məmə in pəh. ");
INSERT INTO tnp_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kəməhuvən e nəve nɨtəni=pən məhuvari əpəha ikɨn kəti nərgɨn u Kenesəret, kəni motiuvi-ərain bot ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nian kəməhuvari ikɨn əha, nətəmimi mɨn ikɨn kəmotəhrun uəhai əmə məmə in Iesu. ");
INSERT INTO tnp_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kəni kəmotaiu məhuvən əpəha lahuənu mɨn mautəni=pən kəm nətəmimi. Kəni nian kotətəu məmə Iesu əha ikɨn əha, kotəmki nətəm kautohmɨs e rəhalah mɨn pet məhuva ohni. ");
INSERT INTO tnp_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kəni ikɨn mɨn rəfin Iesu tatuvən=pən ikɨn e lahuənu əlkələh mɨn, mɨne lahuənu asoli mɨn, mɨne ikɨn mɨn rəfin tɨtəlau, nətəmimi kotəmki nətəm kautohmɨs mohiet motəlɨn əmə ilah əpəha e makɨt ikɨn. Kəni kəmotəkeikei məutəni=pən kəm Iesu məmə otegəhan e lah kotek əmə nɨfɨfɨ napən rəhan. Kəni nətəmimi rəfin u kəmotek rəhan kot kəmotəuvɨr e rəhalah nɨmɨsiən. ");
INSERT INTO tnp_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Kəni Farəsi nəuvein mɨne nəgətun nəuvein rəha Lou, kəmotsɨpən əha Jerusɨləm, məutəharəg ilah Iesu. ");
INSERT INTO tnp_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Kəni kəmotafu məmə nətəmimi mɨn rəha Iesu nəhlmɨlah tamɨkmɨk kəni məsoteikuasiən e noliən rəha Farəsi mɨn, kəni motauən. ");
INSERT INTO tnp_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farəsi mɨn, mɨne nətəm Isrel tepət, kəmautohtəu=pən əhruahru kastɨm rəha tɨpɨlah nuvəh mɨn. Kəutəkeikei moteikuas e nəhlmɨlah e noliən kəti, kəni uərisɨg lan, kotəhrun nauəniən. ");
INSERT INTO tnp_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kəni nian kotsɨpən e makɨt məhuva, məsotauən pɨpɨmiən, motaupən moteikuas e nəhlmɨlah, uərisɨg kəmanotauən. Kəni mautohtəu=pən natimnati tepət mɨn lanəha iətəm kəmotos o tɨpɨlah nuvəh mɨn. Kəni kastɨm əhruahru əha ikɨn rəha neikuasiən e sospən, mɨne kap, mɨne pesɨn u kəmol e aiən. ");
INSERT INTO tnp_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kəni inu Farəsi mɨn mɨne nəgətun mɨn rəha Lou kotətapuəh o Iesu məmə, “!?Təhro rəham mɨn nətəmimi kəsotohtəu-pəniən kastɨm rəha tɨpɨtah nuvəh mɨn!? !?Təhro kəsoteikuasiən e nəhlmɨlah ko məpanotauən, kəni mautol lanəha!?” ");
INSERT INTO tnp_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mətəu Iesu təməni=pən kəm lah məmə, “Aupən Aiseə təməni pəhriən nian təməni pətɨgəm əhruahru nəghatiən rəha Uhgɨn mətəni e təmah məmə itəmah nəfaki eiuə mɨn. In təməni məmə, ‘Uhgɨn təni məmə nətəmimi mɨn u kautɨsiai iəu e nəghatiən əmə rəhalah, mətəu nɨkilah tətan=pən əpəha isəu. ");
INSERT INTO tnp_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Məutəfaki kəm iəu o nati əpnapɨn əmə, mətəu-inu ilah kəutəgətun nətəmimi e lou iətəm iətəmimi əmə təmol məutəni məmə lou rəha Uhgɨn, mətəu kəpə.’” ");
INSERT INTO tnp_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kəni Iesu təməni mɨn kəm lah məmə, “Itəmah nəutəpəh Lou rəha Uhgɨn mautohtəu=pən əmə kastɨm rəha iətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kəni məni=pən kəm lah məmə, “Nəutəfəri pɨk o noliən əpətu rəhatəmah məmə nəkotəpəh Lou rəha Uhgɨn kəni məutohtəu=pən aru əmə kastɨm rəhatəmah. ");
INSERT INTO tnp_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosɨs təməni məmə, ‘Onəkɨsiai rəham tatə mɨne mamə. Nəmə iətəmi kəti tətəghati rah e rəhan tatə mɨne mamə, okəkeikei kohamu.’ ");
INSERT INTO tnp_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mətəu itəmah nəkotəni məmə, iətəmi kəti nəmə təpəh nasiruiən e rəhan tatə mɨne rəhan mamə kəni məni=pən kəm lau məmə, ‘Rəhak u nati u iəkəmə iəkasiru e təlau lan, mətəu iəmələhu əmə məmə rəha Uhgɨn. Kəni nati kətəfən kəm Uhgɨn ko kəsoliən nati kəti lan.’ ");
INSERT INTO tnp_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","“Kəni kastɨm rəhatəmah tətegəhan məmə suah kəti təhrun nəpəhiən nasiruiən e rəhan tatə mɨne rəhan mamə e noliən əha. Kəni inu təsɨsiaiən ilau. ");
INSERT INTO tnp_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mətəu e noliən əha, nəutəgətun nətəmimi e rəhatəmah kastɨm məmə in nati agɨn, kəni motol nəghatiən rəha Uhgɨn tatol əmə nati əpnapɨn lan. Kəni natimnati mɨn tepət mɨn lanəha itəmah nautol.” ");
INSERT INTO tnp_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kəni Iesu təmauɨn e nɨmənin nətəmimi məmə okəhuva iuəkɨr ohni kəni təni=pən kəm lah məmə, “Otətəlɨg vivi-to lak məmə nəkotəhrun noliən rəha nauəniən mɨne neikuasiən. ");
INSERT INTO tnp_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nati iətəmimi tatun təsoliən iətəmimi tamɨkmɨk e nəhmtɨ Uhgɨn, mətəu nati tatsɨpən e nɨki iətəmimi tatol iətəmimi tətamɨkmɨk e nəhmtɨ Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nian Iesu təmiet rəkɨs e nɨmənin nətəmimi u, kəni muvən əpəha imə, kəni rəhan mɨn nətəmimi kotətapuəh o nɨpətɨ nəghatiən mɨn u kəm in. ");
INSERT INTO tnp_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Kəni Iesu təməni=pən kəm lah məmə, “Nəmə təhro itəmah mɨn rəhn-kapə təmah tɨkə. Onəkotəkeikei motəhrun məmə natimnati iətəm iətəmimi tatun in təhmen əmə e nati ihluə təsoliən iətəmimi tətərah e nəhmtɨ Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mətəu-inu tun kəni təsuvəniən e nɨkin, mətəu tatuvən e nɨsɨgan, kəni matiet mɨn.” (E nəghatiən əha Iesu təməni pətɨgəm məmə nauəniən rəfin katun təuvɨr e nəhmtɨ Uhgɨn.) ");
INSERT INTO tnp_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kəni təni məmə, “Mətəu nati iətəm tatiet e nɨki iətəmimi, in tol iətəmimi tətamɨkmɨk e nəhmtɨ Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Mətəu-inu nɨki iətəmimi tətəhti natimnati tərah tepət, kəni nətəmimi kautol noliən tərah mɨn u: nɨpətan mɨne nəman mɨne, kautit oneuən ilah mɨn; kəutakləh; kautohamu iətəmi; ");
INSERT INTO tnp_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kəutakləh e pətan rəha iətəmi pɨsɨn; kəutaumɨs pɨk o natimnati; kautol təfagə tərah mɨn; kəuteiuə; kautit əpnapɨn əmə nɨpətan mɨne nəman; kautetet; kəutəni nɨkalɨ iətəmi; kəutəfəri ilah; kəutalməli. ");
INSERT INTO tnp_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Noliən tərah mɨn əha, ilah kəha kautsɨpən e nɨki nətəmimi kəni mautol ilah kotamɨkmɨk e nəhmtɨ Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","26","Kəni Iesu təmiet u ikɨnu kəni məsəu-pahav muvən əpəha Fonisiə, ima Nanihluə mɨn e nɨtəni rəha Sɨriə, mətatɨg e nimə kəti iuəkɨr o taun u Taea, mətəhluaig məsolkeikeiən məmə nətəmimi okotəhrun məmə in tətatɨg əha ikɨn əha, mətəu ko təsəhluaigiən. Mətəu pətan kəti əha ikɨn, narmɨn tərah tətatɨg e rəhan pətəkəku. Pətan u təmair ikɨn əha, kəni in təsəfakiən, in Ianihluə. (Nətəm Isrel kotəni məmə Nanihluə mɨn kotəhmen e kuri.) Nian təmətəu natimnati təuvɨr mɨn iətəm Iesu tatol ilah, kəni tasək muva mɨsin=pən nəulɨn ohni məmə otəhgi pətɨgəm narmɨn tərah e rəhan pətəkəku. ");
INSERT INTO tnp_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Mətəu Iesu təni məmə, “Kəpə. Pəh kotaupən motaugɨn kəlkələh mɨn. Təsəuvɨriən məmə okəraki=pən e nauəniən nɨg kəlkələh mɨn kəm ‘kuri mɨn.’” ");
INSERT INTO tnp_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mətəu pətan u təni məmə, “Nɨpəhriəniən iətəmi asoli, mətəu nati əpnapɨn kuri mɨn, mətəu kegəhan məmə ilah kautun nɨpɨspɨsɨ nauəniən nɨg kəlkələh mɨn iətəm tatɨmərəgrəg=pən e nɨpəg tepɨl.” ");
INSERT INTO tnp_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kəni Iesu təməni=pən kəm in məmə, “Mətəu-inu nəmuhalpɨn vivi rəhak nəghatiən, uvən-to əpəha imam ikɨn mafu narmɨn tərah tɨniet rəkɨs e rəham pətəkəku.” ");
INSERT INTO tnp_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Pətan u təmaiu muvən iman lahuənu mafu rəhan pətəkəku tətapɨli-pəri vivi əmə e rəhan pet, kəni narmɨn tərah tɨniet rəkɨs lan. ");
INSERT INTO tnp_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kəni Iesu təmiet ikɨn əha ima nətəm Taea kəni muvən=pən əpəha Saedon muvən=pən əpəha Tekapolɨs ikɨn matuvən əpəha e nəhu Lek Kaləli. ");
INSERT INTO tnp_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kəni nətəmimi kəmotit iətəmimi kəti nɨmatəlgɨn talu kəni məruru nəghatiən məhuva məmə Iesu otələhu=pən nəhlmɨn lan pəh tətəu təuvɨr mɨn e nɨmɨsiən. ");
INSERT INTO tnp_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kəni Iesu təmit suah u mian əpəha isəu nəuvetɨn o nətəmimi, kəni məfən nəuanəhlmɨn e nɨmatəlgɨn kəni magəh nəhlmɨn mələhu=pən e namɨn. ");
INSERT INTO tnp_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kəni məsal pəri əpəha e neai, kəni meəhagəhli ohni e rəhan nəghatiən məmə, “!Efata!” Nɨpətɨn təni məmə, “!Əuvɨr-tə!” ");
INSERT INTO tnp_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kəni əmeiko iətəmi u tɨnatətəu nati, kəni namɨn tɨnəuvɨr mɨnatəghati vivi. ");
INSERT INTO tnp_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kəni Iesu təməniəhu ilah məmə okəsotəniən nati u kəm nətəmimi. Mətəu nian Iesu təmətəkeikei kəm lah, mətəu ilah kəmotəkeikei motəni pətɨgəm pɨk mɨn kəm nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kəmotauɨt pɨk ohni motəni məmə, “Natimnati rəfin iətəm tatol, mətəu in təuvɨr pɨk agɨn. Nətəmimi mɨn u nɨmatəlgɨlah talu kɨnautətəu nati, mɨne nətəmimi mɨn u kotəruru nəghatiən kɨnautəghati.” ");
INSERT INTO tnp_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","E nian kəti mɨn, nətəmimi tepət kəməhuva mɨn ohni, kəni mətəu nɨglah nauəniən tɨnɨkə. Kəni Iesu təmauɨn e rəhan mɨn nətəmimi kəhuva kəni təni=pən kəm lah məmə, ");
INSERT INTO tnp_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nɨkik tɨnahmə pɨk o nətəmimi mɨn əpəha mətəu-inu, kəməhuərisɨg lak mɨnotos rəkɨs nian kɨsɨl, kəni rəueiu əha, nɨglah nauəniən tɨnɨkə. ");
INSERT INTO tnp_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nəmə iəkahli=pən ilah kautəhuvən əha rəueiu, kəni sueiuei otoh ilah, kəni nəhmtɨlah otapɨn e suaru, mətəu-inu kəməsotauəniən nuvəh, kəni nəuvein kəmotsɨpən əpəha isəu.” ");
INSERT INTO tnp_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kəni rəhan mɨn nətəmimi kəmotətapuəh ohni məmə, “?Okos iə pɨret təhmen o naugɨniən ilah? In u ikɨnu nati tɨkə ikɨn, nətəmimi kəsotatɨgiən ikɨn.” ");
INSERT INTO tnp_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Kəni Iesu təmətapuəh o lah məmə, “?Nautos pɨret kuvəh?” Mətəu kotəni məmə “Səpɨn.” ");
INSERT INTO tnp_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kəni təməni=pən kəm nətəmimi məmə okotəharəg, kəni tos pɨret u məfaki məni tagkiu kəm Uhgɨn ohni, kəni məhapu məfən kəm rəhan mɨn nətəmimi məmə okotəuəri e nətəmimi, kəni ilah kəmotol lanəha. ");
INSERT INTO tnp_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kəni kəmotos mɨn nəmu əlkələh nəuvein motəfən kəm Iesu, kəni Iesu təfaki kəm Uhgɨn ohni kəni məfən mɨn kəm lah məmə okotəuəri kəm nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Kəni nətəmimi mɨn u Iesu təmaugɨn ilah kotəhmen e fo-tausɨn, kəmotun nauəniən nərfɨlah tasisi, kəni motəpəh nɨpɨspɨsɨ nauəniən, kəni kaipei=pən e kətɨm asoli səpɨn kotəri. ");
INSERT INTO tnp_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kəni Iesu tahli=pən nətəmimi kautəhuvən imalah mɨn ikɨn. Kəni ilah rəhan mɨn nətəmimi kəməhuvən e bot məhuvən əpəha e nɨtəni Talmanutə. ");
INSERT INTO tnp_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kəni Farəsi mɨn nəuvein kəməhuva o Iesu mautorgəhu kəm in motəni=pən kəm in məmə otol-to nəmtətiən asoli kəti pəh kotəhrun məmə in təmsɨpən pəhriən o Uhgɨn, uə kəpə. ");
INSERT INTO tnp_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kəni Iesu nɨkin təməpəou, kəni təmeəhagəhli o lah kəni məni məmə, “?Kərmə təhro nətəmimi mɨn u rəueiu mɨne kotəni məmə okotafu-to nəmtətiən kəti? Mətəu iətəni pəhriən kəm təmah məmə ko kəsoliən nəmtətiən kəti kəm təmah.” ");
INSERT INTO tnp_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kəni məpəh ilah məhuvən e bot məhuvən əpəha e nɨkalɨ nəhu nəven=pən. ");
INSERT INTO tnp_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Rəhan mɨn nətəmimi kəmotalu e nəmkiən pɨret təhmen mətəu kəmotos əmə kətiəh əmə məhuvən e bot. ");
INSERT INTO tnp_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Kəni Iesu təməuvahag kəm lah məmə, “Onauteh vivi itəmah o is rəha Farəsi mɨn mɨne is rəha Herot Antipas.” ");
INSERT INTO tnp_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kəni kəmotəni=pən kəm lah mɨn məmə, “Tətəni lanəha mətəu-inu kəməsotəmkiən pɨret.” ");
INSERT INTO tnp_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Kəni mətəu Iesu tɨnəhrun rəhalah nətəlɨgiən kəni məni məmə, “?Təhro nəutəni nəghatiən əha məmə nəməsotəmkiən pɨret? ?Təhro itəmah nəsoteruh əhanəhiən kəni məsotəhrun əhanəhiən? !Rəhn-kapə təmah tiəkɨs! ");
INSERT INTO tnp_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nəhmtɨtəmah u ikɨn. ?Təhro nəsotehiən nati? Kəni nɨpəgtəlgɨtəmah u ikɨn. ?Təhro nəsotətəuiən nati? Iəkəhrun məmə nəmə təhro nɨnotalu e natimnati iətəm kɨnəhuva rəkɨs. ");
INSERT INTO tnp_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","?Nian iəmos pɨret mɨn əha faif məfən kəm nətəmimi əha faif-tausɨn kotun, kəni uərisɨg nəmotaipei nɨpɨspɨsɨn e kətɨm asoli kuvəh?” Mətəu kotəni məmə, “Tueləf.” ");
INSERT INTO tnp_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Kəni təmətapuəh mɨn o lah məmə, “?Kəni nian iəmos pɨret əha səpɨn məmə iəkəfən kəm nətəmimi mɨn əpəha fo-tausɨn kotun, kəni uərisɨg nəməhuveipei=pən nɨpɨspɨsɨn e kətɨm asoli kuvəh?” Mətəu kotəni məmə, “səpɨn.” ");
INSERT INTO tnp_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kəni təmətapuəh o lah məmə, “?Mətəu itəmah nəkotəruru əhanəh iəu?” ");
INSERT INTO tnp_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kəni kəməhuvari əpəha ikɨn kəti kətəni məmə Petsaitə, kəni nətəmimi ikɨn kəmotit suah kəti nəhmtɨn tərah məhuva kəni məutəkeikei o Iesu məmə otələhu=pən nəhlmɨn lan. ");
INSERT INTO tnp_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kəni Iesu təmos nəhlmɨ suah u mian isəu nəuvetɨn o lahuənu kəni magəh nəhmtɨ suah u kəni mələhu=pən nəhlmɨ mil lan, kəni mətapuəh ohni məmə, “?Nɨnəhrun neruhiən nati uə kəpə?” ");
INSERT INTO tnp_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mətəu suah u təməsal pəri kəni məni məmə, “Iətafu nətəmimi mətəu kotəhmen əmə e nɨgi mɨn mətəu in əmə u kəutaliuək.” ");
INSERT INTO tnp_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kəni Iesu təmatɨg mələhu=pən mɨn nəhlmɨn mil e nəhmtɨ suah u, kəni nəhmtɨn tɨnəhrun neruh viviən natimnati mɨnəpəh nəuau-əuauiən. ");
INSERT INTO tnp_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Kəni Iesu təmahli=pən məmə otatuvən iman ikɨn mətəu təməniəhu məmə otəsuvən-pəniən əha lahuənu əha ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Kəni Iesu mɨne rəhan mɨn nətəmimi kəmohiet motəsəu pahav məhuvən e lahuənu mɨn u iuəkɨr o nati əpəha Sisəriə Fɨlɨpai. Nian kəmautəhuvən e suaru kəni tətapuəh o lah məmə, “?Otəni-to məmə nətəmimi kotəni iəu məmə iəu pəh?” ");
INSERT INTO tnp_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Mətəu rəhan mɨn nətəmimi kotəni məmə, “Nətəmimi nəuvein kotəni məmə ik Jon Bəptais. Nəuvein kotəni məmə ik Elaijə. Nəuvein mɨn kotəni məmə ik iəni kəti rəha Uhgɨn aupən.” ");
INSERT INTO tnp_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Kəni təmətapuəh o lah məmə, “?Mətəu itəmah nəkotəni məmə iəu pəh?” Kəni Pitə təni məmə, “!IK u Məsaiə əpələ!” ");
INSERT INTO tnp_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Kəni Iesu təməniəhu əskasɨk ilah məmə, okəsotəni pətɨgəmiən in kəm iətəmi kəti. ");
INSERT INTO tnp_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kəni təmatəgətun ilah kəni mətəni məmə, “Iəu Nətɨ Iətəmimi oiəpanətəu nahməiən o natimnati tepət. Nətəmi asoli rəha nətəm Isrel, mɨne pris asoli mɨn, mɨne nəgətun mɨn rəha Lou okotəməki lak, kəni motohamu iəu, mətəu oiəkos nian kɨsɨl ko, kəni məpanəmiəgəh mɨn.” ");
INSERT INTO tnp_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Təməni-vivi pau kəm lah, mətəu Pitə təmit Iesu mian əpəha e nɨkalɨ suaru kəni mətəniəhu əskasɨk məmə otəsəghatiən lanəha. ");
INSERT INTO tnp_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kəni mətəu Iesu təməsal=pən meruh rəhan mɨn nətəmimi, kəni məni=pən kəm Pitə məmə, “!Ik iərmɨs Setən asoli, agɨm muvən isəu ohniəu! Rəham nətəlɨgiən səniəmə rəha Uhgɨn, mətəu rəha iətəmimi əmə.” ");
INSERT INTO tnp_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kəni Iesu təmauɨn rəfin e nətəmimi, mɨne rəhan mɨn nətəmimi, məmə okəhuva ohni, kəni məni məmə, “Nəmə iətəmi kəti təni məmə otuərisɨg lak, otəkeikei malu aru lan, kəni mələs rəhan nɨgi kəməluau muərisɨg lak. ");
INSERT INTO tnp_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Iətəmimi iətəm tolkeikei məmə otosmiəgəh rəhan nəmiəgəhiən e nəhue nɨftəni u, kəni otəmkarəpən e rəhan nəmiəgəhiən itulɨn. Mətəu iətəmi otɨmɨs ohniəu mɨne Nanusiən Təuvɨr rəhak, in otos nəmiəgəhiən itulɨn. ");
INSERT INTO tnp_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","?Nəmə iətəmimi kəti tatos rəfin natimnati e nəhue nɨftəni, mətəu uərisɨg lan otɨmɨs kəni təsosiən nəmiəgəhiən itulɨn, in təmol win e nati təuvɨr kəti, uə kəpə? Kəpə. ");
INSERT INTO tnp_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ko iətəmi təsəfəniən nati kəti kəm Uhgɨn məmə Uhgɨn otəfən nəmiəgəhiən itulɨn kəm in. ");
INSERT INTO tnp_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Nəmə nətəmimi kəutaulɨs e nəni pətɨgəmiən iəu mɨne rəhak nəghatiən kəm nətəmi kəsotəfakiən mautol təfagə tərah, kəni o nian iəu Nətɨ Iətəmimi oiəkuva lan, iəu mɨn oiəkaulɨs e nəni pətɨgəmiən məmə ilah u rəhak mɨn nətəmimi. O nian əha iəkuva itɨmah nagelo asim mɨn e noraipiən əhagəhag asoli rəha rəhak tatə.” ");
INSERT INTO tnp_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kəni Iesu təməni məmə, “Iətəni pəhriən kəm təmah məmə, itəmah nəuvein u nəutəhtul u ikɨnu rəueiu, ko kəsohmɨsiən motətəuarus koteruh Narmənɨgiən Rəha Uhgɨn otuva e nəsanəniən asoli.” ");
INSERT INTO tnp_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kəni nian sikɨs kɨnəhuva mɨnəhuvən rəkɨs, kəni Iesu tit Pitə, Jemɨs, mɨne Jon, kəni ilahal pɨsɨn əmə kɨluərisɨg lan məhuvən əpəha e nɨtəuət əfəməh kəti, kəni ilah pɨsɨn əmə əha ikɨn. Kəni kəmlafu nɨpətɨ Iesu təməuhlin muva mol pɨsɨn. ");
INSERT INTO tnp_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Rəhan napən təmuva məruən mətoraip-oraip, ko iətəmi kəti təseikuasiən e napən kəti təruən lanəha. ");
INSERT INTO tnp_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kəni suah milahal əha kəmlafu Elaijə mɨne Mosɨs kəmiaiet pətɨgəm=pa məhləghati ilahal Iesu. ");
INSERT INTO tnp_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kəni Pitə təməni=pən kəm Iesu məmə, “Iəgətun, təuvɨr məmə iəkluva u ikɨn u. Pəh mɨhlol nɨmauvluvl kɨsɨl, rəham kəti, rəha Mosɨs kəti, kəni rəha Elaijə kəti.” ");
INSERT INTO tnp_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pitə tɨnətəghati əpnapɨn əmə mətəu-inu kɨnləgɨn pɨk məhlərəmrumɨn. ");
INSERT INTO tnp_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kəni nəpuə təmuva məuveg ilah, kəni kəmotətəu nəuia iətəmi kəti təmsɨpən əpəha e nəpuə məmə, “Inu nətɨk keikei u iəkolkeikei pɨk. Onəklətəlɨg lan.” ");
INSERT INTO tnp_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kəni rəueiu agɨn mɨn, kəmleirair, mətəu kəsleruhiən mɨn suah mil, mətəu kəmleruh əmə Iesu tətəhtul ilahal min. ");
INSERT INTO tnp_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nian kəməuteiuaiu e nɨtəuət məhuvən əpəha ləhtəni, kəni Iesu təməniəhu əskasɨk ilahal məmə, “Natimnati mɨn u nəmleh əpəha ilɨs e nɨtəuət, onəsləniən kəm iətəmi kəti mɨlətəuarus=pən iəu Nətɨ Iətəmimi oiəkəmiəgəh mɨn e nɨmɨsiən.” ");
INSERT INTO tnp_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kəni ilahal kəmlɨsiai nəghatiən rəha Iesu, mətəu kəməhləni əmə kəm lahal mɨn məmə, “Nəghatiən əha təməni məmə otəmiəgəh mɨn e nɨmɨsiən, kəruru məmə nɨpətɨn təni məmə nak.” ");
INSERT INTO tnp_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kəni kəmlətapuəh o Iesu məmə, “?Təhro iəgətun mɨn rəha Lou kotəni məmə Elaijə otəkeikei maupən muva?” ");
INSERT INTO tnp_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Kəni Iesu təməni=pən kəm lahal məmə, “Nɨpəhriəniən, Elaijə otaupən muva məmə otol vivi natimnati rəfin. ?Mətəu təhro Nauəuə Rəha Uhgɨn təməni məmə iəu Nətɨ Iətəmimi oiəpanətəu nahməiən o natimnati tepət, kəni nətəmimi okoteruh iəu motəuhlin nəmtahlah ohniəu motəpəh iəu? ");
INSERT INTO tnp_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mətəu iətəni pəhriən kəm təmahal məmə Elaijə tɨnuva rəkɨs, kəni kəmol nati tərah lan təhmen e Nauəuə Rəha Uhgɨn təməni məmə okəpanol lanəha.” ");
INSERT INTO tnp_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nian kəmohtəlɨg=pa mɨn, moteruh nətəmimi nəuvein mɨn rəha Iesu, mətəu nɨmənin nətəmimi kəmohtəlau e lah, kəni iəgətun nəuvein rəha Lou mɨne nətəmimi mɨn rəha Iesu kautorgəhu. ");
INSERT INTO tnp_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nian nətəmimi kəmoteruh Iesu, narmɨlah təmiuvɨg pɨk ohni, kəni motaiu məhuva məmə okotəghati kəm in. ");
INSERT INTO tnp_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kəni Iesu təmətapuəh o lah məmə, “?Nakəha nautorgəhu ohni itəmah nətəmimi mɨn əpəha?” ");
INSERT INTO tnp_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mətəu nətəmimi mɨn u kəti təni məmə, “Iəgətun, iəu iəmit nətɨk muva ohnik məmə onəkol vivi, mətəu-inu narmɨn tərah kəti tətatɨg lan kəni mol təruru nəghatiən. ");
INSERT INTO tnp_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kəni nian narmɨn tərah əpə taskəlɨm in, kəni moh mələs iahu morin e nɨməulul, kəni nəhun nəuan ruən tatiet, təhmen e nəuaui nɨtəhi, kəni matɨgət-ərain nəhluvn, nɨpətɨn tatɨkɨmkɨm. Kəni iəmətapuəh o rəham nətəmimi məmə okotəhgi pətɨgəm narmɨn tərah u lan, mətəu kotəruru nəhgi pətɨgəmiən.” ");
INSERT INTO tnp_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Mətəu Iesu təni məmə, “Kəsi, itəmah u nətəmimi rəueiu mɨne nəsotəhatətəiən lak. Kərmə oiəkatɨg kitah min itəmah mətəuarus=pən nian nak nəmanotəhatətə lak. Kəni kərmə onəhgɨn iəpanəmeig e təmah. !Otit suakəku ko məhuva kəm iəu!” ");
INSERT INTO tnp_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kəni kəmotələs məhuvən o Iesu. Kəni narmɨn tərah əpəha təmafu Iesu kəni tol suakəku u tauɨt nɨpətɨn tərəmrumɨn pɨk, kəni məmei morin əpə ləhtəni e nɨməulul məsəuəsəu mətan, kəni nəunəhuan tiet təhmen e sop. ");
INSERT INTO tnp_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Kəni Iesu təmətapuəh o rəhan tatə məmə, “Təmol lanəha mɨnos nu kuvəh?” Mətəu rəhan tatə təni məmə, “Təmətuəuin e nian təmatəkəku mətəuarus=pa əha rəueiu. ");
INSERT INTO tnp_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kəni nian tepət narmɨn tərah kəha tatoh mətləfən əpəha e nɨgəm mɨne nəhu məmə otohamu. Nəmə nəkəhrun noliən, pəh nəkasəkəhruin itɨmlau masiru e tɨmlau.” ");
INSERT INTO tnp_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Mətəu Iesu təni məmə, “Nak əha, nəghatiən u məmə, ‘Nəmə nəkəhrun noliən’? Uhgɨn təhrun noliən natimnati rəfin kəm iətəmimi iətəm tətəhatətə lan.” ");
INSERT INTO tnp_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kəni rəueiu agɨn, tatə rəha suakəku u təmagət əfəməh məmə, “Iəkəhatətə lam, mətəu in əmə u rəhak nəhatətəiən təkəku əmə. !Asiru lak məmə rəhak nəhatətəiən otəri mepət!” ");
INSERT INTO tnp_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kəni nian Iesu təmeruh məmə nətəmimi nəuvein mɨn kɨnəutaiu mɨnəutuva iuəkɨr ohni məmə okotafu-to, kəni təni=pən əskasɨk uəhai əmə kəm narmɨn tərah əpəha məmə, “Ik narmɨn tərah iətəm natol nɨmatəlgɨtəmi tətalu, kəni mol iətəmi təruru nəghatiən. !Iəkəni=pɨnə əhruahru u rəueiu məmə onəkiet e suakəku u, kəni məsuva mɨniən muvən lan!” ");
INSERT INTO tnp_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kəni narmɨn tərah əha təmagət əfəməh mol suakəku əpəha tauɨt mərəmrumɨn mɨn u iuəkɨr agɨn tɨmɨs, kəni miet lan. Ko nakafu məmə tɨnɨmɨs rəkɨs, kəni nətəmimi tepət kotəni məmə tɨnɨmɨs. ");
INSERT INTO tnp_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mətəu Iesu təmeapən maskəlɨm nəhlmɨn miuvi-pəri, kəni təhtul. ");
INSERT INTO tnp_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Iesu təmuvən imə, kəni ilah pɨsɨn əmə rəhan mɨn nətəmimi kəutəharəg, kəni kotətapuəh ohni məmə, “?Kərmə təhro iəkotəruru nəhgi pətɨgəmiən narmɨn tərah əpəha?” ");
INSERT INTO tnp_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Mətəu Iesu təni məmə, “Nəfakiən əmə təhrun nəhgi pətɨgəmiən narmɨn tərah mɨn əha lanəha.” ");
INSERT INTO tnp_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Kəni Iesu mɨne rəhan nətəmimi kəmohiet u ikɨnu kəni məhuvən=pən əpəha e nɨtəni Kaləli ikɨn, mətəu Iesu təsolkeikeiən məmə okəhrun məmə in əha ikɨn əha. ");
INSERT INTO tnp_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Təmol lanəha mətəu-inu tətəgətun rəhan mɨn nətəmimi. Təməni məmə, “Iəu Nətɨ Iətəmimi, okegəhan=pən lak kəm nətəmimi kotohamu iəu iəkɨmɨs. Mətəu oiəkos nian kɨsɨl, kəni məpanəmiəgəh mɨn.” ");
INSERT INTO tnp_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kəni mətəu rəhan mɨn nətəmimi kəsotəhrun viviən rəhan nəghatiən, kəni nɨkilah tɨnətəgɨn o nətapuəhiən e nɨpətɨ nəghatiən rəhan. ");
INSERT INTO tnp_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kəmohiet=pa əpəha Kapeniəm, kəni mɨnautəhuvən imə kəti. Kəni Iesu təmətapuəh o lah məmə, “?Nak əha nəmautəni e suaru?” ");
INSERT INTO tnp_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mətəu kɨnotaulɨs o nuhalpɨniən motəpnapɨn əmə mətəu-inu, e suaru kəmautəni məmə pəh in tepət e lah. ");
INSERT INTO tnp_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kəni Iesu təməhtiahu məharəg, kəni mauɨn e rəhan nətəmimi tueləf məmə okəhuva-to ohni, kəni təni=pən kəm lah məmə, “Iətəmi tolkeikei məmə in otepət e nətəmimi, in otəkeikei meiuaiu e lah kəni muva məmə in ioluək əmə kəti rəhalah.” ");
INSERT INTO tnp_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Kəni mələs suakəku kəti muva mem aupən e lah, kəni maskəlɨm məmə, ");
INSERT INTO tnp_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Kəni iətəmimi iətəm tatos e nɨkin agiən suakəku təhmen e inu, kəni tatol e nərgək, kəni təhmen əmə məmə tatos iəu e nɨkin agiən. Kəni iətəmimi iətəm tatos iəu e nɨkin agiən, kəni təhmen əmə məmə tatos iətəmi u iətəm təmahli=pa iəu.” ");
INSERT INTO tnp_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Kəni Jon təməni=pən kəm Iesu məmə, “Iəgətun iəmotafu suah kəti tətəhgi pətɨgəm narmɨn tərah mɨn e nərgəm, kəni iəmotəniəhu mətəu-inu səniəmə kitah kəti.” ");
INSERT INTO tnp_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Mətəu Iesu təni məmə, “Sotəniəhuiən, mətəu-inu nətəmimi rəfin nətəm kautol nati apɨspɨs mɨn e nərgək, ko kəsotəni uəhaiən nəghatiən tərah lak. ");
INSERT INTO tnp_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Iətəmimi iətəm səniəmə rəhatah tɨkɨmɨr, in tolkeikei itah. ");
INSERT INTO tnp_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Iətəni pəhriən kəm təmah məmə, nəmə iətəm tətasiru e təmah, mətəu-inu rəhak u itəmah, kəni Uhgɨn otətəou in o rəhan noliən təuvɨr u, nati əpnapɨn rəhan nasiruiən in nati əkəku əmə təhmen e nəhu tətəfɨnə kəm təmah məmə nəkotəmnɨm.” ");
INSERT INTO tnp_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Kəni Iesu təmətəkeikei mətəni məmə, “Kəlkələh mɨn u kəutəhatətə lak, nəmə iətəmi kəti tol kəti təmei e rəhan nəmiəgəhiən uə rəhan nəhatətəiən, kəni iətəmi əha, Uhgɨn otol nalpɨniən asoli kəm in. Kəni nalpɨniən əha otəskasɨk tapirəkɨs nəmə kətu=pən kəpiel kəti e nentəuin, kəni kahtiuvət lan əpəha ləuantəhi lokamnɨm məmə otamnɨm. ");
INSERT INTO tnp_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","“Kəni nəmə nəhlməm tol ik natol təfagə, kəni təuvɨr məmə nəkətahtuv rəkɨs məraki lan. Nəmə nəhlməm kətiəh əmə mətəu onəkos nəmiəgəhiən itulɨn, inu təuvɨr pɨk mapirəkɨs agɨn məmə nəhlməm keiu mətəu okəraki=pən lam e nɨgəm asoli u naunun tɨkə.” ");
INSERT INTO tnp_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Kəni nəmə nəhlkəm kəti tol ik nətəmei e rəham nəmiəgəhiən, nəkətahtuv rəkɨs. Nəmə nəhlkəm kətiəh əmə mətəu onəkos nəmiəgəhiən itulɨn, inu təuvɨr pɨk mapirəkɨs agɨn məmə nəhlkəm keiu mətəu okəraki=pən lam e nɨgəm asoli. ");
INSERT INTO tnp_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kəni nəmə nəhmtəm kəti tol ik nətəmei e rəham nəmiəgəhiən, nəkələs rəkɨs. Nəmə nəhmtəm kətiəh əmə mətəu onəkuvən ikɨn Uhgɨn tətarmənɨg ikɨn, inu təuvɨr pɨk mapirəkɨs agɨn məmə nəhmtəm keiu mətəu okəraki=pən lam e nɨgəm asoli. ");
INSERT INTO tnp_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kəni ikɨn əha, uhrəl mɨn okotətu e nɨpətɨ nətəmimi ikɨn məsohmɨsiən, kəni nɨgəm tatus ilah kəni matuəu əmə kɨlpɨn ko kəsohapɨsiən nian kəti. ");
INSERT INTO tnp_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Uhgɨn tətearəgrəg=pən nɨgəm e nətəmimi təhmen əmə e sol kətearəgrəg=pən e nauəniən. ");
INSERT INTO tnp_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“?Sol təuvɨr, mətəu nəmə otɨsiu, kəni kəruru məmə okəfən mɨn nak pəh tətəhiən? Onəkotəkeikei motos sol u təhmen e nolkeikeiən e rəhatəmah nəmiəgəhiən, kəni motatɨg e nəməlinuiən nian rəfin.” ");
INSERT INTO tnp_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kəni Iesu təmiet ikɨn əha kəni muvən miet=pən əpəha e nɨtəni əpəha Jutiə e nəven nɨtəni=pən e nəhu Jotən. Kəni nɨmənin nətəmimi kəmotuhapumɨn=pən mɨn ilah mɨn ohni, kəni tətəgətun ilah məmə inu tətəgətun ilah mɨne nian mɨn. ");
INSERT INTO tnp_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kəni Farəsi nəuvein kəməhuva moteiuə əmə motətapuəh ohni məmə, “?Təhro? ?Rəhatah Lou tətegəhan məmə iərman təhrun nəpəhiən rəhan pətan mol difos lan, uə kəpə?” ");
INSERT INTO tnp_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Mətəu Iesu təmətapuəh o lah məmə, “?Lou nak u Mosɨs təmələhu aupən kəm təmah?” ");
INSERT INTO tnp_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kəni mətəu kotəni məmə, “Mosɨs təmegəhan lan məmə nəmə iərman tətəpəh rəhan pətan, kəni təkeikei mətei nauəuə kəti məfən kəm rəhan pətan məmə in tɨnəpəh mɨnol difos lan, kəni ko mənahli pətɨgəm.” ");
INSERT INTO tnp_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Mətəu Iesu təni məmə, “Mosɨs təmətei lou ko mətəu-inu rəhn-kapə təmah tiəkɨs pɨk. ");
INSERT INTO tnp_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Mətəu e nətuəuiniən, Uhgɨn təmol natimnati, kəni mol iərman mɨne pətan. ");
INSERT INTO tnp_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","O nati əha in əha, iərman otəpanəpəh rəhan tatə mɨne mamə, kəni mətuatɨg ilau rəhan pətan. ");
INSERT INTO tnp_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Kəni ilau okiəuva nɨpətɨlau kətiəh. Kəni rəueiu, ilau səniəmə keiu, mətəu kətiəh əmə. ");
INSERT INTO tnp_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Uhgɨn tɨnɨlpɨn ilau kɨniəuva mɨnuol kətiəh, kəni o nati əha, pəh iətəmimi kəti ko təsətahtuviən rəhalau natɨgiən.” ");
INSERT INTO tnp_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kəni Iesu mɨne rəhan nətəmimi kəməhuvən əpəha imə, kəni rəhan mɨn nətəmimi kotətapuəh ohni o nati u. ");
INSERT INTO tnp_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kəni təməni=pən kəm lah məmə, “Iətəmi tatol tifos mətəpəh rəhan pətan kəni matit mɨn in pɨsɨn kəti, in tatol təfagə tərah e rəhan əhruahru pətan. ");
INSERT INTO tnp_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kəni təhmen mɨn əmə, nəmə pətan kəti tətəpəh rəhan iərman kəni matɨtəu=pən in pɨsɨn kəti, in mɨn tatol təfagə tərah e rəhan əhruahru iərman.” ");
INSERT INTO tnp_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kəni nətəmimi nəuvein kəmotəmki kəlkələh mɨn məhuva o Iesu məmə otələhu=pən nəhlmɨn e lah məfən nəuvɨriən rəha Uhgɨn kəm lah. Mətəu rəhan mɨn nətəmimi kəmautəniəhu ilah. ");
INSERT INTO tnp_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mətəu nian Iesu təmeruh, kəni niəməha tol, mətahi ilah məmə, “Pəh kəlkələh mɨn okəhuva ohniəu. Sotəniəhuiən kəlkələh mɨn u, mətəu-inu nətəmimi mɨn u nɨkilah təhmen əmə e nɨki kəlkələh mɨn, ilah u Uhgɨn tətarmənɨg e lah. ");
INSERT INTO tnp_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Iatəni pəhriən kəm təmah məmə, nəmə iətəmi kəti təsolkeikeiən məmə oteiuaiu məhmen e kəlkələh mɨn u kəti mupəh Uhgɨn tarmənɨg lan, ko in təsatɨg ahgəliən Narmənɨgiən Rəha Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kəni mos kəlkələh mɨn e nəhlmɨn, kəni mələhu=pən nəhlmɨn e lah məmə, “Pəh Uhgɨn otəfɨnə rəhan nəuvɨriən kəm təmah.” ");
INSERT INTO tnp_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nian Iesu tɨnətaliuək matuvən, kəni suah kəti təmaiu muva mɨsin=pən nəulɨn ohni məmə, “Iəgətun təuvɨr, oiəkəkeikei mol nak u məmə iəkos nəmiəgəhiən itulɨn?” ");
INSERT INTO tnp_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Mətəu Iesu təni məmə, “?Təhro nətəni məmə iəu iətəmi təuvɨr? Uhgɨn pɨsɨn əmə u in təuvɨr, iətəmi kəti mɨn tɨkə məmə in təuvɨr. ");
INSERT INTO tnp_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ik nɨnəhrun rəkɨs lou mɨn rəha Mosɨs məmə onəsohamuiən iətəmi, məsakləhiən, məseiuəiən, məsakləhiən e pətan, onəkəkeikei mɨsiai rəham tatə mɨne mamə.” ");
INSERT INTO tnp_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mətəu suah u təni məmə, “Iəgətun, lou mɨn u, iatol rəfin ilah nian iəmatəkəku mətəuarus=pa u rəueiu mɨne.” ");
INSERT INTO tnp_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Kəni Iesu təməsal=pən əhruahru meh suah u molkeikei pɨk, kəni məni məmə, “Nati kəti mɨn əmə əha ikɨn onəkol. Uvən mol nətəmimi kotos nəhmtɨ rəham nautə rəfin agɨn, kəni məfən məni lan kəm nanrah mɨn, kəni ik onəkos nəuvɨriən tepət əpəha e negəu e neai. Kəni muva, muərisɨg lak, mol məmə rəhak iətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kəni nian suah u təmətəu nəghatiən u, kəni nəhmtɨn təməpəou, kəni nɨkin təməpəou pɨk ohni, matuvən mətəu-inu rəhan nautə tepət. ");
INSERT INTO tnp_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kəni Iesu təməsal=pən meruh nətəmi mɨn əha ikɨn, kəni məni=pən kəm rəhan mɨn nətəmimi məmə, “!Nəman! Tiəkɨs pəhriən o nətəm rəhalah nautə tepət məmə okəhuvən motatɨg ahgəl e Narmənɨgiən Rəha Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kəni rəhan mɨn nətəmimi kəmotauɨt pɨk o nəghatiən rəhan, mətəu Iesu təməni mɨn məmə, “Nenətɨk mɨn, tiəkɨs pəhriən məmə iətəmi kəti otuvən matɨg ahgəl e Narmənɨgiən Rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tiəkɨs o kaməl asoli məmə otuvən=pən e nɨpəg nitɨl, mətəu tiəkɨs pɨk agɨn o iətəm rəhan nautə tepət məmə otuvən matɨg ahgəl e Narmənɨgiən Rəha Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kəni rəhan mɨn nətəmimi kəmotauɨt pɨk ohni motəni məmə, “?Ei, mətəu pəh təhrun nosiən nəmiəgəhiən itulɨn?” ");
INSERT INTO tnp_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Kəni Iesu təməsal=pən meruh ilah, kəni məni məmə, “Nak u, ko iətəmimi təsoliən. Mətəu Uhgɨn, in təhrun noliən natimnati rəfin.” ");
INSERT INTO tnp_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Mətəu Pitə təni məmə, “Itɨmah iəmotəpəh rəfin rəhatɨmah natimnati məmə oiəkohuərisɨg lam.” ");
INSERT INTO tnp_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Mətəu Iesu təni məmə, “Iətəni pəhriən, iətəmimi iətəm otəpəh rəhan nimə, uə pian mɨn, uə kakə mɨn, uə mamə, uə tatə, uə kəlkələh mɨn, uə rəhan nɨftəni ohniəu mɨne Nanusiən Təuvɨr, ");
INSERT INTO tnp_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","e nəmiəgəhiən rəha nəhue nɨftəni u, in otos nɨtailah uan-hanrɨt, inu nimə mɨn, mɨne pian mɨn, mɨne kakə mɨn, mɨne mamə mɨn, mɨne kəlkələh mɨn, mɨne nɨftəni mɨn — kəni in otos mɨn nərahiən mɨn iətəm nətəmimi okotol kəm in. Kəni e nəmiəgəhiən vi iətəm otəpanuva, in otos nəmiəgəhiən itulɨn. ");
INSERT INTO tnp_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mətəu nətəmimi tepət u kautaupən u rəueiu, okəpanəhuərisɨg, kəni nətəmi u kautəhuərisɨg u rəueiu okəpanotaupən.” ");
INSERT INTO tnp_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kəni Iesu mɨne kəmotaliuək e suaru məutəri=pən əpəha Jerusɨləm, kəni Iesu təmətaupən e rəhan mɨn nətəmimi, əmeiko narmɨlah təmiuvɨg pɨk ohni, kəni nətəmi kəmautəhuərisɨg e lah kəmotəgɨn. Kəni Iesu tit rəkɨs rəhan mɨn nətəmi tueləf məhuvən, kəni mətəni=pən nati nak iətəm okəpanol lan, ");
INSERT INTO tnp_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","məni məmə, “Otətəlɨg vivi-to lak. Rəueiu kɨnautəri mɨnautəhuvən əpəha Jerusɨləm, kəni okegəhan=pən lak iəu Nətɨ Iətəmimi e nəhlmɨ pris asoli mɨn mɨne nəgətun mɨn rəha Lou. Kəni okotəni məmə oiəkɨmɨs, kəni okotəhlman=pən lak e nəhlmɨ Nanihluə mɨn. ");
INSERT INTO tnp_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kəni okotəuvsan lak, kəni motagəh iəu, motalis iəu, kəni motohamu iəu. Mətəu e nian tatol kɨsɨl lan u, iəpanəmiəgəh mɨn.” ");
INSERT INTO tnp_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kəni Jemɨs mɨne Jon, nətɨ Səpəti mil, kəmiəuva o Iesu, kəni muəni=pən ohni məmə, “Iəgətun, iəkuolkeikei nati kəti məmə onəkol kəm tɨmlau.” ");
INSERT INTO tnp_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Kəni Iesu təni məmə, “?Nəkuolkeikei nak məmə iəkol kəm təlau?” ");
INSERT INTO tnp_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Mətəu kuəmə, “O nian nəkuva məmə onəkarmənɨg e nəhagəhagiən rəha nəsanəniən rəham, kəni iəkuolkeikei məmə onəkegəhan e tɨmlau kəti təharəg e nəhlməm maru kəni kəti təharəg e nəhlməm məuɨl, ikɨn mil ko ima nəsanəniən mɨne nɨsiaiən ikɨn.” ");
INSERT INTO tnp_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kəni Iesu təməni=pən kəm lau məmə, “Itəlau nəkuəruru nati nətuəni. ?Təhro? ?Itəlau, nɨkitəlau təhti məmə nəkuəhmen o nəmnɨmiən e kap rəha nahməiən iəu oiəkəmnɨm lan? ?Kəni muəhmen mɨn məmə okol bəptais e təlau e nahməiən məmə inu okol lak?” ");
INSERT INTO tnp_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Kəni kuəmə, “!Əuəh, iəkuəhmen lan!” Mətəu Iesu təni məmə, “Pəhriən, onəkuəkeikei nəmnɨmiən e kap iəu iəkəmnɨm lan. Kəni okol bəptais e təlau e bəptais iətəm okol bəptais lak lan. ");
INSERT INTO tnp_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mətəu o nəharəgiən e nəhlmək maru mɨne məuɨl, səniəmə rəhak məmə iəkəni. Ikɨn mil əha, ilau rəha nətəmimi u iətəm Uhgɨn təmol əpenə-penə o lah.” ");
INSERT INTO tnp_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Uərisɨg lan, rəhan nətəmi ten kəmotətəu nəghatiən u, kəni niəməha təmol ilah o Jemɨs mɨne Jon. ");
INSERT INTO tnp_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kəni Iesu təmauɨn e rəhan mɨn nətəmimi kəhuva, kəni təni=pən kəm lah məmə, “Itəmah nəkotəhrun məmə nətəmimi mɨn u kotəni məmə okotepət e Nanihluə mɨn, kautəfəri aru ilah, kəni nətəmi asoli rəhalah kautol nalkutiən asoli kəm rəhalah mɨn nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","“Mətəu itəmah onəsotoliən lanəha. Nəmə itəmah kəti tolkeikei məmə in otepət e təmah, in otəkeikei muva məmə in ioluək əmə kəti rəhatəmah. ");
INSERT INTO tnp_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kəni nəmə itəmah kəti tolkeikei məmə in otit itəmah, kəni in otəkeikei muva məmə in iol əhruin kəti rəhatəmah. ");
INSERT INTO tnp_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kəni iəu mɨn, Nətɨ Iətəmimi, iəməsuvaiən məmə nətəmimi okotol uək kəm iəu, mətəu iəmuva məmə iəkol uək kəm nətəmimi kəni məfən rəhak nəmiəgəhiən məmə iəkɨtɨs ilah e rəhalah noliən tərah mɨn.” ");
INSERT INTO tnp_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kəni Iesu mɨne rəhan mɨn nətəmimi, kəməhuva əpəha Jeriko. Kəni nian kɨnohiet mautəhuvən, kəni nətəmimi tepət kəməhuərisɨg e lah. Kəni suah kəti nəhmtɨn tərah, tətəharəg e nɨkalɨ suaru, nərgɨn u Patimiəs nətɨ Timiəs. Nian rəfin təteasiə e məni o nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nian təmətəu məmə Iesu iətəm Nasərɨt tətaliuək e suaru mətuva, kəni təmagət əfəməh məmə, “!Əui, Iesu Mipɨ Tefɨt, asəkəhruin iəu masiru lak!” ");
INSERT INTO tnp_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kəni nətəmimi nəuvein kotearəg lan motəni məmə, “!Ei, sagətiən!” motəni pau mətəu in təməha magət əfəməh pɨk mɨn məmə, “!Mipɨ Tefɨt, asəkəhruin iəu masiru lak!” ");
INSERT INTO tnp_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kəni Iesu təhtul kəni məni məmə, “Otauɨn-pən-to e suah u məmə tuva.” Kəni motəni=pən kəm in məmə, “Ei, agiən, məhtul, mətəu-inu Iesu tətauɨn lam.” ");
INSERT INTO tnp_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kəni suah u təməraki e rəhan kot, miuvɨg-pəri məhtul muvən o Iesu. ");
INSERT INTO tnp_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Kəni Iesu tətapuəh ohni məmə, “?Nəkolkeikei nak?” Mətəu təni məmə, “Iəgətun, iəkolkeikei məmə nəkol vivi nəhmtək pəh iəkeh nati.” ");
INSERT INTO tnp_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Kəni Iesu təni məmə, “Atuvən. Rəham nəhatətəiən tɨnol vivi ik.” Kəni rəueiu agɨn mɨn nəhmtɨn təməuvɨr, tɨnateh nati. Kəni mɨnatɨtəu=pən Iesu məutan. ");
INSERT INTO tnp_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kəməhuvən iuəkɨr o Jerusɨləm, iuəkɨr o lahuənu mil u Petfas mɨne Petəni, mautəhuvən əpəha e Nɨtəuət Rəha Nɨgi U Olif, kəni Iesu təmahli=pən rəhan keiu iətəmimi mil kuaupən. ");
INSERT INTO tnp_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Təməni=pən nəghatiən u kəm lau məmə, “Onəkian əpəha e lahuənu əha kəutəsal=pən ikɨn. O nian nəkian əha ikɨn, kəni ko mueruh mɨn nətɨ togki kəti kəsasuə əhanəhiən lan kəmohrain. Kəni nəkiatɨs muasɨg miəuva. ");
INSERT INTO tnp_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kəni nəmə iətəmi kəti tətəni məmə, ‘?Onəkuəhro e nətɨ togki?’ kəni nəkuəmə, ‘Iərmənɨg tolkeikei, kəni otəpanahli=pa mɨn tuva uəhai əmə.’” ");
INSERT INTO tnp_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ilau kəmian kəni mueruh nətɨ togki u kəmohrain e nɨkalɨ suaru əpah iuəkɨr o namtɨhluə e nimə, kəni kiatɨs. ");
INSERT INTO tnp_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Mətəu nətəmimi nəuvein kəməutəhtul əha ikɨn kəni motətapuəh o lau məmə, “!Ei! !Nətiatɨs nətɨ togki u o nak?” ");
INSERT INTO tnp_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kəni kəmuəni=pən nəghatiən rəha Iesu kəm lah, kəni kəmotegəhan=pən e nətɨ togki kəm lau. ");
INSERT INTO tnp_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kəni kəmuasɨg togki mian o Iesu, kəni muəpeg rəhalau kot muəhtərain nəhue togki u lan, kəni Iesu təmasuə lan. ");
INSERT INTO tnp_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kəni nətəmimi tepət kəmotepin rəhalah kot əpah e suaru, kəni nəuvein kəmotaiu məhuvən əpəha e nɨkinati motətei nɨmənati motəmki məhuva motepin əpah e suaru. ");
INSERT INTO tnp_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nətəm kəutaupən mɨne nətəm kautəhuərisɨg kəmotagət əfəməh məmə, “!Hosanə, əni-vivi Uhgɨn! !Iərmənɨg Uhgɨn tətatɨg ilau iətəmimi u iətəm tətuva e nərgɨn! ");
INSERT INTO tnp_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","!Pəh Uhgɨn otəfən rəhan nəuvɨriən kəm suah u tətuva məmə iərmənɨg təhmen e Tefɨt u tɨpɨtɨmah aupən! !Hosanə o Uhgɨn əpəha ilɨs e negəu e neai!” ");
INSERT INTO tnp_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kəni Iesu təmuvən əpəha Jerusɨləm e Nimə Rəha Uhgɨn meruh rəfin natimnati mɨtəlau. Mətəu mɨtɨgar tɨnalelin rəkɨs, kəni tiet ilah rəhan mɨn tueləf nətəmimi mautəhuvən mɨn Petəni. ");
INSERT INTO tnp_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kəni kəməni pa lauɨg lan, kohiet mɨn Petəni mɨnautəhuvən Jerusɨləm, kəni nəumɨs tɨnus Iesu. ");
INSERT INTO tnp_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kəni təsal=pən e nɨgi kəti fik tətəhtul əpəha isəu nəuvetɨn nɨmalɨn tepət. Tuvən məmə otəhli nəuan kəti, mətəu nəuan tɨkə, nɨmalɨn əmə, mətəu-inu səniəmə nian rəha nɨgi fik tətəuə lan. ");
INSERT INTO tnp_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kəni Iesu təməni=pən kəm nɨgi fik əha məmə, “Pəh nətəmimi kəsotun mɨniən nəuam e nu mɨn rəfin.” Kəni rəhan mɨn nətəmimi kəmotətəu rəhan nəghatiən əha təməni. ");
INSERT INTO tnp_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kəni kəməhuvən mohiet=pən əpəha Jerusɨləm, kəni Iesu tuvən əpəha imə e Nimə Rəha Uhgɨn məhgi pətɨgəm nətəmimi kautol makɨt, kəni mahuvihin tepɨl rəha nətəm kautol senɨs e məni, mɨne stul rəha nətəmi kautol səlɨm e mak mɨn. ");
INSERT INTO tnp_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kəni məhtul pəsɨg e nətəmimi məmə okəsotəmkiən rəhalah natimnati məhuvən əpəha e Nimə ikɨn Rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kəni təməgətun ilah məmə, “Kəmətei=pən e Nauəuə Rəha Uhgɨn məmə Uhgɨn təni məmə, ‘Rəhak nimə, in nimə rəha nəfakiən məmə nətəmimi e nɨtəni mɨn rəfin okotəfaki=pa ikɨn kəm iəu.’ Mətəu itəmah nəmotol məmə in ‘nimə rəha iakləh mɨn.’” ");
INSERT INTO tnp_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kəni pris asoli mɨn mɨne nəgətun mɨn rəha Lou kəmotətəu rəhan nəghatiən. Kəni kɨnotəgɨn e Iesu mətəu-inu nian nɨmənin nətəmimi kəmotətəu rəhan nəgətuniən, narmɨlah tiuvɨg pɨk ohni. Kəni pris asoli mɨn mɨne nəgətun mɨn rəha Lou kɨnotətuəuin məutəsal e suaru kəti məmə okotohamu in. ");
INSERT INTO tnp_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kəni nian tɨnəhnaiuv, Iesu mɨne rəhan mɨn nətəmimi kohiet Jerusɨləm mɨnautəhuvən. ");
INSERT INTO tnp_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kəni kəməni lauɨg lan, kəməhuva mɨn e suaru motafu nɨgi fik əha tɨnaukei rəkɨs muvən mətəuarus əpəha e nəukətɨn. ");
INSERT INTO tnp_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Kəni Pitə nɨkin tɨnəhti nəghatiən rəha Iesu e nɨgi əha, kəni təni=pən kəm in məmə, “!Iəgətun, afu-to nɨgi fik əpələ nəməni rah, kəni tɨnaukei rəkɨs!” ");
INSERT INTO tnp_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Kəni Iesu təməni=pən kəm lah məmə, “Otəhatətə əmə e Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Iətəni pəhriən kəm təmah məmə nəmə iətəmi kəti tətəhatətə pəhriən e Uhgɨn, kəni otəni=pən kəm nɨtəuət əpəha məmə, ‘Uvən, miuvɨg pətɨgəm əpəha ləuantəhi mamnɨm,’ kəni nəmə təsəniən e nɨkin keiu, məhatətə əmə e Uhgɨn, kəni nati u otol nɨpəhriəniən. ");
INSERT INTO tnp_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kəni o nati u inu, iəkəni kəm təmah məmə, nəmə nəkotəfaki o nati kəti kəni motəhatətə məmə onəkotos pəhriən, kəni onəpanotos rəfin nati u nəmotəfaki ohni. ");
INSERT INTO tnp_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“!E nian nəkotəhtul məutəfaki, mətəu nɨkitəmah nəuvetɨn əha ikɨn tərah mətəu-inu iətəmi kəti təmol nati kəti təsəhmeniən e təmah, kəni otalu e rəhan noliən tərah məsotalpɨniən nɨtai təfagə tərah rəhan. Otol lanəha pəh Uhgɨn əpəha e negəu e neai in otalu kəni mafəl rəhatəmah təfagə tərah mɨn.” ");
INSERT INTO tnp_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Kəni Iesu mɨne rəhan tueləf nətəmimi kəmohtəlɨg=pa mɨn əpah Jerusɨləm. Kəni Iesu taliuək mətan əpəha e Nimə Rəha Uhgɨn, kəni pris asoli nəuvein, mɨne nəgətun mɨn rəha Lou, mɨne nətəmi asoli rəha nətəm Isrel kəməhuva ohni. ");
INSERT INTO tnp_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Kəni kəutətapuəh məmə, “?Əni-to kəm tɨmah məmə pəh təmegəhan lam natol natimnati mɨn əha? ?Kəni pəh təmegəhan e nepətiən əha, Uhgɨn uə iətəmimi əmə?” ");
INSERT INTO tnp_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Kəni Iesu təməni=pən kəm lah məmə, “Oiəkətapuəh-pɨnə-to nəghatiən kəti kəm təmah, kəni nəmə nəkotuhalpɨn ko, kəni iəkəni=pɨnə məmə pəh təmegəhan e nepətiən u məmə iəkol natimnati mɨn əha. ");
INSERT INTO tnp_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","?Otəni-to məmə pəh təməni məmə Jon otol bəptais e nətəmimi? ?Uhgɨn, uə iətəmimi əmə kəti?” ");
INSERT INTO tnp_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kəni əmeiko kɨnotəni-əni kəm lah mɨn məmə, “?Ei, okotəni məmə nak? Nəmə okotəni məmə Uhgɨn əha rəueiu, kəni otəni mɨn məmə, kəni təhro kəməsotəhatətəiən e Jon. ");
INSERT INTO tnp_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mətəu, ko kəsotəniən məmə iətəmimi əmə kəti.” Kəmotəni lanəha mətəu-inu ilah kəmotəgɨn e nətəmimi iətəm kɨnotəni rəkɨs nɨpəhriəniən e Jon məmə in iəni kəti rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kəni kəmotəni=pən kəm Iesu məmə, “Itɨmah iəkotəruru.” Mətəu Iesu təni məmə, “Kəni iəu mɨn, ko iəsəni pətɨgəmiən kəm təmah məmə pəh təmegəhan e nepətiən məmə iəkol natimnati mɨn əha.” ");
INSERT INTO tnp_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kəni Iesu təməni nəghatiən əuhlin kəti kəm lah məmə, “Suah kəti təmasum e nəua krep, u nɨləuɨs katol wain e nəuan. Kəni mol kəlkəl e kəpiel tuvən mɨtəlau lan, kəni mol ikɨn kəti o noliən nɨmei naliuək-aliuəkiən e nəua krep məmə nəhuɨn otaiu kəni kol wain lan. Kəni mol nimə kəti iətəm in ilɨs məmə iətəmi otəri lan mətəsal vivi o nasumiən o nati miəgəh mɨn mɨne nətəmimi. Kəni təmegəhan=pən e nasumiən kəm nətəmimi məmə okotasum lan, kəni məuəri nəua krep, nəuvetɨn rəhan, nəuvetɨn rəhalah. Kəni miet muvən e naliuəkiən ikɨ pɨsɨn kəti. ");
INSERT INTO tnp_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Matuvən, matuvən, kəni nian nɨləuɨs u krep təmol nəuan kəni mɨnɨmarəg, iətəmi asoli təmahli=pən rəhan kəti ioluək məmə in otuvən meh nətəm kautol uək e rəhan nasumiən məmə okotəhli nəua krep, kəni motəuəri motəfən rəha iətəmi asoli nəuvein. ");
INSERT INTO tnp_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mətəu nətəmimi mɨn əha kəmotəhtul motəhti ioluək əha, kəni motahli=pən tɨtəlɨg məsotəfəniən nəua krep nəuvein mɨne kəm in. ");
INSERT INTO tnp_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Kəni iətəmi asoli u tahli=pən mɨn rəhan kəti ioluək tuvən, kəni kotoh rəhn-kapə motol aulɨs in. ");
INSERT INTO tnp_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kəni tahli=pən mɨn rəhan kəti ioluək tuvən, kəni kotohamu tɨmɨs. Ilah tepət kəməhuvən, kəni nətəmimi mɨn u kotohaein nəuvein, kəni motohamu nəuvein. ");
INSERT INTO tnp_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Kəni kətiəh əmə əha ikɨn ilau min kətuatɨg, inu nətɨn keikei. Naunun, təmahli=pən nətɨn, kəni nɨkin təhti məmə, ‘Ilah okotəkeikei motɨsiai nətɨk.’ ");
INSERT INTO tnp_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mətəu təmuvən kəni nətəmimi mɨn u kotəni məmə, ‘Inu nətɨ iətəmi asoli iətəm otarmənɨg e nasumiən nian rəhan tatə otɨmɨs. !Pəh kəhuvən motohamu mɨn, kəni motarmənɨg e nasumiən rəhan!’ ");
INSERT INTO tnp_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kəni kəmotaskəlɨm motohamu, kəni motələs nɨpətɨn məhuvən motəraki=pən lan əpəha ihluə e nasumiən.” ");
INSERT INTO tnp_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Kəni Iesu təməni=pən kəm lah məmə, “?Iətəmi asoli u otol nak? Otuvən mohamu ilah kəni məfən mɨn nasumiən u kəm nətəpɨsɨn mɨn nəuvein.” ");
INSERT INTO tnp_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Kəni Iesu təməni=pən kəm lah məmə, “?Nəmotafin e Nauəuə Rəha Uhgɨn u, uə kəpə? Tətəni məmə, ‘Kəpiel u iətəm nətəmimi rəha nuvləkɨniən nimə kəsotolkeikeiən motəpəh, in tɨnuva kəpiel keikei o noliən nimə. Iərmənɨg təmol nati u, kəni in nati təuvɨr agɨn e nəhmtɨtah.’” ");
INSERT INTO tnp_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Kəni nətəmimi asoli kotolkeikei məmə okotaskəlɨm Iesu motləfən e kaləpus, mətəu-inu tətəghati rah e lah e nəghatiən əuhlin u. Mətəu kɨnotəgɨn e nɨmənin nətəmimi kəni motəpəh, motagɨm. ");
INSERT INTO tnp_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Farəsi mɨn nəuvein mɨne nətəmimi nəuvein e pati rəha Kig Herot Antipas, rəhalah mɨn nətəmi asoli kəmotahli=pən ilah məmə okəhuva moteiuə e Iesu pəh təmei aru e rəhan nəghatiən. ");
INSERT INTO tnp_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kəməhuva ohni kəni motəni=pən kəm in məmə, “Iəgətun, iəkotəhrun məmə ik iətəmi əhruahru. Noliən rəham o nətəmimi təhmen əhmen əmə o nətəmi asoli mɨne nətəmimi əpnapɨn mɨn rəfin əmə. Mətəni nɨpəhriəniən mətəgətun nətəmimi e suaru rəha Uhgɨn. ?Əni-to məmə təhruahru məmə iəkotətəou=pən takɨs kəm Kig Sisə, kəpmən asoli rəha nətəm Rom, uə kəpə? ?Oiəkotəkeikei motətəou=pən, uə kəpə?” ");
INSERT INTO tnp_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mətəu Iesu tɨnəhrun əmə məmə kəutəni əmə e nohlɨlah mətəu nɨkilah tol pɨsɨn, kəni məni məmə, “?Təhro nəkotəni məmə onəkotol məmə iəkəmei e rəhak nəghatiən? Otos-to məni kəti məhuva-to pəh iəkeh.” ");
INSERT INTO tnp_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kəni kəmotos kəti məhuva, kəni təmətapuəh o lah məmə, “?Narmɨ pəh u, kəni nərgɨ pəh u e məni u?” Mətəu kotəni məmə, “Sisə, iətəmi asoli rəha Rom.” ");
INSERT INTO tnp_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kəni Iesu təni məmə, “Natimnati rəha Sisə, okəfən kəm Sisə. Mətəu natimnati rəha Uhgɨn okəfən kəm Uhgɨn.” Kəni narmɨlah təmiuvɨg mətəu-inu təmuhalpɨn vivi rəhalah nəghatiən. ");
INSERT INTO tnp_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kəni Satusi mɨn nəuvein kəməhuva o Iesu. E rəhalah nətəlɨgiən, nətəmimi kəmohmɨs məsotəmiəgəh mɨniən. Kəməutalkut o noliən məmə rəhalah nətəlɨgiən in təhruahru, kəni tol lanəha, kəmotəni kəm Iesu məmə, ");
INSERT INTO tnp_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Iəgətun, Mosɨs təmətei rəkɨs lou kəti u təni məmə, ‘Nəmə iərman kəti otɨmɨs, kəni məpəh rəhan pətan, kəni məsuələsiən nətɨlau kəti mɨne, kəni pian otəkeikei mit pətalɨmɨs əha, məmə okuələs nətɨlau kəti ko, kəni suakəku u otos nɨmei rəhan tatə asoli əpəha tɨnɨmɨs rəkɨs.’ ");
INSERT INTO tnp_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Kəni nəman ilah səpɨn, u rəhalah tatə kətiəh. Kəni iətəm tepət e lah təmaupən mit pətan kəti, kəni məsuələsiən nətɨlau kəti, kəni mɨmɨs. ");
INSERT INTO tnp_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kəni iətəm təmuərisɨg tit pətalɨmɨs u, kəni məsuələsiən nətɨlau kəti mɨne, kəni tɨmɨs mɨn. Kəni pialau iətəm tatuərisɨg e lau tol əmə nati kətiəh. ");
INSERT INTO tnp_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mətuvən, matuvən kəni nətəmi mɨn u səpɨn ilah pialah mɨn kəmotit pətan u kəni ilah rəfin mohmɨs, kəni məsotələsiən nətɨlah kəti mɨne. Kəni pətan əpəha təmɨmɨs mɨn. ");
INSERT INTO tnp_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","?Kəni o nian nətəmimi okotəmiəgəh mɨn e rəhalah nɨmɨsiən, kəni pətan əha rəha pəh, u ilah rəfin səpɨn kəmotit?” ");
INSERT INTO tnp_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Mətəu Iesu təni məmə, “Itəmah nəmotəmkarəpən. ?Nəkotəhrun məmə onak? Mətəu-inu itəmah nəkotəruru Nauəuə Rəha Uhgɨn, kəni mautəruru mɨn nəsanəniən rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nian nətəmimi nətəm kəmohmɨs okotəmiəgəh mɨn, ilah okotəhmen e nagelo mɨn əpəha e neai, kəni məsotit mɨniən pətan, mɨne məsotohtəu=pən mɨniən iərman. ");
INSERT INTO tnp_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kəni oiəkəgətun itəmah e iətəm tətəmiəgəh mɨn e rəhan nɨmɨsiən. Kəni nəmə təhro itəmah nəsotafin əhanəhiən nəghatiən əha kəmətei=pən e nauəuə rəha Mosɨs, tətəni nanusiən rəha Mosɨs nian nɨgi kəti nɨgəm təmatus. Kəni e nian əha, Epraham, mɨne Aisək, mɨne Jekəp kɨnohmɨs rəkɨs nuvəh. Kəni Uhgɨn təməni=pən kəm Mosɨs məmə, ‘Rəueiu əha, iəu Uhgɨn rəha Epraham, mɨne Uhgɨn rəha Aisək, mɨne Uhgɨn rəha Jekəp.’ ");
INSERT INTO tnp_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tol lanəha, kəmləmiəgəh e narmɨlahal, nati əpnapɨn kəmlɨmɨs e nɨpətɨlahal. Kəni tol pəhriən lanu mətəu-inu Uhgɨn, in Uhgɨn rəha nətəm kəutəmiəgəh, səniəmə rəha nətəm kəmohmɨs agɨn. Itəmah nəmotəmkarəpən pəhriən.” ");
INSERT INTO tnp_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Kəni iəgətun kəti rəha Lou təmətəharəg mətətəu ilah kəutəghati, kəni Iesu tətuhalpɨn vivi nəghatiən rəha Satusi mɨn. Kəni tuva o Iesu mətətapuəh ohni məmə, “?Lou əhro pəhruvən u in ilɨs agɨn kəni in məuvɨr məmə okotohtəu=pən?” ");
INSERT INTO tnp_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Kəni Iesu təməni=pən kəm in məmə, “Lou u in ilɨs agɨn u okotohtəu=pən təni məmə, ‘!Otətəlɨg vivi-to itəmah nətəm Isrel! Uhgɨn u in rəhatah Iərmənɨg, in əmə in Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Onəkolkeikei Uhgɨn u rəham Iərmənɨg e nɨkim rəfin, mɨne nəmiəgəhiən rəfin rəham, mɨne nətəlɨgiən rəfin rəham, mɨne nəsanəniən rəfin rəham.’ ");
INSERT INTO tnp_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kəni lou iətəm tatuərisɨg lan təni məmə, ‘Onəkolkeikei ik mɨn nəuvein təhmen=pən əmə məmə natolkeikei aru ik.’ Lou kəti tɨkə mɨn tapirəkɨs lou mil əha.” ");
INSERT INTO tnp_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kəni iəgətun əha rəha Lou təni məmə, “Iəgətun, rəham nəghatiən təhruahru. Nəməni pəhriən məmə Iərmənɨg əmə in Uhgɨn. Uhgɨn kəti mɨn tɨkə. ");
INSERT INTO tnp_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kəni okotolkeikei Uhgɨn e nɨkitah rəfin, mɨne nətəlɨgiən rəfin rəhatah, mɨne nəsanəniən rəfin rəhatah, kəni motolkeikei kitah mɨn nəuvein məmə kotolkeikei aru kitah mɨn. Təuvɨr pɨk məmə okotohtəu=pən lou mil əha tapirəkɨs nuvan əhtuviən nati miəgəh mɨne sakrifais mɨn rəfin iətəm Lou tətəni.” ");
INSERT INTO tnp_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kəni Iesu təmeh məmə rəhan nəghatiən teinatɨg pɨk, kəni təni=pən ohni məmə, “Ik nɨnuva iuəkɨr o Narmənɨgiən Rəha Uhgɨn.” Kəni uərisɨg lan, ilah rəfin kɨnotəgɨn e nətapuəh mɨniən nəghatiən ohni. ");
INSERT INTO tnp_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nian Iesu təmətəgətun nətəmimi əpəha e Nimə Rəha Uhgɨn, kəni mətətapuəh o nəghatiən kəti o lah məmə, “?Təhro iəgətun mɨn rəha Lou kotəni məmə Məsaiə u in mipɨ Kig Tefɨt? ");
INSERT INTO tnp_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Narmɨn Rəha Uhgɨn təməfən neinatɨgiən kəm Tefɨt məmə otəni məmə, ‘Iərmənɨg Uhgɨn təməni=pən kəm rəhak Iərmənɨg məmə, Əharəg u e rəhak maru, ikɨn ima nəsanəniən mɨne nɨsiaiən, mətəuarus=pən iəu iəkələs iahu rəham tɨkɨmɨr mɨn məlɨn=pən ilah əpəha ləhtəni e nəhlkəm, məmə nətarmənɨg e lah.’ ");
INSERT INTO tnp_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tefɨt aru təməni məmə Məsaiə in rəhan Iərmənɨg. ?Kəni nəmə mipɨ Tefɨt aru əmə, kəni təhro matol rəhan Iərmənɨg?” Kəni nətəmimi mɨn u kəmautətəlɨg e Iesu kəmotagiən pɨk e rəhan nəghatiən. ");
INSERT INTO tnp_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nian Iesu təmətəgətun ilah, kəni məni məmə, “Itəmah onəkotəkeikei məutətəu vivi itəmah kəni məsotohtəu-pəniən noliən mɨn rəha nəgətun mɨn rəha Lou. Ilah kotolkeikei məmə okəhuvən e napən əfəməh mɨn rəha nəfəriən məmə nətəmimi okoteruh=pən ilah lan. Kəni nɨkilah tətagiən nian nətəmimi kəutəfəri nəhlmɨ lah kəm lah e nɨsiaiən əpəha e makɨt. ");
INSERT INTO tnp_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kəni əpəha imə e nimə rəha nuhapumɨniən, kotolkeikei məmə okotəharəg aupən əpəha təuvɨr ikɨn. Kəni e nian rəha lafet, ilah kotolkeikei məmə okəhuvən motəharəg aupən ikɨn nɨsiaiən ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kəni motakləh e nimə mɨn rəha pətalɨmɨs mɨn, kəni moteiuə əmə məutəfaki əfəməh məmə okotol pəh nətəmimi kotɨsiai ilah, mətəu okəmanol nalpɨniən kəm lah tapirəkɨs.” ");
INSERT INTO tnp_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kəni Iesu təmətəharəg əpəha e Nimə Rəha Uhgɨn iuəkɨr o bokɨs kətəfən məni ikɨn, materuh nətəmimi tepət kəutəraki=pən e məni rəhalah. Kəni nətəmi rəhalah nautə tepət kəutəraki=pən e məni asoli mɨn. ");
INSERT INTO tnp_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kəni pətalɨmɨs kəti ianrah təməfən məni əkəku keiu əmə. ");
INSERT INTO tnp_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Kəni Iesu təmauɨn e rəhan mɨn nətəmimi kəhuva kəni məni məmə, “Iətəni=pɨnə kəm təmah məmə pətalɨmɨs əha ianrah pəhriən, mətəu təməraki=pən e məni asoli tapirəkɨs rəha nətəmimi mɨn rəfin. ");
INSERT INTO tnp_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ilah kəmotəraki=pən e rəhalah məni, mətəu tepət mɨn əpəha lahuənu. Mətəu pətalɨmɨs u iətəm in ianrah pəhriən, in təməfən rəfin məni rəhan o nosiən nəhmtɨ nɨgɨn nauəniən, kəni tɨkə mɨn əha ikɨn.” ");
INSERT INTO tnp_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nian Iesu təmatiet e Nimə Rəha Uhgɨn, kəni rəhan kəti nətəmi tueləf təməni=pən ohni məmə, “!Iəgətun, afu-to kəpiel asoli mɨn mɨne nimə mɨn kotəuvɨr!” ");
INSERT INTO tnp_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Kəni mətəu Iesu təni məmə, “Itəmah nauteh natimnati mɨn əha, mətəu nian otətuva iətəm nimə mɨn əha, nətəmimi okotoharəg-rəg kəpiel mɨn e lah. Ko kəpiel kəti təsəməhliən e nɨmein.” ");
INSERT INTO tnp_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Uərisɨg lan, Iesu təmuvən mətəharəg əpəha e Nɨtəuət Rəha Nɨgi U Olif ikɨn kəhrun neruhiən Nimə Rəha Uhgɨn e nɨtəni=pən. Kəni Jemɨs, Jon, Pitə mɨne Antɨru kəməhuva ohni ilah pɨsɨn əmə. ");
INSERT INTO tnp_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Kəni kəmotətapuəh ohni məmə, “?Əni-to məmə natimnati mɨn əha okəhuva nəhgɨn? ?Kəni nəmtətiən əhro u otol pəh iəkotəhrun məmə tɨnol nian əhruahru əha rəueiu rəha natimnati mɨn əha?” ");
INSERT INTO tnp_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Kəni Iesu təməni=pən kəm lah məmə, “Onəutətəu vivi itəmah o nətəmimi, məsotegəhaniən məmə koteiuə e təmah. ");
INSERT INTO tnp_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kəni mətəu nətəmimi tepət okəpanəhuva e nərgək, kəti otəni məmə in Məsaiə, kəti otəni məmə in, kəni moteiuə e nətəmimi tepət. ");
INSERT INTO tnp_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Kəni nəmə nəkotətəu məmə nətəmimi nəuvein kəutəməu əpəha iuəkɨr o təmah, kəni motətəu mɨn nəuvein mɨn əpəha isəu kautoh ilah mɨn, mətəu nəgənməpɨtəmah otəsəgɨniən. Natimnati mɨn əha okotaupən məhuva pəhriən, mətəu səniəmə naunun nian əha tɨnətuva. ");
INSERT INTO tnp_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nɨtəni asoli mɨn okotəluagɨn, kəni kəntri mɨn okotoh mɨn ilah mɨn, kəni nəmig asoli otəlauəl ikɨn mɨn rəfin, kəni nəumɨs asoli otus nətəmimi; mətəu natimnati mɨn əha nətuəuiniən əmə rəha nahməiən iətəm otəmanuva, kotəhmen əmə e pətan iətəm təmol nərfɨn, kəni mɨnətuəuin mətətəu nahməiən məmə otəsuvəhiən temək. ");
INSERT INTO tnp_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Onəutətəu vi itəmah. Okələs itəmah kan nəkotəhtul e nəhmtɨ kaunsɨl, kəni okoh itəmah əpəha imə e nimə rəha nuhapumɨniən mɨn, kəni onəkotəhtul aupən e kig mɨn mətəu-inu rəhak mɨn u nətəmimi itəmah. Kəni onəkotəni pətɨgəm iəu kəm lah. ");
INSERT INTO tnp_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mətəu okaupən kəni pətɨgəm Nanusiən Təuvɨr kəm nətəmimi ikɨn mɨn rəfin ko, kəni naunun nian təmanuva. ");
INSERT INTO tnp_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Nəmə kəhuva motələs itəmah kətan məmə onəkotəhtul e kaunsɨl, kəni nɨkitəmah təsəhti pɨkiən məmə onəkotəni nak. E nian əhruahru əha, onəkotəni pətɨgəm əmə nəghatiən u Uhgɨn otəfɨnə kəm təmah, mətəu-inu nəghatiən u onəkotəni, səniəmə rəhatəmah nəghatiən, mətəu rəha Narmɨn Rəha Uhgɨn otəfɨnə. ");
INSERT INTO tnp_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Nətəmimi okotegəhan=pən e pialah əhruahru mɨn kəm rəhalah tɨkɨmɨr mɨn məmə okotohamu ilah, kəni tatə mɨn okotol mɨn lanəha kəm nenətɨlah əhruahru mɨn, kəni kəlkələh mɨn okotəhtul motol noliən əhmen mɨn əmə kəm rəhalah tatə mɨne mamə mɨn məmə okotohamu ilah. ");
INSERT INTO tnp_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nətəmimi rəfin okotəməki e təmah o nərgək. Mətəu iətəmi otəhtul əskasɨk mətəuarus=pən natimnati mɨn əha okotol naunun, kəni Uhgɨn otosmiəgəh.” ");
INSERT INTO tnp_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Nian əha, onəkoteruh ‘nati iətəm Uhgɨn tətəməki lan əpəha e Nimə Rəha Uhgɨn, kəni nati u tatol Nimə Rəha Uhgɨn təsasimiən.’ (Iətəmi tətafin nəghatiən u, in otəkeikei məsal lan məhrun nɨpətɨn.) Kəni e nian əha, nətəm Jutiə okotəkeikei motaiu motagɨm=pən e nɨtəuət mɨn. ");
INSERT INTO tnp_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Iətəmi tətəmeig ihluə e rəhan nimə ko təsuvən mɨniən e nɨpəgnəua nimə məmki rəhan natimnati. Otaiu əmə magɨm. ");
INSERT INTO tnp_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nəmə iətəmi tətasum, kəni ko təsuvəniən lahuənu o rəhan napən mos. Otaiu əmə magɨm. ");
INSERT INTO tnp_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","“!Kəsi! Nahməiən asoli o nɨpətan nətəm kəmotol nərfɨlah mɨne nɨpətan kəutəfən nah kəm nəpəou mɨn. E nian əha okotos pɨk nahməiən. ");
INSERT INTO tnp_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Otəfaki əsanən kəm Uhgɨn məmə natimnati mɨn əha okəsəhuvaiən e nian rəha nətəpuiən, inəha nian rəha nɨmətagi asoli mɨne nuhuən mɨne, ");
INSERT INTO tnp_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","mətəu-inu e nian əha, nahməiən asoli kəseruh əhanəhiən kəti mɨne tol lanəha e nian Uhgɨn təmətuəuin mol natimnati mətəuarus=pa u rəueiu mɨne. Kəni okəseruh mɨniən nahməiən asoli kəti tol mɨn lanəha. ");
INSERT INTO tnp_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mətəu Uhgɨn təmətei əkuəkɨr nian əha. Nəmə təməsətei əkuəkɨriən, kəni ko iətəmi kəti təsəmiəgəhiən. In təmətei əkuəkɨr rəkɨs nian əha o rəhan mɨn nətəmimi nətəm tɨnɨtəpɨn rəkɨs ilah məmə rəhan mɨn. ");
INSERT INTO tnp_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“E nian əha, nəmə iətəmi kəti otəni məmə, ‘!Afu-to Məsaiə əpəha!’ uə ‘!Afu-to in əpə!’ mətəu onəsotəhatətəiən lan. ");
INSERT INTO tnp_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Onəsotəhatətəiən lan mətəu-inu, Məsaiə eiuə nəuvein, mɨne iəni eiuə mɨn, ilah okəhuva motol nəmtətiən mɨn mɨne nati apɨspɨs mɨn. Nəmə ilah kotəhrun noliən, okotalkut məmə okotiuvi rəkɨs nətəmimi mɨn u nətəm Uhgɨn təmɨtəpɨn rəkɨs ilah. ");
INSERT INTO tnp_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","!O natimnati mɨn əha, onəkotətəu! Mətəu iəmaupən rəkɨs məni pətɨgəm rəfin natimnati mɨn əha kəm təmah.” ");
INSERT INTO tnp_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Kəni e nian nahməiən asoli əha otɨkə, ‘kəni mɨtɨgar otəpɨs, kəni məuɨg otəsasiəiən, ");
INSERT INTO tnp_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","kəni məhau mɨn e neai okotəmei kəni natimnati asoli mɨn ikɨn e neai okotəlauəl.’ ");
INSERT INTO tnp_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kəni nətəmimi okotafu iəu Nətɨ Iətəmimi oiəkuva e nəpuə e rəhak nəsanəniən mɨne nepətiən əhagəhag asoli rəhak iətəm otasiəgəpɨn rəfin iəu. ");
INSERT INTO tnp_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Kəni e nian əha, iəkahli=pən nagelo mɨn rəhak kəhuvən motəmki nətəmi mɨn u Uhgɨn təmɨtəpɨn ilah məhuva motoriarun əmə ilah kətiəh. Nagelo mɨn okəhuvən e nətəni mɨn rəfin agɨn e nəhue nɨftəni məmə okotəmki ilah. ");
INSERT INTO tnp_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Nɨkitəmah otəkeikei mətəhti nɨgi u fik. Nian əhruahru iətəm nəhlmɨn mɨn kɨnəutətuəuin mauteviə, kəni nɨmalɨn mɨn kɨnəutapɨlpɨl, itəmah nəkotəhrun məmə nian əha inəha iətəm nəkotasum lan rəhatəmah. ");
INSERT INTO tnp_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kəni e noliən əhmen mɨn əmə, nian nəkoteruh məmə natimnati mɨn u kɨnəutəhuva, kəni nəkotəhrun əmə məmə otəsuvəhiən agɨn iəkuva mɨn. ");
INSERT INTO tnp_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","“Iatəni pəhriən kəm təmah məmə nətəmimi nətəm kəutatɨg u rəueiu, ko kəsohmɨs rəfiniən mətəuarus natimnati mɨn əha okəhuva motol nɨpəhriəniən lan. ");
INSERT INTO tnp_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Neai mɨne nɨftəni okiakə, mətəu nəghatiən mɨn rəhak ko kəsohkəiən. ");
INSERT INTO tnp_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Iətəmi kəti təsəhruniən nian uə auə əhruahru rəha natimnati mɨn əha. Nagelo mɨn əpəha e neai kotəruru, kəni iəu mɨn Nətɨ Iətəmimi iəkəruru. Mətəu Tatə Uhgɨn əmə in təhrun nian əhruahru əha. ");
INSERT INTO tnp_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Onəutətəu vivi itəmah məutair, mətəu-inu itəmah nəkotəruru nian əha rəhak oiəkuva lan məmə otuva nəhgɨn. ");
INSERT INTO tnp_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Otəhmen e iətəmi asoli kəti tatuvən məmə otaliuək əpəha ikɨ pɨsɨn kəti, kəni məlɨn rəhan mɨn noluək məmə okəutatɨg o rəhan mɨn natimnati, kəni məfən rəhalah mɨn uək kətiəh kətiəh. Kəni məni=pən kəm iətəmi e namtɨhluə məmə otətair. ");
INSERT INTO tnp_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Kəni itəmah onəutatɨg məutair məutəsal mətəu-inu itəmah nəkotəruru nian iətəmi asoli rəha nimə u otuva lan. Kəruru məmə otuva ləhnaiuv, uə o lapɨn, uə o fətukai tɨnətəri, uə mɨtɨgar tɨnətəri. ");
INSERT INTO tnp_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kəruru, kəmə təhro otuva ueiuəhai əmə. !Təsəuvɨriən məmə nəkotapɨli nian in otuva! ");
INSERT INTO tnp_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","!Mətəu nəghatiən mɨn u iətəm iətəni=pɨnə kəm təmah, iətəni mɨn kəm nətəmimi mɨn rəfin məmə okəutair məutəsal!” ");
INSERT INTO tnp_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nian keiu əmə əha ikɨn kəmanol lafet mil lan rəha Pasova mɨne Pɨret U Is Tɨkə Lan. Kəni pris asoli mɨn, mɨne nəgətun mɨn rəha Lou kəməutəsal e suaru o Iesu məmə okotələs oneuən motohamu. ");
INSERT INTO tnp_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kəni kotəni məmə okəsotoliən e nian rəha lafet mətəu-inu məta nɨmənin nətəmimi okotorgəhu nəmə kotəhrun məmə kəmotol nati kəti tərah kəm Iesu. ");
INSERT INTO tnp_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kəni Iesu təmətatɨg əpəha Petəni ima Saimon u leprosi təmatol aupən. Nian təmətauən, kəni pətan kəti təmos səntə kəti təməri e pətəl u kəmol e kəpiel iətəm nəhmtɨn tiəkɨs, kətəni məmə alapastə. Səntə u, nəmiəvɨn təuvɨr, kəni nəhmtɨn tiəkɨs, kəmol e nokɨ nard, nɨgi kəti. Kəni pətan əha təməhti rəkɨs, məueiu rəhn-kapə Iesu e səntə əha. ");
INSERT INTO tnp_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kəni nətəmimi nəuvein kəməutəharəg əha ikɨn, niəməha təmol ilah, kəni mautəni=pən kəm lah mɨn məmə, “?Təhro tətərəkɨn səntə? ");
INSERT INTO tnp_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","!Nəmə tol səlɨm lan təhrun nosiən məni asoli təhmen e tri-hanrɨt tənariəs, məhrun nəfəniən kəm nanrah mɨn!” Kəni məutahi pətan u. ");
INSERT INTO tnp_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mətəu Iesu təni məmə, “!Otəpəh-tə! ?Nəutahi onak? In təmol nati təuvɨr kəm iəu. ");
INSERT INTO tnp_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nian mɨn rəfin itəmah nanrah mɨn nəutatɨg, kəni nəmə nəkotolkeikei, nəkotəhrun nasiruiən e lah. Mətəu iəu iəsatɨgiən nian rəfin kitah min itəmah. ");
INSERT INTO tnp_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Pətan u təmol nati u in təhrun. Təməueiu nɨpətɨk məmə otol əpenə-penə o nian okɨtənɨm iəu. ");
INSERT INTO tnp_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Iətəni pəhriən kəm təmah məmə, ikɨn mɨn rəfin okətanus pətɨgəm Nanusiən Təuvɨr, kəni okətanus mɨn nati u pətan u təmol məmə okəsaluiən lan.” ");
INSERT INTO tnp_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kəni Jutəs Iskariot in e nətəmi tueləf rəha Iesu, təmuvən meruh pris asoli mɨn məmə otegəhan=pən e Iesu kəm lah. ");
INSERT INTO tnp_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nian kəmotətəu rəhan nəghatiən, kəni kəmotagiən ohni, motəni məmə okəmanotəfən məni kəm in. Kəni Jutəs təmətəhtahnin əmə nian təuvɨr məmə otuva kəni tegəhan e Iesu lan kəm lah. ");
INSERT INTO tnp_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nian tɨnuva o noliən lafet rəha Pɨret U Is Tɨkə Lan, kəni kɨnatətuəuin noliən lafet, kəni noliən rəhalah katoh sipsip o lafet rəha Pasova. E nian əha, nətəmimi mɨn rəha Iesu kəməhuva ohni motəni məmə, “?Nəkolkeikei məmə iəkəhuvən iə motol əpenə-penə ikɨn məmə onəkol lafet ikɨn rəha Pasova?” ");
INSERT INTO tnp_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kəni Iesu təmahli=pən rəhan keiu iətəmimi mil məmə, “Onəkian əha taun mueruh iətəmi kəti tətaharu pəri pətəl asoli kəti təmətu=pən nəhu lan, kəni nəkuɨtəu=pən. ");
INSERT INTO tnp_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Əpəha e nimə iətəm tatuvən=pən ikɨn, kəni nəkuətapuəh o iətəmi asoli rəha nimə ko məmə, ‘?Iəgətun təni məmə nəuan u in pəhruvən məmə itɨmah in, mɨne rəhan mɨn nətəmimi iəkotauən ikɨn e lafet rəha Pasova?’ ");
INSERT INTO tnp_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kəni in otəgətun nəuan asoli u in ilɨs agɨn kɨnəlɨn vivi rəkɨs natimnati ikɨn. Onəkian əmə muol nɨgtah ikɨn nauəniən.” ");
INSERT INTO tnp_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kəni kəmian e taun mueruh natimnati təhmen=pən əmə məmə inu Iesu təməni mɨne. Kəni ilau kəmuol əpenə-penə nauəniən ikɨn məmə rəha lafet rəha Pasova. ");
INSERT INTO tnp_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tɨnəhnaiuv, Iesu mɨne rəhan mɨn nətəmimi tueləf kəməhuva, ");
INSERT INTO tnp_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","məutauən e tepɨl. Iesu təməni=pən kəm lah məmə, “Iətəni pəhriən kəm təmah məmə itəmah kəti u ikɨnu rəueiu kəutauən pəti kitah min, otegəhan=pən lak kəm rəhak mɨn tɨkɨmɨr.” ");
INSERT INTO tnp_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kəni rəhan mɨn nətəmimi nɨkilah təməpəou agɨn, kəni məutətapuəh kətiəh kətiəh ohni məmə, “?Ei, Iərmənɨg, pəh u? !?Iəu!?” ");
INSERT INTO tnp_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Kəni Iesu təməni=pən kəm lah məmə, “Itəmah əmə kəti u nətəmi tueləf u in tətəuveri pəti pɨret e dis kətiəh matun. ");
INSERT INTO tnp_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kəni iəu Nətɨ Iətəmimi oiəkəkeikei mɨmɨs məmə inu Nauəuə Rəha Uhgɨn təməni lak mɨne, mətəu kəsi o iətəmi u iətəm tatol kəuɨt kəsuə iətəm otegəhan=pən lak Nətɨ Iətəmimi. !Təməuvɨr əmə məmə in təməsair=paiən!” ");
INSERT INTO tnp_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","E nian kəməutauən, Iesu təmos pɨret məfaki məni tagkiu ohni kəm Uhgɨn, kəni məhapu məfən kəm lah məni məmə, “Otos, inu nɨpətɨk.” ");
INSERT INTO tnp_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Matɨg mos mɨn kap wain məfaki məni tagkiu ohni kəm Uhgɨn, məfən kəm lah, kəni ilah rəfin kəmotəmnɨm=pən lan. ");
INSERT INTO tnp_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kəni təməni=pən kəm lah məmə, “Inu nɨrak iətəm tatol məmə nəniəskasɨkiən rəha nasiruiən in tətəhtul mətəmiəgəh. Nɨrak u otaiu o nətəmimi tepət məmə otafəl rəkɨs rəhalah təfagə tərah mɨn. ");
INSERT INTO tnp_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Iətəni pəhriən kəm təmah məmə oiəsəmnɨm mɨniən wain u mətəuarus=pən oiəmanəmnɨm mɨn ikɨn Uhgɨn otarmənɨg ikɨn.” ");
INSERT INTO tnp_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kəni kəmotani nəpuən əfaki kəti, uərisɨg kohiet məhuvən əpəha e Nɨtəuət Rəha Nɨgi U Olif. ");
INSERT INTO tnp_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kəni Iesu təməni=pən kəm lah məmə, “Itəmah rəfin u onəpanotagɨm motəpəh iəu mətəu-inu Nauəuə Rəha Uhgɨn tɨnəni rəkɨs aupən məmə Uhgɨn otəmanoh iətəmi rəha nəsaliən e sipsip mɨn, kəni sipsip mɨn okotaiu kətiəh kətiəh. ");
INSERT INTO tnp_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Mətəu nian iəkəmiəgəh mɨn e nɨmɨsiən, iəkaupən muvən əpəha Kaləli, kəni itəmah nəmanəhuərisɨg.” ");
INSERT INTO tnp_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Mətəu Pitə təni məmə, “Nati əpnapɨn ilah rəfin okotagɨm rəkɨs lam, mətəu iəu əmə ko iəsagɨm rəkɨsiən lam.” ");
INSERT INTO tnp_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Kəni Iesu təməni=pən kəm in məmə, “Iətəni pəhriən kəm ik məmə o lapɨn əmə u, nian mənɨg otəsəkakə əhanəhiən mau keiu, kəni ik onəkəni mau kɨsɨl məmə nəkəruru iəu.” ");
INSERT INTO tnp_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mətəu Pitə təməni əskasɨk məmə, “Nati əpnapɨn iəkəkeikei mɨmɨs kilau mɨn ik, ko iəsəniən məmə iəkəruru ik.” Kəni rəhan rəfin nətəmimi kotəni mɨn təhmen e Pitə. ");
INSERT INTO tnp_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kəni lapɨn kəməhuvən əpəha ikɨn kəti nərgɨn u Ketsəməni, kəni Iesu təməni=pən kəm lah məmə, “Otəharəg u ikɨn u, pəh iəkuvən məfaki.” ");
INSERT INTO tnp_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kəni mit Pitə, Jemɨs mɨne Jon məhuvən, kəni nɨkin tɨnətahmə pɨk, kəni tɨnətəu tərah agɨn. ");
INSERT INTO tnp_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kəni təni məmə, “Nɨkik tətahmə pɨk, kəni iuəkɨr iəkɨmɨs lan. Ələharəg u ikɨnu kəni məhlair əmə.” ");
INSERT INTO tnp_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kəni muvən mɨn nəuvetɨn meiuaiu məmei e nɨftəni mətəfaki məmə, “Nəmə suaru kəti mɨn əha ikɨn, pəh nian əfɨgəm u otəsuvaiən ohniəu.” ");
INSERT INTO tnp_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kəni mətəfaki məmə, “Apə,” (u nɨpətɨn u təni məmə rəhak tatə), “ik nəkəhrun noliən natimnati mɨn rəfin. Əui, os rəkɨs nahməiən mɨn u iətəm okəmanəhuva. Mətəu nəsoliən rəhak nətəlɨgiən, mətəu ol nati nak iətəm ik əmə nəkolkeikei.” ");
INSERT INTO tnp_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kəni mɨtəlɨg=pa. Mətəu rəhan iətəmimi milahal kəhlapɨli. Kəni təni=pən kəm Pitə məmə, “?Saimon, nətapɨli, uə? ?Təhro nəsairiən-to auə kətiəh əmə?” ");
INSERT INTO tnp_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kəni məni=pən kəm lahal məmə, “Onəklair məhləfaki maleh vivi məmə onəsləmei-pəniən e nəfeifeiən. Nɨkitəmahal tolkeikei, mətəu nɨpətɨtəmahal təpəou.” ");
INSERT INTO tnp_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kəni təməpəh mɨn ilahal, mɨtəlɨg=pən mɨn mətəfaki mətəni əmə nati kətiəh. ");
INSERT INTO tnp_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kəni mɨtəlɨg=pa mɨn, mətəu kɨnlapɨli mɨn, mɨnləruru nairiən, kəni mɨnləruru məmə okɨhləni=pən nak kəm in. ");
INSERT INTO tnp_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Təmuvən mɨn kəni mɨtəlɨg=pa mau kɨsɨl, mətəu kəhlapɨli, kəni təməni=pən kəm lahal məmə, “?Nəhlapɨli əhanəh məhləmeig? !Nəhmen! Nian tɨnuva məmə iəu Nətɨ Iətəmimi okegəhan=pən lak e nəhlmɨ nətəm nol təfagə tərah. ");
INSERT INTO tnp_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","!Ɨhləhtul-tə, kautəhuvən! Lahfu-to, iətəmimi u tətegəhan=pən lak e nəhlmɨ tɨkɨmɨr mɨn, əpəha tətuva.” ");
INSERT INTO tnp_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Iesu təmətəghati əhanəh, kəni Jutəs in e nətəmi tueləf rəhan mɨn tətaupən e nɨmənin nətəmimi. Nəuvein kotəmki nau rəha nəluagɨniən, mɨne neim məhuva. Nətəmi mɨn u, pris asoli mɨn, mɨne nəgətun mɨn rəha Lou, mɨne nətəmi asoli rəha nətəm Isrel kəmotahli=pa ilah. ");
INSERT INTO tnp_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Iətəmi u tətegəhan e Iesu kəm lah təməni rəkɨs kəm lah məmə, “Iətəmi əha iəkol nəmtətiən kəti rəha nolkeikeiən lan, nəkotəhrun əmə məmə iətəmi əha in əha. !Nəkotaskəlɨm motos məhuvən motaskəlɨm vivi!” ");
INSERT INTO tnp_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kəni əmeiko Jutəs təmuva iuəkɨr o Iesu, kəni məni məmə, “Iəgətun,” kəni mol nəmtətiən rəha nolkeikeiən lan. ");
INSERT INTO tnp_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kəni nətəmimi mɨn əha kəməhuva motaskəlɨm tiəkɨs. ");
INSERT INTO tnp_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mətəu ilah kəti rəha Iesu təmatəhtul iuəkɨr o lah təmeuvi nau rəha nəluagɨniən e nɨmein maut-aut əmeiko mauəh e nau mohatuv rəkɨs matəlgɨ ioluək kəti lan rəha pris asoli agɨn. ");
INSERT INTO tnp_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kəni Iesu təni məmə, “?Təhro nəutəmki nau asoli rəha nəluagɨniən mɨne neim məutəhuva məmə onəkotələs iəu? ?Nɨkitəmah təhti məmə iəu iohamu itəmi kəti matol nəluagɨniən o nələs iahuiən kəpmən, uə? !Kəpə! ");
INSERT INTO tnp_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nian mɨn rəfin kitah min itəmah əpəha e Nimə Rəha Uhgɨn iətəgətun nətəmimi ikɨn. ?Kəni nəkotəhro məsotaskəlɨmiən iəu? Mətəu nati Nauəuə Rəha Uhgɨn təməni otəkeikei muva mol nɨpəhriəniən lan.” ");
INSERT INTO tnp_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kəni rəhan mɨn rəfin nətəmimi kɨnotəpəh in, kəni motagɨm. ");
INSERT INTO tnp_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kəni iətəm aluə kəti iətəm təməlkahu əmə e napən kəti matuərisɨg e Iesu, kəni nətəmimi nəuvein kəmotələs, motəmkarəpən lan, ");
INSERT INTO tnp_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","kəni rəhan napən tɨtɨs, taiu piəpiə əmə magɨm. ");
INSERT INTO tnp_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kəni tətapinəpu əhanəh, kəmotos Iesu məhuvən əpəha ima pris asoli agɨn u kətuhapumɨn rəfin pris asoli mɨn, mɨne nəgətun mɨn rəha Lou, mɨne nətəmi asoli rəha nətəm Isrel ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Kəni Pitə tətan təlɨg-təlɨg matuərisɨg e lah muvən əpəha lahuənu ima pris asoli agɨn ikɨn. Kəni təmuvən əpəha e iat mətəharəg ilah soldiə mɨn rəha pris asoli agɨn mətətogəm e nɨgəm. ");
INSERT INTO tnp_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kəni pris asoli mɨn mɨne nətəmimi rəfin rəha kaunsɨl kəməutəsal e nəniən mɨn nəuvein rəha Iesu məmə okotohamu ohni. Mətəu kəsotehiən kəti mɨne. ");
INSERT INTO tnp_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kəni nətəmimi tepət kəmoteiuə e Iesu, mətəu rəhalah nəghatiən tətaiu pɨsɨn pɨsɨn. ");
INSERT INTO tnp_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kəni nəuvein kotəhtul moteiuə lan məmə, ");
INSERT INTO tnp_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Iəmətəu təməni məmə otərəkɨn Nimə Rəha Uhgɨn u nətəmimi əmə kəmotol e nəhlmɨlah. Mətəu e nian tatol kɨsɨl lan, təmanuvləkɨn mɨn nɨtain u kəsoliən e nəhlmɨtəmi.” ");
INSERT INTO tnp_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kəmotəni lanəha mətəu ilah mɨn, rəhalah nəghatiən tətaiu pɨsɨn pɨsɨn. ");
INSERT INTO tnp_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kəni pris asoli agɨn təməhtul aupən e lah kəni məni=pən kəm Iesu məmə, “?Təhro nəsəghatiən? ?Təhro e nəghatiən mɨn əha iətəm kautəni pətɨgəm tətələs pɨkɨn ik?” ");
INSERT INTO tnp_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mətəu Iesu təpnapɨn əmə məsəghatiən. Kəni pris asoli agɨn əpəha təməni=pən mɨn məmə, “?Təhro? ?Ik Məsaiə u Nətɨ Iətəmi kətəni-vivi?” ");
INSERT INTO tnp_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Kəni Iesu təni məmə, “!Əuəh, iəu u! Onəpanoteruh iəu Nətɨ Iətəmimi iətəharəg e nəven maru rəha Uhgɨn u iətəm rəhan nəsanəniən iahgin, kəni manoteh mɨn iəu e nəpuə e neai iətuva.” ");
INSERT INTO tnp_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kəni pris asoli agɨn tearɨs rəhan napən mɨn mətəu-inu in tolkeikei məgətun kəm nətəmimi məmə nɨkin təmərah o nəghatiən rəha Iesu, kəni məni məmə, “Okəsotəsal mɨniən iətəmi kəti məmə otəni mɨn nati kəti lan. ");
INSERT INTO tnp_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","!Nɨnotətəu rəkɨs tətəghati rah e Uhgɨn! ?Nəutəhrətəlɨg? ?Okotəhro e suah u?” Kəni ilah rəfin kəmotəni məmə otəkeikei mɨmɨs. ");
INSERT INTO tnp_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kəni kəmotol əuvsan Iesu, kəni nəuvein kəmotagəh lan, nəuvein kotəlis nəhmtɨn motoh kəni motəni məmə, “!Ei, ik iəni rəha Uhgɨn! !Əni-to məmə pəh u təmoh ik!” Kəni soldiə mɨn rəha pris asoli agɨn kəmotem. ");
INSERT INTO tnp_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kəni Pitə təmətan əhanəh əpəha ləhtəni e iat. Kəni pətan mɨtə kəti u in ioluək rəha pris asoli agɨn təmuva. ");
INSERT INTO tnp_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Kəni mafu tətətogəm e nɨgəm, kəni təmeruh mətɨg Pitə kəni məni məmə, “Ik mɨn itəlau Iesu iətəm Nasərɨt nəmətuan.” ");
INSERT INTO tnp_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mətəu Pitə təmeiuə, kəni məni məmə, “Iəkəruru nati ko nətəni,” kəni muvən mətəhtul əpəha e ket rəha iat. Kəni mənɨg kəti təkakə. ");
INSERT INTO tnp_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kəni pətan əha təmeruh mɨn in ikɨn əha, kəni məni=pən kəm nətəm kəutəhtul əha ikɨn məmə, “Suah u in mɨn in ilah kəti.” ");
INSERT INTO tnp_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mətəu Pitə təmeiuə mɨn. Kəni təsuvəhiən, nətəmimi nətəm kəutəhtul əha ikɨn əha kəmotəni=pən mɨn kəm in məmə, “Nɨpəhriən, ik mɨn ilah kəti mətəu-inu iəkotəhrun məmə ik iətəm Kaləli.” ");
INSERT INTO tnp_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Mətəu Pitə təməni məmə, “Nəmə iəteiuə, pəh Uhgɨn otol nalpɨniən əskasɨk kəm iəu,” kəni mos mɨn nonauvɨl məmə, “!Iəkəruru suah kəha nəutəni!” ");
INSERT INTO tnp_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kəni rəueiu agɨn mɨn mənɨg təkakə mɨn, kəni nɨkin təhti nəghatiən rəha Iesu məmə, “Mənɨg otəsəkakə əhanəhiən mau keiu, kəni ik onəkəni mau kɨsɨl məmə nəkəruru iəu.” Kəni Pitə tɨnətəu tərah əmeiko mətasək. ");
INSERT INTO tnp_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kəni ləplapɨn agɨn pris asoli mɨn, mɨne nətəmi asoli rəha nətəm Isrel, mɨne nəgətun mɨn rəha Lou, mɨne nətəmimi mɨn rəfin rəha kaunsɨl kəmotuhapumɨn ilah mɨn, kəni mautələhu nəghatiən məmə okotohamu Iesu. Kəmotəni=pən kəm nətəmimi nəuvein məmə okotəlis Iesu kəni motit məhuvən motəhlman=pən lan e nəhlmɨ Pailət, u kəpmən asoli rəhalah. ");
INSERT INTO tnp_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Kəni Pailət təmətapuəh ohni məmə, “?Ik kig rəha nətəm Isrel?” Kəni mətəu Iesu təni məmə, “Ik nətəni məmə tol lanko.” ");
INSERT INTO tnp_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kəni pris asoli mɨn kəmotəni pətɨgəm noliən tepət lan. ");
INSERT INTO tnp_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kəni Pailət təmətapuəh ohni məmə, “?Təhro nəsuhalpɨniən? ?Nəmətəu kəmotəni pətɨgəm nɨpəgnəmtɨn tepət lam?” ");
INSERT INTO tnp_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mətəu Iesu təsəghati mɨniən, məpnapɨn əmə, kəni Pailət narmɨn təmiuvɨg ohni. ");
INSERT INTO tnp_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","E nu mɨn rəfin, nian katol lafet lan rəha Pasova, noliən rəha kəpmən u Pailət məmə in otahli pətɨgəm iətəmi kəti e kaləpus iətəm nətəm Isrel kəmotəni. ");
INSERT INTO tnp_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kəni suah kəti, nərgɨn u Parəpəs, tətatɨg e kaləpus ilah in mɨn nəuvein, mətəu-inu kəmotohamu iətəmimi e nian kəməutəluagɨn ilah kəpmən. ");
INSERT INTO tnp_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kəni nɨmənin nətəmimi kəməhuva o Pailət motəni=pən kəm in məmə otol əmə nati kətiəh təhmen=pən e iətəm tatol nian mɨn, mahli pətɨgəm iətəmi kəti e kaləpus. ");
INSERT INTO tnp_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Kəni Pailət təmətapuəh o lah məmə, “?Nəkotolkeikei məmə iəkahli pətɨgəm kig rəha nətəm Isrel?” ");
INSERT INTO tnp_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Təməni lanəha mətəu-inu in tɨnəhrun rəkɨs məmə pris asoli mɨn kəmotəfən Iesu e nəhlmɨn mətəu-inu kautetet. ");
INSERT INTO tnp_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mətəu pris asoli mɨn kəmotəkeikei kəm nɨmənin nətəmimi məmə okotəuhlin nətəlɨgiən rəhalah. Kəni ilah kəmotətapuəh o Pailət məmə otahli pətɨgəm Parəpəs, mətəu səniəmə Iesu. ");
INSERT INTO tnp_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kəni Pailət təmətapuəh o lah məmə, “?Mətəu iəkəhro e suah u itəmah nəmotəni məmə in kig rəha nətəm Isrel?” ");
INSERT INTO tnp_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kəni kəmotagət əfəməh məmə, “!Okətu-pəri e nɨgi kəməluau!” ");
INSERT INTO tnp_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Kəni Pailət təmətapuəh mɨn o lah məmə, “?O nak? ?Noliən tərah nak u suah u təmol?” Mətəu kəmotagət əfəməh mɨn məmə, “!Okətu-pəri e nɨgi kəməluau!” ");
INSERT INTO tnp_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kəni Pailət təmolkeikei məmə otol nɨkilah, kəni mahli pətɨgəm Parəpəs, kəni məhlman=pən e Iesu e nəhlmɨ rəhan soldiə mɨn məmə okotalis kəni motətu-pəri e nɨgi kəməluau. ");
INSERT INTO tnp_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kəni soldiə mɨn rəha Pailət kotələs Iesu məhuvən əpəha imə e nimə asoli rəha kəpmən, kətəni məmə Praetoriəm. Kəni kəmotauɨn rəfin e soldiə mɨn kəhuva mohtəlau lan. ");
INSERT INTO tnp_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kəni məhuvən=pən e kot ərarəuv təhmen əmə e kot rəha kig, kəni motuerin-uerin nɨləuɨs iətəm tol nihlɨn nihlɨn motol kəfəfau lan iətəm təhmen e kəfəfau rəha kig, kəni motəfəfau=pən lan kəm in. ");
INSERT INTO tnp_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kəni motol mɨrə kəni məutəuvsan lan məutəni məmə, “Itɨmah iəkotəfɨnə nɨsiaiən kəm ik, kig rəha nətəm Isrel.” ");
INSERT INTO tnp_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kəni motoh rəhn-kapə e nəuanɨgi, motagəh lan, motasiəulɨn e nəulɨlah məutəfən nɨsiaiən eiuə kəm in. ");
INSERT INTO tnp_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nian kəmotol əuvsan rəkɨs lan, kəni motəpeg rəkɨs kot ərarəuv əha, kəni məhuvən=pən əhanəh e rəhan napən, kəni motit məhuvən məmə okotətu-pəri e nɨgi kəməluau. ");
INSERT INTO tnp_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nian əha, e suaru, kəmoteruh suah kəti iətəm Sairəni, nərgɨn u Saimon. (In tatə rəha Aleksantə mɨne Rufəs.) Tatuvən Jerusɨləm, kəni kotəkeikei kəm in məmə otələs nɨgi kəluau. ");
INSERT INTO tnp_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kəni kəmotit Iesu məhuvən əpəha ikɨn kəti kətəni məmə, Kolkotə, u nɨpətɨn təni məmə Louipɨl-uipɨl. ");
INSERT INTO tnp_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kəni kəmotəfən wain u kəmol fɨləh-fɨləh ilau mərsɨn u mɨr məmə otəmnɨm pəh təsətəuiən nahməiən e nɨpətɨn, mətəu təpəh nəmnɨmiən. ");
INSERT INTO tnp_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kəni kəmotələs Iesu məhuvən motətu-pəri e nɨgi kəməluau. Kəni motəuəri rəhan napən moturin tais ohni məmə pəh otos. ");
INSERT INTO tnp_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kəmotətu-pəri Iesu e nɨgi kəməluau e nain klok ləplapɨn, ");
INSERT INTO tnp_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","kəni motətei rəkɨs nɨpəgnəmtɨn u kəmoteh lan məmə, In kig rəha nətəm Isrel kəni motəhti=pən nəghatiən u e rəhan nɨgi kəməluau. ");
INSERT INTO tnp_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kəni iətəmimi mil keiu iətəm kətuəluagɨn kəm kəpmən matuoh nətəmimi, kəmətu-pəri ilau e nɨgi kəməluau, kəti e nɨkalɨn maru, kəti e nɨkalɨn məuɨl. ");
INSERT INTO tnp_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Kəni nətəmimi nətəm kəutaliuək e suaru, məuturin-urin rəhn-kapə lah kəm in məutəuvsan lan məutəni məmə, “Ei, ik nəməni məmə onəkərəkɨn Nimə Rəha Uhgɨn kəni nian tatol kɨsɨl lan, nəmanuvləkɨn mɨn in pɨsɨn. ");
INSERT INTO tnp_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","!Eiuaiu-to e nɨgi kəməluau ko, mosmiəgəh aru-to ik!” ");
INSERT INTO tnp_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Pris asoli mɨn mɨne nəgətun mɨn rəha Lou kəmotol əmə nati kətiəh motol əuvsan motəni məmə, “!Təmasiru e nətəmimi tepət, mətəu ko təsasiru aruiən lan! ");
INSERT INTO tnp_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Təuvɨr pəh kitah koteruh-to Məsaiə u, kig rəha nətəm Isrel, oteiuaiu e nɨgi kəməluau pəh kitah koteruh motəhatətə lan.” Kəni iətəmimi mil u kətuəhkul ilahal Iesu kɨnatuəni mɨn nəghatiən tərah lan. ");
INSERT INTO tnp_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kəni e tueləf klok mətəuarus=pən tri klok, napinəpuiən təmeiuaiu mɨrəuei nati. ");
INSERT INTO tnp_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kəni e tri klok ləhnaiuv, Iesu təmasək əfəməh e rəhan nəghatiən məni məmə, “!Eli, Eli! ?Lema sapaktəni?” Nɨpətɨ rəhan nəghatiən təni məmə, “!Uhgɨn rəhak, Uhgɨn rəhak! ?Təhro nətəpəh iəu?” ");
INSERT INTO tnp_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nətəmimi nəuvein kəməutəhtul əha ikɨn kəməsotətəu viviən nəghatiən u, kəmotəni məmə, “Otətəu-to. Tətauɨn e Elaijə.” ");
INSERT INTO tnp_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kəni ilah kəti təmaiu muvən miuvi=pən wain u tarfu e nati kəti tɨmətmətɨg təhmen e kotɨn, məu-pəri e nəuanɨgi tuvən o Iesu məmə otəmnɨm. Kəni məni məmə, “Pəh-to koteh-to məmə Elaijə otuva mələs iahu, uə kəpə.” ");
INSERT INTO tnp_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mətəu Iesu təmagət əfəməh mɨn, kəni rəhan nehagiən tiet. ");
INSERT INTO tnp_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kəni əpəha e Nimə Rəha Uhgɨn, napən iətəm tətəhkul pəsɨg e Ikɨn Tasim Agɨn Ikɨn, təməhapu nəuvetɨn keiu təmətuəuin əpəha ilɨs mətəuarus=pa əpəha ləhtəni. ");
INSERT INTO tnp_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kəni iətəmi asoli rəha soldiə mɨn iətəm təmatəhtul e nɨkalɨ Iesu, təmeh məmə təmɨmɨs lanəha, kəni in təməni məmə, “!Nɨpəhriəniən, suah u in Nətɨ Uhgɨn pəhriən!” ");
INSERT INTO tnp_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nɨpətan nəuvein kəməutəhtul isəu məutəsal=pa mauteruh. Ilah nəuvein u Meri Maktələ, mɨne iahuni mamə rəha Jemɨs əkəku mɨne Josɨs, mɨne Səlome. ");
INSERT INTO tnp_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ilahal kəməhlɨtəu=pən Iesu nian təmətatɨg Kaləli, məhlasiru lan. Ilah nɨpətan tepət kəmotəri məhuvən əpəha Jerusɨləm ilah Iesu. ");
INSERT INTO tnp_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kəni nian əha Iesu təmɨmɨs lan, in nian rəha nol əpenə-penəiən natimnati rəha Sapət, kəni olauɨg nian rəha Sapət, kəsoliən uək lan. Tɨnapinəpu, ");
INSERT INTO tnp_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Josɨp in iətəm Aramatiə tɨnuva. In iətəmi kəti rəha kaunsɨl iətəm kətɨsiai in. In nɨkin təməhti pɨk Narmənɨgiən Rəha Uhgɨn. Kəni təməsəgɨniən, muvən o Pailət mətapuəh o nɨpətɨ Iesu. ");
INSERT INTO tnp_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nian Pailət təmətəu məmə Iesu tɨnɨmɨs rəkɨs, kəni təmauɨt mauɨn e iətəmi asoli rəha soldiə mɨn mətapuəh ohni məmə, “?Kətəni pəhriən məmə Iesu tɨnɨmɨs rəkɨs uəhai əmə?” ");
INSERT INTO tnp_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mətəu iətəmi asoli rəha soldiə mɨn təni məmə, “Nɨpəhriəniən, tɨnɨmɨs rəkɨs.” Pailət təmətəu nəghatiən u kəni megəhan=pən e nɨpətɨ Iesu kəm Josɨp. ");
INSERT INTO tnp_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Kəni Josɨp təmuvən mos nəhmtɨ napən ruən kəti, nərgɨn u linən, muva mələs iahu Iesu e nɨgi kəməluau məuveg lan, mələs muvən mələhu=pən e nɨpəg kəpiel u kəmel rəkɨs məmə okol suvət ikɨn. Kəni mɨsuə=pən e kəpiel asoli kəti mahtɨpəsɨg=pən e nɨpəg kəpiel u lan. ");
INSERT INTO tnp_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Kəni Meri Maktələ mɨne Meri mamə rəha Josɨs, ilau kəmueruh ikɨn əha kəmələhu=pən Iesu ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nian rəha Sapət tɨnuva mɨnuvən rəkɨs, kəni Meri Maktələ mɨne Meri mamə rəha Jemɨs, mɨne Səlome kəmlos nəhmtɨ nati pien-pien mɨn u nəmiəvɨlah təuvɨr məmə okɨlol=pən e nɨpətɨ Iesu. ");
INSERT INTO tnp_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ləplapɨn agɨn mɨtɨgar tɨnətəri e Sante, pəta milahal u kəmhluvən e suvət. ");
INSERT INTO tnp_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nian kəmhluvən e suaru kəni məhləni kəm lahal mɨn məmə, “?Kərmə pah otasiru e tahal mɨsuə rəkɨs kəpiel asoli əpəha e nɨpəg kəpiel?” ");
INSERT INTO tnp_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mətəu-inu kəpiel əha kəpiel asoli. Mətəu nian kəmhluvən iuəkɨr, mɨləsal=pən mɨlafu kɨnɨsuə rəkɨs e kəpiel. ");
INSERT INTO tnp_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kəmhluvən imə e nɨpəg kəpiel mɨlafu iətəm aluə kəti tətəharəg əha e nɨpəg kəpiel e nɨkalɨn maru ikɨn rəhalahal, təmuvən e kot əfəməh ruən kəti, kəni ilahal kəmhlauɨt pɨk ohni. ");
INSERT INTO tnp_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kəni təməni=pən kəm lahal məmə, “Sləgɨn pɨkiən. Nələsal e Iesu iətəm Nasərɨt, iətəm kəmətu-pəri e nɨgi kəməluau, mətəu in tɨkə u ikɨnu rəueiu. In tɨnəmiəgəh rəkɨs e rəhan nɨmɨsiən. Leruh-to nɨmein u kəmələhu=pən ikɨn. ");
INSERT INTO tnp_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kəni rəueiu onəkluvən mɨhləni=pən kəm rəhan mɨn nətəmimi mɨne Pitə, məmə in otaupən matuvən Kaləli, kəni onəkohuərisɨg lan məhuvən moteh əha ikɨn məmə inu təməni rəkɨs mɨne kəm təmah.” ");
INSERT INTO tnp_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kəmlaiu mɨhliet e suvət məhlagɨm, mətəu-inu kɨnləgɨn pɨk məhlərəmrumɨn. Kəni mɨhluvən məsləniən nati kəti mɨne kəm nətəmimi mətəu-inu kɨnləgɨn pɨk. ");
INSERT INTO tnp_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nian Iesu təməmiəgəh mɨn e Sante ləplapɨn agɨn, kəni maupən miet=pa o Meri Maktələ. Aupən təməhgi pətɨgəm narmɨn tərah səpɨn lan. ");
INSERT INTO tnp_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kəni Meri təmuvən məni=pən kəm rəhan mɨn nətəmimi nətəm kəməutan ilah min ilah aupən, mətəu nɨkilah tətahmə pɨk kəni məutasək. ");
INSERT INTO tnp_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mətəu nian kəmotətəu məmə Iesu tɨnəmiəgəh rəkɨs e rəhan nɨmɨsiən, kəni miet=pa o pətan əha, mətəu ilah kəməsotəniən nɨpəhriəniən lan. ");
INSERT INTO tnp_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Uərisɨg, Iesu təmiet=pa o iətəmimi mil keiu kəmiasɨpən Jerusɨləm mətian e suaru, mətəu e nian əha nɨpətɨn təmol pɨsɨn. ");
INSERT INTO tnp_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kəni ilau kəmiatəlɨg mɨn mian muəni=pən kəm ilau mɨn nəuvein, mətəu ilah kəməsotəni mɨniən nɨpəhriəniən e lau. ");
INSERT INTO tnp_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kəni uərisɨg, Iesu təmiet=pa mɨn o rəhan nətəmimi lepɨn nian kəməutauən. Kəni mətahi ilah məmə, “Itəmah nəsotəhatətəiən lak, rəhn-kapə təmah tiəkɨs pɨk.” Təmahi ilah mətəu-inu kəsotəhatətəiən e nətəm kəmoteh məmə tɨnəmiəgəh rəkɨs e rəhan nɨmɨsiən. ");
INSERT INTO tnp_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kəni məni=pən kəm lah məmə “Əhuvən motəni pətɨgəm Nanusiən Təuvɨr kəm nətəmimi mɨn e nəuanɨləuɨs mɨn rəfin e nɨtəni mɨn rəfin. ");
INSERT INTO tnp_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Iətəmi otətəu Nanusiən Təuvɨr təhatətə lan kəni mol bəptais, Uhgɨn otosmiəgəh. Mətəu iətəmi təsəhatətəiən lan, Uhgɨn otol nalpɨniən asoli kəm in. ");
INSERT INTO tnp_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kəni nətəmi okotəhatətə lak, Uhgɨn otol ilah kotol nati apɨspɨs mɨn. Okotəhgi pətɨgəm narmɨn tərah tepət e nərgək, kəni motəghati e nəghatiən ikɨ pɨsɨn mɨn. ");
INSERT INTO tnp_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ilah kotəhrun naskəlɨmiən sɨneik u tatus itəmi, motəhrun nəmnɨmiən nati kətakonə lan, mətəu ko təsərəkɨniən ilah. Ilah motəhrun nələhu-pəniən nəhlmɨlah e nətəm kautohmɨs kotəmiəgəh.” ");
INSERT INTO tnp_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kəni nian Iərmənɨg Iesu tɨnəghati rəkɨs kəm rəhan mɨn nətəmimi, kəni Uhgɨn tos mɨnatuvən e neai, kəni in tətəharəg e nɨkalɨ Uhgɨn maru, ikɨn ima nəsanəniən mɨne nɨsiaiən. ");
INSERT INTO tnp_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kəni rəhan mɨn nətəmimi kəmohiet məhuvən motanus pətɨgəm rəhan nəghatiən əpəha ikɨn mɨn rəfin. Kəni Iərmənɨg tətasiru e lah matol nəmtətiən tepət. Kəni nəmtətiən mɨn əha kautol nəfɨgəmiən məmə rəhalah nəghatiən in nɨpəhriəniən. ");
INSERT INTO tnp_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Teofɨləs, ik iətəmi asoli katɨsiai ik, kəni iəkətei nauəuə u tatuvən kəm ik. Aupən, Uhgɨn təməni natimnati nəuvein, kəni rəueiu e nian rəhatah, in tɨnol ilah kɨnəhuva mɨnautol nɨpətɨn. Nətəmimi tepət kəməutatɨg e nian əha, mauteruh natimnati mɨn əha e nəhmtɨlah əhruahru, kəni məutəni. Kəni nətəmi nəuvein kəməutətəu rəhalah nəghatiən, kəni məutalkut pɨk məmə okotətei rəkɨs əhruahru natimnati mɨn əha. ");
INSERT INTO tnp_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kəni iəu iəmɨtəu vivi nəghatiən mɨn əha məmə iəkəhrun əhruahru mə təmətuəuin əhro, kəni iəu rəhak nətəlɨgiən məmə təuvɨr iəu mɨn iəkətei rəkɨs əhruahru natimnati ərəfin mɨn əha məmə onəkafin. Iətətei əhruahru natimnati mɨn u nəukətɨ nəniən mɨne natimnati iətəm kautəhuərisɨg. ");
INSERT INTO tnp_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Iəkolkeikei məmə iəkəni natimnati mɨn əha kəm ik məmə nəkəhrun əhruahru məmə nəniən iətəm kəməni rəkɨs kəm ik, in nɨpəhriəniən. ");
INSERT INTO tnp_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","E nian rəha suah kəti, nərgɨn u Herot Asoli, kig rəha Jutiə, e nian əha pris kəti nərgɨn u Səkaraea. In kəti mɨn e pris mɨn u kətəni nərgɨ lah məmə, Pris mɨn rəha Apia. Aupən rəkɨs, suah u Apia tatsɨpən e pris u Eron. Rəhan pətauəhli nərgɨn u Ilesəpet, kəni in mɨn tatsɨpən e pris u Eron. ");
INSERT INTO tnp_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kəni ilau kuəhruahru e nəhmtɨ Uhgɨn, nian rəfin kətuɨtəu=pən vivi noliən rəha Lou rəhan mɨne nəghatiən mɨn rəhan, kəni məsuərəkɨniən kəti. ");
INSERT INTO tnp_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nati əpnapɨn kuəhruahru, mətəu ilau nətɨlau tɨkə. Ilesəpet, in təseməkiən mətəuarus mɨnəpətauəhli kəni ilau pəti kɨnuauəhli. ");
INSERT INTO tnp_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kəni nian tɨnuva əhruahru, məmə pris mɨn rəha Apia okəhuvən e Nimə Rəha Uhgɨn motol rəhalah natimnati mɨn. Kəni Səkaraea, in mɨn təmuvən mə tol pɨsəpɨs rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","E noliən rəha pris mɨn, ilah kəmotatu e kəpiel əkəku mɨn mə otəgətun pəh mə otol nati e Nimə Rəha Uhgɨn məmə otuvan nati pien-pien tuvən kəm Uhgɨn. E nian ilah kəmotol lanəha in təməgətun Səkaraea. ");
INSERT INTO tnp_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kəni e nian in təmuvən imə mətuvan nati pien-pien, nətəmimi tepət kəmautəhtul ihluə mautəfaki. ");
INSERT INTO tnp_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kəni agelo kəti rəha Uhgɨn təmietɨgəm=pən ohni mətəhtul əha e nəven maru ikɨn, əha kətuvan nati pien-pien ikɨn. ");
INSERT INTO tnp_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kəni nian Səkaraea təmeruh, kəni narmɨn təmiuvɨg mətərəmrumɨn mɨnəruru əfəməh nati, kəni nəgɨniən təməriauəh e nɨkin. ");
INSERT INTO tnp_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mətəu agelo təməni=pən kəm in məmə, “Səkaraea, səgɨniən, mətəu rəueiu Uhgɨn tɨnətəu rəham nəfakiən. Kəni rəham pətauəhli Ilesəpet otos nətɨn kəti iərman. Kəni onəkəkeikei mauɨn e nərgɨn məmə Jon. ");
INSERT INTO tnp_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kəni onəkətəu təuvɨr magiən mɨn, kəni nətəmimi tepət okotagiən o nairiən rəhan, ");
INSERT INTO tnp_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","mətəu-inu in otuva iətəmi asoli e nəhmtɨ Iərmənɨg. Kəni in otəsəmnɨm agɨniən wain mɨne nəmnɨmiən əskasɨk mɨn. Kəni Narmɨn Rəha Uhgɨn otəriauəh lan, nian otətatɨg əhanəh e nərfɨ rəhan mamə, matuvən əmə lanəha nian rəfin. ");
INSERT INTO tnp_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kəni in otiuvi=pa nətəm Isrel tepət okohtəlɨg=pa o Iərmənɨg, Uhgɨn rəhalah. ");
INSERT INTO tnp_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","“Uərisɨg Iərmənɨg otuva, mətəu in otaupən muva mətan e narmɨn mɨne e nəsanəniən təhmen e Elaijə məmə in otəuhlin nətəlɨgiən rəha tatə mɨn kohtəlɨg=pən mɨn o rəhalah kəlkələh mɨn, kəni in otəuhlin mɨn nətəm kəutəhti nəuia Uhgɨn okotos mɨn neinatɨgiən rəha nətəmi kotəhruahru. E noliən əha, in otol əpenə-penə o nəmiəgəhiən rəha nətəmimi o nuvaiən rəha Iərmənɨg.” ");
INSERT INTO tnp_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Kəni Səkaraea təməni=pən kəm agelo məmə, “?Oiəkəhro lanu məhrun məmə nati u otuva mol nɨpəhriəniən lan? Mətəu-inu iəu inauəhli rəkɨs, kəni rəhak pətan mɨn tɨnəpətauəhli.” ");
INSERT INTO tnp_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Kəni agelo təməni=pən kəm in məmə, “Iəu, nərgək u Kapriel, kəni iəu iətəhtul e nəhmtɨ Uhgɨn e nian ərəfin. Kəni in təmahli=pa iəu məmə iəkuva məghati kəm ik, kəni məni=pɨnə nanusiən təuvɨr u. ");
INSERT INTO tnp_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","!Ətəlɨg-to lak! Naməm otekəu kəni onəsəghatiən mətəuarus=pa nəkeruh nɨpətɨ nəghatiən u, mətəu-inu nəməsəniən nɨpəhriəniən e rəhak nəghatiən. Nati u in otuva mol nɨpəhriəniən lan e nian əhruahru rəhan.” ");
INSERT INTO tnp_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kəni e nian əha, nətəmimi kəməutəhtahnin Səkaraea, nɨkilah təhti məmə təhro tɨnan tɨnuvəh əha e Nimə Rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mətəu nian in təmuva ihluə, mətəu tɨnəruru nəghatiən, kəni ilah kəmotəhrun məmə in təmeruh nati kəti təhmen e nəməhlairiən əpəha imə. In təməghati əmə e nəhlmɨn kəm lah, məsəghatiən mətəu namɨn təmekəu. ");
INSERT INTO tnp_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nian rəhan uək rəha pris e Nimə Rəha Uhgɨn təmol naunun, kəni in təmɨtəlɨg=pən lahuənu. ");
INSERT INTO tnp_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kəni təsuvəhiən, rəhan pətauəhli təməpəh məuɨg e iəpəou. Kəni e məuɨg faif, pətauəhli u in təmətəhluaig əmə lahuənu, ");
INSERT INTO tnp_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","kəni in təməni məmə, “Inu uək rəha Iərmənɨg. Aupən ikɨn, nətɨk tɨkə kəni iətaulɨs. Mətəu rəueiu u, Uhgɨn tɨnol təuvɨr kəm iəu, kəni nɨkin tagiən məmə iəkələs nətɨk, kəni iəu oiəsaulɨs mɨniən e nəhmtɨ nətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nian Ilesəpet iəpəou tɨnatɨg lan mɨnos məuɨg sikɨs, Uhgɨn təmahli=pən rəhan agelo, nərgɨn u Kapriel, məmə in otuvən e nɨtəni Kaləli e taun kəti nərgɨn u Nasərɨt. ");
INSERT INTO tnp_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","In təmos nəghatiən kəti matuvən rəha pətan mɨtə kəti iətəm təruru əhanəh iərman, mətəu kɨnəni rəkɨs məmə okitipən mə rəha suah kəti, nərgɨn u Josɨp. In mipɨ Kig Tefɨt tərah. Kəni pətan əha, nərgɨn u Meri. ");
INSERT INTO tnp_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kəni agelo təmuvən miet=pən, kəni məni=pən kəm in məmə, “Təuvɨr, Meri. Uhgɨn təmələhu rəhan nəuvɨriən kəm ik, kəni in mətatɨg itəlau min.” ");
INSERT INTO tnp_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mətəu Meri tɨnəruru əfəməh nəghatiən əha, kəni nɨkin tɨnəhti pɨk məmə nɨpətɨ nəghatiən əha təhro lanu. ");
INSERT INTO tnp_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kəni agelo təməni=pən kəm in məmə, “Səgɨniən, Meri, mətəu-inu Uhgɨn təməni rəkɨs məmə in otətuati e rəhan nəuvɨriən kəm ik. ");
INSERT INTO tnp_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kəni inəha, ik onəkəpəh məuɨg e nətɨm kəti, kəni onəkələs iərman. Kəni onakauɨn e nərgɨn mə Iesu. ");
INSERT INTO tnp_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","In otuva iətəmi asoli kəni in iətəmi keikei, kəni okauɨn lan məmə Nətɨ Uhgɨn Ilɨs Agɨn. Kəni Iərmənɨg Uhgɨn otol in tuva Kig təhmen=pən əmə e tɨpɨn tərah Tefɨt. ");
INSERT INTO tnp_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kəni in otarmənɨg e nətəmimi mɨn rəfin nətəm kautsɨpən e Jekəp, kəni rəhan narmənɨgiən otatɨg itulɨn matuvən naunun tɨkə.” ");
INSERT INTO tnp_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Kəni Meri təməni=pən kəm agelo məmə, “?Iəsəhruniən məmə oiəkəhro lanu mələs suakəku kəti nəmə iəsɨtəu-pəniən iərman kəti?” ");
INSERT INTO tnp_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Kəni agelo təməni=pən kəm in məmə, “Narmɨn Rəha Uhgɨn otuva matɨg lam, kəni nəsanəniən rəha Uhgɨn Ilɨs Agɨn otəuveg ik. Kəni in ko, suakəku asim ko onəkələs, okauɨn lan məmə in nətɨ Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kəni iətəni=pɨnə kəm ik məmə ik kəti Ilesəpet tɨnamki-amki rəkɨs e nətɨn kəti iərman, nati əpnapɨn in tɨnəpətauəhli rəkɨs. Kəmətəni lan məmə ko təseməkiən, mətəu rəueiu əha tɨnəpəh rəkɨs məuɨg sikɨs e nətɨn. ");
INSERT INTO tnp_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Natimnati mɨn u tatɨtəu=pən əmə nəghatiən rəha Uhgɨn məmə, ‘Uhgɨn təhrun noliən natimnati ərəfin, kəni nati kəti təsiəkɨsiən ohni.’” ");
INSERT INTO tnp_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kəni Meri təməni=pən məmə, “Əuəh, iəu pətan iol əhruin əmə rəha Iərmənɨg. Pəh in otol lak nati nak iətəm ik nɨnəni rəkɨs.” Kəni agelo təpəh in, kəni mɨtəlɨg. ");
INSERT INTO tnp_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Uərisɨg lan təsuvəhiən, kəni Meri təmiet iman ikɨn kəni maliuək uəhai mətuvən e taun e nɨtəuət e Jutiə mə otəsal=pən e Ilesəpet, ");
INSERT INTO tnp_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","kəni in təmuvən e lahuənu rəha Səkaraea, kəni muvən imə mətəni təuvɨr kəm Ilesəpet. ");
INSERT INTO tnp_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kəni nian Ilesəpet təmətəu nəghatiən rəha Meri, suakəku u iətəm tətatɨg e nərfɨn təmauɨt, kəni Narmɨn Rəha Uhgɨn təməri e nɨki Ilesəpet. ");
INSERT INTO tnp_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Kəni in təmagət əfəməh məmə, “!Uhgɨn tɨnol təuvɨr ohnik tapirəkɨs nɨpətan ərəfin, kəni in tɨnol təuvɨr mɨn kəm suakəku u onəkələs! ");
INSERT INTO tnp_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nɨkik tagiən. Kəni təhro Uhgɨn təmol nati təuvɨr asoli kəm iəu, məmə mamə rəha Iərmənɨg rəhak tuva məsal=pa lak. ");
INSERT INTO tnp_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Iətəni lanu mətəu e nian iəmətəu rəham nəghatiən, kəni suakəku u e nərfək təmagiən mauɨt. ");
INSERT INTO tnp_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Uhgɨn otol təuvɨr kəm ik mətəu-inu nəməni nɨpəhriəniən e nəghatiən u Iərmənɨg təməni tɨnuva lam məmə otol nɨpəhriəniən lan.” ");
INSERT INTO tnp_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Kəni Meri təməni məmə, “E nəmiəgəhiən rəfin rəhak, iatləfəri nərgɨ Iərmənɨg ilɨs, ");
INSERT INTO tnp_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Kəni nɨkik tətagiən pɨk o Uhgɨn Iosmiəgəh rəhak, ");
INSERT INTO tnp_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","mətəu-inu iəu pətan iol əhruin əmə u iəu nati əpnapɨn əmə, mətəu nɨkin tətəhti iəu. Kəni rəueiu mɨne matuvən, nətəmimi rəfin okotəni məmə Uhgɨn təmol təuvɨr kəm iəu; ");
INSERT INTO tnp_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","mətəu-inu Uhgɨn u nəsanəniən rəhan in iahgin, in təmol nati apɨspɨs mɨn təuvɨr pɨk agɨn kəm iəu, kəni in nərgɨn tasim. ");
INSERT INTO tnp_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","In tatolkeikei nətəmimi mɨn u kəutɨsiai in, inu nətəmimi e nəuanɨləuɨs aupən ikɨn mətəuarus=pa nəuanɨləuɨs mɨn nətəm kəutəhuva əhanəh. ");
INSERT INTO tnp_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","In təmol nati apɨspɨs mɨn e nəsanəniən e nəhlmɨn. In təməhgi-atiti nətəm kəutəfəri ilah e nətəlɨgiən rəhalah. ");
INSERT INTO tnp_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","In tatosiahu narmənɨg mɨn e rəhalah narmənɨgiən, kəni in tətəfəri nətəmi mɨn u rəhalah nətəlɨgiən teiuaiu. ");
INSERT INTO tnp_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nətəmi nəumɨs tatus ilah, in tətaugɨn ilah e nauəniən təuvɨr, Kəni nətəmi rəhalah nautə tepət, in tahli pətɨgəm ilah, kəni nati tɨkə e nəhlmɨ lah. ");
INSERT INTO tnp_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Uhgɨn təmasiru e nəuanɨləuɨs mɨn rəha Isrel u rəhan iol əhruin mɨn, kəni təməsaluiən e rəhan nolkeikeiən e ");
INSERT INTO tnp_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Epraham mɨne rəhan mɨn nəuanɨləuɨs, matuvən əmə lanko naunun tɨkə məmə inəha təməni kəm tɨpɨlah mɨn nuvəh.” ");
INSERT INTO tnp_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Kəni Meri təmatɨg ilau Ilesəpet mətəuarus=pən məuɨg kɨsɨl, kəni in təmɨtəlɨg=pən əpəha iman ikɨn. ");
INSERT INTO tnp_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kəni nian əhruahru rəha Ilesəpet tɨnuva məmə otemək lan, kəni təmələs nətɨn iərman. ");
INSERT INTO tnp_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kəni nətəmimi nətəm kəutatɨg iuəkɨr ohni mɨne rəhan mɨn nəuanɨləuɨs, kəmotətəu nanusiən əha məmə Iərmənɨg təmol nəuvɨriən asoli kəm in, kəni ilah kəməhuva motol kətiəh ilah min məmə okotagiən pəti. ");
INSERT INTO tnp_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nian suakəku əha tɨnos nian eit, ilah kəməhuva məmə okotəhgi=pən. Kəni iuəkɨr kotauɨn e nərgɨn məmə iahuni rəhan tatə Səkaraea, ");
INSERT INTO tnp_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","mətəu rəhan mamə təni məmə, “Kəpə. Okauɨn e nərgɨn məmə Jon.” ");
INSERT INTO tnp_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kəni ilah kəmotəni kəm in məmə, “?Onak? Rəham nərgɨn u Jon tɨkə.” ");
INSERT INTO tnp_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kəni kəmotəghati e nəhlmɨlah məutətapuəh o Səkaraea mə in otəkeikei məni-to mə okauɨn e nərgɨn mə pəh. ");
INSERT INTO tnp_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Kəni in təmətapuəh o nati kəti mə otətei rəkɨs nati kəti lan, kəni in təmətei=pən məmə, “Nərgɨn u Jon.” Nian kəmoteh, narmɨlah təmiuvɨg pɨk. ");
INSERT INTO tnp_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kəni e nian əmə əha, namɨ Səkaraea tɨnɨmətɨg kəni tɨnəhrun nəghatiən mətəni-vivi Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kəni nətəmimi rəfin u kəutatɨg iuəkɨr kəmotəgɨn. Kəni nətəmimi kəmotəni pɨk natimnati mɨn u tɨtəlau-təlau əha ilɨs e nɨtəni Jutiə. ");
INSERT INTO tnp_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kəni nətəmimi mɨn ərəfin nətəm kəmotətəu nanusiən əha, kəni məutətəlɨg lan, məutətapuəh məmə, “?Suakəku əha, otuva iətəmi əhro?” Kəməutəni lanəha mətəu-inu kəmoteruh əmə məmə nəsanəniən rəha Iərmənɨg tətatɨg lan. ");
INSERT INTO tnp_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Kəni Narmɨn rəha Uhgɨn təməri e nɨki Səkaraea, tatə rəha Jon, kəni in təməni pətɨgəm nəghatiən iətəm Uhgɨn təməfən kəm in. Kəni təməni lanu məmə, ");
INSERT INTO tnp_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Pəh kotəni-vivi Iərmənɨg, u in Uhgɨn rəha nətəm Isrel, mətəu-inu in təmuva məmə otasiru e rəhan mɨn nətəmimi, kəni in təmos rəkɨs ilah e nəhlmɨ tɨkɨmɨr mɨn rəhalah. ");
INSERT INTO tnp_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Uhgɨn u təməfəri iosmiəgəh əsanən iətəm otosmiəgəh kitah. Iosmiəgəh u təmsɨpən e nəuanɨləuɨs rəha iol əhruin rəhan u Tefɨt. ");
INSERT INTO tnp_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kəni in təhmen=pən əmə e nəghatiən iətəm Uhgɨn təməni rəkɨs kəm tah nəghatiən rəha iəni mɨn rəhan aupən. ");
INSERT INTO tnp_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","In təməni-əskasɨk rəkɨs məmə otosmiəgəh itah o tɨkɨmɨr mɨn rəhatah mɨne nətəmimi rəfin nətəm kəutəməki e tah. ");
INSERT INTO tnp_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","In tətləfəri iosmiəgəh əha məmə otol nəuvɨriən u in təməni kəm kəha tərah mɨn, kəni təsaluiən e rəhan nəghatiən iətəm in aru təməni e rəhan nəniəskasɨkiən rəha nasiruiən, ");
INSERT INTO tnp_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","inu nəniəskasɨkiən iətəm in təməni kəm kəha Epraham. ");
INSERT INTO tnp_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","In təmləfəri iosmiəgəh əha məmə otosmiəgəh itah, kəni mələs rəkɨs itah e nəhlmɨ tɨkɨmɨr mɨn rəhatah məmə nian mɨn rəfin e nəmiəgəhiən rəhatah, kitah okotəhrun noliən rəhan uək e nəhmtɨ Uhgɨn, kəni məsotəgɨniən, ");
INSERT INTO tnp_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","kəni kitah okotasim, kəni nəmiəgəhiən rəhatah otəhruahru e nian mɨn rəfin. ");
INSERT INTO tnp_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Kəni ik, nətɨk, okauɨn lam məmə ik iəni rəha Uhgɨn Ilɨs Agɨn, mətəu-inu ik onəkaupən e Iərmənɨg məmə onəkol əpenə-penə rəhan suaru. ");
INSERT INTO tnp_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ik onəkəni pətɨgəm kəm rəhan mɨn nətəmimi məmə Uhgɨn otosmiəgəh ilah nian in otafəl rəkɨs rəhalah təfagə tərah mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","In otol mətəu-inu, in tolkeikei itah matol təuvɨr kəm tah. E nolkeikeiən rəhan, Krɨsto otuva o tah təhmen=pən e mɨtɨgar tətəri e neai, ");
INSERT INTO tnp_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","mətasiəgəpɨn itah nətəmimi kəutatɨg e napinəpuiən mɨne əpəha ikɨn nɨmɨsiən tatoh itəmi ikɨn, kəni matit vivi nəhlkɨtah e suaru rəha nəməlinuiən.” ");
INSERT INTO tnp_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kəni suakəku təmepət e nɨpətɨn, kəni narmɨn rəhan təsanən. Kəni nian rəfin in tətatɨg əpəha ikɨn təpiə-məpiə ikɨn mətəhtahnin nian rəhan otuva iətəm otətuəuin uək lan kəni nətəm Isrel okoteruh. ");
INSERT INTO tnp_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","E nian mɨn əha uərisɨg Iesu tair, suah kəti iətəm Rom, nərgɨn u Sisə Okastas, in iətəmi asoli təmətarmənɨg e nɨtənimtəni mɨn rəfin rəha Rom. In təmələhu lou kəti məmə okafin rəfin nətəmimi iətəm kəutatɨg rəfin əha ikɨn. ");
INSERT INTO tnp_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Inu nafiniən nətəmimi kəmaupən kol, kəni Kuarinias in kəpmən rəha Sɨriə. ");
INSERT INTO tnp_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","E nian əha, nətəmimi rəfin okotəkeikei mohtəlɨg=pən imalah mɨn ikɨn kəmotair ikɨn məmə okafin ilah, kəni kətei rəkɨs nərgɨlah e nauəuə rəha kəpmən. ");
INSERT INTO tnp_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kəni Josɨp mɨne Meri kəmiaiet e nɨtəni Kaləli e taun kəti, nərgɨn u Nasərɨt, mian əpəha nɨtəni Jutiə e taun kəti, nərgɨn u Petlehem, ima Kig Tefɨt aupən. Ilau kəmian ikɨn əha mətəu-inu Josɨp in mipɨ Tefɨt tərah. ");
INSERT INTO tnp_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ilau Meri kətian məmə okos nərgɨlau. Kɨnəni rəkɨs mə Meri otɨtəu=pən Josɨp, kəni Meri in namki-amki rəkɨs e iəpəou. ");
INSERT INTO tnp_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nian ilau əpəha Petlehem, nimə tɨkə məmə okuapɨli ikɨn, kəni kətuapɨli e nimə rəha natimiəgəh mɨn. Kəni nian rəha Meri tɨnuva məmə otemək e nətɨn. ");
INSERT INTO tnp_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kəni iəpəou iətəm in təmaupən mair, in iərman. Kəni in təuveg e napən, mələhu=pən e bokɨs kəti iətəm kətələhu=pən manvehli u natimiəgəh mɨn kəutauən=pən ikɨn. ");
INSERT INTO tnp_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kəni e nɨkalɨ Petlehem, nətəmimi rəha sipsip mɨn kəməutəsal o rəhalah mɨn sipsip mɨn lapɨn. ");
INSERT INTO tnp_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kəni agelo kəti rəha Iərmənɨg təmietɨgəm=pən o lah, kəni nəhagəhagiən asoli rəha Iərmənɨg təmasiəgəpɨn ilah, kəni kəmotəgɨn pɨk. ");
INSERT INTO tnp_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mətəu agelo təni=pən kəm lah məmə, “Sotəgɨniən, mətəu-inu iəu iətuva məmə iəkəfɨnə nəniən təuvɨr kəti iətəm otol nɨki nətəmimi kotagiən pɨk, kəni nəniən u in rəha nətəmimi ərəfin. ");
INSERT INTO tnp_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Əpəha e taun rəha Kig Tefɨt, suakəku kəti təmair=pa u rəueiu. In Iosmiəgəh, kəni in Krɨsto iətəm Uhgɨn təməni aupən məmə otahli=pa o təmah, kəni in Iərmənɨg. ");
INSERT INTO tnp_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Inu nəmtətiən rəhatəmah: onəkoteruh suakəku kəməuveg e napən, kəni kələhu=pən e bokɨs kətaugɨn=pən nati miəgəh mɨn ikɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kəni rəueiu agɨn, nagelo mɨn tepət kəmohietɨgəm=pa məutəhtul ilah min, məutəni-vivi Uhgɨn, məutəni məmə, ");
INSERT INTO tnp_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kətəni-vivi Uhgɨn əpəha ilɨs ilɨs agɨn e neai. Kəni əpəha ləhtəni e nəhue nɨtəni u, nətəmimi iətəm nɨki Uhgɨn tətagiən o lah, ilah okotatɨg e nəməlinuiən.” ");
INSERT INTO tnp_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nian nagelo mɨn kɨnotəpəh nətəmimi rəha sipsip mɨn mɨnotohtəlɨg=pən e negəu e neai, kəni nətəmimi rəha sipsip mɨn kəmotəni kəm lah mɨn məmə, “Pəh kəhuvən Petlehem moteh-to nati u Iərmənɨg təməni=pa kəm tah.” ");
INSERT INTO tnp_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kəmotəhrəmlin uəhai əmə məhuvən moteh Meri mɨne Josɨp mɨne suakəku iətəm kəmələhu=pən e bokɨs iətəm kətaugɨn=pən nati miəgəh mɨn ikɨn. ");
INSERT INTO tnp_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nian kəməhuvən rəkɨs moteh suakəku u, kəni kəmotanus nəghatiən e suakəku u iətəm kəmotos o agelo. ");
INSERT INTO tnp_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kəni nətəmimi rəfin nətəm kəmotətəu nəghatiən əha rəha nətəmimi rəha sipsip mɨn, ilah kəmotauɨt, narmɨlah təmiuvɨg pɨk. ");
INSERT INTO tnp_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mətəu Meri təmatos əmə e nɨkin natimnati rəfin mɨn u, kəni mətətəlɨg lan nian mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kəni nətəmimi rəha sipsip mɨn kəmohtəlɨg, məutəfəri nərgɨ Uhgɨn məutəni-vivi in o natimnati rəfin iətəm kəmotətəu kəni moteh, təhmen=pən əmə e nati u agelo təməni=pən kəm lah. ");
INSERT INTO tnp_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nian suakəku təmair mɨnos nian eit, kəni kəhgi=pən tɨtəu=pən Lou rəhalah, kəni kauɨn e nərgɨn məmə Iesu, nərgɨn u iətəm agelo təməni=pən kəm Meri aupən rəkɨs, nian in təməsəpəh əhanəhiən məuɨg lan. ");
INSERT INTO tnp_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kəni tɨnuva əhruahru e nian rəha Josɨp mɨne Meri məmə okuələs suakəku u mian əpəha Jerusɨləm məmə okuəfən kəm Iərmənɨg. Kəni ilau kəmian. ");
INSERT INTO tnp_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Inu tatɨtəu=pən əhruahru Lou rəha Iərmənɨg u tətəni məmə, “Suakəku iərman mɨn u kəmaupən kələs ilah, okəkeikei kətəfən ilah kəm Uhgɨn məmə rəhan.” ");
INSERT INTO tnp_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kəni ilau kəmian Jerusɨləm o nati kəti mɨn, məmə ilau okuos mak keiu uə iəuein keiu, kəni miohamu mətuəfən kəm Uhgɨn o nafəliən namɨkmɨkiən rəha Meri, tatɨtəu=pən əmə Lou rəha Iərmənɨg u Mosɨs təmətei. ");
INSERT INTO tnp_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kəni inu iətəmimi kəti əha Jerusɨləm nərgɨn u Sɨmion. Rəhan nəmiəgəhiən təhruahru, kəni nian rəfin tatɨtəu=pən nəghatiən rəha Uhgɨn. Kəni in tətəhtahnin nuvaiən rəha Krɨsto iətəm otuva mosmiəgəh mol nəunəhmtɨlah nətəm Isrel. Kəni Narmɨn Rəha Uhgɨn təmuva məriauəh e nɨkin. ");
INSERT INTO tnp_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Narmɨn Rəha Uhgɨn tɨnəni rəkɨs kəm in məmə otəsɨmɨsiən mətəuarus in oteh Krɨsto iətəm Iərmənɨg təməni mə otahli=pa. ");
INSERT INTO tnp_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Narmɨn Rəha Uhgɨn təməuhlin nɨkin məmə in otuvən e Nimə Rəha Uhgɨn. Kəni Josɨp mɨne Meri kəmuələs suakəku u Iesu mian e nimə Rəha Uhgɨn məmə ilau okuol natimnati rəfin iətəm Lou tətəni. ");
INSERT INTO tnp_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Kəni Sɨmion təmeruh Iesu, kəni in təmələs=pa e nərfɨn, kəni mətəni-vivi Uhgɨn, mətəni=pən məmə, ");
INSERT INTO tnp_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Iərmənɨg, nəmol rəfin rəham nəghatiən o nəniəskasɨkiən kəm iəu, iol əhruin əmə rəham. Kəni rəueiu, inategəhan lak məmə iəkɨmɨs-tə e nəməlinuiən, ");
INSERT INTO tnp_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","mətəu-inu ineruh e nəhmtək suakəku u iətəm otosmiəgəh nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ik nəmol əpenə-penə məmə in Iosmiəgəh, kəni nətəmimi rəfin okoteruh. ");
INSERT INTO tnp_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","In otuva nəhagəhagiən, kəni otəgətun rəhan suaru kəm Nanihluə mɨn, kəni nətəmimi okotləfəri rəham mɨn nətəm Isrel o Iosmiəgəh əha.” ");
INSERT INTO tnp_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Kəni tatə mɨne mamə rəha suakəku u, narmɨlau təmiuvɨg o nəghatiən mɨn əha Sɨmion təməni lan. ");
INSERT INTO tnp_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Kəni Sɨmion təməfaki məmə nəuvɨriən rəha Uhgɨn otuvən o lau. Kəni in təməni kəm Meri u mamə rəha suakəku məmə, “Onakateh, Uhgɨn təməni rəkɨs məmə suakəku u otol məmə nətəmimi tepət əpəha Isrel okoteiuaiu motorin, kəni tepət mɨn okotəri. Kəni in otuva nəmtətiən kəti nətəmimi tepət okotəghati rah lan məmə, ");
INSERT INTO tnp_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","nətəmimi okoteruh nətəlɨgiən mɨn e nɨki nətəmimi tepət. “Kəni Meri, nɨkim otɨtəgɨt təhmen e suah kəti təməu nɨkim e nau asɨlə.” ");
INSERT INTO tnp_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kəni pətauəhli kəti əha ikɨn, nərgɨn u Ana, kəni in iəni kəti. In nətɨ Fanuel, iətəmi kəti in təmsɨpən e Aser aupən ikɨn. Pətauəhli u, rəhan nu tepət. Nian in pətan mɨtə əmə kəti, kəni mɨtəu=pən rəhan iauəhli. Kəni ilau kəmuan o nu səpɨn əmə, kəni rəhan iauəhli tɨmɨs. ");
INSERT INTO tnp_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Kəni pətan u təmətatɨg əmə lanəha mətəuarus=pa in pətauəhli kəti. Kəni rəueiu mɨnos nu eiti-fo. Nian rəfin in tətatɨg e Nimə Rəha Uhgɨn mətəfaki, inəha ləplapɨn mɨne ləhnaiuv tətətuakəm mətəpəh nauəniən mətəfaki kəm Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kəni in təmuva ikɨn əha e nian əhruahru Sɨmion tətəghati e suakəku. Kəni pətauəhli u tətəni-vivi Uhgɨn ohni, kəni mətəghati e suakəku əha kəm nətəmimi rəfin u kəməutəhtahnin məmə Krɨsto in otɨtɨs nətəm Isrel. ");
INSERT INTO tnp_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nian Josɨp mɨne Meri, ilau kəmuol natimnati u lou rəha Iərmənɨg tətəni, kəni kəmlɨtəlɨg=pən nɨtəni Kaləli e taun Nasərɨt, imalahal ikɨn. ");
INSERT INTO tnp_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kəni suakəku təmepət muva məskasɨk, kəni in teinatɨg vivi, kəni nian rəfin nəuvɨriən rəha Uhgɨn tətəriauəh e rəhan nəmiəgəhiən. ");
INSERT INTO tnp_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","E nu mɨn rəfin, tatə mɨne mamə rəha Iesu kətian Jerusɨləm məmə okotol lafet rəha Pasova. ");
INSERT INTO tnp_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nian Iesu tɨnos nu tueləf, in təmɨtəu=pən ilau mɨhluvən əpəha ilɨs e lafet əha, təhmen=pən əmə e noliən rəha nətəm Isrel. ");
INSERT INTO tnp_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nian lafet tɨnol naunun, kəni nətəmimi kɨnotohtəlɨg mautəhuvən imalah mɨn ikɨn, mətəu iətəm aluə Iesu in təməsɨtəu-pəniən rəhan tatə mɨne mamə, in matol əmə əpəha Jerusɨləm, mətəu ilau kuəruru. ");
INSERT INTO tnp_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nɨkilau təhti mə in təmuvən ilah nətəmimi mɨn nəuvein motaupən, kəni ilah kəmotaliuək o nian apiəpiə kətiəh. Kəni ilau kɨnətuəsal lan o rəhalau mɨn nətəmimi, mɨne nətəmimi iətəm kuəhrun ilah. ");
INSERT INTO tnp_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mətəu nian ilau kəməsueruhiən in, kəni kəmiatəlɨg muəsal lan mian Jerusɨləm. ");
INSERT INTO tnp_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kəni e nian kɨsɨl, kəni mueruh e Nimə Rəha Uhgɨn, tətəharəg ilah nəgətun mɨn matətəlɨg e lah, kəni mətətapuəh o lah o natimnati nəuvein. ");
INSERT INTO tnp_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kəni nətəmimi rəfin nətəm kəmotətəu nati u, narmɨlah təmiuvɨg pɨk o rəhan nəhruniən mɨne rəhan nuhalpɨniən nəghatiən mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kəni nian rəhan tatə mɨne mamə kəmueh, kəni narmɨlau təmiuvɨg pɨk ohni. Kəni rəhan mamə təməni=pən kəm in məmə, “Nətɨk. ?Nəkəhro matol lanu lan e tɨmlau. Itɨmlau rəham tatə nɨkitɨmlau təhti pɨk ik, kəni iətuəsal pɨk lam.” ");
INSERT INTO tnp_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kəni in təməni=pən kəm lau məmə, “?Nətuəsal lak onak? ?Nəsuəhruniən məmə iəu iəkəkeikei mətuva e nimə rəha rəhak Tatə?” ");
INSERT INTO tnp_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mətəu ilau kəsuəhruniən nɨpətɨ nəghatiən tətəni kəm lau. ");
INSERT INTO tnp_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kəni in təmɨtəu=pən ilau mɨhleiuaiu mɨhluvən əpəha Nasərɨt. Kəni in təmɨsiai ilau matol nəuialau. Mətəu nian rəfin rəhan mamə tətətəlɨg e natimnati rəfin mɨn əha e nɨkin. ");
INSERT INTO tnp_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Kəni Iesu təmatepət e nɨpətɨn, kəni rəhan nəhruniən tatol iahgin, kəni e nian mɨn rəfin, Uhgɨn mɨne nətəmimi nɨkilah tətagiən ohni. ");
INSERT INTO tnp_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kəni e nian rəha iətəm Rom, nərgɨn u Sisə Taipiriəs, in təmətarmənɨg e nɨtəni mɨn rəfin rəha Rom. Kəni e nian in təmətarmənɨg mətəuarus=pa nu fiftin, kəni nətəmi asoli nəuvein mɨn kəutarmənɨg ləhtəni e Sisə e nɨftəni əlkələh mɨn rəha Rom, inu Herot tətarmənɨg əpəha Kaləli, mɨne pian Fɨlɨp in tətarmənɨg əpəha Ituria mɨne Trakonaetas, mɨne Lisanias tətarmənɨg əpəha Apilin, mɨne Pontiəs Pailət u iətəm Rom in kəpmən rəha Jutiə. ");
INSERT INTO tnp_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Inu e nian əhruahru rəha Anəs mɨne Kaiəfəs ilau pris asoli agɨn mil rəha Isrel. E nian əha, Jon nətɨ Səkaraea, in tɨnepət rəkɨs, in mətan əpəha təpiə-məpiə ikɨn, kəni Uhgɨn təməfən nəghatiən kəti kəm in. ");
INSERT INTO tnp_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kəni in təmuvən mətan rəfin əha iuəkɨr o nəhu Jotən mətəni pətɨgəm nəghatiən rəha Uhgɨn. In mətəni məmə nətəmimi okotəkeikei mohtəlɨg e noliən tərah mɨn rəhalah, kəni məhuvən o Uhgɨn, məmə in otafəl noliən tərah mɨn rəhalah. Kəni nəmtətiən lanko, okol bəptais e lah. ");
INSERT INTO tnp_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","In təhmen əmə e nəghatiən rəha iəni u Aiseə iətəm təmətei e nauəuə rəhan məmə, “Suah kəti tətauɨn əpəha ikɨn təpiə-məpiə ikɨn mətəni məmə, ‘itəmah, nəkotol əpenə-penə e suaru rəha Iərmənɨg, kəni mautol rəhan suaru təhruahru. ");
INSERT INTO tnp_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nɨpəgləuahtəni mɨn otɨrəuei vivi, kəni nɨtəuət mɨn mɨne narɨt mɨn rəfin okosiahu, kəni suaru ekəu-ekəu mɨn okəgəhruahru, kəni suaru u tapəhri-apəhri okol təpiə. ");
INSERT INTO tnp_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kəni nətəmimi rəfin okoteh suaru rəha Uhgɨn o nosmiəgəhiən nətəmimi.’” ");
INSERT INTO tnp_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kəni e nian əha, nətəmimi tepət kəməhuva o Jon məmə in otol bəptais e lah, mətəu in təməni=pən kəm lah məmə, “!Itəmah nəkohtəhmen əmə e təgəluə mɨn! !Nɨkitəmah təsəhtiən məmə onəkotagɨm rəkɨs e niəməha mɨne nalpɨniən rəha Uhgɨn iətəm tətuva! ");
INSERT INTO tnp_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Onəkotəkeikei motol nati kəti pəh kəhrun məmə nɨnotəpəh pəhriən noliən tərah mɨn rəhatəmah kəni məhuva o Uhgɨn. Kəni sotəni aruiən kəm təmah e nəfəriən məmə itəmah nəkotəhruahru mətəu-inu itəmah namipɨ Epraham mɨn. !Kəpə! Inu nati əpnapɨn əmə. Iətəni kəm təmah məmə, Uhgɨn təhrun noliən kəpiel mɨn u kəhuva namipɨ Epraham mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kəni rəueiu əha, Uhgɨn tɨnəhtul maru o nətahli-pəniən nɨgi e nəukətɨn. Kəni nəmə nɨgi kəti təsəuəiən e nəuan iətəm təuvɨr, kəni in otəuahli məraki=pən e nɨgəm.” ");
INSERT INTO tnp_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kəni nɨmənin nətəmimi kəmotətapuəh o Jon məmə, “?Kəni oiəkotol nak?” ");
INSERT INTO tnp_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Kəni Jon təməni=pən kəm lah məmə, “Okəmə rəham napən keiu, əfən kəti kəm suah kəti u rəhan tɨkə. Nəmə nəgəm nauəniən tatɨg, əfən kəti kəm nətəmimi u nɨglah tɨkə.” ");
INSERT INTO tnp_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nətəmimi nəuvein rəha nosiən məni rəha takɨs kəməhuva məmə otol bəptais e lah, kəni motətapuəh o Jon məmə, “?Kəni oiəkotol nak?” ");
INSERT INTO tnp_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Kəni Jon təməni=pən kəm lah məmə, “Sotos əuauiən məni o nətəmimi tapirəkɨs inu təhmen əmə mə onəkotos.” ");
INSERT INTO tnp_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kəni soldiə mɨn nəuvein kəmotətapuəh mɨn, “Kəni itɨmah? ?Itɨmah o iəkotəhro?” Kəni in təməni=pən kəm lah məmə, “Sotoliən nəgɨniən kəm nətəmimi məmə, ‘Okəmə nəsotəfaiən məni, kəni iəkotol nahməiən kəm təmah.’ Kəni sotoliən nəgɨniən kəm nətəmimi məmə, ‘Okəmə nəsotəfaiən məni, kəni iəkotəni=pən kəm nətəmi asoli məmə nəmotol nati kəti tərah.’ Nɨkitəmah otəkeikei magiən o nos əhruahruiən nətəouiən rəhatəmah kəni in əmə ko.” ");
INSERT INTO tnp_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kəni nətəmi u kəməutəhtahnin Krɨsto u Uhgɨn təməni məmə otahli=pa, nɨkilah təhti məta Jon in Krɨsto. ");
INSERT INTO tnp_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mətəu Jon təməni=pən kəm lah məmə, “Iatol bəptais e təmah e nəhu, mətəu iətəmi kəti tətuva rəhan nəsanəniən mɨne nepətiən tapirəkɨs iəu. Kəni iəu ləhtəni agɨn, iəsəhmeniən məmə iəkuva iəu iol əhruin kəti rəhan o noliən rəhan uək. Kəni suah kəha, in otol bəptais e təmah e Narmɨn Rəha Uhgɨn mɨne nɨgəm. ");
INSERT INTO tnp_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","In tətəhtul maru o neruhiən noliən rəha nətəmimi məmə otəuəri ilah, nətəm kotəuvɨr mɨne nətəm kotərah təhmen e iətəm tətasum. Tətələs fok o nafəl rəkɨsiən nɨlosɨ wit məmə otos nɨpətɨn iətəm təuvɨr. Nətəm kotəuvɨr kotəhmen e nɨpətɨ wit, tatos ilah matuvən lahuənu. Mətəu nətəm kotərah kotəhmen e nɨlosɨ wit, təraki=pən e lah e nɨgəm asoli iətəm tatuəu naunun tɨkə.” ");
INSERT INTO tnp_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kəni Jon təməni pətɨgəm nəniən təuvɨr e nəghatiən tepət məmə otiuvi=pa nətəlɨgiən rəha nətəmimi kəhuvən o Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","E nian əha, Herot Antipas təmitirəkɨs Herotiəs inu pətan rəha pian, kəni in təmol natimnati tepət tərah. Kəni noliən mɨn əha, Jon təməni əskasɨk mahi Herot Antipas o noliən tərah mɨn rəhan. ");
INSERT INTO tnp_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kəni Herot Antipas təmatɨg mol mɨn noliən tərah kəti mɨn tapirəkɨs, in təmələs Jon muvən mahtɨpəsɨg lan e kaləpus. ");
INSERT INTO tnp_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Mətəu nian Jon təməsuvən əhanəhiən e kaləpus, kəni in təmatol bəptais e nətəmimi mɨn, kəni Iesu mɨn təmuva, kəni Jon tol bəptais lan. Kəni nian Iesu təmətəfaki, Uhgɨn təmerəh e neai, ");
INSERT INTO tnp_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","kəni Narmɨn Rəha Uhgɨn təmsɨpəri meiuaiu, nɨpətɨn təhmen e mak muva məharəg pəri e Iesu, kəni nəuia Uhgɨn təmsɨpəri e negəu e neai mətəni məmə, “Ik nətɨk keikei, iəkolkeikei pɨk ik, kəni nɨkik tagiən pɨk agɨn ohnik.” ");
INSERT INTO tnp_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nian Iesu təmətuəuin rəhan uək, rəhan nu təhmen=pən e tate. Nətəmimi nɨkilah təhti məmə in nətɨ Josɨp. Kəni Josɨp in nətɨ Heli, ");
INSERT INTO tnp_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli in nətɨ Matat, Matat in nətɨ Lifai, Lifai in nətɨ Melki, Melki in nətɨ Janae, Janae in nətɨ Josɨp, ");
INSERT INTO tnp_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josɨp in nətɨ Matatias, Matatias in nətɨ Amos, Amos in nətɨ Neham, Neham in nətɨ Esli, Esli in nətɨ Nagae, ");
INSERT INTO tnp_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagae in nətɨ Mahat, Mahat in nətɨ Matatias, Matatias in nətɨ Semein, Semein in nətɨ Josek, Josek in nətɨ Jota, ");
INSERT INTO tnp_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jota in nətɨ Joanan, Joanan in nətɨ Resa, Resa in nətɨ Serupapel, Serupapel in nətɨ Sealtiel, Sealtiel in nətɨ Neri, ");
INSERT INTO tnp_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri in nətɨ Melki, Melki in nətɨ Ati, Ati in nətɨ Kosam, Kosam in nətɨ Elmatam, Elmatam in nətɨ Er, ");
INSERT INTO tnp_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er in nətɨ Josuə, Josuə in nətɨ Eliesa, Eliesa in nətɨ Jorim, Jorim in nətɨ Matat, Matat in nətɨ Lifai, ");
INSERT INTO tnp_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lifai in nətɨ Sɨmion, Sɨmion in nətɨ Juta, Juta in nətɨ Josɨp, Josɨp in nətɨ Jonam, Jonam in nətɨ Eliakim, ");
INSERT INTO tnp_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim in nətɨ Melea, Melea in nətɨ Mena, Mena in nətɨ Matata, Matata in nətɨ Natan, Natan in nətɨ Tefɨt, ");
INSERT INTO tnp_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Tefɨt in nətɨ Jese, Jese in nətɨ Opet, Opet in nətɨ Poas, Poas in nətɨ Salmon, Salmon in nətɨ Nason, ");
INSERT INTO tnp_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason in nətɨ Aminatap, Aminatap in nətɨ Atmin, Atmin in nətɨ Ani, Ani in nətɨ Hesron, Hesron in nətɨ Peres, Peres in nətɨ Juta, ");
INSERT INTO tnp_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juta in nətɨ Jekəp, Jekəp in nətɨ Aisək, Aisək in nətɨ Epraham, Epraham in nətɨ Tera, Tera in nətɨ Nahor, ");
INSERT INTO tnp_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor in nətɨ Seruk, Seruk in nətɨ Rehu, Rehu in nətɨ Pelek, Pelek in nətɨ Eper, Eper in nətɨ Sela, ");
INSERT INTO tnp_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela in nətɨ Kaenan, Kaenan in nətɨ Apaksat, Apaksat in nətɨ Sem, Sem in nətɨ Noa, Noa in nətɨ Lamek, ");
INSERT INTO tnp_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek in nətɨ Metusela, Metusela in nətɨ Inok, Inok in nətɨ Jaret, Jaret in nətɨ Mahalalel, Mahalalel in nətɨ Kenan, ");
INSERT INTO tnp_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan in nətɨ Enos, Enos in nətɨ Set, Set in nətɨ Atəm, kəni Atəm in nətɨ Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Narmɨn Rəha Uhgɨn təməriauəh e nəmiəgəhiən rəha Iesu, kəni nian in təmsɨpən e nəhu Jotən, kəni Narmɨn Rəha Uhgɨn təməghati=pən e nɨki Iesu məmə in otuvən əpəha təpiə-məpiə ikɨn. ");
INSERT INTO tnp_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kəni e nian fote, Setən təməfən-əfən kəm Iesu. E nian mɨn rəfin əha, in təsauəniən, kəni e naunun nian mɨn əha, nəumɨs təmus agɨn in. ");
INSERT INTO tnp_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kəni Setən təni=pən kəm Iesu məmə, “Okəmə ik Nətɨ Uhgɨn, əni=pən kəm kəpiel u məmə otəuhlin mol pɨret lan.” ");
INSERT INTO tnp_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Kəni Iesu təmuhalpɨn nəghatiən rəha Setən məmə, “Kəmətei e Nauəuə Rəha Uhgɨn məmə, ‘Nətəmimi ko kəsotəmiəgəhiən e nauəniən əmə.’” ");
INSERT INTO tnp_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kəni Setən təmit Iesu mian əpəha e nɨtəuət əfəməh kəti, kəni məgətun uəhai əmə in e nɨtənimtəni mɨn rəfin, mɨne e nəuvɨriən rəhalah, ");
INSERT INTO tnp_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","kəni in təməni=pən kəm in məmə, “Iəu o iəkəfɨnə e nəhlməm narmənɨgiən mɨn mɨne nepətiən mɨn rəfin, mɨne nəmemtəhiən rəhalah, mətəu-inu natimnati rəfin tətatɨg e nəhlmək, kəni iəkəhrun negəhan-pəniən kəm iətəmi-pəh iəkolkeikei məmə iəkəfən kəm in. ");
INSERT INTO tnp_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Mətəu nəmə nəkəfaki=pa kəm iəu, kəni natimnati mɨn rəfin u rəham.” ");
INSERT INTO tnp_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kəni Iesu təni=pən kəm in məmə, “Nauəuə Rəha Uhgɨn tətəni məmə, ‘Onəkotəfaki əmə kəm rəhatəmah Iərmənɨg Uhgɨn, kəni in əmə, onautol əmə rəhan nətəlɨgiən.’” ");
INSERT INTO tnp_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kəni Setən təmit in mian əpəha Jerusɨləm e nəhue nimə əpəha ilɨs agɨn e Nimə Rəha Uhgɨn. Kəni məni=pən kəm in məmə, “Okəmə ik Nətɨ Uhgɨn, iuvɨg-to u ikɨnu, ");
INSERT INTO tnp_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","mətəu-inu kəmətei e Nauəuə Rəha Uhgɨn məmə, ‘In otahli=pa nagelo mɨn rəhan kəhuva motəsal vivi ohnik, ");
INSERT INTO tnp_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","kəni ilah okotos əmə ik ilɨs e nəhlmɨlah məmə onəsoriniən nəhlkəm e kəpiel.’” ");
INSERT INTO tnp_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Kəni Iesu təmuhalpɨn nəghatiən rəha Setən məmə, “Nauəuə Rəha Uhgɨn tətəni mɨn məmə, ‘Onəsotoliən nəfən-əfəniən kəm rəhatəmah Iərmənɨg Uhgɨn məmə otol nati kəti, məmə nəkoteruh məmə in tətatɨg itəmah min, uə kəpə.’” ");
INSERT INTO tnp_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nian Setən təmol naunun e nəfən-əfəniən rəhan, in təmagɨm muvən isəu o Iesu mətəhtahnin mə nian təuvɨr kəti mɨn rəhan otəpanuva mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kəni Iesu təmɨtəlɨg=pən nɨtəni Kaləli, kəni nəsanəniən rəha Uhgɨn təməriauəh e nəmiəgəhiən rəhan. Kəni nəghatiən ohni təmɨtəlau-təlau e lahuənu mɨn tepət e nɨtəni əha. ");
INSERT INTO tnp_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kəni Iesu in təmətəgətun e nimə rəha nuhapumɨniən mɨn, kəni nətəmimi mɨn rəfin kəməutəni-vivi in. ");
INSERT INTO tnp_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kəni Iesu təmuvən Nasərɨt, ikɨn əha in təmepət ikɨn aupən. Kəni e nian rəha Sapət, in təmuvən e nimə rəha nuhapumɨniən təhmen əmə mə in tatol nian mɨn. Kəni in təməhtul məmə otafin Nauəuə Rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kəni kəməfən nauəuə iətəm kəmaiu-aiu rəha iəni u Aiseə. Kəni in təmuahru=pən e iətəm Aiseə təmətei tətəni lanəha məmə, ");
INSERT INTO tnp_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Narmɨn Rəha Uhgɨn tətatɨg lak mətəu-inu təmɨtəpɨn iəu məmə iəkəni pətɨgəm nəniən təuvɨr kəm nanrah mɨn. Kəni təmahli=pa iəu məmə iəkuvən məni=pən kəm nətəmi kəutatɨg e kaləpus məmə iəkɨtɨs ilah, kəni mahli pətɨgəm ilah, kəni məni=pən kəm nətəmimi mɨn nəhmtɨlah təpɨs məmə okoteruh nati. Kəni təmahli=pa iəu məmə iəkuvən mɨtɨs nɨki nətəmimi, ");
INSERT INTO tnp_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","kəni məni pətɨgəm məmə nian tɨnuva rəkɨs məmə Iərmənɨg otəgətun rəhan nəuvɨriən kəni mosmiəgəh nətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nian təmafin rəkɨs nauəuə u, kəni maiu-aiu mɨn məfən nauəuə u kəm iətəm tətələhu nauəuə u, kəni mətəharəg məmə otəgətun nətəmimi. Kəni nəhmtɨ nətəmimi rəfin əha imə təməhtul əmə lan. ");
INSERT INTO tnp_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kəni in təmətəghati kəm lah mətəni məmə, “Rəueiu u e nian u nəutətəlɨg lan e Nauəuə Rəha Uhgɨn, Uhgɨn tɨnol əpu nəghatiən mɨn əha tɨnuva matol nɨpəhriəniən lan.” ");
INSERT INTO tnp_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nətəmimi rəfin kəmotəni-vivi in, kəni narmɨlah təmiuvɨg o nəghatiən təuvɨr mɨn in tətəni, kəni məutəni kəm lah mɨn məmə, “?Nətɨ Josɨp u, uə kəpə?” ");
INSERT INTO tnp_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kəni Iesu təməni=pən kəm lah məmə, “Iəkəhrun məmə onəkotəni=pa nəghatiən əuas u kəm iəu u tətəni məmə, ‘Toktə, ol vivi aru-to nɨpətɨm,’ u nɨpətɨn məmə, ‘Natimnati mɨn əha u kətəni mə nəmol rəkɨs ilah əpəha Kapeniəm, təuvɨr məmə nəkuva mol mɨn ilah u ikɨnu imam ikɨn.’ ");
INSERT INTO tnp_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Pəhriən, iəkəni kəm təmah məmə ko nətəmimi kəsotɨsiaiən iəni kəti iətəm tatsɨpən e lah. ");
INSERT INTO tnp_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","E nian rəha Elaijə, nuhuən təməsəfuviən o nu kɨsɨl mɨne məuɨg sikɨs, nəumɨs təman kəni nauəniən tɨkə. Kəni iətəni pəhriən kəm təmah məmə, e nian əha, pətalɨmɨs mɨn tepət u ikɨnu Isrel, ");
INSERT INTO tnp_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","mətəu Uhgɨn təməsahli-pəniən Elaijə məmə otuvən masiru e lah. Kəpə. In təmahli=pən məmə otasiru e pətalɨmɨs kəti əpəha Saedon e taun Sarefat, kəni pətan u in pətan Ianihluə kəti. ");
INSERT INTO tnp_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kəni e nian rəha iəni Elisa, nətəmimi tepət kəməutatɨg Isrel u kəmautos nɨmɨsiən u leprosi e nɨpətɨ lah, kəni Elisa təməsol viviən kəti mɨne. Mətəu in təmol vi əmə Neman u iətəm Sɨriə, in iətəm Ianihluə kəti.” ");
INSERT INTO tnp_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kəni e nian nətəmimi u e nimə rəha nuhapumɨniən kəmotətəu nəghatiən əha niəməha təmol pɨk ilah. ");
INSERT INTO tnp_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kəni kəmotəhtul uəhai əmə motaskəlɨm Iesu, motələs mohiet itaun, məhuvən əpəha e kiəkɨs e nɨkalɨ taun məmə kotəraki pətɨgəm lan. ");
INSERT INTO tnp_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mətəu Iesu təmaliuək rəkɨs e lah miet e nəlugɨn e lah kəni matuvən. ");
INSERT INTO tnp_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kəni Iesu təmeiuaiu muvən əpəha Kapeniəm, taun kəti mɨn rəha Kaləli. Kəni e nian rəha Sapət in təmətəgətun nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Kəni nətəmimi iətəm kəmotətəu rəhan nəghatiən, narmɨlah təmiuvɨg pɨk ohni mətəu-inu rəhan nəghatiən təfɨgəm, nepətiən tatɨg lan. ");
INSERT INTO tnp_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kəni in əpəha imə e nimə rəha nuhapumɨniən, kəni suah kəti əha ikɨn iətəm narmɨn tərah kəti tətatɨg lan. Kəni in təmagət əfəməh məmə, ");
INSERT INTO tnp_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“!Ei, Iesu iətəm Nasərɨt! ?Təhro? ?Nəmuva məmə nəkol nərahiən kəm tɨmah? Inəhrun rəkɨs ik. Ik Iətəmi Asim rəha Uhgɨn!” ");
INSERT INTO tnp_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Mətəu Iesu təmagət əskasɨk lan məmə, “!Aaah, sagətiən! !Iet magɨm rəkɨs e suah u!” Kəni narmɨn tərah əha təmol suah u tɨsɨpəri morin e nɨftəni e nəlugɨlah, əmeiko magɨm rəkɨs lan, mətəu təməsərəkɨniən suah u. ");
INSERT INTO tnp_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kəni nətəmimi rəfin ikɨn əha narmɨlah təmiuvɨg kəni məutəni=pən kəm lah mɨn məmə, “Ei! ?Nəghatiən nak u? Suah u, təmagət əskasɨk e narmɨn tərah mɨn e nəghatiən rəha nepətiən mɨne nəsanəniən, kəni ilah kəmohiet e nətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kəni nəniən rəha Iesu təmaiu mɨtəlau e nɨtəni əha. ");
INSERT INTO tnp_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iesu təməhtul kəni miet e nimə rəha nuhapumɨniən muvən əpəha e nimə rəha Saimon. E nian əha, uhu Saimon tatɨmɨs matətəpu-ətəpu pɨk, kəni ilah kəmotəni=pən kəm Iesu məmə oteruh. ");
INSERT INTO tnp_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Kəni Iesu təməhtul=pən iuəkɨr ohni kəni magət əskasɨk e nɨmɨsiən, kəni pətan u təsanən. Əmeiko in təhtul kəni mol nauəniən nɨglah. ");
INSERT INTO tnp_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nian mɨtɨgar tɨniuvɨg rəkɨs, nətəmimi kəmotos nətəmimi mɨn rəfin u nətəm kautohmɨs e nɨmɨsiən pɨsɨn pɨsɨn mɨn məhuva o Iesu. Kəni in təmələhu=pən nəhlmɨn e lah kətiəh kətiəh, kəni ilah rəfin kəmotəsanən. ");
INSERT INTO tnp_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kəni iərmɨs mɨn kəmohiet motagɨm e nətəmimi tepət məutagət əfəməh məmə, “!Ik Nətɨ Uhgɨn!” Mətəu Iesu təmagət əskasɨk e lah mahtɨpəsɨg e lah o nəghatiən mətəu-inu ilah kotəhrun məmə in Krɨsto iətəm Uhgɨn təmahli=pa. ");
INSERT INTO tnp_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kəni kəməni lauɨg lan, Iesu təmiet əha ikɨn əha muvən əpəha ikɨn kəti iətəm nətəmimi kohkə ikɨn. Mətəu nətəmimi kəmotəsal lan, kəni nian kəmoteruh in, ilah kəməhuva ohni məutalkut məmə okotəniəhu məmə in təsagɨmiən məpəh ilah. ");
INSERT INTO tnp_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mətəu in təməni=pən kəm lah məmə, “Kəpə. Iəu iəkəkeikei muvən lahuənu pɨsɨn mɨn nəuvein, məni pətɨgəm nəniən təuvɨr rəha Narmənɨgiən Rəha Uhgɨn, mətəu-inu Uhgɨn təmahli=pa iəu məmə iəkol lanu.” ");
INSERT INTO tnp_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kəni in təmatuvən mətan e nɨtəni Jutiə mətəni pətɨgəm nəghatiən rəha Uhgɨn e nimə rəha nuhapumɨniən mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nian kəti, Iesu təmətəhtul e nɨkalɨ nəhu asoli, nərgɨn u Lek Kaləli. Kəni nɨmənin nətəmimi kəməhuva motəhtul motohtəlau lan məutatətə kəni məutəhgi ilah mɨn məmə okotətəu nəghatiən rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kəni in təmeh bot keiu rəha nətəm kautos nəmu e nɨpəkɨl mətəu ilah kəutafəl nopɨn mɨn rəhalah. ");
INSERT INTO tnp_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Kəni Iesu təmuvən e bot rəha Saimon, kəni mətapuəh ohni məmə otiuvi-pah bot tuvən ihluə nəuvetɨn. Nian Saimon təməharəg pətɨgəm e bot, kəni Iesu təməharəg lan mətəgətun nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nian Iesu təməghati rəkɨs kəm nətəmimi, kəni məni=pən kəm Saimon məmə, “Saimon, otasuə kotəsəu-pah lokamnɨm, kəni ko motəraki e nopɨn motos nəmu nəuvein.” ");
INSERT INTO tnp_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Kəni Saimon təni məmə, “Iətəmi asoli, iəmotalkut pɨk lapɨn mətəuarus=pa u, məsotosiən nəmu kəti mɨne. Mətəu ik nɨnəni mɨn mə okəhuvən, təuvɨr pəh kəhuvən motəraki mɨn e nopɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kəni nian ilah kəmotol, kəmotos pɨk nəmu tepət e rəhalah nopɨn, kəni nopɨn mɨn rəhalah kəmotəri kəni motasisi e nəmu mɨn, kəni nopɨn mɨn təsuvəhiən kotəhapu. ");
INSERT INTO tnp_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kəni ilah kəmotauɨn=pən mɨn e nətəmimi e bot pɨsɨn mə kəhuva motasiru e lah. !Kəni ilah kəməhuva motəmki=pən nəmu e bot pəti mil kuəri muəriauəh e nəmu, kəni iuəkɨr bot mil kuamnɨm! ");
INSERT INTO tnp_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nian Saimon Pitə təmeruh nati u, kəni təmasiəulɨn=pən kəm Iesu e nɨsiaiən mətəni məmə, “!Iərmənɨg, uvən isəu ohniəu, iəu iəsəhmeniən, iəu iol təfagə tərah!” ");
INSERT INTO tnp_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","In təməghati lanu mətəu-inu in mɨne nətəmi mɨn əha e bot mil, kəmotauɨt pɨk narmɨlah təmiuvɨg o nəmu mɨn u tepət lanəha. ");
INSERT INTO tnp_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Kəni Jemɨs mɨne Jon, nətɨ Səpəti mil u katiavi nəmu mɨn ilahal Saimon, ilau mɨn kəmuauɨt pɨk narmɨlau tiuvɨg o nəmu mɨn u. Mətəu Iesu təməni=pən kəm Saimon məmə, “Səgɨniən. Ik iətəm rəha niuviən nəmu, mətəu rəueiu əha matuvən, ik onəkiuvi=pa nətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kəni nian ilah kəmotiuvi-pari rəhalah bot mɨn, kəni motəpəh ərəfin natimnati kəni məhuərisɨg e Iesu, kəni məhuva rəhan mɨn nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nian Iesu təmətaliuək e taun kəti, suah kəti iətəmi təmos nɨmɨsiən u leprosi təmaliuək muva. Nɨmɨsiən u leprosi təmaiu ərəfin e nɨpətɨn. Kəni nian in təmeruh Iesu, təmeiuaiu masiəulɨn=pən nɨpənəgɨn e nɨftəni mətəfən nɨsiaiən kəm in, mətasək mətəkeikei kəm in mətəni kəm in məmə, “Iərmənɨg, okəmə nəkolkeikei, kəni nəkəhrun nol viviən iəu, kəni mafəl rəkɨs namɨkmɨkiən lak.” ");
INSERT INTO tnp_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Kəni Iesu təmuahru e nəhlmɨn mələhu=pən lan məni məmə, “Əuəh. Iəkolkeikei. !Əuvɨr-tə!” Əmeiko rəueiu agɨn, nɨmɨsiən u leprosi tɨkə lan. ");
INSERT INTO tnp_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kəni Iesu təməniəhu məmə otəsəni pətɨgəmiən natimnati mɨn u kəm nətəmimi, mətəu təməni kəm in məmə, “Uvən meruh pris kəti pəh in oteh məmə nɨpətɨm tɨnol lanko, kəni ko ik mol sakrifais kəm Uhgɨn iətəm Lou rəha Mosɨs tətəni məmə nəmə suah kəti iətəm rəhan leprosi tɨnɨkə, kəni nətəmimi okotəhrun məmə nɨnəuvɨr pəhriən, kəni rəham namɨkmɨkiən tɨnɨkə.” ");
INSERT INTO tnp_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mətəu nanusiən rəha Iesu təmiet muvən ikɨn mɨn rəfin, kəni nətəmimi tepət kəməhuva məmə okotətəlɨg e rəhan nəgətuniən, kəni məmə in otol vivi nɨmɨsiən mɨn rəhalah. ");
INSERT INTO tnp_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mətəu nian tepət, in tatuvən təpiə-məpiə ikɨn, in pɨsɨn əmə, məmə otətəfaki. ");
INSERT INTO tnp_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nian kəti, Iesu təmətəgətun əpəha ima e nimə kəti, kəni Farəsi mɨn, mɨne nəgətun mɨn rəha Lou, ilah mɨn əpəha ikɨn kəutəharəg, kəmotsɨpən əpəha lahuənu mɨn e nɨtəni Kaləli, mɨne nɨtəni Jutiə, mɨne taun Jerusɨləm. Kəni nəsanəniən rəha Iərmənɨg tətatɨg o Iesu məmə in otol vi nətəmimi mɨn u kautohmɨs. ");
INSERT INTO tnp_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","E nian əha, nətəmimi nəuvein kəmotələs suah kəti məhuva, in tətapɨli əmə e nɨmahan rəhan mətəu-inu nɨpətɨn nəuvetɨn təmɨmɨs. Kəni ilah kəmotolkeikei məmə okotələs məhuva motələhu=pən e nəhlkɨ Iesu. ");
INSERT INTO tnp_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mətəu ilah kotəruru nuvəniən ima mətəu nətəmimi tepət əha ikɨn. Kəni kəməhuvən əpəha ilɨs e nəhue nimə motos rəkɨs nəhgɨ nimə nəuvetɨn, kəni motəhlman-əhlman e suah u teiuaiu e nɨmahan rəhan muvən iuəkɨr əmə o Iesu. ");
INSERT INTO tnp_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nian Iesu təmeruh rəhalah nəhatətəiən, kəni təni məmə, “Niəli. Rəham nolrahiən mɨn, iəu inos rəkɨs rəkɨs.” ");
INSERT INTO tnp_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Kəni nəgətun mɨn rəha Lou mɨne Farəsi mɨn nɨkilah təhti məmə, “?Iətəmi nak u tətəghati əuvsan məmə in Uhgɨn? Uhgɨn əmə in təhrun nos rəkɨsiən noliən tərah mɨn rəha nətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iesu in tɨnəhrun rəkɨs rəhalah nətəlɨgiən, kəni in təməni=pən kəm lah məmə, “?Təhro nəutətəlɨg lanko? ");
INSERT INTO tnp_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","?Nɨkitəmah təhti məmə nəghatiən u tɨmətɨg o nəniən, ‘Iəkos rəkɨs rəham təfagə tərah mɨn,’ uə nəghatiən u, ‘Əhtul maliuək’? ");
INSERT INTO tnp_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kəni rəueiu onəkoteruh məmə Nətɨ Iətəmimi in tatos nepətiən o nos rəkɨsiən təfagə tərah mɨn u ikɨnu e nəhue nɨtəni.” Kəni in təməni=pən kəm suah u təmatɨmɨs məmə, “Əhtul, mos rəham nɨmahan maliuək matuvən imam ikɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kəni əmeiko təsuvəhiən agɨn, suah u təhtul mələs rəhan nɨmahan mɨnətaliuək mətəni-vivi Uhgɨn matuvən. ");
INSERT INTO tnp_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kəni ilah rəfin kəmotauɨt pɨk ohni narmɨlah təmiuvɨg, kəni mautəni-vivi nərgɨ Uhgɨn, kəni məutərəmrumɨn kəni məutəgɨn nəuvetɨn məutəni məmə, “Nəman, rəueiu kitah kauteruh nati apɨspɨs agɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Uərisɨg e natimnati mɨn u, Iesu təmiet maliuək matuvən, kəni in təmeruh suah kəti iətəm tatos məni rəha takɨs, nərgɨn u Lifai, tətəharəg ikɨn kətətəou=pən takɨs ikɨn. Kəni Iesu təməni=pən kəm in məmə, “Va, muərisɨg lak muva rəhak iətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kəni in təməpəh natimnati mɨn rəfin rəhan, məhtul muərisɨg e Iesu. ");
INSERT INTO tnp_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kəni Lifai təmol nauəniən asoli kəti rəha Iesu əpəha e rəhan nimə. Kəni nətəmimi tepət nətəm kautos məni rəha takɨs, mɨne nətəmi əpnapɨn mɨn kəməhuva məutəharəg pəti ilah min ilah məmə okotauən. ");
INSERT INTO tnp_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kəni Farəsi mɨn mɨne nətəmimi nəuvein mɨn u rəhalah nəgətun mɨn rəha Lou, nɨkilah təsagiəniən kəni məutəni=pən kəm nətəmimi rəha Iesu məmə, “?Təhro itəmah nəutauən pəti əmə itəmah nətəmi kautos məni rəha takɨs mɨne nətəm nol təfagə tərah?” ");
INSERT INTO tnp_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Kəni Iesu təməni=pən kəm lah məmə, “Iətəmimi u in təsɨmɨsiən, təsarəriəiən e toktə. Mətəu iətəm tatɨmɨs, in otarəriə e toktə. ");
INSERT INTO tnp_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Iəu iəməsuvaiən məmə iəkauɨn e nətəmimi mɨn u kotəni məmə kɨnotəhruahru rəkɨs. Mətəu iəmuva məmə iəkauɨn e nətəmimi mɨn u kotəhrun əmə məmə ilah kautol noliən tərah mɨn, məmə okotəuhlin rəhalah nətəlɨgiən.” ");
INSERT INTO tnp_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kəni ilah kəmotəni=pən kəm Iesu məmə, “Nətəmimi rəha Jon Bəptais, nian rəfin kəutəpəh nauəniən məutətuakəm o nəfakiən kəm Uhgɨn, kəni nətəmimi rəha Farəsi mɨn ilah mɨn kautol əmə nati kətiəh, mətəu rəham nətəmimi mɨn kəutauən əmə katɨlpɨn. ?Təhro?” ");
INSERT INTO tnp_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Kəni Iesu təməni=pən kəm lah məmə, “?Nian itəmah nautol nauəniən rəha iətəm təmol əmə marɨt, mətəu okotəni kəm rəhan mɨn məmə okotəkeikei motəpəh nuniən nauəniən, uə kəpə? !Kəpə! ");
INSERT INTO tnp_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mətəu nian tətuva nətəmimi okotələs rəkɨs suah u təmol əmə marɨt motələs məhuvən isəu o rəhan mɨn nətəmimi. Kəni e nian əha, ilah okotəpəh nauəniən lan.” ");
INSERT INTO tnp_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kəni Iesu təməni mɨn nəghatiən əuhlin kəti tol lanu məmə, “Ko suah kəti təsosiən napən vi rəhan məhapu nəuvetɨn, kəni məhli=pən e napən əmnəmɨt məmə otol pəsɨg e iətəm tərah. Mətəu təni məmə otol lanəha, kəni otərəkɨn rəhan napən vi, kəni napən vi nəuvetɨn ko təsəməhli viviən ilau napən əuas. ");
INSERT INTO tnp_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Kəni ko suah kəti təsosiən wain vi miuvi=pən e pətəl əuas u təskasɨk, pətəl u kəmol e nɨlosɨ nəni. Nəmə suah kəti tol lanəha, kəni wain vi otahlɨfu kəni mɨməhrehreh, kəni wain taiəh rəfin, kəni pətəl mɨn, otərah. ");
INSERT INTO tnp_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mətəu wain vi okəkeikei kiuvi=pən e pətəl vi ətmətɨg. ");
INSERT INTO tnp_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kəni iətəmi iətəm təməmnɨm rəkɨs wain əuas, ko in təsolkeikeiən məmə otəmnɨm mɨn wain vi, mətəu in otəni məmə, ‘Wain əuas in təuvɨr.’” ");
INSERT INTO tnp_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nian kəti e Sapət, Iesu mɨne rəhan mɨn nətəmimi kəməutaliuək məutohapumɨn e nasumiən mɨn rəha wit, nati kəti təhmen e rais, kəni rəhan mɨn nətəmimi kəutəhli wit nəuvein məutauɨg rəkɨs nɨlosɨn, kəni mautun. ");
INSERT INTO tnp_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mətəu Farəsi mɨn nəuvein kəmotagət məmə, “!Ei! Sapət u rəueiu, kəni noliən u nautol təsəhmen-pəniən e Lou. ?Təhro itəmah nautol lanko?” ");
INSERT INTO tnp_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Mətəu Iesu təməni=pən kəm lah məmə, “?Itəmah nəsotafiniən e Nauəuə Rəha Uhgɨn, natimnati mɨn əha Kig Tefɨt təmol aupən? Ilah rəhan mɨn nətəmimi nəumɨs təmus ilah. ");
INSERT INTO tnp_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kəni in təmuvən imə e Nima Tapolɨn rəha Uhgɨn, təmos pɨret u iətəm pris mɨn kɨnotəfən rəkɨs kəm Uhgɨn. Kəni Lou tətəni məmə pris mɨn əmə kotəhrun nuniən, mətəu Tefɨt in təmun kəni məfən nəuvein kəm rəhan mɨn nətəmimi məmə okotun.” ");
INSERT INTO tnp_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kəni Iesu təməni=pən kəm lah məmə, “Iəu, Nətɨ Iətəmimi, iəu iətarmənɨg e nian rəha Sapət.” ");
INSERT INTO tnp_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kəni e nian pɨsɨn kəti mɨn rəha Sapət, Iesu təmuvən əpəha imə e nimə rəha nuhapumɨniən, mətəgətun nətəmimi. Kəni ikɨn əha, suah kəti əha ikɨn nəhlmɨn maru təmɨmɨs, ko təsegaruiən lan. ");
INSERT INTO tnp_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kəni nəgətun mɨn rəha Lou, mɨne Farəsi mɨn, ilah kəutəsal məmə okoteruh mə Iesu otol vi suah u e nian rəha Sapət, pəh ilah kotəhrun nəniən mə Iesu təmatgəhli Lou. ");
INSERT INTO tnp_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mətəu Iesu təməhrun əmə nətəlɨgiən rəhalah, kəni təməni=pən kəm suah u nəhlmɨn təmɨmɨs məmə, “Va, məhtul aupən.” Kəni tuvən məhtul=pən əha aupən. ");
INSERT INTO tnp_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kəni Iesu təməni=pən kəm lah məmə, “Iəkolkeikei məmə iəkətapuəh nati kəti o təmah. ?Təhro? ?E nian rəha Sapət, noliən nak in təhruahru e Lou məmə okol, kəhrun noliən nati təuvɨr uə kəhrun noliən nati tərah? ?Okosmiəgəh iətəmi, uə okuhamu itəmi?” ");
INSERT INTO tnp_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Kəni Iesu təməsal=pən meruh nətəmimi mɨtəlau, kəni məni=pən kəm suah u nəhlmɨn təmɨmɨs məmə, “Uahru-to e nəhlməm.” Kəni in təmuahru e nəhlmɨn, kəni nəhlmɨn təuvɨr. ");
INSERT INTO tnp_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mətəu Farəsi mɨn mɨne nəgətun mɨn rəha Lou, nɨkilah nərah pɨk agɨn, kəni məutəghati-əghati kəm lah mɨn məmə okotəhro e suah kəha Iesu. ");
INSERT INTO tnp_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kəni e nian mɨn əha, Iesu təmuvən əpəha ilɨs e nɨtəuət məmə otəfaki, kəni mətəfaki lapɨn mətəuarus tian. ");
INSERT INTO tnp_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kəni tɨnian, in təmauɨn e rəhan mɨn nətəmimi məmə okəhuva moteruh in. Kəni in təmɨtəpɨn rəkɨs tueləf, mauɨn e nərgɨn lah məmə aposɨl mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nərgɨ aposɨl mɨn u tol lanu: Saimon iətəm Iesu təmauɨn e nərgɨ vi mə Pitə, mɨne pian Antɨru, mɨne Jemɨs mɨne Jon, mɨne Fɨlɨp, mɨne Patolomiu, ");
INSERT INTO tnp_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","mɨne Matiu, mɨne Toməs, mɨne Jemɨs nətɨ Alfiəs, mɨne Saimon u kətauɨn lan məmə Selot, ");
INSERT INTO tnp_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","mɨne Jutəs nətɨ Jemɨs, mɨne Jutəs Iskariot u iətəm təmegəhan e Iesu kəm rəhan mɨn tɨkɨmɨr mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kəni Iesu mɨne rəhan aposɨl mɨn kəmoteiuaiu e nɨtəuət məhuva ikɨn kəti təməhli ikɨn, ilah nətəmimi rəhan mɨn tepət, mɨne nətəmimi əpnapɨn mɨn tepət, kəmotsɨpən nɨtəni Jutiə, mɨne Jerusɨləm, mɨne nɨkalkalɨ nɨtəhi Taea mɨne Saedon. ");
INSERT INTO tnp_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ilah kəməhuva məmə okotətəu nəghatiən rəha Iesu, kəni məmə otol vi nɨmɨsiən mɨn rəhalah. Kəni in təmol vi nɨmɨsiən mɨn rəhalah. Kəni in təmol vi mɨn nətəmimi narmɨn tərah mɨn kəmotərəkɨn ilah. ");
INSERT INTO tnp_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kəni nətəmimi nətəm kəməutəhtul təlau-təlau lan, kəmotalkut məmə okotek mətəu-inu nəsanəniən tatsɨpən lan matol vi ilah rəfin. ");
INSERT INTO tnp_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Kəni Iesu təməsal=pən meruh rəhan mɨn nətəmimi, kəni təni=pən kəm lah məmə, “Itəmah u nanrah mɨn, nəutatɨg e nəuvɨriən pəhriən. In nəuvɨriən pəhriən mətəu-inu, itəmah nətəmimi rəha Uhgɨn, kəni in otarmənɨg e təmah. ");
INSERT INTO tnp_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Itəmah nətəm nəumɨs tatus itəmah rəueiu, nəutatɨg e nəuvɨriən pəhriən. In nəuvɨriən pəhriən mətəu-inu, onəkotəni məmə, ‘Əuəh, təhmen.’ Itəmah nətəm nəutasək u rəueiu, nəutatɨg e nəuvɨriən pəhriən. In nəuvɨriən pəhriən mətəu-inu onəkotaləh. ");
INSERT INTO tnp_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Onəkotatɨg e nəuvɨriən pəhriən nian nətəmimi kəutəməki e təmah, kəni kəsegəhaniən e təmah məmə onəkotol nati kətiəh itəmah min ilah, kəni kətəni rah itəmah, kəni kətərəkɨn nərgɨ təmah məmə itəmah rəha iərmɨs mɨn, kəni ilah kautol noliən mɨn əha kəm təmah mətəu-inu iəu Nətɨ iətəmimi, kəni itəmah rəhak mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","E nian mɨn əha, nəkotagiən, kəni motəmako e nagiəniən mətəu-inu nətəouiən asoli rəhatəmah rəha natimnati mɨn əha tətatɨg e negəu e neai. Nɨkitəmah otagiən mətəu tɨpɨlah mɨn kəmotol noliən kətiəh əmə kəm iəni mɨn aupən ikɨn. ");
INSERT INTO tnp_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mətəu, kəsi, nərahiən asoli otuva o təmah u rəhatəmah nautə tepət rəueiu mətəu-inu, nɨnotos rəkɨs nagiəniən rəfin iətəm onəkotos, ");
INSERT INTO tnp_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kəsi, nərahiən asoli otuva o təmah nətəm nəutauən pɨk məutətəu təuvɨr lanəha rəueiu mətəu-inu, nəumɨs otəpanus itəmah. Kəsi, nahməiən asoli otuva o təmah nətəm nəutaləh əha rəueiu mətəu-inu, onəpanotasək agɨn. ");
INSERT INTO tnp_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kəsi, nərahiən asoli otuva o təmah nian nətəmimi mɨn kautləfəri nərgɨ təmah mətəu-inu, tɨpɨlah mɨn kəməutləfəri lanəha nərgɨ iəni eiuə mɨn aupən ikɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Kəni təməni mɨn məmə, “Mətəu iətəni kəm təmah nətəm nəutətəlɨg lak motəhrun məmə, onəkotəkeikei məutolkeikei rəhatəmah tɨkɨmɨr mɨn, kəni məutol təuvɨr kəm nətəm kəutəməki e təmah, ");
INSERT INTO tnp_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","kəni nian nətəmimi kəutəuiakən e təmah, mətəu itəmah onəkotəni=pən kəm Uhgɨn məmə otəfən rəhan nəuvɨriən kəm lah, kəni onəkotəfaki o nətəmimi u kautol tərah e təmah. ");
INSERT INTO tnp_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Okəmə suah kəti tem nɨkapɨm, əfən mɨn nəven tem. Okəmə suah kəti tos rəham kot, kəni ətəhtul maru mɨn o nəfən mɨniən rəham sot. ");
INSERT INTO tnp_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kəni əfən mɨn nati nak kəm iətəmimi kəti nəmə teasiə lam, kəni iətəmimi kəti təmos rəham nəuvein natimnati, əpəh əmə, məsətapuəhiən lan. ");
INSERT INTO tnp_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kəni otol təuvɨr kəm nətəmimi rəfin e noliən mɨn rəfin iətəm nəkotolkeikei məmə nətəmimi okotol kəm təmah. ");
INSERT INTO tnp_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nɨkitəmah təsəhtiən məmə okləfəri itəmah nəmə itəmah nautolkeikei əmə nətəmimi mɨn u kotolkeikei əmə itəmah mətəu-inu, nətəmi kotərah mɨn, ilah mɨn kotolkeikei ilah mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nɨkitəmah təsəhtiən məmə okləfəri itəmah nəmə itəmah nautol təuvɨr əmə kəm nətəmi mɨn u kautol təuvɨr əmə kəm təmah. Mətəu-inu nətəm kotərah mɨn kautol mɨn nati kətiəh. ");
INSERT INTO tnp_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nɨkitəmah təsəhtiən məmə okəni-vivi itəmah nəmə nautegəhan e natimnati kəm nətəmi nəuvein nətəm ilah kotəhrun nalpɨn-pɨnəiən nɨtain kəm təmah. Mətəu-inu nətəmimi kotərah, ilah mɨn kəutegəhan e natimnati kəm lah mɨn məmə nian kəti kəpanos=pən mɨn nɨtain. ");
INSERT INTO tnp_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Mətəu onəkotəkeikei məutolkeikei rəhatəmah mɨn tɨkɨmɨr mɨn, kəni mautol təuvɨr kəm lah, kəni mautegəhan=pən e natimnati u kəmotos məmə okəsotalpɨniən. Okəmə onautol lanəha, rəhatəmah nətəouiən asoli tətatɨg, kəni nəkəhuva nenətɨ Uhgɨn Ilɨs Agɨn, mətəu-inu in tatol təuvɨr kəm nətəm kəutaumɨs mɨn, kəni matol təuvɨr mɨn kəm nətəmi u kəsotəniən məmə nɨkilah tagiən o natimnati təuvɨr u in tatol kəm lah. ");
INSERT INTO tnp_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mətəu onəkotolkeikei nətəmimi təhmen əmə e rəhatəmah Tatə tatolkeikei nətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Kəni Iesu təməni məmə, “Onəsəniən noliən rəha iətəmimi məmə tərah, pəh kəsəniən rəham noliən məmə tərah; onəsəniən məmə suah kəti otəkeikei mos nalpɨniən o təfagə tərah rəhan, kəni pəh okəsəniən məmə ik onəkəkeikei mos nalpɨniən o təfagə tərah kəti rəham; salpɨniən malu e noliən tərah rəha iətəmimi u tatol kəm ik, kəni pəh kəsalpɨniən kalu e noliən tərah rəham. ");
INSERT INTO tnp_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ətuati, məfən kəm nətəmimi, kəni Uhgɨn otəfɨnə natimnati tepət tepət kəm ik, təhmen e kətɨm u təməri kasin-asin kargɨn təri məriauəh kəni mətauvəregɨn u okəfɨnə e nəhlməm. Okəmə nəkəfən tepət, okəfɨnə tepət kəm ik, mətəu nəmə nəkəfən təkəku əmə, okəfɨnə əmə təkəku kəm ik.” ");
INSERT INTO tnp_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kəni in təməni nəghatiən əuhlin kəti kəm lah məmə, “Iətəmi nəhmtɨn təpɨs ko təsitiən iətəmi kəti mɨn u nəhmtɨn təpɨs mɨn. !Kəsi, okiauvɨg=pən e nɨpəg asoli! ");
INSERT INTO tnp_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Iətəm kətəgətun, in təsapirəkɨsiən rəhan iəgətun, mətəu iətəmi u tətətəlɨg vivi mətɨtəu=pən iəgətun e nətəlɨgiən mɨn rəfin, in otuva məhmen e rəhan iəgətun. ");
INSERT INTO tnp_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“?Təhro nətəni nɨpɨspɨsɨ nɨgi e nəhmtɨ piam, mətəu nɨkim təsəhtiən nɨgi asoli agɨn e nəhmtəm? ");
INSERT INTO tnp_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","?Nəmə nəsəhruniən nɨgi asoli e nəhmtəm, kəni onəkəhro mos rəkɨs nɨpɨspɨsɨ nɨgi e nəhmtɨ piam? !Itəmah nəfaki eiuə mɨn! Aupən mos rəkɨs nɨgi asoli e nəhmtəm, kəni məhrun neruhiən nɨftəni e nəhmtɨ piam kəti.” ");
INSERT INTO tnp_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Mətəu Iesu təkeikei mətəni məmə, “Ko nɨgi katun kəti kotəsəuəiən e nɨgi kəsuniən, təhmen=pən əmə e nɨgi kəsuniən ko təsəuəiən e nɨgi katun, ");
INSERT INTO tnp_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","mətəu kəhrun neruhiən nɨgi e nəuan. Ko iətəmi təsəhliən nəua nɨgi katun e nɨgi akonə, kəni ko iətəmi təsəhliən nəua nɨgi ətəhiən e nəuanɨləuɨs arfu. ");
INSERT INTO tnp_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Iətəmi təuvɨr, nɨkin təriauəh e natimnati təuvɨr mɨn, kəni in tatol natimnati təuvɨr. Kəni iətəm tərah, nɨkin təriauəh əmə e noliən tərah mɨn, kəni in tatol əmə noliən tərah; mətəu-inu e nian in tətəghati, kəni natimnati mɨn əha e nɨkin kautohiet.” ");
INSERT INTO tnp_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Kəni Iesu təməni məmə, “?Təhro nəutauɨn lak məmə ‘Iərmənɨg, Iərmənɨg,’ mətəu nəsotoliən nati iətəni? ");
INSERT INTO tnp_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Pəh iəkəgətun itəmah e noliən rəha suah kəti iətəm təmuva ohniəu, kəni mətətəu nəghatiən mɨn rəhak, kəni matol natimnati mɨn iətəm iətəni ilah. ");
INSERT INTO tnp_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","“Kəni in təhmen əmə e iətəmimi u təmol rəhan nimə. Təmaupən mel nɨftəni meiuaiu muvən mafəl vivi kəpiel əpəha ləhtəni, kəni mol pən rəhan nimə ikɨn. Nian nuhuən təməfuv maiu mahruəh muva mələs pɨkɨn, mətəu təsəlauəliən lan, mətəu-inu təmol təskasɨk. ");
INSERT INTO tnp_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mətəu iətəmi iətəm tətətəu nəghatiən rəhak kəni məsoliən, in təhmen=pən e iətəm təmol pəri rəhan nimə əmə e nɨftəni. Nian nuhuən təməfuv maiu mahruəh muva mələs pɨkɨn nimə, kəni əmeiko təmei morin məhapu-əhapu.” ");
INSERT INTO tnp_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nian Iesu təməghati rəkɨs kəm nətəmimi, kəni in təmuvən əpəha e taun Kapeniəm. ");
INSERT INTO tnp_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kəni ikɨn əha, iətəmi asoli kəti rəha soldiə mɨn rəha nətəm Rom tətatɨg, kəni slef kəti əha ikɨn rəhan iətəmimi in tolkeikei pɨk, mətəu slef əha tatɨmɨs pɨk, rəhan nahməiən tepət. ");
INSERT INTO tnp_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kəni e nian iətəmi asoli əha təmətəu nəniən rəha Iesu, kəni in təmahli rəkɨs nətəmi asoli nəuvein rəha nətəm Isrel məmə okəhuvən motəni=pən kəm Iesu məmə otuvən mol vi rəhan slef. ");
INSERT INTO tnp_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kəni nətəmi asoli mɨn əha kəməhuva moteh Iesu, məutətapuəh əskasɨk ohni mautəni məmə, “Iərmənɨg, təhruahru əmə məmə nəkasiru e suah kəha, ");
INSERT INTO tnp_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","mətəu-inu in tolkeikei pɨk kitah nətəm Isrel, kəni in təmasiru mol nimə rəha nuhapumɨniən.” ");
INSERT INTO tnp_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kəni Iesu təmɨtəu=pən ilah. Kəni nian kɨnəhuva iuəkɨr o nimə, iətəmi asoli rəha soldiə mɨn tahli=pən rəhan mɨn nətəmimi kəhuvən moteruh Iesu məutəni rəhan nəghatiən u məmə, “Iərmənɨg, suvaiən nahgim təsɨkəiən, mətəu-inu iəu iəsəhmeniən məmə nəkuva imak ikɨn. ");
INSERT INTO tnp_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kəni tol lanu, iəu iəsəhmeniən mə iəkuva meh ik. Ik iətəmi asoli kəti, mətəu iəu iətəmi əkəku əmə. Mətəu əghati əmə, kəni rəhak iol əhruin, in otətəu təuvɨr mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Iəkəhrun məmə ik natos narmənɨgiən məmə nɨmɨsiən otəkeikei mol nəuiam. Iəkəhrun mətəu-inu iəu mɨn, rəhak nətəmi asoli mɨn kəutarmənɨg lak, kəni iatol nəuialah. Kəni soldiə mɨn nəuvein əha ikɨn nətəm iəu iətarmənɨg e lah. Nəmə iəkəni kəm kəti məmə, ‘Uvən,’ kəni tuvən. Kəni nəmə iəkəni kəm kəti məmə, ‘Va,’ kəni tuva. Kəni nəmə iəkəni kəm rəhak slef məmə, ‘Ol nati u,’ kəni tol nati əha.” ");
INSERT INTO tnp_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nian Iesu təmətəu nəghatiən u, narmɨn təmiuvɨg pɨk o nəghatiən rəha suah u. Kəni in təmeirair məni=pən kəm nəhlin nətəmimi u kəutəhtul uərisɨg lan məmə, “Iəkəni kəm təmah məmə, suah u səniəmə in iətəm Isrel. Kəni nati əpnapɨn nətəm Isrel, mətəu iəseruhiən ilah kəti rəhan nəhatətəiən iahgin təhmen=pən lan.” ");
INSERT INTO tnp_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kəni e nian iahlirəkɨs mɨn rəha iətəmi asoli kəmohtəlɨg=pən imə, kəni moteruh iol əhruin əha tɨnəsanən rəkɨs. ");
INSERT INTO tnp_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kəni təsuvəhiən e natimnati mɨn u, Iesu təmuvən e taun kəti nərgɨn u Nain, ilah rəhan mɨn nətəmimi mɨne nɨmənin nətəmimi tepət kautəhuərisɨg lan. ");
INSERT INTO tnp_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kəmol nɨpai e kəpiel tɨtəlau e taun əha, kəni nian Iesu təmuva iuəkɨr o namtɨhluə rəha taun, meruh nətəmimi kautsɨpən e taun mautələs iətəm təmɨmɨs kəti. In iətəm aluə iərman, nətɨ pətalɨmɨs kəti in kətiəh əmə. Kəni nɨmənin nətəmimi tepət e taun əha kəutaliuək pəti ilah pətalɨmɨs əha. ");
INSERT INTO tnp_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mətəu nian Iərmənɨg təmeh pətalɨmɨs əha, nɨkin tahmə pɨk ohni, kəni məni=pən kəm in məmə, “Sasəkiən.” ");
INSERT INTO tnp_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kəni in təmuvən mek uvləuvlə u kətəlis suah u təmɨmɨs lan, kəni kəmotəhtul. Kəni Iesu təməni=pən məmə, “!Iətəm aluə! !Iətəni kəm ik məmə, əhtul!” ");
INSERT INTO tnp_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kəni iətəm təmɨmɨs təməmiəgəh kəni məhtul, kəni mɨnətəghati. Kəni Iesu təfən iətəm aluə əha kəm rəhan mamə. ");
INSERT INTO tnp_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nətəmimi rəfin kəmotəgɨn məutərəmrumɨn, kəni mautəni-vivi Uhgɨn məmə, “!Iəni asoli kəti tɨnuva u rəueiu kəutatɨg kitah min!” Kəni məutəni mɨn məmə, “!Uhgɨn təmuva məmə otasiru e rəhan mɨn nətəmimi!” ");
INSERT INTO tnp_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kəni nanusiən rəha Iesu təmaiu mɨtəlau ikɨn mɨn rəfin e nɨtəni Jutiə kəni e nɨftəni mɨn rəfin mɨn iuəkɨr ohni. ");
INSERT INTO tnp_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nətəmimi rəha Jon Bəptais kəmotəni=pən kəm in natimnati rəfin iətəm Iesu təmol ilah. Kəni Jon Bəptais təmauɨn e rəhan keiu iətəmimi mil kiəuva ohni, ");
INSERT INTO tnp_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","kəni tahli rəkɨs ilau məmə okian mueruh Iərmənɨg muətapuəh ohni məmə, “?Təhro? ?Ik u iətəm kəmətəni aupən məmə suah kəti otuva, uə itɨmah iəutəhtahnin iətəmimi kəti mɨn məmə otəpanuva mɨn?” ");
INSERT INTO tnp_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kəni nian suah mil kəmiəuva mueruh Iesu, kəmuəni=pən kəm in məmə, “Jon Bəptais təmahli=pa itɨmlau iəkiəuva məmə iəkuətapuəh ohnik məmə, ‘?Təhro? ?Ik u iətəm kəmətəni aupən məmə suah kəti otuva, uə itɨmah iəutəhtahnin iətəmimi kəti mɨn məmə otəpanuva mɨn?’” ");
INSERT INTO tnp_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kəni e nian əmə əha ilau kəmiəuva mueruh Iesu lan, mətəu Iesu tatol nɨmɨsiən tepət kotəuvɨr. Nəuvein kautos nɨmɨsiən pɨsɨn pɨsɨn mɨn, nəuvein narmɨn tərah tətatɨg e lah. Kəni nətəmimi tepət nəhmtɨ lah tərah, mətəu Iesu təmol vivi ilah. ");
INSERT INTO tnp_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kəni Iesu təməni=pən kəm lau məmə, “Iatəlɨg mian muəni=pən natimnati mɨn ərəfin u kəm Jon, nati iətəm nəmuətəu kəni mueruh. Nətəmi nəhmtɨlah təpɨs kɨnauteruh nati. Kəni nətəmimi nətəm nəhlkɨlah tərah kɨnotətəu təuvɨr kəni mɨnəutaliuək. Kəni nətəmimi mɨn u kəmotos nɨmɨsiən leprosi, nɨlosɨlah tɨnəuvɨr. Kəni nətəmimi mɨn u nɨpəgtəlgɨlah təmalu, rəueiu əha kɨnautətəu nati. Kəni nətəmimi mɨn u kəmohmɨs, kɨnotəmiəgəh mɨn. Kəni rəueiu, iətəmi kəti tɨnatənɨ pətɨgəm nanusiən təuvɨr kəm nanrah mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Iətəmimi otatɨg e nəuvɨriən pəhriən nəmə in təsəhlmaniən e nəhatətəiən lak o natimnati mɨn iətəm iəu iatol uə iəsoliən.” ");
INSERT INTO tnp_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nian iahləpis mil rəha Jon ilau kəmiatəlɨg mɨn, kəni Iesu tɨnətuəuin mətəghati e Jon kəm nətəmimi mɨn u kəutəharəg əha ikɨn, mətəni məmə, “?Aupən, nəmautəhuvən ikɨn təpiə-məpiə ikɨn məmə nəkoteh nak? ?Nəməhuvən məmə nəkotafu iətəmi əpnapɨn əmə kəti təhmen e nɨmanuvehli əfəməh iətəm nɨmətagi tətalɨfu alɨfu əpnapɨn əmə? Kəpə. ");
INSERT INTO tnp_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","?Kəni təhro itəmah nəmohiet, məmə nəkotafu iətəmi kəti iətəm tatuvən e napən təuvɨr nəhmtɨn tiəkɨs? Kəpə. Nətəmimi kautəhuvən e napən təuvɨr, məutagiən əmə o rəhalah nautə, ilah kəutatɨg e nimə təuvɨr mɨn təhmen e rəha kig. ");
INSERT INTO tnp_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","?Mətəu nati nak əha nəməhuvən məmə nəkoteruh, iəni kəti, uə? Əuəh, pəhriən, mətəu iətəni kəm təmah məmə in ilɨs tapirəkɨs iəni. ");
INSERT INTO tnp_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Suah u inu Nauəuə Rəha Uhgɨn təmətəghati lan. Uhgɨn təməni məmə, ‘Otafu-to. Iətahli=pɨnə iahləpis iətəm otos rəhak nəghatiən. In otaupən lam məmə otol əpenə-penə e rəham suaru.’ ");
INSERT INTO tnp_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Iətəni kəm təmah məmə, nətəmi u kəmotair e nɨftəni u, kəti təsapirəkɨsiən suah kəha Jon. Kəni mətəu iətəmi in ləhtəni agɨn e Narmənɨgiən Rəha Uhgɨn, in ilɨs tapirəkɨs Jon.” ");
INSERT INTO tnp_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nian nətəmi əpnapɨn, mɨne nətəmimi rəha nosiən takɨs kəmotətəu nəghatiən rəha Iesu, ilah kəmotəni məmə suaru rəha Uhgɨn in suaru əhruahru. Kəutəni lanəha mətəu-inu Jon təmol bəptais rəkɨs e lah. ");
INSERT INTO tnp_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mətəu Farəsi mɨn mɨne nəgətun mɨn rəha Lou, ilah kəməsotosiən bəptais rəha Jon, kəni inəha ilah kəmotəpəh suaru rəha Uhgɨn e nəmiəgəhiən rəhalah. ");
INSERT INTO tnp_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kəni Iesu təməghati mɨn məmə, “?Oiəkəni noliən rəha nətəmimi u rəueiu, məmə təhmen e nak? ?Kəni rəhalah nətəlɨgiən təhro? ");
INSERT INTO tnp_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ilah kotəhmen=pən e kəlkələh mɨn kəutəharəg ikɨn katol makɨt ikɨn məutahkul məutauɨn e lah mɨn nəuvein məmə, ‘Itɨmah iəmotahli nau kəm təmah məmə onəkautol danɨs rəha nagiəniən lan, mətəu itəmah nəsotoliən danɨs. Kəni itɨmah iəməutasək eiuə rəha nɨmɨsiən, mətəu nəsotasəkiən kitah min itəmah.’ ");
INSERT INTO tnp_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Iatəni lanu mətəu-inu nian Jon Bəptais təmuva, mətətuakəm məsuniən nauəniən nian tepət o nəfakiən, məsəmnɨmiən wain. Kəni itəmah nəutəni məmə, ‘Suah kəha, narmɨn tərah kəti tətatɨg lan.’ ");
INSERT INTO tnp_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mətəu iəu, Nətɨ Iətəmimi, iəmuva mətauən mətəmnɨm wain, kəni itəmah nəutəni məmə, ‘!Otafu-to, suah kəha in iətəmimi rəha nauən pɨkiən mɨne iətəmimi rəha napɨsiən, kəni mətan pəti ilah nətəmimi rəha nosiən məni rəha takɨs, mɨne nətəmimi nətəm nol təfagə tərah!’ ");
INSERT INTO tnp_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mətəu neinatɨgiən rəha Uhgɨn mɨne nəlpəkauiən rəhan in təhruahru məmə itɨmlau Jon iatuol nati in tolkeikei. Kəni nəmiəgəhiən rəha nətəmimi u kəutəhatətə lanəha tətəgətun məmə inu nɨpəhriəniən.” ");
INSERT INTO tnp_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Kəni Farəsi kəti, nərgɨn u Saimon, in təmauɨn e Iesu məmə otuvən mauən e rəhan nimə. Kəni Iesu təmuvən lahuənu, kəni muvən imə e nimə rəha Farəsi u mətəharəg məmə otauən. ");
INSERT INTO tnp_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kəni pətan kəti e taun əha in iol təfagə tərah, təmətəu məmə Iesu tətauən əpəha ima Farəsi ikɨn. Kəni in təmos səntə kəti muva iətəm nəhmtɨn tiəkɨs. Səntə u e pətəl kəmol e kəpiel iətəm nəhmtɨn tiəkɨs, kətəni kəmə alapastə. ");
INSERT INTO tnp_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Kəni in təmuva iuəkɨr o Iesu məhtul e nɨkalɨ nəhlkɨn mətasək, nəhu nəhmtɨn tahli=pən e nəhlkɨ Iesu mol nəhlkɨn təpɨrɨg. Kəni təmafəl nəhu nəhmtɨn e nəhlkɨ Iesu e nəuanun, kəni matek nəhlkɨ Iesu e nɨkapɨn mətəfən nɨsiaiən kəm in, kəni mol=pən səntə e nəhlkɨn. ");
INSERT INTO tnp_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kəni Farəsi u təmeh nati u, kəni məni aru e nɨkin məmə, “Nəmə suah u in iəni pəhriən, ko in təhrun əmə noliən rəha pətan əha iətəm tatek nəhlkɨn, məmə in iol təfagə tərah.” ");
INSERT INTO tnp_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Kəni Iesu təməni=pən kəm in məmə, “Saimon, iəkolkeikei məmə iəkəni nati kəti kəm ik.” Kəni Saimon təni məmə, “Əuəh, Iəgətun, nati nak?” ");
INSERT INTO tnp_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Kəni Iesu təni məmə, “Suah keiu, rəhalau məni təsəhmeniən, kəni iərmənɨg kəti təməfən məni nəuvein kəm lau, mə nian kəti kəmənuhalpɨn rəhan məni. Kəti təmos faif-hanrɨt tənariəs, kəni kəti tos fifti tənariəs. ");
INSERT INTO tnp_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nian ilau kɨnuəruru nalpɨniən, kəni iərmənɨg təməni məmə, ‘uəpəh əmə nalpɨniən məni u nəmuos.’ ?Kəni suah mil u in pəhruvən lan otolkeikei pɨk iərmənɨg?” ");
INSERT INTO tnp_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Kəni Saimon in təni məmə, “Nɨkik təhti məmə iətəm u in təmos məni tepət, iərmənɨg in nɨkin təmepət ohni, in otolkeikei pɨk iərmənɨg.” Kəni Iesu təməni məmə, “Nəməni pəhriən.” ");
INSERT INTO tnp_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kəni Iesu təmeirair meruh pətan u, kəni məni=pən kəm Saimon məmə, “?Saimon, nəmeh pətan u, uə kəpə? Nian iəmuva imam ikɨn, ik nəsəfaiən nəhu kəti o nəueiuiən nəhlkək, mətəu pətan u, in təməueiu nəhlkək e nəhu nəhmtɨn mafəl e nəuanun. ");
INSERT INTO tnp_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nian iəmuva, kəni Saimon, ik nəməsoliən nəmtətiən kəti məmə nəkolkeikei iəu. Mətəu pətan u, tatek əmə nəhlkək e nɨkapɨn lanko, kəni noliən rəhan tətəgətun məmə in tolkeikei iəu. ");
INSERT INTO tnp_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Saimon, ik nəməsəueiuiən rəhk-kapə e kalɨku nəuvetɨn, mətəu pətan u, in təməueiu nəhlkək e səntə iətəm nati kəti nəhmtɨn tiəkɨs. ");
INSERT INTO tnp_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kəni tol lanu iətəni kəm ik məmə, inafəl rəkɨs rəhan təfagə tərah mɨn u tepət pɨk, kəni tol lanu, noliən mɨn əha iətəm təmol, tətəgətun məmə tolkeikei pɨk iəu. Mətəu nian iətos rəkɨs təfagə tərah rəha iətəmimi nəuan nəuvetɨn əmə, kəni kəsi, rəhan nolkeikeiən in natiəkəku ohniəu.” ");
INSERT INTO tnp_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kəni Iesu təməni=pən kəm pətan u məmə, “Rəham təfagə tərah mɨn, iəu inafəl rəkɨs.” ");
INSERT INTO tnp_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Kəni nətəmimi nəuvein mɨn iətəm kəməutauən ilah min, kəutəni kəm lah mɨn məmə, “?Iətəmimi naku təni məmə tatos rəkɨs təfagə tərah rəha iətəmimi?” ");
INSERT INTO tnp_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mətəu Iesu təməni=pən kəm pətan u məmə, “Uhgɨn tɨnosmiəgəh ik mətəu-inu nəməhatətə lak. Kəni uvən, pəh nəməlinuiən rəha Uhgɨn tətatɨg ohnik.” ");
INSERT INTO tnp_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Uərisɨg e natimnati mɨn əha, Iesu in tətaliuək matuvən e taun mɨn nəuvein mɨne lahuənu mɨn nəuvein. In mətəni pətɨgəm nəghatiən rəha Uhgɨn kəni mətanus pətɨgəm nanusiən təuvɨr rəha Narmənɨgiən Rəha Uhgɨn. Kəni e nian əha, tueləf aposɨl mɨn rəhan kəməutohtəu=pən. ");
INSERT INTO tnp_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kəni nɨpətan nəuvein mɨn kəmautuərisɨg e Iesu, inu aupən ilah kəmautohmɨs, uə kəmautos narmɨn tərah mɨn e lah, mətəu Iesu in təməhgi pətɨgəm narmɨn tərah mɨn kəni mol vi rəhalah nɨmɨsiən. Nərgɨ nɨpətan mɨn u Meri u kətəni məmə Maktələ u Iesu təməhgi pətɨgəm narmɨn tərah səpɨn lan; ");
INSERT INTO tnp_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","mɨne Joana pətauəhli rəha Jusa iətəm in tepət e nətəmimi nətəm kautol uək e nimə rəha kig Herot Antipas; mɨne Susana; mɨne nɨpətan tepət mɨn. Nɨpətan mɨn u kəutəfən rəhalah məni o nosiən nəhmtɨ natimnati o nasiruiən e Iesu mɨne rəhan tueləf nətəmimi mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nətəmimi mɨn tepət kəmotsɨpən e taun mɨn tepət məhuva o Iesu. Nian kəməhuva məutəhtul tɨtəlau lan, kəni təməni nəghatiən əuhlin u kəm lah, ");
INSERT INTO tnp_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Suah kəti, rəha nərfeiən nɨkɨtɨ wit, təmuvən mətearəgrəg e nɨkɨtɨ wit əpəha e nasumiən. Kəni nəuvein tɨmərəgrəg e suaru, mətəu nətəmimi kəməhuva motaliuək lan, kəni mənɨg mɨn kəməhuva motun rəkɨs ilah. ");
INSERT INTO tnp_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kəni nɨkɨtɨn nəuvein kohmərəgrəg=pən e nɨftəni nəuan nəuvetɨn iətəm kəpiel əha ləhtəni lan. Nian koteviə, kəni motaukei mətəu-inu nəhu tɨkə ləhtəni ikɨn. ");
INSERT INTO tnp_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kəni nɨkɨtɨ wit nəuvein kəmotəmei=pən e nɨki nɨləuɨs u tol nihlɨn, kəni nian nɨkɨtɨ wit mɨn koteviə mətəu nɨləuɨs tətatu-atu ilah kəni kohmɨs. ");
INSERT INTO tnp_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mətəu nɨkɨtɨ wit nəuvein kəmotəmei=pən e nɨftəni təuvɨr kəni moteviə kəni motəuə e nəua lah tepət pɨk təhmen=pən e uan-hanrɨt.” Nian Iesu təməni rəkɨs nəghatiən u, kəni məghati, məni kəm lah məmə, “Itəmah rəfin matəlgɨtəmah tatɨg, otətəlɨg vivi, kəni motəhrun nəghatiən mɨn u.” ");
INSERT INTO tnp_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Kəni nətəmimi rəha Iesu kəmotətapuəh ohni məmə, “Əni=pa nɨpətɨ nəghatiən u kəm tɨmah.” ");
INSERT INTO tnp_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Kəni in təməni=pən kəm lah məmə, “Itəmah, Uhgɨn tɨnerəh rəkɨs e rəhatəmah suaru məmə itəmah onəkotəhrun nəghatiən rəha Narmənɨgiən Rəha Uhgɨn iətəm tətəhluaig. Mətəu nətəmimi mɨn nəuvein, ilah kautos əmə e nəghatiən əuhlin mɨn, məmə ilah okoteh, mətəu kotəruru, kəni ilah okəutətəu, mətəu ko kəsotəhruniən.” ");
INSERT INTO tnp_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Kəni Iesu in təməni məmə, “Nɨpətɨ nəghatiən u tol lanu. Nɨkɨtɨ wit tətəgətun=pən nəghatiən rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nɨkɨtɨ wit iətəm təməmei e suaru tətəgətun=pən nətəmimi mɨn u kəutətəu nəghatiən rəha Uhgɨn, mətəu Setən tatos rəkɨs nəghatiən rəha Uhgɨn e rəhalah nətəlɨgiən məmə okəsotosiən nɨpəhriəniən lan, mə Uhgɨn otəsosmiəgəhiən ilah. ");
INSERT INTO tnp_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Nɨkɨtɨ wit mɨn u kəmotəmei=pən nɨftəni u təkəku kəpiel əha ləhtəni, kəutəgətun=pən nətəmimi u kəutətəu nəghatiən rəha Uhgɨn, nɨkilah tətagiən ohni. Mətəu nokɨlah təseiuaiuiən isəu, ilah kəutəhatətə e nian əkuəkɨr əmə. Mətəu nian nəfeifeiən tuva, uə nərahiən tuva e nəmiəgəhiən rəhalah, kəni ilah kotəmei e rəhalah nəhatətəiən. ");
INSERT INTO tnp_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Kəni nɨkɨtɨ wit mɨn u kəmotəmei=pən e nɨki nɨləuɨs, kəutəgətun=pən nətəmimi u kəmotətəu nəghatiən rəha Uhgɨn, mətəu natimnati tepət tətatu-atu=pən e nəmiəgəhiən rəhalah, mətəu ilah kəutətəlɨg pɨk e natimnati rəha nəmiəgəhiən rəhalah, uə ilah kotolkeikei nautə tepət, uə ilah kotolkeikei məmə okotətəu təuvɨr e rəhalah nəmiəgəhiən. Kəni nəmiəgəhiən rəhalah təsəuəiən e nati təuvɨr kəti e nəghatiən rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Mətəu nɨkɨtɨ wit mɨn u kəmotəmei e nɨftəni təuvɨr, kəutəgətun=pən nətəmimi u kəmotətəu nəghatiən rəha Uhgɨn, kəni nɨkilah təhruahru kəni məuvɨr, kəni ilah kəmotaskəlɨm nəghatiən rəha Uhgɨn tiəkɨs e nɨkilah. Kəni ilah kotəuə e nəmiəgəhiən təuvɨr.” ");
INSERT INTO tnp_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kəni Iesu təməni=pən məmə, “?Pəh tətasiəpən e lait kəni masuəpəpɨm lan e bəkɨt, uə taharu=pən e nɨpəg pet? !Kəpə! Kəsoliən lanəha. Nian nəkotasiə e lait, kəni motaharu pəri e tepɨl məmə nətəmimi okoteruh nati lan. ");
INSERT INTO tnp_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kəni tol mɨn lanəha, nəmə suah kəti tətəhluaig e nati kəti, mətəu Uhgɨn in otol əpu in, kəni nəmə suah kəti tatos oneuən nəghatiən kəti, mətəu Uhgɨn in otəni əpu. ");
INSERT INTO tnp_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nəghatiən u nəutətəu, otətəlɨg vivi lan. Iətəmi u in tɨnəhrun rəkɨs nɨpətɨ nəghatiən rəhak, in təhrun nosiən tepət təhmɨn. Mətəu iətəmi u təsəhruniən, in otəmkarəpən e nati iətəm nɨkin tətəhti məmə tatos.” ");
INSERT INTO tnp_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kəni e nian əha, mamə rəha Iesu mɨne pian mɨn kəməhuva məmə okoteh, mətəu ko kəsəhuvəniən iuəkɨr moteh mətəu nətəmimi tepət kəutətəlɨg lan. ");
INSERT INTO tnp_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kəni nətəmimi kəmotəni=pən kəm in məmə, “Mamə rəham mɨne piam mɨn ilah əpəha ihluə kəutəhtul, ilah kotolkeikei məmə okoteruh ik.” ");
INSERT INTO tnp_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kəni Iesu təməni=pən kəm lah məmə, “Nətəmimi rəfin u nətəm kəutətəu nəghatiən rəha Uhgɨn kəni məutohtəu=pən, ilah u rəhak nətəmimi mɨn, ilah rəhak mɨn mamə mɨn mɨne piak mɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nian kəti Iesu mɨne rəhan mɨn nətəmimi kəməhuvən e bot kəti, kəni in təməni=pən kəm lah məmə, “Pəh kəhuvən e nɨkalɨ lek e nɨtəni=pən.” Kəni kəmotiuvi nivən mohiet. ");
INSERT INTO tnp_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nian bot tɨnətaiu, kəni Iesu təmuvən mətapɨli. Kəni nɨmətagi asoli kəti təmeiuaiu=pən e nəhu əha, kəni nəhu tɨnatuvən e nɨpəgnəua bot, kəni iuəkɨr əmə bot tamnɨm. ");
INSERT INTO tnp_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kəni kəmotəhgi-pəri Iesu kəni motəni, “!Ei, Iətəmi asoli! !Ei, Iətəmi asoli! Air-tə, okohmɨs rəueiu!” Kəni Iesu təmair magət məniəhu nɨmətagi mɨne peau-peau asoli mɨn. Kəni nɨmətagi təmohrahli nəhlmɨn, kəni təməməlinu. ");
INSERT INTO tnp_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kəni Iesu təməni kəm lah məmə, “Təhro? ?Rəhatəmah iə nəhatətəiən?” Mətəu ilah kɨnotəgɨn, kəni narmɨlah təmiuvɨg mɨn, kəni mɨnautəni=pən kəm lah mɨn məmə, “!Ei! ?Iətəmimi nak u? Nati əpnapɨn nɨmətagi mɨne nəhu, mətəu kətuətəlɨg e rəhan nəghatiən matuol.” ");
INSERT INTO tnp_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kəni ilah kəməhuva mohietɨgəm=pa ima nətəm Kerasa ikɨn, inəha e nɨtəni=pən e nəhu u, kəni məhuvari. ");
INSERT INTO tnp_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nian Iesu təmuvari, kəni əmeiko iətəmimi kəti əha ikɨn təmuva meh. Suah u, narmɨn tərah mɨn kəutatɨg lan, kəni in aupən in təsuvəniən e napən, kəni in təsapɨliən imə, mətəu in tətatɨg əmə əha e nɨpəg kəpiel mɨn, ikɨn katɨtənɨm nətəmimi ikɨn. ");
INSERT INTO tnp_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Aupən ikɨn, nian tepət, narmɨn tərah əha tatol in tətalməli pɨk, kəni nətəmimi kəutəlis nəhlkɨn mɨne nəhlmɨn e sen məmə otaskəlɨm tiəkɨs mauteh məmə otəsərəkɨniən natimnati. Mətəu nian rəfin təteatuv-eatuv sen mɨn əha, kəni narmɨn tərah tətəkeikei kəm in məmə otiet magɨm muvən əpəha ikɨn təpiə-məpiə ikɨn. Mətəu nian ialməli u təmeh Iesu, təmearəg əfəməh, muva morin=pən e nəhlkɨ Iesu, kəni mətagət məmə, “!Iesu, Nətɨ Uhgɨn Ilɨs Agɨn! ?Nəmə nəkəhro lak? !Əui, iətətapuəh ohnik məmə onəsoliən nalpɨniən asoli kəti kəm iəu!” Narmɨn tərah u təməni lanu mətəu-inu Iesu təməni rəkɨs məmə in otiet magɨm e suah u. ");
INSERT INTO tnp_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Kəni Iesu təmətapuəh ohni məmə, “?Nərgəm pəh?” Kəni in təməni məmə, “Nɨmənin Tepət.” Təməni lanəha mətəu-inu narmɨn tərah mɨn tepət kəməutatɨg lan. ");
INSERT INTO tnp_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kəni narmɨn tərah mɨn kəmotətapuəh əskasɨk o Iesu məmə, “Onəsahli-pəniən itɨmah e nɨpəg iətəm naunun tɨkə tapinəpu ikɨn, u imə nalpɨniən.” ");
INSERT INTO tnp_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kəni ikɨn əha e nɨkalɨ nɨtəuət, pɨkəh mɨn tepət kəutauən məutan əha ikɨn. Kəni narmɨn tərah mɨn kəməutasək=pən məutəni=pən kəm Iesu məmə, “Əui, egəhan e tɨmah iəkəhuvən e pɨkəh mɨn əha.” Kəni Iesu təmegəhan e lah kəhuvən. ");
INSERT INTO tnp_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kəni narmɨn tərah mɨn u kəmohiet e suah u məhuvən e pɨkəh mɨn, kəni pɨkəh mɨn ilah rəfin kəmotaiu məuteiuaiu e nɨpatu, kəni motiuvɨg=pən e nəhu motamnɨm. ");
INSERT INTO tnp_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nian nətəmimi nətəm kəutaugɨn pɨkəh mɨn kəmoteh nati u, kohiet motagɨm məhuvən məutəni pətɨgəm nanusiən rəha natimnati mɨn u e taun rəhalah mɨne ikɨn mɨn rəfin tɨtəlau-təlau. ");
INSERT INTO tnp_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kəni nətəmimi kəmohiet e taun məhuvən məmə okoteruh natimnati mɨn əha. Kəni kəməhuva moteruh Iesu, kəni moteh mɨn suah u narmɨn tərah mɨn kəmohiet rəkɨs lan, in tətəharəg e nəhlkɨ Iesu kəni nəpəh nalməliən, kəni mɨnəfən rəkɨs rəhan napən. Kəni nətəm e taun u kəmotəgɨn. ");
INSERT INTO tnp_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kəni nətəmimi u kəmoteh əhruahru nati u e nəhmtɨlah, ilah kəmotanus tatuvən kəm nətəmimi nəuvein mɨn məutəni pətɨgəm məmə Iesu təməhrol lanu mol vivi suah kəha, u aupən narmɨn tərah mɨn kəməutatɨg lan. ");
INSERT INTO tnp_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kəni nətəmimi rəfin u kəutatɨg iuəkɨr o Kerasa, kəmotəni=pən kəm Iesu məmə otiet əha imalah ikɨn mətəu-inu ilah kɨnəutəgɨn pɨk. Kəni əmeiko in təmuvən e bot məmə okotasuə məhuvən nəve nəhu=pən. ");
INSERT INTO tnp_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mətəu suah u narmɨn tərah mɨn kəmohiet lan, in təmətapuəh o Iesu məmə, “!Pale, pəh iəkuvnə kitah!” Mətəu Iesu təni=pən kəm in məmə, ");
INSERT INTO tnp_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ɨtəlɨg muvən imam ikɨn, muvən məni pətɨgəm natimnati mɨn u Uhgɨn təmol kəm ik.” Kəni suah u təmuvən ikɨn rəfin e taun u iman ikɨn mətəni pətɨgəm natimnati mɨn iətəm Iesu təmol kəm in. ");
INSERT INTO tnp_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nian Iesu təmɨtəlɨg=pa mɨn e nɨtəni=pa e nəhu u, nətəmimi nɨkilah təmagiən məmə koteruh mɨn Iesu, mətəu-inu ilah kəmautəhtahnin. ");
INSERT INTO tnp_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kəni iətəmi kəti təmuva meh, nərgɨn u Jaerəs, suah u in iətəmi asoli kəti rəha nimə rəha nuhapumɨniən. Təmuva meiuaiu mɨsin nəulɨn e nɨsiaiən, mətəkeikei e nətapuəhiən kəm Iesu məmə in otuvən əpəha iman ikɨn, ");
INSERT INTO tnp_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","mətəu-inu nətɨn pətəkəku tatɨmɨs pɨk rəhan nahməiən tepət, kəni təsuvəhiən rəueiu tɨmɨs. In nəuan kətiəh əmə, rəhan nu tueləf. Kəni Iesu təmaliuək matuvən o pətəkəku əha, kəni nɨmənin nətəmimi tepət kəmotəhtul təlau lan məutatətə əmə e lah mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kəni pətan kəti təmuva o Iesu iətəm tatos nɨmɨsiən rəhalah nɨpətan nian rəfin əmə mɨnos nu tueləf, kəni in təmuvən o nətəmimi tepət iətəm kautol mərsɨn, mətəu ko kəti təsol viən. ");
INSERT INTO tnp_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kəni pətan əha in təmsɨpən e nəmtah Iesu ikɨn, kəni meapən mek nɨfɨfɨ napən rəha Iesu, kəni əmeiko rəueiu agɨn mɨn, rəhan nɨmɨsiən təmol naunun. ");
INSERT INTO tnp_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Kəni Iesu təni məmə, “?Ei, pəh təmek iəu?” Mətəu nətəmimi kotəni məmə, “Kəti təsekiən ik,” kəni Pitə təni məmə, “!Iətəmi asoli, nətəmimi tepət kəutələs pɨkɨn ik.” ");
INSERT INTO tnp_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mətəu Iesu təni məmə, “Kəpə. Iəkəhrun məmə iətəmi kəti təmek iəu mətəu-inu iəmətəu nəsanəniən təmiet lak.” ");
INSERT INTO tnp_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kəni nian pətan əha tɨnəhrun məmə ko təsəhluaigiən, in təmuva mətərəmrumɨn pɨk kəni mɨsin nəulɨn mətəfən nɨsiaiən kəm Iesu. Kəni e nəhmtɨ nətəmimi rəfin, təni pətɨgəm kəm Iesu məmə təmek in o nak, kəni mətəni pətɨgəm mɨn məmə nian təmek in, kəni rəueiu agɨn mɨn, rəhan nɨmɨsiən təmol naunun. ");
INSERT INTO tnp_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kəni Iesu təməni=pən kəm in məmə, “Nətɨk pətan, e rəham nəhatətəiən lak, nɨnuva mɨnəuvɨr. Kəni atuvən, pəh nəməlinuiən rəha Uhgɨn tətatɨg ohnik.” ");
INSERT INTO tnp_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nian Iesu təmətəghati əhanəh, kəni iətəmi kəti təmsɨpən ima Jaerəs ikɨn tiet=pa, kəni məni kəm Jaerəs məmə, “Nətɨm pətəkəku tɨnɨmɨs rəkɨs. Mə iəgətun nahgin təsɨkəiən məmə tuva.” ");
INSERT INTO tnp_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mətəu nian Iesu təmətəu nəghatiən əha, in təməni=pən kəm Jaerəs məmə, “Səgɨniən. Əhatətə əmə lak, kəni pətəkəku rəham, in otəmiəgəh mɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nian Iesu təmuvən mietɨgəm=pən lahuənu ima suah kəha, kəni mit rəkɨs əmə Pitə mɨne Jon, mɨne Jemɨs, mɨne mamə mɨne tatə rəha pətəkəku u iətəm təmɨmɨs, məmə ilah əmə okəhuvən imə. ");
INSERT INTO tnp_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nətəmimi rəfin kəutasək əfəməh məutauɨn e pətəkəku əha, mətəu Iesu təni=pən kəm lah məmə, “Sotasəkiən. Pətəkəku u in təsɨmɨsiən. In tətapɨli əmə.” ");
INSERT INTO tnp_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kəni ilah kəmotaləh əuvsan lan mətəu-inu ilah kotəhrun məmə pətəkəku əha tɨnɨmɨs rəkɨs. ");
INSERT INTO tnp_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mətəu Iesu təmuvən imə, kəni meapən mos nəhlmɨ pətəkəku u kəni mauɨn lan məmə, “Pətəkəku, əhtul.” ");
INSERT INTO tnp_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kəni əmeiko pətəkəku əha təməmiəgəh mɨn məhtul. Kəni Iesu təməni=pən kəm lah məmə, “Otəfən nati kəti tun.” ");
INSERT INTO tnp_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kəni rəhan mamə mɨne tatə, narmɨlau təmiuvɨg pɨk, mətəu Iesu təni=pən kəm lau məmə, “Onəsuəni pətɨgəmiən natimnati mɨn u kəm iətəmimi kəti.” ");
INSERT INTO tnp_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Kəni Iesu təmoriarun rəhan mɨn tueləf nətəmimi, kəni məfən nəsanəniən kəm lah kəni mətegəhan=pən e rəhan nepətiən kəm lah məmə ilah kotəhrun nəhgi pətɨgəmiən narmɨn tərah mɨn, kəni mə ilah okotol vivi nɨmɨsiən mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kəni Iesu təmahli pətɨgəm ilah məmə okotəni pətɨgəm Narmənɨgiən Rəha Uhgɨn, kəni məmə okotol vivi nətəmimi iətəm kəutohmɨs. ");
INSERT INTO tnp_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kəni in təməni=pən kəm lah məmə, “Nian onəkəhuvən, məsotosiən natimnati nəuvein rəha naliuəkiən rəhatəmah, natimnati iətəm təhmen e kasɨkɨn, uə kətɨm, uə nauəniən, uə məni, kəni məsotosiən napən keiu. ");
INSERT INTO tnp_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kəni nian itəmah nəkəhuvən e lahuənu kəti məutatɨg e nimə kəti, nimə u inu onəkotatɨg əmə lan mətəuarus nian itəmah onəkohiet lan. ");
INSERT INTO tnp_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kəni ikɨn pəhruvən onəkəhuvən ikɨn, nəmə nətəmimi nɨkilah təsəgɨniən məmə nəkəhuva motatɨg itəmah milah, kəni onəkotohrapɨspɨs rəkɨs nɨməulul e nəhlkɨ təmah kəni mohiet. Inu nəmtətiən kəti tətəgətun məmə nəkotəpəh ilah, kəni nɨki Uhgɨn tərah o lah.” ");
INSERT INTO tnp_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kəni ilah kəmohiet motaliuək mautəhuvən lahuənu mɨn məutanus pətɨgəm nanusiən təuvɨr, kəni ikɨn mɨn rəfin kautəhuvən ikɨn, məutəfaki kəm nətəmimi tepət, kəni kotəmiəgəh. ");
INSERT INTO tnp_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kəni Kig Herot Antipas u in iərmənɨg e nɨtəni Kaləli, in təmətəu nanusiən rəha natimnati mɨn u iətəm Iesu tatol ilah. In təmətəlɨg lan muvən, mətəu tɨnəruru əfəməh mətəu-inu nətəmimi nəuvein kəutəni məmə Jon Bəptais tɨnəmiəgəh mɨn, ");
INSERT INTO tnp_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","kəni nətəmimi nəuvein mɨn kəutəni məmə Elaijə tɨnuva mɨn, kəni nətəmimi nəuvein kəutəni məmə in iəni kəti rəha Uhgɨn aupən ikɨn iətəm təməmiəgəh mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kəni Herot Antipas təməni məmə, “Jon u, iəu iəməuahtuv rəkɨs rəhn-kapə. ?Mətəu iətəmi pəh u iətətəu rəhan nanusiən?” Kəni in mətəsal e Iesu məmə oteruh. ");
INSERT INTO tnp_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kəni aposɨl mɨn rəha Iesu kəmohtəlɨg=pa mɨn ohni, kəni motəni=pən kəm in natimnati rəfin iətəm kəmotol. Kəni in təmit ilah mohiet rəkɨs e nətəmimi, məhuvən əpəha taun pɨsɨn kəti mɨn, nərgɨn u Petsaitə. ");
INSERT INTO tnp_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mətəu nian nətəmimi kəmotətəu nanusiən məmə Iesu tɨnuva, kəni kəməhuva mautəhuərisɨg e lah. Kəni Iesu nɨkin təmagiən əmə nian təmeruh ilah, kəni in təməgətun ilah e Narmənɨgiən Rəha Uhgɨn, kəni mətol vivi nətəmi kautohmɨs kəutəmiəgəh mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kəni ləhnaiuv iuəkɨr tapinəpu, nətəmi tueləf rəha Iesu kəməhuva ohni məutəni məmə, “Iərmənɨg. Ahli=pən nətəmimi rəfin kautəhuvən əpəha lahuənu mɨn məmə okotəsal ikɨn kəti o napɨliən kəni motəsal e nauəniən kəti kotun mətəu-inu, ikɨnu nətəmimi kohkə ikɨn, in lɨmɨnan.” ");
INSERT INTO tnp_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mətəu Iesu təməni=pən kəm lah məmə, “Kəpə, itəmah əmə. Onəkotaugɨn nətəmimi mɨn əha.” Mətəu ilah kəmotəni məmə, “Itɨmah iəutos əmə pɨret faif mɨne nəmu keiu. ?Təhro? ?Nəkolkeikei məmə iəkəhuvən motos nəhmtɨ nauəniən kəti mɨn nɨg nɨmənin nətəmimi mɨn rəfin əha?” ");
INSERT INTO tnp_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kəmotəghati lanəha mətəu nətəmimi tepət pɨk u kəməhuva ikɨn əha, nəmə kafin nəman əmə, kəni ilah rəfin faif-tausɨn. Mətəu Iesu təni=pən kəm rəhan mɨn nətəmimi məmə, “Əhuvən motəuəri ilah fifti fifti motəni məmə okotəharəg.” ");
INSERT INTO tnp_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kəni rəhan mɨn nətəmimi kəmotəuəri ilah mɨn lanəha, kəni nətəmimi rəfin kəmotəharəg. ");
INSERT INTO tnp_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Kəni Iesu təmos pɨret əha faif mɨne nəmu u keiu, məsal-pəri əpəha e neai, kəni məfaki=pən lan, kəni məmkərɨs məfən kəm rəhan mɨn nətəmimi məmə okotəfən kəm nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kəni nətəmimi rəfin kəmotauən məhuvən nərfɨlah tasisi. Kəni kotəpəh nɨpɨspɨsɨ nauəniən, kəni nətəmimi rəha Iesu kəmotaipei=pən e kətɨm asoli ilah tueləf kotəri vivi. ");
INSERT INTO tnp_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kəni nian kəti, Iesu mɨne rəhan mɨn əmə nətəmimi kautatɨg, kəni Iesu tətəfaki kəm Uhgɨn. Kəni in təmətapuəh e lah məmə, “?Nətəmimi kəutəni iəu məmə iəu pəh?” ");
INSERT INTO tnp_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Mətəu kotəni məmə, “Nəuvein kəutəni məmə ik Jon Bəptais. Kəni nəuvein kəutəni məmə ik iəni Elaijə. Kəni nəuvein kəutəni məmə ik iəni kəti rəha Uhgɨn u aupən ikɨn iətəm tɨnəmiəgəh mɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kəni Iesu təmətapuəh e lah məmə, “?Mətəu itəmah nəkotəni məmə iəu pəh?” Kəni Pitə təni məmə, “Ik Krɨsto iətəm Uhgɨn təməni məmə otahli=pa.” ");
INSERT INTO tnp_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Mətəu Iesu təməniəhu əskasɨk ilah məmə okəsotəniən nəghatiən mɨn əha kəm nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kəni in təmatɨg məni mɨn kəm rəhan mɨn nətəmimi məmə, “Nati kəti otəkeikei muva mol nɨpəhriəniən lan, məmə iəu, Nətɨ Iətəmimi, oiəkətəu nahməiən e natimnati tepət. Kəni nətəmi asoli u nəhlin rəha Isrel, mɨne pris asoli mɨn, mɨne nəgətun mɨn rəha Lou, ilah okotəməki lak, kəni motuhamu iəu, kəni iəkɨmɨs. Mətəu nian tatol kɨsɨl lan, Uhgɨn otol iəkəmiəgəh mɨn e nɨmɨsiən.” ");
INSERT INTO tnp_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kəni Iesu təməni=pən kəm rəhan mɨn nətəmimi məmə, “Iətəmi u tolkeikei məmə otuva muərisɨg lak, in otəkeikei məpəh natimnati mɨn nɨkin tolkeikei, kəni mələs rəhan nɨgi kəməluau muərisɨg lak, ");
INSERT INTO tnp_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","mətəu-inu nəmə iətəmimi tolkeikei məmə otosmiəgəh rəhan nəmiəgəhiən e nɨftəni u, in otəmkarəpən e rəhan nəmiəgəhiən itulɨn. Mətəu iətəmimi u otɨmɨs o nərgək, kəni in otos nəmiəgəhiən itulɨn. ");
INSERT INTO tnp_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","?Nəmə suah kəti otos rəfin natimnati rəha nɨftəni u, kəni mɨmɨs ohni, in otos nati təuvɨr nak? ");
INSERT INTO tnp_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Okəmə nəkaulɨs o nəniən nərgək mɨne rəhak nəghatiən, kəni Nətɨ Iətəmimi in mɨn otaulɨs mɨn ohnik e nian in otuva e nepətiən əhagəhag mɨne nəsanəniən rəhan, mɨne e nepətiən əhagəhag mɨne nəsanəniən rəha Tatə rəhan mɨne nagelo mɨn asim. ");
INSERT INTO tnp_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mətəu iətəni nɨpəhriəniən kəm təmah məmə, itəmah nəuvein u nəutəhtul u ikɨnu, onəkoteruh Narmənɨgiən Rəha Uhgɨn uərisɨg nəpanohmɨs.” ");
INSERT INTO tnp_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nian Iesu təməghati rəkɨs, iuəkɨr o nəfakiən kətiəh, kəni Iesu təmit Pitə, mɨne Jon, mɨne Jemɨs kəməhuvən əpəha ilɨs e nɨtəuət məmə in otəfaki. ");
INSERT INTO tnp_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kəni nian in təmətəfaki, kəni rəhn-kapə təməuhlin muva mol pɨsɨn, kəni napən rəhan təmuva məruən matoraip-oraip. ");
INSERT INTO tnp_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kəni əmeiko Mosɨs mɨne Elaijə kəmiaiet=pa muəhtul məhləghati ilahal Iesu, ");
INSERT INTO tnp_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Kəni nəhagəhagiən asoli kəti təmasiə mɨtəlau e lau, ilahal kəməhləghati e nɨmɨsiən rəha Iesu əpəha Jerusɨləm iətəm otol nəghatiən rəha iəni mɨn rəha Uhgɨn mə tuva mol nɨpəhriəniən lan. ");
INSERT INTO tnp_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mətəu Pitə mɨne suah mil, napɨliən tɨnos rəkɨs ilahal, kəni kəmhlapɨli nəuvetɨn. Mətəu nian kəmhlair, mɨhlafu nəhagəhagiən asoli tɨtəlau e Iesu, kəni kəmhleruh Mosɨs mɨne Elaijə kətuəhtul ilahal Iesu. ");
INSERT INTO tnp_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kəni nian suah mil kɨnətuagɨm rəkɨs e Iesu, kəni Pitə təməni=pən kəm Iesu məmə, “Iərmənɨg, təuvɨr məmə itɨmahal iəkluva məhlatɨg u ikɨnu. Pəh iəklol nɨmauvluvl kɨsɨl, rəham kəti, rəha Mosɨs kəti, kəni rəha Elaijə kəti.” Mətəu in təmətəghati əpnapɨn əmə, məsəhruniən məmə nəghatiən nak u in tətəni. ");
INSERT INTO tnp_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mətəu nian təmətəghati əhanəh, kəni nəpuə kəti təmuva məuveg ilahal, nian kəmhleruh nəpuə təməuveg ilahal, kəni kəmhləgɨn pɨk. ");
INSERT INTO tnp_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kəni ilahal kəhlətəu nəuia suah kəti təmsɨpən e nəpuə, mətəni məmə, “Inu nətɨk iətəm iəu iəmɨtəpɨn. !Əhlətəlɨg vivi lan!” ");
INSERT INTO tnp_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nian kɨnotətəu rəkɨs nəuia Uhgɨn təməghati, kəni Pitə mɨne Jon mɨne Jemɨs kəmleruh pɨsɨn əmə Iesu. Kəni e nian mɨn əha, kəsləniən natimnati mɨn əha kəm suah kəti mɨn, kəməsləniən natimnati mɨn u iətəm kəmhleruh. ");
INSERT INTO tnp_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kəni kəməni lauɨg lan, nian Iesu mɨne rəhan iətəmi milahal kəmotsɨpəri ilɨs e nɨtəuət moteiuaiu=pa, kəni moteh nətəmimi tepət kəməhuva ohni. ");
INSERT INTO tnp_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kəni nətəmimi mɨn əha kəti təmauɨn əfəməh e Iesu məmə, “Iəkolkeikei məmə nəkuva masiru e rəhak suakəku iərman, mətəu-inu in nəuan kətiəh əmə. ");
INSERT INTO tnp_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nian tepət, narmɨn tərah kəti tətuva lan, kəni mol in tətagət pɨk, kəni mol nɨpətɨn tətərəmrumɨn pɨk, nəhun nəuan ruən tatiet, təhmen e nəuaui nɨtəhi. Narmɨn tərah əha tatorin pɨk in, kəni mətaskəlɨm in, kəni məsəpəhiən nian kəti. ");
INSERT INTO tnp_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kəni iəu iəmətapuəh o rəham mɨn nətəmimi məmə okotəhgi pətɨgəm narmɨn tərah u, mətəu ilah kotəruru nəhgi pətɨgəmiən.” ");
INSERT INTO tnp_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Kəni Iesu təməni=pən kəm lah məmə, “Itəmah u nətəmi rəueiu mɨne, rəhatəmah nəhatətəiən tɨkə. Kəni rəhatəmah nətəlɨgiən təsəhruahruiən. Kərmə oiəkatɨg kitah min itəmah mətəuarus=pən nian nak nəmanotəhatətə lak. Kəni kərmə onəhgɨn iəpanəmeig e təmah. It nətɨm muva u ikɨnu.” ");
INSERT INTO tnp_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nian suakəku u təmətuva əhanəh o Iesu, kəni narmɨn tərah tətgəpis təmei morin=pən e nɨftəni, mol nɨpətɨn tərəmrumɨn pɨk. Mətəu Iesu təmagət əskasɨk e narmɨn tərah u, kəni məhgi pətɨgəm narmɨn tərah tiet, kəni mol vi suakəku. Kəni məfən suakəku u kəm rəhan tatə. ");
INSERT INTO tnp_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kəni ilah rəfin, narmɨlah təmiuvɨg o nəsanəniən asoli rəha Uhgɨn. Mətəu nian nətəmimi narmɨlah təmiuvɨg o natimnati mɨn rəfin u Iesu təmol ilah, kəni in təməni=pən kəm rəhan mɨn nətəmimi məmə, ");
INSERT INTO tnp_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Otos nəghatiən u teiuaiu mamnɨm e nɨkitəmah kəni məsotaluiən lan. Iəu Nətɨ Iətəmimi, suah kəti otegəhan=pən lak e nəhlmɨ tɨkɨmɨr mɨn rəhak.” ");
INSERT INTO tnp_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mətəu rəhan mɨn nətəmimi kəsotəhruniən nɨpətɨ nəghatiən u mətəu-inu Uhgɨn təməhluaig e nɨpətɨ nəghatiən u məmə ilah okəsotəhruniən, kəni ilah kɨnotəgɨn o nətapuəhiən o nɨpətɨ nəghatiən u o Iesu. ");
INSERT INTO tnp_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kəni nətəmimi rəha Iesu kɨnautol nɨkilah mɨn məmə pəh in otepət mapirəkɨs ilah rəfin. ");
INSERT INTO tnp_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mətəu Iesu təməhrun rəkɨs nati nɨkilah tətəhti, kəni in təmos suakəku kəti kəni mit muva kəni təhtul e nɨkalɨ lah, ");
INSERT INTO tnp_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","kəni məni=pən kəm lah məmə, “Nəmə iətəmi kəti, nɨkin tagiən məmə otos suakəku kəti meruh vivi, kəni in tatol lanəha e nərgək, kəni in təhmen=pən məmə in tatos iəu, mateh vivi iəu. Kəni iətəmi tatos iəu e nɨkin agiən, in tatos Uhgɨn u iətəm təmahli=pa iəu. Nəniən pəhriən u mətəu-inu iətəmi tatosiahu in ləhtəni agɨn, in otuva iətəmi asoli.” ");
INSERT INTO tnp_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Kəni Jon təməni məmə, “Iərmənɨg. Itɨmah iəmoteruh suah kəti tətəhgi pətɨgəm narmɨn tərah mɨn e nərgəm, kəni iəmotəniəhu məmə otəsoliən lanəha mətəu səniəmə in rəhatah kəti iətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Mətəu Iesu təməni=pən kəm in məmə, “Səniəhuiən mətəu-inu, nəmə suah kəti təsoliən tɨkɨmɨr itəmah min, kəni in tolkeikei itəmah.” ");
INSERT INTO tnp_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kəni tɨnuva iuəkɨr o nian Uhgɨn otos Iesu lan muvən əpəha e negəu e neai, kəni Iesu tɨnolkeikei məmə otəkeikei muvən Jerusɨləm. ");
INSERT INTO tnp_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kəni in təmahli=pən nətəmimi nəuvein mə kotos rəhan nəghatiən motaupən məhuvən əpəha lahuənu kəti e nɨtəni Səmeriə məmə okotol əpenə-penə ohni. ");
INSERT INTO tnp_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mətəu nətəmi ikɨn əha, kəsotolkeikeiən məmə in otuvən matɨg əha imalah ikɨn, mətəu ilah kotəhrun vivi məmə in tatuvən Jerusɨləm. ");
INSERT INTO tnp_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kəni nian rəhan iətəmimi mil, Jemɨs mɨne Jon, ilau kəmueruh nati mɨn u, kəni kəmuəni məmə, “?Iərmənɨg, nəkolkeikei məmə iəkuauɨn e nɨgəm tɨsɨpən əpəha ilɨs e negəu e neai meiuaiu muva mus ilah?” ");
INSERT INTO tnp_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mətəu Iesu təmeirair mahi ilau. ");
INSERT INTO tnp_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kəni ko məhuvən mɨn lahuənu pɨsɨn kəti mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kəni e nian Iesu mɨne rəhan mɨn nətəmimi kəməutaliuək mautəhuvən e suaru, kəni suah kəti təməni=pən kəm in məmə, “Onəkuvən=pən iə ikɨn, iəkɨtəu=pən ik.” ");
INSERT INTO tnp_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Kəni Iesu təməni=pən kəm in məmə, “Kuri rarpɨn mɨn, rəhalah nɨpəg tatɨg məmə okotapɨli ikɨn. Kəni mənɨg mɨn, nimaalah tatɨg məmə okotapɨli ikɨn. Mətəu iəu Nətɨ Iətəmimi, nimə rəhak tɨkə o napɨliən.” ");
INSERT INTO tnp_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kəni Iesu təməni=pən kəm suah kəti mɨn məmə, “Va, kilau min ik, nəkuva ik rəhak iətəmimi.” Mətəu suah u təni=pən məmə, “Iərmənɨg, əui. Oiəkɨtəu=pən ik mətəu pəh iəkuvən pɨpɨm mɨtənɨm rəhak tatə.” ");
INSERT INTO tnp_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Mətəu Iesu təməni=pən kəm in məmə, “Kəpə, əpəh=pən. Pəh nətəmi kɨnohmɨs rəkɨs e nɨkilah, kohtənɨm aru ilah mɨn. Mətəu ik, uvən məni pətɨgəm Narmənɨgiən Rəha Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kəni kəti mɨn təni məmə, “Iərmənɨg, iəkətəu=pɨnə ik muva iətəmimi rəham, mətəu əui, pəh pɨpɨm iəkɨtəlɨg=pən imak ikɨn mauiəhruin rəhak mɨn nətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Mətəu Iesu təməni=pən kəm in məmə, “Nəmə suah kəti tɨnətuəuin matol uək rəha Uhgɨn, mətəu rəhan nətəlɨgiən tatuvən o natimnati pɨsɨn pɨsɨn mɨn nəuvein, kəni suah u təsəhmen-pəniən məmə Uhgɨn otarmənɨg lan.” ");
INSERT INTO tnp_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Uərisɨg e natimnati mɨn əha, Iərmənɨg təmɨtəpɨn rəkɨs səpɨnte-tu nətəmimi nəuvein mɨn rəhan, kəni mahli=pən ilah keiu-keiu kotaupən lan məhuvən e taun mɨn, mɨne ikɨn mɨn nəuvein mɨn iətəm Iesu təpanuərisɨg muvən ikɨn. ");
INSERT INTO tnp_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kəni təməni=pən kəm lah məmə, “!Oteruh-to! Nauəniən tepət əpəha e nasumiən tɨnɨməhtə, mətəu noluək mɨn təkəku əmə kəutəulək lan. Otətapuəh o iətəmi asoli rəha nasumiən məmə otahli=pa noluək mɨn tepət məmə okəhuvən motəulək e nasumiən rəhan. ");
INSERT INTO tnp_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Əhuvən, mətəu onəkotəkeikei motəhrun məmə iəu iətahli=pən itəmah nautəhuvən təhmen e sipsip əlkələh mɨn məutaliuək mautəhuvən e nəlugɨn kuri rarpɨn mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kəni onəsotosiən kətɨm əkəku rəha məni, mɨne kətɨm, mɨne put, kəni məsotəmeigiən e suaru məutəghati kəm nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Nimə nak o nəkəhuvən ikɨn, nəkotaupən motəni pətɨgəm məmə, ‘!Pəh nəməlinuiən otətatɨg ikɨn!’ ");
INSERT INTO tnp_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nəmə iətəmi rəha nəməlinuiən əha ikɨn, kəni rəhatəmah nəfakiən otuva mol nɨpəhriəniən lan, kəni nəməlinuiən otətatɨg ohni. Mətəu nəmə iətəmimi kəti tol lanəha tɨkə, kəni nəua nəfakiən rəhatəmah otɨtəlɨg=pa mɨn o təmah. ");
INSERT INTO tnp_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kəni onəkotatɨg əmə e nimə kətiəh, sotapɨliən e nimə pɨsɨn pɨsɨn mɨn. Kəni nauəniən nak okotəfɨnə kəm təmah, nəkotun. Kəni nəmnɨmiən nak okotəfɨnə, nəkotəmnɨm. Mətəu-inu nəmə suah kəti tatol uək, kəni təhruahru məmə in otos nətəouiən lan. ");
INSERT INTO tnp_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Nian itəmah nəkəhuvən e taun kəti, nəmə nɨkilah tagiən o təmah, kəni nəkotun nauəniən nak kotəfɨnə kəm təmah, ");
INSERT INTO tnp_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","kəni itəmah onəkotəkeikei motol vi nətəmi kəutohmɨs məutatɨg ikɨn, kəni motəni=pən kəm lah məmə, ‘Narmənɨgiən Rəha Uhgɨn tətuva iuəkɨr o təmah.’ ");
INSERT INTO tnp_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mətəu nəmə nəkəhuvən e taun kəti, kəni nətəmimi nɨkilah təsagiəniən o təmah, kəni əhuvən məutaliuək e suaru asoli mɨn, kəni motəni məmə, ");
INSERT INTO tnp_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nɨməulul rəha nɨftəni e nəhlkɨtɨmah, iəkotohrapɨspɨs rəkɨs, inu in nəmtətiən tətəgətun məmə nəmotol təsəhmeniən, kəni Uhgɨn təpəh itəmah. Mətəu onəkotəkeikei motəhrun məmə Narmənɨgiən Rəha Uhgɨn tɨnatuva iuəkɨr rəkɨs.’ ");
INSERT INTO tnp_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kəni iətəni pəhriən kəm təmah məmə, Uhgɨn otəfən nalpɨniən asoli kəm lah tapirəkɨs nalpɨniən rəha taun əha Sotəm aupən. ");
INSERT INTO tnp_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“!Itəmah nətəm Korasin, kəsi, nahməiən asoli otuva o təmah! !Itəmah nətəm Petsaitə, kəsi, nahməiən asoli otuva o təmah! Mətəu-inu iəmol pau nati apɨspɨs tepət e taun mil rəhatəmah mətəu itəmah nəsotəuhliniən nətəlɨgiən rəhatəmah! Kəni nəmə iəmol natimnati mɨn əha əpəha Taea mɨne Saedon aupən, ko nətəmimi əha ikɨn əha kəmotəuhlin rəhalah nətəlɨgiən e noliən tərah mɨn, kəni ilah məhuvən e napən əuas mɨn məhuvən məutəharəg e nəhmtahu e nɨgəm məutəgətun məmə kautətəu tərah agɨn o noliən tərah mɨn rəhalah. ");
INSERT INTO tnp_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mətəu e nian əha iətəm Uhgɨn otol nalpɨniən kəm nətəmimi, nalpɨniən rəhatəmah in otəskasɨk, mapirəkɨs nalpɨniən rəha nətəm Taea mɨne Saedon u aupən. ");
INSERT INTO tnp_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","?Kəni itəmah nətəm Kapeniəm, nɨkitəmah təhti məmə Uhgɨn otəfəri=pən itəmah əha ima nɨsiaiən əpəha e negəu e neai? !Kəpə! Mətəu Uhgɨn otəhlman e təmah nəkoteiuaiu ləhtəni agɨn, ima naulɨsiən.” ");
INSERT INTO tnp_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kəni Iesu təməni=pən kəm rəhan mɨn nətəmimi məmə, “Nətəmimi u kəutətəlɨg e təmah, kəutətəlɨg lak. Kəni nətəmimi mɨn u kəutəuhlin=pən nəmtahlah e təmah, kautəuhlin=pa nəmtahlah kəm iəu, kəni məutəuhlin=pən nəhmtɨlah kəm suah u iətəm təmahli=pa iəu.” ");
INSERT INTO tnp_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kəni nətəmimi mɨn rəha Iesu ilah səpɨnte-tu kəmohtəlɨg=pa mɨn, kəni nɨkilah təmagiən məutəni kəm Iesu məmə, “!Iərmənɨg, nati əpnapɨn narmɨn tərah mɨn, mətəu nian itɨmah iəkotəghati e nərgəm, kəni ilah kautol nəuiatɨmah!” ");
INSERT INTO tnp_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Kəni Iesu təməni=pən kəm lah məmə, “Iəu iəmeh Setən təmsɨpəri ilɨs e neai meiuaiu təhmen=pən e noraipiən. ");
INSERT INTO tnp_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Otətəlɨg-to. Iəu inəfɨnə rəkɨs nəsanəniən kəm təmah, u itəmah nəkotəhrun nevɨg-ərainiən sɨneik mɨn mɨne skopion mɨn. Kəni nəsanəniən u iətəfɨnə kəm təmah, in tapirəkɨs nəsanəniən rəha tɨkɨmɨr rəhatah, Setən. Kəni ko nati kəti təsərəkɨniən itəmah. ");
INSERT INTO tnp_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Inu nɨpəhriəniən. Mətəu onəsotagiəniən məmə narmɨn tərah mɨn kautol nəuiatəmah, mətəu onəkotagiən əmə mətəu-inu Uhgɨn tɨnətei rəkɨs nərgɨtəmah əpəha e negəu e neai.” ");
INSERT INTO tnp_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kəni e nian əha, Narmɨn Rəha Uhgɨn təmol nɨki Iesu tətagiən pɨk, kəni in təməfaki məni məmə, “Tatə Uhgɨn, ik Iərmənɨg rəha natimnati rəfin ilɨs e neai mɨne ləhtəni e nəhue nɨftəni. Iətəni-vivi ik mətəu-inu nəməhluaig e nɨpətɨ natimnati mɨn u e nəhmtɨ nətəmimi nətəm koteinatɨg motəhrun vivi nati. Kəni nəmol əpu kəm nətəmimi nətəm kotəhmen=pən əmə e kəlkələh mɨn məmə okotəhrun vivi. Əuəh, Tatə, inu nati kəti iətəm ik nəkolkeikei.” ");
INSERT INTO tnp_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Kəni Iesu təkeikei mətəghati kəm lah məmə, “Rəhak Tatə təmegəhan=pa rəkɨs natimnati rəfin e nəhlmək. Kəni iətəmi kəti tɨkə iətəm təhrun vivi iəu u Nətɨ Uhgɨn, məmə iəu pəh əhruahru. Mətəu Tatə Uhgɨn əmə təhrun. Kəni iətəmi kəti tɨkə iətəm təhrun vivi Uhgɨn, mətəu iəu pɨsɨn əmə u Nətɨ Uhgɨn, iəkəhrun, mɨne nətəmimi nətəm iəu iəmɨtəpɨn məmə iəkol pətɨgəm Tatə Uhgɨn kəm lah.” ");
INSERT INTO tnp_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kəni Iesu təmeirair məghati əmə kəm rəhan mɨn nətəmimi məmə, “!Onəkotatɨg e nəuvɨriən pəhriən mətəu-inu itəmah nauteh e nəhmtɨtəmah natimnati mɨn u! ");
INSERT INTO tnp_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Iətəni kəm təmah məmə, iəni mɨn tepət aupən, mɨne kig mɨn tepət, kəmotolkeikei pɨk məmə okoteh natimnati mɨn u itəmah nauteruh, mətəu kəməsoteruhiən. Kəni ilah kəmotolkeikei məmə okotətəu natimnati mɨn u itəmah nautətəu, mətəu kəməsotətəuiən.” ");
INSERT INTO tnp_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kəni e nian əha, ieinatɨg kəti rəha Lou təməhtul meiuə əmə e nətapuəhiən kəti kəm Iesu məmə oteh-to məmə Iesu in teinatɨg pəhriən uə kəpə. In təməni məmə, “?Iəgətun, oiəkəhro lanu mos nəmiəgəhiən itulɨn?” ");
INSERT INTO tnp_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Kəni Iesu təməni=pən kəm in məmə, “?Lou rəha Mosɨs tətəni məmə nak? ?Nian ik nətafin, nɨpətɨn tətəni nak kəm ik?” ");
INSERT INTO tnp_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Kəni suah u təməni=pən məmə, “Onəkəkeikei molkeikei Iərmənɨg rəham Uhgɨn e nɨkim rəfin, mɨne nəmiəgəhiən rəfin rəham, mɨne nəsanəniən rəfin rəham, mɨne nətəlɨgiən rəfin rəham, kəni molkeikei mɨn ik mɨn nəuvein məmə natolkeikei aru ik mɨne.” ");
INSERT INTO tnp_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Kəni Iesu təməni=pən kəm in məmə, “In əhruahru ko. Okəmə natol lanəha, kəni ik onəkos nəmiəgəhiən itulɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mətəu suah kəha, in tolkeikei əmə məmə otəgətun rəhan noliən məmə in iətəmi əhruahru, kəni in təmətapuəh o Iesu məmə, “?Mətəu nɨpəh mɨn ilah iəu mɨn nəuvein?” ");
INSERT INTO tnp_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Kəni Iesu təməni=pən kəm in məmə, “Suah kəti təmsɨpən Jerusɨləm kəni maliuək meiuaiu matuvən əpəha Jeriko. Kəni e suaru, nakləh mɨn nəuvein kəmotaskəlɨm motəmki rəkɨs rəhan napən, kəni motoh motələhu tɨmɨseiah mətəməhli e suaru, kəni motagɨm motəpəh. ");
INSERT INTO tnp_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Kəni əmeiko təuvɨr agɨn, pris kəti tatɨtəu mɨn suaru əha mətuva, mətəu nian in təmeruh suah kəha, in təmaliuək mos nɨkalɨ suaru matuvən. ");
INSERT INTO tnp_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kəni Lifait kəti tɨtəu mɨn suaru kətiəh muva, mətəu nian in təmeruh suah kəha in tətəməhli, təmol əmə nati kətiəh mɨn maliuək mos nɨkalɨ suaru. ");
INSERT INTO tnp_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Mətəu iətəm Səmeriə kəti, iətəm kautol tɨkɨmɨr ilah nətəm Isrel, in mɨn tatɨtəu suaru əha mətuva, kəni meruh suah kəha tətəməhli. Nian təmeruh, nɨkin təmahmə ohni, ");
INSERT INTO tnp_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","kəni in təmaliuək muvən ohni, mafəl rəhan nɨməgɨm e oiel mɨne wain, kəni məuveg vivi ilah. Kəni mɨləfəri suah u maharu-pəri e rəhan togki, kəni mələs mian əpəha e hotel kəni mateh vivi. ");
INSERT INTO tnp_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kəni kəməni lauɨg lan, in təmos məni muvən məfən kəm iətəmi rəha hotel, kəni məni=pən kəm in məmə, ‘Onateh vivi suah u, kəni nəmə nəkəraki e rəham kəti məni lan, kəni nian iəu iəkɨtəlɨg=pa mɨn, kəni nəkəni=pa, kəni iəu iəpanalpɨn.’” ");
INSERT INTO tnp_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Kəni nian Iesu təmol naunun e nəghatiən u, kəni mətapuəh o ieinatɨg e Lou məmə, “?E rəham nətəlɨgiən, suah milahal əha, nəkəhrun məmə ilahal pəh təmol təuvɨr kəm suah kəha kəmoh, təhmen məmə in in kəti?” ");
INSERT INTO tnp_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Kəni ieinatɨg e Lou təməni=pən məmə, “Iətəmimi iətəmi in təmolkeikei pɨk suah kəha.” Kəni Iesu təməni=pən kəm in məmə, “Intəh. Ik uvən mol mɨn təhmen=pən əmə məmə inu suah kəha təmol.” ");
INSERT INTO tnp_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nian Iesu mɨne rəhan mɨn nətəmimi kəməutaliuək e suaru, kəni kəmohiet=pən lahuənu kəti. Kəni pətan kəti, nərgɨn u Matə, in təmos Iesu e nɨkin agiən muvən əpəha e rəhan nimə. ");
INSERT INTO tnp_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Pətan əha, pian kəti əha ikɨn, nərgɨn u Meri. Kəni Meri təmuva məharəg iuəkɨr e nəhlkɨ Iərmənɨg mətətəlɨg e nəgətuniən mɨn rəhan. ");
INSERT INTO tnp_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mətəu Matə, rəhan nətəlɨgiən tatuvən pɨk o noliən nauəniən, kəni uək tɨnatoh in. Kəni təmuvən o Iesu məni=pən kəm in məmə, “?Iərmənɨg, təhro? ?Nɨkim təhti məmə təhruahru əmə, uə kəpə, məmə pətan u piak təsasiruiən lak mɨne o noliən uək u, kəni iəu pɨsɨn əmə iatol? Ahli=pa məmə otuva masiru lak.” ");
INSERT INTO tnp_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mətəu Iərmənɨg təməni=pən kəm in məmə, “Ei, Matə. Sətəlɨg pɨkiən e natimnati mɨn tepət lanko. ");
INSERT INTO tnp_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mətəu nati kətiəh əmə in nati agɨn, kəni Meri in tɨnɨtəpɨn rəkɨs nati u iətəm in təuvɨr tapirəkɨs, kəni ko iəu iəsos rəkɨsiən nati əha ohni.” ");
INSERT INTO tnp_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nian kəti, Iesu təmətəfaki kəm Uhgɨn ikɨn kəti. Nian təmol naunun nəfakiən rəhan kəm Uhgɨn, kəni rəhan kəti iətəmimi təmətapuəh ohni məmə, “Iərmənɨg, əgətun-to itəmah e suaru rəha nəfakiən kəm Uhgɨn, təhmen=pən e Jon Bəptais in təməgətun rəhan mɨn nətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Kəni Iesu təməni=pən kəm lah məmə, “Nian nəmə nəkotəfaki kəm Uhgɨn, nəkotəni məmə, ‘Tatə Uhgɨn, nərgəm ilɨs agɨn, pəh nətəmimi okotɨsiai. Pəh rəham narmənɨgiən tuva mətatɨg. ");
INSERT INTO tnp_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nian rəfin, onəkəfa nauəniən nɨgtəmah təhmen o nian rəueiu. ");
INSERT INTO tnp_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kəni mafəl rəkɨs rəhatɨmah noliən tərah mɨn mətəu-inu itɨmah mɨn iəsotaplɨniən motəpəh rəkɨs naskəlɨm iəkɨsiən e nɨkitɨmah noliən tərah mɨn rəha nətəmimi iətəm kautol e tɨmah. Kəni məsegəhan-pəniən e tɨmah iəkəhuvən ima nəfeifeiən, məta iəkotəmkarəpən motol təfagə tərah.’” ");
INSERT INTO tnp_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Kəni təməni=pən kəm lah məmə, “?Nəmə suah kəti tuva imam ikɨn lapɨn, mətəu nauəniən tɨkə, kəni onəkəhro? Onəkuvən e nimə rəha ik kəti, kəni məni=pən məmə, ‘Pale, suah kəti əha təmsɨpən isəu muva imak ikɨn rəueiu lapɨn, mətəu nauəniən təmɨkə mə iəkəfən kəm in. Əfa nauəniən kəti, iəkos muvən məfən kəm in.’ ");
INSERT INTO tnp_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kəni nəmə, in otəni=pɨnə kəm ik məmə, ‘!Aaah! Atuvən, səhgi-pəriən itɨmah, inotapɨli rəkɨs itɨmah kəlkələh mɨn rəhak. Ko iəsəhtul mɨniən məfɨnə nauəniən kəm ik.’ ");
INSERT INTO tnp_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Iəkəni kəm təmah məmə, nati əpnapɨn ik in kəti, mətəu suah u təsolkeikeiən məmə in otəfɨnə nauəniən kəm ik. Mətəu iətəni pəhriən, nian nətəkeikei mətətapuəh ohni, kəni in otəhtul məfɨnə natimnati mɨn rəfin iətəm ik nəkolkeikei. ");
INSERT INTO tnp_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Kəni tol lanu iəkəni kəm təmah məmə, otətapuəh=pən kəm Uhgɨn o natimnati, kəni in otəfɨnə kəm təmah. Kəni otəsal lan, kəni onəkoteruh. Kəni otəhti-əhti doə, kəni doə oterəh o təmah. ");
INSERT INTO tnp_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Iəkəni lanu mətəu-inu nətəmimi rəfin nətəm kəutətapuəh, ilah okotos. Kəni nətəmimi mɨn u nətəm kəutəsal, ilah okoteruh. Kəni nətəmimi mɨn u kəutəhti-əhti doə, kəni doə oterəh o lah. ");
INSERT INTO tnp_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Itəmah tatə mɨn. ?Itəmah kəti, nian nətɨn tətapuəh o nəmu, kəni in otəfən sɨneik? !Kəpə! ");
INSERT INTO tnp_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","?Uə nian in tətapuəh o nonalɨ mənɨg, kəni in otəfən skopion? !Kəpə! ");
INSERT INTO tnp_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nati əpnapɨn itəmah nətəmimi nəkotərah, mətəu nəutəfən natimnati təuvɨr mɨn kəm nenətɨtəmah mɨn. Mətəu Tatə Uhgɨn e negəu e neai, noliən rəhan in təuvɨr pɨk mapirəkɨs agɨn noliən rəhatəmah, kəni nɨpəhriəniən, in otəfən Narmɨn Rəhan kəm nətəmimi mɨn u ilah kəutətapuəh ohni.” ");
INSERT INTO tnp_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Kəni e nian kəti, suah kəti əha ikɨn iətəm narmɨn tərah tətatɨg lan, kəni in təruru nəghatiən. Kəni Iesu təməhgi pətɨgəm narmɨn tərah əha, kəni suah kəha təmətuəuin məghati, kəni nətəmimi narmɨlah təmiuvɨg pɨk ohni. ");
INSERT INTO tnp_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mətəu nətəmimi mɨn əha nəuvein kəutəni məmə, “Pielsepul u in iətəmi asoli rəha narmɨn tərah mɨn, in əmə əha təməfən nəsanəniən kəm suah u məmə in otəhgi pətɨgəm narmɨn tərah mɨn e nətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Kəni nətəpɨsɨn mɨn nəuvein kəmotətapuəh o Iesu məmə in otol-to nəmtətiən asoli kəti e nəsanəniən iətəm tatsɨpən e negəu e neai mətəu-inu, ilah kotolkeikei məmə okotəhrun-to məmə Iesu in iətəmi pəh. ");
INSERT INTO tnp_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mətəu Iesu tɨnəhrun rəkɨs nətəlɨgiən rəhalah, kəni təni məmə, “Nəmə nətəmimi e kəntri kəti kautəhapu ilah mɨn, kəni okotərəkɨn rəhalah kəntri, kəni narmənɨgiən otearɨs mɨkə. Kəni təhmen=pən əmə, e lahuənu kəti, nəmə nətəmimi lan kautəhapu ilah mɨn, kəni okotərəkɨn agɨn lahuənu u. ");
INSERT INTO tnp_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","?Kəni nəmə nətəmimi rəha Setən kautəhapu ilah mɨn, kəni otəhro lanu e rəhan narmənɨgiən otatɨg? Iətəni lanu mətəu-inu nəutəni lanu məmə iətəhgi pətɨgəm narmɨn tərah mɨn e nəsanəniən rəha Pielsepul. ");
INSERT INTO tnp_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","?Kəni nəmə iəu, iətəhgi pətɨgəm narmɨn tərah mɨn e nəsanəniən rəha Pielsepul, kəni itəmah nəutəni məmə rəhatəmah mɨn nətəmimi kəutəhgi pətɨgəm narmɨn tərah mɨn e nəsanəniən rəha Pielsepul. Təmə tol lanəha, ilah okotakil rəhatəmah mɨn nəghatiən məmə in neiuəiən. ");
INSERT INTO tnp_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mətəu nəmə iəu iətəhgi pətɨgəm narmɨn tərah mɨn e nətəmimi e nəsanəniən rəha Uhgɨn, kəni tətəgətun məmə Narmənɨgiən Rəha Uhgɨn tɨnuvnə rəkɨs o təmah. ");
INSERT INTO tnp_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Nian iətəmi rəhan nəsanəniən tepət tətəmki natimnati rəha nəluagɨniən, in otətəhtul maru mətəsal vi o rəhan nimə, in ko rəhan natimnati kəutəməhli vi əmə. ");
INSERT INTO tnp_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mətəu nian iətəpɨsɨn kəti mɨn iətəm rəhan nəsanəniən tapirəkɨs in, in otuva muəluagɨn mətian-mətian tehpahu in, kəni mos rəkɨs rəfin rəhan natimnati rəha nəluagɨniən iətəm təmələhu=pən rəhan nətəlɨgiən lan, kəni in otəuəri natimnati rəfin rəha suah kəha kəm rəhan mɨn nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Iətəmi u in təsuərisɨgiən lak, in rəhak tɨkɨmɨr. Kəni iətəmi u in təsoriaruniən sipsip mɨn, in tatol ilah kəutagɨm atiti.” ");
INSERT INTO tnp_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Kəni təməni əskasɨk məmə, “Nian narmɨn tərah tatiet e suah kəti, kəni in tuvən mətan əpəha ikɨn kɨkə-kɨkə ikɨn, ikɨn nəhu tɨkə lan mətəsal ikɨn otəmeig ikɨn, mətəu təseruhiən. Kəni in otəni məmə, ‘Pəh iəkɨtəlɨg=pən e rəhak nimə u iəmsɨpən ikɨn aupən.’ ");
INSERT INTO tnp_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kəni nian in təmɨtəlɨg=pa, meh rəhan nimə kəmafəl təpiə vivi, kəni natimnati rəfin kəutəməhl-məhli vi əmə. ");
INSERT INTO tnp_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kəni in otuvən mit mɨn narmɨn tərah səpɨn mɨn məhuva u kotərah pɨk motapirəkɨs in. Kəni okəhuvən mɨn imə motatɨg e nəmiəgəhiən rəha suah u. Kəni suah u, aupən rəhan nəmiəgəhiən tərah, mətəu rəueiu tɨnərah pɨk agɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nian Iesu təməni nəghatiən əha, pətauəhli kəti tagət əfəməh məmə, “Uhgɨn təmətuati pəhriən e rəhan nəuvɨriən kəm pətan u iətəm təmemək lam, kəni məfɨnə nah kəm ik.” ");
INSERT INTO tnp_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kəni Iesu təni məmə, “Nɨpəhriəniən, mətəu Uhgɨn otətuati e rəhan nəuvɨriən kəm nətəmimi mɨn u kəutətəu rəhan nəghatiən tapirəkɨs agɨn, kəni mautol.” ");
INSERT INTO tnp_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kəni nian nətəmimi kəməhuva məmə okotətəu nəghatiən rəha Iesu, kəməhuva tepət nəuvetɨn mɨn, kəni Iesu təni məmə, “Itəmah nətəmi rəueiu mɨne, itəmah nol təfagə tərah agɨn mɨn. Itəmah nəkotolkeikei məmə nəkoteh nati apɨspɨs u nəmtətiən kəti. Mətəu Uhgɨn ko təsəfɨnəiən nəmtətiən kəti kəm təmah tol lanu. Mətəu Uhgɨn otəfɨnə əmə nəmtətiən kətiəh kəm təmah, inəha nəmtətiən rəha iəni Jonə. ");
INSERT INTO tnp_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Təhmen əmə e Jonə mə in nəmtətiən kəti tatuvən o nətəm Ninivə u aupən, kəni tol lanu, iəu Nətɨ Iətəmimi iəu mɨn nəmtətiən rəha nətəmimi u rəueiu mɨne. ");
INSERT INTO tnp_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Kəni e nian əha Uhgɨn otakil nətəmimi rəfin, kəni kwin rəha nɨtəni pesi ikɨn, otəhtul məni pətɨgəm məmə itəmah nətəm nəkotərah. Otəhrun nəniən lanəha mətəu-inu, in təmiet e nɨkalɨ nɨtəni əpəha isəu agɨn, kəni maliuək muva məmə otətəu nəghatiən rəha Kig Solomən u iətəm teinatɨg pɨk. Kəni oteruh-to, suah kəti iətəm in ilɨs agɨn mapirəkɨs Kig Solomən tɨnuva, mətəu itəmah nəsotətəlɨgiən. ");
INSERT INTO tnp_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Kəni nətəm Ninivə okotəhtul e nian Uhgɨn otakil nətəmimi ərəfin lan, kəni ilah okotəni məmə itəmah nəmotol noliən tərah. Kəni ilah okotəhrun nəniən lanəha mətəu-inu, nian ilah kəmotətəu nəghatiən rəha Jonə, ilah kəmotəuhlin ilah e noliən tərah mɨn rəhalah. Kəni rəueiu u, suah kəti u ikɨnu in ilɨs pɨk tapirəkɨs Jonə.” ");
INSERT INTO tnp_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Kəni Iesu təməni məmə, “Ko suah kəti təsasiəpəniən e lait, kəni ko matɨg məhluaig lan uə təfən e nɨpəg nati kəti. Kəpə. Mətəu nian iətəmi tasiəpən e lait, otəkeikei maharu pəri e nɨgi rəha lait məmə nətəmimi u kəutəhuva e nɨpəg nəuan nimə, kəni ko mauteruh nəhagəhagiən rəha lait kəni kotəhrun neruhiən nati lan. ");
INSERT INTO tnp_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nəhmtəm təhmen e lait u tətəfən nəhagəhagiən kəm nɨpətɨm. Nian nəhmtəm mil kuəuvɨr, təhmen əmə məmə nɨpətɨm təriauəh e nəhagəhagiən. Mətəu nian nəhmtəm mil kuərah, təhmen əmə məmə nɨpətɨm təriauəh e napinəpuiən. ");
INSERT INTO tnp_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kəni tol lanəha, ik onəkəkeikei mateh vivi məmə rəham nəhagəhagiən in səniən məmə napinəpuiən. ");
INSERT INTO tnp_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kəni nəmə rəham nəmiəgəhiən təriauəh vivi e nəhagəhagiən, napinəpuiən otɨkə agɨn lam, kəni nəhagəhagiən tasiəgəpɨn vivi rəfin rəham nəmiəgəhiən, təhmen=pən əmə e nəhagəhagiən rəha nəuanɨsiə tətasiəgəpɨn ik.” ");
INSERT INTO tnp_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kəni nian Iesu təməghati rəkɨs, kəni Farəsi kəti təmuva məni=pən kəm in məmə okian muauən əpəha e rəhan nimə. Kəni Iesu təmaliuək muvən əpəha imə məharəg e nɨkalɨ tepɨl o nauəniən. ");
INSERT INTO tnp_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kəni Farəsi əpəha təmauɨt ohni narmɨn təmiuvɨg nian təmeruh məmə Iesu təməsəueiuiən nəhlmɨn e nəhu uərisɨg təpanauən. ");
INSERT INTO tnp_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kəni Iərmənɨg təməni=pən kəm in məmə, “Itəmah u Farəsi mɨn, nəkotəhmen əmə e kap mɨne pɨlet iətəm nəutafəl ilah əpəha ihluə əmə, mətəu in əpəha e nɨpəgnəualah, kotapɨn. Itəmah nəkotəriauəh e navərəsiən mɨne nərahiən. ");
INSERT INTO tnp_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","!Itəmah nəutalməli pɨk! ?Nɨkitəmah təhti uə kəpə məmə, Uhgɨn iətəm təmol nɨpətɨtəmi, in mɨn təmol nɨkitəmi? !Əuəh! ");
INSERT INTO tnp_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mətəu onəkotəfən kəm nanrah mɨn e nɨkitəmah agiən, kəni natimnati rəfin ihluə mɨne imə okotəhruahru motəuvɨr. ");
INSERT INTO tnp_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“!Mətəu itəmah Farəsi mɨn, nərahiən asoli otuva o təmah! Itəmah nəutohtəu=pən vivi nɨpɨspɨsɨ Lou mɨn. Itəmah nəkotəni məmə nautol tait rəhatəmah e nɨmalɨ mɨnɨt mɨne ru mɨne nəuvein mɨn kotol lanəha, u iətəmimi tətəfən e nauəniən. Inu təhruahru e Lou, mətəu itəmah nɨnotəpəh nɨtəu-pəniən suaru əhruahru rəha nakiliən iətəmimi, mɨne suaru rəha nolkeikeiən Uhgɨn. Onəkotəkeikei motol noliən təuvɨr asoli əha, kəni məsotaluiən məmə nəkotol tait rəhatəmah. ");
INSERT INTO tnp_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Itəmah u Farəsi mɨn, nərahiən asoli otuva o təmah, mətəu-inu nəkotolkeikei məmə nəkəhuvən məutəharəg aupən e nimə rəha nuhapumɨniən. Kəni e makɨt, nəkotolkeikei məmə nətəmimi okotəfəri=pɨnə nəhlmɨ lah kəm təmah o nɨsiaiən itəmah. ");
INSERT INTO tnp_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Itəmah u Farəsi mɨn, nərahiən asoli otuva o təmah, mətəu-inu itəmah nəkotəhmen e suvət u kotamɨkmɨk, mətəu kəsəhrun əhruahruiən məmə in iə, kəni nətəmimi kəutaliuək pɨkɨn lan motəruru, məutol rəhalah nəmiəgəhiən tətamɨkmɨk.” ");
INSERT INTO tnp_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kəni iəgətun kəti rəha Lou təməni=pən kəm Iesu məmə, “Iəgətun. Nian nətəni nəghatiən mɨn u, kəni tətərəkɨn mɨn itɨmah.” ");
INSERT INTO tnp_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kəni Iesu təni məmə, “!Nəgətun mɨn rəha Lou! Nərahiən asoli otuva o təmah mətəu-inu, itəmah nəutəlɨn-pəri nati fɨgəm mɨn u tiəkɨs məmə nətəmimi okotos. Kəni məsotasiruiən nəuvetɨn e nəuanəhlmɨtəmah məmə onəkotasiru e lah o nosiən natimnati mɨn əha. ");
INSERT INTO tnp_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Nərahiən asoli otuva o təmah mətəu-inu itəmah nəutuvləkɨn nimə təuvɨr mɨn o suvət rəha iəni mɨn rəha Uhgɨn aupən, kəni məutəni məmə nəutɨsiai ilah. Mətəu nəuteiuə. Tɨpɨtəmah mɨn əmə kəmotohamu ilah. ");
INSERT INTO tnp_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Tol lanu, itəmah nəutəni pətɨgəm məmə itəmah nəutegəhan e natimnati mɨn əha tɨpɨtəmah mɨn kəmotol aupən, u kəmotohamu iəni mɨn, kəni itəmah nɨkitəmah tagiən o noliən rəhalah, kəni ko nautuvləkɨn suvət mɨn rəhalah. ");
INSERT INTO tnp_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Kəni tol lanəha, Uhgɨn u iətəm teinatɨg pɨk təməni məmə, ‘Iəu oiəkahli=pən rəhak iəni mɨn mɨne aposɨl mɨn okəhuvən motəghati kəm lah, kəni ilah okotəgəu rəkɨs ilah motol nərahiən kəm nəuvein, kəni motuhamu nəuvein.’ ");
INSERT INTO tnp_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Tol lanəha, Uhgɨn otakil itəmah təhmen məmə itəmah əmə nəmotohamu iəni mɨn rəfin rəhan, kəni in otol nalpɨniən kəm təmah o nɨmɨsiən rəhalah, ilah u kəməutatɨg e nətuəuiniən e nɨftəni mətəuarus=pa u rəueiu, ");
INSERT INTO tnp_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","iəni mɨn rəfin u kəmotuhamu əpəha e Epɨl mətəuarus=pən Səkaraea, u iətəm təmɨmɨs e Nimə rəha Uhgɨn e nəlugɨn e oltə mɨne nimə. Kəni nɨpəhriəniən, itəmah u rəueiu mɨne, Uhgɨn otol nalpɨniən kəm təmah. ");
INSERT INTO tnp_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Kəsi, itəmah mɨn u nəgətun mɨn rəha Lou, nərahiən asoli otuva o təmah mətəu-inu suaru kəti əha ikɨn iətəm tətəgətun nak Uhgɨn tolkeikei. Itəmah nəkotəhrun suaru əha, mətəu nəutəhluaig lan məmə nətəmimi kotəruru. Itəmah nəsotəgətun-pəniən, kəni məutasisɨg e nətəmimi məmə ilah mɨn kotəruru nɨtəu-pəniən.” ");
INSERT INTO tnp_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nian Iesu təmiet e nimə əha mɨnətaliuək mɨnatuvən, kəni nəgətun mɨn rəha Lou mɨne Farəsi mɨn, niəməha təmol ilah. Təmətuəuin əha ikɨn əha, ilah kəməhuva məmə tɨkɨmɨr mɨn rəhan. Kəni ilah kəməutərakipən e nəghatiən əskasɨk tepət kəm in ");
INSERT INTO tnp_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","məmə okoteruh-to nəniən kəti rəhan u iətəm təsəhmeniən. ");
INSERT INTO tnp_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kəni e nian əha, nətəmimi tepət kəməhuva kətiəh, ko kafin kəruru. Mətəu nətəmimi tɨnepət pɨk, kəni məutəhgi-əhgi rəkɨs ilah mɨn. Kəni ko Iesu tətuəuin mətəghati kəm rəhan mɨn nətəmimi məmə, “Itəmah, onəutətəu itəmah o is rəha Farəsi mɨn, is u in noliən rəhalah u rəhalah nəniən təuvɨr, mətəu nɨkilah tamɨkmɨk. ");
INSERT INTO tnp_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Natimnati u iətəmimi tatol oneuən, Uhgɨn otəpanəfətɨgəm, tagəhag ikɨn. Kəni natimnati iətəm iətəmimi tətəhluaig lan, kəni Uhgɨn otəpanəfətɨgəm, nətəmimi okoteruh. ");
INSERT INTO tnp_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Natimnati u nautəni e napinəpuiən, nətəmimi okotətəu e nərauiə asoli. Kəni natimnati u nəutəni oneuən e nɨpəgnəua nimə, nətəmimi kəpanotəni pətɨgəm əpə ihluə, nətəmimi rəfin okotətəu. ");
INSERT INTO tnp_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Rəhak mɨn nətəmimi, iəkəni kəm təmah məmə, nəsotəgɨniən e nətəmimi u kotəhrun nuhamuiən nɨpətɨtəmah, mətəu uərisɨg, ko kəsotol mɨniən nati kəti tərah e təmah. ");
INSERT INTO tnp_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mətəu iəkəni pətɨgəm kəm təmah iətəmi u təhruahru məmə onəkotəgɨn lan. Onəkotəkeikei motəgɨn e Uhgɨn, mətəu-inu nian in otohamu suah kəti, in təhrun nərəki-pəniən in e nɨgəm asoli. Əuəh, nɨpəhriəniən, iəkəni kəm təmah məmə onəkotəkeikei motəgɨn e Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Mənɨg əlkələh uəha kotəhmen e kəuviəguvehli u kos nəhmtɨ lah məni əkəku əmə, mətəu Uhgɨn təsaluiən agɨn e kəti. ");
INSERT INTO tnp_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Sotəgɨniən, mətəu-inu Uhgɨn tolkeikei itəmah tapirəkɨs mənɨg mɨn tepət. Nɨpəhriəniən, Uhgɨn təmafin məhrun vivi nəuanutəmah rəfin. ");
INSERT INTO tnp_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Iəkəni kəm təmah məmə, nəmə iətəmi tətəni pətɨgəm e nəhmtɨ nətəmimi məmə in rəhak kəti, kəni iəu Nətɨ Iətəmimi, iəu mɨn iəkəni pətɨgəm e nəhmtɨ nagelo mɨn rəha Uhgɨn məmə in rəhak iətəmimi. ");
INSERT INTO tnp_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mətəu nəmə iətəmi tətəni pətɨgəm e nəhmtɨ nətəmimi məmə in səniəmə məmə iətəmimi kəti rəhak, kəni iəu iəkəni pətɨgəm e nəhmtɨ nagelo mɨn məmə suah u in səniəmə iətəmimi kəti rəhak. ");
INSERT INTO tnp_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Kəni iətəmimi tətəni nəghatiən tərah e Nətɨ Iətəmimi, Uhgɨn otafəl rəkɨs rəhan təfagə tərah. Mətəu iətəmimi tətəghati rah e Narmɨn Rəha Uhgɨn, ko Uhgɨn təsafəl rəkɨsiən rəhan təfagə tərah. ");
INSERT INTO tnp_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Kəni nian kotiuvi pətɨgəm itəmah e nimə rəha nuhapumɨniən, mɨne e nəhmtɨ iərmənɨg mɨn, mɨne nətəmi asoli mɨn məmə okotiuvi pətɨgəm itəmah məutakil rəhatəmah nəghatiən, kəni nɨkitəmah otəsəhti pɨkiən məmə onəkotəhro lanu motuhalpɨn rəhalah nəghatiən, ");
INSERT INTO tnp_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","mətəu-inu e nian əhruahru əha, Narmɨn Rəha Uhgɨn otəgətun itəmah e nəghatiən nak onəkotəghati lan kəni motəni kəm lah.” ");
INSERT INTO tnp_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kəni nətəmi mɨn əha kəti təməni=pən kəm Iesu məmə, “Iəgətun. Rəhak tatə tɨnɨmɨs rəkɨs. Pale, əni=pən kəm piak məmə otəuəri natimnati rəha tatə rəhatɨmlau məmə təfa rəhak nəuvein, u iətəm tatə təmələhu məmə rəhak.” ");
INSERT INTO tnp_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mətəu Iesu təməni kəm in məmə, “Iəu kəti, iəu iəkɨkə e nətəlɨgiən u rəhatəlau o nəuəriən rəhatəlau natimnati.” ");
INSERT INTO tnp_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kəni Iesu təməni=pən kəm lah məmə, “Onəutətəu vivi itəmah. Onəkotasisɨg vivi e təmah məmə nəsotoliən məmə itəmah navərəs mɨn, mətəu nəukətɨ nəmiəgəhiən təsɨsɨpəniən e nautə tepət.” ");
INSERT INTO tnp_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kəni təməni nəghatiən əuhlin u məmə, “Suah kəti, rəhan nautə tepət, kəni rəhan nasumiən təuvɨr pɨk. ");
INSERT INTO tnp_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kəni məni=pən aru kəm in məmə, ‘?Kəsi, oiəkəhro əha rəueiu, mətəu-inu rəhak nimə mɨn kɨnotəpəh nəhmeniən məmə iəkəfən nauəniən nəgək mɨn ikɨn?’ ");
INSERT INTO tnp_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Kəni in təməni məmə, ‘Təuvɨr məmə iəkol lanu lan. Iəkəmki rəkɨs nimə mɨn u, kəni mol nimə asoli mɨn nəuvein iətəm iahgin mɨn nəuvetɨn. Kəni məlɨn=pən nəgək nauəniən, mɨne nautə mɨn rəhak ikɨn. ");
INSERT INTO tnp_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kəni iəkəhrun nəniən aru kəm iəu məmə, rəhak natimnati tepət pəhriən təhmen o nu tepət. Kəni rəueiu əha iəkəmeig, mətauən, mətəmnɨm, kəni mətətəu nagiəniən təuvɨr əmə lanu rəha nian rəfin.’ ");
INSERT INTO tnp_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Mətəu Uhgɨn təməni=pən kəm in məmə, ‘!Ik ialməli! Iəu iəməfɨnə nəmiəgəhiən u kəm ik, mətəu rəueiu əmə u lapɨn, iəkos rəkɨs, nəkɨmɨs. ?Kəni okəhro e natimnati mɨn u rəham ik nəmoriarun=pa tepət pɨk, kəni pəh otarmənɨg e natimnati mɨn əha?’” ");
INSERT INTO tnp_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Kəni Iesu təməni məmə, “Uhgɨn otol əmə lanəha kəm nətəmimi u kəutoriarun nautə mɨn tepət məmə rəhalah, kəni nɨkin təsəhti pɨkiən noliən təuvɨr mɨn u Uhgɨn tolkeikei.” ");
INSERT INTO tnp_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kəni Iesu təməni kəm rəhan mɨn nətəmimi məmə, “Mətəu-inu noliən əha, iətəni kəm təmah məmə, nəsotətəlɨg pɨkiən e natimnati rəha nəmiəgəhiən rəhatəmah məmə onəkotun nak, kəni məsotətəlɨg pɨkiən e natimnati rəha nɨpətɨtəmah məmə onəkəhuvən e nak. ");
INSERT INTO tnp_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nəsotətəlɨg pɨkiən mətəu-inu nəmiəgəhiən rəhatəmah tapirəkɨs nauəniən, kəni nɨpətɨtəmah tapirəkɨs napən mɨn rəha nuvəniən lan. ");
INSERT INTO tnp_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Oteruh-to mənɨg mɨn, ilah kəsotasumiən, kəni məsotəuləkiən, kəni rəhalah nimə rəha nauəniən tɨkə, mətəu Uhgɨn in tətaugɨn ilah. !Mətəu Uhgɨn tolkeikei pɨk itəmah tapirəkɨs mənɨg mɨn! ");
INSERT INTO tnp_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“?Nɨkitəmah təhti məmə rəhatəmah nətəlɨg pɨkiən təhrun noliən rəhatəmah nəmiəgəhiən təfəməh? !Kəpə! Noliən rəha nətəlɨg pɨkiən təsəfɨnəiən auə kətiəh mɨn e nəmiəgəhiən rəhatəmah. ");
INSERT INTO tnp_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","?Mətəu nəmə itəmah nəsotəhruniən noliən nati əkəku kəti tol lanəha, kəni təhro nəutətəlɨg pɨk e natimnati pɨsɨn pɨsɨn mɨn e nəmiəgəhiən rəhatəmah? ");
INSERT INTO tnp_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Nɨkitəmah təhti-to noliən rəha nəugɨnɨgi mɨn u kəutəugɨn. Ilah kəsotoliən nati kəti, məsotəhliən rəhalah napən. Mətəu iəkəni kəm təmah məmə aupən, Kig Solomən, in iətəmimi rəhan nautə tepət, kəni rəhan napən iətəm tatuvən lan, ilah kotəuvɨr motapirəkɨs. Mətəu nəugɨ nɨgi əpnapɨn mɨn kotəuvɨr tapirəkɨs agɨn rəhan napən. ");
INSERT INTO tnp_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nəugɨnɨgi mɨn əha kəutəhtul o nian kətiəh əmə, kəni olauɨg, kuvan e nɨgəm, mətəu Uhgɨn in tatol ilah kotəuvɨr pɨk. ?Kəni nɨkitəmah təhti məmə in otəfɨnə napən kəm təmah uə kəpə? !Əuəh! Rəhak nətəmimi, rəhatəmah nəhatətəiən təkəku agɨn. ");
INSERT INTO tnp_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Təsəuvɨriən məmə nɨkitəmah təhti pɨk natimnati o nəmiəgəhiən rəhatəmah, kəni nian rəfin nəutəsal e nauəniən nɨgtəmah mɨne nəmnɨmiən nɨmtəmah. ");
INSERT INTO tnp_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nɨkitəmah təsəhti pɨkiən natimnati mɨn əha, mətəu-inu nətəm kəsotəhatətəiən e Uhgɨn, ilah kəutəsal e natimnati mɨn əha. Rəhatəmah Tatə in təhrun natimnati iətəm nəkotəkeikei motos o nəmiəgəhiən rəhatəmah. ");
INSERT INTO tnp_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mətəu onəkotətəlɨg pɨk əmə e natimnati rəha Narmənɨgiən Rəha Uhgɨn motol təhtul aupən e nəmiəgəhiən rəhatəmah, kəni in otəfɨnə mɨn kəm təmah natimnati mɨn rəha nəmiəgəhiən u ikɨnu e nəhue nɨftəni. ");
INSERT INTO tnp_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Nəsotəgɨniən, itəmah rəhak mɨn sipsip itəmah təkəku əmə, mətəu-inu Tatə rəhatəmah nɨkin tətagiən pɨk o təmah məmə onəkotatɨg ahgəl rəhan narmənɨgiən, kəni in oteh vivi itəmah, kəni onəkotarmənɨg itəmah min. ");
INSERT INTO tnp_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Onəkotəfətɨgəm rəhatəmah natimnati nətəmimi kotos nəhmtɨn, kəni motəfən məni kəm nanrah mɨn. Nian nəkotol təuvɨr lanu, in təhmen məmə ikɨn nautə rəhatəmah otətəməhli ikɨn ko təsərahiən nian kəti, kəni itəmah onəkotələhu pən rəhatəmah natimnati iətəm təuvɨr əpəha e negəu e neai iətəm ko təsɨkəiən. Kəni ikɨn əha, ko nakləh mɨn kəsotərəkɨniən, kəni ko uvni mɨn kəsotərəkɨniən natimnati mɨn əha. ");
INSERT INTO tnp_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Iətəni lanu mətəu-inu, ikɨn pəhruvən rəhatəmah natimnati təuvɨr mɨn kəutəməhli ikɨn, kəni nɨkitəmah otəkeikei məhti-əhti natimnati mɨn əha ikɨn əha.” ");
INSERT INTO tnp_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Kəni Iesu təməni məmə, “Nian mɨn ərəfin, onəutəhtul maru, təhmen e iətəmi təfən napən rəha uək, meargin rəhan kətəuti, kəni masiəpən e rəhan nəuanɨsiə nian rəfin. ");
INSERT INTO tnp_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Onəkotəkeikei motəhmen e noluək mɨn rəha iərmənɨg kəti təmsɨpən e lafet kəti rəha marɨt kəti. Kəni nian in təmuva məhti-əhti doə, kəni əmeiko, ilah koterəh e doə məmə otuvən imə. ");
INSERT INTO tnp_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Noluək mɨn u kəutair məutəhtul maru nian iərmənɨg tətuva, ilah kəmoteh kəni motos nəuvɨriən rəha iərmənɨg. Nɨpəhriəniən u iəkəni kəm təmah məmə, in otuvən e napən rəha uək, kəni mauɨn e lah məmə okəhuva motəharəg, kəni in oteh vivi ilah kəni maugɨn ilah. ");
INSERT INTO tnp_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kəni nəmə iərmənɨg otətuva lapɨn e napinəpuiən, uə e nian mənɨg nətəkakə lan, mətəu noluək mɨn kəutair mautol əpenə əmə, kəni in otol təuvɨr agɨn kəm lah. ");
INSERT INTO tnp_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kəni itəmah nəkotəkeikei motəhrun məmə, nəmə suah kəti təhrun nian əhruahru iətəm iakləh otuva e rəhan nimə məmə otakləh, kəni ko in təsapɨliən, in otətəhtul maru mateh vivi rəhan nimə məmə iakləh otəsuvaiən imə. ");
INSERT INTO tnp_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kəni itəmah, nian rəfin nəkotəkeikei məutəhtul maru mətəu-inu iəu Nətɨ Iətəmimi iəkuva mɨn e nian iətəm itəmah nəsotəhruniən.” ");
INSERT INTO tnp_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Kəni Pitə təməni=pən kəm in məmə, “Iərmənɨg. ?Nəghatiən əuhlin u nətəni rəhatɨmah əmə, uə rəha nətəmimi ərəfin?” ");
INSERT INTO tnp_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kəni Iərmənɨg təni məmə, “?Pəh u in ioluək kəni meinatɨg mɨn matol rəhan uək e nian mɨn rəfin e noliən iətəm təuvɨr? ?Kəni iərmənɨg kəti otəfəri pəh otuva iətəmi asoli rəha noluək mɨn e nimə rəhan məmə in təuəri nauəniən nɨg noluək mɨn rəfin e nian əhruahru rəhan? ");
INSERT INTO tnp_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kəni nian iərmənɨg rəha suah kəha tɨtəlɨg=pa, kəni meruh məmə in tatol vivi rəhan uək, kəni in otol təuvɨr kəm ioluək əha. ");
INSERT INTO tnp_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nɨpəhriəniən iəkəni kəm təmah məmə, iərmənɨg in otəfəri ioluək əha tuva mol iətəmi asoli lan məmə in otarmənɨg e natimnati rəfin rəhan. ");
INSERT INTO tnp_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","?Mətəu nəmə ioluək u nɨkin təhti məmə, ‘Rəhak iətəmi asoli təsuvaiən nuvəh. Ko təsuva uəhaiən.’ Kəni ioluək əha tɨnətuəuin mɨnatoh noluək mɨn nɨpətan mɨne nəman, kəni muvən mətauən mətəmnɨm mətapɨs. ?Kəni iərmənɨg otol nak? ");
INSERT INTO tnp_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Iərmənɨg rəha suah u otɨtəlɨg=pa ohni e nian kəti iətəm in təsəhruniən kəni məsəhtul maruiən ohni. Kəni iərmənɨg otəfən nalpɨniən asoli kəm in, kəni in otəfən in tuvən matɨg ilah nətəmi mɨn u kəsotoliən rəhan nəghatiən. ");
INSERT INTO tnp_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ioluək əha iətəm tɨnəhrun rəkɨs nəghatiən rəha iərmənɨg rəhan, mətəu in təsəhtul maruiən məmə otol uək mɨn əha, kəni okoh in tətəu nahməiən. ");
INSERT INTO tnp_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mətəu ioluək iətəm in təsəhruniən nəghatiən mɨn rəha iərmənɨg, kəni in matol natimnati iətəm in təsəhruahruiən iətəm in otəkeikei mos nalpɨniən ohni, kəni okoh mətɨg ioluək u. Iətəmimi u Uhgɨn tətəfən natimnati tepət kəm in, in otəkeikei mol natimnati tepət. Kəni iətəmimi u kətələhu=pən natimnati tepət e nəhlmɨn, okətapuəh e natimnati tepət ohni.” ");
INSERT INTO tnp_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Kəni Iesu təməni məmə, “Iəmuva məmə iəkəhlman e nɨgəm e nəhue nɨftəni, kəni nəmə rəueiu əha nɨgəm əha tɨnatuəu rəkɨs, kəni nɨkik tagiən. ");
INSERT INTO tnp_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nian əskasɨk kəti otuva e rəhak nəmiəgəhiən, təhmen e noliən bəptais kəti, kəni nɨkik tətahmə lan mətəuarus otol naunun. ");
INSERT INTO tnp_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","?Nɨkitəmah təhti məmə iəmuva u məmə iəkələhu nəməlinuiən e nəhue nɨftəni? !Kəpə! Iəməsuvaiən məmə iəkələhu nəməlinuiən, mətəu iəmuva məmə iəkol nətəmimi kotaiu atiti. ");
INSERT INTO tnp_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kəni rəueiu əha, nəmə nətəmimi faif e lahuənu kəti, kəni okotəuəri ilah mɨn, kɨsɨl oklahi keiu, kəni keiu okuahi kɨsɨl. ");
INSERT INTO tnp_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tatə mɨne nətɨn iərman okətuərah o lau mɨn. Kəni mamə mɨne nətɨn pətan, okətuərah o lau mɨn. Kəni pətan mɨne uhun, okətuərah o lau mɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kəni in təməghati mɨn kəm nɨmənin nətəmimi mətəni məmə, “Nian nəkoteruh nɨmalɨ nəpuə mɨn okotəri, kəni nəkotəni uəhai əmə məmə otəfuv, kəni otol pəhriən. ");
INSERT INTO tnp_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kəni nian nəkoteruh nɨuig notəsuvəhiən tol naugɨn, nəkotəni məmə okəpiapei, kəni otol pəhriən. ");
INSERT INTO tnp_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","!Ei! !Itəmah nəfaki eiuə mɨn! Itəmah nəkotəni məmə nəkotəhrun pɨk natimnati mɨn, kəni motəhrun nehiən nɨftəni mɨne neai, kəni nəkotəhrun məmə nian otuva lanəha, kəni otol pəhriən lanəha. ?Mətəu təhro nəsotəhruniən nɨpətɨ nəmtətiən mɨn iətəm nauteruh əha rəueiu? ");
INSERT INTO tnp_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“?Təhro nəsotɨtəpəniən suaru iətəm təhruahru məmə onəkotohtəu=pən? ");
INSERT INTO tnp_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nian suah kəti otələs ik nəkian e kot, kəni e nian natualiuək e suaru, kəni təuvɨr məmə nəkaupən məghati kəm in muəni-vivi rəhatəlau nərahiən. Nəmə nəsuoliən, kəni otələs ik mian e kot, kəni iətəmi asoli rəha kot otegəhan=pən lam e nəhlmɨ polɨs, kəni otələs ik muvən masisɨg lam e kaləpus. ");
INSERT INTO tnp_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Iətəni kəm ik məmə, nəmə tol lanəha, ko nəsietiən e kaləpus mətəuarus nəkəkeikei mətəou e məni rəfin agɨn o nalpɨniən rəham.” ");
INSERT INTO tnp_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kəni e nian əha, nətəmimi nəuvein kəməhuva motəni=pən kəm Iesu məmə nətəm Kaləli nəuvein kautoh natimiəgəh mɨn məmə okotol sakrifais lan kəm Uhgɨn, əmeiko, soldiə mɨn rəha kəpmən u Pailət kəməhuva motohamu ilah, kəni nɨra natimiəgəh mɨn mɨne nɨra nətəmimi mɨn kəmotaiu motol əmə kətiəh. ");
INSERT INTO tnp_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Kəni Iesu təməni=pən məmə, “?Təhro? ?Nɨkitəmah təhti məmə nərahiən əskasɨk rəha nətəm Kaləli əha məmə inkonu ilah kotərah pɨk tapirəkɨs ərəfin nətəm Kaləli? ");
INSERT INTO tnp_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","!Kəpə! Iətəni kəm təmah məmə təsoliən lanəha. Mətəu okəmə itəmah mɨn nəsotəuhliniən itəmah e noliən tərah mɨn rəhatəmah, kəni itəmah mɨn onəkohmɨs. ");
INSERT INTO tnp_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","?Kəni təhro e nətəm Sailoam eitin əpə nimə əfəməh təməmei məharəg-ərain ilah kohmɨs? ?Nɨkitəmah təhti məmə nəmiəgəhiən rəhalah tərah tapirəkɨs nətəmimi rəfin əpəha Jerusɨləm? ");
INSERT INTO tnp_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","!Kəpə! Iətəni kəm təmah məmə təsoliən lanəha. Mətəu nəmə itəmah nəsotəuhliniən itəmah e noliən tərah rəhatəmah, kəni itəmah mɨn onəkohmɨs.” ");
INSERT INTO tnp_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kəni təməni nəghatiən əuhlin u məmə, “Iətəmimi kəti təmərfei nɨgi kəti e nasumiən rəhan, nərgɨn u fik. Kəni nian nu mɨn nəuvein təmuva mɨnuvən rəkɨs, kəni suah u təmuvən nian tepət mətəsal e nəuan nɨgi u, mətəu-inu təsəuəiən. ");
INSERT INTO tnp_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kəni in təməni=pən kəm suah u tateh nasumiən məmə, ‘Eruh-to. Iəmuva mətəsal e nəuan nɨgi mɨnos nu kɨsɨl, mətəu iəseruhiən nəuan nɨgi kəti mɨne. Əuahli rəkɨs. Təsəuvɨriən məmə təhtul pəsɨg e nɨftəni rəha nasumiən.’ ");
INSERT INTO tnp_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kəni suah u iətəm tateh nasumiən təni=pən kəm in məmə, ‘Iətəmi asoli, upəh-to pəh tos mɨn nu kətiəh. Kəni iəkel nɨftəni mɨtəlau e nəukətɨn, kəni masiru lan məmki=pən nɨftəni təuvɨr. ");
INSERT INTO tnp_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kəni nəmə təuə e nu əha ikɨn, kəni ko təuvɨr. Mətəu nəmə kəpə, ik nəkəhrun nətei rəkɨsiən.’” ");
INSERT INTO tnp_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kəni e Sapət kəti, Iesu təmətəgətun nətəmimi əpəha e nimə rəha nuhapumɨniən. ");
INSERT INTO tnp_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kəni pətan kəti əha ikɨn narmɨn tərah tətatɨg lan e nu eitin, kəni tatol məmə nəmtahn tatekəu e nian rəfin, kəni məsəhtul əhruahruiən. ");
INSERT INTO tnp_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kəni Iesu təmeruh in, kəni in təmauɨn lan məmə otuva ohni, kəni təni=pən kəm in məmə, “Pətan. Iəu iatɨtɨs rəkɨs rəham nɨmɨsiən, ko təsaskəlɨmiən ik.” ");
INSERT INTO tnp_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kəni Iesu təmələhu=pən nəhlmɨn lan, kəni əmeiko, təməhtul əhruahru mɨnəuvɨr, kəni mɨnatəni-vivi Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mətəu iətəmi asoli rəha nimə rəha nuhapumɨniən, nɨkin təmahmə məmə inko Iesu təmol vi pətan u e nian rəha Sapət. Kəni in təməni=pən kəm nətəmimi məmə, “Nian sikɨs rəhatəmah o noliən uək lan. Nəkotəhrun nəhuvaiən e nian mɨn əha məmə in otol vi itəmah lan, mətəu e nian rəha Sapət, onəsəhuvaiən lan.” ");
INSERT INTO tnp_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Kəni Iərmənɨg təməni=pən kəm in məmə, “!Itəmah nəfaki eiuə mɨn! ?Pəh u ikɨnu e nɨkitəmah e nian rəha Sapət, kəni təsɨtɨsiən rəhan kau uə togki u təmohrain, kəni masɨg muvən təmnɨm nəhu? !Kəpə! Itəmah mɨn nautol lanəha. ");
INSERT INTO tnp_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mətəu pətan əha, in nəuanɨləuɨs kəti rəha Epraham, u Setən təməlis o nu eitin. Kəni təhruahru əmə iəu iəkəkeikei mɨtɨs kəni mosmiəgəh in e nian rəha Sapət.” ");
INSERT INTO tnp_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kəni nəghatiən rəha Iesu təmol rəhan tɨkɨmɨr mɨn kəmotaulɨs. Kəni nətəmimi rəfin, nɨkilah tagiən o uək təuvɨr agɨn mɨn iətəm Iesu tatol ilah. ");
INSERT INTO tnp_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kəni Iesu təməni məmə, “?Narmənɨgiən Rəha Uhgɨn in təhmen e nak? Pəh iəkəni nəghatiən əuhlin kəti məmə otəgətun itəmah e Narmənɨgiən Rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nəua nɨgi kəti u nɨkɨtɨn natiəkəku agɨn u tətəgətun=pən Narmənɨgiən Rəha Uhgɨn. Kəni suah kəti tərfei e rəhan nasumiən. Kəni nɨkɨtɨn teviə mol iahgin, kəni mənɨg ilɨs mɨn kəhuva motol=pən nimaalah e nəhlmɨn mɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kəni təməni mɨn məmə, “?Iətəgətun Narmənɨgiən Rəha Uhgɨn məmə in təhmen=pən e nak? ");
INSERT INTO tnp_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","In təhmen=pən e is nəuan nəuvetɨn iətəm pətan kəti tətalkin flauə e pesɨn asoli, kəni təhgi flauə rəfin tətasisi matol iahgin.” ");
INSERT INTO tnp_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nian Iesu təmətaliuək matuvən Jerusɨləm, kəni mətəgətun nətəmimi e nəhruənu asoli mɨn mɨne lahuənu mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kəni suah kəti təmətapuəh ohni məmə, “?Iərmənɨg, nətəmimi nəuan nəuvein əmə iətəm Uhgɨn otosmiəgəh ilah?” Kəni Iesu təməni=pən kəm lah məmə, ");
INSERT INTO tnp_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Iəkəni kəm təmah məmə onəkotəkeikei motalkut pɨk məmə nəkəhuvən pən e namtɨhluə u iətəm natiəkəku tatuvən e negəu e neai, mətəu-inu nətəmimi tepət okotalkut məmə okəhuvən imə, mətəu ko kəsəhuvəniən. ");
INSERT INTO tnp_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mətəu o nian kəti, iərmənɨg rəha nimə əha in otəhtul masisɨg e rəhan doə. Kəni itəmah u nəsəhuvaiən əha imə e nɨkulu iətəm natiəkəku, onəkəutəhtul ihluə məutəhti-əhti nɨkulu məutəni məmə, ‘Pale, Iərmənɨg. !Erəh e doə o tɨmah!’ Mətəu in otəni məmə, ‘Iəkəruru agɨn itəmah.’ ");
INSERT INTO tnp_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kəni itəmah onəkotəni məmə, ‘Iərmənɨg, kitah kəmotauən pəti, kəni ik nəməgətun itɨmah əpəha imatɨmah ikɨn.’ ");
INSERT INTO tnp_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mətəu in otəni=pɨnə məmə, ‘Iəu iətəni kəm təmah məmə iəkəruru agɨn itəmah. Itəmah rəfin nətəm nəkotərah agɨn. !Əhuvən əpəha isəu ohniəu!’ ");
INSERT INTO tnp_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“E nian əha itəmah onəkoteruh Epraham, mɨne Aisək, mɨne Jekəp, mɨne iəni aupən mɨn kəutatɨg e negəu e neai iətəm Uhgɨn tətarmənɨg lan, mətəu itəmah onəutəhtul ihluə kəni okəraki pətɨgəm e təmah, kəni onəkotasək, mautɨgət-ərain nəhluvtəmah, məutətəu tərah. ");
INSERT INTO tnp_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kəni nətəmimi okotsɨpən e nɨkalɨn mɨn rəfin rəha nəhue nɨftəni, məmə okəhuvən motəharəg motauən e negəu e neai iətəm Uhgɨn tətarmənɨg lan. ");
INSERT INTO tnp_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kəni təuvɨr məmə nəkotəhrun məmə, nətəmimi nəuvein iətəm kautəhuərisɨg okəhuva motəhtul aupən. Kəni nətəmimi nəuvein u kəutaupən, ilah okəpanəhuərisɨg.” ");
INSERT INTO tnp_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kəni e nian əha, Farəsi mɨn nəuvein kəməhuva motəni=pən kəm Iesu məmə, “Təuvɨr məmə onəkiet uəhai əmə u ikɨnu matuvən, mətəu-inu Herot Antipas tolkeikei məmə otuhamu ik.” ");
INSERT INTO tnp_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Kəni Iesu təməni=pən kəm lah məmə, “Herot Antipas in iol ekəu-ekəu, təhmen e kuri rarpɨn. Əhuvən motəni=pən kəm in məmə iəu iətəni məmə, ‘Eh-to. Nian əkuəkɨr əmə əha ikɨn tətatɨg iətəm iəu iəkəhgi pətɨgəm narmɨn tərah mɨn e nətəmimi, kəni matol vivi nɨmɨsiən rəha nətəmimi, kəni uərisɨg e nian kɨsɨl lan, kəni iəkol naunun e rəhak uək.’ ");
INSERT INTO tnp_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","“Nati əpnapɨn Herot təməni lanəha, mətəu iəu iəkəkeikei mətɨtəu=pən rəhak suaru matuvən u rəueiu, mɨne olauɨg, mɨne oniəh muvən miet pən Jerusɨləm. Ikɨn əha əhruahru iətəm okotəkeikei kɨsiai iəni mɨn ikɨn. Mətəu Jerusɨləm əmə, kətuhamu iəni mɨn rəha Uhgɨn ikɨn. ");
INSERT INTO tnp_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“!Əui kəsi, nətəm Jerusɨləm, nətəm Jerusɨləm! Itəmah nəutohamu iəni mɨn rəha Uhgɨn, kəni nətəmimi nətəm Uhgɨn təmahli=pa kəm təmah, nəutahtɨmu ilah e kəpiel apɨn, inəha nətəmimi u rəha Uhgɨn nətəm kautos nəghatiən rəhan. Nian tepət iətigaru əfəməh e nəhlmək məmə iəkos vivi itəmah, təhmen=pən e mənɨg iətəm tatuu nenətɨn mɨn e nɨkəuvkəuvɨn, mətəu nɨkitəmah təsagiəniən, kəni məutəpəh iəu. ");
INSERT INTO tnp_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Otafu-to. Uhgɨn tɨnəpəh itəmah, rəhatəmah nimə nərahiən otələs, kəni nati tɨkə ikɨn. Kəni iəkəni kəm təmah məmə, nati əha in nɨpəhriəniən mətəu-inu onəsoteruh mɨniən iəu mətəuarus nəkotəni məmə, ‘!Iərmənɨg Uhgɨn tətatɨg ilau suah u iətəm tətuva e nərgɨn.’” ");
INSERT INTO tnp_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","E nian e Sapət kəti, Iesu təmuvən e nimə rəha iətəmi asoli kəti rəha Farəsi mɨn məmə otauən, kəni nətəmimi kəmauteruh vivi in məmə otol-to nak. ");
INSERT INTO tnp_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Kəni inəha Iesu təmətəharəg ikɨn, suah kəti tatɨmɨs e nɨmɨsiən u nɨpətɨn tətasisi, in tətəharəg iuəkɨr əmə ohni. ");
INSERT INTO tnp_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kəni Iesu təmətapuəh o nəgətun mɨn rəha Lou mɨne Farəsi mɨn məmə, “?Təhro? ?Lou tətegəhan məmə suah kəti otol vivi nətəmi kautohmɨs kotəhrun nəmiəgəhiən mɨn e Sapət, uə Kəpə?” ");
INSERT INTO tnp_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mətəu ilah kəsotəniən nati kəti mɨne. Kəni Iesu təmos suah u, mol nɨpətɨn təuvɨr mɨn, kəni mahli=pən tatuvən. ");
INSERT INTO tnp_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kəni təməni=pən kəm lah məmə, “?Nəmə itəmah kəti, rəhan suakəku, uə rəhan kau otiuvɨg=pən pɨkɨn e nɨmɨl asoli e Sapət, kəni in otəhro? In otəkeikei muvən mələs rəkɨs uəhai əmə. ?Pəh u e təmah otəsoliən lanəha?” ");
INSERT INTO tnp_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kəni rəhalah kəti nəghatiən təmɨkə məmə okotəni. ");
INSERT INTO tnp_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kəni Iesu təmeh nətəmimi nəuvein iətəm kəmauɨn e lah o nauəniən, kəni kəməhuva imə kəni motɨtəpɨn ikɨn mɨn rəha nɨsiaiən məmə okotəharəg=pən ikɨn. Kəni təməni=pən kəm lah məmə, ");
INSERT INTO tnp_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nəmə iətəmi tətauɨn lam məmə onəkuva o nauəniən rəha marɨt, kəni nəsuvəniən məharəg pɨpɨm ikɨn təuvɨr ikɨn maupən. Məta suah kəti in tepət mapirəkɨs ik tuva, ");
INSERT INTO tnp_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","kəni iətəmi asoli rəha nimə otəni kəm ik məmə, ‘Agɨm. Pəh suah u in otəharəg u ikɨnu.’ Kəni onakaulɨs mətəu-inu onəkəkeikei meiuaiu məharəg ləhtəni agɨn ikɨn nɨsiaiən tɨkə ikɨn. ");
INSERT INTO tnp_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mətəu nəmə suah kəti taun lam məmə nəkuvən mauən e nauəniən kəti, kəni təuvɨr məmə nəkɨtəpɨn ikɨn nɨsiaiən tɨkə ikɨn. Kəni ko, nəmə iətəmi asoli rəha nimə tuva, kəni in otəni kəm ik məmə, ‘Rəhak iətəmimi, uvən məharəg əha ilɨs, ikɨn təuvɨr ikɨn.’ Kəni inu otləfəri nərgəm e nəhmtɨ nətəmi rəfin əha imə. ");
INSERT INTO tnp_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Iəkəni lanu mətəu-inu iətəmi tətəfəri aru in məmə otuva iətəmi asoli, Uhgɨn in otosiahu in. Mətəu iətəmimi tatosiahu aru in, Uhgɨn otəfəri matol iətəmi asoli lan.” ");
INSERT INTO tnp_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kəni Iesu təməni=pən kəm iətəmi asoli rəha nimə u məmə, “Nəmə natol nauəniən asoli kəti e nərauiə uə lapɨn, təsəuvɨriən məmə nəkauɨn e ik mɨn nəuvein, mɨne piam mɨn, mɨne nɨmənin mɨn rəham, mɨne nətəmi rəhalah nautə tepət u kəutatɨg təlau lam. Nəmə natol lanəha, kəni məta, ilah mɨn okotauɨn lam məmə nəkuvən motauən itəmah min ilah, kəni ilah okotalpɨn nati nəmol kəm lah. ");
INSERT INTO tnp_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mətəu nian natol nauəniən kəti, onəkəkeikei mauɨn e nanrah mɨn, mɨne nətəmi nɨpətɨ lah nəuvetɨn tərah, mɨne iəhlkɨn rah mɨn, mɨne nətəmi nəhmtɨlah tərah, məmə okəhuva nəkaugɨn ilah. ");
INSERT INTO tnp_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kəni Uhgɨn in otətuati e rəhan nəuvɨriən kəm ik, mətəu-inu ko ilah kəsotalpɨn agɨniən nati nəmol kəm lah. Mətəu e naunun nian, nian nətəm kotəhruahru okotəmiəgəh mɨn, Uhgɨn otətəu ik lan.” ");
INSERT INTO tnp_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kəni ilah kəti əha ikɨn e nauəniən təmətəu nəghatiən əha, kəni təməni=pən kəm Iesu məmə, “Təuvɨr pɨk o iətəmimi u otuvən əpəha e negəu e neai ikɨn Uhgɨn tətarmənɨg lan, kəni mauən e nauəniən asoli rəhan.” ");
INSERT INTO tnp_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mətəu Iesu təməni=pən kəm in məmə, “Nian kəti, suah kəti təmol nauəniən asoli kəti rəhan, kəni mauɨn e nətəmimi tepət məmə okəhuva motauən pəti ilah min. ");
INSERT INTO tnp_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kəni e nian rəha nauəniən, in təmahli=pən rəhan iol əhruin məmə otuvən məni pətɨgəm kəm nətəmimi u təmauɨn rəkɨs e lah. Kəni təmuvən məni=pən kəm lah məmə, ‘Əhuva-tə motauən, inol əpenə-penə rəkɨs e nauəniən.’ ");
INSERT INTO tnp_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Mətəu ilah rəfin kəmotəpəh nuvəniən motəni məmə ko kəsuvaiən. Kəti təmaupən məni kəm in məmə, ‘Pale. Əni=pən-to kəm rəham iətəmi asoli məmə ko iəsuvnəiən mətəu-inu, iəmos əmə nəhmtɨ nɨftəni kəti, kəni iəkəkeikei muvən meruh.’ ");
INSERT INTO tnp_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Kəni kəti mɨn təni məmə, ‘Pale. Əni=pən kəm rəham iətəmi asoli məmə ko iəsuvnəiən mətəu-inu iəmos əmə nəhmtɨ kau ten rəha niuviən kat, kəni iəkəkeikei muvən meh pɨpɨm rəhalah mɨn uək.’ ");
INSERT INTO tnp_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Kəni kəti mɨn təni məmə, ‘Əni=pən kəm rəham iətəmi asoli məmə ko iəsuvnəiən mətəu-inu, kəmit rəhak pətan kəhuva lahuənu u rəueiu.’ ");
INSERT INTO tnp_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Kəni iol əhruin təmuva məni=pən kəm rəhan iətəmi asoli. Kəni iətəmi asoli u nɨkin təmahmə pɨk, kəni təməni=pən kəm rəhan iol əhruin məmə, ‘Uvən uəhai e suaru mɨne ikɨn mɨn nəuvein e taun meruh nanrah mɨn, mɨne nətəmi nɨpətɨ lah mɨn tərah, mɨne nətəmi nəhmtɨ lah tərah, mɨne nətəmi nəhlkɨlah tərah, kəni mit ilah məhuva.’ ");
INSERT INTO tnp_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Kəni in təmol nati rəhan iətəmi asoli təməni, kəni nian in təmɨtəlɨg=pa məni=pən kəm rəhan iətəmi asoli məmə, ‘Iətəmi asoli. Iəu inol rəkɨs natimnati mɨn iətəm ik nəməni məmə iəkol, mətəu nauəniən tepət əhanəh əha ikɨn, kəni nimə təhmen e nətəmimi nəuvein mɨn.’ ");
INSERT INTO tnp_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Kəni iətəmi asoli təməni kəm ioluək məmə, ‘Kəni ko uvən e suaru, mɨne ikɨn mɨn rəfin ihluə e taun, kəni muvən muh nɨkilah məmə ilah okəhuva imə, məmə nimə u rəhak otəkeikei məri. ");
INSERT INTO tnp_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mətəu iəkəni kəm ik məmə nətəmi iəmaupən mauɨn e lah, ko kəsotun askəuvɨniən nauəniən nəuvetɨn rəhak.’” ");
INSERT INTO tnp_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nɨmənin nətəmimi tepət kəmautəhuərisɨg e Iesu e suaru. Kəni nian in təmeirair məni=pən kəm lah məmə, ");
INSERT INTO tnp_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Nəmə suah kəti tolkeikei məmə otuərisɨg lak, in otəkeikei mol iəu iəkəhtul aupən e rəhan nəmiəgəhiən. In otəkeikei molkeikei pɨk agɨn iəu, mapirəkɨs rəhan tatə mɨne mamə mɨne rəhan pətan mɨne nətɨn mɨn mɨne pian mɨn mɨne nəuvɨnɨn mɨn, mɨne in əhruahru mɨn. Kəni nəmə təsoliən lanəha, ko in təsəhmeniən məmə otuva rəhak iətəmimi. ");
INSERT INTO tnp_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kəni nəmə iətəmimi kəti təsələsiən rəhan nɨgi kəluau mɨtəu=pa iəu, ko in təsəhmeniən məmə in otuva mol rəhak iətəmimi lan. ");
INSERT INTO tnp_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Nəmə itəmah kəti tolkeikei məmə tol nimə asoli kəti u təfəməh, in otaupən məharəg meruh rəhan məni rəha natimnati mɨn məmə təhmen uə kəpə. ");
INSERT INTO tnp_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","In tatol lanəha mətəu nəmə in təsaupəniən meruh məni ohni, kəni in otətuəuin mətələhu nəukətɨ nimə əmə, nəmə təsoliən naunun lan, kəni nətəmi rəfin u kəhuva moteruh kəni motaləh lan motəni məmə, ");
INSERT INTO tnp_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Otafu-to. Suah əpəha təmol nimə kəni məsol rəfiniən.’ ");
INSERT INTO tnp_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Kəni nəmə kig kəti, rəhan nətəm kəutəluagɨn ilah ten-tausɨn əmə, mətəu tətətəu məmə kig pɨsɨn kəti mɨn rəhan nətəm kəutəluagɨn ilah tuenti-tausɨn tətuva məmə okuəluagɨn, ko təsuvən uəhaiən mə otəluagɨn. In otaupən məharəg mətəlɨg lan məmə təhrun nehpahuiən, uə kəpə. ");
INSERT INTO tnp_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nəmə təhrun məmə ko təsehpahuiən, in otəkeikei mahli=pən nətəmi nəuvein kəhuvən moteh rəhan mɨn tɨkɨmɨr nian in isəu əhanəh, məmə okotol nəməlinuiən. ");
INSERT INTO tnp_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kəni təhmen əmə, nəmə itəmah kəti in təsol əpenə-penəiən məmə otəhlman e natimnati rəhan məmə tuva muərisɨg lak, ko in təsuvaiən mə rəhak iətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Kəni Iesu təmol naunun e nəghatiən rəhan kəm nətəmimi e suaru məmə, “Sol in nati təuvɨr kəti, mətəu nəmə narfuiən rəhan tɨkə, ko nati tɨkə mə ko tol məmə in otəuvɨr mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kəni ko kəsoliən nati təuvɨr kəti lan, kəni nətəmimi okotəraki əmə lan. Itəmah rəfin matəlgɨtəmah tatɨg, otətəlɨg vivi, kəni motəhrun nəghatiən mɨn u.” ");
INSERT INTO tnp_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","E nian əha, nətəmimi tepət nətəmi kautos məni rəha takɨs, mɨne nətəmimi mɨn tepət u iol təfagə tərah mɨn, kəməhuva məmə okotətəlɨg e Iesu. ");
INSERT INTO tnp_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Kəni Farəsi mɨn mɨne nəgətun mɨn rəha Lou kəməutəni nɨkalɨ Iesu o nətəm iol təfagə tərah mɨn əha, məutəni məmə, “Suah əha, nɨkin tagiən əmə məmə nol təfagə tərah mɨn kəutəhuva ohni, kəni məutauən pəti.” ");
INSERT INTO tnp_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kəni əmeiko Iesu təməni nəghatiən əuhlin kəti məmə, ");
INSERT INTO tnp_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Inu nɨpəhriəniən, uə kəpə. Nəmə itəmah kəti rəhan sipsip ilah uan-hanrɨt, kəni kətiəh təluei, kəni tupəh nainti-nain kəutan ikɨn təpiə ikɨn məutauən, kəni muvən məsal e sipsip u təməluei mətəuarus məkeikei meruh. ");
INSERT INTO tnp_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nian in təmeh, kəni in təməfəri mələs, kəni nɨkin təmagiən. ");
INSERT INTO tnp_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kəni nian in təmiet=pa lahuənu, in otəkeikei mauɨn e in mɨn nəuvein, mɨne nətəmimi mɨn u kəutatɨg ilah min, kəni məni=pən kəm lah məmə, ‘Əhuva. Pəh kotagiən pəti, mətəu-inu iəmeruh mɨn rəhak sipsip u təməluei.’” ");
INSERT INTO tnp_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nian Iesu təməni rəkɨs nəghatiən əuhlin u, kəni məni=pən kəm lah məmə, “Kəni iəu iəkəni kəm təmah məmə, əpəha e neai otəhmen əmə lanəha. Nəmə iol təfagə tərah kəti tɨtəlɨg e rəhan nətəlɨgiən muva o Uhgɨn, kəni nagiəniən asoli əpəha ilɨs e negəu e neai o suah u otepət, mapirəkɨs nagiəniən o nətəmimi nainti-nain u nɨkilah təhti məmə kotəhruahru məsotoliən nati kəti tərah iətəm okotəkeikei mohtəlɨg e nətəlɨgiən rəhalah ohni.” ");
INSERT INTO tnp_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Kəni Iesu təmatɨg məghati mɨn məmə, “?Nəmə pətan kəti rəhan məni ten kəmol e sɨlfə, kəni məruru kətiəh, kəni in otol nak? In otasiə, kəni maiəh məsal vi əha imə mətəuarus meruh. ");
INSERT INTO tnp_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kəni nian in təmeruh məni əha, in otauɨn e in mɨn nəuvein mɨne nətəmimi mɨn u kəutatɨg ilah min, məni məmə, ‘Əhuva pəh kotagiən pəti mətəu-inu iəmeruh rəkɨs rəhak məni əpələ təmɨkə.’” ");
INSERT INTO tnp_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nian Iesu təməni rəkɨs nəghatiən əuhlin u, kəni məni=pən kəm lah məmə, “Iəu iəkolkeikei məmə iəkəni kəm təmah məmə, təhmen əmə mɨn lanəha, nagiəniən asoli e nəhmtɨ nagəlo mɨn əpəha ilɨs e neai, nian iol təfagə tərah kəti tɨtəlɨg e nətəlɨgiən rəhan matuvən o Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kəni Iesu təmətəkeikei mətəni məmə, “Suah kəti, nətɨn iərman keiu. ");
INSERT INTO tnp_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Iətəm təkəku lan təni=pən kəm tɨmɨlau, ‘Tatə. Əuəri nautə mɨn rəham, kəni məfa rəhak u rəueiu.’ Kəni tɨmɨlau təuəri rəhan natimnati kəni məfən kəm lau. ");
INSERT INTO tnp_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Kəni təsuvəhiən, nətɨn iətəm təkəku tos rəhan muvən mətuati lan kəni mos məni lan, kəni miet imalah ikɨn muvən e nɨtəni pɨsɨn kəti mɨn isəu. Kəni mol rəhan məni mərəkɨn-rəkɨn e noliən tərah mɨn əmə. ");
INSERT INTO tnp_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kəni nian rəhan məni təmɨkə rəfin, nəumɨs asoli təman e nɨtəni əha, kəni nəumɨs tɨnatus suah u, nɨgɨn nauəniən tɨnɨkə. ");
INSERT INTO tnp_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kəni təmuvən matol uək kəm suah kəti əha ikɨn, kəni suah u təmahli=pən məmə otuvən mətaugɨn rəhan mɨn nɨpɨkəh mɨn. Nian in təmətaugɨn nɨpɨkəh mɨn əha, ");
INSERT INTO tnp_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","mətəu nəumɨs natus pɨk kəni əmeiko in tɨnatolkeikei məmə otun nauəniən nɨg pɨkəh mɨn. Mətəu iətəmi tɨkə məmə otəfən nati kəm in. ");
INSERT INTO tnp_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Kəni əmeiko nətəlɨgiən təuvɨr kəti tɨnuva ohni, kəni tətəlɨg məmə, ‘Kəsi. Rəueiu əha noluək mɨn rəha tatə, nɨglah nauəniən tepət mapirəkɨs agɨn, mətəu iəu əpə iətatɨg u ikɨnu, otəsuvəhiən iəkɨmɨs e nəumɨs. ");
INSERT INTO tnp_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Oiəkəkeikei miet u ikɨnu mɨtəlɨg=pən o rəhak tatə, kəni məni=pən kəm in məmə, “Tatə. Iəu iəmol təfagə tərah e Uhgɨn mɨne ik. ");
INSERT INTO tnp_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Rəueiu əha iəsəhmeniən məmə onəkauɨn lak məmə nətɨm. Mətəu ol iəu məmə ioluək əmə kəti rəham.” ’ ");
INSERT INTO tnp_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kəni təməhtul maliuək mɨnatuvən məmə oteh rəhan tatə. “Mətəu nian təmətuva əhanəh isəu, rəhan tatə təməsal=pən mafu, kəni nɨkin təmepət ohni, kəni maiu muvən mos nəuegɨn magiən ohni. ");
INSERT INTO tnp_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Kəni nətɨn təni=pən kəm in məmə, ‘Tatə. Iəu iəmol təfagə tərah e Uhgɨn mɨne ik. Rəueiu əha iəsəhmeniən məmə onəkauɨn lak məmə nətɨm.’ ");
INSERT INTO tnp_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Mətəu rəhan tatə taun e rəhan mɨn noluək mɨn məni=pən kəm lah məmə, ‘!Ei! Əhuvən uəhai motos napən u iətəm təuvɨr mapirəkɨs məhuva məhuvən=pən lan kəm in, kəni motos ring motəfən e nəhlmɨn, kəni motos put kəhuva məhuvən=pən e nəhlkɨn, ");
INSERT INTO tnp_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","kəni motos kau iətəm tasisi-asisi məuvɨr kəni motoh, pəh kotol pəti nauəniən asoli rəha nətɨk, ");
INSERT INTO tnp_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","mətəu-inu nətɨk u, in təhmen əmə məmə təmɨmɨs rəkɨs, mətəu rəueiu in tɨnəmiəgəh mɨn. In təməluei, mətəu ineruh mɨn.’ Kəni əmeiko ilah kɨnautol lafet. ");
INSERT INTO tnp_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Kəni e nian əha, nətɨn iətəm tepət in əpəha e nasumiən. Nian təmətuva mɨnuva iuəkɨr o lahuənu, kəni mətəu nətəmimi kautol nəpuən, kəni məutol danɨs. ");
INSERT INTO tnp_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kəni taun e ioluək kəti tuva tətapuəh lan məmə, ‘?Ei, nati nak əha nətəmimi kautol?’ ");
INSERT INTO tnp_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kəni təməni=pən kəm in məmə, ‘Piam təmuva, kəni rəham tatə təmoh pɨlɨk iətəm tasisi mətəu-inu piam tɨnɨtəlɨg=pa, kəni in təsanən əmə.’ ");
INSERT INTO tnp_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Kəni nɨkin təmahmə, kəni in təməni məmə, ‘Ko iəsuvəniən imə.’ Mətəu rəhan tatə təmuva ihluə mətəkeikei kəm in məmə otuvən imə. ");
INSERT INTO tnp_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mətəu təni=pən kəm rəhan tatə məmə, ‘Afu-to. Kəmətuatɨg nu tepət rəkɨs, kəni iatol uək u ikɨnu təhmen=pən əmə məmə rəham kəti ioluək, kəni məsəhtiən nəuiam. ?Mətəu təhro, tatə? Nəməsəfaiən nati əkəku kəti kəm iəu təhmen=pən e nəni, məmə iəkol nauəniən lan itɨmah iəu mɨn nəuvein. ");
INSERT INTO tnp_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mətəu nətɨm əha iətəm təmərəkɨn rəfin rəham mɨn natimnati o nətəouiən nɨpətan mɨn lan rəha suaru, mətəu nian tɨnɨtəlɨg=pa lahuənu, kəni nəkauɨt moh pɨlɨk u tasisi-asisi matol lafet lan rəhan.’ ");
INSERT INTO tnp_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Mətəu rəhan tatə təni=pən məmə, ‘Nətɨk. Nian rəfin kilau min ik kətuatɨg, kəni natimnati rəfin rəhak in rəham. ");
INSERT INTO tnp_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mətəu təhruahru əmə məmə okol lafet u motagiən, mətəu-inu piam u təhmen=pən əmə məmə təmɨmɨs rəkɨs, mətəu rəueiu in tɨnəmiəgəh mɨn. In təmɨkə, mətəu rəueiu kɨnoteh mɨn.’” ");
INSERT INTO tnp_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Kəni Iesu təməni kəm rəhan mɨn nətəmimi məmə, “Suah kəti rəhan nautə tepət, kəni in təmos suah kəti tuva in iətəmi asoli rəha noluək mɨn. Kəni rəhan mɨn nəuvein noluək mɨn kəməhuva motəni=pən nərahiən rəha iətəmi asoli əha kəm iərmənɨg, motəni məmə, ‘Ei, suah kəha tətərəkɨn rəham natimnati.’ ");
INSERT INTO tnp_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kəni təmauɨn e suah kəha məmə tuva təghati kəm in məmə, ‘?Ei, nəghatiən nak u iətətəu kətəni lam? Iəkolkeikei məmə nəkos rəfin nəghatiən mɨn rəha uək rəham muva, mətəu rəueiu əha iəkahli pətɨgəm ik e uək.’ ");
INSERT INTO tnp_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Kəni iətəmi asoli əha təmuvən nɨkin təhti məmə, ‘Kəsi. Rəhak iərmənɨg təni məmə otəraki lak e rəhak uək əha rəueiu. ?Kəni oiəkəhro əha rəueiu? Iəu iəsəhmeniən məmə o iəkuvən mətu nɨftəni o nosiən məni, kəni iəu iəkɨsiai neasiəiən o məni. ");
INSERT INTO tnp_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","!Əuəh! Rəueiu əha inəhrun nati oiəkol pəh nətəmimi okotol iəu iəkuvən imalah ikɨn kəni ko moteh vivi iəu nəmə rəhak iərmənɨg otəraki lak e rəhak uək.’ ");
INSERT INTO tnp_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Kəni ko in təmauɨn rəfin e nətəmimi nətəmi kəmotos məni o iərmənɨg kəhuva kətiəh kətiəh. Kəni in təməni=pən kəm iətəm təmaupən muva məmə, ‘?Ik nəmos nak?’ ");
INSERT INTO tnp_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Kəni suah kəha təni məmə, ‘Iəmos dɨrəm rəha oiel rəha nauəhiən ilah uan-hanrɨt.’ Kəni iətəmimi asoli təməni=pən kəm in məmə, ‘Inu mə nauəuə rəha kauɨn rəham. Əharəg uəhai, kəni mətei fifti dɨrəm əmə e rəham nauəuə.’ ");
INSERT INTO tnp_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Kəni ko məni=pən kəm suah kəti mɨn məmə, ‘?Ik nəmos nak?’ Mətəu in təni məmə, ‘Iəmos uan tausɨn pak wit.’ Kəni iətəmi asoli təni məmə, ‘Os nauəuə rəha kauɨn rəham, kəni mətei=pən əmə eit-hanrɨt pak wit.’ ");
INSERT INTO tnp_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Kəni ko, iərmənɨg rəha iətəmi asoli əha iətəm in təmol tərah lan, təməni-vivi in o rəhan neiuəiən məmə in oteh vivi aru in. “Nati u tətəgətun məmə nətəmimi rəha nɨftəni, ilah kotəhrun vivi noliən mɨn rəha nɨftəni nian ilah kəutəghati kəm lah mɨn, tapirəkɨs nətəmimi rəha nəhagəhagiən. ");
INSERT INTO tnp_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Kəni iətəni kəm təmah məmə, onəkotasiru vivi e nətəmimi e məni rəha nɨftəni məmə ilah okəhuva rəhatəmah niəli mɨn. Kəni nian məni rəha nɨftəni u otɨkə, kəni Uhgɨn otos itəmah muvən əpəha e negəu e neai iətəm ko təsɨkəiən. ");
INSERT INTO tnp_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Nəmə suah kəti in tətəsal vivi o nati əkəku kəti, kəni in otəhrun nəsaliən o nati asoli. Kəni nəmə suah kəti in tatol noliən tərah e nati əkəku kəti, kəni in otol noliən tərah e nati asoli. ");
INSERT INTO tnp_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","?Kəni tol lanəha, nəmə itəmah nəsotəsal viviən o məni rəha nɨftəni u, kəni pəh otegəhan e təmah məmə nəkotos nati iətəm təuvɨr pəhriən, u natimnati rəha Uhgɨn? ");
INSERT INTO tnp_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kəni nəmə itəmah nəsotəsal viviən e natimnati rəha suah kəti mɨn, kəni nɨki təmah təsəhtiən məmə okəfɨnə mɨn kəm təmah məmə rəhatəmah əhruahru natimnati mətəu-inu, kateruh məmə ko nəsotəsal viviən mɨn natimnati mɨn əha. ");
INSERT INTO tnp_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ko iətəmimi kəti təsuvaiən məmə in ioluək rəha iətəmi asoli mil keiu. Nəmə tol lanəha, in otolkeikei kəti matol nəuian, kəni məməki e kəti kəni məsoliən nəuian. Kəni ko nəsoliən ioluək rəha Uhgɨn mɨne məni e nian kətiəh.” ");
INSERT INTO tnp_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farəsi mɨn kotolkeikei pɨk məni, kəni nian kəmotətəu nəghatiən mɨn u, kəni kəmotaləh əuvsan e Iesu. ");
INSERT INTO tnp_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mətəu in təməni kəm lah məmə, “Itəmah nautol noliən mɨn məmə nətəmimi kotəni məmə itəmah nəkotəhruahru. Mətəu Uhgɨn təhrun nɨkitəmah məmə nəkotərah. Iətəni lanu mətəu-inu nati nak u nətəmimi kəutos məmə in nati agɨn, mətəu e nəhmtɨ Uhgɨn in nati əpnapɨn əmə.” ");
INSERT INTO tnp_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Kəni in təmətəkeikei mətəni məmə, “Kəmətəni pətɨgəm Lou mɨne nəghatiən rəha iəni mɨn rəha Uhgɨn mətəuarus=pa Jon Bəptais, kəni ko uərisɨg lan, kətəni pətɨgəm nanusiən təuvɨr rəha Narmənɨgiən Rəha Uhgɨn, kəni nətəmimi rəfin kəutalkut pɨk məmə okəhuvən motatɨg lan. ");
INSERT INTO tnp_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mətəu kəsəniən məmə uək rəha Lou mɨne nəsanəniən rəhan, təmol naunun. Nəghatiən rəfin rəhan kəutatɨg, iətəm tepət mɨn mətəuarus=pən iətəm təkəku agɨn. Lou otətatɨg mapirəkɨs neai mɨne nɨftəni. ");
INSERT INTO tnp_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Kəni təhmen=pən əmə lanəha: nəmə iətəmi kəti tatol tifos mətəpəh rəhan pətan, kəni matit pətan pɨsɨn kəti mɨn mətuatɨg, in tatol təfagə tərah. Kəni nəmə iətəmi kəti tatit pətan kəti iətəm rəhan iərman təməpəh kəni ilau mətuatɨg, in tatol təfagə tərah mətəu-inu in tətakləh e pətan rəha iətəmi pɨsɨn kəti.” ");
INSERT INTO tnp_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Kəni Iesu təməni məmə, “Iətəmi kəti rəhan nautə tepət, kəni in tatuvən e napən təuvɨr kəmoh e al u nəugɨ naris in nəhmtɨn tiəkɨs, kəni nian rəfin in tatun əmə nauəniən təuvɨr mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Kəni ianrah kəti, nərgɨn u Lasɨrɨs, nɨməgɨm təmol rəfin nɨpətɨn mɨn. Kəni kəmələs kan əpəha e namtɨhluə rəha suah u. ");
INSERT INTO tnp_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","In tolkeikei pɨk məmə otatun nɨpɨspɨsɨ nauəniən mɨn u kəutəmei e tepɨl rəha iətəmi asoli əha. Kəni nati tərah mɨn kəti, kuri mɨn kəutəhuva məutəpah-əpah nɨməgɨm mɨn rəhan. ");
INSERT INTO tnp_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Kəni ianrah əha təmɨmɨs, kəni nagelo mɨn kəmotos in məhuvən əpəha e nɨkalɨ Epraham, ima nəuvɨriən ikɨn. Kəni iətəmi u rəhan nautə tepət, in mɨn təmɨmɨs kəni kɨtənɨm. ");
INSERT INTO tnp_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kəni in təmuvən əpəha e nɨgəm asoli, kəni tətətəu naməhiən asoli, kəni nian təməsal-pəri, mafu Epraham əpəha isəu. Kəni Lasɨrɨs əpəha e nɨkalɨn. ");
INSERT INTO tnp_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kəni təmauɨn əfəməh məmə, ‘!Əui, Tatə Epraham! Asiru lak. Əni=pən kəm Lasɨrɨs məmə otəfən nəuan nəhlmɨn e nəhu kəni mos muva mek namɨk lan məmə otətəpu, mətəu iətətəu nahməiən asoli e nɨgəm u ikɨnu rəueiu.’ ");
INSERT INTO tnp_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Mətəu Epraham təni məmə, ‘Nətɨk, nɨkim təhti-to rəham nəmiəgəhiən aupən. Ik nəmatos natimnati təuvɨr mɨn rəham tepət, mətəu Lasɨrɨs təmatətəu nahməiən tepət e nɨpətɨn. Mətəu rəueiu əha, in tətətəu təuvɨr u ikɨnu, kəni ik nətətəu nahməiən tepət e nɨpətɨm. ");
INSERT INTO tnp_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kəni nati kəti mɨn. E nəlugɨn e tah, nɨmɨl asoli tətəuəri itah, ik ko, kəni itɨmah u. Nəmə itɨmah kəti tolkeikei məmə otuvnə meh ik, mətəu ko təsuvəniən. Kəni nəmə itəmah kəti tolkeikei məmə otuva meh itɨmah mətəu ko təsuvaiən.’ ");
INSERT INTO tnp_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Kəni iətəm rəhan nautə tepət təməni məmə, ‘Tatə. Əui, kəsi. Ahli=pən Lasɨrɨs tuvən e nimə rəha tatə rəhak, ");
INSERT INTO tnp_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","mətəu-inu piak faif əha ikɨn. Təuvɨr məmə in otuvən məghati mem əskasɨk ilah məmə okotətəu ilah məmə okəsəhuvaiən u ikɨnu iətəm iətətəu nahməiən asoli agɨn ikɨn,’ ");
INSERT INTO tnp_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Mətəu Epraham təni məmə, ‘Kəpə. Nəghatiən rəha Mosɨs mɨne iəni mɨn rəha Uhgɨn tətatɨg. Pəh piam mɨn okotətəu nəghatiən mɨn əha.’ ");
INSERT INTO tnp_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Kəni iətəmi rəhan nautə tepət təməni məmə, ‘Kəpə, Tatə Epraham. Təsəhmeniən. Mətəu nəmə iətəmi kəti otəmiəgəh mɨn e nɨmɨsiən otuvən məghati kəm lah, kəni nɨpəhriəniən, ilah okotəuhlin rəhalah nətəlɨgiən kəni motəpəh təfagə tərah mɨn rəhalah.’ ");
INSERT INTO tnp_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Kəni Epraham təni məmə, ‘Nəmə kəsotətəlɨgiən e nəghatiən rəha Mosɨs mɨne iəni mɨn rəha Uhgɨn, kəni nati əpnapɨn nəmə iətəmi kəti təmiəgəh pau e nɨmɨsiən kəni muvən məghati kəm lah, mətəu ko kəsotəniən nɨpəhriəniən lan.’” ");
INSERT INTO tnp_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Kəni Iesu təməni kəm rəhan mɨn nətəmimi məmə, “Pəhriən, natimnati mɨn u kautiuvi=pən iətəmi tətəmei=pən e təfagə tərah, okəhuva. !Mətəu nərahiən asoli o iətəmi əha u tətəfən-əfən kəm nətəmimi, uə in suaru rəha nəfən-əfəniən! ");
INSERT INTO tnp_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mətəu nəmə iətəmi kəti tiuvi=pən rəhak kəti iətəmimi u təhmen e suakəku, məmə otol təfagə tərah, kəni suah kəha, Uhgɨn otol nalpɨniən asoli kəm in. Kəni nalpɨniən əha otəskasɨk tapirəkɨs nəmə katu=pən kəpiel kəti e nentəui, kəni kəraki=pən əpəha itəhi lokamnɨm. ");
INSERT INTO tnp_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kəni tol lanəha, əutətəu mauteruh vi rəhatəmah nəmiəgəhiən. “Nəmə piam tatol təfagə tərah kəm ik, kəni əni=pən rəhan noliən tərah e nəhmtɨn, kəni nəmə tətəuhlin rəhan nətəlɨgiən, kəni alu e rəhan noliən tərah məsosiən tatɨg e nɨkim. ");
INSERT INTO tnp_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kəni nati əpnapɨn nəmə in tatol təfagə tərah lam mau səpɨn e nian kətiəh, kəni muva mau səpɨn, kəni məni=pən kəm ik məmə, ‘Kəsi, iəmol təfagə tərah lam. Iatɨtəlɨg e nətəlɨgiən rəhak kəni mətəpəh təfagə tərah,’ kəni ik onəkəkeikei məsalpɨniən malu e rəhan noliən rah mɨn, kəni məsosiən tatɨg e nɨkim.” ");
INSERT INTO tnp_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Kəni aposɨl mɨn kəmotətapuəh o iərmənɨg məmə, “Ol rəhatɨmah nəhatətəiən təskasɨk təhmɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Kəni Iərmənɨg təməni məmə, “Nati əpnapɨn nəmə rəhatəmah nəhatətəiən natiəkəku agɨn pau təhmen e nɨpɨspɨsɨ nɨpəkɨl, kəni nəkotəhrun nəniən kəm nɨgi u nokɨn təfəməh məmə, ‘Euvi aru ik, kəni muvən miuvɨg=pən itəhi,’ kəni nɨgi u otol nəuiatəmah. ");
INSERT INTO tnp_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Otəni-to. ?Nəmə iətəmi kəti rəhan ioluək tətasum, uə in tateh rəhan mɨn sipsip mɨn, nian in tuva lahuənu, nɨkitəmah təhti məmə, iətəmi asoli otəni=pən kəm in məmə, ‘!Ei! Va uəhai məharəg mun nauəniən əha’? !Kəpə! ");
INSERT INTO tnp_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","In otəni=pən kəm rəhan ioluək məmə, ‘Uvən mol nəgək nauəniən, kəni ko muvən muvən e rəham napən təuvɨr, kəni məfa nəgək nauəniən mɨne nɨmək nəmnɨmiən. Nian nəkol rəfin rəham uək, ko nəkəhrun nuniən nauəniən kəni mɨne nəmnɨmiən.’ ");
INSERT INTO tnp_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","?Kəni nɨkitəmah təhti məmə iətəmi asoli, in otəni-vivi rəhan ioluək o uək asoli rəhan iətəm in otəkeikei mol? !Kəpə! ");
INSERT INTO tnp_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kəni itəmah ko, nəkotəhmen əmə e noluək mɨn rəha Uhgɨn. Nian nəmotol rəkɨs natimnati rəfin iətəm Uhgɨn təməni məmə onəkotəkeikei motol, onəkotəni məmə, ‘Itɨmah noluək mɨn əmə. Noliən rəhatəmah təsəhmeniən o nəni-viviən. Itɨmah iəmotol əmə uək u itɨmah oiəkotəkeikei mautol.’” ");
INSERT INTO tnp_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nian Iesu təmətaliuək matuvən Jerusɨləm, in təmətaliuək matuvən=pən e nəlugɨ nɨtəni mil u Səmeriə mɨne Kaləli. ");
INSERT INTO tnp_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Kəni nian in təmiet=pən lahuənu kəti, nətəmimi ten iətəm nɨmɨsiən u leprosi təmol ilah kəməhuva motəhtul isəu nəuvetɨn, ");
INSERT INTO tnp_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","kəni motauɨn lan məmə, “!Iesu, Iətəmi asoli, asiru e tɨmah!” ");
INSERT INTO tnp_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Kəni nian in təmeh ilah, təni məmə, “Onəkəhuvən o pris məmə in oteh nɨpətɨtəmah.” Kəni nian ilah kəmautaliuək əhanəh e suaru, kəni motəuvɨr, nɨmɨsiən təmɨkə. ");
INSERT INTO tnp_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kəni ilah kəti təmeruh məmə leprosi rəhan tɨnɨkə, kəni in təməlali mɨtəlɨg=pən o Iesu, mətəni əfəməh məmə, “!Iatəni-vivi Uhgɨn! !Iatəni-vivi Uhgɨn!” ");
INSERT INTO tnp_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kəni in təmeiuaiu e nəhlkɨ Iesu mɨsin nəulɨn nɨpənəgɨn tatek nɨftəni, kəni mətəni kəm Iesu məmə nɨkin tətagiən məmə in təmol vivi rəhan nɨmɨsiən. Kəni suah u in iətəm Səmeriə. ");
INSERT INTO tnp_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kəni Iesu təməni məmə, “?Iəmol vivi nətəmi ten kəni mos rəkɨs rəhalah nɨmɨsiən, uə kəpə? ?Mətəu nain mɨn, ilah iə? ");
INSERT INTO tnp_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","?Suah u in iapɨspɨs əmə, mətəu in pɨsɨn əmə təmɨtəlɨg=pa mətəni-vivi Uhgɨn?” ");
INSERT INTO tnp_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kəni Iesu təməni kəm suah u məmə, “Əhtul maliuək matuvən. Rəham nəhatətəiən təmol vivi ik.” ");
INSERT INTO tnp_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nian kəti, Farəsi mɨn kəmotətapuəh o Iesu məmə, “?Onəhgɨn Narmənɨgiən Rəha Uhgɨn otuva?” Kəni in təməni=pən kəm lah məmə, “Narmənɨgiən Rəha Uhgɨn otəsuvaiən məmə nətəmimi okoteruh e nəhmtɨ lah. ");
INSERT INTO tnp_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kəni iətəmimi tɨkə mə otəni məmə, ‘Əsal=pa meh, in uəha,’ uə ‘!Əsal=pən meh, in əpəha!’ mətəu-inu Narmənɨgiən Rəha Uhgɨn tɨnuva rəkɨs mətatɨg e nɨkitəmah.” ");
INSERT INTO tnp_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kəni Iesu təni kəm rəhan mɨn nətəmimi məmə, “Nian mɨn kəutəhuva iətəm itəmah onəkotolkeikei məmə onəkoteh nian mɨn rəha Nətɨ Iətəmimi, mətəu ko nəsotehiən. ");
INSERT INTO tnp_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Kəni nətəmimi okotəni kəm təmah məmə, ‘!Əsal=pa, in uəha!’ uə ‘!Əsal=pən, in əpəha!’ Mətəu onəsəhuvəniən motohtəu=pən ilah, ");
INSERT INTO tnp_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","mətəu-inu e nian iəu Nətɨ Iətəmimi oiəkuva lan, in otəhmen e noraipiən iətəm tətoraip kəni mətasiəgəpɨn neai e nɨkalɨn kəti mətəuarus=pən nɨkalɨn kəti mɨn, kəni nətəmimi rəfin okoteruh motəhrun. ");
INSERT INTO tnp_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mətəu aupən, iəu iəkəkeikei mətəu naməhiən tepət, kəni nətəmi kəutatɨg rəueiu, ilah okotəuhlin nəmtahlah mətəpəh iəu. ");
INSERT INTO tnp_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“E nian iəu, Nətɨ Iətəmimi, iəkuva lan, otəhmen=pən əmə e nian rəha Noa aupən, iətəm nətəmimi kəmotol natimnati mɨn məsotəhruniən məmə Uhgɨn otol nati kəti lan məsotol əpenə-penəiən. ");
INSERT INTO tnp_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","E nian əha, nətəmimi kəməutauən, məutəmnɨm, mautol marɨt, inəha natimnati mɨn rəfin kəmautol e nəmiəgəhiən rəhalah, motətəuarus=pa nian iətəm Noa tɨnuvən e nɨpəgnəua negəu asoli rəhan. Kəni nuhuən təməfuv naruəh asoli təmuva kəni maiu melərmin rəfin nətəmimi iətəm kəməsəhuvəniən e negəu. ");
INSERT INTO tnp_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“In təhmen=pən əmə e nian rəha suah kəha Lot. Nətəmimi kəmotauən, məutəmnɨm, məutos nəhmtɨ natimnati mɨn, məutasum, mautuvləkɨn nimə mɨn, inəha natimnati rəfin kəmautol e nəmiəgəhiən rəhalah. ");
INSERT INTO tnp_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Mətəu e nian iətəm Lot təmiet lan e taun əha Sotəm, kəni nɨgəm mɨne kəpiel mɨn kəmohuəu mautsɨpəri e neai motohamu ilah rəfin əpəha e taun. ");
INSERT INTO tnp_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Kəni otəhmen əmə e nian iəu Nətɨ Iətəmimi oiəkuva mɨn lan kəni, Uhgɨn otol əpu iəu kəm nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","E nian əha, nəmə suah kəti tətəharəg ihluə e rəhan nimə, pəh in tagɨm məsuvən mɨniən imə məmə in otos rəhan natimnati, kəni nəmə suah kəti in əpəha e nasumiən, pəh in otagɨm məsuva mɨniən lahuənu. ");
INSERT INTO tnp_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","!Onəsotaluiən e pətauəhli rəha Lot! ");
INSERT INTO tnp_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","In təmolkeikei məmə otaskəlɨm rəhan nəmiəgəhiən e nəhue nɨftəni u məsɨtəupaiən iəu, in otəsosiən nəmiəgəhiən itulɨn. Mətəu iətəmimi u tətəpəh natimnati rəha nəmiəgəhiən e nəhue nɨftəni u, kəni mətətəu=pa iəu, in otos nəmiəgəhiən itulɨn. ");
INSERT INTO tnp_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Iətəni kəm təmah məmə, e nian əha lapɨn, iətəmimi keiu okətuapɨli e pet kətiəh, kəni okos rəkɨs kəti, kəpəh kəti. ");
INSERT INTO tnp_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Pətan keiu kətuəharəg pəti matuol nauəniən, kəni okos kətiəh, kəpəh kəti.” ");
INSERT INTO tnp_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Kəni rəhan noluək mɨn kəmotəni=pən kəm in məmə, “?Iərmənɨg, onəkuva iə?” Kəni in təməni=pən kəm lah məmə, “Onəkotəhrun əmə. Təhmen e nian nati miəgəh kəti təmɨmɨs mətəməhli, kəni kuveriə mɨn koteiuaiu mauton pəti.” ");
INSERT INTO tnp_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Kəni Iesu təməni nəghatiən əuhlin kəm lah mətəgətun ilah lan məmə okotəkeikei məutəfaki nian rəfin məsotəpəhiən, məsotoliən məmə nɨkilah otəsəmeiən. ");
INSERT INTO tnp_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","In təməni məmə, “Lahuənu kəti, iəni kəti əha ikɨn rəha nələhuiən nəghatiən mɨn. Kəni təsɨsiaiən Uhgɨn, kəni təsɨsiai mɨniən nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kəni e lahuənu əha, pətalɨmɨs kəti əha ikɨn, kəni nian rəfin tətuva materuh iəni u mətəni=pən kəm in məmə, ‘Əui. Kəsi, onəkasiru lak məghati o nələhu əhruahruiən nərahiən rəha tɨkɨmɨr rəhak tatol kəm iəu.’ ");
INSERT INTO tnp_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Mətəu iəni u in təməsuvəniən, kəni mos nian əfəməh məmə otagət mol vi nərahiən əha rəha pətalɨmɨs. Mətəu pətan əha təmətətapuəh o suah kəha nian rəfin matuvən matuvən, kəni iəni nɨkin təni məmə, ‘Nati əpnapɨn iəsɨsiaiən Uhgɨn, kəni məsɨsiai mɨniən nətəmimi, ");
INSERT INTO tnp_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","mətəu pətan əha tətəni mətəni nati kətiəh mɨnatol mɨrə iəu o rəhan nəghatiən, matol matol. Pəh iəkəkeikei muvən məni-vivi rəhan nərahiən kəni mələhu nəuvɨriən. Nəmə iəkəpəh, kəni in otətuva ohniəu matol matol rəueiu kəni iəkəpəou lan.’” ");
INSERT INTO tnp_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kəni nian Iərmənɨg təməni rəkɨs nəghatiən əuhlin əha, kəni məni məmə, “Otətəlɨg-to e nəghatiən rəha iəni əpəha iətəm in tərah təhmɨn. ");
INSERT INTO tnp_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","?Mətəu təhro e Uhgɨn? In təmɨtəpɨn rəhan mɨn nətəmimi, kəni ilah kəutasək=pən kəm in nian rəfin e nərauiə mɨne lapɨn mɨn rəfin. ?Kəni nɨkitəmah təhti məmə in otəni=pən kəm lah məmə, ‘Pəh pɨpɨm’? Kəpə. ?Kəni nɨkitəmah təhti məmə in ko təsasiruiən uəhai əmə e rəhan mɨn? Kəpə. ");
INSERT INTO tnp_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Iətəni=pɨnə kəm təmah məmə nɨpəhriəniən, in otasiru uəhai əmə e rəhan mɨn, kəni mol vivi rəhalah nərahiən. ?Mətəu nian iəu Nətɨ Iətəmimi oiəkɨtəlɨg=pa mɨn lan e nɨftəni, oiəkeh nətəmimi nəuvein nətəm kəutəhatətə e Uhgɨn, uə kəpə?” ");
INSERT INTO tnp_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Kəni Iesu təməni nəghatiən əuhlin kəti kəm nətəmimi nəuvein nətəm nɨkilah təhti məmə ilah kotəhruahru motapirəkɨs nətəmimi rəfin, kəni motəsal iahu e lah. ");
INSERT INTO tnp_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","In təməni məmə, “Suah mil keiu kəmian əpəha e Nimə Rəha Uhgɨn məmə kuəfaki. Kəti, in Farəsi, kəni kəti in iətəmi tatos məni rəha takɨs. ");
INSERT INTO tnp_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Kəni Farəsi təməhtul məmə tətəfaki, kəni in mətəni aru əmə in, mətəni məmə, ‘Uhgɨn, iətəni-vivi ik mətəu-inu nəmol məmə iəkol iətəpɨsɨn lak, mə inəha nətəmimi kotolkeikei pɨk məni kəni məuteiuə məmə kotakləh lan, kəni məutol tərah, kəni məutakləh e pətan rəha iətəpɨsɨn. Mətəu iəu iəsoliən kəmə ilah. Kəni iəu mɨn iəsoliən kəmə suah kəha iətəm tatos məni rəha takɨs. ");
INSERT INTO tnp_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nian keiu e nəfakiən kətiəh, iətətuakəm mətəpəh nauəniən mətəfaki kəm ik. Kəni nəmə iəkos natimnati ten, iətos rəkɨs kətiəh mətəfɨnə kəm ik.’ ");
INSERT INTO tnp_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Mətəu suah kəha, iətəmi tatos məni rəha takɨs, in təməhtul=pən isəu, kəni mətaulɨs məsəsal pəriən e negəu e neai kəni məfaki. Kəni nɨkin tɨtəgɨt mətasək mətəhti mankɨlahan mətəni məmə, ‘Uhgɨn, iəu iətəmi tərah. !Nɨkim teiuaiu ohniəu!’” ");
INSERT INTO tnp_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kəni Iesu təni məmə, “Iətəni kəm təmah. Nian suah mil u okiatəlɨg=pən lahuənu, iətəmi rəha takɨs, in otəhruahru e nəhmtɨ Uhgɨn. Mətəu Farəsi, in təsoliən lanəha, mətəu-inu iətəmi tətəfəri aru in, Uhgɨn otosiahu, mətəu iətəmi tatosiahu aru in, Uhgɨn otəfəri.” ");
INSERT INTO tnp_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kəni nətəmimi nəuvein kəmotos rəhalah mɨn iəpəou mətmətɨg mɨn məhuva kəm Iesu məmə in otələhu=pən nəhlmɨn e lah kəni məfaki o lah. Mətəu nian rəhan mɨn nətəmimi kəmoteh ilah, kəni motəniəhu ilah. ");
INSERT INTO tnp_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mətəu Iesu təmauɨn e iəpəou mɨn əha mə okəhuva ohni, kəni məni=pən kəm rəhan mɨn natətəlɨg məmə, “Sotəniəhuiən iəpəou mɨn məmə okəsəhuvaiən ohniəu, pəh ilah okəhuva ohniəu, mətəu-inu Narmənɨgiən Rəha Uhgɨn in rəha nətəmimi mɨn u kotəhmen e iəpəou mɨn u. ");
INSERT INTO tnp_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Iatəni pəhriən kəm təmah məmə, nəmə iətəmi kəti təsolkeikeiən məmə oteiuaiu məhmen e kəlkələh mɨn u kəti mupəh Uhgɨn tarmənɨg lan, ko in təsatɨg ahgəliən Narmənɨgiən Rəha Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kəni iətəmi asoli kəti təməni=pən kəm Iesu məmə, “Iəgətun, ik iətəmi təuvɨr. ?Oiəkəhro mos nəmiəgəhiən itulɨn?” ");
INSERT INTO tnp_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Kəni Iesu təməni=pən kəm in məmə, “?Təhro nətauɨn lak məmə iəu iətəmi təuvɨr? Suah kəti tɨkə in iətəmi təuvɨr, mətəu Uhgɨn əmə in təuvɨr. ");
INSERT INTO tnp_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ik nəkəhrun nəghatiən mɨn e Lou rəha Uhgɨn tətəni məmə, ‘Sakləhiən e pətan rəha iətəpɨsɨn, məsohamuiən iətəmimi, məsakləhiən e natimnati, məseiuəiən e kot, mɨsiai rəham tatə mɨne mamə.’” ");
INSERT INTO tnp_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Kəni suah u təməni məmə, “Natimnati mɨn rəfin u, iəmol rəfin ilah, nian iəmətəkəku mətəuarus=pa u rəueiu.” ");
INSERT INTO tnp_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nian Iesu təmətəu nəghatiən əha, kəni təni=pən kəm in məmə, “Nati kəti mɨn əmə əha ikɨn onəkol. Uvən mol nətəmimi kotos nəhmtɨ rəham nautə rəfin agɨn, kəni məfən məni lan kəm nanrah mɨn. Kəni ik onəkos nəuvɨriən tepət əpəha e negəu e neai. Kəni muva muərisɨg lak, mol məmə rəhak iətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Mətəu nian təmətəu nəghatiən mɨn əha, nɨkin təməpəou mətəu inko rəhan nautə tepət. ");
INSERT INTO tnp_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Kəni nian Iesu təməsal=pən meruh məmə nɨkin nəpəou, kəni təni məmə, “!Ei, tiəkɨs agɨn o iətəmi rəhan nautə tepət məmə in otuva matɨg ahgəl e Narmənɨgiən Rəha Uhgɨn! ");
INSERT INTO tnp_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tiəkɨs məmə kau otuvən=pən e nɨpəg nitɨl, mətəu tiəkɨs pɨk məmə iətəmi rəhan nautə tepət otuva matɨg ahgəl e Narmənɨgiən Rəha Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Kəni nətəmimi u kəutətəu nəghatiən əha kəmotəni məmə, “?Nəmə tiəkɨs o iətəmi rəhan nautə tepət, kəni pəh əha in təhmen məmə otos nəmiəgəhiən əha?” ");
INSERT INTO tnp_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Mətəu in təməni məmə, “Nati nak u tiəkɨs pɨk agɨn, mə ko nətəmimi kəsotoliən, mətəu Uhgɨn in təhrun noliən.” ");
INSERT INTO tnp_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kəni Pitə təməni=pən kəm in məmə, “?Mətəu təhro e tɨmah? Iəmotəpəh rəfin rəhatɨmah natimnati kəni məhuva məmə iəkəhuərisɨg lam.” ");
INSERT INTO tnp_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Kəni Iesu təməni=pən kəm lah məmə, “Iətəni pəhriən kəm təmah məmə, iətəmi təməpəh rəhan nimə, uə rəhan pətan, uə pian mɨn, uə rəhan tatə mɨne mamə, uə rəhan kəlkələh mɨn mətəu-inu in tatɨtəu=pən Narmənɨgiən Rəha Uhgɨn, ");
INSERT INTO tnp_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kəni e nəhue nɨftəni u, in otos natimnati tepət tapirəkɨs ilah mɨn u təməpəh ilah, kəni uərisɨg, in otos mɨn nəmiəgəhiən itulɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Kəni Iesu təməni=pən kəm rəhan tueləf natətəlɨg mɨn məmə okohiet e nɨmənin nətəmimi məhuva kətiəh motuhapumɨn ilah mɨn, kəni təməni=pən kəm lah məmə, “Otətəlɨg-to. Rəueiu kəhuvən əpəha ilɨs Jerusɨləm, kəni natimnati mɨn iətəm iəni mɨn rəha Uhgɨn aupən kəmotəni lak, Nətɨ Iətəmimi, e nauəuə mɨn rəhalah, ilah okəhuva motol nɨpəhriəniən. ");
INSERT INTO tnp_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nətəmimi okotegəhan=pən lak e nəhlmɨ Nanihluə mɨn, kəni nətəmimi okotəghati motaləh əuvsan lak, motol=pən əmə iəu, motagəh əpis nəhmtək, ");
INSERT INTO tnp_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","kəni okalis iəu, kəni kohamu iəu. Mətəu e nian tatol kɨsɨl lan, oiəkəmiəgəh mɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Mətəu kəsotəhruniən rəhan nəghatiən mɨn. In təhmen=pən e nəghatiən iətəm nɨpətɨn tətəhluaig, kəni kəsotəhruniən nɨpətɨ nəghatiən mɨn əha. ");
INSERT INTO tnp_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nian Iesu təmuva iuəkɨr o taun əha Jeriko, suah kəti in tətəharəg e nɨkalɨ suaru nəhmtɨn tərah. Nian rəfin in təteasiə e məni o nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kəni nian iətəmi əha nəhmtɨn tərah təmətəu məmə nətəmimi tepət kəutaliuək e suaru, kəni in təmətapuəh məmə, “?Nati nak əha katol?” ");
INSERT INTO tnp_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nətəmimi kəmotəni=pən kəm in məmə, “Iesu əpəha, iətəm Nasərɨt, tətaliuək e suaru.” ");
INSERT INTO tnp_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kəni təmagət əfəməh məmə, “!Iesu! !Mipɨ kig Tefɨt! !Asiru lak!” ");
INSERT INTO tnp_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Kəni nətəmimi mɨn u kəutaliuək məutaupən e Iesu, kəmotagət lan, motəni məmə, “!Sagətiən!” Mətəu in təmagət əfəməh təhmɨn məmə, “!Mipɨ kig Tefɨt! !Asəkəhruin iəu masiru lak!” ");
INSERT INTO tnp_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kəni Iesu təməhtul təməni=pən kəm lah məmə okotit məhuva. Kəni nian kəmotit məhuva iuəkɨr, Iesu tətapuəh ohni məmə, ");
INSERT INTO tnp_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“?Nəkolkeikei məmə iəkol nak kəm ik?” Kəni in təməni məmə, “Iərmənɨg, iəkolkeikei məmə oiəkair meruh nati.” ");
INSERT INTO tnp_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kəni Iesu təməni=pən kəm in məmə, “Air meruh nati. Rəham nəhatətəiən tɨnol vivi ik.” ");
INSERT INTO tnp_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Əmeiko rəueiu agɨn mɨn, təmair mɨnateh nati, kəni mɨnatuərisɨg e Iesu, mətəni-vivi Uhgɨn. Kəni nian nətəmimi rəfin kəmoteruh nati əha, ilah kəməutəni-vivi Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Kəni Iesu təmaliuək muvən imə e taun u Jeriko matuvən məmə otiet=pən e nɨkalɨn nəuvetɨn mɨn kəti. ");
INSERT INTO tnp_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Kəni e taun əha, suah kəti əha ikɨn, nərgɨn u Sakiəs. In iətəmi asoli kəti rəha nətəm kautos məni rəha takɨs, kəni in rəhan nautə tepət. ");
INSERT INTO tnp_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Kəni in tolkeikei məmə oteh-to məmə Iesu in pəh, mətəu təruru neruhiən mətəu in təkuəkɨr, nətəmimi kəutəhtul pəsɨg lan. ");
INSERT INTO tnp_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kəni in təmaiu aupən muvən məri e nɨgi kəti, nərgɨn u sikəmo, məmə otəhrun neruhiən Iesu nian in otuva=pa in ikɨn. ");
INSERT INTO tnp_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kəni nian Iesu təmuva əhruahru əha ikɨn, təməsal-pəri meruh, kəni məni=pən kəm in məmə, “Sakiəs. Eiuaiu uəhai, mətəu rəueiu ko iəkəkeikei muvən mauən əpəha e rəham nimə.” ");
INSERT INTO tnp_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kəni Sakiəs təmeiuaiu uəhai əmə, kəni mit Iesu mian əpəha iman ikɨn imə, kəni nɨkin təmagiən. ");
INSERT INTO tnp_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mətəu nian nətəmimi kəmoteruh natimnati mɨn əha, kəni kəutasiuən kəm lah mɨn o noliən əha məutəni nɨkalɨ Iesu məmə, “Suah əha tatuvən e nimə rəha iol təfagə tərah.” ");
INSERT INTO tnp_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kəni nian kɨnəhuvən rəkɨs e nɨpəgnəua nimə rəha Sakiəs, in təhtul məni kəm Iərmənɨg məmə, “Iərmənɨg, ətəlɨg-to. Oiəkəuəri rəhak natimnati mol nəhmtɨn keiu, kəti rəhak, kəni kəti iəkəfən kəm nanrah mɨn. Kəni natimnati iətəm iəmakləh lan o suah kəti, oiəkalpɨn mau kuvət.” ");
INSERT INTO tnp_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Kəni Iesu təni=pən kəm in məmə, “Rəueiu Uhgɨn tɨnosmiəgəh ik mɨne rəham mɨn, mətəu-inu ik mɨn, nəməhatətə e Uhgɨn, kəni ik nəuanɨləuɨs pəhriən kəti rəha Epraham. ");
INSERT INTO tnp_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kəni iəu, Nətɨ Iətəmimi, iəmuva məmə iəkəsal e nətəmimi iətəm kəmotəluei, kəni mosmiəgəh ilah.” ");
INSERT INTO tnp_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nian nətəmimi kəməutətəlɨg e Iesu, in təmətəkeikei mətəni nəghatiən əuhlin kəm lah mətəu-inu in tɨnuva iuəkɨr o Jerusɨləm, kəni nɨkilah təhti məmə Narmənɨgiən Rəha Uhgɨn otəsuvəhiən əha rəueiu tuva. ");
INSERT INTO tnp_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kəni təməni=pən kəm lah məmə, “Iərmənɨg kəti tolkeikei məmə in otuvən isəu meruh kig asoli agɨn məmə kig asoli otəfəri in mol kig lan əpəha iman ikɨn, kəni in otəpanɨtəlɨg=pa mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Kəni in təmauɨn e rəhan noluək mɨn ten, kəni məuəri məni asoli kətiəh kətiəh e lah. Kəni in təməni=pən kəm lah məmə, ‘Itəmah onəkotəkeikei motalkut o məni u o noliən nətɨn mətəuarus=pən iəu iəkɨtəlɨg=pa mɨn.’ ");
INSERT INTO tnp_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Mətəu nətəm iman ikɨn kəsotolkeikeiən suah kəha, kəni motahli=pən nətəmimi nəuvein kotos nəghatiən məhuvən kəm kig asoli agɨn məmə, ‘Itɨmah iəsotolkeikeiən məmə suah u otarmənɨg e tɨmah.’ ");
INSERT INTO tnp_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mətəu kəmləfəri iərmənɨg u kol kig lan, kəni in təmɨtəlɨg=pa mɨn. Kəni suah u təmauɨn e rəhan noluək mɨn iətəm in təməuəri rəhan məni kəm lah. In tolkeikei məmə otəhrun məmə ilah kəmotətəuarus məni nak nian in təmətatɨg əpəha isəu. ");
INSERT INTO tnp_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Kəni iətəm təmaupən muva məni=pən kəm in məmə, ‘Iərmənɨg, nəmələhu=pa məni kətiəh e nəhlmək, kəni iəmətəuarus məni ten mɨn.’ ");
INSERT INTO tnp_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kəni rəhan iərmənɨg təməni=pən kəm in məmə, ‘Ik ioluək təuvɨr, nəmol nati iətəm in təuvɨr. Mətəu-inu nəmol uək təuvɨr o neruh viviən nati iətəm təkəku, kəni rəueiu əha oiəkegəhan lam məmə ik onəkarmənɨg e taun ilah ten.’ ");
INSERT INTO tnp_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Kəni iətəm tətuərisɨg lan təmuva məni=pən məmə, ‘Iərmənɨg, nəmələhu=pa məni kətiəh e nəhlmək, kəni iəmətəuarus məni faif mɨn.’ ");
INSERT INTO tnp_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Kəni iərmənɨg təməni=pən kəm in məmə, ‘Ik onəkarmənɨg e taun ilah faif.’ ");
INSERT INTO tnp_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Kəni ioluək kəti mɨn təmuva məni=pən kəm in məmə, ‘Iərmənɨg, inu rəham məni. Iəməlis-ərain e napən, kəni məhluaig vivi lan. ");
INSERT INTO tnp_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Iəu iəməgɨn lam mətəu-inu, iəkəhrun məmə ik iətəmi noliən rəham tiəkɨs. Ik natos natimnati kəsəniəmə məmə rəham, kəni matos nauəniən e nasumiən mɨn rəha nətəmimi pɨsɨn mɨn.’ ");
INSERT INTO tnp_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Kəni iərmənɨg təməni=pən kəm in məmə, ‘!Ik ioluək tərah! E rəham əmə nəghatiən, iətakil ik məmə nəmol tərah agɨn. Nəmə ik nɨnəhrun rəkɨs məmə iəu iətəmi iəkɨs, kəni iətos natimnati iətəm kəsəniəmə rəhak, kəni matos nauəniən e nasumiən mɨn rəha nətəmimi pɨsɨn mɨn, ");
INSERT INTO tnp_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","kəni təhro nəməsosiən rəhak məni muvən məfən e bank, kəni nian iəkɨtəlɨg lan, iəkəhrun nosiən rəhak məni ilau nətɨn.’ ");
INSERT INTO tnp_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Kəni təməni=pən kəm rəhan mɨn nətəmimi məmə, ‘Otos rəkɨs rəhan məni, kəni motəfən kəm suah u rəhan məni ten.’ ");
INSERT INTO tnp_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Kəni ilah kəmotəni məmə, ‘!Iərmənɨg, təsəhruahruiən mətəu-inu rəhan məni ten rəkɨs!’ ");
INSERT INTO tnp_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Kəni iərmənɨg təməni=pən kəm lah məmə, ‘Iətəni kəm təmah məmə, iətəmimi iətəm tatos nati kəti, kəmanəfən mɨn nəuvein mɨn kəm in. Mətəu iətəmi rəhan nati kəti tɨkə, kəpanos rəkɨs rəhan natimnati rəfin. ");
INSERT INTO tnp_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kəni rəueiu, rəhak tɨkɨmɨr mɨn iətəm kəməsotolkeikeiən iəu məmə iəkuva kig rəhalah, onəkotit ilah məhuva, kəni motuhamu ilah e nəhmtək.’” ");
INSERT INTO tnp_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kəni nian Iesu təməghati rəkɨs, kəni in təmaliuək maupən matuvən əpəha ilɨs Jerusɨləm, kəni nətəmimi kəmautuərisɨg lan. ");
INSERT INTO tnp_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nian kəməhuva iuəkɨr o lahuənu mil u keiu, Petfas mɨne Petəni e Nɨtəuət Rəha Nɨgi U Olif, kəni in təməni=pən kəm rəhan mil keiu iətəmimi məmə, ");
INSERT INTO tnp_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Onəkian əpəha lahuənu ikɨn kəmotsɨpən ikɨn. Ikɨn əha, onəkueh nətɨ togki kəti kəsasuə əhanəhiən lan. Nəkiatɨs nɨləuɨs lan muasɨg miəuva u ikɨnu. ");
INSERT INTO tnp_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kəni nəmə suah kəti tətapuəh o təlau məmə, ‘?Nətiatɨs togki o nak?’ kəni onəkuəni=pən kəm in məmə, ‘Iərmənɨg, in tolkeikei məmə otol nati kəti lan.’” ");
INSERT INTO tnp_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kəni kəmian mueruh natimnati rəfin tol əmə məmə inu Iesu təməni. ");
INSERT INTO tnp_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kəni nian kəmətiatɨs nətɨ togki, kəni nətəmimi mɨn rəha togki kəmotətapuəh o lau məmə, “!Ei! ?Nətiatɨs nətɨ togki o nak?” ");
INSERT INTO tnp_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Kəni ilau kəmuəni=pən məmə, “Kəpə. Iərmənɨg tolkeikei məmə otol nati kəti lan.” ");
INSERT INTO tnp_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kəni kəmuasɨg miəuva kəm Iesu, kəni kəmuəpəg rəhalau kəti napən muəhtərain nəmtah nətɨ togki lan, kəni muasiru e Iesu təri masuə e nətɨ togki. ");
INSERT INTO tnp_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nian təmasuə lan mɨnatuvən, kəni rəhan mɨn nətəmimi kəmotaupən motəpeg rəhalah mɨn kəti napən motəpenə e suaru. ");
INSERT INTO tnp_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nian Iesu tɨnatuva iuəkɨr o Jerusɨləm mətasuə e togki məteiuaiu e Nɨtəuət Rəha Nɨgi U Olif, kəni nətəmimi mɨn rəfin rəhan nɨkilah təmagiən, kəni mɨnautəni-vivi Uhgɨn məutagət əfəməh o nati apɨspɨs mɨn ilah kəmoteruh in təmatol. ");
INSERT INTO tnp_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Kəni ilah məutəni məmə, “!Iərmənɨg Uhgɨn tətatɨg ilau kig u iətəm tətuva e nərgɨn! Pəh nəməlinuiən otatɨg əpəha e negəu e neai, kəni əpəha ilɨs ilɨs agɨn e negəu e neai, okətəfəri nərgɨ Iərmənɨg Uhgɨn!” ");
INSERT INTO tnp_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kəni Farəsi mɨn nəuvein əha kəutatɨg əha ikɨn kəmotəni=pən kəm in məmə, “Iəgətun. Əniəhu rəham mɨn nətəmimi məmə okəsotagətiən.” ");
INSERT INTO tnp_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mətəu in təməni=pən kəm lah məmə, “Nəmə nətəmi mɨn u kəsotagətiən, kəni kəpiel əpnapɨn mɨn u, ilah okotagət əfəməh.” ");
INSERT INTO tnp_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kəni nian Iesu təmuva iuəkɨr meruh taun əha Jerusɨləm, in təmasək o nətəmimi mɨn əha ikɨn əha. ");
INSERT INTO tnp_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Kəni in təni məmə, “Kəsi, iəmolkeikei pɨk məmə itəmah mɨn nəmotəhrun natimnati mɨn iətəm okotəfɨnə nəməlinuiən kəm təmah e nian u rəueiu. Mətəu kəpə. Kəni rəueiu, natimnati mɨn əha kəutəhluaig ko nəsoteruhiən. ");
INSERT INTO tnp_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mətəu e nian mɨn iətəm otuva o təmah, rəhatəmah tɨkɨmɨr mɨn okəhuva motəhtul tɨtəlau e təmah, okotel nɨftəni motətu-pəri motol əpətɨn rəhatəmah taun, kəni motahtɨpəsɨg lan məmə onəsohietiən. ");
INSERT INTO tnp_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Kəni ilah okotərəkɨn rəfin nimə e taun rəhatəmah, kəni ko kəpiel kəti mɨne rəha nimə mɨn otəsəhtuliən. Kəni okotohamu itəmah rəfin itəmah kəlkələh mɨn rəhatəmah. Natimnati rəfin u otuva mətəu-inu itəmah nəmoteruh mətəu nəməsotəhruniən nian iətəm Uhgɨn təmuva məmə in otosmiəgəh itəmah lan.” ");
INSERT INTO tnp_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kəni Iesu təmuvən Jerusɨləm, kəni muvən e iat rəha Nimə Rəha Uhgɨn meruh nətəmimi kautol makɨt ikɨn, kəni mətəhgi pətɨgəm ilah. ");
INSERT INTO tnp_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Kəni in təməni=pən kəm lah məmə, “Kəmətei rəkɨs e Nauəuə Rəha Uhgɨn məmə, ‘Rəhak nimə, in nimə rəha nəfakiən,’ mətəu itəmah nɨnautol tɨnuva məmə ‘nimə kəti iətəm nakləh mɨn kəutəhluaig ikɨn.’” ");
INSERT INTO tnp_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kəni uərisɨg lan, e nian mɨn rəfin, Iesu təmətəgətun əpəha imə e Nimə Rəha Uhgɨn. Kəni pris asoli mɨn, mɨne nəgətun mɨn rəha Lou, mɨne nətəmimi asoli mɨn rəha nətəm Isrel, kəməutəsal e suaru məmə okotuhamu Iesu, ");
INSERT INTO tnp_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","mətəu kəsotehiən suaru kəti mətəu-inu nətəmimi rəfin kotolkeikei pɨk məmə okotətəu nəghatiən mɨn rəhan, kəni nəghatiən rəhan tətaskəlɨm vivi rəhalah nətəlɨgiən. ");
INSERT INTO tnp_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nian kəti, Iesu təmətəgətun nətəmimi əpəha e Nimə Rəha Uhgɨn, kəni mətəni pətɨgəm nanusiən təuvɨr rəha Uhgɨn kəm nətəmimi. Kəni pris asoli mɨn, mɨne nəgətun mɨn rəha Lou, mɨne nətəmimi asoli mɨn rəha nətəm Isrel kəməhuva moteh in, ");
INSERT INTO tnp_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","kəni kəmotətapuəh ohni məmə, “?Əni-to kəm tɨmah məmə natol natimnati mɨn əha e nepətiən əhro? ?Kəni pəh təmegəhan lam natol natimnati mɨn əha?” ");
INSERT INTO tnp_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Kəni Iesu təməni=pən kəm lah məmə, “Təuvɨr əmə. Iəu iəkətapuəh mɨn e nəghatiən kəti kəm təmah, kəni itəmah onəkotaupən motuhalpɨn=pa kəm iəu. ");
INSERT INTO tnp_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","?Pəh təmegəhan e nepətiən kəm Jon məmə in otol bəptais e nətəmimi, Uhgɨn uə iətəmimi əmə?” ");
INSERT INTO tnp_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kəni kɨnəutəni nəghatiən u kəm lah mɨn, məutəni məmə, “Nəmə kotəni məmə Uhgɨn təmegəhan lan, kəni in otəni məmə, ‘?Mətəu təhro nəsotəniən nɨpəhriəniən e nəghatiən rəha Jon?’ ");
INSERT INTO tnp_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Mətəu nəmə kitah kotəni məmə nətəmimi əmə kəmotegəhan lan, kəni nətəmi mɨn əha okotəhti itah e kəpiel mətəu-inu ilah kɨnotəni rəkɨs nɨpəhriəniən e Jon məmə in iəni kəti rəha Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kəni ilah kəmotuhalpɨn məmə, “Itɨmah iəsotəhruniən məmə pəh təmegəhan lan.” ");
INSERT INTO tnp_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kəni Iesu təni=pən kəm lah məmə, “Kəni iəu mɨn, ko iəsəniən məmə pəh təmegəhan e nepətiən kəm iəu məmə iəkol natimnati mɨn u.” ");
INSERT INTO tnp_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kəni Iesu təməni nəghatiən əuhlin kəti kəm nətəmimi məmə, “Iətəmi asoli kəti təmərfei nɨləuɨs u krep e nasumiən asoli rəhan. Kəni mələhu=pən nasumiən u e nəhlmɨ nətəmimi nəuvein, kəni ilah okəutasum kəni məutafəl, kəni nian rəha nəuləkiən, kəni ilah okotəfən nəuvetɨn kəm in. Kəni in təmuvən əpəha e nɨtəni pɨsɨn kəti mɨn, kəni mɨnatɨg mɨnos nian tepət. ");
INSERT INTO tnp_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","“Kəni nian krep təmol nəuan kəni mɨnatɨmarəg, iətəmi asoli u təmahli=pən rəhan kəti ioluək məmə in otuvən meruh nətəm kəutasum e rəhan nasumiən məmə okotəhli nəua krep, kəni motəuəri motəfən rəha iətəmi asoli nəuvein. Mətəu nətəmimi mɨn əha kəmotəhtul motəhti ioluək əha, kəni motahli=pən tɨtəlɨg kəni məsotəfəniən nəua krep nəuvein kəm in. ");
INSERT INTO tnp_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kəni iətəmi asoli təmahli=pən mɨn rəhan kəti ioluək. Kəni ilah kəmotoh mɨn, kəni motol aulɨs in, kəni motahli=pən tɨtəlɨg məsotəfəniən nəua krep kəti kəm in mɨne. ");
INSERT INTO tnp_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kəni in təmahli=pən mɨn kəti, kəni ilah kəmotoh motəfən nɨməgɨm kəm in, kəni motəraki pətɨgəm lan. ");
INSERT INTO tnp_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Kəni iətəmi asoli rəha nasumiən təni məmə, ‘?Oiəkəhro əha rəueiu? Təuvɨr məmə iəkahli=pən nətɨk əhruahru, iətəm iəkolkeikei pɨk. Nɨkik təhti məta okotɨsiai in.’ Kəni in təmahli=pən. ");
INSERT INTO tnp_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Mətəu nian nətəmimi mɨn əha kəmoteruh, kəni kəmotəni kəm lah mɨn məmə, ‘Nətɨ iətəmi asoli əpə tətuva u nian kəti nasumiən tuva mol rəhan lan. Pəh kotohamu, kəni kitah kotos nasumiən u rəhan məmə rəhatah.’ ");
INSERT INTO tnp_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kəni kəmotaskəlɨm motatu pətɨgəm lan e nasumiən, kəni motoh motohamu. “?Kəni tol lanəha, iətəmi asoli rəha nasumiən otol nak e nətəmimi mɨn əha? ");
INSERT INTO tnp_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","In otuva kəni moh nətəmimi mɨn əha mohamu ilah, kəni in otələhu=pən nasumiən asoli əha tuvən e nəhlmɨ nətəpɨsɨn.” Kəni nian nətəmimi kəmautətəlɨg lan kəmotətəu nəghatiən əha, məutəni məmə, “!Təuvɨr məmə, otəsol agɨniən nati əha!” ");
INSERT INTO tnp_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Mətəu Iesu təməsal=pən meruh ilah, kəni məni məmə, “?Mətəu nəghatiən u nɨpətɨn nak? Nauəuə Rəha Uhgɨn tətəni məmə, ‘Kəpiel iətəm nətəmimi rəha nuvləkɨniən nimə kəmotəraki lan, in tɨnuva kəpiel keikei rəha noliən nimə.’ ");
INSERT INTO tnp_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Nətəmimi rəfin nətəm okotəmei motorin=pən ilah e kəpiel əha, kəni nɨkɨlkɨlilah otɨtəgɨt-əgɨt. Kəni nəmə kəpiel əha otəmei məhti iətəmi kəti, kəni in otauvtəuvtə mərah agɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kəni nəgətun mɨn rəha Lou, mɨne pris asoli mɨn kəmotəhrun məmə nəghatiən əuhlin u rəhan tətəni əmə ilah, kəni tol lanəha, ilah kəutəsal e suaru məmə okotaskəlɨm uəhai əmə, motləfən e kaləpus, mətəu kɨnotəgɨn e nətəmimi, kəni motəpəh. ");
INSERT INTO tnp_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kəni nəgətun mɨn rəha Lou, mɨne pris asoli mɨn kəutəsal vivi o Iesu məmə okotətəu nəghatiən kəti rəhan u təsəhmen əhruahruiən. Kəni o nəghatiən u, okotəfən in e nəhlmɨ iətəm kəti rəha kəpmən rəha Rom. Kəni kəmotahli=pən nətəmimi nəuvein məmə ilah okəhuvən motol kəuɨt kəsuə e Iesu. ");
INSERT INTO tnp_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kəni kəuɨt kəsuə mɨn kəməhuvən motətapuəh o Iesu məmə, “Iəgətun. Itɨmah iəkotəhrun natimnati mɨn iətəm nətəni mɨne natimnati iətəm nətəgətun nətəmimi lan, kotəhruahru vivi. Ik onəsoliən noliən pɨsɨn kəm suah kəti, kəni matɨg mol pɨsɨn mɨn kəm suah kəti. Mətəu onəkol təhmen-əhmen əmə kəm lah rəfin. Kəni ik nətəghati əmə e nɨpəhriəniən mətəgətun nətəmimi e suaru rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kəni tol lanu, əni-to kəm təmah məmə, təhruahru e Lou rəhatah məmə okotətəou takɨs kəm Kig Sisə u in iətəmi asoli agɨn rəha kəpmən rəha Rom, uə kəpə?” ");
INSERT INTO tnp_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mətəu Iesu təməhrun rəkɨs məmə kautol kəuɨt kəsuə kəm in, kəni in təməni=pən kəm lah məmə, ");
INSERT INTO tnp_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Otəgətun-to məni kəti kəm iəu. ?Narmɨ pəh u tətatɨg e məni u? ?Kəni nərgɨ pəh u tətatɨg e məni u?” Kəni kəmotəni məmə, “Narmɨ Sisə, mɨne nərgɨ Sisə.” ");
INSERT INTO tnp_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kəni in təməni=pən kəm lah məmə, “Kəni ko nəmə natimnati rəha Sisə, əfən kəm Sisə. Kəni natimnati rəha Uhgɨn, əfən kəm Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kəni e nəhmtɨ nətəmimi ərəfin, nəghatiən mɨn iətəm kəutətapuəh lan, ko kəsələs iahuiən Iesu lan. Mətəu narmɨlah təmiuvɨg pɨk e nəghatiən iətəm Iesu təmuhalpɨn, kəni kəməsotəghatiən. ");
INSERT INTO tnp_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kəni Satusi mɨn nəuvein kəməhuva o Iesu. Ilah kəutəni məmə nian iətəmi tɨmɨs, ko təsəmiəgəh mɨniən. ");
INSERT INTO tnp_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Kəni kəmotətapuəh e nəghatiən kəti kəm Iesu məmə, “Iəgətun. Mosɨs təmətei=pən e Lou rəhatah məmə nəmə iərman kəti otɨmɨs, kəni məpəh rəhan pətan, kəni məsuələsiən nətɨlau kəti mɨne, kəni pian otəkeikei mit pətalɨmɨs əha, məmə okuələs nətɨlau kəti ko, kəni suakəku u otos nɨmei rəhan tatə asoli əpəha tɨnɨmɨs rəkɨs. ");
INSERT INTO tnp_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","“Tol lanəha, nəman ilah səpɨn, u rəhalah tatə kətiəh. Kəni iətəm tepət e lah təmaupən mit pətan kəti, kəni məsuələsiən nətɨlau kəti, kəni mɨmɨs. ");
INSERT INTO tnp_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Pian iətəm tətuərisɨg lan, təmit mɨn pətalɨmɨs u, mətəu in mɨn təmɨmɨs, kəni kəməsuələsiən nətɨlau kəti. ");
INSERT INTO tnp_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kəni uərisɨg lan, pialah kəti mɨn təmit mɨn pətalɨmɨs u, mətəu in mɨn təmɨmɨs. Kəni pian mɨn əha ilah rəfin səpɨn kəmotit pətan u, mətəu kəsotələsiən nətɨlah kəti, ilah kəmohmɨs ərəfin. ");
INSERT INTO tnp_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kəni uərisɨg lan, pətalɨmɨs u tɨmɨs mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Inəha nətəmimi səpɨn, ilah pialah mɨn kəmotit pətan əha. ?Mətəu e Naunun Nian, nian nətəmimi okotəmiəgəh mɨn e nɨmɨsiən, pətan əha in rəha pəh lan?” ");
INSERT INTO tnp_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Kəni Iesu təməni=pən kəm lah məmə, “E nian u rəueiu e nəhue nɨftəni u, nəman mɨne nɨpətan kautol marɨt. ");
INSERT INTO tnp_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Mətəu e nian rəha natɨgiən vi, otəsoliən lanəha. Nətəmimi nətəm Uhgɨn nɨkin tətagiən o lah məmə ilah okotəmiəgəh mɨn e nɨmɨsiən, kəni in otos ilah məhuvən kotatɨg e natɨgiən vi. Kəni ko ilah okəsotoliən marɨt, kəni ilah okəsotohtəu-pəniən noliən rəha marɨt, ");
INSERT INTO tnp_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","mətəu-inu ilah ko kəsohmɨs mɨniən. Kəni ko kəsohmɨs mɨniən mətəu-inu, ilah okotəhmen əmə e nagelo mɨn nətəm kəsohmɨsiən, kəni məsotoliən marɨt, kəni məsoteməkiən e kəlkələh mɨn. Kəni ilah mɨn u nətəm Uhgɨn təmol ilah kotəmiəgəh mɨn e nɨmɨsiən, ilah mɨn nenətɨ Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kəni kotəhrun məmə inu otuva mol nɨpəhriəniən lan mətəu-inu, nauəuə rəha Mosɨs tətəgətun mɨn məmə nian nətəmimi okohmɨs, ilah okotəmiəgəh mɨn. E nəniən rəha nɨgi iətəm nɨgəm təmatuəu=pən lan, Mosɨs təmauɨn e Iərmənɨg məmə in ‘Uhgɨn rəha Epraham, Uhgɨn rəha Aisək, mɨne Uhgɨn rəha Jekəp,’ nati əpnapɨn ilahal kəmlɨmɨs rəkɨs nuvəh nəuvetɨn. ");
INSERT INTO tnp_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Uhgɨn u, in Uhgɨn rəha nətəm kautəmiəgəh, mətəu səniəmə in Uhgɨn rəha nətəm kəmohmɨs, mətəu-inu in tateh nətəmimi mɨn rəfin məmə ilah okotəmiəgəh, nati əpnapɨn nəmə kəmohmɨs rəkɨs uə kəutəmiəgəh əhanəh.” ");
INSERT INTO tnp_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kəni nəgətun mɨn rəha Lou nəuvein kəmotəni=pən kəm Iesu məmə, “Iəgətun, nəmuhalpɨn vivi pəhriən.” ");
INSERT INTO tnp_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kəni kəmotəgɨn o nətapuəh mɨniən nəghatiən kəti mɨn tol lanəha. ");
INSERT INTO tnp_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Kəni Iesu təməni=pən kəm lah məmə, “?Təhro nətəmimi kəutəni məmə Krɨsto iətəm Uhgɨn təməni məmə otahli=pa, in mipɨ Kig Tefɨt? ");
INSERT INTO tnp_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Mətəu-inu e Nauəuə Rəha Nəpuən Mɨn, Kig Tefɨt aru əmə təməni məmə, ‘Iərmənɨg Uhgɨn təməni=pən kəm rəhak Iərmənɨg məmə, “Əharəg u e rəhak maru, ikɨn ima nəsanəniən mɨne nɨsiaiən, ");
INSERT INTO tnp_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mətəuarus=pən iəu iəkələs iahu rəham tɨkɨmɨr mɨn, məlɨn=pən ilah əpəha ləhtəni e nəhlkəm, məmə nətarmənɨg e lah.” ’ ");
INSERT INTO tnp_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Kig Tefɨt əhruahru təməni məmə Krɨsto in rəhan Iərmənɨg. ?Kəni nəmə mipɨ Tefɨt əhruahru əmə, kəni təhro matol rəhan Iərmənɨg lan?” ");
INSERT INTO tnp_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nətəmimi kəməutətəlɨg, kəni Iesu təməni=pən kəm rəhan mɨn nətəmimi məmə, ");
INSERT INTO tnp_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Itəmah onəkotəkeikei məutətəu vivi itəmah kəni məsotohtəu-pəniən noliən mɨn rəha nəgətun mɨn rəha Lou. Ilah kotolkeikei məmə okəhuvən e napən əfəməh mɨn rəha nəfəriən məmə nətəmimi okoteruh=pən ilah lan. Kəni nɨkilah tətagiən nian nətəmimi kəutəfəri nəhlmɨ lah kəm lah e nɨsiaiən əpəha e makɨt. Kəni əpəha imə e nimə rəha nuhapumɨniən, kotolkeikei məmə okotəharəg aupən əpəha təuvɨr ikɨn. Kəni e nian rəha lafet, ilah kotolkeikei məmə okəhuvən motəharəg aupən ikɨn nɨsiaiən ikɨn. ");
INSERT INTO tnp_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Kəni ilah kautol tərah kəni məutakləh e nimə mɨn rəha pətalɨmɨs mɨn. Kəni ilah kəutəfaki əfəməh məuteiuə əmə məmə nətəmimi okoteruh ilah ohni. Nalpɨniən rəha nətəmimi mɨn u in otəskasɨk mapirəkɨs.” ");
INSERT INTO tnp_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Kəni nian Iesu təməsal-pəri, materuh vivi nətəmimi mɨn u rəhalah nautə tepət kəutəfən rəhalah məni e bokɨs kətəfən məni ikɨn əpəha e Nimə Rəha Uhgɨn, ");
INSERT INTO tnp_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","kəni in təmeruh pətalɨmɨs kəti ianrah tətəfən məni əkəku keiu əmə. ");
INSERT INTO tnp_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kəni Iesu təni məmə, “Nɨpəhriəniən iətəni kəm təmah məmə, məni iətəm pətan u təməfən, in tapirəkɨs rəha nətəmimi rəfin, ");
INSERT INTO tnp_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","mətəu nətəm rəhalah nautə tepət kəmotəfən məni nəuvein mətəu inko in nati əpnapɨn o lah, rəhalah tepət mɨn əpəha ikɨn. Mətəu pətalɨmɨs u in ianrah pəhriən, in təməfən rəfin rəhan məni o nos nəhmtɨniən nauəniən nɨgɨn, kəni tɨkə mɨn əha ikɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kəni Iesu təmətəu rəhan mɨn nəuvein nətəmimi kəutəni Nimə Rəha Uhgɨn iətəm rəhan kəpiel asoli mɨn kotəuvɨr, mɨne natimnati təuvɨr mɨn əha imə iətəm nətəmimi kəmotəfən kəm Uhgɨn. Kəni təni məmə, ");
INSERT INTO tnp_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Itəmah nəuteruh natimnati mɨn əha, mətəu nian otətuva nətəmimi okotoharəg-rəg kəpiel mɨn rəha nimə əha, kəpiel mɨn rəfin okotəmei, ko kəti təsəhtuliən əha tətəhtul ikɨn rəueiu.” ");
INSERT INTO tnp_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Kəni kəmotətapuəh ohni məmə, “Iəgətun. ?Natimnati mɨn əha onəhgɨn kəhuva? ?Kəni nəmtətiən nak otəgətun məmə otəsuvəhiən natimnati mɨn əha okəhuva?” ");
INSERT INTO tnp_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Kəni Iesu təni məmə, “Onəkotəkeikei məutətəu vivi itəmah məmə suah kəti otəseiuəiən e təmah, mətəu-inu nətəmimi tepət okəhuva motəni məmə, ‘!Iəu, iəu Krɨsto u!’ Kəni nəuvein okotəni məmə, ‘Nian rəha natimnati əha tɨnuva iuəkɨr.’ Mətəu onəsəhuərisɨgiən e lah. ");
INSERT INTO tnp_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kəni nian onəkotətəu nanusiən məmə nətəmimi kəutəluagɨn, uə nətəmimi kəutəməu ilah rəhalah kəpmən, mətəu itəmah onəsotəgɨniən. Natimnati mɨn əha okotaupən məhuva pɨpɨm, mətəu kəsəniə məmə in Naunun Nian.” ");
INSERT INTO tnp_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kəni Iesu təni=pən kəm lah məmə, “Nətəmimi e nɨtəni mɨn nəuvein okotəluagɨn ilah nətəmimi e nɨtəni mɨn nəuvein, kəni kəpmən nəuvein okotəluagɨn ilah kəpmən nəuvein. ");
INSERT INTO tnp_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kəni nəmig asoli mɨn okotan, kəni nəumɨs otan ikɨn mɨn tepət e nəhue nɨftəni, kəni nɨmɨsiən əskasɨk mɨn okotan e nəhue nɨftəni, kəni əpəha ilɨs e neai, natimnati mɨn okəhuva motol nɨki nətəmimi otəgɨn, kəni ilah okoteruh nəmtətiən asoli mɨn e neai. ");
INSERT INTO tnp_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Mətəu nian natimnati mɨn u okəsəhuva pɨpɨm əhanəhiən, nətəmimi okotaskəlɨm itəmah, kəni motol nərahiən kəm təmah o nəhatətəiən rəhatəmah, kəni motələs itəmah məhuvən əpəha e nimə rəha nuhapumɨniən, mɨne e kaləpus, kəni onəkotəhtul e nəhmtɨ kig mɨn mɨne nətəmi asoli mɨn rəha kəpmən mətəu-inu itəmah nautos nərgək məutəni nɨpəhriəniən lak. ");
INSERT INTO tnp_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Inəha nian təuvɨr əhruahru məmə nəkotəni pətɨgəm nanusiən təuvɨr kəm lah. ");
INSERT INTO tnp_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mətəu otol əpenə-penə e nɨkitəmah rəueiu məmə e nian əha nɨkitəmah təsəhtiən məmə nəghatiən nak onəkotəni kəm lah, ");
INSERT INTO tnp_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","mətəu-inu iəu oiəkəfɨnə nəghatiən əhruahru kəm təmah kəni məfɨnə nəhruniən kəm təmah, kəni mol rəhatəmah nəghatiən təsanən, kəni rəhatəmah mɨn tɨkɨmɨr ko kəsotuhalpɨniən, kəni ko kəsotəniən məmə nəsotəniən nɨpəhriəniən. ");
INSERT INTO tnp_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kəni rəhatəmah tatə mɨne mamə mɨn, mɨne piatəmah mɨn, mɨne rəhatəmah nɨmənin mɨn, mɨne niəli mɨn okotəfən itəmah e nəhlmɨ tɨkɨmɨr mɨn. Kəni okotohamu itəmah nəuvein. ");
INSERT INTO tnp_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nətəmimi mɨn rəfin okotəməki e təmah o nərgək. ");
INSERT INTO tnp_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mətəu ko nəuanutəmah uəha kəti, ko təsɨkəiən. ");
INSERT INTO tnp_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nian onəutəhtul əskasɨk məutəhatətə lak e nian iəkɨs mɨn iətəm okəhuva e rəhatəmah nəmiəgəhiən, kəni onəkotos nəmiəgəhiən itulɨn. ");
INSERT INTO tnp_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Mətəu nian onəkoteruh soldiə mɨn okəhuva tepət motohtəlau e taun u Jerusɨləm, kəni itəmah onəkotəkeikei motəhrun məmə otəsuvəhiən kəni kərəkɨn agɨn taun əha Jerusɨləm. ");
INSERT INTO tnp_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kəni itəmah nəutatɨg Jutiə, onəkotəkeikei motaiu motagɨm məhuvən motəhluaig əpəha e nɨtəuət mɨn. Kəni itəmah nətəm nəutatɨg e taun əha, onəkotəkeikei mohiet. Kəni itəmah nətəm nəutatɨg ikɨnu tɨtəlau e taun əha, onəsəhuvən mɨniən əha imə e taun əha, ");
INSERT INTO tnp_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","mətəu-inu nian əha, in nian rəha Uhgɨn otol nalpɨniən lan kəm nətəm kautol noliən tərah, kəni mol əpu nəghatiən iətəm kəmətei=pən e nauəuə rəhan tuva matol nɨpəhriəniən lan. ");
INSERT INTO tnp_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","“!Kəsi! Nahməiən asoli o nɨpətan nətəm kəmotol nərfɨlah mɨne nɨpətan kəutəfən nah kəm nəpəou mɨn. E nian əha okotos pɨk nahməiən, mətəu-inu nərahiən asoli otuva e nəhue nɨftəni, kəni niəməha mɨne nalpɨniən rəha Uhgɨn otuva kəm nətəmimi mɨn u rəha Isrel u kautol noliən tərah mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kəni rəhalah tɨkɨmɨr mɨn okagəmu ilah e nau, kəni nian okotoh ilah, kəni okotit ilah məhuvən e nɨtəni pɨsɨn pɨsɨn mɨn kəni ilah okəhuva iol əhruin nati mɨn rəhalah. Kəni Nanihluə mɨn okotaliuək kəni motevɨg əpevɨn e Jerusɨləm motələs iahu nətəmimi mɨn ikɨn iətəm kəutatɨg əhanəh, məutarmənɨg e lah, mətəuarus=pən rəhalah nian otol naunun. ");
INSERT INTO tnp_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Kəni nəmtətiən nəuvein okəhuva e mɨtɨgar, mɨne məuɨg, mɨne məhau mɨn. Kəni ikɨnu e nəhue nɨftəni, nətəmimi rəfin okotəgɨn e nərkərɨkiən rəha nɨtəhi mɨne peau-peau asoli mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nətəmimi okotəgɨn pɨk məutɨmɨseiah e nərahiən asoli mɨn iətəm kəutəhuva e nəhue nɨftəni, mətəu-inu natimnati e neai iətəm kotəskasɨk pɨk, mətəu Uhgɨn otəlauəl-auəl e lah. ");
INSERT INTO tnp_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kəni e nian əha, okoteruh Nətɨ Iətəmimi tətuva e nɨmalɨ nəpuə kəti e nəsanəniən mɨne nepətiən əhagəhag asoli rəhan. ");
INSERT INTO tnp_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kəni nian natimnati mɨn u kɨnotətuəuin mɨnəutəhuva mɨnautol nɨpəhriəniən lan, otəhtul məha-məha motəhrun məmə nati təuvɨr tɨnatuva, mətəu-inu otəsuvəhiən Uhgɨn otosmiəgəh itəmah.” ");
INSERT INTO tnp_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kəni in təməni nəghatiən əuhlin u kəm lah məmə, “Nəkotəhrun-to nɨgi u fik mɨne nɨgi nəuvein mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nəmə kɨnotehaləgləg mɨnəutapɨlpɨl mɨn, kəni nəkotəhrun məmə in nian rəha nasumiən. ");
INSERT INTO tnp_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Təhmen əmə, nəmə nəkoteh natimnati mɨn u kautol lanəha, onəkotəhrun məmə otəsuvəhiən, Narmənɨgiən Rəha Uhgɨn tuva. ");
INSERT INTO tnp_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Nɨpəhriəniən iətəni kəm təmah məmə nɨmənin rəha Isrel otəsɨkəiən mətəuarus=pən natimnati rəfin əha okotol nɨpəhriəniən. ");
INSERT INTO tnp_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Neai mɨne nɨftəni okiakə, mətəu nəghatiən mɨn rəhak ko kəsohkəiən.” ");
INSERT INTO tnp_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Kəni Iesu tətəni məmə, “Nəkotəkeikei məutətəu itəmah. Sotərəkɨniən rəhatəmah nian mɨn o noliən əmə lafet, məutapɨs lan, kəni məutətəlɨg pɨk e natimnati rəha nɨftəni u. Təsəuvɨriən məmə nian asoli u otuva mos kauɨt kəm təmah təhmen=pən məmə nəuanɨkulu təmahtɨpəsɨg e təmah, ");
INSERT INTO tnp_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","mətəu-inu nian əha otuva mələs nətəmimi mɨn rəfin e nəhue nɨftəni. ");
INSERT INTO tnp_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mətəu nian rəfin onəkotəkeikei məutəhtul maru, kəni məutəkeikei məutəfaki məmə nəkotos nəsanəniən təhmen məmə nəkəutəhtul əskasɨk əmə e natimnati ərəfin əha okəhuva, kəni ko Nətɨ Iətəmimi otagiən o təmah nian onəkotəhtul e nəhmtɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kəni nian rəfin Iesu tətəgətun nətəmimi əpəha e Nimə Rəha Uhgɨn, kəni lapɨn mɨn in tiet muvən əpəha Nɨtəuət Rəha Nɨgi U Olif mətapɨli əha ikɨn. ");
INSERT INTO tnp_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kəni nian mɨn rəfin ləplapɨn agɨn, nətəmimi kəutəhuva məmə okotətəlɨg e rəhan nəghatiən əpəha e Nimə Rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kəni nian rəha lafet rəha Pɨret U Is Tɨkə Lan tɨnatuva iuəkɨr, kəni in tɨnətuəuin e lafet rəha Pasova. ");
INSERT INTO tnp_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Kəni pris asoli mɨn mɨne nəgətun mɨn rəha Lou kəməutəsal oneuən e suaru məmə okotohamu Iesu lan. Kəməutəsal oneuən e suaru mətəu-inu ilah kəutəgɨn e nətəmimi məmə, kəta nɨmənin nətəmimi okotorgəhu nəmə kotəhrun məmə kəmotohamu Iesu. ");
INSERT INTO tnp_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kəni Setən təmuvən e nɨki Jutəs, u nərgɨn kəti mɨn u Iskariot, in kəti e nətəmimi tueləf rəha Iesu. ");
INSERT INTO tnp_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Kəni in təmuvən meruh pris asoli mɨn mɨne nətəmi asoli mɨn rəha soldiə rəha Nimə Rəha Uhgɨn, məutəsal e suaru məmə otegəhan e Iesu tuvən e nəhlmɨlah. ");
INSERT INTO tnp_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Kəni nɨkilah təmagiən, kəni kəmotəniəkɨs məmə okotəfən məni kəti kəm in. ");
INSERT INTO tnp_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Kəni Jutəs təmegəhan lan məmə in otol, kəni mətəsal e suaru məmə otegəhan e Iesu tuvən e nəhlmɨlah nian nətəmimi okohkə lan. ");
INSERT INTO tnp_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kəni e nian rəha lafet rəha Pɨret U Is Tɨkə Lan tɨnuva, kəni e nian əha, nətəmimi okotəkeikei motuh nətɨ sipsip rəha lafet rəha Pasova. ");
INSERT INTO tnp_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Kəni Iesu təmauɨn e Pitə mɨne Jon, kəni məni=pən kəm lau məmə, “Ian kəni muol əpenə-penə nauəniən rəha lafet rəha Pasova məmə okəhuvən motauən ikɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Kəni kəmuəni=pən kəm in məmə, “?Nəkolkeikei məmə itɨmlau oiəkian iə muol əpenə-penə e nauəniən ikɨn?” ");
INSERT INTO tnp_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Kəni təməni=pən kəm lau məmə, “Uətəlɨg vivi-to. Nian itəlau onəkian=pən itaun, kəni onəkueh suah kəti tətaharu pəri pətəl asoli kəmətu=pən nəhu lan. Kəni nəkiauərisɨg lan mɨhluvən e nimə kəti iətəm in otuvən ikɨn. ");
INSERT INTO tnp_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Kəni nəkuəni=pən kəm iətəmi asoli rəha nimə, ‘?Iəgətun təmahli=pa itɨmlau məmə iəkuva muətapuəh ohnik məmə nəuan u in pəhruvən iətəm in mɨne rəhan mɨn nətəmimi okəhuva motol nauəniən ikɨn rəha lafet rəha Pasova?’ ");
INSERT INTO tnp_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kəni in otit itəlau nəkian əpəha e nəuan ilɨs ikɨn iətəm kɨnol vivi rəkɨs natimnati rəfin rəha nauəniən əha ikɨn. Kəni nəkuol əpenə-penə nauəniən əha ikɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kəni kəmian mueruh natimnati rəfin təhmen=pən əmə məmə inu Iesu təməni mɨne. Kəni ilau kəmuol əpenə-penə nauəniən ikɨn məmə rəha lafet rəha Pasova. ");
INSERT INTO tnp_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kəni e nian rəha nauəniən, Iesu təmuvən məharəg e tepɨl ilah rəhan mɨn aposɨl mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kəni təməni=pən kəm lah məmə “Otəsuvəhiən, okol nahməiən kəm iəu. Mətəu nɨkik tɨnolkeikei pɨk məmə okotaupən motun nauəniən rəha lafet rəha Pasova. ");
INSERT INTO tnp_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Iəkolkeikei pɨk məmə kitah okotauən lanu mətəu-inu, ko iəsauəniən mɨn e nauəniən rəha Pasova mətəuarus nɨpətɨ lafet u tuva mol nɨpəhriəniən lan e Narmənɨgiən Rəha Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kəni Iesu təmos kap wain məni tagkiu ohni kəm Uhgɨn, kəni məni məmə, “Otos itəmah rəfin kəni motəmnɨm, ");
INSERT INTO tnp_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","mətəu-inu rəueiu iətəni kəm təmah məmə iəsəmnɨmiən wain mətəuarus=pən nian natimnati rəfin okotatɨg ahgəl Narmənɨgiən Rəha Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kəni təmos pɨret məni tagkiu ohni kəm Uhgɨn, kəni məhapu məfən kəm rəhan mɨn nətəmimi, kəni məni məmə, “Inu nɨpətɨk iətəm iətəfɨnə o təmah. Nian rəfin onəkotəkeikei mautol nati u məmə nɨkitəmah tətəhti iəu.” ");
INSERT INTO tnp_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","E noliən əhmen mɨn əmə, nian kəmotauən rəkɨs, Iesu təmos kap wain kəni məni məmə, “Kap wain u tətəgətun=pən nəniəskasɨkiən vi rəha nasiruiən rəha Uhgɨn kəm nətəmimi, kəni nəniəskasɨkiən vi u tətəhtul mətəmiəgəh e nɨrak iətəm otaiu o təmah. ");
INSERT INTO tnp_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Mətəu onəkotətəlɨg vivi-to. Suah kəti u ikɨnu kəutauən kitah min e tepɨl, kəni in otəpanegəhan=pən lak e nəhlmɨ rəhak mɨn tɨkɨmɨr. ");
INSERT INTO tnp_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Iəu Nətɨ Iətəmimi oiəkəkeikei mɨmɨs məmə inu Uhgɨn təməni mɨne. !Mətəu kəsi, nərahiən asoli tatuvən o iətəmi təmegəhan=pən lak e nəhlmɨ tɨkɨmɨr mɨn!” ");
INSERT INTO tnp_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Kəni kɨnəutətapuəh-ətapuəh o lah mɨn məmə, “?Kitah pəh otol nati əha?” ");
INSERT INTO tnp_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kəni nati kəti mɨn, ilah kɨnautol nɨkilah mɨn məmə pəh u in otepət mapirəkɨs nəuvein. ");
INSERT INTO tnp_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Kəni Iesu təni=pən kəm lah məmə, “Kig mɨn rəha nɨftəni u kəutarmənɨg e nətəmimi e rəhalah nəsanəniən, kəni kəutauɨn aru e lah məmə ilah ‘Nətəmimi rəha Nasiruiən.’ ");
INSERT INTO tnp_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mətəu itəmah onəsotoliən lanəha. Nəmə itəmah kəti in ilɨs, in otosiahu in təhmen=pən e suakəku. Kəni nəmə itəmah kəti tətəhtul aupən, kəni in otuva iol əhruin nati əmə kəti. ");
INSERT INTO tnp_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","?Pəh u in ilɨs pɨk, iətəmi in tətauən e tepɨl, uə iol əhruin iətəm tatos nauəniən e tepɨl in ilɨs tapirəkɨs? Nəkotəhrun məmə iətəm tətauən e tepɨl in ilɨs tapirəkɨs. Mətəu iəu, iətəmi asoli rəhatəmah, nian iəmətaliuək kitah min itəmah, iəməhmen=pən e iol əhruin əmə kəti. ");
INSERT INTO tnp_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Itəmah u, nian rəfin nəutatɨg iuəkɨr ohniəu nian iətatɨg e nian əskasɨk mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kəni təhmen əmə məmə Tatə rəhak tətəfəri iəu məmə iəkuva kig, kəni iəu mɨn oiəkəfəri itəmah məmə nəkəhuva kig mɨn, ");
INSERT INTO tnp_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","məmə nəkəhuva motəharəg kitah min iəu, motauən pəti e nian iəkuva mol kig lan. Kəni e nian əha, itəmah mɨn onəkotəharəg e jeə mɨn rəha Kig, kəni itəmah onəkəhuva motəhtul aupən e nəuanɨləuɨs mɨn ilah tueləf rəha Isrel məutakil ilah məutarmənɨg e lah.” ");
INSERT INTO tnp_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Kəni Iesu təni=pən kəm Saimon Pitə məmə, “Kəsi. Saimon. Ətəlɨg-to lak. Setən tɨnətapuəh rəkɨs o Uhgɨn məmə otegəhan məmə in otuva məfən-əfən kəm təmah mol nərahiən kəm təmah məmə otəgətun rəhatəmah nəhatətəiən məmə təskasɨk lak uə kəpə. ");
INSERT INTO tnp_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Mətəu inəfaki rəkɨs ohnik məmə rəham nəhatətəiən otəsəmeiən. Kəni nian nəkəuhlin rəham nətəlɨgiən tɨtəlɨg=pa mɨn, ik onəkəkeikei mol nətəlɨgiən rəha piam mɨn okotəskasɨk.” ");
INSERT INTO tnp_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Mətəu Saimon Pitə təni=pən kəm in məmə, “Iərmənɨg. Iətəhtul maru məmə iəkuvən kilau min ik e kaləpus, kəni mɨmɨs kilau min ik.” ");
INSERT INTO tnp_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Kəni Iesu təni=pən kəm in məmə, “Pitə, iətəni kəm ik məmə, o lapɨn u mənɨg otəsəkakə əhanəhiən, kəni ik onəkəni mau kɨsɨl məmə nəkəruru iəu.” ");
INSERT INTO tnp_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kəni Iesu təni=pən kəm lah məmə, “Aupən, iəmahli pətɨgəm itəmah, nəməsotosiən məni e pauɨs, mɨne kətɨm, mɨne put. ?Təhro? ?Rəhatəmah natimnati təsəhmeniən, uə kəpə?” Kəni ilah kəmotəni məmə, “Kəpə.” ");
INSERT INTO tnp_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Kəni təməni=pən kəm lah məmə, “Mətəu rəueiu, nəmə suah kəti tatos rəhan məni e pauɨs uə kətɨm, otəkeikei mos. Kəni iətəm təsosiən nau rəha nəluagɨniən, pəh otətuati e rəhan kot mos nəhmtɨ rəhan kəti. ");
INSERT INTO tnp_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Iətəni kəm təmah məmə nəghatiən u e Nauəuə Rəha Uhgɨn tətəghati lak, kəni in otəkeikei mol nɨpəhriəniən. In tətəni məmə, ‘Nətəmimi nɨkilah təhti məmə in iətəmimi kəti in tətəraki e Lou.’ Əuəh, nəghatiən u tatol nɨpəhriəniən əha rəueiu.” ");
INSERT INTO tnp_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kəni ilah kəmotəni məmə, “Iərmənɨg, afu-to. Nau rəha nəluagɨniən keiu u.” Kəni in təni=pən kəm lah məmə, “Nəhmen. Otəpəh-tə.” ");
INSERT INTO tnp_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kəni Iesu təmiet e taun muvən əpəha e Nɨtəuət Rəha Nɨgi U Olif təhmen=pən əmə məmə in tatol nian mɨn rəfin, kəni rəhan mɨn nətəmimi kəutohtəu=pən in. ");
INSERT INTO tnp_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kəni nian in təmuvən mətəuarus=pən əha ikɨn əha, məni=pən kəm lah məmə, “Onəkotəkeikei məutəfaki məmə nati kəti otəsəfən-əfəniən kəm təmah.” ");
INSERT INTO tnp_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kəni in təmaliuək mupəh ilah muvən nəuvetɨn, kəni mɨsin nəulɨn mətəfaki mətəni məmə, ");
INSERT INTO tnp_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tatə, okəmə nɨkim tagiən, kəsi, os rəkɨs nahməiən mɨn u okəpanəhuva. Mətəu nəsoliən rəhak nətəlɨgiən, mətəu ol nati ik əmə nəkolkeikei.” ");
INSERT INTO tnp_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kəni agelo e neai kəti təmietɨgəm=pən məfən nəsanəniən kəm Iesu. ");
INSERT INTO tnp_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kəni mətəu-inu nɨkin tətahmə pɨk, kəni rəhan nətəlɨgiən təsəməhliən, kəni təməfaki əskasɨk pɨk, kəni nəmnəhagiən asoli təmaiu lan mətəhliahli=pən e nɨftəni təhmen e nɨrə. ");
INSERT INTO tnp_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nian təməfaki rəkɨs, kəni məhtul mɨtəlɨg=pən o rəhan mɨn nətəmimi, kəni meruh ilah kɨnotapɨli alu rəkɨs. Kəmotəpəou mətəu-inu nɨkilah tətahmə. ");
INSERT INTO tnp_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kəni təni=pən kəm lah məmə, “?Təhro nəutapɨli? Otair motəfaki məmə nati kəti otəsəfən-əfəniən kəm təmah.” ");
INSERT INTO tnp_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nian Iesu təmətəghati əhanəh, nɨmənin nətəmimi kəmohiet=pa əha ikɨn, kəni suah kəha Jutəs, u in iətəmimi kəti e nətəmi tueləf rəha Iesu, in təmit ilah məhuva, in təmuva iuəkɨr məmə otol nəmtətiən kəti rəha nolkeikeiən kəm Iesu. ");
INSERT INTO tnp_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Mətəu Iesu təni=pən kəm in məmə, “?Jutəs, iəu Nətɨ Iətəmimi, mətəu təhro nəmuva məmə onəkol nəmtətiən kəti rəha nolkeikeiən kəm iəu, kəni e noliən u megəhan=pən lak e nəhlmɨ rəhak tɨkɨmɨr mɨn?” ");
INSERT INTO tnp_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kəni nian nətəmimi mɨn rəha Iesu kəmoteruh natimnati mɨn əha mɨnotəhrun məmə nak əha okol, kəni kəmotəni=pən kəm in məmə, “?Iərmənɨg oiəkotəhro? ?Iəkotəluagɨn e nau, uə?” ");
INSERT INTO tnp_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Əmeiko ilah kəti təmauəh e nau rəha nəluagɨniən mohatuv rəkɨs nɨmatəlgɨn maru rəha ioluək rəha pris asoli agɨn. ");
INSERT INTO tnp_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Mətəu Iesu təni məmə, “!Ei! !Nəhmen, otupəh əmə!” Kəni in təmələhu=pən nəhlmɨn e matəlgɨ suah u, kəni mol vivi mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kəni Iesu təməghati kəm pris asoli mɨn, mɨne nətəmimi asoli mɨn rəha soldiə rəha Nimə Rəha Uhgɨn, mɨne nətəmi asoli rəha nɨmənin rəha Isrel, u kəməhuva məmə okotaskəlɨm Iesu. In təməni=pən kəm lah məmə, “Təhro, nəman? ?Nɨkitəmah təhti məmə iəu iohamu itəmi kəti matol nəluagɨniən o nələs iahuiən kəpmən, uə? !Kəpə! ?Kəni nəutəmki nau asoli mɨn mɨne neim mɨn məutəhuva məmə onəkotaskəlɨm iəu? ");
INSERT INTO tnp_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","?Nian rəfin iətan kitah min itəmah e Nimə Rəha Uhgɨn, mətəu təhro nəsotaskəlɨmiən iəu? Mətəu rəueiu əha, in nian əhruahru rəhatəmah, kəni nəsanəniən rəha napinəpuiən in tətarmənɨg.” ");
INSERT INTO tnp_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kəni kəməhuva motaskəlɨm Iesu motələs məhuvən e lahuənu rəha pris asoli agɨn. Kəni Pitə təmuərisɨg e lah mətəu təməsuvəniən iuəkɨr o lah. ");
INSERT INTO tnp_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nətəmi mɨn əha kəmotahli nɨgəm əpəha e iat rəha pris asoli agɨn, kəni məutəharəg tɨtəlau e nɨgəm. Kəni Pitə tuvən mətəharəg ilah min. ");
INSERT INTO tnp_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kəni pətan mɨtə kəti u in ioluək rəha pris asoli agɨn, təmuva meruh Pitə tətəharəg, kəni nəhagəhagiən rəha nɨgəm təmasiəgəpɨn in, kəni pətan əha təmateruh mətɨg in, kəni məni=pən kəm lah məmə, “Suah u, in mɨn ilau Iesu kəmətuan.” ");
INSERT INTO tnp_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Mətəu Pitə təni=pən kəm pətan u məmə, “Iəsəhruniən suah u nətəni.” ");
INSERT INTO tnp_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kəni uərisɨg lan təsuvəhiən, suah kəti mɨn tuva məni=pən kəm Pitə məmə, “Ei, ik mɨn, ik iətəmi kəti rəhan.” Mətəu Pitə təni məmə, “Ei, səniəmə iəu iətəmimi rəhan.” ");
INSERT INTO tnp_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kəni ko uərisɨg lan, auə kəti tɨnuva mɨnuvən rəkɨs, kəni suah kəti təməni əskasɨk kəm lah məmə, “Nɨpəhriəniən məmə suah u təmatuərisɨg e Iesu, mətəu in iətəm Kaləli!” ");
INSERT INTO tnp_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Mətəu Pitə təni məmə, “!Ei! !Iəsəhrun agɨniən nəghatiən u nətəni!” Kəni nian Pitə təmətəghati əhanəh, kəni mənɨg təkakə. ");
INSERT INTO tnp_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kəni Iərmənɨg təmeirair məsal=pən əhruahru meruh Pitə. Kəni Pitə, nɨkin təhti nəghatiən rəha Iərmənɨg iətəm təməni lan məmə, “O lapɨn əmə u, nian mənɨg otəsəkakə əhanəhiən, ik onəkəni mau kɨsɨl məmə nəkəruru iəu.” ");
INSERT INTO tnp_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Kəni Pitə tiet muvən ihluə, təmasək təmasək. ");
INSERT INTO tnp_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Kəni e nian əha, nətəmimi nətəm kəmotaskəlɨm Iesu kəmotagət əuvsan lan, kəni mautoh. ");
INSERT INTO tnp_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ilah kəmotəlis-ərain nəhmtɨn kəni motoh, məutəni=pən məmə, “!Ei, iəni! ?Əni-to məmə pəh tatoh ik?” ");
INSERT INTO tnp_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Kəni ilah kəmotəni nəghatiən tərah tepət məutərəkɨn in lan. ");
INSERT INTO tnp_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kəni ləplapɨn agɨn, nətəmi asoli rəha nɨmənin rəha Isrel kəməhuva motuhapumɨn e kaunsɨl rəhalah, ilah u pris asoli mɨn mɨne nəgətun mɨn rəha Lou. Kəni nətəmimi kotos Iesu məhuva təhtul e nəhmtɨ kaunsɨl əha. ");
INSERT INTO tnp_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Kəni nətəmi rəha kaunsɨl kəmotətapuəh ohni məmə, “Nəmə ik Krɨsto u iətəm Uhgɨn təməni məmə otahli=pa, əni kəm tɨmah.” Mətəu Iesu təni=pən kəm lah məmə, “Nəmə iəkəni kəm təmah, kəni nəsotəniən nɨpəhriəniən lak. ");
INSERT INTO tnp_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Kəni nəmə iəkətapuəh itəmah, ko nəsotuhalpɨniən. ");
INSERT INTO tnp_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mətəu tətuəuin rəueiu, iəu Nətɨ Iətəmimi, iəu oiəkuvən məharəg e nɨkalɨ Uhgɨn maru, Uhgɨn u iətəm rəhan nəsanəniən iahgin agɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kəni ilah rəfin kəmotətapuəh ohni məmə, “?Təhro? Ik Nətɨ Uhgɨn?” Kəni Iesu təni=pən məmə, “Itəmah nəutəni məmə iəu u inu.” ");
INSERT INTO tnp_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kəni kotəni məmə, “?Təhro kitah kəutəsal e nəghatiən kəti mɨn məmə otasiru e rəhatah nəghatiən? Kɨnotətəu əhruahru nəghatiən əha e nohlɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kəni nətəmimi rəfin rəha kaunsɨl kəmotəhtul motit Iesu məhuvən kəm Pailət. ");
INSERT INTO tnp_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Kəni motəni pətɨgəm nɨpəgnəmtɨn mɨn iətəm otoh Iesu məmə, “Iəmoteh məmə suah u tatit rəhatah nətəmimi mɨn, kəni mol ilah kəutalməli, kəni mətəuhlin rəhalah nətəlɨgiən kautol tɨkɨmɨr ilah kəpmən rəha Rom, mətahtɨpəsɨg e tɨmah məmə iəsotətəouiən takɨs tuvən kəm Sisə iətəm tətarmənɨg e nɨtəni u. Kəni in mətəni pətɨgəm məmə in Krɨsto iətəm Uhgɨn təmahli=pa məmə in kig kəti.” ");
INSERT INTO tnp_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kəni Pailət təmətapuəh ohni məmə, “?Təhro? ?Ik kig rəha nətəm Isrel?” Mətəu Iesu təni=pən kəm in məmə, “Ik nəməni lanko.” ");
INSERT INTO tnp_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kəni Pailət təməni=pən kəm pris asoli mɨn mɨne nətəmimi rəfin məmə, “Iəsehiən nɨpəgnəmtɨn kəti mɨne, iətəm tətəni məmə suah u təmərəkɨn Lou.” ");
INSERT INTO tnp_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mətəu ilah kəmotagət əfəməh məutəni məmə, “Kəpə. Mətəu suah u tətan əpnapɨn mətəgətun nətəmimi rəfin ikɨn mɨn əha Jutiə təmətuəuin əpəha Kaləli mətuva mətəuarus=pa u ikɨnu, kəni mol nətəlɨgiən rəha nətəmimi kəutəluei məutalməli.” ");
INSERT INTO tnp_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Kəni nian Pailət təmətəu nəghatiən əha, tətapuəh məmə, “?Təhro? ?Suah u in iətəm Kaləli?” ");
INSERT INTO tnp_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Kəni nian təmətəu məmə Iesu tɨsɨpən Kaləli, ikɨn əha iətəm Herot Antipas tətarmənɨg ikɨn, in təmahli=pən Iesu məmə otuvən meruh Herot, mətəu-inu e nian əha, Herot mɨn in tətatɨg Jerusɨləm. ");
INSERT INTO tnp_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Kəni nian Herot Antipas təmeruh Iesu, nɨkin təmagiən pɨk, mətəu-inu nuvəh nəuvetɨn in təmolkeikei məmə oteruh. Herot təmətəu əmə nəniən rəhan, kəni in təmolkeikei pɨk məmə teruh otol nati apɨspɨs kəti. ");
INSERT INTO tnp_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kəni o natimnati mɨn u, Herot Antipas təmətapuəh lan o nəghatiən mɨn tepət o Iesu, mətəu Iesu təməpnapɨn əmə məsuhalpɨniən rəhan nəghatiən. ");
INSERT INTO tnp_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kəni pris asoli mɨn mɨne nəgətun mɨn rəha Lou kəmotəhtul motagət əskasɨk e nɨpəgnəmtɨn mɨn rəhalah mautuh Iesu lan. ");
INSERT INTO tnp_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kəni uərisɨg lan, Herot Antipas mɨne rəhan mɨn soldiə kotagət əuvsan e Iesu, kəni məutəuvsan lan. Kəni Herot təməni=pən kəm rəhan mɨn soldiə məmə okəhuvən=pən e napən təuvɨr rəha kig kəm in, kəni motit mɨn məhuvən kəm Pailət. ");
INSERT INTO tnp_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Aupən ikɨn, Herot Antipas mɨne Pailət kəmatuol tɨkɨmɨr kəm lau mɨn, mətəu e nian əha, ilau kəmiəuva mɨnuolkeikei ilau mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Kəni Pailət təmauɨn e pris asoli mɨn, mɨne nətəmi asoli rəha nətəm Isrel, mɨne nətəmimi rəfin, kəni ilah rəfin kəməhuva kətiəh. ");
INSERT INTO tnp_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Kəni in təməni=pən kəm lah məmə, “Suah u, nəmotos məhuva təhtul e nəhmtək, kəni nəmotəni məmə tətəuhlin nətəlɨgiən rəha nətəmimi rəhatəmah kautol tɨkɨmɨr kəm kəpmən. Mətəu iəmakil rəkɨs rəhan nətəlɨgiən u e nəhmtɨtəmah, kəni məsehiən məmə təmatgəhli lou kəti, kəni nɨpəgnəmtɨn mɨn iətəm nəutəni lan təsoliən nɨpəhriəniən. ");
INSERT INTO tnp_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Kəni Herot Antipas mɨn, in təmakil meruh məmə noliən rah kəti təsəhkul-pəniən lan. Tol lanəha, in tahli=pa tuva mɨn kəm tah, kəni təhruahru əmə məmə suah u in təməsoliən nati kəti iətəm tərah məmə in otɨmɨs ohni. ");
INSERT INTO tnp_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Kəni o nati əha inəha, rəhak mɨn soldiə okotalis əmə, kəni uərisɨg kotahli=pən tatuvən.” ");
INSERT INTO tnp_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Mətəu ilah rəfin kəmotagət əfəməh məutəni məmə, “!Otɨləfətɨgəm suah u kəni motohamu! !Mətəu ahli pətɨgəm Parəpəs tuva meh itəmah!” ");
INSERT INTO tnp_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Suah u Parəpəs, kəmləfən e kaləpus mətəu-inu təməhtul aupən məmki nətəmimi məutəluagɨn mə kotələs iahu kəpmən rəha Rom e taun əha, kəni in təmohamu itəmi.) ");
INSERT INTO tnp_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Mətəu Pailət in təmolkeikei məmə otəhlman e Iesu tatuvən, kəni in təməghati mɨn kəm lah. ");
INSERT INTO tnp_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mətəu ilah kəmotagət əfəməh pɨk məmə, “!Ətu-pəri in e nɨgi kəməluau! !Ətu-pəri in e nɨgi kəməluau!” ");
INSERT INTO tnp_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mətəu Pailət təməghati mɨn kəm lah mɨnau kɨsɨl məmə, “?O nak? ?Suah u in təmol nati tərah nak? Iəu iəseruhiən məmə in təmol nati kəti iətəm təhruahru məmə in otɨmɨs ohni. Mətəu rəhak soldiə mɨn, ilah okotalis əmə, mə kəmanotəhlman lan tatuvən.” ");
INSERT INTO tnp_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Mətəu ilah kəmotəkeikei məutagət əskasɨk, kəni məutagət əfəməh e Pailət məmə otətu-pəri Iesu e nɨgi kəməluau. Kəni məutagət məutagət pɨk, kəni motapirəkɨs Pailət. ");
INSERT INTO tnp_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Tol lanəha, Pailət təməni məmə Iesu otəkeikei mɨmɨs təhmen=pən məmə ilah kəutəni mɨne. ");
INSERT INTO tnp_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kəni in təmol nətəlɨgiən rəhalah, kəni mahli pətɨgəm Parəpəs u in təmətatɨg e kaləpus o nəluagɨniən o kəpmən mɨne mohamu itəmi. Kəni in megəhan=pən e Iesu e nəhlmɨ rəhan mɨn soldiə məmə ilah okotos məhuvən mohtəu nətəlɨgiən rəha nɨmənin nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kəni nian soldiə mɨn kəmotit Iesu mohiet e taun, kəni motafu iətəm Sairəni kəti, nərgɨn u Saimon. Kəni kəmotaskəlɨm motələhu pəri nɨgi kəməluau rəha Iesu e nəuegɨn məmə otələs, kəni motəni=pən məmə otɨtəu=pən Iesu. ");
INSERT INTO tnp_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kəni nɨmənin nətəmimi tepət kəmautaliuək məutuərisɨg e Iesu e suaru, kəni nɨpətan mɨn kəmautəhuərisɨg e lah, məutasək o Iesu kəni məutauɨn lan. ");
INSERT INTO tnp_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Mətəu Iesu təmeirair məsal=pən meruh ilah, kəni məni=pən kəm lah məmə, “Nɨpətan Jerusɨləm. Sotasəkiən ohniəu, mətəu otasək aru o təmah, mɨne nenətɨtəmah mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Otətəlɨg-to lak. Nian tərah mɨn otətuva kəni kəmanəni məmə, ‘!Otagiən itəmah nətəm nəsoteməkiən uə nəsotəfəniən nah kəm iəpəou!’ ");
INSERT INTO tnp_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","E nian əha, nətəmimi okotəni=pən kəm nɨtəuət asoli mɨn məmə, ‘Əui, ohmərəgrəg=pa e tɨmah.’ ");
INSERT INTO tnp_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Iətəni lanu mətəu nətəmimi mɨn u kautol nati tərah mɨn u kəm iəu rəueiu e nian u nɨgi tətəmtə əhanəh. ?Kəni otəpanəhro əhanəh nian nɨgi tɨnɨmətu?” ");
INSERT INTO tnp_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kəni soldiə mɨn kəmotələs suah mil keiu iətəm ilau kəmuatgəhli lou, məmə okuhamu ilahal Iesu. ");
INSERT INTO tnp_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kəni kəməhuva ikɨn kəti, nərgɨn u Louipɨl-uipɨl. Ikɨn əha, motətu-pəri Iesu e nɨgi kəməluau. Kəni kəmotətu-pəri iatgəhli lou mil əha ikɨn, kəti e nɨkalɨ Iesu maru, kəni kəti e nɨkalɨn məuɨl. ");
INSERT INTO tnp_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kəni Iesu təni məmə “Tatə. Alu e rəhalah noliən tərah mɨn kautol lak, kəni məsalpɨniən, mətəu-inu kəsotəhruniən nati nak ilah kautol.” Kəni kəmotəuəri napən rəhan moturin tais ohni. ");
INSERT INTO tnp_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kəni nətəmimi mɨn u kəməutəhtul əha ikɨn, mauteruh natimnati mɨn u, mətəu nətəmi asoli mɨn rəha nətəm Isrel kəutol əuvsan e Iesu məutəni məmə, “!In təmosmiəgəh nətəmimi tepət rəkɨs. Mətəu nəmə in Krɨsto iətəm Uhgɨn təməni məmə otahli=pa, kəni in Iətəm Uhgɨn Təməni Rəkɨs, təuvɨr pəh otosmiəgəh aru in!” ");
INSERT INTO tnp_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Kəni soldiə mɨn, ilah mɨn kəutəghati əuvsan e Iesu, kəni məhuva iuəkɨr ohni məutətapuəh məmə in tolkeikei wain u iətəm tarfu, ");
INSERT INTO tnp_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","mautəni məmə, “!Nəmə ik kig pəhriən rəha Isrel, osmiəgəh aru-to ik əha rəueiu!” ");
INSERT INTO tnp_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kəni nəghatiən kəti əha ikɨn kəmətei kətu-pəri e rəhn-kapə nɨgi kəməluau, tətəni məmə, Inu kig rəha nətəm Isrel ");
INSERT INTO tnp_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kəni iatgəhli lou mil kəti iətəm kətuəhkul-pəri e nɨgi kəluau, in təməghati rah e Iesu, mətəni məmə, “!Ei! ?Ik Krɨsto iətəm Uhgɨn təməni məmə otahli=pa, uə kəpə?” ");
INSERT INTO tnp_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mətəu iatgəhli lou əha kəti mɨn təməni=pən kəm in kəti, kəni mahtɨpəsɨg lan məmə, “?Təhro? ?Nəsəgɨniən e Uhgɨn, nati əpnapɨn onəkɨmɨs? Nalpɨniən u rəhatahal in təhmen-əhmen əmə. ");
INSERT INTO tnp_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mətəu təməhruahru əmə məmə kilau okiamɨs o rəhalau noliən tərah mɨn iətəm kəmuol. Mətəu suah u, in təsoliən nati kəti tərah kəti mɨne.” ");
INSERT INTO tnp_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kəni məni=pən kəm Iesu məmə, “Iesu, o nian onəkuva mətol kig lan, kəni nɨkim otətəhti iəu.” ");
INSERT INTO tnp_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Kəni Iesu təməni=pən kəm in məmə, “Nɨpəhriəniən iətəni kəm ik, məmə rəueiu əmə kilau min ik əpəha e negəu e neai.” ");
INSERT INTO tnp_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Kəni iuəkɨr tueləf klok e nərauiə, mɨtɨgar təsasiəiən, kəni napinəpuiən tɨnan rəfin ikɨn əha mətəuarus=pən tri klok ləhnaiuv. Kəni napən iətəm tətəhkul pəsɨg=pən Ikɨn Tasim Agɨn Ikɨn e Nimə Rəha Uhgɨn, təməhapu nəuvetɨn keiu. ");
INSERT INTO tnp_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Kəni Iesu təmasək əfəməh məmə, “!Tatə. Iatələhu=pən nəmiəgəhiən rəhak e nəhlməm!” Nian təməni rəkɨs nəghatiən əha, kəni rəhan nehagiən tiet. ");
INSERT INTO tnp_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kəni nian iətəmi asoli rəha soldiə mɨn əha rəha nətəm Rom təmeh natimnati mɨn əha, kəni in təməni-vivi Uhgɨn mətəni məmə, “!Nɨpəhriəniən, suah u in təhruahru pəhriən!” ");
INSERT INTO tnp_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kəni nətəmimi mɨn u kəməhuva ikɨn əha məmə okoteruh, nian kəmoteruh natimnati mɨn əha, kəməutətəu tərah e nɨkilah kəni məutəhti-əhti mankɨlahalah, kəni mɨnəutəhuvən. ");
INSERT INTO tnp_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Kəni niəli mɨn rəha Iesu, mɨne nɨpətan iətəm kəmotsɨpən Kaləli motohtəu=pən Iesu məhuva, ilah kəməutəhtul isəu nəuvetɨn kəni məuteruh natimnati mɨn əha. ");
INSERT INTO tnp_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Kəni iətəm Aramatiə kəti əha ikɨn, nərgɨn u Josɨp. Aramatiə in taun kəti rəha Isrel, kəni suah kəha in iətəmimi kəti rəha kaunsɨl rəha nətəm Isrel. In iətəmi təuvɨr, rəhan nəmiəgəhiən təhruahru, kəni in iətəmi kəti təmətəhtahnin məmə oteruh Narmənɨgiən Rəha Uhgɨn. Kəni in təməsegəhaniən e nəghatiən rəha kaunsɨl iətəm kəmotegəhan e Iesu məmə okuh. ");
INSERT INTO tnp_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Kəni in təmuvən meh Pailət mətapuəh ohni məmə otegəhan e nɨpətɨ Iesu tos. ");
INSERT INTO tnp_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kəni Josɨp təmuvən mosiahu nɨpətɨ Iesu e nɨgi kəməluau, mos muva məuveg e napən təuvɨr kəti, nərgɨn u linən. Kəni mos muvən mələhu=pən e nɨpəg kəpiel iətəm kəmətei rəkɨs o noliən suvət ikɨn, mətəu kəsɨtənɨm əhanəhiən suah kəti ikɨn. ");
INSERT INTO tnp_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Inəha e nian rəha nətəm Isrel iətəm kautol əpenə-penə lan o nian rəha Sapət, kəni iuəkɨr Sapət tətuəuin. ");
INSERT INTO tnp_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kəni nɨpətan u kəmotsɨpən Kaləli kəmautuərisɨg e Iesu, kəməutohtəu=pən suah u, kəməhuvən kəni moteruh nɨpəg kəpiel, kəni moteruh noliən iətəm in təmələhu Iesu ikɨn. ");
INSERT INTO tnp_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kəni uərisɨg, nɨpətan kəmohtəlɨg=pən lahuənu, kəni mautol əpenə-penə nɨmənati mɨn nəuvein mɨne fomat iətəm nəmiəvɨlah təuvɨr məmə okotol=pən e nɨpətɨ Iesu. Kəni e nian rəha Sapət, ilah kəmotəmeig məutohtəu=pən nəghatiən rəha Lou. ");
INSERT INTO tnp_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kəni e Sante ləplapɨn agɨn, nɨpətan kəməhuvən əpəha e suvət, motos natimnati u nəmiəvɨlah təuvɨr u kəmotol əpenə-penə rəkɨs lan. ");
INSERT INTO tnp_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nian kəməhuva e suvət, moteruh kəpiel u kətahtɨpəsɨg e nɨpəg kəpiel lan, mətəu kəmɨsuə rəkɨs rəkɨs. ");
INSERT INTO tnp_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","E nian kəməhuvən imə e nɨpəg kəpiel, mətəu kəsotehiən nɨpətɨ Iərmənɨg Iesu. ");
INSERT INTO tnp_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kəni ilah kɨnotəruru əfəməh məutətəlɨg e natimnati mɨn əha. Kəni əmeiko kəmotauɨt pɨk e iətəmi keiu kəmiaietɨgəm=pa əha ikɨn məutuəhtul ilah nɨpətan, kəmian e napən iətəm tətoraip-oraip. ");
INSERT INTO tnp_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kəni nɨpətan kəmotəgɨn pɨk, motasiəulɨn nəulɨlah məutəsal iahu mauteh nɨftəni. Kəni suah mil kuəmə, “Təhro nəutəsal e iətəmi tətəmiəgəh u ikɨnu imə nətəm kəmohmɨs? ");
INSERT INTO tnp_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","In tɨkə u ikɨnu. !In tɨnəmiəgəh mɨn! Nɨkitəmah təhti nəghatiən in təməni kəm təmah nian in təmətatɨg əhanəh əpəha Kaləli məmə, ");
INSERT INTO tnp_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Natimnati mɨn u okotəkeikei muva motol nɨpəhriəniən lan. Okegəhan=pən e Nətɨ Iətəmimi tuvən e nəhlmɨ iol təfagə tərah mɨn, kəni okətu-pəri e nɨgi kəməluau tɨmɨs, mətəu e nian tatol kɨsɨl lan, kəni in otəmiəgəh mɨn.’” ");
INSERT INTO tnp_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kəni nɨkilah tɨnəhti nəghatiən rəha Iesu. ");
INSERT INTO tnp_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kəni kəmohiet e suvət məhuvən motəni=pən natimnati mɨn əha kəm nətəmi lepɨn rəha Iesu, mɨne rəhan mɨn rəfin. ");
INSERT INTO tnp_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Kəni nɨpətan mɨn əha u kəmotəni pətɨgəm natimnati mɨn u kəm aposɨl mɨn, inko Meri Maktələ, Joana, Meri mamə rəha Jemɨs, mɨne nɨpətan mɨn nəuvein iətəm kəməhuvən e suvət. ");
INSERT INTO tnp_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mətəu aposɨl mɨn kəmotətəu nəghatiən əha təhmen=pən əmə e nəghatiən alməli kəti iətəm nɨpətɨn tɨkə, kəni məsotəniən nɨpəhriəniən lan. ");
INSERT INTO tnp_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mətəu Pitə təməhtul maiu muvən əpəha e suvət, məməhli-əməhli məsal=pən e nɨpəg kəpiel kəni meruh əmə napən iətəm kəməuveg nɨpətɨ Iesu lan, mətəu nati mɨn kəti tɨkə əha ikɨn. Kəni in təmaliuək mɨtəlɨg mɨnatuvən lahuənu, kəni matətəlɨg pɨk e natimnati mɨn əha. ");
INSERT INTO tnp_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","E nian əmə əha inəha, suah mil keiu rəha Iesu kəmətualiuək mətian lahuənu kəti, nərgɨn u Emeəs. Lahuənu u mətəuarus=pən Jerusɨləm, in iuəkɨr o lepɨn kilomitə. ");
INSERT INTO tnp_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kəni nian ilau kəmətualiuək mətian, kəni ilau mətuəghati e natimnati mɨn u kəmol ilah. ");
INSERT INTO tnp_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nian ilau kəmətuəghati lanəha, kəni Iesu təmuva iuəkɨr o lau, məhlaliuək pəti mɨhluvən. ");
INSERT INTO tnp_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mətəu kəməsuəhruniən məmə pəh əha ilahal min kəməhlaliuək mətəu-inu Uhgɨn təmahtɨpəsɨg e nətəlɨgiən rəhalau. ");
INSERT INTO tnp_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Kəni Iesu təməni=pən kəm lau məmə, “Suah mil. ?Nati nak u nətuəni?” Kəni əmeiko kəmuəlali muəhtul, nəhmtɨlau təməpəou. ");
INSERT INTO tnp_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kəni suah mil əha kəti, nərgɨn u Kleopas, təməni=pən kəm in məmə, “Iətəhrun məmə ik əmə u iapɨspɨs kəti u Jerusɨləm iətəm nəsəhruniən natimnati mɨn kəmol ilah e nian mɨn u kɨnəhuva mɨnəhuvən rəkɨs.” ");
INSERT INTO tnp_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kəni in təməni=pən kəm lau məmə, “?Natimnati mɨn nak əha?” Kəni kəmuəni=pən kəm in məmə, “Natimnati mɨn u kəmol e Iesu iətəm Nasərɨt. In iəni kəti rəha Uhgɨn, kəni rəhan uək təsanən vivi mɨne rəhan mɨn nəghatiən kotəfɨgəm, kəni nɨki Uhgɨn mɨne nɨki nətəmimi tətagiən lan. ");
INSERT INTO tnp_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mətəu rəhatɨmah pris asoli mɨn mɨne nəgətun mɨn rəha Lou kəmotəfən in tuvən e nəhlmɨ nətəm Rom məmə okotakil məmə in otɨmɨs. Kəni kəmotətu-pəri e nɨgi kəluau tɨmɨs. ");
INSERT INTO tnp_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","“Mətəu itɨmah iəmotələhu=pən pau rəhatɨmah nətəlɨgiən tətatɨg əskasɨk lan məmə in otos rəkɨs itɨmah nətəm Isrel e nəhlmɨ tɨkɨmɨr mɨn rəhatɨmah. Kəni rəueiu in nian tatol kɨsɨl lan. ");
INSERT INTO tnp_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kəni nati kəti mɨn, nɨpətan nəuvein u iəməutan, kəmotol narmɨtɨmah təmiuvɨg o nəghatiən kəti. Rəueiu ləplapɨn agɨn, kəməhuvən əpəha e suvət u kəmɨtənɨm Iesu ikɨn, ");
INSERT INTO tnp_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","mətəu kəməsoteruhiən nɨpətɨn. Kəni kəmohtəlɨg=pa motəni məmə, ‘Iəmoteh nati kəti təhmen e nəməhlairiən, agelo mil keiu kətuəni=pa məmə Iesu təməmiəgəh.’ ");
INSERT INTO tnp_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kəni rəhatɨmah nəuvein nətəmimi kəməhuvən e suvət, kəmoteh natimnati rəfin agɨn təhruahru təhmen əmə e nəghatiən əha nɨpətan mɨn əha kəmotəni, mətəu kəsotehiən Iesu.” ");
INSERT INTO tnp_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kəni in təməni=pən kəm lau məmə, “Suah mil. !Rəhatəlau kapə tɨkə, nəkotəhro tiəkɨs agɨn o təmah o nəniən nɨpəhriəniən e natimnati mɨn u iəni mɨn rəha Uhgɨn kəmotəni! ");
INSERT INTO tnp_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","?Nəkuəhrun uə kəpə məmə, Krɨsto, u Uhgɨn təməni məmə otahli=pa otəkeikei mos nahməiən e nɨpətɨn, kəni uərisɨg lan, in təpanuvən e negəu e neai mos nərgɨn rəha nɨsiaiən?” ");
INSERT INTO tnp_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kəni Iesu təməni=pən vivi kəm lau Nauəuə Rəha Uhgɨn u kəutəghati lan, təmətuəuin e nauəuə rəha Mosɨs kəni muvən mətəuarus=pən nauəuə mɨn rəha iəni mɨn rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kəni kɨnəhluva iuəkɨr o lahuənu u suah mil u kətian ikɨn. Kəni kɨnuafu məmə Iesu tɨnətaliuək mɨnətapirəkɨs ilau məsəhtuliən, ");
INSERT INTO tnp_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","mətəu ilau kətioh nɨkin məmə, “Ei, təuvɨr məmə nəkuva kitahal min ik, mətəu tɨnapinəpu rəkɨs, kəni təsuvəhiən rəueiu mɨtɨgar tiuvɨg.” Kəni ko tuvən meruh ilau məhləharəg. ");
INSERT INTO tnp_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nian kɨnəhləharəg məmə okɨhlauən, kəni in təmos pɨret kəni məni-vivi Uhgɨn ohni, kəni ko məmkərɨs məfən kəm lau. ");
INSERT INTO tnp_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kəni əmeiko Uhgɨn tol kɨnuəhrun məmə in Iesu, kəni əmeiko in tatɨg mɨkə mɨn, kəni kəməsueruhiən mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kəni kəmuəni=pən kəm lau mɨn məmə, “!Ei! ?Nian in təməni=pa vivi Nauəuə Rəha Uhgɨn kəm lau e suaru, kəni kəmuətəu təuvɨr lan nɨkilau tətagiən pɨk, uə kəpə?” ");
INSERT INTO tnp_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kəni rəueiu agɨn mɨn, kəmuəhtul miaiet ikɨn əha miatəlɨg=pən mɨn Jerusɨləm. Kəni ikɨn əha, ilau kəmueh nətəmimi lepɨn rəha Iesu mɨne nətəmimi mɨn nəuvein mɨn rəhan kəməhuva motuhapumɨn rəkɨs ilah mɨn məutəharəg, ");
INSERT INTO tnp_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","kəni məutəni məmə, “!Nɨpəhriəniən! !Iərmənɨg təməmiəgəh mɨn, kəni Saimon Pitə təmeh rəkɨs!” ");
INSERT INTO tnp_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kəni ilau kəmuəni=pən rəfin natimnati iətəm kəmol kəm lau e suaru, kəni muəni=pən nian ilau kəmuəhrun Iesu lan e nian iətəm in təməgəuvahli pɨret məfən kəm lau. ");
INSERT INTO tnp_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kəni nian kətuəni əhanəh nəghatiən mɨn əha, Iesu təmuva məhtul e nəlugɨn e lah mətəni kəm lah məmə, “Nəməlinuiən tətatɨg o təmah.” ");
INSERT INTO tnp_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Mətəu ilah kəmotauɨt lan kəni mɨnəutəgɨn, nɨkilah təhti məmə kɨnotafu narmɨn kəti. ");
INSERT INTO tnp_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Mətəu in təməni=pən kəm lah məmə, “?Təhro rəhatəmah nətəlɨgiən tətərah lanko? ?Təhro rəhatəmah nətəlɨgiən tətəhtul pəgpag? ");
INSERT INTO tnp_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Oteh-to nəhlmək mɨne nəhlkək məmə iəu əmə əpə. Otea=pa motek nɨpətɨk kəni motəhrun məmə iəu. Narmɨ iətəmimi nɨpətɨn mɨne nɨkɨlkɨlin tɨkə, təsoliən məmə inu nauteh iəu, nɨpətɨk mɨne nɨkɨlkɨlik əpə ikɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Təməni nəghatiən əha, kəni məgətun nəhlmɨn mɨne nəhlkɨn kəm lah. ");
INSERT INTO tnp_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kəni narmɨlah təmiuvɨg nɨkilah təmagiən pɨk kəni motalu məmə nati u in nɨpəhriəniən. Ilah kəsotəni-vivi əhanəhiən nɨpəhriəniən lan. Kəni in təməni=pən kəm lah məmə, “?Nauəniən kəti u nəutos, uə?” ");
INSERT INTO tnp_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kəni kəmotos nəmu nəuvetɨn iətəm kəmuvan rəkɨs motəfən kəm in, ");
INSERT INTO tnp_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","kəni e nəhmtɨlah, təmos mun. ");
INSERT INTO tnp_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kəni Iesu təməni=pən kəm lah məmə, “Aupən ikɨn, nian iəmətatɨg əhanəh kitah min itəmah, iəməni nəghatiən u kəm təmah məmə, natimnati rəfin iətəm kəutəghati lak e Nauəuə Rəha Uhgɨn, okotəkeikei məhuva mautol nɨpəhriəniən lan, inu nəghatiən mɨn e nauəuə rəha Mosɨs, mɨne nauəuə mɨn rəha iəni mɨn rəha Uhgɨn, mɨne Nauəuə Rəha Nəpuən Mɨn.” ");
INSERT INTO tnp_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kəni in təmerəh e rəhalah nətəlɨgiən məmə okotəhrun nəghatiən mɨn iətəm tətatɨg e Nauəuə Rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kəni təməni=pən kəm lah məmə, “Nəghatiən iətəm tətatɨg e Nauəuə Rəha Uhgɨn tətəni məmə nətəmimi okotol tərah e Krɨsto iətəm Uhgɨn təmahli=pa, mautol tətətəu nahməiən e nɨpətɨn mətuvən mətəuarus tɨmɨs, mətəu e nian tatol kɨsɨl lan, in otəmiəgəh mɨn e nɨmɨsiən. ");
INSERT INTO tnp_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kəni e nərgɨ Krɨsto u Uhgɨn təmahli=pa, nətəmimi okotəkeikei motəni pətɨgəm nəghatiən u məmə nətəmimi okotəkeikei motəuhlin kəni motohtəlɨg e rəhalah təfagə tərah mɨn, kəni Uhgɨn in otəsalpɨniən nɨtai təfagə, kəni malu e rəhalah noliən tərah mɨn. Nəghatiən u otəkeikei muvən kəm nətəmimi mɨn e nəuanɨləuɨs mɨn rəfin e nɨtəni mɨn rəfin, otətuəuin Jerusɨləm muvən əpəha ikɨn mɨn rəfin e nəhue nɨtəni mɨn. ");
INSERT INTO tnp_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Itəmah nəmoteh natimnati mɨn u, kəni onəkotəni pətɨgəm əhruahru nəghatiən mɨn lan. ");
INSERT INTO tnp_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kəni iəkahli=pa suah u iətəm rəhak Tatə təməniəkɨs məmə in otahli=pa kəm təmah, inu rəhan Narmɨn. Mətəu onəkotəhtahnin e taun əha motətəuarus=pən nəkotos nəsanəniən rəha Narmɨn Rəha Uhgɨn, kəni təriauəh e nəmiəgəhiən rəhatəmah.” ");
INSERT INTO tnp_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kəni Iesu təmit ilah mohiet e taun məhuvən əha lahuənu Petəni. Kəni məfəri nəhlmɨn məfaki o lah. ");
INSERT INTO tnp_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kəni nian təmətəfaki o lah, kəni məpəh ilah nian Uhgɨn təmos mɨnatuvən əpəha ilɨs e negəu e neai. ");
INSERT INTO tnp_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kəni kəmoteiuaiu motəfaki=pən kəm in, kəni uərisɨg lan, kəmohtəlɨg=pən Jerusɨləm nɨkilah tətagiən. ");
INSERT INTO tnp_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kəni nian rəfin, kəutəhuvən e Nimə Rəha Uhgɨn məutəni-vivi Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Aupən agɨn, e nətuəuiniən nian, Nəghatiən tɨnatɨg rəkɨs. Nəghatiən u təmətatɨg ilau Tatə Uhgɨn, kəni Nəghatiən u, in mɨn, in Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","E nəukətɨ nian, in təmətatɨg rəkɨs ilau Uhgɨn, ");
INSERT INTO tnp_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","kəni Uhgɨn təmol natimnati rəfin e Nəghatiən u, kəni natimnati rəfin iətəm Uhgɨn təmol, nati kəti tɨkə mɨne məmə Nəghatiən u təsoliən. ");
INSERT INTO tnp_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Inu, in Nəukətɨ Nəmiəgəhiən, kəni Nəmiəgəhiən u, in Nəhagəhagiən rəha nətəmimi rəfin. ");
INSERT INTO tnp_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nəhagəhagiən əha, tətasiəgəpɨn napinəpuiən, kəni napinəpuiən ko təsapirəkɨsiən. ");
INSERT INTO tnp_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Iətəmimi kəti iətəm Uhgɨn təmahli=pa təmuva, nərgɨn u Jon Bəptais. ");
INSERT INTO tnp_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Təmuva mətəhtul pətɨgəm məmə otanus pətɨgəm Nəhagəhagiən əha kəm nətəmimi, pəh ilah rəfin kotəni nɨpəhriəniən lan. ");
INSERT INTO tnp_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Səniəmə Jon Bəptais in Nəhagəhagiən əha, mətəu in təmuva əmə məmə otəhtul pətɨgəm məni pətɨgəm Nəhagəhagiən əha kəm nətəmimi rəfin. ");
INSERT INTO tnp_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nəghatiən əha təmətuva e nəhue nɨftəni, kəni in Nəhagəhagiən pəhriən, iətəm in tətasiəgəpɨn nətəmimi rəfin. ");
INSERT INTO tnp_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nati əpnapɨn məmə Uhgɨn təmol nɨftəni u e Nəghatiən əha, kəni Nəghatiən u təmətatɨg e nəhue nɨftəni u, mətəu nətəmimi rəha nəhue nɨftəni u kəsotəniən nɨpəhriəniən məmə in pəh. ");
INSERT INTO tnp_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Təmuva iman ikɨn, mətəu nətəmiman mɨn kəutəuhlin=pən nəmtahlah kəm in, məsotolkeikeiən. ");
INSERT INTO tnp_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mətəu nətəmimi nəuvein kəmotos in, kəni ilah rəfin nətəm kəmotos in, nɨkilah tagiən ohni, kəni motəhatətə e nərgɨn, kəni in təməfən nepətiən kəm lah məmə kotəhrun nuvaiən nenətɨ Uhgɨn mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nenətɨ Uhgɨn mɨn əha, ilah kəsotairiən e noliən u iəpəou mɨn kəutair lan, kəni məsəniən mɨn məmə e nətəlɨgiən rəha iətəmimi, təhmen e tatə kəti iətəm tolkeikei in otos iəpəou. Mətəu ilah kəutair vi mɨn e Uhgɨn, e rəhan əmə nəsanəniən. ");
INSERT INTO tnp_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nəghatiən əha, in təmuva iətəmimi, mətatɨg kitah min u nətəmimi rəha nəhue nɨftəni. Kəni itɨmah iəmoteruh rəhan nepətiən, kəni nəsanəniən asoli mɨne nəhagəhagiən rəhan e nəhmtɨtɨmah. Inu, in nəsanəniən asoli mɨne nəhagəhagiən rəha Nəuan Kətiəh Əmə, iətəm in təmsɨpən e Tatə Uhgɨn. In təriauəh e nəuvɨriən iətəm tətətuati lan kəm tah, kəni məriauəh mɨn e nɨpəhriəniən. ");
INSERT INTO tnp_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon təmatəhtul pətɨgəm mətəni əfəməh məmə, “Iətəmi u inu iətəm iəu iəmətəni məmə, ‘Iətəmi kəti tətuərisɨg lak, mətəu in ilɨs tapirəkɨs iəu, mətəu-inu, nian iəməsair əhanəhiən, in təmətatɨg itulɨn rəkɨs.’” ");
INSERT INTO tnp_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kəni in təməriauəh e nəuvɨriən iətəm in tətətuati lan kəm tah, kəni e nəuvɨriən əha rəhan, nian rəfin in tətəfa, mətəfa, mətəfa, kəm tah rəfin. ");
INSERT INTO tnp_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tol lanəha mətəu-inu Lou iətəm Uhgɨn təməfa aupən, Mosɨs in suaru ohni, mətəu Iesu Krɨsto in suaru rəha nətuatiən e nəuvɨriən əha mɨne nɨpəhriəniən rəha Uhgɨn kəm tah. ");
INSERT INTO tnp_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Iətəmi kəti təseruhiən Uhgɨn nian kəti mɨne. Mətəu Nəuan Kətiəh Əmə, in Uhgɨn, iətəm in iuəkɨr o nɨki Tatə Uhgɨn, in təmol əpu Uhgɨn kəm tah kəni kotəhrun. ");
INSERT INTO tnp_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Kəni nətəmimi asoli mɨn rəha nətəm Isrel nətəm kautatɨg Jerusɨləm, kəmotahli=pən pris mɨn nəuvein mɨne Lifait mɨn u, nətəm kəutasiru e pris mɨn e Nimə Rəha Uhgɨn, məmə okəhuva moteh Jon motətapuəh ohni, məmə, “?Ik iətəmi pəh ko?” Kəutətapuəh mətəu-inu nətəmimi tepət kəmautəni məmə Jon in Krɨsto iətəm Uhgɨn təməni məmə otahli=pa. Kəni əmeiko, Jon təməhtul pətɨgəm məni pətɨgəm in. ");
INSERT INTO tnp_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nian ilah kəmotətapuəh ohni, in təməsəhluaigiən, mətəu təməni=pən əhruahru əmə in kəm lah məmə, “Səniəmə iəu Krɨsto iətəm Uhgɨn təməni məmə otahli=pa.” ");
INSERT INTO tnp_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Kəni ilah kəmotəni məmə, “?Nəmə səniəmə ik Krɨsto, kəni ik pəh? ?Ik Elaijə?” Mətəu Jon təni məmə, “Kəpə, səniəmə iəu Elaijə.” Kəni ilah kəmotətapuəh mɨn ohni məmə, “?Nəmə səniəmə ik Elaijə, kəni ik pəh? ?Ik iəni rəha Uhgɨn iətəmi kəmətəni aupən məmə otəpanuva?” Mətəu Jon təni məmə, “Kəpə.” ");
INSERT INTO tnp_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kəni ilah kəmotəni məmə, “?Kəni ik pəh? Ik onəkeikei məni pətɨgəm ik kəm tɨmah, pəh itɨmah iəkəhuvən motəni=pən kəm nətəmimi kəmotahli=pa itɨmah iəkəhuva.” ");
INSERT INTO tnp_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Kəni təni=pən kəm lah məmə, “Iəu u iətəm iəni rəha Uhgɨn Aiseə təməni rəkɨs aupən məmə, ‘Iəu u nəuia iətəmi kəti tətauɨn əfəməh əpəha ikɨn təpiə-məpiə ikɨn, mətəni məmə, otol suaru təhruahru rəha Iərmənɨg.’” ");
INSERT INTO tnp_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nətəmimi nətəm kəmahli=pa ilah, Farəsi mɨn nəuvein əha ikɨn, ");
INSERT INTO tnp_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","kəni ilah kəmotətapuəh o Jon məmə, “?Nəmə səniəmə ik Krɨsto iətəm Uhgɨn təməni məmə otahli=pa, kəni səniəmə ik Elaijə, kəni səniəmə ik iəni iətəm kəmətəni pətɨgəm aupən, kəni təhro natol bəptais e nətəmimi?” ");
INSERT INTO tnp_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Kəni tuhalpɨn mətəni məmə, “Iəu iatol bəptais e nətəmimi e nəhu, mətəu iətəmi kəti u ikɨn e nəlugɨn e təmah, iətəm itəmah nəkotəruru in. ");
INSERT INTO tnp_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Iətəmi u tətuərisɨg lak, mətəu in ilɨs, in tepət mapirəkɨs iəu, kəni iəu ləhtəni lan, kəni iəsəhmen agɨniən məmə iəkol uək əkəku agɨn kəti rəhan.” ");
INSERT INTO tnp_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Natimnati mɨn u, kəmol əpəha e lahuənu kəti, nərgɨn u Petəni, in tətatɨg əpəha e nɨtəni=pən e nəhu Jotən. Ikɨn əha Jon təmatol bəptais e nətəmimi ikɨn. ");
INSERT INTO tnp_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kəməni lauɨg lan, Jon təmeruh Iesu tətaliuək mətuva, kəni in təni məmə, “!Ei! !Oteruh-to! Suah u inu, in Nətɨ Sipsip rəha Uhgɨn o noliən sakrifais lan o noliən tərah mɨn rəha nətəmimi. Kəni in otəpanos rəkɨs noliən tərah mɨn rəha nɨtənimtəni mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iətəmi u inu, iəu iəmətəni kəm təmah məmə, ‘Iətəmi kəti tətuərisɨg lak, mətəu in ilɨs tapirəkɨs iəu, mətəu-inu, nian iəməsair əhanəhiən, in təmətatɨg itulɨn rəkɨs.’ ");
INSERT INTO tnp_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nian iəu iəmətəghati lan, kəni iəu mɨn iəməruru məmə in iətəmi pəh; mətəu iəmuva matol bəptais e nətəmimi e nəhu məmə iəkol əpu suah u kəm nətəmimi mɨn rəha Isrel.” ");
INSERT INTO tnp_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Jon təmətəhtul pətɨgəm mətəni məmə, “Uhgɨn təmahli=pa iəu məmə iəkol bəptais e nətəmimi e nəhu, kəni nian iəmətəghati lan, iəu mɨn iəməruru məmə suah u inu. Mətəu Uhgɨn təməni=pa kəm iəu məmə, ‘Onəkeruh Narmɨn Rəhak oteiuaiu matɨg e iətəmimi kəti. Kəni suah u inu, in otol bəptais e nətəmimi e Narmɨn Rəha Uhgɨn.’ Kəni əmeiko, uərisɨg iəmeruh Narmɨn Rəha Uhgɨn təmsɨpəri e neai təhmen e mak, muva, meiuaiu məharəg-pəri lan. ");
INSERT INTO tnp_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Iəu əhruahru iəmeruh nati u, kəni iəməhtul pətɨgəm mətəni pətɨgəm məmə, ‘Suah u inu, in Nətɨ Uhgɨn pəhriən.’” ");
INSERT INTO tnp_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kəməni lauɨg lan, Jon tətəhtul əmə əha ləmen kətiəh əmə ilahal rəhan keiu iətəmimi mil. ");
INSERT INTO tnp_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kəni nian nəhmtɨ Jon təməhtul e Iesu taliuək mətuva kəni təni məmə, “!Ei! !Oteruh-to! !Suah u inu, in Nətɨ Sipsip rəha Uhgɨn!” ");
INSERT INTO tnp_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kəni nian rəhan iətəmimi mil kəmuətəu nəghatiən əha, kəmuəhtul mətiauərisɨg e Iesu. ");
INSERT INTO tnp_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Kəni Iesu teirair meruh suah mil u kətiatəu=pən in, kəni in təni məmə, “Ei! !Suah mil! ?Nətuəsal lak onak?” Kəni ilau kuəmə, “Rapai. ?Ik nətatɨg iə?” (Nəghatiən u “Rapai,” nɨpətɨn u “Iəgətun.”) ");
INSERT INTO tnp_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Kəni Iesu təməni=pən məmə, “Pəh kɨhluvən nəkueruh-to.” Kəni ilau kəmiauərisɨg lan mɨhluvən kueruh ikɨn in tətatɨg ikɨn. Iuəkɨr mɨtɨgar tiuvɨg ləhnaiuv, ilau kəmətuan ilahal min mətəuarus tapinəpu. ");
INSERT INTO tnp_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Suah mil u kəti iətəm təmətəu Jon kəni muərisɨg e Iesu, nərgɨn u Antɨru, pian u Saimon Pitə. ");
INSERT INTO tnp_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kəni rəueiu agɨn mɨn, in təmuvən meh pian Saimon, kəni məni=pən kəm in məmə, “!Ei! !Inotafu rəkɨs Məsaiə!” (Nəghatiən u, Məsaiə, nɨpətɨn u məmə, “Krɨsto,” iətəm Uhgɨn təməni məmə otahli=pa.) ");
INSERT INTO tnp_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Kəni təmit Saimon muva o Iesu. Kəni nian nəhmtɨ Iesu təməhtul lan, kəni məni=pən kəm in məmə, “Ik u inu Saimon, nətɨ Jon, mətəu rəueiu okauɨn ərəg-rəg lam məmə ‘Kefəs.’” (In “Pitə” e nəghatiən Kris u nɨpətɨn məmə “kəpiel.”) ");
INSERT INTO tnp_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kəməni lauɨg lan mɨn, Iesu nɨkin tɨnəhti məmə otuvən-to Kaləli. Təməsal e Fɨlɨp kəni meruh. Kəni Iesu təməni=pən kəm in məmə, “Va-to, mɨtəu=pa iəu.” ");
INSERT INTO tnp_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Fɨlɨp u, in iətəm Petsaitə, ima Antɨru mɨne Pitə. ");
INSERT INTO tnp_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Kəni in təmuvən məsal meruh Nətaniəl, kəni təni=pən kəm in məmə, “Itɨmah inoteruh suah əpələ u, aupən Mosɨs təmətei rəkɨs rəhan nəghatiən mɨn iətəm tətəghati lan e nauəuə rəha Lou. Kəni iəni mɨn rəha Uhgɨn aupən ilah mɨn kəmotətei rəkɨs nəghatiən mɨn iətəm tətəghati lan. In iətəm Nasərɨt, in nətɨ Josɨp, kəni nərgɨn u Iesu.” ");
INSERT INTO tnp_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Mətəu Nətaniəl təni məmə, “!Nati nak! ?Nɨkim təhti məmə nati təuvɨr kəti otsɨpən e Nasərɨt? !Kəpə!” Kəni Fɨlɨp təni məmə, “Intəh, təuvɨr əmə, pəh-to kian nəkeruh-to.” ");
INSERT INTO tnp_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nian Iesu təmeruh Nətaniəl tətaliuək mətuva, kəni təni məmə, “!Suah u, in iətəm Isrel pəhriən! !Neiuəiən tɨkə lan!” ");
INSERT INTO tnp_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Kəni əmeiko Nətaniəl təmauɨt mətapuəh o Iesu məmə, “?Nəməhra məhrun məmə iəu iətəmi tol lanu?” Kəni Iesu təni=pən kəm in məmə, “Nian ik nəmətəharəg e nəukətɨ nɨgi fik, kəni Fɨlɨp təsauɨn əhanəhiən lam, mətəu iəu iəmafu rəkɨs ik.” ");
INSERT INTO tnp_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Kəni Nətaniəl təni məmə, “!Iəgətun! !Ik Nətɨ Uhgɨn! Ik Kig rəha nətəm Isrel!” ");
INSERT INTO tnp_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Iesu təməni=pən kəm in məmə, “?Ik nəməhatətə lak mətəu-inu iəu iəməni əmə məmə iəmeruh rəkɨs ik nian nəmətəharəg=pən əha e nəukətɨ nɨgi fik? Ik onəmaneruh nati asoli mɨn tapirəkɨs inu.” ");
INSERT INTO tnp_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Kəni məni mɨn məmə, “Nɨpəhriəniən agɨn u iətəni=pɨnə kəm təmah məmə, onəpanoteruh negəu e neai otəuag, kəni nagelo mɨn rəha Uhgɨn kəutəri mautəhuvən e neai, kəni məuteiuaiu məutəhuva e Nətɨ Iətəmimi u təhmen e suaru tatɨlpɨn nuvəniən e neai mɨne nəhue nɨftəni.” ");
INSERT INTO tnp_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kəməni niəh lan, katol marɨt kəti əpəha Kenə, lahuənu kəti e Kaləli. Kəni mamə rəha Iesu in əpəha ikɨn. ");
INSERT INTO tnp_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Kəni ilah kotauɨn=pən mɨn e Iesu mɨne rəhan mɨn nətəmimi, məmə ilah mɨn okəhuvən e marɨt əha. ");
INSERT INTO tnp_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Kautol mautol lafet, kəni nətəmimi mɨn kotəmnɨm rəfin wain, kəni mamə rəha Iesu təni=pən kəm in məmə, “Rəhalah wain təmɨkə.” ");
INSERT INTO tnp_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Mətəu Iesu təni=pən kəm in məmə, “?Pətauəhli, təhro nətələhu=pa nati u kəm iəu? Nian rəhak təsuva əhanəhiən.” ");
INSERT INTO tnp_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mətəu rəhan mamə təni=pən kəm noluək mɨn rəha marɨt məmə, “Itəmah onəkotəkeikei motol natimnati rəfin iətəm in otəni.” ");
INSERT INTO tnp_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nɨlosɨ nati asoli ilah sikɨs, kəməlɨn əha ikɨn əha o nəhu, məmə nətəm Isrel ilah okoteikuas məutaruətuəh lan e nəhmtɨ Uhgɨn. Nɨlosɨ nati mɨn u, kəmol e kəpiel, kəni kətiəh təhrun nosiən uan-hanrɨt litə nəhu. ");
INSERT INTO tnp_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Kəni Iesu təni=pən kəm nətəm kautol uək məmə, “Otətu=pən nəhu e nɨlosɨ nati mɨn u.” Kəni kəmotətu ilah kotəriauəh vivi. ");
INSERT INTO tnp_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kəni təni=pən kəm lah məmə, “Otətu rəkɨs nəhu kəti motos məhuvən kəm iətəm tətarmənɨg e marɨt.” Kəni ilah kəmotol lanəha. ");
INSERT INTO tnp_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kəni nian iətəmi u təməmnɨm askəuvɨn, mətəu nəhu tɨnol rəkɨs wain lan. Mətəu iətəmi u in tətarmənɨg e marɨt u, in təruru məmə kəmos iə wain u. Nətəmi mɨn əmə u nətəm kəmotos nəhu məhuva, ilah əmə kotəhrun. Kəni iətəm tətarmənɨg e marɨt təmauɨn e iətəm təmol marɨt, ");
INSERT INTO tnp_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","məni=pən məmə, “Nian rəfin nətəmimi kotaupən motəfətɨgəm wain təuvɨr, kəni uərisɨg nətəmimi kotəmnɨm tepət ko, kəni kəpanəfətɨgəm inu təsəuvɨr pɨkiən. !Mətəu ik, nəmaharu kalɨn iətəm təuvɨr mətəuarus=pa u rəueiu!” ");
INSERT INTO tnp_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kəni inu nəmtətiən iətəm Iesu təmətuəuin agɨn lan mol. Kəni in təmol ikɨn Kenə, lahuənu kəti e Kaləli. E nəmtətiən əha, in təməgətun nepətiən rəha Uhgɨn lan, kəni rəhan nətəmimi mɨn, kəmotəhatətə əskasɨk lan. ");
INSERT INTO tnp_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Uərisɨg e marɨt əha, in təmeiuaiu muvən e taun asoli əha Kapeniəm əpəha Kaləli ilah rəhan mamə mɨne pian mɨn mɨne rəhan nətəmimi mɨn. Kəni kəmotatɨg nian nəuvein əha ikɨn əha. ");
INSERT INTO tnp_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Kəni tɨnuva iuəkɨr o nian rəha lafet rəha nətəm Isrel iətəm kətəni məmə lafet rəha Pasova. Kəni Iesu təməri muvən əpəha Jerusɨləm. ");
INSERT INTO tnp_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ihluə lan e Nimə Rəha Uhgɨn kəutəfaki ikɨn, Iesu təmafu nətəmimi kautol səlɨm e kau, mɨne sipsip, mɨne mak mɨn, məmə nətəmimi okotos nəhmtɨn o noliən sakrifais lan. Kəni nətəmimi nəuvein əha ikɨn, ilah kautol senɨs e məni rəha nətəmi ikɨ pɨsɨn pɨsɨn mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kəni in tos təulə nəuvein, mətəl o nalisiən iətəmi. Kəni in mɨtəu nətəmi mɨn u ilah kau mɨn mɨne sipsip mɨn məmə okohiet e Nimə Rəha Uhgɨn. Kəni in mauvəregɨn məni rəha nətəmi mɨn u nətəm kautol senɨs lan, kəni təmahuvihin-ahuvihin rəhalah tepɨl mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kəni mahi ilah mɨn u nətəm kautol səlɨm e iəuein məni=pən kəm lah məmə, “!Otəmki natimnati mɨn u mohiet! !Itəmah məsotoliən Nimə Rəha Tatə rəhak tuva məmə in nimə rəha noliən makɨt!” ");
INSERT INTO tnp_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Kəni nətəmimi rəhan, nɨkilah təməhti nəghatiən kəti e Nauəuə Rəha Uhgɨn, iətəm tətəni məmə, “Iəu iəkolkeikei pɨk Nimə Rəham e nɨkik, nɨkik pɨk agɨn lan.” ");
INSERT INTO tnp_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Kəni nətəmi asoli mɨn rəha nətəm Isrel nɨkilah təmahmə motətapuəh ohni məmə, “?Pəh təmol məmə nəkəhrun noliən nati u? !Ol nəmtətiən məmə otəgətun əhruahru kəm tɨmah!” ");
INSERT INTO tnp_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Mətəu Iesu təni məmə, “Nəmə itəmah nəkotərəkɨn Nimə u Rəha Uhgɨn, kəni nian kɨsɨl əmə, iəu iəkuvləkɨn mɨn təhtul.” ");
INSERT INTO tnp_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Kəni nətəmi asoli mɨn əha kotəni məmə, “!Ei, nəman! Nətəmimi kəmotol uək asoli o nu ilah rəfin fote-sikɨs motuvləkɨn Nimə u Rəha Uhgɨn. !Onəkəhro lanu muvləkɨn e nian kɨsɨl əmə!” ");
INSERT INTO tnp_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Mətəu Nimə əha Rəha Uhgɨn iətəm Iesu tətəghati lan, in nɨpətɨn. ");
INSERT INTO tnp_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kəni uərisɨg, nian in tɨnɨmɨs rəkɨs, kəni mɨnəmiəgəh mɨn, kəni rəhan nətəmimi mɨn, nɨkilah təhti nəghatiən əha rəhan iətəm təməni. Kəni ilah kəmotəhatətə e Nauəuə Rəha Uhgɨn, mɨne nəghatiən iətəm Iesu təməni=pən kəm lah. ");
INSERT INTO tnp_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nian əha Iesu təmətatɨg e Jerusɨləm e nian rəha lafet rəha Pasova u, nətəmimi tepət kəmoteruh nəmtətiən mɨn iətəm in təmol, kəni kəmotəhatətə lan. ");
INSERT INTO tnp_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mətəu Iesu in təməhrun nati iətəm tətatɨg e nɨkilah, kəni məsəhatətəiən e lah. ");
INSERT INTO tnp_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ko iətəmi kəti təsəhtul pətɨgəmiən məghati rəha nətəmimi lan, mətəu-inu Iesu təhrun rəfin nətəlɨgiən rəha nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Iətəmi asoli kəti rəha nətəm Isrel, nərgɨn u, Nikotiməs. In Farəsi kəti. ");
INSERT INTO tnp_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Kəni nian kəti lapɨn, in təmuvən məmə otəghati ilau Iesu. In təməni=pən məmə, “Iəgətun, itɨmah iəkotəhrun məmə ik iəgətun kəti iətəm Uhgɨn təmahli=pa ik nəkuva, mətəu-inu iətəmi kəti ko təsoliən nəmtətiən mɨn u ik natol nəmə Uhgɨn təsatɨgiən ohni.” ");
INSERT INTO tnp_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Kəni Iesu təni=pən kəm in məmə, “Nɨpəhriəniən agɨn u iətəni=pɨnə kəm ik məmə, nəmə iətəmimi kəti təsair vivi mɨniən, ko in təseruhiən Narmənɨgiən Rəha Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Kəni Nikotiməs, narmɨn təmiuvɨg pɨk, kəni mətapuəh ohni məmə, “?Iətəmi tɨnol iahgin rəkɨs, otəhro mair mətmətɨg mɨn? Ko təsuvən mɨniən e nərfɨ rəhan mamə kəni mair=pa mɨn!” ");
INSERT INTO tnp_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Kəni Iesu təni=pən kəm in məmə, “Nɨpəhriəniən agɨn u iətəni=pɨnə kəm ik məmə, nəmə iətəmi təsair viən e nəhu mɨne Narmɨn Rəha Uhgɨn, ko təsuvəniən matɨg ahgəl Narmənɨgiən Rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nɨpətɨtəmi təmair əmə e nɨrə rəha iətəmimi əmə, mətəu Narmɨn Rəha Uhgɨn əmə u in tatol məmə narmɨtəmi tətair vi mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Təsəuvɨriən məmə narməm otiuvɨg nian iəməni=pɨnə kəm ik məmə, ‘Onəkəkeikei motair vi mɨn.’ ");
INSERT INTO tnp_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Təhmen əmə e nɨmətagi u nəseruhiən məmə tatsɨpən ikɨn kəti, matelel nati matuvən ikɨn kəti iətəm in tolkeikei məmə otuvən=pən ikɨn. Natətəu əmə, mətəu ik nəsoteruhiən məmə təmsɨpən iə, kəni matuvən iə. Kəni e suaru kətiəh əmə, kitah kəsoteruhiən Narmɨn Rəha Uhgɨn, mətəu kauteruh əmə rəhan uək e nəmiəgəhiən rəha iətəmi iətəm təmair vi mɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Kəni əmeiko, Nikotiməs tətapuəh o Iesu məmə, “?Natimnati mɨn u, otəhro lanu muva?” ");
INSERT INTO tnp_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Kəni Iesu təni məmə, “Ik iəgətun asoli rəha nətəm Isrel. ?Təhro nəkəruru natimnati mɨn u? ");
INSERT INTO tnp_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nɨpəhriəniən agɨn u iətəni=pɨnə kəm ik məmə, nəghatiən mɨn u iətəm iətəni ilah, iəu iəkəhrun vivi, kəni natimnati iətəm iətəni pətɨgəm, iəu ineruh rəkɨs. Mətəu itəmah nəsotəhatətəiən e nəghatiən mɨn rəhatɨmah. ");
INSERT INTO tnp_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Iəu iəməni natimnati mɨn iətəm katol e nəhue nɨtəni əmə u, mətəu itəmah nəsotəhatətəiən e rəhak nəghatiən. ?Kəni nəmə iəkəni natimnati mɨn iətəm katol e Negəu e Neai, nəkotəhro lanu motəhatətə lan? ");
INSERT INTO tnp_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Iətəmi kəti tɨsuvəniən əpəha ilɨs e Negəu e Neai, meiuaiu=pa, məni pətɨgəm nian kəti mɨne. Mətəu Nətɨ Iətəmimi əmə, təmsɨpən iman ikɨn e Negəu e Neai, meiuaiu=pa, təhrun nəni pətɨgəmiən. ");
INSERT INTO tnp_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Aupən, əpəha ikɨn təpiə-məpiə ikɨn, Mosɨs təmos narmɨ sɨneik kəti, mətu-pəri ilɨs e nɨgi əfəməh kəti, kəni mɨləfəri. Kəni e noliən əhmen əmə lanəha, okəkeikei kətu-pəri mɨləfəri Nətɨ Iətəmimi lanəha, ");
INSERT INTO tnp_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","məmə nətəmimi mɨn u nətəm okotəhatətə lan, ilah okotos nəmiəgəhiən itulɨn. ");
INSERT INTO tnp_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Tol lanəha, Uhgɨn təmolkeikei pɨk nətəmimi e nəhue nɨftəni, tol=pən in təməfa Nətɨn Nəuan Kətiəh Əmə, məmə nətəmimi mɨn rəfin u nətəm kəutəhatətə lan, ilah ko kəsəhuvəniən e nɨgəm itulɨn, mətəu okotos nəmiəgəhiən itulɨn. ");
INSERT INTO tnp_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Uhgɨn in təməsahli=paiən Nətɨn tuva e nəhue nɨftəni u məmə otəni pətɨgəm nalpɨniən rəha noliən rəha nətəmimi rəha nəhue nɨftəni, mətəu in təmahli=pa məmə Nətɨn otuva in suaru o nosmiəgəhiən nətəmimi e nəhue nɨftəni. ");
INSERT INTO tnp_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Nətəmimi nətəm kəutəhatətə lan, Uhgɨn otəsəniən nalpɨniən rəhalah. Mətəu nətəmimi nətəm kəsotəhatətəiən lan, Uhgɨn tɨnəni rəkɨs nalpɨniən rəhalah, mətəu-inu kəsotəhatətəiən e Nətɨ Uhgɨn Nəuan Kətiəh Əmə. ");
INSERT INTO tnp_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Uhgɨn tətakil nətəmimi e noliən u məmə, Nəhagəhagiən tɨnuva rəkɨs e nəhue nɨftəni, mətəu nətəmimi kəsotolkeikeiən Nəhagəhagiən, mətəu-inu nian rəfin rəhalah noliən, təsəhruahruiən. ");
INSERT INTO tnp_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nətəmimi nətəm kautol noliən iətəm təsəhruahruiən, ilah kəutəməki e Nəhagəhagiən. Kəni ilah kəsəhuvaiən e Nəhagəhagiən, mətəu-inu ilah kəutəpəh məmə Nəhagəhagiən əha otasiəgəpɨn pətɨgəm rəhalah noliən tərah mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","“Mətəu nətəmimi nətəm kautohtəu=pən suaru rəha nɨpəhriəniən ilah okəhuva e Nəhagəhagiən, məmə Nəhagəhagiən əha, in otasiəgəpɨn rəhalah noliən, kəni mətəgətun məmə ilah kautol nəuia Uhgɨn e nəsanəniən əmə rəhan.” ");
INSERT INTO tnp_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Uərisɨg e natimnati mɨn əha, Iesu mɨne rəhan mɨn nətəmimi kəmohiet Jerusɨləm motan əmə e nɨtəni Jutiə. Təmatɨg nuvəh nəuvetɨn ilah min ikɨn əha, kəni matol bəptais e nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Mətəu e nian əha, Jon mɨn, in tatol bəptais e nətəmimi əpəha ikɨn kəti iuəkɨr əmə o Salim, nərgɨn u, Aenon, mətəu-inu, ikɨn əha, nəhu tepət ikɨn. Kəni nətəmimi kautəhuvən ikɨn əha, məmə Jon otol bəptais e lah. ");
INSERT INTO tnp_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","E nian əha, kəsləfən əhanəhiən Jon e kaləpus. ");
INSERT INTO tnp_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kəni nətəmimi nəuvein rəha Jon, ilah kəmotorgəhu ilah iətəm kəti u taskəlɨm vivi lou rəha Mosɨs, o noliən əhruahru iətəm iətəmimi otəkeikei maig məmə in otəhruahru e nəhmtɨ Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kəni ilah kəməhuvən moteruh Jon, motəni=pən kəm in məmə, “Iəgətun, ik nəkəhrun iətəmimi kəti u aupən itəlau min əpəha e nɨtəni=pən ikɨn e nəhu Jotən, kəni ik nəməhtul pətɨgəm mətəghati lan kəm nətəmimi. Rəueiu əha, in tɨnatol bəptais e nətəmimi. Kəni ilah rəfin kɨnautəhuvən ohni.” ");
INSERT INTO tnp_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Kəni Jon təni=pən məmə, “Iətəmimi təruru noliən nati kətiəh mɨne, nəmə Uhgɨn əpəha e Negəu e Neai tətəfən uək əha kəm in. ");
INSERT INTO tnp_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Itəmah u nəutəhtul=pa ohniəu. Itəmah nəkotəhrun məmə iətəni lanu məmə, ‘Səniəmə iəu Krɨsto iətəm Uhgɨn təməni məmə otahli=pa.’ Mətəu Uhgɨn təmahli=pa iəu məmə iəkaupən muva, kəni Krɨsto in otəpanuərisɨg. ");
INSERT INTO tnp_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Iətəm aluə kəti məmə otol marɨt, in otos pətan vi rəhan. Mətəu iətəmimi u tətasiru e lafet rəha marɨt u, nɨkin tagiən pɨk məmə otəhtul e nɨkalɨ iətəm aluə u mətəlɨg lan. Krɨsto in təhmen e iətəm aluə, kəni iəu iəkəhmen e iətəm tasiru. Kəni nɨkik tagiən məmə in təmuva, kəni nɨkik tagiən mɨn məmə nətəmimi okotuərisɨg lan. ");
INSERT INTO tnp_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Krɨsto əha, in otəkeikei muva mə in ilɨs tapirəkɨs iəu, kəni ko iəu iəkeiuaiu.” ");
INSERT INTO tnp_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Iətəmimi in təmsɨpən ilɨs e Negəu e Neai, in ilɨs tapirəkɨs nətəmimi ərəfin. Iətəmimi iətəm tətan əmə e nəhue nɨftəni, in iətəmimi əmə rəha nəhue nɨftəni, kəni in təhrun əmə nəniən natimnati mɨn u e nəhue nɨftəni u. Mətəu, iətəmimi iətəm tatsɨpən ilɨs e neai in ilɨs tapirəkɨs nətəmimi rəfin. ");
INSERT INTO tnp_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","In tətəhtul pətɨgəm o nəni pətɨgəmiən natimnati iətəm in təmeruh kəni mɨnətəu rəkɨs, mətəu iətəmimi kəti mɨne təsəhatətəiən e rəhan nəghatiən. ");
INSERT INTO tnp_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Iətəmimi iətəm təmos rəhan nəghatiən kəni mətəhatətə lan, in tətəhtul pətɨgəm məmə nəghatiən iətəm Uhgɨn təməni, in nɨpəhriəniən. ");
INSERT INTO tnp_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tol lanəha mətəu-inu iətəmimi əha iətəm Uhgɨn təmahli=pa tuva, in tətəni pətɨgəm əmə nəghatiən mɨn rəha Uhgɨn. Kotəhrun məmə in tətəni pətɨgəm əmə nəghatiən mɨn rəha Uhgɨn mətəu-inu Uhgɨn təməfən Narmɨn Rəhan təriauəh lan, ko kəseuviəhliniən keruh kəni kəsehiən naunun lan. ");
INSERT INTO tnp_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Əuəh, Tatə Uhgɨn in tolkeikei pɨk Nətɨn əha, kəni in tɨnələhu=pən rəkɨs natimnati rəfin e nəhlmɨn. ");
INSERT INTO tnp_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Iətəmimi u iətəm tətəhatətə e Nətɨ Uhgɨn u, in tatos nəmiəgəhiən itulɨn u, naunun tɨkə. Kəni mətəu, iətəmi tətəhti nəuia Nətɨn u, in ko təsosiən nəmiəgəhiən itulɨn u nian kəti mɨne, mətəu-inu iətəmimi iətəm tol lanəha, niəməha rəha Uhgɨn tatuvən ohni naunun tɨkə. ");
INSERT INTO tnp_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farəsi mɨn kəmotətəu nəghatiən, məmə Iesu in tɨnatiuvi=pa nətəmimi tepət kɨnəutəhuva ohni, kəni in tatol bəptais e lah tepət. Rəhan nətəmimi tepət e rəha Jon. ");
INSERT INTO tnp_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Mətəu nɨpəhriəniən səniəmə Iesu in tatol bəptais e lah, nətəmimi mɨn əmə rəhan ilah kautol bəptais e nətəmimi.) ");
INSERT INTO tnp_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Kəni nian Iesu tɨnəhrun məmə Farəsi mɨn kɨnautətəu nəghatiən əha, kəni in təmiet Jutiə mɨtəlɨg=pən əpəha Kaləli. ");
INSERT INTO tnp_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Kəni nian in təmatuvən əha ikɨn əha, təməni məmə otəkeikei muvən=pən Səmeriə ikɨn. ");
INSERT INTO tnp_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Kəni in təmuvən=pən e taun kəti e Səmeriə, nərgɨn u, Saikar. Taun əha, in iuəkɨr o nɨtəni kəti iətəm Jekəp təmətei məfən aupən ikɨn kəm nətɨn u Josɨp. ");
INSERT INTO tnp_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Kəni wel rəha Jekəp əha ikɨn. Kəni Iesu tɨnəpəou agɨn, mətəu-inu in təmaliuək e suaru əfəməh, kəni tuva məharəg-pəri iuəkɨr o wel, mətəmeig. E nian əha, mɨtɨgar tɨnəhtul əhruahru. ");
INSERT INTO tnp_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Kəni rəhan mɨn nətəmimi kəməhuvən əpəha itaun, məmə okotos nəhmtɨ nauəniən. Kəni təsuvəhiən, pətan Səmeriə kəti, təmuva məmə otətu nəhu. Kəni Iesu təni=pən kəm in məmə, “Ei. Əfa-to nəhu nəuan nəuvetɨn kəm iəu. Iəkolkeikei məmə iəkəmnɨm.” ");
INSERT INTO tnp_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kəni pətan Səmeriə u, təni=pən kəm in məmə, “!Ei! Ik iətəm Isrel ko, kəni iəu pətan Səmeriə. ?Təhro nətətapuəh=pa o nəhu kəm iəu?” Təməni=pən lanəha mətəu-inu iətəm Jutiə mɨne iətəm Səmeriə kəsuəmnɨm pətiən nəhu e kap kətiəh. ");
INSERT INTO tnp_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Kəni Iesu təni=pən kəm in məmə, “Ik nəkəruru nati nak iətəm Uhgɨn tolkeikei məmə otəfɨnə kəm ik. Kəni ik məruru mɨn iəu, iəu u, iətətapuəh=pɨnə o nəhu kəm ik. Nəmə ik nəkəhrun, ik onəkətapuəh o nəhu ohniəu. Kəni iəu oiəkəfɨnə nəhu miəgəh.” ");
INSERT INTO tnp_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kəni pətan u, təni=pən kəm in məmə, “Iətəmi asoli, ik rəham pəkɨt tɨkə kəni wel u, in əpəha ləhtəni isəu. ?Nəhu miəgəh u, nətəni məmə onəkətu əhro lanu? ");
INSERT INTO tnp_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Rəhatah kəha Jekəp u aupən, in təməfa wel u kəm tah, kəni in təmatətu nəhu ikɨn nɨmɨn, ilah nenətɨn mɨn, mɨne rəhan mɨn kau mɨn. ?Kəni təhro? ?Ik nəkapirəkɨs Jekəp, uə?” ");
INSERT INTO tnp_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Kəni Iesu təməni=pən kəm in məmə, “Nətəm kəutəmnɨm nəhu e wel u, ilah okəpanotəuauə mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Mətəu iətəmimi iətəm otəmnɨm nəhu iətəm iəu iəkəfən kəm in, ko təsəuauə mɨniən nian kəti mɨne. Nəhu iətəm iəu oiəkəfən kəm in, in təhmen e nəhmtɨ nəhu kəti iətəm tətapuəl-apuəl mətaiu əpəha imə e nɨkin nian rəfin, mətəfən nəmiəgəhiən itulɨn kəm in, iətəm otəsoliən naunun.” ");
INSERT INTO tnp_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Kəni pətan əha təni=pən kəm in məmə, “!Iətəmi asoli, əui! Əfa-to nəhu u kəti kəm iəu, məmə iəu iəsəuauə mɨniən nian kəti, kəni məsuvaiən mɨn u ikɨnu, mətu nəhu.” ");
INSERT INTO tnp_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Kəni Iesu təni=pən kəm in məmə, “Uvən mauɨn=pən e rəham iərman, kəni miəuva u ikɨnu.” ");
INSERT INTO tnp_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Kəni pətan əha təni=pən kəm in məmə, “M-m-m. Iəu rəhak iərman tɨkə.” Mətəu Iesu təni=pən kəm in məmə, “Nətəni pəhriən məmə rəham iərman tɨkə. ");
INSERT INTO tnp_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Mətəu-inu ik, nəmɨtəu=pən rəkɨs nəman faif, kəni iərman u iətəm itəlau min nətuatɨg u rəueiu, səniəmə rəham əhruahru iərman. Nəghatiən rəham u rəueiu, in nɨpəhriəniən.” ");
INSERT INTO tnp_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Kəni pətan u, təni=pən məmə, “!Ei-i-si! Iətəmi asoli, iətafu məmə ik iəni kəti rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tɨpɨtɨmah mɨn aupən, ilah kəmautəfaki kəm Uhgɨn əpəha ilɨs e nɨtəuət əpəha, mətəu itəmah nətəm Isrel, nəutəni məmə Jerusɨləm əmə əha, okəkeikei kətan ikɨn kətəfaki.” ");
INSERT INTO tnp_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Mətəu Iesu təni=pən kəm in məmə, “Pətan, ik onəkəkeikei məni nɨpəhriəniən e rəhak nəghatiən. Nian əha ikɨn tətuva, məmə itəmah onəsotəfaki mɨniən kəm Tatə Uhgɨn əpəha e nɨtəuət asoli əha, mɨne Jerusɨləm mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Itəmah nətəm Səmeriə, itəmah nəutəfaki kəm Uhgɨn mətəu itəmah nəkotəruru in. Mətəu itɨmah iəutəfaki kəm Uhgɨn u, iəkotəhrun in, mətəu-inu suaru rəha Uhgɨn o nosmiəgəhiən nətəmimi in təmsɨpa e tɨmah, nətəm Isrel. ");
INSERT INTO tnp_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mətəu otəsuvəhiən, Narmɨn rəha Uhgɨn in otasiru e nəfaki pəhriən mɨn, mol ilah məmə ilah okotəhrun vivi Uhgɨn məmə Uhgɨn u, in Uhgɨn pəhriən, kəni mol ilah məmə ilah okotəfaki kəm in e nɨkilah pəhriən. Mətəu-inu Tatə Uhgɨn in tətəsal e nəfaki mɨn nətəm kautol lanəha. Kəni nɨpəhriəniən məmə nian əha tɨnuva rəkɨs. ");
INSERT INTO tnp_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Uhgɨn səniəmə iətəmimi. Kəpə. In narmɨn. Tol lanəha, kəni nətəmimi nətəm kəutəfaki kəm in, ilah kotəkeikei motəfaki kəm Uhgɨn məmə Uhgɨn u, in Uhgɨn pəhriən, kəni ilah kotəkeikei motəfaki kəm in e nɨkilah pəhriən e nəsanəniən rəha Narmɨn Rəhan.” ");
INSERT INTO tnp_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kəni pətan u, təməni=pən kəm in məmə, “Iəu inəhrun məmə Məsaiə, otəkeikei muva. Inu, kətauɨn lan məmə Krɨsto iətəm Uhgɨn təməni məmə otahli=pa. Kəni nian otuva, kəni in təhrun nəni pətɨgəmiən natimnati rəfin kəm tah.” ");
INSERT INTO tnp_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Kəni Iesu təni=pən kəm in məmə, “Iəu u inu, iətəghati kəm ik.” ");
INSERT INTO tnp_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kəni əmeiko, nətəmimi rəha Iesu kəmohtəlɨg=pa mɨn. Kəni narmɨlah təmiuvɨg pɨk nian kəmoteh in tətəghati ilau pətan kəti. Mətəu ilah kəti təməsətapuəhiən o pətan əha məmə, “?Ik nəkolkeikei nak?” uə kəm Iesu məmə, “?Ik nətəghati kəm pətan əha o nak?” ");
INSERT INTO tnp_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kəni pətan u, təməpəh rəhan nɨlosɨ nəhu tətəharəg, mɨtəlɨg muvən əpəha e taun. Təmuvən mətəni=pən kəm nətəmimi ikɨn əha məmə, ");
INSERT INTO tnp_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“!Ei! Əhuvən-to motafu suah kəti əha ikɨn əha. In təməni pətɨgəm rəfin natimnati mɨn iətəm iəu iəmol. ?Nəmə təhro in Krɨsto iətəm Uhgɨn təməni məmə otahli=pa?” ");
INSERT INTO tnp_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kəni ilah kəmohiet e taun əha, mɨnautəhuvən məmə okotafu to Iesu. ");
INSERT INTO tnp_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kəni e nian əha, nətəmimi rəha Iesu kəmautuh nɨkin məmə, “Iəgətun, ik auən kəti.” ");
INSERT INTO tnp_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Mətəu in təni=pən kəm lah məmə, “Iəu nəgək əpəha nauəniən iətəm itəmah nəkotəruru.” ");
INSERT INTO tnp_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tol lanəha, rəhan mɨn nətəmimi kɨnəutətapuəh-ətapuəh o lah mɨn məmə, “?Təhro? ?Kəmə təhro iətəmi kəti təməfən nauəniən kəti kəm in, uə?” ");
INSERT INTO tnp_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Mətəu Iesu təni=pən kəm lah məmə, “Uhgɨn təmahli=pa iəu iəkuva, kəni nauəniən u nəgək, məmə iatol natimnati iətəm in tolkeikei məmə iəkol. Kəni iəkol rəfin uək mɨn iətəm in təməfa məmə iəkol, o nol naununiən rəhan uək. ");
INSERT INTO tnp_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Itəmah nəkotəhrun-to nəghatiən kəti u kətəni məmə, ‘Məuɨg kuvət əha ikɨn tətatɨg məmə okotətəuarus nian rəha nəuləkiən e nauəniən e nasumiən.’ Mətəu iəu iətəni kəm təmah, oteruh-to nauəniən u e nasumiən. Rəueiu əha, nɨmalɨlah tɨnɨmətu rəkɨs. Nian rəha nəuləkiən əha rəueiu. ");
INSERT INTO tnp_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","“Iətəmimi rəha nəuləkiən tɨnuva, mɨnətətuəuin mɨnatos rəkɨs rəhan nətəouiən. Kəni nauəniən u, in təməulək lan o nəmiəgəhiən itulɨn. E noliən u, iətəmimi iətəm tətasum mɨne iətəmimi iətəm tətəulək lan mos mətuva, ilau pəti nɨkilau otagiən. ");
INSERT INTO tnp_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nəghatiən kəti u kətəni məmə, ‘Iətəmi kəti təmuvən məmə otərfei kəni mɨsuv nati, mətəu iətəmi pɨsɨn kəti mɨn otəulək lan mos muva.’ Nəghatiən u, in nɨpəhriəniən. ");
INSERT INTO tnp_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Iəu iəmahli=pən itəmah məmə onəkəhuvən motəulək e nasumiən iətəm itəmah nəməsotərfeiən mɨne məsotɨsuviən. Nətəpɨsɨn mɨn, ilah kəmotasum lan. Kəni itəmah nɨnəutəhli nəua rəhalah uək.” ");
INSERT INTO tnp_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Kəni e taun u, nətəm Səmeriə tepət, ilah kəmotəhatətə e Iesu mətəu-inu pətan əha təməhtul pətɨgəm mətəni=pən kəm lah məmə, “Iesu təməni pətɨgəm natimnati rəfin iətəm iəu iəmatol.” ");
INSERT INTO tnp_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kəni nian nətəm Səmeriə kəməhuvən moteh, kəni kəmotəkeikei ohni məmə otuvən motatɨg ilah min. Kəni Iesu təmuvən motatɨg o nian keiu. ");
INSERT INTO tnp_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kəni nətəmimi tepət mɨn kəmotəhatətə lan e rəhan mɨn nəghatiən. ");
INSERT INTO tnp_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Kəni mautəni=pən kəm pətan u məmə, “Itɨmah iəmotəhatətə lan o nəghatiən u iətəm ik nəməni=pa, mətəu rəueiu əha, iəkotəhatətə lan mətəu-inu itɨmah əhruahru iəmotətəu rəhan nəghatiən mɨn, kəni motəhrun pəhriən məmə in Iosmiəgəh rəha nəhue nɨftəni.” ");
INSERT INTO tnp_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nian Iesu təmatɨg mos nian keiu rəkɨs ikɨn əha, in təmiet muvən Kaləli. ");
INSERT INTO tnp_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Aupən, in təmətəni məmə iəni mɨn rəha Uhgɨn, nauət imalah mɨn, ilah kəsotɨsiaiən ilah. ");
INSERT INTO tnp_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nətəm Kaləli, aupən ilah kəməhuvən Jerusɨləm mautol lafet rəha Pasova, kəni e nian əha, ilah kəmoteruh natimnati mɨn iətəm in təmol ikɨn əha. Kəni nian Iesu təmuvən Kaləli, nɨkilah təmagiən ohni. ");
INSERT INTO tnp_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kəni Iesu təmɨtəlɨg=pən mɨn e lahuənu Kenə, əpəha Kaləli. Ikɨn əha aupən, in təmol nəhu tuva mol wain. Kəni e Kapeniəm iuəkɨr əmə, iətəmi asoli kəti rəha kig tətatɨg ikɨn. Kəni nətɨn kəti tatɨmɨs. ");
INSERT INTO tnp_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kəni nian suah u təmətəu məmə Iesu təmsɨpən Jutiə mɨnuva rəkɨs Kaləli, kəni in təmuva meruh Iesu. Kəni məni=pən kəm in məmə oteiuaiu muva əpəha Kapeniəm masiru e nətɨn. Mətəu-inu suakəku otɨmɨs rəueiu. ");
INSERT INTO tnp_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Kəni Iesu təni=pən kəm suah u məmə, “!Nəman! Itəmah u, nəkotəni məmə onəkoteruh əmə nəmtətiən mɨn mɨne natimnati mɨn iətəm narmɨtəmah otaupən miuvɨg ohni, uərisɨg ko, nəpanotəhatətə lak. Mətəu nəmə nəsoteruhiən, ko nəsotəhatətəiən lak.” ");
INSERT INTO tnp_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kəni suah kəha təni məmə, “!Iətəmi asoli, əui! !Pəh kian uəhai əmə! !Otəsuvəhiən rəueiu nətɨk tɨmɨs!” ");
INSERT INTO tnp_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Kəni Iesu təməni=pən kəm in məmə, “Uvən; nətɨm otəpanəmiəgəh.” Kəni suah u təməhatətə e nəghatiən rəha Iesu kəni mɨtəlɨg. ");
INSERT INTO tnp_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nian in təmatuvən əhanəh e suaru, meruh rəhan noluək mɨn, kəni ilah kotəni=pən kəm in məmə, “Rəham suakəku tɨnəmiəgəh rəkɨs.” ");
INSERT INTO tnp_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kəni in təmətapuəh o lah məmə, “?Təməuvɨr e nian nak?” Kəni ilah kəmotəni=pən kəm in məmə, “Nəniuv ləhnaiuv e uan klok rəhan nəpiapeiən təmɨkə.” ");
INSERT INTO tnp_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Kəni suah u, təməhrun məmə, e nian əhruahru əha inəha, Iesu təməni=pən kəm in məmə, “Rəham suakəku otəpanəmiəgəh.” Kəni in mɨne rəhan mɨn, kəmotəhatətə e Iesu. ");
INSERT INTO tnp_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Inu nian tatol keiu lan iətəm Iesu təmiet Jutiə, muva Kaləli kəni mol nəmtətiən kəti. ");
INSERT INTO tnp_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Uərisɨg e nian əha, Iesu təməri muvən e taun u Jerusɨləm, mətəu-inu katol lafet kəti rəha nətəm Isrel əha ikɨn əha. ");
INSERT INTO tnp_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","E Jerusɨləm, noan nəhu asoli kəti əpəha ikɨn, iətəm kətaig lan. E nəghatiən rəha nətəm Isrel kətəni nərgɨn məmə Petseta. Kəni nimə kəti tətəhtul iuəkɨr o noan nəhu əha. Nimə u, fərantə lan, faif. In iuəkɨr əmə o ket u e nɨkalɨ taun u, nərgɨn u, Ket rəha Sipsip. ");
INSERT INTO tnp_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Kəni ikɨn əha e fərantə mɨn, nətəm kautohmɨs tepət kəutapɨli əha ikɨn. Nəuvein nəhmtɨlah tərah, kəni nəuvein nəhlkɨlah tərah, nəuvein mɨn nɨpətɨlah nəuvetɨn təmɨmɨs. ");
INSERT INTO tnp_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Kəni suah kəti əha ikɨn tətapɨli. In təmatɨmɨs mɨnos rəkɨs nu tate-eit. ");
INSERT INTO tnp_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Kəni Iesu təmeruh suah u tətapɨli, kəni in mɨnəhrun məmə suah u təmɨmɨs nuvəh nəuvetɨn, kəni tətapuəh ohni məmə, “?Təhro? ?Nəkolkeikei məmə onəkəuvɨr?” ");
INSERT INTO tnp_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Iətəmi tatɨmɨs əha təni=pən kəm in məmə, “Iətəmi asoli, iətəmi tɨkə məmə otələs iəu meiuaiu muvən e noan nəhu əha nian nəhu təlauəl. Nian rəfin, iəu iətalkut pɨk məmə iəkeiuaiu muvən e nəhu, mətəu nətəmimi nəuvein ilah kotapirəkɨs iəu moteiuaiu məhuvən. Kəni ilah motaupən motek nəhu.” ");
INSERT INTO tnp_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kəni Iesu təni=pən kəm in məmə, “!Əhtul! Mos rəham nɨmahan maliuək matuvən.” ");
INSERT INTO tnp_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kəni rəueiu agɨn suah kəha təməuvɨr mɨn. Kəni maiu-aiu rəhan nɨmahan mos matuvən. Nati u kəmol e nian rəha Sapət, ");
INSERT INTO tnp_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","kəni nətəmi asoli mɨn rəha Isrel kəmotahi suah kəha iətəm tɨnəmiəgəh e rəhan nɨmɨsiən, motəni məmə, “Nian u rəueiu rəha Sapət; kəni təsəhruahruiən e Lou rəhatah məmə onəkos lanko rəham nɨmahan.” ");
INSERT INTO tnp_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Kəni in təni=pən kəm nətəmi mɨn u məmə, “Mətəu suah u təmol vivi iəu, in təməni=pa məmə iəkos rəhak nɨmahan maliuək matuvən.” ");
INSERT INTO tnp_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Kəni ilah kəmotətapuəh ohni məmə, “?Suah pəh ko təməni=pɨnə kəm ik məmə onəkol nati u?” ");
INSERT INTO tnp_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mətəu suah u təruru nərgɨ Iesu, mətəu-inu nətəmimi tepət ikɨn əha, kəni Iesu təmɨkə=pən əmə əpəha e nɨkilah. ");
INSERT INTO tnp_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kəni uərisɨg, Iesu təmeruh suah kəha e Nimə Rəha Uhgɨn, kəni təni=pən kəm in məmə, “!Ei! !Eruh-to! !Ik nɨnəuvɨr rəkɨs! Mətəu onətətəu ik məmə nəsol mɨniən təfagə tərah mɨn. Nəmə nəkol, nərahiən kəti otos mɨn ik, iətəm tərah pɨk mɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kəni suah kəha təmuvən məni pətɨgəm kəm nətəmi asoli mɨn rəha Isrel məmə, “Suah u iətəm təmol vivi iəu, nərgɨn ko, Iesu.” ");
INSERT INTO tnp_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kəni tol lanəha, nətəmi asoli rəha nətəm Isrel, ilah kɨnautohtəu-ohtəu Iesu məmə okotol nərahiən kəm in, mətəu-inu ilah kauteruh in tatol natimnati mɨn tol lanəha e nian rəha Sapət kəni nati u tol ilah kəutəməki lan. ");
INSERT INTO tnp_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Mətəu Iesu təməni=pən kəm lah məmə, “Nian rəfin rəhak Tatə in tatol uək, kəni iəu mɨn iatol uək.” ");
INSERT INTO tnp_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kəni nəghatiən u, tol nətəlɨgiən rəhalah təskasɨk təhmɨn mɨn, məmə okotohamu in tɨmɨs. Mətəu-inu rəueiu əha, səniəmə məmə tətatgəhli əmə Lou rəha Sapət, mətəu nati asoli agɨn, in tətəni məmə rəhan Tatə əhruahru Uhgɨn, kəni tol lanəha, in matol məmə in təhmen əhruahru e Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kəni Iesu təni=pən kəm lah məmə, “Nɨpəhriəniən agɨn u iətəni kəm təmah, Nətɨ Uhgɨn təruru noliən nati kəti e rəhan aru əmə nətəlɨgiən. Təhrun əmə noliən natimnati mɨn u iətəm tateruh Tatə Uhgɨn tatol, mətəu-inu natimnati rəfin u iətəm Tatə Uhgɨn tatol, Nətɨn, in mɨn in tatol. ");
INSERT INTO tnp_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nətɨn təhrun noliən lanəha, mətəu-inu Tatə Uhgɨn tolkeikei pɨk Nətɨn, kəni in tətəgətun in e natimnati rəfin iətəm in tatol. Kəni in otəpanəgətun in e natimnati rəfin iətəm in tatol. Kəni in otəpanəgətun mɨn natimnati mɨn kəm in iətəm iahgin mɨn kotapirəkɨs in mɨn u, məmə otol itəmah narmɨtəmah tatiuvɨg pɨk ohni. ");
INSERT INTO tnp_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","“Mətəu-inu Tatə Uhgɨn tatol nətəm kəmohmɨs ilah kotəmiəgəh mɨn, kəni e noliən kətiəh əmə, Nətɨn təhrun nəfəniən nəmiəgəhiən kəm nətəmimi nətəm nɨkin tagiən məmə otəfən kəm lah. ");
INSERT INTO tnp_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Mətəu-inu səniəmə Tatə Uhgɨn iətəm in otakil nətəmimi, mətəu in təmələhu=pən rəfin nakiliən e nəhlmɨ Nətɨn, ");
INSERT INTO tnp_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","məmə nətəmimi ilah rəfin okotɨsiai Nətɨn, təhmen əmə məmə inu kəutɨsiai lanəha Tatə Uhgɨn. Iətəmimi iətəm təsɨsiaiən Nətɨn, ko təsɨsiaiən Tatə Uhgɨn u iətəm təmahli=pa Nətɨn. ");
INSERT INTO tnp_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nɨpəhriəniən agɨn u iatəni kəm təmah məmə, iətəmimi iətəm tətətəu rəhak nəghatiən, kəni mətəhatətə e Uhgɨn iətəm təmahli=pa iəu iəkuva, in tɨnatos nəmiəgəhiən itulɨn. Ko in təsəhtuliən e nəhmtək məmə oiəkəni pətɨgəm nalpɨniən rəhan. In tɨnagɨm rəkɨs e nɨmɨsiən, kəni mɨnuva o nəmiəgəhiən. ");
INSERT INTO tnp_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nɨpəhriəniən agɨn u iatəni kəm təmah, məmə o nian kəti iətəm tətuva, nətəmi mɨn u kəmohmɨs, ilah okotətəu nəuia Nətɨ Uhgɨn, kəni nətəmi mɨn u ilah kəutətəlɨg lan, ilah okotos nəmiəgəhiən. Kəni nɨpəhriəniən, nian əha tɨnuva rəkɨs. ");
INSERT INTO tnp_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tatə Uhgɨn in Nəukətɨ Nəmiəgəhiən, kəni e noliən kətiəh əmə, in təmol məmə Nətɨn in mɨn Nəukətɨ Nəmiəgəhiən, ");
INSERT INTO tnp_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","kəni in təmələhu=pən nəsanəniən mɨne nepətiən e nəhlmɨ Nətɨn məmə in otakil noliən mɨn rəha nətəmimi, mətəu-inu in Nətɨ Iətəmimi. ");
INSERT INTO tnp_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Təsəuvɨriən məmə narmɨtəmah otiuvɨg pɨk o nati u, mətəu-inu nian əha ikɨn tətuva iətəm nətəm kəmohmɨs okotətəu nəuia Nətɨn, ");
INSERT INTO tnp_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","kəni ilah okotəhtul e rəhalah mɨn suvət, ilah mɨn u aupən kəmautol noliən təuvɨr mɨn okotəkeikei motəhtul mɨn motos mɨn nəmiəgəhiən, mətəu nətəmi mɨn aupən ilah kəmautol noliən tərah mɨn, ilah okotəkeikei motəhtul mɨn e nɨmɨsiən kəni motəhtul e nəhmtɨ Tatə Uhgɨn məmə Nətɨn otəni pətɨgəm rəhalah nalpɨniən. ");
INSERT INTO tnp_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Iəu iəkəruru nol aruiən nati kəti e rəhak əmə nəsanəniən. Iəu iətakil noliən mɨn rəha nətəmimi mɨn, mətəu iatol əhruahru əmə məmə rəhak Tatə tətəni mɨne məmə oiəkol. Kəni nian iəkakil noliən rəha nətəmimi, iəkəhrun məmə iəkol təhruahru, mətəu-inu oiəsolkeikeiən məmə iəkol əmə e rəhak nətəlɨgiən. Iəkəkeikei mol təhmen e nətəlɨgiən rəha Uhgɨn iətəm təmahli=pa iəu iəkuva.” ");
INSERT INTO tnp_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nəmə iəu pɨsɨn əmə iətəhtul pətɨgəm mətəghati aru lak, kəni rəhak nəghatiən ko təsəhtuliən. ");
INSERT INTO tnp_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mətəu iətəmi kəti mɨn əha ikɨn in tətəhtul pətɨgəm kəni matol nəfɨgəmiən ohniəu, kəni iəu iəkəhrun məmə nəghatiən mɨn u rəhan iətəm tətəni lak ilah nɨpəhriəniən. ");
INSERT INTO tnp_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Aupən, itəmah nəmotahli=pən rəhatəmah mɨn nətəmimi məmə okəhuvən motətəlɨg e nəghatiən rəha Jon, kəni in təmətəhtul pətɨgəm o nɨpəhriəniən. ");
INSERT INTO tnp_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Iətəghati lanu lan, mətəu iəsarəriəiən e nəghatiən rəha iətəmimi əmə kəti məmə təhrun noliən nəfɨgəmiən ohniəu. Kəpə. Təsoliən lanəha. Iətəghati e nəghatiən rəha Jon lanu mətəu-inu iəkolkeikei məmə Uhgɨn otosmiəgəh itəmah. ");
INSERT INTO tnp_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon u, təhmen e lait kəti. Tatuəu məhagəhag vivi, kəni nɨkitəmah təmagiən ohni o nian əkuəkɨr əmə. ");
INSERT INTO tnp_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Mətəu rəhak uək mɨn, ilah mɨn kautol nəfɨgəmiən ohniəu. Kəni ilah kotəsanən motapirəkɨs nəghatiən mɨn u Jon təmatəni. Uək mɨn u, rəhak Tatə təməfa kəm iəu mə iəkol naunun e lah. Kəni uək mɨn u rəhak, ilah kəutəni pətɨgəm iəu, kəni ilah mautol əpu iəu məmə rəhak Tatə in təmahli=pa iəu. ");
INSERT INTO tnp_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Kəni Tatə Uhgɨn iətəm təmahli=pa iəu, inəha iətəm tɨnatəhtul pətɨgəm ohniəu. In tətəni pətɨgəm pau iəu, mətəu itəmah nəsotətəu agɨniən nəuian aupən mətəuarus=pa u rəueiu mɨne, kəni itəmah nəsoteruhiən nəhmtɨn. ");
INSERT INTO tnp_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kəni nəghatiən rəhan təsatɨg viviən e nɨkitəmah, mətəu-inu itəmah nəsotəhatətəiən lak, iəu u, iətəm in təmahli=pa iəu iəkuva. ");
INSERT INTO tnp_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Itəmah nəutafin pɨk nəghatiən mɨn e Nauəuə Rəha Uhgɨn, kəni motəhatətə e nəghatiən mɨn əha məmə itəmah onəkotos nəmiəgəhiən iətəm naunun tɨkə. Mətəu oteruh-to. Nəghatiən mɨn əha e Nauəuə Rəha Uhgɨn, ilah kəutəghati lak, məutəni pətɨgəm iəu. ");
INSERT INTO tnp_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Mətəu itəmah nəutəpəh nuvaiən ohniəu məmə nəkotos nəmiəgəhiən ohniəu. ");
INSERT INTO tnp_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Iəsoliən nati agɨn e nəni-viviən rəha nətəmimi. Kəpə. ");
INSERT INTO tnp_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mətəu mə itəmah ko, iəu iəkəhrun vivi itəmah, kəni iəu iəkəhrun vivi məmə nolkeikeiən rəha Uhgɨn tɨkə e nɨkitəmah. ");
INSERT INTO tnp_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Iəu iəmuva e nərgɨ Tatə rəhak, mətəu itəmah nəsotosiən iəu e nɨkitəmah, nɨkitəmah təsagiəniən ohniəu; mətəu nəmə iətəmi kəti tətuva e nərgɨn aru əmə, kəni nɨkitəmah tos, kəni motagiən ohni. ");
INSERT INTO tnp_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nian rəfin itəmah nəkotolkeikei məmə nəkotos nəni-viviən rəhatəmah mɨn, mətəu nəsotalkut agɨniən məmə onəkotol nati kəti iətəm Uhgɨn u, in pɨsɨn əmə in Uhgɨn, otəni-vivi itəmah ohni. ?Onəkotəhatətə əhro lanu lak nian nautol noliən əha? ");
INSERT INTO tnp_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Təsəuvɨriən məmə nɨkitəmah otəhti məmə, iəu oiəkəni pətɨgəm noliən tərah mɨn rəhatəmah e nəhmtɨ Tatə Uhgɨn. Kəpə. Mətəu Mosɨs pəhriən, nian rəfin itəmah nəutəsal=pən ohni, in otəni pətɨgəm noliən tərah mɨn rəhatəmah. ");
INSERT INTO tnp_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mətəu-inu nəmə itəmah nəmotəhatətə pəhriən e nəghatiən mɨn rəha Mosɨs, kəni itəmah onəkotəhatətə mɨn e rəhak nəghatiən mɨn. Mətəu-inu təmətei nəghatiən mɨn kəutəghati lak. ");
INSERT INTO tnp_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mətəu itəmah nasotəhatətəiən e nəghatiən mɨn iətəm in təmətei, tol lanəha, suaru tɨkə agɨn məmə onəkotəhatətə lak.” ");
INSERT INTO tnp_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Uərisɨg e natimnati mɨn u, Iesu təmuvən əpəha e nɨtəni=pən e nəhu asoli nərgɨ u, Lek Kaləli. Kəni nərgɨn kəti mɨn u, Lek Taipiriəs. ");
INSERT INTO tnp_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kəni nɨmənin nətəmimi kəmautuərisɨg lan, mətəu-inu kəutafu nəmtətiən mɨn rəhan, iətəm tatol nətəmimi kautohmɨs kəmotəsanən. ");
INSERT INTO tnp_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Kəni Iesu təmuvən əpəha ilɨs e nɨtəuət kəti, kəni mətəharəg ikɨn ilah rəhan mɨn nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","E nian əha, lafet kəti rəha nətəm Isrel u, kətəni məmə lafet rəha Pasova tɨnuva iuəkɨr. ");
INSERT INTO tnp_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Kəni nian Iesu təməsal=pən, kəni meruh nɨmənin nətəmimi tepət ilah kəməhuva, kəni in təmətapuəh o Fɨlɨp məmə, “?Okotəhro motos pɨret tepət təhmen e nətəmimi mɨn u məmə ilah okotun?” ");
INSERT INTO tnp_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","In təməni askəuvɨn əmə məmə oteruh-to nəhatətəiən rəha Fɨlɨp, mətəu in tɨnəhrun rəkɨs nati nak iətəm in otəpanol. ");
INSERT INTO tnp_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Kəni Fɨlɨp təni=pən kəm in məmə, “!Ei! Nəmə okos nəhmtɨ pɨret məni lan təhmen e tu-hanrɨt tənariəs pau, mətəu ko təsəhmeniən. Nətəmimi mɨn u rəfin ilah okotun əmə təkəku məkəku.” ");
INSERT INTO tnp_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Kəni iətəmimi kəti rəha Iesu, nərgɨn u Antɨru u pia Saimon Pitə, in təməni=pən kəm Iesu məmə, ");
INSERT INTO tnp_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Suakəku kəti uəha tatos pɨret faif kəmol e pale, mɨne nəmu keiu. Mətəu ko təsəhmen agɨniən e nətəmimi mɨn əha.” ");
INSERT INTO tnp_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Kəni Iesu təni məmə, “Otəni=pən kəm nətəmimi məmə okotəharəg.” Kəni ikɨn əha, manuvehli tepət, kəni ilah kəmotəharəg. Kəni nəmpə rəha nəman əmə, təhmen e faif-tausɨn. ");
INSERT INTO tnp_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kəni Iesu təmos pɨret, məni tagkiu kəm Uhgɨn ohni, kəni məfən pɨret u kəm lah rəfin u kəutəharəg, kəni matɨg mol mɨn nati kətiəh əmə e nəmu. Kəni ilah kəmotun təhmen nərfɨlah tasisi. ");
INSERT INTO tnp_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kəni nian kɨnotauən rəkɨs, nərfɨlah tasisi, kəni Iesu təni=pən kəm rəhan mɨn nətəmimi məmə, “Əhuvən motəuəri nɨpɨspɨsɨ pɨret mɨn kəutəməhl-məhli. Təsəuvɨriən məmə okotərəkɨn əmə.” ");
INSERT INTO tnp_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kəni ilah kəməhuvən motəuəri nɨpɨspɨsɨ pɨret kəni məhuveipei=pən e kətɨm asoli mɨn ilah tueləf kotəriauəh vivi. Pɨret u, in nɨpɨspɨsɨ pɨret ilah faif kəmol e pale, iətəm nətəmimi kəmotun motəpəh. ");
INSERT INTO tnp_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kəni nian nətəmimi kəmoteruh nəmtətiən əha iətəm Iesu təmol, kəni ilah kəmotəni məmə, “Nɨpəhriəniən. !Iəni pəhriən u rəha Uhgɨn iətəm aupən kəmətəni məmə in otuva e nəhue nɨftəni!” ");
INSERT INTO tnp_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Kəni Iesu təməhrun məmə nətəmimi mɨn u kotəni məmə okəhuva motos in məhuvən motəkeikei kəm in məmə in otuva mol kig rəhalah. Kəni in təmagɨm mɨn, məpəh ilah muvən əpəha e nɨtəuət, mətan in pɨsɨn əmə. ");
INSERT INTO tnp_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nian mɨtɨgar təmeiuaiu, nətəmimi rəha Iesu mɨn kəmoteiuaiu məhuvən e lek əha. ");
INSERT INTO tnp_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kəni tɨnapinəpu, mətəu Iesu tɨkə, təsuva-əhanəhiən. Kəni əmeiko, ilah kəməhuvən motəri e bot kəti, kəni mɨnəutasuə lan mɨnəutohapumɨn mɨn e lek, məmə ilah okəhuvən Kapeniəm. ");
INSERT INTO tnp_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kəni nɨmətagi asoli kəti təməhtul mɨnatol nəhu tɨnətərah. ");
INSERT INTO tnp_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kəni nian ilah kəməutasuə mautəhuvən, təhmen e faif uə sikɨs kilomitə, kəni ilah kəmotafu Iesu taliuək e nəhue nəhu mətuva iuəkɨr o rəhalah bot. Kəni ilah kəmotəgɨn pɨk, ");
INSERT INTO tnp_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","mətəu in təməni=pən kəm lah məmə, “Sotəgɨn pɨkiən, mə iəu əpə.” ");
INSERT INTO tnp_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","!Kəni nɨkilah təmagiən mə kotələs in e bot, mautol əmeiko, rəueiu agɨn, mətəu bot tɨnuvən e nəve nəhu e nɨtəni=pən ikɨnu kəməutəni məmə okəhuvən ikɨn! ");
INSERT INTO tnp_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kəməni lauɨg lan, nətəmimi mɨn nətəm kəutatɨg əha e ləven=pən=pa ikɨn e lek asoli u, ilah kəmoteruh məmə aupən, bot kətiəh əmə tətəhtul. Kəni ilah kotəhrun məmə Iesu təsuvəniən e bot u ilah rəhan mɨn nətəmimi, mətəu-inu nian kəmohiet, ilah pɨsɨn əmə məhuvən. ");
INSERT INTO tnp_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kəni bot mɨn nəuvein, komotsɨpən e taun u Taipiriəs, ilah kəməhuva. Ilah kəməhuvari iuəkɨr əmə u ikɨnu iətəm Iərmənɨg təməhtul ikɨn məfaki mətəni tagkiu o pɨret, kəni nətəmimi kəmotun. ");
INSERT INTO tnp_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kəni ilah kəmoteruh məmə Iesu tɨnɨkə u ikɨnu, moteruh məmə rəhan mɨn nətəmimi kɨnohkə mɨn, kəni tol lanəha, ilah mɨn kəmotasuə mɨn e bot mɨn, məhuvən Kapeniəm, mautəsal lan. ");
INSERT INTO tnp_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nian nətəmimi mɨn u kəmoteruh Iesu əpəha nəve nəhu=pən əpəha e lek u, kotətapuəh ohni məmə, “?Iəgətun, ik nəmuva u ikɨnu nəhgɨn?” ");
INSERT INTO tnp_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Mətəu Iesu təməni=pən kəm lah məmə, “Nɨpəhriəniən agɨn iətəni kəm təmah məmə, itəmah nəutəsal lak, səniəmə nəmoteruh nəmtətiən mɨn u iətəm iəmol, mətəu itəmah nəmotun əmə pɨret, nərfɨtəmah tasisi. ");
INSERT INTO tnp_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mətəu təsəuvɨriən məmə itəmah nahgitəmah otɨkə o nosiən pɨret iətəm otəpanəmnəmɨt mɨkə. Itəmah, nahgitəmah otəkeikei mɨkə o nosiən pɨret iətəm tətatɨg itulɨn u, pɨret rəha nəmiəgəhiən iətəm naunun tɨkə. Pɨret u, inu, Nətɨ Iətəmimi otəpanəfɨnə kəm təmah; mətəu-inu Tatə Uhgɨn, in təməgətun məmə nɨkin tagiən o Nətɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kəni ilah kəmotətapuəh ohni məmə, “?Noliən nak mɨn u iətəm Uhgɨn tolkeikei məmə itɨmah oiəkotol?” ");
INSERT INTO tnp_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Kəni Iesu təni=pən kəm lah məmə, “Itəmah nəkotəkeikei motəhatətə lak, məmə Uhgɨn təmahli=pa iəu. Nati u inu Uhgɨn in tolkeikei.” ");
INSERT INTO tnp_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Kəni ilah kəmotətapuəh mɨn ohni məmə, “?Mətəu ik onəkol nəmtətiən nak, məmə itɨmah iəkoteruh kəni iəkotəhatətə lam? ?Ik onəkol nati nak? ");
INSERT INTO tnp_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nian rəhatah kəha mɨn u aupən, ilah kəmautan ikɨn təpiə-məpiə ikɨn, ilah kəmautun ‘mana.’ Nəghatiən kəti e Nauəuə Rəha Uhgɨn tətəni məmə, ‘In təməfən pɨret iətəm təmsɨpən e Negəu e Neai məmə ilah okotun.’” ");
INSERT INTO tnp_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Mətəu Iesu təməni=pən kəm lah məmə, “Nɨpəhriəniən agɨn u iatəni kəm təmah məmə, səniəmə Mosɨs təməfɨnə pɨret u iətəm tatsɨpən e Negəu e Neai məmə nəkotun. Mətəu mə rəhak Tatə in təməfɨnə. Kəni in u tətəfɨnə pɨret pəhriən iətəm tatsɨpən e Negəu e Neai, məmə itəmah onəkotun. ");
INSERT INTO tnp_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Mətəu-inu pɨret rəha Uhgɨn, inu in iətəm tatsɨpən e Negəu e Neai, məteiuaiu=pa e nəhue nɨftəni. Kəni pɨret u tətəfən nəmiəgəhiən kəm nətəmimi e nəhue nɨftəni.” ");
INSERT INTO tnp_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Kəni ilah kəmotəni=pən kəm in məmə, “Iətəmi asoli, kəsi, əfa-to pɨret u kəm tɨmah nian rəfin.” ");
INSERT INTO tnp_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Kəni Iesu təməni=pən kəm lah məmə, “Iəu u, iəu Pɨret iətəm tətəfən nəmiəgəhiən. Iətəmimi otuva ohniəu, in nəumɨs otəsus mɨniən. Kəni iətəmimi iətəm otəhatətə lak, in otəsəuauə mɨniən. ");
INSERT INTO tnp_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mətəu iəu iəməni=pɨnə rəkɨs kəm təmah, məmə nati əpnapɨn nauteruh iəu, mətəu itəmah nəsotəhatətəiən lak. ");
INSERT INTO tnp_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nətəmimi nətəm rəhak Tatə tətəfa ilah kəm iəu, ilah okəhuva ohniəu. Kəni iətəmimi iətəm otuva ohniəu, ko iəsahli pətɨgəmiən. ");
INSERT INTO tnp_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Mətəu-inu iəu iəmsɨsɨpəniən e Negəu e Neai meiuaiu=pa e nəhue nɨftəni məmə iəkol natimnati mɨn u iəu əmə iəkolkeikei. Mətəu iəmuva məmə iəkol natimnati mɨn u iətəm rəhak Tatə təmahli=pa iəu iəkuva ohni. ");
INSERT INTO tnp_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Kəni in tolkeikei məmə iəu iəkaskəlɨm tiəkɨs nətəmimi mɨn u nətəm in təməmki=pa ilah kəm iəu, oiəsəmkarəpəniən e iətəmi kəti mɨne. In tolkeikei məmə e naunun nian, iəu iəkol nətəmi mɨn u ilah okotəmiəgəh mɨn e nɨmɨsiən. ");
INSERT INTO tnp_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Mətəu-inu rəhak Tatə in tolkeikei məmə nətəmimi rəfin nətəm kəutəsal=pən o Nətɨn, kəni motəhatətə lan, ilah okotos nəmiəgəhiən itulɨn. Kəni e naunun nian, iəu oiəkol nətəmimi mɨn u ilah okotəmiəgəh mɨn e nɨmɨsiən.” ");
INSERT INTO tnp_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Kəni o nati u, nətəmimi nɨkilah tɨnətuəuin mətagət, mətəu-inu in tətəni məmə, “Iəu u, Pɨret iətəm tatsɨpən e Negəu e Neai, meiuaiu=pa e nəhue nɨftəni.” ");
INSERT INTO tnp_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ilah kəutəni məmə, “?Təhro? Suah u in Iesu, nətɨ Josɨp, kitah kotəhrun əmə rəhan tatə mɨne mamə. ?Təhro in tətəni lanəha məmə, ‘Iəu iəmsɨpən e Negəu e Neai, mətuva e nəhue nɨftəni’?” ");
INSERT INTO tnp_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iesu təməni=pən kəm lah məmə, “Təsəuvɨriən məmə nəkotəghati lanko. ");
INSERT INTO tnp_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nəmə Tatə Uhgɨn iətəm təmahli=pa iəu iəkuva, in təsiuvi=paiən iətəmimi kəti tuva ohniəu, kəni ko iətəmimi u təsuva aruiən ohniəu məmə iəkol otəmiəgəh mɨn e nɨmɨsiən e naunun nian. ");
INSERT INTO tnp_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nəghatiən iətəm iəni kəti təmətei aupən e Nauəuə rəha Uhgɨn, tətəni tol lanu məmə, ‘Uhgɨn in otəgətun nətəmimi rəfin.’ Iətəmimi iətəm tətətəlɨg e nəgətuniən rəha Tatə Uhgɨn kəni mos rəhan nətəlɨgiən ikɨn, in tətuva ohniəu. ");
INSERT INTO tnp_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Iətəmimi kətiəh mɨne tɨkə, iətəm təmeruh Tatə Uhgɨn. In pɨsɨn əmə u iətəm təmsɨpən lan, təmeruh in. ");
INSERT INTO tnp_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nɨpəhriəniən agɨn u iətəni kəm təmah məmə, iətəmimi iətəm tətəhatətə lak, in tɨnos nəmiəgəhiən itulɨn. ");
INSERT INTO tnp_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“Iəu u, Pɨret rəha nəmiəgəhiən. ");
INSERT INTO tnp_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nati əpnapɨn tɨpɨtəmah mɨn aupən, ilah kəmotun pɨret u ‘mana’ əpəha ikɨn təpiə-məpiə ikɨn, mətəu ilah kəmohmɨs rəkɨs. ");
INSERT INTO tnp_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mətəu Pɨret iətəm təmsɨpən e Negəu e Neai meiuaiu=pa u rəueiu, in tol pɨsɨn. Pɨret u, təmeiuaiu=pa məmə iətəmi iətəm tatun, ko təsɨmɨsiən ");
INSERT INTO tnp_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Iəu u, iəu Pɨret iətəm tətəmiəgəh, təmsɨpən e Negəu e Neai, meiuaiu=pa e nəhue nɨftəni. Iətəmi otun Pɨret u, in otəmiəgəh matuvən əmə lanko naunun tɨkə; kəni Pɨret u, iətəm iəu iəkəfɨnə o nəmiəgəhiən rəha nətəmimi e nəhue nɨftəni, inu nəhuvegək.” ");
INSERT INTO tnp_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nəghatiən u təmol nətəmimi kɨnautəhtul mɨnautorgəhu kəm lah mɨn, motəni məmə, “?Təhro ?Suah u təhrun nəfaiən nəhuvegɨn kitah kotun?” ");
INSERT INTO tnp_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kəni Iesu təməni=pən kəm lah məmə, “Nɨpəhriəniən agɨn u iətəni=pɨnə kəm təmah məmə, nəmə itəmah nəsotuniən nəhuvegɨ Nətɨ Iətəmimi, kəni məsotəmnɨmiən nɨran, ko nəsotosiən nəmiəgəhiən itulɨn. ");
INSERT INTO tnp_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Iətəmimi iətəm tatun əmə nəhuvegək mətəmnɨm nɨrak, in otos nəmiəgəhiən itulɨn, kəni e naunun nian, iəu oiəkol in otəmiəgəh mɨn e nɨmɨsiən. ");
INSERT INTO tnp_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Iəməni lanəha, mətəu-inu nəhuvegək in pɨret pəhriən nɨg nətəmimi. Konu nɨrak, in nəmnɨmiən pəhriən nɨm nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Iətəmimi iətəm tatun nəhuvegək, kəni mətəmnɨm nɨrak, in otatɨg lak. Kəni iəu iətatɨg lan. ");
INSERT INTO tnp_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“Rəhak Tatə iətəm təmahli=pa iəu iəkuva, in nəukətɨ nəmiəgəhiən. Kəni iəu iatos nəmiəgəhiən ohni. Kəni e noliən əhmen əmə, iətəmimi iətəm tatun iəu, inu tatos nəmiəgəhiən ohniəu. ");
INSERT INTO tnp_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Iəu u pɨret pəhriən, iətəm təmsɨpən e Negəu e Neai, meiuaiu=pa e nəhue nɨftəni. In təsəhmeniən e pɨret u, iətəm tɨpɨtah mɨn aupən kəmautun. Nati əpnapɨn məmə ilah kəmotun pɨret əha, mətəu ilah kɨnohmɨs rəkɨs. Mətəu iətəmimi iətəm tun pɨret u, in otos nəmiəgəhiən itulɨn, iətəm naunun tɨkə.” ");
INSERT INTO tnp_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iesu təməni pətɨgəm nəghatiən mɨn u, nian təmətəgətun nətəmimi əpəha e nimə rəha nuhapumɨniən e Kapeniəm. ");
INSERT INTO tnp_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nətəmimi tepət rəha Iesu kəmotətəu nəghatiən u rəhan, kəni ilah kotəni məmə, “!Nəman! !Nəghatiən u tiəkɨs agɨn! ?Pəh u təhrun nosiən nəghatiən tol lanəha?” ");
INSERT INTO tnp_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Kəni Iesu təməhrun aru məmə nətəmimi mɨn rəhan, kɨnautəni mun-mun e nəghatiən əha rəhan. Kəni in təməni=pən kəm lah məmə, “?Mətəu təhrol əha? ?Nətəlɨgiən rəhatəmah təmeiuaiu o nati u? ");
INSERT INTO tnp_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","?Mətəu nəmə təhro nəkoteruh Nətɨ Iətəmimi təri matuvən mɨn ikɨn əha, in təmsɨpən ikɨn aupən, təhrol u rəueiu? ");
INSERT INTO tnp_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Narmɨn Rəha Uhgɨn əmə təhrun nəfəniən nəmiəgəhiən kəm iətəmimi. Nəsanəniən rəha iətəmimi təruru noliən nati u. Nəghatiən mɨn u iəmatəni kəm təmah, ilah nəghatiən mɨn rəha Narmɨn Rəha Uhgɨn iətəm tətəfən nəmiəgəhiən kəm nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mətəu itəmah nəuvein u ikɨnu, itəmah nəsotəhatətə əhanəhiən lak.” (Iesu təməni lanəha mətəu-inu in tɨnəhrun rəkɨs e nətuəuiniən məmə nətəmi nɨpəh mɨn u kəsotəhatətəiən lan, kəni pəh u in otegəhan=pən e nəhlmɨ tɨkɨmɨr mɨn rəhan.) ");
INSERT INTO tnp_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Kəni in təməni məmə, “O nati u inu, iəu iəməni rəkɨs kəm təmah, məmə ko iətəmimi kəti təsuvaiən ohniəu nəmə Tatə Uhgɨn təsoliən suaru ohni.” ");
INSERT INTO tnp_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Uərisɨg e nəghatiən əha, nətəmimi rəhan tepət kəmotagɨm, mɨnotəpəh nɨtəu-pəniən. ");
INSERT INTO tnp_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kəni Iesu təmətapuəh o rəhan nətəmimi tueləf məmə, “?Təhro e təmah? ?Itəmah mɨn nəkotəni məmə nəkotagɨm motəpəh iəu?” ");
INSERT INTO tnp_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Kəni Saimon Pitə təməni=pən kəm in məmə, “?Iərmənɨg, itɨmah oiəkəhuvən o pəh? Ik əmə u, rəham əmə nəghatiən in tətəfən nəmiəgəhiən iətəm naunun tɨkə. ");
INSERT INTO tnp_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kəni itɨmah inotəhatətə rəkɨs lam, kəni itɨmah inotəhrun rəkɨs məmə ik Iətəmi Asim rəha Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Kəni Iesu təməni=pən kəm lah məmə, “Itəmah u, nətəmi tueləf rəhak. Iəu u, iəmɨtəpɨn itəmah, mətəu itəmah kəti u ikɨn, in iərmɨs.” ");
INSERT INTO tnp_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","In tətəni Jutəs, nətɨ Saimon Iskariot, mətəu-inu in mɨn in iətəmi tueləf kəti rəha Iesu, mətəu uərisɨg ikɨn, in otəpanegəhan=pən in e nəhlmɨ rəhan mɨn tɨkɨmɨr. ");
INSERT INTO tnp_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Uərisɨg e natimnati mɨn u, Iesu təsolkeikeiən məmə otuvən lahuənu mɨn e Jutiə məmə otol rəhan uək əha ikɨn əha, mətəu-inu, nətəmi asoli rəha nətəm Jutiə kəmotətei nəniən oneuən kəti ohni məmə okotuhamu in. Kəni tɨtəlɨg muvən lahuənu mɨn e nɨtəni Kaləli. ");
INSERT INTO tnp_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mətəu nian tɨnəkuəkɨr e nian rəha noliən lafet kəti rəha nətəm Isrel, nərgɨn ko lafet rəha Noliən Nɨmauvluvl. ");
INSERT INTO tnp_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Kəni pia Iesu mɨn kəmotəni=pən kəm in məmə, “Təuvɨr agɨn konu məmə nəkiet muvən əpəha Jutiə, pəh nətəmimi mɨn rəham əha ikɨn əha, ilah koteruh nati apɨspɨs mɨn rəham iətəm natol. ");
INSERT INTO tnp_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mətəu-inu iətəmimi iətəm tolkeikei məmə nətəmimi okotəhrun in, kəni ko təsəhluaigiən e rəhan mɨn uək mɨn. Nəmə natol natimnati mɨn u, uvən mol əpu ik, kəni təuvɨr agɨn məmə onəkol pəh nətəmimi mɨn e nəhue nɨftəni koteruh.” ");
INSERT INTO tnp_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Pian agɨn mɨn pau, ilah mɨn kəsotəhatətəiən lan, kəni mol kəutəni lanəha. ");
INSERT INTO tnp_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Kəni Iesu təməni=pən kəm lah məmə, “Nian əhruahru rəhak təsuva əhanəhiən, mətəu itəmah, nian mɨn rəfin əmə təhruahru o təmah. ");
INSERT INTO tnp_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nətəmimi rəha nəhue nɨftəni u, ilah ko kəsotəməkiən e təmah, mətəu iəu, ilah kəutəməki lak, mətəu-inko iəu iatəni pətɨgəm məmə rəhalah noliən təsəhruahruiən. ");
INSERT INTO tnp_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Itəmah onəkautəhuvən e lafet, mətəu ko iəu iəsaupəniən muvən e lafet əha mətəu inko, nian əhruahru rəhak təsuva əhanəhiən.” ");
INSERT INTO tnp_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","In təmətəni nəghatiən u, kəni mətatɨg əpəha Kaləli. ");
INSERT INTO tnp_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kəni pia Iesu mɨn kəmotaupən məhuvən e lafet əha, uərisɨg ko, Iesu təmuvən mɨn. Mətəu nian təmuvən, in təmətan oneuən əmə o nətəmimi məmə okəsotehiən. ");
INSERT INTO tnp_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Kəni e lafet əha, nətəmi asoli rəha nətəm Jerusɨləm, kəutəsal lan məutətapuəh lan əpnapɨn əmə o nətəmimi məmə, “?Suah əpə in iə?” ");
INSERT INTO tnp_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kəni ikɨn əha, nɨmənin nətəmimi kəməutasiuən-asiuən lan. Ilah nəuvein kotəni məmə, “In iətəmi təuvɨr kəti,” mətəu nəuvein kotəni məmə, “Kəpə, in təteiuə əmə əpəha e nətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mətəu ilah kəutəgɨn e rəhalah nətəmi asoli, kəni kəti təməsəni pətɨgəmiən Iesu e nɨki nətəmimi məmə nətəmimi okotətəu. ");
INSERT INTO tnp_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Lafet əha, kəmol o nəfakiən apiəpiə kəti, kəni e nəlugɨ lafet u, Iesu in təmuvən əpəha e Nimə Rəha Uhgɨn, mətəgətun nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Kəni nətəmi asoli rəha nətəm Isrel, narmɨlah təmiuvɨg pɨk, kəni kotəni məmə, “?Suah u təməhro məhrun natimnati mɨn u e Nauəuə Rəha Uhgɨn? Rəhatah kəti iətəmi asoli təsəgətuniən lan mɨne.” ");
INSERT INTO tnp_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Kəni Iesu təməni=pən kəm lah məmə, “Nəghatiən mɨn u iətəm iətəgətun nətəmimi lan, səniəmə rəhak əmə. Ilah kautsɨpən e Tatə Uhgɨn iətəm təmahli=pa iəu iəkuva. ");
INSERT INTO tnp_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","“Kəni nəmə suah kəti rəhan nətəlɨgiən təskasɨk məmə otol natimnati mɨn iətəm Uhgɨn tolkeikei, kəni in təhrun məmə nəghatiən mɨn u rəhak, ilah kautsɨpən o Uhgɨn, səniəmə rəhak aru əmə. ");
INSERT INTO tnp_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Iətəmimi iətəm tətəghati aru əmə e rəhan nepətiən, in tətalkut aru əmə ohni, məmə otiuvi rəkɨs nətəmimi, kəni kotəfəri nərgɨn ohni. Mətəu iətəmimi iətəm tolkeikei məmə nətəmimi okotəfəri nərgɨ iətəm təmahli=pa in tuva, in iətəmimi rəha nəniən nɨpəhriəniən, in səniəmə iətəm təteiuə. ");
INSERT INTO tnp_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosɨs təməfən Lou kəm təmah, mətəu itəmah kətiəh mɨne təsol viviən Lou əha mɨne. ?Itəmah nəutalkut məmə nəkotohamu iəu o nak?” ");
INSERT INTO tnp_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Kəni nɨmənin nətəmimi kotəni məmə, “!Nəman! !Narmɨn tərah kəti u tətatɨg lam! ?Pəh təni məmə otoh ik mɨne?” ");
INSERT INTO tnp_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Kəni Iesu təməni=pən kəm lah məmə, “Iəu iəmol uək kətiəh əmə, kəni itəmah rəfin, narmɨtəmah tatiuvɨg ohni. ");
INSERT INTO tnp_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mətəu itəmah mɨn nautol uək e Sapət, nəutəhgi=pən nəsualkələh e nian əha, mautohtəu=pən Lou rəha Mosɨs. (Nɨpəhriəniən, səniəmə Mosɨs əhruahru in təmətuəuin noliən əha, mətəu tɨpɨtəmah mɨn ilah kəmotətuəuin.) ");
INSERT INTO tnp_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mətəu nian rəfin, itəmah nəutəhgi=pən nəsualkələh e nian rəha Sapət mautol məmə onəsotatgəhliən Lou rəha Mosɨs. ?Kəni təhro niəməha tatol itəmah mətəu-inu iəu iəmol vivi agɨn nɨpətɨ iətəmimi e nian rəha Sapət? ");
INSERT INTO tnp_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Otəpəh nakiliən noliən rəhak u iətəm nəmoteruh əmə e nəhmtɨtəmah, mətəu onəkotəkeikei motətəlɨg e natimnati iətəm nəsoteruhiən e nəhmtɨtəmah, kəni motakil e nətəlɨgiən iətəm təhruahru.” ");
INSERT INTO tnp_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Kəni e nian əha, nətəm Jerusɨləm nəuvein kotəni məmə, “?Təhrol əha? ?Suah u inu, nətəmi asoli kotəni məmə okotuhamu? ");
INSERT INTO tnp_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mətəu oteruh-to. In tɨnatəgətun pətɨgəm əmə nətəmimi əpəha e nəhmtɨ nətəmimi mətəu suah kəti təsahiən ohni. ?Təhro nəmə nak nətəmi asoli mɨn kɨnotəhrun rəkɨs məmə in Krɨsto iətəm Uhgɨn təməni məmə otahli=pa? ");
INSERT INTO tnp_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mətəu kitah kotəhrun ikɨn suah u təmsɨpən ikɨn. Mətəu nian Krɨsto in otuva, ko iətəmi kəti təsəhruniən ikɨn in tatsɨpən ikɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Kəni e nian əha, Iesu in tətəgətun nətəmimi e Nimə Rəha Uhgɨn. Kəni in təmagət əfəməh mətəni pətɨgəm məmə, “Nɨkitəmah təhti məmə nəkotəhrun iəu, kəni motəhrun mɨn ikɨn iəmsɨpən ikɨn, mətəu itəmah nəkotəruru. Iəu, iəməsuvaiən e nətəlɨgiən əmə rəhak. Uhgɨn təmahli=pa iəu iəkuva. Kəni Uhgɨn, in nɨpəhriəniən. Itəmah nəkotəruru in, ");
INSERT INTO tnp_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","mətəu iəu iəkəhrun, mətəu-inu iəu iəmsɨpən lan. Kəni in təmahli=pa iəu iəkuva.” ");
INSERT INTO tnp_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","O nati u, nətəmi asoli mɨn kəmotolkeikei məmə soldiə mɨn okotaskəlɨm Iesu, mətəu kəti təməsea-pəniən mek, mətəu-inu təsol əhanəhiən nian rəhan. ");
INSERT INTO tnp_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Mətəu e nɨmənin nətəmimi ikɨn əha, ilah tepət kəmotəhatətə lan, kəni motəni məmə, “Nəmə Krɨsto tuva, kəni ko in təsoliən nəmtətiən tepət tapirəkɨs ilah mɨn u suah u Iesu tatol.” ");
INSERT INTO tnp_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Kəni nian Farəsi mɨn kəmotətəu nɨmənin nətəmimi kəutasiuən-asiuən e Iesu lanəha, ilah mɨne pris asoli mɨn kəmotahli=pən soldiə mɨn nətəm kəutəhtul o Nimə Rəha Uhgɨn məmə okotaskəlɨm Iesu. ");
INSERT INTO tnp_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kəni Iesu təməni=pən kəm nɨmənin nətəmimi məmə, “Iəu iətatɨg nian təkuəkɨr əmə kitah min itəmah, kəni uərisɨg, iəkɨtəlɨg=pən mɨn o iətəm təmahli=pa iəu. ");
INSERT INTO tnp_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","E nian u, itəmah onəpanotəsal lak, mətəu ko nəsotehiən iəu; mətəu-inu ikɨn əha, iəu iatuvən ikɨn, ko itəmah nəsəhuvaiən ikɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Kəni nətəmi asoli mɨn rəha nətəm Isrel kɨnəutətapuəh-ətapuəh o lah mɨn məmə, “?In otuvən iə əha məmə kitah okəsoteruhiən in? ?Otuvən o nətəm Isrel nəuvein u nətəm kəutatɨg e nɨtəni pɨsɨn pɨsɨn mɨn ilah Nanihluə mɨn, məmə otəgətun ilah? ");
INSERT INTO tnp_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","In tətəni məmə e nian əha, kitah okotəsal lan, mətəu kəsoteruhiən in, mətəu-inu ikɨn əha in tatuvən ikɨn, ko kitah kəsəhuvəniən ikɨn. ?Nəghatiən nak u, nɨpətɨn tətəni nak?” ");
INSERT INTO tnp_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Naunun nian rəha lafet əha, in iahgin tapirəkɨs e nian mɨn nəuvein rəha lafet. Kəni e nian əha, Iesu təməhtul əpəha e nəhmtɨ nətəmimi magət əfəməh məmə, “!Iətəmimi iətəm tətəuauə, pəh in otuva ohniəu, məmnɨm! ");
INSERT INTO tnp_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Iətəmimi iətəm tətəhatətə lak, in təhmen e nəghatiən rəha Nauəuə Rəha Uhgɨn u tətəni lanu məmə, ‘Nəhu iətəm tətəfən nəmiəgəhiən pəhriən, in otsɨpən e nɨkin, təhmen e nəhmtɨ nəhu iətəm tətapuəl-apuəl mətəri mətaiəh pətɨgəm.’” ");
INSERT INTO tnp_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iesu təməni nəghatiən u, mətəghati e Narmɨn Rəha Uhgɨn u uərisɨg in otəpanəfən kəm nətəmi mɨn u kotəhatətə lan. Mətəu e nian əha, Narmɨn Rəha Uhgɨn, təsuva əhanəhiən e nətəmimi, mətəu-inu Uhgɨn təməsəfəri əhanəhiən Iesu. ");
INSERT INTO tnp_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nian nətəmimi əha ikɨn kəmotətəu nəghatiən u, kəni nəuvein kotəni məmə, “Suah u, in iəni rəha Uhgɨn u, aupən kəmatəghati lan.” ");
INSERT INTO tnp_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Mətəu nəuvein mɨn ilah kotəni məmə, “Suah u, in Krɨsto iətəm Uhgɨn təməni məmə otahli=pa.” Mətəu in pɨsɨn mɨn nəuvein kotəni məmə, “?Nɨkitəmah təhti məmə Krɨsto iətəm Uhgɨn təməni məmə otahli=pa təhrun nɨsɨpəniən e Kaləli? !Kəpə! ");
INSERT INTO tnp_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Nauəuə rəha Uhgɨn tətəni məmə Krɨsto iətəm Uhgɨn təməni məmə otahli=pa otəkeikei mɨsɨpən e nəuanɨləuɨs rəha Tefɨt, e taun u Petlehem, ima Tefɨt aupən.” ");
INSERT INTO tnp_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tol lanəha, kəni nɨmənin nətəmimi mɨn u, kəmotuəri ilah mɨn o Iesu. ");
INSERT INTO tnp_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Kəni nəuvein kotəni məmə okotaskəlɨm in, mətəu iətəmi kəti təməsea-pəniən mek. ");
INSERT INTO tnp_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kəni soldiə mɨn kəmohtəlɨg məhuvən o pris asoli mɨn mɨne Farəsi mɨn, kəni nətəmi asoli mɨn əha kəmotətapuəh o lah məmə, “?Təhro nəsotələsiən Iesu məhuva?” ");
INSERT INTO tnp_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Kəni soldiə mɨn əha kotəni=pən kəm lah məmə, “!Iəməsotələsiən mətəu-inko suah kəti təsəghatiən təhmen lan!” ");
INSERT INTO tnp_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Kəni Farəsi mɨn kəmotəni=pən kəm lah məmə, “?Təhro? In tɨniuvi=pən nətəlɨgiən rəhatəmah mɨn e rəhan nəghatiən eiuə? ");
INSERT INTO tnp_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","?Nəmoteruh rəkɨs rəhatah kəti iətəmi asoli uə Farəsi kəti təməhatətə lan? ");
INSERT INTO tnp_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Mətəu nətəmi əpnapɨn mɨn, ilah kotəruru agɨn Lou rəha Mosɨs, tol lanəha, Uhgɨn otərəkɨn ilah.” ");
INSERT INTO tnp_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Kəni Nikotiməs u in Farəsi kəti, inəha ikɨn ilah min. Suah u inu aupən təmuvən mətəghati kəm Iesu. Kəni in təməni=pən kəm lah məmə, ");
INSERT INTO tnp_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“?Təhro? ?Təhruahru e Lou rəhatah məmə kitah okotəni pətɨgəm nalpɨniən rəha iətəmimi iətəm kitah kəsotaupəniən motəhrun vivi, konu, məsoteh əhruahruiən nati nak iətəm in tatol?” ");
INSERT INTO tnp_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Kəni ilah kəmotəni=pən kəm in məmə, “?Təhro? !?Ik u ik iətəm Kaləli, uə!? Uvən-to mafin mɨn Nauəuə Rəha Uhgɨn. Ik onəkeruh məmə iəni kəti ko təsɨsɨpəniən Kaləli.” ");
INSERT INTO tnp_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kəni nətəmimi kɨnotohtəlɨg=pən mɨn məutəhuvən lahuənu mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Mətəu Iesu təmuvən əpəha e nɨtəuət u, nərgɨn u, Nɨtəuət Rəha Nɨgi U Olif. ");
INSERT INTO tnp_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kəməni lauɨg, ləplapɨn agɨn, kəni Iesu təmɨtəlɨg=pən mɨn e Nimə Rəha Uhgɨn. Kəni nətəmimi tepət kəməhuva, motuhapumɨn=pən ilah mɨn ohni, kəni Iesu təməharəg kəni mɨnətuəuin mətəgətun ilah. ");
INSERT INTO tnp_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Kəni nəgətun mɨn rəha Lou mɨne Farəsi mɨn kəmotələs pətan kəti məhuva ohni. Kəni motol in təhtul aupən e nəhmtɨlah. Pətan əha, nətəmimi nəuvein kəmoteruh e nəhmtɨlah məmə tətapɨli ilau iərman kəti səniəmə rəhan əhruahru iərman. ");
INSERT INTO tnp_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Kəni nətəmi asoli mɨn əha kəmotəni=pən kəm Iesu məmə, “Iəgətun, pətan u nətəmimi kəmoteruh e nəhmtɨlah məmə in tətapɨli ilau iərman kəti, mətəu səniəmə rəhan əhruahru iərman. ");
INSERT INTO tnp_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","E Lou rəhatah, Mosɨs təmələhu nəghatiən kəti tətəni məmə, pətan tol lanu, kitah kotəkeikei motəhti e kəpiel apɨn motahtɨmu. ?Mətəu ik, rəham nətəlɨgiən təhro?” ");
INSERT INTO tnp_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ilah kəmotətapuəh lanəha, məmə okotol nətəlɨgiən ekəu-ekəu, pəh ilah moteruh=pən noliən tərah nəuvein lan, məmə ilah kotəhrun nakiliən noliən rəhan. Mətəu Iesu təpnapɨn əmə, məməhli-əməhli mətətei nati e nɨftəni e nəuanəhlmɨn. ");
INSERT INTO tnp_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ilah kəməutəhtul məutəhtul məutətapuəh e nəghatiən u kəm in, kəni in təhtul, kəni məni=pən kəm lah məmə, “Nəmə itəmah kəti u ikɨnu, in təsoliən noliən tərah nian kəti mɨne, pəh in otaupən məhti pətan u.” ");
INSERT INTO tnp_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kəni in məməhli-əməhli mɨn, mətətei nati e nɨftəni e nəuanəhlmɨn. ");
INSERT INTO tnp_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kəni nian ilah kəmotətəu nəghatiən rəhan, kɨnəutan kətiəh kətiəh, məutagɨm. Nauəhli mɨn kotaupən motagɨm kətiəh kətiəh, motəpəh əmə Iesu mɨne pətan əha. ");
INSERT INTO tnp_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kəni Iesu təməhtul əhruahru mɨn lan məni=pən kəm pətan məmə, “?Pətan, nətəmimi mɨn u kəmotəhruvən? ?Kəti təsuvaiən məmə otəni pətɨgəm rəham nalpɨniən?” ");
INSERT INTO tnp_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Kəni pətan əha təməni=pən kəm in məmə, “Iətəmi asoli, ilah kohkə.” Kəni Iesu təni=pən məmə, “Iəu mɨn, ko iəsəni pətɨgəmiən rəham nalpɨniən. Mətəu atuvən, mol naunun e noliən tərah mɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Kəni Iesu təmətəghati mɨn kəm lah, mətəni məmə, “Iəu u, iəu Nəhagəhagiən rəha nətəmimi u e nəhue nɨftəni. Iətəmimi iətəm tətɨtəu=pa iəu, ko in təsaliuəkiən e napinəpuiən nian kəti mɨne, mətəu in otos nəhagəhagiən e nəmiəgəhiən rəhan.” ");
INSERT INTO tnp_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Kəni Farəsi mɨn kəmotəni=pən kəm in məmə, “!Ik nətəfu pətɨgəm ik lanko, mətəu iətəmi kəti təsoliən rəhan aru nəfɨgəmiən, kəni tol lanko, rəham nəghatiən ko təsəhtuliən!” ");
INSERT INTO tnp_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Kəni Iesu təni=pən məmə, “Əuəh, nɨpəhriəniən məmə iəu aru əmə iətəni pətɨgəm iəu. Mətəu rəhak nəghatiən in tətəhtul pəhriən, mətəu-inko, iəu iəkəhrun ikɨn iatsɨpən ikɨn, kəni məhrun mɨn ikɨn iatuvən mɨn ikɨn, mətəu itəmah nəkotəruru ikɨn iatuvən ikɨn, kəni motəruru ikɨn iatsɨpən ikɨn. ");
INSERT INTO tnp_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","“Itəmah u, nəutakil noliən rəha iətəmimi e nətəlɨgiən rəha iətəmimi əmə. Mətəu iəu iəsakiliən noliən rəha iətəmi lanəha, məsakiliən iətəmi kəti. ");
INSERT INTO tnp_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Mətəu nəmə iəu, iəkakil noliən rəha nətəmimi, oiəkol e noliən iətəm təhruahru, mətəu-inu səniəmə iətakil e nətəlɨgiən əmə rəhak, mətəu itɨmlau Tatə Uhgɨn iətəm təmahli=pa iəu, rəhatɨmlau nakiliən in kətiəh əmə. ");
INSERT INTO tnp_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","E Lou rəhatəmah, kəmətei məmə, nəmə iətəmimi keiu, katuol nəfɨgəmiən o nəghatiən kəti, kəni nəghatiən u, in otatəhtul. ");
INSERT INTO tnp_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Kəni rəueiu əha, iəu iatəni pətɨgəm iəu, mətəu rəhak Tatə iətəm in təmahli=pa iəu iəkuva, in mɨn tatol nəfɨgəmiən ohniəu.” ");
INSERT INTO tnp_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kəni tol lanəha, ilah kɨnəutətapuəh ohni məmə, “?Mətəu Tatə in iə rəham?” Kəni in təni məmə, “Itəmah nəkotəruru iəu, kəni itəmah nəkotəruru mɨn rəhak Tatə. Nəmə itəmah nəkotəhrun mə iəu pəh, kəni nəkotəhrun mɨn rəhak Tatə.” ");
INSERT INTO tnp_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iesu təməni nəghatiən u e Nimə Rəha Uhgɨn əhruahru, nian in təmətəgətun nətəmimi əpəha ikɨn kəti iətəm kətəfən məni ikɨn. Mətəu iətəmi kəti təməsuvəniən maskəlɨm in, mətəu-inu təsol əhanəhiən nian rəhan. ");
INSERT INTO tnp_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Kəni Iesu təmətəni=pən mɨn kəm lah məmə, “Iəu iəpanagɨm rəkɨs e təmah, kəni itəmah onəkotəsal lak. Mətəu itəmah onəkohmɨs, kəni təfagə tərah u rəhatəmah otatɨg əhanəh e təmah. Ikɨn əha iatuvən ikɨn, ko itəmah nəsəhuvaiən ikɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Kəni nətəmi asoli rəha nətəm Isrel, ilah kotəni məmə, “?Nəghatiən əha Iesu tətəni məmə, ikɨn əha in tatuvən ikɨn, ko kitah kəsəhuvəniən ikɨn, nɨpətɨn tətəni nak? ?Nəmə təhro in otohamu aru in, uə?” ");
INSERT INTO tnp_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Kəni Iesu təməni=pən kəm lah məmə, “Imatəmah u ikɨnu, mətəu iəu, iəu imak əha ilɨs ikɨn əha, kəni iəmsɨpən ikɨn, meiuaiu=pa. Itəmah nətəmimi rəha nəhue nɨftəni u. Mətəu iəu, səniəmə iətəmi rəha nəhue nɨftəni u. ");
INSERT INTO tnp_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Tol lanəha, iətəni=pɨnə kəm təmah məmə, itəmah onəpanohmɨs e noliən tərah mɨn rəhatəmah, mətəu-inu nəmə itəmah nəsotəhatətəiən lak məmə Iəu U Inu, kəni itəmah onəkohmɨs, kəni noliən tərah mɨn rəhatəmah okotatɨg agɨn e təmah.” ");
INSERT INTO tnp_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Kəni ilah kəmotətapuəh ohni məmə, “!Ei! ?Ik pəh konu?” Kəni in təməni=pən kəm lah məmə, “Iəu iəkəhmen əmə məmə in konu iəmatəni kəm təmah aupən, mətəuarus=pa u rəueiu. ");
INSERT INTO tnp_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Natimnati tepət iətəm iəkəhrun nəniən e təmah, kəni məhrun nakiliən noliən mɨn rəhatəmah ohni, mətəu iətəmimi iətəm təmahli=pa iəu, rəhan nəghatiən in nɨpəhriəniən əmə. Iəu iətəni pətɨgəm əmə natimnati mɨn iətəm iəmətəu ohni, məmə nətəmimi rəha nəhue nɨftəni ilah okotətəu.” ");
INSERT INTO tnp_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Mətəu ilah kəsotəhruniən məmə Iesu in tətəgətun Tatə Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Tol lanəha, in təni=pən kəm lah məmə, “Nian onəkotləfəri rəkɨs Nətɨ Iətəmimi, nəpanotəhrun məmə Iəu U Inu. Kəni onəpanotəhrun mɨn məmə iəsol aruiən nati kəti e rəhak nətəlɨgiən. Iətəni əmə natimnati iətəm Tatə Uhgɨn təməgətun iəu lan. ");
INSERT INTO tnp_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Iətəmi təmahli=pa iəu iəkuva, in tətatɨg itɨmlau min. In təsəpəhiən iəu iəkan pɨsɨn, mətəu-inu, nian rəfin, iatol natimnati mɨn iətəm nɨkin tətagiən ohni.” ");
INSERT INTO tnp_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nian Iesu təmətəni nəghatiən mɨn əha, nətəmimi tepət kəmotəni nɨpəhriəniən lan. ");
INSERT INTO tnp_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kəni Iesu təməni=pən kəm nətəm Isrel mɨn u kəmotəni nɨpəhriəniən lan məmə, “Nəmə nəkotaskəlɨm əskasɨk nəghatiən mɨn u rəhak, iətəm iətəni=pɨnə kəm təmah, itəmah əhruahru konu, rəhak nətəmimi mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kəni itəmah onəkotəhrun nɨpəhriəniən, kəni nɨpəhriəniən u, otɨtɨs itəmah məmə nəsəhuva mɨniən motol slef.” ");
INSERT INTO tnp_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Kəni ilah kəmotəni=pən kəm in məmə, “Itɨmah u namipɨ Epraham, itɨmah u iəsotol agɨniən slef mɨn rəha iətəmi kəti. ?Təhro nəməni nəghatiən u məmə, ‘Nɨpəhriəniən otɨtɨs itəmah, nəkotəpiə.’?” ");
INSERT INTO tnp_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Kəni Iesu təni=pən kəm lah məmə, “Nɨpəhriəniən agɨn u iətəni=pɨnə kəm təmah, nətəmimi nətəm kautol noliən tərah, kəni noliən tərah u, in tətarmənɨg e lah, kəni mətaskəlɨm matol ilah kəutəhuva rəhan mɨn slef. ");
INSERT INTO tnp_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kəni slef, rəhan iətəmi asoli təsegəhaniən məmə otatɨg e nimə rəhan. Mətəu iərmənɨg tətegəhan lan məmə nətɨn tətatɨg e nimə rəhan nian rəfin matuvən əmə lanko naunun tɨkə. ");
INSERT INTO tnp_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","!Tol lanəha, nəmə Nətɨ Uhgɨn tatɨtɨs itəmah, kəni tatɨtɨs pəhriən agɨn itəmah, kəni itəmah nəsəhuva mɨniən motol slef! ");
INSERT INTO tnp_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Iəkəhrun məmə itəmah namipɨ Epraham, mətəu nəutəsal e suaru məmə onəkotohamu iəu, mətəu-inu nəsotolkeikeiən məmə onəkotətəlɨg e rəhak nəghatiən. ");
INSERT INTO tnp_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Iəu iətəni natimnati mɨn u, iətəm iəmeruh rəhak Tatə təmol. Mətəu itəmah nautol natimnati mɨn u iətəm rəhatəmah əmə tatə təməni kəm təmah.” ");
INSERT INTO tnp_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Kəni ilah kəmotəni=pən kəm in məmə, “!Mətəu tatə rəhatɨmah, in Epraham!” Kəni Iesu təməni=pən kəm lah məmə, “Nəmə itəmah namipɨ Epraham əhruahru mɨn, kəni itəmah onəkotos rəhan noliən mɨn, təhmen lan təmol aupən. Mətəu itəmah səniəmə namipɨn əhruahru, mətəu-inu nəsotosiən noliən mɨn rəhan. ");
INSERT INTO tnp_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Iəu iətəni pətɨgəm nəghatiən pəhriən kəm təmah iətəm iəmətəu o Uhgɨn, mətəu itəmah nəkotəni məmə onəkotohamu iəu. ?Nɨkitəmah təhti məmə noliən rəha Epraham tol lanəha? ");
INSERT INTO tnp_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Itəmah nəutohtəu=pən əmə noliən əmə rəha tatə rəhatəmah.” Kəni ilah kəmotəni=pən kəm in məmə, “Itɨmah u səniəmə kəlkələh mɨn e suaru. Uhgɨn əmə in Tatə rəhatɨmah.” ");
INSERT INTO tnp_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Kəni Iesu təni=pən kəm lah məmə, “Nəmə Uhgɨn pəhriən in Tatə rəhatəmah, kəni itəmah onəkotolkeikei iəu, mətəu-inu iəu iəmsɨpən lan, muva u ikɨnu. Mətəu in səniəmə rəhatəmah Tatə. Iəu iəməsuvaiən u ikɨnu e rəhak aru əmə nətəlɨgiən, iəmuva mətəu-inu in təmahli=pa iəu. ");
INSERT INTO tnp_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","“?Mətəu təhro nəsotəhruniən nɨpətɨ nəghatiən rəhak? !Mətəu-inu nəsotolkeikei agɨniən məmə nəkotətəu rəhak nəghatiən! ");
INSERT INTO tnp_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Itəmah, rəhatəmah noliən təhmen əmə e noliən rəha tatə rəhatəmah, Setən. Kəni nian rəfin itəmah nəkotolkeikei noliən nəuan. Noliən rəhan iətəm təmatol e nətuəuiniən, tatol əhanəh, in iətəmi rəha nohamuiən itəmi. In təməki e nɨpəhriəniən, mətəu-inu nɨpəhriəniən tɨkə lan. Nian in təteiuə, in tatol əmə rəhan noliən, mətəu-inu in iətəmi rəha neiuəiən, kəni in tatə rəha neiuəiən mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","“Mətəu iəu iətəni nɨpəhriəniən əmə kəm təmah, kəni tol lanəha, itəmah nəsotəhatətəiən e rəhak nəghatiən. ");
INSERT INTO tnp_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","?Təhro? Itəmah kəti u ikɨnu təhrun nəgətuniən məmə iəu iəmol noliən tərah kəti mɨne? ?Nəmə iəu iətəni nəghatiən pəhriən mɨn, kəni təhro itəmah nəsotəhatətəiən lak? ");
INSERT INTO tnp_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Iətəmimi rəha Uhgɨn, in tatətəlɨg e nəghatiən rəha Uhgɨn, mətəu itəmah səniəmə nətəmimi rəha Uhgɨn. Tol lanəha, nəsotətəlɨgiən e nəghatiən rəha Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Kəni nətəmi asoli rəha nətəm Isrel kəmotahi Iesu motəni məmə, “!Nəman! !Itɨmah inoteruh əhruahru ik! Ik iətəm Səmeriə kəti. !Ik, narmɨn tərah kəti tətatɨg lam!” ");
INSERT INTO tnp_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Mətəu Iesu təni məmə, “Narmɨn tərah tɨkə lak, mətəu iəu iətəfəri nərgɨ rəhak Tatə, mətəu itəmah, nəutərəkɨn nərgək. ");
INSERT INTO tnp_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Iəu iəsalkutiən o nərgɨn asoli, mətəu iətəmi kəti in tətalkut ohniəu. Kəni in otəpanakil nətəmimi rəfin. ");
INSERT INTO tnp_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nɨpəhriəniən agɨn u iətəni=pɨnə kəm təmah məmə, iətəmimi iətəm tatol nəuiak, ko in təsɨmɨsiən nian kəti mɨne.” ");
INSERT INTO tnp_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Kəni nətəmimi mɨn əha kotəni=pən kəm in məmə, “!Rəueiu inotəhrun məmə narmɨn tərah kəti tətatɨg lam! Epraham təmɨmɨs, kəni iəni mɨn kəmohmɨs mɨn, mətəu ik nətəni məmə, iətəmimi iətəm tatol nəuiam, ko in təsɨmɨsiən nian kəti. ?Nəghatiən nak u? ");
INSERT INTO tnp_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","?Ik nəkapirəkɨs Epraham u tɨpɨtɨmah tɨnɨmɨs rəkɨs? ?Kəni mɨne iəni mɨn u kɨnohmɨs rəkɨs? ?Kəni nəkəmə ik iətəmimi nak?” ");
INSERT INTO tnp_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Kəni Iesu təni=pən məmə, “Nəmə iəu əmə iətəfəri aru iəu, kəni rəhak nɨsiaiən in nati əpnapɨn əmə. Mətəu rəhak Tatə u itəmah nəutəni məmə in Uhgɨn rəhatəmah, inəha in tətəfəri iəu mətəfən nɨsiaiən kəm iəu. ");
INSERT INTO tnp_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Itəmah nəkotəruru in, mətəu iəu iəkəhrun in. Nəmə iəkəni məmə iəkəruru in, kəni in otol iəu məmə iəu iətəmimi rəha neiuəiən, təhmen əmə e təmah. Mətəu iəu iəkəhrun in, kəni iəu matol nəuian. ");
INSERT INTO tnp_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tɨpɨtəmah u Epraham, nɨkin təmagiən pɨk məmə in otəpaneh nian rəhak otuva. Kəni nian in təməhrun məmə rəhak nian otəkeikei muva, kəni nɨkin təmagiən-pɨk.” ");
INSERT INTO tnp_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Kəni nətəmimi mɨn u kəmotahi motəni məmə, “!Nəman! !Ik nəsos əhanəhiən nu fifti mɨne! Nəməhro mafu Epraham?” ");
INSERT INTO tnp_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Kəni Iesu təni məmə, “Nɨpəhriəniən agɨn u iətəni=pɨnə kəm təmah məmə, nian Epraham təməsair əhanəhiən, mətəu Iəu Iətatɨg.” ");
INSERT INTO tnp_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Kəni əmeiko, ilah kəmotəmki kəpiel apɨn, motəni məmə okotəhti Iesu lan; mətəu Iesu təməhluaig, kəni miet e Nimə Rəha Uhgɨn matuvən. ");
INSERT INTO tnp_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Kəni nian kəti, Iesu təmaliuək mətan, kəni meruh suah kəti. Nian təmair, nəhmtɨn təpɨs. ");
INSERT INTO tnp_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Kəni nətəmimi mɨn rəha Iesu kəmotəni=pən kəm in məmə, “Iəgətun, suah u təmair nəhmtɨn təpɨs. ?O nak? ?O noliən tərah rəhan, uə noliən tərah rəha tatə mɨne mamə rəhan?” ");
INSERT INTO tnp_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Mətəu Iesu təni məmə, “Nəhmtɨ suah u təmərah, mətəu səniəmə e noliən tərah rəhan, uə e noliən tərah rəha tatə mɨne mamə rəhan. Mətəu, nəhmtɨ suah u təməpɨs lanəha məmə Uhgɨn otəgətun rəhan uək e nəmiəgəhiən rəhan. ");
INSERT INTO tnp_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nian tətian əhanəh, kitah kotəkeikei motol uək rəha Uhgɨn, iətəm təmahli=pa iəu iəkuva. Nian lapɨn otəpanuva, kəni iətəmimi in təruru noliən uək. ");
INSERT INTO tnp_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nian iəu iətatɨg əhanəh e nəhue nɨftəni u, iəu Nəhagəhagiən rəha nətəmimi e nəhue nɨftəni.” ");
INSERT INTO tnp_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nian Iesu təməni rəkɨs nəghatiən əha, təmagəh nɨftəni, kəni, mol nəmɨt lan, kəni mos nəmɨt əha, mol=pən e nəhmtɨ suah kəha. ");
INSERT INTO tnp_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Kəni Iesu təni=pən ohni məmə, “Onəkuvən e noan nəhu Sailoam, kəni məueiu nəhmtəm.” (Nərgɨn u Sailoam, nɨpətɨn təni məmə, “Kəmahli=pən.”) Kəni suah kəha, təmuvən, məueiu nəhmtɨn. Nian təmɨtəlɨg=pa, mətəu nəhmtɨn tɨnəuvɨr, kəni mɨnateruh nati. ");
INSERT INTO tnp_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kəni nətəmimi iman ikɨn, mɨne nətəm min u nətəm kotəhrun in, məmə in iətəmimi kəti nian rəfin təteasiə o məni o nətəmimi, ilah narmɨlah təmiuvɨg pɨk ohni. Kəni kɨnautətapuəh-ətapuəh o lah mɨn məmə, “!Ei! !Oteruh-to! ?Suah u inu, nian rəfin tətəharəg məteasiə o məni o nətəmimi?” ");
INSERT INTO tnp_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Kəni nətəmimi nəuvein kotəni məmə, “Əuəh, inəha.” Kəni mətəu nəuvein kotəni məmə, “Kəpə. Təhmen əmə lan, mətəu səniəmə in.” Mətəu suah kəha təni məmə, “!Iəu u inu!” ");
INSERT INTO tnp_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Kəni ilah kəmotətapuəh ohni məmə, “?Nəhmtəm təməhro məuvɨr?” ");
INSERT INTO tnp_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Kəni in təni məmə, “Suah u, nərgɨn u Iesu, in təmol nəmɨt nəuvetɨn kəni mol=pən e nəhmtək, kəni məni məmə, ‘Uvən əpəha Sailoam, məueiu nəhmtəm.’ Kəni əmeiko, iəmuvən. Nian iəməueiu nəhmtək, mətəu nəhmtək tɨnəuvɨr, inateh nati.” ");
INSERT INTO tnp_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Kəni ilah kəmotətapuəh ohni məmə, “?Mətəu suah tətatɨg iə?” Kəni in təni məmə, “Iəu iəkəruru.” ");
INSERT INTO tnp_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kəni nətəmimi kəmotələs suah u nəhmtɨn təmərah aupən, məhuvən kəm Farəsi mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Nian u, iətəm Iesu təmol=pən nəmɨt e nəhmtɨ suah kəha kəni mol vivi, in nian rəha Sapət. ");
INSERT INTO tnp_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Kəni Farəsi mɨn kəmotətapuəh ohni məmə, “?Nəməhro nəhmtəm təuvɨr?” Kəni suah kəha təməni=pən kəm lah məmə, “Iesu təmol=pən nəmɨt e nəhmtək, kəni iəkuvən məueiu rəkɨs, kəni nəhmtək təuvɨr, iateruh nati.” ");
INSERT INTO tnp_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Kəni Farəsi mɨn nəuvein kəmotəni=pən məmə, “Suah ko təsɨsɨpəniən o Uhgɨn, mətəu-inu, in təsɨtəu-pəniən lou rəha Sapət.” Mətəu Farəsi mɨn nəuvein mɨn kotəni məmə, “?Mətəu təhro? Suah kəha səniəmə in tatol noliən tərah. Iətəm tatol noliən tərah təruru noliən nəmtətiən kəti lanəha.” Kəni ilah kəmotəuəri ilah mɨn o nəghatiən u. ");
INSERT INTO tnp_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kəni ilah kəmotətapuəh mɨn ohni məmə, “?Suah kəha təmol vivi nəhmtəm, kəni nɨkim təhti məmə in iətəmimi nak?” Kəni in təməni=pən kəm lah məmə, “In iəni kəti.” ");
INSERT INTO tnp_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Mətəu nətəmi asoli rəha nətəm Isrel kəsotəniən nɨpəhriəniən lan məmə suah u aupən nəhmtɨn təmərah, mətəu rəueiu əha, tɨnətair. Tol lanəha, ilah kəmotauɨn=pən e rəhan tatə mɨne mamə kiəuva, ");
INSERT INTO tnp_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","kəni kəmotətapuəh o lau məmə, “?Təhro? ?Nətɨtəlau u suah u? ?Itəlau onəkuəni-to məmə nian in təmair=pa, kəni nəhmtɨn təpɨs? ?Okəmə nɨpəhriəniən, kəni nəhmtɨn təməhro məuvɨr?” ");
INSERT INTO tnp_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Kəni rəhan mamə mɨne tatə kuəmə “Itɨmlau iəkuəhrun məmə nətɨtɨmlau əha, kəni itɨmlau iəkuəhrun məmə təmair=pa, nəhmtɨn tərah. ");
INSERT INTO tnp_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Mətəu itɨmlau iəkuəruru məmə, rəueiu əha, kəməhro nəhmtɨn tair. Kəni itɨmlau iəkuəruru mɨn məmə iətəmimi pəh təmol nəhmtɨn təuvɨr. Təuvɨr məmə itəmah nəkotətapuəh ohni. In tɨnepət rəkɨs, in təhrun nəniən natimnati mɨn rəfin kəm təmah.” ");
INSERT INTO tnp_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Rəhan tatə mɨne mamə, kəmuəni lanəha, mətəu-inu ilau kətuəgɨn e nətəmi asoli mɨn rəha Isrel, mətəu-inu ilah kɨnotələhu rəkɨs nəghatiən kəti məmə, iətəmimi iətəm tətəni pətɨgəm məmə Iesu in Krɨsto iətəm Uhgɨn təməni məmə otahli=pa, kəni ilah okotahli pətɨgəm e nimə rəha nuhapumɨniən. ");
INSERT INTO tnp_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Tol lanəha, rəhan tatə mɨne mamə, ilau kəmuəni məmə, “In tɨnepət rəkɨs, təuvɨr məmə itəmah nəkotətapuəh ohni, pəh in təni.” ");
INSERT INTO tnp_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","O nati u, ilah kəmotauɨn=pən mɨn e suah kəha iətəm nəhmtɨn təmərah aupən, məmə otuva məhtul aupən e nəhmtɨlah. Kəni kəmotahi motəni məmə, “Əni nɨpəhriəniən kəni məfəri nərgɨ Uhgɨn. Itɨmah iəkotəhrun məmə suah u, in iol təfagə tərah.” ");
INSERT INTO tnp_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Mətəu suah u təni məmə, “Iəu iəkəruru məmə suah u in iol təfagə tərah, uə kəpə. Nati kətiəh əmə iətəm iəu iəkəhrun. Aupən nəhmtək təməu, mətəu rəueiu inətair.” ");
INSERT INTO tnp_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Kəni ilah kɨnəutətapuəh mɨn ohni məmə, “?Təməhro ik? ?Təməhro lanu mol nəhmtəm tair?” ");
INSERT INTO tnp_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Mətəu in təni məmə, “Iəməni=pɨnə rəkɨs kəm təmah, mətəu itəmah nəsotətəlɨgiən lak. ?Təhro nəkotəni məmə iəkəni mɨn? ?Itəmah mɨn nəkotəni məmə rəhan u itəmah!?” ");
INSERT INTO tnp_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kəni ilah kəmotahi motəni rah, motəni məmə, “!Ah! !Ik u rəhan iətəmimi! !Mətəu itɨmah u, nətəmimi rəha Mosɨs! ");
INSERT INTO tnp_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Itɨmah iəkotəhrun vivi məmə Uhgɨn təmətəghati kəm Mosɨs, mətəu suah ko, iəkotəruru məmə təmsɨpən iə.” ");
INSERT INTO tnp_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Kəni suah kəha təni məmə, “!Nəman! !Narmək təmiuvɨg pɨk! !Suah u in təmol vivi nəhmtək, mətəu itəmah nəkotəruru ikɨn təmsɨpən ikɨn! ");
INSERT INTO tnp_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kitah kotəhrun məmə Uhgɨn təsətəlɨgiən e nətəm kautol noliən tərah. !Mətəu iətəmi tatɨsiai Uhgɨn, kəni matol nəuian, Uhgɨn tətətəlɨg lan! ");
INSERT INTO tnp_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","E nətuəuiniən nian, mətəuarus=pa u rəueiu, kəsətəu əhanəhiən iətəmi kəti təmol vivi iətəm nəhmtɨn təməpɨs kəti iətəm təmair=pa tol lanəha. Mətəu nəhmtək tɨnəuvɨr. ");
INSERT INTO tnp_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nəmə iətəmi kəti təsɨsɨpəniən e Uhgɨn, ko təsol agɨniən nati kəti. Mətəu təhruahru əmə məmə in tatsɨpən e Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Kəni ilah kəmotahi mɨn motəni məmə, “!Nəman! Ik iətəmimi rəha noliən tərah nian mɨn rəfin əmə, tətuəuin e nian nəmair=pa mətəuarus=pa u rəueiu. ?Nəkəhro məmə nəkəgətun itɨmah?” Kəni ilah motəraki pətɨgəm lan. ");
INSERT INTO tnp_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Kəni Iesu təmətəu nəghatiən məmə kəmahli pətɨgəm suah u e nimə rəha nuhapumɨniən, kəni in təmuvən meruh, kəni tətapuəh ohni məmə, “?Təhro? ?Ik nətəhatətə e Nətɨ Iətəmimi?” ");
INSERT INTO tnp_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Kəni suah u təni məmə, “?Iətəmi asoli, iətəmimi ko in pəh? !Əui! Əni=pa-to, pəh iəu iəkəhatətə lan.” ");
INSERT INTO tnp_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Kəni Iesu təni=pən kəm in məmə, “Rəueiu əha, ik nɨneh rəkɨs in. Suah u, mə inu iəu, iətəghati kəm ik u rəueiu.” ");
INSERT INTO tnp_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Kəni suah u təni=pən kəm Iesu məmə, “Iərmənɨg, iəu inəhatətə lam əha rəueiu.” Kəni in masiəulɨn=pən kəm in, kəni mətəfaki kəm in. ");
INSERT INTO tnp_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Kəni Iesu təməni məmə, “Iəu iəmuva e nəhue nɨftəni u məmə iəkakil nətəmimi məuəri ilah, kəni tol lanəha, nətəmi nəhmtɨlah təməpɨs, okoteh nati, kəni nətəmi mɨn u kauteh nati, nəhmtɨlah otəpɨs.” ");
INSERT INTO tnp_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Kəni Farəsi mɨn nəuvein əha ikɨn, kəmotətəu nəghatiən lan, kəni kotəni=pən kəm in məmə, “?Təhro? ?Ik nətəni məmə nəhmtɨtɨmah mɨn təpɨs?” ");
INSERT INTO tnp_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Kəni Iesu təməni=pən kəm lah məmə, “Nəmə nəhmtɨtəmah təpɨs, oiəsəniən məmə itəmah nəkotəkeikei motos nalpɨniən o təfagə tərah mɨn rəhatəmah. Mətəu itəmah nəkotəni məmə nəhmtɨtəmah təuvɨr, nəuteh nati, kəni tol lanəha, təfagə tərah mɨn rəhatəmah tətatɨg əhanəh e təmah.” ");
INSERT INTO tnp_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Kəni təni məmə, “Nɨpəhriəniən agɨn u iətəni kəm təmah məmə, iətəmi iətəm tatuvən imə e nɨpai rəha sipsip, təsuvən-pəniən e namtɨhluə, mətəu in tətəri kəni matiuvɨgegəu məmə otuvən imə e nɨpai rəha sipsip, in iakləh mɨne iohamu itəmi kəti. ");
INSERT INTO tnp_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Mətəu iətəmimi iətəm tatuvən=pən e namtɨhluə, in iətəm tətəsal o sipsip. ");
INSERT INTO tnp_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Iətəmimi iətəm tətəhtul e namtɨhluə, nian rəfin in taterəh e doə o suah u, kəni sipsip mɨn kotəhrun nəuian. Nian rəfin in tətauɨn e nərgɨ sipsip mɨn kətiəh kətiəh, kəni in matit ilah mautohiet. ");
INSERT INTO tnp_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nian in tatit rəhan mɨn sipsip mɨn mautohiet e nɨpai, in tətaupən e lah, kəni sipsip mɨn kautəhuərisɨg lan, mətəu-inu kotəhrun nəuian. ");
INSERT INTO tnp_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mətəu ilah kəsotohtəu-pəniən iətəmi kəti u iətəm kotəruru, ilah okotəkeikei motagɨm motəpəh, mətəu-inu ilah kotəruru nəuian.” ");
INSERT INTO tnp_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesu təməghati əuhlin lanu, mətəu ilah kotəruru nɨpətɨn məmə tətəni nak. ");
INSERT INTO tnp_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Tol lanəha, kəni Iesu təməni=pən mɨn kəm lah məmə, “Nɨpəhriəniən agɨn u iətəni kəm təmah məmə, iəu u, Namtɨhluə rəha sipsip mɨn iətəm kautəhuvən=pən ikɨn. ");
INSERT INTO tnp_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nətəmi mɨn u nətəm kəmotaupən lak, ilah rəfin nətəmimi rəha nakləhiən əmə mɨne nohamuiən itəmi. Mətəu sipsip mɨn ko kəsotətəlɨgiən e lah. ");
INSERT INTO tnp_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Iəu u, iəu Namtɨhluə u. Iətəmi tətuva=pa iəu ikɨn, məmə otuvən imə, in otos nəmiəgəhiən. In otuva imə, miet muvən ihluə e iəu, kəni mos nɨmanuvehli əmemtəh təuvɨr. ");
INSERT INTO tnp_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mətəu iakləh, in tətuva əmə o nati kətiəh əmə. In tətuva məmə otakləh kəni mohamu itəmi, kəni mərəkɨn-ərəkɨn natimnati rəfin. Mətəu iəu, iəmuva məmə iəkol suaru o nosiən nəmiəgəhiən, kəni nəmiəgəhiən u otol nɨki nətəmimi tagiən vivi. ");
INSERT INTO tnp_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Iəu u, Iətəmimi rəha Nəsal Viviən Sipsip Mɨn. Iətəmi təuvɨr u, iətəm tətəsal vivi o sipsip mɨn, in nɨkin tagiən əmə məmə otəfən nəmiəgəhiən rəhan o sipsip mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Sipsip mɨn, ilah rəha Iətəmimi rəha Nəsal Viviən e Sipsip Mɨn. Mətəu iətəmimi kəti iətəm kətətəou məmə in otətəsal o sipsip mɨn, in səniəmə iətəmi əhruahru rəha nəsaliən o sipsip. Səniəmə in rəhan əha sipsip mɨn. Kəni nəmə tafu kuri arpɨn kəti tuva məmə otus ilah, kəni in otaiu magɨm məpəh ilah. Kəni kuri arpɨn u, tuvən mus sipsip mɨn nəuvein, kəni məhgi atiti ilah kətiəh kətiəh. ");
INSERT INTO tnp_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Iətəmi tol lanəha, in otagɨm mətəu-inu kətətəou əmə in o nəsaliən o sipsip mɨn, mətəu e nɨkin, in təsəniən nati agɨn e sipsip mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Iəu u inu, iəu Iətəmimi rəha Nəsal Viviən o Sipsip Mɨn. Tatə Uhgɨn in təhrun iəu, kəni iəu iəkəhrun in, kəni e noliən əhmen əmə, iəu iəkəhrun rəhak sipsip mɨn, kəni rəhak sipsip mɨn ilah kotəhrun iəu. Iəu nɨkik tagiən əmə, məmə oiəkɨmɨs o nosmiəgəhiən ilah. ");
INSERT INTO tnp_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Rəhak mɨn nəuvein mɨn sipsip əpəha ikɨn, iətəm ilah kəsotatɨgiən e nɨpai u, mətəu iəu iəkəkeikei mit mɨn ilah kəhuva. Ilah mɨn, okəpanotəhrun nətəuiən nəuiak. Kəni sipsip mɨn u ilah rəfin u, okəhuva motuhapumɨn əmə ilah mɨn motol kətiəh. Kəni iətəmimi kətiəh əmə, in otateruh ilah. ");
INSERT INTO tnp_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Rəhak Tatə in tolkeikei pɨk iəu, mətəu-inu nɨkik tagiən əmə məmə iəkəfən rəhak nəmiəgəhiən o nətəmimi, məmə uərisɨg lanko, iəu iəkos mɨn nəmiəgəhiən rəhak. ");
INSERT INTO tnp_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Iətəmimi kəti tɨkə məmə otos rəkɨs nəmiəgəhiən rəhak, mətəu iəu aru əmə iəkəfən rəhak nəmiəgəhiən mətəu-inu iəu əmə iəkolkeikei lanəha. Iəu aru əmə iətos nepətiən məmə iəkəhlman e rəhak nəmiəgəhiən, kəni iəu aru əmə matos mɨn nepətiən məmə iəkaskəlɨm mɨn rəhak nəmiəgəhiən. Nati u inu, iətəm rəhak Tatə təməni=pa kəm iəu məmə iəkəkeikei mol.” ");
INSERT INTO tnp_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kəni nətəm Isrel u, ilah kəmotəhapu mɨn ilah mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ilah tepət kəutəni məmə, “!Suah u narmɨn tərah kəti tətatɨg lan! !Rəhn-kapə tətalməli! ?Təhro itəmah nəutətəlɨg lan?” ");
INSERT INTO tnp_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mətəu nəuvein mɨn, ilah kəutəni məmə, “Nəghatiən u, səniəmə nəghatiən rəha iətəmi narmɨn tərah tətatɨg lan. ?Nɨkitəmah təhti məmə, narmɨn tərah təhrun nol viviən iətəmi nəhmtɨn təməu, təuvɨr mɨn?” ");
INSERT INTO tnp_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tɨnuva e nian rəha nətəm Isrel iətəm kautol lafet kəti lan əpəha Jerusɨləm. Nərgɨn u, lafet rəha Nol Viviən Mɨn Nimə Rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Inəha e nian rəha nətəpuiən. Kəni Iesu təmətaliuək e fərantə kəti e Nimə Rəha Uhgɨn, nərgɨn u Fərantə Rəha Kig Solomən. ");
INSERT INTO tnp_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Kəni nətəmi asoli rəha nətəm Isrel nəuvein kəməhuva motəhtul, mohtəlau lan. Kəmotəni=pən kəm in məmə, “?Onəhgɨn kəni ik nəmanol itɨmah iəkotəhrun ik? Nəmə ik Krɨsto pəhriən iətəm Uhgɨn təməni məmə otahli=pa, nəkəni=pa vivi kəm tɨmah.” ");
INSERT INTO tnp_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Kəni Iesu təni=pən kəm lah məmə, “Iəu iəməni=pɨnə rəkɨs kəm təmah, mətəu itəmah nəsotəhatətəiən lak. Nəmtətiən mɨn u iətəm iatol e nərgɨ rəhak Tatə, ilah kautol nəfɨgəmiən e nəghatiən rəhak, ");
INSERT INTO tnp_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","mətəu itəmah nəsotəhatətəiən lak, mətəu-inko itəmah səniəmə rəhak mɨn sipsip mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Rəhak sipsip mɨn ilah kəutətəu nəuiak kəni motəhrun. Iəu iəkəhrun vivi ilah, kəni ilah kəutuərisɨg lak. ");
INSERT INTO tnp_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Kəni iəu iətəfən nəmiəgəhiən itulɨn u naunun tɨkə kəm lah, ilah ko kəsohmɨsiən nian kəti mɨne. Kəni iətəmimi kəti mɨne ko təsiuvi rəkɨsiən ilah e nəhlmək. ");
INSERT INTO tnp_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Rəhak Tatə iətəm təməfa ilah kəm iəu, in təsanən tapirəkɨs natimnati mɨn rəfin. Tol lanəha, kəni iətəmi kəti ko təsiuvi rəkɨsiən ilah e nəhlmɨn. ");
INSERT INTO tnp_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Itɨmlau rəhak Tatə, itɨmlau kətiəh əmə.” ");
INSERT INTO tnp_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Kəni nətəm Isrel kəmotəmki mɨn kəpiel apɨn, məmə okotəhti in lan. ");
INSERT INTO tnp_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Mətəu Iesu təni=pən kəm lah məmə, “Iəu inol rəkɨs nəmtətiən təuvɨr mɨn tepət e nəhmtɨtəmah. Nəmtətiən mɨn əha ilah əha, rəhak Tatə təməfa məmə iəu iəkol. ?Mətəu nəmtətiən əhro u itəmah nəkotəni məmə onəkotəhti iəu ohni e kəpiel apɨn?” ");
INSERT INTO tnp_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Kəni ilah kotəni məmə, “Itɨmah iəsotəniən məmə iəkotəhti ik e kəpiel apɨn o nati apɨspɨs təuvɨr u ik natol. Itɨmah iəkotəni məmə iəkotəhti ik mətəu-inu nətəni rah Uhgɨn. Ik iətəmimi əmə, mətəu ik nətəni məmə ik Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Kəni Iesu təni=pən kəm lah məmə, “Kəmətei=pən aupən, e rəhatəmah əhruahru Lou, məmə Uhgɨn təməni=pən kəm lah məmə, ‘Itəmah uhgɨn mɨn.’ ");
INSERT INTO tnp_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kəni kitah kotəhrun məmə Nauəuə Rəha Uhgɨn, ko təsəuhliniən, in nɨpəhriəniən əmə. Uhgɨn təməfa nəghatiən rəhan kəm nətəmimi nəuvein. ?Tol lanəha, nəmə Uhgɨn təmətəghati e nətəmi mɨn u, kəni məni ilah məmə uhgɨn mɨn, ");
INSERT INTO tnp_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","kəni nəkotəhro məutahi iəu məutəni məmə iəu iətəni rah Uhgɨn mətəu iətəni məmə iəu Nətɨ Uhgɨn? Iəu u inu, iətəm Tatə Uhgɨn in təmələhu=pən iəu məmə rəhan pɨsɨn əmə, kəni mol əpenə-penə iəu, məmə otahli=pa iəu iəkuva e nəhue nɨftəni. ");
INSERT INTO tnp_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Nəmə iəsoliən nəmtətiən mɨn iətəm rəhak Tatə tatol, kəni sotəhatətəiən lak. ");
INSERT INTO tnp_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Mətəu nəmə iatol nəmtətiən mɨn u rəhak Tatə tatol, kəni nati əpnapɨn məmə itəmah nəsotəhatətəiən e rəhak nəghatiən mɨn, mətəu təuvɨr məmə onəkotəhatətə e nəmtətiən mɨn rəhak. Kəni tol lanəha, itəmah onəmanotəhrun vivi agɨn məmə Tatə Uhgɨn tətatɨg lak, kəni iətatɨg e Tatə Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tol lanəha, e nəghatiən mɨn u, ilah kəmotolkeikei mɨn məmə okotaskəlɨm in, mətəu in təmiet e lah magɨm. ");
INSERT INTO tnp_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","In təmohapumɨn=pən mɨn e nəve nəhu Jotən, muvən əpəha Jon təmatol bəptais e nətəmimi ikɨn aupən. Kəni mətatɨg əha ikɨn əha. ");
INSERT INTO tnp_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Kəni nətəmimi tepət kəməhuva ohni, kəni motəni məmə, “Jon təməsoliən nəmtətiən kəti mɨne. Mətəu nəghatiən mɨn iətəm in təmətəni e suah u, ilah rəfin nɨpəhriəniən əmə.” ");
INSERT INTO tnp_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kəni ikɨn əha, nətəmimi tepət kəmotəhatətə e Iesu. ");
INSERT INTO tnp_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Iətəm Petəni kəti, nərgɨn u Lasɨrɨs, tatɨmɨs. Petəni, in lahuənu kəti, ima Meri mɨne pian Matə. ");
INSERT INTO tnp_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Meri u, inu, uərisɨg otəpanəueiu nəhlkɨ Iərmənɨg rəhatah e səntə, kəni mafəl e nəuanun, tasɨk. Kəni pətan u, rəhan u kakə Lasɨrɨs u tatɨmɨs. ");
INSERT INTO tnp_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Tol lanəha, nəuvɨnɨ Lasɨrɨs mil kuahli=pən nəghatiən o Iesu məmə, “Iətəmi asoli, ik kəti u iətəm nəkolkeikei pɨk, in tatɨmɨs.” ");
INSERT INTO tnp_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nian Iesu təmətəu nəghatiən u, kəni in təni məmə, “Lasɨrɨs tatɨmɨs, mətəu rəhan nɨmɨsiən əha, ko təsoliən in tɨmɨs agɨn. Nɨmɨsiən əha rəhan otol məmə nətəmimi okotəfəri motəni-vivi Uhgɨn ohni. Kəni nɨmɨsiən əha otol məmə nətəmimi okotəfəri motəni-vivi Nətɨ Uhgɨn ohni.” ");
INSERT INTO tnp_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iesu tolkeikei pɨk Matə mɨne pian, mɨne rəhalau kakə Lasɨrɨs. ");
INSERT INTO tnp_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Tol lanəha, nian tətətəu pau məmə Lasɨrɨs tatɨmɨs, in təmatɨg mos nian keiu əpəha ikɨn tətatɨg ikɨn. ");
INSERT INTO tnp_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kəni uərisɨg, təni=pən kəm rəhan mɨn nətəmimi məmə, “Pəh kohtəlɨg=pən mɨn Jutiə.” ");
INSERT INTO tnp_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Mətəu rəhan mɨn nətəmimi kotəni=pən, kəm in məmə, “Iəgətun, rəueiu əmə uəha, nətəmimi asoli rəha Isrel əha ikɨn əha kəmotəni məmə okotahtɨmu ik e kəpiel apɨn. ?Mətəu ik nəkəni məmə onəkɨtəlɨg=pən mɨn ikɨn əha?” ");
INSERT INTO tnp_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Kəni Iesu təni=pən kəm lah məmə, “Itəmah nəkotəhrun məmə tueləf auə lənian. Nəmə iətəmimi tətaliuək lənian, ko təsoriniən nəhlkɨn e kəpiel kəti, mətəu-inu tateruh nati e nəhagəhagiən rəha nəhue nɨftəni. ");
INSERT INTO tnp_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Mətəu nəmə in tətaliuək lapɨn, in təhrun noriniən nəhlkɨn e kəpiel kəti, mətəu-inu rəhan nəhagəhagiən tɨkə.” ");
INSERT INTO tnp_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Iesu tɨnəni rəkɨs nəghatiən əha, kəni in məni=pən kəm lah məmə, “Kitah kəti u Lasɨrɨs, in tətapɨli. Mətəu iəu oiəkuvən əha ikɨn məhgi-pəri.” ");
INSERT INTO tnp_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Kəni rəhan mɨn nətəmimi kotəni=pən kəm in məmə, “Iətəmi asoli, nəmə in tətapɨli, kəni rəhan nɨmɨsiən otɨkə. !In otətəu təuvɨr mɨn!” ");
INSERT INTO tnp_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","E nəghatiən u rəha Iesu, nɨpətɨn u məmə Lasɨrɨs tɨnɨmɨs rəkɨs. Mətəu ilah nɨkilah təhti məmə Lasɨrɨs in tətapɨli əmə. ");
INSERT INTO tnp_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kəni Iesu təməni=pən vivi məmə, “Lasɨrɨs tɨnɨmɨs rəkɨs. ");
INSERT INTO tnp_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nian nɨkik tətəhti itəmah, nɨkik tagiən məmə iəməsatɨgiən itɨmlau min, mətəu-inu nati u, otasiru e təmah məmə onəkotəhatətə lak. Mətəu təuvɨr məmə pəh kəhuvən moteh in.” ");
INSERT INTO tnp_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Kəni Toməs u, kətauɨn lan məmə, Mil-Mil, in təni=pən kəm nətəmimi nəuvein mɨn rəha Iesu məmə, “Təuvɨr, pəh kitah rəfin kəhuvən, məmə kitah rəfin okohmɨs əmə kitah min.” ");
INSERT INTO tnp_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nian Iesu təmietɨgəm=pən Petəni, kəni təmətəu məmə kəmɨtənɨm Lasɨrɨs tɨnos nian kuvət rəkɨs. ");
INSERT INTO tnp_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Lahuənu u, Petəni, in iuəkɨr əmə o Jerusɨləm, nəmə təhro suaru lan təhmen e kilomitə kɨsɨl, ");
INSERT INTO tnp_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","kəni nətəm Isrel tepət kəməhuva məmə okoteh Matə mɨne Meri o nəfəriən nətəlɨgiən rəhalau mətəu-inu kətuətəu tərah o rəhalau kakə təmɨmɨs. ");
INSERT INTO tnp_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Kəni nian Matə təmətəu məmə Iesu tətuva, in təməhtul muvən məmə oteruh. Mətəu Meri, in təmətəharəg əmə imə. ");
INSERT INTO tnp_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Kəni Matə təməni=pən kəm Iesu məmə, “Iətəmi asoli, nəmə ik nəmətatɨg u ikɨnu, ko rəhak kakə təməsɨmɨsiən. ");
INSERT INTO tnp_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mətəu iəu iəkəhrun məmə nati nak onəkətapuəh lan kəm Uhgɨn, kəni Uhgɨn otəpanəfɨnə kəm ik.” ");
INSERT INTO tnp_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Kəni Iesu təni=pən kəm in məmə, “Rəham kakə otəpanəmiəgəh mɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Matə təni məmə, “Əuəh. Iəu iəkəhrun məmə Lasɨrɨs otəmanəmiəgəh mɨn e Naunun Nian, iətəm nətəmimi rəfin kəmohmɨs okotair=pa mɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Kəni Iesu təni=pən kəm in məmə, “Iəu u, iəu Nəukətɨ Nair=pa Mɨniən e Nɨmɨsiən, kəni iəu mɨn, iəu Nəukətɨ Nəmiəgəhiən. Iətəmimi iətəm in otəhatətə lak, nati əpnapɨn məmə in təmɨmɨs, mətəu in otəmiəgəh mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Kəni iətəmi iətəm tətəmiəgəh kəni mətəhatətə lak, in ko təsɨmɨsiən agɨn nian kəti mɨne. ?Nətəhatətə e nəghatiən u rəhak?” ");
INSERT INTO tnp_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Matə təni=pən kəm in məmə, “Əuəh, Iərmənɨg. Iəu inəhatətə lam, məmə ik Krɨsto iətəm Uhgɨn təməni məmə otahli=pa. Ik Nətɨ Uhgɨn. Ik u inu, aupən kəməni e Nauəuə Rəha Uhgɨn məmə ik onəpanuva e nəhue nɨftəni.” ");
INSERT INTO tnp_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nian Matə tɨnəni rəkɨs nəghatiən u, kəni muvən məmə otəni=pən kəm pian Meri tuva. Təmuvən kəni masiuən=pən e matəlgɨn məmə, “Iəgətun tɨnuva rəkɨs. Tolkeikei məmə oteruh ik.” ");
INSERT INTO tnp_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Kəni nian Meri təmətəu nəghatiən u, təməhtul uəhai əmə, matuvən məmə oteruh Iesu. ");
INSERT INTO tnp_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Iesu in təsuvən əhanəhiən lahuənu, in tətəhtul əha ikɨn Matə təmuvən ikɨn meh. ");
INSERT INTO tnp_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Kəni nətəm Isrel mɨn u kəməutəharəg imə ilah Meri, məutəfəri rəhan nətəlɨgiən. Nian kəmoteruh in təməhtul uəhai əmə matuvən ihluə, kəni ilah kohuərisɨg lan. Nɨkilah təhti məmə tatuvən e suvət, otasək. ");
INSERT INTO tnp_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Meri təmiet=pən u ikɨn Iesu tətəhtul ikɨn, kəni nian təmeruh Iesu, in təmasiəulɨn məni=pən kəm in məmə, “Iətəmi asoli, nəmə ik nəmətatɨg u ikɨnu, kəni ko rəhak kakə təsɨmɨsiən.” ");
INSERT INTO tnp_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nian Iesu təmeruh məmə pətan u mɨne nətəmimi mɨn u ilah min kəutasək, in təmətəu tərah pɨk, nɨkin təfɨgəm. ");
INSERT INTO tnp_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Kəni in təmətapuəh o lah məmə, “?Nəmohtənɨm iə?” Kəni ilah kəmotəni=pən kəm in məmə, “Iətəmi asoli, va-to meruh.” ");
INSERT INTO tnp_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iesu, nəhu nəhmtɨn təmaiəh. ");
INSERT INTO tnp_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kəni nətəm Isrel mɨn u, ilah kotəni məmə, “Ei, nətəmimi. !In təmolkeikei pɨk agɨn suah u tapirəkɨs!” ");
INSERT INTO tnp_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Mətəu ilah nəuvein mɨn kotəni məmə, “Suah kəha inəha aupən, təmol vivi iətəm nəhmtɨn təpɨs. ?Kəni təhro məsəniəhuiən Lasɨrɨs məmə təsɨmɨsiən?” ");
INSERT INTO tnp_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Kəni Iesu təmətəu mɨn tərah pɨk, kəni in təmuvən əpəha e suvət. Ilah kəmohtənɨm Lasɨrɨs əpəha e nɨpəg kəpiel kəti, kəni motləfən mɨn kəpiel kəti mɨn motahtɨpəsɨg=pən nɨpəg kəpiel lan. Inu rəhalah noliən. ");
INSERT INTO tnp_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Kəni Iesu təni=pən məmə, “Otahuvihin rəkɨs-to kəpiel.” Kəni Matə u, nəuvɨnɨ Lasɨrɨs, təni=pən kəm Iesu məmə, “!Mətəu iətəmi asoli, in tɨnəpien rəkɨs! Kəmɨtənim tɨnos nian kuvət rəkɨs.” ");
INSERT INTO tnp_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Mətəu Iesu təni=pən kəm in məmə, “?Təhro? ?Ik nɨnalu məmə iəməni=pɨnə rəkɨs kəm ik məmə nəmə nəkəhatətə lak kəni onəkeh nəsanəniən asoli mɨne nepətiən əhagəhag rəha Uhgɨn?” ");
INSERT INTO tnp_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tol lanəha, ilah kəmotahuvihin rəkɨs kəpiel. Kəni Iesu təməsal-pəri kəni məni məmə, “Tatə, iəu iətəni tagkiu ohnik mətəu-inu nəmətəu rəkɨs rəhak nəghatiən. ");
INSERT INTO tnp_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Kəni iəkəhrun məmə e nian rəfin, natətəu iəu. Mətəu iətəni nəghatiən u, o nətəmi mɨn u, nətəm kautəhtul tɨtəlau lak, məmə ilah okotəhatətə məmə ik nəmahli=pa iəu.” ");
INSERT INTO tnp_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kəni əmeiko, nian Iesu tɨnəni rəkɨs nəghatiən u, in təmauɨn əfəməh məmə, “!Lasɨrɨs, əhtul miet!” ");
INSERT INTO tnp_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","!Kəni Lasɨrɨs təməhtul miet mətmətɨg əmə, napən mɨn u iətəm kəmatu-ərain nəhlmɨn mɨne nəhlkɨn mɨne nəhmtɨn mɨne lan tətatɨg əhanəh lan! Kəni Iesu təni=pən kəm lah məmə, “Ohtɨs rəkɨs napən mɨn əha, pəh in taliuək.” ");
INSERT INTO tnp_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nətəm Isrel nətəm kəməhuva o Meri kəni moteh natimnati mɨn u iətəm Iesu təmol, ilah tepət kəmotəhatətə lan. ");
INSERT INTO tnp_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Mətəu ilah mɨn nəuvein kəməhuvən o Farəsi mɨn, kəni motəni pətɨgəm kəm lah natimnati mɨn rəfin iətəm Iesu təmol. ");
INSERT INTO tnp_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kəni o nati u, Farəsi mɨn u mɨne pris asoli mɨn ilah kəmotaskəlɨm nuhapumɨniən asoli kəti rəhalah, kəni ilah kəmotəni kəm lah mɨn məmə, “?Okotəhro lanu? Suah kəha tɨnatol nəmtətiən tepət. ");
INSERT INTO tnp_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nəmə kotəpəh əmə, tatol lanəha, kəni nətəmimi rəfin okotəhatətə lan, kəni nətəm Rom ilah okəhuva motərəkɨn Nimə Rəha Uhgɨn mɨne nɨtəni rəhatah, kəni motos rəkɨs ilau e nəhlmɨtah.” ");
INSERT INTO tnp_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kəni ilah kəti u, nərgɨn u Kaiəfəs, in pris asoli agɨn e nu əha. Tol lanəha, in təməni məmə, “Itəmah nəkotəruru agɨn nati u. ");
INSERT INTO tnp_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","?Təhro itəmah nəsotəhruniən? ?Itəmah nəsotəhruniən məmə təuvɨr nəuvetɨn o təmah məmə iətəmi kətiəh əmə otɨmɨs o nətəmimi, tapirəkɨs məmə kəntri apiəpiə otɨmɨs?” ");
INSERT INTO tnp_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Nian in tɨnəni nəghatiən u, in təməsəni aruiən e nətəlɨgiən əmə rəhan. In pris asoli agɨn e nu əha, kəni in təmaupən məni pətɨgəm nəghatiən iətəm Uhgɨn təməfən kəm in. Kəni in təməni məmə Iesu in otɨmɨs o nosmiəgəhiən nətəm Isrel. ");
INSERT INTO tnp_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Kəni mətəu rəhan nɨmɨsiən, səniəmə o nosmiəgəhiən nətəm Isrel əmə, mətəu o nosmiəgəh mɨniən nenətɨ Uhgɨn mɨn nətəm kəutan atiti e nəhue nɨtəni mɨn, kəni mol ilah kəhuva motol kətiəh əmə. ");
INSERT INTO tnp_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tol lanəha, e nian əha, ilah kəmotegəhan lan məmə okotəkeikei motəsal e suaru kəti o nuhamuiən Iesu. ");
INSERT INTO tnp_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kəni o nati u, Iesu təsaliuək pətɨgəmiən mɨn ikɨn mɨn e Jutiə, in təmagɨm ikɨnu, muvən əpəha e taun kəti, nərgɨn u Efraim. Taun u, in iuəkɨr əmə o ikɨn təpiə-məpiə ikɨn. Kəni in mətatɨg ikɨn əha, ilah rəhan mɨn nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tɨnatuvən iuəkɨr o nian rəha lafet kəti rəha nətəm Isrel, nərgɨn u, lafet rəha Pasova. Kəni nətəmimi tepət kɨnautohiet ikɨn pɨsɨn pɨsɨn mɨn mɨnəutəhuva Jerusɨləm məmə okotol natimnati mɨn məmə ilah okotaruətuəh e nəhmtɨ Uhgɨn, uərisɨg ko, kəmanotətuəuin e lafet əha. ");
INSERT INTO tnp_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Kəni nətəmi mɨn əha kɨnəutəsal e Iesu. Kəni nian kəmotuhapumɨn e Nimə Rəha Uhgɨn, kɨnəutətapuəh-ətapuəh o lah mɨn məmə, “?Kəruru mə Iesu otuva e lafet u, uə kəpə?” ");
INSERT INTO tnp_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Mətəu e nian əha, pris asoli mɨn mɨne Farəsi mɨn kəmotələhu nəghatiən kəti, məmə nəmə iətəmimi kəti təhrun ikɨn Iesu tətatɨg ikɨn, in otəkeikei muva məni pətɨgəm kəm lah, pəh soldiə mɨn kəhuvən motaskəlɨm. ");
INSERT INTO tnp_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nian sikɨs əha ikɨn tətatɨg əhanəh kəpənan e nian rəha lafet rəha Pasova, kəni Iesu tɨnɨtəlɨg=pa mɨn Petəni, ima Lasɨrɨs ikɨn. Suah u inu, Lasɨrɨs Iesu in təmol in təmiəgəh mɨn e nɨmɨsiən. ");
INSERT INTO tnp_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kəni nətəmimi ikɨnu, kəmotol nauəniən kəti rəha Iesu e nimə rəha Matə. Kəni in tos nauəniən, muva. Kəni Lasɨrɨs mɨn əha ikɨn e nauəniən əha, ilah Iesu mɨne, kautəməhli=pən məutauən. ");
INSERT INTO tnp_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kəni Meri təmos səntə kəti təməri e nɨlosɨ nati, muva. Səntə u, kəmol e nokɨ nard. Səntə əha, nəmiəvɨn təuvɨr, kəni nəhmtɨn tiəkɨs. Kəni in təməueiu nəhlkɨ Iesu e səntə u, kəni mafəl e nəuanun. Nəmiəvɨ səntə u, təməriauəh rəfin e nɨpəgnəuan nimə. ");
INSERT INTO tnp_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Mətəu iətəmimi kəti rəha Iesu, nərgɨn u Jutəs Iskariot, suah u inu uərisɨg lanko təpanegəhan=pən e Iesu e nəhlmɨ rəhan tɨkɨmɨr mɨn, in təmahi ohni. In təməni məmə, ");
INSERT INTO tnp_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“?Ik nəkəruru noliən səlɨm e səntə u, mos məni lan, kəni məfən kəm nanrah mɨn? Səntə, in təhmen e məni u, tri-hanrɨt tənariəs.” ");
INSERT INTO tnp_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","In təməni lanəha, mətəu səniəmə in tatol nati agɨn e nanrah mɨn, mətəu in təməni əmə, mətəu-inu in iakləh. In tatos kətɨm rəha məni rəhalah, kəni nian nəuvein, in tətakləh lan. ");
INSERT INTO tnp_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Mətəu Iesu təni məmə, “Upəh-to pətan u. Sərəkɨniən rəhan nətəlɨgiən. In təmətələhu vivi səntə u, məmə otəueiu nɨpətɨk, o nian əha iətəm okɨtənɨm iəu lan. ");
INSERT INTO tnp_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nanrah mɨn, nian rəfin itəmah min ilah nəutatɨg. Mətəu iəu, ko iəsatɨgiən nian rəfin kitah min itəmah.” ");
INSERT INTO tnp_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Kəni nian nɨmənin nətəm Jutiə kəmotətəu məmə Iesu tətatɨg lahuənu Petəni, kəni ilah kɨnəhuvən ikɨn. Kəsəhuvaiən əmə məmə okoteh Iesu, mətəu ilah kəməhuva mɨn məmə okoteh-to Lasɨrɨs u təmɨmɨs, kəni Iesu tol mɨn təmiəgəh. ");
INSERT INTO tnp_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kəni əmeiko, pris asoli mɨn, kəmotegəhan lan mɨn məmə okəkeikei kohamu mɨn Lasɨrɨs, ");
INSERT INTO tnp_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","mətəu-inu nian nətəm Isrel tepət kəmoteruh Lasɨrɨs təməmiəgəh mɨn, kəni ilah kəmotəhatətə e Iesu, kəni mɨnautəpəh rəhalah nətəmimi asoli mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kəməni lauɨg lan, nɨmənin nətəmimi nətəm kəməhuva Jerusɨləm məmə okotol lafet rəha Pasova, kəmotətəu məmə Iesu tətaliuək mɨnatuvən e taun. ");
INSERT INTO tnp_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Kəni tol lanəha, ilah kəmohiet e taun u, mautəmki nati kəti təhmen e nɨmalɨ nəmɨl mautəhuvən məmə okoteruh Iesu. Kəni məutagət əfəməh mautəni məmə, “!Hosanə! !Iərmənɨg Uhgɨn tətatɨg ilau suah u iətəm tətuva e nərgɨn! !Iərmənɨg Uhgɨn tətatɨg ilau Kig u rəha nətəm Isrel!” ");
INSERT INTO tnp_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Kəni Iesu təmeruh nətɨ togki kəti, kəni tasuə lan maliuək matuvən. Natimnati mɨn u, Nauəuə Rəha Uhgɨn tɨnəni rəkɨs məmə, ");
INSERT INTO tnp_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Nətəm Jerusɨləm, Itəmah sotəgɨniən. !Oteruh-to! !Kig rəhatəmah tətuva, in tətasuə e nətɨ togki maliuək mətuva, mətuva!” ");
INSERT INTO tnp_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","E nian əha, nətəmimi rəha Iesu ilah kotəruru nɨpətɨ nati u. Mətəu uərisɨg, nian Iesu tɨnəmiəgəh mɨn e nɨmɨsiən, kəni Uhgɨn tɨnol əpu rəkɨs nepətiən rəha Iesu, kəni nɨkilah təpanəhti məmə aupən, kəmətei rəkɨs nəghatiən lan e Nauəuə Rəha Uhgɨn, konu nətəmimi kɨnotol nəghatiən mɨn əha, tɨnuva mɨnol nɨpəhriəniən lan. ");
INSERT INTO tnp_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","E nian Iesu təmauɨn e Lasɨrɨs, kəni Lasɨrɨs tiet e nɨpəg kəpiel məmiəgəh mɨn, nɨmənin nətəmimi tepət ilah Iesu e ikɨn əha e nian əha. Kəni ilah kəməutanus natimnati u in təmol. ");
INSERT INTO tnp_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tol lanəha, nətəmimi tepət kəməhuva məmə okoteruh Iesu, mətəu-inu kəmotətəu məmə in təmol nəmtətiən əha. ");
INSERT INTO tnp_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kəni Farəsi mɨn kɨnautəni-əni kəm lah mɨn məmə, “!Oteruh-to, ko kitah kəsotol agɨniən nati kəti. Rəueiu əha, nətəmimi rəfin e nəhue nɨftəni kɨnautəhuərisɨg lan!” ");
INSERT INTO tnp_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kəni nian nətəmimi kəməhuvən Jerusɨləm məmə okotəfaki e nian rəha lafet u, kəni nətəm Kris nəuvein mɨn əha ikɨn ilah min, kəmautəfaki. ");
INSERT INTO tnp_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nətəm Kris mɨn u kəməhuva moteh Fɨlɨp. Fɨlɨp in iətəm Petsaitə əpəha Kaləli. Kəni ilah kəmotəni=pən kəm in məmə, “Iətəmi asoli, iəkotolkeikei məmə iəkoteruh Iesu.” ");
INSERT INTO tnp_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Kəni Fɨlɨp təhtul muvən məni=pən kəm Antɨru, kəni ilau kəmian muəni=pən kəm Iesu. ");
INSERT INTO tnp_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Kəni Iesu təməni=pən kəm lah məmə, “Rəueiu əha, Nətɨ Iətəmimi, rəhan nian tɨnuva rəkɨs, məmə Uhgɨn otol əpu rəhan nepətiən. ");
INSERT INTO tnp_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nɨpəhriəniən agɨn u iətəni kəm təmah məmə, iətəmimi otəkeikei mɨtənɨm nɨkɨtɨ nati e nɨftəni keruh məmə tɨmɨs. Nəmə təsɨmɨsiən, ko təseviəiən kəni məsəuəiən. Mətəu nəmə otɨmɨs, kəni otəuə e nəuan tepət. ");
INSERT INTO tnp_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Kəni tol lanu, iətəmi nɨkin tətəhti pɨk rəhan nəmiəgəhiən e nəhue nɨftəni u, in otəmkarəpən lan. Mətəu iətəmi iətəm nɨkin təsəhti pɨkiən lanəha rəhan nəmiəgəhiən e nəhue nɨftəni u, in otaskəlɨm vivi nəmiəgəhiən rəhan o nəmiəgəhiən itulɨn. ");
INSERT INTO tnp_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Iətəmi tolkeikei məmə otol uək rəhak, in otəkeikei muərisɨg lak, kəni nəmə ikɨn pəhruvən iəu iəkatɨg ikɨn, kəni in mɨn, in otatɨg ikɨn. Kəni iətəmi tatol uək rəhak, Tatə Uhgɨn otɨsiai in.” ");
INSERT INTO tnp_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Kəni Iesu təməni=pən kəm lah məmə, “Rəueiu əha, nɨkik tətahmə pɨk. ?Oiəkəhrol lanu? Ko iəsəniən məmə, ‘Tatə, oh rəkɨs nahməiən iətəm tətuva ohniəu.’ Nati u inu, iəu iəmuva ohni. ");
INSERT INTO tnp_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tatə, ik əfəri aru nərgəm.” Kəni əmeiko, rəueiu agɨn ilah kəmotətəu nəuia iətəmi kəti təmsɨpəri=pən e neai tətəni məmə, “Iəu inəfəri rəkɨs nərgək, kəni rəueiu əha, oiəkəfəri mɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kəni nətəmimi nətəm kəməutəhtul iuəkɨr ohni kəmotətəu nəuia iətəmi əha, kəni ilah nəuvein kotəni məmə, “!Nətəmimi! ?Nati nak u? ?Kaluəluə kəti, uə?” Mətəu nəuvein kotəni məmə, “Agelo kəti əha tətəghati kəm in.” ");
INSERT INTO tnp_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Mətəu Iesu təni=pən kəm lah məmə, “Nəuia iətəmi u, təməsuvaiən məmə iəu iəkətəu. Mətəu təmuva məmə itəmah onəkotətəu. ");
INSERT INTO tnp_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Rəueiu əha tɨnol nian iətəm Uhgɨn otakil noliən rəha nətəmimi e nəhue nɨftəni. Rəueiu əha, in otoh iahu nəsanəniən rəha Setən, iərmənɨg rəha nəhue nɨftəni u. ");
INSERT INTO tnp_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nian kətəfəri iəu ilɨs, kəni ko iəu oiəkiuvi=pa nətəmimi rəfin kəhuva ohniəu.” ");
INSERT INTO tnp_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","E nəghatiən u, in tɨnuahpɨk e nɨmɨsiən rəhan məmə otəhro lanu mɨmɨs. ");
INSERT INTO tnp_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Kəni nətəmimi kəmotəni=pən kəm in motəni məmə, “Itɨmah iəmotətəu rəkɨs e Lou rəhatah, məmə nian Krɨsto iətəm Uhgɨn təməni məmə otahli=pa tuva, in otətatɨg itulɨn əmə, mətuvən əmə lanko naunun tɨkə. ?Təhro ik nətəni məmə nətəmimi okotəkeikei motəfəri Nətɨ Iətəmimi? ?Mətəu Nətɨ Iətəmimi u, in pəh?” ");
INSERT INTO tnp_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Kəni Iesu təməni=pən kəm lah məmə, “Nəhagəhagiən u, tətatɨg o təmah o nian əkəku əmə. Kəni nian nəhagəhagiən u, tətatɨg o təmah, itəmah nəkotəkeikei motaliuək lan. Nəmə kəpə, kəni napinəpuiən otətəuarus itəmah. Kəni iətəmimi iətəm tətaliuək e napinəpuiən, in təruru ikɨn in tatuvən ikɨn. ");
INSERT INTO tnp_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nian nəhagəhagiən u tətatɨg əhanəh o təmah, itəmah nəkotəkeikei motəhatətə e nəhagəhagiən u məmə itəmah nəkəhuva nenətɨ nəhagəhagiən.” Nian Iesu təməni rəkɨs nəghatiən u kəm lah, kəni magɨm məpəh ilah muvən mətəhluaig. ");
INSERT INTO tnp_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nati əpnapɨn məmə in tɨnol rəkɨs nəmtətiən tepət e nəhmtɨ nətəm Isrel, mətəu ilah kəsotəhatətəiən lan. ");
INSERT INTO tnp_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Iəni rəha Uhgɨn u Aiseə, təmaupən mətəghati e rəhalah noliən. Kəni nati u təmuva məmə otol nəghatiən rəhan tuva mol nɨpəhriəniən lan. In təməni məmə, “?Iərmənɨg, pəh otəhatətə e nəghatiən rəhatɨmah, uə kətiəh əmə mɨne? ?Iəutəni pətɨgəm, kəni pəh otəhatətə lan, uə kətiəh əmə mɨne? ?Kəni Iərmənɨg otol əpu kəm pəh nahgin iətəm təsanən pɨk o nosmiəgəhiən?” ");
INSERT INTO tnp_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Konu ilah kotəruru nəhatətəiən lan mətəu-inu təhmen=pən əmə məmə Aiseə təməni pətɨgəm mɨn aupən məmə, ");
INSERT INTO tnp_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“In təmol ilah məmə nəhmtɨlah otəpɨs. Nəmə təsəpɨsiən, kəni ilah okoteruh nati kəni motəhrun. Kəni in tɨnahtɨpəsɨg rəkɨs e nɨkilah. Nəmə təsoliən, kəni ilah okoteinatɨg kəni motəhrun nəuhliniən nətəlɨgiən rəhalah, kəni motəhatətə lak, iəkol nəmiəgəhiən rəhalah, otuvi mɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Iəni rəha Uhgɨn, Aiseə u aupən, təməni lanu lan mətəu-inu in təmeruh nepətiən əhagəhag rəha Iesu, kəni tol lanəha, in tətəghati lan. ");
INSERT INTO tnp_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kəni mətəu, nətəmi asoli mɨn tepət nəuvetɨn, ilah mɨn kəmotəhatətə e Iesu. Mətəu ilah kəutəgɨn e nəni pətɨgəmiən məmə ilah kəmotəhatətə lan, mətəu-inu kəutəgɨn e Farəsi mɨn məmə məta kotahli pətɨgəm ilah e nimə rəha nuhapumɨniən, ");
INSERT INTO tnp_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","mətəu-inu nətəmi asoli mɨn u, ilah kotolkeikei pɨk məmə nətəmimi okotəni-vivi ilah, tapirəkɨs məmə Uhgɨn nɨkin, otagiən o lah. ");
INSERT INTO tnp_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Kəni Iesu təmagət əfəməh məmə, “Iətəmimi iətəm tətəhatətə lak, səniəmə tətəhatətə pɨsɨn əmə lak, mətəu tətəhatətə mɨn e Uhgɨn iətəm təmahli=pa iəu. ");
INSERT INTO tnp_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kəni iətəmimi u iətəm təmeruh iəu, səniəmə təmeruh əmə iəu. In təmeruh mɨn Uhgɨn u təmahli=pa iəu. ");
INSERT INTO tnp_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Iəu u nəhagəhagiən. Iəmuva e nəhue nɨftəni u, məmə iətəmimi iətəm otəhatətə lak, otəsatɨgiən e napinəpuiən. ");
INSERT INTO tnp_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Iətəmimi iətəm tətətəu rəhak nəghatiən, məsoliən, ko iəu iəsəni pətɨgəmiən rəhan nalpɨniən, mətəu-inu iəməsuvaiən e nəhue nɨftəni u məmə iəkəni pətɨgəm nalpɨniən rəha nətəmimi. Mətəu iəmuva məmə iəkosmiəgəh ilah. ");
INSERT INTO tnp_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mətəu iətəmimi iətəm tətəuhlin=pa nəmtahn kəm iəu, məsosiən rəhak nəghatiən, nati kəti əha ikɨn tətatɨg məmə in otəni pətɨgəm rəhan nalpɨniən. E Naunun Nian, nəghatiən mɨn u rəhak, ilah okotəni pətɨgəm nalpɨniən rəhan. ");
INSERT INTO tnp_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tol lanəha mətəu-inu nəghatiən mɨn u, səniəmə rəhak pɨsɨn əmə, mətəu Tatə Uhgɨn u təmahli=pa iəu, kəni in təməni məmə iəkəkeikei muvən məni lanəha, kəni məghati lanəha. ");
INSERT INTO tnp_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Kəni iəu inəhrun rəkɨs məmə nəghatiən mɨn u, iətəm in təməni=pa kəm iəu, nəmiəgəhiən itulɨn tətatɨg lan. Kəni tol lanəha, nəghatiən mɨn u iətəni ilah, Tatə Uhgɨn təməni=pa kəni məgətun iəu lan, məmə iəkəni.” ");
INSERT INTO tnp_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Tɨnuva mətəuarus nian nətəm Isrel kotol lafet lan, lafet rəha Pasova, kəni Iesu tɨnəhrun məmə rəhan nian tɨnuva rəkɨs məmə otəpəh nəhue nɨftəni u, muvən meruh Tatə Uhgɨn. Nian rəfin in təmatolkeikei pɨk rəhan nətəmimi u kəutatɨg e nəhue nɨftəni, kəni mətəu rəueiu in tətəgətun əsas rəhan nolkeikeiən kəm lah muvən mətəuarus naunun nian rəhan. ");
INSERT INTO tnp_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Tɨnəhnaiuv, Iesu mɨne rəhan mɨn nətəmimi kəməutauən, kəni Setən tɨnəfən rəkɨs nətəlɨgiən e nɨki Jutəs Iskariot, nətɨ Saimon, məmə in otətuati e Iesu tuvən e nəhlmɨ rəhan tɨkɨmɨr mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iesu təməhrun məmə Tatə Uhgɨn təmələhu=pən rəkɨs natimnati rəfin u e nəhlmɨn, kəni tɨnəhrun mɨn məmə in təmsɨpən e Uhgɨn, kəni in otəpanɨtəlɨg=pən mɨn o Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Tol lanəha, in təməhtul, kəni məpeg rəkɨs rəhan sot asoli, kəni matu in e tauɨl kəti. ");
INSERT INTO tnp_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kəni mələs pesɨn kəti, mətu=pən nəhu lan, kəni əmeiko mətuəuin mətəueiu nəhlkɨ rəhan mɨn nətəmimi, kəni mətafəl e tauɨl, tauɨl u iətəm in tətətəuti lan. ");
INSERT INTO tnp_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Təmol lanəha muvən e Saimon Pitə, kəni Pitə təni=pən kəm in məmə, “?Iərmənɨg, təhro? Təsəuvɨriən məmə ik onəkəueiu nəhlkək.” ");
INSERT INTO tnp_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Mətəu Iesu təni=pən kəm in məmə, “Rəueiu ik nəkəruru nɨpətɨ nati u iəu iatol, mətəu uərisɨg nəpanəhrun nɨpətɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Kəni Pitə təni=pən in məmə, “Onəkəpəh agɨn nafəliən nəhlkək.” Mətəu Iesu təni məmə, “Nəmə iəsəueiuiən nəhlkəm, kəni ko ik nəsuvaiən mol rəhak iətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Kəni Saimon Pitə təməni=pən kəm in məmə, “Iərmənɨg, nəmə tol lanəha, kəni onəsəueiu əməiən nəhlkək, mətəu əueiu mɨn nəhlmək mɨne rəhk-kapə!” ");
INSERT INTO tnp_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Kəni Iesu təni=pən kəm in məmə, “!Kəpə! Iətəmimi u tɨnaig rəkɨs, in tɨnəruən rəkɨs, tɨnəhmen. Təuvɨr əmə məmə okəsəueiu mɨniən nɨpətɨn; mətəu iəu oiəkəkeikei məueiu mɨn əmə nəhlkɨn. Itəmah nɨnotəruən rəkɨs. Mətəu səniəmə itəmah rəfin agɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Iesu tɨnəhrun rəkɨs məmə ilah pəh u otegəhan=pən lan e nəhlmɨ rəhan mɨn tɨkɨmɨr mɨn. Tol lanəha, kəni in təni məmə, “Səniəmə itəmah rəfin agɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nian Iesu tɨnəueiu rəkɨs nəhlkɨ rəhan mɨn nətəmimi, kəni muvən mɨn e rəhan napən, kəni muvən məharəg e nɨmein e tepɨl. Kəni əmeiko mətapuəh o lah məmə, “?Itəmah nəkotəhrun nɨpətɨ nati u iəmol rəueiu agɨn e təmah? ");
INSERT INTO tnp_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Itəmah nəutauɨn lak məmə Nəgətun mɨne Iərmənɨg, kəni təhruahru əmə lanko, mətəu-inu nɨpəhriəniən məmə iəu u, rəhatəmah Nəgətun mɨne rəhatəmah Iərmənɨg. ");
INSERT INTO tnp_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","“Mətəu-inu iəu, iəu u rəhatəmah Iərmənɨg mɨne iəu Iəgətun rəhatəmah, konu iəu iəkəueiu nəhlkɨtəmah, konu itəmah mɨn, onəkotəueiu nəhlkɨtəmah mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Iəu iəmol məgətun itəmah lan, məmə itəmah onəkotol kəm təmah mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nɨpəhriəniən agɨn u iətəni=pɨnə kəm təmah məmə, ioluək kəti, in təsapirəkɨsiən rəhan iətəmi asoli, konu iahli=pən in təsapirəkɨsiən iətəm tətahli. ");
INSERT INTO tnp_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Rəueiu əha, itəmah nəkotəhrun vivi natimnati mɨn u. Kəni o nati u, nəmə onautol lanu, kəni itəmah onəkotos nəuvɨriən o Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Iəu iəsəniən itəmah rəfin. Iəkəhrun vivi itəmah mɨn u nətəm iəu iəmɨtəpɨn itəmah. Mətəu nəghatiən u rəha Nauəuə Rəha Uhgɨn, otəkeikei muva mol nɨpəhriəniən lan. Nəghatiən u tətəni məmə, ‘Iətəmimi u, aupən itɨmlau iəmatuauən pəti e pɨlet kətiəh, mətəu rəueiu, in tɨnəuhlin rəhan nətəlɨgiən, mɨnətələhu nəghatiən tərah ohniəu.’ ");
INSERT INTO tnp_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Iəu iətəni pətɨgəm natimnati mɨn u kəm təmah u rəueiu, nian okəsol əhanəhiən. Mətəu nian okatol, kəni itəmah onəkotəhatətə lak, məmə Iəu U Inu. ");
INSERT INTO tnp_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nɨpəhriəniən agɨn u iətəni=pɨnə kəm təmah məmə, iətəmimi pəh iətəm tatos iətəmi u iətahli=pɨnə, kəni nɨkin tagiən ohni, təhmen=pən əmə məmə in tatos mɨn iəu, kəni nɨkin tagiən ohniəu. Konu iətəmimi iətəm tatos vivi iəu, kəni nɨkin tagiən ohniəu, təhmen=pən əmə məmə in tatos vivi mɨn rəhak Tatə, kəni nɨkin tagiən ohni.” ");
INSERT INTO tnp_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nian Iesu tɨnəni pətɨgəm rəkɨs nəghatiən əha, kəni nɨkin təməfɨgəm pɨk, kəni in təni məmə, “Nɨpəhriəniən agɨn u iətəni=pɨnə kəm təmah məmə, itəmah kəti u ikɨnu otegəhan=pən lak e nəhlmɨ tɨkɨmɨr mɨn rəhak.” ");
INSERT INTO tnp_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kəni rəhan mɨn nətəmimi kəmotəsal=pən moteruh ilah mɨn, mɨnotəruru agɨn məmə in tətəni pəh. ");
INSERT INTO tnp_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Kəni ilah kəti u iətəm Iesu in tolkeikei pɨk, in tətəməhli iuəkɨr əmə o Iesu. ");
INSERT INTO tnp_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Kəni Saimon Pitə, in təmasiuən=pən kəm in məmə, “Ətapuəh-to ohni, məmə iətəmimi pəh kəha in tətəni.” ");
INSERT INTO tnp_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kəni suah kəha təmiəu-iəu muva iuəkɨr o Iesu, kəni mətapuəh ohni məmə, “?Iərmənɨg, pəh u nətəni?” ");
INSERT INTO tnp_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Kəni Iesu təni məmə, “Iəu iəkəmkərɨs pɨret nəuvetɨn, konu məuveri=pən e sup, kəni məfən kəm in, konu suah u, inko.” Kəni əmeiko, in təməmkərɨs pɨret kəti, məuveri=pən e sup, kəni məfən kəm Jutəs, nətɨ Saimon Iskariot. ");
INSERT INTO tnp_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kəni Jutəs təmos pɨret u. Kəni rəueiu agɨn, Setən tɨnəuveg rəhan nətəlɨgiən. Kəni Iesu təni=pən kəm in məmə, “Nati u nəkəmə natol, uvən uəhai əmə mol.” ");
INSERT INTO tnp_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nətəmimi mɨn u rəha Iesu nətəm kautəməhli tɨtəlau e tepɨl məutauən, ilah kəsotəhruniən məmə Iesu təməni=pən nəghatiən u kəm in o nak. ");
INSERT INTO tnp_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Jutəs in tətaharu kətɨm rəha məni rəhalah, kəni ilah nəuvein nɨkilah təhti məmə Iesu təməni=pən kəm in məmə otuvən mos nəhmtɨn nauəniən nəuvein nɨglah o lafet, uə nəmə təhro tatuvən otəfən məni kəti kəm nanrah mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Kəni nian Jutəs təmos rəkɨs pɨret u, təməhtul miet uəhai əmə. Kəni tɨnapinəpu rəkɨs. ");
INSERT INTO tnp_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nian Jutəs tɨniet rəkɨs, kəni Iesu təni məmə, “Rəueiu əha, Uhgɨn tɨnatəfəri nərgɨ Nətɨ Iətəmimi, kəni Nətɨ Iətəmimi tɨnatəfəri nərgɨ Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Mətəu nian Nətɨ Iətəmimi tɨnol əpu rəkɨs nepətiən rəha Uhgɨn, kəni Uhgɨn aru əmə in otol əpu mɨn nepətiən rəha Nətɨ Iətəmimi. Kəni in otol əmə uəha rəueiu əmə. ");
INSERT INTO tnp_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Nenətɨk mɨn, ko iəsatɨgiən tuvəh kitah min itəmah. Kəni itəmah onəmanotəsal lak, mətəu iəu iətəni mɨn nəghatiən kətiəh əmə kəm təmah u rəueiu, iətəm iəməni=pən kəm nətəmi asoli mɨn rəha Isrel aupən. Iətəni=pɨnə kəm təmah məmə, ikɨn əha iatuvən ikɨn, itəmah nəkotəruru nuvəniən ikɨn. ");
INSERT INTO tnp_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Iəu iətəni=pɨnə nəghatiən vi kəti kəm təmah məmə nəkotəkeikei mautol. Itəmah nəkotəkeikei motolkeikei itəmah mɨn. Iəu iəmolkeikei itəmah, kəni itəmah nəkotəkeikei motolkeikei itəmah mɨn təhmen əmə lanəha. ");
INSERT INTO tnp_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kəni nəmə nəkolkeikei lanu itəmah mɨn, kəni nətəmimi rəfin okotəhrun məmə itəmah rəhak mɨn nətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Kəni Saimon Pitə tətapuəh ohni məmə, “?Iərmənɨg, ik onəkuvən iə?” Kəni Iesu təni=pən kəm in məmə, “Ikɨn əha iəu iatuvən ikɨn, ik nəkəruru nɨtəu=paiən iəu rəueiu, mətəu uərisɨg ko, onəpanuva.” ");
INSERT INTO tnp_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Kəni Pitə tətapuəh ohni məmə, “?Iərmənɨg, oiəsɨtəu-pəniən ik u rəueiu o nak? Iəu, nɨkik tagiən əmə məmə iəkɨmɨs ohnik.” ");
INSERT INTO tnp_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Kəni Iesu təni=pən kəm in məmə, “?Ik nəkəmə nɨkim tagiən əmə məmə onəkɨmɨs ohniəu? Nɨpəhriəniən agɨn u iətəni kəm ik məmə, mənɨg otəsəkakə əhanəhiən, kəni ik onəkəni mau kɨsɨl məmə nəkəruru iəu.” ");
INSERT INTO tnp_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Kəni Iesu təməni=pən kəm lah məmə, “Nɨkitəmah təsahməiən. Itəmah nəkotəkeikei motəhatətə e Uhgɨn, kəni motəhatətə mɨn lak. ");
INSERT INTO tnp_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","E nimə rəha Tatə rəhak, nəuan tepət əha ikɨn. Nəghatiən u in nɨpəhriəniən. Nəmə təsoliən lanəha, ko inəni=pɨnə rəkɨs kəm təmah. Rəueiu əha, iəu iatuvən, iəkol əpenə-penə rəhatəmah. ");
INSERT INTO tnp_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kəni mətəu-inu iəkuvən mol əpenə-penə o təmah, kəni iəu oiəpanɨtəlɨg=pa mɨn mos itəmah nəkəhuva motatɨg kitah min iəu, məmə itəmah onəkotatɨg ikɨnu iətəm iəu mɨn iətatɨg ikɨn. ");
INSERT INTO tnp_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ikɨn əha iatuvən ikɨn, itəmah nɨnotəhrun rəkɨs suaru rəhan.” ");
INSERT INTO tnp_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Mətəu Toməs təni=pən kəm in məmə, “Iərmənɨg, itɨmah iəkotəruru ikɨn ko natuvən ikɨn. ?Iəkotəhro lanu lan motəhrun suaru tatuvən ikɨn əha?” ");
INSERT INTO tnp_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Kəni Iesu təni=pən kəm in məmə, “Iəu u, Suaru ohni. Kəni iəu u, Nəukətɨ Nɨpəhriəniən, kəni iəu u, Nəukətɨ Nəmiəgəhiən. Iətəmimi kəti ko təsuvəniən o rəhak Tatə nəmə iəu iəsosiən in muvən. ");
INSERT INTO tnp_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nəmə nəmotəhrun iəu, kəni nəmotəhrun mɨn rəhak Tatə. Kəni tol lanəha, tətuəuin rəueiu, nɨnotəhrun rəkɨs in, kəni mɨnoteruh.” ");
INSERT INTO tnp_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Kəni Fɨlɨp təni=pən kəm in məmə, “Iərmənɨg, əui, əgətun-to Tatə Uhgɨn e tɨmah. Nati əmə u inu, itɨmah iəkotolkeikei.” ");
INSERT INTO tnp_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Kəni Iesu təni=pən kəm in məmə, “Fɨlɨp, iəu iəmatɨg təfəməh kitah min itəmah. Mətəu ik nəkəruru əhanəh iəu. Iətəmimi iətəm tateruh iəu, in tateruh Tatə Uhgɨn. Təhro ik nətəni məmə, ‘Əui, əgətun Tatə Uhgɨn kəm tɨmah?’ ");
INSERT INTO tnp_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","?Ik nəsəhatətəiən məmə iətatɨg e Tatə Uhgɨn, konu Tatə Uhgɨn tətatɨg lak? Nəghatiən mɨn u iəkatəni kəm təmah, səniəmə rəhak əmə. Tatə Uhgɨn u, nian rəfin, tətatɨg lak, inu in tatol rəhan mɨn u uək. ");
INSERT INTO tnp_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Itəmah onəkotəkeikei motəhatətə lak nian iəu iətəni məmə iətatɨg e Tatə Uhgɨn, konu Tatə Uhgɨn tətatɨg lak. Mətəu nəmə kəpə, təuvɨr məmə nəkotəhatətə lak o nəfɨgəmiən rəha uək asoli mɨn iətəm iəmatol. ");
INSERT INTO tnp_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nɨpəhriəniən agɨn u iətəni kəm təmah məmə, iətəmimi iətəm tətəhatətə lak, in otol noliən uək mɨn u iətəm iəu iəmatol. Əuəh, in otol noliən uək təri təhmɨn mɨn tapirəkɨs uək mɨn u iətəm iəu iəmol, mətəu-inko iəu oiəkatuvən o Tatə Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Iəu Nətɨn, kəni nəmə nəkoteasiə e nati kəti e nərgək, nati əpnapɨn nəmə nəkoteasiə e nati nak, iəu iəpanol, məmə uək u rəha Nətɨn otəfəri nərgɨ Tatə Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kəni nəmə onəkoteasiə e nati kəti ohniəu, e nərgək, kəni iəu iəkol.” ");
INSERT INTO tnp_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Kəni Iesu təməghati əhanəh matuvən, mətəni məmə, “Nəmə itəmah nəkotolkeikei iəu, konu itəmah onəkotol nəghatiən rəhak. ");
INSERT INTO tnp_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Kəni iəu, oiəkeasiə e Tatə Uhgɨn məmə in otahli=pa Iasiru kəti mɨn o təmah. Kəni in otətatɨg itulɨn itəmah min. ");
INSERT INTO tnp_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Suah u inu, in Narmɨn rəha Nɨpəhriəniən. Nətəmimi rəha nəhue nɨftəni u, ko kəsotosiən in e nɨkilah, mətəu-inu ilah kəsoteruhiən in, motəruru in. Mətəu itəmah, nəkotəhrun in, mətəu-inko in tətatɨg itəmah min. Kəni in otəpanatɨg e nɨkitəmah. ");
INSERT INTO tnp_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Nian iəu iəkiet e təmah, ko iəsəpəhiən itəmah nəkotatɨg pɨsɨn əmə, təhmen e iətəm kəmɨmɨs-ərin. Iəu iəpanɨtəlɨg=pa mɨn o təmah. ");
INSERT INTO tnp_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Otəsuvəhiən, nətəmimi rəha nəhue nɨftəni u ilah okəsoteruhiən iəu. Mətəu itəmah onəpanoteruh iəu. Kəni mətəu-inu iəu iəpanəmiəgəh, itəmah mɨn onəpanotəmiəgəh. ");
INSERT INTO tnp_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","E nian rəha natimnati mɨn u, kəni itəmah onəkotəhrun məmə iətatɨg e rəhak Tatə. Kəni itəmah nəkotatɨg lak, konu iəu iətatɨg e təmah. ");
INSERT INTO tnp_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Iətəmimi iətəm təmos vivi nəghatiən rəhak, kəni matol, iətəmimi u inu in tolkeikei iəu. Kəni iətəmimi iətəm tolkeikei iəu, rəhak Tatə in otolkeikei mɨn in. Kəni iəu mɨn oiəkolkeikei in. Kəni iəu oiəkol əpu iəu kəm in, məmə in otəhrun vivi iəu.” ");
INSERT INTO tnp_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Kəni Jutəs u, (səniəmə Jutəs Iskariot, mətəu iahunin kəti u in iətəmi kəti mɨn rəha Iesu), in təmətapuəh ohni məmə, “?Iərmənɨg, ik onəkəhro lanu kəni mol əpu ik kəm tɨmah əmə, mətəu onəsol əpuiən ik kəm nətəmimi rəha nəhue nɨftəni?” ");
INSERT INTO tnp_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Mətəu Iesu təməni=pən kəm in məmə, “Iətəmimi iətəm tolkeikei iəu, in otatol nəuiak, kəni rəhak Tatə in otolkeikei in. Konu iəu mɨne rəhak Tatə, itɨmlau oiəkiəuva mətuatɨg itɨmahal min. Kəni itɨmlau iəkuol imatɨmlau əha ikɨn. ");
INSERT INTO tnp_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Iətəmimi iətəm təsolkeikeiən iəu, in təsoliən nəuiak. Nəghatiən mɨn u iətəm nəmotətəu iəmatəni, iəməsəni aruiən ilah. Mətəu iəmos ilah o rəhak Tatə iətəm in təmahli=pa iəu iəkuva. ");
INSERT INTO tnp_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Iəu iatəni pətɨgəm nəghatiən mɨn u kəm təmah nian iətatɨg əhanəh kitah min itəmah. ");
INSERT INTO tnp_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Mətəu Narmɨn Rəha Uhgɨn u, in Iasiru, iətəm Tatə Uhgɨn otahli=pa e nərgək, in otəgətun itəmah e natimnati mɨn rəfin. Kəni in otol itəmah məmə nɨkitəmah otətəhti natimnati mɨn u iətəm iatəni kəm təmah, məsotaluiən lan. ");
INSERT INTO tnp_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Rəueiu əha tɨnuəkɨr məmə iəu oiəkəpəh itəmah. Iəu iətələhu nəməlinuiən rəhak tətatɨg o təmah. Konu nəməlinuiən u, iətəm iəkəfɨnə, təsəhmeniən e nəməlinuiən iətəm nəhue nɨftəni u tətəfɨnə. Itəmah, nɨkitəmah təsahməiən kəni məsotəgɨniən. ");
INSERT INTO tnp_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Itəmah nɨnotətəu rəkɨs rəhak nəghatiən, iəməni=pɨnə kəm təmah məmə, ‘Iəu oiəpanəpəh itəmah, mətəu uərisɨg, oiəpanɨtəlɨg=pa mɨn o təmah.’ Nəmə nəkotolkeikei pəhriən iəu, kəni nɨkitəmah otagiən əmə məmə nəkoteruh iəu iatuvən o rəhak Tatə, mətəu-inu in ilɨs tapirəkɨs iəu. ");
INSERT INTO tnp_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Iəu iətəni pətɨgəm rəkɨs əmə natimnati mɨn u kəm təmah u rəueiu, nian ilah kəsotol əhanəhiən, məmə nian ilah kɨnəhuva mautol nɨpəhriəniən lan, kəni itəmah onəkotəhatətə lak. ");
INSERT INTO tnp_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Rəueiu əha, ko iəsəghatiən təfəməh mɨn kəm təmah, mətəu-inu Setən u iərmənɨg rəha nəhue nɨftəni u, in tɨnuva. In təsosiən nəsanəniən məmə otol win lak. ");
INSERT INTO tnp_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Mətəu iəu iatol əhruahru əmə nəuia Tatə Uhgɨn məmə nətəmimi rəha nəhue nɨftəni okotəhrun məmə iəu iəkolkeikei in. “Intələh, pəh kotəhtul motagɨm u ikɨnu, mautəhuvən.” ");
INSERT INTO tnp_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Kəni Iesu təni məmə, “Iəu u, iəu iəkəhmen e nəukətɨ nɨgi pəhriən. Kəni rəhak Tatə in təhmen e iətəmimi iətəm tətətahlɨn nɨgi u. ");
INSERT INTO tnp_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nəhlmɨ nɨgi mɨn rəfin iətəm kəsotəuəiən, in tətətei rəkɨs ilah, kəni nəhlmɨ nɨgi rəfin u iətəm kautəuə, in tətafəl vivi ilah, məmə ilah okotəuə e nəualah tepət. ");
INSERT INTO tnp_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Itəmah nəkotəhmen e nəhlmɨ nɨgi u. Kəni iəu inafəl vivi rəkɨs itəmah e nəghatiən mɨn iətəm iəməni=pɨnə kəm təmah. ");
INSERT INTO tnp_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Otəhtul=pa lak, kəni iəu oiəkəhtul=pɨnə e təmah. Nəhlmɨ nɨgi otəsəuəiən nəmə in təsəhtul-pəniən e nəukətɨn. Təhmen əmə, itəmah ko nəmiəgəhiən rəhatəmah təsəuəiən e nəuan nəmə nəsotəhtul=paiən lak. ");
INSERT INTO tnp_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Iəu u, iəu nəukətɨ nɨgi. Kəni itəmah nəhlmɨ nɨgi mɨn, nəhlmɨ nɨgi mɨn iətəm tatɨlpɨn=pa vivi lak, mautəhtul=pa. Nəmiəgəhiən rəha iətəmimi iətəm tətəhtul=pa lak kəni iətəhtul=pən lan, in otəuə e nəuan tepət. Mətəu itəmah u, nəmə nəsotəhtul=paiən lak, ko nəsotoliən nati kəti. ");
INSERT INTO tnp_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nəmə iətəmimi təsəhtul=paiən lak, in təhmen e nəhlmɨ nɨgi kəti, iətəm kɨnəraki lan kəni tɨnɨmətu rəkɨs. Nəhlmɨ nɨgi mɨn tol lanəha, kəhrun nəmki-pəniən e nɨgəm, kuvan əhtuv. ");
INSERT INTO tnp_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nəmə itəmah nəkotəhtul=pa lak, kəni nəghatiən rəhak nəmotətəu rəkɨs tətatɨg e nɨkitəmah, nati nak itəmah nəkotolkeikei, nəkotəhrun neasiəiən lan. Kəni Uhgɨn otol kəm təmah. ");
INSERT INTO tnp_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nian nəmiəgəhiən rəhatəmah otəuə e nəuan tepət, nati əha in tətəfəri nərgɨ rəhak Tatə, kəni e noliən u, tətəgətun məmə itəmah rəhak mɨn nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Tatə Uhgɨn in tolkeikei pɨk iəu. Təhmen əmə, iəu iəkolkeikei itəmah lanəha. Otəhtul e rəhak nolkeikeiən. ");
INSERT INTO tnp_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nəmə itəmah nautol rəhak nəghatiən, kəni onəkotəhtul=pa e rəhak nolkeikeiən, təhmen əhruahru əmə məmə inu iəu iəmol nəghatiən mɨn rəha Tatə Uhgɨn, kəni iətəhtul=pən e rəhan nolkeikeiən. ");
INSERT INTO tnp_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Iəu iəmətəni pətɨgəm nəghatiən mɨn u kəm təmah, məmə nɨkitəmah otətagiən, təhmen əmə məmə iəu nɨkik tətagiən. Konu nɨkitəmah otagiən magiən məriauəh. ");
INSERT INTO tnp_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Itəmah nəkotəkeikei mautol nəghatiən u rəhak. Tətəni məmə itəmah onəkotolkeikei itəmah mɨn, təhmen əmə məmə iəu iəkolkeikei itəmah lanəha. ");
INSERT INTO tnp_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Iətəmi kəti tɨkə iətəm tolkeikei pɨk in kəti tapirəkɨs iətəmimi u iətəm tətegəhan e rəhan nəmiəgəhiən məmə otosmiəgəh in mɨn nəuvein. ");
INSERT INTO tnp_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kəni nəmə itəmah nəkotol natimnati mɨn u iətəni kəm təmah, tətəgətun məmə itəmah ko, iəu mɨn nəuvein. ");
INSERT INTO tnp_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","“Iəu oiəsauɨn mɨniən e təmah məmə noluək mɨn rəhak, mətəu-inu iətəm tatol uək, in təruru natimnati mɨn iətəm rəhan iətəmi asoli tatol. Mətəu rəueiu əha, iəu iəkauɨn e təmah, məmə iəu mɨn nəuvein, mətəu-inu natimnati mɨn rəfin u iətəm iəmətəu o rəhak Tatə, inəni pətɨgəm rəkɨs kəm təmah. ");
INSERT INTO tnp_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Itəmah nəməsotɨtəpɨniən iəu, mətəu iəu iəmɨtəpɨn itəmah. Kəni iəu iəmələhu=pən itəmah məmə itəmah onəkəhuvən motol uək, kəni uək rəhatəmah otəuə e nəuan. Kəni nəuan u, in otətatɨg. Tol lanəha, kəni nəmə nəkoteasiə e natimnati mɨn kəm Tatə Uhgɨn e nərgək, kəni in otəfɨnə kəm təmah. ");
INSERT INTO tnp_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Iətəfɨnə nəghatiən kəti kəm təmah in tol lanu. Itəmah onəkotəkeikei motolkeikei itəmah mɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Kəni Iesu təni=pən məmə, “Okəmə nətəmimi rəha nəhue nɨftəni u kautəməki e təmah, nɨkitəmah otəkeikei məhti məmə aupən, ilah kəmotəməki lak lanəha. ");
INSERT INTO tnp_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Okəmə itəmah nətəmimi rəha nəhue nɨftəni u, kəni nətəmimi rəha nəhue nɨftəni okotolkeikei itəmah, mətəu-inu rəhalah u itəmah. Mətəu səniəmə itəmah nətəmimi rəha nəhue nɨftəni u. Iəu iəmɨtəpɨn rəkɨs itəmah, kəni mos rəkɨs itəmah o nəhue nɨftəni. Kəni o nati u inu, nətəmimi rəha nəhue nɨftəni, kautəməki e təmah. ");
INSERT INTO tnp_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nɨkitəmah otəkeikei mətəhti nəghatiən u iəməni=pɨnə rəkɨs kəm təmah məmə, ‘Ioluək əmə kəti, təsapirəkɨsiən rəhan iətəmi asoli.’ Kəni mətəu-inu nətəmi rəha nəhue nɨftəni u, ilah kautol tərah agɨn ohniəu, kəni tol lanəha, ilah okotol noliən kətiəh əmə e təmah. Nəmə ilah kəmotol rəhak nəghatiən, kəni ilah okotol rəhatəmah nəghatiən. Mətəu ilah kəməsotol agɨniən rəhak nəghatiən mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ilah okotol natimnati mɨn lanəha, mətəu-inu itəmah rəhak mɨn nətəmimi. Ilah okotol lanəha, mətəu-inu ilah kotəruru Uhgɨn iətəm təmahli=pa iəu. ");
INSERT INTO tnp_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Iəmuva kəni məghati kəm lah. Tol lanəha nəua nəghatiən u, ilah kəmoteruh əsas rəhalah noliən tərah mɨn. Mətəu kəmotəuhlin matəlgɨlah ohniəu motəpəh rəhak nəghatiən. Kəni rəueiu, ko kəsotəniən məmə rəhalah noliən tərah tɨkə. ");
INSERT INTO tnp_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Iətəmimi iətəm tətəməki lak, in tətəməki mɨn e rəhak Tatə. ");
INSERT INTO tnp_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Iəmuva mol uək mɨn u e nəhmtɨlah iətəm ko iətəpɨsɨn kəti təməsoliən. Tol lanəha, ilah kəmotəhrun məmə pəh u iəu. Kəni nati əpnapɨn kəmotəhrun iəu, mətəu kəutəməki lak, kəni tol lanəha məmə kəutəməki mɨn e rəhak Tatə. Kəni rəueiu, ko kəsotəniən məmə rəhalah noliən tərah tɨkə. ");
INSERT INTO tnp_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Mətəu natimnati mɨn əha otəkeikei mol lanəha, kəni mol məmə nəghatiən u otuva pəhriən iətəm nətəmimi aupən kəmotətei rəkɨs e nauəuə rəha Lou. Rəhalah u Lou iətəm kotolkeikei pɨk tətəghati e lah mətəni məmə, ‘Iəu iəsoliən nati kəti e lah, mətəu ilah kotəməki agɨn lak, mautol tɨməti kəm iəu.’ ");
INSERT INTO tnp_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Mətəu nian Iasiru otuva, in otəni pətɨgəm iəu. Narmɨn rəha Nɨpəhriəniən u, tatsɨpən e Tatə Uhgɨn. Iəu iəkahli=pa in tuva o təmah. ");
INSERT INTO tnp_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Konu itəmah mɨn, onəkotəkeikei motəhtul pətɨgəm motəni iəu, mətəu-inu itəmah nautatɨg kitah min iəu e nətuəuiniən e uək rəhak muva mətəuarus=pa u rəueiu. ");
INSERT INTO tnp_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Iəu inətəni pətɨgəm natimnati mɨn u kəm təmah məmə nəsotəhlmaniən e rəhatəmah nəhatətəiən. ");
INSERT INTO tnp_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ilah okəpanotəhgi pətɨgəm itəmah e nimə mɨn rəha nuhapumɨniən rəhalah; kəni nɨpəhriəniən agɨn, nian əha ikɨn tətuva iətəm nətəmimi okotohamu itəmah, kəni nɨkilah təhti məmə ilah kautol uək təuvɨr kəti rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ilah okotol natimnati mɨn u, mətəu-inu ilah kotəruru pəhriən Tatə Uhgɨn, kəni motəruru pəhriən mɨn iəu. ");
INSERT INTO tnp_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mətəu iəu iəkaupən məni pətɨgəm natimnati mɨn u kəm təmah. Kəni nian ilah kɨnotətuəuin mɨnautol e təmah, kəni nɨkitəmah otəhti məmə iəu iəməni rəkɨs natimnati mɨn u kəm təmah.” Kəni Iesu təghati əhanəh matuvən, mətəni məmə, “Iəu iəməsəni pətɨgəmiən natimnati mɨn u kəm təmah aupən, mətəu-inu iəmətatɨg kitah min itəmah. ");
INSERT INTO tnp_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Mətəu rəueiu iəkɨtəlɨg=pən mɨn o rəhak Tatə iətəm təmahli=pa iəu, mətəu itəmah kəti təsətapuəhiən ohniəu məmə, ‘?Ik onəkuvən iə?’ ");
INSERT INTO tnp_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mətəu rəueiu, tol lanu lan məmə iəməni natimnati mɨn u kəm təmah, kəni nɨkitəmah təmahmə. ");
INSERT INTO tnp_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mətəu iəu iətəni pəhriən kəm təmah məmə, otəuvɨr pɨk o təmah məmə iəu iəkagɨm rəkɨs e təmah. Mətəu-inu nəmə iəsagɨm rəkɨsiən e təmah, kəni ko Iasiru təsuvaiən matɨg itəmah min. Mətəu nəmə iəu iəkagɨm muvən, kəni iəu iəkahli=pa in tuva matɨg o təmah. ");
INSERT INTO tnp_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Kəni nian in otuva, kəni otəgətun nətəmimi rəha nəhue nɨftəni məmə ilah nol təfagə tərah, kəni nətəlɨgiən rəhalah təsəhmeniən o noliən iətəm təhruahru e nəhmtɨ Uhgɨn, kəni nətəlɨgiən rəhalah təsəhmeniən o nakiliən noliən rəha nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Narmɨn u otəgətun ilah məmə ilah nol təfagə tərah, mətəu-inu kəsotəhatətəiən lak. ");
INSERT INTO tnp_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Narmɨn u otəgətun ilah məmə nətəlɨgiən rəhalah in təsəhmeniən o rəhalah nəhruahruiən e nəhmtɨ Uhgɨn, mətəu-inu iəu iəkɨtəlɨg=pən mɨn o rəhak Tatə, kəni itəmah onəsoteruhiən iəu. ");
INSERT INTO tnp_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Narmɨn u otəgətun ilah məmə nətəlɨgiən rəhalah in təsəhmeniən o nakiliən noliən rəha nətəmimi, mətəu-inu Uhgɨn in tɨnakil rəkɨs iərmənɨg rəha nəhue nɨftəni u, Setən. ");
INSERT INTO tnp_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Iəu iatos əhanəh natimnati tepət mɨn məmə iəpanəni kəm təmah. Mətəu rəueiu əha, ko nəsotos rəfiniən ilah. Tiəkɨs pɨk o təmah. ");
INSERT INTO tnp_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Mətəu nian Narmɨn rəha Nɨpəhriəniən otuva, in otit itəmah, mol məmə itəmah nəkotəhrun nɨpəhriəniən mɨn rəfin. In ko təsəni aruiən rəhan əmə nəghatiən. In otəni pətɨgəm əmə natimnati mɨn u in tətətəu o Tatə Uhgɨn. Kəni in otəni=pɨnə mɨn kəm təmah natimnati mɨn u nian kəti okəpanəhuva. ");
INSERT INTO tnp_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","In otətəu nəghatiən pəhriən ohniəu kəni mətəni pətɨgəm kəm təmah. E noliən u, in otəfəri iəu. ");
INSERT INTO tnp_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Natimnati mɨn rəfin rəha Tatə Uhgɨn, in rəhak. Tol lanəha, kəni iəu iətəni məmə, Narmɨn u, in otətəu nəghatiən pəhriən ohniəu kəni matol əpu nɨpətɨn kəm təmah.” ");
INSERT INTO tnp_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Kəni Iesu təni=pən məmə, “Otəsuvəhiən onəsoteruhiən iəu, mətəu uərisɨg ko, təsuvəhiən, kəni onəmanoteruh mɨn iəu.” ");
INSERT INTO tnp_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Kəni nətəmimi mɨn nəuvein rəhan, ilah kəutətapuəh-ətapuəh kəm lah mɨn məmə, “?Nəghatiən u, nɨpətɨn nak? In tətəni kəm tah məmə, ‘Otəsuvəhiən onəsoteruhiən iəu, mətəu uərisɨg, otəsuvəhiən, nəmanoteruh mɨn iəu.’ Kəni in təni məmə, ‘Mətəu-inu iəu iatuvən o Tatə Uhgɨn.’ ");
INSERT INTO tnp_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Nəghatiən u, ‘otəsuvəhiən’ nɨpətɨn nak? Kitah kotəruru nəghatiən mɨn əha in tətəni.” ");
INSERT INTO tnp_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Kəni Iesu tɨnəhrun rəkɨs məmə ilah kotolkeikei məmə okotətapuəh o nati kəti ohni, kəni təni=pən kəm lah məmə, “?Təhro? Iəu iəməni məmə, ‘Otəsuvəhiən itəmah nəsoteruhiən iəu. Mətəu uərisɨg, təsuvəhiən onəmanoteruh mɨn iəu.’ ?Kəni rəueiu nəutətapuəh o təmah mɨn o nɨpətɨ nəghatiən u? ");
INSERT INTO tnp_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nɨpəhriəniən agɨn u iətəni məmə, itəmah nɨkitəmah otahmə, itəmah onəkotasək pɨk, mətəu nətəmimi rəha nəhue nɨftəni, nɨkilah otagiən. Itəmah onəkotətəu tərah pɨk agɨn, mətəu nahməiən rəhatəmah otəuhlin=pa e nagiəniən. ");
INSERT INTO tnp_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nian nəmə tɨnuəkɨr məmə pətan kəti otemək, kəni in otətəu tərah, mətəu-inu tɨnol nian rəhan məmə otətəu nahməiən əha. Mətəu uərisɨg, nəmə nətɨn tɨnair rəkɨs, kəni in nɨkin təsəhti mɨniən nahməiən əha. In nɨkin tətagiən pɨk mətəu-inu nətɨn tɨnair=pa e nəhue nɨftəni. ");
INSERT INTO tnp_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kəni təhmen əmə, rəueiu əha itəmah nautətəu tərah. Mətəu uərisɨg, konu iəu iəkeruh mɨn itəmah. Konu nɨkitəmah otagiən pɨk, ko iətəmimi kəti təsol mɨniən itəmah nɨkitəmah tahmə mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","O nian əha, itəmah onəsotətapuəh mɨniən o nati kəti ohniəu. Nɨpəhriəniən agɨn u iətəni kəm təmah məmə, nəmə itəmah nəkotətapuəh e nati kəti o Tatə Uhgɨn e nərgək, kəni in otəfɨnə kəm təmah. ");
INSERT INTO tnp_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mətəuarus=pa u rəueiu, itəmah nəsotətapuəh əhanəhiən e nati kəti e nərgək. Otətapuəh lan e nərgək, kəni onəkotos, məmə nɨkitəmah otagiən məri məriauəh.” ");
INSERT INTO tnp_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Kəni Iesu tətəghati əhanəh matuvən mətəni məmə, “Iəu iətəni=pɨnə natimnati mɨn u e nəghatiən əuhlin, mətəni kəm təmah. Mətəu nian əha ikɨn tətuva, iətəm iəu iəsəni mɨniən nəghatiən əuhlin lan, mətəu oiəkanus=pɨnə rəhak Tatə kəm təmah e noliən kəti məmə itəmah onəkotəhrun vivi in lan. ");
INSERT INTO tnp_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","E nian əha, itəmah onəkoteasiə e natimnati kəm rəhak Tatə e nərgək, mətəu iəu iəsəniən məmə iəu iəkuvən e nərgɨtəmah measiə e natimnati ohni ");
INSERT INTO tnp_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","mətəu-inu Tatə Uhgɨn, in əmə tolkeikei pɨk itəmah. In tolkeikei itəmah mətəu-inu itəmah nəkotolkeikei iəu, kəni itəmah nəmotəhatətə məmə iəu iəmsɨpən lan. ");
INSERT INTO tnp_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Iəu iəmsɨpən e Tatə Uhgɨn, muva e nəhue nɨftəni u. Konu rəueiu otəsuvəhiən kəni iəkəpəh mɨn nəhue nɨftəni u, mɨtəlɨg=pən mɨn o Tatə Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Kəni nətəmimi mɨn rəhan kəutəni məmə, “In konu! !Rəueiu əha ik nəsəghati əuhlin mɨniən! Ik nətəni əhruahru əmə kəm tɨmah. ");
INSERT INTO tnp_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Rəueiu əha inotəhrun məmə ik nəkəhrun natimnati rəfin agɨn, kəni nati əpnapɨn nəmə iətəmi kəti təsətapuəh əhanəhiən nati kəti ohnik, mətəu ik nəkəhrun nuhalpɨniən nəghatiən mɨn rəfin iətəm kəsətapuəh əhanəhiən lan. Kəni nati u, tol kəni itɨmah iəkotəhrun məmə ik nəmsɨpən e Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Kəni Iesu təni=pən kəm lah məmə, “?Nɨpəhriəniən, itəmah nɨnotəni nɨpəhriəniən lak u rəueiu? ");
INSERT INTO tnp_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Itəmah otətəlɨg-to lan, nian əha ikɨn tətuva, nɨpəhriəniən məmə nian əha tɨniet pətɨgəm=pa rəkɨs, iətəm nətəmimi okotəgəu rəkɨs itəmah, nəkotaiu atiti, məhuvən imatəmah mɨn ikɨn, motəpəh iəu, iəu pɨsɨn əmə. Mətəu ko iəu iəsan pɨsɨn əməiən, mətəu-inu nian rəfin rəhak Tatə tətatɨg itɨmlau min. ");
INSERT INTO tnp_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Iəu iəməni pətɨgəm rəkɨs natimnati mɨn u kəm təmah, məmə otol nəməlinuiən otatɨg e nɨkitəmah mətəu-inu nəutatɨg lak. E nəhue nɨftəni u, nahməiən otepət o təmah, mətəu sotəgɨniən, motəhtul məha-məha, mətəu-inu inehpahu rəkɨs nəsanəniən rəha nəhue nɨftəni.” ");
INSERT INTO tnp_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nian Iesu təməghati rəkɨs, kəni məsal-pəri ilɨs e neai, kəni mətəfaki mətəni məmə, “Tatə, rəhak nian tɨnuva rəkɨs. Iəu iəkolkeikei məmə ik onəkəfəri nərgɨ Nətɨm, məmə in mɨn otəmanəfəri nərgəm, ");
INSERT INTO tnp_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","mətəu-inu ik nəməfən nəsanəniən mɨne nepətiən kəm in, məmə in otarmənɨg e nətəmimi rəfin, kəni məhrun mɨn nəfəniən nəmiəgəhiən itulɨn kəm lah mɨn u, nətəm ik nəməfən mɨn ilah kəm in. ");
INSERT INTO tnp_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kəni nəmiəgəhiən itulɨn u, nɨpətɨn u məmə nətəmimi okotəhrun ik, iətəm ik əmə u ik Uhgɨn pəhriən, kəni motəhrun mɨn Iesu Krɨsto u, ik nəmahli=pa. ");
INSERT INTO tnp_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Iəu iəməfəri nərgəm e nəhue nɨftəni u, kəni inol rəfin uək iətəm ik nəməfa kəm iəu məmə iəkol. ");
INSERT INTO tnp_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tatə, rəueiu əha, tɨnol nian rəham məmə onəkos iəu iəkuvnə mətatɨg kilau mɨn ik. Əfəri iəu məfa nepətiən əhagəhag kəm iəu, təhmen əmə məmə inu, iəmos aupən kilau min ik e nian nɨftəni u təmatɨkə əhanəh. ");
INSERT INTO tnp_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nətəmimi mɨn u nətəm ik nəmos rəkɨs ilah o nəhue nɨftəni məfa ilah kəm iəu, iəu iəmatol əpu nərgəm kəm lah, məmə ilah okotəhrun ik. Aupən, ilah rəham mɨn nətəmimi, mətəu rəueiu ik nəməfa ilah e nəhlmək, məmə ilah rəhak mɨn nətəmimi. Ilah kəmautohtəu=pən rəham nəghatiən, ");
INSERT INTO tnp_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","kəni rəueiu əha, ilah kotəhrun məmə, natimnati mɨn u ik nəməfa kəm iəu, ilah kautsɨpən əmə ohnik. ");
INSERT INTO tnp_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ilah kotəhrun natimnati mɨn u, mətəu-inu ik nəməni=pa rəkɨs nəghatiən kəm iəu, kəni iəu iəməni=pən kəm lah, kəni ilah kautos e nɨkilah. Kəni ilah motəhrun məmə nɨpəhriəniən agɨn məmə iəu iəmsɨpɨnə lam, kəni məutəhatətə lak məmə ik nəmahli=pa iəu. ");
INSERT INTO tnp_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Iəu iətəfaki o lah mɨn u. Iəu iəsəfakiən o nətəmimi rəha nəhue nɨftəni, iətəfaki əmə o nətəmimi mɨn u nətəm ik nəməfa ilah kəm iəu, mətəu-inu ilah u rəham mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nətəmimi mɨn u iatos, ilah rəfin rəham, konu ilah rəfin u nətəm ik natos, ilah rəhak. Kəni nətəmimi mɨn u, ik nəmol ilah məmə nəmiəgəhiən rəhalah tətəfəri nərgək. ");
INSERT INTO tnp_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Rəueiu əha iətuva ohnik, kəni təsuvəhiən iəu iəsatɨgiən u e nəhue nɨftəni u. Mətəu nətəmimi mɨn u, ilah okotatɨg əhanəh e nəhue nɨftəni u. Tatə, ik nəkəhruahru agɨn. Onəkaskəlɨm nətəmimi mɨn u kotatɨg vivi e nəsanəniən rəha nərgəm u ik nəməfa kəm iəu, məmə ilah okotatɨg kətiəh əmə, təhmen e lau, kilau kətiəh. ");
INSERT INTO tnp_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nian iəu iəmətatɨg itɨmah min ilah, kəni mətəpali təuvɨr o lah, e nəsanəniən e nərgəm əmə iətəm ik nəməfa kəm iəu. Iəu iəmateh vivi ilah, iəməsairəuauiən e kəti. Kətiəh əmə u iətəm nətɨ nərəkɨniən, inko Uhgɨn otəkeikei mahli=pən e Nɨgəm Asoli. Konu nati əha otol lanəha, məmə otol nəghatiən e Nauəuə Rəha Uhgɨn otuva mol nɨpəhriəniən. ");
INSERT INTO tnp_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Rəueiu əha, iətuva ohnik, mətəu iətəni nəghatiən mɨn u nian iətatɨg e nəhue nɨftəni, məmə ilah mɨn, nɨkilah otagiən məri məriauəh, təhmen əmə məmə iəu nɨkik tətagiən. ");
INSERT INTO tnp_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Iəu iəməni pətɨgəm rəham nəghatiən mɨn kəm lah. Kəni tol lanəha, nətəmimi rəha nəhue nɨftəni u, kəsotolkeikeiən ilah, kəutəməki e lah, mətəu-inu ilah səniəmə nətəmimi rəha nəhue nɨftəni, təhmen əmə məmə iəu səniəmə iətəmi rəha nɨftəni u. ");
INSERT INTO tnp_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Iəu iəsətapuəhiən ohnik məmə onəkos rəkɨs ilah e nəhue nɨftəni u. Mətəu iəkolkeikei məmə ik onəkahtɨpəsɨg e iətəmi tərah u Setən, məmə otəsuvaiən mərəkɨn ilah. Ik nəkəpali təuvɨr o lah. ");
INSERT INTO tnp_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","“Iəu, səniəmə iətəmimi rəha nəhue nɨftəni u. Kəni tol lanəha, ilah mɨn səniəmə nətəmimi rəha nəhue nɨftəni. ");
INSERT INTO tnp_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Rəham nəghatiən in nɨpəhriəniən rəfin. Onəkol rəham nəghatiən məmə in otol uək e nəmiəgəhiən rəhalah məmə ilah nətəmimi pəhriən rəham motasim motəhruahru. ");
INSERT INTO tnp_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ik nəmahli=pa iəu, iəkuva e nəhue nɨftəni u, kəni təhmen əmə, iəu inətahli pətɨgəm mɨn ilah, kautəhuvən e nəhue nɨftəni. ");
INSERT INTO tnp_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kəni iəu iətəfɨnə aru iəu məmə iəkasim o noliən nəlpəkauiən rəham, məmə iəkasiru e nətəmimi mɨn u, məmə ilah mɨn okotasim motəhruahru, kəni ilah nətəmimi pəhriən rəham. ");
INSERT INTO tnp_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Iəu iəsəfaki əməiən o nətəmi mɨn u, mətəu iətəfaki mɨn o nətəmimi mɨn u nətəm okəpanotəhatətə lak e nəghatiən rəha nətəmimi mɨn u. ");
INSERT INTO tnp_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tatə. Iəu iətəfaki o lah, məmə ilah rəfin okəhuva kətiəh əmə, təhmen=pən əmə məmə inu kilau kətiəh əmə, kəni iətəhtul=pɨnə lam, kəni ik nətəhtul=pa lak. Iətəfaki məmə ilah okəhuva kətiəh əmə kitah min ik, məmə nətəmimi rəha nəhue nɨftəni okotəhatətə məmə ik nəmahli=pa iəu. ");
INSERT INTO tnp_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ik nɨnəfa rəkɨs nepətiən kəm iəu, kəni iəu iətəfən pəti nepətiən rəhak kəm lah, məmə ilah okəhuva kətiəh əmə təhmen əmə məmə kilau katuol kətiəh. ");
INSERT INTO tnp_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Iətəhtul=pən e nɨkilah, kəni ik nətəhtul=pa lak. Tol lanəha, iətəfaki məmə, ilah okəhuva kətiəh əmə e natimnati mɨn rəfin məmə nətəmimi mɨn u rəha nəhue nɨftəni, ilah okoteruh motəhrun məmə ik nəmahli=pa iəu, kəni məmə ik nəmolkeikei rəham nətəmimi təhmen əmə məmə inu, ik nəmolkeikei iəu mɨne. ");
INSERT INTO tnp_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tatə, ik nəməfa ilah u e nəhlmək məmə ilah rəhak mɨn, kəni iəu iəkolkeikei məmə ilah okotəhrun nuvaiən ikɨn ko iətəm iəu mɨn iəkuvən ikɨn, məmə ilah okoteruh nepətiən əhagəhag rəhak iətəm iəu iatos. Nepətiən əhagəhag u, ik nəməfa kəm iəu, mətəu-inu ik nəmolkeikei iəu aupən agɨn nian nɨftəni u təmatɨkə əhanəh. ");
INSERT INTO tnp_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Tatə, ik nəkəhruahru agɨn. Nətəmimi rəha nɨftəni u, ilah kotəruru ik, mətəu iəu iəkəhrun ik. Kəni nətəmimi mɨn u rəhak mɨn, ilah kotəhrun məmə ik nəmahli=pa iəu. ");
INSERT INTO tnp_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Iəu iəmol əpu ik kəm lah, məmə ilah okotəhrun vivi ik, konu iəu, oiəkəkeikei matol əpu ik lanəha, məmə nolkeikeiən rəham otɨnpi vivi nɨkilah, kəni məmə iəu aru oiəkatɨg e nɨkilah. Nolkeikeiən u iətəghati lan, in nolkeikeiən rəham, təhmen məmə inu ik nəkolkeikei iəu lan.” ");
INSERT INTO tnp_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nian Iesu təmaupən məfaki rəkɨs, kəmohiet e taun u, kəni motohapumɨn=pən e nɨtəni=pən e nɨpəg ləuahtəni kəti, nərgɨn u, Kitron. Kəni ikɨn əha, kəmərfei nɨgi olif tepət ikɨn. Kəni Iesu mɨne rəhan mɨn nətəmimi mɨn kəməhuvən e nɨki nɨgi mɨn əha. ");
INSERT INTO tnp_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Kəni Jutəs u, iətəmimi u uərisɨg in otəpanegəhan e Iesu kəm rəham mɨn tɨkɨmɨr, in tɨnəhrun rəkɨs ikɨn əha, mətəu-inu nian nəuvein, Iesu mɨne rəhan mɨn nətəmimi ilah kəutuhapumɨn ilah mɨn ikɨn. ");
INSERT INTO tnp_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kəni pris asoli mɨn mɨne Farəsi mɨn kəmotahli=pən soldiə mɨn nətəm kautəhtul o Nimə Rəha Uhgɨn kəhuva moteh Jutəs. Kəni Jutəs təmit ilah mɨne soldiə mɨn nəuvein rəha nətəm Rom, mit ilah məhuvən e nɨki nɨgi olif əha. Ilah kautəmki nəuanɨsiə, mɨne lait mɨn, mɨne natimnati rəha nəluagɨniən. ");
INSERT INTO tnp_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Iesu tɨnəhrun rəkɨs məmə natimnati mɨn u, in otuva tol lanu lan, mətəu in təmaliuək muvən o lah, kəni mətapuəh o lah məmə, “Itəmah nəutəsal e pəh u?” ");
INSERT INTO tnp_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ilah kəmotəni=pən kəm in məmə, “Iətəm Nasərɨt kəti, nərgɨn u Iesu.” Kəni in təni=pən kəm lah məmə, “Mə Iəu u inu.” (Kəni Jutəs, suah u iətəm təmegəhan=pən e Iesu e nəhlmɨlah, in tətəhtul ilah min.) ");
INSERT INTO tnp_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kəni nian Iesu təməni məmə, “Mə Iəu U Inu,” ilah kəmotan e nəmtahlah mohtəlɨg, moteiuaiu motəmei e nɨftəni. ");
INSERT INTO tnp_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Kəni Iesu tatɨg mətapuəh mɨn o lah məmə, “?Itəmah nəutəsal e pəh konu?” Kəni ilah kotəni məmə, “Iətəm Nasərɨt kəti, nərgɨn u Iesu.” ");
INSERT INTO tnp_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Kəni Iesu təni=pən məmə, “Inəni=pɨnə rəkɨs kəm təmah məmə, ‘Mə Iəu u inu.’ Nəmə itəmah nəutəsal lak, kəni təuvɨr məmə nəkotəpəh nətəmimi mɨn u, kautəhuvən lahuənu.” ");
INSERT INTO tnp_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","In təməni lanəha məmə nəghatiən u iətəm in tɨnəni rəkɨs in otol nɨpəhriəniən lan. Nəghatiən u təməni məmə, “Tatə, nətəmimi mɨn u nətəm nəmələhu=pən ilah e nəhlmək, ko iəsairəuauiən e kəti.” ");
INSERT INTO tnp_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimon Pitə təmatələs rəhan kəti nau rəha nəluagɨniən. Kəni əmeiko, in təmeuvi pətɨgəm uəhai əmə rəhan nau, mauəh lan mohatuv rəkɨs nɨmatəlgɨ ioluək kəti rəha pris asoli agɨn, nɨmatəlgɨn maru. Nərgɨ suah kəha, Malkəs. ");
INSERT INTO tnp_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Mətəu Iesu təni=pən kəm Pitə məmə, “Əfən rəham nau e nɨmein. Ik onəkəkeikei məhrun məmə nahməiən u rəhak, iətəm Tatə Uhgɨn in təməfa kəm iəu, kəni iəu iəkəkeikei mətəlɨg əmə lan, mol.” ");
INSERT INTO tnp_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kəni soldiə mɨn rəha nətəm Rom mɨne iətəmi asoli rəhalah, mɨne soldiə mɨn rəha nətəm Isrel, kəmotaskəlɨm Iesu, kəni motəlis-ərain nəhlmɨn. ");
INSERT INTO tnp_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Kəni kəmotaupən motələs in məhuvən təhtul e nəhmtɨ Anəs. Anəs u inu, in rəhn-iəuaniən Kaiəfəs. Kaiəfəs u inu, in pris asoli agɨn e nu əha. ");
INSERT INTO tnp_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kəni Kaiəfəs u inu, in aupən təməni kəm nətəm asoli rəha nətəm Isrel məmə təuvɨr pɨk məmə iətəmimi kətiəh əmə otɨmɨs o nətəmimi, tapirəkɨs məmə nətəmimi rəfin okohmɨs. ");
INSERT INTO tnp_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Kəni Saimon Pitə mɨne iətəmimi kəti mɨn rəha Iesu, ilau kəmiauərisɨg e Iesu. Iətəmimi u kəti mɨn rəha Iesu, pris asoli agɨn in təhrun vivi. Tol lanəha, in təmɨtəu=pən Iesu, muvən əpəha imə e iat rəha nimə rəha pris asoli agɨn u. ");
INSERT INTO tnp_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Mətəu Pitə in təmatəhtul əmə e ket. Kəni iətəmimi kəti mɨn u rəha Iesu, iətəm pris asoli agɨn təhrun vivi, in təmiet muva ihluə, kəni məni=pən kəm pətan u iətəm tətəhtul o ket. Kəni in təmit Pitə mian imə. ");
INSERT INTO tnp_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kəni əmeiko, pətan mɨtə u iətəm tətəhtul o ket, təmafu Pitə kəni tətapuəh ohni məmə, “?Ei, ik mɨn u iətəmimi rəha suah kəha?” Mətəu Pitə təni məmə, “Kəpə, səniəmə iəu rəhan iətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kəni e nian əha, in nian rəha nətəpuiən, kəni noluək mɨn rəha pris asoli agɨn, mɨne soldiə mɨn, ilah kəmotahli nɨgəm e nəmtahlɨ nɨgəm, kəni mautəhtul tɨtəlau lan, məutətogəm. Kəni Pitə mɨn, in təmuvən matəhtul, matətogəm e nɨgəm. ");
INSERT INTO tnp_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kəni pris asoli agɨn tətətapuəh e natimnati mɨn o Iesu. Tətətapuəh o nətəmimi mɨn rəhan mɨne nəghatiən mɨn rəhan iətəm təmatəni mətəgətun ilah lan. ");
INSERT INTO tnp_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Kəni Iesu tətəni=pən kəm in məmə, “Iəu iəmətəni rəhak nəghatiən mɨn e nəhmtɨ nətəmimi. Nian rəfin, iətəgətun nətəmimi lan, əpəha e nimə mɨn rəha nuhapumɨniən, kəni əpəha e Nimə Rəha Uhgɨn, iətəm nətəm Isrel kəutəharəg ikɨn nian rəfin. Iəu iəsəhluaigiən e rəhak nəghatiən mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","?Təhro nəkətapuəh lanu lan kəm iəu? Təuvɨr məmə nəkuvən mətapuəh o nətəmimi kəmotətəu rəhak nəghatiən mɨn. Ilah kotəhrun vivi natimnati mɨn u iətəm iəməni.” ");
INSERT INTO tnp_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nian Iesu təmatəni nəghatiən əha, kəni soldiə kəti iətəm tətəhtul e Nimə Rəha Uhgɨn, in tətəhtul əha ikɨn, təmem nɨkapɨn, kəni məni məmə, “?Nətəni lanko e pris asoli agɨn o nak?” ");
INSERT INTO tnp_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Kəni Iesu təni=pən kəm in məmə, “Nəmə iəməni nəghatiən nəuvein kəsotəhruahruiən, təuvɨr nəkəni pətɨgəm. ?Mətəu nəmə rəhak nəghatiən mɨn kotəhruahru əmə, təhro nəkem iəu?” ");
INSERT INTO tnp_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Kəni əmeiko Anəs tahli=pən Iesu tuvən o pris asoli agɨn u Kaiəfəs. Mətəu təmatəmki əhanəh nɨləuɨs u kəməlis-ərain lan. ");
INSERT INTO tnp_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Kəni Saimon Pitə təhtul əhanəh mətətogəm e nɨgəm. Kəni kautətapuəh ohni məmə, “?Ei, ik mɨn u, ik iətəmimi rəha iətəmi əha?” Mətəu Pitə təni məmə, “Kəpə, səniəmə iəu rəhan iətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kəni əmeiko, ioluək kəti rəha pris asoli agɨn, in nəuanɨləuɨs kəti rəha suah u Pitə təmətahtuv matəlgɨn aupən, in təməni məmə, “?Nɨkik təhti məmə iəmeruh ik itəmah min əpəha e nɨki nɨgi olif, uə kəpə?” ");
INSERT INTO tnp_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Mətəu Pitə təni məmə, “!Kəpə! Səniəmə iəu.” Kəni rəueiu agɨn mɨn, mənɨg kəti təkakə. ");
INSERT INTO tnp_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kəni ləplapɨn agɨn, kəmotələs Iesu mohiet e nimə rəha Kaiəfəs, məhuvən e nimə rəha Pailət. Pailət in iətəm Rom, mətəu in tatos narmənɨgiən asoli Isrel. Nətəm Isrel kautos nətuakəmiən kəti rəhalah, ilah kəsəhuvəniən e nimə rəha Ianihluə kəti. Nəmə okəhuvən imə, kəni ilah kəutəni məmə ilah kotamɨkmɨk e nəhmtɨ Uhgɨn, kəni ilah ko kəsotuniən nauəniən rəha lafet rəha Pasova. ");
INSERT INTO tnp_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nətuakəmiən u rəhalah, tol kəni Pailət in təmiet e rəhan nimə, muva ihluə məmə oteruh ilah. Kəni in təmətapuəh məmə, “?Nɨpəgnəmtɨn nak u itəmah nauteh=pən e suah u?” ");
INSERT INTO tnp_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Kəni ilah kəmotəni=pən kəm in məmə, “!Nəmə suah u in təsatgəhliən lou, kəni iəsotələsiən məhuva ohnik!” ");
INSERT INTO tnp_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Kəni Pailət təni=pən kəm lah məmə, “Təuvɨr məmə itəmah onəkotələs in məhuvən, kəni itəmah motakil, tɨtəu=pən lou mɨn rəhatəmah.” Mətəu ilah kotəni=pən kəm in məmə, “Mətəu nətəm Rom əmə ilah kotegəhan məmə kəhrun nohamuiən itəmi.” ");
INSERT INTO tnp_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Iesu təmətəni aupən məmə in otɨmɨs lanəha, kəni natimnati mɨn u kəmol məmə nəghatiən mɨn u rəhan okəhuva motol nɨpəhriəniən. ");
INSERT INTO tnp_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Kəni əmeiko Pailət tuvən mɨn imə, kəni mauɨn e Iesu tuva məhtul aupən e nəhmtɨn, kəni mətapuəh ohni məmə, “?Təhro? ?Ik kig rəha nətəm Isrel?” ");
INSERT INTO tnp_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Kəni Iesu təni=pən kəm in məmə, “?Ik aru əmə nətətapuəh lankonu lan, uə nətətapuəh mətəu-inu nətəmimi kəutəni=pɨnə iəu kəm ik?” ");
INSERT INTO tnp_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Kəni Pailət təni=pən məmə, “?Təhro? !?Ik nɨkim təhti məmə iəu iətəm Isrel kəti u!? Nətəmimi imam ikɨn əmə mɨne pris asoli mɨn rəham, ilah kəmotegəhan=pa lam e nəhlmək. ?Ik nəmol nati nak?” ");
INSERT INTO tnp_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Kəni Iesu təni məmə, “Iəu, iəsoliən kig rəha nɨftəni u. Nəmə iəu kig kəti təhmen e kig mɨn rəha nəhue nɨftəni u, kəni rəhak nətəmimi mɨn okotəluagɨn, motoh nətəmimi mɨn u kotolkeikei məmə okotəfən iəu e nəhlmɨ nətəmi asoli rəha nətəm Isrel. Mətəu iəu səniəmə kig kəti rəha nəhue nɨftəni u.” ");
INSERT INTO tnp_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Kəni Pailət təməni məmə, “Pəhriən. Ik kig kəti ko.” Kəni Iesu təni məmə, “Ik nəməni məmə iəu kig kəti. Iəu iəmair=pa e nəhue nɨftəni u o nati kətiəh əmə, məmə iətəhtul pətɨgəm mətəni pətɨgəm nɨpəhriəniən. Kəni iətəmimi iətəm nɨkin tagiən məmə otɨtəu=pən nɨpəhriəniən, kəni in tatətəlɨg e rəhak nəghatiən.” ");
INSERT INTO tnp_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Mətəu Pailət təni=pən kəm in məmə, “?Nak u, nɨpəhriəniən?” Kəni Pailət təmiet mɨn muvən meh nətəmi asoli mɨn rəha nətəm Isrel, məni=pən kəm lah məmə, “Iəu iəseruhiən noliən tərah kəti mɨne e suah u, iətəm tətəni məmə suah u təmərəkɨn lou. ");
INSERT INTO tnp_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Mətəu e noliən rəhatəmah, e nian rəha lafet rəha Pasova, nian rəfin iatɨtɨs suah kəti mahli pətɨgəm e kaləpus. ?Kəni təhro? ?Itəmah nəkolkeikei məmə iəu iəkegəhan lan kəni mɨtɨs kig rəha nətəm Isrel?” ");
INSERT INTO tnp_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Kəni ilah kotagət əfəməh motəni məmə, “!Kəpə! !Itɨmah iəkotəpəh suah ko, iəkotolkeikei Parəpəs!” Parəpəs u, in iakləh kəti, kəni in təmətəluagɨn mətohamu itəmi məmə otəhgi pətɨgəm kəpmən rəha Rom. ");
INSERT INTO tnp_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kəni Pailət təməfən Iesu e nəhlmɨ rəhan mɨn soldiə mɨn, kəni ilah kəmotalis. ");
INSERT INTO tnp_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Kəni kəmotəmki nɨləuɨs iətəm tol nihlɨn nihlɨn, motol kəfəfau lan, təhmen e kəfəfau rəha kig, kəni motaharu=pən e rəhn-kapə. Kəni məhuvən=pən e kot əfəməh kəti kəm in, tol nəugɨ naris lan, təhmen e kot rəha kig. ");
INSERT INTO tnp_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Kəni ilah məhuva ohni, məutəuvsan lan, kəni məutəni məmə, “Ik u inu, kig rəha nətəm Isrel. Itɨmah iəkotəfən nɨsiaiən kəm ik.” Kəni ilah mautem=pən əmə nɨkapɨn. ");
INSERT INTO tnp_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Kəni Pailət tiet mɨn muvən ihluə, kəni mətəni=pən kəm nətəmimi məmə, “Ei, nətəmimi. Iəu iəkahli pətɨgəm mɨn suah u tuva ihluə, məmə itəmah onəkoteruh-to məmə iəu iəsehiən noliən tərah lan mɨne.” ");
INSERT INTO tnp_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Kəni Iesu təmiet mɨn muva ihluə. In tətəfəfau e kəfəfau u kəmol e ləhi iətəm tol nihlɨn-nihlɨn, təhmen e kəfəfau rəha kig, kəni matuvən e kot əfəməh tol nəugɨ naris, təhmen e kot rəha kig, kəni Pailət təni=pən kəm lah məmə, “!Nətəmimi! !Oteh-to! Suah u inu!” ");
INSERT INTO tnp_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Mətəu nian pris asoli mɨn mɨne soldiə mɨn nətəm kəutəhtul o Nimə Rəha Uhgɨn kəmotafu, ilah kəmotagət əfəməh mautəni məmə, “!Okətu-pəri e nɨgi kəməluau! !Okətu-pəri e nɨgi kəməluau!” Kəni Pailət təməni=pən kəm lah məmə, “Intələh, itəmah pɨsɨn əmə, otos məhuvən, motətu-pəri e nɨgi kəməluau. Mətəu iəu iəseruhiən noliən tərah kəti mɨne lan.” ");
INSERT INTO tnp_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Mətəu ilah kotəni məmə, “Rəhatɨmah kəti əha ikɨn lou tətəni məmə in otəkeikei mɨmɨs, mətəu-inu in tətəni məmə in Nətɨ Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Kəni nian Pailət təmətəu nəghatiən u, in təməgɨn pɨk təhmɨn mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Kəni in təmatɨg muvən mɨn imə, mətapuəh o Iesu məmə, “?Ik iətəm iə?” Mətəu Iesu təsuhalpɨniən rəhan nəghatiən. ");
INSERT INTO tnp_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Kəni Pailət təni=pən kəm in məmə, “?Təhro nəsəni=paiən kəm iəu? ?Ik nəsəhruniən məmə iəu iətos nəsanəniən məmə iəkahli pətɨgəm ik, kəni matos mɨn nəsanəniən məmə okəhti=pən ik e nɨgi kəməluau?” ");
INSERT INTO tnp_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Kəni Iesu təni=pən kəm in məmə, “Nəmə Uhgɨn təməsoliən nati u, ko ik onəsos agɨniən nəsanəniən məmə onəkakil iəu. Tol lanəha, noliən tərah rəha iətəmi u iətəm təməfɨnə iəu e nəhlməm, in tərah mapirəkɨs rəham.” ");
INSERT INTO tnp_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kəni tətuəuin e nian əha, Pailət təmolkeikei məmə otəhlman e Iesu. Mətəu nətəmi asoli mɨn rəha nətəm Isrel kəutagət əfəməh mautəni məmə, “Nəmə nəkəhlman e suah u mahli pətɨgəm, kəni ik səniəmə iətəmimi rəha Sisə. Iətəmi kəti u iətəm tətəni məmə in kig in tɨkɨmɨr rəha Sisə.” ");
INSERT INTO tnp_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kəni nian Pailət təmətəu nəghatiən u, kəni təmit Iesu muva mɨn ihluə. Kəni in təmuvən əha ikɨn kəti, nərgɨn u, Lou Kəpiel Epin-Epin, e nəghatiən Isrel, in Kapata, kəni mətəharəg-pəri e jeə rəha nakiliən. ");
INSERT INTO tnp_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tɨnuəkɨr mɨtɨgar təhtul əhruahru, e nian əhruahru rəha nol əpenə-penəiən o noliən lafet rəha Pasova. Kəni Pailət təni=pən kəm nətəm Isrel məmə, “!Ei, nətəmimi mɨn əpə! !Otafu-to! !Suah u in kig rəhatəmah!” ");
INSERT INTO tnp_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Mətəu ilah kəmotagət əfəməh, motəni məmə, “!Ohamu! !Ohamu! !Ətu-pəri e nɨgi kəməluau!” Kəni Pailət təməni=pən kəm lah məmə, “?Itəmah nəkotolkeikei mə iəu iəkətu-pəri kig rəhatəmah e nɨgi kəməluau?” Mətəu pris asoli mɨn kotəni məmə, “!Sisə əmə u, in rəhatɨmah kig!” ");
INSERT INTO tnp_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kəni Pailət təmegəhan=pən e Iesu tuvən e nəhlmɨlah, məmə soldiə mɨn rəha Rom okəhuvən motətu-pəri e nɨgi kəməluau. Kəni ilah kəmotələs Iesu məhuvən. ");
INSERT INTO tnp_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","In tatələs nɨgi kəməluau rəhan, miet matuvən ikɨn kəti mɨn, nərgɨn u, Kolkotə e nəghatiən rəha nətəm Isrel. Nɨpətɨn u, “Louipɨl-uipɨl.” ");
INSERT INTO tnp_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Kəni ikɨn əha, kəmotətu-pəri Iesu e nɨgi kəməluau. Kəni kəmotatɨg motəhti=pən mɨn iətəmimi mil keiu e nɨgi kəməluau keiu mɨn, kəti e nɨkalɨn maru, kəti e nɨkalɨn məuɨl, kəni Iesu in tətəhkul e nəlugɨn e lau. ");
INSERT INTO tnp_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Kəni Pailət təməni kətei rəkɨs nəghatiən kəti, kələs kan kəhti=pən e rəhn-kapə nɨgi kəməluau. Nəghatiən u tətəni məmə, Iesu iətəm Nasərɨt kig rəha nətəm Isrel ");
INSERT INTO tnp_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Kəni nətəm Isrel tepət, ilah kotafin nəghatiən u, mətəu-inu ikɨn əha kəmotəhti=pən Iesu ikɨn, in iuəkɨr əmə o taun. Kəni nəghatiən u, kəmətei rəkɨs e nəghatiən rəha nətəm Isrel, mɨne nəghatiən rəha nətəm Rom, mɨne nəghatiən rəha nətəm Kris. ");
INSERT INTO tnp_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kəni pris asoli mɨn rəha nətəm Isrel, kəməhuvən motəni=pən kəm Pailət məmə, “Onəsəteiən məmə, ‘Kig rəha nətəm Isrel.’ Təuvɨr mə onəkətei məmə, ‘Suah u in tətəni məmə in kig rəha nətəm Isrel.’” ");
INSERT INTO tnp_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Mətəu Pailət təni məmə, “!Kəpə! Nati iətəm iəmətei təməhli əmə lanəha.” ");
INSERT INTO tnp_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kəni nian soldiə mɨn kəmotəhti-pəri rəkɨs Iesu e nɨgi kəməluau, kəni motos rəhan napən, kəni motəuəri nəhmtɨn kuvət, mətəu-inu soldiə mɨn ilah kuvət. Mətəu kot əfəməh rəhan, iətəmimi iətəm in təmol napən, təməsɨlpɨniən napən lan, in təmol apiəpiə əmə napən əha. ");
INSERT INTO tnp_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Kəni soldiə mɨn u kɨnotəni-əni kəm lah mɨn məmə, “Ei, təsəuvɨriən məmə okotearɨs nati u. Təuvɨr məmə okotatu əmə e tais ohni. Kəni iətəmi tol win lan, in tos rəhan u kot.” Nati u təmiet məmə otol nəghatiən rəha Nauəuə Rəha Uhgɨn tuva mol nɨpəhriəniən, u təməni məmə, “Ilah kəmotəmki rəkɨs rəhak napən. Ilah kəmotəuəri e lah mɨn. Kəni ilah kəmotatu e tais məmə otəgətun məmə pəh otos napən mɨn əha.” Kəni tol lanəha, soldiə mɨn kəmotol pəhriən lanəha. ");
INSERT INTO tnp_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Kəni iuəkɨr əmə o nɨgi kəməluau rəha Iesu, nɨpətan kuvət kəmautəhtul əha ikɨn. Mamə rəha Iesu, mɨne pia rəhan mamə, mɨne Meri kəti mɨn, pətan rəha Klopəs, mɨne iahunin kəti mɨn Meri pətan Maktələ. ");
INSERT INTO tnp_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kəni nian Iesu təmeruh rəhan mamə mɨne suah u iətəm in tolkeikei pɨk kautəhtul e nɨkalɨn, kəni təni=pən kəm rəhan mamə məmə, “!Pətan, nətɨm ko!” ");
INSERT INTO tnp_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kəni məni=pən kəm suah u məmə, “Ik rəham u mamə.” Kəni tətuəuin e nian əha, suah u təmit pətan u mian iman ikɨn, kəni in təmateh vivi in, təhmen e rəhan əhruahru mamə. ");
INSERT INTO tnp_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Kəni uərisɨg lan, Iesu təməhrun məmə uək mɨn iətəm in təmuva məmə otol, tɨnol naunun rəkɨs. Kəni o noliən nəghatiən mɨn e Nauəuə Rəha Uhgɨn tuva mol nɨpəhriəniən lan, in təməni məmə “Inəuauə.” ");
INSERT INTO tnp_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kəni nosɨnati əkəku kəti əha ikɨn tətəharəg, kəmiuvi=pən wain lanu tarfu, məni lan nəhmtɨn teiuaiu. Kəni ilah kəmotələs nati kəti talus-alus təhmen e kotɨn, kəni motəfən e wain u, kəni motətu=pən e nəhlmɨ nɨgi kəti kətəni məmə hisop, kəni motləfəri tuvən iuəkɨr o nohlɨ Iesu, məmə otəmnɨm. ");
INSERT INTO tnp_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Kəni nian in təməmnɨm wain u nəuvetɨn, kəni məni məmə, “!Natimnati rəfin tɨnol naunun!” Kəni in təmarəg iahu e rəhn-kapə, mehag pətɨgəm e rəhan nehagiən tiet, kəni mɨmɨs. ");
INSERT INTO tnp_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nian əha rəha nol əpenə-penəiən, mətəu-inu okəni lauɨg lan, nian rəha Sapət. (Kəni Sapət u, in Sapət keikei kəti.) Kəni nətəmi asoli rəha nətəm Isrel kəsotolkeikeiən məmə nɨpətɨ suah milahal əha okəhləhkul e nɨgi kəməluau mətəuarus=pən nian əha. Kəni o nati əha inəha, ilah kəməhuvən motətapuəh o Pailət məmə otahli=pən rəhan mɨn nətəmimi, kəhuvən, motahtɨhli nəhlkɨlahal, pəh ilahal okɨhlɨmɨs uəhai əmə. Konu ilah okotələs rəkɨs nɨpətɨlahal. ");
INSERT INTO tnp_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kəni soldiə mɨn kəmotaupən motahtɨhli nəhlkɨ suah mil u keiu iətəm kəmotəhti=pən ilau e nɨgi kəməluau ilahal Iesu. ");
INSERT INTO tnp_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Mətəu nian kəməhuva o Iesu moteruh məmə in tɨnɨmɨs rəkɨs. Kəni əmeiko, ilah kəsotahtɨhliən nəhlkɨn. ");
INSERT INTO tnp_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kəni soldiə kəti təməu əmə nɨkalɨn e rəhan nɨrəu, kəni rəueiu agɨn, nɨrə mɨne nəhu kəmuaiu əhmen-əhmen əmə, mətueiuaiu e nɨpətɨn. ");
INSERT INTO tnp_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Kəni suah kəti əha ikɨn tətəhtul, in təmeh natimnati mɨn u e nəhmtɨn. Kəni nəghatiən mɨn rəha suah u, in təhruahru, kəni in təhrun məmə in tətəni pəhriən. Kəni in tətəni pətɨgəm məmə itəmah mɨn onəkotəhrun motəhatətə lan.) ");
INSERT INTO tnp_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Natimnati mɨn u kəməhuva məmə okotol nəghatiən e Nauəuə Rəha Uhgɨn tuva mol nɨpəhriəniən lan, u tətəni məmə, “Ko nɨkɨlkɨlin kəti təsɨtəgɨtiən.” ");
INSERT INTO tnp_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kəni nəghatiən kəti mɨn e Nauəuə Rəha Uhgɨn tətəni məmə, “Ilah okoteruh suah u iətəm kəmotəu.” ");
INSERT INTO tnp_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kəni uərisɨg e natimnati mɨn u, iətəm Aramatiə kəti, nərgɨn u, Josɨp. Josɨp u, in iətəmimi kəti rəha Iesu, mətəu tətəhluaig e nati u, mətəu-inu tətəgɨn e nətəmi asoli rəha nətəm Isrel. In təmuvən meruh Pailət, kəni tətapuəh ohni məmə otegəhan lan pəh tos rəkɨs nɨpətɨ Iesu. Kəni əmeiko, Pailət təmegəhan lan, kəni in təmuvən mos rəkɨs. ");
INSERT INTO tnp_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Kəni Nikotiməs, u aupən in təmuvən meruh Iesu lapɨn, in təmuvən ilau Josɨp. In tatɨtol kətɨm kəti, təməriauəh e nati pien-pien mɨn u mɨr mɨne alos. Kətɨm u təfɨgəm təhmen e tate kilo. ");
INSERT INTO tnp_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Kəni ilau kəmuos rəkɨs nɨpətɨ Iesu, muəuveg e napən təuvɨr kəti, nərgɨn u linən. Kəni ilau kəmuol=pən mɨr mɨne alos e napən u, təhmen əhruahru əmə məmə inu nətəm Isrel kəutəuveg nɨpətɨ iətəmimi mɨne lan, mautohtənɨm. ");
INSERT INTO tnp_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kəni ikɨn əha kəmətu-pəri Iesu ikɨn e nɨgi kəməluau, nɨmai kəti əha ikɨn, kəni ikɨn əha, nɨpəg kəpiel kəti əha ikɨn, iətəm katɨtənim itəmi ikɨn. Kəni ikɨn əha, kəsɨtənim=pən əhanəhiən iətəmi kəti ikɨn. ");
INSERT INTO tnp_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kəni ilau kəmuələhu=pən nɨpətɨ Iesu e nɨpəg kəpiel u, mətəu-inu nian əha in nian rəha nətəm Isrel kautol əpenə-penə lan o Sapət, kəni nɨpəg kəpiel iətəm katɨtənɨm itəmi ikɨn, in iuəkɨr əmə. ");
INSERT INTO tnp_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","E Sante, ləplapɨn agɨn, tətapinəpu əhanəh, Meri u pətan Maktələ, təmuvən e nɨpəg kəpiel. !Kəni meruh məmə kəpiel asoli u kəmahtɨpəsɨg e nɨpəg kəpiel lan, kəmɨsuə rəkɨs! ");
INSERT INTO tnp_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tol lanəha, kəni in təmaiu mɨtəlɨg muvən o Saimon Pitə mɨne iətəmimi u kəti mɨn rəha Iesu, u Iesu tolkeikei pɨk, kəni məni=pən kəm lau məmə, “Ilah kəmotələs rəkɨs nɨpətɨ Iərmənɨg əpəha e nɨpəg kəpiel. Kəni iəkotəruru məmə kəmotələhu=pən iə nɨpətɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kəni Pitə mɨne iətəmimi kəti mɨn u rəha Iesu, kəmiaiet mətian məmə okueruh nɨpəg əha. ");
INSERT INTO tnp_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Kəmuaiu əsanən mian, mətəu suah u kəti in təmaiu maupən mapirəkɨs Pitə, maupən muvən əpəha nɨpəg u ikɨn. ");
INSERT INTO tnp_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Kəni in təməməhli-əməhli məsal=pən əpəha imə, kəni meruh napən təuvɨr u linən tətəməhli, mətəu in təməsuvəniən imə. ");
INSERT INTO tnp_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kəni Saimon Pitə in təmiet pətɨgəm=pa mɨn, kəni miuvɨg=pən uəhai əmə imə e nɨpəg kəpiel u, kəni meruh napən mɨn u kautəməhli, ");
INSERT INTO tnp_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","kəni meruh mɨn napən u kəməuveg rəhn-kapə Iesu lan aupən. Napən u, in təsəməhli-pəniən ilah napən mɨn u nəuvein, mətəu in kəmaiu-aiu vivi kələhu pɨsɨn. ");
INSERT INTO tnp_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Iətəmimi u rəha Iesu iətəm təmaupən, in mɨn təmuvən imə e nɨpəg kəpiel, kəni in təmeruh natimnati mɨn u, kəni in təməhatətə məmə Iesu tɨnəmiəgəh mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Nauəuə Rəha Uhgɨn tətəni məmə Iesu otəkeikei məmiəgəh mɨn e nɨmɨsiən, mətəu ilah kəsotəhrun vivi əhanəhiən nəghatiən əha.) ");
INSERT INTO tnp_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Kəni iətəmimi mil u rəha Iesu kəmiatəlɨg mətian imalau ikɨn, ");
INSERT INTO tnp_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","mətəu Meri in tətəhtul iuəkɨr e nɨpəg kəpiel u mətasək. Kəni nian in təmətasək əhanəh, kəni məməhli-əməhli mətəsal=pən əpəha e nɨpəg. ");
INSERT INTO tnp_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Kəni əmeiko mafu agelo keiu əpəha imə. Napən rəhalau in təruən vivi. Ilau kətuəharəg əha kəmələhu=pən Iesu ikɨn. Kətiəh tətəharəg e nɨmei rəhn-kapə, kəni kətiəh e nɨmei nəhlkɨn. ");
INSERT INTO tnp_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Kəni ilau kəmuətapuəh ohni məmə, “Pətan. ?Ik nətasək o nak?” Kəni in təməni=pən kəm lau məmə, “Ilah kəmotələs rəkɨs nɨpətɨ Iərmənɨg rəhak, kəni iəkəruru məmə kəmotələhu=pən iə.” ");
INSERT INTO tnp_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nian in tɨnəni rəkɨs nəghatiən u, kəni meirair, kəni meruh Iesu tətəhtul, mətəu in təruru məmə Iesu. ");
INSERT INTO tnp_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Kəni Iesu təmətapuəh ohni məmə, “Pətan. ?Nətasək o nati nak? Ik nətəsal e pəh?” Mətəu pətan u, nɨkin təhti məmə məta iətəmi u tətafəl nati əha ikɨn əha, kəni in təməni=pən kəm in məmə, “Iətəmi asoli, nəmə ik nəmələs rəkɨs nɨpətɨn, kəni mələhu=pən ikɨn kəti, əui, əni=pa-to kəm iəu, pəh iəu iəkuvən mos.” ");
INSERT INTO tnp_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Kəni Iesu təni=pən məmə, “Meri.” Kəni Meri təmeirair uəhai əmə, məsal=pən meruh, kəni məni məmə, “!Raponi!” (Inu nəghatiən rəha nətəm Isrel u, nɨpətɨn təni məmə, “Rəhak Iəgətun.”) ");
INSERT INTO tnp_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Kəni Iesu təməni=pən kəm in məmə, “Saskəlɨmiən iəu, mətəu iəu iəsuvən əhanəhiən əpəha ilɨs o rəhak Tatə. Mətəu ik, uvən, meh piak mɨn kəni məni=pən kəm lah məmə iəu inatɨtəlɨg=pən ilɨs o rəhak Tatə, kəni in mɨn rəhatəmah Tatə. In Uhgɨn rəhak, kəni in Uhgɨn mɨn rəhatəmah.” ");
INSERT INTO tnp_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kəni Meri təmuvən meruh nətəmimi mɨn rəha Iesu, kəni təni=pən kəm lah məmə, “!Nəsuah mɨn əpə! !Iəu iəmeruh Iərmənɨg!” Kəni in təməni pətɨgəm nəghatiən mɨn iətəm Iesu in təməni=pən kəm in. ");
INSERT INTO tnp_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","E Sante ləhnaiuv, nətəmimi mɨn rəha Iesu kəmotuhapumɨn ilah mɨn əpəha e nimə kəti, kəni motasisɨg e doə motol lok lan, mətəu-inu ilah kəutəgɨn e nətəmimi asoli rəha nətəm Isrel. Kəni əmeiko, Iesu təmuva məhtul e nəlugɨn e lah kəni məni=pən kəm lah məmə, “Pəh nəməlinuiən tətatɨg o təmah.” ");
INSERT INTO tnp_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kəni məgətun nəhlmɨn mɨne nəhlkɨn kəm lah, kəni nɨkilah təmagiən pɨk mətəu-inu kɨnoteruh Iərmənɨg. ");
INSERT INTO tnp_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Kəni Iesu təni=pən mɨn kəm lah məmə, “Pəh nəməlinuiən tətatɨg o təmah. Tol mə rəhak Tatə təmahli=pa iəu, e noliən əhmen əmə, iəu iətahli=pən itəmah.” ");
INSERT INTO tnp_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kəni nian in tɨnəni rəkɨs nəghatiən u, kəni in təmehag=pən e lah, kəni məni məmə, “Itəmah, otos Narmɨn Rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nəmə nəkotalu e noliən tərah rəha iətəmimi, kəni Uhgɨn mɨn otafəl rəkɨs noliən tərah rəhan. Mətəu nəmə itəmah nəsotaluiən e noliən tərah rəha iətəmimi, kəni Uhgɨn otəsaluiən lan kəni məsafəl rəkɨsiən.” ");
INSERT INTO tnp_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Kəni iətəmi tueləf u kəti rəha Iesu, nərgɨn u Toməs, u kətauɨn lan məmə, Mil-Mil, in təmɨkə e nian Iesu təmiet pətɨgəm=pa o lah. ");
INSERT INTO tnp_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kəni in mɨn nəuvein, ilah kəmotəni=pən kəm in məmə, “!Ei, iəmoteruh rəhatah Iərmənɨg!” Mətəu Toməs təməni=pən kəm lah məmə, “Nəmə iəkeruh nɨmei nil e nəhlmɨn mil, konu iəkek e nəuanəhlmək, konu meapən e nɨmei nɨrəu e nɨkalɨn, konu pəh iəkəni nɨpəhriəniən məmə in pəhriən məpanəhatətə lan. Mətəu nəmə iəsehiən, ko iəsəhatətəiən lan.” ");
INSERT INTO tnp_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Kəni tɨnos nəfakiən apiəpiə kətiəh rəkɨs, nətəmimi mɨn rəha Iesu kəutəharəg mɨn əpəha imə, e nimə kətiəh əmə, kəni motahtɨpəsɨg e doə, motol lok. Kəni Toməs əha ikɨn ilah min. Nati əpnapɨn kəmol lok e doə, mətəu Iesu tatɨg muva mɨn məhtul e nəlugɨn e lah məni=pən məmə, “Pəh nəməlinuiən tətatɨg o təmah.” ");
INSERT INTO tnp_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kəni məni=pən kəm Toməs məmə, “Eruh-to nəhlmək. Va mek e nəuanəhlməm. Kəni muahru=pa e nəhlməm kəni meapən e nɨmei nɨrəu u e nɨkalɨk. Səniən neiuəiən lan, mətəu ik onəkəkeikei məhatətə lak.” ");
INSERT INTO tnp_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Kəni Toməs təni=pən kəm in məmə, “Ik rəhak Iərmənɨg, kəni ik rəhak Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Kəni Iesu təni=pən kəm in məmə, “Ik nəməhatətə lak, mətəu-inu nəmeruh iəu. Mətəu nətəmimi mɨn u kəsoteruhiən iəu, kəni ilah kəutəhatətə lak, ilah okotos nəuvɨriən pəhriən, nɨkilah tagiən pəhriən.” ");
INSERT INTO tnp_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iesu təmol nəmtətiən mɨn tepət e nəhmtɨ rəhan nətəmimi, iətəm kəsətei rəkɨsiən e nauəuə u. ");
INSERT INTO tnp_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Mətəu kəmətei natimnati mɨn u e nauəuə u məmə itəmah onəkotəhatətə məmə Iesu in Krɨsto iətəm Uhgɨn təməni məmə otahli=pa, inu Nətɨ Uhgɨn. Kəmətei lanəha, məmə itəmah onəkotos nəmiəgəhiən e nərgɨn, mətəu-inu itəmah nəutəhatətə lan. ");
INSERT INTO tnp_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Uərisɨg e natimnati mɨn u, Iesu təmol əpu mɨn in o rəhan mɨn nətəmimi, əpəha e nɨpəkɨl e nɨkalɨ nəhu asoli, kətəni məmə Lek Kaləli. Kəni təmol əpu in lanu. ");
INSERT INTO tnp_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","E nian əha, nətəmimi mɨn u rəha Iesu kəmotaliuək kətiəh: Saimon Pitə, mɨne Toməs u kətauɨn lan məmə Mil-Mil, mɨne Nətaniəl u iətəm Kaləli iman lahuənu Kenə, mɨne nətɨ Səpəti mil, mɨne iətəmimi mil keiu mɨn rəha Iesu. ");
INSERT INTO tnp_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Pitə təni=pən kəm lah məmə, “Iəu inatuvən iəkauəl e nəmu mɨn.” Kəni ilah kotəni məmə, “Intəh, pəh kitah rəfin kəhuvən.” Kəni ilah rəfin kəmoteiuaiu, məhuvən e bot kəti. Kəni Pitə təməpeg rəhan napən o uək. Kəni ilah kəməhuvən, motəraki e net, mətəuarus tian. Mətəu kəsotosiən nəmu kəti mɨne. ");
INSERT INTO tnp_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kəni tɨnatian, kəni Iesu tuva mətəhtul ipari, mətəu rəhan mɨn nətəmimi, ilah kotəruru məmə Iesu. ");
INSERT INTO tnp_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","In tətapuəh o lah məmə, “!Nəman! ?Nəsotosiən nəmu kəti?” Kəni ilah kotəni məmə, “Kəpə, nəmu tɨkə.” ");
INSERT INTO tnp_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kəni in təni=pən kəm lah məmə, “Intəh, otəraki=pən-to e net e nəven maru ikɨn e nɨkalɨ bot, kəni onəkotiuvi nəmu nəuvein.” Kəni əmeiko, kəmotəraki pətɨgəm e net, əmeiko, mɨnotəruru niuvi-pəriən, mətəu-inu net təri mɨnəri mɨnəriauəh e nəmu. ");
INSERT INTO tnp_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Kəni suah u iətəmi Iesu tolkeikei pɨk, in təni=pən kəm Pitə məmə, “!Ei! !Iərmənɨg əhruahru əha!” Kəni nian Pitə təmətəu nəghatiən u, təmətəuti uəhai əmə e rəhan kot, kəni miuvɨg pətɨgəm ləuantəhi, meai muvari. ");
INSERT INTO tnp_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Kəni nətəmimi mɨn u nəuvein rəha Iesu, ilah kəməhuvari e bot, motiuvi net əpəha təməriauəh e nəmu, mətəu-inu bot iuəkɨr əmə o nɨpəkɨl, təhmen əmə o hanrɨt mitə. ");
INSERT INTO tnp_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kəni nian ilah kəməhuvari, moteruh nɨgəm əkəku kəti əha ikɨn, nəuanəmkeiuv tatuəu əhanəh, kəni nəmu nəuvein əha ikɨn, kətuvan e nɨgəm, mɨne pɨret əha ikɨn. ");
INSERT INTO tnp_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Kəni Iesu təni=pən kəm lah məmə, “Otos nəmu mɨn ko nəuvein iətəm nəmotos məhuva.” ");
INSERT INTO tnp_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Kəni Saimon Pitə təmuvən mɨn e bot, kəni miuvi kəkan net muvən əpəha ipari. Net u təriauəh e nəmu asoli mɨn, ilah rəfin uan-hanrɨt fifti-tri. Kəni nati əpnapɨn məmə net u təməriauəh pau e nəmu, mətəu in təməsəhapuiən. ");
INSERT INTO tnp_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Kəni Iesu təməni=pən kəm lah məmə, “Əhuva motauən.” Kəni ilah nɨkilah təgɨn məmə otətapuəh ohni məmə, “?Ik pəh u?” mətəu-inu ilah kɨnotəhrun əsas məmə in Iərmənɨg. ");
INSERT INTO tnp_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Kəni Iesu təmos pɨret muva məfən kəm lah, kəni məfən mɨn nəmu. ");
INSERT INTO tnp_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Kəni inu, nian tatol kɨsɨl lan, iətəm Iesu təmol əpu in o rəhan mɨn nətəmimi uərisɨg e nian in təmɨmɨs, kəni məmiəgəh mɨn. ");
INSERT INTO tnp_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nian ilah kɨnotauən rəkɨs, Iesu təmətapuəh o Saimon Pitə, məmə, “Saimon Pitə, nətɨ Jon. ?Ik nəkolkeikei iəu tapirəkɨs nətəmi mɨn u?” Pitə təni=pən kəm in məmə, “Əuəh, Iərmənɨg, ik nəkəhrun məmə iəu iəkolkeikei pɨk ik.” Kəni Iesu təni=pən kəm in məmə, “Intəh, ik onəkaugɨn rəhak nenətɨ sipsip mɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kəni Iesu tatɨg mətapuəh mɨn ohni məmə, “Saimon, nətɨ Jon. ?Ik nəkolkeikei iəu?” In təni=pən kəm Iesu məmə, “Əuəh Iərmənɨg, ik nəkəhrun məmə iəkolkeikei ik.” Kəni Iesu təni=pən kəm in məmə, “Intələh, ik onəkəsal vivi o rəhak mɨn sipsip.” ");
INSERT INTO tnp_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kəni mau kɨsɨl lan, Iesu tatɨg mətapuəh mɨn ohni məmə, “Saimon, nətɨ Jon. ?Ik nəkolkeikei iəu?” Kəni Pitə, nɨkin təmahmə, mətəu-inu Iesu təmətapuəh ohni mau kɨsɨl, məmə, “?Ik nəkolkeikei iəu?” Kəni in təni=pən kəm in məmə, “Iərmənɨg, ik nəkəhrun rəfin natimnati. Nəkəhrun məmə iəu iəkolkeikei ik.” Kəni Iesu təni=pən kəm in məmə, “Intəh, ik ətaugɨn rəhak mɨn sipsip. ");
INSERT INTO tnp_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“Nɨpəhriəniən agɨn u iatəni kəm ik məmə, aupən, e rəham nətəm aluəiən, nəməteargin aru rəham kətəuti, kəni mətaliuək matuvən ikɨn mɨn rəfin iətəm nəkolkeikei məmə nəkuvən ikɨn. Mətəu nian ik onəkauəhli, onəkuahru e nəhlməm, kəni iətə-pɨsɨn kəti otəlis-ərain rəham kətəuti, kəni mit ik nəkian ikɨn ik nəsolkeikeiən məmə nəkuvən ikɨn.” ");
INSERT INTO tnp_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","E nəghatiən u, Iesu təmaupən mətəni pətɨgəm rəkɨs əmə, noliən iətəm Pitə otɨmɨs, kəni rəhan nɨmɨsiən, in otəfəri nərgɨ Uhgɨn. Kəni Iesu təni=pən kəm in məmə, “Intəh, uərisɨg lak.” ");
INSERT INTO tnp_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Kəni Pitə teirair meruh iətəmimi kəti rəha Iesu tətuərisɨg e lau, iətəmimi u Iesu tolkeikei pɨk. Iətəmi əha inəha, iətəm təmiəu-iəu muva iuəkɨr o Iesu e nian kəməutauən e lafet rəha Pasova, kəni mətətapuəh ohni məmə, “?Iərmənɨg, pəh u otegəhan=pən lam e nəhlmɨ rəham mɨn tɨkɨmɨr?” ");
INSERT INTO tnp_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nian Pitə təmeruh in, kəni tətapuəh o Iesu məmə, “?Iərmənɨg, mətəu təhro e suah kəha?” ");
INSERT INTO tnp_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Kəni Iesu təni=pən kəm in məmə, “?Nəmə iəu iəkolkeikei məmə in otətəmiəgəh muvən mətəuarus nian iəkɨtəlɨg=pa mɨn, ik onəkəhrun o nak? Ik u, ik onəkəkeikei muərisɨg lak.” ");
INSERT INTO tnp_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kəni tol lanəha o nati u Iesu təməni, nəghatiən kəti əha ikɨn kətəni tɨtəlau-təlau e piatah mɨn məmə, “Iətəmimi u rəha Iesu otəsɨmɨsiən,” mətəu Iesu təməsəniən kəm Pitə məmə suah u otəsɨmɨsiən. In təməni əmə məmə, “?Nəmə, iəu iəkolkeikei məmə in otətəmiəgəh mətəuarus=pən iəkɨtəlɨg=pa mɨn, ik onəkəhrun o nak?” ");
INSERT INTO tnp_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Iətəmimi u rəha Iesu in iətəmimi kətiəh əmə iətəm tətəni pətɨgəm natimnati mɨn u, kəni in mətei rəkɨs nəghatiən mɨn u. Kəni itɨmah iəkotəhrun məmə nəghatiən mɨn u tətəni, in nɨpəhriəniən əmə. ");
INSERT INTO tnp_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kəni natimnati tepət mɨn əpəha ikɨn iətəm Iesu təmol kəni nəmə nətəmimi kəmotətei rəkɨs natimnati mɨn u ilah rəfin e nauəuə mɨn, iəu, nɨkik təhti məmə nəhue nɨftəni u təkəku o nəlɨniən nauəuə mɨn u. ");
INSERT INTO tnp_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofɨləs, e rəhak nauəuə iətəm iəmətei aupən, iəmətei noliən mɨn rəha natimnati rəfin iətəm Iesu təmol mɨne mətəgətun nətəmimi lan. ");
INSERT INTO tnp_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Nauəuə əha tətəni pətɨgəm nian Iesu təmətuəuin rəhan uək mətəuarus Uhgɨn təmos rəkɨs muvən e Negəu e Neai. Mətəu aupən, nian təməsuvən əhanəhiən e Negəu e Neai, Narmɨn Rəha Uhgɨn təmasiru lan məmə otəgətun rəhan mɨn aposɨl mɨn nati nak in tolkeikei məmə okotol. ");
INSERT INTO tnp_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","E nian təməmiəgəh mɨn e nɨmɨsiən, nian tepət tətuva o lah, kəni koteruh in e nian kətiəh kətiəh e nian fote, kəni matol əpu in kəm lah kəni məgətun ilah e noliən mɨn tepət məmə in təməmiəgəh pəhriən e nɨmɨsiən. Kəni e nian mɨn əha, təmətəgətun ilah e Narmənɨgiən Rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Iesu təmətatɨg əhanəh ilah min ilah, kəni nian kəti, nian təmətauən ilah min ilah, in təməni=pən nəghatiən kəti kəm lah məmə, “Itəmah onəsotaupəniən mohiet u Jerusɨləm. Onəkotəkeikei məutatɨg motətəuarus onəkotos Narmɨn Rəha Uhgɨn, u rəhak tatə təməni əskasɨk rəkɨs məmə otəfən kəm təmah, təhmen lanu məmə iəu iəməni=pɨnə rəkɨs kəm təmah. ");
INSERT INTO tnp_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Aupən Jon təmatol bəptais e nətəmimi e nəhu, mətəu otəsuvəhiən, Uhgɨn in otol bəptais e təmah e Narmɨn Rəhan.” ");
INSERT INTO tnp_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","E nian mɨn əha, aposɨl mɨn kəməutatɨg ilah Iesu, kəmotətapuəh ohni məmə, “?Iərmənɨg, rəueiu əha tɨnəuvɨr məmə ik onəkol kitah nətəm Isrel okotarmənɨg e nɨtəni mɨn rəhatah, uə kəpə?” ");
INSERT INTO tnp_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Mətəu Iesu təni=pən kəm lah məmə, “E nian mɨn rəha natimnati mɨn əha, Tatə Uhgɨn təməhluaig e natimnati o təmah, məmə ko nəsotəhruniən. In pɨsɨn əmə, tɨnɨtəpɨn rəkɨs e rəhan nəsanəniən. ");
INSERT INTO tnp_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Mətəu nian Narmɨn Rəha Uhgɨn otuva mətɨg e təmah, itəmah onəkotos nəsanəniən. Kəni itəmah onəkotəkeikei məhuvən motəni pətɨgəm rəhak nəghatiən əpəha Jerusɨləm, mɨne ikɨn mɨn əpəha Jutiə, mɨne Səmeriə, kəni mɨne ikɨn mɨn rəfin e nɨtənimtəni mɨn.” ");
INSERT INTO tnp_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nian təməni rəkɨs əmə nəghatiən əha kəm lah, kəni Uhgɨn tos rəkɨs in məri matuvən e neai. Nian ilah kəmauteruh, kəni nəpuə kəti tuva məuveg, kəni ilah kəsoteruhiən mɨn. ");
INSERT INTO tnp_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nian kəməutəsal pəri əhanəh e neai məutəsəl lan, əmeiko suah mil keiu kəmuəfən napən ruən kəmiaiet=pa e nəlugɨn e lah. ");
INSERT INTO tnp_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Kəni muəni=pən kəm lah məmə, “!Nətəm Kaləli! ?Təhro nəutəhtul u ikɨnu məutəsal pəri lan əpətu lan e nəpuə? Iesu əha Uhgɨn təmos rəkɨs o təmah mos məri matuvən e neai, in otəmanɨtəlɨg pa mɨn təhmen=pən əmə lanəha, mə tətəri matuvən.” ");
INSERT INTO tnp_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kəni aposɨl mɨn kəmotsɨpən e nɨtəuət u kətəni məmə, Nɨtəuət Rəha Nɨgi U Olif, motohtəlɨg=pən Jerusɨləm səniəmə isəu pɨk, iuəkɨr əmə. ");
INSERT INTO tnp_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nian kəmohiet=pən Jerusɨləm, məhuvən=pən imə e nəuan nimə kəti əpəha ilɨs lan, ikɨn kəutatɨg ikɨn. Aposɨl mɨn əha, nərgɨlah u Pitə mɨne Jon mɨne Jemɨs mɨne Antɨru mɨne Fɨlɨp mɨne Toməs mɨne Patolomiu mɨne Matiu mɨne Jemɨs nətɨ Alfiəs mɨne Saimon Selot mɨne Jutəs nətɨ Jemɨs. ");
INSERT INTO tnp_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nətəmi mɨn əha mɨne nɨpətan mɨn, mɨne Meri u məmə rəha Iesu, mɨne notəha Iesu mɨn, ilah kəutəhuva pəti-pəti e nɨkilah kətiəh məutəfaki nian rəfin. ");
INSERT INTO tnp_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Kəni nian kəti, nian nətəm kautəhatətə e Iesu kəməutəharəg, ilah tepət, təhmen e uan-hanrɨt-tuenti ilah rəfin. Kəni Pitə təməhtul mətəghati kəm lah məmə, ");
INSERT INTO tnp_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Piak mɨn mɨne nəuvɨnɨk mɨn. Nuvəh aupən Narmɨn Rəha Uhgɨn təməfən nəghatiən kəti kəm Kig Tefɨt, kəni Kig Tefɨt təni pətɨgəm. Təməni məmə suah kəti otegəhan e Iesu kəm nətəmimi, kəni ilah okotaskəlɨm motohamu. Nəghatiən rəha Nauəuə Rəha Uhgɨn otəkeikei muva mol nɨpəhriəniən lan, kəni rəueiu nəghatiən o suah u tɨnuva mol nɨpəhriəniən rəkɨs lan. Suah u in Jutəs. ");
INSERT INTO tnp_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jutəs, in rəhan əha ikɨn uək məmə otasiru e tah, in kitah əmə.” ");
INSERT INTO tnp_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Jutəs u inu təmos nəhmtɨ nɨftəni kəti e məni u təmos e noliən tərah iətəm in təmol. E nɨftəni əha, təməmei morin kəni nərfɨn təhapu nɨsɨgan tiet. ");
INSERT INTO tnp_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kəni nətəm Jerusɨləm kəmotətəu nəghatiən əha, kəni ilah kotauɨn e nɨftəni əha e nəghatiən əha ikɨn məmə, “Akeltama,” nɨpətɨn u məmə Nɨftəni E Nɨrə.) ");
INSERT INTO tnp_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Kəni Pitə təməni məmə, “Natimnati iətəm Jutəs təmol təmuva mol nɨpəhriəniən lan mətəu-inu e Nauəuə Rəha Nəpuən Mɨn, nəghatiən kəti tətəni məmə, ‘Təuvɨr məmə rəhan nimə tətəhtul əpnapɨn əmə, pəh iətəmi kəti otəsatɨgiən ikɨn.’ “Kəni nəghatiən kəti mɨn tətəni lanu məmə, ‘Təuvɨr məmə iətəmi pɨsɨn kəti mɨn otuva mos nɨmein.’ ");
INSERT INTO tnp_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Kəni tol lanəha, iətəmi kəti otəkeikei mos nɨmei Jutəs mətəni pətɨgəm kəm nətəmimi itɨmah min, məmə Iərmənɨg Iesu təməmiəgəh mɨn e nɨmɨsiən. Suah u, in suah kəti iətəm itɨmah min iəmautan aupən e nian mɨn u iətəm Iərmənɨg Iesu təmətaliuək lan. Suah u in suah kəti iətəm təmətatɨg nian Jon təmətəni pətɨgəm nəghatiən rəha noliən bəptais e təmi, muva mətəuarus=pən nian Uhgɨn təmos rəkɨs Iesu o tah mos məri muvən e Negəu e Neai.” ");
INSERT INTO tnp_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Kəni ilah kəmotəni nərgɨ iətəmi keiu, kəti nərgɨn u Josɨp u nian nəuvein kətauɨn lan məmə Pasapəs Jastəs, kəni kəti mɨn, nərgɨn u Matiəs. ");
INSERT INTO tnp_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Kəni ilah kəmotəfaki məutəni məmə, “Iərmənɨg ik nəkəhrun nɨki nətəmimi rəfin. Ik əgətun e tɨmah məmə suah mil u, in pəhruvən u ik nɨnɨtəpɨn rəkɨs ");
INSERT INTO tnp_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","məmə otaskəlɨm uək u rəha aposɨl iətəm Jutəs təməpəh məmə otuvən e suaru iətəm tərah, iman əhruahru ikɨn.” ");
INSERT INTO tnp_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nian ilah kəmotəfaki rəkɨs, ilah kəmoturin kəpiel nəuvein, kotəhmen e tais, məmə otəgətun məmə pəh otos uək əha, kəni kəpiel mɨn kəmotəgətun nərgɨ Matiəs. Kəni ilah kotəfən Matiəs məmə in aposɨl kəti, kəni rəueiu tɨnol mɨn tueləf aposɨl ilah rəfin. ");
INSERT INTO tnp_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","E nian rəha Pentekos, lafet kəti rəha nətəm Isrel, nətəm u kəutəhatətə e Iesu kəməhuva kətiəh. ");
INSERT INTO tnp_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kəni rəueiu agɨn mɨn, kəmotətəu nati kəti təmsɨpəri e neai təhmen e nɨmətagi asoli kəti tətərkərɨk, kəni nati kəha kəmotətəu təmuva məri rəfin e nɨpəgnəua nimə əha kəutəharəg ikɨn. ");
INSERT INTO tnp_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kəni ilah kəmoteruh nati kəti təhmen e nəmnamɨ nɨgəm tatuəu. Kəni nəmnamɨ nɨgəm mɨn əha, kəmotiuvɨg motan-əhmen nətəmimi rəfin nətəm kəutəharəg əha imə. ");
INSERT INTO tnp_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kəni ilah rəfin, Narmɨn Rəha Uhgɨn təmuva məriauəh mətatɨg e lah, kəni məfən nəsanəniən kəm lah, mol ilah kɨnəutəghati e nəghatiən ikɨ pɨsɨn mɨn. ");
INSERT INTO tnp_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kəni nətəmimi mɨn nəuvein əha ikɨnu, nətəm Isrel nətəm kəutəfaki kəm Uhgɨn. Aupən, ilah kəməhuvən e nɨtəni pɨsɨn pɨsɨn mɨn məutatɨg ikɨn, kəni rəueiu kohtəlɨg=pa məutatɨg Jerusɨləm məmə okotol lafet rəha Pasova. ");
INSERT INTO tnp_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nian ilah kəmotətəu nəghatiən mɨn əha, nətəmimi mɨn tepət kəməhuva. Kəni ilah kəmotauɨt pɨk mətəu-inu kəmotətəu nəghatiən mɨn rəhalah nətəmimi mɨn əha kəutəni. ");
INSERT INTO tnp_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kəmotauɨt pɨk agɨn kəni məutəni məmə, “!Ei! ?Nətəm Kaləli mɨn əmə əha kəutəghati, uə kəpə? ");
INSERT INTO tnp_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","?Təhro əpəha kitah rəfin kəutətəu rəhatah nəghatiən mɨn ilah kəutəni? ");
INSERT INTO tnp_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","Kitah u nətəmimi ikɨ pɨsɨn pɨsɨn mɨn tepət. Ikɨn u nətəm Patiə u ikɨn, mɨne nətəm Metiə, mɨne nətəm Elam, mɨne nətəm Mesopotemiə, mɨne nətəm Jutiə, mɨne nətəm Kapatosiə, mɨne nətəm Pontəs, mɨne nətəm Esiə, mɨne nətəm Fritiə, mɨne nətəm Pamfiliə, mɨne nətəm Ijɨp, mɨne nətəm Lipiə e nɨkalɨn=pən əha Saerin ikɨn, mɨne nətəm Rom, nətəm Isrel əhruahru, mɨne Nanihluə mɨn mətəu kitah kəutəfaki kəm Uhgɨn, mɨne nətəm Krit, mɨne nətəm Arepiə. Mətəu kitah rəfin kəmotətəu ilah kəutəghati e nəghatiən ikɨ pɨsɨn pɨsɨn mɨn rəhatah, məutəni pətɨgəm nati asoli mɨn iətəm Uhgɨn təmol.” ");
INSERT INTO tnp_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Narmɨlah təmiuvɨg pɨk, kəni kəmotətapuəh o lah mɨn məmə, “!Ei! ?Nak u tol lanu?” ");
INSERT INTO tnp_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Mətəu nəuvein kəmotaləh əuvsan e lah, məutəni məmə, “Nati kəutapɨs əpəha.” ");
INSERT INTO tnp_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kəni Pitə təməhtul ilah lepɨn aposɨl mɨn, məghati əfəməh məni=pən kəm nətəmimi məmə, “Nətəmimak mɨn nətəm Isrel, mɨne nətəm ikɨ pɨsɨn pɨsɨn mɨn u nəutatɨg Jerusɨləm, otətəlɨg vivi-to lak, pəh iəkuhamtei=pɨnə nɨpətɨ nati əha kəm təmah. ");
INSERT INTO tnp_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Itəmah nəutəni məmə nətəmi mɨn u kəutapɨs. Mətəu kəpə, kəsotapɨsiən. Nain klok əmə əha rəueiu ləplapɨn. ?Kəni ilah kotəhra motapɨs? ");
INSERT INTO tnp_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","“Mətəu mə tol lanu lan. Iəni rəha Uhgɨn aupən, nərgɨn u Joel, təməni rəkɨs nati u itəmah nəuteruh. In təməni məmə, ");
INSERT INTO tnp_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Uhgɨn təməni məmə, “E naunun nian mɨn, iəkəfən rəhak Narmɨn kəm nətəmimi rəfin. Ilah rəfin okotos nəsanəniən lan. Nenətɨtəmah mɨn, nəman mɨne nɨpətan, ilah okotəni pətɨgəm nəghatiən mɨn rəhak iətəm iəu iəkəfən kəm lah. Nətəm aluə mɨn rəhatəmah, Uhgɨn otəfən nati kəti təhmen e nəməhlairiən kəm lah. Kəni nauəhli mɨn rəhatəmah okotəməhlair e nəməhlairiən pɨsɨn pɨsɨn mɨn. ");
INSERT INTO tnp_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Səniəmə nətəmi asoli mɨn əmə, mətəu nəman mɨne nɨpətan ilah noluək mɨn əmə rəhak, kəni iəkəfən Narmɨn rəhak kəm lah e nian mɨn əha. Kəni ilah okotəni pətɨgəm nəghatiən mɨn rəhak iətəm iəkəfən kəm lah. ");
INSERT INTO tnp_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Oiəkol nati apɨspɨs mɨn əpəha e neai, mɨne nəmtətiən pɨsɨn pɨsɨn mɨn e nɨtəni mɨn. Onəkoteruh nɨrə mɨne nɨgəm mɨne nahnɨgəm okotəri motol nəpuə lan. ");
INSERT INTO tnp_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Mɨtɨgar otaupən mapinəpu lan, kəni məuɨg otasiə təhmen e nɨrə. Kəni ko uərisɨg, Nian asoli agɨn rəha Iərmənɨg otuva. ");
INSERT INTO tnp_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","E nian əha, nətəmimi rəfin nətəm okotauɨn e Nərgək, iəu oiəkosmiəgəh ilah.” ’ ");
INSERT INTO tnp_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Nətəm Isrel, itəmah otətəlɨg e nəghatiən u. Itəmah nəkotəhrun vivi nati apɨspɨs mɨn, mɨne nəmtətiən pɨsɨn pɨsɨn mɨn iətəm Iesu iətəm Nasərɨt təmol e nəsanəniən rəha Uhgɨn, u itəmah nəmoteruh. Natimnati mɨn əha tətəgətun məmə Uhgɨn in pɨsɨn əmə təmahli=pa Iesu tuva. ");
INSERT INTO tnp_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","E nəlpəkauiən rəha Uhgɨn u in təmol rəkɨs mələhu aupən, in təməfɨnə suah u e nəhlmɨtəmah. Kəni itəmah nəmotuhamu in e nian nəmotegəhan=pən lan tuvən e nəhlmɨ nətəm kəsotəfakiən. Kəmotuh u, kəmotətu-pəri e nɨgi kəməluau kəni tɨmɨs. ");
INSERT INTO tnp_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","“Mətəu Uhgɨn təmɨtɨs Iesu e nahməiən rəha nɨmɨsiən, kəni mol in təmiəgəh mɨn e nɨmɨsiən, mətəu-inu nɨmɨsiən, rəhan nəsanəniən tɨkə o naskəlɨmiən in. ");
INSERT INTO tnp_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tefɨt təməni lanəha e Iesu aupən məmə, ‘Nian rəfin iəkəhrun məmə Iərmənɨg tətatɨg itɨmlau min. Ko iəsəgɨniən mətəu-inu tətatɨg e nɨkalɨk itɨmlau mɨn. ");
INSERT INTO tnp_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kəni tol lanəha, iəu nɨkik tətagiən pɨk, mətəni-vivi ik e nohlɨk. Kəni nɨkik təməlinu mətəu iəkəhrun məmə Uhgɨn otosmiəgəh nɨpətɨk. ");
INSERT INTO tnp_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kəni ko nəsəpəhiən narmək otətatɨg ima nətəm kəmohmɨs ikɨn. Kəni ko nəsegəhan mɨniən nɨpətɨ rəham Iətəmimi Əhruahru məmə otəmnəmɨt. ");
INSERT INTO tnp_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ik nəməgətun rəkɨs suaru rəha nəmiəgəhiən kəm iəu, kəni ik onəkol iəu nɨkik tətagiən pɨk nian iətatɨg kilau mɨn ik.’ Inu nəghatiən Tefɨt təməni e Iesu aupən. ");
INSERT INTO tnp_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Piak mɨn. Iəkolkeikei məmə iəkəni nati əhruahru kəm təmah. Iauəhli u kəha rəhatah aupən, Kig Tefɨt, in təmɨmɨs rəkɨs, kəni kəmɨtənɨm, kəni rəhan suvət tətatɨg imatah ikɨn mətəuarus=pa u rəueiu. ");
INSERT INTO tnp_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Mətəu in iəni kəti rəha Uhgɨn, kəni in təhrun məmə Uhgɨn təmos nonauvɨl kəti kəm in məniəkɨs nəghatiən kəti kəm in məmə iətəmi kəti e nɨra rəhan otuərisɨg lan otəkeikei mol Kig. ");
INSERT INTO tnp_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Kig təmafu məmə nati u otəkeikei muva mol nɨpəhriəniən lan. Kəni in təməni məmə Krɨsto əha, iətəm Uhgɨn təməni məmə otahli=pa, Uhgɨn otol təmiəgəh mɨn e nɨmɨsiən, kəni otəsəpəhiən narmɨn tətatɨg ima nətəm kəmohmɨs ikɨn, kəni nɨpətɨn ko təsəmnəmɨtiən. ");
INSERT INTO tnp_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Kəni nəghatiən u tətəghati e Iesu u Uhgɨn təmol rəkɨs təmiəgəh mɨn e nɨmɨsiən. !Kəni itɨmah iəmoteh e nəhmtɨtɨmah! ");
INSERT INTO tnp_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Iesu, rəhan tatə təmos in məri muvən e nɨkalɨn maru ikɨn, imə nɨsiaiən mɨne nəsanəniən. Kəni təhmen=pən əmə məmə Uhgɨn təməni rəkɨs lan aupən, in təməfən Narmɨn rəhan kəm Iesu məmə Iesu otəfən kəm rəhan mɨn. Kəni natimnati mɨn u, nauteruh, məutətəu, Narmɨn Rəha Uhgɨn tatol. ");
INSERT INTO tnp_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kig Tefɨt təməsuvəniən e Negəu e Neai təhmen e Iesu. Kəni Tefɨt təməsəghati aruiən lan nian in təməni nəghatiən mɨn əha məmə, ‘Iərmənɨg. Ik Iərmənɨg rəhak. Uhgɨn Iərmənɨg təni kəm ik məmə, “Əharəg e nɨkalɨk maru, ikɨn imə nɨsiaiən mɨne nəsanəniən, mətəhtahnin. ");
INSERT INTO tnp_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Oiəkol rəham mɨn tɨkɨmɨr mɨn məmə okotəhmen e nɨməulul iətəm natevɨg-ərain e nɨftəni, kəni ik onəkarmənɨg e lah.” ’ ");
INSERT INTO tnp_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Pəh nətəm Isrel rəfin kotəkeikei motəhrun vivi məmə Iesu əha iətəm itəmah nəmotətu-pəri e nɨgi kəməluau, inəha, Uhgɨn təmol məmə in Iərmənɨg mɨne Krɨsto — u iətəm Uhgɨn təməni məmə otahli=pa.” ");
INSERT INTO tnp_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nəghatiən u rəha Pitə təmek pəhriən nɨkilah kəni nɨkilah təpəou. Kəni kəmotətapuəh o Pitə mɨne aposɨl mɨn rəfin məmə, “Piatɨmah mɨn. ?Oiəkotəhro lanu?” ");
INSERT INTO tnp_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Kəni Pitə təməni=pən kəm lah məmə, “Onəkotəkeikei motəuhlin nətəlɨgiən rəhatəmah, kəni kol bəptais e təmah rəfin kətiəh kətiəh e nərgɨ Iesu Krɨsto, məmə Uhgɨn otafəl rəkɨs noliən tərah mɨn rəhatəmah. Kəni Uhgɨn otəfɨnə Narmɨn u kəm təmah, ");
INSERT INTO tnp_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","mətəu Uhgɨn təməni rəkɨs nəghatiən u o təmah, mɨne nenətɨtəmah mɨn, mɨne namipɨtəmah mɨn iətəm okəpanəhuva. Nəniəskasɨkiən u tətatɨg o nətəmimi rəfin mɨn u iətəm Iərmənɨg Uhgɨn rəhatah tətauɨn e lah.” ");
INSERT INTO tnp_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kəni Pitə təməni nəghatiən təuvɨr tepət məmə otiuvi=pa ilah kəhuva, kəni mətəni kəm lah məmə, “O nəkohiet rəkɨs e nətəmi mɨn u, nəpiəh mɨne u nətəm kotərah məmə, Uhgɨn otəsoliən nalpɨniən kəm təmah min ilah.” ");
INSERT INTO tnp_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Kəni ilah tepət u kəmotətəu nəghatiən rəha Pitə kəmotəni nɨpəhriəniən lan, kəni kəmol bəptais e lah. E nian əha, nətəmimi tepət təhmen e tri-tausɨn kəməhuva məhuərisɨg e lah u kəutəhatətə e Iesu. ");
INSERT INTO tnp_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nian rəfin nətəmimi mɨn u kəutəni nɨpəhriəniən e Iesu, kəutətəlɨg e nəghatiən iətəm aposɨl mɨn kəutəgətun ilah lan. E naliuəkiən rəhalah kəməhuva kətiəh, e nauəniən mɨne Nauəniən Rəha Nəmtətiən Rəha Iesu, mɨne nəfakiən. Kəni nian rəfin nɨkilah tətəskasɨk məmə okotəkeikei mautol nati əha. ");
INSERT INTO tnp_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Aposɨl mɨn kəmautol nati apɨspɨs mɨne nəmtətiən pɨsɨn pɨsɨn mɨn e nəsanəniən rəha Uhgɨn. Kəni nətəmimi narmɨlah tatiuvɨg pɨk ohni. ");
INSERT INTO tnp_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nətəmimi mɨn u kəutəhatətə e Iesu, nian rəfin kəutəhuva kətiəh məutəfən rəhalah mɨn natimnati kəm lah mɨn; ");
INSERT INTO tnp_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","kəmə iətəmi kəti rəhan nati kəti tɨkə, kəni kəti təfən rəhan natimnati mos məni lan, kəni məuəri mətuati kəni masiru lan. ");
INSERT INTO tnp_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nian rəfin kəutəhuvən məutəfaki pəti e Nimə Rəha Uhgɨn. Kəni kəmautəhuvən e nimə pɨsɨn pɨsɨn mɨn məutəuəri nauəniən nɨglah e nagiəniən mɨne nɨkilah pəhriən, kəni kəməutauən mɨn e Nauəniən Rəha Nəmtətiən Rəha Iesu. ");
INSERT INTO tnp_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Kəni nian rəfin kəutəni-vivi Uhgɨn, kəni nətəmimi kəutəni-vivi ilah o rəhalah noliən. Kəni nian rəfin Iərmənɨg tatosmiəgəh nətəmimi, kəni ilah kəməutəhuva kətiəh ilah nətəm kəutəhatətə e Iesu. ");
INSERT INTO tnp_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nian kəti e tri klok ləhnaiuv, nian rəha nəfakiən, Pitə mɨne Jon kəmualiuək mətian e Nimə Rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Suah kəti iətəm təsaliuəkiən e nian təmair mətəuarus=pa nian əha, kəmələs kəhuva kaharu e namtɨhluə e Nimə Rəha Uhgɨn u kətəni məmə Namtɨhluə Təuvɨr. Nian rəfin təteasiə e məni o nətəmimi kəutəhuvən imə. ");
INSERT INTO tnp_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nian təmeruh Pitə mɨne Jon kɨnətian məmə okia imə, in təmətapuəh o lau məmə okuəfən məni kəti kəm in. ");
INSERT INTO tnp_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Kəni Pitə mɨne Jon nəhmtɨlau təməhtul lan. Kəni Pitə təni məmə, “Əsal=pa meh itɨmlau.” ");
INSERT INTO tnp_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kəni təməsal=pən meruh ilau, nɨkin təhti məmə otos məni kəti o lau. ");
INSERT INTO tnp_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Mətəu Pitə təməni=pən kəm in məmə, “Rəhak məni tɨkə agɨn. Mətəu nati iətəm iəu iətos, iəkəfɨnə kəm ik. !E nərgɨ Iesu Krɨsto iətəm Nasərɨt, iətəni=pɨnə kəm ik, əhtul maliuək!” ");
INSERT INTO tnp_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kəni in təmasiru lan, mos nəhlmɨn maru miuvi-pəri məmə otəhtul. Kəni əmeiko rəueiu agɨn mɨn nəhlkɨn mil kəmuəhruahru. ");
INSERT INTO tnp_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Əmeiko təmətu-pəri məhtul mɨnətaliuək, mətɨtəu=pən ilau mɨhluvən e Nimə Rəha Uhgɨn, kəni mɨnətaliuək matiuvɨg-iuvɨg-pəri mətəni-vivi Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Kəni nətəmimi rəfin kəmoteruh in tətaliuək mətəni-vivi Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ilah kɨnotəhrun məmə suah əpələ inəha u iətəm təteasiə o məni nian rəfin e namtɨhluə rəha Nimə Rəha Uhgɨn, kəni kəmotauɨt pɨk, narmɨlah təmiuvɨg o suah kəha mətəu-inu nəhlkɨn tɨnəuvɨr. ");
INSERT INTO tnp_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nian təmətəhkul=pən e Pitə mɨne Jon, nətəmimi rəfin narmɨlah təmiuvɨg ohni, kotaiu məhuva məmə okotafu e lahal əha nəuvetɨn kəti e Nimə Rəha Uhgɨn u kətəni məmə Fərantə rəha Kig Solomən. ");
INSERT INTO tnp_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nian Pitə təmeruh ilah, kəni təni=pən kəm lah məmə, “Nətəm Isrel. ?Təhro narmɨtəmah tatiuvɨg pɨk o nati apɨspɨs u? ?Nauteruh itɨmahal nɨkitəmah təhti məmə itɨmlau iətəmi asim mil keiu iəmol vi suah u e nəsanəniən əmə rəhatɨmlau? !Kəpə! ");
INSERT INTO tnp_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nati apɨspɨs u iətəm nəmoteruh, Uhgɨn rəha Epraham, mɨne Aisək, mɨne Jekəp, mɨne tɨpɨtah mɨn rəfin, in təməfəri nərgɨ rəhan ioluək lan, Iesu. Inu iətəmi kətiəh əmə Iesu u nəmotəfən məmə otuvən o nətəmi asoli rəha kəpmən məmə ilah okotuhamu, kəni nati əpnapɨn Pailət təməni rəkɨs məmə okəsuhamuiən okəhlman lan, mətəu itəmah nəmotəni=pən kəm Pailət məmə kəpə, kəni motəpəh in. ");
INSERT INTO tnp_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Itəmah nəmotəpəh Iesu u in iol əhruahru mɨne iətəm təuvɨr e nəhmtɨ Uhgɨn, kəni nəmotətapuəh o Pailət məmə otəhlman e suah kəha iohamu itəmi. ");
INSERT INTO tnp_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kəni e noliən əha, itəmah nəmotuhamu Iesu, iətəm nəmiəgəhiən rəfin tatsɨpən ohni. Mətəu Uhgɨn təmol təmiəgəh mɨn e nɨmɨsiən. Kəni itɨmah iəmoteruh e nəhmtɨtɨmah məmə nɨpəhriən. ");
INSERT INTO tnp_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","“Suah u iətəmi itəmah nauteruh motəhrun, in təməsanən əmə mətəu-inu itɨmah iəutəhatətə e Iesu mɨne nəsanəniən rəhan. In nəsanəniən rəha Iesu mɨne nəhatətəiən iətəm təməfa kəm tɨmah təmol vi suah u, kəni itəmah rəfin nəmoteruh. ");
INSERT INTO tnp_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Piak mɨn. Iəu iəkəhrun məmə nati u nəmotol e Iesu itəmah rəhatəmah nətəmi asoli mɨn, itəmah rəfin nəmotol mətəu-inu nəsotəhruniən məmə Iesu in pəh. ");
INSERT INTO tnp_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Mətəu suaru u inu rəha Uhgɨn o noliən rəhan nəghatiən u in təməni aupən, tɨnuva mɨnol nɨpəhriəniən lan. E nəghatiən rəha iəni mɨn rəhan, in təməni rəkɨs məmə rəhan Krɨsto iətəm təməni rəkɨs aupən məmə otahli=pa, in otəkeikei mətəu nahməiən e nɨpətɨn. ");
INSERT INTO tnp_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Intəh, rəueiu əha, onəkotəkeikei motəuhlin itəmah e rəhatəmah noliən tərah mɨn, kəni motohtəlɨg=pa o Uhgɨn məmə in otafəl rəhatəmah noliən tərah mɨn, kəni məmə Iərmənɨg Uhgɨn otəfɨnə nəmeigiən mɨne nəsanəniən vi e nəmiəgəhiən rəhatəmah, ");
INSERT INTO tnp_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","kəni məmə in otahli=pa Krɨsto tɨtəlɨg=pa mɨn, iətəmi iətəm Uhgɨn təməni rəkɨs aupən. Krɨsto u iətəghati lan, in Iesu. ");
INSERT INTO tnp_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Mətəu Iesu otatɨg pɨpɨm e Negəu e Neai mətəuarus Uhgɨn otol vi mɨn natimnati rəfin təhmen=pən e itəmi Uhgɨn təməni əskasɨk kəm təmah, iətəm rəhan mɨn iəni mɨn aupən agɨn kəmotəni pətɨgəm. ");
INSERT INTO tnp_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Kəni iəni asoli Mosɨs təməni pətɨgəm məmə, ‘Iərmənɨg Uhgɨn otəfəri iəni kəti mɨn e təmah təhmen lak. Onakotəkeikei məutətəlɨg e natimnati mɨn rəfin in otəni kəm təmah mautol nəuian. ");
INSERT INTO tnp_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nətəmi mɨn u okotəhti nəuia iəni əha, Uhgɨn otos rəkɨs ilah o rəhan mɨn nətəmimi kəni ilah okohmɨs.’ ");
INSERT INTO tnp_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Kəni iəni mɨn rəfin kəmotəni əmə nəghatiən kətiəh, təmətuəuin e iəni u Samuel, muva mətəuarus=pa u rəueiu, kəutəni əhanəh nian əha u rəueiu. ");
INSERT INTO tnp_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","“Nəniəskasɨkiən u iətəm Uhgɨn təməni=pən kəm rəhan iəni mɨn aupən, in rəhatəmah. Kəni nəniəskasɨkiən rəha nasiruiən iətəm Uhgɨn təməni kəm tɨpɨtəmah mɨn aupən, in rəhatəmah mɨn, mətəu-inu Uhgɨn təməni=pən kəm Epraham məmə, ‘Oiəkol təuvɨr kəm nətəmimi rəfin e nɨftəni, kəni nati kəti iətəm mipɨm Iosmiəgəh otol, otəfən nəuvɨriən əha kəm nətəmimi ərəfin.’ ");
INSERT INTO tnp_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nian Uhgɨn təməfəri rəhan ioluək u Iesu Iosmiəgəh, təmaupən mahli=pɨnə kəm təmah məmə in otəuhlin itəmah e rəhatəmah noliən tərah mɨn, kəni e noliən əha, in otol təuvɨr kəm təmah.” ");
INSERT INTO tnp_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Nian Pitə mɨne Jon kəmətuəghati əhanəh kəm nətəmimi, kəni pris mɨn, mɨne iətəmi tətarmənɨg e soldiə mɨn u kəutəsal o Nimə Rəha Uhgɨn, mɨne Satusi mɨn, kəmohietɨgəm=pa. ");
INSERT INTO tnp_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nɨkilah təmahmə pɨk mətəu-inu ilau kətuəgətun nətəmimi məmə Iesu təmɨmɨs kəni məmiəgəh mɨn. Kəni inu təmol suaru məmə nətəmi mɨn u kəmohmɨs, Uhgɨn otosmiəgəh mɨn ilah. ");
INSERT INTO tnp_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kəni kəmotaskəlɨm ilau, motləfən əmə ilau e kaləpus mətəu tɨnapinəpu rəkɨs, məmə ilau okuəməhli ikɨn lapɨn, kəni olauɨg lan kəmanuəhtul e kot. ");
INSERT INTO tnp_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mətəu nətəmimi mɨn tepət nian kəmotətəu nəghatiən kəmuəni kəmotəni nɨpəhriəniən lan. Kəni nətəmimi rəfin u kəmotəni nɨpəhriəniən e Iesu, nəman əmə ilah iuəkɨr təhmen e faif-tausɨn. ");
INSERT INTO tnp_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kəməni lauɨg lan, pris mɨn nəuvein, mɨne nətəmi asoli rəha Isrel mɨn, mɨne nəgətun mɨn rəha Lou rəha Mosɨs, kəmotuhapumɨn ilah mɨn əpəha Jerusɨləm. ");
INSERT INTO tnp_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kəmotəharəg ilah Anəs u pris asoli agɨn, mɨne Kaiəfəs, mɨne Jon, mɨne Aleksantə, mɨne nətəmimi mɨn nəuvein e nəhlin rəha suah u pris asoli agɨn, kəmotəharəg e kaunsɨl. ");
INSERT INTO tnp_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Motəni Pitə mɨne Jon kian muəhtul aupən e lah, kəni kotətapuəh o lau məmə, “?Pəh təməfɨnə nepətiən kəm təlau megəhan e təlau məmə natuol nati u, uə nəmuol e nərgɨ pəh?” ");
INSERT INTO tnp_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Kəni Narmɨn Rəha Uhgɨn təməriauəh e nɨki Pitə, kəni Pitə təni=pən kəm lah məmə, “Itəmah u nətəmi nəutarmənɨg e nətəm Isrel, mɨne nətəmi asoli mɨn. ");
INSERT INTO tnp_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Itəmah nəutəsal lan=pa o tɨmlau məmə suah u iətəm nəhlkɨn təmərah təmos iə nəuvɨriən, uə itɨmlau iəmuəhro lanu muol vivi nəhlkɨn. ");
INSERT INTO tnp_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Itəmah rəfin u ikɨnu mɨne nətəm Isrel mɨn rəfin, onəkotəkeikei motəhrun məmə suah u iətəm nəhlkɨn tɨnəuvɨr rəkɨs tətəhtul aupən e təmah e nəsanəniən əmə e nərgɨ Iesu Krɨsto, iətəm Nasərɨt. Suah kəha inəha, itəmah nəmotətu-pəri e nɨgi kəməluau, in təmɨmɨs. Mətəu Uhgɨn təmol təmiəgəh mɨn. ");
INSERT INTO tnp_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Suah kəha inəha, iətəm Nauəuə Rəha Uhgɨn təməni lan məmə, ‘Kəpiel u iətəm itəmah nətəmimi rəha noliən nimə, nəkotəni məmə tərah kəni motəraki lan, mətəu rəueiu in tɨnuva kəpiel təuvɨr agɨn iətəm nimə təhtul-pəri lan.’ ");
INSERT INTO tnp_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Suah kətiəh əmə təhrun nosmiəgəhiən nətəmimi, Iesu pɨsɨn əmə, kəni iətəmimi kəti mɨn tɨkə agɨn e nɨftəni təhrun nosmiəgəhiən nətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nətəmi asoli rəha kaunsɨl kəmotauɨt pɨk nian kəmoteruh məmə kəsuəgɨniən e lah, nati əpnapɨn kəsuoliən skul, ilau iətəmimi mil əmə. Kəmotəhrun əhruahru məmə suah mil əha ilah pəhriən Iesu kəməutaliuək məutan. ");
INSERT INTO tnp_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kəni kɨnotəruru nuhalpɨniən nəghatiən rəhalau mətəu-inu suah u nəhlkɨn tɨnəuvɨr rəkɨs ilahal min ilau. ");
INSERT INTO tnp_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kəni kəmotəni=pən kəm lahal məmə okɨhliet mɨhluvən ihluə pəh ilah əmə kotəghati pɨpɨm. ");
INSERT INTO tnp_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Kəni ilah kəmotətapuəh o lah mɨn məmə, “?Okotəhro e suah mil əha? Nətəmimi rəfin u Jerusɨləm kɨnotəhrun rəkɨs məmə nati apɨspɨs u kəmuol e suah u, in iahgin pɨk, ko kəsəniapɨniən lan. ");
INSERT INTO tnp_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mətəu pəh kotəniəhu əskasɨk ilau məmə okəsuəni pətɨgəm mɨniən nərgɨ Iesu kəm nətəmimi, kəni nəghatiən e nati apɨspɨs əha otəsiet mɨniən nətəmimi kotətəu.” ");
INSERT INTO tnp_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kəni kəmotauɨn e lahal kɨhluva imə, kəni motəni=pən kəm Pitə mɨne Jon məmə okəsuəni pətɨgəm mɨniən nərgɨ Iesu, kəni məsuəgətun mɨniən nətəmimi lan. ");
INSERT INTO tnp_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Mətəu ilau kəmuəni=pən kəm lah məmə, “Itəmah əmə otakil məmə təhruahru e nəhmtɨ Uhgɨn məmə iəkuol nəuiatəmah uə nəuia Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mətəu itɨmlau ko iəsuakɨmiən nohlɨtɨmalau. Oiəkuəkeikei muəni pətɨgəm nati itɨmlau iəmueruh e nəhmtɨtɨmlau kəni muətəu e nɨpəgtəlgɨtɨmlau.” ");
INSERT INTO tnp_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kəni kaunsɨl təməni=pən mɨn kəm Pitə mɨne Jon məmə ilah okotol nalpɨniən kəti kəm lau nəmə ilau okətuəkeikei mətuəni pətɨgəm Iesu kəm nətəmimi, kəni motahli pətɨgəm ilau. Kəmotahli pətɨgəm ilau mətəu-inu kɨnotəruru məmə okotoh əhro ilau. Kəmotəhrun məmə nətəmimi nɨkilah otahmə nəmə ilah okotol nalpɨniən kəm lau, mətəu-inu nətəmimi rəfin kɨnəutəni-vivi Uhgɨn o nati apɨspɨs u Uhgɨn təmol e iətəm u. ");
INSERT INTO tnp_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kəni suah u, nəhlkɨn təməpaiu nian təmair mətəuarus=pa əha rəueiu, kəni rəhan nu tapirəkɨs fote. ");
INSERT INTO tnp_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nian nətəmi asoli rəha kaunsɨl kəmotegəhan e Pitə mɨne Jon məmə okətian, kəmiaiet uəhai əmə mian əpəha nətəm kəutəhatətə e Iesu kəutatɨg ikɨn, kəni muəni pətɨgəm rəfin nəghatiən iətəm pris asoli mɨn mɨne nətəmi asoli rəha kaunsɨl kəmotəni=pən kəm lau. ");
INSERT INTO tnp_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nian kəmotətəu nəghatiən əha, ilah rəfin kəməhuva kətiəh motəfaki=pən kəm Uhgɨn, məutəni məmə, “Iərmənɨg Uhgɨn Asoli, ik nəmol neai, mɨne nɨftəni, mɨne nɨtəhi, mɨne natimnati ərəfin e lah. ");
INSERT INTO tnp_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ik nəməghati e nəsanəniən rəha Narmɨn rəham kəm tɨpɨtɨmah u aupən Kig Tefɨt, u in rəham ioluək, kəni in təməni pətɨgəm rəham nəghatiən məmə, ‘?Təhro nətəmimi e nɨtəni pɨsɨn pɨsɨn mɨn nɨkilah tətahmə pɨk lanəha? Təhro ilah nɨkilah tətəhti məmə okotol nərahiən mɨn əha. Ko kotol pau ko kəsotoliən nati kəti. ");
INSERT INTO tnp_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nətəm kəutarmənɨg e nɨtəni mɨn, kəmotol əpenə-penə o nəluagɨniən, kəni nətəmi asoli mɨn kəutəhuva pəti-pəti, məmə kotəluagɨn ilah Iərmənɨg Uhgɨn mɨne Iosmiəgəh iətəm in təməni rəkɨs.’ ");
INSERT INTO tnp_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Iərmənɨg Uhgɨn, in nɨpəhriəniən nəghatiən iətəm Kig Tefɨt təməni, tɨnuva mɨniet=pa, mətəu-inu Kig Herot Antipas, mɨne Pontiəs Pailət, mɨne nətəm Isrel, mɨne Nanihluə mɨn, ilah rəfin kəməhuva kətiəh u ikɨnu lahuənu Jerusɨləm, məutətei nəghatiən ekəu-ekəu məmə okotuhamu Iesu, u in rəham ioluək əhruahru u ik nəmɨtəpɨn. ");
INSERT INTO tnp_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Mətəu natimnati rəfin iətəm kəmautol təmɨtəu=pən əmə rəham nəghatiən iətəm ik nəməni rəkɨs e nəsanəniən mɨne nəhruniən rəham aupən. ");
INSERT INTO tnp_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Tol lanəha, Iərmənɨg, nɨkim tətəhti nəghatiən iətəm ilah kəmotəni məmə okotoh itɨmah, ol itɨmah rəham noluək mɨn məmə iəsotəgɨniən məmə iəkotəni pətɨgəm rəham nəghatiən. ");
INSERT INTO tnp_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Uahru=pa e nəhlməm əsanən məmə otol vi nətəmi kəutohmɨs, kəni mol nati apɨspɨs mɨn mɨne nəmtətiən pɨsɨn pɨsɨn mɨn e nərgɨ Iesu, rəham ioluək əhruahru.” ");
INSERT INTO tnp_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nian kəmotəfaki rəkɨs, kəni nimə təmarɨgrɨg, kəni Narmɨn Rəha Uhgɨn təmuva məriauəh mətatɨg e lah rəfin, kəni kɨnautəni pətɨgəm nəghatiən rəha Uhgɨn məsotəgɨniən. ");
INSERT INTO tnp_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nətəmi kəutəni nɨpəhriəniən e Iesu rəhalah nətəlɨgiən təmuva kətiəh. Kəti təməsəhluaigiən e rəhan nautə, mətəu kəmautəuəri nautə rəhalah kəm lah mɨn. ");
INSERT INTO tnp_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kəni aposɨl mɨn kəmotos nəsanəniən e Narmɨn Rəha Uhgɨn kəni məutəni pətɨgəm məmə Iərmənɨg Iesu təməmiəgəh mɨn e nɨmɨsiən. Kəni e nəuvɨriən rəha Uhgɨn, in tətasiru e lah rəfin nətəm kəutəfaki. ");
INSERT INTO tnp_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kəni ilah kəti, rəhan kəti nati kəti təməsɨkəiən, mətəu-inu nətəmimi nəuvein nətəm rəhalah nɨftəni uə nimə tatɨg, kəmotol səlɨm lan, kəni motəfən məni kəm aposɨl mɨn, ");
INSERT INTO tnp_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","kəni ilah kəmotəuəri kəm nətəmi mɨn u rəhalah nati kəti tɨkə. ");
INSERT INTO tnp_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tol lanəha, suah kəti əha ikɨn nərgɨn u Josɨp, in nəuanɨləuɨs rəha Lifai, iətəm Saiprəs, aposɨl mɨn kəmotəfən nərgɨn vi kəti kəm in, nərgɨn u Panəpəs, u nɨpətɨn təni məmə, “iətəm tətasiru mətəfəri nətəlɨgiən.” ");
INSERT INTO tnp_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","In təmol səlɨm e rəhan kəti nɨftəni, kəni mos məni lan muvən məfən kəm aposɨl mɨn məmə ilah okotəuəri kəm lah mɨn. ");
INSERT INTO tnp_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Mətəu suah kəti mɨn əha ikɨn, nərgɨn u Anənaiəs, mɨne rəhan pətan nərgɨn u Səfairə. Ilau mɨn kəmos məni e nɨftəni kəti rəhalau. ");
INSERT INTO tnp_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","In təmaskəlɨm oneuən məni nəuvetɨn, kəni rəhan pətan əmə təhrun. Kəni mos əmə nɨpɨlgan muvən məfən kəm aposɨl mɨn məmə məni rəfin rəha nɨftəni. ");
INSERT INTO tnp_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Mətəu Pitə təməni=pən kəm in məmə, “Anənaiəs. ?Təhro nətegəhan e iərmɨs u Setən tətuva e nɨkim? Nəteiuə e Narmɨn Rəha Uhgɨn kəni mətaskəlɨm nɨpɨlga məni nəuvetɨn rəha nɨftəni məmə rəham. ");
INSERT INTO tnp_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Uərisɨg nəmol səlɨm e nɨftəni u, in rəham pɨsɨn əmə. Kəni nian nəmol səlɨm rəkɨs lan, rəham pɨsɨn əmə məni. ?Təhro natol lanəha? !Ik nəseiuəiən e iətəmimi mətəu nəteiuə e Uhgɨn!” ");
INSERT INTO tnp_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nian Anənaiəs təmətəu nəghatiən əha, əmeiko mɨsɨpəri morin rəhan nehagiən tiet. Kəni nətəmimi mɨn əha kəmotətəu nati əha, kəmotəgɨn motərəmrumɨn. ");
INSERT INTO tnp_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Kəni nətəm aluə mɨn kəməhuva motəuveg nɨpətɨn motələs mohiet məhuvən mohtənɨm. ");
INSERT INTO tnp_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Iuəkɨr auə kɨsɨl təmuva muvən rəkɨs, kəni rəhan pətan Səfairə təmiet=pa məruru məmə rəhan iərman tɨnɨmɨs rəkɨs. ");
INSERT INTO tnp_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Kəni Pitə təmətapuəh ohni məmə, “?Əni-to kəm iəu məmə məni rəfin əha e nɨftəni rəhatəlau iətəm kəmos nəhmtɨn?” Kəni in təməni məmə, “Əuəh. Nəhmtɨn rəfin u.” ");
INSERT INTO tnp_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kəni Pitə təməni=pən kəm in məmə, “?Təhro nəmuol oneuən nətəlɨgiən kəti məmə nəkueiuə e Narmɨn Rəha Iərmənɨg məmə ko təsəhruniən nati u nəmuol? !Ətəu-to! Nətəm kəmohtənɨm rəham iərman, ilah u e namtɨhluə kəutəhuva məmə okotələs mɨn ik.” ");
INSERT INTO tnp_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Kəni əmeiko tɨsɨpəri mɨn morin=pən əpəha e nəhlkɨ Pitə ikɨn, nehagiən rəhan tiet kəni tɨmɨs. Nian nətəm aluə mɨn kəməhuva imə, moteruh nɨmɨs rəkɨs, kəni kotələs mohiet məhuvən mohtənɨm e nɨkalɨ rəhan iərman. ");
INSERT INTO tnp_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nian nətəmimi rəha nəfakiən mɨne nətəmi əpnapɨn kəmotətəu nati əha, kəmotəgɨn pɨk. ");
INSERT INTO tnp_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Kəni aposɨl mɨn kəmotol nəmtətiən tepət mɨne nati apɨspɨs mɨn e nəhmtɨ nətəmimi. Kəni nətəmimi mɨn u kəutəni nɨpəhriəniən e Iesu kəməhuva kətiəh əmə e Fərantə rəha Kig Solomən e Nimə Rəha Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nati əpnapɨn nətəmimi mɨn u kəsotəniən nɨpəhriəniən e Iesu kəmotɨsiai ilah, mətəu kəmotəgɨn e nuvəniən əha meruh ilah. ");
INSERT INTO tnp_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Mətəu nian rəfin nətəmimi tepət kəutəhuva məutəni nɨpəhriəniən e Iərmənɨg Iesu, nəman mɨne nɨpətan, kəni ilah tatepət. ");
INSERT INTO tnp_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Mətəu-inu e nati apɨspɨs mɨn iətəm aposɨl mɨn kəmautol, nətəmimi mɨn kautos rəhalah mɨn nɨmɨsiən məutəhuva, kəni məutəlɨn ilah kəutapɨli e rəhalah pet mɨne nɨmahan e suaru məmə nian Pitə otaliuək mapikalɨn e lah, in otek nəuvein, uə nəmə nənɨpɨsiən rəhan əmə tos nəuvein məmə okotəmiəgəh. ");
INSERT INTO tnp_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Kəni nətəmimi tepət tepət kəmotsɨpən lahuənu mɨn iuəkɨr o Jerusɨləm məhuva. Motos rəhalah mɨn nətəm kautohmɨs mɨne nətəmi mɨn u narmɨn tərah tətatɨg e lah məhuva, kəni aposɨl mɨn kəmotəfaki e lah kəni ilah rəfin kotəuvɨr. ");
INSERT INTO tnp_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kəni suah u pris asoli agɨn mɨne rəhan mɨn nətəmimi Satusi mɨn u, ilah e pati kətiəh, niəməha təmol pɨk ilah mətəu-inu nətəmimi tepət kɨnəutəpəh ilah mɨnautəhuvən o aposɨl mɨn. ");
INSERT INTO tnp_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Kəni kəmotauɨt motaskəlɨm aposɨl mɨn motəmki=pən ilah e kaləpus. ");
INSERT INTO tnp_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Mətəu lapɨn lan, agelo kəti rəha Iərmənɨg təmuva merəh e doə e kaləpus mit ilah mohiet. ");
INSERT INTO tnp_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Kəni məni=pən kəm lah məmə, “Əhuvən e Nimə Rəha Uhgɨn motəni pətɨgəm nəghatiən pəhriən rəha nəmiəgəhiən vi u kəm nətəmimi.” ");
INSERT INTO tnp_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Kəni kəməni lauɨg lan, kəmotol nəuia agelo kəni mautəhuvən e Nimə Rəha Uhgɨn mɨnautəni pətɨgəm nərgɨ Iesu kəm nətəmimi. Kəni pris asoli agɨn mɨne rəhan mɨn, kəsotəhrun əhanəhiən məmə ilau kəmiaiet rəkɨs e kaləpus, kəni kəmotauɨn e nətəmi asoli mɨn rəha nətəm Isrel, kəni ilah kəməhuva kətiəh məmə ilah okotəharəg e kaunsɨl asoli rəha Isrel. Kəni motahli=pən nəghatiən kəm nətəm kəutarmənɨg e kaləpus məmə okotahli=pa aposɨl mɨn kəhuva e kot əpəha e kaunsɨl. ");
INSERT INTO tnp_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Mətəu nian soldiə mɨn kəməhuvən e kaləpus, mətəu aposɨl mɨn kohkə. Kəni kohtəlɨg=pa e kaunsɨl motəni məmə, ");
INSERT INTO tnp_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Nian iəməhuvən e kaləpus, motafu doə tahtɨpəsɨg, lok tətəhkul=pən vi əmə lan, kəni soldiə rəha kaləpus kəutəhtul mauteruh vivi əmə namtɨhluə e kaləpus, mətəu nian iəmoterəh e doə məhuvən imə, mətəu kɨkə-kɨkə əmə imə.” ");
INSERT INTO tnp_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Iətəm tətarmənɨg e soldiə mɨn iətəm kəutəsal o Nimə Rəha Uhgɨn, mɨne pris asoli mɨn kəmotətəu nəghatiən əha, kəni motauɨt pɨk, narmɨ lah təmiuvɨg, mɨnotəruru əpnapɨn əmə məmə nati nak otuva mɨn. ");
INSERT INTO tnp_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kəni əmeiko iətəmimi kəti tietɨgəm=pa məmə, “!Ei, nəman! !Nətəmi mɨn əpələ əpə nəmotəmki=pən ilah e kaləpus, ilah əpəha e Nimə Rəha Uhgɨn kəutəgətun nətəmimi!” ");
INSERT INTO tnp_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kəni iətəm tətarmənɨg e soldiə mɨn təmit mɨn soldiə mɨn rəhan məhuvən motəmki aposɨl mɨn məhuva. Mətəu kəməsoteikəpaniən ilah mətəu-inu kɨnotəgɨn məmə nətəmi əpnapɨn okotəhti ilah e kəpiel apɨn nəmə koteikəpan ilah. ");
INSERT INTO tnp_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nian kəmotit ilah məhuva imə, kəni motəni məmə ilah okotəhtul aupən e nətəmi asoli rəha kaunsɨl. Kəni pris asoli agɨn təməni=pən kəm lah məmə, ");
INSERT INTO tnp_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Iəmotəniəhu əskasɨk agɨn itəmah məmə onəsotəgətuniən nətəmimi e nərgɨ suah kəha Iesu. Mətəu nəgətuniən rəhatəmah tɨnaiu ərəfin əpəha Jerusɨləm. Kəni mautol məmə nətəmimi okotəni məmə itɨmah iəmotoh suah kəha Iesu.” ");
INSERT INTO tnp_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Mətəu Pitə təməghati rəhalah aposɨl mɨn lan məmə, “Itɨmah iəkotəkeikei mautol nəuia Uhgɨn, mətəu səniəmə nəuia nətəmimi əmə. ");
INSERT INTO tnp_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Itəmah nəmotuhamu rəkɨs Iesu motətu-pəri e nɨgi kəməluau, mətəu Uhgɨn u rəha tɨpɨtah mɨn aupən təmol təmiəgəh mɨn e nɨmɨsiən. ");
INSERT INTO tnp_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Uhgɨn u inu təməfəri rəkɨs Iesu məmə otuvən məharəg e nɨkalɨn maru, u ima nɨsiaiən mɨne nəsanəniən, məmə in Iərmənɨg mɨne Iosmiəgəh. Uhgɨn təmol nati əha məmə in otol suaru məmə nətəm Isrel mɨn kotəhrun nəuhliniən ilah e rəhalah noliən tərah mɨn, kəni in otafəl rəkɨs noliən tərah mɨn rəhalah. ");
INSERT INTO tnp_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kəni itɨmah Narmɨn Rəha Uhgɨn iəutəni pətɨgəm natimnati mɨn u, kəni Uhgɨn tətəfən Narmɨn rəhan kəm nətəmimi kautol nəuian.” ");
INSERT INTO tnp_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nian nətəmimi rəha kaunsɨl kəmotətəu nəghatiən əha, təmiuvi pɨk rəhalah niəməha, kəni kotolkeikei məmə okotuhamu əmə ilah. ");
INSERT INTO tnp_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Mətəu suah kəti təməhtul, nərgɨn u Kəmaliel, in Farəsi kəti mɨne iəgətun kəti rəha Lou, u nətəmimi rəfin kəutɨsiai. Kəni təmətapuəh o soldiə mɨn məmə okotit aposɨl mɨn məhuvən ihluə pɨpɨm. ");
INSERT INTO tnp_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kəni in təməni kəm kaunsɨl məmə, “Nətəmimak mɨn, nətəm Isrel. Otatətəlɨg vivi məmə onəkotəhro e nətəmi mɨn u. ");
INSERT INTO tnp_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Vi agɨn uəha suah kəti nərgɨn u Teutas, təmietɨgəm=pa mətəni məmə in iətəmi asoli kəti, kəni iuəkɨr nətəmimi fo-hanrɨt kəmotuərisɨg lan. Mətəu kəmohamu in, kəni rəhan nətəmimi kəmotan kətiəh kətiəh, kəni rəhan nətəlɨgiən təmuvən mɨkə. ");
INSERT INTO tnp_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Uərisɨg lan, nian kəpmən təmatafin nətəmimi, suah kəti mɨn u nərgɨn u Jutəs, iətəm Kaləli, in mɨn təmiuvi nətəmimi kəhuərisɨg lan. Mətəu nətəmimi nəuvein kəmotohamu mɨn, kəni rəhan nətəmimi kəmotan kətiəh kətiəh. ");
INSERT INTO tnp_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kəni inu rəhak nətəlɨgiən e nəniən u. !Iəkəni kəm təmah, pəh nəkotəpəh əmə ilah motegəhan e lah kohiet! Mətəu nəmə nati kautol, in rəha iətəmimi əmə, otəpanɨkə. ");
INSERT INTO tnp_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Mətəu nəmə tatsɨpən o Uhgɨn, ko nəsotosiən nəsanəniən məmə onəkotəniəhu ilah. Məta onəkoteruh məmə itəmah Uhgɨn onəkotərgəhu.” ");
INSERT INTO tnp_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Kəni ilah rəfin kəmotegəhan e rəhan nəghatiən. Kəni kəmotauɨn e aposɨl mɨn məmə okəhuva imə, kəni motəni məmə soldiə mɨn okotalis ilah. Kəni motəniəhu əskasɨk mɨn ilah məmə okəsotəghati mɨniən kəm nətəmimi e nərgɨ Iesu kəni motəhlman e lah kohiet. ");
INSERT INTO tnp_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Kəni aposɨl mɨn kəmohiet e kaunsɨl, nɨkilah təmagiən, mətəu-inu Uhgɨn nɨkin təmepət o lah kəni megəhan e lah məmə nətəmimi okotoh ilah mətəu inko kautəhuərisɨg e Iesu. ");
INSERT INTO tnp_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kəni nian rəfin e Nimə Rəha Uhgɨn mɨne nimə mɨn, ilah kəməsotəpəhiən məutəkeikei məutəni pətɨgəm kəni məutəgətun nəghatiən təuvɨr məmə Iesu in Krɨsto iətəm Uhgɨn təməni məmə otahli=pa. ");
INSERT INTO tnp_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nian nəuvein tɨnuva rəkɨs muvən, kəni nətəmi rəha Iesu tɨnətəri mɨnatepət. Nəuvein ilah nəuanɨləuɨs rəha Isrel kəmotsɨpən ikɨn pɨsɨn pɨsɨn mɨn, kəni məutəni əmə nəghatiən Kris, məsotəniən nəghatiən rəha Isrel. Kəni tepət, ilah nətəm Isrel əmə. Mətəu nəfaki mɨn iətəm kəutəni əmə nəghatiən Kris kɨnəutəni nɨkalɨ nəfaki mɨn u nətəm Isrel, məutəni məmə nian kəutəuəri məni mɨne nauəniən kəm pətalɨmɨs mɨn, mətəu kəsoteh viviən pətalɨmɨs mɨn rəha nətəmi mɨn u kəutəni nəghatiən Kris. ");
INSERT INTO tnp_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kəni tueləf aposɨl mɨn kəmotauɨn e nətəmimi rəha Iesu məmə okəhuva-to. Kəni kəmotəni=pən kəm lah məmə, “Piatɨmah mɨn. Təsəuvɨriən məmə itɨmah iəkotəpəh nəni pətɨgəmiən mɨne nəgətuniən nəghatiən rəha Uhgɨn məmə itɨmah iəkəhuvnə motəuəri məni mɨne nauəniən kəm pətalɨmɨs mɨn. Inu uək rəha dikon mɨn. ");
INSERT INTO tnp_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Mətəu rəueiu, otəfətɨgəm-to itəmah səpɨn, nətəmi mɨn u itəmah nəutɨsiai ilah, kəni motəhrun nati, mɨne Narmɨn Rəha Uhgɨn təriauəh e nəmiəgəhiən rəhalah. Kəni itɨmah iəkotəfən nati u kəm lah məmə ilah okotol. ");
INSERT INTO tnp_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kəni pəh itɨmah oiəkəuteruh əmə nəfakiən kəm Uhgɨn mɨne nəni pətɨgəmiən mɨne nəgətuniən nəghatiən rəha Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Kəni ilah rəfin nɨkilah təmagiən, kəni məutegəhan e nəghatiən əha. Kəni kəmotəfətɨgəm Stipɨn u rəhan nəhatətəiən təskasɨk e Uhgɨn, kəni Narmɨn Rəha Uhgɨn təməriauəh mətatɨg lan. Motəfətɨgəm mɨn Fɨlɨp, mɨne Prokorəs, mɨne Nikano, mɨne Timon, mɨne Pamenəs, mɨne Nikoləs iətəm Antiok u aupən təməpəh nəfakiən rəha nətəm iman ikɨn muva mətɨtəu=pən nəfakiən rəha nətəm Isrel. ");
INSERT INTO tnp_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Kəmotit ilah məhuvən kəm aposɨl mɨn, kəni aposɨl mɨn kəmotələhu=pən nəhlmɨlah e lah motəfaki e lah. ");
INSERT INTO tnp_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Kəni nətəmi rəha Iesu kəutəni pətɨgəm nəghatiən rəha Uhgɨn kəm nətəmimi, kəni nətəmi rəha Iesu u Jerusɨləm kɨnautepət pɨk. E nətəmi mɨn əha, pris mɨn tepət kəmotəhatətə e Iesu. ");
INSERT INTO tnp_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Kəni Stipɨn u iətəm təməriauəh e nəuvɨriən mɨne nəsanəniən rəha Uhgɨn, təmol nəmtətiən tepət mɨne nati apɨspɨs mɨn e nəhmtɨ nətəmimi. ");
INSERT INTO tnp_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Mətəu nətəmimi nəuvein e nimə rəha nuhapumɨniən rəha Nətəm Kəmɨtɨs Ilah, kəmotəghati ilah Stipɨn. Nətəmi mɨn u nətəm Isrel u kəmotsɨpən Saerin mɨne Aleksantriə. Kəni nətəmimi nəuvein mɨn u nətəm Isrel u kəmotsɨpən Sɨlɨsiə mɨne Esiə, ilah kəməhuva kətiəh, mɨnautorgəhu ilah Stipɨn. Kotəni məmə nəghatiən rəha Stipɨn təsəhruahruiən, mətəu rəhalah təhruahru. ");
INSERT INTO tnp_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Mətəu Narmɨn rəha Uhgɨn təmol Stipɨn teinatɨg pɨk, kəni nian in təghati, rəhan nəghatiən tapirəkɨs rəhalah. ");
INSERT INTO tnp_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kəni ilah kəmotəou oneuən nətəmimi nəuvein məmə okotasiru e lah motəni pətɨgəm məmə, “Itɨmah iəmotətəu məmə Stipɨn təməni rah Mosɨs mɨne Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kəni rəhalah nəghatiən təmol nɨki nətəmimi, mɨne nətəmi asoli rəha Isrel, mɨne nəgətun mɨn rəha Lou, kəmotəməki e Stipɨn. Kəni kəməhuvən motaskəlɨm motələs məhuvən məmə otəhtul e nəhmtɨ kaunsɨl. ");
INSERT INTO tnp_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Kəni kəmotəmki nətəmimi nəuvein məhuva məmə okoteiuə e Stipɨn. Nətəmi mɨn u kəmotəni məmə, “Nian rəfin tətəni nəghatiən tərah e Nimə Rəha Uhgɨn, kəni mətəni rah Lou rəha Mosɨs. ");
INSERT INTO tnp_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Itɨmah iəmotətəu in təməni məmə Iesu u iətəm Nasərɨt, in otələs iahu Nimə Rəha Uhgɨn, kəni məuhlin noliən mɨn u Mosɨs təməfa kəm tah aupən ikɨn.” ");
INSERT INTO tnp_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Kəni nətəmimi rəfin u kəmautəharəg e kaunsɨl kəmotəsal=pən əhruahru o Stipɨn, motafu məmə nəhmtɨn tɨnagəhag pəhriən təhmen e rəha agelo. ");
INSERT INTO tnp_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kəni pris asoli agɨn təmətapuəh o Stipɨn məmə, “?Təhro? ?Nɨpəhriəniən e nəghatiən mɨn əha kətətu=pən lam?” ");
INSERT INTO tnp_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Kəni Stipɨn təməni məmə, “Piak mɨn mɨne tatə mɨn. Otətəlɨg-to lak. Uhgɨn u iətəm in ilɨs ilɨs pɨk, təmietɨgəm=pa o tɨpɨtah Epraham nian in təmətatɨg əpəha Mesopotemiə, məsuvən əhanəhiən əpəha Haran. ");
INSERT INTO tnp_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Uhgɨn təməni=pən kəm in məmə, ‘Əpəh rəham mɨn, mɨne ikɨn nətatɨg ikɨn muvən e ikɨn kəti iətəm iəu o iəkəgətun lam.’ ");
INSERT INTO tnp_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Kəni Epraham təmiet əha Kaltiə muvən mətatɨg əpəha Haran. Nian təmətatɨg ikɨnu kəni rəhan tatə tɨmɨs, kəni Uhgɨn təmos muva u e nɨftəni u itəmah nəutatɨg lan rəueiu. ");
INSERT INTO tnp_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Mətəu təməsəfən əhanəhiən nɨftəni əkəku agɨn nəuvetɨn kəm in məmə rəhan əhruahru. Mətəu Uhgɨn təməni əskasɨk kəm in məmə otəpanəfən rəfin nɨtəni əha kəm in mɨne namipɨn mɨn. Kəni nɨtəni u otuva imalah agɨn ikɨn, nati əpnapɨn e nian əha Epraham təməsələsiən nətɨn kəti. ");
INSERT INTO tnp_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nəghatiən u Uhgɨn təməni kəm in tol lanəha, in təməni məmə, ‘O nian kəti, nəuanɨləuɨs mɨn rəham okəhuvən motatɨg e nɨftəni pɨsɨn kəti rəha nətəmimi pɨsɨn, kəni ilah okəhuva iapɨspɨs mɨn, kəni nətəm ikɨn okotol ilah okotəhuva slef mɨn, kəni mautol mɨrə kəm lah kətəuarus nu fo-hanrɨt. ");
INSERT INTO tnp_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Mətəu iəkol nalpɨniən kəm nətəmimi mɨn əha kəutarmənɨg e lah. Kəni uərisɨg, rəham mɨn nətəmimi okohiet e nɨtəni əha məhuva motəfaki kəm iəu e nɨtəni u.’ ");
INSERT INTO tnp_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Kəni Uhgɨn təməni əskasɨk məmə in oteh vivi Epraham mɨne nəuanɨləuɨs mɨn rəhan. Kəni məni=pən kəm in məmə in otəhgi=pən nəsualkələh məmə in nəmtətiən kəti məmə ilah nətəmimi mɨn rəha Uhgɨn. Kəni nian Epraham təmələs Aisək, kəni matɨg məhgi=pən nian təmos nian eit. Kəni nian Aisək təmələs Jekəp, kəni matɨg məhgi=pən mɨn. Kəni nian Jekəp təməmki nenətɨn mɨn ilah tueləf, kəni məhgi=pən mɨn ilah. Ilah tueləf əha, nəukətɨ nɨratah.” ");
INSERT INTO tnp_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Kəni Stipɨn təməni=pən mɨn kəm lah məmə, “Kəni nəukətɨ nɨrə mɨn u rəhatah kəmautetet notəhalah u Josɨp, kəni motətuati=pən lan kəm nətəm Ijɨp, məmə otuva slef rəhalah. Mətəu ilau Uhgɨn e nian rəfin, ");
INSERT INTO tnp_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","kəni Uhgɨn tos rəkɨs in e nərahiən rəfin rəhan. Nian təməhtul e nəhmtɨ kig rəha nətəm Ijɨp, kəni Uhgɨn təməfən nəhruniən kəm in, kəni matɨg mol mɨn məmə kig otolkeikei in, kəni mol in tarmənɨg e nɨtəni Ijɨp mɨne nətəmimi mɨne natimnati rəfin rəhan. ");
INSERT INTO tnp_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Kəni əmeiko nəumɨs təman e nɨtəni əpəha Ijɨp mɨne Kenan mol nauəniən tɨkə, kəni nəumɨs natus nətəmimi, kəni tɨpɨtah mɨn nɨglah nauəniən təmɨkə. ");
INSERT INTO tnp_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nian Jekəp tɨnətəu məmə nauəniən əpəha Ijɨp, təmahli=pən nenətɨn mɨn u tɨpɨtah mɨn əha kəhuvən, kəni inu nətuəuiniən ilah kəməhuvən Ijɨp. ");
INSERT INTO tnp_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kəni uərisɨg, ilah kəməhuvən mɨn, kəni in təməni pətɨgəm in kəm lah, mətəu ilah kəsotəhruniən məmə in Josɨp pialah. Kəni kig rəha Ijɨp təmətəu nəniən o Josɨp mɨne pian mɨn. ");
INSERT INTO tnp_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Kəni Josɨp təmahli=pən nəghatiən kəm rəhan tatə Jekəp mɨne rəhan mɨn, məmə okəhuva motatɨg ilah min. E nətəmimi mɨn əha, ilah rəfin səpɨnte faif. ");
INSERT INTO tnp_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","“Kəni Jekəp mɨne rəhan mɨn kəməhuvən Ijɨp, kəni kəməutatɨg məutatɨg, kəni Jekəp mɨne tɨpɨtah mɨn kəmohmɨs ikɨn. ");
INSERT INTO tnp_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Kəni kəməmki ilah kan əpəha Sekəm e nɨtəni u rəhatah, kəni kɨtənɨm ilah ikɨn e nɨpəg kəpiel kəti Epraham təmos rəkɨs nəhmtɨn o nətəm Hamor.” ");
INSERT INTO tnp_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Kəni Stipɨn təmətəkeikei mətəni=pən kəm lah məmə, “Tɨnatuva iuəkɨr məmə Uhgɨn otosmiəgəh rəhan mɨn nətəmimi u təməni rəkɨs kəm Epraham, kəni nəuanɨləuɨs mɨn rəhatah u kəmautatɨg Ijɨp, rəueiu əha tɨnepət. ");
INSERT INTO tnp_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kəni kig kəti mɨn rəha Ijɨp təməhtul, in təsɨsiai agɨniən Josɨp. ");
INSERT INTO tnp_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","In təmosiahu tɨpɨtah mɨn e nətəlɨgiən tərah mɨn rəhan, matol nahməiən kəm lah. Kəni in təmol lou kəti məmə okotəmki pətɨgəm nenətɨlah mɨn iəpəou amrərə mɨn ihluə məmə okohmɨs. ");
INSERT INTO tnp_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Kəni e nian əha, Mosɨs təmair, kəni in suakəku təuvɨr kəti e nəhmtɨ Uhgɨn. Rəhan mamə mɨne tatə kəmuəhluaig oneuən lan əpəha imə muos məuɨg kɨsɨl. ");
INSERT INTO tnp_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nian kəmləfətɨgəm ihluə, nətɨ kig pətan təmeruh, kəni tələs məmə oteh vivi rəhan. ");
INSERT INTO tnp_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Kəmotəgətun in e neinatɨgiən rəfin rəha nətəm Ijɨp, kəni nian in təmepət, in təsanən e nəghatiən mɨne noliən nati. ");
INSERT INTO tnp_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Nian tɨnos nu fote, nɨkin təhti məmə otuvən-to meruh-to nətəmiman mɨn, nətəm Isrel, ");
INSERT INTO tnp_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","kəni mafu kəti iətəm Ijɨp kəti tatoh. Kəni in təmuvən məmə otasiru e in kəti əmeiko mohamu iətəm Ijɨp əpəha. ");
INSERT INTO tnp_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Kəni Mosɨs nɨkin təməhti məmə məta in mɨn, nətəm Isrel, okotəhrun məmə Uhgɨn təmahli=pən in məmə otuvən məmkirəkɨs ilah e nahməiən katol e lah. Mətəu ilah kotəruru. ");
INSERT INTO tnp_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kəni lauɨg lan tafu mɨn iətəm Isrel mil keiu katuoh ilau mɨn, kəni tuvən mə təghati kəm lau məmə otos rəkɨs ilau, kəni məmə otol ilau kuol vi ilau mɨn. Kəni məni=pən kəm lau məmə, ‘Suah mil, itəlau əmə. ?Təhro natuoh itəlau mɨn?’ ");
INSERT INTO tnp_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Mətəu suah u təmaupən mol nəukətɨ norgəhuiən təmətgi=pən Mosɨs isəu, kəni məni=pən kəm in məmə, ‘?Pəh təməfəri ik məmə onəkarmənɨg kəni mətakil itɨmah? ");
INSERT INTO tnp_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","!Iətəhrun məmə nəkolkeikei məmə onəkohamu mɨn iəu təhmen e iətəm Ijɨp u nəmoh nəniuv!’ ");
INSERT INTO tnp_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nian Mosɨs təmətəu nəghatiən əha, kəni təməgɨn kəni miet Ijɨp magɨm muvən əpəha isəu ikɨn Mitian mətatɨg ikɨn məhmen e iapɨspɨs kəti. Nian təmətatɨg mətatɨg mit pətan ikɨn kəti, kəni mələs nətɨn keiu iərman mil. ");
INSERT INTO tnp_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Nian təmətatɨg Mitian mos nu fote, kəni nian kəti tuvən mətan iuəkɨr o nɨtəuət əha Sainai əpəha təpiə-məpiə ikɨn. Kəni agelo kəti təmiet=pən ohni e nɨgəm iətəm tatuəu e nɨgi əkəku kəti. ");
INSERT INTO tnp_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nian təmeruh nɨgəm əha, narmɨn təmiuvɨg pɨk ohni, kəni muvən iuəkɨr məmə oteruh vivi, kəni mətəu Iərmənɨg Uhgɨn təməghati kəm in məmə, ");
INSERT INTO tnp_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Iəu Uhgɨn rəha tɨpɨm mɨn, Uhgɨn rəha Epraham, mɨne Aisək, mɨne Jekəp.’ Kəni Mosɨs təməgɨn mɨnətərəmrumɨn mɨnatəgɨn e nəsal-pəniən əha nɨgəm ikɨn. ");
INSERT INTO tnp_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Kəni Iərmənɨg Uhgɨn təməni=pən kəm in məmə, ‘Os rəkɨs rəham put e nəhlkəm mətəu-inu nɨftəni ko ik nətəhtul ikɨn in tasim agɨn, mətəu iəu əha ikɨn. ");
INSERT INTO tnp_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Imeruh nərahiən iətəm katol e rəhak nətəmimi əpəha Ijɨp, iəmətəu nasəkiən rəhalah, kəni mɨneiuaiu muva məmə iəkəmkirəkɨs ilah o nətəm Ijɨp. Va. Rəueiu əha iəkahli=pən ik nəkɨtəlɨg muvən mɨn Ijɨp.’” ");
INSERT INTO tnp_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Kəni Stipɨn təmətəkeikei mətəni məmə, “Inu iətəm kətiəh əmə Mosɨs iətəm ilah kəmotəpəh nəuian nian ilah kəmotəni=pən məmə, ‘?Pəh təmləfəri ik məmə onəkarmənɨg kəni makil itɨmah?’ Mətəu Uhgɨn pɨsɨn əmə təmahli=pən suah kəha Mosɨs məmə otarmənɨg kəni mosmiəgəh ilah. Təmahli=pən nian agelo təmiet=pən ohni e nɨgəm iətəm tatuəu e nɨgi əkəku kəti. ");
INSERT INTO tnp_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Kəni Mosɨs təmit ilah mohiet Ijɨp, kəni in təmol nati apɨspɨs mɨne nəmtətiən tepət, təmol əpəha Ijɨp, mɨne nian kəməutaliuək mautəhuvən=pən e nɨtəhi u kətəni məmə Nɨtəhi Ərarəuv, mɨne nu fote e ikɨn təpiə-məpiə ikɨn. ");
INSERT INTO tnp_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Inu iətəm kətiəh əmə Mosɨs u təməni=pən kəm nətəm Isrel məmə, ‘Uhgɨn otləfəri iəni kəti mɨn e təmah təhmen lak.’ ");
INSERT INTO tnp_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","“Inu Mosɨs iətəm təmauɨn e tɨpɨtah mɨn məmə okotuhapumɨn ilah mɨn əpəha təpiə-məpiə ikɨn, kəni agelo təməghati kəm in e Nɨtəuət Sainai, kəni Mosɨs u təməfən nəghatiən mɨn u kəm tɨpɨtah mɨn. Kəni nəghatiən mɨn u, ilah nəghatiən keikei mɨn iətəm kəutəfən nəmiəgəhiən kəm nətəmimi, kəni Mosɨs təməhlman tuva kəm tah. ");
INSERT INTO tnp_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Mətəu nian in təmətatɨg əhanəh əpəha e Nɨtəuət Sainai, tɨpɨtah mɨn kəmotəhti nəuian, motəpəh nətəlɨgiən, mətəu nɨkilah təmɨtəlɨg=pən o nati Ijɨp. ");
INSERT INTO tnp_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Kəni kəmotəni=pən kəm Eron məmə, ‘Ol narmɨ nati nəuvein məmə okəhuva uhgɨn mɨn rəhatah mə okotit itah. Mətəu Mosɨs əha inəha, iətəm təməmki itah kohiet Ijɨp, kɨnotəruru məmə in tɨnəhruvən.’ ");
INSERT INTO tnp_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kəni e nian əha, ilah kəmotol narmɨ nati məmə in otuva uhgɨn rəhalah, kəni kəmautol sakrifais e nati miəgəh mɨn məmə okotəfaki kəm in. Kəni kəmautol lafet rəha narmɨ nətɨ kau iətəm ilah əmə kəmotol. ");
INSERT INTO tnp_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Mətəu Uhgɨn təməuhlin=pən nəmtahn kəm lah, kəni megəhan=pən e lah məmə okotəfaki kəm mɨtɨgar mɨne məuɨg mɨne məhau mɨn e nəpuə. Kəni nati əha tətəgətun əsas əmə nəghatiən rəha Uhgɨn iətəm kəmətei e nauəuə rəha iəni mɨn rəha Uhgɨn. Tətəni məmə, ‘!Nətəm Isrel! ?Nian rəfin e nu fote əpəha ikɨn təpiə-məpiə ikɨn, itəmah nəmautoh nati miəgəh mɨn mautol sakrifais lan. ?Mətəu nɨkitəmah təhti məmə nəmautol kəm iəu? !Kəpə! ");
INSERT INTO tnp_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mətəu e nɨkitəmah, itəmah nəmautələs Nima Tapolɨn rəha uhgɨn eiuə u Molek, mɨne narmɨ məhau rəha uhgɨn eiuə u Refan. Nati mil u nəmautol məmə onəkotəfaki kəm lau. O nati əha, iəkahli pətɨgəm itəmah nəkəhuvən isəu motapirəkɨs Papilon.’” ");
INSERT INTO tnp_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Stipɨn təmətəkeikei mətəni məmə, “Nian tɨpɨtah mɨn kəməutatɨg ikɨn təpiə-məpiə ikɨn aupən, ilah kəmotos rəhalah nati kəti, Nima Tapolɨn rəha Uhgɨn iətəm tətəgətun məmə Uhgɨn tətatɨg ilah min. Kəni Mosɨs təmol Nima Tapolɨn əha tətɨtəu=pən əmə nətəlɨgiən rəha Uhgɨn u təməni=pən rəkɨs kəm in. ");
INSERT INTO tnp_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kəni nu tepət uərisɨg, Josuə təmit ilah məhuva məmə okotos rəkɨs nɨtəni əha o nətəm Kenan, nətəni u Uhgɨn təməhgirəkɨs nətəmimi ikɨn. Kəni ilah kəmotələs Nima Tapolɨn u məhuvən motatɨg ilah min motətəuarus=pa e nian rəha Tefɨt təmol kig lan. ");
INSERT INTO tnp_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Uhgɨn təmol təuvɨr kəm Tefɨt, kəni Tefɨt təmətapuəh ohni məmə Uhgɨn otegəhan lan pəh tol nimə kəti iətəm Uhgɨn otatɨg ikɨn. ");
INSERT INTO tnp_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Mətəu nimə əha, Kig Tefɨt təməsoliən, mətəu nətɨn Kig Solomən təmol. ");
INSERT INTO tnp_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Mətəu Uhgɨn iətəm ilɨs agɨn, təsatɨgiən e nimə iətəm iətəmimi əmə təmol. Təhmen e nəghatiən rəha Uhgɨn iətəm iəni rəhan təməni məmə, ");
INSERT INTO tnp_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ikɨn mɨn rəfin e neai təhmen əmə lak məmə iəkəharəg ikɨn marmənɨg, kəni nɨtəni mɨn rəfin təhmen əmə məmə iəkəfu=pən nəhlkək ikɨn. ?Mətəu nimə nak iətəm nəkotəhrun noliən məmə otəhmen lak? ?Kəni ikɨn pəhruvən nəkotəhrun noliən məmə iəkuvən məmeig ikɨn? ");
INSERT INTO tnp_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Otəni-to. ?Pəh təmol rəfin natimnati mɨn əha? Iəu pɨsɨn əmə, iəu Uhgɨn iəmol rəfin ilah.’” ");
INSERT INTO tnp_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Kəni Stipɨn təmətəkeikei mətəni məmə, “!Itəmah u! Rəhn-kapə təmah təskasɨk. Nɨkitəmah tapinəpu təhmen e rəha Nanihluə mɨn. Matəlgɨtəmah talu o nətəuiən nəuia Uhgɨn. !Itəmah nəkotəhmen əmə e tɨpɨtəmah mɨn nətəm kəməutəhti nəuia Narmɨn Rəha Uhgɨn! ");
INSERT INTO tnp_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","?Iəni mɨn rəha Uhgɨn aupən, pəh tɨpɨtəmah mɨn kəməsotoliən nərahiən kəm in? !Tɨkə! Kəmotol nərahiən kəm lah rəfin. Kəmotohamu mɨn nətəmi mɨn u kəməutəni pətɨgəm nuvaiən rəha Iətəmi Əhruahru. Kəni itəmah nəmotegəhan=pən e Itəmi Əhruahru u e nəhlmɨ rəhan mɨn tɨkɨmɨr mɨn kəni kotuhamu. ");
INSERT INTO tnp_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Itəmah nəmotos rəkɨs Lou rəha Uhgɨn u aupən nagelo mɨn kəmotos məhuva, mətəu itəmah nəməsotohtəu=pən agɨniən Lou əha.” ");
INSERT INTO tnp_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nian kəməutətəu nəghatiən mɨn rəha Stipɨn, nəhmtɨlah təmapinəpu, nɨkilah təmahmə pɨk, kəni mautɨgət=pən nəhluvlah kəm in mətəu-inu nɨkilah nahmə agɨn. ");
INSERT INTO tnp_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Mətəu Narmɨn Rəha Uhgɨn təməriauəh e Stipɨn, kəni təsal pəri e Negəu e Neai mafu nəhagəhagiən iətəm təsanən pɨk təmiet ima Uhgɨn ikɨn, kəni meruh Iesu tətəhtul e nɨkalɨ Uhgɨn maru, ikɨn ima narmənɨgiən mɨne nəsanəniən. ");
INSERT INTO tnp_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kəni Stipɨn təməni=pən kəm lah məmə, “!Ei, nəman! Iətafu Negəu e Neai rəha Uhgɨn taterəh, kəni Nətɨ Iətəmimi tətəhtul e nɨkalɨ Uhgɨn maru, ikɨn ima narmənɨgiən mɨne nəsanəniən.” ");
INSERT INTO tnp_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Nian nətəmi asoli rəha kaunsɨl kəmotətəu nəghatiən əha, kəmotəmkəsgɨn matəlgɨlah mɨn e nəuanəhlmɨlah, kəni motearəg e Stipɨn e nəuialah rəfin motauɨt motaiu məhuvən moteapən əhmen-əhmen əmə ohni, ");
INSERT INTO tnp_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","moteikəpan kəni motəraki pətɨgəm lan e taun. Kəni nətəmimi u kəmotətəu nəghatiən rəha Stipɨn, ilah kəmotəpeg rəhalah sot asoli mɨn, motəlɨn=pən iuəkɨr e nəhlkɨ iətəm aluə kəti, nərgɨn u Sol. Kəni mɨnəutəhti Stipɨn e kəpiel apɨn. ");
INSERT INTO tnp_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nian kəmautəhti, kəni Stipɨn təməfaki məmə, “Iərmənɨg Iesu, os narmək.” ");
INSERT INTO tnp_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kəni təmeiuaiu mɨsin nəulɨn kəni masək əfəməh məmə, “Iərmənɨg, afəl noliən tərah iətəm ilah kautol lak.” Nian təmol naunun e rəhan nəfakiən, kəni rəhan nehagiən tiet. ");
INSERT INTO tnp_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Kəni Sol in təmatəhtul əmə nɨkin tətagiən məmə ilah kəmotahtɨmu Stipɨn. Mətuəuin e nian əha, nərahiən asoli kɨnotol e niməfaki əpəha Jerusɨləm. Kəni ilah kəmohiet Jerusɨləm motagɨm=pən Jutiə mɨne Səmeriə motəpəh pɨsɨn əmə aposɨl mɨn kəutatɨg Jerusɨləm. ");
INSERT INTO tnp_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Nətəmimi nəuvein nətəm kəutəfaki əskasɨk kəməhuva motələs Stipɨn məhuvən mohtənɨm, kəni ilah kəmotasək pɨk ohni. ");
INSERT INTO tnp_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Mətəu Sol təmətuəuin mɨnətərəkɨn-ərəkɨn niməfaki, matuvən e nimə mɨn mətiuvi pətɨgəm nəman mɨne nɨpətan iətəm kəutəfaki, kəni matəmki=pən ilah e kaləpus. ");
INSERT INTO tnp_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Kəni nətəm kəutəfaki iətəm kəmohiet Jerusɨləm motagɨm, kəmautəni pətɨgəm nəghatiən rəha Uhgɨn ikɨn mɨn rəfin iətəm ilah kəutəhuvən=pən ikɨn. ");
INSERT INTO tnp_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Fɨlɨp təmuvən e taun kəti rəha Səmeriə, kəni mətəni pətɨgəm nanusiən rəha Krɨsto iətəm Uhgɨn təməni məmə otahli=pa. ");
INSERT INTO tnp_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nian nɨmənin nətəmimi kəmotətəu Fɨlɨp, kəni motafu nati apɨspɨs mɨn iətəm in tatol, ilah rəfin kəməutətəlɨg vivi lan e nak in tətəni. ");
INSERT INTO tnp_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Nətəmimi tepət narmɨn tərah mɨn kəmohiet e lah. Nian narmɨn tərah mɨn kəmohiet, kəmotasək əfəməh. Kəni nətəmimi tepət iətəm nɨpətɨlah təmɨmɨs, uə nətəm kəsotaliuəkiən, kəmotəuvɨr mɨn. ");
INSERT INTO tnp_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kəni nətəmimi rəfin e taun əha, ilah rəfin kəmotagiən. ");
INSERT INTO tnp_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kəni e taun əha, suah kəti nərgɨn u Saimon, in təmatol nati apɨspɨs tepət e nəsanəniən rəha iərmɨs mɨn, kəni nətəmimi rəfin e Səmeriə, narmɨlah təmiuvɨg. Təmol nuvəh nəuvetɨn. In mətəfəri aru əmə in məmə in iətəmi asoli kəti. ");
INSERT INTO tnp_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Kəni nətəmimi rəfin, nətəmi asoli mətəuarus=pa noluək mɨn əmə, kəməutəsal=pən pɨk ohni kəni məutəni məmə, “Suah u in iətəmi kəti u in tatol uək e Nəsanəniən Asoli Rəha Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Kəməutohtəu=pən in nuvəh nəuvetɨn mətəu-inu narmɨlah tatiuvɨg o natimnati mɨn iətəm in tatol. ");
INSERT INTO tnp_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Mətəu nian nətəmimi kəmotətəu nəghatiən iətəm Fɨlɨp tətəni pətɨgəm e nanusiən təuvɨr rəha Narmənɨgiən Rəha Uhgɨn mɨne nəghatiən rəha Iesu Krɨsto, kəmotəni nɨpəhriəniən lan, kəni kəmol bəptais e lah, nəman mɨne nɨpətan. ");
INSERT INTO tnp_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","E nian əha, suah mɨn u Saimon, təməni nɨpəhriəniən e Iesu, kəni kol bəptais mɨn lan. Kəni in tətɨtəu=pən Fɨlɨp ikɨn mɨn rəfin. Narmɨn təmiuvɨg o nati apɨspɨs mɨn mɨne nəmtətiən mɨn iətəm in tateruh Fɨlɨp tatol. ");
INSERT INTO tnp_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nian aposɨl mɨn əpəha Jerusɨləm kəmotətəu məmə nətəm Səmeriə kɨnotəhatətə e nəghatiən rəha Uhgɨn, kəni kəmotahli=pən Pitə mɨne Jon məmə okian o lah. ");
INSERT INTO tnp_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nian ilau kəmian miaiet=pən o lah, muəfaki o lah məmə Narmɨn Rəha Uhgɨn otəriauəh mətatɨg e lah, ");
INSERT INTO tnp_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","mətəu-inu kəmol bəptais əmə e lah e nərgɨ Iərmənɨg Iesu, mətəu Narmɨn Rəha Uhgɨn təsəriauəh əhanəhiən e nəmiəgəhiən rəhalah. ");
INSERT INTO tnp_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Kəni Pitə mɨne Jon kəmuələhu=pən nəhlmɨlau e lah muəfaki e lah, kəni Narmɨn Rəha Uhgɨn təməriauəh e lah. ");
INSERT INTO tnp_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nian Saimon təmafu məmə Narmɨn Rəha Uhgɨn tatuvən e nəmiəgəhiən rəha nətəmimi nian aposɨl mil kəmuələhu=pən nəhlmɨlau e lah muəfaki e lah, kəni in təfətɨgəm məni məmə otəfən kəm lau, ");
INSERT INTO tnp_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","kəni məni=pən kəm lau məmə, “Uəfa mɨn nəsanəniən u kəm iəu məmə nian iəkələhu=pən nəhlmək e nətəmimi, kəni ilah kotəhrun nosiən Narmɨn Rəha Uhgɨn.” ");
INSERT INTO tnp_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Mətəu Pitə təməni=pən kəm in məmə, “!Ik mɨne rəham məni onəkian e nɨgəm asoli! Mətəu-inu nɨkim təhti məmə nəkəhrun nos nəhmtɨ nati u iətəm Uhgɨn tətəfən kəm nətəmimi e məni. ");
INSERT INTO tnp_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ko ik nəsoliən uək u nəuvetɨn mɨne, mətəu-inu rəham nətəlɨgiən təsəhruahruiən e nəhmtɨ Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Əuhlin ik e rəham noliən tərah mɨn kəni məfaki=pən kəm Iərmənɨg, məta tafəl rəkɨs rəham noliən tərah mɨn iətəm nɨkim tətəhti ilah. ");
INSERT INTO tnp_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Iateruh məmə nian rəfin netetiən təməriauəh e rəham nətəlɨgiən, kəni noliən tərah mɨn kəmotəlis ik tiəkɨs.” ");
INSERT INTO tnp_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Kəni Saimon təməni=pən məmə, “!Əui! Uəfaki=pən kəm Iərmənɨg ohniəu məmə natimnati iətəm itəlau nəmuəni, kəti otəsuvaiən ohniəu.” ");
INSERT INTO tnp_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Kəni nian ilau kəmuəni pətɨgəm rəkɨs nəghatiən rəha Iərmənɨg mɨne natimnati iətəm in təmol, kəni kəmətian Jerusɨləm matuəhtul əgmagɨm e lahuənu mɨn rəha Səmeriə matuəni pətɨgəm mɨn nanusiən təuvɨr rəha Iərmənɨg. ");
INSERT INTO tnp_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Kəni agelo kəti rəha Iərmənɨg təməni=pən kəm Fɨlɨp məmə, “Əsəu-pesi muvən e suaru tɨsɨpən Jerusɨləm matuvən Kasa.” (Suaru əha tətəməhli əpəha ikɨn təpiə-məpiə ikɨn.) ");
INSERT INTO tnp_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Kəni in təmatuvən əmeiko mafu iətəm Itiopiə kəti e suaru. Suah əha in iətəmi asoli kəti rəha kwin rəha nətəm Itiopiə. Kəni in təmətarmənɨg e məni rəha kwin. Suah u təmuvən Jerusɨləm məmə otəfaki, ");
INSERT INTO tnp_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","kəni mɨnatɨtəlɨg matuvən iman ikɨn. Kəni in təmətəharəg-pəri e nati kəti kətəni məmə, “kat” iətəm hos tatiuvi. Kəni mətafin nauəuə iətəm iəni kəti rəha Uhgɨn təmətei, nərgɨn u Aiseə. ");
INSERT INTO tnp_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Kəni Narmɨn Rəha Uhgɨn təməni=pən kəm Fɨlɨp məmə, “Uvən maliuək=pən iuəkɨr o kat əha.” ");
INSERT INTO tnp_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Kəni Fɨlɨp təmaiu muvən iuəkɨr ohni, mətəu suah u tətafin nauəuə iətəm iəni Aiseə təmətei. Kəni təmətapuəh ohni məmə, “?Nəkəhrun nɨpətɨ nati u nətafin, uə kəpə?” ");
INSERT INTO tnp_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Kəni suah u təməni=pən kəm Fɨlɨp məmə, “?Iəkəhra məhrun? Mətəu-inu iətəmi kəti tɨkə mə otuhamtei=pa nɨpətɨ nəghatiən u kəm iəu.” Kəni in mətapuəh məmə Fɨlɨp otəri muvən ilau min muəharəg. ");
INSERT INTO tnp_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","In təmətafin nəghatiən u e Nauəuə Rəha Uhgɨn, tətəni məmə, “Kəmit təhmen e sipsip kan məmə okuhamu. Kəni təhmen e nətɨ sipsip, təsagətiən nian kətətei nɨmeimein, Kəni in təməpnapɨn əmə, məsəghatiən. ");
INSERT INTO tnp_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Kəmol aulɨs in, kəni nian kəmakil e kot, kəsakil əhruahruiən. Nian kəmotuhamu, in nəlugɨ iətəmimi əmə kəti, nətɨn tɨkə.” ");
INSERT INTO tnp_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kəni suah u təmətapuəh o Fɨlɨp məmə, “?Kərmə Aiseə təmətəghati aru lan, uə iətəpɨsɨn kəti?” ");
INSERT INTO tnp_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Kəni Fɨlɨp təmətuəuin e nəghatiən kətiəh əmə iətəm təmafin, mətəni=pən nəniən təuvɨr rəha Iesu. ");
INSERT INTO tnp_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Nian kəmətian e suaru miəuva ikɨn kəti nəhu əha ikɨn, kəni suah u təməni=pən kəm Fɨlɨp məmə, “!Afu-to! Nəhu kəti əpəha. ?Təhro? ?Pəh nəkol bəptais lak lan?” Kəni Fɨlɨp təmegəhan lan. ");
INSERT INTO tnp_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Kəni təməniəhu kat məmə otəhtul, kəni ilau pəti kəmueiuaiu mian e nəhu, kəni Fɨlɨp tol bəptais lan. ");
INSERT INTO tnp_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nian kəmuəri e nəhu miəuva ilɨs, Narmɨn Rəha Iərmənɨg tələs rəkɨs Fɨlɨp. Kəni suah u təməseruh mɨniən, mətəu təmatɨtəlɨg matuvən iman ikɨn e nagiəniən asoli e nɨkin. ");
INSERT INTO tnp_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Mətəu Fɨlɨp təmafu məmə tətəhtul əpəha e nɨtəni pahav ikɨn əpəha Astot. Kəni in təmatuvən, mətəni pətɨgəm nanusiən təuvɨr rəha Iesu əpəha e taun mɨn rəfin mətəuarus in təmiet=pən əpəha Sisəriə. ");
INSERT INTO tnp_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Kəni e nian əha, Sol təmətəghati əskasɨk mətəni əskasɨk məmə otohamu nətəmimi rəha Iesu. In təmuvən meruh pris asoli agɨn ");
INSERT INTO tnp_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","mətapuəh ohni məmə otətei nauəuə mɨn kəm nimə mɨn rəha nuhapumɨniən rəha nətəm Isrel əpəha Təmaskɨs, məmə nəmə oteruh kəti tatɨtəu=pən Suaru Rəha Iesu, nati əpnapɨn iərman uə pətan, otaskəlɨm ilah məlis ilah məmki ilah muvən e kaləpus əpəha Jerusɨləm. Kəni təməfən nauəuə mɨn kəm in. ");
INSERT INTO tnp_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nian Sol təmuva iuəkɨr o Təmaskɨs, əmeiko nəhagəhagiən kəti təmsɨpəri e neai tatuəu təhmen e noraipiən muva masiəgəpɨn in mɨne ikɨn mɨn tɨtəlau lan. ");
INSERT INTO tnp_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Kəni in təmsɨpəri morin e nɨftəni, kəni mətəu nəuia suah kəti tətəni=pən kəm in məmə, “!Sol! !Sol! ?Təhro natol nərahiən kəm iəu?” ");
INSERT INTO tnp_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Kəni Sol tətapuəh məmə, “?Ik pəh, Iərmənɨg?” Kəni nəuia iətəmi u təməni=pən kəm in məmə, “Iəu Iesu iətəm ik natol tərah lak. ");
INSERT INTO tnp_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Mətəu rəueiu əhtul muvən əpəha e taun. Ikɨn əha, suah kəti əha ikɨn otəpanəni=pɨnə əmə məmə nati nak onəkol.” ");
INSERT INTO tnp_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Kəni nətəmimi nətəm kautəhuərisɨg e Sol, kəmotauɨt kəni motəhtul məsotagətiən. Kəmotətəu əmə nəuia iətəmi u, mətəu kəməsoteruhiən iətəmi kəti. ");
INSERT INTO tnp_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Kəni Sol təhtul, mətəu nəhmtɨn tɨnəuau, tɨnəruru neruhiən nati. Kəni kəmotos əmə nəhlmɨn motit məhuvən Təmaskɨs. ");
INSERT INTO tnp_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Təmos nian kɨsɨl təməsehiən nati, kəni məsauəniən kəni məsəmnɨmiən nəhu mɨne. ");
INSERT INTO tnp_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Əpəha e Təmaskɨs, iətəmi kəti rəha Iesu əha ikɨn, nərgɨn u Anənaiəs. Iərmənɨg təmauɨn lan e nati kəti təhmen e nəməhlairiən, kəni məni=pən kəm in məmə, “!Anənaiəs!” Kəni in təmətam məmə, “Iərmənɨg, iəu əpə.” ");
INSERT INTO tnp_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Kəni Iərmənɨg təni=pən kəm in məmə, “O nəkuvən əha e nimə rəha Jutəs e suaru asoli iətəm kətəni məmə Təhruahru, kəni mətapuəh o iətəmi kəti, iətəm Tasəs, nərgɨn u Sol. In tətəghati rəueiu kəm Uhgɨn e nəfakiən, ");
INSERT INTO tnp_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","kəni Uhgɨn təməfən nəməhlairiən kəti, kəni təmeruh ik, Anənaiəs, nəmuva mələhu=pən nəhlməm lan məmə nəhmtɨn otair mɨn.” ");
INSERT INTO tnp_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Mətəu Anənaiəs təni məmə, “Iərmənɨg, iətətəu nəghatiən tepət e suah kəha e rəhan noliən tərah mɨn iətəm tatol e nətəm kəutəhatətə lam əpəha Jerusɨləm. ");
INSERT INTO tnp_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Kəni in təmuva u ikɨnu e nərgɨ pris asoli mɨn məmə otaskəlɨm, mələs nətəm kəutəhatətə lam.” ");
INSERT INTO tnp_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Mətəu Iərmənɨg təməni kəm Anənaiəs məmə, “!Uvən! Mətəu-inu suah u in rəhak iətəmimi iətəm inauɨn rəkɨs lan məmə otəni pətɨgəm nərgək kəm Nanihluə u səniə məmə nətəm Isrel, mɨne rəhalah kig mɨn, mɨne nətəm Isrel mɨn. ");
INSERT INTO tnp_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Kəni iəu iəpanəgətun in məmə otos nahməiən o nərgək.” ");
INSERT INTO tnp_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kəni Anənaiəs təmuvən lahuənu muvən imə, kəni mələhu=pən nəhlmɨn e Sol, məni=pən kəm in məmə, “Piak Sol. Iərmənɨg Iesu iətəm təmietɨgəm ohnik e suaru nian nəmətuva u ikɨnu, in təmahli=pa iəu məmə ik onəkeh mɨn nati, kəni Narmɨn Rəha Uhgɨn otəriauəh matɨg lam.” ");
INSERT INTO tnp_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Əmeiko, nati kəti təhmen e nɨvilɨgɨ nəmu təmiet rəkɨs e nəhmtɨ Sol, kəni tair mɨn mɨnateruh nati. Kəni mɨnəhtul mətaliuək, kəni kol bəptais lan məmə in nəmtətiən rəha nəhatətəiən. ");
INSERT INTO tnp_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kəni nian təmun nauəniən, kəni nɨpətɨn tuva məsanən mɨn. Kəni Sol təmatɨg mos nian nəuvein mɨn ilah nətəmimi rəha Iesu əpəha Təmaskɨs. ");
INSERT INTO tnp_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Təmətuəuin mɨn əmə e nian əha, mətəni pətɨgəm Iesu əpəha e nimə mɨn rəha nuhapumɨniən rəha nətəm Isrel məmə Iesu in Nətɨ Uhgɨn pəhriən. ");
INSERT INTO tnp_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Kəni nətəmi rəfin nətəm kəmotətəu in, kəmotauɨt pɨk ohni, kəni məutəni məmə, “!Ei! ?Suah u inu təmatol nərahiən kəm nətəm kəutəhatətə e Iesu əpəha Jerusɨləm aupən, uə kəpə? Kəni in təmuva ikɨnu məmə otaskəlɨm ilah məmki ilah muvən kəm pris asoli mɨn. ?Mə inəha, uə kəpə?” ");
INSERT INTO tnp_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Kəni nəghatiən iətəm Sol tətəni pətɨgəm, in təsanən pɨk mapirəkɨs nəghatiən rəha nətəm Isrel iətəm kəutatɨg Təmaskɨs, kəni mətəgətun vivi məmə Iesu in Krɨsto iətəm Uhgɨn təməni məmə otahli=pa. Kəni ilah kəmotəruru məmə okotəhrəni. ");
INSERT INTO tnp_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Nian tepət təmuva muvən rəkɨs, kəni nətəmi asoli rəha nətəm Isrel kəmotətei oneuən nəua kəti məmə okotohamu Sol, ");
INSERT INTO tnp_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","mətəu Sol təmətəu nəua oneuən rəhalah. Kəni rəueiu e nərauiə mɨne lapɨn mɨn, nətəm Isrel kəutəhtul pəsɨg əpəha e namtɨhluə e nɨpai kəmol e kəpiel məmə okotohamu Sol. ");
INSERT INTO tnp_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Mətəu in mɨn nəuvein kəmotələs lapɨn motaipei e kətɨm asoli kəti iətəm kəmətu=pən təulə lan, motɨləfətɨgəm motəhlman-əhlman lan e nəmtah nɨpai ihluə ikɨn. Kəni in təmagɨm muvən Jerusɨləm. ");
INSERT INTO tnp_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Nian Sol təmietɨgəm=pa Jerusɨləm, təmalkut məmə otuvən meruh nətəmi rəha Iesu mɨtəu=pən ilah, mətəu ilah kəutəgɨn, nɨkilah təhti məmə təteiuə əmə e lah məmə in iətəmi rəha Iesu. ");
INSERT INTO tnp_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Mətəu Panəpəs təmit muvən miti=pən kəm aposɨl mɨn, məni=pən kəm lah məmə təməhrol lanu Sol təmeruh Iərmənɨg Iesu e suaru nian təmatuvən e Təmaskɨs. Kəni təməni=pən mɨn kəm lah məmə Iərmənɨg təməghati kəm Sol, kəni təhro lan in tɨnətəni pətɨgəm nərgɨ Iesu əpəha Təmaskɨs, məsəgɨniən. ");
INSERT INTO tnp_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kəni ilah Sol kəmotatɨg kəni in tatuvən ikɨn mɨn əpəha Jerusɨləm mətəni pətɨgəm nərgɨ Iərmənɨg Iesu məsəgɨniən. ");
INSERT INTO tnp_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Təməghati ilah nətəm Isrel nətəm kəutəni nəghatiən Kris, kəmotoh ilah mɨn e nəghatiən. Kəni kɨnautol məmə okotohamu Sol. ");
INSERT INTO tnp_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nian in mɨn nəuvein nətəm kəutəfaki kəmotətəu, kəməhuvən motit Sol məhuvən motəsəu-pah əpəha ləuahtəni iuəkɨr o nɨtəhi e taun əha Sisəriə, kəni motahli=pən məmə otagɨm muvən əpəha isəu e taun əha Tasəs. ");
INSERT INTO tnp_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Kəni nətəm kəutəhatətə e Iesu əpəha Jutiə, mɨne Kaləli, mɨne Səmeriə kəmotatɨg e nəməlinuiən, iətəmi tɨkə məmə otol nəgɨniən kəm lah. Kəni Narmɨn Rəha Uhgɨn təmətasiru e lah mol ilah kəutəhtul əskasɨk, kəni ilah rəfin kəutatɨg mautɨsiai Iərmənɨg. Kəni ilah tɨnatepət. ");
INSERT INTO tnp_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pitə təmaliuək muvən ikɨn mɨn məmə otəsal e nətəm kəutəhatətə e Iesu. E naliuəkiən rəhan, təmuvən materuh nətəmimi rəha Iərmənɨg əpəha e taun əha Lita əpəha Jutiə. ");
INSERT INTO tnp_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Təmuvən ikɨn əha meruh suah kəti nərgɨn u Aeneas, nɨpətɨn təmɨmɨs tɨnos nu eit, təməsaliuəkiən mətapɨli əmə e rəhan pet. ");
INSERT INTO tnp_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Kəni Pitə təməni=pən kəm in məmə, “Aeneas. Iesu Krɨsto təmosmiəgəh ik əha rəueiu e rəham nɨmɨsiən. Əhtul, maiu-aiu rəham nɨmahan.” Kəni rəueiu agɨn mɨn, Aeneas təməuvɨr mɨn məhtul. ");
INSERT INTO tnp_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Kəni nətəmimi rəfin əha Lita mɨne ikɨn mɨn rəfin əpəha Saron kəmoteruh suah u təmaliuək mətan, kəni ilah rəfin kəmotəuhlin rəhalah nətəlɨgiən kəni mɨnəutəfaki kəm Iərmənɨg. ");
INSERT INTO tnp_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","E taun kəti əha Jopə, pətan kəti əha ikɨn iətəm in tətəhatətə e Iesu, nərgɨn u Tapitə. E nəghatiən rəha nətəm Kris, kətəni məmə Tokəs. Pətan u, nian rəfin tatol təuvɨr kəm nətəmimi kəni mətasiru mɨn e nanrah mɨn. ");
INSERT INTO tnp_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mətəu e nian əha, nɨmɨsiən kəti təmol in kəni tɨmɨs. Kəni ilah kəmotəueiu kəni kəməhuvən=pən e rəhan napən, kəni motələhu e nəuan nimə əpəha ilɨs agɨn. ");
INSERT INTO tnp_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ikɨn əha Lita in iuəkɨr əmə o taun əha Jopə. Kəni nian nətəmi rəha Iesu kəmotətəu məmə Pitə əpəha Lita, kəmotahli=pən suah mil keiu məmə okian muəsəu-pah muəni=pən kəm in məmə, “!Otuva uəhai əmə-to!” ");
INSERT INTO tnp_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Kəni Pitə təmɨtəu=pən ilau. Nian kəmhlietɨgəm=pən lahuənu, kəmotit məhuvən əpəha ilɨs agɨn. Mətəu pətalɨmɨs mɨn təriauəh əpəha ikɨn kəutasək ohni, kəni kəmotəgətun kəm Pitə rəhalah natimnati iətəm pətan əha təməhli nian in təmatəmiəgəh. ");
INSERT INTO tnp_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Kəni Pitə təmahli pətɨgəm ilah, kəni meiuaiu mɨsin nəulɨn kəni məfaki. Kəni məsal=pən o pətan əha təmɨmɨs məmə, “Tapitə, əhtul.” Kəni pətan əha təmair meruh Pitə, kəni məhtul məharəg. ");
INSERT INTO tnp_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Kəni Pitə teapən ohni maskəlɨm nəhlmɨn miuvi-pəri məmə otəhtul e nəhlkɨn mil. Kəni mauɨn=pən e nətəm kəutəhatətə e Iesu mɨne pətalɨmɨs mɨn məmə okəhuva imə, kəni miti=pən pətan əha iətəm tɨnəməmiəgəh kəm lah. ");
INSERT INTO tnp_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kəni nəghatiən e nati əha təmaiu mɨtəlau e taun əha Jopə. Kəni tepət kəmotəni nɨpəhriəniən e Iərmənɨg Iesu. ");
INSERT INTO tnp_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Kəni Pitə təmatɨg əha Jopə nəuvetɨn ilau suah kəti nərgɨn u Saimon iətəm tətol əpenə-penə e nɨlosɨ kau. ");
INSERT INTO tnp_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","E taun Sisəriə, suah kəti əha ikɨn nərgɨn u Koniliəs. In iətəm Rom, kəni in iətəmi asoli rəha soldiə mɨn u ilah rəfin uan-hanrɨt. Kəni ilah kəutsɨpən e “Soldiə rəha Itali.” ");
INSERT INTO tnp_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","In iətəmi kəti in tatɨsiai Uhgɨn rəha nətəm Isrel, mətɨtəu=pən noliən rəha nəfakiən rəhalah, in mɨne rəhan mɨn, mɨne noluək mɨn rəhan. In tətəfən rəhan məni tepət kəm ianrah mɨn, kəni mətəfaki kəm Uhgɨn rəha nətəm Isrel nian rəfin. ");
INSERT INTO tnp_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Nian kəti əmeiko e tri klok ləhnaiuv e nian tətəfaki lan, təmeruh nati kəti təhmen e nəməhlairiən. In təmafu vivi əmə agelo kəti rəha Uhgɨn tətuva ohni, kəni mauɨn lan məmə, “!Koniliəs!” ");
INSERT INTO tnp_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Nian nəhmtɨ Koniliəs təməhtul lan, in təməgɨn kəni məni məmə, “?Iərmənɨg, təhro?” Kəni agelo təməni=pən kəm in məmə, “Uhgɨn tɨnətəu rəkɨs rəham nəfakiən mɨneruh nəuvɨriən iətəm ik natol kəm nanrah mɨn, kəni nɨkin tɨnagiən ohni. ");
INSERT INTO tnp_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ahli=pən nətəmimi nəuvein kəhuvən əpəha Jopə, motos suah kəti məhuva, nərgɨn u Saimon Pitə. ");
INSERT INTO tnp_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","In tətatɨg ilau suah kəti nərgɨn u Saimon u tatol əpenə-penə e nɨlosɨ kau. Rəhan nimə tətəhtul iuəkɨr o nɨtəhi.” ");
INSERT INTO tnp_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nian agelo təməghati rəkɨs kəm in təmɨtəlɨg, kəni Koniliəs təmauɨn e rəhan ioluək keiu mɨne soldiə kəti iətəm tatol uək kəm in, kəni in mɨn iətəmi rəha nəfakiən. ");
INSERT INTO tnp_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","In təməni=pən rəfin natimnati iətəm in təmeruh kəm lahal, kəni mahli=pən ilahal məmə okɨhluvən Jopə. ");
INSERT INTO tnp_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kəni kəməni lauɨg lan, nian mɨtɨgar tɨnalelin, kəni suah milahal əha kəmluva e suaru iuəkɨr o taun əha Jopə. E nian əha, Pitə in təmuvən əpəha ilɨs e nəhue nimə iətəm tepin-epin ikɨn məmə otəfaki kəm Uhgɨn. ");
INSERT INTO tnp_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Mətəu nəumɨs tɨnus, kəni nian kəmatol əhanəh nɨgɨn nauəniən, in təmair mətəu təmeruh nəməhlairiən kəti iətəm Uhgɨn təməfən. ");
INSERT INTO tnp_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","E nəməhlairiən əha, təmeruh neai təmerəh, kəni nati təhmen e tapolɨn asoli kətaskəlɨm nɨfɨfɨn mɨn, kəni kəhlman-əhlman teiuaiu=pa e nɨftəni. ");
INSERT INTO tnp_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","E nɨpəg nati əha, təmeruh nati miəgəh pɨsɨn pɨsɨn mɨn əha ikɨn iətəm kəutaliuək mɨne mautəlkəu, mɨne mənɨg pɨsɨn pɨsɨn mɨn. ");
INSERT INTO tnp_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kəni nəuia iətəmi kəti təməni=pən kəm in məmə, “Pitə, əhtul. Ohamu nəuvein mun.” ");
INSERT INTO tnp_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Mətəu Pitə təni məmə, “!Iərmənɨg, kəpə! E rəhak nəmiəgəhiən iətan məsun əhanəhiən nati kəti tol lanu iətəm Lou rəham təməniəhu məmə kəsuniən tamɨkmɨk e nəhmtəm.” ");
INSERT INTO tnp_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Kəni nəuia iətəmimi təməghati mɨn kəm in məmə, “Səniən məmə nati kəti tamɨkmɨk iətəm iəu Uhgɨn iatəni məmə təuvɨr əmə, təsamɨkmɨkiən.” ");
INSERT INTO tnp_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Kəmuəghati o natimnati mɨn əha mau kɨsɨl, kəni rəueiu agɨn mɨn, tapolɨn əha təməri muvən əpəha e neai. ");
INSERT INTO tnp_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Kəni Pitə nɨkin təməhti pɨk məmə otəhrun nɨpətɨ nati əha təmeh e nəməhlairiən u təmeruh. Mətəu suah milahal u iətəm Koniliəs təmahli=pən ilahal, kəmlətapuəh o nimə rəha Saimon, kəni mɨnluva mɨnleruh. Kəni mɨnluvən məhləhtul əpəha e namtɨhluə. ");
INSERT INTO tnp_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Kəni məhlauɨn əfəməh məmə, “!Ei! ?Suah kəti u ikɨnu nərgɨn u Saimon Pitə uə?” ");
INSERT INTO tnp_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Kəni nian Pitə tətalkut əhanəh məmə otəhrun nɨpətɨ nati əha təmeh e nəməhlairiən, kəni Narmɨn Rəha Uhgɨn təməni=pən kəm in məmə, “!Ei, ətəu-to! Suah milahal kɨsɨl əpəha kələsal lam. ");
INSERT INTO tnp_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Əhtul uəhai meiuaiu muvən meruh ilahal. Nɨkim təsəhtiən məmə ko nəsuvəniən mɨtəu=pən ilahal mətəu-inu iəu iəmahli=pa ilahal məmə okɨluva.” ");
INSERT INTO tnp_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Kəni Pitə təmeiuaiu muvən məni=pən kəm lahal məmə, “Mə iəu u iətəm itəmahal nələsal lan. ?Nəklolkeikei iəu o nah?” ");
INSERT INTO tnp_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Kəni kɨhləni=pən kəm in məmə, “Əuəh. Iətəm tətarmənɨg e soldiə mɨn, u Koniliəs, təmahli=pa itɨmahal məmə iəkluva. In suah kəti iətəm tatɨsiai Uhgɨn kəni in məhruahru e nəhmtɨn, kəni nətəm Isrel kəutɨsiai pɨk in. Agelo kəti rəha Iərmənɨg təməni=pən kəm in məmə in otahli=pa itɨmahal iəhkluva mɨhlit ik kəhuvən iman ikɨn, məmə ik nək