﻿USE sofia;
DROP TABLE IF EXISTS sofia.tnn_vpl;
CREATE TABLE tnn_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tnn_vpl WRITE;
INSERT INTO tnn_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Inu nərgɨ tɨpɨ Iesu Kristo rat mɨn, kit in Kig Tefɨt, kən kit mɨn in Epraham. ");
INSERT INTO tnn_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Epraham in tata rəha Aisak, kən Aisak in tata rəha Jekop, kən Jekop in tata rəha Juta ne pian mɨn, ");
INSERT INTO tnn_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","kən Juta in tata rəha Peres ne Sera, rəhalau mama u Temar, kən Peres in tata rəha Hesron, kən Hesron in tata rəha Ram, ");
INSERT INTO tnn_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","kən Ram in tata rəha Aminatap, kən Aminatap in tata rəha Nason, kən Nason in tata rəha Salmon, ");
INSERT INTO tnn_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","kən Salmon in tata rəha Poas u rəhan mama Rehap, kən Poas in tata rəha Opet u rəhan mama u Rut, kən Opet in tata rəha Jese, ");
INSERT INTO tnn_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","kən Jese in tata rəha Kig Tefɨt. Kən Kig Tefɨt in tata rəha Solomon u rəhan mama in pətan rəha Uria aupən, ");
INSERT INTO tnn_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","kən Solomon in tata rəha Rehopoam, kən Rehopoam in tata rəha Apia, kən Apia in tata rəha Asa, ");
INSERT INTO tnn_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","kən Asa in tata rəha Jehosafat, kən Jehosafat in tata rəha Jehoram, kən Jehoram in pipi rat rəha Usia, ");
INSERT INTO tnn_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","kən Usia in tata rəha Jotam, kən Jotam in tata rəha Ahas, kən Ahas in tata rəha Hesekia, ");
INSERT INTO tnn_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","kən Hesekia in tata rəha Manase, kən Manase in tata rəha Amon, kən Amon in tata rəha Josaea, ");
INSERT INTO tnn_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","kən Josaea in tata rəha Jekonaea ne pian mɨn, kən uarisɨg lan, tɨkɨmɨr mɨn rəha noanol mɨn rəha Isrel kəmotəmɨk ilat motuwɨn Papilon məmə ilat okotuwa slef mɨn rəhalat. ");
INSERT INTO tnn_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kən inu nərgɨ pipi mɨn itəm təmətuoun e nian noanol mɨn rəha Isrel kəmotuwɨn Papilon. Jekonaea in tata rəha Sealtiel, kən Sealtiel in pipi rəha Serupapel, ");
INSERT INTO tnn_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","kən Serupapel in tata rəha Apiut, kən Apiut in tata rəha Eliakim, kən Eliakim in tata rəha Asor, ");
INSERT INTO tnn_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","kən Asor in tata rəha Satok, kən Satok in tata rəha Akim, kən Akim in tata rəha Eliut, ");
INSERT INTO tnn_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","kən Eliut, in tata rəha Eleasar, kən Eleasar in tata rəha Matan, kən Matan in tata rəha Jekop, ");
INSERT INTO tnn_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","kən Jekop in tata rəha Josep u iərman rəha Meri. Kən Meri təmɨləs Iesu, kən kətaun-in məmə Kristo itəm Uhgɨn təmən məmə otahl-ipa. ");
INSERT INTO tnn_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Təmətuoun e Epraham mətoarus-pən Kig Tefɨt, pipi rat mɨn əm u neen kəməte rəkɨs nərgɨlat, ilat fotin. Kən təmətuoun mɨn e Kig Tefɨt mətoarus-pən noanol mɨn rəha Isrel kəmotuwɨn Papilon, pipi rat mɨn ilat rafin fotin. Kən təmətuoun mɨn e noanol mɨn rəha Isrel kəmotuwɨn Papilon mətoarus-pən Kristo itəm Uhgɨn təmən məmə otahl-ipa, pipi rat mɨn ilat rafin fotin. ");
INSERT INTO tnn_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Inu namnusən rəha naiirən rəha Iesu Kristo. Mama rəha Iesu, nərgɨn u Meri, kɨnən rəkɨs məmə okos rəhan kətɨm kan məmə otətəu-pən suah kit, nərgɨn u Josep. Məto e nian kəsueamən əh muatɨg kitiəh, kən Josep təsuwɨnən əh mehm, məto Narmɨn Rəha Uhgɨn tɨnol məmə Meri tɨnəpək-əpək rəkɨs. ");
INSERT INTO tnn_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kən rəhan iaguɨhl Josep in etəm ətuatɨp, kən tatətəlɨg-in məmə otapəs Meri, məto in təsolkeikeən məmə otol Meri taulɨs, kən nɨkin təht məmə otəsən-iarəpən kəm netəmim. ");
INSERT INTO tnn_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Məto nian nɨkin təmatəht məmə in otol nətəlɨgən əh, kən nagelo kit rəha Iərəmərə təmuwa ron e napɨlaiirən mən-ipən kəm in məmə, “Josep, mipɨ Tefɨt rat. Onəkəsəgɨnən məmə onakit Meri məmə in rəham pətan, məto-inu suakəku əh tətatɨg lan, in təmɨsɨ-pən əm o Narmɨn Rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kən in otɨləs nətɨn kit iərman, kən onəkaun-in nərgɨn məmə Iesu məto-inu in otosmegəh rəhan mɨn netəmim e nolən tərat mɨn rəhalat.” ");
INSERT INTO tnn_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Natɨmnat mɨn rafin əh kəmotuwa kol əm nɨpahrienən e nəghatən rəha Iərəmərə itəm rəhan kit ien təmən aupən ikɨn məmə, ");
INSERT INTO tnn_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Pətan əkəku kit itəm iərman təsuwɨnən əh ron, otəpəs məwɨg, kən panɨləs nətɨn kit iərman, kən okaun-in nərgɨn məmə Emanuel,” inu nɨpətɨn təmə, “Uhgɨn tətatɨg kitat min.” ");
INSERT INTO tnn_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kən nian Josep təmaiir, kən təmətəu-pən əm nəghatən rəha nagelo rəha Iərəmərə. Kən təmuwɨn mit Meri muwa e rəhan latuənu məmə rəhan pətan, ");
INSERT INTO tnn_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","məto in təməsuwɨnən əh mehm matuwɨn matuwɨn mətoarus-pən Meri tɨləs nətɨn iərman. Kən Josep təmaun-in nərgɨn məmə Iesu. ");
INSERT INTO tnn_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Iesu təmaiir əpəh nɨtən rəha Jutia e taon Petlehem e nian Kig Herot Asol in təmatərəmərə lan. Kən uarisɨg ikɨn, netəm-iasol mɨn neen kəmotɨsɨ-par isəu motuwa Jerusalem. Kotenatɨg wɨr e nənən nɨpətɨ məhau mɨn. Kən motuwa motətapəh məmə, ");
INSERT INTO tnn_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“?Suakəku u in hiə, itəm in təmaiir məmə in kig rəha netəm Isrel? Emotehm rəhan məhau təmər əpəh par, kən ekoatuwa məmə ekotos-ipən nɨsiaiiən kəm in.” ");
INSERT INTO tnn_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nian Kig Herot Asol təməto nəghatən əh, ilat netəm Jerusalem nɨkilat rafin təmərat. ");
INSERT INTO tnn_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kən təmargəfɨmɨn pris asol mɨn ne iəgətun mɨn rəha Lou rəha nəfakən rəha netəm Isrel, kən matətapəh olat məmə, “?Kristo itəm Uhgɨn tɨnəmən rəkɨs məmə otahl-ipa, in otaiir hiə?” ");
INSERT INTO tnn_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Kən kəmotən-ipən kəm in məmə, “In otaiir əpəh taon Petlehem e nɨtən rəha Jutia. Məto-inu ien kit rəha Uhgɨn aupən, təməte tol min-nulan məmə, ");
INSERT INTO tnn_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ik Petlehem əpəh e nɨtən Juta, okol kəsənən məmə ik nat əpnapɨn e netəm-iasol mɨn əpəh ikɨn Juta, məto-inu etəm-iasol kit otɨsɨ-pən lam, kən in otatehm wɨr rəhak mɨn netəm Isrel tahmen-pən e etəm tatehm wɨr rəhan sipsip mɨn.’” ");
INSERT INTO tnn_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kən Kig Herot Asol təmaun-in netəm kotenatɨg wɨr e nənən nɨpətɨ məhau mɨn kotuwa tuəfɨmɨn anion ilat, matətapəh olat məmə məhau əh təmər ətuatɨp e nian naka, kən kəmotən-ipən nian rəha məhau kəm in. ");
INSERT INTO tnn_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kən in təmən-ipən kəm ilat məmə, “Otuwɨn Petlehem motegəs-in wɨr suakəku. Nian onəkotehm un, kən nakotos nəghatən lan motuwa məmə io mɨn ekuwɨn mos-ipən nɨsiaiiən kəm in.” ");
INSERT INTO tnn_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Nian kəmotəto nəghatən əh, kəmotiet motuwɨn, kən motehm məhau ilouin itəm kəmotehm əpəh par. Nian kəmotehm mɨn məhau əh, nɨkilat təmagien təmagien. Kən məhau un təmaupən-in ilat muwɨn matətul ətuatɨp əh suakəku ilouin tətapɨl ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kən kəmotuwɨn əh imə, motehm suakəku ilau rəhan mama Meri. Kən kəmotɨsin nulɨlat moatos-ipən nɨsiaiiən kəm suakəku əh. Kən kəmotielɨg nautə e rəhalat kətɨm mɨn itəm nəmtɨlat tiəkɨs, moatos-ipən kəm in. Kəmoatos-ipən iaen u kol tatɨpɨt-ɨpɨt, ne nat kit mɨn itəm nəmiəwɨn təwɨr nian katuwan e nɨgəm, nərgɨn u frankinsens, ne fomat itəm nəmiəwɨn təwɨr, nərgɨn u mɨr. ");
INSERT INTO tnn_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kən Uhgɨn təmən-iəhau ilat e napɨlaiirən məmə okəsotɨtəlɨg-pənən o Kig Herot Asol. Kən inəh ilat kəmotawɨlək-in Kig Herot motuwɨn-pən e suatɨp pɨsɨn moatuwɨn iməlat ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nian netəm kotenatɨg wɨr mɨn u kəmotiet rəkɨs mɨnoatuwɨn, kən nagelo kit rəha Uhgɨn təmuwa miet-arəpa o Josep e napɨlaiirən matən-ipən kəm in məmə, “Ətul uəhai, mɨləs suakəku ilau rəhan mama, onəkəhlagɨm məhaluwɨn əpəh Ijip. Kən onatəhlatɨg əh-ikɨn mətoarus-pən io əm ekən-ipɨnə mɨn kəm ik məmə onəkəhalɨtəlɨg-pa mɨn, məto-inu otəsuwəhən, Kig Herot Asol team-in suakəku u məmə otohamnu.” ");
INSERT INTO tnn_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kən əmun e nian əh lapɨn, Josep təmətul mɨləs suakəku ilau rəhan mama məhlagɨm mətəhaluwɨn əpəh Ijip. ");
INSERT INTO tnn_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Kən kəmətəhlatɨg e nɨməptən əh mətoarus-pən Kig Herot Asol otɨmɨs. Nat u tɨnuwa məmə otol nɨpahrienən e nəghatən itəm Iərəmərə təmən rəkɨs aupən e nəghatən rəha ien kit tatən min-nulan məmə, “Emaun-in nətɨk iərman məmə otiet rəkɨs Ijip.” ");
INSERT INTO tnn_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kən e nian Kig Herot Asol təmɨtun məmə netəm kotenatɨg wɨr e məhau mɨn kəməsotolən nəwian motawɨlək-in motagɨm, kən nɨkin təmahmə pɨk agɨn. Kən in təmahl-ipən rəhan mopael mɨn məmə okotuwɨn Petlehem ne ikɨn mɨn rafin tɨtəlau lan, məmə okoteam-in nɨsualkələh iərman mɨn itəm rəhalat nup təsaprəkɨs-inən nup kəiu, kən okotohamnu ilat rafin. In təmɨtəpun nup kəiu nəhlan məto-inu nɨkin təməht məmə nian ətuatɨp əh itəm netəm kotenatɨg kəmotehm məhau lan. ");
INSERT INTO tnn_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Natɨmnat mɨn u təmol nəghatən u tuwa mol nɨpahrienən lan itəm ien Jeremaea tɨnəmən rəkɨs aupən ikɨn məmə, ");
INSERT INTO tnn_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Netəm Rama kəmotəto pətan kit tətasək tətasək məto-inu tatəto tərat agɨn. Pətan əh in Rejel, in tətasək o rəhan nɨsualkələh. Kən məsolkeikeən məmə suah kit otuwa məghat mɨləs-ipər mɨn rəhan nətəlɨgən məto-inu rəhan mɨn nɨsualkələh kɨnotɨmɨs rafin.” ");
INSERT INTO tnn_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Uarisɨg e nian Kig Herot Asol təmɨmɨs, məto Josep ne Meri ne suakəku katəhlatɨg əh əpəh Ijip, kən nagelo kit rəha Uhgɨn təmuwa o Josep e napɨlaiirən kit matən-ipən kəm in məmə, ");
INSERT INTO tnn_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Josep. Ətul mɨləs suakəku ne rəhan mama kən məhalɨtəlɨg-pən e nəptən əh Isrel, məto-inu netəm mɨn u kəmotolkeike məmə okotohamnu suakəku, ilat kɨnotɨmɨs rəkɨs.” ");
INSERT INTO tnn_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kən Josep təmətul mɨləs suakəku əh ne rəhan mama, kən məhalɨtəlɨg-pən mɨn e nəptən əh Isrel. ");
INSERT INTO tnn_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Məto nian Josep təməto məmə Akeleas təmos nəme rəhan tata Kig Herot Asol matərəmərə e Jutia, kən in təməgin nɨtəlɨg-pənən Jutia. Kən Uhgɨn təməghat kəm Josep e napɨlaiirən kit mɨn məmə in otəsuwɨnən Jutia, kən təmiet muwɨn ikɨn pɨsɨn e nɨtən asol Kalili. ");
INSERT INTO tnn_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kən kəməhaluwɨn mətəhlatɨg nɨtən əh Kalili e taon kit, nərgɨn u Nasaret, məmə otol nəghatən rəha ien mɨn rəha Uhgɨn aupən otuwa mol nɨpahrienən. Ilat kəmotən-ipən məmə, “Okotən məmə in etəm Nasaret.” ");
INSERT INTO tnn_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nup mɨn neen tɨnuwa mɨnuwɨn rəkɨs, kən Jon Baptais təmiet-arəpa, kən mətamnus-iarəp nəghatən rəha Uhgɨn əpəh Jutia ikɨn taruən-aruən ikɨn, ");
INSERT INTO tnn_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","matən məmə, “Otəuhlin itəmat e rəhatəmat nolən rat mɨn, kən motuwɨn o Uhgɨn, məto-inu, nian itəm Uhgɨn otərəmərə e netəmim rafin tɨnatuwa iuəhkɨr.” ");
INSERT INTO tnn_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon Baptais u, itəm Aesea, ien rəha Uhgɨn aupən, təmatəghat-in məmə, “Suah kit tətaun əpəh ikɨn taruən-aruən ikɨn matən məmə, ‘Itəmat, otol əpen-əpenə rəha Iərəmərə, kən motol rəhan suatɨp tətuatɨp.’” ");
INSERT INTO tnn_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon tatuwɨn e natɨmnat itəm kəmol e nɨməme nat megəh kit katən məmə kamel, kən rəhan kətəut kəmol e nuwigɨ kau, kən nɨgɨn nagwənən, tatun pitɨp ne nahui sukapak. ");
INSERT INTO tnn_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kən netəmim tepət kəmotɨsɨ-pən Jerusalem, ne ikɨn mɨn nɨtən Jutia, ne ikɨn mɨn iuəhkɨr o nəhau əh Jotan, kəmotuwa məmə okotəplan Jon. ");
INSERT INTO tnn_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kən kəmotən-iarəp rəhalat nolən rat mɨn, kən in təmol baptais elat e nəhau əh Jotan. ");
INSERT INTO tnn_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Məto nian Jon təməplan məmə Farisi mɨn ne Satusi mɨn tepət kəmotuwa məmə otol baptais elat, kən təmən-ipən kəm ilat məmə, “!Itəmat nəkotahmen e təgəluə mɨn! Rəhatəmat nolən teko-eko. ?Nɨkitəmat təht məmə okəmə nəkoatol əm baptais u, kən onəkotagɨm tənin nalpɨnən ne neməha rəha Uhgɨn itəm otuwa? !Kəp! ");
INSERT INTO tnn_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Otol natɨmnat itəm koatəgətun məmə nəmotəuhlin nətəlɨgən rəhatəmat, motapəs pahrien nolən rat mɨn, kən motuwɨn o Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","“Kən sotən atɨpən kəm itəmat e nausitən məmə itəmat nəkotətuatɨp əm məto-inu itəmat noanol mɨn rəha Epraham. !Kəp! Inu nat əpnapɨn əm. Iatən kəm itəmat məmə nat əpnapɨn kəpiel mɨn əm, məto Uhgɨn tɨtun nəuhlinən ilat kotuwa noanol mɨn rəha Epraham. ");
INSERT INTO tnn_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Məto-inu roiu ne, Uhgɨn tɨnətul matɨp rəkɨs məmə otahtɨl-pən nɨg əpəh e nəukətɨn. Kən okəmə nɨg kit təsoe-inən noan itəm təwɨr, kən in otahtɨl mərakin-pən e nɨgəm. ");
INSERT INTO tnn_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Roiu, iatol baptais etəmat e nəhau məto-inu, itəmat nəmotəuhlin rəhatəmat nətəlɨgən o nolən rat mɨn rəhatəmat. Məto etəmim kit otuwa itəm rəhan nəsanənən ne nepətən taprəkɨs-in io. Kən io ləhau agɨn, esahmen-pənən məmə ekɨləs rəhan put tahmen e rəhan iolwək. Kən suah əh, in otol baptais etəmat e Narmɨn Rəha Uhgɨn ne nɨgəm. ");
INSERT INTO tnn_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","In tatətul matɨp o nakilən nolən rəha netəmim məmə otoor netəmim, tahmen-pən e etəm tətasum matoor nagwənən təwɨr ne nagwənən tərat. Tatos nagwənən təwɨr matuwɨn latuənu. Məto tatərakin-pən nagwənən tərat e nɨgəm asol itəm tatuəp namnun tɨkə.” ");
INSERT INTO tnn_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kən Iesu təmiet e nɨtən Kalili muwa e nəhau Jotan məmə Jon otol baptais lan. ");
INSERT INTO tnn_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Məto Jon tatən-iəhau əskasɨk in mən-ipən məmə, “Tətuatɨp əm məmə ik onəkol baptais lak. ?Tahro natuwa məmə ekol baptais lam?” ");
INSERT INTO tnn_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Məto Iesu təmən-ipən kəm in məmə, “Kəp. Pəs otol nəhlan roiu. E nolən əh, kilau okioal nat kit itəm Uhgɨn tolkeike.” Kən Jon təmegəhan-in. ");
INSERT INTO tnn_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kən Jon təmol baptais e Iesu, kən roiu agɨn Iesu təmər e nəhau, kən əmun nego e neai təmerəh, kən təməplan Narmɨn Rəha Uhgɨn təmeiuaiu-pa tahmen e mak, kən məpələh-pər lan. ");
INSERT INTO tnn_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kən nəwia Uhgɨn təmɨsɨ-pən e neai matən məmə, “Inu nətɨk keike itəm iakolkeike pɨk, kən nɨkik tagien pɨk ron.” ");
INSERT INTO tnn_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kən Narmɨn Rəha Uhgɨn təməghat-pən e nɨki Iesu məmə in otuwɨn əpəh ikɨn taruən-aruən ikɨn məmə Setan otos-ipən-os-ipən kəm in. Kən Iesu təmuwɨn ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kən Iesu təmapəs nagwənən o nian foti, e nərauiəgən ne lapɨn, kən uarisɨg lan nəumɨs təmus pɨk. ");
INSERT INTO tnn_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kən Setan təmuwa mɨnatos-ipən-os-ipən kəm Iesu mən-ipən kəm in məmə, “Okəmə ik Nətɨ Uhgɨn, ən-ipən kəm kəpiel mɨn pəs kotəuhlin ilat motuwa motol pɨret lan.” ");
INSERT INTO tnn_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Məto Iesu təmuhalpɨn nəghatən rəha Setan məmə, “Kəməte e Naoa Rəha Uhgɨn məmə, ‘Netəmim okol kəsotatɨgən e nagwənən əm, məto okotatɨg e nəghatən mɨn rafin itəm tatɨsɨ-pən o Uhgɨn.’” ");
INSERT INTO tnn_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kən Setan təmit Iesu mian əpəh Jerusalem, e nətuei nimə əpəh ilɨs agɨn e Nimə Rəha Uhgɨn, ");
INSERT INTO tnn_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","kən mən-ipən kəm Iesu məmə, “Okəmə ik Nətɨ Uhgɨn, ətɨpən əpəh ləhau e nɨsɨp, məto-inu Naoa Rəha Uhgɨn tatən məmə, ‘Uhgɨn otən-ipən kəm rəhan nagelo mɨn məmə okoatehm wɨr ik, kən motɨləs əm ik ilɨs e nelmɨlat məmə nəkəsorinən nelkəm məsɨn ne e kəpiel.’” ");
INSERT INTO tnn_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Kən Iesu təmuhalpɨn nəghatən rəha Setan məmə, “Naoa Rəha Uhgɨn tatən mɨn məmə, ‘Okol nəkəsotos-ipən-os-ipənən kəm rəhatəmat Iərəmərə Uhgɨn məmə otol nat kit, kən məmə onəkotəplan məmə in tətatɨg itəmat min, o kəp.’” ");
INSERT INTO tnn_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kən Setan təmit mɨn Iesu mian əpəh ilɨs e nɨtot asol, kən təməgətun in e kantri mɨn rafin e nətueintən, ne nəsanənən rəhalat, ne natɨmnat wɨr agɨn mɨn rafin itəm kotatɨg lan, ");
INSERT INTO tnn_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","kən təmən-ipən kəm Iesu məmə, “Natɨmnat rafin mɨn əh, oekos-ipɨnə kəm ik məmə onatərəmərə olat, okəmə nəkɨsin-pa nulɨm kən məfak-pa kəm io.” ");
INSERT INTO tnn_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kən Iesu təmuhalpɨn rəhan nəghatən məmə, “!Uwɨn isəu, Setan! Naoa Rəha Uhgɨn tatən məmə, ‘Onəkotəfak əm kəm rəhatəmat Iərəmərə Uhgɨn, kən in əm, onəkotol əm rəhan nətəlɨgən.’” ");
INSERT INTO tnn_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kən Setan təmagɨm mapəs Iesu, kən nagelo mɨn kəmotuwa motasitu lan. ");
INSERT INTO tnn_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kən e nian əh, kəmaskəlɨm Jon Baptais kɨləs-ipən e kalapus. Kən nian Iesu təməto nəghatən lan, kən in təmiet muwɨn e nɨtən Kalili. ");
INSERT INTO tnn_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kən təmapəs natɨgən Nasaret, kən miet muwɨn əpəh ləhau e taon kit, nərgɨn u Kapaneam, iuəhkɨr o Lek Kalili, kən mətatɨg ikɨn əh e nɨtən asol rəha noanol mɨn rəha Sepulun ne Naptali aupən. ");
INSERT INTO tnn_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Təmuwɨn ikɨn əh məmə nəghatən rəha ien Aesea otuwa mol nɨpahrienən lan itəm təmən aupən məmə, ");
INSERT INTO tnn_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Nəptən rəha noanol rəha Sepulun, ne nəptən rəha noanol rəha Naptali tatəməhl e suatɨp tatuwɨn e lek Kalili, entənɨpən-pən e nəhau Jotan. Inu nɨtən asol Kalili, ima Iaihluə mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Netəm ikɨn kəmotatɨg e napinəpən, məto kəmotəplan nəhag-əhagən asol kit. Kən tɨnatian, kən nəhag-əhagən asol təmasiəgəpɨn ilat itəm kəmotatɨg e napinəpən rəha nɨmɨsən u tatəfətain ilat nian rafin.” ");
INSERT INTO tnn_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kən mətuoun e nian əh, Iesu təmatən-iarəp nəghatən rəha Uhgɨn matən məmə, “Otəuhlin itəmat e rəhatəmat nolən rat mɨn, kən motɨtəlɨg-pən o Uhgɨn, məto-inu nərəmərəən rəha Uhgɨn tɨnatuwa iuəhkɨr.” ");
INSERT INTO tnn_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iesu təmətaliwək e nɨkalɨ Lek Kalili, kən məplan suah mil kəiu ilau pian, Antru ne Saimon, u nərgɨn kit mɨn u Pita. Ilau katuərakin net e Lek Kalili məto-inu ilau etəmim mil rəha niuwən nəm mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Kən təmən-ipən kəm ilau məmə, “Uea, mətəu-pa io, muea rəhak etəmim mil, kən io ekol itəmlau nakuea etəmim mil rəha niuwən netəmim məmə okotuwa rəhak mɨn netəmim.” ");
INSERT INTO tnn_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kən roiu agɨn, ilau kəmuapəs rəhalau net, kən muətəu-pən. ");
INSERT INTO tnn_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kən Iesu təmaliwək muwɨn noan məsɨn mɨn, kən məplan suah mil kəiu mɨn ilau pian, nərgɨlau u Jemes ne Jon, nətɨ Sepeti mil. Katuəpələh e nɨpəgnoa pot iləhal rəhalau tata matuəhl wɨr rəhalau net mɨn, kən Iesu təmaun-in ilau məmə okuea miauarisɨg-in in. ");
INSERT INTO tnn_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kən roiu agɨn, ilau kəmuətul muapəs pot ne tata rəhalau, kən muətəu-pən Iesu. ");
INSERT INTO tnn_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kən Iesu təmaliwək ikɨn mɨn rafin e nɨtən Kalili, matəgətun netəmim əpəh e nimə mɨn rəha nuəfɨmɨnən, kən matən-iarəp namnusən təwɨr rəha nərəmərəən rəha Uhgɨn kəm netəmim, kən matol-wɨr netəmim itəm koatɨmɨs e nɨmɨsən rafin, ne netəmim itəm nɨpətɨlat tərat o nɨmɨsən rafin. ");
INSERT INTO tnn_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kən namnusən e Iesu təmɨtəlau rafin e profens ikɨn Siria, kən netəmim kəmotəmɨk netəmim rafin itəm koatɨmɨs motuwa o Iesu, rəhalat nɨmɨsən tol min-nulan: neen koatɨmɨs, neen nɨpətɨlat tɨtahmə, neen narmɨn rat tətatɨg elat, neen koatos nɨmɨsən rəha mənɨg moataut, kən neen nɨpətɨlat məsɨn təmɨmɨs. Məto Iesu təmol-wɨr ilat. ");
INSERT INTO tnn_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kən nɨmanin netəmim kəmotiet e nɨtən Kalili, ne ikɨn Tekapolis, ne Jerusalem əpəh Jutia, ne ikɨn pɨsɨn mɨn neen əpəh Jutia, ne ikɨn mɨn entənɨpən-pən e nəhau Jotan, kən ilat rafin kəmotuarisɨg-in Iesu. ");
INSERT INTO tnn_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nian Iesu təməplan nɨmanin netəmim itəm koatətəu-pən in, kən in təmuwɨn əpəh ilɨs e nɨtot, kən məpələh, kən rəhan netəmim itəm koatuarisɨg-in in, ilat kəmotuwa. ");
INSERT INTO tnn_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Kən mɨnətuoun matəgətun ilat. Iesu təmən məmə, ");
INSERT INTO tnn_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Nakoatatɨg e nəwɨrən pahrien nian nəkoatɨləs-iəhau itəmat, moatən e nɨkitəmat məmə nakoatəkul-pən əm e Uhgɨn. In nəwɨrən pahrien məto-inu, itəmat netəmim rəha Uhgɨn, kən in tatərəmərə etəmat. ");
INSERT INTO tnn_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nakoatatɨg e nəwɨrən pahrien nian nakoatasək kən nɨkitəmat tɨtahmə. In nəwɨrən pahrien məto-inu, Uhgɨn otos-iəhau nɨkitəmat. ");
INSERT INTO tnn_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nakoatatɨg e nəwɨrən pahrien nian nəsotos-ipər atɨpən itəmat. In nəwɨrən pahrien məto-inu, o nian kit Uhgɨn otos-ipɨnə nətueintən kəm itəmat u rəhan mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nakoatatɨg e nəwɨrən pahrien nian nakotolkeike pɨk e nɨkitəmat rafin agɨn məmə nəmegəhən rəhatəmat okotətuatɨp e nɨganəmtɨ Uhgɨn. In nəwɨrən pahrien məto-inu, Uhgɨn otol rəhatəmat nəmegəhən kotətuatɨp e nɨganəmtɨn. ");
INSERT INTO tnn_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nakoatatɨg e nəwɨrən pahrien nian nakotasəkitun netəmim. In nəwɨrən pahrien məto-inu, Uhgɨn otasəkitun itəmat. ");
INSERT INTO tnn_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nakoatatɨg e nəwɨrən pahrien nian nɨkitəmat tətuatɨp məwɨr. In nəwɨrən pahrien məto-inu, onəkotəplan Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nakoatatɨg e nəwɨrən pahrien nian itəmat netəmim rəha nələhəuən nəməlinuən. In nəwɨrən pahrien məto-inu, okaun-in itəmat məmə nenətɨ Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nakoatatɨg e nəwɨrən pahrien nian nəkoatol natɨmnat itəm kotətuatɨp e nɨganəmtɨ Uhgɨn, kən netəmim koatol tərat kəm itəmat ron. In nəwɨrən pahrien məto-inu, itəmat netəmim rəha Uhgɨn, kən in tatərəmərə etəmat. ");
INSERT INTO tnn_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Nakoatatɨg e nəwɨrən pahrien nian netəmim koatol natɨmnat mɨn tərat kəm itəmat məto-inu itəmat netəmim rəhak, inəh koatən rat itəmat, kən moatərəkɨn itəmat, kən moateiuə-in itəmat moatən nəghatən tərat mɨn moatərəkɨn itəmat lan. ");
INSERT INTO tnn_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nɨpahrienən, netəmim kəmoatol nolən ahmen mɨn əm kəm ien mɨn aupən ikɨn itəm ilat koatol kəm itəmat. Kən otagien pɨk, məto-inu nətouən asol rəhatəmat tətatɨg əpəh e nego e neai. ");
INSERT INTO tnn_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Itəmat nəkotahmen e sol kəm netəmim rafin e nətueintən. ?Məto okəmə rəhan nətehenən tɨnɨkə, otahro muwa mətehen mɨn? Təsəwɨr mɨnən o nat kit mɨn, okərakin, kən netəmim kotaliwək lan. ");
INSERT INTO tnn_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Itəmat nəhag-əhagən rəha netəmim e nətueintən. Taon itəm kəmol əpəh ilɨs e nɨtot, okol təsəhluaigən. ");
INSERT INTO tnn_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kən etəmim kit tɨkə məmə otasiepən e lait, kən məfətain-iəhau e kətɨm. Kəp, nian tasiepən e lait, kən in otəkəike mətu-pər ikɨn lait tatəpələh ikɨn məmə lait otasiəgəpɨn rafin nɨpəgnoa nimə o netəmim rafin. ");
INSERT INTO tnn_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kən e nolən ahmen mɨn əm, otol rəhatəmat lait e nəmegəhən rəhatəmat tasiə məmə netəmim okotəplan wək wɨr mɨn itəm itəmat nəkoatol, kən ilat okotɨləs-ipər nərgɨ tata Uhgɨn itəm tətatɨg e nego e neai.” ");
INSERT INTO tnn_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Kən Iesu təmatəkəike matən-ipən kəm ilat məmə, “Təsəwɨrən məmə nɨkitəmat otəht məmə emuwa məmə ekərakin Lou itəm Uhgɨn təmos-ipən kəm Moses ne ien mɨn aupən. !Kəp! Eməsuwamən məmə ekərakin ilat, məto emuwa məmə ekol nɨpətɨ nəghatən mɨn əh okotuwa motol nɨpahrienən. ");
INSERT INTO tnn_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Pahrien, iatən kəm itəmat məmə nian nəptən ne neai kətuatɨg, kən Lou, in mɨn otatɨg. Kən okol nat kit otəsɨkəən lan, nat əpnapɨn in leta əkəku agɨn, kən Lou otətul motol wək mətoarus-pa nəghatən mɨn rafin rəha Lou kotuwa motol nɨpahrienən lan. ");
INSERT INTO tnn_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kən, o nat əh inəh, suah kit itəm tapəs Lou matəgətun netəmim mɨn məmə ilat mɨn okotapəs, nat əpnapɨn in Lou kit ləhau agɨn, kən okotaun-in suah əh məmə in ləhau agɨn e nərəmərəən rəha Uhgɨn. Məto suah kit itəm tatol Lou mɨn əh, matəgətun netəmim lan, kən okotaun-in suah əh məmə in ilɨs agɨn e nərəmərəən rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Iatən nəhlan kəm itəmat məto-inu, rəhatəmat nolən otəkəike mətuatɨp wɨr agɨn e nɨganəmtɨ Uhgɨn, taprəkɨs-in nolən mɨn rəha Farisi mɨn ne iəgətun mɨn rəha Lou itəm nɨkilat əm təht məmə kotətuatɨp wɨr. Okəmə rəham nolən təsətuatɨp wɨrən nəhlan, kən okol nəsuwɨnən matɨg ahgin nərəmərəən rəha Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Kən Iesu təmən mɨn məmə, “Itəmat nəmotəto rəkɨs nəghatən itəm iəgətun mɨn kəmotən kəm pipi rat mɨn rəhatəmat aupən. Ilat kəmotən məmə, ‘Əsotohamnuən etəmim,’ kən ‘Etəmim itəm təmohamnu itəm, otəkəike mətul e nɨganəmtɨ kot mos nalpɨnən.’ ");
INSERT INTO tnn_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Məto io iatən kəm itəmat məmə, okəmə suah kit neməha tatol o nat kit pian təmol, kən tətuatɨp məmə suah əh itəm neməha təmol, otətul e nɨganəmtɨ kot. Kən okəmə suah kit tatən rat pian, kən tətuatɨp məmə in otətul e nɨganəmtɨ kaonsel asol. Kən okəmə suah kit tətau-iərmɨs-in suah kit, kən tətuatɨp məmə etəm təmən nəghatən əh otuwɨn e nɨgəm asol. ");
INSERT INTO tnn_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Kən o nat əh inəh, okəmə nian natuwɨn e olta e Nimə Rəha Uhgɨn məmə onəkos-ipən nat kit kəm Uhgɨn, məto ikɨn əh, nɨkim tɨnəht piam itəm tatol neməha kəm ik o nat kit nəmol kəm in itəm təsahmenən, ");
INSERT INTO tnn_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","əpəs pitən rəham nat əh, kən muwɨn məplan piam muəg-ətuatɨp-in nətəlɨgən rəhatəlau, muapəs nolə tɨkɨmɨr, muea iolɨtɨlau mɨn, kən uarisɨg nəpanɨtəlɨg muwɨn mos-ipən nat kit rəham kəm Uhgɨn e olta əpəh e Nimə Rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Kən okəmə nəmol nat kit təsahmenən e etəmim kit, kən etəmim un tolkeike məmə otɨləs ik muwɨn e kot, təwɨr məmə nakuwɨn uəhai əm, nian nəsianən əh e kot, kən muəg-ətuatɨp-in nɨpəgnəmtɨn rəhatəlau pitən. Okəmə nakapəs, etəmim un otɨləs-ipən ik e nelmɨ etəm tətakil nəghatən, kən etəm tətakil nəghatən otos-ipən ik e nelmɨ polis, kən polis otɨləs-ipən ik e kalapus. ");
INSERT INTO tnn_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nɨpahrienən iatən kəm itəmat məmə, okəmə tol nəhlan, okol nəsietən e kalapus mətoarus nakətou rafin agɨn nalpɨnən rəham.” ");
INSERT INTO tnn_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Kən Iesu tatəkəike matən-ipən kəm ilat məmə, “Itəmat nəmotəto rəkɨs nəghatən u məmə, ‘Itəmat itəm nəmotol marɨt rəkɨs, nəsotakləh-inən nɨpɨtan pɨsɨn mɨn.’ ");
INSERT INTO tnn_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Məto io, io iatən kəm itəmat məmə nian suah kit itəm tɨnol marɨt rəkɨs tatəplan pətan pɨsɨn kit matolkeike məmə otakləh-in, kən in tɨnol rəkɨs təfagə rat e nɨkin, tahmen əm məmə in tɨnakləh-in pahrien. ");
INSERT INTO tnn_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Okəmə nɨganəmtɨm tol ik natol təfagə, kən təwɨr məmə nakɨləs-irəkɨs mərakin. Təməwɨr məmə nɨpətɨm məsɨn tɨkə, taprəkɨs-in nɨpətɨm rafin okərakin-pən e nɨgəm asol namnun tɨkə. ");
INSERT INTO tnn_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kən okəmə nelməm tol ik natol təfagə, kən təwɨr məmə nakətatɨp rəkɨs mərakin. Təməwɨr məmə nɨpətɨm məsɨn tɨkə, taprəkɨs-in nɨpətɨm rafin okərakin-pən e nɨgəm asol namnun tɨkə.” ");
INSERT INTO tnn_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Kən Iesu təmən mɨn məmə, “Itəmat nəmotəto rəkɨs nəghatən u məmə, ‘Etəmim itəm otapəs rəhan pətan, in otəkəike mos-ipən naoa kit kəm in itəm tatəgətun məmə in tɨnapəs in.’ ");
INSERT INTO tnn_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Məto io, io iatən kəm itəmat məmə, okəmə pətan kit itəm təmol marɨt təsuwɨnən mehm suah pɨsɨn kit, məto rəhan iərman tatol tifos mətapəs in, kən suah un tatol təfagə rat. Kən okəmə pətan əh tatətəu-pən suah pɨsɨn, kən pətan əh tatol təfagə, məto nəmkakiəhən rəha iərman rəhan aupən. Kən suah u itəm tatit pətan əh, in mɨn tatol təfagə.” ");
INSERT INTO tnn_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Kən Iesu təmən mɨn məmə, “Nəmotəto rəkɨs nəghatən kit mɨn itəm iəgətun mɨn kəmotən kəm rəhatat pipi mɨn aupən məmə, ‘Nəsotətgəhlən noanawɨl mɨn rəhatəmat itəm nəmotos, məto nəkotəkəike motol nat naka itəm nəmotos noanawɨl lan kəm Uhgɨn məmə nəkotol.’ ");
INSERT INTO tnn_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Məto io, io iatən kəm itəmat məmə, sotos əmən noanawɨl o nat kit məmə otol rəhatəmat nəghatən təskasɨk. Sotosən noanawɨl o nego e neai məto-inu ikɨn əh Uhgɨn tatərəmərə lan, kən nolən əh tahmen məmə noatos noanawɨl o Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kən sotosən noanawɨl o nətueintən məto-inu ikɨn əh Uhgɨn tatərəmərə lan, kən nolən əh tahmen məmə noatos noanawɨl o Uhgɨn. Kən sotosən noanawɨl o Jerusalem məto-inu ikɨn əh in taon rəha Uhgɨn, u in Kig asol ikɨn, kən nolən əh tahmen məmə noatos noanawɨl o Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kən sotosən noanawɨl o rəhatəmat-kapə, məto-inu rəhatəmat nəsanənən tɨkə məmə nakotəuhlin noanutəmat kit tuwa məruən o mapɨn. Uhgɨn əm tatərəmərə e natɨmnat e nəmegəhən rəhatəmat. Kən nolən əh tahmen məmə noatos noanawɨl o Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Məto apəs rəhatəmat nəghatən nian rafin otən əm nɨpahrienən. Kən okəmə rəhatəmat nətəlɨgən e nat kit in ‘əwəh,’ kən nakotən əm məmə, ‘əwəh.’ Kən okəmə rəhatəmat nətəlɨgən e nat kit in ‘kəpə,’ kən nakotən əm məmə, ‘kəpə.’ Nəghatən mɨn itəm kotaprəkɨs-in ‘əwəh’ o ‘kəpə,’ koatɨsɨ-pən e Setan.” ");
INSERT INTO tnn_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Kən Iesu təmatəkəike matən məmə, “Nəmotəto rəkɨs nəghatən kit məmə, ‘Okəmə suah kit tərəkɨn nɨganəmtɨm kit, kən netəmim okotərəkɨn mɨn nɨganəmtɨn kit. Kən okəmə suah kit tərəkɨn nəluəm kit, kən netəmim okotərəkɨn mɨn nəluɨn kit.’ ");
INSERT INTO tnn_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Məto io, io iatən kəm itəmat məmə, nəsalpɨnən nəratən kəm etəmim itəm təmol tərat kəm ik. Okəmə suah kit təhai ik mem nɨkapɨm matɨp, kən nakəkəike maləlin-pən mɨn nɨkapɨm mol pəs tem mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kən okəmə suah kit tɨləs ik mian e kot, kən matəkəike ron ik məmə nakos-ipən rəham sot əkəku kəm in məmə otəg-ətuatɨp-in rəhatəlau nəratən, kən nakəkəike mos-ipən mɨn rəham sot asol. ");
INSERT INTO tnn_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kən okəmə mopael kit rəha netəm Rom tatəkəike ron ik məmə nəkɨləs rəhan kətɨm muwɨn kilometa kitiəh, məto ik nakəkəike mɨləs mɨn muwɨn kilometa kit mɨn tol kəiu. ");
INSERT INTO tnn_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Okəmə suah kit tateasiə-in ron ik, kən ik nakəkəike mos-ipən kəm in. Kən okəmə suah kit tolkeike məmə in otos rəham nat kit muwɨn kənu mos mɨtəlɨg mɨn muwa, kən nəsənən məmə nakapəs, nakəkəike mos-ipən.” ");
INSERT INTO tnn_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Kən Iesu təmən mɨn məmə, “Nəmotəto rəkɨs məmə, ‘Onəkotolkeike rəhatəmat mɨn, kən motetəhau tɨkɨmɨr mɨn rəhatəmat.’ ");
INSERT INTO tnn_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Məto io, io iatən kəm itəmat məmə onəkotolkeike rəhatəmat tɨkɨmɨr mɨn, kən motəfak o netəm mɨn u itəm koatol nəratən kəm itəmat, ");
INSERT INTO tnn_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","kən nolən əh otəgətun məmə itəmat nenətɨ Uhgɨn rəhatəmat itəm tətatɨg ilɨs e nego e neai. Kən otol nəhlan məto-inu rəhatəmat tata Uhgɨn təmol mɨtgar tətasiəgəpɨn netəmim itəm kotəwɨr ne netəmim itəm kotərat, kən in mətahl-ipa nuhuən kəm netəm mɨn u itəm rəhalat nəmegəhən tətuatɨp, ne netəm mɨn u itəm rəhalat nəmegəhən təsətuatɨpən. ");
INSERT INTO tnn_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","?Okəmə nakotolkeike əm netəm mɨn u itəm kotolkeike itəmat, kən nɨkitəmat təht məmə Uhgɨn otətou itəmat o nolən kit itəm təwɨr? !Kəp! !Netəm mɨn u itəm koatos məni rəha takɨs, itəm katən məmə netəm rat, ilat mɨn kotolkeike ilat mɨn! ");
INSERT INTO tnn_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","?Kən okəmə nakotos əm itəmat mɨn neen moatəghat kəm ilat mɨn, məto tahro? ?Nɨkitəmat təht məmə nəkoatol nat kit itəm in təwɨr taprəkɨs-in netəm əpnapɨn? Kəp. Netəmim mɨn itəm kəsotɨtunən Uhgɨn, ilat mɨn koatol nəhlan. ");
INSERT INTO tnn_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tol nəhlan, itəmat nenətɨ Uhgɨn, nəkotəkəike motol nolən itəm in təwɨr mətuatɨp nian rafin, tahmen-pən əm məmə rəhatəmat Tata Uhgɨn in tatol.” ");
INSERT INTO tnn_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Kən Iesu təmən mɨn məmə, “Sotolən məmə nəkotol nolən mɨn itəm təwɨr kəm Uhgɨn məmə netəmim okotəplan itəmat ron. Okəmə nəkotol məmə netəmim okotəplan, kən Uhgɨn əpəh e nego e neai otəsətouən itəmat ron. ");
INSERT INTO tnn_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Tol nəhlan, okəmə nakotos-ipən nat kit kəm ian-rat mɨn məmə nakotasitu elat, nəsotolən e nolən rəha netəmim itəm rəhalat nənən təwɨr, məto nɨkilat tamkɨmɨk. Nian ilat kotasitu e ian-rat mɨn, rəhalat iolwək mɨn koatahl təwi moatol-arəp e nimə rəha nuəfɨmɨnən ne ihluə e suatɨp asol məmə netəmim okotɨtun. Koatol nəhlan məmə netəmim okotɨsiai-in ilat. Nɨpahrienən iatən kəm itəmat məmə, ilat kɨnotos rəkɨs nətouən rəhalat, inəh nɨsiaiiən rəha netəmim. ");
INSERT INTO tnn_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Məto itəmat, okəmə nakotos-ipən nat kit kəm ian-rat mɨn məmə nakotasitu elat, nəkotəkəike motol məmə netəmim okəsotəplanən, nat əpnapɨn rəhatəmat mɨn netəmim. ");
INSERT INTO tnn_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Otol nəhlan məmə netəmim okotəruru rəhatəmat nolən wɨr mɨn, kən rəhatəmat Tata itəm tatəplan rəhatəmat nolən anion mɨn, in otətou itəmat o rəhatəmat nolən wɨr mɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Kən Iesu təmatəkəike matən məmə, “Nian nakotəghat kəm Uhgɨn e nəfakən, kən sotolən e nolən rəha netəmim itəm rəhalat nənən təwɨr, məto nɨkilat tamkɨmɨk. Netəm mɨn əh, ilat kotolkeike məmə okotətul əpəh e nimə rəha nuəfɨmɨnən, ne ihluə e suatɨp asol, kən motəfak məmə netəmim okotəplan motəto ilat. Nɨpahrienən iatən kəm itəmat məmə ilat kɨnotos rəkɨs nətouən rəhalat, inəh nɨsiaiiən rəha netəmim. ");
INSERT INTO tnn_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Məto nian nakotəghat kəm Uhgɨn e nəfakən, nakotuwɨn əpəh e nɨpəgnoa nimə rəhatəmat, kən motahtosɨg e toa, kən motəfak kəm Uhgɨn itəm tətatɨg ikɨn əh itəm netəmim kəsotəplanən itəmat. Kən rəhatəmat Tata itəm tatəplan rəhatəmat nolən anion mɨn, in otətou itəmat o rəhatəmat nolən wɨr mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Kən nian nakotəghat kəm Uhgɨn e nəfakən, sotargətainən nəghatən mɨn tepət tepət u nɨpətɨn tɨkə, tahmen e netəm kotəruru Uhgɨn. Nɨkilat təht məmə rəhalat uhgɨn mɨn okotəto ilat o nəghatən mɨn tepət itəm koatəfak moatən. ");
INSERT INTO tnn_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Sotolən məmə ilat ne, məto-inu uarisɨg nakotətapəh ron, məto rəhatəmat Tata Uhgɨn tɨnɨtun rəkɨs nat naka itəm nakotoleike. ");
INSERT INTO tnn_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Kən tol min-nəhlan, nian nakotəghat kəm Uhgɨn e nəfakən, kən otəfak mihin nulan: ‘Tata rəhatɨmat itəm nətatɨg e nego e neai, pəs netəmim kotɨsiai-in ik. ");
INSERT INTO tnn_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Pəs nərəmərəən rəham tuwa, kən pəs nat itəm ik nakolkeike in otuwa mol nɨpahrienən lan ikɨn-u e nətueintən, tahmen-pən əm ilɨs e nego e neai. ");
INSERT INTO tnn_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Os-ipa nagwənən kəm itɨmat tahmen-in rəha nian roiu. ");
INSERT INTO tnn_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kən aluin məsalpɨnən, nolən rat mɨn rəhatɨmat, tahmen-pən əm məmə itɨmat ekotaluin məsotaskəlɨm-iəkɨsən e nɨkitɨmat nolən rat mɨn rəha netəmim itəm koatol nəratən kəm itɨmat. ");
INSERT INTO tnn_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kən segəhan-inən itɨmat ekotuwɨn ima nos-ipən-os-ipənən, ikɨn itəm məta oekotakiə motol nolən rat, məto os-irəkɨs itɨmat e nelmɨ Setan.’ ");
INSERT INTO tnn_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Okəmə itəmat nəkotaluin, məsotaskəlɨm-iəkɨsən e nɨkitəmat nolən rat mɨn rəha netəmim itəm koatol kəm itəmat, kən rəhatəmat Tata Uhgɨn e nego e neai, in otaluin məsalpɨnən, rəhatəmat nolən rat mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Məto okəmə itəmat nəsotaluinən, motaskəlɨm-iəkɨs e nɨkitəmat nolən rat mɨn rəha netəmim itəm koatol kəm itəmat, kən okol rəhatəmat Tata Uhgɨn otəsaluinən kən malpɨn nolən rat mɨn rəhatəmat.” ");
INSERT INTO tnn_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Kən Iesu təmatən mɨn məmə, “Nian nakotətuakəm motapəs nagwənən motəfak kəm Uhgɨn, sotolən nɨganəmtɨtəmat təpou tahmen-pən e netəm mɨn u itəm rəhatəmat nənən təwɨr, məto nɨkilat tamkɨmɨk. Ilat koatol nɨganəmtɨlat tol pɨsɨn, məmə netəmim okotəplan ilat məmə nəumɨs tɨnus ilat, kən netəmim okotɨsiai-in ilat. Nɨpahrienən iatən kəm itəmat məmə ilat kɨnotos rəkɨs nətouən rəhalat, inəh nɨsiaiiən rəha netəmim. ");
INSERT INTO tnn_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Məto nian nakotətuakəm motapəs nagwənən moatəfak kəm Uhgɨn, onəkotaikuas e nɨganəmtɨtəmat, kən motol-pən oel etəmat, ");
INSERT INTO tnn_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","məmə netəmim okəsotəplanən məmə nakotətuakəm motapəs nagwənən moatəfak kəm Uhgɨn, kən rəhatəmat Tata itəm tatəplan rəhatəmat nolən anion mɨn, in otətou itəmat o rəhatəmat nolən wɨr mɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Kən Iesu təmatən mɨn məmə, “Təsəwɨrən məmə nəkotuargətain rəhatəmat nat wɨr mɨn e nətueintən u məmə rəhatəmat nautə otepət, məto-inu e nətueintən u, wɨn mɨn kotɨtun nunən, kən namtəən tɨtun nərəkɨnən natɨmnat mɨn əh, kən iakləh mɨn kotɨtun nəhapən rəhatəmat nimə motuwɨn imə kakləh-in rəhatəmat natɨmnat. ");
INSERT INTO tnn_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Məto təwɨr məmə nəkotuargətain rəhatəmat nat wɨr mɨn əpəh e nego e neai. Ikɨn əh wɨn mɨn kəsotunən, kən namtəən okol təsərəkɨnən natɨmnat mɨn əh, kən iakləh mɨn okol kəsotakləh-inən. ");
INSERT INTO tnn_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Iatən nəhlan məto-inu, ikɨn pəhruən rəhatəmat natɨmnat wɨr mɨn koatəməhl ikɨn, məto nian rafin nɨkitəmat otəkəike matəht natɨmnat mɨn əh-ikɨn əh. ");
INSERT INTO tnn_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Nɨganəmtɨm in tahmen e lait itəm tatos-ipən nəhag-əhagən kəm nɨpətɨm. Okəmə nɨganəmtɨm mil kuəwɨr, tahmen əm məmə nɨpətɨm tərioah e nəhag-əhagən. ");
INSERT INTO tnn_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Məto okəmə nɨganəmtɨm mil kuərat, tahmen əm məmə nɨpətɨm in tərioah e nalugɨnən. !Kən okəmə nəhag-əhagən e nɨpətɨm in napinəp əmən, tahmen əm məmə ik nəkətatɨg e napinəpən asol agɨn-əh! ");
INSERT INTO tnn_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Etəmim tɨkə itəm tɨtun nuwamən in slef rəha etəm-iasol kəiu. Okəmə in tətalkut məmə otol nəhlan, kən otolkeike kit mol nəwian, kən metəhau kit məsolən nəwian. Okol nəsolən slef rəha Uhgɨn ne məni e nian kitiəh əm.” ");
INSERT INTO tnn_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Kən Iesu təmən məmə, “Kən o natɨmnat mɨn əh, io iatən kəm itəmat məmə, təsəwɨrən məmə nakotətəlɨg-in pɨk rəhatətmat nəmegəhən məmə onəkotun naka, kən motənɨm naka. Kən təsəwɨrən məmə nakotətəlɨg-in pɨk nɨpətɨtəmat məmə onəkotos hiə rəhatəmat napən. ?Nəukətɨ nəmegəhən rəhatɨmat tatəmegəh əm e nagwənən, o kəp? Kəp. ?Kən naka in nat asol o nɨpətɨtat, napən, o kəp? Kəp. ");
INSERT INTO tnn_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Otəplan-tu mənɨg mɨn itəm koatiwɨg moatan. Ilat kəsotasumən, kən ilat kəsotələhəu-wɨrən nagwənən e nɨpəgnoa nimə, məto Tata rəhatəmat e nego neai, in tatos-ipən nagwənən kəm ilat. ?Kən e nɨganəmtɨn, nɨkitəmat təht məmə in tolkeike pɨk itəmat taprəkɨs-in mənɨg mɨn? !Əwəh! ");
INSERT INTO tnn_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","?Nɨkitəmat təht məmə rəhatəmat nətəlɨgən pɨk tɨtun nolən rəhatəmat nəmegəhən təfəməh? !Kəp! Nolən rəha nətəlɨgən pɨk təsafin-pənən aua kitiəh əm e rəhatəmat nəmegəhən. ");
INSERT INTO tnn_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“?Kən təhrol nɨkitəmat tatəht pɨk napən onəkotuwɨn lan? Nɨkitəmat təht-tu nəguɨ nɨg mɨn itəm koatəwiə əpnapɨn əm. Ilat kəsotol pɨkən wək o nəhlən rəhalat napən. ");
INSERT INTO tnn_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Məto ekən kəm itəmat məmə Kig Solomon, in etəmim rəhan nautə tepət, kən rəhan napən itəm tatuwɨn-in, ilat kotəwɨr motaprəkɨs. Məto nəguɨ nɨg əpnapɨn mɨn kotəwɨr taprəkɨs-in rəhan napən. ");
INSERT INTO tnn_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Uhgɨn təmol manuwɨhl əpnapɨn əm təwɨr pɨk e nəguɨ nɨg mɨn əh. Məto manuwɨhl əh in rəha nian kitiəh əm, kən olawɨg kuwan e nɨgəm. ?Kən okəmə Uhgɨn tatol-wɨr manuwɨhl əh, kən nɨkitəmat təht məmə Uhgɨn otos-ipɨnə napən itəm nəkotəkəike motuwɨn lan? !Əwəh! In otol nəhlan. !Ei, rəhatəmat nahatətəən in təkəku agɨn! ");
INSERT INTO tnn_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Tol nəhlan, təsəwɨrən məmə itəmat nakotətəlɨg-in pɨk məmə, ‘?Ekotun naka?’ o ‘?Ekotənɨm naka?’ o ‘?Ekotos hiə napən motuwɨn-in?’ ");
INSERT INTO tnn_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Sotətəlɨg-in pɨkən. Netəm itəm kotəruru Uhgɨn, ilat koatətəlɨg-in pɨk natɨmnat itəm tol nəhlan. Məto itəmat nenətɨ Uhgɨn mɨn, kən rəhatəmat Tata əpəh e nego e neai, in tɨtun məmə nəkotəkəike motos natɨmnat mɨn əh. ");
INSERT INTO tnn_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Məto pəs onəkotol nərəmərəən rəha Uhgɨn, ne nəmegəhən ətuatɨp itəm Uhgɨn tolkeike, ilau okuətul aupən e nəmegəhən rəhatəmat. Nian nəkotol nəhlan, kən Uhgɨn otos-ipɨnə mɨn natɨmnat mɨn əh kəm itəmat. ");
INSERT INTO tnn_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tol nəhlan, təsəwɨrən məmə nakotətəlɨg-in pɨk natɨmnat itəm onəkotəkəike motos olawɨg, məto-inu natɨmnat rəha olawɨg, ilat rəha olawɨg. Nəratən rəha nian kitiəh, in tɨnahmen rəkɨs rəha nian kitiəh. ");
INSERT INTO tnn_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Okəmə nakotakil rat netəmim, kən Uhgɨn otələhəu nəghatən rəha nalpɨnən rəhatəmat. ");
INSERT INTO tnn_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tol nəhlan məto-inu, nəghatən əskasɨk itəm nakoatən məmə suah kit in etəm rat, kən Uhgɨn otətəu-pən əm o nənən rəhatəmat nolən rat mɨn. Okəmə nakotakil etəmim e nolən itəm tətuatɨp, kən Uhgɨn otakil itəmat e nolən itəm tətuatɨp. Məto okəmə nakotakil rat netəmim e nolən əskasɨk, kən Uhgɨn otakil itəmat e nolən ahmen mɨn əm. ");
INSERT INTO tnn_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","?Tahro nakoatən nɨmɨsmɨsɨ nɨg itəm tətatɨg e nɨganəmtɨ piatəmat mɨn, məto itəmat nəsotəplanən nɨg asol itəm tətatɨg e nɨganəmtɨtəmat? ");
INSERT INTO tnn_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","?Kən tahro nakoatən məmə, ‘Ei piak, pəs ekos-irəkɨs nɨmɨsmɨsɨ nɨg e nɨganəmtɨm,’ məto nəsotəplanən nɨg asol e nɨganəmtɨtəmat? ");
INSERT INTO tnn_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","!Rəhatəmat nənən təwɨr, məto nɨkitəmat tamkɨmɨk! Otaupən, motos-irəkɨs nɨg asol e nɨganəmtɨtəmat, kən nəkotɨtun nəplan wɨrən nohrəkɨsən nɨmɨsmɨsɨ nɨg itəm tətatɨg e nɨganəmtɨ piatəmat mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Sotos-ipənən natɨmnat rəha Uhgɨn kəm kuri mɨn, kən sotərakin-pənən rəhatəmat nat wɨr mɨn kəm pɨkəs mɨn. Okəmə nəkotol nəhlan, kən ilat okotaliwək lan kən moteirair motus itəmat.” ");
INSERT INTO tnn_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Kən Iesu təmatəkəike matən məmə, “Ekən kəm itəmat məmə, otətapəh-in kəm Uhgɨn o natɨmnat, kən in otos-ipɨnə kəm itəmat. Kən otegəs-in pəs nakotehm. Kən otəht-əht toa pəs toa oterəh otəmat. ");
INSERT INTO tnn_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ekən nəhlan məto-inu netəmim rafin itəm koatətapəh-in, kən okotos. Kən netəm mɨn u itəm koategəs-in, kən okotehm. Kən netəmim itəm koatəht-əht toa, kən toa oterəh olat. ");
INSERT INTO tnn_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“?Itəmat pah, nian nətɨn tatətapəh-in pɨret, məto in tatos-ipən kəpiel? !Kəp! ");
INSERT INTO tnn_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","?O, nian in tatətapəh-in nəm, məto in tatos-ipən sɨnek? !Kəp! ");
INSERT INTO tnn_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nat əpnapɨn itəmat netəmim rəha nətueintən nakotərat, məto nakoatos-ipən natɨmnat wɨr mɨn kəm nenətɨtəmat mɨn. !Məto Tata Uhgɨn e nego e neai, nolən rəhan in təwɨr pɨk maprəkɨs-in nolən rəhatəmat, kən nɨpahrienən, in otos-ipən natɨmnat wɨr mɨn kəm netəm mɨn u itəm koatətapəh-in ron! ");
INSERT INTO tnn_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kən tol nəhlan, otol təwɨr kəm netəmim rafin e nolən mɨn rafin itəm nakotolkeike məmə netəmim okotol min kəm itəmat. Inu nɨpətɨ Lou itəm Uhgɨn təmos-ipən kəm Moses, ne nəukətɨ nəghatən itəm təmos-ipən kəm ien mɨn aupən.” ");
INSERT INTO tnn_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Iesu təmən mɨn məmə, “Itəmat onəkotəkəike motuwɨn-pən e nafiluə itəm təkəku, məto-inu nafiluə itəm iahgin ne suatɨp itəm tɨmətɨg əm tatuwɨn o nərəkɨnən, kən netəmim tepət koatuwɨn-pən e nafiluə əh. ");
INSERT INTO tnn_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Məto nafiluə itəm təkəku, ne suatɨp itəm tiəkɨs tatuwɨn o nəmegəhən, kən netəmim noan məsɨn əm okotəplan.” ");
INSERT INTO tnn_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Kən Iesu təmən məmə, “Oatəto wɨr itəmat o ien eiueiuə mɨn. Ilat koatuwa moatəghat mətɨg e nolən əpou tahmen e sipsip, məto əpəh imə e nɨkilat, ilat kotahmen e kuri iarupɨn. ");
INSERT INTO tnn_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kən e nəmegəhən rəhalat, nəkotəplan noan, kən nəkotɨtun naka tətatɨg e nɨkilat. Netəmim okol kəsotuwɨnən e nolkosɨk o iapɨl-iapɨl moatəhl noa nɨg itəm təwɨr mətehen tahmen e krep o fik. ");
INSERT INTO tnn_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tol min-nulan, nɨg itəm təwɨr tatoe-in noan itəm təwɨr, məto nɨg itəm tərat tatoe-in noan itəm tərat. ");
INSERT INTO tnn_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nɨg itəm təwɨr okol təsoe-inən noan itəm tərat, kən nɨg itəm tərat, okol təsoe-inən noan itəm təwɨr. ");
INSERT INTO tnn_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nɨg mɨn rafin itəm kəsotoe-inən noalat itəm təwɨr, okəte rəkɨs ilat, kərakin-pən ilat e nɨgəm. ");
INSERT INTO tnn_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Tol nəhlan, e nəmegəhən rəha ien eiueiuə mɨn əh, onəkotəplan noan, kən nəkotɨtun naka tətatɨg e nɨkilat. ");
INSERT INTO tnn_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Sənəmə netəmim rafin itəm kotaun-in io motən məmə, ‘Iərəmərə, Iərəmərə,’ itəm ilat kotɨtun nuwɨnən motatɨg ahgin nərəmərəən rəha Uhgɨn məto ilat mɨn əm u itəm koatol nəwia rəhak Tata itəm tətatɨg e nego e neai. ");
INSERT INTO tnn_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","E nian Uhgɨn otakil netəmim rafin, netəmim tepət okotən kəm in məmə, ‘!Iərəmərə, Iərəmərə! ?Tahro? ?Nəkɨtun o kəp məmə, itɨmat emotən-iarəp nəghatən rəham itəm nəmos-ipa kəm itɨmat, kən motəhg-iarəp narmɨn rat mɨn e nərgəm, kən motol natɨmnat pɨspɨs mɨn e nərgəm?’ ");
INSERT INTO tnn_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kən oekən-ipən ətuatɨp kəm ilat məmə, ‘Aupən ekəruru itəmat, kən u-roiu mɨn ekəruru itəmat. !Otuwɨn isəu ron io, itəmat netəm noatol nolən tərat!’” ");
INSERT INTO tnn_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Kən Iesu təmol namnun rəhan nəghatən məmə, “Okəmə itəmat u itəm nəmotəto nəghatən mɨn u rəhak kən moatol, kən onəkotahmen e etəmim itəm tenatɨg, in təmiləkɨn-pən nəukətɨ rəhan nimə e kəpiel. ");
INSERT INTO tnn_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kən nuhuən təməfɨk, kən naruəh taiu, kən nɨmətag asol telel moh nimə. Məto nimə təsietən məto-inu kəmiləkɨn-pən nəukətɨn e kəpiel. ");
INSERT INTO tnn_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Okəmə itəmat u itəm nəmotəto nəghatən mɨn u rəhak kən məsotolən, kən onəkotahmen e etəmim itəm təsətəlɨg-in wɨrən nolən natɨmnat kən in ialməl, in təmiləkɨn-pən nəukətɨ rəhan nimə e nɨməkləkɨl əm. ");
INSERT INTO tnn_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kən nuhuən təməfɨk, kən naruəh taiu, kən nɨmətag asol telel moh nimə. Kən nimə təmiet, kən nian təmiet, məto təmərat agɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kən nian Iesu təmol namnun rəhan nəghatən, kən netəmim narmɨlat təmiwɨg pɨk ron, ");
INSERT INTO tnn_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","məto-inu nian tatəgətun, sənəmə tahmen e rəhalat iəgətun mɨn rəha Lou, məto rəhan nəghatən təfɨgəm, nepətən əh-ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nian Iesu təmeiuaiu-pa e nɨtot, netəmim tepət kəmotətəu-pən. ");
INSERT INTO tnn_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kən suah kit nɨmɨsən u leprosi təmol təmuwa ron, mɨsin-pən nulɨn o Iesu, kən mən məmə, “Iərəmərə, okəmə nakolkeike, kən nəkɨtun nol-wɨrən io kən mafəl rəkɨs namkɨmɨkən lak.” ");
INSERT INTO tnn_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kən Iesu təməg-əfəməh-in nelmɨn mələhəu-pən lan, mən məmə, “Əwəh. Iakolkeike. Əwɨr-ta.” Kən roiu agɨn-əh, nɨmɨsən leprosi təmagɨm mɨkə lan. ");
INSERT INTO tnn_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kən Iesu təmən-ipən kəm in məmə, “Əsən-iarəpən natɨmnat mɨn u kəm netəmim, məto uwɨn əm mehm pris kit pəs in tehm məmə nɨpətɨm tɨnol min-nulan, kən os-ipən kəm in nat u itəm Lou rəha Moses təmən o suah kit itəm rəhan leprosi tɨnɨkə, kən netəmim okotɨtun məmə nɨpahrienən nɨnəwɨr, kən rəham namkɨmɨkən tɨnɨkə.” ");
INSERT INTO tnn_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kən Iesu təmuwɨn miet-arəpən əpəh e taon Kapaneam, kən etəm-iasol kit rəha mopael mɨn rəha netəm Rom təmuwa məplan Iesu, kən mətasək-pən ron matən məmə, ");
INSERT INTO tnn_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Iərəmərə, rəhak iolwək tatɨmɨs, kən mətapɨl əpəh e nimə rəhak, nɨpətɨn rafin təmɨmɨs, kən tatəto tərat pɨk.” ");
INSERT INTO tnn_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Kən Iesu təmən-ipən kəm in məmə, “Oekɨmnə mol in təwɨr mɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kən etəm-iasol rəha mopael mɨn təmən-ipən kəm in məmə, “Iərəmərə, io etəmim kit itəm esətuatɨpən, kən esahmenən məmə ik onəkuwa e rəhak nɨpəgnoa nimə. Ən əm nəghatən kit, kən ekɨtun məmə in otəto təwɨr mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ekɨtun məmə nɨmɨsən əh otəkəike mol nəwiam, məto-inu io mɨn, rəhak netəm-iasol mɨn kotərəmərə lak, kən iatol nəwialat, kən mopael mɨn neen əh-ikɨn itəm io ekərəmərə elat. Okəmə ekən kəm kit məmə, ‘Uwɨn,’ kən tuwɨn. Kən okəmə ekən kəm kit məmə, ‘Wa,’ kən tuwa. Kən okəmə ekən kəm rəhak slef məmə, ‘Ol nat u,’ kən tol nat əh.” ");
INSERT INTO tnn_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nian Iesu təməto nəghatən əh, kən narmɨn təmiwɨg pɨk ron, kən təmən-ipən kəm netəmim itəm koatuarisɨg-in məmə, “Nɨpahrienən iakatən kəm itəmat məmə, suah u sənəmə in etəm Isrel. Kən nat əpnapɨn noanol mɨn rəha Isrel, məto esehmən ilat kit itəm rəhan nahatətəən təskasɨk tahmen-pən lan. ");
INSERT INTO tnn_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Iatən kəm itəmat məmə netəmim tepət okotɨsɨ-pən e nɨkalɨn par ikɨn ne e nɨkalɨn pah ikɨn, okotuwa motagwən kitiəh e tepɨl ilat Epraham, ne Aisak, ne Jekop əpəh e nərəmərəən əpəh e nego e neai. ");
INSERT INTO tnn_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Məto itəmat noanol rəha Isrel itəm Uhgɨn təmaupən mɨtəpun itəmat məmə in otərəmərə etəmat, in otərakin-pən itəmat ihluə e napinəpən, kən ikɨn əh, netəmim okotasək kən moatəto tərat, kən moatəgətain nəluɨlat mɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kən Iesu təmən-ipən kəm etəm-iasol rəha mopael mɨn məmə, “Atuwɨn. Rəham iolwək otəwɨr tol əm məmə inu ne nəmahatətə məmə Uhgɨn otol mihin.” Kən e nian ətuatɨp əh, nɨpətɨ iolwək rəha etəm-iasol rəha mopael mɨn təmuwa məwɨr mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kən Iesu təmuwɨn e nimə rəha Pita, kən muwɨn imə məplan uhu Pita tatətəp-ətəp mətapɨl. ");
INSERT INTO tnn_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kən təməg-əfəməh-in nelmɨn mek nelmɨ pətaguɨhl un, kən nətəp-ətəpən təmagɨm mɨkə, kən tɨnətul. Kən mɨnatol nagwənən nɨgɨ Iesu. ");
INSERT INTO tnn_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kən ehnaipən in, netəmim kəmotəmɨk netəmim tepət itəm narmɨn rat tətatɨg elat motuwa o Iesu, kən Iesu təməhg-iarəp narmɨn rat mɨn e nəghatən əm rəhan, kən mol-wɨr netəmim rafin itəm koatɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Natɨmnat mɨn əh təmol nəhlan məmə otol nəghatən rəha ien Aesea tuwa mol nɨpahrienən lan, itəm təmən aupən ikɨn məmə, “In təmos-irəkɨs nɨmɨsən mɨn rəhatat, kən mol nɨpətɨtat mɨn itəm kotahmə, kotəwɨr.” ");
INSERT INTO tnn_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kən nian Iesu təməplan nɨmanin netəmim itəm koatɨtəlau in, kən təmən-ipən kəm rəhan netəmim məmə okotuwɨn e nɨkalɨ lek entənɨpən-pən. ");
INSERT INTO tnn_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kən iəgətun kit rəha Lou təmuwa mən-ipən kəm in məmə, “Iəgətun. Hiə ikɨn onakatuwɨn-pən ikɨn, oekətəu-pən ik.” ");
INSERT INTO tnn_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Məto Iesu təmən-ipən kəm in məmə, “Kuri iarupɨn mɨn, rəhalat nɨpəg tatɨg o napɨlən, kən mənɨg mɨn nimaalat tatɨg o napɨlən. Məto Nətɨ Etəmim, in rəhan nimə rəha napɨlən tɨkə məmə otuwɨn mapɨl ikɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kən etəmim kit mɨn rəha Iesu təmuwa mən-ipən kəm in məmə, “Iərəmərə. Oekətəu-pən ik məto, pəs ekuwɨn pitən mɨtənɨm rəhak tata.” ");
INSERT INTO tnn_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Məto Iesu təmən-ipən kəm in məmə, “Ətəu-pa io. Netəmim itəm kəsotolən nəwia Uhgɨn, in tahmen əm məmə ilat kɨnotɨmɨs rəkɨs. Pəs ilat okotuwɨn motɨtənɨm rəhalat netəmim itəm kəmotɨmɨs.” ");
INSERT INTO tnn_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kən Iesu təmuwɨn e pot, kən rəhan mɨn netəmim kotuwɨn ilat min. ");
INSERT INTO tnn_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kən təsuwəhən, nɨmətag asol kit tətul kən mɨnol peau-peau asol mɨn e lek, kən nəhau tatər-pən e pot, iuəhkɨr əm pot tətamnɨm, məto Iesu tətapɨl. ");
INSERT INTO tnn_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kən kəmotuwɨn motəhgaiir e Iesu motən-ipən məmə, “!Iərəmərə! !Osmegəh kitat! !Otəsuwəhən kotamnɨm!” ");
INSERT INTO tnn_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kən Iesu təmən-ipən kəm ilat məmə, “?Tahro nakotəgɨn pɨk? Rəhatəmat nahatətəən təkəku agɨn.” Kən təmətul mən-iəhau nɨmətag ne peau-peau asol mɨn. Kən nɨmətag təmurahl nelmɨn, kən tɨnəməlinu tɨnəməlinu. ");
INSERT INTO tnn_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kən netəmim rəha Iesu narmɨlat təmiwɨg pɨk moatən məmə, “!Ei! ?Etəmim naka u? Nat əpnapɨn nɨmətag ne nəhau, məto ilau kətioal nəwian.” ");
INSERT INTO tnn_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kən nian Iesu təmuwa miet-pa entənɨpən-pən e lek, ikɨn Katara, kən etəmim kəiu itəm narmɨn rat mɨn kotatɨg elau kəmiaiet-arəpa məmə okuəplan Iesu. Ilau kəmiasɨpən e nɨpəg kəpiel mɨn, ikɨn katɨtənɨm netəmim ikɨn. Ilau kuəsanən mətioh netəmim, kən netəmim koatəgin nuwɨn-pənən ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Kən əmun narmɨn rat mɨn itəm kotatɨg elau kəmotaget əfəməh motən məmə, “!Ik Nətɨ Uhgɨn! ?Nəmuwa məmə nakahrol itɨmat? ?Nəmuwa məmə nakol nalpɨnən kəm itɨmat itəm təsolən əh nian rəhan?” ");
INSERT INTO tnn_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Iuəhkɨr əm olat, pɨkəs mɨn tepət əh-ikɨn kotagwən, ");
INSERT INTO tnn_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","kən narmɨn rat mɨn kotasək-pən o Iesu motən məmə, “Okəmə nəkəhg-iarəp itɨmat, ahl-ipən itɨmat ekotuwɨn e pɨkəs mɨn əh.” ");
INSERT INTO tnn_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kən Iesu təmən-ipən kəm ilat məmə, “Otuwɨn.” Kən narmɨn rat mɨn kəmotiet elau, motaiu motuwɨn e pɨkəs mɨn, kən əmun pɨkəs mɨn ilat rafin kəmotaiu moteiuaiu ikɨn təkul-əkul ikɨn, kən motiet-pən e lek motamnɨm. ");
INSERT INTO tnn_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kən netəmim itəm koatehm pɨkəs mɨn, kəmotagɨm motuwɨn e taon motən-iarəp natɨmnat rafin, ne natɨmnat itəm Iesu təmol kəm suah mil itəm narmɨn rat mɨn kotatɨg elau. ");
INSERT INTO tnn_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kən əmun netəmim rafin rəha taon kəmotuwa məmə okotəplan Iesu. Kən nian kəmotəplan in, kən kəmoatəkəike əskasɨk kəm in məmə otəkəike miet əh-ikɨn əh. ");
INSERT INTO tnn_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kən Iesu təmuwɨn e pot muwɨn entənɨpən-pən e lek, kən miet-arəpa iman ikɨn, e taon Kapaneam. ");
INSERT INTO tnn_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kən netəmim neen kəmotɨləs etəmim kit motuwa ron. Nɨpətɨn məsɨn təmɨmɨs, kən mətapɨl e rəhan nɨmɨtiwɨn. Kən nian Iesu təməplan rəhalat nahatətəən, kən təmən-ipən kəm etəm tatɨmɨs un məmə, “Nətɨk, əsəgɨnən. Rəham nolən rat mɨn emos-irəkɨs rəkɨs.” ");
INSERT INTO tnn_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kən nian kəmotəto nəghatən əh, iəgətun mɨn neen rəha Lou kotən-ipən kəm ilat mɨn məmə, “Nəghatən əh tərat. Suah əh tatəghat məmə otol məmə in Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Məto Iesu tɨtun nətəlɨgən rəhalat kən təmən-ipən kəm ilat məmə, “?Tahro itəmat nakoatos nətəlɨgən itəm tərat min-nulan? ");
INSERT INTO tnn_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","?In pəhruən tɨmətɨg məmə oekən, məmə, ‘Emafəl rəkɨs rəham nolən rat mɨn,’ o ‘Ətul maliwək’? ");
INSERT INTO tnn_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kən roiu ekol nat kit məmə nəkotɨtun məmə Nətɨ Etəmim tatos nepətən ikɨn-u e nətueintən məmə otafəl rəkɨs təfagə rat mɨn.” Kən in təmən-ipən kəm suah əh tatɨmɨs məmə, “Ətul mɨləs rəham nɨmɨtiwɨn maliwək matuwɨn latuənu.” ");
INSERT INTO tnn_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kən suah u tatɨmɨs təmətul maliwək matuwɨn latuənu. ");
INSERT INTO tnn_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kən nian nɨmanin netəmim kəmotəplan nat əh, kən kəmotəgɨn, kən motənwiwi nərgɨ Uhgɨn itəm təmos-ipən nepətən kəm etəmim məmə otol nəhlan. ");
INSERT INTO tnn_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kən Iesu təmaliwək muwɨn məsɨn mɨn, məplan suah kit, nərgɨn u Matiu. In etəmim itəm tatos məni rəha takɨs, kən tatəpələh ikɨn katətou-pən takɨs ikɨn. Kən Iesu təmən-ipən kəm in məmə, “Uarisɨg-in io, muwa etəmim rəhak.” Kən in təmətul muarisɨg-in Iesu. ");
INSERT INTO tnn_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kən Iesu təmuwɨn mətagwən e nimə rəha Matiu, kən netəmim tepət rəha nosən məni rəha takɨs kəmotuwa, kən netəmim tepət itəm koatol təfagə rat kəmotuwa, kən ilat kəmotuwa motəpələh motagwən ilat Iesu ne rəhan netəmim. ");
INSERT INTO tnn_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kən nian Farisi mɨn kəmotəplan nat əh, kən kotən-ipən kəm netəm rəha Iesu məmə, “?Tahro rəhatəmat iəgətun tətagwən kələh ilat netəm koatos məni rəha takɨs ne netəm koatol təfagə?” ");
INSERT INTO tnn_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Məto Iesu təməto rəhalat nəghatən kən təmən-ipən kəm ilat məmə, “Etəmim itəm təsɨmɨsən təsuwɨnən məplan tokita. Məto etəmim u itəm tatɨmɨs, in otəkəike muwɨn məplan tokita. ");
INSERT INTO tnn_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Otuwɨn motegəs-in motol nɨpətɨ nəghatən u pahrien itəm Naoa Rəha Uhgɨn tatən məmə, ‘Nat kit tatol nɨkik tətagien, inu məmə onəkotasəkitun netəmim, məto sənəmə rəhatəmat sakrifais mɨn itəm nəkoatol moatos-ipa kəm io itəm tatol nɨkik tətagien.’ Iatən tol min-nulan məto-inu eməsuwamən məmə ekaun-in netəm mɨn u itəm nɨkilat təht məmə kɨnotətuatɨp rəkɨs məmə okotuarisɨg-in io, məto emuwa məmə ekaun-in netəm mɨn u, netəm nol təfagə məmə okotuarisɨg-in io.” ");
INSERT INTO tnn_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kən netəmim rəha Jon Baptais kəmotuwa motəplan Iesu motən-ipən kəm in məmə, “Əplan-tu. Itɨmat ekotətuakəm motapəs nagwənən motəfak kəm Uhgɨn, kən Farisi mɨn, ilat mɨn koatol mihin. ?Məto təhrol e rəham netəmim kəsotolən nəhlan?” ");
INSERT INTO tnn_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Kən Iesu təmən-ipən kəm ilat məmə, “?Nian netəmim koatol marɨt rəha suah kit, kən in tətatɨg e nagwənən rəhan ilat in mɨn neen, nɨkitəmat təht məmə in mɨn neen okotasək? !Kəp! Məto nian əh-ikɨn itəm tatuwa məmə netəmim okotɨləs-irəkɨs etəmim itəm katol nagwənən rəhan. Kən e nian əh, in mɨn neen kotɨtun napəsən nagwənən. ");
INSERT INTO tnn_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Kən etəmim kit tɨkə məmə otos nɨmɨsmɨsɨ nɨməhan wi kit, kən məhlətain-pən e nɨməhan oas rəhan itəm təməhap, məto-inu okəmə tol nəhlan, kən nɨmɨsmɨsɨ nɨməhan wi tɨtun nəhapən nɨməhan oas, kən ikɨn təməhap ikɨn aupən tɨtun nuwamən mol iahgin pɨk agɨn. ");
INSERT INTO tnn_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Kən etəmim kit tɨkə məmə otos wain itəm kəmol wi, kən miuw-pən e pətəl oas u təskasɨk itəm kəmol e nuwigɨ nəni. Okəmə tol nəhlan, kən wain otahləpɨk, kən pətəl otəhap, kən wain otəhtəg, kən pətəl otərat. Məto wain itəm kəmol wi okəkəike kiuw-pən e pətəl itəm kəmol wi tɨmətmətɨg, kən wain ne pətəl katuəməhl wɨr.” ");
INSERT INTO tnn_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nian Iesu tatən-ipən natɨmnat mɨn əh kəm ilat, etəm-iasol kit tuwa mɨsin-pən nulɨn o Iesu məmə, “Nətɨk pətan əkəku təmɨmɨs roiu əm. Məto wa, mələhəu-pən nelməm lan, kən otəmegəh mɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kən Iesu təmətul ne rəhan netəmim, motuarisɨg-in suah un motuwɨn. ");
INSERT INTO tnn_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kən əmun pətan kit əh-ikɨn itəm tatos nɨmɨsən rəhalat nɨpɨtan nian rafin əm, mɨnos nup tuelef. Kən pətan əh təmɨsɨ-pən e məntaa Iesu ikɨn, kən mea-pən mek nɨpəgnəmtɨ kot məsɨn rəhan, ");
INSERT INTO tnn_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","təmol nəhlan məto-inu tatən atɨp kəm in məmə, “Okəmə ekek əm rəhan kot, kən rəhak nɨmɨsən otol namnun.” ");
INSERT INTO tnn_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kən Iesu təmeirair məplan pətan əh, kən mən-ipən kəm in məmə, “Nətɨk pətan, əsəgɨnən. Rəham nahatətəən təmol ik nɨnəwɨr mɨn.” Kən e nian əh, rəhan nɨmɨsən təmɨkə. ");
INSERT INTO tnn_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kən nian Iesu təmuwa miet-arəpa e nimə rəha etəm-iasol əh, kən təmuwɨn imə məplan netəmim koatahl nau motan napuən lan rəha nɨmɨsən, kən netəmim kəmoatasək pɨk. ");
INSERT INTO tnn_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Kən Iesu təmən-ipən məmə, “Otiet motuwɨn isəu, məto-inu pətan əkəku un təsɨmɨsən, məto in tətapɨl əm.” Kən ilat kəmotalah e Iesu. ");
INSERT INTO tnn_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Məto nian netəmim kəmotiet motuwɨn ihluə, kən tuwɨn imə, maskəlɨm nelmɨ pətan əkəku, kən pətan əkəku un təmətul. ");
INSERT INTO tnn_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kən namnusən rəha nat u təmaiu mɨtəlau rafin e nəptən əh. ");
INSERT INTO tnn_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kən nian Iesu təmiet ikɨn əh, məto iganəmtɨn rat mil kəiu kəmuətəu-pən in, kən mətuagət əfəməh məmə, “!Mipɨ Kig Tefɨt, asəkitun itɨmlau!” ");
INSERT INTO tnn_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nian Iesu tɨnuwɨn əpəh imə, kən iganəmtɨn rat mil kuea ron. Kən Iesu təmən-ipən kəm ilau məmə, “?Itəlau nətuahatətə məmə ekɨtun nol-wɨrən nɨganəmtɨtəlau, o kəp?” Kən ilau kuən-ipən məmə, “Əwəh, Iərəmərə.” ");
INSERT INTO tnn_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kən Iesu təmələhəu-pən nelmɨn e nɨganəmtɨlau mən-ipən məmə, “Uhgɨn otol-wɨr nɨganəmtɨtəlau məto-inu nəmuahatətə lan.” ");
INSERT INTO tnn_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kən nɨganəmtɨlau tɨnəwɨr kən kɨnatuəplan nat. Kən Iesu təmən-ipən əskasɨk kəm ilau məmə, “Onəsuən-iarəpən natɨmnat mɨn u kəm netəmim.” ");
INSERT INTO tnn_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Məto ilau kəmiaiet mian, kən muən-iarəp namnusən rəha Iesu tuwɨn mɨtəlau e ikɨn mɨn rafin e nəptən u. ");
INSERT INTO tnn_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nian suah mil u kəmiaiet, netəmim kotɨləs etəmim kit təruru nəghatən motuwa o Iesu. Suah əh in təruru nəghatən məto-inu narmɨn rat tətatɨg lan. ");
INSERT INTO tnn_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kən Iesu təməhg-iarəp narmɨn rat e suah əh, kən tɨnatəghat. Kən nɨmanin netəmim narmɨlat təmiwɨg pɨk ron, kən motən məmə, “Suah kit təsəplanən nat kit tol nulan əpəh Isrel nian kit ne.” ");
INSERT INTO tnn_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Məto Farisi mɨn kəmotən məmə, “Tatos nəsanənən o etəm-iasol rəha narmɨn rat mɨn məmə otəhg-iarəp narmɨn rat mɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Kən Iesu təmaliwək matuwɨn e taon ne latuənu mɨn rafin, kən matəgətun əpəh e nɨpəgnoa nimə mɨn rəha nuəfɨmɨnən, matən-iarəp namnusən təwɨr rəha nərəmərəən rəha Uhgɨn, kən matol-wɨr netəmim rafin itəm koatɨmɨs, ne netəmim rafin itəm nɨpətɨlat tərat koatəwɨr. ");
INSERT INTO tnn_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nian təməplan nɨmanin netəmim tɨnepət pɨk, kən nɨkin təmahmə pɨk olat məto-inu kɨnotos pɨk nahməən, kən motəruru nasitu-atɨpən e rəhalat nəmegəhən, kɨnotahmen e sipsip mɨn itəm etəmim tɨkə o nehmən ilat. ");
INSERT INTO tnn_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kən Iesu təmən-ipən kəm rəhan mɨn netəmim məmə, “!Otəplan-tu! Nagwənən tepət əpəh e nasumən itəm kɨnotɨmətə, məto iolwək mɨn noan məsɨn əm kotəulək-in. ");
INSERT INTO tnn_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kən otəfak-pən o etəm-iasol rəha nasumən məmə otahl-ipa iolwək mɨn tepət məmə okotuwɨn kəulək-in nasumən rəhan.” ");
INSERT INTO tnn_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Kən Iesu təmaun-in netəm tuelef rəhan kotuwa kitiəh, kən mos-ipən nəsanənən kəm ilat məmə ilat kotɨtun nəhg-iarəpən narmɨn rat mɨn e netəmim, kən motɨtun nol-wɨrən nɨmɨsən mɨn rafin, ne netəm mɨn u nɨpətɨlat təmərat. ");
INSERT INTO tnn_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kən inu nərgɨ netəm tuelef rəha Iesu: in taupən Saimon, u nərgɨn kit mɨn un Pita; ne təhan Antru; ne Jemes ne pian Jon, nətɨ Sepeti mil; ");
INSERT INTO tnn_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ne Filip ne Patolomiu; ne Tomas ne Matiu, etəmim rəha nosən məni rəha takɨs; ne Jemes nətɨ Alfeas; ne Tateas; ");
INSERT INTO tnn_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ne Saimon u kətaun-in məmə Selot; ne Jutas Iskariot u təmegəhan-in-pən Iesu tuwɨn e nelmɨ rəhan tɨkɨmɨr mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Kən nian Iesu təmahl-iarəp rəhan netəmim tuelef məmə okotuwɨn motol wək rəhan, təmaupən məghat kəm ilat məmə, “Itəmat onəsotuwɨnən o netəm mɨn un sənəmə noanol mɨn rəha Isrel, kən məsotuwɨnən e taon kit rəha netəm Sameria, ");
INSERT INTO tnn_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","məto onəkotuwɨn o noanol mɨn rəha Isrel itəm kotahmen e sipsip mɨn koatəlue. ");
INSERT INTO tnn_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kən nian nakotuwɨn, nəkotəkəike motən-iarəp məmə, ‘Nian itəm Uhgɨn otərəmərə e netəmim rafin lan, tɨnatuwa iuəhkɨr.’ ");
INSERT INTO tnn_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","“Kən itəmat nəkotəkəike motol netəm koatɨmɨs kotəwɨr mɨn. Kən itəmat nəkotəkəike motol netəm kəmotɨmɨs kotəmegəh mɨn. Kən netəmim itəm leprosi tatol ilat, nəkotəkəike motol nɨpətɨlat tuwa məwɨr mɨn. Kən netəmim itəm narmɨn rat tətatɨg elat, itəmat nəkotəkəike matəhg-iarəp narmɨn rat mɨn kotuwɨn isəu olat. Kən nəsanənən itəm nəmotos, nəməsotosən nəmtɨn. Kən onəkotəkəike motol wək əm, netəmim okəsətouən itəmat lan. ");
INSERT INTO tnn_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nian nakotuwɨn, nəsotosən məni. ");
INSERT INTO tnn_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kən məsotəmɨkən rəhatəmat kətɨm mɨn. Kən natɨmnat itəm nakoatuwɨn-in, in əm un, məsotos mɨnən iahgoau kit mɨn. Kən məsotosən put, ne kasɨkɨn rəhatəmat mɨn. Iatən nəhlan məto-inu tətuatɨp əm məmə katos-ipən kəm iolwək mɨn natɨmnat itəm tətuatɨp o natɨgən rəhalat. ");
INSERT INTO tnn_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Nian nakotuwɨn e taon kit o latuənu kit, nəkotəkəike motehm etəmim kit itəm nɨkin tagien məmə nakotuwɨn mətatɨg itəmat min, kən nakoatatɨg ikɨn əh mətoarus-pən nian nakotiet mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nian nakotuwɨn kətatɨg e nimə kit, nəkotəkəike kəghat wɨr kəm ilat məmə, ‘Nəməlinuən tətatɨg otəmat.’ ");
INSERT INTO tnn_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kən okəmə netəmim e nɨpəgnoa nimə u, nɨkilat tagien məmə okotos itəmat, kən pəs rəhatəmat nəghatən rəha nəməlinuən tətatɨg olat. Məto okəmə nɨkilat təsagienən otəmat, nəkotəkəike motos nəghatən rəha nəməlinuən moatuwɨn. ");
INSERT INTO tnn_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","“Kən okəmə netəmim neen kəsotolkeikeən məmə okotit itəmat nakotuwɨn e rəhalat nɨpəgnoa nimə, o kəsotətəlɨg-inən rəhatəmat nəghatən, kən nian nəkoatiet e nimə rəhalat, o rəhalat latuənu, nəkotəkəike motohapɨspɨs rəkɨs nɨsɨp e nelkɨtəmat məmə ilat okotɨtun məmə nəmotəuhlin-pən məntaatəmat olat. ");
INSERT INTO tnn_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nɨpahrienən iatən kəm itəmat, e nian itəm Uhgɨn otakil netəmim, nalpɨnən rəha netəm mɨn əh in otəskasɨk pɨk maprəkɨs-in nalpɨnən rəha netəm kotərat aupən e taon mil əh, Sotom ne Komora.” ");
INSERT INTO tnn_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Kən Iesu təmatəkəike matən məmə, “Otətəlɨg-in-tu. Etahl-ipən itəmat nakoatuwɨn tahmen e sipsip mɨn itəm kəmotuwɨn ilugɨn e kuri iarupɨn mɨn. Onəkotəkəike motenatɨg wɨr tahmen e malɨkɨm, kən itəmat motan mətɨg tahmen e mənɨg mak. ");
INSERT INTO tnn_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Onakoatəto wɨr itəmat o netəmim, məto-inu ilat okotɨləs itəmat məmə nəkoatətul e nɨganəmtɨ kaonsel rəhalat, kən okotalis itəmat əpəh imə e nimə rəha nuəfɨmɨnən. ");
INSERT INTO tnn_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","“Kən məto-inu itəmat netəmim rəhak, okotewkəkan itəmat nakotuwɨn motətul e nɨganəmtɨ etəm-iasol mɨn rəha kapman mɨn, ne kig mɨn məmə onəkotən-iarəp nəghatən təwɨr rəhak e nɨganəmtɨlat, kən e nɨganəmtɨ Iaihluə mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nian ilat okotuwa motɨləs itəmat, kən nɨkitəmat təsəht pɨkən məmə onəkotuwɨn motən məmə naka, o nakotəhrol nulan motəghat. Nəsotəgɨnən məto-inu Narmɨn Rəha Uhgɨn, in otos-ipɨnə nəghatən itəm onəkotən e nian ətuatɨp əh. ");
INSERT INTO tnn_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nəsotəgɨnən məto-inu sənəmə itəmat onəkotəghat, məto Narmɨn Rəha rəhatəmat Tata, otos-ipɨnə nəghatən kəm itəmat məmə nakoatən-iarəp. ");
INSERT INTO tnn_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Netəmim okotegəhan-in-pən pialat ətuatɨp mɨn kəm rəhalat tɨkɨmɨr mɨn məmə okotohamnu ilat, kən tata mɨn okotol mihin mɨn kəm nenətɨlat ətuatɨp mɨn, kən nɨsualkələh okotətul motol nolən ahmen mɨn əm kəm rəhalat tata mɨn ne mama mɨn məmə okotohamnu ilat. ");
INSERT INTO tnn_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Netəmim rafin okotetəhau itəmat o nərgək. Məto etəm otətul əskasɨk mətoarus-pən natɨmnat mɨn un okotol namnun, kən Uhgɨn otosmegəh. ");
INSERT INTO tnn_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nian okotol tərat kəm itəmat e taon kit, kən nakotiet motagɨm motuwɨn e taon pɨsɨn kit mɨn. Iatən pahrien kəm itəmat məmə okol nəsotuwɨn rafinən e taon mɨn rəha Isrel mətoarus-pən Nətɨ Etəmim in otuwa mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Netəmim itəm koatətəlɨg-in, okol kəsotaprəkɨs-inən rəhalat iəgətun, kən iolwək mɨn, okol kəsotaprəkɨs-inən rəhalat etəm-iasol. ");
INSERT INTO tnn_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Netəm katəgətun ilat, kotəkəike motagien məmə okotuwa motahmen e iəgətun rəhalat, kən iolwək mɨn kotəkəike motagien məmə okotuwa motahmen e etəm-iasol rəhalat. Io, io etəm-iasol rəha nimə. Okəmə netəmim neen kotən rat io məmə io Pielsepul, u nərgɨn kit rəha Setan, kən okol tahmen mɨn əm e iolwək mɨn rəha nimə rəhak.” ");
INSERT INTO tnn_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Kən Iesu təmən məmə, “Tol nəhlan, əsotəginən netəmim. Natɨmat itəm netəmim koatəfətain, Uhgɨn otɨləs-iarəpa ikɨn tagəhag ikɨn, kən natɨmnat itəm netəmim koatəhluaig-in, Uhgɨn otɨləs-iarəpa, netəmim rafin kotəplan. ");
INSERT INTO tnn_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Natɨmnat itəm iatən kəm itəmat e napinəpən, itəmat onəkotəkəike motən-iarəp mɨn e nəhag-əhagən, kən natɨmnat itəm iatən anion, itəmat onəkotəkəike motən-iarəp asol e nɨganəmtɨ netəmim. ");
INSERT INTO tnn_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Sotəginən netəmim itəm kotɨtun nohamnuən nɨpətɨtəmat, məto okol kəsotohamnuən narmɨtəmat. Məto nəkotəgin Uhgɨn itəm tɨtun nərəkɨnən nɨpətɨtəmat ne narmɨtəmat e nɨgəm asol. ");
INSERT INTO tnn_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Otəplan-tu. Mənɨg əlkələh mɨn, netəmim koatol-salɨm-in məni əkəku əm. Məto okəmə rəhatəmat Tata Uhgɨn təsegəhan-inən ilat, okol kit təsɨmɨsən. ");
INSERT INTO tnn_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kən noanutəmat e rəhatəmat-kapə, Uhgɨn tətafin rafin ilat. ");
INSERT INTO tnn_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","!Tol nəhlan, sotəgɨnən! Uhgɨn tolkeike pɨk itəmat taprəkɨs-in mənɨg əlkələh mɨn əh. ");
INSERT INTO tnn_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Tol nəhlan, okəmə etəmim otən-iarəp nərgək e nɨganəmtɨ netəmim, kən io mɨn iatən-iarəp nərgɨn e nɨganəmtɨ rəhak Tata e nego e neai. ");
INSERT INTO tnn_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Məto okəmə etəmim otən-iarəp e nɨganəmtɨ netəmim məmə in sənəmə rəhak, kən ekən-iarəp e nɨganəmtɨ rəhak Tata e nego e neai məmə in sənəmə rəhak. ");
INSERT INTO tnn_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Nɨkitəmat təsəhtən məmə emuwa məmə ekələhəu nəməlinuən e nətueintən. Eməsuwamən məmə ekələhəu nəməlinuən, məto emuwa məmə ekol netəmim kotəmou. ");
INSERT INTO tnn_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Iatən nəhlan məto-inu emuwa məmə ekol iərman otol tɨməht ilau rəhan tata, kən pətan otol tɨməht ilau rəhan mama, kən pətan otol tɨməht ilau uhun, ");
INSERT INTO tnn_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","kən etəmim otol tɨkɨmɨr ilat atɨp rəhan mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Kən etəmim itəm tolkeike pɨk rəhan tata ne mama taprəkɨs-in io, in təsahmenən məmə otuwa rəhak etəmim. Kən etəmim itəm tolkeike pɨk netɨn iərman o pətan taprəkɨs-in io, in təsahmenən məmə otuwa rəhak etəmim. ");
INSERT INTO tnn_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kən etəmim itəm təsɨləsən rəhan nɨg kəməluau muarisɨg-in io, in təsahmenən məmə otuwa rəhak etəmim. ");
INSERT INTO tnn_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kən etəmim itəm tatol pɨk wək əm məmə rəhan nəmegəhən e nətueintən u in otəwɨr, otəmkarəpən e nəmegəhən pahrien. Məto etəmim itəm otɨmɨs o nərgək, in otos nəmegəhən lilɨn. ");
INSERT INTO tnn_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Kən etəmim itəm tatos itəmat e nɨkin agien, kən tahmen əm məmə tatos io e nɨkin agien. Kən etəmim itəm tatos io e nɨkin agien, kən tahmen əm məmə tatos etəm u itəm təmahl-ipa io. ");
INSERT INTO tnn_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kən etəmim itəm tatos e nɨkin agien ien rəha Uhgɨn, məto-inu in tɨtun məmə suah u in ien rəha Uhgɨn, in otos nətouən lan, tahmen əm e itəm ien mɨn koatos. Kən etəmim itəm tatos e nɨkin agien etəm ətuatɨp, məto-inu in tɨtun məmə in etəm ətuatɨp, in otos nətouən lan, tahmen əm e etəm ətuatɨp. ");
INSERT INTO tnn_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kən etəmim itəm tatos-ipən nəhau ətəp noan-məsɨn əm kəm rəhak etəmim, məto-inu in tɨtun məmə rəhak etəmim, nat əpnapɨn rəhak etəmim in ləhau agɨn, nɨpahrienən iatən kəm itəmat məmə, okol təsəmkarəpənən e rəhan nətouən.” ");
INSERT INTO tnn_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nian Iesu tɨnol namnun nəgətunən rəhan netəm tuelef, təmiet ikɨn əh muwɨn e taon mɨn e nɨtən Kalili, matəgətun netəmim kən matən-iarəp nəghatən rəha Uhgɨn kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","E nian əh, Jon Baptais tətatɨg e kalapus, kən in təməto namnusən e wək itəm Iesu tatol. Kən təmahl-ipa rəhan neen netəmim kotuwɨn motətapəh ron məmə, ");
INSERT INTO tnn_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“?Tahro? ?Ik u etəm kəmatən aupən məmə suah kit otuwa, o itɨmat ekoatəsahgin etəmim kit mɨn məmə otəpanuwa mɨn?” ");
INSERT INTO tnn_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Kən Iesu təmən-ipən kəm ilat məmə, “Otuwɨn motəplan Jon motən-ipən nat naka itəm nəmotuwa motəto kən motəplan: ");
INSERT INTO tnn_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","netəm nɨganəmtɨlat təpɨs kɨnoatəplan nat. Kən netəmim itəm nelkɨlat tərat kɨnotəto təwɨr kən mɨnotaliwək. Kən netəm mɨn u kəmotos nɨmɨsən leprosi, nuwigɨlat tɨnəwɨr. Kən netəm mɨn u matəlgɨlat təmalu, roiu matəlgɨlat tɨnoag, kən netəm mɨn u kəmotɨmɨs, kɨnotəmegəh mɨn. Kən ian-rat mɨn, roiu əh suah kit tɨnatən-iarəp namnusən təwɨr kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Etəmim otatɨg e nəwɨrən pahrien okəmə in təsəhlmanən rəhan nahatətəən lak o natɨmnat itəm io ekol.” ");
INSERT INTO tnn_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nian netəmim rəha Jon koatɨtəlɨg, kən Iesu tɨnətuoun matəghat-in Jon kəm netəm mɨn u koatəpələh əh-ikɨn, matən məmə, “?Aupən, nəmotuwɨn ikɨn taruən-aruən ikɨn məmə nəkotəplan naka? ?Nəmotuwɨn məmə nəkotəplan suah kit tahmen e nuwig itəm nɨmətag tətahləpɨk-ahləpɨk əpnapɨn əm? Kəp. ");
INSERT INTO tnn_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","?Kən tahro itəmat nəmoatiet, məmə nəkotəplan suah kit itəm tatuwɨn e napən wɨr nəmtɨn tiəkɨs? Kəp. Netəm kotuwɨn e napən wɨr tol nəhlan, nian rafin kotatɨg e nimə rəha kig. ");
INSERT INTO tnn_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","?Kən tahro itəmat nəkoatiet, məmə nəkotəplan ien kit? Əwəh, nɨpahrienən, kən etəmim əh in ilɨs taprəkɨs-in ien. ");
INSERT INTO tnn_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Inu etəm Naoa Rəha Uhgɨn təmatəghat-in nian Uhgɨn təmən məmə, ‘Otəplan-tu. Iatahl-ipɨnə rəhak iahləpis itəm otos rəhak nəghatən. In otaupən-in ik məmə otol əpen-əpenə e rəham suatɨp.’ ");
INSERT INTO tnn_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nɨpahrienən iatən kəm itəmat, etəmim tɨkə itəm təmaiir e nətueintən in ilɨs taprəkɨs-in Jon Baptais, kən məto etəm ləhau agɨn e nərəmərəən rəha Uhgɨn, in ilɨs taprəkɨs-in Jon. ");
INSERT INTO tnn_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","E nian Jon Baptais təmətuoun matən-iarəp nəghatən rəha Uhgɨn mətoarus-pa roiu, nərəmərəən rəha Uhgɨn in təskasɨk məmə otol wək matuwɨn. Kən netəmim itəm kotəskasɨk kotalkut pɨk məmə okotuwɨn motatɨg ahgin. ");
INSERT INTO tnn_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Iatən nəhlan məto-inu, aupən agɨn mətoarus-pa nian rəha Jon, nəghatən mɨn rəha Lou itəm Uhgɨn təmos-ipən kəm Moses, ne nəghatən mɨn rəha ien mɨn rəha Uhgɨn, koatən-iarəp nərəmərəən rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kən okəmə nɨkitəmat tagien məmə nakotos nətəlɨgən u, ekən məmə Jon in Elaija itəm in ien kit aupən kəmatən məmə otuwa. ");
INSERT INTO tnn_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Etəm matəlgɨn tatɨg, təwɨr məmə in otətəlɨg-in wɨr kən mɨtun nəghatən mɨn u. ");
INSERT INTO tnn_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“?Netəm mɨn u itəm koatatɨg roiu, ilat kotəhrol nulan? Ilat kotahmen e nɨsualkələh itəm koatəpələh ikɨn katol maket ikɨn moatakuhl motaun-in ilat mɨn neen məmə, ");
INSERT INTO tnn_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Itɨmat emotahl nau kəm itəmat məmə onakoatol danis rəha nagienən lan, məto itəmat nəkəsotolən danis. Kən itɨmat emoatasək eiuə rəha nɨmɨsən, məto nəsotasəkən kitat min itɨmat.’ ");
INSERT INTO tnn_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Iatən nəhlan məto-inu Jon təmuwa, kən matətuakəm mətapəs nagwənən matəfak kəm Uhgɨn, kən məsənɨmən wain. Kən netəmim kotən məmə, ‘Suah əh, narmɨn rat kit tətatɨg lan.’ ");
INSERT INTO tnn_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Məto nian io, Nətɨ Etəmim, emuwa kən mətagwən kən matənɨm wain, kən netəmim kotən məmə, ‘Otəplan-tu, suah əh in etəmim rəha nagwən pɨkən ne etəmim rəha napɨsən, kən motan kələh ilat netəmim rəha nosən məni e takɨs, ne netəmim itəm nol təfagə.’ Məto netəmim itəm koatətəu-pən nɨtunən rəha Uhgɨn koatol wək wɨr mɨn. Kən wək wɨr mɨn əh koatəgətun məmə nɨtunən rəha Uhgɨn in nɨpahrienən.” ");
INSERT INTO tnn_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kən Iesu təməghat əskasɨk e netəm e taon mɨn əh itəm in təmol nat pɨspɨs tepət ikɨn e nɨganəmtɨlat. Təməghat nəhlan məto-inu ilat kəsotəuhlinən nətəlɨgən rəhalat o rəhalat nolən rat mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Təmən məmə, “!Itəmat netəm Korasin, kəsi, nahməən asol otuwa otəmat! !Itəmat netəm Petsaeta, kəsi, nahməən asol otuwa otəmat! Məto-inu emol pap nat pɨspɨs tepət e taon rəhatəmat! Kən okəmə emol natɨmnat mɨn əh əpəh Taea ne Saeton aupən, okol netəmim əh-ikɨn əh kəmotəuhlin rəhalat nətəlɨgən e nolən rat mɨn, kən ilat kəmotuwɨn e natɨmnat rat motuwɨn moatəpələh e nəmtap e nɨgəm motəgətun məmə koatəto tərat agɨn o rəhalat nolən rat mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Məto iatən kəm itəmat məmə e nian əh itəm Uhgɨn otol nalpɨnən kəm netəmim, nalpɨnən rəhatəmat in otəskasɨk, maprəkɨs-in nalpɨnən rəha netəm Taea ne Saeton aupən ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“?Kən itəmat netəm Kapaneam, nɨkitəmat təht məmə Uhgɨn otɨləs-ipər itəmat e ikɨn rəha nɨsiaiiən əpəh e nego e neai? !Kəp! Məto Uhgɨn otəhlman itəmat nakotuwɨn ləhau agɨn, imə naulɨsən, məto-inu emol nat pɨspɨs tepət e taon rəhatəmat. Kən okəmə emol natɨmnat mɨn əh əpəh Sotom, kən netəm ikɨn kəmotəuhlin rəhalat nətəlɨgən, kən okol Uhgɨn təməsərəkɨnən Sotom, kən təmətatɨg əm mətoarus-pa u-roiu. ");
INSERT INTO tnn_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Məto iatən kəm itəmat məmə e nian əh itəm Uhgɨn otol nalpɨnən kəm netəmim, nalpɨnən rəhatəmat in otəskasɨk, taprəkɨs-in nalpɨnən rəha netəm Sotom aupən ikɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kən e nian əh, Iesu təməfak matən məmə, “Tata Uhgɨn, ik Iərəmərə rəha natɨmnat rafin ilɨs e neai ne ləhau e nətueintən. Iatənwiwi ik məto-inu nəməhluaig-in nɨpətɨ natɨmnat mɨn u e nɨganəmtɨ netəmim itəm kotenatɨg motɨtun wɨr nat. Kən nəmol-arəp kəm netəmim itəm kotahmen-pən əm e nɨsualkələh məmə okotɨtun wɨr. ");
INSERT INTO tnn_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Əwəh, Tata, inu nat kit itəm nakolkeike.” ");
INSERT INTO tnn_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kən Iesu təmatəkəike matən kəm ilat məmə, “Rəhak Tata təmos-ipa nɨtunən rafin agɨn kəm io. Kən suah kit tɨkə itəm tɨtun wɨr io u Nətɨ Uhgɨn, məmə io pah ətuatɨp. Məto Tata Uhgɨn əm tɨtun. Kən suah kit tɨkə itəm tɨtun wɨr Uhgɨn, məto io pɨsɨn əm u Nətɨ Uhgɨn, ekɨtun, ne netəmim itəm io emɨtəpun məmə ekol-arəp Tata Uhgɨn kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Otuwa ron io, itəmat itəm nəkotol pɨk wək kən nɨnotəpou o natipa-inən katipa əfɨgəm mɨn, kən ekos-ipɨnə namegən. ");
INSERT INTO tnn_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Pəs kotalis rəhak katipa, kən pəs iakaupən məgətun itəmat lan. Iatən nəhlan məto-inu io etəm mətɨg, kən rəhak nətəlɨgən in ləhau. Kən onəkotos namegən e rəhatəmat nəmegəhən. ");
INSERT INTO tnn_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tol nəhlan məto-inu rəhak wək ekos-ipɨnə kəm itəmat in tɨmətɨg, kən rəhak katipa in toigoig.” ");
INSERT INTO tnn_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kən e nian əh e Sapat kit, Iesu ne rəhan mɨn netəmim kəmotaliwək motuwɨn-pən e nasumən rəha wit, nat kit tahmen e rais, kən rəhan netəmim nəumɨs təmus ilat, kən kəmotəhl noa wit kən motun. ");
INSERT INTO tnn_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Məto nian Farisi mɨn kəmotəplan ilat, kən kəmotən-ipən kəm Iesu məmə, “!Ei, əplan-tu! Rəham netəmim koatol nat kit itəm koatətgəhl Lou rəha Sapat.” ");
INSERT INTO tnn_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Kən Iesu təmən-ipən kəm ilat məmə, “?Nəmotafin o kəp, nat naka itəm Kig Tefɨt təmol aupən, nian in ne rəhan mɨn netəmim nəumɨs təmus ilat? ");
INSERT INTO tnn_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","In təmuwɨn imə e Nimə Tapolen Rəha Uhgɨn, kən mos pɨret mun itəm pris mɨn kɨnotos-ipən rəkɨs kəm Uhgɨn. Kən nolən əh tatətgəhl Lou, məto-inu pɨret əh, Lou tatən məmə pris mɨn əm kotɨtun nunən. ");
INSERT INTO tnn_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","?Kən nəmotafin e Lou o kəp, məmə nian rafin e Sapat, pris mɨn əpəh e Nimə Rəha Uhgɨn, ilat koatol wək rəhalat itəm tatətgəhl Lou rəha Sapat? Məto Uhgɨn tatəplan məmə nat əh in tətuatɨp əm. ");
INSERT INTO tnn_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Məto iatən kəm itəmat məmə suah kit u ikɨn-u in ilɨs taprəkɨs-in Nimə Rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","E Naoa Rəha Uhgɨn, in tatən məmə, ‘Nat kit tatol nɨkik tətagien, inu məmə onəkotasəkitun netəmim, məto sənəmə rəhatəmat sakrifais mɨn itəm nəkoatol moatos-ipa kəm io itəm tatol nɨkik tətagien.’ Okəmə nəkotɨtun nɨpətɨ nəghatən u, kən netəm mɨn u itəm kotətuatɨp, okol nəsotakilən ilat motən məmə ilat koatol nolən rat. ");
INSERT INTO tnn_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Iatən nəhlan məto-inu io, Nətɨ Etəmim, io Iərəmərə rəha Sapat.” ");
INSERT INTO tnn_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kən Iesu təmiet ikɨn əh, maliwək matuwɨn əpəh imə e nimə rəha nuəfɨmɨnən rəhalat. ");
INSERT INTO tnn_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kən əmun ikɨn əh, suah kit əh-ikɨn nelmɨn təmɨmɨs, təsəg-ətuatɨp-inən. Kən kəmotətapəh o Iesu məmə, “?Tahro? ?In tətuatɨp e Lou məmə e Sapat, etəmim tɨtun nol-wɨrən etəmim itəm tatɨmɨs?” Ilat kəmotətapəh ron məto-inu koategəs-in nat tərat kit rəha Iesu itəm ilat okotɨləs-ipən in e kot ron. ");
INSERT INTO tnn_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Kən Iesu təmən-ipən kəm ilat məmə, “?Okəmə itəmat kit rəhan kit sipsip, kən sipsip un tiwɨg-pən e noakɨmɨl e Sapat, nɨkitəmat təht məmə suah əh otuwɨn miuw-pər-pa mɨn? !Əwəh! Otəkəike muwɨn miuw-pər. ");
INSERT INTO tnn_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","!Məto etəmim, in nat keike taprəkɨs-in sipsip! Kənu, in tətuatɨp əm e Lou məmə natol nat itəm təwɨr e Sapat.” ");
INSERT INTO tnn_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kən təmən-ipən kəm etəm nelmɨn təmɨmɨs məmə, “Əg-ətuatɨp-in-tu nelməm.” Kən təməg-ətuatɨp-in nelmɨn, kən nelmɨn tɨnuwa mɨnəwɨr agɨn mɨn, tɨnahmen e nelmɨn kit mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Məto Farisi mɨn kəmotiet motuwɨn ihluə mɨnoatəte noa ron məmə okotohamnu Iesu. ");
INSERT INTO tnn_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Kən Iesu təmɨtun nətəlɨgən rəhalat, kən təmiet ikɨn əh. Kən netəmim tepət kəmotuarisɨg in. Kən in təmol-wɨr nɨmɨsən rafin rəhalat kotuwa motəwɨr mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Kən təmən-iəhau ilat məmə okəsotən-iarəpən in kəm netəmim mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Natɨmnat mɨn əh kəmotiet məmə nəghatən rəha Naoa Rəha Uhgɨn otuwa mol nɨpahrienən lan. Uhgɨn təmos-ipən kəm ien Aesea u aupən o nən-iarəpən məmə, ");
INSERT INTO tnn_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Inu iolwək rəhak itəm io enɨtəpun rəkɨs, iakolkeike pɨk in, kən nɨkik tagien pɨk ron. Kən io oekol məmə Narmɨn Rəhak otuwa mərioah lan. Kən in otən-iarəp nolən ətuatɨp rəhak ne nosmegəhən rəhak e nɨganəmtɨ netəmim e nəptən pɨsɨn pɨsɨn mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Okol in təsərgəhəuən kən məsagət əfəməhən, məsəghat pɨkən ikɨn netəmim kotargəfɨmən ilat mɨn ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","In etəm mətɨg, kən in otol təwɨr kəm netəmim itəm koatəpou kən rəhalat nəsanənən tɨkə. In otol nəhlan mətoarus-pa nolən itəm in tətuatɨp, otol win e nolən itəm tərat. ");
INSERT INTO tnn_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kən netəm u sənəmə noanol mɨn rəha Isrel, ilat okotələhəu-pən əskasɨk rəhalat nətəlɨgən tətatɨg lan, məmə in otosmegəh ilat.” ");
INSERT INTO tnn_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kən netəmim kəmotɨləs suah kit motuwa kəm Iesu itəm nɨganəmtɨn təpɨs kən təsəghatən məto-inu narmɨn rat kit tətatɨg lan. Kən Iesu təmol-wɨr mɨn, kən suah əh tənatəplan nat kən mɨnatəghat. ");
INSERT INTO tnn_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kən netəmim rafin narmɨlat təmiwɨg motən məmə, “?Okəmə naka suah u in Mipɨ Kig Tefɨt itəm Uhgɨn təmən məmə otahl-ipa?” ");
INSERT INTO tnn_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kən nian Farisi mɨn kəmotəto nat əh ne nəghatən lan, kən kəmotən məmə, “Suah əh tatəhg-iarəp narmɨn rat mɨn e nəsanənən əm rəha Pielsepul u etəm-iasol rəha narmɨn rat mɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Məto Iesu tɨtun nətəlɨgən rəhalat, kən təmən-ipən kəm ilat məmə, “Okəmə netəmim e kantri kit koatoor ilat mɨn, kən okotərəkɨn rəhalat kantri. Kən tahmen-pən əm e taon kit o latuənu kit, okəmə netəmim kotoor ilat mɨn, kən okotərəkɨn taon un o latuənu un. ");
INSERT INTO tnn_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","“Kən okəmə Setan tatəhg-iarəp narmɨn rat mɨn rəhan e netəmim, kən tatol atɨp əm tɨkɨmɨr kəm in. ?Kən otahro nulan, rəhan nərəmərəən otətul? ");
INSERT INTO tnn_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","?Kən okəmə io iatəhg-iarəp narmɨn rat mɨn e nəsanənən rəha Pielsepul, kən tahro e rəhatəmat mɨn netəmim? ?Ilat koatəhg-iarəp narmɨn rat mɨn e nəsanənən rəha pah? ?Rəha Setan? Kəp. Kən tərat məmə nakoatən məmə io iatol nəhlan. Tol nəhlan, rəhatəmat netəmim okotakil nəghatən mɨn rəhatəmat, motən məmə in neiueiuəən. ");
INSERT INTO tnn_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Məto okəmə iatəhg-iarəp narmɨn rat mɨn e nəsanənən rəha Narmɨn Rəha Uhgɨn, kən nərəmərəən rəha Uhgɨn tɨnuwa rəkɨs otəmat. ");
INSERT INTO tnn_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Kən ekən e suatɨp kit mɨn tol nulan məmə, etəmim kit tɨkə məmə tɨtun nuwɨnən e nimə rəha etəmim kit itəm təsanən məmə otəmɨk rəhan natɨmnat. Məto otaupən məlis ətain etəm u itəm təsanən, uarisɨg təpanuwɨn imə məmki-rəkɨs rəhan natɨmnat. ");
INSERT INTO tnn_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Etəm u itəm təsuarisɨg-inən io, in rəhak tɨkɨmɨr. Kən etəm u itəm təsargətainən sipsip mɨn, in tatoor ilat kotagɨm atit. ");
INSERT INTO tnn_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Tol nəhlan iatən kəm itəmat məmə, Uhgɨn otafəl rəkɨs nolən rat mɨn rafin pɨsɨn pɨsɨn, ne nəghatən rat mɨn rafin pɨsɨn pɨsɨn itəm netəmim koatən lan, məto otol nalpɨnən kən məsaluinən nəghatən rat mɨn itəm netəmim koatən e Narmɨn Rəhan. ");
INSERT INTO tnn_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kən okəmə etəmim tatən rat io, Nətɨ Etəmim, kən Uhgɨn otaluin kən məsalpɨnən. Məto etəmim itəm tatən rat Narmɨn Rəha Uhgɨn, Uhgɨn okol təsaluinən nian kit, e nətueintən u, ne e nian itəm tatuwa. ");
INSERT INTO tnn_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Okəmə nɨg in təwɨr, kən noan in təwɨr, okəmə nɨg in tərat, kən noan in tərat. Tol nəhlan məto-inu itəmat nəkotəplan əm e noa nɨg məmə nɨg in təwɨr o nɨg in tərat. ");
INSERT INTO tnn_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","!Itəmat nəkotahmen e sɨnek! Itəmat noatol nolən eko-eko, kən itəmat netəm nakotərat. Okol nəsotənən nat təwɨr kit, məto-inu nian etəmim tatəghat, tatən əm nat naka itəm tərioah e nɨkin. ");
INSERT INTO tnn_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Etəmim itəm nətəlɨgən təwɨr tərioah e nɨkin, nian rafin in tatən nat itəm in təwɨr. Kən etəmim itəm nətəlɨgən rat tərioah e nɨkin, nian rafin in tatən nat itəm tərat. ");
INSERT INTO tnn_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Iatən kəm itəmat məmə e nian Uhgɨn otakil netəmim lan, netəmim okotəkəike kən-iarəp kəm in məmə tahro ilat kəmoatən nəghatən rat əpnapɨn mɨn rafin rəhalat. ");
INSERT INTO tnn_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tol nəhlan, in otakil rafin nəghatən pɨsɨn mɨn rəhatəmat, məmə itəmat netəm kotətuatɨp o netəm kotərat.” ");
INSERT INTO tnn_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kən iəgətun mɨn neen rəha Lou ne Farisi mɨn kəmotən-ipən kəm in məmə, “Iəgətun. Ekotolkeike məmə ekotəplan nəmtətin kit itəm tapɨspɨs itəm ik onəkol.”; ");
INSERT INTO tnn_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Məto təmən-ipən kəm ilat məmə, “Itəmat netəm roiu ne, nakotərat, nəmotapəs rəhatəmat nahatətəən o Uhgɨn, tahmen e pətan kit tapəs rəhan iərman matətəu-pən suah pɨsɨn. Kən roiu nakotolkeike məmə ekol nəmtətin kit itəm otəgətun məmə emɨsɨ-pən o Uhgɨn. Məto Uhgɨn otos-ipən əm nəmtətin kitiəh əm, kən inəh nəmtətin rəha ien əh Jona. ");
INSERT INTO tnn_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tahmen əm məmə Jona təməməhl e nian kɨsɨl lapɨn ne nərauiəgən e nərpɨ nəm asol, kən Nətɨ Etəmim, in otəməhl nian kɨsɨl lapɨn ne nərauiəgən əpəh e nɨki nəptən. ");
INSERT INTO tnn_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“E nian əh itəm Uhgɨn otakil netəmim rafin, kən netəm Nineva aupən, ilat okotətul motən-iarəp məmə itəmat noanol rəha Isrel nakotərat. Okotɨtun nənən nəhlan məto-inu nian ilat kəmotəto nəghatən rəha ien əh Jona, ilat kəmotəuhlin rəhalat nətəlɨgən o rəhalat nolən rat mɨn. Kən otəplan-tu, suah kit itəm ilɨs taprəkɨs-in Jona tɨnuwa. ");
INSERT INTO tnn_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kən e nian əh itəm Uhgɨn otakil netəmim rafin, kən kwin rəha nəptən pis ikɨn, in otətul mən-iarəp məmə itəmat netəm nakotərat. Otɨtun nənən nəhlan məto-inu, in təmiet e nɨkalɨn nəptən əpəh isəu agɨn, kən maliwək muwa məmə otəto nəghatən rəha Kig Solomon itəm tenatɨg wɨr. Kən otəplan-tu, suah kit itəm ilɨs taprəkɨs-in Kig Solomon tɨnuwa. ");
INSERT INTO tnn_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Nian narmɨn rat tiet e etəmim, kən in otuwɨn maliwək mətan əpəh ikɨn nɨg ne niamɨtə tɨkə ikɨn, kən nəhau tɨkə ikɨn, mategəs-in ikɨn otatɨg mameg ikɨn, məto təsəplanən. ");
INSERT INTO tnn_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Kən tən atɨp əm kəm in məmə, ‘Ekɨtəlɨg-pən e rəhak nimə itəm emɨsɨ-pən ikɨn.’ Kən nian tuwa məplan nimə, etəmim tɨkə ikɨn, kən kəmafəl, kən məlɨn wɨr natɨmnat. ");
INSERT INTO tnn_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kən tuwɨn mit narmɨn rat sepɨn mɨn itəm kotərat pɨk taprəkɨs-in in, kən motuwɨn imə motatɨg, kən natɨgən rəha suah əh roiu tərat pɨk taprəkɨs-in rəhan natɨgən itəm aupən. Kən kotahmen əm e itəmat netəm kotərat itəm nəkotatɨg roiu.” ");
INSERT INTO tnn_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nian Iesu tatəghat əh kəm netəmim, kən rəhan mama ne pian mɨn koatətul əpəh ihluə moatətapəh-in məmə okotəghat kəm in. ");
INSERT INTO tnn_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kən etəmim kit təmən-ipən kəm Iesu məmə, “Rəham mama ne piam mɨn əpəh ihluə koatətul. Ilat kotolkeike məmə okotəghat kəm ik.” ");
INSERT INTO tnn_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Kən Iesu təmən-ipən kəm suah əh itəm təmən-iarəp məmə, “?Pah u rəhak mama, kən pah u piak mɨn?” ");
INSERT INTO tnn_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kən məg-ətuatɨp-in-pən nelmɨn məgətun-pən rəhan netəmim, kən mən məmə, “!Inu rəhak mama ne piak mɨn! ");
INSERT INTO tnn_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Iatən nəhlan məto-inu pah u tatol nəwia rəhak Tata əpəh ilɨs e nego e neai, in piak, ne wɨnɨk, ne rəhak mama.” ");
INSERT INTO tnn_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","E nian ətuatɨp əh, Iesu təmiet e nimə muwɨn matəpələh əpəh iuəhkɨr e nɨkalɨ Lek Kalili. ");
INSERT INTO tnn_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Məto-inu netəmim tepət kəmotuwa kətul kɨtəlau in, kən in təmuwɨn e bot kit matəpələh. Kən netəmim kəmoatətul ipar. ");
INSERT INTO tnn_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kən in təmən-ipən natɨmnat tepət kəm ilat e nimaa nəghatən mɨn. Təmən məmə, “Etəmim kit təmuwɨn məmə oteatəgtəg rəhan nɨkuti wit əpəh e rəhan nasumən. ");
INSERT INTO tnn_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kən nian təmərakin-rakin rəhan nɨkuti wit, neen kəmotɨsas-pən e suatɨp, kən mənɨg mɨn kəmotuwa motun ilat rafin. ");
INSERT INTO tnn_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kən nɨkuti wit neen kəmotɨsas-pən e nəptən itəm kəpiel iuəhkɨr əm. Kəmotəwiə uəhai əm məto-inu nəptən noan məsɨn əm. ");
INSERT INTO tnn_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Məto nian mɨtgar tər, kən məhg ilat koatauke-auke məto-inu nokɨlat təseiuaiu pɨkən. ");
INSERT INTO tnn_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kən nɨkuti wit neen kotɨsas-pən e nɨki nəlkosɨk, kən nian nɨkuti wit kotəwiə məto nəlkosɨk tətatu-atu ilat kən kəmotamɨs. ");
INSERT INTO tnn_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kən nɨkuti wit neen mɨn kəmotɨsas-pən e nəptən itəm təwɨr, kən kəmotoe-in noalat, neen noalat wan-hanrɨt, neen noalat sikiste, neen noalat tate. ");
INSERT INTO tnn_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Etəm matəlgɨn tatɨg, təwɨr məmə in otətəlɨg-in wɨr kən mɨtun nəghatən mɨn u.” ");
INSERT INTO tnn_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kən netəm rəha Iesu kəmotuwa motətapəh ron məmə, “?Tahro natəghat kəm netəmim e nimaa nəghatən mɨn?” ");
INSERT INTO tnn_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Kən Iesu təmən-ipən kəm ilat məmə, “Iatən nəhlan məto-inu itəmat un, Uhgɨn təmerəh e suatɨp otəmat məmə itəmat onəkotɨtun nəghatən anion mɨn rəha nərəmərəən rəha Uhgɨn. Məto ilat əh, Uhgɨn təməserəhən e suatɨp nulan olat. ");
INSERT INTO tnn_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tol nəhlan məto-inu, etəm u itəm rəhan əh-ikɨn nɨtunən, Uhgɨn otos-ipən mɨn nɨtunən kəm in, kən rəhan nɨtunən in otepət pɨk. Məto etəm u itəm rəhan nɨtunən tɨkə, Uhgɨn otos-irəkɨs rafin rəhan nɨtunən itəm nɨkin təht məmə in tatos. ");
INSERT INTO tnn_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Iatəghat e nimaa nəghatən kəm ilat məto-inu ilat koatəplan pap məto kəsotɨtunən, kən ilat koatəto pap məto kəsotɨtun wɨrən. ");
INSERT INTO tnn_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nəmegəhən rəhalat tatol nəghatən rəha ien Aesea tatuwa matol nɨpahrienən lan. In təmən məmə, ‘Okoatəto, moatəto, moatəto, məto okol kəsotɨtunən. Kən okoatəplan, moatəplan, moatəplan, məto okol kəsotɨtunən nian kit. ");
INSERT INTO tnn_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tol nəhlan məto-inu nɨkilat tɨnuwa məskasɨk, kən kɨnotəpou-in nətəlɨg-inən, kən motahtosɨg-in nɨganəmtɨlat. Okəmə təsolən nəhlan, okəm-naka ilat okotəplan e nɨganəmtɨlat, kən ilat okotətəlɨg-in e matəlgɨlat, kən nɨkilat otəmət-mətɨg, kən okotɨtun, kən okotəuhlin-pa ilat ron io məmə ekosmegəh ilat.’ ");
INSERT INTO tnn_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Məto itəmat u, Uhgɨn təmawte-in rəhan nəwɨrən kəm itəmat, kən nian nəkotəplan, nəkotɨtun, kən nian nakotəto, nəkotɨtun. ");
INSERT INTO tnn_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nɨpahrienən iatən kəm itəmat məmə, ien mɨn tepət ne netəm ətuatɨp mɨn tepət kəmotolkeike pɨk məmə okotəplan nat naka itəm nakoatəplan, məto kəsotəplanən. Kən motolkeike pɨk məmə okotəto nat naka itəm nakoatəto, məto kəsotətoən.” ");
INSERT INTO tnn_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Kən Iesu təmatəkəike matən məmə, “Itəmat otətəlɨg-in wɨr-tu məmə nəkotɨtun nɨpətɨ nimaa nəghatən rəha etəm u itəm təmərakin nɨkuti wit. ");
INSERT INTO tnn_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nɨkuti wit itəm təmɨsas e suatɨp, in tahmen e etəmim itəm təto nəghatən rəha nərəmərəən rəha Uhgɨn, məto in təsɨtunən. Kən Setan tuwa mos-irəkɨs uəhai əm nəghatən əh itəm təmuwɨn e nɨkin. ");
INSERT INTO tnn_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“Kən nɨkuti wit itəm təmɨsas-pən e nɨsɨp itəm kəpiel iuəhkɨr əm, in tahmen e etəmim itəm tatəto nəghatən rəha Uhgɨn, kən mos e nɨkin agien, ");
INSERT INTO tnn_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","məto nokɨn təseiuaiu pɨkən, kən tatətul əm o nian əkuəkɨr əm. Nian nəsəsauən, o nəratən tuwa e nəmegəhən rəhan o nəghatən əh, kən təme uəhai əm e rəhan nahatətəən. ");
INSERT INTO tnn_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Kən nɨkuti wit itəm təmɨsas-pən e nɨki nəlkosɨk, in tahmen e etəmim itəm təto nəghatən rəha Uhgɨn, məto rəhan nətəlɨgən tatuwɨn pɨk o natɨmnat rəha nətueintən, kən in tolkeike məmə rəhan nautə otepət, kən nətəlɨgən mɨn əh kotatu-atu nəghatən rəha Uhgɨn, kən nəghatən əh təsoe-inən noan. ");
INSERT INTO tnn_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Məto nɨkuti wit itəm təmɨsas-pən e nəptən wɨr, in tahmen e etəmim itəm təto nəghatən rəha Uhgɨn kən mɨtun nɨpətɨn. Kən e nəmegəhən rəhan, in otoe-in noan, nian neen noan wan-hanrɨt, nian neen noan sikiste, kən nian neen noan tate.” ");
INSERT INTO tnn_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Kən Iesu təmuəh nimaa nəghatən kit mɨn kəm ilat matən məmə, “Nərəmərəən rəha Uhgɨn, in tahmen e etəmim kit itəm təmərakin nɨkuti wit e rəhan nasumən. ");
INSERT INTO tnn_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Məto nian in ne rəhan mɨn netəmim kəmoatapɨl, rəhan kit tɨkɨmɨr təmuwɨn mərakin nɨkuti manuwɨhl rat mɨn e rəhan nasumən, kən magɨm. ");
INSERT INTO tnn_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kən nɨkuti wit wɨr mɨn kəmotəwiə motol iahgin motol noalat. Məto e nian əh, nɨkuti manuwɨhl rat mɨn kəmotər mɨn motuwa motol iahgin. ");
INSERT INTO tnn_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Kən slef mɨn rəha etəmim əh, kəmotuwa motəplan in, motən məmə, ‘Etəm-iasol. ?Nɨkuti wit mɨn itəm nəmərakin e rəham nasumən, ilat nɨkuti wit wɨr mɨn əm, o kəp? ?Məto tahro nɨkuti manuwɨhl rat mɨn kɨnotər?’ ");
INSERT INTO tnn_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Kən təmən-ipən kəm ilat məmə, ‘Tɨkɨmɨr kit təmol nat əh.’ “Kən rəhan slef mɨn kotən-ipən kəm in məmə, ‘?Məto tahro? ?Nakolkeike məmə itɨmat ekotuwɨn kew rəkɨs manuwɨhl rat mɨn əh?’ ");
INSERT INTO tnn_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Məto təmən-ipən kəm ilat məmə, ‘Kəpə. Otapəs. Okəmə itəmat nakotuwɨn kew rəkɨs manuwɨhl rat mɨn, kən məta nakotew rəkɨs mɨn wit wɨr mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pəs ilau kərən əm kuər mətoarus-pən wit tɨnɨmətə. Kən ekən-ipən kəm netəmim itəm okotəulək-in wit məmə ilat okotaupən motew rəkɨs manuwɨhl itəm tərat motəlis o nərakin-pənən e nɨgəm. Uarisɨg okotəulək-in wit wɨr mɨn moatəmɨk moatuwa e nɨpəgnoa nimə rəhak itəm katəlɨn nagwənən ikɨn.’” ");
INSERT INTO tnn_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Kən Iesu təmuəh nimaa nəghatən kit mɨn kəm ilat məmə, “Nərəmərəən rəha Uhgɨn in tahmen e nɨkuti mastat itəm etəmim təmos muwɨn məfe e rəhan nasumən. ");
INSERT INTO tnn_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nɨkuti mastat əh in nətɨn agɨn, məto nian in otəwiə, in otuwa iahgin tahmen e nɨg kit, kən mənɨg mɨn itəm koatiwɨg ilɨs okotuwa motol nimaalat e nelmɨn mɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Kən Iesu təmuəh nimaa nəghatən kit mɨn məmə, “Nərəmərəən rəha Uhgɨn in tahmen-pən e is noan məsɨn itəm pətan kit tətalkin e flaoa tepət itəm kəmol-pən e pesɨn asol, kən tətahl flaoa rafin tətasis matol iahgin.” ");
INSERT INTO tnn_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Natɨmnat mɨn əh rafin, Iesu təmuəh nimaa nəghatən lan kəm netəmim. Nɨpahrienən məmə təməsənən nat kit kəm ilat okəmə təməsuəhən nimaa nəghatən. ");
INSERT INTO tnn_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nolən əh təmol nəghatən rəha ien aupən tatuwa matol nɨpahrienən lan. Təmən məmə, “Ekən-iarəp rəhak nəghatən e nuəhən nimaa nəghatən mɨn. Ekən-iarəp natɨmnat itəm eməhluaig-in ilat nian emətuoun matol nətueintən mətoarus-pa u-roiu.” ");
INSERT INTO tnn_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kən Iesu təmiet rəkɨs e netəmim, kən muwɨn e nɨpəgnoa nimə kit. Kən rəhan mɨn netəmim kəmotuwa ron motətapəh məmə, “Ən-tu kəm itɨmat nɨpətɨ nimaa nəghatən e manuwɨhl itəm təmər e nasumən.” ");
INSERT INTO tnn_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kən Iesu təmən-ipən məmə, “Etəmim itəm təmərakin nɨkuti wit e nasumən, inu io, Nətɨ Etəmim. ");
INSERT INTO tnn_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kən nasumən, in nətueintən, kən nɨkuti wit wɨr mɨn, ilat u netəmim rəha Uhgɨn itəm tatərəmərə elat. Kən manuwɨhl rat mɨn, ilat netəmim rəha Setan. ");
INSERT INTO tnn_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kən tɨkɨmɨr itəm təmuwɨn mərakin manuwɨhl rat, in Setan. Kən nian okəulək-in nasumən, in namnun nian, kən netəmim itəm koatəulək e nasumən, ilat u nagelo mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Okotəmɨk manuwɨhl rat motan-ətɨp e nɨgəm, nolən əh tahmen əm e namnun nian. ");
INSERT INTO tnn_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","“Io Nətɨ Etəmim, ekahl-ipɨnə nagelo mɨn rəhak okotuwɨn ikɨn iatərəmərə ikɨn, motoe rəkɨs natɨmnat rafin ne netəmim rafin itəm koatiuw-pən netəmim o nolən təfagə rat mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ilat okotərakin-pən ilat e nɨgəm asol, kən ikɨn əh netəmim okotasək kən moatəgətain nəluɨlat mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kən netəm kotətuatɨp okotasiə tahmen e mɨt e nərəmərəən rəha rəhalat Tata Uhgɨn. Etəm matəlgɨn tatɨg, in otəkəike mətəlɨg-in wɨr nəghatən mɨn u.” ");
INSERT INTO tnn_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Kən Iesu təmatəkəike matən məmə, “Nərəmərəən rəha Uhgɨn in tahmen e bokis məni kit itəm tatəhluaig e nəptən kit. Kən etəmim kit təmətan məplan bokis məni əh, kən tatɨg mɨtənɨm mɨn. Nɨkin təmagien pɨk, kən təmuwɨn mol-salɨm-in natɨmnat rafin rəhan, kən mos-nəmtɨn nəptən əh.” ");
INSERT INTO tnn_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kən Iesu təmən məmə, “Nərəmərəən rəha Uhgɨn in tahmen e etəmim itəm tategəs-in natɨmnat, kən matol-salɨm-in mɨn. Kən in tategəs-in kəpiel wɨr mɨn nəmtɨlat tiəkɨs, katən məmə perel. ");
INSERT INTO tnn_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nian təməplan perel kit itəm təwɨr pɨk agɨn, kən in təmuwɨn mol-salɨm-in rəhan natɨmnat rafin, kən muwɨn mos-nəmtɨn perel əh kən mɨləs rəhan.” ");
INSERT INTO tnn_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Kən Iesu təmatəkəike matən məmə, “Nərəmərəən rəha Uhgɨn in tahmen e nian netəmim koatərakin-pən net əpəh itəhəi moatos nəm pɨsɨn pɨsɨn mɨn lan. ");
INSERT INTO tnn_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nian net tɨnərioah e nəm, kən kotiuw-par net, kən motoor nəm mɨn motaii-pən nəm wɨr mɨn e kətɨm asol mɨn rəhalat, məto okotərakin nəm itəm kotərat. ");
INSERT INTO tnn_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kən e namnun nian, nagelo mɨn okotuwa motos-irəkɨs netəmim itəm kotərat o netəmim itəm kotətuatɨp, ");
INSERT INTO tnn_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","kən motərakin-pən netəm kotərat e nɨgəm asol, kən ikɨn əh netəmim okotasək moatəgətain nəluɨlat. ");
INSERT INTO tnn_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“?Itəmat nəkotɨtun natɨmnat mɨn un, o kəp?” Kən ilat kəmotən kəm in məmə, “Əwəh.” ");
INSERT INTO tnn_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kən təmən kəm ilat məmə, “Tol nəhlan, iəgətun mɨn rafin rəha Lou itəm kəməgətun wɨr ilat e nərəmərəən rəha Uhgɨn, kotahmen e etəm-iasol rəha nimə itəm rəhan nautə tepət. Kən nian kit in tatos-irəkɨs nat wi e rəhan nautə, kən nian kit mɨn tatos-irəkɨs nat oas.” ");
INSERT INTO tnn_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nian Iesu tɨnol namnun nuəhən nimaa nəghatən mɨn əh, kən təmiet ikɨn əh, ");
INSERT INTO tnn_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","muwɨn iman ikɨn. Kən təmatəgətun netəmim əpəh e nimə rəha nuəfɨmɨnən, kən narmɨlat təmiwɨg, kən kotən məmə, “?Suah u təmɨləs hiə nenatɨgən əh ne nəsanənən əh o nolən nat pɨspɨs mɨn? ");
INSERT INTO tnn_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Suah əh, kitat kotɨtun wɨr in. ?In netɨ etəmim itəm tatol nimə, o kəp? ?Kən rəhan mama, in Meri, kən pian mɨn ilat Jemes, ne Josep, ne Saimon, ne Jutas, o kəp? ");
INSERT INTO tnn_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","?Kən rəhan kaka mɨn kitat min ilat, o kəp? ?Təmos hiə nɨtunən o nolən natɨmnat mɨn əh?” ");
INSERT INTO tnn_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kən nɨkilat təsagienən ron kən motəuhlin məntaalat ron. Məto Iesu təmən-ipən kəm ilat məmə, “Okəmə suah kit in ien, netəmim rafin koatɨsiai-in. Məto rəhan mɨn netəmim əpəh latuənu ne rəhan mɨn netəmim e nɨpəgnoa nimə rəhan, ilat əm kəsotɨsiai-inən.” ");
INSERT INTO tnn_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kən təməsolən nat pɨspɨs tepət ikɨn əh, məto-inu ilat kəsotahatətəən lan. ");
INSERT INTO tnn_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","E nian əh, Kig Herot Antipas u tatərəmərə e nɨtən Kalili, təməto namnusən rəha Iesu. ");
INSERT INTO tnn_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Kən təmən-ipən kəm rəhan etəm-iasol mɨn məmə, “Suah u in Jon Baptais itəm təməmegəh mɨn e nɨmɨsən. Tol nəhlan tatos nəsanənən əh o nolən nat pɨspɨs mɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Herot Antipas təməghat nəhlan məto-inu in təmohamnu rəkɨs Jon Baptais. Inu namnusən e nɨmɨsən rəha Jon Baptais, tol min-nulan. Aupən ikɨn, Kig Herot Antipas təmakləh-in Herotias u pətaguɨhl rəha pia Herot u, Filip Kitiəh. Kən Jon təmən-ipən kəm in məmə, “Təsətuatɨpən məmə nəkɨləs pətan u, məto-inu nakatətgəhl Lou.” Kən Herot Antipas təmaskəlɨm Jon o Herotias, məlis ətain, mɨləs-ipən e kalapus. ");
INSERT INTO tnn_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herot Antipas tolkeike məmə in otohamnu Jon, məto təməsolən məto-inu tatəgin netəmim. Ilat koatɨsiai-in Jon moatən məmə in ien kit. ");
INSERT INTO tnn_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Məto nian kit, Herot Antipas təmol lafet kit rəha nian təmaiir lan, kən pətan əkəku, nətɨ Herotias, təmol danis aupen e nɨganəmtɨ netəmim rafin. Kən rəhan nolən danis təmol Herot Antipas nɨkin təmuwɨn pɨk lan, ");
INSERT INTO tnn_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","kən tol nəhlan, in təmən-iəkɨs mos noanawɨl məmə in otos-ipən nat naka itəm pətan əkəku əh tolkeike. ");
INSERT INTO tnn_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kən Herotias təməghat kəm nətɨn, kən nətɨn təmən-ipən kəm Herot Antipas məmə, “Os rəhn-kapə Jon Baptais e plet kit muwa ikɨn-u mos-ipa kəm io roiu.” ");
INSERT INTO tnn_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kən kig, nɨkin təpou. Məto təmən-ipən kəm rəhan netəmim məmə ilat okotol nəwia nətɨ Herotias, məto-inu o rəhan noanawɨl ne nəniəkɨsən itəm təmol e nɨganəmtɨ netəmim. ");
INSERT INTO tnn_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kən təmahl-ipən netəmim neen kotuwɨn e kalapus, kən ilat kəmotətatɨp rəkɨs rəhn-kapə Jon ikɨn əh, ");
INSERT INTO tnn_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","motələhəu-pən e plet kit, motos motuwa, motos-ipən kəm nətɨ Herotias, kən in təmos-ipən kəm rəhan mama. ");
INSERT INTO tnn_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kən netəmim rəha Jon kəmotuwɨn motɨləs nɨpətɨn motuwɨn motɨtənɨm, kən motuwɨn motən-ipən kəm Iesu. ");
INSERT INTO tnn_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nian Iesu təməto namnusən əh, kən təmətɨpən e bot kit muwɨn əpəh ikɨn kɨkə-kɨkə ikɨn. Məto nian nɨmanin netəmim kəmotɨtun ikɨn təmuwɨn ikɨn, ilat kəmotiet e rəhalat latuənu mɨn motaliwək ipar motuarisɨg-in Iesu. ");
INSERT INTO tnn_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nian Iesu təmuwar, təməplan nɨmanin netəmim tepət, kən nɨkin təmahmə olat matakeike ilat, kən mol-wɨr nɨmɨsən mɨn rəhalat. ");
INSERT INTO tnn_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kən ehnaipən iuəhkɨr o napinəpən, rəhan mɨn netəmim kəmotuwa ron moatən məmə, “Ikɨn-u, ikɨn kɨkə-kɨkə ikɨn, kən otəsuwəhən talugɨn. Ahl-ipən nɨmanin netəmim məmə okotuwɨn latuənu mɨn motos-nəmtɨn nɨgɨlat neen nagwənən.” ");
INSERT INTO tnn_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Kən Iesu təmən-ipən məmə, “Kəp. Otəpəs əm ilat kotatɨg, kən itəmat əm otagwən ilat.” ");
INSERT INTO tnn_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Məto komotən-ipən kəm in məmə, “Itɨmat ekoatos əm pɨret faif ne nəm kəiu.” ");
INSERT INTO tnn_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Kən təmən məmə, “Otos motuwa kəm io.” ");
INSERT INTO tnn_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kən mən-ipən kəm netəmim məmə okotəpələh ləhau e manuwɨhl. Kən təmos pɨret faif ne nəm kəiu əh, masɨpər əpəh e neai, matəfak-pən ron, kən məmkas pɨret. Kən təmos-ipən kəm rəhan mɨn netəmim, kən ilat kotos-ipən kəm nɨmanin netəmim. ");
INSERT INTO tnn_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kən ilat rafin kəmotagwən, nərpɨlat tasis. Kən nɨmɨsmɨsɨ nagwənən itəm kəmotapəs, netəmim rəha Iesu kəmotaii-pən e kətɨm asol ilat tuelef itəm kəmotər kər wɨr. ");
INSERT INTO tnn_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kən netəmim itəm kəmotagwən, nəman əm tahmen e faif-taosan, məto kəsafinən nɨpɨtan ne nɨsualkələh. ");
INSERT INTO tnn_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kən Iesu təmən kəm rəhan netəmim məmə ilat okotətɨpən e bot motaupən moatuwɨn entənɨpən-pən e lek, məto in otahl-ipən netəmim kotɨtəlɨg-pən iməlat mɨn ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nian tɨnahl-ipən rəkɨs netəmim, kən muwɨn əpəh ilɨs e nɨtot kit in pɨsɨn əm, məmə otəfak. Nian tɨnalugən, Iesu pɨsɨn əm əh-ikɨn, ");
INSERT INTO tnn_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","məto bot tɨnuwɨn rəkɨs ilugɨn e lek, kən tɨnatɨləs pɨkən nɨmətag, kən peau-peau mɨn kɨnoatoh bot. ");
INSERT INTO tnn_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kən lapɨn iuəhkɨr o nianən, Iesu təmaliwək e nətuei nəhau muwa olat. ");
INSERT INTO tnn_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Məto nian netəmim rəha Iesu kəmotəplan in tətaliwək e nətuei nəhau, kən kəmotəgɨn pɨk moatən məmə, “!Ei, narmɨ etəmim kit!” Kən kəmotasək əfəməh məto-inu koatəgɨn. ");
INSERT INTO tnn_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Məto uəhai əm, Iesu təməghat kəm ilat məmə, “!Ei, nɨkitəmat tətul məha-məha. Io əpəh. Sotəgɨnən!” ");
INSERT INTO tnn_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Kən Pita təmə, “Iərəmərə, okəmə ik pahrien, kən aun-in io ekaliwək e nətuei nəhau mɨnə.” ");
INSERT INTO tnn_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Kən Iesu təmən-ipən məmə, “Wa.” Kən Pita tiet e nətuei bot, kən maliwək e nətuei nəhau matuwɨn o Iesu. ");
INSERT INTO tnn_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Məto nian təməplan nɨmətag, kən nɨkin təməgɨn pɨk, kən mɨnətuoun mətamnɨm mətasək-pən o Iesu matən məmə, “!Iərəmərə, asitu lak!” ");
INSERT INTO tnn_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kən roiu agɨn, Iesu təmea-pən maskəlɨm Pita, kən mən-ipən kəm in məmə, “Ik rəham nahatətəən təkəku agɨn. ?Tahro rəham nahatətəən təkəku lak?” ");
INSERT INTO tnn_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kən nian kəmuətɨpən e bot, kən nɨmətag təmurahl nelmɨn. ");
INSERT INTO tnn_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kən ilat e nətuei bot kəmotos-ipən nɨsiaiiən asol kəm in moatən məmə, “Pahrien, ik Nətɨ Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nian kɨnotuwɨn entənɨpən-pən, kəmotuwar e nəptən Kenesaret. ");
INSERT INTO tnn_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kən nian netəmim əh-ikɨn əh kɨnotɨtun Iesu, kotahl-ipən nəghatən tuwɨn mɨtəlau o netəmim e latuənu mɨn rafin əh-ikɨn. Kən kəmotos rəhalat mɨn netəmim itəm koatɨmɨs motuwa o Iesu, ");
INSERT INTO tnn_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","kən kəmotəkəike o Iesu məmə ilat itəm koatɨmɨs okotek əm nɨpəgnəmtɨ kot rəhan. Kən ilat rafin itəm kəmotek nɨpəgnəmtɨ kot rəhan, rəhalat nɨmɨsən təmɨkə, kən kəmotəwɨr. ");
INSERT INTO tnn_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kən Farisi mɨn neen ne iəgətun mɨn neen rəha Lou kəmotɨsɨ-pən Jerusalem motuwa o Iesu. Kən motətapəh ron məmə, ");
INSERT INTO tnn_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“?Tahro rəham netəmim koatətgəhl kastom rəhatat itəm rəhatat pipi mɨn aupən kəmotəgətun kitat lan? Ilat kotagwən, məto kəsotaupənən motaikuas e nelmɨlat.” ");
INSERT INTO tnn_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Kən Iesu təmən-ipən kəm ilat məmə, “?Məto tahro itəmat mɨn nakoatətgəhl Lou rəha Uhgɨn o naskəlɨm əskasɨkən kastom rəhatəmat? ");
INSERT INTO tnn_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Iatən nəhlan məto-inu, Uhgɨn təmən məmə, ‘Nəkotəkəike motɨsiai-in rəhatəmat tata ne mama,’ kən təmən mɨn məmə, ‘Etəmim itəm otəghat rat e rəhan tata o mama, okəkəike kohamnu.’ ");
INSERT INTO tnn_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Məto itəmat nakotən məmə, okəmə suah kit rəhan kit məni əh-ikɨn itəm in tɨtun nasituən e rəhan tata ne mama lan, in tɨtun nənən kəm ilau məmə, ‘Kəsi, emələhəu pɨsɨn məni u məmə rəha Uhgɨn,’ ");
INSERT INTO tnn_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","kən okol in otəsɨsiai-inən rəhan tata, kən məsos-ipənən məni u kəm in. E nolən əh, itəmat noatol nəghatən rəha Uhgɨn tatol nat əpnapɨn lan, məto-inu itəmat nakotolkeike məmə nakotaskəlɨm kastom rəhatəmat mɨn əm. ");
INSERT INTO tnn_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","!Rəhatəmat nənən təwɨr, məto nɨkitəmat tamkɨmɨk! Ien Aesea təməghat-in itəmat ətuatɨp nian təmatən-iarəp nəghatən rəha Uhgɨn itəm tatən məmə, ");
INSERT INTO tnn_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Netəm mɨn u koatɨsiai-in io e nohlɨlat əm, məto nɨkilat isəu ron io, ");
INSERT INTO tnn_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Rəhalat nolən rəha nəfakən ron io in nat əpnapɨn əm, kən nian koatəgətun, koatən məmə nəghatən mɨn rəhak, məto in nəghatən mɨn rəha netəmim əm.’” ");
INSERT INTO tnn_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kən Iesu təmaun-in netəmim məmə okotuwa ron, kən mən-ipən kəm ilat məmə, “Otətəlɨg-in-tu, kən motɨtun nat u. ");
INSERT INTO tnn_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nat naka itəm katun, təsolən etəmim tamkɨmɨk e nɨganəmtɨ Uhgɨn, məto nat naka itəm tatiet e nohlɨ etəmim, in tatol etəmim tamkɨmɨk e nɨganəmtɨ Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kən rəhan netəmim kotuwa ron moatətapəh məmə, “?Nəkɨtun məmə Farisi mɨn, nɨkilat tərat nian kəmotəto nəghatən əh?” ");
INSERT INTO tnn_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Kən təmən-ipən məmə, “Nɨg mɨn rafin itəm rəhak Tata əpəh e nego e neai təməsəfeən, okew-pər ilat nokɨn. ");
INSERT INTO tnn_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Apəs ilat. Ilat koatit netəmim, məto nɨganəmtɨlat təpɨs. Okəmə etəmim itəm nɨganəmtɨn təpɨs tit etəmim kit mɨn itəm nɨganəmtɨn təpɨs, kən ilau kərən okiaiwɨg-pən e noakɨmɨl.” ");
INSERT INTO tnn_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kən Pita təmən-ipən kəm in məmə, “Ən-tu nɨpətɨ nimaa nəghatən kəm itɨmat.” ");
INSERT INTO tnn_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Kən Iesu təmən-ipən kəm ilat məmə, “?Itəmat rəhak netəmim, məto itəmat mɨn nəsotɨtunən əh? ");
INSERT INTO tnn_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","?Nəkotɨtun o kəp məmə, nat naka itəm tatuwɨn e nohlɨ etəmim meiuaiu e nərpɨn, kən miet mɨn e nɨpətɨ etəmim? ");
INSERT INTO tnn_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Məto natɨmnat itəm tatɨsɨ-pən e nɨki etəmim kən matiet e nohlɨ etəmim, matol etəmim tətamkɨmɨk e nɨganəmtɨ Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tol nəhlan məto-inu, natɨmnat itəm tatɨsɨ-pən e nɨki etəmim kotol nulan: nətəlɨgən tərat mɨn; nohamnuən etəmim; nakləh-inən pətan; nɨpɨtan ne nəman ne, koatit anion ilat mɨn; nakləhən; nəghat eiuəən e netəmim; nən ratən nərgɨ etəmim. ");
INSERT INTO tnn_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Inu natɨmnat itəm tol etəmim tətamkɨmɨk e nɨganəmtɨ Uhgɨn, məto okəmə suah kit təsaikuasən nelmɨn kən mətagwən, inu təsolən in tamkɨmɨk e nɨganəmtɨ Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kən Iesu təmiet ikɨn əh, kən muwɨn ikɨn itəm taon kəiu əh, Taea ne Saeton katuəməhl ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kən pətan kit əh-ikɨn, Iaihluə u pətan Kenan, təmuwa ron mətasək əfəməh məmə, “Iərəmərə, Mipɨ Tefɨt, asəkitun io. Narmɨn rat kit təskasɨk təmatɨg e nətɨk pətan matərəkɨn in.” ");
INSERT INTO tnn_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Məto Iesu təsən-ipən agɨn-əhən nəghatən kit kəm in. Kən rəhan netəmim kotuwa moatəkəike ron, motən məmə, “Ahl-ipən in isəu, məto-inu tətasək əfəməh matuarisɨg-in kitat.” ");
INSERT INTO tnn_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Kən Iesu təmən-ipən kəm ilat məmə, “Kəmahl-ipa əm io o sipsip mɨn rəha noanol rəha Isrel itəm kəmotəlue.” ");
INSERT INTO tnn_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Məto pətan əh təmuwa mɨsin nulɨn aupən e Iesu matən məmə, “Iərəmərə, asitu lak.” ");
INSERT INTO tnn_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kən Iesu təmən-ipən məmə, “Təsətuatɨpən məmə ekos nagwənən nɨgɨ nɨsualkələh, kən mərakin-pən kəm kuri mɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kən pətan u təmən-ipən məmə, “Əwəh, Iərəmərə. Məto kuri mɨn koatun nɨmɨsmɨsɨ nagwənən itəm təmɨsas e tepɨl rəha iərəmərə mɨn rəhalat.” ");
INSERT INTO tnn_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kən Iesu təmən-ipən məmə, “Ei, pətan. !Rəham nahatətəən in iahgin! Nat naka itəm nakolkeike, otuwa mol nɨpahrienən.” Kən roiu agɨn, netɨn pətan təməwɨr. ");
INSERT INTO tnn_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kən Iesu təmiet ikɨn əh maliwək e nɨkalɨ Lek Kalili. Kən mər muwɨn əpəh ilɨs e nɨtot kit kən matəpələh. ");
INSERT INTO tnn_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nɨmanin netəmim kəmotuwa ron, moatəmɨk netəm mɨn u itəm nelkɨlat təməfaiu-əfaiu, ne netəm nɨganəmtɨlat təpɨs, ne netəm nɨpətɨlat məsɨn təmɨmɨs, ne netəm kotəruru nəghatən, ne nɨmɨsən pɨsɨn pɨsɨn mɨn. Kən motəlɨn-pən ilat iuəhkɨr o Iesu, kən təmol-wɨr ilat. ");
INSERT INTO tnn_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kən nɨmanin netəmim narmɨlat təmiwɨg nian kəmotəplan netəm kotəruru nəghatən kɨnotəghat, ne netəm nɨpətɨlat məsɨn təmɨmɨs kɨnotəwɨr, ne netəm nelkɨlat təməfaiu-əfaiu kɨnotaliwək, ne netəm nɨganəmtɨlat təpɨs kɨnoatəplan nat. Kən moatənwiwi Uhgɨn rəha Isrel. ");
INSERT INTO tnn_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kən Iesu təmaun-in rəhan netəmim kotuwa ron, təmən-ipən kəm ilat məmə, “Nɨkik tɨnahməh pɨk o netəmim mɨn u. Kitat min ilat o nian kɨsɨl əh-roiu, kən nat tɨkə məmə okotun. Esolkeikeən məmə ekahl-ipən ilat koatuwɨn, nəumɨs tus ilat, mətan, neen kotɨmɨs-eah əpəh e suatɨp.” ");
INSERT INTO tnn_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kən rəhan netəmim kotən-ipən kəm in məmə, “?Okotos hiə pɨret u ikɨn-u, ikɨn taruən-aruən ikɨn itəm tahmen məmə okotagwən nɨmanin netəmim lan?” ");
INSERT INTO tnn_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Kən Iesu təmən-ipən kəm ilat məmə, “?Pɨret kuwəh u nakoatos?” Kən kotən-ipən məmə, “Ekoatos pɨret sepɨn ne nəm əkəku noan məsɨn əm.” ");
INSERT INTO tnn_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kən Iesu təmən-ipən kəm nɨmanin netəmim məmə okotəpələh e nəptən. ");
INSERT INTO tnn_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kən təmos pɨret ilat sepɨn, ne nəm əlkələh, kən məfak-pən lan, kən məmkas ilat, mos-ipən kəm rəhan netəmim mɨn, kən kotos-ipən kəm netəmim. ");
INSERT INTO tnn_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kən ilat rafin kəmotun nərpɨlat tasis. Kən netəmim rəha Iesu kotaii-pən nɨmɨsmɨsɨ nagwənən itəm kəmotun kapəs e kətɨm asol ilat sepɨn, kəmotər kər wɨr. ");
INSERT INTO tnn_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Netəmim itəm kəmotun, nəman ilat fo-taosan, məto kəsafinən nɨpɨtan ne nɨsualkələh. ");
INSERT INTO tnn_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kən Iesu tahl-ipən nɨmanin netəmim koatuwɨn, kən in təmətɨpən e bot muwɨn ikɨn Makatan. ");
INSERT INTO tnn_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Kən Farisi mɨn ne Satusi mɨn kəmotuwa o Iesu, kən kəmotəghat əuhlin kəm in məmə otol kəm ilat nəmtətin kit rəha nego e neai, inu nat pɨspɨs asol itəm otəgətun məmə Uhgɨn təmahl-ipa in. ");
INSERT INTO tnn_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kən təmən-ipən kəm ilat məmə, “Nian tɨnehnaipən, nakotən məmə, ‘olawɨg tərauiə, məto-inu napuə tɨnasiə.’ ");
INSERT INTO tnn_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kən laulaugɨn nakotən məmə, ‘Nuhuən otəfɨk, məto-inu napuə tɨnasiə mɨtəlau.’ Nəkotɨtun nənən nɨpətɨ nəmtətin mɨn e nɨmal napuə itəm tatiet, məto nəkotəruru nənən nɨpətɨ nəmtətin itəm nəkotəplan əh-roiu. ");
INSERT INTO tnn_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","“Itəmat netəm roiu ne, nakotərat, itəmat netəm Isrel nəmotapəs rəhatəmat nahatətəən o Uhgɨn, tahmen e pətan kit tapəs rəhan iərman matətəu-pən suah pɨsɨn. Kən roiu nakotolkeike məmə ekol nəmtətin kit itəm otəgətun məmə emɨsɨ-pən o Uhgɨn. Məto Uhgɨn otos-ipən əm nəmtətin kitiəh əm, kən inəh nəmtətin rəha ien əh Jona.” Kən təmapəs ilat matuwɨn. ");
INSERT INTO tnn_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nian Iesu ne rəhan mɨn netəmim kəmoatuwɨn entənɨpən-pən e Lek Kalili, rəhan netəmim kəmotaluin məmə okotos pɨret neen. Kən nian kɨnotuwɨn entənɨpən-pən, ");
INSERT INTO tnn_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","kən təmən-ipən kəm rəhan netəmim məmə, “Onakoatəto itəmat o is rəha Farisi mɨn ne Satusi mɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kən kəmoatən-ipən kəm ilat mɨn məmə, “Tatəghat nəhlan məto-inu kəmotaluin nəmɨkən pɨret neen.” ");
INSERT INTO tnn_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Məto Iesu tɨnɨtun rəhalat nətəlɨgən, kən təmən-ipən kəm ilat məmə, “Ei, rəhatəmat nahatətəən təkəku agɨn. ?Tahro nakoatən-ipən kəm itəmat mɨn məmə pɨret tɨkə otəmat? ");
INSERT INTO tnn_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","?Nəsotɨtunən əh, o kəp? ?Nɨnotaluin pɨret faif u itəm emagwən netəmim faif-taosan lan, kən uarisɨg, nəmotaii-pən nɨmɨsmɨsɨ nagwənən itəm kəmapəs e kətɨm asol kuwəh? ");
INSERT INTO tnn_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","?Kən nɨnotaluin pɨret sepɨn u itəm emagwən netəmim fo-taosan lan, kən uarisɨg, nəmotaii-pən nɨmɨsmɨsɨ nagwənən itəm kəmapəs e kətɨm asol kuwəh? ");
INSERT INTO tnn_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","?Tahro itəmat nəsotɨtunən məmə esəghat-inən pɨret? Oatəto itəmat o is rəha Farisi mɨn ne Satusi mɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kən e nian əh, ilat kəmotɨtun məmə in təsəghat-inən is rəha nolən pɨret məmə okoatəto ilat ron, məto okoatəto ilat o nəghatən mɨn itəm Farisi mɨn ne Satusi mɨn koatəgətun netəmim lan. ");
INSERT INTO tnn_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nian Iesu təmuwa ikɨn Sisaria Filipae, mən-ipən kəm rəhan netəmim məmə, “?Netəmim kotən məmə pah u io, Nətɨ Etəmim?” ");
INSERT INTO tnn_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kən kotən-ipən məmə, “Neen koatən məmə ik Jon Baptais, neen koatən məmə ik ien Elaija, kən neen koatən məmə ik ien Jeremaea, o ien kit aupən ikɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Kən təmən-ipən kəm ilat məmə, “?Məto tahro etəmat? ?Nakotəmə pah u io?” ");
INSERT INTO tnn_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Kən Saimon Pita təmən-ipən məmə, “Ik Kristo itəm Uhgɨn təmən məmə otahl-ipa, ik Nətɨ Uhgɨn itəm tətatɨg matəmegəh.” ");
INSERT INTO tnn_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Kən Iesu təmən-ipən məmə, “Uhgɨn təmawte-in rəhan nəwɨrən kəm ik, Saimon nətɨ Jona, məto-inu sənəmə etəmim əm təmol-arəp nat u kəm ik, məto rəhak Tata əpəh e nego e neai itəm təmol əp nat u kəm ik. ");
INSERT INTO tnn_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kən ekən-ipɨnə kəm ik məmə ik Pita, u nɨpətɨn təmə kəpiel. Kən ekiləkɨn rəhak niməfak e kəpiel u, kən okol nəsanənən rəha nɨmɨsən otəsaprəkɨs-inən. ");
INSERT INTO tnn_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ekos-ipɨnə kəm ik nepətən itəm tatɨsɨ-pən o Uhgɨn əpəh e nego e neai. Kən əpəh e nego e neai, Uhgɨn tɨnegəhan-in rəkɨs nəwiam itəm onakən e nətueintən. Nian onakahtosɨg-in nat kit, o onategəhan-in nat kit, kən otol mihin.” ");
INSERT INTO tnn_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kən mən-ipən əskasɨk kəm rəhan netəmim məmə okəsotən-ipənən kəm suah kit məmə in Kristo itəm Uhgɨn təmən məmə otahl-ipa. ");
INSERT INTO tnn_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","E nian əh, Iesu təmətuoun matən-iarəp kəm rəhan netəmim məmə in otəkəike muwɨn Jerusalem, kən etəm-iasol mɨn rəha noanol rəha Isrel, ne pris asol mɨn, ne iəgətun mɨn rəha Lou, okotol in təto nahməən e nəratən tepət, kən okotohamnu in, kən uarisɨg e nian kɨsɨl, in otəmegəh mɨn e nɨmɨsən. ");
INSERT INTO tnn_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kən Pita tos pɨsɨn Iesu, kən mətuoun matən-iəhau matən məmə, “Iərəmərə, Uhgɨn otəkəike mahtosɨg-in nat əh. !Nat əh okol təsuwamən mol nɨpahrienən lan!” ");
INSERT INTO tnn_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kən Iesu talalin mən-ipən kəm Pita məmə, “!Setan! !Uwɨn isəu ron io! Ik nətahtosɨg-in io. Rəham nətəlɨgən sənəmə nətəlɨgən rəha Uhgɨn, məto in nətəlɨgən rəha netəmim əm.” ");
INSERT INTO tnn_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kən Iesu təmən-ipən kəm rəhan netəmim məmə, “Etəmim itəm tolkeike məmə otuarisɨg-in io, otəkəike maluin atɨp in, kən mɨləs rəhan nɨg kəməluau mətəu-pa io. ");
INSERT INTO tnn_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tol nəhlan məto-inu, etəmim itəm tatol pɨk wək əm məmə rəhan nəmegəhən e nətueintən u in otəwɨr, otəmkarəpən e nəmegəhən pahrien. Məto etəmim itəm otɨmɨs o nərgək, in otos nəmegəhən lilɨn. ");
INSERT INTO tnn_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","?Okəmə etəmim kit tatos rafin natɨmnat e nətueintən, məto uarisɨg lan otɨmɨs kən təsosən nəmegəhən lilɨn, in təmol win e nat kit təwɨr, o kəp? Kəp. Okol suah əh təsos-ipənən nat kit kəm Uhgɨn məmə Uhgɨn otos-ipən nəmegəhən lilɨn kəm in. ");
INSERT INTO tnn_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tol nəhlan məto-inu, io Nətɨ Etəmim epanuwa itɨmat nagelo mɨn e nəsanənən ne nepətən əhag-əhag asol rəha Tata rəhak, kən ekos-ipən nətouən kəm netəmim rafin e wək ətuatɨp itəm kəmotol. ");
INSERT INTO tnn_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Iatən-ipɨnə nɨpahrienən məmə netəmim neen koatətul ukɨn-u itəm kəsotɨmɨsən motəmegəh əm nian Nətɨ Etəmim u in kig, otuwa məmə in otərəmərə e natɨmnat rafin.” ");
INSERT INTO tnn_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nian sikis tɨnuwa mɨnuwɨn rəkɨs, Iesu tit Pita, ne Jemes, ne Jon u pia Jemes, mit iləhal motuwɨn əpəh ilɨs e nɨtot əfəməh, ilat pɨsɨn əm. ");
INSERT INTO tnn_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kən ikɨn əh, nɨpətɨ Iesu təməuhlin muwa mol pɨsɨn. Rəhn-kapə təmasiə məhag-əhag tahmen e mɨtgar, kən rəhan natɨmnat tɨnuwa məruən məhag-əhag. ");
INSERT INTO tnn_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Roiu agɨn, Moses ne Elaija kəmiaet-arəpa mətəhaləghat iləhal Iesu. ");
INSERT INTO tnn_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kən Pita təmən-ipən kəm Iesu məmə, “Iərəmərə. Təwɨr məmə itɨməhal eməhaluwa ikɨn-u. Okəmə nakolkeike, ekiləkɨn makeen kɨsɨl u ikɨn-u, rəham kit, kən rəha Moses kit, kən rəha Elaija kit.” ");
INSERT INTO tnn_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nian Pita təmatəghat əh, mal napuə itəm təhag-əhag təmuwa malpin ilat, kən kəmotəto nəwia suah kit təmiet e mal napuə matən məmə, “Inu nətɨk itəm iakolkeike pɨk. Nɨkik tagien pɨk ron. !Əhalətəlɨg-in in!” ");
INSERT INTO tnn_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nian suah miləhal əh kəməhaləto nəghatən əh, kəməhalɨsɨ-pər məhalɨtənɨm-pən rəhaləhal-kapə e nəptən məhaləgɨn pɨk. ");
INSERT INTO tnn_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Məto Iesu təmuwa mek iləhal matən məmə, “Əhalətul. Əsəhaləgɨnən.” ");
INSERT INTO tnn_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nian kəməhlasɨpər, məsəhaləplanən suah kit, məto Iesu pɨsɨn əm. ");
INSERT INTO tnn_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nian kəmoteiuaiu-pa e nɨtot, Iesu təmən kəm iləhal məmə, “Əsəhalənən kəm etəmim kit nat naka itəm nəməhaləplan mətoarus-pən Nətɨ Etəmim otəmegəh mɨn e nɨmɨsən.” ");
INSERT INTO tnn_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kən kəməhalən-ipən məmə, “?Məto tahro iəgətun mɨn rəha Lou koatən məmə Elaija otəkəike maupən muwa mɨn?” ");
INSERT INTO tnn_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Kən Iesu təmən-ipən məmə, “Nɨpahrienən məmə Elaija otəkəike maupən muwa məmə otol-wɨr mɨn natɨmnat rafin. ");
INSERT INTO tnn_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Məto ekən-ipɨnə kəm itəməhal məmə, Elaija tɨnuwa rəkɨs, məto netəmim kəsotɨtunən in, kən motol tərat lan. E nolən ahmen mɨn əm, Nətɨ Etəmim otəto nahməən e nelmɨlat.” ");
INSERT INTO tnn_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kən rəhan netəmim kɨnotɨtun məmə tatəghat-in Jon Baptais kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nian kɨnotiet-pa o nɨmanin netəmim, suah kit tuwa mɨsin nulɨn aupən-in Iesu, ");
INSERT INTO tnn_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","kən məmə, “Iərəmərə, asəkitun nətɨk. Tətaut, kən matəto pɨk nahməən lan. Nian tepət tatiet-pən e nɨgəm, matiet-pən ləhau e nəhau. ");
INSERT INTO tnn_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Emɨləs muwɨn o rəham netəmim, məto kotəruru nol-wɨrən.” ");
INSERT INTO tnn_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Kən Iesu təmən-ipən məmə, “Ei, itəmat netəm roiu nəsotahatətəən, kən nɨnotuwɨn isəu o suatɨp rəha Uhgɨn. ?Onəghan nəpanotɨtun? ?Oekətatɨg kitat min itəmat mətoarus nian naka? Otɨləs suakəku motuwa kəm io.” ");
INSERT INTO tnn_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Kən Iesu təməghat əskasɨk kəm narmɨn rat, kən tiet e suakəku, kən roiu agɨn suakəku təməwɨr. ");
INSERT INTO tnn_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kən rəhan netəmim kəmotuwa kətul pɨsɨn ilat Iesu, kən motətapəh ron məmə, “?Tahro itɨmat ekotəruru nəhg-iarəpən narmɨn rat?” ");
INSERT INTO tnn_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Kən Iesu təmən-ipən kəm ilat məmə, “Məto-inu rəhatəmat nahatətəən təkəku əm, təsahmenən. Məto iakatən pahrien kəm itəmat məmə, okəmə rəhatəmat nahatətəən əh-ikɨn, nat əpnapɨn tahmen e nɨkuti mastat u nətɨn agɨn, kən nəkotɨtun nən-ipənən kəm nɨtot u məmə, ‘Otiet u ikɨn-u, muwɨn ikɨn əh,’ kən nɨtot otiet, kən nat kit tɨkə itəm itəmat nəkotəruru nolən.” ");
INSERT INTO tnn_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nian kəmotuwa kitiəh əpəh Kalili, Iesu təmən-ipən kəm ilat məmə, “Io Nətɨ Etəmim, suah kit otegəhan-in-pən io e nelmɨ tɨkɨmɨr mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Netəmim okotohamnu io, kən uarisɨg e nian kɨsɨl, Uhgɨn otosmegəh mɨn io e nɨmɨsən.” Kən rəhan netəmim kəmotəto tərat pɨk agɨn o nəghatən əh. ");
INSERT INTO tnn_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nian Iesu ne rəhan netəmim kəmotuwa Kapaneam, netəmim rəha nosən məni rəha takɨs rəha Nimə Rəha Uhgɨn, kəmotuwa o Pita motən məmə, “?Tahro? ?Rəham iəgətun tatətou takɨs u, o kəp?” ");
INSERT INTO tnn_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Kən Pita təmən-ipən məmə, “Əwəh, tatətou.” Nian Pita təmuwɨn e nɨpəgnoa nimə, kən Iesu təmaupən məghat matən kəm in məmə, “?Saimon, nɨkim təht mə naka? ?Kig mɨn rəha nətueintən koatos takɨs o pah, koatos o rəhalat mɨn netəmim, o netəm pɨsɨn mɨn?” ");
INSERT INTO tnn_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita təmən-ipən məmə, “Koatos o netəm pɨsɨn mɨn.” Kən Iesu təmən-ipən məmə, “Kən tol nəhlan, netəm rəha kig kəsotətouən. ");
INSERT INTO tnn_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Məto kitat kəsotolkeikeən məmə kotol ilat kotəto tərat otat. Kən tol nəhlan, təwɨr məmə ik onəkuwɨn əpəh ləhau e lek, mərakin rəham nɨpien o niuwən nəm. Nəm itəm nakaupən miuw, nakəhap nɨpəgnoan, kən onəkəplan məni silfa kit tahmen-in nətouən takɨs. Os muwɨn mos-ipən kəm ilat o nətouən rəhalau takɨs.” ");
INSERT INTO tnn_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","E nian əh, netəmim rəha Iesu kəmotuwa ron motətapəh ron məmə, “?Pah u in etəm-iasol e nərəmərəən rəha Uhgɨn?” ");
INSERT INTO tnn_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kən Iesu taun-in suakəku kit tuwa mətul ilugɨn elat, ");
INSERT INTO tnn_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","kən mən məmə, “Pahrien iatən kəm itəmat məmə okəmə nəsotəuhlinən itəmat motuwa motahmen e nɨsualkələh, okol nəsotuwɨnən motatɨg ahgin nərəmərəən rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tol nəhlan, pah u otɨləs-iəhau atɨp in tahmen e suakəku u, in etəm-iasol e nərəmərəən rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Okəmə suah kit in ləhau tahmen e suakəku u, kən etəmim kit nɨkin tagien o nosən suah u muwɨn e nɨpəgnoa nimə rəhan, kən okəmə tatol e nərgək, kən tahmen məmə tatos io mɨn e nɨkin agien. ");
INSERT INTO tnn_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Məto okəmə etəmim kit tatiuw-pən rəhak kit etəmim u tahmen e suakəku əh, məmə otol nolən rat, kən suah əh, Uhgɨn otol nalpɨnən asol kəm in. Kən nalpɨnən əh otəskasɨk taprəkɨs okəmə kətu-pən kəpiel kit e nentou, kən kərakin-pən əpəh itəhəi lokamnɨm məmə otamnɨm. ");
INSERT INTO tnn_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Kəsi, nahməən asol otuwa o netəmim rəha nətueintən, itəm koatos-ipən-os-ipən kəm netəmim məmə okotol təfagə rat. Nos-ipən-os-ipənən mɨn əh okotəkəike motuwa. Məto kəsi, nahməən asol otuwa o suah u itəm in suatɨp rəha nəratən əh. ");
INSERT INTO tnn_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Okəmə nelməm o nelkəm tol ik natol təfagə, kən nakəte rəkɨs mərakin. Məto-inu təwɨr pɨk məmə nian nakuwɨn e nego e neai, nelkəm kit o nelməm kit tɨkə, taprəkɨs-in məmə ik nataskəlɨm nelməm kərən mil ne nelkəm kərən mil əh-ikɨn, kən kərakin-pən ik e nɨgəm itəm tatuəp namnun tɨkə. ");
INSERT INTO tnn_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Okəmə nɨganəmtɨm tol ik natol təfagə, kən asul-irəkɨs mərakin. Məto-inu təwɨr pɨk məmə nian nakuwɨn e nego e neai, nɨganəmtɨm kit tɨkə, taprəkɨs-in inu məmə ik nataskəlɨm nɨganəmtɨm kərən mil, kən kərakin-pən ik e nɨgəm asol itəm tatuəp namnun tɨkə.” ");
INSERT INTO tnn_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Kən Iesu təmən-ipən məmə, “Nəkotəkəike moatɨtun wɨr məmə nəsotehm-iəhauən netəmim rəhak mɨn itəm kotahmen e nɨsualkələh, məto-inu iatən kəm itəmat məmə nagelo mɨn itəm koatehm ilat, nian rafin ilat koatətul e nɨganəmtɨ rəhak Tata u tətatɨg əpəh e nego e neai məmə okotən-iarəp ilat kəm Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“?Nɨkitəmat təht məmə naka? ?Okəmə etəmim kit rəhan sipsip wan-hanrɨt, kən kitiəh təlue mətan, kən suah əh otol naka? In otapəs ilat nainti-nain əpəh e nɨtot, kən muwɨn megəs-in itəm un itəm təməlue. ");
INSERT INTO tnn_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kən okəmə təməplan, iatən pahrien kəm itəmat məmə, nɨkin otagien o sipsip u kitiəh əm, taprəkɨs-in ilat u sipsip nainti-nain itəm kəsotəlueən. ");
INSERT INTO tnn_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","E nolən ahmen mɨn əm, rəhatəmat Tata əpəh e nego e neai, in təsolkeikeən məmə rəhan kit suakəku otuwɨn məlue.” ");
INSERT INTO tnn_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Kən Iesu təmən məmə, “Okəmə piam kit tol nolən rat kit kəm ik, uwɨn məplan itəlau pɨsɨn əm, kən nakən-ipən nat naka itəm təmol təsətuatɨpən. Okəmə tatətəlɨg-in ik, rəham nəghatən otol in tatɨtəlɨg-pa mɨn nakuəwɨr otəlau mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Məto okəmə təsətəlɨg-inən ik, os etəmim kitiəh o kəiu məhaluwɨn mɨn məhaləplan məmə nəghatən mɨn rafin itəm onəkotən, okotɨtun məmə ilat rafin nɨpahrienən əm. ");
INSERT INTO tnn_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Məto okəmə təsətəlɨg-inən ilat, ən-ipən kəm niməfak. Məto okəmə təsətəlɨg-inən niməfak, kən niməfak otəplan in tahmen e Iaihluə o etəmim rəha nosən məni e takɨs. ");
INSERT INTO tnn_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Iatən pahrien kəm itəmat məmə, əpəh e nego e neai, Uhgɨn tɨnegəhan-in rəkɨs nəwiatəmat itəm nakotən e nətueintən. Nian nəkoatahtosɨg-in nat kit o nakoategəhan-in nat kit, kən otol mihin. ");
INSERT INTO tnn_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Kən iatən mɨn kəm itəmat məmə, okəmə itəlau kəiu nakuən nəghatən kit muəlis e nat kit itəm nakətuətapəh ron o Uhgɨn, kən rəhak Tata əpəh e nego e neai otol nat naka itəm nakətuətapəh ron. ");
INSERT INTO tnn_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tol nəhlan məto-inu, ikɨn pəhruən etəmim kəiu o kɨsɨl kəhaluwa kitiəh e nərgək, io itɨmat min ilat.” ");
INSERT INTO tnn_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kən Pita təmuwa o Iesu kən mətapəh ron məmə, “Iərəmərə. ?Ekaluin nolən tərat itəm piak təmol kəm io mau kuwəh? ?Mau sepɨn tahmen, o?” ");
INSERT INTO tnn_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Kən Iesu təmən-ipən məmə, “Iakən-ipɨnə kəm ik məmə, sənəmə mau sepɨn əm, məto mau sepɨnte-sepɨn. ");
INSERT INTO tnn_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Nakəkəike mol nəhlan məto-inu nərəmərəən rəha Uhgɨn in tol nulan. Kig kit tolkeike məmə otəplan-tu kaon mɨn itəm rəhan netəmim kəmotol kəm in məmə ilat okotətou. ");
INSERT INTO tnn_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nian tɨnətuoun wək əh, kotɨləs rəhan kit iolwək motuwa ron itəm təmol kaon iahgin iahgin, tahmen e ten-taosan talen. ");
INSERT INTO tnn_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Məto suah əh tɨnəruru nətouən, kən tol nəhlan, kig təmən məmə okol-salɨm-in in, ne rəhan pətan, ne rəhan nɨsualkələh, ne rəhan natɨmnat mɨn rafin məmə otətou rəhan kaon. ");
INSERT INTO tnn_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Kən rəhan iolwək təmeiuaiu mɨsin nulɨn aupən in. Kən matəkəike ron matən-ipən kəm in məmə, ‘Awi. ?Nəkɨtun nos-ipamən nian əkuəkɨr məsɨn kəm io məmə ekətou rafin rəhak kaon?’ ");
INSERT INTO tnn_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kən rəhan etəm-iasol təmasəkitun in, kən mapəs rafin rəhan kaon məmə otəsətouən nian kit ne, kən megəhan-in məmə otuwɨn. ");
INSERT INTO tnn_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Məto nian iolwək u təmuwɨn, kən məplan etəmim kit u təmol kaon kəm in, wan-hanrɨt tenarius. Ilau kərən iolwək mil kətioal wək kitiəh əm rəha etəm-iasol. Kən iolwək itəm etəm-iasol təmaluin rəhan kaon, in təmaskəlɨm itəm u kit kəmətioal wək kələh, kən matəmkətɨp nentou, matən məmə, ‘!Ətou-pa rəham kaon itəm nəmol kəm io!’ ");
INSERT INTO tnn_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Kən iolwək un itəm təmol kaon kəm in, teiuaiu mɨsin nulɨn matəkəike ron matən məmə, ‘Awi. ?Nəkɨtun nos-ipamən nian əkuəkɨr məsɨn kəm io məmə ekətou rəhak kaon?’ ");
INSERT INTO tnn_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Məto in təmə, kəp. Kən təmuwɨn mən məmə okɨləs suah u kan kɨləs-ipən e kalapus mətoarus-pa otətou rafin rəhan kaon mɨn itəm təmol. ");
INSERT INTO tnn_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nian iolwək mɨn neen kəmotəplan nat əh, nɨkilat təmahmə pɨk ron, kən motuwɨn motən-ipən kəm etəm-iasol natɨmnat rafin itəm kəmotəplan. ");
INSERT INTO tnn_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Kən etəm-iasol təmaun-in iolwək un tuwa təmən-ipən kəm in məmə, ‘Ik iolwək itəm tərat agɨn. Emapəs rafin rəham kaon məto-inu nəmatəkəike ron io. ");
INSERT INTO tnn_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","?Tahro nəsasəkitunən suah u natioal wək itəlau min, tahmen-pən əm e itəm emol kəm ik?’ ");
INSERT INTO tnn_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kən neməha təmol etəm-iasol, kən təmən məmə okɨləs kan kɨləs-ipən e kalapus məmə etəm tatehm kalapus otol nalpɨnən kəm in mətoarus-pən otətou rafin rəhan kaon itəm təmol.” ");
INSERT INTO tnn_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Kən nian Iesu təmol namnun nimaa nəghatən, təmən-ipən kəm ilat məmə, “Kən e suatɨp kitiəh əm, rəhak Tata əpəh e nego e neai, otol kəm itəmat rafin, okəmə nəsotaluin pahrienən nəratən itəm piatəmat mɨn koatol kəm itəmat.” ");
INSERT INTO tnn_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nian Iesu təmol namnun nənən natɨmnat mɨn u, təmiet Kalili muwɨn nɨtən Jutia entənɨpən-pən e nɨkalɨ nəhau Jotan. ");
INSERT INTO tnn_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kən nɨmanin netəmim kəmotuarisɨg-in in motuwɨn əh-ikɨn əh, kən təmol-wɨr ilat e nɨmɨsən mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Kən Farisi mɨn neen kəmotol noa eko-eko məmə otiuw-pən Iesu o nənən nəghatən kit itəm təsətuatɨpən. Kəmotuwa o Iesu motən məmə, “?Lou tatən məmə iərman tɨtun napəsən rəhan pətan o nat əpnapɨn əm kit, o kəp?” ");
INSERT INTO tnn_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Kən təmən-ipən məmə, “?Nəmotafin o kəp məmə, e nətuounən muwɨn mətoarus-pa u-roiu, Uhgɨn u itəm təmol netəmim rafin, təmol iərman ne pətan? ");
INSERT INTO tnn_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kən Suah u təmən məmə, ‘O nat əh in əh, iərman otəpanapəs rəhan tata ne mama, kən mətuatɨg ilau rəhan pətan. Kən ilau okuea nɨpətɨlau kitiəh.’ ");
INSERT INTO tnn_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kən roiu, ilau sənəmə kəiu, məto kitiəh əm. Uhgɨn tɨnɨlpɨn ilau kɨnuea mɨnioal kitiəh, kən o nat əh, pəs etəmim kit okol təsətatɨpən rəhalau natɨgən.” ");
INSERT INTO tnn_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kən Farisi mɨn kotən-ipən məmə, “?Məto tahro Moses təmən məmə etəmim tɨtun nos-ipənən naoa kit kəm rəhan pətan o napəsən, kən mahl-ipən tatuwɨn?” ");
INSERT INTO tnn_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Kən Iesu təmən-ipən məmə, “Moses təmegəhan-in itəmat noanol rəha Isrel məmə onəkotapəs rəhatəmat nɨpɨtan mɨn məto-inu rəhatəmat-kapə təskasɨk pɨk. Məto aupən, təməsolən nulan. ");
INSERT INTO tnn_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Məto iakatən kəm itəmat məmə, okəmə suah kit tatol tifos mətapəs rəhan pətan itəm təməsətəu-pən anionən iərman pɨsɨn kit, kən suah u mit pətan pɨsɨn, tahmen əm məmə in tətakləh-in pətan əh, mateguafəl rəhan pətan ətuatɨp.” ");
INSERT INTO tnn_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kən netəmim rəha Iesu kotən kəm in məmə, “Okəmə natɨgən rəha iərman ne pətan təskasɨk pɨk nulan, təwɨr məmə iərman ne pətan okəsioalən marɨt.” ");
INSERT INTO tnn_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Kən Iesu təmən-ipən məmə, “Sənəmə netəmim rafin okotɨtun nosən nəghatən u, məto netəm mɨn əm un itəm kəmos-ipən nəghatən u kəm ilat, in rəhalat əm. ");
INSERT INTO tnn_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tol nəhlan məto-inu, netəmim neen okəsotolən marɨt o nat pɨsɨn pɨsɨn mɨn. Kit okol təsolən marɨt məto-inu nɨpətɨn məsɨn tərat nian təmaiir. Kit okol təsolən marɨt məto-inu netəmim kəmotərəkɨn nɨpətɨn məsɨn. Kən kit tatən atɨp məmə in otəsolən marɨt məmə otol wək rəha nərəmərəən rəha Uhgɨn. Etəmim itəm tɨtun nosən nəghatən u, in təike mos.” ");
INSERT INTO tnn_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kən netəmim kəmotəmɨk nɨsualkələh motuwa o Iesu məmə otələhəu-pən nelmɨn elat, kən məfak olat. Məto netəmim rəha Iesu kəmotən-iəhau ilat. ");
INSERT INTO tnn_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Məto Iesu təmən-ipən məmə, “Pəs nɨsualkələh kotuwa ron io, sotən-iəhauən ilat, məto-inu nərəmərəən rəha Uhgɨn in rəha netəmim mɨn u kotol nulan.” ");
INSERT INTO tnn_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kən təmələhəu-pən nelmɨn elat, kən miet ikɨn əh. ");
INSERT INTO tnn_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kən suah kit təmuwa o Iesu mən-ipən məmə, “Iəgətun. ?Io ekəkəike mol wək naka itəm in təwɨr məmə ekos nəmegəhən lilɨn?” ");
INSERT INTO tnn_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Kən Iesu təmən-ipən məmə, “?Tahro nakatətapəh ron io o nat naka itəm təwɨr? Suah kitiəh əm itəm in təwɨr. Okəmə nakolkeike məmə nakos nəmegəhən lilɨn, ətəu-pən nəghatən mɨn rəha Lou.” ");
INSERT INTO tnn_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Kən suah u təmən-ipən məmə, “?Lou mɨn pəhruən?” Kən Iesu təmən-ipən məmə, “Sohamnuən etəmim, kən məsakləh-inən pətan, kən məsakləhən, kən məseiueiuəən e kot, ");
INSERT INTO tnn_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","kən mɨsiai-in rəham tata ne mama, kən molkeike ik kit tahmen əm məmə nakolkeike atɨp ik.” ");
INSERT INTO tnn_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kən etəm aluə u təmən-ipən məmə, “Natɨmnat rafin un iakatol. ?Nat naka mɨn əh-ikɨn itəm eməsolən?” ");
INSERT INTO tnn_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Kən Iesu təmən-ipən məmə, “Okəmə nakolkeike məmə rəham nolən otətuatɨp agɨn, uwɨn mol-salɨm-in rəham nautə, kən mos-ipən məni lan kəm ian-rat mɨn. Kən ik onakos natɨmnat wɨr əpəh e nego e neai. Kən wa, mətəu-pa io.” ");
INSERT INTO tnn_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nian etəm aluə təməto nəghatən əh, kən təmagɨm matuwɨn nɨkin təpou məto-inu rəhan nautə tepət. ");
INSERT INTO tnn_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kən Iesu təmən-ipən kəm rəhan mɨn netəmim məmə, “Ekatən pahrien məmə, tiəkɨs o etəmim itəm rəhan nautə tepət məmə otuwɨn matɨg ahgin nərəmərəən rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kən iatən mɨn kəm itəmat məmə, tiəkɨs məmə kamel otuwɨn-pən e nɨpəg nitel, məto tiəkɨs pɨk məmə etəm rəhan nautə tepət otuwɨn matɨg ahgin nərəmərəən rəha Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nian netəmim rəha Iesu kəmotəto nəghatən əh, narmɨlat təmiwɨg pɨk, kən motən-ipən məmə, “?Kən pah tɨtun nosən nəmegəhən lilɨn?” ");
INSERT INTO tnn_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Kən Iesu təplan ilat kən mən məmə, “Nat u, okol etəmim təsolən. Məto Uhgɨn, in tɨtun nolən natɨmnat rafin.” ");
INSERT INTO tnn_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kən Pita təmən-ipən məmə, “Emotapəs natɨmnat rafin məmə ekotətəu-pən ik. ?Nat naka u, o nian kit in rəhatɨmat?” ");
INSERT INTO tnn_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Kən Iesu təmən-ipən kəm ilat məmə, “Iatən pahrien kəm itəmat məmə, e nian itəm natɨmnat rafin okotəuhlin motuwa motuwiwi, kən Nətɨ Etəmim otəpələh e rəhan jea rəha kig itəm in təhag-əhag məwɨr agɨn, kən itəmat un itəm nəmoatətəu-pa io, onəkotəpələh mɨn e jea rəha kig ilat tuelef, kən motərəmərə e noanol mɨn ilat tuelef rəha Isrel. ");
INSERT INTO tnn_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kən netəmim rafin un itəm kəmotapəs rəhalat nimə mɨn, o pialat mɨn, o wɨnɨlat mɨn, o rəhalat tata o mama, o nenətɨlat mɨn, o rəhalat nəptən mɨn o nərgək, Uhgɨn otos-ipən natɨmnat mɨn əh tepət pɨk agɨn kəm ilat, kən mos-ipən nəmegəhən lilɨn kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Məto netəmim tepət itəm koatətul aupən e nətueintən roiu, okotuwa motətul uarisɨg e nəmegəhən itəm otuwa. Kən netəmim təpət itəm koatətul uarisɨg e nətueintən roiu, okotuwa motətul aupən e nəmegəhən itəm otuwa.” ");
INSERT INTO tnn_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Tol nəhlan məto-inu nərəmərəən rəha Uhgɨn tahmen e etəm-iasol kit rəha nasumən. Təmiet laulaugɨn agɨn məmə otegəs-in netəmim okotuwa motol wək e rəhan nasumən. ");
INSERT INTO tnn_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kən in təmən məmə otətou ilat kitiəh kitiəh wan tenarius e nian kitiəh, kən mahl-ipən ilat kotuwɨn e rəhan nasumən. ");
INSERT INTO tnn_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Iuəhkɨr nain klok laulaugɨn, təmiet muwɨn e maket məplan netəmim neen koatətul məsotolən nat kit. ");
INSERT INTO tnn_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kən təmən-ipən kəm ilat məmə, ‘Itəmat mɨn, otuwɨn motol wək əpəh e rəhak nasumən, kən ekətou itəmat e məni itəm tətuatɨp.’ ");
INSERT INTO tnn_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kən kəmotuwɨn. “Kən iuəhkɨr o tina, təmiet muwɨn mol nat kitiəh əm, kən mol mɨn e tri klok ehnaipən. ");
INSERT INTO tnn_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kən iuəhkɨr e faif klok ehnaipən, təmiet muwɨn məplan netəmim neen mɨn koatətul əpnapɨn əm. Kən təmən-ipən kəm ilat məmə, ‘?Tahro nəkoatətul ikɨn-u nian apiəpiə kit, məsotolən nat kit?’ ");
INSERT INTO tnn_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Kən kotən-ipən məmə, ‘Məto-inu suah kit təsegəs-inən itɨmat məmə ekotol wək rəhan.’ Kən təmən-ipən kəm ilat məmə, ‘Itəmat mɨn otuwɨn kol wək e rəhak nasumən.’ Kən ilat kəmotuwɨn. ");
INSERT INTO tnn_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Nian tɨnehnaipən, etəm-iasol rəha nasumən təmən-ipən kəm rəhan etəmim itəm tatehm rəhan iolwək mɨn məmə, ‘Aun-in iolwək mɨn kotuwa, nakos-ipən rəhalat məni. Nakətuoun mətou netəm itəm kəmotuwa uarisɨg muwɨn mətoarus netəm kəmotaupən motol wək.’ ");
INSERT INTO tnn_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Kən iolwək mɨn itəm kəmotuwa motol wək e faif klok, kəmotuwa kən təmətou ilat wan tenarius kitiəh kitiəh. ");
INSERT INTO tnn_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tol nəhlan, netəm mɨn u itəm kəmotaupən kol wək, nɨkilat təht məmə okotos məni taprəkɨs-in itəm mɨn u kəmotol wək uarisɨg. Məto ilat kitiəh kitiəh kəmotos mɨn əm wan tenarius. ");
INSERT INTO tnn_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nian kəmotos məni, kən kəmoatəghat-əghat kəm ilat mɨn məmə nɨkilat təsagienən o məni, kən motən-ipən kəm etəm-iasol rəha nasumən məmə, ");
INSERT INTO tnn_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Netəm mɨn u itəm kəmotol wək uarisɨg, kəmotol wək əm e aua kitiəh əm, məto ik nəmətou itɨmat min ilat tahmen-ahmen əm. Məto itɨmat emotol wək asol e nərauiə əskasɨk e nian apiəpiə.’ ");
INSERT INTO tnn_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Məto etəm-iasol təmən-ipən kəm ilat kit məmə, ‘Io kit. Esakləh-inən ik. ?Nəmən məmə nakol wək o wan tenarius, o kəp? ");
INSERT INTO tnn_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Os rəham məni matuwɨn. Iakolkeike məmə ekətou etəm u itəm təmol wək uarisɨg tahmen əm lam. ");
INSERT INTO tnn_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Rəhak u məni. ?Ekɨtun nolən nəhlan nat naka itəm iakolkeike, o kəp? ?Natetəhak olat məto-inu io iakəwɨr olat?’” ");
INSERT INTO tnn_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Kən nian Iesu təmol namnun nimaa nəghatən, təmən-ipən kəm ilat məmə, “Tol nəhlan, etəm tatuarisɨg otaupən, kən etəm tətaupən otuarisɨg.” ");
INSERT INTO tnn_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kən nian Iesu təmatuwɨn Jerusalem, təmos rəhan netəmim tuelef motətul pɨsɨn, kən təmən-ipən kəm ilat məmə, ");
INSERT INTO tnn_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Koatuwɨn əpəh ilɨs Jerusalem, kən io Nətɨ Etəmim, okegəhan-in-pən io kəm pris asol mɨn ne iəgətun mɨn rəha Lou. Kən okotiuw-iarəp io məmə ekɨmɨs, ");
INSERT INTO tnn_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","kən motɨləs-ipən io kəm Iaihluə mɨn məmə okotəsan lak, kən motalis motoh, kən motətu-pər io e nɨg kəməluau məmə ekɨmɨs. Kən uarisɨg e nian kɨsɨl, kən Uhgɨn otosmegəh mɨn io e nɨmɨsən.” ");
INSERT INTO tnn_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kən pətan rəha Sepeti, tɨləs nətɨlau mil muwa mɨsin-pən nulɨn o Iesu, matətapəh-in nat kit ron. ");
INSERT INTO tnn_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kən Iesu təmən-ipən məmə, “?Nakolkeike naka?” Kən pətan təmən-ipən məmə, “Pəs nakegəhan-in məmə nətɨk mil u, ilau kərən kit otəpələh e nɨkaləm matɨp, kən kit təpələh e nɨkaləm mol, ikɨn mɨn rəha nəsanənən ne nɨsiaiiən, nian natərəmərə lan.” ");
INSERT INTO tnn_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Kən Iesu təmən-ipən kəm ilau məmə, “Nəkuəruru nat itəm natuətapəh ron. ?Tahro? ?Itəmlau, nɨkitəlau təht məmə nəkuahmen məmə kitəhal kəhalətul e nɨgəm rəha nuwigɨ nien itəm io ekəike mətul lan?” Kən kuən-ipən kəm Iesu məmə, “Əwəh, ekiatun.” ");
INSERT INTO tnn_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Kən Iesu təmən-ipən kəm ilau məmə, “Pahrien, onakuəkəike muənɨm-pən e rəhak kap rəha nətoən nahməən. Məto o nəpələhən e nɨkalɨk matɨp ne mol, sənəmə rəhak məmə ekən. Ikɨn mil əh, ilau rəha netəm mɨn u itəm Uhgɨn təmol əpen-əpenə olat.” ");
INSERT INTO tnn_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nian netəmim ten mɨn rəha Iesu kəmotəto nəghatən əh, kən neməha təmol pɨk ilat o suah mil ilau pian. ");
INSERT INTO tnn_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Məto Iesu taun-in ilat kotuwa kitiəh, kən mən-ipən kəm ilat məmə, “Nəkotɨtun rəkɨs nolən rəha netəm-iasol rəha Iaihluə mɨn. Ilat koatol təskasɨk pɨk kəm rəhalat netəmim mɨn. Kən rəhalat kapman mɨn koatol ilat kotəməhl ləhau e nərəmərəən rəhalat. ");
INSERT INTO tnn_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Məto itəmat, okol nəsotolən nəhlan. Məto okəmə itəmat kit tolkeike məmə otuwa in etəm-iasol kit rəhatəmat, in otəkəike muwa tahmen e iolwək kit rəhatəmat, ");
INSERT INTO tnn_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","kən okəmə itəmat kit tolkeike məmə otətul aupən etəmat, in otəkəike muwa slef rəhatəmat. ");
INSERT INTO tnn_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nolən əh tahmen əm lak, Nətɨ Etəmim. Eməsuwamən məmə netəmim okotol wək rəhak, məto emuwa məmə ekol wək rəhalat, kən ekos-ipən rəhak nəmegəhən məmə ekɨkɨs ilat e rəhalat nolən rat mɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nian Iesu ne rəhan mɨn netəmim kəmoatiet e taon Jeriko, nɨmanin netəmim kəmotətəu-pən in. ");
INSERT INTO tnn_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kən iganəmtɨn rat mil kəiu katuəpələh e nɨkalɨ suatɨp, kən nian kəmuəto məmə Iesu taliwək e suatɨp matuwa, kən kəmuagət əfəməh muən məmə, “!Iərəmərə, Mipɨ Tefɨt, asəkitun itɨmlau!” ");
INSERT INTO tnn_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kən məto, nɨmanin netəmim koatən-iəhau ilau, motən-ipən məmə kəsuagət pɨkən, məto ilau kuagət pɨk agɨn mɨn məmə, “!Iərəmərə, Mipɨ Tefɨt, asəkitun itɨmlau!” ");
INSERT INTO tnn_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kən Iesu tətul maun-in ilau, mən-ipən məmə, “?Nakioalkeike məmə ekol naka kəm itəlau?” ");
INSERT INTO tnn_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kən kuən-ipən məmə, “Iərəmərə, ekioalkeike məmə ekuəplan nat.” ");
INSERT INTO tnn_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Kən Iesu təmasəkitun ilau, kən mek nɨganəmtɨlau. Kən roiu agɨn, kɨnatuəplan nat, kən matuətəu-pən Iesu. ");
INSERT INTO tnn_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nian kɨnotuwa iuəhkɨr o Jerusalem, kɨnotuwa Petfas e Nɨtot Rəha Nɨg U Olif, kən Iesu tahləpis rəhan etəmim kəiu, ");
INSERT INTO tnn_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","kən mən-ipən kəm ilau məmə, “Ian əpəh e latuənu aupən etat, kən ikɨn əh, nakuəplan togki kit kəməruətain ilau nətɨn. Kən nəkiakɨs ilau muasɨg muea kəm io. ");
INSERT INTO tnn_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Okəmə suah kit tən nat kit kəm itəlau, nəkuən-ipən kəm in məmə Iərəmərə tolkeike ilau, kən otəpanahl-ipa ilau e nian əh.” ");
INSERT INTO tnn_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nat u təmuwa məmə in otol nəghatən naka itəm ien təmən otuwa mol nɨpahrienən. Ien təmən məmə, ");
INSERT INTO tnn_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Otən-ipən kəm Nətɨn Pətan Saeon məmə, ‘Otəplan-tu, rəhatəmat kig tatuwa otəmat, rəhan nətəlɨgən in ləhau, kən mətasuə e togki, ne togki u in nətɨn əm.’” ");
INSERT INTO tnn_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kən etəmim mil rəha Iesu kəmian mioal nat naka itəm Iesu təmən məmə okioal. ");
INSERT INTO tnn_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Kəmuasɨg togki ne nətɨn, kən muəfətain noankawi togki mil e rəhalau kot mɨn, kən Iesu təpələh-pər lan. ");
INSERT INTO tnn_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nɨmanin netəmim tepət koatəpen rəhalat kot mɨn əpəh e suatɨp, kən neen kotəte nɨmalɨ nɨg mɨn, kən motəpen ilat e suatɨp. ");
INSERT INTO tnn_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kən nimanin netəmim itəm kotaupən e Iesu, ne nɨmanin netəmim itəm kotuarisɨg-in Iesu, koatagət əfəməh moatən məmə, “!Hosana o Mipɨ Tefɨt! !Iərəmərə Uhgɨn tətatɨg ilau suah u itəm tatuwa e nərgɨn! !Hosana o Uhgɨn əpəh ilɨs e nego e neai!” ");
INSERT INTO tnn_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nian Iesu təmiet-arəpa Jerusalem, netəmim rafin əh-ikɨn nɨkilat təmaut, kən moatən nəghatən tepət moatətapəh məmə, “?Pah u?” ");
INSERT INTO tnn_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kən nɨmanin netəmim kotən məmə, “Inu ien Iesu, rəha Nasaret, əpəh e nɨtən Kalili.” ");
INSERT INTO tnn_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kən Iesu təmuwɨn əpəh imə e Nimə Rəha Uhgɨn, kən məhg-iarəp netəmim itəm koatol-salɨm-in ne moatos-nəmtɨn natɨmnat əh-ikɨn məmə okotol sakrifais lan. Kən mahwin tepɨl mɨn itəm kətawluin məni ikɨn, kən mahwin jea mɨn rəha netəm mɨn u koatol-salɨm-in ioen mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kən mən-ipən kəm ilat məmə, “Kəməte e Naoa Rəha Uhgɨn məmə, ‘Rəhak nimə, okaun-in məmə nimə rəha nəghatən kəm Uhgɨn e nəfakən,’ məto itəmat nəmotol məmə in ‘nimə rəha iakləh mɨn.’” ");
INSERT INTO tnn_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kən iganəmtɨn rat mɨn ne netəm nelkɨlat təməfaiu-əfaiu kəmotuwa ron əpəh e Nimə Rəha Uhgɨn, kən tol-wɨr ilat. ");
INSERT INTO tnn_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Məto nian pris asol mɨn ne iəgətun mɨn rəha Lou kəmotəplan nat wɨr mɨn itəm in təmol, kən motəplan mɨn nɨsualkələh koatagət əfəməh əpəh e Nimə Rəha Uhgɨn, moatən məmə, “!Hosana o Mipɨ Tefɨt!” neməha təmol ilat. ");
INSERT INTO tnn_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kən kotən-ipən kəm Iesu məmə, “?Nakatəto nat naka itəm nɨsualkələh koatən, o kəp?” Kən Iesu təmən-ipən kəm ilat məmə, “Əwəh. ?Nəmotafin, o kəp, nəghatən suah kit təmen kəm Uhgɨn itəm tatən nulan məmə, ‘E nohlɨ nɨsualkələh agɨn ne nɨsualkələh mətmətɨg, nəmol məmə ilat okotənwiwi ik’?” ");
INSERT INTO tnn_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kən təmapəs ilat miet Jerusalem muwɨn e taon Petani, mapɨl ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Laulaugɨn agɨn, Iesu təmatɨtəlɨg-pən Jerusalem, kən nəumɨs tɨnus. ");
INSERT INTO tnn_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kən təməplan nɨg u fik e nɨkalɨ suatɨp, kən təmuwɨn ron məto təsəplanən noan kit, tatəplan əm nɨmalɨn. Kən təmən-ipən kəm nɨg u məmə, “!Okol nəsoe mɨnən!” Kən roiu agɨn, nɨg təmauke-auke. ");
INSERT INTO tnn_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nian rəhan netəmim kəmotəplan nat əh, kən narmɨlat təmiwɨg, kən motən-ipən kəm Iesu məmə, “?Tahro nɨg əh fik təmauke-auke uəhai əm nəhlan?” ");
INSERT INTO tnn_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Məto Iesu təmən-ipən məmə, “Iatən-ipɨnə nɨpahrienən məmə okəmə nakoatos nahatətəən, kən rəhatəmat nətəlɨgən təsolən kəiu, nəkotɨtun nolən nat naka itəm emol e nɨg u fik. Məto sənəmə in əm əh, nəkotɨtun nən-ipənən kəm nɨtot əh məmə, ‘Uwɨn mamnɨm əpəh itəhəi,’ kən otol nəwiatəmat. ");
INSERT INTO tnn_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Okəmə nakotahatətə, kən onəkotos nat naka itəm nakoatətapəh-in e nəfakən.” ");
INSERT INTO tnn_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iesu təmuwɨn e Nimə Rəha Uhgɨn, kən nian təmatəgətun, pris asol mɨn ne netəm-iasol rəha netəm Isrel, koatuwa ron motən-ipən məmə, “?Natol natɨmnat mɨn u e nepətən rəha pah? ?Kən pah təmos-ipɨnə nepətən un?” ");
INSERT INTO tnn_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Kən Iesu təmən-ipən məmə, “Iakətapəh-in-pɨnə nəghatən kit kəm itəmat. Okəmə nakotos-ipa nəghatən kit, kən ekən-ipɨnə kəm itəmat məmə nepətən naka itəm ekatol natɨmnat mɨn u lan. ");
INSERT INTO tnn_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","?Nepətən rəha Jon təmɨsɨ-pən hiə o nolə baptais? ?Təmɨsɨ-pən e nego e neai, o rəha netəmim əm?” Kən kəmotən-ipən kəm ilat mɨn məmə, “Okəmə kotən məmə, ‘Nepətən rəha Jon təmɨsɨ-pən e nego e neai,’ kən otən məmə, ‘?Məto tahro nəsotənən nɨpahrienən lan?’ ");
INSERT INTO tnn_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Məto okəmə kotən məmə, ‘Rəha netəmim əm,’ kitat koatəgin netəmim, məto-inu nɨkilat təht məmə Jon in ien kit rəha Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tol nəhlan, kəmotən-ipən kəm Iesu məmə, “Itɨmat ekotəruru.” Kən Iesu təmən-ipən kəm ilat məmə, “Kən io mɨn, okol ekəsənən kəm itəmat məmə e nepətən naka ekatol natɨmnat mɨn u lan.” ");
INSERT INTO tnn_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kən Iesu təmən-ipən məmə, “?Tahro? ?Nɨkitəmat tatəht məmə naka? Suah kit, nətɨn iərman kəiu. Kən təmuwɨn mən-ipən kəm itəm iahgin lan məmə, ‘Nətɨk, uwɨn mol wək u-roiu əpəh e nasumən.’ ");
INSERT INTO tnn_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Məto nətɨn təmən-ipən məmə, ‘Iakapəs.’ Kən matɨg məuhlin mɨn rəhan nətəlɨgən, kən muwɨn e nasumən. ");
INSERT INTO tnn_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Kən tata tuwɨn o nətɨn itəm təkəku, mən-ipən mɨn kəm in nat kitiəh əm. Kən nətɨn təmən-ipən məmə, ‘Əwəh, tata, ekuwɨn,’ məto təmapəs-pən e nasumən. ");
INSERT INTO tnn_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“?Otən-tu məmə suakəku mil u in pəhruən, təmol nəwia rəhan tata?” Kən kəmotən-ipən məmə, “Suakəku itəm iahgin lan.” Kən Iesu təmən-ipən kəm ilat məmə, “Əwəh, in ətuatɨp. Kən iakatən-ipɨnə nɨpahrienən məmə, netəm koatos məni rəha takɨs, ne nɨpɨtan rəha suatɨp koatuwɨn e nərəmərəən rəha Uhgɨn aupən etəmat, ");
INSERT INTO tnn_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","məto-inu Jon təmuwa otəmat məmə otəgətun suatɨp rəha nolən ətuatɨp, kən məto itəmat nəsotənən nɨpahrienən lan, məto netəm koatos məni rəha takɨs, ne nɨpɨtan rəha suatɨp kəmotən nɨpahrienən lan. Kən nəmotəplan pap nat əh, məto nəməsotəuhlinən itəmat e rəhatəmat nolən rat mɨn, kən məsotənən nɨpahrienən lan.” ");
INSERT INTO tnn_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Kən Iesu tatəkəike matən məmə, “Otətəlɨg-in-tu nimaa nəghatən kit mɨn. Etəm-iasol kit rəha nasumən, təmol nasumən kit e nol kit katən məmə krep, u katol wain lan. Kən mol fenis e kəpiel muwɨn mɨtəlau lan. Kən mol ikɨn kit o nolən nəme naliwək-aliwəkən e noa krep məmə nahuin otaiu kən kol wain lan. Kən mol nimə kit itəm in ilɨs məmə etəmim otaiu lan matehm wɨr nasumən o nat megəh mɨn ne netəmim. Kən təmegəhan-in-pən nasumən kəm netəmim məmə okotasum lan, kən motoor noa krep, məsɨn rəhan, məsɨn rəhalat. Kən miet muwɨn o naliwəkən ik pɨsɨn kit. ");
INSERT INTO tnn_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nian krep tɨnəmarəg, kən tahl-ipən rəhan slef mɨn məmə okotuwɨn e nasumən rəha krep, motətapəh o netəm koatol wək e nasumən məmə okotos-ipən rəhan krep məsɨn kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Məto netəm koatol wək e nasumən kəmotaskəlɨm rəhan slef mɨn, kən motoh kit, motohamnu kit, motaht e kəpiel itəm tatol kɨsɨl lan. ");
INSERT INTO tnn_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kən tahl-ipən mɨn slef mɨn neen kotuwɨn olat, ilat tepət taprəkɨs-in itəm aupən mɨn. Kən netəm koatol wək e nasumən kotol tərat kəm ilat e nolən ahmen mɨn əm itəm kəmotol kəm netəm aupən. ");
INSERT INTO tnn_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Namnun agɨn, tahl-ipən nətɨn iərman tuwɨn olat, kən mən məmə, ‘Ilat okotəkəike motɨsiai-in nətɨk.’ ");
INSERT INTO tnn_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Məto nian netəm koatol wək e nasumən kəmotəplan nətɨn, kən kotən-ipən kəm ilat mɨn məmə, ‘Inu nətɨ etəm-iasol itəm otərəmərə e nasumən nian rəhan tata otɨmɨs. Pəs kotuwɨn motohamnu mɨn, kən motərəmərə e nasumən rəhan.’ ");
INSERT INTO tnn_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kən kəmotaskəlɨm motatɨpin-iarəp e nasumən, kən motohamnu.” ");
INSERT INTO tnn_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Kən nian Iesu təmol namnun nimaa nəghatən, kən təmən məmə, “?Tol nulan, nian etəm-iasol rəha nasumən otuwa, kən otol naka kəm netəmim itəm təmegəhan-in nasumən kəm ilat?” ");
INSERT INTO tnn_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Kən kəmotən-ipən məmə, “Otərək-rəkɨn agɨn-əh netəm rat mɨn əh, motohamnu ilat. Kən uarisɨg, təpanegəhan-in rəhan nasumən əh tuwɨn e nelmɨ netəm pɨsɨn neen, kən e nian ətuatɨp itəm krep tatəmarəg, ilat okotos-ipən noan məsɨn rəhan.” ");
INSERT INTO tnn_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kən Iesu təmən-ipən kəm ilat məmə, “?Nəmotafin Naoa Rəha Uhgɨn u, o kəp? Tatən məmə, ‘Kəpiel u itəm netəm rəha niləkɨnən nimə kəsotolkeikeən motapəs, in tɨnuwa kəpiel keike o nolən nimə. Iərəmərə təmol nat u, kən in nat təwɨr agɨn e nɨganəmtɨtat.’ ");
INSERT INTO tnn_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Tol nəhlan, iatən kəm itəmat məmə nərəmərəən rəha Uhgɨn okoh-rəkɨs otəmat, kən kos-ipən kəm netəmim mɨn u itəm okotol noalat. ");
INSERT INTO tnn_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Okəmə suah kit otɨsɨ-pər e kəpiel u, kəpiel otətarerəh-ətarerəh, məto okəmə kəpiel otɨsɨ-pər lan, otəpələh-ərən in.” ");
INSERT INTO tnn_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nian pris asol mɨn ne Farisi mɨn kəmotəto nimaa nəghatən itəm Iesu təmuəh, kən kɨnotɨtun məmə tatəghat-in ilat. ");
INSERT INTO tnn_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kən kɨnotegəs-in suatɨp kit məmə okotɨləs Iesu lan kan e kalapus, məto koatəgin nɨmanin netəmim, məto-inu netəmim koatən məmə in ien kit. ");
INSERT INTO tnn_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Kən Iesu təmuəh nimaa nəghatən kit mɨn kəm ilat məmə, ");
INSERT INTO tnn_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Nərəmərəən rəha Uhgɨn in tahmen e kig kit itəm təmol əpen-əpenə e nagwənən asol o marɨt rəha nətɨn. ");
INSERT INTO tnn_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kən mahl-ipən rəhan iolwək mɨn məmə okotuwɨn o netəmim mɨn u itəm təmahl-ipən rəkɨs nəghatən olat məmə okotuwa o nagwənən rəha marɨt. Məto kotən məmə kol kəsotuwamən. ");
INSERT INTO tnn_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Kən tahl-ipən rəhan iolwək neen mɨn, mən-ipən kəm ilat məmə, ‘Otuwɨn motən-ipən kəm netəm mɨn u itəm emahl-ipən rəkɨs nəghatən olat məmə, enol əpen-əpenə rəkɨs e rəhak nagwənən. Rəhak kau mɨn ne nətɨ kau mɨn rəhak itəm kotəhg-əhg wɨr, emoh rəkɨs ilat, kən natɨmnat rafin tɨnahmen. Otuwa e nagwənən rəha marɨt.’ ");
INSERT INTO tnn_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Məto kəsotətəlɨg-inən iolwək mɨn, kən motagɨm mɨn, kit tatuwɨn e rəhan nasumən, kit tatuwɨn e rəhan stoa. ");
INSERT INTO tnn_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Kən neen kotaskəlɨm iolwək mɨn rəhan, motol tərat kəm ilat, kən motohamnu ilat. ");
INSERT INTO tnn_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kən kig, neməha təmol pɨk. Kən tahl-ipən rəhan mopael mɨn kotuwɨn, kən motohamnu netəmim mɨn u itəm kəmotohamnu rəhan iolwək mɨn, kən motasiepən e rəhalat taon asol. ");
INSERT INTO tnn_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Kən mən-ipən kəm rəhan iolwək mɨn məmə, ‘Kɨnol əpen-əpenə rəkɨs e nagwənən rəha marɨt, məto netəm mɨn u itəm emahl-ipən rəkɨs nəghatən olat, nolən rəhalat təsahmenən məmə okotuwa. ");
INSERT INTO tnn_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tol nəhlan, otuwɨn əpəh e suatɨp asol mɨn kən motən-ipən kəm netəmim əpnapɨn rafin itəm nakoatəplan məmə okotuwa e nagwənən rəha marɨt.’ ");
INSERT INTO tnn_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kən iolwək mɨn kəmotuwɨn əpəh e suatɨp asol mɨn, kəmotuəfɨmɨn netəmim rafin itəm kəmotəplan ilat, netəmim itəm kotəwɨr ne netəm itəm kotərat, kən ikɨn kətagwən ikɨn təmərioah e netəmim. ");
INSERT INTO tnn_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Məto nian kig təmuwa məplan netəmim, təməplan etəmim kit əh-ikɨn itəm təsuwɨnən e natɨmnat rəha marɨt. ");
INSERT INTO tnn_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kən kig təmən-ipən məmə, ‘?Io kit, nəmahro? ?Nəmuwa imə məto nəməsuwɨnən e natɨmnat rəha marɨt?’ Kən suah u tɨnəruru nuhalpɨnən nəghatən rəhan. ");
INSERT INTO tnn_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Kən kig təmən-ipən kəm rəhan mɨn netəmim məmə, ‘Okotəlis ətain nelmɨn ne nelkɨn, kən motərakin-iarəp əpəh e nalugɨnən itəm ikɨn kətasək ikɨn, kən katəgətain nəluɨtəm ikɨn.’” ");
INSERT INTO tnn_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kən Iesu təmatəkəike mən məmə, “Tol nəhlan məto-inu netəmim tepət, kətahl-ipən nəghatən olat, məto noan məsɨn əm itəm katɨtəpun ilat.” ");
INSERT INTO tnn_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kən Farisi mɨn kəmotiet motuwɨn motol noa eko-eko mɨn məmə otiuw-pən Iesu o nənən nəghatən kit itəm təsətuatɨpən. ");
INSERT INTO tnn_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kən kotahl-ipən rəhalat netəmim kotuwɨn o Iesu ilat netəmim rəha pati rəha Herot. Kən motən-ipən məmə, “Iəgətun. Ekotɨtun məmə ik etəm ətuatɨp, kən matəgətun ətuatɨp pahrien suatɨp rəha Uhgɨn. Nəsolən məmə nətəlɨgən rəha netəmim okotiuw rəkɨs rəham nətəlɨgən, məto-inu natol tahmen-ahmen əm kəm netəmim rafin, okəmə in etəm-iasol o etəm əpnapɨn əm. ");
INSERT INTO tnn_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kən ən-tu kəm itɨmat rəham nətəlɨgən e nat u. ?Tətuatɨp məmə okətou-pən takɨs kəm Kig Sisa, o kəp?” ");
INSERT INTO tnn_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Məto Iesu tɨnɨtun rəhalat nətəlɨgən rat mɨn, kən təmən-ipən kəm ilat məmə, “!Rəhatəmat nənən təwɨr, məto nɨkitəmat tamkɨmɨk! ?Tahro nakotalkut məmə nəkotol noa eko-eko ron io? ");
INSERT INTO tnn_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Otəgətun-tu məni itəm katətou takɨs lan.” Kən kotos məni motuwa kəm in, ");
INSERT INTO tnn_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","kən təmən-ipən kəm ilat məmə, “?Narmɨ pah u, kən nərgɨ pah u e məni u?” ");
INSERT INTO tnn_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Kən kotən-ipən məmə, “Kig Sisa.” Kən Iesu təmən-ipən kəm ilat məmə, “Naka u rəha Kig Sisa, otos-ipən kəm Kig Sisa. Kən naka u rəha Uhgɨn, otos-ipən kəm Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nian kəmotəto nəghatən əh, narmɨlat təmiwɨg. Kən kəmotapəs Iesu motagɨm. ");
INSERT INTO tnn_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","E nian əh inəh, Satusi mɨn kəmotuwa o Iesu. Ilat koatən məmə netəmim okəsotəmegəh mɨnən e nɨmɨsən. Kən kotən-ipən kəm Iesu məmə, ");
INSERT INTO tnn_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Iəgətun. Moses təmən kəm itɨmat məmə, okəmə etəmim otɨmɨs kən məsɨləsən nətɨn kit, kən pian otəkəike mit nəutahlɨmɨs əh məmə otɨləs suakəku o niuw-pərən nərɨg rəha pian itəm təmɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","“Kən ikɨn əh imatɨmat ikɨn, netəm ilat pialat mɨn ilat sepɨn. Itəm təmaupən maiir təmol marɨt, kən mɨmɨs, məsɨləsən nətɨn kit, kən pian itəm tatol kəiu lan tit nəutahlɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kən in mɨn təmɨmɨs məsɨləsən nətɨn kit, kən itəm tatol kɨsɨl lan ne ilat rafin muwɨn mətoarus-pən itəm tatol sepɨn, kəmotol nat kitiəh əm. ");
INSERT INTO tnn_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kən əmun, nəutahlɨmɨs tɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","?Tol nəhlan, ən-tu kəm itɨmat məmə, e nian itəm Uhgɨn otosmegəh netəmim lan e nɨmɨsən, pətan əh in rəha pah, məto-inu ilat rafin əh sepɨn kəmotol marɨt e pətan əh?” ");
INSERT INTO tnn_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Kən Iesu təmən-ipən kəm ilat məmə, “Itəmat nəmotən-arəpən e rəhatəmat nəghatən məto-inu nəsotɨtunən Naoa Rəha Uhgɨn ne nəsanənən rəhan. ");
INSERT INTO tnn_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nian Uhgɨn otosmegəh netəmim e nɨmɨsən, kən netəmim okəsətolən marɨt, okotahmen e nagelo mɨn əpəh e nego e neai. ");
INSERT INTO tnn_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","?Nəmotafin o kəp, Naoa Rəha Uhgɨn itəm tatəghat-in nian Uhgɨn otosmegəh netəmim e nɨmɨsən? Tatən məmə, ");
INSERT INTO tnn_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Io Uhgɨn rəha Epraham, io Uhgɨn rəha Aisak, kən io Uhgɨn rəha Jekop.’ In sənəmə Uhgɨn rəha netəm kəmotɨmɨs, məto in Uhgɨn rəha netəmim itəm koatəmegəh, tahmen-pən mɨn e təs miləhal.” ");
INSERT INTO tnn_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nian nɨmanin netəmim kəmotəto nəghatən əh, narmɨlat təmiwɨg e nəgətunən rəhan. ");
INSERT INTO tnn_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nian Farisi mɨn kəmotəto məmə Iesu təmoh-iəhau Satusi mɨn e rəhan nəghatən, kən Farisi mɨn kəmotuwa kitiəh. ");
INSERT INTO tnn_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Kən kit itəm tɨtun pɨk Lou, təmən-ipən nəghatən kit kəm Iesu məmə Iesu otən nəghatən kit təsətuatɨpən, məmə, ");
INSERT INTO tnn_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“?Lou pəhruən rəha Uhgɨn u in ilɨs pɨk?” ");
INSERT INTO tnn_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Kən Iesu təmən-ipən məmə, “Nakəkəike molkeike Iərəmərə Uhgɨn rəham e nɨkim rafin, ne nəmegəhən rafin rəham, ne nətəlɨgən rafin rəham. ");
INSERT INTO tnn_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Inu in Lou itəm tətaupən kən in ilɨs pɨk. ");
INSERT INTO tnn_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kən Lou itəm tatol kəiu lan, in iuəhkɨr tahmen əm, məmə, ‘Nakəkəike molkeike ik kit tahmen əm məmə nakolkeike atɨp ik.’ ");
INSERT INTO tnn_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kən Lou mil u kəiu, ilau nəukətɨ Lou rafin, ne naoa rəha ien mɨn rafin aupən.” ");
INSERT INTO tnn_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Kən e nian Farisi mɨn kotuəfɨmɨn ilat mɨn, kən Iesu təmən-ipən məmə, ");
INSERT INTO tnn_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“?Nɨkitəmat təht məmə naka, e Kristo itəm Uhgɨn təmən məmə otahl-ipa? ?In tatɨsɨ-pən e noanol rəha pah?” Kən ilat kotən-ipən məmə, “In noanol rəha Tefɨt.” ");
INSERT INTO tnn_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Kən Iesu təmən-ipən məmə, “Məto tahro e Tefɨt, itəm tatəghat e narmɨn rəha Uhgɨn, tətaun-in Kristo məmə ‘Iərəmərə.’ Məto-inu tatən məmə, ");
INSERT INTO tnn_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Iərəmərə təmən kəm rəhak Iərəmərə məmə, “Əpələh e nɨkalɨk e nelmək matɨp, ikɨn rəha nəsanənən ne nɨsiaiiən, mətoarus ekɨləs-iəhau rəham tɨkɨmɨr mɨn ləhau e nelkəm.”’ ");
INSERT INTO tnn_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","?Kən okəmə Tefɨt tətaun-in Kristo məmə ‘rəhak Iərəmərə,’ kən otahro məmə Kristo in mipɨ Tefɨt rat?” ");
INSERT INTO tnn_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kən etəmim kit təsuhalpɨnən nəghatən rəha Iesu. Kən e nian əh matuwɨn, kəmotəgɨn o nətapəh-inən nəghatən kit mɨn tol min-nəhlan. ");
INSERT INTO tnn_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kən Iesu təmən-ipən kəm nɨmanin netəmim ne rəhan mɨn netəmim məmə, ");
INSERT INTO tnn_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Iəgətun mɨn rəha Lou ne Farisi mɨn koatos nepətən məmə okotən-iarəp Lou rəha Moses kəm itəmat. ");
INSERT INTO tnn_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tol nəhlan, nəkotəkəike motətəu-pən kən motol natɨmnat rafin itəm koatən kəm itəmat. Məto nəsotolən nat naka itəm koatol, məto-inu ilat kəsotolən nat naka itəm koatən-iarəp. ");
INSERT INTO tnn_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Koatəkəike o netəmim məmə okotətəu-pən lou əskasɨk mɨn itəm kotahmen e katipa əfɨgəm, məto okol kəsotos-ipənən noanelmɨlat məmə okasitu elat. ");
INSERT INTO tnn_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Natɨmnat rafin itəm ilat koatol, koatol əm məmə netəmim okotəplan. Nəkotɨtun paos itəm netəmim kəmotaii-pən nəghatən rəha Naoa Rəha Uhgɨn ikɨn, kənu motəlis rəhalat-kapə ne nelmɨlat lan. Məto rəha iəgətun mɨn rəha Lou ne Farisi mɨn, rəhalat paos in iahgɨn taprəkɨs. Kən nəkotɨtun nol əlkələh mɨn itəm koatəkul-pən e nɨpəgnəmtɨ kot mɨn, itəm tatəgətun məmə etəmim in təskasɨk o nətəu-pənən Lou. Məto rəha iəgətun mɨn rəha Lou ne Farisi mɨn, rəhalat nol kaifəməh pɨk. ");
INSERT INTO tnn_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kən e lafet mɨn, ilat kotolkeike ikɨn rəha nɨsiaiiən, kən əpəh e nimə rəha nuəfɨmɨnən, ilat kotolkeike məmə okotəpələh ima netəm-iasol mɨn ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kən e ikɨn katol maket ikɨn, ilat kotolkeike məmə netəmim kotən təwɨr kəm ilat, kən motaun-in ilat məmə ‘Rapai’ u nɨpətɨn təmə ‘etəm in ilɨs.’ ");
INSERT INTO tnn_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Məto sotolən məmə netəmim okotaun-in itəmat məmə ‘Rapai, u etəm in ilɨs,’ məto-inu rəhatəmat Etəm-iasol kitiəh əm, kən itəmat piatəmat mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kən sotaun-inən suah kit u e nətueintən məmə, ‘Tata, etəm katɨsiai-in,’ məto-inu Tata rəhatəmat kitiəh əm əpəh ilɨs e nego e neai. ");
INSERT INTO tnn_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kən sotolən məmə netəmim okotaun-in itəmat məmə, ‘Iəgətun,’ məto-inu rəhatəmat Iəgətun kitiəh əm, Kristo itəm Uhgɨn təmən məmə otahl-ipa. ");
INSERT INTO tnn_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Etəm u in ilɨs etəmat, in iolwək rəhatəmat. ");
INSERT INTO tnn_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tol nəhlan məto-inu, etəmim itəm otos-ipər atɨp in, Uhgɨn otɨləs-iəhau, kən etəmim itəm otos-iəhau atɨp in, Uhgɨn otɨləs-ipər. ");
INSERT INTO tnn_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“!Kəsi, nahməən asol otuwa otəmat iəgətun mɨn rəha Lou, ne Farisi mɨn! !Rəhatəmat nənən təwɨr, məto nɨkitəmat tamkɨmɨk! Nakotahtosɨg-in o netəmim suatɨp o nuwɨnən matɨg ahgin nərəmərəən rəha Uhgɨn, məto itəmat nəsotuwɨnən, kən nəsotegəhan-inən məmə netəmim okotuwɨn ikɨn, nat əpnapɨn ilat kotolkeike məmə okotuwɨn. ");
INSERT INTO tnn_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“!Kəsi, nahməən asol otuwa otəmat iəgətun mɨn rəha Lou, ne Farisi mɨn! !Rəhatəmat nənən təwɨr, məto nɨkitəmat tamkɨmɨk! Nɨkitəmat tagien əm məmə nakotuwɨn isəu e nego, o e naliwəkən əm o nuwɨnən e nəptən pɨsɨn pɨsɨn mɨn məmə nakotiuw-pa etəmim kitiəh əm e nəfakən rəhatəmat. Məto nian suah kit tatos nolən mɨn əh rəhatəmat, kən tatuwa etəm rat taprəkɨs-in itəmat, kən nəmotol məmə in otəkəike mos nalpɨnən rəha nɨgəm asol taprəkɨs-in itəmat. ");
INSERT INTO tnn_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“!Kəsi, nahməən asol otuwa otəmat itəm noatit netəmim məto nɨganəmtɨtəmat təpɨs! Itəmat nakoatən məmə, ‘Okəmə suah kit tatos noanawɨl o Nimə Rəha Uhgɨn məmə otol rəhan nəghatən tatətul-iəkɨs, okəmə təsolən, məto in nat əpnapɨn əm. Məto okəmə suah kit tatos noanawɨl o iaen u kol tatɨpɨt-ɨpɨt rəha Nimə Rəha Uhgɨn, kən in otəkəike mol nəwian itəm təmos noanawɨl ron.’ ");
INSERT INTO tnn_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","!Itəmat netəm nakotalməl, nɨganəmtɨtəmat təpɨs! ?Naka u in ilɨs, iaen u kol tatɨpɨt-ɨpɨt, o Nimə Rəha Uhgɨn itəm tatol kol tasim? ");
INSERT INTO tnn_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nakotən mɨn məmə, ‘Okəmə suah kit tatos noanawɨl o olta, in nat əpnapɨn əm. Məto okəmə suah kit tatos noanawɨl e sakrifais itəm tatəpələh lan, kən in otəkəike mol nəwian itəm təmos noanawɨl ron.’ ");
INSERT INTO tnn_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","!Itəmat netəm nɨganəmtɨtəmat təpɨs! ?Naka u in ilɨs, sakrifais o olta itəm tatol sakrifais tasim? ");
INSERT INTO tnn_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tol nəhlan, etəm tatos noanawɨl e olta, pahrien, tatos noanawɨl e olta ne natɨmnat rafin itəm tatəpələh lan. ");
INSERT INTO tnn_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kən etəm tatos noanawɨl e Nimə Rəha Uhgɨn, pahrien tatos noanawɨl e Nimə Rəha Uhgɨn ne Suah u tətatɨg ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kən etəm tatos noanawɨl e nego e neai, pahrien tatos noanawɨl o jea rəha kig u in rəha Uhgɨn, kən tatos noanawɨl o Suah u tatəpələh-pər lan. ");
INSERT INTO tnn_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“!Kəsi, nahməən asol otuwa otəmat iəgətun mɨn rəha Lou, ne Farisi mɨn! !Rəhatəmat nənən təwɨr, məto nɨkitəmat tamkɨmɨk! Nəkoatətəu-pən lou əlkələh mɨn moatos-ipən tait rəha rəhatəmat nɨmalɨ nɨg nəmiəwɨlat tatəpien u katos-ipən e nagwənən, katən məmə min, ne til, ne kumɨn. Məto nakotapəs nat asol e Lou, inu etəm tatol tətuatɨp kən mahmen-ahmen əm kəm netəmim, kən mətasəkitun netəmim, kən tatol nian rafin nat naka itəm təike matol. Təwɨr nəkoatol lou əlkələh mɨn, məto nəkotəkəike moatol lou asol mɨn, məto kəp, nəsotolən. ");
INSERT INTO tnn_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","!Itəmat noatit netəmim məto nɨganəmtɨtəmat təpɨs! !Itəmat netəmim noategəs-in miminao e rəhatəmat kap məmə ko nəsotərgeən, məto nəkotərge nat megəh asol u kamel! ");
INSERT INTO tnn_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“!Kəsi, nahməən asol otuwa otəmat iəgətun mɨn rəha Lou, ne Farisi mɨn! !Rəhatəmat nənən təwɨr, məto nɨkitəmat tamkɨmɨk! Nakotafəl ihluə e kap ne plet, məto əpəh imə tamkɨmɨk, kotərioah e nagwənən ne nənɨmən itəm nəmotakləh-in, o natɨmnat itəm nəmotos məto-inu itəmat iaumɨs mɨn kən nian rafin nəkoatol əm natɨmnat rat mɨn itəm tətatɨg e rəhatəmat nətəlɨgən. ");
INSERT INTO tnn_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","!Itəmat Farisi mɨn, nɨganəmtɨtəmat təpɨs! Otaupən kafəl əpəh imə e kap ne plet, kən ihluə mɨn in təwɨr təsamkɨmɨkən. ");
INSERT INTO tnn_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“!Kəsi, nahməən asol otuwa otəmat iəgətun mɨn rəha Lou, ne Farisi mɨn! !Rəhatəmat nənən təwɨr, məto nɨkitəmat tamkɨmɨk! Nəkotahmen e suwɨt rəha netəm kəmotɨmɨs itəm kəmuəh e pen ruən. Ihluə, netəmim kotəplan məmə təwɨr, məto əpəh imə tərioah e nɨkɨlkɨli netəm kəmotɨmɨs, ne natɨmnat rafin itəm tamkɨmɨk. ");
INSERT INTO tnn_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","E nolən ahmen mɨn əm, ihluə, e nolən rəhatəmat, netəmim kotəplan məmə itəmat nəkotətuatɨp. Məto imə, e nɨkitəmat, nakotərioah e nəghatən nakotən məsotolən, ne nolən rat agɨn mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“!Kəsi, nahməən asol otuwa otəmat iəgətun mɨn rəha Lou, ne Farisi mɨn! !Rəhatəmat nənən təwɨr, məto nɨkitəmat tamkɨmɨk! Nakotiləkɨn nimə e kəpiel rəha suwɨt rəha ien mɨn aupən ne netəm kotətuatɨp, kən moatol nəhlɨp e kəpiel kən moatol malə-malə lan. ");
INSERT INTO tnn_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kən nakotən-ipən məmə, ‘Okəmə itɨmat emotatɨg e nian mɨn rəha tɨpɨtat mɨn, okol itɨmat eməsotasituən elat motohamnu ien mɨn.’ ");
INSERT INTO tnn_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","E nəghatən əh, nakoatən-iarəp məmə itəmat noanol ətuatɨp mɨn rəha tɨpɨtɨmat mɨn aupən itəm kəmotohamnu ien mɨn əh, kən nakotahmen-ahmen əm elat. ");
INSERT INTO tnn_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kən təwɨr əm, itəmat otəkəike motol namnun wək itəm tɨpɨtəmat mɨn kəmotətuoun. ");
INSERT INTO tnn_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“!Itəmat sɨnek mɨn, ne netɨ sɨnek mɨn! ?Nɨkitəmat tatəht məmə okol nakotagɨm e nalpɨnən e nɨgəm asol? !Kəp! ");
INSERT INTO tnn_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Tol nəhlan, ekahl-ipɨnə ien mɨn, ne netəm kotenatɨg, ne iəgətun mɨn. Neen, itəmat onəkotohamnu ilat motətu-pər elat e nɨg kəluau, neen onəkotalis motoh ilat əpəh e nimə rəha nuəfɨmɨnən rəhatəmat, kən neen nakotɨtəp ilat kotiet e taon kit motiet motuwɨn e kit. ");
INSERT INTO tnn_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kən tol nəhlan, itəmat onəkotos nalpɨnən rəha netəmim itəm kəmotohamnu netəmim rafin itəm kotətuatɨp, itəm tətuoun e Epel itəm in tətuatɨp, muwɨn mətoarus-pən Sekaraea, nətɨ Perekia, itəm tɨpɨtəmat mɨn kəmotohamnu e Nimə Rəha Uhgɨn ilugɨn e olta ne nimə. ");
INSERT INTO tnn_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Iatən pahrien kəm itəmat məmə, nalpɨnən rafin u otuwa o netəm rəha Isrel itəm kotatɨg roiu. ");
INSERT INTO tnn_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“!Awe, netəm Jerusalem, netəm Jerusalem! Itəmat nakotohamnu ien mɨn rəha Uhgɨn, kən netəmim itəm Uhgɨn təmahl-ipa kəm itəmat, nəkotahtɨmnu ilat e kəpiel apɨn, inəh netəm u rəha Uhgɨn itəm koatos nəghatən rəhan. Nian tepət iatəg-əfəməh-in nelmək məmə iatəmɨk-əfɨmɨn wɨr itəmat matos wɨr itəmat, tahmen-pən e mənɨg itəm tatu nenətɨn mɨn e nɨkwɨn, məto itəmat nɨkitəmat təsagienən ron kən motapəs io. ");
INSERT INTO tnn_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Otəplan-tu. Uhgɨn tɨnapəs itəmat, rəhatəmat nimə nəratən otoh, kən nat otɨkə ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kən ekən kəm itəmat məmə, nat əh in nɨpahrienən məto-inu onəsotəplan mɨnən io mətoarus nakotən məmə, ‘!Iərəmərə Uhgɨn tətatɨg ilau suah u itəm tatuwa e nərgɨn!’” ");
INSERT INTO tnn_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesu təmiet e Nimə Rəha Uhgɨn maliwək matuwɨn, kən rəhan mɨn netəmim kotuwa motən-ipən kəm in məmə otəplan-tu nimə mɨn u əpəh e Nimə Rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Kən Iesu təmən-ipən məmə, “Əwəh, otəplan-tu nimə mɨn əh. Nɨpahrienən iatən kəm itəmat məmə nimə mɨn əh netəmim okotəhap-əhap kəpiel mɨn elat. Okol kəpiel kit təsəməhlɨn e nəmeen.” ");
INSERT INTO tnn_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kən uarisɨg lan, Iesu təmaliwək ilat rəhan netəmim motuwɨn əpəh e Nɨtot Rəha Nɨg U Olif kən matəpələh. Kən rəhan netəmim kotuwa pɨsɨn əm ron motən-ipən məmə, “?Otən-tu məmə natɨmnat mɨn u okotuwa e nian naka, kən nəmtətin naka otol-arəp məmə rəham nuwamən ne namnun nian tɨnuwa iuəhkɨr?” ");
INSERT INTO tnn_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Kən Iesu təmən-ipən kəm ilat məmə, “Oatehm wɨr itəmat məmə etəmim kit otəseiuə-inən itəmat, ");
INSERT INTO tnn_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","məto-inu netəmim tepət okotuwa motos nərgək moatən məmə, ‘Io Kristo itəm Uhgɨn təmən məmə otahl-ipa,’ kən okoteiuə-in netəmim tepət. ");
INSERT INTO tnn_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Onəkotəto namnusən rəha nəluagɨnən mɨn, kən onəkotəto nəghatən əpnapɨn mɨn məmə netəmim koatəluagɨn. Məto nakoatehm wɨr itəmat məmə nəsotəgɨnən. Natɨmnat mɨn əh otəkəike motuwa motol nɨpahrienən lan, məto namnun nian otəpanuwa. ");
INSERT INTO tnn_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Noanol mɨn okotoh noanol mɨn, kən kantri mɨn okotoh kantri mɨn. Nəumɨs otan, kən namig otəloal ikɨn mɨn tepət. ");
INSERT INTO tnn_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Natɨmnat mɨn əh, nətuounən əm rəha nəratən, tahmen e pətan itəm tɨnətuoun matəto nahməən o neməkən. ");
INSERT INTO tnn_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“E nian mɨn əh, netəmim okotegəhan-in-pən itəmat məmə okol nəratən kəm itəmat, kən kohamnu itəmat, kən netəmim rəha noanol mɨn rafin okotetəhau itəmat məto-inu o nərgək. ");
INSERT INTO tnn_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kən e nian mɨn əh, netəmim tepət okotapəs rəhalat nahatətəən, kən okotegəhan-in-pən ilat mɨn e nelmɨ tɨkɨmɨr mɨn rəhalat, kən motetəhau ilat mɨn, ");
INSERT INTO tnn_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","kən ien eiueiuə mɨn okotuwa moteiuə-in netəmim tepət. ");
INSERT INTO tnn_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Məto-inu nəratən tɨnatepət, iuəhkɨr netəmim rafin rəhalat nolkeikeən o Uhgɨn otɨkə, ");
INSERT INTO tnn_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","məto etəmim itəm otətul əskasɨk mətoarus namnun nian, kən Uhgɨn otosmegəh in. ");
INSERT INTO tnn_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kən namnusən təwɨr əh rəha nərəmərəən rəha Uhgɨn, okən-iarəp ikɨn mɨn rafin e nətueintən, məmə suatɨp əh-ikɨn rəha kantri mɨn rafin o nətəlɨg-inən, kən namnun nian otuwa. ");
INSERT INTO tnn_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ien u Taniel təməghat-in nat kit katən məmə, ‘nat itəm Uhgɨn tatetəhau, kən matol Nimə Rəha Uhgɨn tamkɨmɨk’ (nian nakotafin, otətəlɨg-in nɨpətɨn). Tol nəhlan, nian nat tərat əh tatətul e Nimə Rəha Uhgɨn, ");
INSERT INTO tnn_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","kən itəmat itəm nəkotatɨg Jutia, nakotiet motagɨm motuwɨn motəhluaig e nɨtot mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Okəmə etəmim tətameg ihluə e rəhan nimə, okol təsuwɨnən imə mos mɨn rəhan natɨmnat. ");
INSERT INTO tnn_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Okəmə etəmim əpəh e nasumən rəhan, okol təsɨtəlɨg-pənən latuənu mos rəhan kot. ");
INSERT INTO tnn_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","!Kən kəsi o nɨpɨtan u itəm kotəpɨk-əpɨk, ne nɨpɨtan itəm kotapinahin nɨsualkələh e nian əh, məto-inu ilat okotəto tərat pɨk agɨn! ");
INSERT INTO tnn_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Təwɨr nakotəfak məmə onakəsotagɨmən e nəratən əh e nian rəha nətəpən, o e nian rəha Sapat, ");
INSERT INTO tnn_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","məto-inu e nian əh, nəratən asol otuwa itəm etəmim təməsəplanən tol mihin nəhlan aupən mətoarus-pa u-roiu, kən okol nəratən asol kit tol nəhlan otəsuwa mɨnən nian kit tahmen e in əh. ");
INSERT INTO tnn_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kən okəmə Uhgɨn təsətatɨpən nian rəha nəratən əh, okol etəmim kit təməsəmegəhən. Məto Uhgɨn otətatɨp nian əh o rəhan mɨn netəmim itəm təmɨtəpun rəkɨs ilat. ");
INSERT INTO tnn_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“E nian əh, okəmə suah kit otən-ipɨnə kəm itəmat məmə, ‘!Otəplan-tu, inu Kristo itəm Uhgɨn təmən məmə otəpanahl-ipa!’ o ‘!In əpəh!’ sotənən nɨpahrienən lan, ");
INSERT INTO tnn_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","məto-inu netəmim neen okotuwa motən məmə ilat Kristo, ne ien eiueiuə mɨn okotuwa, kən ilat okotol nəmtətin asol mɨn, ne nat pɨspɨs mɨn məmə okoteiuə-in netəmim, kən okotalkut məmə okoteiuə-in netəmim itəm Uhgɨn təmɨtəpun rəkɨs ilat, okəmə ilat kotɨtun nolən. ");
INSERT INTO tnn_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nɨkitəmat otəkəike matəht wɨr nəghatən mɨn u itəm emən rəkɨs kəm itəmat, uarisɨg natɨmnat mɨn u okotuwa motol nɨpahrienən lan. ");
INSERT INTO tnn_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Tol nəhlan, okəmə suah kit tən kəm itəmat məmə, ‘In əpəh, ikɨn taruən-aruən ikɨn,’ əsotuwɨnən. O suah kit tən məmə, ‘In ikɨn-u e nɨpəg noa nimə,’ sotənən nɨpahrienən lan, ");
INSERT INTO tnn_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","məto-inu nian Nətɨ Etəmim otɨtəlɨg-pa mɨn, otuwa uəhai əm, kən netəmim rafin okotəplan, tahmen e nɨpɨtən itəm təmɨpɨt masiəgəpɨn rafin neai. ");
INSERT INTO tnn_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Nian nat megəh kit təmɨmɨs, nəkotəplan kuəriə mɨn kotuwa məmə okotun. E nolən ahmen mɨn əm, nian nəkotəplan nəmtətin mɨn əh, nəkotɨtun məmə otəsuwəhən ekuwa mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Nian ətuatɨp nəratən əh otol namnun, kən ‘mɨtgar otəpɨs agɨn, kən məwɨg otəsəmɨlhən mɨnən, kən məhau mɨn okotɨsas e neai, kən Uhgɨn otəloal e nəsanənən mɨn əpəh e neai.’ ");
INSERT INTO tnn_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“E nian əh, nəmtətin rəha Nətɨ Etəmim otol-arəp e neai, kən noanol mɨn rafin e nətueintən okotasək e nəgɨnən. Kən okotəplan io, Nətɨ Etəmim ekuwa e nɨmal napuə e neai e nəsanənən ne nepətən əhag-əhag asol rəha Uhgɨn itəm otasiə mɨtəlau lak. ");
INSERT INTO tnn_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kən ekahl-ipən rəhak nagelo mɨn kotiet nian okotəto təwi otasək əfəməh, kən ilat okotuwɨn ikɨn mɨn rafin e nətueintən, motos-irəkɨs rəhak netəmim itəm Uhgɨn təmɨtəpun rəkɨs ilat, kən kuəfɨmɨn ilat kitiəh. ");
INSERT INTO tnn_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Nɨkitəmat otəkəike matəht nɨg u fik. Nian ətuatɨp itəm nelmɨn mɨn kɨnotətuoun katəwiə, kən nɨmalɨn mɨn kɨnoatərget, itəmat nəkotɨtun məmə nian əh inəh itəm nakotasum lan rəhatəmat. ");
INSERT INTO tnn_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kən e nolən ahmen mɨn əm, nian nəkotəplan nəmtətin mɨn əh, onəkotɨtun məmə otəsuwəhən ekuwa mɨn roiu agɨn. ");
INSERT INTO tnn_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Iatən pahrien kəm itəmat məmə netəmim itəm kotatɨg u-roiu, okol kəsotɨmɨs rafinən mətoarus natɨmnat mɨn əh okotuwa kol nɨpahrienən lan. ");
INSERT INTO tnn_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Neai ne nətueintən okiakə, məto nəghatən mɨn rəhak okol kəsotɨkəən.” ");
INSERT INTO tnn_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Kən Iesu təmatəkəike matən məmə, “Suah kit təsɨtunən nian o aua ətuatɨp rəha natɨmnat mɨn əh. Nagelo mɨn əpəh e neai kotəruru, kən io mɨn Netɨ Etəmim ekəruru. Məto Tata Uhgɨn əm in tɨtun nian ətuatɨp əh. ");
INSERT INTO tnn_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","E nian io Nətɨ Etəmim ekuwa lan, otahmen e nian rəha Noah aupən ikɨn itəm netəmim kəsotol əpen-əpenəən ron. ");
INSERT INTO tnn_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","E nian əh, itəm naruəh təsaiuən əh, netəmim koatagwən, moatənɨm, moatol marɨt, inəh natɨmnat rafin kəmoatol e nəmegəhən rəhalat, mətoarus-pən Noah təmuwɨn imə e nɨpəgnoa nego rəhan, ");
INSERT INTO tnn_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","kən ilat kɨnotəruru nat naka otuwa mətoarus-pa naruəh təmaiu məmɨk ilat rafin. In əh otol tahmen əm e nian Nətɨ Etəmim otuwa. ");
INSERT INTO tnn_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Etəmim kəiu e nasumən, kən okos kitiəh, kapəs kitiəh. ");
INSERT INTO tnn_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Pətan kəiu katuəpələh kitiəh matioal nagwənən, kən okos kitiəh, kapəs kitiəh. ");
INSERT INTO tnn_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Tol nəhlan, nəkotəkəike motaiir, məto-inu nəkotəruru nian naka rəhatəmat Iərəmərə otuwa lan. ");
INSERT INTO tnn_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Məto nəkotəkəike motɨtun nat u. Okəmə etəm-iasol rəha nimə tɨtun nian ətuatɨp lapɨn itəm iakləh otuwa, kən in otəkəike mətaiir matehm wɨr nimə məmə iakləh otəsəhapən muwɨn imə. ");
INSERT INTO tnn_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kən itəmat mɨn onəkotəkəike moatətul matɨp, məto-inu Nətɨ Etəmim otuwa e aua əm itəm nɨkitəmat təsəhtən. ");
INSERT INTO tnn_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Nɨkitəmat otəkəike matəht wɨr nolən rəha iolwək itəm in tenatɨg kən tətaskəlɨm wɨr wək rəhan kən məsapəsən. Etəm-iasol təmələhəu məmə iolwək əh otərəmərə e rəhan mɨn rafin iolwək mɨn məmə in otos-ipən nagwənən kəm ilat e nian ətuatɨp. ");
INSERT INTO tnn_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kən okəmə etəm-iasol otuwa məplan etəm tatərəmərə e iolwək mɨn rəhan, kən matol-wɨr rəhan wək, kən otos-ipən nətouən kit kəm suah əh. ");
INSERT INTO tnn_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Iatən-ipɨnə nɨpahrienən məmə etəm-iasol əh otələhəu in tərəmərə e natɨmnat rafin rəhan. ");
INSERT INTO tnn_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Məto okəmə iolwək əh, in etəm rat, kən nɨkin otəht məmə, ‘Rəhak etəm-iasol təsuwamən nuwəh,’ ");
INSERT INTO tnn_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","kən mətuoun matoh iolwək mɨn neen, kən muwɨn magwən mənɨm ilat netəm kotapɨs. ");
INSERT INTO tnn_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kən etəm-iasol rəha iolwək əh otuwa e nian ne aua itəm iolwək nɨkin təsəhtən məmə rəhan etəm-iasol otuwa lan. ");
INSERT INTO tnn_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Etəm-iasol əh otol nalpɨnən asol kəm iolwək əh kən mərakin-pən ikɨn rəha netəm rəhalat nənən təwɨr, məto nɨkilat tamkɨmɨk. Ikɨn əh, netəmim okotasək moatəgətain nəluɨlat.” ");
INSERT INTO tnn_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Kən Iesu təmən-ipən kəm ilat məmə, “E nian itəm rəhatəmat Iərəmərə otuwa mɨn, nərəmərəən rəha Uhgɨn otol nəhlan. Nɨpɨtan əlkələh ilat ten kəmotiet lapɨn məmə okotuwɨn e marɨt kit, kən moatəsahgin etəm otol marɨt otuwa mos rəhan pətan muwɨn e rəhan nimə, əpəh ikɨn katol lafet ikɨn. Ilat ten kəmotos rəhalat lait. ");
INSERT INTO tnn_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Faif kotalməl, kən faif kotenatɨg. ");
INSERT INTO tnn_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nɨpɨtan mɨn u ilat faif itəm kotalməl kəmotos rəhalat lait mɨn, məto kəsotosən karasin məsɨn mɨn o niuw-pənən e lait. ");
INSERT INTO tnn_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Məto nɨpɨtan mɨn u ilat faif itəm kotenatɨg kəmotos rəhalat lait mɨn, kən motos mɨn karasin məsɨn o niuw-pənən e rəhalat lait. ");
INSERT INTO tnn_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kən etəm otol marɨt təsuwa uəhaiən, kən napɨlən tɨnatos ilat koatiuw nəm, kən mɨnotapɨl. ");
INSERT INTO tnn_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Kən lapɨn agɨn, suah kit təmagət əfəməh məmə, ‘!Etəmim itəm otol marɨt tatuwa u-roiu! !Otuwa motəplan!’ ");
INSERT INTO tnn_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Kən nɨpɨtan əlkələh u ilat ten kəmotaiir motuarin asol rəhalat lait mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kən nɨpɨtan itəm kotalməl kotən-ipən kəm nɨpɨtan itəm kotenatɨg məmə, ‘!Awi! Otos-ipa rəhatəmat məsɨn karasin məto-inu rəhatɨmat karasin e rəhatɨmat lait kɨnotamɨr, otəsuwəhən kotəpɨs.’ ");
INSERT INTO tnn_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Məto nɨpɨtan itəm kotenatɨg kotən-ipən kəm ilat məmə, ‘!Kəp! Karasin mɨn u kəsotahmenən o kitat rafin. Məto otɨtəlɨg motuwɨn motos-nəmtɨn rəhatəmat neen karasin əpəh e stoa.’ ");
INSERT INTO tnn_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Məto nian nɨpɨtan itəm kotalməl kəmotaliwək motɨtəlɨg moatuwɨn o karasin, kən etəm itəm otol marɨt təmuwa. Kən nɨpɨtan əlkələh itəm koatətul matɨp, kəmotuwɨn ilat min e nagwənən rəha marɨt, kən motuwɨn imə. Kən kahtosɨg e toa. ");
INSERT INTO tnn_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Uarisɨg, nɨpɨtan əlkələh itəm kotalməl kəmotɨtəlɨg-pa motaun motəmə, ‘!Etəm-iasol, etəm-iasol! !Egəhan-in itəmat ekotɨmnə imə!’ ");
INSERT INTO tnn_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Məto etəm otol marɨt təmən-ipən kəm ilat məmə, ‘Iatən-ipɨnə pahrien məmə, io ekəruru itəmat.’” ");
INSERT INTO tnn_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kən nian Iesu təmol namnun nimaa nəghatən, təmən-ipən kəm ilat məmə, “Tol nəhlan, itəmat nəkotəkəike motaiir, məto-inu nəkotəruru nian ne aua rəha rəhatəmat Iərəmərə otuwa lan.” ");
INSERT INTO tnn_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Kən Iesu təmuəh nimaa nəghatən kit mɨn məmə, “Ekən mɨn məmə e nian itəm rəhatəmat Iərəmərə otuwa mɨn, nərəmərəən rəha Uhgɨn otol nəhlan. Etəm-iasol kit təmol əpen-əpenə məmə otaliwək muwɨn e nəptən pɨsɨn kit muwɨn isəu. Kən maun-in rəhan iolwək mɨn kotuwa, kən tələhəu-pən e nelmɨlat rəhan məni mɨn məmə okotol nat kit lan. ");
INSERT INTO tnn_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Təmos-ipən tətəu-pən nɨtunən rəhalat məmə okotol wək lan. E etəmim kitiəh, təmos-ipən kətɨm faif kəmotər-motərioah e məni, u məni tepət pɨk agɨn. Kən kit mɨn, təmos-ipən mɨn kətɨm kəiu tahmen əm, u məni tepət pɨk. Kən kit mɨn, təmos-ipən kətɨm kitiəh tahmen əm, u məni tepət. Kən etəm-iasol təmiet muwɨn e rəhan naliwəkən. ");
INSERT INTO tnn_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kən iolwək itəm təmos kətɨm faif təmuwɨn uəhai əm mol bisnes lan, kən təmos mɨn kətɨm faif mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kən tahmen-ahmen əm, iolwək itəm təmos kətɨm kəiu, təmuwɨn mol bisnes lan, kən mos mɨn kətɨm kəiu mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Məto iolwək itəm təmos kətɨm kitiəh, in təmuwɨn mel noakɨmɨl məhluaigin-pən məni rəha rəhan etəm-iasol ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Kən nup tepət tɨnuwa mɨnuwɨn, kən etəm-iasol rəha iolwək mɨn u tɨnɨtəlɨg-pa, kən maun-in rəhan iolwək mɨn məmə otəplan-tu məmə ilat kəmotol naka e məni mɨn itəm təmos-ipən kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Iolwək itəm təmos kətɨm faif, təmuwa matos kətɨm faif mɨn itəm təmos, mətul e nɨganəmtɨ etəm-iasol məmə, ‘Etəm-iasol. Aupən nəmələhəu-pən kətɨm faif e nelmək. Kən emol bisnes lan, kən mos mɨn iahgoau kətɨm faif u.’ ");
INSERT INTO tnn_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Kən etəm-iasol təmən-ipən kəm in məmə, ‘Nəmol təwɨr, kən ik iolwək təwɨr itəm nataskəlɨm wɨr wək rəham kən məsapəsən. Nəmol təwɨr nəhlan e natɨmnat mɨn əh noan məsɨn, kən ekələhəu ik nakərəmərə e natɨmnat tepət. !Wa imə matɨg ahgin nagienən rəha etəm-iasol rəham!’ ");
INSERT INTO tnn_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Iolwək itəm təmos-ipən kətɨm kəiu kəm in, təmuwa mən-ipən məmə, ‘Etəm-iasol. Aupən nəmələhəu-pən kətɨm kəiu e nelmək. Kən emol bisnes lan, kən mos mɨn iahgoau kətɨm kəiu u.’ ");
INSERT INTO tnn_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Kən rəhan etəm-iasol təmən-ipən məmə, ‘Nəmol təwɨr, kən ik iolwək təwɨr itəm nataskəlɨm wɨr wək rəham kən məsapəsən. Nəmol təwɨr nəhlan e natɨmnat mɨn əh noan məsɨn, kən ekələhəu ik nakərəmərə e natɨmnat tepət. !Wa imə, kuagien!’ ");
INSERT INTO tnn_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Iolwək itəm kəmos-ipən kətɨm kitiəh kəm in, təmuwa mən-ipən məmə, ‘Etəm-iasol. Ik etəm nakatəkəike pɨk o netəmim. Kən ik natos nagwənən e nasumən itəm nəməsasum-inən, kən matəhl noa nɨg e nɨg itəm nəməsəfeən. ");
INSERT INTO tnn_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kən eməgin ik, məmə okəmə emərəkɨn rəham məni, kən onəkol nalpɨnən asol kəm io, kən emos rəham məni muwɨn məhluaig-in e nɨsɨp. Ah, inu rəham məni.’ ");
INSERT INTO tnn_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Kən rəhan etəm-iasol təmən-ipən məmə, ‘!Ik iolwək rat, ik iəlpah! Ik nəkɨtun rəkɨs məmə iakatos nagwənən e nasumən itəm esasum-inən, kən matəhl noa nɨg e nɨg itəm eməsəfeən. ");
INSERT INTO tnn_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","?Tahro nəsuwɨnən mələhəu-pən rəhak məni e bank, u in nimə rəha nələhəuən məni? Okəmə nəmol nəhlan, nian emɨtəlɨg-pa, ekuwɨn mos rəhak məni, kən ekos məni məsɨn mɨn itəm bank otos-ipa.’ ");
INSERT INTO tnn_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Kən etəm-iasol təmən-ipən kəm rəhan iolwək pɨsɨn məmə, ‘Os-irəkɨs məni ron mos-ipən kəm iolwək u itəm təmos kətɨm faif, ");
INSERT INTO tnn_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","məto-inu etəmim u itəm tɨnos rəkɨs nat kit mol wək lan tuwa mepət, kən okos-ipən neen mɨn, rəhan natɨmnat tepət. Məto etəmim itəm təsolwəkən rəhan tuwa mepət, okos-irəkɨs rafin natɨmnat ron. ");
INSERT INTO tnn_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kən iolwək u iəlpah itəm təruru nolən nat təwɨr kit, ərakin-pən ihluə e napinəpən, ikɨn əh kətasək ikɨn katəgətain nəluɨtəm.’” ");
INSERT INTO tnn_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Kən Iesu təmən-ipən məmə, “Nian Nətɨ Etəmim otuwa e nepətən əhag-əhag ne nəsanənən rəhan, ilat nagelo mɨn rafin, in Kig, kən in otəpələh e rəhan jea rəha Kig matərəmərə e nəsanənən ne nepətən əhag-əhag rəhan. ");
INSERT INTO tnn_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Netəmim rafin e noanol mɨn rafin e nətueintən, okotuəfɨmɨn ilat min e nɨganəmtɨn, kən in otoor netəmim tahmen e etəmim itəm tatehm sipsip mɨn tatoor sipsip mɨn ne nəni mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","In otoor sipsip mɨn kotuwa kan e nelmɨn matɨp, kən nəni mɨn okotuwɨn e nelmɨn mol. ");
INSERT INTO tnn_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Kən Kig otən-ipən kəm netəm mɨn un e nelmɨn matɨp məmə, ‘Otuwa, itəmat u itəm Uhgɨn təmawte-in rəkɨs rəhan nəwɨrən kəm itəmat. Otuwa motos nat naka u itəm Uhgɨn təmələhəu pɨsɨn rəhatəmat. Otuwa motatɨg ahgin nərəmərəən rəhan itəm təmol əpen-əpenə lan aupən təpanol nətueintən. ");
INSERT INTO tnn_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Otuwa motos, məto-inu nian nəumɨs təmus io, nəmotos-ipa nagwənən ekun; kən emətoaoa, nəmotos-ipa nəhau ekənɨm; kən io iapɨspɨs, nəmotit io kotuwɨn e rəhatəmat latuənu; ");
INSERT INTO tnn_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","kən rəhak napən tɨkə, kən nəmotos-ipa napən kəm io; kən matɨmɨs, nəmotehm wɨr io; kən emətatɨg e kalapus, nəmotuwa kuag-pənin io.’ ");
INSERT INTO tnn_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Kən netəm kotətuatɨp okotən-ipən kəm in məmə, ‘?Iərəmərə, nian naka emotəplan ik nəumɨs təmus ik, kən emotagwən ik; o nəmoaoa, kən emotos-ipɨnə nəhau məmə nakənɨm? ");
INSERT INTO tnn_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","?Nian naka emotəplan ik iapɨspɨs, kən emotit ik motuwa latuənu; o rəham napən tɨkə, kən emotos-ipɨnə napən kəm ik? ");
INSERT INTO tnn_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","?Nian naka emotəplan ik nakatɨmɨs, o nəmətatɨg e kalapus, kən emotɨmnə kuag-pənin ik?’ ");
INSERT INTO tnn_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Kən Kig otən-ipən məmə, ‘Iatən-ipɨnə nɨpahrienən məmə nat naka itəm nəmotol kəm piak mɨn u kit, nat əpnapɨn in ian-rat, məto nəmotol kəm io.’ ");
INSERT INTO tnn_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Kən in otən-ipən kəm netəm mɨn u e nelmɨn mol məmə, ‘Otuwɨn isəu ron io. Uhgɨn tɨnələhəu rəkɨs rəhatəmat nalpɨnən. Otuwɨn e nɨgəm asol itəm tatuəp namnun tɨkə u Uhgɨn təmol rəha Setan ne nagelo mɨn rəhan. ");
INSERT INTO tnn_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Otuwɨn isəu məto-inu nian nəumɨs təmus io, nəsotos-ipamən nagwənən kit məmə ekun; kən emətoaoa, nəsotos-ipamən nəhau məmə ekənɨm; ");
INSERT INTO tnn_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","kən io iapɨspɨs, nəsotaun-inən io məmə ekuwa latuənu; kən rəhak napən tɨkə, nəsotos-ipamən napən kit rəhak; kən ematɨmɨs, mətatɨg e kalapus, nəsotuwamən kuag-pənin io.’ ");
INSERT INTO tnn_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Kən ilat mɨn okotən-ipa məmə, ‘!Iərəmərə! ?Nian naka itəm emotəplan ik nəumɨs təmus ik, o mətoaoa, o ik iapɨspɨs, o rəham napən tɨkə, o nəmatɨmɨs, o nəmətatɨg e kalapus kən eməsotɨmnə kuag-pənin ik?’ ");
INSERT INTO tnn_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Kən in otən-ipən kəm ilat məmə, ‘Iatən-ipɨnə pahrien kəm itəmat məmə, okəmə nəməsotasituən e piak mɨn u kit, nat əpnapɨn in ian-rat, məto nəməsotolən kəm io.’ ");
INSERT INTO tnn_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Kən ilat okotuwɨn motos nalpɨnən itəm namnun tɨkə. Məto netəmim kotətuatɨp okotos nəmegəhən lilɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nian Iesu təmol namnun nəghatən mɨn əh kəm rəhan netəmim, kən mən-ipən kəm ilat məmə, ");
INSERT INTO tnn_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nəkotɨtun məmə lafet rəha Nuhagego-inən otuwa, nian kəiu əm əh-ikɨn. Kən io, Nətɨ Etəmim, okegəhan-in-pən io məmə okətu-pər e nɨg kəməluau.” ");
INSERT INTO tnn_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kən pris asol mɨn ne netəm-iasol rəha noanol rəha Isrel kəmotuəfɨmɨn ilat mɨn e nimə rəha pris asol agɨn u nərgɨn u Kaeafas. ");
INSERT INTO tnn_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Kən moatəlpəkau məmə okotaskəlɨm Iesu e nolən eko-eko, kən motohamnu in. ");
INSERT INTO tnn_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Məto motən məmə, “Sənəmə e nian rəha lafet rəha Nuhagego-inən, okol məta netəmim kotoh ilat mɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nian Iesu əpəh e Petani e nimə rəha suah əh, nərgɨn u Saimon u leprosi təmol, ");
INSERT INTO tnn_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","kən pətan kit təmuwa ron mos senta kit u nəmtɨn tiəkɨs, kəmiuw-pən e pətəl kəmol e kəpiel itəm nəmtɨn tiəkɨs, katən məmə alapasta. Nian Iesu tatəpələh e tepɨl mətagwən, kən pətan u təmau rəhn-kapə e senta un. ");
INSERT INTO tnn_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nian netəmim rəha Iesu kəmotəplan nat əh, neməha təmol ilat, motən məmə, “?Tahro katərəkɨn nat u? ");
INSERT INTO tnn_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Senta u, kɨtun nol-salɨm-inən, kən kos məni asol lan, kos-ipən kəm ian-rat mɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Məto Iesu tɨnɨtun nəghatən itəm koatən, kən mən-ipən kəm ilat məmə, “?Tahro noatən rat pətan u? In təmol nat təwɨr agɨn kəm io. ");
INSERT INTO tnn_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ian-rat mɨn nian rafin kotatɨg itəmat min ilat. Məto io, okol esatɨgən kitat min itəmat nian rafin. ");
INSERT INTO tnn_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nian təməhtəg-pən e nɨpətɨk, təmol məmə otol əpen-əpenə o nɨtənɨmən io. ");
INSERT INTO tnn_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Iatən pahrien kəm itəmat məmə, ikɨn mɨn rafin e nətueintən itəm okən-iarəp namnusən təwɨr u, kən okəkəike kən-iarəp mɨn nat naka itəm pətan u təmol, kən nɨkilat otatəht mɨn in.” ");
INSERT INTO tnn_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kən netəm tuelef u kit rəha Iesu, nərgɨn u Jutas Iskariot, təmuwɨn məplan pris asol mɨn, ");
INSERT INTO tnn_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","kən mən-ipən məmə, “?Onəkotos-ipa naka kəm io okəmə ekegəhan-in-pɨnə Iesu kəm itəmat?” Kən kəmotafin məni ilat rafin tate itəm kəmol e silfa. ");
INSERT INTO tnn_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kən tətuoun e nian əh, Jutas təmategəs-in suatɨp məmə otegəhan-in-pən Iesu e nelmɨ rəhan tɨkɨmɨr mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nian e nətuounən itəm rəha lafet rəha Pret U Is Tɨkə Lan, netəmim rəha Iesu kəmotuwa motən-ipən kəm in məmə, “?Nakolkeike məmə itɨmat ekotol əpen-əpenə hiə rəham nagwənən rəha lafet rəha Nuhagego-inən məmə nakagwən ikɨn?” ");
INSERT INTO tnn_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kən Iesu təmən-ipən məmə, “Otuwɨn əpəh e taon, kən onəkotəplan suah kit itəm ekən kəm itəmat, kən nakotən-ipən kəm in məmə, ‘Iəgətun tatən məmə: Nian itəm Uhgɨn təmɨtəpun rəkɨs məmə rəhak, tɨnuwa iuəhkɨr. Kən ekol lafet rəha Nuhagego-inən kitiəh itɨmat rəhak netəmim mɨn e rəham nimə.’” ");
INSERT INTO tnn_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tol nəhlan rəhan netəmim kəmotol nat naka itəm Iesu təmən məmə okotol o nol əpen-əpenəən o nagwənən rəha lafet rəha Nuhagego-inən. ");
INSERT INTO tnn_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nian tɨnehnaipən, Iesu tatəpələh ilat rəhan netəmim tuelef əpəh e tepɨl. ");
INSERT INTO tnn_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kən nian kəmotagwən, kən təmən-ipən kəm ilat məmə, “Iatən pahrien kəm itəmat məmə itəmat kit otegəhan-in-pən io e nelmɨ tɨkɨmɨr mɨn rəhak.” ");
INSERT INTO tnn_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kən nɨkilat tɨnəpou, kən moatən-ipən kəm Iesu kitiəh kitiəh məmə, “?Eh, Iərəmərə, pah u? ?Io?” ");
INSERT INTO tnn_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kən Iesu təmən-ipən məmə, “Etəmim itəm otegəhan-in-pən io e nelmɨ tɨkɨmɨr mɨn rəhak, in rəhak kit itəm tatos nɨgɨn pɨret mos-ipən meer e plet kitiəh əm itɨmlau min. ");
INSERT INTO tnn_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Io, Nətɨ Etəmim, iatuwɨn e suatɨp rəhak, tahmen-ahmen əm e nəghatən kəməte lak. !Məto kəsi, nahməən asol o etəm u itəm otegəhan-in-pən Nətɨ Etəmim e nelmɨ rəhan tɨkɨmɨr mɨn! Təwɨr pɨk agɨn məmə təməsaiir-əmən.” ");
INSERT INTO tnn_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Kən Jutas u etəm otegəhan-in-pən Iesu e nelmɨ rəhan tɨkɨmɨr mɨn təmən-ipən məmə, “Iəgətun. ?Pah əh? ?Io?” Məto Iesu təmən-ipən məmə, “Əwəh, ik. Ik atɨp nəmən.” ");
INSERT INTO tnn_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nian kəmoatagwən, Iesu təmos pɨret, məfak ron, məmkas, mos-ipən kəm rəhan netəmim, mən-ipən məmə, “Otos motun, inu nɨpətɨk.” ");
INSERT INTO tnn_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kən mos kap wain, məfak ron, mos-ipən kəm rəhan netəmim, mən-ipən məmə, “Otənɨm, itəmat rafin. ");
INSERT INTO tnn_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Inu nɨtak itəm tatol məmə nəniəkɨsən rəha nasituən in tatətul matəmegəh. Nɨtak u okəhtəg o netəmim tepət məmə otafəl rəkɨs rəhalat nolən rat mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Iatən pahrien kəm itəmat məmə ekəsənɨm mɨnən wain u mətoarus nian itəm ekənɨm wain wi kitat min itəmat əpəh e nərəmərəən rəha Tata rəhak.” ");
INSERT INTO tnn_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nian kəmotan napuən əfak kit, motiet motuwɨn e Nɨtot Rəha Nɨg U Olif. ");
INSERT INTO tnn_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kən Iesu təmən-ipən kəm ilat məmə, “O lapɨn əm u, nakotapəs rəhatəmat nahatətəən lak o nat naka itəm okol lak. Naoa Rəha Uhgɨn itəm təkəike mol nɨpahrienən, təmən məmə, ‘Io ekohamnu etəmim itəm tatehm sipsip mɨn, kən sipsip mɨn okotan kitiəh kitiəh.’ ");
INSERT INTO tnn_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Məto nian ekəmegəh mɨn e nɨmɨsən, iakaupən muwɨn əpəh Kalili, kən itəmat nəpanotuarisɨg.” ");
INSERT INTO tnn_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Kən Pita təmən-ipən məmə, “Mətan, ilat rafin okotapəs rəhalat nahatətəən lam, məto io, kəp, esapəsən rəhak nahatətəən lam nian kit ne.” ");
INSERT INTO tnn_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Kən Iesu təmən-ipən kəm Pita məmə, “Iatən-ipɨnə pahrien kəm ik məmə, lapɨn əm u, uarisɨg mənɨg təpanɨmnən, onakən mau kɨsɨl məmə nəkəruru io.” ");
INSERT INTO tnn_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Məto Pita tən məmə, “Nat əpnapɨn ekəkəike mɨmɨs kilau min ik, okol ekəsənən məmə ekəruru ik.” Kən rəhan rafin netəmim kotən mɨn tahmen e Pita. ");
INSERT INTO tnn_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kən Iesu ne rəhan netəmim kəmotuwɨn ikɨn kit katən məmə Ketsemani, kən təmən-ipən kəm ilat məmə, “Oatəpələh ikɨn-u, pəs io ekuwɨn ikɨn əh məghat kəm Uhgɨn e nəfakən.” ");
INSERT INTO tnn_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kən təmit Pita ne nətɨ Sepeti mil ilat min, kən nɨkin tɨnahmə pɨk, kən tɨnəto tərat. ");
INSERT INTO tnn_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kən təmən-ipən kəm iləhal məmə, “Iakəto nɨkik tɨnahmə pɨk, iuəhkɨr ekɨmɨs lan. Itəməhal ətahləpələh ukɨn-u, mətəhlaiir kitat min io.” ");
INSERT INTO tnn_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kən muwɨn noan məsɨn əm, meiuaiu mɨsin-pən rəhn-kapə e nɨsɨp matəfak, matən məmə, “Rəhak Tata, okəmə suatɨp kit mɨn əh-ikɨn o rəham nalpəkauən, pəs nakohrəkɨs ron io nəratən itəm tatuwa. Məto sənəmə nakol nəwiak, məto nakol nəwiam.” ");
INSERT INTO tnn_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kən təmɨtəlɨg-pa məplan iləhal kətəhlapɨl. Kən təmən-ipən kəm Pita məmə, “?Tahro nəsəhlaiirən kitat min io o aua kitiəh əm ne? ");
INSERT INTO tnn_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Atəhlaiir kən mətəhaləfak məmə nəsəhaluwɨnən ima nos-ipən-os-ipənən. Nɨkitəməhal tolkeike, məto nɨpətɨtəməhal təpou.” ");
INSERT INTO tnn_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kən mɨtəlɨg-pən mɨn matəfak mətau kəiu, matən məmə, “Rəhak Tata, okəmə ekəkəike mos nəratən itəm tatuwa, kən pəs nakol nəwiam.” ");
INSERT INTO tnn_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kən nian təmɨtəlɨg-pa, təməplan iləhal kɨnəhlapɨl məto-inu napɨlən tɨnos iləhal. ");
INSERT INTO tnn_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kən tapəs iləhal mɨtəlɨg-pən mɨn matəfak mətau kɨsɨl, matən əm nəghatən kitiəh əm. ");
INSERT INTO tnn_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kən mɨtəlɨg-pa mən-ipən kəm iləhal məmə, “?Nəkatəhlapɨl əh mətəhlameg, o? Əhaləplan-tu, aua tɨnatuwa iuəhkɨr, kən io Nətɨ Etəmim, okegəhan-in-pən e nelmɨ netəm nol təfagə rat. ");
INSERT INTO tnn_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","!Əhalətul-ta, koatuwɨn! !Etəmim u tatuwa itəm otegəhan-in-pən io e nelmɨ rəhak tɨkɨmɨr mɨn!” ");
INSERT INTO tnn_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nian Iesu təmatəghat-əh, Jutas, in etəm tuelef kit rəha Iesu, təmiet-arəpa ilat nɨmanin netəmim itəm koatəmɨk naip asol rəha nəluagɨnən ne kəsou-əsou. Pris asol mɨn ne netəm-iasol rəha noanol rəha Isrel kəmotahl-ipa ilat. ");
INSERT INTO tnn_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jutas təmən-ipən rəkɨs nəghatən kəm ilat məmə, “Pah u itəm ekətuilɨm-pən lan, kən nakotaskəlɨm in.” ");
INSERT INTO tnn_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kən roiu agɨn, Jutas təmaliwək muwɨn o Iesu mən-ipən məmə, “!Təwɨr, Iəgətun!” kən mətuilɨm-pən lan. ");
INSERT INTO tnn_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Kən Iesu təmən-ipən məmə, “Io kit, ol nat naka itəm nəmuwa ron.” Kən netəmim kəmotaliwək motaskəlɨm Iesu məmə okotɨləs-ipən e kalapus. ");
INSERT INTO tnn_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kən etəmim kit rəha Iesu təmea-pən miuw rəkɨs rəhan naip asol rəha nəluagɨnən, kən moahin naip təte-rəkɨs matəlgɨ slef rəha pris asol agɨn. ");
INSERT INTO tnn_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kən Iesu təmən-ipən kəm in məmə, “Aii-pən rəham naip e nəmeen, məto-inu netəm mɨn u itəm koatoahin naip, okotɨmɨs e naip. ");
INSERT INTO tnn_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","?Nɨkim təht məmə ekəruru naun-inən rəhak Tata, kən roiu agɨn otahl-ipa nagelo mɨn taosan tepət tepət məmə okotasitu lak? ");
INSERT INTO tnn_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Məto okəmə ekol nəhlan, okol Naoa Rəha Uhgɨn otəsuwamən mol nɨpahrienən lan, itəm tatən məmə otuwa tol nəhlan.” ");
INSERT INTO tnn_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","E nian əh, Iesu təmən-ipən kəm nɨmanin netəmim məmə, “?Tahro nəmotuwa motəmɨk naip asol mɨn ne kəsou-əsou mɨn? ?Nɨkitəmat təht məmə io iatol nəluagɨnən o nahwinən kapman, o? !Kəp! Nian rafin iakatəpələh əpəh e Nimə Rəha Uhgɨn matəgətun netəmim, kən nəsotuwamən motaskəlɨm io. ");
INSERT INTO tnn_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Məto natɨmnat mɨn əh rafin tɨnuwa mol nɨpahrienən lan məmə Naoa Rəha Uhgɨn itəm ien mɨn aupən kəmotəte otuwa mol nɨpahrienən lan.” Kən rəhan mɨn netəmim kəmotapəs in motagɨm. ");
INSERT INTO tnn_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Netəm mɨn u itəm kəmotaskəlɨm Iesu, kəmotɨləs motuwɨn o Kaeafas u in pris asol agɨn. Ikɨn əh, iəgətun mɨn rəha Lou ne netəm-iasol mɨn rəha noanol rəha Isrel, koatuwa motuəfɨmɨn ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Məto Pita tətan təlɨg-təlɨg matuarisɨg-in Iesu, muwɨn əpəh e latuənu rəha pris asol agɨn. Kən təmuwɨn əpəh e iat matəpələh ilat mopael mɨn məmə otəplan-tu məmə okol naka e Iesu. ");
INSERT INTO tnn_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pris asol mɨn ne netəmim rafin rəha kaonsel koategəs-in nəghatən eiueiuə mɨn e Iesu məmə okotohamnu in o nəghatən mɨn əh. ");
INSERT INTO tnn_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Məto kəsotəplanən nolən rat kit rəhan o nəghatən eiueiuə mɨn rəha netəmim, nat əpnapɨn nəghatən eiueiuə mɨn tepət kəmotiet. Kən əmun, etəmim kəiu kuea aupən, ");
INSERT INTO tnn_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","kən muən-iarəp məmə, “Suah u təmatən məmə tɨtun nərəkɨnən Nimə Rəha Uhgɨn, kən miləkɨn mɨn e nian kɨsɨl əm.” ");
INSERT INTO tnn_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kən pris asol agɨn tətul mən-ipən kəm Iesu məmə, “?Tahro nəsəghatən? ?Tahro e nəghatən mɨn əh itəm koatən-iarəp tatɨləs pɨkən ik?” ");
INSERT INTO tnn_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Məto Iesu təpnapɨn əm məsəghatən. Kən pris asol agɨn təmən-ipən kəm in məmə, “Onakəkəike mos noanawɨl kit e Uhgɨn itəm tatəmegəh, kən mən-iarəp nɨpahrienən kəm itɨmat məmə ik Nətɨ Uhgɨn ne Kristo itəm Uhgɨn təmən məmə otahl-ipa, o kəp.” ");
INSERT INTO tnn_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Kən Iesu təmən-ipən məmə, “Əwəh, tol əm məmə inu nəmən mihin ne. Məto ekən-ipɨnə kəm itəmat rafin məmə, e nian itəm otuwa, onəkotəplan io Nətɨ Etəmim ekatəpələh e nɨkalɨn matɨp rəha Uhgɨn u Etəm Təsanən Agɨn, kən mateiuaiu-pa e neai e nɨmal napuə.” ");
INSERT INTO tnn_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kən pris asol agɨn təməhap rəhan napən məto-inu tatəto tərat o nəghatən rəha Iesu, kən mən məmə, “!Tatəghat rat e Uhgɨn! ?Tahro məmə suah kit mɨn təkəike məghat mɨn lan? Otətəlɨg-in-tu, nəmotəto nəghatən rat əh. ");
INSERT INTO tnn_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","?Nɨkitəmat təht məmə naka?” Kən kəmotən-ipən məmə, “Otəkəike mɨmɨs.” ");
INSERT INTO tnn_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kən kəmotagəh əpnapɨn əm nɨganəmtɨn, kən motaht e nelmɨlat. Neen kotem e nelmɨlat, ");
INSERT INTO tnn_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","kən motən-ipən məmə, “Ei, Kristo. ?Ən-iarəp e nəsanənən rəha Uhgɨn məmə pah təmoh ik?” ");
INSERT INTO tnn_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","E nian əh, Pita tatəpələh ihluə e iat rəha nimə, kən iolwək kit pətan əkəku tuwa ron mən-ipən kəm in məmə, “Ik mɨn u, nəmatuarisɨg-in Iesu, etəm Kalili.” ");
INSERT INTO tnn_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Məto Pita təmən-iamnin kəm ilat rafin məmə, “Iəkəruru nat un itəm nakatən.” ");
INSERT INTO tnn_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kən maliwək muwɨn e ket rəha iat, kən ikɨn əh pətan əkəku kit mɨn təməplan in, kən təmən-ipən kəm netəmim ikɨn əh məmə, “Suah u kit u təmatuarisɨg-in Iesu Etəm Nasaret.” ");
INSERT INTO tnn_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Məto Pita təmən-iamnin əskasɨk mɨn mos noanawɨl məmə, “!Iəkəruru suah əh!” ");
INSERT INTO tnn_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Təsuwəhən, netəm mɨn u koatətul ikɨn əh kotuwɨn o Pita motən-ipən məmə, “Pahrien məmə ik kit əh, məto-inu nolən rəha nəghatən rəham tahmen əm elat.” ");
INSERT INTO tnn_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Kən tɨnətuoun maun-in nəratən mɨn koatɨsɨ-pən o Uhgɨn moatuwa ron okəmə teiuə. Kən təmos noanawɨl məmə, “!Iəkəruru suah əh!” Kən roiu agɨn, mənɨg təmɨmnən. ");
INSERT INTO tnn_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kən Pita nɨkin təht nəghatən itəm Iesu təmən kəm in məmə, “Uarisɨg mənɨg otɨmnən, onakən mau kɨsɨl məmə nəkəruru io.” Kən Pita təmiet muwɨn ihluə, kən təmasək təmasək. ");
INSERT INTO tnn_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Laulaugɨn agɨn, pris asol mɨn rafin ne etəm-iasol mɨn rəha netəmim kəmotuəfɨmɨn mɨn motəte noa məmə okotətəu-pən suatɨp naka o nohamnuən Iesu. ");
INSERT INTO tnn_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kəmotəlis in, kən motɨləs motuwɨn motəhlman-pən e nelmɨ Pailat, kapman rəha Rom. ");
INSERT INTO tnn_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nian Jutas u etəm təmegəhan-in-pən Iesu e nelmɨ rəhan tɨkɨmɨr mɨn, təməplan məmə kəmotiuw-iarəp Iesu məmə otɨmɨs, nɨkin tɨnahmə pɨk o nat naka itəm təmol, kən təmɨk məni tate əh itəm kəmol e silfa, məmki-pən kəm pris asol mɨn ne etəm-iasol mɨn rəha noanol rəha Isrel. ");
INSERT INTO tnn_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kən mən-ipən məmə, “Emol təfagə məto-inu emegəhan-in-pən e nelmɨ tɨkɨmɨr mɨn suah kit itəm təsolən nat tərat kit.” Kən kotən-ipən məmə, “Inu nat əpnapɨn əm otəmat. Nat kit rəham əm.” ");
INSERT INTO tnn_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tol nəhlan, Jutas təmərakin-pən məni əpəh e Nimə Rəha Uhgɨn, kən in miet magɨm muwɨn maril atɨp in. ");
INSERT INTO tnn_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kən pris asol mɨn kəmotuwɨn motuwər məni, kən motən məmə, “Təsətuatɨpən e rəhatat Lou məmə okotələhəu-pən məni u ilat məni rəha Nimə Rəha Uhgɨn, məto-inu kəmos-nəmtɨn nɨta etəmim lan.” ");
INSERT INTO tnn_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kən koatən məmə okotos məni əh kən kos-nəmtɨn nəptən kit u aupən katən məmə, “nəptən rəha suah kit itəm tatol sospən e nəptən,” kən koatən məmə okatɨtənɨm iapɨspɨs mɨn ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tol nəhlan, muwa mətoarus-pa u-roiu, netəmim kotaun-in nəptən əh məmə, “Nəptən Rəha Nɨta.” ");
INSERT INTO tnn_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kən nəghatən naka itəm ien Jeremaea təmən aupən, təmuwa mol nɨpahrienən lan. Təmən məmə, “Kəmotos məni tate əh itəm kəmol e silfa, inu nəmtɨn itəm netəm Isrel kəmotən o suah u, ");
INSERT INTO tnn_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","kən koatos məni əh məmə okotos-nəmtɨn ‘nəptən o nolən sospən,’ tahmen əm məmə Iərəmərə təmən kəm io.” ");
INSERT INTO tnn_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Kən Iesu təmuwɨn mətul e nɨganəmtɨ Pailat, kən təmətapəh ron məmə, “?Ik kig rəha netəm Isrel?” Kən Iesu təmən-ipən məmə, “Ik nəmən mihin.” ");
INSERT INTO tnn_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nian pris asol mɨn ne etəm-iasol mɨn rəha Isrel koatən-iarəp nəghatən mɨn e Iesu, məto Iesu təsuhalpɨnən rəhalat nəghatən. ");
INSERT INTO tnn_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kən Pailat təmən-ipən kəm in məmə, “?Nakatəto nəghatən mɨn itəm koatən tatɨləs pɨkən ik, o kəp?” ");
INSERT INTO tnn_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Məto Iesu təpnapɨn əm məsəghatən məsuhalpɨnən nəghatən kit ilat katən, kən Pailat, narmɨn təmiwɨg pɨk. ");
INSERT INTO tnn_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kən e nian rəha lafet rəha Nuhagego-inən, in nolən rəha kapman məmə otahl-iarəp etəmim kit e kalapus itəm nɨmanin netəmim kəmotən. ");
INSERT INTO tnn_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","E nian əh, etəm kit tatəməhl e kalapus, nərgɨn u Parapas. Kən netəmim rafin kotɨtun məmə in təmol tərat pɨk agɨn. ");
INSERT INTO tnn_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kən nian nɨmanin netəmim kɨnotuwa, kən Pailat təmətapəh olat məmə, “?Nakotolkeike məmə ekahl-iarəp pah e kalapus tiet matuwɨn, Parapas, o Iesu, kətaun-in məmə Kristo?” ");
INSERT INTO tnn_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Təmən nəhlan məto-inu in tɨtun məmə kəmotegəhan-in-pən Iesu e nelmɨn məto-inu koatetəhak o Iesu. ");
INSERT INTO tnn_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nian Pailat tatəpələh e jea rəha nakilən nəghatən, rəhan pətan tahl-ipən nəghatən kəm in məmə, “Suah un təsolən nat tərat kit. Əsolən nat kit lan, məto-inu emapɨlaiir lan, kən roiu iatəto tərat agɨn ron.” ");
INSERT INTO tnn_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Məto pris asol mɨn ne netəm-iasol rəha noanol rəha Isrel kəmotəghat kəm nɨmanin netəmim məmə okotəuhlin nətəlɨgən rəhalat. Kən ilat kəmotətapəh o Pailat məmə otahl-iarəp Parapas, kən kotohamnu Iesu. ");
INSERT INTO tnn_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kən Pailat təmətapəh olat məmə, “?Suah mil u, in pəhruən lan ekahl-iarəp?” Məto nɨmanin netəmim kəmotən-ipən məmə, “Parapas.” ");
INSERT INTO tnn_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Kən Pailat təmən-ipən məmə, “?Kən oekahro Iesu u kətaun-in mə Kristo?” Kən nɨmanin netəmim rafin kəmotən-ipən məmə, “!Okətu-pər e nɨg kəluau otɨmɨs!” ");
INSERT INTO tnn_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kən Pailat təmən-ipən kəm ilat məmə, “?O naka? ?Təmol nat tərat naka?” Məto nɨmanin netəmim kəmotagət əfəməh, motən məmə, “!Okətu-pər in e nɨg kəluau otɨmɨs!” ");
INSERT INTO tnn_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kən nian Pailat təməplan məmə okol təsələhəuən nəghatən rəhalat, kən ilat kɨnoatətul matɨp o nəmouən, kən tos nəhau maikuas e nelmɨn aupən e nɨmanin netəmim, kən mən-ipən kəm ilat məmə, “Nəghatən kit rəhak tɨkə o suah u, məmə nɨtan otəməhl-pa lak. !Nɨmɨsən rəhan tatəməhl-pɨnə e nelmɨtəmat!” ");
INSERT INTO tnn_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Kən netəmim rafin kəmotən məmə, “!Pəs nɨtan təməhl-pa otɨmat ne nɨsualkələh mɨn rəhatɨmat mɨn!” ");
INSERT INTO tnn_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kən Pailat təmahl-iarəp megəhan-in-pən Parapas kəm ilat. Məto təmən məmə okalis Iesu, kən təmegəhan-in-pən in məmə okətu-pər e nɨg kəluau məmə otɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kən mopael mɨn rəha Pailat kotɨləs Iesu motuwɨn əpəh imə e nimə asol rəha kapman, katən məmə Praetoriam. Kən kəmotaun-in rafin mopael mɨn kotuwa kɨtəlau lan. ");
INSERT INTO tnn_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kən motəmki-rəkɨs rəhan natɨmnat, motuwɨn-in-pən kot tasiə kit kəm in, tahmen e kot rəha kig kit. ");
INSERT INTO tnn_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Kən motuarin-uarin nol itəm tol nihlən-nihlən motol hat lan, motəfauin-pən e rəhn-kapə Iesu motol mɨlə lan məmə in hat rəha kig kit. Kən motələhəu-pən noanɨg kit e nelmɨn matɨp, kən motɨsin nulɨlat aupən in, motol mɨlə lan, motən-ipən məmə, “!Ekotɨsiai-in ik, kig rəha netəm Isrel!” ");
INSERT INTO tnn_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Kən motagəh lan, kən motɨləs noanɨg motoh rəhn-kapə lan mau tepət. ");
INSERT INTO tnn_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nian kɨnotol rəkɨs mɨlə lan, kən motəpeg rəkɨs kot tasiə, motuwɨn-in-pən mɨn rəhan natɨmnat. Kən motɨləs motuwɨn məmə okotətu-pər e nɨg kəluau məmə otɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nian kəmoatuwɨn, motəplan etəm Saerin kit, nərgɨn u Saimon, kən moatəkəike kəm in məmə otɨləs nɨg kəluau. ");
INSERT INTO tnn_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kəmotuwa ikɨn kit katən məmə, Kolkota, u nɨpətɨn tatən məmə Louipɨl-uipɨl. ");
INSERT INTO tnn_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ikɨn əh kəmotəmki-pən wain kəm Iesu itəm kəmeapətɨp e nat tarɨp. Məto nian Iesu təmənɨm asgəwɨn, kən mapəs nənɨmən. ");
INSERT INTO tnn_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nian kəmətu-pər e nɨg kəluau, kən moturin taes o rəhan natɨmnat. ");
INSERT INTO tnn_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kən moatəpələh moatuag-pən moatehm Iesu ikɨn əh. ");
INSERT INTO tnn_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ilɨs e rəhn-kapə, kəmotəte nɨpəgnəmtɨn nənən. Tatən nəhlan məmə, Inu Iesu, kig rəha netəm Isrel. ");
INSERT INTO tnn_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Kən etəmim kəiu itəm kətioh netəmim mətuakləh-in rəhalat natɨmnat, kəmətu-pər ilau e nɨg kəluau, kit e nɨkalɨn matɨp, kit e nɨkalɨn mol. ");
INSERT INTO tnn_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kən netəm mɨn u itəm kəmotaliwək motuwa moatuwɨn, motən-ipən nəghatən rat kəm Iesu, moturin-urin rəhalat-kapə, ");
INSERT INTO tnn_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","moatən məmə, “Nəmatən məmə onakərəkɨn Nimə Rəha Uhgɨn kən ik pɨsɨn əm miləkɨn o nian kɨsɨl. !Osmegəh atɨp ik! !Kən eiuaiu e nɨg kəluau okəmə ik Nətɨ Uhgɨn pahrien!” ");
INSERT INTO tnn_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","E nolən ahmen mɨn əm, pris asol mɨn, ne iəgətun mɨn rəha Lou, ne netəm-iasol mɨn rəha noanol rəha Isrel kotol mɨlə lan, ");
INSERT INTO tnn_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","motən məmə, “Təmosmegəh netəmim, məto okol təruru nosmegəh atɨpən in. In kig rəha Isrel. Okəmə tatite atɨp e nɨg kəluau, kən okotən nɨpahrienən lan. ");
INSERT INTO tnn_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tətahatətə e Uhgɨn. Pəs Uhgɨn tɨləs-irəkɨs in əh-roiu okəmə in tolkeike, məto-inu təmən məmə in Nətɨ Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","E nolən ahmen mɨn əm, iətgəhl lou mil itəm kəmətu-pər iləhal min in e nɨg kəluau, katuən-ipən nəghatən rat tepət kəm in. ");
INSERT INTO tnn_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kən e tuelef klok mətoarus-pən tri klok, napinəpən təmeiuaiu mɨrəfin nat. ");
INSERT INTO tnn_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kən iuəhkɨr e tri klok ehnaipən, Iesu təmasək əfəməh mən məmə, “!Eloi, Eloi! ?Lama sapaktani?” u nɨpətɨn təmə, “!Uhgɨn rəhak, Uhgɨn rəhak! ?Tahro nakatapəs io?” ");
INSERT INTO tnn_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nian netəmim neen itəm kəmoatətul əh-ikɨn kəmotəto təmasək əfəməh nəhlan, kən kotən məmə, “In tətaun-in Elaija.” ");
INSERT INTO tnn_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Roiu agɨn, kit təmaiu muwɨn mɨləs nat kit tame-ame tahmen e katən, kən mau e wain u tagɨn, maru e nɨg, kən mɨləs-ipən məmə Iesu otənɨm. ");
INSERT INTO tnn_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kən ilat mɨn neen kotən-ipən məmə, “Apəs əm. Pəs koatəplan okəmə Elaija otuwa mosmegəh in, o kəp.” ");
INSERT INTO tnn_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kən nian Iesu təmasək əfəməh mɨn, megəhan-in atɨp məmə otɨmɨs, kən rəhan namegən tiet. ");
INSERT INTO tnn_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","E nian ətuatɨp əh, nɨməhan itəm tatəkul e Nimə Rəha Uhgɨn təməhap mol məsɨn kəiu, təmətuoun əpəh ilɨs muwa mol namnun əpəh ləhau. Namig təməloal, kən kəpiel mɨn kəmotɨmɨsmɨs. ");
INSERT INTO tnn_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Kən suwɨt mɨn itəm kəmol e nɨpəg kəpiel kəmotəhap motoag, kən netəm kotətuatɨp tepət itəm kəmotɨmɨs rəkɨs, kəmotəmegəh mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Kəmotiet e suwɨt mɨn kəmol e nɨpəg kəpiel, kən uarisɨg Iesu təməmegəh e nɨmɨsən, ilat kəmotuwɨn əpəh Jerusalem motiet-arəp o netəmim tepət. ");
INSERT INTO tnn_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kən nian etəm-iasol rəha mopael mɨn rəha netəm Rom ilat netəm mɨn u itəm kəmoatehm Iesu, kəmotəplan namig ne natɨmnat mɨn əh, kəmotəgɨn pɨk, kən motən əfəməh məmə, “!Nɨpahrienən, inu Nətɨ Uhgɨn pahrien!” ");
INSERT INTO tnn_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nɨpɨtan tepət kəmoatətul isəu moatəplan. Aupən ikɨn kəmotiet Kalili moatətəu-pən Iesu moatasitu lan e nat pɨsɨn pɨsɨn mɨn. ");
INSERT INTO tnn_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ilat mɨn neen u Meri Maktala, kən Meri u mama rəha Jemes ne Joses, kən mama rəha nətɨ Sepeti mil. ");
INSERT INTO tnn_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Etəm Aramatia u rəhan nautə tepət, nərgɨn u Josep, in etəmim kit rəha Iesu. Nian tɨnatuwa iuəhkɨr o napinəpən, ");
INSERT INTO tnn_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","təmuwɨn məplan Pailat, kən tətapəh-in nɨpətɨ Iesu, kən Pailat tegəhan-in nɨpətɨ Iesu kəm in. ");
INSERT INTO tnn_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kən Josep təmɨləs nɨpətɨ Iesu muwɨn malpin e nɨməhan ruən wi kit, nərgɨn u linen, ");
INSERT INTO tnn_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","kən mɨləs muwɨn mɨləs-ipən e suwɨt wi kəmel e kəpiel. Suwɨt u in rəha Josep. Kən məsoupəlpəlin-pən kəpiel asol kit mahtosɨg-in nɨpəg kəpiel lan, kən matuwɨn. ");
INSERT INTO tnn_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meri Maktala, ne Meri kit mɨn katuəpələh əh iuəhkɨr o suwɨt. ");
INSERT INTO tnn_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nian əh, in nian katol əpen-əpenə o Sapat, kən kəmən lawɨgin e Sapat, pris asol mɨn ne Farisi mɨn kəmotuwɨn motəplan Pailat. ");
INSERT INTO tnn_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Motən-ipən məmə, “Etəm-iasol. Nɨkitəmat tɨnəht məmə, nian suah əh, etəm rəha neiuəən, təmatəmegəh əh, matən məmə, ‘Nian kɨsɨl otuwa muwɨn, kən Uhgɨn otosmegəh mɨn io e nɨmɨsən.’ ");
INSERT INTO tnn_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tol nəhlan, ahl-ipən rəham neen mopael okotuwɨn moatehm nɨpəg kəpiel suwɨt mətoarus-pən nian kɨsɨl tuwa muwɨn. Mətan, rəhan netəmim okotuwa kakləh-in nɨpətɨn, kən motən-ipən kəm netəmim məmə təməmegəh mɨn e nɨmɨsən. Kən neiueiuəən u, in otərat taprəkɨs-in itəm aupən.” ");
INSERT INTO tnn_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Kən Pailat təmən-ipən məmə, “Otos mopael mɨn, kən motuwɨn motol natɨmnat rafin itəm nakotolkeike məmə okotol o nehm wɨrən suwɨt e nɨpəg kəpiel.” ");
INSERT INTO tnn_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kən kəmotuwɨn moatehm wɨr nɨpəg kəpiel tol nulan, motələhəu-pən nəmtətin kit e kəpiel. Kən kəmotələhəu mopael mɨn məmə okoatehm ikɨn əh. ");
INSERT INTO tnn_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","E Sante laulaugɨn agɨn, təmatian məsian wɨrən, Meri Maktala ne Meri kit mɨn kəmian məmə okiauag suwɨt e nɨpəg kəpiel. ");
INSERT INTO tnn_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kən əmun, namig asol kit təməloal məto-inu nagelo kit rəha Iərəmərə təmeiuaiu e nego e neai muwɨn e nɨpəg kəpiel, kən məsoupəlpəl-in rəkɨs kəpiel, kən matəpələh-pər lan. ");
INSERT INTO tnn_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","In tətasiə tahmen e nɨpɨtən, kən rəhan natɨmnat mɨn kotəruən tahmen e nahui noa nɨtəhəi. ");
INSERT INTO tnn_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Mopael mɨn kəmotəgɨn pɨk, kən motasiəp-asiəp, narmɨlat təmɨkə tahmen e netəm kəmotɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kən nagelo təmən-ipən kəm pətan mil məmə, “Suəgɨnən, məto-inu ekɨtun məmə natuegəs-in Iesu itəm kəmətu-pər e nɨg kəluau. ");
INSERT INTO tnn_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tɨkə u ikɨn-u. In təməmegəh mɨn e nɨmɨsən tahmen əm e inu təmən mihin aupən. Uea muəplan ikɨn təmatəməhl ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kən ian uəhai, kən muən-ipən kəm rəhan netəmim məmə, ‘In təməmegəh mɨn e nɨmɨsən, kən in tətaupən-in itəmat matuwɨn əpəh Kalili. Kən ikɨn əh, onəkotəplan in əh-ikɨn.’ Itəla, rəhak u nəghatən enən kəm itəmlau.” ");
INSERT INTO tnn_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kən pətan mil kəmuagɨm uəhai əm e suwɨt e nɨpəg kəpiel, matuəgɨn, məto nɨkilau tətagien, mətian məmə okuən-ipən kəm netəmim rəha Iesu. ");
INSERT INTO tnn_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kən əmun, Iesu tiet-arəpa olau, mən-ipən məmə, “Təwɨr.” Kən kəmuea o Iesu, muaskəlɨm nelkɨn, kən muəfak kəm in. ");
INSERT INTO tnn_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kən Iesu təmən-ipən kəm ilau məmə, “Suəgɨnən. Ian muən-ipən kəm piak mɨn məmə okotuwɨn Kalili. Ikɨn əh okotəplan io ikɨn.” ");
INSERT INTO tnn_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nian pətan mil kəmualiwək mətian, kən mopael mɨn əh neen kəmotuwɨn e taon, kən motən-ipən kəm pris asol mɨn natɨmnat rafin itəm kəmotəplan. ");
INSERT INTO tnn_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nian pris asol mɨn kəmotuwɨn motəplan netəm-iasol rəha noanol rəha Isrel, kən moatol noa kit motəlis nəghatən lan. Kən motos-ipən məni asol kəm mopael mɨn, ");
INSERT INTO tnn_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","motən-ipən kəm ilat məmə, “Nakotən-ipən kəm netəmim məmə, ‘Rəhan netəmim kəmotuwa lapɨn nian itɨmat emotapɨl, motakləh-in nɨpətɨn motɨləs motagɨm.’ ");
INSERT INTO tnn_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Okəmə kapman otəto namnusən u, kən itɨmat ekotəg-ətuatɨp-in nəghatən u kəm in. Itəmat onəsotosən nəratən lan.” ");
INSERT INTO tnn_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tol nəhlan, mopael mɨn kəmotos məni, kən motol tahmen-pən əm məmə kəmən mihin kəm ilat. Kən namnusən u təmuwɨn mɨtəlau e netəm Isrel muwa mətoarus-pa roiu. ");
INSERT INTO tnn_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kən netəm lepen rəha Iesu kəmotuwɨn Kalili, motuwɨn e nɨtot itəm Iesu təmən kəm ilat məmə okotuwɨn ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nian kəmotəplan in, kən kəmotəfak kəm in, məto neen rəhalat nətəlɨgən tatol kəiu. ");
INSERT INTO tnn_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kən Iesu tuwa olat, kən mən-ipən kəm ilat məmə, “Nepətən rafin rəha nego e neai ne nətueintən o nərəmərəən, Uhgɨn təmos-ipa kəm io. ");
INSERT INTO tnn_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tol nəhlan, otuwɨn motiuw netəmim rəha noanol mɨn rafin e nətueintən məmə okotuwa rəhak netəmim, kən motol baptais elat e nərgɨ Tata Uhgɨn, ne Nətɨn, ne Narmɨn, ");
INSERT INTO tnn_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","kən motəgətun ilat məmə okotətəu-pən rafin nəghatən mɨn itəm emən kəm itəmat. Kən nɨpahrienən, ekətatɨg kitat min itəmat nian mɨn rafin mətoarus namnun nian.” ");
INSERT INTO tnn_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Inu nətuounən rəha Namnusən Təwɨr rəha Iesu Kristo, Netɨ Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ien rəha Uhgɨn, nərgɨn u Aesea təməte-pən mihin e naoa aupən. Uhgɨn təmən məmə, “Otəplan-tu. Iatahl-ipɨnə rəhak iahləpis itəm otos rəhak nəghatən. In otaupən-in ik məmə otol əpen-əpenə e rəham suatɨp.” ");
INSERT INTO tnn_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Suah kit tətaun əpəh ikɨn taruən-aruən ikɨn matən məmə, ‘Itəmat, otol əpen-əpenə o suatɨp rəha Iərəmərə, kən motol rəhan suatɨp tətuatɨp.’” ");
INSERT INTO tnn_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kən tol nəhlan, Jon Baptais təmiet-pa ikɨn taruən-aruən ikɨn matol baptais e netəmim, kən matən-iarəp nəghatən rəha Uhgɨn kəm ilat məmə okotəkəike motəuhlin məntaalat o nolən rat mɨn rəhalat, kən motuwɨn o Uhgɨn, məmə in otafəl nolən rat mɨn rəhalat. Kən e nəmtətin kit, okol baptais elat. ");
INSERT INTO tnn_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Netəmim rafin rəha nɨtən əh Jutia ne taon əh Jerusalem, kəmotuwa motətəlɨg-in rəhan nəghatən kən motən-iarəp rəhalat nolən rat mɨn, kən Jon təmol baptais elat əpəh e nəhau Jotan. ");
INSERT INTO tnn_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon təməsuwɨnən e natɨmnat wɨr. Rəhan natɨmnat tahmen əm e rəha ien u Elaija aupən. Rəhan natɨmnat kəmol e nɨməme kamel, kən rəhn kətəut kəmol e nuwigɨ kau, kən matun əm pitɨp ne nahui sukapak e nɨkinat. ");
INSERT INTO tnn_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kən təmatən-iarəp kəm netəmim məmə, “Suah kit u tatuarisɨg-in io, rəhan nəsanənən ne nepətən taprəkɨs-in io. Io ekəsahmen-in mɨnən məmə ekeiuaiu mapeg rəkɨs rəhan put. ");
INSERT INTO tnn_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ekatol baptais etəmat e nəhau, məto in otəpanol baptais etəmat e Narmɨn Rəha Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","E nian əh, Iesu təmiet əpəh Nasaret, latuənu kit rəha Kalili muwa. Kən Jon təmol baptais lan əpəh e nəhau Jotan. ");
INSERT INTO tnn_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nian Iesu təmər əpəh e nəhau, kən masɨpər məplan nego e neai təmerəh, kən Narmɨn Rəha Uhgɨn təmeiuaiu-pa ron tahmen-pən e mak. ");
INSERT INTO tnn_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kən nəghatən kit təmɨsɨ-pər əpəh e nego e neai matən min-nulan məmə, “Ik netɨk keike, ekolkeike pɨk ik, kən nɨkik tagien pɨk agɨn ron ik.” ");
INSERT INTO tnn_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kən roiu agɨn-əh mɨn, Narmɨn Rəha Uhgɨn təmit-ipən Iesu əpəh ikɨn taruən-aruən ikɨn, ");
INSERT INTO tnn_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ima nat iarupɨn mɨn. Təmatɨg ikɨn mos nian fote. Nian mɨn Setan tatos-ipən-os-ipən kəm in. Kən nagelo mɨn kəmotasitu lan. ");
INSERT INTO tnn_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nian kɨnɨləs-ipən rəkɨs Jon e kalapus, Iesu təmuwɨn əpəh Kalili matən-iarəp Namnusən Təwɨr rəha Uhgɨn kəm netəmim. ");
INSERT INTO tnn_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Təmən məmə, “!Ure! !Rəhan nian tɨnuwa! !Nian rəha nərəmərəən rəha Uhgɨn tɨnatuwa iuəhkɨr! !Otəuhlin nətəlɨgən rəhatəmat, motapəs pahrien nolən rat mɨn, kən motuwɨn o Uhgɨn, kən motahatətə e Namnusən Təwɨr!” ");
INSERT INTO tnn_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nian Iesu təmətaliwək e nɨkalɨ Lek Kalili, kən məplan suah mil kəiu, etəmim rəha niuwən nəm mɨn, nərgɨlau u Saimon ne pian Antru. Kətuatɨp-in rəhalau net. ");
INSERT INTO tnn_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Kən Iesu təmən-ipən kəm ilau məmə, “Uea, mətəu-pa io, muea rəhak etəmim mil, kən io ekol itəmlau nakuea etəmim mil rəha niuwən netəmim məmə okotuwa rəhak mɨn netəmim.” ");
INSERT INTO tnn_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kən əmun kuapəs rəhalau net, kən muətəu-pən. ");
INSERT INTO tnn_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kən Iesu təmaliwək muwɨn təhmɨn mɨn məsɨn, kən məplan netɨ Sepeti mil Jemes ne pian Jon katuəpələh e rəhalau pot matuəhl wɨr rəhalau net. ");
INSERT INTO tnn_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kən e nian əm əh inəh, Iesu təmaun-in ilau lan, kən kuətul muapəs rəhalau tata Sepeti ne rəhan iolwək mɨn kotəpələh e nɨpəg noa pot, kən muətəu-pən Iesu. ");
INSERT INTO tnn_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kən Iesu ne rəhan mɨn netəmim kəmotuwɨn əpəh Kapaneam. Kən e nian rəha Sapat, Iesu tuwɨn əpəh e nimə rəha nuəfɨmɨnən matəgətun netəmim. ");
INSERT INTO tnn_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kən netəmim kəmotəto rəhan nəghatən, kən narmɨlat təmiwɨg pɨk ron məto-inu rəhan nəghatən təfɨgəm, nepətən əh-ikɨn, kən maprəkɨs-in mɨn rəha iəgətun mɨn rəha Lou. ");
INSERT INTO tnn_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kən e nian əh, suah kit narmɨn rat tətatɨg lan təmuwa imə kən mətagət əfəməh məmə, ");
INSERT INTO tnn_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“!Ik Iesu etəm Nasaret! ?Nəmuwa məmə onakahro itɨmat? !Okəmə naka nəmuwa məmə onakərəkɨn itɨmat! !Io enəmɨtun rəkɨs ik, ik Etəm Asim rəha Uhgɨn!” ");
INSERT INTO tnn_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Kən məto Iesu təmən-ipən əskasɨk kəm narmɨn rat un məmə, “!Ah! Əsəghatən, miet e suah un.” ");
INSERT INTO tnn_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kən narmɨn rat təmol nɨpətɨ suah apon tasiəp-asiəp, magət əfəməh miet lan. ");
INSERT INTO tnn_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kən netəmim kəmotaut motən-ipən kəm ilat mɨn məmə, “!Ei, naka u! Okəmə naka nəgətunən wi kit u. !Suah u tatos nəsanənən o nəghatən kəm narmɨn rat mɨn, kən koatətəlɨg-in motol nəwian!” ");
INSERT INTO tnn_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kən kəmamnus ueiuəhai əm Iesu, tuwɨn mapəkol əpəh e nɨtən Kalili. ");
INSERT INTO tnn_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nian Iesu ne Jemes, Jon, Saimon, ne Antru kəmotiet e nimə rəha nuəfɨmɨnən, kən motaiu ətuatɨp əm kan əpəh latuənu rəha Saimon ne Antru ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nian kəmotuwɨn, məto uhu Saimon tatətəp-ətəp, kən mətapɨl-pər e rəhan pet, kən kəmotən-ipən kəm Iesu məmə pətan əh tatɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Kən Iesu təmuwɨn mea-pən o nelmɨn kən tətul. Kən nətəp-ətəpən tagɨm lan, kən tuwɨn matol nɨgɨlat nagwənən. ");
INSERT INTO tnn_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tɨnehnaipən mɨt tɨnaht, nian rəha Sapat tɨnol namnun, kən netəm mɨn u koatɨmɨs, ne netəm narmɨn rat tətatɨg elat, pialat mɨn kəmotəmɨk ilat motuwa o Iesu. ");
INSERT INTO tnn_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Netəmim rafin e latuənu un kəmotuwa motargəfɨmɨn əm ilat mɨn əpəh e nafiluə e nimə un rəha Saimon ne Antru. ");
INSERT INTO tnn_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kən Iesu təmol-wɨr netəmim tepət u koatos nɨmɨsən pɨsɨn-pɨsɨn mɨn kotəwɨr, kən məhg-iarəp narmɨn rat tepət e netəmim, məto təmən-iəhau narmɨn rat mɨn məmə okəsotəghatən, məto-inu kɨnotɨtun rəkɨs məmə pah u Iesu. ");
INSERT INTO tnn_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kən laulaugɨn agɨn, fetukai təsɨrən əh, Iesu təmiet muwɨn əpəh ikɨn netəmim kotɨkə ikɨn matəfak. ");
INSERT INTO tnn_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kən Saimon ne in mɨn neen kəmotuwɨn kateam-in. ");
INSERT INTO tnn_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nian kəmotəplan, kən kəmotən-ipən kəm in məmə, “Netəmim rafin koteam-in ik.” ");
INSERT INTO tnn_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Məto Iesu təmən-ipən kəm ilat məmə, “Kəpə. Pəs kotuwɨn əpəh e latuənu pɨsɨn mɨn neen, ekamnus-iarəp rəhak nəghatən kəm netəmim mapəkol məto-inu, nat əh in əh emuwa ron məmə ekol.” ");
INSERT INTO tnn_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kən muwɨn mapəkol rafin e nɨtən əpəh Kalili, mətamnus-iarəp rəhan nəghatən əpəh e nimə rəha nuəfɨmɨnən mɨn, kən məhg-iarəp narmɨn rat mɨn e netəmim. ");
INSERT INTO tnn_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Suah kit leprosi təmol təmuwa mɨsin-pən nulɨn o Iesu mətasəkin-pən nəwɨrən ron məmə, “Okəmə nakolkeike, kən nəkɨtun nol-wɨrən io kən mafəl rəkɨs namkɨmɨkən lak.” ");
INSERT INTO tnn_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kən Iesu nɨkin təmahmə pɨk ron, kən təməg-əfəməh-in nelmɨn mələhəu-pən lan, mən məmə, “Əwəh. Iakolkeike. !Əwɨr-ta!” ");
INSERT INTO tnn_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kən roiu agɨn-əh, nɨmɨsən leprosi təmagɨm mɨkə lan, kən nɨpətɨn tɨnəwɨr, namkɨmɨkən tɨnɨkə. ");
INSERT INTO tnn_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Kən Iesu təmən-ipən əskasɨk kəm suah un məmə, “Əsən-iarəpən natɨmnat mɨn u kəm netəmim, məto uwɨn əm mehm pris kit pəs in tehm məmə nɨpətɨm tɨnol min-nulan, kən os-ipən kəm in nat u itəm Lou rəha Moses təmən o suah kit itəm rəhan leprosi tɨnɨkə, kən netəmim okotɨtun məmə nɨpahrienən nɨnəwɨr, kən rəham namkɨmɨkən tɨnɨkə.” Kən mahl-ipən tatuwɨn. ");
INSERT INTO tnn_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Məto suah un təmuwɨn kən mən-iarəp nat un kəm netəmim mɨn rafin mol Iesu təsuwɨnən e latuənu mɨn məghat məto-inu nɨmanin netəmim tepət pɨk koatətulosɨg-in. Kən o nat əh inəh, təmətan ikɨn netəmim kotɨkə ikɨn. Kən netəmim kotɨsɨ-pən əpəh ikɨn mɨn rafin moatuwa ron. ");
INSERT INTO tnn_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nian neen kɨnotuwa rəkɨs mɨnotuwɨn, Iesu təmɨtəlɨg-pən mɨn əpəh Kapaneam, kən nəghatən təmaiu muwɨn kəm netəmim mɨn məmə Iesu əpəh rəhan nimə. ");
INSERT INTO tnn_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kən netəmim tepət kəmotuwa motər wɨr əpəh imə, ne ihluə ne, kən rum tɨkə o etəmim kit mɨn. Kən Iesu tatən-iarəp rəhan nəghatən kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Kən suah kuwɨt kəmotalis pialat kit motuwa o Iesu itəm nɨpətɨn məsɨn təmɨmɨs mətapɨl-pər e rəhan nɨmɨtiwɨn. ");
INSERT INTO tnn_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nian kəmotuwa, məto netəmim kɨnotər əpəh imə, kən okol kotəruru nuwɨnən kehm Iesu. Kən kotɨləs motuwɨn əpəh ilɨs e nimə motos-irəkɨs nəhgɨ nimə məsɨn ətuatɨp əm əh Iesu tatətul ikɨn imə, kən motəhlman-əhlman suah un tatite e nɨmɨtiwɨn rəhan muwɨn iuəhkɨr əm o Iesu. ");
INSERT INTO tnn_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nian Iesu təməplan nahatətəən rəhalat, kən tən-ipən kəm etəm tatɨmɨs un məmə, “Nətɨk, enos-irəkɨs rəkɨs nolən rat rəham.” ");
INSERT INTO tnn_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Məto iəgətun mɨn neen rəha Lou kotəpələh əpəh imə, kən nɨkilat təməht məmə, ");
INSERT INTO tnn_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“?Tahro suah u tatən rat Uhgɨn? Nəghatən əh tərat. Uhgɨn əm tɨtun nos-irəkɨsən nolən rat rəha etəmim. !Pah mɨn tɨtun nos-irəkɨsən!” ");
INSERT INTO tnn_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kən roiu agɨn-əh, Iesu tɨləs rəhalat nətəlɨgən, kən məmə, “?Tahro nɨkitəmat tatəht pɨk natɨmnat min-nulan? ");
INSERT INTO tnn_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","?Itəm pəhruən tɨmetɨg, itəm u məmə ekən-ipən kəm suah əh məmə, ‘Enos-irəkɨs rəkɨs rəham nolən rat,’ o itəm u tɨmətɨg məmə, ‘Ətul, mɨləs rəham nɨmɨtiwɨn matuwɨn’? ");
INSERT INTO tnn_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Məto ekol nat kit məmə onəkotɨtun məmə io Netɨ Etəmim, iatos nepətən ikɨn-u e nətueintən o nos-irəkɨsən nolən rat rəha netəmim.” Kən məghat kəm suah əh məmə, ");
INSERT INTO tnn_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Iatən-ipɨnə kəm ik məmə, ətul, mɨləs rəham nɨmɨtiwɨn matuwɨn imam ikɨn.” ");
INSERT INTO tnn_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Kən əmun suah apon təmətul, mɨləs rəhan nɨmɨtiwɨn, maliwək matuwɨn, kən ilat rafin kəmotəplan, motaut, narmɨlat təmiwɨg ron kən motənwiwi Uhgɨn motəmə, “Ekəsotehmən əh nat kit tol min-nulan ne, nian kit.” ");
INSERT INTO tnn_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesu təmuwɨn mɨn mətaliwək əpəh e nɨkalkal nəhau Lek Kalili, kən nɨmanin netəmim kəmotuwa ron, kən tatəgətun ilat. ");
INSERT INTO tnn_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kən təmaliwək matuwɨn kən məplan Lifae netɨ Alfeas, in etəmim rəha nosən məni rəha takɨs, tatəpələh imə matol rəhan wək. Kən Iesu təmən-ipən kəm in məmə, “Ətəu-pa io, muwa rəhak etəmim.” Kən əmun tətul muarisɨg-in. ");
INSERT INTO tnn_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kən nian kit, Iesu təmuwɨn mətagwən əpəh ima Lifae ikɨn ilat netəmim rəha nosən məni rəha takɨs, ne netəm nol təfagə rat neen. Kotagwən əm kitiəh ilat Iesu ne rəhan mɨn netəmim məto-inu netəmim tepət kotol təfagə rat nəhlan kotuarisɨg-in Iesu. ");
INSERT INTO tnn_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Iəgətun rəha Lou neen, ilat u Farisi. Kən neen kəmotəplan məmə Iesu tətagwən əm kitiəh ilat nol təfagə mɨn un, ne netəmim rəha nosən məni rəha takɨs, kən kotətapəh o netəmim rəhan mɨn məmə, “?Tahro Iesu tətagwən əm kitiəh ilat netəm koatol nəhlan?” ");
INSERT INTO tnn_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kən Iesu təməto rəhalat nəghatən, kən təmən-ipən kəm ilat məmə, “Netəm mɨn u kəsotɨmɨs-ɨmɨsən kəsotuwɨnən o tokita, məto netəm mɨn u koatɨmɨs-ɨmɨs koatuwɨn ron. Io eməsuwamən o netəm mɨn u kotəmə kɨnotətuatɨp rəkɨs. Məto emuwa o netəm mɨn u kotɨtun əm məmə ilat koatol nolən rat mɨn.” ");
INSERT INTO tnn_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Kən e nian əh, netəmim mɨn rəha Jon Baptais ne Farisi mɨn kəmotapəs nagwənən motətuakəm o nəfakən kəm Uhgɨn. Kən netəmim neen kəmotuwa motən-ipən kəm Iesu məmə, “Əplan-tu, netəmim rəha Jon Baptais ne Farisi mɨn kotətuakəm o nəfakən. ?Məto tahro rəham mɨn kəsotolən mihin?” ");
INSERT INTO tnn_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Kən Iesu təmən-ipən kəm ilat məmə, “?Nian katol lafet lan rəha etəm tatol marɨt, kən iərman u otol marɨt tətatɨg əh ilat in mɨn neen motol lafet, nɨkitəmat tatəht məmə otətuakəm motapəs nagwənən? !Kəpə! Nian tətatɨg əh ilat min, kən nɨkilat tətagien, motagwən əm. ");
INSERT INTO tnn_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Məto nian əpəh ikɨn məmə okəpanɨləs-irəkɨs suah əh lan, kən e nian əh in əh, in mɨn neen nɨkilat otahmə ron, kən kəpanotətuakəm motapəs nagwənən.” ");
INSERT INTO tnn_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Kən təmatɨg mən mɨn məmə, “Suah kit mɨn okol təsəhl-pənən nɨmɨsmɨsɨ nɨməhan wi kit e nɨməhan oas itəm təmerəh. Okəmə otəhl-pən, kən nɨməhan wi un tɨtun nəhap asolən nɨməhan oas un. ");
INSERT INTO tnn_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Suah kit mɨn okol təsiuw-pənən wain wi kit e nuwigɨ nat oas kit, məto-inu okəmə otiuw-pən wain wi e nuwigɨ nat oas itəm təskasɨk, kən wain otapuəl-apuəl kən nuwigɨ nat oas un otahgig kən məhap, kən wain ne nuwigɨ nat un okuərat. Məto wain wi okiuw-pən əm e nuwigɨ nat wi itəm tɨmətmətɨg.” ");
INSERT INTO tnn_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","E nian kit e Sapat, Iesu ne rəhan mɨn netəmim kəmotaliwək motuwɨn-pən əpəh e nɨki nasumən rəha wit, kən netəmim mɨn rəha Iesu kəmotəhl wit məmə okotun. ");
INSERT INTO tnn_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kən Farisi mɨn u kotaskəlɨm əskasɨk Lou rəha Moses kəmotən-ipən kəm Iesu məmə, “!Ei, əplan-tu! E Sapat, kəsəuləkən əh e nasumən ne kəsolən natɨmnat mɨn nəhlan kotərəkɨn Lou. ?Tahro rəham netəmim mɨn kotol nəhlan?” ");
INSERT INTO tnn_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Iesu təmuhalpɨn rəhalat nəghatən məmə, “Okəm-naka itəmat nakəsotafinən əh nat u Tefɨt təmol aupən nian Apiata in pris asol agɨn rəha Uhgɨn. Itəmat nɨnotafin rəkɨs məmə Tefɨt nəumɨs təmus, kən tuwɨn əpəh e Nimə Tapolən rəha Uhgɨn, kən mɨləs pɨret asim u pris mɨn əm koatun, kən in mɨləs muwa motun ilat in mɨn neen.” ");
INSERT INTO tnn_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kən təmatɨg mən-ipən mɨn kəm ilat məmə, “!Kəməsolən Sapat məmə in nat fɨgəm kəm netəmim, məto kəmol Sapat məmə otasitu elat kotameg! ");
INSERT INTO tnn_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tol nəhlan, io Netɨ Etəmim ekatərəmərə rafin e natɨmnat mɨn, kən matərəmərə mɨn e Sapat.” ");
INSERT INTO tnn_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","E Sapat kit mɨn, Iesu təmɨtəlɨg-pən mɨn əpəh e nimə rəha nuəfɨmɨnən kən məplan suah kit nelmɨn təmɨmɨs, təsəg-ətuatɨp-inən. ");
INSERT INTO tnn_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nian Iesu təmuwɨn imə, kən netəmim kəmotolkeike məmə okotən iərəkɨn Lou lan, kən motalkəlɨk wɨr ron məmə okotehm-tu məmə otol-wɨr suah un e Sapat, o kəp. ");
INSERT INTO tnn_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kən Iesu təmən-ipən kəm suah un məmə, “Ətul muwa u aupən,” kən tətul muwɨn əpəh aupən. ");
INSERT INTO tnn_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kən Iesu təməhai ilat məmə, “?Rəhatat Lou təmə kotɨtun nolən naka e Sapat? ?Təmə təwɨr məmə okotol nat wɨr, o nat tərat? ?Təwɨr məmə okotosmegəh netəmim, o təwɨr məmə okotohamnu netəmim?” Məto kotəpnapɨn əm. ");
INSERT INTO tnn_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kən Iesu təmasɨpən məplan ilat, kən neməha tol, kən nɨkin tahmə olat məto-inu rəhalat-kapə tiəkɨs pɨk. Kən mən-ipən kəm suah un məmə, “Əg-ətuatɨp-in-tu nelməm.” Kən suah apon təməg-ətuatɨp-in nelmɨn, əmun nelmɨn təwɨr. ");
INSERT INTO tnn_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kən Farisi mɨn apon kəmotiet motaiu ətuatɨp əm motuwɨn motəplan rəhalat tɨkɨmɨr mɨn e pati rəha Herot, motol əm kitiəh moteam-in suatɨp məmə okotɨləs Iesu motohamnu. ");
INSERT INTO tnn_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesu ne rəhan mɨn netəmim kəmotiet moteiuaiu motuwɨn əpəh e nəhau Lek Kalili. Nɨmanin netəmim kəmotuarisɨg-in ilat. Netəm mɨn un neen kəmotɨsɨ-pən e latuənu rəhalat e nɨtən Kalili, ");
INSERT INTO tnn_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","neen kotɨsɨ-pən əpəh e latuənu əlkələh mɨn ne Jerusalem rəha nɨtən əpəh Jutia. Neen mɨn kəmotɨsɨ-pis e nəwtain məsɨn əpəh nɨtən Itumia ne e nəwtain nəhau Jotan entənɨpən-pən matuwɨn. Neen mɨn kəmotɨsɨ-pəhap əpəh ikɨn mɨn e taon mil un Taea ne Saeton. Netəm mɨn un kɨnotəto rəkɨs natɨmnat mɨn un Iesu tatol ilat, kən kotuwa məmə okotəplan. ");
INSERT INTO tnn_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kən nɨmanin netəmim kəmotuwa pɨk, kən Iesu təmən-ipən kəm rəhan mɨn netəmim məmə okotol-əpen-əpenə e pot kit məmə otuwɨn məpələh lan, məmə nɨmanin netəmim okəsotəhg-əhg pɨkən in. ");
INSERT INTO tnn_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Məto-inu tɨnol-wɨr rəkɨs netəmim tepət, kən netəm mɨn u kotɨmɨs əh kotəhg-əhg ilat mɨn məmə okotuwa iuəhkɨr motek Iesu. ");
INSERT INTO tnn_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kən nian netəmim itəm narmɨn rat mɨn kotatɨg elat kəmotəplan Iesu, koteiuaiu aupən-in motorin ilat motagət əfəməh məmə, “!Ik Netɨ Uhgɨn!” ");
INSERT INTO tnn_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Məto Iesu təmən-iəhau əskasɨk narmɨn rat mɨn un məmə okəsotən-iarəpən in kəm netəmim. ");
INSERT INTO tnn_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kən Iesu ne kəmotuwɨn əpəh e noanu nɨtot mɨn, kən tətaun-in netəmim neen məmə okotuwa ron. ");
INSERT INTO tnn_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nian kəmotuwɨn, kən təmɨtəpun rəkɨs ilat tuelef kən mos-ipər ilat məmə aposol mɨn. In təmən mɨn məmə netəm mɨn əh, ilat əh okotaliwək ilat min, kən in otahləpis ilat kotuwɨn motən-iarəp namnusən təwɨr kəm netəmim əpəh ikɨn mɨn, ");
INSERT INTO tnn_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","kən okotos mɨn nepətən ne nəsanənən o nəhg-iarəpən narmɨn rat mɨn e netəmim. ");
INSERT INTO tnn_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Netəm mɨn u ilat u təmɨtəpun ilat, ilat u, Saimon u Iesu təməhun-pən mɨn nərgɨn kit mɨn məmə Pita, ");
INSERT INTO tnn_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ne Jemes ne pian Jon netɨ Sepeti mil u Iesu təmos-ipən mɨn nərgɨlau təhan məmə, “Poanejes,” nɨpətɨ nəghatən əh təmə netɨ kaluəluə mil, məto-inu neməha tatol ueiuəhai ilau, ");
INSERT INTO tnn_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","19","ne Antru, Filip, Patolomiu, Matiu, Tomas, Jemes u netɨ Alfeas, Tateas, Saimon u kətaun-in məmə Selot, ne Jutas Iskariot u təmegəhan-in-pən Iesu e nelmɨ tɨkɨmɨr mɨn. Netəm mɨn əh ilat əh tuelef, Iesu təmos-ipər ilat. ");
INSERT INTO tnn_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Uarisɨg, təmɨtəlɨg-pən mɨn latuənu, kən nɨmanin netəmim kəmotuwa mɨn ron, kən Iesu ne rəhan mɨn netəmim kɨnotəruru namegən ne nagwənən ne. ");
INSERT INTO tnn_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nian rəhan mama ne kəmotəto nəghatən u katən e Iesu, kən motuwa məmə okotit-irəkɨs o netəmim, məto-inu netəmim neen koatən məmə Iesu nɨtalməl. ");
INSERT INTO tnn_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Iəgətun mɨn neen rəha Lou kəmotɨsɨ-pən əpəh Jerusalem motuwa kən motəmə Pielsepul, u in etəm-iasol rəha narmɨn rat mɨn, in tətatɨg e Iesu, kən motəmə in tatos-ipən nəsanənən kəm Iesu məmə otəhg-iarəp narmɨn rat mɨn e netəmim. ");
INSERT INTO tnn_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kən Iesu təmaun-in ilat kotuwa iuəhkɨr ron kən tatuəh nimaa nəghatən kəm ilat, məmə, “?Nɨkitəmat tatəht məmə okol Setan təhg-iarəp atɨp Setan? !Kəp! ");
INSERT INTO tnn_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Okəmə netəmim e kantri kit koatoor ilat mɨn, kən okotərəkɨn rəhalat kantri, kən nərəmərəən rəhan otɨsas mɨkə. ");
INSERT INTO tnn_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kən tahmen-pən əm, e latuənu kit, okəmə netəmim lan koatoor ilat mɨn, kən okotərəkɨn agɨn-əh latuənu u. ");
INSERT INTO tnn_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kən okəmə Setan tatəhg-iarəp narmɨn rat mɨn rəhan e netəmim, kən tatol atɨp əm tɨkɨmɨr kəm in. ?Kən otahro nulan, rəhan nərəmərəən otətul? Wək rəhan otɨsas mɨkə. ");
INSERT INTO tnn_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Kən okol iakləh kit təsuwɨn əpnapɨnən imə e rəha etəm kəgin kit ikɨn, mətakləh-in natɨmnat rəhan, məto otəkəike məlis e nol, mələhəu u, kən panuwɨn makləh-in rəhan natɨmnat. ");
INSERT INTO tnn_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ekatən pahrien kəm itəmat məmə təfagə rat rafin rəha netəmim, ne nəghatən rat mɨn itəm ilat koatən, Uhgɨn tɨtun nos-irəkɨsən. ");
INSERT INTO tnn_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Məto etəm tatən rat Narmɨn Rəha Uhgɨn, okol Uhgɨn təsos-irəkɨsən rəhan təfagə rat. Təfagə rat un otətatɨg kitiəh lan mətatɨg, okol təsɨkəən.” ");
INSERT INTO tnn_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesu təmən nəhlan məto-inu kəmotaupən motən məmə narmɨn rat kit tətatɨg lan. ");
INSERT INTO tnn_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kən e nian əh, mama rəha Iesu ne pian mɨn kəmotuwa, kən moatətul əm əpəh ihluə kən motahl-ipən nəghatən o Iesu məmə tuwa-tu mehm ilat. ");
INSERT INTO tnn_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Kən nɨmanin netəmim kəmotəpələh kan keko-in Iesu, kən kən-ipən kəm Iesu məmə, “Ei, mama rəham ne piam mɨn əpəh ihluə, kotolkeike məmə okotehm-tu ik.” ");
INSERT INTO tnn_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Kən Iesu təmən-ipən kəm ilat məmə, “?Pah u rəhak mama ne piak mɨn?” ");
INSERT INTO tnn_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kən masɨpən məplan rafin ilat kən məmə, “Otasɨpən-tu. Itəmat u piak mɨn ne rəhak mama ətuatɨp mɨn. ");
INSERT INTO tnn_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Netəm mɨn u koatol nəwia Uhgɨn, ilat u piak mɨn, ne rəhak kaka mɨn, ne rəhak mama.” ");
INSERT INTO tnn_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Kən Iesu təmɨtəlɨg-pən mɨn əpəh e Lek Kalili matəgətun netəmim, məto nɨmanin netəmim kəmotuwa ron, motol məmə Iesu tuwɨn e pot. Kən pot un tatəməhl-pən e lek, kən Iesu tatəpələh-pən lan. Kən nɨmanin netəmim kəmotəpələh əpəh ipar e nɨkalkal lek. ");
INSERT INTO tnn_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kən Iesu tatuəh nimaa nəghatən mɨn kəm ilat matəgətun ilat e natɨmnat tepət. ");
INSERT INTO tnn_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Təmən-ipən kəm ilat məmə, “Otətəlɨg-tu. Suah kit təmuwɨn məmə oteatəgtəg rəhan nɨkutin natɨmnat əpəh e rəhan nasumən. ");
INSERT INTO tnn_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nian təmateatəgtəg rəhan nɨkutin natɨmnat, kən neen kotɨsas-pən əpəh e nɨkalkal suatɨp, kən mənɨg mɨn kotuwa moaton rəkɨs. ");
INSERT INTO tnn_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kən neen komotɨsas-pən əpəh e nɨki kəpiel, kən motəwiə uəhai əm məto-inu nɨsɨp noan məsɨn. ");
INSERT INTO tnn_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kən nian nərauiə təhg ilat kən kotauke-auke motamɨs, məto-inu nokɨlat təməseiuaiu pɨkən. ");
INSERT INTO tnn_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kən neen kəmotɨsas-pən e nɨki nolkosɨk. Nian kəmotəwiə məto nolkosɨk tətaht-əsɨn ilat kən mətatu-atu-pən elat, kən kotəwiə rat kən məsotoeən. ");
INSERT INTO tnn_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kən neen mɨn kəmotɨsas-pən e nəptən wɨr, kən motəwiə wɨr motol iahgin, kən motoe-in noalat, neen noalat tate, neen noalat sikiste, neen noalat wan-hanrɨt.” ");
INSERT INTO tnn_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kən Iesu təmatɨg mən-ipən mɨn kəm ilat məmə, “Etəm matəlgɨn tatɨg, təwɨr məmə in otətəlɨg-in wɨr kən mɨtun nəghatən mɨn u.” ");
INSERT INTO tnn_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nian Iesu ne kəmotan pɨsin əm ilat rəhan netəmim tuelef ne netəm kotuarisɨg-in, kən kotətapəh ron o nuəhən nimaa nəghatən mɨn. ");
INSERT INTO tnn_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kən Iesu təmən-ipən kəm ilat məmə, “Itəmat un, Uhgɨn tatən-ipɨnə nəghatən anion rəhan kəm itəmat məmə in tatuwa məmə otərəmərə e rəhan mɨn netəmim. Məto netəm mɨn u Iaihluə mɨn, kotəto əm nəghatən rəha Uhgɨn e nuəhən nimaa nəghatən. ");
INSERT INTO tnn_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nolən u tol min-nəhlan məmə, ‘Kotarəplan pap məto kəsotehmən, moatəto pap, məto kəsotɨtunən, kən məto-inu rəhalat-kapə tiəkɨs, kən ko kəpotɨtəlɨg motapəs rəhalat təfagə rat, məmə Uhgɨn otos-irəkɨs rəhalat təfagə rat.’” ");
INSERT INTO tnn_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kən Iesu təmən-ipən kəm ilat məmə, “?Okəmə naka itəmat nəkotəruru əh nuəhən nimaa nəghatən u? ?Itəmat nakotəmə onəkotahro motɨtun mɨn nɨpətɨ nuəhən nimaa nəghatən pɨsɨn pɨsɨn mɨn rafin? Otətəlɨg-in wɨr-tu məmə nəkotɨtun. ");
INSERT INTO tnn_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Nɨpətɨ nuəhən nimaa nəghatən e nɨkutin natɨmnat əh tahmen əm e nəghatən rəha Uhgɨn itəm katən-iarəp kəm netəmim, kən nɨsɨp tahmen e nɨki netəmim. ");
INSERT INTO tnn_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Netəmim neen koatəto, məto tahmen əm e nɨkutin natɨmnat u tatɨsas-pən e suatɨp. Nian koatəto nəghatən rəha Uhgɨn, məto Setan tuwa mos-irəkɨs ueiuəhai əm olat. ");
INSERT INTO tnn_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Kən neen koatəto, məto tahmen əm e nɨkutin natɨmnat un tatɨsas-pən e nɨki kəpiel nokɨlat təseiuaiu pɨkən. Nian koatəto nəghatən rəha Uhgɨn, koatos ueiuəhai əm e nagienən, məto təsatɨgən tuwəh e nɨkilat. Nian koatatɨg rat, o netəmim koatol tərat kəm ilat o nəghatən rəha Uhgɨn, kən koatəme ueiuəhai əm e rəhalat nəmegəhən. ");
INSERT INTO tnn_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Netəmim neen mɨn koatəto, məto tahmen əm e nɨkutin natɨmnat u tatɨsas-pən e nɨki nolkosɨk. Nian koatəto nəghatən rəha Uhgɨn, ");
INSERT INTO tnn_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","məto rəhalat nətəlɨgən tatuwɨn pɨk o natɨmnat rəha nətueintən, kən ilat kotolkeike məmə rəhalat nautə ne natɨmnat wɨr mɨn otepət. Natɨmnat mɨn u kotahmen e nolkosɨk tətaht e nɨkilat, mol kotəpou-in nolən nəghatən rəha Uhgɨn, kən məsotoe-inən noalat. ");
INSERT INTO tnn_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kən neen mɨn koatəto, məto tahmen e nɨkutin natɨmnat u tatɨsas-pən e nəptən wɨr. Nian koatəto nəghatən rəha Uhgɨn, kotos e nɨkilat pahrien, kən motoe-in noalat, neen tate, neen sikiste, kən neen wan-hanrɨt.” ");
INSERT INTO tnn_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kən Iesu təmən-ipən kəm ilat məmə, “?Pah tətasiepən e lait kən mətaii-pən e pesɨn, o tatəhtu-pən e nɨpəg pet? !Kəp! Kəsolən mihin. Nian nakotasiepən e lait, kən motətu-pər e tepɨl məmə netəmim okotehm nat lan. ");
INSERT INTO tnn_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nat katəfətain okəike kepɨk, kən ne nat tatəhluaig otəkəike miet-pa ikɨn təhag-əhag ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Etəm matəlgɨn tatɨg, təwɨr məmə in otətəlɨg-in wɨr kən mɨtun nəghatən mɨn u.” ");
INSERT INTO tnn_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kən matɨg mən-ipən mɨn kəm ilat məmə, “Otətəlɨg-in wɨr-tu. Etəm u tatəto rəhak nəghatən məto təsətəu-pənən, okol təsɨtun wɨr mɨnən. Məto etəm un tatəto matətəu-pən, in otɨtun tepət məsɨn mɨn. ");
INSERT INTO tnn_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tol nəhlan məto-inu, etəm u itəm rəhan əh-ikɨn nɨtunən, kən in tatətəu-pən, kən Uhgɨn otos-ipən mɨn nɨtunən kəm in, kən rəhan nɨtunən in otepət pɨk. Məto etəm u itəm rəhan nɨtunən tɨkə, Uhgɨn otos-irəkɨs rafin rəhan nɨtunən itəm nɨkin təht məmə in tatos.” ");
INSERT INTO tnn_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kən Iesu təmən mɨn məmə, “Nərəmərəən rəha Uhgɨn tahmen e suah kit təmɨs nɨkutin natɨmnat əpəh e rəhan nasumən. ");
INSERT INTO tnn_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","28","Lapɨn mɨn tuwɨn mətapɨl, kən e nərauiəgən mɨn tuwɨn maliwək mətan, kən məsol mɨnən nat kit lan ne, məto-inu nɨsɨp əm tatos-ipən niamɨtəən kəm in məmə otoe-in noan. Məto nɨkutin nat un tɨnəwiə muwɨn mɨnol iahgin, məto suah un təruru məmə təmahro min-nulan məwiə. Kən təmərget mol iahgin, kən mol-pən nɨmalɨn, kən moe matuwɨn matuwɨn, kən mɨnɨmətə. ");
INSERT INTO tnn_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kən nian tɨnɨmətə, e nian əm əh inəh, suah apon tuwɨn mɨləs rəhan nisa muwɨn matəte rəkɨs matəulək-in, məto-inu nian ətuatɨp rəhan tɨnuwa.” ");
INSERT INTO tnn_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kən Iesu təmən mɨn məmə, “?Nərəmərəən rəha Uhgɨn tahro min-nulan? ?Karmə ekən naka məmə tahmen lan? ");
INSERT INTO tnn_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","In tahmen e nɨkuti mastat. Mastat un in nɨg kit nɨkutin netɨn, netɨn, netɨn. In təkəku e nɨkuti nɨg mɨn rafin. ");
INSERT INTO tnn_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Məto nian kəməfe, kən təwiə mol iahgin maprəkɨs-in nɨg mɨn itəm katəfe e nasumən, mol nelmɨn iahgin mɨn, kən mənɨg ilɨs mɨn kotuwa motol-pən niag-iagɨlat huə e tɨkəmkəmən.” ");
INSERT INTO tnn_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iesu təmatəgətun mihin nəhlan netəmim e nuəhən nimaa nəghatən tepət, məto təmatən-ipən əm tahmen məmə okotɨtun. ");
INSERT INTO tnn_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","In təmatəgətun əm netəmim e nuəhən nimaa nəghatən mɨn əh tepət. Məto nian kotan pɨsin əm ilat rəhan mɨn netəmim, kən tatən-iarəp nɨpətɨ nuəhən nimaa nəghatən kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Tɨnehnaipən, kən Iesu təmən-ipən kəm rəhan mɨn netəmim məmə, “Pəs-tu kotuwɨn-tu əpəh entənɨpən-pən e lek u.” ");
INSERT INTO tnn_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kən kəmotapəs netəmim, kən rəhan mɨn netəmim kəmotuwɨn e pot məto Iesu tɨnəmuwɨn rəkɨs matəpələh. Kən kəmotɨləs Iesu e pot moatuwɨn ilat pot neen mɨn kotuarisɨg-in ilat. ");
INSERT INTO tnn_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kəmoatuwɨn əmun nɨmətag asol kit nahgin-nahgin tahmen əm e nalip təmuwa. Kən peau-peau asol mɨn kotoralkin-pən əpəh e nɨpəgnoa pot, kən nəhau tɨnatər-pən e pot, kən pot natol o namnɨmən. ");
INSERT INTO tnn_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Məto Iesu əpəh uarisɨg tətapɨl əlu-alu matauloga-pən e pelo kit. Kən rəhan mɨn netəmim kəmotaiu motuwa motəhgaiir lan, motəmə, “!Ei, Iəgətun! !Tahro nɨkim təsəhtən itɨmat ne, iuəhkɨr əm ekotɨmɨs!” ");
INSERT INTO tnn_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Kən Iesu təmaiir mətul matən-iəhau nɨmətag ne nəhau məmə, “!Nahmen! !Uameg-ta!” Kən nɨmətag təmurahl nelmɨn, kən peau-peau asol mɨn apon kəmotɨkə, kən təməməlinu təməməlinu. ");
INSERT INTO tnn_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kən Iesu təmən-ipən kəm rəhan mɨn netəmim məmə, “?Tahro nakotəgɨn pɨk nəhlan? Okəmə naka rəhatəmat nahatətəən tɨkə əh lak.” ");
INSERT INTO tnn_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Məto rəhan mɨn netəmim kɨnotəgɨn pɨk, kən motən-ipən kəm ilat mɨn məmə, “!Ei nəman! ?Etəmim naka u? Nat əpnapɨn nɨmətag ne nəhau, məto ilau kətioal nəwian.” ");
INSERT INTO tnn_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Iesu ne rəhan mɨn netəmim kəmotuwɨn motuwar əpəh entənɨpən-pən e Lek Kalili, əpəh ima netəm Kerasa. ");
INSERT INTO tnn_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nian Iesu təmiet e pot, kən məplan suah kit təmɨsɨ-pən əpəh e nɨpəg kəpiel mɨn, ikɨn katɨtənɨm netəmim ikɨn. Suah un narmɨn rat tətatɨg lan. ");
INSERT INTO tnn_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Suah un tətatɨg əm əpəh e suwɨt, okol kəsaskəlɨmən, kən kəruru mɨn nəlisən e nol o sen. ");
INSERT INTO tnn_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nian tepət kotəlis nelmɨn ne nelkɨn ne e sen. Məto nian rafin tateatɨp-eatɨp sen, kən matoratɨp-oratɨp sen e nelmɨn ne nelkɨn ne, kən məsanən pɨk məsahmen-inən suah kit məmə otaskəlɨm. ");
INSERT INTO tnn_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kən lapɨn ne e nərauiəgən mɨn ne nian rafin, in tətan əpəh e suwɨt, ne əpəh e nɨtot mɨn, in pɨsɨn əm, mətagət əfəməh, kən matəte atɨp əm in e kəpiel asɨlə mɨn. ");
INSERT INTO tnn_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nian suah un təmasɨpən-in Iesu əpəh isəu tatuwa əh, kən təmaiu muwɨn meiuaiu mɨsin-pən nulɨn ron. ");
INSERT INTO tnn_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Kən mətagət əfəməh məmə, “!Iesu, ik Nətɨ Uhgɨn Ilɨs Agɨn! ?Nəmuwa məmə onakahro io?” Məto Iesu təmə, “!Ik narmɨn rat, iet e suah un!” Məto narmɨn rat apon təmə, “!Ekateasiə-in e nərgɨ Uhgɨn məmə onakəsolən nalpɨnən kəm io!” ");
INSERT INTO tnn_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kən Iesu təmətapəh ron məmə, “?Ik nərgəm pah?” Məto təmə, “Nərgək u, Nɨmanin Tepət, məto-inu itɨmat tepət.” ");
INSERT INTO tnn_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kən kəmotən-ipən əskasɨk kəm Iesu məmə otəsahl-iarəpən ilat əh-ikɨn əh. ");
INSERT INTO tnn_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ikɨn əh, pɨkəs mɨn tepət tepət kotalu əpəh e nɨkalɨ nɨtot un. ");
INSERT INTO tnn_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kən narmɨn rat mɨn apon kəmotən-ipən kəm Iesu məmə, “Kəsi, ahl-ipən-tu itɨmat ekotuwɨn o pɨkəs mɨn əpəh, megəhan-in itɨmat ekotuwɨn motatɨg əpəh elat” ");
INSERT INTO tnn_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kən Iesu təmegəhan-in ilat məmə okotuwɨn, kən narmɨn rat mɨn apon kəmotiet e suah apon motuwɨn əpəh e pɨkəs mɨn. Kən pɨkəs mɨn un kotahmen-in tu-taosan, kəmotaiu motuwɨn əpəh ikɨn təkul-əkul ikɨn, kən motiwɨg-pən əpəh ləhau e nəhau un motamnɨm. ");
INSERT INTO tnn_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kən netəmim itəm kəmotagwən pɨkəs mɨn un, kəmotaiu motuwɨn motən-iarəp natun kəm netəmim mɨn əpəh e taon rəhalat, kən motən tuwɨn mapəkol əpəh latuənu mɨn. Kən netəmim tepət kəmotuwa məmə okotəplan-tu nat un məmə kəmahrol min-nulan. ");
INSERT INTO tnn_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nian kəmotuwa o Iesu, kən motəplan suah un narmɨn rat mɨn kəmotatɨg lan aupən, tɨnapəs nalmələn kən mɨnuwɨn e natɨmnat matəpələh, kən narmɨlat təmiwɨg ron kən motəgɨn. ");
INSERT INTO tnn_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kən netəm mɨn u kəmotehm nat ətuatɨp e nɨganəmtɨlat kəmotamnus nat un kəmotehm Iesu təmol e suah un ne pɨkəs mɨn kəm ilat mɨn neen. ");
INSERT INTO tnn_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Məto netəm mɨn u e nɨtən un kəmotən-ipən əskasɨk kəm Iesu məmə otatuwɨn məsətulən əh iməlat ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kən nian Iesu tɨnatɨtəlɨg-pən mɨn məmə otuwɨn e pot, məto suah un narmɨn rat mɨn kəmotatɨg lan, təmolkeike pɨk məmə otuwɨn ilat Iesu ne, kən matən-ipən kəm Iesu məmə, “Egəhan-in io, pəs ekɨmnə kitat min itəmat.” ");
INSERT INTO tnn_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Məto Iesu təməsegəhan-inən, məto təmən-ipən kəm in məmə, “Ɨtəlɨg-pən imam ikɨn, kən mamnus kəm netəm imam ikɨn nat naka itəm Uhgɨn ilɨs pɨk təmol kəm ik, kən məmə in təmasəkitun ik.” ");
INSERT INTO tnn_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kən təmuwɨn əpəh ikɨn Tekapolis matən-iarəp natɨmnat itəm Iesu təmol kəm in. Kən nian netəmim kəmotəto, kən kəmotaut pɨk ron. ");
INSERT INTO tnn_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kən Iesu ne kəmotuwɨn mɨn e pot motɨtəlɨg-pən entənɨpən-pa e lek, məto nɨmanin netəmim kəmotuwa ron motɨtəlau in əpəh e nɨkalkal lek. ");
INSERT INTO tnn_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kən suah kit, nərgɨn u Jaeras, in etəm-iasol kit rəha nimə rəha nuəfɨmɨnən, təməplan Iesu kən təmuwa mɨsin-pən nulɨn ron. ");
INSERT INTO tnn_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Kən təmatətapəh o Iesu matəkəike kəm in o nasituən məmə, “Rəhak pətan əkəku tatɨmɨs pɨk otəsuwəhən tɨmɨs. !Awi, wa-tu kian nəkələhəu-pən nelməm lan pəs təwɨr məmegəh!” ");
INSERT INTO tnn_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kən Iesu təmətəu-pən suah un mətian, kən nɨmanin netəmim tepət kəmotuarisɨg-in kɨtəlau lan katɨləs-pɨkən-ləs-pɨkən. ");
INSERT INTO tnn_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kən pətan kit təmuwa o Iesu itəm tatos nɨmɨsən rəhalat nɨpɨtan nian rafin əm, mɨnos nup tuelef. ");
INSERT INTO tnn_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Kən təmuwɨn məplan tokita tepət, kən mərakin rafin rəhan məni elat, məto wək rəhalat kəmotol təto pɨk nahməən. Məto rəhan nɨmɨsən təməseiuaiuən, in təmər məsɨn mɨn. ");
INSERT INTO tnn_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","In təməto namnusən e Iesu, kən nɨkin təməht məmə, “Okəmə ekek əm rəhan kot, kən rəhak nɨmɨsən otol namnun.” Kən tol nəhlan, təmuwa maliwək muarisɨg-in ilat, mɨsɨ-pən e məntaa Iesu ikɨn, kən mea-pən mek rəhan kot. ");
INSERT INTO tnn_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nian təmek kot rəha Iesu nəhlan, kən roiu mɨn əm rəhan nɨmɨsən təmətul, kən təməto əm e nɨpətɨn məmə in tɨnəwɨr. ");
INSERT INTO tnn_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Kən roiu mɨn əm, Iesu təməto məmə nəsanənən məsɨn təmiet lan, kən təmeirair matətapəh məmə, “?Pah təmek rəhak kot?” ");
INSERT INTO tnn_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kən məto rəhan mɨn netəmim kotəmə, “Ei, əplan-tu. Netəmim koatɨləs-pɨkən-ləs-pɨkən pɨk ik. ?Tahro nakatən nulan məmə, ‘pah təmek io’?” ");
INSERT INTO tnn_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Məto Iesu təmategəs-in məmə otehm-tu məmə pah təmek. ");
INSERT INTO tnn_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kən əmun pətan apon tɨnɨtun məmə nian in təmek kot rəha Iesu, rəhan nɨmɨsən tɨnɨkə. Tol nəhlan, mɨnatəgɨn mətasiəp-asiəp muwa meiuaiu mɨsin-pən nulɨn o Iesu matən-ipən natɨmnat rafin kəm in. ");
INSERT INTO tnn_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kən Iesu təmən-ipən kəm in məmə, “Nətɨk pətan, e rəham nahatətəən, nɨnuwa mɨnəwɨr. Kən atuwɨn, pəs nəməlinuən rəha Uhgɨn tətatɨg ron ik. !Rəham nɨmɨsən tɨnɨkə!” ");
INSERT INTO tnn_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nian Iesu təmatəghat əh kəm pətan un, kən netəmim neen kəmotɨsɨ-pən əpəh ima Jaeras ikɨn motuwa motən-ipən kəm Jaeras məmə, “Rəham pətan əkəku tɨnɨmɨs rəkɨs. Əsəlɨkiamtəən iəgətun.” ");
INSERT INTO tnn_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Məto Iesu təməsətəlɨg-inən rəhalat nəghatən, kən mən-ipən kəm Jaeras məmə, “Əsəgɨnən, məsolən nɨkim tərat. Ahatətə əm lak.” ");
INSERT INTO tnn_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kən Iesu təmən-iəhau netəmim məmə okəsotuarisɨg-inən ilau, kən mit əm Pita ne Jemes ne pian Jon motuwɨn. ");
INSERT INTO tnn_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kən kəmotuwɨn əpəh ima Jaeras ikɨn motəplan netəmim tepət kəmotuwa motasək moatəun-əun. ");
INSERT INTO tnn_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Kən Iesu təmuwɨn əpəh imə mən-ipən kəm ilat məmə, “?Nakotagət pɨk nulan o naka? ?Kən motasək pɨk o naka? Pətan əkəku u təsɨmɨsən, tətapɨl əm.” ");
INSERT INTO tnn_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kən netəmim kəmotalah-əmnu. Məto Iesu tahl-iarəp ilat məmə okotiet motuwɨn əpəh ihluə. Kən mit əm rəhan etəmim miləhal ne mama ne tata rəha pətan əkəku un motuwɨn əpəh pətan əkəku un tatəməhl ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kən Iesu təmos nelmɨn, mən e rəhalat nəghatən məmə, “Talita kum,” nɨpətɨ nəghatən un təmə, “!Pətan əkəku, iatən-ipɨnə kəm ik məmə onakətul!” ");
INSERT INTO tnn_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kən roiu mɨn əm, pətan əkəku apon təmətul mɨnataliwək. (Pətan əkəku un tɨnos nup tuelef.) Nian netəmim kəmotəplan nat un Iesu təmol, kən narmɨlat təmiwɨg pɨk ron. ");
INSERT INTO tnn_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kən Iesu təmən-ipən əskasɨk kəm netəm mɨn un məmə, “Onakəsotən-iarəpən nat un kəm suah kit.” Kən matɨg mən-ipən mɨn kəm ilat məmə okotos-ipən nagwənən kit kəm pətan əkəku un tun. ");
INSERT INTO tnn_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesu təmiet ikɨn-un kən rəhan mɨn netəmim kəmotətəu-pən motuwɨn əpəh iman ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kən e nian rəha Sapat, Iesu tuwɨn əpəh e nimə rəha nuəfɨmɨnən matəgətun netəmim. Kən netəmim tepət itəm kəmotəto rəhan nəghatən, kəmotaut pɨk ron motəmə, “?Ei nəman, kəruru məmə suah əpəh təməmɨk hiə natɨmnat mɨn əpəh? ?Kəruru məmə təmahrenatɨg nəhlan? ?O kəruru məmə təmahrol nəhlan matol nat pɨspɨs mɨn əpəh? ");
INSERT INTO tnn_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kitat kotɨtun əm məmə suah əh iol əm nimə. In netɨ Meri, pia Jemes, Joses, Jutas ne Saimon. Kən kitat rəhan kaka mɨn kotatɨg.” Kən nɨkilat təsagienən ron kən motəuhlin məntaalat ron. ");
INSERT INTO tnn_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Məto Iesu təmə, “Ien rəha Uhgɨn katɨsiai-in pɨk ikɨn mɨn rafin. Məto rəhan mɨn əm, ne netəm iman ikɨn kəsotɨsiai-inən.” ");
INSERT INTO tnn_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kən ikɨn əh, okol təsolən nat pɨspɨs kit ikɨn, məto rəhan əmun, tɨtun nələhəu-pənən nelmɨn e netəm koatɨmɨs neen, kən kotəmegəh mɨn. ");
INSERT INTO tnn_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kən Iesu narmɨn təmiwɨg pɨk o netəm iman ikɨn məto-inu kəsotolkeikeən məmə okotən nɨpahrienən lan. Kən təmaliwək muwɨn latuənu mɨn rafin, matəgətun netəmim. ");
INSERT INTO tnn_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kən matɨg maun-in mɨn rəhan netəm tuelef kotuwa ron, kən mahl-ipən ilat keiu-keiu. Təmos-ipən nəsanənən kəm ilat o nəhg-iarəpən narmɨn rat mɨn e netəmim. ");
INSERT INTO tnn_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Kən mən-ipən nəghatən u kəm ilat məmə, “Onəkəsotosən nat kit e rəhatəmat naliwəkən, məto onəkotos əm kasɨkɨn rəhatəmat. Onəsotosən məni kit e paos rəhatəmat, kən məsotosən pɨret, o kətɨm, o nat kit. ");
INSERT INTO tnn_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Onəkotuwɨn e put, məto onəsotosən sot kəiu. ");
INSERT INTO tnn_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Okəmə onəkotuwɨn əpəh ima suah kit ikɨn, kən otapɨl əm e rəhan nimə motatɨg kətatɨg kətoarus motiet latuənu əh. ");
INSERT INTO tnn_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kən okəmə onəkotuwɨn e latuənu kit, məto netəmim neen kəsotolkeikeən məmə okotit itəmat nakotuwɨn e rəhalat nɨpəgnoa nimə, o kəsotətəlɨg-inən rəhatəmat nəghatən, kən nian nəkoatiet e rəhalat latuənu, nəkotəkəike motohapɨspɨs rəkɨs nɨsɨp e nelkɨtəmat məmə ilat okotɨtun məmə nəmotəuhlin-pən məntaatəmat olat.” ");
INSERT INTO tnn_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kən kəmotiet motuwɨn motən-ipən kəm netəmim məmə okotəuhlin nətəlɨgən rəhalat, motapəs pahrien nolən rat mɨn, kən motuwɨn o Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Kən motəhg-iarəp narmɨn rat mɨn tepət e netəmim, kən motol-pən oel e netəm mɨn u koatɨmɨs, kən motol-wɨr ilat. ");
INSERT INTO tnn_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kən Kig Herot Antipas təməto nəghatən rəha Iesu tɨnuwɨn mɨnapakol e nɨtən mɨn rafin. Kən netəmim neen kotəmə in Jon Baptais əpəh tɨnaiir-pa mɨn mol tatos nəsanənən o nolən nat pɨspɨs mɨn. ");
INSERT INTO tnn_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Məto netəmim neen mɨn kotəmə in Elaija, neen mɨn kotəmə ien kit rəha Uhgɨn məto tahmen e ien mɨn rəha Uhgɨn aupən. ");
INSERT INTO tnn_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Məto Kig Herot Antipas təməto, kən məmə, “Jon Baptais əpəh emətatɨp rəkɨs rəhn-kapə, məto tɨnəmegəh mɨn.” ");
INSERT INTO tnn_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Kig Herot Antipas təmən nəhlan məto-inu in təmol nat kit təsahmenən. Pian Filip təmatit pətan kit nərgɨn un Herotias mioal marɨt, kən Kig Herot Antipas tit-irəkɨs pətan un ron mioal marɨt. Kən Jon təmatən-ipən kəm in məmə, “Nakatərəkɨn Lou. Təsahmenən məmə onakit pətan rəha piam.” Kən Herotias təməto nəghatən un kən metəhau Jon ron, kən molkeike məmə okohamnu, məto kəp. Kig Herot Antipas təmolkeike məmə otol rəhan pətaguɨhl nɨkin tagien, kən mahl-ipən rəhan mɨn netəmim kotuwɨn motaskəlɨm Jon kəlis ətain, kən kɨləs kan kɨləs-ipən e kalapus. ");
INSERT INTO tnn_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Məto Kig Herot Antipas tatɨsiai-in Jon mɨtun məmə in etəm asim, kən in etəm ətuatɨp kit mol tatehm wɨr kən məsohamnuən. Nian tepət təto nəghatən rəha Jon, kən tɨnəruru əfəməh, məto tolkeike məmə otatətəlɨg-in. ");
INSERT INTO tnn_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Matuwɨn matuwɨn Herotias tɨnos rəhn matɨp Jon e nian kəmatol lafet lan rəha Kig Herot Antipas e nian təmaiir lan. Kig təmaun-in rafin netəm-iasol rəhan mɨn, ne netəm-iasol rəha rəhan mopael mɨn, ne netəm-iasol rəha netəm Kalili, məmə okotuwa motehm motagwən. ");
INSERT INTO tnn_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kən e nian əh, pətan əkəku un netɨ Herotias təmuwa imə matol tanis e nɨganəmtɨlat. Kəmotəplan təmol tanis kən nɨkilat təmagien pɨk ron. Kən kig apon təmən-ipən kəm pətan əkəku apon məmə, “Okəmə nakolkeike naka, nakətapəh-in ron io, kən ekos-ipɨnə kəm ik.” ");
INSERT INTO tnn_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","In təmən-iəkɨs kən mos noanawɨl ron məmə, “Nat naka nakolkeike kən measiə-in ron io, ekos-ipɨnə. Nat əpnapɨn okəmə iahgin tahmen e nɨpɨlga rəhak natɨmnat, məto ekəike mos-ipɨnə.” ");
INSERT INTO tnn_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kən pətan əkəku apon təmuwɨn əpəh ihluə matətapəh o rəhan mama məmə, “?Mama, oekeasiə-in naka o kig?” Məto rəhan mama təmə, “Uwɨn measiə-in rəhn-kapə Jon Baptais.” ");
INSERT INTO tnn_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kən pətan əkəku apon təmaiu ueiuəhai əm muwɨn əpəh imə o kig kən məmə, “Ekolkeike məmə onakɨləs-ipa rəhn-kapə Jon Baptais u-roiu agɨn, kəmələhəu-pən e pɨlet kit.” ");
INSERT INTO tnn_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kən nat un təmol kig nɨkin tahmə pɨk, məto okol təsapəsən, məto-inu tɨnəmos rəkɨs noanawɨl e nɨganəmtɨ netəmim u kəmotuwa o lafet. ");
INSERT INTO tnn_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kən mahl-ipən rəhan kit mopael məmə otaiu əm muwɨn mɨləs rəhn-kapə Jon Baptais muwa. Kən mopael apon təmuwɨn əpəh e kalapus kən mətatɨp-rəkɨs rəhn-kapə Jon Baptais, ");
INSERT INTO tnn_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","kən mələhəu-pən e pɨlet kit mɨləs muwa, kən mɨləs-ipən kəm pətan əkəku apon, kən tɨləs muwɨn kəm rəhan mama. ");
INSERT INTO tnn_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nian netəmim mɨn rəha Jon Baptais kəmotəto netəmim kəmotamnus nat un kəmol e Jon, kən kotuwa motɨləs nɨpətɨn motuwɨn motɨtənɨm e nɨpəg kəpiel rəha nolən suwɨt. ");
INSERT INTO tnn_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Kən aposol mɨn rəha Iesu kəmotɨtəlɨg-pa mɨn ron, kən motən-ipən natɨmnat rafin itəm kəmotol, ne nəghatən mɨn itəm kəmotəgətun netəmim lan. ");
INSERT INTO tnn_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Məto netəmim tepət koatuwa moatuwɨn moatiet moatuwɨn, kən Iesu ne rəhan mɨn netəmim kɨnotəruru nagwənən ne namegən ne. Kən Iesu tən-ipən kəm ilat məmə, “Pəs-tu kotuwɨn-tu əpəh ikɨn kit netəmim kotɨkə ikɨn, kən nakotameg məsɨn.” ");
INSERT INTO tnn_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kən ilat əm motuwɨn e pot kit mɨnotuwɨn əpəh netəmim kotɨkə ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Məto netəmim tepət kəmotəplan ilat nian kəmotiet, kən motɨtun ilat. Kən kəmotiet e latuənu mɨn motaiu kaupən-in ilat, motuwɨn əpəh koatuwɨn ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nian Iesu təmuwar e pot məplan nɨmanin netəmim tepət kɨnəmotuwa rəkɨs, kən təmasəkitun ilat, məto-inu kotahmen əm e sipsip mɨn itəm etəmim tɨkə o nehmən ilat. Kən təmətul matəgətun ilat e natɨmnat tepət. ");
INSERT INTO tnn_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tɨnehnaipən, kən netəmim rəha Iesu kəmotuwa motən-ipən kəm in məmə, “Tɨnətalugɨn, kən ikɨn-u kəsatɨgən ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Təwɨr məmə onakahl-ipən-ta netəmim koatuwɨn əpəh e latuənu mɨn, ne əpəh ikɨn mɨn, məmə okotos-nəmtɨn nɨgɨlat nagwənən.” ");
INSERT INTO tnn_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Məto in təmən-ipən kəm ilat məmə, “Kəp, itəməhal əm. Nakəhlagwən netəm mɨn əh.” Məto kotəmə, “!Naka! ?Nakəmə oekotuwɨn motərakin məni asol agɨn u tu-hanrɨt tenarius o nosən pɨret lan o nagwənən nɨmanin netəmim u?” ");
INSERT INTO tnn_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Məto Iesu təmə, “?Nakoatos pɨret kuwəh? Otuwɨn motehm.” Kəmotuwɨn motehm motəmə, “Pɨret faif, kən nəm kəiu.” ");
INSERT INTO tnn_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kən Iesu tən-ipən kəm rəhan mɨn netəmim mə okotol netəmim kotəpələh e manuwɨhl amiəmɨtə fifti fifti ne uan-hanrɨt uan-hanrɨt, ");
INSERT INTO tnn_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","kən kəmotəpələh nəhlan fifti fifti ne uan-hanrɨt uan-hanrɨt. ");
INSERT INTO tnn_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kən Iesu təmos pɨret faif ne nəm mil u kəiu, kən mətag-pər əpəh e neai məfak ron, kən məmkas pɨret un məmki-pən kəm rəhan mɨn netəmim məmə okotoor kəlɨn kəm netəmim. Kən matɨg mos mɨn nəm mil u kəiu məmkas moor kəm netəmim. ");
INSERT INTO tnn_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kən netəmim rafin kəmotun nərpɨlat tasis, ");
INSERT INTO tnn_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","kən motapəs nɨmɨsmɨsɨ pɨret un ne nəm mil un, kən netəmim mɨn rəha Iesu kotaii-pən e kətɨm asol tuelef kotər wɨr. ");
INSERT INTO tnn_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Kən netəm mɨn u kəmotagwən, nəman elat kotahmen e faif-taosan. ");
INSERT INTO tnn_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kən roiu agɨn-əh mɨn, Iesu təmən-ipən kəm rəhan mɨn netəmim məmə okotɨləs pot kit motaupən motuwɨn entənɨpən-pən əpəh ikɨn kit nərgɨn u Petsaeta, məto in otatɨg mahl-ipən paupən netəmim koatuwɨn iməlat mɨn ikɨn-u panuwɨn. ");
INSERT INTO tnn_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nian tɨnauiatɨpin rəkɨs netəmim, mahl-ipən ilat koatuwɨn, kən muwɨn əpəh e nɨtot məmə otəfak. ");
INSERT INTO tnn_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kən tɨnətalugɨn, pot tɨnuwɨn əpəh ilugɨn ətuatɨp əpəh e lek, məto Iesu tətan pɨsɨn əm əpəh ipar. ");
INSERT INTO tnn_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kən məplan ilat kotasuə kɨtasuə məto kɨnotəpou məto-inu nɨmətag tatoh ilat. Kən tɨnatian-ian, kən taliwək e nətuei nəhau matuwa. Təmaliwək muwa, iuəhkɨr əm taprəkɨs-in ilat. ");
INSERT INTO tnn_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Kən nian netəmim mɨn rəha Iesu kəmotəplan taliwək e nətuei nəhau matuwa, kən nɨkilat təht məmə narmɨ suah kit. Kən ilat rafin kəmotəplan, kən motəgɨn katearɨg əfəməh. Məto roiu agɨn-əh əm, Iesu təmən-ipən kəm ilat məmə, “!Ei, nɨkitəmat tətul məha-məha. Io u inu. Sotəgɨnən!” ");
INSERT INTO tnn_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kən muwɨn e pot məplan ilat moatəpələh, kən nɨmətag təmurahl nelmɨn, kən kəmotaut pɨk ron, ");
INSERT INTO tnn_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","məto-inu rəhalat-kapə tiəkɨs. Kəmotəplan pap Iesu təmagwən netəmim tepət e pɨret noan məsɨn əm, məto ilat kotəruru əh məmə in pah. ");
INSERT INTO tnn_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kəmotuwɨn entənɨpən-pən motuwar əpəh ikɨn kit nərgɨn u Kenesaret, kən motietain pot ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nian kəmotuwar ikɨn əh, netəm ikɨn kəmotɨtun ueiuəhai əm məmə in Iesu. ");
INSERT INTO tnn_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kən kəmotaiu motuwɨn əpəh latuənu mɨn moatən-ipən kəm netəmim. Kən nian kotəto məmə Iesu əh-ikɨn əh, koatəmɨk netəm koatɨmɨs e rəhalat pet motuwa ron. ");
INSERT INTO tnn_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kən ikɨn mɨn rafin Iesu tatuwɨn-pən ikɨn e latuənu əlkələh, ne latuənu asol mɨn, ne ikɨn mɨn rafin tɨtəlau, netəmim kotəmɨk netəm koatɨmɨs motiet katəlɨn əm ilat əpəh maket ikɨn. Kən kəmoatəkəike katən-ipən kəm Iesu məmə otegəhan-in ilat kotek əm nɨpəgnəmtɨ rəhan kot. Kən netəmim rafin u kəmotek rəhan kot, kən motəwɨr e rəhalat nɨmɨsən. ");
INSERT INTO tnn_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Kən Farisi mɨn ne iəgətun neen rəha Lou, kəmotɨsɨ-pən əpəh Jerusalem, motuwa moatəpələh ilat Iesu. ");
INSERT INTO tnn_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Kən kəmotəplan məmə netəmim mɨn rəha Iesu kəmotagwən kən məsotaikuas wɨrən e nelmɨlat e nolən rəha Farisi mɨn. ");
INSERT INTO tnn_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farisi mɨn, ne netəm Isrel tepət, kəmoatətəu-pən ətuatɨp kastom rəha tɨpɨlat nuwəh mɨn. Okəmə kəsotaikuas wɨrən e nelmɨlat un, kən kəsotagwənən. ");
INSERT INTO tnn_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kən nian koatɨsɨ-pən e maket moatuwa, məsotagwənən pitən, motaupən kaikuas e nelmɨlat kən panotagwən. Kən moatətəu-pən natɨmnat tepət mɨn nəhlan itəm kəmotos o tɨpɨlat nuwəh mɨn. Kən kastom ətuatɨp əh-ikɨn rəha naikuasən e sospən, ne panɨkɨn, ne pesɨn u kəmol e iaen. ");
INSERT INTO tnn_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kən inu Farisi mɨn ne iəgətun mɨn rəha Lou kotətapəh o Iesu məmə, “?Tahro rəham mɨn netəmim kəsotətəu-pənən kastom rəha tɨpɨtat nuwəh mɨn? ?Tahro kəsotaupənən motaikuas pitən e nelmɨlat u panotagwən?” ");
INSERT INTO tnn_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Məto Iesu təmən-ipən kəm ilat məmə, “Aupən Aesea təmən-iarəp nəghatən rəha Uhgɨn kən məht ətuatɨp itəmat lan u rəhatəmat nənən təwɨr, məto nɨkitəmat tamkɨmɨk. In təmən məmə, ‘Uhgɨn təmə netəm mɨn u kotɨsiai-in io e nəghatən əm rəhalat, məto nɨkilat tətan-pən əh əpəh isəu. ");
INSERT INTO tnn_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Motəfak kəm io o nat əpnapɨn əm məto-inu ilat kotəgətun netəmim e lou itəm etəmim əm təmol motəmə lou rəha Uhgɨn, məto kəp.’” ");
INSERT INTO tnn_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kən Iesu təmən mɨn kəm ilat məmə, “Itəmat nakotapəs Lou rəha Uhgɨn moatətəu-pən əm kastom rəha etəmim.” ");
INSERT INTO tnn_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kən mən-ipən kəm ilat məmə, “Nakotausit pɨk o nolən apon rəhatəmat məmə nakotapəs Lou rəha Uhgɨn kən motətəu-pən atɨp əm kastom rəhatəmat. ");
INSERT INTO tnn_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses təmən məmə, ‘Onakɨsiai-in rəham tata ne mama. Okəmə suah kit tatəghat rat e rəhan tata ne mama, okəike kohamnu.’ ");
INSERT INTO tnn_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Məto itəmat nakotən məmə, suah kit okəmə tapəs nasituən e rəhan tata ne mama kən mən-ipən kəm ilau məmə, ‘Rəhak u nat u ekəmə ekasitu etəlau lan, məto emələhəu əm məmə rəha Uhgɨn. Kən nat katos-ipən kəm Uhgɨn okol kəsol mɨnən nat kit lan.’ ");
INSERT INTO tnn_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kən motatɨg moatən-iəhau mɨn o nasituən e rəhan tata ne mama. ");
INSERT INTO tnn_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Məto e nolən əh, nakotəgətun netəmim e rəhatəmat kastom motol nəghatən rəha Uhgɨn tatol əm nat əpnapɨn lan. Kən natɨmnat mɨn tepət mɨn nəhlan itəmat nəkoatol.” ");
INSERT INTO tnn_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kən Iesu təmaun-in nɨmanin netəmim məmə okotuwa iuəhkɨr ron kən məmə, “Otətəlɨg-in wɨr-tu io məmə nəkotɨtun. ");
INSERT INTO tnn_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nat etəmim tatərge təsolən etəmim tamkɨmɨk e nɨganəmtɨ Uhgɨn, məto nat tatiet e nɨki etəmim tatol etəmim tamkɨmɨk e nɨganəmtɨ Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nian Iesu təmiet e nɨmanin netəmim un kən muwɨn əpəh imə, kən rəhan mɨn netəmim kotətapəh o nɨpətɨ nəghatən mɨn un kəm in. ");
INSERT INTO tnn_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Kən Iesu təmən-ipən kəm ilat məmə, “Okəmə naka itəmat mɨn rəhatəmat-kapə tɨkə. Onəkotəkəike motɨtun məmə natɨmnat itəm etəmim tatərge in tahmen əm e nat ihluə təsolən etəmim tərat e nɨganəmtɨ Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Məto-inu tərge kən təsuwɨnən e nɨkin, məto tatuwɨn e tɨpəin u, kən matiet mɨn.” (E nəghatən əh Iesu təmən-iarəp məmə nagwənən rafin katun təwɨr e nɨganəmtɨ Uhgɨn.) ");
INSERT INTO tnn_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kən məmə, “Məto nat itəm tatiet e nɨki etəmim, in tol etəmim tətamkɨmɨk e nɨganəmtɨ Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Məto-inu nɨki etəmim tatəht natɨmnat tərat tepət, ilat u: nɨpɨtan ne nəman ne, koatit anion ilat mɨn; nakləhən; nohamnuən itəm; ");
INSERT INTO tnn_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nakləh-inən pətan rəha suah pɨsɨn; naumɨsən o natɨmnat; nolən rat mɨn; neiuəən; nolən rəha nit əpnapɨn əmən nɨpɨtan ne nəman; netetən; nənən nɨkal itəm; nausitən; nalmələn. ");
INSERT INTO tnn_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nolən rat mɨn əh, ilat əh kotɨsɨ-pən e nɨki netəmim kən motol ilat kotamkɨmɨk e nɨganəmtɨ Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","26","Kən Iesu təmiet ikɨn-un kən məsou pəhap muwɨn əpəh Fonisia, ima Iaihluə mɨn e nɨtən rəha Siria, mətatɨg e nimə kit iuəhkɨr o taon u Taea, matəhluaig məsolkeikeən məmə netəmim okotɨtun məmə in tətatɨg əh-ikɨn əh, məto okol təsəhluaigən. Məto pətan kit əh-ikɨn, narmɨn rat tətatɨg e rəhan pətan əkəku. Pətan un təmaiir ikɨn əh, kən in təsəfakən, in Iaihluə. (Netəm Isrel kotəmə Iaihluə mɨn kotahmen e kuri.) Nian təməto natɨmnat wɨr mɨn itəm Iesu tatol ilat, kən tasək muwa mɨsin-pən nulɨn ron məmə otəhg-iarəp narmɨn rat e rəhan pətan əkəku. ");
INSERT INTO tnn_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Məto Iesu təmə, “Kəpə. Pəs kaupən kagwən nɨsualkələh. Təsəwɨrən məmə okərakin-pən nagwənən nɨgɨ nɨsualkələh kəm kuri mɨn.” ");
INSERT INTO tnn_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Məto pətan u təmə, “Nɨpahrienən etəm-iasol, məto kuri mɨn koatun əm nɨmɨsmɨsɨ nagwənən nɨgɨ nɨsualkələh itəm kotɨsas-pən e nɨpəg tepɨl.” ");
INSERT INTO tnn_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kən Iesu təmən-ipən ron məmə, “Məto-inu nəmuhalpɨn wɨr rəhak nəghatən, uwɨn-tu əpəh imam ikɨn məplan narmɨn rat tɨniet rəkɨs e rəham pətan əkəku.” ");
INSERT INTO tnn_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Pətan u təmaiu muwɨn iman latuənu məplan rəhan pətan əkəku tətapɨl-pər wɨr əm e rəhan pet, kən narmɨn rat tɨniet rəkɨs lan. ");
INSERT INTO tnn_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kən Iesu təmiet ikɨn-un ima netəm Taea kən muwɨn-pən əpəh Saeton matuwɨn əpəh e nəhau Lek Kalili, məto təmuwɨn-pən əpəh Tekapolis ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kən netəmim kəmotit suah kit matəlgɨn talu kən məruru nəghatən motuwa məmə Iesu otələhəu-pən nelmɨn lan pəs təto təwɨr. ");
INSERT INTO tnn_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kən Iesu təmit suah un mian əpəh isəu məsɨn o netəmim, kən mɨləs-ipən noa nelmɨn e matəlgɨn kən magəh nelmɨn mələhəu-pən e namɨ suah un. ");
INSERT INTO tnn_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kən masɨpər əpəh e neai, kən mamegahl ron e rəhan nəghatən məmə, “!Efata!” Nɨpətɨn təmə, “!Əwɨr-ta!” ");
INSERT INTO tnn_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kən əmun suah un tɨnatəto nat, kən namɨn tɨnəwɨr mɨnatəghat wɨr. ");
INSERT INTO tnn_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kən Iesu təmən-iəhau ilat məmə okəsotənən nat un kəm netəmim. Məto nian Iesu təmatəkəike kəm ilat, kən ilat kəmotəkəike kən-iarəp kəm netəmim. ");
INSERT INTO tnn_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kəmotaut pɨk ron motəmə, “Natɨmnat rafin itəm tatol, məto in təwɨr pɨk agɨn. Netəm u matəlgɨlat talu kɨnoatəto nat, ne netəm kotəruru nəghatən kɨnoatəghat.” ");
INSERT INTO tnn_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","E nian kit mɨn netəmim tepət kəmotuwa mɨn ron, kən məto, nɨgɨlat nagwənən tɨnɨkə. Kən Iesu təmaun-in rəhan mɨn netəmim kotuwa kən tən-ipən kəm ilat məmə, ");
INSERT INTO tnn_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nɨkik tɨnahmə pɨk o netəm mɨn əpəh məto-inu, kəmotuarisɨg-in io mɨnotos rəkɨs nian kɨsɨl, kən roiu əh, nɨgɨlat nagwənən tɨnɨkə. ");
INSERT INTO tnn_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Okəmə ekahl-ipən ilat koatuwɨn əh-roiu, kən nɨganəmtɨlat otapɨn e suatɨp, kən sueiuei otoh ilat, məto-inu kəməsotagwənən nuwəh, kən neen kəmotɨsɨ-pən əpəh isəu.” ");
INSERT INTO tnn_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kən rəhan mɨn netəmim kəmotətapəh ron məmə, “?Okəmɨk hiə pɨret tahmen-in nagwənən ilat? Ikɨn-u taruən-aruən ikɨn, netəmim kəsotatɨgən ikɨn.” ");
INSERT INTO tnn_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Kən Iesu təmətapəh olat məmə, “?Nakoatos pɨret kuwəh?” Məto kotəmə, “Sepɨn.” ");
INSERT INTO tnn_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kən təmən-ipən kəm netəmim məmə okotəpələh, kən mos pɨret un məfak matən-ipən tagkiu ron kəm Uhgɨn, kən məmkas mos-ipən kəm rəhan mɨn netəmim məmə okotoor kəlɨn kəm netəmim, kən kəmotol mihin. ");
INSERT INTO tnn_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kən kəmotos mɨn nəm əlkələh neen ka, kən Iesu təfak ron kən mos-ipən mɨn kəm ilat məmə okotoor kəlɨn kəm netəmim. ");
INSERT INTO tnn_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Kən netəm mɨn u Iesu təmagwən ilat kotahmen e fo-tausan, kəmotun nagwənən nərpɨlat tasis, kən kapəs nɨmɨsmɨsɨ nagwənən, kən kaii-pən e kɨpəhau sepɨn kotər. ");
INSERT INTO tnn_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kən Iesu tahl-ipən netəmim koatuwɨn iməlat mɨn ikɨn. Kən ilat rəhan mɨn netəmim kəmotuwɨn e pot kan əpəh e nɨtən Talmanuta. ");
INSERT INTO tnn_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kən Farisi mɨn neen kəmotuwa o Iesu moatərgəhəu kəm in motən-ipən kəm in məmə otol-tu nəmtətin asol kit pəs kotɨtun məmə in təmɨsɨ-pən pahrien o Uhgɨn, o kəp. ");
INSERT INTO tnn_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kən Iesu nɨkin təməpou, kən mamegahl ron kən məmə, “?Karmə tahro netəm mɨn u-roiu ne kotəmə okotəplan-tu nəmtətin kit? Məto iatən pahrien kəm itəmat məmə okol kəsolən nəmtətin kit kəm itəmat.” ");
INSERT INTO tnn_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kən mapəs ilat motuwɨn e pot kan əpəh e nɨkalɨ nəhau lek entənɨpən-pən. ");
INSERT INTO tnn_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Rəhan mɨn netəmim kəmotaluin nəmɨkən pɨret məto kəmotos əm kitiəh əm motuwɨn e pot. ");
INSERT INTO tnn_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Kən Iesu təmatəhag kəm ilat məmə, “Otehm wɨr itəmat o is rəha Farisi mɨn ne is rəha Herot Antipas.” ");
INSERT INTO tnn_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kən kəmotən-ipən kəm ilat mɨn məmə, “Tatən nəhlan məto-inu kəməsotəmɨkən pɨret.” ");
INSERT INTO tnn_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Kən məto Iesu tɨnɨtun rəhalat nətəlɨgən kən mən məmə, “?Tahro nakoatən nəghatən əh məmə nəməsotəmɨkən pɨret? ?Tahro itəmat nəkəsotehmən əh kən məsotɨtunən əh? !Rəhatəmat-kapə tiəkɨs! ");
INSERT INTO tnn_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nɨganəmtɨtəmat u ikɨn. ?Tahro nəkəsotehmən nat? Kən matəlgɨtəmat u ikɨn. ?Tahro nakəsotətoən nat? Ekɨtun məmə okəmə naka nɨnəmotaluin natɨmnat itəm kɨnotuwa rəkɨs. ");
INSERT INTO tnn_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","?Nian emos pɨret əh faif məmkas mos-ipən kəm netəmim mɨn əpəh faif-tausan kotun, kən uarisɨg nəmotaii-pən nɨmɨsmɨsɨn e kətɨm asol kuwəh?” Məto kotəmə, “Tuelef.” ");
INSERT INTO tnn_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Kən təmətapəh mɨn olat məmə, “?Kən nian emos pɨret əh sepɨn məmə ekos-ipən kəm netəm mɨn əpəh fo-tausan kotun, kən uarisɨg nəmotaii-pən nɨmɨsmɨsɨn e kətɨm asol kuwəh?” Məto kotəmə, “Sepɨn.” ");
INSERT INTO tnn_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kən təmatətapəh olat məmə, “?Məto itəmat nəkotəruru əh io?” ");
INSERT INTO tnn_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kən kəmotuwar əpəh ikɨn kit katən məmə Petsaeta, kən netəm ikɨn kəmotit suah kit nɨganəmtɨn təməpɨs motuwa kən kətasək ahgin Iesu məmə otələhəu-pən nelmɨn lan. ");
INSERT INTO tnn_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kən Iesu təmos nelmɨ suah un mian isəu məsɨn o latuənu kən tagəh nɨganəmtɨ suah un kən mələhəu-pən nelmɨn mil lan, kən mətapəh ron məmə, “?Nɨnɨtun nehmən nat o kəp?” ");
INSERT INTO tnn_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Məto suah un təmasɨpər kən məmə, “Ekatəplan netəmim məto kotahmen əm e nɨg mɨn məto in əmun kotaliwək.” ");
INSERT INTO tnn_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kən Iesu təmatɨg mələhəu-pən mɨn nelmɨn mil e nɨganəmtɨ suah un, kən tɨnɨtun nəplan wɨrən natɨmnat mɨnapəs noapoapən. ");
INSERT INTO tnn_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Kən Iesu təmahl-ipən məmə otatuwɨn iman ikɨn məto təmən-iəhau məmə otəsuwɨn-pənən əh latuənu əh-ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Kən Iesu ne rəhan mɨn netəmim kəmotiet motəsou pəhap motuwɨn e latuənu mɨn u iuəhkɨr o nat əpəh Sisaria Filipae. Nian kəmoatuwɨn e suatɨp kən tatətapəh olat məmə, “?Otən-tu məmə netəmim kotəmə pah u io?” ");
INSERT INTO tnn_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Məto rəhan mɨn netəmim kotəmə, “Netəmim neen kotəmə ik Jon Baptais. Neen mɨn kotəmə ik Elaija. Neen mɨn kotəmə ik ien kit rəha Uhgɨn aupən.” ");
INSERT INTO tnn_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Kən təmətapəh olat məmə, “?Məto itəmat nakotəmə pah u io?” Kən Pita təmə, “Ik Mesaea ilouin, itəm Uhgɨn təmən məmə otəpanahl-ipa.” ");
INSERT INTO tnn_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Kən Iesu təmən-iəhau əskasɨk ilat məmə, okəsotən-iarəpən in kəm suah kit. ");
INSERT INTO tnn_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kən təmatəgətun ilat kən matən məmə, “Io Netɨ Etəmim oepanəto nahməən o natɨmnat tepət. Netəm-iasol rəha netəm Isrel, ne pris asol mɨn, ne iəgətun mɨn rəha Lou okotetəhau io, kən motohamnu io, məto oekos nian kɨsɨl un, kən panəmegəh mɨn.” ");
INSERT INTO tnn_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Təmən wɨr pap kəm ilat, məto Pita təmit Iesu mian əpəh e nɨkalɨ suatɨp kən matən-iəhau əskasɨk məmə otəsəghatən nəhlan. ");
INSERT INTO tnn_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Kən məto Iesu təmasɨpən məplan rəhan mɨn netəmim, kən mən-ipən kəm Pita məmə, “!Ik iərmɨs Setan asol, agɨm muwɨn isəu lak! Rəham nətəlɨgən sənəmə rəha Uhgɨn, məto rəha etəmim əm.” ");
INSERT INTO tnn_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kən Iesu təmaun-in rafin netəmim ne rəhan mɨn netəmim məmə okotuwa ron, kən təmən məmə, “Okəmə suah kit təmə otuarisɨg-in io, otəkəike maluin atɨp in, kən mɨləs rəhan nɨg kəməluau muarisɨg-in io. ");
INSERT INTO tnn_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Etəmim itəm tolkeike məmə otosmegəh rəhan nəmegəhən e nətueintən u, kən otakiəh e rəhan nəmegəhən lilɨn. Məto etəm otɨmɨs ron io ne Namnusən Təwɨr rəhak, in otos nəmegəhən lilɨn. ");
INSERT INTO tnn_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","?Okəmə etəmim kit tatos rafin natɨmnat e nətueintən, məto uarisɨg lan otɨmɨs kən təsosən nəmegəhən lilɨn, in təmol win e nat kit təwɨr, o kəp? Kəp. ");
INSERT INTO tnn_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Okol suah əh təsos-ipənən nat kit kəm Uhgɨn məmə Uhgɨn otos-ipən nəmegəhən lilɨn kəm in. ");
INSERT INTO tnn_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Netəm kotaulɨs-in nən-iarəpən io ne rəhak nəghatən kəm netəm kotapəs nəfakən motol təfagə rat, kən o nian io Netɨ Etəmim oekuwa lan, io mɨn oekaulɨs-in nənən məmə ilat u rəhak mɨn netəmim. O nian əh oekuwa itɨmat nagelo asim mɨn e nepətən əhag-əhag asol rəha rəhak tata.” ");
INSERT INTO tnn_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kən Iesu təmən məmə, “Ekatən pahrien kəm itəmat məmə, itəmat neen u nəkoatətul u ikɨn-u roiu, okol kəsotɨmɨsən mətoahgin kotəplan nərəmərəən rəha Uhgɨn otuwa e nəsanənən asol.” ");
INSERT INTO tnn_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kən nian sikis kɨnotuwa mɨnotuwɨn rəkɨs, kən Iesu tit Pita, Jemes, ne Jon, kən iləhal pɨsɨn əm kəhaluarisɨg-in motuwɨn əpəh e nɨtot əfəməh kit, kən ilat pɨsɨn əm əh-ikɨn. Kən kəməhaləplan nɨpətɨ Iesu təmol pɨsɨn. ");
INSERT INTO tnn_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Rəhan napən təmuwa məruən matɨpɨt-ɨpɨt, okol suah kit təsaikuasən e nɨməhan kit təruən min-nəhlan. ");
INSERT INTO tnn_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kən suah miləhal apon kəməhaləplan Elaija ne Moses kəmiaet-arəpa mətəhaləghat iləhal Iesu. ");
INSERT INTO tnn_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kən Pita təmən-ipən kəm Iesu məmə, “Iəgətun, təwɨr məmə ekəhaluwa ikɨn-u. Pəs məhalol makeen kɨsɨl, rəham kit, rəha Moses kit, kən rəha Elaija kit.” ");
INSERT INTO tnn_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita tɨnatəghat əpnapɨn əm məto-inu kɨnəhaləgɨn pɨk matəhlasiəp. ");
INSERT INTO tnn_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kən napuə təmuwa malpin ilat, kən kəmotəto nəwia suah kit təmɨsɨ-pən əpəh e napuə məmə, “Inu netɨk keike u ekolkeike pɨk. Onakəhaləkəike məhalətəlɨg-in in.” ");
INSERT INTO tnn_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kən roiu agɨn-əh mɨn, kəməhaleirair, məto kɨnəsəhaləplanən suah mil un, məto kəməhaləplan əm Iesu tatətul ilat min iləhal. ");
INSERT INTO tnn_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nian kəmoateiuaiu e nɨtot un kan əpəh ləhau, kən Iesu təmən-iəhau əskasɨk iləhal məmə, “Natɨmnat un nəməhalehm əpəh ilis e nɨtot, onəsəhalənən kəm suah kit məhalətoarus-pən io Netɨ Etəmim oekəmegəh mɨn e nɨmɨsən.” ");
INSERT INTO tnn_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kən iləhal kəməhalɨsiai-in nəghatən rəha Iesu, məto kəmatəhalən əm kəm iləhal mɨn məmə, “Nəghatən əh təmən məmə otəmegəh mɨn e nɨmɨsən, kəruru məmə nɨpətɨn təmə naka.” ");
INSERT INTO tnn_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kən kəməhalətapəh o Iesu məmə, “?Tahro iəgətun mɨn rəha Lou kotəmə Elaija otəkəike maupən muwa?” ");
INSERT INTO tnn_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Kən Iesu təmən-ipən kəm iləhal məmə, “Nɨpahrienən, Elaija otaupən muwa matol-wɨr mɨn natɨmnat rafin. ?Məto tahro Naoa Rəha Uhgɨn təmən məmə io Netɨ Etəmim oepanəto nahməən o natɨmnat tepət, kən netəmim okotəplan io motapəs io? ");
INSERT INTO tnn_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Məto ekatən pahrien kəm itəməhal məmə Elaija tɨnuwa rəkɨs, kən kəmol nat tərat lan tahmen e Naoa Rəha Uhgɨn təmən məmə okəpanol mihin.” ");
INSERT INTO tnn_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nian kəmotɨtəlɨg-pa mɨn, motehm netəmim neen mɨn rəha Iesu, məto nɨmanin netəmim kəmotɨtəlau elat, kən iəgətun neen rəha Lou ne netəmim mɨn rəha Iesu kotərgəhəu. ");
INSERT INTO tnn_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nian netəmim kəmotəplan Iesu, narmɨlat təmiwɨg pɨk ron, kən motaiu ka məmə okotəghat kəm in. ");
INSERT INTO tnn_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kən Iesu təmətapəh olat məmə, “?Naka əpəh nakotərgəhəu ron itəmat netəm mɨn əpəh?” ");
INSERT INTO tnn_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Məto netəm mɨn u kit təmə, “Iəgətun, io emit netɨk muwa ron ik məmə onakol-wɨr, məto-inu narmɨn rat kit tətatɨg lan kən mol təruru nəghatən. ");
INSERT INTO tnn_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kən nian narmɨn rat apon taskəlɨm in, kən moh mɨləs-iəhau morin əpəh e nɨsɨp, kən nahuin noan tiet tahmen əm e sop, kən matəgətain nəluɨn, nɨpətɨn tatɨkɨmkɨm. Kən emətapəh o rəham netəmim məmə okotəhg-iarəp narmɨn rat əpəh lan, məto kotəruru nəhg-iarəpən.” ");
INSERT INTO tnn_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Məto Iesu təmə, “Kəsi, itəmat un netəm roiu ne nakəsotahatətəən lak. Karmə oekatɨg kitat min itəmat mətoarus-pən nian naka nəpanotahatətə lak. Kən karmə onəghan epanameg etəmat. Enəpou-in itəmat. !Otɨləs suakəku un motuwa!” ");
INSERT INTO tnn_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kən kəmotɨləs kan o Iesu. Kən narmɨn rat apon təməplan Iesu kən mol suakəku apon taut nɨpətɨn tasiəp-asiəp pɨk, kən miet morin əpəh ləhau e nɨsɨp məsoupəlpəl mətan, kən nahui noan tiet tahmen e sop. ");
INSERT INTO tnn_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Kən Iesu təmətapəh o rəhan tata məmə, “?Təmol min-nəhlan mɨnos nup kuwəh?” Məto rəhan tata təmə, “Təmətuoun e nian təmatəkəku mətoarus-pa əh-roiu. ");
INSERT INTO tnn_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kən nian tepət narmɨn rat əh toh matɨləs-ipən əpəh e nɨgəm ne nəhau məmə otohamnu. Okəmə nəkɨtun nolən, pəs nakasəkitun itɨmlau masitu etɨmlau.” ");
INSERT INTO tnn_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Məto Iesu təmə, “?Naka əh, nəghatən u məmə, ‘Okəmə nəkɨtun nolən’? Uhgɨn tɨtun nolən natɨmnat rafin o etəmim itəm tətahatətə lan.” ");
INSERT INTO tnn_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kən roiu agɨn, tata rəha suakəku un təmagət əfəməh məmə, “Ekətahatətə lam, məto in əmun rəhak nahatətəən təkəku əm, asitu lak məmə rəhak nahatətəən otər mepət.” ");
INSERT INTO tnn_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kən nian Iesu təməplan məmə netəmim neen mɨn kɨnotuwa iuəhkɨr ron, kən tən-ipən əskasɨk kəm narmɨn rat apon məmə, “Ik narmɨn rat itəm natol matəlgɨtəm tətalu kən mol itəm katəruru nəghatən. !Ekatən-ipɨnə ətuatɨp u-roiu məmə onakiet e suakəku un, kən məsuwa mɨnən muwɨn lan!” ");
INSERT INTO tnn_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kən narmɨn rat apon təmagət əfəməh mol suakəku apon taut masiəp-asiəp mɨn u iuəhkɨr agɨn tɨmɨs, kən miet lan. Okol nəkəplan məmə tɨnɨmɨs rəkɨs, kən netəmim tepət kotəmə tɨnɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Məto Iesu təmea-pən maskəlɨm nelmɨn miuw-pər, kən tətul. ");
INSERT INTO tnn_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Iesu təmuwɨn imə, kən ilat pɨsɨn əm rəhan mɨn netəmim koatəpələh, kən kotətapəh ron məmə, “?Karmə tahro ekotəruru nəhg-iarəpən narmɨn rat əpəh?” ");
INSERT INTO tnn_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Məto Iesu təmə, “Nəfakən əm tɨtun nəhg-iarəpən narmɨn rat mɨn əh nəhlan.” ");
INSERT INTO tnn_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Kən Iesu ne rəhan mɨn netəmim kəmotiet ikɨn-un kən motuwɨn-pən əpəh e nɨtən Kalili ikɨn, məto Iesu təsolkeikeən məmə okɨtun məmə in əh-ikɨn əh. ");
INSERT INTO tnn_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Təmol nəhlan məto-inu tatəgətun rəhan mɨn netəmim. Təmən məmə, “Io Netɨ Etəmim, okegəhan-in-pən io kəm netəmim kotohamnu io ekɨmɨs. Məto oekos nian kɨsɨl u, kən panəmegəh mɨn.” ");
INSERT INTO tnn_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kən məto rəhan mɨn netəmim kəsotɨtun wɨrən rəhan nəghatən, kən nɨkilat tɨnəgin o nətapəh-inən nɨpətɨ nəghatən rəhan. ");
INSERT INTO tnn_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kəmotiet-pa əpəh Kapaneam, kən mɨnoatuwɨn imə kit. Kən Iesu təmatətapəh olat məmə, “?Naka əpəh nəmoatən e suatɨp?” ");
INSERT INTO tnn_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Məto kɨnotəruru nuhalpɨnən məto-inu, e suatɨp kəmoatən məmə pah in tepət elat. ");
INSERT INTO tnn_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kən Iesu təməht-iəhau məpələh, kən maun-in rəhan netəm tuelef məmə okotuwa-tu ron, kən tən-ipən kəm ilat məmə, “Etəm tolkeike məmə in otepət e netəmim, in oteike meiuaiu elat kən muwa məmə in iolwək əm kit rəhalat.” ");
INSERT INTO tnn_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Kən mɨləs suakəku kit muwɨn məf aupən-in ilat, kən maskəlɨm məmə, ");
INSERT INTO tnn_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Kən etəmim itəm tatos e nɨkin agien suakəku tahmen e inu, kən tatol e nərgək, kən tahmen əm məmə tatos io e nɨkin agien. Kən etəmim itəm tatos io e nɨkin agien, kən tahmen əm məmə tatos etəm u itəm təmahl-ipa io.” ");
INSERT INTO tnn_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Kən Jon təmən-ipən kəm Iesu məmə, “Iəgətun emotəplan suah kit tatəhg-iarəp narmɨn rat mɨn e nərgəm, kən emotən-iəhau məto-inu sənəmə kitat kit.” ");
INSERT INTO tnn_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Məto Iesu təmə, “Sotən-iəhauən, məto-inu etəm tatol nat pɨspɨs mɨn e nərgək, okol təsən uəhaiən nəghatən rat lak. ");
INSERT INTO tnn_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Etəm itəm sənəmə rəhatat tɨkɨmɨr, in tolkeike itat. ");
INSERT INTO tnn_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ekatən pahrien kəm itəmat məmə, okəmə etəm tətasitu etəmat, məto-inu rəhak u itəmat, suah u otəkəike mos nətouən rəhan, nat əpnapɨn in nat əkəku əm tahmen tatos-ipɨnə nəhau ətəp kəm itəmat nakotənɨm.” ");
INSERT INTO tnn_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Kən Iesu təmatəkəike matən məmə, “Nɨsualkələh mɨn u kotahatətə lak, okəmə suah kit tol kit təme e rəhan nəmegəhən o rəhan nahatətəən, kən suah əh, Uhgɨn otol nalpɨnən asol kəm in. Kən nalpɨnən əh otəskasɨk taprəkɨs okəmə kətu-pən kəpiel kit e nentou, kən kərakin-pən əpəh itəhəi lokamnɨm məmə otamnɨm. ");
INSERT INTO tnn_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","“Kən okəmə nelməm tol ik natol təfagə, kən təwɨr məmə nakətatɨp rəkɨs mərakin. Okəmə nelməm kitiəh əm məto onakos nəmegəhən lilɨn, inu təwɨr pɨk maprəkɨs-in məmə nelməm kəiu məto okərakin-pən ik e nɨgəm asol namnun tɨkə.” ");
INSERT INTO tnn_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Kən okəmə nelkəm kit tol ik nakatəme e rəham nəmegəhən nakətatɨp rəkɨs. Okəmə nelkəm kitiəh əm məto onakos nəmegəhən lilɨn, inu təwɨr pɨk maprəkɨs-in məmə nelkəm kəiu məto okərakin-pən ik e nɨgəm asol. ");
INSERT INTO tnn_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kən okəmə nɨganəmtɨm kit tol ik nakatəme e rəham nəmegəhən, nakɨləs-irəkɨs. Okəmə nɨganəmtɨm kitiəh əm məto onəkuwɨn ikɨn Uhgɨn tatərəmərə ikɨn, inu təwɨr pɨk maprəkɨs-in məmə nɨganəmtɨm kəiu məto okərakin-pən ik e nɨgəm asol. ");
INSERT INTO tnn_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kən ikɨn əh, fɨrəl mɨn okotətɨp e nɨpətɨ netəmim ikɨn məsotɨmɨsən, kən nɨgəm tatus ilat kən matuəp əm kɨlpɨn okol kəsohamɨsən nian kit ne. ");
INSERT INTO tnn_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Uhgɨn tateatəgtəg-pən nɨgəm e netəmim tahmen əm e sol kateatəgtəg-pən e nagwənən. ");
INSERT INTO tnn_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“?Sol təwɨr, məto okəmə otɨsiu roiu, kən kəruru məmə okos-ipən mɨn naka pəs tətehen? Onəkotəkəike motos sol u tahmen e nolkeikeən e rəhatəmat nəmegəhən, kən motatɨg e nəməlinuən nian rafin.” ");
INSERT INTO tnn_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kən Iesu təmiet ikɨn-un kən muwɨn miet-pən əpəh entən əpəh Jutia entənɨpən-pən e nəhau əpəh Jotan. Kən nɨmanin netəmim kəmotuəfɨmɨn-pən mɨn ilat mɨn ron, kən tatəgətun ilat məmə inu tatəgətun əh mihin ilat ne nian mɨn. ");
INSERT INTO tnn_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kən Farisi neen kəmotuwa keiuə əm katətapəh ron məmə, “?Tahro? ?Rəhatat Lou tategəhan-in məmə iərman tɨtun napəsən rəhan pətan, o kəp?” ");
INSERT INTO tnn_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Məto Iesu təmətapəh olat məmə, “?Lou naka un Moses təmələhəu aupən kəm itəmat?” ");
INSERT INTO tnn_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kən məto kotəmə, “Moses təmegəhan-in məmə okəmə iərman tətapəs rəhan pətan un, təike məte naoa kit mos-ipən kəm rəhan pətan məmə in tɨnapəs, kən panahl-iarəp.” ");
INSERT INTO tnn_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Məto Iesu təmə, “Moses təməte lou un məto-inu rəhatəmat-kapə tiəkɨs pɨk. ");
INSERT INTO tnn_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Məto e nətuounən, Uhgɨn təmol natɨmnat, kən mol iərman ne pətan. ");
INSERT INTO tnn_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","O nat əh in əh, iərman otəpanapəs rəhan tata ne mama, kən mətuatɨg ilau rəhan pətan. ");
INSERT INTO tnn_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Kən ilau okuea nɨpətɨlau kitiəh. Kən roiu, ilau sənəmə kəiu, məto kitiəh əm. ");
INSERT INTO tnn_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Uhgɨn tɨnɨlpɨn ilau kɨnuea mɨnioal kitiəh, kən o nat əh, pəs etəmim kit okol təsətatɨpən rəhalau natɨgən.” ");
INSERT INTO tnn_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kən Iesu ne rəhan mɨn netəmim kəmotuwɨn əpəh imə, kən rəhan mɨn netəmim kotətapəh ron o nat un. ");
INSERT INTO tnn_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kən təmən-ipən kəm ilat məmə, “Etəm tatol tifos mətapəs rəhan pətan kən matit mɨn in pɨsɨn kit, in tategoafəl matol təfagə rat e rəhan ətuatɨp pətan. ");
INSERT INTO tnn_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kən tahmen mɨn əm, okəmə pətan kit tətapəs rəhan iərman kən matətəu-pən in pɨsɨn kit, in mɨn tateguafəl matol təfagə rat e rəhan ətuatɨp iərman.” ");
INSERT INTO tnn_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kən netəmim neen kəmotəmɨk nɨsualkələh motuwa o Iesu məmə otələhəu-pən nelmɨn elat mawte-in nəwɨrən rəha Uhgɨn kəm ilat, məto rəhan mɨn netəmim kəmoatən-iəhau ilat. ");
INSERT INTO tnn_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Məto nian Iesu təməplan, kən neməha tol, matəhai ilat məmə, “Pəs nɨsualkələh okotuwa ron io. Əsotən-iəhauən nɨsualkələh mɨn un, məto-inu netəm mɨn u nɨkilat tahmen əm e nɨki nɨsualkələh, ilat u Uhgɨn tatərəmərə elat. ");
INSERT INTO tnn_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Iatən pahrien kəm itəmat məmə, okəmə suah kit təsolkeikeən məmə oteiuaiu mahmen e suakəku mapəs Uhgɨn tərəmərə lan, in okol təsatɨg ahginən nərəmərəən rəha Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kən məmɨk nɨsualkələh e nelmɨn, kən mələhəu-pən nelmɨn elat məmə, “Pəs Uhgɨn otawte-in rəhan nəwɨrən kəm itəmat.” ");
INSERT INTO tnn_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nian Iesu tɨnətaliwək matuwɨn, kən suah kit təmaiu muwa mɨsin-pən nulɨn ron məmə, “?Iəgətun wɨr, oekəkəike mol naka un məmə ekos nəmegəhən lilɨn?” ");
INSERT INTO tnn_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Məto Iesu təmə, “?Tahro nakatən məmə io etəm təwɨr? Uhgɨn pɨsɨn əm un in təwɨr, suah kit mɨn tɨkə məmə in təwɨr. ");
INSERT INTO tnn_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ik nɨnəmɨtun rəkɨs lou mɨn rəha Moses məmə onəsohamnuən itəm, məsakləhən, məseiuəən, məsakləh-inən pətan, onəkəike mɨsiai-in rəham tata ne mama.” ");
INSERT INTO tnn_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Məto suah un təmə, “Iəgətun, lou mɨn un, ematol rafin ilat nian ematəkəku mətoarus-pa u-roiu ne.” ");
INSERT INTO tnn_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Kən Iesu təmehm suah un molkeike pɨk, kən məmə, “Nat kit mɨn əm əh-ikɨn onəkol. Uwɨn mol-salɨm-in rafin rəham nautə, kən mos-ipən məni lan kəm ian-rat mɨn, kən ik onakos nautə tepət əpəh e nego e neai. Kən muwa muarisɨg-in io.” ");
INSERT INTO tnn_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kən nian suah un təməto nəghatən un, kən nɨganəmtɨn təməpou, kən nɨkin təməpou pɨk ron matuwɨn məto-inu rəhan natɨmnat tepət. ");
INSERT INTO tnn_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kən Iesu təmasɨpən məplan netəm mɨn əh-ikɨn, kən mən-ipən kəm rəhan mɨn netəmim məmə, “!Nəman! Tiəkɨs pahrien o netəm rəhalat nautə tepət məmə okotuwɨn ahgin nərəmərəən rəha Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kən rəhan mɨn netəmim kəmotaut pɨk o nəghatən rəhan, məto Iesu təmən mɨn məmə, “Nenetɨk mɨn, tiəkɨs pahrien məmə suah kit otuwɨn ahgin nərəmərəən rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tiəkɨs o kamel asol məmə otuwɨn-pən e nɨpəg nitel, məto tiəkɨs pɨk agɨn o etəm rəhan nautə tepət məmə otuwɨn matɨg ahgin nərəmərəən rəha Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kən rəhan mɨn netəmim kəmotaut pɨk ron motəmə, “?Ei, məto pah tɨtun nosən nəmegəhən lilɨn?” ");
INSERT INTO tnn_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Kən Iesu təmasɨpən məplan ilat, kən məmə, “Nat u, okol etəmim təsolən. Məto Uhgɨn, in tɨtun nolən natɨmnat rafin.” ");
INSERT INTO tnn_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kən Pita təmə, “Itɨmat emotapəs rafin rəhatɨmat natɨmnat məmə okotuarisɨg-in ik.” ");
INSERT INTO tnn_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Məto Iesu təmə, “Iatən pahrien, etəm itəm otapəs rəhan nimə, o pian mɨn, o kaka mɨn, o mama, o tata, o nɨsualkələh, o rəhan nəptən ron io ne Namnusən Təwɨr, ");
INSERT INTO tnn_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","e nəmegəhən rəha nətueintən u, in otos nɨtailat wan-hanrɨt, inu nimə mɨn, ne pian mɨn, ne kaka mɨn, ne mama mɨn, ne nɨsualkələh, ne nəptən mɨn. Kən in otos mɨn nəratən mɨn itəm netəmim okotol kəm in. Kən e nəmegəhən wi itəm otəpanuwa, in otos nəmegəhən lilɨn. ");
INSERT INTO tnn_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Məto netəmim tepət u kotaupən u-roiu, okəpanotuarisɨg, kən netəm mɨn u kotuarisɨg u-roiu okəpanotaupən.” ");
INSERT INTO tnn_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kən Iesu ne kəmotaliwək e suatɨp katər-pən əpəh Jerusalem, kən Iesu təmataupən-in rəhan mɨn netəmim, əmun narmɨlat təmiwɨg pɨk ron, kən netəm kəmotuarisɨg-in ilat kəmotəgɨn. Kən Iesu tit-irəkɨs rəhan mɨn netəm tuelef motuwɨn, kən tatən-ipən nat naka itəm okəpanol lan, ");
INSERT INTO tnn_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","məmə, “Otətəlɨg-in wɨr-tu io. Roiu kɨnoatər mɨnoatuwɨn əpəh Jerusalem, kən okegəhan-in-pən io Neti Etəmim e nelmɨ pris asol mɨn ne iəgətun mɨn rəha Lou. Kən okotən məmə oekɨmɨs, kən okotəhlman-pən io e nelmɨ Iaihluə mɨn. ");
INSERT INTO tnn_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kən okotol mɨlə lak, kən motagəh io, motalis io, kən motohamnu io. Məto e nian tatol kɨsɨl lan u, epanəmegəh mɨn.” ");
INSERT INTO tnn_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kən Jemes ne Jon, netɨ Sepeti mil, kəmuea o Iesu, kən muən-ipən ron məmə, “Iəgətun, ekioalkeike nat kit məmə onəkol kəm itɨmlau.” ");
INSERT INTO tnn_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Kən Iesu təmə, “?Nakioalkeike naka məmə ekol kəm itəmlau?” ");
INSERT INTO tnn_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Məto kuəmə, “O nian nakatuwa məmə onakərəmərə e nəhag-əhagən rəha nəsanənən rəham, kən ekioalkeike məmə onakegəhan-in itɨmlau kit təpələh e rahm-matɨp kən kit təpələh e rahm-mol, ikɨn mil rəha nəsanənən ne nɨsiaiiən.” ");
INSERT INTO tnn_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kən Iesu təmən-ipən kəm ilau məmə, “Itəmlau nəkuəruru nat u nakatuən. ?Tahro? ?Itəmlau, nɨkitəlau təht məmə nəkuahmen məmə kitəhal kəhalətul e nɨgəm rəha nuwigɨ nien itəm io ekəike mətul lan? ?Kən muahmen-in mɨn məmə okol baptais etəmlau e nahməən məmə okol mihin lak?” ");
INSERT INTO tnn_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Kən kuəmə, “!Əwəh, ekuahmen in!” Məto Iesu təmə, “Pahrien, onakuəkəike muətul e nɨgəm rəha nuwigɨ nien itəm io ekəike mətul lan. Kən okol baptais etəmlau e baptais itəm okol baptais lak lan. ");
INSERT INTO tnn_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Məto o nəpələhən e nɨkalɨk matɨp ne mol, sənəmə rəhak məmə ekən. Ikɨn mil əh, ilau rəha netəm mɨn u itəm Uhgɨn təmol əpen-əpenə olat.” ");
INSERT INTO tnn_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nian rəhan netəm ten kəmotəto nəghatən un, kən neməha təmol ilat o Jemes ne Jon. ");
INSERT INTO tnn_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kən Iesu təmaun-in rəhan mɨn netəmim kotuwa, kən tən-ipən kəm ilat məmə, “Itəmat nəkotɨtun məmə netəm mɨn u kotəmə okotepət e Iaihluə mɨn, kotos-ipər atɨp ilat, kən netəm-iasol rəhalat koatalɨkiamtə rəhalat mɨn netəmim. ");
INSERT INTO tnn_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","“Məto itəmat onəkəsotolən min-nəhlan. Okəmə itəmat kit tolkeike məmə in otepət etəmat, in otəkəike muwa məmə in iolwək əm kit rəhatəmat. ");
INSERT INTO tnn_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kən okəmə itəmat kit tolkeike məmə in otit itəmat, kən in otəkəike muwa məmə in slef kit rəhatəmat. ");
INSERT INTO tnn_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kən io mɨn, Netɨ Etəmim, eməsuwamən məmə netəmim okotol wək kəm io, məto emuwa məmə ekol wək kəm netəmim kən mos-ipən rəhak nəmegəhən məmə ekɨkɨs ilat e rəhalat nolən rat mɨn.” ");
INSERT INTO tnn_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kən Iesu ne rəhan mɨn netəmim, kəmotuwa əpəh Jeriko. Kən nian kɨnotiet moatuwɨn, kən netəmim tepət kəmotuarisɨg-in ilat. Kən suah kit nɨganəmtɨn təpɨs, tatəpələh e nɨkalɨ suatɨp, nərgɨn u Patimeas netɨ Timeas. Nian rafin tatətapəh-in məni o netəmim. ");
INSERT INTO tnn_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nian təməto məmə Iesu etəm Nasaret tətaliwək e suatɨp matuwa, kən təmagət əfəməh məmə, “!Awi, Iesu Mipɨ Tefɨt, asəkitun io, masitu lak!” ");
INSERT INTO tnn_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kən netəmim neen kotəmərɨt lan motəmə, “!Ei, əsagətən!” motən pap məto in təməha magət əfəməh pɨk mɨn məmə, “!Mipɨ Tefɨt, asəkitun io, masitu lak!” ");
INSERT INTO tnn_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kən Iesu tətul kən mən məmə, “Otaun-in-pən-tu suah un məmə tuwa.” Kən motən-ipən kəm in məmə, “Ei, agien, mətul, məto-inu Iesu tətaun-in ik.” ");
INSERT INTO tnn_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kən suah un təmatɨpin rəhn kot, mətɨp mər muwɨn o Iesu. ");
INSERT INTO tnn_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Kən Iesu təmətapəh ron məmə, “?Nakolkeike naka?” Məto təmə, “Iəgətun, ekolkeike məmə nakol-wɨr nɨganəmtək pəs ekehm nat.” ");
INSERT INTO tnn_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Kən Iesu təmə, “Atuwɨn. Rəham nahatətəən tɨnol-wɨr ik.” Kən roiu agɨn mɨn nɨganəmtɨn təməwɨr, tɨnatehm nat. Kən mɨnatətəu-pən Iesu moatan. ");
INSERT INTO tnn_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kəmotuwɨn iuəhkɨr o Jerusalem, iuəhkɨr o latuənu mil un Petfas ne Petani, moatuwɨn əpəh e Nɨtot Rəha Nɨg U Olif, kən Iesu təmahl-ipən rəhan kəiu etəmim mil kuaupən. ");
INSERT INTO tnn_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Təmən-ipən nəghatən u kəm ilau məmə, “Onakian əpəh e latuənu əh kotasɨpənin. O nian nakian əh-ikɨn, roiu agɨn onakuəplan nətɨ togki kit kəsasuəən əh lan kəməruətain. Kən nəkiakɨs muasɨg mueia. ");
INSERT INTO tnn_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kən okəmə suah kit təmə, ‘?Onakuahro-in netɨ togki?’ kən nakuəmə, ‘Iərəmərə tolkeike, kən otəpanahl-ipa mɨn otəsuwəhən.’” ");
INSERT INTO tnn_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ilau kəmian kən muəplan netɨ togki un kəməruətain e nɨkal suatɨp əpəh iuəhkɨr o nafiluə e nimə, kən kiakɨs. ");
INSERT INTO tnn_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Məto netəmim neen kəmotətul əh-ikɨn kən motətapəh olau məmə, “!Ei! ?Nakətiakɨs netɨ togki un o naka?” ");
INSERT INTO tnn_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kən kəmuən-ipən nəghatən rəha Iesu kəm ilat, kən ilat kəmotegəhan-in-pən netɨ togki kəm ilau. ");
INSERT INTO tnn_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kən kəmuasɨg togki mian o Iesu, kən muapeg rəhalau kot muəfətain noankawi togki un lan, kən Iesu təmasuə lan. ");
INSERT INTO tnn_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kən netəmim tepət kəmotepin rəhalat kot əpəh e suatɨp, kən neen kəmotaiu kan əpəh e nɨkinat katəte manat motəmɨk motuwa motəpen əpəh e suatɨp. ");
INSERT INTO tnn_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Netəm kotaupən ne netəm koatuarisɨg kəmotagət əfəməh məmə, “!Hosana, ənwiwi Uhgɨn! !Iərəmərə Uhgɨn tətatɨg ilau suah u itəm tatuwa e nərgɨn! ");
INSERT INTO tnn_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","!Pəs Uhgɨn otawte-in rəhan nəwɨrən kəm nərəmərəən itəm tatuwa, tahmen-pən əm e nərəmərəən rəha pipi rat u rəhatat Tefɨt! !Hosana o Uhgɨn əpəh ilɨs e nego e neai!” ");
INSERT INTO tnn_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kən Iesu təmuwɨn əpəh Jerusalem e Nimə Rəha Uhgɨn məplan natɨmnat. Məto tɨnapinəp rəkɨs, kən tiet ilat rəhan mɨn netəm tuelef mɨnoatuwɨn əpəh Petani. ");
INSERT INTO tnn_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kən kəmən lawɨgin, kɨnotiet mɨn Petani mɨnoatuwɨn Jerusalem, kən nəumɨs tɨnus Iesu. ");
INSERT INTO tnn_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kən tasɨpən-in nɨg kit fik tatətul əpəh isəu məsɨn nɨmalɨn tepət. Tuwɨn məmə otəhl noan kit, məto noan tɨkə, nɨmalɨn əm, məto-inu sənəmə nian rəha nɨg fik tatoe lan. ");
INSERT INTO tnn_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kən Iesu təmən-ipən kəm nɨg fik un məmə, “Okol netəmim kəsotun mɨnən noam e nup mɨn rafin.” Kən rəhan mɨn netəmim kəmotəto rəhan nəghatən un təmən. ");
INSERT INTO tnn_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kən kəmotuwɨn motiet-pən əpəh Jerusalem, kən Iesu tuwɨn əpəh imə e Nimə Rəha Uhgɨn məhg-iarəp netəmim kotol maket, kən mahwin tepɨl rəha netəm kotol senɨs e məni, ne stul rəha netəm koatol-salɨm-in mak mɨn. ");
INSERT INTO tnn_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kən mətulosɨg-in netəmim məmə okəsotəmɨkən rəhalat natɨmnat motuwɨn-pən əpəh Nimə ikɨn Rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kən təməgətun ilat məmə, “Kəməte-pən e Naoa Rəha Uhgɨn məmə Uhgɨn təmə, ‘Rəhak nimə, in nimə rəha nəfakən məmə netəmim rəha nɨtən mɨn rafin okotəfak-pa ikɨn kəm io.’ Məto itəmat nəmotol məmə in ‘nimə rəha iakləh mɨn.’” ");
INSERT INTO tnn_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kən pris asol mɨn ne iəgətun mɨn rəha Lou kəmotəto rəhan nəghatən. Kən kɨnotəgin Iesu məto-inu nian nɨmanin netəmim kəmotəto rəhan nəgətunən, narmɨlat tiwɨg pɨk ron. Kən pris asol mɨn ne iəgətun mɨn rəha Lou kɨnotətuoun kateam-in suatɨp kit məmə okotohamnu in. ");
INSERT INTO tnn_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kən tɨnehnaipən, Iesu ne rəhan mɨn netəmim kɨnotiet Jerusalem mɨnoatuwɨn. ");
INSERT INTO tnn_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kən kəmən lawɨgin, kəmotuwa mɨn e suatɨp motəplan nɨg fik apon tɨnauke rəkɨs muwɨn miet əpəh e nokɨn. ");
INSERT INTO tnn_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Kən Pita nɨkin tɨnəht nəghatən rəha Iesu o nɨg əh, kən mən-ipən kəm in məmə, “!Iəgətun, əplan-tu nɨg fik ilouin nəmən rat, kən tɨnauke rəkɨs!” ");
INSERT INTO tnn_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Kən Iesu təmən-ipən kəm ilat məmə, “Otahatətə əm e Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Iatən pahrien kəm itəmat məmə okəmə suah kit tətahatətə pahrien e Uhgɨn, kən otən-ipən kəm nɨtot əpəh məmə, ‘Uwɨn, mətɨpən atɨp əpəh itəhəi mamnɨm,’ kən okəmə təsənən e nɨkin kəiu, mahatətə əm e Uhgɨn, kən nat un otol pahrien. ");
INSERT INTO tnn_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","O nat u inu, iakatən kəm itəmat məmə okəmə nakotəfak o nat kit kən motahatətə məmə onəkotos pahrien, kən onəpanotos rafin nat un nəmotəfak ron. ");
INSERT INTO tnn_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“E nian nakotətul katəfak, məto nɨkitəmat məsɨn əh-ikɨn tərat məto-inu suah kit təmol nat kit təsahmenən etəmat, kən aluin rəhan nolən rat məsotalpɨnən rəhan nɨtai təfagə. Otol nəhlan pəs Uhgɨn əpəh e nego e neai in otaluin mafəl rəhatəmat təfagə rat mɨn.” ");
INSERT INTO tnn_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Kən Iesu ne rəhan netəm tuelef kəmotɨtəlɨg-pa mɨn əpəh Jerusalem. Kən Iesu taliwək mətan əpəh e Nimə Rəha Uhgɨn, kən pris asol neen, ne iəgətun mɨn rəha Lou, ne netəm-iasol rəha netəm Isrel kəmotuwa ron. ");
INSERT INTO tnn_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Kən katətapəh məmə, “?Ən-tu kəm itɨmat məmə pah təmegəhan-in ik nakatol natɨmnat mɨn əh? ?Kən pah təmegəhan-in nepətən əh, Uhgɨn o etəmim əm?” ");
INSERT INTO tnn_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Kən Iesu təmən-ipən kəm ilat məmə, “Oekətapəh-in-pɨnə-tu nəghatən kit kəm itəmat, kən okəmə nakotuhalpɨn u, kən ekən-ipɨnə məmə pah təmegəhan-in nepətən əh məmə ekol natɨmnat mɨn əh. ");
INSERT INTO tnn_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","?Otən-tu məmə pah təmən məmə Jon otol baptais e netəmim? ?Uhgɨn, o etəmim əm kit?” ");
INSERT INTO tnn_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kən əmun kɨnotən-ən kəm ilat mɨn məmə, “?Ei, okotən məmə naka? Okəmə okotən məmə Uhgɨn əh-roiu, kən təpanən mɨn məmə, kən tahro kəməsotahatətəən e Jon. ");
INSERT INTO tnn_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Məto, okol kəsotənən məmə etəmim əm kit.” Kəmotən nəhlan məto-inu ilat kəmotəgin netəmim itəm kɨnotən rəkɨs nɨpahrienən e Jon məmə in ien kit rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kən kəmotən-ipən kəm Iesu məmə, “Itɨmat ekotəruru.” Məto Iesu təmə, “Kən io mɨn, okol ekəsən-iarəpən kəm itəmat məmə pah təmegəhan-in nepətən məmə ekol natɨmnat mɨn əh.” ");
INSERT INTO tnn_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kən Iesu təmuəh nimaa nəghatən kit kəm ilat məmə, “Suah kit təmasum-in noa-krep, u nol katol wain e noan. Kən mol fenɨs e kəpiel tuwɨn mɨtəlau in, kən mol ikɨn kit o nolən nəme naliwək-aliwəkən e noa krep məmə nahuin otaiu kən kol wain lan. Kən mol nimə kit itəm in ilɨs məmə etəmim otaiu lan matehm wɨr nasumən o nat megəh mɨn ne netəmim. Kən təmegəhan-in-pən nasumən kəm netəmim məmə okotasum lan, kən motoor noa krep, məsɨn rəhan, məsɨn rəhalat. Kən miet muwɨn o naliwəkən ik pɨsɨn kit. ");
INSERT INTO tnn_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Matuwɨn matuwɨn, kən nian nol u krep təmol noan kən kɨnotəmarəg, etəm-iasol in təmahl-ipa rəhan kit iolwək məmə in otuwɨn mehm netəm koatol wək e rəhan nasumən məmə okotəhl noa krep, kən motoor kos-ipən rəha etəm-iasol neen. ");
INSERT INTO tnn_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Məto netəm mɨn əh kəmotətul motaht iolwək əh, kən motahl-ipən tɨtəlɨg məsotəmki-pənən noa krep neen ne kəm in. ");
INSERT INTO tnn_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Kən etəm-iasol un tahl-ipa mɨn rəhan kit iolwək tuwa, kən kotoh rəhn-kapə motol naulɨsən kəm in. ");
INSERT INTO tnn_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kən tahl-ipa mɨn rəhan kit iolwək tuwa, kən kotohamnu tɨmɨs. Ilat tepət kəmotuwa, kən netəm mɨn un kotoheain neen, kən motohamnu neen. ");
INSERT INTO tnn_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Kən kitiəh əm əh-ikɨn ilau min kətuatɨg, inu netɨn keike otəpanahl-ipa. Namnun, təmahl-ipa nətɨn, kən nɨkin tatəht məmə, ‘Ilat okotəkəike motɨsiai-in nətɨk.’ ");
INSERT INTO tnn_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Məto təmuwɨn kən netəm mɨn un kotəmə, ‘Inu nətɨ etəm-iasol itəm otərəmərə e nasumən nian rəhan tata otɨmɨs. Pəs kotuwɨn motohamnu mɨn, kən motərəmərə e nasumən rəhan.’ ");
INSERT INTO tnn_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kən kəmotaskəlɨm motohamnu, kən motɨləs nɨpətɨn motuwɨn motərakin-pən əpəh ihluə e nasumən.” ");
INSERT INTO tnn_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Kən Iesu təmən-ipən kəm ilat məmə, “?Etəm-iasol un otol naka? Otuwɨn mohamnu ilat kən mos-ipən mɨn nasumən un kəm netəm pɨsɨn neen.” ");
INSERT INTO tnn_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Kən Iesu təmən-ipən kəm ilat məmə, “?Nəmotafin Naoa Rəha Uhgɨn u, o kəp? Tatən məmə, ‘Kəpiel u itəm netəm rəha niləkɨnən nimə kəsotolkeikeən motapəs, in tɨnuwa kəpiel keike o nolən nimə. Iərəmərə təmol nat u, kən in nat təwɨr agɨn e nɨganəmtɨtat.’” ");
INSERT INTO tnn_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Kən netəm-iasol kotolkeike məmə okotaskəlɨm Iesu məto-inu kotəmə tatəghat rat elat. Məto kɨnotəgin nɨmanin netəmim kən motapəs, kagɨm. ");
INSERT INTO tnn_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Farisi mɨn neen ne netəmim neen e pati rəha Kig Herot Antipas, rəhalat mɨn netəm-iasol komotahl-ipən ilat məmə okotuwa keiuə e Iesu pəs təme atɨp e rəhan nəghatən. ");
INSERT INTO tnn_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kəmotuwa ron kən motən-ipən kəm in məmə, “Iəgətun, ekotɨtun məmə ik etəm ətuatɨp kən məsəgɨnən, məsaulɨs-inən netəmim, ne netəm-iasol ne, matən nɨpahrienən matəgətun netəmim e suatɨp rəha Uhgɨn. ?Ən-tu məmə tətuatɨp məmə ekotətou-pən takɨs kəm Sisa, kapman asol rəha netəm Rom, o kəp? ?Oekotəkəike motətou-pən, o kəp?” ");
INSERT INTO tnn_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Məto Iesu tɨnɨtun əm məmə kotən əm e nohlɨlat məto nɨkilat tol pɨsɨn, kən məmə, “?Tahro nakotəmə onəkotol məmə ekəme e rəhak nəghatən? Otos-tu məni kit motuwa-tu pəs ekehm.” ");
INSERT INTO tnn_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kən kəmotos kit motuwa, kən təmətapəh olat məmə, “?Narmɨ pah u, kən nərgɨ pah u e məni u?” Məto kotəmə, “Sisa.” ");
INSERT INTO tnn_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kən Iesu təmə, “Natɨmnat rəha Sisa, okos-ipən kəm Sisa. Məto natɨmnat rəha Uhgɨn okos-ipən kəm Uhgɨn.” Kən narmɨlat təmiwɨg məto-inu təmuhalpɨn wɨr rəhalat nəghatən. ");
INSERT INTO tnn_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kən Satusi mɨn neen kəmotuwa o Iesu. E rəhalat nətəlɨgən, netəmim kotɨmɨs məsotəmegəh mɨnən. Kəmoatalkut o nolən məmə rəhalat nətəlɨgən in tətuatɨp, kən tol nəhlan, kəmotən kəm Iesu məmə, ");
INSERT INTO tnn_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Iəgətun, Moses təməte rəkɨs lou kit u təmə, ‘Okəmə suah kit otɨmɨs, kən mapəs rəhan pətan, kən məsialəsən netɨlau kit ne, kən pian otəkəike mit nəutahlɨmɨs un, kən mialəs netɨlau kit un, kən suakəku un otos nəme rəhan tata asol əpəh tɨnɨmɨs rəkɨs.’ ");
INSERT INTO tnn_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Kən netəmim sepɨn ilat pialat mɨn. Etəm təmaupən maiir təmit pətan kit kən məsialəsən netɨlau kit u, kən tɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kən itəm tuarisɨg tit nəutahlɨmɨs un, kən məsialəsən netɨlau kit ne un, kən tɨmɨs mɨn. Kən pialau itəm tatuarisɨg-in ilau tol əm nat kitiəh. ");
INSERT INTO tnn_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Matuwɨn, matuwɨn kən netəm mɨn un sepɨn ilat pialat mɨn kəmotit pətan un motuwɨn kən ilat rafin mɨnotɨmɨs, kən məsotɨləsən nətɨlat kit ne. Kən pətan apon tɨnɨmɨs mɨn. ");
INSERT INTO tnn_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","?Kən o nian netəmim okotəmegəh mɨn e rəhalat nɨmɨsən, kən pətan əh rəha pah, u ilat rafin sepɨn kəmoatit?” ");
INSERT INTO tnn_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Məto Iesu təmə, “Itəmat nəmotəlue. ?Nəkotɨtun məmə nəmotahrəlue? Məto-inu itəmat nəkotəruru Naoa Rəha Uhgɨn, kən moatəruru mɨn nəsanənən rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nian netəm kəmotɨmɨs okotəmegəh mɨn, ilat okotahmen e nagelo mɨn əpəh e neai, kən məsotit mɨnən pətan, ne məsotətəu-pən mɨnən iərman. ");
INSERT INTO tnn_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kən oekəgətun itəmat e etəmim tatəmegəh mɨn e rəhan nɨmɨsən. Okəmə naka itəmat nakəsotafinən əh nəghatən əh kəməte-pən e naoa rəha Moses, tatən namnusən rəha Moses nian nɨg kit nɨgəm təmatus. Kən e nian əh, Uhgɨn təmən-ipən kəm Moses məmə, ‘Roiu əh, io Uhgɨn rəha Epraham, ne Uhgɨn rəha Aisak, ne Uhgɨn rəha Jekop.’ ");
INSERT INTO tnn_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","In Uhgɨn rəha netəm kotəmegəh, sənəmə rəha netəm kəmotɨmɨs kitiəh. Itəmat nəmotəlue pahrien.” ");
INSERT INTO tnn_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Kən iəgətun kit rəha Lou təmatəpələh matəto ilat kotəghat, kən Iesu tatuhalpɨn wɨr nəghatən rəha Satusi mɨn. Kən tuwa o Iesu matətapəh ron məmə, “?Lou ahro u in ilɨs pɨk kən məwɨr məmə okotətəu-pən?” ");
INSERT INTO tnn_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Kən Iesu təmən-ipən kəm in məmə, “Lou u in ilɨs pɨk u okotətəu-pən təmə, ‘!Otətəlɨg wɨr-tu itəmat netəm Isrel! Uhgɨn u in rəhatat Iərəmərə, in əmun in Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Onakolkeike Uhgɨn u in rəham Iərəmərə e nɨkim rafin, ne nəmegəhən rafin rəham, ne nətəlɨgən rafin rəham, ne nəsanənən rafin rəham.’ ");
INSERT INTO tnn_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kən lou itəm tatuarisɨg-in itəm əh təmə, ‘Onakolkeike ik mɨn neen tahmen-pən əm məmə natolkeike atɨp ik.’ Lou kit tɨkə mɨn taprəkɨs-in lou mil əh.” ");
INSERT INTO tnn_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kən iəgətun əh rəha Lou təmə, “Iəgətun, rəham nəghatən tətuatɨp. Nəmən pahrien məmə Iərəmərə əmun in Uhgɨn. Uhgɨn kit mɨn tɨkə. ");
INSERT INTO tnn_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kən okotolkeike Uhgɨn e nɨkitat rafin, ne nətəlɨgən rafin rəhatat, ne nəsanənən rafin rəhatat, kən motolkeike kitat mɨn neen məmə kotolkeike atɨp kitat mɨn. Təwɨr pɨk məmə okotətəu-pən lou mil əh taprəkɨs-in nuwaan atɨpən nat megəh ne sakrifais mɨn rafin itəm Lou tatən.” ");
INSERT INTO tnn_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kən Iesu təmehm məmə rəhan nəghatən tenatɨg pɨk, kən tən-ipən ron məmə, “Ik nɨnuwa iuəhkɨr o nərəmərəən rəha Uhgɨn.” Kən ilat rafin kɨnotəgin nətapəh-in mɨnən nəghatən ron. ");
INSERT INTO tnn_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nian Iesu təmatəgətun netəmim əpəh e Nimə Rəha Uhgɨn, kən matətapəh-in nəghatən kit kəm ilat məmə, “?Tahro iəgətun mɨn rəha Lou kotəmə Mesaea u in mipɨ Tefɨt? ");
INSERT INTO tnn_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Narmɨn Rəha Uhgɨn təmos-ipən nenatɨgən kəm Tefɨt məmə otən məmə, ‘Uhgɨn təmən-ipən kəm rəhak Iərəmərə məmə, Əpələh u e rəhk-matɨp, ikɨn rəha nəsanənən ne nɨsiaiiən, mətoarus-pən oekos-iəhau rəham tɨkɨmɨr mɨn məlɨn-pən ilat əpəh ləhau e nelkəm.’ ");
INSERT INTO tnn_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tefɨt atɨp təmən məmə Mesaea in rəhan Iərəmərə. ?Kən okəmə mipɨ Tefɨt atɨp əm, kən tahro matol rəhan Iərəmərə?” Kən netəm mɨn un kəmotətəlɨg-in Iesu kəmotagien pɨk o rəhan nəghatən. ");
INSERT INTO tnn_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nian Iesu təmatəgətun ilat kən məmə, “Oatəto wɨr itəmat o iəgətun mɨn rəha Lou itəm kotolkeike nuwɨnən e kot əfəməh motaliwək e suatɨp, kən netəmim koatos-ipən nɨsiaiiən kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kən motolkeike məmə okotəpələh aupən e nimə rəha nuəfɨmɨnən. Kən e nian rəha lafet, ilat koatolkeike məmə okotuwɨn kəpələh-pən aupən ikɨn rəha nɨsiaiiən. ");
INSERT INTO tnn_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kən motakləh-in nimə mɨn rəha nəutahlɨmɨs mɨn, kən moteiuə əm katəfak kaifəməh məmə okotol pəs netəmim kotɨsiai-in ilat, məto okəpanol nalpɨnən kəm ilat taprəkɨs.” ");
INSERT INTO tnn_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kən Iesu təmatəpələh əpəh e Nimə Rəha Uhgɨn iuəhkɨr o pokɨs katərakin-pən məni ikɨn matehm netəmim tepət kotərakin-pən məni rəhalat. Kən netəm rəhalat nautə tepət kotərakin-pən məni asol mɨn. ");
INSERT INTO tnn_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kən nəutahlɨmɨs kit ian-rat təmaii-pən məni əkəku kəiu əm. ");
INSERT INTO tnn_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Kən Iesu təmaun-in rəhan mɨn netəmim kotuwa kən məmə, “Iatən-ipɨnə kəm itəmat məmə nəutahlɨmɨs əh ian-rat pahrien, məto in təmərakin-pən məni asol taprəkɨs-in rəha netəmim mɨn rafin. ");
INSERT INTO tnn_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ilat kəmotərakin-pən rəhalat məni, məto tepət mɨn əpəh latuənu. Məto nəutahlɨmɨs u itəm in ian-rat pahrien, in təmos-ipən rafin məni rəhan o nos-nəmtɨnən nɨgɨn nagwənən, kən tɨkə mɨn əh-ikɨn.” ");
INSERT INTO tnn_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nian Iesu təmatiet e Nimə Rəha Uhgɨn, kən rəhan kit netəm tuelef təmən-ipən ron məmə, “!Iəgətun, əplan-tu kəpiel asol mɨn ne nimə mɨn, kotəwɨr!” ");
INSERT INTO tnn_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Kən məto Iesu təmə, “Itəmat nakoatehm natɨmnat mɨn əh, məto nian otatuwa itəm netəmim okotohalkin-ohalkin kəpiel mɨn rəha nimə mɨn əh, inəh kəpiel kit otəsətulən əh-ikɨn tatətul ikɨn roiu.” ");
INSERT INTO tnn_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Uarisɨg lan, Iesu təmuwɨn matəpələh əpəh e Nɨtot Rəha Nɨg U Olif ikɨn kɨtun nəplanən Nimə Rəha Uhgɨn entənɨpən-pən. Kən Jemes, Jon, Pita ne Antru kəmotuwa ron ilat pɨsɨn əm. ");
INSERT INTO tnn_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Kən moatətapəh ron məmə, “?Ən-tu məmə natɨmnat mɨn əh okotuwa nəghan? ?Kən nəmtətin ahro u otol pəs ekotɨtun məmə tɨnol nian ətuatɨp əh-roiu rəha natɨmnat mɨn əh?” ");
INSERT INTO tnn_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Kən Iesu təmən-ipən kəm ilat məmə, “Onakoatəto wɨr itəmat o netəmim, məsotegəhan-inən məmə koteiuə-in itəmat. ");
INSERT INTO tnn_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kən məto netəmim tepət okəpanotuwa e nərgək, kit otən məmə in Mesaea, kit otən məmə in, kən moteiuə-in netəmim tepət. ");
INSERT INTO tnn_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Kən okəmə nakotəto məmə netəmim neen koatəmou əpəh iuəhkɨr otəmat, kən motəto mɨn məmə neen mɨn əpəh isəu kotoh mɨn ilat mɨn, məto nɨganməpɨtəmat otəsasiepən. Natɨmnat mɨn əh okotaupən motuwa pahrien, məto sənəmə namnun nian əh tɨnatuwa. ");
INSERT INTO tnn_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nɨtən asol mɨn okotəluagɨn, kən kantri mɨn okotoh mɨn ilat mɨn, kən namig asol otəpanol ikɨn mɨn rafin, kən nəumɨs asol otus netəmim, məto natɨmnat mɨn əh nətuounən əm rəha nahməən itəm otəpanuwa, kotahmen əm e pətan itəm təmol nərpɨn, kən mətuoun matəto nahməən məmə otəsuwəhən temək. ");
INSERT INTO tnn_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Onakoatəto wɨr itəmat. Okɨləs itəmat kan nakotətul e nɨganəmtɨ kaonsel, kən okoh itəmat əpəh imə e nimə rəha nuəfɨmɨnən mɨn, kən onəkotətul aupən e netəm-iasol rəha kapman ne kig mɨn məto-inu rəhak mɨn u netəmim itəmat. Kən onəkotən-iarəp Namnusən Təwɨr kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Məto okaupən kən-iarəp Namnusən Təwɨr kəm netəmim ikɨn mɨn rafin un, kən namnun nian təpanuwa. ");
INSERT INTO tnn_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Okəmə okotuwa motɨləs itəmat kətan məmə onəkotətul e kaonsel, kən nɨkitəmat təsəht pɨkən məmə onəkotən naka. E nian ətuatɨp əh, onəkotən-iarəp əm nəghatən u Uhgɨn otos-ipɨnə kəm itəmat, məto-inu nəghatən u onəkotən, sənəmə rəhatəmat nəghatən, məto rəha Narmɨn Rəha Uhgɨn otos-ipɨnə. ");
INSERT INTO tnn_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Netəmim okotegəhan-in-pən pialat ətuatɨp mɨn kəm rəhalat tɨkɨmɨr mɨn məmə okotohamnu ilat, kən tata mɨn okotol mihin mɨn kəm nenətɨlat ətuatɨp mɨn, kən nɨsualkələh okotətul motol nolən ahmen mɨn əm kəm rəhalat tata mɨn ne mama mɨn məmə okotohamnu ilat. ");
INSERT INTO tnn_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Netəmim rafin okotetəhau itəmat o nərgək. Məto etəm otətul əskasɨk mətoarus-pən natɨmnat mɨn un okotol namnun, kən Uhgɨn otosmegəh.” ");
INSERT INTO tnn_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Nian əh, onəkotəplan ‘nat itəm Uhgɨn tatetəhau, kən matol Nimə Rəha Uhgɨn tamkɨmɨk.’ (Etəm tətafin nəghatən u, in otəkəike megəs-in mɨtun nɨpətɨn.) Kən e nian əh, netəm Jutia okotəkəike motaiu moatatɨg əpəh e nɨtot mɨn. ");
INSERT INTO tnn_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Etəm tətameg ihluə e rəhan nimə, kən okol təsuwɨn mɨnən e nɨpəg noa nimə məmɨk rəhan natɨmnat. Otaiu əm magɨm. ");
INSERT INTO tnn_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Okəmə etəm otɨtasum, kən okol təsuwɨn mɨnən latuənu o rəhan nɨməhan məmɨk. Otaiu əm magɨm. ");
INSERT INTO tnn_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","“!Kəsi! Nahməən asol o nɨpɨtan itəm kəmotol nərpɨlat ne nɨpɨtan kotapinahin nɨsualkələh. E nian əh okotos pɨk nahməən. ");
INSERT INTO tnn_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Otəfak əsanən kəm Uhgɨn məmə natɨmnat mɨn əh okəsotuwamən e nian rəha nətəpən, inəh nian rəha nalip ne nuhuən ne, ");
INSERT INTO tnn_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","məto-inu e nian əh, nahməən asol kəməsehmən kit ne kol mihin nəhlan e nian Uhgɨn təmətuoun mol natɨmnat mətoarus-pa u-roiu ne. Kən okəsehm mɨnən nahməən asol kit tol min-nəhlan. ");
INSERT INTO tnn_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Məto Uhgɨn təmətatɨp əkuəkɨr nian əh. Okəmə təməsətatɨpən, kən suah kit okol təməsəmegəhən. In təmətatɨp rəkɨs nian əh o rəhan mɨn netəmim itəm tɨnəmɨtəpun rəkɨs ilat məmə rəhan mɨn. ");
INSERT INTO tnn_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“E nian əh, okəmə suah kit otən məmə, ‘!Əplan-tu Mesaea əpə!’ o ‘!Əplan-tu in əpəh!’ məto onakəsotahatətəən lan. ");
INSERT INTO tnn_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Onakəsotahatətəən lan məto-inu, Mesaea eiuə neen, ne ien eiuə mɨn, ilat okotuwa motol nat pɨspɨs mɨn, motol nat netəmim kotaut ron moteiuə əm. Ilat okotalkut məmə okəmə kotɨtun nolən, kən okotiuw-rəkɨs netəm mɨn u itəm Uhgɨn tɨnəmɨtəpun rəkɨs ilat. ");
INSERT INTO tnn_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","!O natɨmnat mɨn əh, oatəto! Enaupən rəkɨs mɨnən-iarəp rafin natɨmnat mɨn əh kəm itəmat.” ");
INSERT INTO tnn_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Kən e nian nahməən asol əh otɨkə, ‘kən mɨt otəpɨs, kən məwɨg otəsasiəən, ");
INSERT INTO tnn_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","kən məhau mɨn e neai okotɨsas kən natɨmnat asol mɨn ikɨn e neai okotəloal.’ ");
INSERT INTO tnn_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kən netəmim okotəplan io Netɨ Etəmim oekuwa e napuə e rəhak nəsanənən ne nepətən əhag-əhag asol rəhak itəm otasiəgəpɨn rafin io. ");
INSERT INTO tnn_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Kən e nian əh, oekahl-ipən nagelo mɨn rəhak kotuwɨn motəmɨk netəm mɨn u Uhgɨn təmɨtəpun ilat motuwa, kargətain əm ilat kitiəh. Nagelo mɨn okotuwɨn e nɨtən mɨn rafin agɨn e nətueintən məmə okotəmɨk ilat. ");
INSERT INTO tnn_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Nɨkitəmat otəkəike matəht nɨg u fik. Nian ətuatɨp itəm nelmɨn mɨn kɨnotətuoun katəwiə, kən nɨmalɨn mɨn kɨnoatərget, itəmat nəkotɨtun məmə nian əh inəh itəm nakotasum lan rəhatəmat. ");
INSERT INTO tnn_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kən e nolən ahmen mɨn əm, nian nakotehm məmə natɨmnat mɨn u kɨnoatuwa, kən nəkotɨtun əm məmə otəsuwəhən ekuwa mɨn roiu agɨn. ");
INSERT INTO tnn_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Iatən pahrien kəm itəmat məmə netəmim itəm kotatɨg u-roiu, okol kəsotɨmɨs rafinən mətoarus natɨmnat mɨn əh okotuwa kol nɨpahrienən lan. ");
INSERT INTO tnn_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Neai ne nətueintən okiakə, məto nəghatən mɨn rəhak okol kəsotɨkəən. ");
INSERT INTO tnn_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Suah kit təsɨtunən nian o aua ətuatɨp rəha natɨmnat mɨn əh. Nagelo mɨn əpəh e neai kotəruru, kən io mɨn Netɨ Etəmim ekəruru. Məto Tata Uhgɨn əm in tɨtun nian ətuatɨp əh. ");
INSERT INTO tnn_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Onakoatəto wɨr itəmat moataiir, məto-inu itəmat nəkotəruru nian əh rəhak oekuwa lan məmə otuwa nəghan. ");
INSERT INTO tnn_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Otahmen e etəm-iasol kit tatuwɨn məmə otaliwək əpəh ik pɨspɨs kit, kən məlɨn rəhan mɨn iolwək məmə okotehm rəhan natɨmnat, kən mos-ipən rəhalat mɨn wək kitiəh kitiəh. Kən mən-ipən kəm itəm e nafiluə məmə otɨtaiir. ");
INSERT INTO tnn_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Kən itəmat onəkotaiir məto-inu itəmat nəkotəruru nian iərəmərə rəha nimə un otuwa lan. Kəruru məmə otuwa ehnaipən, o lapɨn, o fetukai tɨnatərɨkrɨk, o mɨt tɨnatər. ");
INSERT INTO tnn_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kəruru, okəmə naka otuwa ueiuəhai əm. !Təsəwɨrən məmə nakotapɨl nian in otuwa! ");
INSERT INTO tnn_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","!Məto nəghatən un itəm ekatən-ipɨnə kəm itəmat, ekatən mɨn kəm netəmim mɨn rafin məmə okotaiir!” ");
INSERT INTO tnn_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nian kəiu əm əh-ikɨn kəpanol lafet mil lan rəha Nuhagego-inən ne Pret u is Tɨkə Lan. Kən pris asol mɨn, ne iəgətun mɨn rəha Lou kəmoteam-in suatɨp o Iesu məmə okotɨləs anion motohamnu. ");
INSERT INTO tnn_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kən kotəmə okəsotolən e nian rəha lafet məto-inu kətah nɨmanin netəmim okotəmou okəmə kotɨtun məmə kəmotohamnu Iesu. ");
INSERT INTO tnn_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kən Iesu təmətatɨg əpəh Petani ima Saimon u leprosi təmatol aupən. Nian təmətagwən, kən pətan kit təmos senta kit təmər e pətəl u kəmol e kəpiel itəm nəmtɨn tiəkɨs, katən məmə alapasta. Senta u, nəmiəwɨn təwɨr, kən nəmtɨn tiəkɨs, kəmol e nokɨ nato, nɨg kit. Kən pətan əh təməht-irəkɨs, mau rəhn-kapə Iesu e senta əh. ");
INSERT INTO tnn_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kən netəmim neen kəmotəpələh əh-ikɨn, neməha təmol ilat, kən moatən-ipən kəm ilat mɨn məmə, “?Tahro matərəkɨn senta? ");
INSERT INTO tnn_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","!Okol tapol-salɨm-in tapos məni asol tahmen e tri-hanrɨt tenarius, mɨtun nos-ipənən kəm ian-rat mɨn!” Kən moatəhai moatəhai. ");
INSERT INTO tnn_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Məto Iesu təmə, “!Otapəs-ta! ?Nakotəhai o naka? In təmol nat wɨr kəm io. ");
INSERT INTO tnn_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nian mɨn rafin itəmat ian-rat mɨn nəkotatɨg, kən okəmə nakotolkeike, nəkotɨtun nol-wɨrən kəm ilat, məto io ekɨsatɨgən nian rafin kitat min itəmat. ");
INSERT INTO tnn_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Pətan u təmol nat u in tɨtun. Təmau nɨpətɨk məmə otol əpen-əpenə o nian okəpanɨtənɨm io. ");
INSERT INTO tnn_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ekatən pahrien kəm itəmat məmə, ikɨn mɨn rafin okəpanamnus-iarəp Namnusən Təwɨr, kən kəpanamnus mɨn nat u pətan u təmol məmə okəsaluinən.” ");
INSERT INTO tnn_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kən Jutas Iskariot in e netəm tuelef rəha Iesu, təmuwɨn mehm pris asol mɨn məmə otegəhan-in-pən Iesu kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nian kəmotəto rəhan nəghatən, kən kəmotagien ron, motəmə okəpanotos-ipən məni kit kəm in. Kən Jutas təmatəsahgin əm nian wɨr məmə otuwa kən otegəhan-in Iesu lan kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nian tɨnuwa o nolən lafet rəha Pret U Is Tɨkə Lan, kən kɨnatətuoun nolən lafet, kən nolən rəhalat katoh netɨ sipsip o lafet rəha Nuhagego-inən. E nian əh, netəmim mɨn rəha Iesu kəmotuwa ron motəmə, “?Nakolkeike məmə ekotuwɨn hiə motol əpen-əpenə ikɨn məmə onəkol lafet ikɨn rəha Nuhagego-inən?” ");
INSERT INTO tnn_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kən Iesu təmahl-ipən rəhan kəiu etəmim mil məmə, “Onakian əh taon muəplan suah kit tatəhun pətəl asol kit təmətu-pən nəhau lan, kən nakuətəu-pən. ");
INSERT INTO tnn_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Əpəh e nimə itəm tatuwɨn-pən ikɨn, kən nakuətapəh o etəm-iasol rəha nimə un məmə, ‘?Iəgətun təmə noan u in hiə məmə itɨmat in ne rəhan mɨn netəmim ekotagwən ikɨn e lafet rəha Nuhagego-inən?’ ");
INSERT INTO tnn_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kən in otəgətun noan asol u in ilɨs agɨn kɨnəməlɨn wɨr rəkɨs natɨmnat ikɨn. Onakian əm mioal nɨgɨtat ikɨn nagwənən.” ");
INSERT INTO tnn_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kən kəmian taon muəplan natɨmnat tahmen-pən əm məmə inu Iesu təmən mihin ne. Kən ilau kəmioal əpen-əpenə e nagwənən ikɨn rəha lafet rəha Nuhagego-inən. ");
INSERT INTO tnn_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tɨnehnaipən, Iesu ne rəhan netəm tuelef kəmotuwa, ");
INSERT INTO tnn_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","motagwən e tepɨl. Iesu təmən-ipən kəm ilat məmə, “Ekatən pahrien kəm itəmat məmə itəmat kit u ikɨn-u roiu kotagwən kələh kitat min, otegəhan-in-pən io kəm rəhak mɨn tɨkɨmɨr.” ");
INSERT INTO tnn_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kən rəhan mɨn netəmim nɨkilat təməpou agɨn, kən moatətapəh kitiəh kitiəh ron məmə, “?Ei, Iərəmərə, pah u? ?Io?” ");
INSERT INTO tnn_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Kən Iesu təmən-ipən kəm ilat məmə, “Itəmat əm kit u netəm tuelef u koateer-pən pɨret e pesɨn kitiəh moatun. ");
INSERT INTO tnn_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kən io Netɨ Etəmim oekəike mɨmɨs məmə inu Naoa Rəha Uhgɨn təmən mihin ne, məto kəsi o suah əh kəut kəsuə itəm otegəhan-in-pən io Netɨ Etəmim. !Təməwɨr əm məmə in təməsaiir-pa-mən!” ");
INSERT INTO tnn_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","E nian kəmoatagwən, Iesu təmos pɨret məfak mən tagkiu ron kəm Uhgɨn, kən məmkas mos-ipən kəm ilat məmə, “Otos, inu nɨpətɨk.” ");
INSERT INTO tnn_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Matɨg mos mɨn kap wain məfak mən tagkiu ron kəm Uhgɨn, mos-ipən kəm ilat, kən ilat rafin kəmotənɨm-pən lan. ");
INSERT INTO tnn_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kən təmən-ipən kəm ilat məmə, “Inu nɨtak itəm tatol məmə nəniəkɨsən rəha nasituən in tatətul matəmegəh. Nɨtak u okəhtəg o netəmim tepət məmə otafəl rəkɨs rəhalat təfagə rat mɨn. ");
INSERT INTO tnn_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ekatən pahrien kəm itəmat məmə oekəsənɨm mɨnən wain u mətoarus-pən oepanənɨm mɨn ikɨn Uhgɨn otərəmərə ikɨn.” ");
INSERT INTO tnn_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kən motan napuən, uarisɨg kəpanotiet motuwɨn əpəh Nɨtot Rəha Nɨg U Olif. ");
INSERT INTO tnn_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kən Iesu təmən-ipən kəm ilat məmə, “Itəmat rafin un onəpanotagɨm-tənin io məto-inu, Naoa Rəha Uhgɨn tɨnəmən rəkɨs mihin aupən məmə Uhgɨn otəpanoh etəmim rəha nehmən sipsip mɨn, kən sipsip mɨn okotaiu kitiəh kitiəh. ");
INSERT INTO tnn_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Məto o nian oekəmegəh mɨn, ekaupən-in itəmat muwɨn əpəh Kalili.” ");
INSERT INTO tnn_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Məto Pita təmə, “Nat əpnapɨn ilat rafin okotagɨm-tənin ik, məto io əm un okol ekəsagɨm-təninən ik.” ");
INSERT INTO tnn_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Kən Iesu təmən-ipən kəm in məmə, “Iatən pahrien kəm ik məmə o lapɨn huə, nian mənɨg otəsɨmnənən əh mau kəiu, kən ik onakən mau kɨsɨl məmə nəkəruru io.” ");
INSERT INTO tnn_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Məto Pita təmən əskasɨk məmə, “Nat əpnapɨn ekəkəike mɨmɨs kilau min ik, okol ekəsənən məmə ekəruru ik.” Kən rəhan rafin netəmim kotən mɨn tahmen e Pita. ");
INSERT INTO tnn_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kən lapɨn kəmotuwɨn əpəh kəmahwɨnu ikɨn kit, nərgɨn u Ketsemani, kən Iesu təmən-ipən kəm ilat məmə, “Otəpələh u ikɨn-u, pəs ekuwɨn məfak.” ");
INSERT INTO tnn_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kən mit Pita, Jemes ne Jon motuwɨn, kən nɨkin tɨnatahmə pɨk, kən tɨnəto tərat agɨn. ");
INSERT INTO tnn_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kən məmə, “Nɨkik tɨtahmə pɨk, kən iuəhkɨr ekɨmɨs lan. Atəhaləpələh u ikɨn-u matəhalaiir.” ");
INSERT INTO tnn_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kən muwɨn məsɨn mɨn meiuaiu morin e nɨsɨp matəfak məmə, “Okəmə suatɨp kit mɨn əh-ikɨn, pəs nian əfɨgəm u otəsuwamən ron io.” ");
INSERT INTO tnn_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kən matəfak məmə, “Apa,” (u nɨpətɨn təmə rəhak tata), “ik nəkɨtun nolən natɨmnat mɨn rafin. Awe, os-irəkɨs nahməən mɨn u itəm okəpanotuwa. Məto əsolən rəhak nətəlɨgən, məto ol nat naka itəm ik əm nakolkeike.” ");
INSERT INTO tnn_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kən mɨtəlɨg-pa məto rəhan etəmim miləhal kɨnəhlapɨl. Kən tən-ipən kəm Pita məmə, “?Saimon, nakatapɨl, o? ?Tahro nəsaiirən-tu aua kitiəh əm?” ");
INSERT INTO tnn_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kən mən-ipən kəm iləhal məmə, “Onakəhlaiir mətəhaləfak matəhalehm wɨr məmə onakəsəhaluwɨnən e nelmɨ ios-ipən-os-ipən. Nɨkitəməhal tolkeike, məto nɨpətɨtəməhal təpou.” ");
INSERT INTO tnn_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kən təmapəs mɨn iləhal, mɨtəlɨg-pən mɨn matəfak matən əm nat kitiəh. ");
INSERT INTO tnn_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kən mɨtəlɨg-pa mɨn, məto kɨnəhlapɨl mɨn, mɨnəhaləruru naiirən, kən mɨnəhaləruru mɨn məmə okəhalən-ipən naka kəm in. ");
INSERT INTO tnn_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Təmuwɨn mɨn kən mɨtəlɨg-pa mau kɨsɨl, məto kətəhlapɨl, kən təmən-ipən kəm iləhal məmə, “?Nakatəhalapɨl əh mətəhlameg? !Nahmen! Nian tɨnuwa məmə io Netɨ Etəmim okegəhan-in-pən io e nelmɨ netəm nol təfagə rat. ");
INSERT INTO tnn_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","!Halətul-ta, kotuwɨn! Əhaləplan, etəmim u tategəhan-in-pən io, in tatuwa.” ");
INSERT INTO tnn_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Iesu təmatahghat əh, kən Jutas in e netəm tuelef rəhan mɨn tɨtaupən-in nɨmanin netəmim. Neen kotəmɨk naip rəha nəluagɨnən, ne kəsou-əsou motuwa. Netəm mɨn un, pris asol mɨn, ne iəgətun mɨn rəha Lou, ne netəm-iasol rəha netəm Isrel kəmotahl-ipa ilat. ");
INSERT INTO tnn_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Suah un tategəhan-in Iesu kəm ilat tɨnəmən rəkɨs kəm ilat məmə, “Suah əh oekətuilɨm-pən lan u, nəkotɨtun əm məmə suah əh in əh. !Nakotaskəlɨm motos motuwɨn motaskəlɨm wɨr!” ");
INSERT INTO tnn_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kən əmun Jutas təmuwa iuəhkɨr o Iesu, kən mən məmə, “Iəgətun,” kən mətuilɨm-pən lan. ");
INSERT INTO tnn_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kən netəm mɨn əh kəmotuwa motaskəlɨm tiəkɨs. ");
INSERT INTO tnn_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Məto ilat kit rəha Iesu təmatətul iuəhkɨr olat təmew rəhan naip e nəmeen mətatɨp rəkɨs matəlgɨ slef kit lan rəha pris asol agɨn. ");
INSERT INTO tnn_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kən Iesu təmə, “?Tahro nakotəmɨk naip asol rəha nəluagɨnən ne kəsou-əsou motuwa məmə onəkotɨləs io? ?Nɨkitəmat təht məmə io emit netəmim muwɨn kotəluagɨn o kapman, o kəm-naka io iohamnu itəm kit? ");
INSERT INTO tnn_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nian mɨn rafin kitat min itəmat əpəh e Nimə Rəha Uhgɨn ekatəgətun netəmim ikɨn. ?Kən nakotahro məsotaskəlɨmən io? Məto nat Naoa Rəha Uhgɨn təmən, otəkəike muwa mol nɨpahrienən lan.” ");
INSERT INTO tnn_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kən rəhan mɨn rafin netəmim kɨnotapəs in, kən motagɨm-tənin. ");
INSERT INTO tnn_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kən etəm aluə kit itəm təməlkəhau-in nɨməhan kit, matuarisɨg-in Iesu, kən netəmim neen kəmotɨləs, kɨləs-arəpən lan, ");
INSERT INTO tnn_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","kən rəhn nɨməhan tɨkɨs, taiu piəpiə əm magɨm. ");
INSERT INTO tnn_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kən tɨtalugɨn əh, kəmotos Iesu motuwɨn əpəh ima pris asol agɨn u katuəfɨmɨn rafin pris asol mɨn, ne iəgətun mɨn rəha Lou, ne netəm-iasol rəha netəm Isrel ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Kən Pita tan təlɨg-təlɨg muarisɨg-in ilat muwɨn əpəh latuənu ima pris asol agɨn ikɨn. Kən təmuwɨn əpəh e iat matəpələh ilat mopael mɨn rəha pris asol agɨn moatəto nɨgəm. ");
INSERT INTO tnn_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kən pris asol mɨn ne netəmim rafin rəha kaonsel kəmoategəs-in nɨpəgnəmtɨn mɨn neen e Iesu məmə okotohamnu ron. Məto kəsotehmən kit ne. ");
INSERT INTO tnn_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kən netəmim tepət kəmoteiuə e Iesu, məto rəhalat nəghatən tətaiu pɨsɨn-pɨsɨn. ");
INSERT INTO tnn_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kən neen kotətul moteiuə lan məmə, ");
INSERT INTO tnn_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Emotəto təmən məmə otərəkɨn Nimə Rəha Uhgɨn u netəmim əm kəmotol e nelmɨlat, məto e nian tatol kɨsɨl lan, təpaniləkɨn mɨn nɨtain u kəsolən e nelmɨtəm.” ");
INSERT INTO tnn_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kəmotən nəhlan məto ilat mɨn, rəhalat nəghatən tətaiu pɨsɨn-pɨsɨn. ");
INSERT INTO tnn_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kən pris asol agɨn təmətul aupən-in ilat kən mən-ipən kəm Iesu məmə, “?Tahro nəsəghatən? ?Tahro e nəghatən mɨn əh itəm koatən-iarəp tatɨləs pɨkən ik?” ");
INSERT INTO tnn_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Məto Iesu təpnapɨn əm məsəghatən, kən pris asol agɨn apon təmən-ipən mɨn məmə, “?Tahro? ?Ik Mesaea u Netɨ Etəm katənwiwi?” ");
INSERT INTO tnn_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Kən Iesu təmə, “!Əwəh, io u! Onəpanotehm io Netɨ Etəmim ekatəpələh e rəhn matɨp Uhgɨn u nahgin tepət, kən panotehm mɨn io e napuə e neai ekatuwa.” ");
INSERT INTO tnn_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kən pris asol agɨn tearəsin rəhan natɨmnat məto-inu nɨkin təmərat o nəghatən rəha Iesu, kən məmə, “Okəsotegəs-in mɨnən suah kit məmə otən mɨn nat kit lan. ");
INSERT INTO tnn_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","!Nɨnəmotəto rəkɨs tatəghat rat e Uhgɨn! ?Nakotahrətəlɨg? ?Okotahro suah u?” Kən ilat rafin kəmotən məmə otəkəike mɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kən kəmotol mɨlə e Iesu, kən neen kəmotagəh lan, neen kotəlis nɨganəmtɨn motoh kən motəmə, “!Ei, ik ien rəha Uhgɨn! !Ən-tu məmə pah u təmoh ik!” Kən mopael mɨn rəha pris asol agɨn kəmotem. ");
INSERT INTO tnn_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kən Pita təmətan əh əpəh ləhau e iat. Kən slef pətan kit rəha pris asol agɨn təmuwa. ");
INSERT INTO tnn_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Kən məplan tatəto nɨgəm, kən təmɨsɨlu wɨr məmə, “Ik mɨn itəmlau Iesu etəm Nasaret nəmatuan.” ");
INSERT INTO tnn_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Məto Pita təmən-iamnin, kən məmə, “Iəkəruru nat un nakatən,” kən muwɨn matətul əpəh e ket rəha iat. Kən mənɨg kit təmɨmnən. ");
INSERT INTO tnn_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kən pətan un təmehm mɨn ikɨn əh, kən mən-ipən kəm netəm kotətul əh-ikɨn məmə, “Suah u in ilat kit.” ");
INSERT INTO tnn_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Məto Pita təmən-iamnin mɨn. Kən təsuwəhən, netəm kotətul əh-ikɨn kəmotən-ipən mɨn kəm in məmə, “Nɨpahrienən, ik mɨn ilat kit məto-inu ekotɨtun məmə ik etəm Kalili.” ");
INSERT INTO tnn_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Məto tɨnətuoun maun-in nəratən mɨn koatɨsɨ-pən o Uhgɨn moatuwa ron okəmə teiuə. Kən təmos noanawɨl məmə, “!Iəkəruru suah əh nakotəghat-in!” ");
INSERT INTO tnn_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kən roiu agɨn-əh mɨn mənɨg tɨnɨmnən mɨn, kən nɨkin tɨnəht nəghatən rəha Iesu məmə təmən minu lan məmə, “Mənɨg otəsɨmnənən əh mau kəiu, kən ik onakən mau kɨsɨl məmə nəkəruru io.” Kən Pita tɨnəto tərat kən mətasək. ");
INSERT INTO tnn_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kən laulaugɨn agɨn pris asol mɨn, ne netəm-iasol rəha netəm Isrel, ne iəgətun mɨn rəha Lou, ne netəmim mɨn rafin rəha kaonsel kəmotuəfɨmɨn ilat mɨn, kən moatələhəu nəghatən kit məmə okotohamnu Iesu. Kəmotən-ipən kəm netəmim neen məmə okotəlis Iesu kən motit motuwɨn motəhlman-pən e nelmɨ Pailat, u kapman asol rəhalat. ");
INSERT INTO tnn_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Kən Pailat təmətapəh ron məmə, “?Ik kig rəha netəm Isrel?” Kən məto Iesu təmə, “Ik nəmən mihin.” ");
INSERT INTO tnn_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kən pris asol mɨn kəmotən-iarəp nolən tepət lan. ");
INSERT INTO tnn_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kən Pailat təmətapəh ron məmə, “?Tahro nakəsuhalpɨnən? ?Nəməto kəmotən nɨpəgnəmtɨn tepət lam?” ");
INSERT INTO tnn_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Məto Iesu təsəghat mɨnən, təməpnapɨn əm, kən Pailat narmɨn təmiwɨg ron. ");
INSERT INTO tnn_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","E nup mɨn rafin, nian katol lafet lan rəha Nuhagego-inən, nolən rəha kapman u Pailat məmə in otahl-iarəp suah əpnapɨn əm kit e kalapus, suah kit itəm netəm Isrel kəmoatən. ");
INSERT INTO tnn_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kən suah kit u, nərgɨn u Parapas, tətatɨg e kalapus ilat in mɨn neen, məto-inu kəmotohamnu etəmim e nian kəmatəmou o kapman. ");
INSERT INTO tnn_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kən nɨmanin netəmim kəmotuwa o Pailat motən-ipən kəm in məmə otol əm nat kitiəh tahmen-pən e itəm tatol nian mɨn, mahl-iarəp suah kit e kalapus. ");
INSERT INTO tnn_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Kən Pailat təmətapəh olat məmə, “?Nakotolkeike məmə ekahl-iarəp kig rəha netəm Isrel?” ");
INSERT INTO tnn_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Təmən nəhlan məto-inu in tɨnɨtun rəkɨs məmə pris asol mɨn kəmotos-ipən Iesu e nelmɨn məto-inu kotetəhak. ");
INSERT INTO tnn_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Məto pris asol mɨn kəmotəkəike kəm nɨmanin netəmim məmə okotəuhlin nətəlɨgən rəhalat. Kən ilat kəmotətapəh o Pailat məmə otahl-iarəp Parapas, məto sənəmə Iesu. ");
INSERT INTO tnn_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kən Pailat təmətapəh olat məmə, “?Məto ekahro e suah u itəmat nəmotəmə in kig rəha netəm Isrel?” ");
INSERT INTO tnn_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kən kəmotagət əfəməh məmə, “!Okəht-ipən e nɨg kəməluau!” ");
INSERT INTO tnn_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Kən Pailat təmətapəh mɨn olat məmə, “?Nolən tərat naka u suah u təmol?” Məto kəmotagət əfəməh mɨn məmə, “!Okəht-ipən e nɨg kəməluau!” ");
INSERT INTO tnn_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kən Pailat təmolkeike məmə otol nɨkilat, kən mahl-iarəp Parapas, kən məhlman-pən Iesu e nelmɨ rəhan mopael mɨn məmə okotalis motətu-pər e nɨg kəməluau. ");
INSERT INTO tnn_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kən mopael mɨn rəha Pailat kotɨləs Iesu motuwɨn əpəh imə e nimə asol rəha kapman, katən məmə Praetoriam. Kən kəmotaun-in rafin mopael mɨn kotuwa kɨtəlau lan. ");
INSERT INTO tnn_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kən motuwɨn-in-pən kot asiə tahmen əm e kot rəha kig, kən motuarin-uarin nol itəm tol nihlən-nihlən motol hat lan itəm tahmen e hat rəha kig, kən motəfauin-pən kəm in. ");
INSERT INTO tnn_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kən motol mɨlə lan motəmə, “Itɨmat ekotos-ipɨnə nɨsiaiiən kəm ik, kig rəha netəm Isrel.” ");
INSERT INTO tnn_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kən motoh rəhn-kapə e noanɨg, motagəh lan, motɨsin nulɨlat məmə koatos-ipən nɨsiaiiən eiuən kəm in. ");
INSERT INTO tnn_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nian kəmotahkul rəkɨs lan, kən motapeg rəkɨs kot asiə un, kən motuwɨn-in-pən əh rəhan natɨmnat, kən motit motuwɨn məmə okotəht-ipən e nɨg kəməluau. ");
INSERT INTO tnn_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","E suatɨp, kəmotehm suah kit etəm Saerin, nərgɨn u Saimon. In tata rəha Aleksanta ne Rufas. Tatuwɨn Jerusalem, kən moatəkəike kəm in məmə otɨləs nɨg kəluau. ");
INSERT INTO tnn_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kən kəmotit Iesu motuwɨn əpəh ikɨn kit katən məmə, Kolkota, u nɨpətɨn təmə Louipɨl-uipɨl. ");
INSERT INTO tnn_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kən kəmotos-ipən wain u kəmol pɨləh-pɨləh ilau mərɨsɨn u mɨr məmə otənɨm pəs təsətoən nahməən e nɨpətɨn, məto tapəs nənɨmən. ");
INSERT INTO tnn_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kən kəmotɨləs Iesu motuwɨn motəht-ipən e nɨg kəməluau. Kən motoor rəhan natɨmnat moturin tais ron məmə pah otos. ");
INSERT INTO tnn_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kəmətu-pər Iesu e nɨg kəməluau e nain kɨlok laulaugɨn, ");
INSERT INTO tnn_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","kən motəte-rəkɨs nɨpəgnəmtɨn u kəmotehm lan məmə, In kig rəha netəm Isrel, kən motəht-ipən nəghatən un e rəhan nɨg kəməluau. ");
INSERT INTO tnn_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kən etəmim kəiu itəm kətuəluagɨn o kapman mətioh netəmim, kəmətu-pər ilau e nɨg kəluau, kit e nɨkalɨn matɨp, kit e nɨkalɨn mol. ");
INSERT INTO tnn_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Kən netəmim itəm kotaliwək e suatɨp, moatanu-anu rəhn-kapəlat kəm in moatol mɨlə lan motəmə, “Ei, ik nəmən məmə onakərəkɨn Nimə Rəha Uhgɨn kən nian tatol kɨsɨl lan u, nəpaniləkɨn mɨn in pɨsɨn. ");
INSERT INTO tnn_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Eiuaiu-tu e nɨg kəməluau un, mosmegəh atɨp-tu lam.” ");
INSERT INTO tnn_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Pris asol mɨn ne iəgətun mɨn rəha Lou kəmotol əm nat kitiəh motalah-əmnu motəmə, “Təmasitu e netəmim tepət, məto okol təsasitu atɨpən lan. ");
INSERT INTO tnn_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Təwɨr pəs kitat kotehm-tu Mesaea u, kig rəha netəm Isrel, oteiuaiu e nɨg kəməluau pəs kitat koatəplan motahatətə lan.” Kən etəmim mil u katəhaləkul iləhal Iesu kɨnatuən mɨn nəghatən rat lan. ");
INSERT INTO tnn_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kən e tuelef klok mətoarus-pən tri klok, napinəpən təmeiuaiu mɨrəfin nat. ");
INSERT INTO tnn_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kən e tri kɨlok Iesu təmagət əfəməh məmə, “!Eloi, Eloi! ?Lama sapaktani?” Nɨpətɨn rəhan nəghatən təmə, “!Uhgɨn rəhak, Uhgɨn rəhak! ?Tahro nakatapəs io?” ");
INSERT INTO tnn_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Netəmim neen kəmoatətul əh-ikɨn kəməsotəto wɨrən nəghatən un, kəmotən məmə, “Haləto-tu. Tətaun-in Elaija.” ");
INSERT INTO tnn_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kən ilat kit təmaiu muwɨn miuw-pən wain u tagɨn e nat kit tame-ame tahmen e katən, maru-pər e nuwig tuwɨn o Iesu məmə otənɨm. Kən məmə, “Pəs-tu kotehm-tu məmə Elaija otuwa mɨləs-iəhau, o kəp.” ");
INSERT INTO tnn_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Məto Iesu təmagət əfəməh mɨn, kən rəhan namegən tiet. ");
INSERT INTO tnn_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kən əpəh e Nimə Rəha Uhgɨn, nɨməhan itəm tatəkulosɨg-in Ikɨn Tasim Agɨn Ikɨn, təməhap məsɨn kəiu əpəh ilɨs mətoarus-pa əpəh ləhau. ");
INSERT INTO tnn_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kən etəm-iasol rəha mopael mɨn itəm təmatətul e nɨkalɨ Iesu, təmehm məmə təmɨmɨs min-nulan, kən in təmən məmə, “!Nɨpahrienən, suah u in Netɨ Uhgɨn pahrien!” ");
INSERT INTO tnn_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nɨpɨtan neen kəmoatətul isəu motasɨpa moatehm. Ilat neen u Meri Maktala, ne iahunin itɨ Jemes əkəku ne Joses, ne Salome. ");
INSERT INTO tnn_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Iləhal kəmatəhalətəu-pən Iesu nian təmətatɨg Kalili, mətahlasitu lan. Ilat nɨpɨtan tepət kəmotər kan əpəh Jerusalem ilat Iesu. ");
INSERT INTO tnn_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kən nian əh Iesu təmɨmɨs lan, in nian rəha nol əpen-əpenəən natɨmnat rəha Sapat, kən olawɨgin nian rəha Sapat, kəsolən wək lan. Tɨnehnaipən, ");
INSERT INTO tnn_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Josep in etəm Aramatia tɨnuwa. In etəmim kit rəha kaonsel itəm katɨsiai-in. In nɨkin təməht pɨk nərəmərəən rəha Uhgɨn. Kən təməsəgɨnən muwɨn ima Pailat ikɨn matətapəh-in nɨpətɨ Iesu. ");
INSERT INTO tnn_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nian Pailat təməto məmə Iesu tɨnɨmɨs rəkɨs, kən təmaut maun-in etəm-iasol rəha mopael mɨn matətapəh ron məmə, “?Katən pahrien məmə Iesu tɨnɨmɨs rəkɨs?” ");
INSERT INTO tnn_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Məto etəm-iasol rəha mopael mɨn təmə, “Nɨpahrienən, tɨnɨmɨs rəkɨs.” Pailat təməto nəghatən un kən megəhan-in-pən nɨpətɨ Iesu kəm Josep. ");
INSERT INTO tnn_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Kən Josep təmuwɨn mos-nəmtɨn nɨməhan ruən kit muwa mɨləs-iəhau Iesu e nɨg kəməluau malpin lan, mɨləs muwɨn mələhəu-pən e nɨpəg kəpiel u kɨnəmel rəkɨs məmə okol suwɨt ikɨn. Kən məsoupəlpəlin-pən kəpiel asol kit mahtosɨg-in-pən nɨpəg kəpiel un lan. ");
INSERT INTO tnn_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Kən Meri Maktala ne iahunin itɨ Joses, ilau kəmuəplan ikɨn-u kəmələhəu-pən Iesu ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nian rəha Sapat tɨnuwa mɨnuwɨn rəkɨs, kən Meri Maktala ne iahunin itɨ Jemes, ne Salome kəməhalos-nəmtɨn nat pien-pien mɨn u nəmiəwɨlat təwɨr məmə okəhalol-pən e nɨpətɨ Iesu. ");
INSERT INTO tnn_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Laulaugɨn agɨn mɨt tɨnatər e Sante, pətan miləhal un kəmatəhaluwɨn e suwɨt. ");
INSERT INTO tnn_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nian kəmatəhaluwɨn e suatɨp kən mətəhalən kəm iləhal mɨn məmə, “?Karmə pah otasitu etəhal mahuin rəkɨs kəpiel asol əpəh e nɨpəg kəpiel?” ");
INSERT INTO tnn_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Məto-inu kəpiel əh kəpiel asol. Məto nian kəməhaluwa iuəhkɨr, məhalətag-pən məhaləplan kɨnahuin rəkɨs kəpiel. ");
INSERT INTO tnn_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kəməhaluwɨn imə e nɨpəg kəpiel məhaləplan etəm aluə kit tatəpələh e rahləhal-matɨp, tatuwɨn e kot əfəməh ruən kit, kən iləhal kəmahlaut pɨk ron. ");
INSERT INTO tnn_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kən təmən-ipən kəm iləhal məmə, “Səhaləgɨn pɨkən. Natəhaleam-in Iesu etəm Nasaret, etəm kəmətu-pər e nɨg kəməluau, məto in tɨkə u ikɨn-u roiu. In tɨnəmegəh rəkɨs e rəhan nɨmɨsən. Halehm-tu nəmeen u kəmələhəu-pən ikɨn. ");
INSERT INTO tnn_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kən roiu onakəhaluwɨn məhalən-ipən kəm rəhan mɨn netəmim məsəhalapəsən Pita, məmə in otaupən matuwɨn Kalili, kən onəkotuarisɨg-in motuwɨn motehm əh-ikɨn məmə inu tɨnəmən rəkɨs mihin ne kəm itəmat.” ");
INSERT INTO tnn_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kəmahlaiu məhaliet e suwɨt məhlagɨm, məto-inu kɨnəhaləgɨn pɨk matəhlasiəp. Kən məhaluwɨn məsəhalənən nat kit ne kəm netəmim məto-inu kɨnəhaləgɨn pɨk. ");
INSERT INTO tnn_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nian Iesu təməmegəh mɨn e Sante laulaugɨn agɨn, kən maupən miet-pa o Meri Maktala, aupən təməhg-iarəp narmɨn rat sepɨn lan. ");
INSERT INTO tnn_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kən Meri təmuwɨn mən-ipən kəm rəhan mɨn netəmim itəm kəmotan ilat min ilat aupən, məto nɨkilat tɨtahmə pɨk kən motasək. ");
INSERT INTO tnn_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Məto nian kəmotəto məmə Iesu tɨnəmegəh rəkɨs e rəhan nɨmɨsən, kən miet-pa o pətan əh, məto ilat kəməsotənən nɨpahrienən lan. ");
INSERT INTO tnn_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Uarisɨg, Iesu təmiet-pa o etəmim mil kəiu kəmiasɨpən Jerusalem mətian e suatɨp, məto e nian əh nɨpətɨn təmol pɨsɨn. ");
INSERT INTO tnn_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kən ilau kəmiatəlɨg mɨn mian muən-ipən kəm ilau mɨn neen, məto ilat kəməsotən mɨnən nɨpahrienən elau. ");
INSERT INTO tnn_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kən uarisɨg, Iesu təmiet-pa mɨn o rəhan netəm lepɨn nian kəmotagwən matəhai ilat məmə, “Itəmat nakəsotahatətəən lak, rəhatəmat-kapə tiəkɨs pɨk.” Təməhai ilat məto-inu kəsotahatətəən e netəm kəmotehm məmə tɨnəmegəh rəkɨs e rəhan nɨmɨsən. ");
INSERT INTO tnn_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kən mən-ipən kəm ilat məmə, “Otuwɨn motən-iarəp Namnusən Təwɨr kəm netəmim mɨn e nɨtən mɨn rafin. ");
INSERT INTO tnn_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Etəm otəto Namnusən Təwɨr tahatətə lan kən mol baptais, Uhgɨn otosmegəh. Məto etəm təsahatətəən lan, Uhgɨn otol nalpɨnən asol kəm in. ");
INSERT INTO tnn_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kən netəm okotahatətə lak, Uhgɨn otol ilat kotol nat pɨspɨs mɨn. Okotəhg-iarəp narmɨn rat tepət e nərgək, kən motəghat e nəghatən ik pɨsɨn pɨsɨn mɨn. ");
INSERT INTO tnn_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ilat kotɨtun naskəlɨmən sɨnek u tatus itəm, motɨtun nənɨmən nat kətakonə lan, məto okol təsərəkɨnən ilat. Ilat motɨtun nələhəu-pənən nelmɨlat e netəm kotɨmɨs kotəmegəh.” ");
INSERT INTO tnn_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kən nian Iərəmərə Iesu tɨnəghat rəkɨs kəm rəhan mɨn netəmim, kən Uhgɨn tɨnos mɨnuwɨn e neai, kən in tatəpələh e nɨkalɨ Uhgɨn matɨp, ikɨn rəha nəsanənən ne nɨsiaiiən. ");
INSERT INTO tnn_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kən rəhan mɨn netəmim kəmotiet motuwɨn motamnus-iarəp rəhan nəghatən əpəh ikɨn mɨn rafin. Kən Iərəmərə tətasitu elat matol nəmtətin tepət. Kən nəmtətin mɨn əh koatol nəfɨgəmən məmə rəhalat nəghatən in nɨpahrienən. ");
INSERT INTO tnn_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Teofilas, ik etəm-iasol katɨsiai-in ik. Netəmim tepət kəmotalkut pɨk məmə okotəte rəkɨs ətuatɨp namnusən rəha natɨmnat mɨn itəm Uhgɨn təmol ilugɨn itɨmat. ");
INSERT INTO tnn_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kəmotəte rəkɨs natɨmnat itəm netəmim neen kəmotən, netəm mɨn əh kəmotatɨg e nian rəha nətuounən rəha natɨmnat mɨn əh, kən ilat kəmotehm ətuatɨp e nɨganəmtɨlat natɨmnat mɨn əh, kən moatən-iarəp. ");
INSERT INTO tnn_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kən io emɨtəp wɨr nəghatən mɨn lan məmə ekɨtun wɨr natɨmnat mɨn əh e nətuounən rəhan, kən roiu rəhak nətəlɨgən məmə təwɨr io mɨn ekəte rəkɨs ətuatɨp natɨmnat rafin mɨn əh məmə onakatafin. Ekəte ətuatɨp natɨmnat itəm kəmotaupən, kən natɨmnat itəm kəmotuarisɨg. ");
INSERT INTO tnn_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ekolkeike məmə ekən natɨmnat mɨn əh kəm ik məmə nəkɨtun ətuatɨp nɨpahrienən rəha namnusən itəm kəmən rəkɨs. ");
INSERT INTO tnn_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","E nian rəha suah kit, nərgɨn u Herot Asol, kig rəha Jutia, inəh pris kit nərgɨn u Sekaraea. In kit e pris mɨn kətaun-in ilat məmə, Pris mɨn rəha Apia, u təmɨsɨ-pən e noanol rəha pris u Aron aupən ikɨn. Rəhan pətaguɨhl, nərgɨn u Elisapet, kən in mɨn təmɨsɨ-pən e noanol rəha pris u Eron. ");
INSERT INTO tnn_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kən ilau kuətuatɨp e nɨganəmtɨ Uhgɨn, kən e nian rafin katuətəu-pən wɨr nolən rəha Lou ne nəghatən mɨn rəhan, kən məsuərəkɨnən kit. ");
INSERT INTO tnn_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Məto nətɨlau tɨkə məto-inu Elisapet, in təməseməkən mətoahgin mɨnɨpɨtaguɨhl, kən ilau kərən kɨnuaguɨhl. ");
INSERT INTO tnn_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kən nian ətuatɨp tɨnuwa məmə, Pris mɨn rəha Apia okotuwɨn e Nimə Rəha Uhgɨn motol rəhalat wək. Kən Sekaraea, in mɨn təmuwɨn mol wək rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","E nolən rəha pris mɨn, ilat koatərakin kəpiel əkəku mɨn kotahmen-pən e taes məmə okotegəs-in məmə otəgətun pah otol wək e Nimə Rəha Uhgɨn məmə otuwaan nat pien-pien itəm tatuwɨn kəm Uhgɨn. E nolən əh təməgətun Sekaraea. ");
INSERT INTO tnn_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kən e nian itəm təmuwɨn imə matuwaan nat pien-pien, nɨmanin netəmim tepət koatətul ihluə katəfak. ");
INSERT INTO tnn_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kən nagelo kit rəha Uhgɨn tiet-arəpa ron matətul əh e rəhan matɨp ikɨn, itəm katuwaan nat pien-pien mɨn ikɨn. ");
INSERT INTO tnn_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kən nian Sekaraea təməplan, kən narmɨn təmiwɨg mətasiəp mɨnəruru əfəməh nat, kən nəgɨnən təmərioah e nɨkin. ");
INSERT INTO tnn_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Məto nagelo təmən-ipən məmə, “Sekaraea, əsəgɨnən, məto-inu Uhgɨn tɨnəto rəham nəfakən. Kən rəham pətaguɨhl Elisapet otɨləs nətɨn kit iərman. Kən onakəkəike maun-in nərgɨn məmə Jon. ");
INSERT INTO tnn_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kən onakəto təwɨr kən magien, kən netəmim tepət okotagien o naiirən rəhan, ");
INSERT INTO tnn_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","məto-inu in otuwa etəm-iasol e nɨganəmtɨ Iərəmərə. Kən in otəsənɨmən wain ne nənɨmən əskasɨk mɨn. Kən Narmɨn Rəha Uhgɨn otərioah e nəmegəhən rəhan, nian otətatɨg əh e nərpɨ rəhan mama, matuwɨn əm nulan nian rafin. ");
INSERT INTO tnn_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kən in otiuw-pa netəm Isrel tepət kotɨtəlɨg-pa o Iərəmərə, Uhgɨn rəhalat. ");
INSERT INTO tnn_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kən in otətaupən-in Iərəmərə e narmɨn ne nəsanənən rəha Elaija məmə in otəuhlin nətəlɨgən rəha tata mɨn koatɨtəlɨg-pən mɨn o rəhalat nɨsualkələh mɨn, kən in otəuhlin mɨn netəm koatəht nəwia Uhgɨn okotuwa mɨn e nenatɨgən rəha netəm kotətuatɨp. E nolən əh, in otol nəpen-əpenəən o nəmegəhən rəha netəmim o nuwamən rəha Iərəmərə.” ");
INSERT INTO tnn_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Kən Sekaraea təmən-ipən kəm nagelo məmə, “?Oekahro min-nulan mɨtun məmə nat u otuwa mol nɨpahrienən? Məto-inu io enaguɨhl rəkɨs, kən rəhak pətan tɨnɨpɨtaguɨhl mɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Kən nagelo təmən-ipən kəm in məmə, “Io, nərgək u Kapriel, kən io iatətul e nɨganəmtɨ Uhgɨn e nian rafin. Kən in təmahl-ipa io məmə ekuwa məghat kəm ik, kən mən-ipɨnə namnusən təwɨr u. ");
INSERT INTO tnn_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","!Ətəlɨg-in-tu! Naməm oteko kən onakəsagətən mətoarus-pa nakehm nɨpətɨ nəghatən u, məto-inu nəməsənən nɨpahrienən e rəhak nəghatən. In otuwa mol nɨpahrienən e nian ətuatɨp rəhan.” ");
INSERT INTO tnn_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kən e nian əh, netəmim kəmoatəsahgin Sekaraea, kəmoatətəlɨg-in məmə tahro tɨnan tɨnuwəh-pɨk nəhlan e Nimə Rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kən nian in təmuwa ihluə, məto tɨnəruru nəghatən, kən ilat kɨnotɨtun məmə in təmehm nat kit tahmen e napɨlaiirən. In təmasgəwɨn-asgəwɨn əm e nelmɨn kəm ilat, məsagətən məto-inu namən təmeko. ");
INSERT INTO tnn_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nian rəhan wək rəha pris e Nimə Rəha Uhgɨn tɨnol namnun, kən in təmɨtəlɨg-pən latuənu. ");
INSERT INTO tnn_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kən təsuwəhən, rəhan pətaguɨhl tɨnəpəs məwɨg e suakəku. Kən e məwɨg faif, pətaguɨhl u in təmatəhluaig əm latuənu, ");
INSERT INTO tnn_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","kən in təmən məmə, “Inu wək əm rəha Iərəmərə. Aupən ikɨn, nətɨk tɨkə kən etaulɨs. Məto roiu əh, Uhgɨn təmol təwɨr ron io, kən nɨkin tagien məmə ekɨləs nətɨk, kən io esaulɨs mɨnən e nɨganəmtɨ netəmim.” ");
INSERT INTO tnn_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nian Elisapet tɨnəpək-əpək mɨnos məwɨg sikis, Uhgɨn təmahl-ipən rəhan nagelo, nərgɨn u Kapriel, məmə in otuwɨn e nɨtən Kalili e taon kit, nərgɨn u Nasaret. ");
INSERT INTO tnn_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","In təmos nəghatən kit matuwɨn rəha pətan kit itəm iərman təsuwɨnən əh mehm, məto kɨnən rəkɨs məmə okos rəhan kətɨm kan mə rəha suah kit, nərgɨn u Josep. In mipɨ Kig Tefɨt rat. Kən pətan əh, nərgɨn u Meri. ");
INSERT INTO tnn_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kən nagelo təmuwɨn met-arəpən, kən mən kəm in məmə, “Təwɨr, Meri. Uhgɨn təmələhəu rəhan nəwɨrən kəm ik, kən mətatɨg itəmlau min.” ");
INSERT INTO tnn_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Məto Meri tɨnatəruru əfəməh nəghatən əh, kən nɨkin tɨnatəht pɨk məmə nɨpətɨ nəghatən əh tahro. ");
INSERT INTO tnn_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kən nagelo təmən-ipən kəm in məmə, “Əsəgɨnən, Meri, məto-inu Uhgɨn təmɨtəpun məmə in otawte-in rəhan nəwɨrən kəm ik. ");
INSERT INTO tnn_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kən inəh, ik onakəpəs-in məwɨg e nətɨm kit, kən mɨləs iərman. Kən onəkaun-in nərgɨn məmə Iesu. ");
INSERT INTO tnn_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","In otuwa etəm-iasol kən etəm kəike, kən okaun-in məmə Nətɨ Uhgɨn Ilɨs Agɨn. Kən Iərəmərə Uhgɨn otol in tuwa Kig, tahmen-pən əm e tɨpɨn rat Tefɨt. ");
INSERT INTO tnn_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kən in otərəmərə e noanol mɨn rafin itəm koatɨsɨ-pən e Jekop, kən rəhan nərəmərəən otatɨg lilɨn matuwɨn matuwɨn namnun tɨkə.” ");
INSERT INTO tnn_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Kən Meri təmən-ipən kəm nagelo məmə, “?Oekahro min-nulan mɨləs suakəku kit okəmə esətəu-pənən əh iərman?” ");
INSERT INTO tnn_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Kən nagelo təmən-ipən kəm in məmə, “Narmɨn Rəha Uhgɨn otuwa matɨg lam, kən nəsanənən rəha Uhgɨn Ilɨs Agɨn otəfətain ik. Kən inəh, suakəku onəkɨləs, okaun-in məmə in təmɨsɨ-pən o Uhgɨn, kən in Nətɨ Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kən iatən kəm ik məmə ik kit Elisapet tɨnəpək-əpək rəkɨs in nətɨn kit iərman, nat əpnapɨn in tɨnɨpətaguɨhl rəkɨs. Kəmatən lan məmə pətaguɨhl itəm təseməkən, məto roiu əh tɨnəpəs məwɨg sikis rəkɨs e nətɨn. ");
INSERT INTO tnn_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Natɨmnat mɨn u tatətəu-pən nəghatən rəha Uhgɨn məmə, ‘Uhgɨn tɨtun nolən natɨmnat rafin, kən nat kit təsiəkɨsən ron.’” ");
INSERT INTO tnn_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kən Meri təmən-ipən məmə, “Əwəh, io pətan iolwək əm rəha Iərəmərə. Pəs in otol kəm io nat naka itəm ik nɨnən rəkɨs.” Kən nagelo təmapəs in, kən matuwɨn. ");
INSERT INTO tnn_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Uarisɨg lan təsuwəhən, Meri təmiet iman ikɨn maliwək uəhai əm matuwɨn əpəh ikɨn e nɨtot mɨn e taon kit rəha nɨtən Jutia məmə otətag in kit Elisapet, ");
INSERT INTO tnn_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","kən in təmuwɨn latuənu rəha Sekaraea, muwɨn imə matən təwɨr kəm Elisapet. ");
INSERT INTO tnn_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kən e nian Elisapet təməto nəghatən rəha Meri, suakəku un itəm tətatɨg əpəh e nərpɨn təmaut, kən Narmɨn Rəha Uhgɨn təmər e nɨki Elisapet. ");
INSERT INTO tnn_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Kən təmagət əfəməh məmə, “!Uhgɨn təmol təwɨr kəm ik taprəkɨs-in nɨpɨtan mɨn rafin, kən in otol təwɨr kəm suakəku itəm onəkɨləs! ");
INSERT INTO tnn_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ekɨsɨtunən məmə o naka Uhgɨn təmol təwɨr kəm io min-nulan məmə mama rəha Iərəmərə rəhak təmuwa mətag io. ");
INSERT INTO tnn_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Iatən nəhlan məto-inu e nian ematəto rəham nəghatən, kən suakəku un itəm tətatɨg əpəh e nərpɨk təmagien maut. ");
INSERT INTO tnn_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kən Uhgɨn otol təwɨr kəm ik məto-inu nəmən nɨpahrienən e nəghatən itəm Iərəmərə təməghat-in lam.” ");
INSERT INTO tnn_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Kən Meri təmən məmə, “E nəmegəhən rafin rəhak, iatənwiwi Iərəmərə, ");
INSERT INTO tnn_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","kən nɨkik tətagien pɨk o Uhgɨn Iosmegəh rəhak, ");
INSERT INTO tnn_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","məto-inu io pətan iolwək əm rəhan itəm io nat əpnapɨn əm, məto nɨkin tatəht io. Kən roiu ne matuwɨn, netəmim rafin okotən məmə Uhgɨn təmol təwɨr kəm io; ");
INSERT INTO tnn_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","məto-inu Uhgɨn u nəsanənən rəhan in iahgin, in təmol nat pɨspɨs mɨn təwɨr pɨk agɨn kəm io, kən nərgɨn in tasim. ");
INSERT INTO tnn_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kən in tətasəkitun netəm mɨn u itəm koatɨsiai-in in, inu netəm rəha noanol mɨn aupən ikɨn mətoarus-pa itəm rəha noanol mɨn kəsotaiirən əh. ");
INSERT INTO tnn_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","In təmol nat pɨspɨs mɨn e nəsanənən e nelmɨn. In təmahl-iarəp netəm kotausit e nətəlɨgən rəhalat. ");
INSERT INTO tnn_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","In təmos-iəhau iərəmərə mɨn e rəhalat nərəmərəən, kən in təmɨləs-ipər netəm mɨn u rəhalat nətəlɨgən teiuaiu. ");
INSERT INTO tnn_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Netəm itəm nəumɨs tatus ilat, in tətagwən ilat e nagwənən itəm təwɨr, kən netəm rəhalat nautə tepət, in tətahl-iarəp ilat kən nat tɨkə e nelmɨlat. ");
INSERT INTO tnn_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Uhgɨn təmasitu e noanol mɨn rəha Isrel u rəhan iolwək mɨn, kən təməsaluinən məmə otasəkitun ");
INSERT INTO tnn_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Epraham ne rəhan mɨn noanol, matuwɨn matuwɨn namnun tɨkə.” ");
INSERT INTO tnn_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Kən Meri tətatɨg ilau Elisapet mətoarus-pən məwɨg kɨsɨl, kən in təmɨtəlɨg-pən mɨn əpəh iman ikɨn. ");
INSERT INTO tnn_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kən nian ətuatɨp rəha Elisapet tɨnuwa məmə otemək lan, kən təmɨləs nətɨn iərman. ");
INSERT INTO tnn_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kən netəmim itəm kotatɨg iuəhkɨr ron ne rəhan mɨn noanol, kəmotəto namnusən əh məmə Iərəmərə təmasəkitun mol təwɨr pɨk kəm in nəhlan, kən ilat kəmotuwa motol kitiəh ilat min məmə okotagien kələh. ");
INSERT INTO tnn_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nian suakəku əh tɨnos nian ilat eit, kən ilat kəmotuwa məmə okotəhg-ipən. Kən iuəhkɨr kotaun-in nərgɨn məmə iahuni rəhan tata Sekaraea, ");
INSERT INTO tnn_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","məto rəhan mama tən məmə, “Kəpə. Okaun-in nərgɨn u məmə Jon.” ");
INSERT INTO tnn_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kən ilat kəmotən kəm in məmə, “?Tahro? Rəham kit noanol tɨkə itəm kotaun-in nərgɨn əh Jon.” ");
INSERT INTO tnn_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kən kəmoatəghat e noanelmɨlat moatətapəh o Sekaraea məmə in tolkeike məmə otaun-in-pən nərgɨn məmə pah. ");
INSERT INTO tnn_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Kən in təmətapəh o nat kit məmə in otəte rəkɨs nat kit lan, kən təməte-pən məmə, “Nərgɨn u Jon.” Nian kəmotehm, narmɨlat təmiwɨg pɨk ron. ");
INSERT INTO tnn_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kən e nian əm əh, namən tɨnəg-ətuatɨp, kən tɨnatəghat matənwiwi Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kən ilat rafin itəm kotatɨg iuəhkɨr kəmotəgɨn. Kən netəmim kəmotəghat-in natɨmnat mɨn əh tɨtəlau ikɨn mɨn rafin e narɨt mɨn nɨtən Jutia. ");
INSERT INTO tnn_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kən netəmim rafin itəm kəmotəto namnusən əh, kən kəmoatətəlɨg-in əm, kəmoatətapəh məmə, “?Suakəku əh, otuwa etəmim naka?” Kəmoatən min-nulan məto-inu kəmotəplan əm məmə nəsanənən rəha Iərəmərə tətatɨg lan. ");
INSERT INTO tnn_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Kən Narmɨn Rəha Uhgɨn təmər e nɨki Sekaraea, tata rəha Jon, kən in təmən-iarəp nəghatən itəm Uhgɨn təmos-ipən kəm in. Kən təmən min-nulan məmə, ");
INSERT INTO tnn_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Pəs kotənwiwi Iərəmərə, u Uhgɨn rəha netəm Isrel, məto-inu in təmuwa məmə otasitu e rəhan mɨn netəmim, kən təməmki-rəkɨs ilat e nelmɨ tɨkɨmɨr mɨn rəhalat. ");
INSERT INTO tnn_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","In təmɨləs-ipər iosmegəh təsanən itəm otosmegəh kitat, in təmɨsɨ-pən e noanol rəha iolwək rəhan Tefɨt. ");
INSERT INTO tnn_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kən in tahmen-pən əm e nəghatən u itəm Uhgɨn tɨnəmən rəkɨs kəm kitat e nəghatən rəha ien mɨn rəhan aupən. ");
INSERT INTO tnn_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","In tɨnəmən-iəkɨs rəkɨs məmə otosmegəh kitat o tɨkɨmɨr mɨn rəhatat ne netəmim rafin itəm kotetəhau kitat. ");
INSERT INTO tnn_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","In təmɨləs-ipər iosmegəh əh məmə otasəkitun pipi rat mɨn rəhatat, kən təsaluinən rəhan nəghatən itəm in atɨp təmən e rəhan nəniəkɨsən rəha nasituən, ");
INSERT INTO tnn_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","inu nəniəkɨsən itəm təmən kəm pipi rat Epraham. ");
INSERT INTO tnn_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","In təmɨləs-ipər iosmegəh əh məmə otosmegəh kitat, kən mɨləs-irəkɨs kitat e nelmɨ tɨkɨmɨr mɨn rəhatat, məmə nian mɨn rafin e nəmegəhən rəhatat, kitat kotɨtun nol wəkən rəhan e nɨganəmtɨ Uhgɨn, kən məsotəgɨnən, ");
INSERT INTO tnn_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","kən kitat okotasim, kən nəmegəhən rəhatat otətuatɨp e nian mɨn rafin. ");
INSERT INTO tnn_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Kən ik, nətɨk, okaun-in ik məmə ien rəha Uhgɨn Ilɨs Agɨn, məto-inu ik onakaupən-in Iərəmərə məmə onəkol əpen-əpenə e rəhan suatɨp. ");
INSERT INTO tnn_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ik onakən-iarəp kəm rəhan mɨn netəmim məmə Uhgɨn otosmegəh ilat nian in otafəl rəkɨs rəhalat təfagə rat mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","In otol məto-inu, in tətasəkitun kitat matol təwɨr kəm kitat. E nasəkitunən rəhan, Kristo otuwa otat tahmen-pən e mɨtgar təmər e neai, ");
INSERT INTO tnn_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","mətasiəgəpɨn kitat netəm koatatɨg e napinəpən ne əpəh ikɨn nɨmɨsən tatoh itəm ikɨn, kən matit wɨr nelkɨtat e suatɨp rəha nəməlinuən.” ");
INSERT INTO tnn_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kən suakəku təmatepət e nɨpətɨn, kən narmɨn rəhan təsanən. Kən nian rafin in tətatɨg əpəh ikɨn taruən-aruən ikɨn matəsahgin nian rəhan otuwa itəm otətuoun wək lan e nɨganəmtɨ netəm Isrel. ");
INSERT INTO tnn_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","E nian mɨn əh, suah kit etəm Rom, nərgɨn u Sisa Okastas, in tatərəmərə nɨtən mɨn rafin rəha Rom. In təmələhəu lou kit tətatɨg məmə okafin rafin netəmim itəm koatatɨg rafin əh-ikɨn. ");
INSERT INTO tnn_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Inu nafinən netəmim itəm kəmaupən kol, kən Kuarinias in kapman rəha Siria. ");
INSERT INTO tnn_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kən o nəghatən əh rəha nafinən, netəmim rafin kotəkəike moatɨtəlɨg-pən iməlat mɨn ikɨn itəm kəmotaiir ikɨn məmə okafin ilat, kən kəte rəkɨs nərgɨlat e naoa rəha kapman. ");
INSERT INTO tnn_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kən Josep ne Meri kəmiaiet e nɨtən Kalili e taon kit, nərgɨn u Nasaret, mian əpəh nɨtən Jutia e taon kit, nərgɨn u Petlehem, imə Kig Tefɨt aupən. Ilau kəmian ikɨn əh məto-inu Josep in mipɨ Tefɨt rat. ");
INSERT INTO tnn_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ilau Meri katian məmə okos nərgɨlau. Kɨnagətosɨg-in rəkɨs Meri məmə in otəpanətəu-pən Josep, kən Meri in tɨnəpək-əpək-in rəkɨs suakəku kit. ");
INSERT INTO tnn_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nian ilau əpəh Petlehem, kən nian rəha Meri tɨnuwa məmə otemək-in nətɨn. ");
INSERT INTO tnn_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kən suakəku itəm in təmaupən maiir, in iərman. Kən təmalpin e nɨməhan, mələhəu-pən e pokis kit itəm katələhəu-pən kras u nat megəh mɨn kotagwən-pən ikɨn. Təmol min-nəhlan məto-inu nimə tɨkə məmə okuapɨl ikɨn, kən ilau kətuapɨl əm əh e nimə rəha nat megəh mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kən e nɨkalɨ Petlehem, iolwək e sipsip mɨn koatehm wɨr rəhalat sipsip mɨn lapɨn. ");
INSERT INTO tnn_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kən nagelo kit rəha Iərəmərə təmiet-arəpa olat, kən nəhag-əhagən asol rəha Iərəmərə təmasiəgəpɨn ilat, kən kəmotəgɨn pɨk. ");
INSERT INTO tnn_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Məto nagelo təmən kəm ilat məmə, “Əsotəgɨnən, məto-inu io iatuwa məmə ekos-ipɨnə namnusən təwɨr kəm itəmat itəm otol nɨki netəmim kotagien pɨk, kən namnusən u in rəha netəmim rafin. ");
INSERT INTO tnn_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Əpəh e taon rəha Kig Tefɨt, suakəku kit təmaiir-pa u-roiu. In Iosmegəh, kən in Kristo itəm Uhgɨn təmən aupən məmə otahl-ipa otəmat, kən in Iərəmərə. ");
INSERT INTO tnn_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Inu nəmtətin rəhatəmat: onəkotehm suakəku kəmalpin e nɨməhan, kən kələhəu-pən e pokis kətagwən-pən nat megəh mɨn ikɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kən roiu agɨn-əh mɨn, nagelo mɨn tepət kəmotiet-arəpa moatətul ilat min, moatənwiwi Uhgɨn, moatən məmə, ");
INSERT INTO tnn_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Katənwiwi Uhgɨn əpəh ilɨs ilɨs agɨn-əh e neai. Kən əpəh ləhau e nətueintən u, netəmim itəm nɨki Uhgɨn tətagien olat, ilat okotatɨg e nəməlinuən.” ");
INSERT INTO tnn_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nian nagelo mɨn kəmotapəs iolwək e sipsip mɨn motɨtəlɨg-pən əpəh e nego e neai, kən iolwək e sipsip mɨn kəmotən kəm ilat mɨn məmə, “Pəs kotuwɨn Petlehem motehm-tu nat əh itəm Iərəmərə təmən kəm kitat.” ");
INSERT INTO tnn_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kəmotəruməhlin uəhai əm motuwɨn motehm Meri ne Josep ne suakəku itəm kəmuələhəu-pən e pokis itəm kətagwən-pən nat megəh mɨn ikɨn. ");
INSERT INTO tnn_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nian kəmotuwɨn motehm rəkɨs suakəku u, kən kəmotamnus-iarəp nəghatən rəha suakəku u itəm kəmotos o nagelo. ");
INSERT INTO tnn_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kən netəmim rafin itəm kəmotəto nəghatən əh rəha iolwək e sipsip mɨn, ilat kəmotaut, narmɨlat təmiwɨg pɨk ron. ");
INSERT INTO tnn_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Məto Meri təmatos əm e nɨkin natɨmnat mɨn u rafin, matətəlɨg-in e nian mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kən iolwək e sipsip mɨn kəmoatɨtəlɨg, moatɨləs-ipər nərgɨ Uhgɨn moatənwiwi in o natɨmnat rafin itəm kəmotəto kən motehm, tahmen-pən əm e inu nagelo təmən-ipən mihin kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nian suakəku u tɨnos nian eit itəm təmaiir lan, kən kəhg-ipən in tatətəu-pən Lou rəhalat, kən kaun-in nərgɨn məmə Iesu, nərgɨn u itəm nagelo təmən-ipən kəm Meri aupən ikɨn, nian in təməsəpək-əpək-inən əh. ");
INSERT INTO tnn_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nian suakəku kit tətaiir, rəhan mama ne tata okuəike mioal sakrifais rəha naruətuəhən tatətəu-pən Lou rəha Moses. Kən inəh, tɨnuwa ətuatɨp e nian rəha Josep ne Meri məmə okioal nəhlan. Kən kialəs suakəku un mian əpəh Jerusalem məmə okioas-ipən kəm Iərəmərə. ");
INSERT INTO tnn_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Inu tatətəu-pən əsas Lou rəha Iərəmərə itəm təmən məmə, “Suakəku iərman mɨn itəm kaupən katɨləs ilat, okəkəike katos-ipən ilat kəm Uhgɨn məmə rəhan.” ");
INSERT INTO tnn_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kən ilau kəmian Jerusalem o nat kit mɨn, məmə ilau okioas mak kəiu o iouen kəiu, kən mohamnu matioas-ipən kəm Uhgɨn o naruətuəhən, tahmen-pən əm e Lou rəha Iərəmərə tatən mihin. ");
INSERT INTO tnn_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kən inəh etəmim kit tətatɨg əh Jerusalem, nərgɨn u Simeon. Rəhan nəmegəhən in tətuatɨp wɨr, kən nian rafin tatətəu-pən nəghatən rəha Uhgɨn. Kən in tatəsahgin nuwamən rəha Kristo itəm otuwa mosmegəh netəm Isrel lan. Kən Narmɨn Rəha Uhgɨn təmuwa mərioah e nɨkin. ");
INSERT INTO tnn_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Narmɨn Rəha Uhgɨn tɨnən rəkɨs kəm in məmə otəsɨmɨsən mətoarus in otehm Kristo itəm Iərəmərə təmən məmə in otahl-ipa. ");
INSERT INTO tnn_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kən Narmɨn Rəha Uhgɨn təməuhlin nɨkin məmə in otuwɨn e Nimə Rəha Uhgɨn. Kən Josep ne Meri kəmialəs suakəku u Iesu mian e Nimə Rəha Uhgɨn məmə ilau okioal natɨmnat rafin itəm Lou tatən. ");
INSERT INTO tnn_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Kən Simeon təməplan Iesu, kən təmɨləs məgəfəlin, kən matənwiwi Uhgɨn, mən-ipən məmə, ");
INSERT INTO tnn_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Iərəmərə, nəmol rafin rəham nəghatən o nəniəkɨsən kəm io, iolwək əm rəham. Kən roiu, egəhan-in io məmə ekɨmɨs-ta e nəməlinuən, ");
INSERT INTO tnn_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","məto-inu enəplan e nɨganəmtək suakəku u itəm otosmegəh netəmim. ");
INSERT INTO tnn_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ik nəmol əpen-əpenə məmə in Iosmegəh, kən netəmim rafin okotəplan. ");
INSERT INTO tnn_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","In otuwa nəhag-əhagən, kən otəgətun rəham suatɨp kəm Iaihluə mɨn, kən netəmim okotɨləs-ipər rəham mɨn netəm Isrel o Iosmegəh əh.” ");
INSERT INTO tnn_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Kən tata ne mama rəha suakəku u, narmɨlau təmiwɨg o nəghatən mɨn itəm Simeon təmən lan. ");
INSERT INTO tnn_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Kən Simeon təməfak məmə nəwɨrən rəha Uhgɨn otuwɨn olau. Kən in təmən kəm Meri itəm in mama rəha suakəku məmə, “Onakatehm, Uhgɨn təmɨtəpun məmə suakəku u otol məmə netəmim tepət əpəh Isrel okoteiuaiu motorin, kən tepət mɨn okotər. Kən in otuwa nəmtətin kit itəm netəmim tepət okotəghat rat lan məmə, ");
INSERT INTO tnn_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","netəmim okotəplan nətəlɨgən mɨn e nɨki netəmim tepət. Kən ik Meri, nɨkim otɨtəgɨt tahmen e suah kit təmaru nɨkim e naip asol.” ");
INSERT INTO tnn_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kən pətaguɨhl kit əh-ikɨn tətatɨg, nərgɨn u Ana, kən in ien kit. In nətɨ Fanuel, etəmim kit itəm təmɨsɨ-pən e noanol rəha Aser aupən ikɨn. Pətaguɨhl əh, rəhan nup tepət. Nian təmatetəm-aluə əm, kən mətəu-pən rəhan iaguɨhl. Kən ilau kəmuan o nup sepɨn əm, kən rəhan iaguɨhl təmɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Kən pətan u təmətatɨg əm nulan mətoarus-pa nian əh in tɨnuwa pətaguɨhl kit. Kən roiu mɨnos nup eiti-fo. Nian rafin in tətatɨg e Nimə Rəha Uhgɨn matəfak, inəh laulaugɨn ne ehnaipən tatətuakəm mətapəs nagwənən matəfak kəm Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kən in təmuwa ikɨn əh e nian ətuatɨp itəm Simeon tatəghat-in suakəku əh. Kən pətaguɨhl u tatənwiwi Uhgɨn ron, kən matəghat-in suakəku əh kəm netəmim rafin itəm kəmoatəsahgin məmə Kristo in otɨkɨs netəm Isrel. ");
INSERT INTO tnn_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nian Josep ne Meri, ilau kəmioal natɨmnat rafin u itəm Lou rəha Iərəmərə təmən, kən kəməhalɨtəlɨg-pən Kalili e taon Nasaret, imələhal ikɨn. ");
INSERT INTO tnn_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kən suakəku təmatepət muwa məskasɨk, kən in tenatɨg tenatɨg wɨr, kən nian rafin nəwɨrən rəha Uhgɨn təmərioah e rəhan nəmegəhən. ");
INSERT INTO tnn_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","E nup mɨn rafin, tata ne mama rəha Iesu katian Jerusalem məmə okotol lafet rəha Nuhagego-inən. ");
INSERT INTO tnn_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nian Iesu tɨnos nup tuelef, təmətəu-pən ilau məhaluwɨn əpəh ilɨs e lafet əh, tahmen-pən əm e nolən rəha netəm Isrel. ");
INSERT INTO tnn_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nian lafet tɨnol namnun, kən rəhan mɨn kɨnotɨtəlɨg mɨnoatuwɨn iməlat ikɨn, məto etəm aluə Iesu in təməsətəu-pənən rəhan tata ne mama, in mətatɨg əm Jerusalem, məto ilau kəməsiatunən. ");
INSERT INTO tnn_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nɨkilau tatəht məmə kətah in tətaliwək ilat nɨmanin netəmim rəhalat, kən ilat kəmotaliwək o nian apiəpiə kit. Kən ilau kəmuətuoun matueam-in o rəhalau mɨn, ne netəmim itəm kiatun ilat. ");
INSERT INTO tnn_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Məto nian ilau kəməsuehmən in, kən kəmiatəlɨg mueam-in mian Jerusalem. ");
INSERT INTO tnn_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kəmueam-in nian kɨsɨl, kən muəplan e Nimə Rəha Uhgɨn, tatəpələh ilat iəgətun mɨn matətəlɨg-in ilat, kən matətapəh olat o natɨmnat neen. ");
INSERT INTO tnn_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kən netəmim rafin itəm kəmotəto in, narmɨlat təmiwɨg pɨk o rəhan nɨtunən ne rəhan nuhalpɨnən nəghatən mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kən nian rəhan tata ne mama kəmuehm, kən narmɨlau təmiwɨg pɨk ron. Kən rəhan mama təmən-ipən kəm in məmə, “Nətɨk. ?Nəmahro mol min-nulan etɨmlau? !Əplan-tu! Itɨmlau rəham tata nɨkitɨmlau təməht pɨk ik, kən iakatuegəs-in pɨk ik.” ");
INSERT INTO tnn_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kən in təmən kəm ilau məmə, “?Natuegəs-in io o naka? ?Nakəsiatunən məmə io ekəkəike mətatɨg e nimə rəha rəhak Tata?” ");
INSERT INTO tnn_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Məto ilau kəməsiatunən nɨpətɨ nəghatən itəm təmən kəm ilau. ");
INSERT INTO tnn_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kən in təmətəu-pən ilau məhaleiuaiu məhaluwɨn əpəh Nasaret. Kən in təmatɨsiai-in ilau matol nəwialau. Məto nian rafin rəhan mama tatətəlɨg-in natɨmnat rafin mɨn əh e nɨkin. ");
INSERT INTO tnn_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Kən Iesu təmatepət e nɨpətɨn, kən rəhan nenatɨgən tatol iahgin, kən e nian mɨn rafin, Uhgɨn ne netəmim, nɨkilat tətagien əm ron. ");
INSERT INTO tnn_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kən uarisɨg e natɨmnat mɨn əh, etəm Rom, nərgɨn u Sisa Taepirias, in tatərəmərə nɨtən mɨn rafin rəha Rom. Kən e nian in təmatərəmərə mətoarus-pa nup fiftin, kən netəm-iasol mɨn neen koatol wək ilat min: inu Herot Antipas təmatərəmərə əpəh Kalili, ne pian Filip in təmatərəmərə əpəh Ituria ne Trakonaetas, ne Lisanias təmatərəmərə əpəh Apilin, ne Pontias Pailat u etəm Rom in kapman rəha Jutia. ");
INSERT INTO tnn_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Inu e nian ətuatɨp rəha Anas ne Kaeafas itəm ilau pris asol agɨn mil. E nian əh, Jon nətɨ Sekaraea, itəm tɨnepət rəkɨs u-roiu, in təmətatɨg əpəh ikɨn taruən-aruən ikɨn, kən Uhgɨn təmos-ipən nəghatən kit kəm in. ");
INSERT INTO tnn_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kən in təmuwɨn mətan ikɨn mɨn rafin iuəhkɨr o nəhau Jotan təmatamnus-iarəp nəghatən rəha Uhgɨn. In təmən-ipən məmə netəmim okotəkəike motəuhlin məntaalat o nolən rat mɨn rəhalat, kən motuwɨn o Uhgɨn, məmə in otafəl nolən rat mɨn rəhalat. Kən e nəmtətin kit, okol baptais elat. ");
INSERT INTO tnn_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","In tahmen əm e nəghatən rəha ien u Aesea itəm təməte e naoa rəhan məmə, “Suah kit tətaun əpəh ikɨn taruən-aruən ikɨn matən məmə, ‘Itəmat, otol əpen-əpenə o suatɨp rəha Iərəmərə, kən motol rəhan suatɨp tətuatɨp. ");
INSERT INTO tnn_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Napin nəhau mɨn rafin okətouɨn wɨr, kən nɨtot mɨn ne narɨt mɨn rafin okos-iəhau, kən suatɨp eko-eko mɨn okəg-ətuatɨp-in, kən suatɨp itəm tapər-apər okəike kol təpiə. ");
INSERT INTO tnn_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kən netəmim rafin okotehm suatɨp rəha Uhgɨn o nosmegəhən netəmim.’” ");
INSERT INTO tnn_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kən e nian əh, netəmim tepət kəmotuwa o Jon məmə in otol baptais elat, məto in təmən-ipən kəm ilat məmə, “!Itəmat nəkotahmen əm e sɨnek mɨn! !Nɨkitəmat otəsəhtən məmə onəkotagɨm tənin neməha ne nalpɨnən rəha Uhgɨn itəm otuwa! ");
INSERT INTO tnn_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Otol natɨmnat neen itəm tatəgətun məmə nəmotapəs pahrien nolən rat mɨn kən motuwɨn o Uhgɨn. Kən sotən atɨpən kəm itəmat e nausitən məmə itəmat nəkotətuatɨp əm məto-inu itəmat noanol mɨn rəha Epraham. !Kəp! Inu nat əpnapɨn əm. Iatən kəm itəmat məmə nat əpnapɨn kəpiel mɨn əm, məto Uhgɨn tɨtun nəuhlinən ilat kotuwa noanol mɨn rəha Epraham. ");
INSERT INTO tnn_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kən inəh roiu ne, Uhgɨn tɨnətul matɨp rəkɨs məmə otahtɨl-pən nɨg əpəh e nəukətɨn. Kən okəmə nɨg kit təsoe-inən noan itəm təwɨr, kən in otahtɨl mərakin-pən e nɨgəm.” ");
INSERT INTO tnn_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kən nɨmanin netəmim kəmotətapəh o Jon məmə, “?Naka u itɨmat ekotəkəike motol?” ");
INSERT INTO tnn_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Kən Jon təmən kəm ilat məmə, “Okəmə rəham napən kəiu, os-ipən kit kəm suah kit itəm rəhan tɨkə, kən okəmə nɨgam nagwənən tatɨg, os-ipən məsɨn kəm netəmim u nɨgɨlat tɨkə.” ");
INSERT INTO tnn_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Netəm neen rəha nosən məni rəha takɨs kəmotuwa məmə otol baptais elat, kən kəmotətapəh o Jon məmə, “?Naka u itɨmat ekotəkəike motol?” ");
INSERT INTO tnn_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Kən Jon təmən-ipən kəm ilat məmə, “Sotosən məni o netəmim taprəkɨs-in itəm tahmen əm məmə onəkotos.” ");
INSERT INTO tnn_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kən mopael mɨn neen kəmotətapəh mɨn, “?Kən tahro etɨmat? ?Naka u itɨmat ekotəkəike motol?” Kən in təmən-ipən kəm ilat məmə, “Sotolən nəgɨnən kəm netəmim məmə, ‘Okəmə nəsotos-ipamən məni, kən oekotol nahməən kəm itəmat.’ Kən sotolən nəgɨnən kəm netəmim məmə, ‘Okəmə nəsotos-ipamən məni, kən oekotən-ipən kəm netəm-iasol məmə nəmotol nat kit tərat.’ Nɨkitəmat otəkəike magien o nos ətuatɨpən nətouən rəhatəmat kən in əm un.” ");
INSERT INTO tnn_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kən netəm mɨn əh koatəsahgin, kən nɨkilat tatəht Jon məmə kətah in Kristo itəm Uhgɨn təmən məmə otahl-ipa. ");
INSERT INTO tnn_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kən Jon təmuhalpɨn rəhalat nətəlɨgən məmə, “Iatol baptais etəmat e nəhau, məto etəmim kit tatuwa itəm rəhan nəsanənən ne nepətən taprəkɨs-in io. Kən io ləhau agɨn, esahmenən məmə ekuwa io slef kit rəhan o nolən rəhan wək. Kən suah əh, in otol baptais etəmat e Narmɨn Rəha Uhgɨn ne nɨgəm. ");
INSERT INTO tnn_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","In tatətul matɨp o nehmən nolən rəha netəmim məmə otoor ilat, netəm kotəwɨr ne netəm kotərat, tahmen-pən e etəm tətasum. Tatɨləs fok o nafəl rəkɨsən nuwigɨ noa wit məmə otos nɨpətɨn itəm təwɨr. Netəmim itəm kotəwɨr kotahmen e nɨpətɨ wit, tatos ilat matuwɨn latuənu. Məto netəmim itəm kotərat kotahmen-pən e nuwigɨ noa wit, tatərakin-pən ilat e nɨgəm asol itəm tatuəp namnun tɨkə.” ");
INSERT INTO tnn_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kən Jon təmamnus-iarəp namnusən təwɨr e nəghatən tepət məmə otiuw-pa nətəlɨgən rəha netəmim kotuwɨn o Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","E nian əh, Herot Antipas təmit-irəkɨs Herotias inu pətaguɨhl rəha pian, kən təmol natɨmnat tepət itəm kotərat. Kən o nolən mɨn əh, Jon təmən əskasɨk məhai Herot Antipas o nolən rat mɨn rəhan. ");
INSERT INTO tnn_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kən Herot Antipas təmatɨg mol mɨn nolən rat kit mɨn taprəkɨs, inəh təmɨləs Jon muwɨn mahtosɨg-in e kalapus. ");
INSERT INTO tnn_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Məto e nian Jon təməsuwɨnən əh e kalapus, kən in təmatol baptais e netəmim mɨn, kən Iesu mɨn in təmuwa, kən Jon təmol baptais lan. Kən nian Iesu təmatəfak, Uhgɨn təmerəh e neai, ");
INSERT INTO tnn_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","kən Narmɨn Rəha Uhgɨn təmɨsɨ-pər matite, nɨpətɨn tahmen-pən e mak muwa məpələh-pər e Iesu, kən nəwia Uhgɨn təmɨsɨ-pən e nego e neai matən məmə, “Ik netɨk keike, ekolkeike pɨk ik, kən nɨkik tagien pɨk agɨn ron ik.” ");
INSERT INTO tnn_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nian Iesu təmətuoun rəhan wək, rəhan nup tahmen-pən e tate. Netəmim nɨkilat tatəht məmə in nətɨ Josep. Kən Josep in nətɨ Heli, ");
INSERT INTO tnn_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli in nətɨ Matat, Matat in nətɨ Lifae, Lifae in nətɨ Melki, Melki in nətɨ Janae, Janae in nətɨ Josep, ");
INSERT INTO tnn_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep in nətɨ Matatias, Matatias in nətɨ Amos, Amos in nətɨ Neham, Neham in nətɨ Esli, Esli in nətɨ Nagae, ");
INSERT INTO tnn_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagae in nətɨ Mahat, Mahat in nətɨ Matatias, Matatias in nətɨ Semein, Semein in nətɨ Josek, Josek in nətɨ Jota, ");
INSERT INTO tnn_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jota in nətɨ Joanan, Joanan in nətɨ Resa, Resa in nətɨ Serupapel, Serupapel in nətɨ Sealtiel, Sealtiel in nətɨ Neri, ");
INSERT INTO tnn_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri in nətɨ Melki, Melki in nətɨ Ati, Ati in nətɨ Kosam, Kosam in nətɨ Elmatam, Elmatam in nətɨ Er, ");
INSERT INTO tnn_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er in nətɨ Josua, Josua in nətɨ Eliesa, Eliesa in nətɨ Jorim, Jorim in nətɨ Matat, Matat in nətɨ Lifae, ");
INSERT INTO tnn_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lifae in nətɨ Simeon, Simeon in nətɨ Juta, Juta in nətɨ Josep, Josep in nətɨ Jonam, Jonam in nətɨ Eliakim, ");
INSERT INTO tnn_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim in nətɨ Melea, Melea in nətɨ Mena, Mena in nətɨ Matata, Matata in nətɨ Natan, Natan in nətɨ Tefɨt, ");
INSERT INTO tnn_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Tefɨt in nətɨ Jese, Jese in nətɨ Opet, Opet in nətɨ Poas, Poas in nətɨ Salmon, Salmon in nətɨ Nason, ");
INSERT INTO tnn_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason in nətɨ Aminatap, Aminatap in nətɨ Atmin, Atmin in nətɨ Ani, Ani in nətɨ Hesron, Hesron in nətɨ Peres, Peres in nətɨ Juta, ");
INSERT INTO tnn_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juta in nətɨ Jekop, Jekop in nətɨ Aisak, Aisak in nətɨ Epraham, Epraham in nətɨ Tera, Tera in nətɨ Nahor, ");
INSERT INTO tnn_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor in nətɨ Seruk, Seruk in nətɨ Rehu, Rehu in nətɨ Pelek, Pelek in nətɨ Eper, Eper in nətɨ Sela, ");
INSERT INTO tnn_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela in nətɨ Kaenan, Kaenan in nətɨ Apaksat, Apaksat in nətɨ Sem, Sem in nətɨ Noah, Noah in nətɨ Lamek, ");
INSERT INTO tnn_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek in nətɨ Metusela, Metusela in nətɨ Inok, Inok in nətɨ Jaret, Jaret in nətɨ Mahalalel, Mahalalel in nətɨ Kenan, ");
INSERT INTO tnn_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan in nətɨ Enos, Enos in nətɨ Set, Set in nətɨ Atam, kən Atam təmɨsɨ-pən e Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Narmɨn Rəha Uhgɨn təmərioah e nəmegəhən rəha Iesu, kən e nian in təmɨsɨ-pən e nəhau Jotan, kən Narmɨn Rəha Uhgɨn təməghat-pən e nɨki Iesu məmə in otuwɨn əpəh ikɨn taruən-aruən ikɨn. ");
INSERT INTO tnn_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kən e nian foti, Setan təmos-ipən-os-ipən kəm Iesu. E nian mɨn rafin əh, in təməsagwənən, kən e namnun nian mɨn əh, nəumɨs təmus wɨr in. ");
INSERT INTO tnn_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kən Setan təmən-ipən kəm Iesu məmə, “Okəmə ik Nətɨ Uhgɨn, ən-ipən kəm kəpiel u məmə otəuhlin muwa mol pɨret lan.” ");
INSERT INTO tnn_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Kən Iesu təmuhalpɨn məmə, “Kəməte e Naoa Rəha Uhgɨn məmə, ‘Netəmim okol kəsotatɨgən e nagwənən əm’” ");
INSERT INTO tnn_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kən Setan təmit Iesu mian əpəh nɨtot əfəməh kit, kən roiu agɨn-əh mɨn əm, təməgətun in e kantri mɨn rafin e nətueintən, ne nəsanənən rəhalat, ");
INSERT INTO tnn_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","kən təmən-ipən kəm in məmə, “Io ekələhəu-pɨnə e nelməm nərəmərəən e nɨməptən mɨn, ne nautə rəhalat mɨn rafin, məto-inu natɨmnat rafin əh tətatɨg e nelmək, kən ekɨtun negəhan-inən kəm etəmim pah itəm iakolkeike məmə ekos-ipən kəm in. ");
INSERT INTO tnn_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Məto okəmə ik onakəfak kəm io, kən natɨmnat rafin mɨn u, okotuwa rəham.” ");
INSERT INTO tnn_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kən Iesu təmuhalpɨn rəhan nəghatən məmə, “Naoa Rəha Uhgɨn tatən məmə, ‘Onəkotəfak əm kəm rəhatəmat Iərəmərə Uhgɨn, kən in əm, onəkotol əm rəhan nətəlɨgən.’” ");
INSERT INTO tnn_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kən Setan təmit in mɨnuwɨn əpəh Jerusalem e nətuei nimə əpəh ilɨs agɨn e Nimə Rəha Uhgɨn. Kən təmən-ipən kəm in məmə, “Okəmə ik Nətɨ Uhgɨn, kən iwɨg ukɨn-u, ");
INSERT INTO tnn_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","məto-inu kəməte-pən e Naoa Rəha Uhgɨn məmə, ‘In otahl-ipa nagelo mɨn rəhan okotuwa motehm wɨr ik,’ ");
INSERT INTO tnn_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","kən təməte-pən məmə, ‘Okotɨləs ik ilɨs e nelmɨlat məmə onəkəsorinən nelkəm e kəpiel.’” ");
INSERT INTO tnn_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Kən Iesu təmuhalpɨn rəhan nəghatən məmə, “Naoa Rəha Uhgɨn tatən mɨn məmə, ‘Okol nəkəsotos-ipən-os-ipənən kəm rəhatəmat Iərəmərə Uhgɨn məmə otol nat kit, kən məmə onəkotəplan məmə in tətatɨg itəmat min, o kəp.’” ");
INSERT INTO tnn_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kən nian Setan tɨnol namnun rafin nos-ipən-os-ipənən rəhan, in təmagɨm muwɨn isəu o Iesu matəsahgin məmə nian wɨr kit mɨn rəhan otəpanuwa mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kən Iesu təmɨtəlɨg-pən Kalili, kən nəsanənən rəha Narmɨn Rəha Uhgɨn təmərioah e nəmegəhən rəhan. Kən kəmamnus-amnus in tɨtəlau e nɨməptən əh. ");
INSERT INTO tnn_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kən Iesu təməgətun e nimə rəha nuəfɨmɨnən mɨn, kən netəmim rafin koatənwiwi in. ");
INSERT INTO tnn_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kən Iesu təmuwa Nasaret, ikɨn əh in təmepət ikɨn aupən. Kən e nian rəha Sapat, in təmuwɨn e nimə rəha nuəfɨmɨnən tahmen əm məmə in təmatol mihin nian mɨn. Kən in təmətul məmə otafin Naoa Rəha Uhgɨn, ");
INSERT INTO tnn_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","kən kəmos-ipən naoa itəm kəmaiu-aiu rəha ien u Aesea. Kən in təmurapɨk itəm Aesea təməte-pən tatən nəhlan məmə, ");
INSERT INTO tnn_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Narmɨn Rəha Uhgɨn tətatɨg lak məto-inu təmɨtəpun io məmə ekən-iarəp namnusən təwɨr kəm ian-rat mɨn. Kən təmahl-ipa io məmə ekuwɨn mən-ipən kəm netəm kotatɨg e kalapus məmə ekɨkɨs ilat, kən mahl-iarəp ilat, kən mən-ipən kəm iganəmtɨn əpɨs mɨn məmə okotehm mɨn nat. Kən təmahl-ipən io məmə ekuwɨn mɨkɨs nɨkin rat mɨn itəm kotatɨg e nelmɨn netəm pɨsɨn, itəm koatol tərat kəm ilat, ");
INSERT INTO tnn_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","kən mən-iarəp məmə nian tɨnuwa rəkɨs məmə Iərəmərə otəgətun rəhan nəwɨrən kən mosmegəh netəmim.” ");
INSERT INTO tnn_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Təmafin rəkɨs naoa un, kən maiuaiu mɨn mos-ipən tɨtəlɨg-pən o etəm tatehm wɨr naoa mɨn, kən təməpələh məmə otəgətun netəmim. Kən nɨganəmtɨ netəmim rafin e nimə rəha nuəfɨmɨnən təmatətul əm lan. ");
INSERT INTO tnn_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kən in təmatəghat kəm ilat matən min-nulan məmə, “Roiu agɨn e nian itəm nakoatətəlɨg lan e Naoa Rəha Uhgɨn, Uhgɨn tatol əp nəghatən mɨn əh məmə tɨnatuwa otol nɨpahrienən.” ");
INSERT INTO tnn_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Netəmim rafin koatənwiwi in, kən narmɨlat tatiwɨg o nəghatən wɨr mɨn itəm tatən, kən motən kəm ilat mɨn məmə, “?Nətɨ Josep u, o kəp?” ");
INSERT INTO tnn_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kən Iesu təmən-ipən kəm ilat məmə, “Ekɨtun məmə onakoatən nəghatən oas u kəm io u tatən min-nulan məmə, ‘Tokita, ol-wɨr atɨp-tu nɨpətɨm,’ u nɨpətɨn məmə, ‘Natɨmnat mɨn əh itəm katən məmə nəmol rəkɨs ilat əpəh Kapaneam, təwɨr məmə nakuwa mol mɨn ilat ikɨn-u imam ikɨn.’ ");
INSERT INTO tnn_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nɨpahrienən, iakatən kəm itəmat məmə netəmim okol kəsotɨsiai-inən ien kit itəm təmɨsɨ-pən elat. ");
INSERT INTO tnn_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","E nian rəha Elaija, nuhuən təməsəfɨkən mos nup kɨsɨl ne məwɨg sikis, kən nəumɨs təman ikɨn mɨn rafin nagwənən təmɨkə. Kən ekən nɨpahrienən kəm itəmat məmə, e nian əh, nəutahlɨmɨs tepət ikɨn-u Isrel, ");
INSERT INTO tnn_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","məto Uhgɨn təməsahl-ipənən Elaija məmə otuwɨn masitu elat. Kəp. In təmahl-ipən məmə otasitu əm e nəutahlɨmɨs kit əpəh ikɨn Saeton e taon Sarefat, kən pətan u in Iaihluə kit. ");
INSERT INTO tnn_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kən e nian rəha ien Elisa, netəmim tepət kəmotatɨg Isrel itəm kəmoatos nɨmɨsən rəha nuwigɨtəm u leprosi, kən Elisa təməsol-wɨrən kit ne. Məto in təmol-wɨr əm Neman u etəm Siria, Iaihluə kit.” ");
INSERT INTO tnn_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kən e nian netəmim e nimə rəha nuəfɨmɨnən kəmotəto nəghatən əh, neməha təmol pɨk ilat. ");
INSERT INTO tnn_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kən kəmotəruapɨk kətul motaskəlɨm Iesu, motɨləs motiet e taon, motuwɨn əpəh lekiəkɨs e nɨkalɨ taon məmə okotərakin-iarəp. ");
INSERT INTO tnn_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Məto Iesu təmaliwək əm miet ilugɨn-in ilat mɨnatuwɨn. ");
INSERT INTO tnn_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kən Iesu təmeiuaiu muwɨn əpəh Kapaneam, taon kit mɨn rəha Kalili. Kən e nian rəha Sapat, in təmatəgətun netəmim. ");
INSERT INTO tnn_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Kən netəmim itəm kəmoatəto rəhan nəgətunən, narmɨlat təmiwɨg pɨk ron məto-inu rəhan nəghatən təfɨgəm, nepətən əh-ikɨn. ");
INSERT INTO tnn_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kən in əpəh imə e nimə rəha nuəfɨmɨnən, kən suah kit əh-ikɨn itəm narmɨn rat kit tətatɨg lan. Kən in təmagət əfəməh məmə, ");
INSERT INTO tnn_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“!Ei, Iesu etəm Nasaret! ?Tahro? ?Nəmatuwa məmə onakərəkɨn itɨmat? Ekɨtun rəkɨs ik. !Ik Etəm Asim rəha Uhgɨn!” ");
INSERT INTO tnn_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Məto Iesu təməghat əskasɨk lan məmə, “!Ahh, sagətən! !Iet magɨm e suah un!” Kən narmɨn rat əh təmol suah un tiet morin-pən e nɨməptən ilugɨn-in ilat, kən in təmiet magɨm lan, məto təməsərəkɨnən suah un. ");
INSERT INTO tnn_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kən netəmim rafin ikɨn əh, narmɨlat təmiwɨg kən moatən-ipən kəm ilat mɨn məmə, “!Ei! ?Nəgətunən naka u? Suah əh, in tatəghat əskasɨk e narmɨn rat mɨn e nəghatən rəha nepətən ne nəsanənən, kən ilat koatiet e netəmim.” ");
INSERT INTO tnn_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kən namnusən rəha Iesu təmaiu mɨtəlau e nɨtən əh. ");
INSERT INTO tnn_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iesu təmətul kən miet e nimə rəha nuəfɨmɨnən muwɨn əpəh e nimə rəha Saimon. E nian əh, uhu Saimon tatɨmɨs tatətəp-ətəp asol, kən ilat kəmotən-ipən kəm Iesu məmə otol-wɨr. ");
INSERT INTO tnn_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Kən Iesu təmətul-pən iuəhkɨr ron məghat əskasɨk kəm nətəp-ətəpən, kən nətəp-ətəpən təmɨkə. Kən roiu agɨn-əh mɨn əm, pətaguɨhl u təmətul mɨnatol nagwənən nɨgɨlat. ");
INSERT INTO tnn_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nian mɨt tɨniwɨg rəkɨs, netəmim kəmotos netəmim rafin itəm koatɨmɨs e nɨmɨsən pɨsɨn pɨsɨn mɨn moatuwa o Iesu. Kən təmələhəu-pən nelmɨn elat kitiəh kitiəh, kən ilat rafin kəmotəmegəh. ");
INSERT INTO tnn_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kən iərmɨs mɨn kəmotiet motagɨm e netəmim tepət motagət əfəməh məmə, “!Ik Nətɨ Uhgɨn!” Məto Iesu təmagət əskasɨk elat mahtosɨg-in ilat o nəghatən məto-inu ilat kotɨtun məmə in Kristo itəm Uhgɨn təmahl-ipa. ");
INSERT INTO tnn_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kən kəmən lawɨgin, Iesu təmiet ikɨn əh muwɨn əpəh ikɨn kit itəm netəmim kotɨkə ikɨn. Məto netəmim kəmoteam-in, kən nian kəmotehm, kən kəmotuwa ron motalkut məmə okotən-iəhau məmə in otəsagɨmən mapəs ilat. ");
INSERT INTO tnn_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Məto in təmən-ipən kəm ilat məmə, “Kəp. Io ekəkəike muwɨn latuənu pɨsɨn mɨn neen, mən-iarəp namnusən təwɨr rəha nərəmərəən rəha Uhgɨn, məto-inu Uhgɨn təmahl-ipa io məmə ekol mihin.” ");
INSERT INTO tnn_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kən in təmatuwɨn mətan nɨtən Jutia matən-iarəp nəghatən rəha Uhgɨn e nimə rəha nuəfɨmɨnən mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nian kit, Iesu təmatətul e nɨkalɨ nəhau asol, nərgɨn u Lek Kalili. Kən nɨmanin netəmim kəmotuwa kətul kɨtəlau lan məmə okotəto nəghatən rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kən in təmehm pot kəiu itəm netəm rəha niuwən nəm kəmotapəs katuəməhl e noa nɨməkləkɨl, məto-inu ilat kotaikuas e rehalat net mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Kən Iesu təmər e pot rəha Saimon, kən in təmətapəh o Saimon məmə otiuw-iarəp pot tuwɨn ihluə məsɨn. Nian Saimon təmətɨg-iarəp pot, kən Iesu təməpələh lan matəgətun netəmim. ");
INSERT INTO tnn_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nian Iesu təməghat rəkɨs kəm netəmim, kən mən-ipən kəm Saimon məmə, “Saimon, otasuə kotuwɨn əpəh lokamnɨm, kən nakotərakin rəhatəmat net məmə nakotos nəm neen.” ");
INSERT INTO tnn_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Kən Saimon təmən məmə, “Etəm-iasol, lapɨn itɨmat emotalkut pɨk o nat u mətoahgin-pa tɨnian, məto eməsotosən nəm kit ne. Məto ik nɨnən mɨn məmə okotuwɨn, kən tol nəhlan, pəs okotuwɨn mɨn motərakin rəhatɨmat net mɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kən e nian kəmotol min-nəhlan, kəmotos nəm tepət tepət e rəhalat net, kən net mɨn rəhalat kəmotər kasis wɨr e nəm mɨn, kən net mɨn kɨnotətuoun mɨnotəhap-əhap. ");
INSERT INTO tnn_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kən ilat kəmotaun-in-pən ilat mɨn neen e pot kit mɨn məmə okotuwa kasitu elat. !Kən kəmotuwa kəmki-pən nəm e pot kərən mil kuər mərioah e nəm, iuəhkɨr əm pot mil kətuamnɨm! ");
INSERT INTO tnn_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nian Saimon Pita təmehm nat u, kən təmɨsin-pən nulɨn o Iesu e nɨsiaiiən matən məmə, “!Iərəmərə, uwɨn isəu ron io məto-inu, io esahmenən, io iol təfagə rat!” ");
INSERT INTO tnn_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","In tatəghat min-nulan məto-inu in ne netəm mɨn əh e pot mil, kəmotaut pɨk narmɨlat tiwɨg o nəm mɨn itəm kotepət pɨk nəhlan. ");
INSERT INTO tnn_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Kən Jemes ne Jon, nətɨ Sepeti mil itəm kətəhalol wək iləhal Saimon, ilau mɨn kəmuaut pɨk narmɨlau tiwɨg o nəm mɨn u. Məto Iesu təmən-ipən kəm Saimon məmə, “Əsəgɨnən. Ik etəmim rəha niuwən nəm, məto roiu əh matuwɨn, ik onakiuw-pa netəmim.” ");
INSERT INTO tnn_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kən e nian ilat kəmotiuw-par rəhalat pot mɨn, kən moatapəs natɨmnat rafin motuarisɨg-in əm Iesu, kən motuwa rəhan mɨn netəmim. ");
INSERT INTO tnn_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nian Iesu təmətaliwək e taon kit, suah kit itəm tatos nɨmɨsən u leprosi təmaliwək muwa. Nɨmɨsən u leprosi təmɨrəfin nɨpətɨn. Kən nian in təmehm Iesu, təmeiuaiu mɨsin-pən nɨpɨnəgɨn e nɨsɨp matos-ipən nɨsiaiiən kəm in, kən in təmətasək matəkəike ron matən məmə, “Iərəmərə, okəmə nakolkeike, kən nəkɨtun nol-wɨrən io, kən mafəl rəkɨs namkɨmɨkən lak.” ");
INSERT INTO tnn_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Kən Iesu təməg-əfəməhin-pən nelmɨn mələhəu-pən lan mən məmə, “Əwəh. Iakolkeike. !Əwɨr-ta!” Kən roiu agɨn-əh əm, nɨmɨsən u leprosi təmagɨm mɨkə lan. ");
INSERT INTO tnn_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kən Iesu təmən-iəhau məmə otəsən-iarəpən natɨmnat mɨn u kəm netəmim, məto in təmən-ipən kəm in məmə, “Uwɨn mehm pris kit pəs in otehm məmə nɨpətɨm tɨnol min-nulan, kən os-ipən sakrifais kəm Uhgɨn itəm Lou rəha Moses təmən o suah kit itəm rəhan leprosi tatɨkə, kən netəmim okotɨtun məmə nɨpahrienən nɨnəwɨr, kən rəham namkɨmɨkən tɨnɨkə.” ");
INSERT INTO tnn_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Məto namnusən rəha Iesu tatiet matuwɨn ikɨn mɨn rafin, kən nɨmanin netəmim kəmotuwa məmə okotətəlɨg-in rəhan nəgətunən kən məmə in otol-wɨr nɨmɨsən mɨn rəhalat. ");
INSERT INTO tnn_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Məto nian tepət, tatuwɨn ikɨn taruən-aruən ikɨn, in pɨsɨn əm, məmə otatəfak. ");
INSERT INTO tnn_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nian kit, Iesu təmatəgətun əpəh imə e nimə kit, kən Farisi mɨn, ne iəgətun mɨn rəha Lou, ilat əh-ikɨn koatəpələh, kəmotɨsɨ-pən əpəh latuənu mɨn e nɨtən Kalili, ne nɨtən Jutia, ne taon Jerusalem. Kən nəsanənən rəha Iərəmərə tətatɨg o Iesu məmə in otol-wɨr netəmim u koatɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","E nian əh, netəmim neen kəmotɨləs suah kit motuwa itəm tətapɨl əm e nɨmɨtiwɨn rəhan məto-inu nɨpətɨn məsɨn təmɨmɨs. Kən ilat kotolkeike məmə okotɨləs motələhəu-pən e nelkɨ Iesu. ");
INSERT INTO tnn_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Məto ilat kotəruru nuwɨnən imə məto-inu netəmim tepət əh-ikɨn. Kən kəmotuwɨn əpəh ilɨs e nimə motos-irəkɨs nəhgɨ nimə məsɨn, kən motəhlman-əhlman suah un tatite e nɨmɨtiwɨn rəhan muwɨn iuəhkɨr əm o Iesu. ");
INSERT INTO tnn_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nian Iesu təmehm rəhalat nahatətəən, kən təmən məmə, “Iolɨk. Rəham nolən rat mɨn, io emos-irəkɨs.” ");
INSERT INTO tnn_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Kən iəgətun mɨn rəha Lou ne Farisi mɨn nɨkilat təht məmə, “?Etəmim naka u tatəghat ausit məmə in Uhgɨn? Uhgɨn əm in tɨtun nos-irəkɨsən nolən rat mɨn rəha netəmim.” ");
INSERT INTO tnn_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iesu in tɨtun əm rəhalat nətəlɨgən, kən in təmən-ipən kəm ilat məmə, “?Tahro nakoatətəlɨg min-nulan? ");
INSERT INTO tnn_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","?Naka in tɨmətɨg məmə ekən, ‘Ekos-irəkɨs rəham tefagə rat mɨn,’ o ‘Ətul maliwək’? ");
INSERT INTO tnn_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kən roiu onəkotehm məmə Nətɨ Etəmim tatos nepətən o nos-irəkɨsən təfagə rat mɨn ikɨn-u e nətueintən.” Kən in təmən kəm suah u tatɨmɨs məmə, “Ətul, mɨləs rəham nɨmɨtiwɨn maliwək matuwɨn imam ikɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kən roiu agɨn-əh mɨn, suah u təmətul mɨləs rəhan nɨmɨtiwɨn mɨnataliwək matənwiwi Uhgɨn mɨnatuwɨn. ");
INSERT INTO tnn_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kən ilat rafin kəmotaut pɨk ron narmɨlat tiwɨg, kən moatənwiwi nərgɨ Uhgɨn, kən motasiəp kən moatəgɨn məsɨn moatən məmə, “Nəman, roiu kitat kəmotehm nat pɨspɨs agɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Uarisɨg e natɨmnat mɨn u, Iesu təmiet maliwək matuwɨn, kən in təmehm suah kit itəm tatos məni rəha takɨs, nərgɨn u Lifae, tatəpələh ikɨn katətou takɨs ikɨn. Kən Iesu təmən-ipən kəm in məmə, “Wa, muarisɨg-in io muwa rəhak etəmim.” ");
INSERT INTO tnn_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kən in təmapəs natɨmnat mɨn rafin rəhan, mətul muarisɨg-in Iesu. ");
INSERT INTO tnn_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kən Lifae təmol nagwənən asol kit rəha Iesu əpəh e rəhan nimə. Kən netəmim tepət itəm koatos məni rəha takɨs, ne netəmim əpnapɨn mɨn kəmotuwa moatəpələh kələh ilat min ilat məmə okotagwən. ");
INSERT INTO tnn_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kən Farisi mɨn ne netəmim neen mɨn rəhalat itəm iəgətun mɨn rəha Lou, nɨkilat təsagienən kən moatən-ən kəm netəmim rəha Iesu məmə, “?Tahro itəmat nakotagwən kələh əm itəmat netəmim itəm koatos məni rəha takɨs ne netəm nol təfagə rat?” ");
INSERT INTO tnn_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Kən Iesu təmən-ipən kəm ilat məmə, “Etəmim itəm in təsɨmɨsən, təsuwɨnən mehm tokita. Məto etəm tatɨmɨs, in otəkəike muwɨn mehm tokita. ");
INSERT INTO tnn_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Io eməsuwamən məmə ekaun-in netəm itəm nɨkilat təht məmə kotətuatɨp rəkɨs məmə okotəuhlin nətəlɨgən rəhalat o nolən tərat mɨn itəm koatol. Məto emuwa məmə ekaun-in netəm kotərat məmə okotəuhlin rəhalat nətəlɨgən.” ");
INSERT INTO tnn_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kən ilat kəmotən-ipən kəm Iesu məmə, “Netəmim rəha Jon Baptais, nian rafin koatapəs nagwənən kən katəfak kəm Uhgɨn, kən netəmim rəha Farisi mɨn koatol əm nat kitiəh, məto rəham netəmim mɨn kotagwən əm katɨlpɨn. ?Tahro?” ");
INSERT INTO tnn_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Kən Iesu təmən-ipən kəm ilat məmə, “?Nian itəmat nəkoatol nagwənən rəha etəmim itəm təmol əm marɨt, məto nakotən kəm rəhan mɨn məmə okotəkəike motapəs nunən nagwənən, o kəp? !Kəp! ");
INSERT INTO tnn_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Məto nian tatuwa itəm netəmim okotɨləs-irəkɨs suah u itəm təmol əm marɨt motɨləs kan isəu o rəhan mɨn netəmim. Kən e nian əh inəh, ilat okotapəs nagwənən lan.” ");
INSERT INTO tnn_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kən Iesu təmuəh mɨn nimaa nəghatən kit tol min-nulan məmə, “Okol suah kit təsosən napən wi rəhan məhap məsɨn, kən məhl-pən e napən oas məmə otəhlosɨg-in itəm təmerəh. Məto okəmə tatol nəhlan, kən otərəkɨn rəhan napən wi, kən napən wi məsɨn okol təsəhl-pən wɨrən ilau napən oas. ");
INSERT INTO tnn_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Kən okol suah kit təsosən wain wi miuw-pən e pətəl oas u təskasɨk, pətəl itəm kəmol e nuwigɨ nəni. Okəmə suah kit tatol min-nəhlan, kən wain wi otahləpɨk kən mol pətəl oas in otasis kən mɨmerəh mahtɨperəh, kən wain in otaiu meləg, kən pətəl mɨn, in otərat. ");
INSERT INTO tnn_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Məto wain wi okəkəike kiuw-pən e pətəl wi. ");
INSERT INTO tnn_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kən etəmim itəm təmənɨm wain oas rəkɨs, in təsolkeikeən məmə otənɨm mɨn wain wi, məto-inu in otən məmə, ‘Wain oas in təwɨr.’” ");
INSERT INTO tnn_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nian kit e Sapat, Iesu ne rəhan mɨn netəmim kəmotaliwək motuwa e nasumən mɨn rəha wit, nat kit tahmen e rais, kən rəhan mɨn netəmim kəmotəhl wit neen motawig rəkɨs nɨwin, kən moatun. ");
INSERT INTO tnn_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Məto Farisi mɨn neen koatən məmə, “!Ei! Nian u-roiu in Sapat, kən nolən u nəkoatol tatətgəhl Lou. ?Tahro itəmat nəkoatol min-nəhlan?” ");
INSERT INTO tnn_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Kən Iesu təmən-ipən kəm ilat məmə, “?Itəmat nəsotafinən e Naoa Rəha Uhgɨn, natɨmnat mɨn əh itəm Kig Tefɨt təmol aupən? In ne rəhan mɨn netəmim, nəumɨs təmus ilat. ");
INSERT INTO tnn_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kən in təmuwɨn imə e nimə tapolən rəha Uhgɨn, təmos pɨret u itəm pris mɨn kɨnotos-ipən rəkɨs kəm Uhgɨn. Kən Lou tatən məmə pris mɨn əm kotɨtun nunən, məto Tefɨt təmun kən mos-ipən neen kəm rəhan mɨn netəmim məmə okotun.” ");
INSERT INTO tnn_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kən Iesu təmən-ipən kəm ilat məmə, “Io, Nətɨ Etəmim, ekatərəmərə e nian rəha Sapat.” ");
INSERT INTO tnn_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kən e nian pɨsɨn kit mɨn rəha Sapat, Iesu təmuwɨn əpəh imə e nimə rəha nuəfɨmɨnən, matəgətun netəmim. Kən ikɨn əh, suah kit əh-ikɨn nelmɨn matɨp təmɨmɨs, təsəg-ətuatɨp-inən. ");
INSERT INTO tnn_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kən iəgətun mɨn rəha Lou, ne Farisi mɨn, ilat koatalkəlɨk məmə okotehm-tu Iesu məmə otol-wɨr suah u e nian rəha Sapat, pəs ilat kotɨtun nənən məmə Iesu təmətgəhl Lou. ");
INSERT INTO tnn_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Məto Iesu təmɨtun əm rəhalat nətəlɨgən, kən təmən-ipən kəm suah u itəm nəlmɨn təmɨmɨs məmə, “Wa, mətul aupən e nɨganəmtɨ netəmim rafin.” Kən təmuwɨn mətul-pən əh aupən. ");
INSERT INTO tnn_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kən Iesu təmən-ipən kəm ilat məmə, “Iakolkeike məmə ekətapəh-in nat kit otəmat. ?Tahro? ?E nian rəha Sapat, nolən naka in tətuatɨp e Lou məmə okol, okol nat wɨr, o okol nat tərat? ?Okosmegəh etəmim, o okohamnu etəmim?” ");
INSERT INTO tnn_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Kən təmɨsɨlu ilat rafin mɨtəlau, kən təmən-ipən kəm etəm nelmɨn təmɨmɨs məmə, “Əg-ətuatɨp-in nelməm.” Kən suah əh təməg-ətuatɨp-in nelmɨn, kən nelmɨn təməwɨr. ");
INSERT INTO tnn_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Məto netəm mɨn əh, nɨkilat tɨnərat pɨk agɨn, kən kɨnoatəghat-əghat kəm ilat mɨn məmə okotahro e suah əh Iesu. ");
INSERT INTO tnn_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kən e nian mɨn əh, Iesu təmuwɨn əpəh ilɨs e nɨtot məmə otəfak, kən in təmətatɨg matəfak kəm Uhgɨn e nian əh mətoarus tian. ");
INSERT INTO tnn_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kən tɨnian, təmaun-in rəhan mɨn netəmim məmə okotuwa kehm. Kən təmɨtəpun rəkɨs tuelef, maun-in nərgɨlat məmə aposol mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nərgɨ aposol mɨn u tol min-nulan: Saimon itəm Iesu təmaun-in nərgɨn wi məmə Pita, ne pian Antru, ne Jemes ne Jon, ne Filip, ne Patolomiu, ");
INSERT INTO tnn_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ne Matiu, ne Tomas, ne Jemes nətɨ Alfeas, ne Saimon u kətaun-in məmə Selot, ");
INSERT INTO tnn_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ne Jutas nətɨ Jemes, ne Jutas Iskariot itəm təmegəhan-in-pən Iesu kəm rəhan mɨn tɨkɨmɨr mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kən Iesu ne rəhan aposol mɨn kəmotiet e nɨtot u moteiuaiu motuwa motatɨg e nɨtən iəməhl ilat rəhan netəmim tepət, ne nɨmanin netəmim tepət mɨn kəmotɨsɨ-pən nɨtən Jutia, ne Jerusalem, ne nɨkalkal nɨtəhəi ikɨn Taea ne Saeton. ");
INSERT INTO tnn_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ilat kəmotuwa məmə okotəto nəghatən rəha Iesu kən məmə in otol-wɨr nɨmɨsən mɨn rəhalat. Kən in təmol-wɨr netəmim itəm narmɨn rat mɨn kəmoatərəkɨn ilat. ");
INSERT INTO tnn_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kən netəmim itəm kəmotətul moatɨtəlau lan, kəmotalkut məmə okotek məto-inu nəsanənən tatɨsɨ-pən lan matol-wɨr ilat rafin. ");
INSERT INTO tnn_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Kən Iesu təmasɨpən mehm rəhan mɨn netəmim, kən tən-ipən kəm ilat məmə, “Itəmat u ian-rat mɨn, nakoatatɨg e nəwɨrən pahrien. In nəwɨrən pahrien məto-inu, itəmat netəmim rəha Uhgɨn, kən in tatərəmərə etəmat. ");
INSERT INTO tnn_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Itəmat itəm nakoteam-in nagwənən əh-roiu, nakoatatɨg e nəwɨrən pahrien. In nəwɨrən pahrien məto-inu, onəkotən məmə, ‘Əwəh, tahmen.’ Itəmat itəm nakotasək əh-roiu, nakoatatɨg e nəwɨrən pahrien. In nəwɨrən pahrien məto-inu onəkotalah. ");
INSERT INTO tnn_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nakoatatɨg e nəwɨrən pahrien nian netəmim koatetəhau itəmat, kən kəsegəhan-inən itəmat məmə onəkotol natɨmnat kitiəh itəmat min ilat, kən katən rat itəmat, kən katərəkɨn-rəkɨn nərgɨtəmat məmə itəmat rəha iərmɨs mɨn, kən ilat koatol nolən mɨn əh kəm itəmat məto-inu io Nətɨ Etəmim, kən itəmat rəhak mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“E nian mɨn əh, otagien, kən motətɨp-ətɨp e nagienən məto-inu nətouən asol rəhatəmat rəha natɨmnat mɨn əh tətatɨg əpəh e nego e neai. Nɨkitəmat otagien məto-inu tɨpɨlat mɨn kəmoatol nolən kitiəh əm kəm ien mɨn aupən ikɨn. ");
INSERT INTO tnn_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Məto, kəsi, nahməən asol otuwa otəmat itəm rəhatəmat nautə tepət roiu məto-inu, nɨnotos rəkɨs nagienən rafin itəm onəkotos. ");
INSERT INTO tnn_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kəsi, nahməən asol otuwa otəmat itəm nakotagwən pɨk moatəto təwɨr lan əh-roiu məto-inu, nəumɨs otəpanus itəmat. Kəsi, nahməən asol otuwa otəmat itəm nakotalah əh-roiu məto-inu, nəpanotasək onəkotasək agɨn. ");
INSERT INTO tnn_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kəsi, nahməən asol otuwa otəmat nian netəmim koatɨləs-ipər nərgɨtəmat məto-inu, tɨpɨlat mɨn kəmotɨləs-ipər mihin nərgɨ ien eiueiuə mɨn aupən ikɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Kən təmən mɨn məmə, “Məto ekatən kəm itəmat itəm nakoatətəlɨg-in motɨtun məmə, nəkotəkəike motolkeike rəhatəmat tɨkɨmɨr mɨn, kən motol təwɨr kəm netəm koatetəhau itəmat, ");
INSERT INTO tnn_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","kən nian netəmim koatau iərmɨs-in itəmat, məto itəmat onakotətapəh-in o Uhgɨn məmə otos-ipən rəhan nəwɨrən kəm ilat, kən onəkotəfak o netəmim itəm koatol tərat kəm itəmat. ");
INSERT INTO tnn_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Okəmə suah kit tatem nɨkapɨm, kən ahwin-pən nɨkalɨn kit mɨn tem. Okəmə suah kit tatɨləs rəham kot, kən atətul matɨp o nos-ipən mɨnən rəham sot. ");
INSERT INTO tnn_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Os-ipən nat naka kəm etəmim kit itəm tateasiə-in ron ik, kən etəmim itəm təmos rəham neen natɨmnat, apəs əm, məsətapəh-inən. ");
INSERT INTO tnn_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kən otol təwɨr kəm netəmim rafin e nolən mɨn rafin itəm nakotolkeike məmə netəmim okotol min kəm itəmat. ");
INSERT INTO tnn_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“?Okəmə nakotolkeike əm netəm mɨn u koatolkeike itəmat, nɨkitəmat təht məmə okɨləs-ipər itəmat ron? Kəp. Netəm rat, ilat mɨn koatol təwɨr kəm ilat mɨn, kən moatolkeike ilat mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","?Kən okəmə nəkoatol əm təwɨr kəm netəm mɨn əh itəm koatol təwɨr kəm itəmat, nɨkitəmat təht məmə okɨləs-ipər itəmat ron? Kəp. Netəm rat, ilat mɨn koatol əm nat kitiəh mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","?Kən okəmə nakoategəhan-in natɨmnat kəm netəmim neen itəm ilat kotɨtun nos-ipa mɨnən nɨtain, nɨkitəmat təht məmə okɨləs-ipər itəmat ron? Kəp. Netəm rat, ilat mɨn koategəhan-in natɨmnat kəm ilat mɨn məmə nian kit kəpanotos-ipən mɨn nɨtain tahmen. ");
INSERT INTO tnn_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Məto nəkotəkəike motolkeike rəhatəmat tɨkɨmɨr mɨn, kən moatol təwɨr kəm ilat, kən moategəhan-in natɨmnat itəm kəmotos məmə okəsotalpɨnən. Okəmə nəkotol nəhlan, kən rəhatəmat nətouən asol tətatɨg, kən nakotuwa nenətɨ Uhgɨn Ilɨs Agɨn, məto-inu in tatol təwɨr kəm netəm naumɨs mɨn, kən tatol təwɨr mɨn kəm netəmim itəm kəsotənən məmə nɨkilat tagien o natɨmnat wɨr itəm in tatol kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Otasəkitun netəmim tahmen əm e rəhatəmat Tata tətasəkitun netəmim.” ");
INSERT INTO tnn_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Kən Iesu təmən məmə, “Əsənən nolən rəha etəmim məmə in tərat, kən pəs kəsənən rəham nolən məmə in tərat; əsənən məmə suah kit otəkəike mos nalpɨnən o təfagə rat kit rəhan, kən pəs kəsənən məmə ik onakəkəike mos nalpɨnən o təfagə rat kit rəham; aluin nolən rat rəha etəmim itəm təmol kəm ik, kən pəs kaluin nolən rat rəham. ");
INSERT INTO tnn_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Awte kən məhan nelməm kəm netəmim, kən kos-ipɨnə natɨmnat kəm ik, natɨmnat tepət tepət itəm kəmaii-pən kasin-asin kəgətain, tər matərioah itəm okələhəu-pən ilat e nelməm. Okəmə natos-ipən tepət, okos-ipɨnə tepət kəm ik, məto okəmə natos-ipən noan məsɨn əm, okos-ipɨnə noan məsɨn əm kəm ik.” ");
INSERT INTO tnn_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kən in təmuəh nimaa nəghatən kəm ilat məmə, “Iganəmtɨn əpɨs ko təsitən iganəmtɨn əpɨs kit mɨn. !Kəsi, okiaiwɨg-pən e noakɨmɨl asol! ");
INSERT INTO tnn_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Etəm tatətəlɨg, in təsaprəkɨs-inən rəhan iəgətun, məto etəmim itəm təmətəlɨg-in wɨr matətəu-pən iəgətun e nətəlɨgən mɨn rafin, in otuwa mahmen e rəhan iəgətun. ");
INSERT INTO tnn_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“?Tahro nakatən nɨsɨp noan məsɨn itəm təmuwɨn e nɨganəmtɨ piam, məto nɨkim təsəhtən nɨg asol itəm tətatɨg e nɨganəmtɨm? ");
INSERT INTO tnn_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","?Okəmə nakəsehmən nɨg asol əpəh e nɨganəmtɨm, kən onakahro min-nulan mos-irəkɨs nɨsɨp e nɨganəmtɨ piam? !Rəhatəmat nənən təwɨr, məto nɨkitəmat tamkɨmɨk! Aupən mos-irəkɨs nɨg asol e nɨganəmtɨm, kən mɨtun nehm wɨrən nɨsɨp e nɨganəmtɨ piam kit. ");
INSERT INTO tnn_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“O nat əh inəh, iatən məmə, nɨg katun tɨkə itəm tatoe-in nɨg kəsunən, tahmen-pən əm e nɨg kəsunən təsoe-inən nɨg katun, ");
INSERT INTO tnn_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","məto-inu etəmim tatɨtun nɨg e nehmən noan. Ko etəmim təsəhlən noa nɨg katun e nolkosɨk, kən ko etəmim təsəhlən noa nɨg tətehen e nol e luən. ");
INSERT INTO tnn_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Etəm təwɨr, nɨkin tərioah e natɨmnat wɨr mɨn, kən in tatol natɨmnat itəm təwɨr. Kən etəm tərat, nɨkin tərioah əm e nolən tərat mɨn, kən in tatol əm nolən tərat; məto-inu e nian tatəghat, kən natɨmnat mɨn əh e nɨkin koatiet.” ");
INSERT INTO tnn_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Kən Iesu təmən məmə, “?Tahro nakotaun-in io məmə ‘Iərəmərə, Iərəmərə,’ məto nəsotolən nat naka itəm ekatən? ");
INSERT INTO tnn_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Pəs ekəgətun kəm itəmat nolən rəha suah kit itəm tatuwa ron io, kən matəto nəghatən mɨn rəhak, kən matol natɨmnat mɨn itəm ekatən ilat. ");
INSERT INTO tnn_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","“Kən in tahmen əm e etəmim itəm təmiləkɨn rəhan nimə. Aupən, təmel nɨsɨp meiuaiu muwɨn mafəl wɨr kəpiel apɨn əpəh ləhau, kən miləkɨn-pən rəhan ikɨn nimə. Nian nuhuən təfɨk maiu maruəh muwa mɨləs pɨkən, məto təsəloalən lan, məto-inu təmiləkɨn wɨr tiəkɨs. ");
INSERT INTO tnn_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Məto etəmim itəm tatəto nəghatən rəhak kən məsolən, in tahmen-pən e etəmim itəm tatiləkɨn-pər rəhan nimə tatəpələh-pər əm e nɨməptən. Nian nuhuən təfɨk maiu maruəh muwa mɨləs pɨkən nimə, kən əmun nimə tiet morin mɨməlkin-məlkin.” ");
INSERT INTO tnn_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nian Iesu təməghat rəkɨs kəm netəmim un, kən in təmuwɨn əpəh e taon Kapaneam. ");
INSERT INTO tnn_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kən ikɨn əh, etəm-iasol kit rəha mopael mɨn rəha netəm Rom tətatɨg, kən slef kit əh-ikɨn rəhan itəm in tolkeike pɨk, məto slef əh tatɨmɨs pɨk, rəhan nahməən tepət. ");
INSERT INTO tnn_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kən e nian etəm-iasol əh təməto namnusən rəha Iesu, kən in təmahləpis netəm-iasol neen rəha netəm Isrel məmə okotuwɨn motən-ipən kəm Iesu məmə otuwɨn mol-wɨr rəhan slef. ");
INSERT INTO tnn_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kən nian netəm-iasol mɨn əh kəmotuwa motehm Iesu, motətapəh əskasɨk ron motən məmə, “Iərəmərə, tətuatɨp əm məmə nakasitu e suah əh, ");
INSERT INTO tnn_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","məto-inu in tolkeike pɨk kitat netəm Isrel, kən in təmiləkɨn nimə rəha nuəfɨmɨnən rəhatat.” ");
INSERT INTO tnn_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kən Iesu təmətəu-pən ilat. Kən e nian kɨnoatuwa iuəhkɨr o nimə, etəm-iasol rəha mopael mɨn təmahl-ipən rəhan mɨn netəmim kotuwɨn motehm Iesu moatən-ipən məmə, “Iərəmərə, əsəlɨkiamtəən ik o nuwamən, məto-inu esahmen-pənən məmə onəkuwa imak ikɨn. ");
INSERT INTO tnn_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kən tol min-nəhlan, io esɨmnəən mehm ik. Ik etəm-iasol kit, məto io etəm ləhau əm. Məto əghat əm, kən rəhak slef, in otəsanən mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ekɨtun məmə nɨmɨsən əh otəkəike mol nəwiam, məto-inu io mɨn, rəhak netəm-iasol mɨn kotərəmərə lak, kən iatol nəwialat, kən mopael mɨn neen əh-ikɨn itəm io ekərəmərə elat. Okəmə ekən kəm kit məmə, ‘Uwɨn,’ kən tuwɨn. Kən okəmə ekən kəm kit məmə, ‘Wa,’ kən tuwa. Kən okəmə ekən kəm rəhak slef məmə, ‘Ol nat u,’ kən in tol.” ");
INSERT INTO tnn_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nian Iesu təməto nəghatən u, narmɨn təmiwɨg pɨk o nəghatən rəha suah u. Kən in təmeirair mən-ipən kəm nɨmanin netəmim itəm koatətul uarisɨg in, məmə, “Ekatən kəm itəmat məmə, suah u sənəmə in etəm Isrel. Kən nat əpnapɨn noanol mɨn rəha Isrel, məto esehmən ilat kit itəm rəhan nahatətəən iahgin tahmen-pən lan.” ");
INSERT INTO tnn_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kən e nian iahləpis mɨn rəha etəm-iasol kəmotɨtəlɨg-pən imə, kəmotehm slef əh tɨnəsanən rəkɨs. ");
INSERT INTO tnn_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kən təsuwəhən e natɨmnat mɨn u, Iesu təmuwɨn e taon kit, nərgɨn u Nain, ilat rəhan mɨn netəmim ne nɨmanin netəmim tepət itəm koatuarisɨg-in in. ");
INSERT INTO tnn_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kəmol fenɨs e kəpiel tɨtəlau e taon əh, kən e nian Iesu təmuwa iuəhkɨr o nafiluə rəha taon, kən təmehm netəmim koatɨsɨ-pən e taon moatalis etəm təmɨmɨs kit. In etəm aluə iərman, nətɨ nəutahlɨmɨs kit noan kitiəh əm. Kən nɨmanin netəmim tepət rəha taon koataliwək kələh ilat nəutahlɨmɨs əh. ");
INSERT INTO tnn_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kən nian Iərəmərə təmehm nəutahlɨmɨs əh, in təmasəkitun pɨk, kən mən-ipən kəm in məmə, “Əsasəkən.” ");
INSERT INTO tnn_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kən təmuwɨn mek pet itəm kətalis suah u təmɨmɨs lan, kən kəmotətul. Kən Iesu təmən-ipən məmə, “!Etəm aluə! !Iatən kəm ik məmə, ətul!” ");
INSERT INTO tnn_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kən etəm təmɨmɨs tɨnəmegəh mɨnətul, kən mətuoun matəghat. Kən Iesu təmos-ipən etəm aluə əh kəm rəhan mama. ");
INSERT INTO tnn_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Netəmim rafin kəmotəgɨn motasiəp, kən moatənwiwi Uhgɨn məmə, “!Ien asol kit roiu tətatɨg kitat min!” Kən motən mɨn məmə, “!Uhgɨn təmuwa məmə otasitu e rəhan mɨn netəmim!” ");
INSERT INTO tnn_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kən namnusən rəha Iesu təmaiu mɨtəlau ikɨn mɨn rafin e nɨtən Jutia kən e nɨməptən mɨn rafin iuəhkɨr ron. ");
INSERT INTO tnn_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Netəmim rəha Jon Baptais kəmotən-ipən kəm in natɨmnat rafin itəm Iesu təmol ilat. Kən Jon Baptais təmaun-in rəhan etəmim mil kəiu kuea ron, ");
INSERT INTO tnn_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","kən tahləpis ilau məmə okian muehm Iərəmərə muətapəh ron məmə, “?Karmə ik suah əh itəm otuwa, o məta ekotasɨpən o etəm pɨsɨn kit mɨn?” ");
INSERT INTO tnn_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kən nian suah mil kəmuea muehm Iesu, kəmuən-ipən kəm in məmə, “Jon Baptais təmahl-ipa itɨmlau ekuea məmə ekuətapəh ron ik məmə, ‘?Karmə ik suah əh itəm otuwa, o məta ekotasɨpən o etəm pɨsɨn kit mɨn?’” ");
INSERT INTO tnn_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kən e nian əm əh itəm ilau kəmuea muehm Iesu lan, məto Iesu tatol nɨmɨsən tepət koatəwɨr. Neen koatos nɨmɨsən pɨsɨn pɨsɨn mɨn, neen narmɨn rat tətatɨg elat. Kən netəmim tepət nɨganəmtɨlat təpɨs, məto Iesu təmol-wɨr ilat. ");
INSERT INTO tnn_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kən Iesu təmən-ipən kəm ilau məmə, “Iatəlɨg mian muən-ipən natɨmnat mɨn u rafin kəm Jon, nat itəm nəmuəto kən muehm. Netəm nɨganəmtɨlat təpɨs kɨnoatəplan nat. Kən netəmim itəm nelkɨlat tərat kɨnotəto təwɨr kən mɨnotaliwək. Kən netəm mɨn u kəmotos nɨmɨsən leprosi, nuwigɨlat tɨnəwɨr. Kən netəm mɨn u matəlgɨlat təmalu, roiu matəlgɨlat tɨnoag, kən netəm mɨn u kəmotɨmɨs, kɨnotəmegəh mɨn. Kən ian-rat mɨn, roiu əh suah kit tɨnatən-iarəp namnusən təwɨr kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Uhgɨn otawte-in rəhan nəwɨrən kəm netəmim itəm kəsotəmeən e rəhalat nahatətəən lak o rəhak nolən.” ");
INSERT INTO tnn_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","E nian iahləpis mil rəha Jon ilau kəmiatəlɨg mɨn, kən Iesu təmətuoun matəghat-in Jon kəm nɨmanin netəmim. In təmən məmə, “?Aupən ikɨn, itəmat nəmoatuwɨn əpəh ikɨn taruən-aruən ikɨn məmə onəkotehm naka? ?Nəmoatuwɨn məmə onəkotehm suah kit əpnapɨn əm itəm tahmen e nuwig itəm nɨmətag tətahl tatahuin-ahuin? !Kəp! ");
INSERT INTO tnn_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","?Okəmə kəpə, kən nəmoatuwɨn məmə onəkotehm naka, suah kit itəm tatuwɨn e napən wɨr nəmtɨn tiəkɨs? !Kəp! Netəm itəm koatuwɨn e napən wɨr, motagien əm e rəhalat nautə, ilat kotatɨg e nimə wɨr mɨn tahmen e rəha kig. ");
INSERT INTO tnn_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","?Kən naka əh nəmoatuwɨn məmə nakotehm, ien kit, o? Əwəh, nɨpahrienən, məto iatən kəm itəmat məmə in ilɨs taprəkɨs-in e ien. ");
INSERT INTO tnn_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Suah u inu Naoa Rəha Uhgɨn təmatəghat in məmə, ‘Otəplan-tu. Iatahl-ipɨnə rəhak iahləpis itəm otos rəhak nəghatən. In otaupən-in ik məmə otol əpen-əpenə e rəham suatɨp.’ ");
INSERT INTO tnn_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Iatən kəm itəmat məmə, netəmim itəm kəmotaiir e nətueintən u, kit təsaprəkɨs-inən suah əh Jon. Məto etəm tətatɨg ləhau agɨn e netəmim rafin e nərəmərəən rəha Uhgɨn, in ilɨs taprəkɨs-in Jon.” ");
INSERT INTO tnn_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nian netəmim əpnapɨn, ne netəmim rəha nosən məni rəha takɨs kəmotəto nəghatən rəha Iesu, ilat kəmotən məmə suatɨp rəha Uhgɨn in suatɨp ətuatɨp. Koatən nəhlan məto-inu Jon təmol baptais rəkɨs elat. ");
INSERT INTO tnn_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Məto Farisi mɨn ne iəgətun mɨn rəha Lou, ilat kəməsotegəhanən məmə Jon otol baptais elat, kən inəh kəmotərakin suatɨp rəha Uhgɨn e nəmegəhən rəhalat. ");
INSERT INTO tnn_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kən Iesu təmatəghat mɨn məmə, “?Kən io ekən nolən rəha netəmim roiu, məmə tahmen e naka? ?Kən rəhalat nətəlɨgən naka? ");
INSERT INTO tnn_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ilat kotahmen-pən əm e nɨsualkələh itəm nat kit tɨkə otol nɨkilat tagien. Kən koatəpələh e suatɨp katol maket ikɨn, kən motagət əfəməh motaun-in ilat mɨn neen məmə, ‘Itɨmat emotahl nau kəm itəmat məmə onakoatol danis rəha nagienən lan, məto itəmat nəkəsotolən danis. Kən itɨmat emoatasək eiuə rəha nɨmɨsən, məto nəsotasəkən kitat min itɨmat.’ ");
INSERT INTO tnn_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Iatən min-nulan məto-inu nian Jon Baptais təmuwa, matətuakəm məsunən nagwənən nian tepət o nəfakən, məsənɨmən wain. Kən itəmat nakoatən məmə, ‘Suah əh, narmɨn rat kit tətatɨg lan.’ ");
INSERT INTO tnn_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Məto io, Nətɨ Etəmim, emuwa mətagwən matənɨm wain, kən itəmat nakoatən məmə, ‘!Otəplan-tu, suah əh in etəmim rəha nagwən pɨkən ne etəmim rəha napɨsən, kən motan kələh ilat netəmim rəha nosən məni e takɨs, ne netəmim itəm nol təfagə!’ ");
INSERT INTO tnn_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nenatɨgən rəha Uhgɨn ne nalpəkauən rəhan in tətuatɨp məmə itɨmlau Jon ekioal nat itəm in tolkeike. Kən nəmegəhən rəha netəmim itəm kotahatətə lan, tatəgətun məmə inu nɨpahrienən.” ");
INSERT INTO tnn_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Kən Farisi kit, nərgɨn u Saimon, in təmətapəh o Iesu məmə otuwɨn magwən e rəhan nimə. Kən Iesu təmuwɨn latuənu, muwɨn e nɨpəgnoa nimə rəha Farisi un matəpələh məmə otagwən. ");
INSERT INTO tnn_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kən pətan kit e taon əh in iol təfagə rat, təməto məmə Iesu tətagwən əpəh imə Farisi ikɨn. Kən in təmos senta kit muwa itəm nəmtɨn tiəkɨs. Senta u tətatɨg e pətəl kəmol e kəpiel itəm nəmtɨn tiəkɨs, katən məmə alapasta. ");
INSERT INTO tnn_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Kən in təmuwa iuəhkɨr o Iesu mətul e nɨkalɨ nelkɨn mətasək, nahui nəmtɨn tətuoun mətahl-pən e nelkɨ Iesu mɨnol nelkɨn tɨnəpɨlɨt. Kən təmafəl nahui nəmtɨn e nelkɨ Iesu e noanun, kən mətoafəl nelkɨ Iesu matos-ipən nɨsiaiiən kəm in, kən mol-pən senta e nelkɨn. ");
INSERT INTO tnn_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kən Farisi u təmehm nat əh, kən tatən atɨp e nɨkin məmə, “Okəmə suah əh in ien pahrien, kən okol in təmɨtun əm nolən rəha pətan əh itəm tatek nelkɨn, məmə in iol təfagə rat.” ");
INSERT INTO tnn_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Kən Iesu təmən-ipən kəm in məmə, “Saimon, iakolkeike məmə ekən nat kit kəm ik.” Kən Saimon təmən məmə, “Iəgətun, ən-tu kəm io.” ");
INSERT INTO tnn_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Kən Iesu təmən məmə, “Suah kəiu, rəhalau məni təsahmenən, kən iərəmərə kit təmos-ipən məni neen kəm ilau, kən o nian kit ilau okualpɨn rəhan məni. Kit təmos faif-hanrɨt tenarius, kən kit tos fifti tenarius. ");
INSERT INTO tnn_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nian ilau kənuəruru nos-ipənən nɨtain, kən iərəmərə təmən məmə, ‘Uapəs əm nalpɨnən məni itəm nəmioas.’ ?Kən suah mil u in pəhruən lan otolkeike pɨk iərəmərə?” ");
INSERT INTO tnn_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Kən Saimon in təmən məmə, “Nɨkik təht məmə etəm u itəm in təmos məni tepət, kən iərəmərə təmasəkitun pɨk, in otolkeike pɨk iərəmərə.” Kən Iesu təmən məmə, “Nəmən pahrien.” ");
INSERT INTO tnn_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kən Iesu təmeirair məplan pətan u, kən mən-ipən kəm Saimon məmə, “?Saimon, natehm pətan u, o kəp? E nian emuwa imam ikɨn, ik nəməsos-ipamən nəhau kit o naikuasən e nelkək, məto pətan u, in təmau nelkək e nahui nəmtɨn mafəl e noanun. ");
INSERT INTO tnn_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nian emuwa, kən Saimon, ik nəməsolən nəmtətin kit itəm tatəgətun məmə nakolkeike io. Məto pətan u, tatoafəl nelkək tatuwɨn əm nulan, kən nolən rəhan tatəgətun məmə in tolkeike pɨk io. ");
INSERT INTO tnn_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Saimon, ik nəməsauən rəhk-kapə e oel məsɨn ne, məto pətan u, in təmau nelkək e senta itəm nat kit nəmtɨn tiəkɨs. ");
INSERT INTO tnn_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kən tol nəhlan iatən kəm ik məmə, enafəl rafin rəkɨs rəhan təfagə rat mɨn itəm tepət tepət, kən tol nəhlan, nolən mɨn əh itəm tatol, tatəgətun məmə tolkeike pɨk io. Məto nian iatos-irəkɨs təfagə rəha etəmim noan məsɨn, kən kəsi, rəhan nolkeikeən in natiəkəku ron io.” ");
INSERT INTO tnn_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kən Iesu təmən-ipən kəm pətan u məmə, “Reham təfagə rat mɨn, io enafəl rəkɨs.” ");
INSERT INTO tnn_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Kən netəmim neen mɨn itəm kəmotagwən ilat min, koatən kəm ilat mɨn məmə, “?Etəmim naka əh itəm tatən məmə tatos-irəkɨs təfagə rəha etəmim?” ");
INSERT INTO tnn_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Məto Iesu təmən-ipən kəm pətan u məmə, “Uhgɨn təmosmegəh ik məto-inu nəmahatətə lak. Kən uwɨn, pəs nəməlinuən rəha Uhgɨn tətatɨg ron ik.” ");
INSERT INTO tnn_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Uarisɨg e natɨmnat mɨn əh, Iesu in taliwək matuwɨn e taon mɨn neen ne latuənu mɨn neen. In tatən-iarəp nəghatən rəha Uhgɨn kən mətamnus-iarəp namnusən təwɨr rəha nərəmərəən rəha Uhgɨn. Kən e nian əh, tuelef aposol mɨn rəhan kəmoatətəu-pən. ");
INSERT INTO tnn_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kən nɨpɨtan neen mɨn kəmoatuarisɨg-in Iesu, inu aupən ikɨn ilat kəmoatɨmɨs, o kəmoatos narmɨn rat mɨn tətatɨg elat, məto Iesu in təməhg-iarəp narmɨn rat mɨn kən təmol-wɨr rəhalat nɨmɨsən. Nərgɨ nɨpɨtan mɨn u Meri u katən məmə Maktala itəm Iesu təməhg-iarəp narmɨn rat sepɨn lan; ");
INSERT INTO tnn_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ne Joana pətaguɨhl rəha Jusa itəm in tatərəmərə e nimə rəha Kig Herot Antipas; ne Susana; ne nɨpɨtan tepət mɨn. Nɨpɨtan mɨn u koatos-ipən rəhalat məni o nos-nəmtɨnən natɨmnat o nasituən e Iesu ne rəhan mɨn netəm tuelef. ");
INSERT INTO tnn_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nɨmanin netəmim tepət kəmotɨsɨ-pən e taon mɨn tepət motuwa o Iesu. Nian kəmotuwa motətul kɨtəlau lan, kən təmuəh nimaa nəghatən kəm ilat. In təmən məmə, ");
INSERT INTO tnn_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Suah kit, etəm rəha nəfeən nɨkuti wit, təmuwɨn matərakin nɨkuti wit tatɨsas əpəh e nasumən. Kən neen kəmotɨsas e suatɨp, kən uarisɨg netəmim kotuwa kaliwək lan, kən mənɨg mɨn kotuwa motun rəkɨs ilat. ");
INSERT INTO tnn_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kən nɨkutin neen kotɨsas-pən e nɨsɨp noan məsɨn itəm kəpiel ləhau lan. Nian koatəwiə, kən motauke məto-inu nəhau tɨkə ləhau lan. ");
INSERT INTO tnn_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kən nɨkutin neen kotɨsas-pən e nɨki nolkosɨk. Uarisɨg, nolkosɨk ne wit kuəwiə kələh, kən nolkosɨk tatu-atu-pən lan mətoarus-pən kotɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kən nɨkutin neen mɨn kəmotɨsas-pən e nəptən wɨr motəwiə motoe-in noalat tepət tepət tahmen e wan-hanrɨt.” Nian Iesu təmən rəkɨs nəghatən u, kən təmagət, mən kəm ilat məmə, “Etəm matəlgɨn tatɨg, təwɨr məmə in otətəlɨg-in wɨr kən mɨtun nəghatən mɨn u.” ");
INSERT INTO tnn_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Kən netəmim rəha Iesu kəmotətapəh ron məmə, “Uhapɨk-pa nimaa nəghatən u kəm itɨmat.” ");
INSERT INTO tnn_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Kən in təmən-ipən kəm ilat məmə, “Itəmat, Uhgɨn tɨnerəh rəkɨs e rəhatəmat suatɨp məmə itəmat onəkotɨtun nəghatən rəha nərəmərəən rəha Uhgɨn itəm tatəhluaig. Məto netəmim neen, ilat koatos əm e nuəhən nimaa nəghatən mɨn, məmə ilat okoatehm, məto kotəruru, kən ilat okoatəto, məto okol kəsotɨtunən.” ");
INSERT INTO tnn_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Kən Iesu in təmatəghat məmə, “Nɨpətɨ nimaa nəghatən u tol min-nulan. Nɨkuti wit, inu nəghatən rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nɨkutin mɨn itəm koatɨsas e suatɨp, inu tahmen-pən e netəmim itəm kotəto nəghatən rəha Uhgɨn, kən Setan tatos-irəkɨs nəghatən rəha Uhgɨn e rəhalat nətəlɨgən məmə okəsotənən nɨpahrienən lan, kən Uhgɨn otəsosmegəhən ilat. ");
INSERT INTO tnn_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kən nɨkutin mɨn itəm koatɨsas-pən e nɨsɨp noan məsɨn kəpiel əh ləhau ikɨn, inu tahmen-pən e netəmim itəm koatəto nəghatən rəha Uhgɨn, kən nɨkilat tətagien ron. Məto nokɨlat təseiuaiuən isəu, kən koatahatətə e nian əkuəkɨr əm. Məto nian nəsəsauən, o nəratən tuwa e nəmegəhən rəhalat, kən koatəme e rəhalat nahatətəən. ");
INSERT INTO tnn_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kən nɨkutin mɨn itəm koatɨsas-pən e nɨki nolkosɨk, inu tahmen-pən e netəmim itəm koatəto nəghatən rəha Uhgɨn, məto natɨmnat tepət tətatu-atu-pən e nəmegəhen rəhalat, inəh koatətəlɨg-in pɨk natɨmnat rəha nəmegəhən rəhalat, o ilat kotolkeike nautə tepət, o kotolkeike məmə okotəto təwɨr e rəhalat nəmegəhən. Kən nəmegəhən rəhalat təsoe-inən nat təwɨr kit e nəghatən rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Məto nɨkutin itəm tatɨsas-pən e nɨməptən təwɨr, inu tahmen e netəmim itəm koatəto nəghatən rəha Uhgɨn, kən nɨkilat tətuatɨp kən məwɨr, kən ilat kotaskəlɨm nəghatən rəha Uhgɨn tətatɨg tiəkɨs e nɨkilat. Kən ilat kotalkut matuwɨn matuwɨn, kən motoe-in nəmegəhən təwɨr.” ");
INSERT INTO tnn_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kən Iesu təmən-ipən məmə, “?Pah tətasiepən e lait kən mətaii-pən e pesɨn, o tatəhtu-pən e nɨpəg pet? !Kəp! Kəsolən mihin. Nian nakotasiepən e lait, kən motətu-pər e tepɨl məmə netəmim okotehm nat lan. ");
INSERT INTO tnn_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kən e nolən kitiəh mɨn əm, okəmə suah kit tatəhluaig-in nat kit, məto Uhgɨn otol əp in, kən okəmə suah kit tatos nəghatən anion kit, məto Uhgɨn otən-iarəp. ");
INSERT INTO tnn_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nəghatən u itəm nakoatəto, otətəlɨg-in wɨr. Etəm itəm tɨnɨtun rəkɨs nɨpətɨ nəghatən rəhak, in tɨtun nosən təhmɨn mɨn. Məto etəm itəm təsɨtunən, in otəmkarəpən e nat itəm nɨkin tatəht məmə tatos.” ");
INSERT INTO tnn_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kən e nian əh, mama rəha Iesu ne pian mɨn kəmotuwa məmə okotehm, məto okol kəsotuwɨnən iuəhkɨr motehm məto-inu nɨmanin netəmim tepət koatətlosɨg-in. ");
INSERT INTO tnn_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kən netəmim kəmotən-ipən kəm in məmə, “Mama rəham ne piam mɨn ilat əpəh ihluə koatətul, kən kotolkeike məmə okotehm ik.” ");
INSERT INTO tnn_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kən Iesu təmən-ipən kəm ilat məmə, “Netəmim rafin itəm koatəto nəghatən rəha Uhgɨn kən moatətəu-pən, ilat un rəhak netəmim mɨn, rəhak mama ne piak mɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nian kit Iesu ne rəhan mɨn netəmim kəmotuwɨn e pot kit, kən in təmən-ipən kəm ilat məmə, “Pəs kotuwɨn əpəh entənɨpən-pən e lek u.” Kən kəmotiuw niuwən motiet. ");
INSERT INTO tnn_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nian pot tɨnətaiu, kən Iesu təmuwɨn mapɨl. Kən nɨmətag asol kit təmeiuaiu-pa e lek u, kən nəhau təmuwɨn e nɨpəgnoa pot, iuəhkɨr əm pot tətamnɨm. ");
INSERT INTO tnn_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kən kəmotəhgaiir e Iesu kən motəmə, “!Ei, Etəm-iasol! !Etəm-iasol! Aiir-ta, okotɨmɨs roiu!” Kən Iesu təmaiir məghat mən-iəhau nɨmətag ne peau-peau asol mɨn məmə, “!Nahmen, uameg-ta!” Kən nɨmətag təmurahl nelmɨn, kən tɨnəməlinu tɨnəməlinu. ");
INSERT INTO tnn_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kən Iesu təmən-ipən kəm ilat məmə, “?Tahro? ?Rəhatəmat hiə nahatətəən?” Məto ilat kɨnoatəgɨn, kən narmɨlat tɨnatiwɨg mɨn, kən mɨnoatən-ipən kəm ilat mɨn məmə, “!Ei! ?Etəmim naka u? Nat əpnapɨn nɨmətag ne nəhau, məto katuətəlɨg-in rəhan nəghatən matioal.” ");
INSERT INTO tnn_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kən ilat kəmotuwa kiet-arəpa rəha netəm Kerasa ikɨn, inəh entənɨpən-pən e lek u, kən kəmotuwar əpəh ipar. ");
INSERT INTO tnn_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nian Iesu təmuwar, kən əmun etəmim kit əh-ikɨn təmuwa mehm. Suah un, narmɨn rat mɨn kotatɨg lan, kən nuwəh məsɨn in təməsuwɨn-inən napən, kən in təsapɨlən imə, məto in tətatɨg əm əh e nɨpəg kəpiel mɨn, ikɨn katɨtənɨm netəmim ikɨn. ");
INSERT INTO tnn_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Aupən ikɨn, nian tepət, narmɨn rat əh tatol in tətalməl pɨk, kən netəmim koatəlis nelkɨn ne nelmɨn e sen məmə otaskəlɨm tiəkɨs moatehm məmə otəsərəkɨn-rəkɨnən natɨmnat. Məto e nian rafin tateatɨp-eatɨp sen mɨn əh, kən narmɨn rat tatəkəike kəm in məmə otiet magɨm muwɨn əpəh ikɨn taruən-aruən ikɨn. Kən nian ialməl u təmehm Iesu, təmearɨg əfəməh, muwa morin-pən e nelkɨ Iesu, kən mətagət məmə, “!Iesu, Nətɨ Uhgɨn Ilɨs Agɨn! ?Nakəmə onakahro io? !Awi, iatətapəh ron ik məmə onəsolən nalpɨnən asol kit kəm io!” Narmɨn rat u təmən nəhlan məto-inu Iesu tɨnən rəkɨs məmə in otiet magɨm e suah u. ");
INSERT INTO tnn_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Kən Iesu təmətapəh məmə, “?Nərgəm pah?” Kən in təmən məmə, “Nɨmanin Tepət.” Təmən nəhlan məto-inu narmɨn rat tepət kəmotatɨg lan. ");
INSERT INTO tnn_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kən narmɨn rat mɨn kəmotətapəh əskasɨk o Iesu məmə, “Onəsahl-ipənən itɨmat e nɨpəg itəm namnun tɨkə tapinəp, u imə nalpɨnən.” ");
INSERT INTO tnn_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kən ikɨn əh e nɨkalɨ nɨtot, pɨkəs mɨn tepət kotagwən motan əh-ikɨn. Kən narmɨn rat mɨn kəmotasək moatən-ipən kəm Iesu məmə, “Awi, egəhan-in itɨmat ekotuwɨn e pɨkəs mɨn əh.” Kən Iesu təmegəhan-in ilat kotuwɨn. ");
INSERT INTO tnn_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kən narmɨn rat mɨn u kəmotiet e suah un motuwɨn e pɨkəs mɨn, kən pɨkəs mɨn ilat rafin kəmotaiu moteiuaiu ikɨn təkul-əkul ikɨn, kən motiet-pən e lek motamnɨm. ");
INSERT INTO tnn_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nian netəm kotagwən pɨkəs mɨn kəmotehm nat u, kəmotiet motagɨm motuwɨn moatən-iarəp namnusən rəha natɨmnat mɨn u e taon rəhalat ne ikɨn mɨn rafin tɨtəlau lan. ");
INSERT INTO tnn_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kən netəmim kəmotiet e taon moatuwɨn məmə okotehm natɨmnat mɨn əh. Kən kəmotuwa motehm Iesu, kən motehm mɨn suah un itəm narmɨn rat mɨn kəmotiet rəkɨs lan, in tatəpələh iuəhkɨr e nelkɨ Iesu, tɨnəsalmələn, kən mɨnuwɨn-in rəkɨs rəhan napən. Kən netəmim rəha taon koatəgɨn. ");
INSERT INTO tnn_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kən netəmim itəm kəmotehm ətuatɨp nat u e nɨganəmtɨlat, ilat kotamnus tatuwɨn kəm netəmim neen mɨn moatən-iarəp məmə Iesu təmahro nulan mol-wɨr suah əh, itəm aupən ikɨn narmɨn rat mɨn kəmotatɨg lan. ");
INSERT INTO tnn_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kən netəmim rafin u kotatɨg iuəhkɨr ikɨn Kerasa, kəmotən-ipən kəm Iesu məmə otiet iməlat ikɨn, məto-inu ilat kɨnoatəgɨn pɨk. Kən əmun in təmuwɨn e pot məmə okotasuə moatuwɨn entənɨpən-pən ikɨn. ");
INSERT INTO tnn_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Məto suah u itəm narmɨn rat mɨn kəmotiet lan, in təmətapəh o Iesu məmə, “!Awi, pəs ekɨmnə kitat!” Məto Iesu təmən-ipən kəm in məmə, ");
INSERT INTO tnn_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ɨtəlɨg matuwɨn imam ikɨn, muwɨn mən-iarəp natɨmnat mɨn itəm Uhgɨn təmol kəm ik.” Kən suah u təmuwɨn ikɨn mɨn rafin e taon iman ikɨn matən-iarəp natɨmnat mɨn rafin itəm Iesu təmol kəm in. ");
INSERT INTO tnn_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nian Iesu təmɨtəlɨg-pa mɨn e entənɨpən-pa lan e lek u, netəmim nɨkilat təmagien məmə kɨnotehm mɨn Iesu, məto-inu ilat kəmoatəsahgin. ");
INSERT INTO tnn_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kən etəmim kit təmuwa mehm, nərgɨn u Jaeras, itəm in etəm-iasol kit rəha nimə rəha nuəfɨmɨnən. Təmuwa meiuaiu mɨsin nulɨn e nɨsiaiiən, matəkəike e nətapəhən kəm Iesu məmə in otuwɨn əpəh iman ikɨn, ");
INSERT INTO tnn_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","məto-inu rəhan pətan əkəku tatɨmɨs pɨk rəhan nahməən tepət, kən otəsuwəhən tɨmɨs. In noan kitiəh əm, rəhan nup tuelef. Kən Iesu təmaliwək matuwɨn o pətan əkəku əh, kən nɨmanin netəmim tepət kəmotuwa kɨtəlau lan katɨləs-pɨkən-ləs-pɨkən. ");
INSERT INTO tnn_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kən pətan kit təmuwa o Iesu itəm tatos nɨmɨsən rəhalat nɨpɨtan nian rafin əm mɨnos nup tuelef, kən təmuwɨn o netəmim tepət itəm koatol mərɨsɨn, məto okol kit təsol-wɨrən. ");
INSERT INTO tnn_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kən pətan əh təmɨsɨ-pən e məntaa Iesu ikɨn, kən mea-pən mek nɨpəgnəmtɨ nɨməhan rəha Iesu, kən əmun roiu agɨn-əh mɨn əm, rəhan nɨmɨsən təmol namnun. ");
INSERT INTO tnn_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Kən Iesu tən məmə, “?Ei, pah təmek io?” Kən nian ilat rafin kəmotən məmə kəp, kən Pita təmə, “!Etəm-iasol, nɨmanin netəmim tepət koatɨləs-pɨkən-ləs-pɨkən ik!” ");
INSERT INTO tnn_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Məto Iesu tən məmə, “Kəp. Ekɨtun məmə suah kit təmek io məto-inu eməto məmə nəsanənən təmiet lak.” ");
INSERT INTO tnn_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kən e nian pətan əh tɨnɨtun məmə okol in təsəhluaigən, in təmuwa mətasiəp-asiəp pɨk, kən mɨsin nulɨn matos-ipən nɨsiaiiən kəm Iesu. Kən e nɨganəmtɨ netəmim rafin, tatən-iarəp kəm Iesu məmə təmek in o naka, kən matən-iarəp mɨn məmə e nian təmek in, kən roiu agɨn-əh mɨn əm, rəhan nɨmɨsən təmol namnun. ");
INSERT INTO tnn_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kən Iesu tən-ipən kəm in məmə, “Nətɨk pətan, rəham nahatətəən lak təmol-wɨr ik. Kən atuwɨn, pəs nəməlinuən rəha Uhgɨn tətatɨg ron ik.” ");
INSERT INTO tnn_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nian Iesu təmatəghat əh, kən etəmim kit təmɨsɨ-pən imə Jaeras ikɨn met-arəpa, kən mən kəm Jaeras məmə, “Nətɨm pətan əkəku tɨnɨmɨs rəkɨs. Əsəlɨkiamtəən iəgətun.” ");
INSERT INTO tnn_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Məto nian Iesu təməto nəghatən əh, in təmən-ipən kəm Jaeras məmə, “Əsəgɨnən. Ahatətə əm lak, kən pətan əkəku rəham, in otəwɨr mɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","E nian Iesu təmuwa met-arəpa e nimə rəha suah əh, kən təmit-irəkɨs əm Pita, ne Jon, ne Jemes, ne mama ne tata rəha pətan əkəku itəm in təmɨmɨs, məmə ilat əm okotuwɨn imə. ");
INSERT INTO tnn_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Netəmim rafin koatasək əfəməh moatəun-əun o pətan əkəku əh, məto Iesu təmən-ipən kəm ilat məmə, “Əsotasəkən. Pətan əkəku u in təsɨmɨsən. In tətapɨl əm.” ");
INSERT INTO tnn_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kən ilat kotalah-əsan lan məto-inu ilat kotɨtun məmə pətan əkəku əh tɨnɨmɨs rəkɨs. ");
INSERT INTO tnn_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Məto Iesu təmea-pən mɨləs nelmɨ pətan un kən maun-in məmə, “Pətan əkəku, ətul.” ");
INSERT INTO tnn_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kən əmun pətan əkəku apon təməmegəh mɨn mətul. Kən Iesu təmən-ipən kəm ilat məmə, “Otos-ipən nat kit tun.” ");
INSERT INTO tnn_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kən rəhan mama ne tata, narmɨlau təmiwɨg pɨk, məto Iesu tən-ipən kəm ilau məmə, “Onəkəsuən-iarəpən natɨmnat mɨn u kəm suah kit.” ");
INSERT INTO tnn_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Kən Iesu təmuəfɨmɨn rəhan netəm tuelef kotuwa kitiəh, kən təmos-ipən nəsanənən kəm ilat kən mategəhan-in rəhan nepətən o nərəmərəən kəm ilat məmə ilat kotɨtun nəhg-iarəpən narmɨn rat mɨn, kən məmə ilat okotol-wɨr nɨmɨsən mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kən Iesu təmahl-ipən ilat məmə okotən-iarəp nərəmərəən rəha Uhgɨn, kən məmə okotol-wɨr netəmim itəm koatɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kən in təmən-ipən kəm ilat məmə, “Nian onəkotuwɨn, məsotosən natɨmnat neen rəha naliwəkən rəhatəmat, natɨmnat itəm kotahmen-pən e kasɨkɨn, o kətɨm, o nagwənən, o məni, kən məsotosən napən kəiu. ");
INSERT INTO tnn_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kən e nian itəmat nakotuwɨn e latuənu kit motatɨg e nimə kit, nimə u inun onəkotatɨg əm lan mətoarus-pən nian itəmat onəkotiet lan. ");
INSERT INTO tnn_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kən ikɨn pəhruən onəkotuwɨn ikɨn, okəmə netəmim nɨkilat təsagienən məmə nakotuwa motatɨg itəmat min ilat, kən otohapɨspɨs rəkɨs nɨmoulul e nelkɨtəmat motiet. Inu nəmtətin kit tatəgətun məmə nakotapəs ilat, kən nɨki Uhgɨn tərat olat.” ");
INSERT INTO tnn_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kən ilat kəmotiet motaliwək motuwɨn latuənu mɨn moatamnus-iarəp namnusən təwɨr, kən ikɨn mɨn rafin koatuwɨn ikɨn, moatəfak o netəmim tepət, kən kotəmegəh. ");
INSERT INTO tnn_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kən Kig Herot Antipas u in iərəmərə e nɨtən Kalili, in təməto namnusən rəha natɨmnat mɨn u itəm Iesu tatol ilat. Kən təmətəlɨg-in muwɨn mɨnəruru əfəməh məto-inu netəmim neen kotən məmə Jon Baptais tɨnəmegəh mɨn, ");
INSERT INTO tnn_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","kən netəmim neen mɨn kəmotən məmə Elaija tɨnuwa mɨn, kən netəmim neen kəmotən məmə in ien kit rəha Uhgɨn aupən ikɨn itəm təməmegəh mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kən Herot Antipas təmən məmə, “Jon u, io enəmohatɨp rəkɨs rəhn-kapə. ?Məto etəmim pah u iatəto rəhan namnusən?” Kən in təmategəs-in Iesu məmə otəplan. ");
INSERT INTO tnn_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kən aposol mɨn rəha Iesu kəmotɨtəlɨg-pa mɨn ron, kən motən-ipən kəm in natɨmnat rafin itəm kəmotol. Kən in təmit ilat motiet rəkɨs e netəmim, motuwɨn əpəh e taon pɨsɨn kit mɨn, nərgɨn u Petsaeta. ");
INSERT INTO tnn_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Məto e nian netəmim kəmotəto namnusən məmə Iesu tɨnuwa, kən kəmotuwa motuarisɨg-in ilat. Kən Iesu nɨkin təmagien əm nian in təmehm ilat, kən in tatəgətun ilat e nərəmərəən rəha Uhgɨn, kən matol-wɨr netəm koatɨmɨs kotəmegəh mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kən ehnaipən iuəhkɨr o napinəpən, netəm tuelef rəha Iesu kəmotuwa ron, moatən məmə, “Iərəmərə. Ahl-ipən netəmim rafin koatuwɨn əpəh e latuənu mɨn məmə okotegəs-in ikɨn təwɨr kit rəha napɨlən kən motegəs-in nagwənən itəm okotun məto-inu, ikɨn-u koatan ikɨn roiu, in lɨmɨnan.” ");
INSERT INTO tnn_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Məto in təmən-ipən kəm ilat məmə, “Kəp, itəmat əm. Onəkotagwən netəm mɨn əh.” Kən ilat kotən məmə, “Itɨmat ekoatos əm pɨret faif ne nəm kəiu. ?Tahro? ?Nakolkeike məmə ekotuwɨn motos-nəmtɨn nagwənən kit mɨn nɨgɨ nɨmanin netəmim mɨn əh rafin?” ");
INSERT INTO tnn_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kəmotəghat nəhlan məto-inu netəmim tepət tepət itəm kəmotuwa ikɨn əh, okəmə kafin nəman əm, kən ilat rafin faif-taosan. Məto Iesu tən-ipən kəm rəhan mɨn netəmim məmə, “Otuwɨn motoor ilat fifte fifte motən məmə okotəpələh.” ");
INSERT INTO tnn_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kən rəhan mɨn netəmim kəmotoor ilat mihin nəhlan, kən netəmim rafin kəmotəpələh. ");
INSERT INTO tnn_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Kən Iesu təmos pɨret əh faif ne nəm kəiu, masɨpər e neai, kən matəfak kəm Uhgɨn o nagwənən, kən məmkas matos-ipən kəm rəhan mɨn netəmim məmə okotos-ipən kəm netəmim. ");
INSERT INTO tnn_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kən netəmim rafin kəmotagwən motuwɨn nərpɨlat tasis. Kəmotapəs nɨmɨsmɨsɨ nagwənən, kən netəmim rəha Iesu kəmotaii-pən e kətɨm asol ilat tuelef itəm kəmotər kər wɨr. ");
INSERT INTO tnn_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kən nian kit, Iesu ne rəhan mɨn əm kotatɨg, kən Iesu tatəghat kəm Uhgɨn e nəfakən. Kən in təmətapəh olat məmə, “?Netəmim koatəghat-in io məmə io pah?” ");
INSERT INTO tnn_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Məto kotən məmə, “Neen koatən məmə ik Jon Baptais. Kən neen koatən məmə ik ien Elaija. Kən neen koatən məmə ik ien kit rəha Uhgɨn aupən ikɨn itəm tɨnəmegəh mɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kən Iesu təmətapəh olat məmə, “?Məto itəmat nakotəmə pah u io?” Kən Pita təmən məmə, “Ik Kristo itəm Uhgɨn təmən məmə otahl-ipa.” ");
INSERT INTO tnn_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Məto Iesu təmən-iəhau əskasɨk ilat məmə okəsotən-iarəpən nəghatən mɨn əh kəm netəmim. ");
INSERT INTO tnn_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kən in təmatɨg mən mɨn kəm rəhan mɨn netəmim məmə, “Nat kit itəm otəkəike muwa mol nɨpahrienən lan, məmə io, Nətɨ Etəmim, oekəto nahməən e natɨmnat tepət. Kən netəm-iasol mɨn rəha noanol rəha Isrel, ne pris asol mɨn, ne iəgətun mɨn rəha Lou, ilat okotəuhlin məntaalat kəm io, kən motohamnu io, kən ekɨmɨs. Məto nian itəm tatol kɨsɨl lan, Uhgɨn otol ekəmegəh mɨn e nɨmɨsən.” ");
INSERT INTO tnn_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kən Iesu təmən-ipən kəm rəhan netəmim məmə, “Etəm u tolkeike məmə otuwa muarisɨg-in io, in otəkəike maluin atɨp in, kən e nian rafin in otəkəike mɨləs rəhan nɨg kəməluau muarisɨg-in io, ");
INSERT INTO tnn_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","məto-inu etəmim itəm tolkeike məmə otosmegəh rəhan nəmegəhən e nətueintən u, kən otakiəh e rəhan nəmegəhən lilɨn. Məto etəmim itəm otɨmɨs o nərgək, kən in otos nəmegəhən lilɨn. ");
INSERT INTO tnn_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","?Okəmə suah kit tatos rafin natɨmnat rəha nətueintən u, kən otɨmɨs ron, in otɨləs nat wɨr naka? ");
INSERT INTO tnn_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Okəmə nətaulɨs-in io mətaulɨs-in mɨn rəhak nəghatən, kən Nətɨ Etəmim in otaulɨs-in mɨn ik e nian itəm in otatuwa e nepətən əhag-əhag ne nəsanənən rəhan, ne nepətən əhag-əhag ne nəsanənən rəha Tata rəhan ne nagelo mɨn itəm kotasim. ");
INSERT INTO tnn_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Məto iatən nɨpahrienən kəm itəmat məmə, itəmat neen itəm nəkoatətul ikɨn-u, uarisɨg nəpanotɨmɨs məto nakotaupən motehm nərəmərəən rəha Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Uarisɨg e nəghatən əh rəha Iesu, kən iuəhkɨr nian eit tɨnuwa mɨnuwɨn rəkɨs, kən Iesu təmit Pita, ne Jon, ne Jemes kəmotuwɨn əpəh ilɨs e nɨtot məmə okotəghat kəm Uhgɨn e nəfakən. ");
INSERT INTO tnn_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kən e nian in təmatəfak, kən rəhn-kapə tɨnuwa mɨnol pɨsɨn, kən napən rəhan təmuwa məruən matɨpɨt-ɨpɨt. ");
INSERT INTO tnn_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kən əmun Moses ne Elaija kəmuet-arəpa muətul mətəhaləghat iləhal Iesu, ");
INSERT INTO tnn_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","kən nəhag-əhagən asol kit təmasiə mɨtəlau elau, kən katəhaləghat-in nɨmɨsən rəha Iesu əpəh Jerusalem itəm otol nəghatən rəha ien mɨn rəha Uhgɨn otuwa mol nɨpahrienən lan. ");
INSERT INTO tnn_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Məto Pita ne təs mil, napɨlən tɨnos rəkɨs iləhal, kən kəməhalapɨl məsɨn. Məto nian kəməhalaiir, kəməhalehm nəhag-əhagən asol tɨtəlau e Iesu, kən kəməhalehm Moses ne Elaija katuətul iləhal Iesu. ");
INSERT INTO tnn_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kən nian suah mil kɨnətuagɨm mɨnatian isəu o Iesu, kən Pita təmən-ipən kəm Iesu məmə, “Iərəmərə, təwɨr məmə itɨməhal etəhalatɨg ukɨn-u. Pəs ekəhaliləkɨn makeen kɨsɨl, rəham kit, kən rəha Moses kit, kən rəha Elaija kit.” Məto in təmatəghat əpnapɨn əm, təsɨtunən məmə nəghatən naka in tatən. ");
INSERT INTO tnn_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kən e nian in təmatəghat əh, nɨmal napuə təmuwa malpin ilat, kən nian napuə təməfətain iləhal, kəməhaləgɨn kəməhaləgɨn. ");
INSERT INTO tnn_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kən ilat kəmotəto nəwia suah kit təmɨsɨ-pən e nɨmal napuə, tatən məmə, “Inu nətɨk itəm io emɨtəpun. !Əhalətəlɨg-in wɨr!” ");
INSERT INTO tnn_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nian kɨnotəto rəkɨs nəwia Uhgɨn təməghat un, kən Pita ne Jon ne Jemes kəməhaləplan əm Iesu. Kən e nian mɨn əh, kəsəhalənən natɨmnat mɨn əh kəm suah kit mɨn, kəsəhaləghat-inən natɨmnat mɨn u itəm kəməhaləplan. ");
INSERT INTO tnn_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kən kəmən lawɨg in, nian Iesu ne rəhan etəmim miləhal kəmotɨsɨ-pər ilɨs e nɨtot moteiuaiu-pa, kən motehm netəmim tepət kəmotuwa ron. ");
INSERT INTO tnn_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kən netəm mɨn əh kit təmaun-in əfəməh Iesu məmə, “Iakolkeike məmə nakuwa masitu e rəhak suakəku iərman, məto-inu in noanahlɨ iouen kitiəh əm. ");
INSERT INTO tnn_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nian tepət, narmɨn rat kit tatuwa lan, kən mol in tətagət pɨk, kən mol nɨpətɨn tətasiəp-asiəp matol matol, nahui noan ruən mɨn kotiet, kotahmen əm e sop. Narmɨn rat əh tatərəkɨn pɨk in, kən mətaskəlɨm in, iuəhkɨr təsapəsən in. ");
INSERT INTO tnn_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kən io emətapəh o rəham mɨn netəmim məmə okotəhg-iarəp narmɨn rat u, məto okol kəsotəhg-iarəpən.” ");
INSERT INTO tnn_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Kən Iesu in təmən-ipən kəm ilat məmə, “Itəmat netəm roiu ne, rəhatəmat nahatətəən tɨkə. Kən rəhatəmat nətəlɨgən təsətuatɨpən. Enəpou-in itəmat. ?Oekatɨg kitat min itəmat nian kuwəh? It nətɨm muwa ukɨn-u.” ");
INSERT INTO tnn_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kən nian suakəku u təmatuwa əh o Iesu, kən narmɨn rat təmahtɨgəpis tiet morin-pən e nɨsɨp, mol nɨpətɨn tətasiəp-asiəp. Məto Iesu təməghat əskasɨk kəm narmɨn rat un, kən məhg-iarəp narmɨn rat tiet, kən mol suakəku təwɨr. Kən təmos-ipən suakəku tɨtəlɨg-pən mehm rəhan tata. ");
INSERT INTO tnn_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kən ilat rafin, narmɨlat təmiwɨg o nəsanənən asol rəha Uhgɨn. Məto nian netəmim narmɨlat təmiwɨg o natɨmnat rafin itəm Iesu təmol ilat, kən in təmən-ipən kəm rəhan mɨn netəmim məmə, ");
INSERT INTO tnn_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Otos nəghatən u tatite mamnɨm e nɨkitəmat kən məsotaluinən. Io Nətɨ Etəmim, suah kit otegəhan-in-pən io e nelmɨ tɨkɨmɨr mɨn rəhak.” ");
INSERT INTO tnn_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Məto rəhan mɨn netəmim kəsotɨtunən nɨpətɨ nəghatən u məto-inu Uhgɨn təməhluaig-in nɨpətɨ nəghatən u məmə ilat okəsotɨtunən, kən ilat kɨnotaulɨs-in nətapəh-inən nɨpətɨ nəghatən u o Iesu. ");
INSERT INTO tnn_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kən netəmim rəha Iesu koatol nɨkilat mɨn məmə pah in iahgin etəm-iasol, etəm keike taprəkɨs-in ilat. ");
INSERT INTO tnn_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Məto Iesu təmɨtun rəhalat nətəlɨgən mɨn, kən in təmos suakəku kit mit muwa tətul e nɨkalɨn, ");
INSERT INTO tnn_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","kən tən-ipən kəm ilat məmə, “Okəmə suah kit, nɨkin tagien məmə otos suakəku kit mehm wɨr, kən in tatol min-nəhlan e nərgək, kən in tahmen-pən əm məmə in tatos io, matehm wɨr io. Kən etəm tatos io e nɨkin agien, in tatos Uhgɨn itəm təmahl-ipa io. Inu nɨpahrienən məto-inu etəm tatos-iəhau in ləhau agɨn, in otuwa in etəm-iasol, etəm keike.” ");
INSERT INTO tnn_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Kən Jon təmən məmə, “Iərəmərə. Itɨmat emotehm suah kit tatəhg-iarəp narmɨn rat mɨn e nərgəm, kən emotən-iəhau məmə otəsol wəkən məto-inu sənəmə in rəhatat kit etəmim.” ");
INSERT INTO tnn_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Məto Iesu təmən-ipən kəm in məmə, “Əsən-iəhauən in məto-inu, okəmə suah kit təsolən tɨkɨmɨr itəmat min, kən in iolɨtəmat.” ");
INSERT INTO tnn_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kən tɨnuwa iuəhkɨr o nian itəm Uhgɨn otos Iesu lan muwɨn əpəh e nego e neai, kən Iesu təmən-ipən atɨp kəm in məmə otəkəike muwɨn Jerusalem, kən nat kit tɨkə məmə otahtosɨg-in. ");
INSERT INTO tnn_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kən in təmahl-ipən netəmim neen kotos rəhan nəghatən motaupən-in motuwɨn əpəh latuənu kit Sameria məmə okotol əpen-əpenə rəhan. ");
INSERT INTO tnn_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Məto netəm əh-ikɨn əh, kəsotolkeikeən məmə in otuwɨn matɨg iməlat ikɨn məto-inu, ilat kotɨtun wɨr məmə tatuwɨn Jerusalem. ");
INSERT INTO tnn_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kən nian rəhan etəmim mil, Jemes ne Jon, ilau kəmuehm natɨmnat mɨn əh, kən kəmuən məmə, “?Iərəmərə, nakolkeike məmə ekuaun-in nɨgəm tɨsɨ-pən əpəh ilɨs e nego e neai meiuaiu muwa mus ilat?” ");
INSERT INTO tnn_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Məto Iesu təmeirair məhai ilau. ");
INSERT INTO tnn_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kən kəmotuwɨn mɨn latuənu pɨsɨn kit mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kən e nian Iesu ne rəhan mɨn netəmim kəmotaliwək moatuwɨn e suatɨp, kən suah kit təmən-ipən kəm in məmə, “Io ekuarisɨg-in ik, ikɨn pəhruən onəkuwɨn ikɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Kən Iesu təmən-ipən kəm in məmə, “Kuri iarupɨn mɨn, rəhalat nɨpəg tatɨg məmə okotapɨl ikɨn. Kən mənɨg mɨn, nimaalat tatɨg məmə okotapɨl ikɨn. Məto io Nətɨ Etəmim, nimə rəhak tɨkə o napɨlən.” ");
INSERT INTO tnn_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kən Iesu təmən-ipən kəm suah kit mɨn məmə, “Wa, kilau min ik, muwa ik rəhak etəmim.” Məto suah un tən-ipən məmə, “Iərəmərə, awi. Egəhan-in io ekuwɨn pitən mɨtənɨm rəhak tata.” ");
INSERT INTO tnn_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Məto Iesu təmən-ipən kəm in məmə, “Kəp, apəs-pən. Pəs netəm kɨnotɨmɨs rəkɨs e nɨkilat, koatɨtənəm atɨp ilat mɨn. Məto ik, uwɨn mən-iarəp nərəmərəən rəha Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kən kit mɨn tatən məmə, “Iərəmərə, ekətəu-pən ik muwa io etəmim rəham, məto awi, əpəs pitən ekɨtəlɨg-pən mɨn imak ikɨn mauiatɨpin rəhak mɨn netəmim.” ");
INSERT INTO tnn_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Məto Iesu təmən-ipən kəm in məmə, “Okəmə suah kit tətuoun matol wək rəha Uhgɨn, məto rəhan nətəlɨgən tatuwɨn o nat pɨsɨn pɨsɨn mɨn neen, kən suah u təsahmen-pənən məmə Uhgɨn otərəmərə lan.” ");
INSERT INTO tnn_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Uarisɨg e natɨmnat mɨn əh, Iərəmərə təmɨtəpun rəkɨs sepɨnte-tu netəmim neen mɨn rəhan, kən təmahl-ipən ilat kəiu kəiu kotaupən-in moatuwɨn e taon mɨn ne ikɨn mɨn neen mɨn itəm Iesu təpanuarisɨg muwɨn ikɨn. ");
INSERT INTO tnn_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kən təmən-ipən kəm ilat məmə, “!Otəplan-tu! Nagwənən tepət əpəh e nasumən itəm kɨnotɨmətə, məto iolwək mɨn noan məsɨn əm kotəulək-in. Kən otəfak-pən o etəm-iasol rəha nasumən məmə otahl-ipa iolwək mɨn tepət məmə okotuwɨn kəulək-in nasumən rəhan. ");
INSERT INTO tnn_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Otuwɨn, məto nəkotəkəike motɨtun məmə io etahl-ipən itəmat məmə nakotuwɨn tahmen-pən e sipsip əlkələh mɨn itəm kotaliwək moatuwɨn ilugɨn e kuri iarupɨn mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kən onəkəsotosən kətɨm əkəku rəha məni, ne kətɨm, ne put, kən əsotamegən e suatɨp katəghat kəm netəmim. ");
INSERT INTO tnn_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Nimə naka itəm onəkotuwɨn ikɨn, nakotaupən motən-iarəp məmə, ‘!Pəs nəməlinuən otətatɨg ikɨn!’ ");
INSERT INTO tnn_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Okəmə etəm rəha nəməlinuən əh-ikɨn, kən rəham nəfakən otuwa mol nɨpahrienən, kən nəməlinuən otətatɨg ron. Məto okəmə etəm tol nəhlan tɨkə, kən noa rəham nəfakən otɨtəlɨg-pa mɨn ron ik. ");
INSERT INTO tnn_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kən otatɨg əm e nimə kitiəh əm, sotapɨlən e nimə pɨsɨn pɨsɨn mɨn. Kən nagwənən naka itəm okoatos-ipɨnə kəm itəmat, otun. Kən nənɨmən naka okotos-ipɨnə, otənɨm. Məto-inu in tətuatɨp əm məmə suah kit itəm tatol wək, in tətuatɨp məmə in otos nətouən lan. ");
INSERT INTO tnn_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Nian itəmat nakotuwɨn taon kit, okəmə nɨkilat tətagien otəmat, kən otun nagwənən naka itəm koatos-ipɨnə kəm itəmat, ");
INSERT INTO tnn_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","kən otol-wɨr netəmim itəm koatɨmɨs motatɨg ikɨn, kən motən-iarəp kəm ilat məmə, ‘Nərəmərəən rəha Uhgɨn tatuwa iuəhkɨr otəmat.’ ");
INSERT INTO tnn_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Məto okəmə nakotuwɨn e taon kit, kən netəmim nɨkilat təsagienən otəmat, kən otuwɨn motaliwək e suatɨp asol mɨn, kən motən məmə, ");
INSERT INTO tnn_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nɨmoulul rəha nɨsɨp itəm tətatɨg e nelkɨtɨmat, ekoatoahapɨspɨs rəkɨs, in nəmtətin tatəgətun məmə nəmotol təsahmenən, kən Uhgɨn təmapəs itəmat. Məto nəkotəkəike motɨtun məmə nərəmərəən rəha Uhgɨn tɨnatuwa iuəhkɨr rəkɨs.’ ");
INSERT INTO tnn_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kən iatən nɨpahrienən kəm itəmat məmə, Uhgɨn otol nalpɨnən asol kəm ilat taprəkɨs-in nalpɨnən rəha taon rat əh Sotom aupən.” ");
INSERT INTO tnn_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“!Itəmat netəm Korasin, kəsi, nahməən asol otuwa otəmat! !Itəmat netəm Petsaeta, kəsi, nahməən asol otuwa otəmat! Məto-inu emol pap nat pɨspɨs tepət e taon mil rəhatəmat! Kən okəmə emol natɨmnat mɨn əh əpəh Taea ne Saeton aupən, okol netəmim əh-ikɨn əh kəmotəuhlin rəhalat nətəlɨgən e nolən rat mɨn, kən ilat kəmotuwɨn e natɨmnat rat motuwɨn moatəpələh e nəmtap e nɨgəm motəgətun məmə koatəto tərat agɨn o rəhalat nolən rat mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Məto e nian əh itəm Uhgɨn otol nalpɨnən kəm netəmim, nalpɨnən rəhatəmat in otəskasɨk, maprəkɨs-in nalpɨnən rəha netəm Taea ne Saeton aupən ikɨn. ");
INSERT INTO tnn_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","?Kən itəmat netəm Kapaneam, nɨkitəmat təht məmə Uhgɨn otɨləs-ipər itəmat e ikɨn rəha nɨsiaiiən əpəh e nego e neai? !Kəp! Məto Uhgɨn otɨləs-iəhau itəmat nakotuwɨn ləhau agɨn, ikɨn itəmat onəkotaulɨs ikɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kən Iesu təmən-ipən kəm rəhan mɨn məmə, “Netəmim itəm koatətəlɨg-in itəmat, koatətəlɨg-in io. Kən netəmim itəm koatəuhlin məntaalat kəm itəmat, koatəuhlin məntaalat kəm io, kən netəmim itəm koatəuhlin məntaalat kəm io, koatəuhlin məntaalat kəm suah u itəm təmahl-ipa io.” ");
INSERT INTO tnn_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kən netəmim mɨn rəha Iesu ilat sepɨnte-tu kəmotɨtəlɨg-pa mɨn, kən nɨkilat tətagien moatən kəm Iesu məmə, “!Iərəmərə, nat əpnapɨn narmɨn rat mɨn, məto nian itɨmat ekotəghat e nərgəm, kən ilat koatol nəwiatɨmat!” ");
INSERT INTO tnn_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Kən Iesu təmən-ipən kəm ilat məmə, “Io emehm Setan təmɨsɨ-pər ilɨs e neai meiuaiu tahmen-pən e nɨpɨtən. ");
INSERT INTO tnn_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Otətəlɨg-tu. Io enos-ipɨnə rəkɨs nəsanənən kəm itəmat, inəh itəmat nəkotɨtun neguətainən sɨnek mɨn ne skopion mɨn. Kən nəsanənən itəm iatos-ipɨnə kəm itəmat, in taprəkɨs-in nəsanənən rəha tɨkɨmɨr rəhatat, Setan. Kən okol nat kit təsərəkɨnən itəmat. ");
INSERT INTO tnn_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Inəh nɨpahrienən. Məto nəsotagienən məmə narmɨn rat mɨn koatol nəwiatəmat, məto otagien əm məto-inu Uhgɨn təməte rəkɨs nərgɨtəmat əpəh e nego e neai.” ");
INSERT INTO tnn_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kən e nian əh, Iesu nɨkin tətagien pɨk e nagienən itəm tatɨsɨ-pən e Narmɨn Rəha Uhgɨn, kən in təməfak mən məmə, “Tata Uhgɨn, ik Iərəmərə rəha natɨmnat rafin ilɨs e neai ne ləhau e nətueintən. Iatənwiwi ik məto-inu nəməhluaig-in nɨpətɨ natɨmnat mɨn u e nɨganəmtɨ netəmim itəm kotenatɨg motɨtun wɨr nat. Kən nəmol-arəp kəm netəmim itəm kotahmen-pən əm e nɨsualkələh məmə okotɨtun wɨr. Əwəh, Tata, inu nat kit itəm nakolkeike.” ");
INSERT INTO tnn_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Kən Iesu təmatəkəike matəghat kəm ilat məmə, “Rəhak Tata təmegəhan-in-pa rəkɨs natɨmnat rafin e nelmək. Tata əm tɨtun Netɨn. Kən Nətɨn əm ne netəmim neen, ilat mɨn əm kotɨtun Tata. Ilat u netəmim itəm Nətɨn təmɨtəpun ilat məmə in otol-arəp Tata rəhan kəm ilat.” ");
INSERT INTO tnn_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kən Iesu təmeirair məghat əm kəm rəhan mɨn netəmim məmə, “!Nəkotatɨg e nəwɨrən pahrien məto-inu itəmat nakoatehm e nɨganəmtɨtəmat natɨmnat mɨn əh! ");
INSERT INTO tnn_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Iatən kəm itəmat məmə, aupən ikɨn ien mɨn tepət, ne kig mɨn tepət, kəmotolkeike pɨk məmə okotehm natɨmnat mɨn u itəm itəmat nakoatehm, məto kəməsotehmən. Kən ilat kəmotolkeike məmə okotəto natɨmnat mɨn itəm nakoatəto, məto kəməsotətoən.” ");
INSERT INTO tnn_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kən e nian əh, ienatɨg kit e Lou təmətul meiuə əm e nətapəhən kit kəm Iesu məmə otehm-tu okəmə Iesu in tenatɨg wɨr o kəp. In təmən məmə, “?Iəgətun, oekahro min-nulan mos nəmegəhən lilɨn?” ");
INSERT INTO tnn_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Kən Iesu təmən-ipən kəm in məmə, “?Lou rəha Moses tatən məmə naka? ?Nian ik nətafin, kən nɨpətɨn tatən naka kəm ik?” ");
INSERT INTO tnn_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Kən suah un tən-ipən məmə, “Onakəkəike molkeike Iərəmərə rəham Uhgɨn e nɨkim rafin, ne nəmegəhən rafin rəham, ne nəsanənən rafin rəham, ne nətəlɨgən rafin rəham; kən molkeike mɨn ik mɨn neen tahmen-pən əm məmə nakatolkeike atɨp ik.” ");
INSERT INTO tnn_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Kən Iesu tən-ipən kəm in məmə, “In ətuatɨp un. Okəmə nakatol nəhlan, kən ik onakos nəmegəhən lilɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Məto suah əh, in tolkeike əm məmə otəgətun rəhan nolən məmə in etəm ətuatɨp, kən in təmətapəh o Iesu məmə, “?Məto pah mɨn u ilat io mɨn neen?” ");
INSERT INTO tnn_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Kən Iesu tən-ipən kəm in məmə, “Suah kit təmiet Jerusalem kən maliwək meiuaiu matuwɨn əpəh Jeriko. Kən e suatɨp, iakləh neen kəmotaskəlɨm motəmki-rəkɨs rəhan natɨmnat, kən motoh kələhəu tɨmɨseah mətaməhl e suatɨp, kən kotagɨm motapəs. ");
INSERT INTO tnn_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kən təpəwɨr əh, pris kit tatɨtəp suatɨp əh matuwa, məto nian in təməplan suah əh, in təmaliwək mawɨlək-in matuwɨn. ");
INSERT INTO tnn_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kən Lifaet kit tɨtəp mɨn əm suatɨp kitiəh muwa, kən nian təməplan suah əh tətaməhl, in təmol əm nat kitiəh mɨn mawɨlək-in. ");
INSERT INTO tnn_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Məto etəmim kit rəha Sameria, itəm koatol tɨkɨmɨr ilat netəm Isrel, in mɨn tɨtəp suatɨp əh matuwa, kən məplan suah əh tətaməhl. Nian təməplan, nɨkin təmahmə ron, ");
INSERT INTO tnn_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","kən təmaliwək muwɨn iuəhkɨr ron, mafəl rəhan nɨməgəm mɨn e oel ne wain, kən malpin wɨr ilat. Kən təmɨləs-ipər suah əh mahtu-pər e rəhan togki, kən mɨləs mian əpəh e hotel matehm wɨr. ");
INSERT INTO tnn_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kən kəmən lawɨgin, in təmos məni neen muwɨn mos-ipən kəm etəm-iasol rəha hotel, kən mən-ipən kəm in məmə, ‘Onakatehm wɨr suah u, kən okəmə nəkətuatin rəham neen məni, kən onakən-ipa kəm io nian ekɨtəlɨg-pa mɨn, pəs io ekos-ipɨnə nɨtain.’” ");
INSERT INTO tnn_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Kən nian Iesu tɨnol namnun nəghatən u, kən təmətapəh o ienatɨg e Lou məmə, “?E rəham nətəlɨgən, suah miləhal əh, nəkɨtun məmə iləhal pah təmol təwɨr kəm suah əh kəmoh, tahmen məmə in in kit?” ");
INSERT INTO tnn_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Kən ienatɨg e Lou təmən-ipən məmə, “Etəmim itəm in təmasəkitun suah əh.” Kən Iesu tən-ipən kəm in məmə, “Ita. Ik uwɨn mol mɨn tahmen-pən əm məmə inu suah əh təmol mihin ne.” ");
INSERT INTO tnn_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nian Iesu ne rəhan mɨn netəmim kotaliwək e suatɨp, kən kəmotiet-arəpən latuənu kit. Kən pətan kit, nərgɨn u Mata, təmos Iesu e nɨkin agien muwɨn əpəh e rəhan nimə. ");
INSERT INTO tnn_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Pətan əh, pian kit əh-ikɨn, nərgɨn u Meri. Kən Meri təmuwa matəpələh iuəhkɨr o nelkɨ Iərəmərə matətəlɨg-in nəgətunən mɨn rəhan. ");
INSERT INTO tnn_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Məto Mata, rəhan nətəlɨgən tatuwɨn pɨk o nolən nagwənən, kən wək tɨnatoh in. Kən təmuwɨn o Iesu mən-ipən kəm in məmə, “?Iərəmərə, tahro? ?Nɨkim təht məmə tətuatɨp əm, o kəp, məmə pətan u piak təsasituən lak ne o nolən wək u, kən io pɨsɨn əm iatol? Ahl-ipa məmə otuwa masitu lak.” ");
INSERT INTO tnn_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Məto Iərəmərə təmən-ipən kəm in məmə, “Ei, Mata. Əsətəlɨg-in pɨkən natɨmnat mɨn tepət nəhlan. ");
INSERT INTO tnn_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Məto nat kitiəh əm in nat keike, kən Meri in tɨnɨtəpun rəkɨs nat u itəm in təwɨr taprəkɨs, kən okol io esɨləs-irəkɨsən nat əh ron.” ");
INSERT INTO tnn_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nian kit, Iesu təmatəghat kəm Uhgɨn e nəfakən əpəh ikɨn kit. Kən nian təmol namnun rəhan nəfakən kəm Uhgɨn, kən rəhan kit etəmim təmətapəh ron məmə, “Iərəmərə, əgətun-tu itɨmat e suatɨp rəha nəghatən kəm Uhgɨn e nəfakən, tahmen-pən e Jon Baptais in təməgətun mihin rəhan mɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Kən Iesu təmən-ipən kəm ilat məmə, “Nian nakotəghat kəm Uhgɨn e nəfakən, onəkotən məmə, ‘Tata Uhgɨn, nərgəm in ilɨs agɨn, pəs netəmim okotɨsiai-in. Pəs rəham nərəmərəən tuwa matɨg. ");
INSERT INTO tnn_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nian rafin, os-ipa nagwənən kəm itɨmat tahmen-in rəha nian roiu. ");
INSERT INTO tnn_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kən afəl rəkɨs rəhatɨmat nolən rat mɨn məto-inu itɨmat esotaskəlɨm-iəkɨsən e nɨkitɨmat nolən rat mɨn rəha netəmim itəm koatol kəm itɨmat. Kən segəhan-inən itɨmat ekotuwɨn ima nos-ipən-os-ipənən, ikɨn itəm məta oekotakiə motol təfagə rat.’” ");
INSERT INTO tnn_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Kən təmən-ipən kəm ilat məmə, “?Okəmə suah kit tuwa imam ikɨn lapɨn, kən rəham nagwənən tɨkə, kən onəkol naka? Onəkuwɨn e nimə rəha ik kit, kən mən-ipən məmə, ‘Io kit, os-ipa nagwənən məsɨn, kən ekos muwɨn magwən suah kit lan itəm təmɨsɨ-pən isəu muwa imak ikɨn roiu lapɨn, kən rəhak nagwənən tɨkə məmə ekagwən in lan.’ ");
INSERT INTO tnn_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kən in otuhalpɨn-pɨnə kəm ik məmə, ‘!Aaah! Atuwɨn, səhgaiirən etɨmat, enotapɨl rəkɨs itɨmat rəhak nɨsualkələh. Okol esətul mɨnən mos-ipɨnə nagwənən kəm ik.’ ");
INSERT INTO tnn_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ekən kəm itəmat məmə, nat əpnapɨn ik in kit, məto suah un təsolkeikeən məmə in otos-ipɨnə nagwənən kəm ik. Məto iatən nɨpahrienən, nian nakatəkəike matətapəh ron, kən in otətul mos-ipɨnə natɨmnat rafin kəm ik itəm nakolkeike. ");
INSERT INTO tnn_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Kən tol nəhlan ekən kəm itəmat məmə, otətapəh-in kəm Uhgɨn o natɨmnat, kən in otos-ipɨnə kəm itəmat. Kən otegəs-in, kən nakotehm. Kən otəht-əht toa, kən toa oterəh otəmat. ");
INSERT INTO tnn_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ekən nəhlan məto-inu netəmim rafin itəm koatətapəh-in, kən okoatos. Kən netəm mɨn u itəm koategəs-in, kən okoatehm. Kən netəmim itəm koatəht-əht toa, kən toa oterəh olat. ");
INSERT INTO tnn_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Itəmat tata mɨn. ?Itəmat kit, nian nətɨn tatətapəh-in nəm, məto in tatos-ipən sɨnek? !Kəp! ");
INSERT INTO tnn_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","?O nian in tatətapəh-in noanahlɨ-mənɨg, məto in tatos-ipən skopion? !Kəp! ");
INSERT INTO tnn_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nat əpnapɨn itəmat netəm nakotərat, məto nakoatos-ipən natɨmnat wɨr mɨn kəm nenətɨtəmat mɨn. Məto Tata Uhgɨn əpəh e nego e neai, nolən rəhan in təwɨr pɨk maprəkɨs-in nolən rəhatəmat, kən nɨpahrienən, in otos-ipən Narmɨn Rəhan kəm netəm mɨn u itəm koatətapəh-in ron.” ");
INSERT INTO tnn_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Kən e nian kit, suah kit əh-ikɨn itəm narmɨn rat tətatɨg lan, kən tol məmə in təruru nəghatən. Kən Iesu təməhg-iarəp narmɨn rat əh, kən suah əh təmətuoun matəghat, kən netəmim narmɨlat təmiwɨg pɨk ron. ");
INSERT INTO tnn_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Məto netəmim mɨn əh neen koatən məmə, “Pielsepul u in etəm-iasol rəha narmɨn rat mɨn, in əm əh təmos-ipən nəsanənən kəm suah u məmə in otəhg-iarəp narmɨn rat mɨn e netəmim.” ");
INSERT INTO tnn_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Kən netəm pɨsɨn neen mɨn kəmotətapəh o Iesu məmə in otol-tu nat pɨspɨs kit e nəsanənən itəm tatɨsɨ-pən e nego e neai məto-inu, ilat kotolkeike məmə okotɨtun-tu məmə Iesu in etəmim pah. ");
INSERT INTO tnn_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Məto Iesu tɨnɨtun rəkɨs nətəlɨgən mɨn rəhalat, kən təmən məmə, “Okəmə netəmim e kantri kit koatoor ilat mɨn, kən okotərəkɨn rəhalat kantri, kən nərəmərəən otɨsas mɨkə. Kən tahmen-pən əm, e latuənu kit, okəmə netəmim lan koatoor ilat mɨn, kən okotərəkɨn agɨn-əh latuənu u. ");
INSERT INTO tnn_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","?Kən okəmə netəmim rəha Setan koatoor ilat mɨn, kən otahro nulan rəhan nərəmərəən otətatɨg? Iatən min-nulan məto-inu nakoatən məmə iatəhg-iarəp narmɨn rat mɨn e nəsanənən rəha Pielsepul. ");
INSERT INTO tnn_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","?Kən okəmə io, iatəhg-iarəp narmɨn rat mɨn e nəsanənən rəha Pielsepul, kən tahro e rəhatəmat mɨn netəmim, ilat koatəhg-iarəp narmɨn rat mɨn e nəsanənən rəha pah? Tol nəhlan, ilat okotakil rəhatəmat mɨn nəghatən məmə in neiueiuəən. ");
INSERT INTO tnn_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Məto okəmə io iatəhg-iarəp narmɨn rat mɨn e netəmim e nəsanənən rəha Uhgɨn, kən tatəgətun məmə nərəmərəən rəha Uhgɨn tɨnuwa rəkɨs otəmat. ");
INSERT INTO tnn_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Nian etəm rəhan nəsanənən tepət tatəmɨk natɨmnat rəha nəluagɨnən, tatətul matɨp matehm wɨr rəhan nimə, inəh rəhan natɨmnat okotatɨg wɨr əm. ");
INSERT INTO tnn_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Məto nian etəm pɨsɨn kit mɨn itəm rəhan nesanənən taprəkɨs-in in, otuwa muəmou mətian mətian tol win lan, in tatos-irəkɨs rafin rəhan natɨmnat rəha nəluagɨnən itəm təmələhəu-pən rəhan nətəlɨgən lan, kən in otoor natɨmnat rafin rəha suah əh kəm rəhan mɨn netəmim. ");
INSERT INTO tnn_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Etəm u itəm təsuarisɨg-inən io, in rəhak tɨkɨmɨr. Kən etəmim u itəm təsargətainən sipsip mɨn, in tatol ilat kotagɨm atit.” ");
INSERT INTO tnn_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Kən Iesu təmən məmə, “Nian narmɨn rat tatiet e suah kit, kən in tətan əpəh ikɨn kɨkə-kɨkə ikɨn nəhau tɨkə lan mategəs-in ikɨn otameg ikɨn, məto təsəplanən. Kən in tatən məmə, ‘Pəs ekɨtəlɨg-pən e rəhak nimə itəm emɨsɨ-pən ikɨn aupən.’ ");
INSERT INTO tnn_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kən nian in tatɨtəlɨg-pa, mehm rəhan nimə kəmafəl təpiə wɨr, kən natɨmnat rafin koatɨs wɨr. ");
INSERT INTO tnn_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kən in otuwɨn mit mɨn narmɨn rat sepɨn mɨn motuwa itəm kotərat kotaprəkɨs-in in. Kən okotuwɨn mɨn imə motatɨg e nəmegəhən rəha suah u. Kən suah u, aupən rəhan nəməgəhən tərat, məto roiu tɨnərat pɨk agɨn-əh.” ");
INSERT INTO tnn_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nian Iesu tatən nəghatən əh, pətagwəhl kit tagət əfəməh məmə, “Pəs Uhgɨn otawte-in rəhan nəwɨrən kəm pətan itəm təmemək-in ik, kən mətapinahin ik.” ");
INSERT INTO tnn_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kən Iesu təmə, “Nɨpahrienən, məto Uhgɨn otawte-in rəhan nəwɨrən taprəkɨs kəm netəmim itəm koatəto nəghatən rəhan, kən moatol.” ");
INSERT INTO tnn_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kən nian netəmim kəmotuwa məmə okotəto nəghatən rəha Iesu, kəmotuwa tepət məsɨn mɨn, kən Iesu təmə, “Itəmat netəm roiu ne, itəmat nol təfagə rat agɨn. Itəmat nakotolkeike məmə nakotehm nat pɨspɨs u nəmtətin kit. Məto okol Uhgɨn təsos-ipɨnəən nəmtətin kit kəm itəmat. Məto Uhgɨn otos-ipɨnə nəmtətin kitiəh əm kəm itəmat, inəh nəmtətin rəha Jona. ");
INSERT INTO tnn_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tahmen əm e Jona itəm təmuwa nəmtətin kit tatuwɨn o netəmim rəha taon u Nineva aupən, e nolən kitiəh mɨn əm, io Nətɨ Etəmim ekuwa nəmtətin rəha netəmim u-roiu ne. ");
INSERT INTO tnn_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kən e nian əh itəm Uhgɨn otakil netəmim rafin, kən kwin rəha nəptən pis ikɨn, in otətul mən-iarəp məmə itəmat netəm nakotərat. Otɨtun nənən nəhlan məto-inu, in təmiet e nɨkalɨn nəptən əpəh isəu agɨn, kən maliwək muwa məmə otəto nəghatən rəha Kig Solomon itəm tenatɨg wɨr. Kən otəplan-tu, suah kit itəm ilɨs taprəkɨs-in Kig Solomon tɨnuwa. ");
INSERT INTO tnn_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Kən netəmim rəha Nineva okotətul e nian Uhgɨn otakil netəmim rafin lan, kən ilat okotən məmə itəmat nəmotol nolən tərat. Kən ilat kotɨtun nənən nəhlan məto-inu, nian ilat kəmotəto nəghatən rəha Jona, ilat kəmotəuhlin ilat e nolən rat mɨn rəhalat. Kən roiu, suah kit ikɨn-u itəm in ilɨs taprəkɨs-in Jona.” ");
INSERT INTO tnn_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Kən Iesu təmən məmə, “Suah kit tɨkə itəm tətasiepən e lait, kən uarisɨg in tatəhluaig-in, o tətaii-pən e nɨpəg kɨtəh. Kəp. Məto nian etəmim tətasiepən e lait, otəkəike mətu-pər e nɨg rəha lait məmə netəmim itəm okotuwa e nɨpəg noa nimə, kən moatehm nəhag-əhagən rəha lait o nəplanən natɨmnat. ");
INSERT INTO tnn_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nɨganəmtɨm in tahmen e lait itəm tatos-ipən nəhag-əhagən kəm nɨpətɨm. E nian nɨganəmtɨm mil kuəwɨr, tahmen əm məmə nɨpətɨm tərioah e nəhag-əhagən. Məto nian nɨganəmtɨm mil kuərat, tahmen əm məmə nɨpətɨm tərioah e napinəpən. ");
INSERT INTO tnn_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kən tol nulan, ik onakəkəike matehm wɨr məmə nəhag-əhagən e rəham nəmegəhən, in sənəmə napinəpən. ");
INSERT INTO tnn_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kən okəmə rəham nəmegəhən in tərioah wɨr e nəhag-əhagən, napinəpən in otɨkə agɨn lam, kən nəhag-əhagən in tətasiəgəpɨn wɨr rafin rəham nəmegəhən, tahmen-pən əm e nəhag-əhagən rəha lait tətasiəgəpɨn ik.” ");
INSERT INTO tnn_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kən nian Iesu təməghat rəkɨs, kən Farisi kit təmuwa mən-ipən kəm in məmə okian muagwən e rəhan nimə. Kən Iesu təmaliwək muwɨn əpəh imə matəpələh e nɨkalɨ tepɨl o nagwənən. ");
INSERT INTO tnn_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kən Farisi apon təmaut ron narmɨn təmiwɨg nian təməplan məmə Iesu təsaikuasən pitən e nelmɨn uarisɨg təpanagwən. ");
INSERT INTO tnn_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kən Iərəmərə təmən kəm in məmə, “Itəmat Farisi mɨn, nəkotahmen əm e kap ne plet itəm nakotaikuas elat əpəh ihluə əm, məto əpəh e nɨpəgnoalat, kotapɨn. Itəmat nakotərioah e naumɨsən ne nəratən. ");
INSERT INTO tnn_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","!Itəmat nakotalməl pɨk! ?Nɨkitəmat tatəht o kəp məmə, Uhgɨn itəm təmol nɨpətɨtəm, in təmol mɨn nɨkitəm? !Əwəh! ");
INSERT INTO tnn_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Məto otos-ipən kəm ian-rat mɨn e nɨkitəmat agien, kən natɨmnat rafin ihluə ne imə kotətuatɨp motəwɨr. ");
INSERT INTO tnn_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“!Məto itəmat Farisi mɨn, nahməən asol otuwa otəmat! Itəmat nakotətəu-pən wɨr nɨmɨsmɨsɨ Lou mɨn, tahmen e tait rəha nɨmalɨ nɨg mɨn itəm nəmiəwɨlat tatəpien o nolən nagwənən. Məto nakotəuhlin məntaatəmat o nat asol mɨn rəha Lou, inəh nəsotolən nat itəm tətuatɨp mɨn kəm netəmim, kən məsotolkeikeən Uhgɨn. Nəkotəkəike motol nolən wɨr mɨn asol əh, kən məsotaluinən nətəu-pən wɨr mɨnən nɨmɨsmɨsɨ Lou mɨn rafin. ");
INSERT INTO tnn_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Itəmat Farisi mɨn, nahməən asol otuwa otəmat, məto-inu nakotolkeike məmə onəkotuwɨn motəpələh aupən e nimə rəha nuəfɨmɨnən. Kən e maket, nakotolkeike məmə netəmim okotɨləs-ipər nelmɨlat kəm itəmat o nɨsiaiiən itəmat. ");
INSERT INTO tnn_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Itəmat Farisi mɨn, nahməən asol otuwa otəmat, məto-inu itəmat nəkotahmen e suwɨt itəm kotamkɨmɨk, məto kəsɨtun ətuatɨpən məmə in hiə, kən netəmim kotaliwək pɨkən lan motəruru, motol rəhalat nəmegəhən tətamkɨmɨk.” ");
INSERT INTO tnn_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kən iəgətun kit rəha Lou təmən-ipən kəm Iesu məmə, “Iəgətun. Nian nakatən nəghatən mɨn u, kən tatərəkɨn mɨn itɨmat.” ");
INSERT INTO tnn_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kən Iesu təmə, “!Iəgətun mɨn rəha Lou! Nahməən asol otuwa otəmat məto-inu, itəmat nakoatəlɨn-pər nat fɨgəm mɨn itəm tiəkɨs məmə netəmim okoatəmɨk. Məto nəsotasituən məsɨn e noanelmɨtəmat məmə onəkotasitu elat o nəmɨkən natɨmnat mɨn əh. ");
INSERT INTO tnn_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Nahməən asol otuwa otəmat məto-inu əpəh e suwɨt mɨn rəha ien mɨn rəha Uhgɨn aupən, nakoatiləkɨn nimə wɨr mɨn, kən nakoatən məmə nakoatɨsiai-in ilat. Məto nakoteiuə. Tɨpɨtəmat mɨn əm kəmotohamnu ilat. ");
INSERT INTO tnn_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Inəh itəmat nakoatən-iarəp məmə nakotegəhan-in natɨmnat mɨn əh itəm tɨpɨtəmat mɨn kəmoatol aupən, inəh kəmotohamnu ien mɨn, kən itəmat nəkoatol namnun e rəhalat wək nian nakoatiləkɨn suwɨt mɨn rəhalat. ");
INSERT INTO tnn_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Kən o nat əh, Uhgɨn itəm tenatɨg təmən məmə, ‘Io ekahl-ipən rəhak ien mɨn ne aposol mɨn kotuwɨn motəghat kəm ilat, kən ilat okotɨtəp motol nəratən kəm neen, kən motohamnu neen.’ ");
INSERT INTO tnn_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Tol nəhlan, Uhgɨn otakil itəmat tahmen məmə itəmat əm nəmotohamnu ien mɨn rafin rəhan, kən in otol nalpɨnən kəm itəmat o nɨmɨsən rəhalat, ilat itəm kəmotatɨg e nətuounən rəha nətueintən mətoarus-pa u-roiu, ");
INSERT INTO tnn_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ien mɨn rafin itəm kəmotohamnu tətuoun e Epel mətoarus-pən Sekaraea, itəm təmɨmɨs e Nimə Rəha Uhgɨn ilugɨn e olta ne nimə. Nɨpahrienən, itəmat roiu ne, Uhgɨn otol nalpɨnən kəm itəmat. ");
INSERT INTO tnn_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Itəmat iəgətun rəha Lou, nahməən asol otuwa otəmat məto-inu suatɨp kit əh-ikɨn itəm tatəgətun nat naka itəm Uhgɨn tolkeike. Itəmat nəkotɨtun suatɨp əh, məto nakotəhluaig-in məmə netəmim kotəruru. Itəmat nəkəsotətəu-pənən, kən nakahtosɨg-in netəmim məmə ilat mɨn kotəruru nətəu-pənən.” ");
INSERT INTO tnn_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nian Iesu təmiet e nimə əh mɨnataliwək matuwɨn, kən iəgətun mɨn rəha Lou ne Farisi mɨn, neməha təmol ilat. Tətuoun e nian əh, kəmotuwa rəhan tɨkɨmɨr mɨn. Koatərakin-pən nəghatən əskasɨk tepət kəm in ");
INSERT INTO tnn_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","məmə okoteam-in nɨpəgnəmtɨn neen e nəghatən rəhan itəm təsahmenən. ");
INSERT INTO tnn_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kən e nian əh, netəmim tepət kəmotuwa kitiəh, okol kafin kəruru. Məto netəmim tɨnepət pɨk, kən moatəhg-irəkɨs-əhg-irəkɨs ilat mɨn. Kən Iesu təmətuoun matəghat kəm rəhan mɨn netəmim məmə, “Itəmat, nakoatəto itəmat o is rəha Farisi mɨn, is u in nolən rəhalat itəm rəhalat nənən təwɨr, məto nɨkilat tamkɨmɨk. ");
INSERT INTO tnn_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Natɨmnat itəm etəmim tatol anion, Uhgɨn təpanɨləs-iarəpa tagəhag ikɨn. Kən natɨmnat itəm etəmim tatəhluaig-in, kən Uhgɨn təpanɨləs-iarəpa, netəmim okotəplan. ");
INSERT INTO tnn_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Natɨmnat itəm nakoatən e napinəpən, kən netəmim okotəto e nərauiəgən. Kən natɨmnat itəm nakoatən anion e nɨpəgnoa nimə, kən netəmim kəpanotən-iarəp ihluə, netəmim rafin okotəto. ");
INSERT INTO tnn_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Rəhak mɨn netəmim, ekən kəm itəmat məmə, əsotəginən netəmim itəm kotɨtun nohamnuən nɨpətɨtəmat, məto uarisɨg, okol kəsotol mɨnən nat kit tərat kəm itəmat. ");
INSERT INTO tnn_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Məto iatən-iarəp etəmim u kəm itəmat itəm tətuatɨp məmə onakoatəgin. Onəkotəkəike motəgin Uhgɨn, məto-inu nian in otohamnu suah kit, in tɨtun nərakin-pənən in e nɨgəm asol. Əwəh, nɨpahrienən, ekən kəm itəmat məmə nakoatəkəike motəgin Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Mənɨg əlkələh mɨn, katol-salɨm-in ilat tepət nəmtɨn məni əkəku əm, məto Uhgɨn təsaluin agɨn-əhən kit. ");
INSERT INTO tnn_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Əsotəgɨnən, məto-inu Uhgɨn tolkeike itəmat taprəkɨs-in mənɨg mɨn tepət. Nɨpahrienən, Uhgɨn təmafin mɨtun wɨr noanutəmat rafin. ");
INSERT INTO tnn_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ekən kəm itəmat məmə, okəmə etəmim tatən-iarəp e nɨganəmtɨ netəmim məmə in rəhak kit, kən io Nətɨ Etəmim, io mɨn ekən-iarəp e nɨganəmtɨ nagelo mɨn rəha Uhgɨn məmə in rəhak etəmim. ");
INSERT INTO tnn_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Məto okəmə etəmim tatən-iarəp e nɨganəmtɨ netəmim məmə in sənəmə etəmim kit rəhak, kən io ekən-iarəp e nɨganəmtɨ nagelo mɨn rəha Uhgɨn məmə suah u in sənəmə etəmim kit rəhak. ");
INSERT INTO tnn_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Kən etəmim itəm tatən nəghatən rat e Nətɨ Etəmim, Uhgɨn otafəl rəkɨs rəhan təfagə rat. Məto etəmim itəm tatəghat rat e Narmɨn Rəha Uhgɨn, okol Uhgɨn təsafəl rəkɨsən rəhan təfagə tərat. ");
INSERT INTO tnn_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Kən nian koatiuw-iarəp itəmat e nimə rəha nuəfɨmɨnən, ne e nɨganəmtɨ iərəmərə mɨn, ne netəm-iasol mɨn məmə okotiuw-iarəp itəmat motakil motuəh motələhəu nəghatən rəhatəmat, kən nɨkitəmat təsəht pɨkən məmə onəkotahro min-nulan kuhalpɨn rəhalat nəghatən, ");
INSERT INTO tnn_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","məto-inu e nian ətuatɨp əh, Narmɨn Rəha Uhgɨn otəgətun itəmat e nəghatən naka itəm itəmat onakoatəghat-in kən moatən kəm ilat.” ");
INSERT INTO tnn_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kən netəm mɨn əh kit təmən-ipən kəm Iesu məmə, “Iəgətun. Tata rəhak tɨnɨmɨs rəkɨs. Awi, uəh nɨki piak məmə otoor natɨmnat rəha tata rəhatɨmlau məmə otos-ipa rəhak neen, itəm tata təmələhəu məmə rəhak.” ");
INSERT INTO tnn_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Məto Iesu təmən kəm in məmə, “Rəhak etəmim, rəhak tɨkə e nətəlɨgən u rəhatəmlau o noorən rəhatəmlau natɨmnat.” ");
INSERT INTO tnn_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kən Iesu təmən-ipən kəm ilat məmə, “Oatəto wɨr itəmat. Otahtosɨg-in wɨr itəmat məmə onəkəsotuwamən itəmat iaumɨs mɨn, məto-inu nəukətɨ nəmegəhən, in sənəmə nautə tepət.” ");
INSERT INTO tnn_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kən təmuəh nimaa nəghatən u məmə, “Suah kit, rəhan nautə tepət, kən rəhan nasumən tatol nɨpətɨn tepət. ");
INSERT INTO tnn_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kən təmən-ipən atɨp kəm in məmə, ‘?Oekahrol min-nulan, məto-inu rəhak nimə mɨn kɨnəsotahmenən məmə ekəlɨn-pən nɨgak nagwənən mɨn lan?’ ");
INSERT INTO tnn_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Kən in təmən məmə, ‘Təwɨr məmə ekol nulan. Ekəmki-rəkɨs nimə mɨn u, kən ekiləkɨn nimə neen mɨn itəm iahgin məsɨn. Kən ekəlɨn-pən nɨgak nagwənən, ne rəhak nautə mɨn ikɨn. ");
INSERT INTO tnn_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kən ekɨtun nənən məmə, rəhak natɨmnat tepət tepət tahmen o nup tepət. Kən roiu ekameg, mətagwən, matənɨm, kən matəto nagienən təwɨr əm nulan matuwɨn.’ ");
INSERT INTO tnn_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Məto Uhgɨn təmən-ipən kəm in məmə, ‘!Ik ialməl! Roiu əm lapɨn, onakɨmɨs. ?Okahrol rəham natɨmnat u tatəməhl nəmargətain?’” ");
INSERT INTO tnn_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Kən Iesu təmən məmə, “Uhgɨn otol əm nəhlan kəm netəmim itəm kotargətain nautə tepət məmə in rəhalat, məto nɨkin təsəht pɨkən nolən wɨr mɨn itəm Uhgɨn tolkeike.” ");
INSERT INTO tnn_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kən Iesu təmən kəm rəhan netəmim mɨn məmə, “Məto-inu o nolən əh, iatən kəm itəmat məmə, nəsotətəlɨg-in pɨkən natɨmnat rəha nəmegəhən rəhatəmat məmə onəkotun naka, kən məsotətəlɨg-in pɨkən natɨmnat rəha nɨpətɨtəmat məmə onəkotuwɨn-in natɨmnat naka. ");
INSERT INTO tnn_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Əsotətəlɨg-in pɨkən məto-inu nəmegəhən rəhatəmat taprəkɨs-in nagwənən, kən nɨpətɨtəmat taprəkɨs-in napən mɨn rəha nuwɨn-inən. ");
INSERT INTO tnn_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Otəplan-tu mənɨg mɨn, ilat kəsotasumən, kən məsotəuləkən, kən rəhalat nimə rəha nagwənən tɨkə, məto Uhgɨn tətagwən ilat. !Məto Uhgɨn tolkeike pɨk itəmat taprəkɨs-in mənɨg mɨn! ");
INSERT INTO tnn_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","?Nɨkitəmat təht məmə rəhatəmat nətəlɨgən pɨk tɨtun nolən rəhatəmat nəmegəhən təfəməh? !Kəp! Nolən rəha nətəlɨgən pɨk təsafin-pənən aua kitiəh əm e rəhatəmat nəmegəhən. ");
INSERT INTO tnn_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","?Məto okəmə itəmat nəsotɨtunən nolən nat əkəku kit tol nəhlan, tahro nakoatətəlɨg-in pɨk natɨmnat pɨsɨn pɨsɨn mɨn e nəmegəhən rəhatəmat? ");
INSERT INTO tnn_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Nɨkitəmat təht-tu nolən rəha nəguɨ-nɨg mɨn itəm koatəguɨn. Ilat kəsotol wəkən, məsotəhlən rəhalat napən. Məto ekən kəm itəmat məmə aupən, Kig Solomon rəhan nautə tepət, kən rəhan napən təwɨr pɨk, məto rəhan napən mɨn kəsotəwɨrən taprəkɨs-in nəguɨ-nɨg mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nəguɨ-nɨg mɨn əh koatətul rəha nian kitiəh əm, kən olawɨgin, netəmim kotaan ilat e nɨgəm, məto Uhgɨn in tatol ilat kotəwɨr kotəwɨr. ?Kən nɨkitəmat təht məmə in otos-ipɨnə napən kəm itəmat, o kəp? !Əwəh! Rəhak netəmim, rəhatəmat nahatətəən in natiəkəku əm. ");
INSERT INTO tnn_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Təsəwɨrən məmə nɨkitəmat tatəht pɨk natɨmnat o nəmegəhən rəhatəmat, kən nian rafin nakotegəs-in nagwənən nɨgɨtəmat ne nənɨmən nɨmɨtəmat. ");
INSERT INTO tnn_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nɨkitəmat təsəht pɨkən natɨmnat mɨn əh, məto-inu netəm kəsotahatətəən e Uhgɨn, ilat koategəs-in natɨmnat mɨn əh. Rəhatəmat Tata in tɨtun natɨmnat itəm nəkotəkəike motos o nəmegəhən rəhatəmat. ");
INSERT INTO tnn_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Məto nakotətəlɨg-in pɨk natɨmnat rəha nərəmərəən rəha Uhgɨn motol tətul aupən e nəmegəhən rəhatəmat, kən in otos-ipɨnə mɨn kəm itəmat natɨmnat mɨn rəha nəmegəhən ikɨn-u e nətueintən. ");
INSERT INTO tnn_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Əsotəgɨnən, itəmat sipsip mɨn u rəhak itəm itəmat noan məsɨn əm, məto-inu Tata rəhatəmat nɨkin tagien pɨk məmə onəkotatɨg ahgin rəhan nərəmərəən, kən in otehm wɨr itəmat, kən itəmat mɨn onəkotərəmərə itəmat min. ");
INSERT INTO tnn_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Otosalɨm-in rəhatəmat natɨmnat mɨn, kən motos-ipən məni lan kəm ian-rat mɨn. Nian nəkotol təwɨr min-nulan, in tahmen-pən məmə nəkotol rəhatəmat pokɨs rəha məni itəm otəsəratən nian kit, kən nakotələhəu-pən rəhatəmat natɨmnat itəm təwɨr əpəh e nego e neai. Kən ikɨn əh, okol iakləh mɨn kəsotuwɨnən iuəhkɨr motakləh-in, kən okol wɨn mɨn kəsotərəkɨnən natɨmnat mɨn əh. ");
INSERT INTO tnn_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Iatən nəhlan məto-inu, ikɨn pəhruən rəhatəmat natɨmnat wɨr mɨn koatəməhl ikɨn, kən nɨkitəmat otəkəike matəht natɨmnat mɨn əh-ikɨn əh.” ");
INSERT INTO tnn_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Kən Iesu təmən məmə, “Pəs nəkoatətul matɨp nian rafin, tahmen-pən əm məmə nakoatuwɨn-in napən mɨn rəha wək, kən moatehm wɨr məmə rəhatəmat lait otatuəp e nian rafin. ");
INSERT INTO tnn_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Onəkotəkəike motahmen-pən e iolwək mɨn rəha iərəmərə kit itəm tatɨsɨ-pən e lafet kit rəha marɨt. Kən nian in tatuwa matəht-əht toa, kən roiu əm, ilat koaterəh e toa məmə otuwa imə. ");
INSERT INTO tnn_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Iolwək mɨn itəm koataiir moatətul matɨp nian iərəmərə tatuwa, ilat okotehm motos nəwɨrən rəha iərəmərə. Nɨpahrienən ekən kəm itəmat məmə, in otuwɨn-in napən rəha wək, kən maun-in ilat məmə okotuwa kəpələh, kən in otehm wɨr ilat mətagwən ilat. ");
INSERT INTO tnn_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kən okəmə iərəmərə tatuwa lapɨn e napinəpən tɨnəlis kɨnkɨn lan, e nian mənɨg mɨn kɨnotətuoun kɨnoatɨmnən lan, məto iolwək mɨn ilat koatətul matɨp əm, kən in otol təwɨr agɨn kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kən itəmat nəkotəkəike motɨtun məmə, okəmə suah kit tɨtun nian ətuatɨp itəm iakləh otuwa e rəhan nimə məmə otakləh, kən in okol təsapɨlən, in tatətul matɨp matehm wɨr rəhan nimə məmə iakləh otəsuwamən imə. ");
INSERT INTO tnn_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kən itəmat, nian rafin nəkotəkəike moatətul matɨp məto-inu io Nətɨ Etəmim ekuwa mɨn e nian itəm itəmat nakəsotɨtunən.” ");
INSERT INTO tnn_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Kən Pita təmən-ipən kəm in məmə, “Iərəmərə. ?Nakatuəh nimaa nəghatən rəhatɨmat əm, o rəha netəmim rafin?” ");
INSERT INTO tnn_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kən Iərəmərə tatən məmə, “?Pah u in iolwək itəm tenatɨg kən tatol rəhan wək e nian mɨn rafin e nolən itəm təwɨr? ?Kən iərəmərə kit otɨləs-ipər pah in otuwa etəm-iasol rəha iolwək mɨn e nimə rəhan məmə in otoor nagwənən nɨgɨ iolwək mɨn rafin e nian ətuatɨp rəhan? ");
INSERT INTO tnn_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kən nian iərəmərə rəha suah əh tatiet-arəpa, kən məplan məmə in tatol-wɨr rəhan wək, kən in otol təwɨr kəm iolwək əh. ");
INSERT INTO tnn_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nɨpahrienən iakatən kəm itəmat məmə, iərəmərə in otɨləs-ipər iolwək əh tuwa mol etəm-iasol lan məmə in otərəmərə e natɨmnat rafin rəhan. ");
INSERT INTO tnn_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","?Məto tahro? Kəm-naka iolwək un nɨkin otəht məmə, ‘Rəhak etəm-iasol təsuwamən nuwəh. Okotəsuwa uəhaiən.’ Kən iolwək əh tɨnətuoun matoh iolwək mɨn nɨpɨtan ne nəman, kən muwɨn mətagwən matənɨm mətapɨs. ?Kən iərəmərə otol naka? ");
INSERT INTO tnn_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Iərəmərə rəha suah un otiet-arəpa ron e nian kit itəm in təməsɨtunən kən məsətul matɨpən ron. Kən iərəmərə otos-ipən nalpɨnən asol kəm in, kən otɨləs-ipən in tuwɨn matɨg ilat netəm mɨn u itəm kəsotolən rəhan nəghatən. ");
INSERT INTO tnn_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Iolwək əh itəm tɨnɨtun rəkɨs nəghatən rəha iərəmərə rəhan, məto in təsətul matɨpən məmə otol wək mɨn əh, kən okoh in təto nahməən. ");
INSERT INTO tnn_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Məto iolwək itəm in təsɨtunən nəghatən mɨn rəha iərəmərə, kən matol natɨmnat itəm təsətuatɨpən itəm otəkəike mos nalpɨnən ron, kən okoh mətɨg əm iolwək u. Etəmim itəm Uhgɨn tatos-ipən natɨmnat tepət kəm in, in otəkəike mol natɨmnat tepət. Kən etəmim itəm katələhəu-pən natɨmnat tepət e nelmɨn, okatətapəh-in mɨn natɨmnat tepət ron.” ");
INSERT INTO tnn_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Kən Iesu təmən məmə, “Emuwa məmə ekəhlman nɨgəm e nətueintən, kən okəmə roiu əh nɨgəm əh tɨnatuəp rəkɨs, kən nɨkik otagien. ");
INSERT INTO tnn_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nian əskasɨk kit itəm otuwa e rəhak nəmegəhən, tahmen e nolə baptais kit, kən nɨkik tɨtahmə lan mətoarus-pən tɨnol namnun. ");
INSERT INTO tnn_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","?Nɨkitəmat təht məmə emuwa məmə ekələhəu nəməlinuən e nətueintən? !Kəp! Eməsuwamən məmə ekələhəu nəməlinuən, məto emuwa məmə ekol netəmim kotoor ilat mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kən tətuoun u-roiu, okəmə netəmim faif e latuənu kit, kən kotoor ilat mɨn, kɨsɨl katəhaləhai kəiu, kən kəiu katuəhai kɨsɨl. ");
INSERT INTO tnn_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tata in otəhai nətɨn iərman, kən nətɨn əh otəhai rəhan tata. Kən mama in otəhai nətɨn pətan, kən nətɨn əh otəhai rəhan mama. Kən pətan otəhai uhun, kən uhun otəhai nəgon.” ");
INSERT INTO tnn_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kən in təməghat mɨn kəm nɨmanin netəmim matən məmə, “Nian nakotehm nɨmal napuə mɨn okotər, kən nakotən uəhai əm məmə otəfɨk, kən otol mihin. ");
INSERT INTO tnn_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kən nian nəkotəplan məmə nuwɨg təmɨləs kərpəp, nakotən məmə nape-apeən otuwa, kən otol mihin. ");
INSERT INTO tnn_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","!Ei! !Rəhatəmat nənən təwɨr, məto nɨkitəmat tamkɨmɨk! Itəmat nakoatəmə nəkotɨtun pɨk natɨmnat mɨn, kən motɨtun nehmən nɨməptən ne neai, kən nəkotɨtun məmə nian otuwa min-nulan, kən otol nəhlan. ?Məto tahro nakəsotɨtunən nɨpətɨ nəmtətin mɨn itəm nakoatəplan əh-roiu? ");
INSERT INTO tnn_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“?Tahro nakəsotɨtəpunən suatɨp itəm tətuatɨp məmə onəkotətəu-pən? ");
INSERT INTO tnn_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nian suah kit otɨləs ik nakuwɨn e kot, kən nian natualiwək e suatɨp, kən təwɨr məmə nakuaupən muəghat muən wɨr rəhatəmlau nəratən. Okəmə nəkəsioal mihinən, kən otɨləs ik muwɨn e kot, kən etəm-iasol rəha kot otegəhan-in-pən ik e nelmɨ polis, kən polis otɨləs ik muwɨn mahtosɨg-in ik e kalapus. ");
INSERT INTO tnn_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Iatən kəm ik məmə, okəmə tol nəhlan, okol nəsietən e kalapus mətoarus nakətou rafin agɨn nalpɨnən rəham.” ");
INSERT INTO tnn_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kən e nian əh, netəmim neen kəmotuwa kən-ipən kəm Iesu məmə netəm Kalili neen koatoh nat megəh mɨn məmə okotol sakrifais lan kəm Uhgɨn, kən nian kitiəh mɨn əm, mopael mɨn rəha kapman u Pailat kəmotuwa motohamnu ilat, kən nɨtalat nat megəh mɨn kəmotol əm kitiəh kətaiu. ");
INSERT INTO tnn_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Kən Iesu təmən-ipən məmə, “?Tahro? ?Nɨkitəmat təht məmə nɨmɨsən əskasɨk tol min-nulan rəha netəm Kalili əh, tatəgətun məmə ilat netəm rat taprəkɨs-in netəmim rafin rəha Kalili? ");
INSERT INTO tnn_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","!Kəp! Iatən kəm itəmat məmə təsol mihinən nəhlan. Məto okəmə itəmat nakəsotəuhlinən itəmat e nolən rat mɨn rəhatəmat, kən itəmat mɨn onəkotɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","?Kən tahro e netəm eitin rəha Saeloam itəm nimə əfəməh təmiet məfətain ilat kotɨmɨs? ?Nɨkitəmat təht məmə natɨmnat mɨn əh tatəgətun məmə nəmegəhən rəhalat tərat taprəkɨs-in netəmim rafin əpəh Jerusalem? ");
INSERT INTO tnn_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","!Kəp! Iatən kəm itəmat məmə təsol mihinən nəhlan. Məto okəmə itəmat nakəsotəuhlinən itəmat e nolən rat mɨn rəhatəmat, kən itəmat mɨn onəkotɨmɨs.” ");
INSERT INTO tnn_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kən təmuəh nimaa nəghatən u məmə, “Etəmim kit təməfe nɨg kit əpəh e rəhan nasumən, nərgɨn u fik. Kən nian nup mɨn neen təmuwa mɨnuwɨn rəkɨs, suah u təmuwɨn nian tepət mateam-in noa nɨg u, məto tɨkə, məto-inu təsoeən. ");
INSERT INTO tnn_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kən in təmən kəm suah u tatehm nasumən məmə, ‘Əplan-tu. Emuwa mateam-in noa fik u mɨnos nup kɨsɨl, məto esehmən noa nɨg kit ne. Ahtɨhl rəkɨs. Təsəwɨrən məmə tatətulosɨg e nɨməptən rəha nasumən.’ ");
INSERT INTO tnn_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kən suah u tatehm nasumən tuhalpɨn rəhan nəghatən məmə, ‘Etəm-iasol, əpəs əm tos nup kitiəh mɨn əm. Kən ekel nɨsɨp mɨtəlau e nəukətɨn, kən masitu lan məmki-pən nɨsɨp wɨr. ");
INSERT INTO tnn_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kən okəmə tatoe e nup əh-ikɨn, kən təwɨr əm. Məto okəmə kəpə, ik nəkɨtun nəte rəkɨsən.’” ");
INSERT INTO tnn_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kən e Sapat kit, Iesu tatəgətun netəmim əpəh imə e nimə kit rəha nuəfɨmɨnən. ");
INSERT INTO tnn_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kən pətan kit əh-ikɨn itəm narmɨn rat tətatɨg lan e nup eitin, kən tatol məmə məntaan tatəfaiu e nian rafin, kən məsətul ətuatɨpən. ");
INSERT INTO tnn_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kən nian Iesu təmehm in, kən təmaun-in məmə otuwa ron, kən tatən kəm in məmə, “Pətan. Io iatɨkɨs rəkɨs rəham nɨmɨsən, kol təsaskəlɨm mɨnən ik.” ");
INSERT INTO tnn_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kən Iesu təmələhəu-pən nelmɨn lan, kən əmun roiu agɨn-əh mɨn əm, təmətul ətuatɨp mɨnəwɨr, kən mɨnatənwiwi Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Məto etəm-iasol rəha nimə rəha nuəfɨmɨnən, nɨkin təmahmə məto-inu Iesu təmol-wɨr pətan u e nian rəha Sapat. Kən in təmən-ipən kəm netəmim məmə, “Nian sikis rəhatəmat o nol wəkən. Nəkotɨtun nuwamən e nian mɨn əh məmə in otol-wɨr itəmat lan, məto e nian rəha Sapat, okol nəsotuwamən lan.” ");
INSERT INTO tnn_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Kən Iərəmərə təmən-ipən kəm in məmə, “!Rəhatəmat nənən təwɨr, məto nɨkitəmat tamkɨmɨk! ?Pah u e nɨkitəmat e nian rəha Sapat, kən təsɨkɨsən rəhan pɨlɨk o togki itəm təməru ətain, masɨg muwɨn tətanəm nəhau? !Kəp! Itəmat rafin nəkoatol min-nəhlan. ");
INSERT INTO tnn_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Məto pətan əh, in noanol kit rəha Epraham, itəm Setan təməlis o nup eitin. Tətuatɨp əm məmə io ekəike mɨkɨs kən mosmegəh in e nian rəha Sapat.” ");
INSERT INTO tnn_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kən nəghatən rəha Iesu təmol rəhan tɨkɨmɨr mɨn kəmotaulɨs. Kən netəmim rafin, nɨkilat tətagien o wək wɨr agɨn mɨn itəm Iesu tatol ilat. ");
INSERT INTO tnn_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kən Iesu təmən məmə, “?Nərəmərəən rəha Uhgɨn in tahmen e naka? ?Kən io oekən nəghatən naka kən məgətun lan? ");
INSERT INTO tnn_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nərəmərəən rəha Uhgɨn, in tahmen-pən e noa nəpɨk itəm natiəkəku, kən suah kit təmɨləs məfe e rəhan nasumən. Kən nɨkutin tɨnəwiə mɨnol iahgin, kən mənɨg ilɨs mɨn kotuwa moatol-pən nimaalat e nelmɨn mɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kən təmən mɨn məmə, “?Iatəgətun nərəmərəən rəha Uhgɨn məmə in tahmen-pən e naka? ");
INSERT INTO tnn_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","In tahmen-pən e is noan məsɨn itəm pətan kit tətalkin e flaoa tepət itəm kəmol-pən e pesɨn asol, kən tətahl flaoa rafin tətasis matol iahgin.” ");
INSERT INTO tnn_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Kən nian Iesu təmaliwək matuwɨn Jerusalem, kən matəgətun netəmim e taon mɨn ne latuənu mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kən suah kit təmətapəh ron məmə, “?Iərəmərə, netəmim noan məsɨn əm itəm Uhgɨn otosmegəh ilat?” Kən Iesu təmən-ipən kəm ilat məmə, ");
INSERT INTO tnn_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Iatən kəm itəmat məmə onəkotəkəike motalkut pɨk məmə nakotuwɨn-pən e toa itəm natiəkəku tatuwɨn e nego e neai, məto-inu netəmim tepət itəm okotalkut məmə okotuwɨn imə, məto ko kəsotuwɨnən. ");
INSERT INTO tnn_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Məto o nian kit, iərəmərə rəha nimə əh in otətul mahtosɨg e rəhan toa. Kən itəmat itəm nəsotuwamən əh imə e toa itəm natiəkəku əh, onakoatətul ihluə moatəht-əht toa moatən məmə, ‘Awi, Iərəmərə. !Erəh e toa otɨmat!’ Məto in otən məmə, ‘Ekəruru agɨn-əh itəmat.’ ");
INSERT INTO tnn_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kən itəmat nakotətuoun moatən məmə, ‘Iərəmərə, kitat kəmotagwən kələh, kən ik nəmatəgətun itɨmat əpəh e rəhatɨmat ikɨn.’ ");
INSERT INTO tnn_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Məto in otən-ipɨnə məmə, ‘Io ekatən kəm itəmat məmə ekəruru agɨn-əh itəmat. Itəmat rafin netəm nakotərat agɨn. !Otuwɨn isəu ron io!’ ");
INSERT INTO tnn_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“E nian əh itəmat onəkotehm Epraham, ne Aisak, ne Jekop, ne ien mɨn aupən koatatɨg e nego e neai itəm Uhgɨn tatərəmərə lan, məto itəmat onakoatətul ihluə kən okərakin-iarəp itəmat, kən onəkotasək, moatəgətain nəluɨtəmat, moatəto tərat. ");
INSERT INTO tnn_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kən netəmim okotɨsɨ-par, kən motɨsɨ-pah, kən motɨsɨ-pəhap, kən motɨsɨ-pis, məmə okotuwɨn motəpələh motagwən e nego e neai itəm Uhgɨn tatərəmərə lan. ");
INSERT INTO tnn_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kən təwɨr məmə nəkotɨtun məmə, netəmim neen itəm koatuarisɨg əh-roiu, ilat okotuwa motətul aupən. Kən netəmim neen itəm koatətul aupən əh-roiu, ilat okəpanotuwa motətul uarisɨg.” ");
INSERT INTO tnn_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kən e nian əh, Farisi mɨn neen kəmotuwa motən-ipən kəm Iesu məmə, “Təwɨr məmə nakiet uəhai əm u ikɨn-u matuwɨn, məto-inu Herot Antipas tolkeike məmə otohamnu ik.” ");
INSERT INTO tnn_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Kən Iesu təmən-ipən kəm ilat məmə, “Herot Antipas in iol keko-eko, tahmen e kuri iarupɨn itəm tətagwən mɨtə. Otuwɨn motən-ipən kəm in məmə io ekatən məmə, ‘Ehm-tu. Nian əkuəkɨr əm əh-ikɨn tətatɨg itəm io ekəhg-iarəp narmɨn rat mɨn e netəmim, kən matol-wɨr nɨmɨsən rəha netəmim, kən uarisɨg e nian kɨsɨl lan, kən ekol namnun rəhak wək.’ ");
INSERT INTO tnn_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","“Nat əpnapɨn Herot təmən nəhlan, məto io ekəike matətəu-pən rəhak suatɨp matuwɨn u-roiu, ne olawɨg, ne oniəh muwɨn miet-pən Jerusalem. Inu ikɨn ətuatɨp itəm okotəkəike kɨsiai-in ien mɨn ikɨn. Məto Jerusalem əm, katohamnu ien mɨn rəha Uhgɨn ikɨn. ");
INSERT INTO tnn_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“!Awe, netəm Jerusalem, netəm Jerusalem! Itəmat nakotohamnu ien mɨn rəha Uhgɨn, kən netəmim itəm Uhgɨn təmahl-ipa kəm itəmat, nəkotahtɨmnu ilat e kəpiel apɨn, inəh netəm u rəha Uhgɨn itəm koatos nəghatən rəhan. Nian tepət iatəg-əfəməh-in nelmək məmə iatəmɨk-əfɨmɨn wɨr itəmat matos wɨr itəmat, tahmen-pən e mənɨg itəm tatu nenətɨn mɨn e nɨkwɨn, məto itəmat nɨkitəmat təsagienən ron kən motapəs io. ");
INSERT INTO tnn_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kən nəkotɨtun məmə Uhgɨn təmapəs itəmat, kən iakatən kəm itəmat məmə okol nəkəsotehmən io matuwɨn matuwɨn mətoarus nakotən məmə, ‘!Iərəmərə Uhgɨn tətatɨg ilau suah u itəm tatuwa e nərgɨn!’” ");
INSERT INTO tnn_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","E nian rəha Sapat kit, Iesu təmuwɨn e nimə rəha etəm-iasol kit rəha Farisi mɨn məmə okotagwən, kən netəmim koatɨsɨlu wɨr məmə okotehm-tu naka əh otol. ");
INSERT INTO tnn_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Kən inəh Iesu tatəpələh ikɨn, suah kit tatɨmɨs e nɨmɨsən rəha kasis-asis, tatəpələh iuəhkɨr əm ron. ");
INSERT INTO tnn_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kən Iesu təmətapəh o iəgətun mɨn rəha Lou ne Farisi mɨn məmə, “?Tahro? ?Lou tategəhan-in məmə suah kit otol-wɨr netəm koatɨmɨs kotəmegəh mɨn e nian rəha Sapat, o kəp?” ");
INSERT INTO tnn_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Məto ilat kəsotənən nat kit ne. Kən Iesu təmos suah un, mol nɨpətɨn təwɨr mɨn, kən mahl-ipən tatuwɨn. ");
INSERT INTO tnn_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kən təmən-ipən kəm ilat məmə, “?Okəmə itəmat kit, rəhan suakəku, o rəhan kau otiwɨg-pən pɨkən e noakɨmɨl asol e nian rəha Sapat, kən in otol naka? In otəkəike muwɨn mɨləs-irəkɨs uəhai əm. ?Pah u etəmat otəsol mihinən?” ");
INSERT INTO tnn_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kən nəghatən rəhalat təmɨkə məmə okotən. ");
INSERT INTO tnn_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kən Iesu təmehm netəmim neen itəm kəmaun-in ilat o nagwənən, kən kəmotuwa imə motɨtəpun ikɨn mɨn rəha nɨsiaiiən məmə okotəpələh aupən ikɨn. Kən təmən-ipən kəm ilat məmə, ");
INSERT INTO tnn_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Okəmə etəmim tətaun-in ik məmə onəkuwa o nagwənən kit rəha marɨt, kən nəsuwɨnən məpələh ikɨn rəha nɨsiaiiən. Məta suah kit in ilɨs katɨsiai-in pɨk tuwa, ");
INSERT INTO tnn_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","kən etəm-iasol rəha nimə otən kəm ik məmə, ‘Agɨm. Pəs suah u in təpələh u ikɨn-un.’ Kən onakaulɨs məto-inu nakəkəike muwɨn məpələh ləhau agɨn itəm nɨsiaiiən tɨkə ikɨn. ");
INSERT INTO tnn_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Məto okəmə suah kit tətaun-in ik məmə nakuwɨn magwən e lafet kit, kən təwɨr məmə nakɨtəpun ikɨn nɨsiaiiən tɨkə ikɨn. Kən tol nəhlan, nian etəm-iasol rəha nimə tatuwa, in otən kəm ik məmə, ‘Rəhak etəmim, uwɨn məpələh ilɨs, ikɨn rəha nɨsiaiiən.’ Kən inu otɨləs-ipər nərgəm e nɨganəmtɨ netəmim rafin əh imə. ");
INSERT INTO tnn_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ekən nəhlan məto-inu etəm tatɨləs-ipər atɨp in məmə in otuwa etəm-iasol, Uhgɨn otɨləs-iəhau in. Məto etəmim itəm tatɨləs-iəhau atɨp in, Uhgɨn otɨləs-ipər mol tuwa etəm-iasol.” ");
INSERT INTO tnn_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kən Iesu təmən-ipən kəm etəm-iasol rəha nimə məmə, “Okəmə natol nagwənən asol kit e nərauiəgən o lapɨn, təsəwɨrən məmə nakaun-in ik mɨn neen, ne piam mɨn, ne rəham noanol mɨn, ne netəm rəhalat nautə tepət itəm kotatɨg kɨtəlau lam. Okəmə natol mihin, kən məta, ilat mɨn okotaun-in ik məmə nakuwɨn motagwən itəmat min, kən ilat okotalpɨn nat nəmol kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Məto nian natol lafet kit, kən onakəkəike maun-in ian-rat mɨn, ne netəm nɨpətɨlat məsɨn tərat, ne ielkɨn rat mɨn, ne netəm nɨganəmtɨlat təpɨs, məmə okotuwa nakotagwən. ");
INSERT INTO tnn_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kən Uhgɨn otawte-in rəhan nəwɨrən kəm ik, məto-inu okol ilat kəsotalpɨn agɨn-əhən nat nəmol kəm ilat. Məto e namnun nian, nian netəm kotətuatɨp okoatəmegəh mɨn, kən Uhgɨn otətou ik lan.” ");
INSERT INTO tnn_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kən ilat kit əh-ikɨn itəm tətagwən təməto nəghatən əh, kən təmən-ipən kəm Iesu məmə, “Təwɨr pɨk o etəmim itəm otuwɨn əpəh e nego e neai itəm Uhgɨn tatərəmərə lan, kən magwən e lafet asol rəhan.” ");
INSERT INTO tnn_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Məto Iesu təmən kəm in məmə, “Nian kit, suah kit təmol nagwənən asol kit rəhan, kən maun-in netəmim tepət məmə okotuwa kagwən kələh ilat min. ");
INSERT INTO tnn_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kən e nian rəha nagwənən, in təmahl-ipən rəhan iolwək məmə otuwɨn mən-iarəp kəm netəmim itəm təmaun-in rəkɨs ilat. Kən tən-ipən kəm ilat məmə, ‘Otuwa kagwən, məto-inu enol əpenə-penə rəkɨs e nagwənən.’ ");
INSERT INTO tnn_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Məto ilat rafin kəmotapəs nuwɨnən moatən məmə okol kəsotuwamən. Kit təmaupən mən kəm in məmə, ‘Kəsi. Ən-tu kəm rəham iərəmərə məmə ko esɨmnən məto-inu, emos-nəmtɨn əm nɨməptən kit, kən ekəike muwɨn mətag.’ ");
INSERT INTO tnn_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Kən kit mɨn təmə, ‘Kəsi. Ən-tu kəm rəham iərəmərə məmə ko esɨmnən məto-inu, emos-nəmtɨn əm kau ten rəha niuwən kat, kən ekəike muwɨn mehm pitən rəhalat mɨn wək.’ ");
INSERT INTO tnn_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Kən kit mɨn təmə, ‘Ən-tu kəm rəham iərəmərə məmə ko esɨmnən məto-inu, kəmit rəhak pətan ka latuənu əh-roiu.’ ");
INSERT INTO tnn_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Kən iolwək təmuwa mən-ipən kəm rəhan etəm-iasol. Kən etəm-iasol un nɨkin təmahmə təmahmə, kən təmən kəm rəhan iolwək məmə, ‘Uwɨn uəhai e suatɨp ne ikɨn mɨn neen e taon meam-in ian-rat mɨn, ne netəm nɨpətɨlat məsɨn tərat, ne netəm nɨganəmtɨlat təpɨs, ne ielkɨn rat mɨn, kən mit ilat motuwa.’ ");
INSERT INTO tnn_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kən in təmol əm məmə rəhan etəm-iasol təmən mihin ne, kən təmɨtəlɨg-pa mən-ipən məmə, ‘Etəm-iasol. Natɨmnat rafin itəm nəmən, io enol rəkɨs, məto nagwənən tepət əh-ikɨn kən nimə tahmen e netəmim neen mɨn.’ ");
INSERT INTO tnn_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Kən etəm-iasol təmən kəm iolwək məmə, ‘Kən uwɨn e suatɨp, ne ikɨn mɨn rafin ihluə e taon, kən uwɨn muəh nɨkilat məmə ilat okotuwa imə, məmə nimə u rəhak otəkəike mər wɨr. ");
INSERT INTO tnn_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Məto ekən kəm ik məmə netəm emaun-in ilat aupən, ko kəsotun asgəwɨnən nagwənən məsɨn rəhak.’” ");
INSERT INTO tnn_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Netəmim tepət tepət koatuarisɨg-in Iesu e suatɨp. Kən in təmeirair mən-ipən kəm ilat məmə, ");
INSERT INTO tnn_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Okəmə suah kit tolkeike məmə otuwa muarisɨg-in io, in otəkəike mos io ekətul aupən e rəhan nəmegəhən. In otəkəike molkeike io maprəkɨs-in rəhan tata ne mama ne rəhan pətagwəhl ne nətɨn mɨn ne pian mɨn ne wɨnɨn mɨn, ne in atɨp mɨn. Okəmə təsol mihinən, kən ko in təsahmenən məmə otuwa mol rəhak lan etəmim. ");
INSERT INTO tnn_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kən etəmim pah itəm təsɨləsən rəhan nɨg kəluau mətəu-pa io, kən ko in təsahmenən məmə otuwa mol rəhak lan etəmim. ");
INSERT INTO tnn_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Okəmə itəmat kit tolkeike məmə otiləkɨn nimə asol kit kaifəməh, kən in otaupən məpələh mehm wɨr məni rəha natɨmnat mɨn məmə otehm rəhan məni məmə tahmen, o kəp. ");
INSERT INTO tnn_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","In tatol nəhlan məto-inu okəmə in təsaupənən mehm wɨr məni ron, kən in tatətuoun matol fauntesen əm, məto tɨnəruru nol rafinən, kən netəmim rafin itəm okotuwa motehm, kən okotalah-əmnu moatən məmə, ");
INSERT INTO tnn_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Əplan-tu. Suah u təmətuoun əm rəhan nimə, məto tɨnəruru nol rafinən.’ ");
INSERT INTO tnn_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Kən okəmə kig kit rəhan mopael ilat ten-taosan əm, tatəto namnusən məmə kig pɨsɨn kit mɨn itəm rəhan mopael mɨn tuente-taosan tatuwa məmə okuəluagɨn, kən otəsuwɨn uəhaiən o nəluagɨnən. Aupən ikɨn, otəkəike məpələh mehm wɨr məmə in tɨtun nol winən, o kəp. ");
INSERT INTO tnn_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Okəmə tɨtun məmə okol təsol winən, in otəkəike mahl-ipən netəmim neen kotuwɨn motehm rəhan tɨkɨmɨr nian in əpəh isəu əh, kən okotətapəh o nəməlinuən. ");
INSERT INTO tnn_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kən e nolən ahmen mɨn əm, itəmat nəkotəkəike motəpələh motehm wɨr nəmegəhən rəhatəmat. Okəmə itəmat kit təsapəsən əh rəhan natɨmnat mɨn rafin, kən ko in təsahmenən məmə otuwa mol rəhak lan etəmim.” ");
INSERT INTO tnn_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Nian etəmim kit takiəh nien, kən nɨpətɨ nien in təwɨr o nawɨrən nagwənən. Məto nian kɨnawɨr rəkɨs nagwənən lan, kən nɨpatin təsəwɨr mɨnən o nunən. ");
INSERT INTO tnn_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kən okol kəsolən nat wɨr kit lan, kən netəmim okotərakin əm. Etəm matəlgɨn tatɨg, təwɨr məmə in otətəlɨg-in wɨr kən mɨtun nəghatən mɨn u.” ");
INSERT INTO tnn_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","E nian əh, netəmim tepət itəm koatos məni rəha takɨs, ne netəmim tepət itəm nol təfagə rat, kəmotuwa məmə okotətəlɨg-in Iesu. ");
INSERT INTO tnn_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Kən Farisi mɨn ne iəgətun mɨn rəha Lou koatəghat rat Iesu o netəm nol təfagə rat mɨn əh, moatən məmə, “Suah əh, nɨkin tətagien əm məmə nol təfagə rat mɨn koatuwɨn ron, kən motagwən kələh.” ");
INSERT INTO tnn_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kən e nəghatən mɨn u, Iesu təmuəh nimaa nəghatən u məmə, ");
INSERT INTO tnn_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“?Itəmat pah u, rəhan sipsip wan-hanrɨt, kən kitiəh təməlue, məto in nɨkin təsəhtən? Okəmə itəmat kit rəhan sipsip təmɨkə nəhlan, kən in otəkəike mapəs rəhan nainti-nain sipsip koatun kras moatətul əpəh təpiə ikɨn, kən in otuwɨn mategəs-in itəm təməlue mətoarus-pən in otehm. ");
INSERT INTO tnn_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kən nian in təmehm, təmɨləs-ipər məhun, kən nɨkin tətagien. ");
INSERT INTO tnn_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kən nian in təmiet-arəpa latuənu, in otəkəike maun-in in mɨn neen, ne netəm kotatɨg motɨtəlau lan, kən mən-ipən kəm ilat məmə, ‘Otuwa kotagien kələh, məto-inu emehm mɨn rəhak sipsip itəm təməlue.’” ");
INSERT INTO tnn_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kən nian Iesu təmol namnun nimaa nəghatən, təmən-ipən kəm ilat məmə, “Kən iatən kəm itəmat məmə, tahmen-pən əm əpəh e nego e neai. Okəmə iol təfagə rat kit tatəuhlin rəhan nəmegəhən kəm Uhgɨn, kən nagienən əpəh ilɨs e nego e neai o suah əh in tepət, taprəkɨs-in nagienən o netəmim nainti-nain itəm nɨkilat təht məmə kotətuatɨp məsotolən nat kit tərat itəm okotəkəike motəuhlin nəmegəhən rəhalat ron.” ");
INSERT INTO tnn_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Kən Iesu təmatɨg məghat mɨn məmə, “?Okəmə pətan kit rəhan məni ten kəmol e silfa, kən in təmɨkɨl kitiəh, kən in otol naka? In otasiepən e lait kit, kən mol pɨrum megəs-in wɨr əpəh imə matuwɨn matuwɨn mehm. ");
INSERT INTO tnn_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kən nian təmehm məni əh, in otaun-in rəhan mɨn neen ne netəm kotatɨg motɨtəlau lan, matən məmə, ‘Otuwa kotagien kələh məto-inu emehm rəkɨs məni ilou rəhak təmɨkə.’” ");
INSERT INTO tnn_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kən nian Iesu təmol namnun nimaa nəghatən, təmən-ipən kəm ilat məmə, “Kən ekolkeike məmə ekən kəm itəmat məmə, e nolən kitiəh mɨn əm, nagienən asol e nɨganəmtɨ nagelo mɨn əpəh ilɨs e nego e neai, nian iol təfagə rat kit tatəuhlin rəhan nətəlɨgən matuwɨn o Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kən Iesu təmatəkəike matən məmə, “Suah kit, nətɨn iərman kəiu. ");
INSERT INTO tnn_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","In əkəku lan tən-ipən kəm rəhalau tata məmə, ‘Tata. Oor nautə mɨn rəham, mos-ipa rəhak u-roiu.’ Kən rəhalau tata toor rəhan natɨmnat mos-ipən kəm ilau. ");
INSERT INTO tnn_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Kən təsuwəhən, nətɨn in əkəku lan tos rəhan lan muwɨn mol-salɨm-in ilat, kən mos məni e nautə mɨn un miet iməlat ikɨn muwɨn e nəptən pɨsɨn kit mɨn isəu. Kən ikɨn əh, təmatərəkɨn rəhan məni e nolən rat mɨn matuwɨn matuwɨn. ");
INSERT INTO tnn_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kən nian rəhan məni tɨnɨkə rafin, nəumɨs asol tɨnɨtan e nɨtən əh, kən nəumɨs tɨnatus suah un, nɨgɨn nagwənən tɨnɨkə. ");
INSERT INTO tnn_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kən təmuwɨn matol wək kəm suah kit əh-ikɨn əh, kən suah u təmahl-ipən məmə otuwɨn mətagwən rəhan pɨkəs mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kən nəumɨs təmus pɨk məmə in tolkeike məmə otun nagwənən nɨgɨ pɨkəs mɨn, məto etəmim tɨkə itəm otos-ipən nat kit kəm in. ");
INSERT INTO tnn_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Kən nətəlɨgən wɨr tɨnuwa mɨn lan, kən matətəlɨg-in məmə, ‘Kəsi. Roiu əh iolwək mɨn rəha tata, nɨgɨlat nagwənən tepət maprəkɨs, məto io ekətatɨg u ikɨn-u, otəsuwəhən kən ekɨmɨs e nəumɨs. ");
INSERT INTO tnn_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Oekiet u ikɨn-u mɨtəlɨg-pən o rəhak tata, kən mən-ipən kəm in məmə, “Tata. Io emol tefagə tərat kəm Uhgɨn ne ik. ");
INSERT INTO tnn_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Roiu əh esahmenən məmə onəkaun-in io məmə nətɨm. Məto aun-in io ekahmen-pən əm məmə io iolwək əm kit rəham.”’ ");
INSERT INTO tnn_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kən təmətul maliwək mɨnatuwɨn məmə otehm rəhan tata. “Məto nian təmatuwa əh əpəh isəu, rəhan tata təmasɨpən məplan, kən təmasəkitun, maiu muwɨn mɨləs muətain mətagien ron. ");
INSERT INTO tnn_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kən netɨn tən-ipən kəm in məmə, ‘Tata. Io emol tefagə tərat kəm Uhgɨn ne ik. Roiu əh esahmenən məmə onəkaun-in io məmə nətɨm.’ ");
INSERT INTO tnn_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Məto rəhan tata taun-in rəhan iolwək mɨn mən-ipən kəm ilat məmə, ‘!Ei! Otuwɨn uəhai motos kot itəm in təwɨr maprəkɨs motuwa kuwɨn-in-pən kəm in, kən motos rig motarɨgɨn-pən e noanelmɨn, kən motos put ka kuwɨn-in-pən e nelkɨn, ");
INSERT INTO tnn_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","kən motɨləs pɨlɨk itəm tasis-asis məwɨr motuwa koh, pəs kotol kələh lafet lan rəha nətɨk, ");
INSERT INTO tnn_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","məto-inu nətɨk u, in tahmen əm məmə təmɨmɨs rəkɨs, məto roiu in tɨnəmegəh mɨn. In təməlue, məto enehm mɨn.’ Kən ilat kɨnoatol lafet. ");
INSERT INTO tnn_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Kən e nian əh, netɨn asol lan in əpəh e nasumən. Kən e nian təmatuwa mɨnuwa iuəhkɨr o latuənu, kən mɨnəto netəmim koatol napuən mɨn, moatol tanis. ");
INSERT INTO tnn_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kən təmaun-in iolwək kit tuwa tətapəh ron məmə, ‘?Ei, naka əh netəmim koatol?’ ");
INSERT INTO tnn_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kən tən-ipən kəm in məmə, ‘Piam təmuwa, kən rəham tata təmoh pɨlɨk itəm tasis-asis məto-inu piam tɨnɨtəlɨg-pa mɨn, kən in təsanən əm.’ ");
INSERT INTO tnn_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Kən nɨkin təmahmə, kən məmə, ‘Okol esuwɨnən imə.’ Kən rəhan tata təmuwa ihluə matəkəike kəm in məmə otuwɨn imə. ");
INSERT INTO tnn_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Məto tən-ipən kəm rəhan tata məmə, ‘Əplan-tu. Kəmuatɨg nup tepət rəkɨs, kən iatol wək u ikɨn-u tahmen-pən əm məmə rəham kit iolwək, kən məsəhtən nəwiam kit ne. ?Məto tahro, tata? Nəməsos-ipamən nat əkəku kit kəm io tahmen-pən e nəni, məmə ekol nagwənən lan itɨmat io mɨn neen. ");
INSERT INTO tnn_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Məto nətɨm əh itəm təmərəkɨn rafin rəham nautə o nətouən nɨpɨtan mɨn lan rəha suatɨp, kən nian tɨnɨtəlɨg-pən latuənu, kən nakətul matoh pɨlɨk tasis-asis matol lafet lan rəhan.’ ");
INSERT INTO tnn_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Kən rəhan tata tən-ipən məmə, ‘Nətɨk. Nian rafin kilau min ik kətuatɨg, kən natɨmnat rafin rəhak in rəham. ");
INSERT INTO tnn_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Məto tətuatɨp əm məmə okotol lafet u motagien, məto-inu piam u tahmen-pən əm məmə təmɨmɨs rəkɨs, məto roiu in tɨnəmegəh mɨn. In təmɨkə, məto roiu kɨnotehm mɨn.’” ");
INSERT INTO tnn_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Kən Iesu təmən kəm rəhan mɨn netəmim məmə, “Suah kit rəhan nautə tepət, kən in təmos suah kit tuwa etəm-iasol o rəhan iolwək mɨn. Kən rəhan iolwək mɨn neen kəmotuwa moatən-ipən nəratən rəha etəm-iasol əh kəm iərəmərə, moatən məmə, ‘Ei, suah əh tatərəkɨn rəham natɨmnat.’ ");
INSERT INTO tnn_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kən təmaun-in suah əh tuwa tatəghat kəm in məmə, ‘?Ei, nəghatən naka mɨn u iakatəto katən lam? Ekolkeike məmə nakos rafin nəghatən mɨn rəha wək rəham muwa, məto-inu roiu ekahl-iarəp ik e wək.’ ");
INSERT INTO tnn_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Kən etəm-iasol əh təmuwɨn matətəlɨg-in məmə, ‘Awe. Rəhak iərəmərə tolkeike məmə otərakin io e rəhak wək u-roiu. ?Kən ekol naka əh-roiu? Nahgik təsahmenən məmə ekel nɨsɨp mos məni ikɨn, kən io iaulɨs pɨk o neasiə-inən məni o netəmim. ");
INSERT INTO tnn_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","!Ei! Roiu əh enɨtun nat naka itəm io ekol pəs netəmim okotit io motuwɨn iməlat ikɨn moatehm wɨr io nian rəhak iərəmərə otərakin io e rəhak wək.’ ");
INSERT INTO tnn_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Kən in təmaun-in rafin netəmim itəm kəmotol kaon kəm iərəmərə kotuwa ron kitiəh kitiəh. Kən təmən-ipən kəm itəm təmaupən muwa məmə, ‘?Ik nəmol kaon e naka?’ ");
INSERT INTO tnn_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Kən suah əh təmən məmə, ‘Eməmɨk tram rəha oel o noahən ilat wan-hanrɨt.’ Kən etəm-iasol təmən kəm in məmə, ‘Inu ma pepe rəha kaon rəham. Əpələh uəhai əm-tu, kən əte-pən fifti tram əm e rəham pepe.’ ");
INSERT INTO tnn_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Kən təmən-ipən kəm suah kit mɨn məmə, ‘?Ik nəmol kaon e naka?’ Kən in təmə, ‘Emol kaon e wan-taosan pak wit.’ Kən etəm-iasol təmə, ‘Os ma pepe rəha kaon rəham, kən əte-pən əm eit-hanrɨt pak wit.’ ");
INSERT INTO tnn_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Kən uarisɨg lan, iərəmərə rəha etəm-iasol apon itəm təmatol tərat kəm in, təmatənwiwi in o rəhan nolən rəha neiueiuəən məmə in otehm wɨr atɨp in. Nat u tatəgətun məmə netəmim rəha nətueintən, ilat kotenatɨg wɨr o nolən mɨn rəha nətueintən nian ilat koatəghat kəm ilat mɨn, taprəkɨs-in nenatɨgən rəha netəmim rəha nəhag-əhagən. ");
INSERT INTO tnn_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Kən iatən kəm itəmat məmə, otasitu wɨr e netəmim e məni rəha nətueintən məmə ilat okotuwa iolɨtəmat mɨn. Kən nian məni rəha nətueintən otɨkə, kən Uhgɨn otos itəmat muwɨn əpəh e nego e neai itəm otətatɨg lilɨn. ");
INSERT INTO tnn_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Okəmə nəkɨtun məmə suah kit tatehm wɨr nat əkəku kit, kən nəkɨtun məmə in tɨtun nehm wɨrən nat itəm iahgin. Kən okəmə nəkɨtun məmə suah kit tatol nolən itəm təsətuatɨpən e nat əkəku kit, kən nəkɨtun məmə in otol nolən təsətuatɨpən e nat itəm iahgin. ");
INSERT INTO tnn_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","?Kən tol nəhlan, okəmə itəmat nəkəsotehm wɨrən məni rəha nətueintən u, kən pah otegəhan-in itəmat məmə nakotos nat itəm təwɨr pahrien, inəh natɨmnat rəha Uhgɨn? ");
INSERT INTO tnn_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kən okəmə itəmat nəkəsotehm wɨrən natɨmnat rəha suah kit mɨn, kən nɨkitəmat təsəhtən məmə okos-ipən əh mɨn kəm itəmat rəhatəmat atɨp natɨmnat məto-inu, katəplan məmə onəkəsotehm wɨr mɨnən natɨmnat mɨn əh. ");
INSERT INTO tnn_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Etəmim tɨkə itəm tɨtun nuwamən in slef rəha etəm-iasol kəiu. Okəmə in tətalkut məmə otol nəhlan, kən otolkeike kit mol nəwian, kən metəhau kit məsolən nəwian. Okol nəsolən slef rəha Uhgɨn ne məni e nian kitiəh əm.” ");
INSERT INTO tnn_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisi mɨn kotolkeike pɨk məni, kən nian kəmotəto nəghatən mɨn u, kən kəmotalah-əsan e Iesu. ");
INSERT INTO tnn_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Məto in təmən kəm ilat məmə, “Itəmat nəkoatol nolən mɨn itəm koatol netəmim koatən məmə nəkotətuatɨp. Məto Uhgɨn tɨtun nɨkitəmat məmə kotərat. Iatən nəhlan məto-inu nat naka itəm netəmim koatɨləs-ipər məmə in nat keike, məto e nɨganəmtɨ Uhgɨn in nat əpnapɨn əm.” ");
INSERT INTO tnn_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Kən in təmatəkəike matən məmə, “Kəmən-iarəp Lou ne nəghatən rəha ien mɨn rəha Uhgɨn mətoarus-pa Jon Baptais, kən uarisɨg lan, katən-iarəp namnusən təwɨr rəha nərəmərəən rəha Uhgɨn, kən netəmim rafin kotalkut pɨk məmə okotuwɨn motatɨg ahgin. ");
INSERT INTO tnn_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Məto kəsənən məmə wək rəha Lou ne nəsanənən rəhan təmɨkə. Nəghatən rafin rəhan kotatɨg, in asol mɨn mətoarus-pən in əkəku agɨn. Lou otətatɨg taprəkɨs-in neai ne nətueintən. ");
INSERT INTO tnn_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Kən tahmen-pən əm nulan: okəmə suah kit tatol tifos mətapəs rəhan pətan, kən matit pətan pɨsɨn kit mɨn mətuatɨg, kən in tategoafəl rəhan pətan matol təfagə rat. Kən okəmə suah kit tatit pətan kit itəm rəhan iərman təmapəs kən ilau mətuatɨg, kən in tatol təfagə rat məto-inu in tətakləh-in pətan rəha suah pɨsɨn kit.” ");
INSERT INTO tnn_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Kən Iesu təmən məmə, “Suah kit rəhan nautə tepət tatuwɨn e napən wɨr mɨn nəguɨ-naris itəm nəmtɨn tiəkɨs, kən nian rafin tatun pɨk nagwənən wɨr mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Kən ian-rat kit, nərgɨn u Lasaros, nɨməgəm təmɨrafin nɨpətɨn. Kən kəmɨləs kan kələhəu əpəh e nafiluə rəha latuənu. ");
INSERT INTO tnn_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","In tolkeike pɨk məmə otun nɨmɨsmɨsɨ nagwənən itəm təmɨsas e tepɨl rəha etəm-iasol əh. Kən nat kit tərat mɨn, kuri mɨn kotuwa moatəpəh-əpəh nɨməgəm mɨn rəhan. ");
INSERT INTO tnn_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Kən ian-rat əh təmɨmɨs, kən nagelo mɨn kəmotɨləs motuwɨn əpəh e nɨkalɨ Epraham, ikɨn rəha nɨsiaiiən. Suah un rəhan nautə tepət, in təmɨmɨs mɨn, kən kəmɨtənɨm. ");
INSERT INTO tnn_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kən in tuwɨn əpəh e nɨgəm asol, kən tatəto nahməən asol, kən nian təmasɨpər, təməplan Epraham əpəh isəu. Kən Lasaros əpəh e nɨkalɨn. ");
INSERT INTO tnn_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kən təmaun-in əfəməh məmə, ‘!Tata Epraham! Awi, asəkitun io. Ahl-ipən Lasaros məmə oteer əm noanelmɨn e nəhau kən mos muwa mek namək lan məmə otətəp, məto-inu iatəto nahməən asol e nɨgəm ukɨn-u roiu.’ ");
INSERT INTO tnn_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Məto Epraham təmə, ‘Nətɨk, nɨkim təht-tu rəham nəmegəhən aupən. Ik nəmatos natɨmnat wɨr rəham tepət, məto Lasaros təmatəto nahməən tepət e nɨpətɨn. Məto roiu əh, in tatəto təwɨr ikɨn-u, kən ik, natəto nahməən tepət e nɨpətɨm. ");
INSERT INTO tnn_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kən nat kit mɨn. Ilugɨn-in kitat, noakɨmɨl asol itəm tatoor kitat, ik un, kən itɨmat u. Okəmə itɨmat kit tolkeike məmə otɨmnə mehm ik, məto okol təsɨmnəən. Kən okəmə itəmat kit tolkeike məmə otuwa mehm itɨmat, məto okol təsuwamən.’ ");
INSERT INTO tnn_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Kən etəm rəhan nautə tepət təmən məmə, ‘Tata. Iakatəkəike kəm ik, awi, kəsi. Ahl-ipən Lasaros tuwɨn e nimə rəha tata rəhak, ");
INSERT INTO tnn_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","məto-inu piak faif əh-ikɨn. Təwɨr məmə in otuwɨn məghat mem əskasɨk ilat məmə okoatəto ilat məmə okəsotuwamən ukɨn-u itəm iatəto nahməən asol agɨn ikɨn.’ ");
INSERT INTO tnn_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Məto Epraham təmə, ‘Kəp. Nəghatən rəha Moses ne ien mɨn rəha Uhgɨn tətatɨg. Pəs piam mɨn okotəto nəghatən mɨn əh.’ ");
INSERT INTO tnn_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Kən etəm rəhan nautə tepət təmən məmə, ‘Kəp, Tata Epraham. Təsahmenən. Məto okəmə suah kit otəmegəh mɨn e nɨmɨsən otuwɨn məghat kəm ilat, kən nɨpahrienən, ilat okotəuhlin rəhalat nətəlɨgən kən motapəs təfagə rat mɨn rəhalat.’ ");
INSERT INTO tnn_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Kən Epraham təmə, ‘Okəmə kəsotətəlɨg-inən nəghatən rəha Moses ne ien mɨn rəha Uhgɨn, kən in nat əpnapɨn okəmə suah kit təmegəh pap e nɨmɨsən kən muwɨn matəghat kəm ilat, məto okol kəsotən mɨnən nɨpahrienən lan.’” ");
INSERT INTO tnn_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Kən Iesu təmən kəm rəhan mɨn netəmim məmə, “Nɨpahrienən, nos-ipən-os-ipənən rəha təfagə tərat mɨn itəm koatiuw-pən netəmim e nəratən, ilat okotuwa. !Məto nahməən asol tatuwɨn o etəmim itəm tatos-ipən-os-ipən netəmim, o in suatɨp rəha nos-ipən-os-ipənən! ");
INSERT INTO tnn_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Məto okəmə etəmim kit tatiuw-pən rəhak kit etəmim u tahmen e suakəku, məmə otol təfagə rat, kən suah əh, Uhgɨn otol nalpɨnən asol kəm in. Kən nalpɨnən əh otəskasɨk taprəkɨs okəmə kətu-pən kəpiel kit e nentou, kən kərakin-pən əpəh itəhəi lokamnɨm məmə otamnɨm. ");
INSERT INTO tnn_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kən tol nəhlan, oatəto moatehm wɨr rəhatəmat nəmegəhən. “Okəmə piam tatol təfagə tərat kəm ik, kən ən-ipən rəhan nolən rat e nɨganəmtɨn, kən okəmə tatəuhlin rəhan nətəlɨgən, kən aluin rəhan nolən rat məsosən tatɨg e nɨkim. ");
INSERT INTO tnn_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kən nat əpnapɨn in tatol təfagə rat kəm ik mau sepɨn e nian kitiəh, kən muwa mau sepɨn mən-ipɨnə kəm ik məmə, ‘Kəsi, emol təfagə rat kəm ik. Ekəuhlin rəhak nətəlɨgən mapəs rəhak təfagə rat,’ kən ik onakəkəike maluin rəhan nolən rat mɨn, kən məsosən tatɨg e nɨkim.” ");
INSERT INTO tnn_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Kən aposol mɨn kəmotətapəh o Iərəmərə məmə, “Ol rəhatɨmat nahatətəən təskasɨk təhmɨn mɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Kən Iərəmərə təmən məmə, “Nat əpnapɨn okəmə rəhatəmat nahatətəən in təkəku agɨn əm tahmen e nɨmɨsmɨsɨ nɨməkləkɨl, kən nəkotɨtun nənən kəm nɨg u neegɨn məmə, ‘Euw atɨp ik, kən muwɨn miwɨg-pən itəhəi,’ kən nɨg u otol nəwiatəmat. ");
INSERT INTO tnn_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ən-tu. ?Okəmə suah kit rəhan iolwək tətasum, o in tatehm sipsip mɨn, kən in tatɨtəlɨg-pa latuənu, kən nɨkitəmat təht məmə etəm-iasol otən kəm in məmə, ‘!Ei! Wa uəhai məpələh mun nagwənən əh’? !Kəp! ");
INSERT INTO tnn_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Məto in otən kəm rəhan iolwək məmə, ‘Uwɨn mol nɨgak nagwənən, kən uwɨn muwɨn e rəham napən təwɨr, kən mos-ipa nɨgak nagwənən ne nɨmək nənɨmən. Nian nəmol rafin rəham wək, nəkɨtun nuwɨnən magwən kən mənɨm.’ ");
INSERT INTO tnn_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","?Kən nɨkitəmat təht məmə etəm-iasol, in otən tagkiu kəm rəhan iolwək o wək asol rəhan itəm in otəkəike mol? !Kəp! ");
INSERT INTO tnn_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kən itəmat un, nəkotahmen əm e iolwək mɨn rəha Uhgɨn. Nian nəmotol rəkɨs natɨmnat rafin itəm Uhgɨn təmən kəm itəmat məmə onəkotəkəike motol, onəkotəkəike motən əm məmə, ‘Itɨmat iolwək mɨn əm. Nolən rəhatɨmat təsahmenən o nənwiwiən. Itɨmat emotol əm wək itəm itɨmat ekotəkəike moatol.’” ");
INSERT INTO tnn_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nian Iesu təmaliwək matuwɨn Jerusalem, in təmaliwək muwɨn-pən ilugɨn i nəptən mil u Sameria ne Kalili. ");
INSERT INTO tnn_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Kən nian in təmiet-arəpa latuənu kit, netəmim ten itəm nɨmɨsən u leprosi təmol ilat kəmotuwa motətul isəu məsɨn, ");
INSERT INTO tnn_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","kən motaun-in məmə, “!Iesu, Etəm-iasol, asəkitun itɨmat!” ");
INSERT INTO tnn_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Kən nian in təmehm ilat, təmən-ipən kəm ilat məmə, “Onəkotuwɨn o pris məmə in otehm nɨpətɨtəmat.” Kən nian ilat kəmotaliwək əh e suatɨp, kən kəmotəwɨr, nɨmɨsən təmɨkə. ");
INSERT INTO tnn_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kən ilat kit təməplan məmə leprosi rəhan tɨnɨkə, kən in təməuhlin mɨtəlɨg-pən o Iesu, matən əfəməh məmə, “!Iatənwiwi Uhgɨn! !Iatənwiwi Uhgɨn!” ");
INSERT INTO tnn_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kən in təmeiuaiu e nelkɨ Iesu mɨsin nulɨn nɨpɨnəgɨn tatek nɨsɨp, kən matən kəm Iesu məmə nɨkin tətagien məmə in təmol-wɨr rəhan nɨmɨsən. Kən suah u in etəm Sameria. ");
INSERT INTO tnn_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kən Iesu təmən məmə, “?Emol-wɨr netəm ten maruətuəh-in rəkɨs rəhalat nɨmɨsən, o kəp? ?Məto nain hiə? ");
INSERT INTO tnn_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","?Suah u in iapɨspɨs əm, məto in pɨsɨn əm təmɨtəlɨg-pa matənwiwi Uhgɨn?” ");
INSERT INTO tnn_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kən Iesu təmən kəm suah u məmə, “Ətul maliwək matuwɨn. Rəham nahatətəən təmol-wɨr ik.” ");
INSERT INTO tnn_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nian kit, Farisi mɨn kəmotətapəh o Iesu məmə, “?Onəghan nərəmərəən rəha Uhgɨn otuwa?” Kən in təmən-ipən kəm ilat məmə, “Nərəmərəən rəha Uhgɨn otəsuwamən məmə netəmim okotehm e nɨganəmtɨlat. ");
INSERT INTO tnn_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kən etəmim tɨkə itəm otən məmə, ‘!Asɨ-pa mehm, in huə!’ o ‘!Asɨpən mehm, in əpəh!’ məto-inu nərəmərəən rəha Uhgɨn tɨnuwa rəkɨs mətatɨg e nɨkitəmat.” ");
INSERT INTO tnn_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kən Iesu təmən kəm rəhan mɨn netəmim məmə, “Nian mɨn koatuwa itəm itəmat onakoatolkeike məmə onəkotehm nian mɨn rəha Nətɨ Etəmim, məto okol nəkəsotehmən. ");
INSERT INTO tnn_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Kən netəmim okotən kəm itəmat məmə, ‘!Asɨ-pa, in huə!’ o ‘!Asɨpən, in əpəh!’ Məto əsotuwɨnən motətəu-pən ilat, ");
INSERT INTO tnn_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","məto-inu e nian io Nətɨ Etəmim oekuwa lan, in otahmen-pən e nɨpɨtən itəm tatɨpɨt kən mətasiəgəpɨn neai e nɨkalɨn kit mətoarus-pən nɨkalɨn kit mɨn, kən netəmim rafin koatəplan motɨtun. ");
INSERT INTO tnn_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Məto aupən, io ekəkəike məto nahməən tepət, kən netəm kotatɨg roiu, ilat okotəuhlin məntaalat motapəs io. ");
INSERT INTO tnn_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“E nian io, Nətɨ Etəmim, ekuwa lan, otahmen-pən əm e nian rəha suah əh Noah aupən, itəm netəmim kəmoatol natɨmnat mɨn məsotɨtunən məmə Uhgɨn otol nat kit lan. ");
INSERT INTO tnn_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","E nian əh, netəmim kəmotagwən, moatənɨm, moatol marɨt, inəh natɨmnat rafin kəmoatol e nəmegəhən rəhalat, mətoarus-pa nian itəm Noah tɨnuwɨn imə e nɨpəgnoa nego asol rəhan. Kən nuhuən təməfɨk naruəh asol təmuwa maiu əlɨmin rafin netəmim itəm kəsotuwɨnən e nego. ");
INSERT INTO tnn_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“In tahmen-pən əm e nian rəha suah əh Lot. Netəmim kəmotagwən, moatənɨm, moatol-salɨm-in natɨmnat mɨn, moatos-nəmtɨm natɨmnat mɨn, moatasum, moatiləkɨn nimə mɨn, inəh natɨmnat rafin kəmoatol e nəmegəhən rəhalat. ");
INSERT INTO tnn_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Məto e nian itəm Lot təmiet lan e taon əh Sotom, kən nɨgəm ne kəpiel mɨn itəm koatuəp kəmotɨsɨ-pər e neai motoamnu ilat rafin əpəh e taon. ");
INSERT INTO tnn_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Kən otahmen əm e nian io Nətɨ Etəmim oekuwa mɨn lan kən Uhgɨn otol əp io kəm netəmim. ");
INSERT INTO tnn_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","E nian əh, okəmə suah kit tatəpələh ihluə e rəhan nimə, pəs in otagɨm məsuwɨn mɨnən imə məmə in otos rəhan natɨmnat, kən okəmə suah kit in əpəh e nasumən, pəs in otagɨm məsuwa mɨnən latuənu. ");
INSERT INTO tnn_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","!Onəkəsotaluinən pətaguɨhl rəha Lot! ");
INSERT INTO tnn_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Etəm tolkeike məmə in otaskəlɨm rəhan nəmegəhən e nətueintən u məsətəu-pa-mən io, in otəsosən nəmegəhən lilɨn. Məto etəmim itəm tətapəs natɨmnat rəha nəmegəhən e nətueintən u kən matətəu-pa io, in otos nəmegəhən lilɨn. ");
INSERT INTO tnn_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Iatən kəm itəmat məmə, e nian əh lapɨn, etəmim kəiu okətuapɨl e pet kitiəh əm, kən okos-irəkɨs kit, kapəs kit. ");
INSERT INTO tnn_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Pətan kəiu okətioal nagwənən, kən okos-irəkɨs kit, kapəs kit.” ");
INSERT INTO tnn_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Kən rəhan iolwək mɨn kəmotən-ipən kəm in məmə, “?Iərəmərə, onəkuwa hiə?” Kən in təmən-ipən kəm ilat məmə, “Onəkotɨtun əm. Tahmen e nian ligkai mɨn koatiwɨg ilɨs moteiuaiu moatər itəhəi, kən nəkotɨtun məmə nəm mɨn əh-ikɨn əh.” ");
INSERT INTO tnn_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Kən Iesu təmuəh nimaa nəghatən kəm ilat matəgətun ilat lan məmə okotəkəike moatəfak nian rafin məsotapəsən, məsotolən məmə nɨkilat otatite. ");
INSERT INTO tnn_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","In təmən məmə, “Latuənu kit, ien kit əh-ikɨn rəha nələhəuən nəghatən mɨn. Kən təsɨsiai-inən Uhgɨn, kən təsɨsiai-in mɨnən netəmim. ");
INSERT INTO tnn_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kən e latuənu əh, nəutahlɨmɨs kit əh-ikɨn, kən nian rafin tatuwa matəplan ien un matən-ipən kəm in məmə, ‘Awi. Okol nakasitu lak məghat o nəratən itəm rəhak tɨkɨmɨr tatol kəm io.’ ");
INSERT INTO tnn_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Məto ien təməsuwɨnən, kən mos nian əfəməh məmə otəghat mol-wɨr nəratən əh rəha nəutahlɨmɨs. Məto pətan əh təmətapəh o suah əh nian rafin matuwɨn matuwɨn, kən ien tɨnatətəlɨg-in məmə, ‘Nat əpnapɨn esɨsiai-inən Uhgɨn, kən məsɨsiai-in mɨnən netəmim, ");
INSERT INTO tnn_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","məto pətan əh tatən nat kitiəh mətaləkiamtə io o rəhan nəghatən, matuwɨn matuwɨn. Io ekəkəike muwɨn mən wɨr rəhan nəratən kən mələhəu nəwɨrən. Okəmə ekapəs, kən in otatuwa ron io matuwɨn matuwɨn kən ekəpou in.’” ");
INSERT INTO tnn_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kən nian Iərəmərə təmuəh rəkɨs nimaa nəghatən əh, kən təmən məmə, “Otətəlɨg-in-tu nəghatən rəha ien əpəh itəm tərat təhmɨn. ");
INSERT INTO tnn_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","?Məto tahro e Uhgɨn? In təmɨtəpun rəhan mɨn netəmim, kən ilat koatasək-pən kəm in nian rafin e nərauiəgən mɨn ne lapɨn mɨn rafin. ?Kən nɨkitəmat təht məmə in otən-ipən kəm ilat məmə, ‘Onakoatəsahgin pitən’? Kəp. ?Kən nɨkitəmat təht məmə in otasitu uəhai əm e rəhan mɨn? ");
INSERT INTO tnn_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Iatən kəm itəmat məmə nɨpahrienən, in otasitu uəhai əm e rəhan mɨn, kən mol-wɨr rəhalat nəratən. ?Məto nian io Nətɨ Etəmim oekɨtəlɨg-pa mɨn lan e nətueintən, oekehm netəmim neen itəm koatahatətə e Uhgɨn, o kəp?” ");
INSERT INTO tnn_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Kən Iesu təmuəh nimaa nəghatən kit e netəmim neen itəm nɨkilat tatəht məmə ilat kotətuatɨp taprəkɨs-in netəmim rafin, kən motasɨl-iəhau-in netəmim rafin. ");
INSERT INTO tnn_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","In təmən məmə, “Suah mil kəiu kəmian əpəh e Nimə Rəha Uhgɨn məmə okuəghat kəm in e nəfakən. Kit, in Farisi, kən kit in etəm tatos məni rəha takɨs. ");
INSERT INTO tnn_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Kən Farisi təmətul mateiuə məmə in tatəfak kəm Uhgɨn, məto nɨpahrienən tatən atɨp in, matən məmə, ‘Uhgɨn, iatən tagkiu kəm ik məto-inu nəmol məmə ekol etəm pɨsɨn lak, inəh io mɨn neen kotolkeike pɨk məni kən moateiuə məmə kotakləh-in, kən moatol tərat, kən motakləh-in pətan rəha etəm pɨsɨn. Kən io esolən məmə suah əh etəm tatos məni rəha takɨs. ");
INSERT INTO tnn_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nian kəiu e wik kitiəh, iatətuakəm mətapəs nagwənən matəfak kəm ik. Kən okəmə ekos natɨmnat ten, ekatos-irəkɨs kitiəh matos-ipɨnə kəm ik.’ ");
INSERT INTO tnn_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Məto suah əh, etəm tatos məni rəha takɨs, in tatətul-pən isəu, kən mətaulɨs məsasɨpərən e neai məfak. Kən nɨkin tatɨtəgɨt mətasək mətaht manɨkɨləhan matən məmə, ‘Uhgɨn, io etəm tərat. !Asəkitun io!’” ");
INSERT INTO tnn_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kən Iesu təmə, “Iaten kəm itəmat. Nian suah mil u okatiatəlɨg-pən latuənu, etəm rəha takɨs, rəhan nəmegəhən in otətuatɨp e nɨganəmtɨ Uhgɨn. Məto Farisi təsol mihinən, məto-inu etəmim itəm tatɨləs-ipər atɨp in, Uhgɨn otɨləs-iəhau, məto etəmim itəm tatos-iəhau atɨp in, Uhgɨn otɨləs-ipər.” ");
INSERT INTO tnn_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kən netəmim neen kəmotəmɨk rəhalat nɨsualkələh mətmətɨg motuwa kəm Iesu məmə in otələhəu-pən nelmɨn elat kən məfak olat. Məto nian rəhan mɨn netəmim kəmotehm ilat, kən kəmotən-iəhau ilat. ");
INSERT INTO tnn_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Məto Iesu təmatən-iarəp məmə nɨsualkələh mɨn un okotuwa ron, kən təmən-ipən kəm rəhan mɨn netəmim məmə, “Əsotahtosɨg-inən nɨsualkələh məmə okəsotuwamən ron io, pəs ilat okotuwa ron io, məto-inu nərəmərəən rəha Uhgɨn in rəha netəmim itəm kotahmen e nɨsualkələh mɨn u. ");
INSERT INTO tnn_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Okəmə suah kit tolkeike məmə in otuwa matɨg ahgin nərəmərəən rəha Uhgɨn, kən in təike muwa tahmen e suakəku. Məto okəmə təsol mihinən, kol in təsuwamən.” ");
INSERT INTO tnn_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kən etəm-iasol kit təmən-ipən kəm Iesu məmə, “Iəgətun, ik etəm təwɨr. ?Oekol naka məmə ekos nəmegəhən lilɨn?” ");
INSERT INTO tnn_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Kən Iesu təmən-ipən kəm in məmə, “?Tahro nakatən kəm io məmə io etəm təwɨr? Suah kit tɨkə in etəm təwɨr, məto Uhgɨn əm in təwɨr. ");
INSERT INTO tnn_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ik nəkɨtun nəghatən mɨn e Lou rəha Uhgɨn koatən məmə, ‘Əsakləh-inən pətan pɨsɨn, əsohamnuən etəmim, əsakləh-inən natɨmnat, əseiueiuəən e kot, ɨsiai-in rəham mama ne tata.’” ");
INSERT INTO tnn_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Kən suah u təmən məmə, “Natɨmnat rafin u, io emol rafin ilat, nian ematəkəku mətoarus-pa u-roiu.” ");
INSERT INTO tnn_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nian Iesu təməto nəghatən əh, təmən-ipən kəm in məmə, “Nat kitiəh əm əh-ikɨn itəm ik nəməsolən əh. Uwɨn mol-salɨm-in nautə rafin rəham, kən mos məni lan muwɨn mos-ipən kəm ian-rat mɨn, kən ik onakos natɨmnat wɨr əpəh e nego e neai. Kən wa, muarisɨg-in io məmə ik rəhak etəmim.” ");
INSERT INTO tnn_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Məto nian təməto nəghatən mɨn əh, nɨkin təməpou məto-inu rəhan nautə tepət. ");
INSERT INTO tnn_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Kən Iesu təmasɨpən məplan, təmən məmə, “!Awi, tiəkɨs pɨk o etəm rəhan nautə tepət məmə in otuwɨn matɨg ahgin nərəmərəən rəha Uhgɨn! ");
INSERT INTO tnn_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tiəkɨs məmə kau otuwɨn-pən e nɨpəg nitel, məto tiəkɨs pɨk məmə etəm rəhan nautə tepət otuwɨn matɨg ahgin nərəmərəən rəha Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Kən netəm kəmotəto nəghatən əh kəmotən məmə, “?Okəmə in tiəkɨs o etəm rəhan nautə tepət, məto pah əh in tahmen məmə otos nəmegəhən əh?” ");
INSERT INTO tnn_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Məto in təmən məmə, “Natɨmnat itəm tiəkɨs, ko netəmim kəsotolən, məto Uhgɨn in tɨtun nolən.” ");
INSERT INTO tnn_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kən Pita təmən-ipən kəm in məmə, “?Məto tahro etɨmat? Emotapəs rafin rəhatɨmat natɨmnat kən moatuwa məmə ekotuarisɨg-in ik.” ");
INSERT INTO tnn_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Kən Iesu təmən-ipən kəm ilat məmə, “Iatən pahrien kəm itəmat məmə, etəm təmapəs rəhan nimə, o rəhan pətan, o pian mɨn, o rəhan tata ne mama, o rəhan nɨsualkələh məto-inu in tatətəu-pən nərəmərəən rəha Uhgɨn, ");
INSERT INTO tnn_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kən e nətueintən u, in otos natɨmnat tepət nəhlan taprəkɨs-in ilat mɨn u təmapəs ilat, kən uarisɨg, in otos mɨn nəmegəhən lilɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Kən Iesu təmən-ipən kəm rəhan netəm tuelef məmə okotiet e nɨmanin netəmim motuwa kitiəh kuəfɨmɨn ilat mɨn, kən təmən-ipən kəm ilat məmə, “Otətəlɨg-tu. Roiu koatuwɨn əpəh ilɨs Jerusalem, kən natɨmnat mɨn itəm ien mɨn rəha Uhgɨn aupən kəmoatən lak, Nətɨ Etəmim, ilat okotuwa kol nɨpahrienən. ");
INSERT INTO tnn_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Netəmim okotegəhan-in-pən io e nelmɨ Iaihluə mɨn, kən netəmim okotəghat motalah əsan lak, motoh io, motol naulɨsən kəm io, kən motagəh-əpis io, motagəh e nɨpətɨk. ");
INSERT INTO tnn_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Kən okalis io, kən kohamnu io, məto e nian tatol kɨsɨl lan, oekəmegəh mɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Məto kəsotɨtunən rəhan nəghatən mɨn. In tahmen-pən e nəghatən itəm nɨpətɨn tatəhluaig, kən kəsotɨtunən nɨpətɨ nəghatən mɨn əh. ");
INSERT INTO tnn_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nian Iesu tatuwa iuəhkɨr o taon əh Jeriko, iganəmtɨn əpɨs kit əh-ikɨn tatəpələh e nɨkalɨ suatɨp. Nian rafin in tateasiə-in məni o netəmim. ");
INSERT INTO tnn_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kən nian iganəmtɨn əpɨs təməto məmə netəmim tepət kotaliwək e suatɨp, kən in təmətapəh məmə, “?Naka əh katol?” ");
INSERT INTO tnn_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Netəmim kəmotən-ipən kəm in məmə, “Iesu əpəh, etəm Nasaret, tətaliwək e suatɨp.” ");
INSERT INTO tnn_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kən təmagət əfəməh məmə, “!Iesu! !Mipɨ Kig Tefɨt! !Asəkitun io!” ");
INSERT INTO tnn_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Kən netəm mɨn u koataliwək motaupən-in Iesu, kəmotagət lan, moatən məmə, “!Əsagətən!” Məto in təmagət əfəməh məsɨn mɨn məmə, “!Mipɨ Kig Tefɨt! !Asəkitun io!” ");
INSERT INTO tnn_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kən Iesu təmətul mən-ipən kəm ilat məmə okotɨləs motuwa. Kən nian kəmotɨləs motuwa iuəhkɨr, Iesu təmətapəh ron məmə, ");
INSERT INTO tnn_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“?Naka un nakolkeike məmə io ekol kəm ik?” Kən in təmən məmə, “Iərəmərə, ekolkeike məmə oekaiir mehm nat.” ");
INSERT INTO tnn_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kən Iesu təmən-ipən kəm in məmə, “Aiir mehm nat. Rəham nahatətəən təmol-wɨr nɨganəmtɨm.” ");
INSERT INTO tnn_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kən roiu agɨn-əh mɨn əm, təmaiir mɨnatehm nat, kən mɨnatuarisɨg-in Iesu, matənwiwi Uhgɨn. Kən nian netəmim rafin kəmotəplan nat əh, ilat kəmoatənwiwi Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Kən Iesu təmaliwək muwɨn imə e taon u Jeriko matuwɨn məmə otiet-arəpən e nəwtain məsɨn. ");
INSERT INTO tnn_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Kən e taon əh, suah kit əh-ikɨn, nərgɨn u Sakias. In etəm-iasol kit rəha netəm koatos məni rəha takɨs, kən rəhan nautə tepət. ");
INSERT INTO tnn_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Kən in tolkeike məmə otəplan-tu məmə Iesu in pah, məto təruru nəplanən məto-inu in natiəkuəkɨr, kən netəmim koatətulosɨg-in. ");
INSERT INTO tnn_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kən in təmaiu aupən muwɨn maiu e nɨg kit, nərgɨn u sikamo, məmə otɨtun nəplanən Iesu nian in otuwa-pa ikɨn. ");
INSERT INTO tnn_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kən nian Iesu təmuwa ətuatɨp əh in ikɨn, təmasɨpər məplan, kən mən-ipən kəm in məmə, “Sakias. Eiuaiu uəhai, məto-inu roiu ekəkəike muwɨn matɨg əpəh e rəham nimə.” ");
INSERT INTO tnn_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kən Sakias təmeiuaiu uəhai əm, kən mit Iesu mian əpəh iman ikɨn imə, kən nɨkin təmagien. ");
INSERT INTO tnn_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Məto nian netəmim kəmotəplan natɨmnat mɨn əh, kən koatasiwən-in nolən mɨn əh moatən nɨkalɨ Iesu məmə, “Suah əh tatuwɨn e nimə rəha iol təfagə rat.” ");
INSERT INTO tnn_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kən nian kɨnotuwɨn e nɨpəgnoa nimə rəha Sakias, in tətul mən-ipən məmə, “Iərəmərə, atətəlɨg-in-tu. Oekoor rəhak natɨmnat mol niel kəiu, kit rəhak, kən kit oekos-ipən kəm ian-rat mɨn. Kən natɨmnat itəm emakləh-in o suah kit, oekalpɨn mau kuwɨt.” ");
INSERT INTO tnn_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Kən Iesu tən-ipən kəm in məmə, “Roiu Uhgɨn tɨnosmegəh rəkɨs ik ne rəham mɨn, məto-inu ik mɨn, nəmahatətə e Uhgɨn, kən ik noanol pahrien kit rəha Epraham. ");
INSERT INTO tnn_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kən io, Nətɨ Etəmim, emuwa məmə ekeam-in netəmim itəm koatəlue, kən mosmegəh ilat.” ");
INSERT INTO tnn_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nian netəmim koatətəlɨg-in Iesu, in təmatəkəike matuəh nimaa nəghatən kəm ilat məto-inu in tɨnatuwa iuəhkɨr o Jerusalem, kən nɨkilat təht məmə nərəmərəən rəha Uhgɨn otəsuwəhən tuwa. ");
INSERT INTO tnn_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kən təmən-ipən kəm ilat məmə, “Etəm-iasol kit tolkeike məmə in otuwɨn isəu məplan kig asol agɨn məmə kig asol otɨləs-ipər in mol kig lan əpəh iman ikɨn, kən otəpanɨtəlɨg-pa mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Kən təmaun-in rəhan iolwək ten, kən moor məni kitiəh kitiəh kəm ilat. Kən in təmən-ipən kəm ilat məmə, ‘Itəmat onəkotəkəike motol wək e məni u o nosən ətain mətoarus-pən io ekɨtəlɨg-pa mɨn.’ ");
INSERT INTO tnn_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Məto ilat əpəh iman ikɨn koatetəhau suah əh, kən motahl-ipən nəghatən kəm kig asol agɨn məmə, ‘Itɨmat esotolkeikeən məmə suah u otərəmərə etɨmat.’ ");
INSERT INTO tnn_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Məto kəmɨləs-ipər in kol kig lan, kən in təmɨtəlɨg-pa mɨn. Kən in təmaun-in rəhan iolwək mɨn itəm təmoor rəhan məni kəm ilat. In tolkeike məmə otɨtun məmə ilat kəmotol win e məni naka nian in təmətatɨg əpəh isəu. ");
INSERT INTO tnn_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Kən etəm tətaupən təmuwa mən-ipən kəm in məmə, ‘Iərəmərə, nəmələhəu-pa məni kitiəh e nelmək, kən emol win e məni ten mɨn.’ ");
INSERT INTO tnn_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kən rəhan etəm-iasol təmən-ipən kəm in məmə, ‘Ik iolwək təwɨr, nəmol wək itəm in təwɨr. Məto-inu nəmol wək təwɨr o nehm wɨrən nat itəm natiəkəku, kən roiu oekegəhan-in mɨn ik məmə onakərəmərə taon ilat ten.’ ");
INSERT INTO tnn_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Kən etəm tatuarisɨg lan təmuwa mən-ipən məmə, ‘Iərəmərə, nəmələhəu-pa məni kitiəh e nelmək, kən emol win e məni faif mɨn.’ ");
INSERT INTO tnn_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Kən etəm-iasol təmən-ipən kəm in məmə, ‘Ik onakərəmərə e taon ilat faif.’ ");
INSERT INTO tnn_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Kən iolwək kit mɨn təmuwa mən-ipən kəm in məmə, ‘Iərəmərə, inu rəham məni. Eməlis ətain e napən, kən məhluaig-in wɨr, ");
INSERT INTO tnn_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","məto-inu io iatəgin ik itəm rəham nolən tiəkɨs. Nakatos natɨmnat itəm kəsənəmə rəham, kən matəulək e nasumən mɨn itəm ik nəməsəfeən ilat.’ ");
INSERT INTO tnn_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Kən etəm-iasol təmən-ipən kəm in məmə, ‘!Ik iolwək rat! Nəghatən əm rəham tatəgətun məmə nəmol tərat agɨn. Nɨnɨtun rəkɨs məmə io etəm-iəkɨs, kən iakatos natɨmnat itəm kəsənəmə rəhak, kən iatəulək e nasumən mɨn itəm eməsəfeən ilat. ");
INSERT INTO tnn_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","?Tahro nəməsosən rəhak məni muwɨn mələhəu-pən e pag, kən nian ekɨtəlɨg lan, ekɨtun nosən rəhak məni ilau profit rəhan?’ ");
INSERT INTO tnn_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Kən təmən-ipən kəm rəhan mɨn əh məmə, ‘Otos-irəkɨs rəhan məni, kən motos-ipən kəm suah u rəhan məni ten.’ ");
INSERT INTO tnn_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Kən ilat kəmotən məmə, ‘!Iərəmərə, təsətuatɨpən məto-inu rəhan məni ten rəkɨs!’ ");
INSERT INTO tnn_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Kən etəm-iasol təmən-ipən kəm ilat məmə, ‘Iatən kəm itəmat məmə, etəmim itəm tatos nat kit, kəpanos-ipən mɨn neen mɨn. Məto etəm rəhan nat kit tɨkə, kəpanos-irəkɨs rəhan natɨmnat rafin. ");
INSERT INTO tnn_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kən roiu, rəhak tɨkɨmɨr mɨn itəm kəməsotolkeikeən məmə ekuwa kig rəhalat, onəkotit ilat motuwa, kən onəkotohamnu ilat e nɨganəmtək.’” ");
INSERT INTO tnn_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kən nian Iesu təməghat rəkɨs un, kən in təmaliwək maupən matuwɨn Jerusalem, kən netəmim koatuarisɨg in. ");
INSERT INTO tnn_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nian kɨnotuwa iuəhkɨr o latuənu mil u kəiu, Petfas ne Petani e Nɨtot Rəha Nɨg U Olif, kən in təmən-ipən kəm rəhan mil etəmim kəiu məmə, ");
INSERT INTO tnn_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Ian əpəh latuənu itəm kotɨsɨ-pən ikɨn. Ikɨn əh, onakuehm nətɨ togki kit itəm kəsasuəən əh lan. Iakɨs nol lan muasɨg muea ikɨn-u. ");
INSERT INTO tnn_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kən okəmə suah kit tətapəh otəmlau məmə, ‘?Nakətiakɨs togki o naka?’ kən onəkuən-ipən kəm in məmə, ‘Iərəmərə rəhatat, in tolkeike məmə otol nat kit lan.’” ");
INSERT INTO tnn_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kən kəmian muehm natɨmnat rafin tol əm məmə inu Iesu təmən mihin ne. ");
INSERT INTO tnn_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kən nian kəmətiakɨs nətɨ togki, kən netəmim mɨn rəha togki kəmotətapəh olau məmə, “!Ei! ?Nətiakɨs nətɨ togki o naka?” ");
INSERT INTO tnn_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Kən ilau kəmuən-ipən məmə, “Kəp. Iərəmərə tolkeike məmə otol nat kit lan.” ");
INSERT INTO tnn_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kən kəmuasɨg muea kəm Iesu, kən kəmuapeg rəhalau kot muəfətain məntaa nətɨ togki lan, kən muasitu e Iesu tər masuə e nətɨ togki. ");
INSERT INTO tnn_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nian təmasuə lan mɨnatuwɨn, kən rəhan netəmim kotapeg rəhalat mɨn kot motəpen-pən e suatɨp. ");
INSERT INTO tnn_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nian Iesu tɨnatuwa iuəhkɨr o Jerusalem mətasuə e togki mateiuaiu e Nɨtot Rəha Nɨg U Olif, kən netəmim rafin rəhan nɨkilat tətagien, kən mɨnətuoun moatənwiwi Uhgɨn motagət əfəməh o nat pɨspɨs mɨn itəm kəmoatehm in təmatol. ");
INSERT INTO tnn_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Kən koatən məmə, “!Iərəmərə Uhgɨn tətatɨg ilau Kig u itəm tatuwa e nərgɨn! !Pəs nəməlinuən tətatɨg əpəh e nego e neai, kən əpəh ilɨs ilɨs agɨn e nego e neai, katɨləs-ipər nərgɨ Iərəmərə Uhgɨn!” ");
INSERT INTO tnn_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kən Farisi mɨn neen itəm kəmotatɨg əh-ikɨn kəmotən-ipən kəm in məmə, “Iəgətun. Ən-iəhau rəham mɨn netəmim məmə okotakəm nohlɨlat.” ");
INSERT INTO tnn_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Məto in təmən-ipən kəm ilat məmə, “Okəmə netəm mɨn u kəsotagətən, kən kəpiel mɨn u, ilat okotagət əfəməh.” ");
INSERT INTO tnn_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kən nian Iesu təmuwa iuəhkɨr təmehm taon əh Jerusalem, kən təmasək o netəm mɨn əh-ikɨn əh. ");
INSERT INTO tnn_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Kən tatən məmə, “Ei, nat əpnapɨn nəmotapəs natɨmnat itəm tatos-ipa nəməlinuən mətoarus-pa u-roiu, məto okəmə nəkotɨtun ilat roiu əm, kən Uhgɨn otos-ipɨnə kəm itəmat. Məto kəp. Natɨmnat mɨn əh koatəhluaig okol nəkəsotehmən. ");
INSERT INTO tnn_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Məto e nian mɨn itəm tatuwa otəmat, rəhatəmat tɨkɨmɨr mɨn okotuwa kətul kɨtəlau-in itəmat, okotel nɨməptən kətu-pər kol əpətɨn rəhatəmat taon, kən motahtosɨg-in itəmat lan məmə nəkəsotietən. ");
INSERT INTO tnn_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Kən ilat okotərəkɨn rafin nimə e taon rəhatəmat, kən okotohamnu itəmat rafin təlmin nɨsualkələh mɨn rəhatəmat. Okol kəpiel kit ne rəha nimə mɨn osətətulən. Natɨmnat rafin u otatuwa məto-inu itəmat nəmotəruru nian itəm Uhgɨn təmuwa məmə in otosmegəh itəmat lan.” ");
INSERT INTO tnn_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kən Iesu təmuwɨn mɨnatəhg-iarəp netəmim itəm koatol maket e Nimə Rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Kən in təmən-ipən kəm ilat məmə, “Kəməte rəkɨs e Naoa Rəha Uhgɨn məmə, ‘Rəhak nimə, in nimə rəha nəfakən kəm io,’ məto itəmat nɨnoatol tɨnuwa in ‘nimə kit itəm iakləh mɨn koatəhluaig ikɨn.’” ");
INSERT INTO tnn_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kən uarisɨg lan, e nian mɨn rafin, Iesu təmatəgətun əpəh imə e Nimə Rəha Uhgɨn. Kən pris asol mɨn, ne iəgətun mɨn rəha Lou, ne netəm-iasol mɨn rəha noanol mɨn rəha Isrel, kəmotegəs-in suatɨp məmə okotohamnu Iesu, ");
INSERT INTO tnn_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","məto kəməsotehmən suatɨp kit məto-inu netəmim rafin kotolkeike pɨk məmə okoatəto nəghatən mɨn rəhan, kən nəghatən rəhan tətaskəlɨm wɨr rəhalat nətəlɨgən. ");
INSERT INTO tnn_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nian kit, Iesu təmatəgətun netəmim əpəh e Nimə Rəha Uhgɨn, kən matən-iarəp namnusən təwɨr rəha Uhgɨn kəm netəmim. Kən pris asol mɨn, ne iəgətun mɨn rəha Lou, ne netəm-iasol mɨn rəha noanol rəha Isrel kəmotuwa kehm in, ");
INSERT INTO tnn_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","kən kəmotətapəh ron məmə, “?Ən-tu kəm itɨmat məmə pah təmegəhan-in ik nakatol natɨmnat mɨn əh? ?Kən pah təmegəhan-in nepətən əh, Uhgɨn o etəmim əm?” ");
INSERT INTO tnn_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Kən Iesu təmən-ipən kəm ilat məmə, “Təwɨr əm. Io ekətapəh-in mɨn nəghatən kit kəm itəmat, kən itəmat onəkotaupən motuhalpɨn-pa kəm io. ");
INSERT INTO tnn_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","?Pah təmegəhan-in nepətən kəm Jon məmə in otol baptais e netəmim, Uhgɨn o etəmim əm?” ");
INSERT INTO tnn_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kən kɨnoatən-ən nəghatən u kəm ilat mɨn, mɨnoatən məmə, “Okəmə kotən məmə Uhgɨn təmegəhan-in, kən in otən məmə, ‘?Məto tahro nəkəsotənən nɨpahrien e Jon?’ ");
INSERT INTO tnn_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Məto okəmə kitat kotən məmə netəmim əm kəmotegəhan-in, kən netəm mɨn əh okotaht kitat e kəpiel məto-inu ilat kɨnotən rəkɨs nɨpahrienən e Jon məmə in ien kit rəha Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kən ilat kəmotuhalpɨn məmə, “Itɨmat esotɨtunən məmə pah təmegəhan-in.” ");
INSERT INTO tnn_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kən Iesu təmən-ipən kəm ilat məmə, “Kən io mɨn, ko esənən məmə pah təmegəhan-in nepətən kəm io məmə ekatol natɨmnat mɨn u.” ");
INSERT INTO tnn_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kən Iesu təmuəh nimaa nəghatən kit kəm netəmim məmə, “Etəm-iasol kit təməfe nol u krep e nasumən asol rəhan. Kən in təmələhəu-pən nasumən u e nelmɨ netəmim neen, kən ilat okotol wək lan, kən nian rəha nəulək-inən, okotos-ipən məsɨn kəm in. Kən təmuwɨn əpəh e nɨməptən pɨsɨn kit matɨg mɨnos nian tepət. ");
INSERT INTO tnn_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kən nian krep təmol noan kən kɨnotəmarəg, etəm-iasol in təmahl-ipa rəhan kit iolwək məmə in otuwɨn mehm netəm koatol wək e rəhan nasumən məmə okotəhl noa krep, kən motoor kos-ipən rəha etəm-iasol neen. Məto netəm mɨn əh kəmotətul motaht iolwək əh, kən motahl-ipən tɨtəlɨg məsotəmki-pənən noa krep neen ne kəm in. ");
INSERT INTO tnn_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kən etəm-iasol təmahl-ipa mɨn rəhan kit iolwək mɨn. Kən ilat kotaht mɨn, motol naulɨsən rat kəm in, kən motahl-ipən tɨtəlɨg məsotəmki-pənən noa krep neen ne kəm in. ");
INSERT INTO tnn_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kən in tahl-ipən mɨn kit mɨn, kən ilat kəmoatoh katoh kos-ipən nɨməgəm kəm in, kən motahl-iarəp. ");
INSERT INTO tnn_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Kən etəm-iasol rəha nasumən təmə, ‘?Ekol naka əh-roiu? Təwɨr məmə ekahl-ipən nətɨk ətuatɨp itəm iakolkeike pɨk, okəm-naka ilat okotɨsiai-in.’ Kən in təmahl-ipən. ");
INSERT INTO tnn_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Məto nian netəm mɨn əh kəmotehm, kəmotən kəm ilat mɨn məmə, ‘Nətɨ etəm-iasol ilouin tatuwa itəm o nian kit nasumən tuwa məmə rəhan. Pəs kotuwɨn motohamnu, kən kitat okotos nasumən rəhan məmə rəhatat.’ ");
INSERT INTO tnn_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kən kəmotaskəlɨm motewkəkan motuwɨn əpəh ihluə e nasumən, kən motoh kohamnu. “?Kən iərəmərə otol naka kəm netəm mɨn əh? ");
INSERT INTO tnn_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","In otuwa moh netəm mɨn əh kotɨmɨs, kən in otələhəu-pən nasumən asol əh otuwɨn e nelmɨ netəm pɨsɨn.” Kən nian netəm kəmoatətəlɨg-in in kəmotəto nəghatən əh, kəmotən məmə, “!Pəs okol kəsol agɨn-əhən nat əh!” ");
INSERT INTO tnn_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Məto Iesu təmasɨpən ətuatɨp əm olat, kən mən məmə, “Naoa Rəha Uhgɨn tatən məmə, ‘Kəpiel əh itəm netəm rəha niləkɨnən nimə kəmotərakin, in təmuwa kəpiel keike rəha nolən nimə.’ “?Məto nəghatən u nɨpətɨn naka? ");
INSERT INTO tnn_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Netəmim rafin itəm okotiet motorin-pən ilat e kəpiel əh, kən okotorapɨtpɨt ilat motol nɨmɨsmɨsɨn. Məto okəmə kəpiel əh otiet maht suah kit, kən in otawtəwɨtə mərat agɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kən iəgətun mɨn rəha Lou, ne pris asol mɨn kəmotɨtun məmə nimaa nəghatən rəhan tatən ilat, kən tol nəhlan, kəmoategəs-in suatɨp məmə okotaskəlɨm uəhai əm, kɨləs-ipən e kalapus, məto kɨnoatəgin netəmim, kən motapəs. ");
INSERT INTO tnn_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kən iəgətun mɨn rəha Lou, ne pris asol mɨn koatalkəlɨk wɨr o Iesu, moatolkeike məmə okotətu-pən nɨpəgnəmtɨn mɨn neen e nəghatən kit rəhan məmə okotɨləs-ipən in e nelmɨ etəm Rom, kapman rəhalat. Kən kəmotahl-ipən netəmim neen məmə ilat okotuwɨn motol kəut kəsuə kəm Iesu. ");
INSERT INTO tnn_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kən kəut kəsuə mɨn kəmotuwɨn motətapəh o Iesu məmə, “Iəgətun. Itɨmat ekotɨtun natɨmnat mɨn itəm nakatən ne natɨmnat itəm nakəgətun netəmim lan, kotətuatɨp wɨr. Ik onakəsolən nolən pɨsɨn kəm suah kit, kən matɨg mol pɨsɨn mɨn kəm suah kit. Məto onəkol tahmen ahmen əm kəm ilat rafin. Kən ik nakatəghat-in əm nɨpahrienən matəgətun netəmim e suatɨp rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","?Ən-tu kəm itɨmat məmə, tətuatɨp e Lou rəhatat məmə okotətou takɨs kəm Sisa u in kapman rəha Rom, o kəp?” ");
INSERT INTO tnn_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Məto Iesu təmɨtun əm məmə koatol kəut kəsuə kəm in, kən in təmən-ipən kəm ilat məmə, ");
INSERT INTO tnn_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Otəgətun-tu məni kit kəm io. ?Narmɨ pah u tətatɨg e məni u? ?Kən nərgɨ pah u tətatɨg e məni u?” Kən kəmotən məmə, “Narmɨ Sisa, ne nərgɨ Sisa.” ");
INSERT INTO tnn_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kən in təmən-ipən kəm ilat məmə, “Inəh natɨmnat rəha Sisa, os-ipən kəm Sisa. Kən natɨmnat rəha Uhgɨn, os-ipən kəm Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kən e nɨganəmtɨ netəmim rafin, nəghatən mɨn itəm koatətapəh-in, okol kəsotɨləs-iəhauən Iesu lan. Məto narmɨlat təmiwɨg pɨk o nəghatən itəm Iesu təmuhalpɨn, kən kəməsotəghatən. ");
INSERT INTO tnn_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kən Satusi mɨn neen kəmotuwa o Iesu. Ilat koatən məmə netəm kəmotɨmɨs, okol kəsotəmegəh mɨnən. ");
INSERT INTO tnn_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Kən kəmotətapəh-in nəghatən kit kəm Iesu məmə, “Iəgətun. Moses təməte-pən e Lou rəhatat məmə okəmə suah kit otɨmɨs, kən rəhan pətaguɨhl tətatɨg məto kəməsialəsən nətɨlau kit, kən inəh pian kit otəkəike mit nəutahlɨmɨs un. E nolən əh, ilau okuemək, kən nɨsualkələh mɨn okotaskəlɨm nərɨg mɨn rəha etəm tɨkə. ");
INSERT INTO tnn_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","“Tol nəhlan, pian ilat sepɨn. Kən itəm tepət elat təmaupən mit pətan kit, kən uarisɨg tɨmɨs, məto kəsialəsən nətɨlau kit. ");
INSERT INTO tnn_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Pian itəm tatuarisɨg in, təmit mɨn nəutahlɨmɨs un, məto in mɨn təmɨmɨs, kən kəsialəsən nətɨlau kit. ");
INSERT INTO tnn_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kən uarisɨg lan, pialat kit mɨn tit mɨn nəutahlɨmɨs un, məto təmɨmɨs mɨn. Kən pian mɨn əh ilat rafin sepɨn kəmotit pətan un, məto kəsotɨləsən nətɨlat kit, kən kəmotɨmɨs rafin. ");
INSERT INTO tnn_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kən uarisɨg lan, nəutahlɨmɨs təmɨmɨs mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Inəh netəm sepɨn, ilat pialat mɨn kəmotit pətan əh. ?Məto e Namnun Nian, nian netəmim okotəmegəh mɨn e nɨmɨsən, pətan əh in rəha pah lan?” ");
INSERT INTO tnn_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Kən Iesu təmən-ipən kəm ilat məmə, “E nətueintən u, nəman ne nɨpɨtan koatol marɨt. ");
INSERT INTO tnn_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Məto e nian rəha natɨgən wi, netəmim itəm Uhgɨn nɨkin tətagien olat məmə ilat okotəmegəh mɨn e nɨmɨsən kən mos ilat muwɨn kotatɨg e natɨgən wi, ko ilat kəsotol mɨnən marɨt. ");
INSERT INTO tnn_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ilat okol kəsotɨmɨs mɨnən məto-inu ilat okotahmen əm e nagelo mɨn. Kən ilat nenətɨ Uhgɨn məto-inu in təmol ilat kotəmegəh mɨn e nɨmɨsən. ");
INSERT INTO tnn_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kən kotɨtun məmə inu otuwa mol nɨpahrienən lan məto-inu, naoa rəha Moses tatəgətun mɨn məmə nian netəmim okotɨmɨs, ilat okotəmegəh mɨn. E namsu rəha nɨg itəm nɨgəm təmatuəpən lan, Moses tətaun-in Iərəmərə Uhgɨn məmə in ‘Uhgɨn rəha Epraham, Uhgɨn rəha Aisak, ne Uhgɨn rəha Jekop,’ nat əpnapɨn iləhal kəməhalɨmɨs rəkɨs nuwəh məsɨn. ");
INSERT INTO tnn_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Uhgɨn u, in Uhgɨn rəha netəm koatəmegəh, məto sənəmə in Uhgɨn rəha netəm kəmotɨmɨs, məto-inu in tatehm netəmim rafin məmə ilat koatəmegəh, nat əpnapɨn okəmə kəmotɨmɨs rəkɨs o koatəmegəh əh.” ");
INSERT INTO tnn_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kən iəgətun mɨn rəha Lou neen kəmotən-ipən kəm Iesu məmə, “Iəgətun, nəmuhalpɨn wɨr pahrien.” ");
INSERT INTO tnn_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kən kəmotəgɨn o nətapəh-inən nəghatən kit mɨn tol min-nəhlan. ");
INSERT INTO tnn_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Kən Iesu təmən-ipən kəm ilat məmə, “?Tahro netəmim koatən məmə Kristo itəm Uhgɨn təmən məmə otahl-ipa, in mipɨ Kig Tefɨt rat? ");
INSERT INTO tnn_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Məto-inu e Naoa Rəha Napuən Mɨn, Kig Tefɨt atɨp əm təmən məmə, ‘Iərəmərə Uhgɨn təmən kəm rəhak Iərəmərə Kristo məmə, “Əpələh e nɨkalɨk matɨp, ikɨn rəha nəsanənən ne nɨsiaiiən, ");
INSERT INTO tnn_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mətoarus-pa io ekos-iəhau rəham tɨkɨmɨr mɨn, mol ilat kotahmen e nɨməhan kit itəm nateguafəl nelkəm lan.”’ ");
INSERT INTO tnn_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Kig Tefɨt atɨp təmən məmə Mesaea in rəhan Iərəmərə. ?Kən okəmə mipɨ Tefɨt atɨp əm, kən tahro matol rəhan Iərəmərə?” ");
INSERT INTO tnn_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nian netəmim kəmoatətəlɨg, Iesu təmən-ipən kəm rəhan mɨn netəmim məmə, ");
INSERT INTO tnn_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Itəmat onəkotəkəike moatəto wɨr itəmat kən məsotətəu-pənən nolən mɨn rəha iəgətun mɨn rəha Lou. Nɨkilat tətagien məmə okoatuwɨn-in napən əfəməh mɨn rəha nausitən məmə netəmim okoatehm ilat ron. Kən nɨkilat tətagien nian netəmim koatos-ipər nelmɨlat e maket e nɨsiaiiən kəm ilat. Kən əpəh imə e nimə rəha nuəfɨmɨnən, kotolkeike məmə okotəpələh aupən əpəh təwɨr ikɨn. Kən e nian rəha lafet, ilat koatolkeike məmə okotuwɨn kəpələh-pən aupən ikɨn rəha nɨsiaiiən. ");
INSERT INTO tnn_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Kən ilat koatol tərat kən motakləh-in nimə mɨn rəha nəutahlɨmɨs mɨn. Kən ilat koatəfak əfəməh moateiuə əm məmə netəmim okoatəplan ilat ron. Nalpɨnən rəha netəm mɨn u in otəskasɨk maprəkɨs.” ");
INSERT INTO tnn_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Kən Iesu təmatehm tatɨsɨlu wɨr netəm rəhalat nautə tepət itəm koataii-pən məni e pokɨs rəha məni əpəh e Nimə Rəha Uhgɨn, ");
INSERT INTO tnn_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","kən in təmehm nəutahlɨmɨs kit ian-rat təmaii-pən məni əkəku kəiu əm. ");
INSERT INTO tnn_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kən Iesu təmən məmə, “Nɨpahrienən iatən kəm itəmat məmə, məni itəm pətan u təmaii-pən, in taprəkɨs-in rəha netəmim rafin, ");
INSERT INTO tnn_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","məto-inu netəm rəhalat nautə tepət kəmotaii-pən məni neen məto in nat əpnapɨn əm olat, rəhalat tepət mɨn əh-ikɨn. Məto nəutahlɨmɨs u itəm in ian-rat pahrien, in təmos-ipən rafin məni rəhan o nos-nəmtɨnən nɨgɨn nagwənən, kən tɨkə mɨn əh-ikɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kən rəhan mɨn neen netəmim koatəghat-in Nimə Rəha Uhgɨn itəm rəhan kəpiel asol mɨn kotəwɨr, ne natɨmnat wɨr mɨn əh imə itəm netəmim kəmotos-ipən kəm Uhgɨn. Kən Iesu təmən məmə, ");
INSERT INTO tnn_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Itəmat nakoatehm natɨmnat mɨn əh, məto nian otatuwa itəm netəmim okotohalkin-ohalkin kəpiel mɨn rəha nimə əh, inəh kəpiel kit otəsətulən əh-ikɨn tatətul ikɨn roiu.” ");
INSERT INTO tnn_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Kən kəmotətapəh ron məmə, “Iəgətun. ?Natɨmnat mɨn əh onəghan kotuwa? ?Kən nəmtətin naka otəgətun məmə otəsuwəhən natɨmnat mɨn əh okotuwa?” ");
INSERT INTO tnn_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Kən Iesu tatən məmə, “Onəkotəkəike moatəto wɨr itəmat məmə suah kit otəseiuə-inən itəmat, məto-inu netəmim tepət okotuwa motən məmə, ‘!Io, io Kristo u!’ kən neen okotən məmə, ‘Nian rəha natɨmnat əh tɨnatuwa iuəhkɨr.’ Məto əsotuarisɨg-inən ilat. ");
INSERT INTO tnn_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kən nian onəkotəto namnusən məmə netəmim koatəluagɨn, o netəmim koatətul moatəmou ilat rəhalat kapman, məto itəmat onəsotəgɨnən. Natɨmnat mɨn əh okotaupən ka pitən, məto sənəmə in Namnun Nian.” ");
INSERT INTO tnn_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kən Iesu təmən-ipən kəm ilat məmə, “Noanol mɨn neen okotoh noanol pɨsɨn neen mɨn, kən kapman kit otoh kapman kit. ");
INSERT INTO tnn_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kən namig asol mɨn okotan, kən nəumɨs otan ikɨn mɨn tepət e nətueintən, kən nɨmɨsən əskasɨk mɨn okotan e nətueintən, kən əpəh ilɨs e neai, natɨmnat okotuwa motol nɨki netəmim otəgɨn, kən ilat okotəplan nəmtətin asol mɨn e neai. ");
INSERT INTO tnn_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Məto nian natɨmnat mɨn u okəsotuwamən əh, netəmim okotaskəlɨm itəmat, kən motoh itəmat, kən motɨləs itəmat kan əpəh e nimə mɨn rəha nuəfɨmɨnən, ne əpəh e kalapus, kən onakoatətul e nɨganəmtɨ kig mɨn ne netəm-iasol mɨn rəha kapman məto-inu itəmat nakoatos nərgək moatən nɨpahrien lak. ");
INSERT INTO tnn_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Inəh nian ətuatɨp məmə nakotən-iarəp namnusən təwɨr kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Məto əsotətəlɨg-in paupənən məmə nəghatən naka itəm onəkotən kəm ilat, ");
INSERT INTO tnn_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","məto-inu io ekos-ipɨnə nəghatən ətuatɨp kəm itəmat kən mos-ipɨnə nenatɨgən kəm itəmat, kən mol rəhatəmat nəghatən təsanən, kən rəhatəmat tɨkɨmɨr mɨn okol kəsotuhalpɨnən, kən okol kəsotənən məmə nakoateiuə. ");
INSERT INTO tnn_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kən rəhatəmat tata ne mama mɨn, ne piatəmat mɨn, ne rəhatəmat noanol mɨn, ne iolɨtəmat mɨn okotɨləs-ipən itəmat e nelmɨ tɨkɨmɨr mɨn. Kən okotohamnu itəmat neen. ");
INSERT INTO tnn_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Netəmim rafin okotetəhau itəmat o nərgək. ");
INSERT INTO tnn_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Məto noanutəmat ne huə, kit otəsɨkəən. ");
INSERT INTO tnn_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nian onakoatətul əskasɨk motahatətə lak e nian iəkɨs mɨn itəm okoatuwa e rəhatəmat nəmegəhən, kən onəkotos nəmegəhən lilɨn lan. ");
INSERT INTO tnn_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Məto nian onakehm mopael mɨn okotuwa tepət motɨtəlau e taon u Jerusalem, kən itəmat onəkotəkəike motɨtun məmə otəsuwəhən kən kərəkɨn agɨn taon əh Jerusalem. ");
INSERT INTO tnn_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kən itəmat netəm nəkotatɨg Jutia, onəkotəkəike motaiu motagɨm motuwɨn motəhluaig əpəh nɨtot mɨn. Kən itəmat netəm nəkotatɨg e taon əh, onəkotəkəike motiet. Kən itəmat netəm nəkotatɨg ikɨn mɨn tɨtəlau e taon əh, onakəsotuwɨn mɨnən əh imə e taon əh, ");
INSERT INTO tnn_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","məto-inu nian əh, in nian rəha Uhgɨn otol nalpɨnən lan kəm netəm koatol nolən tərat, kən mol əp nəghatən itəm kəməte-pən e naoa rəhan tuwa mol nɨpahrienən. ");
INSERT INTO tnn_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Awe, nahməən asol rəha mama mɨn itəm nərpɨlat əh-ikɨn, ne itəm mɨn u koatapinahin nɨsualkələh, məto-inu nəratən asol otuwa e nətueintən, kən neməha ne nalpɨnən rəha Uhgɨn otuwɨn kəm netəmim rafin rəha Isrel. ");
INSERT INTO tnn_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kən okagɨmnu netəmim e naip, kən nian rəhalat tɨkɨmɨr mɨn kəmotol win elat, kən okotit ilat motuwɨn ikɨn pɨsɨn pɨsɨn mɨn kən ilat okotuwa slef mɨn rəhalat. Kən Iaihluə mɨn okotaliwək kən katewɨg-ewɨg e Jerusalem motɨləs-iəhau netəmim ikɨn itəm koatatɨg əh, motərəmərə elat, kətoarus-pən nian rəhalat otol namnun. ");
INSERT INTO tnn_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Kən nəmtətin neen okotuwa e mɨtgar, ne məwɨg, ne məhau mɨn. Kən ikɨn-u e nətueintən, netəmim rafin okotəgin nərkərɨkən rəha nɨtəhəi ne peau-peau asol mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Netəmim okotəgɨn pɨk moatɨmɨseah o nəratən asol mɨn itəm koatuwa e nətueintən, məto-inu natɨmnat rəha neai itəm kotəskasɨk pɨk, məto Uhgɨn otəloal-əloal elat. ");
INSERT INTO tnn_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kən e nian əh, okotehm Nətɨ Etəmim tateiuaiu e mal napuə kit e nəsanənən ne nepətən əhag-əhag asol rəhan. ");
INSERT INTO tnn_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kən nian natɨmnat mɨn u kɨnotətuoun moatuwa katol nɨpahrienən lan, otətul motasɨpər e neai, məto-inu otəsuwəhən rəhatəmat Kristo otuwa mɨkɨs itəmat.” ");
INSERT INTO tnn_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kən in təmuəh nimaa nəghatən kəm ilat məmə, “Nakotɨtun-tu nɨg u fik ne nɨg neen mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Okəmə kotalpətəg mɨnotapɨlpɨl mɨn, kən nəkotɨtun məmə in nian rəha nasumən. ");
INSERT INTO tnn_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","E nolən kitiəh əm, okəmə nakotehm natɨmnat mɨn u koatol nəhlan, onəkotɨtun məmə otəsuwəhən, nərəmərəən rəha Uhgɨn tuwa. ");
INSERT INTO tnn_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Nɨpahrienən ekatən kəm itəmat məmə noanol rəha Isrel otəsɨkəən mətoarus-pən natɨmnat rafin əh okotol nɨpahrienən. ");
INSERT INTO tnn_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Neai ne nətueintən okiakə, məto nəghatən mɨn rəhak okol kəsotɨkəən.” ");
INSERT INTO tnn_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Kən Iesu tatən məmə, “Nəkotəkəike moatəto itəmat. Əsotərəkɨnən rəhatəmat nian mɨn o nolən əmən lafet, motapɨs lan, kən moatətəlɨg-in pɨk natɨmnat rəha nətueintən u. Təsəwɨrən məmə nian rəhak otuwa mos kaut kəm itəmat tahmen-pən məmə noanɨkulu təmohasɨn itəmat, ");
INSERT INTO tnn_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","məto-inu nian əh otuwa mɨləs netəmim rafin rəha nətueintən. ");
INSERT INTO tnn_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Məto nian rafin onəkotəkəike moatətul matɨp, kən motəkəike katəfak məmə nakotos nəsanənən tahmen məmə nəkoatətul əskasɨk əm e nian natɨmnat rafin əh koatuwa, kən inəh nɨki Nətɨ Etəmim otagien otəmat nian onəkotətul e nɨganəmtɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kən nian rafin Iesu tatəgətun netəmim əpəh e Nimə Rəha Uhgɨn, kən lapɨn mɨn in tiet muwɨn əpəh Nɨtot Rəha Nɨg U Olif mətapɨl əh-ikɨn. ");
INSERT INTO tnn_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kən nian mɨn rafin laulaugɨn agɨn, netəmim koatuwa məmə okotətəlɨg-in rəhan nəghatən əpəh e Nimə Rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kən nian rəha lafet rəha Pret U Is Tɨkə Lan tɨnatuwa iuəhkɨr, kən in tɨnətuoun e lafet rəha Nuhagego-inən. ");
INSERT INTO tnn_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Kən pris asol mɨn ne iəgətun mɨn rəha Lou koateam-in anion suatɨp məmə okotohamnu Iesu lan. Koateam-in anion suatɨp məto-inu ilat koatəgin netəmim məmə, kətah nɨmanin netəmim okotəmou okəmə kotɨtun məmə kəmotohamnu Iesu. ");
INSERT INTO tnn_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","“Kən Setan təmos nɨki Jutas, u nərgɨn kit mɨn u Iskariot, in e netəm tuelef rəha Iesu. ");
INSERT INTO tnn_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Kən in təmuwɨn matəghat kəm pris asol mɨn ne netəm-iasol mɨn rəha mopael rəha Nimə Rəha Uhgɨn, mateam-in suatɨp məmə otegəhan-in Iesu tuwɨn e nelmɨlat. ");
INSERT INTO tnn_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Kən nɨkilat təmagien, kən kəmotən-iəkɨs məmə okotos-ipən məni kit kəm in. ");
INSERT INTO tnn_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Kən Jutas təmegəhan lan məmə in otol, kən mateam-in suatɨp məmə otegəhan-in Iesu tuwɨn e nelmɨlat nian netəmim okotɨkə lan. ");
INSERT INTO tnn_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kən nian rəha lafet rəha Pret U Is Tɨkə Lan tɨnuwa, kən e nian əh, netəmim okotəkəike motoh nətɨ sipsip rəha lafet rəha Nuhagego-inən. ");
INSERT INTO tnn_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Kən Iesu təmaun-in Pita ne Jon, kən mən-ipən kəm ilau məmə, “Ian kən mioal əpen-əpenə nagwənən rəha lafet rəha Nuhagego-inən məmə okotuwɨn motagwən ikɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Kən kəmuən-ipən kəm in məmə, “?Nakolkeike məmə itɨmlau oekian hiə mioal əpen-əpenə e nagwənən ikɨn?” ");
INSERT INTO tnn_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Kən təmən-ipən kəm ilau məmə, “Uətəlɨg wɨr-tu. Nian itəmlau onakuet-arəpən e taon, kən onakuehm suah kit tatəhun pətəl asol kəmətu-pən nəhau lan. Kən nəkiauarisɨg-in məhaluwɨn e nimə kit itəm otuwɨn ikɨn. ");
INSERT INTO tnn_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Kən nəkuən-ipən kəm etəm-iasol rəha nimə məmə, ‘?Iəgətun təmahl-ipa itɨmlau məmə ekuea muətapəh ron ik məmə noan u in hiə itəm in ne rəhan mɨn netəmim okotuwa motol nagwənən ikɨn rəha lafet rəha Nuhagego-inən?’ ");
INSERT INTO tnn_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kən in otit itəmlau nakian əpəh e noan ilɨs ikɨn itəm kɨnəlɨn wɨr rəkɨs natɨmnat rafin rəha nagwənən əh-ikɨn. Kən nakioal əpen-əpenə nagwənən əh-ikɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kən kəmian muehm natɨmnat rafin tahmen əm məmə inu Iesu təmən mihin ne. Kən kəmioal əpen-əpenə e nagwənən ikɨn rəha lafet rəha Nuhagego-inən. ");
INSERT INTO tnn_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kən e nian rəha nagwənən, Iesu təmuwɨn məpələh e tepɨl ilat rəhan aposol mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kən təmən-ipən kəm ilat məmə, “Otəsuwəhən, okol nahməən kəm io. Məto nɨkik tɨnolkeike pɨk məmə okotaupən kun nagwənən rəha lafet rəha Nuhagego-inən. ");
INSERT INTO tnn_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Iakolkeike pɨk məmə kitat okotagwən min-nulan məto-inu, okol esagwən mɨnən e nagwənən rəha Nuhagego-inən mətoarus nɨpətɨ lafet u tuwa mol nɨpahrienən lan e nərəmərəən rəha Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kən Iesu təmos kap wain mən tagkiu ron kəm Uhgɨn, kən mən məmə, “Otos itəmat rafin, kən motənɨm, ");
INSERT INTO tnn_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","məto-inu roiu iatən kəm itəmat məmə esənɨmən wain mətoarus-pən nian natɨmnat rafin kotatɨg ahgin nərəmərəən rəha Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kən təmos pɨret mən tagkiu ron kəm Uhgɨn, kən məmkas mos-ipən kəm rəhan mɨn netəmim, kən mən məmə, “Inu nɨpətɨk itəm iakatos-ipɨnə otəmat. Nian rafin onəkotəkəike motol nat u məmə nɨkitəmat tatəht io.” ");
INSERT INTO tnn_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kən e nolən kitiəh əm, nian kəmotagwən rəkɨs, Iesu təmos kap wain kən təmən məmə, “Kap wain u in nɨtak itəm otaiu otəmat, kən tatəgətun nəniəkɨsən wi rəha nasituən rəha Uhgɨn kəm netəmim. ");
INSERT INTO tnn_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Məto onəkotətəlɨg wɨr-tu. Suah kit ukɨn-u kotagwən kitat min e tepɨl, kən in otəpanegəhan-in-pən io e nelmɨ rəhak mɨn tɨkɨmɨr. ");
INSERT INTO tnn_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Io Nətɨ Etəmim oekəkəike mɨmɨs məmə inu Uhgɨn təmən mihin ne. !Məto awe, nahməən asol tatuwɨn o etəm tategəhan-in-pən io e nelmɨ tɨkɨmɨr mɨn!” ");
INSERT INTO tnn_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Kən kɨnoatətapəh-ətapəh olat mɨn məmə, “?Kitat pah otol nat əh?” ");
INSERT INTO tnn_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kən nat kit mɨn, ilat kɨnoatol nɨkilat mɨn məmə pah u in ilɨs pɨk taprəkɨs-in ilat. ");
INSERT INTO tnn_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Kən Iesu təmən-ipən kəm ilat məmə, “Kig mɨn rəha nətueintən u koatərəmərə e netəmim e rəhalat nəsanənən, kən koataun-in atɨp ilat məmə ilat ‘Netəm rəha Nasituən.’ ");
INSERT INTO tnn_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Məto itəmat onəkəsotolən min-nəhlan. Okəmə itəmat kit in ilɨs, in otɨləs-iəhau in tahmen-pən e suakəku. Kən okəmə itəmat kit tatətul aupən, kən in otuwa iolwək əm kit. ");
INSERT INTO tnn_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","?Pah u in ilɨs pɨk, etəmim itəm tətagwən e tepɨl, o iolwək itəm tatos nagwənən matuwa? Nəkotɨtun məmə etəm tətagwən e tepɨl in ilɨs taprəkɨs. Məto io, etəm-iasol rəhatəmat, nian emətaliwək kitat min itəmat, emahmen-pən e iolwək əm kit. ");
INSERT INTO tnn_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Itəmat u, nian rafin nəkotatɨg iuəhkɨr ron io e nian ekətatɨg e nian əskasɨk mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kən tahmen-pən əm məmə Tata rəhak tatɨləs-ipər io məmə ekuwa kig, kən io mɨn iatɨləs-ipər itəmat məmə nakotuwa kig mɨn, ");
INSERT INTO tnn_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","məmə nakotuwa kəpələh kitat min io, kotagwən kələh e nian ekuwa mol kig lan. Kən e nian əh, itəmat mɨn onəkotəpələh e jea mɨn rəha kig, kən itəmat onəkotuwa motətul aupən e noanol mɨn tuelef rəha Isrel moatakil ilat moatərəmərə elat.” ");
INSERT INTO tnn_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Kən Iesu təmən-ipən kəm Saimon Pita məmə, “Kəsi. Saimon. Ətəlɨg-in-tu io. Setan tɨnətapəh rəkɨs o Uhgɨn məmə otegəhan-in məmə in otuwa mos-ipən-os-ipən kəm itəmat mol nəratən kəm itəmat məmə otəgətun rəhatəmat nahatətəən in təskasɨk lak o kəp. ");
INSERT INTO tnn_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Məto enəfak rəkɨs ron ik məmə rəham nahatətəən otəsatiteən. Kən nian nakatəuhlin rəham nətəlɨgən tatɨtəlɨg-pa mɨn, ik onakəkəike mol nətəlɨgən rəha piam mɨn okotəskasɨk.” ");
INSERT INTO tnn_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Məto Saimon Pita təmən-ipən kəm in məmə, “Iərəmərə. Iatətul matɨp məmə ekɨmnə kilau min ik e kalapus, kən mɨmɨs kilau min ik.” ");
INSERT INTO tnn_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Kən Iesu təmən-ipən kəm in məmə, “Pita, ekatən kəm ik məmə, o lapɨn huə, nian mənɨg otəsɨmnənən əh, kən ik onakən mau kɨsɨl məmə nəkəruru io.” ");
INSERT INTO tnn_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kən Iesu təmən-ipən kəm ilat məmə, “Aupən, emətahl-iarəp itəmat, nəməsotosən məni e paos, ne kətɨm, ne put. ?Tahro? ?Rəhatəmat natɨmnat təsahmenən, o kəp?” Kən ilat kəmotən məmə, “Kəp.” ");
INSERT INTO tnn_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Kən təmən-ipən kəm ilat məmə, “Məto roiu, okəmə suah kit tatos rəhan məni e paos o kətɨm, otəkəike mos. Kən etəm təsosən naip rəha nəluagɨnən, pəs otol-salɨm-in rəhan kot mos-nəmtɨ rəhan kit. ");
INSERT INTO tnn_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Iatən kəm itəmat məmə nəghatən u e Naoa Rəha Uhgɨn tatəghat-in io, kən in otəkəike mol nɨpahrienən. In tatən məmə, ‘Netəmim nɨkilat təht məmə in etəmim kit itəm tatərəkɨn Lou.’ Əwəh, nəghatən u tatol nɨpahrienən əh-roiu.” ");
INSERT INTO tnn_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kən ilat kəmotən məmə, “Iərəmərə, əplan-tu. Naip rəha nəluagɨnən kəiu əpəh.” Kən in təmən kəm ilat məmə, “Ah, nahmen. Otapəs-ta.” ");
INSERT INTO tnn_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kən Iesu təmiet e taon muwɨn əpəh e Nɨtot Rəha Nɨg U Olif tahmen-pən əm məmə in tatol mihin e nian rafin, kən rəhan mɨn netəmim koatətəu-pən. ");
INSERT INTO tnn_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kən nian in təmuwɨn mətoarus-pən əh-ikɨn əh, təmən-ipən kəm ilat məmə, “Onəkotəkəike moatəfak məmə nat kit otəsos-ipən-os-ipənən kəm itəmat motol rəhatəmat nahatətəən otatite lak.” ");
INSERT INTO tnn_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kən in təmaliwək mapəs ilat muwɨn məsɨn, kən mɨsin nulan matəfak matən məmə, ");
INSERT INTO tnn_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tata, okəmə nɨkim tagien, awi, os-irəkɨs nahməən mɨn u itəm okəpanotuwa. Məto əsolən rəhak nətəlɨgən, məto ol nat naka itəm ik əm nakolkeike.” ");
INSERT INTO tnn_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kən nagelo kit təmɨsɨ-pən e neai muwa mos-ipən nəsanənən kəm Iesu. ");
INSERT INTO tnn_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kən məto-inu nɨkin tɨtahmə pɨk, kən rəhan nətəlɨgən tɨnatol wək pɨk, kən təməfak əskasɨk pɨk, kən noəh təmaiu lan məhl matəht nɨsɨp tahmen e nɨta. ");
INSERT INTO tnn_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nian təməfak rəkɨs, in təmətul mɨtəlɨg-pən məmə otehm rəhan mɨn netəmim, kən təməplan ilat kɨnotapɨl rəkɨs. Kɨnotəpou məto-inu nɨkilat tɨtahmə. ");
INSERT INTO tnn_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kən təmən-ipən kəm ilat məmə, “?Tahro nakotapɨl? Otaiir motəfak məmə nat kit otəsos-ipən-os-ipənən kəm itəmat motol rəhatəmat nahatətəən otatite lak.” ");
INSERT INTO tnn_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nian Iesu təmatəghat əh, nɨmanin netəmim kəmotiet-arəpa ikɨn əh, kən suah əh Jutas, u in etəmim kit e netəm tuelef rəha Iesu, in təmit ilat motuwa, kən təmuwa iuəhkɨr məmə otatuilɨm e Iesu. ");
INSERT INTO tnn_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Məto Iesu təmən-ipən kəm in məmə, “?Jutas, io Nətɨ Etəmim, məto tahro nəmuwa məmə onəkatuilɨm-pa lak kən e nolən əh megəhan-in-pən io e nelmɨ rəhak tɨkɨmɨr mɨn?” ");
INSERT INTO tnn_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kən nian netəmim mɨn rəha Iesu kɨnotehm natɨmnat mɨn əh mɨnotɨtun məmə naka əh okol, kəmotən-ipən kəm in məmə, “?Iərəmərə, oekotahro? ?Ekotəte ilat e naip, o?” ");
INSERT INTO tnn_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kən ilat kit təmoahin naip təte-rəkɨs matəlgɨn matɨp rəha slef rəha pris asol agɨn. ");
INSERT INTO tnn_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Məto Iesu təmə, “!Ei! !Nahmen, otapəs əm!” Kən in təmələhəu-pən nelmɨn e matəlgɨ suah u, kən mol-wɨr mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kən Iesu təməghat kəm pris asol mɨn, ne netəm-iasol mɨn rəha mopael rəha Nimə Rəha Uhgɨn, ne etəm-iasol mɨn rəha noanol rəha Isrel, u kəmotuwa məmə okotaskəlɨm Iesu. In təmən məmə, “?Tahro, nəman? ?Nɨkitəmat təht məmə io emit netəmim muwɨn kotəluagɨn o kapman, o kəm-naka io iohamnu itəm kit, kən nakotəmɨk naip asol mɨn rəha nəluagɨnən ne nəlnal mɨn moatuwa məmə onəkotaskəlɨm? ");
INSERT INTO tnn_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","?Nian rafin etan əm kitat min itəmat e Nimə Rəha Uhgɨn, məto tahro nəsotaskəlɨmən io? Məto roiu əh, in nian ətuatɨp rəhatəmat, kən nəsanənən rəha napinəpən in tatərəmərə.” ");
INSERT INTO tnn_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kən kəmotuwa motaskəlɨm Iesu motɨləs motuwɨn e latuənu rəha pris asol agɨn. Kən Pita tuarisɨg-in ilat məto təsuwɨnən iuəhkɨr olat. ");
INSERT INTO tnn_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Netəm mɨn əh kəmotahl nɨgəm kit əpəh e iat rəha pris asol agɨn, kən motəpələh kɨtəlau e nɨgəm. Kən Pita tuwa matəpələh ilat min. ");
INSERT INTO tnn_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kən pətan əkəku kit u slef rəha pris asol agɨn, təmuwa mehm Pita tatəpələh, kən nəhag-əhagən rəha nɨgəm tətasiəgəpɨn in, kən nɨganəmtɨ pətan əh təmətul lan, kən təmən-ipən kəm ilat məmə, “Suah u, in mɨn ilau Iesu kəmatuan.” ");
INSERT INTO tnn_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Məto Pita təmən-ipən kəm pətan un məmə, “Esɨtunən suah un nakatən.” ");
INSERT INTO tnn_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kən uarisɨg lan təsuwəhən, suah kit mɨn tuwa mən-ipən kəm Pita məmə, “Ei, ik mɨn, ik etəmim kit rəhan.” Məto Pita təmə, “Ei, sənəmə io etəmim rəhan.” ");
INSERT INTO tnn_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Uarisɨg lan, aua kit tɨnuwa mɨnuwɨn rəkɨs, kən suah kit təməghat əskasɨk kəm ilat məmə, “!Nɨpahrienən məmə suah u təmatuarisɨg-in Iesu, məto-inu in etəm Kalili!” ");
INSERT INTO tnn_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Məto Pita təmə, “!Ei! !Esɨtun agɨn-əhən nəghatən u nakatən!” Kən nian Pita təmatəghat əh, kən mənɨg təmɨmnən. ");
INSERT INTO tnn_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kən Iərəmərə təməuhlin masɨpən ətuatɨp matehm Pita. Kən Pita, nɨkin təməht nəghatən rəha Iərəmərə itəm təmən lan məmə, “O lapɨn əm u, nian mənɨg otəsɨmnənən əh, ik onakən mau kɨsɨl məmə nəkəruru io.” ");
INSERT INTO tnn_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Kən Pita təmiet muwɨn ihluə, təmasək təmasək. ");
INSERT INTO tnn_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Kən e nian əh, netəmim itəm kəmotaskəlɨm Iesu kəmotəghat əsan lan, kən moatoh. ");
INSERT INTO tnn_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Kən kəmotəlis ətain nɨganəmtɨn kən motoh, moatən-ipən məmə, “!Ei, ien! ?Ən-tu məmə pah tatoh ik?” ");
INSERT INTO tnn_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Kən kəmoatən nəghatən rat tepət moatərəkɨn in lan. ");
INSERT INTO tnn_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kən laulaugɨn agɨn, netəm-iasol rəha noanol rəha Isrel, ne pris asol mɨn, ne iəgətun mɨn rəha Lou kəmotuwa kuəfɨmɨn e kaonsel rəhalat, kən netəmim kəmotɨləs Iesu motuwa tətul e nɨganəmtɨ kaonsel əh. Kən netəm rəha kaonsel kəmotətapəh ron məmə, ");
INSERT INTO tnn_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Okəmə ik Kristo itəm Uhgɨn təmən məmə otahl-ipa, ən kəm itɨmat.” Məto Iesu təmən-ipən kəm ilat məmə, “Okəmə ekən kəm itəmat, kən nəsotənən nɨpahrienən lak. ");
INSERT INTO tnn_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Kən okəmə ekətapəh otəmat, kən okol nəkəsotuhalpɨnən. ");
INSERT INTO tnn_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Məto tətuoun roiu, io Nətɨ Etəmim, io oekuwɨn məpələh əh-ikɨn rəha nəsanənən ne nɨsiaiiən, inəh e nɨkalɨ Uhgɨn matɨp, Uhgɨn u itəm rəhan nəsanənən iahgin.” ");
INSERT INTO tnn_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kən ilat rafin kəmotətapəh ron məmə, “?Tahro? ?Ik Nətɨ Uhgɨn?” Kən Iesu təmən-ipən məmə, “Nakoatən məmə io u inu.” ");
INSERT INTO tnn_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kən kotən məmə, “?Tahro kitat koateam-in nəghatən kit mɨn məmə otasitu e rəhatat nəghatən? Kɨnotəto ətuatɨp nəghatən əh e nohlɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kən netəmim rafin rəha kaonsel kəmotətul motit Iesu motuwɨn kəm Pailat. ");
INSERT INTO tnn_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Kən moatən-iarəp nɨpəgnəmtɨn mɨn itəm otoh Iesu məmə, “Emotehm məmə suah u tatit rəhatat netəmim mɨn, kən mol ilat kotalməl, kən matəuhlin rəhalat nətəlɨgən koatol tɨkɨmɨr ilat kapman rəha Rom, mətahtosɨg-in itɨmat məmə esotətouən takɨs kəm Sisa itəm tatərəmərə e nɨməptən u. Kən in matən-iarəp məmə in Kristo itəm Uhgɨn təmahl-ipa məmə in kig kit.” ");
INSERT INTO tnn_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kən Pailat təmətapəh ron məmə, “?Tahro? ?Ik kig rəha netəm Isrel?” Məto Iesu tən-ipən kəm in məmə, “Ik nəmən mihin.” ");
INSERT INTO tnn_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kən Pailat təmən-ipən kəm pris asol mɨn ne netəmim rafin məmə, “Esehmən nɨpəgnəmtɨn kit ne, itəm tatən məmə suah u təmərəkɨn lou.” ");
INSERT INTO tnn_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Məto ilat kotagət əfəməh moatən məmə, “Kəp. Məto suah u tətan əpnapɨn matəgətun netəmim rafin ikɨn mɨn əh Jutia təmətuoun əpəh Kalili muwa mətoarus-pa ukɨn-u, kən mol nətəlɨgən rəha netəmim koatəlue motalməl.” ");
INSERT INTO tnn_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Kən nian Pailat təməto nəghatən əh, təmətapəh məmə, “?Tahro? ?Suah u in etəm Kalili?” ");
INSERT INTO tnn_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Kən nian təməto məmə Iesu təmiet ikɨn əh itəm Herot Antipas tatərəmərə ikɨn, in təmahl-ipən Iesu məmə otuwɨn mehm Herot, məto-inu e nian əh, Herot mɨn in tətatɨg Jerusalem. ");
INSERT INTO tnn_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Kən nian Herot Antipas təmehm Iesu, nɨkin təmagien pɨk, məto-inu nuwəh məsɨn in təmolkeike məmə otehm. Herot təmatəto əm namnusən rəhan, kən in təmolkeike pɨk məmə in otehm Iesu otol nat pɨspɨs kit. ");
INSERT INTO tnn_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kən o natɨmnat mɨn u, Herot Antipas təmətapəh-in nəghatən mɨn tepət kəm Iesu, məto Iesu təməpnapɨn əm məsuhalpɨnən rəhan nəghatən. ");
INSERT INTO tnn_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kən pris asol mɨn ne iəgətun mɨn rəha Lou kəmotətul motəghat əskasɨk e nɨpəgnəmtɨn mɨn rəhalat moatoh Iesu lan. ");
INSERT INTO tnn_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kən uarisɨg lan, Herot Antipas ne rəhan mɨn mopael kotagət ausit e Iesu, kən moatəsan lan. Kən Herot təmən-ipən kəm rəhan mopael mɨn məmə okotuwɨn-in-pən kot wɨr kit rəha kig kəm in, kən motit motuwɨn mɨn kəm Pailat. ");
INSERT INTO tnn_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Aupən ikɨn, Herot Antipas ne Pailat kəmətioal tɨkɨmɨr kəm ilau mɨn, məto e nian əh, ilau kəmuea mɨnioalkeike ilau mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Kən Pailat təmaun-in pris asol mɨn, ne netəm-iasol rəha netəm Isrel, ne netəmim rafin, kən ilat rafin kəmotuwa kitiəh. ");
INSERT INTO tnn_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Kən in təmən-ipən kəm ilat məmə, “Suah u, nəmotɨləs motuwa tətul e nɨganəmtək, kən nəmotən məmə tatəuhlin nətəlɨgən rəha netəmim rəhatəmat koatol tɨkɨmɨr kəm kapman. Məto emakil rəkɨs nətəlɨgən u e nɨganəmtɨtəmat, kən məsehmən məmə təmətgəhl lou kit, kən nɨpəgnəmtɨn mɨn itəm nakoatən lan təsolən nɨpahrienən. ");
INSERT INTO tnn_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Kən Herot Antipas mɨn, in təmakil mehm məmə nolən rat kit təsəkul-pənən lan. Tol nəhlan, in tahl-ipa tuwa mɨn o kitat, kən təpiə əm məmə suah u in təməsolən nat kit itəm tərat məmə in otɨmɨs ron. ");
INSERT INTO tnn_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Kən o nat əh inəh, rəhak mɨn mopael okotalis əm, kən uarisɨg kotahl-iarəp tatuwɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Məto ilat rafin kəmotagət əfəməh moatən məmə, “!Otɨləs-iarəp suah un kən kohamnu! !Məto ahl-iarəp Parapas tuwa mehm itɨmat!” ");
INSERT INTO tnn_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Suah u Parapas, kəmɨləs-ipən e kalapus məto-inu in təmol netəmim kotəluagɨn o kapman e taon əh, kən in iohamnu itəm.) ");
INSERT INTO tnn_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Məto Pailat in tolkeike məmə otahl-iarəp Iesu tatuwɨn, kən in təməghat mɨn kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Məto ilat kəmotagət əfəməh pɨk məmə, “!Ətu-pər in e nɨg kəluau! !Ətu-pər in e nɨg kəluau!” ");
INSERT INTO tnn_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Məto Pailat təməghat mɨn kəm ilat mɨnətau kɨsɨl lan əh-roiu məmə, “?Tahro? ?Suah u in təmol nat tərat naka? Io esehmən məmə in təmol nat kit itəm tətuatɨp məmə in otɨmɨs ron. Məto rəhak mopael mɨn, ilat okotalis əm, kən uarisɨg lan kotahl-iarəp tatuwɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Məto ilat koatəkəike motəghat əskasɨk, kən motagət əfəməh e Pailat məmə otətu-pər Iesu e nɨg kəluau. Kən motagət pɨk moatuwɨn moatuwɨn, kɨnol win e nətəlɨgən rəha Pailat. ");
INSERT INTO tnn_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kən Pailat təmakil Iesu məmə otəkəike mɨmɨs tahmen-pən məmə inəh ilat kəmotən mihin ne. ");
INSERT INTO tnn_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kən in təmol nətəlɨgən rəhalat, kən təmahl-iarəp Parapas u aupən in təmətatɨg e kalapus o nəluagɨnən o kapman ne nohamnuən itəm. Məto təmegəhan-in Iesu tuwɨn e nelmɨ rəhan mopael mɨn məmə ilat okotos motuwɨn kɨtəp nətəlɨgən rəha nɨmanin netəmim. ");
INSERT INTO tnn_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kən nian mopael mɨn kəmotit Iesu motiet e taon, kən kəmotəplan etəm Saerin kit, nərgɨn u Saimon. In təmɨsɨ-pən isəu maliwək matuwa e taon. Kən kəmotaskəlɨm motələhəu-pər nɨg kəluau rəha Iesu e nuwegɨn məmə otɨləs, kən motən-ipən məmə otətəu-pən Iesu. ");
INSERT INTO tnn_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kən nɨmanin netəmim tepət kəmotaliwək katuarisɨg-in Iesu e suatɨp, kən nɨpɨtan tepət mɨn koatuarisɨg-in ilat, koatasək moatəun-əun o Iesu. ");
INSERT INTO tnn_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Məto Iesu təməuhlin masɨpən məplan ilat, kən mən-ipən kəm ilat məmə, “Nɨpɨtan Jerusalem. Əsotasəkən ron io, məto otasək atɨp otəmat, ne nenətɨtəmat mɨn. ");
INSERT INTO tnn_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Otətəlɨg-in-tu io. Nian tatuwa itəm okəpanən məmə, ‘!Otagien itəmat netəm nəsoteməkən o nəsotapinahinən suakəku!’ ");
INSERT INTO tnn_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","E nian əh, netəmim okotən-ipən kəm nɨtot asol mɨn məmə, ‘Awi, otɨsas-pa etɨmat,’ kən okotən-ipən kəm narɨt mɨn məmə, ‘Awi, otəfətain itɨmat.’ ");
INSERT INTO tnn_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","?Məto okəmə nɨgəm tatuəp nəhlan nian nɨg nɨmalɨn tətamiəmɨtə əh, kən tahro e nian nɨg tɨnəmətu?” ");
INSERT INTO tnn_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kən mopael mɨn kəmotɨləs suah mil kəiu itəm kəmuətgəhl lou kan məmə okotohamnu iləhal Iesu. ");
INSERT INTO tnn_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kən kəmotuwa ikɨn kit, nərgɨn u Louipɨl-uipɨl. Ikɨn əh, kəmotətu-pər Iesu e nɨg kəməluau. Kən kəmotətu-pər iətgəhl lou mil əh-ikɨn, kit e nɨkalɨ Iesu matɨp, kən kit e nɨkalɨn mol. ");
INSERT INTO tnn_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kən Iesu təmə, “Tata. Aluin rəhalat nolən rat mɨn itəm koatol kəm io, kən məsalpɨnən, məto-inu kəsotɨtunən nat naka itəm koatol.” Kən kəmotoor rəhan natɨmnat moaturin taes ron. ");
INSERT INTO tnn_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kən netəm mɨn u koatətul əh-ikɨn, moatehm natɨmnat mɨn u, məto etəm-iasol mɨn rəha noanol rəha Isrel kotalah əsan e Iesu moatən məmə, “!In təmosmegəh netəmim tepət rəkɨs. Məto okəmə in Kristo itəm Uhgɨn təmən məmə otahl-ipa, kən in Etəm Uhgɨn Təmɨtəpun, kən pəs in otosmegəh atɨp in!” ");
INSERT INTO tnn_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Kən mopael mɨn, ilat mɨn koatəghat əsan e Iesu, kən motuwa iuəhkɨr ron moatətapəh məmə in tolkeike wain u itəm tagɨn, ");
INSERT INTO tnn_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","moatən məmə, “!Okəmə nɨpahrienən ik kig rəha noanol mɨn rəha Isrel, osmegəh atɨp ik əh-roiu!” ");
INSERT INTO tnn_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kən nəghatən kit əh-ikɨn kəməte kətu-pər e rəhn-kapə nɨg kəluau, tatən məmə, Inu kig rəha netəm Isrel. ");
INSERT INTO tnn_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kən iətgəhl lou mil kit itəm katəkul-pər e nɨg kəluau, in tatəghat rat e Iesu, matən məmə, “!Ei! ?Ik Kristo itəm Uhgɨn təmən məmə otahl-ipa, o kəp? !Okəmə tol mihin, osmegəh ik kən mosmegəh mɨn itɨmlau!” ");
INSERT INTO tnn_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Məto iətgəhl lou əh kit mɨn təmən-ipən kəm in kit, kən mahtosɨg-in məmə, “?Tahro? ?Nəsəginən Uhgɨn, nat əpnapɨn onakɨmɨs? Nalpɨnən u rəhatəhal in tahmen-ahmen əm. ");
INSERT INTO tnn_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Məto təmətuatɨp əm məmə kilau okiamɨs o rəhalau nolən rat mɨn itəm kəmioal. Məto suah u, in təsolən nat tərat kit ne.” ");
INSERT INTO tnn_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kən təmən-ipən kəm Iesu məmə, “Iesu, o nian onəkuwa matol kig lan, kən nɨkim otatəht io.” ");
INSERT INTO tnn_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Kən Iesu təmən-ipən kəm in məmə, “Nɨpahrienən iatən kəm ik, məmə roiu əm kilau min ik əpəh e nego e neai.” ");
INSERT INTO tnn_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Kən iuəhkɨr tuelef klok e nərauiəgən, mɨt nəsasiəən, kən napinəpən tɨnan rafin ikɨn əh mətoarus-pən tri klok ehnaipən. Kən nɨməhan itəm tatəkulosɨg-in-pən Ikɨn Tasim Agɨn Ikɨn e Nimə Rəha Uhgɨn, təməhap məsɨn kəiu. ");
INSERT INTO tnn_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Kən Iesu təmagət əfəməh məmə, “!Tata. Iatələhəu-pən nəmegəhən rəhak e nelməm!” Nian təmən rəkɨs nəghatən əh u, kən rəhan namegən tiet. ");
INSERT INTO tnn_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kən nian etəm-iasol rəha mopael mɨn rəha netəm Rom təmehm natɨmnat mɨn əh, kən in təmənwiwi Uhgɨn matən məmə, “!Nɨpahrienən, suah u in tətuatɨp pahrien!” ");
INSERT INTO tnn_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kən netəmim itəm kəmotuwa ikɨn əh məmə okotəplan, nian kəmotəplan natɨmnat mɨn əh, kəmoatuwɨn moatəto tərat e nɨkilat, kən motahtaht manɨkɨləhalat. ");
INSERT INTO tnn_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Kən iolɨ Iesu mɨn, ne nɨpɨtan itəm kəmotɨsɨ-pən Kalili motətəu-pən Iesu motuwa, ilat kəmoatətul isəu məsɨn kən moatehm natɨmnat mɨn əh. ");
INSERT INTO tnn_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Kən etəm Aramatia kit əh-ikɨn, nərgɨn u Josep. Aramatia in taon kit rəha Isrel, kən suah əh in etəmim kit rəha kaonsel rəha netəm Isrel. In etəm təwɨr, rəhan nəmegəhən tətuatɨp, kən in etəmim kit təmatəsahgin məmə otəplan nərəmərəən rəha Uhgɨn. Kən in təməsegəhanən e nəghatən rəha kaonsel itəm kəmoategəhan-in Iesu məmə okoh. ");
INSERT INTO tnn_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Kən in təmuwɨn mehm Pailat mətapəh ron məmə otegəhan-in nɨpətɨ Iesu tos. ");
INSERT INTO tnn_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kən Josep təmuwɨn mɨləs-iəhau nɨpətɨ Iesu e nɨg kəməluau, mos muwa malpin e nɨməhan wɨr kit, nərgɨn u linen. Kən təmɨləs muwɨn mələhəu-pən e nɨpəg kəpiel itəm kɨnəməte rəkɨs o nolən suwɨt ikɨn, məto kəsɨtənɨmən əh suah kit ikɨn. ");
INSERT INTO tnn_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","In əh e nian rəha noanol mɨn rəha Isrel itəm koatol əpen-əpenə lan o nian rəha Sapat, kən iuəhkɨr Sapat tətuoun. ");
INSERT INTO tnn_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kən nɨpɨtan itəm kəmotɨsɨ-pən Kalili kəmotuarisɨg-in Iesu, kəmotətəu-pən suah un, motuwɨn motəplan nɨpəg kəpiel, kən motəplan nolən itəm in tatələhəu-pən min Iesu ikɨn. ");
INSERT INTO tnn_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kən uarisɨg, nɨpɨtan kəmotɨtəlɨg-pən latuənu, kən kəmoatol əpen-əpenə manat mɨn neen ne fomat itəm nəmiəwɨlat təwɨr məmə okol-pən e nɨpətɨ Iesu. Kən e nian rəha Sapat, ilat kəmotameg moatətəu-pən nəghatən rəha Lou. ");
INSERT INTO tnn_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kən e Sante laulaugɨn agɨn, nɨpɨtan kəmotuwɨn əpəh e suwɨt, motəmɨk nat pien-pien mɨn u nəmiəwɨlat təwɨr itəm kəmotol əpen-əpenə rəkɨs lan. ");
INSERT INTO tnn_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nian kəmotuwa e suwɨt, kəmotehm kəpiel itəm kətahtosɨg-in nɨpəg kəpiel lan, məto kəmahwin rəkɨs. ");
INSERT INTO tnn_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","E nian kəmotuwɨn e nɨpəg kəpiel, məto kəsotehmən nɨpətɨ Iərəmərə Iesu. ");
INSERT INTO tnn_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kən ilat kɨnotəruru əfəməh moatətəlɨg-in natɨmnat mɨn əh. Kən əmun etəmim kəiu əh-ikɨn, katuətul ilat min nɨpɨtan, kəmian e napən itəm tatɨpɨt-ɨpɨt. ");
INSERT INTO tnn_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kən nɨpɨtan kəmotəgɨn pɨk, kəmotɨsin nulɨlat motasɨl-iəhau moatehm nɨməptən, kən suah mil kuəmə, “?Tahro nakoategəs-in etəm tatəmegəh u ikɨn-u ima netəm kəmotɨmɨs? ");
INSERT INTO tnn_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","In tɨkə ukɨn-u. !In tɨnəmegəh mɨn! Nɨkitəmat otəkəike matəht nəghatən itəm təmən kəm itəmat nian in təmətatɨg əh əpəh Kalili məmə, ");
INSERT INTO tnn_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Natɨmnat mɨn u okotəkəike motuwa motol nɨpahrienən lan. Okegəhan-in-pən Nətɨ Etəmim tuwɨn e nelmɨ iol təfagə rat mɨn, kən okətu-pər e nɨg kəluau tɨmɨs, məto e nian tatol kɨsɨl lan, kən in otəmegəh mɨn.’” ");
INSERT INTO tnn_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kən nɨkilat tɨnəht nəghatən rəha Iesu. ");
INSERT INTO tnn_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kən kəmotiet e suwɨt motuwɨn motən-ipən natɨmnat mɨn əh kəm netəm lefen rəha Iesu, ne rəhan mɨn rafin. ");
INSERT INTO tnn_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Kən nɨpɨtan mɨn əh itəm kəmotən-iarəp natɨmnat mɨn u kəm aposol mɨn, inəh Meri Maktala, Joana, Meri mama rəha Jemes, ne nɨpɨtan neen mɨn itəm kəmotuwɨn e suwɨt. ");
INSERT INTO tnn_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Məto aposol mɨn kəmotəto nəghatən əh tahmen-pən əm e nəghatən alməl kit itəm nɨpətɨn tɨkə, kən məsotənən nɨpahrienən lan. ");
INSERT INTO tnn_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Məto Pita təmətul maiu muwɨn əpəh suwɨt ikɨn, moeg-oeg masɨpən e nɨpəg kəpiel kən təmehm əm napən itəm kəmalpin nɨpətɨ Iesu lan, məto nat kit mɨn tɨkə əh-ikɨn. Kən in təmaliwək mɨtəlɨg mɨnatuwɨn latuənu, kən matətəlɨg-in pɨk natɨmnat mɨn əh. ");
INSERT INTO tnn_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","E nian əm əh inəh, suah mil kəiu rəha Iesu kəmualiwək mətian latuənu kit, nərgɨn u Emeas. Latuənu un mətoarus-pən Jerusalem, in iuəhkɨr o lepen kilometa. ");
INSERT INTO tnn_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kən e nian ilau kəmualiwək mətian, kən ilau kəmatuəghat-in natɨmnat mɨn itəm kəmol ilat. ");
INSERT INTO tnn_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nian ilau kəmatuəghat nəhlan, kən Iesu təmuwa iuəhkɨr olau, məhlaliwək kələh mətəhaluwɨn. ");
INSERT INTO tnn_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Məto kəməsiatunən məmə pah əh iləhal min kəmətəhlaliwək məto-inu Uhgɨn təmahtosɨg-in nətəlɨgən rəhalau. ");
INSERT INTO tnn_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Kən Iesu təmən-ipən kəm ilau məmə, “Təs mil. ?Naka un nakatuən?” Kən əmun kəmuelahl muətul, nɨganəmtɨlau təməpou. ");
INSERT INTO tnn_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kən suah mil əh kit, nərgɨn u Kleopas, təmən-ipən kəm in məmə, “Okəm-naka ik əm un iapɨspɨs kit u Jerusalem itəm nəsɨtunən natɨmnat mɨn itəm kəmol ilat e nian mɨn itəm kɨnotuwɨn rəkɨs.” ");
INSERT INTO tnn_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kən in təmən-ipən kəm ilau məmə, “?Natɨmnat naka mɨn əh?” Kən kəmuən-ipən kəm in məmə, “Natɨmnat mɨn itəm kəmol e etəm Nasaret əh Iesu. In ien kit rəha Uhgɨn, kən rəhan wək təsanən wɨr ne rəhan mɨn nəghatən kotəfɨgəm, kən nɨki Uhgɨn ne nɨki netəmim tətagien lan. ");
INSERT INTO tnn_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Məto rəhatɨmat pris asol mɨn ne iəgətun mɨn rəha Lou kəmotɨləs-ipən e nelmɨ netəm Rom məmə okotakil məmə in otɨmɨs. Kən kəmotətu-pər e nɨg kəluau tɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","“Məto itɨmat emotələhəu-pən pap rəhatɨmat nətəlɨgən tətatɨg əskasɨk lan məmə in otɨləs-irəkɨs itɨmat noanol mɨn rəha Isrel e nelmɨ tɨkɨmɨr mɨn rəhatɨmat. Kən roiu in nian tatol kɨsɨl lan. ");
INSERT INTO tnn_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kən nat kit mɨn, nɨpɨtan neen itəm emotan, kəmotol məmə narmɨtɨmat təmiwɨg o nəghatən kit. Roiu laulaugɨn agɨn-əh, kəmotuwɨn əpəh e suwɨt itəm kəmɨtənɨm Iesu ikɨn, ");
INSERT INTO tnn_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","məto kəməsotehmən nɨpətɨn. Kən kəmotɨtəlɨg-pa moatən məmə, ‘Emotehm nat kit tahmen e napɨlaiirən, inəh nagelo mil kəiu katuən-ipa kəm itɨmat məmə Iesu tatəmegəh.’ ");
INSERT INTO tnn_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kən rəhatɨmat neen netəmim kəmotuwɨn e suwɨt, kəmotehm natɨmnat rafin agɨn tətuatɨp tahmen-pən əm e nəghatən əh nɨpɨtan mɨn əh kəmotən mihin ne, məto kəsotehmən Iesu.” ");
INSERT INTO tnn_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kən in təmən-ipən kəm ilau məmə, “Təs mil. !Rəhatəmlau-kapə tɨkə, kən nakatiaiuw nɨfagə matialəs pɨk o nənən nɨpahrienən o natɨmnat itəm ien mɨn rəha Uhgɨn kəmotən! ");
INSERT INTO tnn_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","?Nəkiatun o kəp məmə, Kristo itəm Uhgɨn təmən məmə otahl-ipa otəkəike mos nahməən e nɨpətɨn, kən uarisɨg lan, in təpanuwɨn əpəh e nego e neai mos nərgɨn rəha nɨsiaiiən?” ");
INSERT INTO tnn_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kən Iesu təmən-ipən wɨr kəm ilau Naoa Rəha Uhgɨn itəm koatəghat-in in, təmətuoun e naoa rəha Moses kən muwɨn mətoarus-pən naoa mɨn rəha ien mɨn rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kən kɨnətəhaluwa iuəhkɨr o latuənu itəm suah mil katian ikɨn. Kən kənuəplan məmə Iesu tɨnətaliwək mɨnatuwɨn məsətulən, ");
INSERT INTO tnn_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","məto ilau kətiauəh nɨkin məmə, “Ei, təwɨr məmə nəkətatɨg kitəhal min ik, məto-inu tɨnapinəp rəkɨs, otəsuwəhən roiu mɨt taht.” Kən təmuwɨn mɨnehm ilau mətəhaləpələh. ");
INSERT INTO tnn_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kən kɨnatəhaləpələh məmə okəhlagwən, kən in təmos pɨret mən tagkiu ron kəm Uhgɨn, kən məmkas mos-ipən kəm ilau. ");
INSERT INTO tnn_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kən əmun Uhgɨn təmol kəniatun məmə in Iesu, kən əmun in təmɨkə mɨn, kən kənəsuəplanən. ");
INSERT INTO tnn_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kən kəmuən-ipən kəm ilau mɨn məmə, “!Ei! ?Nian in təmatən-ipa wɨr Naoa Rəha Uhgɨn kəm kilau e suatɨp, kən katuəto təwɨr lan nɨkilau tətagien pɨk, o kəp?” ");
INSERT INTO tnn_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kən roiu agɨn-əh mɨn, kəmuətul miaiet ikɨn əh miatəlɨg-pən mɨn Jerusalem. Kən ikɨn əh, ilau kəmuehm netəm lepen rəha Iesu ne netəmim neen mɨn rəhan kəmotuwa kuəfɨmɨn rəkɨs ilat mɨn katəpələh, ");
INSERT INTO tnn_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","kən moatən məmə, “!Nɨpahrienən! !Iərəmərə təməmegəh mɨn, kən Saimon Pita təmehm rəkɨs!” ");
INSERT INTO tnn_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kən ilau kəmuən-ipən rafin natɨmnat itəm kəmol kəm ilau e suatɨp, kən muən-ipən nian ilau kəmatiatun Iesu lan e nian itəm in təmatəmkas pɨret matos-ipən kəm ilau. ");
INSERT INTO tnn_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kən nian katuən əh nəghatən mɨn əh, Iesu təmuwa mətul ilugɨn-in ilat matən kəm ilat məmə, “Nəməlinuən tətatɨg otəmat.” ");
INSERT INTO tnn_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Məto ilat kəmotaut lan kən mɨnoatəgin, nɨkilat təht məmə kɨnotəplan narmɨn kit. ");
INSERT INTO tnn_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Məto in təmən-ipən kəm ilat məmə, “?Tahro rəhatəmat nətəlɨgən tatərat nəhlan? ?Tahro rəhatəmat nətəlɨgən tatətul pagpag? ");
INSERT INTO tnn_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Otehm-tu nelmək ne nelkək məmə io əm u. Otea-pa motek nɨpətɨk kən motɨtun məmə io. Narmɨ etəmim nɨpətɨn ne nɨkɨlkɨlin tɨkə, təsolən məmə inu nakoatehm io, nɨpətɨk ne nɨkɨlkɨlik əh-ikɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Təmən nəghatən əh, kən təməgətun nelmɨn ne nelkɨn kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ilat kəsotən wɨrən nɨpahrienən lan məto-inu nɨkilat tətagien pɨk, kən narmɨlat tatiwɨg. Kən in təmən-ipən kəm ilat məmə, “?Nagwənən kit un nakoatos, o?” ");
INSERT INTO tnn_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kən kəmotos nəm məsɨn itəm kəmwaan rəkɨs motos-ipən kəm in, ");
INSERT INTO tnn_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","kən e nɨganəmtɨlat, təmos mun. ");
INSERT INTO tnn_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kən Iesu təmən-ipən kəm ilat məmə, “Aupən ikɨn, nian emətatɨg əh kitat min itəmat, emən nəghatən u kəm itəmat məmə, natɨmnat rafin itəm koatəghat-in io e Naoa Rəha Uhgɨn, okotəkəike motuwa motol nɨpahrienən lan, inəh nəghatən mɨn e naoa rəha Moses, ne naoa mɨn rəha ien mɨn rəha Uhgɨn, ne Naoa Rəha Napuən Mɨn.” ");
INSERT INTO tnn_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kən in təmerəh e rəhalat nətəlɨgən məmə okotɨtun nəghatən mɨn itəm tətatɨg e Naoa Rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kən təmən-ipən kəm ilat məmə, “Nəghatən itəm tətatɨg e Naoa Rəha Uhgɨn tatən məmə netəmim okotol tərat kəm Kristo itəm Uhgɨn təmahl-ipa, motol tatəto nahməən e nɨpətɨn matuwɨn matuwɨn tɨmɨs, məto e nian itəm tatol kɨsɨl lan, in otəmegəh mɨn e nɨmɨsən. ");
INSERT INTO tnn_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kən e nərgɨ Kristo itəm Uhgɨn təmahl-ipa, netəmim okotəkəike motən-iarəp nəghatən əh məmə netəmim okotəkəike motəuhlin kən motɨtəlɨg e rəhalat təfagə rat mɨn, kən Uhgɨn in otəsalpɨnən nɨtai təfagə, kən maluin rəhalat nolən rat mɨn. Nəghatən u otəkəike muwɨn kəm noanol mɨn rafin əpəh ikɨn mɨn rafin, otətuoun Jerusalem kən muwɨn mətoahgin-pən ikɨn mɨn rafin e nətueintən. ");
INSERT INTO tnn_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Itəmat nəmotehm natɨmnat mɨn u, kən onəkotən-iarəp ətuatɨp nəghatən mɨn lan. ");
INSERT INTO tnn_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kən ekahl-ipa suah u itəm rəhak Tata təmən-iəkɨs məmə in otahl-ipa kəm itəmat, inu rəhan Narmɨn. Məto onakoatəsahgin e taon əh mətoahgin-pən nakotos nəsanənən rəha Narmɨn Rəha Uhgɨn, kən tərioah e nəmegəhən rəhatəmat.” ");
INSERT INTO tnn_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kən Iesu təmit ilat motiet e taon motuwɨn əh latuənu Petani. Kən təmɨləs-ipər nelmɨn məfak olat. ");
INSERT INTO tnn_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kən nian təmatəfak olat, kən təmapəs ilat nian Uhgɨn təmɨləs mɨnatuwɨn əpəh ilɨs e nego e neai. ");
INSERT INTO tnn_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kən kəmoteiuaiu motəfak-pən kəm in, kən uarisɨg lan, kotɨtəlɨg-pən Jerusalem nɨkilat tətagien. ");
INSERT INTO tnn_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kən nian rafin, koatuwɨn e Nimə Rəha Uhgɨn moatənwiwi Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Aupən agɨn, e nətuounən nian, Nəghatən tɨnatɨg rəkɨs. Nəghatən u təmətatɨg ilau Uhgɨn, kən Nəghatən u, in Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","E nəukətɨ nian, in tɨnəmatɨg rəkɨs ilau Uhgɨn, ");
INSERT INTO tnn_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","kən Uhgɨn təmol natɨmnat rafin e Nəghatən u, kən natɨmnat rafin itəm Uhgɨn təmol, nat kitiəh ne tɨkə məmə Nəghatən u təsolən. ");
INSERT INTO tnn_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Inu, in Nəukətɨ Nəmegəhən, kən Nəmegəhən u, in Nəhag-əhagən rəha netəmim rafin. ");
INSERT INTO tnn_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nəhag-əhagən əh, tətasiəgəpɨn napinəpən, kən napinəpən okol təsaprəkɨs-inən. ");
INSERT INTO tnn_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Etəmim kit itəm Uhgɨn təmahl-ipa tuwa, nərgɨn u, Jon. ");
INSERT INTO tnn_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Təmətul-arəp məmə otamnus-iarəp Nəhag-əhagən əh kəm netəmim, pəs ilat rafin kotən nɨpahrienən lan. ");
INSERT INTO tnn_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Sənəmə Jon in Nəhag-əhagən əh, məto in təmuwa əm məmə otətul-arəp mən-iarəp Nəhag-əhagən əh kəm netəmim rafin. ");
INSERT INTO tnn_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nəghatən əh təmatuwa e nətueintən, kən in Nəhag-əhagən pahrien, itəm in tətasiəgəpɨn netəmim rafin. ");
INSERT INTO tnn_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nat əpnapɨn məmə Uhgɨn təmol nətueintən u e Nəghatən əh, kən təmətatɨg e nətueintən u, məto netəmim rəha nətueintən kotəruru in. ");
INSERT INTO tnn_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Təmuwa iman ikɨn, məto natiman mɨn koatəuhlin məntaalat kəm in, məsotolkeikeən. ");
INSERT INTO tnn_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Məto netəmim rafin itəm kəmotos in nɨkilat tagien ron, kən motahatətə e nərgɨn, kən in təmegəhan-in ilat koatuwa nenətɨ Uhgɨn mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nenətɨ Uhgɨn mɨn əh, ilat kəsotaiirən e nolən itəm nɨsualkələh kotaiir mihin, kən sənəmə e nətəlɨgən rəha etəmim, o rəha tata mɨn, məto ilat kotaiir wi mɨn e Uhgɨn, e rəhan nəsanənən əm. ");
INSERT INTO tnn_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nəghatən əh, in təmuwa etəmim, mətatɨg kitat min. Kən itɨmat emotəplan rəhan nepətən, kən nəsanənən asol ne nəhag-əhagən rəhan e nɨganəmtɨtɨmat. Inu, in nəsanənən asol ne nəhag-əhagən rəha Noan Kitiəh Əm, itəm in təmɨsɨ-pən e Tata Uhgɨn. In tərioah e nəwɨrən itəm tətawte-in kəm kitat, kən mərioah mɨn e nɨpahrienən. ");
INSERT INTO tnn_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon tatətul-arəp matən əfəməh məmə, “Etəmim u inu itəm io ematən məmə, ‘Io etaupən, kən suah kit mɨn əh-ikɨn tatuarisɨg-in io, məto in ilɨs taprəkɨs-in io, məto-inun, nian eməsaiirən əh, in tɨnəmatɨg lilɨn rəkɨs.’” ");
INSERT INTO tnn_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kən in tərioah e nəwɨrən itəm in tətawte-in kəm kitat, kən e nəwɨrən əh rəhan, nian rafin in tatos-ipa, matos-ipa, matos-ipa, kəm kitat rafin. ");
INSERT INTO tnn_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tol nəhlan məto-inu Lou itəm Uhgɨn təmos-ipa aupən, Moses in suatɨp ron, məto Iesu Kristo in suatɨp rəha nawte-inən nəwɨrən əh ne nɨpahrienən rəha Uhgɨn kəm kitat. ");
INSERT INTO tnn_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Suah kit təsehmən Uhgɨn nian kit ne. Məto Noan Kitiəh Əm, in Uhgɨn, itəm in iuəhkɨr o noanenau rəha Tata Uhgɨn, in təmol əp Uhgɨn kəm kitat kən kotɨtun. ");
INSERT INTO tnn_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Kən netəm-iasol mɨn e noanol rəha Isrel itəm kotatɨg Jerusalem, kəmotahl-ipən pris mɨn neen ne Lifaet mɨn un, netəm kotasitu e pris mɨn e Nimə Rəha Uhgɨn, məmə okotuwa motehm Jon motətapəh ron, məmə, “?Ik etəmim pah un?” Kən o nat u, Jon təmətul-arəp matən-iarəp in. ");
INSERT INTO tnn_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nian ilat kəmotətapəh ron, in təməsəhluaig-inən, məto təmən-ipən ətuatɨp əm in kəm ilat məmə, “Sənəmə io Kristo itəm Uhgɨn təmən məmə otahl-ipa.” ");
INSERT INTO tnn_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Kən ilat kəmotən məmə, “?Okəmə sənəmə ik Kristo, kən ik pah? ?Ik Elaija?” Məto Jon təmə, “Kəpə, sənəmə io Elaija.” Kən ilat kəmotətapəh mɨn ron məmə, “?Okəmə sənəmə ik Elaija, kən ik pah? ?Ik ien rəha Uhgɨn itəm kəmatən aupən məmə otəpanuwa?” Məto Jon təmə, “Kəpə.” ");
INSERT INTO tnn_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kən ilat kəmotən məmə, “Ik onəkəike mən-iarəp ik kəm itɨmat, pəs itɨmat ekotuwɨn motən-ipən kəm netəm kəmotahl-ipa itɨmat ekotuwa.” ");
INSERT INTO tnn_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Kən tən-ipən kəm ilat məmə, “Io u itəm ien rəha Uhgɨn Aesea tɨnəmən-iarəp rəkɨs aupən məmə, ‘Suah kit tətagət əfəməh əpəh ikɨn taruən-aruən ikɨn, matən məmə, Otol-wɨr suatɨp rəha Iərəmərə.’” ");
INSERT INTO tnn_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nətəmim itəm kəmahl-ipa ilat, Farisi mɨn neen əh-ikɨn, ");
INSERT INTO tnn_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","kən ilat kəmotətapəh mɨn o Jon məmə, “?Okəmə sənəmə ik Kristo itəm Uhgɨn təmən məmə otahl-ipa, kən sənəmə ik Elaija, kən sənəmə ik ien itəm kəmatən-iarəp aupən, kən təhrol nakatol baptais e netəmim?” ");
INSERT INTO tnn_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Kən tuhalpɨn matən məmə, “Io iatol baptais e netəmim e nəhau, məto suah kit u ikɨn ilugɨn etəmat, itəm itəmat nəkotəruru in. ");
INSERT INTO tnn_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Io etaupən, suah un in tatuarisɨg, məto in ilɨs, kən io ləhau ləhau əm, kən esahmen agɨn-əhən məmə ekol wək kit rəhan.” ");
INSERT INTO tnn_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Natɨmnat mɨn u, kəmol əpəh e latuənu kit, nərgɨn u Petani, in tətatɨg əpəh entənɨpən e nəhau Jotan. Ikɨn əh Jon tatol baptais e netəmim ikɨn. ");
INSERT INTO tnn_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kəmən lawɨgin, Jon təməplan Iesu taliwək matuwa, kən in tən məmə, “!Ei! !Otəplan-tu! Suah u inu, in Nətɨ Sipsip rəha Uhgɨn. Kən in otəpanos-irəkɨs nolən rat mɨn rəha nətueintən u. ");
INSERT INTO tnn_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Etəmim u inu, io ematən kəm itəmat məmə, ‘Io etaupən, kən suah kit mɨn əh-ikɨn tatuarisɨg-in io, məto in ilɨs taprəkɨs-in io, məto-inu nian eməsaiirən əh, in tɨnəmatɨg lilɨn rəkɨs.’ ");
INSERT INTO tnn_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nian io ematəghat-in, kən io mɨn eməruru məmə in etəmim pah; məto emuwa matol baptais e netəmim e nəhau məmə ekol əp suah u kəm noanol mɨn rəha Isrel.” ");
INSERT INTO tnn_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Jon təmatətul-arəp matən məmə, “Uhgɨn təmahl-ipa io məmə io ekol baptais e netəmim e nəhau, kən nian ematəghat-in, io mɨn eməruru məmə suah u inu. Məto Uhgɨn təmən-ipa kəm io məmə, ‘Onəkəplan Narmɨn Rəhak oteiuaiu matɨg e etəmim kit. Kənu suah u inun, in otol baptais e netəmim e Narmɨn Rəha Uhgɨn.’ Kən əmun, uarisɨg eməplan Narmɨn Rəha Uhgɨn təmɨsɨ-pər e neai tahmen e mak, muwa, meiuaiu məpələh-pər lan. ");
INSERT INTO tnn_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Io ətuatɨp eməplan nat u, kən ematətul-arəp matən-iarəp məmə, ‘Suah u inu, in Nətɨ Uhgɨn pahrien.’” ");
INSERT INTO tnn_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kəmən lawɨgin, Jon tətatɨg əpəh ikɨn kitiəh əm iləhal rəhan kəiu etəmim. ");
INSERT INTO tnn_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kən nian nɨganəmtɨ Jon təmətul e Iesu taliwək matuwa kən təmə, “!Ei! !Otəplan-tu! !Suah u inu, in Nətɨ Sipsip rəha Uhgɨn!” ");
INSERT INTO tnn_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kən nian rəhan etəmim mil kəmuəto nəghatən əh, kəmuətul matiauarisɨg-in Iesu. ");
INSERT INTO tnn_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Kən Iesu teirair məplan suah mil un katuətəu-pən-in, kən in təmə, “!Ei! !Suah mil! ?Natuegəs-in naka?” Kən ilau kuəmə, “Rapai. ?Ik nətatɨg hiə?” (Nəghatən u “Rapai,” nɨpətɨn u “Iəgətun.”) ");
INSERT INTO tnn_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Kən Iesu təmən-ipən məmə, “Pəs kəhaluwɨn nakuəplan-tu.” Kən ilau kəmiauarisɨg-in məhaluwɨn kuəplan ikɨn in tətatɨg ikɨn. Iuəhkɨr mɨtgar tiwɨg ehnaipən, ilau kəmətuan iləhal min mətoarus tapinəp. ");
INSERT INTO tnn_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Suah mil u kit itəm təməto Jon, nərgɨn u Antru, pian u Saimon Pita. ");
INSERT INTO tnn_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kən roiu agɨn-əh mɨn, in təmuwɨn mehm pian Saimon mit muwa, kən mən-ipən kəm in məmə, “!Ei! !Enotəplan rəkɨs Mesaea!” (Nəghatən u, Mesaea, nɨpətɨn u məmə, “Kristo,” itəm Uhgɨn təmən məmə otahl-ipa.) ");
INSERT INTO tnn_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Kən təmit Saimon muwa o Iesu. Kən nian nɨganəmtɨ Iesu təmətul lan, kən mən-ipən kəm in məmə, “Ik u inu Saimon, nətɨ Jon, məto roiu okaun-in ətəgtəg ik məmə ‘Kefas.’” (In “Pita” e nəghatən Kris). ");
INSERT INTO tnn_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kəmən lawɨgin mɨn, Iesu nɨkin tɨnəht məmə otuwɨn-tu Kalili. Kən nian in təməplan Filip, kən tən-ipən kəm in məmə, “Wa-tu, mətəu-pa io.” ");
INSERT INTO tnn_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip u, in etəm Petsaeta, ima Antru ne Pita. ");
INSERT INTO tnn_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Kən in təmehm Nataniel, kən tən-ipən kəm in məmə, “Itɨmat enotəplan suah ilouin, aupən Moses təməte rəkɨs rəhan nəghatən mɨn itəm tatəghat-in e naoa rəha Lou. Kən ien mɨn rəha Uhgɨn aupən ilat mɨn kəmotəte rəkɨs nəghatən mɨn itəm tatəghat-in. In etəm Nasaret, in nətɨ Josep, kən nərgɨn u, Iesu.” ");
INSERT INTO tnn_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Məto Nataniel təmə, “?Naka lan? ?Nɨkim təht məmə nat wɨr kit otɨsɨ-pən e Nasaret? !Kəp!” Kən Filip təmə, “Ita, təwɨr əm, pəs-tu kian nakəplan-tu.” ");
INSERT INTO tnn_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nian Iesu təməplan Nataniel taliwək matuwa, kən təmə, “!Suah u, in noanol ətuatɨp rəha Isrel! !Neiueiuəən tɨkə lan!” ");
INSERT INTO tnn_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Kən əmun Nataniel tətapəh o Iesu məmə, “?Nəmahro mɨtun məmə io etəm tol nulan?” Kən Iesu tən-ipən kəm in məmə, “Nian ik nəmatəpələh e nəukət nɨg fik, kən Filip təsaun-inən əh ik, məto io enəməplan rəkɨs ik.” ");
INSERT INTO tnn_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Kən Nataniel təmə, “!Iəgətun! !Ik Nətɨ Uhgɨn! !Ik Kig rəha noanol mɨn rəha Isrel!” ");
INSERT INTO tnn_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Iesu təmən-ipən kəm in məmə, “?Ik nəmatahatətə lak məto-inu io emən əm məmə enəməplan rəkɨs ik, nian nəmatəpələh-pən əh e nəukətɨ nɨg fik? Ik onəpanəplan nat asol mɨn taprəkɨs-in itəm u.” ");
INSERT INTO tnn_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Kən mən mɨn məmə, “Nɨpahrienən agɨn u iatən-ipɨnə kəm itəmat məmə, onəpanotəplan napuə oterəh, kən nagelo mɨn rəha Uhgɨn koatər moatuwɨn e neai, kən moteiuaiu moatuwa o Nətɨ Etəmim.” ");
INSERT INTO tnn_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kəmən niəh in, katol marɨt kit əpəh Kena, latuənu kit e Kalili. Kən mama rəha Iesu in əpəh ikɨn ilat min. ");
INSERT INTO tnn_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Kən ilat kotaun-in-pən mɨn Iesu ne rəhan mɨn netəmim, məmə ilat mɨn okotuwɨn e marɨt əh. ");
INSERT INTO tnn_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Kən e nian əh, kəmotənɨm rafin wain, kən mama rəha Iesu tən-ipən kəm in məmə, “Rəhalat wain təmɨkə.” ");
INSERT INTO tnn_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Məto Iesu tən-ipən kəm in məmə, “?Pətan, təhrol nakatələhəu-pa nat u kəm io? Nian rəhak təsuwamən əh.” ");
INSERT INTO tnn_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Məto rəhan mama tən-ipən kəm iolwək mɨn rəha marɨt məmə, “Itəmat onəkotəkəike motol natɨmnat rafin itəm in otən.” ");
INSERT INTO tnn_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nuwigɨ nat asol ilat sikis, kəməlɨn əh-ikɨn əh o nəhau, məmə netəm Isrel ilat kotəike motaikuas e nelmɨlat məmə ilat okotaruətuəh e nɨganəmtɨ Uhgɨn. Nuwigɨ nat mɨn un, kəmol e kəpiel, kən okəmə naka kitiəh tɨtun nosən wan-hanrɨt lita nəhau. ");
INSERT INTO tnn_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Kən Iesu tən-ipən kəm netəm koatol wək məmə, “Otətu-pən nəhau e nuwigɨ nat mɨn un.” Kən kəmotətu ilat kotərioah wɨr. ");
INSERT INTO tnn_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kən tən-ipən kəm ilat məmə, “Otətu rəkɨs nəhau neen motos motuwɨn kəm etəm tərəmərə e marɨt.” Kən ilat kəmotol mihin. ");
INSERT INTO tnn_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kən nian suah un təmənɨm asgəwɨn, məto nəhau tɨnol rəkɨs wain lan. Məto etəmim itəm tərəmərə e marɨt u, in təruru məmə kəmos hiə wain u. Netəm mɨn əm un itəm kəmotos nəhau motuwa, ilat əm kotɨtun. Kən etəm tərəmərə e marɨt təmaun-in etəm təmol marɨt, ");
INSERT INTO tnn_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","mən-ipən məmə, “Nian rafin netəmim kotaupən motos-iarəp wain wɨr, kən uarisɨg netəmim kotənɨm tepət un, kənu kəpanos-iarəp itəm u təsəwɨr pɨkən. Məto ik natos əh itəm təwɨr muwa mətoarus-pa u-roiu.” ");
INSERT INTO tnn_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kən inu nəmtətin itəm Iesu təmətuoun agɨn-əh lan mol. Kən in təmol ikɨn Kena, latuənu kit e Kalili. Nəmtətin əh, in təməgətun nepətən rəha Uhgɨn lan, kən rəhan netəmim mɨn, kəmotahatətə əskasɨk lan. ");
INSERT INTO tnn_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Uarisɨg e marɨt əh, in təmeiuaiu muwɨn e taon əh Kapaneam ilat rəhan mama ne pian mɨn ne rəhan netəmim mɨn. Kən kəmotatɨg nian əkuəkɨr əm əh-ikɨn əh. ");
INSERT INTO tnn_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Kən tɨnuwa iuəhkɨr o nian rəha lafet kit rəha noanol mɨn rəha Isrel itəm katən məmə lafet rəha Nuhagego-inən. Kən Iesu təmər muwɨn əpəh Jerusalem. ");
INSERT INTO tnn_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","E Nimə Rəha Uhgɨn, Iesu təməplan netəmim itəm koatos məni e kau, ne sipsip, ne iouen, məmə netəmim okotos-nəmtɨn. Kən netəmim neen əh-ikɨn, ilat koatol senɨs e məni rəha netəm ik pɨsɨn pɨsɨn mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kən in tos təulə neen, mətəl o nalis-alisən itəm. Kən in mɨtəp netəm mɨn un ilat rəhalat kau mɨn ne sipsip mɨn məmə okotiet e Nimə Rəha Uhgɨn. Kən in təməhtəg məni rəha netəm mɨn u itəm koatol senɨs lan, kən təmahwin-ahwin rəhalat tepɨl mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kən məhai ilat mɨn u itəm koatol-salɨm-in iouen mən-ipən məmə, “!Otəmɨk nat mɨn un motiet! !Itəmat sotolən Nimə Rəha Tata rəhak tuwa in nimə kit rəha nolən makɨt!” ");
INSERT INTO tnn_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Kən netəmim rəhan, nɨkilat tuəh nəghatən kit e Naoa Rəha Uhgɨn, itəm tatən məmə, “Io ekolkeike pɨk Nimə Rəham e nɨkik, nɨkik tatɨmɨs-pən lan.” ");
INSERT INTO tnn_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Kən netəm-iasol mɨn rəha netəm Isrel kotətapəh ron məmə, “?Pah təmol məmə nəkɨtun nolən nat u? !Ol nəmtətin məmə otəgətun ətuatɨp kəm itɨmat!” ");
INSERT INTO tnn_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Məto Iesu təmə, “Okəmə itəmat nakotərəkɨn Nimə u Rəha Uhgɨn, kən nian kɨsɨl əm, io ekiləkɨn mɨn tətul.” ");
INSERT INTO tnn_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Kən netəm-iasol mɨn un kotəmə, “!Ei, nəman! Netəmim kəmotol wək pɨk e nup ilat rafin foti-sikis motiləkɨn Nimə u Rəha Uhgɨn. ?Onakahrol nulan miləkɨn e nian kɨsɨl əm?” ");
INSERT INTO tnn_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Məto Nimə əh Rəha Uhgɨn itəm Iesu tatəghat-in, in nɨpətɨn. ");
INSERT INTO tnn_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kən uarisɨg, nian in tɨnɨmɨs rəkɨs, kən mɨnəmegəh mɨn, kən rəhan netəmim mɨn, nɨkilat tuəh nəghatən əh rəhan itəm təmən. Kən ilat kəmotahatətə e Naoa Rəha Uhgɨn, ne nəghatən itəm Iesu təmatən-ipən kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nian əh Iesu təmətatɨg e Jerusalem e nian rəha lafet rəha Nuhagego-inən, netəmim tepət kəmotəplan nəmtətin mɨn itəm in təmol, kən kəmotahatətə e nərgɨn. ");
INSERT INTO tnn_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Məto Iesu in təmɨtun nat itəm tətatɨg e nɨkilat, kən məsatahatətəən elat. ");
INSERT INTO tnn_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Okol suah kit təsətul-arəpən məghat rəha netəmim lan, məto-inu Iesu tɨtun rafin nətəlɨgən rəha netəmim. ");
INSERT INTO tnn_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Etəm-iasol kit e noanol rəha Isrel, nərgɨn u, Nikotimas. In Farisi kit. ");
INSERT INTO tnn_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Kən nian kit lapɨn, in təmuwɨn məmə otəghat ilau Iesu. In təmən-ipən məmə, “Iəgətun, itɨmat ekotɨtun məmə ik iəgətun kit itəm Uhgɨn təmahl-ipa ik nakuwa, məto-inu suah kit okol təsolən nəmtətin mɨn un ik nakatol okəmə Uhgɨn təsatɨgən ron.” ");
INSERT INTO tnn_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Kən Iesu tən-ipən kəm in məmə, “Nɨpahrienən agɨn u iatən-ipɨnə kəm ik məmə, okəmə etəmim kit təsaiir wiən, okol in təsəplanən nərəmərəən rəha Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Kən Nikotimas, narmɨn təmiwɨg pɨk, kən mətapəh ron məmə, “?Etəm tɨnol iahgin rəkɨs, otəhrol maiir mətmətɨg mɨn? !In okol təsuwɨn mɨnən e nərpɨ rəhan mama kən maiir-pa mɨn!” ");
INSERT INTO tnn_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Kən Iesu tən-ipən kəm in məmə, “Nɨpahrienən agɨn u iatən-ipɨnə kəm ik məmə, okəmə etəmim təsaiir-wiən e nəhau ne Narmɨn Rəha Uhgɨn, okol təsuwɨnən matɨg ahgin nərəmərəən rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nɨpətɨtəm tətaiir əm e nɨta rəha etəmim əm, məto Narmɨn Rəha Uhgɨn əm un in tatol məmə narmɨtəm tətaiir wi mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Təsəwɨrən məmə narməm otiwɨg məto-inu emən-ipɨnə kəm ik məmə, ‘Onəkotəkəike motaiir wi mɨn.’ ");
INSERT INTO tnn_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tahmen əm e nɨmətag tatɨsɨ-pə ikɨn kit, matelel nat matuwɨn ikɨn kit itəm in tolkeike məmə otuwɨn-pən ikɨn. Natəto əm, məto ik nəkəruru məmə təmɨsɨ-pə hiə, kən matuwə hiə. Kən e suatɨp kitiəh əm, kitat kəsotəplanən Narmɨn Rəha Uhgɨn, məto koatəplan əm rəhan wək e nəmegəhən rəha etəmim itəm təmaiir wi mɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Kən əmun, Nikotimas tətapəh o Iesu məmə, “?Natɨmnat mɨn un, otəhrol nulan muwa?” ");
INSERT INTO tnn_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Kən Iesu təmə, “Ik iəgətun asol rəha netəm Isrel. ?Təhrol nəkəruru natɨmnat mɨn u?” ");
INSERT INTO tnn_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nɨpahrienən agɨn u iatən-ipɨnə kəm ik məmə, nəghatən mɨn u itəm ekoatən ilat, itɨmat ekotɨtun wɨr, kən natɨmnat itəm ioatən-iarəp, itɨmat enotəplan rəkɨs. Məto itəmat nəsotahatətəən e nəghatən mɨn rəhatɨmat. ");
INSERT INTO tnn_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Io iatən əm natɨmnat mɨn itəm katol e nətueintən əm u, məto itəmat nəsotahatətəən e rəhak nəghatən. ?Kən okəmə ekən natɨmnat mɨn itəm katol e Nego e Neai, nakotəhrol nulan motahatətə lan? ");
INSERT INTO tnn_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Suah kit təsuwɨnən əpəh ilɨs e Nego e Neai, meiuaiu-pa, mən-iarəp nian kit ne. Məto Nətɨ Etəmim əm, təmɨsɨ-pən iman ikɨn e Nego e Neai, meiuaiu-pa, tɨtun nən-iarəpən. ");
INSERT INTO tnn_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Aupən, əpəh ikɨn taruən-aruən ikɨn, Moses təmɨləs narmɨ sɨnek kit, mətu-pər ilɨs e nɨg əfəməh kit, kən mɨləs-ipər. Kən e nolən kitiəh əm, okəike kɨləs-ipər mihin Nətɨ Etəmim, ");
INSERT INTO tnn_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","məmə netəm mɨn u itəm okotahatətə lan, ilat okotos nəmegəhən itulɨn. ");
INSERT INTO tnn_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Tol nəhlan, Uhgɨn təmolkeike pɨk netəmim e nətueintən, tol-pən in təmos-ipa Nətɨn Noan Kitiəh Əm, məmə netəm mɨn u itəm koatahatətə lan, ilat okol kəsotɨmɨsən, məto okotos nəmegəhən itulɨn. ");
INSERT INTO tnn_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Uhgɨn in təməsahl-ipamən Nətɨn tuwa e nətueintən u məmə otən-iarəp nalpɨnən rəha nolən rəha netəmim rəha nətueintən, məto in təmahl-ipa, məmə otuwa mol suatɨp o nosmegəhən netəmim e nətueintən. ");
INSERT INTO tnn_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Etəmim itəm tətahatətə lan, Uhgɨn okol təsənən nalpɨnən rəhan, məto etəmim itəm təsahatətəən lan, Uhgɨn tɨnən rəkɨs nalpɨnən rəhan, məto-inu in təsahatətəən e Nətɨ Uhgɨn Noan Kitiəh Əm. ");
INSERT INTO tnn_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Uhgɨn tətakil netəmim e nolən u məmə, Nəhag-əhagən tɨnuwa rəkɨs e nətueintən, məto netəmim kəsotolkeikeən Nəhag-əhagən. Ilat kəmoatolkeike Napinəpən ilə, məto-inu nian rafin rəhalat nolən, təsətuatɨpən. ");
INSERT INTO tnn_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Etəmim itəm tatol nolən itəm təsətuatɨpən, in tetəhau Nəhag-əhagən. Kən in təsuwamən e Nəhag-əhagən, məto-inu in tapəs məmə Nəhag-əhagən əh otasiəgəpɨn rəhan nolən mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Məto etəmim itəm tatətəu-pən suatɨp rəha nɨpahrienən in otuwa e Nəhag-əhagən, məmə Nəhag-əhagən əh, in otasiəgəpɨn rəhan nolən kən matəgətun məmə in təmol ilat e nəsanənən əm rəha Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Uarisɨg e natɨmnat mɨn əh, Iesu ne rəhan mɨn netəmim kəmotuwɨn e nɨtən Jutia. Təmatɨg nuwəh məsɨn ilat min ikɨn əh, kən matol baptais e netəmim. ");
INSERT INTO tnn_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Məto e nian əh, Jon mɨn, in tatol baptais e netəmim əpəh ikɨn kit iuəhkɨr əm o Salim, nərgɨn u, Aenon, məto-inu, ikɨn əh, nəhau tepət ikɨn. Kən netəmim koatuwɨn ikɨn əh, məmə Jon otol baptais elat. ");
INSERT INTO tnn_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","E nian əh, kəməsɨləs-ipənən əh Jon e kalapus. ");
INSERT INTO tnn_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kən netəmim neen rəha Jon, ilat kəmotərgəhəu ilat etəm Isrel kit, o nolən ətuatɨp itəm etəmim otəkəike maikuas məmə in otaruətuəh e nɨganəmtɨ Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kən ilat kəmotuwɨn kehm Jon, motən-ipən kəm in məmə, “Iəgətun, ik nəkɨtun etəmim kit u aupən itəlau min əpəh entənɨpən-pən ikɨn e nəhau Jotan, kən ik nəmətul-arəp matəghat-in kəm netəmim. Roiu əh, in tɨnatol baptais e netəmim. Kən ilat rafin kɨnoatuwɨn ron.” ");
INSERT INTO tnn_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Kən Jon tən-ipən məmə, “Etəmim təruru nolən nat kitiəh ne, okəmə Uhgɨn əpəh e Nego e Neai təsos-ipənən wək əh kəm in. ");
INSERT INTO tnn_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Itəmat u noatətul-pa ron io. Itəmat nəkotɨtun məmə iatən nulan məmə, ‘Sənəmə io Kristo itəm Uhgɨn təmən məmə otahl-ipa.’ Məto Uhgɨn təmahl-ipa io məmə iakaupən muwa, kən Kristo in otəpanuarisɨg. ");
INSERT INTO tnn_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ekuəh nimaa nəghatən kit kəm itəmat. Etəmim itəm in otol marɨt e pətan kit, pətan əh tatətəu-pən əm in. Kən etəmim u, netəmim koatəsahgin məmə in otuwa e lafet rəha marɨt, kən nɨkilat kotagien lan kən motəto nəwian, ilat kəsotetetən in. Kən io u, ekahmen e in kit itəm tatəsahgin əm matətəlɨg-in o nətoən nəwian, kən io mɨn esetəhakən kəm in o netəmim itəm koatuarisɨg-in, məto nɨkik tagien mərioah ron. ");
INSERT INTO tnn_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kristo əh, in otəkəike muwa mə in ilɨs taprəkɨs-in io, kənu io ekəike meiuaiu.” ");
INSERT INTO tnn_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Etəmim itəm təmɨsɨ-pən ilɨs e Nego e Neai, in ilɨs taprəkɨs-in netəmim rafin. Etəmim itəm tətan əm e nətueintən, in etəmim əm rəha nətueintən, kən in tɨtun əm nənən natɨmnat mɨn u e nətueintən u. Məto, etəmim itəm tatɨsɨ-pən ilɨs e neai in ilɨs taprəkɨs netəmim rafin. ");
INSERT INTO tnn_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","In tatətul-arəp o nən-iarəpən natɨmnat itəm in təməplan kən mɨnəto rəkɨs, məto etəmim kit ne təsahatətəən e rəhan nəghatən. ");
INSERT INTO tnn_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Məto etəmim itəm təmos rəhan nəghatən kən mətahatətə lan, in tatətul-arəp məmə nəghatən itəm Uhgɨn təmən, in nɨpahrienən. ");
INSERT INTO tnn_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tol nəhlan məto-inu etəmim əh itəm Uhgɨn təmahl-ipa tuwa, in tatən-iarəp əm nəghatən mɨn rəha Uhgɨn. Kotɨtun məmə in tatən-iarəp əm nəghatən mɨn rəha Uhgɨn məto-inu Uhgɨn təmos-ipən Narmɨn Rəhan tərioah lan, okol kəsolən mak lan kəsehmən namnun. ");
INSERT INTO tnn_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Əwəh, Tata Uhgɨn in tolkeike pɨk Nətɨn əh, kən in tɨnələhəu-pən rəkɨs natɨmnat rafin e nelmɨn. ");
INSERT INTO tnn_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Etəmim u itəm tətahatətə e Nətɨ Uhgɨn u, in tatos nəmegəhən itulɨn u, namnun tɨkə. Kən məto, etəm tatəht nəwia Nətɨn u, in okol təsosən nəmegəhən itulɨn u nian kit ne, məto-inu etəmim itəm tol nəhlan, neməha rəha Uhgɨn tatuwɨn ron namnun tɨkə. ");
INSERT INTO tnn_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisi mɨn kəmotəto nəghatən, məmə Iesu in tɨnatiuw-pa netəmim tepət kɨnotuwa ron, kən in tatol baptais elat tepət. Rəhalat nampa taprəkɨs-in nampa rəha netəmim rəha Jon. ");
INSERT INTO tnn_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Məto nɨpahrienən sənəmə Iesu in tatol baptais elat, netəmim mɨn əm rəhan ilat kotol baptais e netəmim.) ");
INSERT INTO tnn_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Kən nian Iesu tɨnɨtun məmə Farisi mɨn kɨnotəto nəghatən əh, kən in təmiet e Jutia mɨtəlɨg-pən əpəh Kalili. ");
INSERT INTO tnn_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Kən nian in təmatuwɨn ikɨn əh, təmən mə otəkəike muwɨn-pən Sameria ikɨn. ");
INSERT INTO tnn_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Kən in təmuwɨn-pən e taon kit e Sameria, nərgɨn un, Saeka. Taon əh, in iuəhkɨr o nɨməptən kit itəm aupən Jekop in təmətatɨpən kəm nətɨn u Josep. ");
INSERT INTO tnn_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Kən wel rəha Jekop əh-ikɨn. Kən Iesu tɨnəpou agɨn, məto-inu in təmaliwək e suatɨp əfəməh, kən tuwa məpələh-pər iuəhkɨr o wel, mɨtameg. E nian əh, in tɨnol tina. ");
INSERT INTO tnn_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Kən rəhan netəmim mɨn kəmotuwɨn əpəh e taon, məmə okotos-nəmtɨn nagwənən. Kən pətan Sameria kit, təmuwa məmə otətu nəhau. Kən Iesu tən-ipən kəm in məmə, “Eh. Os-ipa-tu nəhau noan məsɨn kəm io. Ekolkeike məmə ekənɨm.” ");
INSERT INTO tnn_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kən pətan Sameria u, tən-ipən kəm in məmə, “!Ei! Ik etəm Isrel un, kən io pətan Sameria. ?Təhrol nakatətapəh-in-pa nəhau kəm io?” Təmən-ipən nəhlan məto-inun etəm Jutia ne etəm Sameria kəsuənɨm kələhən nəhau e panɨkɨn kitiəh. ");
INSERT INTO tnn_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Kən Iesu tən-ipən kəm in məmə, “Ik nəkəruru nat naka itəm Uhgɨn tolkeike məmə otos-ipɨnə kəm ik. Kən ik məruru mɨn io, io u, iatətapəh-in-pɨnə nəhau kəm ik. Okəmə ik nəkɨtun, ik onakətapəh-in-pa nəhau ron io. Kən io oekos-ipɨnə nəhau megəh.” ");
INSERT INTO tnn_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kən pətan un, tən-ipən kəm in məmə, “Etəm-iasol, ik rəham pəkɨt tɨkə, kən wel u, in əpəh ləhau isəu. ?Nəhau megəh un nakatən mə onakətu ahrol minu lan? ");
INSERT INTO tnn_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Rəhatat pipi Jekop u aupən, in təmos-ipa wel u kəm itat, kən in təmatətu nəhau ikɨn nɨmɨn, ilat nenətɨn mɨn, ne rəhan mɨn kau mɨn. ?Kən təhrol? ?Ik nakaprəkɨs-in Jekop, o?” ");
INSERT INTO tnn_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Kən Iesu təmən-ipən kəm in məmə, “Netəm koatənɨm nəhau e wel u, ilat okəpanotoaoa mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Məto etəmim itəm otənɨm nəhau itəm io ekos-ipən kəm in, okol təsoaoa mɨnən nian kit ne. Nəhau itəm io oekos-ipən kəm in, in tahmen e nəmtɨ nəhau kit itəm tɨtapuəl-apuəl mətaiu əpəh imə e nɨkin nian rafin, matos-ipən nəmegəhən itulɨn kəm in, itəm otəsolən namnun.” ");
INSERT INTO tnn_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Kən pətan un tən-ipən kəm in məmə, “!Etəm-iasol, awi! Os-ipa-tu nəhau un kit kəm io, məmə io ekəsoaoa mɨnən nian kit, kən məsuwa mɨnən u ikɨn-u, mətu nəhau.” ");
INSERT INTO tnn_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Kən Iesu tən-ipən kəm in məmə, “Uwɨn maun-in-pən rəham iaguɨhl, kən muea ikɨn-u.” ");
INSERT INTO tnn_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Kən pətan un tən-ipən kəm in məmə, “Io rəhak iaguɨhl tɨkə.” Məto Iesu tən-ipən kəm in məmə, “Nakatən pahrien məmə rəham iaguɨhl tɨkə. ");
INSERT INTO tnn_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Məto-inu ik, nəmətəu-pən rəkɨs nəman faif, kən iərman u itəm itəmlau min nakatuatɨg u-roiu, sənəmə rəham ətuatɨp iaguɨhl. Nəghatən rəham u-roiu, in nɨpahrienən.” ");
INSERT INTO tnn_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Kən pətan u, tən-ipən kəm in məmə, “Etəm-iasol, iatəplan məmə ik ien kit rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tɨpɨtɨmat mɨn aupən, ilat kəmotəfak kəm Uhgɨn əpəh ilɨs e nɨtot əpəh, məto itəmat netəm Isrel, nakoatən məmə Jerusalem əm un, okəkəike kan ikɨn katəfak.” ");
INSERT INTO tnn_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Məto Iesu tən-ipən kəm in məmə, “Pətan, ik onakəkəike mən nɨpahrienən e rəhak nəghatən. Nian əh-ikɨn tatuwa, məmə itəmat onəsotəfak mɨnən kəm Tata Uhgɨn əpəh e nɨtot asol əh, ne Jerusalem mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Itəmat netəm Sameria, itəmat noatəfak kəm Uhgɨn məto itəmat nəkotəruru in. Məto itɨmat ioatəfak kəm Uhgɨn u, ekotɨtun in, məto-inun suatɨp rəha Uhgɨn o nosmegəhən netəmim in təmɨsɨ-pa etɨmat, netəm Isrel. ");
INSERT INTO tnn_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Məto otəsuwəhən, nɨpahrienən məmə nian əh tɨnuwa rəkɨs, nian Narmɨn Rəha Uhgɨn in otasitu e iəfak pahrien mɨn, mol ilat məmə ilat okotɨtun wɨr Uhgɨn məmə Uhgɨn u, in Uhgɨn pahrien, kən mol ilat məmə ilat okotəfak kəm in e nɨkilat pahrien. Məto-inu Tata Uhgɨn in tategəs-in iəfak mɨn itəm koatol nəhlan. ");
INSERT INTO tnn_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Uhgɨn in sənəmə etəmim. Kəpə. In narmɨn. Tol nəhlan, kən netəmim itəm koatəfak kəm in, ilat kotəkəike motəfak kəm Uhgɨn məmə Uhgɨn u, in Uhgɨn pahrien, kən ilat kotəkəike motəfak kəm in e nɨkilat pahrien e nəsanənən rəha Narmɨn Rəhan.” ");
INSERT INTO tnn_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kən pətan u, təmən-ipən kəm in məmə, “Io enɨtun məmə Mesaea u, otəkəike muwa. Inu, kətaun-in məmə Kristo itəm Uhgɨn təmən məmə otahl-ipa. Kən nian otuwa, kən in tɨtun nən-iarəpən natɨmnat rafin kəm kitat.” ");
INSERT INTO tnn_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Iesu tən-ipən kəm in məmə, “Io u inu, iatəghat kəm ik.” ");
INSERT INTO tnn_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Kən roiu agɨn-əh, netəmim rəha Iesu kəmotɨtəlɨg-pa mɨn. Kən narmɨlat təmiwɨg pɨk nian kəmotəplan in tatəghat ilau pətan kit. Məto ilat kit təməsətapəhən ron məmə, “?Ik nakolkeike naka?” o “?Ik natəghat kəm pətan əh o naka?” ");
INSERT INTO tnn_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kən pətan u, təmapəs rəhan nuwigɨ nəhau tatəpələh, mɨtəlɨg muwɨn əpəh e taon. Təmuwɨn matən-ipən kəm netəmim ikɨn əh məmə, ");
INSERT INTO tnn_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Eh. Otuwɨn-tu motəplan-tu suah kit əh-ikɨn əh, in təmən-iarəp rafin natɨmnat mɨn itəm io ematol. ?Okəmə naka in Kristo itəm Uhgɨn təmən məmə otahl-ipa?” ");
INSERT INTO tnn_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kən ilat kəmotiet e taon əh, mɨnoatuwɨn məmə okotəplan-tu Iesu. ");
INSERT INTO tnn_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kən e nian əh, netəmim rəha Iesu koatuəh nɨkin məmə, “Iəgətun, ik agwən kit.” ");
INSERT INTO tnn_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Məto in tən-ipən kəm ilat məmə, “Io nɨgak əpəh nagwənən itəm itəmat nəkotəruru.” ");
INSERT INTO tnn_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tol nəhlan, rəhan netəmim kɨnoatətapəh-ətapəh olat mɨn məmə, “?Tahro? ?Okəm-naka suah kit təmos-ipən nagwənən kit kəm in, o?” ");
INSERT INTO tnn_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Məto Iesu tən-ipən kəm ilat məmə, “Uhgɨn təmahl-ipa io iakuwa, kən nagwənən u nɨgak, məmə iakatol natɨmnat itəm in tolkeike məmə oekol. Kənu iakol rafin wək mɨn itəm in təmos-ipa məmə oekol, o nol namnunən rəhan wək. ");
INSERT INTO tnn_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Itəmat nəkotɨtun-tu nəghatən kit u katən məmə, ‘Məwɨg kuwɨt əh-ikɨn tətatɨg məmə okotoarus nian rəha nəulək-inən nagwənən e nasumən.’ Məto io iatən-ipɨnə kəm itəmat, otəplan-tu nagwənən u e nasumən. Roiu əh, nɨmalɨlat tɨnapə rəkɨs. Nian rəha nəuləkən əh-roiu. ");
INSERT INTO tnn_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","“Etəmim rəha nəuləkən tɨnuwa, mɨnətuoun mɨnatos rəkɨs rəhan nətouən. Kən nagwənən u, in təməulək in o nəmegəhən lilɨn. E nolən u, etəmim itəm tətasum ne etəmim itəm tatəulək in mos matuwa, ilau kərən nɨkilau otagien. ");
INSERT INTO tnn_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nəghatən kit u katən məmə, ‘Suah kit tuwɨn mə otasum, məto etəm pɨsɨn kit mɨn otəulək-in məmɨk muwa.’ Nəghatən u, in nɨpahrienən. ");
INSERT INTO tnn_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Io emahl-ipən itəmat məmə onəkotuwɨn motəulək e nasumən itəm itəmat nəməsotasum-inən. Netəm pɨsɨn mɨn, ilat kəmotasum in. Kən itəmat nɨnoatəhl noa rəhalat wək.” ");
INSERT INTO tnn_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Kən e taon u, netəm Sameria tepət, ilat kəmotahatətə e Iesu məto-inu pətan əh təmatətul-arəp matən-ipən kəm ilat məmə, “Iesu təmən-iarəp natɨmnat rafin itəm io ematol.” ");
INSERT INTO tnn_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kən nian netəm Sameria kəmotuwɨn motehm, kən kəmotəkəike kəm in məmə otuwɨn motatɨg ilat min. Kən Iesu təmuwɨn moatatɨg o nian kəiu. ");
INSERT INTO tnn_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kən netəmim tepət mɨn kəmotahatətə lan e rəhan mɨn nəghatən. ");
INSERT INTO tnn_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Kən moatən-ipən kəm pətan u məmə, “Itɨmat emotahatətə lan o nəghatən u itəm ik nəmən-ipa, məto roiu əh, ekoatahatətə lan məto-inu itɨmat əm emotəto rəhan nəghatən mɨn, kən motɨtun pahrien məmə in Iosmegəh rəha nətueintən.” ");
INSERT INTO tnn_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nian Iesu təmatɨg mos nian kəiu rəkɨs ikɨn əh, in təmiet muwɨn Kalili. ");
INSERT INTO tnn_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Məto-inu aupən, in təmatən məmə ien mɨn rəha Uhgɨn, natiməlat mɨn, ilat kəsotɨsiai-inən ilat. ");
INSERT INTO tnn_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Netəm Kalili, aupən ilat kəmotuwɨn Jerusalem moatol lafet rəha Nuhagego-inən, kən e nian əh, ilat kəmotəplan natɨmnat mɨn itəm in təmol ikɨn əh. Kən nian Iesu təmuwɨn Kalili, nɨkilat təmagien ron. ");
INSERT INTO tnn_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kən Iesu təmɨtəlɨg-pən mɨn e latuənu Kena, əpəh Kalili. Ikɨn əh aupən, in təmol nəhau tuwa mol wain. Kən e Kapaneam, etəm-iasol rəha kig tətatɨg ikɨn. Kən nətɨn kit tatɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kən nian suah u təməto məmə Iesu təmɨsɨ-pən u Jutia mɨnuwa rəkɨs Kalili, kən in təmuwa məplan Iesu. Kən mən-ipən ron məmə oteiuaiu muwɨn əpəh Kapaneam kən mol-wɨr nətɨn. Məto-inu suakəku nol otɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Kən Iesu tən-ipən kəm suah un məmə, “!Nəman! Itəmat u, nakotəmə onəkotəplan əm nəmtətin mɨn ne natɨmnat mɨn itəm narmɨtəmat otiwɨg ron aupən, kənu uarisɨg un, nəpanotahatətə lak. Məto okəmə nəsotəplanən, okol nəsotahatətəən lak.” ");
INSERT INTO tnn_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kən suah un təmə, “!Etəm-iasol, awi! !Pəs kian uəhai əm! !Otəsuwəhən roiu nətɨk tɨmɨs!” ");
INSERT INTO tnn_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Kən Iesu təmən-ipən kəm in məmə, “Uwɨn; nətɨm otəpanəmegəh.” Kən suah un təmahatətə e nəghatən rəha Iesu kən mɨtəlɨg. ");
INSERT INTO tnn_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nian in təmatuwɨn əh e suatɨp, təməplan rəhan iolwək mɨn, kən ilat kotən-ipən kəm in məmə, “Rəham suakəku tɨnəmegəh rəkɨs.” ");
INSERT INTO tnn_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kən in təmətapəh olat məmə, “?Təməwɨr e nian naka?” Kən ilat kəmotən-ipən kəm in məmə, “Nəniəp ehnaipən e wan klok rəhan nəgəpanən təmɨkə.” ");
INSERT INTO tnn_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Kən suah un, təmɨtun məmə, e nian ətuatɨp əh inəh, Iesu təmən-ipən kəm in məmə, “Rəham suakəku otəpanəmegəh.” Kən in ne rəhan mɨn, kəmotahatətə e Iesu. ");
INSERT INTO tnn_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Inu nian tatol kəiu lan itəm Iesu təmiet Jutia, muwa Kalili kən mol nəmtətin kit. ");
INSERT INTO tnn_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Uarisɨg e nian əh, Iesu təmər muwɨn e taon u Jerusalem, məto-inu katol lafet kit rəha netəm Isrel əh-ikɨn əh. ");
INSERT INTO tnn_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","E Jerusalem, noan asol kit əpəh ikɨn, itəm kətaig lan. E nəghatən rəha netəm Isrel katən nərgɨn məmə Petseta. Kən nimə kit tatətul iuəhkɨr o noan əh. Nimə un, feranta lan, faif. In əh iuəhkɨr o ket u e fenɨs rəha taon u, nərgɨn u, Ket rəha Sipsip. ");
INSERT INTO tnn_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Kən ikɨn əh, e feranta mɨn, netəm koatɨmɨs tepət koatapɨl əh-ikɨn. Neen nɨganəmtɨlat təpɨs, kən neen nelkɨlat tərat, neen mɨn nɨpətɨlat nəwtain təmɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Kən suah kit əh-ikɨn əh tətapɨl. In təmatɨmɨs mɨnos rəkɨs nup tate-eit. ");
INSERT INTO tnn_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Kən Iesu təplan suah un tətapɨl, kən in mɨnɨtun məmə suah u təmɨmɨs nuwəh məsɨn, kən tətapəh ron məmə, “?Tahro? ?Nakolkeike məmə onakəwɨr?” ");
INSERT INTO tnn_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Etəm tatɨmɨs un tən-ipən kəm in məmə, “Etəm-iasol, etəmim tɨkə məmə otɨləs io meiuaiu muwɨn e noan əh nian nəhau tatəloal. Nian rafin, io etalkut pɨk məmə ekeiuaiu muwɨn e noan əh, məto netəmim neen ilat kotaprəkɨs-in io moteiuaiu motuwɨn. Kən ilat motaupən motek nəhau.” ");
INSERT INTO tnn_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kən Iesu tən-ipən kəm in məmə, “!Ətul! Mos rəham nɨmɨtiwɨn maliwək matuwɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kən roiu agɨn suah apon təməwɨr mɨn. Kən maiuaiu rəhan nɨmɨtiwɨn mos matuwɨn. Nat u kəmol e nian rəha Sapat, ");
INSERT INTO tnn_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","kən netəm-iasol mɨn rəha Isrel kəmotəhai suah un itəm tɨnəmegəh e rəhan nɨmɨsən, motəmə, “Nian u-roiu rəha Sapat; kən təsətuatɨpən e Lou rəhatat məmə onakos nulan rəham nɨmɨtiwɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Kən in tən-ipən kəm netəm mɨn u məmə, “Məto suah u təmol-wɨr io, in təmən-ipa məmə ekos rəhak nɨmɨtiwɨn maliwək matuwɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Kən ilat kəmotətapəh ron məmə, “?Suah pah apon təmən-ipɨnə kəm ik məmə onəkol nat un?” ");
INSERT INTO tnn_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Məto suah un təruru nərgɨ Iesu, məto-inu netəmim tepət ikɨn əh, kən Iesu təmɨkə-pən əm əh ilugɨn elat. ");
INSERT INTO tnn_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kən uarisɨg, Iesu təməplan suah un e Nimə Rəha Uhgɨn, kən tən-ipən kəm in məmə, “!Ei! !Əplan-tu! !Ik nɨnəwɨr rəkɨs! Məto onatəto ik məmə nəsol mɨnən təfagə rat mɨn. Okəmə nakol, nəratən kit otɨləs mɨn ik, itəm tərat təhmɨn mɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kən suah apon təmuwɨn mən-ipən kəm netəm-iasol mɨn rəha Isrel məmə, “Suah u itəm təmol-wɨr io, nərgɨn un, Iesu.” ");
INSERT INTO tnn_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kən tol nəhlan, netəm-iasol rəha netəm Isrel, ilat kɨnoatɨtəp-ɨtəp Iesu məmə okotol nəratən kəm in, məto-inu ilat kotəplan in tatol natɨmnat mɨn tol nəhlan e nian rəha Sapat. ");
INSERT INTO tnn_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Məto Iesu təmən-ipən kəm ilat məmə, “Nian rafin rəhak Tata tatol əh wək, kən io mɨn oekatol wək.” ");
INSERT INTO tnn_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kən nəghatən u, tol nətəlɨgən rəhalat təskasɨk təhmɨn mɨn, məmə okotohamnu in tɨmɨs. Məto-inu roiu əh, sənəmə məmə tatətgəhl əm Lou rəha Sapat, məto nat in iahgin pɨk, in tatən məmə rəhan u Tata ətuatɨp Uhgɨn, kən tol nulan, in matol məmə in tahmen ətuatɨp e Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kən Iesu tən-ipən kəm ilat məmə, “Nɨpahrienən agɨn un iatən kəm itəmat, Nətɨ Uhgɨn təruru nolən nat kit e rəhan atɨp əm nətəlɨgən. Tɨtun əm nolən natɨmnat mɨn un itəm Tata Uhgɨn tatol, məto-inu natɨmnat rafin u itəm Tata Uhgɨn tatol, Nətɨn, in mɨn in tatol. ");
INSERT INTO tnn_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nətɨn tɨtun nolən nəhlan, məto-inu Tata Uhgɨn tolkeike pɨk Nətɨn, kən in tatəgətun kəm in natɨmnat rafin itəm in tatol. Kən in otəpanəgətun mɨn natɨmnat mɨn kəm in itəm iahgin mɨn kotaprəkɨs-in in mɨn u, məmə otol itəmat narmɨtəmat tatiwɨg pɨk ron. ");
INSERT INTO tnn_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","“Məto-inu Tata Uhgɨn tatol netəm kəmotɨmɨs ilat koatəmegəh mɨn, kən e nolən kitiəh əm, Nətɨn tɨtun nos-ipənən nəmegəhən kəm netəmim itəm nɨkin tagien məmə otos-ipən kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Məto-inu sənəmə Tata Uhgɨn itəm in otakil netəmim, məto in təmələhəu-pən rafin nakilən e nelmɨ Nətɨn, ");
INSERT INTO tnn_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","məmə netəmim ilat rafin okotɨsiai-in Nətɨn, tahmen əm məmə inun koatɨsiai-in mihin Tata Uhgɨn. Etəmim itəm təsɨsiai-inən Nətɨn, okol təsɨsiai-inən Tata Uhgɨn u itəm təmahl-ipa Nətɨn. ");
INSERT INTO tnn_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nɨpahrienən agɨn u iatən kəm itəmat məmə, etəmim itəm tatəto rəhak nəghatən, kən mətahatətə e Uhgɨn itəm təmahl-ipa io iakuwa, in tɨnatos nəmegəhən itulɨn. In okol təsətulən e nɨganəmtək məmə oekən-iarəp nalpɨnən rəhan. In tɨnagɨm rəkɨs e nɨmɨsən, kən mɨnuwa o nəmegəhən. ");
INSERT INTO tnn_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nɨpahrienən agɨn u iatən kəm itəmat, məmə o nian kit itəm tatuwa, kən tɨnuwa rəkɨs, netəm mɨn u kəmotɨmɨs, ilat okotəto nəwia Nətɨ Uhgɨn, kən netəm mɨn u ilat kotətəlɨg-in, ilat okotos nəmegəhən. ");
INSERT INTO tnn_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tata Uhgɨn in Nəukətɨ Nəmegəhən, kən e nolən kitiəh əm, in təmol mə Nətɨn in mɨn Nəukətɨ Nəmegəhən, ");
INSERT INTO tnn_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","kən in təmələhəu-pən nəsanənən ne nepətən e nelmɨ Nətɨn məmə in otakil nolən mɨn rəha netəmim, məto-inu in Nətɨ Etəmim. ");
INSERT INTO tnn_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Təsəwɨrən məmə narmɨtəmat otiwɨg pɨk o nat u, məto-inu nian əh-ikɨn tatuwa itəm netəm kəmotɨmɨs okotəto nəwia Nətɨn, ");
INSERT INTO tnn_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","kən ilat okotətul e rəhalat mɨn suwɨt, ilat mɨn u aupən kəmoatol nolən wɨr mɨn okotəkəike motətul mɨn motos mɨn nəmegəhən, məto itəm mɨn aupən ilat kəmoatol nolən rat mɨn, ilat okotəkəike motətul mɨn e nɨmɨsən kən motətul e nɨganəmtɨ Tata Uhgɨn məmə Nətɨn otən-iarəp rəhalat nalpɨnən. ");
INSERT INTO tnn_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Io ekəruru nolən nat kit e rəhak atɨp əm nəsanənən. Io iakatakil nolən mɨn rəha netəmim mɨn, məto iatol ətuatɨp əm məmə rəhak Tata tatən mihin ne məmə oekol. Kən nian iakakil nolən rəha netəmim, ekɨtun mə ekol tətuatɨp, məto-inun oesalkutən məmə ekol əm e rəhak nəsanənən. Məto io, ekəike malkut məmə iakol tahmen e nətəlɨgən rəha Uhgɨn itəm təmahl-ipa io ekuwa.” ");
INSERT INTO tnn_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Okəmə io pɨsɨn əm iakəghat-in io, kən rəhak nəghatən okol təsətulən. ");
INSERT INTO tnn_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Məto suah kit mɨn əh-ikɨn in tatətul-arəp kən matol nəfɨgəmən ron io, kən io ekɨtun məmə nəghatən mɨn u rəhan itəm tatən lak in nɨpahrienən. ");
INSERT INTO tnn_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Aupən, itəmat nəmotahl-ipən rəhatəmat mɨn netəmim məmə okotuwɨn motətəlɨg-in nəghatən rəha Jon, kən in təmatətul-arəp o nɨpahrienən. ");
INSERT INTO tnn_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Iatəghat nulan, məto esagɨleən e nəghatən rəha etəmim əm kit məmə tɨtun nolən nəfɨgəmən ron io. Kəpə. Təsolən nulan. Iatəghat-in nəghatən rəha Jon nulan məto-inu ekolkeike məmə Uhgɨn otosmegəh itəmat. ");
INSERT INTO tnn_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon u, tahmen e lait kit. Tatuəp məhag-əhag wɨr, kən nɨkitəmat təmagien ron o nian təkuəkɨr əm. ");
INSERT INTO tnn_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Məto rəhak wək mɨn, ilat mɨn koatol nəfɨgəmən ron io. Kən ilat kotəsanən motaprəkɨs-in nəghatən mɨn un Jon təmatən. Wək mɨn un, rəhak Tata təmos-ipa kəm io mə oekol namnun elat. Kən wək mɨn u rəhak, ilat koatən-iarəp io, kən ilat moatol əp io məmə rəhak Tata in təmahl-ipa io. ");
INSERT INTO tnn_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Kən Tata Uhgɨn itəm təmahl-ipa io, inun itəm tɨnatətul-arəp ron io. In tatən-iarəp io pap, məto itəmat nəsotətoən nəwian, kən itəmat nəsotəplanən nɨganəmtɨn. ");
INSERT INTO tnn_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kən nəghatən rəhan təsatɨg wɨrən e nɨkitəmat, məto-inun itəmat nəsotahatətəən lak, io u, itəm in təmahl-ipa io iakuwa. ");
INSERT INTO tnn_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Itəmat noatafin pɨk nəghatən mɨn e Naoa Rəha Uhgɨn, kən motahatətə e nəghatən mɨn əh məmə itəmat onəkotos nəmegəhən itəm namnun tɨkə. Məto otəplan-tu. Nəghatən mɨn əh e Naoa Rəha Uhgɨn, ilat koatəghat-in io, moatən-iarəp io. ");
INSERT INTO tnn_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Məto itəmat nakotapəs nuwamən ron io məmə nakotos nəmegəhən ron io. ");
INSERT INTO tnn_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Esolən nat agɨn-əh e nənwiwiən rəha netəmim. Kəpə. ");
INSERT INTO tnn_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Məto itəmat u inun, io ekɨtun wɨr itəmat, kən io ekɨtun wɨr məmə nolkeikeən rəha Uhgɨn tɨkə e nɨkitəmat. ");
INSERT INTO tnn_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Io emuwa e nərgɨ Tata rəhak, məto itəmat nəsotosən io e nɨkitəmat, nɨkitəmat təsagienən ron io; məto okəmə etəmim kit tatuwa e nərgɨn atɨp əm, kən nɨkitəmat tos, kən motagien ron. ");
INSERT INTO tnn_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nian rafin itəmat nakotolkeike məmə nakotos nənwiwiən rəhatəmat mɨn, məto nəsotalkut agɨn-əhən məmə onəkotol nat kit itəm Uhgɨn u, in pɨsɨn əm in Uhgɨn, otənwiwi itəmat ron. ?Onəkotahatətə ahro nulan lak e nolən əh? ");
INSERT INTO tnn_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Təsəwɨrən məmə nɨkitəmat otəht məmə, io oekən-iarəp nolən rat mɨn rəhatəmat e nɨganəmtɨ Tata Uhgɨn. Kəpə. Məto Moses ilə, nian rafin itəmat noatuag-pən ron, in otən-iarəp nolən rat mɨn rəhatəmat. ");
INSERT INTO tnn_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Məto-inu okəmə itəmat nəmotahatətə pahrien e nəghatən mɨn rəha Moses, kən itəmat onəkotahatətə mɨn e rəhak nəghatən mɨn. Məto-inun, nəghatən mɨn itəm in təməte rəkɨs, ilat koatəghat-in io. ");
INSERT INTO tnn_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Məto itəmat nəsotahatətəən e nəghatən mɨn itəm in təməte, tol nəhlan, suatɨp tɨkə agɨn məmə onəkotahatətə lak. ");
INSERT INTO tnn_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Uarisɨg e natɨmnat mɨn u, Iesu təmuwɨn əpəh entənɨpən e nəhau asol nərgɨn un, Lek Kalili. Kən nərgɨn kit mɨn un, Lek Taepirias. ");
INSERT INTO tnn_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kən nɨmanin netəmim kəmoatuarisɨg-in, məto-inun koatəplan nəmtətin mɨn rəhan, itəm tatol netəmim koatɨmɨs koatəto təwɨr. ");
INSERT INTO tnn_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Kən Iesu təmuwɨn əpəh ilɨs e nɨtot kit, kən matəpələh ikɨn əh ilat rəhan mɨn netəmim. ");
INSERT INTO tnn_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","E nian əh, lafet kit rəha netəm Isrel u, kətaun-in məmə lafet rəha Nuhagego-inən tɨnatuwa iuəhkɨr. ");
INSERT INTO tnn_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Kən nian Iesu tasɨpən əpəh isəu, kən məplan nɨmanin netəmim tepət ilat koatuwa, kən in tətapəh o Filip məmə, “?Okotəhrol motos pɨret tepət tahmen-in netəm mɨn u məmə ilat okotun?” ");
INSERT INTO tnn_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","In təmən asgəwɨn əm məmə otəplan nahatətəən rəha Filip, məto in tɨnɨtun rəkɨs nat naka itəm in otəpanol. ");
INSERT INTO tnn_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Kən Filip tən-ipən kəm in məmə, “!Ei! Okəmə okos-nəmtɨn pɨret məni lan tahmen e tu-hanrɨt tenarius pap, məto okol təsahmenən. Netəm mɨn u rafin ilat okotun əm noan məsɨn noan məsɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Kən etəmim kit rəha Iesu, pian u Saimon Pita, nərgɨn u Antru, in təmən-ipən kəm Iesu məmə, ");
INSERT INTO tnn_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Suakəku kit əh-ikɨn əh, in tatos pɨret faif kəmol e pale, ne nəm kəiu. Məto okol təsahmen-in agɨn-əhən netəm mɨn əh.” ");
INSERT INTO tnn_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Kən Iesu təmə, “Otən-ipən-tu kəm netəmim kotəpələh.” Kən ikɨn əh, manuwɨhl tepət, kən ilat kəmotəpələh. Kən nampa rəha nəman əm, in nat kit tahmen e faif-taosan. ");
INSERT INTO tnn_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kən Iesu təmos pɨret, mən tagkiu kəm Uhgɨn ron, kən mos-ipən pɨret un kəm ilat rafin u koatəpələh, kən matɨg mol mɨn nat kitiəh əm e nəm. Kən ilat kəmotun tahmen-in nərpɨlat. ");
INSERT INTO tnn_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kən nian kɨnotagwən rəkɨs, nərpɨlat tasis, kən Iesu təmən-ipən kəm rəhan mɨn netəmim məmə, “Otuwɨn motuwər nɨmɨsmɨsɨ pɨret mɨn əh koatɨs. Təsəwɨrən məmə okotərəkɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kən ilat kəmotuwɨn motuwər nɨmɨsmɨsɨ pɨret kən motaii-pən e kətɨm asol mɨn ilat tuelef kotərioah wɨr. Pɨret u, in nɨmɨsmɨsɨ pɨret ilat faif kəmol e pale itəm netəmim kəmotun kapəs. ");
INSERT INTO tnn_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kən nian netəmim kəmotəplan nəmtətin əh itəm Iesu təmol, kən ilat kəmotən məmə, “Nɨpahrienən. !Ien pahrien u rəha Uhgɨn itəm aupən kəmatən məmə in otuwa e nətueintən!” ");
INSERT INTO tnn_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Kən Iesu təmɨtun məmə netəm mɨn u kotəmə okotuwa motos in motuwɨn motəkəike kəm in məmə in otuwa mol kig rəhalat. Kən in təmagɨm mɨn, mapəs ilat muwɨn əpəh e nɨtot, mətan in pɨsɨn əm. ");
INSERT INTO tnn_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nian mɨtgar təmeiuaiu, netəmim rəha Iesu mɨn kəmoteiuaiu motuwɨn e lek əh. ");
INSERT INTO tnn_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kən tɨnapinəp, məto Iesu tɨkə, təsuwamən əh. Kən əmun, ilat kəmotuwɨn motər e pot kit, kən mɨnotasuə lan motaulego mɨn e lek un, məmə ilat okotuwɨn Kapaneam. ");
INSERT INTO tnn_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kən nɨmətag asol kit təmətul mɨnol nəhau tɨnərat-nərat. ");
INSERT INTO tnn_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kən nian ilat kəmotasuə motuwɨn, tahmen e faif o sikis kilomita, kən ilat kotəplan Iesu taliwək e nətuei nəhau matuwa iuəhkɨr o rəhalat pot. Kən ilat kəmotəgɨn pɨk, ");
INSERT INTO tnn_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","məto in təmən-ipən kəm ilat məmə, “Əsotəgɨn pɨkən, io u inu.” ");
INSERT INTO tnn_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","!Kən nɨkilat təmagien o nɨləsən in e pot, moatol əmun, roiu agɨn, məto pot tɨnuwɨn e nəwtain nəhau entənɨpən-pən ikɨn-un kəmotən məmə okotuwɨn ikɨn! ");
INSERT INTO tnn_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kəmən lawɨgin, netəmim mɨn itəm kotatɨg əh entənɨpən-pa ikɨn e lek asol u, ilat kəmotəplan məmə aupən, pot kitiəh əm tatətul ukɨn-u. Kən ilat kotɨtun məmə Iesu təsuwɨnən e pot u ilat rəhan mɨn netəmim, məto-inun nian kəmotiet, ilat pɨsɨn əm moatuwɨn. ");
INSERT INTO tnn_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kən pot mɨn neen, kəmotɨsɨ-pən e taon u Taepirias, ilat kəmotuwa. Ilat kəmotuwar iuəhkɨr əm o ikɨn-u itəm Ierəmərə təmətul ikɨn məfak matən tagkiu o pɨret, kən netəmim kəmotun. ");
INSERT INTO tnn_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kən tol nəhlan, nian ilat kəmotəplan məmə Iesu tɨnɨkə u ikɨn-u, kən rəhan mɨn netəmim kotɨkə, ilat mɨn kəmotasuə mɨn e pot kit, motuwɨn e Kapaneam, moategəs-in. ");
INSERT INTO tnn_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nian netəm mɨn u kəmotəplan Iesu əpəh entənɨpən-pən əpəh e lek u, kotətapəh ron məmə, “?Iəgətun, ik nəmuwa ikɨn-u nəghan?” ");
INSERT INTO tnn_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Məto Iesu təmən-ipən kəm ilat məmə, “Nɨpahrienən agɨn iatən kəm itəmat məmə, itəmat noategəs-in io, sənəmə nəmotəplan nəmtətin mɨn u itəm emol, məto itəmat nəmotun əm pɨret, nərpɨtəmat tasis. ");
INSERT INTO tnn_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Məto təsəwɨrən məmə itəmat nahgitəmat otɨkə o nosən pɨret itəm otəpanəmnəmɨt mɨkə. Itəmat, nahgitəmat otəkəike mɨkə o nosən pɨret itəm tətatɨg lilɨn u, rəha nəmegəhən itəm namnun tɨkə. Pɨret u, inu, Nətɨ Etəmim otəpanos-ipɨnə kəm itəmat; məto-inu Tata Uhgɨn, in təməgətun məmə nɨkin tagien o Nətɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kən ilat kəmotətapəh ron məmə, “?Nolən naka mɨn un itəm Uhgɨn tolkeike məmə itɨmat oekotol?” ");
INSERT INTO tnn_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Kən Iesu tən-ipən kəm ilat məmə, “Itəmat nəkotəkəike motahatətə lak, məmə Uhgɨn təmahl-ipa io. Nat u inu Uhgɨn in tolkeike.” ");
INSERT INTO tnn_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Kən ilat kəmotətapəh mɨn ron məmə, “?Məto ik onəkol nəmtətin naka, məmə itɨmat ekotəplan kən ekotahatətə lam? ?Ik onəkol nat naka? ");
INSERT INTO tnn_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nian rəhatat pipi mɨn u aupən, ilat kəmotan ikɨn taruən-aruən ikɨn, ilat kəmotun ‘mana.’ Nəghatən kit e Naoa Rəha Uhgɨn tatən məmə, ‘In tatos-ipən pɨret itəm tatɨsɨ-pən e Nego e Neai məmə ilat okotun.’” ");
INSERT INTO tnn_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Məto Iesu təmən-ipən kəm ilat məmə, “Nɨpahrienən agɨn u iatən kəm itəmat məmə, sənəmə Moses təmos-ipən pɨret u itəm tatɨsɨ-pən e Nego e Neai məmə nakotun. Rəhak Tata ilə in tatos-ipɨnə. Kən inun tatos-ipən pɨret pahrien itəm tatɨsɨ-pən e Nego e Neai, məmə itəmat onəkotun. ");
INSERT INTO tnn_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Məto-inu pɨret rəha Uhgɨn, inu in itəm tatɨsɨ-pən e Nego e Neai, mateiuaiu-pa e nətueintən. Kən pɨret u tatos-ipən nəmegəhən kəm netəmim e nətueintən.” ");
INSERT INTO tnn_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Kən ilat kəmotən-ipən kəm in məmə, “Etəm-iasol, awi os-ipa-tu pɨret u kəm itɨmat nian rafin.” ");
INSERT INTO tnn_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Kən Iesu təmən-ipən kəm ilat məmə, “Io u, io Pɨret itəm tatos-ipən nəmegəhən. Etəmim otuwa ron io, in nəumɨs otəsus mɨnən. Kən etəmim itəm otahatətə lak, in otəsoaoa mɨnən. ");
INSERT INTO tnn_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Məto io emən-ipɨnə rəkɨs kəm itəmat, məmə nat əpnapɨn nəkotəplan io, məto itəmat nəsotahatətəən əh lak. ");
INSERT INTO tnn_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Netəmim itəm rəhak Tata tatos-ipa ilat kəm io, ilat okotuwa ron io. Kən etəmim itəm otuwa ron io, okol iakəsahl-iarəp-ən. ");
INSERT INTO tnn_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Məto-inu io eməsɨsɨ-pənən e Nego e Neai meiuaiu-pa e nətueintən məmə iakol natɨmnat mɨn u io əm ekolkeike. Məto emuwa məmə ekol natɨmnat mɨn u itəm rəhak Tata təmahl-ipa io ekuwa ron. ");
INSERT INTO tnn_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Kən in tolkeike məmə io esəmkarəpən-inən netəm mɨn un itəm in təməmki-pa ilat kəm io. In tolkeike məmə e namnun nian, io oekol netəm mɨn u ilat okotəmegəh mɨn e nɨmɨsən. ");
INSERT INTO tnn_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Məto-inu rəhak Tata in tolkeike məmə netəmim rafin itəm kotuag-pən o Netɨn, kən motahatətə lan, ilat okotos nəmegəhən itulɨn. Kən e namnun nian, io oekol netəm mɨn u ilat okotəmegəh mɨn e nɨmɨsən.” ");
INSERT INTO tnn_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","O nat u, netəmim nɨkilat tɨnətuoun mətagət, məto-inu in tatən məmə, “Io u, Pɨret itəm tatɨsɨ-pən e Nego e Neai, meiuaiu-pa e nətueintən.” ");
INSERT INTO tnn_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ilat koatən məmə, “?Təhrol? Suah u in Iesu, nətɨ Josep, kitat kotɨtun əm rəhan tata ne mama. ?Təhrol in tatən nulan məmə, ‘Io emɨsɨ-pən e Nego e Neai, matuwa e nətueintən’?” ");
INSERT INTO tnn_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iesu təmən-ipən kəm ilat məmə, “Nɨkitəmat təsagət-agətən nulan. ");
INSERT INTO tnn_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Okəmə Tata Uhgɨn itəm təmahl-ipa io ekuwa, in təsiuw-pamən etəmim kit tuwa ron io, kən okol etəmim un təsuwa atɨpən ron io məmə io oekol in otəmegəh mɨn e nɨmɨsən e namnun nian. ");
INSERT INTO tnn_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nəghatən itəm ien kit təməte aupən e Naoa rəha Uhgɨn, tatən nulan məmə, ‘Uhgɨn in otəgətun netəmim rafin.’ Etəmim itəm tatətəlɨg-in nəgətunən rəha Tata Uhgɨn, in tatuwa ron io. ");
INSERT INTO tnn_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Etəmim kitiəh ne tɨkə, itəm təməplan Tata Uhgɨn. In pɨsɨn əm un itəm təmɨsɨ-pən lan, təməplan in. ");
INSERT INTO tnn_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nɨpahrienən agɨn u iatən-ipɨnə kəm itəmat məmə, etəmim itəm tətahatətə lak, in tɨnos nəmegəhən lilɨn. ");
INSERT INTO tnn_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Io un, Pɨret rəha nəmegəhən. ");
INSERT INTO tnn_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nat əpnapɨn tɨpɨtəmat mɨn aupən, ilat kəmotun pɨret u ‘mana’ əpəh ikɨn taruən-aruən ikɨn, məto ilat kɨnotɨmɨs rəkɨs. ");
INSERT INTO tnn_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Məto Pɨret itəm tatɨsɨ-pən e Nego e Neai meiuaiu-pa u-roiu, in tol pɨsɨn. Pɨret u, təmeiuaiu-pa məmə etəmim itəm tatun, okol təsɨmɨsən. ");
INSERT INTO tnn_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Io u, io Pɨret itəm tatəmegəh, təmɨsɨ-pən e Nego e Neai, meiuaiu-pa e nətueintən. Etəmim itəm otun Pɨret u, in otəmegəh matuwɨn, matuwɨn, namnun tɨkə; kən Pɨret u, itəm io oekos-ipən o nəmegəhən rəha netəmim e nətueintən, inun, noanuwəhgək.” ");
INSERT INTO tnn_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nəghatən u təmol netəmim kɨnotətul mɨnoatərgəhəu kəm ilat mɨn, motəmə, “?Təhrol? ?Suah u tɨtun nos-ipamən noanuwəhgɨn kitat kotun?” ");
INSERT INTO tnn_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kən Iesu təmən-ipən kəm ilat məmə, “Nɨpahrienən agɨn u iatən-ipɨnə kəm itəmat məmə, okəmə itəmat nəsotunən noanuwəhgɨ Nətɨ Etəmim, kən məsotənɨmən nɨtan, okol nakəsotosən nəmegəhən. ");
INSERT INTO tnn_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Etəmim itəm tatun əm noanuwəhgək matənɨm nɨtak, in otos nəmegəhən lilɨn, kən e namnun nian, io oekol in otəmegəh mɨn e nɨmɨsən. ");
INSERT INTO tnn_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Emən nəhlan, məto-inu noanuwehgək in pɨret pahrien nɨgɨ netəmim. Kənu nɨtak, in nənɨmən pahrien nɨmɨ netəmim. ");
INSERT INTO tnn_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Etəmim itəm tatun noanuwəhgək, kən matənɨm nɨtak, in otatɨg lak. Kən iakətatɨg lan. ");
INSERT INTO tnn_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“Rəhak Tata itəm təmahl-ipa io ekuwa, in nəukətɨ nəmegəhən. Kən io iatos nəmegəhən ron. Kən e nolən kitiəh əm, etəmim itəm tatun io, inu tatos nəmegəhən ron io. ");
INSERT INTO tnn_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Io u pɨret pahrien, itəm təmɨsɨ-pən e Nego e Neai, meiuaiu-pa e nətueintən. In təsahmenən e pɨret u, itəm tɨpɨtəmat mɨn aupən kəmoatun. Nat əpnapɨn məmə ilat kəmoatun pɨret əh, məto ilat kɨnotɨmɨs rəkɨs. Məto etəmim itəm tatun pɨret u, in otos nəmegəhən lilɨn, itəm namnun tɨkə.” ");
INSERT INTO tnn_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iesu təmən-iarəp nəghatən mɨn u, nian təmatəgətun netəmim əpəh e nimə rəha nuəfɨmɨnən e Kapaneam. ");
INSERT INTO tnn_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Netəmim tepət rəha Iesu kəmotəto nəghatən u rəha Iesu, kən ilat kotəmə, “!Nəman! !Nəghatən u tiəkɨs pɨk! ?Pah u tɨtun nosən nəghatən tol nəhlan?” ");
INSERT INTO tnn_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Kən Iesu təmɨtun atɨp məmə netəmim mɨn rəhan, kɨnotasiwɨn-asiwɨn-in nəghatən əh rəhan. Kən in təmən-ipən kəm ilat məmə, “?Təhrol əh? ?Nətəlɨgən rəhatəmat təmeiuaiu o nat u? ");
INSERT INTO tnn_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","?Məto okəmə naka nəkotəplan Nətɨ Etəmim tər matuwɨn mɨn ikɨn əh, in təmɨsɨ-pən ikɨn aupən, təhrol u-roiu? ");
INSERT INTO tnn_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Narmɨn Rəha Uhgɨn əm tɨtun nos-ipənən nəmegəhən kəm etəmim. Nəsanənən rəha etəmim təruru nolən nat u. Nəghatən mɨn u ematən kəm itəmat, ilat nəghatən mɨn rəha Narmɨn Rəha Uhgɨn itəm tatos-ipən nəmegəhən kəm netəmim. ");
INSERT INTO tnn_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Məto itəmat neen u ikɨn-u, itəmat nəsotahatətəən əh lak.” (Iesu təmən nulan məto-inu in tɨnɨtun rəkɨs e nətuounən məmə netəm pah mɨn u kəsotahatətəən lan, kən pah un in otegəhan-in-pən in e nelmɨ tɨkɨmɨr mɨn rəhan.) ");
INSERT INTO tnn_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Kən in təmən məmə, “O nat u inu, io enəmən rəkɨs kəm itəmat, məmə okol etəmim kit təsuwamən ron io okəmə Tata Uhgɨn təsolən suatɨp ron.” ");
INSERT INTO tnn_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Uarisɨg e nəghatən əh, netəmim rəhan tepət kəmotagɨm, mɨnotapəs nətəu-pənən. ");
INSERT INTO tnn_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kən Iesu təmətapah o rəhan netəmim tuelef məmə, “?Təhrol etəmat? ?Itəmat mɨn nakotən məmə nakotagɨm kapəs io?” ");
INSERT INTO tnn_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Kən Saimon Pita təmən-ipən kəm in məmə, “?Iərəmərə, itɨmat oekotuwɨn o pah? Ik əm un, rəham əm nəghatən in tatos-ipən nəmegəhən itəm namnun tɨkə. ");
INSERT INTO tnn_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kən itɨmat enotahatətə rəkɨs lam, kən itɨmat enotɨtun rəkɨs məmə ik Etəm Asim rəha Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Kən Iesu təmən-ipən kəm ilat məmə, “Itəmat u, netəm tuelef rəhak. Io u, emɨtəpun itəmat, məto itəmat kitiəh u ikɨn, in iərmɨs.” ");
INSERT INTO tnn_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","In tatən Jutas, nətɨ Saimon Iskariot, məto-inu in mɨn in etəm tuelef kit rəha Iesu, məto uarisɨg ikɨn, in otəpanegəhan-in-pən in e nelmɨ rəhan tɨkɨmɨr mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Uarisɨg e natɨmnat mɨn u, Iesu təsolkeikeən məmə otuwɨn latuənu mɨn e Jutia məmə otol rəhan wək əh-ikɨn əh, məto-inun, netəm-iasol rəha netəm Jutia kəmoatəte noa anion kit ron. Kən tɨtəlɨg muwɨn latuənu mɨn e nɨtən Kalili. ");
INSERT INTO tnn_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Məto nian tɨnuəkɨr e nian rəha nolən lafet kit rəha netəm Isrel, nərgɨn un, lafet rəha Nolən Makeen. ");
INSERT INTO tnn_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Kən pia Iesu mɨn kəmotən-ipən kəm in məmə, “Təwɨr məmə nakiet muwɨn əpəh Jutia, mə pəs netəmim mɨn rəham əh-ikɨn əh, ilat kotəplan nat pɨspɨs mɨn rəham itəm natol. ");
INSERT INTO tnn_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Məto-inu etəmim itəm tolkeike məmə netəmim okotɨtun in, okol təsəhluaig-inən rəhan wək mɨn. Okəmə natol natɨmnat mɨn u, uwɨn mol əp ik, kən təwɨr agɨn məmə onəkol pəs netəmim mɨn e nətueintən kotəplan.” ");
INSERT INTO tnn_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Pian agɨn-əh mɨn pap, ilat mɨn kəsotahatətəən lan, kən mol koatən nəhlan. ");
INSERT INTO tnn_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Kən Iesu təmən-ipən kəm ilat məmə, “Nian ətuatɨp rəhak təsuwamən əh, məto itəmat, nian mɨn rafin əm tətuatɨp otəmat. ");
INSERT INTO tnn_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Netəmim rəha nətueintən u, ilat okol kəsotetəhauən itəmat, məto io, ilat kotetəhau io, məto-inun io iatən-iarəp məmə rəhalat nolən təsətuatɨpən. ");
INSERT INTO tnn_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Itəmat onəkotuwɨn e lafet, məto io okol esuwɨn paupənən e lafet əh məto-inun, nian ətuatɨp rəhak təsuwamən əh.” ");
INSERT INTO tnn_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","In təmatən nəghatən u, kən mətatɨg əpəh Kalili. ");
INSERT INTO tnn_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kən pia Iesu mɨn kəmotaupən motuwɨn e lafet əh, uarisɨg un, Iesu təmuwɨn mɨn. Məto nian təmuwɨn, in təmətan anion əm o netəmim məmə okəsotehmən. ");
INSERT INTO tnn_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Kən e lafet əh, netəm-iasol rəha netəm Jerusalem, koategəs-in in moatətapəh-in əpnapɨn əm o netəmim məmə, “?Suah əpəh in hiə?” ");
INSERT INTO tnn_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kən ikɨn əh, nɨmanin netəmim kəmotasiwɨn-asiwɨn in. Ilat neen kotəmə, “In etəm wɨr kit,” məto neen kotəmə, “Kəpə, in tateiuə-in əm netəmim əpəh.” ");
INSERT INTO tnn_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Məto ilat koatəgin rəhalat netəm-iasol mɨn, kən kit təməsən-iarəpən Iesu əpəh e nɨki netəmim məmə netəmim okotəto. ");
INSERT INTO tnn_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Lafet əh, kəmol o wik apiəpiə kit, kən ilugɨn e lafet u, Iesu in təmuwɨn əpəh e Nimə Rəha Uhgɨn, matəgətun netəmim. ");
INSERT INTO tnn_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Kən netəm-iasol rəha netəm Isrel, narmɨlat təmiwɨg pɨk, kən kotəmə, “?Suah u təmahrol mɨtun natɨmnat mɨn u e Naoa Rəha Uhgɨn? Rəhatat kit etəm-iasol təsəgətunən lan, ne.” ");
INSERT INTO tnn_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Kən Iesu təmən-ipən kəm ilat məmə, “Nəghatən mɨn u itəm iatəgətun netəmim lan, sənəmə rəhak əm. Ilat kotɨsɨ-pən e Tata Uhgɨn itəm təmahl-ipa io ekuwa. ");
INSERT INTO tnn_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","“Kən okəmə suah kit rəhan nətəlɨgən təskasɨk məmə otol natɨmnat mɨn itəm Uhgɨn tolkeike, kən in otɨtun məmə nəghatən mɨn u rəhak, ilat koatɨsɨ-pən o Uhgɨn, sənəmə rəhak atɨp əm. ");
INSERT INTO tnn_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Etəmim itəm tatəghat-in atɨp əm rəhan nepətən, in tətalkut atɨp əm ron, məmə otiuw rəkɨs netəmim, kən kotos-ipər nərgɨn ron. Məto etəmim itəm tolkeike məmə netəmim okotɨləs-ipər nərgɨ etəm təmahl-ipən in tuwa, in etəmim rəha nənən nɨpahrienən, in sənəmə etəm tateiuə. ");
INSERT INTO tnn_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses təmos-ipɨnə Lou kəm itəmat, məto itəmat kitiəh ne təsol-wɨrən Lou əh ne. ?Itəmat nakotəmə onəkotohamnu io o naka?” ");
INSERT INTO tnn_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Kən nɨmanin netəmim kotəmə, “!Nəman! !Narmɨn rat kit un tətatɨg lam! ?Pah təmə otoh ik ne?” ");
INSERT INTO tnn_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Kən Iesu təmən-ipən kəm ilat məmə, “Io emol wək kitiəh əm, kən itəmat rafin, narmɨtəmat tatiwɨg ron. ");
INSERT INTO tnn_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Məto itəmat mɨn nəkotol wək e Sapat, noatəhg-ipən nɨsualkələh e nian əh, moatətəu-pən Lou rəha Moses. (Nɨpahrienən, sənəmə Moses ətuatɨp in təmətuoun nolən əh, məto tɨpɨtəmat mɨn ilat kəmotətuoun.) ");
INSERT INTO tnn_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Məto nian rafin, itəmat noatəhg-ipən nɨsualkələh e nian rəha Sapat moatol məmə onasotətgəhlən Lou rəha Moses. ?Kən təhrol neməha tatol itəmat məto-inu io emol-wɨr agɨn nɨpətɨ etəmim e nian rəha Sapat? ");
INSERT INTO tnn_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Otapəs nakilən nolən rəhak u itəm nəmotəplan əm e nɨganəmtɨtəmat, məto itəmat onəkotəkəike motakil rəhak nolən e nətəlɨgən itəm tətuatɨp.” ");
INSERT INTO tnn_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Kən e nian əh, netəm Jerusalem neen kotəmə, “?Təhrol əh? ?Suah u inu, netəm-iasol kotəmə okotohamnu? ");
INSERT INTO tnn_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Məto otəplan-tu. In tɨnatəgətun-arəp əm netəmim əpəh e nɨganəmtɨ netəmim məto suah kit təsəhaiən in ron. ?Təhrol okəm-naka netəm-iasol mɨn kɨnotɨtun rəkɨs məmə in Kristo itəm Uhgɨn təmən məmə otahl-ipa? ");
INSERT INTO tnn_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Məto kitat kotɨtun ikɨn suah u təmɨsɨ-pən ikɨn. Məto nian Kristo in otuwa, okol suah kit təsɨtunən ikɨn in tatɨsɨ-pən ikɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Kən e nian əh, Iesu in tatəgətun netəmim e Nimə Rəha Uhgɨn. Kən in təmagət əfəməh matən-iarəp məmə, “Nɨkitəmat təht məmə nəkotɨtun io, kən motɨtun mɨn ikɨn emɨsɨ-pən ikɨn, məto itəmat nəkotəruru. Io, eməsuwamən e nətəlɨgən əm rəhak. Uhgɨn təmahl-ipa io ekuwa. Kən Uhgɨn, in nɨpahrienən. Itəmat nəkotəruru in, ");
INSERT INTO tnn_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","məto io ekɨtun, məto-inu io emɨsɨ-pən lan. Kən in təmahl-ipa io ekuwa.” ");
INSERT INTO tnn_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","O nat u, ilat kəmotolkeike məmə mopael mɨn okotaskəlɨm Iesu, məto kit təməsea-pənən mek, məto-inun təsolən əh nian rəhan. ");
INSERT INTO tnn_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Məto e nɨmanin netəmim ikɨn əh, ilat tepət kəmotahatətə lan, kən motəmə, “Okəmə Kristo tuwa, kən in okol təsolən nəmtətin tepət taprəkɨs-in itəm suah u Iesu tatol.” ");
INSERT INTO tnn_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Kən nian Farisi mɨn kəmotəto nɨmanin netəmim kotasiwɨn-asiwɨn e Iesu nulan, ilat ne pris asol mɨn kəmotahl-ipən mopael mɨn itəm kotətul o Nimə Rəha Uhgɨn məmə okotaskəlɨm Iesu. ");
INSERT INTO tnn_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kən Iesu təmən-ipən kəm ilat məmə, “Io ekətatɨg nian təkuəkɨr əm kitat min itəmat, kən uarisɨg, ekɨtəlɨg-pən mɨn o etəm təmahl-ipa io. ");
INSERT INTO tnn_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","E nian u, itəmat onəpanotegəs-in io, məto okol nəsotehmən io; məto-inu ikɨn əh, itəm oekuwɨn ikɨn, okol itəmat nəsotuwamən ikɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Kən netəm-iasol mɨn rəha netəm Isrel kɨnotətapəh-ətapəh olat mɨn məmə, “?In otuwɨn hiə əh məmə kitat okəsotəplanən in? ?Otuwɨn o noanol mɨn neen rəha netəm Isrel itəm kotatɨg e nəptən pɨsɨn pɨsɨn mɨn ilat netəm Kris, məmə otəgətun netəm Kris? ");
INSERT INTO tnn_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","In tatən məmə e nian əh, kitat okotegəs-in in, məto kəsotehmən in, məto-inun ikɨn əh in tatuwɨn ikɨn, okol kitat kəsotuwɨnən ikɨn. ?Nəghatən u, nɨpətɨn tatən naka?” ");
INSERT INTO tnn_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Namnun nian rəha lafet əh, in iahgin taprəkɨs-in nian mɨn neen rəha lafet. Kən e nian əh, Iesu təmətul əpəh e nɨganəmtɨ netəmim magət əfəməh məmə, “!Etəmim itəm tatoaoa, pəs in otuwa ron io, mənim! ");
INSERT INTO tnn_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Etəmim itəm tətahatətə lak, in tahmen e nəghatən rəha Naoa Rəha Uhgɨn u tatən nulan məmə, ‘Nəhau itəm tatos-ipən nəmegəhən pahrien, in otɨsɨ-pən e nɨkin, tahmen e nəmtɨ nəhau itəm tɨtapuəl-apuəl matər mətaiu e nɨkin.’” ");
INSERT INTO tnn_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iesu təmən nəghatən u, matəghat-in Narmɨn Rəha Uhgɨn u uarisɨg in otəpanos-ipən kəm netəm mɨn u itəm kotahatətə lan. Məto e nian əh, Narmɨn Rəha Uhgɨn, təsuwamən əh e netəmim, məto-inu kəsɨləs-ipərən əh Iesu. ");
INSERT INTO tnn_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nian netəmim əh-ikɨn kəmotəto nəghatən u, kən neen kotəmə, “Suah u, in ien rəha Uhgɨn u, aupən kəmatəghat-in.” ");
INSERT INTO tnn_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Məto neen mɨn ilat kotəmə, “Suah u, in Kristo itəm Uhgɨn təmən məmə otahl-ipa.” Məto in pɨsɨn mɨn neen kotən məmə, “?Nɨkitəmat təht məmə Kristo itəm Uhgɨn təmən məmə otahl-ipa tɨtun nɨsɨ-pənən e netəm Kalili? ");
INSERT INTO tnn_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Naoa Rəha Uhgɨn tatən məmə Kristo itəm Uhgɨn təmən məmə otahl-ipa otəkəike masɨpən e noanol rəha Tefɨt, e taon u Petlehem, imə Tefɨt aupən.” ");
INSERT INTO tnn_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tol nəhlan, kən nɨmanin netəmim mɨn u, kəmotoor ilat mɨn o Iesu. ");
INSERT INTO tnn_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Kən neen kotəmə okotaskəlɨm in, məto etəmim kit təməsea-pənən mek. ");
INSERT INTO tnn_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kən mopael mɨn kəmotɨtəlɨg motuwɨn o pris asol mɨn ne Farisi mɨn, kən netəm-iasol mɨn əh kəmotətapəh olat məmə, “?Təhrol nəsotɨləsən Iesu motuwa?” ");
INSERT INTO tnn_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Kən mopael mɨn un kotən-ipən kəm ilat məmə, “!Eməsotɨləsən məto-inun suah kit təsəghatən tahmen e suah əh!” ");
INSERT INTO tnn_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Kən Farisi mɨn kəmotən-ipən kəm ilat məmə, “?Tahro? ?In tɨneiuə-in mɨn itəmat? ");
INSERT INTO tnn_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","?Nəmotəplan rəkɨs rəhatat kit etəm-iasol o Farisi kit təmatahatətə lan? ");
INSERT INTO tnn_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Məto netəm əpnapɨn mɨn, ilat kotəruru agɨn Lou rəha Moses, tol nəhlan, Uhgɨn otərəkɨn ilat.” ");
INSERT INTO tnn_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Kən Nikotimas u in Farisi kit, in əh-ikɨn ilat min. Suah u inu aupən təmuwɨn matəghat kəm Iesu. Kən in təmən-ipən kəm ilat məmə, ");
INSERT INTO tnn_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“?Təhrol? ?Tətuatɨp e Lou rəhatat məmə kitat okotən-iarəp nalpɨnən rəha etəmim itəm kitat kəsotaupənən motɨtun wɨr, kənu, məsotehm ətuatɨpən nat naka itəm in tatol?” ");
INSERT INTO tnn_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Kən ilat kəmotən-ipən kəm in məmə, “?Təhrol? ?Ik mɨn un ik etəm Kalili? Uwɨn-tu mafin mɨn Naoa Rəha Uhgɨn. Ik onəkəplan məmə ien kit okol təsɨsɨ-pənən Kalili.” E kopi oas mɨn neen rəha Niutesteman itəm kəməte e nəghatən Kris aupən, nəghatən u Jon 7:53—8:11 tɨkə. ");
INSERT INTO tnn_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kən netəmim kɨnotɨtəlɨg-pən mɨn motuwɨn latuənu mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Məto Iesu təmuwɨn əpəh e nɨtot u, nərgɨn un, Nɨtot Rəha Nɨg U Olif. ");
INSERT INTO tnn_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kəmən lawɨgin, laulaugɨn agɨn-əh, kən Iesu təmɨtəlɨg-pən mɨn e Nimə Rəha Uhgɨn. Kən netəmim tepət kəmotuwa, motuəfɨmɨn ilat mɨn ron, kən Iesu təməpələh mɨnətuoun matəgətun ilat. ");
INSERT INTO tnn_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Kən nəgətun mɨn rəha Lou ne Farisi mɨn kəmotɨləs pətan kit motuwa ron. Kən motol in tətul aupən e nɨganəmtɨlat. Pətan un, netəmim kəmotəplan məmə in tətapɨl ilau iərman kit sənəmə rəhan ətuatɨp iərman. ");
INSERT INTO tnn_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Kən ilat kəmotən-ipən kəm Iesu məmə, “Iəgətun, pətan u netəmim kəmotəhtɨmɨs in məmə in tətapɨl ilau iərman kit u, məto sənəmə rəhan iərman ətuatɨp. ");
INSERT INTO tnn_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","E Lou rəhatat, Moses təmələhəu nəghatən kit tatən məmə, pətan tol nulan, kitat kotəkəike motaht e kəpiel apɨn motahtɨmnu. ?Məto ik, rəham nətəlɨgən təhrol?” ");
INSERT INTO tnn_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ilat kəmotətapəh nəhlan, məmə okotol noa eko-eko, pəs ilat motəplan-pən nolən rat neen lan, kən ilat kotɨtun nakilən nolən rəhan ron. Məto Iesu təpnapɨn əm, moeg-oeg matəte nat e nɨsɨp e noanelmɨn. ");
INSERT INTO tnn_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ilat kəmoatətapəh-in nəghatən u kəm in, moatuwɨn moatuwɨn, kən in tətul, kən mən-ipən kəm ilat məmə, “Okəmə itəmat kit u ikɨn-u, in təsolən nolən rat nian kit ne, pəs in otaupən maht pətan u.” ");
INSERT INTO tnn_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kən in təmoeg-oeg mɨn, matəte nat e nɨsɨp e noanelmɨn. ");
INSERT INTO tnn_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kən nian ilat kəmotəto nəghatən rəhan, kɨnotan kitiəh kitiəh, moatagɨm. Naguɨhl-aguɨhl mɨn kotaupən moatiet kitiəh kitiəh, motapəs əm Iesu ne pətan un. ");
INSERT INTO tnn_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kən Iesu təməg-ətuatɨp mɨn mən-ipən kəm pətan un məmə, “?Pətan, netəm mɨn u kəmotahruwɨn? ?Kit təsuwamən məmə otən-iarəp rəham nalpɨnən?” ");
INSERT INTO tnn_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Kən pətan un təmən-ipən kəm in məmə, “Etəm-iasol, ilat kotɨkə.” Kən Iesu tən-ipən məmə, “Io mɨn, okol esən-iarəpən rəham nalpɨnən. Məto atuwɨn, mol namnun e nolən rat mɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Kən Iesu təmatəghat mɨn kəm ilat, matən məmə, “Io u, io Nəhag-əhagən rəha netəmim u e nətueintən. Etəmim itəm tatətəu-pa io, okol in təsaliwəkən e napinəpən nian kit ne, məto in otos nəhag-əhagən e nəmegəhən rəhan.” ");
INSERT INTO tnn_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Kən Farisi mɨn kəmotən-ipən kəm in motəmə, “!Ik nəkatən-iarəp ik nulan, məto suah kit təsolən rəham nəfɨgəmən, kən tol nəhlan, rəham nəghatən okol təsətulən!” ");
INSERT INTO tnn_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Kən Iesu tən-ipən məmə, “Əwəh, nɨpahrienən məmə io atɨp əm iatən-iarəp io. Məto rəhak nəghatən in tatətul əh, məto-inun, io ekɨtun ikɨn iatɨsɨ-pən ikɨn, kən mɨtun mɨn ikɨn iatuwɨn mɨn ikɨn, məto itəmat nəkotəruru ikɨn iatuwɨn ikɨn, kən motəruru ikɨn iatɨsɨ-pən ikɨn. ");
INSERT INTO tnn_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Itəmat u, nakotakil nolən rəha etəmim e nətəlɨgən rəha etəmim əm. Məto io esakilən nolən rəha etəmim nəhlan. ");
INSERT INTO tnn_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Məto okəmə io, iakakil nolən rəha netəmim, oekol e nolən itəm tətuatɨp, məto-inu sənəmə ekakil e nətəlɨgən əm rəhak, məto itɨmlau Tata Uhgɨn itəm təmahl-ipa io, rəhatɨmlau nakilən in kitiəh əm. ");
INSERT INTO tnn_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","E Lou rəhatəmat, kəməte məmə, okəmə etəmim kəiu, kətioal nəfɨgəmən o nəghatən kit, kən nəghatən u, in otatətul. ");
INSERT INTO tnn_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Kən roiu əh, io iatən-iarəp io, məto rəhak Tata itəm in təmahl-ipa io iakuwa, in mɨn tatol nəfɨgəmən ron io.” ");
INSERT INTO tnn_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kən tol nəhlan, ilat kɨnotətapəh ron məmə, “?Məto rəham Tata in hiə?” Kən in təmə, “Itəmat nəkotəruru io, kən itəmat nəkotəruru mɨn rəhak Tata. Okəmə itəmat nəkotɨtun io un, kən nəkotɨtun mɨn rəhak Tata.” ");
INSERT INTO tnn_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iesu təmən nəghatən u, nian in təməgətun netəmim əpəh e ikɨn kit itəm katələhəu-pən məni ikɨn e Nimə Rəha Uhgɨn. Məto suah kit təməsuwɨnən maskəlɨm in, məto-inun təsolən əh nian rəhan. ");
INSERT INTO tnn_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Kən Iesu təmatən-ipən mɨn kəm ilat məmə, “Io ekagɨm tənin itəmat, kən itəmat onakoategəs-in io. Məto itəmat onəkotɨmɨs, kən təfagə rat u rəhatəmat otatɨg əh etəmat. Ikɨn əh iakatuwɨn ikɨn, okol itəmat nəsotuwamən ikɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Kən netəm Isrel, ilat kotəmə, “?Nəghatən əh Iesu tatən məmə, ikɨn əh in tatuwɨn ikɨn, okol kitat kəsotuwɨnən ikɨn, nɨpətɨn tatən naka? ?Okəm-naka in otohamnu atɨp in, o?” ");
INSERT INTO tnn_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Kən Iesu təmən-ipən kəm ilat məmə, “Imatəmat u ikɨn-u, məto io, io imak əh ilɨs ikɨn əh, kən emɨsɨ-pən ikɨn, meiuaiu-pa. Itəmat netəmim rəha nətueintən u. Məto io, sənəmə etəm rəha nətueintən u. ");
INSERT INTO tnn_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Tol nəhlan, iatən-ipɨnə kəm itəmat məmə, itəmat onəpanotɨmɨs e nolən rat mɨn rəhatəmat, məto-inu okəmə itəmat nəsotahatətəən lak məmə Io u inu, kən itəmat onəkotɨmɨs, kən nolən rat mɨn rəhatəmat okotatɨg agɨn-əh etəmat.” ");
INSERT INTO tnn_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Kən ilat kəmotətapəh ron motəmə, “!Ei! ?Ik pah un?” Kən in təmən-ipən kəm ilat məmə, “Io ekahmen əm məmə inun ematən kəm itəmat aupən, mətoarus-pa u-roiu. ");
INSERT INTO tnn_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Natɨmnat tepət itəm ekɨtun nənən etəmat, kən mɨtun nakilən nolən mɨn rəhatəmat ron, məto etəmim itəm təmahl-ipa io, rəhan nəghatən in nɨpahrienən əm. Io iatən-iarəp əm natɨmnat mɨn itəm eməto ron, məmə netəmim rəha nətueintən ilat okotəto.” ");
INSERT INTO tnn_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Məto ilat kəsotɨtunən məmə Iesu in tatəghat-in Tata Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Tol nəhlan, in tən-ipən kəm ilat məmə, “Nian nəmotɨləs-ipər rəkɨs Netɨ Etəmim un, nəpanotɨtun məmə Io u inu. Kən onəpanotɨtun mɨn məmə esol atɨpən nat kit e rəhak əm nətəlɨgən. Iatən əm natɨmnat itəm Tata Uhgɨn təməgətun io lan. ");
INSERT INTO tnn_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Etəm təmahl-ipa io ekuwa, in tətatɨg itɨmlau min. In təsapəsən io ekan pɨsɨn, məto-inu, nian rafin, iatol natɨmnat mɨn itəm nɨkin tagien ron.” ");
INSERT INTO tnn_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nian Iesu təmatən nəghatən mɨn əh, netəmim tepət kəmotən nɨpahrienən lan. ");
INSERT INTO tnn_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kən Iesu təmən-ipən kəm netəm Isrel mɨn itəm kəmotən nɨpahrienən lan məmə, “Okəmə nakotaskəlɨm əskasɨk nəghatən mɨn u rəhak, itəm iatən-ipɨnə kəm itəmat, itəmat ətuatɨp un, rəhak netəmim mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kən itəmat onəkotɨtun nɨpahrienən, kən nɨpahrienən u, otɨkɨs itəmat məmə nakəsotuwa-mɨnən kol slef.” ");
INSERT INTO tnn_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Kən ilat kəmotən-ipən kəm in məmə, “Itɨmat u noanol mɨn rəha Epraham, itɨmat u esotol agɨn-əhən slef mɨn rəha suah kit. ?Təhrol nəmən nəghatən u məmə, ‘Nɨpahrienən otɨkɨs itəmat, nakotapiə.’?” ");
INSERT INTO tnn_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Kən Iesu tən-ipən kəm ilat məmə, “Nɨpahrienən agɨn u iatən-ipɨnə kəm itəmat, netəmim itəm koatol nolən rat, kən nolən rat u, in tatərəmərə elat, kən mətaskəlɨm ilat matol ilat koatuwa rəhan slef mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kən slef, rəhan etəm-iasol təsegəhan-inən məmə otatɨg e nimə rəhan. Məto iərəmerə tategəhan-in məmə nətɨn otətatɨg e nimə rəhan nian rafin matuwɨn matuwɨn namnun tɨkə. ");
INSERT INTO tnn_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","!Tol nəhlan, okəmə Nətɨ Uhgɨn tatɨkɨs itəmat, kən tatɨkɨs agɨn pahrien itəmat, kən itəmat nakəsotuwa-mɨnən kol slef! ");
INSERT INTO tnn_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ekɨtun məmə itəmat noanol mɨn rəha Epraham, məto noategəs-in suatɨp məmə onəkotohamnu io, məto-inu nəsotolkeikeən məmə onəkotətəlɨg-in rəhak nəghatən. ");
INSERT INTO tnn_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Io iatən natɨmnat mɨn un, itəm eməplan rəhak Tata təmol. Məto itəmat noatol natɨmnat mɨn u itəm rəhatəmat əm tata təmən kəm itəmat.” ");
INSERT INTO tnn_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Kən ilat kəmotən-ipən kəm in məmə, “Məto tata rəhatɨmat, in Epraham.” Kən Iesu təmən-ipən kəm ilat məmə, “Okəmə itəmat noanol ətuatɨp mɨn rəha Epraham, kən itəmat onəkotos rəhan nolən mɨn, tahmen lan təmatol aupən. Məto itəmat sənəmə noanol ətuatɨp rəhan. ");
INSERT INTO tnn_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Io iatən-iarəp nəghatən pahrien kəm itəmat itəm iakatəto o Uhgɨn, məto itəmat nakotən məmə onəkotohamnu io. ?Nɨkitəmat təht məmə nolən rəha Epraham tol nəhlan? ");
INSERT INTO tnn_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Itəmat nakotətəu-pən əm nolən rəha tata rəhatəmat əm.” Kən ilat kəmotən-ipən kəm in məmə, “Itɨmat u sənəmə nɨsualkələh lapɨn. Uhgɨn əm in Tata rəhatɨmat.” ");
INSERT INTO tnn_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Kən Iesu tən-ipən kəm ilat məmə, “Okəmə Uhgɨn pahrien in Tata rəhatəmat, kən itəmat onəkotolkeike io, məto-inu io emɨsɨ-pən lan, muwa ikɨn-u. Məto in sənəmə rəhatəmat Tata. Io esuwamən ikɨn-u e rəhak atɨp əm nətəlɨgən, emuwa məto-inu in təmahl-ipa io. ");
INSERT INTO tnn_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","?Məto təhrol nakəsotɨtunən nɨpətɨ nəghatən rəhak? !Məto-inun nəsotolkeike agɨn-əhən məmə onəkotəto rəhak nəghatən! ");
INSERT INTO tnn_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Itəmat, rəhatəmat nolən tahmen əm e nolən rəha tata rəhatəmat, Setan. Kən nian rafin itəmat nakotolkeike nolən noan. Nolən rəhan itəm təmatol e nətuounən, tatol əh, in etəmim rəha nohamnuən itəm. In tatetəhau nɨpahrienən, məto-inu nɨpahrienən tɨkə lan. Nian in tateiuə, in tatol əm rəhan nolən, məto-inu in etəmim rəha neiuəən, kən in tata rəha neiuə mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Məto io iatən nɨpahrienən əm kəm itəmat, kən tol nəhlan, itəmat nəsotahatətəən e rəhak nəghatən. ");
INSERT INTO tnn_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","?Təhrol? ?Itəmat kit u ikɨn-u tɨtun nəgətunən məmə io emol nolən rat kit? ?Okəmə io ekatən əm nəghatən pahrien mɨn, kən təhrol itəmat nəsotahatətəən lak? ");
INSERT INTO tnn_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Etəmim rəha Uhgɨn, in tatətəlɨg-in nəghatən rəha Uhgɨn, məto itəmat sənəmə netəmim rəha Uhgɨn. Tol nəhlan, nəsotətəlɨg-inən nəghatən rəha Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Kən netəm Isrel kəmotəhai Iesu motəmə, “!Nəman! !Itɨmat enotəplan ətuatɨp ik! Ik etəm Sameria kit. !Ik, narmɨn rat kit tətatɨg lam!” ");
INSERT INTO tnn_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Məto Iesu təmə, “Narmɨn rat tɨkə lak, məto io iatɨləs-ipər nərgɨ rəhak Tata, kən məto itəmat, nakotərəkɨn nərgək. ");
INSERT INTO tnn_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Io esalkutən o rəhak nərɨg asol, məto suah kit in tətalkut ron io. Kən in otəpanakil netəmim rafin. ");
INSERT INTO tnn_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nɨpahrienən agɨn u iatən-ipɨnə kəm itəmat məmə, etəmim itəm tatol nəwiak, okol in təsɨmɨsən nian kit ne.” ");
INSERT INTO tnn_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Kən netəm mɨn un kotən-ipən kəm in məmə, “!Roiu enotɨtun məmə narmɨn rat kit tətatɨg lam! Epraham təmɨmɨs, kən ien mɨn kəmotɨmɨs mɨn, məto ik nakatən məmə, etəmim itəm tatol nəwiam, in okol təsɨmɨsən nian kit. ?Nəghatən naka u? ");
INSERT INTO tnn_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","?Ik nakaprəkɨs-in Epraham u tɨpɨtɨmat tɨnəmɨmɨs rəkɨs? ?Kən ne ien mɨn u kəmotɨmɨs? ?Ik nakəmə ik etəmim naka?” ");
INSERT INTO tnn_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Kən Iesu tən-ipən məmə, “Okəmə io əm iatɨləs-ipər atɨp io, kən rəhak nɨsiaiiən in nat əpnapɨn əm. Məto rəhak Tata u itəmat nakoatən məmə in Uhgɨn rəhatəmat, inun in tatɨləs-ipər io matos-ipən nɨsiaiiən kəm io. ");
INSERT INTO tnn_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Itəmat nəkotəruru in, məto io ekɨtun. Okəmə ekən məmə ekəruru in, kən in otol io məmə io etəmim rəha neiuəən, tahmen əm etəmat. Məto io ekɨtun in, kən io matol nəwian. ");
INSERT INTO tnn_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tɨpɨtəmat u Epraham, nɨkin təmagien pɨk məmə in otəpanəplan nian rəhak otuwa. Kən nian in təmɨtun məmə rəhak nian otəkəike muwa, kən nɨkin təmagien təmagien.” ");
INSERT INTO tnn_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Kən netəm mɨn u kəmotəhai motəmə, “!Nəman! !Ik nəsosən əh nup fifti ne! ?Nəmahrol məplan Epraham?” ");
INSERT INTO tnn_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Kən Iesu təmə, “Nɨpahrienən agɨn u iatən-ipɨnə kəm itəmat məmə, nian Epraham təməsaiirən əh, məto Io Etatɨg.” ");
INSERT INTO tnn_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Kən əmun, ilat kəmotəmɨk kəpiel apɨn, motəmə okotaht Iesu lan; məto Iesu təməhluaig, kən miet e Nimə Rəha Uhgɨn, mɨnatuwɨn. ");
INSERT INTO tnn_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Kən nian kit, Iesu təmaliwək mətan, kən məplan suah kit. Nian təmaiir, məto nɨganəmtɨn təpɨs. ");
INSERT INTO tnn_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Kən netəmim mɨn rəha Iesu kəmotən-ipən kəm in məmə, “Iəgətun, suah u təmaiir məto nɨganəmtɨn təpɨs. ?O naka? ?O nolən rat rəhan, o nolən rat rəha tata ne mama rəhan?” ");
INSERT INTO tnn_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Məto Iesu təmə, “Nɨganəmtɨ suah u təmərat, məto sənəmə e nolən rat rəhan, o e nolən rat rəha tata ne mama rəhan. Məto, nɨganəmtɨ suah u təməpɨs nəhlan məmə Uhgɨn otəgətun rəhan wək e nəmegəhən rəhan. ");
INSERT INTO tnn_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nian tatian əh, kitat kotəkəike kol wək rəha Uhgɨn, itəm təmahl-ipa io ekuwa. Nian lapɨn otəpanuwa, kən etəmim in təruru nolən wək. ");
INSERT INTO tnn_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nian io etatɨg əh e nətueintən u, io Nəhag-əhagən rəha netəmim e nətueintən.” ");
INSERT INTO tnn_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nian Iesu təmən rəkɨs nəghatən əh, təmagəh nɨsɨp, kən mol nəmɨt əkəku lan, kən mos nəmɨt un, mol-pən e nɨganəmtɨ suah un. ");
INSERT INTO tnn_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Kən Iesu mən-ipən kəm in məmə, “Onəkuwɨn e noan nəhau Saeloam, kən mau nɨganəmtɨm.” (Nərgɨn u Sailom, nɨpətɨn təmə, “Kəmahl-ipən”). Kən suah un təmuwɨn, mau nɨganəmtɨn. Nian təmɨtəlɨg-pa, məto nɨganəmtɨn tɨnəwɨr, kən tɨnatehm nat. ");
INSERT INTO tnn_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kən netəmim iman ikɨn, ne netəm mɨn u itəm kotɨtun in, məmə in etəmim kit nian rafin tateasiə o məni o netəmim, ilat narmɨlat təmiwɨg pɨk ron. Kən kɨnotətapəh-ətapəh olat mɨn məmə, “!Ei! !Otəplan-tu! ?Suah u inu, nian rafin tatəpələh mateasiə o məni o netəmim?” ");
INSERT INTO tnn_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Kən netəmim neen koatəmə, “Əwəh, in əh.” Kən məto neen kotəmə, “Kəpə. Tahmen əm lan, məto sənəmə in.” Məto suah un təmə, “!Io u inu!” ");
INSERT INTO tnn_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Kən ilat kəmotətapəh ron məmə, “?Nɨganəmtɨm təmahrol məwɨr?” ");
INSERT INTO tnn_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Kən in təmə, “Suah u, nərgɨn u Iesu, in təmol nəmɨt neen kən mol-pən e nɨganəmtək, kən mən məmə, ‘Uwɨn əpəh Saeloam, mau nɨganəmtɨm.’ Kən əmun, emuwɨn. Nian emau nɨganəmtək, məto nɨganəmtək tɨnəwɨr, enatehm nat.” ");
INSERT INTO tnn_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Kən ilat kəmotətapəh ron məmə, “?Məto suah un tətatɨg hiə?” Kən in təmə, “Io ekəruru.” ");
INSERT INTO tnn_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kən netəmim kəmotɨləs suah u itəm nɨganəmtɨn təməpɨs aupən, motuwɨn kəm Farisi mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Nian u, itəm Iesu təmol-pən nəmɨt e nɨganəmtɨ suah kit lan təwɨr, in nian rəha Sapat. ");
INSERT INTO tnn_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Kən Farisi mɨn kəmotətapəh ron məmə, “?Nəmahrol nɨganəmtɨm təwɨr?” Kən suah un təmən-ipən kəm ilat məmə, “Iesu təmol-pən nəmɨt e nɨganəmtək, kən ekuwɨn mau rəkɨs, kən nɨganəmtək təwɨr, iatəplan nat.” ");
INSERT INTO tnn_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Kən Farisi mɨn neen kəmotən-ipən məmə, “Suah un təsɨsɨ-pənən o Uhgɨn, məto-inun, in təsətəu-pənən Lou rəha Sapat.” Məto Farisi mɨn neen mɨn kotəmə, “?Məto tahro? Suah əh sənəmə in iol təfagə rat. Iol təfagə rat təruru nolən nəmtətin kit nulan.” Kən ilat kəmotoor ilat mɨn o nəghatən u. ");
INSERT INTO tnn_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kən ilat kəmotətapəh mɨn ron məmə, “?Suah əh təmol-wɨr nɨganəmtɨm, kən nɨkim təht məmə in etəmim naka?” Kən in təmən-ipən kəm ilat məmə, “In ien kit.” ");
INSERT INTO tnn_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Məto netəm-iasol rəha netəm Isrel kəsotənən nɨpahrienən lan məmə suah u aupən nɨganəmtɨn təməpɨs, məto roiu əh, tɨnətaiir. Tol nəhlan, ilat kəmotaun-in-pən rəhan tata ne mama kueia, ");
INSERT INTO tnn_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","kən kəmotətapəh olau məmə, “?Təhrol? ?Nətɨtəmlau u suah u? ?Itəmlau onakuən-tu məmə nian in təmaiir-pa, kən nɨganəmtɨn təpɨs? ?Okəmə nɨpahrienən, kən nɨganəmtɨn təmahrol məwɨr?” ");
INSERT INTO tnn_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Kən rəhan mama ne tata kuəmə, “Itɨmlau ekiatun məmə nətɨtɨmlau əh, kən itɨmlau ekiatun məmə təmaiir-pa, nɨganəmtɨn təpɨs. ");
INSERT INTO tnn_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Məto itɨmlau ekuəruru məmə, roiu əh, kəmahrol nɨganəmtɨn taiir. Kən itɨmlau ekuəruru mɨn məmə etəmim pah təmol nɨganəmtɨn təwɨr. Təwɨr məmə itəmat nakotətapəh ron. In tɨnepət rəkɨs, in tɨtun nənən natɨmnat mɨn rafin kəm itəmat.” ");
INSERT INTO tnn_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Rəhan tata ne mama, kəmuən nəhlan, məto-inu ilau katuəgin netəm-iasol mɨn rəha Isrel, məto-inu ilat kɨnotələhəu rəkɨs nəghatən kit məmə, etəmim itəm tatən-iarəp məmə Iesu in Kristo itəm Uhgɨn təmən məmə otahl-ipa, kən ilat okotahl-iarəp in e nimə rəha nuəfɨmɨnən. ");
INSERT INTO tnn_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Tol nəhlan, rəhan tata ne mama, ilau kəmuən məmə, “In tɨnepət rəkɨs, təwɨr məmə itəmat nakotətapəh ron, pəs in tən.” ");
INSERT INTO tnn_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","O nat u, ilat kəmotaun-in-pən mɨn suah un itəm nɨganəmtɨn təməpɨs aupən, məmə otuwa mətul aupən e nɨganəmtɨlat. Kən kəmotəhai motən məmə, “Ən nɨpahrienən kən ləs-ipər nərgɨ Uhgɨn. Itɨmat ekotɨtun məmə suah u, in iol təfagə rat.” ");
INSERT INTO tnn_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Məto suah u təmə, “Io ekəruru məmə suah u in iol təfagə rat, o kəp. Nat kitiəh əm itəm io ekɨtun. Aupən nɨganəmtək təməpɨs, məto roiu enataiir.” ");
INSERT INTO tnn_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Kən ilat kɨnotətapəh mɨn ron məmə, “?Təmahrol ik? ?Təmahrol mol-wɨr ik, kən nɨganəmtɨm təwɨr?” ");
INSERT INTO tnn_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Məto in təmə, “Enəmən-ipɨnə rəkɨs kəm itəmat, məto itəmat nəsotətəlɨg-inən io. ?Təhrol nakotəmə iakən mɨn? ?Itəmat mɨn nakotəmə rəhan u itəmat?” ");
INSERT INTO tnn_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kən ilat kəmotəhai in motən rat, motəmə, “!Ah! !Ik u rəhan etəmim! !Məto itɨmat u, netəmim rəha Moses! ");
INSERT INTO tnn_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Itɨmat ekotɨtun wɨr məmə Uhgɨn təmatəghat kəm Moses, məto suah un, ekotəruru məmə təmɨsɨ-pən hiə.” ");
INSERT INTO tnn_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Kən suah apon təmə, “!Nəman! !Narmək təmiwɨg pɨk! !Suah u in təmol-wɨr nɨganəmtək, məto itəmat nəkotəruru ikɨn təmɨsɨ-pən ikɨn! ");
INSERT INTO tnn_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kitat kotɨtun məmə Uhgɨn təsətəlɨg-inən netəm koatol nolən rat. !Məto etəm tatɨsiai-in Uhgɨn, kən matol nəwian, Uhgɨn tatətəlɨg-in! ");
INSERT INTO tnn_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","E nətuounən nian, mətoarus-pa u-roiu, kəsətoən əh suah kit məmə təmol-wɨr iganəmtɨn əpɨs kit itəm təmaiir-pa tol mihin, məto nɨganəmtɨn tɨnəwɨr. ");
INSERT INTO tnn_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Okəmə suah u təməsɨsɨ-pənən o Uhgɨn, okol təsol agɨn-əh nat kit. Məto tətuatɨp əm məmə in tatɨsɨ-pən o Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Kən ilat kəmotəhai mɨn motəmə, “!Nəman! Ik etəmim rəha nolən rat nian rafin əm, tətuoun e nian nəmaiir-pa mətoarus-pa u-roiu. ?Nakahrol məmə nakəgətun itɨmat?” Kən ilat kəmotahl-iarəp in e nimə rəha nuəfɨmɨnən. ");
INSERT INTO tnn_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Kən Iesu təməto nəghatən məmə kəmahl-iarəp suah u e nimə rəha nuəfɨmɨnən, kən in təmuwɨn məplan, kən tətapəh ron məmə, “?Təhrol? ?Ik nəkatahatətə e Nətɨ Etəmim?” ");
INSERT INTO tnn_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Kən suah un təmə, “?Etəm-iasol, etəmim un in pah? !Awi! Ən-ipa-tu kəm io, pəs io ekahatətə lan.” ");
INSERT INTO tnn_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Kən Iesu tən-ipən kəm in məmə, “Roiu əh, ik nɨnehm rəkɨs in. Suah u, mə inu io, iatəghat kəm ik u-roiu.” ");
INSERT INTO tnn_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Kən suah un tən-ipən kəm Iesu məmə, “Iərəmərə, io enatahatətə lam.” Kən in təmɨsin-pən nulɨn ron, kən matəfak kəm in. ");
INSERT INTO tnn_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Kən Iesu təmən-ipən kəm in məmə, “Io emuwa e nətueintən u məmə ekakil netəmim motoor ilat, kən tol nəhlan, netəm nɨganəmtɨlat təməpɨs, okotehm nat, kən netəm mɨn u koatehm nat, nɨganəmtɨlat otəpɨs.” ");
INSERT INTO tnn_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Kən Farisi mɨn neen əh-ikɨn, kəmotəto nəghatən lan, kən kotən-ipən kəm in məmə, “?Təhrol? ?Ik nakatən məmə nɨganəmtɨtɨmat mɨn təpɨs?” ");
INSERT INTO tnn_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Kən Iesu təmən-ipən kəm ilat məmə, “Okəmə nɨganəmtɨtəmat təpɨs, oesənən məmə itəmat nəkotəkəike motos nalpɨnən o təfagə rat mɨn rəhatəmat. Məto itəmat nakotəmə nɨganəmtɨtəmat təwɨr, nakotehm nat, kən tol nəhlan, təfagə rat mɨn rəhatəmat tətatɨg əh etəmat.” ");
INSERT INTO tnn_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Kən tən məmə, “Nɨpahrienən agɨn u iatən kəm itəmat məmə, etəmim itəm tatuwɨn imə e noanɨkulu rəha sipsip, təsuwɨn-pənən e ket, məto in tətaiu əm lan kən matiwɨgego in məmə otuwɨn imə e noanɨkulu rəha sipsip, in iakləh ne iohamnu itəm kit. ");
INSERT INTO tnn_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Məto etəmim itəm tatuwɨn-pən e ket, in etəm tatehm sipsip. ");
INSERT INTO tnn_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Etəmim itəm tatətul e ket, nian rafin in taterəh e ket o suah u, kən sipsip mɨn kotɨtun nəwian. Nian rafin in tətaun-in nərgɨ sipsip mɨn kitiəh kitiəh, kən in matit ilat moatiet. ");
INSERT INTO tnn_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nian in tatit rəhan mɨn rafin sipsip moatiet e noanɨkulu, in tətaupən-in ilat, kən sipsip mɨn koatuarisɨg-in, məto-inu kotɨtun nəwian. ");
INSERT INTO tnn_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Məto ilat kəsotətəu-pənən suah kit u itəm kotəruru, ilat okotəkəike kagɨm kapəs, məto-inu ilat kotəruru nəwian.” ");
INSERT INTO tnn_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesu təmuəh nimaa nəghatən u, məto ilat kotəruru nɨpətɨn məmə tatən naka. ");
INSERT INTO tnn_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Tol nəhlan, kən Iesu təmən-ipən mɨn kəm ilat məmə, “Nɨpahrienən agɨn u iatən kəm itəmat məmə, io u, io Ket rəha sipsip mɨn itəm koatuwɨn-pən ikɨn. ");
INSERT INTO tnn_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Netəm mɨn u itəm kotaupən-in io, ilat rafin netəmim rəha nakləhən əm ne nohamnuən itəm. Məto sipsip mɨn kol kəsotətəlɨg-inən ilat. ");
INSERT INTO tnn_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Io un, io Ket u. Etəm tatuwa-pa io ikɨn, məmə otuwɨn imə, in otos nəmegəhən. In otuwa imə, miet muwɨn ihluə e io, kən mos manuwɨhl wɨr itəm tamiəmɨtə lan. ");
INSERT INTO tnn_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Məto iakləh, in tatuwa əm o nat kitiəh əm. In tatuwa məmə otakləh kən mohamnu itəm, kən mərəkɨn-ərəkɨn natɨmnat rafin. Məto io, emuwa məmə iakol suatɨp o nosən nəmegəhən, kən nəmegəhən u, in tərioah wɨr e nəwɨrən rafin. ");
INSERT INTO tnn_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Io u, Etəmim rəha Nehm Wɨrən Sipsip Mɨn. Etəm wɨr un, itəm tatehm wɨr sipsip mɨn, in nɨkin tagien əm məmə otos-ipən nəmegəhən rəhan o sipsip mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Məto etəmim un itəm katətou məmə in otatehm sipsip mɨn, in sənəmə etəm ətuatɨp rəha nehmən sipsip. Sənəmə in rəhan əh sipsip mɨn. Kən okəmə tarəplan kuri iarupɨn kit tatuwa məmə otus ilat, kən in otaiu mapəs ilat. Kən kuri iarupɨn u, tuwɨn mus sipsip mɨn neen, kən məhgatit ilat kotagɨm kitiəh kitiəh. ");
INSERT INTO tnn_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Etəm nəhlan, in otagɨm məto-inun katətou əm in o nehmən sipsip mɨn, məto e nɨkin, in təsolən nat agɨn e sipsip mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Io u inu, io Etəmim rəha Nehm Wɨrən Sipsip Mɨn. Tata Uhgɨn in tɨtun io, kən io ekɨtun in, kən e nolən kitiəh əm, io ekɨtun rəhak sipsip mɨn, kən rəhak sipsip mɨn ilat kotɨtun io. Io nɨkik tagien əm, məmə oekɨmɨs o nosmegəhən ilat. ");
INSERT INTO tnn_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kənu rəhak mɨn neen əpəh ikɨn sipsip mɨn, itəm kəsotatɨgən e noanɨkulu u, məto io ekəkəike mit mɨn ilat kotuwa. Ilat mɨn, okəpanotɨtun nətoən nəwiak. Kənu sipsip mɨn u ilat rafin u, okotuwa motuəfɨmɨn əm ilat mɨn motol kitiəh. Kən etəmim kitiəh əm, in otatehm ilat. ");
INSERT INTO tnn_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Rəhak Tata in tolkeike pɨk io, məto-inu nɨkik tagien əm məmə oekos-ipən rəhak nəmegəhən o netəmim, məmə uarisɨg lan, io ekos mɨn nəmegəhən rəhak. ");
INSERT INTO tnn_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Etəmim kit tɨkə məmə otos-irəkɨs nəmegəhən rəhak, məto io atɨp əm ekos-ipən rəhak nəmegəhən məto-inun io əm iakolkeike mihin. Io atɨp əm iatos nepətən məmə ekəhlman rəhak nəmegəhən, kən io atɨp əm matos mɨn nepətən məmə ekaskəlɨm mɨn rəhak nəmegəhən. Nat u inu, itəm rəhak Tata təmən-ipa kəm io məmə ekəkəike mol mihin.” ");
INSERT INTO tnn_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kən netəm Isrel u, ilat kəmotoor mɨn ilat mɨn o nəghatən mɨn u. ");
INSERT INTO tnn_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ilat tepət kotən məmə, “!Suah u narmɨn rat kit tətatɨg lan! !Rəhn-kapə tətalməl! ?Təhrol itəmat nakoatətəlɨg-in?” ");
INSERT INTO tnn_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Məto neen mɨn, ilat koatən məmə, “Nəghatən u, sənəmə nəghatən rəha etəm narmɨn rat tətatɨg lan. ?Nɨkitəmat təht məmə, narmɨn rat tɨtun nol-wɨrən iganəmtɨn əpɨs, təwɨr mɨn?” ");
INSERT INTO tnn_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tɨnuwa e nian rəha netəm Isrel itəm koatol lafet kit lan Jerusalem. Nərgɨ lafet u, in lafet rəha Nol-Wɨrən Mɨn Nimə Rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","In əh e nian rəha nətəpən. Kən Iesu təmətaliwək e feranta e Nimə Rəha Uhgɨn, nərgɨn u, Feranta Rəha Kig Solomon. ");
INSERT INTO tnn_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Kən netəm Isrel neen kəmotuwa motətul, motɨtəlau in. Kəmotən-ipən kəm in məmə, “?Onəghan kən ik nəpanol itɨmat ekotɨtun ik? Okəmə ik Kristo pahrien itəm Uhgɨn təmən məmə otahl-ipa, nakən-ipa wɨr kəm itɨmat.” ");
INSERT INTO tnn_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Kən Iesu tən-ipən kəm ilat məmə, “Io enəmən-ipɨnə rəkɨs kəm itəmat, məto itəmat nəsotahatətəən lak. Nəmtətin mɨn u itəm iatol e nərgɨ rəhak Tata, ilat koatol nəfɨgəmən e nəghatən rəhak, ");
INSERT INTO tnn_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","məto itəmat nəsotahatətəən lak, məto-inun itəmat sənəmə rəhak mɨn sipsip mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Rəhak sipsip mɨn ilat koatəto nəwiak kən motɨtun. Io ekɨtun wɨr ilat, kən ilat koatuarisɨg-in io. ");
INSERT INTO tnn_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Kən io iatos-ipən nəmegəhən lilɨn u namnun tɨkə kəm ilat, ilat okol kəsotɨsɨmɨsən nian kit ne. Kən etəmim kit ne okol təsiuw rəkɨsən ilat e nelmək. ");
INSERT INTO tnn_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Rəhak Tata itəm təmos-ipa ilat kəm io, in təsanən taprəkɨs-in natɨmnat rafin. Tol nəhlan, kən suah kit okol təsiuw rəkɨsən ilat e nelmɨn. ");
INSERT INTO tnn_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Itɨmlau rəhak Tata, itɨmlau kitiəh əm.” ");
INSERT INTO tnn_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Kən netəm Isrel kəmotəmɨk mɨn kəpiel apɨn, məmə okotaht in lan. ");
INSERT INTO tnn_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Məto Iesu tən-ipən kəm ilat məmə, “Io enamol rəkɨs nəmtətin wɨr mɨn tepət e nɨganəmtɨtəmat. Nəmtətin mɨn əh ilat əh, rəhak Tata təmos-ipa məmə io ekol. ?Məto nəmtətin ahrol un itəmat nakotəmə onəkotaht io ron e kəpiel apɨn?” ");
INSERT INTO tnn_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Kən ilat kotəmə, “Itɨmat esotənən məmə ekotaht ik e kəpiel apɨn o nat pɨspɨs wɨr mɨn u ik natol. Itɨmat ekotəmə ekotaht ik məto-inu nakatən rat Uhgɨn. Ik etəmim əm, məto ik nakatən məmə ik Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Kən Iesu tən-ipən kəm ilat məmə, “Kəməte-pən aupən, e rəhatəmat ətuatɨp Lou, məmə Uhgɨn təmən-ipən kəm ilat məmə, ‘Itəmat uhgɨn mɨn.’ ");
INSERT INTO tnn_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kən kitat kotɨtun məmə Naoa Rəha Uhgɨn, okol təsəuhlinən. Uhgɨn təmos-ipən nəghatən rəhan kəm netəmim neen. ?Tol nəhlan, okəmə Uhgɨn təmatəghat-in netəm mɨn u, kən mən ilat məmə uhgɨn mɨn, ");
INSERT INTO tnn_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","kən nakotəhrol motəhai io moatən məmə io iatən rat Uhgɨn məto-inu iatən məmə io Nətɨ Uhgɨn? Io u inu, itəm Tata Uhgɨn in təmələhəu-pən io məmə rəhan pɨsɨn əm, kən mol əpen-əpenə lak, məmə otahl-ipa io ekuwa e nətueintən. ");
INSERT INTO tnn_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Okəmə esolən nəmtətin mɨn itəm rəhak Tata tatol, kən sotahatətəən lak. ");
INSERT INTO tnn_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Məto okəmə iatol nəmtətin mɨn u rəhak Tata tatol, kən nat əpnapɨn məmə itəmat nəsotahatətəən e rəhak nəghatən mɨn, məto təwɨr məmə onəkotahatətə e nəmtətin mɨn rəhak. Kən tol nəhlan, itəmat onəpanotɨtun wɨr agɨn məmə Tata Uhgɨn tətatɨg lak, kən iakətatɨg e Tata Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tol nəhlan, o nəghatən mɨn u, ilat kəmotolkeike mɨn məmə okotaskəlɨm in, məto in təmiet elat, magɨm. ");
INSERT INTO tnn_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","In təmeguəfɨmɨn-pən mɨn e nəwtain nəhau Jotan, muwɨn əpəh, aupən, Jon təmol baptais e netəmim ikɨn. Kən mətatɨg ikɨn əh. ");
INSERT INTO tnn_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Kən netəmim tepət kəmotuwa ron, kən moatən məmə, “Jon təməsolən nəmtətin kit ne. Məto nəghatən mɨn itəm in təmatən e suah u, ilat rafin nɨpahrienən əm.” ");
INSERT INTO tnn_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kən ikɨn əh, netəmim tepət kəmotahatətə e Iesu. ");
INSERT INTO tnn_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Etəm Petani kit, nərgɨn u Lasaros, tatɨmɨs. Petani, in latuənu kit, ima Meri ne pian Mata. ");
INSERT INTO tnn_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Meri u, inu, uarisɨg otəpənau nelkɨ Iərəmərə rəhatat e senta, kən mafəl e noanun, təmiəg. Kən pətan u, rəhan u kaka Lasaros u tatɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Tol nəhlan, wɨnɨ Lasaros mil kuahl-ipən nəghatən o Iesu məmə, “Etəm-iasol, ik kit u itəm nakolkeike pɨk, in tatɨmɨs.” ");
INSERT INTO tnn_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nian Iesu təməto nəghatən u, kən in təmə, “Lasaros tatɨmɨs, məto rəhan nɨmɨsən əh, okol təsolən in tɨmɨs agɨn-əh. Nɨmɨsən əh rəhan otol məmə netəmim okotɨləs-ipər motənwiwi Uhgɨn ron. Kən nɨmɨsən əh otol məmə netəmim okotɨləs-ipər motənwiwi Nətɨ Uhgɨn ron.” ");
INSERT INTO tnn_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iesu tolkeike pɨk Mata ne pian, ne rəhalau kaka Lasaros. ");
INSERT INTO tnn_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Tol nulan, nian tatəto pap məmə Lasaros tatɨmɨs, in təmatɨg mɨn mos nian kəiu əpəh ikɨn tətatɨg ikɨn. ");
INSERT INTO tnn_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kən uarisɨg, tən-ipən kəm rəhan netəmim mɨn məmə, “Pəs kotɨtəlɨg-pən mɨn Jutia.” ");
INSERT INTO tnn_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Məto rəhan netəmim mɨn kotən-ipən kəm in məmə, “Iəgətun, roiu əm huə, netəm-iasol rəha Jutia kəmotəmə okotahtɨmnu ik e kəpiel apɨn. ?Məto ik nakən məmə onakɨtəlɨg-pən mɨn ikɨn əh?” ");
INSERT INTO tnn_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Kən Iesu tən-ipən kəm ilat məmə, “Itəmat nəkotɨtun məmə tuelef aua e nərauiəgən. Okəmə etəmim tətaliwək e nərauiəgən, okol təsorinən nelkɨn e kəpiel kit, məto-inu tatəplan nat e nəhag-əhagən rəha nətueintən. ");
INSERT INTO tnn_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Məto okəmə in tətaliwək lapɨn, in tɨtun norinən nelkɨn e kəpiel kit, məto-inu rəhan nəhag-əhagən tɨkə.” ");
INSERT INTO tnn_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Iesu tɨnən rəkɨs nəghatən əh, kən in mən-ipən kəm ilat məmə, “Kitat kit u Lasaros, in tətapɨl. Məto io oekuwɨn əh-ikɨn məhgaiir lan.” ");
INSERT INTO tnn_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Kən rəhan mɨn netəmim kotən-ipən kəm in məmə, “Etəm-iasol, okəmə in tətapɨl, kən rəhan nɨmɨsən otɨkə. !In otəto təwɨr mɨn!” ");
INSERT INTO tnn_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","E nəghatən u rəha Iesu, nɨpətɨn u məmə Lasaros tɨnɨmɨs rəkɨs. Məto ilat nɨkilat təht məmə Lasaros in tətapɨl əm. ");
INSERT INTO tnn_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kən Iesu təmən-ipən wɨr məmə, “Lasaros tɨnɨmɨs rəkɨs. ");
INSERT INTO tnn_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nian nɨkik tatuəh itəmat, nɨkik tagien məmə eməsatɨgən itɨmlau min, məto-inu nat u, otasitu etəmat məmə onəkotahatətə lak. Məto təwɨr məmə pəs kotuwɨn motehm in.” ");
INSERT INTO tnn_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Kən Tomas u, kətaun-in məmə Mil Mil, in tən-ipən kəm netəmim neen mɨn rəha Iesu məmə, “Təwɨr, pəs kitat rafin kotuwɨn, məmə kitat rafin okotɨmɨs əm kitat min.” ");
INSERT INTO tnn_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nian Iesu təmiet-arəpən Petani, kən təməto məmə kəmɨtənɨm Lasaros, tɨnos nian kuwɨt rəkɨs. ");
INSERT INTO tnn_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Latuənu u Petani, in iuəhkɨr əm o Jerusalem, okəmə naka suatɨp lan tahmen e kilomita kɨsɨl, ");
INSERT INTO tnn_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","kən netəm Isrel tepət kəmotuwa məmə okotehm Mata ne Meri motɨləs-ipər nətəlɨgən rəhalau məto-inun katuəto tərat o rəhalau kaka təmɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Kən nian Mata təməto məmə Iesu tatuwa, in təmətul muwɨn məmə otəplan. Məto Meri, in təmatəpələh əm imə. ");
INSERT INTO tnn_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Kən Mata təmən-ipən kəm Iesu məmə, “Etəm-iasol, okəmə ik nəmətatɨg ikɨn-u, okol rəhak kaka təməsɨmɨsən. ");
INSERT INTO tnn_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Məto io enɨtun əh məmə nat naka onakətapəh-in kəm Uhgɨn, kən Uhgɨn otəpanos-ipɨnə kəm ik.” ");
INSERT INTO tnn_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Kən Iesu tən-ipən kəm in məmə, “Rəham kaka otəpanəmegəh mɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mata təmə, “Io ekɨtun məmə Lasaros otəpanəməgəh mɨn e Namnun Nian, itəm netəmim rafin kəmotɨmɨs okotaiir-pa mɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Kən Iesu tən-ipən kəm in məmə, “Io u, io Nəukətɨ Naiir-pa Mɨnən e Nɨmɨsən, kən io mɨn, io Nəukətɨ Nəmegəhən. Etəmim itəm in otahatətə lak, nat əpnapɨn məmə in təmɨmɨs, məto in otəmegəh mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Kən etəmim itəm tatəmegəh kən mətahatətə lak, in okol təsɨmɨs agɨn-əhən nian kit ne. ?Nəkatahatətə e nəghatən u rəhak?” ");
INSERT INTO tnn_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mata tən-ipən kəm in məmə, “Əwəh, Iərəmərə. Io enatahatətə lam, məmə ik Kristo itəm Uhgɨn təmən məmə otahl-ipa. Ik Nətɨ Uhgɨn. Ik u inun, aupən netəmim kəmoatən məmə ik onəpanuwa e nətueintən.” ");
INSERT INTO tnn_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nian Mata tɨnən rəkɨs nəghatən u, kən muwɨn məmə otən-ipən kəm pian Meri tuwa. Təmuwɨn kən masiwən-in-pən e matəlgɨn məmə, “Iəgətun tɨnuwa rəkɨs. Tolkeike məmə otəplan ik.” ");
INSERT INTO tnn_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Kən nian Meri təməto nəghatən u, təmətul uəhai əm, matuwɨn məmə otəplan Iesu. ");
INSERT INTO tnn_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Iesu in təsuwamən əh latuənu, in tatətul əh-ikɨn Mata təmuwɨn ikɨn mehm. ");
INSERT INTO tnn_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Kən nian netəm Isrel mɨn u itəm kəmoatəpələh imə ilat Meri, moatɨləs-ipər rəhan nətəlɨgən, kəmotəplan in təmətul uəhai əm matuwɨn ihluə, kən ilat kotuarisɨg-in. Nɨkilat təht məmə tatuwɨn e suwɨt, otasək. ");
INSERT INTO tnn_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Meri təmiet-arəpən u ikɨn Iesu tatətul ikɨn, kən nian təməplan Iesu, in təmɨsin nulɨn mən-ipən kəm in məmə, “Etəm-iasol, okəmə ik nəmətatɨg ikɨn-u, kən okol rəhak kaka təsɨmɨsən.” ");
INSERT INTO tnn_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nian Iesu təməplan məmə pətan u ne netəmim mɨn un ilat min koatasək, in təməto tərat pɨk, nɨkin tɨfɨm. ");
INSERT INTO tnn_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Kən in təmətapəh olat məmə, “?Nəmotɨtənɨm hiə?” Kən ilat kəmotən-ipən kəm in məmə, “Etəm-iasol, wa-tu məplan.” ");
INSERT INTO tnn_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iesu, nahwi nəmtɨn təmaiəh. ");
INSERT INTO tnn_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kən netəm Isrel mɨn u, ilat kotəmə, “Ei, netəmim. !In təmolkeike pɨk agɨn-əh suah u taprəkɨs!” ");
INSERT INTO tnn_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Məto ilat neen mɨn koatən məmə, “Suah əh in əh aupən, təmol-wɨr iganəmtɨn əpɨs. ?Kən təhrol məsən-iəhauən Lasaros məmə təsɨmɨsən?” ");
INSERT INTO tnn_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Kən Iesu təməto mɨn tərat pɨk, kən in təmuwɨn əpəh e suwɨt. Ilat kəmotɨtənɨm Lasaros əpəh e nɨpəg kəpiel kit, kən motɨləs-ipən mɨn kəpiel kit mɨn motahtosɨg-in-pən nɨpəg kəpiel lan. ");
INSERT INTO tnn_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Kən Iesu tən-ipən məmə, “Otahwin rəkɨs-tu kəpiel.” Kən Mata u, wɨnɨ Lasaros, tən-ipən kəm Iesu məmə, “Etəm-iasol, in tɨnəpien rəkɨs. Kəmɨtənɨm tɨnos nian kuwɨt rəkɨs.” ");
INSERT INTO tnn_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Məto Iesu tən-ipən kəm in məmə, “?Təhrol? ?Ik nɨnaluin məmə emən-ipɨnə rəkɨs kəm ik məmə okəmə nakahatətə lak kən onəkəplan nəsanənən asol ne nepətən əhag-əhag rəha Uhgɨn?” ");
INSERT INTO tnn_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tol nəhlan, ilat kəmotahwin rəkɨs kəpiel. Kən Iesu təmuag-pər kən məmə, “Tata, io iatən tagkiu kəm ik məto-inu nəməto rəkɨs rəhak nəghatən. ");
INSERT INTO tnn_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Kən ekɨtun məmə e nian rafin, natəto io. Məto iatən nəghatən u, o netəm mɨn u, itəm koatətul tɨtəlau-in io, məmə ilat okotahatətə məmə ik nəmahl-ipa io.” ");
INSERT INTO tnn_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kən əmun, nian Iesu tɨnən rəkɨs nəghatən u, in təmaun əfəməh məmə, “!Lasaros, ətul miet!” ");
INSERT INTO tnn_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Kən Lasaros təmətul miet, matəmɨk mətmətɨg əm nɨməhan mɨn u itəm kəməlis ətain nelmɨn ne nelkɨn ne nɨganəmtɨn ne lan. Kən Iesu tən-ipən kəm ilat məmə, “Otɨkɨs rəkɨs nɨməhan mɨn əh, pəs in taliwək.” ");
INSERT INTO tnn_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Netəm Isrel itəm kəmotuwa o Meri kən motehm natɨmnat mɨn u itəm Iesu təmol, ilat tepət kəmotahatətə lan. ");
INSERT INTO tnn_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Məto ilat mɨn neen kəmotuwɨn o Farisi mɨn, kən motən-iarəp kəm ilat rafin natɨmnat mɨn itəm Iesu təmol. ");
INSERT INTO tnn_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kən o nat u, Farisi mɨn u ne pris asol mɨn ilat kəmotaskəlɨm nuəfɨmɨnən asol kit rəhalat, kən ilat kəmotən kəm ilat mɨn məmə, “?Okotəhrol nulan? Suah əh tɨnatol nəmtətin tepət. ");
INSERT INTO tnn_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Okəmə okotapəs əm, tatol nəhlan, kən netəmim rafin okotahatətə lan, kən netəm Rom ilat okotuwa motərəkɨn Nimə Rəha Uhgɨn ne kantri rəhatat kən motos-irəkɨs ilau e nelmɨtat.” ");
INSERT INTO tnn_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kən ilat kit u, nərgɨn u Kaeafas, in pris asol agɨn e nup əh. Tol nulan, in təmən məmə, “Itəmat nəkotəruru agɨn-əh nat u. ");
INSERT INTO tnn_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","?Təhrol itəmat nəsotɨtunən? ?Itəmat nəsotɨtunən məmə təwɨr məsɨn otəmat məmə etəmim kitiəh əm otɨmɨs o netəmim, taprəkɨs-in məmə kantri apiəpiə otɨmɨs?” ");
INSERT INTO tnn_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Nian in tɨnən nəghatən u, in təməsən atɨpən e nətəlɨgən əm rəhan. In pris asol agɨn e nup əh, kən in təmaupən mən-iarəp nəghatən itəm Uhgɨn təmos-ipən kəm in. Kən in təmən məmə Iesu in otɨmɨs o nosmegəhən netəm Isrel. ");
INSERT INTO tnn_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Kən məto rəhan nɨmɨsən, sənəmə o nosmegəhən netəm Isrel əm, məto o nosməgəh mɨnən nenətɨ Uhgɨn mɨn itəm kotan atit e nətueintən, kən mol ilat kotuwa motol kitiəh əm. ");
INSERT INTO tnn_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tol nəhlan, e nian əh, ilat kəmotegəhan-in məmə okotəkəike kegəs-in suatɨp kit o nohamnuən Iesu. ");
INSERT INTO tnn_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kən o nat u, Iesu təsaliwək-arəp mɨnən ikɨn mɨn e Jutia, in təmagɨm ikɨn-u, muwɨn əpəh e taon kit, nərgɨn u Efraim. Taon u, in iuəhkɨr əm o ikɨn taruən-aruən ikɨn. Kən in mətatɨg ikɨn əh, ilat rəhan mɨn netəmim. ");
INSERT INTO tnn_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tɨnatuwa iuəhkɨr o nian rəha lafet kit rəha netəm Isrel, nərgɨn u, lafet rəha Nuhagego-inən. Kən netəmim tepət kɨnoatiet ikɨn pɨsɨn pɨsɨn mɨn mɨnoatuwa Jerusalem məmə okotol natɨmnat mɨn məmə ilat okotaruətuəh e nɨganəmtɨ Uhgɨn, paupən un, məpanotuwɨn e lafet əh. ");
INSERT INTO tnn_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Kən netəm mɨn əh kɨnoategəs-in Iesu. Kən nian kəmotuəfɨmɨn e Nimə Rəha Uhgɨn, kɨnoatətapəh-ətapəh olat mɨn məmə, “?Kəruru mə Iesu otuwa e lafet u, o kəp?” ");
INSERT INTO tnn_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Məto e nian əh, pris asol mɨn ne Farisi mɨn kəmotələhəu nəghatən kit, məmə okəmə etəmim kit tɨtun ikɨn Iesu tətatɨg ikɨn, in otəkəike muwa mən-iarəpən kəm ilat, pəs mopael mɨn kotuwɨn motaskəlɨm. ");
INSERT INTO tnn_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nian sikis əh-ikɨn tətatɨg əh kəpənan e nian rəha lafet rəha Nuhagego-inən, kən Iesu tɨnɨtəlɨg-pa mɨn Petani, imə Lasaros ikɨn. Suah u inu, Iesu in təmol in təmegəh mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kən netəmim ikɨn-u, kəmotol nagwənən kit rəha Iesu. Kən Mata in tos nagwənən, muwa. Kən Lasaros mɨn əh-ikɨn e nagwənən əh, ilat Iesu ne, koatəməhl-pən, moatagwən. ");
INSERT INTO tnn_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kən Meri təmos senta kit tatər e nuwigɨ nat, muwa. Senta u, kəmol e nokɨ nato. Senta əh, nəmiəwɨn təwɨr, kən nəmtɨn tiəkɨs. Kən in təmau nelkɨ Iesu e senta u, kən mafəl e noanun. Nəmiəwɨ senta u, təmɨrəfin nɨpəgnoa nimə. ");
INSERT INTO tnn_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Məto etəmim kit rəha Iesu, nərgɨn u Jutas Iskariot, suah un uarisɨg otəpanegəhan-in-pən Iesu e nelmɨ rəhan tɨkɨmɨr mɨn, in təməhai ron. In təmən məmə, ");
INSERT INTO tnn_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“?Ik nəkəruru nol-salɨm-in senta u, mos məni lan, kən mos-ipən kəm ian-rat mɨn? Senta u, in tahmen e tri-hanrɨt tenarius. ");
INSERT INTO tnn_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","In təmən nəhlan, məto sənəmə in tatol nat agɨn e ian-rat mɨn, məto in təmən əm, məto-inu in iakləh. In tatos kətɨm rəha məni rəhalat, kən nian neen, in tətakləh-in. ");
INSERT INTO tnn_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Məto Iesu təmə, “Əpəs-tu pətan u. Sərəkɨnən rəhan nətəlɨgən. In təmatələhəu wɨr senta u, məmə otau nɨpətɨk, o nian əh itəm okɨtənɨm io lan. ");
INSERT INTO tnn_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ian rat mɨn, nian rafin itəmat min ilat nəkotatɨg. Məto io, okol esatɨgən nian rafin kitat min itəmat.” ");
INSERT INTO tnn_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Kən nian nɨmanin netəm Jutia kəmotəto məmə Iesu tətatɨg latuənu Petani, kən ilat kɨnoatuwa ikɨn. Kəsotuwa əmən məmə okotehm Iesu, məto ilat kotuwa mɨn məmə okotəplan-tu Lasaros u təmɨmɨs, kən Iesu tol mɨn təmegəh. ");
INSERT INTO tnn_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kən əmun, pris asol mɨn, kəmotegəhan-in mɨn məmə okəkəike kohamnu mɨn Lasaros, ");
INSERT INTO tnn_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","məto-inun nian netəm Isrel tepət kəmotəplan Lasaros təməmegəh mɨn, kən ilat kəmotahatətə e Iesu, kən mɨnotapəs rəhalat netəm-iasol mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kəmən lawɨgin, nɨmanin netəmim itəm kəmoatuwa Jerusalem məmə okotol lafet rəha Nuhagego-inən, kəmotəto məmə Iesu tətaliwək mɨnatuwa e taon. ");
INSERT INTO tnn_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Kən tol nəhlan, ilat kəmotiet e taon u, moatəmɨk nat kit tahmen e nɨmalɨ nəmɨl moatuwɨn mə okotəplan Iesu. Kən moatagət əfəməh moatən məmə, “!Hosana! !Iərəmərə Uhgɨn tətatɨg ilau suah u itəm tatuwa e nərgɨn! !Iərəmərə Uhgɨn tətatɨg ilau Kig u rəha netəm Isrel!” ");
INSERT INTO tnn_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Kən Iesu təməplan nətɨ togki kit, kən tasuə lan maliwək matuwɨn. Natɨmnat mɨn u, Naoa Rəha Uhgɨn tɨnəmən rəkɨs məmə, ");
INSERT INTO tnn_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Netəm Saeon, itəmat sotəgɨnən. !Otəplan-tu! !Kig rəhatəmat tatuwa, in tɨtasuə e nətɨ togki maliwək matuwa!” ");
INSERT INTO tnn_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","E nian əh, netəmim rəha Iesu ilat kotəruru nɨpətɨ nat u. Məto uarisɨg, nian Iesu tɨnəmegəh mɨn e nɨmɨsən, kən Uhgɨn tɨnol əp rəkɨs nepətən rəha Iesu, kən nɨkilat təpanəht məmə aupən, kəməte rəkɨs nəghatən lan e Naoa Rəha Uhgɨn, kənu netəmim kɨnotol nəghatən mɨn əh tɨnuwa mɨnol nɨpahrienən lan. ");
INSERT INTO tnn_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","E nian Iesu təmaun-in Lasaros, kən Lasaros tiet e nɨpəg kəpiel məmegəh mɨn, nɨmanin netəmim tepət kəmotatɨg ilat əh-ikɨn. Kən ilat əh kəmotətul-arəp mɨnotən-iarəp natɨmnat mɨn u in təmol. ");
INSERT INTO tnn_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tol nəhlan, netəmim tepət kəmotuwa məmə okotəplan Iesu, məto-inu koatəto məmə in təmol nəmtətin əh. ");
INSERT INTO tnn_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kən Farisi mɨn kɨnoatən-ən kəm ilat mɨn məmə, “!Otəplan-tu, okol kitat kəsotol agɨn-əhən nat kit. Roiu əh, netəmim rafin e nətuounən kɨnoatuarisɨg-in!” ");
INSERT INTO tnn_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kən nian netəmim kəmotuwɨn Jerusalem məmə okotəfak e nian rəha lafet u, kən netəm Kris neen mɨn əh-ikɨn ilat min, kəmoatəfak. ");
INSERT INTO tnn_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Netəm Kris mɨn u kəmotuwa motehm Filip. Filip in etəm Petsaeta əpəh Kalili. Kən ilat kəmotən-ipən kəm in məmə, “Etəm-iasol, iakotolkeike məmə ekotəplan Iesu.” ");
INSERT INTO tnn_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Kən Filip tətul muwɨn mən-ipən kəm Antru, kən ilau kəmian muən-ipən kəm Iesu. ");
INSERT INTO tnn_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Kən Iesu təmən-ipən kəm ilat məmə, “Roiu əh, Nətɨ Etəmim, rəhan nian tɨnuwa rəkɨs, məmə Uhgɨn otol əp rəhan nepətən əhag-əhag. ");
INSERT INTO tnn_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nɨpahrienən agɨn u iatən kəm itəmat məmə, etəmim otəkəike mɨtənɨm nɨkuti nat e nɨsɨp kən otɨmɨs. Okəmə təsɨmɨsən, kən okol təsəwiəən kən məsoeən. Məto okəmə otɨmɨs, kən otoe-in noan tepət, tepət. ");
INSERT INTO tnn_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Etəm nɨkin tatəht pɨk rəhan nəmegəhən e nətueintən u, in otəmkarəpən-in. Məto etəmim itəm nɨkin təsəht pɨkən nəhlan rəhan nəmegəhən e nətueintən u, in otaskəlɨm wɨr nəmegəhən rəhan o nəmegəhən lilɨn. ");
INSERT INTO tnn_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Etəm tolkeike məmə otol wək rəhak, in otəkəike muarisɨg-in io, kən okəmə ikɨn pəhruən io ekatɨg ikɨn, kən in mɨn, in otatɨg ikɨn-u. Kən etəm tatol wək rəhak, Tata Uhgɨn otɨsiai-in.” ");
INSERT INTO tnn_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Kən Iesu təmən-ipən kəm ilat məmə, “Roiu əh, nɨkik tɨtahmə pɨk. ?Oekahrol min-nulan? Okol esənən məmə, ‘Tata, ohrəkɨs nahməən itəm tatuwa ron io.’ Natɨmnat u inu, io emuwa ron. ");
INSERT INTO tnn_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tata, ik os-ipər atɨp nərgəm.” Kən əmun, roiu agɨn-əh, ilat kəmotəto nəwian kit təmɨsɨ-pən e neai tatən məmə, “Io enɨləs-ipər rəkɨs nərgək, kən roiu əh, oekɨləs-ipər mɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kən netəmim itəm kəmotətul iuəhkɨr ron kəmotəto nəwian əh, kən ilat neen kotəmə, “!Netəmim! ?Naka u? ?Kaluəluə kit, o?” Məto neen kotəmə, “Nagelo kit əh tatəghat kəm in.” ");
INSERT INTO tnn_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Məto Iesu tən-ipən kəm ilat məmə, “Nəwian u, təməsuwamən məmə io ekəto. Məto təmuwa məmə itəmat onəkotəto. ");
INSERT INTO tnn_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Roiu əh tɨnol nian itəm Uhgɨn otakil nolən rəha netəmim e nətueintən. Roiu əh, in otoh-iəhau nəsanənən rəha Setan, iərəmərə rəha nətueintən u. ");
INSERT INTO tnn_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nian katɨləs-ipər io ilɨs, kən io oekiuw-pa netəmim rafin kotuwa ron io.” ");
INSERT INTO tnn_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","E nəghatən u, in tɨnuhapɨk e nɨmɨsən rəhan. ");
INSERT INTO tnn_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Kən netəmim kəmotən-ipən kəm in motən məmə, “Itɨmat enotəto rəkɨs e Lou rəhatat, məmə nian Kristo itəm Uhgɨn təmən məmə otahl-ipa tuwa, in otətatɨg lilɨn əm, matuwɨn namnun tɨkə. ?Təhrol ik nakatən məmə netəmim okotəkəike motɨləs-ipər Nətɨ Etəmim? ?Məto Nətɨ Etəmim u, in pah?” ");
INSERT INTO tnn_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Kən Iesu təmən-ipən kəm ilat məmə, “Nəhag-əhagən u, tətatɨg otəmat o nian təkəku əm. Kən nian nəhag-əhagən u tətatɨg otəmat, itəmat nəkotəkəike motaliwək lan. Okəmə kəpə, kən napinəpən otɨrəfin itəmat. Kən etəmim itəm tətaliwək e napinəpən, in təruru ikɨn in tatuwɨn ikɨn. ");
INSERT INTO tnn_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nian nəhag-əhagən u tətatɨg əh otəmat, itəmat nəkotəkəike motahatətə e nəhag-əhagən u məmə itəmat nakotuwa nenətɨ nəhag-əhagən.” Nian Iesu təmən rəkɨs nəghatən u kəm ilat, kən magɨm mapəs ilat muwɨn matəhluaig. ");
INSERT INTO tnn_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nat əpnapɨn məmə in tɨnol rəkɨs nəmtətin tepət e nɨganəmtɨ netəm Isrel, məto ilat kəsotahatətəən lan. ");
INSERT INTO tnn_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ien rəha Uhgɨn u Aesea, təmaupən matəghat-in rəhalat nolən. Kən nat u təmuwa məmə otol nəghatən rəhan tuwa mol nɨpahrienən lan. In təmən məmə, “?Iərəmərə, pah otahatətə e nəghatən rəhatɨmat? ?Ekoatən-iarəp, kən pah otahatətə lan? ?Kən Iərəmərə otol əp kəm pah nahgin itəm təsanən pɨk o nosmegəhən?” ");
INSERT INTO tnn_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kənu ilat kotəruru nahatətəən lan məto-inu tahmen-pən əm məmə Aesea təmən-iarəp mɨn aupən məmə, ");
INSERT INTO tnn_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“In təmol ilat məmə nɨganəmtɨlat otəpɨs. Okəmə təsəpɨsən, kən ilat okotəplan nat kən motɨtun. Kən in tɨnahtosɨg-in rəkɨs nɨkilat. Okəmə təsolən, kən ilat okotenatɨg kən motɨtun nəuhlinən nətəlɨgən rəhalat, kən motahatətə lak, ekol nəmegəhən rəhalat tuwiwi mɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ien rəha Uhgɨn, Aesea u aupən, təmən nulan məto-inun in təməplan nepətən əhag-əhag rəha Iesu, kən tol nəhlan, in tatəghat-in. ");
INSERT INTO tnn_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kən məto, netəm-iasol mɨn tepət məsɨn, ilat mɨn kəmotahatətə e Iesu. Məto ilat koatəgin nən-iarəpən məmə ilat kəmotahatətə lan, məto-inun koatəgin Farisi mɨn məmə okotahl-iarəp ilat e nimə rəha nuəfɨmɨnən, ");
INSERT INTO tnn_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","məto-inu netəm iasol mɨn u, ilat kotolkeike pɨk məmə netəmim okotənwiwi ilat, taprəkɨs-in məmə Uhgɨn nɨkin otagien olat. ");
INSERT INTO tnn_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Kən Iesu təmagət əfəməh məmə, “Etəmim itəm tətahatətə lak, sənəmə tətahatətə pɨsɨn əm lak, məto tətahatətə mɨn e Uhgɨn itəm təmahl-ipa io. ");
INSERT INTO tnn_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kən etəmim u itəm təməplan io, sənəmə təməplan əm io. In təməplan mɨn Uhgɨn u təmahl-ipa io. ");
INSERT INTO tnn_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Io u nəhag-əhagən. Emuwa e nətueintən u, məmə etəmim itəm otahatətə lak, otəsatɨgən e napinəpən. ");
INSERT INTO tnn_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Etəmim itəm tatəto rəhak nəghatən, məsolən, okol esən-iarəpən rəhan nalpɨnən, məto-inun eməsuwamən e nətueintən u məmə ekən-iarəp nalpɨnən rəha netəmim. Məto emuwa məmə ekosmegəh ilat. ");
INSERT INTO tnn_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Məto etəmim itəm tatəuhlin-pa məntaan kəm io, məsosən rəhak nəghatən, nat kit əh-ikɨn tətatɨg məmə in otən-iarəp rəhan nalpɨnən. O Namnun Nian, nəghatən mɨn u rəhak, ilat okotən-iarəp nalpɨnən rəhan. ");
INSERT INTO tnn_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tol nəhlan məto-inu nəghatən mɨn u, sənəmə rəhak pɨsɨn əm, məto Tata Uhgɨn u təmahl-ipa io, kən in təmən məmə ekəkəike muwɨn mən nəhlan, kən mol nəhlan. ");
INSERT INTO tnn_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Kən io enəmɨtun rəkɨs məmə nəghatən mɨn u, itəm in təmən-ipa kəm io, nəmegəhən lilɨn tətatɨg lan. Kən tol nəhlan, nəghatən mɨn u iakatən ilat, Tata Uhgɨn təmən-ipa kən məgətun io elat, məmə ekən mihin.” ");
INSERT INTO tnn_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Tɨnuwa mətoarus nian netəm Isrel kotol lafet lan, lafet rəha Nuhagego-inən, kən Iesu tɨnɨtun məmə rəhan nian tɨnuwa rəkɨs məmə otiet e nətueintən u, muwɨn mehm Tata Uhgɨn. Nian rafin in təmatolkeike pɨk rəhan netəmim u kotatɨg e nətueintən, kən məto roiu in tatəgətun əsas rəhan nolkeikeən rafin kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Tɨnehnaipən, Iesu ne rəhan netəmim mɨn kəmoatagwən, kən Setan tɨnatos-ipən-os-ipən rəkɨs kəm Jutas Iskariot, nətɨ Saimon, məmə in otosalɨm-in Iesu tuwɨn e nelmɨ tɨkɨmɨr mɨn rəhan. ");
INSERT INTO tnn_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iesu təmɨtun məmə Tata Uhgɨn təmələhəu-pən rəkɨs natɨmnat rafin u e nelmɨn, kən tɨnɨtun mɨn məmə in təmɨsɨ-pən o Uhgɨn, kən in otəpanɨtəlɨg-pən mɨn o Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Tol nəhlan, in təmətul, kən mapeg rəkɨs rəhan sot asol, kən mətəut-in tawɨl kit. ");
INSERT INTO tnn_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kən mɨləs pesɨn kit, mətu-pən nəhau lan, kən əmun mətuoun mətau nelkɨ rəhan mɨn netəmim, kən mətafəl e tawɨl, tawɨl u itəm in tatətəut-in. ");
INSERT INTO tnn_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Təmol mihin, muwɨn e Saimon Pita, kən Pita tən-ipən kəm in məmə, “?Iərəmərə, təhrol? Təsəwɨrən məmə ik onakau nelkək.” ");
INSERT INTO tnn_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Məto Iesu tən-ipən kəm in məmə, “Roiu ik nəkəruru nɨpətɨ nat u io iatol, məto uarisɨg un, onəpanɨtun nɨpətɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Kən Pita tən-ipən kəm in məmə, “Okol nəsauən nelkək nian kit ne.” Məto Iesu təmə, “Okəmə ekəsauən nelkəm, kən okol ik nəkəsuwamən mol rəhak etəmim.” ");
INSERT INTO tnn_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Kən Saimon Pita təmən-ipən kəm in məmə, “!Iərəmərə, okəmə tol nəhlan, kən onasauən əm nelkək, məto onakau mɨn nelmək ne rəhk-kapə!” ");
INSERT INTO tnn_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Kən Iesu tən-ipən kəm in məmə, “!Kəp! Etəm un tɨnaig rəkɨs, in tɨnəruən rəkɨs, tɨnahmen. Təwɨr əm məmə okəsau mɨnən nɨpətɨn; məto io oekəike mau mɨn əm nelkɨn. Itəmat nɨnotəruən rəkɨs. Məto sənəmə itəmat rafin agɨn-əh.” ");
INSERT INTO tnn_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Iesu tɨnɨtun rəkɨs məmə ilat pah un otegəhan-in-pən in e nelmɨ rəhan tɨkɨmɨr mɨn. Tol nəhlan, kən in tən məmə, “Sənəmə itəmat rafin agɨn-əh.” ");
INSERT INTO tnn_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nian Iesu tɨnau rəkɨs nelkɨ rəhan netəmim mɨn, kən muwɨn mɨn e rəhan napən, kən muwɨn mɨn məpələh e nəmeen e tepɨl. Kən əmun mətapəh olat məmə, “?Itəmat nəkotɨtun nɨpətɨ nat u emol roiu agɨn etəmat? ");
INSERT INTO tnn_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Itəmat nakotaun-in io məmə Iəgətun ne Iərəmərə, kən tətuatɨp əm nulan, məto-inun nɨpahrienən məmə io u, rəhatəmat Iəgətun ne rəhatəmat Iərəmərə. ");
INSERT INTO tnn_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","“Məto-inu io, io u rəhatəmat Iərəmərə ne io Iəgətun rəhatəmat, kənu io ekau nelkɨtəmat, kənu itəmat mɨn, onəkotau nelkɨtəmat mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Io emol məgətun itəmat lan, məmə itəmat onəkotol nolən kitiəh əm, məmə inu, emol mihin etəmat. ");
INSERT INTO tnn_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nɨpahrienən agɨn u iatən-ipɨnə kəm itəmat məmə, iolwək kit, in təsaprəkɨs-inən rəhan etəm-iasol, kənu iahl-ipən in təsaprəkɨs-inən etəm tɨtahləpis. ");
INSERT INTO tnn_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Roiu əh, itəmat nəkotɨtun wɨr natɨmnat mɨn u. Kən o nat u, okəmə nəkoatol nulan, kən itəmat onəkotos nəwɨrən o Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Io esənən itəmat rafin. Io ekɨtun wɨr itəmat mɨn un itəm io emɨtəpun itəmat. Məto nəghatən u rəha Naoa Rəha Uhgɨn, otəkəike muwa mol nɨpahrienən lan. Nəghatən u tatən məmə, ‘Etəmim u, aupən itɨmlau ematuagwən kələh e plet kitiəh, məto roiu, in tɨnəuhlin rəhan nətəlɨgən, mɨnatol noa kəm io.’ ");
INSERT INTO tnn_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Io iatən-iarəp natɨmnat mɨn u kəm itəmat u-roiu, nian okəsolən əh. Məto nian okatol, kən itəmat onəkotahatətə lak, məmə Io u inu. ");
INSERT INTO tnn_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nɨpahrienən agɨn u iatən-ipɨnə kəm itəmat məmə, etəmim pah itəm tatos rəhak iahləpis kən nɨkin tagien ron, tahmen-pən əm məmə in tatos mɨn io, kən nɨkin tagien ron io. Kənu etəmim itəm tatos wɨr io, kən nɨkin tagien ron io, tahmen-pən əm məmə in tatos wɨr mɨn rəhak Tata, kən nɨkin tagien ron.” ");
INSERT INTO tnn_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nian Iesu tɨnən-iarəp rəkɨs nəghatən əh, kən nɨkin təməfɨgəm pɨk, kən in təmə, “Nɨpahrienən agɨn u iatən-ipɨnə kəm itəmat məmə, itəmat kit u ikɨn-u, otegəhan-in-pən io e nelmɨ tɨkɨmɨr mɨn rəhak.” ");
INSERT INTO tnn_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kən rəhan netəmim mɨn kəmotətag-pən motəplan ilat mɨn. Nɨkilat natəht məmə kəruru məmə in tatən pah. ");
INSERT INTO tnn_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Kən ilat kit u itəm Iesu in tolkeike pɨk, in tataməhl iuəhkɨr əm o Iesu. ");
INSERT INTO tnn_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Kən Saimon Pita, in təmasgəwɨn-pən anion kəm in məmə, “Ətapəh-tu ron, məmə etəmim pah əh in tatən.” ");
INSERT INTO tnn_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kən suah əh təmiəu-iəu muwa iuəhkɨr o Iesu, kən mətapəh ron məmə, “?Iərəmərə, pah un nakatən?” ");
INSERT INTO tnn_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Kən Iesu təmə, “Io ekəmkas pɨret məsɨn, kənu meer-pən e sup, kən mos-ipən kəm in, kənu suah u, inun.” Kən əmun, in təməmkas pɨret kit, meer-pən e sup, kən mos-ipən kəm Jutas, nətɨ Saimon Iskariot. ");
INSERT INTO tnn_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kən Jutas təmos pɨret un. Kən Setan tɨnalpin rəhan nətəlɨgən. Kən Iesu tən-ipən kəm in məmə, “Nat u nakəmə nakol, uwɨn uəhai əm mol.” ");
INSERT INTO tnn_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Netəmim mɨn un rəha Iesu itəm kotəməhl tɨtəlau e tepɨl moatagwən, ilat kəsotɨtunən məmə Iesu təmən-ipən nəghatən u kəm in o naka. ");
INSERT INTO tnn_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Jutas in tɨtahtu kətɨm rəha məni rəhalat, kən ilat neen nɨkilat təht məmə Iesu təmən-ipən kəm in məmə otuwɨn mos-nəmtɨn nagwənən neen nɨgɨlat o lafet, o okəm-naka tatuwɨn otos-ipən məni neen kəm ian-rat mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Kən nian Jutas təmos rəkɨs pɨret u, təmətul miet uəhai əm. Kən tɨnapinəp rəkɨs. ");
INSERT INTO tnn_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nian Jutas tɨniet rəkɨs, kən Iesu təmə, “Roiu əh, Uhgɨn tɨnatɨləs-ipər nərgɨ Nətɨ Etəmim, kən Nətɨ Etəmim tɨnatɨləs-ipər nərgɨ Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Məto nian Nətɨ Etəmim tɨnol əp rəkɨs nepətən rəha Uhgɨn, kən Uhgɨn atɨp əm in otol əp mɨn nepətən rəha Nətɨ Etəmim. Kən in otol əm huə roiu əm. ");
INSERT INTO tnn_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Nenətɨk mɨn, okol esatɨgən tuwəh kitat min itəmat. Kən itəmat onəpanotegəs-in io, məto io iakatən mɨn əm nəghatən kitiəh əm kəm itəmat u-roiu, itəm ematən-ipən kəm netəm-iasol mɨn rəha Isrel aupən. Ematən-ipən kəm ilat məmə, ‘Ikɨn əh ekatuwɨn ikɨn, itəmat nəkotəruru nuwɨnən ikɨn.’ ");
INSERT INTO tnn_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Io iatən-ipɨnə nəghatən wi kit kəm itəmat məmə nəkotəkəike moatol. Itəmat nəkotəkəike motolkeike itəmat mɨn. Tahmen-pən əm məmə io emolkeike mihin itəmat, kənu e nolən kitiəh əm, itəmat nəkotəkəike motolkeike itəmat mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kən okəmə nakolkeike nulan itəmat mɨn, kən netəmim rafin okotɨtun məmə itəmat rəhak mɨn netəmim.” ");
INSERT INTO tnn_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Kən Saimon Pita tətapəh ron məmə, “?Iərəmərə, ik onəkuwɨn hiə?” Kən Iesu tən-ipən kəm in məmə, “Ikɨn əh io ekatuwɨn ikɨn, ik nəkəruru nətəu-pa-mən io roiu, məto uarisɨg un, onəpanuwa.” ");
INSERT INTO tnn_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Kən Pita tətapəh ron məmə, “?Iərəmərə, oekəsətəu-pənən ik u-roiu o naka? Io, nɨkik tagien əm məmə ekɨmɨs ron ik.” ");
INSERT INTO tnn_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Kən Iesu tən-ipən kəm in məmə, “?Ik nakəmə nɨkim tagien əm məmə onakɨmɨs ron io? Nɨpahrienən agɨn u iatən kəm ik məmə, mənɨg otəsɨmnənən əh, kən ik onakən mau kɨsɨl məmə nəkəruru io.” ");
INSERT INTO tnn_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Kən Iesu təmən-ipən kəm ilat məmə, “Nɨkitəmat təsahməən. Itəmat nəkotəkəike motahatətə e Uhgɨn, kən motahatətə mɨn lak. ");
INSERT INTO tnn_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","E nimə rəha Tata rəhak, noan tepət əh-ikɨn. Nəghatən u in nɨpahrienən. Okəmə təsol mihinən, okol enən-ipɨnə rəkɨs kəm itəmat. Roiu əh, io ekatuwɨn, ekol əpen-əpenə rəhatəmat. ");
INSERT INTO tnn_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kən məto-inu ekuwɨn mol apen-pena otəmat, kən io oepanɨtəlɨg-pa mɨn mos itəmat nakotuwa moatatɨg kitat min io, məmə itəmat onəkotatɨg ikɨn-u itəm io mɨn iakətatɨg ikɨn. ");
INSERT INTO tnn_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ikɨn əh iakatuwɨn ikɨn, itəmat nɨnotɨtun rəkɨs suatɨp rəhan.” ");
INSERT INTO tnn_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Məto Tomas tən-ipən kəm in məmə, “Iərəmərə, itɨmat ekotəruru ikɨn-un nakatuwɨn ikɨn. ?Ekotəhrol nulan motɨtun suatɨp tatuwɨn ikɨn əh?” ");
INSERT INTO tnn_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Kən Iesu tən-ipən kəm in məmə, “Io u, suatɨp ron. Kən io un, nəukətɨ nɨpahrienən, kənu io un, nəukətɨ nəmegəhən. Etəmim kit okol təsuwamən o rəhak Tata okəmə io ekəsosən in muwɨn. ");
INSERT INTO tnn_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Okəmə nəmotɨtun io, kən nəmotɨtun mɨn rəhak Tata. Kən tol nəhlan, tətuoun roiu, nɨnotɨtun rəkɨs in, kən mɨnotəplan.” ");
INSERT INTO tnn_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Kən Filip tən-ipən kəm in məmə, “Iərəmərə, awi əgətun-tu Tata Uhgɨn kəm itɨmat. Nat əm u inu, itɨmat ekotolkeike.” ");
INSERT INTO tnn_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Kən Iesu tən-ipən kəm in məmə, “Filip, io emətatɨg təfəməh kitat min itəmat. Məto ik nəkəruru əh io. Etəmim itəm tatəplan io, in tatəplan Tata Uhgɨn. ?Təhrol ik nakatən məmə, ‘Awi, əgətun Tata Uhgɨn kəm itɨmat’? ");
INSERT INTO tnn_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","?Ik nəsahatətəən məmə iakatɨg e Tata Uhgɨn, kənu Tata Uhgɨn tətatɨg lak? Nəghatən mɨn u iakatən kəm itəmat, sənəmə rəhak əm. Tata Uhgɨn u, nian rafin, tətatɨg lak, inun in tatol rəhan mɨn u wək. ");
INSERT INTO tnn_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Itəmat onəkotəike motahatətə lak nian io iatən məmə iakətatɨg e Tata Uhgɨn, kənu Tata Uhgɨn tətatɨg lak. Məto okəmə kəpə, təwɨr məmə nakotahatətə lak o nəfɨgəmən rəha nəmtətin mɨn itəm ematol. ");
INSERT INTO tnn_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nɨpahrienən agɨn u iatən kəm itəmat məmə, etəmim itəm tətahatətə lak, in otol nolən wək mɨn un itəm io ematol. Əwəh, in otol nolən wək tər təhmɨn mɨn taprəkɨs-in wək mɨn un itəm io emol, məto-inun io oekatuwɨn o Tata Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Io Nətɨn, kən okəmə nakoteasiə-in nat kit e nərgək, nat əpnapɨn okəmə nakoteasiə-in nat naka, io epanol, məmə wək u rəha Nətɨn otɨləs-ipər nərgɨ Tata Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kən okəmə onəkoteasiə-in nat kit ron io, e nərgək, kən io ekol.” ");
INSERT INTO tnn_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Kən Iesu təməghat əh matuwɨn, matən məmə, “Okəmə itəmat nakotolkeike io, kənu itəmat onəkotol nəghatən rəhak. ");
INSERT INTO tnn_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Kən io, oekeasiə o Tata Uhgɨn məmə in otahl-ipa Iasitu kit mɨn otəmat. Kən in otətatɨg lilɨn itəmat min. ");
INSERT INTO tnn_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Suah un inun, in Narmɨn rəha Nɨpahrienən. Netəmim rəha nətueintən u, okol kəsotosən in e nɨkilat, məto-inu ilat kəsotəplanən in, motəruru in. Məto itəmat, nəkotɨtun in, məto-inun in tətatɨg itəmat min. Kən in otəpanatɨg e nɨkitəmat. ");
INSERT INTO tnn_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Nian io ekiet etəmat, okol esapəsən itəmat nəkotatɨg pɨsɨn əm, tahmen e suakəlh. Io epanɨtəlɨg-pa mɨn otəmat. ");
INSERT INTO tnn_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Otəsuwəhən, netəmim rəha nətueintən u ilat okəsotəplanən io. Məto itəmat onəpanotəplan io. Kən məto-inun io epanəmegəh, itəmat mɨn onəpanotəmegəh. ");
INSERT INTO tnn_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","O nian rəha natɨmnat mɨn u, kən itəmat onəkotɨtun məmə iakətatɨg e rəhak Tata. Kən itəmat nəkotatɨg lak, kənu io ekətatɨg etəmat. ");
INSERT INTO tnn_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Etəmim itəm təmos wɨr nəghatən rəhak, kən matol, etəmim u inun in tolkeike io. Kən etəmim itəm tolkeike io, rəhak Tata in otolkeike mɨn in. Kən io mɨn oekolkeike in. Kən io oekol əp io kəm in, məmə in otɨtun əsas io.” ");
INSERT INTO tnn_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Kən Jutas u, (sənəmə Jutas Iskariot, məto iahunin kit), in təmətapəh ron məmə, “?Iərəmərə, ik onakahrol nulan kən mol əp ik kəm itɨmat əm, məto onəsol əpən ik kəm netəmim rəha nətueintən?” ");
INSERT INTO tnn_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Məto Iesu tən-ipən kəm in məmə, “Etəmim itəm tolkeike io, in otatol nəwiak, kənu rəhak Tata in otolkeike in. Kənu io ne rəhak Tata, itɨmlau ekueia mətuatɨg itɨməhal min. Kən itɨmlau ekioal imatɨmlau əh-ikɨn. ");
INSERT INTO tnn_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Etəmim itəm təsolkeikeən io, in təsolən nəwiak. Nəghatən mɨn u itəm nəmotəto ematən, eməsən atɨpən ilat. Məto emos ilat o rəhak Tata itəm in təmahl-ipa io ekuwa. ");
INSERT INTO tnn_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Io iatən-iarəp nəghatən mɨn u kəm itəmat nian etatɨg əh kitat min itəmat. ");
INSERT INTO tnn_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Məto Narmɨn Rəha Uhgɨn u, in Iasitu, itəm Tata Uhgɨn otahl-ipa e nərgək, in otəgətun itəmat e natɨmnat mɨn rafin. Kən in otatol itəmat məmə nɨkitəmat otatəht natɨmnat mɨn u itəm iatən kəm itəmat, məsotaluinən. ");
INSERT INTO tnn_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Roiu əh tɨnuəkɨr məmə io oekapəs itəmat. Io iatələhəu nəməlinuən rəhak tətatɨg otəmat. Kənu nəməlinuən u, itəm iakatos-ipɨnə, təsahmenən e nəməlinuən itəm nətueintən u tatos-ipɨnə. Itəmat, nɨkitəmat təsahməən kən məsotəgɨnən. ");
INSERT INTO tnn_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Itəmat nɨnəmotəto rəkɨs rəhak nəghatən, emən-ipɨnə kəm itəmat məmə, ‘Io oepanapəs itəmat, məto uarisɨg, oepanɨtəlɨg-pa mɨn otəmat.’ Okəmə nakotolkeike pahrien io, kən nɨkitəmat otagien əm məmə nəkotəplan io iakatuwɨn o rəhak Tata, məto-inu in ilɨs taprəkɨs-in io. ");
INSERT INTO tnn_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Io iatən-iarəp rəkɨs əm natɨmnat mɨn u kəm itəmat u-roiu, nian ilat kəsotolən əh, məmə nian ilat kɨnotuwa moatol nɨpahrien lan, kən itəmat onəkotahatətə lak. ");
INSERT INTO tnn_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Roiu əh, okol esəghatən təfəməh mɨn kəm itəmat, məto-inun Setan u iərəmərə rəha nətueintən u, in tɨnatuwa. In təsosən nəsanənən məmə otol win lak. ");
INSERT INTO tnn_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Məto io iatol ətuatɨp əm nəwia Tata Uhgɨn məmə netəmim rəha nətueintən okotɨtun məmə io ekolkeike in. “Itəla, pəs kotətul motagɨm ikɨn-u, moatuwɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Kən Iesu tatən məmə, “Io un, io ekahmen e nokət nɨg pahrien. Kən rəhak Tata in tahmen e etəmim itəm tatɨtasɨlɨn nɨg u. ");
INSERT INTO tnn_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nelmɨ nɨg mɨn rafin itəm kəsotoeən, in tatəte rəkɨs ilat, kən nelmɨ nɨg mɨn rafin u itəm koatoe, in tətafəl wɨr ilat, məmə ilat okotoe-in noalat tepət. ");
INSERT INTO tnn_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Itəmat nəkotahmen e nelmɨ nɨg u. Kən io enafəl wɨr rəkɨs itəmat e nəghatən mɨn itəm iatən-ipɨnə kəm itəmat. ");
INSERT INTO tnn_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Otəper-ipa lak, kən io oekəper-ipən etəmat. Nelmɨ nɨg otəsoeən okəmə in təsəper-ipənən e nəukətɨn. E nolən kitiəh əm, itəmat okol nəmegəhən rəhatəmat təsoe-inən noan okəmə nəsotəper-ipamən lak. ");
INSERT INTO tnn_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Io u, io nokət nɨg. Kən itəmat nelmɨ nɨg mɨn, nelmɨ nɨg mɨn itəm koatətul-pən wɨr lak, moatəper-ipa. Nəmegəhən rəha etəmim itəm tatəper-ipa lak kən iatəper-ipən lan, in otoe-in noan tepət. Məto itəmat u, okəmə nəsotəper-ipamən lak, okol nəsotolən nat kit. ");
INSERT INTO tnn_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Okəmə etəmim təsəper-ipamən lak, in tahmen e nelmɨ nɨg kit, itəm kɨnərakin kən tɨnapə rəkɨs. Nelmɨ nɨg mɨn tol nəhlan, kɨtun nəmɨkən kərakin-pən e nɨgəm, kuwaan ətɨp. ");
INSERT INTO tnn_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Okəmə itəmat nakotəper-ipa lak, kən nəghatən mɨn rəhak kotəper-ipən etəmat, nat naka itəmat nakotolkeike, nəkotɨtun neasiə-inən. Kən Uhgɨn otol kəm ik. ");
INSERT INTO tnn_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nian nəmegəhən rəhatəmat otoe-in noan tepət, nat əh in tatɨləs-ipər nərgɨ rəhak Tata, kən e nolən u, tatəgətun məmə itəmat rəhak mɨn netəmim. ");
INSERT INTO tnn_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Tata Uhgɨn in tolkeike pɨk io. E nolən kitiəh əm, io ekolkeike mihin itəmat. Otəper-ipən e rəhak nolkeikeən. ");
INSERT INTO tnn_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Okəmə itəmat nəkoatol rəhak nəghatən, kən onəkotəper-ipa e rəhak nolkeikeən, tahmen ətuatɨp əm mə inun io emol nəghatən mɨn rəha Tata Uhgɨn, kən iatəper-ipən e rəhan nolkeikeən. ");
INSERT INTO tnn_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Io ematən-iarəp nəghatən mɨn u kəm itəmat, məmə nɨkitəmat otətagien, tahmen əm məmə io nɨkik tətagien. Kənu nɨkitəmat otagien otagien mərioah. ");
INSERT INTO tnn_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Itəmat nəkotəkəike moatol nəghatən u rəhak. Tatən məmə itəmat onəkotolkeike itəmat mɨn, tahmen əm məmə io ekolkeike mihin itəmat. ");
INSERT INTO tnn_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Suah kit tɨkə itəm tolkeike pɨk in kit taprəkɨs-in etəmim un itəm tategəhan-in rəhan nəmegəhən məmə otosmegəh in mɨn neen. ");
INSERT INTO tnn_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kən okəmə itəmat nəkotol natɨmnat mɨn u iatən kəm itəmat, tatəgətun məmə itəmat un, io mɨn neen. ");
INSERT INTO tnn_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Io oesaun-in mɨnən itəmat məmə iolwək mɨn rəhak, məto-inun etəm tatol wək, in təruru natɨmnat mɨn itəm rəhan etəm-iasol tatol. Məto roiu əh, io ekaun-in itəmat, məmə io mɨn neen, məto-inun natɨmnat mɨn rafin u itəm eməto o rəhak Tata, enən-iarəp rəkɨs kəm itəmat. ");
INSERT INTO tnn_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Itəmat nəməsotɨtəpunən io, məto io emɨtəpun itəmat. Kən io emələhəu-pən itəmat məmə itəmat onəkotuwɨn motol wək, kən wək rəhatəmat otoe-in noan. Kən noan un, in otətatɨg. Tol nəhlan, kən okəmə nakoteasiə-in natɨmnat mɨn kəm Tata Uhgɨn e nərgək, kən in otos-ipɨnə kəm itəmat. ");
INSERT INTO tnn_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Iatos-ipɨnə nəghatən kit kəm itəmat in tol nulan. Itəmat onəkotəike motolkeike itəmat mɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Kən Iesu tən-ipən məmə, “Okəmə netəmim rəha nətueintən u koatetəhau itəmat, nɨkitəmat otəkəike muwəh məmə aupən, ilat kəmotetəhau mihin io. ");
INSERT INTO tnn_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Okəmə itəmat netəmim rəha nətueintən u, kən netəmim rəha nətueintən okotolkeike itəmat, məto-inu rəhalat u itəmat. Məto sənəmə itəmat netəmim rəha nətueintən u. Io enɨmɨtəpun rəkɨs itəmat, kən mos-irəkɨs itəmat o nətueintən. Kən o nat u inu, netəmim rəha nətueintən, kotetəhau itəmat. ");
INSERT INTO tnn_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nɨkitəmat otəkəike matəht nəghatən u emən-ipɨnə rəkɨs kəm itəmat məmə, ‘Iolwək əm kit, təsaprəkɨs-inən rəhan etəm-iasol.’ Kən məto-inu netəm rəha nətueintən u, ilat koatol tərat agɨn ron io, kən tol nəhlan, ilat okotol nolən kitiəh əm etəmat. Okəmə ilat kəmotol rəhak nəghatən, kən ilat okotol rəhatəmat nəghatən. Məto ilat kəməsotol agɨn-əhən rəhak nəghatən mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ilat okotol natɨmnat mɨn nulan etəmat, məto-inun itəmat rəhak mɨn netəmim. Ilat okotol nəhlan, məto-inu ilat kotəruru Uhgɨn itəm təmahl-ipa io. ");
INSERT INTO tnn_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Emuwa kən məghat kəm ilat. Tol nəhlan e noa nəghatən u, ilat kəmotəplan əsas rəhalat nolən rat mɨn. Məto kəmoatəuhlin məntalat ron io moatapəs rəhak nəghatən. Kən roiu, kol kəsotənən məmə rəhalat nolən rat tɨkə. ");
INSERT INTO tnn_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Etəmim itəm tetəhau io, in tetəhau mɨn rəhak Tata. ");
INSERT INTO tnn_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Emuwa mol wək mɨn u e nɨganəmtɨlat itəm kol etəm pɨsɨn kit təməsolən. Tol nəhlan, ilat kəmotɨtun məmə pah u io. Kən nat əpnapɨn kəmotɨtun io, məto koatetəhau io, kən tol nəhlan məmə koatetəhau mɨn rəhak Tata. Kən roiu, kol kəsotənən məmə rəhalat nolən rat tɨkə. ");
INSERT INTO tnn_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Məto natɨmnat mɨn əh otəkəike mol nəhlan, kən mol məmə nəghatən u otuwa pahrien itəm netəm aupən kəmotəte rəkɨs e naoa rəha Lou. Rəhalat u Lou tatən məmə, ‘Io esolən nat kit elat, məto ilat kotetəhau agɨn-əh io, moatol tɨməht kəm io.’ ");
INSERT INTO tnn_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Məto nian Iasitu otuwa, in otatən-iarəp io. Narmɨn rəha Nɨpahrienən u, tatɨsɨ-pən o Tata Uhgɨn. Io ekahl-ipa in tuwa otəmat. ");
INSERT INTO tnn_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kənu itəmat mɨn, onəkotəkəike motən-iarəp io, məto-inu itəmat noatatɨg kitat min io e nətuounən e wək rəhak muwa mətoarus-pa u-roiu. ");
INSERT INTO tnn_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Io enatən-iarəp natɨmnat mɨn u kəm itəmat məmə rəhatəmat nahatətəən otəseiuaiuən. ");
INSERT INTO tnn_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ilat okəpanotəhg-iarəp itəmat e nimə mɨn rəha nuəfɨmɨnən rəhalat; kən nɨpahrienən agɨn, nian əh-ikɨn tatuwa itəm netəm okotohamnu itəmat, kən nɨkilat təht məmə ilat koatol wək wɨr kit rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ilat okotol natɨmnat mɨn u, məto-inun ilat kotəruru Tata Uhgɨn, kən motəruru mɨn io. ");
INSERT INTO tnn_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Məto io ekaupən matən-iarəp natɨmnat mɨn u kəm itəmat. Kən nian ilat kɨnotətuoun mɨnatol etəmat, kən nɨkitəmat otuəh məmə io enəmən rəkɨs natɨmnat mɨn u kəm itəmat.” Kən Iesu təghat əh matuwɨn, matən məmə, “Io eməsən-iarəpən natɨmnat mɨn u kəm itəmat aupən, məto-inu emətatɨg kitat min itəmat. ");
INSERT INTO tnn_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Məto roiu ekɨtəlɨg-pən mɨn o rəhak Tata itəm təmahl-ipa io, məto itəmat kit təsətapəhən ron io məmə, ‘?Ik onəkuwɨn hiə?’ ");
INSERT INTO tnn_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Məto roiu, tol nulan məmə emən natɨmnat mɨn u kəm itəmat, kən nɨkitəmat təmahmə. ");
INSERT INTO tnn_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Məto io iatən pahrien kəm itəmat məmə, otəwɨr pɨk otəmat məmə io ekagɨm tənin itəmat. Məto-inu okəmə esagɨm təninən itəmat, kən Iasitu okol təsuwamən matɨg itəmat min. Məto okəmə io ekagɨm, muwɨn, kən io ekahl-ipa in tuwa mətatɨg otəmat. ");
INSERT INTO tnn_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Kən nian in otuwa, kən otəgətun netəmim rəha nətueintən məmə ilat iol təfagə rat, kən nətəlɨgən rəhalat təsahmenən o nolən itəm tətuatɨp e nɨganəmtɨ Uhgɨn, kən nətəlɨgən rəhalat təsahmenən o nakilən nolən rəha netəmim. ");
INSERT INTO tnn_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Narmɨn u otəgətun ilat məmə ilat iol təfagə rat, məto-inu kəsotahatətəən lak. ");
INSERT INTO tnn_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Narmɨn u otəgətun kəm ilat məmə nətəlɨgən rəhalat in təsahmenən o rəhalat nətuatɨpən e nɨganəmtɨ Uhgɨn, məto-inu io ekɨtəlɨg-pən mɨn o rəhak Tata, kən itəmat onəsotehmən io. ");
INSERT INTO tnn_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Narmɨn u otəgətun kəm ilat məmə nətəlɨgən rəhalat in təsahmenən o nakilən nolən rəha netəmim, məto-inu Uhgɨn in tɨnakil rəkɨs iərəmərə rəha nətueintən u, Setan. ");
INSERT INTO tnn_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Io iatos natɨmnat tepət mɨn əh-ikɨn məmə epanən kəm itəmat. Məto roiu əh, okol nəsotos rafinən ilat. Ilat kotiəkɨs pɨk əh otəmat. ");
INSERT INTO tnn_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Məto nian Narmɨn rəha Nɨpahrienən otuwa, in otit itəmat, tol mə itəmat nəkotɨtun nɨpahrienən rafin. In okol təsən atɨpən rəhan əm nəghatən. In otən-iarəpən əm natɨmnat mɨn u itəm in tatəto e Tata Uhgɨn. Kən in otən-iarəpɨnə mɨn kəm itəmat natɨmnat mɨn u itəm nian kit okəpanotuwa. ");
INSERT INTO tnn_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","In otəto nəghatən pahrien ron io kən matən-iarəp kəm itəmat. E nolən u, in otɨləs-ipər io. ");
INSERT INTO tnn_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Natɨmnat mɨn rafin rəha Tata Uhgɨn, in rəhak. Tol nəhlan, kən io ekatən məmə, Narmɨn u, in otəto nəghatən pahrien ron io kən matol əp nɨpətɨn kəm itəmat.” ");
INSERT INTO tnn_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Kən Iesu tən-ipən məmə, “Otəsuwəhən onəsotəplanən io, məto uarisɨg un, təsuwəhən, kən onəpanotəplan mɨn io.” ");
INSERT INTO tnn_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Kən netəmim mɨn neen rəhan, ilat koatətapəh-ətapəh kəm ilat mɨn məmə, “?Nəghatən u, nɨpətɨn naka? In tatən kəm itat məmə, ‘Otəsuwəhən onəsotəplanən io, məto uarisɨg, otəsuwəhən, nəpanotəplan mɨn io.’ Kən in tən məmə, ‘Məto-inu io iakatuwɨn o Tata Uhgɨn.’ ");
INSERT INTO tnn_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","?Nəghatən u, ‘otəsuwəhən’ nɨpətɨn naka? Kitat kotəruru nəghatən mɨn əh in tatən.” ");
INSERT INTO tnn_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Kən Iesu tɨnɨtun rəkɨs məmə ilat kotolkeike məmə okotətapəh-in nat kit ron, kən in tən-ipən kəm ilat məmə, “?Tahro? Io emən məmə, ‘Otəsuwəhən itəmat nəsotəplanən io. Məto uarisɨg, təsuwəhən onəpanotəplan mɨn io.’ ?Kən roiu nakotətapəh otəmat mɨn o nɨpətɨ nəghatən u? ");
INSERT INTO tnn_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nɨpahrienən agɨn u iatən kəm itəmat məmə, itəmat nɨkitəmat otahmə, itəmat onəkotasək pɨk, məto nətueintən, nɨkin otagien. Itəmat onəkotəto tərat pɨk agɨn, məto nahməən rəhatəmat otəuhlin-pa e nagienən. ");
INSERT INTO tnn_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nian okəmə tɨnuəhkɨr məmə pətan kit otemək, kən in tatəto tərat, məto-inun tɨnol nian rəhan məmə otəto nahməən e nɨpətɨn. Məto uarisɨg, okəmə nətɨn tɨnaiir rəkɨs, kən in nɨkin təsəht mɨnən nahməən əh. In nɨkin tətagien pɨk məto-inu nətɨn tɨnaiir-pa e nətueintən. ");
INSERT INTO tnn_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","E nolən kitiəh əm, roiu əh itəmat nakotəto tərat. Məto uarisɨg, kənu io ekəplan mɨn itəmat. Kənu nɨkitəmat otagien otagien, okol etəmim kit təsol mɨnən itəmat nɨkitəmat tahmə mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","O nian əh, itəmat onəsotətapəh-in mɨnən nat kit ron io. Nɨpahrienən agɨn u iatən kəm itəmat məmə, okəmə itəmat nakotətapəh-in nat kit o Tata Uhgɨn e nərgək, kən in otos-ipɨnə kəm itəmat. ");
INSERT INTO tnn_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mətoarus-pa u-roiu, itəmat nəsotətapəh-inən əh nat kit ron e nərgək. Otətapəh-in e nərgək, kən onəkotos, məmə nɨkitəmat otagien otagien mərioah.” ");
INSERT INTO tnn_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Kən Iesu tatəghat əh matuwɨn matən məmə, “Io ematuəh nimaa nəghatən e natɨmnat mɨn u, matən kəm itəmat. Məto nian əh-ikɨn tatuwa, itəm io ekəsuəh mɨnən nimaa nəghatən lan, məto oekəghat-in rəhak Tata kəm itəmat e nolən kit itəm itəmat onəkotɨtun wɨr in. ");
INSERT INTO tnn_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","E nian əh, itəmat onəkoteasiə-in natɨmnat kəm rəhak Tata e nərgək, məto io esənən məmə io ekuwɨn e nərgɨtəmat measiə-in natɨmnat ron ");
INSERT INTO tnn_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","məto-inu Tata Uhgɨn, in əmun tolkeike pɨk itəmat. In tolkeike itəmat məto-inu itəmat nakotolkeike io, kən itəmat nəmotahatətə məmə io emɨsɨ-pən lan. ");
INSERT INTO tnn_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Io emɨsɨ-pən o Tata Uhgɨn, muwa e nətueintən u. Kənu roiu otəsuwəhən kən ekiet mɨn e nətueintən u, mɨtəlɨg-pən mɨn o Tata Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Kən netəmim rəhan mɨn koatən məmə, “!In un! !Roiu əh ik nəsuəh mɨnən nimaa nəghatən! Ik nakatən ətuatɨp əm kəm itɨmat. ");
INSERT INTO tnn_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Roiu əh enotɨtun məmə okəmə suah kit təsətapəh-inən əh nat kit ron ik, məto ik nəkɨtun nuhalpɨnən nəghatən mɨn rafin itəm kəsətapəhinən əh. O nat u, tol kən itɨmat ekotɨtun məmə ik nəmɨsɨ-pən o Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Kən Iesu tən-ipən kəm ilat məmə, “?Nɨpahrienən, itəmat nakotahatətə lak u-roiu? ");
INSERT INTO tnn_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Itəmat otətəlɨg-in-tu, nian əh-ikɨn tatuwa, nɨpahrienən məmə nian əh tɨniet-arəpa rəkɨs, itəm netəmim okotɨtəp itəmat rafin, nakotaiu atit, motuwɨn imatəmat mɨn ikɨn, motapəs io, io pɨsɨn əm. Məto okol io esan pɨsɨn əmən, məto-inu nian rafin rəhak Tata tətatɨg itɨmlau min. ");
INSERT INTO tnn_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Io enəmən-iarəp rəkɨs natɨmnat mɨn u kəm itəmat, məmə rəhatəmat nətəlɨgən oteiuaiu məto-inu nəkotatɨg lak. E nətueintən u, nahməən otepət otəmat, məto sotəgɨnən, motətul məha-məha, məto-inu io enol win rəkɨs e nəsanənən rəha nətueintən.” ");
INSERT INTO tnn_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nian Iesu təməghat rəkɨs, kən mətag-pər ilɨs e neai, kən matəfak matən məmə, “Tata, rəhak nian tɨnuwa rəkɨs. Io iakolkeike məmə ik onakɨləs-ipər nərgɨ Nətɨm, məmə in mɨn otəpanɨləs-ipər nərgəm, ");
INSERT INTO tnn_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","məto-inu ik nəmos-ipən nəsanənən ne nepətən kəm in, məmə in otərəmərə e netəmim rafin, kən mɨtun mɨn nos-ipənən nəmegəhən lilɨn kəm ilat mɨn u, itəm ik nəmos-ipən ilat mɨn kəm in. ");
INSERT INTO tnn_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kən nəmegəhən lilɨn u, nɨpətɨn u məmə netəmim okotɨtun ik, itəm ik əm un ik Uhgɨn pahrien, kən motɨtun mɨn Iesu Kristo u, ik nəmahl-ipa. ");
INSERT INTO tnn_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Io ematɨləs-ipər nərgəm e nətueintən u, kən enol rafin rəkɨs wək itəm ik nəmos-ipa kəm io məmə iakol. ");
INSERT INTO tnn_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tata, roiu əh, tɨnol nian rəham məmə onakos io ekɨmnə mətatɨg kilau min ik. Ləs-ipər io mos-ipa nepətən əhag-əhag kəm io, tahmen əm mə inun, emos aupən kilau min ik e nian nətueintən u təmatɨkə əh. ");
INSERT INTO tnn_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Netəm mɨn u itəm ik nəmos-irəkɨs ilat o nətueintən mos-ipa ilat kəm io, io ematol əp nərgəm kəm ilat, məmə ilat okotɨtun ik. Aupən, ilat rəham mɨn netəmim, məto roiu ik nəmələhəu-pən ilat e nelmək, məmə ilat rəhak mɨn netəmim. Ilat kəmoatətəu-pən rəham nəghatən, ");
INSERT INTO tnn_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","kən roiu əh, ilat kotɨtun məmə, natɨmnat mɨn u itəm ik nəmos-ipa kəm io, ilat koatɨsɨ-pən əm ron ik. ");
INSERT INTO tnn_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ilat kotɨtun natɨmnat mɨn u, məto-inu ik nɨnəmən-ipa rəkɨs nəghatən kəm io, kən io emən-ipən kəm ilat, kən ilat koatos e nɨkilat. Kən ilat motɨtun məmə nɨpahrienən agɨn məmə io emɨsɨ-pɨnə ron ik, kən moatahatətə lak məmə ik nəmahl-ipa io. ");
INSERT INTO tnn_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Io iatəfak olat mɨn u. Io esəfakən o netəmim rəha nətueintən, iatəfak əm o netəm mɨn u itəm ik nəmos-ipa ilat kəm io, məto-inun ilat u rəham mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Netəm mɨn u iatos, ilat rafin rəham, kənu ilat rafin u itəm ik natos, ilat rəhak. Kən netəm mɨn u, ik nəmol ilat məmə nəmegəhən rəhalat tatɨləs-ipər nərgək. ");
INSERT INTO tnn_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Roiu əh iakatuwa ron ik, kən otəsuwəhən io esatɨgən u e nətueintən u. Məto netəm mɨn u, ilat okotatɨg əh e nətueintən u. Tata, ik nakətuatɨp agɨn. Awi, nakaskəlɨm netəm mɨn u kotatɨg wɨr e nəsanənən rəha nərgəm u itəm ik nəmos-ipa kəm io, məmə ilat okotatɨg kitiəh əm, tahmen məmə inu, kilau min ik kitiəh. ");
INSERT INTO tnn_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nian io emətatɨg itɨmat min ilat, kən ematɨpal wɨr olat, e nəsanənən rəha nərgəm əm itəm ik nəmos-ipa kəm io. Io ematehm wɨr ilat, esaiiroauinən kit. Kitiəh əm u itəm təməlue, inun itəm Uhgɨn otəkəike mərəkɨn, kənu nat əh otol nəhlan, məmə otol nəghatən rəha Naoa Rəha Uhgɨn otuwa mol nɨpahrienən. ");
INSERT INTO tnn_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Roiu əh, iatuwa ron ik, məto iatən nəghatən mɨn u nian etatɨg əh e nətueintən, məmə ilat mɨn, nɨkilat otagien otagien, tahmen əm məmə io nɨkik tətagien. ");
INSERT INTO tnn_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Io emən-iarəp rəham nəghatən mɨn kəm ilat. Kən tol nəhlan, netəmim rəha nətueintən u, kəsotolkeikeən ilat, koatetəhau ilat, məto-inun ilat sənəmə netəmim rəha nətueintən, tahmen əm məmə io sənəmə etəmim rəha nətueintən. ");
INSERT INTO tnn_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Io esətapəhən ron ik məmə onakos-irəkɨs ilat e nətueintən u. Məto ekolkeike məmə ik onakahtosɨg-in etəm rat u, Setan, məmə in otəsuwamən mərəkɨn ilat. Ik onakɨpal wɨr olat. ");
INSERT INTO tnn_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Io, sənəmə etəmim rəha nətueintən u. Kən tol nəhlan, ilat mɨn sənəmə netəmim rəha nətueintən. ");
INSERT INTO tnn_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Rəham nəghatən in nɨpahrienən rafin. Onəkol rəham nəghatən məmə in otol wək e nəmegəhən rəhalat məmə ilat netəmim pahrien rəham motasim motətuatɨp. ");
INSERT INTO tnn_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ik nəmahl-ipa io, ekuwa e nətueintən u, kən e nolən kitiəh əm, io enatahl-iarəp mɨn ilat, kotuwɨn e nətueintən. ");
INSERT INTO tnn_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kən io iatos-ipɨnə atɨp io məmə iakatasim o nolən nalpəkauən rəham, məmə ekasitu e netəm mɨn u, məmə ilat mɨn okotasim motətuatɨp, kən ilat netəmim pahrien rəham. ");
INSERT INTO tnn_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Io esəfakən əm o netəm mɨn u, məto iatəfak mɨn o netəm mɨn u itəm okəpanotahatətə lak e nəghatən rəha netəm mɨn u. ");
INSERT INTO tnn_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tata, io iatəfak olat, məmə ilat rafin okotuwa kitiəh əm, tahmen-pən əm məmə inun kilau kitiəh əm, kən iakətatɨg-pɨnə lam, kən ik nəkətatɨg lak. Iatəfak məmə ilat okotuwa kitiəh əm kitat min ik, məmə netəmim rəha nətueintən okotahatətə məmə ik nəmahl-ipa io. ");
INSERT INTO tnn_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ik nɨnəmos-ipa rəkɨs nepətən kəm io, kən io iatawte-in kələh nepətən rəhak kəm ilat, məmə ilat okotuwa kitiəh əm tahmen əm məmə kilau kətioal kitiəh. ");
INSERT INTO tnn_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Iakətatɨg e nɨkilat, kən ik nəkətatɨg lak. Tol nəhlan, iatəfak məmə, ilat okotuwa kitiəh əm e natɨmnat mɨn rafin məmə netəm mɨn u rəha nətueintən, ilat okotəplan motɨtun məmə ik nəmahl-ipa io, kən məmə ik nəmolkeike rəham netəmim tahmen əm məmə inu, ik nəmolkeike mihin io. ");
INSERT INTO tnn_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tata, ik nəmos-ipa ilat u e nelmək məmə ilat rəhak mɨn, kən io ekolkeike məmə ilat okotɨtun nuwamən ikɨn-u itəm io mɨn ekuwɨn ikɨn, məmə ilat okotəplan nepətən əhag-əhag rəhak itəm io ekatos. Nepətən əhag-əhag u, ik nəmos-ipa kəm io, məto-inu ik nəmolkeike io aupən agɨn nian nətueintən u təmatɨkə əh. ");
INSERT INTO tnn_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Tata, ik nakətuatɨp agɨn. Netəmim rəha nətueintən u, ilat kotəruru ik, məto io ekɨtun ik. Kən netəm mɨn u rəhak mɨn, ilat kotɨtun məmə ik nəmahl-ipa io. ");
INSERT INTO tnn_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Io emol əp ik kəm ilat, məmə ilat okotɨtun wɨr ik, kənu io, oiakatəkəike matol əp ik nəhlan, məmə nolkeikeən rəham otɨnɨp wɨr nɨkilat, kən məmə io atɨp oiakətatɨg e nɨkilat. Nolkeikeən u iakatəghat-in, in nolkeikeən rəham, tahmen mə inu ik nakolkeike mihin io.” ");
INSERT INTO tnn_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nian Iesu təmaupən məfak, kəmotiet e taon u, kən moteguəfɨmɨn-pən entənɨpən-pən e noanapinat kit, nərgɨn un, Ketron. Kən ikɨn əh, kəmahwɨnu kit ikɨn. Kən Iesu ne rəhan netəmim mɨn kəmotuwɨn e nɨki nɨg mɨn əh. ");
INSERT INTO tnn_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Kən Jutas u, etəm u uarisɨg in otəpanegəhan-in Iesu kəm rəhan tɨkɨmɨr mɨn, in tɨnɨtun rəkɨs ikɨn əh, məto-inu nian neen, Iesu ne rəhan mɨn netəmim ilat koatuəfɨmɨn ilat mɨn ikɨn. ");
INSERT INTO tnn_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kən pris asol mɨn ne Farisi mɨn kəmotahl-ipən mopael mɨn itəm koatətul o Nimə Rəha Uhgɨn kotuwa motehm Jutas. Kən Jutas təmit netəm mɨn əh ilat mopael mɨn neen rəha netəm Rom, mit ilat motuwɨn e nɨki nɨg olɨf əh. Ilat koatəmɨk noanɨsiə, ne lait mɨn, ne natɨmnat rəha nəluagɨnən. ");
INSERT INTO tnn_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Iesu tɨnəmɨtun rəkɨs məmə natɨmnat mɨn u, in otuwa tol nulan, məto in təmaliwək muwɨn olat, kən mətapəh olat məmə, “?Itəmat noategəs-in pah un?” ");
INSERT INTO tnn_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ilat kəmotən-ipən kəm in məmə, “Etəm Nasaret kit, nərgɨn u Iesu.” Kən in tən-ipən kəm ilat məmə, “Io u inu.” (Kən Jutas, suah u itəm təmegəhan-in-pən Iesu e nelmɨlat, in tatətul ilat min.) ");
INSERT INTO tnn_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kən nian Iesu təmən məmə, “Io u inu,” ilat kəmotani məntaalat motɨtəlɨg, moteiuaiu motorin ilat e nɨsɨp. ");
INSERT INTO tnn_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Kən Iesu tatɨg mətapəh mɨn olat məmə, “?Itəmat nakotegəs-in pah un?” Kən ilat kotəmə, “Etəm Nasaret kit, nərgɨn u Iesu.” ");
INSERT INTO tnn_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Kən Iesu tən-ipən məmə, “Enən-ipɨnə rəkɨs kəm itəmat məmə, ‘Io u inu.’ Okəmə itəmat nakoategəs-in io, kən təwɨr məmə nakotapəs netəmim mɨn u, koatuwɨn latuənu.” ");
INSERT INTO tnn_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","In təmən nəhlan məmə nəghatən u itəm in tɨnəmən rəkɨs in otol nɨpahrienən. Nəghatən u təmən məmə, “Tata, netəm mɨn u itəm nəmələhəu-pən ilat e nelmək, okol esaiiroauinən kit.” ");
INSERT INTO tnn_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimon Pita təmatɨləs rəhan kit nisa rəha nəluagɨnən. Kən əmun, in təmiuw-iarəp rəhan nisa, məte rəkɨs matelgɨ slef kit rəha pris asol agɨn, matəlgɨn matɨp. Nərgɨ suah un, Malkas. ");
INSERT INTO tnn_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Məto Iesu tən-ipən kəm Pita məmə, “Aii-pən rəham nisa u e rəhan sipa. Ik onəkəike mɨtun məmə nahməən u rəhak, itəm Tata Uhgɨn in təmos-ipa kəm io, kən io ekəike mətəlɨg-in əm, mol.” ");
INSERT INTO tnn_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kən mopael mɨn rəha netəm Rom ne etəm-iasol rəhalat, ne mopael mɨn rəha netəm Isrel, kəmotaskəlɨm Iesu, kən motəlis ətain nelmɨn. ");
INSERT INTO tnn_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Kən kəmotaupən motɨləs in motuwɨn tətul e nɨganəmtɨ Anas. Anas un, in etəmaa Kaeafas. Kaeafas un, in pris asol agɨn e nup əh. ");
INSERT INTO tnn_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kən Kaeafas u inu, in aupən təmən kəm netəm-iasol rəha netəm Isrel məmə təwɨr pɨk məmə etəmim kitiəh əm otɨmɨs o netəmim, taprəkɨs-in məmə netəmim rafin okotɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Kən Saimon Pita ne etəmim kit mɨn rəha Iesu, ilau kəmiauarisɨg-in Iesu. Etəmim u kit mɨn rəha Iesu, pris asol agɨn in tɨtun wɨr. Tol nəhlan, in təmətəu-pən Iesu, mian əpəh imə e iat rəha nimə rəha pris asol agɨn un. ");
INSERT INTO tnn_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Məto Pita in təmatətul əm e ket. Kən etəmim kit mɨn u rəha Iesu, itəm pris asol agɨn tɨtun wɨr, in təmiet muwa ihluə, kən mən-ipən kəm pətan u itəm tatətul o ket. Kən in təmit Pita mian imə. ");
INSERT INTO tnn_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kən əmun, pətan un itəm tatətul o ket, təməplan Pita kən tətapəh ron məmə, “?Ei, ik mɨn un etəmim rəha suah əh?” Məto Pita təmə, “Kəpə, sənəmə io rəhan etəmim.” ");
INSERT INTO tnn_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kən e nian əh, in nian rəha nətəpən, kən iolwək mɨn rəha pris asol agɨn, ne mopael mɨn, ilat kəmotasiepən e noanəmkɨlɨp e nɨgəm, kən moatətul tɨtəlau in, moatəto. Kən Pita mɨn, in təmuwɨn motətul, moatəto nɨgəm. ");
INSERT INTO tnn_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kən pris asol agɨn tatətapəh-in natɨmnat mɨn o Iesu. Tatətapəh o netəmim mɨn rəhan ne nəghatən mɨn rəhan itəm təmatən matəgətun ilat lan. ");
INSERT INTO tnn_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Kən Iesu tən-ipən kəm in məmə, “Io ematən rəhak nəghatən mɨn e nɨganəmtɨ netəmim. Nian rafin, iatəgətun netəmim lan, əpəh e nimə mɨn rəha nuəfɨmɨnən, kən əpəh e Nimə Rəha Uhgɨn, itəm netəm Isrel koatəpələh ikɨn nian rafin. Io esəhluaig-inən rəhak nəghatən mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","?Təhrol nakətapəh-in nulan kəm io? Təwɨr mə nakuwɨn mətapəh o netəm kəmoatəto rəhak nəghatən mɨn. Təwɨr nakuwɨn mətapəh o nəghatən mɨn un emən-ipən kəm ilat. Ilat kotɨtun wɨr natɨmnat mɨn u itəm ematən.” ");
INSERT INTO tnn_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nian Iesu təmatən nəghatən əh, kən mopael kit itəm in tatətul e Nimə Rəha Uhgɨn, in tatətul əh-ikɨn, təmem nɨkapɨn, kən məmə, “?Nakatən nulan e pris asol agɨn o naka?” ");
INSERT INTO tnn_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Kən Iesu tən-ipən kəm in məmə, “Okəmə emən nəghatən neen itəm təsətuatɨpən, təwɨr məmə onakən-iarəp. ?Məto okəmə rəhak nəghatən mɨn kotətuatɨp əm, təhrol nakatem io?” ");
INSERT INTO tnn_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Kən əmun Anas tahl-ipən Iesu tuwɨn o pris asol agɨn u Kaeafas. Kən tatəmɨk mətmətɨg əm nol itəm kəməlis lan. ");
INSERT INTO tnn_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Kən Saimon Pita tətul əh matəto nɨgəm. Kən koatətapəh ron məmə, “?Ei, ik mɨn un, ik etəmim rəha suah əh?” Məto Pita təmə, “Kəpə, sənəmə io rəhan etəmim.” ");
INSERT INTO tnn_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kən əmun, iolwək kit rəha pris asol agɨn, in noanol kit rəha suah u Pita təmətatɨp matəlgɨn aupən, in təmən məmə, “?Nɨkik təht məmə eməplan ik itəmat min əpəh e nɨki nahwɨnuən, o kəpə?” ");
INSERT INTO tnn_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Məto Pita təmə, “Kəpə. Sənəmə io.” Kən roiu agɨn-əh mɨn, mənɨg kit tɨmnən. ");
INSERT INTO tnn_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kən laulaugɨn agɨn-əh, kəmotɨləs Iesu motiet e nimə rəha Kaeafas, motuwɨn e nimə rəha Pailat. Pailat in etəm Rom, məto in tatos nərəmərəən asol Isrel. Netəm Isrel koatos nətuakəmən kit rəhalat, ilat kəsotuwɨnən e nimə rəha etəm ik pɨsɨn kit. Okəmə okotuwɨn imə, kən ilat koatən məmə ilat kotamkɨmɨk e nɨganəmtɨ Uhgɨn, kən ilat okol kəsotunən nagwənən rəha lafet rəha Nuhagego-inən. ");
INSERT INTO tnn_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","O nətuakəmən u rəhalat, tol kən Pailat in təmiet e rəhan nimə, muwa ihluə mə otəplan ilat. Kən in təmətapəh məmə, “?Nɨpəgnəmtɨ naka un itəmat noatehm-pən e suah u?” ");
INSERT INTO tnn_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Kən ilat kəmotən-ipən kəm in məmə, “Okəmə suah u in təsətgəhlən lou, okol esotɨləsən in motuwa kəm ik.” ");
INSERT INTO tnn_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Kən Pailat tən-ipən kəm ilat məmə, “Təwɨr məmə itəmat onəkotɨləs in motuwɨn, kən itəmat motakil, tətəu-pən lou mɨn rəhatəmat.” Məto ilat kotən-ipən kəm in məmə, “Məto netəm Rom əm ilat kotegəhan-in məmə kɨtun nohamnuən etəmim.” ");
INSERT INTO tnn_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Iesu təmatən aupən məmə in otɨmɨs nəhlan, kən natɨmnat mɨn u kəmol məmə nəghatən mɨn u rəhan okotuwa motol nɨpahrienən. ");
INSERT INTO tnn_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Kən əmun Pailat tuwɨn mɨn imə, kən maun-in Iesu tuwa mətul aupən-in nɨganəmtɨn, kən tətapəh ron məmə, “?Təhrol? ?Ik kig rəha netəm Isrel?” ");
INSERT INTO tnn_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Kən Iesu tən-ipən kəm in məmə, “?Ik atɨp əm nakatətapəh nulan, o ik nakatətapəh məto-inu netəmim koatən-ipɨnə io kəm ik?” ");
INSERT INTO tnn_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Kən Pailat tən-ipən məmə, “?Təhrol? ?Ik nɨkim təht mə io etəm Isrel kit? Netəmim imam ikɨn əm ne pris asol mɨn rəham, ilat kəmotegəhan-in-pa ik e nelmək. ?Ik nəmol nat naka?” ");
INSERT INTO tnn_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Kən Iesu təmə, “Io, esolən kig rəha nətueintən u. Okəmə io kig kit tahmen e kig mɨn rəha nətueintən u, kən rəhak netəmim mɨn okotəmou, motoh netəm mɨn un itəm kotolkeike məmə okotos-ipən io e nelmɨ netəm-iasol rəha netəm Isrel. Məto io sənəmə kig kit rəha nətueintən u.” ");
INSERT INTO tnn_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Kən Pailat tətapəh ron məmə, “?Məto nɨpahrienən məmə ik kig kit?” Kən Iesu təmə, “Ik nəmən məmə io kig kit. Io emaiir-pa e nətueintən u o nat kitiəh əm, məmə ekatətul-arəp matən-iarəp nɨpahrienən. Kən etəmim itəm nɨkin tagien məmə otətəu-pən nɨpahrienən, kən in tatətəlɨg-in rəhak nəghatən.” ");
INSERT INTO tnn_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Məto Pailat tən-ipən kəm in məmə, “?Naka un, nɨpahrienən?” Kən Pailat təmiet mɨn muwɨn mehm netəm-iasol mɨn rəha netəm Isrel, mən-ipən kəm ilat məmə, “Io esəplanən nolən rat kit ne e suah u, itəm tatən məmə suah u təmərəkɨn lou. ");
INSERT INTO tnn_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Meto e nolən rəhatəmat, e nian rəha lafet rəha Nuhagego-inən, nian rafin iatɨkɨs suah kit mahl-iarəpən e kalapus. ?Kən təhrol? ?Itəmat nakotolkeike məmə io ekegəhan-in kən mɨkɨs kig rəha netəm Isrel?” ");
INSERT INTO tnn_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Kən ilat kotagət əfəməh motən məmə, “!Kəpə! !Itɨmat ekotapəs suah un, ekototolkeike Parapas!” Parapas un, in iakləh kit, kən in təmatəluagɨn matohamnu itəm məmə otəhg-iarəp kapman rəha Rom. ");
INSERT INTO tnn_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kən Pailat təmos-ipən Iesu e nelmɨ rəhan mopael mɨn, kən ilat kəmotalis-alis. ");
INSERT INTO tnn_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Kən kəmotəmɨk nol itəm tol nihlən-nihlən, motol hat lan, tahmen e hat rəha kig, kən motəfauin-pən e rəhn-kapə. Kən motuwɨn-in-pən kot əfəməh kit kəm in, tol nəguɨ-naris lan, tahmen e kot rəha kig. ");
INSERT INTO tnn_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Kən ilat motuwa ron, moatol mɨləh lan, kən moatən məmə, “Ik u inu, kig rəha netəm Isrel. Itɨmat ekotos-ipən nɨsiaiiən kəm ik.” Kən ilat moatem-pən əm nɨkapɨn. ");
INSERT INTO tnn_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Kən Pailat tiet mɨn muwɨn ihluə, kən matən-ipən kəm netəmim məmə, “Ei, netəmim. Io ekahl-iarəp mɨn suah u tuwa ihluə, məmə itəmat onəkotəplan-tu məmə io esehmən nolən rat lan ne.” ");
INSERT INTO tnn_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Kən Iesu təmiet mɨn muwa ihluə. In tatəfauin hat u itəm kəmol e nol itəm tol nihlən-nihlən, tahmen e hat rəha kig, kən matuwɨn e kot əfəməh tol nəguɨ-naris, tahmen e kot rəha kig, kən Pailat tən-ipən kəm ilat məmə, “!Netəmim! !Otəplan-tu! !Suah u inu!” ");
INSERT INTO tnn_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Məto nian pris asol mɨn ne mopael mɨn itəm koatehm Nimə Rəha Uhgɨn kəmotəplan, ilat kəmotagət əfəməh moatən məmə, “!Okəht-ipən e nɨg kəməluau! !Okəht-ipən e nɨg kəməluau!” Kən Pailat təmən-ipən kəm ilat məmə, “Itəla, itəmat pɨsɨn əm, otɨləs motuwɨn, motəht-ipən in e nɨg kəməluau. Məto io esəplanən nolən rat kit ne lan.” ");
INSERT INTO tnn_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Məto ilat kotəmə, “Rəhatɨmat kit əh-ikɨn lou tatən məmə in otəkəike mɨmɨs, məto-inu in tatən məmə in Nətɨ Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Kən nian Pailat təməto nəghatən u, in təməgɨn pɨk təhmɨn mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Kən in təmatɨg muwɨn mɨn imə, mətapəh o Iesu məmə, “?Ik etəm hiə?” Məto Iesu təsuhalpɨnən rəhan nəghatən. ");
INSERT INTO tnn_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Kən Pailat tən-ipən kəm in məmə, “?Təhrol nəsən-ipamən kəm io? ?Ik nəsɨtunən məmə io iatos nəsanənən məmə ekahl-iarəp ik, kən matos mɨn nəsanənən məmə okəht-ipən ik e nɨg kəməluau?” ");
INSERT INTO tnn_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Kən Iesu tən-ipən kəm in məmə, “Okəmə Uhgɨn təməsolən nat u, okol ik onəsos agɨn-əhən nəsanənən məmə onakakil io. Tol nəhlan, nolən rat rəha suah un itəm təmos-ipɨnə io e nelməm, in tərat maprəkɨs-in rəham.” ");
INSERT INTO tnn_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kən tətuoun e nian əh, Pailat təmolkeike məmə otɨkɨs Iesu. Məto netəm-iasol mɨn rəha netəm Isrel koatagət əfəməh moatən məmə, “Okəmə nakɨkɨs suah u mahl-iarəp, kən ik sənəmə etəmim rəha Sisa. Etəmim u itəm tatən məmə in kig, in tɨkɨmɨr rəha Sisa.” ");
INSERT INTO tnn_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kən nian Pailat təməto nəghatən u, kən təmit Iesu muwa mɨn ihluə. Kən in təmuwɨn e ikɨn kit, nərgɨn un, Lou Kəpiel Epin-Epin, e nəghatən Isrel, in Kapata, kən matəpələh-pər jea rəha nakilən. ");
INSERT INTO tnn_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tɨnuəkɨr mɨtgar tətul e tina, e nian ətuatɨp rəha nol əpen-əpenəən o nolən lafet rəha Nuhagego-inən. Kən Pailat tən-ipən kəm netəm Isrel məmə, “!Ei netəm mɨn əpə! !Otəplan-tu! !Suah u in kig rəhatəmat!” ");
INSERT INTO tnn_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Məto ilat kəmotagət əfəməh, motən məmə, “!Ohamnu! !Ohamnu! !Əht-ipən e nɨg kəməluau!” Kən Pailat təmən-ipən kəm ilat məmə, “?Itəmat nakotolkeike mə io ekəht-ipən kig rəhatəmat e nɨg kəməluau?” Məto pris asol mɨn kotəmə, “!Sisa əm un, in rəhatɨmat kig!” ");
INSERT INTO tnn_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kən Pailat təmegəhan-in-pən Iesu tuwɨn e nelmɨlat, məmə mopael mɨn rəha Rom okotuwɨn motəht-ipən e nɨg kəməluau. Kən ilat kəmotɨləs Iesu motuwɨn. ");
INSERT INTO tnn_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","In tatɨləs nɨg kəməluau rəhan, matiet matuwɨn ikɨn kit mɨn, nərgɨn un, Kolkota e nəghatən rəha netəm Isrel. Nɨpətɨn u, “Louipɨl-uipɨl.” ");
INSERT INTO tnn_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Kən ikɨn əh, kəmotəht-ipən Iesu e nɨg kəməluau. Kən kəmotatɨg motəht-ipən mɨn etəmim kəiu, kit e nɨkalɨn matɨp, kit e nɨkalɨn mol, kən Iesu in tatəkul ilugɨn elau. ");
INSERT INTO tnn_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Kən Pailat təmən kəte rəkɨs nəghatən kit, kɨləs kan kəht-ipən e rəhn-kapə nɨg kəməluau. Nəghatən u tatən məmə, Iesu, etəm Nasaret, kig rəha netəm Isrel. ");
INSERT INTO tnn_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Kən netəm Isrel tepət, ilat kotafin nəghatən u, məto-inu ikɨn əh kəmotəht-ipən Iesu ikɨn, in iuəhkɨr əm o taon. Kən nəghatən u, kəməte rəkɨs e nəghatən rəha netəm Isrel, ne nəghatən rəha netəm Rom, ne nəghatən rəha netəm Kris. ");
INSERT INTO tnn_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kən pris asol mɨn rəha netəm Isrel, kəmotuwɨn motən-ipən kəm Pailat məmə, “Onəkəsəteən məmə, ‘Kig rəha netəm Isrel.’ Təwɨr mə onakəte ilə məmə, ‘Suah u in tatən məmə in kig rəha netəm Isrel.’” ");
INSERT INTO tnn_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Məto Pailat təmə, “Nat itəm eməte, eməte.” ");
INSERT INTO tnn_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kən nian mopael mɨn kəmotəht-ipən rəkɨs Iesu e nɨg kəməluau, kən motəmɨk rəhan natɨmnat, kən kəmotoor ilat nəmtɨn kuwɨt, məto-inun mopael mɨn ilat kuwɨt. Məto kot əfəməh rəhan, etəmim itəm in təmol nɨməhan, in təmɨsɨlpɨn-ɨlpɨnən nɨməhan lan, in təmol apiəpiə əm nɨməhan əh. ");
INSERT INTO tnn_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Kən mopael mɨn u kɨnotən-ən kəm ilat mɨn məmə, “Ei, təsəwɨrən məmə okotearəsin nat u. Təwɨr məmə okotatɨpin əm tais ron. Kən etəm tatol win lan, in tɨtol rəhan u kot.” Nat u təmiet məmə otol nəghatən rəha Naoa Rəha Uhgɨn tuwa mol nɨpahrienən, u təmən məmə, “Ilat kəmotəmki-rəkɨs rəhak natɨmnat. Ilat kəmotoor elat mɨn. Kən ilat kəmotatɨpin tais məmə otəgətun məmə pah otos natɨmnat mɨn əh.” Kən tol nəhlan, mopael mɨn kəmotol mihin pahrien. ");
INSERT INTO tnn_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Kən iuəhkɨr əm o nɨg kəməluau rəha Iesu, nɨpɨtan kuwɨt kəmoatətul əh-ikɨn. Mama rəha Iesu, ne pia rəhan mama, ne Meri kit mɨn, pətan rəha Klopas, kən iahunin kit mɨn Meri pətan Maktala. ");
INSERT INTO tnn_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kən nian Iesu təməplan rəhan mama ne suah un itəm in tolkeike pɨk katuətul e nɨkalɨn, kən tən-ipən kəm rəhan mama məmə, “!Pətan, nətɨm un!” ");
INSERT INTO tnn_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kən mən-ipən kəm suah u məmə, “Ik rəham u mama.” Kən tətuoun e nian əh, suah u təmit pətan un mian iman ikɨn, kən in təmatehm wɨr in, tahmen e rəhan mama ətuatɨp. ");
INSERT INTO tnn_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Kən uarisɨg lan, Iesu təmɨtun məmə wək mɨn itəm in təmuwa məmə otol, tɨnol namnun rəkɨs. Kən o nolən nəghatən mɨn e Naoa Rəha Uhgɨn tuwa mol nɨpahrienən lan, in təmən məmə, “Enoaoa.” ");
INSERT INTO tnn_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kən pesɨn əkəku kit əh-ikɨn tatəpələh, kəmiuw-pən wain lan u tagɨn. Kən ilat kəmotɨləs nat kit tame-ame tahmen e katən, kən moteer-pən e wain un, kən motatu-pən e nelmɨ nɨg katən mə hisop, kən motɨləs-ipər tuwɨn iuəhkɨr o nohlɨ Iesu, məmə otɨrɨm. ");
INSERT INTO tnn_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Kən nian in təmənɨm wain u məsɨn, kən məmə, “!Natɨmnat rafin tɨnol namnun!” Kən təmətag-iəhau, megəhan-in-pən rəhan namegən tiet, kən mɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nian əh rəha nol əpen-əpenəən, məto-inu okən lawɨgin un, nian rəha Sapat. (Kən Sapat u, in Sapat keike kit.) Kən netəm-iasol rəha netəm Isrel kəsotolkeikeən məmə nɨpətɨ suah miləhal əh okətəhaləkul e nɨg kəməluau mətoarus-pən nian əh. Kən o nat əh, ilat kəmotuwɨn motətapəh o Pailat məmə otahl-ipa rəhan mɨn netəmim, kotuwɨn, motətgəhl nelkɨləhal, pəs iləhal kəhalɨmɨs uəhai əm. Kənu ilat kotɨləs-irəkɨs nɨpətɨləhal. ");
INSERT INTO tnn_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kən mopael mɨn kəmotaupən motətgəhl nelkɨ suah mil un kəiu itəm kəmotəht-ipən ilau e nɨg kəməluau iləhal Iesu. ");
INSERT INTO tnn_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Məto nian kəmotuwa o Iesu, motəplan məmə in tɨnɨmɨs rəkɨs. Kən əmun, ilat kəsotətgəhlən nelkɨn. ");
INSERT INTO tnn_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kən mopael kit təmaru əm nɨkalɨn e rəhan nɨro, kən roiu agɨn-əh, nɨta ne nəhau kəmuaiəh ahmen-ahmen əm, mətuatite e nɨpətɨn. ");
INSERT INTO tnn_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Kən suah kit əh-ikɨn tatətul, in təmehm natɨmnat mɨn u e nɨganəmtɨn. Kən nəghatən mɨn rəha suah u, in tətuatɨp, kən in tɨtun məmə in tatən pahrien. Kən in tatən-iarəp məmə itəmat mɨn onəkotɨtun motahatətə lan.) ");
INSERT INTO tnn_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Natɨmnat mɨn u kəmotuwa məmə okotol nəghatən e Naoa Rəha Uhgɨn tuwa mol nɨpahrienən lan, u tatən məmə, “Okol nɨkɨlɨkɨlin kit təsɨtəgɨtən.” ");
INSERT INTO tnn_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kən nəghatən kit mɨn e Naoa Rəha Uhgɨn tatən məmə, “Ilat okotəplan suah u itəm kəmotaru.” ");
INSERT INTO tnn_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kən uarisɨg e natɨmnat mɨn u, etəm Aramatia kit, nərgɨn u, Josep. Josep u, in etəmim kit rəha Iesu, məto tatəhluaig-in nat u, məto-inun tatəgin netəm-iasol rəha netəm Isrel. In təmuwɨn məplan Pailat, kən tətapəh ron məmə otegəhan-in pəs tɨləs-irəkɨs nɨpətɨ Iesu. Kən əmun, Pailat təmegəhan-in, kən in təmuwɨn mɨləs-irəkɨs. ");
INSERT INTO tnn_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Kən Nikotimas, u aupən in təmuwɨn məplan Iesu lapɨn, in təmuwɨn ilau Josep. In tatɨtol kətɨm kit, təmərioah e nat pien-pien mɨn u mɨr ne alos. Kətɨm u təfɨgəm tahmen e tate kilo. ");
INSERT INTO tnn_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Kən ilau kəmialəs-irəkɨs nɨpətɨ Iesu, mualpin e nɨməhan wɨr kit, nərgɨn u linen. Kən ilau kəmioal-pən mɨr ne alos e nɨməhan u, tahmen ətuatɨp əm mə inun netəm Isrel kotalpin mihin nɨpətɨ etəmim, moatɨtənɨm. ");
INSERT INTO tnn_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kən ikɨn əh kəməht-ipən Iesu ikɨn e nɨg kəməluau, kəmahwɨnu ikɨn, kən e ikɨn əh, nɨpəg kəpiel kit əh-ikɨn, itəm katɨtənɨm itəm ikɨn. Kən ikɨn əh, kəsɨtənɨm-pənən əh suah kit ikɨn. ");
INSERT INTO tnn_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kən ilau kəmuələhəu-pən nɨpətɨ Iesu e nɨpəg kəpiel u, məto-inu nian əh in nian rəha netəm Isrel koatol əpen-əpenə lan o Sapat, kən nɨpəg kəpiel itəm katɨtənɨm itəm ikɨn, in iuəhkɨr əm. ");
INSERT INTO tnn_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","E Sante, laulaugɨn agɨn, tɨtapinəp-apinəp əh, Meri u pətan Maktala, təmuwɨn e nɨpəg kəpiel, kən məplan məmə kəpiel asol itəm kəmahtosɨg-in nɨpəg kəpiel lan, in kəmahwin rəkɨs. ");
INSERT INTO tnn_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tol nəhlan, kən in təmaiu mɨtəlɨg muwɨn o Saimon Pita ne etəmim u kit mɨn rəha Iesu, u Iesu tolkeike pɨk, kən mən-ipən kəm ilau məmə, “Ilat kəmotɨləs-irəkɨs nɨpətɨ Iərəmərə əpəh e nɨpəg kəpiel. Kən ekotəruru məmə kəmotələhəu hiə nɨpətɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kən Pita ne etəmim kit mɨn u rəha Iesu, kəmiaiet mətian məmə okuəplan nɨpəg əh. ");
INSERT INTO tnn_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Kəmuaiu əsanən mian, məto suah u kit in təmaiu maupən maprəkɨs-in Pita, maupən muwɨn əpəh nɨpəg u ikɨn. ");
INSERT INTO tnn_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Kən in təməməhl-əməhl mətag-pən əpəh imə, kən məplan nɨməhan wɨr u linen tatəməhl, məto in təməsuwɨnən imə. ");
INSERT INTO tnn_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kən Saimon Pita in təmiet-arəpa mɨn, kən megupən uəhai əm imə e nɨpəg kəpiel u, kən təməplan nɨməhan u koatəməhl, ");
INSERT INTO tnn_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","kən məplan mɨn nɨməhan u kəmotalpin rəhn-kapə Iesu lan aupən. Nɨməhan u, in təsəməhl-pənən ilat nɨməhan mɨn un neen, məto in kəmaiu-aiu wɨr kələhəu pɨsɨn. ");
INSERT INTO tnn_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Etəmim u rəha Iesu itəm təmaupən, in mɨn təmuwɨn imə e nɨpəg kəpiel, kən in təməplan natɨmnat mɨn u, kən in təmatahatətə məmə Iesu tɨnəmegəh mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Naoa Rəha Uhgɨn tatən məmə Iesu otəkəike məmegəh mɨn e nɨmɨsən, məto ilat kəsotɨtun wɨrən əh nəghatən əh.) ");
INSERT INTO tnn_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Kən etəmim mil un rəha Iesu kəmiatəlɨg mətian iməlau ikɨn, ");
INSERT INTO tnn_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","məto Meri in tatətul iuəhkɨr e nɨpəg kəpiel u mətasək. Kən nian in təmətasək əh, kən məməhl-əməhl mətuag-pən əpəh e nɨpəg. ");
INSERT INTO tnn_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Kən əmun təməplan nagelo kəiu əpəh imə. Natɨmnat rəhalau in təruən təruən. Ilau katuəpələh u ikɨn-u kəmələhəu-pən Iesu ikɨn. Kitiəh tatəpələh e nəme rəhn-kapə, kən kitiəh e nəme nelkɨn. ");
INSERT INTO tnn_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Kən ilau kəmuətapəh ron məmə, “Pətan. ?Ik natasək o naka?” Kən in təmən-ipən kəm ilau məmə, “Ilat kəmotɨləs-irəkɨs nɨpətɨ Iərəmərə rəhak, kən ekəruru məmə kəmotələhəu-pən hiə.” ");
INSERT INTO tnn_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nian in tɨnən rəkɨs nəghatən u, kən meirair, kən təməplan Iesu tatətul əm u ikɨn-un, məto in təruru məmə Iesu. ");
INSERT INTO tnn_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Kən Iesu təmətapəh ron məmə, “Pətan. ?Nakətasək o naka? ?Ik nategəs-in pah?” Məto pətan u, nɨkin təht məmə okəmə naka suah u itəm tatɨtasɨlin nahwɨnuən, kən in təmən-ipən kəm in məmə, “Etəm-iasol, okəmə ik nəmɨləs-irəkɨs nɨpətɨn, kən mələhəu-pən əh kit, awi, ən-ipa-tu kəm io, pəs io ekuwɨn mɨləs.” ");
INSERT INTO tnn_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Kən Iesu tən-ipən məmə, “Meri.” Kən Meri təmeirair, mətag-pən məplan, kən məmə, “!Raponi!” (Inu nəghatən rəha netəm Isrel u, nɨpətɨn təmə, “Rəhak Iəgətun.”) ");
INSERT INTO tnn_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Kən Iesu təmən-ipən kəm in məmə, “Saskəlɨmən io, məto-inu io esuwɨnən əh əpəh ilɨs o rəhak Tata. Məto ik, uwɨn, mehm piak mɨn kən mən-ipən kəm ilat məmə io enatɨtəlɨg-pən ilɨs o rəhak Tata, kən in mɨn rəhatəmat Tata. In Uhgɨn rəhak, kən in Uhgɨn mɨn rəhatəmat.” ");
INSERT INTO tnn_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kən Meri Maktala təmuwɨn məplan netəmim mɨn rəha Iesu, kən tən-ipən kəm ilat məmə, “!Suah mɨn əpə! !Io eməplan Iərəmərə!” Kən in təmən-iarəp nəghatən mɨn itəm Iesu in təmən-ipən kəm in. ");
INSERT INTO tnn_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","E Santei ehnaipən, netəmim mɨn rəha Iesu kəmotargəfɨmɨn ilat mɨn əpəh e nimə kit, kən motahtosɨg e toa motol lok lan, məto-inu ilat koatəgin netəm-iasol rəha netəm Isrel. Kən əmun, Iesu təmuwa mətul ilugɨn elat, kən mən-ipən kəm ilat məmə, “Pəs nəməlinuən tətatɨg otəmat.” ");
INSERT INTO tnn_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kən in təmurapɨk nelmɨn kən mol-pən nɨkalɨn kəm ilat, kən nɨkilat təmagien pɨk məto-inu kɨnotəplan Iərəmərə. ");
INSERT INTO tnn_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Kən Iesu tən-ipən mɨn kəm ilat məmə, “Pəs nəməlinuən tətatɨg otəmat. Tol mə rəhak Tata təmahl-ipa io, e nolən kitiəh əm io etahl-ipən itəmat nakoatuwɨn e nətueintən.” ");
INSERT INTO tnn_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kən nian in tɨnən rəkɨs nəghatən u, kən in təmehag-pən elat, kən məmə, “Itəmat, otos Narmɨn Rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Okəmə nəkotaluin nolən rat rəha etəmim, kən Uhgɨn mɨn in otafəl rəkɨs nolən rat rəhan. Məto okəmə itəmat nəsotaluinən nolən rat rəha etəmim, kən Uhgɨn otəsaluinən kən məsafəl rəkɨsən.” ");
INSERT INTO tnn_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Kən etəm tuelef u kit rəha Iesu, nərgɨn u Tomas, u kətaun-in məmə, Mil Mil, in təmɨkə e nian Iesu təmiet-arəpa olat. ");
INSERT INTO tnn_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kən in mɨn neen, ilat kəmotən-ipən kəm in məmə, “!Ei, emotəplan rəhatat Iərəmərə!” Məto Tomas təmən-ipən kəm ilat məmə, “Okəmə ekəplan nəme nil e nelmɨn mil, kənu ekek e noanelmɨk, kənu mea-pən e nəme nɨro e nɨkalɨn, kənu panahatətə lan. Məto okəmə esəplanən, okol esahatətəən lan.” ");
INSERT INTO tnn_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Kən tɨnos wik kitiəh rəkɨs, netəmim mɨn rəha Iesu koatəpələh mɨn əpəh imə, e nimə kitiəh əm, kən motahtosɨg e toa, motol lok. Kən Tomas əh-ikɨn ilat min. Nat əpnapɨn kəmol lok e toa, məto Iesu tatɨg muwa mɨn mətul ilugɨn elat mən-ipən məmə, “Pəs nəməlinuən tətatɨg otəmat.” ");
INSERT INTO tnn_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kən mən-ipən kəm Tomas məmə, “Əplan-tu nelmək. Wa mek e noanelməm. Kən məg-ətuatɨp-in nelməm kən mea-pən e nəme nɨro u e nɨkalɨk. Səmɨk mətmətɨgən rəham nahatətəən rəun, məto ik onəkəike mətahatətə lak.” ");
INSERT INTO tnn_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Kən Tomas tən-ipən kəm in məmə, “Ik rəhak Iərəmərə, kən ik rəhak Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Kən Iesu tən-ipən kəm in məmə, “Ik nəmahatətə lak, məto-inu nəməplan io. Məto netəm mɨn un kəsotəplanən io, kən ilat kotahatətə lak, ilat okotos nəwɨrən pahrien, nɨkilat tagien pahrien.” ");
INSERT INTO tnn_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iesu təmol nəmtətin mɨn tepət e nɨganəmtɨ rəhan netəmim, itəm kəsəte rəkɨsən e naoa u. ");
INSERT INTO tnn_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Məto kəməte nəghatən mɨn u məmə itəmat onəkotahatətə məmə Iesu in Kristo itəm Uhgɨn təmən məmə otahl-ipa, inu Nətɨ Uhgɨn. Kəməte nəhlan, məmə itəmat onəkotos nəmegəhən e nərgɨn, məto-inu itəmat noatahatətə lan. ");
INSERT INTO tnn_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Uarisɨg e natɨmnat mɨn u, Iesu təmol əp mɨn in o rəhan mɨn netəmim, əpəh e nɨməkləkɨl e nɨkalɨ lek asol, katən mə Lek Kalili. Kən təmol əp in nulan. ");
INSERT INTO tnn_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","E nian əh, netəmim mɨn u rəha Iesu kəmotaliwək kitiəh: Saimon Pita, ne Tomas u kətaun-in məmə Mil Mil, ne Nataniel u, etəm Kalili iman latuənu Kena, ne nətɨ Sepeti mil, ne etəmim mil kəiu mɨn rəha Iesu. ");
INSERT INTO tnn_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Pita tən-ipən olat məmə, “Io enatuwɨn ekatɨpin net.” Kən ilat kotəmə, “Itəla, pəs kitat rafin kotuwɨn.” Kən ilat rafin kəmotatite, motuwɨn e pot kit. Kən Pita təmapeg rəhan natɨmnat o wək. Kən ilat kəmotuwɨn, motatɨpin net, motətoarus tian. Məto kəsotosən nəm kit ne. ");
INSERT INTO tnn_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kən tɨnatian, kən Iesu tuwa matətul ipar, məto rəhan mɨn netəmim, ilat kotəruru məmə Iesu. ");
INSERT INTO tnn_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","In tətapəh olat məmə, “!Nəman! ?Nəsotosən nəm kit, o?” Kən ilat kotəmə, “Kəpə, nəm tɨkə.” ");
INSERT INTO tnn_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kən in tən-ipən kəm ilat məmə, “Itəla, otatɨpin-pən-tu net e matɨp ikɨn e nɨkalɨ pot u, kən onəkotiuw nəm neen.” Kən əmun, kotatɨpin-iarəp net, əmun, mɨnotəruru niuw-pərən, məto-inu net tɨnər mɨnər mɨnərioah e nəm. ");
INSERT INTO tnn_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Kən suah u itəm Iesu tolkeike pɨk, in tən-ipən kəm Pita məmə, “!Ei! !Iərəmərə ətuatɨp əh!” Kən nian Pita təməto nəghatən u, təmətəut uəhai əm, kən mətɨpən itəhəi, meai muwɨn ipar. ");
INSERT INTO tnn_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Kən netəmim mɨn u neen rəha Iesu, ilat kəmotuwar e pot, moatiuw net apon təmərioah e nəm, məto-inu bot in iuəhkɨr əm məsɨn o nɨməkləkɨl, tahmen əm hanrɨt mita. ");
INSERT INTO tnn_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kən nian ilat kəmotuwɨn ipar, motəplan nɨgəm əkəku kit əh-ikɨn, nəmtahlɨn tatuəp əh, kən nəm neen əh-ikɨn, katuwan e nɨgəm, ne pɨret əh-ikɨn. ");
INSERT INTO tnn_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Kən Iesu tən-ipən kəm ilat məmə, “Otəmɨk nəm mɨn un neen itəm nəmotos motuwa.” ");
INSERT INTO tnn_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Kən Saimon Pita təmuwɨn mɨn e pot, kən mewkəkan net muwɨn əpəh ipar. Net u tərioah e nəm asol mɨn, ilat rafin wan-hanrɨt-fifti-tri. Kən nat əpnapɨn məmə net u təmərioah pap e nəm, məto in təməsəhapən. ");
INSERT INTO tnn_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Kən Iesu təmən-ipən kəm ilat məmə, “Otuwa motagwən.” Kən ilat kit nɨkin təsəhtən məmə otətapəh ron məmə, “?Ik pah un?” məto-inu ilat kɨnotɨtun əsas məmə in Iərəmərə. ");
INSERT INTO tnn_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Kən Iesu təmos pɨret muwa mos-ipən kəm ilat, kən mos-ipən mɨn nəm. ");
INSERT INTO tnn_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Kən inu, nian tatol kɨsɨl lan, itəm Iesu təmol əp in o rəhan mɨn netəmim uarisɨg e nian in təmɨmɨs, kən məmegəh mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nian ilat kɨnotagwən rəkɨs, Iesu təmətapəh o Saimon Pita, məmə, “Saimon, nətɨ Jon. ?Ik nakolkeike io taprəkɨs-in netəm mɨn un?” Pita tən-ipən kəm in məmə, “Əwəh, Iərəmərə, ik nəkɨtun məmə io ekolkeike pɨk ik.” Kən Iesu tən-ipən kəm in məmə, “Itəla, ik onakatagwən rəhak nenətɨ sipsip mɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kən Iesu tatɨg mətapəh mɨn ron məmə, “Saimon, nətɨ Jon. ?Ik nakolkeike io?” In tən-ipən kəm Iesu məmə, “Əwəh Iərəmərə, ik nəkɨtun məmə iakolkeike ik.” Kən Iesu tən-ipən kəm in məmə, “Itəla, ik onakatehm wɨr rəhak sipsip mɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kən mətau kɨsɨl lan, Iesu tatɨg mətapəh mɨn ron məmə, “Saimon, nətɨ Jon. ?Ik nakolkeike io?” Kən Pita, nɨkin təmahmə, məto-inu Iesu təmətapəh ron mau kɨsɨl, məmə, “?Ik nakolkeike io?” Kən in tən-ipən kəm in məmə, “Iərəmərə, ik nəkɨtun natɨmnat rafin. Ik nəkɨtun məmə io ekolkeike ik.” Kən Iesu tən-ipən kəm in məmə, “Itəla, ik atagwən rəhak sipsip mɨn. ");
INSERT INTO tnn_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“Nɨpahrienən agɨn u iatən kəm ik məmə, aupən, e rəham netəm-aluəən, nəmatiargin atɨp rəham kətəut, kən mətaliwək matuwɨn ikɨn mɨn rafin itəm nakolkeike məmə nakuwɨn ikɨn. Məto nian ik onakaguɨhl, onakəg-ətuatɨp-in nelməm, kən etəm pɨsɨn kit otəlis ətain rəham kətəut, kən mit ik nakian ikɨn ik nəsolkeikeən məmə nakuwɨn ikɨn.” ");
INSERT INTO tnn_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","E nəghatən u, Iesu təmaupən matən-iarəp rəkɨs əm, nolən itəm Pita otɨmɨs, kən rəhan nɨmɨsən, in otɨləs-ipər nərgɨ Uhgɨn. Kən Iesu tən-ipən kəm in məmə, “Itəla, uarisɨg-in io.” ");
INSERT INTO tnn_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Kən Pita teirair məplan etəmim kit rəha Iesu u, Iesu tolkeike pɨk, tatuarisɨg-in ilau. Suah əh inəh, itəm təmiəu-iəu muwa iuəhkɨr o Iesu e nian kəmotagwən e lafet rəha Nuhagego-inən, kən matətapəh ron məmə, “?Iərəmərə, pah un otegəhan-in-pən ik e nelmɨ rəham tɨkɨmɨr mɨn?” ");
INSERT INTO tnn_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nian Pita təməplan in, kən tətapəh o Iesu məmə, “?Iərəmərə, məto tahro e suah əh?” ");
INSERT INTO tnn_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Kən Iesu tən-ipən kəm in məmə, “?Okəmə io ekolkeike məmə in otatəmegəh muwɨn mətoarus nian iakɨtəlɨg-pa mɨn, ik onəkɨtun o naka? Ik un, ik onəkəike muarisɨg-in io.” ");
INSERT INTO tnn_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kən tol nəhlan o nat u Iesu təmən, nəghatən kit əh-ikɨn katən tɨtəlau-ɨtəlau e piatat mɨn məmə, “Etəmim u rəha Iesu otəsɨmɨsən,” məto Iesu təməsənən kəm Pita məmə suah u otəsɨmɨsən. In təmən əm məmə, “?Okəmə, io ekolkeike məmə in otatəmegəh, mətoarus-pən iakɨtəlɨg-pa mɨn, ik onəkɨtun o naka?” ");
INSERT INTO tnn_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Etəmim u rəha Iesu in etəmim kitiəh əm itəm tatən-iarəp natɨmnat mɨn u, kən in məte rəkɨs nəghatən mɨn u. Kən itɨmat ekotɨtun məmə nəghatən mɨn u tatən, in nɨpahrienən əm. ");
INSERT INTO tnn_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kən natɨmnat tepət mɨn əpəh ikɨn itəm Iesu təmol kən okəmə netəmim kəpoatəte rəkɨs natɨmnat mɨn u ilat rafin e naoa mɨn, io, nɨkik təht məmə rum otɨkə e nətueintən rafin o nəlɨnən naoa mɨn u. ");
INSERT INTO tnn_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofilas, e rəhak naoa itəm eməte aupən, eməte nolən mɨn rəha natɨmnat rafin itəm Iesu təmatol ne matəgətun netəmim lan. ");
INSERT INTO tnn_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Naoa əh tatən-iarəp nian Iesu təmətuoun rəhan wək mətoarus Uhgɨn təmɨləs matuwɨn e Nego e Neai. Məto aupən, təməsuwɨnən əh e Nego e Neai, Narmɨn Rəha Uhgɨn təmətasitu lan məmə otəgətun rəhan aposol mɨn. ");
INSERT INTO tnn_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","E nian təməmegəh mɨn e nɨmɨsən, nian tepət tatuwa olat kən ilat kotəplan in e nian kitiəh kitiəh e nian foti, kən matol əp in kəm ilat məmə okotɨtun məmə in təməmegəh pahrien e nɨmɨsən. Kən e nian mɨn əh, təmatəgətun ilat e nərəmərəən rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nian Iesu təmətatɨg əh ilat min ilat, in təmən-ipən nəghaten kit kəm ilat məmə, “Itəmat onəsotaupənən motiet u e Jerusalem. Onəkotəkəike kətatɨg motətoarus onəkotos Narmɨn Rəha Uhgɨn, u rəhak tata tɨnəmən-iəkɨs rəkɨs məmə otos-ipɨnə kəm itəmat, tahmen mɨn məmə inu io iatən-ipɨnə kəm itəmat. ");
INSERT INTO tnn_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Aupən Jon təmatol baptais e netəmim e nəhau, məto otəsuwəhən, Uhgɨn in otol baptais etəmat e Narmɨn Rəhan.” ");
INSERT INTO tnn_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","E nian mɨn əh, itəm aposol mɨn kəmotatɨg ilat Iesu, kəmotətapəh ron məmə, “?Iərəmərə, tɨnuwa e nian ətuatɨp əh-roiu məmə ik onəkol kitat netəm Isrel okotərəmərə mɨn e nɨtən mɨn rəhatat, o kəp?” ");
INSERT INTO tnn_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Məto Iesu təmən-ipən kəm ilat məmə, “E nian mɨn rəha natɨmnat mɨn əh, Uhgɨn təməhluaig-in otəmat, okol itəmat nəsotɨtunən. Rəhak tata pɨsɨn əm, in tɨnɨtəpun rəkɨs e rəhan nəsanənən. ");
INSERT INTO tnn_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Məto e nian Narmɨn Rəha Uhgɨn otuwa matɨg etəmat, itəmat onəkotos nəsanənən. Kən itəmat onokotəkəike motuwɨn motən-iarəp rəhak nəghatən əpəh Jerusalem, ne ikɨn mɨn əpəh Jutia, ne Sameria, kən ne ikɨn mɨn rafin e nətueintən.” ");
INSERT INTO tnn_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nian təmən rəkɨs əm nəghatən əh kəm ilat, kən Uhgɨn təmɨləs-irəkɨs in tɨnər matuwɨn e neai. Nian ilat kəmoatəplan, kən napuə kit təmuwa malpin, kən ilat kəməsotəplan mɨnən. ");
INSERT INTO tnn_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nian kəmotɨtagpər əh e neai moategəs-in, roiu agɨn-əh, suah mil kəiu kəmian e natɨmnat ruən kəmuet-arəpa muətul ilugɨn elat, ");
INSERT INTO tnn_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","kən muən-ipən kəm ilat məmə, “!Netəm Kalili! ?Təhrol nəkoatətul ikɨn-u moatətagpər nəpo lan e napuə? Iesu əh itəm Uhgɨn təmɨləs-irəkɨs otəmat mɨləs mər matuwɨn e neai, in otəpanɨtəlɨg-pa mɨn tahmen-pən əm e itəm əh, itəm tər matuwɨn.” ");
INSERT INTO tnn_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kən aposol mɨn kəmotiet e nɨtot u katən məmə, Nɨtot Rəha Nɨg U Olif, motɨtəlɨg-pən Jerusalem itəm sənəmə in isəu pɨk, in iuəhkɨr əm. ");
INSERT INTO tnn_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nian kəmotiet-arəpən Jerusalem, kəmotuwɨn e nɨpəgnoa nimə kit əpəh ilɨs lan itəm koatatɨg ikɨn. Aposol mɨn əh, nərgɨlat u Pita ne Jon ne Jemes ne Antru, kən Filip ne Tomas, kən Patolomiu ne Matiu, kən Jemes nətɨ Alfeas, kən Saimon Selot, kən Jutas nətɨ Jemes. ");
INSERT INTO tnn_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Netəm mɨn əh ne nɨpɨtan mɨn, ne Meri u mama rəha Iesu, ne pia Iesu mɨn, ilat koatuwa moatəfak kitiəh nian tepət. ");
INSERT INTO tnn_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nian neen tɨnuwa mɨnuwɨn rəkɨs, kən netəm mɨn u itəm koatahatətə e Iesu kəmotuwa kitiəh. Ilat tepət, tahmen e wan-hanrɨt-tuente ilat rafin. Kən Pita təmətul matəghat kəm ilat məmə, ");
INSERT INTO tnn_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Piak mɨn ne wɨnɨk mɨn. Nəghatən rəha Naoa Rəha Uhgɨn otəkəike muwa mol nɨpahrienən lan, itəm nuwəh aupən Narmɨn Rəha Uhgɨn təmos-ipən nəghatən kəm Kig Tefɨt, kən Kig Tefɨt təmən-iarəp suah u Jutas məmə in otit netəmim motuwɨn kaskəlɨm Iesu. Kən nəghatən əh tɨnuwa əh-roiu mɨnol nɨpahrienən lan. ");
INSERT INTO tnn_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jutas kitat min kitiəh əm. Kən in rəhan əh-ikɨn wək itəm təmatol mətasitu etat.” ");
INSERT INTO tnn_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Jutas u inu təmos-nəmtɨn nəptən kit e məni u təmos e nolən rat itəm təmol. E nəptən əh, təmiet morin kən kəhap nərpɨn nɨsgan tiet. ");
INSERT INTO tnn_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kən netəm Jerusalem kəmotəto nəghatən əh, kəmotaun-in nəptən əh e nəghatən ikɨn məmə, “Akeltama,” nɨpətɨn u məmə Nəptən e Nɨta.) ");
INSERT INTO tnn_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Kən Pita təmən məmə, “E Naoa Rəha Napuən Mɨn, nəghatən kit tatən məmə, ‘Təwɨr məmə rəhan nimə tatətul əpnapɨn əm, okol etəmim kit təsatɨgən ikɨn.’ “Kən nəghatən kit mɨn tatən min-nulan məmə, ‘Təwɨr məmə etəm pɨsɨn kit otuwa mos nəmeen mol wək rəhan.’ ");
INSERT INTO tnn_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Kən tol nəhlan, okotəkəike kɨlesipər suah kit itəm təmehm e nɨganəmtɨn nəmegəhən rəha Iesu e nɨmɨsən, kən in otuwa mɨn mehm kitat məmə otən-iarəp Iesu məmə in Iərəmərə rəhatat. Suah u, in suah kit itəm kitat min kəmoatan aupən e nian mɨn u itəm Iərəmərə Iesu təmətaliwək lan. Suah un in suah kit itəm təmətatɨg nian Jon təmatən-iarəp nəghatən rəha nolən baptais etəm, muwa mətoarus-pən nian itəm Uhgɨn təmos-irəkɨs Iesu o kitat mɨləs mər muwɨn e Nego e Neai.” ");
INSERT INTO tnn_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Kən ilat kəmotən-iarəp nərgɨ etəmim kəiu, kit nərgɨn u Josep u nian neen kətaun-in məmə Pasapas o Jastas, kən kit mɨn, nərgɨn u Matias. ");
INSERT INTO tnn_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Kən ilat kəmotəfak motən məmə, “Iərəmərə, ik nəkɨtun nɨki netəmim rafin. Ik asitu etɨmat məmə suah mil u, in pəhruən ik nɨnəmɨtəpun rəkɨs ");
INSERT INTO tnn_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","məmə otaskəlɨm wək u rəha aposol itəm Jutas təmapəs məmə otuwɨn e suatɨp itəm tərat, iman ətuatɨp ikɨn.” ");
INSERT INTO tnn_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nian kəmotəfak rəkɨs, ilat kəmoturin kəpiel neen, kotahmen e tais, məmə otəgətun məmə pah otos wək əh, kən nərgɨ Matias təmiet. Kən ilat kəmotɨləs-ipən Matias məmə in aposol kit, kən roiu tɨnol mɨn tuelef aposol ilat rafin. ");
INSERT INTO tnn_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","E nian rəha Pentekos, lafet kit rəha noanol mɨn rəha Isrel, netəm mɨn u itəm koatahatətə e Iesu kəmotuwa kitiəh. ");
INSERT INTO tnn_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kən roiu agɨn mɨn, kəmotəto nat kit təmɨsɨ-pər e neai tahmen e nɨmətag asol kit tatelel nat, kən nat əh kəmotəto təmuwa mər rafin e nɨpəgnoa nimə itəm koatəpələh ikɨn. ");
INSERT INTO tnn_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kən ilat kəmotəplan nat kit tahmen e nɨgəm təmuəp. Kən ləpləpin nɨgəm mɨn əh, kəmotiwɨg motan ahmen-in netəmim rafin itəm koatəpələh əh imə. ");
INSERT INTO tnn_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kən ilat rafin, Narmɨn Rəha Uhgɨn təmuwa mərioah mətatɨg elat, kən mɨnos-ipən nəsanənən kəm ilat, mol ilat kɨnoatəghat e nəghatən ik pɨsɨn mɨn. ");
INSERT INTO tnn_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kən noanol mɨn neen əh-ikɨn rəha netəm Isrel itəm koatəfak kəm Uhgɨn. Ilat kəmotɨsɨ-pən ik pɨsɨn pɨsɨn mɨn məto kotatɨg Jerusalem. ");
INSERT INTO tnn_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nian ilat kəmotəto nəghatən mɨn əh, netəmim tepət kəmotuwa. Kən ilat kəmotaut pɨk məto-inu kəmotəto nəghatən mɨn rəhalat itəm netəm mɨn əh koatən. ");
INSERT INTO tnn_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kəmotaut pɨk agɨn kən motən məmə, “!Ei! ?Netəm Kalili əm əh koatəghat, o kəp? ");
INSERT INTO tnn_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","?Tahro kitat rafin koatəto rəhatat nəghatən mɨn itəm ilat koatən? ");
INSERT INTO tnn_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","Kitat u netəm ik pɨsɨn pɨsɨn mɨn tepət. Ikɨn-u netəm Patia əh-ikɨn, ne netəm Metia, ne netəm Elam, ne netəm Mesopotemia, ne netəm Jutia, ne netəm Kapatosia, ne netəm Pontas, ne netəm Esia, ne netəm Fritia, ne netəm Pamfilia, ne netəm Ijip, ne netəm Lipia e nɨkalɨn-pən əh Saerin ikɨn, ne netəm Rom, neen noanol ətuatɨp rəha netəm Isrel, neen netəm pɨsɨn məto koatəfak kəm Uhgɨn, ne netəm Krit, ne netəm Arepia. Məto kitat rafin kəmotəto ilat koatən nat asol itəm Uhgɨn təmol e nəghatən ik pɨsɨn mɨn rəhatat.” ");
INSERT INTO tnn_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Narmɨlat təmiwɨg pɨk, rehalat-kapə təmɨkə, kən kəmoatətapəh olat mɨn məmə, “!Ei! ?Naka u tol nulan?” ");
INSERT INTO tnn_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Məto neen kəmotalah-əmnu ilat, motən məmə, “Nat koatapɨs əpəh.” ");
INSERT INTO tnn_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kən Pita təmətul ilat lepen aposol mɨn, təmagət əfəməh matən-ipən kəm netəmim məmə, “Itəmat rafin noanol mɨn rəha Isrel ne netəm pɨsɨn pɨsɨn mɨn u nakoatatɨg Jerusalem, otətəlɨg-in wɨr-tu io, pəs ekuhapɨk e nɨpətɨ nat əh kəm itəmat. ");
INSERT INTO tnn_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Itəmat nakoatən məmə netəm mɨn u koatapɨs. Məto kəp, kəsotapɨsən. Nain kɨlok əm əh-roiu laulaugɨn. ?Kən tahro ilat koatapɨs? ");
INSERT INTO tnn_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","“Məto in tol nulan. Ien rəha Uhgɨn aupən, nərgɨn u Joel, təmən rəkɨs nat u itəm itəmat nakoatəplan. In təmən məmə, ");
INSERT INTO tnn_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Uhgɨn təmən məmə, “E namnun nian mɨn, ekos-ipən rəhak Narmɨn kəm netəmim rafin. Ilat rafin okotos nəsanənən lan. Nenətɨtəmat mɨn, nəman ne nɨpɨtan, ilat okotən-iarəp nəghatən mɨn rəhak itəm io iatos-ipən kəm ilat. Netəm aluə mɨn rəhatəmat, Uhgɨn otos-ipən nat kit tahmen e napɨlaiirən kəm ilat. Kən naguɨhl-aguɨhl mɨn rəhatəmat okotapɨlaiir e napɨlaiirən pɨsɨn pɨsɨn mɨn. ");
INSERT INTO tnn_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Sənəmə netəm-iasol mɨn əm, məto nəman ne nɨpɨtan ilat nolwək mɨn əm rəhak, kən ekos-ipən Narmɨn rəhak kəm ilat. Kən ilat okotən-iarəp nəghatən mɨn rəhak itəm iatos-ipən kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Oekol nat pɨspɨs mɨn əpəh e neai, ne nəmtətin pɨsɨn pɨsɨn mɨn e nɨməptən. Onəkotəplan nɨta ne nɨgəm ne nəhaniəm okotər motol napuə lan. ");
INSERT INTO tnn_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Aupən, mɨtgar otapinəp kən məwɨg otasiə tahmen e nɨta. Kən uarisɨg, Nian asol asol agɨn rəha Iərəmərə otuwa. ");
INSERT INTO tnn_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","E nian əh, netəmim rafin itəm okotaun-in Nərgək, io ekosmegəh ilat.”’ ");
INSERT INTO tnn_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Noanol mɨn rəha Isrel, itəmat otətəlɨg-in nəghatən u. Itəmat nəkotɨtun wɨr nat pɨspɨs mɨn, ne nəmtətin pɨsɨn pɨsɨn mɨn itəm Iesu təmol e nəsanənən rəha Uhgɨn, itəm itəmat nəmotəplan. Natɨmnat mɨn əh tatəgətun məmə Uhgɨn in pɨsɨn əm təmahl-ipa Iesu tuwa. ");
INSERT INTO tnn_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","E nalpəkauən rəha Uhgɨn itəm təmol mələhəu aupən, in təmos-ipɨnə suah u e nelmɨtəmat. Kən itəmat nəmotohamnu in e nian nəmotegəhan-in-pən in tuwɨn e nelmɨ netəm rat kəsotəfakən. Kəmotoh kətu-pər e nɨg kəməluau. ");
INSERT INTO tnn_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","“Məto Uhgɨn təmɨkɨs Iesu e nahməən rəha nɨmɨsən, kən mol in təmegəh mɨn e nɨmɨsən, məto-inu nɨmɨsən, rəhan nəsanənən tɨkə o naskəlɨmən. ");
INSERT INTO tnn_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tefɨt təmən nulan e Iesu aupən məmə, ‘Nian rafin ekɨtun məmə Iərəmərə tətatɨg itɨmlau min. Okol esəgɨnən məto-inu tətatɨg e nɨkalɨk itɨmlau min. ");
INSERT INTO tnn_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Məto-inu o nat əh, io nɨkik tagien pɨk, matənwiwi ik e nohlɨk. Kən nɨkik təməlinu məto-inu ekɨtun məmə Uhgɨn otosmegəh nɨpətɨk. ");
INSERT INTO tnn_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kən okol nəsapɨsən narmək tətatɨg ima netəm kəmotɨmɨs ikɨn. Kən okol nəsegəhan-in mɨnən nɨpətɨ rəham Etəmim Ətuatɨp məmə otəmnəmɨt. ");
INSERT INTO tnn_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ik nəməgətun rəkɨs suatɨp rəha nəmegəhən kəm io, kən ik onəkol io nɨkik tətagien pɨk nian ekətatɨg kilau min ik.’ In əh nəghatən itəm Tefɨt təmən e Iesu aupən. ");
INSERT INTO tnn_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Piak mɨn. Iakolkeike məmə ekən nat ətuatɨp kəm itəmat. Iaguɨhl u pipi rəhatat aupən, Kig Tefɨt, in təmɨmɨs rəkɨs, kən kəmɨtənɨm, kən rəhan suwɨt tətatɨg imətat ikɨn mətoarus-pa u-roiu. ");
INSERT INTO tnn_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Məto in ien kit rəha Uhgɨn, kən in tɨtun məmə Uhgɨn təmos noanawɨl kit kəm in mən-iəkɨs nəghatən kit kəm in məmə etəmim kit e nɨta rəhan otuarisɨg-in otəkəike muwa mol Kig. ");
INSERT INTO tnn_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Kig Tefɨt təməplan məmə nat u otəkəike muwa mol nɨpahrienən lan. In təmən məmə Kristo əh, itəm Uhgɨn təmən məmə otahl-ipa, in otol təmegəh mɨn e nɨmɨsən, kən Uhgɨn otəsapəsən narmɨn tətatɨg ima netəm kəmotɨmɨs ikɨn, kən nɨpətɨn okol təsəmnəmɨtən. ");
INSERT INTO tnn_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Kən nəghatən u tatəghat e Iesu itəm Uhgɨn təmol rəkɨs təmegəh mɨn e nɨmɨsən. !Kən itɨmat emotəplan e nɨganəmtɨtɨmat! ");
INSERT INTO tnn_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Iesu, rəhan tata təmɨləs in mər muwɨn e nɨkalɨn matɨp e ikɨn rəha nɨsiaiiən ne nəsanənən. Kən tahmen-pən əm məmə Uhgɨn təmən-iəkɨs mihin aupən, in təmos-ipən Narmɨn rəhan kəm Iesu məmə Iesu otos-ipən kəm rəhan mɨn. Kən natɨmnat mɨn u, noatəplan, moatəto, Narmɨn Rəha Uhgɨn tatol. ");
INSERT INTO tnn_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kig Tefɨt təməsuwɨnən e Nego e Neai tahmen e Iesu. Kən Tefɨt təməsəghat-in atɨpən in nian in təmən nəghatən mɨn əh məmə, ‘Iərəmərə təmən kəm rəhak Iərəmərə məmə, “Əpələh e nɨkalɨk matɨp, ikɨn rəha nɨsiaiiən ne nəsanənən, matəsahgin. ");
INSERT INTO tnn_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Oekol rəham tɨkɨmɨr mɨn məmə okotahmen e nɨmoulul itəm nategotain e nəptən, kən ik matərəmərə elat.”’ ");
INSERT INTO tnn_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Itəmat rafin noanol mɨn rəha Isrel onəkotəkəike motɨtun wɨr məmə Iesu əh itəm itəmat nəmotətu-pər e nɨg kəməluau, in əh, Uhgɨn təmol məmə in Iərəmərə ne Kristo - etəm itəm Uhgɨn təmən məmə otahl-ipa.” ");
INSERT INTO tnn_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nəghatən u rəha Pita təmek pahrien nɨkilat, kən kotətapəh o Pita ne aposol mɨn məmə, “Piatɨmat mɨn. ?Oekol tahro nulan?” ");
INSERT INTO tnn_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Kən Pita təmən-ipən kəm ilat məmə, “Onəkotəkəike kəuhlin nətəlɨgən rəhatəmat, kən kol baptais etəmat e nərgɨ Iesu Kristo, məmə Uhgɨn otafəl rəkɨs nolən rat mɨn rəhatəmat. Kən Uhgɨn otos-ipɨnə Narmɨn u kəm itəmat, ");
INSERT INTO tnn_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","məto Uhgɨn təmən-iəkɨs nəghatən u otəmat, ne nenətɨtəmat mɨn, ne namipɨtəmat mɨn itəm okəpanotuwa. Nəniəkɨsən u tətatɨg o netəm mɨn u itəm Iərəmərə Uhgɨn rəhatat tətaun-in ilat.” ");
INSERT INTO tnn_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kən Pita tatən nəghatən wɨr tepət məmə otiuw-pa ilat kotuwa, kən matən kəm ilat məmə, “Onəkotiet rəkɨs e netəm un, netəm kotərat məmə Uhgɨn otəsolən nalpɨnən kəm itəmat min ilat.” ");
INSERT INTO tnn_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Kən ilat tepət itəm kəmotəto nəghatən rəha Pita kəmotən nɨpahrienən lan, kən kəmol baptais elat. E nian əh, netəmim tepət tahmen e tri-taosan kəmotuwa moatuarisɨg-in ilat u koatahatətə e Iesu. ");
INSERT INTO tnn_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nian rafin netəm mɨn u koatən nɨpahrienən e Iesu, koatətəlɨg-in nəghatən itəm aposol mɨn koatəgətun ilat lan. E naliwəkən rəhalat kəmoatuwa kitiəh, e nagwənən ne Nagwənən Rəha Nəmtətin Rəha Iesu, ne nəfakən. Kən nian rafin nɨkilat tiəkɨs məmə okotəkəike moatol nat əh. ");
INSERT INTO tnn_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Aposol mɨn kəmotol nat pɨspɨs ne nəmtətin pɨsɨn pɨsɨn mɨn e nəsanənən rəha Uhgɨn. Kən netəmim narmɨlat təmiwɨg pɨk ron. ");
INSERT INTO tnn_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Netəm mɨn u koatahatətə e Iesu, nian rafin koatuwa kitiəh moatawte-in rəhalat nautə mɨn kəm ilat mɨn, ");
INSERT INTO tnn_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","tahmen e okəmə suah kit rəhan nat kit tɨkə, kən kit otol-salɨm-in rəhan kit nautə kən masitu lan. ");
INSERT INTO tnn_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nian rafin kotuwɨn katəfak kitiəh e Nimə Rəha Uhgɨn. Kən kəmotuwɨn e nimə pɨsɨn pɨsɨn mɨn moatoor nagwənən nɨgɨlat e nagienən ne nɨkilat pahrien, kən kəmotagwən mɨn e Nagwənən Rəha Nəmtətin Rəha Iesu. ");
INSERT INTO tnn_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Kən nian rafin koatənwiwi Uhgɨn, kən netəmim koatenwiwi ilat o rəhalat nolən. Kən nian rafin Iərəmərə Uhgɨn tatosmegəh netəmim kotuwa kitiəh ilat netəm koatahatətə e Iesu. ");
INSERT INTO tnn_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nian kit e tri kɨlok ehnaipən, nian rəha nəfakən, Pita ne Jon kəmualiwək mətian e Nimə Rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Suah kit itəm təsaliwəkən e nian təmaiir mətoarus-pa nian əh, kəmɨləs ka kahtu e nafiluə e Nimə Rəha Uhgɨn u katən məmə Nafiluə Təwɨr. Nian rafin tateasiə-in məni o netəmim itəm koatuwɨn imə. ");
INSERT INTO tnn_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nian təməplan Pita ne Jon kɨnatian məmə okia imə, in təmətapəh olau məmə okios-ipən məni kit kəm in. ");
INSERT INTO tnn_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Kən Pita ne Jon nɨganəmtɨlau təmətul lan. Kən Pita təmə, “Ətag-pa mehm itɨmlau.” ");
INSERT INTO tnn_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kən təmətag-pən məplan ilau nɨkin tatəht məmə otos məni kit olau. ");
INSERT INTO tnn_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kən Pita təmən-ipən kəm in məmə, “Rəhak məni tɨkə agɨn. Məto nat naka itəm io iatos, ekos-ipɨnə kəm ik. !E nərgɨ Iesu Kristo etəm Nasaret, iatən-ipɨnə kəm ik, ətul maliwək!” ");
INSERT INTO tnn_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kən in təmasitu lan, mɨləs nelmɨn matɨp miuw-pər məmə otətul. Kən roiu agɨn nelkɨn mil kəmuəg-ətuatɨp. ");
INSERT INTO tnn_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Kən təmətɨp mər mətul mɨnataliwək, matətəu-pən ilau mətəhaluwɨn e Nimə Rəha Uhgɨn, kən mɨnataliwək matətɨpər-ətɨpər matənwiwi Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Kən netəmim rafin kəmotəplan in tətaliwək matənwiwi Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Nian ilat kɨnotɨtun məmə suah ilouin inəh itəm tateasiə o məni nian rafin e nafiluə rəha Nimə Rəha Uhgɨn, kəmotaut pɨk, narmɨlat təmiwɨg e suah əh. ");
INSERT INTO tnn_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nian təmatəkul-pən e Pita ne Jon, netəmim narmɨlat təmiwɨg ron, kotaiu motuwa məmə okotəplan iləhal e ikɨn kit e Nimə Rəha Uhgɨn u katən məmə Fəranta rəha Kig Solomon. ");
INSERT INTO tnn_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nian Pita təməplan ilat, kən təmən-ipən kəm ilat məmə, “Noanol mɨn rəha Isrel. ?Tahro narmɨtəmat tatiwɨg pɨk o nat pɨspɨs u? ?Noatarəplan itɨməhal nɨkitəmat təht məmə itɨmlau etəm iasim mil kəiu emioal-wɨr suah u e nəsanənən əm rəhatɨmlau? !Kəp! ");
INSERT INTO tnn_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","O nat pɨspɨs u itəm nəmotəplan, Uhgɨn rəha Epraham, ne Aisak, ne Jekop, ne tɨpɨtat mɨn rafin, in təmɨləs-ipər nərgɨ rəhan iolwək lan, Iesu. Inu etəm kitiəh əm Iesu itəm nəmotɨləs motuwɨn o netəm-iasol mɨn rəha kapman məmə ilat okotohamnu, kən Pailat təmən rəkɨs məmə okɨsohamnuən okəhlman əm, məto itəmat nəmotən-ipən kəm Pailat məmə nəsotolkeikeən in. ");
INSERT INTO tnn_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Itəmat nəmotapəs Iesu itəm in iol ətuatɨp ne etəm təwɨr e nɨganəmtɨ Uhgɨn, kən nəmotətapəh o Pailat məmə otəhlman suah əh iohamnu itəm. ");
INSERT INTO tnn_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kən e nolən əh, itəmat nəmotohamnu Iesu, itəm nəmegəhən rafin tatɨsɨ-pən ron. Məto Uhgɨn təmol təmegəh mɨn e nɨmɨsən. Kən itɨmat emotəplan e nɨganəmtɨtɨmat məmə in nɨpahrienən. ");
INSERT INTO tnn_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Suah u itəm itəmat nəkotɨtun moatəplan, in təməsanən əm məto-inu itɨmat iotahatətə e Iesu ne nəsanənən rəhan. In nəsanənən rəha Iesu ne nahatətəən itəm təmos-ipa kəm itɨmat təmol-wɨr suah u, kən itəmat rafin nakoatəplan. ");
INSERT INTO tnn_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Piak mɨn. Io ekɨtun məmə nat un nəmotol e Iesu itəmat rəhatəmat netəm-iasol mɨn, itəmat rafin nəmotol məto-inu nəsotɨtun wɨrən məmə Iesu in pah. ");
INSERT INTO tnn_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Məto suatɨp u inu rəha Uhgɨn o nuhapɨkən rəhan nəghatən itəm təmən aupən. E nəghatən rəha rəhan mɨn ien mɨn, in təmən rəkɨs məmə rəhan Kristo itəm təmən rəkɨs aupən məmə otahl-ipa, in otəkəike məto nahməən e nɨpətɨn. ");
INSERT INTO tnn_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Itəla, roiu əh, onəkotəkəike motəuhlin itəmat e rəhatəmat nolən rat mɨn kən motɨtəlɨg-pən o Uhgɨn məmə in otafəl rəhatəmat nolən rat mɨn, kən məmə Iərəmərə Uhgɨn otos-ipɨnə namegən ne nəsanənən wi e nəmegəhən rəhatəmat, ");
INSERT INTO tnn_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","kən məmə in otahl-ipa Kristo tɨtəlɨg-pa mɨn, etəm itəm Uhgɨn təmən rəkɨs aupən. Iatəghat-in Kristo u Iesu. ");
INSERT INTO tnn_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Məto Iesu otətatɨg pitən e Nego e Neai mətoarus Uhgɨn otol-wɨr mɨn natɨmnat rafin tahmen-pən e itəm Uhgɨn təmən-iəkɨs kəm itəmat, itəm rəhan ien mɨn aupən agɨn kəmotən-iarəp. ");
INSERT INTO tnn_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Kən Moses təmən-iarəp məmə, ‘Iərəmərə Uhgɨn otɨləs-ipər ien kit mɨn etəmat tahmen lak. Onəkotəkəike motətəlɨg-in natɨmnat rafin itəm otən kəm itəmat motol nəwian. ");
INSERT INTO tnn_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Netəm mɨn u itəm okotəht nəwia ien əh, Uhgɨn otɨləs-irəkɨs ilat o rəhan mɨn netəmim kən ilat okotɨmɨs.’ ");
INSERT INTO tnn_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Inu nɨpahrienən. Ien mɨn rafin kəmotən əm nəghatən kitiəh, təmətuoun e ien u Samuel, muwa mətoarus-pa u-roiu. ");
INSERT INTO tnn_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","“Nəniəkɨsən mɨn u itəm Uhgɨn təmən-ipən kəm rəhan ien mɨn aupən, in rəhatəmat. Kən nəniəkɨsən rəha nasituən itəm Uhgɨn təmən kəm tɨpɨtəmat mɨn aupən, in rəhatəmat mɨn, məto-inu Uhgɨn təmən-ipən kəm Epraham məmə, ‘Ekol təwɨr kəm netəmim rafin e nətueintən, kən nat kit itəm mipɨm Iosmegəh otol, otos-ipən nəwɨrən əh kəm netəmim rafin.’ ");
INSERT INTO tnn_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nian Uhgɨn təmɨləs-ipər rəhan iolwək u Iesu Iosmegəh, təmaupən mahl-ipɨnə kəm itəmat məmə in otəuhlin itəmat e rəhatəmat nolən rat mɨn, kən e nolən əh, in otol təwɨr kəm itəmat.” ");
INSERT INTO tnn_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Nian Pita ne Jon kəmatuəghat əh kəm netəmim, kən pris mɨn, ne etəm tərəmərə e mopael mɨn itəm koatehm Nimə Rəha Uhgɨn, ne Satusi mɨn, kəmotiet-arəpa. ");
INSERT INTO tnn_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nɨkilat təmahmə pɨk məto-inu ilau katuəgətun netəmim məmə Iesu təmɨmɨs kən məmegəh mɨn. Kən inu tatəgətun məmə netəm u kəmotɨmɨs, Uhgɨn otosmegəh mɨn ilat. ");
INSERT INTO tnn_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kən kəmotaskəlɨm ilau, kɨləs-ipən ilau e kalapus məto-inu tɨnapinəp rəkɨs, kən okuəməhl əm mətoarus olauwɨg. ");
INSERT INTO tnn_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Məto netəmim tepət itəm kəmotəto nəghatən itəm kəmuən kəmotən nɨpahrienən lan. Kən netəmim rafin itəm kəmotən nɨpahrienən e Iesu, ilat iuəhkɨr tahmen e faif-taosan. ");
INSERT INTO tnn_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kəmən lawɨgin, pris asol, ne netəm-iasol rəha noanol mɨn rəha Isrel, ne iəgətun mɨn rəha Lou rəha Moses, kəmotargəfɨmɨn ilat mɨn əpəh Jerusalem. ");
INSERT INTO tnn_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kəmotəpələh ilat Anas u pris asol agɨn, ne Kaeafas, ne Jon, ne Aleksanta, ne netəmim neen e noanol rəha suah u pris asol agɨn, kəmotəpələh e kaonsel. ");
INSERT INTO tnn_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Kəmotən Pita ne Jon kian muətul aupən elat, kən kotətapəh olau məmə, “?Nəmios hiə nəsanənən u mioal nat u, o nəmioal e nərgɨ pah?” ");
INSERT INTO tnn_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Kən Narmɨn Rəha Uhgɨn təmərioah e nɨki Pita, kən Pita təmən-ipən kəm ilat məmə, “Itəmat u itəm noatərəmərə e noanol mɨn rəha Isrel, ne netəm-iasol mɨn. ");
INSERT INTO tnn_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Itəmat noategəs-in-pa otɨmlau məmə suah u itəm nelkɨn təmərat təmos hiə nəwɨrən, o emuahrol nulan mioal-wɨr nelkɨn. ");
INSERT INTO tnn_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Itəmat rafin ikɨn-u ne noanol mɨn rafin rəha Isrel, onəkotəkəike motɨtun məmə suah u itəm nelkɨn tɨnəwɨr rəkɨs tatətul aupən-in itəmat e nəsanənən əm e nərgɨ Iesu Kristo, etəm Nasaret. Suah əh inəh, itəmat nəmotətu-pər e nɨg kəməluau, in təmɨmɨs. Məto Uhgɨn təmol təmegəh mɨn. ");
INSERT INTO tnn_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Suah əh inəh, itəm Naoa Rəha Uhgɨn təmən lan məmə, ‘Kəpiel u itəm itəmat netəm rəha niləkɨnən nimə, nakotəmə tərat motərakin, məto roiu in tɨnuwa kəpiel keike itəm nimə tatətul-pər lan.’ ");
INSERT INTO tnn_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nərɨg kit tɨkə e nətueintən itəm Uhgɨn təmos-ipa məmə tɨtun nosmegəhən netəmim, məto Iesu pɨsɨn əm tɨtun nosmegəhən netəmim.” ");
INSERT INTO tnn_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Netəm-iasol rəha kaonsel kəmotaut pɨk nian kəmotəplan məmə kəsuəginən ilat, nat əpnapɨn kəsioalən skul, ilau etəmim əm. Kəmotɨtun ətuatɨp məmə suah mil əh ilat pahrien Iesu kəmotaliwək moatan. ");
INSERT INTO tnn_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kən kɨnotəruru nuhalpɨnən nəghatən rəhalau məto-inu suah u nelkɨn tɨnəwɨr rəkɨs tatətul iləhal min ilau. ");
INSERT INTO tnn_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kən kəmotən-ipən kəm iləhal məmə okəhaliet məhaluwɨn ihluə pəs ilat əm kotəghat pitən. ");
INSERT INTO tnn_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Kən kəmoatətapəh-ətapəh olat mɨn məmə, “?Okotahro suah mil əh? Netəmim rafin u Jerusalem kɨnotɨtun rəkɨs məmə nat pɨspɨs u kəmol e suah u, in iahgin pɨk, okol kəsotən-iamninən. ");
INSERT INTO tnn_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Məto pəs kotən-iəhau əskasɨk ilau məmə okəsuən-iarəp mɨnən nərgɨ Iesu kəm netəmim, kən nəghatən e nat pɨspɨs əh otəsiet mɨnən netəmim kotəto.” ");
INSERT INTO tnn_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kən kəmotaun-in iləhal kəhaluwa mɨn imə, kən kəmotən-ipən kəm Pita ne Jon məmə okəsuən-iarəp mɨnən nərgɨ Iesu, kən məsuəgətun mɨnən netəmim lan. ");
INSERT INTO tnn_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Məto ilau kəmuən-ipən kəm ilat məmə, “Itəmat əm otakil məmə tətuatɨp e nɨganəmtɨ Uhgɨn məmə ekioal nəwiatəmat o nəwia Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Məto itɨmlau okol esuakɨmən nohlɨtɨmlau. Oekuəike muən-iarəp natɨmnat itəm emuəplan e nɨganəmtɨtɨmlau kən muəto e matəlgɨtɨmlau.” ");
INSERT INTO tnn_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kən kaonsel təmən-ipən mɨn kəm Pita ne Jon məmə ilat okotol nalpɨnən kit kəm ilau okəmə ilau okatuəkəike matuən-iarəp Iesu kəm netəmim, kən motahl-iarəp ilau. Kəmotahl-iarəp ilau məto-inu kɨnotəruru məmə okotahruəh ilau. Kəmotɨtun məmə netəmim nɨkilat otahmə okəmə ilat okotol nalpɨnən kəm ilau, məto-inu netəmim rafin koatənwiwi Uhgɨn o nat pɨspɨs itəm Uhgɨn təmol e etəm nelkɨn təməfaiu ");
INSERT INTO tnn_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","nian təmaiir mətoarus-pa əh-roiu. Rəhan nup taprəkɨs-in foti. ");
INSERT INTO tnn_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nian netəm-iasol rəha kaonsel kəmotegəhan-in ilau məmə ilau okatian, kəmiaiet uəhai əm mian əpəh netəm koatahatətə e Iesu koatatɨg ikɨn, kən muən-iarəp rafin nəghatən itəm pris asol mɨn ne netəm-iasol rəha kaonsel kəmotən-ipən kəm ilau. ");
INSERT INTO tnn_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nian kəmotəto nəghatən əh, ilat rafin kəmotuwa kitiəh motəfak-pən kəm Uhgɨn motən məmə, “Iərəmərə Uhgɨn, ik nəmol neai, ne nɨməptən, ne nɨtəhəi, ne natɨmnat rafin elat. ");
INSERT INTO tnn_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ik nəməghat e nəsanənən e Narmɨn rəham kəm tɨpɨtɨmat u aupən Kig Tefɨt, u in rəham iolwək, kən in təmən-iarəp rəham nəghatən məmə, ‘?Tahro netəm e nəptən pɨsɨn pɨsɨn mɨn nɨkilat tɨtahmə pɨk nəhlan? Tahro ilat koatəte noa məmə okotol nəratən mɨn əh, u itəm okol koatol pap, təsuwɨnən miet, otɨkə-pən əm olat. ");
INSERT INTO tnn_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Netəm koatərəmərə e nɨtən mɨn, koatol əpen-əpenə okotəmou, kən netəm-iasol mɨn rəha nətueintən koatuwa kitiəh ilat min ilat, məmə okotəmou ilat Iərəmərə Uhgɨn ne Iosmegəh itəm in təmən’ ");
INSERT INTO tnn_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Iərəmərə Uhgɨn, in nɨpahrienən nəghatən itəm Kig Tefɨt təmən tɨnuwa mɨnet-arəp, məto-inu Kig Herot Antipas, ne Pontias Pailat, ne noanol mɨn rəha Isrel, ne Iaihluə mɨn, ilat rafin kəmotuwa kitiəh ikɨn-u latuənu Jerusalem, moatol noa eko-eko məmə okotohamnu Iesu, itəm in rəham iol ətuatɨp itəm nəmɨtəpun. ");
INSERT INTO tnn_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Kəmoatəte noa rəhalat tatətəu-pən əsas əm rəham nəghatən itəm ik nɨnəmən rəkɨs e nəsanənən ne nenatɨgən rəham aupən. ");
INSERT INTO tnn_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Tol nəhlan, Iərəmərə, nɨkim tatəht nəghatən itəm ilat kəmoatən məmə okotoh itɨmat, ol itɨmat rəham iolwək mɨn məmə esotəgɨnən məmə ekotən-iarəp rəham nəghatən. ");
INSERT INTO tnn_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Əgəfəməhin-pa nelməm məmə otol-wɨr netəm koatɨmɨs, kən mol nat pɨspɨs mɨn ne nəmtətin pɨsɨn pɨsɨn mɨn e nərgɨ Iesu, rəham iol ətuatɨp.” ");
INSERT INTO tnn_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nian kəmotəfak rəkɨs, kən nat kit təməloal e nimə, kən Narmɨn Rəha Uhgɨn təmuwa mərioah mətatɨg elat, kən kɨnoatən-iarəp nəghatən rəha Uhgɨn məsotəgɨnən. ");
INSERT INTO tnn_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Netəm koatən nɨpahrienən e Iesu rəhalat nətəlɨgən təmuwa kitiəh. Kit təməsaumɨsən məhluaig-in rəhan nautə məto kəmoatoor nautə rəhalat kəm ilat mɨn. ");
INSERT INTO tnn_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kən aposol mɨn kəmotos nəsanənən e Narmɨn Rəha Uhgɨn kən moatən-iarəp məmə Iərəmərə Iesu təmegəh mɨn e nɨmɨsən. Kən e nəwɨrən rəha Uhgɨn, in tətasitu elat rafin itəm koatəfak. ");
INSERT INTO tnn_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kən ilat kit, rəhan kit nat kit təməsɨkəən, məto-inu netəmim neen kəmotosalɨm-in rəhalat nəptən o nimə, kən motos-ipən məni lan kəm aposol mɨn, ");
INSERT INTO tnn_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","kən ilat kəmoatoor kəm itəm mɨn u rəhalat nat kit tɨkə. ");
INSERT INTO tnn_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tol nəhlan, suah kit əh-ikɨn nərgɨn u Josep, noanol kit rəha Lifae, etəm Saepras, aposol mɨn kəmotos-ipən nərɨg wi kit kəm in, nərgɨn u Panapas, u nɨpətɨn təmə, “etəm tətasitu matɨləs-ipər nətəlɨgən.” ");
INSERT INTO tnn_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","In təmosalɨm-in rəhan kit nəptən, kən məmɨk məni lan muwa məmki-pən kəm aposol mɨn məmə ilat okotoor kəm ilat mɨn. ");
INSERT INTO tnn_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Məto suah kit mɨn əh-ikɨn, nərgɨn u Ananaeas, ne rəhan pətan nərgɨn u Safaera. Ilau mɨn kəmioal-salɨm-in rəhalau kit nɨməptən. ");
INSERT INTO tnn_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","In təmaskəlɨm anion məni məsɨn, kən rəhan pətan əm tɨtun. Kən məmɨk əm məsɨn muwɨn məmki-pən kəm aposol mɨn məmə məni e nəptən rafin. ");
INSERT INTO tnn_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Məto Pita təmən-ipən kəm in məmə, “Ananaeas. ?Tahro nategəhan-in iərmɨs u Setan tatuwa e nɨkim? Nakateiuə-in Narmɨn Rəha Uhgɨn kən mətaskəlɨm anion məni məsɨn rəha nɨməptən məmə rəham. ");
INSERT INTO tnn_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","?Aupən nɨməsosalɨm-inən nɨməptən u, in rəham o kəp? ?Kən nian nəmosalɨm-in, rəham məni lan o kəp? ?Tahro natol nuhlan? !Ik nɨseiuə-inən etəmim, məto nateiuə-in Uhgɨn!” ");
INSERT INTO tnn_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nian Ananaeas təməto nəghatən əh, əmun mɨsɨ-pər morin rəhan namegən tiet. Kən netəmim itəm kəmotəto nat əh, kəmotəgɨn motasiəp. ");
INSERT INTO tnn_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Kən netəm aluə mɨn kəmotuwa motalpin nɨpətɨn motɨləs motiet motuwɨn kɨtənɨm. ");
INSERT INTO tnn_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Iuəhkɨr aua kɨsɨl təmuwa muwɨn rəkɨs, kən rəhan pətan Safaera təmiet-arəpa məruru məmə rəhan iərman tɨnɨmɨs rəkɨs. ");
INSERT INTO tnn_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Kən Pita təmətapəh ron məmə, “?Ən-tu kəm io məmə məni e nəptən rafin əh rəhatəlau itəm nəmiosalɨm-in?” Kən in tən məmə, “Əwəh. Məni rafin un.” ");
INSERT INTO tnn_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kən Pita təmən-ipən kəm in məmə, “?Tahro nəmatioal anion noa kit məmə nakueiuə-in Narmɨn Rəha Iərəmərə məmə okol təsɨtunən nat u nəmioal? !Əto-tu! Netəm kəmotɨtənɨm rəham iərman, ilat u e nafiluə koatuwa məmə okotɨləs mɨn ik.” ");
INSERT INTO tnn_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Kən roiu agɨn tɨsɨ-pər morin-pən əpəh nelkɨ Pita ikɨn, mɨmɨs namegən tiet. Nian netəm aluə mɨn kəmotuwa imə, motəplan tɨnɨmɨs rəkɨs, kən kotɨləs motiet motuwɨn kɨtənɨm e nɨkalɨ rəhan iərman. ");
INSERT INTO tnn_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nian netəmim rəha niməfak ne netəm əpnapɨn kəmotəto nat əh, kəmotəgɨn kəmotəgɨn. ");
INSERT INTO tnn_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Kən aposol mɨn kəmotol nəmtətin tepət ne nat pɨspɨs mɨn e nɨganəmtɨ netəmim. Kən netəmim mɨn u itəm koatən nɨpahrienən e Iesu kəmoatuwa kitiəh əm e Feranta rəha Kig Solomon e Nimə Rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Netəmim kəmoatɨsiai-in ilat, məto netəm mɨn u kəsotənən nɨpahrienən e Iesu kəmotəgin nuwɨnən ikɨn əh mehm ilat. ");
INSERT INTO tnn_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Məto nian rafin netəmim tepət koatuwa moatən nɨpahrienən e Iesu, nəman ne nɨpɨtan, kən ilat tatepət. ");
INSERT INTO tnn_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Məto-inu e nat pɨspɨs mɨn itəm aposol mɨn kəmoatol, netəmim koatos rəhalat nɨmɨsən mɨn moatuwa, kən moatəlɨn ilat kotapɨl e rəhalat pet ne nɨmɨtiwɨn e suatɨp məmə nian Pita otaliwək mapikalɨn ilat, in otek neen o kəm-naka nəghanpɨs in əm tos neen kən məmə ilat okotəmegəh. ");
INSERT INTO tnn_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Kən netəmim tepət tepət kəmotɨsɨ-pən e latuənu mɨn iuəhkɨr o Jerusalem kəmotuwa. Kəmotəmɨk rəhalat netəm koatɨmɨs ne netəm itəm narmɨn rat tətatɨg elat motuwa, kən aposol mɨn kəmotəfak elat kən ilat rafin kotəwɨr. ");
INSERT INTO tnn_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kən suah u pris asol agɨn ne rəhan mɨn netəmim Satusi mɨn u, ilat e pati kitiəh, kəmotol pɨk tɨməht elat məto-inu netəmim tepət kɨnoatapəs ilat mɨnoatuwɨn o aposol mɨn. ");
INSERT INTO tnn_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Kən kəmotaut kaskəlɨm aposol mɨn kəmki-pən ilat e kalapus. ");
INSERT INTO tnn_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Məto lapɨn-in, nagelo kit rəha Iərəmərə təmuwa merəh e nafiluə e kalapus mit ilat motiet. ");
INSERT INTO tnn_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Kən mən-ipən kəm ilat məmə, “Otuwɨn e Nimə Rəha Uhgɨn motən-iarəp nəghatən pahrien rəha nəmegəhən wi u kəm netəmim.” ");
INSERT INTO tnn_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Kən kəmən lawɨgin, kəmotol nəwia nagelo kən mɨnotuwɨn əpəh e Nimə Rəha Uhgɨn moatən-iarəp nərgɨ Iesu kəm netəmim. Kən pris asol agɨn ne rəhan mɨn, kəmotaun-in netəm-iasol mɨn rəha noanol mɨn rəha Isrel, kən ilat kəmotuwa kitiəh məmə ilat okotəpələh e kaonsel asol rəha noanol mɨn rəha Isrel. Kən motahl-ipən nəghatən kəm netəm kotərəmərə e kalapus məmə okotahl-ipa aposol mɨn kotuwa e kot əpəh e kaonsel. ");
INSERT INTO tnn_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Məto nian mopael mɨn kəmotuwɨn e kalapus, məto aposol mɨn kotɨkə. Kən kotɨtəlɨg-pa e kaonsel motən məmə, ");
INSERT INTO tnn_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Nian emotuwɨn ket-arəpən e kalapus, motəplan toa tətahtosɨg, lok tatəkul-pən wɨr əm lan, kən mopael mɨn rəha kalapus koatətul katehm wɨr əm nafiluə e kalapus, məto nian emoterəh motuwɨn imə, məto kɨkə-kɨkə əh imə.” ");
INSERT INTO tnn_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nian etəm tatərəmərə e mopael mɨn itəm koatehm Nimə Rəha Uhgɨn, ne pris asol mɨn kəmotəto nəghatən əh, kəmotaut pɨk, rəhalat-kapə təmɨkə, mɨnotəruru əpnapɨn əm məmə nat naka otuwa mɨn. ");
INSERT INTO tnn_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kən əmun etəmim kit tiet-arəpa məmə, “!Ei, nəman! !Netəm mɨn ilouin itəm nəmotəmki-pən ilat e kalapus, ilat əpəh e Nimə Rəha Uhgɨn koatəgətun netəmim!” ");
INSERT INTO tnn_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kən etəm tərəmərə e mopael mɨn təmit mopael mɨn rəhan motuwɨn motəmɨk aposol mɨn motuwa. Məto kəməsotewkəkanən ilat məto-inu koatəgɨn məmə netəm əpnapɨn okotaht ilat e kəpiel apɨn okəmə okotewkəkan ilat. ");
INSERT INTO tnn_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nian kəmotit ilat motuwa imə, kən motən məmə ilat okotətul aupən-in netəm-iasol rəha kaonsel. Kən pris asol agɨn təmən-ipən kəm ilat məmə, ");
INSERT INTO tnn_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Emotən-iəhau əskasɨk agɨn itəmat məmə onəsətəgətunən netəmim e nərgɨ suah əh Iesu. Məto nəgətunən rəhatəmat tɨnaiu rafin əpəh Jerusalem. Kən moatol məmə netəmim okotən məmə itɨmat emotoh suah əh.” ");
INSERT INTO tnn_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Məto Pita təməghat rəhalat aposol mɨn lan məmə, “Itɨmat ekotəkəike motol nəwia Uhgɨn, sənəmə nəwia netəmim əm. ");
INSERT INTO tnn_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Itəmat nəmotohamnu rəkɨs Iesu motətu-pər e nɨg kəməluau, məto Uhgɨn u rəha tɨpɨtat mɨn aupən təmol təmegəh mɨn e nɨmɨsən. ");
INSERT INTO tnn_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Uhgɨn u inu təmɨləs-ipər rəkɨs Iesu məmə otuwɨn matəpələh e nɨkalɨn matɨp, ikɨn rəha nɨsiaiiən ne nəsanənən, məmə in Iərəmərə ne Iosmegəh. Uhgɨn təmol nat əh məmə in otol suatɨp məmə noanol mɨn rəha Isrel kotɨtun nəuhlinən ilat e rəhalat nolən rat mɨn, kən in otafəl rəkɨs nolən rat mɨn rəhalat. ");
INSERT INTO tnn_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kən itɨmat Narmɨn Rəha Uhgɨn ekoatən-iarəp natɨmnat mɨn u, kən Uhgɨn tatos-ipən Narmɨn rəhan kəm netəmim itəm koatol nəwian.” ");
INSERT INTO tnn_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nian netəmim rəha kaonsel kəmotəto nəghatən əh, təmew pɨk rəhalat neməha, kən kotolkeike məmə okotohamnu əm ilat. ");
INSERT INTO tnn_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Məto suah kit təmətul, nərgɨn u Kamaliel, in Farisi kit ne iəgətun kit rəha Lou, u itəm netəmim rafin koatɨsiaiiən. Kən təmətapəh o mopael mɨn məmə okotit aposol mɨn motuwɨn ihluə pitən. ");
INSERT INTO tnn_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kən in təmən-ipən kəm ilat məmə, “Natimak mɨn, netəm Isrel. Otakil wɨr noa rehatəmat məmə onəkotahro netəm mɨn u. ");
INSERT INTO tnn_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Wi agɨn huə suah kit nərgɨn u Teutas, təmiet-arəp matən məmə in etəm-iasol kit, kən iuəhkɨr netəmim fo-hanrɨt kəmotuarisɨg-in. Məto kəmohamnu in, kən rəhan netəmim kəmotan kitiəh kitiəh, kən rəhan nətəlɨgən təmuwɨn mɨkə. ");
INSERT INTO tnn_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Uarisɨg lan, nian kapman təmətafin netəmim, suah kit mɨn nərgɨn u Jutas, etəm Kalili, in mɨn təmiw netəmim koatuarisɨg-in. Məto netəmim neen kəmotohamnu mɨn, kən rəhan netəmim kəmotan kitiəh kitiəh. ");
INSERT INTO tnn_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kən inu rəhak nətəlɨgən e nənən u. !Ekən kəm itəmat, pəs kotapəs əm ilat motegəhan-in ilat kotiet! Məto okəmə nat koatol in rəha etəmim əm, otəpanɨsas. ");
INSERT INTO tnn_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Məto okəmə tatɨsɨ-pən o Uhgɨn, okol kəsotosən nəsanənən məmə okotən-iəhau ilat. Okotəplan əm məmə kitat Uhgɨn koatəmou.” Kən ilat rafin kəmotegəhan-in rəhan nəghatən. ");
INSERT INTO tnn_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Kən kəmotaun-in aposol mɨn məmə okotuwa imə, kən motən məmə mopael mɨn okotalis ilat. Kən motən-iəhau əskasɨk mɨn ilat məmə okəsotəghat mɨnən kəm netəmim e nərgɨ Iesu kən motəhlman ilat kotiet. ");
INSERT INTO tnn_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nian aposol mɨn kəmotiet e kaonsel, nɨkilat tətagien, məto-inu Uhgɨn təmɨsiai-in ilat kən megəhan-in məmə netəmim okotoh ilat məto-inu koatuarisɨg-in Iesu. ");
INSERT INTO tnn_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kən nian rafin e Nimə Rəha Uhgɨn ne nimə mɨn, ilat kəməsotapəsən kəmoatəkəike katən-iarəp kən moatəgətun nəghatən wɨr məmə Iesu in Kristo itəm Uhgɨn təmən məmə otahl-ipa. ");
INSERT INTO tnn_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nian neen tɨnuwa mɨnuwɨn rəkɨs, kən netəm rəha Iesu tɨnatər mɨnatepət. Neen rəhalat kəmotɨsɨ-pən ikɨn pɨsɨn pɨsɨn mɨn, kən koatən əm nəghatən Kris. Kən tepət, ilat netəm Isrel əm. Məto iəfak mɨn itəm koatən əm nəghatən Kris kɨnoatən nɨkalɨ iəfak mɨn u netəm Isrel, moatən məmə nian koatoor məni ne nagwənən kəm nəutahlɨmɨs mɨn, məto kəsotehm wɨrən nəutahlɨmɨs mɨn rəha itəm mɨn u koatən nəghatən Kris. ");
INSERT INTO tnn_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kən tuwelef aposol mɨn kəmotaun-in netəm rəha Iesu məmə okotuwa-tu. Kən kəmotən-ipən kəm ilat məmə, “Piak mɨn. Təsəwɨrən məmə itɨmat ekotapəs nən-iarəpən ne nəgətunən nəghatən rəha Uhgɨn məmə itɨmat ekotɨmnə katoor məni ne nagwənən kəm nəutahlɨmɨs mɨn. ");
INSERT INTO tnn_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Məto roiu, otətgi-arəp-tu etəmat mɨn, netəmim sepɨn u itəm noatɨsiai-in ilat, kən kotenatɨg, ne Narmɨn Rəha Uhgɨn tərioah e nəmegəhən rəhalat. Kən itɨmat ekotos-ipən nat u kəm ilat məmə ilat okoatol. ");
INSERT INTO tnn_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Mapəs itɨmat e nəfakən kəm Uhgɨn ne nən-iarəpən ne nəgətunən nəghatən rəha Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Kən ilat rafin nɨkilat təmagiən, kən motegəhan e nəghatən əh. Kən kəmotətɨg-iarəp Stipen u rəhan nahatətəən təskasɨk e Uhgɨn ne Narmɨn Rəha Uhgɨn tərioah mətatɨg lan, kəmotətɨg-iarəp mɨn Filip, ne Prokoras, ne Nikano, ne Timon, ne Pamenas, ne Nikolas etəm Antiok u aupən təmapəs nəfakən rəha netəm iman ikɨn mɨnuwa matətəu-pən nəfakən rəha netəm Isrel. ");
INSERT INTO tnn_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Kəmotit ilat motuwɨn kəm aposol mɨn, kən aposol mɨn kəmotələhəu-pən nelmɨlat elat motəfak elat. ");
INSERT INTO tnn_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Kən netəm rəha Iesu koatən-iarəp nəghatən rəha Uhgɨn kəm netəmim, kən netəm rəha Iesu u Jerusalem tɨnatepət-natepət. E netəm əh, pris mɨn tepət kəmotahatətə e Iesu. ");
INSERT INTO tnn_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Kən Stipen u etəm tərioah e nəwɨrən ne nəsanənən rəha Uhgɨn, təmol nəmtətin tepət ne nat pɨspɨs mɨn e nɨganəmtɨ netəmim. ");
INSERT INTO tnn_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Məto netəmim neen e nimə rəha nuəfɨmɨnən rəha Netəm Kəmɨkɨs Ilat, kəmotəghat ilat Stipen. Netəm mɨn u noanol mɨn rəha Isrel u kəmotɨsɨ-pən Saerin ne Aleksantria. Kən netəmim neen mɨn u noanol mɨn rəha Isrel u kəmotɨsɨ-pən Silisia ne Esia, ilat kəmotuwa kitiəh, kən mɨnoatərgəhəu ilat Stipen. Kotəmə nəghatən rəha Stipen təsətuatɨpən, meto rəhalat tətuatɨp. ");
INSERT INTO tnn_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Məto Narmɨn Rəha Uhgɨn təmol Stipen tenatɨg-pɨk, kən nian in otəghat, rəhan nəghatən tatoh-iəhau rəhalat. ");
INSERT INTO tnn_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kən ilat kəmotətou anion netəmim neen məmə okotasitu elat motən-iarəp məmə, “Itɨmat emotəto məmə Stipen təmən rat Moses ne Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kən rəhalat nəghatən təmol nɨki netəmim, ne netəm-iasol rəha Isrel ne iəgətun mɨn rəha Lou, kəmotetəhau Stipen. Kən kəmotuwɨn kaskəlɨm motɨləs motuwɨn məmə otətul e nɨganəmtɨ kaonsel. ");
INSERT INTO tnn_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Kən kəmotəmɨk netəmim neen motuwa məmə okoteiuə e Stipen. Kən netəm mɨn un kotən məmə, “Nian rafin tatən nəghatən rat e Nimə Rəha Uhgɨn, kən matən rat Lou rəha Moses. ");
INSERT INTO tnn_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Itɨmat emotəto in təmən məmə Iesu u etəm Nasaret, in otɨləs-iəhau Nimə Rəha Uhgɨn, kən məuhlin nolən mɨn itəm Moses təmos-ipa kəm kitat aupən ikɨn.” ");
INSERT INTO tnn_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Kən netəmim rafin itəm kəmoatəpələh e kaonsel kəmotətag-pən ətuatɨp o Stipen, kən kəmotəplan məmə nɨganəmtɨn tɨnəhag-əhag tahmen e rəha nagelo. ");
INSERT INTO tnn_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kən pris asol agɨn təmətapəh o Stipen məmə, “?Tahro, nəghatən mɨn əh nɨpahrienən?” ");
INSERT INTO tnn_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Kən Stipen təmən məmə, “Piak mɨn ne tata mɨn. Otətəlɨg-in-tu io. Uhgɨn u itəm in ilɨs ilɨs pɨk, təmiet-arəpa o tɨpɨtat Epraham nian in təmətatɨg əpəh Mesopotemia, məsuwɨnən əh əpəh Haran. ");
INSERT INTO tnn_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Uhgɨn təmən-ipən kəm in məmə, ‘Apəs rəham mɨn, ne ikɨn nətatɨg ikɨn, muwɨn e ikɨn kit itəm io epanəgətun kəm ik.’ ");
INSERT INTO tnn_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Kən Epraham təmiet əh Kaltia muwɨn mətatɨg əpəh Haran. Təmətatɨg ikɨn-u kən rəhan tata təmɨmɨs, kən Uhgɨn təmɨləs muwa e nəptən u itəmat noatatɨg lan əh-roiu. ");
INSERT INTO tnn_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Məto təmɨsos-ipənən nəptən məsɨn huə tahmen e nuwigɨ iar ne kəm in məmə in rəhan ətuatɨp. Məto Uhgɨn təmən-iəkɨs kəm in məmə otəpanos-ipən rafin nɨtən əh kəm in ne namipɨn rat mɨn. Kən in otuwa iməlat agɨn ikɨn, nat əpnapɨn e nian əh Epraham təmɨsɨləsən əh nətɨn kit. ");
INSERT INTO tnn_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nəghatən itəm Uhgɨn təmən kəm in tol nulan, in təmən məmə, ‘O nian kit, noanol mɨn rəham okotuwɨn katɨg e nəptən pɨsɨn kit. Okol iapɨspɨs elat kotol wək kəm netəmim e nəptən pɨsɨn, okol nahməən kəm ilat kətoarus nup fo-hanrɨt. ");
INSERT INTO tnn_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Məto ekol nalpɨnən kəm netəmim itəm koatərəmərə elat. Kən uarisɨg, noanol mɨn rəham okotiet e nɨtən mɨn əh motuwa kəfak kəm io e nɨtən u.’ ");
INSERT INTO tnn_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kən Uhgɨn təmən-iəkɨs məmə in otehm wɨr Epraham ne noanol mɨn rəhan. Kən mən-ipən kəm in məmə in otəhg-ipən nɨsualkələh nəman məmə in nəmtətin kit məmə ilat netəmim rəha Uhgɨn. Kən nian Epraham təmɨləs Aisak, kən məhg-ipən nian təmos nian eit. Kən nian Aisak təmɨləs Jekop, kən matɨg məhg-ipən mɨn. Kən nian Jekop təməmɨk nenətɨn ilat tuwelef, kən təməhg-ipən mɨn ilat. Ilat tuwelef əh, nəukətɨ nɨta rəhatat.” ");
INSERT INTO tnn_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Kən Stipən təmən-ipən mɨn kəm ilat məmə, “Məto-inu netəm mɨn əh, nəukətɨ nɨta mɨn u rəhatat, kəmotetəhak e Josep, kəmotosalɨm-in-pən kəm netəm Ijip, məmə otuwa slef rəhalat, məto ilau Uhgɨn e nian rafin, ");
INSERT INTO tnn_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","kən Uhgɨn tɨləs-irəkɨs in e nəratən. Nian təmətul e nɨganəmtɨ kig rəha netəm Ijip, kən Uhgɨn təmos-ipən nenatɨgən kəm in kən matɨg mol mɨn məmə kig otolkeike in, kən mol in tatərəmərə e nɨtən Ijip ne netəmim ne natɨmnat rafin rəhan. ");
INSERT INTO tnn_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Kən əmun nəumɨs təman e nɨtən əpəh Ijip ne Kenan mol nagwənən tɨkə, kən nəumɨs natus asol netəmim, kən tɨpɨtat mɨn nɨgɨlat nagwənən təmɨkə. ");
INSERT INTO tnn_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nian Jekop tɨnəto məmə nagwənən əpəh Ijip, təmahl-ipən tɨpɨtat mɨn əh kotuwɨn, kən inu nətuounən ilat kəmotuwɨn Ijip. ");
INSERT INTO tnn_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kən uarisɨg ilat kəmotuwɨn mɨn, kən təmən-iarəp in kəm ilat, məto-inu ilat kəsotɨtunən məmə in Josep pialat. Kən kig rəha Ijip təməto namnusən rəha Josep ne pian mɨn. ");
INSERT INTO tnn_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Kən Josep təmahl-ipən nəghatən kəm rəhan tata Jekop ne rəhan mɨn məmə okotuwa motatɨg ilat min. E netəm əh, ilat rafin sepɨnte faif. ");
INSERT INTO tnn_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Kən Jekop ne rəhan mɨn kəmotuwɨn kətatɨg Ijip, kən nian kəmotatɨg kətatɨg kɨmɨs ikɨn. ");
INSERT INTO tnn_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Kən kəməmɨk ilat kan əpəh Sekem kɨtənɨm ilat ikɨn e nɨpəg kəpiel kit itəm Epraham tɨnos-nəmtɨn rəkɨs o noanol mɨn rəha Hamor.” ");
INSERT INTO tnn_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Kən Stipen təmatəkəike matən-ipən kəm ilat məmə, “Tɨnatuwa iuəhkɨr məmə Uhgɨn otosmegəh rəhan netəmim itəm təmən-iəkɨs kəm Epraham, kən noanol mɨn rəhatat itəm kəmotatɨg Ijip aupən, roiu əh tɨnepət-nepət. ");
INSERT INTO tnn_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kən kig kit mɨn rəha Ijip təmətul, in təruru agɨn Josep. ");
INSERT INTO tnn_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","In təmos-iəhau tɨpɨtat mɨn e neiuəən, matol nahməən kəm ilat. Kən in təmol lou kit məmə okotəmki-arəp nenətɨlat mɨn ihluə məmə okotɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Kən e nian əh, Moses təmaiir, kən in suakəku wɨr kit e nɨganəmtɨ Uhgɨn. Rəhan mama ne tata kəmuəhluaig-in anion əpəh imə mios məwɨg kɨsɨl. ");
INSERT INTO tnn_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nian kəmɨləs-iarəp ihluə, nətɨ kig pətan təməplan, kən tɨləs məmə otehm wɨr rəhan. ");
INSERT INTO tnn_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Kəmotəgətun in e nenatɨgən rafin rəha netəm Ijip, kən nian in təmepət, in təsanən e nəghatən ne nolən nat. ");
INSERT INTO tnn_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Nian tɨnos nup foti, nɨkin təht məmə otuwɨn-tu muag natiman mɨn, netəm Isrel, ");
INSERT INTO tnn_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","kən məplan kit etəm Ijip kit tatoh. Kən in təmuwɨn məmə otasitu e in kit əmun mohamnu etəm Ijip apon. ");
INSERT INTO tnn_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Kən Moses nɨkin təməht məmə kəm-naka in mɨn neen netəm Isrel okotɨtun məmə Uhgɨn təmahl-ipən in məmə otuwɨn məmki-rəkɨs ilat e nahməən katol elat. Məto ilat kotəruru. ");
INSERT INTO tnn_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kən lawɨgin təməplan mɨn noanol kəiu rəha Isrel kətioh ilau mɨn, kən tuwɨn məghat kəm ilau məmə otoor rəkɨs ilau, kən məmə otol ilau kioal-wɨr ilau mɨn. Kən mən-ipən kəm ilau məmə, ‘Suah mil. Itəlau piatəlau agɨn mil. ?Tahro natioh itəlau mɨn?’ ");
INSERT INTO tnn_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Məto suah u təmətuoun nəmohən təmətgi-pən Moses isəu, kən mən-ipən kəm in məmə, ‘?Pah təmɨləs-ipər ik məmə nakatərəmərə kən matiuw-iarəp itɨmat? ");
INSERT INTO tnn_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","!Okəm-naka nakolkeike məmə onakohamnu mɨn io tahmen e etəm Ijip u nəmoh nəniəp!’ ");
INSERT INTO tnn_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nian Moses təməto nəghatən əh, kən təməgɨn miet Ijip magɨm muwɨn əpəh Mitian mətatɨg ikɨn mahmen e iapɨspɨs kit. Nian təmətatɨg mətatɨg mit pətan ikɨn kit, kən mialəs nətɨlau kəiu iərman mil. ");
INSERT INTO tnn_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Nian təmətatɨg Mitian mɨnos nup foti, kən nian kit tuwɨn mətan iuəhkɨr o nɨtot asol əh Sinae əpəh ikɨn taruən-aruən ikɨn. Kən nagelo kit təmiet-arəpa ron e nɨgəm itəm tatuəp e nɨg əkəku kit. ");
INSERT INTO tnn_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nian təməplan nɨgəm əh, narmɨn təmiwɨg pɨk ron, kən muwɨn iuəhkɨr məmə otəplan wɨr, kən məto Iərəmərə Uhgɨn təməghat kəm in məmə, ");
INSERT INTO tnn_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Io Uhgɨn rəha tɨpɨm mɨn, Uhgɨn rəha Epraham, ne Aisak, ne Jekop.’ Kən Moses təməgɨn mɨnətasiəp mɨnatəgin nətag-pənən əh nɨgəm ikɨn. ");
INSERT INTO tnn_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Kən Iərəmərə Uhgɨn təmən-ipən kəm in məmə, ‘Oh-rəkɨs rəham put e nelkəm məto-inu nəptən ik natətul ikɨn in tol pɨsɨn agɨn, məto-inu io əh-ikɨn. ");
INSERT INTO tnn_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Eməplan nəratən itəm katol e rəhak netəmim əpəh Ijip, eməto nasəkən rəhalat, kən mɨnatite muwa məmə ekəmki-rəkɨs ilat o netəm Ijip. Wa. Roiu əh ekahl-ipən ik nakɨtəlɨg muwɨn mɨn Ijip.’” ");
INSERT INTO tnn_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Kən Stipen təmatəkəike matən məmə, “Inu etəm kitiəh əm Moses itəm ilat kəmotapəs nəwian nian ilat kəmotən-ipən kəm in məmə, ‘?Pah təmɨləs-ipər ik məmə nakatərəmərə kən matiuw-iarəp itɨmat?’ Məto Uhgɨn pɨsɨn əm təmahl-ipən suah əh Moses məmə otərəmərə kən mosmegəh ilat. Təmahl-ipən nian nagelo təmiet-pa ron e nɨgəm itəm tatuəp e nɨg əkəku kit. ");
INSERT INTO tnn_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Kən Moses təmit ilat motiet Ijip, kən in təmol nat pɨspɨs ne nəmtətin tepət, təmol əpəh Ijip, ne nian kəmoateguəfɨmɨn e nɨtəhəi u katən məmə Nɨtəhəi Asiə, ne nup foti e ikɨn taruən-aruən ikɨn. ");
INSERT INTO tnn_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Inu etəm kitiəh əm Moses u təmən-ipən kəm netəm Isrel məmə, ‘Uhgɨn otɨləs-ipər ien kit mɨn etəmat tahmen lak.’ ");
INSERT INTO tnn_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","“Inu Moses itəm noanol mɨn rəha Isrel kəmoatan kitiəh ilat min, kən nagelo təməghat kəm in e Nɨtot Sinae, kən ilat tɨpɨtat mɨn kəmoatan. Kən Uhgɨn təmos-ipən nəghatən keike mɨn itəm koatəmegəh, kən in otəhlman tuwa kəm kitat. ");
INSERT INTO tnn_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Məto nian in təmətatɨg əh əpəh e Nɨtot Sinae, tɨpɨtat mɨn kəmotəht nəwian, motapəs nətəlɨg-inən məto nɨkilat təmɨtəlɨg-pən o nat Ijip. ");
INSERT INTO tnn_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Kən kəmotən-ipən kəm Eron məmə, ‘Ol narmɨ nat kit məmə in otuwa uhgɨn rəhatat. ?Məto Moses əh inəh, itəm təməmɨk itat kotiet Ijip, kɨnotəruru məmə in tɨnahruwɨn?’ ");
INSERT INTO tnn_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kən e nian əh, ilat kəmotol narmɨ nətɨ kau kit məmə in otuwa uhgɨn rəhalat, kən kəmotol sakrifais e nat megəh mɨn məmə okotəfak kəm in. Kən kəmotol lafet rəha narmɨ nətɨ kau itəm ilat əm kəmotol. ");
INSERT INTO tnn_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Məto Uhgɨn təməuhlin-pən məntaan kəm ilat, kən megəhan-in ilat məmə okotəfak kəm mɨtgar ne məwɨg ne məhau mɨn e napuə. Kən nat əh tatəgətun əsas əm nəghatən rəha Uhgɨn itəm kəməte e naoa rəha ien mɨn rəha Uhgɨn. Tatən məmə, ‘!Netəm Isrel! ?Nian rafin e nup foti e ikɨn taruən-aruən ikɨn, itəmat nakoatoh nat megəh mɨn məmə nakoatol-pa sakrifais kəm io? !Kəp! ");
INSERT INTO tnn_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Məto itəmat nəmoatɨləs nimə tapolen rəha uhgɨn eiuə u Molek, ne narmɨ məhau rəha uhgɨn eiuə u Refan. Nat mil u nəmoatol məmə onokotəfak kəm ilau. O nat əh ekahl-iarəp itəmat nakotuwɨn isəu motaprəkɨs-in Papilon.’” ");
INSERT INTO tnn_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Stipen təmatəkəike matən məmə, “Nian tɨpɨtat mɨn kəmotatɨg ikɨn taruən-aruən ikɨn aupən, ilat kəmotos rəhalat nat kit, Nimə Tapolən rəha Uhgɨn itəm tatəgətun məmə Uhgɨn tətatɨg ilat min. Kən Moses təmol Nimə Tapolən əh tətəu-pən əm nətəlɨgən rəha Uhgɨn u təmən-ipən rəkɨs kəm in. ");
INSERT INTO tnn_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kən nup tepət uarisɨg, e nian Josua təmit ilat motuwa məmə okotos-irəkɨs nɨtən əh o netəm Kenan, kən kəmotɨləs Nimə Tapolən u motuwɨn e nɨtən u Uhgɨn təməhg-irəkɨs netəmim ikɨn. Kən ilat kəmotɨləs motuwɨn motatɨg ilat min kətoarus-pa e nian rəha Tefɨt təmol kig lan. ");
INSERT INTO tnn_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Uhgɨn təmol təwɨr kəm Tefɨt, kən Tefɨt təmətapəh ron məmə Uhgɨn otegəhan in pəs tol nimə kit itəm Uhgɨn otətatɨg ikɨn. ");
INSERT INTO tnn_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Məto nimə əh, Kig Tefɨt təməsolən, məto nətɨn Kig Solomon təmol. ");
INSERT INTO tnn_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Məto Uhgɨn itəm ilɨs agɨn, təsatɨgən e nimə itəm etəmim əm təmol, tahmen e nəghatən rəha Uhgɨn itəm ien rəhan təmən məmə, ");
INSERT INTO tnn_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ikɨn mɨn rafin e neai tahmen in əm io məmə iakəpələh ikɨn mərəmərə, kən nətueintən rafin tahmen in əm məmə ekəf-pən nelkək ikɨn. ?Məto nimə-naka itəm nəkotɨtun nolən məmə otahmen-in io? ?Kən ikɨn pəhruən nəkotɨtun nolən məmə ekuwɨn mameg ikɨn? ");
INSERT INTO tnn_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Otən-tu. ?Pah təmol rafin natɨmnat mɨn əh? Io pɨsɨn əm, io Uhgɨn emol rafin ilat.’” ");
INSERT INTO tnn_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Kən Stipen təmatəkəike matən məmə, “!Itəmat u! Rəhatəmat-kapə təskasɨk. Rəhatəmat nətəlɨgən tapinəp tahmen e rəha netəm kəsotəfakən. Itəmat nəsotolkeikeən məmə onəkotol nəwia Uhgɨn. !Itəmat nəkotahmen e tɨpɨtat mɨn itəm koatəht nəwia Narmɨn Rəha Uhgɨn! ");
INSERT INTO tnn_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","?Ien mɨn rəha Uhgɨn aupən, pah tɨpɨtəmat mɨn kəməsotolən nəratən kəm in? !Tɨkə! Kəmotol nəratən kəm ilat rafin. Kəmotohamnu mɨn itəm mɨn u koatən-iarəp nuwamən rəha Etəm Ətuatɨp. Kən itəmat nəmotegəhan-in-pən Etəm Ətuatɨp u e nelmɨ rəhan tɨkɨmɨr mɨn kən kotohamnu. ");
INSERT INTO tnn_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Itəmat nəmotos rəkɨs Lou rəha Uhgɨn u aupən nagelo mɨn kəmotos motuwa, məto itəmat nəməsotətəu-pən agɨnən Lou əh.” ");
INSERT INTO tnn_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nian kəmoatəto nəghatən mɨn rəha Stipen, nɨganəmtɨlat təmapinəp, nɨkilat nahmə nahmə, kən moatəgətain-pən nəluɨlat kəm in məto-inu nɨkilat nahmə agɨn. ");
INSERT INTO tnn_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Məto Narmɨn Rəha Uhgɨn təmərioah e Stipen, kən tɨtagpər e Nego e Neai məplan nəhag-əhagən itəm təsanən pɨk təmiet imə Uhgɨn ikɨn, kən məplan Iesu tatətul e nɨkalɨ Uhgɨn matɨp, ikɨn rəha nərəmərəən ne nəsanənən. ");
INSERT INTO tnn_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kən Stipen təmən-ipən kəm ilat məmə, “!Ei, nəman! Iatəplan Nego e Neai rəha Uhgɨn taterəh, kən Nətɨ Etəmim tatətul e nɨkalɨ Uhgɨn matɨp, ikɨn rəha nərəmərəən ne nəsanənən.” ");
INSERT INTO tnn_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Nian netəm-iasol rəha kaonsel kəmotəto nəghatən əh, kəmotasitɨg matəlgɨlat mɨn e noanelməlat, kən motearɨg e Stipen e nəwialat rafin motaut motaiu motuwɨn kea-pən ahmən-ahmen əm ron, ");
INSERT INTO tnn_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","motewkəkan ka kərakin-iarəp e taon, kən mɨnoatətuoun kətaht e kəpiel apɨn. Kən ilat kəmotapeg rəhalat sot asol mɨn, motəlɨn-pən iuəhkɨr o nelkɨ etəm aluə kit, nərgɨn u Sol. ");
INSERT INTO tnn_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nian kəmotaht Stipen e kəpiel apɨn, in təməfak məmə, “Iərəmərə Iesu, os narmək.” ");
INSERT INTO tnn_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kən təmeiuaiu mɨsin nulɨn kən masək əfəməh məmə, “Iərəmərə, afəl nolən rat itəm ilat koatol lak.” Nian təmol namnun rəhan nəfakən, kən rəhan namegən tiet. ");
INSERT INTO tnn_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Kən Sol tatətul əm nɨkin tətagien məmə ilat kəmotahtɨmnu Stipen. Mətuoun e nian əh, nəratən asol kɨnatol e niməfak əpəh Jerusalem. Kən ilat kəmotiet Jerusalem motagɨm-pən Jutia ne Sameria, motapəs pɨsɨn əm aposol mɨn koatatɨg Jerusalem. ");
INSERT INTO tnn_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Netəmim neen itəm koatəfak əskasɨk kəmotuwa motɨləs Stipen motuwɨn kɨtənɨm, kən ilat kəmotasək pɨk ron. ");
INSERT INTO tnn_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Məto Sol təmətuoun mɨnatərəkɨn-ərəkɨn niməfak, matuwɨn e nimə mɨn matewkəkan-iarəp nəman ne nɨpɨtan itəm koatəfak, kən matəmki-pən ilat e kalapus. ");
INSERT INTO tnn_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Kən netəm koatəfak itəm kəmotiet Jerusalem moatagɨm, kəmotən-iarəp nəghatən rəha Uhgɨn ikɨn mɨn rafin itəm ilat koatuwɨn ikɨn. ");
INSERT INTO tnn_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip təmuwɨn e taon kit rəha Sameria, kən matən-iarəp namnusən rəha Kristo itəm Uhgɨn təmən məmə otahl-ipa. ");
INSERT INTO tnn_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nian nɨmanin netəmim kəmotəto Filip, kən motəplan nat pɨspɨs mɨn itəm in tatol, ilat rafin kəmotuwa iuəhkɨr katətəlɨg-in nat naka in tatən. ");
INSERT INTO tnn_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Netəmim tepət narmɨn rat mɨn kəmotiet elat. Nian narmɨn rat mɨn kəmoatiet, kəmotearɨg əfəməh. Kən netəmim tepət itəm nɨpətɨlat təmɨmɨs, o itəm kəsotaliwəkən, kəmotəwɨr mɨn. ");
INSERT INTO tnn_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kən netəmim rafin e taon əh, ilat rafin koatagien. ");
INSERT INTO tnn_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kən e taon əh, suah kit nərgɨn u Saimon, in təmatol nat pɨspɨs tepət e nəsanənən rəha iərmɨs mɨn, kən netəmim rafin rəha Sameria, narmɨlat təmiwɨg ron. Təmol nuwəh məsɨn. In matos-ipər atɨp in məmə in etəm-iasol kit. ");
INSERT INTO tnn_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Kən netəmim rafin, netəm-iasol mətoarus-pa iolwək mɨn əm, kəmoatətag-pən pɨk ron kən moatən məmə, “Suah u in uhgɨn kit u nərgɨn u Uhgɨn Itəm Rəhan Nəsanənən Ilɨs.” ");
INSERT INTO tnn_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Kəmoatətəu-pən in nuwəh məsɨn məto-inu narmɨlat tatiwɨg o natɨmnat mɨn itəm in tatol. ");
INSERT INTO tnn_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Məto nian netəmim kəmotəto nəghatən itəm Filip tatən-iarəp e namnusən təwɨr rəha nərəmərəən rəha Uhgɨn ne nəghatən rəha Iesu Kristo, kəmotən nɨpahrienən lan, kən kəmol baptais elat, nəman ne nɨpɨtan. ");
INSERT INTO tnn_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Suah mɨn u Saimon, təmən mɨn nɨpahrienən e Iesu, kən kol baptais mɨn lan. Kən in tatətəu-pən Filip ikɨn mɨn rafin. Narmɨn tatiwɨg o nat pɨspɨs mɨn ne nəmtətin mɨn itəm in tatəplan Filip tatol. ");
INSERT INTO tnn_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nian aposol mɨn əpəh Jerusalem kəmotəto məmə netəm Sameria kɨnotahatətə e nəghatən rəha Uhgɨn, kən kəmotahl-ipən Pita ne Jon məmə okian olat. ");
INSERT INTO tnn_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nian ilau kəmian muet-arəpən olat, kəmuəfak olat məmə Narmɨn Rəha Uhgɨn otərioah mətatɨg elat, ");
INSERT INTO tnn_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","məto-inu kəmol baptais əm elat e nərgɨ Iərəmərə Iesu, məto Narmɨn Rəha Uhgɨn təsərioahən əh e nəmegəhən rəhalat. ");
INSERT INTO tnn_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Kən Pita ne Jon kəmuələhəu-pən nelmɨlau elat muəfak elat, kən Narmɨn Rəha Uhgɨn təmərioah mətatɨg elat. ");
INSERT INTO tnn_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nian Saimon təməplan məmə Narmɨn Rəha Uhgɨn tatuwɨn e nəmegəhən rəha netəmim nian aposol mil katuələhəu-pən nelmɨlau elat matuəfak elat, kən in təməmki-arəp məni məmə otos-ipən kəm ilau, ");
INSERT INTO tnn_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","kən mən-ipən kəm ilau məmə, “Ios-ipa mɨn nəsanənən u kəm io məmə nian iakələhəu-pən nelmək e netəmim, kən ilat kotɨtun nosən Narmɨn Rəha Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Məto Pita təmən-ipən kəm in məmə, “!Ik ne rəham məni onakian e nɨgəm asol! Məto-inu ik nɨkim təht məmə nəkɨtun nos-nəmtɨnən e məni nat u itəm Uhgɨn tatos-ipən əm kəm netəmim. ");
INSERT INTO tnn_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Okol ik nəsolən wək u məsɨn ne, məto-inu rəham nətəlɨgən təsətuatɨpən e nɨganəmtɨ Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Əuhlin ik e rəham nolən rat mɨn kən məfak-pən kəm Iərəmərə, məta in tafəl rəkɨs rəham nolən rat mɨn itəm nɨkim tatuəhl-uəhl ilat. ");
INSERT INTO tnn_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Eməplan məmə nian rafin netəhakən təmol rəham nətəlɨgən tuwɨn ik pɨsɨn, kən nolən rat əh təməlis ik tiəkɨs.” ");
INSERT INTO tnn_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Kən Saimon təmən-ipən məmə, “!Awi! Uəfak-pən kəm Iərəmərə ron io məmə natɨmnat itəm itəlau nəmuən, kit otəsuwamən ron io.” ");
INSERT INTO tnn_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Nian ilau kəmuən-iarəp nəghatən rəha Iərəmərə ne natɨmnat itəm in təmol, kən ilau kəmiaiet Sameria mətian Jerusalem, muətul əgmagɨm e latuənu mɨn rəha Sameria matuən-iarəp mɨn namnusən təwɨr rəha Iərəmərə. ");
INSERT INTO tnn_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Kən nagelo kit rəha Iərəmərə təmən-ipən kəm Filip məmə, “Əsou pis muwɨn e suatɨp tatɨsɨ-pən Jerusalem matuwɨn Kasa.” (Suatɨp əh tatəməhl əpəh ikɨn taruən-aruən ikɨn.) ");
INSERT INTO tnn_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Kən in təmatuwɨn əmun məplan etəm Itiopia kit e suatɨp. Suah əh in etəm-iasol kit rəha kwin rəha netəm Itiopia. Kən in tatərəmərə e məni rafin rəha kwin. Suah u təmɨsɨ-pən Jerusalem e nəfakən, ");
INSERT INTO tnn_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","kən mɨnɨtəlɨg matuwɨn iman ikɨn. Kən in tatəpələh-pər e nat kit katən məmə, “kat” itəm hos tatiuw. Kən mətafin naoa itəm ien rəha Uhgɨn Aesea təməte. ");
INSERT INTO tnn_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Kən Narmɨn Rəha Uhgɨn təmən-ipən kəm Filip məmə, “Uwɨn maliwək iuəhkɨr o kat əh.” ");
INSERT INTO tnn_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Kən Filip təmaiu muwɨn iuəhkɨr ron, məto suah u tətafin naoa itəm ien rəha Uhgɨn Aesea təməte. Kən təmətapəh ron məmə, “?Nəkɨtun nɨpətɨ nat un nakatafin, o kəp?” ");
INSERT INTO tnn_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Kən suah un təmən-ipən kəm Filip məmə, “?Ekahro mɨtun? Məto-inu suah kit tɨkə itəm otuhapɨk nɨpətɨ nəghatən u kəm io.” Kən in mətapəh məmə Filip otər muwɨn ilau min muəpələh. ");
INSERT INTO tnn_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","In təmətafin nəghatən u e Naoa Rəha Uhgɨn, tatən məmə, “Kəmit tahmen e sipsip kan məmə okohamnu. Kən tahmen e nətɨ sipsip, təsəghatən nian katəte noanun, Kən in təməpnapɨn əm, məsəghatən. ");
INSERT INTO tnn_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Kəmol aulɨs in, kən nian kəmakil e kot, kɨsakil ətuatɨpən. Nian kəmotohamnu, in etəm aluə əm kit, itəm nətɨn tɨkə.” ");
INSERT INTO tnn_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kən suah u təmətapəh o Filip məmə, “?Karmə Aesea təmatəghat atɨp in, o etəm pɨsɨn kit?” ");
INSERT INTO tnn_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Kən Filip təmətuoun e nəghatən kitiəh əm itəm təmətafin, matən-ipən namnusən təwɨr rəha Iesu. ");
INSERT INTO tnn_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Nian kəmatian e suatɨp muea ikɨn kit nəhau əh-ikɨn, kən suah un təmən-ipən kəm Filip məmə, “!Əplan-tu! Nəhau kit əpəh. ?Tahro? ?Pəs nakol baptais lak lan?” ");
INSERT INTO tnn_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Kən təmən-iəhau kat məmə otətul, kən ilau kərən kəmian əpəh ləhau e nəhau, kən Filip tol baptais lan. ");
INSERT INTO tnn_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nian kəmuər e nəhau muea ilɨs, Narmɨn rəha Iərəmərə tɨləs-irəkɨs Filip. Kən suah un təmɨsəplan mɨnən, məto təmɨtəlɨg matuwɨn iman ikɨn e nagienən asol e nɨkin. ");
INSERT INTO tnn_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Məto Filip təmaut əm, məplan tatətul əpəh e nɨtən pəhap ikɨn əpəh Astot. Kən in təmatuwɨn əpəh e taon mɨn matən-iarəp namnusən təwɨr rəha Iesu mətoarus in təmiet-pən əpəh Sisaria. ");
INSERT INTO tnn_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Kən e nian əh, Sol təmatəghat əskasɨk matən-iəkɨs məmə otohamnu netəmim rəha Iesu. In təmuwɨn məplan pris asol agɨn ");
INSERT INTO tnn_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","mətapəh ron məmə otəte naoa kit kəm nimə rəha nuəfɨmɨnən rəha netəm Isrel əpəh Tamaskes, məmə okəmə otəplan kit tatətəu-pən Suatɨp Rəha Iesu, nat əpnapɨn iərman o pətan, otaskəlɨm ilat məlis ilat məmɨk ilat muwɨn e kalapus əpəh Jerusalem. ");
INSERT INTO tnn_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nian Sol təmuwa iuəhkɨr o Tamaskes, roiu agɨn mɨn nəhag-əhagən kit təmɨsɨ-pər e neai tatuəp tahmen e nɨpɨtən muwa masiəgəpɨn in ne ikɨn mɨn tɨtəlau lan. ");
INSERT INTO tnn_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Kən in təmiet morin e nəptən, kən məto nəwia suah kit tatən-ipən kəm in məmə, “!Sol! !Sol! ?Tahro natol nəratən kəm io?” ");
INSERT INTO tnn_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Kən Sol tətapəh məmə, “?Ik pah, Iərəmərə?” Kən nəwia suah un təmən-ipən kəm in məmə, “Io Iesu itəm ik natol tərat kəm io. ");
INSERT INTO tnn_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Məto roiu ətul muwɨn əpəh e taon. Ikɨn əh, suah kit əh-ikɨn otəpanən-ipɨnə məmə nat naka onəkol.” ");
INSERT INTO tnn_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Kən netəmim itəm koatuarisɨg-in Sol, kəmotaut kətul kəsəghatən, kəmotəto əm nəwia suah un, məto kəsotəplanən. ");
INSERT INTO tnn_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Kən Sol tətul, məto nɨganəmtɨn tɨnoapoap, tɨnəruru nehmən nat. Kən kəmotos əm nelmɨn motit motuwɨn Tamaskes. ");
INSERT INTO tnn_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Təmos nian kɨsɨl təmɨsehmən nat, kən təməsagwənən kən məsənɨmən nəhau ne. ");
INSERT INTO tnn_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Əpəh e Tamaskes, etəm rəha Iesu kit əh-ikɨn, nərgɨn u Ananaeas. Iərəmərə təmaun-in e nat kit tahmen e napɨlaiirən, kən mən-ipən kəm in məmə, “!Ananaeas!” Kən in tagət məmə, “Iərəmərə, io əpəh.” ");
INSERT INTO tnn_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Kən Iərəmərə tən-ipən kəm in məmə, “Uwɨn əh e nimə rəha Jutas e suatɨp asol itəm katən məmə Tətuatɨp, kən mətapəh o etəmim kit, etəm Tasas, nərgɨn u Sol. In tatəghat roiu kəm Uhgɨn e nəfakən, ");
INSERT INTO tnn_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","kən Uhgɨn təmos-ipən napɨlaiirən kit, kən təməplan etəmim kit, nərgɨn u Ananaeas, təmuwa mələhəu-pən nelmɨn lan məmə nɨganəmtɨn otəwɨr mɨn.” ");
INSERT INTO tnn_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Məto Ananaeas təmə, “Iərəmərə, eməto nənən tepət e suah əh e rəhan nolən rat mɨn itəm tatol e netəm koatahatətə lam əpəh Jerusalem. ");
INSERT INTO tnn_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Kən in təmuwa ikɨn-u e nərgɨ pris asol mɨn məmə otaskəlɨm, məlis netəm koatahatətə lam.” ");
INSERT INTO tnn_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Məto Iərəmərə təmən kəm Ananaeas məmə, “!Uwɨn! Məto-inu suah u in rəhak etəmim itəm enəmaun-in rəkɨs məmə otən-iarəp nərgək kəm netəm Iaihluə u sənəmə netəm Isrel, ne rəhalat kig mɨn, ne netəm Isrel. ");
INSERT INTO tnn_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Kən io epanəgətun in məmə otos nahməən o nərgək.” ");
INSERT INTO tnn_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kən Ananaeas təmuwɨn latuənu muwɨn imə, kən mələhəu-pən nelmɨn e Sol, mən-ipən kəm in məmə, “Piak Sol. Iərəmərə Iesu itəm təmiet-arəp ron ik e suatɨp nian nəmoatuwa ikɨn-u, in təmahl-ipa io məmə ik onakehm mɨn nat, kən Narmɨn Rəha Uhgɨn otərioah mətatɨg lam.” ");
INSERT INTO tnn_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Roiu agɨn, nat kit tahmen e nuwilɨgɨ nəm təmiet rəkɨs e nɨganəmtɨ Sol, kən in tɨnaiir mɨn mɨnatehm nat. Kən in təmətul mɨnataliwək, kən kol baptais lan məmə in nəmtətin rəha nahatətəən. ");
INSERT INTO tnn_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kən nian təmun nagwənən neen, kən nɨpətɨn təməsanən mɨn. Kən Sol təmatɨg mos nian neen mɨn ilat netəm rəha Iesu əpəh Tamaskes. ");
INSERT INTO tnn_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Təmətuoun mɨn əm e nian əh, matən-iarəp nərgɨ Iesu əpəh e nimə rəha nuəfɨmɨnən rəha netəm Isrel, məmə Iesu in Nətɨ Uhgɨn pahrien. ");
INSERT INTO tnn_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Kən netəmim rafin itəm kəmotəto in, kəmotaut pɨk ron, kən motən məmə, “!Ei! ?Suah u inu təmatol nəratən kəm netəm koatahatətə e Iesu əpəh Jerusalem aupən, o kəp? Kən in təmuwa ikɨn-u məmə otaskəlɨm ilat məlis ilat məmɨk muwɨn kəm pris asol mɨn. ?In əh, o kəp?” ");
INSERT INTO tnn_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Kən nəghatən itəm Sol tatən-iarəp, in təsanən pɨk maprəkɨs-in nəghatən rəha netəm Isrel itəm koatatɨg Tamaskes, kən matəgətun wɨr məmə Iesu in Kristo itəm Uhgɨn təmən məmə otahl-ipa. Kən ilat kɨnotəruru nat okotən. ");
INSERT INTO tnn_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Nian tepət təmuwa muwɨn rəkɨs, kən netəm Isrel neen kəmoatəte anion noa kit məmə okotohamnu Sol, ");
INSERT INTO tnn_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","məto Sol təməto noa anion rəhalat. Kən roiu e nərauiəgən ne lapɨn mɨn, netəm Isrel kotətlosɨg əpəh e nafiluə rəha fenɨs kəmol e kəpiel məmə okotohamnu Sol. ");
INSERT INTO tnn_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Məto in mɨn neen kəmotɨləs lapɨn motaii-pən e kətɨm asol kit itəm kəmətu-pən təulə lan, motuwɨn motɨləs-iarəp e nakuhal e fenɨs. Kən in təmagɨm muwɨn Jerusalem. ");
INSERT INTO tnn_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Nian Sol təmuwɨn Jerusalem, təmalkut məmə otuwɨn mətəu-pən netəm rəha Iesu, məto ilat koatəgin, nɨkilat təht məmə tateiuə-in əm ilat məmə in etəm rəha Iesu. ");
INSERT INTO tnn_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Məto Panapas təmit muwɨn mit-ipən kəm aposol mɨn, mən-ipən kəm ilat məmə təmahro nulan Sol təməplan Iərəmərə Iesu e suatɨp nian təmatuwɨn Tamaskes. Kən təmən-ipən mɨn kəm ilat məmə Iərəmərə təməghat kəm Sol, kən tahro nulan in tɨnatən-iarəp nərgɨ Iesu əpəh Tamaskes, məsəgɨnən. ");
INSERT INTO tnn_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kən ilat Sol kəmotatɨg kən tatuwɨn ikɨn mɨn əpəh Jerusalem matən-iarəp nərgɨ Iərəmərə Iesu məsəgɨnən. ");
INSERT INTO tnn_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Kəmotəghat ilat netəm Isrel itəm kotən nəghatən rəha netəm Kris, kəmotoh ilat mɨn e nəghatən. Kən kɨnoatol məmə okotohamnu Sol. ");
INSERT INTO tnn_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nian in mɨn neen rəha niməfak kəmotəto, kəmotuwɨn motit Sol motuwɨn əpəh ləhau iuəhkɨr o itəhəi e taon əh Sisaria, kən motahl-ipən məmə otagɨm muwɨn əpəh isəu e taon əh Tasas. ");
INSERT INTO tnn_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Kən netəm koatəfak əpəh Jutia, ne Kalili, ne Sameria kəmotatɨg e nəməlinuən, etəmim tɨkə itəm otol nəgɨnən kəm ilat. Kən Narmɨn Rəha Uhgɨn təmətasitu elat mol ilat koatətul əskasɨk, kən ilat rafin koatatɨg katɨsiai-in Iərəmərə. Kən ilat tɨnatepət. ");
INSERT INTO tnn_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita təmaliwək muwɨn ikɨn mɨn məmə otuag netəm koatahatətə e Iesu. E rəhan naliwəkən, təmuwɨn məplan netəmim rəha Iərəmərə əpəh e taon əh Lita. ");
INSERT INTO tnn_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Təmuwɨn ikɨn əh məplan suah kit nərgɨn u Aeneas, nɨpətɨn təmɨmɨs tɨnos nup eit, təsaliwəkən mətapɨl əm e rəhan pet. ");
INSERT INTO tnn_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Kən Pita təmən-ipən kəm in məmə, “Aeneas. Iesu Kristo tosmegəh ik əh-roiu e rəham nɨmɨsən. Ətul, maiu-aiu rəham nɨmɨtiwɨn.” Kən roiu agɨn mɨn, Aeneas təməwɨr mɨn mətul. ");
INSERT INTO tnn_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Kən netəmim rafin Lita ne ikɨn mɨn rafin əpəh Saron kəmotəplan suah u təmaliwək mətan, kən ilat rafin kɨnotəuhlin rəhalat nətəlɨgən kən mɨnoatəfak kəm Iərəmərə. ");
INSERT INTO tnn_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","E taon kit Jopa, pətan kit əh-ikɨn itəm in etəm rəha Iesu, nərgɨn u Tapita, u nɨpətɨn təmə, “tia,” u in nat megəh kit. E nəghatən rəha netəm Kris, koatən məmə Tokas. Pətan u, nian rafin tatol təwɨr kəm netəmim kən mətasitu mɨn e ian-rat mɨn. ");
INSERT INTO tnn_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Məto e nian əh, nɨmɨsən kit təmol kən tɨmɨs. Kən kəmotau kol senɨs kəm in, kələhəu e nimə əpəh ilɨs agɨn. ");
INSERT INTO tnn_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ikɨn əh Lita iuəhkɨr əm o taon əh Jopa. Kən nian netəm rəha Iesu kəmotəto məmə Pita əpəh Lita, kəmotahl-ipən suah mil kəiu məmə okian mən-ipən kəm in məmə, “!Otuwa uəhai əm-tu!” ");
INSERT INTO tnn_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Kən Pita təmətəu-pən ilau. Nian kəməhalet-arəpa latuənu, kəmotit motuwɨn əpəh ilɨs agɨn. Məto nəutahlɨmɨs mɨn tərioah əpəh ikɨn koatasək ron, kən kəmoatəgətun kəm Pita rəhalat natɨmnat itəm pətan əh təməhl nian təmatəmegəh. ");
INSERT INTO tnn_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Kən Pita təmahl-iarəp rafin ilat, kən meiuaiu mɨsin nulɨn matəfak. Kən mətag-pən o pətan əh təmɨmɨs məmə, “Tapita, ətul.” Kən pətan apon təmaiir məplan Pita, kən mətul matəpələh. ");
INSERT INTO tnn_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Kən Pita təmea-pən ron maskəlɨm miuw-pər məmə otətul e nelkɨn mil. Kən maun-in-pən netəm koatahatətə e Iesu ne nəutahlɨmɨs mɨn məmə okotuwa imə, kən mit-ipən pətan əh kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kən nəghatən e nat əh təmaiu mɨtəlau e taon əh Jopa. Kən tepət kəmotən nɨpahrienən e Iərəmərə Iesu. ");
INSERT INTO tnn_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Kən Pita təmatɨg əh Jopa məsɨn ilau suah kit nərgɨn u Saimon itəm tatol natɨmnat e nuwigɨ kau. ");
INSERT INTO tnn_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","E taon Sisaria, suah kit əh-ikɨn nərgɨn u Konilias. In etəm Rom, kən in etəm-iasol rəha mopael ilat rafin wan-hanrɨt. Kən ilat koatɨsɨ-pən e “Mopael rəha Itali.” ");
INSERT INTO tnn_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","In etəmim kit itəm tatɨsiai-in Uhgɨn rəha netəm Isrel, in ne rəhan mɨn ne rəhan iolwək mɨn. In tatos-ipən rəhan məni tepət kəm ian-rat mɨn, kən matəfak kəm Uhgɨn rəha Isrel nian rafin. ");
INSERT INTO tnn_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Nian kit əmun e tri kɨlok ehnaipən e nian tatəfak lan, təməplan nat kit tahmen e napɨlaiirən. In təməplan wɨr nagelo kit rəha Uhgɨn tatuwa ron, kən maun-in məmə, “!Konilias!” ");
INSERT INTO tnn_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Nian nɨganəmtɨ Konilias təmətul lan, in təməgɨn kən mən məmə, “?Iərəmərə, tahro?” Kən nagelo təmən-ipən kəm in məmə, “Uhgɨn tɨnəplan rəkɨs nəfakən rəham ne nəwɨrən itəm natol kəm ian-rat mɨn. ");
INSERT INTO tnn_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ahl-ipən netəmim neen kotuwɨn əpəh Jopa, motɨləs suah kit motuwa, nərgɨn u Saimon Pita. ");
INSERT INTO tnn_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","In tətatɨg ilau suah kit nərgɨn u Saimon u tatol natɨmnat e nuwigɨ kau. Rəhan nimə tatətul iuəhkɨr o itəhəi.” ");
INSERT INTO tnn_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nian nagelo itəm təmatəghat kəm in təmagɨm, kən Konilias təmaun-in rəhan iolwək kəiu ne mopael kit itəm tatol wək kəm in, kən in etəm rəha nəfakən. ");
INSERT INTO tnn_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","In təmən-ipən rafin natɨmnat itəm təməplan kəm iləhal, kən mahl-ipən iləhal məmə okəhaluwɨn Jopa. ");
INSERT INTO tnn_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kən kəmən lawɨgin, nian mɨtgar tɨnalalin, kən suah miləhal əh kəmatəhaluwa e suatɨp iuəhkɨr o taon əh Jopa, Pita təmuwɨn əpəh ilɨs e nətuei nimə itəm tepin-epin ikɨn məmə otəghat kəm Uhgɨn e nəfakən. ");
INSERT INTO tnn_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Məto nəumɨs tɨnus, kən nian kəmatol əh nɨgɨn nagwənən, in taiir məto təməplan napɨlaiirən kit itəm Uhgɨn tatos-ipa. ");
INSERT INTO tnn_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","E napɨlaiirən əh, təməplan neai təmerəh, kən nat kit tahmen e tapolən asol kətaskəlɨm nɨpəgnəmtɨn mɨn, kən kəhlman-əhlman teiuaiu matuwa e nəptən. ");
INSERT INTO tnn_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","E nɨpəg nat əh, təməplan nat megəh pɨsɨn pɨsɨn mɨn əh-ikɨn itəm kotaliwək ne motəkioah, ne mənɨg pɨsɨn pɨsɨn mɨn. ");
INSERT INTO tnn_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kən nəwia suah kit təmən-ipən kəm in məmə, “Pita, ətul. Ohamnu neen mon.” ");
INSERT INTO tnn_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Məto Pita təmə, “!Iərəmərə, kəp! E rəhak nəmegəhən esonən əh nat kit nulan itəm Lou rəham təmən-iəhau məmə kəsunən tamkɨmɨk e nɨganəmtɨm.” ");
INSERT INTO tnn_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Kən nəwia suah u təməghat mɨn kəm in məmə, “Əsənən məmə nat kit tamkɨmɨk itəm io Uhgɨn iatən məmə təwɨr əm, təsamkɨmɨkən.” ");
INSERT INTO tnn_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Kəmuəghat o natɨmnat mɨn əh mau kɨsɨl, kən roiu agɨn mɨn, tapolən apon təmər muwɨn əpəh e neai. ");
INSERT INTO tnn_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Kən Pita nɨkin təmatəht pɨk məmə otɨtun nɨpətɨ nat əh tahmen e napɨlaiirən itəm təməplan. Məto suah miləhal un itəm Konilias təmahləpis iləhal, kəməhalətapəh o nimə rəha Saimon, kən mɨnəhaluwa mɨnəhaləplan. Kən mɨnəhaluwɨn mətəhalətul əpəh e nafiluə. ");
INSERT INTO tnn_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Kən məhlaun əfəməh məmə, “!Ei! ?Suah kit u ikɨn-u nərgɨn u Saimon Pita?” ");
INSERT INTO tnn_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Kən nian Pita tətalkut əh məmə otɨtun nɨpətɨ nat əh tahmen e napɨlaiirən, kən Narmɨn Rəha Uhgɨn təmən-ipən kəm in məmə, “!Ei, əto-tu! Suah miləhal kɨsɨl əpəh katəhalegəs-in ik. ");
INSERT INTO tnn_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ətul uəhai matite muwɨn məplan iləhal. Kən məsəgɨnən o nətəu-pənən iləhal məto-inu io emahl-ipa iləhal məmə okəhaluwa.” ");
INSERT INTO tnn_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Kən Pita təmeiuaiu muwɨn mən-ipən kəm iləhal məmə, “Io u inu itəm itəməhal natəhalegəs-in. ?Nakəhalolkeike io o naka?” ");
INSERT INTO tnn_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Kən kəhalən-ipən kəm in məmə, “Əwəh. Etəm tatərəmərə e mopael mɨn, u Konilias, təmahl-ipa itɨməhal məmə ekəhaluwa. In suah kit itəm tətuatɨp e nɨganəmtɨ Uhgɨn, kən in matəfak mɨn kəm Uhgɨn. Kən noanol mɨn rəha netəm Isrel koatɨsiai-in pɨk. Nagelo kit rəha Iərəmərə təmən-ipən kəm in məmə ik onəkuwɨn əh iman ikɨn, kən mamnus nəghatən kəm in pəs in otəto.” ");
INSERT INTO tnn_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Kən Pita təmit iləhal motuwɨn imə məmə ilat okotapɨl əh-ikɨn. Kən kəmən lawɨgin, Pita təmətəu-pən iləhal, kən iəfak mɨn neen rəha Jopa, kəmotətəu-pən ilat. ");
INSERT INTO tnn_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Kəmən lawɨgin mɨn, kəmotiet-arəpən əpəh Sisaria. Ikɨn əh Konilias təmətapəh o rəhan mɨn ne netəmim neen məmə okotuwa katəsahgin Pita. ");
INSERT INTO tnn_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Nian Pita təmatuwɨn məmə otuwɨn imə, kən Konilias təmiet mɨsin nulɨn e nelkɨ Pita ikɨn məmə otəfak kəm in. ");
INSERT INTO tnn_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Məto Pita təmɨtol-ipər mɨn mən-ipən kəm in məmə, “Ətul, io etəmim əm tahmen lam.” ");
INSERT INTO tnn_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Kən Pita təmatəghat ilau Konilias kən kəmian imə. Pita təplan məmə netəmim tepət kɨnotuwa rəkɨs katəpələh. ");
INSERT INTO tnn_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Kən Pita təmən-ipən kəm ilat məmə, “Itəmat rafin nəkotɨtun wɨr məmə tasim e Lou rəha netəm Isrel məmə okotuwa mətan kitiəh ilat netəm sənəmə netəm Isrel o kotuwɨn motətag ilat. Məto Uhgɨn təmən kəm io e napɨlaiirən məmə esənən məmə suah kit in tamkɨmɨk e nɨganəmtɨn. ");
INSERT INTO tnn_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Tol-pən nəhlan, nian nəmotahl-ipɨnə nəghatən ron io, eməsənən nat kit, nɨkik təmagien əm məmə ekuwa. ?Məto iakolkeike məmə ekətapəh məmə nəmotahl-ipɨnə nəghatən ron io məmə ekuwa o naka?” ");
INSERT INTO tnn_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kən Konilias təmə, “Nian kɨsɨl tɨnuwɨn rəkɨs tahmen əh-roiu e tri kɨlok ehnaipən, ematəfak əpəh e rəhak nimə. Kən roiu agɨn suah kit itəm rəhan natɨmnat təhag-əhag tətul aupən-in io, ");
INSERT INTO tnn_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","kən mən məmə, ‘Konilias. Uhgɨn təməto rəkɨs rəham nəfakən, kən məsaluinən nat wɨr mɨn itəm ik natol kəm ian-rat mɨn. ");
INSERT INTO tnn_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ahl-ipən netəmim neen kotuwɨn əpəh Jopa o suah kit əh-ikɨn, nərgɨn u Saimon Pita məmə otuwa. In tətatɨg e nimə rəha suah kit, nərgɨn u Saimon, u itəm tatol natɨmnat mɨn e nuwigɨ kau. Rəhan nimə tatətul iuəhkɨr o itəhəi.’ ");
INSERT INTO tnn_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kən ekahl-ipɨnə uəhai əm nəghatən ron ik. Kən təwɨr pɨk məmə ik nəmuwa. Itɨmat rafin u ikɨn-u e nɨganəmtɨ Uhgɨn ioatətəlɨg-in ik məmə onakən-ipa rafin natɨmnat itəm Iərəmərə təmos-ipɨnə məmə onakən-ipa kəm itɨmat.” ");
INSERT INTO tnn_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kən Pita təməghat mən məmə, “Roiu enɨtun məmə sənəmə noanol rəha Isrel əm itəm Uhgɨn nɨkin tagien olat, ");
INSERT INTO tnn_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","məto nɨkin tagien o netəmim ikɨn mɨn rafin itəm koatɨsiai-in ne moatol nat itəm tətuatɨp. ");
INSERT INTO tnn_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","“Itəmat nəkotɨtun rəkɨs nəghatən itəm Uhgɨn təmos-ipən kəm netəm Isrel itəm tatən namnusən təwɨr rəha nəməlinuən ilat Uhgɨn e Iesu Kristo itəm in Iərəmərə rəha netəm rafin. ");
INSERT INTO tnn_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Itəmat nəkotɨtun natɨmnat mɨn itəm Iesu etəm Nasaret təmol əpəh ikɨn mɨn e Jutia təmətuoun e Kalili. In təmol natɨmnat mɨn əh uarisɨg e wək rəha Jon Baptais itəm tatən-iarəp kəm netəmim məmə okəike kol baptais elat. ");
INSERT INTO tnn_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Iesu əh, Uhgɨn təmɨtəpun mos-ipən Narmɨn Rəha Uhgɨn ne nəsanənən kəm in, kən məto-inu Uhgɨn tətatɨg ilau min, in təmuwɨn e ikɨn mɨn matol nat wɨr mɨn, kən matol-wɨr netəmim itəm Setan təməlis ilat. ");
INSERT INTO tnn_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Itɨmat emotəplan natɨmnat itəm in təmol əpəh Jerusalem ne ikɨn mɨn əpəh Jutia. Kən itɨmat emotəplan nian netəmim kəmotoh kətətu-pər e nɨg kəməluau kən tɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Məto Uhgɨn təmol təmegəh mɨn e nian itəm tatol kɨsɨl lan, kən matol əp in kəm netəmim neen məmə okotəplan məmə in təməmegəh mɨn. ");
INSERT INTO tnn_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Sənəmə netəmim rafin kəmotəplan in, məto netəm əm un itəm Uhgɨn təmɨtəpun ilat məmə okotəplan, itɨmat əh inəh emotagwən kitiəh itɨmat min nian təməmegəh mɨn e nɨmɨsən. ");
INSERT INTO tnn_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","“Kən in təmən-ipa kəm itɨmat məmə ekotən Iesu kəm netəmim, kən motən-iarəp məmə Uhgɨn təmɨləs-ipər rəkɨs in məmə in otakil nolən rəha netəmim rafin itəm koatəmegəh ne itəm kɨnotɨmɨs rəkɨs. ");
INSERT INTO tnn_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ien mɨn rafin rəha Uhgɨn aupən kəmoatən-iarəp in məmə, netəmim rafin itəm koatən nɨpahrienən lan, Uhgɨn otafəl rəkɨs rəhalat mɨn nolən rat mɨn e nərgɨ in Iesu.” ");
INSERT INTO tnn_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Nian Pita təmatəghat əh, Narmɨn Rəha Uhgɨn təmuwa mərioah mətatɨg elat u itəm koatəto nəghatən əh. ");
INSERT INTO tnn_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Kən netəm Isrel itəm koatən nɨpahrienən e Iesu itəm kəmotətəu-pən Pita əpəh Jopa motuwa, kəmotaut pɨk nian kəmotəplan nat əh məmə Uhgɨn təmawte-in mɨn Narmɨn Rəhan kəm netəm u sənəmə netəm Isrel. ");
INSERT INTO tnn_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kɨnotɨtun məmə təmos-ipən Narmɨn Rəhan kəm ilat məto-inu kəmotəto netəmim koatəghat e nəghatən ik pɨsɨn mɨn moatɨləs-ipər nərgɨ Uhgɨn. Kən Pita təmə, ");
INSERT INTO tnn_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“?Pah tɨtun nən-iəhauən netəm mɨn u məmə okəsolən baptais elat? Məto ilat kɨnotos rəkɨs Narmɨn Rəha Uhgɨn tahmen etat.” ");
INSERT INTO tnn_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Kən in təmən-ipən məmə okol baptais elat e nərgɨ Iesu Kristo. Kən ilat kəmotətapəh o Pita məmə otatɨg məsɨn ilat min. ");
INSERT INTO tnn_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Kən aposol mɨn ne netəm koatəfak əpəh ikɨn mɨn e nɨtən Jutia kəmotəto məmə Iaihluə mɨn, ilat mɨn kɨnoatən nɨpahrienən e nəghatən rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kən nian Pita təmər muwɨn Jerusalem, məto netəm rəha iəfak mɨn itəm koatən məmə okəkəike katəhg-ipən netəmim, ilat kɨnoatən nɨkalɨn, ");
INSERT INTO tnn_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","moatən məmə, “?Tahro ik nəmuwɨn mətatɨg e nimə rəha netəm kəsəhg-ipənən ilat, mətagwən itəmat min ilat?” ");
INSERT INTO tnn_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kən Pita tɨnətuoun matən wɨr kəm ilat namnusən rəha natɨmnat rafin əpəh Sisaria, ");
INSERT INTO tnn_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","təmatən kəm ilat məmə, “Nian emətatɨg Jopa matəfak məplan nat kit tahmen e napɨlaiirən. E nat əh, eməplan nat kit tahmen e tapolen asol kit itəm təmiet e neai kətaskəlɨm nɨpəgnəmtɨn mɨn kəhlman-əhlman teiuaiu matuwa ron io. ");
INSERT INTO tnn_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Emətag-pən wɨr e nɨpəgnoa nat əh məplan nat megəh pɨsɨn pɨsɨn mɨn əh-ikɨn itəm kotaliwək ne motəkioah, ne nat megəh iarupɨn mɨn, ne mənɨg pɨsɨn pɨsɨn mɨn. ");
INSERT INTO tnn_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kən eməto nəwia suah kit tatən-ipa kəm io məmə, ‘Pita, ətul mohamnu neen mon.’ ");
INSERT INTO tnn_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Məto ekən-ipən kəm in məmə, ‘!Iərəmərə, kəp! E rəhak nəmegəhən esunən nat kit nulan itəm Lou rəham təmən-iəhau məmə ekɨsunən tamkɨmɨk e nɨganəmtɨm.’ ");
INSERT INTO tnn_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Eməto mɨn nəwia suah un təmɨsɨ-pən e neai matən-ipa kəm io məmə, ‘Əsənən məmə nat kit tamkɨmɨk itəm io Uhgɨn iakən məmə təwɨr əm təsamkɨmɨkən.’ ");
INSERT INTO tnn_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Emuəghat o natɨmnat mɨn əh mau kɨsɨl, kən tapolən apon təmər muwɨn əpəh e neai. ");
INSERT INTO tnn_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Kən roiu agɨn e nian əh, suah kɨsɨl kəhaliet-arəpa e nimə itəm iotatɨg ikɨn. Netəm Sisaria kəmotahl-ipa iləhal məmə okəhaluwa ron io, kit io kan. ");
INSERT INTO tnn_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Kən Narmɨn Rəha Uhgɨn təmən-ipa kəm io məmə ekətəu-pən iləhal, nat əpnapɨn iləhal sənəmə netəm Isrel. Piatat mɨn ilat sikis itəm kəmotətəu-pa io, emotuwɨn kiet-pən əpəh e nimə rəha suah əh Konilias motuwɨn imə. ");
INSERT INTO tnn_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kən in təmən-ipa kəm itɨmat məmə təhrol nulan in təməplan nagelo kit rəha Uhgɨn təmuwa miet-arəpa ron e rəhan nimə, kən mən-ipən kəm in məmə, ‘Ahl-ipən netəmim neen kotuwɨn əpəh Jopa o suah kit nərgɨn u Saimon Pita. ");
INSERT INTO tnn_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","In otən-ipɨnə nəghatən kit kəm itəmat məmə itəmat rafin, ik ne rəham mɨn, ne rəham iolwək mɨn, məmə Uhgɨn otosmegəh itəmat rafin.’ ");
INSERT INTO tnn_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Kən nian emətuoun matəghat, Narmɨn Rəha Uhgɨn təmeiuaiu mərioah matɨg elat tahmen əm e inu təmuwa min etat aupən. ");
INSERT INTO tnn_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Kən nɨkik tatəht nəghatən itəm Iərəmərə təmən məmə, ‘Jon tatol baptais e netəmim e nəhau, məto otəsuwəhən Uhgɨn tol baptais etəmat e Narmɨn Rəhan.’ ");
INSERT INTO tnn_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kən okəmə Uhgɨn tatos-ipən kəm ilat Narmɨn kitiəh əm itəm təmos-ipa kəm kitat nian kitat kəmotən nɨpahrienən e Iərəmərə Iesu Kristo, io etəmim əm, okol esən-iəhauən Uhgɨn o nat naka itəm in tolkeike məmə otol kəm ilat.” ");
INSERT INTO tnn_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nian kəmotəto nəghatən rəha Pita, ilat kəməsotetəhau mɨnən, məto kəmotənwiwi Uhgɨn motəmə, “Nat əh tol nulan məmə Uhgɨn tɨnol rəkɨs suatɨp rəha Iaihluə mɨn məmə ilat mɨn okotəuhlin ilat e rəhalat nolən rat mɨn məmə Uhgɨn otosmegəh ilat.” ");
INSERT INTO tnn_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Nian Sol ne rəhan mɨn kəmotohamnu Stipen, kəmatol tərat kəm netəm koatən nɨpahrienən e Iesu. Kən iəfak mɨn əh kəmotagɨm motuwɨn əpəh ikɨn mɨn əpəh Fonisia ne Saepras ne Antiok, motən-iarəp nərgɨ Iesu kəm netəm əm u, netəm Isrel. ");
INSERT INTO tnn_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Məto ilat neen netəm Saepras ne Saerin kəmotuwɨn Antiok motən-iarəp mɨn namnusən təwɨr rəha Iərəmərə Iesu kəm netəm əpnapɨn əm, sənəmə netəm Isrel əm. ");
INSERT INTO tnn_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Kən Iərəmərə təmatol wək tepət e rəhan nəsanənən kən mətasitu pɨk elat, kən netəmim tepət tepət kəmotəuhlin ilat motən nɨpahrienən e Iərəmərə Iesu. ");
INSERT INTO tnn_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Netəm rəha niməfak əpəh Jerusalem kəmotəto namnusən rəha nat əh, kən kəmotahl-ipən Panapas məmə otuwɨn əpəh Antiok. ");
INSERT INTO tnn_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nian təmiet-arəpən, təməplan məmə Uhgɨn təmolkeike pɨk ilat matol təwɨr kəm ilat, kən netəmim tepət kəmotən nɨpahrienən e Iesu, kən Panapas nɨkin təmagien masitu elat məmə ilat okoatətul əskasɨk e Iərəmərə e nɨkilat rafin. ");
INSERT INTO tnn_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Panapas in etəm wɨr kit itəm Narmɨn Rəha Uhgɨn tərioah mətatɨg lan, kən rəhan nahatətəən in təskasɨk o Uhgɨn. Kən in təmasitu e netəmim tepət ikɨn əh məmə ilat okotən nɨpahrienən e Iərəmərə Iesu. ");
INSERT INTO tnn_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kən Panapas təmiet muwɨn Tasas mategəs-in Sol. ");
INSERT INTO tnn_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nian təməplan Sol, təmit mian əpəh Antiok, kəmuatɨg ikɨn o nup kitiəh muatəfak ilat netəm rəha niməfak əh matuəgətun netəmim tepət. Ikɨn əh Antiok kəmətuoun kaun-in netəm rəha Iesu Kristo məmə, “Kristin.” ");
INSERT INTO tnn_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","E nian əh, ien neen rəha Uhgɨn kəmotiet Jerusalem motuwɨn əpəh Antiok. ");
INSERT INTO tnn_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Kit nərgɨn u Akapus təmətul məghat e nəsanənən e Narmɨn Rəha Uhgɨn məmə otəsuwəhən nəumɨs otan e nɨtən Rom apiəpiə. (Nəumɨs təman nian Klotias təmatərəmərə e netəm Rom.) ");
INSERT INTO tnn_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kən netəm rəha Iesu əpəh Antiok kəmotolkeike məmə okotasitu e netəm rəha Iesu əpəh Jutia. Kit tahl-ipən məni naka, tepət o noan məsɨn, itəm tɨtun nahl-ipənən. ");
INSERT INTO tnn_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Kən kəmotol məni mɨn əh, motəmki-pən kəm Panapas ne Sol məmə okuəmɨk mian kəm elta mɨn rəha niməfak əpəh Jerusalem. ");
INSERT INTO tnn_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","E nian əh, nian Panapas ne Sol kəmatuəgətun əpəh Antiok, Kig Herot Akripa Kitiəh təmahl-ipən rəhan mopael mɨn məmə okotaskəlɨm netəmim neen rəha niməfak əpəh Jerusalem məmə otol ilat kotəto nahməən e nɨpətɨlat. ");
INSERT INTO tnn_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Təmahl-ipən rəhan mɨn netəmim kəmotuwɨn kaskəlɨm Jemes pia Jon kən motətamnu e rəhalat naip asol. ");
INSERT INTO tnn_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nian təmətamnu Jemes, məplan məmə netəm Isrel nɨkilat təmagien pɨk ron. Kən in təmatɨg maskəlɨm mɨn Pita. Təmatol nat u e nian kəmatol lafet mil lan Rəha Nuhagego-inən ne Pret U Is Tɨkə Lan. ");
INSERT INTO tnn_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Nian tɨnaskəlɨm rəkɨs Pita, kən təmɨləs-ipən e kalapus. Kən Herot təmən məmə mopael sikistin okoatətlosɨg-in, kuwɨt kuwɨt e aua mɨn rafin e nərauiəgən ne lapɨn. Kən Herot tolkeike məmə otiuw-iarəp tətul e nɨganəmtɨ netəmim nian lafet tɨnol namnun. ");
INSERT INTO tnn_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Məto nian Pita təmətatɨg e kalapus, kən netəm rəha niməfak kəmotəfak-pən əskasɨk ron kəm Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","E lapɨn itəm olawɨg in, kən Herot tiuw-iarəp, Pita təmətapɨl ilugɨn e mopael kəiu, kəməlis nelmɨn mil e sen kəiu, kətu-pən kit e mopael kit, kən kətu-pən kit e mopael kit mɨn. Kən mopael kəiu katuətul matuehm nafiluə e kalapus. ");
INSERT INTO tnn_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Roiu agɨn-əh, nagelo kit rəha Iərəmərə tiet-pa, kən təmasiə məhag-əhag e nɨpəgnoa kalapus. Təmekek nɨkalɨ Pita kən məhgaiir lan. Kən məmə, “!Ətul uəhai!” Kən sen mil kəmuɨsas atɨp e nelmɨ Pita mil. ");
INSERT INTO tnn_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Kən nagelo tən-ipən kəm in məmə, “Uwɨn e rəham put ne natɨmnat.” Kən Pita tuwɨn elat. Kən tən-ipən mɨn kəm in məmə, “Uwɨnin rəham kot, kən mətəu-pa io.” ");
INSERT INTO tnn_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Kən Pita təmətəu-pən miaiet e nɨpəgnoa kalapus, məto in təsɨtunən məmə natɨmnat mɨn u nagelo tatol lan in nɨpahrienən. Nɨkin təht məmə tatehm nat kit tahmen e napɨlaiirən. ");
INSERT INTO tnn_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Kəmualiwək muaprəkɨs-in mopael kit itəm tatehm kalapus, kən mualiwək muaprəkɨs-in mɨn mopael kit mɨn, kən kəmuea e namnu toa itəm kəmiləkɨn e iaen. Toa u tatuag-pən e taon asol. Nian kəmuea iuəhkɨr ron kən təmerəh atɨp kən kəmiaiet-pən ikɨn. Nian kəmualiwək məsɨn mian e suatɨp, kən əmun nagelo təmɨkə mɨn. ");
INSERT INTO tnn_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Kən Pita in tɨnɨtun məmə sənəmə napɨlaiirən, kən tən məmə, “Roiu enɨtun ətuatɨp məmə Iərəmərə təmahl-ipa rəhan nagelo təmuwa mɨləs-irəkɨs io e nat naka itəm Herot tolkeike məmə otol lak itəm netəm Isrel kəmoatolkeike məmə okotəplan.” ");
INSERT INTO tnn_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nian Pita tɨnɨtun məmə Uhgɨn təmɨləs-irəkɨs in, kən təmuwɨn əpəh e nimə rəha Meri, mama rəha Jon Mak. Netəm koatahatətə e Uhgɨn tepət kəmotuwa kitiəh moatəfak-pən kəm Uhgɨn məmə otasitu lan. ");
INSERT INTO tnn_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Kən Pita təməht-əht toa e iat rəha nimə əh, kən pətan iolwək kit, nərgɨn u Rota, təmaiu muwɨn məmə karmə pah əh tatəht-əht toa. ");
INSERT INTO tnn_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nian təməto nəwia Pita, kən təmɨtun məmə in Pita pahrien. Kən nɨkin təmagien pɨk agɨn-əh kən taluin nerəhən e toa məto təmaiu mɨtəlɨg muwɨn məplan netəmim u koatəfak, kən təmən məmə, “!Ei, netəmim, Pita əpəh ihluə e toa tatətul!” ");
INSERT INTO tnn_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Məto kotəmə, “Ah. Ik ialməl.” Məto in təmatəkəike matən məmə, “!Kəp! Iatən pahrien.” Kən ilat kotən məmə, “Okəmə naka rəhan nagelo tiə.” ");
INSERT INTO tnn_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Məto Pita tatəkəike matəht-əht toa. Kən kəmotuwɨn kerəh e toa, kən nian kəmotəplan in, nɨkilat təmaut pɨk ron. ");
INSERT INTO tnn_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Məto Pita təmɨləs-ipər nelmɨn mefətutu ilat məmə okəsotəghatən. Kən matən-iarəp kəm ilat məmə təmahro nulan Iərəmərə təmɨləs-iarəp in e kalapus. Kən mən-ipən kəm ilat məmə, “Otən-ipən nəghatən u kəm Jemes ne piatat mɨn e niməfak.” Kən təmiet magɨm matuwɨn ik pɨsɨn kit mɨn. ");
INSERT INTO tnn_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kəmən lawɨgin, mopael mɨn itəm kəmoatehm Pita e kalapus, kəmotətapəh-ətapəh olat mɨn, kən mɨnotəruru əfəməh məmə Pita təmahruwɨn. ");
INSERT INTO tnn_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Kən nian Herot təməto məmə Pita təmɨkə, kən təmahl-ipən mopael mɨn məmə okotegəs-in. Məto nian mopael mɨn kəməsotəplanən, kən Herot təmaun-in mopael mɨn itəm kəmotehm kalapus mətapəh olat məmə Pita təmahrol magɨm. Məto ilat kotəruru kən in təmən məmə okəmɨk mopael mɨn əh kan kohamnu ilat. Kən Herot təmiet Jutia muwɨn e taon kit Sisaria matɨg ikɨn o nian neen. ");
INSERT INTO tnn_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","E nian əh, Kig Herot Akripa Kitiəh neməha təmol pɨk təmetəhau netəm kotatɨg e taon mil əh, Taea ne Saeton. Kən netəm-iasol mɨn rəha taon mil əh kəmotuwa kitiəh kən motuwɨn məmə okotəplan kig məmə okotaru nego, məto-inu netəm iməlat ikɨn kotuwɨn katos-nəmtɨn nagwənən imə kig ikɨn. Məto aupən ilat kəmotuwɨn motəplan kig, kəmotəghat ilat suah kit nərgɨn u Plastus, itəm tatehm wɨr natɨmnat e nimə rəha Kig Herot, motiuw-pən məmə otətəu-pən ilat. ");
INSERT INTO tnn_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","E nian itəm Kig Herot təmɨtəpun lan məmə otuwɨn məplan ilat, kən təmuwɨn e rəhan natɨmnat wɨr mɨn itəm tatəgətun məmə in tatərəmərə. Kən təmuwa məpələh e ikɨn imə kig, kən matəghat kəm netəmim. ");
INSERT INTO tnn_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Kən netəmim kəmotagət əfəməh məmə, “!Suah u tatəghat sənəmə in etəmim məto uhgɨn kit!” ");
INSERT INTO tnn_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kən roiu agɨn mɨn nagelo kit rəha Iərəmərə təmoh e nɨmɨsən əskasɨk kit məto-inu Herot təmos nənwiwiən o netəmim, kən məsos-ipənən nənwiwiən kəm Uhgɨn, kən wom mɨn kəmoton nɨsgan kən tɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Kən e nian əh, netəm koatən nɨpahrienən e Iesu kəmoatəkəike kətamnus-iarəp nəghatən rəha Uhgɨn e ikɨn mɨn tepət, kən netəmim tepət kəmotuwa katən nɨpahrienən e Iesu. ");
INSERT INTO tnn_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Nian Panapas ne Sol kəmioal namnun rəhalau wək əpəh Jerusalem, miatəlɨg mian Antiok iləhal Jon Mak. ");
INSERT INTO tnn_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","E niməfak Antiok, ien mɨn əh-ikɨn ne iəgətun mɨn. Ilat u Panapas, ne Simeon katən məmə etəm iapɨn, ne Lusias etəm Saerin, ne Manaen u təmepət ilau Herot Antipas u təmatərəmərə e Kalili aupən, ne Sol. ");
INSERT INTO tnn_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","E nian kit ilat kəmotapəs nagwənən kən moatəfak-pən kəm Iərəmərə, kən Narmɨn Rəha Uhgɨn təmən-ipən kəm ilat məmə, “Iakolkeike məmə roiu əh onəkotɨləs-ipər Panapas ne Sol məmə ilau okioal wək u itəm emaun-in ilau ron.” ");
INSERT INTO tnn_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Kən nian kɨnotapəs rəkɨs nagwənən motəfak, kən motələhəu-pən nelmɨlat e rəhalau-kapə məmə okotɨləs-ipər ilau, kən motahl-ipən ilau məmə okian mioal wək. ");
INSERT INTO tnn_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Kən məto-inu Narmɨn Rəha Uhgɨn təmahl-ipən ilau məmə okioal wək u, kən ilau kəmian əpəh e taon Selusia, kən ikɨn əh kəmian e nego kit mian əpəh e nəptən kit Saepras. ");
INSERT INTO tnn_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Nian kəmiet-arəpən e taon Salamis, kəmian e nimə rəha nuəfɨmɨnən rəha netəm Isrel matuən-iarəp nəghatən rəha Uhgɨn. Kən Jon Mak tatətəu-pən ilau mətasitu elau. ");
INSERT INTO tnn_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Kən kəməhlaliwək əm e nəptən un mətoarus məhaliet-arəpa e taon Pafos. Ikɨn əh kəməhaləplan noanol kit rəha Isrel itəm tatol nat pɨspɨs e nəsanənən rəha iərmɨs mɨn, kən in ien eiuə, nərgɨn u Patisas. ");
INSERT INTO tnn_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Suah u tətaliwək nian tepət ilau Setias Polas u kapman asol rəha netəm Saepras. Setias Polas in tenatɨg, rəhan nətəlɨgən təwɨr. Kən in təmahl-ipən nəghatən məmə Panapas ne Sol okuea muəplan, məto-inu tolkeike məmə otəto nəghatən rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Məto suah u Patisas təmatən rat ilau. (Nərgɨn e nəghatən Kris katən məmə Elimas). Kən mətalkut məmə otəuhlin nətəlɨgən rəha Setias Polas məmə otəsənən nɨpahrienən e Iesu. ");
INSERT INTO tnn_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Kən Sol u kətaun-in mɨn məmə Pol, Narmɨn Rəha Uhgɨn təmərioah e nɨkin, kən təmətag-pən ətuatɨp o Elimas kən mən məmə, ");
INSERT INTO tnn_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“!Ei! Ik nətɨ Setan. Ik tɨkɨmɨr rəha natɨmnat rafin itəm kotətuatɨp. Ik nakərioah əm e neiueiuəən ne nəratən. ?Onəghan nəpanapəs nən ratən suatɨp pahrien rəha Iərəmərə itəm natəuhlin? ");
INSERT INTO tnn_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Roiu əh, Iərəmərə otol nalpɨnən kit kəm ik məmə nɨganəmtɨm otəpɨs, onəsəplanən nəhag-əhagən kit ne o nian neen.” Kən roiu agɨn mɨn təməplan norəu ne napinəpən kəmuea mualpin nɨganəmtɨn, kən nɨganəmtɨn təpɨs agɨn. Kən təmətul matea-pən əpnapɨn əm məmə suah kit otasitu lan mit. ");
INSERT INTO tnn_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nian kapman Setias Polas təməplan nat əh, təmən nɨpahrienən e Iesu məto-inu təmaut magien o nəgətunən rəha suah mil e Iərəmərə. ");
INSERT INTO tnn_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Kən Pol ne rəhan mɨn netəmim kəmotiet Pafos motuwɨn e nego kit motuwɨn əpəh taon Perka e ikɨn Pamfilia. Ikɨn əh Jon Mak təmapəs ilat mɨtəlɨg-pən əpəh Jerusalem. ");
INSERT INTO tnn_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Kən ilat kəmotiet Perka motuwɨn əpəh taon Antiok əh-ikɨn Pisitia. Kən e nian rəha Sapat, kəmotuwɨn imə e nimə rəha nuəfɨmɨnən rəha netəm Isrel moatəpələh. ");
INSERT INTO tnn_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Nian kəmotəto nafinən rəha Lou ne Ien Mɨn, kən netəm-iasol rəha nimə əh kəmotahl-ipən nəghatən kəm Pol ne Panapas motən məmə, “Piak mɨn. Okəmə itəmat kit tatos nəghatən wɨr məmə otən tasitu e netəmim, tətul mən-iarəp.” ");
INSERT INTO tnn_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Kən Pol təmətul mefətutu ilat məmə okəsotəghatən, kən mən məmə, “Noanol mɨn rəha netəm Isrel ne itəmat Iaihluə mɨn itəm noatəfak-pən kəm Uhgɨn, otətəlɨg-in-tu io. ");
INSERT INTO tnn_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Uhgɨn rəha noanol mɨn rəha Isrel təmɨtəpun tɨmɨtat mɨn aupən kən mol ilat kotepət nian ilat kəmoatatɨg əpəh ikɨn Ijip. Kən e nəsanənən asol rəhan, təmit-iarəp ilat e nəptən əh. ");
INSERT INTO tnn_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kən matehm wɨr ilat o nup foti nian kəmotan əpəh ikɨn taruən-aruən ikɨn. ");
INSERT INTO tnn_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","In təmol noanol mɨn rəha netəm Isrel kəmotoh kapman mɨn rəha nəptən sepɨn itəm kotatɨg e nɨtən əh Kenan, kən mos-ipən nəptən əh rəhalat kəm tɨpɨtat mɨn məmə rəhatat. ");
INSERT INTO tnn_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Natɨmnat mɨn əh kəmol nup fo-hanrɨt-fifti tɨnuwa mɨnuwɨn rəkɨs. Uarisɨg e natɨmnat mɨn əh, Uhgɨn təmos-ipən kəm noanol mɨn rəha Isrel netəm-iasol mɨn məmə ilat okotərəmərə elat mətoarus-pa e nian rəha ien rəha Uhgɨn Samuel. ");
INSERT INTO tnn_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Kən netəmim kəmotətapəh kəm Samuel o kig, kən Uhgɨn təmos-ipən kəm ilat Sol u nətɨ Kis, təmɨsɨ-pən e noanol rəha Benjamin. Kən in təmərəmərə elat o nup foti. ");
INSERT INTO tnn_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kən nian Uhgɨn təmɨləs-irəkɨs Sol, kən in mol Tefɨt təmuwa kig. In təmən-iarəp nat kit təwɨr lan məmə, ‘Eməplan suah kit Tefɨt nətɨ Jese, in etəm tətuatɨp itəm io iakolkeike. Kən in otol natɨmnat rafin itəm io iakolkeike məmə otol.’ ");
INSERT INTO tnn_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Kən Uhgɨn təmol məmə Iosmegəh kit, inu Iesu, otɨsɨ-pən e noanol rəha suah u Kig Tefɨt, məmə otosmegəh netəm Isrel tahmen-pən əm məmə in təmən-iəkɨs mihin. ");
INSERT INTO tnn_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Məto uarisɨg Iesu tətuoun rəhan wək, Jon təmaupən mən-iarəp kəm noanol mɨn rəha Isrel məmə okotəkəike motəuhlin ilat e rəhalat nolən rat mɨn kən kol baptais elat. ");
INSERT INTO tnn_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nian Jon təmatuwa iuəhkɨr o nolən namnun rəhan wək, in təmən məmə, ‘?Nɨkitəmat təht məmə io pah? Io sənəmə etəm ilouin itəm Uhgɨn təmən rəkɨs. !Kəp! In tatuarisɨg lak itəm io esahmenən məmə ekapeg rəkɨs rəhan put.’ ");
INSERT INTO tnn_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Piak mɨn itəm nəmotɨsɨ-pən e noanol rəha Epraham, ne itəmat Iaihluə mɨn itəm nəkoatəfak kəm Uhgɨn, otətəlɨg-in wɨr, Uhgɨn təmahl-ipa kəm kitat nəghatən u e Iesu məmə in otosmegəh kitat. ");
INSERT INTO tnn_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Kən netəmim itəm kotatɨg Jerusalem ne rəhalat netəm-iasol mɨn kəməsotɨtunən məmə suah əh inəh Iesu, Uhgɨn təmahl-ipa məmə otosmegəh ilat. Kən nat əpnapɨn kəmatafin-iarəp kəm ilat e Sapat mɨn rafin nəghatən rəha ien mɨn rəha Uhgɨn itəm kəmoatən e Iesu, məto ilat kəməsotɨtunən. Kən ilat kəmotən məmə okohamnu Iesu tahmen-pən əm itəm ien mɨn rəha Uhgɨn kəmotən aupən məmə netəmim okotol mihin. ");
INSERT INTO tnn_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Nat əpnapɨn kəməsotəplanən nat kit məmə otɨmɨs ron, məto kəmotətapəh məmə Pailat otohamnu. ");
INSERT INTO tnn_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","“Nian kəmol rafin natɨmnat itəm Nəghatən rəha Uhgɨn təmən məmə okol mihin lan, kən rəhan mɨn netəmim kəmotɨləs-iəhau e nɨg kəluau motɨləs ka kɨtənɨm e nɨpəg kəpiel. ");
INSERT INTO tnn_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Məto Uhgɨn təmol in təmegəh mɨn e nɨmɨsən. ");
INSERT INTO tnn_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Kən e nian tepət tatiet-arəpa o rəhan mɨn netəmim. Netəm əh, ilat Iesu kəmotan aupən əpəh Kalili mətoarus-pa Jerusalem. Kən roiu əh netəm əh koatən-iarəp kəm piatat mɨn u noanol mɨn rəha Isrel, məmə ilat kəmotəplan pahrien Iesu, kən in təməmegəh pahrien. ");
INSERT INTO tnn_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Kən roiu əh, itɨmat ioatən-ipɨnə kəm itəmat namnusən təwɨr əh, məmə nəniəkɨsən itəm Uhgɨn təmol kəm tɨpɨtat mɨn aupən, ");
INSERT INTO tnn_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","roiu əh, tɨnol rafin nəghatən rəhan kəm kitat noanol mɨn rəhalat nian təmosmegəh Iesu e nɨmɨsən. Tahmen-pən əm e Naoa Rəha Uhgɨn e Naoa Rəha Napuən Mɨn kəiu tatən məmə, ‘Ik nətɨk. Roiu enuwa rəham tata ətuatɨp.’ ");
INSERT INTO tnn_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Uhgɨn təmən-iəkɨs rəkɨs e rəhan Naoa məmə otəpanosmegəh Iesu e nɨmɨsən, kən okol təsɨmɨs mɨnən, kən nɨpətɨn otəsəmnəmɨtən. Tatən məmə, ‘Nɨpahrienən, oekos-ipɨnə nat wɨr agɨn mɨn kəm ik itəm emən-iəkɨs rəkɨs kəm Kig Tefɨt aupən.’ ");
INSERT INTO tnn_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Kən e ik pɨsɨn mɨn kit mɨn e Naoa Rəha Uhgɨn, Kig Tefɨt təmən kəm Uhgɨn e Iosmegəh məmə, ‘Kən onɨsegəhan-inən məmə nɨpətɨ Iolwək Ətuatɨp rəham otəmnəmɨt məpien.’ ");
INSERT INTO tnn_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Nian Tefɨt təmatəmegəh, təmol natɨmnat mɨn itəm Uhgɨn tolkeike. Uarisɨg ikɨn tɨmɨs, kən kəmɨtənɨm ilat tɨpɨn mɨn, kən nɨpətɨn təməmnəmɨt. ");
INSERT INTO tnn_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Kən nəghatən əh, təməsəghat-inən Tefɨt, məto təmatəghat-in Iesu məmə in mɨn təmɨmɨs, məto Uhgɨn təmol təmegəh mɨn, kən nɨpətɨn təmɨsəmnəmɨtən. ");
INSERT INTO tnn_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Kən piak mɨn, iakolkeike məmə onəkotɨtun məmə roiu iatən-ipɨnə kəm itəmat məmə e Iesu, Uhgɨn otos-irəkɨs nolən rat mɨn rəhatəmat. ");
INSERT INTO tnn_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kən itəmat onəkotəkəike motɨtun məmə Iesu pɨsɨn əm tɨtun nos-irəkɨsən nolən rat rəha netəm u itəm koatahatətə lan. In otɨkɨs ilat o nolən rat mɨn rəhalat. Məto suatɨp rəha nətəu-pənən Lou rəha Moses təsahmenən o nosmegəhən etəmim. ");
INSERT INTO tnn_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kən itəmat onəkotəkəike moatəto itəmat məmə nəghatən rəha ien mɨn rəha Uhgɨn otəsuwamən etəmat. ");
INSERT INTO tnn_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Kən in tatən məmə, ‘Ei, otətəlɨg-in-tu, itəmat itəm noatəghat nausit moatən rat natɨmnat rafin. Onəkotaut kən motɨmɨs, məto-inu e nian nakoatəmegəh, oekol nat kit tərat pɨk otəmat itəm okol nəsotənən nɨpahrienən lan, nat əpnapɨn okəmə suah kit otən ətuatɨp kəm itəmat.’” ");
INSERT INTO tnn_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Nian Pol ne Panapas kɨnatiaiet e niməfak, netəmim kəmotətapəh olau məmə, “Awi, okol nakuea mɨn e Sapat u tatuwa, muən-iarəp mɨn nəghatən əh neen kəm itɨmat.” ");
INSERT INTO tnn_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kən nian netəmim kəmotiet e nimə, ilat tepət kəmotətəu-pən Pol ne Panapas. Netəm əh, neen noanol mɨn rəha Isrel, kən neen netəm rəha ikɨn mɨn itəm kəmotapəs rəhalat nahatətəən moatətəu-pən nahatətəən rəha netəm Isrel. Kən ilau kəmuəghat kəm ilat matuən-ipən əskasɨk kəm ilat məmə, “Onəkotəkəike motaskəlɨm nahatətəən rəhatəmat e Uhgɨn.” ");
INSERT INTO tnn_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Kən e Sapat itəm tatuwa, iuəhkɨr netəmim rafin e taon asol əh kəmotuwa məmə okotəto nəghatən rəha Uhgɨn. ");
INSERT INTO tnn_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Kən nian netəm Isrel kəmotəplan nɨmanin netəmim kəmotuwa o nəghatən rəha Pol, kən kəmotetəhak pɨk olat, kən mɨnotətuoun moatən rat Pol ne nat naka itəm in tatən. ");
INSERT INTO tnn_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Kən Pol ne Panapas kəməsuagɨnən kəmuən məmə, “Itɨmlau oekuəike muən-iarəp nəghatən u rəha Uhgɨn kəm itəmat pitən, noanol mɨn rəha Isrel. Kən itəmat nəmotapəs nəghatən rəha Uhgɨn, kən itəmat nakoatən atɨp əm məmə itəmat nəsotahmenən o nosən nəmegəhən lilɨn. Kən roiu itɨmlau enatian məmə ekuən-iarəp namnusən təwɨr u kəm Iaihluə mɨn itəm sənəmə noanol mɨn rəha Isrel, ");
INSERT INTO tnn_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","kən inu, inu nəghatən itəm Iərəmərə təmos-ipa rəkɨs kəm itɨmlau məmə ekioal, in tatən e Naoa Rəha Uhgɨn məmə, ‘Io emol ik məmə onəkuwa ik nəhag-əhagən kit rəha Iaihluə mɨn, məmə natən-iarəp kəm netəmim rafin məmə iakolkeike məmə ekosmegəh ilat.’” ");
INSERT INTO tnn_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nian Iaihluə mɨn kəmotəto nəghatən əh, nɨkilat təmagien ron, kən mɨnoatamnus-amnus kəm ilat mɨn məmə nəghatən rəha Iesu Iərəmərə in təwɨr pɨk. Kən netəm u itəm Uhgɨn təmaun-in rəkɨs ilat məmə okotos nəmegəhən u itəm namnun tɨkə, ilat kəmotən nɨpahrienən lan. ");
INSERT INTO tnn_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kən nəghatən rəha Iərəmərə təmaiu mɨtəlau e nɨtən əh rafin e taon əh. ");
INSERT INTO tnn_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Məto noanol mɨn rəha Isrel neen kəmotuwɨn motəplan nɨpɨtan asol rəha taon əh itəm koatəfak ilat netəm Isrel, ne netəm-iasol mɨn e taon əh, motiuw-pa ilat moatol neməha kəm Pol ne Panapas. Kən kəmotəhg-iarəp ilau iməlat ikɨn. ");
INSERT INTO tnn_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Məto ilau kəmioah pɨspɨs nəptən e nelkɨlau tahmen e nəmtətin kit məmə Uhgɨn təməuhlin məntaan kəm ilat kən otol nalpɨnən kəm ilat. Kən ilau kəmiaiet mian e taon əh Ikoniam. ");
INSERT INTO tnn_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Məto netəm rəha Iesu əpəh Antiok, Narmɨn Rəha Uhgɨn tatərioah elat, kən ilat nɨkilat tətagien pɨk. ");
INSERT INTO tnn_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","E Ikoniam kəmian mɨn əpəh e nimə rəha nuəfɨmɨnən rəha netəm Isrel, kən matuən-iarəp nəghatən rəha Uhgɨn, kən nəghatən rəhalau təwɨr pɨk məmə təmiuw-pa netem Isrel tepət ne netəm Iaihluə tepət mɨn, məmə ilat kəmoatən nɨpahrienən e Iesu. ");
INSERT INTO tnn_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Məto netəm Isrel itəm kəsotənən nɨpahrienən e rəhalau nəghatən, kəmotuwɨn o Iaihluə mɨn, motol ilat kotetəhau pɨk netəm u koatən nɨpahrienən e Iesu, moatol neməha kəm ilat. ");
INSERT INTO tnn_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Məto Pol ne Panapas kəmuatɨg ikɨn tuwəh, məsuəginən ilat, kəmatuəkəike matuən-iarəp nəghatən rəha nəwɨrən rəha Uhgɨn kəm netəmim rafin. Kən Iərəmərə təmol ilau kioal nat pɨspɨs ne nəmtətin tepət məmə netəmim okotɨtun məmə rəhalau nəghatən rəha nosmegəhən in nəghatən pahrien. ");
INSERT INTO tnn_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kən netəm ikɨn əh, kəmotəhap ilat mɨn, neen kəmotətəu-pən netəm Isrel itəm kəsotənən nɨpahrienən e Iesu, kən neen kəmotətəu-pən aposol mil əh, Pol ne Panapas. ");
INSERT INTO tnn_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Kən netəm Isrel ne Iaihluə mɨn, ne netəm-iasol mɨn rəhalat mɨn, kɨnoatol nəghatən anion kit məmə okotərəkɨn ilau, kən motahtɨmnu ilau e kəpiel. ");
INSERT INTO tnn_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Məto nian kəmotəto nəghatən anion rəhalat, kəmuagɨm mian əpəh e ikɨn Likaonia, kən mian mətuatɨg e taon mil əh, Listra ne Tepe. ");
INSERT INTO tnn_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Kən e taon mil əh ne ikɨn mɨn tɨtəlau e taon mil əh, ilau katuən-iarəp namnusən təwɨr rəha Iesu Iosmegəh. ");
INSERT INTO tnn_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Kən e Listra, suah kit əh-ikɨn. Nian təmaiir məto nelkɨn təməfaiu təruru naliwəkən, tatəpələh əm, kən in tatəpələh ikɨn əh ");
INSERT INTO tnn_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","matətəlɨg-in nəghatən rəha Pol. Pol təmətag-pən ətuatɨp o suah əh, mɨnɨtun məmə suah əh tɨnatahatətə rəkɨs məmə nelkɨn tɨtun nəwɨrən, ");
INSERT INTO tnn_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","kən magət əfəməh lan məmə, “!Ei piak, ətul!” Kən əmun, suah apon təmətɨp mər kən mɨnataliwək. ");
INSERT INTO tnn_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nian nɨmanin netəmim kəmotəplan nat əh itəm Pol təmol, kəmotən əfəməh e nəghatən Likaonia məmə, “!Ei! Otəplan-tu. Uhgɨn mɨn rəhatat kɨnotol netəmim in, ilat mɨnotuwa imətat ikɨn.” ");
INSERT INTO tnn_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Kən kəmotəuhlin nərgɨ Panapas məmə Sus u nɨpətɨn təmə in iərəmərə rəha uhgɨn mɨn rəhalat. Kən kəmotəuhlin mɨn nərgɨ Pol məmə Heremes, nɨpətɨn u məmə in iəghat asol rəha uhgɨn mɨn rəhalat. ");
INSERT INTO tnn_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Nimə rəha narmɨ nat rəha uhgɨn əh Sus, in tatətul ihluə e taon əh. Kən pris rəha uhgɨn əh Sus təmasɨg kau mɨn neen itəm tɨnətu-pən rəkɨs nəguɨ-nɨg elat. Kən məmɨk ilat muwa e nafiluə rəha latuənu rəhalat itəm kəmotol əpətɨn e kəpiel. Məto in ne nɨmanin netəmim kotolkeike məmə kotol sakrifais kəm ilau motol nənwiwiən lan kəm Pol ne Panapas. ");
INSERT INTO tnn_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Məto nian aposol mil kəmuəto nəghatən e nat əh, kəmuəhap rəhalau natɨmnat. Kən kəmuaiu mian əpəh ilugɨn elat. Kən muagət əfəməh məmə, ");
INSERT INTO tnn_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“!Ei, nəman! ?Nakotəmə nəkotol nat un o naka? Itɨmlau etəmim əm tahmen etəmat. Etios namnusən təwɨr matuea kəm itəmat, kən ekioalkeike məmə ekuəuhlin nətəlɨgən rəhatəmat məmə nakotapəs nəfakən kəm uhgɨn mɨn u itəm rəhalat nəsanənən tɨkə. Məto onəkotəfak əm kəm Uhgɨn itəm tatəmegəh, mətatɨg namnun tɨkə. In pɨsɨn əm təmol neai, nəptən, nɨtəhəi, ne natɨmnat rafin itəm koatatɨg ikɨn mɨn rafin. ");
INSERT INTO tnn_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Aupən in təmegəhan-in məmə netəmim e ikɨn mɨn rafin məmə ilat okotətəu-pən atɨp əm suatɨp mɨn rəhalat. ");
INSERT INTO tnn_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Məto nian rafin in tatol suatɨp kəm ilat məmə ilat kotɨtun nəplanən rəhan nəwɨrən itəm in tatol. In tatol nuhuən tatəfɨk, matol nagwənən mɨn e nasumən, kən koatol nɨpətɨlat e nian ətuatɨp rəhalat. In tatos-ipən nagwənən kəm itəmat mol itəmat nakoatəto təwɨr.” ");
INSERT INTO tnn_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Məto kəmatuən pap nəghatən əh kəm ilat, iuəhkɨr əm kuakiə o nən-iəhauən ilat o nolən sakrifais, o nos-ipənən nənwiwiən kəm ilau. ");
INSERT INTO tnn_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Kən netəmim neen e noanol mɨn rəha netəm Isrel kəmotiet e Antiok əh Pisitia ne Ikoniam motiet-pa Listra motiuw-pa netəmim tepət məmə okotuwa kəplan ilat. Kən kəmotɨləs Pol kən motaht e kəpiel, kən motewkəkan ka kərakin-iarəp e taon motapəs tətaməhl. Nɨkilat təht məmə təmɨmɨs. ");
INSERT INTO tnn_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Məto nian netəm rəha Iesu kəmotuwa kətul kɨtəlau in, kən tətul əmun muwɨn mɨn əpəh imə e taon. Kən kəmən lawɨgin, in ne Panapas kəmiaiet mian Tepe. ");
INSERT INTO tnn_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Kən Pol ne Panapas kəmuən-iarəp namnusən təwɨr e taon əh Tepe, kən kəmiaiuw-pa netəmim tepət kotuwa o Iesu. Kən kəmiatəlɨg muea Listra, kən uarisɨg u, kiaiet mɨn muea Ikoniam, kən miaiet mɨn muea Antiok əh Pisitia. ");
INSERT INTO tnn_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Kən ikɨn əh, kəmatuem əskasɨk netəm rəha Iesu. Kən matioas-ipən nəghatən məmə okotətul əskasɨk e nahatətəən e Iesu. Kən matuən məmə, “Kitat okotatɨg e nəratən tepət nian koatuwɨn e suatɨp rəha nuwɨnən matɨg ahgin nərəmərəən rəha Uhgɨn. Məto nat əpnapɨn əm, kitat okotəkəike moatətul əskasɨk.” ");
INSERT INTO tnn_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Kən e niməfak mɨn e ikɨn mɨn rafin itəm ilau katian ikɨn, katuəmki-pər elta mɨn rəhalat. Kən matuapəs nagwənən matioal nəfakən, kən matuələhəu e nelmɨ Iərəmərə netəmim itəm kɨnoatən rəkɨs nɨpahrienən lan. ");
INSERT INTO tnn_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Kən ilau kəmian-pən Pisitia ikɨn muatite-pa Pamfilia ikɨn e taon əh Peka, ");
INSERT INTO tnn_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ikɨn əh ilau kəmuən-iarəp namnusən təwɨr ikɨn. Kən ilau kəmuatite-pa mɨn e taon kit mɨn Atalia, ");
INSERT INTO tnn_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","kən kəmios nego ikɨn miatəlɨg-pa Antiok əh Siria. Netəm Antiok əh inəh, aupən ikɨn ilat kəmotahl-ipən Pol ne Panapas məmə okian muən-iarəp nəghatən rəha Uhgɨn, kən motəfak məmə Uhgɨn otehm wɨr ilau e ikɨn mɨn itəm ilau katian ikɨn. Kən roiu kɨnioal namnun wək rəhalau. ");
INSERT INTO tnn_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Nian ilau kəmiatəlɨg-pa mɨn, kəmuaun-in netəmim rəha niməfak məmə okotuwa kitiəh. Kən ilau kəmuən-iarəp kəm ilat natɨmnat itəm Uhgɨn təmol elau e nəsanənən rəhan, kən məmə təmahro nulan Iaihluə mɨn, ilat kəmotuwa moatən nɨpahrienən e Iesu. ");
INSERT INTO tnn_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Kən ikɨn əh, ilau kəmuatɨg tuwəh ilat netəm rəha Iesu. ");
INSERT INTO tnn_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Kən netəmim neen kəmotiet əpəh Jutia motatite-pa Antiok moatəgətun piatat mɨn moatən məmə, “Okəmə kəsəhg-ipənən itəmat, tahmen e inu itəm Lou rəha Moses tatən mihin, okol Uhgɨn təsosmegəhən itəmat.” ");
INSERT INTO tnn_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Kən Pol ne Panapas ilat netəm əh koatərgəhəu o nəghatən əh, kən kəmotəghat əfəməh e nənən əh. Kən uarisɨg