﻿USE sofia;
DROP TABLE IF EXISTS sofia.tnk_vpl;
CREATE TABLE tnk_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tnk_vpl WRITE;
INSERT INTO tnk_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kwopi nəɡkiariien i rani nəɡhi kaha kupwən me səvəi Iesu Kristo. In kwənəkwus səvəi Kiɡ Tevɨt mɨne kwənəkwus səvəi Epraham. ");
INSERT INTO tnk_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Epraham in tata səvəi Aesak, Aesak in tata səvəi Jekop, Jekop in tata səvəi Juta mɨne piəvni me, ");
INSERT INTO tnk_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juta in tata səvəi Peres mɨne Sara. Mama səvənrau nə Tamar. Peres in tata səvəi Hesron, Hesron in tata səvəi Ram, ");
INSERT INTO tnk_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram in tata səvəi Aminatap, Aminatap in tata səvəi Nason, Nason in tata səvəi Salmon, ");
INSERT INTO tnk_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon in tata səvəi Poas. Mama səvəi Poas nə Rehap. Poas in tata səvəi Opet. Mama səvəi Opet nə Rut. Opet in tata səvəi Jese, ");
INSERT INTO tnk_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jese in tata səvəi Kiɡ Tevɨt. Kiɡ Tevɨt in tata səvəi Solomon. Mama səvəi Solomon nə Patsepa pran səvəi Uria kupwən. ");
INSERT INTO tnk_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon in tata səvəi Rehopoam, Rehopoam in tata səvəi Apia, Apia in tata səvəi Asa. ");
INSERT INTO tnk_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa in tata səvəi Jehosafat, Jehosafat in tata səvəi Joram, Joram i tata səvəi Usia, ");
INSERT INTO tnk_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia in tata səvəi Jotam, Jotam in tata səvəi Ahas, Ahas in tata səvəi Hesekia, ");
INSERT INTO tnk_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia in tata səvəi Manase, Manase in tata səvəi Amon, Amon in tata səvəi Josaea, ");
INSERT INTO tnk_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaea in tata səvəi Jekonaea mɨne piəvni me. Ia nəpɨn nəha kɨnərhi irapw nəkur Isrel həier mhəuvən ia tənə Papilon. ");
INSERT INTO tnk_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ia nəpɨn nəha nəkur Isrel həməier irə mhəuvən ia tənə Papilon, Jekonaea in tata səvəi Sealtiel, Sealtiel in tata səvəi Serupapel, ");
INSERT INTO tnk_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serupapel in tata səvəi Apiut, Apiut in tata səvəi Eliakim, Eliakim in tata səvəi Asop, ");
INSERT INTO tnk_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asop in tata səvəi Jatok, Jatok in tata səvəi Akim, Akim in tata səvəi Eliut, ");
INSERT INTO tnk_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut in tata səvəi Eleasar, Eleasar in tata səvəi Matan, Matan in tata səvəi Jekop, ");
INSERT INTO tnk_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop in tata səvəi Josef. Josef nə in iərman səvəi Meri. Meri nə in pran nə mama səvəi Iesu. Iesu nə kani nəɡhɨn nə Kristo. ");
INSERT INTO tnk_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ro iamɨnhi irə fwe Epraham meste pehe Kiɡ Tevɨt tata me irəha pam fotin. Fwe Kiɡ Tevɨt meste pehe kɨnərhi irapw nəkur Isrel həier mhəuvən ia tənə Papilon tata me irəha pam fotin. Fwe ia nəpɨn nəha nəkur Isrel həməier irə mhəuvən ia tənə Papilon meste pehe Kristo rətui tata me irəha pam fotin. ");
INSERT INTO tnk_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","In i nəɡkiariien sə rani Iesu Kristo mə rɨnəfo mətui. Mama səvənhi nəɡhɨn nə Meri. Fwe kupwən kəsisəɡ in mə tresi pen iərman riti nəɡhɨn nə Josef. Nəpɨn irau krouəpwəh narə pəriien ihi, Meri rətoni mə rɨno tɨpwɨn ia nəɡse Nənɨmwɨn Ikinan. ");
INSERT INTO tnk_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josef in iərmama riti sə noien səvənhi ratukwatukw, rəpwəh nokeikeiien mə Meri traurɨs ia nəmri nərmama. Ro pen nətərɨɡien səvənhi mə trəpwəh afafa a in. ");
INSERT INTO tnk_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mətə nəpɨn Josef ramətərɨɡ mə tro iamɨnhi, aɡelo riti səvəi Iərɨmənu rier pen tukwe ia nəməkrəhaien, mɨni mə, “Josef, kwənəkwus səvəi Kiɡ Tevɨt. Tikuvehi Meri mə pran səim, məpwəh nehekɨrien. Iəkunouihi nəha ia tɨpwɨn ruvehe ia nəɡse Nənɨmwɨn Ikinan. ");
INSERT INTO tnk_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Meri trərəhi tɨni iərman, tikaməkeikei mɨseɡi pen nəɡhɨn nə mə Iesu, tɨ nəri nə mə in truvehimɨru nərmama me səvənhi, muvehi raka nərəhaien me səvənraha.” ");
INSERT INTO tnk_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Narimnari me pam i həier pehe iamɨnhi mə nəɡkiariien i truvehe mukuə sə Iərɨmənu rɨməni irapw ia tərhui profet riti səvənhi fwe kupwən. ");
INSERT INTO tnk_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","In rɨməni mə, “Həreɡi ro. Prən i rɨreirei ihi iərman tro tɨpwɨn, mərəhi tɨni iərman. Nənə irəha tuhəseɡi pen nəɡhɨn nə mə Emanuel.” (Nɨpwrai nəhaɡ nəha in i mə Kumwesən ramarə tukutaha.) ");
INSERT INTO tnk_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nəpɨn Josef rətui ia napriien səvənhi, ro nəfe aɡelo nəha səvəi Iərɨmənu rɨməni pen tukwe in, muvehi Meri mə pran səvənhi, ");
INSERT INTO tnk_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","mətə rɨpkapri pəri mhə irau min meste rərəhi tɨni iərman. Nənə Josef rɨseɡi pen nəɡhɨn nə mə Iesu. ");
INSERT INTO tnk_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Nəpɨn Iesu rɨnətui raka ia rukwənu Petlehem ia tənə Jutia, ia nəpɨn nəha Kiɡ Herot ramərɨmənu, nərmama me nepwɨn səməme həukurən amasan noien səvəi kəməhau me həuku pen fwe meri rautə ikɨn, mhəuvehe ia Jerusalem, ");
INSERT INTO tnk_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","mamhəres mə, “Iəkunouihi nəha rɨpkətui a i, in kiɡ səvəi nəkur Isrel, in pəku? Kɨmaha iahənətoni kəməhau səvənhi fwe ia kwopun meri rautə ikɨn, nənə iahaməuvehe mə taheiwaiu ia nənimen, mhəuvei pen nɨsiaiien səkɨmaha min.” ");
INSERT INTO tnk_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nəpɨn Kiɡ Herot rɨreɡi nəɡkiariien nəha, in mɨne nəkur Jerusalem me pam hərkərinari mhehekɨr. ");
INSERT INTO tnk_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nənə Kiɡ Herot rəkwein pris asori me mɨne nahatən me səməme kamhahatən nəkur Isrel ia Loa səvəi Moses, nənə məres pen irəha i mə, “Iəmə nə kani mə Kristo trətui pəku?” ");
INSERT INTO tnk_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Mɨreɡi irəha həni pen tukwe in mə, “Ia rukwənu Petlehem ia tənə Jutia. Kɨmaha iahəukurən mə tro iamɨnhi irə tɨ nəri nə mə profet riti fwe kupwən rɨmərai nəɡkiariien i mə: ");
INSERT INTO tnk_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Mətə ik Petlehem ia tənə Jutia rɨpko mhə ik rukwənu auər a ia rukwənu asori me ia tənə Jutia. Iərman riti truku pen ia niram, mərɨmənu ia nərmama. In trətui amasan tɨ sipsip me səiou nəkur Isrel.’” ");
INSERT INTO tnk_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ia nəpɨn nəha Kiɡ Herot rəkwein afafa nəmə me nəha həukurən amasan noien səvəi kəməhau me həuvehe. Rəres pen irəha i nəfe nəpɨn atukwatukw hənətoni kəməhau nəha rutə vi a irə. ");
INSERT INTO tnk_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nəpɨn həni pam, in rərhi pen irəha, mɨni mə, “Kɨmiaha tihəuvən fwe Petlehem, mhətui amasan ro iəkunouihi nəha mə in pəku. Nəpɨn hiətoni, tihəuvehe mhəni sas pehe tukw iou i, pwəh iou mwi iakevən meiwaiu ia nənimen, muvei pen nɨsiaiien səiou min.” ");
INSERT INTO tnk_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nəmə me nəha hətərɨɡ pam nəɡkiariien səvəi Kiɡ Herot, nənə mhəier. Ia suatuk hətoni kəməhau nəha hənətoni nəpɨn rautə vi a fwe ia kwopun meri rautə ikɨn rakupwən ia nirəha, mamevən meste rərer atukwatukw məhiəpwɨn kwopun nəha iəkunouihi ramarə ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nəpɨn irəha hətoni kəməhau nəha, rerɨnraha raɡien, haɡien pɨk. ");
INSERT INTO tnk_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nənə həuvnimwə ia nəkwai nimwə nəha, mhətoni iəkunouihi nəha irau mama səvənhi Meri, mhənɨmwi nukurhunraha, mhəuvei pen nɨsiaiien səvənraha min. Ia nəpɨn nəha həsevər ia tənərɨpw me səvənraha, mhəuvei pen nari amasan me min. Həuvei pen kol mɨne nɨse nei mi nə kani mə fraɡkinsens mɨne mɨr. ");
INSERT INTO tnk_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nənə ia nəpɨn irə, Kumwesən rɨnise irəha ia nəməkrəhaien mə tuhəpwəh nɨrərɨɡien mhəuvən tɨ Kiɡ Herot. Ro pen irəha həier, mamhesi pen suatuk əpə, mamhəuvən fwe imwənraha. ");
INSERT INTO tnk_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nənə nəpɨn nəmə me nəha həukurən amasan noien səvəi kəməhau me həuvəier raka, aɡelo riti səvəi Iərɨmənu rier pen tɨ Josef ia nəməkrəhaien, mɨni mə, “Əskəmter, mərəhi iəkunouihi i irau mama səvənhi, mharap, mharevən fwe ia tənə Ijip, mamhararə fwe ikɨn meste iou takɨni mə tiharrərɨɡ. Rɨpko mhə tui Kiɡ Herot trətui iəkunouihi i mə trousi əpune.” ");
INSERT INTO tnk_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ro iamɨnhi irə Josef rɨskəmter ia nəpɨn, mərəhi iəkunouihi i irau mama səvəi iəkunouihi, mharevən fwe ia Ijip. ");
INSERT INTO tnk_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nənə irəhar hararə fwe ikɨn meste Kiɡ Herot remhə. Nəri nəha rier pehe iamɨnhi mə nəɡkiariien i truvehe mukuə sə Iərɨmənu rɨməni irapw ia tərhui profet riti səvənhi fwe kupwən. In rɨməni mə, “Iakəkwein nərɨk rier ia tənə Ijip muvehe.” ");
INSERT INTO tnk_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nəpɨn Kiɡ Herot rətoni mə nəmə me nəha həukurən amasan noien səvəi kəməhau me həneikuə irə, niemaha rəpi pɨk in. In rərhi pen naruaɡən me səvənhi həuvən mhousi əpune nɨpwnəti nərman me pam fwe ia Petlehem mɨne ia kwopun me ipaka səməme nuk səvənraha kəru meiwaiu. In ramesi pen a nəpɨn atukwatukw kəməhau nəha rutə vi a irə rəmwhen nəmə me nəha həukurən amasan noien səvəi kəməhau me həməni pen tukwe in. ");
INSERT INTO tnk_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Narimnari me nəha ro nəɡkiariien i Profet Jeremaea rɨməni ruvəuvehe muvəukuə: ");
INSERT INTO tnk_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Kamreɡi pran riti fwe ia Rama ramasək maməkwein əpwəmwɨs. Rejel nə ramasək tɨ nɨpwnətɨn me, nənə mɨpkokeikei mhə mə iərmama riti trəɡkiari vivi min, tɨ nəri nə mə nɨpwnətɨn me həuvəiwən.” ");
INSERT INTO tnk_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nəpɨn Kiɡ Herot remhə, Josef in fwe Ijip, nənə aɡelo riti səvəi Iərɨmənu rier pen tukwe in ia nəməkrəhaien, ");
INSERT INTO tnk_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","mɨni mə, “Əskəmter, mərəhi iəkunouihi i mɨne mama səvənhi mharevən fwe ia tənə Isrel. Nərmama me nəha kənamhətui iəkunouihi i mə tuhousi əpune həuvamhə.” ");
INSERT INTO tnk_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ro iamɨnhi irə Josef rɨskəmter irau mama səvəi iəkunouihi, mharevən fwe ia tənə Isrel. ");
INSERT INTO tnk_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mətə nəpɨn Josef rɨreɡi mə Akeleas ruvehi təmwki tata səvənhi Herot, mamərɨmənu ia tənə Jutia, in rehekɨr nevənien fwe ikɨn. Nənə tɨ nəri nə mə Kumwesən rɨnise mwi in ia nəməkrəhaien mə trəpwəh nevənien fwe ikɨn, in rier mevən fwe ia tənə Kalili. ");
INSERT INTO tnk_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ia kwopun nəha revən mamarə ia taon riti kani mə Nasaret. Nəri nəha rier pehe iamɨnhi mo nəɡkiariien i profet me həməni fwe kupwən ruvəuvehe muvəukuə. Irəha həɡkiari ia Kristo, mhəni mə, “Tukəkwein in mə iəmə Nasaret.” ");
INSERT INTO tnk_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nuk me nepwɨn ruvehe mukurau, nənə Jon Paptaes ruvehe ia kwopun akwesakwes ikɨn fwe ia tənə Jutia, maməvisau m nərmama mə, ");
INSERT INTO tnk_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Kɨmiaha tihaməkeikei mhərərɨɡ ia noien ərəha me səkɨmiaha tɨ nəri nə mə nɨtətə ia neiai ruvəuvehe ipaka.” ");
INSERT INTO tnk_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon nəha in iəmə Profet Aesea rəɡkiari irə fwe kupwən nəpɨn rɨni mə, “Reri iərmama riti raməkwein əpwəmwɨs ia kwopun akwesakwes ikɨn, mamɨni mə, ‘Kɨmiaha tihaməkeikei mhəpərhi suatuk səvəi Iərɨmənu səkɨtaha, mhəmri atukwatukw suatuk ouihi me səvənhi.’” ");
INSERT INTO tnk_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon ramarkahu ia tɨnari kɨno ia nɨmwheri kamel, mamətoti ia teki nərimɨru, maməni kinhə mɨne kwənipwət ia sukapak. ");
INSERT INTO tnk_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nərmama me həpɨk həier ia Jerusalem mɨne kwopun me ia tənə Jutia mɨne kwopun me ipaka tɨ nui arɨs Jotan, mamhəuvən tɨ Jon, ");
INSERT INTO tnk_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","mamhəni irapw noien ərəha me səvənraha, nənə in ramo paptaes ia nirəha ia nui arɨs Jotan. ");
INSERT INTO tnk_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mətə nəpɨn Jon rətoni Farisi me mɨne Satusi me həpɨk kamhəuvehe mə in tro paptaes ia nirəha, in rɨni pen tɨ nirəha i mə, “Kɨmiaha hiəmwhen ia snek me kamhahi əpune nərmama. Kumwesən niemaha rəpi. Rɨpko mhə tui in trərpwɨn noien ərəha me səkɨmiaha. Sin rɨni pehe tukumiaha i mə tihap raka irə? ");
INSERT INTO tnk_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kɨmiaha tihaməkeikei mho noien amasan me trahatən pen mə hiənəpwəh pərhien noien ərəha me səkɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Rərəha tihəni pen tukumiaha me i mə Epraham in kaha səkɨmiaha. Iakani pehe tukumiaha i mə Kumwesən rukurən nuvehiien kəruəterei me i, mo nɨpwnəti Epraham me ia nirəha. ");
INSERT INTO tnk_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","In rɨnərpwi pen raka paha səvənhi ia nuai nei me na trərai. Nei me pam səməme həpkukuə mhə nukwai nei amasan in trərai əmwesi, mousə pen irəha ia napw. ");
INSERT INTO tnk_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Iou iakamo paptaes ia kɨmiaha ia nui tɨ nəri nə mə hiənəpwəh noien ərəha me səkɨmiaha. Mətə iərmama nəha rauvehe kurirə ia nirak nɨskaiien səvənhi rasori məpi raka iou. Iou iapkəmwhen mhə mə takuvehi raka put səvənhi. In tro paptaes ia kɨmiaha ia Nənɨmwɨn Ikinan mɨne ia napw. ");
INSERT INTO tnk_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Fok səvənhi, in rarukwi utə nuni nari me irə, rɨnəmak raka ia rəɡɨn. Na trɨrukwi utə nuni nari me səvənhi irə tɨ nuaiien nunɨn mɨne tekɨn. Nuni nari me sə ramasan in trɨpeki pen irəha ia nimwə səvənhi sə ramoeite nəveɡɨnien ikɨn, mətə tekɨn sə rərəha in trɨhiai pen napw irə, napw sə trɨpkɨfwə mhə.” ");
INSERT INTO tnk_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ia nəpɨn nəha Iesu ruku pen ia tənə Kalili, muvehe ia nui arɨs Jotan mə Jon tro paptaes irə. ");
INSERT INTO tnk_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Mətə Jon raməmwur mamɨnise in, mamɨni mɨnuə, “Kwa ik i tiko paptaes ia nirak. Rəfo ikuvehe tukw iou mə tako paptaes ia niram?” ");
INSERT INTO tnk_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mətə Iesu rɨni pen tukwe in mə, “Rekəm. Tikaməkeikei mo paptaes ia nirak təkwtəkwuni. Ratukwatukw tɨ nəri nə mə ia noien nəha krau trauo narimnari me pam sə Kumwesən rokeikei həuvehe mhəukuə.” Ro pen Jon rəseni, mo paptaes irə. ");
INSERT INTO tnk_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nəpɨn Jon rɨno raka paptaes ia Iesu, Iesu rutə pehe ia nui, təkwtəkwuni a kəpuapen rəkwaɡ tukwe, in rətoni Nənɨmwɨn səvəi Kumwesən rameiwaiu pehe rosi mak inhərɨpw, muvehe məkure irə. ");
INSERT INTO tnk_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nənə reri Kumwesən ruku pen ia neiai, mɨni mə, “In i nərɨk keikei. Rerɨk raɡien tukwe.” ");
INSERT INTO tnk_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nənə Nənɨmwɨn Ikinan riri pen Iesu revən ia kwopun akwesakwes ikɨn. Ia kwopun nəha Setan raməmwur mə tro Iesu rɨmwei ia nərəhaien. ");
INSERT INTO tnk_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Iesu rɨpkəni mhə nari meste pen nəpɨn foti ia nəpɨn mɨne ia ran. Kurirə ikɨn nukumhə rɨnahi pɨk in. ");
INSERT INTO tnk_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nənə Setan sə raməmwur mə tro nərmama həmwei ia nərəhaien, ruvehe, mɨni pen tɨ Iesu i mə, “Trɨni mɨnuə ik Tɨni Kumwesən pərhien, ni pen tɨ kəruəterei me i mə tuhəuvehe mho nəveɡɨnien ia nirəha.” ");
INSERT INTO tnk_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mətə Iesu rɨni mə, “Kɨmərai pen ia Nəkukuə Ikinan mə, ‘Iərmama trɨpkɨmɨru mhə ia nəveɡɨnien əpa, mətə trɨmɨru ia nəɡkiariien pam sə raku pen ia tərhui Kumwesən.’” ");
INSERT INTO tnk_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nənə Setan ruvehi Iesu, mevən fwe ia taon ikinan nəha Jerusalem, mukurei pen in ia kwopun riti irənhə anan ia təkure nimwə səvəi Kumwesən, ");
INSERT INTO tnk_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","nənə mɨni pen tukwe in mə, “Trɨni mɨnuə ik Tɨni Kumwesən pərhien, ivə irapw. Kɨmərai pen ia Nəkukuə Ikinan mə, ‘Kumwesən trɨni pen tɨ naɡelo me səvənhi mə irəha tuhaməkeikei mhətui amasan tukw ik, mhəuvehi utə ik ia rəɡɨnraha, kamo ikouini nɨsum ia kəruəterei riti.’” ");
INSERT INTO tnk_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Mɨreɡi Iesu rɨni pen tukwe in mə, “Mətə kɨmərai pen mwi ia Nəkukuə Ikinan mə, ‘Tikəpwəh neipweipwiien Iərɨmənu Kumwesən səim.’” ");
INSERT INTO tnk_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nənə Setan ruvehi mwi in muvehi mevən fwe ia təkuər riti sə rəpwəmwɨs anan, mahatən irapw nɨtətə me pam kiɡ me ia tɨprənə i kamhərɨmənu ia nirəha, mahatən irapw mwi nautə amasan me pam ia nɨtətə me nəha, ");
INSERT INTO tnk_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","mɨni pen tɨ Iesu i mə, “Narimnari me pam nəha takuvei pehe mik trɨni mɨnuə ikɨsiai iou, mɨnɨmwi nukurhum mi ia nənimek.” ");
INSERT INTO tnk_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Mətə Iesu rɨni pen tukwe in mə, “Evən isipwɨn, Setan! Kɨmərai pen ia Nəkukuə Ikinan mə, ‘Tikɨnɨmwi nukurhum mi ia nəmri Iərɨmənu Kumwesən səim, mɨsiai in. In əpa nə tiko nəkwan.’” ");
INSERT INTO tnk_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ia nəpɨn nəha Setan rəpwəh Iesu mamevən. Nənə Iesu rətoni naɡelo me həuvehe, mamho tukwini nari min. ");
INSERT INTO tnk_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ia nəpɨn nəha kəkwtəmhiri Jon Paptaes kuvehi puvnimwə in ia kalapus. Nəpɨn Iesu rɨreɡi, in rəpwəh kwopun nəha, mɨrərɨɡ mevən ia tənə Kalili, ");
INSERT INTO tnk_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","nənə mier ia taon nəha Nasaret, mevən mamarə ia Kapaneam. Kapaneam in taon riti ipaka tɨ nui asori Kalili fwe ia tɨprənə səvəi Sepulun mɨne Naftali. ");
INSERT INTO tnk_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nəri nəha rier pehe iamɨnhi mə nəɡkiariien səvəi Profet Aesea truvehe mukuə. In rɨməni mə, ");
INSERT INTO tnk_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Tənə səvəi Sepulun mɨne tənə səvəi Naftali, ipaka tɨ nui asori Kalili fwe ia nɨkare nui arɨs Jotan pen, in i tənə Kalili kwopun nərmama rɨpko mhə irəha nəkur Isrel kamharə ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nərmama səməme kamharə ia nəpitəvien tuhətoni nukuraanien asori riti. Nərmama səməme kamharə ia təmwkəmwi nemhəien nukuraanien riti trutə məhiəpwɨn irəha.” ");
INSERT INTO tnk_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ia nəpɨn nəha Iesu rɨnaməvisau, mɨnamɨni mə, “Kɨmiaha tihaməkeikei mhərərɨɡ ia noien ərəha me səkɨmiaha tɨ nəri nə mə nɨtətə ia neiai ruvəuvehe ipaka.” ");
INSERT INTO tnk_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Nəpɨn Iesu ramavən ia nɨkare nui asori Kalili, in rətoni iərmama kəru, Saemon (iəmə kani mwi nəɡhɨn mə Pita) mɨne piəvni nəɡhɨn nə Antru. Krauerukw net ia nui tɨ nəri nə mə irau iərmama mi kravi nəmu. ");
INSERT INTO tnk_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Iesu rɨni pen tɨ nirau i mə, “Rouvehe roukurirə iou. Pwəh iou tako kɨmirau iərmama mi sə kravi nərmama.” ");
INSERT INTO tnk_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Təkwtəkwuni a krouəpwəh net me səvənrau roukurirə in. ");
INSERT INTO tnk_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kurirə ikɨn Iesu ravən ouihi a mwi, mətoni iərmama kəru mwi, Jemes mɨne piəvni nəɡhɨn nə Jon. Irau tɨni Sepeti mi. Krauəkure ia nəkwai nɨtətə ouihi riti irəhar tata səvənrau kamharɨtiri net me səvənrahar. Iesu rəkwein irau, ");
INSERT INTO tnk_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","nənə təkwtəkwuni a krouəpwəh nɨtətə ouihi mɨne tata səvənrau, rouevən roukurirə in. ");
INSERT INTO tnk_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iesu revən ia kwopun me pam ia tənə Kalili, mamahatən nərmama ia nəkwai nimwəfwaki me səvəi nəkur Isrel, maməvisau irapw nəɡkiariien amasan ia nɨtətə sə Kumwesən ramərɨmənu irə, mamomasan nərmama me pam səməme kamhemhə ia nemhəien me səpəmsəpə mɨne səməme nemhəien rouraha nɨpəri nɨpwranraha. ");
INSERT INTO tnk_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ro pen nərmama kamhəni pɨk nəɡhi Iesu. Nəɡkiariien səvənraha rauvirɨs mamevən ia kwopun me pam ia tənə Siria. Nənə irəha həuvehi nərmama me pam səməme kamhemhə, mhəuvehi mhəuvehe tukwe. Irəha kamhemhə ia nemhəien me səpəmsəpə. Nepwɨn nɨpwranraha raməmisə. Nepwɨn nəremhə me kamharə ia nirəha. Nepwɨn nemhəien nəha nɨkəvan ramo irəha. Nepwɨn nɨpəri nɨpwranraha remhə. Nənə Iesu ro irəha həuvehe mhəsanɨn. ");
INSERT INTO tnk_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nənə nərmama həpɨk kamhəkurirə ia Iesu. Nepwɨn həuku pen ia tənə Kalili, nepwɨn həuku pen fwe Tekapolis, kwopun taon ten ikɨn, nepwɨn həuku pen ia Jerusalem mɨne tənə Jutia. Nənə nepwɨn həuku pen ia nɨkare nui arɨs Jotan pen mwi. ");
INSERT INTO tnk_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nəpɨn Iesu rətoni nərmama me həuvəpɨk, rutə ia təkuər riti məkure. Nərmama me səvənhi həuvehe tukwe, ");
INSERT INTO tnk_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","nənə in rɨnamahatən irəha, mɨnamɨni mə, ");
INSERT INTO tnk_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Nərmama səməme hətə sas ia rerɨnraha mə irəha həmwhen ia nərmama nautə səvənraha riwən, rerɨnraha traɡien, tɨ nəri nə mə nɨtətə ia neiai səvənraha. ");
INSERT INTO tnk_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nərmama səməme kamhəreɡi rərəha mamhasək, rerɨnraha traɡien, tɨ nəri nə mə Kumwesən truvehi utə nətərɨɡien səvənraha. ");
INSERT INTO tnk_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nərmama səməme həpkəfiəutə mhə ia nirəha, rerɨnraha traɡien, tɨ nəri nə mə Kumwesən truvei pen tɨprənə i mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nərmama səməme hokeikei pɨk mə tuhətoni noien atukwatukw, mamhəreɡi nokeikeiien nəha rəmwhen ia iərmama nukumhə ramahi, maməkwakwa, rerɨnraha traɡien, tɨ nəri nə mə Kumwesən tro irəha həreɡi həkuvəutə. ");
INSERT INTO tnk_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nərmama səməme kamhapi tɨ nərmama, rerɨnraha traɡien, tɨ nəri nə mə Kumwesən trapi mwi tɨ nirəha. ");
INSERT INTO tnk_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nərmama səməme nətərɨɡien səvənraha rəmher, rerɨnraha traɡien, tɨ nəri nə mə irəha tuhətə Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nərmama səməme kamhəmri nəmərinuien, rerɨnraha traɡien, tɨ nəri nə mə tukɨni irəha mə nɨpwnəti Kumwesən me. ");
INSERT INTO tnk_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nərmama səməme kamometə irəha tɨ nəri nə mə kamho noien atukwatukw, rerɨnraha traɡien, tɨ nəri nə mə nɨtətə ia neiai səvənraha. ");
INSERT INTO tnk_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kɨmiaha i rerɨmiaha traɡien nəpɨn nərmama tuharɨs əkenhɨn ia kɨmiaha, mhometə kɨmiaha, mhəni nəɡkiariien ərəha me səpəmsəpə mɨne neikuəien me, mhousi kɨmiaha irə tɨ nəri nə mə kɨmiaha nərmama me səiou. ");
INSERT INTO tnk_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kɨmiaha tihaməkeikei mhəreɡi ramasan, mhaɡien pɨk, tɨ nəri nə mə nərəkuien səkɨmiaha rasori fwe ia neiai. Kɨmiaha hiəukurən mə nərmama me hənometə profet kupwən me ia noien a mwi nəha.” ");
INSERT INTO tnk_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Kɨmiaha nə hiəmwhen ia sol ia tɨprənə i. Mətə trɨni mɨnuə sol nəsienien səvənhi ruvəiwən, tukəfo mwi rəsien mwi? Sol nə rɨpkəmwhen mhə mə tuko nari amasan riti mwi irə. Ramasan mə tukərarki a i, nənə nərmama tuhavən irə. ");
INSERT INTO tnk_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Kɨmiaha nə hiəmwhen ia nukuraanien ia tɨprənə i. Taon riti fwe ia təkure təkuər ko rɨpkərkwafə mhə. ");
INSERT INTO tnk_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nərmama me həpkɨhiai pen mhə napw ia laet mhəuiui ia nari riti, mətə irəha tuhaməkeikei mhəkurei utə i ia nəri kakurei utə laet irə mə nərmama ia nəkwai nimwə tuhətoni raməhiapw. ");
INSERT INTO tnk_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Rəmwhen a mwi ia kɨmiaha tihaməkeikei mho laet səkɨmiaha ruək asori ia nəmri nərmama pwəh hətoni noien amasan me səkɨmiaha nənə mhəɡnəɡɨni Tata səkɨmiaha fwe ia neiai.” ");
INSERT INTO tnk_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Rerɨmiaha trəpwəh nɨrhiien mə iakuvehe mə takərarki Loa səvəi Moses mɨne nəɡkiariien səvəi profet kupwən me. Iapkuvehe mhə mə takərarki nəɡkiariien me səvənraha, mətə iakuvehe mə tako nəɡkiariien me səvənraha həuvehe mhəukuə. ");
INSERT INTO tnk_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Iakani nɨpərhienien tukumiaha i mə loa nəha trɨpkiwən mhə meste tɨprənə mɨne neiai trouiwən. Nəɡkiariien kwakwa uə nɨpəri nəɡkiariien kwakwa kɨmərai pen ia loa nəha trɨpkiwən mhə meste narimnari me pam tuhəier irapw. ");
INSERT INTO tnk_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ro pen iərmama sə trərui loa riti rouihi ia loa me i, mamahatən nərmama me mə tuho mwi iamɨnhi, tukəkwein in mə iəmə auər a ia nɨtətə ia neiai. Mətə iərmama sə tresi pen loa me i, mamahatən nərmama me irə, tukəkwein in mə iəmə asori ia nɨtətə ia neiai. ");
INSERT INTO tnk_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Iou iakani pehe tukumiaha i mə noien səkɨmiaha traməkeikei matukwatukw məpi raka noien səvəi nahatən me səvəi Loa mɨne noien səvəi Farisi me. Mə rekəm, kɨmiaha tihəpwəh nuvnimwəien ia nɨtətə ia neiai ia nəpɨn riti.” ");
INSERT INTO tnk_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Kɨmiaha hiəuvəreɡi raka kɨməni pen tɨ kaha kupwən me səkɨtaha mə, ‘Tikəpwəh nousi əpuneien iərmama. Trɨni mɨnuə iərmama riti rousi əpune iərmama riti ratukwatukw mə tuko nərpwɨnien min.’ ");
INSERT INTO tnk_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mətə iou iakani pehe tukumiaha i iərmama sə ramo niemaha m piəvni, ratukwatukw mə tuko nərpwɨnien min. Iərmama sə trɨni pen tɨ piəvni mə, ‘Ikamarməri,’ ratukwatukw mə tukuvi irapw in ia nəmri nəmə asori me. Iərmama sə trəskiari ərəha anan ia piəvni, ratukwatukw mə trevən ia kwopun napw asori rauək ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ro pen trɨni mɨnuə ikamərer pen ia nɨfatə səvəi Kumwesən mə tikuvei pen nari riti min, nənə ia kwopun nəha rerɨm rɨrhi mə piam niemaha raməpi in tɨ nari riti ikɨno min, ");
INSERT INTO tnk_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tikəpwəh nəri nəha ikuə tikuvei pen m Kumwesən pwəh raməmak ia nɨkare nɨfatə, nənə mevən. Tikaməkeikei mukupwən mevən tɨ piam rouamasan kɨmirau min, nənə kurirə ikrərɨɡ, muvei pen narimnari me səim ia təkure nɨfatə ramevən tɨ Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Trɨni mɨnuə iko noien ərəha riti ia iərmama, nənə in rokeikei mə kɨmirau min tirouərer ia nəmri nəmə asori me pwəh həkiri noien səim, ramasan mə tikevən akwauakw, rouəmri atukwatukw nəri nəha nəpɨn kɨmirau irauesi pen ihi suatuk rauevən ia kwopun kaməkiri nəɡkiariien ikɨn. Rərəha mə iərmama nəha ikɨno noien ərəha irə trəmri pen ik ia rəɡi iəmə asori sə raməkiri nəɡkiariien, nənə iəmə asori sə raməkiri nəɡkiariien trəmri pen ik ia rəɡi polis, nənə tukuvehi puvnimwə ik ia kalapus. ");
INSERT INTO tnk_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Iakani nɨpərhienien tukw ik i mə tikəpwəh nierien ia kalapus meste ikərəku pen pam faen me səim.” ");
INSERT INTO tnk_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Kɨmiaha hiəuvəreɡi raka kɨməni mə, ‘Tikəpwəh nakresien pran səvəi iərməpə.’ ");
INSERT INTO tnk_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mətə iou iakani pehe tukumiaha i trɨni mɨnuə iərman riti rətoni pran riti, nənə rerɨn rakres i, iəmə nəha rɨnərui raka nəɡkiariien nəha ia rerɨn. ");
INSERT INTO tnk_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Trɨni mɨnuə nənimem mwatuk ramo ik ikamwei ia nərəhaien, tikukumwiri raka, mərarki. Nənimem nɨpəri nɨpwram a. Trɨni mɨnuə ikouraha nɨpəri nɨpwram ramasan pɨk məpi raka mə tukərarki pen nɨpwram me pam ia kwopun napw asori rauək ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nənə trɨni mɨnuə rəɡɨm mwatuk ramo ik ikamwei ia nərəhaien, tikərai raka, mərarki. Rəɡɨm nɨpəri nɨpwram a. Trɨni mɨnuə ikouraha nɨpəri nɨpwram ramasan pɨk məpi raka mə tukərarki pen nɨpwram me pam ia kwopun napw asori rauək ikɨn.” ");
INSERT INTO tnk_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Nəɡkiariien riti mwi kɨməni fwe kupwən in i mə, ‘Iərman sə rokeikei mə trəpwəh pran səvənhi pwəh ruvei pen nɨmwai nəkukuə riti m pran səvənhi rani mə in rɨnəpwəh in.’ ");
INSERT INTO tnk_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mətə iou iakani pehe tukumiaha i trɨni mɨnuə iərman riti rəpwəh pran səvənhi, pran sə rɨpko əpnapen mhə nari irau iərməpə, ramouraha səvənhi pran, mamo in revən mamətui iərməpə riti mə triri in. Trɨni mɨnuə prən nəha resi pen iərməpə riti iamɨnhi, in ramo noien ərəha. Iərman nəha in ramesi pen rɨpko mhə iərman atukwatukw səvənhi. Nənə iərman sə ramiri pran sə iərman səvənhi rɨnəpwəh in ramo noien ərəha. Prən nəha in ramiri səvəi iərməpə.” ");
INSERT INTO tnk_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Nəɡkiariien riti mwi kɨmiaha hiəuvəreɡi raka kɨməni pen tɨ kaha kupwən me in i mə, ‘Tikəpwəh nuvehiien kwəsuahi ia nəmri Iərɨmənu meikuə irə, mətə tikaməkeikei mo nəfe ikɨməuvehi kwəsuahi mɨni mə tiko.’ ");
INSERT INTO tnk_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Mətə iou iakani pehe tukumiaha i mə tihəpwəh nuvehiien kwəsuahi iamɨnhi. Tikəpwəh nahatən penien neiai uə tɨprənə uə Jerusalem muvehi kwəsuahi ia nirəhar, tɨ nəri nə mə neiai in nə kwopun Kumwesən raməkure ikɨn mamərɨmənu, tɨprənə in nə nəri Kumwesən ramərpwi utə tɨpaɡe nɨsun mi irə, nənə Jerusalem in nə taon səvənhi, in Iərɨmənu Asori. ");
INSERT INTO tnk_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tikəpwəh nahatən penien kəmkapwə, muvehi kwəsuahi irə, tɨ nəri nə mə ko ipko mhə nɨmwai nukwənem riti ruvehe məpsan uə ruvehe mɨpitəv. ");
INSERT INTO tnk_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mətə nəɡkiariien səim pwəh ro iamɨnhi. Tikɨni a ‘Ouəh’ uə ‘Rekəm.’ Nəɡkiariien sə rəpi raka nəɡkiariien mi nəha ruku pen tɨ Setan.” ");
INSERT INTO tnk_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Kɨmiaha hiəuvəreɡi raka kɨməni mə, ‘Trɨni mɨnuə iərmama rouraha nənimek riti tukaməkeikei kouraha mwi nənimen riti. Trɨni mɨnuə iərmama rouraha revɨk riti tukaməkeikei kouraha mwi revɨn riti.’ ");
INSERT INTO tnk_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mətə iou iakani pehe tukumiaha i mə tihəpwəh nəvisəien kɨmiaha iərmama rərəha, mhəpwəh nərpwɨnien tai noien ərəha səvənhi iamɨnhi. Trɨni mɨnuə iərmama riti rəpwi nɨkare nɨkapwɨm mwatuk, ikuvei pen mwi nɨkaren mour min. ");
INSERT INTO tnk_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Trɨni mɨnuə iərmama riti ruvi irapw ik ia nəɡkiariien asori mə truvei raka səim karkahu, ikuvei pen mwi səim kot min. ");
INSERT INTO tnk_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Trɨni mɨnuə iərmama riti raməkeikei mik mə tikəvrani narimnari me səvənhi mavən kilometa kuatia, ikavən kilometa kəru kɨmirau min. ");
INSERT INTO tnk_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Trɨni mɨnuə iərmama riti rəres ik nari riti, ikuvei pen min. Tikəpwəh nɨniseien iərmama sə rokeikei mə truvehi ouihi a səim narimnari me.” ");
INSERT INTO tnk_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Kɨmiaha hiəuvəreɡi raka kɨməni mə, ‘Tikaməkeikei mokeikei piam nənə məmwəki iərmama sə raməmwəki ik.’ ");
INSERT INTO tnk_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mətə iou iakani pehe tukumiaha i mə kɨmiaha tihaməkeikei mhokeikei nərmama səməme haməmwəki kɨmiaha, nənə mhəfwaki tɨ nərmama səməme kamhometə kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Noien nəha trahatən pen mə Tata səkɨmiaha fwe ia neiai nɨpwnətɨn me nə kɨmiaha, tɨ nəri nə mə in ramo meri səvənhi rautə nukwəsikər raməhiəpwɨn nərmama ərəha me mɨne nərmama amasan me. In ramərhi irapw mwi nesən raməfwi nərmama atukwatukw mɨne nərmama həpkatukwatukw mhə. ");
INSERT INTO tnk_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kɨmiaha hiaməfətərɨɡ irə? Trɨni mɨnuə kɨmiaha hiokeikei a nərmama səməme hokeikei kɨmiaha, Kumwesən trəɡnəɡɨni kɨmiaha tɨ nəfe? Nərmama kamərəku pen takis minraha irəha mwi kamho noien nəha! ");
INSERT INTO tnk_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nənə trɨni mɨnuə kɨmiaha hiaməɡkiari pen m piəvmiaha me a, nəfe noien amasan hiamo mhəpi raka nərmama me nepwɨn? Nərmama me səməme həreirei Kumwesən irəha mwi kamho noien nəha! ");
INSERT INTO tnk_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ro pen kɨmiaha tihaməkeikei mhatukwatukw rəmwhen ia Tata səkɨmiaha fwe ia neiai in ratukwatukw.” ");
INSERT INTO tnk_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Kɨmiaha tihaməsiari nəpɨn hiamo noien atukwatukw me səkɨmiaha, mhəpwəh noien ia nəmri nərmama me mə irəha tuhətoni. Trɨni mɨnuə hiamo iamɨnhi irə, nərəkuien səkɨmiaha sə truku pen tɨ Tata səkɨmiaha fwe ia neiai triwən. ");
INSERT INTO tnk_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Nəpɨn ikuə tikuvei pen nari riti mə trasitu ia nərmama nautə səvənraha riwən, ikəpwəh nukupwənien məse kisɨpw rəmwhen kəuətkəsuə me kamho ia nəkwai nimwəfwaki me səvəi nəkur Isrel mɨne ia suatuk me mə nərmama tuhətoni mhəɡnəɡɨni irəha. Iakani nɨpərhienien tukumiaha i nərmama me nəha həuvəuvehi raka nərəkuien səvənraha. ");
INSERT INTO tnk_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mətə nəpɨn tikuvei pen nari riti mə trasitu ia nərmama nautə səvənraha riwən, ikəpwəh nəseniien rəɡɨm mour rukurən nəfe rəɡɨm mwatuk ramo. ");
INSERT INTO tnk_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ro iamɨnhi irə tiko afafa nəriariien səim, nənə səim Tata sə ramətə narimnari me kamo afafa truvei pehe nərəkuien mik.” ");
INSERT INTO tnk_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Nənə nəpɨn kɨmiaha tihəfwaki, hiəpwəh noien rəmwhen ia kəuətkəsuə me kamho. Irəha kamhərer ia nəkwai nimwəfwaki me səvəi nəkur Isrel mɨne ia kwopun me suatuk me həuvehe mamhəvsiek ikɨn, mamhəfwaki mə nərmama tuhətoni irəha. Irəha hokeikei pɨk noien nəha, mətə iakani nɨpərhienien tukumiaha i mə nərmama me nəha həuvəuvehi raka nərəkuien səvənraha. ");
INSERT INTO tnk_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mətə nəpɨn tikəfwaki, ikevən ia nəkwai rum səim mərəpinhə, məfwaki m Tata səim sə nərmama həpkətoni mhə. Nənə Tata səim sə ramətə narimnari me kamo afafa truvei pehe nərəkuien mik. ");
INSERT INTO tnk_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nənə nəpɨn kɨmiaha tihəfwaki, hiəpwəh nɨniien nəɡkiariien me rɨpɨk rəmwhen ia nərmama səməme həreirei Kumwesən kamho. Irəha rerɨnraha rɨrhi mə kumwesən me səvənraha tuhəreɡi irəha tɨ nəri nə mə kamhəni nəɡkiariien me rɨpɨk. ");
INSERT INTO tnk_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kɨmiaha tihəpwəh noien rəmwhen ia nirəha tɨ nəri nə mə nəpɨn kɨmiaha hiəpkəres mhə ihi Tata səkɨmiaha, in ruvəukurən raka narimnari me sə həiwən təni kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ro pen kɨmiaha tihaməkeikei mhəfwaki iamɨnhi irə: ‘Tata səkɨmaha ia neiai, Pwəh nərmama həsiai nəɡhɨm ro ikinan i. ");
INSERT INTO tnk_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Pwəh nɨtətə sə ikamərɨmənu irə ruvehe. Pwəh ko nəkwam ia tɨprənə rəmwhen kamo nəkwam ia neiai. ");
INSERT INTO tnk_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tikuvei pehe nəveɡɨnien sənəmaha rəmwhen səvəi nəpɨn ipwet. ");
INSERT INTO tnk_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tikenouenou noien ərəha me səkɨmaha rəmwhen kɨmaha iahamenouenou noien ərəha me səməme nərmama hamo ia kɨmaha. ");
INSERT INTO tnk_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tikəpwəh niri penien kɨmaha ia kwopun tahəmwei ia nərəhaien ikɨn, mətə tikɨnise Setan mə trəpwəh nourahaien kɨmaha.’ ");
INSERT INTO tnk_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Trɨni mɨnuə kɨmiaha hienouenou noien ərəha me səvəi nərmama, Tata səkɨmiaha fwe ia neiai in mwi trenouenou noien ərəha me səkɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mətə trɨni mɨnuə kɨmiaha hiəpwəh nenouenouien noien ərəha me səvəi nərmama, Tata səkɨmiaha trəpwəh mwi nenouenouien noien ərəha me səkɨmiaha.” ");
INSERT INTO tnk_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nənə nəpɨn tihəpwəh naniien nari mə tihəfwaki, hiəpwəh noien nənimemiaha rəpou rəmwhen ia kəuətkəsuə me kamho. Irəha kamho nənimenraha ruvehe mopəiti mə nərmama me tuhətoni mhəukurən mə kamhəpwəh naniien nari. Iakani nɨpərhienien tukumiaha i nərmama me nəha həuvəuvehi raka nərəkuien səvənraha. ");
INSERT INTO tnk_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mətə nəpɨn ikuə tikəpwəh nəniien nari mə tikəfwaki, ikaikuas ia nənimem, mahakwi oel ia nukwənem. ");
INSERT INTO tnk_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Nənə nərmama tuhəpwəh nətoniien mə ikəpwəh nəniien nari, mətə Tata səim sə nərmama həpkətoni mhə trətoni. Nənə Tata nəha səim sə ramətə narimnari me kamo afafa truvei pehe nərəkuien mik.” ");
INSERT INTO tnk_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Kɨmiaha tihəpwəh noeiteien nautə səkɨmiaha ia tɨprənə i. Ia kwopun i uvne me mɨne nopweiien krauouraha nari. Ia kwopun i rakres me kamheitehi nimwə, mamhəuvnimwə, mamhakres. ");
INSERT INTO tnk_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mətə kɨmiaha tihaməkeikei mhoeite nautə səkɨmiaha ia neiai. Ia kwopun nəha uvne me mɨne nopweiien kroupkouraha mhə nari. Rakres me həpkeitehi mhə nimwə mə tuhəuvnimwə mhakres. ");
INSERT INTO tnk_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Iakani iamɨnhi irə tɨ nəri nə mə kwopun nautə səim raməmak ikɨn, nətərɨɡien səim traməmak mwi ikɨn.” ");
INSERT INTO tnk_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Nəmri iərmama in nə rauvei pen nukuraanien m nɨpwran. Ro iamɨnhi irə trɨni mɨnuə nənimem ramasan, nɨpwram pam trukuər ia nukuraanien. ");
INSERT INTO tnk_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mətə mə nənimem rərəha, nɨpwram pam trukuər ia nəpitəvien. Trɨni mɨnuə nukuraanien ia rerɨm ro nəpitəvien irə, ikamarə ia nəpitəvien pərhien.” ");
INSERT INTO tnk_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Iərmama riti riwən ramo tukwini nari ko ro nəkwai iəmə asori kəru. Trɨni mɨnuə ro iamɨnhi irə, trokeikei riti, məmwəki riti, uə trɨsiai riti mɨpkɨsiai mhə riti. Kɨmiaha ko hiəpkuvehi pəri mhə Kumwesən mɨne mane mho iəmə asori mi irə səkɨmiaha mə tiho pəri nəkwanrau.” ");
INSERT INTO tnk_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ro pen iakani pehe tukumiaha i mə tihəpwəh nətərɨɡ pɨkien tɨ nɨmɨruien səkɨmiaha, mamhəres nəfe tihani uə nəfe tihənɨmwi. Tihəpwəh nətərɨɡ pɨkien ia nɨpwramiaha, mamhəres nəfe tiharkahu i. Nɨmɨruien rɨpko mhə səvəi nəveɡɨnien əpa. Nɨpwrai iərmama rɨpko mhə səvəi tɨnari əpa. ");
INSERT INTO tnk_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Hətə ro menu me i ia nɨmaɡouaɡou. Irəha həpwəh nəpweiien nari, mhəpwəh nesiien nukwan, mhəpwəh noeiteien nəveɡɨnien ia nimwə sə kamoeite nəveɡɨnien ikɨn. Mətə Tata səkɨmiaha ia neiai raməkwməni irəha. Nənə ia nənimen kɨmiaha hiamasan pɨk mhəpi raka irəha. ");
INSERT INTO tnk_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Sin ia kɨmiaha ko ro nɨmɨruien səvənhi rəpwəmwɨs mwi səvəi nəpɨn ouihi a trɨni mɨnuə ramətərɨɡ pɨk tukwe? Kɨmiaha riti ko rɨpko mhə nəri nəha. ");
INSERT INTO tnk_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ro iamɨnhi irə rəfo hiamətərɨɡ pɨk tɨ tɨnari? Hətoni ro tihinari me ia kwopun me mə kamhəfəutə irə. Irəha həpwəh noien wok, mhəpwəh nɨtiriien tɨnari. ");
INSERT INTO tnk_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mətə iakani pehe tukumiaha i Kiɡ Solomon fwe kupwən nautə səvənhi rasori pɨk, mamarkahu tɨnari amasan me, mətə tɨnari səvənhi rɨpkamasan mhə rəmwhen ia tihinari me i. ");
INSERT INTO tnk_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kɨmiaha nahatətəien səkɨmiaha rɨpkɨskai mhə. Kumwesən rauvei pen tɨnari amasan me m tihinari me, nəri auər a tihinari me kamhəmɨru ipwet mətə trakwakwi haukei, mhəsas, kuvani ia napw. Mə Kumwesən ramo iamɨnha irə, in truvei pehe mwi tɨnari m kɨmiaha məpi raka. ");
INSERT INTO tnk_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ro pen tihəpwəh nətərɨɡ pɨkien, mamhəres mə, ‘Tsani nəfe?’ uə ‘Tsənɨmwi nəfe?’ uə ‘Tsarkahu ia nəfe?’ ");
INSERT INTO tnk_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nərmama səməme həreirei Kumwesən kamhətui əmisə nəveɡɨnien mɨne tɨnari. Nənə Tata səkɨmiaha ia neiai ruvəukurən raka narimnari me i mə tihaməkeikei mhəuvehi. ");
INSERT INTO tnk_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mətə kɨmiaha tihəkupwən mhətui əmisə nɨtətə sə in ramərɨmənu irə mɨne noien atukwatukw me səvənhi, nənə in truvei pehe mwi narimnari me pam i m kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ro pen kɨmiaha tihəpwəh nətərɨɡ pɨkien tɨ nəfe trakwakwi. Narimnari me səvəi trakwakwi səvəi trakwakwi. Nəsəsauien me səvəi nəpɨn kuatia nəmwhen raka.” ");
INSERT INTO tnk_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Kɨmiaha tihəpwəh nəkiriien nərmama tɨ noien ərəha me səvənraha kamo Kumwesən rəkiri mwi kɨmiaha tɨ noien ərəha me səkɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nəkiriien səkɨmiaha sə hiaməkiri nərmama irə, tukəkiri mwi kɨmiaha irə. Nərpwɨnien səkɨmiaha sə hiamo m nərmama tukərpwɨn pehe mwi m kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Rəfo ikamətə nɨmwəkmwəki nei sə raməmak ia nəmri piam, mətə ipkətə mhə nɨpəri nei asori sə raməmak ia nənimem? ");
INSERT INTO tnk_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Trɨni mɨnuə nɨpəri nei asori raməmak ia nənimem, rəfo iakamɨni pen tɨ piam mə, ‘Əseni iou, pwəh iakɨskəri raka nɨmwəkmwəki nei sə raməmak ia nənimem’? ");
INSERT INTO tnk_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ik iərmama sə ikamo kəuətkəsuə tikaməkeikei mukupwən muvehi raka nɨpəri nei asori sə raməmak ia nənimem, kurirə irə ikətə amasan nari mə tikɨskəri raka nɨmwəkmwəki nei sə raməmak ia nəmri piam. ");
INSERT INTO tnk_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kɨmiaha tihəpwəh nuvei penien nari sə ro ikinan m kuri me. Rərəha mə kuri me nəha hərari mhahi testesi nɨpwramiaha. Tihəpwəh nərarki penien nəri amasan nənimen rutə pɨk revən tɨ pɨkə me. Rərəha mə pɨkə me nəha havən irə ia nɨsunraha.” ");
INSERT INTO tnk_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Trɨni mɨnuə hiokeikei nari riti, ramasan mə tihəres, nənə tukuvei pehe m kɨmiaha. Tihətui əmisə i, nənə tihətoni. Tihəkunkun ia təpinhə, nənə tukəsevər tukumiaha. ");
INSERT INTO tnk_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Iərmama sə raməres nari, truvehi nari. Iərmama sə ramətui əmisə nari, trətoni. Iərmama sə rakunkun ia təpinhə, tukəsevər tukwe. ");
INSERT INTO tnk_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Sin ia kɨmiaha nəpɨn iəkunouihi səvənhi rəres bred, truvei pen kəruəterei min, ");
INSERT INTO tnk_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","uə rəres nəmu truvei pen snek? Rekəm! ");
INSERT INTO tnk_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kɨmiaha tihaməkeikei mhəuvei pen narimnari amasan me m nəkwərhakwərha me səkɨmiaha. Mə kɨmiaha i nəkur ərəha hiəukurən noien iamɨnhi, hiaməfətərɨɡ ia Tata səkɨmiaha ia neiai? In truvei pen narimnari amasan me rasori mwi m nərmama səməme kamhəres in tukwe. ");
INSERT INTO tnk_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ro pen nəfe noien kɨmiaha hiokeikei mə nərmama tuho ia kɨmiaha, kɨmiaha mwi tiho ia nirəha, tɨ nəri nə mə in i nɨpwrai nəɡkiariien me ia Loa səvəi Moses mɨne nəkukuə me səvəi profet kupwən me.” ");
INSERT INTO tnk_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Kɨmiaha tihaməkeikei mhəukurau ia ket ouihi. Iakani iamɨnhi irə tɨ nəri nə mə ket asori mɨne suatuk sə rɨməru ramevən tɨ nemhəien. Nərmama həpɨk kamhəukurau ia ket nəha. ");
INSERT INTO tnk_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mətə ket ouihi mɨne suatuk əknekɨn ramevən tɨ nɨmɨruien. Nərmama houihi a kamhətə suatuk nəha.” ");
INSERT INTO tnk_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Kɨmiaha tihaməsiari tɨ profet eikuə me. Irəha tuhəuvehe tukumiaha mhəvi sipsip me ia nirəha, mətə rerɨnraha rəmwhen ia kuri əprmɨn me. ");
INSERT INTO tnk_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kɨmiaha tihətə irəha, mhəukurən mə irəha profet eikuə me, tɨ nəri nə mə noien səvənraha trahatən pen. Rəfo, ko kesi nukwai krep ia rəhi, uə nukwai niemɨs ia nəkwus sə ro rɨrevɨn me? Rekəm! ");
INSERT INTO tnk_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nei amasan raukuə kwənkwai nei amasan, mətə nei ərəha raukuə kwənkwai nei ərəha. ");
INSERT INTO tnk_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nei amasan ko rəpwəh nukuəien kwənkwai nei ərəha. Nei ərəha ko rəpwəh nukuəien kwənkwai nei amasan. ");
INSERT INTO tnk_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nei me pam səməme həpkukuə mhə kwənkwanraha sə ramasan kamərai əmwesi irəha, kamərarki pen ia napw. ");
INSERT INTO tnk_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ro pen kɨmiaha tihətə irəha mhəukurən mə irəha profet eikuə me tɨ nəri nə mə noien səvənraha trahatən pen. ");
INSERT INTO tnk_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Nərmama həpɨk kamhəkwein iou mə, ‘Iərɨmənu, Iərɨmənu,’ mətə rɨpko mhə irəha pam tuhəuvnimwə mhə ia nɨtətə ia neiai. Iərmama sə ramo nəkwai Tata səiou sə ramarə ia neiai in truvnimwə. ");
INSERT INTO tnk_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ia nəpɨn nəha nərmama həpɨk tuhəni pehe tukw iou i mə, ‘Iərɨmənu, Iərɨmənu, ia nəɡhɨm kɨmaha iahənəvisau m nərmama. Ia nəɡhɨm kɨmaha iahənəkoui irapw nəremhə me ia nərmama. Ia nəɡhɨm kɨmaha iahəno nɨmtətien asori me rɨpɨk. Rəfo ia kɨmaha?’ ");
INSERT INTO tnk_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mətə iou takɨni pen atukwatukw tɨ nirəha i mə, ‘Iou iapkukurən raka mhə kɨmiaha ia nəpɨn riti. Kɨmiaha nərmama me hiamo noien ərəha, həuvən isipwɨn tukw iou.’” ");
INSERT INTO tnk_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Iərmama sə rɨreɡi nəɡkiariien me i səiou, mamo nəfe iakɨməni, in trəmwhen ia iərmama riti rukurən nari muvrhəkɨn nimwə səvənhi ia təkure kəruəterei. ");
INSERT INTO tnk_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nəpɨn nesən rauər, iapiwən raiu, nɨmətaɡi rəsuə ia nimwə nəha, mətə nimwə nəha rəpwəh nɨmweiien tɨ nəri nə mə kɨməuvrhəkɨn pen ramərer əknekɨn ia təkure kəruəterei. ");
INSERT INTO tnk_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Mətə iərmama sə rɨreɡi nəɡkiariien me i səiou, məpwəh noien nəfe iakɨməni, in trəmwhen ia iərmama riti rɨreirei nari muvrhəkɨn nimwə səvənhi ia nɨpəkɨr. ");
INSERT INTO tnk_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nəpɨn nesən rauər, iapiwən raiu, nɨmətaɡi ruvehe məsuə ia nimwə nəha, nənə nimwə nəha rɨmwei. Nəpɨn rɨmwei irə ruvehe mərəha pam.” ");
INSERT INTO tnk_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nəpɨn Iesu rɨni pam nəɡkiariien me i, nərmama me hərkəri asori nari ia nahatənien səvənhi, ");
INSERT INTO tnk_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","tɨ nəri nə mə in rahatən irəha rəmwhen iərmama sə rauvehi nasoriien ruku pen tɨ Kumwesən. In ropə ia nahatən me səvənraha səməme kamhahatən Loa. ");
INSERT INTO tnk_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nəpɨn Iesu reiwaiu ia təkuər nəha, nərmama həpɨk kamhəkurirə i. ");
INSERT INTO tnk_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nənə iərmama riti nemhəien skai riti ro tekɨn ruvehe tukwe in, mɨnɨmwi nukurhun mi ia nənimen, mɨni mə, “Iərɨmənu. Mə rerɨm raɡien, ko iko iou iakəmher?” ");
INSERT INTO tnk_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Nənə Iesu rosə pen rəɡɨn, mɨrapi in, mɨni mə, “Rerɨk raɡien. Tikuvehe məmher.” Təkwtəkwuni a nemhəien səvəi iərmama nəha raraka irə. Nɨpwran ruvehe məmher mwi. ");
INSERT INTO tnk_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nənə Iesu rɨni pen tukwe in mə, “Tikətui amasan tukwe, məpwəh nɨniien nəfe iakɨno mik tɨ iərmama riti. Mətə tikevən atukwatukw tɨ pris pwəh rətoni nɨpwram mə rəmher. Tikuvei pen nəfe m Kumwesən sə Moses rɨməni. Nərmama me tuhətoni həukurən mə nemhəien i ruvəiwən ia nɨpwram.” ");
INSERT INTO tnk_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Iesu revən mapirapw ia taon nəha Kapaneam. Iaruaɡən riti səvəi nəkur Rom nəha ikɨn in rasori ia naruaɡən me irəha pam hantret. Ruvehe tɨ Iesu, məres mə, ");
INSERT INTO tnk_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Iərɨmənu. Ko ikasitu ia nirak? Iərmama sə ramo tukwini nari miou raməmak fwe ia nəkwai nimwə səiou, mamreɡi rərəha anan, ko rɨpkavən mhə.” ");
INSERT INTO tnk_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Mɨreɡi Iesu rɨni pen tukwe in mə, “Iou takuvehe mo in ruvehe məsanɨn.” ");
INSERT INTO tnk_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mətə iəmə asori səvəi naruaɡən me rɨni mə, “Iərɨmənu. Rɨpko mhə iou iəmə amasan riti. Iapkəmwhen mhə mə tikuvehe muvnimwə ia nimwə səiou. Mətə tikɨni a nəkwam, nənə pwəh iərmama sə ramo tukwini nari miou ruvehe məsanɨn. ");
INSERT INTO tnk_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Iou mwi iərmama riti sə iakamarə teɡɨn nəmə asori me. Naruaɡən me nepwɨn mwi kamharə teɡɨn iou. Nəpɨn iakɨni pen tɨ riti mə ‘Evən,’ in trevən. Nəpɨn iakɨni pen tɨ riti mwi mə ‘Uvehe,’ in truvehe. Nəpɨn iakɨni pen tɨ iərmama sə ramo tukwini nari miou mə ‘O nəri,’ in tro.” ");
INSERT INTO tnk_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nəpɨn Iesu rɨreɡi nəɡkiariien nəha, rərkərinari, mɨni pen tɨ nərmama səməme kamhəkurirə in mə, “Iakani nɨpərhienien tukumiaha i mə iou iapkətə raka mhə iəmə Isrel riti nahatətəien səvənhi rɨskai rəmwhen ia nahatətəien səvəi iəmə Rom i. ");
INSERT INTO tnk_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Iakani pehe tukumiaha i mə nərmama həpɨk rɨpko mhə irəha nəkur Isrel tuhəuku pen ia nɨkaren parei mɨne nɨkaren peraha mhəuvehe mhani pəri nari irəha Epraham mɨne Aesak mɨne Jekop ia Nɨtətə ia Neiai. ");
INSERT INTO tnk_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Mətə nəkur Isrel, irəha nɨpwnəti nɨtətə nəha, tukərarki irapw irəha həpɨk fwe iruə ia kwopun rɨpitəv ikɨn. Ia kwopun nəha tuhasək, mhahi tərini revɨnraha.” ");
INSERT INTO tnk_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nənə Iesu rɨni pen tɨ iəmə asori səvəi naruaɡən me mə, “Evən. Iərmama sə ramo tukwini nari mik trəsanɨn rəmwhen ikɨni nɨpərhienien mə tako mik.” Təkwtəkwuni a irə iərmama sə ramo tukwini nari m iəmə asori səvəi naruaɡən me ruvehe məsanɨn. ");
INSERT INTO tnk_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kurirə ikɨn Iesu revən muvnimwə ia nimwə səvəi Pita, mətoni kaka pran səvəi Pita raməmak maməkwiei fifa. ");
INSERT INTO tnk_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Iesu rɨrapi rəɡɨn, nənə nemhəien raraka irə. Prən nəha rɨskəmter, mɨnaməpnəpenə nəveɡɨnien sənəni. ");
INSERT INTO tnk_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ia nəpɨn nəha ia nəruarəv meri ruvəivə irəha həuvehi nərmama həpɨk nəremhə me kamharə ia nirəha həuvehi irəha mhəuvehe tɨ Iesu. In rɨni a nəɡkiariien səvənhi, məkoui irapw nənɨmwɨn ərəha me irə, mo mwi səməme kamhemhə irəha pam həuvehe mhəsanɨn. ");
INSERT INTO tnk_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Narimnari me i həier pehe iamɨnhi mə nəɡkiariien səvəi Profet Aesea truvehe mukuə. In rɨməni mə, “In ruvehi nemhəien me səkɨtaha mɨne nəmisəien me səkɨtaha.” ");
INSERT INTO tnk_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nəpɨn Iesu rətoni mə nərmama me həpɨk hərer kurau kurau irə, rɨni pen tɨ nərmama me səvənhi mə, “Pwəh səuvən mhəpi sɨmwɨn pen fwe ia nɨkare nui asori.” ");
INSERT INTO tnk_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ia nəpɨn nəha iahatən riti səvəi Loa ruvehe mɨni pen tukwe in mə, “Iahatən, takukurirə ik kwopun pəku tikevən ikɨn.” ");
INSERT INTO tnk_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Mɨreɡi Iesu rɨni pen tukwe in mə, “Kuri əprmɨn me səvənraha nɨpəɡ rarə. Menu me ia nɨmaɡouaɡou təpwaɡenraha rarə. Mətə iou, Iəməti Iərmama, kwopun səiou riwən mə takapri ikɨn.” ");
INSERT INTO tnk_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nənə iərmama riti mwi sə ramərer ia kwopun nəha irəha nərmama me səvəi Iesu rɨni pen tukwe in mə, “Iərɨmənu. Takukurirə ik, mətə pwəh iakukupwən mevən mɨnɨmwi raka səiou tata.” ");
INSERT INTO tnk_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Mɨreɡi Iesu rɨni pen tukwe in mə, “Nərmama səməme həpkukurirə mhə iou rəmwhen mə həuvamhə raka. Tikukurirə iou, məpwəh irəha. Pwəh irəha hənɨmwi nərmama me səvənraha səməme həuvamhə.” ");
INSERT INTO tnk_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ia nəpɨn nəha Iesu rəputə ia nɨtətə ouihi riti. Nərmama me səvənhi həkurirə in. ");
INSERT INTO tnk_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Irəha həier mənamhəuvən. Rɨpko mhə tui nɨmətaɡi asori riti rɨskəmter ia təkure nui mo peiau peiau me rasori mɨnakuər ia nɨtətə ouihi səvənraha. Mətə Iesu ramapri. ");
INSERT INTO tnk_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ro pen irəha həuvən, mhəsuəpwiri in, mamhəni mə, “Iərɨmənu! Tikuvehimɨru kɨtaha! Na tsəmwhenɨmw!” ");
INSERT INTO tnk_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Rəfo kɨmiaha hiamhekɨr? Kwa nahatətəien səkɨmiaha rɨpkɨskai mhə.” Nənə in rɨskəmter mɨnise nɨmətaɡi mɨne nui asori mɨni mɨnuə troueiwaiu. Təkwtəkwuni a mwi narimnari me pam həuvehe mhəmərinu. ");
INSERT INTO tnk_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nərmama me səvənhi nənimenraha rier. Irəha həni mə, “Nəfe i iərmama nɨmətaɡi mɨne nui krauo nəkwan?” ");
INSERT INTO tnk_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nəpɨn Iesu rier pen ia nɨkare nui asori ia tənə səvəi nəmə Katara, iərmama kəru krouier ia kwopun kanɨmwi nərmama ikɨn, rouvehe tukwe in ia suatuk. Nəremhə me kamharə ia nirau, mamho irau krauousi nərmama. Iərmama riti riwən ko rukurau ia suatuk ia kwopun nəha. ");
INSERT INTO tnk_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nəpɨn irau krouətə Iesu, krouəkwein əpwəmwɨs, rouni mə, “Tɨni Kumwesən, ikuvehe mə tiko nəfe ia kɨmaha? Rosi tiko nəmisəien m kɨmaha, mətə rɨpko mhə ihi nəpɨn atukwatukw səvənhi uə?” ");
INSERT INTO tnk_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mətə toue pɨkə me həpɨk kamhərku ia kwopun nəha isipwɨn kwopti tɨ nirəha. ");
INSERT INTO tnk_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nəremhə me nəha hase Iesu, mhəni mə, “Trɨni mɨnuə ikəkoui irapw kɨmaha, pwəh ikərhi pen kɨmaha iahəuvən ia reri pɨkə me nəha.” ");
INSERT INTO tnk_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Həuvən!” Ro pen irəha həier ia iərmama mi nəha, mhəuvən ia reri pɨkə me. Təkwtəkwuni a mwi pɨkə me pam haiu, mheiwaiu ia nəpatu, mhəsas pen ia təmwei nui asori, mhəmwhenɨmw. ");
INSERT INTO tnk_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nərmama səməme kamhətui tɨ pɨkə me hap, mhəuvən ia taon səvənraha, mhəni irapw narimnari me pam nəha irəha hənətoni. Irəha həɡkiari pɨk ia nəfe Iesu rɨno ia iəmə mi nəha nəremhə me hənarə ia nirau. ");
INSERT INTO tnk_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nərmama me pam ia taon nəha həier mə tuhətə Iesu ia suatuk. Nəpɨn hətoni, hase in mə trəpwəh tənə səvənraha mamevən. ");
INSERT INTO tnk_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nənə Iesu rəputə ia nɨtətə ouihi, məpi sɨmwɨn mwi ia nui asori, muvehe ia taon səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ia kwopun nəha nərmama nepwɨn həuvehi iərmama riti mhəuvehi mhəuvehe tukwe. Iərmama nəha ramapri ia nɨməhan səvənhi nɨsun mi krouemhə. Nəpɨn Iesu rətoni nahatətəien səvənraha, rɨni pen tɨ iərmama sə nɨsun mi krouemhə mə, “Nərɨk. Tikəpwəh nehekɨrien. Iakɨnenouenou raka noien ərəha me səim.” ");
INSERT INTO tnk_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nəpɨn Iesu rɨni nəɡkiariien nəha nahatən me nepwɨn səvəi Loa həɡkiari mɨnraha me, mhəni mə, “Iəmə i rani ərəha Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Mətə Iesu ruvəukurən raka nətərɨɡien səvənraha, mɨni mə, “Rəfo rerɨmiaha ramrhi ərəha iou iamɨnhi irə? ");
INSERT INTO tnk_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nəɡkiariien mi sə pəku nəha rɨməru tukw iou tɨ nɨniien: nəɡkiariien i mə, ‘Iakɨnenouenou raka noien ərəha me səim,’ uə nəɡkiariien i mə, ‘Ərer mavən’? ");
INSERT INTO tnk_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mətə iakokeikei mə kɨmiaha tihəukurən mə iou, Iəməti Iərmama, iakauvehi nasoriien ia tɨprənə i. Iakukurən nenouenouien noien ərəha me.” Nənə Iesu rɨni pen tɨ iərmama sə nɨsun mi krouemhə mə, “Ərer, muvehi nɨməhan səim, mavən mamevən fwe imwam.” ");
INSERT INTO tnk_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Iəmə nəha rərer, mavən, mevən fwe imwəni. ");
INSERT INTO tnk_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nəpɨn nərmama hətoni nəri nəha, həhekɨr, nənə həuvehi utə nəɡhi Kumwesən tɨ nəri nə mə in ruvei pen nasoriien m nərmama mə tuho iamɨnhi irə. ");
INSERT INTO tnk_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nəpɨn Iesu rəpwəh kwopun nəha mamevən, rətoni iərmama riti nəɡhɨn nə Matiu raməkure ia nimwə kamərəku pen takis ikɨn. Iesu rɨni pen tukwe in mə, “Kurirə iou.” Nənə Matiu rɨskəmter mukurirə in. ");
INSERT INTO tnk_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kurirə irə Iesu revən maməni nari ia nəkwai nimwə səvəi Matiu. Nərmama kamərəku pen takis mɨnraha mɨne nərmama ərəha me nepwɨn mwi həpɨk həuvehe mamhani pəri nari irəha min mɨne nərmama me səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nəpɨn Farisi me hətoni, həni pen tɨ nərmama me səvənhi mə, “Rəfo iahatən səkɨmiaha raməni pəri nari irəha nərmama kamərəku pen takis mɨnraha mɨne nərmama ərəha me nepwɨn mwi?” ");
INSERT INTO tnk_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Mətə nəpɨn Iesu rɨreɡi, rɨni mə, “Nərmama həsanɨn tuhətui tokta tɨ nəfe? Mətə nərmama kamhemhə kamhətui tokta. ");
INSERT INTO tnk_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ramasan mə kɨmiaha tihəuvən kahatən kɨmiaha ia nɨpwrai nəɡkiariien i Kumwesən rɨməni ia Nəkukuə Ikinan mə, ‘Iakəpwəh nokeikeiien mə nərmama tuhousi əpune nərimɨru me mhəuvehi pehe miou, mətə iakokeikei mə irəha tuhapi tɨ nirəha me.’” Nənə Iesu rarə mɨni mwi mə, “Iakani iamɨnhi irə tɨ nəri nə mə iapkuvehe mhə mə takəkwein nərmama atukwatukw me, mətə iakuvehe mə takəkwein nərmama ərəha me.” ");
INSERT INTO tnk_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ia nəpɨn nəha nərmama me səvəi Jon Paptaes həuvehe tɨ Iesu, mamhəni mə, “Rəfo kɨmaha mɨne Farisi me iahaməpwəh naniien nari tɨ nəfwakiien, mətə nərmama me səim həpwəh noien iamɨnhi irə?” ");
INSERT INTO tnk_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Nərmama ia nəveɡɨnien i kamo tɨ narə viien səvəi iərman mɨne pran tuhaməkeikei mhani nari, mamhaɡien, tɨ nəri nə mə iərman sə rɨpkarə vi a irau pran səvənhi ramarə irəha mɨnraha. Rɨpkatukwatukw mhə mə rerɨnraha trəpou ia nəpɨn nəha. Mətə trɨpkuvehe ia nəpɨn sə tukuvehi raka iərman sə rɨpkarə vi a irau səvənhi pran trɨpkarə mhə mwi irəha mɨnraha. Ia nəpɨn nəha irəha tuhəpwəh naniien nari tɨ nəfwakiien. ");
INSERT INTO tnk_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Iərmama riti riwən ko ruvehi nɨpəri tɨnari vi mɨtiri tukuahaɡ ia ruei tɨnari ivɨs. Trɨni mɨnuə ro iamɨnhi irə, tɨnari vi truvi tərini nənə meitehi asori mwi. ");
INSERT INTO tnk_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Iərmama riti riwən ko rətəɡi pen waen vi ia tɨki waen tui me sə kɨno ia teki nəni. Trɨni mɨnuə ro iamɨnhi irə, tɨki waen tui me tuhəsisi mhəpəruə tɨ nəri nə mə həuvəskai raka. Waen trarɨs pam, nənə tɨki waen me tuhərəha. Mətə waen vi tukətəɡi pen ia tɨki waen vi me sə hamərməru ihi mə waen vi mɨne tɨki waen vi me irau pəri trouəmak amasan.” ");
INSERT INTO tnk_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nəpɨn Iesu rani narimnari me nəha tɨ nirəha i, təkwtəkwuni a mwi iəmə asori riti səvəi nimwəfwaki səvəi nəkur Isrel ruvehe tukwe in, mɨnɨmwi nukurhun mi ia nənimen, mɨni mə, “Prənouihi səiou rɨpkemhə a i, mətə tiko muvehe, məmrutə rəɡɨm irə, nənə in trɨmɨru mwi.” ");
INSERT INTO tnk_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ro pen Iesu rɨskəmter irəha nərmama me səvənhi, mhəkurirə iəmə nəha. ");
INSERT INTO tnk_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Pran riti fwe ikɨn ramemhə ia nemhəien səvəi nɨpran. Nemhəien nəha rɨnarə rerɨn irə muvehi nuk twelef. Təkwtəkwuni nəha rukurirə Iesu, muvehe, mɨrapi nusvenhi tɨnari səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","In ro iamɨnhi irə mɨne tɨ nəri nə mə rerɨn ramrhi mə, “Rosi ko iakrapi tɨnari səvənhi, ko iakuvehe məsanɨn.” ");
INSERT INTO tnk_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nəpɨn rɨrapi tɨnari səvəi Iesu, Iesu ruvsini, mətoni prən nəha, mɨni mə, “Prən i. Tikəpwəh nehekɨrien. Nahatətəien səim rɨno raka ik ikuvehe məsanɨn.” Təkwtəkwuni a prən nəha ruvehe məsanɨn. ");
INSERT INTO tnk_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kurirə irə Iesu revən mapirapw ia nimwə səvəi Jaeras, mətoni nərmama səməme kamhani nɨpu səvəi nemhəien mɨne nərmama həpɨk kamho nurɨɡrɨɡien asori. ");
INSERT INTO tnk_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","In rɨni mə, “Həier. Prənouihi nəha rɨpkemhə mhə, mətə ramapri a.” Irəha həreɡi harɨs ia Iesu. ");
INSERT INTO tnk_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mətə nəpɨn həməier irapw irə, in ruvnimwə, muvehi rəɡi prən ouihi nəha, nənə in rɨmɨru mərer. ");
INSERT INTO tnk_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nənə nəvisauien səvəi nəri i revən ia kwopun me pam ia tənə nəha. ");
INSERT INTO tnk_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nəpɨn Iesu rəpwəh kwopun nəha mamevən, iərmama kəru nənimenrau rɨfwə kroukurirə in, rouəkwein əpwəmwɨs, rouni mə, “Kwənəkwus səvəi Kiɡ Tevɨt! Api tukumrau!” ");
INSERT INTO tnk_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nəpɨn Iesu ruvnimwə ia nəkwai nimwə, iərmama mi nəha nəmrɨnrau rɨfwə krouvehe tukwe in. Nənə Iesu rɨni pen tɨ nirau i mə, “Kɨmirau irouni nɨpərhienien mə iakukurən noien nəri i uə rekəm?” Mɨreɡi irau krouni mə, “Ouəh, Iərɨmənu.” ");
INSERT INTO tnk_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ro pen in rɨrapi nəmrɨnrau, mɨni mə, “Itə. Pwəh iakomasan nənimemirau rukurirə pen a nahatətəien səkɨmirau.” ");
INSERT INTO tnk_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nənə nənimenrau rətui, irau krouətə nari. Nənə Iesu rɨnise pen əknekɨn tɨ nirau i mə, “Kɨmirau tirouətui amasan tukwe, rouəpwəh nɨniien nəfe iakɨno m kɨmirau tɨ iərmama riti.” ");
INSERT INTO tnk_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mətə irau krouəpwəh in, rouevən rouəvisau nəfe Iesu rɨno mɨnrau nəɡkiariien səvənrau ruvirɨs mevən ia kwopun me pam ia tənə nəha. ");
INSERT INTO tnk_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nəpɨn iərmama mi nəha krouərari rauevən, təkwtəkwuni nəha nərmama nepwɨn həiri iərmama riti, mhəiri mhəuvehe tɨ Iesu. Iərmama nəha ko rɨpkəɡkiari mhə tɨ nəri nə mə iəremhə rarə irə. ");
INSERT INTO tnk_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nəpɨn Iesu rəkoui irapw raka iəremhə nəha, iərmama nəha rɨnaməɡkiari. Nənə nərmama me hətoni hərkərinari irə, mamhəni mə, “Kɨtaha səpkətə raka mhə nari riti iamɨnhi ia tənə Isrel.” ");
INSERT INTO tnk_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mətə Farisi me həni mə, “In rauvehi nɨskaiien səvəi iəremhə sə in rasori ia nəremhə me, maməkoui irapw nəremhə me irə.” ");
INSERT INTO tnk_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ia nəpɨn nəha Iesu revən ia taon me mɨne rukwənu me pam, mamahatən nərmama ia nəkwai nimwəfwaki me səvəi nəkur Isrel, maməvisau nəɡkiariien amasan ia nɨtətə sə Kumwesən ramərɨmənu irə, mamomasan nərmama me pam səməme kamhemhə ia nemhəien me səpəmsəpə mɨne səməme nemhəien rouraha nɨpəri nɨpwranraha. ");
INSERT INTO tnk_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nəpɨn in rətoni nərmama həpɨk anan, rerɨn rərkwəpɨr tɨ nirəha, tɨ nəri nə mə haməmwur pɨk, mhənəpou. Irəha həmwhen ia sipsip me nepwɨn iərmama riwən trətə amasan irəha. ");
INSERT INTO tnk_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ro iamɨnhi irə Iesu rɨni pen tɨ nərmama me səvənhi mə, “Nəveɡɨnien sə ruvəmruə raka fwe ia nəmhien rasori pɨk, mətə nərmama səməme kamhəpeki pehe houihi a. ");
INSERT INTO tnk_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ro iamɨnhi irə kɨmiaha tihaməkeikei mhəfwaki m Kumwesən sə ramərɨmənu ia nəmhien, mhəres in mə trərhi pen nərmama nepwɨn mwi həuvən fwe ia nəmhien səvənhi mhəpeki nəveɡɨnien sə ruvəmruə, mhəpeki mhəuvehe.” ");
INSERT INTO tnk_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iesu rəkwein pen nərmama səvənhi twelef həuvehe tukwe. Nənə in ruvei pen nasoriien mɨnraha. Ia nasoriien nəha irəha həukurən nəkoui irapwien nənɨmwɨn ərəha me ia nərmama, mhəukurən mwi nomasanien nərmama me pam səməme kamhemhə ia nemhəien me səpəmsəpə. ");
INSERT INTO tnk_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aposol me nəha irəha pam twelef nəɡhɨnraha me i: Sə rukupwən Saemon (iəmə sə kani mə Pita), mɨne Antru piəvi Saemon, mɨne Jemes tɨni Sepeti, mɨne Jon piəvi Jemes, ");
INSERT INTO tnk_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","mɨne Filip, mɨne Patolomiu, mɨne Tomas, mɨne Matiu (iəmə sə kupwən kamərəku pen takis min), mɨne Jemes tɨni Alfeas, mɨne Tateas, ");
INSERT INTO tnk_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","mɨne Saemon (iəmə sə kupwən rakurirə ia nəmə me nəha kamhəmwur mə tuhəkoui irapw nəkur Rom), mɨne Jutas Iskariot (iəmə sə ruvei pen Iesu ia rəɡi nərmama səməme haməmwəki in). ");
INSERT INTO tnk_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nəmə me nəha twelef Iesu rərhi pen irəha, maməvəhaɡ mɨnraha, mani mə, “Kɨmiaha tihəpwəh nevənien tɨ nərmama rɨpko mhə irəha nəkur Isrel, mhəpwəh mwi nuvnimwəien ia taon riti səvəi nəkur Sameria. ");
INSERT INTO tnk_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mətə kɨmiaha tihaməkeikei mhəuvən əpa tɨ nəkur Isrel. Irəha həmwhen ia sipsip me hənəruei. ");
INSERT INTO tnk_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nəpɨn kɨmiaha hiamesi pen suatuk səkɨmiaha mamhəuvən, tihəni irapw iamɨnhi irə mə, ‘Nɨtətə ia neiai ruvəuvehe ipaka.’ ");
INSERT INTO tnk_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Kɨmiaha tihaməkeikei mho nərmama səməme kamhemhə həuvehe mhəsanɨn. Səməme həuvamhə, kɨmiaha tiho irəha hətui mwi. Səməme nemhəien skai ro tekɨnraha, kɨmiaha tiho irəha həuvehe mhəmher. Səməme nəremhə me kamharə ia nirəha, kɨmiaha tihəkoui irapw nəremhə me nəha ia nirəha. Nasoriien i iakauvei pehe m kɨmiaha hiəpkuvehi mhə nənimen. Ro pen kɨmiaha tihasitu ia nərmama me irə, mhəpwəh nəresien nərəkuien tukwe. ");
INSERT INTO tnk_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kɨmiaha tihəpwəh nuvehiien kol uə silva uə kapa uə mane riti mwi mhəvai pen ia pəket me səkɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kɨmiaha tiharkahu karkahu kuatia a, mhəuvei pen put, mhəuvehi tənərɨpw mɨne kaskɨn səvəi navənien səkɨmiaha, mətə tihəpwəh nuvehiien sə rəkwaku. Iakani iamɨnhi irə tɨ nəri nə mə kɨmiaha hiəmwhen ia nərmama kamhowok. Ratukwatukw mə nəkur me nəha tuhəkwməni kɨmiaha, mhəuvei pehe nəfe riwən təni kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Nəpɨn kɨmiaha tihəuvən ia taon riti uə rukwənu riti, tihətui iərmama riti sə in rerɨn raɡien mə truvehi puvnimwə kɨmiaha ia nimwə səvənhi, nənə tihamarə ikɨn meste nəpɨn tihəier irə. ");
INSERT INTO tnk_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nəpɨn tihəuvnimwə ia nimwə nəha tihəkwein amasan ia nirəha mhəni mə, ‘Nəmərinuien ramarə tukumiaha.’ ");
INSERT INTO tnk_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nənə trɨni mɨnuə nərmama ia nəkwai nimwə nəha rerɨnraha raɡien mə tuhəuvehi puvnimwə pehe kɨmiaha, nəmərinuien nəha səkɨmiaha tramarə tɨ nirəha, mətə mə rerɨnraha rɨpkaɡien mhə tukumiaha, nəmərinuien nəha səkɨmiaha trɨrərɨɡ mwi tukumiaha. ");
INSERT INTO tnk_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nənə trɨni mɨnuə nərmama nepwɨn həpwəh nəsevərien ia rerɨnraha tukumiaha uə həpwəh nətərɨɡien ia nəɡkiariien me səkɨmiaha, nəpɨn kɨmiaha tihəier ia nimwə səvənraha uə taon səvənraha, tihaməkeikei mhounouini raka nɨməkwrur ia nɨsumiaha, mhahatən pen mə irəha həno noien ərəha. ");
INSERT INTO tnk_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Iakani nɨpərhienien tukumiaha i ia nəpɨn nəha Kumwesən trərpwɨn noien ərəha me irə nərpwɨnien səvəi nərmama ia taon nəha trɨskai məpi raka nərpwɨnien səvəi tənə Sotom mɨne Komora fwe kupwən.” ");
INSERT INTO tnk_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Həreɡi ro. Iakamərhi pen kɨmiaha mə tihəuvən mhəmwhen ia kwəti sipsip me sə kamhərer ia kurkwai kuri əprmɨn me. Ro pen kɨmiaha tihaməkeikei mho rəmwhen ia nərimɨru sə rukurən nari mɨne nərimɨru sə noien səvənhi rəmher. ");
INSERT INTO tnk_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Kɨmiaha tihaməsiari nərmama me. Irəha tuhəuvei pen kɨmiaha ia rəɡi nəmə asori me mə irəha tuhəkiri nəɡkiariien səkɨmiaha. Irəha tuhərisi mwi kɨmiaha ia nəkwai nimwəfwaki me səvəi nəkur Isrel. ");
INSERT INTO tnk_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tɨ nəri nə mə kɨmiaha nərmama me səiou, irəha tuhəuvehi kɨmiaha, mhərpwi irapw kɨmiaha ia nəmri kiɡ me mɨne ia nəmri nərmama səməme kamhərɨmənu. Mətə mə irəha ho iamɨnha irə kɨmiaha tihəuvehi nəpɨn riti səkɨmiaha tihəni irapw nəɡkiariien səiou irə ia nəmrɨnraha mɨne ia nəmri nərmama rɨpko mhə irəha nəkur Isrel. ");
INSERT INTO tnk_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nəpɨn nərmama tuhəuvei pen kɨmiaha ia rəɡi nəmə asori me mə irəha tuhəkiri nəɡkiariien səkɨmiaha, tihəpwəh nətərɨɡ pɨkien mə kɨmiaha tihəfni irə uə nəfe nəɡkiariien tihəni. Kɨmiaha tihəpwəh nətərɨɡ pɨkien iamɨnhi tɨ nəri nə mə ia nəpɨn atukwatukw nəha tihəɡkiari irə tukuvei pehe m kɨmiaha nəfe nəɡkiariien tihəni. ");
INSERT INTO tnk_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Rɨpko mhə nəɡkiariien atukw səkɨmiaha tihəni, mətə Nənɨmwɨn səvəi Tata səkɨmiaha trəɡkiari ia tərhumiaha. ");
INSERT INTO tnk_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Iərmama truvei pen piəvni anan ia rəɡi nərməpə mə tukousi əpune. Tata me tuho mwi iamɨnhi ia tɨnɨnraha me. Nəkwərhakwərha me tuhəskəmter mhəni ərəha səvənraha me tata me mɨne mama me, mhəuvei pen irəha mə tukousi əpune irəha. ");
INSERT INTO tnk_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nərmama me pam tuhəmwəki kɨmiaha tɨ nəri nə mə kɨmiaha nərmama me səiou. Mətə iərmama sə trərer əknekɨn ia nahatətəien səvənhi meste nərəhaien me i həuvehe mhəukurau pam, Kumwesən truvehimɨru in. ");
INSERT INTO tnk_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nəpɨn irəha tuhometə kɨmiaha ia taon riti, kɨmiaha tihaməkeikei mhap mhəuvən ia taon əpə riti. Iakani nɨpərhienien tukumiaha i kɨmiaha tihəpkəuvən pam mhə ia taon me ia tənə Isrel kurirə iou, Iəməti Iərmama, iakuvehe. ");
INSERT INTO tnk_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Iərmama sə kamahatən in rɨpkasori mhə ia iahatən səvənhi. Iərmama sə ramo tukwini nari rɨpkasori mhə ia iəmə asori səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Trɨni mɨnuə iərmama sə kamahatən in ruvehe mɨnəmwhen ia iahatən səvənhi, uə iərmama sə ramo tukwini nari ruvehe mɨnəmwhen ia iəmə asori səvənhi, rerɨnrau traɡien. Iou iəmə asori səkɨmiaha, mətə irəha həməni ərəha iou mə iou iəremhə asori Pielsepul. Ro iamɨnhi irə hiəukurən mə irəha tuhəni ərəha anan mwi kɨmiaha nərmama me səiou. ");
INSERT INTO tnk_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ro pen kɨmiaha tihəpwəh nehekɨrien irəha. Narimnari me pam səməme hamərkwafə tuhaməkeikei mhəier irapw. Narimnari me pam səməme haməmak afafa tukaməkeikei kətoni kuvehi irapw ia nukuraanien. ");
INSERT INTO tnk_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nəfe nəɡkiariien iakani pehe tukumiaha ia nəpitəvien, kɨmiaha tihaməkeikei mhəni irapw ia nukuraanien. Nəfe nəɡkiariien hiamreɡi kaməsiwən irə, kɨmiaha tihaməkeikei mhəni irapw ia təkure nimwə me. ");
INSERT INTO tnk_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kɨmiaha tihəpwəh nehekɨrien nərmama səməme həukurən nousi əpuneien nɨpwramiaha, mətə ko həpwəh nousi əpuneien nənɨmwɨmiaha. Mətə kɨmiaha tihaməkeikei mhehekɨr Kumwesən tɨ nəri nə mə in rukurən nouraha pəriien nɨpwramiaha mɨne nənɨmwɨmiaha ia kwopun napw asori rauək ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Rerɨmiaha rɨrhi ro kwəti menu me. Nənimenraha reiwaiu. Kauvehi kəru ia silin sə rouihi anan kuatia. Mətə mə Tata səkɨmiaha rɨpkəseni mhə menu me nəha ko riti rəpwəh nɨmweiien ia tɨprənə memhə. ");
INSERT INTO tnk_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hətə ro nɨmwai nukwənemiaha, mətə Kumwesən rɨnəvsini pam raka irəha. ");
INSERT INTO tnk_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ro iamɨnhi irə kɨmiaha tihəpwəh nehekɨrien. Ia nənimen kɨmiaha hiamasan mwi mhəpi raka kwəti menu me nəha həpɨk. ");
INSERT INTO tnk_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Iərmama sə trɨni irapw ia nəmri nərmama mə in iərmama riti səiou, iou mwi takɨni irapw ia nəmri Tata səiou ia neiai mə in iərmama riti səiou. ");
INSERT INTO tnk_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mətə iərmama sə trɨni irapw ia nəmri nərmama mə in rɨreirei iou, iou mwi takɨni irapw ia nəmri Tata səiou ia neiai mə iakreirei in.” ");
INSERT INTO tnk_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Rərəha mə rerɨmiaha ramrhi iou mə iakuvehe mə tako nərmama ia tɨprənə i harə ia nəmərinuien. Iapkuvehe mhə mə tako nərmama harə ia nəmərinuien, mətə iakuvehe mə tako nərmama həuai irəha me, mhəvisə. ");
INSERT INTO tnk_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Iakuvehe mə tako ‘iərmama rəvisə irau tata səvənhi, pran rəvisə irau mama səvənhi, prɨsɨni pran rəvisə irau kaka pran səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Iərmama riti trətoni mə nərmama səməme kamharə ia nəkwai nimwə səvənhi tuhaməmwəki in.’ ");
INSERT INTO tnk_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Iərmama sə rokeikei pɨk tata səvənhi uə mama səvənhi məpi raka in rokeikei iou, rəpwəh nəmwhenien mə truvehe mo in iərmama riti səiou. Nənə iərmama sə rokeikei pɨk tɨni iərman uə tɨni pran məpi raka in rokeikei iou rəpwəh nəmwhenien mə truvehe mo in iərmama riti səiou. ");
INSERT INTO tnk_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Iərmama sə rɨpkuvehi utə mhə nei kamarkuaui səvənhi, məvrani mukurirə iou, rəpwəh nəmwhenien mə truvehe mo in iərmama riti səiou. ");
INSERT INTO tnk_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Iərmama sə rokeikei mə trəkwtəmhiri nɨmɨruien səvənhi trarfai irə. Mətə iərmama sə traraka ia nɨmɨruien səvənhi tukw iou truvehi nɨmɨruien rerɨn.” ");
INSERT INTO tnk_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Iərmama sə raməsevər ia rerɨn tukumiaha rəmwhen mə raməsevər mwi ia rerɨn tukw iou. Nənə iərmama sə raməsevər ia rerɨn tukw iou rəmwhen mə raməsevər mwi ia rerɨn tɨ Kumwesən sə rɨnərhi pehe iou iakuvehe. ");
INSERT INTO tnk_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Iərmama sə raməsevər ia rerɨn tɨ iərmama riti tɨ nəri nə mə in rukurən mə iərmama nəha in profet, in truvehi nərəkuien səvənhi rəmwhen ia nərəkuien səvəi profet. Nənə iərmama sə raməsevər ia rerɨn tɨ iərmama riti tɨ nəri nə mə in rukurən mə iərmama nəha in iərmama atukwatukw, in truvehi nərəkuien səvənhi rəmwhen ia nərəkuien səvəi iərmama atukwatukw. ");
INSERT INTO tnk_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nənə iərmama sə truvei pen nui əkwiei a m iərmama riti tɨ nəri nə mə in rukurən mə iərmama nəha in iərmama riti səiou, nəri auər a mə in reiwaiu ia nərmama nepwɨn səiou, mətə iakani nɨpərhienien tukumiaha i mə iərmama nəha traməkeikei muvehi nərəkuien səvənhi.” ");
INSERT INTO tnk_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nəpɨn Iesu rəvəhaɡ pam m nərmama səvənhi twelef, in rier ia kwopun nəha, mevən ia taon me səvəi nəkur Kalili mə trahatən irəha məvisau mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ia nəpɨn nəha Jon Paptaes raməmak ia kalapus. Nəpɨn rɨreɡi narimnari me Iesu Kristo ramo, in rərhi pen nərmama nepwɨn səvənhi ");
INSERT INTO tnk_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","həuvən mə tuhəres pen Iesu i mə, “Ik i in i profet kupwən me kamhəni ik mə tikuvehe uə rekəm? Mə rɨpko mhə ik i rosi kɨmaha tahətui səpə iti uə?” ");
INSERT INTO tnk_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Kɨmiaha tihəuvən mhəni pen tɨ Jon nəfe hiəreɡi mhətoni. ");
INSERT INTO tnk_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nərmama me nəmrɨnraha rɨfwə hətui mhətə nari, nənə səməme nɨsunraha rərfe həvi atukw i mhavən. Nərmama səməme nemhəien skai ro tekɨnraha həuvehe mhəmher, nənə səməme nəkwəreɡɨnraha ruvisɨmw rəkwaɡ həreɡi nari. Nərmama me nepwɨn səməme kupwən həuvamhə, təkwtəkwuni nəha həuvəmɨru mwi, nənə nərmama me nautə səvənraha riwən kaməvisau nəɡkiariien amasan mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Iərmama sə ramətə iou, trɨni mɨnuə in rɨpkɨmwei mhə ia nahatətəien səvənhi tɨ nari riti iakamo, rerɨn traɡien.” ");
INSERT INTO tnk_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nəpɨn nərmama me səvəi Jon hənərari mənamhəuvən, Iesu rɨnaməɡkiari ia Jon, mɨnamɨni pen tɨ nərmama me i mə, “Fwe kupwən, kɨmiaha hiəier ia taon me mɨne rukwənu me mhəuvən ia kwopun akwesakwes ikɨn mə tihətə nəfe? Iərmama riti sə rəmwhen ia kwənkwai niɡ rɨpkərer atukwatukw mhə nəpɨn mətaɡi rauini? Rekəm. ");
INSERT INTO tnk_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kɨmiaha hiəier mhəuvən mə tihətə nəfe? Iərmama riti sə rauvei pen tɨnari amasan me? Rekəm. Nərmama səməme kamhəuvei pen tɨnari amasan me kamharə ia nimwə me səvəi kiɡ me. ");
INSERT INTO tnk_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kɨmiaha hiəier mhəuvən mə tihətə nəfe? Profet riti? Ouəh, nɨpərhienien. Kɨmiaha hiəier mhəuvən mə tihətə profet riti. Mətə iakani pehe tukumiaha i mə iəmə i in rasori məpi raka profet. ");
INSERT INTO tnk_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","In iərmama sə Nəkukuə Ikinan raməɡkiari irə, nəpɨn rɨni mə, ‘Ətə ro, takərhi pen iərmama sə trəɡkiari tukwini səiou, in trukupwən ia niram mevən, məpərhi səim suatuk.’ ");
INSERT INTO tnk_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Iakani nɨpərhienien tukumiaha i mə nərmama me səməme nɨpran me hərəhi irəha ia tɨprənə i riti riwən rasori məpi raka Jon Paptaes. Mətə nərmama me pam ia nɨtətə ia neiai sə in reiwaiu anan ia nirəha in rasori məpi raka Jon. ");
INSERT INTO tnk_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ia nəpɨn nəha Jon Paptaes rɨnaməvisau irə ruvehe meste pehe ipwet mɨne, nɨtətə ia neiai rauvirɨs mamevən ia nɨskaiien, nənə nərmama skai me kamhəkwtəmhiri. ");
INSERT INTO tnk_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Fwe kupwən meste pehe nəpɨn səvəi Jon, profet me pam mɨne Loa səvəi Moses kamhəni irapw narimnari me sə tuhəuvehe. ");
INSERT INTO tnk_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nənə trɨni mɨnuə rerɨmiaha raɡien tɨ nɨreɡiien nəɡkiariien i səiou, iakani pehe tukumiaha i mə Jon in nə Elaeja sə profet me həməni mə truvehe mwi. ");
INSERT INTO tnk_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Iərmama sə nəkwəreɡɨn rarə tɨ nɨreɡiien nari traməkeikei mətərɨɡ amasan. ");
INSERT INTO tnk_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Takɨni nəfe nəɡkiariien musipekɨn ia noien səvəi nərmama ipwet mɨne? Irəha həmwhen ia nəkwərhakwərha me kamhəkure ia kwopun kamapɨr ikɨn, mamhəkwein pen ia irəha me nepwɨn mə, ");
INSERT INTO tnk_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Kɨmaha iahani nɨpu səvəi naɡienien tukumiaha, mətə kɨmiaha hiəpko mhə tanis. Iahani nɨpu səvəi nemhəien, mətə kɨmiaha hiəpkasək mhə.’ ");
INSERT INTO tnk_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Iakani iamɨnhi irə tɨ nəri nə mə Jon rɨməuvehe, mɨpkəni mhə nari, məpwəh nənɨmwiien waen, nənə irəha həni mə, ‘Iəremhə rarə irə.’ ");
INSERT INTO tnk_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Iou Iəməti Iərmama iakɨməuvehe, maməni nari, mamənɨmwi rəmwhen a ia nirəha, nənə irəha həni mə, ‘Hətə ro iəmə nəha, in raməni pɨk nari, mamənɨmwi mamakonə i, mamavən pəri irəha nərmama səməme kamərəku pen takis mɨnraha mɨne nərmama ərəha me nepwɨn mwi!’ Mətə noien amasan me səvəi nərmama səməme kamhesi pen nukurənien səvəi Kumwesən kamhahatən pen mə nukurənien nəha ro nɨpərhienien.” ");
INSERT INTO tnk_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ia nəpɨn nəha Iesu rɨnaməɡkiari skai m nərmama me ia taon me sə in rɨno nɨmtətien asori me səvənhi rɨpɨk ikɨn, tɨ nəri nə mə irəha həpkəpwəh mhə noien ərəha me səvənraha. ");
INSERT INTO tnk_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","In rɨni mə, “Trərəha anan tukumiaha nəkur Korasin! Trərəha anan tukumiaha nəkur Petsaeta! Iakɨno raka nɨmtətien asori me ia taon mi səkɨmiaha, mətə kɨmiaha hiəpkəpwəh mhə noien ərəha me səkɨmiaha. Rɨpɨni mɨnuə iakɨno nɨmtətien me nəha ia taon mi nəha Taea mɨne Saeton, tui raka ko nərmama me ikɨn hənarkahu raka tɨnari ivɨs, mhəkure ia nɨmwrakw, mhəpwəh noien ərəha me səvənraha. ");
INSERT INTO tnk_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mətə iou iakani pehe tukumiaha i ia nəpɨn nəha Kumwesən trərpwɨn noien ərəha me irə nərpwɨnien səkɨmiaha trɨskai məpi raka nərpwɨnien səvəi nəkur Taea mɨne Saeton. ");
INSERT INTO tnk_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nənə kɨmiaha nəkur Kapaneam. Tukəfo ia kɨmiaha? Ko kuvehi utə kɨmiaha hiəuvən ia neiai? Rekəm! Tukuvehi irapw kɨmiaha hiəuvən inhərɨpw ia Imwei Nəkur Həuvamhə. Iakɨno raka nɨmtətien asori me ia taon səkɨmiaha, mətə kɨmiaha hiəpkəpwəh mhə noien ərəha me səkɨmiaha. Rɨpɨni mɨnuə iakɨno nɨmtətien me nəha ia taon nəha Sotom fwe kupwən ko ramarə ihi meste ipwet mɨne. ");
INSERT INTO tnk_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mətə iou iakani pehe tukumiaha i ia nəpɨn nəha Kumwesən trərpwɨn noien ərəha me irə, nərpwɨnien səkɨmiaha trɨskai məpi raka nərpwɨnien səvəi tənə Sotom fwe kupwən.” ");
INSERT INTO tnk_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ia nəpɨn nəha Iesu rɨni irapw mə, “Tata səiou Iərɨmənu ia neiai mɨne tɨprənə, iakani tanak tukw ik, tɨ nəri nə mə ikɨnərkwafə narimnari me i. Nərmama səməme həukurən nari mɨne səməme kɨnahatən amasan irəha həpkətoni mhə. Mətə iko pui pen m nərmama səməme həmwhen ia nɨpwnəti nəkwərhakwərha me hətoni. ");
INSERT INTO tnk_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ouəh, Tata, nəri nəha ikɨno ramesi pen a nətərɨɡien amasan səim.” ");
INSERT INTO tnk_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Iesu rarə mɨni pen mwi tɨ nərmama me i mə, “Tata səiou rɨnəmri pehe raka narimnari me pam ia rəɡɨk, iou Tɨni. Nənə iərmama riti riwən rukurən iou, mətə Tata səiou əpa. Nənə iərmama riti riwən rukurən səiou Tata, Iou əpa mɨne nərmama me nəha səməme rerɨk raɡien mə tako pui pen in mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Həuvehe tukw iou kɨmiaha i səməme hiamo pɨk wok mamhəvrani nari pəmpəm me nənə pwəh iakuvei pehe napwɨsien m kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kɨmiaha tihəuvehi nəɡkiariien me səiou səməme iakamahatən kɨmiaha irə, mhatipə pen ia nuramiaha rəmwhen ia nəri katipə pen ia nurai kau mə trərar. Pwəh iakahatən kɨmiaha ia noien me səiou. Iou iəmə afafa. Rerɨk reiwaiu. Nənə kɨmiaha tihətoni napwɨsien ia nɨmɨruien səkɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kɨmiaha tiho iamɨnhi irə tɨ nəri nə mə nəɡkiariien sə iakamahatən kɨmiaha irə rɨməru, nənə narimnari me sə takuvei pehe m kɨmiaha mə tihəuvehi həpwəh nɨpamien.” ");
INSERT INTO tnk_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ia nəpɨn nəha, ia Sapat riti, Iesu ramavən maməpi sɨmwɨn ia nɨmei wit me nepwɨn. Nərmama me səvənhi nukumhə rɨnamahi irəha, nənə hənamesi kwənkwai wit mənamhani. ");
INSERT INTO tnk_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mətə nəpɨn Farisi me hətoni, həni pen tukwe in mə, “Ətə ro. Nərmama me səim kamho noien riti rɨpkatukwatukw mhə ia Loa səkɨtaha mə tuko ia Sapat.” ");
INSERT INTO tnk_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Rosi kɨmiaha hiəpkəvsini raka mhə ia Nəkukuə Ikinan nəfe Kiɡ Tevɨt rɨno fwe kupwən uə? Ia nəpɨn nəha in mɨne nərmama me səvənhi nukumhə ramahi irəha, ");
INSERT INTO tnk_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Kiɡ Tevɨt ruvnimwə ia nimwə səvəi Kumwesən, məni bred ikinan sə raməmak ia nɨfatə. Rɨpkatukwatukw mhə ia Loa səkɨtaha mə in mɨne nərmama me səvənhi tuhani bred nəha, mətə pris me əpa həukurən naniien. ");
INSERT INTO tnk_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Uə rosi kɨmiaha hiəpkəvsini raka mhə ia Loa səkɨtaha mə ia Sapat me pris me fwe ia nimwə səvəi Kumwesən kamhərui loa səvəi Sapat mətə Kumwesən rətə mə irəha həpwəh noien nari riti rərəha? ");
INSERT INTO tnk_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Iakani pehe tukumiaha i nari riti rasori məpi raka nimwə səvəi Kumwesən in i ia kwopun i. ");
INSERT INTO tnk_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kumwesən rɨməni mə, ‘Iakəpwəh nokeikeiien mə nərmama tuhousi əpune nərimɨru me mhəuvehi pehe miou, mətə iakokeikei mə irəha tuhapi tɨ nirəha me.’ Rɨpɨnuə kɨmiaha hiəukurən nɨpwrai nəɡkiariien i ko hiəpwəh nɨni ərəhaien nərmama me səiou. Irəha həpwəh noien nari riti rərəha. ");
INSERT INTO tnk_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Iakani iamɨnhi irə tɨ nəri nə mə iou, Iəməti Iərmama, iakamərɨmənu ia Sapat.” ");
INSERT INTO tnk_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iesu rəpwəh kwopun nəha, mevən, muvnimwə ia nimwəfwaki səvəi nəkur Isrel. ");
INSERT INTO tnk_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Iərmama riti ia nəkwai nimwəfwaki nəha rəɡɨn rərfe. Ko rɨpkuvi atukw mhə i. Farisi me həres pen Iesu i mə, “Ratukwatukw ia Loa səkɨtaha mə ia Sapat tukomasan iərmama sə ramemhə uə rekəm?” Kamhətərɨɡ ia Iesu mə trəfni irə. Trɨni mɨnuə rəseni, tuhəni ərəha in tukwe. ");
INSERT INTO tnk_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Iesu rɨni pen tɨ nirəha i mə, “Sin ia kɨmiaha, trɨni mɨnuə sipsip riti səvənhi rivə pen ia ruei tənə ia Sapat trəpwəh raməmak? In traməkeikei məkwtəmhiri, muvehi utə. ");
INSERT INTO tnk_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mətə iərmama in ramasan məpi raka sipsip! Ro iamɨnhi irə ratukwatukw ia Loa səkɨtaha mə tuko noien amasan ia Sapat.” ");
INSERT INTO tnk_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nənə Iesu rəɡkiari m iərmama sə rəɡɨn rərfe, mɨni mə, “Tiko muvi atukw rəɡɨm.” Iərmama nəha ruvi atukw rəɡɨn. Rəɡɨn ruvehe mamasan mwi məsanɨn rəmwhen ia nɨkare rəɡɨn. ");
INSERT INTO tnk_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mətə Farisi me həier irapw, mhousəsɨmwɨn irəha me, mənamhəni ərəha Iesu, mənamhətui suatuk mə tuhousi əpune in. ");
INSERT INTO tnk_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Iesu ruvəukurən raka nətərɨɡien səvənraha, ro pen rier ia kwopun nəha. Nərmama həpɨk həkurirə in. Səməme kamhemhə in ro irəha pam həuvehe mhəsanɨn, ");
INSERT INTO tnk_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","nənə mɨnise pen tɨ nirəha i mə tuhəpwəh nɨniien nəɡhɨn kamo nərmama həreɡi həukurən in. ");
INSERT INTO tnk_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Narimnari me i həier pehe iamɨnhi mə nəɡkiariien səvəi Profet Aesea truvehe mukuə. In rɨməni mə, ");
INSERT INTO tnk_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Hətə ro iərmama sə ramo tukwini nari miou. Iakɨmərfi raka in. Iakokeikei pɨk in, rerɨk raɡien tukwe. Takəmri pen Nənɨmwɨn səiou ramarə irə, nənə in trɨni irapw noien atukwatukw tɨ nərmama rɨpko mhə irəha nəkur Isrel. ");
INSERT INTO tnk_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","In trɨpkəvisə mhə uə trəpwəh nətəpaharien. Nərmama tuhəpwəh nɨreɡiien rerɨn ia suatuk me. ");
INSERT INTO tnk_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","In truvehi məru nərmama səməme həpkɨskai mhə rəmwhen kauvehi məru kwənkwai niɡ sə rərkwəpɨr, nənə səməme nəɡsenraha rɨnamiwən in truvehi məru irəha rəmwhen kauvehi məru nukumheəv ia napw sə na trɨfwə. Tro iamɨnhi irə mamevən meste in tro narimnari me pam həuvehe mhatukwatukw. ");
INSERT INTO tnk_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nənə nərmama me rɨpko mhə irəha nəkur Isrel tuhəmri pen əknekɨn nətərɨɡien səvənraha irə.” ");
INSERT INTO tnk_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nəpɨn riti nərmama nepwɨn həiri iərmama riti mhəiri mhəuvehe tɨ Iesu. Iərmama nəha nənimen rɨfwə ko rɨpkəɡkiari mhə tɨ nəri nə mə iəremhə rarə irə. Nənə Iesu ro in ruvehe məsanɨn. Iərmama nəha rəɡkiari, mətə mwi nari. ");
INSERT INTO tnk_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nənə nərmama me pam nənimenraha rier. Həni mə, “Nərmama. Rosi iəmə i in i kwənəkwus səvəi Kiɡ Tevɨt kɨtaha sameitenhi uə?” ");
INSERT INTO tnk_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mətə nəpɨn Farisi me həreɡi, həni mə, “Rekəm! Iəmə nəha rauvehi nɨskaiien səvəi iəremhə asori nəha Pielsepul, maməkoui irapw nəremhə me irə.” ");
INSERT INTO tnk_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Mətə Iesu rukurən nətərɨɡien səvənraha, mɨni pen tɨ nirəha i mə, “Trɨni mɨnuə ieni riti ruai narəien səvənhi ro kəru irə, nərmama me səvənhi kamhousi irəha me, nɨtətə sə ieni nəha ramərɨmənu irə truvehe mərəha. Trɨni mɨnuə nərmama ia rukwənu riti uə ia nəkwai nimwə riti həuai irəha me ia kusen kəru, kamhousi irəha me, irəha ko həpkarə amasan mhə. ");
INSERT INTO tnk_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nənə mə nɨpərhienien i Setan raməkoui irapw nəremhə me səvənhi ia nərmama, noien nəha ramahatən pen mə narəien səvənhi ro kəru. In ramousi atukw a in. Mə ro iamɨnhi irə nɨtətə sə in ramərɨmənu irə trəfərer əpwəmwɨs? ");
INSERT INTO tnk_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kɨmiaha hiaməni iou mə iakaməkoui irapw nəremhə me ia nɨskaiien səvəi Pielsepul. Trɨni mɨnuə nəɡkiariien nəha səkɨmiaha ro nɨpərhienien, rəfo ia nərmama me səkɨmiaha? Irəha kamhəkoui irapw nəremhə me ia nɨskaiien səvəi sin? Səvəi Setan? Rekəm! Ro pen ramasan mə irəha tuhəkiri nəɡkiariien i səkɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Mətə iou iakaməkoui irapw nəremhə me ia nɨskaiien səvəi Nənɨmwɨn səvəi Kumwesən. Noien nəha ramahatən pen mə nɨtətə sə Kumwesən ramərɨmənu irə ruvəuvehe raka tukumiaha. ");
INSERT INTO tnk_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Uə iərmama riti trəfo muvnimwə, makres narimnari me ia nəkwai nimwə səvəi iəmə skai riti? In traməkeikei mukupwən məkwtəmhiri iəmə skai nəha, mərihi rəɡɨn mi mɨne nɨsun mi. Kurirə irə in rukurən nevənien makres narimnari me fwe ia nəkwai nimwə səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Iərmama sə rɨpkukurirə mhə iou in raman əpə ia nirak. Nənə iərmama sə rɨpkasitu mhə ia nirak, mamiri pehe nərmama həuvehe tukw iou, in raməkoui kɨrkɨri irəha. ");
INSERT INTO tnk_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ro pen iakani pehe tukumiaha i. Kumwesən rukurən nenouenouien nərəhaien me pam səməme nərmama tuho uə tuhəni irə, məpwəh nərpwɨnien. Mətə iərmama sə trɨni ərəha Nənɨmwɨn Ikinan, Kumwesən trɨpkenouenou mhə nərəhaien səvənhi ia nəpɨn riti. ");
INSERT INTO tnk_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Iərmama sə trɨni nəɡkiariien ərəha riti, muəsi Iou Iəməti Iərmama irə, Kumwesən rukurən nenouenouien nərəhaien səvənhi, məpwəh nərpwɨnien. Mətə iərmama sə trɨni nəɡkiariien ərəha riti muəsi Nənɨmwɨn Ikinan i, Kumwesən trɨpkenouenou mhə nərəhaien səvənhi ia nəpɨn riti. Nərpwɨnien səvənhi trarə ia nɨtətə ipwet mɨne mɨne ia nɨtətə sə trɨpkuvehe.” ");
INSERT INTO tnk_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Nei amasan rukuə nukwai nei amasan, mətə nei ərəha rukuə nukwai nei ərəha. Nei amasan uə nei ərəha tihətə sas a ia kwənkwanrau. ");
INSERT INTO tnk_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kɨmiaha hiəmwhen ia kuse snek me səməme kamhahi əpune iərəmə! Kɨmiaha nəkur ərəha tihəfo mhəni nəɡkiariien amasan? Ko hiəpko mhə, tɨ nəri nə mə iərmama raməɡkiari, ramɨni irapw a nəfe nətərɨɡien rerɨn rukuər irə. ");
INSERT INTO tnk_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Iərmama amasan rani irapw nəɡkiariien amasan tɨ nəri nə mə rerɨn rukuər ia nətərɨɡien amasan. Iərmama ərəha rani irapw nəɡkiariien ərəha tɨ nəri nə mə rerɨn rukuər ia nətərɨɡien ərəha. ");
INSERT INTO tnk_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Iakani pehe tukumiaha i ia nəpɨn nəha Kumwesən trəkiri nərmama me irə tɨ noien me səvənraha, in trəres nəɡkiariien ərəha me pam sə nərmama me həməni əpnapen, nənə irəha tuhaməkeikei mhəni pen tukwe in mə hənəfo irə mhəni. ");
INSERT INTO tnk_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nəɡkiariien me səim sə ikamɨni, Kumwesən trəkiri nəɡkiariien me nəha mətə sas ia niram mə ik iərmama atukwatukw uə ik iərmama ərəha.” ");
INSERT INTO tnk_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nənə nahatən me nepwɨn səvəi Loa mɨne Farisi me həni pen tɨ Iesu i mə, “Iahatən. Kɨmaha iahokeikei mə tiko nɨmtətien riti pwəh iahətoni ro.” ");
INSERT INTO tnk_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Mətə Iesu rɨni pen tɨ nirəha i mə, “Kɨmiaha nərmama ipwet mɨne hiamətui a nɨmtətien tɨ nəri nə mə noien səkɨmiaha rikou. Kɨmiaha hiənəpwəh Kumwesən rəmwhen pran sə rəpwəh iərman səvənhi mamesi pen iərməpə. Kumwesən trəpwəh nuvei peheien nɨmtətien riti mwi m kɨmiaha, mətə nɨmtətien əpa səvəi Profet Jona. ");
INSERT INTO tnk_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Fwe kupwən Profet Jona raməmak ia tɨpwi nəmu asori nəpɨn ia ran kahar mɨne nəpɨn ia nəpɨn kahar. Rəmwhen a mwi iou, Iəməti Iərmama, takarə ia reri tɨprənə nəpɨn ia ran kahar mɨne nəpɨn ia nəpɨn kahar. ");
INSERT INTO tnk_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ia nəpɨn nəha Kumwesən trəkiri nərmama me irə tɨ noien me səvənraha, nəmə Nineve tuhərer irəha nərmama ipwet mɨne, nənə mhəni mə irəha nəkur ərəha me. Iakani iamɨnhi irə tɨ nəri nə mə nəpɨn nəmə Nineve həreɡi Profet Jona raməvisau, irəha hərərɨɡ ia noien ərəha me səvənraha. Mətə hətə ro! Iərmama riti in rasori ia Profet Jona in i ia kwopun i. ");
INSERT INTO tnk_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ia nəpɨn nəha Kumwesən trəkiri nərmama me irə tɨ noien me səvənraha, prən asori sə rɨnamərɨmənu ia tənə Sipa fwe kupwən trərer irəha nərmama ipwet mɨne, nənə mɨni mə irəha nəkur ərəha me. Iakani iamɨnhi irə tɨ nəri nə mə prən nəha ruku pen ia nɨkare tənə fwe isipwɨn anan muvehe mə trɨreɡi nukurənien səvəi Solomon. Mətə hətə ro! Iərmama riti in rasori ia Solomon in i ia kwopun i. ");
INSERT INTO tnk_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Nəpɨn kɨnəkoui irapw nənɨmwɨn ərəha riti ia iərmama, nənɨmwɨn ərəha nəha trəfo irə? Trevən mavən ia kwopun me sə nui riwən ikɨn, mamətui kwopun trapwɨs ikɨn. Mətə mə rɨpkətoni mhə, ");
INSERT INTO tnk_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","trəɡkiari iamɨnhi irə mə, ‘Takrərɨɡ mwi mevən tɨ nimwə fwe səiou sə iakɨməier irə.’ Nənə nəpɨn rɨrərɨɡ muvehe, trətoni mə nimwə nəha ro tekɨn, kɨnaies amasan irə, narimnari me pam kamhəmrɨmər a ia təmwhekɨnraha. ");
INSERT INTO tnk_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nənə in trevən miri mwi nənɨmwɨn ərəha me sefen səməme hərəha mhəpi raka in, miri irəha mhəuvehe, mhəuvnimwə mwi, nənə mharə ia reri iərmama nəha. Nənə nɨmɨruien səvəi iərmama nəha truvehe mərəha anan məpi raka sə kupwən. Nəri nəha iakani truvehe meste nərmama ərəha me i ipwet mɨne.” ");
INSERT INTO tnk_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nəpɨn Iesu raməɡkiari m nərmama, nərmama nepwɨn hətoni piəvni me mɨne mama səvənhi kamhərer fwe iruə mamhəres in mə tuhəɡkiari ro min. ");
INSERT INTO tnk_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nənə iərmama riti rɨni pen tɨ Iesu i mə, “Ətə ro! Səim mama mɨne piam me kamhərer fwe iruə, mamhətui ik. Irəha hokeikei mə tuhəɡkiari mik.” ");
INSERT INTO tnk_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Mətə Iesu rɨni mə, “Sin nəha səiou mama? Nɨsɨmə nəha piak me?” ");
INSERT INTO tnk_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","In ruini rəɡɨn ia nərmama me səvənhi, mɨni mə, “Kɨmiaha i mama me səiou. Kɨmiaha i piak me. ");
INSERT INTO tnk_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Iərmama sə ramo nəkwai Tata səiou fwe ia neiai, in nə piak mɨne kɨtirimak mɨne mama səiou.” ");
INSERT INTO tnk_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ia nəpɨn nəha Iesu rier ia nimwə mevən məkure ia nɨkare nui asori. ");
INSERT INTO tnk_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nərmama me həpɨk həuvehe mhousəsɨmwɨn pen irəha me tukwe. Ro pen Iesu rəputə ia nɨtətə ouihi riti fwe peraha məkure irə. Nərmama me pam kamhərer parei ia nɨpəkɨr. ");
INSERT INTO tnk_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nənə in rani narimnari me rɨpɨk tɨ nirəha i, mausipekɨn, mamɨni mə, “Həreɡi ro. Nəpɨn riti, iərmama riti revən mə truini nuni nari me ia nəmhien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nəpɨn rauini nuni nari me, nuni nari me nepwɨn həsas pen ia suatuk, nənə menu me həuvehe mhani pam. ");
INSERT INTO tnk_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nepwɨn həsas pen ia təkure kəpwier tɨprənə rouihi ikɨn. Həuverə akwauakw a tɨ nəri nə mə nuanraha rɨpkeiwaiu amasan mhə ia tɨprənə. ");
INSERT INTO tnk_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Mətə nəpɨn meri rəkwiri, mənhi, haukei pam tɨ nəri nə mə nuanraha rouihi. ");
INSERT INTO tnk_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nuni nari me nepwɨn həsas pen ia tɨprənə sə nəkwus ərəha rauvirɨs ikɨn. Nəkwus ərəha me həuvirɨs mhəuvehe mhousəman pam irəha. ");
INSERT INTO tnk_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Nənə nuni nari me nepwɨn həsas pen ia tɨprənə amasan, nənə mhəukuə. Nepwɨn kwənkwan hantret, nepwɨn kwənkwan sikisti, nepwɨn kwənkwan toti. ");
INSERT INTO tnk_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Iərmama sə nəkwəreɡɨn rarə tɨ nɨreɡiien nari traməkeikei mətərɨɡ amasan.” ");
INSERT INTO tnk_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kurirə irə nərmama me səvəi Iesu həuvehe, mhəni pen tukwe in mə, “Rəfo ikaməɡkiari m nərmama ia nusipekɨnien me?” ");
INSERT INTO tnk_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Kɨmiaha nərmama me səiou kɨnəsevər ia suatuk tukumiaha hiəukurən narimnari me i ia nɨtətə ia neiai hənamərkwafə fwe kupwən. Mətə nərməpə me, kɨpkəsevər mhə ia suatuk tɨ nirəha mə tuhəukurən narimnari me nəha iamɨnhi. ");
INSERT INTO tnk_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ro iamɨnhi irə tɨ nəri nə mə iərmama sə kuvei pen nari riti min, ro wok irə, tukuvei pen sə rəkwaku min, nənə in truvehi rəmwhen məpi raka. Mətə iərmama sə kuvei pen nari riti min, ro nəri auər a irə, tukuvehi raka pam tukwe. ");
INSERT INTO tnk_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Iou iakaməɡkiari mɨnraha ia nusipekɨnien me tɨ nəri nə mə kamhətui, mətə həpkətə mhə nari. Kamhəreɡi, mətə həpkreɡi mhə nari mhəukurən. ");
INSERT INTO tnk_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Noien səvənraha ro nəɡkiariien i səvəi Profet Aesea ruvəuvehe muvəukuə. Rɨni mə, ‘Kɨmiaha tihəreɡi, mhəreɡi, mhəreɡi, mətə tɨ nəpɨn riti tihəpkreɡi mhə mhəukurən. Tihətoni, mhətoni, mhətoni, mətə tɨ nəpɨn riti tihəpkətoni mhə mhəukurən. ");
INSERT INTO tnk_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tro iamɨnha irə, tɨ nəri nə mə reri nərmama me i ruvəskai raka. Hənəsisəɡ raka ia nəkwəreɡɨnraha mɨne nənimenraha. Mətə trɨni mɨnuə həpwəh noien iamɨnha irə, nəfe nəɡhɨn tuhəukurən nətoniien ia nənimenraha nənə mhəreɡi ia nəkwəreɡɨnraha, uə tuhəukurən ia rerɨnraha, nənə mhərari mhəuvehe tukw iou, nənə tako irəha həuvehe mhəsanɨn.’ ");
INSERT INTO tnk_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Mətə kɨmiaha nəmrɨmiaha ramətə nari, nəkwəreɡɨmiaha ramreɡi nari. Ro iamɨnhi irə rerɨmiaha traməkeikei maɡien. ");
INSERT INTO tnk_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Iakamɨni nɨpərhienien tukumiaha i mə fwe kupwən profet me həpɨk mɨne nəkur atukwatukw me həpɨk hokeikei mə tuhətə narimnari me i hiamətə, mətə həpkətə mhə. Hokeikei mə tuhəreɡi nəɡkiariien me i hiamreɡi, mətə həpkreɡi mhə. ");
INSERT INTO tnk_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Hətərɨɡ iou pwəh iakɨni irapw nɨpwrai nusipekɨnien səvəi iərmama sə rauini nuni nari me. ");
INSERT INTO tnk_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nuni nari sə rəsas pen ia suatuk rəmwhen ia iərmama sə ramreɡi nəvisauien ia nɨtətə sə Kumwesən ramərɨmənu irə, mətə in rɨreirei nɨpwran. Ro pen Setan ruvehe akwauakw, muvehi raka nəɡkiariien nəha ia nətərɨɡien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nuni nari sə rəsas pen ia təkure kəpwier rəmwhen ia iərmama sə ramreɡi nəɡkiariien amasan, nənə təkwtəkwuni a ruvehi, maɡien tukwe. ");
INSERT INTO tnk_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mətə nəɡkiariien nəha rɨpkeiwaiu amasan mhə ia rerɨn rəmwhen ia nuai nei me. In truvehi nəɡkiariien nəha səvəi nəpɨn ouihi a. Nəpɨn nərmama tuho nəmisəien min, uə tuhometə in tɨ nəɡkiariien amasan, traraka akwauakw a irə. ");
INSERT INTO tnk_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Nuni nari sə rəsas pen ia tɨprənə nəkwus ərəha rauvirɨs ikɨn rəmwhen ia iərmama sə rɨreɡi nəɡkiariien amasan, mətə ramətərɨɡ pɨk ia narimnari me səvəi tɨprənə i. Mane rameikuə irə, mavi raka nətərɨɡien səvənhi. Nətərɨɡien me nəha housəman nəɡkiariien amasan. Rəpwəh nukuəien. ");
INSERT INTO tnk_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mətə nuni nari sə rəsas pen ia tɨprənə amasan rəmwhen ia iərmama sə rɨreɡi nəɡkiariien amasan, mukurən nɨpwran, mukuə. Riti nukwan toti, riti nukwan sikisti, riti nukwan hantret.” ");
INSERT INTO tnk_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Nənə Iesu rɨni nusipekɨnien riti mwi tɨ nirəha i mə, “Nɨtətə ia neiai rəmwhen ia iərmama sə ruini nuni nari amasan me ia nəmhien səvənhi, ");
INSERT INTO tnk_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","mətə nəpɨn nərmama me səvənhi kamhapri, iərmama sə raməmwəki in ruvehe, muini pen mwi nuni nurhi ərəha ia nəkwai nəmhien nəha, nənə mier mamevən. ");
INSERT INTO tnk_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nəpɨn nuni nari amasan me həutə pehe, mətə nurhi ərəha mwi rutə ia rerɨnraha. ");
INSERT INTO tnk_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Iəmə asori nəha səvənhi nərmama nepwɨn kamho tukwini nari min. Irəha həuvehe, mhəni pen tukwe in mə, ‘Iəmə asori. Ikɨnəpwei nuni nari amasan me ia nəmhien səim. Mətə rəfo nurhi ərəha mwi fwe ikɨn?’ ");
INSERT INTO tnk_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Mɨreɡi in rɨni pen tɨ nirəha i mə, ‘Kwa iərmama sə raməmwəki iou rɨno.’ Mɨreɡi nərmama səməme kamho tukwini nari min həni pen tukwe in mə, ‘Ro iamɨnhi irə ikokeikei mə kɨmaha tahəuvən mheivi raka nurhi ərəha?’ ");
INSERT INTO tnk_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mətə in rɨni mə, ‘Rekəm. Rərəha mə kɨmiaha hiameivi utə nurhi ərəha, nənə mheivi utə pekɨn sə ramasan me. ");
INSERT INTO tnk_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pwəh irəha həutə pəri meste nəpɨn nəha tuhəmruə irə. Ia nəpɨn nəha takɨni pen tɨ nərmama me səiou səməme tuhesi kwənkwai nari amasan me nəha mə, Kɨmiaha tihəkupwən mhousəsɨmwɨn nurhi ərəha, mhərihi tərini ia kusen me mə tukərarki pen ia napw. Mətə kwənkwai nari amasan me kɨmiaha tihəpeki, mhəuvehe, mhəmri ia nimwə səiou sə iakamoeite nəveɡɨnien ikɨn.’” ");
INSERT INTO tnk_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iesu rɨni irapw nusipekɨnien riti mwi tɨ nirəha i, mɨni mə, “Nɨtətə ia neiai rəmwhen ia kwənuni nei nəha mastat. Iərmama riti ruvehi, məpwei ia nəmhien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nuni mastat in rouihi anan ia nuni nei me, mətə nəpɨn rutə, rasori məpi raka nəpɨɡɨn me pam, muvehe mo nei irə, menu me ia nɨmaɡouaɡou həuvehe mho pen kwətəpaɡ me səvənraha ia rəɡɨn me.” ");
INSERT INTO tnk_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nənə Iesu rɨni pen nusipekɨnien riti mwi tɨ nirəha i, mɨni mə, “Nɨtətə ia neiai rəmwhen ia yis sə pran riti ruvehi, mərapi irau flaoa rɨpɨk, nənə məpwəh meste yis rəse floa me pam rəsisi.” ");
INSERT INTO tnk_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iesu rəɡkiari m nərmama me ia nusipekɨnien me a. Nəɡkiariien riti mwi riwən rɨni mahatən irəha irə. ");
INSERT INTO tnk_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Iesu ro iamɨnhi irə mə nəɡkiariien i profet riti səvəi Kumwesən rɨməni fwe kupwən truvehe mukuə. Rɨni mə, “Takəɡkiari ia nusipekɨnien me, mɨni irapw narimnari me sə iakɨnərkwafə i nəpɨn nəha iakɨno tɨprənə i meste pehe ipwet mɨne.” ");
INSERT INTO tnk_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Iesu rəɡkiari pam, məpwəh nərmama me, muvnimwə ia nəkwai nimwə. Nənə nərmama me səvənhi həuvehe tukwe, mhəni mə, “Tikəusiəre pui pehe ro nɨpwrai nusipekɨnien nəha ikɨməni ia nurhi ərəha sə rutə ia nəmhien.” ");
INSERT INTO tnk_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Mɨreɡi Iesu rɨni mə, “Iərmama sə rauini nuni nari amasan me in nə iou, Iəməti Iərmama. ");
INSERT INTO tnk_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nəmhien in nə tɨprənə i. Nuni nari amasan me irəha nə nɨpwnəti nɨtətə sə Kumwesən ramərɨmənu irə. Nurhi ərəha me irəha nə nɨpwnəti Setan, iəremhə ərəha. ");
INSERT INTO tnk_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Iərmama sə rəmwəki iəmə asori səvəi nəmhien, muini pen nurhi ərəha in nə Setan. Nəpɨn nuni nari amasan me həmruə irə in nə nəpɨn sampam. Nənə nərmama me nəha həuvən mhesi kwənkwan irəha nə naɡelo me. ");
INSERT INTO tnk_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Rəmwhen mə nərmama housəsɨmwɨn nurhi ərəha, nənə mhəuvani ia napw, ia nəpɨn sampam tro mwi iamɨnhi irə. ");
INSERT INTO tnk_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Iou, Iəməti Iərmama, takərhi pen naɡelo me səiou, həuvən ia kwopun me səiou sə iakamərɨmənu ikɨn. Nənə irəha tuhəpeki raka narimnari me pam səməme kamho nərmama kamhəmwei ia nərəhaien mɨne nəkur ərəha me pam, ");
INSERT INTO tnk_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","nənə mhərarki pen irəha ia napw asori. Ia kwopun nəha nərmama tuhasək, mhahi tərini revɨnraha. ");
INSERT INTO tnk_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nənə nəkur atukwatukw tuhəuvnimwə ia nɨtətə sə Tata səvənraha ramərɨmənu irə, nənə mhəhiapw rosi meri. Iərmama sə nəkwəreɡɨn rarə traməkeikei mətərɨɡ amasan.” ");
INSERT INTO tnk_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Nɨtətə ia neiai rəmwhen ia mane asori kɨnɨmwi ia tɨprənə riti. Iərmama riti raman mətoni mane nəha, rarə mɨnɨmwi mwi. Tɨ nəri nə mə rerɨn raɡien pɨk, in rəmri pen nəmri nari ia narimnari me pam səvənhi, muvehi mane irə, nənə mevən muvehi nəmri tɨprənə nəha.” ");
INSERT INTO tnk_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Nənə riti mwi. Nɨtətə ia neiai rəmwhen ia iərmama riti sə ramətui kəruəterei amasan me nəha kani mə pel mə trəmri pen nəmri nari ia nirəha, nənə muvehi mane. ");
INSERT INTO tnk_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nəpɨn rətoni pel riti nənimen rutə pɨk, revən məmri pen nəmri nari ia narimnari me pam səvənhi, muvehi mane irə, nənə mevən muvehi nəmri pel nəha.” ");
INSERT INTO tnk_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Nənə riti mwi. Nɨtətə ia neiai rəmwhen ia net sə kərarki pen ia nəkwai təsi, ruvehi nəmu me səpəmsəpə. ");
INSERT INTO tnk_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nəpɨn net ruvəukuər, nərmama həvi parei, mhəkure, mənamhəuai nəmu me. Sə ramasan me kamhəvai pen ia tənərɨpw me, mətə sə rərəha me kamhərarki. ");
INSERT INTO tnk_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tro mwi iamɨnhi irə ia nəpɨn sampam. Naɡelo me tuhəuvən, mhəpeki raka nəkur ərəha ia reri nəkur amasan, ");
INSERT INTO tnk_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","nənə mhərarki pen irəha ia kwopun napw asori rauək ikɨn. Ia kwopun nəha nərmama tuhasək, mhahi tərini revɨnraha.” ");
INSERT INTO tnk_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Iesu rəɡkiari pam, nənə məres pen nərmama me i səvənhi mə, “Narimnari me i iakɨni pehe tukumiaha i hiəreɡi mhəukurən nɨpwranraha uə rekəm?” Mɨreɡi irəha həni mə “Ouəh. Kɨmaha iahəukurən.” ");
INSERT INTO tnk_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Ro iamɨnhi irə iərmama sə kupwən in iahatən səvəi Loa, mətə kurirə irə kahatən amasan in ia nɨtətə ia neiai, in rəmwhen ia iəmə asori riti nautə me rɨpɨk fwe ia nəkwai nimwə səvənhi. In rukurən nuvnimwəien mɨpeki raka nautə me sə vi irau nautə me sə tui.” ");
INSERT INTO tnk_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nəpɨn Iesu rɨni irapw pam nusipekɨnien me i, in rəpwəh kwopun nəha, ");
INSERT INTO tnk_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","mevən ia Nasaret, imwəni atukwatukw, mɨnamahatən nərmama ia nəkwai nimwəfwaki səvəi nəkur Isrel. Irəha nənimenraha rier. Həni mə, “Iəmə i ruvehi nukurənien nəha pəku? Raməfo mamo nɨmtətien me i? ");
INSERT INTO tnk_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Kwa tɨni Josef i iəmə sə rɨməuvrhəkɨn nimwə! Səvənhi mama nə nəɡhɨn nə Meri. Piəvni me nə Jemes, Josef, Jutas, mɨne Saemon. ");
INSERT INTO tnk_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kɨtiriməni me pam hamarə ia rukwənu i kɨtaha mɨnraha. Ro iamɨnhi irə iəmə i ruvehi narimnari me nəha pəku?” ");
INSERT INTO tnk_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nənə rerɨnraha rɨpkaɡien mhə tɨ Iesu. Həpwəh nɨsiaiien in. Mətə Iesu rɨni pen tɨ nirəha i mə, “Nərmama ia kwopun me kamhəsiai profet riti, mətə nəkur imwəni me mɨne nərmama səməme kamharə ia nəkwai nimwə səvənhi ko həpwəh nɨsiaiien in.” ");
INSERT INTO tnk_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nənə Iesu rɨpko mhə nɨmtətien me rɨpɨk ia kwopun nəha, tɨ nəri nə mə nəkur imwəni me həpwəh nɨniien nɨpərhienien irə. ");
INSERT INTO tnk_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ia nəpɨn nəha nərmama kamhəni pɨk nəɡhi Iesu. Nəpɨn Kiɡ Herot rɨreɡi nəɡkiariien səvənraha, ");
INSERT INTO tnk_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","rɨni pen tɨ nərmama səməme kamho tukwini nari min mə, “In nəha Jon Paptaes. Rɨnətui mwi ia nemhəien səvənhi ro pen rauvehi nɨskaiien mamo nɨmtətien me.” ");
INSERT INTO tnk_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kiɡ Herot rɨni iamɨnhi irə tɨ nəri nə mə fwe kupwən in rəkwtəmhiri Jon, mərihi in, muvehi puvnimwə ia kalapus tɨ Herotias, pran səvəi piəvni nəɡhɨn nə Filip. ");
INSERT INTO tnk_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Niemaha raməpi prən nəha tɨ nəri nə mə Jon rɨni pen tɨ Kiɡ Herot i mə, “Ikakres pran səvəi piam noien nəha rɨpkatukwatukw mhə ia Loa.” ");
INSERT INTO tnk_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kiɡ Herot rokeikei mə trousi əpune Jon, mətə rehekɨr nərmama tɨ nəri nə mə irəha həni mə Jon in profet riti. ");
INSERT INTO tnk_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mətə nəpɨn ko nəveɡɨnien asori riti sə rahatən pen nəpɨn Kiɡ Herot rɨnətui irə, prən ouihi səvəi Herotias ruvehe motanis ia nənimenraha, mo Kiɡ Herot rerɨn raɡien. ");
INSERT INTO tnk_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ro pen Kiɡ Herot rɨni nəkwan muvehi kwəsuahi tukwe mə truvei pen nəfe nəɡhɨn prən ouihi i trəres i. ");
INSERT INTO tnk_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ia nəpɨn nəha mama səvəi prən ouihi rəɡkiari min, mɨni pen nətərɨɡien səvənhi tukwe. Nənə prən ouihi nəha revən mɨni pen tɨ Kiɡ Herot i mə, “Tikevən muvehi kənkapwə Jon Paptaes ia tikiplet muvehi muvehe ia kwopun i muvei pehe miou.” ");
INSERT INTO tnk_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nəpɨn Kiɡ Herot rɨreɡi nəresien nəha, rerɨn rəpou. Mətə tɨ nəri nə mə rɨməuvehi kwəsuahi ia nəmri nəmə asori me səməme kamhani pəri nari irəha min in rɨni nəkwan mə tukuvei pen. ");
INSERT INTO tnk_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","In rərhi pen iaruaɡən riti səvənhi revən ia kalapus, mərai raka kənkapwə Jon, ");
INSERT INTO tnk_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","məmri pen ia tikiplet, muvehi muvehe, muvei pen m prən ouihi. Prənouihi nəha ruvehi mevən, muvei pen m mama səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nənə nərmama me səvəi Jon həuvehe, mhəuvehi nɨpwran, mhəuvən, mhənɨmwi. Kurirə irə həuvən mhəni pen tɨ Iesu. ");
INSERT INTO tnk_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nənə nəpɨn Iesu rɨreɡi nəɡkiariien i, rəputə ia nɨtətə ouihi, məpwəh kwopun nəha, mevən in əpa ia kwopun riti nərmama həiwən ikɨn. Mətə nərmama me həreɡi, həier ia taon me, mhavən a, mhəkurirə in. ");
INSERT INTO tnk_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nəpɨn in ruvarei, rətoni nərmama həpɨk, nənə rerɨn rərkwəpɨr tɨ nirəha. Nənə in ro nərmama me səvənraha səməme kamhemhə həuvehe mhəsanɨn. ");
INSERT INTO tnk_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nəpɨn rɨnaməruarəv meri na trivə, nərmama me səvəi Iesu həuvehe mhətə in, mhəni mə, “Rɨnaməpitəv. Kwopun i nəveɡɨnien riwən ikɨn. Ramasan mə tikərhi pen nərmama me i həuvən ia rukwənu me pwəh həuvehi nəmri nəveɡɨnien sənənraha.” ");
INSERT INTO tnk_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Mətə Iesu rɨni pen tɨ nirəha i mə, “Irəha tuhəuvən tɨ nəfe? Kɨmiaha nə tihəuvei pen nəveɡɨnien mɨnraha.” ");
INSERT INTO tnk_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Mɨreɡi irəha həni pen tukwe in mə, “Nəveɡɨnien sənətaha rəpwəh nəmwhenien. Bred krirum mɨne nəmu kəru a i.” ");
INSERT INTO tnk_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Mɨreɡi Iesu rɨni mə, “Həuvehi irəha mhəuvehe tukw iou.” ");
INSERT INTO tnk_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","In rɨni nəkwan mə nərmama tuhəkure ia nurhi. Ruvehi bred krirum mɨne nəmu kəru, məkwətə ia nɨmaɡouaɡou, məfwaki mɨni vivi Kumwesən tukwe, məkwsen bred me, muvei pen m nərmama me səvənhi, nənə irəha həpeki pen m nərmama. ");
INSERT INTO tnk_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nərmama pam hani nari tɨpwɨnraha rəsisi. Nənə nərmama me səvəi Iesu həvai pen nɨpərpəri nəveɡɨnien me nəha sə hənani mhəpwəh rukuər ia tənərɨpw me irəha pam twelef. ");
INSERT INTO tnk_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nərmama me nəha həpɨk hani nari nərman nɨpran mɨne nəkwərhakwərha. Kəvsini nərman me əpa ipaka faef-taosen. ");
INSERT INTO tnk_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kurirə irə Iesu rɨni pen tɨ nərmama me səvənhi mə tuhəputə ia nɨtətə ouihi, mhəkupwən mhəpi sɨmwɨn ia nui asori. In tramo mərhi pen nərmama həuvən fwe imwənraha me. ");
INSERT INTO tnk_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Iesu rəsəkɨr raka mɨnraha, mutə ia təkuər riti mə trəfwaki in əpa. Nəpɨn rɨnəpitəv in əpa ia kwopun nəha, ");
INSERT INTO tnk_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","mətə nɨtətə ouihi nərmama me səvənhi kamhəsuə i ruvan raka isipwɨn tɨ tənə nəha. Peiau peiau me kamhəpwi tɨ nəri nə mə irəha kamhaiu mamhəuvən ia nəmri mətaɡi mwatuk. ");
INSERT INTO tnk_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ia nəpɨn nəha rɨnamran Iesu ruvehe tɨ nirəha, mamavən ia təkure nui. ");
INSERT INTO tnk_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Mətə nəpɨn nərmama me səvənhi həti pen mhətoni mə in ravən ia təkure nui, həhekɨr, mhəni mə, “Kwa iəremhə nəha.” Nənə irəha həkwein əpwəmwɨs tɨ nəri nə mə həhekɨr asori. ");
INSERT INTO tnk_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Mətə təkwtəkwuni a Iesu rəɡkiari mɨnraha mɨni mə, “Kɨmiaha tihəpwəh nɨreɡiien rərəha. Kwa iou i. Tihəpwəh nehekɨrien.” ");
INSERT INTO tnk_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Mɨreɡi Pita rɨni pen tukwe in mə, “Iərɨmənu. Trɨni mɨnuə ik nə tikɨni nəkwam tukw iou i mə takavən ia təkure nui muvehe tukw ik.” ");
INSERT INTO tnk_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Mɨreɡi Iesu rɨni mə, “Uvehe.” Ro pen Pita reivə irapw ia nəkwai nɨtətə ouihi, mavən ia təkure nui mevən tɨ Iesu. ");
INSERT INTO tnk_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mətə nəpɨn rətoni nɨmətaɡi, rehekɨr, mɨnaməmwhenɨmw, mɨnaməkwein əpwəmwɨs mə, “Iərɨmənu! Uvehimɨru iou!” ");
INSERT INTO tnk_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Təkwtəkwuni a Iesu rosə pen rəɡɨn muvehi Pita, mɨni pen tukwe in mə, “Ik iərmama nahatətəien səim rɨpkɨskai mhə. Rəfo nətərɨɡien səim ro kəru iamɨnhi irə?” ");
INSERT INTO tnk_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nəpɨn irau krouəputə ia nɨtətə ouihi, nɨmətaɡi reiwaiu miwən. ");
INSERT INTO tnk_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nənə nərmama me səvəi Iesu ia nəkwai nɨtətə ouihi hənɨmwi nukurhunraha, mhəuvei pen nɨsiaiien səvənraha min, mhəni mə, “Nɨpərhienien ik Tɨni Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Irəha həpi sɨmwɨn ia nui asori, mhəuvən mhəuvarei ia tənə Kenesaret. ");
INSERT INTO tnk_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nəpɨn nərmama ia kwopun nəha hətoni mhəukurən mə Iesu nəha, hərhi pen nəɡkiariien revən ia rukwənu me pam ia kwopun nəha. Nənə irəha həuvehi nərmama me pam səməme kamhemhə mhəuvehi mhəuvehe tɨ Iesu, ");
INSERT INTO tnk_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","mamhəres in mə ko irəha hərapi a nusvenhi tɨnari səvənhi. Nənə irəha pam səməme hərapi həuvehe mhəsanɨn. ");
INSERT INTO tnk_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ia nəpɨn nəha Farisi me mɨne nahatən me səvəi Loa həier ia Jerusalem, mhəuvehe tɨ Iesu, mhəni mə, ");
INSERT INTO tnk_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Rəfo nərmama me səim kamhərui nɨtətə səvəi kaha kupwən me? Nəpɨn hani nari, həpkukupwən mhə mhərkwerɨɡ.” ");
INSERT INTO tnk_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Rəfo kɨmiaha hiamətefi nəɡkiariien səvəi Kumwesən mə tihesi pen narəien səkɨmiaha? ");
INSERT INTO tnk_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kumwesən rɨməni nəkwan mə, ‘Tikɨsiai tata mɨne mama səim.’ In rɨməni mwi mə, ‘Trɨni mɨnuə iərmama riti rani ərəha tata mɨne mama səvənhi, tukaməkeikei kousi əpune in.’ ");
INSERT INTO tnk_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mətə kɨmiaha hiaməni mə, ‘Trɨni mɨnuə iərmama riti rɨni pen tɨ səvənhi tata mɨne mama mə, Səiou narimnari me sə trasitu ia kɨmirau ro ikinan i səvəi Kumwesən, ");
INSERT INTO tnk_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ramasan mə in trəpwəh nuvei penien nari riti m səvənhi tata mɨsiai in irə.’ Ia noien nəha kɨmiaha hiamousi raka nəɡkiariien səvəi Kumwesən ia narəien səkɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kɨmiaha kəuətkəsuə me. Fwe kupwən, Profet Aesea rɨməni atukwatukw kɨmiaha, mɨni mə, ");
INSERT INTO tnk_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Nərmama me i kamhəsiai iou ia tərhunraha, mətə rerɨnraha rəmak isipwɨn tukw iou. ");
INSERT INTO tnk_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kamhəfwaki auər a miou. Nəpɨn kamhahatən nərmama, həni mə kamhahatən nəɡkiariien səiou, mətə rekəm. Kamhahatən nəɡkiariien sə ruku pen a tɨ nərmama.’” ");
INSERT INTO tnk_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nənə Iesu rəkwein nərmama me həuvehe tukwe. Rɨni pen tɨ nirəha i mə, “Kɨmiaha tihətərɨɡ amasan ia nirak, mhəukurən nəfe takɨni. ");
INSERT INTO tnk_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Rɨpko mhə nəri sə ruvnimwə ia nəkwai iərmama ramo in rəmkemɨk ia nəmri Kumwesən, mətə nəri sə ruku pen ia nəkwan mamier in nə ramo in rəmkemɨk ia nəmri Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nənə nərmama me səvənhi həuvehe, mhəni pen tukwe in mə, “Ikukurən mə nəpɨn Farisi me həreɡi nəɡkiariien nəha niemaha rəpi irəha.” ");
INSERT INTO tnk_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Mɨreɡi Iesu rɨni mə, “Nei me pam səməme Tata səiou fwe ia neiai rɨpkəpwei mhə tɨ nəpɨn riti keivi utə irəha. ");
INSERT INTO tnk_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kɨmiaha tihəpwəh irəha. Irəha nərmama kamhəiri pen nərmama ia suatuk sə tuhesi, mətə nəmrɨnraha rɨfwə. Trɨni mɨnuə iərmama riti nənimen rɨfwə mamiri pen iərmama riti mwi nənimen rɨfwə ia suatuk sə trouesi, irau pəri trouivə irapw ia ruei tənə.” ");
INSERT INTO tnk_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Mətə Pita rɨni pen tukwe in mə, “Ni pehe ro tukumaha i nɨpwrai nusipekɨnien nəha ikɨməni.” ");
INSERT INTO tnk_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Mɨreɡi Iesu rɨni mə, “Kɨmiaha mwi hiamreirei ihi? ");
INSERT INTO tnk_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Hiəpkukurən mhə mə nəfe nari revən ia nəkwai iərmama, ramevən ia tɨpwɨn, mamier. ");
INSERT INTO tnk_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Mətə nəri sə ramier ia nəkwai iərmama raku pen ia rerɨn fwe imwə nənə in nə ramo in rəmkemɨk ia nəmri Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Iakani iamɨnhi irə tɨ nəri nə mə nətərɨɡien ərəha ruku pen ia reri iərmama fwe imwə, mamier: nousi əpuneien iərmama, nakresien pran səvəi iərməpə, noien sə nərman mɨne nɨpran kamhəiri əpnapen irəha me, nakresien, neikuəien, nɨni ərəhaien iərmama. ");
INSERT INTO tnk_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Noien me i ramo iərmama rəmkemɨk ia nəmri Kumwesən. Mətə trɨni mɨnuə iərmama rɨpkərkwerɨɡ mhə, maməni nari, noien nəha ko rɨpko mhə in ruvehe məmkemɨk ia nəmri Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Nənə Iesu rier, məpwəh kwopun nəha, mevən ipaka tɨ taon mi nəha Taea mɨne Saeton. ");
INSERT INTO tnk_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nənə təkwtəkwuni a pran Kenan riti sə ramarə ia kwopun nəha ruvehe, mamasək, mamɨni mə, “Iərɨmənu, kwənəkwus səvəi Kiɡ Tevɨt, tikapi tukw iou! Iəremhə ramarə ia prən ouihi səiou, mamo in raməmisə pɨk!” ");
INSERT INTO tnk_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mətə Iesu rəpwəh nɨniien nəɡkiariien riti tɨ prən nəha. Nənə nərmama me səvənhi həuvehe mamhəɡkiari min, mhəni mhənuə, “Ərhi pen prən i ramevən, tɨ nəri nə mə rakurirə kɨtaha, mamasək.” ");
INSERT INTO tnk_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Mɨreɡi Iesu rɨni mə, “Kumwesən rərhi pehe iou mə takuvehe əpa tɨ nəkur Isrel. Irəha həmwhen ia sipsip me hənəruei.” ");
INSERT INTO tnk_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mətə prən nəha ruvehe mɨnɨmwi nukurhun mi ia nənimen, mɨni mə, “Iərɨmənu. Tikasitu ia nirak.” ");
INSERT INTO tnk_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Mɨreɡi Iesu rɨni mə, “Rəpwəh namasanien mə takuvehi nəveɡɨnien sənəi nəkwərhakwərha mərarki pen i m kuri me.” ");
INSERT INTO tnk_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mɨreɡi prən i rɨni mə, “Nɨpərhienien, Iərɨmənu. Mətə kuri me mwi kamhani nɨmwəkmwəki nəveɡɨnien sə raməsas irapw ia ruei tepol səvəi iəmə asori səvənraha.” ");
INSERT INTO tnk_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Mɨreɡi Iesu rɨni pen tukwe in mə, “Prən i ikamahatətə pərhien. Pwəh iako mik rəmwhen sə ikokeikei.” Təkwtəkwuni a mwi prən ouihi səvənhi ruvehe məsanɨn. ");
INSERT INTO tnk_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iesu rier ia kwopun nəha, mavən ia nɨkarkare nui asori Kalili, mevən mutə ia təkuər riti məkure fwe ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nənə nərmama həpɨk həuvehe tukwe, mamhəuvehi nərmama me səməme kamhemhə. Nepwɨn nɨsunraha rərfe. Nepwɨn nənimenraha rɨfwə. Nepwɨn nemhəien rouraha nɨpəri nɨpwranraha. Nepwɨn ho iəpou ko həpwəh nəɡkiariien. Həuvehi mwi nərmama həpɨk mwi, mhəmri pen irəha ia nɨsui Iesu, nənə in ro irəha həuvehe mhəsanɨn. ");
INSERT INTO tnk_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ia nəpɨn nəha nəpou me haməɡkiari. Nərmama nemhəien rouraha nɨpəri nɨpwranraha həuvehe mhəsanɨn. Nərmama səməme nɨsunraha rərfe, həvi atukw a nɨsunraha mamhavən. Nənə nərmama nənimenraha rɨfwə hətui mamhətə nari. Nəpɨn nərmama me hətoni, nənimenraha rier. Nənə həɡnəɡɨni Kumwesən səvəi nəkur Isrel. ");
INSERT INTO tnk_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ia nəpɨn nəha Iesu rəkwein nərmama me səvənhi həuvehe. Rɨni pen tɨ nirəha i mə, “Rerɨk rərkwəpɨr tɨ nərmama me i. Hənarə raka nəpɨn kahar kɨtaha mɨnraha, nənə sənənraha nəveɡɨnien ruvəiwən. Iakəpwəh no keikeiien mə takərhi pen irəha fwe imwənraha nəpɨn nukumhə ramahi irəha. Rərəha mə kamhəuvən nəmrɨnraha rɨpitəv həmwei ia suatuk.” ");
INSERT INTO tnk_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Mɨreɡi nərmama me səvənhi həni pen tukwe in mə, “Tsəuvehi bred pəku rəmwhen tsəkwmənu nərmama me i? Kwa həpɨk anan. Kɨtaha samarə ia kwopun nəveɡɨnien riwən ikɨn.” ");
INSERT INTO tnk_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Sənəmiaha bred kevə?” Mɨreɡi həni mə, “Sefen mɨne kwopnəti nəmu me nepwɨn mwi fwe ikɨn.” ");
INSERT INTO tnk_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Iesu rɨni nəkwan mə nərmama me nəha sənənraha nəveɡɨnien riwən tuhəkure ia tɨprənə. ");
INSERT INTO tnk_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nənə ruvehi bred nəha sefen mɨne kwopnəti nəmu me, məfwaki mɨni vivi Kumwesən tukwe. Nəpɨn rəfwaki pam, maməkwsen bred me, mauvei pen m nərmama me səvənhi, həpeki pen m nərmama me. ");
INSERT INTO tnk_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nərmama me pam hani nari tɨpwɨnraha rəsisi. Nəpɨn hənani raka nari, həvai pen nɨpərpəri bred mɨne nəmu me hənani mhəpwəh rukuər ia tənərɨpw sefen. ");
INSERT INTO tnk_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nərmama me nəha hani nari həpɨk anan nərman nɨpran mɨne nəkwərhakwərha. Kəvsini nərman me əpa irəha pam fo-taosen. ");
INSERT INTO tnk_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nənə Iesu rərhi pen irəha kamhəuvən imwənraha me. Kurirə irə rəputə ia nɨtətə ouihi riti, mamevən fwe kwopun riti nəɡhɨn nə Makatan. ");
INSERT INTO tnk_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ia nəpɨn nəha Farisi me mɨne Satusi me həuvehe, mhəres pen Iesu i mə, “Ko iko ro nɨmtətien riti sə ruku pen ia neiai pwəh iahətoni mhəukurən mə ik pərhien Kumwesən rərhi pehe ik?” ");
INSERT INTO tnk_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Mɨreɡi Iesu rɨni mə, “Nəpɨn meri na trivə, kɨmiaha hiəni mə, ‘Rosi trakwakwi rukwəsikər tɨ nəri nə mə nɨmaɡouaɡou rəruerəv.’ ");
INSERT INTO tnk_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nənə ia nəpnəpɨn kɨmiaha hiəni mə, ‘Rosi nesən trauər ipwet tɨ nəri nə mə nɨmaɡouaɡou rəruerəv, məpuə.’ Kɨmiaha hiəukurən nətəien nɨmaɡouaɡou, nənə mhəukurən nəfe nari nɨmaɡouaɡou ramahatən pen. Mətə rəfo hiəreirei nɨpwrai nɨmtətien me i kamo ipwet mɨne? ");
INSERT INTO tnk_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kɨmiaha nərmama ipwet mɨne hiamətui a nɨmtətien tɨ nəri nə mə noien səkɨmiaha rikou. Kɨmiaha hiənəpwəh Kumwesən rəmwhen pran sə rəpwəh iərman səvənhi mamesi pen iərməpə. Kumwesən trəpwəh nuvei peheien nɨmtətien riti mwi m kɨmiaha, mətə nɨmtətien əpa səvəi Profet Jona.” Iesu rɨni nəɡkiariien nəha, məpwəh irəha, mamevən. ");
INSERT INTO tnk_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ia nəpɨn nəha Iesu revən irəha nərmama me səvənhi, mhəuvən mhəpi sɨmwɨn ia nui asori. Nərmama me səvənhi hənenouenou mə tuhəuvehi bred. Nəpɨn irəha həuvarei ia nɨkaren pen, ");
INSERT INTO tnk_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Iesu rɨni pen tɨ nirəha i mə, “Kɨmiaha tihətui amasan, mhəsiari tɨ yis səvəi Farisi me mɨne Satusi me.” ");
INSERT INTO tnk_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Mɨreɡi irəha hənaməɡkiari mɨnraha me i mə, “Rosi raməɡkiari iamɨnhi irə tɨ nəri nə mə kɨtaha sənenouenou bred uə?” ");
INSERT INTO tnk_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Nənə nəpɨn Iesu rɨreɡi, rɨni mə, “Kɨmiaha nahatətəien səkɨmiaha rɨpkɨskai mhə. Rəfo hiaməɡkiari m kɨmiaha me mə sənəmiaha bred riwən? ");
INSERT INTO tnk_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kɨmiaha hiəreirei ihi? Rerɨmiaha rɨpkrhi mhə bred krirum sə iakɨnəkwməni nərmama faef-taosen irə mɨne tənərɨpw kevə hiəməuvehi kurirə? ");
INSERT INTO tnk_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Rerɨmiaha rɨpkrhi mhə bred sefen sə iakɨnəkwməni nərmama fo-taosen irə mɨne tənərɨpw kevə hiəməuvehi kurirə? ");
INSERT INTO tnk_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Rəfo həreirei nɨpwrai nəɡkiariien səiou? Iapkəɡkiari mhə ia bred, mətə iakamɨni mə kɨmiaha tihaməsiari tɨ yis səvəi Farisi me mɨne Satusi me.” ");
INSERT INTO tnk_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ia nəpɨn nəha nərmama me səvəi Iesu həuvehe mhəukurən mə Iesu rɨpkɨni mhə mə tuhəsiari tɨ yis səvəi bred, mətə tuhəsiari tɨ nahatənien səvəi Farisi me mɨne Satusi me. ");
INSERT INTO tnk_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nəpɨn Iesu ruvehe ipaka tɨ taon nəha Sisaria Filipae, rəres pen nərmama me səvənhi mə, “Nərmama kamhəni iou, Iəməti Iərmama, mə iou sin?” ");
INSERT INTO tnk_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Mɨreɡi həni mə, “Nərmama nepwɨn kamhəni ik mə Jon Paptaes. Nepwɨn kamhəni ik mə Profet Elaeja. Nepwɨn mwi kamhəni ik mə Jeremaea uə profet riti mwi fwe kupwən.” ");
INSERT INTO tnk_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Mətə kɨmiaha hiaməni mə iou sin?” ");
INSERT INTO tnk_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Mɨreɡi Saemon Pita rɨni mə, “Ik Kristo. Kumwesən sə ramɨru, tɨni nə ik.” ");
INSERT INTO tnk_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Mɨreɡi Iesu rɨni pen tukwe in mə, “Saemon, tɨni Jon, rerɨm traɡien! Rɨpko mhə iərmama riti rahatən ik irə mə tikukurən nəri i, mətə Tata səiou fwe ia neiai rahatən ik irə ikukurən. ");
INSERT INTO tnk_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nənə iakani pehe tukw ik i mə ik nə Pita. Nɨpwrai nəhaɡ nəha mə kəpwier. Ia təkure kəpwier i takuvrhəkɨn nakalasia me səiou rəmwhen sə kauvrhəkɨn pen nimwə irə, nɨskaiien səvəi nemhəien ko rɨpkouraha mhə irəha. ");
INSERT INTO tnk_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Takuvei pehe ki me səvəi nɨtətə ia neiai mik. Nəfe nari ikərihi tərini ia tɨprənə i, tukərihi tərini fwe ia neiai. Nəfe nari ikɨfi raka ia tɨprənə i, tukɨfi raka fwe ia neiai.” ");
INSERT INTO tnk_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nənə Iesu rɨnise pen əknekɨn tɨ nərmama me səvənhi mə, “Kɨmiaha tihəpwəh nɨniien tɨ iərmama riti mə iou Kristo.” ");
INSERT INTO tnk_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ia nəpɨn nəha mamevən, Iesu rɨnamahatən nərmama me səvənhi mə, “Takaməkeikei mevən fwe Jerusalem. Nəmə asori me mɨne pris asori me mɨne nahatən me səvəi Loa tuho nəmisəien me rɨpɨk ia nirak, mhousi əpune iou. Mətə ia nəpɨn səro kahar irə takətui mwi.” ");
INSERT INTO tnk_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ia nəpɨn nəha Pita riri raka Iesu ia nɨkarenraha, mɨnanise pen tukwe in mə, “Iərɨmənu, pwəh Kumwesən trapi tukw ik, məpwəh nəseniien nərmama tuho noien nəha ia niram ia nəpɨn riti.” ");
INSERT INTO tnk_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Mətə Iesu ruvsini, mɨni pen tɨ Pita i mə, “Setan, evən ia təkutak! Ikaməmwur mə tiko iakapəti mɨmwei iamɨnhi irə tɨ nəri nə mə nətərɨɡien səim rɨpkesi pen mhə nətərɨɡien səvəi Kumwesən, mətə ikamesi pen a nətərɨɡien səvəi nərmama.” ");
INSERT INTO tnk_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nənə Iesu rɨni pen tɨ nərmama me səvənhi mə, “Iərmama sə rokeikei mə truvehe mo iərmama riti səiou traməkeikei məpwəh nətərɨɡien səvənhi, muvehi utə nei kamarkuaui səvənhi, məvrani mukurirə iou. ");
INSERT INTO tnk_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Iərmama sə rokeikei mə trəkwtəmhiri nɨmɨruien səvənhi trarfai irə, mətə iərmama sə traraka ia nɨmɨruien səvənhi tukw iou truvehi nɨmɨruien rerɨn. ");
INSERT INTO tnk_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Trɨni mɨnuə iərmama riti rɨpeki pam narimnari me ia tɨprənə i mo səvənhi i, nənə kurirə ikɨn remhə, mətə rɨpkuvehi mhə nɨmɨruien rerɨn, noien nəha trəfasitu irə? Uə iərmama truvei pen nəfe mərpwɨn tai nɨmɨruien səvənhi? ");
INSERT INTO tnk_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Iou Iəməti Iərmama takuvehe ia nɨskaiien səvəi Tata səiou kɨmaha naɡelo me səiou. Ia nəpɨn nəha takərpwɨn noien səvəi nərmama me kuatia kuatia. Nərpwɨnien sə takuvei pen mɨnraha tresi pen a nəfe nari irəha həno. ");
INSERT INTO tnk_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Iakani nɨpərhienien tukumiaha i nərmama nepwɨn kamhərer ia kwopun i tuhəpkemhə mhə meste tuhətoni iou, Iəməti Iərmama, iakauvehe rəmwhen ia kiɡ mə takərɨmənu ia nɨtətə səiou.” ");
INSERT INTO tnk_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nəpɨn sikis rukurau, nənə Iesu riri əpa Pita mɨne Jemes mɨne piəvni Jon, həutə parei ia təkuər əpwəmwɨs riti. ");
INSERT INTO tnk_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ia kwopun nəha irəhar harətoni ia nənimenrahar nɨpwrai Iesu ruvehe mopə. Nənimen rəhiapw rəmwhen ia meri. Tɨnari səvənhi ruvehe məpsan rəmwhen ia nukuraanien. ");
INSERT INTO tnk_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Təkwtəkwuni a irəhar harətoni Profet Elaeja mɨne Moses krouier pehe, rouəɡkiari irəhar Iesu. ");
INSERT INTO tnk_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nənə Pita rɨni pen tɨ Iesu i mə, “Iərɨmənu. Ramasan mə kɨmrahar iaharuvehe i. Mə ikokeikei tako tənimwə kahar, riti səim, riti səvəi Moses, riti səvəi Profet Elaeja.” ");
INSERT INTO tnk_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita raməɡkiari ihi, təkwtəkwuni a mwi nəpuə əpsan riti ruvehe muveɡi irəha. Reri Kumwesən ruku pen ikɨn, mɨni mə, “In nəha nərɨk keikei. Rerɨk raɡien tukwe. Tihətərɨɡ in.” ");
INSERT INTO tnk_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nəpɨn Pita mɨne Jon mɨne Jemes harreɡi nəɡkiariien nəha, harhekɨr, mharmwei, mharnɨmwi irapw nənimenrahar ia tɨprənə. ");
INSERT INTO tnk_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Mətə Iesu ruvehe mɨrapi irəhar, mɨni mə, “Harərer, mharəpwəh nehekɨrien.” ");
INSERT INTO tnk_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nənə irəhar harəkwətə, harəpwəh nətoniien Moses mɨne Profet Elaeja, mətə Iesu əpa irəha min. ");
INSERT INTO tnk_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nəpɨn irəha kamheiwaiu pehe ia təkuər, Iesu rɨni pen tɨ nirəhar i mə, “Kɨmirəhar tiharəpwəh nɨniien tɨ iərmama riti nɨmtətien nəha hiarnətoni, meste iou, Iəməti Iərmama, iakətui mwi ia nemhəien səiou.” ");
INSERT INTO tnk_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nənə Pita mɨne Jemes mɨne Jon harəres pen in i mə, “Rəfo nahatən me səvəi Loa kamhəni mə Profet Elaeja traməkeikei mukupwən muvehe?” ");
INSERT INTO tnk_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Mɨreɡi Iesu rɨni mə, “Nɨpərhienien. Profet Elaeja truvehe məmri amasan pam narimnari me rəmwhen ia sə fwe kupwən. ");
INSERT INTO tnk_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mətə iou iakani pehe tukumirəhar i mə Profet Elaeja ruvəuvehe raka nənə nərmama me həpkətə sas mhə in, mətə hesi pen nətərɨɡien səvənraha, mho rərəha irə. Iou mwi, Iəməti Iərmama, takaməkeikei mevən ia rəɡɨnraha, nənə irəha tuho nəmisəien miou.” ");
INSERT INTO tnk_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ia nəpɨn nəha Pita mɨne Jemes mɨne Jon haruvehe, mharukurən mə Iesu raməɡkiari ia Jon Paptaes. ");
INSERT INTO tnk_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nəpɨn irəha hərərɨɡ pehe mwi tɨ nərmama me, iərmama riti ruvehe tɨ Iesu, mɨnɨmwi nukurhun mi ia nənimen, ");
INSERT INTO tnk_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","mɨni mə, “Iərɨmənu. Tikapi tukw iou, masitu ia nərɨk. Nemhəien i nɨkəvan ro in. In raməmisə pɨk. Nəpɨn rɨpɨk ramwei pen ia napw, mamwei pen ia nui. ");
INSERT INTO tnk_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Iakuvehi in muvehe tɨ nərmama me səim, mətə irəha ko həpko mhə in ruvehe məsanɨn.” ");
INSERT INTO tnk_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Mɨreɡi Iesu rɨni mə, “Kɨmiaha nəkur ipwet mɨne nahatətəien səkɨmiaha riwən. Noien səkɨmiaha rikou. Tsarə kɨtaha miou mesite nəfe nəpɨn? Tɨnesən mɨne iakapwɨs kɨmiaha? Kɨmiaha tihəuvən mhəuvehi iəkunouihi nəha mhəuvehi mhəuvehe.” ");
INSERT INTO tnk_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nəpɨn həuvehi mhəuvehe, Iesu rɨnise pen tɨ iəremhə i mə, “Tikier ia iəkunouihi i.” Nənə təkwtəkwuni a rier, iəkunouihi nəha ruvehe məsanɨn. ");
INSERT INTO tnk_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kurirə irə nərmama me səvəi Iesu həuvehe tɨ Iesu, mhəres pen in əpa mə, “Rəfo kɨmaha iahəreirei nəkoui irapwien nənɨmwɨn ərəha nəha?” ");
INSERT INTO tnk_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Tɨ nəri nə mə nahatətəien səkɨmiaha rɨpkɨskai mhə. Iakani nɨpərhienien tukumiaha i trɨni mɨnuə kɨmiaha hiahatətə pərhien ia Kumwesən, nəri auər a mə nahatətəien nəha səkɨmiaha rouihi anan rəmwhen ia kwənuni nei nəha mastat, mətə hiəukurən nɨniien tɨ təkuər i mə, ‘Təkuər i tikaraka ia kwopun i mevən məkure pen fwe,’ nənə trier mevən. Narimnari me pam trɨməru tukumiaha.” ");
INSERT INTO tnk_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nəpɨn nərmama me səvəi Iesu housəsɨmwɨn irəha me ia tənə Kalili, in rɨni pen tɨ nirəha i mə, “Trɨpko mhə tui kuvei pen iou, Iəməti Iərmama, ia rəɡi nərmama. ");
INSERT INTO tnk_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Irəha tuhousi əpune iou, nənə Kumwesən tro iakətui mwi ia nemhəien səiou ia nəpɨn səro kahar irə.” Nənə nərmama me səvənhi həreɡi rərəha anan. ");
INSERT INTO tnk_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nəpɨn Iesu mɨne nərmama səvənhi me həuvehe ia Kapaneam, nərmama səməme kamhəuvehi takis səvəi nimwə səvəi Kumwesən həuvehe tɨ Pita, mhəni mə, “Rosi iahatən səkɨmiaha rɨpkərəku mhə takis səvəi nimwə səvəi Kumwesən uə?” ");
INSERT INTO tnk_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Mɨreɡi Pita rɨni mə, “Ouəh. In ramərəku.” Nəpɨn Pita revən muvnimwə, Iesu rukupwən məɡkiari min, mɨni mə, “Saemon, ikaməfətərɨɡ irə? Kiɡ me ia tɨprənə i kamhəkeikei m nəfe nərmama me mə tuhərəku pen nəmri takis mɨnraha, tɨnɨnraha me uə nərməpə?” ");
INSERT INTO tnk_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Mɨreɡi Pita rɨni mə, “Nərməpə.” Mɨreɡi Iesu rɨni pen tukwe in mə, “Ikani nɨpərhienien. Nɨpwnəti kiɡ me həpkərəku mhə nəmri takis, ");
INSERT INTO tnk_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","mətə pwəh sərəku pen rərəha kɨtaha tso niemaha rəpi nərmama me i səməme kamhəuvehi takis. Tikevən fwe ia nui asori, mosəperaha. Nəmu sə rukupwən məɡher ia kwərvinari, tikɨvi utə, məti pen ia nəkwan, nənə tikətoni silin riti. Tikuvehi muvei pen mərəku pen takis səkrau mɨnraha.” ");
INSERT INTO tnk_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ia nəpɨn nəha nərmama me səvəi Iesu həuvehe tukwe in, mhəni mə, “Ia nɨtətə ia neiai sin rasori məpi raka nərmama me nepwɨn?” ");
INSERT INTO tnk_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nənə Iesu rəkwein iəkunouihi riti ruvehe, rərpwi irapw in ia kurkwanraha, ");
INSERT INTO tnk_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","nənə mɨni mə, “Iakani nɨpərhienien tukumiaha i mə kɨmiaha tihaməkeikei mhərari mhəuvehe mhəmwhen ia nəkwərhakwərha me. Mə hiəpwəh tihəpkuvnimwə mhə ia nɨtətə ia neiai ia nəpɨn riti. ");
INSERT INTO tnk_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Iərmama sə treiwaiu rəmwhen ia iəkunouihi, mɨpkəfiəutə mhə in, in rasori məpi raka nərmama me nepwɨn ia nɨtətə ia neiai. ");
INSERT INTO tnk_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Iərmama sə trəsevər ia rerɨn tɨ iəkunouihi riti sə ro iamɨnhi ia nəɡhɨk rəmwhen mə raməsevər mwi ia rerɨn tukwe iou.” ");
INSERT INTO tnk_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Nəkwərhakwərha me i səməme kamhahatətə ia nirak, trɨni mɨnuə iərmama riti ro riti rɨmwei ia nərəhaien, Kumwesən trərpwɨn noien ərəha səvənhi. Iərmama nəha trɨreɡi rərəha anan məpi raka kərihi pen kəruəterei asori ia nɨpətəkinuan kosə irapw i ia təmwei təsi. ");
INSERT INTO tnk_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Trərəha anan tɨ nərmama ia tɨprənə i tɨ nəri nə mə narimnari me kamhəuvehe tuho irəha həmwei ia nərəhaien. Narimnari me i tuhaməkeikei mhəuvehe, mətə trərəha anan tɨ iərmama sə truvehi narimnari me i muvehe. ");
INSERT INTO tnk_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Mə rəɡɨm uə nɨsum ramo ikamwei ia nərəhaien, tikərai raka, mərarki. Mə rəɡɨm rɨpɨp uə nɨsɨm rɨpɨp mətə ikuvehi nɨmɨruien, ramasan pɨk tukw ik. Rərəha mə rəɡɨm kəru uə nɨsum kəru mətə tukərarki pen ik ia kwopun napw asori rauək rerɨn ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mə nənimem ramo ikamwei ia nərəhaien, tikukumwiri raka, mərarki. Mə nənimem kuatia mətə ikuvehi nɨmɨruien, ramasan pɨk tukw ik. Rərəha mə nənimem kəru mətə tukərarki pen ik ia kwopun napw asori rauək ikɨn.” ");
INSERT INTO tnk_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Nənə Iesu rɨni mə, “Kɨmiaha tihətui amasan tukumiaha me mhəpwəh noien nəri auər a ia nəkwərhakwərha me i riti. Iakani pehe tukumiaha i mə fwe ia neiai naɡelo me səvənraha kamhətə rerɨn nəmri Tata səiou sə ramarə fwe ia neiai. ");
INSERT INTO tnk_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Iou, Iəməti Iərmama, iakuvehe mə takuvehimɨru nərmama səməme kamhəruei. ");
INSERT INTO tnk_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Kɨmiaha hiaməfətərɨɡ irə? Trɨni mɨnuə iərmama riti sipsip me səvənhi irəha pam hantret, nənə riti ia nirəha rəruei, trəfo pen irə? In trəpwəh naenti-naen kamhani nurhi ia təkuər, mevən mamətui sə nəha rɨnəruei. ");
INSERT INTO tnk_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nənə trɨni mɨnuə rətoni, iakamɨni nɨpərhienien tukumiaha i mə rerɨn raɡien pɨk tɨ sipsip nəha məpi raka naenti-naen səməme həpkəruei mhə. ");
INSERT INTO tnk_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ia noien nəha rəmwhen a mwi Tata səkɨmiaha ia neiai rəpwəh nokeikeiien mə nəkwərhakwərha me i riti trəruei.” ");
INSERT INTO tnk_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Trɨni mɨnuə piam ro rərəha ia niram, evən mətoni kɨmirau əpa. Nənə ikɨni pen nəfe rɨno rərəha. Trɨni mɨnuə rətərɨɡ ik, nəɡkiariien səim tro piam rɨrərɨɡ pehe səkɨmirau min tramasan. ");
INSERT INTO tnk_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mətə trɨni mɨnuə rəpwəh nətərɨɡien ik, iri iərmama kuatia uə kəru mharevən mwi pwəh irau kroureɡi rouətoni nəɡkiariien me pam nəha ikɨni pen tɨ piam ro nɨpərhienien. ");
INSERT INTO tnk_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Trɨni mɨnuə rerɨn rəpwəh nətərɨɡien irəha, ni irapw tɨ nakalasia me səvəi nəfwakiien. Nənə trɨni mɨnuə rəpwəh mwi nətərɨɡien irəha, tiko irə rəmwhen iərmama sə rɨreirei Kumwesən uə iərmama sə kamərəku pen takis min. ");
INSERT INTO tnk_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Iakani nɨpərhienien tukumiaha i nəfe nari tihərihi tərini ia tɨprənə i tukərihi tərini fwe ia neiai, nənə nəfe nari tihəfi raka ia tɨprənə i tukɨfi raka fwe ia neiai. ");
INSERT INTO tnk_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Iakani pehe mwi nɨpərhienien tukumiaha i trɨni mɨnuə kəru ia kɨmiaha ia tɨprənə i krouni sɨmwɨn nari riti, rouəres i, Tata səiou ia neiai in tro nəkwanrau, ");
INSERT INTO tnk_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","tɨ nəri nə mə pəku ikɨn iərmama kəru uə kahar harousəsɨmwɨn ia nəɡhɨk, iakamarə tɨ nirəha ia kwopun nəha.” ");
INSERT INTO tnk_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nənə Pita rutə pehe mɨni pen tɨ Iesu i mə, “Iərɨmənu. Trɨni mɨnuə piak ramo noien ərəha miou, nəpɨn kevə takenouenou i? Rosi sefen uə?” ");
INSERT INTO tnk_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Mɨreɡi Iesu rɨni mə, “Iou iapkɨni pehe mhə tukw ik i mə tikenouenou nərəhaien me səvəi piam m sefen, mətə tikenouenou nərəhaien me səvənhi nəpɨn me pam. ");
INSERT INTO tnk_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Iakamɨni iamɨnhi irə tɨ nəri nə mə nɨtətə ia neiai rəmwhen ia iəmə asori riti sə rokeikei mə nərmama me i kamho tukwini nari min tuhərəku pam kaon me səvənraha sə in rɨməuvei pen mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nəpɨn rəkwein irəha mə tuhəuvehe, həuvehi riti ia nirəha mhəuvehe. Kaon səvənhi rasori pɨk anan. ");
INSERT INTO tnk_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ko rɨpkərəku mhə. Ro pen iəmə asori səvənhi rɨni mə tukəmri pen nəmri nari m iəmə i mɨne pran səvənhi mɨne nɨpwnətɨn me mɨne narimnari me pam səvənhi. In truvehi mane ia nirəha, mərəku kaon səvəi iəmə nəha. ");
INSERT INTO tnk_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ia nəpɨn nəha iəmə nəha sə ramo tukwini nari m iəmə asori rɨnɨmwi nukurhun mi, mamasək, mɨni pen tɨ iəmə asori səvənhi mə, ‘Tikapi tukw iou, muvei pehe nəpɨn miou, nənə takərəku pehe pam mik.’ ");
INSERT INTO tnk_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nənə iəmə asori rerɨn rərkwəpɨr tɨ iəmə i ramo tukwini nari min. Ro pen in renouenou kaon səvənhi, mɨni mə trəpwəh nərəkuien, məseni in rier mamevən. ");
INSERT INTO tnk_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Mətə nəpɨn iəmə nəha rier irapw, rətoni iərmama riti sə ramo tukwini nari irau min. Kaon riti səvənhi ramarə tukwe in. Rouihi pɨk anan. Nənə in ruvehi iərmama nəha, məkwtəmhiri nɨpətəkinuan, mɨni mə, ‘Ərəku pehe pam səim kaon.’ ");
INSERT INTO tnk_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nənə iərmama nəha ramo tukwini nari irau min rɨmwei irapw, mamasək, mɨni pen tukwe in mə, ‘Tikapi tukw iou, muvei pehe nəpɨn miou, nənə takərəku pehe pam mik.’ ");
INSERT INTO tnk_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Mətə iəmə nəha iəmə asori rɨnenouenou kaon səvənhi rəpwəh nokeikeiien. In revən muvehi iərmama nəha muvehi puvnimwə ia kalapus mə trarə meste trərəku pam kaon səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nəpɨn nərmama nepwɨn səməme kamho tukwini nari m iəmə asori hətoni noien nəha, həreɡi rərəha anan. Həuvən mhəni pen tɨ iəmə asori səvənraha narimnari me pam iəmə nəha rɨno. ");
INSERT INTO tnk_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ro iamɨnhi irə iəmə asori rəkwein iərmama nəha ramo tukwini nari min ruvehe. Rɨni pen tukwe in mə, ‘Ik iəmə ərəha. Iakamo tukwini ərəha nari miou. Iakɨnenouenou kaon me pam səim, tɨ nəri nə mə ikɨnasək teɡɨn iou. ");
INSERT INTO tnk_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mətə rəfo ikəpwəh napiien tɨ iərmama nəha sə ramo tukwini nari miou kɨmirau min rəmwhen iou iakɨnapi tukw ik?’ ");
INSERT INTO tnk_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ro pen iəmə asori niemaha rəpi. In ruvehi puvnimwə iəmə nəha ia kalapus mə tuko nəmisəien min meste trərəku pam kaon səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ia noien nəha rəmwhen a mwi Tata səiou ia neiai tro ia kɨmiaha kuatia kuatia trɨni mɨnuə hiəpwəh nenouenouien nərəhaien səvəi piəvmiaha me ia rerɨmiaha.” ");
INSERT INTO tnk_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iesu rɨni pam nəɡkiariien me nəha, nənə məpwəh tənə Kalili, mier mevən ia tənə Jutia fwe ia nɨkare nui arɨs Jotan pen. ");
INSERT INTO tnk_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nərmama həpɨk həkurirə i. Nənə in ro səməme kamhemhə həuvehe mhəsanɨn ia kwopun nəha. ");
INSERT INTO tnk_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nənə Farisi me həuvehe tukwe in mhəres pen nari riti min mə tuhəreɡi ro Iesu mə trəfni irə. Irəha həni mə, “Ratukwatukw ia Loa səkɨtaha mə ko iərman riti rəpwəh səvənhi pran uə rekəm?” ");
INSERT INTO tnk_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Mɨreɡi Iesu rɨni mə, “Rosi kɨmiaha hiəpkəvsini raka mhə nəɡkiariien i ia Nəkukuə Ikinan rɨni mə fwe ia nukune narəien ‘Kumwesən rɨno iərmama kəru riti iərman riti pran,’ ");
INSERT INTO tnk_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","rarə mɨni mwi mə, ‘Ro iamɨnhi irə iərman traraka ia tata mɨne mama səvənhi, mevən rouarə pəri irau pran səvənhi, nənə irau trouvehe rouəmwhen ia nɨpwrai iərmama kuatia.’ ");
INSERT INTO tnk_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nəɡkiariien nəha rɨni mə iərman mɨne pran səvənhi krouəpwəh ihi noien iərmama kəru i, mətə krouvəuvehe rouəmwhen ia nɨpwrai iərmama kuatia. Tɨ nəri nə mə Kumwesən rɨrɨpɨn iərman mɨne pran səvənhi iamɨnhi irə, ro pen rɨpkatukwatukw mhə mə iərman trəpwəh səvənhi pran, mətefi narəien səvənrau.” ");
INSERT INTO tnk_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mɨreɡi Farisi me həni pen tɨ Iesu i mə, “Mə ro iamɨnhi irə rəfo Moses rɨməni mə iərman sə rokeikei mə trəpwəh pran səvənhi trɨrai nɨmwai nəkukuə m pran səvənhi rani mə in rɨnəpwəh in, nənə mərhi pen i ramevən?” ");
INSERT INTO tnk_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Moses rɨnəseni kɨmiaha mə tihəpwəh nɨpran me səkɨmiaha tɨ nəri nə mə kəmkapwəmiaha rɨskai, mətə fwe ia nukune narəien rɨpko mhə iamɨnhi irə. ");
INSERT INTO tnk_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Iou iakani pehe tukumiaha i iərman sə rəpwəh pran səvənhi miri pran əpə riti mwi ramo noien ərəha. Prən nəha in ramiri rɨpko mhə pran atukwatukw səvənhi. Mətə mə pran ramo əpnapen nari irau iərməpə, iərman səvəi prən nəha rukurən nəpwəhien in.” ");
INSERT INTO tnk_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nənə nərmama me səvəi Iesu həni pen tukwe in mə, “Trɨni mɨnuə ro iamɨnhi irə nəpɨn iərman rəpwəh pran səvənhi, ramasan mə iərman rəpwəh a niriien pran.” ");
INSERT INTO tnk_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Mətə Iesu rɨni pen tɨ nirəha i mə, “Rɨpko mhə nərmama me pam həukurən nuvehiien nəɡkiariien i səiou mharə irə, mətə səməme əpa Kumwesən rəsevər ia suatuk tukunraha irəha nəha tuhəuvehi mharə irə. ");
INSERT INTO tnk_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nərman nepwɨn tuhəpwəh niriien pran tɨ nəri nə mə hənətui pehe mwatukw səvənraha rəpou. Ro pen rerɨnraha riwən ia pran. Nərman nepwɨn tuhəpwəh niriien pran tɨ nəri nə mə kərai irəha rəmwhen kamo ia kau kərman. Ro pen rerɨnraha riwən ia pran. Nənə nərman me nepwɨn mwi tuhəpwəh niriien pran tɨ nəri nə mə irəha hokeikei nətərɨɡien səvənraha trəmak əpa ia nɨtətə ia neiai. Iərmama sə rukurən nuvehiien nəɡkiariien i səiou traməkeikei muvehi marə irə.” ");
INSERT INTO tnk_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nəpɨn riti nərmama nepwɨn kamhəuvehi nəkwərhakwərha me səvənraha mamhəuvehe tɨ Iesu mə trəmri utə rəɡɨn mi ia nirəha məfwaki. Nərmama me səvənhi hənise irəha. ");
INSERT INTO tnk_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Mətə Iesu rɨni mə, “Pwəh nɨpwnəti nəkwərhakwərha me həuvehe tukw iou. Tihəpwəh nɨniseien irəha tɨ nəri nə mə nɨtətə ia neiai səvəi nərmama səməme həmwhen ia nəkwərhakwərha me i.” ");
INSERT INTO tnk_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nənə Iesu rəmri utə rəɡɨn mi ia nirəha, məfwaki tɨ nirəha, nənə məpwəh irəha mamevən. ");
INSERT INTO tnk_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ia nəpɨn nəha iərmama riti ruvehe tɨ Iesu, mɨni mə, “Iahatən, nəfe noien amasan takaməkeikei mo mə takuvehi nɨmɨruien rerɨn?” ");
INSERT INTO tnk_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Mɨreɡi Iesu rɨni pen tukwe in mə, “Rəfo ikaməres iou nari riti ia nɨkaren səvəi noien amasan? Kumwesən əpa ramasan. Trɨni mɨnuə ikuə tikuvehi nɨmɨruien, ikesi pen loa me səvənhi.” ");
INSERT INTO tnk_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mɨreɡi iərmama nəha rɨni pen tukwe in mə, “Nəfe loa me takesi pen?” Mɨreɡi Iesu rɨni mə, “Tikəpwəh nousi əpuneien iərmama, məpwəh nakresien pran səvəi iərməpə, məpwəh nakresien, məpwəh neikuəien. ");
INSERT INTO tnk_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Tikaməkeikei mɨsiai səim tata mɨne mama, nənə mokeikei piam rəmwhen ikokeikei atukw a ik.” ");
INSERT INTO tnk_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mɨreɡi iərmama nəha rɨni pen tɨ Iesu i mə, “Loa me pam i iakamesi pen. Nəfe mwi nəha ikɨn takaməkeikei mo?” ");
INSERT INTO tnk_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Mɨreɡi Iesu rɨni pen tukwe in mə, “Trɨni mɨnuə ikuə tikuvehe matukwatukw pam, evən, məmri pen nəmri nari ia səim narimnari me. Nəpɨn kuvehi nənimen, tikuvehi mane, muvei pen m nərmama nautə səvənraha riwən. Nənə səim nautə trɨpɨk fwe ia neiai. Nəpɨn ikɨno pam, ikuvehe mukurirə iou.” ");
INSERT INTO tnk_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nəpɨn iərmama nəha rɨreɡi nəɡkiariien nəha, in rəpwəh Iesu, mamevən. Rerɨn rəpou tɨ nəri nə mə nautə səvənhi rasori. ");
INSERT INTO tnk_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ro iamɨnhi irə Iesu rɨni pen tɨ səvənhi nərmama me i mə, “Iakamɨni nɨpərhienien tukumiaha i rɨskai tɨ iərmama nautə səvənhi rasori mə truvnimwə ia nɨtətə ia neiai. ");
INSERT INTO tnk_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Takɨni mwi tukumiaha i. Iərmama nautə səvənhi rasori rəknekɨn tukwe in mə truvnimwə ia nɨtətə sə Kumwesən ramərɨmənu irə. Rəknekɨn məpi raka nərimɨru nəha kamel rasu pen ia ruei nitel mier.” ");
INSERT INTO tnk_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nəpɨn nərmama me səvənhi həreɡi nəɡkiariien nəha nənimenraha rier. Həni mə, “Mə rəknekɨn iamɨnhi, nɨsɨmə nəha ko həuvehi nɨmɨruien?” ");
INSERT INTO tnk_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Mətə Iesu rətə irəha mɨni mə, “Nəri nəha rəknekɨn iərmama ko rɨpko mhə, mətə Kumwesən rukurən noien. Narimnari me pam rɨməru tɨ Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Mɨreɡi Pita rɨni pen tukwe in mə, “Ətə ro. Kɨmaha iahənəpwəh pam narimnari me səkɨmaha mamhəkurirə ik. Ro iamɨnhi irə kɨmaha tahəuvehi nəfe?” ");
INSERT INTO tnk_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Iakamɨni nɨpərhienien tukumiaha i ia nɨtətə vi sə truvehe narimnari me pam tuhəuvehe mhərməvi. Ia nəpɨn nəha iou, Iəməti Iərmama, takəkure ia jea asori səiou mərɨmənu. Kɨmiaha i səməme hiaməkurirə iou ipwet mɨne tihəkure mwi ia jea me twelef mhərɨmənu ia kwənəkwus me twelef səvəi nəkur Isrel. ");
INSERT INTO tnk_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nənə nərmama me pam səməme hənəpwəh narimnari me səvənraha tɨ nəri nə mə irəha nərmama me səiou tuhəuvehi tain. Trɨni mɨnuə iərmama riti rəpwəh nimwə me, uə piəvni me, uə kɨtiriməni me, uə tata mɨne mama səvənhi, uə nəkwərhakwərha me səvənhi, uə tɨprənə səvənhi, in truvehi tain rasori mwi rəmwhen hantret, nənə muvehi mwi nɨmɨruien rerɨn. ");
INSERT INTO tnk_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mətə nərmama həpɨk kamhəkupwən tuhəuvehe mhəkurirə. Nənə səməme kamhəkurirə tuhəuvehe mhəkupwən.” ");
INSERT INTO tnk_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Iakamɨni iamɨnhi irə tɨ nəri nə mə suatuk sə Kumwesən ia neiai ramərɨmənu ia nɨtətə səvənhi rəmwhen iəmə asori riti nəmhien səvənhi rasori. Nəpɨn riti rier ia nəpnəpɨn anan mə trɨpeki nərmama nepwɨn tuhəmhu səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Rɨni mə irəha kuatia kuatia tuhəmhu nəpɨn pekɨn nənə mhəuvehi silin kuatia kɨno ia silva. Nənə nəpɨn irəha həseni raka, in rərhi pen irəha həuvən fwe səvənhi nəmhien. ");
INSERT INTO tnk_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nənə ia naen klok ia nəpnəpɨn, iəmə asori rier mwi, mətoni nərmama nepwɨn kamhərer ia kwopun kamo maket ikɨn, mhəpko mhə nari riti. ");
INSERT INTO tnk_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","In rɨni pen tɨ nirəha i mə, ‘Kɨmiaha mwi hiəuvən mhəmhu fwe nəmhien səiou, nənə nəfe nərəkuien atukwatukw səkɨmiaha takuvei pehe m kɨmiaha.’ ");
INSERT INTO tnk_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ro pen irəha həuvən. Ia twelef klok, nənə ia tri klok ia nəruarəv, iəmə asori nəha rɨrərɨɡ mo mwi nəɡhi nari riti a. ");
INSERT INTO tnk_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nənə ia faef klok ia nəruarəv in rier mwi, mətoni nərmama nepwɨn kamhərer ihi ia kwopun nəha. Nənə rɨni pen tɨ nirəha i mə, ‘Rəfo kɨmiaha hiamərer ia kwopun i nəpɨn pekɨn hiəpko mhə nari riti?’ ");
INSERT INTO tnk_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Mɨreɡi həni pen tukwe in mə, ‘Iərmama riwən rəkwein kɨmaha ipwet mə tahowok səvənhi.’ Mɨreɡi iəmə asori rɨni pen tɨ nirəha i mə, ‘Kɨmiaha mwi hiəuvən mhəmhu fwe ia nəmhien səiou.’ ");
INSERT INTO tnk_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nənə ia nəruarəv iəmə asori səvəi nəmhien rɨni pen tɨ iərmama səvənhi sə trərəku nərmama mə, ‘Əkwein nərmama me nəha kamhəmhu səiou həuvehe nənə ikuvei pen nərəkuien səvənraha. Tikukupwən ia səməme haməkurirə mhəuvehe men mo sampam ia səməme haməkupwən mhəuvehe.’ ");
INSERT INTO tnk_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nənə nəpɨn nərmama səməme iəmə asori rərhi pen irəha ia faef klok ia nəruarəv həuvehe, irəha kuatia kuatia həuvehi silin riti kɨno ia silva. ");
INSERT INTO tnk_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nəpɨn nərmama səməme iəmə asori rərhi pen irəha ia nəpnəpɨn anan həuvehe, rerɨnraha rɨrhi mə tuhəuvehi rasori mwi, mətə irəha kuatia kuatia həuvehi mwi silin riti kɨno ia silva. ");
INSERT INTO tnk_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Irəha həuvehi, rerɨnraha rɨpkaɡien mhə. Həni pen tɨ iəmə asori i ");
INSERT INTO tnk_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","mə, ‘Səməme i həuvehe kurirə həmhu aoa kuatia a, mətə kɨmaha iahəmhu nəpɨn pekɨn ia nukwəsikər asori. Rəfo ikərəku kɨmaha rəmnəmwhen a?’ ");
INSERT INTO tnk_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Mətə iəmə asori rɨni pen tɨ nirəha riti mə, ‘Iapko mhə nari riti rərəha ia niram. Ikɨnəseni raka mə tikəmhu nəpɨn pekɨn nənə muvehi silin kuatia kɨno ia silva. ");
INSERT INTO tnk_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Tikuvehi nərəkuien səim muvehi mamevən. Iərmama i ruvehe kurirə rerɨk raɡien tɨ nuvei penien nərəkuien səvənhi rəmwhen a mwi iakuvei pehe mik. ");
INSERT INTO tnk_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ikukurən mə ko iako nəfe iakokeikei mə tako ia mane səiou? Rəfo rerɨm ramrhi ərəha iou tɨ namasanien nəha iako mɨnraha?’” ");
INSERT INTO tnk_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nənə Iesu rɨni mə, “Ro iamɨnhi irə nərmama səməme həuvehe kupwən tuhəuvehe mhəkurirə, nənə səməme həuvehe kurirə tuhəuvehe mhəkupwən.” ");
INSERT INTO tnk_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Nəpɨn Iesu rautə mamevən fwe ia Jerusalem, riri raka əpa nərmama səvənhi twelef. Ia suatuk rɨni pen tɨ nirəha i mə, ");
INSERT INTO tnk_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Həreɡi ro. Kɨtaha saməutə mamhəuvən fwe ia Jerusalem. Ia kwopun nəha tukuvei pen iou, Iəməti Iərmama, ia rəɡi pris asori me mɨne nahatən me səvəi Loa. Irəha tuhəni mə takaməkeikei memhə. ");
INSERT INTO tnk_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Tuhəuvei pen iou ia rəɡi nərmama rɨpko mhə irəha nəkur Isrel. Nənə irəha tuharɨs əkenhɨn ia nirak, mhərisi iou, mhərui tərini pen iou ia nei kamarkuaui. Takemhə, nənə Kumwesən tro iakətui mwi ia nəpɨn səro kahar irə.” ");
INSERT INTO tnk_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ia nəpɨn nəha pran səvəi Sepeti riri tɨni mi kəru, muvehe tɨ Iesu, mɨnɨmwi nukurhun mi ia nənimen, maməres pen nari riti min. ");
INSERT INTO tnk_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nənə Iesu rɨni pen tɨ prən i mə, “Ikokeikei nəfe?” Mɨreɡi rɨni pen tukwe in mə, “Ni mə iəkunouihi mi kəru səiou trouəkure riti ia nɨkarem mwatuk riti ia nɨkarem mour nəpɨn tikərɨmənu ia nɨtətə səim.” ");
INSERT INTO tnk_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Mɨreɡi Iesu rɨni mə, “Kɨmirau iroureirei nəfe nari irouəres i. Ko kɨmirau irouənɨmwi kap i iou takənɨmwi?” Mɨreɡi irau krouni mə, “Kɨmrau iarouəmwhen.” ");
INSERT INTO tnk_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Mɨreɡi Iesu rɨni pen tɨ nirau i mə, “Nɨpərhienien kɨmirau tirouənɨmwi kap i səiou, mətə iou ko iakəpwəh nəseniien kɨmirau irouəkure riti ia nɨkarek mwatuk riti ia nɨkarek mour. Mətə kwopun nəha səvəi iərmama mi nəha səiou Tata rɨmərfi raka irau mə trəkure fwe ikɨn.” ");
INSERT INTO tnk_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nəpɨn ten mwi nərmama me səvəi Iesu həreɡi nəresien nəha səvəi Jemes mɨne Jon, niemaha rəpi irəha. ");
INSERT INTO tnk_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Mətə Iesu rəkwein irəha həuvehe tukwe. Rɨni mə, “Kɨmiaha hiəuvəukurən raka noien səvəi nərmama rɨpko mhə irəha nəkur Isrel. Nəmə asori me səvənraha sə kamhərɨmənu ia nirəha, kamhəfiəutə ia irəha, mamho nərmama kamho nəkwanraha. ");
INSERT INTO tnk_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mətə kɨmiaha tihəpwəh noien iamɨnhi irə ia kɨmiaha me. Trɨni mɨnuə kɨmiaha riti rokeikei mə truvehe masori ia kɨmiaha, in traməkeikei muvehe mo iərmama sə ramo tukwini nari m kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Trɨni mɨnuə kɨmiaha riti rokeikei mə trasori makupwən ia kɨmiaha, in traməkeikei muvehe mo iərmama sə ramo auər a wok səkɨmiaha pam. ");
INSERT INTO tnk_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kɨmiaha tiho rəmwhen a ia nirak. Iou, Iəməti Iərmama, iapkuvehe mhə mə nərmama tuho tukwini nari miou, mətə iakuvehe mə tako tukwini nari mɨnraha, muvei pen nɨmɨruien səiou trərəku suatuk tɨ nɨfi rakaien nari ia nərmama həpɨk.” ");
INSERT INTO tnk_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nəpɨn Iesu mɨne nərmama me səvənhi həier ia Jeriko, mamhəuvən, nərmama həpɨk kamhəkurirə ia Iesu. ");
INSERT INTO tnk_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ia kwopun nəha iərmama kəru krouəkure ia nɨkare suatuk. Nənimenrau rɨfwə. Nəpɨn kroureɡi mə Iesu rauvehe mə trukurau, krouəkwein əpwəmwɨs, rouni mə, “Iərɨmənu, kwənəkwus səvəi Kiɡ Tevɨt! Api tukumrau!” ");
INSERT INTO tnk_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mɨreɡi nərmama həɡkiari skai mɨnrau mə, “Rouafafa.” Mətə irau krourɨpɨn rouəkwein əpwəmwɨs mwi, rouni mə, “Iərɨmənu, kwənəkwus səvəi Kiɡ Tevɨt! Api tukumrau!” ");
INSERT INTO tnk_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nənə Iesu rərer, məkwein irau krouvehe, rɨni mə, “Irouokeikei mə tako nəfe m kɨmirau?” ");
INSERT INTO tnk_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Mɨreɡi krouni pen tukwe in mə, “Iərɨmənu. Iarouokeikei mə nəmrɨmrau trouətui pwəh iarouətə nari.” ");
INSERT INTO tnk_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iesu rerɨn rərkwəpɨr tɨ nirau. Rɨrapi nənimenrau. Nənə təkwtəkwuni nəha nənimenrau ramasan. Krouətə nari. Nənə Iesu ramesi suatuk mamevən, irau krouəkurirə i. ");
INSERT INTO tnk_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Irəha həuvən ipaka tɨ Jerusalem, mhəier pen ia Təkuər Olif ia kwopun nəha ipaka tɨ rukwənu Petfas, nənə Iesu rərhi pen iərmama kəru səvənhi, ");
INSERT INTO tnk_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","mɨni pen tɨ nirau i mə, “Kɨmirau tirouevən fwe ia rukwənu nəha samarəti pen i. Nəpɨn tirouapirapw fwe ikɨn, tirouətə toɡki riti kɨnəkwi tərini irau tɨni. Tiroufi raka nari ia nirau, rouəsɨɡi irau, rouvehe tukw iou. ");
INSERT INTO tnk_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Trɨni mɨnuə iərmama riti rəres kɨmirau mə iroufi raka nari irə tɨ nəfe, tirouni mə ‘Iərɨmənu səkɨtaha raməres toɡki mi i, mətə trɨpkəpwəmwɨs mhə trərhi pehe mwi irau.’” ");
INSERT INTO tnk_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nəri nəha rier pehe iamɨnhi irə mə nəɡkiariien səvəi Profet Aesea truvehe mukuə. In rɨməni mə, ");
INSERT INTO tnk_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Kɨmiaha tihəni pen tɨ nəkur Saeon mə, ‘Hətə ro kiɡ səkɨmiaha rauvehe tukumiaha, mɨpkəfiəutə mhə in, raməkure ia toɡki, toɡki i in kwəti toɡki a.’” ");
INSERT INTO tnk_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Iərmama mi nəha səvəi Iesu krouevən, rauo nəfe in rɨməni pen tɨ nirau i. ");
INSERT INTO tnk_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Krouəsɨɡi toɡki nəha irau tɨni, rouəsɨɡi rouvehe, rouəpənə pen karkahu əpwəmwɨs mi səvənrau ia təkutai toɡki mi nəha, nənə Iesu rəkure irə. ");
INSERT INTO tnk_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nərmama həpɨk həpənə pen karkahu əpwəmwɨs me səvənraha ia suatuk. Nərmama nepwɨn mwi hərai nɨmwai nei me, mhəpənə pen ia suatuk. ");
INSERT INTO tnk_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nərmama səməme kamhəkupwən mɨne səməme kamhəkurirə ia Iesu kamhəkwein əpwəmwɨs, mamhəni mə, “Səɡnəɡɨni iəmə i ruku pen ia kwənəkwus səvəi Kiɡ Tevɨt! Səkwein amasan irə rauvehe ia nəɡhi Iərɨmənu səkɨtaha! Kəɡnəɡɨni Kumwesən fwe irənhə anan!” ");
INSERT INTO tnk_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nəpɨn Iesu ruvnimwə ia Jerusalem, nərmama pam ia taon nəha kamhəni nəɡkiariien me rɨpɨk, mamhəres mə, “Nəfe nəha iərmama?” ");
INSERT INTO tnk_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mɨreɡi nərmama səməme kamhəkurirə in həni mə, “In i profet nəha nəɡhɨn nə Iesu. Ruku pen fwe Nasaret ia tənə Kalili.” ");
INSERT INTO tnk_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nənə Iesu revən ia nimwə səvəi Kumwesən, mɨnaməkoui irapw nərmama səməme kamhəmri pen nəmri nari ia narimnari me mɨne səməme kamhəuvehi nəmri narimnari me. Rəvsini tepol me səvəi nərmama kamhəvriwei mane me. Rəvsini jea me səvəi nərmama səməme kauvehi nəmri menu me tɨ nirəha. ");
INSERT INTO tnk_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","In rɨni pen tɨ nirəha i mə, “Kɨmərai pen ia Nəkukuə Ikinan mə, ‘Tukani nimwə səiou mə nimwəfwaki,’ mətə kɨmiaha hiəno ruvəuvehe kwopun sə rakres me kamhərkwafə ikɨn.” ");
INSERT INTO tnk_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ia nəpɨn nəha nərmama səməme nənimenraha rɨfwə mɨne səməme nɨsunraha rərfe həuvehe tɨ Iesu ia nimwə səvəi Kumwesən, nənə in ro irəha həuvehe mhəsanɨn. ");
INSERT INTO tnk_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Mətə pris asori me mɨne nahatən me səvəi Loa rerɨnraha rɨpkaɡien mhə ia narimnari amasan me sə in ramo. Irəha həreɡi mwi mə nəkwərhakwərha me ia nimwə səvəi Kumwesən kamhəkwein əpwəmwɨs mə, “Səɡnəɡɨni iəmə i ruku pen ia kwənəkwus səvəi Kiɡ Tevɨt!” Irəha hətoni niemaha rəpi irəha. ");
INSERT INTO tnk_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nənə həni pen tɨ Iesu i mə, “Ikreɡi nəɡkiariien nəha kamhəni?” Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Ouəh, iakamreɡi. Rosi hiəpkəvsini raka mhə nəɡkiariien i ia Nəkukuə Ikinan rɨni mə, ‘Ikɨnəpnəpenə raka ia tərhui nəkwərhakwərha me mɨne tərhui nəkwərhakwərha əmtəmetə me mə tuhəɡnəɡɨni ik?’” ");
INSERT INTO tnk_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nənə Iesu rəpwəh irəha, mier ia Jerusalem, mevən fwe Petani, mapri ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kɨni rakwakwi irə, ia nəpnəpɨn Iesu rɨrərɨɡ mamevən mwi fwe Jerusalem mɨreɡi nukumhə rɨnahi. ");
INSERT INTO tnk_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nənə in rəti pen mətoni niemɨs riti ramərer ia nɨkare suatuk. Revən ipaka tukwe mətə nɨmwan me a. Nukwan riwən. Ro pen in rəɡkiari ia nei nə mɨni mə, “Tikəpwəh mwi nukuəien ia nəpɨn riti.” Nənə təkwtəkwuni a niemɨs nə ruvehe maukei. ");
INSERT INTO tnk_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nəpɨn nərmama me səvənhi hətoni, hərkərinari, mhəni mə, “Niemɨs nəha rəfɨmhiə akwauakw iamɨnhi irə?” ");
INSERT INTO tnk_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Iakani nɨpərhienien tukumiaha i trɨni mɨnuə kɨmiaha hiahatətə pərhien ia Kumwesən, mhəpwəh nəmkiəmkiien, hiəukurən noien rəmwhen iakɨno ia niemɨs i. Mətə rɨpko mhə in əpa i. Trɨni mɨnuə kɨmiaha hiəni pen tɨ təkuər i mə, ‘Təkuər i, tiko mier mivə pen fwe ia təsi,’ nənə təkuər nəha tro nəkwamiaha. ");
INSERT INTO tnk_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Trɨni mɨnuə kɨmiaha hiahatətə pərhien ia Kumwesən, nəfe nəɡhɨn tihəfwaki mhəres i, tihəuvehi.” ");
INSERT INTO tnk_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iesu revən ia nimwə səvəi Kumwesən, mamahatən nərmama me. Nənə pris asori me mɨne nəmə asori me səvəi nəkur Isrel həuvehe tukwe, mhəni mə, “Ikamo narimnari me i ia nəkwai sin, uə sin rəseni ik mə tiko narimnari me i?” ");
INSERT INTO tnk_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Iou mwi takəres kɨmiaha nəresien riti. Trɨni mɨnuə hiəni atukwatukw tukw iou i, takɨni pehe tukumiaha i mə iakamo narimnari me i ia nəkwai sin. ");
INSERT INTO tnk_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Fwe kupwən, sin rərhi pehe Jon mə tro paptaes ia nərmama, Kumwesən uə iərmama riti?” Nənə irəha həɡkiari pəri, mamhəni mə, “Tsəfni irə i? Tuko səni mə Kumwesən rərhi pehe Jon mə tro paptaes ia nərmama, Iesu trɨni pehe tukutaha i mə, ‘Ro iamɨnhi irə rəfo hiəpwəh nɨniien nɨpərhienien ia nəɡkiariien səvəi Jon?’ ");
INSERT INTO tnk_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mətə ko səni mə iərmama riti rərhi pehe Jon uə?” Mətə irəha həhekɨr nɨniien iamɨnhi, tɨ nəri nə mə nərmama me həni nɨpərhienien ia Jon mə in profet pərhien riti. ");
INSERT INTO tnk_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ro pen həni pen tɨ Iesu i mə, “Kɨmaha iahəreirei.” Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Iou mwi ko iakəpwəh nɨniien tukumiaha i mə iakamo narimnari me i ia nəkwai sin.” ");
INSERT INTO tnk_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Nənə Iesu rɨni pen tɨ nirəha i mə, “Kɨmiaha hiaməfətərɨɡ irə? Iərmama riti tɨni kəru. Nəpɨn riti revən mɨni pen tɨ nəmritaik səvənhi mə, ‘Nərɨk. Ipwet tikevən məmhu ia nəmhien səkrau.’ ");
INSERT INTO tnk_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mɨreɡi rɨni mə, ‘Iakəpwəh.’ Mətə kurirə irə rərari ia nətərɨɡien səvənhi, mevən. ");
INSERT INTO tnk_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nənə tata səvənhi revən tɨ piəvni mɨni pen nəɡkiariien kuatia. Mɨreɡi rɨni mə, ‘Ramasan tata, pwəh iakevən.’ Mətə in rəpwəh nevənien. ");
INSERT INTO tnk_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Sə pəku ia nirau ro nəkwai tata səvənhi?” Mɨreɡi irəha həni mə, “Nəmritaik.” Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Iakamɨni nɨpərhienien tukumiaha i nərmama səməme kamərəku pen takis mɨnraha mɨne nɨpran me səvəi suatuk kamhəkupwən ia kɨmiaha, mamhəuvnimwə ia nɨtətə sə Kumwesən ramərɨmənu irə. ");
INSERT INTO tnk_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Iakɨni iamɨnhi irə tɨ nəri nə mə Jon Paptaes rɨməuvehe tukumiaha mahatən suatuk atukwatukw sə tihesi pen, nənə kɨmiaha hiəpwəh nɨniien nɨpərhienien irə. Mətə nərmama səməme kamərəku pen takis mɨnraha mɨne nɨpran me səvəi suatuk həməni nɨpərhienien irə. Kurirə irə hiətoni, mətə hiəpwəh nɨrərɨɡien ia noien ərəha səkɨmiaha, mamhəni ihi neikuəien irə.” ");
INSERT INTO tnk_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Kɨmiaha tihətərɨɡ iou pwəh iakɨni irapw nusipekɨnien riti mwi. Iəmə asori riti rəpwei nəkwus nəha krep ia nəmhien səvənhi, mukurei pen nəpai rukurau kurau irə, muəsi kəpwier mo nəkwan sə tukeivə testesi tɨpwei krep ikɨn tɨ nuvehiien nɨsen, mo mwi nəpai rəpwəmwɨs mutə tukətui tɨ krep ikɨn. Nəpɨn ro sampam irə, rəseni nərmama nepwɨn həuvehe mhətui tɨ nɨmei krep səvənhi. Irəha tuhəmhu ikɨn, mhesi kwənkwai krep, mhəuai, mhəuvei pen nɨpərɨn m iəmə asori. Iəmə asori rəmri pen nɨmei krep səvənhi ia rəɡɨnraha, mier, mevən ia tənə əpə iti. ");
INSERT INTO tnk_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nəpɨn kwənkwai krep rɨmruə, iəmə asori rərhi pen nərmama me nepwɨn səməme kamho tukwini nari min həuvən mhətə nəmə hamətui tɨ nɨmei krep səvənhi. In rokeikei mə tuhəuvei pen kwənkwai krep me nepwɨn mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Mətə nəmə kamhətui tɨ krep həkwtəmhiri iotukwininari me səvənhi, mhəuəsi riti, mhousi əpune riti, nənə mhəkwi riti ia kəruəterei. ");
INSERT INTO tnk_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Iəmə asori rərari, mərhi pen mwi nərmama nepwɨn mwi kamho tukwini nari min həuvən. Nənə nəmə kamhətui tɨ krep ho mwi nari kuatia ia nirəha. ");
INSERT INTO tnk_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Sampam iəmə asori rərhi pen tɨni, mɨni mə, ‘Irəha tuhəsiai nərɨk.’ ");
INSERT INTO tnk_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mətə nəpɨn nəmə kamhətui tɨ krep hətoni tɨni iəmə asori, həni pen tɨ nirəha me i mə, ‘Kwa tɨni iəmə asori nəha. Nəpɨn tata səvənhi tremhə, nɨmei krep i ruvehe mo səvənhi. Həuvehe, pwəh sousi əpune nənə nɨmei krep səvənhi truvehe mo səkɨtaha i.’ ");
INSERT INTO tnk_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nənə irəha həkwtəmhiri, mhousi əpune, mhərarki irapw ia taniruə. ");
INSERT INTO tnk_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ro iamɨnhi irə nəpɨn iəmə asori səvəi nɨmei krep truvehe, tro nəfe ia nəmə hamətui tɨ nɨmei krep səvənhi?” ");
INSERT INTO tnk_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Mɨreɡi nəmə asori me həni pen tɨ Iesu i mə, “In trousi əpune nəmə ərəha me nəha ia noien riti rərəha anan, məseni nərməpə me həuvehe mhətui tɨ nɨmei krep səvənhi. Irəha tuhesi kwənkwai krep ia nəpɨn atukwatukw səvənhi, mhəuai, mhəuvei pen nɨpərɨn min.” ");
INSERT INTO tnk_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Rosi kɨmiaha hiəpkəvsini raka mhə nəɡkiariien i ia Nəkukuə Ikinan rɨni mə, ‘Kəruəterei nəha nəmə kamhəuvrhəkɨn nimwə hənuə rərəha, mhəpwəh, təkwtəkwuni nəha ruvəuvehe mɨno kəruəterei sə rəpi raka pam kəruəterei me, məkwtəmhiri əknekɨn pam nimwə. Iərɨmənu səkɨtaha rɨno nəri i, sətoni nəmrɨtaha rier tukwe’? ");
INSERT INTO tnk_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ro pen iakani pehe tukumiaha i mə nɨtətə sə Kumwesən ramərɨmənu irə raməmak ia rəɡɨmiaha, tukamevən kuvehi raka tukumiaha kuvei pen m nərmama nepwɨn səməme tuhəukuə kwənkwan me. ");
INSERT INTO tnk_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Iərmama sə trɨmwei pen ia kəruəterei nəha, nɨkəkrin me trərkwəpɨrərkwəpɨr. Trɨni mɨnuə kəruəterei nəha rɨmwei pen ia iərmama riti, iərmama nəha trɨpwarɨspwarɨs.” ");
INSERT INTO tnk_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nəpɨn pris asori me mɨne Farisi me həreɡi nusipekɨnien me nəha Iesu rani, həukurən mə raməɡkiari ia nirəha. ");
INSERT INTO tnk_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Hokeikei mə tuhəkwtəmhiri in, mətə hənhekɨr nərmama me tɨ nəri nə mə irəha kamhəni mə in profet pərhien riti. ");
INSERT INTO tnk_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nənə Iesu rəɡkiari mwi mɨnraha, musipekɨn mɨni mə, ");
INSERT INTO tnk_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Suatuk sə Kumwesən ia neiai ramərɨmənu ia nɨtətə səvənhi rəmwhen ia kiɡ riti sə ro nəveɡɨnien asori səvəi tɨni tɨ nəri nə mə tɨni rɨpkiri a pran səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Rərhi pen nərmama səməme kamho tukwini nari min həuvən mhəkwein nərmama səməme in ruvəni pen raka tɨ nirəha i mə tuhəuvehe, mətə irəha həpwəh nokeikeiien mə tuhəuvehe. ");
INSERT INTO tnk_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ro pen kiɡ rərari mərhi pen nərmama nepwɨn mwi səməme kamho tukwini nari min, rɨni pen tɨ nirəha i mə, ‘Kɨmiaha tihəuvən mhəni pen tɨ nərmama səməme iakuvəni raka tɨ nirəha i mə tuhəuvehe mə hətə ro iakɨnəpnəpenə raka səiou nəveɡɨnien. Iakɨnousi əpune raka kau me səiou mɨne kwəti kau me səiou həsisi amasan. Narimnari me pam i iakameitenhi a kɨmiaha. Tihəuvehe tɨ nəveɡɨnien asori səiou sə iakamo səvəi nərɨk tɨ nəri nə mə rɨpkiri a pran səvənhi.’ ");
INSERT INTO tnk_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Mətə irəha ho nəri auər a ia nəɡkiariien səvəi kiɡ, mamhəuvən. Riti revən tɨ səvənhi nəmhien. Riti revən tɨ səvənhi stoa. ");
INSERT INTO tnk_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Nərmama me nəha nepwɨn həkwtəmhiri nərmama səməme kamho tukwini nari m kiɡ, mho naurɨsien mɨnraha, mhousi əpune irəha. ");
INSERT INTO tnk_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ia nəpɨn nəha kiɡ niemaha rəpi. Ro pen rərhi pen naruaɡən me səvənhi, həuvən mhousi əpune nərmama me nəha səməme hənousi əpune səvənhi me nərmama, nənə mhəuvani taon səvənraha. ");
INSERT INTO tnk_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kurirə irə kiɡ rɨni pen tɨ nərmama səməme kamho tukwini nari min mə, ‘Nəveɡɨnien asori səiou sə iakamo tɨ nərɨk sə rɨpkiri a pran i iakɨnəpnəpenə pam tukwe, mətə səməme iakuvəni raka tɨ nirəha i mə tuhəuvehe həpwəh nəmwhenien. ");
INSERT INTO tnk_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ro iamɨnhi irə, kɨmiaha tihəuvən fwe suatuk me, mhəni pen tɨ nərmama me pam səməme hiətoni irəha mə tuhəuvehe ia nəveɡɨnien səiou.’ ");
INSERT INTO tnk_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nənə nərmama me nəha kamho tukwini nari m kiɡ həier, mhəuvən ia suatuk me, mhəkwein nərmama me pam səməme hətoni irəha, nəkur ərəha mɨne nəkur amasan, həuvehi irəha mhəuvən tɨ nəveɡɨnien asori səvəi kiɡ. Nənə nimwə sə kaməni nari ikɨn rukuər ia nərmama. ");
INSERT INTO tnk_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Mətə nəpɨn kiɡ ruvnimwə pehe mə trətoni nərmama me nəha səməme həuvehe, rətə iərmama riti raməni nari mɨpkarkahu mhə tɨnari atukwatukw sə kamarkahu i ia nəveɡɨnien sə ro iamɨnhi. ");
INSERT INTO tnk_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nənə kiɡ rɨni pen tukwe in mə, ‘Iou riti! Ikəfuvnimwə pehe irə məpwəh narkahuien tɨnari atukwatukw sə kamarkahu i ia nəveɡɨnien iamɨnhi?’ Nənə iərmama nəha rɨreirei mə trɨni nəfe. ");
INSERT INTO tnk_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nənə kiɡ rɨni pen tɨ nərmama me nəha kamho tukwini nari min mə, ‘Hərihi rəɡɨn mi mɨne nɨsun mi, mhərarki irapw iruə ia nəpitəvien. Kwopun nəha nərmama tuhasək ikɨn, mhahi tərini revɨnraha.’” ");
INSERT INTO tnk_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nənə Iesu rarə mɨni mwi mə, “Kaməkwein nərmama həpɨk mə tuhəuvehe, mətə houihi a Kumwesən ruvərfi raka irəha mə səvənhi me.” ");
INSERT INTO tnk_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ia nəpɨn nəha Farisi me həuvən, mhəɡkiari pəri, mamhəres mə tuhəfo mho Iesu rəfwəkour ia nəɡkiariien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nəpɨn həɡkiari pam, hərhi pen nərmama nepwɨn səvənraha tɨ Iesu həuvən irəha nərmama nepwɨn səvəi Kiɡ Herot, nənə mhəni mə, “Iahatən. Kɨmaha iahəukurən mə ik iəmə sə ikani nɨpərhienien. Ikamahatən atukwatukw suatuk sə Kumwesən rokeikei mə nərmama tuhesi pen. Ikəpwəh nehekɨrien nərmama, mətə nəmə asori uə nəmə auər a ikahatən rəmnəmwhen a tɨ nirəha. ");
INSERT INTO tnk_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ro iamɨnhi irə tiko mɨni pehe ro tukumaha i nətərɨɡien səim. Ratukwatukw ia Loa səkɨtaha mə tsərəku pen nəmri takis m Kiɡ Sisa uə rekəm?” ");
INSERT INTO tnk_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Mətə Iesu ruvəukurən raka nətərɨɡien ərəha səvənraha, rɨni mə, “Kɨmiaha kəuətkəsuə me. Rəfo hiameipweipwi iou iamɨnhi irə? ");
INSERT INTO tnk_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Həuvehi silin riti mhəuvehi mhəuvehe, pwəh iakətə ro.” Nənə irəha həuvei pen silin riti min. ");
INSERT INTO tnk_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nənə Iesu rɨni pen tɨ nirəha i mə, “Nənɨmwi iərmama sin i ia silin? Nənə nəɡhi sin i?” ");
INSERT INTO tnk_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Mɨreɡi həni mə, “Nənɨmwi Kiɡ Sisa mɨne nəɡhi Kiɡ Sisa.” Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Ro iamɨnhi irə narimnari me səvəi Kiɡ Sisa hiəuvei pen m Kiɡ Sisa. Narimnari me səvəi Kumwesən hiəuvei pen m Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nəpɨn irəha həreɡi nəɡkiariien səvənhi, nənimenraha rier. Nənə həpwəh Iesu mamhəuvən. ");
INSERT INTO tnk_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ia nəpɨn nəha mwi Satusi me nepwɨn həuvehe tɨ Iesu. (Satusi me irəha kamhəni mə iərmama sə ruvamhə ko rɨpkətui mhə mwi.) Irəha həuvehe mhəres Iesu nəresien riti, ");
INSERT INTO tnk_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","mhəni mə, “Iahatən, Moses rɨməni mə, ‘Trɨni mɨnuə iərman riti remhə, məpwəh səvənhi pran, mətə tɨnɨnrau riwən, piəvi iərman nəha traməkeikei miri pran nəha rouərəhi nəkwərhakwərha me, rouəsihaɡɨn piəvi iəmə nəha.’ ");
INSERT INTO tnk_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mətə nərman me nepwɨn səkɨtaha, irəha pam sefen. Irəha piəvnraha me. Sə rasori riri pran riti, rouəpwəh nərəhiien iəkunouihi riti, remhə, məpwəh səvənhi pran. Nənə piəvi iərman nəha riri. ");
INSERT INTO tnk_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Piəvni sə resi pen in mwi ro iamɨnhi irə. Nənə piəvni sə ro kahar in mwi ro iamɨnhi irə mamevən meste sampam. ");
INSERT INTO tnk_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Nərman me nəha sefen hemhə pam. Nənə prən nəha remhə mwi. ");
INSERT INTO tnk_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ni pehe ro tukumaha i. Ia nəpɨn nəha Kumwesən tro nərmama hətui mwi ia nemhəien, prən nəha səvəi sin ia nərman me nəha sefen, tɨ nəri nə mə irəha pam həməiri in?” ");
INSERT INTO tnk_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Mətə Iesu rɨni pen tɨ nirəha i mə, “Kɨmiaha hiəreirei nɨpwrai nəɡkiariien me ia Nəkukuə Ikinan, mhəreirei mwi nɨskaiien səvəi Kumwesən. Ro iamɨnhi irə mɨne nahatənien səkɨmiaha rɨpkatukwatukw mhə. ");
INSERT INTO tnk_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nəpɨn nərmama tuhətui mwi ia nemhəien, nərman tuhəpwəh niriien nɨpran, nɨpran tuhəpwəh nesi penien nərman. Mətə irəha tuhəmwhen ia naɡelo me ia neiai. ");
INSERT INTO tnk_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nənə nəɡkiariien səvəi nəɡkiariien i hiaməni mə iərmama ko rɨpkətui mhə mwi ia nemhəien. Rosi kɨmiaha hiəpkəvsini raka mhə nəɡkiariien i Kumwesən rɨməni pehe tukumiaha i uə? Rɨməni mə, ");
INSERT INTO tnk_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Iou Kumwesən səvəi Epraham mɨne Kumwesən səvəi Aesak mɨne Kumwesən səvəi Jekop.’ In rɨpko mhə Kumwesən səvəi nərmama me səməme həuvamhə, mətə in Kumwesən səvəi nərmama me səməme kamhəmɨru.” ");
INSERT INTO tnk_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nəpɨn nərmama me həreɡi nəɡkiariien nəha Iesu ramahatən nərmama me irə, nənimenraha rier. ");
INSERT INTO tnk_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mətə nəpɨn Farisi me həreɡi mə Iesu rəsisəɡ tərhui Satusi me ia nəɡkiariien səvənhi, irəha housəsɨmwɨn irəha me. ");
INSERT INTO tnk_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Irəha riti in iahatən səvəi Loa rəres pen nari riti min mə trɨreɡi ro Iesu mə trəfni irə. In rɨni mə, ");
INSERT INTO tnk_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Iahatən. Nəfe loa ia Loa səvəi Moses in rasori?” ");
INSERT INTO tnk_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Mɨreɡi Iesu rɨni pen tukwe in mə, “‘Tikaməkeikei mokeikei Iərɨmənu Kumwesən səim ia rerɨm me pam, mokeikei in ia nɨmɨruien me pam səim, mokeikei in ia nətərɨɡien me pam səim.’ ");
INSERT INTO tnk_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Loa nəha in rasori makupwən ia loa me. ");
INSERT INTO tnk_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nənə loa səro kəru irə rakurirə pen loa nəha rəmwhen irə. Rɨni mə, ‘Tikaməkeikei mokeikei piam rəmwhen ikokeikei atukw a ik.’ ");
INSERT INTO tnk_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nəɡkiariien me pam kɨmərai pen ia Loa səvəi Moses mɨne nəkukuə me səvəi profet kupwən me həɡher pen ia loa mi nəha.” ");
INSERT INTO tnk_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisi me housəsɨmwɨn irəha me, nənə Iesu rəres pen irəha i ");
INSERT INTO tnk_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","mə, “Kɨmiaha hiaməfətərɨɡ irə mə Kristo in tɨni sin?” Mɨreɡi irəha həni pen tukwe in mə, “In tɨni Kiɡ Tevɨt tɨ nəri nə mə truku pen ia kwənəkwus səvənhi.” ");
INSERT INTO tnk_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Mətə rəfo nəha Kiɡ Tevɨt rɨnəkwein Kristo mə Iərɨmənu səvənhi? Ia nəpɨn nəha Nənɨmwɨn Ikinan rɨnarə irə Kiɡ Tevɨt rɨməni mə, ");
INSERT INTO tnk_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Kumwesən rɨni pen tɨ Iərɨmənu səiou mə, Əkure ia nɨkarek mwatuk mesite tako nərmama səməme haməmwəki ik həuvehe, tikərpwi utə tɨpaɡe nɨsum mi ia nirəha.’ ");
INSERT INTO tnk_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Mə Kiɡ Tevɨt rɨnəkwein Kristo mə Iərɨmənu səvənhi rəfo kɨmiaha hiaməni mə in tɨni Kiɡ Tevɨt?” ");
INSERT INTO tnk_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nəpɨn Iesu rəres nəresien nəha, iərmama riti riwən ko rɨrɨpwen pen min. Ia nəpɨn nəha mamevən, nərmama pam həhekɨr nəresien nəresien me min. ");
INSERT INTO tnk_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Iesu rəɡkiari m nərmama me mɨne nərmama me səvənhi, mɨni mə, ");
INSERT INTO tnk_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Nahatən me səvəi Loa mɨne Farisi me kamhəkure ia təmwki Moses. ");
INSERT INTO tnk_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ro iamɨnhi irə kɨmiaha tihaməkeikei mhəsiai irəha, mho nəfe nəɡhɨn irəha həni pehe tukumiaha i. Mətə tihəpwəh noien rəmwhen ia nirəha. Irəha kamhəvisau, mətə həpko mhə nəfe kamhəni. ");
INSERT INTO tnk_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kamhəkeikei m nərmama me mə tuhesi pen loa skai me səməme həmwhen ia katipə sə rɨpam, mətə irəha həpkuvei pen mhə nəkwai rəɡɨnraha riti mhasitu ia nirəha tɨ natipəien. ");
INSERT INTO tnk_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kamho noien amasan me pam səvənraha mə nərmama tuhətoni həɡnəɡɨni irəha. Kwəti tənərɨpw me i kɨməvai pen nəɡkiariien səvəi Kumwesən irə, nərmama kamhərihi tərini pen ia nɨpwənanraha mɨne rəɡɨnraha, nahatən me səvəi Loa kamhəkwusi səvənraha sə pwinari, mho mwi nusvenhi karkahu me səvənraha həpwəmwɨs. ");
INSERT INTO tnk_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ia nəveɡɨnien asori me irəha hokeikei mə tuhəkure ia kwopun kamsiai nərmama me ikɨn. Ia nəkwai nimwəfwaki me səvəi nəkur Isrel hokeikei mə tuhəkure ia kwopun amasan me. ");
INSERT INTO tnk_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ia kwopun kamo maket me ikɨn hokeikei mə nərmama tuhəkwein irəha ia nɨsiaiien, mhokeikei nəpɨn nərmama həkwein irəha mə, ‘Iahatən.’ ");
INSERT INTO tnk_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Mətə kɨmiaha tihəpwəh nəseniien nərmama həkwein kɨmiaha mə ‘Iahatən,’ tɨ nəri nə mə iahatən səkɨmiaha kuatia a, nənə kɨmiaha piəvmiaha me. ");
INSERT INTO tnk_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nənə tihəpwəh nəkweinien iərmama riti ia tɨprənə i mə ‘Tata,’ tɨ nəri nə mə Tata səkɨmiaha kuatia a. In ramarə fwe ia neiai. ");
INSERT INTO tnk_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nənə tihəpwəh nəseniien nərmama həkwein kɨmiaha mə ‘Iərɨmənu,’ tɨ nəri nə mə səkɨmiaha Iərɨmənu kuatia a. In i iou, Kristo. ");
INSERT INTO tnk_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Iərmama sə rokeikei mə trasori ia kɨmiaha in traməkeikei muvehe mo iərmama sə ramo tukwini nari m kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mətə iərmama sə rauvehi utə in, Kumwesən truvehi irapw in. Iərmama sə rauvehi irapw in Kumwesən truvehi utə in. ");
INSERT INTO tnk_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Trərəha anan tukumiaha nahatən me səvəi Loa mɨne Farisi me. Kɨmiaha kəuətkəsuə me. Hiaməsisəɡ ia təpinhə ia nɨtətə ia neiai ia nəmri nərmama. Kɨmiaha hiəpwəh nuvnimwəien ia nɨtətə nəha, nənə hiaməsisəɡ mwi nərmama səməme hokeikei mə tuhəuvnimwə irə. ");
INSERT INTO tnk_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Trərəha anan tukumiaha nahatən me səvəi Loa mɨne Farisi me. Kɨmiaha kəuətkəsuə me. Hiəsuə ia nɨtətə me mhəpi sɨmwɨn ia təsi mɨne tənə mhəuvən isipwɨn mə tihəvi iərmama kuatia ruvehe mukurirə ia kɨmiaha. Nənə nəpɨn in ruvehe mukurirə ia kɨmiaha, hio ruvehe mərəha anan məpi raka kɨmiaha. Nɨpwnəti kwopun napw asori rauək ikɨn irəha nə kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Trərəha anan tukumiaha. Kɨmiaha nərmama hiaməiri pen nərmama ia suatuk sə tuhesi, mətə nənimemiaha rɨfwə. Hiaməni mə ‘Trɨni mɨnuə iərmama riti rahatən nimwə səvəi Kumwesən, muvehi kwəsuahi irə, nəɡkiariien nəha ro nəri auər a. Mətə trɨni mɨnuə rahatən kol ia nəkwai nimwə nəha, muvehi kwəsuahi irə, in traməkeikei mo nəfe in ramɨni.’ ");
INSERT INTO tnk_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kɨmiaha hiəreirei nari. Nənimemiaha rɨfwə. Sə pəku nəha ro ikinan məpi raka, kol nəha uə nimwəfwaki sə ro kol ruvehe mo ikinan i? ");
INSERT INTO tnk_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nənə kɨmiaha hiaməni mə, ‘Trɨni mɨnuə iərmama riti rahatən nɨfatə səvəi Kumwesən, muvehi kwəsuahi irə, nəɡkiariien nəha ro nəri auər a. Mətə trɨni mɨnuə rahatən nari riti sə kɨnəmri utə ia təkure nɨfatə nəha, in traməkeikei mo nəfe in ramɨni.’ ");
INSERT INTO tnk_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kɨmiaha nənimemiaha rɨfwə. Sə pəku nəha ro ikinan məpi raka, nəri sə raməmak utə ia təkure nɨfatə uə nɨfatə səvəi Kumwesən sə ro nəri nəha ruvehe mo ikinan i? ");
INSERT INTO tnk_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ro iamɨnhi irə iərmama sə ramahatən nɨfatə səvəi Kumwesən, mauvehi kwəsuahi irə, in ramahatən nɨfatə nəha mɨne narimnari me pam səməme kamhəmak ia təkuren kauvei pen m Kumwesən, mauvehi kwəsuahi ia nirəha. ");
INSERT INTO tnk_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nənə iərmama sə ramahatən nimwə səvəi Kumwesən, mauvehi kwəsuahi irə, in ramahatən nimwə nəha mɨne Kumwesən sə ramarə fwe ia nəkwan, mauvehi kwəsuahi ia nirau. ");
INSERT INTO tnk_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nənə iərmama sə ramahatən neiai, mauvehi kwəsuahi irə, ramahatən Kumwesən mɨne jea sə Kumwesən raməkure irə mamərɨmənu, mauvehi kwəsuahi ia nirau. ");
INSERT INTO tnk_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Trərəha anan tukumiaha nahatən me səvəi Loa mɨne Farisi me. Kɨmiaha kəuətkəsuə me. Hiaməuai narimnari me səkɨmiaha ia kusen ten, mamhəuvei pen riti m Kumwesən. Hiamo iamɨnhi irə ia nəri ouihi rəmwhen ia nɨmwai nei me səməme kavi rərəɡi pen ia nəveɡɨnien. Mətə hiənenouenou nəɡkiariien me həpam mwi. Kɨmərai pen ia Loa səvəi Kumwesən mə iərmama traməkeikei mo noien atukwatukw, mamapi tɨ iərmama, nənə mamahatətə ia Kumwesən. Ramasan mə kɨmiaha hiamo nəɡkiariien asori me nəha, mhəpwəh nenouenouien mwi nəɡkiariien ouihi me. ");
INSERT INTO tnk_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kɨmiaha nərmama hiaməiri pen nərmama ia suatuk sə tuhesi, mətə nənimemiaha rɨfwə. Nəpɨn hiənɨmwi nui, hiəpeki raka manman irə, mətə hiəpkətə mhə nərimɨru nəha kamel raməmak irə, nənə hiətɨɡai. ");
INSERT INTO tnk_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Trərəha anan tukumiaha nahatən me səvəi Loa mɨne Farisi me. Kɨmiaha kəuətkəsuə me. Noien səkɨmiaha rəmwhen ia kap mɨne tikinari kaikuas irə iruə rəmher mətə nəkwan rəmkemɨk. Fwe imwə rerɨmiaha rukuər ia nərəhaien mɨne nakresien. Hiamətərɨɡ əpa tukumiaha me. ");
INSERT INTO tnk_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ik Farisi, nənimem rɨfwə pərhien. Kupwən maikuas ia nəkwai kap mɨne plet kurirə ikəpərhi tekɨn iruə rəmher. ");
INSERT INTO tnk_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Trərəha anan tukumiaha nahatən me səvəi Loa mɨne Farisi me. Kɨmiaha kəuətkəsuə me. Kɨmiaha hiəmwhen ia nɨpəɡi kəruəterei sə kərkwafə pen iərmama sə remhə ikɨn kəfəri iruə rəpsan. Nəpɨn nərmama hətoni iruə, rerɨnraha rɨrhi mə ramasan, mətə fwe imwə rukuər ia nɨkəkri iərmama mɨne nɨpwran sə rɨmərɨr məmkemɨk. ");
INSERT INTO tnk_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ia noien nəha rəmwhen a mwi nəpɨn nərmama hətə nɨpwramiaha iruə, rerɨnraha rɨrhi mə kɨmiaha hiatukwatukw, mətə fwe imwə rerɨmiaha rukuər ia neikuəien mɨne noien ərəha me. ");
INSERT INTO tnk_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Trərəha anan tukumiaha nahatən me səvəi Loa mɨne Farisi me. Kɨmiaha kəuətkəsuə me. Hiəuvrhəkɨn kref me səvəi profet me mɨne nəmə atukwatukw me, mamhərukwi utə tihinari me ia nirəha. ");
INSERT INTO tnk_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kɨmiaha hiaməni mə, ‘Rɨpkɨni mɨnuə samarə ia nəpɨn kupwən səvəi kaha me, ko səpwəh noien rəmwhen irəha həno, mhousi əpune profet me.’ ");
INSERT INTO tnk_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ia nəɡkiariien nəha kɨmiaha hiaməni pui atukw a kɨmiaha mə nɨpərhienien i nɨmwipwi nərmama me nəha səməme hənousi əpune profet kupwən me irəha nə kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ramasan mə kɨmiaha tihərɨpɨn noien ərəha me nəha kaha kupwən me səkɨmiaha həno stat mho, mho sampam irə. ");
INSERT INTO tnk_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kɨmiaha snek me, hiəmwhen ia nɨpwnəti snek me kamhahi əpune iərmama! Tihəfo mhap mə Kumwesən trəpwəh nərpwɨnien noien ərəha me səkɨmiaha ia kwopun napw asori rauək ikɨn? ");
INSERT INTO tnk_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Tɨ nəri nə mə kɨmiaha hiamo noien me nəha, iou takərhi pehe profet me, mɨne nərmama səməme həukurən nari, mɨne nahatən me həuvehe tukumiaha. Kɨmiaha tihousi əpune nepwɨn, mhərui tərini pen nepwɨn ia nei kamarkuaui, mhousi nepwɨn ia nəkwai nimwəfwaki me səkɨmiaha, mhərɨpwi irəha ia taon me. ");
INSERT INTO tnk_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Takərhi pehe irəha tukumiaha iamɨnhi irə mə kɨmiaha nərmama ipwet mɨne tihəuvehi nərpwɨnien tɨ nɨte nəkur atukwatukw me pam sə rɨnaiu ia tɨprənə i rostat ia nɨte Epel, iəmə sə rɨpko mhə nərəhaien riti, muvehe meste nɨte Sekaraea tɨni Perekia sə kɨmiaha hiənousi əpune ia nimwə səvəi Kumwesən ia nɨmwrhenhi nɨfatə mɨne kwopun sə ro ikinan. ");
INSERT INTO tnk_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Iakani nɨpərhienien tukumiaha i narimnari me pam i treste kɨmiaha nərmama ipwet mɨne.” ");
INSERT INTO tnk_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem, Jerusalem! Ik taon i ikamousi əpune profet me, maməkwi əpune nərmama səməme Kumwesən ramərhi pehe irəha tukw ik. Nəpɨn rɨpɨk iakokeikei mə takousəsɨmwɨn nɨpwnətɨm me rəmwhen ia rɨnhi menu ramo ia tɨni me mauiui irəha ia tərəɡɨn mi. Mətə kɨmiaha hiəpwəh nokeikeiien. ");
INSERT INTO tnk_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Hətə ro. Təkwtəkwuni nəha Kumwesən trəpwəh nimwə səkɨmiaha ro tekɨn a. ");
INSERT INTO tnk_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Iakamɨni pehe tukumiaha i mə kɨmiaha tihəpwəh mwi nətoniien iou meste tihəni mə, ‘Səɡnəɡɨni iərmama i rauvehe ia nəɡhi Iərɨmənu səkɨtaha.’” ");
INSERT INTO tnk_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesu rier ia nimwə səvəi Kumwesən mamevən. Ia nəpɨn nəha nərmama me səvənhi həuvehe mhahatən pen nimwə nəha mɨne nimwə me nəha kɨməuvrhəkɨn pen mwi irə mə in trətoni. ");
INSERT INTO tnk_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nənə Iesu rɨni pen tɨ nirəha i mə, “Kɨmiaha hiamətə nimwə me i? Iakani nɨpərhienien tukumiaha i mə tukamevən tukousi testesi pam, kəruəterei riti ko rəpwəh nərer əknekɨnien ia riti.” ");
INSERT INTO tnk_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kurirə irə Iesu raməkure ia Təkuər Olif, nənə nərmama me səvənhi həuvehe tukwe. Nəpɨn irəha min əpa həres pen in i mə, “Tiko mɨni ro tukumaha i mə narimnari me i tuhəuvehe tɨnesən? Nəfe nɨmtətien truvehe mahatən pen mə nuveheien səim mɨne nəpɨn sampam krouvəuvehe ipaka?” ");
INSERT INTO tnk_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Kɨmiaha tihaməsiari kamo iərmama riti reikuə ia kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nərmama həpɨk tuhəuvehe ia nəɡhɨk, mhəni mə irəha Kristo. Tuheikuə ia nərmama həpɨk. ");
INSERT INTO tnk_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kɨmiaha tihəreɡi nərmama tuhəvisau ia naruaɡənien me mə ‘naruaɡənien riti fwe’ uə ‘naruaɡənien trutə.’ Tihətui amasan rərəha hiəhekɨr, tɨ nəri nə mə nəri nəha traməkeikei muvehe, mətə rɨpko mhə ihi nəpɨn sampam. ");
INSERT INTO tnk_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Iakamɨni iamɨnhi irə tɨ nəri nə mə nərmama ia kwənəkwus riti tuhəskəmter mharuaɡən irəha nərmama ia kwənəkwus əpə. Nərmama səvəi kiɡ riti tuhəskəmter mharuaɡən irəha nərmama səvəi kiɡ əpə. Nukumhə trahi nərmama. Kwopun me nepwɨn nɨmwnɨmwien trɨkiu. ");
INSERT INTO tnk_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mətə narimnari me pam i rəmwhen a ia pran sə rɨnamreɡi təkutan rɨnaməmisə tɨ nərəhiien iəkunouihi. ");
INSERT INTO tnk_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ia nəpɨn nəha tukuvei pen kɨmiaha ia rəɡi nərmama mə irəha tuho nəmisəien m kɨmiaha, mhousi əpune kɨmiaha. Nərmama ia tənəmtənə me pam tuhəmwəki kɨmiaha tɨ nəri nə mə kɨmiaha nərmama me səiou. ");
INSERT INTO tnk_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nərmama həpɨk nahatətəien səvənraha trɨmwei. Irəha tuhəseni pen irəha me ia rəɡi nəmə ərəha me, mhəmwəki irəha me. ");
INSERT INTO tnk_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Profet eikuə me həpɨk tuhəskəmter, mheikuə ia nərmama me həpɨk. ");
INSERT INTO tnk_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nənə tɨ nəri nə mə noien ərəha truvehe masori, nərmama həpɨk nokeikeiien səvənraha truvehe məkwiei. ");
INSERT INTO tnk_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mətə iərmama sə trərer əknekɨn ia nahatətəien səvənhi meste nərəhaien me i həuvehe mhəukurau pam, Kumwesən truvehimɨru in. ");
INSERT INTO tnk_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tukɨni irapw nəɡkiariien amasan i raməɡkiari ia nɨtətə sə Kumwesən ramərɨmənu irə. Nərmama ia tənəmtənə me pam tuhaməkeikei mhəreɡi kurirə irə nəpɨn sampam truvehe.” ");
INSERT INTO tnk_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Kɨmiaha tihətoni nəri nəha Profet Taniel rɨməni kani mə ‘Nəri sə rərəha anan mamouraha narimnari ikinan.’ Tramərer ia kwopun ikinan fwe ia nəkwai nimwə səvəi Kumwesən. Nəpɨn kɨmiaha tihətoni, iərmama sə raməvsini nəkukuə i traməkeikei mukurən nɨpwran. ");
INSERT INTO tnk_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nərmama ia tənə Jutia tuhaməkeikei mhap mhərkwafə ia təkuər me. ");
INSERT INTO tnk_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Trɨni mɨnuə iərmama riti ramapwɨs ia təkure nimwə səvənhi, traməkeikei meiwaiu map akwauakw, məpwəh nuvnimwəien mə truvehi nari riti sə rəmak ia nəkwai nimwə səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nənə trɨni mɨnuə iərmama riti raməmhu ia nəmhien səvənhi, traməkeikei map akwauakw, məpwəh nɨrərɨɡien mevən imwəni mə truvehi səvənhi tɨnari. ");
INSERT INTO tnk_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Trərəha anan tɨ nɨpran me səməme tuhəpəmpəm mɨne səməme tuhaməuvei pen kənunu m nəkwərhakwərha əmtəmetə me ia nəpɨn nəha. ");
INSERT INTO tnk_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Tihəfwaki mə nəpɨn nəha tihap irə trəpwəh nuveheien ia nəpɨn səvəi nəkwieiien uə ia Sapat riti, ");
INSERT INTO tnk_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","tɨ nəri nə mə nəpɨn nəha nəpɨn səvəi nərəhaien. Nərəhaien nəha trasori məpi raka nərəhaien me pam səməme həuvəuvehe raka fwe nukune narəien mesite pehe ipwet mɨne. Nənə nərəhaien riti mwi riwən truvehe məpi raka. ");
INSERT INTO tnk_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ko nərəhaien nəha ravən əpwəmwɨs, nərmama me hemhə pam. Mətə Iərɨmənu tro nəpɨn sə nərəhaien nəha travən irə rukwakwa. In tro iamɨnhi irə mə truvehimɨru nərmama me səvənhi səməme in ruvərfi raka irəha. ");
INSERT INTO tnk_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ia nəpɨn nəha, trɨni mɨnuə iərmama riti rɨni pehe tukumiaha i mə, ‘Hətə ro, Kristo i’ uə ‘Hətə ro, Kristo nəha,’ kɨmiaha tihəpwəh nɨniien nɨpərhienien irə. ");
INSERT INTO tnk_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nərmama tuhəskəmter. Nepwɨn tuhəni mə irəha Kristo, mətə neikuəien. Nepwɨn tuhəni mə irəha profet, mətə neikuəien. Tuho nɨmtətien asori me mɨne narimnari me nərmama tuhətoni mhərkəri asori nari irə. Irəha tuhəmwur mə tuheikuə ia nərmama səməme Kumwesən ruvərfi raka irəha, trɨni mɨnuə irəha həukurən noien. ");
INSERT INTO tnk_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Hətə ro. Narimnari me pam iakukupwən muvəni raka tukumiaha i. ");
INSERT INTO tnk_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ro iamɨnhi irə trɨni mɨnuə nərmama me nepwɨn həni pehe tukumiaha i mə, ‘Hətə ro. Kristo in fwe ia kwopun akwesakwes ikɨn,’ tihəpwəh nevənien fwe ikɨn. Trɨni mɨnuə həni mə, ‘Hətə ro. In i ia nəkwai nimwə,’ tihəpwəh nɨniien nɨpərhienien irə. ");
INSERT INTO tnk_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nəpɨn rouapɨr irə nərmama hətoni nəhiapwien səvənhi fwe pesu meste nari fwe prehi. Iou, Iəməti Iərmama, nuveheien səiou tro mwi iamɨnhi irə. ");
INSERT INTO tnk_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ia kwopun pəku nɨpwrai nəri remhə ikɨn menu me nəha kamhani nɨpwrai nəri sə remhə tuhəuvehe mhousəsɨmwɨn irəha me, mhani.” ");
INSERT INTO tnk_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Nəpɨn nərəhaien nəha trukurau pam, təkwtəkwuni a mwi meri truvehe mɨpitəv, məkwə trəpwəh nəhiapwien, kəməhau me ia nɨmaɡouaɡou tuhəsasəsas, narimnari me ia nɨmaɡouaɡou həskai pɨk, Kumwesən trɨkiukiu ia nirəha. ");
INSERT INTO tnk_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ia nəpɨn nəha nɨmtətien səiou Iəməti Iərmama trier irapw ia nɨmaɡouaɡou. Nənə nərmama ia kwənəkwus me pam ia təkure tɨprənə i tuhəreɡi rərəha mhasək tukwe. Irəha tuhətoni iou, Iəməti Iərmama, ia nəpuə fwe ia nɨmaɡouaɡou iakauvehe ia nɨskaiien mɨne nukuraanien asori. ");
INSERT INTO tnk_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ia nəpɨn nəha kisɨpw riti trasək asori, nənə takərhi raka naɡelo me səiou, həuvrehi, mhəuvesu, mhəuveraha, mhəuvarei, mhəuvən ia kwopun me pam ia tɨprənə i, mhəpeki nərmama me səməme iakɨmərfi irəha mə səiou, mhəpeki irəha mhəuvehe.” ");
INSERT INTO tnk_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Həreɡi ro nusipekɨnien səvəi nei nəha niemɨs. Nəpɨn rɨnarkwi pen tukun sə rɨmərməru mɨnaməpɨrpɨr, kɨmiaha hiəukurən mə nəpɨn səvəi nəpnəpanien ruvəuvehe ipaka. ");
INSERT INTO tnk_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Rəmwhen a mwi, nəpɨn kɨmiaha tihətoni narimnari me i, tihəukurən mə iou, Iəməti Iərmama, iakuvəuvehe ipaka, rəmwhen a iakamərer ia kwəruə ia nimwə mə takuvnimwə pehe. ");
INSERT INTO tnk_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Iakani nɨpərhienien tukumiaha i mə nərmama səməme kamhəmɨru təkwtəkwuni mɨne tuhəpwəh nemhə pamien meste narimnari me pam i həier pehe. ");
INSERT INTO tnk_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Neiai mɨne tɨprənə trouiwən, mətə nəɡkiariien me səiou tuhəpkiwən mhə.” ");
INSERT INTO tnk_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Mətə nəpɨn səvəi nəri nəha uə aoa səvənhi iərmama riti riwən rukurən. Naɡelo me ia neiai mɨne iou mwi, Tɨni Kumwesən, iahəreirei. Mətə Tata səiou əpa rukurən. ");
INSERT INTO tnk_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nəpɨn nəha iou, Iəməti Iərmama, takuvehe irə trəmwhen ia nəpɨn səvəi Noa. ");
INSERT INTO tnk_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nəpɨn nesən asori rəpwəh ihi nauərien, nərmama me kamhəveɡɨn, mamhənɨmwi. Nərman me kamhəiri nɨpran. Nɨpran me kamhesi pen nərman. Irəha kamho noien me nəha mamhəuvən meste Noa ruvnimwə ia nɨtətə asori səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Irəha həreirei mə tuhemhə meste nesən asori rauər, nənə iapiwən raiu mɨpeki raka irəha həmwhenɨmw. Iou, Iəməti Iərmama, nuveheien səiou tro mwi iamɨnha irə. ");
INSERT INTO tnk_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ia nəpɨn nəha iərman kəru trouəmhu ia nəmhien, tukuvehi raka riti, kəpwəh riti. ");
INSERT INTO tnk_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Pran kəru trouvənari ia kwopun kuatia, tukuvehi raka riti, kəpwəh riti. ");
INSERT INTO tnk_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ro iamɨnhi irə kɨmiaha tihamətui a mhəpwəh napriien tɨ nəri nə mə hiəreirei nəfe nəpɨn Iərɨmənu səkɨmiaha truvehe irə. ");
INSERT INTO tnk_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mətə kɨmiaha tihaməkeikei mhəukurən nəri. Trɨni mɨnuə iərmama riti rukurən mə ipwet ia nəpɨn iərmama riti truvehe muvnimwə ia nəkwai nimwə səvənhi makres, in tramətui a məpwəh napriien. Ko in rəpwəh nəseniien iərmama riti reitehi nimwə səvənhi muvnimwə makres. ");
INSERT INTO tnk_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Rəmwhen a mwi kɨmiaha mwi tihaməkeikei mhəpnəpenə tɨ nəri nə mə iou, Iəməti Iərmama, takuvehe ia nəpɨn riti tihakiraka iou. ");
INSERT INTO tnk_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Iotukwininari sə rukurən nari, mamo nəkwai iəmə asori səvənhi ia nəpɨn me pam, iəmə asori səvənhi truvehi utə in ruvehe masori ia nimwə səvənhi mə trəkwməni nərmama me səvənhi ia nəpɨn atukwatukw kamhani nari irə. ");
INSERT INTO tnk_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Trɨni mɨnuə iəmə asori səvəi iotukwininari nəha ruvehe mətoni mə ramo wok me iamɨnha irə, iotukwininari nəha rerɨn traɡien. ");
INSERT INTO tnk_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Iakani nɨpərhienien tukumiaha i iəmə asori nəha truvehi utə iotukwininari nəha ruvehe masori ia narimnari me pam səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mətə mə iotukwininari nəha rerɨn rɨnamrhi mə iəmə asori səvənhi ramo tanpen, məpwəh nuvehe akwauakwien, ");
INSERT INTO tnk_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","nənə rɨnamousi nərman mɨne nɨpran səməme kamho tukwini pəri nari irəha min, maməveɡɨn, mamənɨmwi, mamakonə irəha nərmama kamhənɨmwi pɨk, ");
INSERT INTO tnk_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","iəmə asori səvənhi truvehe ia nəpɨn riti in trakiraka in, uə ia aoa riti sə in rɨreirei. ");
INSERT INTO tnk_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nənə iəmə asori səvənhi trərpwɨn noien ərəha me səvənhi, məmri pen in ramarə irəha kəuətkəsuə me. Ia kwopun nəha irəha tuhasək, mhahi tərini revɨnraha.” ");
INSERT INTO tnk_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Nəpɨn nəha nɨtətə ia neiai truvehe irə trəmwhen ia nɨprən ouihi me irəha pam ten. Həuvehi laet me səvənraha mhəuvən mə tuhətoni iərman sə triri vi a pran səvənhi. Iərman nəha triri prən nəha krouevən fwe imwəni rouarə pəri. ");
INSERT INTO tnk_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Prən ouihi me nəha krirum həreirei nari. Krirum həukurən nari. ");
INSERT INTO tnk_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nəpɨn səməme həreirei nari həuvehi laet me səvənraha, həpwəh nuvehiien oel laet rauək irə irəha mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Mətə səməme həukurən nari həuvehi laet me səvənraha, mhəuvehi mwi tɨkinari me nepwɨn həukuər ia oel laet rauək irə. ");
INSERT INTO tnk_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nənə tɨ nəri nə mə iərman sə rɨpkiri a pran səvənhi ramo tɨpwə irəha həreɡi napriien ruvehi irəha hapri. ");
INSERT INTO tnk_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Mətə ia kurkwai nəpɨn iərmama riti rəkwein, mɨni mə, ‘Iərman sə rɨpkiri a pran səvənhi rauvehe! Həuvehe mhətoni!’ ");
INSERT INTO tnk_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ia nəpɨn nəha nɨprən ouihi me nəha ten hətui, mhəpərhi laet me səvənraha. ");
INSERT INTO tnk_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nənə səməme həreirei nari həni pen tɨ səməme həukurən nari mə, ‘Həuvei pehe səkɨmiaha riti oel laet rauək irə. Laet me səkɨmaha hənaməfwə.’ ");
INSERT INTO tnk_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Mətə səməme həukurən nari həni mə, ‘Rekəm. Oel i laet rauək irə trɨpkəmwhen mhə tukutaha pam. Həuvən fwe ia stoa me mhəuvehi nəmri səkɨmiaha me nepwɨn.’ ");
INSERT INTO tnk_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Nəpɨn irəha kamhəuvən mə tuhəuvehi nəmri oel laet rauək irə, iərman sə rɨpkiri a pran səvənhi rapirapw. Nɨprən ouihi me nəha krirum səməme hənəpnəpenə, həuvnimwə irəha min ia nəkwai nimwə sə tukəni nəveɡɨnien asori ikɨn. Nənə nərmama həsisəɡ ia təpinhə. ");
INSERT INTO tnk_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kurirə irə nɨprən ouihi me nəha səməme həpkəpnəpenə mhə hərərɨɡ mwi, mhəuvehe, mamhəkwein mə, ‘Iərɨmənu, Iərɨmənu, əsevər ia təpinhə tukumaha.’ ");
INSERT INTO tnk_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mətə iərman sə rɨpkiri a pran səvənhi rɨni mə, ‘Iakamɨni nɨpərhienien tukumiaha i iakreirei kɨmiaha.’” ");
INSERT INTO tnk_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nənə Iesu rɨni mə, “Ro iamɨnhi irə kɨmiaha tihaməkeikei mhətui amasan, mhəpwəh napriien, tɨ nəri nə mə hiəreirei nəfe nəpɨn uə aoa Iərɨmənu səkɨmiaha truvehe irə.” ");
INSERT INTO tnk_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Nuveheien səvənhi trəmwhen iərmama riti sə rauvehi navənien əpwəmwɨs səvənhi. Kurirə rier imwəni rəkwein nərmama səməme kamho tukwini nari min həuvehe. Nənə rəmri pen mane səvənhi ia rəɡɨnraha mə tuhətui amasan tukwe. ");
INSERT INTO tnk_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ia riti ruvei pen tənərɨpw me krirum mane rukuər irə, nənə tənərɨpw kəru m riti, nənə tənərɨpw kuatia m riti. Ruvei pen kuatia kuatia mɨnraha rəmwhen in rukurən mə trətui amasan tukwe. Kurirə irə in rier mamevən. ");
INSERT INTO tnk_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Iərmama sə ruvehi tənərɨpw krirum revən atukwatukw mowok irə, nənə muvehi mane asori rukuər ia tənərɨpw krirum mwi. ");
INSERT INTO tnk_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nənə iərmama sə ruvehi tənərɨpw kəru ro mwi iamɨnhi, nənə muvehi mane asori rukuər ia tənərɨpw kəru mwi. ");
INSERT INTO tnk_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mətə iərmama sə ruvehi tənərɨpw kuatia revən meri tɨprənə, mɨnɨmwi mane səvəi iəmə asori səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Nəpɨn əpwəmwɨs rukurau, iəmə asori səvəi nərmama me nəha rɨrərɨɡ muvehe, nənə mokeikei mə trəskun mane me nəha rɨməuvei pen mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nənə iərmama sə rɨməuvehi tənərɨpw krirum ruvehe mərer ia nəmri iəmə asori səvənhi, mɨni mə, ‘Iəmə asori, fwe kupwən ikɨməuvei pehe tənərɨpw krirum miou mane rukuər ia nirəha. Ətə ro, iakɨnowok irə rəkwəhi mwi masori iakuvai pen ia tənərɨpw krirum mwi.’ ");
INSERT INTO tnk_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Nənə iəmə asori səvənhi rɨni pen tukwe in mə, ‘Ik iəmə amasan. Ikamo tukwini amasan nari miou ia nəpɨn me. Ikɨnətui amasan tɨ nəri ouihi i iakɨnəmri pehe ia rəɡɨm, mo pen tako ik ikuvehe masori mətui tɨ narimnari me rɨpɨk. Uvnimwə pehe ia nəkwai nimwə səvəi iəmə asori səim. Pwəh krau krauaɡien pəri.’ ");
INSERT INTO tnk_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Nənə iərmama sə rɨməuvehi tənərɨpw kəru in mwi ruvehe mərer ia nəmri iəmə asori səvənhi, mɨni mə, ‘Iəmə asori, fwe kupwən ikɨməuvehi pehe tənərɨpw kəru miou mane rukuər ia nirau. Ətə ro, iakɨnowok irə rəkwəhi mwi masori iakuvai pen ia tənərɨpw kəru mwi.’ ");
INSERT INTO tnk_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nənə iəmə asori səvənhi rɨni pen tukwe in mə, ‘Ik iəmə amasan. Ikamo tukwini amasan nari miou ia nəpɨn me. Ikɨnətui amasan tɨ nəri ouihi i iakɨnəmri pehe ia rəɡɨm, mo pen tako ik ikuvehe masori mətui tɨ narimnari me rɨpɨk. Uvnimwə pehe ia nəkwai nimwə səvəi iəmə asori səim. Pwəh krau krauaɡien pəri.’ ");
INSERT INTO tnk_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nənə iərmama sə ruvehi tənərɨpw kuatia in mwi ruvehe mərer ia nəmri iəmə asori səvənhi, mɨni mə, ‘Iəmə asori. Iakukurən mə ik iərmama riti noien səim rɨskai. Ik ikapeki nəveɡɨnien ia nəmhien sə ipkəmhu mhə irə, nənə mamesi mwi nukwai nei me ia kwopun ipkəpwei mhə nuni nari ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ro iamɨnhi irə, iakɨhekɨr, mevən, mɨnɨmwi tənərɨpw səim sə mane rukuər irə ia tɨprənə. Ətə ro in i mane səim.’ ");
INSERT INTO tnk_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Mətə iəmə asori səvənhi rɨni pen tukwe in mə, ‘Ik iəmə ərəha. Ikamo tukwini ərəha nari miou, mamarpaha. Ikuvəukurən raka mə iakapeki nəveɡɨnien ia nəmhien sə iapkəmhu mhə irə, nənə mamesi mwi nukwai nei me ia kwopun iapkəpwei mhə nuni nari ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Mətə rəfo ikəpwəh nəmri penien mane səiou fwe ia paɡ? Kamo ipkəmri pen ko iapkuvehe mɨpkuvehi ihi mane səiou mɨne sə rəkwaku paɡ rəkwəhi.’ ");
INSERT INTO tnk_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nənə iəmə asori rɨni pen tɨ nərmama səməme kamho tukwini nari min mə, ‘Həuvei raka tənərɨpw tukwe, mhəuvei pen m iərmama sə rɨməuvehi tənərɨpw ten. ");
INSERT INTO tnk_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Iərmama sə kuvei pen nari riti min, ro wok irə, tukuvei pen mwi rasori mwi min, nənə in truvehi rəmwhen məpi raka. Mətə iərmama sə kuvei pen nari riti min, ro nəri auər a irə, tukuvehi raka pam tukwe. ");
INSERT INTO tnk_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mətə iərmama i sə ramo tukwini ərəha nari miou hərarki irapw i iruə ia nəpitəvien. Ia kwopun nəha nərmama tuhasək, mhahi tərini revɨnraha.’” ");
INSERT INTO tnk_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Nəpɨn nəha iou, Iəməti Iərmama, takuvehe irə ia nukuraanien asori kɨmaha naɡelo me, takəkure ia jea səiou mərɨmənu. ");
INSERT INTO tnk_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nərmama ia tənəmtənə me pam tuhəuvehe mhousəsɨmwɨn pehe irəha me ia nənimek, nənə iou takuai irəha rəmwhen iərmama sə ramətui tɨ sipsip me muai sipsip me mɨne nəni me. ");
INSERT INTO tnk_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Takuai pen sipsip me ia nɨkarek mwatuk, mətə nəni me ia nɨkarek mour. ");
INSERT INTO tnk_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nənə iou kiɡ səvənraha takɨni pen tɨ nərmama me nəha ia nɨkarek mwatuk mə, ‘Həuvehe kɨmiaha i səməme Tata səiou raməkwein amasan ia kɨmiaha. Nəpɨn tɨprənə namiwən ihi, in rɨnəpnəpenə raka kwopun səkɨmiaha ia nɨtətə sə in ramərɨmənu irə. Həuvehe mharə irə. ");
INSERT INTO tnk_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nəpɨn nukumhə rahi iou hiəuvei pehe nəveɡɨnien miou. Nənə nəpɨn iakakwakwa hiəuvei pehe nui miou. Nəpɨn iakamavən rəmwhen ia iərmama pwɨspwɨs, hiəuvehi puvnimwə iou ia nəkwai nimwə me səkɨmiaha me. ");
INSERT INTO tnk_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nəpɨn tɨnari səiou riwən, hiarkahu pehe miou. Nəpɨn iakamemhə, hiəuvehe mhəti pehe iou. Nəpɨn iakamarə ia kalapus, hiəuvehe tukw iou.’ ");
INSERT INTO tnk_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Mɨreɡi nəkur atukwatukw me nəha tuhəni pehe tukw iou i mə, ‘Iərɨmənu. Mətə nəfe nəpɨn nəha kɨmaha iahənətoni nukumhə rahi ik, nənə iahəuvei pehe nəveɡɨnien mik, uə ikakwakwa nənə iahəuvei pehe nui mik? ");
INSERT INTO tnk_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nəfe nəpɨn kɨmaha iahətoni ikamavən rəmwhen ia iərmama pwɨspwɨs riti, nənə iahəuvehi puvnimwə ik ia nimwə me səkɨmaha me, uə səim tɨnari riwən, nənə iaharkahu pehe mik? ");
INSERT INTO tnk_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nəfe nəpɨn kɨmaha iahətoni ikamemhə, uə ikamarə ia kalapus, nənə iahəuvehe mhəti pehe ik?’ ");
INSERT INTO tnk_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mɨreɡi iou kiɡ səvənraha takɨni pen tɨ nirəha i mə, ‘Iakamɨni nɨpərhienien tukumiaha i nəpɨn kɨmiaha həno noien nəha ia piak riti sə in iəmə auər a ia piak me, hiəno noien nəha ia nirak.’ ");
INSERT INTO tnk_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kurirə irə iou takɨni pen tɨ nərmama me nəha ia nɨkarek mour mə, ‘Kɨmiaha i Kumwesən raməkwein ərəha ia kɨmiaha haraka ia nənimek mhəuvən ia napw sə rauək rerɨn. Kɨnəse napw nəha tɨ Setan mɨne naɡelo me səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nəpɨn nukumhə rahi iou kɨmiaha hiəpwəh nuvei peheien nəveɡɨnien miou. Nəpɨn iakakwakwa hiəpwəh nuvei peheien nui miou. ");
INSERT INTO tnk_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nəpɨn iakamavən rəmwhen ia iərmama pwɨspwɨs riti, hiəpwəh nuvehi puvnimwəien iou ia nəkwai nimwə me səkɨmiaha me. Nəpɨn tɨnari səiou riwən, hiəpwəh narkahu peheien miou. Nəpɨn iakamemhə uə iakamarə ia kalapus, hiəpwəh nəti peheien iou.’ ");
INSERT INTO tnk_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Mɨreɡi irəha mwi tuhəni pehe tukw iou i mə, ‘Iərɨmənu, mətə nəfe nəpɨn nəha kɨmaha iahənətoni nukumhə rahi ik, uə ikakwakwa uə ikamavən rəmwhen ia iərmama pwɨspwɨs, uə tɨnari səim riwən, uə ikamemhə, uə ikamarə ia kalapus, nənə kɨmaha iahəpwəh nasituien ia niram?’ ");
INSERT INTO tnk_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Mɨreɡi iou takɨni pen tɨ nirəha i mə, ‘Iakani nɨpərhienien tukumiaha i nəpɨn kɨmiaha hiəpwəh noien nəha ia piak riti sə in iəmə auər ia piak me, hiənəpwəh noien nəha ia nirak.’ ");
INSERT INTO tnk_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nənə nərmama me nəha tuhəuvən ia kwopun Kumwesən trərpwɨn rerɨn noien ərəha me səvənraha ikɨn. Mətə nərmama atukwatukw tuhəuvən mhəuvehi nɨmɨruien rerɨn.” ");
INSERT INTO tnk_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nəpɨn Iesu rɨni pam nəɡkiariien me nəha, in rəɡkiari m nərmama me səvənhi, mɨni mə, ");
INSERT INTO tnk_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kɨmiaha hiəukurən mə nəpɨn kəru mwi tuko Pasova. Ia nəpɨn nəha tukuvei pen iou, Iəməti Iərmama, ia rəɡi nərmama me mə irəha tuhərui tərini pen iou ia nei kamarkuaui.” ");
INSERT INTO tnk_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ia nəpɨn nəha pris asori me mɨne nəmə asori me səvəi nəkur Isrel housəsɨmwɨn irəha me ia nəkwai nimwə səvəi pris asori anan. Nəɡhɨn nə Kaeafas. ");
INSERT INTO tnk_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nənə hərai sun mə tuhəuvən afafa, mhəkwtəmhiri Iesu, mhousi əpune. ");
INSERT INTO tnk_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Mətə həni mə, “Pwəh kɨtaha səpwəh nəkwtəmhiriien Iesu ia nəpɨn səvəi nəveɡɨnien asori. Rərəha mə nərmama niemaha trəpi irəha kamho nurɨɡrɨɡien asori tukwe.” ");
INSERT INTO tnk_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nəpɨn Iesu ramarə ia rukwənu nəha Petani, ruvnimwə pen ia nəkwai nimwə səvəi Saemon (Saemon nəha kupwən nemhəien skai ro tekɨn.) ");
INSERT INTO tnk_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nənə pran riti ruvehe tɨ Iesu mauvehi potel riti kɨno ia kəruəterei riti kani mə alapasta. Fwe ia nəkwai potel nəha senta riti nənimen rutə pɨk. Prən nəha rətəɡi pen senta nəha ia nukwəne Iesu nəpɨn raməkure ia kwopun kaməni nari ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nənə nəpɨn nərmama me səvəi Iesu hətoni, niemaha rəpi irəha. Həni mə, “Rəfo ramouraha senta iamɨnhi? ");
INSERT INTO tnk_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Rɨpkəmri pen a nəmri nari irə, ko ruvehi mane asori irə, muvei pen m nərmama nautə səvənraha riwən.” ");
INSERT INTO tnk_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Mətə nəpɨn Iesu rɨreɡi nəɡkiariien nəha, rɨni pen tɨ nirəha i mə, “Rəfo kɨmiaha hiamo iamɨnhi irə ia prən i? In ramo noien amasan riti miou. ");
INSERT INTO tnk_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nərmama nautə səvənraha riwən tuhamarə kɨmiaha mɨnraha ia nəpɨn me, mətə iou tapkarə mhə kɨtaha m kɨmiaha nəpɨn me. ");
INSERT INTO tnk_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Rəfo prən i rətəɡi pehe senta i ia nɨpwrak? In ro mə trəpnəpenə ia nɨpwrak mə tukɨnɨmwi. ");
INSERT INTO tnk_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Iakamɨni nɨpərhienien tukumiaha i kwopun pəku ia tənəmtənə me tukɨni irapw nəɡkiariien amasan səiou ikɨn tukɨni irapw nəfe prən i rɨno miou mə nərmama rerɨnraha tramrhi.” ");
INSERT INTO tnk_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nərmama me səvəi Iesu irəha pam twelef, riti ia nirəha nəɡhɨn nə Jutas Iskariot. Revən tɨ pris asori me, ");
INSERT INTO tnk_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","mɨni mə, “Trɨni mɨnuə iakuvei pehe Iesu ia rəɡɨmiaha, kɨmiaha tihəuvei pehe nəfe miou?” Irəha hərəku in silin me kɨno ia silva irəha pam toti. ");
INSERT INTO tnk_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ia nəpɨn atukwatukw nəha Jutas rɨnamətui suatuk mə truvei pen Iesu ia rəɡɨnraha. ");
INSERT INTO tnk_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Neste atukwatukw nəpɨn nəha tuhani bred sə yis riwən irə. Nərmama me səvəi Iesu həuvehe tukwe in, mhəni mə, “Kwopun pəku nəha ikokeikei mə kɨmaha tahəpnəpenə nəveɡɨnien səvəi Pasova ikɨn, nənə ik tikəni?” ");
INSERT INTO tnk_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Mɨreɡi Iesu rɨni mə, “Həuvən fwe Jerusalem, mhətoni iərmama riti fwe ikɨn, mhəni pen tukwe in mə, ‘Iahatən səkɨtaha rɨni mə nəpɨn səiou ruvəuvehe ipaka. Tahani pəri nəveɡɨnien səvəi Pasova kɨmaha nərmama me səiou ia nəkwai nimwə səim.’” ");
INSERT INTO tnk_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nərmama me səvəi Iesu həuvən mho nəfe rɨməni pen tɨ nirəha i, mhəpnəpenə tɨ nəveɡɨnien səvəi Pasova. ");
INSERT INTO tnk_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ia nəruarəv Iesu mɨne twelef nərmama me səvənhi kamhəkure ");
INSERT INTO tnk_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","mamhani pəri nari. Nənə Iesu rɨni pen tɨ nirəha i mə, “Iakamɨni nɨpərhienien tukumiaha i mə kɨmiaha riti truvei pen iou ia rəɡi nərmama səməme kamhəmwəki iou.” ");
INSERT INTO tnk_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nəpɨn irəha həreɡi nəɡkiariien nəha, rerɨnraha rəpou. Həuvehe kuatia kuatia mamhəres Iesu i mə, “Iərɨmənu, sin nəha ikani? Iou?” ");
INSERT INTO tnk_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Mɨreɡi Iesu rɨni mə, “Iakani iərmama sə rameitesi bred ia tikiplet kuatia kɨmrau min. In truvei pen iou ia rəɡi nərmama səməme kamhəmwəki iou. ");
INSERT INTO tnk_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Iou, Iəməti Iərmama, takaməkeikei memhə rəmwhen kɨmərai pen ia Nəkukuə Ikinan, mətə trərəha anan tɨ iərmama sə truvei pen iou ia rəɡi nərmama səməme kamhəmwəki iou. Ramasan pɨk mə rɨpkəpwəh a nətuiien.” ");
INSERT INTO tnk_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nənə Jutas, iərmama sə truvei pen Iesu ia rəɡi nərmama kamhəmwəki in, rɨni mə, “Iahatən, sin nəha ikani? Iou?” Mɨreɡi Iesu rɨni pen tukwe in mə, “Ik nə ikani.” ");
INSERT INTO tnk_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nəpɨn nəha kamhani nari irə, Iesu ruvehi bred, məfwaki mɨni vivi Kumwesən tukwe, nənə məkwsen, muvei pen m nərmama me səvənhi, mɨni mə, “Tihəuvehi, mhani. In i nɨpwrak.” ");
INSERT INTO tnk_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kurirə irə in ruvehi kap waen, məfwaki mɨni vivi Kumwesən tukwe. Məfwaki pam, nənə muvei pen mɨnraha, mɨni mə, “Kɨmiaha pam tihənɨmwi. ");
INSERT INTO tnk_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","In i nɨtek sə trərihi tərini əknekɨn nəɡkiariien vi səvəi Kumwesən. Traiu tɨ nərmama həpɨk mə Kumwesən trəpwəh nərpwɨnien noien ərəha me səvənraha. ");
INSERT INTO tnk_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Iakani pehe tukumiaha i tapkənɨmwi mhə mwi waen i meste nəpɨn nəha takənɨmwi waen vi kɨtaha m kɨmiaha ia nɨtətə sə Tata səiou ramərɨmənu irə.” ");
INSERT INTO tnk_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nənə irəha hani nɨpu riti, mho sampam irə, mhəier mhəuvən ia Təkuər Olif. ");
INSERT INTO tnk_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ia kwopun nəha Iesu rɨni pen tɨ səvənhi nərmama me i mə, “Ipwet ia nəpɨn kɨmiaha pam tihap raka ia nirak. Iakani iamɨnhi irə tɨ nəri nə mə kɨmərai pen ia Nəkukuə Ikinan mə Kumwesən rɨni mə, ‘Iou takousi iərmama sə ramətui tɨ sipsip, nənə sipsip me səvənhi tuhaiu kɨrkɨri.’ ");
INSERT INTO tnk_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Mətə in tro iakətui mwi ia nemhəien səiou. Takətui raka, mevən fwe ia tənə Kalili. Iou takukupwən kɨmiaha tihəkurirə.” ");
INSERT INTO tnk_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Mətə Pita rɨni pen tɨ Iesu i mə, “Irəha pam tuhap raka ia niram, mətə rɨpko mhə iou.” ");
INSERT INTO tnk_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Mɨreɡi Iesu rɨni pen tukwe in mə, “Iakani nɨpərhienien tukw ik i ipwet ia nəpɨn, kurirə rəiə rakaka, ik tikɨni m kahar mə ikreirei iou.” ");
INSERT INTO tnk_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Mətə Pita rɨni pen tukwe in mə, “Trɨni mɨnuə həni mə takaməkeikei memhə krau mik, mətə ko iakəpwəh nɨniien mə iakreirei ik.” Nənə nərmama me pam səvənhi həni nəɡkiariien kuatia. ");
INSERT INTO tnk_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Iesu mɨne nərmama me səvənhi həuvən ia kwopun riti nəɡhɨn nə Ketsemane. Nənə Iesu rɨni pen tɨ nirəha i mə, “Kɨmiaha tihaməkure ia kwopun i. Pwəh iou iakevən kwərha məfwaki.” ");
INSERT INTO tnk_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nənə in riri Pita mɨne tɨni Sepeti kəru irəhar harevən irəha min. Ia nəpɨn nəha in rɨnamreɡi rərəha, rerɨn rəpou pɨk. ");
INSERT INTO tnk_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nənə rɨni pen tɨ nirəhar i mə, “Rerɨk rəpou pɨk ipaka iakemhə tukwe. Tiamharo i, pwəh kɨtaha m kɨmirəhar tsəpwəh napriien.” ");
INSERT INTO tnk_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nənə Iesu revən ouihi a mwi mɨmwei ia tɨprənə məfwaki, mɨni mə, “Tata səiou. Tikuvehi raka kap i pwəh iakəpwəh nənɨmwiien. Mətə tikəpwəh noien rəmwhen sə iakokeikei, mətə tiko rəmwhen sə ikokeikei.” ");
INSERT INTO tnk_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nənə Iesu rəfwaki pam, mɨrərɨɡ pehe mətoni Pita mɨne Jemes mɨne Jon kamharapri. Nənə in rɨni pen tɨ Pita i mə, “Rəfo, ko hiəpkətui mhə nəpɨn ouihi a uə? ");
INSERT INTO tnk_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kɨmirəhar tiharətui mharəfwaki mə tiharəpwəh nɨmweiien ia nərəhaien. Nɨpərhienien rerɨmiaha raɡien mə tihəfwaki, mətə nɨpwramiaha rəpou.” ");
INSERT INTO tnk_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nənə Iesu revən səro kəru irə, məfwaki, mɨni mə, “Tata səiou. Trɨni mɨnuə kap i ko rɨpkiwən mhə meste iakənɨmwi, tako rəmwhen sə ikokeikei.” ");
INSERT INTO tnk_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nənə Iesu rɨrərɨɡ pehe mwi mətə irəhar harnapri mwi, tɨ nəri nə mə napriien ruvəuvehi irəhar. ");
INSERT INTO tnk_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ro iamɨnhi irə in rəpwəh mwi irəhar, mevən səro kahar irə, məfwaki, mɨni a mwi nəɡkiariien kuatia. ");
INSERT INTO tnk_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kurirə irə ruvehe mwi tɨ nərmama me səvənhi, mɨni pen tɨ nirəhar i mə, “Rəfo, hiamarapri, mamharuvehi ihi napwɨsien səkɨmiahar? Həreɡi ro. Nəpɨn nəha ruvəuvehe. Iərmama riti truvei pen iou, Iəməti Iərmama, ia rəɡi nəmə ərəha me. ");
INSERT INTO tnk_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tiharo mharərer. Pwəh saməuvən. Hətə ro, iərmama nəha trɨni pui iou ruvəuvehe ipaka.” ");
INSERT INTO tnk_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nəpɨn Iesu raməɡkiari ihi, Jutas, in riti ia twelef nərmama me səvəi Iesu, ruvehe irəha nərmama həpɨk. Nepwɨn kamhəuvehi nau. Nepwɨn kamhəuvehi nɨpəri nei. Pris asori me mɨne nəmə asori me səvəi nəkur Isrel hənərhi pen irəha. ");
INSERT INTO tnk_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jutas rɨnəɡkiari raka mɨnraha mə, “Iərmama sə takakei min, iəmə nə in nə. Kɨmiaha tihəkwtəmhiri.” ");
INSERT INTO tnk_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nənə Jutas ruvehe, mevən atukwatukw tɨ Iesu, mɨni mə, “Ramasan tukw ik, iahatən.” Nənə rakei min. ");
INSERT INTO tnk_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Mɨreɡi Iesu rɨni pen tukwe in mə, “Iou riti. Tiko mo nəfe ikɨməuvehe tukwe.” Nənə nərmama me həuvehe mhəmri pen rəɡɨnraha ia Iesu, mhəkwtəmhiri. ");
INSERT INTO tnk_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Mətə iərmama riti sə ramərer ipaka tɨ Iesu reivi raka nau səvənhi, mərai iərmama riti sə ramo tukwini nari m pris asori anan, mərai raka nɨkare nɨfreɡɨn. ");
INSERT INTO tnk_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nənə Iesu rɨni pen tukwe in mə, “Uvehi nau səim mɨvai pen ia təmwhekɨn, tɨ nəri nə mə nərmama me səməme kamhəuvehi nau mə tuharuaɡən irə tukərai əpune irəha ia nau. ");
INSERT INTO tnk_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kɨmiaha hiaməfətərɨɡ irə mə ko iapkəkwein mhə Tata səiou nənə təkwtəkwuni a irə in trərhi pehe naɡelo me taosen m taosen həuvehe mhasitu ia nirak? ");
INSERT INTO tnk_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mətə trɨni mɨnuə iako iamɨnhi irə nəɡkiariien i sə Nəkukuə Ikinan rani mə kɨmiaha tihəkwtəmhiri iou iamɨnhi irə trəfuvehe mukuə irə?” ");
INSERT INTO tnk_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ia nəpɨn nəha Iesu rɨni pen tɨ nərmama me i mə, “Rəfo hiaməuvehi nau me mɨne nɨpərpəri nei me mamhəuvehe mə tihəkwtəmhiri iou iamɨnhi irə? Nətərɨɡien səkɨmiaha rɨnuə iou rakres riti uə? Ia nərineiv m neis mɨne iakamarə fwe ia nimwə səvəi Kumwesən, mamahatən nərmama. Rəfo hiəpwəh nəkwtəmhiriien iou ia nəpɨn nəha? ");
INSERT INTO tnk_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mətə narimnari me i hiamo haməier pehe iamɨnhi irə mə nəɡkiariien me nəha profet kupwən me həmərai pen ia Nəkukuə Ikinan tuhəuvehe mhəukuə.” Nəpɨn nərmama me i həkwtəmhiri Iesu, nərmama me səvənhi həpwəh in mhap. ");
INSERT INTO tnk_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nərmama me nəha səməme həkwtəmhiri Iesu həiri in mhəuvən tɨ Kaeafas. Kaeafas in pris asori anan. Nahatən me səvəi Loa mɨne nəmə asori me səvəi nəkur Isrel hənousəsɨmwɨn raka irəha me ia nimwə səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita rakurirə ia Iesu, mamavən isipwɨn tukwe meste nari fwe nɨkare nimwə səvəi pris asori anan. Nənə muvnimwə, məkure irəha iotukwininari me, mə trətoni mə tukəfo irə ia Iesu. ");
INSERT INTO tnk_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nənə pris asori me mɨne nəmə asori me səvəi nəkur Isrel kamhətui nərmama nepwɨn mə tuheikuə, mhəni irapw nəri ərəha riti sə Iesu rɨno uə rɨməni. Nəmə asori me hokeikei mə tuhəreɡi pwəh housi əpune in tukwe. ");
INSERT INTO tnk_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nəri auər a mə nərmama həpɨk həskəmter mamheikuə ia nəfe hənətoni Iesu rɨno uə həməreɡi in rɨməni, mətə nəmə asori me həpkətə mhə nari riti. Mətə irəha kamhəmwur mamhəuvən meste iərmama kəru krouvehe, ");
INSERT INTO tnk_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","rouni mə, “Iəmə i rɨməni iamɨnhi irə mə, ‘Iou iakukurən nourahaien nimwə səvəi Kumwesən, marə muvrhəkɨn mwi ia nəpɨn kahar.’” ");
INSERT INTO tnk_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nənə pris asori anan rərer, mɨni pen tɨ Iesu i mə, “Nəɡkiariien riti riwən tikɨni? Rəfo ia nəɡkiariien nəha irau krouni rauuəsi ik irə?” ");
INSERT INTO tnk_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mətə Iesu rəpnapen. Nənə pris asori anan rɨni pen tukwe in mə, “Iakəres pehe ik i ia nəɡhi Kumwesən sə ramɨru. Ni pehe ro tukumaha i. Ik Kristo, Tɨni Kumwesən, uə rekəm?” ");
INSERT INTO tnk_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Mɨreɡi Iesu rɨni pen tukwe in mə, “Ik ikɨni, mətə iakani pehe tukumiaha i mə nəha təkwtəkwuni mɨne mamevən tihətoni iou, Iəməti Iərmama, takaməkure ia nɨkare Kumwesən mwatuk sə in nɨskaiien səvənhi rasori. Tihətoni mwi iou takauvehe ia nəpuə me ia nɨmaɡouaɡou.” ");
INSERT INTO tnk_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nənə nəpɨn pris asori anan rɨreɡi, reitehi tɨnari səvənhi, mɨni mə, “Kɨtaha tsətui iərmama riti mwi tro pui iəmə i tɨ nəfe? Kɨmiaha hiəuvəreɡi raka mə in rɨni ərəha Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nətərɨɡien səkɨmiaha mə tsəfo irə?” Mɨreɡi irəha həni mə, “In traməkeikei memhə.” ");
INSERT INTO tnk_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nənə hərɡəvəsi pen nənimen, mamhəuəsi in. Nepwɨn həpwi in, ");
INSERT INTO tnk_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","mamhəni mə, “Mə ik Kristo pərhien, ni pehe ro tukumaha i nəɡkiariien sə ruku pen tɨ Nənɨmwɨn mə sin ruəsi ik!” ");
INSERT INTO tnk_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ia nəpɨn nəha Pita fwe inhərɨpw ia nɨkare nimwə səvəi pris asori anan. Nənə pran riti sə ramo tukwini nari m pris asori anan ruvehe ipaka tukwe, mɨni mə, “Ik mwi ikɨnamavən pəri kɨmirau Iesu iəmə Kalili.” ");
INSERT INTO tnk_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mətə ia nəmrɨnraha pam Pita rɨni mə, “Rekəm. Iou iakreirei nəfe i ikamɨni.” ");
INSERT INTO tnk_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pita rəpwəh nɨkare nimwə nəha mier mevən ipaka tɨ təpinhə asori riti sə nərmama kamhəuvnimwə pehe irə. Nənə pran riti mwi sə ramo tukwini nari rətə in, mɨni pen tɨ nərmama səməme kamhərer ia kwopun nəha mə, “Iəmə i rɨnamavən pəri irau Iesu iəmə Nasaret.” ");
INSERT INTO tnk_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Mɨreɡi Pita rɨni mwi mə, “Rekəm. Iakani pehe tukw ik i kwəsuahi anan mə iou iakreirei iəmə nəha ikani.” ");
INSERT INTO tnk_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nəpɨn ouihi a rukurau, nənə nərmama səməme kamhərer ia kwopun nəha həuvehe, mhəni pen tɨ Pita i mə, “Nɨpərhienien. Ik riti ia nirəha tɨ nəri nə mə ik iəmə Kalili.” ");
INSERT INTO tnk_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mɨreɡi Pita rɨni mə, “Mə iakameikuə pwəh Kumwesən rərpwɨn noien ərəha səiou. Iakani pehe tukumiaha i kwəsuahi anan mə iou iakreirei iəmə nəha kɨmiaha hiaməni.” Pita rɨni iamɨnhi irə, nənə təkwtəkwuni a rəiə rakaka. ");
INSERT INTO tnk_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nənə Pita rerɨn rɨrhi nəɡkiariien səvəi Iesu. Rɨməni mə, “Kurirə rəiə rakaka, ik tikɨni m kahar mə ikreirei iou.” Pita rerɨn rɨrhi. Nənə rier mevən mɨrapi nasəkien. ");
INSERT INTO tnk_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ia nəpnəpɨn pris asori me mɨne nəmə asori me səvəi nəkur Isrel irəha pam hərai sun mə tuhousi əpune Iesu. ");
INSERT INTO tnk_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Irəha həiri in, mhəuvən, mhəmri pen in ia rəɡi Paelat. Paelat nəha in iəmə Rom sə ramərɨmənu ia kwopun nəha. ");
INSERT INTO tnk_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nəpɨn Jutas iəmə i sə rɨməuvei pen Iesu ia rəɡi nərmama səməme kamhəmwəki, in rətoni mə irəha həni mə Iesu traməkeikei memhə, in rərari ia nətərɨɡien səvənhi, muvehi silin me nəha kɨno ia silva irəha pam toti, muvehi muvehe, muvei pen m pris asori me mɨne nəmə asori me səvəi nəkur Isrel, ");
INSERT INTO tnk_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","mɨni mə, “Iakɨno noien ərəha i, muvei pehe iərmama sə in ratukwatukw a ia rəɡɨmiaha mə tihousi əpune in.” Mɨreɡi irəha həni mə, “Rəfo ikuvehe masək teɡɨn kɨmaha? Səim atukw a nə noien.” ");
INSERT INTO tnk_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nənə Jutas rərarki irapw silin me kɨno ia silva fwe ia nəkwai nimwə səvəi Kumwesən, nənə mier mevən, mɨrukwi utə atukw a in ia kwənəkwus. ");
INSERT INTO tnk_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mətə pris asori me həuvehi silin me nəha kɨno ia silva, mhəni mə, “Rɨpkatukwatukw mhə ia Loa səkɨtaha mə kɨtaha tsousəsɨmwɨn mane i irəha mane səvəi nimwəfwaki tɨ nəri nə mə mane i kuvei pen mə tukuvehi nəmri iərmama i mə tukousi əpune.” ");
INSERT INTO tnk_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ro iamɨnhi irə irəha hərai sun mhəuvehi mane nəha, mhəuvehi nəmri tɨprənə riti. Fwe kupwən kani tɨprənə nəha mə Tɨprənə sə kamo tekinari me irə. Irəha həuvehi nəmri tɨprənə nəha mə tukɨnɨmwi nərmama pwɨspwɨs me ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ro pen ipwet mɨne kamseɡi pen ihi nəɡhi tɨprənə nəha mə Tɨprənə sə netə rɨnaiu ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ia nəpɨn nəha nəɡkiariien səvəi Profet Jeremaea ruvəuvehe muvəukuə. In rɨməni mə, “Irəha həuvehi silin me kɨno ia silva irəha pam toti. In nə mane sə nəkur Isrel me nepwɨn həni mə tuhəuvei pen tɨ nuvehiien nəmri iərmama nəha. ");
INSERT INTO tnk_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Irəha həuvei pen mane nəha mhəuvehi nəmri tɨprənə sə kamo tekinari me irə rəmwhen ia Iərɨmənu rɨni pehe tukw iou i mə tako.” ");
INSERT INTO tnk_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Nəpɨn Iesu ramərer ia nəmri Paelat, Paelat rəres pen in mə, “Ik kiɡ səvəi nəkur Isrel?” Mɨreɡi Iesu rɨni mə, “Ik ikani.” ");
INSERT INTO tnk_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ia nəpɨn nəha pris asori me mɨne nəmə asori me səvəi nəkur Isrel həskəmter, mamhəni ərəha Iesu, mətə Iesu rəpwəh nɨniien nəɡkiariien riti tɨ nirəha i. ");
INSERT INTO tnk_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ro pen Paelat rɨni pen tukwe in mə, “Rəfo ikaməpnapen? Ipkreɡi mhə nəɡkiariien me rɨpɨk nəha kamhəni ərəha ik irə?” ");
INSERT INTO tnk_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mətə Iesu rɨpkɨni mhə nəɡkiariien riti tukwe in, mɨpkərpwɨn mhə nəɡkiariien riti sə irəha kamhəni. Nənə Paelat rətoni mərkəri asori nari irə. ");
INSERT INTO tnk_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ia nuk me pam nəpɨn kamo nəveɡɨnien asori nəha Pasova irə, iəmə Rom sə ramərɨmənu ia kwopun nəha rukurən nuvehi rakaien iərmama riti ia kalapus sə nəkur Isrel həməres i, nənə məseni in rier mamevən. ");
INSERT INTO tnk_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ia nəpɨn nəha iərmama riti fwe ia nəkwai kalapus nərmama pam həukurən in nəɡhɨn nə Parapas. ");
INSERT INTO tnk_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ro iamɨnhi irə nəpɨn nərmama housəsɨmwɨn irəha me, Paelat rɨni pen tɨ nirəha i mə, “Kɨmiaha hiokeikei mə takəseni sin rier ia kalapus mamevən, Parapas uə Iesu sə kani mə Kristo?” ");
INSERT INTO tnk_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Paelat rəres pen irəha iamɨnhi irə tɨ nəri nə mə in rukurən mə nəmə asori me səvəi nəkur Isrel həməuvei pen Iesu ia rəɡɨn tɨ nəmwəkiien səvənraha. ");
INSERT INTO tnk_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nari riti mwi, nəpɨn in raməkure ia kwopun sə raməkiri nəɡkiariien ikɨn, pran səvənhi rərhi pen nəɡkiariien riti revən tukwe mɨni mə, “Tikəpwəh noien nari riti ia iəmə atukwatukw nəha. Ia nəpɨn rɨran pehe ipwet iakəməkrəha irə. Nənə təkwtəkwuni iakreɡi rərəha tukwe.” ");
INSERT INTO tnk_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mətə pris asori me mɨne nəmə asori me səvəi nəkur Isrel kamhəkeikei m nərmama mə tuhəres Paelat i mə trəseni Parapas rier ia kalapus mamevən, mətə trousi əpune Iesu. ");
INSERT INTO tnk_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nənə Paelat rəres pen mwi irəha i mə, “Iəmənmi i sə pəku kɨmiaha hiokeikei mə takəseni rier ia kalapus mamevən?” Mɨreɡi irəha həni mə, “Parapas.” ");
INSERT INTO tnk_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Mɨreɡi Paelat rɨni pen tɨ nirəha i mə, “Ro iamɨnhi irə takəfo ia Iesu sə kani mə Kristo?” Mɨreɡi irəha pam həni mə, “Pwəh hərui tərini pen in ia nei kamarkuaui.” ");
INSERT INTO tnk_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Mɨreɡi Paelat rɨni mə, “Tɨ nəfe? Nəfe nəha nərəhaien in rɨno?” Mətə irəha həni asori mwi mə, “Pwəh hərui tərini pen in ia nei kamarkuaui.” ");
INSERT INTO tnk_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nəpɨn Paelat rətoni mə ko rɨpko mhə rerɨnraha rəpwiuən, mətə hənamo nurɨɡrɨɡien asori, in ruvehi nui, maikuas ia rəɡɨn mi ia nəmrɨnraha pam, mɨni mə, “Iou iakiwən ia nemhəien səvəi iəmə i. Nɨten riwən ia nirak. Ramarə a ia kɨmiaha.” ");
INSERT INTO tnk_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Mɨreɡi nərmama me pam həni mə, “Pwəh nɨten rəmak pehe a ia kɨmiaha mɨne nəkwərhakwərha me səkɨmaha.” ");
INSERT INTO tnk_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nənə Paelat ro nəkwanraha, məseni Parapas rier ia kalapus mamevən, mətə rɨni nəkwan mə tukərisi Iesu. Nəpɨn naruaɡən me səvənhi hərisi pam in, Paelat ruvei pen in ia rəɡɨnraha mə tuhərui tərini pen ia nei kamarkuaui. ");
INSERT INTO tnk_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Naruaɡən me səvəi Paelat həiri Iesu mhəuvnimwə ia nimwə asori səvəi Paelat nəɡhɨn nə Praetoriam. Irəha həkwein irəha me nepwɨn ia kusen səvənraha həuvehe mhousəsɨmwɨn irəha me ipaka tɨ Iesu, ");
INSERT INTO tnk_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","mhəuvehi raka karkahu səvənhi, mharkahu pen karkahu əruerəv min rəmwhen ia karkahu səvəi kiɡ. ");
INSERT INTO tnk_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Həuvehi rəhi, mhəuvnhi kəfəfau səvəi kiɡ irə, mhəfəfau pen ia kənkapwə, mhəuvei pen mwi rɨɡi nei riti ia rəɡɨn mwatuk rəmwhen ia nəri sə kiɡ rauvehi rahatən pen nasoriien səvəi kiɡ. Hənɨmwi nukurhunraha ia nənimen, mamharɨs əkenhɨn irə, mamhəni mə, “Ik kiɡ səvəi nəkur Isrel kɨmaha iahəsiai ik!” ");
INSERT INTO tnk_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Irəha hərɡəvəsi in, mhəuvehi raka rɨɡi nei nəha ia rəɡɨn, mhousi kənkapwə irə. ");
INSERT INTO tnk_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nəpɨn hənarɨs əkenhɨn raka irə, həuvehi raka karkahu əruerəv nə mharkahu pen tɨnari ihi səvənhi, mhəiri in mhəuvən mə tuhərui tərini pen ia nei kamarkuaui. ");
INSERT INTO tnk_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nəpɨn naruaɡən me nəha hənaməier, hətoni iəmə Saerin riti nəɡhɨn nə Saemon. Irəha həkeikei min mə trəvrani nei kamarkuaui səvəi Iesu. ");
INSERT INTO tnk_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Irəha həuvən ia kwopun riti nəɡhɨn nə Kolkota (nɨpwrai nahaɡ nəha kwopun səvəi kerhə ia iərmama). Ia kwopun nəha irəha ");
INSERT INTO tnk_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","həuvei pen waen m Iesu mə trənɨmwi. Kəvti pen nɨmwai nari riti rəfiə trasitu muəsi nəmisəien. Mətə nəpɨn Iesu rəpwasi əɡhan, rəpwəh nokeikeiien mə trənɨmwi. ");
INSERT INTO tnk_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nəpɨn irəha hərui tərini pen raka in ia nei kamarkuaui, həuai kɨrkɨri tɨnari me səvənhi, mhəuini nari riti sə trahatən pen mə sin truvehi nəfe tɨnari səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nənə həkure ia kwopun nəha, mamhətui tukwe. ");
INSERT INTO tnk_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ia kənkapwə irənhə irə irəha hərui pen nəkukuə riti kɨmərai mə Iesu tremhə tɨ nəfe. Rɨni mə: Iesu I Kig Səvəi Nəkur Isrel ");
INSERT INTO tnk_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ia nəpɨn nəha həuvehi rakres mi kəru, mhərui tərini pen mwi irau ia nei kamarkuaui, riti ia nɨkare Iesu mwatuk, riti ia nɨkaren mour. ");
INSERT INTO tnk_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nənə nərmama səməme kamhəukurau ia suatuk kamhounouini kənkapwənraha me, mamhəni ərəha Iesu, ");
INSERT INTO tnk_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","mamhəni mə, “Ik nə iəmə ikɨməni mə tikouraha nimwə səvəi Kumwesən marə muvrhəkɨn mwi ia nəpɨn kahar. Itə, uvehimɨru ik! Trɨni mɨnuə ik Tɨni Kumwesən pərhien, araka ia nei kamarkuaui meiwaiu pehe.” ");
INSERT INTO tnk_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ia noien a mwi nəha pris asori me mɨne nahatən me səvəi Loa mɨne nəmə asori me səvəi nəkur Isrel harɨs əkenhɨn irə, mamhəni mə, ");
INSERT INTO tnk_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“In rɨməuvehimɨru raka nərmama həpɨk, mətə ko rɨpkuvehimɨru atukw mhə in. Mə in kiɡ səvəi nəkur Isrel pərhien, ramasan mə raraka ia nei kamarkuaui meiwaiu pehe, pwəh kɨtaha sətoni mhəni nɨpərhienien irə. ");
INSERT INTO tnk_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Iəmə i rahatətə ia Kumwesən mɨni mə in Tɨni Kumwesən. Pwəh sətoni ro mə Kumwesən rerɨn raɡien tukwe truvehimɨru in təkwtəkwuni.” ");
INSERT INTO tnk_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Iərmama mi nəha sə krauakres kɨnərui tərini pen irau ia nei kamarkuaui irəhar Iesu, irau mwi krauni ərəha in rəmwhen nepwɨn həməni. ");
INSERT INTO tnk_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ia kurkwai nəpɨn ia ran nəpitəvien ruvehe mousəman kwopun me pam ia tənə nəha meste aoa kahar rukurau. ");
INSERT INTO tnk_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nənə rarɨpwi tri klok ia nəruarəv Iesu rəkwein əpwəmwɨs, mɨni mɨnuə, “Eloi, Eloi, lama sapaktani?” Nɨpwrai nəɡkiariien nəha in i mə “Kumwesən səiou, Kumwesən səiou, rəfo ikap raka ia nirak iamɨnhi?” ");
INSERT INTO tnk_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nərmama me nepwɨn səməme kamhərer mamhəspau ia Iesu həreɡi nəɡkiariien nəha, mhəni mə, “Iəmə i raməkwein Profet Elaeja.” ");
INSERT INTO tnk_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nənə təkwtəkwuni a riti ia nirəha raiu muvehi nɨpəri koton, meitesi ia waen sə rəfiə, mɨpiri pen ia nusvenhi rəɡi nei riti, muvehi pen mə Iesu trənɨmwi. ");
INSERT INTO tnk_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Mətə in me nepwɨn həni mə, “Pəpɨm ro pwəh sətoni mə Profet Elaeja truvehe muvehimɨru iəmə i uə rekəm.” ");
INSERT INTO tnk_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nənə Iesu rəkwein əpwəmwɨs mwi, məseni pen nɨmɨruien səvənhi, memhə. ");
INSERT INTO tnk_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Təkwtəkwuni a mwi tɨnari sə rəɡher tukuahaɡ kwopun ikinan anan fwe ia nəkwai nimwə səvəi Kumwesən reitehi nɨpərɨn kəru fwe irənhə meste nari fwe inhərɨpw. Nənə tɨprənə rɨkiu, meitehi kəruəterei me. ");
INSERT INTO tnk_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nɨpəɡi kəruəterei me nepwɨn sə kɨnərkwafə nɨpwrai nərmama ikɨn həuvehe mhəkwaɡ, nənə Kumwesən ro nərmama me səvənhi həpɨk hətui mwi ia nemhəien səvənraha. ");
INSERT INTO tnk_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Kurirə irə nəpɨn Iesu rətui mwi ia nemhəien səvənhi irəha həier irapw ia nɨpəɡi kəruəterei me səvənraha, mhəuvən ia taon ikinan nə Jerusalem, nərmama həpɨk hətoni irəha. ");
INSERT INTO tnk_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Iaruaɡən riti nəha in rasori ia naruaɡən me irəha pam hantret. In mɨne naruaɡən me nepwɨn səvənhi kamhətui tɨ Iesu. Nəpɨn irəha hətoni nɨmwnɨmwien nəha mɨne narimnari me nəha sə həməier pehe, həhekɨr asori, mhəni mə, “Nɨpərhienien iəmə i in Tɨni Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nənə nɨpran me həpɨk ia kwopun nəha kamhərer isipwɨn kwopti tɨ Iesu mamhəspau irə. Nɨpran me nəha həməier ia tənə Kalili, mamhəkurirə ia Iesu, mamhasitu irə. ");
INSERT INTO tnk_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Meri Maktala, mɨne Meri mama səvəi Jemes mɨne Josef, mɨne mama səvəi tɨni Sepeti mi kamharərer irəha mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Iəmə Aramatia riti nəha ikɨn nəɡhɨn nə Josef. Nautə səvənhi rasori. In mwi iərmama riti səvəi Iesu. Ia nəruarəv ");
INSERT INTO tnk_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","revən tɨ Paelat, məres pen mə ko Paelat rəseni in ruvehi nɨpwrai Iesu. Ro pen Paelat rɨni nəkwan mə tukuvehi pen min. ");
INSERT INTO tnk_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josef revən muvehi nɨpwrai Iesu, muveɡi ia tɨnari əmher riti kɨno ia linen, ");
INSERT INTO tnk_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","nənə məmri pen ia nɨpəɡi kəruəterei riti səvənhi sə in rɨnərai ərori raka. Nəpɨn rɨnəmri raka, rəsəkwuəsəkwu kəruəterei asori riti mərəpinhə pen kwəruə irə, nənə mamevən. ");
INSERT INTO tnk_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meri Maktala, mɨne Meri mama səvəi Jemes mɨne Josef krauəkure fwe ikɨn, rouəti pen nɨpəɡi kəruəterei nəha kɨnərkwafə nɨpwrai Iesu ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kɨni rakwakwi irə, nəpɨn kaməpnəpenə irə tɨ Sapat, pris asori me mɨne Farisi me həuvən mhousəsɨmwɨn irəha me ia nəmri Paelat, ");
INSERT INTO tnk_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","həni pen tukwe in mə, “Iəmə asori. Rerɨmaha ramrhi nəɡkiariien riti səvəi iəmə nəha rameikuə. Nəpɨn ramɨru ihi, rɨməni mə nəpɨn kahar trukurau nənə in trətui mwi ia nemhəien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ro iamɨnhi irə tikərhi pen nərmama me nepwɨn səim pwəh həuvən mhəsisəɡ əknekɨn ia nɨpəɡ sə kɨnərkwafə nɨpwran ikɨn meste nəpɨn kahar haruvehe mharukurau. Rərəha nərmama me səvənhi həuvən, mhakres nɨpwran, mhəni pen tɨ nərmama mə in rɨnətui mwi ia nemhəien səvənhi. Tuko ro iamɨnhi irə neikuəien nəha səvənraha trərəha məpi raka sə fwe kupwən.” ");
INSERT INTO tnk_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Mɨreɡi Paelat rɨni pen tɨ nirəha i mə, “Iakəseni naruaɡən me nepwɨn səiou. Tiho mhəiri irəha mhəuvən mhəsisəɡ əknekɨn ia nɨpəɡi kəruəterei nəha.” ");
INSERT INTO tnk_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ro pen irəha həuvən mhəmri pen nari riti ia kəruəterei sə ramərer tukuahaɡ ia nɨpəɡ nəha mə iərmama riti rɨkiu irə irəha tuhətoni mhəukurən. Nənə naruaɡən me nepwɨn kamhərer tukuahaɡ tukwe. ");
INSERT INTO tnk_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nəpɨn Sapat ruvəukurau, ipaka rɨnamran ia Sante, Meri Maktala mɨne Meri mama səvəi Jemes krouevən mə trouətə nɨpəɡi kəruəterei kɨnəmri pen nɨpwrai Iesu irə. ");
INSERT INTO tnk_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nənə təkwtəkwuni a irə, nɨmwnɨmwien asori rɨkiu, tɨ nəri nə mə aɡelo riti səvəi Iərɨmənu rier ia neiai meiwaiu pehe, məsəkwu raka kəruəterei nəha kɨnəsisəɡ pen ia nɨpəɡ, nənə məkure utə irə. ");
INSERT INTO tnk_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nɨpwran ramser rəmwhen ia nouapɨrien. Tɨnari səvənhi rəpsan anan. ");
INSERT INTO tnk_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nəpɨn naruaɡən me nəha səməme kamhərer tukuahaɡ tɨ nɨpəɡ hətoni aɡelo nəha, həhekɨr mhətəmnɨmwɨn, həuvehe mhəmwhen ia nərmama həuvamhə. ");
INSERT INTO tnk_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mətə aɡelo nəha rɨni pen tɨ prən mi nəha mə, “Rouəpwəh nehekɨrien. Iakukurən mə irouətui Iesu sə kɨnərui tərini pen ia nei kamarkuaui. ");
INSERT INTO tnk_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","In riwən i. In rɨnətui mwi ia nemhəien səvənhi rəmwhen mə in rɨməni. Rouvehe, rouətə kwopun nɨpwran rɨnamapri ikɨn, ");
INSERT INTO tnk_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","nənə rouevən akwauakw rouni pen tɨ nərmama me səvənhi mə in rɨnətui mwi ia nemhəien səvənhi, nənə təkwtəkwuni in rakupwən ia kɨmiaha mamevən ia tənə Kalili. Kɨmiaha tihətoni in fwe ikɨn. Iroureɡi iakuvəni raka narimnari me i tukumirau i.” ");
INSERT INTO tnk_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nənə irau krouəpwəh akwauakw nɨpəɡ, rouhekɨr, mətə rerɨnrau raɡien pɨk mwi. Krouaiu, rouevən mə trouni nəri nəha tɨ nərmama me səvəi Iesu. ");
INSERT INTO tnk_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nənə təkwtəkwuni a Iesu rier irapw tɨ nirau, mɨni mə, “Ramasan tukumirau!” Nənə irau krouvehe tukwe, rounɨmwi nukurhunrau ia nənimen, rouəkwtəmhiri nɨsun mi, rousiai in. ");
INSERT INTO tnk_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nənə Iesu rɨni pen tɨ nirau i mə, “Rouəpwəh nehekɨrien, rouevən, rouni pen tɨ piak me mə irəha tuhəuvən fwe tənə Kalili. Ia kwopun nəha irəha tuhətə iou.” ");
INSERT INTO tnk_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nəpɨn irau krourərɨɡ, təkwtəkwuni a mwi, naruaɡən me nepwɨn səməme hənamərer tukuahaɡ nɨpəɡ həuvən fwe taon, nənə mhəni pen narimnari me nəha tɨ pris asori me. ");
INSERT INTO tnk_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nənə pris asori me hoeite nəmə asori me səvəi nəkur Isrel mamhərai sun irəha mɨnraha. Nənə nəpɨn həuvərai sun raka, həuvei pen mane asori m naruaɡən me nəha, ");
INSERT INTO tnk_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","mhəni mə, “Kɨmiaha tihəni irapw tɨ nərmama me mə nəpɨn kɨmiaha hiamapri ia nəpɨn nərmama me səvəi Iesu həuvehe mhakres nɨpwran. ");
INSERT INTO tnk_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nənə trɨni mɨnuə Paelat rɨreɡi nəɡkiariien nəha, kɨmaha tahəɡkiari min mə in trəpwəh nourahaien kɨmiaha.” ");
INSERT INTO tnk_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ro iamɨnhi irə naruaɡən me həuvehi mane, mhəuvən, mho nəfe pris asori me həməni pen tɨ nirəha i. Nənə nəɡkiariien nəha ruvirɨs ia tənə Isrel. Kamɨni ihi ipwet mɨne. ");
INSERT INTO tnk_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ia nəpɨn nəha nərmama me səvəi Iesu irəha pam eleven həuvən fwe tənə Kalili ia təkuər riti sə Iesu rɨməni pen tɨ nirəha i kupwən. ");
INSERT INTO tnk_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nəpɨn irəha hətoni in, hənɨmwi nukurhunraha ia nənimen, mhəsiai in. Mətə nepwɨn həreirei amasan ia rerɨnraha mə Iesu pərhien i. ");
INSERT INTO tnk_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nənə Iesu ruvehe, mɨni pen tɨ nirəha i mə, “Kumwesən ruvei pehe nasoriien miou iakamərɨmənu ia narimnari me pam ia neiai mɨne tɨprənə. ");
INSERT INTO tnk_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ro pen kɨmiaha tihaməkeikei mhəuvən mhəvi nərmama ia tənəmtənə me pam pwəh irəha həuvehe mho nərmama me səiou ia nirəha. Kɨmiaha tihaməkeikei mho paptaes ia nirəha ia nəɡhi Tata mɨne Tɨni mɨne Nənɨmwɨn Ikinan, ");
INSERT INTO tnk_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","mamhahatən irəha mə irəha tuhaməkeikei mho nəɡkiariien me pam sə iakɨnahatən kɨmiaha irə. Nənə həreɡi ro nəri i. Iou takamarə rerɨn tukumiaha meste nəpɨn sampam.” ");
INSERT INTO tnk_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nukune nəɡkiariien amasan sə raməvisau Iesu Kristo, Tɨni Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kɨmərai pen nəɡkiariien riti ia nəkukuə səvəi Profet Aesea fwe kupwən. Nəɡkiariien nəha rani iamɨnhi irə mə, “Ətə ro, takərhi pen iərmama sə trəɡkiari tukwini səiou, in trukupwən ia niram mevən, məpərhi səim suatuk.” ");
INSERT INTO tnk_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Reri iərmama riti raməkwein əpwəmwɨs ia kwopun akwesakwes ikɨn mamɨni mə, ‘Kɨmiaha tihaməkeikei mhəpərhi suatuk səvəi Iərɨmənu səkɨtaha, mhəmri atukwatukw suatuk ouihi me səvənhi.’” ");
INSERT INTO tnk_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ro iamɨnhi irə Jon rier irapw ia kwopun akwesakwes ikɨn, maməvisau irapw tɨ nərmama mə, “Kɨmiaha tihaməkeikei mhərərɨɡ ia noien ərəha me səkɨmiaha, mho paptaes, nənə Kumwesən trəpwəh nərpwɨnien noien ərəha me səkɨmiaha.” ");
INSERT INTO tnk_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nərmama pam ia tənə Jutia mɨne Jerusalem həuvən tɨ Jon, mamhəni irapw noien ərəha me səvənraha, nənə in ramo paptaes ia nirəha ia nui arɨs Jotan. ");
INSERT INTO tnk_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon ramarkahu ia tɨnari kɨno ia nɨmwheri kamel, mamətoti ia teki nərimɨru, maməni kinhə mɨne kwənipwət ia sukapak. ");
INSERT INTO tnk_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ramɨni irapw mə, “Kurirə ia nirak, iərmama riti fwe rauvehe. Nɨskaiien səvənhi rasori məpi raka iou. Iapkəmwhen mhə mə takərpəsuk mɨfi raka nəkwus ia səvənhi put. ");
INSERT INTO tnk_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Iou iakamo paptaes ia kɨmiaha ia nui, mətə in truvehe mo paptaes ia kɨmiaha ia Nənɨmwɨn Ikinan.” ");
INSERT INTO tnk_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ia nəpɨn nəha Iesu ruku pen fwe ia taon nəha Nasaret ia tənə Kalili, muvehe, nənə Jon ro paptaes irə ia nui arɨs Jotan. ");
INSERT INTO tnk_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nəpɨn atukwatukw Iesu rutə pehe ia nui, rətoni kəpuapen rəkwaɡ, Nənɨmwɨn Ikinan rosi mak inhərɨpw reiwaiu pehe məkure irə. ");
INSERT INTO tnk_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nənə reri Kumwesən ruku pen ia neiai mɨni mə, “Ik nərɨk keikei. Rerɨk raɡien tukw ik.” ");
INSERT INTO tnk_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jon rɨno raka paptaes ia Iesu. Nənə Nənɨmwɨn Ikinan rərhi pen Iesu revən ia kwopun akwesakwes ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Rarə ikɨn meste nəpɨn foti. Ia nəpɨn nəha Setan raməmwur mə tro Iesu rɨmwei ia nərəhaien. Iesu ramarə irəha nəri əprmɨn me. Naɡelo me hamo tukwini nari min. ");
INSERT INTO tnk_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kəkwtəmhiri Jon, kuvehi puvnimwə ia kalapus. Kurirə ikɨn Iesu ruvehe ia tənə Kalili, maməvisau irapw nəɡkiariien amasan səvəi Kumwesən, mamɨni mə, ");
INSERT INTO tnk_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Təkwtəkwuni rɨno nəpɨn atukwatukw. Nɨtətə sə Kumwesən ramərɨmənu irə ruvəuvehe ipaka. Tihərərɨɡ ia noien ərəha me səkɨmiaha, mhəni nɨpərhienien ia nəɡkiariien amasan səiou.” ");
INSERT INTO tnk_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nəpɨn Iesu ramavən ia nɨkare nui asori Kalili, rətoni Saemon irau piəvni nəɡhɨn nə Antru krauerukw net ia nui. Irau krauerukw net ia nui tɨ nəri nə mə irau iərmama mi kravi nəmu. ");
INSERT INTO tnk_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Iesu rɨni pen tɨ nirau i mə, “Rouvehe roukurirə iou, pwəh tako kɨmirau tirouvehe iərmama mi sə kravi nərmama.” ");
INSERT INTO tnk_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nənə təkwtəkwuni a krouəpwəh net səvənrau roukurirə in. ");
INSERT INTO tnk_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kurirə ikɨn Iesu ravən ouihi a mwi, mətoni tɨni Sepeti Jemes mɨne piəvni nəɡhɨn nə Jon. Krauəkure ia nəkwai nɨtətə ouihi riti rautiri net me. ");
INSERT INTO tnk_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Iesu rətoni irau, məkwein irau. Nənə krouəpwəh səvənrau tata Sepeti raməkure ia nəkwai nɨtətə ouihi irəha nərmama səməme ramərəku irəha tɨ noien wok səvənhi, rouevən roukurirə Iesu. ");
INSERT INTO tnk_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Iesu mɨne nərmama me səvənhi həuvən ia taon riti nəɡhɨn nə Kapaneam. Ia Sapat Iesu ruvnimwə ia nəkwai nimwəfwaki səvəi nəkur Isrel mamahatən nərmama me. ");
INSERT INTO tnk_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Irəha hərkəri asori nari ia nahatənien səvənhi, tɨ nəri nə mə in ramahatən irəha rəmwhen iərmama sə rauvehi nasoriien ruku pen tɨ Kumwesən. In ropə ia nahatən me səvəi Loa. ");
INSERT INTO tnk_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nənə təkwtəkwuni a iərmama riti sə nənɨmwɨn ərəha ramarə irə ruvnimwə pehe ia nəkwai nimwəfwaki səvənraha, ");
INSERT INTO tnk_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","məkwein əpwəmwɨs, mɨni mə, “Iesu, ik iəmə Nasaret! Ikuvehe mə tiko nəfe ia kɨmaha? Ikuvehe mə tikouraha kɨmaha uə? Iakukurən ik. Ik iəmə ikinan səvəi Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Mətə Iesu rɨnise nənɨmwɨn ərəha, mɨni mə, “Əpwəh nəɡkiariien, mier ia iərmama i.” ");
INSERT INTO tnk_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nənə nənɨmwɨn ərəha rəkwein əpwəmwɨs, mɨkiukiu ia nɨpwran, mier. ");
INSERT INTO tnk_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kurirə irə nərmama me nənimenraha rier. Haməres irəha me i mə, “Nəfe nəha? Nahatənien vi riti uə? Iəmə i rauvehi nasoriien, mamɨni nəkwan tɨ nənɨmwɨn ərəha me, nənə irəha ho.” ");
INSERT INTO tnk_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Təkwtəkwuni a mwi nəɡkiariien kamɨni ia Iesu rier mevən ia kwopun me pam ia tənə Kalili. ");
INSERT INTO tnk_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Iesu rier irapw ia nimwəfwaki səvəi nəkur Isrel irəha Jemes mɨne Jon mɨne Saemon mɨne Antru. Irəha həuvən atukwatukw mhəuvnimwə ia nəkwai nimwə səvəi Saemon mɨne Antru. ");
INSERT INTO tnk_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nəpɨn hapirapw fwe ikɨn, nərmama həvisau pen m Iesu mə kaka pran səvəi Saemon ramapri, maməkwiei fifa. ");
INSERT INTO tnk_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ro iamɨnhi irə Iesu revən mətoni, muvehi rəɡi prən nəha, mɨvi utə. Təkwtəkwuni a mwi nemhəien raraka ia prən nəha. Rəsanɨn mevən mɨsui raka nəveɡɨnien muvei pen mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Raməruarəv meri ruvəivə. Nənə nərmama me həuvehi pam nərmama səməme nemhəien rarə ia nirəha mɨne səməme nəremhə me kamharə ia nirəha həuvehi irəha mhəuvehe tɨ Iesu. ");
INSERT INTO tnk_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nərmama pam ia rukwənu səvəi Saemon housəsɨmwɨn pen irəha ia kwəruə ia nimwə səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Nənə Iesu ro nərmama həpɨk nemhəien səpəmsəpə rarə ia nirəha həuvehe mhəsanɨn. In rəkoui irapw nəremhə me həpɨk ia nərmama, mətə rɨnise nəremhə me nəha mə tuhəpwəh nəɡkiariien tɨ nəri nə mə irəha həukurən mə in sin. ");
INSERT INTO tnk_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ia nəpnəpɨn anan, rapitəv ihi, Iesu rətui mevən fwe ia kwopun riti sə nərmama həiwən ikɨn, maməfwaki fwe ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Nənə Saemon mɨne in me nepwɨn kamhətui in. ");
INSERT INTO tnk_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nəpɨn hətoni Iesu, həni pen tukwe in mə, “Iesu, nərmama pam fwe kamhətui ik.” ");
INSERT INTO tnk_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Pwəh səuvən mwi ia rukwənu me nəha ipaka tukutaha. Takəvisau mwi mɨnraha, tɨ nəri nə mə səiou atukwatukw nəha wok iakɨməuvehe tukwe.” ");
INSERT INTO tnk_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nənə Iesu revən mukurau ia tənə Kalili, maməvisau ia nəkwai nimwəfwaki me səvəi nəkur Isrel, maməkoui irapw nəremhə me ia nərmama. ");
INSERT INTO tnk_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Iərmama riti nemhəien skai riti raməmak ia tekɨn. In ruvehe tɨ Iesu, mɨnɨmwi nukurhun mi ia nənimen, mɨni pen tukwe in mə, “Mə rerɨm raɡien ko iko iakəmher?” ");
INSERT INTO tnk_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nənə Iesu rerɨn rərkwəpɨr tukwe. In rosə pen rəɡɨn, mɨrapi in, mɨni mə, “Rerɨk raɡien. Tikuvehe məmher.” ");
INSERT INTO tnk_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nənə təkwtəkwuni a nemhəien raraka irə. Iesu ro nɨpwran ruvehe məmher mwi, ");
INSERT INTO tnk_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","mərhi pen i, mɨnise pen tukwe in mə, “Tikətui amasan tukwe, məpwəh nɨniien nəfe iakɨno mik tɨ iərmama riti, mətə tikevən atukwatukw tɨ pris pwəh rətoni nɨpwram mə rɨnəmher. Tikuvei pen nəfe m Kumwesən sə Moses rɨməni. Nərmama tuhətoni həukurən mə nemhəien i ruvəiwən ia nɨpwram.” ");
INSERT INTO tnk_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mətə nəpɨn iərmama nəha rəpwəh Iesu mier, rɨnani irapw nəfe Iesu rɨno min tɨ nərmama me. Nəɡkiariien səvənhi ruvirɨs ro pen rɨskai tɨ Iesu mə travən mevən mwi ia rukwənu riti mwi. Mətə ramavən a ia kwopun me nərmama həiwən ikɨn. Nərmama pam ia kwopun me kamhəuvehe tukwe. ");
INSERT INTO tnk_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nəpɨn me nepwɨn rukurau, nənə Iesu rɨrərɨɡ pehe mwi ia Kapaneam. Nərmama me həreɡi kaməvisau mə in fwe ia nəkwai nimwə. ");
INSERT INTO tnk_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ro iamɨnhi irə irəha həuvən mhousəsɨmwɨn pen irəha me tukwe. Nəkwai nimwə rukuər ia nərmama. Kwopun səvəi nəkureien riwən fwe imwə mɨne ia kwəruə. Iesu raməvisau irapw nəɡkiariien amasan mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ia nəpɨn nəha nərmama kefə həuvehi iərmama riti mhəuvehe tɨ Iesu. Iərmama nəha nɨsun mi krouemhə. Ko rɨpkavən mhə. ");
INSERT INTO tnk_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Həuvehi pehe, mətə ko həpkəuvən mhə ipaka tɨ Iesu tɨ nəri nə mə nərmama həpɨk anan. Ro iamɨnhi irə irəha həputə ia təkure nimwə, mho ruei nimwə riti ratukwatukw ia kwopun nəha Iesu raməkure ikɨn. Ho pam ruə, həuvehi irapw nɨməhan sə iərmama nɨsun mi krouemhə ramapri irə reiwaiu. ");
INSERT INTO tnk_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nəpɨn Iesu rətoni nahatətəien səvənraha, rɨni pen tɨ iərmama sə nɨsun mi krouemhə mə, “Nərɨk, iakɨnenouenou raka noien ərəha me səim.” ");
INSERT INTO tnk_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nahatən me nepwɨn səvəi Loa kamhəkure fwe ikɨn, rerɨnraha ramrhi mə, ");
INSERT INTO tnk_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Rəfo iəmə nəha raməɡkiari iamɨnha irə mɨne? Nəɡkiariien nəha rərəha. Kumwesən əpa rukurən nenouenouien noien ərəha me. Sin mwi rukurən noien?” ");
INSERT INTO tnk_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Təkwtəkwuni a Iesu rukurən nətərɨɡien səvənraha, mɨni pen tɨ nirəha i mə, “Rəfo rerɨmiaha ramrhi iamɨnhi? ");
INSERT INTO tnk_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nəɡkiariien mi sə pəku nəha rɨməru tukw iou tɨ nɨniien tɨ iərmama i nɨsun mi krouemhə: nəɡkiariien i mə, ‘Iakɨnenouenou raka noien ərəha me səim,’ uə nəɡkiariien i mə, ‘Ərer, muvehi nɨməhan səim, mavən mamevən’? ");
INSERT INTO tnk_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Mətə iakokeikei mə kɨmiaha tihəukurən mə iou, Iəməti Iərmama, iakauvehi nasoriien ia tɨprənə i. Iakukurən nenouenouien noien ərəha me.” ");
INSERT INTO tnk_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Nənə Iesu rɨni pen tɨ iərmama sə nɨsun mi krouemhə mə, “Iakani pehe tukw ik i mə ərer, muvehi nɨməhan səim, mavən mamevən fwe imwam.” ");
INSERT INTO tnk_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Təkwtəkwuni a rərer, muvehi nɨməhan səvənhi ia nəmri nərmama, mavən mamevən. Nənə irəha nənimenraha rier. Həɡnəɡɨni Kumwesən mə, “Səpkətə raka mhə nari riti iamɨnhi irə ia nəpɨn riti!” ");
INSERT INTO tnk_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesu revən mwi mamavən ia nɨkare nui asori Kalili. Nərmama həpɨk həuvehe tukwe, nənə in ramahatən irəha. ");
INSERT INTO tnk_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ia nəpɨn nəha ramavən mətoni Livae tɨni Alfeas raməkure ia nimwə kamərəku pen takis ikɨn. Iesu rɨni pen tukwe in mə, “Kurirə iou.” Nənə Levi rɨskəmter mukurirə in. ");
INSERT INTO tnk_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kurirə irə Iesu revən maməni nari ia nəkwai nimwə səvəi Livae. Nərmama kamərəku pen takis mɨnraha mɨne nərmama ərəha me nepwɨn mwi həpɨk kamhani pəri nari irəha min mɨne nərmama me səvənhi. (Ro iamɨnhi irə mɨne tɨ nəri nə mə nərmama kamərəku pen takis mɨnraha mɨne nərmama ərəha me nepwɨn mwi həpɨk kamhəkurirə ia Iesu.) ");
INSERT INTO tnk_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nənə nahatən me səvəi Loa, irəha mwi Farisi me, həuvehe mhətoni Iesu raməni nari irəha nərmama kamərəku pen takis mɨnraha mɨne nərmama ərəha me nepwɨn mwi. Irəha həres nərmama me səvənhi mə, “Rəfo in raməni nari irəha nərmama kamərəku pen takis mɨnraha mɨne nərmama ərəha me nepwɨn mwi?” ");
INSERT INTO tnk_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nəpɨn Iesu rɨreɡi nəɡkiariien səvənraha, rɨni pen tɨ nirəha i mə, “Nərmama həsanɨn tuhətui tokta tɨ nəfe? Mətə nərmama kamhemhə kamhətui tokta. Iou iapkuvehe mhə mə takəkwein nərmama atukwatukw me, mətə iakuvehe mə takəkwein nərmama ərəha me.” ");
INSERT INTO tnk_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nəpɨn riti nərmama me səvəi Jon Paptaes irəha Farisi me kamhəpwəh naniien nari tɨ nəfwakiien. Nərmama nepwɨn həuvehe mhəres Iesu i mə, “Rəfo nərmama me səvəi Jon mɨne Farisi me kamhəpwəh naniien nari tɨ nəfwakiien, mətə səim nərmama me həpko mhə?” ");
INSERT INTO tnk_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Nərmama ia nəveɡɨnien i kamo tɨ narə viien səvəi iərman mɨne pran tuhaməkeikei mhani nari, mamhaɡien, tɨ nəri nə mə iərman sə rɨpkarə vi a irau pran səvənhi ramarə irəha mɨnraha. Rɨpkatukwatukw mhə mə irəha tuhəpwəh naniien nari tɨ nəfwakiien ia nəpɨn nəha. ");
INSERT INTO tnk_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mətə trɨpkuvehe ia nəpɨn sə tɨpkuvehi raka iərman sə rɨpkarə vi a irau pran səvənhi trɨpkarə mhə mwi irəha mɨnraha. Ia nəpɨn nəha irəha tuhəpwəh naniien nari tɨ nəfwakiien. ");
INSERT INTO tnk_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Iərmama riti riwən ko ruvehi nɨpəri tɨnari vi mɨtiri tukuahaɡ ia ruei tɨnari ivɨs. Trɨni mɨnuə ro iamɨnhi irə, nɨpəri tɨnari vi truvehe mɨkɨmkɨm, meitehi tɨnari ivɨs mo ruen rasori. ");
INSERT INTO tnk_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Iərmama riti riwən ko rətəɡi pen waen vi ia tɨki waen tui sə kɨno ia teki nəni. Trɨni mɨnuə ro iamɨnhi irə, waen vi trəse tɨki waen tui rəsisi məpəruə. Nənə tɨki waen tui mɨne waen vi irau pəri krouərəha. Mətə waen vi tukətəɡi pen ia tɨki waen vi me.” ");
INSERT INTO tnk_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nəpɨn riti ia Sapat Iesu ramavən maməpi sɨmwɨn ia nɨmei wit me nepwɨn. Nərmama me səvənhi kamhəkurirə in, mamhesi kwənkwai wit, mamhani. ");
INSERT INTO tnk_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ro iamɨnhi irə Farisi me həni pen tɨ Iesu i mə, “Ətə ro. Nərmama me səim kamho noien riti rɨpkatukwatukw mhə ia Loa səkɨtaha mə tuko ia sapat. Rəfo kamho iamɨnha irə?” ");
INSERT INTO tnk_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Rosi kɨmiaha hiəpkəvsini raka mhə ia Nəkukuə Ikinan nəfe Kiɡ Tevɨt rɨno fwe kupwən uə? Ia nəpɨn nəha Apiatar rauvehi wok irə səvəi pris asori anan, Kiɡ Tevɨt mɨne nərmama me səvənhi nəveɡɨnien riwən tɨ nirəha, nukumhə rɨnahi irəha. Nənə Kiɡ Tevɨt ruvnimwə ia nimwə səvəi Kumwesən, muvehi bred ikinan sə raməmak ia nɨfatə. Rɨpkatukwatukw mhə ia Loa səkɨtaha mə in trəni bred nəha, pris me əpa həukurən naniien. Mətə Kiɡ Tevɨt rəni, muvei pen mwi m nərmama me səvənhi hani.” ");
INSERT INTO tnk_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nənə Iesu rɨni pen tɨ nirəha i mə, “Kɨno Sapat tɨ iərmama. Kɨpko mhə iərmama tɨ Sapat. ");
INSERT INTO tnk_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ro pen iou, Iəməti Iərmama, iakamərɨmənu ia Sapat.” ");
INSERT INTO tnk_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Iesu revən muvnimwə mwi ia nimwəfwaki səvəi nəkur Isrel. Iərmama riti ia nəkwai nimwəfwaki nəha rəɡɨn rərfe ko rɨpkuvi atukw mhə i. ");
INSERT INTO tnk_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nəmə asori me kamhətə Iesu mə trəfo irə mɨne. Trɨni mɨnuə romasan iərmama nəha ia Sapat, tuhəni ərəha in tukwe. ");
INSERT INTO tnk_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Iesu rɨni pen tɨ iərmama sə rəɡɨn rərfe mə, “Ərer ia kurkwai nərmama.” ");
INSERT INTO tnk_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nənə Iesu rəres pen irəha i mə, “Ratukwatukw ia Loa səkɨtaha mə ia Sapat tuko noien amasan uə tuko noien ərəha? Ratukwatukw mwi mə tukuvehimɨru iərmama uə tukousi əpune?” Iesu rəres pen irəha i, mətə həpwəh nəɡkiariien. ");
INSERT INTO tnk_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","In rəti ərari mamətə irəha. Niemaha rəpi. Rerɨn rəpou tɨ nəri nə mə kənkapwənraha rɨskai. Nənə in rɨni pen tɨ iərmama sə rəɡɨn rərfe mə, “Tiko muvi atukw rəɡɨm.” Iərmama nəha ruvi atukw rəɡɨn. Rəɡɨn ruvehe mamasan mwi. ");
INSERT INTO tnk_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nənə Farisi me həier irapw, mhəuvən akwauakw tɨ nərmama me səvəi Kiɡ Herot. Irəha housəsɨmwɨn irəha me mhəni ərəha Iesu, mamhətui suatuk mə tuhousi əpune in. ");
INSERT INTO tnk_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesu rier irəha nərmama me səvənhi, mevən fwe ia nui asori Kalili. Nəkur Kalili həpɨk həkurirə i. ");
INSERT INTO tnk_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Nərmama həpɨk mwi nəha ikɨn nəpɨn həreɡi narimnari me nəha Iesu ramo həuvehe mhətoni in. Nepwɨn həuku pen ia tənə Jutia mɨne Jerusalem, nepwɨn həuku pen ia tənə Itumia, nepwɨn həuku pen ia nui arɨs Joten pen, nepwɨn mwi həuku pen ia kwopun me nəha ipaka tɨ taon mi nəha Taea mɨne Saeton. ");
INSERT INTO tnk_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tɨ nəri nə mə nərmama me nəha həpɨk anan, Iesu rɨni pen tɨ nərmama me səvənhi mɨnuə tuhəpnəpenə ia nɨtətə ouihi riti pwəh in rəkure irə kamo nərmama həsɨɡəsɨɡi in. ");
INSERT INTO tnk_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","In rɨni iamɨnhi irə mɨne tɨ nəri nə mə in rɨnomasan raka nərmama həpɨk mo pen səməme kamhemhə kamhəuvehe ipaka tukwe mə tuhərapi in. ");
INSERT INTO tnk_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nənə ia nəpɨn me, nəpɨn nənɨmwɨn ərəha me səməme kamharə ia nərmama kamhətoni in, kamhənɨmwi nukurhunraha ia nənimen, mamhəkwein asori, mamhəni mə, “Ik Tɨni Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mətə Iesu ranise pen əknekɨn tɨ nirəha i mə tuhəpwəh nəkwein əpwəmwɨsien nəɡhɨn iamɨnhi kamo nərmama həreɡi həukurən in. ");
INSERT INTO tnk_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Iesu rutə ia təkuər riti, məkwein nərmama me səvənhi səməme in rokeikei mə irəha tuhəuvehe tukwe, nənə irəha həuvehe. ");
INSERT INTO tnk_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","In rərpwi rəɡɨn ia nirəha pam twelef, mɨseɡi pen nəɡhɨnraha mə aposol me. Irəha tuhamarə pəri irəha Iesu. In trərhi pen irəha həuvən mhəvisau irapw nəɡkiariien amasan. ");
INSERT INTO tnk_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","In truvei pen nasoriien mɨnraha. Ia nasoriien nəha irəha tuhəkoui irapw nəremhə me ia nərmama. ");
INSERT INTO tnk_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nəɡhi aposol me nəha ro iamɨnhi irə: Saemon (iəmə Iesu rɨseɡi pen nəɡhɨn sə vi mə Pita). ");
INSERT INTO tnk_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Nənə Jemes mɨne piəvni nəɡhɨn nə Jon (irau tɨni Sepeti mi. Iesu rɨseɡi pen nəɡhɨnrau sə vi mə Poanejes. Nɨpwrai nəɡkiariien nəha in nə mə tɨni karuəruə mi). ");
INSERT INTO tnk_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Nənə Antru, mɨne Filip, mɨne Patolomiu, mɨne Matiu, mɨne Tomas, mɨne Jemes tɨni Alfeas, mɨne Tateas, mɨne Saemon (iəmə sə kupwən rakurirə nəmə me nəha kamhəmwur mə tuhəkoui irapw nəkur Rom). ");
INSERT INTO tnk_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Nənə Jutas Iskariot (iəmə sə ruvehi pen Iesu ia rəɡi nərmama səməme kamhəmwəki in). ");
INSERT INTO tnk_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kurirə irə Iesu revən muvnimwə ia nimwə riti. Nərmama me həuvehe mwi tukwe. Irəha həpɨk. Ro pen Iesu mɨne nərmama me səvənhi nəpɨn səvənraha riwən tɨ nəniien nari. ");
INSERT INTO tnk_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nəpɨn nəkur imwəni me həreɡi nəfe Iesu ramo, həuvən mə tuhəuvehi raka in, mhəni mə, “In ramarməri.” ");
INSERT INTO tnk_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ia nəpɨn nəha nahatən me nepwɨn səvəi Loa həuku pen fwe ia Jerusalem, mhəni ərəha Iesu, mhəni mə, “Pielsepul ramarə ia iəmə nəha. Iəmə nəha raməkoui irapw nəremhə me ia nɨskaiien səvəi iəremhə sə in rasori ia nəremhə me.” ");
INSERT INTO tnk_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Irəha həni ərəha Iesu iamɨnhi irə ro pen Iesu rəkwein pen irəha həuvehe. Rəɡkiari mɨnraha, mɨni nusipekɨnien riti tɨ nirəha i mə, “Rəfo irə? Ko Setan rəkoui irapw nəremhə me səvənhi ia nərmama uə rekəm? ");
INSERT INTO tnk_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Trɨni mɨnuə ieni riti ruai narəien səvənhi ro kəru irə, nərmama me səvənhi kamhousi irəha me, nɨtətə sə ieni nəha ramərɨmənu irə ko rɨpkərer əpwəmwɨs mhə. ");
INSERT INTO tnk_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Trɨni mɨnuə nərmama səməme kamharə ia nəkwai nimwə riti həuai narəien səvənraha ro kəru irə, kamhousi irəha me, irəha ko həpkarə amasan mhə. ");
INSERT INTO tnk_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nənə trɨni mɨnuə Setan ruai narəien səvənhi ro kəru irə, raməkoui irapw nəremhə me səvənhi ia nərmama, noien səvəi Setan ko rɨpkərer əpwəmwɨs mhə. Trəsas miwən. ");
INSERT INTO tnk_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Iərmama riti riwən ko revən ia nəkwai nimwə səvəi iəmə skai riti, makres narimnari me səvənhi. In traməkeikei mukupwən məkwtəmhiri iəmə skai nəha, mərihi rəɡɨn mi mɨne nɨsun mi. Kurirə irə in rukurən nevənien makres narimnari me fwe ia nəkwai nimwə səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Iakani nɨpərhienien tukumiaha i. Kumwesən rukurən nenouenouien nərəhaien me pam səməme nɨpwnəti nərmama me tuho uə tuhəni irə, məpwəh nərpwɨnien. ");
INSERT INTO tnk_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mətə iərmama sə trɨni ərəha Nənɨmwɨn Ikinan, Kumwesən trɨpkenouenou mhə nərəhaien səvənhi ia nəpɨn riti. Nərpwɨnien səvənhi trarə rerɨn.” ");
INSERT INTO tnk_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesu rɨni nəɡkiariien nəha tɨ nəri nə mə nahatən me səvəi Loa haməni mə, “Nənɨmwɨn ərəha ramarə irə.” ");
INSERT INTO tnk_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ia nəpɨn nəha piəvi Iesu me mɨne mama səvənhi həuvehe mamhərer fwe iruə, mhərhi pen nəɡkiariien tɨ Iesu mə truvehe. ");
INSERT INTO tnk_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nərmama həpɨk kamhəkure kurkurau ia Iesu. Irəha həni pen tukwe in mə, “Ətə ro! Səim fwe mama mɨne piam me kamhərer fwe iruə mamhəres ik.” ");
INSERT INTO tnk_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Mɨreɡi Iesu rɨni mə, “Sin nəha səiou mama? Nɨsɨmə nəha piak me?” ");
INSERT INTO tnk_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","In rəti ərari mamətə səməme kamhəkure kurkurau i, mɨni pen tɨ nirəha i mə, “Kɨmiaha i səiou mama me. Kɨmiaha i piak me. ");
INSERT INTO tnk_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nərmama səməme kamho nəkwai Kumwesən, irəha həmwhen ia mama me mɨne piak me səiou.” ");
INSERT INTO tnk_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iesu rɨnamahatən mwi nərmama ia nɨkare nui asori. Nərmama me həpɨk həuvehe mhousəsɨmwɨn pen irəha me tukwe. Ro pen Iesu rəputə ia nɨtətə ouihi riti fwe peraha, məkure irə. Nərmama me pam kamhərer parei ia nɨkare nui asori. ");
INSERT INTO tnk_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Iesu ramahatən irəha narimnari me rɨpɨk ia nusipekɨnien me. Nəpɨn ramahatən irəha, rani mə, ");
INSERT INTO tnk_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Tihəreɡi ro! Iərmama riti revən mə truini nuni nari ia nəmhien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nəpɨn rauini pen nuni nari me, nuni nari me nepwɨn həsas pen ia suatuk. Menu me həuvehe mhani pam. ");
INSERT INTO tnk_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nuni nari me nepwɨn həsas pen ia təkure kəpwier sə tɨprənə rouihi ikɨn. Həutə akwauakw tɨ nəri nə mə nuanraha rɨpkeiwaiu amasan mhə ia tɨprənə. ");
INSERT INTO tnk_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nuanraha rouihi. Ro pen nəpɨn meri rəkwiri, mənhi, haukei pam. ");
INSERT INTO tnk_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nuni nari me nepwɨn həsas pen ia tɨprənə sə nəkwus ərəha rautə irə. Nəkwus ərəha me nəha həuvirɨs mhəuvehe mhousəman pam. Ro pen nuni nari me həpkukuə mhə. ");
INSERT INTO tnk_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nuni nari me nepwɨn həsas pen ia tɨprənə amasan, mhəutə amasan, mhəukuə. Nepwɨn kwənkwan toti, nepwɨn kwənkwan sikisti, nepwɨn kwənkwan hantret.” ");
INSERT INTO tnk_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Iesu rɨni mə, “Iərmama sə nəkwəreɡɨn rarə tɨ nɨreɡiien nari traməkeikei mətərɨɡ amasan.” ");
INSERT INTO tnk_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nəpɨn Iesu əpa, nərmama səvənhi twelef həuvehe irəha nərmama me nepwɨn mwi səməme kamharə ipaka tɨ Iesu, mhəres pen mə rəfo in ramahatən nərmama ia nusipekɨnien me. ");
INSERT INTO tnk_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Iesu rɨni pen tɨ nirəha i mə, “Kɨmiaha nərmama me səiou kɨnəsevər ia suatuk tukumiaha hiəukurən nɨtətə sə Kumwesən ramərɨmənu irə mə in rəfo irə. Mətə nərmama iruə me, iakamahatən irəha ia nusipekɨnien me a, ");
INSERT INTO tnk_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","mə irəha tuhətə, mətə tuhəpwəh nətəien mhəukurən. Irəha tuhəreɡi, mətə tuhəpwəh nɨreɡiien mhəukurən. Ro iamɨnhi irə ko irəha həpwəh nɨrərɨɡien mhəuvehe tɨ Kumwesən mɨnuə in trenouenou noien ərəha me səvənraha.” ");
INSERT INTO tnk_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Iesu rəres pen nərmama me səvənhi mə, “Rəfo? Kɨmiaha hiəreirei nɨpwrai nusipekɨnien səvəi iərmama sə rauini nuni nari? Ro iamɨnhi irə tihəfo mhəukurən mwi nusipekɨnien me nepwɨn mwi? ");
INSERT INTO tnk_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Iərmama sə rauini nuni nari rəmwhen ia iərmama sə raməvisau irapw nəɡkiariien amasan. ");
INSERT INTO tnk_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nərmama nepwɨn həmwhen ia nuni nari sə həsas pen ia suatuk. Nəpɨn hamətərɨɡ iərmama raməvisau irapw nəɡkiariien amasan, təkwtəkwuni a mwi Setan ruvehe muvehi raka nəɡkiariien nəha hamreɡi. ");
INSERT INTO tnk_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nərmama nepwɨn həmwhen ia nuni nari sə həsas pen ia təkure kəpwier. Nəpɨn hamreɡi nəɡkiariien amasan, həuvehi, mhaɡien tukwe. ");
INSERT INTO tnk_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mətə nəɡkiariien nəha rɨpkeiwaiu amasan mhə ia rerɨnraha rəmwhen ia nuai nei me. Irəha tuhəuvehi nəɡkiariien nəha səvəi nəpɨn ouihi a. Nəpɨn nərmama tuho nəmisəien mɨnraha, uə tuhometə irəha tɨ nəɡkiariien amasan, tuharaka akwauakw a irə. ");
INSERT INTO tnk_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nərmama nepwɨn həmwhen ia nuni nari sə həsas pen ia tɨprənə nəkwus ərəha rautə irə. Həreɡi nəɡkiariien amasan, ");
INSERT INTO tnk_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mətə hamətərɨɡ pɨk ia narimnari me səvəi tɨprənə i. Mane rameikuə ia nirəha, mavi raka nətərɨɡien səvənraha. Hokeikei mə tuhəuvehi nautə me nepwɨn mwi. Nətərɨɡien me nəha həuvnimwə ia rerɨnraha mhousəman nəɡkiariien amasan rəpwəh nukuəien. ");
INSERT INTO tnk_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mətə nərmama nepwɨn mwi həmwhen ia nuni nari sə həsas pen ia tɨprənə amasan. Irəha həreɡi nəɡkiariien amasan, mhəuvehi, mhəukuə. Riti nukwan toti, riti nukwan sikisti, riti nukwan hantret.” ");
INSERT INTO tnk_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Iesu rɨni pen tɨ nirəha i mə, “Trɨni mɨnuə iərmama riti ruvehi laet, muvnimwə pehe, ko rəuiui ia nari riti uə rukurei pen ia kwopun afafa ikɨn? Rekəm! Traməkeikei mukurei pen ia nəri kakurei pen laet irə. ");
INSERT INTO tnk_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Narimnari me pam səməme hamərkwafə tuhaməkeikei mhəier irapw. Narimnari me pam səməme haməmak afafa tuhaməkeikei mhəuvehe ia nukuraanien. ");
INSERT INTO tnk_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kɨmiaha nərmama nəkwəreɡɨmiaha rarə tɨ nɨreɡiien nari, tihətərɨɡ amasan.” ");
INSERT INTO tnk_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Iesu rarə mɨni pen mwi tɨ nirəha i mə, “Tihətərɨɡ amasan ia nəfe hiamreɡi. Nəfe nari hiəuvehi pen tukuvehi pehe rəmwhen rɨrərɨɡ mwi tukumiaha nənə kuvehi pehe sə rəkwaku. ");
INSERT INTO tnk_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ro iamɨnhi irə tɨ nəri nə mə iərmama sə kuvei pen nari riti min, ro wok irə, tukuvei pen sə rəkwaku min. Mətə iərmama sə kuvei pen nari riti min, ro nəri auər a irə, tukuvehi raka pam tukwe.” ");
INSERT INTO tnk_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Iesu rɨni mə, “Nɨtətə sə Kumwesən ramərɨmənu irə rəmwhen ia iərmama riti sə ruini nuni nari rəsas pen ia tɨprənə. ");
INSERT INTO tnk_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ruini pam nuni nari, mevən mapri. Mapri ia nəpɨn meste rɨran. Revən mamavən. Nənə nuni nari rɨruəruə mutə. Mətə iərmama nəha rɨreirei mə rəfo mo iamɨnhi irə. ");
INSERT INTO tnk_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tɨprənə a ro nuni nari rutə, merɨp tukun, mɨfi tihin, mo kwənkwan. ");
INSERT INTO tnk_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mətə nəpɨn kwənkwan rɨmruə, iərmama nəha revən mesi, tɨ nəri nə mə nəpɨn atukwatukw nəha səvənhi.” ");
INSERT INTO tnk_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iesu rɨni mə, “Tsəfni ia nɨtətə sə Kumwesən ramərɨmənu irə? Rəfo irə? Nəfe nəha nəɡkiariien tsəni mhəusipekɨn irə? ");
INSERT INTO tnk_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nɨtətə sə Kumwesən ramərɨmənu irə rəmwhen ia kwənuni nei nəha mastat. Nəpɨn kɨnɨmwi pen ia tɨprənə, nuni mastat rouihi anan ia nuni nei me. ");
INSERT INTO tnk_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mətə nəpɨn kɨnɨmwi pen pam, rutə masori məpi raka nəpɨɡɨn me pam. Rəɡrəɡɨn rasori. Menu me ia nɨmaɡouaɡou ho pen kwətəpaɡ me səvənraha irə, mhəkure afafa irə.” ");
INSERT INTO tnk_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iesu rɨni irapw nusipekɨnien me rɨpɨk mwi həmwhen ia səməme i, mamahatən nərmama me ia nəɡkiariien amasan, mɨni pen atukwatukw rəmwhen mə irəha tuhəreɡi mhəukurən. ");
INSERT INTO tnk_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Iesu rəpwəh nɨniien nəɡkiariien əpə iti mwi tɨ nirəha, nusipekɨnien me a. Mətə kurirə ikɨn, nəpɨn Iesu mɨne nərmama me səvənhi irəha əpa, rɨni irapw pam nɨpwrai nəɡkiariien. ");
INSERT INTO tnk_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ia nəpɨn nəha rɨnaməruarəv, Iesu rɨni pen tɨ nərmama me səvənhi mə, “Pwəh səpi sɨmwɨn pen fwe ia nɨkare nui.” ");
INSERT INTO tnk_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nənə irəha həpwəh nərmama me, mhəputə ia nəkwai nɨtətə ouihi sə Iesu raməkure irə, mamhəuvən. Nɨtətə ouihi me nepwɨn mwi kamhəkurirə irəha. ");
INSERT INTO tnk_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ia nəpɨn nəha nɨmətaɡi asori riti rɨskəmter. Peiau peiau raməpwi nɨtətə ouihi mamati pen mɨnakuər. ");
INSERT INTO tnk_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Iesu raməsauə mamapri fwe ia kurirə ia nɨtətə ouihi. Nərmama me səvənhi həsuəpwiri in mhəni pen tukwe in mə, “Iahatən, ətə ro! Na tsəmwhenɨmw! Iko nəri auər a ia kɨtaha mik uə?” ");
INSERT INTO tnk_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Iesu rərer mɨnise nɨmətaɡi, məɡkiari m nui mə, “Tikeiwaiu, məmərinu.” Nɨmətaɡi reiwaiu. Nui rəmərinu. Narimnari me pam həuvehe mhəmərinu. ");
INSERT INTO tnk_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nənə Iesu rɨni pen tɨ nərmama me səvənhi mə, “Rəfo hiamhekɨr iamɨnhi irə? Kɨmiaha hiəpkahatətə mhə ihi ia nirak uə?” ");
INSERT INTO tnk_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Mətə irəha həhekɨr pɨk, mhəres pen irəha me i mə, “Nəfe nəha iərmama? Nɨmətaɡi mɨne nui krauo nəkwan!” ");
INSERT INTO tnk_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Irəha həier pen ia nɨkare nui asori ia tənə səvəi nəmə Karasa. ");
INSERT INTO tnk_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nəpɨn nɨtətə ouihi ruvehe mərer, Iesu ruvarei, nənə iərmama riti ruku pen ia kwopun kanɨmwi nərmama ikɨn mier pehe tukwe. Nənɨmwɨn ərəha ramarə irə. ");
INSERT INTO tnk_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Iərmama nəha ramarə ia kwopun kanɨmwi nərmama ikɨn. Iərmama riti mwi riwən nɨskaiien səvənhi rəmwhen mə trəkwtəmhiri iərmama nəha mərihi mwi in. Jen rəpwəh nəmwhenien. ");
INSERT INTO tnk_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nəpɨn rɨpɨk hənərihi raka rəɡɨn mi mɨne nɨsun mi ia jen, mətə rəvi əmwsəmwesi jen sə rəkwtəmhiri rəɡɨn, mousi testesi jen sə rəkwtəmhiri nɨsun. ");
INSERT INTO tnk_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ia nəpɨn mɨne ia ran ramavən ia kwopun kanɨmwi nərmama ikɨn mɨne ia təkure təkuər me, maməkwein əpwəmwɨs, maməkwi testesi atukw a in ia kəruəterei. ");
INSERT INTO tnk_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nəpɨn iərmama nəha rəti pen mətoni Iesu isipwɨn kwopti ramavən mauvehe, raiu muvehe mɨnɨmwi nukurhun mi ia nənimen, ");
INSERT INTO tnk_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","maməɡkiari asori, mamɨni mə, “Iesu. Kumwesən sə rasori anan tɨni nə ik. Ikuvehe mə tikəfo iou irə? Ia nəɡhi Kumwesən iakase ik tikəpwəh noien nəmisəien miou.” ");
INSERT INTO tnk_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","In raməɡkiari iamɨnhi irə tɨ nəri nə mə Iesu ruvəni pen raka tukwe in mə, “Ik, nənɨmwɨn ərəha, tikier ia iərmama i.” ");
INSERT INTO tnk_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Iesu rəres pen in i mə, “Nəɡhɨm sin?” Mɨreɡi rɨni mə, “Iou nəɡhɨk Nəkuər tɨ nəri nə mə kɨmaha iahəpɨk.” ");
INSERT INTO tnk_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","In ramase Iesu, maməɡkiari asori mə trəpwəh nərhiien irəha həuvən isipwɨn. ");
INSERT INTO tnk_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mətə toue pɨkə me həpɨk anan kamhərku ia kwopun nəha. ");
INSERT INTO tnk_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nənɨmwɨn ərəha me nəha hamase Iesu i mə, “Tikərhi pen kɨmaha iahəuvən ia pɨkə me. Pwəh iahəuvnimwə ia rerɨnraha.” ");
INSERT INTO tnk_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Iesu rəseni irəha. Ro pen nənɨmwɨn ərəha me həier ia iərmama nəha mhəuvnimwə ia reri pɨkə me. Pɨkə me, ipaka irəha pam 2000, haiu, mheiwaiu ia nəpatu, mhəsas pen ia təmwei nui asori, məmwhenɨmw. ");
INSERT INTO tnk_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nərmama səməme kamhətui tɨ pɨkə me hap, mhəuvən ia taon səvənraha mɨne ia rukwənu me, mhəni irapw nəfe hənətoni. Nəpɨn nərmama me həreɡi, həuvən mə tuhəspau i mə rəfo irə. ");
INSERT INTO tnk_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Irəha həuvehe tɨ Iesu, mhəti pen mhətoni iərmama sə nənɨmwɨn ərəha me həpɨk hənarə irə. Rarkahu, maməkure, nətərɨɡien səvənhi rɨnəmak amasan. Irəha hətoni həhekɨr. ");
INSERT INTO tnk_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nənə səməme hənətoni həni irapw tɨ nirəha i nəfe kɨno ia iərmama nəha mɨne pɨkə me. ");
INSERT INTO tnk_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nənə irəha hənamase Iesu mə trəpwəh tənə səvənraha mamevən. ");
INSERT INTO tnk_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nəpɨn Iesu rɨnaməputə ia nɨtətə ouihi, iərmama sə nəremhə me hənarə irə raməres in mə trəseni in pwəh revən irau min. ");
INSERT INTO tnk_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mətə Iesu rɨni pen tukwe in mə, “Rekəm. Tikevən fwe imwam, mətoni ik me nepwɨn, məvisau mɨnraha narimnari me Iərɨmənu rɨno mik, mɨni mə rerɨn rərkwəpɨr tukw ik.” ");
INSERT INTO tnk_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nənə iərmama nəha revən fwe ia Tekapolis, kwopun taon ten ikɨn, maməvisau narimnari me nəha Iesu rɨno min. Nərmama pam həreɡi, hamərkərinari irə. ");
INSERT INTO tnk_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iesu rəputə ia nɨtətə ouihi, məpi sɨmwɨn mwi ia nui asori Kalili, muvarei ia nɨkaren pen. Nəpɨn rauvarei ihi, nərmama həpɨk həuvehe mhousəsɨmwɨn pen irəha me tukwe. ");
INSERT INTO tnk_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nənə iəmə asori riti səvəi nimwəfwaki səvəi nəkur Isrel ruvehe. Nəɡhɨn nə Jaeras. Nəpɨn rətə Iesu, ruvehe mɨnɨmwi nukurhun mi ia nənimen, ");
INSERT INTO tnk_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","mamase in mə, “Prənouihi səiou na tremhə. Tikuvehe məmrutə ro rəɡɨm ia nɨpwran pwəh ruvehe məsanɨn, mɨmɨru.” ");
INSERT INTO tnk_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nənə Iesu rukurirə in rouevən. Nərmama həpɨk həukuraukurau irə, mamhəkurirə i. ");
INSERT INTO tnk_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pran riti fwe ikɨn ramemhə ia nemhəien səvəi nɨpran. Nemhəien nəha rɨnarə rerɨn irə muvehi nuk twelef. ");
INSERT INTO tnk_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ruvavən raka tɨ tokta me həpɨk, mɨreɡi nəmisəien me səpəmsəpə ia rəɡɨnraha, mouraha pam mane səvənhi ia nemhəien, mətə nemhəien səvənhi rəpwəh neiwaiuien. Ruvehe mamasori. ");
INSERT INTO tnk_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","In ruvəreɡi raka nərmama kamhəvisau Iesu. Ro pen ruvehe ia reri nəkuər səməme kamhəkurirə ia Iesu, mɨrapi tɨnari səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Rerɨn ramrhi mə, “Rosi ko iakrapi tɨnari səvənhi, nemhəien səiou triwən.” ");
INSERT INTO tnk_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Nəpɨn rɨrapi tɨnari səvəi Iesu, təkwtəkwuni a mwi nɨmwapw rama. Prən nəha rɨreɡi mə nɨpwran rɨnəsanɨn. ");
INSERT INTO tnk_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ia nəpɨn nəha Iesu rɨreɡi mə nəɡsen rier irə mevən mo nari riti. Rəti kurirə ia reri nərmama, maməres mə, “Sin rɨrapi tɨnari səiou?” ");
INSERT INTO tnk_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Mɨreɡi nərmama me səvənhi həni pen tukwe in mə, “Ikətə nərmama me i həpɨk kamhousəsɨmwɨn pehe ipaka tukw ik. Rəfo ikaməres mə sin rɨrapi ik?” ");
INSERT INTO tnk_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mətə Iesu rəti ərari mamətui mə sin rɨrapi in. ");
INSERT INTO tnk_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Pran sə rɨrapi Iesu rukurən nəfe Iesu rɨno min. Ro iamɨnhi irə ruvehe mɨnɨmwi nukurhun mi ia nəmri Iesu, mehekɨr mətəmnɨmwɨn, mɨni irapw pam nɨpərhienien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Iesu rɨreɡi, mɨni pen tɨ prən i mə, “Nərɨk, nahatətəien səim rɨno raka ik ikuvehe məsanɨn. Nəmərinuien ramarə tukw ik. Evən! Nemhəien səim ruvəiwən.” ");
INSERT INTO tnk_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nəpɨn Iesu raməɡkiari ihi, nərmama nepwɨn həuku pen ia nimwə səvəi iəmə asori nəha Jaeras, mhəuvehe, mhəni mə, “Səim prən ouihi ruvamhə raka. Ramasan mə ikɨni pen tɨ iahatən i mə in trəpwəh pehe.” ");
INSERT INTO tnk_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mətə Iesu ro nəri auər a ia nəfe irəha haməni, mɨni pen tɨ Jaeras i mə, “Tikəpwəh nehekɨrien, mɨni a nɨpərhienien ia nirak.” ");
INSERT INTO tnk_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ia nəpɨn nəha Iesu rɨnise pen tɨ nərmama mə tuhəpwəh nukurirəien in. Mətə rəseni a Pita, Jemes, mɨne Jon piəvi Jemes. ");
INSERT INTO tnk_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nəpɨn irəha həuvən mhapirapw ia nimwə səvəi Jaeras, Iesu rəti pen mətə kamho nurɨɡrɨɡien asori. Nərmama kamhapi mamhasək əpwəmwɨs. ");
INSERT INTO tnk_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Mətə Iesu ruvnimwə ia nəkwai nimwə məres pen irəha i mə, “Rəfo hiaməurɨɡrɨɡ mamhasək? Prənouihi nəha rɨpkemhə mhə, mətə ramapri a.” ");
INSERT INTO tnk_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Irəha həreɡi, harɨs ia Iesu. Mətə in rərhi irapw irəha həuvən fwe iruə, miri tata mɨne mama səvəi prən ouihi irəhar nərmama kahar səvənhi həuvən fwe ia kwopun prən ouihi raməmak ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nənə in ruvehi rəɡi prən ouihi nəha, mɨni pen tukwe in mə, “Talita kum.” Nɨpwrai nəɡkiariien nəha rɨni iamɨnhi irə mə, “Prənouihi, iakɨni pehe tukw ik i mə ərer.” ");
INSERT INTO tnk_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Təkwtəkwuni a prən ouihi rɨskəmter mavən. (Prənouihi nəha nuk səvənhi twelef.) Nəpɨn nərmama hətoni nəfe Iesu rɨno, nənimenraha rier pɨk. ");
INSERT INTO tnk_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Mətə Iesu rɨnise pen tɨ nirəha i mə, “Tihəpwəh nəvisauien noien i m nərmama. Həuvei pen nəveɡɨnien riti min pwəh rəni.” ");
INSERT INTO tnk_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesu rəpwəh kwopun nəha mevən fwe imwəni. Nərmama me səvənhi irəha mwi həkurirə in mhəuvən fwe ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nəpɨn Sapat ruvehe, Iesu rɨnamahatən nərmama ia nəkwai nimwəfwaki səvəi nəkur Isrel. Nərmama həpɨk səməme kamhətərɨɡ Iesu hərkərinari irə, mamhəres mə, “Iəmə i ruvehi narimnari me nəha pəku? Muvehi nukurənien nəha pəku? Raməfo irə mamo nɨmtətien asori me? ");
INSERT INTO tnk_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kwa kapenta i tɨni Meri! Piəvni me nə Jemes, Josef, Jutas mɨne Saemon. Kɨtiriməni me hamarə ia rukwənu i kɨtaha mɨnraha.” Irəha rerɨnraha rɨpkaɡien mhə tɨ Iesu. Həpwəh nɨsiaiien in. ");
INSERT INTO tnk_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ro iamɨnhi irə Iesu rɨni pen tɨ nirəha i mə, “Nərmama ia kwopun me kamhəsiai profet riti, mətə ia imwəni atukwatukw, nəkur imwəni me mɨne nərmama səməme kamharə ia nəkwai nimwə səvənhi ko həpwəh nɨsiaiien in.” ");
INSERT INTO tnk_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nənə Iesu rɨpko mhə nɨmtətien rɨpɨk fwe imwəni. Ro kəru uə kahar a, məmrutə rəɡɨn mi ia nərmama səməme nemhəien rarə ia nirəha, mo irəha həuvehe mhəsanɨn. ");
INSERT INTO tnk_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","In ramərkərinari ia nəkur imwəni me tɨ nəri nə mə irəha həpkɨni mhə nɨpərhienien irə. Iesu ramevən ia rukwənu me mamahatən nərmama me. ");
INSERT INTO tnk_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ia nəpɨn nəha in rəkwein nərmama səvənhi twelef həuvehe. Nənə in rɨnamərhi pen irəha kəru kəru ia kwopun me, muvei pen nasoriien mɨnraha. Ia nasoriien nəha irəha tuhəkoui irapw nənɨmwɨn ərəha me ia nərmama. ");
INSERT INTO tnk_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Iesu rɨni pen tɨ nirəha i mə, “Tihəpwəh nuvehiien narimnari me səvəi suatuk, nəveɡɨnien uə tənərɨpw uə mane. Tiharkahu ia karkahu kuatia a, mhəuvehi pen put, mhəuvehi kaskɨn a, mhəuvehi mamhəuvən. ");
INSERT INTO tnk_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nəpɨn hiəuvən ia kwopun riti, mhəuvnimwə ia nəkwai nimwə, tiharə ia nimwə nəha meste tihəier. ");
INSERT INTO tnk_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Trɨni mɨnuə fwe ia kwopun riti nərmama həpkəseni mhə kɨmiaha, həpkokeikei mhə mə tuhəreɡi nəɡkiariien səkɨmiaha, nəpɨn kɨmiaha hiəpwəh imwənraha, tihounouini raka nɨməkwrur ia nɨsumiaha. Noien nəha hio ro nɨmtətien mɨnraha, mamahatən pen mə həno noien ərəha.” ");
INSERT INTO tnk_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Iesu rɨni pen pam nənə irəha həuvən mamhəvisau irapw mə nərmama tuhaməkeikei mhərərɨɡ ia noien ərəha me səvənraha. ");
INSERT INTO tnk_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Irəha kamhəkoui irapw nəremhə me həpɨk ia nərmama, mamhətəɡi pen oel ia kənkapwə nərmama səməme nemhəien rarə ia nirəha, mho irəha həuvehe mhəsanɨn. ");
INSERT INTO tnk_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kiɡ Herot rɨreɡi narimnari me səməme Iesu ramo tɨ nəri nə mə nərmama kamhəni pɨk nəɡhi Iesu. Nepwɨn kamhəni mə, “In Jon Paptaes. Rɨnətui mwi ia nemhəien səvənhi ro pen rauvehi nɨskaiien mamo nɨmtətien me.” ");
INSERT INTO tnk_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nepwɨn kamhəni mə, “In Profet Elaeja.” Nepwɨn mwi kamhəni mə, “In profet riti rəmwhen ia profet kupwən me.” ");
INSERT INTO tnk_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mətə nəpɨn Kiɡ Herot rɨreɡi, rɨni mə, “Jon sə iakɨnərai raka kənkapwə rɨnətui mwi ia nemhəien səvənhi.” ");
INSERT INTO tnk_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Kiɡ Herot rɨni nəɡkiariien nəha tɨ nəri nə mə fwe kupwən in rakres Herotias pran səvəi piəvni nəɡhɨn nə Filip. Mətə Jon rɨni pen tukwe in mə, “Ikakres pran səvəi piam noien nəha rɨpkatukwatukw mhə ia Loa.” Nənə tɨ prən nəha Kiɡ Herot rɨni nəkwan kərihi tərini Jon kuvehi puvnimwə ia kalapus. ");
INSERT INTO tnk_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nəpɨn Jon raməmak fwe ia kalapus, Herotias raməmwəki afafa a in, mamokeikei mə trousi əpune Jon, mətə rəknekɨn tukwe tɨ noien. ");
INSERT INTO tnk_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Kiɡ Herot rehekɨr Jon, mukurən mə in iəmə ikinan riti sə noien səvənhi ratukwatukw. In ramətui amasan tɨ Jon mə iərmama riti trəpwəh nourahaien. Nɨpərhienien nəpɨn Kiɡ Herot rɨreɡi Jon raməɡkiari, nətərɨɡien səvənhi rəvsausɨni pɨk, mətə rerɨn raɡien mə trɨreɡi. ");
INSERT INTO tnk_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herotias rokeikei mə trousi əpune Jon, mətə rəknekɨn. Mətə in rətoni suatuk tukwe ia nəpɨn Kiɡ Herot rɨnətui irə. Ia nəpɨn nəha Kiɡ Herot ro nəveɡɨnien asori riti sənəi nəmə asori me səməme kamharə ipaka tukwe in mɨne nəmə asori me səvəi naruaɡən me mɨne nəmə asori me ia tənə Kalili. ");
INSERT INTO tnk_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nəpɨn irəha kamhani pəri nari, prən ouihi səvəi Herotias ruvehe mamotanis ia nəmrɨnraha. Kiɡ Herot mɨne nəmə asori me səməme kamhani pəri nari irəha min hətoni rerɨnraha raɡien tukwe. Ro iamɨnhi irə Kiɡ Herot rɨni pen tɨ prən ouihi nəha mə, “Ikokeikei nəfe ikəres i. Iou takuvei pehe mik.” ");
INSERT INTO tnk_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kiɡ Herot rɨni nəkwan muvehi kwəsuahi tukwe, mɨni mə, “Nəfe ikəres, takuvei pehe. Nɨtətə səiou iakamərɨmənu irə ikuə takərpɨfi ia nɨpərɨn kəru, muvei pehe riti mik, takaməkeikei mo.” ");
INSERT INTO tnk_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kurirə irə prən ouihi nəha revən mɨni pen tɨ səvənhi mama mə, “Mama, takəres nəfe?” Mɨreɡi rɨni mə, “Evən məres kənkapwə Jon Paptaes.” ");
INSERT INTO tnk_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ro iamɨnhi irə prən ouihi nəha raiu akwauakw mevən tɨ Kiɡ Herot, mɨni pen tukwe in mə, “Iakokeikei mə təkwtəkwuni tikuvei pehe kənkapwə Jon Paptaes ia tikiplet.” ");
INSERT INTO tnk_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kiɡ Herot rerɨn rəpou pɨk tukwe. Mətə tɨ nəri nə mə rɨməuvehi kwəsuahi ia nəmri nəmə asori me səməme kamhani pəri nari irəha min, rəpwəh nokeikeiien mə trətefi nəɡkiariien səvənhi sə rɨməni pen tɨ prən ouihi i. ");
INSERT INTO tnk_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Təkwtəkwuni a in rərhi pen iaruaɡən riti mɨni pen tukwe mə trevən muvehi kənkapwə Jon muvehi muvehe. Iaruaɡən nəha revən fwe ia kalapus, mərai raka kənkapwə Jon, ");
INSERT INTO tnk_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","məmri pen ia tikiplet, muvehi muvehe, muvei pen m prən ouihi. Prənouihi nəha ruvehi mevən, muvei pen m səvənhi mama. ");
INSERT INTO tnk_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nəpɨn nərmama me səvəi Jon həreɡi, həuvehe mhəuvehi nɨpwrai Jon, mhəuvən mhəmri pen ia nɨpəɡ sə kanɨmwi iərmama ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Aposol me hərərɨɡ pehe mwi tɨ Iesu, mhəni pen tukwe in narimnari me həno mɨne nəɡkiariien me səməme hənahatən nərmama me irə. ");
INSERT INTO tnk_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nənə Iesu rɨni pen tɨ nirəha i mə, “Həuvehe kɨmiaha əpa. Pwəh səuvən ia kwopun riti nərmama həiwən ikɨn, mhapwɨs ouihi a.” In rɨni iamɨnhi irə tɨ nəri nə mə nərmama həpɨk kamhəuvehe tukwe mamhəuvən. Ro pen nəpɨn səvənraha riwən tɨ nəniien nari. ");
INSERT INTO tnk_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Irəha həputə ia nɨtətə ouihi riti, irəha əpa, mamhəuvən fwe ia kwopun riti nərmama həiwən ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nərmama həpɨk hənətə Iesu mɨne nərmama me səvənhi həputə ia nɨtətə ouihi, mamhəuvən. Həuvəukurən raka kwopun kamhəuvən ikɨn. Ro pen irəha haraka ia rukwənu me səvənraha, mhaiu akwauakw mhəkurau parei mhəkupwən mhəuvən fwe ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nəpɨn Iesu ruvarei, mətoni nərmama həpɨk, nənə rerɨn rərkwəpɨr tɨ nirəha, tɨ nəri nə mə irəha həmwhen ia sipsip me nepwɨn iərmama riwən trətə amasan irəha. Nənə Iesu rɨnamahatən irəha ia narimnari me rɨpɨk. ");
INSERT INTO tnk_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nəpɨn meri rakakini, nərmama me səvənhi həuvehe mhətə in, mhəni mə, “Kwopun i nəveɡɨnien riwən ikɨn. Rɨnaməruarəv. ");
INSERT INTO tnk_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ramasan mə tikərhi pen nərmama me i həuvən ia nəmhien me mɨne rukwənu me kwərha ipaka pwəh həuvehi nəmri nəveɡɨnien sənənraha.” ");
INSERT INTO tnk_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mətə Iesu rɨni mə, “Kɨmiaha nə tihəuvei pen nəveɡɨnien mɨnraha.” Mɨreɡi həni pen tukwe in mə, “Rəfo? Ikokeikei mə tahəuvən mhəuvehi nəmri bred ia silin kɨno ia silfa irəha pam tu-hantret, mhəkwməni irəha i?” ");
INSERT INTO tnk_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Sənəmiaha bred kevə? Həuvən mhətoni ro.” Nənə irəha həuvən mhətoni mhəni mə, “Sənəmaha bred krirum mɨne nəmu kəru.” ");
INSERT INTO tnk_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Tihəuvən mhəni pen tɨ nərmama me i mə tuhəuai irəha me, nepwɨn fifti, nepwɨn hantret, pwəh həkure ia nurhi əmrəmerə.” Nənə nərmama həuai irəha me mhəkure. ");
INSERT INTO tnk_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nənə Iesu ruvehi bred krirum mɨne kwəti nəmu kəru, məkwətə ia nɨmaɡouaɡou, məfwaki mɨni vivi Kumwesən tukwe, məkwsen bred me, muvei pen m nərmama me səvənhi mə tuhəpeki pen m nərmama me, marə məkwsen mwi kwəti nəmu mi nəha kəru həpeki pen m nərmama me pam. ");
INSERT INTO tnk_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nərmama pam hani nari tɨpwɨnraha rəsisi. ");
INSERT INTO tnk_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nənə nərmama me səvəi Iesu həvai pen nɨpərpəri bred mɨne nəmu me hənəpwəh ramrɨmər rukuər ia tənərɨpw twelef. ");
INSERT INTO tnk_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nərmama me nəha hənani nari həpɨk, ikəvsini nərman me əpa irəha pam faef-taosen. ");
INSERT INTO tnk_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Təkwtəkwuni a mwi Iesu rɨni pen tɨ nərmama me səvənhi mə tuhəputə ia nɨtətə ouihi, mhəkupwən, mhəpi sɨmwɨn ia nui asori Kalili, mhəuvarei mhəuvən fwe ia rukwənu nəha Petsaeta. In tramo mərhi pen nərmama me həuvən fwe imwənraha me. ");
INSERT INTO tnk_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nəpɨn Iesu rəsəkɨr raka mɨnraha, mutə ia təkuər riti mə trəfwaki. ");
INSERT INTO tnk_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Raməfwaki meste rɨnapitəv. Nəpɨn nəha rɨnapitəv irə, nərmama me fwe ia nəkwai nɨtətə ouihi kamhaiu ihi ia kurkwai nui asori. Iesu in əpa fwe parei. ");
INSERT INTO tnk_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","In rəti peraha, mətoni irəha kamharkut tɨ nəsuəien tɨ nəri nə mə kamhaiu mamhəuvən ia nəmri mətaɡi mwatuk. Ia nəpɨn nəha rɨnamran, Iesu ruvehe tɨ nirəha, mamavən ia təkure nui, mokeikei mə trevən mukurau ia nɨkarenraha. ");
INSERT INTO tnk_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nəpɨn nərmama me səvənhi həti pen mhətoni Iesu ravən ia təkure nui asori, rerɨnraha ramrhi mə in iəremhə riti. Hamasək əpwəmwɨs. ");
INSERT INTO tnk_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Irəha pam hətoni, həhekɨr asori. Mətə təkwtəkwuni a Iesu rəɡkiari mɨnraha, mɨni mə, “Kɨmiaha tihəpwəh nɨreɡiien rərəha. Kwa iou i. Tihəpwəh nehekɨrien.” ");
INSERT INTO tnk_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Iesu revən tɨ nirəha, məputə ia nɨtətə ouihi. Ia nəpɨn nəha nɨmətaɡi reiwaiu miwən. Nənə nərmama me səvənhi nənimenraha rier pɨk, ");
INSERT INTO tnk_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","tɨ nəri nə mə həreirei nɨpwrai nɨmtətien Iesu sə rɨno ia bred krirum, mətə nətərɨɡien səvənraha rɨskai pɨk. ");
INSERT INTO tnk_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Irəha həpi sɨmwɨn ia nui asori, mhəuvən mhəuvarei ia tənə Kenesaret. ");
INSERT INTO tnk_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nəpɨn hənəkwi tərini raka nɨtətə ouihi səvənraha mhəier, nərmama hətoni, mhəukurən amtia mə Iesu nəha. ");
INSERT INTO tnk_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ro pen irəha haiu mhəuvən ia kwopun me pam, mhəuvehi nərmama me səməme nemhəien rarə ia nirəha, mhəuvehi ia nɨməhan me səvənraha, mhəuvehi mhəuvehe tɨ kwopun pəku həreɡi mə Iesu ramarə ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ia kwopun pam Iesu revən ikɨn, ia taon me, uə ia rukwənu asori me, uə ia rukwənu ouihi me, nərmama me həmri nərmama me səməme nemhəien rarə ia nirəha ia kwopun asori me səvənraha me, mamhəres Iesu mə ko irəha hərapi a nusvenhi tɨnari səvənhi. Nənə irəha pam səməme hərapi nusvenhi tɨnari səvənhi həuvehe mhəsanɨn. ");
INSERT INTO tnk_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisi me nepwɨn mɨne nahatən me nepwɨn səvəi Loa səməme həuku pen fwe ia Jerusalem housəsɨmwɨn pen irəha me tɨ Iesu, ");
INSERT INTO tnk_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","mhətoni səvənhi nərmama me nepwɨn kamhərui nɨtətə səvəi kaha kupwən me səvənraha, mamhani nəveɡɨnien ia rəɡɨnraha, mətə həpkukupwən mhə mhərkwerɨɡ. ");
INSERT INTO tnk_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Farisi me mɨne nəkur Isrel me pam kamhesi pen nɨtətə səvəi kaha kupwən me səvənraha. Trɨni mɨnuə həpwəh nərkwerɨɡien ia rəɡɨnraha, ko həpwəh naniien nari. ");
INSERT INTO tnk_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nəpɨn irəha həuku pen fwe maket, mhəuvehe ia rukwənu, tuhaməkeikei mhəkupwən mhərkwerɨɡ. Mə həpwəh, ko həpwəh naniien nari. Natuakəmien me nepwɨn mwi həpɨk kamhesi pen. Kamhəuvehi tɨkikap me mɨne tikinari ouihi me mɨne tikinari asori me səməme kɨno ia pras, mhakiətənɨmw irəha ia nui mə tuho həmher ia nəmri Kumwesən.) ");
INSERT INTO tnk_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Farisi me mɨne nahatən me səvəi Loa həres pen Iesu i mə, “Rəfo səim nərmama me həpwəh nesi penien nɨtətə səvəi kaha kupwən me? Hamani nari, mətə həpkukupwən mhə mhərkwerɨɡ.” ");
INSERT INTO tnk_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Fwe kupwən, Profet Aesea rɨməni atukwatukw kɨmiaha kəuətkəsuə me. Rəmwhen kɨmərai pen ia Nəkukuə Ikinan mə, ‘Nərmama me i kamhəɡnəɡɨni iou ia tərhunraha, mətə nətərɨɡien səvənraha rəmak isipwɨn tukw iou. ");
INSERT INTO tnk_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Irəha kamhəfwaki auər a miou. Nəpɨn kamhahatən nərmama, həni mə kamhahatən nəɡkiariien səiou, mətə rekəm. Kamhahatən a nəɡkiariien sə ruku pen tɨ nərmama.’ ");
INSERT INTO tnk_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kɨmiaha hiənəpwəh raka nəɡkiariien me səvəi Kumwesən, nənə təkwtəkwuni mɨne hiamesi pen a natuakəmien me səvəi nərmama.” ");
INSERT INTO tnk_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Iesu rarə mɨni pen mwi tɨ nirəha i mə, “Kɨmiaha hiəukurən amasan noien səvəi nərarkiien Loa səvəi Kumwesən mə tihesi pen narəien səkɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tihətərɨɡ ro tɨ Moses. Rɨməni mə, ‘Tikɨsiai səim tata mɨne səim mama.’ Rɨni mwi mə, ‘Trɨni mɨnuə iərmama riti rani ərəha səvənhi tata mɨne mama, tukaməkeikei kousi əpune in.’ ");
INSERT INTO tnk_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mətə kɨmiaha hiaməni mə, ‘Trɨni mɨnuə iərmama riti rɨni pen tɨ səvənhi tata mɨne mama mə, Səiou narimnari me sə trasitu ia kɨmirau ro korpan’ (uə səvəi Kumwesən), ");
INSERT INTO tnk_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ko rɨpkasitu mhə mwi ia səvənhi tata mɨne mama, muvei pen nari riti mɨnrau. Hiaməsisəɡ iərmama nəha. ");
INSERT INTO tnk_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nənə ia noien nəha hiamousi raka nəɡkiariien səvəi Kumwesən ia narəien səkɨmiaha kɨnahatən kɨmiaha irə. Narimnari me rɨpɨk hiamo iamɨnhi.” ");
INSERT INTO tnk_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Iesu rəkwein mwi nərmama me həuvehe. Rɨni pen tɨ nirəha i mə, “Kɨmiaha pam tihətərɨɡ amasan ia nirak, mhəukurən nəfe takɨni. ");
INSERT INTO tnk_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nari riti riwən iərmama rəni ko ro in ruvehe məmkemɨk ia nəmri Kumwesən. Mətə narimnari me səməme həuku pen ia rerɨn fwe imwə mamhəier irəha nə kamho in rəmkemɨk ia nəmri Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kɨmiaha nərmama nəkwəreɡɨmiaha rarə tɨ nɨreɡiien nari, tihətərɨɡ amasan.” ");
INSERT INTO tnk_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nəpɨn nəha Iesu rɨskəmter məpwəh nərmama me nəha, muvnimwə fwe ia nəkwai nimwə. Nənə nərmama me səvənhi kamhəres pen in mə trɨni nɨpwrai nusipekɨnien sə rɨməni. ");
INSERT INTO tnk_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nənə Iesu rɨni pen tɨ nirəha i mə, “Kɨmiaha mwi hiamreirei ihi? Hiəpkukurən mhə mə nəfe nəɡhɨn ruku pen fwe iruə muvnimwə ia iərmama ko rɨpko mhə in rəmkemɨk ia nəmri Kumwesən ");
INSERT INTO tnk_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","tɨ nəri nə mə rɨpkuvnimwə mhə ia rerɨn, mətə ramevən ia tɨpwɨn mamier.” (Ia nəɡkiariien nəha, Iesu rɨni irapw mə nəveɡɨnien me pam ramasan tɨ nəniien.) ");
INSERT INTO tnk_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Iesu rarə mɨni mwi mə, “Nari sə ruku pen ia reri iərmama fwe imwə mamier in nə ramo in rəmkemɨk ia nəmri Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Iakani iamɨnhi irə tɨ nəri nə mə nətərɨɡien ərəha ruku pen fwe imwə ia reri iərmama, mamier. Nərman mɨne nɨpran kamhəiri əpnapen irəha me, nakresien, nousi əpuneien iərmama, nakresien pran səvəi iərməpə, ");
INSERT INTO tnk_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","iərmama raməpwtɨɡ tɨ nautə səvənhi, nəmtɨhaien nari, neikuəien, noien sə ro naurɨsien, nəmwəkiien, nɨni ərəhaien iərmama, nəfiəutəien, narməriien. ");
INSERT INTO tnk_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Noien ərəha me i kamhəuku pen fwe imwə ia reri iərmama, mamhəier, mamho iərmama rəmkemɨk ia nəmri Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iesu rier məpwəh kwopun nəha, mevən ipaka tɨ taon nəha Taea. Revən mamarə ia nimwə riti, məpwəh nokeikeiien mə nərmama tuhəukurən in mə ramarə ia kwopun nəha. Mətə ko rɨpkərkwafə mhə tɨ nirəha. ");
INSERT INTO tnk_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Nənə pran riti fwe ikɨn, səvənhi prən ouihi nənɨmwɨn ərəha ramarə irə. Prən nəha rɨpko mhə prən Isrel, mətə rɨnətui fwe ia Fonisia ia tənə Siria. Nəpɨn rɨreɡi mə Iesu in ia kwopun nəha, ruvehe tukwe, mɨnɨmwi nukurhun mi ia nənimen, mamasək teɡɨn in mə, “Tikasitu ia nirak, məkoui irapw iəremhə ia səiou prən ouihi.” ");
INSERT INTO tnk_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Mɨreɡi Iesu rɨni pen tukwe in mə, “Pwəh nəkwərhakwərha həkupwən mhani nari tɨpwɨnraha rəsisi. Rəpwəh namasanien mə takuvehi nəveɡɨnien sənəi nəkwərhakwərha, mərarki pen i m kuri me.” ");
INSERT INTO tnk_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mɨreɡi prən nəha rɨni pen tukwe in mə, “Iərɨmənu, nɨpərhienien, mətə kuri me fwe ia ruei tepol, irəha mwi kamhani nɨmwəkmwəki nəveɡɨnien sənəi nəkwərhakwərha.” ");
INSERT INTO tnk_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Mɨreɡi Iesu rɨni pen tukwe in mə, “Tɨ nəri nə mə ikɨni iamɨnhi irə, ik tikrərɨɡ mamevən. Iəremhə ruvəier raka ia prən ouihi səim.” ");
INSERT INTO tnk_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nənə prən nəha rɨrərɨɡ pen fwe imwəni mətə səvənhi prən ouihi ramapri amasan ia nɨməhan səvənhi. Iəremhə naraka irə. ");
INSERT INTO tnk_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Iesu rəpwəh kwopun səvəi Taea mevən ia taon riti nəɡhɨn nə Saeton, məpwəh muvehe ia Tekapolis, kwopun taon ten ikɨn, məpi sɨmwɨn pehe ia nui asori Kalili. ");
INSERT INTO tnk_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ia kwopun nəha nərmama nepwɨn həuvehi iəpou riti sə rɨpkəɡkiari mhə nəkwəreɡɨn ruvisɨmw, mhəuvehi mhəuvehe tɨ Iesu, mhəres pen mə trəmrutə rəɡɨn irə. ");
INSERT INTO tnk_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nənə Iesu riri raka əpa iəpou nəha, rouevən isipwɨn tɨ nərmama, muvei pen nukwai rəɡɨn ia ruei nəkwəreɡi iəpou, mərɡavɨs pen ia rəɡɨn, mɨrapi nərami iəpou irə. ");
INSERT INTO tnk_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nənə məkwətə ia neiai, meiahaɡ əfi, mɨni pen tɨ iəpou i mə, “Efata!” Nɨpwrai nəɡkiariien nəha “Efata,” in i mə “Əkwaɡ!” ");
INSERT INTO tnk_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Iesu rɨni iamɨnhi irə mɨne nəkwəreɡi iəpou nəha rəkwaɡ. Rerɨn ruvehe raməɡkiari amasan. ");
INSERT INTO tnk_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Nənə Iesu rɨnise pen əknekɨn tɨ nirəha i mə tuhəpwəh nəvisauien nəfe in rɨno ia iəpou nəha. Mətə nəpɨn rɨnise əknekɨn irəha, həməha mhəni mwi. ");
INSERT INTO tnk_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nənimenraha rier pɨk tɨ Iesu. Həni mə, “Eh! Narimnari me i iəmə i ramo rɨrai raka pam! Nərmama səməme nəkwəreɡɨnraha ruvisɨmw, mɨne nərmama səməme həpkəɡkiari mhə, in ramomasan irəha.” ");
INSERT INTO tnk_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ia nəpɨn nəha nərmama həpɨk həuvehe mwi tɨ Iesu. Sənənraha nəveɡɨnien ruvəiwən. Iesu rəkwein nərmama me səvənhi həuvehe. Rɨni pen tɨ nirəha i mə, ");
INSERT INTO tnk_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Rerɨk rərkwəpɨr tɨ nərmama me i. Hənarə raka nəpɨn kahar kɨtaha mɨnraha nənə sənənraha nəveɡɨnien ruvəiwən. ");
INSERT INTO tnk_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Irəha nepwɨn həuku pen fwe isipwɨn. Trɨni mɨnuə həpkani mhə nari, iakərhi pen irəha fwe imwənraha, nəmrɨnraha trɨpitəv həmwei ia suatuk.” ");
INSERT INTO tnk_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Mɨreɡi nərmama me səvənhi həres pen mə, “Kɨtaha tsəfo irə mhəuvehi sənənraha bred? Samarə ia kwopun nəveɡɨnien riwən ikɨn.” ");
INSERT INTO tnk_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Mɨreɡi Iesu rəres pen irəha i mə, “Sənəmiaha bred kevə?” Mɨreɡi həni mə, “Sefen.” ");
INSERT INTO tnk_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Iesu rɨni nəkwan mə nərmama me nəha sənənraha nəveɡɨnien riwən tihəkure ia tɨprənə. Irəha həkure, nənə in ruvehi bred me nəha sefen, məfwaki mɨni vivi Kumwesən tukwe. Nəpɨn rəfwaki pam, maməkwsen bred me, mauvei pen m nərmama me səvənhi mə tuhəpeki pen m nərmama me. Nənə həpeki pen mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nərmama me səvənhi sənənraha kwopnəti nəmu me nepwɨn mwi fwe ikɨn. Iesu rəfwaki mɨni vivi Kumwesən tukwe. Məfwaki pam, mɨni pen tɨ nirəha i mə, “Nəmu me i mwi tihəpeki pen mɨnraha.” ");
INSERT INTO tnk_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nənə nərmama me pam hani nari tɨpwɨnraha rəsisi. Həvai pen nɨpərpəri bred mɨne nəmu me hənəpwəh ramrɨmər rukuər ia tənərɨpw sefen. ");
INSERT INTO tnk_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","10","Nərmama me nəha Iesu rəkwməni irəha ipaka fo-taosen. Nəpɨn Iesu rəkwməni pam irəha, rərhi pen irəha kamhəuvən imwənraha me. Kurirə irə rəputə ia nɨtətə ouihi irəha nərmama me səvənhi mamhəuvən fwe ia kwopun riti nəɡhɨn nə Talmanuta. ");
INSERT INTO tnk_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisi me həuvehe mamhəres Iesu mə, “Ko iko ro nɨmtətien riti sə ruku pen ia neiai pwəh iahətoni mhəukurən mə ik pərhien Kumwesən rərhi pehe ik?” ");
INSERT INTO tnk_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Iesu rɨreɡi, mɨreɡi rərəha fwe imwə ia rerɨn, mɨni mə, “Nɨmtətien əfo nəha nərmama ipwet mɨne kamhətui? Iakani nɨpərhienien tukumiaha i mə nərmama ipwet mɨne ro iamɨnhi Kumwesən trəpwəh nuvei penien nɨmtətien riti mɨnraha.” ");
INSERT INTO tnk_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ia nəpɨn nəha Iesu rəpwəh irəha, məputə ia nɨtətə ouihi irəha nərmama me səvənhi, mhəier, mamhəuvən ia nɨkare nui. ");
INSERT INTO tnk_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nərmama me səvəi Iesu hənenouenou mə tuhəuvehi bred. Sənənraha bred kuatia a ia nəkwai nɨtətə ouihi. ");
INSERT INTO tnk_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nənə Iesu rəvəhaɡ mɨnraha, mɨni mə, “Tihətui amasan, mamhəsiari tɨ yis səvəi Farisi me mɨne yis səvəi Kiɡ Herot.” ");
INSERT INTO tnk_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Mɨreɡi nərmama me səvənhi hənaməɡkiari mɨnraha me i mə, “Sənətaha bred riwən.” ");
INSERT INTO tnk_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Nəpɨn Iesu rɨreɡi, rɨni pen tɨ nirəha i mə, “Rəfo hiaməɡkiari m kɨmiaha me mə sənəmiaha bred riwən? Rosi hiəpkətə raka mhə ihi mhəreirei? Rosi kəmkapwəmiaha rɨskai? ");
INSERT INTO tnk_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nənimemiaha nə, mətə rəfo hiəpkətə mhə nari? Nəkwəreɡɨmiaha nə, mətə rəfo hiəpkreɡi mhə nari? Rosi rerɨmiaha rɨpkrhi mhə ");
INSERT INTO tnk_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","nəpɨn iakɨnəkwsen bred krirum məkwməni nərman faef-taosen irə? Ia nəpɨn nəha kɨmiaha hiəuvehi tənərɨpw kevə rukuər ia nɨpərpəri nəveɡɨnien hənəpwəh ramrɨmər?” Mɨreɡi həni pen tukwe in mə, “Twelef.” ");
INSERT INTO tnk_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nənə Iesu rəres pen mə, “Nəpɨn iakɨnəkwməni nərmama fo-taosen ia bred sefen, kɨmiaha hiəuvehi tənərɨpw kevə rukuər ia nɨpərpəri nəveɡɨnien hənəpwəh ramrɨmər?” Mɨreɡi həni pen tukwe in mə, “Sefen.” ");
INSERT INTO tnk_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nənə Iesu rəres pen irəha i mə, “Hiamreirei ihi?” ");
INSERT INTO tnk_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Irəha həuvehe ia taon nəha Petsaeta. Nərmama nepwɨn fwe ikɨn həiri iərman riti nənimen rɨfwə mhəuvehe tɨ Iesu, mhəres Iesu mə Iesu trəmrutə rəɡɨn irə. ");
INSERT INTO tnk_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nənə Iesu ruvehi rəɡɨn, miri in rouaraka ia rukwənu. Nənə Iesu rərɡəvəsi nənimen məmrutə rəɡɨn irə, məres in i mə, “Ikamətə nari?” ");
INSERT INTO tnk_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mɨreɡi iərmama nəha nənimen rɨfwə rəti ərari mɨni mə, “Iakamətə nərmama me, mətə iapkətə amasan mhə irəha. Iakamətə irəha həmwhen a ia nei me kamhavən.” ");
INSERT INTO tnk_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ro iamɨnhi irə Iesu rarə məmri pen mwi rəɡɨn ia nənimen. Iərmama nəha rəməha mətui. Nənə nənimen ruvehe mamasan mətə amasan narimnari. ");
INSERT INTO tnk_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nənə Iesu rərhi pen in, mɨni mə, “Tikevən atukwatukw fwe imwam, məpwəh nevənien fwe ia rukwənu nəha krɨməuku pen ikɨn.” ");
INSERT INTO tnk_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Iesu mɨne səvənhi nərmama me həuvən ia rukwənu me ia tənə riti nəɡhɨn nə Sisaria Filipae. Nəpɨn kamhəuvən ia suatuk, Iesu rəres pen səvənhi nərmama me i mə, “Nərmama kamhəni iou mə iou sin?” ");
INSERT INTO tnk_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Mɨreɡi həni pen tukwe in mə, “Nərmama nepwɨn kamhəni ik mə Jon Paptaes. Nepwɨn kamhəni ik mə Profet Elaeja. Nepwɨn mwi kamhəni ik mə profet kupwən riti səvəi Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nənə Iesu rəres pen irəha mə, “Mətə kɨmiaha hiaməni mə iou sin?” Mɨreɡi Pita rɨni mə, “Ik Kristo.” ");
INSERT INTO tnk_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nənə Iesu rɨnise pen tɨ nirəha i mə tuhəpwəh nɨniien tɨ iərmama riti mə in Kristo. ");
INSERT INTO tnk_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ia nəpɨn nəha rɨnamahatən irəha mə, “Iou, Iəməti Iərmama, takaməkeikei mɨreɡi rərəha ia narimnari me rɨpɨk. Nəmə asori me mɨne pris asori me mɨne nahatən me səvəi Loa, irəha tuhəpwəh iou, mhousi əpune iou. Takemhə, nənə, nəpɨn səro kahar irə iakətui mwi.” ");
INSERT INTO tnk_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iesu rɨni irapw nəɡkiariien nəha, ro nukurənien i. Mətə Pita riri raka Iesu ia nɨkarenraha, mɨnanise pen tukwe in mə, “Tikəpwəh nɨniien nəɡkiariien nəha ikani.” ");
INSERT INTO tnk_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Mətə Iesu ruvsini, mətoni nərmama me səvənhi kamhərer. Nənə rɨnise pen tɨ Pita i, mɨni mə, “Setan, evən ia təkutak! Nətərɨɡien səim rɨpkesi pen mhə nətərɨɡien səvəi Kumwesən, mətə ikamesi pen a nətərɨɡien səvəi nərmama.” ");
INSERT INTO tnk_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Iesu rəkwein nərmama me pam həuvehe irəha nərmama me səvənhi. In rɨni pen tɨ nirəha i mə, “Iərmama sə rokeikei mə truvehe mo iərmama riti səiou, traməkeikei məpwəh nətərɨɡien səvənhi, muvehi utə nei kamarkuaui səvənhi, məvrani mukurirə iou. ");
INSERT INTO tnk_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Iərmama sə rokeikei mə trəkwtəmhiri nɨmɨruien səvənhi trarfai irə. Mətə iərmama sə traraka ia nɨmɨruien səvənhi tukw iou mɨne nəɡkiariien amasan səiou truvehi nɨmɨruien rerɨn. ");
INSERT INTO tnk_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Trɨni mɨnuə iərmama riti rɨpeki pam narimnari me ia tɨprənə i, mo səvənhi i, nənə kurirə ikɨn remhə marfai ia nɨmɨruien rerɨn, noien nəha trəfasitu irə? ");
INSERT INTO tnk_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Iərmama truvei pen nəfe mərpwɨn tai nɨmɨruien səvənhi? ");
INSERT INTO tnk_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nərmama ipwet mɨne noien səvənraha rərəha. Irəha hənəpwəh Kumwesən rəmwhen ia pran riti sə rɨnəpwəh iərman səvənhi, mamesi pen iərman əpə mwi. Trɨni mɨnuə iərmama riti raurɨs ia nəmrɨnraha tɨ nɨniien mə in iərmama riti səiou, raurɨs mwi tɨ nəvisauien nəɡkiariien səiou mɨnraha, iou mwi Iəməti Iərmama, ia nəpɨn nəha takuvehe ia nɨskaiien səvəi tata səiou kɨmaha naɡelo ikinan me, takaurɨs tɨ nɨniien mə iərmama nəha in iərmama riti səiou.” ");
INSERT INTO tnk_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Iesu rɨni pen tɨ nirəha i mə, “Iakani nɨpərhienien tukumiaha i mə nərmama nepwɨn kamhərer ia kwopun i tuhəpkemhə mhə meste tuhətoni nɨskaiien səvəi Kumwesən rier pehe irau nɨtətə sə in ramərɨmənu irə.” ");
INSERT INTO tnk_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nəpɨn sikis rukurau, nənə Iesu riri əpa Pita mɨne Jemes mɨne Jon, həutə parei ia təkuər əpwəmwɨs riti. Ia kwopun nəha irəhar harətoni ia nənimenrahar nɨpwrai Iesu ruvehe mopə. ");
INSERT INTO tnk_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Səvənhi tɨnari ruvehe məpsan mamser pɨk. Iərmama sə ramaikuas tɨnari ia tɨprənə i ko rɨpkaikuas mhə rəpsan rəmwhen ia tɨnari səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nənə irəhar harətoni Profet Elaeja mɨne Moses krouier pehe, rouəɡkiari irəhar Iesu. ");
INSERT INTO tnk_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nənə Pita rɨni pen tɨ Iesu i mə, “Iahatən, ramasan mə kɨmrahar iaharuvehe i. Pwəh kɨmrahar iaharo tənimwə kahar, riti səim, riti səvəi Moses, riti səvəi Profet Elaeja.” ");
INSERT INTO tnk_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Pita rɨni iamɨnhi irə tɨ nəri nə mə irəhar harhekɨr pɨk. Rɨreirei mə trəfni irə.) ");
INSERT INTO tnk_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nənə nəpuə riti ruvehe muveɡi irəha. Nənə reri Kumwesən ruku pen ia nəpuə mɨni mə, “In nəha nərɨk keikei. Tihətərɨɡ in.” ");
INSERT INTO tnk_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Təkwtəkwuni a mwi, Pita, Jemes, mɨne Jon harəti ərari mharəpwəh nətoniien Moses mɨne Profet Elaeja, mətə Iesu əpa irəha min. ");
INSERT INTO tnk_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nəpɨn kamheiwaiu pehe ia təkuər, Iesu rɨnise pen tɨ nirəhar i mə, “Nəfe hiarɨnətoni kɨmirəhar tiharəpwəh nɨniien tɨ iərmama riti meste iou, Iəməti Iərmama, iakətui mwi ia nemhəien səiou.” ");
INSERT INTO tnk_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ro iamɨnhi irə mɨne harəpwəh nɨni irapwien nəfe harɨnətoni, mətə kamharəres irəhar me i mə, “Nəfe nɨpwrai nəɡkiariien nəha Iesu rɨməni pehe tukutahar i mə in trətui mwi ia nemhəien səvənhi?” ");
INSERT INTO tnk_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nənə irəhar harəres Iesu mə, “Rəfo nahatən me səvəi Loa kamhəni mə Profet Elaeja traməkeikei mukupwən muvehe?” ");
INSERT INTO tnk_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Mɨreɡi Iesu rɨni pen tɨ nirəhar i mə, “Nɨpərhienien, Profet Elaeja trukupwən muvehe məmri amasan pam narimnari me rəmwhen ia sə fwe kupwən. Mətə rəfo kɨmərai pen ia Nəkukuə Ikinan iamɨnhi irə mə iou, Iəməti Iərmama, takaməkeikei mɨreɡi rərəha ia narimnari me rɨpɨk? Tuho ia nirak rəmwhen ia iou iəmə rərəha riti. ");
INSERT INTO tnk_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mətə iou iakani pehe tukumiaha i mə Profet Elaeja ruvəuvehe raka. Nənə nərmama me hesi pen nətərɨɡien səvənraha mho rərəha irə rəmwhen ia Nəkukuə Ikinan rani.” ");
INSERT INTO tnk_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Iesu irəha Pita, Jemes, mɨne Jon hərərɨɡ pehe mwi tɨ nərmama me səvəi Iesu, mhətoni nərmama həpɨk kamhərer kurkurau ia nərmama me səvəi Iesu. Nahatən me səvəi Loa mɨne nərmama me kamhəvisə mɨnraha me. ");
INSERT INTO tnk_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nəpɨn nərmama me hətə Iesu, hərkərinari, mhaiu mhəuvən mhəɡkiari pen min. ");
INSERT INTO tnk_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nənə Iesu rəres pen irəha i mə, “Kɨmiaha nahatən me səvəi Loa hiaməɡkiari ia nəfe?” ");
INSERT INTO tnk_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mətə riti ia nərmama me nəha rɨni pen tukwe in mə, “Iahatən, iou iakuvehi səiou iəkunouihi muvehe tukw ik. Nənɨmwɨn ərəha riti ramarə irə, mamo rerɨn riwən ko rɨpkəɡkiari mhə. ");
INSERT INTO tnk_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kwopun pəku səiou iəkunouihi revən ikɨn, nəpɨn nənɨmwɨn ərəha ruvehi in, ruvehi mouini ia tɨprənə. Nɨsəkwan ramaiu ia tərhun. Ramahi revɨn. Nɨpwran rakɨnkɨn. Iakɨnəres raka nərmama me səim mə tuhəkoui irapw nənɨmwɨn ərəha nəha, mətə həni mə ko həpko mhə.” ");
INSERT INTO tnk_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Kɨmiaha nəkur ipwet mɨne səkɨmiaha nahatətəien riwən. Tsarə kɨtaha miou mesite nəfe nəpɨn? Tɨnesən mɨne iakapwɨs kɨmiaha? Kɨmiaha tihəuvən mhəuvehi iəkunouihi nəha mhəuvehi mhəuvehe.” ");
INSERT INTO tnk_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nənə irəha həuvən mhəuvehi in mhəuvehe tɨ Iesu. Nəpɨn nənɨmwɨn ərəha rətə Iesu, təkwtəkwuni a ro iəkunouihi rɨmwei ia tɨprənə, mərkərekɨr, məsəkwusəkwu. Nɨsəkwan ramaiu ia tərhun. ");
INSERT INTO tnk_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nənə Iesu rəres pen səvənhi tata i mə, “Iəkunouihi i ruvehi nemhəien i nuk kevə?” Mɨreɡi səvənhi tata rɨni mə, “Nemhəien i rɨməuvehi ia nouihiien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nəpɨn rɨpɨk nənɨmwɨn ərəha i ro iəkunouihi rɨmwei pen ia napw uə ia nui mə tremhə. Mətə mə ikukurən noien nari riti, tikapi tukumrau, masitu ia kɨmrau.” ");
INSERT INTO tnk_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Mɨreɡi Iesu rɨni pen tukwe in mə, “Rəfo ikɨni nəɡkiariien nəha mətə mə ikukurən noien? Trɨni mɨnuə iərmama riti rahatətə pərhien ia nirak, iakukurən noien narimnari me pam min.” ");
INSERT INTO tnk_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nənə təkwtəkwuni a mwi tata səvəi iəkunouihi nəha rasək əpwəmwɨs, mɨni mə, “Iakahatətə ia niram, mətə nahatətəien səiou rɨpkɨskai mhə. Tikasitu ia nirak!” ");
INSERT INTO tnk_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ia nəpɨn nəha nərmama həpɨk kamhaiu mamhəuvehe. Nəpɨn Iesu rətoni irəha, rɨnise pen tɨ nənɨmwɨn ərəha, mɨni mə, “Ik nənɨmwɨn ərəha sə ikamo iərmama tərhun ruvisɨmw mɨne nəkwəreɡɨn ruvisɨmw, iou iakani pehe tukw ik i mə tikier ia iəkunouihi i məpwəh nuvnimwə peheien mwi irə.” ");
INSERT INTO tnk_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nənə nənɨmwɨn ərəha rɨkiukiu pɨk ia iəkunouihi, məkwein əpwəmwɨs, mier. Mətə nɨpwrai iəkunouihi nəha ruvehe məpouəpou pam. Ro pen nərmama həpɨk həni mə, “Eh, ruvamhə!” ");
INSERT INTO tnk_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mətə Iesu ruvehi rəɡɨn, mɨvi utə, rərer. ");
INSERT INTO tnk_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kurirə irə Iesu revən muvnimwə ia nəkwai nimwə. Nəpɨn nərmama me səvənhi me irəha min əpa, həres pen in mə, “Rəfo kɨmaha iahəreirei nəkoui irapwien nənɨmwɨn ərəha nəha?” ");
INSERT INTO tnk_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Nənɨmwɨn ərəha sə ro me iamɨnha irə, nari riti riwən ko rəkoui irapw irəha, mətə nəfwakiien əpa.” ");
INSERT INTO tnk_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Irəha həpwəh kwopun nəha mhəuvən mhəpi sɨmwɨn ia tənə Kalili. Iesu rɨpkokeikei mhə mə nərmama tuhəukurən kwopun me nəha ramarə ikɨn, ");
INSERT INTO tnk_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","tɨ nəri nə mə ramahatən nərmama me səvənhi, mamɨni pen tɨ nirəha i mə, “Trɨpko mhə tui kuvei pen iou, Iəməti Iərmama, ia rəɡi nərmama. Irəha tuhousi əpune iou. Takemhə, nənə, nəpɨn səro kahar irə iakətui mwi ia nemhəien səiou.” ");
INSERT INTO tnk_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Mətə nərmama me səvənhi həreirei nɨpwrai nəɡkiariien i in rani. Həhekɨr tɨ nəresien in. ");
INSERT INTO tnk_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Irəha həuvehe ia Kapaneam. Nəpɨn həuvnimwə ia nəkwai nimwə riti, Iesu rəres pen nərmama me səvənhi mə, “Saməuvehe kɨmiaha hiaməɡkiari ia nəfe?” ");
INSERT INTO tnk_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mətə irəha həpwəh nəɡkiariien, tɨ nəri nə mə kamhəuvehe mamhəɡkiari mə sin ia nirəha in rasori. ");
INSERT INTO tnk_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nənə Iesu rəkure, məkwein nərmama səvənhi twelef həuvehe. Rɨni pen tɨ nirəha i mə, “Iərmama sə rokeikei mə trakupwən ia nərmama me pam, traməkeikei muvehe mukurirə, mamo in iərmama sə ramo tukwini nari m nərmama me pam.” ");
INSERT INTO tnk_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nənə Iesu ruvehi iəkunouihi riti mərpwi ia kurkwan ia nirəha, mərəhi utə, marə mɨni pen mwi tɨ nirəha i mə, ");
INSERT INTO tnk_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Iərmama sə trəsevər ia rerɨn tɨ iəkunouihi riti sə ro iamɨnhi ia nəɡhɨk rəmwhen mə raməsevər mwi ia rerɨn tukwe iou. Iərmama sə raməsevər ia rerɨn tukw iou rəmwhen mə raməsevər mwi ia rerɨn tɨ Kumwesən sə rɨnərhi pehe iou iakuvehe.” ");
INSERT INTO tnk_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon rɨni pen tɨ Iesu i mə, “Iahatən, kɨmaha iahətoni iərmama riti raməkoui irapw nəremhə me ia nəɡhɨm. Iahaməmwur mə tahənise in tɨ nəri nə mə rɨpko mhə in kɨmaha riti.” ");
INSERT INTO tnk_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Mətə Iesu rɨni mə, “Kɨmiaha tihəpwəh nɨniseien in. Iərmama sə ramo nɨmtətien ia nəɡhɨk, ko rəpwəh nɨni ərəha akwauakwien iou. ");
INSERT INTO tnk_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Iərmama sə rəpwəh nɨni ərəhaien kɨtaha in kɨtaha riti. ");
INSERT INTO tnk_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Iakani nɨpərhienien tukumiaha i. Kɨmiaha nə nərmama me səiou, iou Kristo. Trɨni mɨnuə iərmama riti ruvei pehe nui m kɨmiaha ia nəɡhɨk mə tihənɨmwi, in traməkeikei muvehi nərəkuien səvənhi.” ");
INSERT INTO tnk_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Nəkwərhakwərha me i səməme kamhahatətə ia nirak, trɨni mɨnuə iərmama riti ro riti rɨmwei ia nərəhaien, Kumwesən trərpwɨn noien ərəha səvənhi. Iərmama nəha trɨreɡi rərəha məpi raka kərihi pen kəruəterei asori ia nɨpətəkinuan kosə irapw i ia təmwei təsi. ");
INSERT INTO tnk_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mə rəɡɨm ramo ikamwei ia nərəhaien, tikərai raka. Mə rəɡɨm rɨpɨp mətə ikuvehi nɨmɨruien, ramasan pɨk tukw ik. Rərəha mə rəɡɨm kəru mətə tikevən fwe ia kwopun napw asori rauək rerɨn ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","45","Mə nɨsum ramo ikamwei ia nərəhaien, tikərai raka. Mə nɨsum rɨpɨp mətə ikuvehi nɨmɨruien, ramasan pɨk tukw ik. Rərəha mə nɨsum mi kəru mətə tukərarki pen ik ia kwopun napw asori rauək rerɨn ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","47","Mə nənimem ramo ikamwei ia nərəhaien, tikukumwiri raka. Mə nənimem kuatia a mətə ikuvnimwə pen ia nɨtətə sə Kumwesən ramərɨmənu irə, ramasan pɨk tukw ik. Rərəha mə nənimem kəru, mətə tukərarki pen ik ia kwopun napw asori rauək ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ia kwopun nəha ‘irər səməme hamani irəha həpwəh nemhəien. Napw rəpwəh nɨfwəien.’ ");
INSERT INTO tnk_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Napw trətəɡətəɡ pen ia nərmama me pam rəmwhen ia sol sə kamətəɡi pen ia nəveɡɨnien. ");
INSERT INTO tnk_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sol in nari amasan. Mətə trɨni mɨnuə sol nəsienien səvənhi ruvəiwən, tihəfo mho rəsien mwi? Pwəh sol raməmak pen ia rerɨmiaha. Nənə hiamarə ia nəmərinuien.” ");
INSERT INTO tnk_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iesu rəpwəh kwopun nəha mevən ia tənə Jutia fwe ia nɨkare nui arɨs Jotan pen. Nərmama həpɨk həuvehe mwi mhousəsɨmwɨn pen irəha me tukwe. In rahatən irəha rosi sə ramo ia nəpɨn me. ");
INSERT INTO tnk_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nənə Farisi me nepwɨn həuvehe mhəres pen nari riti min mə tuhəreɡi ro Iesu mə trəfni irə. Irəha həni mə, “Ratukwatukw ia Loa səkɨtaha mə ko iərman riti rəpwəh səvənhi pran uə rekəm?” ");
INSERT INTO tnk_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Mɨreɡi Iesu rəres pen irəha i mə, “Nəfe nəɡkiariien Moses rɨməni pehe tukumiaha i fwe kupwən?” ");
INSERT INTO tnk_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Mɨreɡi həni mə “Moses rɨnəseni mə iərman riti rukurən nɨraiien nɨmwai nəkukuə m pran səvənhi rani mə in rɨnəpwəh in, nənə mərhi pen i ramevən.” ");
INSERT INTO tnk_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Mətə Iesu rɨni pen tɨ nirəha i mə, “Moses rɨmərai nəɡkiariien nəha m kɨmiaha tɨ nəri nə mə kəmkapwəmiaha rɨskai. ");
INSERT INTO tnk_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Mətə Nəkukuə Ikinan rɨni mə fwe ia nukune narəien, ‘Kumwesən rɨno iərmama kəru riti iərman riti pran.’ ");
INSERT INTO tnk_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Ro iamɨnhi irə iərman traraka ia tata mɨne mama səvənhi mevən rouarə pəri irau pran səvənhi, nənə ");
INSERT INTO tnk_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","irau trouvehe rouəmwhen ia nɨpwrai iərmama kuatia.’ Nəɡkiariien nəha rɨni mə iərman mɨne pran səvənhi krouəpwəh ihi noien iərmama kəru i, mətə krouvəuvehe rouəmwhen ia nɨpwrai iərmama kuatia. ");
INSERT INTO tnk_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tɨ nəri nə mə Kumwesən rɨrɨpɨn iərman mɨne pran səvənhi iamɨnhi irə, ro pen rɨpkatukwatukw mhə mə iərman trəpwəh səvənhi pran, mətefi narəien səvənrau.” ");
INSERT INTO tnk_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nəpɨn Iesu mɨne nərmama me səvənhi həuvnimwə mwi ia nəkwai nimwə, irəha həres mwi nəɡkiariien i min. ");
INSERT INTO tnk_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nənə Iesu rɨni pen tɨ nirəha i mə, “Iərman sə rəpwəh pran səvənhi miri prən əpə riti mwi ramo noien ərəha ia səvənhi pran. Prən nəha in ramiri rɨpko mhə pran atukwatukw səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Rəmwhen a mwi pran sə rəpwəh səvənhi iərman mesi pen iərman əpə riti mwi ramo noien ərəha ia səvənhi iərman. Iərman nəha in ramesi pen rɨpko mhə iərman atukwatukw səvənhi.” ");
INSERT INTO tnk_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nəpɨn riti nərmama me kamhəuvehi nəkwərhakwərha me səvənraha, mamhəuvehe tɨ Iesu mə trapi irəha. Nənə nərmama me səvəi Iesu hənise irəha. ");
INSERT INTO tnk_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mətə nəpɨn Iesu rətoni, niemaha rəpi. In rɨni pen tɨ nirəha i mə, “Pwəh nəkwərhakwərha me həuvehe tukw iou. Tihəpwəh nɨniseien irəha. Nɨtətə sə Kumwesən ramərɨmənu irə səvəi nərmama səməme həmwhen ia nəkwərhakwərha me i. ");
INSERT INTO tnk_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Iakani nɨpərhienien tukumiaha i mə iərmama traməkeikei mo rəmwhen ia iəkunouihi, muvehi nɨtətə sə Kumwesən ramərɨmənu irə. Mə rɨpko mhə trɨpkuvnimwə mhə ia nɨtətə nəha ia nəpɨn riti.” ");
INSERT INTO tnk_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nənə Iesu rərəhi pehe nəkwərhakwərha me, məmrutə rəɡɨn mi ia nirəha, məkwein amasan ia nirəha. ");
INSERT INTO tnk_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Iesu rɨnamesi pen mwi suatuk səvənhi mamevən. Nənə iərmama riti raiu muvehe mɨnɨmwi nukurhun mi ia nənimen, məres pen in i mə, “Iahatən, ik iəmə amasan. Nəfe noien takaməkeikei mo mə takuvehi nɨmɨruien rerɨn?” ");
INSERT INTO tnk_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Mɨreɡi Iesu rɨni pen tukwe in mə, “Rəfo ikɨni mə iou iəmə amasan? Iərmama amasan riti riwən. Kumwesən əpa in ramasan. ");
INSERT INTO tnk_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ik ikuvəukurən raka loa me səvəi Kumwesən. In rɨni mə, ‘Tikəpwəh nousi əpuneien iərmama, məpwəh nakresien pran, məpwəh nakresien, məpwəh neikuəien, məpwəh neikuəien mə tikakres. Tikaməkeikei mɨsiai səim tata mɨne mama.’” ");
INSERT INTO tnk_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mɨreɡi iərmama nəha rɨni pen tɨ Iesu i mə, “Iahatən, loa me pam i iakesi pen fwe ia nouihiien səiou meste pehe ipwet mɨne.” ");
INSERT INTO tnk_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iesu rətə iərmama nəha, rerɨn rokeikei in. Ro iamɨnhi irə rɨni pen tukwe in mə, “Nari kuatia rarə ikəpwəh ihi noien. Evən, məmri pen nəmri nari ia səim narimnari me. Nəpɨn kuvehi nənimen, tikuvehi mane, muvei pen m nərmama nautə səvənraha riwən. Nənə səim nautə trɨpɨk fwe ia neiai. Nəpɨn ikɨno pam, ikuvehe mukurirə iou.” ");
INSERT INTO tnk_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nəpɨn iərmama nəha rɨreɡi nəɡkiariien nəha, nənimen rɨsiu. Rəpwəh Iesu mamevən. Rerɨn rəpou tɨ nəri nə mə nautə səvənhi rasori. ");
INSERT INTO tnk_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ia nəpɨn nəha Iesu rəti ərari mətoni nərmama me səvənhi, mɨni pen tɨ nirəha i mə, “Rəknekɨn tɨ nərmama nautə səvənraha rasori mə tuhəuvnimwə ia nɨtətə sə Kumwesən ramərɨmənu irə.” ");
INSERT INTO tnk_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nərmama me səvəi Iesu hərkəri asori nari ia nəɡkiariien səvənhi. Mətə Iesu rɨni pen mwi tɨ nirəha i mə, “Nəkwərhakwərha səiou me, rəknekɨn tɨ nuvnimwəien ia nɨtətə sə Kumwesən ramərɨmənu irə. ");
INSERT INTO tnk_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Iərmama nautə səvənhi rasori rəknekɨn tukwe in mə truvnimwə ia nɨtətə sə Kumwesən ramərɨmənu irə. Rəknekɨn məpi raka nərimɨru nəha kamel rasu pen ia ruei nitel mier.” ");
INSERT INTO tnk_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nəpɨn nərmama me səvəi Iesu həreɡi nəɡkiariien səvənhi, nənimenraha rier. Kamhəres irəha me i mə, “Mə rəknekɨn iamɨnhi, nɨsɨmə nəha ko həuvehi nɨmɨruien?” ");
INSERT INTO tnk_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iesu rətə irəha mɨni mə, “Nəri nəha rəknekɨn iərmama ko rɨpko mhə, mətə Kumwesən rukurən noien. Narimnari me pam rɨməru tɨ Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ia nəpɨn nəha Pita rɨskəmter mɨni pen tɨ Iesu i mə, “Ətə ro. Kɨmaha iahənəpwəh pam narimnari me səkɨmaha mamhəkurirə ik.” ");
INSERT INTO tnk_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Mɨreɡi Iesu rɨni mə, “Iakani nɨpərhienien tukumiaha i mə nərmama me səməme hənəpwəh narimnari me səvənraha tukwe iou mə tuhəuvən mhəvisau irapw nəɡkiariien amasan səiou, irəha pam tuhəuvehi tain. Trɨni mɨnuə iərmama riti rəpwəh nimwə me, uə piəvni me, uə kɨtiriməni me, uə mama mɨne tata səvənhi, uə nəkwərhakwərha me səvənhi, uə tɨprənə səvənhi, ");
INSERT INTO tnk_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ia nɨtətə ipwet mɨne truvehi mwi tain hantret, nimwə me, mɨne piəvni me, mɨne kɨtiriməni me, mɨne mama me, mɨne nəkwərhakwərha me, mɨne tɨprənə. Tukəmwəki mwi in, ko nəmisəien min tɨ nəɡkiariien amasan səiou. Nənə ia nɨtətə fwe truvehe in truvehi nɨmɨruien rerɨn. ");
INSERT INTO tnk_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mətə nərmama həpɨk səməme kamhəkupwən tuhəkurirə. Nənə səməme kamhəkurirə tuhəkupwən.” ");
INSERT INTO tnk_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Irəha kamhesi pen suatuk mamhəutə pen fwe ia Jerusalem. Iesu rakupwən irəha kamhəkurirə. Səvənhi nərmama me hərkərinari. Nərmama səməme kamhəkurirə ia nirəha kamhəhekɨr. Iesu riri raka əpa nərmama səvənhi twelef mɨnani pen tɨ nirəha i nəfe tuho irə, ");
INSERT INTO tnk_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","mɨni mə, “Hətə ro, kɨtaha saməutə mamhəuvən fwe ia Jerusalem. Ia kwopun nəha tukuvei pen iou, Iəməti Iərmama, ia rəɡi pris asori me mɨne nahatən me səvəi Loa. Irəha tuhəni mə takaməkeikei memhə. Tuhəuvei pen iou ia rəɡi nərməpə rɨpko mhə irəha nəkur Isrel. ");
INSERT INTO tnk_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Irəha tuharɨs əkenhɨn ia nirak, mhərɡəvəsi iou, mhərisi iou, mhousi əpune iou. Ia nəpɨn sə ro kahar irə takətui mwi ia nemhəien səiou.” ");
INSERT INTO tnk_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jemes mɨne Jon, tɨni Sepeti mi, irau krouvehe tɨ Iesu rouni pen tukwe in mə, “Iahatən, kɨmrau tarouəres ik ia nari riti. Iarouokeikei mə tikəseni kɨmrau.” ");
INSERT INTO tnk_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Mɨreɡi Iesu rɨni mə, “Nəfe irouokeikei mə tako m kɨmirau?” ");
INSERT INTO tnk_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Mɨreɡi krouni mə, “Əseni kɨmrau pwəh riti rəkure ia nɨkarem mwatuk riti ia nɨkarem mour nəpɨn tikuvehi nasoriien səim, mamərɨmənu ia nərmama.” ");
INSERT INTO tnk_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Mətə Iesu rɨni pen tɨ nirau i mə, “Kɨmirau iroureirei nəfe nari irouəres i. Ko kɨmirau irouənɨmwi kap i iou takənɨmwi? Uə ko kakiətənɨmw mwi kɨmirau ia paptaes i sə tukakiətənɨmw iou irə?” ");
INSERT INTO tnk_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Mɨreɡi krouni mə, “Kɨmrau iarouəmwhen.” Mɨreɡi Iesu rɨni pen tɨ nirau i mə, “Kap i iou takənɨmwi, kɨmirau mwi tirouənɨmwi. Tukakiətənɨmw kɨmirau mwi ia paptaes i tukakiətənɨmw iou irə. ");
INSERT INTO tnk_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mətə iou ko iakəpwəh nəseniien kɨmirau irouəkure riti ia nɨkarek mwatuk riti ia nɨkarek mour. Mətə kwopun nəha səvəi iərmama mi nəha kɨmərfi raka irau mə trouəkure fwe ikɨn.” ");
INSERT INTO tnk_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nəpɨn ten mwi nərmama me səvəi Iesu həreɡi nəresien nəha səvəi Jemes mɨne Jon, niemaha rəpi irəha. ");
INSERT INTO tnk_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ro iamɨnhi irə Iesu rəkwein irəha həuvehe. Rɨni pen tɨ nirəha i mə, “Kɨmiaha hiəuvəukurən raka noien səvəi nərmama rɨpko mhə irəha nəkur Isrel. Nəmə asori me səvənraha sə kamhərɨmənu ia nirəha, kamhəfiəutə irəha, mamho nərmama kamho nəkwanraha. ");
INSERT INTO tnk_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mətə kɨmiaha tihəpwəh noien iamɨnha irə ia kɨmiaha me. Trɨni mɨnuə kɨmiaha riti rokeikei mə truvehe masori ia kɨmiaha, in traməkeikei muvehe mo iərmama sə ramo tukwini nari m kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Trɨni mɨnuə kɨmiaha riti rokeikei mə trasori makupwən ia kɨmiaha, in traməkeikei muvehe mo iərmama sə ramo auər a wok səkɨmiaha pam. ");
INSERT INTO tnk_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kɨmiaha tiho rəmwhen a ia nirak. Iou, Iəməti Iərmama, iapkuvehe mhə mə nərmama tuho tukwini nari miou, mətə iakuvehe mə tako tukwini nari mɨnraha, muvei pen nɨmɨruien səiou trərəku suatuk tɨ nɨfi rakaien nari ia nərmama həpɨk.” ");
INSERT INTO tnk_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Iesu mɨne nərmama me səvənhi həuvehe mhapirapw ia taon nəha Jeriko. Nəpɨn həier, nərmama həpɨk kamhəkurirə in. Partimeas, tɨni Timeas, raməkure ia nɨkare suatuk mamase mane m nərmama. Partimeas nənimen rɨfwə. ");
INSERT INTO tnk_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nəpɨn rɨreɡi mə Iesu iəmə Nasaret rɨnauvehe, rɨnaməkwein əpwəmwɨs, mɨnamɨni mə, “Iesu, kwənəkwus səvəi Kiɡ Tevɨt! Api tukw iou!” ");
INSERT INTO tnk_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nərmama həpɨk hənise pen tukwe in, mhəni mə, “Afafa, məpwəh nəɡkiariien!” Mətə Partimeas rarɨpɨn maməkwein əpwəmwɨs mwi, mamɨni mə, “Iesu, kwənəkwus səvəi Kiɡ Tevɨt! Api tukw iou!” ");
INSERT INTO tnk_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ia nəpɨn nəha Iesu rərer, mɨni pen tɨ nirəha i mə, “Həkwein iərmama nəha ruvehe.” Irəha həkwein iərmama sə nənimen rɨfwə, mhəni pen tukwe in mə, “Aɡien, mɨskəmter! Iesu raməkwein ik mə tikevən tukwe.” ");
INSERT INTO tnk_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nənə iərmama nəha nənimen rɨfwə ruvehi raka səvənhi karkahu əpwəmwɨs məpwəh, mɨskəmter akwauakw, mevən tɨ Iesu. ");
INSERT INTO tnk_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nənə Iesu rɨni pen tukwe in mə, “Ikokeikei mə tako nəfe mik?” Mɨreɡi iərmama nəha nənimen rɨfwə rɨni pen tukwe in mə, “Iahatən, iakokeikei mə nənimek trətui pwəh iakətə nari.” ");
INSERT INTO tnk_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Mɨreɡi Iesu rɨni pen tukwe in mə, “Ramasan. Ikukurən nevənien. Nahatətəien səim rɨnomasan raka nənimem.” Nənə təkwtəkwuni nəha nənimen rɨnamasan mɨnətə nari. Nənə Iesu ramesi suatuk mamevən, iərmama nəha rukurirə i. ");
INSERT INTO tnk_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Irəha həuvən ipaka tɨ Jerusalem, mhəier pen ia Təkuər Olif ia kwopun nəha ipaka tɨ rukwənu mi nəha Petfas mɨne Petani. Ia nəpɨn nəha Iesu rərhi pen iərmama kəru səvənhi, ");
INSERT INTO tnk_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","mɨni pen tɨ nirau i mə, “Kɨmirau tirouevən fwe ia rukwənu nəha samarəti pen i. Nəpɨn tirouapirapw fwe ikɨn, tirouətə kwəti toɡki riti kɨnəkwi tərini, iərmama rɨpkəkure raka mhə irə. Tiroufi raka nari irə, rouəsɨɡi rouvehe. ");
INSERT INTO tnk_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Trɨni mɨnuə iərmama riti rəres kɨmirau i mə, ‘Rəfo iroufi raka nari ia kwəti toɡki?’ tirouni pen mə, ‘Iərɨmənu səkɨtaha raməres kwəti toɡki i, mətə trɨpkəpwəmwɨs mhə trərhi pehe mwi i.’” ");
INSERT INTO tnk_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ia nəpɨn nəha krauevən rouətoni kwəti toɡki nəha kɨnəkwi tərini pen ipaka tɨ kwəruə ia nimwə riti ramərer ia suatuk. Nəpɨn kroufi raka nari irə, ");
INSERT INTO tnk_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","nərmama nepwɨn səməme kamhərer ipaka tɨ nirau ia kwopun nəha həni mə, “Rəfo iroufi raka nari ia kwəti toɡki?” ");
INSERT INTO tnk_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Mətə krouni pen nəfe Iesu rɨməni pen tɨ nirau i. Nəpɨn nərmama me nəha həreɡi, həseni irau krouevən. ");
INSERT INTO tnk_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Irau krouəsɨɡi kwəti toɡki nəha rouvehe tɨ Iesu, rouəpənə pen karkahu əpwəmwɨs mi səvənrau ia təkuren. Nənə Iesu rəkure irə. ");
INSERT INTO tnk_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nərmama həpɨk həpənə karkahu əpwəmwɨs me səvənraha ia suatuk. Nərmama nepwɨn mwi həpənə pen nɨmwai nei me sə hənərai ia nɨmei nari. ");
INSERT INTO tnk_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nərmama səməme kamhəkupwən mɨne səməme kamhəkurirə ia Iesu, kamhəkwein əpwəmwɨs, mamhəni mə, “Səɡnəɡɨni Kumwesən! Səkwein amasan ia iərmama i rauvehe ia nəɡhi Iərɨmənu səkɨtaha! ");
INSERT INTO tnk_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Səkwein amasan ia kiɡ i rauvehe mə truvehi təmwheki kaha səkɨtaha Kiɡ Tevɨt mərɨmənu ia kɨtaha! Kəɡnəɡɨni Kumwesən ia neiai irənhə anan!” ");
INSERT INTO tnk_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nənə Iesu ruvnimwə ia Jerusalem, mevən ia nimwə səvəi Kumwesən, maməspau narimnari me fwe ikɨn. Mətə raməruarəv ro pen Iesu rəpwəh mɨrərɨɡ mevən fwe ia Petani irəha twelef nərmama me səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Rakwakwi irə irəha həier ia Petani. Iesu rɨreɡi nukumhə rɨnahi. ");
INSERT INTO tnk_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Rəti pen mətoni niemɨs riti ramərer. Nɨmwan rɨpɨk. Iesu revən mə trətə mə nukwan fwe ikɨn uə riwən. Revən ipaka tukwe, mətə nɨmwan me a. Nukwan riwən tɨ nəri nə mə rɨpko mhə nəpɨn atukwatukw sə nei nəha trukuə irə. ");
INSERT INTO tnk_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ro iamɨnhi irə Iesu rɨni pen tɨ nei nəha mə, “Iərmama riti trəpwəh mwi nəniien nukwam ia nəpɨn riti.” Nəpɨn Iesu rɨni nəɡkiariien nəha, nərmama me səvənhi həreɡi. ");
INSERT INTO tnk_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Iesu mɨne nərmama me səvənhi həier pehe ia Jerusalem. Nənə Iesu revən ia nimwə səvəi Kumwesən, mɨnaməkoui irapw nərmama me səməme kamhəmri pen nəmri nari ia narimnari me mɨne səməme kamhəuvehi nəmri narimnari me. Rəvsini tepol me səvəi nərmama me kamhəvriwei mane me. Rəvsini jea me səvəi nərmama səməme kauvehi nəmri menu me tɨ nirəha, ");
INSERT INTO tnk_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","mɨnise pen tɨ nərmama mə tuhəpwəh nuvehiien narimnari me mhəpi sɨmwɨn ia kwopun nəha nimwə səvəi Kumwesən ramərer ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nənə Iesu rɨnamahatən irəha mə, “Kɨmərai pen ia Nəkukuə Ikinan mə, ‘Tukani nimwə səiou mə nimwəfwaki səvəi nərmama me ia tənəmtənə me.’ Mətə kɨmiaha hiəno ruvəuvehe kwopun sə rakres me kamhərkwafə ikɨn.” ");
INSERT INTO tnk_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nəpɨn pris asori me mɨne nahatən me səvəi Loa həreɡi nəɡkiariien səvəi Iesu, kənamhətui suatuk mə tuhousi əpune. Irəha kamhəhekɨr Iesu tɨ nəri nə mə nərmama me pam nənimenraha rier tɨ nahatənien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nənə nəruarəv irə Iesu mɨne nərmama me səvənhi haraka ia Jerusalem, mamhəuvən. ");
INSERT INTO tnk_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Rakwakwi irə ia nəpnəpɨn irəha həukurau ia kwopun niemɨs ramərer ikɨn, mhətə mə nei nəha ruvəmhiə fwe irənhə meste nuan me inhərɨpw. ");
INSERT INTO tnk_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nənə Pita rerɨn rɨrhi nəɡkiariien səvəi Iesu. Rɨni pen tukwe in mə, “Iahatən, ətə ro nei nəha ikɨnəkwein ərəha irə, ruvehe muvɨmhiə pam.” ");
INSERT INTO tnk_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Tihahatətə ia Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Iakani nɨpərhienien tukumiaha i trɨni mɨnuə iərmama riti rɨni pen tɨ təkuər i mə, ‘Təkuər i, tiko mier mivə pen fwe ia təsi,’ mə nətərɨɡien səvəi iərmama nəha rəpwəh nəmkiəmkiien, mətə rahatətə əknekɨn ia nəfe rɨməni mə tro, Kumwesən tro nəkwan. ");
INSERT INTO tnk_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ro iamɨnhi irə iakani nɨpərhienien tukumiaha i mə nəpɨn tihəfwaki, nəfe nəɡhɨn tihəres i, tihahatətə mə hiəuvəuvehi raka, nənə Kumwesən truvei pehe m kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Nənə nəpɨn tihərer mhəfwaki, trɨni mɨnuə iərmama riti rɨno noien ərəha ia kɨmiaha, tihenouenou i. Tiho iamɨnhi irə mə Tata səkɨmiaha ia neiai in mwi trenouenou noien ərəha me səkɨmiaha.” ");
INSERT INTO tnk_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Irəha həuvehe mwi ia Jerusalem. Nəpɨn Iesu ramavən ia kwopun nimwə səvəi Kumwesən ramərer ikɨn, pris asori me mɨne nahatən me səvəi Loa mɨne nəmə asori me səvəi nəkur Isrel həuvehe tukwe, ");
INSERT INTO tnk_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","mhəres pen in mə, “Ikamo narimnari me i ia nəkwai sin, uə sin rəseni ik mə tiko narimnari me i?” ");
INSERT INTO tnk_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Iou mwi takəres kɨmiaha nəresien riti. Trɨni mɨnuə hiəni atukwatukw tukw iou i, takɨni pehe tukumiaha i mə iakamo narimnari me i ia nəkwai sin. ");
INSERT INTO tnk_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Tiho mhəni ro tukw iou i mə fwe kupwən, sin rərhi pehe Jon mə tro paptaes ia nərmama, Kumwesən uə iərmama riti?” ");
INSERT INTO tnk_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nənə irəha həɡkiari pəri, mamhəni mə, “Tsəfni irə i? Tuko səni mə Kumwesən rərhi pehe Jon mə tro paptaes ia nərmama, Iesu trɨni pehe mə, ‘Ro iamɨnhi irə rəfo hiəpwəh nɨniien nɨpərhienien ia nəɡkiariien səvəi Jon?’ ");
INSERT INTO tnk_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mətə ko səni mə iərmama riti rərhi pehe Jon uə?” Mətə irəha həhekɨr tɨ nɨniien iamɨnha irə tɨ nəri nə mə nərmama me hahatətə ia Jon mə in profet pərhien riti. ");
INSERT INTO tnk_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ro pen həni pen tɨ Iesu i mə, “Kɨmaha iahəreirei.” Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Iou mwi ko iakəpwəh nɨniien tukumiaha i mə iakamo narimnari me i ia nəkwai sin.” ");
INSERT INTO tnk_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ia nəpɨn nəha Iesu rɨnaməɡkiari mɨnraha mɨnani nusipekɨnien me, mɨnani mə, “Iəmə asori riti rəpwei nəkwus nəha krep ia nəmhien səvənhi, mukurei pen nəpai rukurau kurau irə, muəsi kəpwier mo nəkwan sə tukeivə testesi tɨpwei krep ikɨn tɨ nuvehiien nɨsen, mo mwi nəpai rəpwəmwɨs mutə tukətui tɨ krep ikɨn. Nəpɨn ro sampam irə, rəseni nərmama nepwɨn həuvehe mhətui tɨ nɨmei krep səvənhi. Irəha tuhəmhu ikɨn, mhesi kwənkwai krep, mhəuai, mhəuvei pen nɨpərɨn m iəmə asori. Iəmə asori rəmri pen nɨmei krep səvənhi ia rəɡɨnraha, mier mevən ia tənə əpə iti. ");
INSERT INTO tnk_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nəpɨn kwənkwai krep rɨmruə, iəmə asori rərhi pen iərmama riti sə ramo tukwini nari min revən mətə nəmə kamhətui tɨ nɨmei krep səvənhi. In rokeikei mə tuhəuvei pen kwənkwai krep nepwɨn səpwəni min. ");
INSERT INTO tnk_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mətə irəha həkwtəmhiri iəmə nəha, mhousi, mhərhi pen i ramevən, mhəpwəh nuvei penien nari riti min. ");
INSERT INTO tnk_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Iəmə asori rərari, mərhi pen iərmama riti mwi sə ramo tukwini nari min revən. Nənə irəha housi kənkapwə, mho naurɨsien min. ");
INSERT INTO tnk_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Iəmə asori rərari mərhi pen riti mwi revən. Nənə irəha housi əpune. Irəha ho noien nəha ia nepwɨn mwi həpɨk. Həuəsi nepwɨn, mhousi əpune nepwɨn. ");
INSERT INTO tnk_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nənə nərmama me nəha kamho tukwini nari m iəmə asori həuvəiwən pam, mətə tɨni anan kuatia sə rokeikei pɨk. Iəmə asori rərhi pen i tɨ nəmə kamhətui tɨ krep, mɨni mə, ‘Irəha tuhəsiai nərɨk.’ ");
INSERT INTO tnk_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mətə nəpɨn nəmə kamhətui tɨ krep hətoni tɨni iəmə asori, həni pen tɨ nirəha me i mə, ‘Kwa tɨni iəmə asori nəha. Nəpɨn tata səvənhi tremhə, nɨmei krep i ruvehe mo səvənhi. Pwəh sousi əpune nənə nɨmei krep səvənhi truvehe mo səkɨtaha i.’ ");
INSERT INTO tnk_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nənə irəha həkwtəmhiri, mhousi əpune, mhərarki irapw ia taniruə. ");
INSERT INTO tnk_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Iəmə asori səvəi nɨmei krep, trəfo nəha? Truvehe mousi əpune nəmə me nəha məseni pen nɨmei krep səvənhi ia rəɡi nərməpə. ");
INSERT INTO tnk_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Rosi kɨmiaha hiəpkəvsini raka mhə nəɡkiariien i ia Nəkukuə Ikinan uə? ‘Kəruəterei nəha nəmə kamhəuvrhəkɨn nimwə hənuə rərəha, mhəpwəh, təkwtəkwuni nəha ruvəuvehe mɨno kəruəterei sə rəpi raka pam kəruəterei me, məkwtəmhiri əknekɨn pam nimwə. ");
INSERT INTO tnk_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Iərɨmənu səkɨtaha rɨno nəri i, sətoni nəmrɨtaha rier tukwe.’” ");
INSERT INTO tnk_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nənə nəmə asori me hənuə tuhəkwtəmhiri Iesu, tɨ nəri nə mə həreɡi mə in rɨni nusipekɨnien nəha muəsi irəha i, mətə hənhekɨr nərmama, mhəpwəh Iesu, mamhəuvən. ");
INSERT INTO tnk_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nəmə asori me səvəi nəkur Isrel hokeikei mə tuhəkwtəmhiri Iesu. Ro pen hərhi pen Farisi me nepwɨn mɨne nərmama nepwɨn səvəi Kiɡ Herot mə tuhəuvən mhəres Iesu narimnari me nepwɨn, mho in rəfwəkour ia nəɡkiariien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","15","Nənə irəha həuvehe mhəni pen tɨ Iesu i mə, “Iahatən, iahəukurən mə ik iəmə sə ikani nɨpərhienien. Ikəpwəh nehekɨrien nərmama. Nəmə asori uə nəmə auər a ikahatən rəmnəmwhen a tɨ nirəha, mahatən atukwatukw suatuk sə Kumwesən rokeikei mə nərmama tuhesi pen. Tiko mɨni ro tukumaha i mə ratukwatukw ia Loa səkɨtaha mə tahəuvehi pen nəmri takis m Kiɡ Sisa uə rekəm?” Mətə Iesu ruvəukurən raka rerɨnraha mə hokeikei mə in trəfwəkour ia nəɡkiariien səvənhi. Nənə rɨni pen tɨ nirəha i mə, “Rəfo hiameipweipwi iou iamɨnhi irə? Həuvehi silin riti mhəuvehi mhəuvehe pwəh iakətə ro.” ");
INSERT INTO tnk_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nənə irəha həuvei pen silin riti min. Nənə Iesu rəres pen mə, “Nənɨmwi iərmama sin i ia silin? Nənə nəɡhi sin i?” Mɨreɡi həni mə, “Nənɨmwi Kiɡ Sisa mɨne nəɡhi Kiɡ Sisa.” ");
INSERT INTO tnk_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Narimnari me səvəi Kiɡ Sisa hiəuvei pen m Kiɡ Sisa. Narimnari me səvəi Kumwesən hiəuvei pen m Kumwesən.” Irəha həreɡi nəɡkiariien səvənhi, nənimenraha rier. ");
INSERT INTO tnk_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Satusi me nepwɨn həuvehe tɨ Iesu. (Satusi me irəha kamhəni mə iərmama sə ruvamhə ko rɨpkətui mhə mwi.) Irəha həuvehe mhəres Iesu nəresien riti, mhəni mə, ");
INSERT INTO tnk_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Iahatən, Moses rɨmərai pen ia Loa səkɨtaha mə trɨni mɨnuə iərman riti remhə, məpwəh səvənhi pran, mətə tɨnɨnrau riwən, piəvi iərman nəha traməkeikei miri pran nəha rouərəhi nəkwərhakwərha me, rouəsihaɡɨn piəvi iəmə nəha. ");
INSERT INTO tnk_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mətə nərman sefen, irəha piəvnraha me. Sə rasori riri pran riti, krouəpwəh nərəhiien iəkunouihi riti, nənə iərman nəha remhə, məpwəh səvənhi pran. ");
INSERT INTO tnk_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nənə piəvni səro kəru irə riri prən nəha, memhə mwi, məpwəh prən nəha, mətə tɨnɨnrau riwən. Nənə piəvni səro kahar irə ro mwi iamɨnhi irə ");
INSERT INTO tnk_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","meste irəha pam sefen həiri prən nəha, mhemhə pam, nənə prən nəha rəpwəh nərəhiien iəkunouihi riti, memhə mwi. ");
INSERT INTO tnk_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ni pehe ro tukumaha i. Ia nəpɨn nəha Kumwesən tro nərmama hətui mwi ia nemhəien, pran nəha səvəi sin, tɨ nəri nə mə nərman me nəha sefen irəha pam həməiri in?” ");
INSERT INTO tnk_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Kɨmiaha hiəreirei nɨpwrai nəɡkiariien me ia Nəkukuə Ikinan, mhəreirei mwi nɨskaiien səvəi Kumwesən. Ro iamɨnhi irə mɨne nahatənien səkɨmiaha rɨpkatukwatukw mhə. ");
INSERT INTO tnk_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nəpɨn nərmama tuhətui mwi ia nemhəien, nərman tuhəpwəh niriien nɨpran, nɨpran tuhəpwəh nesi penien nərman. Mətə irəha tuhəmwhen naɡelo me ia neiai. ");
INSERT INTO tnk_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nənə nəɡkiariien səvəi nəɡkiariien i hiaməni mə iərmama ko rɨpkətui mhə mwi ia nemhəien. Rosi kɨmiaha hiəpkəvsini raka mhə nəɡkiariien nəha ia Nəkukuə Ikinan Moses rɨmərai rani nei nəha napw rauək irə mətə rɨpkahi əmwesi mhə? Ia kwopwi nəɡkiariien nəha, Kumwesən rɨməni pen tɨ Moses i mə, ‘Iou Kumwesən səvəi Epraham mɨne Kumwesən səvəi Aesak mɨne Kumwesən səvəi Jekop.’ ");
INSERT INTO tnk_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","In rɨpko mhə Kumwesən səvəi nərmama me səməme həuvamhə, mətə in Kumwesən səvəi nərmama me səməme kamhəmɨru. Kɨmiaha nahatənien səkɨmiaha rɨpkatukwatukw anan mhə.” ");
INSERT INTO tnk_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Iahatən riti səvəi Loa ruvehe mɨreɡi irəha kamhəres irəha me i. Nəpɨn rɨreɡi mə Iesu rɨni pen atukwatukw tɨ nirəha i, in rəres pen Iesu i mə, “Nəfe nəha loa rasori ia loa me?” ");
INSERT INTO tnk_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Mɨreɡi Iesu rɨni mə, “Loa sə rasori in nəha Moses rɨməni mə, ‘Kɨmiaha nəkur Isrel! Tihətərɨɡ amasan! Iərɨmənu Kumwesən səkɨtaha in əpa kuatia. ");
INSERT INTO tnk_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nənə tikaməkeikei mokeikei Iərɨmənu Kumwesən səim ia rerɨm me pam, mokeikei in ia nɨmɨruien me pam səim, mokeikei in ia nətərɨɡien me pam səim, mokeikei in ia nɨskaiien me pam səim.’ ");
INSERT INTO tnk_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nənə loa səro kəru irə in i mə, ‘Tikaməkeikei mokeikei piam rəmwhen ikokeikei atukw a ik.’ Loa riti mwi riwən rasori mwi məpi raka loa mi nəha.” ");
INSERT INTO tnk_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mɨreɡi iahatən səvəi Loa rɨni pen tɨ Iesu i mə, “Iahatən. Nəɡkiariien səim ratukwatukw. Ikani nɨpərhienien mə Iərɨmənu in kuatia. Kumwesən riti mwi riwən, mətə in əpa. ");
INSERT INTO tnk_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Iərmama traməkeikei mokeikei in ia rerɨn me pam, mokeikei in ia nətərɨɡien me pam səvənhi, mokeikei in ia nɨskaiien me pam səvənhi. In traməkeikei mokeikei piəvni rəmwhen rokeikei atukw a in. Noien nəha ramasan məpi raka iərmama rousi əpune nərimɨru me, muvani nɨpwranraha ia nɨfatə, muvei pen m Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nəpɨn Iesu rətə mə iahatən səvəi Loa ramɨni pen nəɡkiariien sə ratukwatukw min, rɨni pen tukwe in mə, “Ik ipaka tɨ nɨtətə sə Kumwesən ramərɨmənu irə.” Kurirə irə nərmama pam həhekɨr Iesu. Riti mwi riwən rəres pen nəresien min. ");
INSERT INTO tnk_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nəpɨn Iesu ramahatən nərmama ia nimwə səvəi Kumwesən, rəres pen irəha i mə, “Rəfo nahatən me səvəi Loa haməni mə Kristo in tɨni Kiɡ Tevɨt? ");
INSERT INTO tnk_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kiɡ Tevɨt atukwatukw, nəpɨn Nənɨmwɨn Ikinan rɨnarə irə, rɨməni irapw mə, ‘Kumwesən rɨni pen tɨ Iərɨmənu səiou mə, Əkurei ia nɨkarek mwatuk mesite tako nərmama səməme haməmwəki ik həuvehe, tikərpwi utə tɨpaɡe nɨsum mi ia nirəha.’ ");
INSERT INTO tnk_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ia nəɡkiariien nəha Kiɡ Tevɨt atukwatukw rɨnəkwein Kristo mə Iərɨmənu səvənhi. Mə ro iamɨnhi irə rəfo irəha kamhəni mə in tɨni Kiɡ Tevɨt?” Nəkuər nəha rerɨnraha raɡien mə tuhətərɨɡ ia Iesu. ");
INSERT INTO tnk_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nəpɨn Iesu ramahatən irəha i, mani mə, “Kɨmiaha tihaməkeikei mhəsiari tɨ nahatən me səvəi Loa. Irəha hokeikei mə tuharkahu ia karkahu əpwəmwɨs me mamhan. Ia kwopun kamo maket me ikɨn hokeikei mə nərmama tuhəkwein irəha ia nɨsiaiien. ");
INSERT INTO tnk_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ia nəkwai nimwəfwaki me səvəi nəkur Isrel hokeikei mə tuhəkure ia kwopun amasan me. Ia nəveɡɨnien asori me hokeikei mə tuhəkure ia kwopun kamsiai nəmə asori me ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Irəha kamhəpeki raka nautə səvəi nɨpran me səməme nərman me səvənraha hemhə mhəpwəh irəha. Kamhəfwaki ia nəfwakiien əpwəmwɨs me mə nərmama tuhəsiai irəha. Kumwesən trərpwɨn noien ərəha me səvənraha rasori mwi.” ");
INSERT INTO tnk_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iesu raməkure ipaka tɨ kwopun kamerukw pen mane m Kumwesən ikɨn, maməspau nərmama me kamherukw pen mane me səvənraha. Nərmama me səməme nautə səvənraha rasori həpɨk herukw pen mane asori. ");
INSERT INTO tnk_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mətə pran riti fwe ikɨn. Səvənhi iərman remhə məpwəh in. Nautə səvənhi riwən. Ruvehe merukw pen silin ouihi mi kəru. ");
INSERT INTO tnk_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nəpɨn Iesu rətoni, rəkwein nərmama me səvənhi həuvehe. Rɨni pen tɨ nirəha i mə, “Iakani nɨpərhienien tukumiaha i mə prən nəha iərman səvənhi remhə məpwəh in, nautə səvənhi riwən, in rerukw pen mane rasori məpi raka nərmama me pam nəha səməme kamherukw pen mane m Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Iakani iamɨnhi irə tɨ nəri nə mə nərmama me nəha nautə səvənraha rasori. Həuvehi raka nɨpərɨn a mhəuvei pen m Kumwesən. Mətə prən nəha nautə səvənhi riwən ruvei pen mane me pam səvənhi sə truvehi nəveɡɨnien irə.” ");
INSERT INTO tnk_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nəpɨn Iesu rɨnamier ia kwopun nimwə səvəi Kumwesən ramərer ikɨn, iərmama riti səvənhi rɨni pen tukwe in mə, “Iahatən. Ətə ro nimwə səvəi Kumwesən. Kɨno ia kəruəterei asori me. Nimwə me i hamasan pɨk.” ");
INSERT INTO tnk_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Mɨreɡi Iesu rɨni pen tukwe in mə, “Ikətə nimwə asori me i? Tukamevən tukousi testesi pam, kəruəterei riti ko rəpwəh nərer əknekɨnien ia riti.” ");
INSERT INTO tnk_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nəpɨn Iesu raməkure ia Təkuər Olif, maməti əpwəmwɨs pen ia nimwə səvəi Kumwesən, Pita mɨne Jemes mɨne Jon mɨne Antru həres afafa in mə, ");
INSERT INTO tnk_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tiko mɨni ro tukumaha i mə narimnari me nəha truvehe tɨnesən? Nəfe nɨmtətien truvehe mahatən pen mə nəpɨn səvəi narimnari me nəha ruvəuvehe ipaka?” ");
INSERT INTO tnk_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Kɨmiaha tihaməsiari kamo iərmama riti reikuə ia kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nərmama həpɨk tuhəuvehe ia nəɡhɨk, mhəni mə irəha Kristo. Tuheikuə ia nərmama həpɨk. ");
INSERT INTO tnk_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nəpɨn tihəreɡi nərmama tuhəvisau ia naruaɡənien mə ‘naruaɡənien riti fwe’ uə ‘naruaɡənien trutə,’ tihəpwəh nehekɨrien. Nəri nəha traməkeikei muvehe, mətə rɨpko mhə ihi nəpɨn sampam. ");
INSERT INTO tnk_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nərmama ia kwənəkwus riti tuhəskəmter mharuaɡən irəha nərmama ia kwənəkwus əpə. Nərmama səvəi kiɡ riti tuhəskəmter mharuaɡən irəha nərmama səvəi kiɡ əpə. Kwopun me nepwɨn nɨmwnɨmwien trɨkiu. Nukumhə trahi nərmama. Mətə narimnari me i rəmwhen a ia pran sə rɨnamreɡi təkutan rɨnaməmisə tɨ nərəhiien iəkunouihi. ");
INSERT INTO tnk_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Kɨmiaha tihamətə amasan ia kɨmiaha me. Nərmama tuhəuvei pen kɨmiaha ia rəɡi nəmə asori me mə irəha tuhəkiri nəɡkiariien səkɨmiaha. Fwe ia nəkwai nimwəfwaki me səvəi nəkur Isrel tuhərisi kɨmiaha. Tihərer ia nəmri kiɡ me mɨne ia nəmri nərmama səməme kamhərɨmənu tɨ nəri nə mə kɨmiaha nərmama me səiou. Tihərer ia nəmrɨnraha mhəvisau irapw nəɡkiariien amasan səiou mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nəɡkiariien amasan səiou traməkeikei mukupwən mevən tɨ nərmama pam ia tənəmtənə me kurirə irə nəpɨn sampam truvehe. ");
INSERT INTO tnk_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nəpɨn nərmama tuhəuvei pen kɨmiaha ia rəɡi nəmə asori me mə irəha tuhəkiri nəɡkiariien səkɨmiaha, kurirə hiəɡkiari, tihəpwəh nətərɨɡ pɨkien ia nəfe tihəni. Mətə ia nəpɨn səkɨmiaha tihəɡkiari irə, tihəskəmter, mhəɡkiari, tɨ nəri nə mə rɨpko mhə kɨmiaha atukwatukw tihəɡkiari, mətə Nənɨmwɨn Ikinan truvei pehe nəɡkiariien m kɨmiaha hiəɡkiari. ");
INSERT INTO tnk_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ia nəpɨn nəha iərmama truvei pen piəvni anan ia rəɡi nərməpə mə tukousi əpune. Tata me tuho mwi iamɨnhi ia tɨnɨnraha me. Nəkwərhakwərha me tuhəskəmter mhəni ərəha səvənraha me tata mɨne mama, mhəuvei pen irəha mə tukousi əpune irəha. ");
INSERT INTO tnk_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nərmama me pam tuhəmwəki kɨmiaha tɨ nəri nə mə kɨmiaha nərmama me səiou. Mətə iərmama sə trərer əknekɨn ia nahatətəien səvənhi meste nərəhaien me i həuvehe mhəukurau pam, Kumwesən truvehimɨru in.” ");
INSERT INTO tnk_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Kɨmiaha tihətoni nəri Profet Taniel rɨməni kani mə ‘Nəri sə rərəha anan mamouraha narimnari ikinan.’ Tramərer ia kwopun sə rɨpkatukwatukw mhə mə trərer ikɨn. Ia nəpɨn nəha tihətoni, (iərmama sə raməvsini nəkukuə i traməkeikei mukurən nɨpwran), nərmama ia tənə Jutia tuhaməkeikei mhap mhərkwafə ia təkuər me. ");
INSERT INTO tnk_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Trɨni mɨnuə iərmama riti ramapwɨs ia təkure nimwə səvənhi, traməkeikei meiwaiu map akwauakw, məpwəh nuvnimwəien mə truvehi nari riti. ");
INSERT INTO tnk_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Trɨni mɨnuə iərmama riti raməmhu ia nəmhien səvənhi, traməkeikei map akwauakw, məpwəh nɨrərɨɡien mevən imwəni mə truvehi səvənhi tɨnari. ");
INSERT INTO tnk_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Trərəha anan tɨ nɨpran me səməme tuhəpəmpəm mɨne səməme tuhaməuvei kənunu m nəkwərhakwərha əmtəmetə me ia nəpɨn nəha ");
INSERT INTO tnk_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Tihəfwaki mə nəpɨn nəha trəpwəh nuveheien ia nəpɨn səvəi nəkwieiien, ");
INSERT INTO tnk_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","tɨ nəri nə mə nəpɨn nəha nəpɨn səvəi nərəhaien. Nərəhaien nəha trasori məpi raka nərəhaien me pam səməme həuvəuvehe raka fwe nukune narəien mesite pehe ipwet mɨne. Nənə nərəhaien riti mwi riwən truvehe məpi raka. ");
INSERT INTO tnk_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ko nərəhaien nəha ravən əpwəmwɨs, nərmama me hemhə pam. Mətə Iərɨmənu tro nəpɨn sə nərəhaien nəha travən irə rukwakwa. In tro iamɨnhi irə mə truvehimɨru nərmama me səvənhi səməme ruvərfi raka irəha. ");
INSERT INTO tnk_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ia nəpɨn nəha, trɨni mɨnuə iərmama riti rɨni pehe tukumiaha i mə, ‘Hətə ro Kristo i’ uə ‘Hətə ro Kristo nəha,’ kɨmiaha tihəpwəh nɨniien nɨpərhienien irə. ");
INSERT INTO tnk_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nərmama tuhəskəmter. Nepwɨn tuhəni mə irəha Kristo, mətə neikuəien. Nepwɨn tuhəni mə irəha profet, mətə neikuəien. Tuho nɨmtətien me mɨne narimnari me nərmama tuhətoni mhərkərinari irə. Irəha tuhəmwur mə tuheikuə ia nərmama səməme Kumwesən ruvərfi raka irəha, trɨni mɨnuə irəha həukurən noien. ");
INSERT INTO tnk_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mətə kɨmiaha tihaməsiari. Narimnari me pam iakukupwən muvəni raka tukumiaha i.” ");
INSERT INTO tnk_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Iesu rɨrɨpɨn mɨni mə, “Mətə nəpɨn nərəhaien nəha truvehe mukurau pam, ‘meri truvehe mɨpitəv, məkwə trəpwəh nəhiapwien, ");
INSERT INTO tnk_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","kəməhau me ia nɨmaɡouaɡou tuhəsasəsas, narimnari me ia nɨmaɡouaɡou həskai pɨk, Kumwesən trɨkiukiu ia nirəha.’ ");
INSERT INTO tnk_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kurirə irə nərmama tuhətoni iou, Iəməti Iərmama, ia nəpuə iakauvehe ia nɨskaiien asori mɨne nukuraanien asori. ");
INSERT INTO tnk_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ia nəpɨn nəha takərhi raka naɡelo me səiou həuvrehi, mhəuvesu, mhəuveraha, mhəuvarei, mhəuvən ia kwopun me pam ia tɨprənə i, mhəpeki nərmama me səməme iakɨmərfi irəha mə səiou, mhəpeki irəha mhəuvehe. ");
INSERT INTO tnk_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Həreɡi ro nusipekɨnien səvəi nei nəha niemɨs. Nəpɨn rɨnarkwi pen tukun sə rɨmərməru mɨnaməpɨrpɨr, kɨmiaha hiəukurən mə nəpɨn səvəi nəpnəpanien ruvəuvehe ipaka. ");
INSERT INTO tnk_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Rəmwhen a mwi, nəpɨn kɨmiaha tihətoni narimnari me i hənaməier pehe, tihəukurən mə iou, Iəməti Iərmama, iakuvəuvehe ipaka, rəmwhen a iakamərer ia kwəruə ia nimwə mə takuvnimwə pehe. ");
INSERT INTO tnk_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Iakani nɨpərhienien tukumiaha i mə nərmama səməme kamhəmɨru təkwtəkwuni mɨne tuhəpwəh nemhə pamien meste narimnari me pam i həier pehe. ");
INSERT INTO tnk_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Neiai mɨne tɨprənə trouiwən, mətə nəɡkiariien me səiou tuhəpkiwən mhə. ");
INSERT INTO tnk_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Mətə nəpɨn səvəi nəri nəha, uə aoa səvənhi, iərmama riti riwən rukurən. Naɡelo me ia neiai mɨne iou mwi, Tɨni Kumwesən, iahəreirei. Mətə Tata səiou, in əpa rukurən. ");
INSERT INTO tnk_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kɨmiaha tihaməsiari, tɨ nəri nə mə hiəreirei mə nəpɨn nəha truvehe tɨnesən. ");
INSERT INTO tnk_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Rəmwhen a ia iərmama riti ravən əpwəmwɨs, məseni pen narimnari me səvənhi ia rəɡi nərmama me səməme kamho tukwini nari min. Irəha pam səvənraha wok rarə. Nənə nəpɨn iərmama nəha ramier irə rɨni pen tɨ iərmama sə raməkure ia kwəruə ia nimwə səvənhi mə, ‘Tikamətui amasan tɨ səiou narimnari me, məpwəh napriien.’ ");
INSERT INTO tnk_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ro iamɨnhi irə kɨmiaha tihaməkeikei mhətui amasan, mhəpwəh napriien, tɨ nəri nə mə hiəreirei mə iəmə asori səvəi nimwə truvehe tɨnesən. Truvehe ia nəruarəv uə ia nəpɨn uə ia nəpɨn rəiə rakaka irə uə ia nəpnəpɨn. ");
INSERT INTO tnk_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Rərəha mə ruvehe akwauakw mətoni hiamapri. ");
INSERT INTO tnk_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nəfe iakamɨni pehe tukumiaha i, iakamɨni pen tɨ nərmama me pam mə, ‘Hətui amasan, mhəpwəh napriien!’” ");
INSERT INTO tnk_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nəpɨn kəru mwi nəkur Isrel ho Pasova irau nəveɡɨnien asori sə hani bred sə yis riwən irə. Pris asori me mɨne nahatən me səvəi Loa kamhətui suatuk riti mə tuhəuvən afafa, məkwtəmhiri Iesu, mhousi əpune. ");
INSERT INTO tnk_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Irəha kamhəni mə, “Pwəh kɨtaha səpwəh nəkwtəmhiriien Iesu ia nəpɨn səvəi nəveɡɨnien asori. Rərəha mə nərmama niemaha trəpi irəha kamho nurɨɡrɨɡien asori tukwe.” ");
INSERT INTO tnk_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nəpɨn Iesu ramarə ia rukwənu nəha Petani, ruvnimwə pen ia nəkwai nimwə səvəi Saemon. (Saemon nəha kupwən nemhəien skai ro tekɨn.) Iesu raməkure maməni nari. Pran riti ruvehe mauvehi potel riti kɨno ia kəruəterei riti nəɡhɨn nə alapasta. Fwe ia nəkwai potel nəha senta sə kɨno ia nat atukwatukw. Nənimen rutə pɨk. Prən nəha rətefi tərhui potel nəha, mətəɡi pen ia nukwəne Iesu. ");
INSERT INTO tnk_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mətə nərmama nepwɨn niemaha rəpi irəha, kamhəni pen tɨ nirəha me i mə, “Rəfo ramouraha senta ianhi? ");
INSERT INTO tnk_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ramasan mə rɨpkəmri pen a nəmri nari ia senta nəha pwəh iərmama riti ruvehi. Rukurən nuvehiien mane asori muvei pen m nərmama nautə səvənraha riwən.” Nənə kamhəski prən nəha. ");
INSERT INTO tnk_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mətə Iesu rɨni mə, “Tihəpwəh nəskiien prən i! Rəfo hiamo iamɨnhi irə? In ramo noien amasan riti miou. ");
INSERT INTO tnk_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nərmama me səməme nautə səvənraha riwən tuhamarə kɨmiaha mɨnraha ia nəpɨn me. Nəpɨn hiənuə tihasitu ia nirəha, hiəukurən nasituien. Mətə iou tapkarə mhə kɨtaha m kɨmiaha nəpɨn me. ");
INSERT INTO tnk_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Prən i rɨno nari riti rəmwhen irə mə tro. Rukupwən mətəɡi pehe senta maməpnəpenə ia nɨpwrak mə tukɨnɨmwi. ");
INSERT INTO tnk_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Iakani nɨpərhienien tukumiaha i mə nərmama tuhəvisau irapw nəɡkiariien amasan səiou ia kwopun me ia tɨprənə i, mhəvisau irapw nəfe prən i rɨno miou mə nərmama rerɨnraha tramrhi.” ");
INSERT INTO tnk_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jutas Iskariot, in riti ia twelef nərmama me səvəi Iesu, revən tɨ pris asori me mə trəɡkiari mɨnraha. Revən mɨni mə, “Takuvei pehe Iesu m kɨmiaha.” ");
INSERT INTO tnk_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nəpɨn pris asori me həreɡi nəɡkiariien səvənhi, rerɨnraha raɡien tukwe. Həni mə tuhəuvei pen mane min. Nənə Jutas rɨnamətui suatuk mə truvei pen Iesu ia rəɡɨnraha. ");
INSERT INTO tnk_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Neste atukwatukw nəpɨn nəha tuhani bred sə yis riwən irə. (Ia nəpɨn asori nəha, nərmama kamhousi əpune sipsip me səvəi Pasova.) Nərmama me səvəi Iesu həres pen Iesu i mə, “Kwopun pəku nəha ikokeikei mə kɨmaha tahəuvən mhəpnəpenə tɨ nəveɡɨnien səvəi Pasova ikɨn, nənə, ik tikəni?” ");
INSERT INTO tnk_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nənə Iesu rərhi pen iərmama mi kəru səvənhi mɨni pen tɨ nirau i mə, “Kɨmirau tirouevən fwe ia Jerusalem. Iərman riti trəpi raka kɨmirau ia suatuk, mauvehi tɨkinari riti nui rukuər irə. Iroukurirə pen in. ");
INSERT INTO tnk_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nəpɨn revən muvnimwə ia nəkwai nimwə, iroukurirə i, rauevən, rouni pen tɨ iəmə asori səvəi nimwə nəha mə, ‘Iahatən səkɨtaha rani mə, nimwə əfo nəha tahani pəri nəveɡɨnien səvəi Pasova kɨmaha səiou me nərmama me ikɨn?’ ");
INSERT INTO tnk_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nənə in triri kɨmirau mevən fwe irənhə ia nimwə nəha mahatən rum asori riti. Narimnari me pam hənəmak raka fwe ikɨn. Ia rum nəha kɨmirau tirouəpnəpenə tukutaha.” ");
INSERT INTO tnk_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nənə iərmama mi nəha səvəi Iesu krouier, rouevən fwe ia Jerusalem, rouətə narimnari me pam rosi a Iesu rɨməni pen tɨ nirau i. Nənə krouəpnəpenə tɨ nəveɡɨnien səvəi Pasova. ");
INSERT INTO tnk_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ia nəruarəv Iesu ruvehe irəha twelef nərmama me səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nəpɨn kamhani pəri nari irə, Iesu rɨni pen tɨ nirəha i mə, “Iakani nɨpərhienien tukumiaha i mə kɨmiaha riti truvei pen iou ia rəɡi nərmama me səməme kamhəmwəki iou. Kɨmiaha riti raməni pəri nari kɨmrau min.” ");
INSERT INTO tnk_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nəpɨn irəha həreɡi nəɡkiariien nəha, rerɨnraha rəpou. Həuvehe kuatia kuatia mamhəres Iesu i mə, “Sin nəha ikani? Iou?” ");
INSERT INTO tnk_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Iakani kɨmiaha riti ia twelef nərmama me i səiou. Iərmama sə rameitesi bred ia tikiplet kuatia kɨmrau min. ");
INSERT INTO tnk_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Iou, Iəməti Iərmama, takaməkeikei memhə rəmwhen kɨmərai pen ia Nəkukuə Ikinan, mətə trərəha anan tɨ iərmama sə truvei pen iou ia rəɡi nərmama me səməme kamhəmwəki iou. Ramasan pɨk mə rɨpkəpwəh a nətuiien.” ");
INSERT INTO tnk_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nəpɨn nəha kamhani nari irə, Iesu ruvehi bred məfwaki mɨni vivi Kumwesən tukwe. Məfwaki pam, nənə məkwsen muvei pen m səvənhi me nərmama me, mɨni pen tɨ nirəha i mə, “Tihəuvehi. In i nɨpwrak.” ");
INSERT INTO tnk_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kurirə irə in ruvehi kap waen, məfwaki mɨni vivi Kumwesən tukwe. Məfwaki pam, nənə muvei pen mɨnraha irəha pam hənɨmwi waen ia tɨkikap nəha. ");
INSERT INTO tnk_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nəpɨn Iesu rauvei pen mɨnraha, in rɨni mə, “In i nɨtek sə trərihi tərini əknekɨn nəɡkiariien vi səvəi Kumwesən. Traiu tɨ nərmama həpɨk. ");
INSERT INTO tnk_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Iakani nɨpərhienien tukumiaha i mə tapkənɨmwi mhə mwi waen meste takənɨmwi waen vi ia nɨtətə sə Kumwesən ramərɨmənu irə.” ");
INSERT INTO tnk_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nənə irəha hani nɨpu riti, mho sampam irə, mhəier mhəuvən ia Təkuər Olif. ");
INSERT INTO tnk_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Iesu rɨni pen tɨ səvənhi nərmama me i mə, “Tukamevən kɨmiaha pam tihap raka ia nirak. Iakani iamɨnhi irə tɨ nəri nə mə kɨmərai pen ia Nəkukuə Ikinan mə Kumwesən rɨni mə, ‘Iou takousi iərmama sə ramətui tɨ sipsip, sipsip me tuhaiu kɨrkɨri.’ ");
INSERT INTO tnk_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Mətə in tro iakətui mwi ia nemhəien səiou. Takətui raka, mevən fwe ia tənə Kalili. Iou takukupwən kɨmiaha tihəkurirə.” ");
INSERT INTO tnk_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Mətə Pita rɨni pen tɨ Iesu i mə, “Irəha pam tuhap raka ia niram, mətə rɨpko mhə iou.” ");
INSERT INTO tnk_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Mɨreɡi Iesu rɨni pen tukwe in mə, “Iakani nɨpərhienien tukw ik i ipwet ia nəpɨn, kurirə rəiə rakaka səro kəru irə, ik tikɨni m kahar mə ikreirei iou.” ");
INSERT INTO tnk_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mətə Pita rəɡkiari asori mə, “Trɨni mɨnuə həni mə takaməkeikei memhə krau mik, mətə ko iakəpwəh nɨniien mə iakreirei ik.” Nənə irəha pam həni nəɡkiariien kuatia. ");
INSERT INTO tnk_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Irəha həuvən ia kwopun riti nəɡhɨn nə Ketsemane. Iesu rɨni pen tɨ səvənhi me nərmama me i mə, “Kɨmiaha tihaməkure ia kwopun i. Pwəh iou iakevən məfwaki.” ");
INSERT INTO tnk_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nənə in riri Pita, Jemes, mɨne Jon harevən irəha min. Ia nəpɨn nəha in rɨnamreɡi rərəha, rerɨn rəpou pɨk. ");
INSERT INTO tnk_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nənə rɨni pen tɨ nirəhar i mə, “Rerɨk rəpou pɨk ipaka iakemhə tukwe. Tiamharo i mharəpwəh napriien.” ");
INSERT INTO tnk_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nənə Iesu revən ouihi a mwi, mɨmwei ia tɨprənə, məfwaki, maməres suatuk riti mwi mə nəpɨn nəha trukurau irə. ");
INSERT INTO tnk_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","In rɨni mə, “Tata keikei, narimnari me pam rɨməru tukw ik. Tikuvehi raka kap i pwəh iakəpwəh nənɨmwiien. Mətə tikəpwəh noien rəmwhen sə iakokeikei, mətə tiko rəmwhen sə ikokeikei.” ");
INSERT INTO tnk_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nənə Iesu rəfwaki pam, mɨrərɨɡ pehe mətoni Pita mɨne Jemes mɨne Jon kamharapri. Nənə in rɨni pen tɨ Pita i mə, “Eh, Saemon, rəfo ikamapri, ko ipkətui mhə nəpɨn ouihi a uə? ");
INSERT INTO tnk_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Tiharətui mharəfwaki mə tiharəpwəh nɨmweiien ia nərəhaien. Nɨpərhienien, rerɨmiaha raɡien mə tihəfwaki, mətə nɨpwramiaha rəpou.” ");
INSERT INTO tnk_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nənə Iesu rɨrərɨɡ mevən məfwaki mwi, mɨni a nəɡkiariien sə rɨməni kupwən. ");
INSERT INTO tnk_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nənə mɨrərɨɡ pehe mwi mətə irəhar kamharapri mwi, tɨ nəri nə mə napriien ruvəuvehi irəhar. Nənə harfi nəmrɨnrahar, mətə harreirei mə tuharni pen nəfe tukwe in. ");
INSERT INTO tnk_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nənə Iesu revən səro kahar irə muvehe mɨni pen tɨ nirəhar i mə, “Hiamarapri, mamharuvehi ihi napwɨsien səkɨmiahar? Nəmwhen. Nəpɨn nəha ruvəuvehe. Iərmama riti truvei pen iou, Iəməti Iərmama, ia rəɡi nəmə ərəha me. ");
INSERT INTO tnk_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tiharo mharərer. Pwəh saməuvən. Hətə ro, iərmama nəha trɨni pui iou ruvəuvehe ipaka.” ");
INSERT INTO tnk_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nəpɨn Iesu raməɡkiari ihi, Jutas, in riti ia twelef nərmama me səvəi Iesu, ruvehe irəha nərmama me həpɨk. Pris asori me mɨne nahatən me səvəi Loa mɨne nəmə asori me səvəi nəkur Isrel hənərhi pen irəha. Nepwɨn kamhəuvehi nau. Nepwɨn kamhəuvehi nɨpəri nei. ");
INSERT INTO tnk_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jutas rɨnəɡkiari raka mɨnraha mə, “Iərmama sə takakei min, iəmə nə in nə. Kɨmiaha tihəkwtəmhiri, mhəiri raka mhəuvən, mhətui amasan mə trəpwəh napien.” ");
INSERT INTO tnk_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nənə nəpɨn Jutas ruvehe ia kwopun nəha, revən atukwatukw tɨ Iesu, mɨni mə, “Iahatən!” Nənə makei min. ");
INSERT INTO tnk_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jutas rakei min, nənə nərmama me həuvehe mhəkwtəmhiri. ");
INSERT INTO tnk_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mətə iərmama riti sə ramərer ipaka tɨ Iesu reivi raka nau səvənhi, mərai iərmama riti sə ramo tukwini nari m pris asori anan, mərai raka nɨkare nɨfreɡɨn. ");
INSERT INTO tnk_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nənə Iesu rɨni pen tɨ nirəha i mə, “Rəfo hiəuvehi nau me mɨne nɨpərpəri nei me mhəuvehe mə tihəkwtəmhiri iou iamɨnhi irə? Nətərɨɡien səkɨmiaha rɨnuə iou rakres riti uə? ");
INSERT INTO tnk_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ia nərineiv m neis mɨne iakamarə kɨtaha m kɨmiaha fwe ia nimwə səvəi Kumwesən, mamahatən nərmama. Rəfo hiəpwəh nəkwtəmhiriien iou ia nəpɨn nəha? Mətə hiamo iamɨnhi irə mə nəɡkiariien sə Nəkukuə Ikinan rɨməni truvehe mukuə.” ");
INSERT INTO tnk_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Irəha həkwtəmhiri Iesu. Nənə nərmama me pam səvənhi həpwəh in mhap. ");
INSERT INTO tnk_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Təmaruə riti rakurirə Iesu. Rauveɡi a nɨpwran ia ravaravar. Nərmama me həuvehe mhəkwtəmhiri. ");
INSERT INTO tnk_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Mətə resi raka ravaravar ia nɨpwran maiu auər a map. ");
INSERT INTO tnk_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nərmama me həiri Iesu mhəuvən tɨ pris asori anan. Pris asori me mɨne nəmə asori me səvəi nəkur Isrel, mɨne nahatən me səvəi Loa, hənousəsɨmwɨn pen pam raka irəha me tukwe. ");
INSERT INTO tnk_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Nəpɨn həiri pen Iesu mamhəuvən, Pita rakurirə ia Iesu mamavən isipwɨn tukwe meste nari fwe ia nɨkare nimwə səvəi pris asori anan. Nənə muvnimwə maməkure irəha iotukwininari me, mamərhiəpw ia napw. ");
INSERT INTO tnk_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nənə pris asori me mɨne nəmə asori me səvəi nəkur Isrel kamhətui nərmama nepwɨn mə tuhəni irapw nəri ərəha riti sə Iesu rɨno uə rɨməni. Nəmə asori me hokeikei mə tuhəreɡi pwəh housi əpune Iesu tukwe. Mətə irəha həpkətə mhə nari riti. ");
INSERT INTO tnk_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Rəknekɨn tɨ nirəha tɨ nəri nə mə nərmama həpɨk həskəmter mamheikuə ia nəfe hənətoni Iesu rɨno uə həməreɡi in rɨməni, mətə nəɡkiariien səvənraha rɨpkuvehe mhə mo kuatia. ");
INSERT INTO tnk_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nənə nərmama nepwɨn həskəmter mamheikuə ia Iesu mamhəni mə, ");
INSERT INTO tnk_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Kɨmaha iahəreɡi iəmə i rɨməni mə, ‘Iou takouraha nimwə i səvəi Kumwesən sə nərmama həno ia rəɡɨnraha. Nəpɨn kahar rukurau takuvrhəkɨn riti mwi nərmama tuhəpwəh noien ia rəɡɨnraha.’” ");
INSERT INTO tnk_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Həni iamɨnhi irə, mətə nəɡkiariien mwi səvənraha rɨpko mhə kuatia. ");
INSERT INTO tnk_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nənə pris asori anan rərer ia kurkwan ia nirəha məres pen Iesu i mə, “Nəɡkiariien riti riwən tikɨni? Rəfo ia nəɡkiariien nəha irəha kamhəni mamhousi ik irə?” ");
INSERT INTO tnk_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mətə Iesu rəpnapen, məpwəh nəɡkiariien. Nənə pris asori anan rəres pen mwi mə, “Rəfo? Ik Kristo? Kumwesən sə kamɨni vivi in tɨni nə ik?” ");
INSERT INTO tnk_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Mɨreɡi Iesu rɨni mə, “Iou i. Tukamevən kɨmiaha tihətoni iou, Iəməti Iərmama, takaməkure ia nɨkare Kumwesən mwatuk sə in nɨskaiien səvənhi rasori. Tihətoni mwi iou takauvehe ia nəpuə me ia nɨmaɡouaɡou.” ");
INSERT INTO tnk_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nənə nəpɨn pris asori anan rɨreɡi, reitehi karkahu səvənhi, mɨni mə, “Kɨtaha tsətui iərmama riti mwi tro pui iəmə i tɨ nəfe? ");
INSERT INTO tnk_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Hiəuvəreɡi raka mə in rɨni ərəha Kumwesən. Nətərɨɡien səkɨmiaha mə tsəfo irə?” Nənə irəha pam həni mə Iesu traməkeikei memhə. ");
INSERT INTO tnk_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nepwɨn həskəmter mhərɡəvəsi pen in. Nepwɨn housəman nənimen, mamhəuəsi in, mamhəni mə, “Ni ro nəɡkiariien sə ruku pen tɨ Nənɨmwɨn mə sin ruəsi ik!” Nənə naruaɡən me səvəi pris asori anan irəha mwi həuvehi mhəpwi. ");
INSERT INTO tnk_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita in fwe inhərɨpw ia nɨkare nimwə səvəi pris asori anan. Nənə pran riti sə ramo tukwini nari m pris asori anan ruvehe. ");
INSERT INTO tnk_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nəpɨn rətoni Pita ramərhiəpw ia napw, rəti əter irə, mɨni mə, “Ik mwi ikɨnamavən pəri kɨmirau Iesu iəmə Nasaret.” ");
INSERT INTO tnk_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mɨreɡi Pita rɨni mə, “Rekəm. Iou iakreirei iəmə nəha, mɨreirei nəfe i ikamɨni.” Nənə Pita rəpwəh nɨkare nimwə səvəi pris asori anan mevən ipaka tɨ kwəruə asori riti sə nərmama kamhəuvnimwə pehe irə. Nənə rəiə riti rakaka. ");
INSERT INTO tnk_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nənə pran sə ramo tukwini nari ruvehe mɨnamɨni mwi tɨ nərmama səməme kamhərer ipaka tɨ Pita i mə, “Iəmə i in riti ia nirəha.” ");
INSERT INTO tnk_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Mətə Pita rɨni mwi mə, “Rekəm. Rɨpko mhə iou riti ia nirəha.” Nənə hərer ouihi a mwi. Nərmama səməme kamhərer ipaka tukwe in həni pen mwi mə, “Nɨpərhienien, ik riti ia nirəha tɨ nəri nə mə ik iəmə Kalili.” ");
INSERT INTO tnk_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Mɨreɡi Pita rɨni mə “Mə iakameikuə pwəh Kumwesən rərpwɨn noien ərəha səiou. Iakani pehe tukumiaha i kwəsuahi anan mə iou iakreirei iəmə nəha kɨmiaha hiaməni.” ");
INSERT INTO tnk_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pita rɨni iamɨnhi irə nənə təkwtəkwuni a rəiə rakaka səro kəru irə. Nənə Pita rerɨn rɨrhi nəɡkiariien sə Iesu rɨməni pen tukwe in mə, “Kurirə rəiə rakaka səro kəru irə, tikɨni m kahar mə ikreirei iou.” Pita rerɨn rɨrhi. Nənə rerɨn rərkwəpɨr, rasək. ");
INSERT INTO tnk_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ia nəpnəpɨn pris asori me mɨne nəmə asori me səvəi nəkur Isrel mɨne nahatən me səvəi Loa mɨne nərmama pam ia nəkureien səvənraha hərai sun nəɡkiariien səvənraha, mhərihi Iesu, mhəiri mhəuvən, mhəmri pen in ia rəɡi Paelat. ");
INSERT INTO tnk_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Nənə Paelat rəres pen Iesu i mə, “Ik kiɡ səvəi nəkur Isrel?” Mɨreɡi Iesu rɨni mə, “Ik ikani.” ");
INSERT INTO tnk_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ia nəpɨn nəha pris asori me kamhəni ərəha Iesu ia narimnari me rɨpɨk. ");
INSERT INTO tnk_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ro pen Paelat rəres pen mwi tɨ Iesu i mə, “Nəɡkiariien riti riwən tikɨni pen tɨ nirəha i? Reɡi ro narimnari me rɨpɨk kamhəni ərəha ik irə.” ");
INSERT INTO tnk_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mətə Iesu rəpwəh nəɡkiariien. Nənə Paelat rərkərinari irə. ");
INSERT INTO tnk_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Noien riti nəha ikɨn Paelat ramo ia nuk me pam ia nəpɨn səvəi nəveɡɨnien asori nəha Pasova. Raməseni iərmama riti sə nəkur Isrel həməni rier ia kalapus mamevən. ");
INSERT INTO tnk_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ia nəpɨn nəha iərmama riti raməmak fwe ia kalapus nəɡhɨn nə Parapas. Kɨməuvehi puvnimwə in ia kalapus irəha nərmama me nepwɨn tɨ nəri nə mə hənousi əpune iərmama ia nəpɨn səvəi naruaɡənien riti. ");
INSERT INTO tnk_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ro iamɨnhi irə nərmama həpɨk həuvehe tɨ Paelat mənamhəres pen mə trəseni iərmama riti rier ia kalapus rəmwhen sə ramo mɨnraha ia nuk me. ");
INSERT INTO tnk_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Mɨreɡi Paelat rɨni pen tɨ nirəha i mə, “Kɨmiaha hiokeikei mə takəseni kiɡ səvəi nəkur Isrel rier ia kalapus?” ");
INSERT INTO tnk_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Paelat rəres pen irəha iamɨnhi irə tɨ nəri nə mə in rukurən mə pris asori me həməuvei pen Iesu ia rəɡɨn tɨ nəmwəkiien səvənraha. ");
INSERT INTO tnk_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nənə Paelat rəres pen irəha, mətə pris asori me hərer kukurau mamhərhiərhi nərmama, mamhəni pen tɨ nirəha i mə tuhəres pen Paelat i mə trəpwəh narakaien ia Iesu mətə traraka ia Parapas. ");
INSERT INTO tnk_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ro iamɨnhi irə Paelat rəɡkiari mwi mɨnraha mɨni mə, “Trɨni mɨnuə iakəseni Parapas rier ia kalapus, rəfo ia iərmama sə hiaməni mə in kiɡ səvəi nəkur Isrel?” ");
INSERT INTO tnk_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Mɨreɡi irəha həkwein əpwəmwɨs mwi mə, “Ərui tərini pen in ia nei kamarkuaui!” ");
INSERT INTO tnk_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Mɨreɡi Paelat rɨni pen tɨ nirəha i mə, “Tɨ nəfe? Nəfe nəha nərəhaien in rɨno?” Mətə həni asori mwi mə, “Ərui tərini pen in ia nei kamarkuaui!” ");
INSERT INTO tnk_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nərmama me həpɨk nənə Paelat rokeikei mə tro rerɨnraha rəpwiuən. Ro pen rəseni Parapas rier ia kalapus mamevən. Nənə Paelat rɨni pen tɨ naruaɡən me mə tuhərisi Iesu. Hərisi pam nənə Paelat rəseni pen Iesu ia rəɡɨnraha mə tuhərui tərini pen ia nei kamarkuaui. ");
INSERT INTO tnk_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Naruaɡən me həiri Iesu mhəier mhəuvən ia nəkwai nimwə asori səvəi Paelat. (Nimwə nəha nəɡhɨn nə Praetoriam.) Nəpɨn hapirapw fwe ikɨn, həkwein irəha me nepwɨn ia kusen səvənraha həuvehe, ");
INSERT INTO tnk_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","mharkahu pen karkahu əruerəv riti m Iesu rəmwhen ia karkahu səvəi kiɡ. Həuvehi rəhi mhəuvnhi kəfəfau irə səvəi kiɡ, mhəfəfau pen ia kənkapwə. ");
INSERT INTO tnk_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Hənaməkwein pen irə mə, “Ik kiɡ səvəi nəkur Isrel kɨmaha iahəsiai ik!” ");
INSERT INTO tnk_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Irəha həuəsi kənkapwə ia rɨɡi nei, mhərɡəvəsi in, mhənɨmwi nukurhunraha ia nənimen mamhəuvnhi nɨsiaiien irə. ");
INSERT INTO tnk_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nəpɨn hənarɨs əkenhɨn raka irə, həuvehi raka karkahu əruerəv irə, mharkahu pen tɨnari ihi səvənhi, mhəiri in mhəier mə tuhərui tərini pen ia nei kamarkuaui. ");
INSERT INTO tnk_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Irəha həiri Iesu, mamhəuvən. Ia suatuk naruaɡən me hətoni iəmə Saerin riti. Nəɡhɨn nə Saemon. In tata səvəi Aleksanta mɨne Rufas. Ruku pen fwe ia rukwənu mauvehe i ia taon. Naruaɡən me həkeikei min mə trəvrani nei kamarkuaui səvəi Iesu. ");
INSERT INTO tnk_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Həiri Iesu mhəuvən ia kwopun riti nəɡhɨn nə Kolkota (Nɨpwrai nəhaɡ nəha kwopun səvəi kerhə ia iərmama) ");
INSERT INTO tnk_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Irəha həuvei pen waen min kəvti pen nɨmwai nari riti rəfiə trasitu muəsi nəmisəien. Mətə Iesu rəpwəh nənɨmwiien. ");
INSERT INTO tnk_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Irəha hərui tərini pen Iesu ia nei kamarkuaui, mharə mhəuai kɨrkɨri tɨnari me səvənhi, mhəuini nari riti sə trahatən pen mə sin truvehi nəfe tɨnari səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Hərui tərini pen Iesu ia nei kamarkuaui ia naen klok ia nəpnəpɨn. ");
INSERT INTO tnk_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nəkukuə kɨmərai mə Iesu tremhə tɨ nəfe rɨni mə: IN I KIG SƏVƏI NƏKUR ISREL ");
INSERT INTO tnk_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Nəpɨn hərui tərini pen Iesu ia nei kamarkuaui, hərui tərini pen mwi rakres mi kəru ia nei kamarkuaui, riti ia nɨkare Iesu mwatuk riti ia nɨkaren mour. ");
INSERT INTO tnk_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nənə nərmama səməme həukurau pehe ia suatuk, kamhəni ərəha Iesu, mamharɨs əkenhɨn irə, mamhounouini kənkapwənraha me, mamhəni mə, “Ik nə iəmə ikɨməni mə tikouraha nimwə səvəi Kumwesən marə muvrhəkɨn mwi ia nəpɨn kahar. ");
INSERT INTO tnk_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ita, uvehimɨru ik, maraka ia nei kamarkuaui meiwaiu pehe!” ");
INSERT INTO tnk_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Pris asori me mɨne nahatən me səvəi Loa, irəha mwi kamhəni ərəha Iesu, mamharɨs əkenhɨn irə, mamhəni pen tɨ nirəha me i mə, “In ruvəuvehimɨru raka nərmama həpɨk, mətə ko rɨpkuvehimɨru atukw mhə in.” ");
INSERT INTO tnk_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Həni mə, “In Kristo. In kiɡ səvəi nəkur Isrel. Ramasan mə raraka ia nei kamarkuaui meiwaiu pehe pwəh kɨtaha sətoni mhəni nɨpərhienien irə.” Iərman mi nəha kəru kɨnərui tərini pen irau ia nei kamarkuaui irəhar Iesu, irau mwi krauni ərəha in. ");
INSERT INTO tnk_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ia kurkwai nəpɨn ia ran nəpitəvien ruvehe mousəman kwopun me pam ia tənə nəha meste aoa kahar rukurau. ");
INSERT INTO tnk_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nənə ia tri klok ia nərvarəv Iesu rasək əpwəmwɨs mɨni mə, “Eloi, Eloi, lama sapaktani?” Nɨpwrai nəɡkiariien nəha, in i mə, “Kumwesən səiou, Kumwesən səiou, rəfo ikap raka ia nirak iamɨnhi?” ");
INSERT INTO tnk_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nərmama nepwɨn səməme kamhərer mamhəspau ia Iesu həreɡi nəɡkiariien nəha, mhəni mə, “Həreɡi ro, iəmə i raməkwein Profet Elaeja.” ");
INSERT INTO tnk_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nənə riti ia nirəha raiu muvehi nɨpəri koton, meitesi ia waen sə rəfiə, mɨpiri pen ia nusvenhi rəɡi nei riti, muvehi pen mə Iesu trənɨmwi, mɨni mə, “Pəpɨm ro pwəh sətoni mə Profet Elaeja truvehe muvehi raka iəmə i ia nei kamarkuaui uə rekəm.” ");
INSERT INTO tnk_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mətə Iesu rasək əpwəmwɨs, muvehi neiahaɡien səvənhi sampam, memhə. ");
INSERT INTO tnk_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ia nəpɨn nəha tɨnari sə rəɡher tukuahaɡ kwopun ikinan anan fwe ia nəkwai nimwə səvəi Kumwesən reitehi nɨpərɨn kəru fwe irənhə meste nari fwe inhərɨpw. ");
INSERT INTO tnk_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Iəmə asori riti səvəi naruaɡən me ramərer maməti pen mətoni Iesu. Nəpɨn rətoni Iesu ruvehi neiahaɡien səvənhi sampam, memhə iamɨnhi irə, rɨni mə, “Nɨpərhienien iəmə i in Tɨni Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nɨpran me nepwɨn kamhərer isipwɨn kwopti tɨ Iesu mamhəspau irə. Meri Maktala, mɨne Salome, mɨne Meri mama səvəi Jemes mɨne Joses, irəha mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nəpɨn Iesu rɨnamavən fwe ia tənə Kalili nɨpran mirəhar nəha kamhəkurirə i, mamhasitu irə. Nɨpran me nepwɨn mwi həpɨk, nəpɨn Iesu ruvehe ia Jerusalem, irəha mwi həkurirə in mhəuvehe. ");
INSERT INTO tnk_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Fraete, nəpɨn kaməpnəpenə irə tɨ Sapat, tɨ nəri nə mə nəruarəv meri rɨnamivə, ");
INSERT INTO tnk_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Josef iəmə Aramatia revən mə trəres Paelat mə ko Paelat rəseni in ruvehi nɨpwrai Iesu. (Josef in mwi raməkure irəha nəmə asori me səvəi nəkur Isrel nəpɨn housəsɨmwɨn irəha me. Nərmama kamhəsiai in. Josef rameitenhi mə trətoni nɨtətə sə Kumwesən ramərɨmənu irə truvehe.) Josef rətəɡase ia Paelat, mevən məres nɨpwrai Iesu. ");
INSERT INTO tnk_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nəpɨn Josef rəres pen Paelat tɨ nɨpwrai Iesu, Paelat rərkərinari, mɨreirei mə Iesu ruvamhə pərhien uə rekəm. Ro iamɨnhi irə rəkwein pen iəmə asori səvəi naruaɡən me məres pen tukwe in mə, “Nɨpərhienien Iesu ruvamhə raka?” ");
INSERT INTO tnk_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mɨreɡi iəmə asori səvəi naruaɡən me rɨni mə, “Nɨpərhienien Iesu ruvamhə raka.” Nəpɨn Paelat rɨreɡi, rəseni Josef mə, “Ikukurən nevənien muvehi raka nɨpwran.” ");
INSERT INTO tnk_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josef revən muvehi nəmri tɨnari kani mə linen, muvehi raka nɨpwrai Iesu ia nei kamarkuaui, muveɡi irə. Muveɡi pam, muvehi mevən, məmri pen ia nɨpəɡi kəruəterei riti kɨnərai ərori raka, nənə məsəkwusəkwu kəruəterei asori riti mərəpinhə pen kwəruə irə. ");
INSERT INTO tnk_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ia nəpɨn nəha Meri Maktala mɨne Meri mama səvəi Joses krouətə kwopun nəha kəmri pen Iesu ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Rɨnaməruarəv, nəpɨn Sapat rɨno sampam, Meri Maktala, mɨne Salome, mɨne Meri mama səvəi Jemes, haruvehi nəmri nɨmwai nari me nepwɨn sə nɨpekɨnraha rapein amasan, mə tuharevən mharəmri pen ia nɨpwrai Iesu. ");
INSERT INTO tnk_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ia Sante, ia nəpnəpɨn anan, irəhar hənamarevən fwe ia nɨpəɡ. ");
INSERT INTO tnk_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ia suatuk kamharəres irəhar me i mə, “Sin nəha trasitu ia kɨtahar, məpəkɨr raka kəruəterei nəha ramo tukuahaɡ kwəruə ia nɨpəɡ?” ");
INSERT INTO tnk_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mətə nəpɨn harapirapw fwe ikɨn, harəti pen mharətoni kəruəterei asori nəha kɨnəpəkɨr raka raka i. ");
INSERT INTO tnk_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nənə harevən ia nəkwai nɨpəɡ, mharətoni iərmama riti raməkure ia nɨkarenrahar mwatuk, mamarkahu ia karkahu sə rəpwəmwɨs məpsan. Irəhar harətoni, nənimenrahar rier. ");
INSERT INTO tnk_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mətə iərmama nəha rɨni pen tɨ nirəhar i mə, “Nəmrɨmirəhar trəpwəh nierien. Hiamarətui Iesu, iəmə Nasaret sə kɨnərui tərini pen ia nei kamarkuaui. In riwən i. Rɨnətui raka ia nemhəien səvənhi. Harətoni ro kwopun kɨnəmri pen nɨpwran raməmak ikɨn. ");
INSERT INTO tnk_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mətə tiharevən mharni pen tɨ nərmama me səvənhi mɨne Pita mə Iesu trukupwən ia kɨmiaha mamevən fwe ia tənə Kalili. Kɨmiaha tihətoni in fwe ikɨn rəmwhen rɨməni tukumiaha i.” ");
INSERT INTO tnk_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nənə nɨprən mirəhar nəha harhekɨr pɨk, mharətəmnɨmwɨn, mharier, mharap ia nɨpəɡ. Mətə harəpwəh nəvisauien nəfe kɨməni pen tɨ nirəhar i, tɨ nəri nə mə harhekɨr. ");
INSERT INTO tnk_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sante ia nəpnəpɨn Iesu rətui mwi ia nemhəien səvənhi, mukupwən mier irapw tɨ Meri Maktala, pran sə fwe kupwən Iesu rɨnəkoui irapw nəremhə me irə irəha pam sefen. ");
INSERT INTO tnk_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Meri revən mətə nərmama me səməme kamharə pəri irəha Iesu kupwən. Kamhəkure tɨ Iesu, mamhasək tukwe. Meri ruvehe mɨni pen tɨ nirəha i mə “Iakɨnətə Iesu.” ");
INSERT INTO tnk_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nəpɨn həreɡi mə Iesu rɨnətui mwi ia nemhəien səvənhi, mhəreɡi mwi mə Meri rətoni, nənə həpkɨni mhə nɨpərhienien irə. ");
INSERT INTO tnk_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kurirə irə kəru ia nirəha krouier ia taon rouavən ia suatuk. Nənə Iesu rier irapw tɨ nirau. Krouətə nɨpwran ropə iti. ");
INSERT INTO tnk_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Iərman mi nəha krourərɨɡ rouevən tɨ nərmama me səvəi Iesu, rouəvisau mɨnraha, mətə irəha həpwəh nɨniien nɨpərhienien ia nəɡkiariien səvənrau. ");
INSERT INTO tnk_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kurirə irə nərmama me nəha səvəi Iesu irəha eleven kamhəkure mamhani pəri nari. Ia nəpɨn nəha Iesu rier irapw tɨ nirəha, maməski irəha tɨ nəri nə mə kənkapwənraha rɨskai. Nahatətəien səvənraha riwən. Hənəpwəh nɨniien nɨpərhienien ia nəɡkiariien səvəi Meri, mhəpwəh mwi nɨniien nɨpərhienien ia iərmama səməmi nəha krɨnouətoni Iesu mə rɨnətui pərhien mwi ia nemhəien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Iesu rɨni pen tɨ nirəha me i mə, “Həuvən ia kwopun me pam ia tɨprənə i, mhəvisau irapw nəɡkiariien amasan səiou m nərmama me pam. ");
INSERT INTO tnk_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Iərmama sə trɨni nɨpərhienien ia nəɡkiariien amasan səiou, ko paptaes irə, Kumwesən truvehimɨru in. Mətə iərmama sə trəpwəh nɨniien nɨpərhienien ia nəɡkiariien amasan səiou, Kumwesən trərpwɨn noien ərəha me səvənhi. ");
INSERT INTO tnk_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nərmama səməme kamhahatətə ia nirak tuho nɨmtətien me i. Irəha tuhəkoui irapw nəremhə me ia nərmama ia nəɡhɨk. Irəha tuhəɡkiari ia nəɡkiariien səvəi nəkur əpə. ");
INSERT INTO tnk_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Irəha tuhəuvehi snek me səməme kamhahi əpune nərmama. Trɨni mɨnuə irəha hənɨmwi nari riti kəvti pen nɨmwai nari sə ramousi əpune iərmama, ko rɨpkuəsi mhə irəha. Irəha tuhərapi nərmama səməme nemhəien rarə ia nirəha mho irəha həuvehe mhəsanɨn.” ");
INSERT INTO tnk_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nəpɨn Iesu Iərɨmənu rɨnəɡkiari pen pam mɨnraha, kuvehi utə in revən fwe ia neiai, məkure ia nɨkare Kumwesən mwatuk. ");
INSERT INTO tnk_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nənə nərmama me səvənhi həuvən mhəvisau ia kwopun me pam. Nəpɨn kamhəvisau irə, Iərɨmənu ramarə tɨ nirəha, mamo nɨmtətien me mə nərmama tuhətoni, mhəni nɨpərhienien ia nəɡkiariien amasan səvənhi. ");
INSERT INTO tnk_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nərmama həpɨk hənousari raka tɨ nɨrai penien ia nəkukuə narimnari me nəha Iesu rɨno fwe kupwən nəpɨn ramavən kɨmaha min. ");
INSERT INTO tnk_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Irəha həmərai pen nəɡkiariien me nəha nərmama həukurən amasan irə həməni pehe tukumaha i. Fwe ia nukune wok səvənhi, nərmama me nəha həukurən amasan irə hənətoni Iesu ia nənimenraha, nənə mamhəvisau irapw nəɡkiariien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Iou mwi iakɨnəskun pam raka narimnari me i mukurən amasan kɨnəfo irə fwe ia nukunen muvehe. Nənə təkwtəkwuni, iəmə asori Teofilas, iakreɡi ramasan mə pwəh iakrai pen ia nəkukuə riti mik. ");
INSERT INTO tnk_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Iakamo iamɨnhi irə mɨnuə tikukurən amasan nəɡkiariien sə kɨnahatən ik irə. In ro nɨpərhienien. ");
INSERT INTO tnk_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ia nəpɨn nəha Herot ramərɨmənu ia tənə Jutia pris riti nəɡhɨn nə Sekaraea. In pris riti ia təmwen səvənraha kani mə Pris me səvəi Apia. Səvənhi iərmama in pran riti sə ruku pen ia kwənəkwus səvəi Eron. Nəɡhɨn nə Elisapet. ");
INSERT INTO tnk_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Irau pəri noien səvənrau ratukwatukw ia nəmri Kumwesən. Ia nəpɨn me krauesi pen atukwatukw pam nəfe nəɡhɨn Loa səvəi Iərɨmənu rani. ");
INSERT INTO tnk_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mətə tɨnɨnrau riwən. Elisapet rɨpkəkwəhakwen mhə. In nɨprənemə. Sekaraea nərɡharə. ");
INSERT INTO tnk_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nəpɨn riti Sekaraea irəha təmwen səvənhi kamhowok səvəi pris me ia nəmri Kumwesən ia nimwə səvənhi. ");
INSERT INTO tnk_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nənə irəha hesi pen noien səvəi pris me mhəuini nari riti sə ramahatən nari. Trahatən pen mə sin trevən fwe ia nəkwai nimwə səvəi Iərɨmənu muvani nɨmwəkmwəki nari nɨpekɨn rapein amasan ia təkure nɨfatə. Həuini pen nəri nəha nənə rahatən pen Sekaraea. ");
INSERT INTO tnk_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ia nəpɨn atukwatukw sə kauvani nɨmwəkmwəki nari nɨpekɨn rapein amasan irə nərmama me kamhəfwaki fwe iruə. ");
INSERT INTO tnk_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nənə aɡelo riti səvəi Kumwesən rier pehe mamərer ia nɨkare nɨfatə mwatuk ia nəri kauvani nɨmwəkmwəki nari nɨpekɨn rapein amasan irə. ");
INSERT INTO tnk_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nəpɨn Sekaraea rətoni aɡelo nəha, rehekɨr pɨk mətəmnɨmwɨn. ");
INSERT INTO tnk_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mətə aɡelo rɨni pen tukwe in mə, “Sekaraea tikəpwəh nehekɨrien. Kumwesən ruvəreɡi raka nəfwakiien səim. Səim iərmama Elisapet trərəhi tɨnɨmirau riti iərman. Nənə tikɨseɡi pen nəɡhɨn nə mə Jon. ");
INSERT INTO tnk_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tikreɡi ramasan mamaɡien tukwe. Nəpɨn trətui, nərmama həpɨk mwi rerɨnraha traɡien tukwe. ");
INSERT INTO tnk_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","In truvehe mo iəmə asori ia nəmri Kumwesən. In trɨpkənɨmwi mhə waen uə nənɨmwiien skai. Nəpɨn in ramarə ihi ia tɨpwi mama səvənhi rerɨn ruvəukuər raka ia Nənɨmwɨn Ikinan. ");
INSERT INTO tnk_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","In tro nəkur Isrel me həpɨk hərərɨɡ mhəuvehe tɨ Iərɨmənu Kumwesən səvənraha. ");
INSERT INTO tnk_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","In trakupwən ia Iərɨmənu. Nətərɨɡien səvənhi mɨne nɨskaiien səvənhi trəmwhen ia nətərɨɡien mɨne nɨskaiien səvəi Profet Elaeja. In tro tata me hərərɨɡ ia rerɨnraha mə rerɨnraha trɨrhi mwi nɨpwnətɨnraha me. Nərmama səməme hamərui nəkwai Kumwesən in tro irəha hərərɨɡ mhəuvehe mhesi pen nətərɨɡien səvəi nərmama hatukwatukw. Ro iamɨnhi irə in tro nərmama həpnəpenə tɨ nuveheien səvəi Iərɨmənu.” ");
INSERT INTO tnk_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Mɨreɡi Sekaraea rɨni pen tɨ aɡelo i mə, “Takəfo mukurən mə nəri nəha tro iamɨnhi irə? Kwa iou iakɨnərɡharə səiou iərmama nɨprənemə.” ");
INSERT INTO tnk_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mɨreɡi aɡelo rɨni pen tukwe in mə, “Iou i Kapriel. Iakamərer ia nəmri Kumwesən. In rərhi pehe iou mə takuvehe məɡkiari pehe mik məvisau nəri amasan mik. ");
INSERT INTO tnk_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mətə tɨ nəri nə mə ipkɨni mhə nɨpərhienien ia nəɡkiariien səiou, ətə ro, rerɨm triwən. Tipkəɡkiari mhə mesite nəri iakɨməni pehe tukw ik i trier pehe. Trukuə ia nəpɨn atukwatukw səvənhi.” ");
INSERT INTO tnk_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ia nəpɨn nəha, fwe iruə, nərmama kamheitenhi Sekaraea. Hərkərinari mə in rəmak tui ia nəkwai nimwə səvəi Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nəpɨn rier irapw iruə, ko rɨpkəɡkiari mhə mɨnraha, mətə raməɡkiari a ia rəɡɨn. Hənətə həuvəukurən mɨnuə in rɨnətə nari riti rəmwhen ia nəməkrəhaien fwe nəkwai nimwəfwaki. ");
INSERT INTO tnk_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nəpɨn nəha Sekaraea ramowok pris irə fwe ia nimwə səvəi Kumwesən ruvehe mukurau, nənə in rɨrərɨɡ mevən fwe imwəni. ");
INSERT INTO tnk_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kurirə irə rɨpko mhə tui, nənə səvənhi iərmama Elisapet ro tɨpwɨn. Nəpɨn rɨno tɨpwɨn, raməmak afafa ia nəkwai nimwə səvənhi mesite pen məkwə krirum səvənhi, mamɨni mə, ");
INSERT INTO tnk_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Iərɨmənu rɨno nəri miou. Nəpɨn rəti irapw mətə iakamaurɨs ia nəmri nərmama tɨ nəri nə mə səiou iəkunouihi riwən, rerɨn raɡien ruvehi raka naurɨsien nəha ia nirak.” ");
INSERT INTO tnk_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisapet rɨno tɨpwɨn marə məkwə sikis. Ia nəpɨn nəha Kumwesən rərhi pen aɡelo riti nəɡhɨn nə Kapriel revən mə trətoni prənvi riti fwe ia taon riti ia tənə Kalili nəɡhɨn nə Nasaret. ");
INSERT INTO tnk_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Prənvi nəha ramreirei ihi iərman. Kɨnəsisəɡ raka in mɨnuə tresi pen iərman riti nəɡhɨn nə Josef. Josef in kwənəkwus riti səvəi Kiɡ Tevɨt. Prənvi nəha nəɡhɨn nə Meri. ");
INSERT INTO tnk_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aɡelo nəha rier pen tukwe in, mɨni mə, “Meri. Tiko maɡien. Iərɨmənu ramasan tukw ik mamarə tukw ik.” ");
INSERT INTO tnk_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mətə Meri nətərɨɡien səvənhi rəvsausɨni pɨk tɨ nəɡkiariien nəha mamətərɨɡ mə rəfo aɡelo rɨni pen tukwe in iamɨnhi. ");
INSERT INTO tnk_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nənə aɡelo nəha rɨni pen tukwe in mə, “Meri tikəpwəh nehekɨrien. Kumwesən ramasan tukw ik. ");
INSERT INTO tnk_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Reɡi ro! Tiko tɨpwɨm, mərəhi nərɨm riti iərman. Tikɨseɡi pen nəɡhɨn nə mə Iesu. ");
INSERT INTO tnk_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","In truvehe mo in iəmə asori. Tukəkwein in mə tɨni Kumwesən, Kumwesən sə rasori anan. Iərɨmənu Kumwesən səkɨmiaha truvehi pen nɨtətə səvəi rɨpwɨni Kiɡ Tevɨt min. ");
INSERT INTO tnk_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","In trərɨmənu ia nuk nuk me ia nərmama me səməme həuku pen ia kwənəkwus səvəi Jekop. Nɨtətə səvənhi trɨpkiwən mhə.” ");
INSERT INTO tnk_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mɨreɡi Meri rɨni pen tɨ aɡelo i mə, “Trəfo mo iamɨnhi. Iou prənvi. Iakreirei iərman?” ");
INSERT INTO tnk_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mɨreɡi aɡelo rɨni pen tukwe in mə, “Nənɨmwɨn Ikinan truvehe ia niram. Kumwesən sə rasori anan nɨskaiien səvənhi trəuiui ik. Ro iamɨnhi irə tukəkwein pen iəkunouihi ikinan nəha tikərəhi mɨnuə in Tɨni Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nənə reɡi ro. Ik riti fwe Elisapet nɨprənemə, mətə in mwi rɨno tɨpwɨn trərəhi tɨni riti iərman. Kani in mə pran sə rɨpkəkwəhakwen mhə, mətə ruvəuvehe mɨpəmpəm marə məkwə sikis. ");
INSERT INTO tnk_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Narimnari me pam rɨməru tɨ Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mɨreɡi Meri rɨni mə, “Iou pran sə iakamo tukwini nari m Iərɨmənu səiou. Pwəh rukuə ia nirak rəmwhen ia sə ikɨməni.” Nənə aɡelo nəha rəpwəh in mamevən. ");
INSERT INTO tnk_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ia nəpɨn nəha, rɨpko mhə tui, Meri rier mevən akwauakw fwe ia rukwənu riti ia təkure tənə ia Jutia, ");
INSERT INTO tnk_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","mevən ia nəkwai nimwə səvəi Sekaraea, maməɡkiari pen m Elisapet. ");
INSERT INTO tnk_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nəpɨn Elisapet rɨreɡi Meri raməɡkiari, tɨni rakurisei asori ia tɨpwɨn. Nənə Elisapet rerɨn ruvehe mukuər ia Nənɨmwɨn Ikinan. ");
INSERT INTO tnk_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Nənə in rəkwein əpwəmwɨs mɨni mə, “Meri Kumwesən ramasan tukw ik məpi raka pam nɨpran me. Ramasan mwi tɨ nərɨm sə tikərəhi. ");
INSERT INTO tnk_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Mama səvəi Iərɨmənu səiou ruvehe mətə iou. Rəfo ko nəri amasan ia nirak iamɨnhi? ");
INSERT INTO tnk_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Reɡi ro, nəpɨn ikapirapw məkwein iou, iakreɡi rerɨm, iəkunouihi ia tɨpwɨk rakurisei asori ia naɡienien. ");
INSERT INTO tnk_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Rerɨm traɡien tɨ nəri nə mə ikɨməni mə nɨpərhienien trukuə irə ia nəfe Iərɨmənu rɨməni pehe tukw ik i.” ");
INSERT INTO tnk_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mɨreɡi Meri rɨni mə, “Ia nɨmɨruien pam səiou iakauvehi utə nəɡhi Iərɨmənu səiou. ");
INSERT INTO tnk_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Rerɨk raɡien pɨk tɨ Kumwesən səiou sə rauvehimɨru iou. ");
INSERT INTO tnk_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Iou pran auər a sə iakamo tukwini nari min, mətə rerɨn ramrhi iou. Təkwtəkwuni mɨne mamevən nərmama pam tuhəni iou mə iou pran sə rerɨk ramaɡien, ");
INSERT INTO tnk_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","tɨ nəri nə mə Kumwesən i sə rɨskai pɨk rɨno narimnari asori me miou. Nəɡhɨn ro ikinan. ");
INSERT INTO tnk_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Napiien səvənhi ramarə tɨ nərmama me pam səməme kamhəsiai in, mamarə mwi tɨ nɨpwnətɨnraha me mɨne nɨmwipwɨnraha me mamevən. ");
INSERT INTO tnk_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","In ramo nɨmtətien me ia rəɡɨn əsanɨn, maməkoui irapw nərmama səməme kamhəfiəutə ia rerɨnraha. ");
INSERT INTO tnk_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","In rauvehi irapw kiɡ asori me ia kwopun kamhəkure ikɨn mamhərɨmənu, marə mauvehi utə mwi nəmə auər a me. ");
INSERT INTO tnk_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","In rauvei pen nəveɡɨnien amasan m nərmama səməme nukumhə ramahi irəha. Hani tɨpwɨnraha rəsisi. Mətə səməme nautə səvənraha rasori in ramərhi irapw irəha, mɨpkuvei pen mhə nari riti mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","In ramasitu ia kɨtaha nəkur Isrel. Kɨtaha nərmama me səvənhi samo tukwini nari min. In ramo iamɨnhi irə tɨ nəri nə mə rerɨn ramrhi napiien səvənhi ");
INSERT INTO tnk_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","rosi in rɨməni pen tɨ kaha kupwən me səkɨtaha. In rɨməni pen tɨ Epraham mə in trapi Epraham mɨne nərmama me ia kwənəkwus səvənhi ia nuk nuk me.” ");
INSERT INTO tnk_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meri rarə irau Elisapet meste məkwə kahar rukurau, nənə kurirə irə rɨrərɨɡ mevən fwe imwəni. ");
INSERT INTO tnk_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Rɨneste nəpɨn səvəi Elisapet trərəhi tɨni irə. Rərəhi tɨni iərman. ");
INSERT INTO tnk_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nərmama me ipaka tukwe mɨne nɨpərɨn me həreɡi mə Kumwesən rɨnapi asori in. Həuvehe mhətə in mamhaɡien pəri. ");
INSERT INTO tnk_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nəpɨn iəkunouihi səvənhi reste nəpɨn eit, həuvehi mhəuvehe mə tukuvehi ninhum min. Nətərɨɡien səvənraha mə tuhəseɡi pen nəɡhɨn nə Sekaraea, nəpwɨnhi tata səvənhi. ");
INSERT INTO tnk_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mətə səvənhi mama rɨni mə, “Rekəm. Tsəseɡi pen nəɡhɨn nə mə Jon” ");
INSERT INTO tnk_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mɨreɡi irəha həni pen tukwe in mə, “Mətə rəfo? Nahaɡ nəha riwən ia kwənəkwus səim.” ");
INSERT INTO tnk_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nənə irəha həɡkiari pen m tata səvənhi ia rəɡɨnraha, mhəres nəfe nahaɡ in rokeikei mə tuhəseɡi pen ia iəkunouihi. ");
INSERT INTO tnk_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sekaraea rəres nəri kamrai pen nari irə. Kuvehi pen min. Nənə rɨrai pen ianhi mə, “Nəɡhɨn nə Jon.” Nənə irəha pam hərkərinari irə. ");
INSERT INTO tnk_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ia nəpɨn nəha Sekaraea rerɨn rɨnarə mwi. Nənə in rɨnaməɡnəɡɨni Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nərmama me ia nɨkarkare rukwənu həreɡi həhekɨr. Nəɡkiariien nəha ruvirɨs ia kwopun me pam ia təkure tənə ia Jutia. ");
INSERT INTO tnk_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nərmama me pam səməme həreɡi nəɡkiariien nəha hamətərɨɡ irə mə, “Iəkunouihi nəha trəfo irə? Mətə in nə nɨskaiien səvəi Iərɨmənu ramarə irə.” ");
INSERT INTO tnk_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ia nəpɨn nəha Nənɨmwɨn Ikinan ruvehe mukuər ia reri Sekaraea, tata səvəi Jon, muvei pen nəɡkiariien min. Nənə Sekaraea rɨni mə, ");
INSERT INTO tnk_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Pwəh səɡnəɡɨni Iərɨmənu Kumwesən səkɨtaha nəkur Isrel. In ruvehe masitu ia kɨtaha nərmama me səvənhi meivinari ia kɨtaha. ");
INSERT INTO tnk_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","In ruvehi utə iəmə skai riti sə truvehimɨru kɨtaha. Iəmə skai nəha in kwənəkwus riti səvəi Kiɡ Tevɨt sə rɨnamo tukwini nari m Kumwesən fwe kupwən. ");
INSERT INTO tnk_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nəri nəha ramesi pen nəɡkiariien me səməme Kumwesən rɨməni pehe tukutaha i ia tərhui profet ikinan me səvənhi fwe kupwən. ");
INSERT INTO tnk_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","In rɨməni mə truvehimɨru kɨtaha, muvehi raka kɨtaha ia rəɡi nərmama me pam səməme kamhometə kɨtaha, mamhəmwəki kɨtaha. ");
INSERT INTO tnk_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","In rɨməni mə trapi kaha kupwən me səkɨtaha, məpwəh nenouenouien nəɡkiariien ikinan səvənhi. ");
INSERT INTO tnk_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Promes nəha in rɨməuvei pen m kaha kupwən səkɨtaha Epraham, mauvehi kwəsuahi tukwe. ");
INSERT INTO tnk_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","In rɨməni mə nəpɨn truvehi raka kɨtaha ia rəɡi nərmama səməme haməmwəki kɨtaha, in trəseni kɨtaha tso tukwini nari min, mhəpwəh nehekɨrien. ");
INSERT INTO tnk_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kɨtaha tsəmher mhatukwatukw ia nənimen ia nəpɨn me pam ia nɨmɨruien səkɨtaha. ");
INSERT INTO tnk_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nənə ik, nərɨk, tukɨni mə Kumwesən sə rasori anan, profet riti səvənhi nə ik, tɨ nəri nə mə tikukupwən məpərhi suatuk me səvəi Iərɨmənu səkɨtaha, nənə in trukurirə. ");
INSERT INTO tnk_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Tikɨni irapw tɨ nərmama me səvənhi mə Kumwesən truvehimɨru irəha, məpwəh nərpwɨnien noien ərəha me səvənraha. ");
INSERT INTO tnk_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kumwesən səkɨtaha in ramasan pɨk, mamapi kɨtaha. Ia napiien nəha səvənhi in trərhi pehe Kristo ruku pen fwe ia neiai, muvehe tukutaha rəmwhen ia meri rautə ia nəpnəpɨn. ");
INSERT INTO tnk_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","In truvei pen nukuraanien m nərmama səməme kamhəkure ia nəpitəvien mɨne təmwkəmwi nemhəien. In triri nɨsutaha ia suatuk səvəi nəmərinuien.” ");
INSERT INTO tnk_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nənə iəkunouihi nəha rapwinari, mauvehe mɨskai ia nənɨmwɨn. Ia nəpɨn me ramarə fwe ia kwopun akwesakwes ikɨn meste nəpɨn nəha in rier irapw ia nəmri nəkur Isrel. ");
INSERT INTO tnk_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nəpɨn Jon rɨnətui raka, Kiɡ Sisa Okastas, iəmə Rom sə ramərɨmənu ia tənəmtənə me, rɨni nəkwan mɨnuə nərmama me ia kwopun me tuhaməkeikei mhərərɨɡ pen fwe imwənraha atukwatukw mɨnuə tukəvsini irəha. ");
INSERT INTO tnk_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Noien nəha kɨməkupwən ko ia nəpɨn nəha Kwaerinias ramərɨmənu ia tənə Siria. ");
INSERT INTO tnk_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nərmama me pam hərərɨɡ mamhəuvən imwənraha me mɨnuə tuhəuvehi pen nəɡhɨnraha. ");
INSERT INTO tnk_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josef rier ia taon nəha Nasaret ia tənə Kalili, mevən ia tənə Jutia ia taon səvəi Kiɡ Tevɨt fwe kupwən kani mə Petlehem, mamevən fwe ikɨn tɨ nəri nə mə ruku pen ia kwənəkwus səvəi Kiɡ Tevɨt. ");
INSERT INTO tnk_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Krauevən irau Meri mɨnuə tukuvehi nəɡhɨnrau. Josef rɨnəsisəɡ raka Meri. Meri rɨno tɨpwɨn. ");
INSERT INTO tnk_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nəpɨn irau krouarə ikɨn, Meri rɨneste nəpɨn atukwatukw səvənhi mə trərəhi iəkunouihi irə. ");
INSERT INTO tnk_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Rərəhi tɨni iərman, nəmritaik. Rərəhi, muveɡi ia tɨnari, məmri pen ia nɨtətə kaməkwməni nərimɨru me irə. In ro iamɨnhi irə tɨ nəri nə mə nimwə nəha nərmama kamhərəku pen mamhapri ikɨn ruvəukuər. ");
INSERT INTO tnk_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ia kwopun nəha nərmama nepwɨn sə kamhətui tɨ sipsip kamhəmak ia nɨkare taon nəha iruə, mamhətui tɨ sipsip me səvənraha ia nəpɨn. ");
INSERT INTO tnk_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Aɡelo riti səvəi Iərɨmənu reiwaiu pehe mərer ia nɨkarenraha. Nukuraanien səvəi Iərɨmənu rəhiəpwɨn irəha. Nənə irəha həhekɨr pɨk. ");
INSERT INTO tnk_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mətə aɡelo nəha rɨni pen tɨ nirəha i mə, “Kɨmiaha tihəpwəh nehekɨrien. Həreɡi ro! Iou takəvisau nəɡkiariien amasan anan m kɨmiaha. Nərmama pam tuhaɡien asori tukwe. ");
INSERT INTO tnk_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ipwet ia taon səvəi Kiɡ Tevɨt kupwən kwəti iəkunouihi riti rɨnətui. In Kristo, Iərɨmənu səkɨtaha. Kumwesən ruvərfi raka in mə truvehe tukumiaha muvehimɨru kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nəri tro nɨmtətien m kɨmiaha. Tihəuvən mhətoni kwəti iəkunouihi kuveɡi ia tɨnari raməmak ia nɨtətə kaməkwməni nərimɨru me irə.” ");
INSERT INTO tnk_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aɡelo nəha rəɡkiari pam, nənə təkwtəkwuni a mwi irə naɡelo me həpɨk həuku pen fwe ia neiai mhərer irəha min, mamhəɡnəɡɨni Kumwesən mamhani nɨpu mə, ");
INSERT INTO tnk_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kaməɡnəɡɨni Kumwesən fwe irənhə anan. Ia tɨprənə i nəmərinuien trarə tɨ nərmama me səməme Kumwesən rerɨn raɡien tɨ nirəha.” ");
INSERT INTO tnk_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nəpɨn naɡelo me həpwəh irəha mhərərɨɡ pen fwe ia neiai, nərmama me nəha səməme kamhətui tɨ sipsip me həni pen tɨ nirəha me i mə, “Pwəh səuvən fwe Petlehem mhətə ro nəri Iərɨmənu rɨməni pehe tukutaha i.” ");
INSERT INTO tnk_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nənə irəha havən akwauakw mhəuvən mhətoni Meri mɨne Josef mɨne kwəti iəkunouihi sə ramapri ia nɨtətə kaməkwməni nərimɨru me irə. ");
INSERT INTO tnk_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nəpɨn hətoni iəkunouihi nəha, həni irapw nəfe aɡelo rɨməni pen tɨ nirəha i. ");
INSERT INTO tnk_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nənə nərmama me pam səməme hamreɡi hərkərinari ia nəɡkiariien səvənraha. ");
INSERT INTO tnk_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mətə Meri rəkwtəmhiri pam narimnari me nəha ia rerɨn mamətərɨɡ tukwe. ");
INSERT INTO tnk_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nənə nərmama me nəha səməme kamhətui tɨ sipsip hamərərɨɡ mamhəɡnəɡɨni Kumwesən mamhəuvehi utə nəɡhɨn tɨ narimnari me nəha hənətoni mhəreɡi rosi kɨməni pen tɨ nirəha i. ");
INSERT INTO tnk_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nəpɨn sə ro eit irə kuvehi ninhum m iəkunouihi nəha, kseɡi pen nəɡhɨn nə mə Iesu, nəhaɡ sə aɡelo rɨməkupwən muvei pen m Meri nəpɨn rɨpko mhə ihi tɨpwɨn. ");
INSERT INTO tnk_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nənə rɨno nəpɨn sə Josef mɨne Meri tro narimnari me nəha Loa səvəi Moses rɨni mə tro irau krouvehe rouəmher mwi tɨ nəfwakiien. Ia nəpɨn nəha krouərəhi Iesu, rouevən fwe ia Jerusalem mə trouvei pen m Iərɨmənu. ");
INSERT INTO tnk_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Noien nəha ramesi pen nəɡkiariien i kɨmərai pen ia Loa səvəi Iərɨmənu. Rɨni mə, “Nəmritaik me pam nərman me tukəkwein irəha mə nəkwərhakwərha ikinan me səvəi Iərɨmənu.” ");
INSERT INTO tnk_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Irau krouevən mwi mə trouvei pen nərimɨru riti tukousi əpune kuvei pen m Iərɨmənu. Noien nəha ramesi pen nəɡkiariien i sə raməmak ia Loa səvənhi. Rɨni mə, “Nərmama me iamɨnhi tuhəuvei pen mak kəru uə kwəti menu kəru.” ");
INSERT INTO tnk_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Iərmama riti ia Jerusalem nəɡhɨn nə Simeon. In iəməfwaki riti. Noien səvənhi ratukwatukw. In rameitenhi nəpɨn nəha iəmə nəha kani mə Kristo truvehe irə, nənə muvehimɨru nəkur Isrel. Nənɨmwɨn Ikinan rarə ia Simeon. ");
INSERT INTO tnk_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nənɨmwɨn Ikinan nəha rɨnahatən raka in mə ko in rɨpkemhə mhə meste trətoni Kristo nəha Kumwesən rɨməni mə trərhi pehe i. ");
INSERT INTO tnk_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nənɨmwɨn Ikinan riri pen Simeon revən ia nəkwai nimwə səvəi Kumwesən. Nəpɨn Josef mɨne Meri krouərəhi iəkunouihi nəha Iesu, rouuvnimwə pehe mə tro narimnari me nəha Loa səvəi Iərɨmənu rɨni, ");
INSERT INTO tnk_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon rərəhi pehe Iesu ia rəɡɨn mi, məɡnəɡɨni Kumwesən tukwe, mɨni mə, ");
INSERT INTO tnk_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Iərɨmənu. Ikɨno nəɡkiariien səim ruvəuvehe muvəukuə. Iou iərmama sə iakamo tukwini nari mik. Təkwtəkwuni nəha iakukurən nemhəien, mətə nəmərinuien trarə tukw iou. ");
INSERT INTO tnk_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nənimek rɨnətoni suatuk səim sə tikuvehimɨru nərmama me irə. ");
INSERT INTO tnk_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ikɨnəpnəpenə raka suatuk i ia nəmri nərmama ia kwopun me pam. ");
INSERT INTO tnk_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Iəkunouihi i truvei pen nukuraanien mɨne nərmama rɨpko mhə irəha nəkur Isrel. Irəha tuhətə nari, mhəɡnəɡɨni səim nərmama me nəkur Isrel tukwe.” ");
INSERT INTO tnk_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nəpɨn Josef mɨne Meri kroureɡi nəɡkiariien nəha Simeon rani ia iəkunouihi səvənrau, krouərkərinari irə. ");
INSERT INTO tnk_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Nənə Simeon rəkwein amasan mwi ia nirau, mɨni pen tɨ Meri mama səvəi iəkunouihi nəha mə, “Reɡi ro! Kumwesən ruvərfi raka iəkunouihi i mə tro nəkur Isrel həpɨk həmwei, nənə marə mo mwi həpɨk hərer. In trəmwhen ia nɨmtətien riti. Nərmama həpɨk tuhəni ərəha in, ");
INSERT INTO tnk_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","nənə mho nərmama hətoni nətərɨɡien me səvənraha sə kamhərkwafə ia rerɨnraha. Nənə ik mwi tikreɡi nəmisəien fwe ia rerɨm rəmwhen kəpi ik ia nau.” ");
INSERT INTO tnk_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Pran riti nəha ikɨn nəɡhɨn nə Ana. In profet riti. Tata səvənhi nəɡhɨn nə Fanuel. In kwənəkwus riti səvəi Aser fwe kupwən. Nəpɨn Ana rɨnaməprən vi ihi, in rerə, mamarə irau səvənhi iərman nuk sefen. Kurirə irə iərman səvənhi remhə məpwəh in. Nənə prən nəha rarə iamɨnhi muvehe meste in rɨnəprənemə. Nuk səvənhi eiti foa. Ia nəpɨn me Ana rɨpkier mhə ia nəkwai nimwə səvəi Kumwesən. Mətə ia nəpɨn mɨne ia ran ramsiai Kumwesən, maməpwəh nəveɡɨnien, maməfwaki. ");
INSERT INTO tnk_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nəpɨn Simeon raməɡkiari ia iəkunouihi nəha, təkwtəkwuni a mwi Ana rier pehe, mɨnani tanak tɨ Kumwesən, mɨnaməɡkiari ia iəkunouihi nəha m nərmama səməme kamheitenhi Kristo mə truvehe meivinari ia Jerusalem. ");
INSERT INTO tnk_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nəpɨn Josef mɨne Meri krɨno pam narimnari me nəha Loa səvəi Iərɨmənu rɨni, krourərɨɡ rouevən fwe tənə Kalili ia taon səvənrau Nasaret. ");
INSERT INTO tnk_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nənə iəkunouihi nəha rapwinari. Nɨpwran ruvehe mamskai. Nukurənien səvənhi rautə pehe. Ia nəpɨn me Kumwesən raməkwein amasan irə. ");
INSERT INTO tnk_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ia nuk me pam tata mɨne mama səvəi Iesu krauesi pen narəien səvəi nəkur Isrel, rauevən fwe Jerusalem nəpɨn kamho nəveɡɨnien asori nəha Pasova. ");
INSERT INTO tnk_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nəpɨn Iesu səvənhi nuk twelef, həutə pen fwe ikɨn rəmwhen kamho ia nuk me pam. ");
INSERT INTO tnk_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nəpɨn həno pam nəveɡɨnien asori nəha, nərmama me kamhərərɨɡ mamhəuvən fwe imwənraha me, mətə təmaruə nəha Iesu ramo a fwe Jerusalem. Səvənhi tata mɨne mama kroureirei. ");
INSERT INTO tnk_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Rerɨnrau ramrhi mə ramavən irəha nərmama səməme kamhərərɨɡ mamhəuvən fwe imwənraha. Ia nəpɨn pekɨn kamhəuvən iamɨnhi, nənə irau krɨnauətui in ia kwənəkwus səvənrau mɨne nərmama səməme krouukurən amasan irəha. ");
INSERT INTO tnk_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nəpɨn krouəpwəh nətəien Iesu, krourərɨɡ, rouevən fwe Jerusalem, rouətui in. ");
INSERT INTO tnk_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nəpɨn kahar rukurau, nənə krouətə in fwe ia nəkwai nimwə səvəi Kumwesən. Raməkure ia kurkwai nahatən me səvəi nəkur Isrel, mamətərɨɡ irəha, maməres irəha nəresien me nepwɨn. ");
INSERT INTO tnk_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nərmama me pam səməme kamhətərɨɡ in, nənimenraha rier tɨ nəri nə mə Iesu ramərai pen amasan nɨpwrai nəɡkiariien mɨnraha, mukurən amasan nari. ");
INSERT INTO tnk_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nəpɨn tata mɨne mama səvənhi krouətə in, irau mwi nənimenrau rier. Nənə mama səvənhi rɨni pen tukwe in mə, “Nərɨk, rəfo iko iamɨnhi irə ia kɨmrau? Ətə ro! Kɨmrau tata səim iarouətui əmisə ik, rouhekɨr pɨk.” ");
INSERT INTO tnk_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mɨreɡi Iesu rɨni pen tɨ nirau i mə, “Rəfo kɨmirau irouətui iou? Rosi iroureirei mə takaməkeikei marə ia nəkwai nimwə səvəi Tata səiou?” ");
INSERT INTO tnk_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mətə irau kroureirei nɨpwrai nəɡkiariien nəha Iesu rani pen tɨ nirau i. ");
INSERT INTO tnk_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kurirə irə Iesu reiwaiu mevən fwe ia Nasaret irəhar mɨnrau, mamsiai irau. Ia nəpɨn me mama səvənhi rerɨn ramrhi narimnari me nəha, mamətərɨɡ tukwe. ");
INSERT INTO tnk_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nənə Iesu nɨpwran mɨne nukurənien səvənhi krouvehe rouasori. Kumwesən mɨne nərmama kamhəkwein amasan irə. ");
INSERT INTO tnk_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Taepirias Sisa, kiɡ səvəi nəkur Rom, rɨnərɨmənu raka nuk fiftin. Ia nəpɨn nəha Ponjes Paelat in iəmə Rom sə ramərɨmənu ia tənə Jutia. Herot in iəmə Rom sə ramərɨmənu ia tənə Kalili. Piəvi Herot nəɡhɨn nə Filip in iəmə Rom sə ramərɨmənu ia kwopun mi nəha kəru Ituria mɨne Trakonaetas. Lisanias in iəmə Rom sə ramərɨmənu ia Apilin. ");
INSERT INTO tnk_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anas mɨne Kaeafas irau iəmə Isrel mi sə krauvehi wok səvəi pris asori anan ia Jerusalem. Nəpɨn irau krouvehi wok nəha, Kumwesən rəɡkiari m Jon tɨni Sekaraea ia kwopun akwesakwes ikɨn. ");
INSERT INTO tnk_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nənə Jon revən ia kwopun me pam ipaka tɨ nui arɨs Jotan, mamɨni irapw tɨ nərmama mə, “Kɨmiaha tihaməkeikei mhərərɨɡ ia noien ərəha me səkɨmiaha, mho paptaes, nənə Kumwesən trəpwəh nərpwɨnien noien ərəha me səkɨmiaha.” ");
INSERT INTO tnk_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nəri nəha ramesi pen nəɡkiariien i kɨmərai pen ia nəkukuə səvəi Profet Aesea. Rɨni mə, “Iərmama riti raməkwein əpwəmwɨs ia kwopun akwesakwes ikɨn mamɨni mə, ‘Kɨmiaha tihaməkeikei mhəpərhi suatuk səvəi Iərɨmənu səkɨtaha, mhəmri atukwatukw suatuk ouihi me səvənhi. ");
INSERT INTO tnk_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nəkwətənə me pam tukərhavən irəha. Təkuər me mɨne nahakw me tukuvehi irapw pam irəha. Suatuk ikou me tuko irəha həuvehe mhatukwatukw. Suatuk me kamhapətiapəti tukeipeni irəha pwəh həuvehe mhəpwiə, ");
INSERT INTO tnk_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","nənə nərmama me pam tuhətə suatuk sə Kumwesən truvehimɨru nərmama me irə.’” ");
INSERT INTO tnk_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nərmama həpɨk həuvən tɨ Jon mə tro paptaes ia nirəha. In rani pen tɨ nirəha i mə, “Kɨmiaha hiəmwhen ia snek me kamhahi əpune nərmama. Kumwesən niemaha rəpi. Rɨpko mhə tui in trərpwɨn noien ərəha me səkɨmiaha. Sin rɨni pehe tukumiaha i mə tihap raka irə? ");
INSERT INTO tnk_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kɨmiaha tihaməkeikei mho noien amasan me trahatən pen mə kɨmiaha hiənəpwəh pərhien noien ərəha me səkɨmiaha. Rərəha kɨmiaha tihəni pen tukumiaha me i mə Epraham in kaha səkɨmiaha. Iakani pehe tukumiaha i mə Kumwesən rukurən nuvehiien kəruəterei me i, mo nɨpwnəti Epraham me ia nirəha. ");
INSERT INTO tnk_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","In rɨnərpwi pen raka paha səvənhi ia nuai nei me na trərai. Nei me pam səməme həpkukuə mhə nukwai nei amasan in trərai əmwesi, mousə pen irəha ia napw.” ");
INSERT INTO tnk_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nərmama me nəha həres pen Jon i mə, “Nəfe nəha kɨmaha taho?” ");
INSERT INTO tnk_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Mɨreɡi Jon rɨni pen tɨ nirəha i mə, “Iərmama karkahu səvənhi kəru traməkeikei muvehi pen riti m iərmama karkahu səvənhi riwən. Iərmama nəveɡɨnien sənəni rasori traməkeikei mo mwi iamɨnhi masitu ia iərmama nəveɡɨnien sənəni riwən.” ");
INSERT INTO tnk_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ia nəpɨn nəha nərmama nepwɨn səməme kamərəku pen takis mɨnraha irəha mwi həuvehe mə Jon tro paptaes ia nirəha. Irəha həni pen tukwe in mə, “Iahatən, nəfe nəha kɨmaha taho?” ");
INSERT INTO tnk_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Mɨreɡi Jon rɨni pen tɨ nirəha i mə, “Kɨmiaha tihəpwəh nuvehiien mane rəpi raka sə kɨməni mə tihəuvehi.” ");
INSERT INTO tnk_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Naruaɡən me nepwɨn irəha mwi həres pen Jon i mə, “Nənə kɨmaha, kɨmaha taho nəfe?” Mɨreɡi Jon rɨni pen tɨ nirəha i mə, “Kɨmiaha tihəpwəh nəkeikeiien m nərmama mheikuə ia nirəha mə tiho nəmisəien mɨnraha trɨni mɨnuə həpkuvei pehe mhə mane m kɨmiaha. Rerɨmiaha traməkeikei maɡien tɨ nərəkuien səkɨmiaha.” ");
INSERT INTO tnk_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ia nəpɨn nəha nərmama me kamheitenhi mə Jon tro nari riti. Nərmama me pam rerɨnraha rarhi mə rosi Jon in Kristo, iəmə nəha Kumwesən rɨməni mə trərhi pehe i. ");
INSERT INTO tnk_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mətə Jon rɨni pen tɨ nirəha i mə, “Iou iakamo paptaes ia kɨmiaha ia nui, mətə iərmama səvənhi nɨskaiien rasori məpi raka iou, in nə rauvehe kurirə ia nirak. Iou iapkəmwhen mhə mə takɨfi raka nəkwus ia səvənhi put. In tro paptaes ia kɨmiaha ia Nənɨmwɨn Ikinan mɨne ia napw. ");
INSERT INTO tnk_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Fok səvənhi, in rarukwi utə nuni nari me irə rɨnəmak raka ia rəɡɨn, na trɨrukwi utə nuni nari me səvənhi irə tɨ nuaiien nunɨn mɨne tekɨn. In trɨpeki nuni nari me sə ramasan mevən ia nimwə səvənhi sə ramoeite nəveɡɨnien ikɨn, mətə tekɨn sə rərəha in trɨhiai pen napw irə, napw sə trɨpkɨfwə mhə.” ");
INSERT INTO tnk_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ia nəɡkiariien me rɨpɨk mwi Jon raməvisau irapw nəɡkiariien amasan m nərmama, mamousari mə tro irəha hərərɨɡ ia noien ərəha me səvənraha. ");
INSERT INTO tnk_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Mətə ia nəpɨn nəha Herot, iəmə Rom sə ramərɨmənu ia tənə Kalili, rakres pran səvəi piəvni. Prən nəha nəɡhɨn nə Herotias. Jon rəɡkiari m Herot, mɨni mə noien nəha mɨne noien me rɨpɨk mwi Herot rɨno hərəha. ");
INSERT INTO tnk_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nənə Herot rarə makutan pen mwi nərəhaien riti mwi ia nərəhaien me nəha səvənhi, muvehi puvnimwə Jon ia kalapus. ");
INSERT INTO tnk_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nəpɨn Jon ramo paptaes ihi ia nərmama, ro paptaes mwi Iesu. Ia nəpɨn nəha Iesu raməfwaki, mətoni kəpuapen rəkwaɡ, ");
INSERT INTO tnk_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Nənɨmwɨn Ikinan rosi mak inhərɨpw reiwaiu pehe məkure irə, nənə reri Kumwesən ruku pen ia neiai, mɨni mə, “Ik nərɨk keikei. Rerɨk raɡien tukw ik.” ");
INSERT INTO tnk_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nəpɨn Iesu rɨnamostat wok səvənhi, wok səvəi nəvisauien, nuk səvənhi rəmwhen ia toti. Nərmama me rerɨnraha ramrhi mə in tɨni Josef. Josef in tɨni Heli. ");
INSERT INTO tnk_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli in tɨni Matat. Matat in tɨni Livae. Livae in tɨni Melki. Melki in tɨni Janae. Janae in tɨni Josef. ");
INSERT INTO tnk_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josef in tɨni Matatias. Matatias in tɨni Amos. Amos in tɨni Neham. Neham in tɨni Esli. Esli in tɨni Nanɡae. ");
INSERT INTO tnk_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nanɡae in tɨni Mahat. Mahat in tɨni Matatias. Matatias in tɨni Semein. Semein in tɨni Josek. Josek in tɨni Jota. ");
INSERT INTO tnk_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jota in tɨni Joanan. Joanan in tɨni Resa. Resa in tɨni Serupapel. Serupapel in tɨni Sealtiel. Sealtiel in tɨni Neri. ");
INSERT INTO tnk_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri in tɨni Melki. Melki in tɨni Ati. Ati in tɨni Kosam. Kosam in tɨni Elmatam. Elmatam in tɨni Ere. ");
INSERT INTO tnk_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ere in tɨni Josua. Josua in tɨni Elieser. Elieser in tɨni Jorim. Jorim in tɨni Matat. Matat in tɨni Livae. ");
INSERT INTO tnk_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livae in tɨni Simeon. Simeon in tɨni Juta. Juta in tɨni Josef. Josef in tɨni Jonam. Jonam in tɨni Eliakim. ");
INSERT INTO tnk_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim in tɨni Melea. Melea in tɨni Mena. Mena in tɨni Matataha. Matataha in tɨni Natan. Natan in tɨni Kiɡ Tevɨt. ");
INSERT INTO tnk_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Kiɡ Tevɨt in tɨni Jese. Jese in tɨni Opet. Opet in tɨni Poas. Poas in tɨni Salmon. Salmon in tɨni Nason. ");
INSERT INTO tnk_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason in tɨni Aminatap. Aminatap in tɨni Atmin. Atmin in tɨni Arni. Arni in tɨni Hesron. Hesron in tɨni Peres. Peres in tɨni Juta. ");
INSERT INTO tnk_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juta in tɨni Jekop. Jekop in tɨni Aesak. Aesak in tɨni Epraham. Epraham in tɨni Tera. Tera in tɨni Nehor. ");
INSERT INTO tnk_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nehor in tɨni Seruɡ. Seruɡ in tɨni Rehu. Rehu in tɨni Pelek. Pelek in tɨni Epar. Epar in tɨni Sela. ");
INSERT INTO tnk_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela in tɨni Kaenan. Kaenan in tɨni Apaksat. Apaksat in tɨni Sem. Sem in tɨni Noa. Noa in tɨni Lamek. ");
INSERT INTO tnk_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek in tɨni Metusela. Metusela in tɨni Inok. Inok in tɨni Jaret. Jaret in tɨni Mahalalel. Mahalalel in tɨni Kenan. ");
INSERT INTO tnk_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan in tɨni Enos. Enos in tɨni Set. Set in tɨni Atam. Atam in tɨni Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Nəpɨn Iesu rəpwəh nui arɨs Jotan mə trɨrərɨɡ mevən ia tənə Kalili, rerɨn rukuər ia Nənɨmwɨn Ikinan. Nənɨmwɨn nəha riri pen in revən fwe ia kwopun akwesakwes ikɨn. ");
INSERT INTO tnk_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ia kwopun nəha Setan rəmwur nəpɨn foti mə tro Iesu rɨmwei ia nərəhaien. Ia nəpɨn nəha Iesu rəpwəh nəniien nari. Nəpɨn foti me nəha həuvehe mhəukurau pam, nənə in rɨreɡi nukumhə rɨnahi. ");
INSERT INTO tnk_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nənə Setan rɨni pen tukwe in mə, “Trɨni mɨnuə ik Tɨni Kumwesən pərhien, ni pen tɨ kəpwier i mə truvehe mo nəveɡɨnien irə.” ");
INSERT INTO tnk_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Mɨreɡi Iesu rɨni pen tukwe in mə, “Kɨmərai pen ia Nəkukuə Ikinan mə, ‘Iərmama trəpwəh nɨmɨruien ia nəveɡɨnien əpa.’” ");
INSERT INTO tnk_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ia nəpɨn nəha Setan ruvehi Iesu mutə mahatən nɨtətə me pam kiɡ me kamhərɨmənu ia nirəha ia təkure tɨprənə i, ");
INSERT INTO tnk_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","nənə mɨni pen tukwe in mə, “Takuvei pehe nasoriien mik ikərɨmənu ia nɨtətə me pam nəha. Nautə amasan me pam ia nirəha tuho səim ia nirəha. Nautə me nəha hənəmak raka ia rəɡɨk. Iakukurən nuvei penien m sin nəɡhɨn iakokeikei mə takuvei pen min. ");
INSERT INTO tnk_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ro iamɨnhi irə trɨni mɨnuə ikɨsiai iou, mɨnɨmwi nukurhum mi ia nənimek, narimnari me pam nəha tuhəuvehe mho səim irə.” ");
INSERT INTO tnk_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Mɨreɡi Iesu rɨni pen tukwe in mə, “Kɨmərai pen ia Nəkukuə Ikinan mə, ‘Tikɨsiai Iərɨmənu Kumwesən səim, mɨnɨmwi nukurhum mi ia nənimen. In əpa nə tiko nəkwan.’” ");
INSERT INTO tnk_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ia nəpɨn nəha Setan ruvehi Iesu mevən fwe ia Jerusalem, mukurei pen in ia kwopun riti irənhə anan ia təkure nimwə səvəi Kumwesən, nənə mɨni pen tukwe in mə, “Trɨni mɨnuə ik Tɨni Kumwesən pərhien, ivə irapw ia kwopun i. ");
INSERT INTO tnk_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kɨmərai pen ia Nəkukuə Ikinan mə, ‘Kumwesən trɨni pen tɨ naɡelo me səvənhi mə irəha tuhaməkeikei mhətui amasan tukw ik, ");
INSERT INTO tnk_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","mhəuvehi utə ik ia rəɡɨnraha, kamo ikouini nɨsum ia kəruəterei riti.’” ");
INSERT INTO tnk_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Mɨreɡi Iesu rɨni pen tukwe in mə, “Nəkukuə Ikinan rani mə, ‘Tikəpwəh neipweipwiien Iərɨmənu Kumwesən səim.’” ");
INSERT INTO tnk_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Setan ramousari iamɨnhi irə mə tro Iesu rɨmwei ia nərəhaien me nəha. Nəpɨn ro sampam, rəpwəh Iesu mamevən mə tɨ nəpɨn riti ruvehe mwi tukwe. ");
INSERT INTO tnk_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kurirə irə Iesu rɨrərɨɡ, mevən ia tənə Kalili, nɨskaiien səvəi Nənɨmwɨn Ikinan rarə irə. Nəɡkiariien sə raməvisau in ruvirɨs mevən ia kwopun me pam ia tənə nəha. ");
INSERT INTO tnk_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nənə in ramahatən nərmama ia nəkwai nimwəfwaki me səvəi nəkur Isrel. Nərmama me pam kamhəuvehi utə nəɡhɨn. ");
INSERT INTO tnk_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nənə Iesu ruvehe ia Nasaret, kwopun nəha in rɨməpwinari ikɨn. Ia Sapat in ruvnimwə ia nimwəfwaki səvəi nəkur Isrel rəmwhen ramo ia Sapat me pam, mərer mə trəvsini irapw Nəkukuə Ikinan. ");
INSERT INTO tnk_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nənə iərmama riti ruvehi nɨmwai nəkukuə nəha kɨnərfe kɨrai pen nəɡkiariien səvəi Profet Aesea irə, muvehi muvei pen m Iesu. Nənə Iesu ruvehi mɨvi atukw i, mətui mətoni kwopun kɨmərai pen nəɡkiariien i rɨni iamɨnhi irə mɨnuə: ");
INSERT INTO tnk_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Nənɨmwɨn səvəi Iərɨmənu ramarə ia nirak, tɨ nəri nə mə in ruvərfi raka iou mə takaməkeikei mɨni irapw nəɡkiariien amasan tɨ nərmama nautə səvənraha riwən. In rərhi pehe iou iakuvehe mə takɨni irapw iamɨnhi irə mə, ‘Kɨmiaha səməme hiamarə ia kalapus takeivinari ia kɨmiaha, nənə səməme nənimemiaha rɨfwə tako kɨmiaha hiətui mhətə nari.’ In rərhi pehe iou iakuvehe mə takeivinari ia nərmama səməme kamometə irəha, ");
INSERT INTO tnk_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","nənə mɨni irapw mə nuk nəha Iərɨmənu truvehimɨru nərmama me səvənhi irə ruvəuvehe.” ");
INSERT INTO tnk_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nəpɨn Iesu rəvsini irapw pam nəɡkiariien nəha, rəsisəɡ nəkukuə, muvei pen mɨne iərmama sə ramətui tɨ nəkukuə me, nənə məkure. Nərmama me pam ia nəkwai nimwəfwaki nəha səvəi nəkur Isrel nənimenraha revən tukwe. ");
INSERT INTO tnk_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nənə Iesu rɨni pen tɨ nirəha i mə, “Nəɡkiariien i ia Nəkukuə Ikinan kɨmiaha hiamreɡi ipwet i ruvəuvehe muvəukuə.” ");
INSERT INTO tnk_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nərmama me pam nəha haməni amasan Iesu. Irəha hamərkərinari ia nəɡkiariien amasan me səməme kamhəuku pen ia tərhun. Mətə kurirə həni mə, “Rosi a mə tɨni Josef nəha uə?” ");
INSERT INTO tnk_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Iakreɡi kɨmiaha hiokeikei mə tihəni pehe tukw iou i nəɡkiariien i kani rerɨn mə: ‘Tokta. Tikukupwən muvehimɨru atukw a ik pwəh kɨmaha iahəni nɨpərhienien ia niram.’ Rosi nəɡkiariien riti mwi kɨmiaha tihəni pehe tukw iou i in i mə, ‘Nɨmtətien me nəha kɨmaha iahamreɡi ikɨno fwe ia taon nəha Kapaneam, ramasan mə iko mwi ia kwopun i imwam.’” ");
INSERT INTO tnk_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Iesu rarə mɨni mwi mə, “Iakani nɨpərhienien tukumiaha i profet riti nəkur imwəni me ko həpkɨsiai mhə in. ");
INSERT INTO tnk_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mətə pərhien iakani pehe tukumiaha i fwe kupwən ia nəpɨn səvəi Profet Elaeja nɨpran me həpɨk səməme nərman me səvənraha hemhə mhəpwəh irəha kamharə ia tənə Isrel. Nesən rɨpkauər mhə nuk kahar məkwə sikis nukumhə asori ruvehe mahi nərmama pam ia tənə nəha ");
INSERT INTO tnk_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","mətə Kumwesən rɨpkərhi pen mhə Elaeja mə trasitu ia nirəha riti. In rərhi pen in revən əpa fwe ia rukwənu nəha Jerefat ia tənə Saeton mə trasitu ia pran riti sə iərman səvənhi remhə məpwəh in. ");
INSERT INTO tnk_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kurirə irə ia nəpɨn səvəi Profet Elisa nərmama həpɨk səməme nemhəien skai ro tekɨnraha kamharə ia tənə Isrel. Mətə Elisa rɨpko mhə irəha riti ruvehe məmher. In ro Neman əpa iəmə Siria ruvehe məmher.” ");
INSERT INTO tnk_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nəpɨn nərmama me ia nəkwai nimwəfwaki həreɡi nəɡkiariien me nəha, irəha pam niemaha rəpi irəha. ");
INSERT INTO tnk_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Həskəmter, mhəkwtəmhiri Iesu, mhəsuə in, mhəier ia taon səvənraha, mhəuvən ia nɨpəseɡi təkuər sə həno taon səvənraha ikɨn mə tuhəsuə irapw i. ");
INSERT INTO tnk_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mətə Iesu ravən amasan a ia kurkwanraha, mamevən. ");
INSERT INTO tnk_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Iesu reiwaiu mevən ia Kapaneam taon riti ia tənə Kalili, nənə ia Sapat ramahatən nərmama. ");
INSERT INTO tnk_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Irəha hərkəri asori nari ia nahatənien səvənhi, tɨ nəri nə mə nəɡkiariien səvənhi nɨskaiien səvəi Kumwesən ramarə irə. ");
INSERT INTO tnk_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Iərmama riti ia nəkwai nimwəfwaki nəha səvəi nəkur Isrel nənɨmwɨn ərəha ramarə irə. Iərmama nəha rəkwein əpwəmwɨs mɨni mə, ");
INSERT INTO tnk_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Iesu iəmə Nasaret! Ikuvehe mə tiko nəfe ia kɨmaha? Ikuvehe mə tikouraha kɨmaha uə? Iakukurən ik. Ik iəmə ikinan səvəi Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Mətə Iesu rɨnise nənɨmwɨn ərəha nəha, mɨni mə, “Əpwəh nəɡkiariien, mier ia iərmama i.” Iəremhə ro iərmama nəha rɨmwei ia kurkwanraha, mier irə, məpwəh nourahaien in. ");
INSERT INTO tnk_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nərmama me nənimenraha rier. Həni pen tɨ nirəha me i mə, “Nəfe i nəɡkiariien? Iəmə i rauvehi nasoriien mɨne nɨskaiien sə ruku pen tɨ Kumwesən, məɡkiari m nənɨmwɨn ərəha me mə tuhəier ia iərmama, nənə irəha həier.” ");
INSERT INTO tnk_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kurirə nəɡkiariien kani ia Iesu rier mevən ia kwopun me pam ia tənə nəha. ");
INSERT INTO tnk_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iesu rərer, mier ia nimwəfwaki nəha səvəi nəkur Isrel, mevən muvnimwə ia nimwə səvəi Saemon. Kaka pran səvəi Saemon ramemhə, maməkwiei fifa. Nənə irəha həɡkiari pen m Iesu tukwe. ");
INSERT INTO tnk_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Iesu revən mərer pen ipaka tɨ prən nəha ia kwopun ramapri ikɨn, mɨnise nemhəien, nənə nemhəien raraka irə. Təkwtəkwuni a prən nəha rɨskəmter, mɨnasui raka nəveɡɨnien sənənraha. ");
INSERT INTO tnk_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nəpɨn meri ruvəivə, nərmama pam kamhəuvehi irəha me nepwɨn səməme nemhəien me səpəmsəpə kamharə ia nirəha, həuvehi irəha, mhəuvehe tɨ Iesu. Nənə Iesu rəmrutə rəɡɨn mi ia nirəha kuatia kuatia, mo irəha pam həuvehe mhəsanɨn. ");
INSERT INTO tnk_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nəremhə me mwi həier ia nərmama həpɨk, mamhəkwein əpwəmwɨs mə, “Ik Tɨni Kumwesən!” Mətə Iesu rɨnise irəha mə tuhəpwəh nəɡkiariien, tɨ nəri nə mə irəha həukurən in mə in Kristo. ");
INSERT INTO tnk_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nəpɨn rɨnamran, Iesu rier mevən ia kwopun riti sə nərmama həiwən ikɨn. Nənə nərmama kamhətui in. Nəpɨn hətoni, hokeikei mə tuhənise in mə trəpwəh nəpwəhien irəha. ");
INSERT INTO tnk_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mətə in rɨni pen tɨ nirəha i mə, “Takaməkeikei mevən ia taon me nepwɨn mwi, məvisau irapw nəɡkiariien amasan sə raməɡkiari ia nɨtətə sə Kumwesən ramərɨmənu irə. In i wok Kumwesən rɨnərhi pehe iou tukwe.” ");
INSERT INTO tnk_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ro pen Iesu revən maməvisau ia nəkwai nimwəfwaki me səvəi nəkur Isrel ia tənə Jutia. ");
INSERT INTO tnk_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nəpɨn riti, nəpɨn Iesu ramərer ia nɨkare nui asori nəha Kenesaret, nərmama həpɨk housəsɨmwɨn pen irəha ipaka tukwe mə tuhətərɨɡ nəɡkiariien səvəi Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nənə Iesu rətoni nɨtətə ouihi kəru krouəmak ia nɨkare nui. Nərmama səvəi nɨviien nəmu me hənəpwəh irau, mamhaikuas ia net me səvənraha. ");
INSERT INTO tnk_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nɨtətə ouihi mi nəha riti səvəi Saemon. Iesu rəputə irə, məres pen Saemon mə trarhɨr i pwəh ruveraha ouihi kwopti. Nənə Iesu rəkure ia nəkwai nɨtətə ouihi nəha, mɨnamahatən nərmama. ");
INSERT INTO tnk_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nəpɨn rəɡkiari pam, mɨni pen tɨ Saemon i mə, “Kɨmiaha tihəsuə mhəuvən ia kwopun əmwhenɨmw, merukw irapw net me səkɨmiaha, mhəvi nəmu me nepwɨn.” ");
INSERT INTO tnk_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Mɨreɡi Saemon rɨni mə, “Iərɨmənu. Kɨmaha iahəmwur meste rɨran mhəpkuvi mhə nəmu riti. Mətə tɨ nəri nə mə ikani pwəh iakevən mwi mherukw irapw net me səkɨmaha.” ");
INSERT INTO tnk_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nəpɨn irəha həuvən mho iamɨnha irə, nəmu me həuvən pɨk ia net me səvənraha. Tɨ nəri nə mə nəmu me həpɨk anan net me səvənraha hənaməkw əmsəmwerɨs. ");
INSERT INTO tnk_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Irəha həkwein nərmama səməme kamhəvi pəri nəmu me irəha mɨnraha fwe ia nɨtətə ouihi əpə mə tuhəuvehe mhasitu. Irəha həuvehe, hərki pen nəmu me ia nɨtətə ouihi mi səvənraha rukuər. Ipaka nɨtətə ouihi mi krouəmwhenɨmw. ");
INSERT INTO tnk_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nəpɨn Saemon Pita rətoni, rɨnɨmwi nukurhun mi ia nəmri Iesu, mɨni mə, “Iərɨmənu. Evən isipwɨn tukw iou. Iou iəmə ərəha i.” ");
INSERT INTO tnk_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Pita rəɡkiari iamɨnhi irə tɨ nəri nə mə in mɨne nərmama me ia nəkwai nɨtətə ouihi səvənhi hətə nəmu me nəha həvi, mhətoni həpɨk anan. Nənimenraha rier. ");
INSERT INTO tnk_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nənə Jemes mɨne Jon, tɨni Sepeti mi sə kamharəvi pəri nəmu irəhar Saemon, nəmrɨnrau mwi rier. Mətə Iesu rɨni pen tɨ Saemon i mə, “Tikəpwəh nehekɨrien. Ik iərmama səvəi nɨviien nəmu, mətə təkwtəkwuni nəha mamevən tikuvi nərmama.” ");
INSERT INTO tnk_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nənə irəha həvi parei nɨtətə ouihi mi nəha, mhəpwəh pam narimnari me səvənraha, mhəkurirə Iesu. ");
INSERT INTO tnk_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nəpɨn riti Iesu revən ia taon riti. Iərmama riti ruvehe nemhəien skai ramo tekɨn mamouraha nɨpwran me pam. Nəpɨn rətoni Iesu, rɨmwei mɨnɨmwi irapw nənimen ia tɨprənə, mamase in mə, “Iərɨmənu. Mə rerɨm raɡien, ko iko iou ikəmher?” ");
INSERT INTO tnk_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nənə Iesu rosə pen rəɡɨn, mɨrapi in, mɨni mə, “Rerɨk raɡien. Tiko məmher.” Təkwtəkwuni a nəmhien raraka ia iərmama nəha. ");
INSERT INTO tnk_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nənə Iesu rɨnise in, mɨni mə, “Tikəpwəh nɨniien nəfe iakɨno mik tɨ iərmama riti, mətə tikevən atukwatukw tɨ pris pwəh in rətoni nɨpwram mə rəmher. Tikuvei pen nəfe m Kumwesən sə Moses rɨməni. Nərmama me tuhətoni həukurən mə nemhəien i ruvəiwən ia nɨpwram.” ");
INSERT INTO tnk_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mətə nəɡkiariien sə raməvisau Iesu rier mevən mwi ia kwopun me. Nənə nərmama həpɨk anan həuvehe ia kwopun kuatia mə tuhətərɨɡ in, mhəuvehe mwi mə truvehi raka nemhəien me səvənraha, mo irəha həuvehe mhəsanɨn. ");
INSERT INTO tnk_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mətə ia nəpɨn me Iesu ramier mamevən ia kwopun me nərmama həiwən ikɨn maməfwaki. ");
INSERT INTO tnk_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nəpɨn riti Iesu ramahatən nərmama me. Farisi me mɨne nahatən me səvəi Loa kamhəkure mamhətərɨɡ in. Irəha həməier ia Jerusalem mɨne rukwənu me ia tənə Kalili mɨne tənə Jutia mhəuvehe. Nɨskaiien səvəi Kumwesən ramarə ia Iesu, nənə in ramo nərmama səməme nemhəien ramarə ia nirəha həuvehe mhəsanɨn. ");
INSERT INTO tnk_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ia nəpɨn nəha nərmama nepwɨn həuvehi iərmama riti ramapri ia nɨməhan səvənhi nɨsun mi krouemhə. Hokeikei mə tuhəuvehi, mhəuvnimwə, mhəmri pen in ia nəmri Iesu, ");
INSERT INTO tnk_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","mətə həpkətə mhə suatuk riti tɨ nəri nə mə nərmama həpɨk anan. Ro pen irəha həputə ia təkure nimwə, mho ruei nimwə riti, mhəuvehi irapw iərmama nəha irau nɨməhan sə in ramapri irə, kroueiwaiu rouəmak ia nəmri Iesu ia kurkwanraha. ");
INSERT INTO tnk_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nəpɨn Iesu rətə nahatətəien səvənraha, in rɨni mə, “Iərman. Iakɨnenouenou raka noien ərəha me səim.” ");
INSERT INTO tnk_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nəpɨn nahatən me səvəi Loa mɨne Farisi me həreɡi nəɡkiariien nəha, hənaməres irəha me i mə, “Sin i iərmama i rani ərəha Kumwesən iamɨnhi? Kumwesən əpa rukurən nenouenouien noien ərəha me. Sin mwi rukurən noien?” ");
INSERT INTO tnk_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mətə Iesu ruvəukurən raka nətərɨɡien səvənraha, mɨni pen tɨ nirəha i mə, “Rəfo rerɨmiaha ramrhi iamɨnhi? ");
INSERT INTO tnk_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nəɡkiariien mi sə pəku nəha rɨməru tukw iou tɨ nɨniien tɨ iərmama i nɨsun mi krouemhə: nəɡkiariien i mə, ‘Iakɨnenouenou raka noien ərəha me səim,’ uə nəɡkiariien i mə, ‘Ərer mavən’? ");
INSERT INTO tnk_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mətə iakokeikei mə kɨmiaha tihəukurən mə iou, Iəməti Iərmama, iakauvehi nasoriien ia tɨprənə i. Iakukurən nenouenouien noien ərəha me.” Nənə Iesu rɨni pen tɨ iərmama sə nɨsun mi krouemhə mə, “Iakani pehe tukw ik i mə ərer, muvehi nɨməhan səim, mavən mamevən fwe imwam.” ");
INSERT INTO tnk_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Təkwtəkwuni a iərmama nəha rərer ia nəmrɨnraha, muvehi nɨməhan səvənhi, mamevən fwe imwəni, maməɡnəɡɨni Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nərmama me pam hətoni, həhekɨr. Nənimenraha rier. Həuvehi utə nəɡhi Kumwesən, mamhəni mə, “Kwa kɨtaha i sənətoni narimnari me nepwɨn ipwet rusəpə.” ");
INSERT INTO tnk_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kurirə irə Iesu rier mətoni iərmama riti sə kamərəku pen takis min. Nəɡhɨn nə Livae. Raməkure ia nimwə kamərəku pen takis ikɨn. Iesu rɨni pen tukwe in mə, “Kurirə iou.” ");
INSERT INTO tnk_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nənə in rəpwəh narimnari me pam səvənhi, mɨskəmter, mukurirə in. ");
INSERT INTO tnk_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kurirə irə Livae ro nəveɡɨnien asori ia nəkwai nimwə səvənhi sənəi Iesu. Nərmama kamərəku pen takis mɨnraha mɨne nərmama nepwɨn mwi həpɨk kamhani pəri nari irəha mɨnrau. ");
INSERT INTO tnk_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nənə Farisi me mɨne nepwɨn mwi ia nirəha nahatən me səvəi Loa rerɨnraha rɨpkaɡien mhə. Həni pen tɨ nərmama me səvəi Iesu i mə, “Rəfo kɨmiaha hiamani nari kɨmiaha nərmama kamərəku pen takis mɨnraha mɨne nərmama ərəha me nepwɨn mwi?” ");
INSERT INTO tnk_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Nərmama həsanɨn tuhətui tokta tɨ nəfe? Mətə nərmama kamhemhə kamhətui tokta. ");
INSERT INTO tnk_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Iou iapkuvehe mhə mə takəkwein nərmama atukwatukw me, mətə iakuvehe mə takəkwein nərmama ərəha me, mə irəha tuhərərɨɡ ia noien ərəha me səvənraha.” ");
INSERT INTO tnk_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nənə irəha həni pen tɨ Iesu i mə, “Nəpɨn rɨpɨk nərmama me səvəi Jon Paptaes həpwəh naniien nari tɨ nəfwakiien. Nərmama me səvəi Farisi me irəha mwi kamho iamɨnhi. Mətə rəfo səim me nərmama me kamhəveɡɨn mamhənɨmwi?” ");
INSERT INTO tnk_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Nərmama ia nəveɡɨnien kamo tɨ narə viien səvəi iərman mɨne pran tuhaməkeikei mhani nari, mamhaɡien, tɨ nəri nə mə iərman sə rɨpkarə vi a irau pran səvənhi ramarə irəha mɨnraha. Rɨpkatukwatukw mhə mə tihəkeikei mɨnraha mə tuhəpwəh naniien nari ia nəpɨn nəha. ");
INSERT INTO tnk_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mətə trɨpkuvehe ia nəpɨn sə tukuvehi raka iərman sə rɨpkarə vi a irau pran səvənhi trɨpkarə mhə mwi irəha mɨnraha. Ia nəpɨn nəha irəha tuhəpwəh naniien nari.” ");
INSERT INTO tnk_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Iesu rɨni mwi nusipekɨnien riti tɨ nirəha i mə, “Iərmama riti riwən ko reitehi raka nɨpəri tɨnari vi mɨtiri tukuahaɡ ia ruei tɨnari ivɨs. Trɨni mɨnuə ro iamɨnhi irə, trouraha tɨnari vi səvənhi, nənə nɨpəri tɨnari vi ko rɨpkrɨpɨn amasan mhə ia tɨnari ivɨs səvənhi. ");
INSERT INTO tnk_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Iərmama riti riwən ko rətəɡi pen waen vi ia tɨki waen tui me sə kɨno ia teki nəni. Trɨni mɨnuə ro iamɨnhi irə, waen vi trəse tɨki waen tui me həsisi mhəpəruə. Nənə tɨki waen tui me mɨne waen vi irau pəri trouərəha. ");
INSERT INTO tnk_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mətə waen vi tukətəɡi pen ia tɨki waen vi me. ");
INSERT INTO tnk_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nənə iərmama riti mwi riwən nəpɨn rɨnənɨmwi raka waen tui rokeikei mə trənɨmwi waen vi, tɨ nəri nə mə in rɨni mə, ‘Sə tui ramasan pɨk.’” ");
INSERT INTO tnk_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nəpɨn riti ia Sapat Iesu ravən maməpi sɨmwɨn ia nɨmei wit me nepwɨn, nənə nərmama me səvənhi kamhesi raka tɨpwe wit me, mamhəveri raka tekɨnraha ia rəɡɨnraha, mamhani kwənunɨn me. ");
INSERT INTO tnk_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mətə Farisi me nepwɨn həni mə, “Rəfo kɨmiaha hiamo noien riti rɨpkatukwatukw mhə ia Loa səkɨtaha mə tuko ia Sapat?” ");
INSERT INTO tnk_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Rosi kɨmiaha hiəpkəvsini raka mhə ia Nəkukuə Ikinan nəfe Kiɡ Tevɨt rɨno fwe kupwən uə? Nəpɨn nukumhə ramahi in mɨne nərmama me səvənhi, ");
INSERT INTO tnk_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ruvnimwə ia nimwə səvəi Kumwesən, muvehi bred ikinan sə raməmak ia nɨfatə. Rɨpkatukwatukw mhə ia Loa səkɨtaha mə in trəni bred nəha, pris me əpa həukurən naniien. Mətə Kiɡ Tevɨt rəni, muvei pen mwi m nərmama me səvənhi hani” ");
INSERT INTO tnk_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nənə Iesu rɨni pen tɨ nirəha i mə, “Iou, Iəməti Iərmama, iakamərɨmənu ia Sapat.” ");
INSERT INTO tnk_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ia Sapat riti mwi Iesu ruvnimwə ia nimwəfwaki səvəi nəkur Isrel, mamahatən nərmama. Iərmama riti ia nəkwai nimwəfwaki nəha rəɡɨn rərfe. ");
INSERT INTO tnk_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Nahatən me səvəi Loa mɨne Farisi me kamhətə amasan Iesu mə tuhətoni mə trəfo irə mɨne. Trɨni mɨnuə romasan iərmama nəha ia Sapat, tuhəni ərəha in tukwe. ");
INSERT INTO tnk_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mətə Iesu ruvəukurən raka nətərɨɡien səvənraha, mɨni pen tɨ iərmama sə rəɡɨn rərfe mə, “Uvehe, mərer ia kurkwai nərmama.” Iərmama nəha ruvehe, mərer ia kurkwanraha. ");
INSERT INTO tnk_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nənə Iesu rɨni pen tɨ nirəha i mə, “Iakuə takəres kɨmiaha nari riti. Ratukwatukw ia Loa səkɨtaha mə ia Sapat tuko noien amasan uə tuko noien ərəha? Ratukwatukw mwi mə tukuvehimɨru iərmama uə tukousi əpune in?” ");
INSERT INTO tnk_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nəpɨn Iesu rəti ərari mətə pam raka irəha, mɨni pen tɨ iərmama sə rəɡɨn rərfe mə, “Tiko mɨvi atukw rəɡɨm.” Nənə in rɨvi atukw rəɡɨn. Rəɡɨn ruvehe mamasan mwi. ");
INSERT INTO tnk_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mətə nərmama me nəha niemaha rəpi pɨk irəha. Hənaməɡkiari mɨnraha me, mamhəres mə tuhəfo ia Iesu. ");
INSERT INTO tnk_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ia nəpɨn nəha Iesu rier mutə ia təkuər riti mə trəfwaki. In rəfwaki m Kumwesən nəpɨn pekɨn ia nəpɨn. ");
INSERT INTO tnk_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nəpɨn rɨnamran, rəkwein nərmama me səvənhi, nənə mərpwi rəɡɨn ia nepwɨn irəha pam twelef, mɨseɡi pen nəɡhɨnraha mə aposol me. ");
INSERT INTO tnk_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nəɡhɨnraha me i: Saemon (iəmə sə Iesu rɨseɡi pen nəɡhɨn sə vi mə Pita), mɨne Antru piəvi Saemon, mɨne Jemes mɨne Jon, mɨne Filip, mɨne Patolomiu, ");
INSERT INTO tnk_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","mɨne Matiu, mɨne Tomas, mɨne Jemes tɨni Alfeas, mɨne Saemon (iəmə sə kupwən rakurirə ia səməme haməmwur mə tuhəkoui irapw nəkur Rom), ");
INSERT INTO tnk_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","mɨne Jutas tɨni Jemes, mɨne Jutas Iskariot (iəmə sə ruvei pen Iesu ia rəɡi nərmama səməme haməmwəki in). ");
INSERT INTO tnk_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nənə Iesu mɨne nərmama me nəha səvənhi heiwaiu pehe ia təkuər, mamhərer ia kwopun rətəni ikɨn irəha nərmama həpɨk mwi səvənhi mɨne nərmama həpɨk mwi səməme haməuku pen ia tənə Jutia mɨne Jerusalem mɨne ia nɨkare təsi ipaka tɨ taon mi nəha Taea mɨne Saeton. ");
INSERT INTO tnk_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Irəha nəha həuvehe mə tuhətərɨɡ Iesu, mhəuvehe mwi mə in tro irəha səməme nemhəien rarə ia nirəha həuvehe mhəsanɨn. Nənə səməme nənɨmwɨn ərəha me kamhouraha irəha, Iesu romasan irəha. ");
INSERT INTO tnk_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nərmama me pam hamousari mə tuhərapi in tɨ nəri nə mə nəɡsen raku pen irə, mamo irəha pam həuvehe mhəsanɨn. ");
INSERT INTO tnk_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Nənə Iesu rəti pen mamətə nərmama me səvənhi, mɨni mə, “Kɨmiaha səməme nautə səkɨmiaha riwən rerɨmiaha traɡien, tɨ nəri nə mə nɨtətə sə Kumwesən ramərɨmənu irə səkɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kɨmiaha səməme nukumhə ramahi kɨmiaha ipwet mɨne rerɨmiaha traɡien, tɨ nəri nə mə tɨpwɨmiaha trəsisi. Kɨmiaha səməme hiamasək ipwet mɨne rerɨmiaha traɡien, tɨ nəri nə mə kɨmiaha tiharɨs. ");
INSERT INTO tnk_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Rerɨmiaha traɡien nəpɨn nərmama tuhaməmwəki kɨmiaha, uə tuhəpkəseni mhə kɨmiaha mə kɨmiaha tihəuvehe mho kuatia kɨmiaha mɨnraha, uə tuhəni ərəha kɨmiaha, mhəni nəɡhɨmiaha mə kɨmiaha nəremhə me, tɨ nəri nə mə kɨmiaha nərmama me səiou, Iou Iəməti Iərmama. ");
INSERT INTO tnk_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ia nəpɨn nəha kɨmiaha tihaɡien, mho tanis. Nərəkuien səkɨmiaha rasori fwe ia neiai. Kaha kupwən me səvənraha həno iamɨnha irə ia profet me. ");
INSERT INTO tnk_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mətə kɨmiaha səməme nautə səkɨmiaha rasori trərəha anan tukumiaha, tɨ nəri nə mə kɨmiaha hiəuvəuvehi raka nɨmɨruien səkɨmiaha sə rɨməru. ");
INSERT INTO tnk_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kɨmiaha səməme tɨpwɨmiaha raməsisi ipwet mɨne trərəha anan tukumiaha, tɨ nəri nə mə nukumhə trahi kɨmiaha. Kɨmiaha səməme hiamarɨs ipwet mɨne trərəha anan tukumiaha, tɨ nəri nə mə kɨmiaha tihəreɡi rərəha mhasək. ");
INSERT INTO tnk_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Trərəha anan tukumiaha nəpɨn nərmama me pam kamhəni amasan kɨmiaha. Kaha kupwən me səvənraha həno iamɨnha irə ia profet eikuə me.” ");
INSERT INTO tnk_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Mətə iou iakani pehe tukumiaha i səməme hiamətərɨɡ ia nirak mə kɨmiaha tihaməkeikei mhokeikei nərmama səməme haməmwəki kɨmiaha, nənə mho noien amasan m nərmama səməme kamho noien ərəha m kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kɨmiaha tihaməkeikei mhəkwein amasan ia nərmama səməme kamhəkwein ərəha ia kɨmiaha, nənə mhəfwaki tɨ nərmama səməme kamhometə kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Trɨni mɨnuə iərmama riti rəpwi nɨkare nɨkapwɨm, tikuvei pen mwi nɨkaren min. Trɨni mɨnuə iərmama riti ruvehi raka səim kot, ramasan mə ikuvei pen mwi karkahu səim min. ");
INSERT INTO tnk_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Trɨni mɨnuə iərmama riti rəres ik nari riti, ikuvei pen min. Trɨni mɨnuə iərmama riti rɨpeki raka narimnari me səim, tikəpwəh nəresien in mə trɨpeki pehe mwi. ");
INSERT INTO tnk_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nəfe noien kɨmiaha hiokeikei mə nərmama tuho ia kɨmiaha, kɨmiaha mwi tiho ia nirəha. ");
INSERT INTO tnk_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Trɨni mɨnuə kɨmiaha hiokeikei a nərmama me səməme hokeikei kɨmiaha, Kumwesən trəɡnəɡɨni kɨmiaha tɨ nəfe? Nəkur ərəha me irəha mwi hokeikei nərmama me səməme hokeikei irəha! ");
INSERT INTO tnk_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Trɨni mɨnuə kɨmiaha hio noien amasan mɨne nərmama səməme ho noien amasan m kɨmiaha, Kumwesən trəɡnəɡɨni kɨmiaha tɨ nəfe? Nəkur ərəha me irəha mwi kamho iamɨnha irə. ");
INSERT INTO tnk_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Trɨni mɨnuə kɨmiaha hiəuvei pen mane m iərmama riti sə hiətɨɡite irə mə trərpwɨn pehe mwi m kɨmiaha, Kumwesən trəɡnəɡɨni kɨmiaha tɨ nəfe? Nəkur ərəha me irəha mwi kamhəuvei pen mane me mɨnraha me mə tukərpwɨn pen tai mane atukwatukw mɨnraha me. ");
INSERT INTO tnk_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Mətə kɨmiaha tihaməkeikei mhokeikei nərmama səməme haməmwəki kɨmiaha, mho noien amasan mɨnraha, mhəuvei pen mane mɨnraha, mhəpwəh nətərɨɡien mə tihəuvehi nari riti rəmwhen ia tain. Kɨmiaha tiho iamɨnhi irə nənə nərəkuien səkɨmiaha trasori. Tukɨni mə Kumwesən sə rasori anan nɨpwnətɨn me nə kɨmiaha tɨ nəri nə mə in ramo noien amasan m nərmama səməme həpkɨni mhə tanak tukwe mɨne nərmama ərəha me. ");
INSERT INTO tnk_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kɨmiaha tihaməkeikei mhapi nərmama rəmwhen ia Tata səkɨmiaha ramapi irəha.” ");
INSERT INTO tnk_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Kɨmiaha tihəpwəh nəkiriien nərmama tɨ noien ərəha me səvənraha, nənə Kumwesən trəpwəh nəkiriien kɨmiaha tɨ noien ərəha me səkɨmiaha. Tihəpwəh nərɨpwɨnien noien ərəha me səvəi nərmama, nənə Kumwesən trəpwəh nərɨpwɨnien noien ərəha me səkɨmiaha. Tihenouenou noien ərəha me səvəi nərmama, nənə Kumwesən trenouenou noien ərəha me səkɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kɨmiaha tihaməkeikei mhəriari pen narimnari me m nərmama, nənə Kumwesən trəriari pehe narimnari me m kɨmiaha. In truvei pehe rasori pɨk ia rəɡɨmiaha rəmwhen ia iərmama rarɨɡɨn pen ia tənərɨpw, mɨkiukiu irə meste ruvehe mukuər məsas. Trɨni mɨnuə kɨmiaha hiəriari pen asori, Kumwesən trəriari pehe rasori m kɨmiaha. Mətə mə kɨmiaha hiəriari pen ouihi, in trəriari pehe m kɨmiaha rouihi.” ");
INSERT INTO tnk_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iesu rɨni mwi nusipekɨnien riti tɨ nirəha i mə, “Rəfo, ko iərmama riti sə nənimen rɨfwə ramiri pen iərmama riti mwi nənimen rɨfwə ia suatuk sə trouesi? Tuko ro iamɨnhi irə irau pəri krouivə irapw ia ruei tənə. ");
INSERT INTO tnk_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Iərmama sə kamahatən in rɨpkasori mhə ia iahatən səvənhi. Mətə mə kamahatən in keste rukurən pam nari, in trəmwhen ia iahatən səvənhi. ");
INSERT INTO tnk_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Rəfo ikamətə nɨmwəkmwəki nei sə raməmak ia nəmri piam, mətə ipkətə mhə nɨpəri nei asori sə raməmak ia nənimem? ");
INSERT INTO tnk_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Trɨni mɨnuə nɨpəri nei asori raməmak ia nənimem, rəfo iakamɨni pen tɨ piam mə, ‘Piak, əseni iou pwəh iakɨskəri raka nɨmwəkmwəki nei sə raməmak ia nənimem’? Ik iərmama sə ikamo kəuətkəsuə tikaməkeikei mukupwən muvehi raka nɨpəri nei asori sə raməmak ia nənimem, kurirə irə ikətə amasan nari mə tikɨskəri raka nɨmwəkmwəki nei sə raməmak ia nəmri piam. ");
INSERT INTO tnk_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Nei amasan riti riwən rukuə kwənkwai nei ərəha. Rəmwhen a mwi nei ərəha rəpwəh nukuəien kwənkwai nei amasan. ");
INSERT INTO tnk_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nərmama hətə sas ia nei me ia kwənkwanraha. Kɨpkesi raka mhə kwənkwai niemɨs ia rəhi, uə kwənkwai krep ia nəkwus ərəha. ");
INSERT INTO tnk_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Rəmwhen a mwi iərmama amasan rani irapw nəɡkiariien amasan tɨ nəri nə mə rerɨn rukuər ia nətərɨɡien amasan. Iərmama ərəha rani irapw nəɡkiariien ərəha tɨ nəri nə mə rerɨn rukuər ia nətərɨɡien ərəha. Iakani iamɨnhi irə tɨ nəri nə mə iərmama raməɡkiari, ramɨni irapw a nəfe nətərɨɡien rerɨn rukuər irə.” ");
INSERT INTO tnk_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Rəfo kɨmiaha hiaməkwein iou mə ‘Iərɨmənu, Iərɨmənu,’ mətə hiəpwəh noien nəfe iakɨni pehe tukumiaha i? ");
INSERT INTO tnk_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Iərmama sə ruvehe tukw iou, mɨreɡi nəɡkiariien me səiou, mamo nəfe iakɨməni, pwəh iakɨni irapw noien səvənhi tukumiaha. ");
INSERT INTO tnk_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","In rəmwhen ia iərmama sə rauvrhəkɨn nimwə səvənhi. In reri ruə rəmwhenɨmw, məmri nəri sə nimwə trərer pen irə ia kəruəterei. Nəpɨn nesən asori rauər, iapiwən raiu muvehe meri nimwə nəha mətə ko rɨpkɨkiukiu mhə irə, tɨ nəri nə mə iərmama nəha rɨməuvrhəkɨn amasan nimwə nəha. ");
INSERT INTO tnk_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mətə iərmama sə rɨreɡi nəɡkiariien səiou, məpwəh noien narimnari me iakɨməni, rəmwhen iərmama sə ruvrhəkɨn nimwə səvənhi ia təkure tɨprənə, mətə rɨpkəmri pen mhə nari sə raməkwtəmhiri əknekɨn nɨsui nimwə. Nəpɨn iapiwən raiu muvehe meri nimwə nəha, təkwtəkwuni a nimwə nəha rɨmwei. Nənə nəpɨn rɨmwei irə, ruvehe mərəha pam.” ");
INSERT INTO tnk_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nəpɨn Iesu rɨni pam nəɡkiariien me nəha tɨ nərmama, revən mapirapw ia taon nəha Kapaneam. ");
INSERT INTO tnk_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Iaruaɡən riti səvəi nəkur Rom nəha ikɨn in rasori ia naruaɡən me irəha pam hantret. Səvənhi fwe iərmama sə ramo tukwini nari min. In rokeikei pɨk iərmama nəha, mətə ramemhə na tremhə. ");
INSERT INTO tnk_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nəpɨn iaruaɡən nəha rɨreɡi kani mə Iesu ruvəuvehe, rərhi pen nəmə asori me nepwɨn səvəi nəkur Isrel həuvən mə tuhəres in mə ko ruvehe mo iərmama sə ramo tukwini nari min rəsanɨn. ");
INSERT INTO tnk_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nəpɨn irəha həuvehe tɨ Iesu, kamhase in, mamhəni mə, “Ramasan mə tikasitu ia iəmə nəha ");
INSERT INTO tnk_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","tɨ nəri nə mə in rokeikei pɨk kɨtaha nəkur Isrel. Iəmə nəha in nəha rɨməuvei pehe mane masitu ia kɨmaha iahəuvrhəkɨn nimwəfwaki səkɨmaha ia kwopun i.” ");
INSERT INTO tnk_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nənə Iesu rukurirə irəha. Nəpɨn ruvehe ipaka tɨ nimwə nəha, iaruaɡən nəha sə in rasori ia naruaɡən me irəha pam hantret rərhi pen in me nepwɨn həuvən, mhəni pen tɨ Iesu i mə, “Iərɨmənu. Tikəpwəh nəmwurien iamɨnhi. Rɨpko mhə iou iəmə amasan riti. Iapkəmwhen mhə mə tikuvehe, muvnimwə ia nimwə səiou. ");
INSERT INTO tnk_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ro iamɨnhi irə iou iakreɡi mə ko iou iapkuvehe mhə tukw ik. Mətə tikɨni a nəkwam pwəh səiou iotukwininari ruvehe məsanɨn. ");
INSERT INTO tnk_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Iou mwi iərmama riti iakamarə teɡɨn nəmə asori me. Naruaɡən me nepwɨn mwi kamharə teɡɨn iou. Nəpɨn iakɨni pen tɨ riti mə ‘Evən,’ in trevən. Nəpɨn iakɨni pen tɨ riti mwi mə ‘Uvehe,’ in truvehe. Nəpɨn iakɨni pen tɨ iərmama sə ramo tukwini nari miou mə ‘O nəri,’ in tro.” ");
INSERT INTO tnk_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nəpɨn Iesu rɨreɡi nəɡkiariien nəha, rərkərinari ia iəmə nəha, muvsini mətoni nərmama səməme kamhəkurirə in, mɨni mə, “Iakani nɨpərhienien tukumiaha i mə iou iapkətə raka mhə iəmə Isrel riti nahatətəien səvənhi rɨskai rəmwhen ia nahatətəien səvəi iəmə Rom i.” ");
INSERT INTO tnk_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nənə nəpɨn nərmama me nəha iaruaɡən nəha rərhi pen irəha hərərɨɡ mhapirapw ia nimwə səvənhi, hətoni iərmama sə ramo tukwini nari min rɨnəsanɨn. ");
INSERT INTO tnk_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kurirə irə nəpɨn ouihi a rukurau Iesu revən fwe ia taon riti nəɡhɨn nə Naen. Nərmama səvənhi me mɨne nərmama nepwɨn mwi həpɨk həkurirə in. ");
INSERT INTO tnk_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nəpɨn Iesu ruvehe ipaka tɨ kwəruə asori səvəi taon nəha, rətoni nərmama kamhəier irə, mamhəuvehi iəkunouihi riti sə remhə, mamhəuvən mə tuhənɨmwi. Mama səvəi iəkunouihi nəha tɨni riti mwi riwən. Səvənhi iərman ruvamhə raka, məpwəh in. Nərmama həpɨk ia taon nəha kamhəkurirə prən nəha. ");
INSERT INTO tnk_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nəpɨn Iərɨmənu səkɨtaha rətə prən nəha, rerɨn rərkwəpɨr tukwe. Nənə in rɨni mə, “Prən i, tikəpwəh nasəkien.” ");
INSERT INTO tnk_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nənə Iesu revən ipaka, mɨrapi nɨkoukau səvəi iəkunouihi nəha. Nərmama səməme kamhəuvehi hərer. Nənə Iesu rɨni mə, “Iəkunouihi i! Iakɨni pehe tukw ik i mə tiko mərer!” ");
INSERT INTO tnk_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nənə iəkunouihi nəha sə remhə rɨskəmter, məkure, mɨnaməɡkiari. Nənə Iesu ruvehi in, muvei pen m mama səvənhi. ");
INSERT INTO tnk_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nərmama me pam hətoni həhekɨr, mhəɡnəɡɨni Kumwesən, mhəni mə, “Profet asori riti ruvəier pehe tukutaha.” Nənə irəha həni mwi mə, “Kumwesən ruvəuvehe raka mə truvehimɨru nərmama me səvənhi.” ");
INSERT INTO tnk_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nənə nəɡkiariien sə raməvisau nəri nəha Iesu rɨno ruvirɨs mevən ia kwopun me pam ia tənə Jutia mɨne kwopun me nepwɨn mwi ipaka tɨ tənə nəha. ");
INSERT INTO tnk_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nərmama me səvəi Jon Paptaes həvisau pen narimnari me pam i min. Nəpɨn Jon rɨreɡi, ");
INSERT INTO tnk_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","rəkwein səvənhi iərmama kəru krouvehe tukwe. Nənə in rərhi pen irau krouevən tɨ Iərɨmənu səkɨtaha mə trouəres in mə, “Ik i in i profet kupwən me kamhəni ik mə tikuvehe uə rekəm? Mə rɨpko mhə ik i rosi kɨmaha tahətui səpə iti uə?” ");
INSERT INTO tnk_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nəpɨn iəmə mi nəha krouvehe tɨ Iesu, krouni mə, “Jon Paptaes rərhi pehe kɨmrau iarouvehe mə trouəres ik mə, ‘Ik i in i profet kupwən me kamhəni ik mə tikuvehe uə rekəm? Mə rɨpko mhə ik i rosi kɨmaha tahətui səpə iti uə?’” ");
INSERT INTO tnk_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ia nəpɨn nəha Iesu raməkoui irapw nemhəien me səpəmsəpə mɨne nənɨmwɨn ərəha me ia nərmama həpɨk, mamo irəha həuvehe mhəsanɨn. Nərmama həpɨk nənimenraha rɨfwə in ro irəha hətui mhətə nari. ");
INSERT INTO tnk_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nənə in rɨni pen tɨ iəmə mi nəha Jon rərhi pen irau mə, “Kɨmirau tirouevən rouni pen tɨ Jon i nəfe iroureɡi rouətoni. Nərmama me nəmrɨnraha rɨfwə hətui mhətə nari, səməme nɨsunraha rərfe həvi atukw i mhavən. Nərmama nemhəien skai ro tekɨnraha həuvehe mhəmher, səməme nəkwəreɡɨnraha ruvisɨmw rəkwaɡ həreɡi nari. Nərmama me nepwɨn səməme kupwən həuvamhə, təkwtəkwuni nəha həuvəmɨru mwi. Nənə nərmama nautə səvənraha riwən kaməvisau nəɡkiariien amasan mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Iərmama sə ramətə iou trɨni mɨnuə in rɨpkɨmwei mhə ia nahatətəien səvənhi tɨ nari riti iakamo rerɨn traɡien.” ");
INSERT INTO tnk_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nəpɨn iəmə mi nəha Jon rərhi pen irau krourərɨɡ rouevən, Iesu rɨnaməɡkiari ia Jon, mɨnamɨni pen tɨ nərmama me i mə, “Fwe kupwən kɨmiaha hiəier ia taon me mɨne rukwənu me mhəuvən ia kwopun akwesakwes ikɨn mə tihətə nəfe? Iərmama riti sə rəmwhen ia kwənkwai niɡ rɨpkərer atukwatukw mhə nəpɨn mətaɡi rauini? Rekəm. ");
INSERT INTO tnk_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kɨmiaha hiəier mhəuvən mə tihətə nəfe? Iərmama riti sə rauvei pen tɨnari amasan me? Rekəm. Nərmama səməme kamhəuvei pen tɨnari amasan me, mamharə ia narəien sə rɨməru, irəha fwe ia nimwə me səvəi kiɡ me. ");
INSERT INTO tnk_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kɨmiaha hiəier mhəuvən mə tihətə nəfe? Profet riti? Ouəh, nɨpərhienien. Kɨmiaha hiəier mhəuvən mə tihətə profet riti. Mətə iakani pehe tukumiaha i iəmə i in rasori məpi raka profet. ");
INSERT INTO tnk_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","In iərmama sə Nəkukuə Ikinan raməɡkiari irə nəpɨn rɨni mə, ‘Ətə ro, takərhi pen iərmama sə trəɡkiari tukwini səiou, in trukupwən ia niram mevən, məpərhi səim suatuk.’ ");
INSERT INTO tnk_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Iakani nɨpərhienien tukumiaha i mə nərmama me sə nɨpran me hərəhi irəha ia tɨprənə i riti riwən rasori məpi raka Jon. Mətə nərmama me pam ia nɨtətə sə Kumwesən ramərɨmənu irə sə in reiwaiu anan ia nirəha in rasori məpi raka Jon.” ");
INSERT INTO tnk_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nəpɨn nərmama əpnapen me mɨne nərmama səməme kamərəku pen takis mɨnraha həreɡi nəɡkiariien i, həni mə Kumwesən in ratukwatukw. Irəha həni iamɨnhi irə tɨ nəri nə mə Jon rɨno raka paptaes ia nirəha. ");
INSERT INTO tnk_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mətə Farisi me mɨne nahatən me səvəi Loa hənəpwəh nəseniien mə Jon tro paptaes ia nirəha. Ro iamɨnhi irə irəha hənəpwəh suatuk sə Kumwesən rɨməni mə irəha tuhesi pen. ");
INSERT INTO tnk_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Iesu rarə mɨni mwi mə, “Takɨni nəfe nəɡkiariien mahatən pen noien səvəi nərmama ipwet mɨne? Noien səvənraha rəfo? ");
INSERT INTO tnk_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Irəha həmwhen ia nəkwərhakwərha kamhəkure ia kwopun kamapɨr ikɨn, mamhəkwein pen ia irəha me nepwɨn mə, ‘Kɨmaha iahani nɨpu səvəi naɡienien tukumiaha, mətə kɨmiaha hiəpko mhə tanis. Iahani nɨpu səvəi nemhəien, mətə kɨmiaha hiəpkasək mhə.’ ");
INSERT INTO tnk_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Iakani iamɨnhi irə tɨ nəri nə mə Jon Paptaes rɨməuvehe, mɨpkəni mhə nari, məpwəh nənɨmwiien waen, nənə kɨmiaha hiaməni mə, ‘Iəremhə rarə irə.’ ");
INSERT INTO tnk_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Iou, Iəməti Iərmama, iakɨməuvehe, maməni nari, mamənɨmwi rəmwhen a ia kɨmiaha, nənə kɨmiaha hiaməni mə, ‘Hətə ro iəmə nəha, in raməni pɨk nari, mamənɨmwi mamakonə i, mamavən pəri irəha nərmama səməme kamərəku pen takis mɨnraha mɨne nərmama ərəha me nepwɨn mwi!’ ");
INSERT INTO tnk_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mətə nərmama səməme kamhesi pen nukurənien səvəi Kumwesən kamho noien amasan me. Noien amasan me nəha kamhahatən pen mə nukurənien nəha ro nɨpərhienien.” ");
INSERT INTO tnk_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nəpɨn riti Farisi riti rəres Iesu mə truvehe məni nari irau min. Ro pen Iesu revən muvnimwə ia nimwə səvəi Farisi nəha, məkure mə trəni nari. ");
INSERT INTO tnk_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ia taon nəha pran riti sə ramo noien ərəha. Nəpɨn rɨreɡi mə Iesu raməni nari fwe nəkwai nimwə səvəi Farisi nəha, ruvehi senta mevən fwe ikɨn. Senta nəha raməmak ia nəkwai potel riti kɨno ia kəruəterei nəɡhɨn nə alapasta. ");
INSERT INTO tnk_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Prən nəha revən mərer ia təkutai Iesu ipaka tɨ nɨsun mi, mamasək. Nɨse nənimen rətəɡ pen ia nɨsui Iesu mi krouəpwtɨɡ. Nənə reiwaiu muvei pen nɨmwai nukwənen, mɨrai raka i, makei m nɨsun mi, mahakwi nɨsun mi ia senta. ");
INSERT INTO tnk_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nəpɨn Farisi nəha sə rəkwein Iesu mə trəni pəri nari irau min rətə prən nəha, rerɨn ramrhi mə, “Kamo iəmə nəha in profet pərhien, ko rukurən mə nəfe nəha pran ramrapi in. Kwa pran sə ramo noien ərəha.” ");
INSERT INTO tnk_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nənə Iesu rɨni pen tukwe in mə, “Saemon, iou iakuə takɨni nari riti tukw ik i.” Mɨreɡi Saemon rɨni mə, “Ni pehe ro iahatən.” ");
INSERT INTO tnk_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Mɨreɡi Iesu rɨni mə, “Iəmə asori riti ruvei pen mane m iərmama kəru mə tɨ nəpɨn riti krouərpwɨn pen min. Kaon səvəi riti silin kɨno ia silva irəha pam faef hantret. Nənə kaon səvəi riti silin kɨno ia silva irəha pam fifti. ");
INSERT INTO tnk_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Iərmama mi nəha rɨskai tɨ nirau tɨ nərpwɨn penien min. Ro pen iəmə asori rərai raka kaon səvənrau mɨni mə irau trouəpwəh nərpwɨnien. Tuko ro iamɨnha irə sin nəha ia iərmama mi nəha trokeikei pɨk iəmə asori nəha?” ");
INSERT INTO tnk_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Mɨreɡi Saemon rɨni mə, “Rosi sə nəha sə kaon səvənhi rasori nənə iəmə asori rərai raka.” Mɨreɡi Iesu rɨni pen tukwe in mə, “Nəkiriien səim ratukwatukw.” ");
INSERT INTO tnk_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nənə in ruvsini, məti pen mətə prən nəha, mɨni pen tɨ Saemon i mə, “Ikətə prən i? Nəpɨn iakɨməuvnimwə pehe ia nimwə səim, ipkaikuas mhə ia nɨsuk mi ia nui, mətə prən i raikuas ia nɨsuk mi ia nɨse nənimen, mɨrai raka ia nɨmwai nukwənen. ");
INSERT INTO tnk_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ik ipkakei mhə miou, mətə nəpɨn iakuvnimwə pehe, prən i rɨnamakei m nɨsuk mi, məpwəh napwɨsien. ");
INSERT INTO tnk_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ik ipkahakwi mhə nukwənek ia oel, mətə prən i rahakwi nɨsuk mi ia senta. ");
INSERT INTO tnk_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ro iamɨnhi irə iakani pehe tukw ik i mə noien ərəha me rɨpɨk prən i rɨno iou iakɨnenouenou raka. Ro pen in rokeikei pɨk iou. Mətə iərmama sə rɨpko pɨk mhə noien ərəha trɨni mɨnuə iakenouenou noien ərəha me nəha səvənhi iərmama nəha ko in rɨpkokeikei pɨk mhə iou tukwe.” ");
INSERT INTO tnk_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nənə Iesu rɨni pen tɨ prən i mə, “Iakɨnenouenou raka noien ərəha me səim.” ");
INSERT INTO tnk_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nənə nərmama me nəha səməme kamhani pəri nari irəha min, kənamhəni pen tɨ nirəha me i mə, “Sin i iərmama i rukurən nenouenouien noien ərəha me iamɨnhi?” ");
INSERT INTO tnk_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mətə Iesu rɨni pen tɨ prən i mə, “Nahatətəien səim ruvəuvehimɨru ik. Evən. Nəmərinuien trarə tukw ik.” ");
INSERT INTO tnk_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kurirə irə nəpɨn ouihi a rukurau, Iesu ramevən ia taon me mɨne rukwənu me, mamɨni irapw nəɡkiariien amasan sə raməvisau nɨtətə sə Kumwesən ramərɨmənu irə. Nərmama səvənhi twelef ");
INSERT INTO tnk_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","mɨne nɨpran me nepwɨn mwi kamhəkurirə in. Fwe kupwən Iesu rɨnomasan nɨpran me nəha, məkoui irapw nənɨmwɨn ərəha me ia nepwɨn, muvehi raka nemhəien me ia nepwɨn. Nəɡhɨnraha me i: Meri sə kaməkwein mwi nəɡhɨn nə mə Maktala, pran nəha Iesu rɨnəkoui irapw nəremhə sefen irə; ");
INSERT INTO tnk_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","nənə Joana, pran səvəi Jusa, iəmə asori riti sə ramowok ipaka tɨ Herot; nənə Susana, mɨne nɨpran me həpɨk mwi səməme kamhəuvehi nəmri narimnari me ia mane me səvənraha, mamhəuvei pen m Iesu mɨne nərmama me səvənhi mə trasitu ia nirəha. ");
INSERT INTO tnk_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nərmama həpɨk anan həier ia taon me pam ia kwopun nəha, mhəuvehe tɨ Iesu. Nəpɨn hənousəsɨmwɨn raka irəha me, in rɨni nusipekɨnien riti tɨ nirəha i mɨnuə, ");
INSERT INTO tnk_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Iərmama riti revən mə truini nuni nari me ia nəmhien səvənhi. Nəpɨn rauini pen nuni nari me, nuni nari me nepwɨn həsas pen ia suatuk, nənə nərmama havən ia nirəha, menu me ia nɨmaɡouaɡou həuvehe mhani pam. ");
INSERT INTO tnk_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nənə nuni nari me nepwɨn həsas pen ia təkure kəpwier tɨprənə rouihi ikɨn. Həuverə mətə tɨ nəri nə mə nui riwən haukei pam. ");
INSERT INTO tnk_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nənə nuni nari me nepwɨn həsas pen ia tɨprənə nəkwus ərəha rauvirɨs ikɨn. Nənə nəkwus ərəha me həuvirɨs mhəuvehe mhousəman pam irəha. ");
INSERT INTO tnk_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nənə nuni nari me nepwɨn həsas pen ia tɨprənə amasan, mhəutə, mhəukuə kwənkwan hantret.” Nəpɨn Iesu rɨni pam nəɡkiariien me nəha, rəkwein əpwəmwɨs, mɨni mə, “Iərmama sə nəkwəreɡɨn rarə tɨ nɨreɡiien nari traməkeikei mətərɨɡ amasan.” ");
INSERT INTO tnk_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nəpɨn nərmama me səvəi Iesu həres pen in mə nəfe nɨpwrai nusipekɨnien nəha, ");
INSERT INTO tnk_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","in rɨni mə, “Kɨmiaha nərmama me səiou kɨnəsevər ia suatuk tukumiaha hiəukurən narimnari me i ia nɨtətə sə Kumwesən ramərɨmənu irə hənamərkwafə fwe kupwən. Mətə nərməpə me kamhəreɡi iakaməɡkiari ia narimnari me nəha iakausipekɨn a irə. Iakamo iamɨnhi irə mə ‘irəha tuhətə, mətə tuhəpwəh nətəien mhəukurən. Irəha tuhəreɡi, mətə tuhəpkreɡi mhə mhəukurən.’ ");
INSERT INTO tnk_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Nənə nɨpwrai nusipekɨnien i iakɨməni ro iamɨnhi irə. Nuni nari in nə nəɡkiariien səvəi Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Səməme həsas pen ia suatuk həmwhen ia nərmama səməme həreɡi nəɡkiariien səvəi Kumwesən. Nəpɨn həuvəreɡi raka Setan ruvehe, muvehi raka nəɡkiariien nəha ia nətərɨɡien səvənraha, kamo irəha həni nɨpərhienien irə nənə Kumwesən ruvehimɨru irəha. ");
INSERT INTO tnk_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nənə səməme həsas pen ia təkure kəpwier tɨprənə rouihi ikɨn həmwhen ia nərmama səməme həreɡi nəɡkiariien səvəi Kumwesən, nənə mhəuvehi, mhaɡien tukwe. Mətə nəɡkiariien nəha rɨpkeiwaiu amasan mhə ia rerɨnraha rəmwhen ia nuai nei me. Irəha tuhəni nɨpərhienien irə nəpɨn ouihi a. Nəpɨn narimnari me tuhəuvehe mho nəmisəien mɨnraha mə tro mətə sas ia nahatətəien səvənraha, irəha həmwei. ");
INSERT INTO tnk_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nənə səməme həsas pen ia tɨprənə nəkwus ərəha rauvirɨs ikɨn həmwhen ia nərmama səməme həreɡi nəɡkiariien nəha, mətə nəpɨn irəha kamhesi pen suatuk səvənraha mamhəuvən, kamhətərɨɡ pɨk tɨ narimnari me səvəi tɨprənə i rəmwhen ia mane mɨne nəfe m nəfe mwi irəha hokeikei mə tuhəuvehi mhəreɡi ramasan irə ia nɨmɨruien səvənraha. Nətərɨɡien me nəha həuvirɨs ia rerɨnraha, həuvehe, mhousəman nəɡkiariien səvəi Kumwesən. Nənə nəɡkiariien nəha rəpwəh nukuəien. ");
INSERT INTO tnk_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mətə səməme həsas pen ia tɨprənə amasan irəha nəha həmwhen ia nərmama səməme həreɡi nəɡkiariien səvəi Kumwesən, nənə mhəkwtəmhiri ia rerɨnraha sə ratukwatukw mamasan. Irəha həkwtəmhiri əknekɨn mamhəuvən nənə mhəukuə.” ");
INSERT INTO tnk_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Iərmama riti riwən ko rɨhiai pen napw ia laet məuiui ia nari riti uə rukurei pen kwopun afafa ikɨn. Mətə traməkeikei mukurei utə i ia nari sə kakurei utə laet irə mə nərmama tuhətoni raməhiapw nəpɨn həuvnimwə pehe. ");
INSERT INTO tnk_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Rəmwhen a mwi narimnari me pam səməme hamərkwafə tuhaməkeikei mhəier irapw. Narimnari me pam səməme haməmak afafa tukaməkeikei kətoni kuvehi irapw ia nukuraanien. ");
INSERT INTO tnk_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ro iamɨnhi irə kɨmiaha tihaməkeikei mhətərɨɡ amasan ia nəfe hiamreɡi tɨ nəri nə mə iərmama sə kuvei pen nari riti min, ro wok irə, tukuvei pen sə rəkwaku min. Mətə iərmama sə kuvei pen nari riti min, ro nəri auər a irə, tukuvehi raka pam tukwe.” ");
INSERT INTO tnk_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ia nəpɨn nəha piəvi Iesu me mɨne mama səvənhi həuvehe mə tuhətə in, mətə ko həpkəuvən mhə ipaka tukwe tɨ nəri nə mə nərmama me həpɨk. ");
INSERT INTO tnk_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ro pen nərmama me həni pen tɨ Iesu i mə, “Səim mama mɨne piam me kamhərer fwe iruə. Irəha hokeikei mə tuhətə ik.” ");
INSERT INTO tnk_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Nərmama səməme kamhəreɡi nəɡkiariien səvəi Kumwesən, nənə mamho nəfe rani irəha nə səiou mama mɨne piak me.” ");
INSERT INTO tnk_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nəpɨn riti Iesu rəputə ia nɨtətə ouihi irəha nərmama me səvənhi, rɨni pen tɨ nirəha i mə, “Pwəh səuvən mhəpi sɨmwɨn pen fwe ia nɨkare nui asori.” Ro pen həvi nivən, mənamhəuvən. ");
INSERT INTO tnk_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nəpɨn kamhaiu ia nɨtətə ouihi mamhəuvən, Iesu revən mapri. Nɨmətaɡi asori reiwaiu ia nəkwai nui asori nəha, nɨtətə ouihi səvənraha rɨnakuər ia nui, na tuhəmwhenɨmw. ");
INSERT INTO tnk_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nərmama me səvəi Iesu həuvən, mhəsuəpwiri in, mhəni mə, “Iərɨmənu. Iərɨmənu. Na tsəmwhenɨmw!” Iesu rərer mɨnise nɨmətaɡi mɨne peiau peiau asori me, nənə heiwaiu mhəiwən. Narimnari me həuvehe mhəmərinu. ");
INSERT INTO tnk_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Iesu rɨni pen tɨ nirəha i mə, “Nahatətəien pəku səkɨmiaha?” Mətə irəha həhekɨr. Nənimenraha rier. Kamhəni pen tɨ nirəha me i mə, “Nəfe nəha iərmama? Raməɡkiari m nɨmətaɡi mɨne nui krauo nəkwan!” ");
INSERT INTO tnk_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Irəha həier ia tənə Kalili, mhaiu ia nɨtətə ouihi nəha, mhəpi sɨmwɨn ia nui asori, mhəuvən ia tənə səvəi nəmə Karasa. ");
INSERT INTO tnk_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nəpɨn Iesu ruvarei, iərmama riti ia taon riti fwe ikɨn ruvehe tukwe. Iərmama nəha nəremhə me kamharə irə. Nəpɨn rɨpɨk rɨpkarkahu mhə tɨnari, mɨpkapri mhə mwi ia nəkwai nimwə səvənhi, mətə ramarə ia kwopun kanɨmwi nərmama ikɨn. ");
INSERT INTO tnk_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nəpɨn iərmama nəha rətə Iesu, rasək əpwəmwɨs, muvehe mɨnɨmwi nukurhun mi ia nənimen, məɡkiari asori mɨni mə, “Iesu, Kumwesən sə rasori anan tɨni nə ik. Ikuvehe mə tikəfo iou irə? Iakase ik tikəpwəh noien nəmisəien miou.” ");
INSERT INTO tnk_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nənɨmwɨn ərəha nəha raməɡkiari iamɨnhi irə, tɨ nəri nə mə Iesu ruvəni pen raka tukwe in mɨnuə trier ia iərmama nəha. (Nəpɨn me rɨpɨk nənɨmwɨn ərəha nəha rɨnəkwtəmhiri iərmama nəha. Nərmama hənərihi rəɡɨn mi mɨne nɨsun mi ia jen me, mhərer tukuahaɡ in, mətə in rəvi əmwesi jen me, iəremhə rəkoui pen in revən ia kwopun akwesakwes ikɨn.) ");
INSERT INTO tnk_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nənə Iesu rəres in mə, “Nəɡhɨm sin?” Mɨreɡi rɨni mə, “Iou nəɡhɨk Nəkuər.” In rɨni iamɨnhi irə tɨ nəri nə mə nəremhə me həpɨk həməuvnimwə ia reri iərmama nəha. ");
INSERT INTO tnk_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nənə nəremhə me nəha hase Iesu mə trəpwəh nərhi penien irəha həuvən ia nɨpəɡ sə rameiwaiu nukunen riwən. ");
INSERT INTO tnk_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Mətə toue pɨkə me həpɨk kamhərku ia kwopun nəha. Nəremhə me hase Iesu mə trəseni irəha həuvnimwə ia rerɨnraha. Ro pen Iesu rəseni irəha. ");
INSERT INTO tnk_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nənə nəremhə me həier ia iərmama nəha, mhəuvnimwə ia reri pɨkə me. Pɨkə me haiu, mheiwaiu ia nəpatu, mhəsas pen ia təmwei nui asori, mhəmwhenɨmw. ");
INSERT INTO tnk_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nəpɨn nərmama səməme kamhətui tɨ pɨkə me hətoni, hap, mhəni irapw ia taon səvənraha mɨne rukwənu me. ");
INSERT INTO tnk_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nənə nərmama me həier mhəuvən mə tuhəspau i mə rəfo. Nəpɨn həuvehe tɨ Iesu həti pen mhətoni iərmama nəha nəremhə me həməier irə, rarkahu, maməkure irapw ia nɨsui Iesu, nətərɨɡien səvənhi rɨnəmak amasan. Irəha hətoni həhekɨr. ");
INSERT INTO tnk_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nənə səməme hənətoni nəri nəha, həni irapw tɨ nərmama me i mə iərmama nəha rɨnəfo muvehe məsanɨn. ");
INSERT INTO tnk_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nənə nəkur Karasa səməme kamharə ipaka tɨ kwopun nəha həres Iesu mə trəpwəh irəha mamevən tɨ nəri nə mə həhekɨr pɨk anan. Ro iamɨnhi irə in rəputə ia nɨtətə ouihi mə trɨrərɨɡ. ");
INSERT INTO tnk_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Iərmama sə nəremhə me həməier irə rase in mə trəseni in pwəh revən irau min. Mətə Iesu rərhi pen i ramevən, mɨni mə, ");
INSERT INTO tnk_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Tikrərɨɡ mevən fwe imwam, mɨni irapw narimnari me i Kumwesən rɨno mik.” Nənə iərmama nəha revən ia kwopun me pam fwe ia taon səvənhi, mamɨni irapw narimnari me nəha Iesu rɨno min. ");
INSERT INTO tnk_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nəpɨn Iesu rɨrərɨɡ pehe mwi ia nɨkare nui asori, nərmama me həuvən tukwe. Rerɨnraha raɡien tɨ nəri nə mə kamheitenhi in. ");
INSERT INTO tnk_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Iərmama riti fwe ikɨn nəɡhɨn nə Jaeras. In iəmə asori riti səvəi nimwəfwaki səvəi nəkur Isrel. Ruvehe mɨnɨmwi nukurhun mi ia nəmri Iesu, mamase in mə truvehe ia nimwə səvənhi, ");
INSERT INTO tnk_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","tɨ nəri nə mə prən ouihi səvənhi ramemhə na tremhə. Prənouihi nəha səvənhi in əpa kuatia. Nuk səvənhi ipaka reste twelef. Nəpɨn Iesu ravən mamevən, nərmama həpɨk həukuraukurau irə. ");
INSERT INTO tnk_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Pran riti nəha ikɨn ruvehe ramemhə ia nemhəien səvəi nɨpran. Nemhəien nəha rɨnarə rerɨn irə muvehi nuk twelef. In rɨnouraha pam mane səvənhi ia tokta me, mətə iərmama riti riwən ko ro in rəsanɨn. ");
INSERT INTO tnk_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Prən nəha rukurirə Iesu, muvehe, mɨrapi nusvenhi tɨnari səvənhi. Təkwtəkwuni a mwi nɨmwapw rama, nemhəien səvənhi ro sampam. ");
INSERT INTO tnk_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nənə Iesu rɨni mə, “Sin nəha rɨrapi iou?” Mɨreɡi nərmama pam həni mə rɨpko mhə irəha. Nənə Pita rɨni mə, “Iərɨmənu. Nərmama həpɨk kamhərer kurkurau ik, mamhəsɨɡiəsɨɡi ik.” ");
INSERT INTO tnk_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mətə Iesu rɨni mə, “Rekəm. Iakukurən mə iərmama riti rɨrapi iou. Iakreɡi nəɡsek rier ia nirak, mevən mo nari riti.” ");
INSERT INTO tnk_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nənə nəpɨn prən nəha rətoni mə ko in rɨpkərkwafə mhə, ruvehe mamətəmnɨmwɨn, mɨnɨmwi nukurhun mi ia nəmri Iesu, mɨni irapw ia nəmri nərmama me pam mə in rɨrapi Iesu tɨ nəfe mɨne rɨnəfo məsanɨn akwauakw. ");
INSERT INTO tnk_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nənə Iesu rɨni pen tɨ prən i mə, “Nərɨk, nahatətəien səim rɨno raka ik ikuvehe məsanɨn. Evən. Nəmərinuien trarə tukw ik.” ");
INSERT INTO tnk_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nəpɨn Iesu raməɡkiari ihi, iərmama riti ruku pen ia nimwə səvəi iəmə asori nəha Jaeras, muvehe mɨni mə, “Səim prən ouihi ruvamhə raka. Ramasan mə ikɨni pen tɨ iahatən i mə in trəpwəh pehe.” ");
INSERT INTO tnk_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mətə nəpɨn Iesu rɨreɡi nəɡkiariien nəha, rɨni pen tɨ Jaeras i mə, “Tikəpwəh nehekɨrien, mɨni a nɨpərhienien ia nirak, nənə prən ouihi səim trəsanɨn.” ");
INSERT INTO tnk_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nəpɨn Iesu rapirapw ia nimwə səvəi Jaeras, rɨpkəseni mhə nərmama me pam mə tuhəuvnimwə irəha min, mətə rəseni əpa Pita mɨne Jon mɨne Jemes mɨne tata mɨne mama səvəi prən ouihi nəha. ");
INSERT INTO tnk_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nərmama me pam kamhasək mamhəkwein əpwəmwɨs tɨ prən ouihi nəha, mətə Iesu rɨni mə, “Rəfo kɨmiaha hiamasək? Prənouihi nəha rɨpkemhə mhə, mətə ramapri a.” ");
INSERT INTO tnk_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Irəha həreɡi harɨs ia Iesu. Irəha həukurən mə prən ouihi nəha ruvamhə raka. ");
INSERT INTO tnk_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mətə Iesu ruvehi rəɡi prən ouihi nəha, mɨni mə, “Prənouihi, ərer.” ");
INSERT INTO tnk_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nənə nɨmɨruien səvənhi ruvehe. Təkwtəkwuni a mwi rɨskəmter. Nənə Iesu rɨni mə tukuvei pen nəveɡɨnien min pwəh rəni. ");
INSERT INTO tnk_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tata mɨne mama səvəi prən ouihi nəha nənimenrau rier, mətə Iesu rɨnise pen tɨ nirau i mə trouəpwəh nɨniien tɨ iərmama riti nəfe in rɨno. ");
INSERT INTO tnk_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iesu rəkwein nərmama səvənhi twelef həuvehe mhousəsɨmwɨn irəha me. Nənə in ruvei pen nɨskaiien mɨnraha. Ia nɨskaiien nəha irəha həukurən nɨfi rakaien nemhəien me ia nərmama. Nənə in ruvei pen mwi nasoriien mɨnraha. Ia nasoriien nəha irəha həukurən nəkoui irapwien nəremhə me pam. ");
INSERT INTO tnk_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nəpɨn Iesu ruvei pen pam, rərhi pen irəha mə tuhəuvən mhəvisau irapw nɨtətə sə Kumwesən ramərɨmənu irə, nənə mho nərmama səməme kamhemhə həuvehe mhəsanɨn. ");
INSERT INTO tnk_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","In rɨni pen tɨ nirəha i mə, “Kɨmiaha tihəpwəh nuvehiien narimnari me səvəi suatuk səkɨmiaha rəmwhen ia kaskɨn, uə tənərɨpw, uə nəveɡɨnien, uə mane. Kɨmiaha tiharkahu ia karkahu kuatia a. ");
INSERT INTO tnk_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nəpɨn tihəuvən ia kwopun riti, nənə mhəuvnimwə ia nimwə riti, nimwə nə in nə tiharə irə meste hiəier ia kwopun nəha. ");
INSERT INTO tnk_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Trɨni mɨnuə hiəuvən ia taon riti, mətə nərmama me ikɨn həpkəsevər mhə ia rerɨnraha tukumiaha, nəpɨn hiəier ia taon səvənraha, tihounouini raka nɨməkwrur ia nɨsumiaha tɨ nahatən penien mə irəha həno noien ərəha.” ");
INSERT INTO tnk_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nənə nərmama me twelef səvəi Iesu həier, mhəuvən ia rukwənu me, mamhəvisau irapw nəɡkiariien amasan, mamho nərmama səməme kamhemhə ia kwopun me pam həuvehe mhəsanɨn. ");
INSERT INTO tnk_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herot, iəmə Rom sə ramərɨmənu ia tənə Kalili, rɨreɡi narimnari me nəha Iesu ramo. Ia nəpɨn nəha nətərɨɡien səvənhi rəvsausɨni tɨ nəri nə mə nərmama me nepwɨn kamhəni mə Jon Paptaes rɨnətui mwi ia nemhəien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Nənə nərmama me nepwɨn kamhəni mə Profet Elaeja ruvəier pehe mwi. Nənə nərmama me nepwɨn mwi kamhəni mə profet kupwən riti rɨnətui mwi ia nemhəien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nənə Herot rɨni mə, “Jon iakɨnərai raka kənkapwə. Mətə sin mwi iərmama i iakamreɡi nəvisauien irə?” Ro iamɨnhi raməmwur mə trətə Iesu. ");
INSERT INTO tnk_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nəpɨn aposol me hərərɨɡ mhəuvehe mwi tɨ Iesu, həni pen tukwe in narimnari me pam səməme həno. Nənə in riri raka əpa irəha, mharaka ia nərmama mhəuvən ia taon riti nəɡhɨn nə Petsaeta. ");
INSERT INTO tnk_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nəpɨn nərmama me həreɡi mə Iesu ramevən fwe ikɨn, kamhəkurirə pen in. Nəpɨn Iesu rətoni irəha, rerɨn raɡien. In rəkwein irəha həuvehe, nənə rəɡkiari mɨnraha ia nɨtətə sə Kumwesən ramərɨmənu irə, mo səməme nemhəien ramarə ia nirəha həuvehe mhəsanɨn. ");
INSERT INTO tnk_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Rɨnaməruarəv meri na trivə. Nərmama səvənhi twelef həuvehe, mhəni pen tukwe in mə, “Ramasan mə tikərhi pen nərmama me i həuvən ia rukwənu me mɨne nəmhien me kwərha ipaka pwəh hətui kwopun me səvəi napriien mɨne nəveɡɨnien tɨ nəri nə mə kwopun i narimnari me həiwən ikɨn.” ");
INSERT INTO tnk_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mətə Iesu rɨni pen tɨ nirəha i mə, “Kɨmiaha nə tihəuvei pen nəveɡɨnien mɨnraha.” Mɨreɡi həni mə, “Kɨmaha iahəuvehi a bred krirum mɨne nəmu kəru. Rəfo? Ikokeikei mə kɨmaha tahəuvən mhəuvehi nəmri nəveɡɨnien sənəi nərmama me pam i?” ");
INSERT INTO tnk_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Irəha həni iamɨnhi tɨ nəri nə mə nəpɨn həvsini a nərman me ia nirəha mətə ipaka faef-taosen.) Nənə Iesu rɨni pen tɨ səvənhi nərmama me i mə, “Kɨmiaha tihəuvən mho irəha həuai irəha me mhəkure əpəməpə me fifti ia təmwen kuatia.” ");
INSERT INTO tnk_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Nənə irəha həuvən mho nərmama me həkure rəmwhen Iesu rɨməni. ");
INSERT INTO tnk_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nənə Iesu ruvehi bred me nəha krirum mɨne nəmu i kəru, məkwətə ia nɨmaɡouaɡou, məfwaki mɨni vivi Kumwesən tukwe, məkwsen, mauvei pen m səvənhi nərmama me mə irəha tuhəpeki pen m nərmama me. ");
INSERT INTO tnk_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nərmama me pam hani nari tɨpwɨnraha rəsisi. Nənə nərmama me səvəi Iesu həvai pen nɨpərpəri nəveɡɨnien me nəha sə hənani mhəpwəh rukuər ia tənərɨpw irəha pam twelef. ");
INSERT INTO tnk_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nəpɨn riti Iesu in əpa raməfwaki irəha səvənhi me nərmama. Nənə rɨni pen tɨ nirəha i mə, “Nərmama kamhəni iou mə iou sin?” ");
INSERT INTO tnk_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Mɨreɡi həni mə, “Nərmama nepwɨn kamhəni ik mə Jon Paptaes. Mətə nepwɨn kamhəni ik mə Profet Elaeja. Nepwɨn mwi kamhəni ik mə profet kupwən riti sə rɨnətui mwi ia nemhəien səvənhi.” ");
INSERT INTO tnk_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Mətə kɨmiaha hiaməni mə iou sin?” Mɨreɡi Pita rɨni mə, “Ik Kristo sə Kumwesən rɨməni mə trərhi pehe ik ikuvehe.” ");
INSERT INTO tnk_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Nənə Iesu rɨnise pen əknekɨn tɨ nirəha i mə, “Kɨmiaha tihəpwəh nɨniien nəɡkiariien i tɨ iərmama riti.” ");
INSERT INTO tnk_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nənə in rɨrɨpɨn nəɡkiariien səvənhi mɨni mə, “Iou Iəməti Iərmama takaməkeikei mɨreɡi nəmisəien me rɨpɨk. Nəmə asori me mɨne pris asori me mɨne nahatən me səvəi Loa tuhəuvei pehe təkutanraha miou. Tukousi əpune iou, nənə nəpɨn sə ro kahar irə iakətui mwi.” ");
INSERT INTO tnk_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nənə Iesu rɨni pen tɨ nərmama me pam mə, “Iərmama sə rokeikei mə truvehe mo iərmama riti səiou traməkeikei məpwəh nətərɨɡien səvənhi, muvehi utə nei kamarkuaui səvənhi ia nəpɨn me, məvrani mukurirə iou. ");
INSERT INTO tnk_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Iərmama sə rokeikei mə trəkwtəmhiri nɨmɨruien səvənhi trarfai irə. Mətə iərmama sə traraka ia nɨmɨruien səvənhi tukw iou truvehi nɨmɨruien rerɨn. ");
INSERT INTO tnk_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Trɨni mɨnuə iərmama riti rɨpeki pam narimnari me ia tɨprənə i mo səvənhi i, nənə kurirə ikɨn remhə, mətə rɨpkuvehi mhə nɨmɨruien rerɨn, noien nəha trəfasitu irə? ");
INSERT INTO tnk_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Iərmama sə traurɨs ia nəmri nərmama tɨ nɨniien mə in iərmama riti səiou, maurɨs mwi tɨ nəvisauien nəɡkiariien me səiou mɨnraha, Iou mwi Iəməti Iərmama, ia nəpɨn nəha takuvehe ia nɨskaiien səiou mɨne ia nɨskaiien səvəi tata səiou mɨne naɡelo ikinan me, takaurɨs tɨ nɨniien mə iərmama nəha in iərmama riti səiou. ");
INSERT INTO tnk_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mətə iakani nɨpərhienien tukumiaha i nərmama nepwɨn kamhərer ia kwopun i tuhəpkemhə mhə meste tuhətoni nɨtətə sə Kumwesən ramərɨmənu irə rier pehe.” ");
INSERT INTO tnk_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nəpɨn Iesu rɨni pam nəɡkiariien me nəha, ipaka nəpɨn eit ruvehe mukurau, nənə in riri Pita mɨne Jemes mɨne Jon mutə parei ia təkuər riti mə trəfwaki. ");
INSERT INTO tnk_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nəpɨn raməfwaki, nənimen ruvehe mopə. Tɨnari səvənhi ruvehe məpsan mamser. ");
INSERT INTO tnk_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Təkwtəkwuni a iərmama kəru krauəɡkiari irəhar min. Irau nə Moses mɨne Profet Elaeja. ");
INSERT INTO tnk_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Krouier pehe ia nukuraanien asori, rauni narimnari me ia nɨkaren səvəi nemhəien səvənhi sə trɨpko mhə tui in revən mo sampam irə fwe ia Jerusalem. ");
INSERT INTO tnk_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ia nəpɨn nəha Pita mɨne James mɨne Jon haremhə napriien. Mətə nəpɨn harətui, harətoni nɨpwrai Iesu ramser iərmama kəru nəha krouərer irəhar min. ");
INSERT INTO tnk_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nənə nəpɨn irau krɨnouəpwəh Iesu rauevən, Pita rɨni pen tukwe in mə, “Iərɨmənu. Ramasan mə kɨmrahar iaharuvehe i. Pwəh kɨmrahar iaharo tənimwə kahar, riti səim, riti səvəi Moses, riti səvəi Profet Elaeja.” (Mətə Pita raməɡkiari əpnapen, mɨpkukurən amasan mhə nəfe rani.) ");
INSERT INTO tnk_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nəpɨn in raməɡkiari ihi, nəpuə riti rɨnauvehe mɨnamousəman irəhar. Irəhar harətoni mə nəpuə nəha truveɡi irəhar. Harətoni harhekɨr. ");
INSERT INTO tnk_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nənə reri Kumwesən ruku pen ia nəpuə nəha, mɨni mə, “In nəha nərɨk sə iakuvərfi raka in. Kɨmiaha tihətərɨɡ in.” ");
INSERT INTO tnk_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nəpɨn Kumwesən rəɡkiari pam, harəti pen mharətoni Iesu əpa ramərer. Kurirə ia nəpɨn nəha irəhar harəpnapen, mharəpwəh nɨniien tɨ iərmama riti nəfe harənətoni. ");
INSERT INTO tnk_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kɨni rakwakwi irə, nəpɨn irəha həneiwaiu raka ia təkuər nəha, nərmama həpɨk həuvehe tɨ Iesu. ");
INSERT INTO tnk_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nənə iərmama riti sə ramərer ia reri nərmama me nəha rəkwein əpwəmwɨs, mɨni mə, “Iahatən. Iakase ik. Tiko muvehe mətə ro nərɨk. In kwənkwan kuatia. ");
INSERT INTO tnk_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ia nəpɨn me nənɨmwɨn ərəha riti raməkwtəmhiri in, mamo in ramərkərinari mamasək əpwəmwɨs, mamərkərekər, nɨsəkwan ramaiu. Nənɨmwɨn ərəha nəha ro pɨk nəmisəien min, ko rɨpkaraka akwauakw mhə irə. ");
INSERT INTO tnk_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Iakɨnəres raka səim nərmama me mə irəha tuhəkoui irapw i, mətə ko həpko mhə.” ");
INSERT INTO tnk_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Mɨreɡi Iesu rɨni mə, “Kɨmiaha nəkur ipwet mɨne nahatətəien səkɨmiaha riwən. Noien səkɨmiaha rikou. Tsarə kɨtaha miou meste nəfe nəpɨn? Tɨneisən mɨne iakapwɨs kɨmiaha? Tiko miri nərɨm muvehe i.” ");
INSERT INTO tnk_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nəpɨn iəkunouihi nəha ramavən ihi mauvehe, iəremhə ruvehi in mouini irapw ia tɨprənə, mamo in ramərkərekər. Mətə Iesu rɨnise pen tɨ nənɨmwɨn ərəha, mo iəmə ouihi nəha ruvehe məsanɨn. Nəpɨn rɨnəsanɨn raka Iesu ruvehi in muvei pen m səvənhi tata. ");
INSERT INTO tnk_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nənə nərmama pam səməme hətoni nəri asori nəha Iesu rɨno ia nɨskaiien səvəi Kumwesən nənimenraha rier. Mətə nəpɨn irəha pam kamhərkəri ihi nari ia narimnari me nəha in ramo, Iesu rɨni pen tɨ səvənhi nərmama me i mə, ");
INSERT INTO tnk_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Pwəh nəɡkiariien me i həuvnimwə amasan ia nəkwəreɡɨmiaha. Trɨpko mhə tui kuvei pen iou, Iəməti Iərmama, ia rəɡi nərmama.” ");
INSERT INTO tnk_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mətə irəha həreɡi nəɡkiariien i həreirei nɨpwran. Kumwesən rərkwafə i mə ko irəha həpkətoni mhə. Nənə həhekɨr tɨ nəresien Iesu mə nəfe nɨpwrai nəɡkiariien i. ");
INSERT INTO tnk_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ia nəpɨn nəha nərmama me səvəi Iesu hənaməvisə mɨnraha me mə sin ia nirəha in rasori. ");
INSERT INTO tnk_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mətə Iesu rukurən nətərɨɡien səvənraha. Ro pen in ruvehi iəkunouihi riti, mərpwi ia nɨkaren, ");
INSERT INTO tnk_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","nənə mɨni pen tɨ nirəha i mə, “Iərmama sə trəsevər ia rerɨn tɨ iəkunouihi i ia nəɡhɨk, raməsevər mwi ia rerɨn tukw iou. Iərmama sə raməsevər ia rerɨn tukwe iou rəmwhen mə raməsevər mwi ia rerɨn tɨ Kumwesən sə rɨnərhi pehe iou iakuvehe. Iakani iamɨnhi irə tɨ nəri nə mə iərmama sə truvehi irapw in ia kɨmiaha in nə iərmama sə rasori ia kɨmiaha.” ");
INSERT INTO tnk_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Mɨreɡi Jon rɨni mə, “Iahatən, kɨmaha iahətoni iərmama riti raməkoui irapw nəremhə me ia nəɡhɨm. Iahaməmwur mə tahənise in tɨ nəri nə mə rɨpko mhə in kɨmaha riti.” ");
INSERT INTO tnk_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Mətə Iesu rɨni pen tukwe in mə, “Kɨmiaha tihəpwəh nɨniseien in. Iərmama sə rɨpkɨni ərəha mhə kɨmiaha in kɨmiaha riti.” ");
INSERT INTO tnk_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Rɨnauvehe ipaka tɨ nəpɨn nəha Kumwesən truvehi Iesu mutə mevən ia neiai. Iesu nətərɨɡien səvənhi ruvehe mɨskai mə traməkeikei mevən fwe Jerusalem. ");
INSERT INTO tnk_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nənə in rərhi pen nərmama nepwɨn mə tuhəkupwən irə. Irəha həuvən mhəier pen ia rukwənu riti səvəi nəkur Sameria mə tuhəpnəpenə ia narimnari me kurirə Iesu ruvehe. ");
INSERT INTO tnk_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mətə nərmama ia kwopun nəha həpkəseni mhə Iesu mə truvehe imwənraha tɨ nəri nə mə irəha həuvəukurən raka nətərɨɡien səvənhi rɨskai mə traməkeikei mevən fwe Jerusalem. ");
INSERT INTO tnk_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nəpɨn iərmama mi kəru səvənhi mi Jemes mɨne Jon krouətə noien nəha, krouni mə, “Iərɨmənu. Ikokeikei mə kɨmrau trouəkwein napw pwəh ruku pen fwe ia neiai meiwaiu pehe mahi əmwesi irəha?” ");
INSERT INTO tnk_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mətə Iesu ruvsini in mɨnise pen əknekɨn tɨ nirau i. ");
INSERT INTO tnk_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nənə irəha həuvən mwi ia rukwənu əpə riti. ");
INSERT INTO tnk_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nəpɨn riti Iesu mɨne nərmama me səvənhi kamhesi pen suatuk mamhəuvən. Nənə iərmama riti rɨni pen tukwe in mə, “Takukurirə ik kwopun pəku tikevən ikɨn.” ");
INSERT INTO tnk_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Mɨreɡi Iesu rɨni pen tukwe in mə, “Kuri əprmɨn me səvənraha nɨpəɡ rarə. Menu me ia nɨmaɡouaɡou təpwaɡenraha rarə. Mətə iou, Iəməti Iərmama, kwopun səiou riwən mə takapri ikɨn.” ");
INSERT INTO tnk_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nənə Iesu rɨni pen tɨ iərmama riti mwi mə, “Kurirə iou.” Mətə iərmama nəha rɨni mə, “Iərɨmənu. Takukurirə ik, mətə pwəh iakukupwən mevən mɨnɨmwi raka səiou tata.” ");
INSERT INTO tnk_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Mɨreɡi Iesu rɨni pen tukwe in mə, “Nərmama səməme həpkukurirə mhə iou rəmwhen mə həuvamhə raka. Pwəh irəha hənɨmwi nərmama me səvənraha səməme həuvamhə. Mətə ik tiko muvehe, mevən məvisau irapw nɨtətə sə Kumwesən ramərɨmənu irə.” ");
INSERT INTO tnk_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nənə iərmama riti mwi rɨni mə, “Iərɨmənu. Takukurirə ik, mətə pwəh iakevən məsəkɨr raka m nəkur imwak me.” ");
INSERT INTO tnk_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Mɨreɡi Iesu rɨni pen tukwe in mə, “Trɨni mɨnuə iərmama rauvehi kəkur i kau ravi, mɨnamostat mɨnamərar, maməti kurirə, rɨpko mhə in iəmə amasan riti sə truvehi wok ia nɨtətə sə Kumwesən ramərɨmənu irə.” ");
INSERT INTO tnk_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kurirə irə Iərɨmənu səkɨtaha rərpwi rəɡɨn ia nərmama me nepwɨn mwi irəha pam sefenti-tu, mərhi pen irəha mə tuhəkupwən irə, mhəuvən kəru kəru ia taon me mɨne rukwənu me pam sə in mwi trukurirə pen irəha mevən ikɨn. ");
INSERT INTO tnk_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","In rɨni pen tɨ nirəha i mə, “Nəveɡɨnien sə ruvəmruə raka fwe ia nəmhien rasori pɨk, mətə nərmama səməme kamhəpeki pehe houihi a. Ro iamɨnhi irə kɨmiaha tihaməkeikei mhəfwaki m Kumwesən sə ramərɨmənu ia nəmhien, mhəres in mə trərhi pen nərmama nepwɨn mwi həuvən fwe ia nəmhien səvənhi mhəpeki nəveɡɨnien sə ruvəmruə, mhəpeki mhəuvehe. ");
INSERT INTO tnk_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kɨmiaha tihəuvən, mətə tihaməkeikei mhəukurən nəri i. Iakamərhi pen kɨmiaha mə tihəuvən mhəmwhen ia kwəti sipsip me sə kamhərer ia kurkwai kuri əprmɨn me. ");
INSERT INTO tnk_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tihəpwəh nuvehiien tənərɨpw sə kavai pen mane irə, uə tənərɨpw sə kavai pen nəveɡɨnien irə, uə put səkɨmiaha. Tihəpwəh napwɨsien ia suatuk, mhəɡkiari kɨmiaha iərmama riti. ");
INSERT INTO tnk_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nəfe nimwə tihəuvnimwə irə, tihəkupwən mhəni mə, ‘Nəmərinuien ramarə ia nimwə i.’ ");
INSERT INTO tnk_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Trɨni mɨnuə iərmama səvəi nimwə nəha rokeikei nəmərinuien nəha, nəmərinuien səkɨmiaha trəuiui in. Mətə mə rekəm, trɨrərɨɡ mwi tukumiaha. ");
INSERT INTO tnk_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kɨmiaha tihamarə rerɨn ia nimwə kuatia a, mhəpwəh nevən əpnapenien ia nimwə me. Nəfe nari irəha tuhəuvei pehe m kɨmaha, tihəuvehi mhani mhənɨmwi. Tiho iamɨnha irə tɨ nəri nə mə kɨmiaha hiəmwhen ia nərmama kamhowok. Ratukwatukw mə irəha tuhərəku pehe narimnari me nəha m kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Trɨni mɨnuə kɨmiaha hiəuvən ia taon riti, nənə nərmama me ikɨn həuvehi puvnimwə kɨmiaha ia nimwə me səvənraha, tihani nəfe nəveɡɨnien sə tuhəuvei pehe m kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nərmama səməme nemhəien rarə ia nirəha, tiho irəha həuvehe mhəsanɨn. Tihəni pen tɨ nirəha i mə, ‘Nɨtətə sə Kumwesən ramərɨmənu irə ruvəuvehe ipaka tukumiaha.’ ");
INSERT INTO tnk_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mətə trɨni mɨnuə kɨmiaha hiəuvən ia taon riti, nənə nərmama me ikɨn həpwəh nəsevərien ia rerɨnraha tukumiaha, tihəuvən, mhərer ia kurkwai suatuk me, mhəni irapw iamɨnhi irə mə, ");
INSERT INTO tnk_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nɨməkwrur ia taon i səkɨmiaha i raməmak ia nɨsumaha, kɨmaha tahahakwi raka tɨ nəri nə mə kɨmiaha hiəno noien ərəha. Kɨmiaha tihaməkeikei mhəukurən nəri i. Nɨtətə sə Kumwesən ramərɨmənu irə ruvəuvehe ipaka tukumiaha, mətə kɨmiaha hiənəpwəh.’ ");
INSERT INTO tnk_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Iou iakani pehe tukumiaha i ia nəpɨn nəha Kumwesən trərpwɨn noien ərəha me irə nərpwɨnien səvəi nərmama ia taon nəha trɨskai məpi raka nərpwɨnien səvəi nəkur Sotom.” ");
INSERT INTO tnk_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Trərəha anan tukumiaha nəkur Korasin! Trərəha anan tukumiaha nəkur Petsaeta! Iakɨno raka nɨmtətien asori me ia taon mi səkɨmiaha, mətə kɨmiaha hiəpkəpwəh mhə noien ərəha me səkɨmiaha. Rɨpɨni mɨnuə iakɨno nɨmtətien me nəha ia taon mi nəha Taea mɨne Saeton, tui raka ko nərmama me ikɨn hənarkahu raka tɨnari ivɨs, mhəkure ia nɨmwrakw, mhəpwəh noien ərəha me səvənraha. ");
INSERT INTO tnk_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mətə ia nəpɨn nəha Kumwesən trərpwɨn noien ərəha me irə nərpwɨnien səkɨmiaha trɨskai məpi raka nərpwɨnien səvəi nəkur Taea mɨne Saeton. ");
INSERT INTO tnk_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nənə kɨmiaha nəkur Kapaneam. Tukəfo ia kɨmiaha? Ko kuvehi utə kɨmiaha hiəuvən ia neiai? Rekəm! Tukuvehi irapw kɨmiaha hiəuvən inhərɨpw Imwei Nəkur Həuvamhə.” ");
INSERT INTO tnk_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nənə Iesu rɨni pen tɨ nərmama me səvənhi mə, “Iərmama sə ramətərɨɡ ia nəɡkiariien səkɨmiaha rəmwhen mə ramətərɨɡ mwi ia nəɡkiariien səiou. Iərmama sə rauvei pen təkutan m kɨmiaha rəmwhen mə rauvei pehe mwi təkutan miou. Nənə iərmama sə rauvei pehe təkutan miou rəmwhen mə rauvei pen mwi təkutan m Kumwesən sə rɨnərhi pehe iou iakuvehe.” ");
INSERT INTO tnk_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nərmama me nəha irəha pam sefenti-tu hərərɨɡ mwi mhəuvehe tɨ Iesu, mamhaɡien, mamhəni mə, “Iərɨmənu. Nəremhə me irəha mwi ho nəkwamaha nəpɨn iahəɡkiari mɨnraha ia nəɡhɨm.” ");
INSERT INTO tnk_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Iakɨnətoni kərarki irapw Setan rier ia neiai meiwaiu pehe rəmwhen ia nouapɨrien. ");
INSERT INTO tnk_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Həreɡi ro. Iakuvəuvei pehe raka nasoriien m kɨmiaha. Kɨmiaha hiəukurən neivəien ia snek me mɨne mimi me sə kamhəpi mamho nəmisəien m nərmama. Iakɨməuvehi utə kɨmiaha hiasori ia nɨskaiien me pam səvəi Setan. Nari riti riwən tro nəmisəien m kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nəri nəha ro nɨpərhienien. Mətə rərəha kɨmiaha hiamaɡien tɨ nəri nə mə nəremhə me kamho nəkwamiaha. Kɨmiaha tihaməkeikei mhaɡien tɨ nəri nə mə Kumwesən ruvərai pen raka nəɡhɨmiaha fwe ia neiai.” ");
INSERT INTO tnk_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ia nəpɨn a mwi nəha Iesu rerɨn ruvehe mukuər ia naɡienien səvəi Nənɨmwɨn Ikinan, nənə in rɨni mə, “Tata səiou Iərɨmənu ia neiai mɨne tɨprənə iakani tanak tukw ik tɨ nəri nə mə ikɨnərkwafə narimnari me i. Nərmama səməme həukurən nari mɨne səməme kɨnahatən amasan irəha həpkətoni mhə. Mətə iko pui pen m nərmama səməme həmwhen ia nɨpwnəti nəkwərhakwərha me hətoni. Ouəh, Tata. Nəri nəha ikɨno ramesi pen a nətərɨɡien amasan səim. ");
INSERT INTO tnk_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tata səiou rɨnəmri pehe raka narimnari me pam ia tɨpaɡe rəɡɨk, iou tɨni. Nənə iərmama riti riwən rukurən iou, mətə Tata səiou əpa. Nənə iərmama riti riwən rukurən səiou Tata. Iou əpa mɨne nərmama me nəha səməme rerɨk raɡien mə tako pui pen in mɨnraha.” ");
INSERT INTO tnk_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Iesu ruvsini in, məɡkiari pen əpa m səvənhi nərmama me, mɨni mə, “Rerɨmiaha traɡien tɨ nəri nə mə kɨmiaha hiamətə narimnari me i ia nəmrɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Iakani pehe tukumiaha i mə fwe kupwən profet me həpɨk mɨne kiɡ me həpɨk hokeikei mə tuhətə narimnari me i hiamətə, mətə həpkətə mhə. Hokeikei mə tuhəreɡi nəɡkiariien me i hiamreɡi, mətə həpkreɡi mhə.” ");
INSERT INTO tnk_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ia nəpɨn nəha, iahatən riti səvəi Loa rokeikei mə trɨreɡi atukwatukw ro Iesu mə trəfni irə. Ro pen rɨskəmter, mɨni mə, “Iahatən. Takəfo irə muvehi nɨmɨruien rerɨn?” ");
INSERT INTO tnk_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Mɨreɡi Iesu rɨni mə, “Nəkukuə Ikinan rani nəfe? Nəpɨn ikəvsini Loa nəha mɨreɡi rɨməfni irə?” ");
INSERT INTO tnk_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mɨreɡi iahatən səvəi Loa rɨni mə, “Tikaməkeikei mokeikei Iərɨmənu Kumwesən səim ia rerɨm me pam, mokeikei in ia nɨmɨruien me pam səim, mokeikei in ia nɨskaiien me pam səim, mokeikei in ia nətərɨɡien me pam səim, nənə tikaməkeikei mokeikei piam rəmwhen ikokeikei atukw a ik.” ");
INSERT INTO tnk_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Mɨreɡi Iesu rɨni pen tukwe in mə, “Nəɡkiariien səim ratukwatukw. Trɨni mɨnuə iko narimnari me i Nəkukuə Ikinan rani, tikuvehi nɨmɨruien irə.” ");
INSERT INTO tnk_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mətə iahatən səvəi Loa rokeikei mə treikuə irə mə in iəmə atukwatukw. Ro pen rɨni pen tɨ Iesu i mə, “Sin nə piak?” ");
INSERT INTO tnk_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Mɨreɡi Iesu rɨni mə, “Iərmama riti rier ia Jerusalem mameiwaiu mamevən ia Jeriko. Nərmama nepwɨn sə kamhakres həkwtəmhiri, mhəpeki raka mane mɨne tɨnari səvənhi, mhousi in, mhap raka irə, mhəpwəh raməmak ipaka remhə. ");
INSERT INTO tnk_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ia nəpɨn nəha pris riti ramesi pen suatuk nəha, mətoni iəmə nəha, rukurau irə ia nɨkare suatuk mamevən. ");
INSERT INTO tnk_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kurirə irə kwənəkwus riti səvəi Livae sə ramasitu ia pris me ro mwi iamɨnhi, muvehe ia kwopun nəha, mətoni iəmə nəha, mukurau mwi irə ia nɨkare suatuk mamevən. ");
INSERT INTO tnk_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Mətə iəmə Sameria riti in mwi ramesi pen suatuk nəha, ruvehe ia kwopun nəha iəmə nəha raməmak ikɨn. Nəpɨn rətoni iəmə nəha, rerɨn rərkwəpɨr tukwe. ");
INSERT INTO tnk_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","In revən ipaka tukwe maikuas ia nɨmwapw me səvənhi ia oel mɨne waen, nənə muveɡi tərini nɨmwapw me, mərəhi utə iəmə nəha mukurei pen in ia təkure toɡki səvənhi, nənə muvehi mevən ia nimwə sə kamərəku pen kamapri ikɨn, mamətui amasan tukwe. ");
INSERT INTO tnk_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kɨni rakwakwi irə, ruvehi irapw silin kəru kɨno ia silva, muvei pen m iərmama nəha sə kamərəku pen min kamapri ia nimwə səvənhi, mɨni mə, ‘Tikətui amasan tɨ iəmə i. Trɨni mɨnuə ikouraha mane me nepwɨn səim məpi raka səməmi iakauvei pehe mik, nəpɨn takrərɨɡ muvehe, takərpwɨn pehe mik.’” ");
INSERT INTO tnk_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nənə Iesu rəres mə, “Ikaməfətərɨɡ irə? Sin ia nirəhar i ro rəmwhen ia in piəvi iəmə nəha nərmama səməme kamhakres həkwtəmhiri?” ");
INSERT INTO tnk_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mɨreɡi iahatən səvəi Loa rɨni mə, “Sə nəha rɨnapi tukwe masitu irə.” Mɨreɡi Iesu rɨni pen tukwe in mə, “Ik tikevən mo mwi iamɨnhi.” ");
INSERT INTO tnk_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nəpɨn Iesu mɨne nərmama me səvənhi kamhesi pen suatuk səvənraha mamhəuvən, həier pen ia rukwənu riti. Pran riti fwe ikɨn nəɡhɨn nə Marta rəsevər ia nimwə səvənhi mə Iesu truvnimwə irə. ");
INSERT INTO tnk_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Prən nəha piəvni riti nəɡhɨn nə Meri. Nəpɨn Iərɨmənu səkɨtaha ruvnimwə pehe, Meri revən məkure ipaka tukwe, mamətərɨɡ nəɡkiariien səvənhi sə ramahatən nərmama me irə. ");
INSERT INTO tnk_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mətə Marta ko rɨpkəkure mhə mhətərɨɡ i tɨ nəri nə mə rasui raka pɨk nəveɡɨnien sənəi nərmama. Nənə in revən tɨ Iesu, mɨni mə, “Iərɨmənu. Rəfo? Ratukwatukw mə piak rəpwəh iou, iou əpa iakasui raka nəveɡɨnien sənəi nərmama me? Ni pen tukwe in mə traməkeikei masitu ia nirak.” ");
INSERT INTO tnk_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mətə Iərɨmənu səkɨtaha rɨni pen tukwe in mə, “Marta, Marta! Ikamətərɨɡ tɨ narimnari me rɨpɨk. Rerɨm ko rɨpkapwɨs mhə. ");
INSERT INTO tnk_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mətə nari kuatia a kɨmiaha tihaməkeikei mho. Tihətərɨɡ ia nəɡkiariien səiou. In nə ramasan pɨk, Meri ramo. Ro pen iou takəpwəh nɨniseien in.” ");
INSERT INTO tnk_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nəpɨn riti Iesu raməfwaki ia kwopun riti, məfwaki pam, nənə iərmama riti səvənhi rɨni pen tukwe in mə, “Iərɨmənu. Tikahatən ro kɨmaha tahəfəfwaki irə rəmwhen ia Jon rɨnahatən nərmama me səvənhi irə.” ");
INSERT INTO tnk_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Nəpɨn kɨmiaha tihəfwaki, tihəni iamɨnhi irə mə, ‘Tata, pwəh nərmama həsiai nəɡhɨm ro ikinan i. Pwəh nɨtətə sə ikamərɨmənu irə ruvehe. ");
INSERT INTO tnk_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tikuvei pehe nəveɡɨnien sənəmaha rəmwhen səvəi nəpɨn ipwet. ");
INSERT INTO tnk_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tikenouenou noien ərəha me səkɨmaha tɨ nəri nə mə kɨmaha mwi iahamenouenou noien ərəha me səməme nərmama hamo ia kɨmaha. Tikəpwəh niri penien kɨmaha ia kwopun tahəmwei ia nərəhaien ikɨn.’” ");
INSERT INTO tnk_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nənə Iesu rarə mɨni pen mwi tɨ nirəha i mə, “Sin ia kɨmiaha trevən tɨ in riti ia kurkwai nəpɨn ia nəpɨn, nənə mɨni pen tukwe in mə, ‘Iou riti. Uvei pehe ro bred kahar. ");
INSERT INTO tnk_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Piak riti ruku pen isipwɨn muvehe təkwtəkwuni, mətə nəveɡɨnien sənak riwən mə takuvei pen min’? ");
INSERT INTO tnk_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Iəmə nəha ia nəkwai nimwə trəɡkiari mə, ‘Tikəpwəh nometəien iou. Iakɨnərəpinhə raka. Kɨmaha nəkwərhakwərha me səiou iahənapri raka. Ko iakəpwəh nɨskəmterien muvei pehe nari riti mik.’” ");
INSERT INTO tnk_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nənə Iesu rɨni mə, “Nɨpərhienien iəmə nəha rɨni mɨnuə ko in rɨpkɨskəmter mhə muvei pen nari riti min. Mətə iakani pehe tukumiaha i in trɨskəmter muvei pen nəfe nari iərmama nəha raməres i. In trɨpko mhə iamɨnhi irə tɨ nəri nə mə raməkwein iərmama nəha mə in riti, mətə in tro tɨ nəri nə mə iərmama nəha rəres in, məpwəh naurɨsien. ");
INSERT INTO tnk_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Iakani pehe tukumiaha i trɨni mɨnuə kɨmiaha hiokeikei nari riti, ramasan mə tihəres, nənə tukuvei pehe m kɨmiaha. Tihətui əmisə i, nənə tihətoni. Tihəkunkun ia təpinhə, nənə tukəsevər tukumiaha. ");
INSERT INTO tnk_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Iərmama sə raməres nari truvehi nari. Iərmama sə ramətui əmisə nari trətoni. Iərmama sə rakunkun ia təpinhə tukəsevər tukwe. ");
INSERT INTO tnk_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Sin ia kɨmiaha tata me nəpɨn iəkunouihi səvənhi rəres nəmu, trəpwəh nuvei penien nəmu, mətə truvei pen snek min? ");
INSERT INTO tnk_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","13","Uə trɨni mɨnuə rəres kwənəre menu, truvei pen mimi sə trəpi mo nəmisəien min? Rekəm! Kɨmiaha tihaməkeikei mhəuvei pen narimnari amasan me m nəkwərhakwərha me səkɨmiaha. Mə kɨmiaha nəkur ərəha hiəukurən noien iamɨnhi irə, hiaməfətərɨɡ ia Tata səkɨmiaha ia neiai? In truvei pen Nənɨmwɨn Ikinan rasori mwi m nərmama səməme kamhəres in tukwe.” ");
INSERT INTO tnk_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nəpɨn riti Iesu raməkoui irapw iəremhə riti sə ramarə ia iərmama riti. Iərmama nəha ko rɨpkəɡkiari mhə, mətə nəpɨn iəremhə ruvəier irə, rɨnaməɡkiari. Nənə nərmama me hətoni hərkərinari irə. ");
INSERT INTO tnk_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mətə irəha me nepwɨn həni mə, “Iəmə nəha raməkoui irapw nəremhə me ia nɨskaiien səvəi Pielsepul, iəremhə sə in rasori ia nəremhə me.” ");
INSERT INTO tnk_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nərmama nepwɨn mwi kamhəres pen Iesu i mə, “Ko iko ro nɨmtətien riti sə ruku pen ia neiai pwəh iahətoni mhəukurən mə ik pərhien Kumwesən rərhi pehe ik?” ");
INSERT INTO tnk_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mətə Iesu ruvəukurən raka nətərɨɡien səvənraha, nənə rɨni pen tɨ nirəha i mə, “Trɨni mɨnuə ieni riti ruai narəien səvənhi ro kəru irə, nərmama me səvənhi kamhousi irəha me, nɨtətə sə ieni nəha ramərɨmənu irə truvehe mərəha. Trɨni mɨnuə nərmama səməme kamharə ia nəkwai nimwə riti həuai narəien səvənraha ro kəru irə, kamhousi irəha me, irəha ko həpkarə amasan mhə. ");
INSERT INTO tnk_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Trɨni mɨnuə Setan ruai narəien səvənhi ro kəru irə, raməkoui irapw nəremhə me səvənhi ia nərmama, nɨtətə sə in ramərɨmənu irə trəfərer əpwəmwɨs? Trəsas miwən. Iakani iamɨnhi irə tɨ nəri nə mə kɨmiaha hiaməni iou mə iou iakaməkoui irapw nəremhə me ia nɨskaiien səvəi Pielsepul. ");
INSERT INTO tnk_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Trɨni mɨnuə nəɡkiariien nəha səkɨmiaha ro nɨpərhienien, rəfo ia nərmama me səkɨmiaha? Irəha kamhəkoui irapw nəremhə me ia nɨskaiien səvəi sin? Səvəi Setan? Rekəm! Ro pen ramasan mə irəha həkiri nəɡkiariien i səkɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mətə iou iakaməkoui irapw nəremhə me ia nɨskaiien səvəi Kumwesən. Noien nəha ramahatən pen mə nɨtətə sə Kumwesən ramərɨmənu irə ruvəuvehe raka tukumiaha. ");
INSERT INTO tnk_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Nəpɨn iəmə skai riti rauvehi narimnari me səvəi naruaɡənien ia rəɡɨn, mamərer tukuahaɡ ia nimwə səvənhi, nautə me səvənhi iərmama riti ko rɨpkuvehe mhə makres i. ");
INSERT INTO tnk_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mətə trɨni mɨnuə iəmə riti nɨskaiien səvənhi rasori mwi irə ruvehe, in traruaɡən irau min ruvehi irapw in, mɨpeki raka narimnari me səvənhi sə ramərer irə mamaruaɡən. Nənə kurirə irə, in truai narimnari me sə in rɨməpeki raka ia rəɡi iəmə skai nəha, mɨpeki pen mɨne in me nepwɨn. ");
INSERT INTO tnk_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Iərmama sə rɨpkukurirə mhə iou in raman əpə ia nirak. Nənə iərmama sə rɨpkasitu mhə ia nirak, mɨpeki nərmama mhəuvehe tukw iou, in raməkoui kɨrkɨri irəha.” ");
INSERT INTO tnk_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Nəpɨn kɨnəkoui irapw nənɨmwɨn ərəha riti ia iərmama, nənɨmwɨn ərəha nəha trəfo irə? Trevən mavən ia kwopun me sə nui riwən ikɨn, mamətui kwopun trapwɨs ikɨn. Nəpɨn rɨpkətoni mhə, trəɡkiari iamɨnhi irə mə, ‘Takrərɨɡ mwi mevən tɨ nimwə fwe səiou sə iakɨməier irə.’ ");
INSERT INTO tnk_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nənə nəpɨn rɨrərɨɡ muvehe, trətoni mə nimwə nəha kɨnaies amasan irə, narimnari me pam kamhəmrɨmər a ia təmwhekɨnraha. ");
INSERT INTO tnk_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nənə in trevən miri mwi nənɨmwɨn ərəha me sefen səməme hərəha mhəpi raka in, miri irəha mhəuvehe, mhəuvnimwə mwi, nənə mharə ia reri iərmama nəha. Nənə nɨmɨruien səvəi iərmama nəha truvehe mərəha anan məpi raka sə kupwən.” ");
INSERT INTO tnk_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nəpɨn Iesu rani irapw narimnari me nəha, pran riti ia reri nərmama rəkwein əpwəmwɨs, mɨni pen tɨ Iesu i mə, “Pran sə rərəhi ik, muvei pen kənunu mik, rukurən naɡienien.” ");
INSERT INTO tnk_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Mətə Iesu rɨni pen tukwe in mə, “Mətə nərmama səməme kamhəreɡi nəɡkiariien səvəi Kumwesən, nənə mamho nəkwan həukurən naɡienien mwi mhəpi raka.” ");
INSERT INTO tnk_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nəpɨn nərmama me həuvehe mənamhəpɨk, Iesu rɨni mə, “Nərmama ipwet mɨne irəha nəkur ərəha. Kamhətui a nɨmtətien. Kumwesən trəpwəh nuvei penien nɨmtətien riti mwi mɨnraha, mətə nɨmtətien əpa səvəi Profet Jona. ");
INSERT INTO tnk_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Fwe kupwən Profet Jona ruvehe mo nɨmtətien irə mɨne nəkur Nineve. Rəmwhen a mwi iou, Iəməti Iərmama, takuvehe mo nɨmtətien ia nirak mɨne nərmama ipwet mɨne. ");
INSERT INTO tnk_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ia nəpɨn nəha Kumwesən trərpwɨn noien ərəha me irə, prən asori sə rɨnamərɨmənu ia tənə Sipa fwe kupwən trərer irəha nərmama ipwet mɨne, nənə mɨni mə irəha nəkur ərəha me. Iakani iamɨnhi irə tɨ nəri nə mə prən nəha ruku pen ia nɨkare tənə fwe isipwɨn anan muvehe mə trɨreɡi nukurənien səvəi Solomon. Mətə hətə ro! Iərmama riti in rasori ia Solomon in i ia kwopun i. ");
INSERT INTO tnk_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ia nəpɨn nəha Kumwesən trərpwɨn noien ərəha me irə, nəmə Nineve tuhərer irəha nərmama ipwet mɨne, nənə mhəni mə irəha nəkur ərəha me. Iakani iamɨnhi irə tɨ nəri nə mə nəpɨn nəmə Nineve həreɡi Jona raməvisau, irəha hərərɨɡ ia noien ərəha me səvənraha. Mətə hətə ro! Iərmama riti in rasori ia Profet Jona in i ia kwopun i.” ");
INSERT INTO tnk_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Iərmama riti riwən ko rɨhiai pen napw ia laet mukurei pen ia kwopun afafa ikɨn uə rəuiui ia nari riti, mətə trukurei utə i ia nəri kakurei utə laet irə mə nərmama səməme həuvnimwə pehe tuhətoni raməhiəpwɨn nari. ");
INSERT INTO tnk_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nənimem nə rauvei pehe nukuraanien m nɨpwram. Nəpɨn nənimem rəsanɨn, nɨpwram pam rukuər ia nukuraanien. Mətə nəpɨn nənimem rərəha, nɨpwram pam rukuər ia nəpitəvien. ");
INSERT INTO tnk_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ro iamɨnhi irə tikaməkeikei mhəskun amasan nukuraanien nəha ia rerɨm mə rɨpko mhə nəpitəvien irə. ");
INSERT INTO tnk_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mə nɨpwram pam rukuər ia nukuraanien sə nəpitəvien riti riwən irə, trəhiapw amasan rəmwhen ia laet sə raməhiapw mauvei pehe nukuraanien mik.” ");
INSERT INTO tnk_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nəpɨn Iesu raməɡkiari ihi, Farisi riti rəres pen in mə trevən ia nimwə səvənhi, məni pəri nari irau min. Ro pen Iesu revən muvnimwə məkure mə trəni nari. ");
INSERT INTO tnk_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nənə Farisi nəha rərkərinari nəpɨn rətoni mə Iesu rɨpkukupwən mhə mərkwerɨɡ kurirə rəni nari. ");
INSERT INTO tnk_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nənə Iərɨmənu səkɨtaha rɨni pen tukwe in mə, “Kɨmiaha Farisi me noien səkɨmiaha rəmwhen ia tɨkikap mɨne tikinari kamaikuas irə iruə rəmher mətə nəkwan rəmkemɨk. Fwe imwə rerɨmiaha rukuər ia nakresien mɨne nərəhaien. ");
INSERT INTO tnk_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kɨmiaha me i hiəreirei nari. Hiaməfətərɨɡ irə mə Kumwesən sə rɨno nəri iruə rɨpko mhə mwi sə fwe imwə? ");
INSERT INTO tnk_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mətə ramasan mə kɨmiaha hiəuvehi nəveɡɨnien mɨne nui sə krouəmak ia nəkwai tɨkikap me mɨne tikinari me səkɨmiaha, mhəuvehi mhəuvei pen m nərmama nautə səvənraha riwən. Nənə tihətoni narimnari me pam tuhəmher tukumiaha. ");
INSERT INTO tnk_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Mətə trərəha anan tukumiaha Farisi me tɨ nəri nə mə kɨmiaha hiaməuai narimnari me pam səkɨmiaha ia kusen ten, mamhəuvei pen riti m Kumwesən. Hiamo iamɨnhi irə ia nəri ouihi rəmwhen ia nɨmwai nei me səməme kavi rərəɡi pen ia nəveɡɨnien. Mətə hiənenouenou noien atukwatukw səvəi nəkiriien iərmama, mhənenouenou mwi noien səvəi nokeikeiien Kumwesən. Ramasan mə kɨmiaha hio noien mi nəha, mhəpwəh nenouenouien mwi sə nəha hiamo ia nəri ouihi. ");
INSERT INTO tnk_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Trərəha anan tukumiaha Farisi me tɨ nəri nə mə ia nəkwai nimwəfwaki me səvəi nəkur Isrel hiokeikei mə tihəkure ia kwopun amasan me. Ia kwopun kamomaket me ikɨn hiokeikei mə nərmama tuhəkwein kɨmiaha ia nɨsiaiien. ");
INSERT INTO tnk_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Trərəha anan tukumaha tɨ nəri nə mə kɨmiaha hiəmwhen ia kref me kɨpko mhə mak ia nirəha, nənə nərmama həreirei mamhavən utə ia nirəha.” ");
INSERT INTO tnk_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ia nəpɨn nəha iahatən riti səvəi Loa rɨni pen tɨ Iesu i mə, “Iahatən. Nəpɨn ikani nəɡkiariien me nəha, ikani ərəha mwi kɨmaha.” ");
INSERT INTO tnk_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Mɨreɡi Iesu rɨni mə, “Trərəha anan mwi tukumiaha nahatən me səvəi Loa tɨ nəri nə mə hiaməkeikei m nərmama me mə tuhesi pen loa skai me səməme həmwhen ia katipə sə rɨpam. Mətə kɨmiaha ko hiəpkuvei pen mhə nukwai rəɡɨmiaha riti mhasitu ia nirəha tɨ natipəien. ");
INSERT INTO tnk_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Trərəha anan tukumiaha tɨ nəri nə mə kɨmiaha hiəuvrhəkɨn kref me səvəi profet me səməme kaha kupwən me səkɨmiaha hənousi əpune irəha. ");
INSERT INTO tnk_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ia noien nəha kɨmiaha hiamo pui atukw a kɨmiaha mə rerɨmiaha raɡien ia narimnari me nəha kaha kupwən me səkɨmiaha həno. Irəha hənousi əpune profet me, nənə kɨmiaha hiəuvrhəkɨn kref me səvənraha. ");
INSERT INTO tnk_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ro iamɨnhi irə Kumwesən sə rukurən pam nari rɨni mə, ‘Iou takərhi pen profet me mɨne aposol me həuvən tɨ nirəha. Irəha tuhousi əpune nepwɨn, mhometə nepwɨn.’ ");
INSERT INTO tnk_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","In tro iamɨnhi irə mɨne mə nərmama ipwet mɨne tuhəuvehi nərpwɨnien tɨ nɨte profet me pam sə rɨnostat maiu ia nukune narəien muvehe. ");
INSERT INTO tnk_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nɨte Epel muvehe meste nɨte Sekaraea sə kɨnousi əpune in ia nimwə səvəi Kumwesən ia nɨmwrhenhi nɨfatə mɨne kwopun sə ro ikinan, iakani nɨpərhienien tukumiaha i nərmama ipwet mɨne tuhəuvehi nərpwɨnien tɨ nɨtenraha pam. ");
INSERT INTO tnk_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Trərəha anan tukumiaha nahatən me səvəi Loa tɨ nəri nə mə kɨmiaha hiərkwafə ki sə raməsevər ia təpinhə ia nimwə nəha nukurənien raməmak ia nəkwan. Kɨmiaha hiəpkuvnimwə mhə, nənə mamhənise mwi səməme hokeikei mə tuhəuvnimwə.” ");
INSERT INTO tnk_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nəpɨn Iesu rier ia kwopun nəha mamevən, nahatən me səvəi Loa mɨne Farisi me həreɡi niemaha rɨnaməpi pɨk irəha. Hənaməres Iesu nəresien me ia narimnari me rɨpɨk. ");
INSERT INTO tnk_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Irəha hamərer mwatuk mə tuhəkwtəmhiri in trɨni mɨnuə rəfwəkour ia nəɡkiariien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ia nəpɨn nəha nərmama həpɨk həmwhen ia taosen m taosen həuvehe mhousəsɨmwɨn irəha me. Kwopun rouihi. Hameivə pen ia nɨsunraha me. Nənə Iesu rukupwən məɡkiari pen m nərmama me səvənhi, mɨni mə, “Kɨmiaha tihaməsiari tɨ yis səvəi Farisi me. Yis nəha in nə noien səvəi kəuətkəsuə. ");
INSERT INTO tnk_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Narimnari me pam səməme kamhərkwafə tuhaməkeikei mhəier irapw. Narimnari me pam səməme kamhəmak afafa tukaməkeikei kətoni kuvehi irapw ia nukuraanien. ");
INSERT INTO tnk_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ro pen nəfe nəɡkiariien kɨmiaha hiəni ia nəpitəvien nərmama tuhəreɡi ia nukuraanien. Nəfe nəɡkiariien kɨmiaha hiəsivən irə ia kwopun afafa tukɨni irapw ia təkure nimwə me.” ");
INSERT INTO tnk_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Iou me nepwɨn, iakani pehe tukumiaha i mə kɨmiaha tihəpwəh nehekɨrien nərmama səməme həukurən nousi əpuneien nɨpwramiaha mətə kurirə irə ko həpko mhə nari riti mwi. ");
INSERT INTO tnk_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mətə takɨni pehe tukumiaha i sin nəha tihaməkeikei mhehekɨr i. Tihaməkeikei mhehekɨr Kumwesən tɨ nəri nə mə nəpɨn in rɨnousi əpune raka iərmama, rauvehi nasoriien tɨ nosə penien in ia kwopun napw asori rauək ikɨn. Ouəh, nɨpərhienien, iakani pehe tukumiaha i mə kɨmiaha tihaməkeikei mhehekɨr in. ");
INSERT INTO tnk_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Rerɨmiaha rɨrhi ro kwəti menu me. Nənimenraha reiwaiu. Kauvehi krirum ia silin sə rouihi anan kəru, mətə kwəti menu me nəha Kumwesən ko rɨpkenouenou mhə riti. ");
INSERT INTO tnk_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hətə ro nɨmwai nukwənemiaha, mətə Kumwesən rɨnəvsini pam raka irəha. Ro iamɨnhi irə kɨmiaha tihəpwəh nehekɨrien. Ia nənimen kɨmiaha hiamasan mwi mhəpi raka kwəti menu me nəha həpɨk.” ");
INSERT INTO tnk_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Iakani pehe tukumiaha i. Iərmama sə trɨni irapw ia nəmri nərmama me mə in iərmama riti səiou, Iou mwi Iəməti Iərmama takɨni irapw ia nəmri naɡelo me səvəi Kumwesən mə in iərmama riti səiou. ");
INSERT INTO tnk_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mətə iərmama sə trɨni irapw ia nəmri nərmama me mə in rɨreirei iou, iou mwi takɨni irapw ia nəmri naɡelo me səvəi Kumwesən mə iakreirei in. ");
INSERT INTO tnk_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Iərmama sə trɨni nəɡkiariien ərəha riti, muəsi Iou Iəməti Iərmama irə, Kumwesən rukurən nenouenouien nərəhaien səvənhi, məpwəh nərpwɨnien. Mətə iərmama sə trɨni nəɡkiariien ərəha riti, muəsi Nənɨmwɨn Ikinan irə, Kumwesən trɨpkenouenou mhə nərəhaien səvənhi ia nəpɨn riti. Nərpwɨnien səvənhi trarə rerɨn. ");
INSERT INTO tnk_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nərmama tuhəuvehi kɨmiaha, mhərpwi irapw kɨmiaha ia nəmri nəmə asori me səvəi nimwəfwaki me səvəi nəkur Isrel mɨne ia nəmri nərmama səməme kamhərɨmənu mɨne səməme kamhəuvehi nasoriien mə irəha tuhəkiri nəɡkiariien me səkɨmiaha. Ia nəpɨn nəha kɨmiaha tihəpwəh nətərɨɡ pɨkien mə tihəfo mhosərɨpɨn nəɡkiariien səvənraha uə tihəni nəfe nəɡkiariien tɨ nirəha i. ");
INSERT INTO tnk_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tihəpwəh nətərɨɡ pɨkien irə, tɨ nəri nə mə nəpɨn atukwatukw nəha səkɨmiaha sə tihəɡkiari irə, Nənɨmwɨn Ikinan trahatən kɨmiaha ia nəfe nəɡkiariien tihəni.” ");
INSERT INTO tnk_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Iərmama riti ia reri nərmama me nəha rɨni pen tɨ Iesu i mə, “Iahatən. Tata səiou ruvamhə raka. Ni pen tɨ piak i mə pwəh kɨmrau iarouwai pəri narimnari me nəha tata rɨnəmri mə səkɨmrau.” ");
INSERT INTO tnk_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mətə Iesu rɨni pen tukwe in mə, “Iərman. Sin mə takəmri amasan nəvisəien səkɨmirau? Rɨpko mhə wok səiou nə.” ");
INSERT INTO tnk_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nənə Iesu rɨni pen tɨ nirəha i mə, “Kɨmiaha tihətui amasan, mhəpwəh nəseniien noien i kɨmiaha hiokeikei mə tihəuvehi nautə me rɨpɨk. Nukune nɨmɨruien səvəi iərmama rɨpko mhə in nə nautə asori səvənhi.” ");
INSERT INTO tnk_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nənə Iesu rɨni nusipekɨnien riti tɨ nirəha i mə, “Iərmama riti nautə səvənhi rasori. Nəveɡɨnien rasori pɨk ia nəmhien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Rerɨn rɨrhi mɨnuə ‘Takəfo i? Kwopun riti mwi səiou takəmri amasan nəveɡɨnien sənak ikɨn riwən.’ ");
INSERT INTO tnk_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Iərmama nəha ramətərɨɡ tukwe, nənə mɨni mə, ‘Ah, iakukurən nəfe tako. Takeitehi nimwə me səiou, nənə muvrhəkɨn tain me rasori mwi. Ia nimwə me nəha takəmri pen nəveɡɨnien me sənak mɨne narimnari amasan me pam səiou.’ ");
INSERT INTO tnk_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nəpɨn iərmama nəha rɨno pam, in rəɡkiari iamɨnhi irə mɨni mə, ‘Səiou narimnari amasan me sə iakɨməfate i ruvəpɨk. Takɨmɨru irə nuk rɨpɨk. Ramasan mə takapwɨs, məveɡɨn, mənɨmwi, maɡien.’ ");
INSERT INTO tnk_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mətə Kumwesən rɨni pen tukwe in mə, ‘Ik iərmama ikreirei nari. Ipwet ia nəpɨn tako ik ikemhə. Nənə tukəfo ia narimnari me nəha ikɨnəpnəpenə irə? Sin truvehi?’ ");
INSERT INTO tnk_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Noien nəha rəmwhen mwi iərmama sə ramoeite nautə me səvənhi mə səvənhi əpa, mətə ia nəmri Kumwesən in iəmə auər a.” ");
INSERT INTO tnk_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nənə Iesu rɨni pen tɨ səvənhi nərmama me i mə, “Ro iamɨnhi irə iakani pehe tukumiaha i kɨmiaha tihəpwəh nətərɨɡ pɨkien tɨ nɨmɨruien səkɨmiaha mamhəres nəfe tihani. Tihəpwəh nətərɨɡ pɨkien ia nɨpwramiaha mamhəres nəfe tiharkahu i. ");
INSERT INTO tnk_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nɨmɨruien rɨpko mhə səvəi nəveɡɨnien əpa. Nɨpwrai iərmama rɨpko mhə səvəi tɨnari əpa. ");
INSERT INTO tnk_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Hətoni ro menu me ia nɨmaɡouaɡou. Həpwəh nəpweiien nari, mhəpwəh nesiien nukwan. Nimwə səvənraha sə kamhoeite nəveɡɨnien ikɨn riwən. Mətə Kumwesən raməkwməni irəha. Nənə ia nənimen kɨmiaha hiamasan pɨk mhəpi raka menu me. ");
INSERT INTO tnk_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Sin ia kɨmiaha ko ro nɨmɨruien səvənhi rəpwəmwɨs mwi səvəi nəpɨn ouihi a trɨni mɨnuə ramətərɨɡ pɨk tukwe? ");
INSERT INTO tnk_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mə rɨskai tukumiaha tɨ noien nəri nəha rouihi, rəfo hiamətərɨɡ pɨk tɨ narimnari me nepwɨn mwi? ");
INSERT INTO tnk_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Hətoni ro tihinari me mə kamhəfəutə irə. Irəha həpwəh noien wok, mhəpwəh nɨtiriien tɨnari. Mətə iakani pehe tukumiaha i Kiɡ Solomon fwe kupwən nautə səvənhi rasori pɨk, mətə tɨnari səvənhi rɨpkamasan mhə rəmwhen ia tihinari me i. ");
INSERT INTO tnk_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kɨmiaha nahatətəien səkɨmiaha rɨpkɨskai mhə. Kumwesən rauvei pen tɨnari amasan me m tihinari me, nəri auər a tihinari me kamhəmɨru ipwet mətə trakwakwi haukei, mhəsas, kuvani ia napw. Mə Kumwesən ramo iamɨnha irə, in truvei pehe mwi tɨnari m kɨmiaha məpi raka. ");
INSERT INTO tnk_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kɨmiaha tihəpwəh nətui əmisəien nəfe tihani uə nəfe tihənɨmwi. Kɨmiaha tihəpwəh nətərɨɡ pɨkien tukwe, ");
INSERT INTO tnk_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","tɨ nəri nə mə nərmama ia tənəmtənə me ia təkure tɨprənə i kamhətui əmisə narimnari me nəha, nənə Tata səkɨmiaha ruvəukurən raka narimnari me nəha mə kɨmiaha tihaməkeikei mhəuvehi. ");
INSERT INTO tnk_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mətə kɨmiaha tihaməkeikei mhətui əmisə nɨtətə sə in ramərɨmənu irə, nənə in trəriari pehe mwi narimnari me nəha m kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kɨmiaha i sipsip me səiou hiəpkəpɨk mhə. Tihəpwəh nehekɨrien. Tata səkɨmiaha rerɨn raɡien tɨ nuvei peheien nɨtətə sə in ramərɨmənu irə m kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tihəmri pen nəmri nari ia narimnari me səkɨmiaha, mhəuvehi mane ia nirəha, nənə mhəuvei pen m nərmama nautə səvənraha riwən. Tihəkusi tənərɨpw me sə tuhəpkɨmərɨr mhə ia nəpɨn riti mhəvai pen nautə səkɨmiaha ia nirəha. Tihəfate pen nautə səkɨmiaha fwe ia neiai. Ia kwopun nəha nautə səkɨmiaha ko rɨpkiwən mhə ia nəpɨn riti tɨ nəri nə mə iərmama səvəi nakresien riwən uvne me həpkouraha mhə narimnari. ");
INSERT INTO tnk_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Iakani iamɨnhi irə tɨ nəri nə mə kwopun nautə səkɨmiaha raməmak ikɨn, nətərɨɡien səkɨmiaha traməmak mwi ikɨn.” ");
INSERT INTO tnk_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Kɨmiaha tihaməkeikei mharkahu tɨnari səvəi wok, nənə mhəhiai pen napw ia laet me səkɨmiaha pwəh rauək rerɨn. ");
INSERT INTO tnk_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ho rəmwhen ia nərmama səməme kamheitenhi iəmə asori səvənraha mə trier ia nəveɡɨnien asori səvəi iərman sə kiri pen vi a pran səvənhi, muvehe ia rukwənu səvənhi. Nəpɨn in ruvehe, mɨkunkun təpinhə, təkwtəkwuni a irəha tuhəsevər ia təpinhə tukwe. ");
INSERT INTO tnk_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Trɨni mɨnuə iəmə asori nəha ruvehe mətoni nərmama me nəha səməme kamho tukwini nari min kamhətui mhəpkapri mhə, rerɨnraha traɡien. Iakani nɨpərhienien tukumiaha i iəmə asori nəha trarkahu tɨnari səvənhi səvəi wok, nənə mɨni pen tɨ nirəha mə tuhəkure mhani nari. Nənə in trɨsui raka nəveɡɨnien, muvei pen mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Trɨni mɨnuə iəmə asori nəha ruvehe ia kurkwai nəpɨn, uə ia nəpɨn rəiə rakaka irə, mətoni nərmama me nəha səməme kamho tukwini nari min kamhətui mhəpkapri mhə, rerɨnraha traɡien. ");
INSERT INTO tnk_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mətə kɨmiaha tihaməkeikei mhəukurən nəri i. Trɨni mɨnuə iərmama riti rukurən mə ipwet ia nəpɨn iərmama riti truvehe, muvnimwə ia nəkwai nimwə səvənhi, makres, in tramətui a məpwəh napriien. Ko in rəpwəh nəseniien iərmama riti reitehi nimwə səvənhi, muvnimwə, makres. ");
INSERT INTO tnk_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Rəmwhen a mwi kɨmiaha mwi tihaməkeikei mhəpnəpenə tɨ nəri nə mə iou, Iəməti Iərmama, takuvehe ia nəpɨn riti tihakiraka iou.” ");
INSERT INTO tnk_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Mɨreɡi Pita rɨni mə, “Iərɨmənu. Ikani nusipekɨnien nəha maməɡkiari pehe m kɨmaha əpa uə ikaməɡkiari pen mɨne nərmama me pam?” ");
INSERT INTO tnk_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mɨreɡi Iərɨmənu səkɨtaha rɨni mə, “Iotukwininari sə rukurən nari, mamo nəkwai iəmə asori səvənhi ia nəpɨn me, iəmə asori səvənhi truvehi utə in ruvehe masori ia səvənhi iotukwininari me pam mə trəkwməni irəha ia nəpɨn atukwatukw kamhani nari irə. ");
INSERT INTO tnk_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Trɨni mɨnuə iəmə asori səvəi iotukwininari nəha ruvehe, mətoni mə ramo wok me iamɨnha irə, iotukwininari nəha rerɨn traɡien. ");
INSERT INTO tnk_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Iakani nɨpərhienien tukumiaha i iəmə asori nəha truvehi utə iotukwininari nəha ruvehe masori ia narimnari me pam səvənhi. ");
INSERT INTO tnk_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mətə mə iotukwininari nəha rerɨn rɨnamrhi mə iəmə asori səvənhi ramo tanpen, məpwəh nuvehe akwauakwien, nənə rɨnamousi nərman mɨne nɨpran səməme kamho tukwini pəri nari irəha min, maməveɡɨn, mamənɨmwi, mamakonə, ");
INSERT INTO tnk_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","iəmə asori səvənhi truvehe ia nəpɨn riti in trakiraka in, uə ia aoa riti sə in rɨreirei. Iəmə asori səvənhi trərpwɨn noien ərəha me səvənhi, məmri pen in ramarə irəha nərmama səməme həpkɨni mhə nɨpərhienien ia nəɡkiariien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Iotukwininari sə ruvəukurən raka nəkwai iəmə asori səvənhi, mətə rɨpkəpnəpenə mhə, uə rɨpkesi pen mhə nəkwan, tukərisi pɨk in. ");
INSERT INTO tnk_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mətə iotukwininari sə rɨreirei nəkwai iəmə asori səvənhi, nənə mo nari riti ratukwatukw mə tukərisi in tukwe, tukərisi məru a in. Iərmama sə Kumwesən ruvei pen narimnari me rɨpɨk min traməkeikei mo narimnari me rɨpɨk. Nənə iərmama sə nərmama həmri pen narimnari me rɨpɨk ia rəɡɨn, tuhəres pen in narimnari me rɨpɨk mwi.” ");
INSERT INTO tnk_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nənə Iesu rɨni mə, “Iou iakuvehe mə takərarki pehe napw ia tɨprənə i. Iakuə ko napw nəha ruvəuək raka, mətə rɨpkuək mhə ihi. ");
INSERT INTO tnk_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Səiou riti nəha paptaes tukaməkeikei kakiətənɨmw iou irə. Nənə təkwtəkwuni iakamreɡi rərəha pɨk anan meste tuko sampam irə. ");
INSERT INTO tnk_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nətərɨɡien səkɨmiaha rəfo? Hiənuə iakuvehe mə tako nərmama ia tɨprənə i harə ia nəmərinuien? Iakani pehe tukumiaha i mə iapkuvehe mhə mə tako nərmama harə ia nəmərinuien, mətə iakuvehe mə tako nərmama həuai irəha me. ");
INSERT INTO tnk_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Təkwtəkwuni mamevən trɨni mɨnuə nərmama krirum kamharə ia nəkwai nimwə kuatia, irəha tuhəuai irəha me. Kahar tuharəmwəki kəru. Kəru trouəmwəki kahar. ");
INSERT INTO tnk_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Irəha tuhəuai irəha me. Tata trəmwəki tɨni iərman, tɨni iərman trəmwəki tata səvənhi. Mama trəmwəki tɨni pran, tɨni pran trəmwəki mama səvənhi. Kaka pran trəmwəki prɨsɨni pran, prɨsɨni pran trəmwəki kaka pran səvənhi.” ");
INSERT INTO tnk_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iesu rɨni nəɡkiariien riti mwi tɨ nərmama me mə, “Nəpɨn kɨmiaha hiətoni nəpuə riti rutə ia nukunhi təsi, təkwtəkwuni a hiəni mə, ‘Kwa nesən trauər.’ Nənə nesən rauər. ");
INSERT INTO tnk_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Nənə nəpɨn kɨmiaha hiətoni nɨmətaɡi natoɡə rɨskəmter, hiəni mə, ‘Kwa nukwəsikər travən.’ Nənə nukwəsikər ravən. ");
INSERT INTO tnk_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kɨmiaha kəuətkəsuə me! Hiəukurən nətəien tɨprənə mɨne nɨmaɡouaɡou, nənə mhəukurən nəfe nari irau krouahatən pen. Mətə rəfo hiəreirei nɨpwrai nɨmtətien me i kamo ipwet mɨne?” ");
INSERT INTO tnk_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Kɨmiaha tihaməkeikei mhəkiri suatuk me, mhəni mə sə pəku nəha ratukwatukw. ");
INSERT INTO tnk_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Trɨni mɨnuə iko noien ərəha riti ia iərmama, nənə in rokeikei mə kɨmirau min tirouərer ia nəmri nəmə asori me pwəh həkiri noien səim, ramasan mə tikevən akwauakw, rouəmri atukwatukw nəri nəha nəpɨn ipkevən mhə ihi ia kwopun kaməkiri nəɡkiariien ikɨn. Rərəha iərmama nəha ikɨno noien ərəha irə trəmri pen ik ia rəɡi iəmə sə raməkiri nəɡkiariien, nənə iəmə sə raməkiri nəɡkiariien trəmri pen ik ia rəɡi polis, nənə tukuvehi puvnimwə ik ia kalapus. ");
INSERT INTO tnk_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Iakani nɨpərhienien tukw ik i tikəpwəh nierien meste ikərəku pen pam faen me səim.” ");
INSERT INTO tnk_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ia nəpɨn a mwi nəha, nərmama nepwɨn həuvehe mhəvisau pen m Iesu mə Paelat rɨnousi əpune nəmə Kalili me nepwɨn nəpɨn irəha kamhəvi nɨte nərimɨru me ia nɨfatə səvəi Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Nənə Iesu rɨni pen tɨ nirəha i mə, “Kɨmiaha hiaməfətərɨɡ ia nəmə Kalili me nəha? Irəha hərəha anan mhəpi raka nəmə Kalili me nepwɨn tɨ nəri nə mə irəha hemhə iamɨnha irə? ");
INSERT INTO tnk_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Rekəm! Mətə iakani pehe tukumiaha i kɨmiaha tihaməkeikei mhəpwəh noien ərəha me səkɨmiaha. Mə hiəpwəh noien, kɨmiaha pam tihemhə rəmwhen ia nirəha. ");
INSERT INTO tnk_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Uə kɨmiaha hiaməfətərɨɡ ia nərmama me nəha eitin nimwə riti rəpwəmwɨs mutə rɨmwei, məkure tərini irəha, hemhə? Irəha hərəha anan mhəpi raka irəha me nepwɨn səməme kamharə fwe Jerusalem? ");
INSERT INTO tnk_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Rekəm! Mətə iakani pehe tukumiaha i kɨmiaha tihaməkeikei mhəpwəh noien ərəha me səkɨmiaha. Mə hiəpwəh noien, kɨmiaha pam tihemhə rəmwhen ia nirəha.” ");
INSERT INTO tnk_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Nənə Iesu rɨni nusipekɨnien riti tɨ nirəha i mə, “Iərmama riti rəpwei niemɨs riti ia nəmhien səvənhi. Nənə ia nəpɨn riti ruvehe mamətui nukwan, mətə rɨpkətə mhə riti. ");
INSERT INTO tnk_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ro pen rɨni pen tɨ iərmama sə raməmhu səvənhi mə, ‘Ətə ro. Nuk kahar nəha təkwtəkwuni iakuvehe mamətui kwənkwai niemɨs i, mətə iapkətə mhə riti. Ərai əmwesi! Ramərer auər a ia tɨprənə i.’ ");
INSERT INTO tnk_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mɨreɡi iərmama sə raməmhu səvənhi rɨni mə, ‘Iəmə asori. Əpwəh rərer nuk riti mwi. Pwəh iakeri nukunen mukuraukurau, nənə mərki pen nɨmwinahak sə trasitu irə mutə amasan. ");
INSERT INTO tnk_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Trɨni mɨnuə rərer nuk riti mwi mukuə, ramasan. Mətə mə rɨpkukuə mhə, ikukurən nərai əmwesiien.’” ");
INSERT INTO tnk_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nəpɨn riti ia Sapat Iesu ramahatən nərmama ia nəkwai nimwəfwaki səvəi nəkur Isrel. ");
INSERT INTO tnk_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Pran riti nəha ikɨn nənɨmwɨn ərəha rɨnarə raka irə ia nuk eitin mamo təkutan rikou. Prən nəha rəmakəmak a, ko rɨpkərer atukwatukw mhə. ");
INSERT INTO tnk_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nəpɨn Iesu rətoni, rəkwein pen prən nəha, mɨni pen tukwe in mə, “Prən i. Takɨfi raka nemhəien səim ia niram.” ");
INSERT INTO tnk_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nənə Iesu rəmri pen rəɡɨn mi irə, nənə təkwtəkwuni a təkutai prən nəha ruvehe matukwatukw. Nənə in rəɡnəɡɨni Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mətə iəmə asori səvəi nimwəfwaki niemaha rəpi tɨ nəri nə mə Iesu romasan prən nəha ia Sapat. In rɨni pen tɨ nərmama i mə, “Nəpɨn sikis nəha ratukwatukw mə tuko wok irə. Həuvehe ia nəpɨn me nəha pwəh in romasan nɨpwramiaha. Mətə ia Sapat kɨmiaha tihəpwəh nuveheien.” ");
INSERT INTO tnk_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mɨreɡi Iərɨmənu səkɨtaha rɨni pen tukwe in mə, “Kɨmiaha kəuətkəsuə me. Sin ia kɨmiaha rəpwəh nɨfiien səvənhi kau uə toɡki ia Sapat, mɨsɨɡi, mevən tɨ nui? Kɨmiaha pam hiamo nəri i! ");
INSERT INTO tnk_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nənə rəfo ia prən i Setan rɨrukwi nuk eitin? In kwənəkwus riti səvəi Epraham. Ko iapkɨfi mhə nemhəien i irə ia Sapat?” ");
INSERT INTO tnk_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nəpɨn Iesu rɨni nəɡkiariien nəha, nərmama pam səməme kamhətə ərəha in həreɡi haurɨs. Mətə səməme həpkətə ərəha mhə in rerɨnraha raɡien tɨ narimnari asori me sə in ramo. ");
INSERT INTO tnk_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nənə Iesu rɨni mə, “Nɨtətə sə Kumwesən ramərɨmənu irə rəmwhen ia nəfe nari? Takɨni nəfe nəɡkiariien mahatən pen irə? ");
INSERT INTO tnk_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Rəmwhen ia nuni nei mastat sə rouihi anan ia nuni nei me. Iərmama riti ruvehi, məpwei ia nəmhien səvənhi, nənə rutə, muvehe mo nei irə, nənə menu me ia nɨmaɡouaɡou ho pen kwətəpaɡ me səvənraha ia rəɡɨn me.” ");
INSERT INTO tnk_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Nənə Iesu rarə mɨni mwi mə, “Takɨni nəfe nəɡkiariien mahatən pen nɨtətə sə Kumwesən ramərɨmənu irə? ");
INSERT INTO tnk_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Rəmwhen ia yis sə pran riti ruvehi, muvehi mərapi irau flaoa me rɨpɨk, nənə məpwəh meste yis rəse floa me pam rəsisi.” ");
INSERT INTO tnk_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Iesu ravən makurau ia taon me mɨne rukwənu me, mamahatən nərmama, mamesi pen suatuk səvənhi mamevən mə treste nari fwe Jerusalem. ");
INSERT INTO tnk_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nənə iərmama riti rɨni pen tukwe in mə, “Iərɨmənu. Nərmama me nəha Kumwesən truvehimɨru irəha tuhəpɨk uə tuhouihi a?” Mɨreɡi Iesu rɨni pen tɨ nirəha i mɨnuə, ");
INSERT INTO tnk_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Kɨmiaha tihaməkeikei mhousari mhəuvnimwə ia kwəruə ouihi. Iakani pehe tukumiaha i nərmama həpɨk tuhousari tɨ nuvnimwəien, mətə tuhəpwəh nuvnimwəien. ");
INSERT INTO tnk_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Iəmə asori səvəi nimwə nəha trɨskəmter, məsisəɡ ia təpinhə ia nimwə səvənhi. Ia nəpɨn nəha kɨmiaha tihərer iruə, mamhərui təpinhə, mamhəni mə, ‘Iərɨmənu, əsevər ia təpinhə tukumaha.’ Mɨreɡi in trɨni pehe tukumiaha i mə, ‘Kɨmiaha hiəuku pəku? Iakreirei kɨmiaha.’ ");
INSERT INTO tnk_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mɨreɡi kɨmiaha tihəni mə, ‘Kɨmaha i səməme sənəveɡɨn, mhənənɨmwi pəri kɨtaha mik. Ikɨnərer ia suatuk me səkɨmaha, mamahatən nərmama.’ ");
INSERT INTO tnk_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mətə in trɨni iamɨnhi mə, ‘Iakani pehe tukumiaha i iakreirei kɨmiaha mə hiəuku pəku. Kɨmiaha pam i nərmama hiamo noien ərəha, həuvən isipwɨn tukw iou.’ ");
INSERT INTO tnk_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ia kwopun nəha kɨmiaha tihasək mhahi tərini revɨmiaha nəpɨn tihətoni Epraham mɨne Aesak mɨne Jekop mɨne profet kupwən me kamhəuvnimwə ia nɨtətə sə Kumwesən ramərɨmənu irə, mətə kɨnərarki irapw kɨmiaha iruə. ");
INSERT INTO tnk_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nənə nərmama rɨpko mhə irəha nəkur Isrel tuhəuku pesu, mhəuku prehi, mhəuku peraha, mhəuku parei, mhəuvehe mhəkure mhani pəri nari ia nɨtətə sə Kumwesən ramərɨmənu irə. ");
INSERT INTO tnk_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nənə həreɡi ro. Nərmama nepwɨn kamhəkurirə tuhəuvehe mhəkupwən, nənə nepwɨn haməkupwən tuhəuvehe mhəkurirə.” ");
INSERT INTO tnk_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ia nəpɨn a mwi nəha Farisi me nepwɨn həuvehe mhəni pen tɨ Iesu i mə, “Araka ia kwopun i mamevən. Herot rokeikei mə trousi əpune ik.” ");
INSERT INTO tnk_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Həuvən mhəni pen tɨ kuri əprmɨn nəha Herot mə iakani ianhi mə, ‘Reɡi ro! Iakaməkoui irapw nəremhə me ia nərmama, mafi raka nemhəien me ia nirəha. Tako iamɨnhi irə ipwet mɨne trakwakwi. Nənə tɨneis iako sampam ia wok səiou. ");
INSERT INTO tnk_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Takaməkeikei mesi pen suatuk səiou mamevən ipwet, trakwakwi, mɨne tɨneis, tɨ nəri nə mə ko kɨpkousi əpune mhə profet riti ia kwopun əpə iti, mətə traməkeikei memhə fwe ia Jerusalem əpa.’ ");
INSERT INTO tnk_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalem, Jerusalem! Ik taon i ikamousi əpune profet me maməkwi əpune nərmama səməme Kumwesən ramərhi pehe irəha tukw ik! Nəpɨn rɨpɨk iakokeikei mə takousəsɨmwɨn nɨpwnətɨm me rəmwhen ia rɨnhi menu ramo ia tɨni me mauiui irəha ia tərəɡɨn mi. Mətə kɨmiaha hiəpwəh nokeikeiien. ");
INSERT INTO tnk_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Hətə ro. Təkwtəkwuni nəha Kumwesən trəpwəh nimwə səkɨmiaha. Nənə iakani pehe tukumiaha i mə kɨmiaha tihəpwəh mwi nətoniien iou meste tihəni mə, ‘Səɡnəɡɨni iərmama i rauvehe ia nəɡhi Iərɨmənu səkɨtaha.’” ");
INSERT INTO tnk_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ia Sapat riti Iesu revən mə trəni nari ia nəkwai nimwə səvəi iəmə asori riti səvəi Farisi me. Irəha kamhətə amasan in mə trəfo irə. ");
INSERT INTO tnk_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Iərmama riti nəha ikɨn nemhəien ramarə irə, mamo rəɡɨn mi mɨne nɨsun mi krouəsisi. ");
INSERT INTO tnk_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nəpɨn Iesu rətoni, rəres pen nahatən me səvəi Loa mɨne Farisi me i mə, “Rəfo? Ratukwatukw ia loa səkɨtaha mə ia Sapat tuko iərmama sə nemhəien rarə irə ruvehe məsanɨn uə rekəm?” ");
INSERT INTO tnk_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mətə irəha həpwəh nɨniien nəɡkiariien riti. Ia nəpɨn nəha Iesu ruvehi iərmama nəha, mo nɨpwran ruvehe məsanɨn, rərhi pen in ramevən. ");
INSERT INTO tnk_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kurirə irə Iesu rɨni pen tɨ nirəha i mə, “Sin ia kɨmiaha trɨni mɨnuə ia Sapat səvənhi iəkunouihi uə kau rɨmwei pen ia ruei tənə trɨpkevən akwauakw mhə mɨvi utə in?” ");
INSERT INTO tnk_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mətə rɨskai tɨ nirəha ko irəha həpwəh nɨniien nəɡkiariien riti tɨ nəresien nəha. ");
INSERT INTO tnk_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ia nəpɨn nəha, Iesu rətə nərmama nepwɨn səməme iəmə asori səvəi nimwə nəha rəkwein irəha mə tuhani pəri nari həuvən mhəkure ia kwopun nəha kamsiai nərmama ikɨn. Nənə Iesu rɨni nusipekɨnien riti tɨ nirəha i mə, ");
INSERT INTO tnk_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Trɨni mɨnuə iərmama riti rəkwein ik mə tikevən məni nari ia nəveɡɨnien asori sə kamo tɨ iərman sə kiri pen vi a pran səvənhi, tikəpwəh nəkureien ia kwopun kamsiai nərmama me ikɨn. Rərəha iərmama riti sə rasori ia niram ruvehe, ");
INSERT INTO tnk_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","nənə iərmama sə rɨnəkwein kɨmirau pəri truvehe, mɨni pehe tukw ik i mə, ‘Araka, pwəh iərmama i rəkure ia kwopun i.’ Nənə ik tikaurɨs tɨ nəri nə mə tikaməkeikei mevən məkure ia kwopun i inhərɨpw anan. ");
INSERT INTO tnk_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mətə trɨni mɨnuə iərmama riti rəkwein ik iamɨnhi, tikevən məkure ia kwopun sə inhərɨpw anan. Nənə iərmama sə rɨnəkwein ik truvehe mɨni pehe tukw ik i mə, ‘Iou riti. Uvehe məkure ia kwopun i irənhə.’ Ia noien nəha in truvehi utə ik ia nəmri nərmama me pam səməme kamhani pəri nari kɨmiaha mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Iakani iamɨnhi irə tɨ nəri nə mə iərmama sə rauvehi utə in, Kumwesən truvehi irapw in, nənə iərmama sə rauvehi irapw in, Kumwesən truvehi utə in.” ");
INSERT INTO tnk_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nənə Iesu rɨni pen tɨ iərmama i rɨnəkwein in mə trəni nari ia nəkwai nimwə səvənhi mə, “Trɨni mɨnuə iko nəveɡɨnien asori riti ia rukwəsikər uə ia nəpɨn, tikəpwəh nəkweinien ik me nepwɨn uə piam me uə nərmama ia kwənəkwus səim uə nərmama səməme kamharə ipaka tukw ik nautə səvənraha rasori mə irəha tuhəuvehe mhani nari. Mə iko iamɨnhi irə irəha tuhəkwein mwi ik mə tikevən məni pəri nari kɨmiaha mɨnraha. Nənə ia noien nəha irəha tuhərpwɨn tai noien ikɨno mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mətə nəpɨn tiko nəveɡɨnien asori, tikəkwein nərmama nautə səvənraha riwən, mɨne nərmama səməme nɨpəri nɨpwranraha remhə, mɨne səməme nɨsunraha rərfe, mɨne səməme nənimenraha rɨfwə mə irəha tuhəuvehe mhani pəri nari. ");
INSERT INTO tnk_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nənə Kumwesən trəkwein amasan ia niram tɨ nəri nə mə irəha ko həpkərpwɨn pehe mhə tai noien sə ikɨno mɨnraha. Mətə ia nəpɨn sampam, nəpɨn nəkur atukwatukw tuhətui mwi ia nemhəien, Kumwesən trərpwɨn pehe mik.” ");
INSERT INTO tnk_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Iərmama riti sə raməni pəri nari irəha Iesu rɨreɡi nəɡkiariien nəha, mɨni pen tukwe in mə, “Iərmama sə truvnimwə ia nɨtətə sə Kumwesən ramərɨmənu irə məni nari rerɨn traɡien.” ");
INSERT INTO tnk_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mətə Iesu rɨni pen tukwe in mə, “Nəpɨn riti iərmama riti rokeikei mə tro nəveɡɨnien asori riti, nənə mukupwən məkwein nərmama həpɨk mə tuhəuvehe tukwe. ");
INSERT INTO tnk_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ia nəpɨn səvəi nəveɡɨnien asori nəha, in rərhi pen iərmama riti sə ramo tukwini nari min revən tɨ nirəha səməme in rɨnəkwein irəha mə tuhəuvehe, mɨni pen tɨ nirəha mə, ‘Həuvehe, iakɨnəpnəpenə pam narimnari.’ ");
INSERT INTO tnk_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Mətə irəha pam həni mə ko həpkuvehe mhə. Iərmama sə rukupwən məɡkiari rɨni pen tukwe in mə, ‘Sore. Ko iapkuvehe mhə. Iapkuvehi a nəmri tɨprənə riti. Takaməkeikei mevən mətoni.’ ");
INSERT INTO tnk_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Riti mwi rɨni mə, ‘Sore. Mətə iou iapkuvehi a nəmri kau me irəha pam ten. Takaməkeikei mevən məskun irəha. Ko iou iapkuvehe mhə.’ ");
INSERT INTO tnk_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Riti mwi rɨni mə, ‘Kiri pehe a pran səiou i. Ro iamɨnhi irə ko iapkuvehe mhə.’ ");
INSERT INTO tnk_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ia nəpɨn nəha iərmama sə ramo tukwini nari rɨrərɨɡ, mevən tɨ iəmə asori səvənhi, məvisau pen nəɡkiariien me nəha min. Nənə iəmə asori niemaha rəpi. In rɨni pen tɨ iərmama nəha ramo tukwini nari min mə, ‘Evən akwauakw ia suatuk me mɨne kwopun me ia taon i, miri nərmama nautə səvənraha riwən, mɨne nərmama səməme nɨpəri nɨpwranraha remhə, mɨne səməme nənimenraha rɨfwə, mɨne səməme nɨsunraha rərfe, miri irəha mhəuvehe.’ ");
INSERT INTO tnk_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ro pen iotukwininari nəha revən, mɨrərɨɡ, mɨni mə, ‘Iəmə asori. Nəfe ikɨməni iakɨno, mətə nimwə səim rɨpkukuər mhə.’ ");
INSERT INTO tnk_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Mɨreɡi iəmə asori səvəi iotukwini nari nəha rɨni pen tukwe in mə, ‘Evən ia suatuk me mɨne kwopun me iruə ia taon, məkeikei m nərmama mə tuhəuvnimə pehe pwəh nimwə səiou rukuər amasan. ");
INSERT INTO tnk_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Iakani pehe tukw ik i nərmama me nəha səməme iakɨnəkwein irəha fwe kupwən irəha riti ko rɨpkəni mhə nəveɡɨnien səiou.’” ");
INSERT INTO tnk_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nəpɨn riti nərmama həpɨk kamhəkurirə Iesu. Nənə in ruvsini mɨni pen tɨ nirəha i mɨnuə, ");
INSERT INTO tnk_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Trɨni mɨnuə iərmama riti ruvehe tukw iou in traməkeikei mokeikei iou məpi raka tata səvənhi mɨne mama səvənhi, mɨne pran səvənhi, mɨne nɨpwnətɨn me, mɨne piəvni me, mɨne kɨtiriməni me, mɨne nɨmɨruien atukw səvənhi. Trɨni mɨnuə in rɨpkokeikei mhə iou iamɨnhi, ko rɨpkuvehe mhə mo in iərmama riti səiou. ");
INSERT INTO tnk_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Iərmama sə rɨpkəvrani mhə nei kamarkuaui səvənhi muvehe mukurirə iou, ko in rɨpkuvehe mhə mo in iərmama riti səiou. ");
INSERT INTO tnk_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Sin ia kɨmiaha rokeikei mə tro nimwə riti rəpwəmwɨs mutə, mətə rɨpkukupwən mhə məkure, məvsini nəmri narimnari me sə tro nimwə irə mə mane səvənhi rəmwhen uə rekəm? ");
INSERT INTO tnk_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Trɨni mɨnuə iərmama rɨpko mhə iamɨnhi irə, nəpɨn ro sampam ia nɨsui nimwə nəha, ko rɨpko pam mhə nimwə, nənə nərmama me pam tuhətə harɨs əkenhɨn irə, ");
INSERT INTO tnk_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","mhəni mə, ‘Hətə ro iərmama nəha. Rɨno pam nɨsui nimwə, mətə ko rɨpko pam mhə.’ ");
INSERT INTO tnk_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Uə nəfe kiɡ rokeikei mə trevən maruaɡən irau kiɡ riti, mətə rɨpkukupwən mhə məkure, mətərɨɡ tukwe mə in rəmwhen ko riri pen səvənhi naruaɡən me irəha pam ten taosen həuvən mharuaɡən irəha kiɡ sə ramiri pehe səvənhi me irəha pam twenti taosen? ");
INSERT INTO tnk_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Trɨni mɨnuə kiɡ nəha rətoni mə in rəpwəh nəmwhenien, nəpɨn kiɡ nəha səvənhi naruaɡən me irəha pam twenti taosen rauvehe ihi fwe isipwɨn, in trərhi pen nərmama nepwɨn səvənhi həuvən mə tuhəres mə trəfo nəha məmri nəmərinuien. ");
INSERT INTO tnk_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ia noien nəha rəmwhen a mwi kɨmiaha tihaməkeikei mhəkupwən mhətərɨɡ tukwe. Trɨni mɨnuə kɨmiaha riti rerɨn rɨpkaɡien mhə mə traraka ia narimnari me pam səvənhi, ko in rɨpkuvehe mhə mo in iərmama riti səiou.” ");
INSERT INTO tnk_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Sol nəri ramasan. Mətə trɨni mɨnuə sol nəsienien səvənhi ruvəiwən, tukəfo mwi rəsien mwi? ");
INSERT INTO tnk_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Rɨpkamasan mhə tɨ tɨprənə uə tɨ nihi kau sə tukərapi ia tɨprənə kəmhu irə. Ramasan a mə tukərarki a i. Iərmama sə nəkwəreɡɨn rarə tɨ nɨreɡiien nari traməkeikei mətərɨɡ amasan.” ");
INSERT INTO tnk_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ia nəpɨn nəha nərmama səməme kamərəku pen takis mɨnraha mɨne nərmama ərəha me nepwɨn mwi həuvehe mə tuhətərɨɡ ia Iesu. ");
INSERT INTO tnk_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nəpɨn Farisi me mɨne nahatən me səvəi Loa hətoni, həni ərəha Iesu, mhəni mə, “Iəmə i raməseni nəkur ərəha me həuvehe tukwe in. Raməni pəri nari irəha mɨnraha.” ");
INSERT INTO tnk_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ro pen Iesu rɨni nusipekɨnien riti tɨ nirəha i mə, ");
INSERT INTO tnk_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Trɨni mɨnuə kɨmiaha riti səvənhi sipsip me irəha pam hantret, mətə rətə wau ia riti, trəfo pen irə? In trəpwəh naenti-naen fwe ia kwopun kamhani nurhi ikɨn, mevən mətui sipsip sə rɨnəruei meste trətoni. ");
INSERT INTO tnk_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nənə nəpɨn rətoni, truvehi utə məmri pen ia nuran mi, mamaɡien, ");
INSERT INTO tnk_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","mevən fwe imwəni, moeite in me nepwɨn mɨne nərmama səməme kamharə ipaka tukwe, mɨni pen tɨ nirəha i mə, ‘Pwəh saɡien pəri tɨ nəri nə mə iakɨnətoni sipsip səiou sə rɨnəruei.’ ");
INSERT INTO tnk_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Rəmwhen ia noien nəha iakani pehe tukumiaha i trɨni mɨnuə iərmama ərəha riti rɨrərɨɡ ia nətərɨɡien səvənhi, məpwəh noien ərəha me səvənhi, naɡienien fwe ia neiai trasori məpi raka naɡienien sə kamreɡi tɨ nərmama atukwatukw me nəha irəha pam neanti-naen səməme tuhəpkrərɨɡ mhə ia nətərɨɡien səvənraha tɨ nəri nə mə noien ərəha me səvənraha riwən.” ");
INSERT INTO tnk_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nənə Iesu rɨni mə, “Uə trɨni mɨnuə pran səvənhi silin irəha pam ten, rətə wau ia riti, trəfo pen irə? Trɨhiai pen napw ia laet, maies ia nəkwai nimwə, mamətui silin nəha meste trətoni. ");
INSERT INTO tnk_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nənə nəpɨn rətoni, trəkwein in me nepwɨn mɨne nərmama səməme kamharə ipaka tukwe, mɨni mə, ‘Pwəh saɡien pəri tɨ nəri nə mə iakɨnətoni silin sə iakɨnətə wau irə.’ ");
INSERT INTO tnk_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Rəmwhen ia noien nəha iakani pehe tukumiaha i naɡelo me səvəi Kumwesən kamhaɡien nəpɨn iərmama ərəha riti rɨrərɨɡ ia nətərɨɡien səvənhi, məpwəh noien ərəha me səvənhi.” ");
INSERT INTO tnk_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Nənə Iesu rɨni mə, “Iərmama riti tɨni kəru iərman mi. ");
INSERT INTO tnk_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nəpɨn riti tɨni sə rouihi rɨni pen tɨ səvənhi tata i mə, ‘Tata. Uai narimnari me səim muvei pehe səiou nəha təkwtəkwuni.’ Nənə tata səvənhi ruai narimnari me səvənhi ia nənimen kəru riti səvəi tɨni sə rasori riti səvəi tɨni sə rouihi. ");
INSERT INTO tnk_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Rɨpko mhə tui tɨni sə rouihi roueite səvənhi narimnari me, ruvehi mane irə, mier, məpwəh imwəni, mevən marə ia tənə riti isipwɨn. Nənə ia kwopun nəha in rouraha mane səvənhi ia noien ərəha me ");
INSERT INTO tnk_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","meste mane səvənhi riwən. Nəpɨn səvənhi mane ruvəiwən pam, nukumhə rɨnamavən ia tənə nəha. Nukumhə rɨnamahi. Sənəni nəveɡɨnien riwən. ");
INSERT INTO tnk_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ro pen in revən mamowok səvəi iərmama riti ia tənə nəha. Nənə iərmama nəha rərhi pen in revən mə trəkwməni pɨkə me səvənhi. ");
INSERT INTO tnk_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nəpɨn in raməkwməni pɨkə me nəha, nukumhə rahi pɨk anan, mətə iərmama riti rɨpkuvei pen mhə nari riti min. Nənə rerɨn rɨrhi mə, ‘Rosi ko iakəni nɨpəri nəveɡɨnien riti sənəi pɨkə me i takreɡi ramasan.’ ");
INSERT INTO tnk_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Mətə nəpɨn nətərɨɡien amasan səvənhi rɨrərɨɡ muvehe, in rɨni mə, ‘Nərmama me nəha tata səiou ramərəku pen mɨnraha tɨ no tukwiniien nari min irəha pam nəveɡɨnien sənənraha rasori məpi raka irəha, mətə iou iakamarə ia kwopun i nukumhə ramahi iou na takemhə. ");
INSERT INTO tnk_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Takier ia kwopun i, mɨrərɨɡ, mevən tɨ səiou tata, mɨni pen tukwe in mɨnuə, Tata. Iakɨno nari riti rərəha rəpwəh nəmwhenien ia nəmri Kumwesən mɨne ia nənimem. ");
INSERT INTO tnk_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Təkwtəkwuni nəha iapkəmwhen mhə mə tikəkwein nərɨm ia nirak. Tiko iou iakəmwhen iərmama riti sə ikamərəku pen min tɨ no tukwiniien nari mik.’ ");
INSERT INTO tnk_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ro iamɨnhi irə təmaruə nəha rɨskəmter, mɨrərɨɡ, mɨnamevən tɨ tata səvənhi. Mətə nəpɨn rauvehe ihi fwe isipwɨn, tata səvənhi rətoni, nənə rerɨn rərkwəpɨr tukwe. Raiu, mevən, mərəhi pehe, makei min. ");
INSERT INTO tnk_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nənə tɨni rɨni pen tukwe in mə, ‘Tata. Iakɨno nari riti rərəha rəpwəh nəmwhenien ia nəmri Kumwesən mɨne ia nənimem. Təkwtəkwuni nəha iapkəmwhen mhə mə tikəkwein nərɨm ia nirak.’ ");
INSERT INTO tnk_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mətə tata səvənhi rəkwein nərmama səməme kamho tukwini nari min mɨni mə, ‘Həuvən akwauakw, mhəuvehi karkahu əpwəmwɨs riti sə ramasan pɨk məpi raka karkahu əpwəmwɨs me nepwɨn, nənə mharkahu pen i min, mhəuvei pen riɡ ia nukwai rəɡɨn, mhəuvei pen put ia nɨsun mi, ");
INSERT INTO tnk_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","nənə mhəuvən mhəuvehi kau nəha nɨpwran rəsisi amasan mhəuvehe, mhousi əpune. Pwəh sani mhaɡien pəri ");
INSERT INTO tnk_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","tɨ nəri nə mə iəkunouihi i səiou rəmwhen mə ruvamhə raka, mətə təkwtəkwuni ruvəmɨru mwi. In rɨnəruei, mətə təkwtəkwuni nəha iakɨnətoni mwi.’ Nənə irəha kənamhaɡien pəri. ");
INSERT INTO tnk_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ia nəpɨn nəha tɨni sə rasori in fwe ia nəmhien. Nəpɨn rɨrərɨɡ mauvehe ia rukwənu, muvehe ipaka tɨ nimwə, rɨreɡi nərmama kamhani nɨpu, mamho tanis. ");
INSERT INTO tnk_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nənə rəkwein iərmama riti sə ramo tukwini nari m tata səvənhi, məres mə, ‘Nəfe i hiamo?’ ");
INSERT INTO tnk_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mɨreɡi iərmama nəha rɨni pen tukwe in mə, ‘Piam ruvəuvehe. Nənə tata səim ruəsi kau nəha nɨpwran rəsisi amasan tɨ nəri nə mə piam rɨrərɨɡ muvehe məsanɨn a.’ ");
INSERT INTO tnk_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ro iamɨnhi irə tɨni sə rasori niemaha rəpi, rəpwəh nuvnimwəien ia nəkwai nimwə. Tata səvənhi rier, məres in mə truvnimwə, ");
INSERT INTO tnk_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","mətə in rɨni pen tɨ səvənhi tata i mə, ‘Ətə ro! Nuk me rɨpɨk iakamo tukwini pehe nari mik ia kwopun i, mɨpkərui mhə nəkwam. Mətə ipkuvei pehe mhə nari riti miou rəmwhen ia kwəti nəni mə tako nəveɡɨnien irə mhaɡien pəri kɨmaha iou me nepwɨn. ");
INSERT INTO tnk_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mətə nəpɨn nərɨm nəha sə rɨnouraha narimnari me səim tɨ nərəkuien nɨpran ia suatuk rɨrərɨɡ muvehe ia rukwənu, ikousi əpune kau nəha nɨpwran rəsisi amasan mamo nəveɡɨnien irə səvənhi.’ ");
INSERT INTO tnk_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Mɨreɡi tata səvənhi rɨni pen tukwe in mə, ‘Nərɨk. Nəpɨn me pam krau mik krauarə. Narimnari me pam səiou səim. ");
INSERT INTO tnk_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mətə ratukwatukw mə tso nəveɡɨnien i, mhaɡien, tɨ nəri nə mə piam in rəmwhen mə ruvamhə raka, mətə təkwtəkwuni ruvəmɨru mwi. Rɨnəruei, mətə təkwtəkwuni nəha sənətoni mwi.’” ");
INSERT INTO tnk_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iesu rɨni pen tɨ nərmama me səvənhi mə, “Iərmama riti nautə səvənhi rasori. Səvənhi riti fwe iotukwininari ramətui tɨ nautə səvənhi, mətə kamɨni ərəha in mə ramouraha nautə nəha. ");
INSERT INTO tnk_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ro iamɨnhi irə iərmama sə nautə səvənhi rasori rəkwein iəmə nəha ruvehe, rəres pen in mə, ‘Nəfe nəɡkiariien me i iakamreɡi kamɨni ia niram? Uvei pehe nəkukuə sə ikɨmərai pen səim wok irə. Təkwtəkwuni nəha tiko sampam ia wok.’ ");
INSERT INTO tnk_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Mɨreɡi iotukwininari sə ramətui tɨ nautə səvəi iəmə asori nəha rerɨn rɨrhi mə, ‘Səiou iəmə asori trərarki irapw iou ia wok səiou. Mətə nɨskaiien səiou rəpwəh nəmwhenien mə takeri tɨprənə muvehi mane irə. Iakamaurɨs tɨ naseien mane tɨ nərmama. Tako nəfe nəha təkwtəkwuni? ");
INSERT INTO tnk_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ah, iakukurən nəfe tako! Nərmama me nəha səməme həpkərpwɨn pehe mhə ihi kaon me səvənraha sə iəmə asori səiou rɨməuvei pen mɨnraha, tako rerɨnraha raɡien. Trɨni mɨnuə iako iamɨnhi irə, nəpɨn iəmə asori səiou trərarki iou, irəha tuhəuvehi puvnimwə iou ia nəkwai nimwə me səvənraha.’ ");
INSERT INTO tnk_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ia nəpɨn nəha in rəkwein nərmama me nəha səməme həpkərpwɨn pehe mhə ihi kaon səvənraha həuvehe kuatia kuatia tukwe in. Sə rukupwən mevən, rəres in mə, ‘Ikɨməuvehi nəfe narimnari me səvəi iəmə asori səiou, mətə ipkuvehi mhə ihi nənimen?’ ");
INSERT INTO tnk_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Mɨreɡi iərmama nəha rɨni mə, ‘Tram me irəha pam hantret həukuər ia oel kaməvənari irə.’ Mɨreɡi iəmə nəha rɨni mə, ‘In i nɨmwai nəkukuə səvəi kaon səim. Tikuvehi, məkure akwauakw, mɨrai pen mə fifti tram a.’ ");
INSERT INTO tnk_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Iəmə nəha rarə mɨni pen tɨ riti mwi mə, ‘Nənə ik ikɨməuvehi nəfe mətə ipkuvehi mhə ihi nənimen?’ Mɨreɡi iərmama nəha rɨni mə, ‘Pak flaoa irəha pam wan taosen.’ Mɨreɡi iəmə nəha rɨni mə, ‘In i nɨmwai nəkukuə səvəi kaon səim. Tikuvehi mɨrai pen mə pak me irəha pam eit hantret a.’ ");
INSERT INTO tnk_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Iotukwininari sə ramətui tɨ nautə səvəi iəmə asori nəha ramo noien riti sə rɨpkatukwatukw mhə. Mətə kurirə irə iəmə asori səvənhi ruvehe mɨni vivi in tɨ nəri nə mə in rukurən nari. Nəri nəha ramahatən pen mə nərmama ia tɨprənə i həukurən amasan nari tɨ noien pisnes irəha nərmama səvənraha. Irəha həukurən amasan mhəpi raka nɨpwnəti nukuraanien me. ");
INSERT INTO tnk_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nənə iakani pehe tukumiaha i kɨmiaha tihaməkeikei mhasitu amasan ia nərmama ia nautə me səvəi tɨprənə i mə irəha tuhəuvehe mho kɨmiaha me nepwɨn ia nirəha. Nənə nəpɨn nautə me nəha tuhəiwən, Kumwesən truvehi puvnimwə kɨmiaha ia nimwə me səməme tuhəpkiwən mhə ia nəpɨn riti. ");
INSERT INTO tnk_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Iərmama sə ramətui amasan tɨ nəri ouihi a trətui amasan mwi tɨ nəri asori. Nənə iərmama sə rɨpkətui amasan mhə tɨ nəri ouihi trɨpkətui amasan mhə mwi tɨ nəri asori. ");
INSERT INTO tnk_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Trɨni mɨnuə kɨmiaha hiəpkətui amasan mhə tɨ nautə səvəi tɨprənə i, sin trəmri pehe nautə sə ro nɨpərhienien irə ia rəɡɨmiaha mə tihətui amasan tukwe? ");
INSERT INTO tnk_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nənə trɨni mɨnuə kɨmiaha hiəpkətui amasan mhə tɨ narimnari me səvəi iərməpə, sin truvei pehe narimnari me m kɨmiaha mə tihəuvehi mho səkɨmiaha irə? ");
INSERT INTO tnk_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Iərmama riti riwən ramo tukwini nari ko ro nəkwai iəmə asori kəru. Trɨni mɨnuə ro iamɨnhi irə, trokeikei riti məmwəki riti, uə trɨsiai riti mɨpkɨsiai mhə riti. Kɨmiaha ko hiəpkuvehi pəri mhə Kumwesən mɨne mane mho iəmə asori mi irə səkɨmiaha mə tiho pəri nəkwanrau.” ");
INSERT INTO tnk_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Nəpɨn Farisi me həreɡi nəɡkiariien me nəha harɨs ia Iesu tɨ nəri nə mə irəha hokeikei pɨk mane. ");
INSERT INTO tnk_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mətə Iesu rɨni pen tɨ nirəha i mə, “Kɨmiaha Farisi me hiameikuə ia nəmri nərmama mə kɨmiaha nəmə atukwatukw, mətə Kumwesən rukurən rerɨmiaha. Nəfe nari nərmama kamhəfiəutə irəha me tukwe, mətə ia nəmri Kumwesən rərəha anan. ");
INSERT INTO tnk_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Kɨnəvisau irapw Loa səvəi Moses mɨne nəɡkiariien me səvəi profet kupwən me meste pehe Jon Paptaes. Kurirə irə kɨnaməvisau irapw nəɡkiariien amasan i raməɡkiari ia nɨtətə sə Kumwesən ramərɨmənu irə. Nənə nərmama me pam kamhəmwur mə tuhəuvnimwə ia nɨtətə nəha. ");
INSERT INTO tnk_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Rəknekɨn mə neiai mɨne tɨprənə krouvehe rouiwən. Mətə rəknekɨn pɨk mə nukwai nəkukuə ouihi riti sə kɨmərai pen ia Loa ruvehe miwən. ");
INSERT INTO tnk_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Iərman sə rəpwəh pran səvənhi miri pran əpə riti mwi ramo noien ərəha. Prən nəha in ramiri rɨpko mhə səvənhi atukwatukw pran. Nənə iərman sə riri pran sə iərman səvənhi rɨnəpwəh ramo noien ərəha. Prən nəha in ramiri səvəi iərməpə.” ");
INSERT INTO tnk_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nənə Iesu rɨni mə, “Iərmama riti nautə səvənhi rasori ramarkahu tɨnari me nənimenraha rəknekɨn. Ia nəpɨn me raməni amasan nari, mamaɡien. ");
INSERT INTO tnk_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ia kwəruə ia rukwənu səvənhi nərmama kamhəkure pen iərmama riti nəɡhɨn nə Lasaros. Nautə səvənhi riwən. Nɨmwapw me həpɨk ia nɨpwran. ");
INSERT INTO tnk_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Iəmə nə rokeikei pɨk mə traməni nɨmwəkmwəki nəveɡɨnien sə raməsas irapw ia ruei tepol səvəi iərmama nəha nautə səvənhi rasori. Kuri me mwi kamhəuvehe, mamhəpwasi nɨmwapw me səvənhi. ");
INSERT INTO tnk_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nəpɨn iərmama nəha nautə səvənhi riwən remhə, naɡelo me həuvehi nənɨmwɨn, mhəuvehi mhəuvən, mhəmri pen ia nɨkare Epraham. Iərmama nəha nautə səvənhi rasori in mwi remhə, kɨnɨmwi in. ");
INSERT INTO tnk_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Fwe Imwei Nəkur Həuvamhə in ramreɡi nəmisəien asori, məkwətə, mətoni Epraham fwe isipwɨn kwopti Lasaros ia nɨkaren. ");
INSERT INTO tnk_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nənə in rəkwein əpwəmwɨs mɨni mə, ‘Tata Epraham. Tikapi iou, mərhi pen Lasaros pwəh revən meitesi nukwai rəɡɨn ia nui, nənə muvehe mɨrapi nəramɨk irə mə trəkwiei. Iakamreɡi nəmisəien asori ia napw i.’ ");
INSERT INTO tnk_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Mətə Epraham rɨni mə, ‘Nərɨk. Rerɨm tramrhi narəien səim nəpɨn ikamɨru ihi. Ik ikɨməuvehi narimnari amasan me, mətə Lasaros rɨməuvehi narimnari ərəha me. Nənə təkwtəkwuni nəha in ramreɡi ramasan ia kwopun i, mətə ik ikamreɡi nəmisəien asori. ");
INSERT INTO tnk_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nari riti mwi ko iapkasitu mhə ia niram tɨ nəri nə mə Kumwesən rɨnəmri təpuapəɡ asori riti ro tukuahaɡ kɨtaha m kɨmiaha. Kɨmaha riti ko rɨpkier mhə ia kwopun i muvehe mətə kɨmiaha. Kɨmiaha riti ko rɨpkier mhə ia kwopun nə muvehe mətə kɨmaha.’ ");
INSERT INTO tnk_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Mɨreɡi iərmama nəha nautə səvənhi rasori rɨni mə, ‘Ro iamɨnhi irə iakamase ik tata mə tikərhi pen Lasaros revən fwe ia nimwə səvəi tata səiou. ");
INSERT INTO tnk_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Piak me fwe ikɨn irəha pam krirum, pwəh rɨni pen tɨ nirəha i mɨnuə tuhaməkeikei mhəsiari, kamo irəha mwi həuvehe ia kwopun i, kwopun səvəi nəmisəien asori.’ ");
INSERT INTO tnk_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Mətə Epraham rɨni mə, ‘Moses mɨne profet kupwən me həuvəni raka mə nərmama tuhaməkeikei mhəsiari tɨ kwopun nəha. Ramasan mə pwəh piam me hətərɨɡ ia nəɡkiariien me səvənraha.’ ");
INSERT INTO tnk_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mɨreɡi iərmama nəha nautə səvənhi rasori rɨni mə, ‘Rekəm, Tata Epraham, sə nəha rɨpkəmwhen mhə. Mətə mə iərmama riti rətui mwi ia nemhəien səvənhi, mevən tɨ nirəha, irəha tuhəpwəh noien ərəha me səvənraha.’ ");
INSERT INTO tnk_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Mɨreɡi Epraham rɨni pen tukwe in mə, ‘Trɨni mɨnuə irəha həpwəh nətərɨɡien ia nəɡkiariien səvəi Moses mɨne profet kupwən me, tuko iərmama riti rətui mwi ia nemhəien səvənhi, mətə ko həpkɨni mhə nɨpərhienien ia nəɡkiariien səvənhi.’” ");
INSERT INTO tnk_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Nənə Iesu rɨni pen tɨ nərmama me səvənhi mə, “Nɨpərhienien narimnari me tuhəuvehe mhəvi nərmama həmwei ia nərəhaien, mətə trərəha anan tɨ iərmama sə truvehi narimnari me nəha mier pehe. ");
INSERT INTO tnk_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Trɨni mɨnuə in ro nəkwərhakwərha me i riti rɨmwei ia nərəhaien, Kumwesən trərpwɨn noien ərəha səvənhi. Iərmama nəha trɨreɡi rərəha anan məpi raka kərihi pen kəruəterei asori ia nɨpətəkinuan, kosə irapw i ia təmwei təsi. ");
INSERT INTO tnk_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kɨmiaha tihaməkeikei mhatuakəm amasan tukumiaha. Trɨni mɨnuə piam ro noien ərəha ia niram, tikɨnise pen tukwe in mə rəpwəh. Mə rɨrərɨɡ ia nətərɨɡien səvənhi, məpwəh, tikenouenou i. ");
INSERT INTO tnk_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Trɨni mɨnuə ia nəpɨn kuatia ro noien ərəha ia niram m sefen mətə ia noien me nəha ramo rɨrərɨɡ mwi irə mɨni pehe tukw ik i mə, ‘Noien i iakamo rərəha. Pwəh iakəpwəh,’ nənə tikaməkeikei menouenou noien ərəha səvənhi.” ");
INSERT INTO tnk_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nənə aposol me səvəi Iərɨmənu səkɨtaha həni mə, “Iərɨmənu. Tiko mwi nahatətəien səkɨmaha ruvehe mɨskai mwi.” ");
INSERT INTO tnk_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mɨreɡi Iərɨmənu səkɨtaha rɨni mə, “Trɨni mɨnuə nahatətəien səkɨmiaha rouihi a rəmwhen ia nuni nei nəha mastat sə rouihi anan ia nuni nei me, hiəukurən nɨniien tɨ nei asori i mə ‘Tiko meivi utə atukw a nuam me, mevən mərer ia təmwei təsi,’ nənə tro nəkwamiaha.” ");
INSERT INTO tnk_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Nənə Iesu rɨni mə, “Kɨmiaha hiaməfətərɨɡ irə? Trɨni mɨnuə iəmə asori riti rərhi pen iərmama riti sə ramo tukwini nari min revən mə trərar ia nəmhien uə ramətui tɨ sipisip me, nəpɨn iərmama nəha ruku pen fwe ia nəmhien muvehe, ko səvənhi iəmə asori rɨni pen tukwe in mə, ‘Itə. Təkwtəkwuni tikuvehe krauəni pəri nari’? ");
INSERT INTO tnk_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Rekəm! Mətə iəmə asori səvənhi trəɡkiari pen min mɨni mə, ‘Itə. Evən məpnəpenə sənak riti nəveɡɨnien, nənə mevən markahu amasan səim muvehe. Nəpɨn iakaməveɡɨn, mamənɨmwi, tikamo tukwini pehe nari miou. Nəpɨn ikɨno pam, nənə ikukurən nəniien nəveɡɨnien sənam.’ ");
INSERT INTO tnk_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","?Nəpɨn iərmama iamɨnhi ro nəkwai iəmə asori səvənhi, kɨmiaha hiəukurən mə iəmə asori nəha rɨni pen tanak tukwe in uə rekəm? Rekəm! ");
INSERT INTO tnk_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kɨmiaha nə hiəmwhen ia nərmama səməme hiamo tukwini nari m Kumwesən. Nəpɨn tiho pam narimnari me nəha in rɨməni mə tiho, tihaməkeikei mhəni mə, ‘Kwa kɨmaha i nərmama me səməme iahamo tukwini nari. Kɨmaha iahəno a nəfe ratukwatukw mə taho.’” ");
INSERT INTO tnk_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Iesu ramevən fwe ia Jerusalem, makurau ia nɨmwrhenhi tənə mi nəha Sameria mɨne Kalili. ");
INSERT INTO tnk_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nəpɨn rier pen ia rukwənu riti, nərmama ten nemhəien skai ro tekɨnraha həuvehe tukwe, mhərer isipwɨn kwopti, ");
INSERT INTO tnk_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","mənamhəkwein əpwəmwɨs mə, “Iesu Iərɨmənu! Api tukumaha!” ");
INSERT INTO tnk_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nəpɨn Iesu rətə irəha, rɨni pen tɨ nirəha i mə, “Kɨmiaha tiho mhəuvən tɨ pris me pwəh irəha hətə nɨpwramiaha.” Nəpɨn irəha kamhəuvən ia suatuk, nɨpwranraha ruvehe məmher. ");
INSERT INTO tnk_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nənə irəha riti rətə mə nɨpwran rɨnəsanɨn, rɨrərɨɡ mwi, maməkwein əpwəmwɨs, maməɡnəɡɨni Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Iəmə nəha in iəmə Sameria. Ruvehe mɨnɨmwi nukurhun mi ia nəmri Iesu, mɨni tanak tukwe. ");
INSERT INTO tnk_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nənə Iesu rɨni mə, “Kɨmiaha nəha nɨpwramiaha ruvehe mɨnəmher rosi kɨmiaha pam ten uə? Mətə nərmama naen mwi pəku? ");
INSERT INTO tnk_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Rəfo iəmə i rɨpko mhə in iəmə Isrel in əpa rɨrərɨɡ məɡnəɡɨni Kumwesən?” ");
INSERT INTO tnk_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nənə Iesu rɨni pen tɨ iəmə i mə, “Tiko mərer mamevən. Nahatətəien səim rɨno raka ik ikuvehe məsanɨn.” ");
INSERT INTO tnk_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisi me nepwɨn həres pen Iesu i mə, “Tɨnesən nɨtətə sə Kumwesən ramərɨmənu irə ruvehe?” Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Nəpɨn nɨtətə sə Kumwesən ramərɨmənu irə truvehe irə, nərmama tuhəpkətoni mhə nɨmtətien me. ");
INSERT INTO tnk_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Irəha tuhəpkɨni mhə mə, ‘Hətə ro, in i!’ uə ‘In nəha!’ Irəha tuhəpwəh nɨniien iamɨnha irə tɨ nəri nə mə həreɡi ro nɨtətə sə Kumwesən ramərɨmənu irə rɨnarə raka ia kurkwamiaha.” ");
INSERT INTO tnk_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nənə Iesu rɨni pen tɨ nərmama me səvənhi mə, “Nəpɨn nəha rauvehe kɨmiaha tihokeikei pɨk mə tihətoni iou, Iəməti Iərmama, ia nəpɨn riti səiou, mətə tihəpkətoni mhə. ");
INSERT INTO tnk_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nərmama nepwɨn tuhəni pehe tukumiaha i mə, ‘Hətə ro in nəha’ uə ‘Hətə ro in i.’ Mətə kɨmiaha tihəpwəh nierien, mhəpwəh nukurirəien irəha. ");
INSERT INTO tnk_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nəpɨn rouapɨr irə nərmama hətoni nəhiapwien səvənhi ia nɨmaɡouaɡou fwe pesu meste nari fwe prehi. Iou, Iəməti Iərmama, nəpɨn səiou sə takuvehe irə tro mwi iamɨnhi. ");
INSERT INTO tnk_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mətə takaməkeikei mukupwən mɨreɡi nəmisəien me rɨpɨk. Nərmama ipwet mɨne tuhəni ərəha iou, mhəuvei pehe təkutanraha miou. ");
INSERT INTO tnk_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nəpɨn iou, Iəməti Iərmama, takuvehe irə trəmwhen ia nəpɨn səvəi Noa. ");
INSERT INTO tnk_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nərmama me kamhəveɡɨn, mamhənɨmwi. Nərman me kamhəiri nɨpran. Nɨpran me kamhesi pen nərman. Irəha kamho noien me nəha mamhəuvən meste Noa ruvnimwə ia nɨtətə asori səvənhi, nənə nui asori ruvehe, məuiui irəha, irəha pam həmwhenɨmw. ");
INSERT INTO tnk_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Trəmwhen mwi nəpɨn səvəi Lot. Nərmama kamhəveɡɨn, mamhənɨmwi, mamhəmri pen nəmri nari ia narimnari me, mamhəuvehi nənimenraha, mamhəmhu, mamho nimwə me. ");
INSERT INTO tnk_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Mətə nəpɨn nəha Lot rier ia Sotom irə, napw mɨne təpisi krouukrutə fwe ia nɨmaɡouaɡou, roueiwaiu pehe rouahi əmwesi irəha pam. ");
INSERT INTO tnk_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nəpɨn nəha iou, Iəməti iərmama, takuvehe irə trəmwhen a mwi. ");
INSERT INTO tnk_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ia nəpɨn nəha, trɨni mɨnuə iərmama riti ramapwɨs ia təkure nimwə səvənhi traməkeikei meiwaiu map akwauakw, məpwəh nuvnimwəien mə truvehi nari riti ia nəkwai nimwə. Trɨni mɨnuə iərmama riti raməmhu ia nəmhien səvənhi traməkeikei mo rəmwhen a mwi, map akwauakw, məpwəh nɨrərɨɡien mevən fwe imwəni. ");
INSERT INTO tnk_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Rerɨmiaha tramrhi pran səvəi Lot. ");
INSERT INTO tnk_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Iərmama sə rəmwur mə trəkwtəmhiri nɨmɨruien səvənhi trarfai irə. Mətə iərmama sə raraka ia nɨmɨruien səvənhi truvehi nɨmɨruien rerɨn. ");
INSERT INTO tnk_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Iakani pehe tukumiaha i ia nəpɨn nəha ia nəpɨn iərmama kəru trouapri pəri ia nɨməhan kuatia, tukuvehi raka riti, kəpwəh riti. ");
INSERT INTO tnk_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Pran kəru trouvənari pəri, tukuvehi raka riti, kəpwəh riti.” ");
INSERT INTO tnk_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Mɨreɡi nərmama me səvəi Iesu həni pen tukwe in mə, “Pəku, Iərɨmənu?” Mɨreɡi in rɨni pen tɨ nirəha i mə, “Ia kwopun pəku nɨpwrai nəri remhə ikɨn menu me nəha kamhani nɨpwrai nəri sə remhə tuhəuvehe mhousəsɨmwɨn irəha me, mhani.” ");
INSERT INTO tnk_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Nəpɨn riti Iesu rokeikei mə trahatən nərmama me səvənhi mə irəha tuhaməkeikei mhəfwaki ia nəpɨn me, mhəpwəh nəpouien i. Ro pen in rɨni nusipekɨnien riti tɨ nirəha i ");
INSERT INTO tnk_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","mə, “Ia rukwənu riti iəmə asori riti sə raməkiri nəɡkiariien. In rəpwəh nehekɨrien Kumwesən, məpwəh mwi nɨsiaiien nərmama. ");
INSERT INTO tnk_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ia rukwənu nəha pran riti iərman səvənhi remhə məpwəh in. Ia nəpɨn me rauvehe tɨ iəmə asori sə raməkiri nəɡkiariien, mamɨni pen tukwe in mə, ‘Asitu ia nirak, mɨnise iərmama i ramɨni ərəha iou.’ ");
INSERT INTO tnk_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tui kwopti iəmə asori nəha rɨpko mhə nari riti, mətə kurirə irə ramətərɨɡ mə, ‘Nɨpərhienien iapkɨhekɨr mhə Kumwesən, məpwəh mwi nɨsiaiien nərmama, ");
INSERT INTO tnk_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","mətə tɨ nəri nə mə prən i ramometə iou iamɨnhi irə, takasitu irə, mɨnise iərmama nəha ramɨni ərəha in. Mə iapko mhə prən i trauvehe ia nəpɨn me, takəpou i.’” ");
INSERT INTO tnk_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Nənə Iərɨmənu səkɨtaha rɨni mə, “Kɨmiaha tihətərɨɡ ro nəɡkiariien səvəi iəmə asori nəha. In iəmə rərəha, mətə rɨni mə trasitu ia prən nəha. ");
INSERT INTO tnk_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nənə kɨmiaha hiaməfətərɨɡ ia Kumwesən? Trəfo ia nərmama me nəha in ruvərfi raka irəha mə səvənhi səməme kamhasək pen tukwe in ia ran mɨne ia nəpɨn? Ko in ro tanpen ia nirəha, məpwəh nəmri atukwatukwien nəfe kamhasək pen in tukwe? ");
INSERT INTO tnk_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Iakani pehe tukumiaha i mə in trasitu akwauakw ia nirəha, məmri atukwatukw nəfe kamhasək pen in tukwe. Nəɡkiariien i iakani ro nɨpərhienien. Mətə rəfo? Nəpɨn iou, Iəməti Iərmama, takrərɨɡ pehe mwi ia tɨprənə i, takətoni nərmama həpɨk kamhahatətə ia nirak uə rekəm?” ");
INSERT INTO tnk_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ia nəpɨn nəha Iesu rɨni mwi nusipekɨnien riti mwi tɨ nərmama nepwɨn səməme rerɨnraha ramrhi mɨnuə irəha hatukwatukw, mamhətə ərəha nərməpə. ");
INSERT INTO tnk_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","In rɨni mə, “Iərmama kəru krouutə pen fwe ia nimwə səvəi Kumwesən mə trouəfwaki. Riti Farisi. Riti iərmama sə kamərəku pen takis min. ");
INSERT INTO tnk_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nənə Farisi rərer əpə məfwaki iamɨnhi irə mə, ‘Kumwesən. Iakɨni tanak tukw ik tɨ nəri nə mə iou iapkəmwhen mhə ia nərmama nepwɨn. Irəha kamhakres, mamho noien ikou, mamhəiri nɨpran səvəi nərməpə. Iakɨni tanak tukw ik tɨ nəri nə mə iapkəmwhen mhə ia iərmama nəha kamərəku pen takis min. ");
INSERT INTO tnk_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ia nəfwakiien kuatia iakəpwəh nəniien nari m kəru tɨ nəfwakiien. Iakuai narimnari me pam sə iakapeki irəha pam ten sə ro kuatia irə səim.’ ");
INSERT INTO tnk_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Mətə iərmama nəha kamərəku pen takis min, ramərer isipwɨn kwopti. Ko rɨpkəkwətə mhə ia nɨmaɡouaɡou, mətə rerɨn rəpou. In ramərpwərpwi a kwənpwenhɨn tukwe, mamɨni mə, ‘Kumwesən, tikapi iou. Iou iəmə ərəha.’” ");
INSERT INTO tnk_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nənə Iesu rɨni mə, “Iakani pehe tukumiaha i nəpɨn irau kroueiwaiu rouevən fwe rukwənu, iərmama sə kamərəku pen takis min in ratukwatukw ia nəmri Kumwesən, mətə Farisi rɨpkatukwatukw mhə, tɨ nəri nə mə iərmama sə rauvehi utə in, Kumwesən truvehi irapw in, mətə iərmama sə rauvehi irapw in, Kumwesən truvehi utə in.” ");
INSERT INTO tnk_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nəpɨn riti nərmama nepwɨn kamhərəhi kwəti nəkwərhakwərha me mamhəuvehe tɨ Iesu mə in trɨrapi irəha, məkwein amasan ia nirəha. Nəpɨn nərmama me səvənhi hətoni, hənise irəha. ");
INSERT INTO tnk_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mətə Iesu rəkwein irəha həuvehe tukwe, mɨni mə, “Pwəh nɨpwnəti nəkwərhakwərha me həuvehe tukw iou. Tihəpwəh nɨniseien irəha tɨ nəri nə mə nɨtətə sə Kumwesən ramərɨmənu irə səvəi nərmama səməme həmwhen ia nəkwərhakwərha me i. ");
INSERT INTO tnk_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Iakani nɨpərhienien tukumiaha i mə iərmama traməkeikei mo rəmwhen ia iəkunouihi, muvehi nɨtətə sə Kumwesən ramərɨmənu irə. Mə rɨpko mhə trɨpkuvnimwə mhə ia nɨtətə nəha.” ");
INSERT INTO tnk_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Iəmə asori riti səvəi nəkur Isrel rəres Iesu i mə, “Iahatən, ik iəmə amasan. Nəfe noien takaməkeikei mo mə takuvehi nɨmɨruien rerɨn?” ");
INSERT INTO tnk_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Mɨreɡi Iesu rɨni pen tukwe in mə, “Rəfo ikɨni mə iou iəmə amasan? Iərmama amasan riti riwən. Kumwesən əpa in ramasan. ");
INSERT INTO tnk_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ik ikuvəukurən raka loa me səvəi Kumwesən. In rɨni mə, ‘Tikəpwəh nakresien pran, məpwəh nousi əpuneien iərmama, məpwəh nakresien, məpwəh neikuəien. Tikaməkeikei mɨsiai səim tata mɨne mama.’” ");
INSERT INTO tnk_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mɨreɡi iərmama nəha rɨni mə, “Loa me pam i iakamesi pen fwe ia nouihiien səiou muvehe meste pehe ipwet mɨne.” ");
INSERT INTO tnk_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nəpɨn Iesu rɨreɡi nəɡkiariien i, rɨni pen tukwe in mə, “Nari kuatia rarə ikəpwəh ihi noien. Evən, məmri pen nəmri nari ia səim narimnari me. Nəpɨn kuvehi nənimen, tikuvehi mane, muvei pen m nərmama nautə səvənraha riwən. Nənə səim nautə trɨpɨk fwe ia neiai. Nəpɨn ikɨno pam, ikuvehe mukurirə iou.” ");
INSERT INTO tnk_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Mətə nəpɨn iərmama nəha rɨreɡi nəɡkiariien nəha, rerɨn ruvehe məpou pɨk, tɨ nəri nə mə nautə səvənhi rasori anan. ");
INSERT INTO tnk_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nəpɨn Iesu rətoni mə rerɨn rəpou pɨk iamɨnhi, rɨni mə, “Rəknekɨn tɨ nərmama nautə səvənraha rasori mə tuhəuvnimwə ia nɨtətə sə Kumwesən ramərɨmənu irə. ");
INSERT INTO tnk_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Iərmama nautə səvənhi rasori rəknekɨn tukwe in mə truvnimwə ia nɨtətə sə Kumwesən ramərɨmənu irə. Rəknekɨn məpi raka nərimɨru nəha kamel rasu pen ia ruei nitel mier.” ");
INSERT INTO tnk_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nəpɨn Iesu rɨni irapw nəɡkiariien nəha, nərmama səməme kamhəreɡi həni mə, “Mə rəknekɨn iamɨnhi, nɨsɨmə nəha ko həuvehi nɨmɨruien?” ");
INSERT INTO tnk_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Mətə Iesu rɨni mə, “Nəfe nari rəknekɨn nərmama ko həpko mhə mətə rɨməru tɨ Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nənə Pita rɨni mə, “Ətə ro. Kɨmaha iahənəpwəh narimnari me səkɨmaha mamhəkurirə ik.” ");
INSERT INTO tnk_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Iakani nɨpərhienien tukumiaha i mə nərmama me pam səməme həpwəh narimnari me səvənraha tɨ nɨtətə sə Kumwesən ramərɨmənu irə tuhəuvehi tain. Trɨni mɨnuə iərmama riti rəpwəh nimwə səvənhi, uə pran səvənhi, uə piəvni me, uə tata mɨne mama səvənhi, uə nəkwərhakwərha me səvənhi, ");
INSERT INTO tnk_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ia nɨtətə ipwet mɨne in truvehi tain rasori mwi, nənə ia nɨtətə sə rauvehe in truvehi nɨmɨruien rerɨn.” ");
INSERT INTO tnk_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ia nəpɨn nəha Iesu riri raka əpa nərmama səvənhi twelef, mɨni pen tɨ nirəha i mə, “Həreɡi ro. Kɨtaha saməutə mamhəuvən fwe ia Jerusalem. Ia kwopun nəha nəɡkiariien me pam səməme kamhəɡkiari ia nirak Iəməti Iərmama ia nəkukuə me səvəi profet kupwən me tuhəuvehe mhəukuə. ");
INSERT INTO tnk_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tukuvei pen iou ia rəɡi nərmama rɨpko mhə irəha nəkur Isrel. Nənə irəha tuharɨs əkenhɨn ia nirak, mho naurɨsien miou, mhərɡəvəsi iou, ");
INSERT INTO tnk_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","mhərisi iou, nənə mhousi əpune iou. Ia nəpɨn sə ro kahar irə takətui mwi ia nemhəien səiou.” ");
INSERT INTO tnk_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Mətə nərmama me səvənhi həreirei narimnari me i. Nəɡkiariien i rərkwafə tɨ nirəha. Həpkuvehi amasan mhə nɨpwran. ");
INSERT INTO tnk_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nəpɨn Iesu rɨnamevən ipaka tɨ taon nəha Jeriko, iərmama riti nənimen rɨfwə raməkure ia nɨkare suatuk, mamase mane. ");
INSERT INTO tnk_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nəpɨn rɨreɡi nərmama me həpɨk kamhəuvehe mamhəukurau ia suatuk, rəres mə, “Nəfe i?” ");
INSERT INTO tnk_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Mɨreɡi həni pen tukwe in mə, “Iesu iəmə Nasaret i ruvehe makurau.” ");
INSERT INTO tnk_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ia nəpɨn nəha iərmama nəha rɨnaməkwein əpwəmwɨs mə, “Iesu, kwənəkwus səvəi Kiɡ Tevɨt! Api tukw iou!” ");
INSERT INTO tnk_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nənə nərmama səməme kamhərer kupwən hənise in, mamhəni mə, “Afafa a, məpwəh nəɡkiariien!” Mətə in rarɨpɨn maməkwein əpwəmwɨs mwi mamɨni mə, “Iesu, kwənəkwus səvəi Kiɡ Tevɨt! Api tukw iou!” ");
INSERT INTO tnk_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nənə Iesu rərer, mɨni pen tɨ nərmama me mə irəha tuhəiri iərmama nəha mhəuvehe tukwe in. Nənə nəpɨn iərmama nəha ruvehe ipaka, Iesu rəres pen in mɨnuə, ");
INSERT INTO tnk_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ikokeikei mə tako nəfe mik?” Mɨreɡi rɨni mə, “Iərɨmənu. Iakokeikei mə takətui mətə nari.” ");
INSERT INTO tnk_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Mɨreɡi Iesu rɨni pen tukwe in mə, “Itə. Tikətui mətə nari. Nahatətəien səim rɨnomasan raka nənimem.” ");
INSERT INTO tnk_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nənə təkwtəkwuni nəha rətui mɨnamətə nari, nənə mukurirə ia Iesu, muvehi utə nəɡhi Kumwesən. Nərmama me pam hətoni həɡnəɡɨni Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iesu rier pen ia taon nəha Jeriko, mamevən mə trəpi sɨmwɨn. ");
INSERT INTO tnk_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ia taon nəha iərmama riti nəɡhɨn nə Sakias. In iəmə asori riti ia nirəha nərmama kamərəku pen takis mɨnraha. Nautə səvənhi rasori. ");
INSERT INTO tnk_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","In ramarkut mə trətə Iesu mə in nəfe iərmama. Mətə nərmama həpɨk kamhərer tukuahaɡ in. Ko rɨpkətoni mhə tɨ nəri nə mə in rukwakwa. ");
INSERT INTO tnk_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ro pen raiu mukupwən ia nirəha, məputə ia nei riti kani mə sikamo mə trətə Iesu ia kwopun nəha trukurau ikɨn. ");
INSERT INTO tnk_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nəpɨn Iesu ruvehe muvehi teɡɨn kwopun nəha, rəkwətə, mɨni pen tukwe in mə, “Sakias. Eiwaiu akwauakw. Takaməkeikei muvnimwə ia nimwə səim ipwet.” ");
INSERT INTO tnk_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nənə Sakias reiwaiu akwauakw a miri Iesu rouevən fwe ia nimwə səvənhi. Rerɨn ramaɡien. ");
INSERT INTO tnk_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mətə nəpɨn nərmama hətoni, kamhəni ərəha Iesu mhəni mə, “In revən mamapwɨs ia nəkwai nimwə səvəi iəmə rərəha riti.” ");
INSERT INTO tnk_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Fwe ia nəkwai nimwə Sakias rɨskəmter, mɨni pen tɨ Iərɨmənu səkɨtaha mə, “Iərɨmənu. Reɡi ro! Takuai nautə səiou ia nənimen kəru, muvei pen riti m nərmama nautə səvənraha riwən. Trɨni mɨnuə iakɨnakres m iərmama riti, takərpwɨn pen min m kefə.” ");
INSERT INTO tnk_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Mɨreɡi Iesu rɨni pen tukwe in mə, “Ipwet nɨmɨruien vi ruvəuvehe tɨ nərmama ia nəkwai nimwə i tɨ nəri nə mə iəmə i in mwi kwənəkwus riti səvəi Epraham. ");
INSERT INTO tnk_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","In nə iou, Iəməti Iərmama, iakɨməuvehe tukwe mə takətui nərmama səməme hənəruei, nənə muvei pen nɨmɨruien vi mɨnraha.” ");
INSERT INTO tnk_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nəpɨn nərmama kamhətərɨɡ ia nəɡkiariien me nəha, Iesu rarə mɨni mwi nusipekɨnien riti tɨ nirəha i tɨ nəri nə mə in ruvəuvehe ipaka tɨ Jerusalem rerɨnraha ramrhi mə rosi in truvehe mo kiɡ irə mɨnamərɨmənu ia nɨtətə səvəi Kumwesən təkwtəkwuni. ");
INSERT INTO tnk_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ro iamɨnhi irə Iesu rɨni mə, “Iəmə asori riti revən ia tənə riti isipwɨn mə kiɡ riti fwe ikɨn truvei pen nasoriien min. Nənə in trɨrərɨɡ mərɨmənu ia nəkur imwəni. ");
INSERT INTO tnk_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Kurirə iəmə asori nəha rier, rəkwein nərmama səməme kamho tukwini nari min irəha pam ten, muvei pen silin kɨno ia kol kuatia kuatia mɨnraha, nənə mɨni pen tɨ nirəha i mə, ‘Kɨmiaha tihəuvehi mane me i mhowok irə meste takrərɨɡ pehe mwi.’ ");
INSERT INTO tnk_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mətə nəkur imwəni me həmwəki iəmə asori nəha, mhərhi pen nərmama nepwɨn həkurirə in, mhəuvən mhəni pen tɨ kiɡ sə truvei pen nasoriien min mə, ‘Kɨmaha iahəpwəh nokeikeiien mə iəmə i trərɨmənu ia kɨmaha.’ ");
INSERT INTO tnk_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mətə kiɡ nəha rəpwəh nɨnipehiien irəha, muvei pen nasoriien m iəmə asori nəha. Nənə nəpɨn iəmə asori nəha rɨrərɨɡ pehe imwəni, rɨni nəkwan mɨnuə tukəkwein nərmama me nəha kamho tukwini nari min səməme in rɨməuvei pen mane me mɨnraha mə tuhəuvehe tukwe. In rokeikei mə trukurən mane me in rɨməuvei pen mɨnraha hənowok irə mhəuvehi nəfe mane mwi rasori mwi. ");
INSERT INTO tnk_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Sə rukupwən muvehe mərer ia nənimen mɨni mə, ‘Iəmə Asori. Silin i ikɨməuvehi pehe miou kɨno ia kol rukwəhi mwi silin me kɨno ia kol irəha pam ten.’ ");
INSERT INTO tnk_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mɨreɡi iəmə asori rɨni pen tukwe in mə, ‘Səim wok ramasan. Ik iərmama sə ikamo tukwini amasan nari miou. Ikɨnətui amasan tɨ nəri ouihi. Ro pen takuvei pehe nasoriien mik ikərɨmənu ia taon me irəha pam ten.’ ");
INSERT INTO tnk_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nənə sə resi pen ruvehe, mɨni mə, ‘Iəmə asori. Silin i ikɨməuvehi pehe miou kɨno ia kol rukwəhi mwi silin me kɨno ia kol irəha pam krirum.’ ");
INSERT INTO tnk_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mɨreɡi iəmə asori rɨni pen tukwe in mə, ‘Ik tikərɨmənu ia taon me irəha pam krirum.’ ");
INSERT INTO tnk_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nənə riti mwi ruvehe, mɨni mə, ‘Iəmə Asori. Silin i in i ikɨməuvehi pehe miou kɨno ia kol. Iakehekɨr ik, mərkwafə i ia kwəti tɨnari, ");
INSERT INTO tnk_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","tɨ nəri nə mə ik iərmama riti noien səim rɨskai. Ikauvehi raka narimnari me sə iərməpə rɨnəmri, nənə mapeki raka mwi nəveɡɨnien ia nəmhien sə ipkəpwei mhə.’ ");
INSERT INTO tnk_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mətə iəmə asori rɨni pen tukwe in mə, ‘Ik iəmə ərəha. Ikamo tukwini ərəha nari miou. Nəɡkiariien atukw səim ro pui ik. Ik ikuvəukurən raka mə iou iərmama riti noien səiou rɨskai. Iakauvehi raka narimnari me sə iərməpə rɨnəmri, nənə mapeki raka mwi nəveɡɨnien ia nəmhien sə iapkəpwei mhə. ");
INSERT INTO tnk_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Mətə rəfo ikəpwəh nəmri penien səiou mane fwe ia paɡ? Kamo ipkəmri pen ko iapkuvehe mɨpkuvehi ihi mane səiou mɨne sə rəkwaku paɡ rukwəhi.’ ");
INSERT INTO tnk_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nənə iəmə asori rɨni pen tɨ səməme kamhərer ia kwopun nəha mə, ‘Həuvehi raka silin nəha kɨno ia kol ia rəɡɨn mhəuvei pen m iərmama sə rauvehi silin me kɨno ia kol irəha pam ten.’ ");
INSERT INTO tnk_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Mɨreɡi irəha həni pen tukwe in mə, ‘Iəmə Asori! Mətə in ruvəuvehi raka ten.’ ");
INSERT INTO tnk_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mɨreɡi iəmə asori rɨni mə, ‘Iakani pehe tukumiaha i iərmama sə kuvei pen nari riti min, ro wok irə, tukuvei pen sə rəkwaku min. Mətə iərmama sə kuvei pen nari riti min, ro nəri auər a irə, tukuvehi raka pam tukwe. ");
INSERT INTO tnk_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mətə nərmama me nəha səməme həmwəki iou, mhəpwəh nokeikeiien mə takərɨmənu ia nirəha, həuvehi irəha mhəuvehe ia nənimek, nənə mhousi əpune irəha.’” ");
INSERT INTO tnk_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Iesu rɨni pam nəɡkiariien me nəha, mərari, mautə mamevən fwe ia Jerusalem. In rakupwən nərmama me kamhəkurirə. ");
INSERT INTO tnk_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nəpɨn rier pen ia təkuər nəha nəɡhɨn nə Təkuər Olif ipaka tɨ rukwənu mi nəha Petfas mɨne Petani, rərhi pen iərmama kəru səvənhi, ");
INSERT INTO tnk_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","mɨni mə, “Kɨmirau tirouevən ia rukwənu nəha samarəti pen i. Nəpɨn tirouapirapw fwe ikɨn, tirouətə kwəti toɡki riti kɨnəkwi tərini, iərmama rɨpkəkure raka mhə irə. Tiroufi raka nari irə, rouəsɨɡi rouvehe ia kwopun i. ");
INSERT INTO tnk_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Trɨni mɨnuə iərmama riti rəres kɨmirau mə, ‘Rəfo iroufi raka nari irə?’ tirouni pen tukwe in mə, ‘Iərɨmənu səkɨtaha raməres i.’” ");
INSERT INTO tnk_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ro iamɨnhi irə, iərmama mi nəha Iesu rərhi pen irau, krouevən rouətoni narimnari me pam rosi in rɨməni pen tɨ nirau i. ");
INSERT INTO tnk_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nəpɨn kroufi raka nari ia kwəti toɡki nəha, iərmama səvənhi nəha kwəti toɡki rɨni pen tɨ nirau i mə, “Rəfo iroufi raka nari irə?” ");
INSERT INTO tnk_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Mɨreɡi krouni mə, “Iərɨmənu səkɨtaha raməres i.” ");
INSERT INTO tnk_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nənə krouəsɨɡi kwəti toɡki nəha rouvehe tɨ Iesu, rouəpənə pen kot mi səvənrau ia təkuren, nənə rouasitu ia Iesu rəputə məkure irə. ");
INSERT INTO tnk_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nəpɨn in rəkure ia kwəti toɡki nəha mamevən, nərmama həpənə pen kot me səvənraha ia suatuk. ");
INSERT INTO tnk_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nəpɨn Iesu rameiwaiu ia Təkuər Olif, mɨnamevən ipaka tɨ Jesrusalem, nərmama me pam səvənhi həpɨk anan, hənamaɡien, mamhəkwein əpwəmwɨs, mamhəɡnəɡɨni Kumwesən tɨ nɨmtətien asori me hənətoni, ");
INSERT INTO tnk_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","mamhəni mə, “Səɡnəɡɨni kiɡ i rauvehe ia nəɡhi Iərɨmənu səkɨtaha! Nəmərinuien fwe ia neiai. Kauvehi utə nəɡhi Kumwesən fwe irənhə anan!” ");
INSERT INTO tnk_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ia nəpɨn nəha Farisi me nepwɨn ia reri nərmama həni pen tɨ Iesu i mə, “Iahatən. Nise əknekɨn səim me nərmama mə tuhafafa.” ");
INSERT INTO tnk_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mɨreɡi Iesu rɨni mə, “Iakani pehe tukumiaha i. Trɨni mɨnuə irəha hafafa, kəruəterei me i tuhəkwein əpwəmwɨs.” ");
INSERT INTO tnk_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nəpɨn Iesu ruvehe ipaka tɨ taon nəha Jerusalem mətoni, ramapi tɨ nərmama me ikɨn, ");
INSERT INTO tnk_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","mɨni mə, “Rosi ko ramo kɨmiaha hiəukurən ipwet i narimnari me sə trəmri nəmərinuien, mətə təkwtəkwuni mɨne kamhərkwafə ko kɨmiaha hiəpkətoni mhə. ");
INSERT INTO tnk_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mətə nəpɨn nəha rauvehe nərmama səməme haməmwəki kɨmiaha tuhəuvehe mheikurkurau ia kɨmiaha. Naruaɡən me səvənraha tuheri tɨprənə mhərkurau ia taon səkɨmiaha mhəkure tukuahaɡ ia kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Irəha tuhousi testesi nimwə me səkɨmiaha, mharə mhousi əpune pam mwi kɨmiaha ia kwopun i. Ko irəha həpkəpwəh mhə kəpwier riti raməkure əknekɨn ia riti, tɨ nəri nə mə Kumwesən ruvəuvehe raka mə truvehimɨru kɨmiaha, mətə kɨmiaha hiəpkətə sas mhə ia nəpɨn nəha.” ");
INSERT INTO tnk_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nənə Iesu revən ia nimwə səvəi Kumwesən, mɨnaməkoui irapw nərmama səməme kamhəmri pen nəmri nari ia narimnari me mə tukuvehi nənimen, ");
INSERT INTO tnk_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","mɨni pen tɨ nirəha i mə, “Kɨmərai pen ia Nəkukuə Ikinan mɨnuə ‘Nimwə səiou tro nimwəfwaki irə.’ Mətə kɨmiaha hiəno ruvəuvehe kwopun rakres me kamhərkwafə ikɨn.” ");
INSERT INTO tnk_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ia nəpɨn me Iesu ramevən ia nimwə səvəi Kumwesən, mamahatən nərmama me. Pris asori me mɨne nahatən me səvəi Loa mɨne nəmə asori me nepwɨn mwi səvəi nəkur Isrel hokeikei mə tuhousi əpune in. ");
INSERT INTO tnk_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mətə rɨskai tɨ nirəha. Ko həpkətoni mhə suatuk riti tɨ noien tɨ nəri nə mə nərmama me pam hokeikei pɨk mə tuhətərɨɡ ia nəɡkiariien me səvənhi. ");
INSERT INTO tnk_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nəpɨn riti, Iesu ramahatən nərmama ia nimwə səvəi Kumwesən, maməvisau nəɡkiariien amasan mɨnraha, nənə pris asori me mɨne nahatən me səvəi Loa mɨne nəmə asori me səvəi nəkur Isrel həuvehe, ");
INSERT INTO tnk_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","mhəni pen tukwe in mə, “Ni pehe tukumaha i. Ikamo narimnari me i ia nəkwai sin, uə sin rəseni ik mə tiko narimnari me i?” ");
INSERT INTO tnk_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Iou mwi takəres kɨmiaha nəresien riti. Həni pehe tukw iou i. ");
INSERT INTO tnk_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Fwe kupwən sin rərhi pehe Jon mə tro paptaes ia nərmama, Kumwesən uə iərmama riti?” ");
INSERT INTO tnk_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nənə irəha həɡkiari pəri, mamhəni mə, “Tsəfni irə i? Tuko səni mə Kumwesən rərhi pehe Jon Iesu trɨni pehe tukutaha i mə ‘Ro iamɨnhi irə rəfo kɨmiaha hiəpwəh nɨniien nɨpərhienien ia nəɡkiariien səvəi Jon?’ ");
INSERT INTO tnk_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Mətə tuko səni mə iərmama riti rərhi pehe Jon, nərmama me pam i tuhəkwi əpune kɨtaha ia kəruəterei me, tɨ nəri nə mə irəha kamhəni nɨpərhienien ia Jon mə in profet riti.” ");
INSERT INTO tnk_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ro pen irəha həni pen tɨ Iesu i mə, “Kɨmaha iahəreirei mə sin rərhi pehe Jon mə tro paptaes ia nərmama.” ");
INSERT INTO tnk_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Iou mwi ko iakəpwəh nɨniien tukumiaha i mə iakamo narimnari me i ia nəkwai sin.” ");
INSERT INTO tnk_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Iesu rɨnaməɡkiari m nərmama mɨni irapw nusipekɨnien riti tɨ nirəha i, mɨni mə, “Iəmə asori riti rəpwei nəkwus nəha krep ia nəmhien səvənhi, məpwei pam, nənə məseni nərmama nepwɨn həuvehe mhətui tɨ nɨmei krep səvənhi. Irəha tuhəmhu ikɨn, mhesi kwənkwai krep, mhəuai, mhəuvei pen nɨpərɨn m iəmə asori. Iəmə asori rəmri nɨmei krep səvənhi ia rəɡɨnraha, mier mevən ia tənə əpə iti marə kɨni tui fwe ikɨn. ");
INSERT INTO tnk_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nəpɨn kwənkwai krep rɨmruə, iəmə asori rərhi pen iərmama riti sə ramo tukwini nari min revən mətə nəmə hamətui tɨ nɨmei krep səvənhi mə tuhəuvei pen nukwai krep me nepwɨn min. Mətə nəmə kamhətui tɨ krep həuəsi iəmə nəha, mhərhi pen i ramevən, mhəpwəh nuvei penien nari riti min. ");
INSERT INTO tnk_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nənə iəmə asori rərhi pen mwi iərmama riti mwi sə ramo tukwini nari min revən. Mətə ho rəmwhen a mwi irə, mhəuəsi in, mho naurɨsien min, mhərhi pen in rɨrərɨɡ, mhəpwəh nuvei penien nari riti min. ");
INSERT INTO tnk_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nənə iəmə asori rərari mərhi pen sə ro kahar irə revən. Sə nəha mwi həuəsi in nɨpwran me rəpəruəpəruə, mhərarki irapw i. ");
INSERT INTO tnk_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ia nəpɨn nəha iəmə asori səvəi nɨmei krep rɨni mə, ‘Takəfo i? Ramasan mə pwəh iakərhi pen nərɨk keikei. Irəha tuhətoni, mhəsiai in.’ ");
INSERT INTO tnk_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Mətə nəpɨn nəmə me nəha hətoni tɨni iəmə asori rauvehe, həni pen tɨ nirəha me i mə, ‘Kwa tɨni iəmə asori nəha. Nəpɨn tata səvənhi tremhə, nəmhien i ruvehe mo səvənhi. Pwəh sousi əpune nənə nəmhien səvənhi truvehe mo səkɨtaha i.’ ");
INSERT INTO tnk_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nənə irəha həkwtəmhiri, mhousi əpune, mhərarki irapw ia taniruə. Ro iamɨnhi irə iəmə asori səvəi nɨmei krep trəfo ia nəmə me nəha? ");
INSERT INTO tnk_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","In truvehe, mousi əpune irəha, nənə məseni pen nɨmei krep səvənhi ia rəɡi nərməpə.” Nəpɨn nərmama me həreɡi nəɡkiariien nəha, həni mə, “Rekəm. Ko rɨpko mhə iamɨnhi.” ");
INSERT INTO tnk_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Mətə Iesu rəti pen mətə irəha mɨni mə, “Mə trɨpko mhə iamɨnhi nəfe nɨpwrai nəɡkiariien i kɨmərai pen ia Nəkukuə Ikinan? ‘Kəruəterei nəha nəmə kamhəuvrhəkɨn nimwə hənuə rərəha, mhəpwəh, təkwtəkwuni nəha ruvəuvehe mɨno kəruəterei sə rəpi raka pam kəruəterei me, məkwtəmhiri əknekɨn pam nimwə. ");
INSERT INTO tnk_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Iərmama sə trɨmwei pen ia kəruəterei nəha, nɨkəkrin me trərkwəpɨrərkwəpɨr. Trɨni mɨnuə kəruəterei nəha rɨmwei pen ia iərmama riti, iərmama nəha trɨpwarɨspwarɨs.’” ");
INSERT INTO tnk_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Nahatən me səvəi Loa mɨne pris asori me hənuə tuhəkwtəmhiri a Iesu ia nəpɨn nəha tɨ nəri nə mə həreɡi mə in rɨni nusipekɨnien nəha muəsi irəha i, mətə hənhekɨr a nərmama. ");
INSERT INTO tnk_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ro pen irəha kamhətə amasan in, mhərhi pen nərmama nepwɨn sə kamhətə afafa nari həuvən mə tuheikuə ia Iesu mhəres pen nəresien me nepwɨn min. Nəmə asori me hokeikei mə Iesu trəfwəkour ia nəɡkiariien səvənhi, nənə irəha həukurən nəkwtəmhiriien in tukwe, nənə mhəuvei pen in ia rəɡi iəmə Rom sə rauvehi nasoriien mamərɨmənu ia kwopun nəha. ");
INSERT INTO tnk_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nəmə me nəha sə kamhətə afafa nari həuvən mhəres pen Iesu i mə, “Iahatən. Kɨmaha iahəukurən mə nəɡkiariien me səim sə ikamahatən nərmama me irə ratukwatukw. Ipkopəiti mhə ia nərmama me nepwɨn, mətə ikamahatən pərhien suatuk sə Kumwesən rokeikei mə nərmama tuhesi pen. ");
INSERT INTO tnk_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ro iamɨnhi irə tiko mɨni pehe ro tukumaha i nətərɨɡien səim. Ratukwatukw ia Loa səkɨtaha mə tsərəku pen nəmri takis m Kiɡ Sisa uə rekəm?” ");
INSERT INTO tnk_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mətə Iesu ruvəukurən raka mə irəha kamheikuə a, mamhəres nəresien nəha mə in trəfwəkour ia nəɡkiariien səvənhi. Ro pen in rɨni pen tɨ nirəha i mɨnuə, ");
INSERT INTO tnk_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Həuvei pehe silin riti pwəh iakətə ro. Nənɨmwi iərmama sin i ia silin? Nənə nəɡhi sin i?” Mɨreɡi irəha həni mə, “Nənɨmwi Kiɡ Sisa mɨne nəɡhi Kiɡ Sisa.” ");
INSERT INTO tnk_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Ianhi irə, narimnari me səvəi Kiɡ Sisa hiəuvei pen m Kiɡ Sisa. Narimnari me səvəi Kumwesən hiəuvei pen m Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nənə irəha ko həpkəkwtəmhiri mhə Iesu ia nəmri nərmama tɨ nəri nə mə rɨpkəfwəkour mhə ia nəɡkiariien səvənhi. Mətə hərkərinari ia nəɡkiariien səvənhi, nənə mhəuvehe mhəpnapen. ");
INSERT INTO tnk_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Satusi me nepwɨn həuvehe tɨ Iesu. (Satusi me irəha kamhəni mə iərmama sə ruvamhə ko rɨpkətui mhə mwi.) ");
INSERT INTO tnk_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Irəha həuvehe mhəres in nəresien riti, mhəni mə, “Iahatən. Moses rɨmərai pen ia Loa səkɨtaha mə trɨni mɨnuə iərman riti remhə, məpwəh səvənhi pran, mətə tɨnɨnrau riwən, piəvi iərman nəha traməkeikei miri pran nəha rouərəhi nəkwərhakwərha me, rouəsihaɡɨn piəvi iəmə nəha. ");
INSERT INTO tnk_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Mətə nərman sefen, irəha piəvnraha me. Sə rasori riri pran riti, rouəpwəh nərəhiien iəkunouihi riti, remhə, məpwəh səvənhi pran. ");
INSERT INTO tnk_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Piəvni sə resi pen in mwi ro mwi iamɨnhi irə. ");
INSERT INTO tnk_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nənə piəvni sə ro kahar, mamevən meste irəha pam sefen həiri prən nəha, mhemhə pam. ");
INSERT INTO tnk_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Nənə prən nəha rəpwəh nərəhiien iəkunouihi riti, memhə mwi. ");
INSERT INTO tnk_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ni pehe ro tukumaha i. Ia nəpɨn nəha Kumwesən tro nərmama hətui mwi ia nemhəien, prən nəha səvəi sin ia nərman me nəha sefen, tɨ nəri nə mə irəha pam həməiri in?” ");
INSERT INTO tnk_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Ia nɨtətə ipwet mɨne nərman kamhəiri nɨpran, nɨpran kamhesi pen nərman. ");
INSERT INTO tnk_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Mətə ia nɨtətə vi sə truvehe, nərman mɨne nɨpran me tuhəpwəh noien iamɨnha irə. Nərman mɨne nɨpran səməme Kumwesən trətə irəha mə hatukwatukw tuhətui mwi ia nemhəien, nənə mharə ia nɨtətə vi nəha. ");
INSERT INTO tnk_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Irəha tuhəpwəh nemhəien mwi tɨ nəri nə mə irəha həmwhen ia naɡelo me. Irəha nɨpwnəti Kumwesən me tɨ nəri nə mə in ro irəha hətui mwi ia nemhəien. ");
INSERT INTO tnk_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mətə Moses in mwi rɨnahatən mə nərmama səməme həuvamhə tuhətui mwi. Ia kwopi nəɡkiariien sə raməɡkiari ia nei nəha napw rauək irə mətə rɨpkahi əmwesi mhə, Moses rɨnəkwein Iərɨmənu mɨni mə in Kumwesən səvəi Epraham mɨne Kumwesən səvəi Aesak mɨne Kumwesən səvəi Jekop. ");
INSERT INTO tnk_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nəɡkiariien nəha ramahatən pen mə Kumwesən rɨpko mhə in Kumwesən səvəi nərmama me səməme həuvamhə, mətə in Kumwesən səvəi nərmama me səməme kamhəmɨru. Ro iamɨnhi irə tɨ nəri nə mə ia nənimen nərmama me pam kamhəmɨru.” ");
INSERT INTO tnk_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ia nəpɨn nəha nahatən me nepwɨn səvəi Loa həni mə, “Iahatən. Nəɡkiariien səim ratukwatukw.” ");
INSERT INTO tnk_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Irəha həni iamɨnhi irə tɨ nəri nə mə Satusi me hənaurɨs, ko həpwəh nəresien nari riti mwi min. ");
INSERT INTO tnk_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Mətə Iesu rɨni pen tɨ nirəha i mə, “Rəfo kamɨni mə Kristo in tɨni Kiɡ Tevɨt? ");
INSERT INTO tnk_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kiɡ Tevɨt atukwatukw rɨməni ia Nəkukuə Ol Sam mə, ‘Kumwesən rɨni pen tɨ Iərɨmənu səiou mə, Əkure ia nɨkarek mwatuk, ");
INSERT INTO tnk_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","meste tako nərmama səməme haməmwəki ik həuvehe, tikərpwi utə tɨpaɡe nɨsum mi ia nirəha.’ ");
INSERT INTO tnk_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ia nəɡkiariien nəha Kiɡ Tevɨt rɨnəkwein Kristo mə Iərɨmənu səvənhi. Mə ro iamɨnhi irə rəfo kamɨni mə in tɨni Kiɡ Tevɨt?” ");
INSERT INTO tnk_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nəpɨn nərmama me pam kamhətərɨɡ irə, Iesu rɨni pen tɨ nərmama me səvənhi mɨnuə, ");
INSERT INTO tnk_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kɨmiaha tihaməkeikei mhəsiari tɨ nahatən me səvəi Loa. Irəha hokeikei mə tuharkahu ia karkahu əpwəmwɨs me, mamhan. Ia kwopun kamomaket me ikɨn hokeikei mə nərmama tuhəkwein irəha ia nɨsiaiien. Ia nəkwai nimwəfwaki me səvəi nəkur Isrel hokeikei mə tuhəkure ia kwopun amasan me. Ia nəveɡɨnien asori me hokeikei mə tuhəkure ia kwopun kamsiai nəmə asori me ikɨn. ");
INSERT INTO tnk_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Irəha kamheikuə ia nɨpran me səməme nərman me səvənraha həuvamhə, mamhakres narimnari me səvənraha, nənə mamho mwi nəfwakiien əpwəmwɨs me mə nərmama tuhətoni həsiai irəha tukwe. Kumwesən trərpwɨn noien ərəha me səvənraha rasori mwi.” ");
INSERT INTO tnk_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iesu rəti pen mətoni nərmama nautə səvənraha rasori kamherukw pen mane me səvənraha ia kwopun kamerukw pen mane m Kumwesən ikɨn. ");
INSERT INTO tnk_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ia nəpɨn nəha pran riti ruvehe. Prən nəha iərman səvənhi remhə məpwəh in. Nautə səvənhi riwən. Ruvehe merukw pen silin ouihi mi kəru. Iesu rətoni, ");
INSERT INTO tnk_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","mɨni mə, “Iakani nɨpərhienien tukumiaha i prən i nautə səvənhi riwən iərman səvənhi remhə məpwəh in rerukw pen mane rasori məpi raka nərmama me pam nəha. ");
INSERT INTO tnk_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Iakani iamɨnhi irə tɨ nəri nə mə nərmama me nəha nautə səvənraha rasori. Həuvehi raka nɨpərɨn a mhəuvei pen m Kumwesən. Mətə prən i nautə səvənhi riwən ruvei pen mane me pam səvənhi sə truvehi nəveɡɨnien irə.” ");
INSERT INTO tnk_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nərmama nepwɨn səvəi Iesu kamhəɡkiari ia nimwə səvəi Kumwesən, mamhəni mə ramasan pɨk tɨ nəri nə mə kɨno ia kəruəterei amasan me mɨne narimnari amasan me kɨməuvei pen m Kumwesən. Nənə Iesu rɨni mə, ");
INSERT INTO tnk_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Narimnari me i kɨmiaha hiamətoni, tukamevən tukousi testesi pam, kəruəterei riti ko rəpwəh nərer əknekɨnien ia riti.” ");
INSERT INTO tnk_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mɨreɡi irəha həres pen in mə, “Iahatən. Narimnari me i tuhəuvehe tɨnesən? Nəfe nɨmtətien truvehe mahatən pen mə nəpɨn səvəi narimnari me i ruvəuvehe ipaka?” ");
INSERT INTO tnk_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Mɨreɡi Iesu rɨni mə, “Kɨmiaha tihaməsiari kamo iərmama riti reikuə ia kɨmiaha. Nərmama həpɨk tuhəuvehe ia nəɡhɨk, mhəni mə irəha Kristo, mhəni mwi mə nəpɨn səvəi narimnari me i ruvəuvehe ipaka. Mətə kɨmiaha tihəpwəh nukurirəien ia nirəha. ");
INSERT INTO tnk_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kɨmiaha tihəreɡi nərmama tuhəvisau ia naruaɡənien me səməme nərmama kamho ia nirəha me, mamho mwi ia nərmama səməme kamhərɨmənu. Nəpɨn tihəreɡi, tihəpwəh nehekɨrien, tɨ nəri nə mə nəri nəha traməkeikei mukupwən muvehe, mətə rɨpko mhə ihi nəpɨn sampam.” ");
INSERT INTO tnk_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Iesu rarə mɨni pen mwi tɨ nirəha i mə, “Nərmama ia kwənəkwus riti tuhəskəmter mharuaɡən irəha nərmama ia kwənəkwus əpə. Nərmama səvəi kiɡ riti tuhəskəmter mharuaɡən irəha nərmama səvəi kiɡ əpə. ");
INSERT INTO tnk_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nɨmwnɨmwien asori me tuhəkiu. Ia kwopun me nepwɨn nukumhə trahi nərmama. Nemhəien skai me tuhəuvehe mhouraha nərmama. Nənə narimnari me nərmama tuhətoni həhekɨr i mɨne nɨmtətien asori me tuhəuku pen ia nɨmaɡouaɡou. ");
INSERT INTO tnk_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Mətə nəpɨn narimnari me nəha həpkuvehe mhə ihi, nərmama tuhəkwtəmhiri kɨmiaha ia rəɡɨnraha, mhometə kɨmiaha. Irəha tuhəuvei pen kɨmiaha ia rəɡi nəmə asori me ia nəkwai nimwəfwaki me səvəi nəkur Isrel. Tɨ nəri nə mə kɨmiaha nərmama me səiou, nəmə asori me nəha tuhəuvehi puvnimwə kɨmiaha ia kalapus, nənə mhərpwi irapw kɨmiaha ia nəmri kiɡ me mɨne nəmri nərmama səməme kamhərɨmənu. ");
INSERT INTO tnk_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","In i nəpɨn səkɨmiaha tihəni irapw nəɡkiariien amasan səiou irə. ");
INSERT INTO tnk_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ro iamɨnhi irə mɨne kɨmiaha tihəpwəh nətərɨɡ pɨkien ia nəfe nəɡkiariien səkɨmiaha tihəni pen tɨ nirəha i. ");
INSERT INTO tnk_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Iou takuvei pehe nəɡkiariien mɨne nukurənien m kɨmiaha. Nərmama me nəha səməme kamhəmwəki kɨmiaha tuhəreɡi nəɡkiariien me səkɨmiaha, irəha riti ko rɨpkousi raka mhə, uə trɨni neikuəien irə. ");
INSERT INTO tnk_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Tata me mɨne mama me səkɨmiaha me, mɨne piəvmiaha me, mɨne nərmama ia kwənəkwus me səkɨmiaha me, mɨne kɨmiaha me nepwɨn tuhəuvei pen kɨmiaha ia rəɡi nərmama səməme haməmwəki kɨmiaha. Nənə irəha tuhousi əpune kɨmiaha nepwɨn. ");
INSERT INTO tnk_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nərmama me pam tuhəmwəki kɨmiaha tɨ nəri nə mə kɨmiaha nərmama me səiou. ");
INSERT INTO tnk_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mətə nɨmwai nukwənemiaha nə ia kəmkapwəmiaha kuatia ia nirəha trɨpkiwən mhə. ");
INSERT INTO tnk_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kɨmiaha tihaməkeikei mhərer əknekɨn ia nahatətəien səkɨmiaha. Ia noien i tihəuvehi nɨmɨruien.” ");
INSERT INTO tnk_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Mətə nəpɨn kɨmiaha tihətoni naruaɡən me həpɨk həuvehe mheikurkurau ia Jerusalem, tihaməkeikei mhəukurən mə trɨpko mhə tui nənə irəha tuhouraha pam kwopun i. ");
INSERT INTO tnk_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ia nəpɨn nəha, nərmama ia tənə Jutia tuhaməkeikei mhap mhəuvən ia təkuər me. Səməme kamharə ia nəkwai taon i tuhaməkeikei mhəier. Nənə səməme kamharə iruə tuhəpwəh nuvnimwə peheien mwi irə. ");
INSERT INTO tnk_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nəpɨn nəha in nəpɨn sə Kumwesən trərpwɨn noien ərəha me irə, mo nəɡkiariien me pam səməme kɨmərai pen ia Nəkukuə Ikinan həuvehe mhəukuə. ");
INSERT INTO tnk_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Trərəha anan tɨ nɨpran me səməme tuhəpəmpəm mɨne səməme tuhaməuvei pen kənunu m nəkwərhakwərha əmtəmetə me ia nəpɨn nəha, tɨ nəri nə mə nəmisəien asori treste tɨprənə i. Niemaha səvəi Kumwesən trəuiui nərmama me ia kwopun i. ");
INSERT INTO tnk_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Tukəpi əpune nepwɨn ia nau, nənə kəkwtəmhiri nepwɨn kuvehi irəha həuvən mho slef me ia nirəha ia tənəmtənə me. Nənə nərmama rɨpko mhə irəha nəkur Isrel tuhavən testesi Jerusalem, mhərɨmənu ia nəkur me ikɨn meste nəpɨn səvəi nərmama rɨpko mhə irəha nəkur Isrel tro sampam.” ");
INSERT INTO tnk_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Nənə nɨmtətien me tuhəuku pen ia meri, məkwə, mɨne kəməhau me. Ia təkure tɨprənə i nərmama ia tənəmtənə me tuhəhekɨr, mhəreirei tɨ nəri nə mə təsi ramərkwəpahar pɨk, mamo peiau peiau asori me. ");
INSERT INTO tnk_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nərmama tuhətoni nəfe truvehe meste tɨprənə i, nənə həhekɨr pɨk, mhemhə rasi tukwe. Narimnari me ia nɨmaɡouaɡou həskai pɨk, Kumwesən trɨkiukiu ia nirəha. ");
INSERT INTO tnk_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ia nəpɨn nəha irəha tuhətoni iou, Iəməti Iərmama, ia reri nəpuə riti, iakauvehe ia nɨskaiien mɨne nukuraanien asori. ");
INSERT INTO tnk_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nəpɨn kɨmiaha tihətoni narimnari me nəha hənaməier pehe, tihərer atukwatukw, mhəkwətə, tɨ nəri nə mə nəpɨn səkɨmiaha sə takeivinari nari ia kɨmiaha ruvəuvehe ipaka.” ");
INSERT INTO tnk_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Nənə Iesu rɨni nusipekɨnien riti tɨ nirəha i mə, “Hətə ro nei niemɨs mɨne nei me pam. ");
INSERT INTO tnk_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nəpɨn hənaməpɨrpɨr kɨmiaha hiətoni mhəukurən mə nəpɨn səvəi nəpnəpanien ruvəuvehe ipaka. ");
INSERT INTO tnk_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Rəmwhen a mwi, nəpɨn kɨmiaha tihətoni narimnari me i hənaməier pehe, tihəukurən mə nɨtətə sə Kumwesən ramərɨmənu irə ruvəuvehe ipaka. ");
INSERT INTO tnk_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Iakani nɨpərhienien tukumiaha i mə nərmama səməme kamhəmɨru təkwtəkwuni mɨne tuhəpwəh nemhə pamien meste narimnari me pam i həier pehe. ");
INSERT INTO tnk_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Neiai mɨne tɨprənə trouiwən, mətə nəɡkiariien me səiou tuhəpkiwən mhə.” ");
INSERT INTO tnk_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Nənə Iesu rɨni mə, “Mətə kɨmiaha tihaməkeikei mhəsiari, mhəpwəh nourahaien nəpɨn səkɨmiaha ia noien lafet me, uə ia nənɨmwiien nənɨmwiien skai mhakonə irə, uə ia nətərɨɡ pɨkien ia narəien səkɨmiaha ia tɨprənə i. Rərəha nəpɨn nəha səiou truvehe məsɡatukw ia kɨmiaha rəmwhen kwənkru ruəsi kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Iakani iamɨnhi irə tɨ nəri nə mə nəpɨn nəha treste nərmama pam ia təkure tɨprənə i. ");
INSERT INTO tnk_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mətə ia nəpɨn me kɨmiaha tihaməkeikei mhətui amasan, mhəpwəh napriien. Tihəfwaki mə nəpɨn narimnari me nəha truvehe irə nɨskaiien səkɨmiaha trəmwhen tɨ narakaien irə, nənə mhərer ia nənimek, Iou Iəməti Iərmama.” ");
INSERT INTO tnk_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ia nəpɨn me pam Iesu ramahatən nərmama ia nimwə səvəi Kumwesən, mətə ia nəpɨn rier ia taon, mevən mapri ia Təkuər Olif. ");
INSERT INTO tnk_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nənə ia nəpnəpɨn anan nərmama me həuvehe mwi tukwe fwe ia nimwə səvəi Kumwesən mə tuhətərɨɡ in. ");
INSERT INTO tnk_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nəveɡɨnien asori nəha nəkur Isrel kamhani bred sə yis riwən irə ruvəuvehe ipaka. Nəveɡɨnien asori nəha nəɡhɨn nə Pasova. ");
INSERT INTO tnk_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Pris asori me mɨne nahatən me səvəi Loa kamhətui suatuk riti mə tuhəuvən afafa mhousi əpune Iesu tɨ nəri nə mə kamhhekɨr nərmama. ");
INSERT INTO tnk_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ia nəpɨn nəha Setan ruvnimwə ia reri Jutas, iəmə nəha kani mwi in mə Iskariot, in riti ia nərmama me twelef səvəi Iesu. ");
INSERT INTO tnk_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nənə Jutas rəpwəh irəha mevən tɨ pris asori me mɨne nəmə asori me səvəi naruaɡən me sə kamhətui tɨ nimwə səvəi Kumwesən, məɡkiari mɨnraha mɨni mə rukurən nətuiien suatuk riti tɨ nuvei penien Iesu ia rəɡɨnraha. ");
INSERT INTO tnk_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nəpɨn irəha həreɡi, rerɨnraha raɡien. Həni sɨmwɨn mə tuhəuvei pen mane min. ");
INSERT INTO tnk_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ro pen Jutas rəseni, nənə mɨnamətui nəpɨn riti nərmama həiwən irə mə truvei pen Iesu ia rəɡɨnraha. ");
INSERT INTO tnk_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nəveɡɨnien asori nəha nəkur Isrel kamhani bred sə yis riwən irə ruvəuvehe. Ia nəpɨn nəha kamhousi əpune kwəti sipsip me səvəi Pasova. ");
INSERT INTO tnk_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ro pen Iesu rərhi pen Pita mɨne Jon, mɨni mə, “Rouevən, rouəpnəpenə ia nəveɡɨnien səvəi Pasova sənətaha, pwəh sani.” ");
INSERT INTO tnk_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Mɨreɡi krouni pen tukwe in mə, “Ikokeikei mə kɨmrau trouəpnəpenə irə pəku?” ");
INSERT INTO tnk_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Mɨreɡi in rɨni pen tɨ nirau i mə, “Roureɡi ro. Nəpɨn kɨmirau tirouier pen fwe ia taon, iərman riti trəpi raka kɨmirau ia suatuk, mauvehi tɨkinari riti nui rukuər irə. Iroukurirə pen in rouuvnimwə ia nimwə nəha in truvnimwə irə, ");
INSERT INTO tnk_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","nənə rouni pen tɨ iəmə asori səvəi nimwə nəha mə, ‘Iahatən səkɨtaha rani pehe tukw ik i mə nimwə əfo nəha tahani pəri nəveɡɨnien səvəi Pasova kɨmaha səiou me nərmama me ikɨn?’ ");
INSERT INTO tnk_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nənə in triri kɨmirau mevən fwe irənhə ia nimwə nəha mahatən rum asori riti. Narimnari me pam hənəmak raka fwe ikɨn. Ia rum nəha kɨmirau tirouəpnəpenə tukutaha.” ");
INSERT INTO tnk_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nənə irau krouevən rouətə narimnari me pam rosi Iesu rɨməni pen tɨ nirau i. Nənə krouəpnəpenə ia nəveɡɨnien səvəi Pasova. ");
INSERT INTO tnk_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nəpɨn səvəi nəniien nari ruvəuvehe. Iesu rəkure ia kwopun kaməni nari ikɨn irəha aposol me səvənhi. ");
INSERT INTO tnk_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ia nəpɨn nəha in rɨni pen tɨ nirəha i mə, “Iakɨnokeikei pɨk mə kurirə ko nəmisəien miou, takukupwən məni nəveɡɨnien i səvəi Pasova kɨtaha m kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Iakani pehe tukumiaha i iou tapkəni mhə mwi nəveɡɨnien səvəi Pasova meste nɨpwrai nəveɡɨnien i truvehe mukuə ia nɨtətə sə Kumwesən ramərɨmənu irə.” ");
INSERT INTO tnk_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nənə Iesu ruvehi kap waen, məfwaki mɨni vivi Kumwesən tukwe, nənə mɨni mə, “Kɨmiaha pam tuhəuvehi nəri, mhənɨmwi. ");
INSERT INTO tnk_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Iakani pehe tukumiaha i ipwet mɨne mamevən tapkənɨmwi mhə mwi waen meste nɨtətə sə Kumwesən ramərɨmənu irə truvehe.” ");
INSERT INTO tnk_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kurirə irə in ruvehi bred, məfwaki mɨni vivi Kumwesən tukwe, nənə məkwsen, muvei pen mɨnraha, mɨni mə, “In i nɨpwrak sə takuvei pen tukumiaha. Kɨmiaha tihaməkeikei mamho iamɨnhi irə mə rerɨmiaha ramrhi iou.” ");
INSERT INTO tnk_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Rəmwhen a mwi nəpɨn irəha hənani raka nari, Iesu ruvehi kap waen, mɨni mə, “Kap i in i nəɡkiariien vi səvəi Kumwesən. Nɨtek sə traiu tukumiaha trərihi tərini əknekɨn nəɡkiariien nəha. ");
INSERT INTO tnk_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Mətə həreɡi ro. Iərmama sə truvei pen iou ia rəɡi nərmama səməme kamhəmwəki iou raməkure kɨmrau min. ");
INSERT INTO tnk_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Iou, Iəməti Iərmama, takaməkeikei memhə rəmwhen kɨmərfi mə tuko ia nirak, mətə trərəha anan tɨ iərmama sə truvei pen iou ia rəɡi nərmama səməme kamhəmwəki iou.” ");
INSERT INTO tnk_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nəpɨn Iesu rɨni nəɡkiariien nəha, irəha hənaməres irəha me i mə sin nəha ia nirəha tro iamɨnha irə mɨne. ");
INSERT INTO tnk_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ia nəpɨn nəha nərmama me səvəi Iesu hənaməvisə mɨnraha me, mamhəres irəha me i mə sin ia nirəha in rasori. ");
INSERT INTO tnk_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Nənə Iesu rɨni pen tɨ nirəha i mə, “Kiɡ me səvəi nərmama me rɨpko mhə irəha nəkur Isrel kamhərɨmənu ia nirəha. Səməme hasori ia nirəha kani irəha mə Nərmama səvəi Nasituien. ");
INSERT INTO tnk_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mətə kɨmiaha tihəpwəh noien iamɨnha irə ia kɨmiaha me, rekəm. Iərmama nəha ia kɨmiaha in rasori traməkeikei muvehe məmwhen iərmama nəha ia kɨmiaha nuk səvənhi rouihi. Nənə iərmama nəha ia kɨmiaha in ramiri pen kɨmiaha ia suatuk sə tihesi, traməkeikei muvehe məmwhen iərmama sə ramo tukwini nari m kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Sin nəha in rasori, iəmə asori sə raməkure maməni nari uə səvənhi iotukwininari sə rasui raka nəveɡɨnien sənəni? Kɨmiaha hiəukurən mə iəmə asori sə raməkure maməni nari in rasori. Mətə ia rerɨmiaha iou iakamo rəmwhen iotukwininari sə rasui raka nəveɡɨnien sənəmiaha. ");
INSERT INTO tnk_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kɨmiaha i hiəpkap raka mhə ia nirak nəpɨn iakɨnarə ia nəsəsauien me səiou. ");
INSERT INTO tnk_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ro pen rəmwhen ia Tata səiou rɨməuvei pehe nasoriien miou mə takərɨmənu, iou mwi takuvei pehe nasoriien m kɨmiaha mə tihərɨmənu. ");
INSERT INTO tnk_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ia nɨtətə səiou sə takərɨmənu irə, kɨmiaha tihəkure ia tepol səiou, mhəveɡɨn, mhənɨmwi, nənə mhəkure ia jea me, mhərɨmənu ia kwənəkwus me twelef səvəi nəkur Isrel.” ");
INSERT INTO tnk_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Saemon, Saemon. Reɡi ro! Setan rɨnəres raka Kumwesən i mə trəseni pen kɨmiaha ia rəɡɨn. In rokeikei mə truai kɨmiaha rəmwhen iərmama ruai nuni wit mɨne tekɨn. ");
INSERT INTO tnk_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Mətə iakɨnəfwaki raka tukw ik mə nahatətəien səim trəpwəh nɨmweiien. Nənə nəpɨn tikrərɨɡ muvehe mwi tukw iou, tikaməkeikei mo nahatətəien səvəi piam me ruvehe mɨskai.” ");
INSERT INTO tnk_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Mɨreɡi Pita rɨni pen tukwe in mə, “Iərɨmənu. Iakamərer mwatuk mə takuvnimwə ia kalapus krau mik, uə takemhə krau mik.” ");
INSERT INTO tnk_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Mɨreɡi Iesu rɨni mə, “Pita. Iakani pehe tukw ik i ia nəpɨn a i rəiə trəpwəh nakakaien meste tikɨni m kahar mə ikreirei iou.” ");
INSERT INTO tnk_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nənə Iesu rɨni pen tɨ nirəha i mə, “Fwe kupwən, nəpɨn iakɨnərhi pen kɨmiaha mə tihəuvən mhəvisau, hio rəmwhen iakɨməni, hiəpwəh nuvehiien tənərɨpw sə hiaməvai pen mane uə tɨnari irə mɨne put me səkɨmiaha. Nənə rəfo? Nari riti rɨməiwən təni kɨmiaha?” Mɨreɡi irəha həni mə, “Rekəm. Nari riti riwən.” ");
INSERT INTO tnk_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Mətə təkwtəkwuni trɨni mɨnuə iərmama riti səvənhi fwe tənərɨpw sə ravai pen mane uə tɨnari irə, pwəh ruvehi. Nənə trɨni mɨnuə iərmama riti səvənhi nau səvəi naruaɡənien riwən, pwəh rəmri pen nəmri nari ia kot səvənhi, muvehi riti irə. ");
INSERT INTO tnk_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Iakani pehe tukumiaha i nəɡkiariien i ia Nəkukuə Ikinan traməkeikei muvehe mukuə ia nirak. Rɨni mɨnuə ‘Kəvsini pen in irəha nərmama səməme kamhərui loa.’ Nəɡkiariien i kɨmərai pen ia Nəkukuə Ikinan raməɡkiari ia nirak, rɨnakuə nəha təkwtəkwuni.” ");
INSERT INTO tnk_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Mɨreɡi irəha həni mə, “Iərɨmənu. Ətə ro! Nau kəru i səvəi naruaɡənien.” Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Nəmwhen.” ");
INSERT INTO tnk_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iesu rier ia taon, mevən ia Təkuər Olif rəmwhen ramo ia nəruarəv me pam. Nərmama me səvənhi kamhəkurirə in. ");
INSERT INTO tnk_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nəpɨn in rapirapw ia kwopun nəha, rɨni pen tɨ nirəha i mə, “Kɨmiaha tihəfwaki mə tihəpwəh nɨmweiien ia nərəhaien.” ");
INSERT INTO tnk_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nənə in rəpwəh irəha mevən isipwɨn kwopti, mɨnɨmwi nukurhun mi, məfwaki, ");
INSERT INTO tnk_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","mɨni mə, “Tata. Trɨni mɨnuə ratukwatukw ia nətərɨɡien səim, tikuvehi raka kap i pwəh iakəpwəh nənɨmwiien. Mətə tikəpwəh noien rəmwhen sə iakokeikei, tiko rəmwhen sə ikokeikei.” ");
INSERT INTO tnk_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ia nəpɨn nəha aɡelo riti ruku pen ia neiai mier irapw tɨ Iesu mo in rɨskai mwi. ");
INSERT INTO tnk_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nənə tɨ nəri nə mə Iesu rɨreɡi rərəha anan, rəfwaki əmisə mwi. Nɨseseien səvənhi ruvehe məmwhen ia netə sə rəmərəməri pen ia tɨprənə. ");
INSERT INTO tnk_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nəpɨn in rəfwaki pam, mɨskəmter, mevən mwi tɨ nərmama me səvənhi, mətoni mə hənapri tɨ nəri nə mə rerɨnraha rəpou. ");
INSERT INTO tnk_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","In rɨni pen tɨ nirəha i mə, “Rəfo kɨmiaha hiamapri? Hətui, mhəfwaki mə tihəpwəh nɨmweiien ia nərəhaien.” ");
INSERT INTO tnk_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nəpɨn Iesu raməɡkiari ihi, nərmama həpɨk həuvehe. Iəmə nəha, nəɡhɨn nə Jutas, riti ia twelef nərmama me səvəi Iesu, ramiri irəha. In ruvehe ipaka tɨ Iesu mə trakei min, ");
INSERT INTO tnk_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","mətə Iesu rɨni pen tukwe in mə, “Jutas. Rəfo? Ikuə tiko pui iou, Iəməti Iərmama, ia nakeiien?” ");
INSERT INTO tnk_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nəpɨn nərmama səməme kamhərer ipaka tɨ Iesu hətoni nəfe trukurirə mier pehe, həni mə, “Iərɨmənu. Kɨmaha tahəfo? Tahərai irəha ia nau me səkɨmaha me uə rekəm?” ");
INSERT INTO tnk_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nənə irəha riti rərai iərmama sə ramo tukwini nari m pris asori anan mərai raka nɨkare nɨfreɡɨn mwatuk. ");
INSERT INTO tnk_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Mətə Iesu rɨni mə, “Nəmwhen nə!” Nənə mɨrapi nɨfreɡɨn, momasan. ");
INSERT INTO tnk_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Iesu rəɡkiari m pris asori me, mɨne naruaɡən me nəha kamhətui tɨ nimwə səvəi Kumwesən, mɨne nəmə asori me səvəi nəkur Isrel səməme həuvehe mə tuhəkwtəmhiri in. In rɨni mə, “Rəfo hiaməuvehi nau me mɨne nɨpərpəri nei me mamhəuvehe mə tihəkwtəmhiri iou iamɨnhi irə? Nətərɨɡien səkɨmiaha rɨnuə iou rakres riti uə? ");
INSERT INTO tnk_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nərineiv m neis mɨne kɨtaha miou samarə ia nəkwai nimwə səvəi Kumwesən. Rəfo hiəpwəh nəkwtəmhiriien iou ia rəɡɨmiaha ia nəpɨn nəha? Mətə in i nəpɨn səkɨmiaha, nəpɨn nɨskaiien səvəi nəpitəvien trərɨmənu ia kɨmiaha.” ");
INSERT INTO tnk_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ia nəpɨn nəha nərmama me nəha həkwtəmhiri Iesu, mhəiri mhəuvən ia nimwə səvəi pris asori anan. Pita rakurirə, mətə rəpwəh nevənien ipaka. ");
INSERT INTO tnk_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nəpɨn irəha hərkwumen pam napw riti ia nɨkare nimwə nəha, mhəkure pəri, Pita raməkure irəha mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nənə pran riti sə ramo tukwini nari rətoni in raməkure ipaka tɨ napw. Ramətə amasan in, nənə mɨni mə, “Iəmə i in mwi rɨnamavən pəri irau Iesu.” ");
INSERT INTO tnk_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Mətə Pita rɨni mə, “Rekəm, prən i. Iakreirei iəmə nəha.” ");
INSERT INTO tnk_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nəpɨn ouihi a rukurau, nənə iərmama riti mwi rətoni in mɨni mə, “Ik riti mwi ia nirəha.” Mətə Pita rɨni mə, “Iəmə i, rɨpko mhə iou.” ");
INSERT INTO tnk_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nəpɨn ouihi a rəmwhen ia aoa riti rukurau, nənə iərmama riti mwi rəɡkiari skai, mɨni mə, “Nɨpərhienien i. Iəmə i in mwi rɨnamavən pəri irau Iesu. Kwa in mwi iəmə Kalili nəha.” ");
INSERT INTO tnk_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Mətə Pita rɨni mə, “Iəmə i, iakreirei nəfe i iakaməɡkiari irə.” Təkwtəkwuni a mwi, nəpɨn raməɡkiari ihi, rəiə rakaka. ");
INSERT INTO tnk_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nənə Iərɨmənu səkɨtaha ruvsini, məti pen mətə Pita. Nənə Pita rerɨn rɨrhi nəɡkiariien i səvəi Iərɨmənu səkɨtaha. Rɨməni pen tukwe in mə, “Ia nəpɨn a i kurirə rəiə rakaka, tikɨni m kahar mə ikreirei iou.” ");
INSERT INTO tnk_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nənə Pita rier mevən iruə mɨrapi nasəkien. ");
INSERT INTO tnk_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ia nəpɨn nəha nəmə me nəha səməme kamhərer tukuahaɡ Iesu, kamhəuəsi in, mamharɨs əkenhɨn irə. ");
INSERT INTO tnk_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Irəha housəman mwi nənimen, nənə mamhəres in mə, “Ni ro nəɡkiariien sə ruku pen tɨ Nənɨmwɨn mə sin ruəsi ik!” ");
INSERT INTO tnk_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nənə həni mwi nəɡkiariien me rɨpɨk mwi, mamhəni ərəha in irə. ");
INSERT INTO tnk_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nəpɨn ruvəran nəmə asori me səvəi nəkur Isrel mɨne pris asori me mɨne nahatən me səvəi Loa housəsɨmwɨn irəha me. Nənə nərmama me həiri Iesu, mhəuvən, mhərpwi irapw in ia nəmrɨnraha. Nənə nəmə asori me i həni mə, ");
INSERT INTO tnk_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Trɨni mɨnuə ik Kristo, ni pehe tukumaha i.” Mətə Iesu rɨni pen tɨ nirəha i mə, “Ko iakɨni pehe tukumiaha i, ko kɨmiaha hiəpkɨni mhə nɨpərhienien irə. ");
INSERT INTO tnk_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ko iakəres nəresien riti m kɨmiaha, ko hiəpkosərɨpɨn pehe mhə miou. ");
INSERT INTO tnk_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mətə nəha təkwtəkwuni mɨne mamevən iou, Iəməti Iərmama, takəkure ia nɨkare Kumwesən mwatuk sə in nɨskaiien səvənhi rasori.” ");
INSERT INTO tnk_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Mɨreɡi irəha pam həni mə, “Ro iamɨnhi irə ik Tɨni Kumwesən?” Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Hiaməni mə iou i in i.” ");
INSERT INTO tnk_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Mɨreɡi həni mə, “Kɨtaha tsətui mwi iərmama riti mwi mə trɨni pui in tɨ nəfe? Səuvəreɡi raka mə in rɨni ərəha Kumwesən. Ruku pen atukwatukw ia tərhun.” ");
INSERT INTO tnk_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ia nəpɨn nəha nərmama pam ia kusen nəha həskəmter, mhəiri Iesu, mhəuvən, mhərer ia nəmri Paelat. ");
INSERT INTO tnk_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Nəpɨn kamhərer ia nəmri Paelat, həni ərəha Iesu i mə, “Kɨmaha iahətoni iəmə i ramiri əpə iti kɨmaha nəkur Isrel, mamɨnise kɨmaha mə tahəpwəh nərəku penien nəmri takis m Kiɡ Sisa. In rani mwi mə in Kristo, iərmama sə trərɨmənu ia kɨmaha.” ");
INSERT INTO tnk_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Mɨreɡi Paelat rəres Iesu i mə, “Ik kiɡ səvəi nəkur Isrel?” Mɨreɡi Iesu rɨni pen tukwe in mə, “Ik ikani.” ");
INSERT INTO tnk_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nənə Paelat rɨni pen tɨ pris asori me mɨne nərmama me pam nəha mə, “Iakətə iamɨnhi irə mə nərəhaien riwən ia iəmə i.” ");
INSERT INTO tnk_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mətə irəha həɡkiari skai, mhəni mə, “Mətə iəmə i ramahatən nərmama me pam ia tənə Jutia, mamo irəha haməvisə mɨnraha me. In rɨno stat fwe ia tənə Kalili muvehe meste nari ia kwopun i.” ");
INSERT INTO tnk_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nəpɨn Paelat rɨreɡi nəɡkiariien nəha, rəres mə, “Iəmə i in iəmə Kalili uə rekəm?” ");
INSERT INTO tnk_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nənə nəpɨn Paelat rɨreɡi mə Iesu ruku pen ia kwopun nəha Herot ramərɨmənu ikɨn, rərhi pen in revən tukwe, tɨ nəri nə mə ia nəpɨn nəha Herot mwi fwe Jerusalem. ");
INSERT INTO tnk_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nəpɨn Herot rətə Iesu, rerɨn raɡien pɨk. Tui kwopti rokeikei mə trətoni, tɨ nəri nə mə ramreɡi kani nəɡhɨn, nənə mokeikei mwi mə trətoni Iesu ro nɨmtətien riti. ");
INSERT INTO tnk_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ro pen Herot rəres Iesu nəresien me rɨpɨk, mətə Iesu rɨpkɨni mhə nəɡkiariien riti. ");
INSERT INTO tnk_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ia nəpɨn nəha pris asori me mɨne nahatən me səvəi Loa həskəmter, mamhəɡkiari skai, mamhəni ərəha Iesu. ");
INSERT INTO tnk_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herot mɨne naruaɡən me səvənhi kamhətə ərəha in, mamharɨs əkenhɨn irə. Nənə Herot rɨni nəkwan mə irəha tuharkahu pen karkahu amasan riti min. Nəpɨn hənarkahu pen raka min, Herot rərhi pen in rɨrərɨɡ mevən tɨ Paelat. ");
INSERT INTO tnk_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ia nəpɨn nəha Herot mɨne Paelat krouvehe rouəkwein irau me mə iou riti. Mətə kupwən krouəmwəki irau me. ");
INSERT INTO tnk_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Paelat rousəsɨmwɨn pris asori me mɨne nəmə asori me səvəi nəkur Isrel ");
INSERT INTO tnk_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","mɨni pen tɨ nirəha i mə, “Kɨmiaha hiəməuvehi iəmə i, mhəuvehe, mhərpwi ia nənimek, mamhəni mə ramiri raka nərmama ia suatuk atukwatukw. Iakɨnəkiri raka noien səvənhi ia nəmrɨmiaha, mətə iapkətoni mhə nari riti ro rərəha rəmwhen nəɡkiariien me nəha kɨmiaha hiaməni, mamhəuəsi in irə. ");
INSERT INTO tnk_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herot mwi rɨpkətoni mhə nari riti ro rərəha. Ro pen rərhi pehe in rɨrərɨɡ mwi muvehe tukutaha. Hətə ro! Iəmə i rɨpko mhə nari riti sə rəmwhen mə tukousi əpune in tukwe. ");
INSERT INTO tnk_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ro iamɨnhi irə takərisi in, nənə məseni in rier ia kalapus mamevən.” ");
INSERT INTO tnk_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Mətə nərmama me nəha irəha pam həkwein əpwəmwɨs mə, “Uvehi irapw iəmə nə məseni Parapas rier ia kalapus tukumaha.” ");
INSERT INTO tnk_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Iəmə nəha Parapas raməmak ia kalapus tɨ nəri nə mə rɨmərkwumen naruaɡənien riti ia taon nəha Jerusalem, nənə mousi əpune mwi iərmama.) ");
INSERT INTO tnk_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Paelat rarə məɡkiari mwi mɨnraha tɨ nəri nə mə rokeikei mə trəseni Iesu rier ia kalapus mamevən. ");
INSERT INTO tnk_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mətə irəha kamhəkwein əpwəmwɨs mə, “Ərui tərini pen in ia nei kamarkuaui! Ərui tərini pen in ia nei kamarkuaui!” ");
INSERT INTO tnk_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Nənə Paelat rarə məɡkiari sə ro kahar irə, mɨni pen tɨ nirəha i mə, “Tɨ nəfe? Nəfe nərəhaien in rɨno? Iakɨnətə raka in mə rɨpko mhə noien ərəha riti sə rəmwhen mə tukousi əpune in tukwe. Ro iamɨnhi irə takərisi in, nənə, məseni in rier ia kalapus mamevən.” ");
INSERT INTO tnk_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Mətə irəha haməmwur, mamhəkwein əpwəmwɨs, mamhəni mə tukaməkeikei kərui tərini pen Iesu ia nei kamarkuaui. Irəha həkwein əpwəmwɨs iamɨnha irə mamhəuvən meste ");
INSERT INTO tnk_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Paelat rɨni mə tro nəkwanraha. ");
INSERT INTO tnk_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Iəmə nəha Parapas sə kɨməuvehi puvnimwə in ia kalapus tɨ naruaɡənien mɨne nousi əpuneien iərmama Paelat rəseni in rier ia kalapus mamevən, mətə ruvei pen Iesu ia rəɡi naruaɡən me səvənhi mə irəha tuho irə rəmwhen ia nəmə asori me səvəi nəkur Isrel hokeikei. ");
INSERT INTO tnk_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Naruaɡən me nəha həiri Iesu, mhəier ia taon, mhətoni iəmə Saerin riti nəɡhɨn nə Saemon. Ruku pen ia kwopun riti iruə mauvehe ia taon. Irəha həkwtəmhiri in, mhəmri pen nei kamarkuaui səvəi Iesu ia nuran, nənə mhəkeikei min mə trəvrani mukurirə Iesu. ");
INSERT INTO tnk_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nərmama me həpɨk kamhəkurirə Iesu. Nɨpran me həpɨk irəha mɨnraha kamhapi, mamhasək asori tukwe. ");
INSERT INTO tnk_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Mətə Iesu ruvsini, məti pen mətə irəha, mɨni mə, “Nɨprən Jerusalem me. Kɨmiaha tihəpwəh nasəkien tukw iou, mətə tihasək tukumiaha me mɨne nɨpwnətɨmiaha me. ");
INSERT INTO tnk_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nəpɨn riti sə rauvehe trərəha anan. Tukɨni iamɨnhi irə mə nɨpran me səməme həpkəkwəhakwen mhə, mhəpkuvei pen raka mhə kənunu m iəkunouihi, irəha həukurən naɡienien. ");
INSERT INTO tnk_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ia nəpɨn nəha nərmama tuhəni pen tɨ təkuər me mə ‘Həkure tərini kɨmaha’ mɨne nəpatu me ‘Housəman kɨmaha.’ ");
INSERT INTO tnk_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Mə nərmama kamho narimnari me i nəpɨn nei ramerə ihi tukəfo irə nəpɨn nei ruvehe mɨmhiə?” ");
INSERT INTO tnk_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nənə naruaɡən me kamhəiri iəmə ərəha mi kəru, mhəier mə tuhousi əpune irau irəhar Iesu. ");
INSERT INTO tnk_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Irəha həuvehe ia kwopun nəha kani mə Kerhə səvəi Iərmama. Ia kwopun nəha hərui tərini pen Iesu ia nei kamarkuaui, mhərui tərini pen mwi iəmə ərəha mi nəha ia nei kamarkuaui, riti ia nɨkare Iesu mwatuk, riti ia nɨkaren mour. ");
INSERT INTO tnk_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nənə Iesu rɨni mə, “Tata. Tikəpwəh nərpwɨnien tai noien ərəha səvənraha tɨ nəri nə mə həreirei nəfe i kamho.” Nənə irəha həuai kɨrkɨri tɨnari me səvənhi, mhəuini nari riti sə trahatən pen sin truvehi nəfe tɨnari səvənhi. ");
INSERT INTO tnk_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nərmama ia kwopun nəha kamhərer mamhəspau ia Iesu, mətə nəmə asori me səvəi nəkur Isrel kamharɨs əkenhɨn irə, mamhəni mhənuə, “In rɨməuvehimɨru nərmama me həpɨk. Trɨni mɨnuə in Kristo pərhien sə Kumwesən ruvərfi raka in, ramasan mə ruvehimɨru atukw a in.” ");
INSERT INTO tnk_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Naruaɡən me irəha mwi kamharɨs əkenhɨn irə, mamhəuvehe ipaka tukwe, mamhəmwur mə tuhəuvei pen waen sə rəfiə min, ");
INSERT INTO tnk_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","mamhəni mə, “Trɨni mɨnuə ik kiɡ səvəi nəkur Isrel pərhien, uvehimɨru atukw ik!” ");
INSERT INTO tnk_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ia kənkapwə irənhə irə nəkukuə riti kɨmərai mə Iesu tremhə tɨ nəfe. Rɨni mə: In I KiG SəvəI Nəkur Isrel ");
INSERT INTO tnk_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Iəmə ərəha mi nəha sə krouəɡher ia kwopun nəha riti rɨni ərəha Iesu i, mɨni mə, “Ik Kristo uə rekəm? Uvehimɨru atukw ik mɨne kɨmrau!” ");
INSERT INTO tnk_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mətə in riti rɨnise in, mɨni mə, “Rosi ipkehekɨr mhə Kumwesən uə? Kwa kɨməuvei pehe nərpwɨnien mik rəmwhen a mwi irə. ");
INSERT INTO tnk_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ratukwatukw a mə kamousi əpune krau iamɨnhi. In i tai noien ərəha səkrau. Mətə iəmə i rɨpko mhə nari riti rərəha.” ");
INSERT INTO tnk_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nənə iəmə nəha rarə mɨni mwi mǝ, “Iesu. Rerɨm tramrhi iou nəpɨn tikərɨmənu ia nɨtətə səim.” ");
INSERT INTO tnk_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Mɨreɡi Iesu rɨni pen tukwe in mə, “Iakani nɨpərhienien tukw ik i. Ipwet tikarə krau mik ia kwopun amasan nəha Parataes.” ");
INSERT INTO tnk_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Ipaka tɨ kurkwai nəpɨn ia ran nukuraanien səvəi meri riwən. Nəpitəvien ruvehe mousəman kwopun me pam ia tənə nəha meste aoa kahar rukurau. Ia nəpɨn nəha tɨnari sə rəɡher tukuahaɡ rum sə ro ikinan anan fwe ia nəkwai nimwə səvəi Kumwesən reitehi nɨpərɨn kəru. ");
INSERT INTO tnk_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nənə Iesu rəkwein əpwəmwɨs mɨni mə, “Tata. Iakəmri pehe nənɨmwɨk ia rəɡɨm.” Rɨni nəɡkiariien nəha, nənə muvehi neiahaɡien səvənhi sampam, memhə. ");
INSERT INTO tnk_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Iaruaɡən riti səvəi nəkur Rom nəha in rasori ia naruaɡən me irəha pam hantret. Nəpɨn rətoni Iesu mə rɨnəfemhə irə, rəɡnəɡɨni Kumwesən, mɨni mə, “Nɨpərhienien. Iəmə i in iəmə atukwatukw.” ");
INSERT INTO tnk_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nənə nərmama me pam səməme hənousəsɨmwɨn irəha me fwe ikɨn tɨ nəspauien ia nəri nəha kɨno ia Iesu, nəpɨn hətoni, hərərɨɡ pen imwənraha, mhəreɡi rərəha, mamhərui kwənpwenhɨnraha tukwe. ");
INSERT INTO tnk_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Nərmama me pam səməme həukurən Iesu, mɨne nɨpran me nəha səməme hənaməkurirə in fwe ia tənə Kalili, kamhərer isipwɨn, mamhəspau ia narimnari me nəha. ");
INSERT INTO tnk_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Iərmama riti nəɡhɨn nə Josef. Imwəni nə Aramatia taon riti səvəi nəkur Isrel. Josef in raməkure irəha nəmə asori me səvəi nəkur Isrel nəpɨn housəsɨmwɨn irəha me. Noien səvənhi ramasan matukwatukw. Nəpɨn nəmə asori me hənərai sɨmwɨn mə tukousi əpune Iesu, Josef rɨpkəseni mhə. Ia nəpɨn me in rameitenhi mə trətoni nɨtətə sə Kumwesən ramərɨmənu irə ruvehe. ");
INSERT INTO tnk_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Josef revən tɨ Paelat, məres mə ko rəseni in ruvehi nɨpwrai Iesu. ");
INSERT INTO tnk_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nəpɨn Paelat rəseni, Josef revən, muvehi raka nɨpwrai Iesu ia nei kamarkuaui, nənə muveɡi ia tɨnari kani mə linen, mevən məmri pen ia nɨpəɡi kəruəterei sə kɨnərai ərori raka, kɨpkəmri pen raka mhə nɨpwrai iərmama riti ikɨn. ");
INSERT INTO tnk_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","In i nəpɨn kaməpnəpenə irə tɨ Sapat, Sapat ruvəuvehe ipaka. ");
INSERT INTO tnk_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nɨpran me nəha səməme həməier ia tənə Kalili, mhəkurirə Iesu mhəuvehe, irəha həkurirə Josef i, nənə mhətoni nɨpəɡi kəruəterei nəha mɨne Josef rəfəmri pen nɨpwrai Iesu irə. ");
INSERT INTO tnk_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nəpɨn hətoni pam, hərərɨɡ, mhəpnəpenə nɨmwai nari me nepwɨn sə nɨpekɨnraha rapein amasan, mhəpnəpenə mwi senta me nepwɨn. Nənə ia Sapat hapwɨs rəmwhen sə Loa rɨməni. ");
INSERT INTO tnk_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ia Sante, nəpnəpɨn anan, nɨpran me nəha həuvehi nɨmwai nari me səməme hənəpnəpenə raka ia nirəha nɨpekɨnraha rapein amasan, mhəuvehi mhəuvən ia nɨpəɡi kəruəterei nəha kɨnərkwafə nɨpwrai Iesu ikɨn, ");
INSERT INTO tnk_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","nənə mhətoni kəruəterei asori nəha kɨnərəpinhə pen ia tərhui nɨpəɡ kɨnəsəkwusəkwu raka i. ");
INSERT INTO tnk_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Mətə nəpɨn hasu puvnimwə ia nɨpəɡ, həpkətoni mhə nɨpwrai Iesu Iərɨmənu səkɨtaha. ");
INSERT INTO tnk_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nəri nəha ro nətərɨɡien səvənraha rəvsausɨni pɨk. Nəpɨn kamhərer mamhətərɨɡ tukwe, təkwtəkwuni a mwi iərmama kəru krouier irapw tɨ nirəha. Tɨnari səvənrau raməhiapw. ");
INSERT INTO tnk_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Irəha hətoni həhekɨr mhənɨmwi irapw nənimenraha ia tɨprənə. Nənə iərmama mi nəha krouni pen tɨ nirəha i mə, “Rəfo kɨmiaha hiamətui iərmama sə rɨmɨru ia kwopun i kamərkwafə nɨpwrai nərmama sə hemhə ikɨn? ");
INSERT INTO tnk_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","In riwən i, mətə in rɨnətui mwi. Rerɨmiaha tramrhi nəɡkiariien i in rɨməni pehe tukumiaha i nəpɨn rɨnamarə ihi fwe ia tənə Kalili. ");
INSERT INTO tnk_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","In rɨməni mə, ‘Irəha tuhaməkeikei mhəuvei pen iou, Iəməti Iərmama, ia rəɡi nəmə ərəha me. Nənə nəmə ərəha me nəha tuhərui tərini pen iou ia nei kamarkuaui. Takemhə, mətə nəpɨn sə ro kahar irə takətui mwi.’” ");
INSERT INTO tnk_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Nənə nɨpran me nəha rerɨnraha rɨrhi mwi nəɡkiariien nəha səvənhi. ");
INSERT INTO tnk_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Hərərɨɡ ia nɨpəɡ, mhəuvən, mhətoni eleven nərmama me səvəi Iesu mɨne nepwɨn mwi, həni pen narimnari me i tɨ nirəha. ");
INSERT INTO tnk_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nɨpran me nəha səməme həni irapw narimnari me i tɨ aposol me səvəi Iesu irəha nəha Meri Maktala, mɨne Joana, mɨne Meri mama səvəi Jemes, mɨne nɨpran me nepwɨn mwi irəha mɨnrahar. ");
INSERT INTO tnk_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mətə aposol me rerɨnraha rɨrhi mə rosi nəɡkiariien nəha səvənraha ro nəri auər a irə. Irəha həpkɨni mhə nɨpərhienien irə. ");
INSERT INTO tnk_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mətə Pita rɨskəmter, maiu, mevən ia nɨpəɡi kəruəterei nəha kɨnərkwafə nɨpwrai Iesu ikɨn, mərpəsuk, məti puvnimwə, mətoni tɨnari me nəha linen sə kɨməveɡi nɨpwrai Iesu irə ramrɨmər, mətə nari riti mwi riwən. Nənə in rəpwəh kwopun nəha mamevən mərkərinari ia nəfe rɨnətoni. ");
INSERT INTO tnk_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ia nəpɨn a mwi nəha iərmama kəru səvəi Iesu krauevən ia rukwənu riti nəɡhɨn nə Emeas. Rukwənu nəha ipaka tɨ Jerusalem kavən rəmwhen ia kilometa irəha pam eleven. ");
INSERT INTO tnk_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Irau krauəɡkiari pəri ia narimnari me nəha kɨno. ");
INSERT INTO tnk_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nəpɨn nəha krauəɡkiari pəri irə, Iesu ruvehe ipaka, mamavən irəhar mɨnrau, ");
INSERT INTO tnk_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","mətə nari riti ruveɡi nətərɨɡien səvənrau, kroureirei mə Iesu nəha. ");
INSERT INTO tnk_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nənə Iesu rɨni pen tɨ nirau i mə, “Nəfe i irauavən rauni pen tukumirau me i?” Nənə krouərer, nənimenrau rɨpkaɡien mhə. ");
INSERT INTO tnk_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Irau riti, nəɡhɨn nə Kleopas, rɨni pen tukwe in mə, “Rosi ik əpa ia nərmama me səməme kamhavən fwe ia Jerusalem ikreirei narimnari me nəha kɨno nərineiv m neis mɨne?” ");
INSERT INTO tnk_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Mɨreɡi Iesu rɨni pen tɨ nirau i mə, “Nəfe narimnari?” Mɨreɡi krouni pen tukwe in mə, “Narimnari me nəha kɨno ia Iesu, iəmə Nasaret. Iəmə nəha in profet riti. Ia nəmri Kumwesən mɨne ia nəmri nərmama narimnari me sə in rɨno mɨne nəɡkiariien səvənhi ro nənɨmwɨn mɨskai. ");
INSERT INTO tnk_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pris asori me mɨne nəmə asori me səkɨtaha həməuvei pen in ia rəɡi nəkur Rom mə irəha tuhəni mə in traməkeikei memhə. Nənə irəha hərui tərini pen in ia nei kamarkuaui. ");
INSERT INTO tnk_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Mətə kɨmaha iahənəmri pen əknekɨn nətərɨɡien səkɨmaha irə mə in iərmama sə treivinari ia kɨtaha nəkur Isrel. Narimnari me nəha kɨno, mətə nari riti mwi, ipwet i nəpɨn sə ro kahar irə. ");
INSERT INTO tnk_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Riti mwi, nɨpran nepwɨn ia təmwen səkɨmaha ho nəmrɨmaha rier. Ia nəpnəpɨn anan həuvən fwe ia nɨpəɡ sə kɨnərkwafə iəmə nəha ikɨn, ");
INSERT INTO tnk_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","mətə həpkətoni mhə nɨpwran. Nəpɨn irəha hərərɨɡ pehe, həni mwi mə hənətoni aɡelo mi kəru krouier pehe tɨ nirəha, krouni mɨnuə in rɨnətui mwi ia nemhəien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nərmama nepwɨn ia təmwen səkɨmaha həuvən fwe ia nɨpəɡi kəruəterei nəha, nənə mhətoni rəmwhen atukwatukw mə nɨpran me nəha həməni, mətə həpkətoni mhə nɨpwrai iəmə nəha.” ");
INSERT INTO tnk_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Mɨreɡi Iesu rɨni pen tɨ nirau i mə, “Kwa rosi kɨmiaha hiəreirei nəɡkiariien me pam sə profet kupwən me həməni. Rəfo kɨmiaha hiamo tanpen ia rerɨmiaha, mhəpwəh nɨni akwauakwien nɨpərhienien irə? ");
INSERT INTO tnk_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kumwesən ruvəni raka mə iəmə nəha kani mə Kristo traməkeikei mɨreɡi nəmisəien me nəha kurirə revən muvehi nasoriien səvənhi.” ");
INSERT INTO tnk_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nənə Iesu rəusiəre pui pen amasan tɨ nirau i nɨpwrai nəɡkiariien me pam sə kɨmərai pen ia Nəkukuə Ikinan səməme haməɡkiari ia in. Ia nəɡkiariien səvənhi rəɡkiari ia nəkukuə səvəi Moses muvehe meste nəkukuə me səvəi profet me. ");
INSERT INTO tnk_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nəpɨn irəhar haruvehe ipaka tɨ rukwənu nəha irau krauevən ikɨn, Iesu ramo rəmwhen mə in trəpwəh irau mavən mamevən. ");
INSERT INTO tnk_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Mətə irau krouəkeikei min, rouni mə, “Samaro pəpɨm kɨtahar mik. Rɨnaməruarəv. Rɨpko mhə tui meri rivə.” Ro pen Iesu ruvnimwə irəhar mɨnrau mə tuamharo pəpɨm. ");
INSERT INTO tnk_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nəpɨn in rəkure mə trəni pəri nari irəhar mɨnrau, ruvehi bred, məfwaki mɨni vivi Kumwesən tukwe, məkwsen, muvei pen mɨnrau. ");
INSERT INTO tnk_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ia nəpɨn nəha nətərɨɡien səvənrau rəsevər, krɨnauətə rɨnaukurən mə Iesu nəha. Nənə təkwtəkwuni a mwi in riwən ia nəmrɨnrau. ");
INSERT INTO tnk_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nənə irau krouni pen tukunrau me i mə, “Pərhien. Nəpɨn raməɡkiari pehe m krau ia suatuk, maməusiəre pui pehe nɨpwrai nəɡkiariien me ia Nəkukuə Ikinan, nəɡkiariien səvənhi ramasan pɨk, mamo rerɨrau ramaɡien.” ");
INSERT INTO tnk_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nənə ia nəpɨn nəha krouəskəmter, rourərɨɡ rouevən fwe ia Jerusalem. Ia kwopun nəha krouətə nərmama me eleven səvəi Iesu mɨne nərmama nepwɨn mwi irəha mɨnraha hənousəsɨmwɨn raka irəha me, ");
INSERT INTO tnk_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","mamhəni mə, “Nɨpərhienien. Iərɨmənu səkɨtaha rɨnətui mwi. In ruvəier irapw raka tɨ Saemon.” ");
INSERT INTO tnk_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nənə iəmə mi nəha krouni irapw nəfe krɨnouətoni ia suatuk, rouni mwi krɨnəfo rouətoni sas ia Iesu nəpɨn in raməkwsen bred. ");
INSERT INTO tnk_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nəpɨn irau krauəɡkiari ihi ia nari m nari me nəha, təkwtəkwuni a mwi hətoni Iesu ramərer ia kurkwanraha, mɨni pen tɨ nirəha i mə, “Nəmərinuien trarə tukumiaha.” ");
INSERT INTO tnk_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Mətə irəha hərkərinari irə, mhehekɨr. Rerɨnraha rɨrhi mə kamhətoni nənɨmwi iərmama riti. ");
INSERT INTO tnk_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ro pen Iesu rɨni pen tɨ nirəha i mə, “Rəfo hiamhekɨr iamɨnhi irə? Rəfo nəresien me kamhəutə ia rerɨmiaha mamho kɨmiaha hiəpwəh nɨniien nɨpərhienien ia nirak? ");
INSERT INTO tnk_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Hətoni ro rəɡɨk mi mɨne nɨsuk mi. Kwa iou i. Hərapi iou, mhəreɡi, mhəukurən mə nusak i mɨne nɨkəkrik i. Mətə nənɨmwi iərmama nusan mɨne nɨkəkrin riwən.” ");
INSERT INTO tnk_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Iesu rɨni nəɡkiariien nəha, mɨsəni irapw rəɡɨn mi mɨne nɨsun mi tɨ nirəha hətoni. ");
INSERT INTO tnk_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nəpɨn hətoni nəmrɨnraha rier. Rerɨnraha raɡien. Mətə nahatətəien səvənraha ramərməru ihi. Iesu rɨni pen tɨ nirəha i mə, “Sənəmiaha i nəveɡɨnien uə rekəm?” ");
INSERT INTO tnk_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nənə irəha həuvei pen nɨpəri nəmu afə riti min. ");
INSERT INTO tnk_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","In ruvehi məni ia nəmrɨnraha. ");
INSERT INTO tnk_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nənə Iesu rɨni pen tɨ nirəha i mə, “Narimnari me i kamhesi pen nəɡkiariien me səiou sə iakɨməni pehe tukumiaha i fwe kupwən nəpɨn iakɨnamarə pəri ihi kɨtaha m kɨmiaha. Iakɨməni mɨnuə nəɡkiariien me pam nəha kɨmərai pen ia Loa səvəi Moses mɨne nəkukuə me səvəi profet kupwən me mɨne Ol Sam səməme kamhəɡkiari ia nirak tuhaməkeikei mhəuvehe mhəukuə.” ");
INSERT INTO tnk_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nənə in rəsevər ia nətərɨɡien səvənraha mə irəha tuhəukurən nɨpwrai nəɡkiariien me ia Nəkukuə Ikinan, ");
INSERT INTO tnk_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","rɨni pen tɨ nirəha i mə, “Nəɡkiariien me nəha kɨmərai pen ia Nəkukuə Ikinan həni iamɨnhi mə iou Kristo takaməkeikei mukupwən mɨreɡi nəmisəien, memhə, nənə ia nəpɨn sə ro kahar irə iakətui mwi. ");
INSERT INTO tnk_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Tukəvisau irapw mə nərmama tuhaməkeikei mhəpwəh noien ərəha me, mhahatətə ia nirak, nənə Kumwesən trəpwəh nərpwɨnien noien ərəha me səvənraha. Tukukupwən kəvisau irapw nəɡkiariien i ia Jerusalem kurirə revən tɨ nərmama ia tənəmtənə me pam. ");
INSERT INTO tnk_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kɨmiaha nəha hiənətoni narimnari me i ia nənimemiaha. ");
INSERT INTO tnk_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Həreɡi ro! Iou takərhi pehe Nənɨmwɨn Ikinan reiwaiu pehe tukumiaha rəmwhen ia Tata səiou rɨno raka promes irə. Mətə kɨmiaha tihəpwəh nierien ia taon i meste nɨskaiien nəha trukrutə ia neiai meiwaiu pehe. Kumwesən trarkahu pehe m kɨmiaha.” ");
INSERT INTO tnk_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nənə Iesu riri irəha mhəier mhəuvən mheste nari fwe rukwənu nəha Petani. Ia kwopun nəha in ruvehi utə rəɡɨn mi, məkwein amasan ia nirəha. ");
INSERT INTO tnk_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nəpɨn raməkwein amasan ia nirəha, raraka ia nirəha, nənə kuvehi utə in revən fwe ia neiai. ");
INSERT INTO tnk_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Irəha hənɨmwi nukurhunraha, mhəuvei pen nɨsiaiien səvənraha min. Nəpɨn hərərɨɡ mhəuvən fwe ia Jerusalem, rerɨnraha raɡien pɨk. ");
INSERT INTO tnk_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ia nəpɨn me kamhəuvən ia nimwə səvəi Kumwesən, mamhəɡnəɡɨni in. ");
INSERT INTO tnk_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Fwe tui, nəpɨn tɨprənə ramiwən ihi, Nəɡkiariien səvəi Kumwesən rɨnarə raka. Nəɡkiariien nəha ramarə irau Kumwesən. Nəɡkiariien nəha in Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","In rɨnarə raka irau Kumwesən fwe tui nəpɨn tɨprənə ramiwən ihi. ");
INSERT INTO tnk_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Narimnari me pam həuku pen irə mharə. Narimnari me pam səməme kamharə riti riwən rɨpkuku pen mhə irə marə. ");
INSERT INTO tnk_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nəɡkiariien nəha in nukune nɨmɨruien. Nɨmɨruien nəha in nukuraanien sə raməhiəpwɨn nərmama. ");
INSERT INTO tnk_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nukuraanien nəha raməhiapw ia nəpitəvien, nəpitəvien ko rɨpkousəman mhə. ");
INSERT INTO tnk_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Iərman riti Kumwesən rərhi pehe i nəɡhɨn nə Jon. ");
INSERT INTO tnk_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","In ruvehe mə trərer irapw məɡkiari ia nukuraanien nəha pwəh nərmama həreɡi nəɡkiariien səvənhi, nənə mhəni nɨpərhienien irə. ");
INSERT INTO tnk_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Rɨpko mhə Jon in nukuraanien nəha, mətə ruvehe mə trərer irapw məɡkiari irə, ");
INSERT INTO tnk_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","mɨni mə nukuraanien pərhien sə raməhiəpwɨn nərmama me pam na truvehe ia tɨprənə i. ");
INSERT INTO tnk_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nɨpərhienien nukuraanien nəha ruvehe ia tɨprənə i. In nəha Nəɡkiariien nəha tɨprənə i mɨne nərmama me pam həuku pen irə mharə, mətə nəpɨn rier pehe irə irəha həreirei mə in sin. ");
INSERT INTO tnk_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","In ruvehe imwəni atukwatukw, mətə nəkur imwəni me həpkəsevər mhə ia rerɨnraha tukwe. ");
INSERT INTO tnk_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mətə nərmama me səməme həsevər ia rerɨnraha tukwe, in ruvei pen nasoriien mɨnraha mə irəha nɨpwnəti Kumwesən me. In ruvei pen nasoriien nəha m nərmama me pam səməme kamhəni nɨpərhienien ia nəɡhɨn. ");
INSERT INTO tnk_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Mətə nəpɨn həuvehe mho nɨpwnəti Kumwesən me ia nirəha, irəha həpkətui pehe mhə ia nɨte tata mɨne mama, uə ia nokeikeiien səvəi nɨpwranrau, uə ia nətərɨɡien səvəi iərman riti, rekəm. Kumwesən əpa ruvei pen nɨmɨruien vi mɨnraha ro irəha həuvehe nɨpwnətɨn me. ");
INSERT INTO tnk_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nəɡkiariien səvəi Kumwesən ruvehe mo iərmama i nɨpwran rəmwhen ia nɨpwrataha rarə ouihi a kɨmaha min. Kɨmaha iahənətoni nasoriien səvənhi, nasoriien sə in rauvehi tɨ nəri nə mə in Tɨni Kumwesən anan kuatia. Iahənətoni mə rerɨn rukuər ia namasanien mɨne nɨpərhienien. ");
INSERT INTO tnk_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon rərer irapw məɡkiari irə, məkwein əpwəmwɨs, mɨni mə, “Iəmə i in i iəmə sə iakɨnəɡkiari irə nəpɨn iakɨni mə, ‘Iəmə sə trukurirə pehe iou, in rasori ia nirak, tɨ nəri nə mə nəpɨn iapkətui pehe mhə ihi, mətə in rɨnarə raka.’” ");
INSERT INTO tnk_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nənə tɨ nəri nə mə rerɨn rukuər ia namasanien mɨne nɨpərhienien, nəpɨn me kɨtaha pam saməuvehi narimnari amasan me raku pen tukwe. ");
INSERT INTO tnk_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Loa sə Kumwesən ruvei pehe ruku pen tɨ Moses, mətə namasanien mɨne nɨpərhienien ruku pen tɨ Iesu Kristo. ");
INSERT INTO tnk_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Iərmama riti rɨpkətoni raka mhə Kumwesən, mətə Tɨni Kumwesən anan kuatia in Kumwesən. Ia nəpɨn me in ipaka tɨ Tata səvənhi. In rɨno pui pehe Tata səvənhi m kɨtaha. ");
INSERT INTO tnk_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nəɡkiariien səvəi Jon ro iamɨnhi irə. Nəpɨn riti nəmə asori me səvəi nəkur Isrel hərhi pen pris me nepwɨn mɨne Livaet me nepwɨn həier ia Jerusalem mhəuvən mə tuhəres pen in mə, “Ik sin?” ");
INSERT INTO tnk_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nənə Jon rɨpkəpnapen mhə, mətə rəɡkiari, mo nukurənien i, mɨni mə, “Rɨpko mhə iou Kristo.” ");
INSERT INTO tnk_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Mɨreɡi irəha həres pen in mə, “Ik Elaeja?” Mɨreɡi in rɨni mə, “Rekəm. Rɨpko mhə iou Elaeja.” Mɨreɡi irəha həni mə, “Ik profet nəha kɨməni mə truvehe?” Mɨreɡi in rɨni mə, “Rekəm.” ");
INSERT INTO tnk_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ro iamɨnhi irə irəha həni pen tukwe in mə, “Ik sin? Kɨmaha tahaməkeikei mhəuvei pen nəɡkiariien m səməme hənərhi pehe kɨmaha. Ikəfni irə ia niram?” ");
INSERT INTO tnk_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Mɨreɡi Jon rɨni mə, “Iou iəmə i kamreɡi rerɨk ia kwopun akwesakwes ikɨn. Iakaməkwein əpwəmwɨs mə, ‘Kɨmiaha tihaməkeikei mhəpərhi suatuk səvəi Iərɨmənu səkɨtaha.’ Noien i iakamo ramesi pen nəɡkiariien səvəi Profet Aesea kupwən.” ");
INSERT INTO tnk_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nərmama me i səməme kɨnərhi pehe irəha nepwɨn Farisi me. ");
INSERT INTO tnk_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Irəha həres pen Jon i mə, “Rəfo ikamo paptaes ia nərmama, mətə rɨpko mhə ik Kristo uə Elaeja uə profet nəha Nəkukuə Ikinan rani mə truvehe?” ");
INSERT INTO tnk_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Mɨreɡi Jon rɨni pen tɨ nirəha i mə, “Iakamo paptaes ia kɨmiaha ia nui, mətə iərmama riti ramərer kurkwan ia kɨmiaha hiəreirei. ");
INSERT INTO tnk_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Iou iakɨməkupwən muvehe, iəmə nəha in trukurirə. Iapkəmwhen mhə mə takɨfi raka nəkwus ia put səvənhi.” ");
INSERT INTO tnk_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Narimnari me i həier pehe ia rukwənu Petani fwe nɨkare nui arɨs Jotan pen, kwopun Jon ramo paptaes ikɨn. ");
INSERT INTO tnk_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kɨni rakwakwi irə Jon rətoni Iesu ravən mauvehe. Nəpɨn rətoni, rɨni mə, “Hətə ro in i kwəti sipsip səvəi Kumwesən. In truvehi raka noien ərəha me səvəi nərmama me ia tɨprənə i. ");
INSERT INTO tnk_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iəmə i in i iakaməɡkiari irə nəpɨn iakɨməni mə, ‘Iəmə sə trukurirə pehe iou, in rasori ia nirak, tɨ nəri nə mə nəpɨn iapkətui pehe mhə ihi, mətə in rɨnarə raka.’ ");
INSERT INTO tnk_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Fwe kupwən iou iakreirei iəmə i, mətə iakɨməuvehe, mamo paptaes ia nui mə takətə sas in, nənə mahatən nəkur Isrel irə pwəh irəha hətoni mhəukurən.” ");
INSERT INTO tnk_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nənə Jon rarə mɨni irapw mwi mə, “Iou iakɨnətoni Nənɨmwɨn Ikinan ruku pen fwe ia neiai meiwaiu rəmwhen ia mak inhərɨpw muvehe məkure irə. ");
INSERT INTO tnk_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Fwe kupwən iou iakreirei iəmə i, mətə Iəmə sə rɨnərhi pehe iou mə tako paptaes ia nui rɨni pehe tukw iou i mə, ‘Ik tikətoni Nənɨmwɨn Ikinan reiwaiu məkure ia iərmama riti. Iərmama nəha in nəha tro paptaes ia Nənɨmwɨn Ikinan.’ ");
INSERT INTO tnk_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Iou Jon iakɨnətoni nəri i, nənə mani mɨnuə iəmə i in Tɨni Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kɨni rakwakwi irə, Jon ramərer ia kwopun a mwi nə irəhar iərmama kəru səvənhi. ");
INSERT INTO tnk_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nəpɨn rəti pen mətoni Iesu ramavən makurau, rɨni mə, “Hətə ro in i kwəti sipsip səvəi Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Iərmama mi nəha səvəi Jon kroureɡi in rɨni nəɡkiariien nəha, nənə kraukurirə ia Iesu. ");
INSERT INTO tnk_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Iesu ruvsini mətoni irau kraukurirə in, nənə rɨni pen tɨ nirau i mə, “Kɨmirau irouətui nəfe?” Mɨreɡi krouni pen tukwe in mə, “Rapai, ikamarə pəku?” (Nəɡkiariien nəha “Rapai” nɨpwran mə Iahatən.) ");
INSERT INTO tnk_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Mɨreɡi in rɨni pen tɨ nirau i mə, “Rouvehe rouətoni.” Ro pen irau krouevən, rouətoni kwopun in ramarə ikɨn. Nənə irau krouarə irəhar min ia nəpɨn nəha tɨ nəri nə mə rɨnaməruarəv ipaka meri rivə. ");
INSERT INTO tnk_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Irau riti rɨreɡi Jon rəɡkiari nənə rukurirə ia Iesu in nə Antru, piəvi Saemon Pita. ");
INSERT INTO tnk_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Nəri sə rukupwən mo in revən mətoni piəvni Saemon, nənə mɨni pen tukwe in mə, “Kɨmaha iahətoni Mesaea.” (Mesaea nɨpwran mə Kristo.) ");
INSERT INTO tnk_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nənə in riri Saemon mevən tɨ Iesu. Iesu rəti pen mətoni Saemon, mɨni mə, “Ik Saemon, tɨni Jon. Tukəkwein ik mə Kefas.” (Kefas nɨpwran mə Pita.) ");
INSERT INTO tnk_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kɨni rakwakwi irə, Iesu rokeikei mə trevən ia tənə Kalili. In rətui Filip, mətoni, mɨni pen tukwe in mə, “Kurirə iou.” ");
INSERT INTO tnk_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip nəha in iəmə Petsaeta, imwei Antru mɨne Pita. ");
INSERT INTO tnk_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Nənə Filip rətui Nataniel, mətoni, mɨni pen tukwe in mə, “Kɨmaha iahətoni iəmə i Moses rɨmərai ia nəkukuə səvəi Loa mɨne profet me mwi həmərai mamhəɡkiari irə. In iəmə Nasaret, tɨni Josef. Nəɡhɨn nə Iesu.” ");
INSERT INTO tnk_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Mɨreɡi Nataniel rɨni pen tukwe in mə, “Ko nari amasan riti ruku pen ia Nasaret uə?” Mɨreɡi Filip rɨni pen tukwe in mə, “Uvehe mətoni.” ");
INSERT INTO tnk_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nəpɨn Iesu rətoni Nataniel ravən muvehe, in rəɡkiari irə, mɨni mə, “Hətə ro. Iəmə Isrel pərhien i. Neikuəien riwən irə.” ");
INSERT INTO tnk_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Mɨreɡi Nataniel rɨni pen tukwe in mə, “Ikəfukurən iou?” Mɨreɡi Iesu rɨni mə, “Nəpɨn ikaməkure teɡɨn niemɨs, Filip rəpwəh ihi nəkweinien ik, iakɨnətə raka ik.” ");
INSERT INTO tnk_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Mɨreɡi Nataniel rɨni pen tukwe in mə, “Iahatən. Ik Tɨni Kumwesən pərhien. Ik pərhien kiɡ səvəi nəkur Isrel.” ");
INSERT INTO tnk_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Mɨreɡi Iesu rɨni mə, “Rəfo? Ikɨni nɨpərhienien ia nirak tɨ nəri nə mə iakɨni nəɡkiariien i mə ‘Iakɨnətə raka ik ikaməkure teɡɨn niemɨs’? Ik tikətoni narimnari me nepwɨn mwi hasori ia səməme nəha.” ");
INSERT INTO tnk_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Iesu rarə mɨni pen mwi tukwe in mə, “Iakani nɨpərhienien tukumiaha i kɨmiaha tihətoni kəpuapen trəkwaɡ nənə naɡelo me səvəi Kumwesən tuhaməutə mamheiwaiu ia Iəməti Iərmama.” ");
INSERT INTO tnk_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kɨni neis irə nərmama nepwɨn ia rukwənu Kena ia tənə Kalili həiri pen vi a pran riti m iərman səvənhi, mharə mho mwi nəveɡɨnien asori riti mamhaɡien pəri irəha mɨnrau. Mama səvəi Iesu irəha mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Kɨnəkwein Iesu mɨne nərmama me səvənhi mə irəha mwi tuhəuvən mhani pəri nari irəha mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nəpɨn waen ruvəiwən, mama səvəi Iesu rɨni pen tukwe in mə, “Sənmwɨnraha waen ruvəiwən.” ");
INSERT INTO tnk_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Mɨreɡi Iesu rɨni pen tukwe in mə, “Prən i. Ikəfo mani pehe nəri i tukw iou? Nəpɨn səiou rɨpkuvehe mhə ihi.” ");
INSERT INTO tnk_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mɨreɡi mama səvənhi rɨni pen tɨ nərmama səməme kamho tukwini nari mə, “Kɨmiaha tihaməkeikei mho nəfe nəɡhɨn in trɨni pehe tukumiaha i.” ");
INSERT INTO tnk_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ia kwopun nəha nəri kamərəmɨn pen nui irə irəha pam sikis kɨno ia kəruəterei. Irəha kuatia kuatia rukurən nuvehiien eiti uə hantret twenti lita. Nui nəha səvəi nəkur Isrel kamhərkwerɨɡ irə.) ");
INSERT INTO tnk_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iesu rɨni pen tɨ nərmama me nəha kamho tukwini nari mə, “Kɨmiaha tihərəmɨn pen nui ia nəri kamərəmɨn pen nui ia nirəha.” Irəha hərəmɨn meste pehe rukuər. ");
INSERT INTO tnk_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Nənə Iesu rɨni pen tɨ nirəha i mə, “Nəha təkwtəkwuni kɨmiaha tihəkwəhi raka nepwɨn, mhəuvehi mhəuvən mhəuvei pen m iəmə asori səvəi nəveɡɨnien asori.” Ro pen irəha həuvehi mhəuvən. ");
INSERT INTO tnk_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nəpɨn iəmə asori səvəi nəveɡɨnien asori rənɨmwi əɡhan nui nəha, nui sə Iesu rɨno ruvehe mo waen i, in rɨreirei mə waen ruku pəku. (Mətə iotukwininari me səməme həkwəhi raka nui irəha həukurən.) Ro iamɨnhi irə iəmə asori səvəi nəveɡɨnien nəha rəkwein iərman sə rɨpkarə vi a irau pran səvənhi ruvehe, ");
INSERT INTO tnk_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","rɨni pen tukwe in mə, “Samarə kamo nəveɡɨnien asori iamɨnhi kukupwən kukwəhi raka waen sə ramasan pɨk kauvei pen m nərmama. Nənə nəpɨn nərmama me hənənɨmwi asori kwopti, kukwəhi raka sə rɨpkamasan pɨk mhə kauvei pen mɨnraha hənɨmwi. Mətə ik ikəpwəh nukwəhi rakaien waen sə ramasan pɨk meste nəha təkwtəkwuni.” ");
INSERT INTO tnk_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","In i nɨmtətien sə Iesu rukupwən mo ia rukwənu Kena ia tənə Kalili. Ia nɨmtətien nəha in rahatən pen nasoriien səvənhi. Nənə nərmama me səvənhi həni nɨpərhienien irə. ");
INSERT INTO tnk_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kurirə irə Iesu rewaiu pen fwe taon Kapaneam irəha mama səvənhi mɨne piəvni me mɨne nərmama me səvənhi. Nənə irəha harə nəpɨn ouihi a fwe ikɨn. ");
INSERT INTO tnk_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nəveɡɨnien asori səvəi nəkur Isrel kani mə Pasova rɨnauvehe ipaka. Iesu rutə pen fwe Jerusalem, ");
INSERT INTO tnk_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","mətoni nərmama nepwɨn ia nəkwai nimwə səvəi Kumwesən kamhəmri pen nəmri nari ia kau me mɨne sipsip me mɨne menu me. Nepwɨn kamhəkure mamhəvriwei mane. In rətoni irəha, ");
INSERT INTO tnk_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ruvehi nəkwus me, mo kwənkɨrkɨr irə, məkoui irapw irəha pam mɨne sipsip me mɨne kau me həier irapw ia nimwə nəha. In rətəɡi irapw mane səvəi nərmama kamhəvriwei i, muvsini tepol me səvənraha. ");
INSERT INTO tnk_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nənə səməme kamhəmri pen nəmri nari ia menu me, in rɨni pen tɨ nirəha i mə, “Kɨmiaha tihəuvehi nəri me i mharaka, mhəpwəh noien nimwə səvəi Tata səiou ro kwopun kauvehi nəmri nari ikɨn.” ");
INSERT INTO tnk_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ia nəpɨn nəha nərmama me səvənhi rerɨnraha rɨrhi nəɡkiariien i kɨmərai pen ia Nəkukuə Ikinan rɨni mə, “Iakokeikei pɨk nimwə səim. Nokeikeiien nəha rauək rəmwhen ia napw ia rerɨk.” ");
INSERT INTO tnk_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ro pen nəmə asori me səvəi nəkur Isrel həni pen tukwe in mə, “Sin rɨməuvei pehe nasoriien mik mə tiko narimnari me i? Nəfe nəha nɨmtətien tiko m kɨmaha pwəh iahətoni mhəukurən?” ");
INSERT INTO tnk_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Housi testesi nimwə i səvəi Kumwesən, nənə ia nəpɨn səro kahar irə takuvehi utə mwi.” ");
INSERT INTO tnk_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Mɨreɡi nəmə asori me səvəi nəkur Isrel həni mə, “Kwa nimwə i səvəi Kumwesən kuvrhəkɨn nuk irəha pam foti-sikis. Tikəfo muvehi utə mwi ia nəpɨn kahar?” ");
INSERT INTO tnk_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Mətə nimwə nəha səvəi Kumwesən Iesu raməɡkiari irə in nə nɨpwran. ");
INSERT INTO tnk_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ro iamɨnhi irə nəpɨn Iesu rətui mwi ia nemhəien səvənhi, nərmama me səvənhi rerɨnraha rɨrhi mə in rɨməni nəɡkiariien i, nənə irəha həni nɨpərhienien ia Nəkukuə Ikinan mɨne nəɡkiariien nəha Iesu rɨməni. ");
INSERT INTO tnk_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nəpɨn Iesu in fwe Jerusalem tɨ nəveɡɨnien asori nəha kani mə Pasova, nərmama həpɨk hətoni nɨmtətien me nəha in ramo, mhəni nɨpərhienien ia nəɡhɨn. ");
INSERT INTO tnk_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mətə Iesu rɨpkɨni mhə nɨpərhienien ia nirəha, mhəpwəh nɨni pamien rerɨn tɨ nirəha i, tɨ nəri nə mə in ruvəukurən raka nərmama me pam. ");
INSERT INTO tnk_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","In rɨpkətui mhə iərmama riti tro pui pen nətərɨɡien səvəi iərmama min, tɨ nəri nə mə in ruvəukurən raka nəfe ramarə ia reri iərmama. ");
INSERT INTO tnk_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Iəmə asori riti səvəi nəkur Isrel nəɡhɨn nə Nikotimas. In Farisi riti. ");
INSERT INTO tnk_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Iəmə i ruvehe tɨ Iesu ia nəpɨn, mɨni pen tukwe in mə, “Iahatən. Kɨmaha iahəukurən mə ik iahatən riti sə Kumwesən rərhi pehe ik. Iərmama riti riwən ko ro nɨmtətien me i səməme ikamo trɨni mɨnuə Kumwesən rɨpkarə mhə tukwe.” ");
INSERT INTO tnk_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Mɨreɡi Iesu rɨni pen tukwe in mə, “Iakani nɨpərhienien tukw ik i trɨni mɨnuə iərmama kɨpkukwəhi mhə mwi in, ko in rɨpkətə mhə nɨtətə sə Kumwesən ramərɨmənu irə.” ");
INSERT INTO tnk_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Mɨreɡi Nikotimas rɨni pen tukwe in mə, “Tukəfa kukwəhi mwi iərmama sə ruvəpwinari raka? Ko in revən mwi ia tɨpwi mama səvənhi mə tukukwəhi mwi in uə rekəm?” ");
INSERT INTO tnk_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Mɨreɡi Iesu rɨni mə, “Iakani nɨpərhienien tukw ik i trɨni mɨnuə iərmama kəpwəh nukwəhiien in ia nui mɨne Nənɨmwɨn, ko in rɨpkuvnimwə mhə ia nɨtətə sə Kumwesən ramərɨmənu irə. ");
INSERT INTO tnk_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nəri sə iərmama rukwəhi in iərmama. Nəri sə Nənɨmwɨn rukwəhi in nənɨmwɨn. ");
INSERT INTO tnk_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Tikəpwəh nərkəriien nari mə iakɨni pehe tukw ik i mə ‘Tukaməkeikei kukwəhi mwi ik.’ ");
INSERT INTO tnk_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nɨmətaɡi ravən mamevən ia kwopun pəku rokeikei mə trevən ikɨn. Kɨmiaha hiamreɡi rameikweikwi nɨmwai nari, mətə hiəreirei mə ruku pəku mauvəku. Nərmama me pam səməme Nənɨmwɨn rukwəhi irəha ho mwi iamɨnhi.” ");
INSERT INTO tnk_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Mɨreɡi Nikotimas rɨni pen tukwe in mə, “Tukəfo narimnari me i ruvehe mo iamɨnha irə?” ");
INSERT INTO tnk_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Mɨreɡi Iesu rɨni pen tukwe in mə, “Ik iahatən səvəi nəkur Isrel. Rəfo ikreirei narimnari me i? ");
INSERT INTO tnk_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Iakani nɨpərhienien tukw ik i kɨmaha iahaməni nəfe iahəukurən, mamhəɡkiari ia nəfe iahənətoni ia nəmrɨmaha, mətə kɨmiaha hiəpkɨni mhə nɨpərhienien ia nəɡkiariien səkɨmaha. ");
INSERT INTO tnk_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Iakɨnəɡkiari raka ia narimnari me ia tɨprənə i, mətə kɨmiaha hiəpkɨni mhə nɨpərhienien ia nəɡkiariien səiou. Ro iamɨnhi irə tihəfo mhəni nɨpərhienien ia nəɡkiariien səiou trɨni mɨnuə iakəɡkiari ia narimnari me ia neiai? ");
INSERT INTO tnk_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Iərmama riti riwən ruvəutə raka mevən ia neiai. Iəməti Iərmama in əpa ruku pen ia neiai meiwaiu. ");
INSERT INTO tnk_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Fwe kupwən Moses ruvehi utə snek riti kɨno ia aean nə pras ia kwopun akwesakwes ikɨn. Rəmwhen a mwi tukaməkeikei kuvehi utə Iəməti Iərmama ");
INSERT INTO tnk_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","mə iərmama sə rani nɨpərhienien irə truvehi nɨmɨruien rerɨn. ");
INSERT INTO tnk_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kumwesən rokeikei pɨk nərmama ia tɨprənə i, məriari pehe Tɨni anan kuatia mə nərmama me pam səməme tuhəni nɨpərhienien irə tuhəpkemhə mhə, mətə tuhəuvehi nɨmɨruien rerɨn. ");
INSERT INTO tnk_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kumwesən rɨpkərhi pehe mhə Tɨni ruvehe ia tɨprənə i mə trərpwɨn noien ərəha me səvəi nərmama, mətə in rərhi pehe Tɨni mə truvehimɨru irəha. ");
INSERT INTO tnk_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Iərmama sə rani nɨpərhienien ia Tɨni Kumwesən, Kumwesən trəpwəh nərpwɨnien noien ərəha me səvənhi. Mətə iərmama sə rɨpkɨni mhə nɨpərhienien irə, Kumwesən ruvəni raka mə in trərpwɨn noien ərəha me səvənhi tɨ nəri nə mə iərmama nəha rɨpkɨni mhə nɨpərhienien ia Tɨni anan kuatia. ");
INSERT INTO tnk_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kumwesən ruvəni raka mə in truvei pen nərpwɨnien m nərmama tɨ noien i iakani. Nukuraanien ruvəuvehe raka ia tɨprənə i, mətə nərmama həpkokeikei mhə nukuraanien, mhokeikei a nəpitəvien, tɨ nəri nə mə noien me səvənraha hərəha. ");
INSERT INTO tnk_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Iərmama sə ramo noien ərəha me rəmwəki nukuraanien. Ko in rɨpkuvehe mhə irə kamo nukuraanien nəha rəhiəpwɨn noien me səvənhi. ");
INSERT INTO tnk_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mətə iərmama sə ramo nɨpərhienien ruvehe ia nukuraanien mə tro nukurənien i mə noien me səvənhi in ramo tɨ nəri nə mə ramsiai Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kurirə ia nəri nəha, Iesu mɨne nərmama me səvənhi həuvən ia tənə Jutia. In ramarə ikɨn irəha mɨnraha, mamo paptaes ia nərmama. ");
INSERT INTO tnk_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon mwi ramo paptaes ia nərmama fwe Aenon kwopun riti ipaka tɨ Salim, tɨ nəri nə mə nui me həpɨk fwe ikɨn. Nərmama me kamhəuvehe tukwe, nənə in ramo paptaes ia nirəha. ");
INSERT INTO tnk_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Ia nəpɨn nəha kɨpkuvehi puvnimwə mhə ihi Jon ia kalapus.) ");
INSERT INTO tnk_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Nəpɨn riti nərmama nepwɨn səvəi Jon mɨne iəmə Isrel riti hənaməvisə mɨnraha me tɨ nəresien riti mə tuhəfərkwerɨɡ irə. ");
INSERT INTO tnk_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nənə irəha həuvehe tɨ Jon, mhəni pen tukwe in mə, “Iahatən. Rerɨm ramrhi iəmə nəha fwe kupwən kɨmirau min ia nɨkare nui arɨs Jotan pen, iəmə sə ikɨnərer irapw məɡkiari irə? Ətə ro. In ramo paptaes ia nərmama. Nərmama pam kamhəuvən tukwe.” ");
INSERT INTO tnk_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Mɨreɡi Jon rɨni mə, “Iərmama ko rɨpkuvehi atukw mhə nari riti, mətə nəfe nari in ruvehi Kumwesən traməkeikei muvei pen min. ");
INSERT INTO tnk_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kɨmiaha i hiəuvəreɡi raka iou iakɨməni iamɨnhi irə mə, ‘Rɨpko mhə iou Kristo, mətə Kumwesən rərhi pehe iou mə takukupwən ia Kristo muvehe.’ ");
INSERT INTO tnk_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nəpɨn kiri pen vi a pran riti m iərman səvənhi, prən nəha səvəi sin? Kwa səvəi iərman nəha! Mətə nəpɨn kamo nəveɡɨnien asori səvəi narə viien səvənrau, in riti ramərer ipaka, mamreɡi iərman nəha raməɡkiari, rerɨn raɡien pɨk tukwe. Ro iamɨnhi irə təkwtəkwuni iakamreɡi rerɨk ramaɡien pɨk. ");
INSERT INTO tnk_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Iərman nəha traməkeikei mutə masori, mətə iou takaməkeikei meiwaiu mouihi. ");
INSERT INTO tnk_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Iəmə sə ruku pen fwe irənhə rasori ia nərmama me pam. Iəmə sə ruku pen ia tɨprənə in səvəi tɨprənə, nənə raməɡkiari ia narimnari me səvəi tɨprənə. Mətə iəmə sə ruku pen ia neiai rasori ia nərmama me pam. ");
INSERT INTO tnk_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","In rani irapw nəfe rɨnətoni mɨreɡi, mətə iərmama riti riwən rɨni nɨpərhienien ia nəɡkiariien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mətə iərmama sə rɨni nɨpərhienien ia nəɡkiariien səvənhi ramahatən pen mə nəɡkiariien nəha Kumwesən rɨni ro nɨpərhienien. ");
INSERT INTO tnk_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Iəmə sə Kumwesən rɨnərhi pehe i rani irapw nəɡkiariien me səvəi Kumwesən, tɨ nəri nə mə Kumwesən rauvei pen Nənɨmwɨn Ikinan min rasori pɨk. ");
INSERT INTO tnk_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tata Kumwesən in rokeikei Tɨni, mɨnəmri pen raka narimnari me pam ia rəɡɨn. ");
INSERT INTO tnk_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Iərmama sə rani nɨpərhienien ia Tɨni Kumwesən nɨmɨruien rerɨn rɨnarə raka irə. Mətə iərmama sə rɨpko mhə nəkwai Tɨni Kumwesən, in trɨpkətə mhə nɨmɨruien ia nəpɨn riti, mətə niemaha səvəi Kumwesən raməmak rerɨn irə.” ");
INSERT INTO tnk_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Kəvisau pen m Farisi me mə Iesu ravi nərmama həpɨk həuvehe mho nərmama me səvənhi, nənə in ramo paptaes ia nirəha. Nərmama me nəha həpɨk mhəpi raka səməme Jon ravi irəha, mamo paptaes ia nirəha. ");
INSERT INTO tnk_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Mətə nɨpərhienien rɨpko mhə Iesu atukwatukw ramo paptaes ia nirəha, mətə nərmama səvənhi me a kamho.) ");
INSERT INTO tnk_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nəpɨn Iesu rukurən mə Farisi me həuvəreɡi raka nəɡkiariien nəha, in rəpwəh tənə Jutia, mɨnamevən mwi ia tənə Kalili. ");
INSERT INTO tnk_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ia suatuk səvənhi Iesu rɨreɡi mə traməkeikei məpi sɨmwɨn ia tənə Sameria. ");
INSERT INTO tnk_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ro iamɨnhi irə in ruvehe ia taon riti ia Sameria nəɡhɨn nə Saeka. Taon nəha ipaka tɨ kwopwi tɨprənə Jekop rɨməuvei pen m tɨni nəɡhɨn nə Josef. ");
INSERT INTO tnk_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Wel sə Jekop rɨneri fwe kupwən in nəha ia kwopun nəha. Nənə Iesu rɨreɡi rəpou pɨk tɨ navənien səvənhi, revən, maməkure ia nɨkare wel nəha. Ipaka tɨ kurkwai nəpɨn ia ran. ");
INSERT INTO tnk_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Nənə prən Sameria riti ruvehe mə trukwəhi nui. Iesu rɨni pen tukwe in mə, “Vei pehe nui riti miou iakənɨmwi.” ");
INSERT INTO tnk_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Nərmama me səvəi Iesu həuvavən fwe taon mə tuhəuvehi nəmri nəveɡɨnien.) ");
INSERT INTO tnk_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mɨreɡi prən Sameria i rɨni pen tukwe in mə, “Ik iəmə Isrel. Iou prən Sameria. Rəfo ikaməres pehe nui miou?” (Prən i rɨni iamɨnhi irə tɨ nəri nə mə nəkur Isrel mɨne nəkur Sameria ko həpkənɨmwi mhə nui ia kap kuatia.) ");
INSERT INTO tnk_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Iesu rɨni pen tɨ prən i mə, “Ikreirei nəfe nari Kumwesən rokeikei mə truvei pehe mik. Ikreirei mwi iou sə iakani pehe tukw ik i mɨnuə ‘Vei pehe nui riti miou iakənɨmwi.’ Kamo ikukurən ko ikəres iou nənə iakuvei pehe nuimɨru mik.” ");
INSERT INTO tnk_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mɨreɡi prən i rɨni pen tukwe in mə, “Iəmə asori. Teki nəri tikukwəhi nui irə riwən. Wel i rəmwhenɨmw. Nənə tikuvehi pəku nuimɨru nəha? ");
INSERT INTO tnk_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Rəfo? Ik iəmə asori məpi raka kaha kupwən səkɨtaha Jekop? In rɨməuvei pehe wel i m kɨtaha, mɨnamənɨmwi nui irə. Nɨpwnətɨn me mɨne kau me səvənhi irəha mwi hənamənɨmwi.” ");
INSERT INTO tnk_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Mɨreɡi Iesu rɨni pen tɨ prən i mə, “Iərmama sə rənɨmwi nui i trəkwakwa mwi, ");
INSERT INTO tnk_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","mətə iərmama sə trənɨmwi nui takuvei pen min trɨpkəkwakwa mhə mwi ia nəpɨn riti. Nui sə takuvei pen min trakwərkwər ia reri iərmama nəha rəmwhen ia nəmri nui riti mauvei pen nɨmɨruien rerɨn min.” ");
INSERT INTO tnk_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mɨreɡi prən i rɨni pen tukwe in mə, “Iəmə asori. Uvei pehe nui nəha miou pwəh iapkakwakwa mhə mwi, məpwəh nuveheien ia kwopun i mukwəhi nui!” ");
INSERT INTO tnk_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Mɨreɡi Iesu rɨni pen tɨ prən i mə, “Evən, məkwein səim iərman, rouvehe mwi ia kwopun i.” ");
INSERT INTO tnk_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mɨreɡi prən i rɨni pen tukwe in mə, “Səiou iərman riwən.” Mɨreɡi Iesu rɨni mə, “Ikani atukwatukw mə səim iərman riwən. ");
INSERT INTO tnk_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ikɨnesi pen raka nərman irəha pam krirum, nənə sə nəha ikamesi pen ipwet mɨne rɨpko mhə iərman atukwatukw səim. Nəri i ikɨni ro nɨpərhienien.” ");
INSERT INTO tnk_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Prən i rɨni pen tukwe in mə, “Iəmə asori. Iakətə ik mə ik profet riti. ");
INSERT INTO tnk_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Kaha kupwən me səkɨmaha nəkur Sameria kamhəfwaki pen m Kumwesən ia təkuər i, mətə kɨmiaha nəkur Isrel hiaməni mə Jerusalem kwopun atukwatukw nərmama tuhaməkeikei mhəfwaki pen m Kumwesən ikɨn.” ");
INSERT INTO tnk_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Mɨreɡi Iesu rɨni pen tukwe in mə, “Prən i. Ni nɨpərhienien ia nəɡkiariien səiou. Nəpɨn nəha rauvehe kɨmiaha tihəpwəh nəfwakiien m Tata Kumwesən ia təkuər i mɨne fwe Jerusalem. ");
INSERT INTO tnk_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kɨmiaha hiaməfwaki mhəreirei Kumwesən, mətə kɨmaha iahaməfwaki mhəukurən amasan in, tɨ nəri nə mə suatuk Kumwesən rauvehimɨru nərmama irə ruku pen ia kɨmaha nəkur Isrel. ");
INSERT INTO tnk_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nəpɨn riti nəha rauvehe, mətə ruvəuvehe raka. Ia nəpɨn nəha nərmama səməme kamhəfwaki pərhien tuhəfwaki m Tata Kumwesən ia nənɨmwɨn mɨne nɨpərhienien, tɨ nəri nə mə Tata Kumwesən ramətui nərmama səməme kamho iamɨnhi mə irəha tuhəfwaki pen min. ");
INSERT INTO tnk_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kumwesən in nənɨmwɨn, nənə nərmama me səməme kamhəfwaki pen min tuhaməkeikei mhəfwaki ia nənɨmwɨn mɨne nɨpərhienien.” ");
INSERT INTO tnk_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mɨreɡi prən i rɨni pen tukwe in mə, “Iakukurən mə Mesaea truvehe (iəmə sə kaməkwein in mə Kristo). Nəpɨn in truvehe, in trɨni pehe narimnari me pam tukutaha.” ");
INSERT INTO tnk_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Mɨreɡi Iesu rɨni pen tɨ prən i mə, “Kwa iou i iou iakaməɡkiari mik.” ");
INSERT INTO tnk_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Təkwtəkwuni a mwi nərmama me səvəi Iesu hərərɨɡ mwi, mhətoni Iesu raməɡkiari m pran riti. Hətoni hərkərinari irə, mətə irəha riti rɨpkɨni mhə mə, “Iakamətui nəfe?” uə “Ikaməɡkiari kɨmirau prən i tɨ nəfe?” ");
INSERT INTO tnk_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ro iamɨnhi irə prən nəha rəpwəh teki nəri rakwəhi nui irə, mevən ia taon, mɨni pen tɨ nərmama me fwe ikɨn mɨnuə, ");
INSERT INTO tnk_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Həuvehe, mhətoni iərmama riti sə rɨni pehe tukw iou i narimnari me pam sə iakɨno. Rosi iəmə i in Kristo uə?” ");
INSERT INTO tnk_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nənə irəha həier ia taon, mamhəuvehe tɨ Iesu. ");
INSERT INTO tnk_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ia nəpɨn nəha nərmama me səvəi Iesu kamhəni pen tukwe in mə, “Iahatən, əni nari.” ");
INSERT INTO tnk_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Mətə in rɨni pen tɨ nirəha i mə, “Sənak nəveɡɨnien sə takəni kɨmiaha hiəreirei.” ");
INSERT INTO tnk_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ro iamɨnhi irə nərmama me səvənhi həni pen tɨ nirəha me i mə, “Rəfo? Iərmama riti ruvəuvei pen raka nəveɡɨnien min uə?” ");
INSERT INTO tnk_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Sənak nəveɡɨnien in i. Takaməkeikei mo nəkwai Iəmə sə rɨnərhi pehe iou iakuvehe, mo sampam ia wok səvənhi. ");
INSERT INTO tnk_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Kɨmiaha hiəukurən nəɡkiariien i kamɨni rerɨn mə, ‘Məkwə kefə mwi nəha ikɨn kesi raka nukwai wit sə rɨmruə ia nəmhien.’ Mətə iakani pehe tukumiaha i həti pen ro wit ia nəmhien me. Nɨmwanraha me həuvəmhiə. Rɨno nəpɨn sə tukesi nukwanraha. ");
INSERT INTO tnk_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Iərmama sə ramesi nukwai wit, in ruvəuvehi raka nərəkuien səvənhi, mamousəsɨmwɨn nukwai wit me mə tuhəuvehi nɨmɨruien rerɨn. Ia noien nəha iərmama sə raməpwei wit mɨne iərmama sə ramesi nukwan irau trouaɡien pəri. ");
INSERT INTO tnk_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nəɡkiariien i kamɨni ro nɨpərhienien irə mə, ‘Iərmama əpə rəpwei wit, nənə iərməpə ramesi nukwan.’ ");
INSERT INTO tnk_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Iou iakərhi pen kɨmiaha mə tihəuvən mhesi nukwai wit me. Rɨpko mhə kɨmiaha hiənəpwei wit me nəha. Nərməpə hənəpwei, nənə təkwtəkwuni kɨmiaha tihəkurirə ia nirəha, mho pam nəfe irəha hənostat mho.” ");
INSERT INTO tnk_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nəkur Sameria həpɨk həni nɨpərhienien ia Iesu tɨ nəri nə mə həreɡi prən i rɨni ianhi irə mə, “In rɨni pehe tukw iou i narimnari me pam sə iakɨno.” ");
INSERT INTO tnk_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ro iamɨnhi irə, nəpɨn nəkur Sameria me nəha həuvehe tukwe, həres pen Iesu mə trarə irəha mɨnraha. Nənə in rarə ikɨn nəpɨn kəru. ");
INSERT INTO tnk_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kurirə irə nəkur Sameria həpɨk mwi həni nɨpərhienien ia Iesu tɨ nəri nə mə həreɡi nəɡkiariien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Irəha həni pen tɨ prən nəha mə, “Kupwən kɨmaha iahaməni nɨpərhienien ia iəmə i tɨ nəri nə mə iahəreɡi nəɡkiariien səim. Mətə təkwtəkwuni kɨmaha iahaməni nɨpərhienien irə tɨ nəri nə mə iahəreɡi atukwatukw nəɡkiariien səvənhi, nənə kɨmaha iahəukurən mə nɨpərhienien in iərmama sə rauvehimɨru nərmama ia tənəmtənə me.” ");
INSERT INTO tnk_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kɨni neis irə Iesu rəpwəh kwopun nəha, mamevən ia tənə Kalili, ");
INSERT INTO tnk_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","tɨ nəri nə mə fwe kupwən in atukwatukw rɨməni mə, “Profet riti nəkur imwəni me ko həpkɨsiai mhə in.” ");
INSERT INTO tnk_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ro iamɨnhi irə, nəpɨn in rapirapw ia tənə Kalili, nəkur Kalili me həsevər ia rerɨnraha tukwe tɨ nəri nə mə irəha mwi həmavən fwe Jerusalem ia nəpɨn səvəi nəveɡɨnien asori Pasova. Irəha hənətoni narimnari me pam in rɨno ia kwopun nəha. ");
INSERT INTO tnk_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ro iamɨnhi irə Iesu rapirapw ia tənə Kalili, mevən mwi ia rukwənu Kena, kwopun nəha in rɨno nui ruvehe mo waen irə. Iəmə asori riti tɨni ramemhə mamapri fwe taon Kapaneam. ");
INSERT INTO tnk_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nəpɨn iəmə i rɨreɡi mə Iesu ruku pen ia tənə Jutia muvəuvehe raka ia tənə Kalili, revən tukwe mɨni mə, “Səiou iəkunouihi ramemhə na tremhə. Ko ikeiwaiu pehe ia Kapaneam mo in ruvehe məsanɨn?” ");
INSERT INTO tnk_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Mɨreɡi Iesu rɨni pen tukwe in mə, “Kɨmiaha hiokeikei mə tako nɨmtətien me mɨne narimnari me tihərkərinari irə. Mə hiəpkətoni mhə tihəpwəh nɨniien nɨpərhienien ia nirak.” ");
INSERT INTO tnk_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mɨreɡi iəmə asori nəha rɨni pen tukwe in mə, “Iəmə asori. Tikuvehe akwauakw. Trɨpko mhə tui nərɨk remhə.” ");
INSERT INTO tnk_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Mɨreɡi Iesu rɨni pen tukwe in mə, “Tiko mevən. Nərɨm trɨpkemhə mhə.” Iəmə nəha rɨni nɨpərhienien ia nəɡkiariien nəha Iesu rɨməni pen tukwe in, nənə mɨrərɨɡ mamevən. ");
INSERT INTO tnk_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nəpɨn rameiwaiu pen imwəni, iotukwininari me səvənhi həuvehe, mhəvisau pen min mə tɨni ramɨru. ");
INSERT INTO tnk_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ro iamɨnhi irə in rəres pen irəha i nəfe taem tɨni rɨnəsanɨn irə. Mɨreɡi irəha həni pen tukwe in mə, “Nərineiv ia wan klok ia nəruarəv nemhəien raraka irə.” ");
INSERT INTO tnk_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tata səvəi iəkunouihi nəha rukurən mə ia nəpɨn atukwatukw nəha Iesu rɨməni pen tukwe in mə, “Nərɨm trɨpkemhə mhə.” Ro iamɨnhi irə in mɨne nərmama pam səməme kamharə ia nəkwai nimwə səvənhi həni nɨpərhienien ia Iesu. ");
INSERT INTO tnk_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","In i nɨmtətien sə ro kəru irə Iesu rɨno nəpɨn rier ia tənə Jutia muvehe ia tənə Kalili. ");
INSERT INTO tnk_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kurirə irə nəveɡɨnien asori riti səvəi nəkur Isrel ruvehe nənə Iesu rutə pen fwe Jerusalem. ");
INSERT INTO tnk_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nui riti fwe ia Jerusalem rametɨmw rerɨn ipaka tɨ kwəruə nəha kani mə Kwəruə Səvəi Sipsip Me. Ia nəɡkiariien Hipru kani nui nəha mə Petsata. Ia nɨkarkare nui nəha kɨno nari krirum ia kəpwier həmwhen ia tənimwə me. ");
INSERT INTO tnk_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nərmama kamhemhə həpɨk kamhəmak teɡɨn tənimwə me nəha. Nepwɨn nənimenraha rɨfwə. Nepwɨn nɨsunraha rərfe. Nepwɨn nɨpəri nɨpwranraha remhə. Irəha kamheitenhi nui nəha trɨkiu. ");
INSERT INTO tnk_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Nəpɨn nepwɨn aɡelo riti səvəi Iərɨmənu reiwaiu ia reri nui nəha mo rɨkiu. Nənə iərmama sə rukupwən meiwaiu ia reri nui nəfe nemhəien ro in raraka irə. Nənə in ruvehe məsanɨn. ");
INSERT INTO tnk_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Iərmama riti nəha ikɨn nemhəien səvənhi narə irə nuk toti-eit. ");
INSERT INTO tnk_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nəpɨn Iesu rətoni iəmə nəha raməmak ia kwopun nəha, mukurən mə rɨnəmak tui, in rɨni pen tukwe in mə, “Ikokeikei mə tikuvehe məsanɨn?” ");
INSERT INTO tnk_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Iəmə sə ramemhə rɨni pen tukwe in mə, “Iəmə asori. Sin truvehi iou meiwaiu ia nui nəpɨn nui rɨkiukiu irə? Iərmama riti riwən. Nənə nəpɨn iakuə takevən, mətə iərməpə iti rukupwən ia nirak meiwaiu ia nui.” ");
INSERT INTO tnk_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Mɨreɡi Iesu rɨni pen tukwe in mə, “Ərer, muvehi səim nɨməhan, mavən.” ");
INSERT INTO tnk_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nənə təkwtəkwuni a mwi iəmə nəha ruvehe məsanɨn, muvehi nɨməhan səvənhi, mavən. Nəpɨn nəha ia Sapat. ");
INSERT INTO tnk_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ro iamɨnhi irə nəmə asori me səvəi nəkur Isrel həni pen tɨ iəmə i Iesu rɨno in rəsanɨn mə, “Ipwet i Sapat. Rəpwəh natukwatukwien ia Loa səkɨtaha mə tikuvehi səim nɨməhan.” ");
INSERT INTO tnk_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Mɨreɡi in rɨni pen tɨ nirəha i mə, “Mətə iəmə sə rɨno iou iakəsanɨn, in rɨni pehe tukw iou i mə takuvehi nɨməhan səiou mavən.” ");
INSERT INTO tnk_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Mɨreɡi irəha həni pen tukwe in mə, “Sin nə iəmə rɨni pehe tukw ik i mə tikuvehi nɨməhan səim mavən?” ");
INSERT INTO tnk_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mətə iəmə nəha rɨreirei mə sin nəha rɨno in ruvehe məsanɨn. In rɨreirei tɨ nəri nə mə Iesu rukurau akwauakw a, nərmama həpɨk anan ia kwopun nəha. ");
INSERT INTO tnk_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kurirə irə Iesu rətui iəmə nəha mətoni ia nimwə səvəi Kumwesən, mɨni pen tukwe in mə, “Ətə ro, ikɨnəsanɨn! Tikevən maraka ia noien ərəha, kamo nərəhaien riti rasori məpi raka sə kupwən ruvehi ik.” ");
INSERT INTO tnk_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Iəmə nəha rier mevən mɨni pen tɨ nəmə asori me səvəi nəkur Isrel mə Iesu nəha rɨno in ruvehe məsanɨn. ");
INSERT INTO tnk_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nənə tɨ nəri nə mə Iesu ramo narimnari me nəha ia Sapat, nəmə asori me səvəi nəkur Isrel kənamhəni ərəha in. ");
INSERT INTO tnk_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Mətə Iesu rɨni pen tɨ nirəha i mə, “Səiou Tata ramowok ia nəpɨn me. Ro pen iou mwi takaməkeikei mowok.” ");
INSERT INTO tnk_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nəɡkiariien nəha ro nəmə asori me səvəi nəkur Isrel kənamhəmwur pɨk mə tuhousi əpune Iesu, tɨ nəri nə mə in rɨpkərui mhə Loa səvəi Sapat əpa, mətə rɨni mwi Kumwesən mə Tata səvənhi, mamo in rəmwhen a mwi Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ro iamɨnhi irə Iesu rɨni pen tɨ nirəha i mə, “Iakani nɨpərhienien tukumiaha i Tɨni Kumwesən ko rəpwəh no atukwien nari riti, mətə rukurən noien əpa nəfe nari rətə Tata səvənhi ramo. Nəfe nəɡhɨn Tata Kumwesən ramo, nəri nəha Tɨni mwi ramo. ");
INSERT INTO tnk_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Iakɨni iamɨnhi irə tɨ nəri nə mə Tata Kumwesən rokeikei pɨk Tɨni, maməseni Tɨni rətoni narimnari me pam sə in ramo. Nənə in trəseni Tɨni rətoni narimnari me nepwɨn hasori mwi mə kɨmiaha tihətoni mhərkərinari irə. ");
INSERT INTO tnk_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tata Kumwesən ramo nərmama səməme həuvamhə hətui mwi. In rauvei pen nɨmɨruien mɨnraha. Rəmwhen a mwi Tɨni rukurən nuvei penien nɨmɨruien m nərmama səməme rerɨn raɡien mə truvei pen mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tata Kumwesən rəpwəh nəkiriien noien səvəi iərmama riti, mətə wok səvəi nəkiriien noien səvəi iərmama, in rɨnəmri pen pam ia rəɡi Tɨni ");
INSERT INTO tnk_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","mə nərmama me pam tuhəsiai Tɨni rəmwhen kamhəsiai Tata səvənhi. Iərmama sə rɨpkɨsiai mhə Tɨni Kumwesən, rɨpkɨsiai mhə Tata səvənhi sə rɨnərhi pehe in ruvehe. ");
INSERT INTO tnk_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Iakani nɨpərhienien tukumiaha i. Iərmama sə ramreɡi nəɡkiariien səiou, mamɨni nɨpərhienien ia Iəmə sə rɨnərhi pehe iou iakuvehe, nɨmɨruien rerɨn rɨnarə raka irə. Ia nəpɨn nəha tukərpwɨn noien ərəha me irə, tɨpkɨni mhə mə iərmama nəha traməkeikei memhə. Mətə in rɨnaraka raka ia nemhəien muvəuvehe tɨ nɨmɨruien. ");
INSERT INTO tnk_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Iakani nɨpərhienien tukumiaha i. Nəpɨn riti nəha rauvehe, ruvəuvehe, nəpɨn sə nərmama həuvamhə tuhəreɡi reri Tɨni Kumwesən irə, nənə səməme kamhəreɡi tuhəmɨru mwi. ");
INSERT INTO tnk_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tata Kumwesən in nukune nɨmɨruien. Ro pen in rɨnəseni Tɨni mə Tɨni mwi in nukune nɨmɨruien. ");
INSERT INTO tnk_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tata Kumwesən rɨməuvei pen nasoriien m Tɨni mɨni mə trəkiri noien səvəi nərmama, mərpwɨn pen mɨnraha. In rauvehi nasoriien iamɨnha irə tɨ nəri nə mə Tɨni nə in nə Iəməti Iərmama. ");
INSERT INTO tnk_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nənimemiaha trəpwəh nierien ia nəɡkiariien i. Nəpɨn riti nəha rauvehe nəpɨn sə nərmama həuvamhə tuhəreɡi reri Tɨni Kumwesən, ");
INSERT INTO tnk_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","nənə mharaka ia kwopun kɨmənɨmwi irəha ikɨn. Səməme kənamho noien amasan tuhətui mwi mhəuvehi nɨmɨruien. Səməme kənamho noien ərəha tuhətui mwi tukərpwɨn noien ərəha me səvənraha. ");
INSERT INTO tnk_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Iou ko iakəpwəh no atukwien nari riti. Iakaməkiri noien səvəi nərmama mamesi pen a nəfe iakamreɡi. Nənə nəkiriien səiou ratukwatukw tɨ nəri nə mə iapkəmwur mhə tɨ nəfe iakokeikei, mətə iakaməmwur tɨ nəfe Iəmə sə rɨnərhi pehe iou iakuvehe rokeikei. ");
INSERT INTO tnk_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Trɨni mɨnuə iakərer irapw məɡkiari atukw ia nirak nəɡkiariien səiou ko kɨpkɨni mhə nɨpərhienien irə.” ");
INSERT INTO tnk_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","“Mətə riti nəha ramərer irapw məɡkiari ia nirak. Iakukurən mə nəɡkiariien səvənhi ro nɨpərhienien. ");
INSERT INTO tnk_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Fwe kupwən kɨmiaha hiərhi pen nərmama nepwɨn həuvən tɨ Jon. In rərer irapw məɡkiari ia nirak mə nɨpərhienien i iou nəfe iərmama. ");
INSERT INTO tnk_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Iapkəɡkiari mhə iamɨnhi irə mɨne tɨ nəri nə mə iakamətɨɡite ia iərmama riti mə trɨni irapw mə iou sin, rekəm. Mətə iakamɨni Jon mə kɨmiaha tihəni nɨpərhienien ia nəɡkiariien səvənhi nənə mhəuvehi nɨmɨruien. ");
INSERT INTO tnk_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon nəha rəmwhen ia nari riti rauək, mukuraan. Rerɨmiaha rɨnaɡien tɨ nukuraanien səvənhi nəpɨn ouihi a. ");
INSERT INTO tnk_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Mətə nari riti nəha ikɨn ramɨni irapw iou mə iou sin rɨskai mwi məpi raka nəɡkiariien səvəi Jon. In nə wok me sə Tata Kumwesən rɨnəseni iou mə tako. Wok me i iakamo kamhəni irapw iou mə nɨpərhienien Tata Kumwesən rɨnərhi pehe iou iakuvehe. ");
INSERT INTO tnk_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nənə Tata Kumwesən sə rɨnərhi pehe iou iakuvehe, in mwi ramərer irapw, maməɡkiari ia nirak mə iou sin. Mətə kɨmiaha hiəpkreɡi raka mhə rerɨn, mhəpkətə raka mhə mwi nənimen. ");
INSERT INTO tnk_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nəɡkiariien səvənhi rɨpkarə mhə ia rerɨmiaha tɨ nəri nə mə kɨmiaha hiəpkɨni mhə nɨpərhienien ia iərmama sə in rɨnərhi pehe i. ");
INSERT INTO tnk_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kɨmiaha hiaməvsini pɨk Nəkukuə Ikinan. Rerɨmiaha ramrhi mə ia nəɡkiariien me nəha tihəuvehi nɨmɨruien rerɨn. Mətə nəɡkiariien me nəha kwa həɡkiari ia nirak, ");
INSERT INTO tnk_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","mətə kɨmiaha hiəpwəh nokeikeiien mə tihəuvehe tukw iou mhəuvehi nɨmɨruien. ");
INSERT INTO tnk_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Iakəpwəh noien nəri anan ia nəɡnəɡɨniien səvəi nərmama, ");
INSERT INTO tnk_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","mətə iakukurən kɨmiaha. Nokeikeiien səvəi Kumwesən riwən ia rerɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Iou iakɨməuvehe ia nəɡhi Tata səiou, mətə kɨmiaha hiəpkəsevər mhə ia rerɨmiaha tukw iou. Mətə mə iərməpə riti truvehe ia nəɡhɨn əpa kɨmiaha tihəsevər ia rerɨmiaha tukwe. ");
INSERT INTO tnk_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kɨmiaha tihəfo mhəni nɨpərhienien ia nirak? Rəknekɨn tɨ nəri nə mə kɨmiaha hiokeikei mə tihəuvehi nəɡnəɡɨniien səkɨmiaha me, mətə hiəpkəmwur mhə mho nari riti mə Kumwesən i Kumwesən pərhien trəɡnəɡɨni kɨmiaha tukwe. ");
INSERT INTO tnk_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Rerɨmiaha trəpwəh nɨrhiien mə iou takɨni irapw noien ərəha me səkɨmiaha ia nəmri Tata Kumwesən. Iərmama riti nəha ikɨn in trɨni irapw noien ərəha me səkɨmiaha. In nəha Moses sə hiaməmri pen əknekɨn nətərɨɡien səkɨmiaha irə. ");
INSERT INTO tnk_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Rɨpɨnuə kɨmiaha hiəməni nɨpərhienien ia Moses, tihəni mwi nɨpərhienien ia nirak, tɨ nəri nə mə in rɨmərai nəɡkiariien me kamhəɡkiari ia nirak. ");
INSERT INTO tnk_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mətə kɨmiaha hiəpkɨni mhə nɨpərhienien ia nəɡkiariien me səvənhi sə in rɨmərai. Ro iamɨnhi irə tihəfo mhəni nɨpərhienien ia nəɡkiariien me səiou?” ");
INSERT INTO tnk_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Kurirə ia narimnari me nəha, Iesu rəpi sɨmwɨn ia nui asori fwe Kalili, muvarei ia nɨkaren pen. Nui nəha nəɡhɨn riti mwi mə Nui Asori Səvəi Taepirias. ");
INSERT INTO tnk_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nərmama həpɨk kamhəkurirə in tɨ nəri nə mə irəha hənətoni nɨmtətien me nəha ramo ia nərmama kamhemhə. ");
INSERT INTO tnk_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Nənə Iesu rutə ia təkuər riti maməkure ikɨn irəha nərmama me səvənhi. ");
INSERT INTO tnk_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(Ia nəpɨn nəha, nəveɡɨnien asori riti səvəi nəkur Isrel nəɡhɨn nə Pasova ruvəuvehe ipaka.) ");
INSERT INTO tnk_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iesu rəti pen mamətə mə nərmama həpɨk kamhəuvehe mə tuhətə in. Ro pen rɨni pen tɨ Filip i mə, “Tsəuvehi nəmri nəveɡɨnien pəku pwəh nərmama me i hani?” ");
INSERT INTO tnk_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Iesu ruvəukurən raka nəfe in tro, mətə rɨni nəɡkiariien nəha mə trətoni mə Filip trəfni irə.) ");
INSERT INTO tnk_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Mɨreɡi Filip rɨni pen tukwe in mə, “Trɨni mɨnuə kuvehi nəmri nəveɡɨnien ia silin kɨno ia silva irəha pam tu-hantret, mətə rəpwəh ihi nəmwhenien. Irəha kuatia kuatia tuhani ouihi a.” ");
INSERT INTO tnk_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Iərmama riti səvəi Iesu nəɡhɨn nə Antru piəvi Saemon Pita. In rɨni pen tɨ Iesu i mə, ");
INSERT INTO tnk_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Təmaruə riti ia kwopun i sənəni bred krirum kɨno ia pale mɨne nəmu kəru. Mətə sə nəha rɨpkəmwhen mhə tɨ nərmama me i. Irəha həpɨk anan.” ");
INSERT INTO tnk_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Mɨreɡi Iesu rɨni mə, “Kɨmiaha tiho nərmama me həkure.” Ia kwopun nəha nurhi rɨpɨk ikɨn. Nərmama həkure. Nəpɨn kəvsini nərman əpa irəha pam ipaka faef-taosen. ");
INSERT INTO tnk_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nənə Iesu ruvehi bred me nəha krirum məfwaki mɨni vivi Kumwesən tukwe, muvei pen m nərmama me nəha səməme kamhəkure. Ro mwi iamɨnhi irə ia nəmu mi nəha kəru. Irəha hani reste irəha. ");
INSERT INTO tnk_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nəpɨn hənani raka nari tɨpwɨnraha rəsisi, Iesu rɨni pen tɨ nərmama me səvənhi mə, “Kɨmiaha tihəuvən mhəuvehi nɨpərpəri nəveɡɨnien sə hənani mhəpwəh. Rərəha souraha nɨpərɨn.” ");
INSERT INTO tnk_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ro iamɨnhi irə irəha həuvən mhəuvehi nɨpərpəri bred krirum kɨno ia pale nərmama hənani mhəpwəh, mhəvai pen ia tənərɨpw me irəha pam twelef. ");
INSERT INTO tnk_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nəpɨn nərmama me hətoni nɨmtətien nəha Iesu rɨno, həni mə, “Nɨpərhienien iəmə i in i profet nəha kɨməni mə truvehe ia tɨprənə i.” ");
INSERT INTO tnk_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Iesu rukurən mə irəha hokeikei mə tuhəuvehe mhəkwtəmhiri in, mho in mə iəmə asori sə trərɨmənu ia nirəha. Ro iamɨnhi irə in rəpwəh irəha, mevən in əpa fwe ia təkuər. ");
INSERT INTO tnk_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nəpɨn rɨnaməruarəv, nərmama me səvənhi heiwaiu mhəuvən ia nui asori Kalili, ");
INSERT INTO tnk_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","mhəputə ia nɨtətə ouihi, mhəier, mənamhəpi sɨmwɨn ia nui asori, mamhəuvən fwe taon nəha Kapaneam. Rɨnəpitəv, mətə Iesu rəpwəh ihi nuveheien tɨ nirəha. ");
INSERT INTO tnk_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Nui asori ruvehe mɨnaməsəsau tɨ nəri nə mə nɨmətaɡi asori riti rɨskəmter. ");
INSERT INTO tnk_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nəpɨn irəha həsuə mhəuvən isipwɨn kwopti rəmwhen ia kilometa krirum uə sikis, hətoni Iesu ravən ia təkure nui, mauvehe ipaka tɨ nɨtətə ouihi səvənraha. Irəha hətoni həhekɨr. ");
INSERT INTO tnk_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Mətə in rɨni pen tɨ nirəha i mə, “Kɨmiaha tihəpwəh nehekɨrien. Iou a i.” ");
INSERT INTO tnk_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ro iamɨnhi irə rerɨnraha raɡien həuvehi in mhəuvehi utə ia nəkwai nɨtətə ouihi səvənraha. Nənə təkwtəkwuni a mwi nɨtətə ouihi səvənraha ruvarei ia tənə nəha kamhəuvən ikɨn. ");
INSERT INTO tnk_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kɨni rakwakwi irə, nərmama nepwɨn kamharə ihi ia nɨkare nui asori ipaka tɨ kwopun nəha nərmama me səvəi Iesu həməier ikɨn. Nərmama me nəha hətoni mə nərineiv nɨtətə ouihi kuatia a ramərer ia kwopun nəha. Irəha həukurən mə Iesu rɨnapkəputə mhə irə irəha nərmama me səvənhi, mətə nərmama me səvənhi irəha əpa hənəsuə mamhəuvən. ");
INSERT INTO tnk_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nɨtətə ouihi me nepwɨn həier ia taon Tiperias, mhəuvehe ipaka tɨ kwopun nəha Iərɨmənu səkɨtaha rɨməni vivi Kumwesən tɨ bred, nənə nərmama hani. ");
INSERT INTO tnk_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ro iamɨnhi irə nəpɨn nərmama hətoni mə Iesu mɨne nərmama me səvənhi həiwən ia kwopun nəha, həputə ia nɨtətə ouihi me nəha, mhəuvən fwe Kapaneam, mamhətui Iesu. ");
INSERT INTO tnk_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nəpɨn irəha hətoni in ia nɨkare nui asori, həni pen tukwe in mə, “Iahatən. Ikɨməuvehe nesən ia kwopun i?” ");
INSERT INTO tnk_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Kɨmiaha hiamətui iou tɨ nəfe? Tɨ nəri nə mə hiənətə nɨmtətien me nepwɨn? Rekəm! Mətə iakani nɨpərhienien tukumiaha i mə kɨmiaha hiamətui iou tɨ nəri nə mə hiənani bred tɨpwɨmiaha rəsisi. ");
INSERT INTO tnk_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tihəpwəh nəmwurien mə tihəuvehi nəveɡɨnien sə ramərɨr mətə tihəmwur mə tihəuvehi nəveɡɨnien sə raməmak rerɨn mauvei pehe nɨmɨruien rerɨn. Nəveɡɨnien nəha Iəməti Iərmama truvei pehe m kɨmiaha. Iəməti Iərmama in nəha Tata Kumwesən rɨnəmri pen raka mak səvənhi irə.” ");
INSERT INTO tnk_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Mɨreɡi irəha həni pen tukwe in mə, “Kɨmaha tahaməkeikei mhəfo irə, mho narimnari me nəha Kumwesən rokeikei?” ");
INSERT INTO tnk_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “In i nəri Kumwesən rokeikei. Kɨmiaha tihəni nɨpərhienien ia iəmə sə in rɨnərhi pehe i.” ");
INSERT INTO tnk_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Mɨreɡi irəha həni pen tukwe in mə, “Ro iamɨnhi irə tiko nəfe nɨmtətien pwəh kɨmaha iahətoni, nənə mhəni nɨpərhienien ia niram? Nəfe nari tiko? ");
INSERT INTO tnk_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Kaha kupwən me səkɨtaha hənani nəveɡɨnien nəha mana fwe kwopun akwesakwes ikɨn. Nəɡkiariien riti kɨmərai pen ia Nəkukuə Ikinan ramɨni iamɨnhi irə mə, ‘In ruvei pen mɨnraha nəveɡɨnien sə ruku pen ia neiai mə tuhani.’” ");
INSERT INTO tnk_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Iakani nɨpərhienien tukumiaha i. Rɨpko mhə Moses ruvei pehe m kɨmiaha nəveɡɨnien sə ruku pen ia neiai, mətə Tata səiou rauvei pehe m kɨmiaha nəveɡɨnien pərhien sə ruku pen ia neiai. ");
INSERT INTO tnk_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nəveɡɨnien i Kumwesən rauvei pehe m kɨmiaha in i iəmə rukrutə ia neiai meiwaiu pehe. In rauvei pehe nɨmɨruien m nərmama ia tɨprənə i.” ");
INSERT INTO tnk_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Mɨreɡi irəha həni pen tukwe in mə, “Iəmə asori. Tikuvei pehe nəveɡɨnien nəha m kɨmaha ia nəpɨn me.” ");
INSERT INTO tnk_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Iou nəveɡɨnien sə kauvehi nɨmɨruien irə. Iərmama sə rauvehe tukw iou nukumhə trɨpkahi mhə in, nənə iərmama sə rani nɨpərhienien ia nirak trɨpkəkwakwa mhə mwi ia nəpɨn riti. ");
INSERT INTO tnk_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mətə iakuvəni pehe raka tukumiaha i mə kɨmiaha hiənətə raka iou, mətə hiəpkɨni mhə nɨpərhienien ia nirak. ");
INSERT INTO tnk_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nərmama me pam səməme Tata Kumwesən rauvei pehe miou tuhəuvehe tukw iou. Nənə iərmama sə ruvehe tukw iou tapkəkoui irapw mhə in ia nəpɨn riti. ");
INSERT INTO tnk_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Iakani iamɨnhi irə tɨ nəri nə mə iou iapkukrutə mhə ia neiai meiwaiu pehe mə tako narimnari me sə iou əpa iakokeikei, mətə iakukrutə ia neiai meiwaiu pehe mə tako narimnari me Iəmə sə rɨnərhi pehe iou rokeikei. ");
INSERT INTO tnk_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nənə in i nəri Iəmə sə rɨnərhi pehe iou rokeikei. Nərmama me pam səməme in ruvei pehe miou takəpwəh nətə wauien ia nirəha riti, mətə ia nəpɨn sampam tako irəha pam hətui mwi ia nemhəien. ");
INSERT INTO tnk_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nɨpərhienien nəri i in i Tata səiou rokeikei. Nərmama me pam səməme hətə Tɨni, mhəni nɨpərhienien irə, tuhəuvehi nɨmɨruien rerɨn. Ia nəpɨn sampam tako irəha hətui mwi ia nemhəien.” ");
INSERT INTO tnk_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Mɨreɡi nəkur Isrel kamhəɡkiari afafa mɨnraha me, mamhəni ərəha Iesu tɨ nəri nə mə in rəɡkiari mɨni iamɨnhi irə mə, “Iou nəveɡɨnien sə rukrutə ia neiai meiwaiu pehe.” ");
INSERT INTO tnk_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Irəha həni mə, “Rosi Iesu əpa nəha tɨni Josef uə? Kɨtaha səukurən tata mɨne mama səvənhi. Ro iamɨnhi irə rəfo in ramɨni təkwtəkwuni mɨnuə ‘Iou iakɨməukruutə ia neiai meiwaiu pehe?’” ");
INSERT INTO tnk_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Tihəpwəh nəɡkiari afafaien m kɨmiaha me iamɨnhi irə. ");
INSERT INTO tnk_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Iərmama riti riwən ko ruvehe atukw tukw iou, mətə Tata Kumwesən sə rɨnərhi pehe iou traməkeikei mɨvi in ruvehe tukw iou, nənə ia nəpɨn sampam tako in rətui mwi ia nemhəien. ");
INSERT INTO tnk_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kɨmərai pen ia nəkukuə me səvəi profet kupwən me mə, ‘Irəha pam nə Kumwesən trahatən irəha.’ Ro iamɨnhi irə nərmama me səməme kamhətərɨɡ ia Tata Kumwesən mamhəuvehi nukurənien tuhəuvehe tukw iou. ");
INSERT INTO tnk_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nəɡkiariien nəha nɨpwran rɨpko mhə mə iərmama riti rɨnətə raka Tata Kumwesən, rekəm. Iərmama əpa sə ruku pen ia Kumwesən, in nə rɨnətə Tata Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Iakani nɨpərhienien tukumiaha i. Iərmama sə rani nɨpərhienien ia nirak nɨmɨruien rerɨn rɨnarə raka irə. ");
INSERT INTO tnk_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Iou nəveɡɨnien kauvehi nɨmɨruien irə. ");
INSERT INTO tnk_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Kaha me səkɨmiaha hənani nəveɡɨnien nəha mana fwe ia kwopun akwesakwes ikɨn, nənə mhemhə. ");
INSERT INTO tnk_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","In i nəveɡɨnien sə rukrutə ia neiai meiwaiu pehe mə iərmama ko rəni nənə məpwəh nemhəien. ");
INSERT INTO tnk_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Iou nəveɡɨnien sə ramɨru rukrutə ia neiai meiwaiu pehe. Trɨni mɨnuə iərmama riti rəni nəveɡɨnien i in trɨmɨru rerɨn. Nənə nəveɡɨnien sə takuvei pen mə nərmama ia tɨprənə i tuhəuvehi nɨmɨruien in i nɨpwrak.” ");
INSERT INTO tnk_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Iesu rɨni nəɡkiariien nəha, nənə nəkur Isrel me hənaməvisə mɨnraha me, mhəni mə, “Iəmə nəha trəfo muvei pehe nɨpwran m kɨtaha sani?” ");
INSERT INTO tnk_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Iakani nɨpərhienien tukumiaha i. Kɨmiaha tihaməkeikei mhani nɨpwrai Iəməti Iərmama, mhənɨmwi nɨten. Mə kɨmiaha hiəpwəh, nɨmɨruien riwən ia kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Iərmama sə raməni nɨpwrak mamənɨmwi nɨtek, nɨmɨruien rerɨn rɨnarə raka irə, nənə ia nəpɨn sampam iou tako in rətui mwi ia nemhəien. ");
INSERT INTO tnk_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Iakani iamɨnhi irə tɨ nəri nə mə nɨpwrak in nəveɡɨnien pərhien mɨne nɨtek in nənɨmwien pərhien. ");
INSERT INTO tnk_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Iərmama sə raməni nɨpwrak, mamənɨmwi nɨtek, rəpwit əknekɨn ia nirak iakəpwit əknekɨn irə. ");
INSERT INTO tnk_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tata Kumwesən sə rɨnərhi pehe iou iakuvehe in ramɨru. Iou iakauvehi nɨmɨruien ruku pen irə. Ia noien nəha rəmwhen a mwi iərmama sə kəkwməni in ia nɨpwrak mɨne nɨtek truvehi nɨmɨruien ruku pen ia nirak. ");
INSERT INTO tnk_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","In i nəveɡɨnien sə rukrutə ia neiai meiwaiu pehe. Ropə ia mana nəha kaha kupwən me hənani, mhemhə. Iərmama sə raməni nəveɡɨnien i trɨmɨru rerɨn.” ");
INSERT INTO tnk_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iesu rɨni nəɡkiariien me nəha ia nəkwai nimwəfwaki səvəi nəkur Isrel nəpɨn ramahatən nərmama me fwe Kapaneam. ");
INSERT INTO tnk_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nərmama kamhəkurirə ia Iesu həpɨk həreɡi nəɡkiariien nəha həni mə, “Nəɡkiariien nəha rɨskai. Sin ko rətərɨɡ irə?” ");
INSERT INTO tnk_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Mətə Iesu ruvəukurən atukw raka ia rerɨn mə nərmama me səvənhi rerɨnraha rɨpkaɡien mhə tɨ nəɡkiariien nəha, kamhəsiwənəsiwən tukwe. Ro pen in rɨni pen tɨ nirəha i mə, “Rəfo? Rosi nəɡkiariien i ro kɨmiaha hiəmwei ia nahatətəien səkɨmiaha? ");
INSERT INTO tnk_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Mə nəɡkiariien nəha rɨskai tukumiaha, tihəfətərɨɡ irə mə hiətoni Iəməti Iərmama rutə mwi ia kwopun rɨnamarə ikɨn kupwən? ");
INSERT INTO tnk_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Nənɨmwɨn Ikinan əpa rauvei pehe nɨmɨruien. Nɨpwrai iərmama ko rɨpko mhə nəri nəha. Nəɡkiariien me i iakɨməni pehe tukumiaha i ho nənɨmwɨn mhəuvei pehe nɨmɨruien. ");
INSERT INTO tnk_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mətə kɨmiaha nepwɨn hiəpkɨni mhə nɨpərhienien ia nirak.” (Iesu rɨni ianhi tɨ nəri nə mə ruvəukurən raka fwe kupwən nɨsɨmə nəha ia nirəha tuhəpwəh nɨniien nɨpərhienien irə mɨne sin nəha truvei pen in ia rəɡi nərmama səməme haməmwəki in.) ");
INSERT INTO tnk_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nənə Iesu rarə mɨni mwi mə, “Kɨmiaha nepwɨn hiəpkɨni mhə nɨpərhienien ia nirak. Ro pen iakɨməni pehe tukumiaha i mə iərmama riti riwən ko ruvehe atukw tukw iou trɨni mɨnuə Tata Kumwesən rɨpkəseni mhə in.” ");
INSERT INTO tnk_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nəpɨn Iesu rɨni pam nəɡkiariien nəha nərmama me səvənhi həpɨk həpwəh in mhərərɨɡ, mhəpwəh mwi nukurirəien in. ");
INSERT INTO tnk_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ro pen Iesu rɨni pen tɨ səvənhi nərmama me twelef mə, “Kɨmiaha mwi hiokeikei mə tihəpwəh iou mamhəuvən?” ");
INSERT INTO tnk_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Mɨreɡi Saemon Pita rɨni pen tukwe in mə, “Iərɨmənu. Kɨmaha tihəuvən tɨ sin? Ik əpa ikauvehi nəɡkiariien sə rauvei pehe nɨmɨruien rerɨn. ");
INSERT INTO tnk_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kɨmaha iahəuvəuvehe raka mhəni nɨpərhienien ia niram, mhəuvəukurən raka mə ik nə Iəmə Ikinan səvəi Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Kɨmiaha i twelef nərmama me səiou, iakɨnərpwi rəɡɨk ia kɨmiaha, mətə kɨmiaha riti in iəremhə.” ");
INSERT INTO tnk_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","In raməɡkiari ia Jutas tɨni Saemon Iskariot, tɨ nəri nə mə Jutas riti ia twelef nərmama səvəi Iesu truvei pen Iesu ia reɡi nərmama səməme haməmwəki in. ");
INSERT INTO tnk_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kurirə irə Iesu ramavən mamərkurau ia tənə Kalili, məpwəh nokeikeiien mə trevən ia tənə Jutia, tɨ nəri nə mə nəmə asori me səvəi nəkur Isrel kamhətui in mə tuhousi əpune. ");
INSERT INTO tnk_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ipaka tɨ nəveɡɨnien asori nəha səvəi nəkur Isrel nəɡhɨn nə Nəveɡɨnien səvəi Tənimwə Me. ");
INSERT INTO tnk_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ro pen piəvi Iesu me həni pen tukwe in mə, “Tikier ia kwopun i, mevən ia tənə Jutia, mə səim me nərmama me irəha mwi tuhətoni narimnari me i sə ikamo. ");
INSERT INTO tnk_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Trɨni mɨnuə iərmama riti rokeikei mə nərmama tuhəukurən in, ko in rɨpkərkwafə mhə narimnari me sə in ramo. Ikamo narimnari me i, ramasan mə iko ia nəmri nərmama pam ia tɨprənə i pwəh hətə ik.” ");
INSERT INTO tnk_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Piəvi Iesu me həni iamɨnhi irə tɨ nəri nə mə irəha mwi həpkɨni mhə nɨpərhienien irə.) ");
INSERT INTO tnk_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ro pen Iesu rɨni pen tɨ nirəha i mə, “Nəpɨn səiou rɨpkuvehe mhə ihi, mətə nəpɨn səkɨmiaha rauvehe ia nəpɨn me. ");
INSERT INTO tnk_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nərmama ia tɨprənə i ko həpkəmwəki mhə kɨmiaha, mətə irəha kamhəmwəki iou, tɨ nəri nə mə iakaməɡkiari ia nirəha, mamɨni mə noien me səvənraha hərəha. ");
INSERT INTO tnk_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ramasan mə kɨmiaha hiəutə mhəuvən ia nəveɡɨnien asori. Mətə iou tapkevən mhə ia nəveɡɨnien asori nəha, tɨ nəri nə mə nəpɨn səiou rɨpkuvehe mhə ihi.” ");
INSERT INTO tnk_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Iesu rɨni pam nəɡkiariien i, nənə mamo a ia tənə Kalili. ");
INSERT INTO tnk_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Mətə nəpɨn piəvni me həuvəutə raka mhəuvavən ia nəveɡɨnien asori, in mwi rutə mevən, mɨpkavən irapw mhə mətə ravən afafa. ");
INSERT INTO tnk_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nəmə asori me səvəi nəkur Isrel kamhətui in ia nəveɡɨnien asori, mamhəni mə, “In pəku?” ");
INSERT INTO tnk_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nənə nərmama kamhəsiwən mamhəɡkiari pɨk ia Iesu. Nepwɨn həni mə, “In iəmə amasan.” Nepwɨn mwi həni mə, “Rekəm. In rameikuə ia nərmama.” ");
INSERT INTO tnk_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mətə iərmama riti riwən rɨni irapw Iesu ia nəmri nərmama, tɨ nəri nə mə irəha həhekɨr nəmə asori me səvəi nəkur Isrel. ");
INSERT INTO tnk_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nəpɨn nəha kamo nəveɡɨnien asori irə ruvehi nəfwakiien riti. Ia kurkwai nəfwakiien nəha Iesu rutə mevən ia nimwə səvəi Kumwesən, mɨnamahatən nərmama me. ");
INSERT INTO tnk_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ro iamɨnhi irə nəmə asori me səvəi nəkur Isrel hərkərinari, mhəni mə, “Rəfo iəmə i rukurən amasan narimnari me i ia Nəkukuə Ikinan mətə kɨpkahatən raka mhə in?” ");
INSERT INTO tnk_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Nəɡkiariien i iakamahatən nərmama me irə rɨpko mhə nəɡkiariien səiou, mətə nəɡkiariien səvəi Iəmə sə rɨnərhi pehe iou iakuvehe. ");
INSERT INTO tnk_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Trɨni mɨnuə iərmama riti rokeikei mə tro nəkwai Kumwesən, in trətə sas nəɡkiariien i iakamahatən nərmama me irə mə ruku pen tɨ Kumwesən uə iakani irapw nəɡkiariien atukw səiou. ");
INSERT INTO tnk_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Iərmama sə rani irapw nəɡkiariien atukw səvənhi raməmwur mə nərmama tuhəuvehi utə nəɡhɨn. Mətə iərmama sə raməmwur mə nərmama tuhəuvehi utə nəɡhi iəmə sə rɨnərhi pehe in, in nəha iərmama sə rani nɨpərhienien. Ia reri iərmama nəha neikuəien riwən. ");
INSERT INTO tnk_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses rɨməuvei pehe Loa m kɨmiaha uə rekəm? Ouəh nɨpərhienien, mətə kɨmiaha riti riwən ramesi pen Loa nəha. Rəfo hiaməmwur mə tihousi əpune iou?” ");
INSERT INTO tnk_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mɨreɡi nərmama me həni mə, “Iəremhə riti ramarə ia niram! Sin raməmwur mə trousi əpune ik?” ");
INSERT INTO tnk_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Iakɨno nɨmtətien kuatia a kɨmiaha pam hiamərkərinari irə. ");
INSERT INTO tnk_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses rɨməni pen tukumiaha mə nəpɨn iəkunouihi riti iərman səkɨmiaha ruvehi nəpɨn səvənhi eit kuvehi ninhum min. Nənə tɨ loa nəha nəri auər a mə nəpɨn eit rəmak pen ia Sapat kɨmiaha tihaməuvehi ninhum m nəkwərhakwərha me səkɨmiaha. (Nɨpərhienien rɨpko mhə Moses rɨməkupwən mo noien nəha, mətə kaha kupwən me haməkupwən mho.) ");
INSERT INTO tnk_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mə kɨmiaha hiaməuvehi ninhum m iəkunouihi ia Sapat kamo hiərui loa səvəi Moses, rəfo niemaha raməpi kɨmiaha tɨ nəri nə mə ia Sapat iakɨno iərman riti nɨpwran me pam ruvehe məsanɨn? ");
INSERT INTO tnk_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kɨmiaha tihəpwəh nəkiriien nari ia noien i sə hiamətoni əpa, mətə tihaməkeikei mhəkiri nari ia noien sə ratukwatukw.” ");
INSERT INTO tnk_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ro iamɨnhi irə nəkur Jerusalem me nepwɨn həni mə, “Rosi iəmə i in i nəmə asori me kamhəmwur mə tuhousi əpune uə? ");
INSERT INTO tnk_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Hətoni ro in raməɡkiari ia nəmri nərmama me pam, mətə irəha həpkɨnise mhə in. Rosi nəmə asori me həukurən pərhien mə iəmə i in Kristo uə? ");
INSERT INTO tnk_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mətə kɨtaha səukurən kwopun sə iəmə i ruku pen ikɨn. Nəpɨn iəmə nəha Kristo trier pehe, iərmama riti trɨpkukurən mhə kwopun ruku pen ikɨn.” ");
INSERT INTO tnk_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ro iamɨnhi irə nəpɨn Iesu ramahatən nərmama ia nimwə səvəi Kumwesən, in rəkwein əpwəmwɨs, mɨni mə, “Rerɨmiaha ramrhi mə hiəukurən iou, mhəukurən mwi kwopun iakuku pen ikɨn, mətə kɨmiaha hiəreirei. Iou iapkuvehe mhə ia nətərɨɡien atukw səiou. Iəmə sə rɨnərhi pehe iou iakuvehe in pərhien. Kɨmiaha hiəreirei in. ");
INSERT INTO tnk_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Iou iakukurən in, tɨ nəri nə mə iakuku pen irə, nənə in rərhi pehe iou iakuvehe.” ");
INSERT INTO tnk_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ro iamɨnhi irə nəmə asori me kamhəmwur mə tuhəkwtəmhiri Iesu, mətə iərmama riti riwən rəkwtəmhiri in tɨ nəri nə mə nəpɨn səvənhi rɨpkuvehe mhə ihi. ");
INSERT INTO tnk_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Mətə nərmama həpɨk ia kwopun nəha həni nɨpərhienien ia Iesu, mamhəni mə, “Nəpɨn iəmə nəha Kristo trier pehe, in trəpwəh noien nɨmtətien me rɨpɨk mwi məpi raka səməme iəmə i rɨno.” ");
INSERT INTO tnk_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisi me həreɡi nərmama me kamhəsiwən mamhəni narimnari me i ia Iesu. Ro pen irəha mɨne pris asori me hərhi pen iotukwininari me nepwɨn həuvən mə tuhəkwtəmhiri in. ");
INSERT INTO tnk_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ia nəpɨn nəha Iesu rɨni mə, “Takarə nəpɨn ouihi a kɨtaha m kɨmiaha nənə mevən tɨ Iəmə sə rɨnərhi pehe iou iakuvehe. ");
INSERT INTO tnk_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kɨmiaha tihətui iou, mhəpwəh nətoniien iou, tɨ nəri nə mə kwopun takarə ikɨn ko kɨmiaha hiəpkəuvən mhə ikɨn.” ");
INSERT INTO tnk_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ro iamɨnhi irə nəmə asori me səvəi nəkur Isrel həɡkiari mɨnraha me, mamhəni mə, “In nəha təkwtəkwuni iəmə i trevən pəku səpwəh nətoniien in? Rosi trevən ia tənəmtənə me ia kwopun me nəha nəkur Isrel kamharə ikɨn irəha nəkur Kris, mahatən nəkur Kris uə? ");
INSERT INTO tnk_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","In rɨni iamɨnhi irə mə, ‘Kɨmiaha tihətui iou, mhəpwəh nətoniien iou. Kwopun takarə ikɨn ko kɨmiaha hiəpkəuvən mhə ikɨn.’ ?Nəɡkiariien nəha nɨpwran rəfo irə?” ");
INSERT INTO tnk_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nəpɨn sampam səvəi nəveɡɨnien asori nəha, in nə nəpɨn sə rasori ia nəpɨn me nepwɨn, Iesu rɨskəmter, məkwein əpwəmwɨs, mɨni mə, “Trɨni mɨnuə kɨmiaha riti rəkwakwa, uvehe tukw iou, mənɨmwi. ");
INSERT INTO tnk_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Iərmama sə rani nɨpərhienien ia nirak, Nəkukuə Ikinan ruvəni raka iamɨnhi irə mɨnuə nui sə rauvei pen nɨmɨruien trier fwe ia rerɨn maiu rəmwhen ia nui arɨs me.” ");
INSERT INTO tnk_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iesu rɨni nəɡkiariien i maməɡkiari ia Nənɨmwɨn Ikinan. In i Nənɨmwɨn sə nərmama səməme kamhəni nɨpərhienien ia Iesu tuhəuvehi. Mətə ia nəpɨn nəha kəpwəh ihi nuvei penien Nənɨmwɨn nəha mɨnraha, tɨ nəri nə mə kɨpkuvehi utə mhə ihi Iesu rɨrərɨɡ pen fwe ia neiai. ");
INSERT INTO tnk_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nəpɨn irəha həreɡi nəɡkiariien me nəha, nərmama nepwɨn həni mə, “Nɨpərhienien iəmə i in profet nəha kɨməni mə truvehe.” ");
INSERT INTO tnk_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Nepwɨn həni mə, “In i Kristo.” Mətə nepwɨn həni mə, “Rekəm. Iəmə nəha Kristo trɨpkuku pen mhə ia tənə Kalili. ");
INSERT INTO tnk_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Nəkukuə Ikinan rɨni mə Kristo truku pen ia kwənəkwus səvəi Kiɡ Tevɨt. In trətui ia Petlehem, rukwənu səvəi Kiɡ Tevɨt ia tənə Jutia.” ");
INSERT INTO tnk_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ro iamɨnhi irə nərmama me nəha həuai irəha me tɨ Iesu. ");
INSERT INTO tnk_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Nepwɨn hokeikei mə tuhəkwtəmhiri in, mətə iərmama riti riwən rəkwtəmhiri. ");
INSERT INTO tnk_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ia nəpɨn nəha iotukwininari me nəha hərərɨɡ mhəuvehe tɨ pris asori me mɨne Farisi me, nənə nəmə asori me i həres pen irəha i mə, “Rəfo kɨmiaha hiəpwəh nuvehiien Iesu mhəuvehi mhəuvehe?” ");
INSERT INTO tnk_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Mɨreɡi iotukwininari me həni mə, “Kɨmaha iahəpkreɡi raka mhə iərmama riti raməɡkiari rəmwhen ia iəmə nəha.” ");
INSERT INTO tnk_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mɨreɡi Farisi me həni pen tɨ nirəha i mə, “Rosi in reikuə ia kɨmiaha, mo kɨmiaha mwi hiəruei uə? ");
INSERT INTO tnk_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Rəfo? Kɨmiaha hiətoni iəmə asori riti səkɨtaha uə Farisi riti rɨni nɨpərhienien irə? Rekəm! ");
INSERT INTO tnk_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Mətə nərmama me nəha səməme kamhəkurirə in həreirei Loa səvəi Moses. Ro pen Kumwesən raməkwein ərəha ia nirəha.” ");
INSERT INTO tnk_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikotimas, iəmə sə rɨmavən mətə Iesu fwe kupwən, in riti ia Farisi me i. In rɨni pen tɨ nirəha i mə, ");
INSERT INTO tnk_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Loa səkɨtaha raməfni irə? Ko kɨtaha səkiri iərmama riti mə noien səvənhi rərha mətə səpkukupwən mhə mhəreɡi nəɡkiariien səvənhi, mhətui nəfe noien in ramo?” ");
INSERT INTO tnk_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Mɨreɡi irəha həni mə, “Rosi ik mwi ik iəmə Kalili uə? Əvsini Nəkukuə Ikinan mətoni ro mə profet riti trɨpkutə mhə fwe tənə Kalili.” ");
INSERT INTO tnk_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nərmama havən kɨrkɨri, mamhəuvən fwe imwənraha me. ");
INSERT INTO tnk_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Mətə Iesu revən ia Təkuər Olif. ");
INSERT INTO tnk_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kɨni rakwakwi irə, ia nəpnəpɨn in rɨrərɨɡ mevən ia nimwə səvəi Kumwesən. Nərmama me pam həuvehe tukwe, nənə in rəkure, mɨnamahatən irəha. ");
INSERT INTO tnk_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ia nəpɨn nəha nahatən me səvəi Loa mɨne Farisi me həuvehi pran riti sə kətə pui in ramo əpnapen nari irau iərman riti rɨpko mhə səvənhi. Irəha həuvehi mhəuvehe mhərpwi irapw in ia nəmri nərmama me pam, ");
INSERT INTO tnk_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","nənə mhəni pen tɨ Iesu i mə, “Iahatən. Kətə pui prən i ramo əpnapen nari irau iərman riti rɨpko mhə səvənhi. ");
INSERT INTO tnk_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ia Loa səkɨtaha Moses rɨməni mɨnuə kɨtaha tsaməkeikei mhəkwi əpune nɨpran me səməme kamho iamɨnhi irə. Mətə ik mə tso nəfe ia pran i?” ");
INSERT INTO tnk_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Irəha həni nəɡkiariien nəha mə tuhəreɡi mə Iesu trəfni irə. Hokeikei mə in trəfwəkour ia nəɡkiariien səvənhi, nənə irəha həukurən nɨni ərəhaien in tukwe. Mətə Iesu rərpəsuk mɨnamrai pen nəkukuə ia tɨprənə ia nukwai rəɡɨn. ");
INSERT INTO tnk_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Mətə irəha kamhəmwur a mamhəres in. Ro iamɨnhi irə in rɨskəmter, mɨni pen tɨ nirəha i mə, “Sin ia kɨmiaha nərəhaien səvənhi riwən? Pwəh in rukupwən mərarki pen kəruəterei ia prən i.” ");
INSERT INTO tnk_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Nənə in rərpəsuk mwi mɨnamrai nəkukuə ia tɨprənə ia nəkwai rəɡɨn. ");
INSERT INTO tnk_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nənə nəpɨn irəha həreɡi nəɡkiariien nəha, havən mamhəuvən kuatia kuatia. Nərɡharə me həkupwən ntəmaruə me həkurirə, mhəpwəh Iesu əpa mɨne prən nəha ramərer. ");
INSERT INTO tnk_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Iesu rɨskəmter, mɨni pen tɨ prən i mə, “Prən i. Irəha isə? Riti rɨpkɨni mhə mə tikemhə?” ");
INSERT INTO tnk_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mɨreɡi prən i rɨni mə, “Rekəm, iəmə asori. Riti rɨpkɨni mhə.” Mɨreɡi Iesu rɨni mə, “Iou mwi iakəpwəh nɨniien mə tikemhə, mətə tiko mamevən məpwəh nərəhaien.” ");
INSERT INTO tnk_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Iesu rəɡkiari mwi m Farisi me mɨni mə, “Iou nukuraanien sə raməhiəpwɨn nərmama ia tɨprənə i. Iərmama sə rakurirə iou trəpwəh navənien ia nəpitəvien, mətə trətoni nukuraanien sə kauvehi nɨmɨruien irə.” ");
INSERT INTO tnk_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mɨreɡi Farisi me həni pen tɨ Iesu i mə, “Ikamərer irapw maməɡkiari atukw ia niram iamɨnhi irə, mətə nɨpəri nəɡkiariien səim riwən tukw ik, ro pen nəɡkiariien səim ko kɨpkɨni mhə nɨpərhienien irə!” ");
INSERT INTO tnk_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Pərhien iakamərer irapw maməɡkiari atukw ia nirak, mətə nəɡkiariien səiou ko kɨni nɨpərhienien irə, tɨ nəri nə mə iakukurən kwopun iakuku pen ikɨn mɨne kwopun iakamevən ikɨn. Mətə kɨmiaha hiəreirei kwopun iakuku pen ikɨn uə kwopun iakamevən ikɨn. ");
INSERT INTO tnk_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kɨmiaha hiaməkiri nari ia nətərɨɡien səvəi iərmama a, mətə iou iapkəkiri mhə iərmama riti. ");
INSERT INTO tnk_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Mətə trɨni mɨnuə iakəkiri iərmama riti, nəkiriien səiou ro nɨpərhienien tɨ nəri nə mə rɨpko mhə iou əpa iakaməkiri in, mətə iou mɨne Tata sə rɨnərhi pehe iou iakuvehe. ");
INSERT INTO tnk_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Hiəukurən nəɡkiariien i kɨmərai pen ia Loa səkɨmiaha rɨni iamɨnhi irə mə, ‘Iərmama kəru krouərer irapw rouni nəɡkiariien kuatia tukɨni nɨpərhienien irə.’ ");
INSERT INTO tnk_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Təkwtəkwuni nəha iou mɨne Tata Kumwesən sə rɨnərhi pehe iou iakuvehe kɨmrau iarouərer irapw rouəɡkiari ia nirak rouni nəɡkiariien kuatia.” ");
INSERT INTO tnk_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Mɨreɡi irəha həni pen tɨ Iesu i mə, “Səim isə Tata?” Mɨreɡi Iesu rɨni mə, “Kɨmiaha hiəuvəreirei iou, mhəuvəreirei mwi Tata səiou. Kamo hiəpkukurən iou, ko hiəukurən mwi Tata səiou.” ");
INSERT INTO tnk_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iesu rɨməni nəɡkiariien me i nəpɨn in ramahatən nərmama fwe ia nimwə səvəi Kumwesən ia kwopun kamerukw pen mane səvəi nəfwakiien ikɨn, mətə iərmama riti rəpwəh nəkwtəmhiriien in tɨ nəri nə mə nəpɨn səvənhi tukəkwtəmhiri in irə rɨpkuvehe mhə ihi. ");
INSERT INTO tnk_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ro iamɨnhi irə Iesu rɨni pen mwi tɨ nirəha i mə, “Iou takəpwəh kɨmiaha mamevən. Kɨmiaha tihətui iou mhemhə kɨmiaha noien ərəha me səkɨmiaha. Kɨmiaha tihəpkəuvən mhə ia kwopun nəha iakamevən ikɨn.” ");
INSERT INTO tnk_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ro iamɨnhi irə nəmə asori me səvəi nəkur Isrel həni mə, “Nəɡkiariien nəha in rani mə kwopun nəha ramevən ikɨn, kɨtaha tsəpkəuvən mhə ikɨn, nɨpwran rəfo irə? Rosi in trousi əpune atukw a in uə?” ");
INSERT INTO tnk_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Kɨmiaha imwəmiaha inhərɨpw. Iou imwak irənhə. Kɨmiaha nərmama səvəi tɨprənə i. Iou rɨpko mhə iou iərmama səvəi tɨprənə i. ");
INSERT INTO tnk_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Iakuvəni raka tukumiaha i mə kɨmiaha tihemhə kɨmiaha noien ərəha me səkɨmiaha. Iakɨməni iamɨnha irə tɨ nəri nə kɨmiaha tihaməkeikei mhəni nɨpərhienien ia nirak mə iou i in i. Mə hiəpwəh tihemhə kɨmiaha noien ərəha me səkɨmiaha.” ");
INSERT INTO tnk_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Mɨreɡi irəha həres pen in mə, “Ik sin nə?” Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Iou iərmama i iakani pehe tukumiaha i fwe kupwən meste pehe ipwet. ");
INSERT INTO tnk_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Səiou me nəɡkiariien me rɨpɨk iakukurən nɨniien ia kɨmiaha. Narimnari me rɨpɨk hiəno iakukurən nəkiriien mə hərəha. Mətə Iəmə sə rɨnərhi pehe iou iakuvehe nəɡkiariien səvənhi ro nɨpərhienien, nənə iou iakani irapw tɨ nərmama ia tɨprənə i nəfe nəɡkiariien iakreɡi in rɨməni pehe tukw iou i.” ");
INSERT INTO tnk_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Mətə irəha həreirei mə Iesu raməɡkiari ia Tata Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ro iamɨnhi irə Iesu rɨni pen tɨ nirəha i mə, “Nəpɨn kɨmiaha tihəuvehi utə raka iou, Iəməti Iərmama, tihəukurən mə iou i in i. Kɨmiaha tihəukurən mwi mə iapko əpa raka mhə nari riti, mətə iakəɡkiari mamesi pen a nəfe Tata Kumwesən rahatən iou irə. ");
INSERT INTO tnk_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Iəmə sə rɨnərhi pehe iou iakuvehe in ramarə kɨmrau min. In rɨpkəpwəh mhə iou iakamavən əpa, tɨ nəri nə mə nəpɨn me pam iakamo narimnari me səməme rerɨn ramaɡien tukwe.” ");
INSERT INTO tnk_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nəpɨn Iesu rani nəɡkiariien me nəha nərmama həpɨk həni nɨpərhienien irə. ");
INSERT INTO tnk_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ro iamɨnhi irə Iesu rɨni pen tɨ nəkur Isrel me i səməme həni nɨpərhienien irə mə, “Trɨni mɨnuə kɨmiaha hiamrɨpɨn mamho nəɡkiariien səiou, kɨmiaha atukwatukw nə nərmama me səiou. ");
INSERT INTO tnk_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nənə kɨmiaha tihəukurən nəɡkiariien sə ro nɨpərhienien, nəɡkiariien pərhien i trɨfi nari ia kɨmiaha.” ");
INSERT INTO tnk_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Mɨreɡi irəha həni pen tɨ Iesu i mə, “Kɨmaha kwənəkwus me səvəi Epraham. Iərmama riti rɨpko raka mhə slef ia kɨmaha. Rəfo ikɨni nəɡkiariien i mə nəɡkiariien pərhien trɨfi nari ia kɨmaha?” ");
INSERT INTO tnk_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Iakani nɨpərhienien tukumiaha i iərmama sə ramo noien ərəha, noien ərəha səvənhi ramərɨmənu irə mamoslef irə. ");
INSERT INTO tnk_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Slef riti in ko rəpwəh narə rerɨnien ia nəkwai nimwə səvəi iəmə asori səvənhi, mətə tɨni əpa rukurən narə rerɨnien ikɨn. ");
INSERT INTO tnk_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ro iamɨnhi irə trɨni mɨnuə Tɨni Kumwesən rɨfi nari ia kɨmiaha, in trɨfi pərhien nari ia kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Iakukurən mə kɨmiaha kwənəkwus me səvəi Epraham, mətə hiaməmwur mə tihousi əpune iou tɨ nəri nə mə kɨmiaha hiəpwəh nokeikeiien mə tihəreɡi nəɡkiariien səiou. ");
INSERT INTO tnk_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Iou iakaməɡkiari ia nəfe iakɨnətoni kɨmrau Tata səiou, mətə kɨmiaha hiamo nəfe hiamreɡi tata səkɨmiaha rɨməni pehe tukumiaha.” ");
INSERT INTO tnk_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Mɨreɡi irəha həni pen tɨ Iesu i mə, “Səkɨmaha tata Epraham.” Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Trɨni mɨnuə kɨmiaha nɨpwnəti Epraham pərhien me, tihamo nəfe noien in rɨnamo fwe kupwən. ");
INSERT INTO tnk_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Iou i iəmə sə iakani irapw tukumiaha nəɡkiariien pərhien sə iakreɡi ruku pen tɨ Kumwesən. Mətə təkwtəkwuni kɨmiaha hiaməmwur mə tihousi əpune iou. Epraham rɨpko mhə noien i. ");
INSERT INTO tnk_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kɨmiaha hiamo a nəfe noien tata səkɨmiaha rɨno.” Mɨreɡi irəha həni pen tɨ Iesu i mə, “Rɨpko mhə kɨmaha iəkun iərmwɨn me. Kumwesən in əpa tata səkɨmaha.” ");
INSERT INTO tnk_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Trɨni mɨnuə Kumwesən in tata pərhien səkɨmiaha, kɨmiaha tihokeikei iou tɨ nəri nə mə iou iakuku pen irə muvehe ia kwopun i. Iapkuvehe mhə ia nətərɨɡien atukw səiou, mətə in rɨnərhi pehe iou iakuvehe. ");
INSERT INTO tnk_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Rəfo kɨmiaha hiəreirei nɨpwrai nəɡkiariien i iakani? Hiəreirei tɨ nəri nə mə kɨmiaha hiəpkokeikei anan mhə mə tihətərɨɡ ia nəɡkiariien səiou. ");
INSERT INTO tnk_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kɨmiaha nɨpwnəti Setan me. Hiokeikei mə tihamo a nəkwai tata səkɨmiaha. Fwe kupwən muvehe meste pehe ipwet mɨne in iərmama sə ramousi əpune nərmama. In raməmwəki nɨpərhienien tɨ nəri nə mə nɨpərhienien riwən irə. Nəpɨn in rameikuə, in ramesi pen a noien səvənhi, tɨ nəri nə mə in iərmama səvəi neikuəien, in nukune neikuəien me pam. ");
INSERT INTO tnk_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mətə iou iakani a nəɡkiariien pərhien ro pen kɨmiaha hiəpkɨni mhə nɨpərhienien ia nirak. ");
INSERT INTO tnk_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Sin ia kɨmiaha rukurən no puiien noien ərəha riti iakɨno? Trɨni mɨnuə iakani a nəɡkiariien pərhien me rəfo kɨmiaha hiəpkɨni mhə nɨpərhienien ia nirak? ");
INSERT INTO tnk_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Iərmama sə ruku pen ia Kumwesən, in ramətərɨɡ ia nəɡkiariien səvəi Kumwesən. Mətə kɨmiaha hiəpkuku pen mhə ia Kumwesən ro pen hiəpkətərɨɡ mhə nəɡkiariien səvənhi.” ");
INSERT INTO tnk_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Mɨreɡi nəkur Isrel həni pen tukwe in mə, “Kɨmaha iahaməni atukwatukw ik iəmə Sameria iəremhə ramarə ia niram uə rekəm?” ");
INSERT INTO tnk_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Mɨreɡi Iesu rɨni mə, “Iəremhə riwən ia nirak. Iou iakamsiai tata səiou, mətə kɨmiaha hiəpkɨsiai mhə iou. ");
INSERT INTO tnk_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Iou iapkəmwur mhə mə nərmama tuhəuvehi utə nəɡhɨk. Riti nəha ikɨn in raməmwur tukwe. In Iəmə sə raməkiri nərmama. ");
INSERT INTO tnk_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Iakani nɨpərhienien tukumiaha i. Iərmama sə ramo nəɡkiariien səiou trɨpkemhə mhə ia nəpɨn riti.” ");
INSERT INTO tnk_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Mɨreɡi nəkur Isrel həni pen tukwe in mə, “Təkwtəkwuni nəha kɨmaha iahəukurən mə iəremhə riti ramarə ia niram! Epraham ruvamhə, profet me həuvamhə mwi, mətə ik ikani mə iərmama sə ramo nəɡkiariien səim trɨpkemhə mhə ia nəpɨn riti. ");
INSERT INTO tnk_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Rəfo? Ik ikasori məpi raka tata səkɨtaha Epraham fwe ruvamhə raka? Profet kupwən me irəha mwi həuvamhə raka! Ikuə ik nəfe iərmama?” ");
INSERT INTO tnk_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Trɨni mɨnuə iakuvehi utə atukw a iou nɨsiaiien sə kuvei pehe miou ro nəri auər a i. Mətə Tata səiou in nə Iəmə sə rauvehi utə iou. Kɨmiaha hiaməkwein in mə Kumwesən səkɨmiaha, ");
INSERT INTO tnk_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","mətə kɨmiaha hiəuvəreirei in. Iou iakukurən in. Trɨni mɨnuə iakɨni mə iakreirei in, iou iəmə iakameikuə rəmwhen ia kɨmiaha. Mətə iou iakukurən in, mamo nəɡkiariien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tata səkɨmiaha Epraham rɨnaɡien pɨk nəpɨn rɨməreɡi mə trətoni nəpɨn sə takuvehe irə. In rətoni nənə rerɨn raɡien.” ");
INSERT INTO tnk_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Mɨreɡi nəmə asori me səvəi nəkur Isrel həni pen tukwe in mə, “Nuk səim rɨpkeste mhə ihi fifti! Ikəfo mətoni Epraham?” ");
INSERT INTO tnk_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Iakani nɨpərhienien tukumiaha i nəpɨn Epraham rɨpkətui pehe mhə ihi, iou iakɨnarə raka.” ");
INSERT INTO tnk_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Iesu rɨni nəɡkiariien nəha ro pen irəha həpeki kəruəterei me mə tuhəkwi in irə, mətə Iesu rərkwafə mier ia nimwə səvəi Kumwesən mamevən. ");
INSERT INTO tnk_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Nəpɨn riti Iesu rukurau mətoni iərmama riti nəpɨn rɨnətui pehe irə nənimen rɨfwə. ");
INSERT INTO tnk_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Nənə nərmama me səvəi Iesu həres pen Iesu i mə, “Iahatən. Sin rɨno nərəhaien ro iəmə i rɨnətui pehe nənimen rɨfwə, in uə səvənhi tata mɨne mama?” ");
INSERT INTO tnk_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Mɨreɡi Iesu rɨni mə, “Rɨpko mhə nərəhaien səvəi iəmə i uə nərəhaien səvəi tata mɨne mama səvənhi, mətə in rɨnətui pehe nənimen rɨfwə mə Kumwesən rukurən noien nərmama hətoni nɨskaiien səvənhi nəpɨn tromasan in. ");
INSERT INTO tnk_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nəpɨn ia ran kɨtaha tsaməkeikei mho wok me səvəi Iəmə sə rɨnərhi pehe iou iakuvehe. Nəpitəvien rauvehe. Iərmama riti ko rɨpko mhə wok ia nəpɨn nəha. ");
INSERT INTO tnk_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nəpɨn iakamarə ia tɨprənə, iou nukuraanien sə raməhiəpwɨn nərmama ia tɨprənə.” ");
INSERT INTO tnk_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Iesu rɨni pam nəɡkiariien me nəha, mərɡəvəsi tɨprənə, mo nəmtɨɡei ia nɨsəkwan, nənə muvehi nəmtɨɡei nəha, mahakwi pen ia nəmri iəmə nəha, ");
INSERT INTO tnk_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","mɨni pen tukwe in mə, “Evən ia nui Saeloam, maikuas raka nəmtɨɡei ia nənimem.” Nəhaɡ nəha Saeloam nɨpwran mə “Kərhi pen.” Ro pen iəmə nəha revən, maikuas raka nəmtɨɡei ia nənimen, mɨrərɨɡ muvehe mamətə nari. ");
INSERT INTO tnk_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nənə nəkur imwəni me mɨne səməme hənətoni in ramase mane fwe kupwən kamhəni mə, “Rosi iəmə nəha in nəha fwe kupwən raməkure mamase mane uə rekəm?” ");
INSERT INTO tnk_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Irəha nepwɨn kamhəni mə, “Kwa in nə!” Mətə nepwɨn həni mə, “Rekəm. Rɨpko mhə in, mətə iərmama riti rəmwhen irə.” Mətə iəmə nəha rɨni mə, “Kwa iou i iəmə nəha hiaməni!” ");
INSERT INTO tnk_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ro pen irəha həni pen tukwe in mə, “Kɨnəfo irə nənimem rətui?” ");
INSERT INTO tnk_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Mɨreɡi iəmə nəha rɨni mə, “Iəmə nəha nəɡhɨn nə Iesu ro nəmtɨɡei, mahakwi pehe ia nənimek, mɨni pehe tukw iou i mə, ‘Evən ia nui Saeloam, maikuas raka nəmtɨɡei ia nənimem.’ Ro pen iakevən maikuas raka, nənə mətə nari.” ");
INSERT INTO tnk_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Mɨreɡi irəha həni pen tukwe in mə, “Iəmə nəha in pəku?” Mɨreɡi iəmə nəha rɨni mə, “Iakreirei.” ");
INSERT INTO tnk_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Irəha həiri iəmə nəha fwe kupwən nənimen rɨfwə mhəuvən tɨ Farisi me. ");
INSERT INTO tnk_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","(Sapat riti nəha Iesu rɨno nəmtɨɡei mo nəmri iərmama nəha rətui.) ");
INSERT INTO tnk_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ro iamɨnhi irə Farisi me kənamhəres pen mwi iəmə nəha mə, “Ikɨnəfo mətə nari?” Mɨreɡi in rɨni pen tɨ nirəha i mə, “In rahakwi pehe nəmtɨɡei ia nənimek, iakaikuas raka irə, nənə təkwtəkwuni iakətə nari.” ");
INSERT INTO tnk_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mɨreɡi Farisi me nepwɨn kamhəɡkiari ia Iesu, mamhəni mə, “Iəmə i rɨpko mhə Kumwesən rərhi pehe in tɨ nəri nə mə in rɨpkɨsiai mhə Sapat.” Mətə Farisi me nepwɨn mwi kamhəni mə, “Rəfo? Ko iəmə ərəha riti ro nɨmtətien me iamɨnhi? Rekəm!” Nənə irəha həuai irəha me tɨ nəɡkiariien nəha. ");
INSERT INTO tnk_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ro iamɨnhi irə irəha həni pen mwi tɨ iəmə nəha nənimen rɨfwə fwe kupwən mə, “Ikaməfni irə ia iəmə nəha rɨno nənimem rətui? In nəfe iərmama?” Mɨreɡi iəmə nəha rɨni mə, “In profet riti.” ");
INSERT INTO tnk_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nəmə asori me səvəi nəkur Isrel həpwəh nokeikeiien mə tuhəni nɨpərhienien ia iəmə nəha mə fwe kupwən nənimen rɨfwə, mətə təkwtəkwuni nəha ramətə nari. Ro pen həkwein tata mɨne mama səvənhi, ");
INSERT INTO tnk_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","mhəres pen irau i mə, “Rəfo? In i tɨnɨmirau? Ko kɨmirau irouni mə nɨpərhienien nəpɨn rɨnətui pehe irə nənimen rɨfwə? Nənə mə ro nɨpərhienien rəfo in ramətə nari təkwtəkwuni?” ");
INSERT INTO tnk_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Mɨreɡi tata mɨne mama səvənhi krouni mə, “Kɨmrau iaroukurən mə tɨnɨmrau i. Iaroukurən mwi mə nəpɨn rɨnətui pehe irə nənimen rɨfwə. ");
INSERT INTO tnk_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Mətə təkwtəkwuni in ramətə nari kɨmrau iaroureirei mə rəfo irə. Iaroureirei mwi mə sin rɨno nənimen rətui. Ramasan mə kɨmiaha hiəres pen in i. In ruvəpwinari raka. Pwəh in rɨni nəɡkiariien səvənhi.” ");
INSERT INTO tnk_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","(Tata mɨne mama səvənhi krouni nəɡkiariien me nəha tɨ nəri nə mə krouhekɨr nəmə asori me səvəi nəkur Isrel. Irəha hənərai sun raka mɨnuə iərmama sə trɨni irapw mə Iesu in Kristo, tuhəkoui irapw in, mhəpwəh nəseniien mwi in ruvnimwə pehe ia nimwəfwaki səvənraha.) ");
INSERT INTO tnk_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nəri nəha ro irau krouni ianhi mə, “In ruvəpwinari raka. Ramasan mə kɨmiaha hiəres pen in i.” ");
INSERT INTO tnk_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ro iamɨnhi irə irəha həkwein pen mwi iəmə nəha fwe kupwən nənimen rɨfwə nənə mhəni pen tukwe in mə, “Tikuvehi utə nəɡhi Kumwesən, mɨni nɨpərhienien. Kɨmaha iahəukurən mə iəmə i in iəmə ərəha.” ");
INSERT INTO tnk_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Mɨreɡi in rɨni mə, “Iou iakreirei mə iəmə nəha in iəmə ərəha uə rekəm. Mətə nəri kuatia iou iakukurən. Kupwən nənimek rɨfwə, mətə təkwtəkwuni nəha iakamətə nari.” ");
INSERT INTO tnk_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Mɨreɡi irəha həni pen tukwe in mə, “In rɨno nəfe ia niram? Məfo irə mo nənimem rətui?” ");
INSERT INTO tnk_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Mɨreɡi in rɨni mə, “Iakuvəni pehe raka tukumiaha i, mətə kɨmiaha hiəpkreɡi mhə. Rəfo hiokeikei mə tihəreɡi mwi? Rosi kɨmiaha mwi hiokeikei mə tihəuvehe mho kɨmiaha nərmama me səvənhi uə?” ");
INSERT INTO tnk_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Mɨreɡi irəha həni ərəha iəmə nəha, mhəni mə, “Ik iərmama riti səvənhi, mətə kɨmaha nərmama me səvəi Moses. ");
INSERT INTO tnk_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kɨmaha iahəukurən mə Kumwesən rɨnəɡkiari m Moses, mətə iəmə i kɨmaha iahəreirei mə in ruku pəku.” ");
INSERT INTO tnk_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mɨreɡi iəmə nəha rɨni mə, “Kwa nəri i ro nari riti. Kɨmiaha hiəreirei mə iəmə i ruku pəku, mətə in rɨno nənimek rətui. ");
INSERT INTO tnk_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kɨtaha səukurən mə Kumwesən rɨpkreɡi mhə nəfwakiien me səvəi nəkur ərəha me, mətə trɨni mɨnuə iərmama riti ramsiai Kumwesən, mamo nəkwan, Kumwesən ramreɡi nəfwakiien me səvənhi. ");
INSERT INTO tnk_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Fwe kupwən kɨno tɨprənə meste pehe ipwet kɨpkreɡi raka mhə mə iərmama riti ro nəmri iərmama sə nənimen rɨfwə rətui. ");
INSERT INTO tnk_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Mə iəmə i rɨpkuku pen mhə tɨ Kumwesən in ko rɨpko mhə nari riti.” ");
INSERT INTO tnk_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Mɨreɡi irəha həni pen tukwe in mə, “Kwa ik iəmə ərəha fwe nəpɨn ikɨnətui pehe irə meste pehe ipwet. Ikuə tikəfo? Tikahatən kɨmaha uə?” Nənə irəha həkoui irapw in ia nimwəfwaki, mhəpwəh nəseniien mwi in ruvnimwə pehe. ");
INSERT INTO tnk_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Kɨni pen tɨ Iesu i mə irəha həkoui irapw iəmə nəha iamɨnhi. Ro pen in revən mətui iəmə nəha, mətoni, mɨni pen tukwe in mə, “Ikɨni nɨpərhienien ia Iəməti Iərmama uə rekəm?” ");
INSERT INTO tnk_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mɨreɡi iəmə nəha rɨni mə, “Iəmə asori. Ni pehe ro tukw iou i mə sin nə Iəməti Iərmama pwəh iakɨni nɨpərhienien irə.” ");
INSERT INTO tnk_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Mɨreɡi Iesu rɨni pen tukwe in mə, “Ikɨnətə raka in. Iou i sə iakaməɡkiari mik, iou Iəməti Iərmama.” ");
INSERT INTO tnk_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mɨreɡi iəmə nəha rɨni mə, “Iərɨmənu. Iakɨni nɨpərhienien ia niram.” Nənə in rɨnɨmwi nukurhun mi ia nəmri Iesu, mɨsiai in. ");
INSERT INTO tnk_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Iesu rɨni mə, “Iou iakuvehe ia tɨprənə i mə takəkiri nərmama. Səməme nənimenraha rɨfwə tuhətui mhətə nari, mətə səməme hamətə nari nənimenraha truvehe mɨfwə.” ");
INSERT INTO tnk_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisi me nepwɨn ipaka tɨ Iesu həreɡi nəɡkiariien nəha, nənə mhəni pen tukwe in mə, “Kɨmaha mwi nənimemaha rɨfwə uə rekəm?” ");
INSERT INTO tnk_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Ko nəmrɨmiaha rɨfwə ko nərəhaien səkɨmiaha riwən. Mətə tɨ nəri nə mə təkwtəkwuni kɨmiaha hiaməni mə hiamətə nari nərəhaien səkɨmiaha raməmak ihi ia kɨmiaha.” ");
INSERT INTO tnk_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Iakani nɨpərhienien tukumiaha i. Iərmama sə rɨpkukurau mhə ia kwəruə muvnimwə ia koupə səvəi sipsip me, mətə rəputə ia kwopun əpə iti mati pen ia nəkwai koupə nəha, iərmama nəha in iərmama sə ramakres, mamousi iərmama. ");
INSERT INTO tnk_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Mətə iərmama sə rukurau ia kwəruə muvnimwə ia koupə, in iərmama sə ramətui tɨ sipsip me. ");
INSERT INTO tnk_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Iərmama sə ramərer ia kwəruə raməsevər ia təpinhə tɨ iərmama nəha. Sipsip me kamhəreɡi rerɨn. In raməkwein nəɡhi sipsip me səvənhi kuatia kuatia, nənə miri irəha mhəier. ");
INSERT INTO tnk_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nəpɨn in riri səvənhi sipsip me pam mhəier, makupwən ia nirəha, nənə sipsip me kamhəkurirə in, tɨ nəri nə mə həukurən rerɨn. ");
INSERT INTO tnk_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Iərməpə riti sipsip me tuhəpwəh nukurirəien in, mətə tuhap raka irə tɨ nəri nə mə həreirei rerɨn.” ");
INSERT INTO tnk_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesu rɨni nusipekɨnien i tɨ nirəha, mətə irəha həreirei nəfe nəha rani. ");
INSERT INTO tnk_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ro pen Iesu rɨni pen mwi tɨ nirəha i mə, “Iakani nɨpərhienien tukumiaha i. Iou kwəruə səvəi sipsip me. ");
INSERT INTO tnk_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Irəha pam səməme haməkupwən ia nirak mhəuvehe irəha nərmama səməme kənamhakres, mamhousi iərmama, mətə sipsip me həpkətərɨɡ mhə irəha. ");
INSERT INTO tnk_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Iou kwəruə. Trɨni mɨnuə iərmama riti ruvnimwə pehe ia nirak, in trarə amasan, mukurən nuvnimwə peheien, mɨtei irapw, mətui nəveɡɨnien sənəni. ");
INSERT INTO tnk_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Iərmama nəha ramakres rauvehe a mə trakres, mousi əpune sipsip me, mouraha irəha. Mətə iou iakuvehe mə irəha tuhəuvehi nɨmɨruien nənə mhəuvehi asori. ");
INSERT INTO tnk_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Iou iərmama sə iakamətui amasan tɨ sipsip me. Iərmama sə ramətui amasan tɨ sipsip me rerɨn raɡien a mə tremhə tɨ sipsip me səvənhi. ");
INSERT INTO tnk_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mətə iərmama sə kamərəku pen min mə trətui tɨ sipsip me rɨpko mhə in iərmama pərhien sə ramətui tɨ sipsip me tɨ nəri nə mə sipsip me nəha səvəi iərməpə. Nəpɨn iərmama nəha rətə kuri əprmɨn riti rauvehe, rəpwəh sipsip me maiu map. Nənə kuri əprmɨn nəha ruvehe muvehi nepwɨn, mɨrɨpwi kɨrkɨri nepwɨn. ");
INSERT INTO tnk_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Iərmama nəha raiu map tɨ nəri nə mə in iərmama riti kamərəku a in. In ro nəri auər a ia sipsip me nəha. ");
INSERT INTO tnk_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Iou iərmama sə ramətui amasan tɨ sipsip me. Iou iakukurən sipsip me səiou, sipsip me səiou həukurən mwi iou. ");
INSERT INTO tnk_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ia noien nəha rəmwhen a mwi Tata Kumwesən rukurən iou, iou mwi iakukurən Tata Kumwesən, nənə iou rerɨk raɡien a mə takemhə tɨ sipsip me səiou. ");
INSERT INTO tnk_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Səiou me nepwɨn sipsip me həiwən ia koupə i. Takaməkeikei mɨpeki pehe mwi irəha, nənə irəha tuhəreɡi rerɨk. Ro iamɨnhi irə sipsip me nəha tuhəuvehe mho touen kuatia. Iərmama kuatia tramətui tɨ nirəha. ");
INSERT INTO tnk_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tata Kumwesən rokeikei pɨk iou tɨ nəri nə mə rerɨk raɡien a mə takemhə tɨ nirəha. Takemhə tɨ nirəha, nənə marə muvehi mwi nɨmɨruien səiou rɨrərɨɡ. ");
INSERT INTO tnk_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Rɨpko mhə iərmama riti truvehi raka nɨmɨruien səiou, mətə iou atukw takəseni pen nɨmɨruien səiou rəmwhen sə iakokeikei. Iakauvehi nasoriien tɨ nəseniien nɨmɨruien səiou, mauvehi mwi nasoriien tɨ nuvehiien mwi nɨmɨruien səiou rɨrərɨɡ. In i nəri Tata səiou rɨməni tukw iou i mə takaməkeikei mo.” ");
INSERT INTO tnk_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Iesu rɨni pam nəɡkiariien me nəha nənə nəmə asori me səvəi nəkur Isrel həuai mwi irəha me tukwe. ");
INSERT INTO tnk_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Irəha həpɨk həni mə, “Iəmə nəha iəremhə ramarə irə. In ramarməri. Rəfo kɨmiaha hiamətərɨɡ in?” ");
INSERT INTO tnk_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mətə irəha nepwɨn həni mə, “Rekəm. Iərmama sə iəremhə riti ramarə irə ko rɨpkəɡkiari mhə iamɨnhi. Ko iəremhə riti ro iərmama nənimen rɨfwə rətui mətə nari?” ");
INSERT INTO tnk_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nəpɨn nəha ruvəuvehe nəkur Isrel kamho nəveɡɨnien asori nəha kani mə Nəveɡɨnien səvəi Tetekesen. Kamho nəveɡɨnien nəha fwe Jerusalem ia nəpɨn səvəi nəkwieiien. ");
INSERT INTO tnk_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Iesu ramavən ia kwopun riti ia nimwə səvəi Kumwesən kani mə Vranda səvəi Solomon. ");
INSERT INTO tnk_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nənə nəmə asori me səvəi nəkur Isrel həuvehe mheikurkurau irə, mhəni pen tukwe in mə, “Kɨmaha tahameitenhi ik mɨnesən? Trɨni mɨnuə ik Kristo sə Kumwesən rɨməni mə trərhi pehe i, ni pehe tukumaha i, məpwəh nərkwafəien.” ");
INSERT INTO tnk_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Iakuvəni raka tukumiaha i, mətə kɨmiaha hiəpkɨni mhə nɨpərhienien ia nirak. Narimnari me nəha səməme iakamo ia nəɡhi Tata səiou kamhahatən pen mə iou sin. ");
INSERT INTO tnk_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Mətə kɨmiaha hiəpkɨni mhə nɨpərhienien ia nirak tɨ nəri nə mə rɨpko mhə kɨmiaha sipsip me səiou. ");
INSERT INTO tnk_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Sipsip me səiou kamhəreɡi rerɨk. Iou iakukurən irəha, nənə irəha kamhəkurirə iou. ");
INSERT INTO tnk_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Iakauvei pen nɨmɨruien rerɨn mɨnraha. Irəha tuhəpkemhə mhə ia nəpɨn riti. Iərmama riti riwən truvehi raka irəha ia rəɡɨk. ");
INSERT INTO tnk_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tata səiou sə ruvei pehe irəha miou, nɨskaiien səvənhi rəpi raka nərmama me pam. Iərmama riti riwən ko ruvehi raka irəha ia rəɡɨn. ");
INSERT INTO tnk_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Iou mɨne Tata səiou kɨmrau kuatia.” ");
INSERT INTO tnk_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ia nəpɨn nəha nəmə asori me səvəi nəkur Isrel həpeki mwi kəruəterei me mə tuhəkwi əpune in. ");
INSERT INTO tnk_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Iakɨno raka noien amasan me rɨpɨk ia nəmrɨmiaha Tata Kumwesən ruvei pehe mə tako. Sə rəfo nəha mə tihəkwi əpune iou tukwe?” ");
INSERT INTO tnk_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Mɨreɡi nəmə asori me səvəi nəkur Isrel həni pen tukwe in mə, “Kɨmaha tahəpkəkwi əpune mhə ik tɨ noien amasan riti sə ikɨno, mətə kɨmaha tahəkwi əpune ik tɨ nəri nə mə ikani ərəha Kumwesən. Ik iərmama a, mətə ikani mə ik Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Rosi kɨmiaha hiəpkəvsini raka mhə nəɡkiariien i kɨmərai pen ia Loa səkɨmiaha uə? Rɨni iamɨnhi irə mɨnuə ‘Iakɨni mɨnuə kɨmiaha nə kumwesən me.’ ");
INSERT INTO tnk_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","36","Kɨtaha səukurən mə nəfe Nəkukuə Ikinan rani ko kɨpkətefi mhə. Ro iamɨnhi irə mə Kumwesən rɨnəkwein nərmama me nəha səməme in rɨməuvei pen nəɡkiariien səvənhi mɨnraha mɨnuə ‘kumwesən me,’ rəfo kɨmiaha hiaməni ərəha iou? Iou iərmama i Kumwesən ruvərfi raka iou, mərhi pehe iou iakuvehe ia tɨprənə i, mətə kɨmiaha hiaməni mə iakani ərəha in, tɨ nəri nə mə iakɨni mə, ‘Iou Tɨni Kumwesən.’ ");
INSERT INTO tnk_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Mə iou iapko mhə narimnari me səiou Tata rokeikei mə tako rərəha mə kɨmiaha hiəni nɨpərhienien ia nirak. ");
INSERT INTO tnk_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Mətə mə iakamo narimnari me nəha, pərhien hiəpkɨni mhə nɨpərhienien ia nirak, mətə tihaməkeikei mhəni nɨpərhienien ia narimnari me nəha sə iakamo. Ia noien i kɨmiaha tihəukurən, mhəukurən amasan mə Tata Kumwesən in i ia nirak iou nə irə.” ");
INSERT INTO tnk_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Irəha haməmwur mwi mə tuhəkwtəmhiri Iesu, mətə in ramkeies raka ia rəɡɨnraha, ");
INSERT INTO tnk_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","mavən məpi sɨmwɨn mwi ia nui arɨs Jotan, mevən ia kwopun nəha Jon ramo paptaes ikɨn fwe kupwən, mamarə ia kwopun nəha. ");
INSERT INTO tnk_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nərmama həpɨk həuvehe tukwe, mhəni mə, “Jon rɨpko nɨmtətien riti, mətə nəɡkiariien me pam səməme in rɨməni ia iəmə i ho nɨpərhienien.” ");
INSERT INTO tnk_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ro pen nərmama həpɨk ia kwopun nəha həni nɨpərhienien ia Iesu. ");
INSERT INTO tnk_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Iərmama riti ramemhə nəɡhɨn nə Lasaros. Imwəni fwe Petani. Petani in rukwənu səvəi Meri mɨne piəvi Meri nəɡhɨn nə Marta. ");
INSERT INTO tnk_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Meri nəha in pran sə rɨnətəɡi pen senta ia nɨsui Iərɨmənu səkɨtaha, mahakwi raka ia nɨmwai nukwənen. Lasaros nəha in kɨtiriməni. ");
INSERT INTO tnk_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lasaros ramemhə iamɨnhi irə ro pen kɨtiriməni mi nəha krouərhi pen nəɡkiariien riti revən tɨ Iesu, rouni mə, “Iərɨmənu. Ik riti sə ikokeikei pɨk ramemhə.” ");
INSERT INTO tnk_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Mətə nəpɨn Iesu rɨreɡi nəɡkiariien nəha, rɨni mə, “Nemhəien i ko rɨpko mhə Lasaros remhə anan. Ramarə irə mə nərmama tuhətoni nasoriien səvəi Kumwesən. Nemhəien i in suatuk sə Kumwesən truvehi utə nəɡhi Tɨni irə.” ");
INSERT INTO tnk_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iesu rokeikei pɨk Marta mɨne piəvni Meri mɨne kɨtirimənrau Lasaros. ");
INSERT INTO tnk_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ro iamɨnhi irə nəpɨn in rɨreɡi mə Lasaros ramemhə, in rarə mwi nəpɨn kəru mwi ia kwopun nəha in ramarə ikɨn. ");
INSERT INTO tnk_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nəpɨn nəha kəru rukurau nənə in rɨni pen tɨ nərmama me səvənhi mə, “Pwəh səuvən mwi fwe tənə Jutia.” ");
INSERT INTO tnk_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Mɨreɡi nərmama me səvənhi həni pen tukwe in mə, “Iahatən. Təkwtəkwuni a kwərha nəmə asori me ia Jutia hokeikei mə tuhəkwi əpune ik ia kəruəterei me. Mətə ikokeikei mə tikrərɨɡ mevən mwi fwe ikɨn?” ");
INSERT INTO tnk_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Mɨreɡi Iesu rɨni mə, “Kɨmiaha hiəukurən mə aoa twelef ia ran. Trɨni mɨnuə iərmama riti ramavən ia ran, trɨpkapəti mhə tɨ nəri nə mə in ramətə nukuraanien sə raməhiəpwɨn nərmama ia tɨprənə i. ");
INSERT INTO tnk_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Mətə trɨni mɨnuə iərmama riti ramavən ia nəpɨn in trapəti tɨ nəri nə mə nukuraanien nəha riwən irə.” ");
INSERT INTO tnk_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Iesu rɨni pam nəɡkiariien me nəha, marɨpɨn mani pen tɨ nirəha i mə, “Kɨtaha riti Lasaros ramapri, mətə iakɨnamevən takəsuəpwiri in.” ");
INSERT INTO tnk_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Mɨreɡi nərmama me səvənhi həni pen tukwe in mə, “Iərɨmənu. Trɨni mɨnuə in ramapri in truvehe məsanɨn.” ");
INSERT INTO tnk_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","(Iesu rəɡkiari ia Lasaros mə ruvamhə, mətə rerɨnraha ramrhi mə nɨpwrai nəɡkiariien səvənhi mə in ramapri a.) ");
INSERT INTO tnk_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ro pen Iesu rɨni pen atukwatukw tɨ nirəha i mə, “Lasaros ruvamhə. ");
INSERT INTO tnk_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nənə nəpɨn rerɨk rɨrhi kɨmiaha, iakaɡien mə iou iapkarə mhə ia kwopun nəha nəpɨn remhə irə. Nəri nəha trasitu ia kɨmiaha mo kɨmiaha hiəni nɨpərhienien ia nirak. Mətə pwəh səuvən tukwe.” ");
INSERT INTO tnk_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ro iamɨnhi irə Tomas nəha kani in mə “Mwirmwir,” rɨni pen tɨ nərmama me nəha irəha min kamhəkurirə ia Iesu mə, “Ramasan. Pwəh kɨtaha pam səuvən mhemhə kɨtaha min.” ");
INSERT INTO tnk_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nənə Iesu rapirapw ia Petani mətoni Lasaros rɨnəmak nəpɨn kefə raka ia nɨpəɡi kəruəterei. ");
INSERT INTO tnk_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Rukwənu nəha Petani ipaka tɨ Jerusalem, kavən rəmwhen ia kilometa kahar. ");
INSERT INTO tnk_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Nəkur Isrel me həpɨk həməuvehe tɨ Marta mɨne Meri mə tuhəɡkiari vivi mɨnrau tɨ nəri nə mə kɨtirimənrau ruvamhə. ");
INSERT INTO tnk_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ro iamɨnhi irə nəpɨn Marta rɨreɡi mə Iesu rauvehe, in revən mətə in. Mətə Meri raməkure a ia nəkwai nimwə. ");
INSERT INTO tnk_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta rɨni pen tɨ Iesu i mə, “Iərɨmənu. Ko ramo ik ia kwopun i ko kɨtirimak rəpwəh nemhəien. ");
INSERT INTO tnk_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mətə iou iakukurən mə təkwtəkwuni nəfe nəɡhɨn tikəres Kumwesən tukwe, in truvei pehe mik.” ");
INSERT INTO tnk_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Mɨreɡi Iesu rɨni pen tukwe in mə, “Kɨtirimam trətui mwi ia nemhəien səvənhi.” ");
INSERT INTO tnk_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mɨreɡi Marta rɨni pen tukwe in mə, “Iou iakukurən mə in trətui mwi ia nəpɨn sampam, nəpɨn nərmama tuhətui mwi ia nemhəien.” ");
INSERT INTO tnk_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Mɨreɡi Iesu rɨni pen tukwe in mə, “Iou iərmama i iakamo nərmama səməme həuvamhə hətui mwi ia nemhəien. Iou nɨmɨruien. Iərmama sə rani nɨpərhienien ia nirak nəri auər a mə remhə mətə trɨmɨru. ");
INSERT INTO tnk_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nənə iərmama sə ramɨru, mani nɨpərhienien ia nirak, trɨpkemhə mhə ia nəpɨn riti. Ikɨni nɨpərhienien ia nəɡkiariien i?” ");
INSERT INTO tnk_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mɨreɡi Marta rɨni pen tukwe in mə, “Ouəh, Iərɨmənu. Iakani nɨpərhienien mə ik iəmə i kani mə Kristo. Ik Tɨni Kumwesən. Ik iəmə i profet kupwən me həməni mə tikuvehe ia tɨprənə i.” ");
INSERT INTO tnk_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta rɨni nəɡkiariien nəha, nənə mərari mevən mə trəkwein piəvni Meri. In revən məɡkiari afafa min, mɨni mə, “Iahatən səkrau in i ruvəuvehe, maməres ik.” ");
INSERT INTO tnk_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nənə nəpɨn Meri rɨreɡi nəɡkiariien nəha, rɨskəmter akwauakw, mevən tɨ Iesu. ");
INSERT INTO tnk_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Iesu rɨpkuvehe mhə ihi ia rukwənu nəha, mətə ramərer ihi ia kwopun nəha Marta rɨnətoni in ikɨn. ");
INSERT INTO tnk_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Nəkur Isrel me nəha səməme kamhəkure irəha Meri ia nəkwai nimwə mamhəɡkiari vivi min, hətoni Meri rɨskəmter akwauakw mier irapw iruə. Ro pen irəha həkurirə in. Rerɨnraha ramrhi mə rosi in ramevən mə trasək ia kwopun kɨnərkwafə nɨpwrai kɨtiriməni ikɨn. ");
INSERT INTO tnk_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Nəpɨn Meri ruvehe ia kwopun nəha Iesu ramərer ikɨn, mətoni, in rɨnɨmwi nukurhun mi ia nənimen, mɨni pen tukwe in mə, “Iərɨmənu. Ko ramo ik ia kwopun i ko kɨtirimak rəpwəh nemhəien.” ");
INSERT INTO tnk_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ia nəpɨn nəha Meri ramasək. Nəkur Isrel me nəha səməme həuvehe irəha min irəha mwi kamhasək. Iesu rətoni rerɨn rərkwəpɨr, meiahaɡ əfi tukwe, ");
INSERT INTO tnk_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","mɨni mə, “Kɨmiaha hiənərkwafə nɨpwran pəku?” Mɨreɡi irəha həni pen tukwe in mə, “Iərɨmənu. Uvehe mətoni.” ");
INSERT INTO tnk_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iesu rasək. ");
INSERT INTO tnk_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ro pen nəkur Isrel me həni mə, “Hətoni ro. Rosi in rokeikei pɨk anan Lasaros.” ");
INSERT INTO tnk_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Mətə irəha nepwɨn həni mə, “Iəmə i rɨnomasan raka iərmama riti nənimen rɨfwə. Rəfo in rɨpkomasan mhə mwi Lasaros mə trəpwəh nemhəien?” ");
INSERT INTO tnk_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ro iamɨnhi irə Iesu rɨreɡi mwi rərəha anan. In ruvehe ia kwopun kɨnərkwafə nɨpwrai Lasaros ikɨn. Kɨnərkwafə nɨpwran ia nɨpəɡi kəruəterei riti. Nənə kəruəterei riti mwi ramərer tukuahaɡ tərhui nɨpəɡ nəha. ");
INSERT INTO tnk_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Iesu rɨni mə, “Həuvehi raka kəruəterei nəha.” Mətə Marta, kɨtiriməi iəmə nəha sə ruvamhə, rɨni pen tukwe in mə, “Iərɨmənu. In ruvəpein raka. In i nəpɨn sə ro kefə səvənhi.” ");
INSERT INTO tnk_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Mɨreɡi Iesu rɨni pen tukwe in mə, “Rosi ikɨnenouenou nəfe iakɨməni pehe tukw ik uə? Trɨni mɨnuə ikɨni nɨpərhienien ia nirak, tikətə nasoriien səvəi Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ro iamɨnhi irə irəha həuvehi raka kəruəterei nəha. Nənə Iesu rəkwətə, mɨni mə, “Tata. Iakani tanak tukw ik tɨ nəri nə mə ikuvəreɡi raka iou. ");
INSERT INTO tnk_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Iakukurən mə ikamreɡi iou ia nəpɨn me pam, mətə iakani nəɡkiariien i mə trasitu ia nərmama me i kamhərer kuraukurau. Iakuə irəha tuhəni nɨpərhienien mə ikɨnərhi pehe iou.” ");
INSERT INTO tnk_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nəpɨn Iesu rɨni pam nəɡkiariien me nəha, rəkwein əpwəmwɨs, mɨni mə, “Lasaros! Ier irapw!” ");
INSERT INTO tnk_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nənə iəmə nəha sə ruvamhə rier irapw. Tɨnari me nəha sə kɨnərkwi rəɡɨn mi mɨne nɨsun mi irə mɨne sə nəha kɨnərkwi nənimen irə kamhəmak ihi ia nɨpwran. Nənə Iesu rɨni pen tɨ nirəha i mə, “Həfi raka tɨnari irə, pwəh ravən.” ");
INSERT INTO tnk_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nəkur Isrel me nəha səməme həməuvehe mhəti pehe Meri irəha həpɨk hətoni nəfe Iesu rɨno, nənə mhəni nɨpərhienien ia Iesu. ");
INSERT INTO tnk_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Mətə irəha nepwɨn həuvən tɨ Farisi me, mhəni pen nəfe Iesu rɨno. ");
INSERT INTO tnk_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ro iamɨnhi irə pris asori me mɨne Farisi me housəsɨmwɨn nəmə asori me səvəi nəkur Isrel, mhəni mə, “Kɨtaha tsəfo i? Kwa iəmə i ramo nɨmtətien me rɨpɨk. ");
INSERT INTO tnk_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Trɨni mɨnuə kɨtaha səseni in ramo iamɨnhi irə marɨpɨn, nərmama me pam tuhəni nɨpərhienien irə. Nənə nəkur Rom tuhəuvehe mhouraha nimwəfwaki səkɨtaha mɨne nərmama me səkɨtaha.” ");
INSERT INTO tnk_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Mətə irəha riti nəɡhɨn nə Kaeafas in rauvehi wok səvəi pris asori anan ia nuk nəha. In rɨni pen tɨ nirəha i mə, “Kɨmiaha hiəreirei nari. ");
INSERT INTO tnk_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Rəfo kɨmiaha hiəpkətə mhə mhəukurən? Ko iərmama kuatia remhə tɨ nəkur Isrel ramasan məpi raka kousi əpune kɨtaha nəkur Isrel me pam.” ");
INSERT INTO tnk_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaeafas rɨpkɨni atukw mhə nəɡkiariien i, mətə in rauvehi wok səvəi pris asori anan ia nuk nəha, mani irapw nəɡkiariien sə ruku pen tɨ Nənɨmwɨn Ikinan. Nəri nəha rɨpkier pehe mhə ihi, mətə in rukupwən mɨni irapw mə Iesu tremhə tɨ nəkur Isrel. ");
INSERT INTO tnk_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Mətə in trɨpkemhə mhə tɨ nirəha əpa nəkur Isrel, in tremhə mwi tɨ nɨpwnəti Kumwesən me səməme kamharə kɨrkɨri ia tənəmtənə me, nənə mousəsɨmwɨn irəha ia kusen kuatia. ");
INSERT INTO tnk_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ia nəpɨn nəha nəmə asori me nəha hənamrai sun mə tuhousi əpune Iesu. ");
INSERT INTO tnk_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ro iamɨnhi irə Iesu rəpwəh navən irapwien ia nəmri nəkur Isrel ia tənə Jutia, mətə in rəpwəh tənə səvənraha mevən ia taon riti nəɡhɨn nə Efrem. Taon nəha ipaka tɨ kwopun akwesakwes ikɨn. Iesu ramarə ikɨn irəha nərmama me səvənhi. ");
INSERT INTO tnk_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nəveɡɨnien asori nəha səvəi nəkur Isrel nəɡhɨn nə Pasova ruvəuvehe ipaka. Ro pen nərmama həpɨk həier ia kwopun me mhəutə pen fwe Jerusalem mə tuho irəha həmher ia nəmri Kumwesən kurirə Pasova ruvehe. ");
INSERT INTO tnk_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Irəha kamhərer ia nimwə səvəi Kumwesən, mamhətui Iesu, mamhəɡkiari mɨnraha me, mamhəni mə, “Kɨmiaha hiaməfətərɨɡ irə? Rosi ko in rɨpkuvehe mhə ia nəveɡɨnien asori uə?” ");
INSERT INTO tnk_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Irəha həni ianhi tɨ nəri nə mə pris asori me mɨne Farisi me həuvəni raka nəkwanraha mə trɨni mɨnuə iərmama riti rukurən kwopun Iesu ramarə ikɨn traməkeikei mɨni pen tɨ nirəha i nənə irəha tuhəuvən mhəkwtəmhiri in. ");
INSERT INTO tnk_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nəpɨn sikis a mwi nəveɡɨnien asori nəha Pasova ruvehe. Ro pen Iesu revən ia Petani, imwei Lasaros. Lasaros nə iəmə sə Iesu rɨnəsuəpwiri in ia nemhəien. ");
INSERT INTO tnk_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Irəha həpnəpenə nəveɡɨnien riti sənəi Iesu fwe ikɨn. Marta rasui raka nəveɡɨnien. Lasaros in mwi riti ia nərmama me nəha səməme kamhani pəri nari irəha min. ");
INSERT INTO tnk_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ia nəpɨn nəha Meri ruvehi nɨpəri senta kɨno ia nat atukwatukw nənimen rutə pɨk. In ruvehi mətəɡi pen ia nɨsui Iesu mi, nənə mɨnamrai nɨsun mi ia nɨmwai nukwənen. Nəkwai nimwə ruvehe mukuər ia nɨpeki senta. ");
INSERT INTO tnk_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Mətə iərmama riti səvəi Iesu, nəɡhɨn nə Jutas Iskariot, iəmə nəha rɨpko mhə tui truvei pen Iesu ia rəɡi nərmama səməme haməmwəki in, in rɨni mə, ");
INSERT INTO tnk_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Rəfo kɨpkəmri pen mhə nəmri nari ia senta nəha? Kukurən nuvehiien silin me kɨno ia silva irəha pam tri hantret, kuvei pen m nərmama nautə səvənraha riwən.” ");
INSERT INTO tnk_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Jutas rɨpkɨni mhə nəɡkiariien nəha tɨ nəri nə mə in rokeikei mə trasitu ia nərmama nautə səvənraha riwən. Mətə in rɨni nəɡkiariien nəha tɨ nəri nə mə in rauvehi tənərɨpw irəha kamhəvai pen mane irə, nənə nəpɨn nepwɨn ramakres afafa nɨpərɨn səvənhi. ");
INSERT INTO tnk_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Mətə Iesu rɨni mə, “Əpwəh nəskiien prən i. In rɨno nəri i rerɨn ramrhi nəpɨn tukɨnɨmwi iou irə. ");
INSERT INTO tnk_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nərmama nautə səvənraha riwən tiharə kɨmiaha mɨnraha nəpɨn me, mətə iou tapkarə pəri mhə kɨtaha m kɨmiaha nəpɨn me.” ");
INSERT INTO tnk_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nəkur Isrel me həpɨk həreɡi mə Iesu in ia kwopun nəha, həreɡi həuvən tukwe. Irəha həpkəuvən mhə mə tuhətoni Iesu əpa, mətə həuvən mə tuhətoni mwi Lasaros. Lasaros nə in iəmə sə Iesu rɨnəsuəpwiri in ia nemhəien. ");
INSERT INTO tnk_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Pris asori me hərai sun mə tuhousi əpune Lasaros mwi, ");
INSERT INTO tnk_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","tɨ nəri nə mə nəkur Isrel me həpɨk, nəpɨn hətoni mə in ruvəmɨru mwi, həni nɨpərhienien ia Iesu, nənə mhəpwəh nukurirəien nəmə asori me səvənraha. ");
INSERT INTO tnk_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kɨni rakwakwi irə, nərmama me nəha səməme həuvən tɨ nəveɡɨnien asori nəha Pasova həreɡi mə Iesu rauvehe ia Jerusalem. Nərmama me nəha həpɨk. ");
INSERT INTO tnk_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Həuvehi nɨmwai nəmwɨr mhəuvehi mhəier ia taon mhəuvən mhətə in rauvehe ia suatuk, kamhəkwein əpwəmwɨs mə, “Səɡnəɡɨni Kumwesən! Səkwein amasan ia iəmə i rauvehe ia nəɡhi Iərɨmənu səkɨtaha! Səkwein amasan irə, in kiɡ səvəi nəkur Isrel!” ");
INSERT INTO tnk_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iesu rətə kwəti toɡki riti nənə rəkure irə. Nəri nəha ramesi pen nəɡkiariien i kɨmərai pen ia Nəkukuə Ikinan. Rɨni iamɨnhi irə mɨnuə, ");
INSERT INTO tnk_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Nəkur Saeon tihəpwəh nehekɨrien. Hətə ro kiɡ səkɨmiaha rauvehe, maməkure ia kwəti toɡki riti.” ");
INSERT INTO tnk_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ia nəpɨn nəha nərmama me səvəi Iesu həreirei nɨpwrai narimnari me i. Mətə kurirə irə, kuvehi utə raka Iesu revən fwe ia neiai, rerɨnraha rɨrhi mə kɨmərai pen narimnari me i ia Nəkukuə Ikinan raməɡkiari irə. Rerɨnraha rɨrhi mwi mə nərmama me həno narimnari me i irə. ");
INSERT INTO tnk_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Iesu rɨno Lasaros rətui mwi ia nemhəien səvənhi. Nərmama me nəha səməme kamhərer irəha min ia nəpɨn nəha in rɨnəkwein Lasaros irə mə trier ia nɨpəɡi kəruəterei irəha kamhərɨpɨn mamhəni irapw nəfe irəha hənətoni. ");
INSERT INTO tnk_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nərmama həpɨk hənuə tuhətoni Iesu tɨ nəri nə mə irəha kamhəreɡi mə in rɨno nɨmtətien nəha. ");
INSERT INTO tnk_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ro iamɨnhi irə Farisi me kamhəni pen tɨ nirəha me i mə, “Hətoni ro, kɨtaha ko səpko anan mhə nari riti! Təkwtəkwuni nəha nərmama me pam kamhəkurirə in!” ");
INSERT INTO tnk_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nəkur Kris me nepwɨn nəha ikɨn kamhəfwaki irəha nərmama me nəha səməme həməutə pen fwe Jerusalem tɨ nəveɡɨnien asori. ");
INSERT INTO tnk_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nəkur Kris me nəha həuvehe tɨ Filip. (Filip imwəni fwe Petsaeta ia tənə Kalili.) Həuvehe mhəni pen tukwe in mə, “Iəmə asori. Kɨmaha iahokeikei mə tahətoni Iesu.” ");
INSERT INTO tnk_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ro iamɨnhi irə Filip revən mɨni pen tɨ Antru, nənə rouevən rouni pen tɨ Iesu. ");
INSERT INTO tnk_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Nənə Iesu rɨni pen tɨ nirəha i mə, “Təkwtəkwuni nəha nəpɨn sə Kumwesən truvehi utə nəɡhi Iəməti Iərmama irə ruvəuvehe. ");
INSERT INTO tnk_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Iakani nɨpərhienien tukumiaha i. Nuni nari riti ko rɨpkukuə mhə kwənkwan trɨni mɨnuə rɨpkukupwən mhə mɨmwei irapw ia tɨprənə memhə. Mətə mə remhə trukuə kwənkwan rɨpɨk. ");
INSERT INTO tnk_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Iərmama sə rokeikei pɨk nɨmɨruien səvənhi trarfai irə, mətə iərmama sə rəmwəki nɨmɨruien səvənhi ia tɨprənə i in trəkwtəmhiri nɨmɨruien səvənhi mamevən muvehi nɨmɨruien rerɨn. ");
INSERT INTO tnk_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Iərmama sə ramo tukwini nari miou traməkeikei mukurirə iou. Nənə kwopun pəku iakamarə ikɨn iərmama sə ramo tukwini nari miou in mwi trarə ikɨn. Iərmama sə ramo tukwini nari miou Tata Kumwesən trɨsiai in. ");
INSERT INTO tnk_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Təkwtəkwuni nəha iakreɡi rərəha anan. Nənə takəfni mwi irə? Ko iakɨni mə ‘Tata uvehi raka nəmisəien sə rauvehe tukw iou’? Rekəm, kwa in nə iakɨməuvehe tukwe mə nəpɨn i treste iou iamɨnhi irə. ");
INSERT INTO tnk_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tata uvehi utə nəɡhɨm!” Təkwtəkwuni a mwi kreɡi nəɡkiariien riti ruku pen ia neiai muvehe. Nəɡkiariien nəha rɨni mə, “Iou iakuvəuvehi utə raka nəɡhɨk, nənə təkwtəkwuni nəha takuvehi utə mwi.” ");
INSERT INTO tnk_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nərmama səməme kamhərer ipaka tukwe həreɡi həni mə, “Kwa karuəruə!” Nepwɨn həni mə, “Aɡelo riti rəɡkiari pen min.” ");
INSERT INTO tnk_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “nəɡkiariien nəha rɨpkuvehe mhə mə iou takreɡi. Mətə ruvehe mə kɨmiaha tihəreɡi. ");
INSERT INTO tnk_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Təkwtəkwuni nəha rɨno nəpɨn sə Kumwesən trərpwɨn noien ərəha me kamo ia tɨprənə i. Təkwtəkwuni nəha in trəkoui irapw Setan sə ramərɨmənu ia tɨprənə i. ");
INSERT INTO tnk_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nənə iou, nəpɨn kuvehi utə iou iakaraka ia tɨprənə, takvi pehe nərmama pam həuvehe tukw iou.” ");
INSERT INTO tnk_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Iesu rɨni nəɡkiariien i mani əuenhɨn mə trəfemhə irə. ");
INSERT INTO tnk_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ro pen nərmama həni pen tukwe in mə, “Kɨmaha iahəuvəreɡi raka ia Loa səkɨtaha mə nəpɨn Kristo truvehe in tramarə rerɨn. Rəfo ikani mə tukuvehi utə Iəməti Iərmama? Sin nəha Iəməti Iərmama nəha?” ");
INSERT INTO tnk_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Nukuraanien sə raməhiəpwɨn kɨmiaha trarə nəpɨn ouihi a mwi kɨmiaha min. Havən nəpɨn nukuraanien i ramarə ihi kɨmiaha min, kamo nəpitəvien ruvehe mousəman kɨmiaha. Iərmama sə ramavən ia nəpitəvien rɨreirei kwopun ramevən ikɨn. ");
INSERT INTO tnk_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nəpɨn nukuraanien i ramarə ihi kɨmiaha min, tihəni nɨpərhienien irə. Ia suatuk nəha kɨmiaha tihəuvehe mho nɨpwnəti nukuraanien ia kɨmiaha.” Nəpɨn Iesu rɨni pam nəɡkiariien me i, in rəpwəh irəha, mevən mərkwafə. ");
INSERT INTO tnk_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Iesu rɨno auər a nɨmtətien me rɨpɨk ia nəmri nəkur Isrel mətə irəha həpkɨni mhə nɨpərhienien irə. ");
INSERT INTO tnk_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Noien i rier pehe iamɨnhi mə nəɡkiariien i Profet Aesea rɨməni fwe kupwən truvehe mukuə irə. In rɨməni iamɨnhi irə mɨnuə, “Iərɨmənu. Sin rɨni nɨpərhienien ia nəɡkiariien səkɨmaha? Iərɨmənu ro pui nɨskaiien səvənhi m sin?” ");
INSERT INTO tnk_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ro iamɨnhi irə irəha ko həpkɨni mhə nɨpərhienien ia Iesu tɨ nəri nə mə Profet Aesea rɨməni mwi mɨnuə, ");
INSERT INTO tnk_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Kumwesən rɨno nənimenraha rɨfwə, nənə məsisəɡ ia nətərɨɡien səvənraha. In rɨno iamɨnhi kamo irəha hətə nari ia nənimenraha, mhəukurən nari ia rerɨnraha, mhərərɨɡ, nənə tako irəha həuvehe mhəsanɨn.” ");
INSERT INTO tnk_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Profet Aesea rɨməni nəɡkiariien me i tɨ nəri nə mə in rɨnətoni nasoriien səvəi Iesu, nənə məɡkiari irə. ");
INSERT INTO tnk_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Mətə pərhien nəmə asori me həpɨk kwopti irəha mwi həni nɨpərhienien ia Iesu. Mətə tɨ nəri nə mə kamhəhekɨr Farisi me, həpwəh nɨni irapwien. Irəha həpwəh nokeikeiien mə Farisi me tuhərhi irapw irəha ia nimwəfwaki səvənraha. ");
INSERT INTO tnk_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nəmə asori me i hokeikei mə nərmama tuhaməmwur ia nəɡnəɡɨniien irəha. Irəha hokeikei sə nəha məpi raka mə Kumwesən trəɡnəɡɨni irəha. ");
INSERT INTO tnk_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ia nəpɨn nəha Iesu rəkwein əpwəmwɨs, mɨni mə, “Iərmama sə rani nɨpərhienien ia nirak, rɨpkɨni əpa mhə nɨpərhienien ia nirak, mətə rani nɨpərhienien ia Iəmə sə rɨnərhi pehe iou. ");
INSERT INTO tnk_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nənə iərmama sə ramətə iou, ramətə mwi Iəmə sə rɨnərhi pehe iou. ");
INSERT INTO tnk_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Iou iakɨməuvehe ia tɨprənə i iakəmwhen ia nukuraanien. Ro iamɨnhi irə, iərmama sə rani nɨpərhienien ia nirak trɨpkarə mhə ia nəpitəvien. ");
INSERT INTO tnk_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Iərmama sə ramreɡi nəɡkiariien me səiou, məpwəh noien nəfe iakani, tapkərpwɨn mhə noien ərəha səvənhi. Iou iapkuvehe mhə ia tɨprənə i mə takərpwɨn noien ərəha səvəi nərmama, mətə iakuvehe mə takuvehimɨru irəha. ");
INSERT INTO tnk_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mətə iərmama sə rauvei pehe təkutan miou, məpwəh mwi nɨniien nɨpərhienien ia nəɡkiariien me səiou, nari riti nəha ikɨn tukərpwɨn pen min tukwe. Ia nəpɨn sampam tukərpwɨn pen min tɨ nəri nə mə rɨni nəri auər a ia nəɡkiariien səiou sə iakɨməni. ");
INSERT INTO tnk_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tro iamɨnhi irə tɨ nəri nə mə nəɡkiariien me i səiou rɨpkuku pehe mhə ia nirak a. Mətə Tata Kumwesən sə rɨnərhi pehe iou iakuvehe, in nə rɨməni pehe nəkwan tukw iou i mə nəfe noien səvəi nəɡkiariien takesi pen mɨne nəfe nəɡkiariien takɨni. ");
INSERT INTO tnk_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nənə iakukurən mə nəɡkiariien i səvənhi in nə nukune nɨmɨruien rerɨn. Ro iamɨnhi irə nəfe iakani, mani makurirə a nəfe nəɡkiariien Tata Kumwesən rɨməni pehe tukw iou i.” ");
INSERT INTO tnk_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Trakwakwi tuko nəveɡɨnien asori nəha Pasova. Iesu rukurən mə nəpɨn səvənhi ruvəuvehe ipaka na trəpwəh tɨprənə i mevən tɨ Tata Kumwesən. Nəpɨn me in ramokeikei nərmama me səvənhi səməme kamharə ia tɨprənə i, mamokeikei irəha nəpɨn me meste pehe nəpɨn in tremhə irə. ");
INSERT INTO tnk_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ia nəruarəv Iesu mɨne nərmama me səvənhi kamhani pəri nari. Setan rɨnəmri pen raka nətərɨɡien riti ia reri Jutas Iskariot, tɨni Saemon, mə truvei pen Iesu ia rəɡi nərmama səməme haməmwəki in. ");
INSERT INTO tnk_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iesu rukurən mə Tata Kumwesən ruvəuvei pen raka narimnari me pam ia rəɡɨn. In rukurən mwi mə fwe kupwən in rəpwəh Kumwesən muvehe, nənə təkwtəkwuni in trɨrərɨɡ mevən mwi tɨ Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ro iamɨnhi irə in rɨskəmter ia kwopun nəha kamhani pəri nari ikɨn, muvehi raka karkahu səvənhi, nənə muvehi tɨnari riti mwi kamərai raka nəpwtɨɡien irə, mətoti. ");
INSERT INTO tnk_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Mətoti pam, mɨvi pen nui ia nari kamaikuas ia nɨsui iərmama irə, nənə mɨnamaikuas ia nɨsui nərmama me səvənhi, nənə mamrai raka nəpwtɨɡien ia tɨnari sə in rɨnətoti irə. ");
INSERT INTO tnk_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nəpɨn in ruvehe tɨ Saemon Pita, Pita rɨni pen tukwe in mə, “Iərɨmənu. Ikuə tikaikuas mwi ia nɨsuk mi?” ");
INSERT INTO tnk_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Mɨreɡi Iesu rɨni pen tukwe in mə, “Nəri i iakamo ikreirei təkwtəkwuni, mətə kurirə ikɨn tikukurən.” ");
INSERT INTO tnk_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Mɨreɡi Pita rɨni pen tukwe in mə, “Rekəm. Ko iakəpwəh nəseniien ik ikaikuas ia nɨsuk mi ia nəpɨn riti.” Mɨreɡi Iesu rɨni pen tukwe in mə, “Mə iapkaikuas mhə ia niram, tukəpwəh nɨniien mwi mə ik iərmama riti səiou.” ");
INSERT INTO tnk_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Mɨreɡi Saemon Pita rɨni pen tukwe in mə, “Iərɨmənu. Mə ro iamɨnhi irə, tikəpwəh naikuas əpaien ia nɨsuk mi, mətə tikaikuas mwi ia tɨpaɡe rəɡɨk mi mɨne nukwənek.” ");
INSERT INTO tnk_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Mɨreɡi Iesu rɨni pen tukwe in mə, “Iərmama sə rɨnaru raka traru mwi tɨ nəfe? Nɨpwran rɨnəmher pam raka, mətə nɨsun mi əpa traməkeikei maikuas mwi ia nirau. Kɨmiaha hiənəmher raka, mətə rɨpko mhə kɨmiaha pam.” ");
INSERT INTO tnk_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Iesu ruvəukurən raka sin ia nirəha truvei pen in ia rəɡi nərmama səməme haməmwəki in. Ro pen in rɨni ianhi mə, “Rɨpko mhə kɨmiaha pam hiəmher.” ");
INSERT INTO tnk_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nəpɨn Iesu raikuas pam ia nɨsunraha, rarkahu mwi karkahu səvənhi, mevən mwi məkure ia təmwhekɨn, nənə mɨni pen tɨ nirəha i mə, “Kɨmiaha hiəukurən nɨpwrai nəri i iako m kɨmiaha? ");
INSERT INTO tnk_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kɨmiaha hiaməkwein iou mə ‘Iahatən’ mɨne ‘Iərɨmənu.’ Nənə hiaməni atukwatukw a, tɨ nəri nə mə nɨpərhienien iou Iahatən səkɨmiaha mɨne Iərɨmənu səkɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ro iamɨnhi irə mə iou iakɨnaikuas ia nɨsumiaha iamɨnhi, ramasan mə kɨmiaha mwi tihaikuas ia nɨsumiaha me. ");
INSERT INTO tnk_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Iou iako noien i mahatən kɨmiaha irə mə kɨmiaha tiho rəmwhen iou iakɨno m kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Iakani nɨpərhienien tukumiaha i. Iərmama sə ramo tukwini nari rɨpkasori mhə ia iəmə asori səvənhi. Iərmama sə kamərhi in tɨ nuvehiien nəɡkiariien in rɨpkasori mhə ia iərmama sə ramərhi in. ");
INSERT INTO tnk_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Təkwtəkwuni nəha kɨmiaha hiəukurən amasan narimnari me i, ro iamɨnhi irə trɨni mɨnuə hio iamɨnha irə, kɨmiaha rerɨmiaha traɡien.” ");
INSERT INTO tnk_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Iou iapkəɡkiari mhə ia kɨmiaha pam. Iakukurən amasan səməme iakɨnərpwi rəɡɨk ia nirəha. Mətə nəɡkiariien i ia Nəkukuə Ikinan traməkeikei muvehe mukuə. Rɨni mə, ‘Iərmama sə kupwən iarouəni nari kɨmrau min, mətə təkwtəkwuni nəha in ruvəuvehe mɨnəmwəki iou.’ ");
INSERT INTO tnk_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Iou iakani irapw nəri i tukumiaha təkwtəkwuni, nəpɨn rəpwəh ihi nier peheien. Mətə nəpɨn trier pehe irə, nənə kɨmiaha tihəni nɨpərhienien ia nirak mə iou i in i. ");
INSERT INTO tnk_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Iakani nɨpərhienien tukumiaha i. Iərmama sə raməsevər ia rerɨn tɨ iərmama riti səiou sə takərhi pen i rəmwhen mə raməsevər mwi ia rerɨn tukw iou. Nənə iərmama sə raməsevər ia rerɨn tukw iou rəmwhen mə raməsevər mwi ia rerɨn tɨ Kumwesən sə rɨnərhi pehe iou iakuvehe.” ");
INSERT INTO tnk_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nəpɨn Iesu rɨni pam nəɡkiariien me nəha, rɨreɡi rərəha fwe ia rerɨn, mɨni irapw mə, “Iakani nɨpərhienien tukumiaha i mə kɨmiaha riti truvei pen iou ia rəɡi nərmama səməme kamhəmwəki iou.” ");
INSERT INTO tnk_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nənə nərmama me səvənhi həti pen mhətoni irəha me, mhəreirei mə Iesu rani sin. ");
INSERT INTO tnk_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Irəha riti Iesu rokeikei pɨk, in raməkure ipaka tɨ Iesu. ");
INSERT INTO tnk_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ro pen Saemon Pita ruini pen kənkapwə min mə trəres ro Iesu mə iərmama sin nəha in rani. ");
INSERT INTO tnk_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ro iamɨnhi irə iərmama nəha rəkure pəpən ipaka tɨ Iesu, məres in mə, “Iərɨmənu, sin nəha ikani?” ");
INSERT INTO tnk_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Mɨreɡi Iesu rɨni mə, “Iərmama sə takəkwsen bred meitesi ia nɨse nari muvei pen min, iərmama nəha i nəha.” Nənə in ruvehi nɨpəri bred riti, meitesi ia nɨse nari, muvei pen m Jutas tɨni Saemon Iskariot. ");
INSERT INTO tnk_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nənə Jutas ruvehi bred, təkwtəkwuni a mwi Setan ruvnimwə ia rerɨn. Nənə Iesu rɨni pen tukwe in mə, “Nəfe nəha ikuə tiko, iko akwauakw.” ");
INSERT INTO tnk_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Iesu rɨni nəɡkiariien nəha tɨ Jutas, mətə nərmama me nəha kamhani pəri nari irəha min həreirei mə rɨni pen tɨ nəfe. ");
INSERT INTO tnk_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Nepwɨn rerɨnraha rɨrhi mə rosi Iesu rɨməni pen tukwe in mə trevən muvehi nəmri nəveɡɨnien riti uə trevən muvei pen mane nepwɨn m nərmama nautə səvənraha riwən. Rerɨnraha rɨrhi iamɨnhi tɨ nəri nə mə Jutas ramətui tɨ tənərɨpw sə irəha kamhəvai pen mane me səvənraha irə. ");
INSERT INTO tnk_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ro iamɨnhi irə nəpɨn Jutas ruvehi raka bred, rərer, mier akwauakw a. Ia nəpɨn nəha ruvəpitəv. ");
INSERT INTO tnk_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nəpɨn Jutas ruvəier raka, Iesu rɨni mə, “Təkwtəkwuni nəha rɨno nəpɨn sə tukuvehi utə nəɡhi Iəməti Iərmama irə, nənə na in truvehi utə nəɡhi Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Trɨni mɨnuə in ruvehi utə nəɡhi Kumwesən, Kumwesən in mwi truvehi utə in revən marə irau min. In tro təkwtəkwuni a mwi. ");
INSERT INTO tnk_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nɨpwnətɨk me. Ko iapkarə əpwəmwɨs mhə kɨtaha m kɨmiaha. Kɨmiaha tihəpkətui iou, mətə takɨni pehe mwi nəɡkiariien kuatia a m kɨmiaha nəha təkwtəkwuni sə iakɨməni pen m nəmə asori me səvəi nəkur Isrel fwe kupwən. Iakɨməni pen tɨ nirəha i mə, ‘Kɨmiaha ko hiəpkəuvən mhə nəha kwopun iakamevən ikɨn.’ ");
INSERT INTO tnk_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nəɡkiariien vi riti takuvei pehe m kɨmiaha təkwtəkwuni mə tiho. Kɨmiaha tihaməkeikei mhokeikei kɨmiaha me. Rəmwhen iou iakokeikei kɨmiaha ia noien a mwi nəha kɨmiaha tihaməkeikei mhokeikei kɨmiaha me. ");
INSERT INTO tnk_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Trɨni mɨnuə kɨmiaha hiokeikei kɨmiaha me iamɨnhi irə, nərmama me pam tuhəukurən mə kɨmiaha nərmama me səiou.” ");
INSERT INTO tnk_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Nənə Saemon Pita rəres pen in mə, “Iərɨmənu, tikevən pəku?” Mɨreɡi Iesu rɨni mə, “Kwopun pəku iakamevən ikɨn nəha təkwtəkwuni, ko ipkukurirə mhə iou mətə kurirə irə tipkukurirə iou.” ");
INSERT INTO tnk_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Mɨreɡi Pita rɨni mə, “Iərɨmənu takəpwəh nukurirəien ik nəha təkwtəkwuni tɨ nəfe? Iou rerɨk raɡien a mə takemhə tukw ik.” ");
INSERT INTO tnk_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Mɨreɡi Iesu rɨni pen tukwe in mə, “Ikɨni mə rerɨm raɡien a mə tikemhə tukw iou? Iakani nɨpərhienien tukw ik i kurirə rəiə rakaka tikɨni m kahar mə ikreirei iou.” ");
INSERT INTO tnk_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Nənə Iesu rɨni pen tɨ nirəha i mɨnuə, “Rerɨmiaha rəpwəh nəpouien. Kɨmiaha tihaməkeikei mhəni nɨpərhienien ia Kumwesən, mhəni mwi nɨpərhienien ia nirak. ");
INSERT INTO tnk_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ia nəkwai nimwə səvəi Tata səiou nəkwan rɨpɨk. Iakɨnamevən takəpnəpenə ia kwopun riti səkɨmiaha. Nəɡkiariien i ro nɨpərhienien. Mə neikuəien ko iakəpwəh nɨniien tukumiaha. ");
INSERT INTO tnk_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Takevən məpnəpenə ia kwopun riti səkɨmiaha, məpnəpenə pam nənə mɨrərɨɡ pehe mwi mɨpeki pehe kɨmiaha ia nirak mə kɨmiaha tiharə ia kwopun iakamarə ikɨn. ");
INSERT INTO tnk_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kwopun nəha iakamevən ikɨn kɨmiaha hiəuvəukurən raka suatuk səvənhi.” ");
INSERT INTO tnk_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Mɨreɡi Tomas rɨni pen tukwe in mə, “Iərɨmənu. Kɨmaha iahəreirei kwopun nəha ikamevən ikɨn. Tahəfukurən suatuk ramevən ia kwopun nəha?” ");
INSERT INTO tnk_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Mɨreɡi Iesu rɨni pen tukwe in mə, “Iou suatuk. Iou nɨpərhienien. Iou nɨmɨruien. Iərmama riti ko rɨpkevən atukw mhə tɨ Tata Kumwesən trɨni mɨnuə iou iapkuvehi mhə in mevən. ");
INSERT INTO tnk_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Trɨni mɨnuə kɨmiaha hiəukurən iou, tihəukurən mwi səiou Tata. Təkwtəkwuni mamevən hiəuvəukurən raka in, mhənətoni raka in.” ");
INSERT INTO tnk_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Mɨreɡi Filip rɨni pen tukwe in mə, “Iərɨmənu. Ahatən ro Tata Kumwesən pwəh kɨmaha iahətoni. Nəri nə in nə kɨmaha iahokeikei.” ");
INSERT INTO tnk_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Mɨreɡi Iesu rɨni pen tukwe in mə, “Filip, iakɨnarə tui kɨtaha m kɨmiaha, mətə ikamreirei ihi iou? Iərmama sə ramətoni iou, ramətoni Tata səiou. Rəfo ikɨni mə ‘Ahatən ro Tata Kumwesən pwəh kɨmaha iahətoni’? ");
INSERT INTO tnk_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kwa iou nə ia Tata Kumwesən, Tata Kumwesən in i ia nirak. Ipkɨni mhə nɨpərhienien irə uə? Nəɡkiariien me i səməme iakani pehe tukumiaha i rɨpko mhə nəɡkiariien atukw səiou, mətə Tata Kumwesən ia nirak ramo wok me səvənhi. ");
INSERT INTO tnk_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ro iamɨnhi irə kɨmiaha tihaməkeikei mhəni nɨpərhienien ia nirak nəpɨn iakɨni iamɨnhi irə mɨnuə ‘Iou nə ia Tata Kumwesən, Tata Kumwesən in i ia nirak.’ Mə rekəm tihaməkeikei mhəni nɨpərhienien ia nirak tɨ nəri nə mə hiamətoni wok me i iakamo. ");
INSERT INTO tnk_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Iakani nɨpərhienien tukumiaha i iərmama sə rani nɨpərhienien ia nirak, in mwi tro wok me i iakamo. Ouəh pərhien in tro wok asori me məpi raka wok me i iakamo tɨ nəri nə mə iakamevən tɨ Tata Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nəfe nari kɨmiaha tihəres ia nəɡhɨk, iou tako mə wok me i Tɨni Kumwesən ramo truvehi utə nəɡhi Tata səvənhi. ");
INSERT INTO tnk_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Trɨni mɨnuə hiəres nari riti miou ia nəɡhɨk, iou tako.” ");
INSERT INTO tnk_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Trɨni mɨnuə kɨmiaha hiokeikei iou, tihaməkeikei mho nəɡkiariien me səiou. ");
INSERT INTO tnk_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nənə takəres Tata Kumwesən, nənə in truvei pehe Iasitu riti mwi m kɨmiaha in trarə rerɨn kɨmiaha min. ");
INSERT INTO tnk_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Iasitu nə in nə Nənɨmwɨn nə nukune nɨpərhienien. Nərmama səvəi tɨprənə i ko həpkuvehi mhə Nənɨmwɨn nə tɨ nəri nə mə irəha həpkətoni mhə, mhəreirei in. Mətə kɨmiaha hiəukurən in, tɨ nəri nə mə in ramarə kɨmiaha min nənə trɨpkarə ia rerɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Iou tapkəpwəh mhə kɨmiaha rəmwhen ia nəkwərhakwərha kemhə təni irəha. Takrərɨɡ mwi tukumiaha. ");
INSERT INTO tnk_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Trɨpko mhə tui nərmama səvəi tɨprənə i tuhəpkətoni mhə iou, mətə kɨmiaha tihətoni iou. Nənə tɨ nəri nə mə iou iakamɨru, kɨmiaha mwi tihəmɨru. ");
INSERT INTO tnk_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Tro nəpɨn səvəi narimnari me i, nənə kɨmiaha tihəukurən mə iou nə ia Tata səiou, kɨmiaha i ia nirak, nənə iou nə ia kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Iərmama sə ruvəreɡi raka nəɡkiariien me səiou, trɨni mɨnuə ramo nəɡkiariien me nəha, in nəha iərmama sə rokeikei pərhien iou. Iərmama sə rokeikei pərhien iou iamɨnhi irə, səiou Tata trokeikei in, nənə iou mwi takokeikei in, mo pui pen iou min.” ");
INSERT INTO tnk_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Mɨreɡi Jutas (rɨpko mhə Jutas Iskariot) rəres pen Iesu i mə, “Iərɨmənu. Tikəfo mo pui ik m kɨmaha əpa, mətə tikəpwəh no puien ik m nərmama səvəi tɨprənə?” ");
INSERT INTO tnk_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Mɨreɡi Iesu rɨni pen tukwe in mə, “Trɨni mɨnuə iərmama riti rokeikei iou, in tro nəɡkiariien səiou, nənə səiou Tata trokeikei in, kɨmrau Tata səiou tarouvehe tukwe, iarauo rukwənu səkɨmrau mhararə kɨmrahar min. ");
INSERT INTO tnk_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Iərmama sə rəpwəh nokeikeiien iou, in trəpwəh noien nəɡkiariien me səiou. Nəɡkiariien i sə hiamreɡi rɨpko mhə nəɡkiariien atukw səiou, mətə in i nəɡkiariien səvəi Tata Kumwesən sə rɨnərhi pehe iou iakuvehe. ");
INSERT INTO tnk_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Narimnari me i iakani irapw tukumiaha i nəpɨn iakamarə ihi kɨtaha m kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Mətə Nənɨmwɨn Ikinan i in Iasitu sə Tata Kumwesən trərhi pehe i ia nəɡhɨk, in trahatən kɨmiaha ia narimnari me pam. In tro rerɨmiaha ramrhi narimnari me i iakani pehe tukumiaha mə kɨmiaha tihəpwəh nenouenouien irə. ");
INSERT INTO tnk_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Na takəpwəh kɨmiaha, mətə iakəmri nəmərinuien tramarə tukumiaha. Nəmərinuien i səiou sə iakauvei pehe rɨpkəmwhen mhə ia nəmərinuien sə nərmama səvəi tɨprənə i tuhəuvei pehe. Rerɨmiaha rəpwəh nəpouien, məpwəh nehekɨrien. ");
INSERT INTO tnk_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Kɨmiaha hiəuvəreɡi raka nəɡkiariien səiou. Iakɨməni pehe tukumiaha i mə, ‘Iou tapkəpwəh kɨmiaha, mətə kurirə takrərɨɡ pehe tukumiaha.’ Trɨni mɨnuə hiokeikei pərhien iou, nənə rerɨmiaha traɡien a mə tihətoni iou iakamevən tɨ Tata Kumwesən, tɨ nəri nə mə in rasori məpi raka iou. ");
INSERT INTO tnk_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Iou iakani pehe raka narimnari me i tukumiaha nəha təkwtəkwuni kurirə həier pehe, ro iamɨnhi nəpɨn həier pehe tihəni nɨpərhienien ia nirak. ");
INSERT INTO tnk_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ko iapkəɡkiari əpwəmwɨs mhə m kɨmiaha nəha təkwtəkwuni tɨ nəri nə mə Setan i iərɨmənu səvəi tɨprənə i rɨnauvehe. In rɨpkasori mhə ia nirak, ");
INSERT INTO tnk_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","mətə nərmama səvəi tɨprənə i tuhaməkeikei mhəukurən mə iakokeikei Tata Kumwesən ro pen iakamesi pen atukwatukw nəfe nəɡkiariien sə in rɨməni pehe tukw iou i mə tako. Həuvehe pwəh saraka ia kwopun i.” ");
INSERT INTO tnk_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Iou iakəmwhen ia nukune nei nəha krep sə ro nɨpərhienien i. Səiou Tata in rəmwhen ia iərmama sə raməpərhi nei nəha. ");
INSERT INTO tnk_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Rəɡi nei me pam səməme həpkukuə mhə in ramərai raka irəha. Rəɡi nei me pam səməme kamhəukuə in raməpərhi amasan mə trukuə kwənkwan rɨpɨk mwi. ");
INSERT INTO tnk_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kɨmiaha hiəmwhen ia rɨɡi nei nəha, nənə iakɨnəpərhi raka kɨmiaha ia nəɡkiariien me səməme iakani pehe tukumiaha. ");
INSERT INTO tnk_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Tihəpwit əknekɨn ia nirak, nənə iou takəpwit əknekɨn ia kɨmiaha. Rɨɡi nei ko rəpwəh nukuəien trɨni mɨnuə rɨpkərer əknekɨn mhə ia nɨpren. Ia noien nəha rəmwhen a mwi nɨmɨruien səkɨmiaha ko rɨpkukuə mhə kwənkwan trɨni mɨnuə hiəpwəh nəpwit əknekɨnien ia nirak. ");
INSERT INTO tnk_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Iou i, iou nukune nei nəha krep. Kɨmiaha nə rəɡrəɡɨn me. Iərmama sə rəpwit əknekɨn ia nirak, nənə iakəpwit əknekɨn irə, iərmama i in trukuə kwənkwan me rɨpɨk. Mətə kɨmiaha ko hiəpko mhə nari riti trɨni mɨnuə hiəpkəpwit əknekɨn mhə ia nirak. ");
INSERT INTO tnk_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Iərmama sə rɨpkəpwit əknekɨn mhə ia nirak in rəmwhen ia rɨɡi nei riti sə kɨnərai raka ruvɨmhiə. Rɨɡi nei me səməme həuvəmhiə iamɨnhi, tukɨpeki irəha kərki pen irəha ia napw. ");
INSERT INTO tnk_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Trɨni mɨnuə hiəpwit əknekɨn ia nirak, nənə nəɡkiariien me səiou ramarə ia rerɨmiaha, nəfe hiokeikei, hiəukurən nəresien, nənə tuko m kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nɨmɨruien səkɨmiaha traməkeikei mukuə kwənkwan me rɨpɨk. Nərmama me tuhətoni mhəukurən mə pərhien kɨmiaha i nərmama me səiou. Ia noien nəha tihəuvehi utə nəɡhi Tata səiou. ");
INSERT INTO tnk_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Iakokeikei kɨmiaha rəmwhen Tata Kumwesən rokeikei iou. Həpwit əknekɨn ia nokeikeiien səiou. ");
INSERT INTO tnk_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Trɨni mɨnuə hiamo nəɡkiariien me səiou, nənə tihəpwit əknekɨn ia nokeikeiien səiou, rəmwhen iou iakɨno nəɡkiariien me səvəi Tata səiou maməpwit əknekɨn ia nokeikeiien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Iakani irapw narimnari me i tukumiaha mə rerɨmiaha tramaɡien rəmwhen iou rerɨk ramaɡien, nənə naɡienien i səkɨmiaha trasori pɨk. ");
INSERT INTO tnk_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nəɡkiariien səiou sə iakani pehe tukumiaha i mə tiho ro iamɨnhi irə: Hokeikei kɨmiaha me rəmwhen iou iakokeikei kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Samarə iərmama riti rəseni kousi əpune in mə nemhəien səvənhi truvehimɨru in me nepwɨn hiəukurən mə nokeikeiien riti mwi riwən rasori məpi raka nokeikeiien nəha. ");
INSERT INTO tnk_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Trɨni mɨnuə hiamo narimnari me i iakani pehe tukumiaha, ramahatən mə iou me nepwɨn nə kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Iou tapkəkwein mhə mwi kɨmiaha mə iotukwininari me səiou tɨ nəri nə mə iotukwininari rɨreirei narimnari me səməme iəmə asori səvənhi ramo. Mətə təkwtəkwuni nəha takəkwein kɨmiaha mə iou me nepwɨn tɨ nəri nə mə narimnari me pam səməme iakɨməreɡi səiou Tata ramɨni iakuvəni pehe raka tukumiaha. ");
INSERT INTO tnk_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kɨmiaha hiəpkukupwən mhə mhərpwi rəɡɨmiaha ia nirak, mətə iou iakukupwən mərpwi rəɡɨk ia kɨmiaha, muvehi utə kɨmiaha mə tihəuvən nɨmɨruien səkɨmiaha trukuə rəmwhen ia nei, nənə kwənkwamiaha trarə. Ro iamɨnhi irə trɨni mɨnuə hiəres nari riti m Tata Kumwesən ia nəɡhɨk, nənə in truvei pehe m kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nəɡkiariien səiou sə iakani pehe tukumiaha i mə tiho ro iamɨnhi irə: Hokeikei kɨmiaha me.” ");
INSERT INTO tnk_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Trɨni mɨnuə nərmama səvəi tɨprənə i kamhəmwəki kɨmiaha, rerɨmiaha trɨrhi mə fwe kupwən irəha hənaməmwəki mwi iou. ");
INSERT INTO tnk_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Trɨni mɨnuə kɨmiaha nərmama səvəi tɨprənə i, irəha tuhokeikei kɨmiaha tɨ nəri nə mə kɨmiaha nərmama me səvənraha. Mətə rɨpko mhə kɨmiaha nərmama səvəi tɨprənə i. Iou iakɨnərpwi rəɡɨk ia kɨmiaha mə kɨmiaha tiharaka ia nərmama səvəi tɨprənə i. Ro iamɨnhi irə nərmama səvəi tɨprənə i kamhəmwəki kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Rerɨmiaha trɨrhi nəɡkiariien i iakuvəni raka tukumiaha i mə, ‘Iərmama sə ramo tukwini nari rɨpkasori mhə ia iəmə asori səvənhi.’ Irəha hənometə iou, ro iamɨnhi irə hiəukurən mə tuhometə mwi kɨmiaha. Irəha hənəpwəh noien nəɡkiariien me səiou, ro iamɨnhi irə hiəukurən mə tuhəpwəh mwi noien nəɡkiariien me səkɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nərmama me səvəi tɨprənə i tuho narimnari me i ia kɨmiaha tɨ nəri nə mə kɨmiaha i nərmama me səiou. Irəha tuhometə kɨmiaha tɨ nəri nə mə həreirei Iəmə sə rɨnərhi pehe iou iakuvehe. ");
INSERT INTO tnk_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Trɨni mɨnuə iakəpwəh nuveheien məɡkiari mɨnraha, nərəhaien səvənraha triwən. Mətə təkwtəkwuni nəha iakuvəuvehe raka, ko həpkərkwafə mhə noien ərəha səvənraha. ");
INSERT INTO tnk_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Iərmama sə raməmwəki iou, in raməmwəki mwi səiou Tata. ");
INSERT INTO tnk_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Iakɨno narimnari me i ia nənimenraha, narimnari me sə iərməpə riti ko rɨpko mhə. Trɨni mɨnuə iapko mhə iamɨnhi nərəhaien səvənraha triwən. Mətə təkwtəkwuni irəha hənətə raka iou, mamhəmwəki kɨmrau Tata səiou. ");
INSERT INTO tnk_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Mətə nəɡkiariien i kɨmərai pen ia Loa səvənraha traməkeikei muvehe mukuə. Rɨni iamɨnhi irə mə, ‘Iou iapko mhə nari riti ia nirəha, mətə irəha həmwəki iou.’ ");
INSERT INTO tnk_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Iasitu riti nəha ikɨn Tata Kumwesən truvei pehe iou takərhi pehe i tukumiaha. Iasitu nəha in nə Nənɨmwɨn nə nukune nɨpərhienien sə ramier ia Tata Kumwesən. Nəpɨn truvehe, trərer irapw məɡkiari ia nirak. ");
INSERT INTO tnk_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nənə kɨmiaha mwi tihaməkeikei mhərer irapw mhəɡkiari ia nirak, tɨ nəri nə kɨtaha miou sənarə fwe ia nukune wok səiou muvehe meste pehe təkwtəkwuni.” ");
INSERT INTO tnk_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Iakani pehe narimnari me i tukumiaha mə nahatətəien səkɨmiaha trəpwəh nɨmweiien. ");
INSERT INTO tnk_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Irəha tuhəpkərhi irapw kɨmiaha ia nimwəfwaki me səvənraha. Pərhien nəpɨn nəha ikɨn rauvehe, nəpɨn nərmama tuhousi əpune kɨmiaha rerɨnraha rɨrhi mə kamho wok amasan riti səvəi Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Irəha tuho noien me nəha tɨ nəri nə mə həreirei Tata səiou mhəreirei mwi iou. ");
INSERT INTO tnk_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mətə iou iakukupwən mɨni pehe narimnari me i tukumiaha mə nəpɨn tuko narimnari me i ia kɨmiaha nənə rerɨmiaha trɨrhi mə iakuvəni pehe raka tukumiaha. Iou iapkɨni pehe mhə narimnari me i tukumiaha fwe kupwən tɨ nəri nə mə iakɨnamarə kɨtaha m kɨmiaha.” ");
INSERT INTO tnk_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Təkwtəkwuni nəha iakɨnamevən tɨ Iəmə sə rɨnərhi pehe iou iakuvehe, mətə kɨmiaha riti rɨpkəres mhə iou mə, ‘Ikamevən pəku?’ ");
INSERT INTO tnk_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Tɨ nəri nə mə iakani pehe narimnari me i tukumiaha, rerɨmiaha rəmisə pɨk. ");
INSERT INTO tnk_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mətə iakani nɨpərhienien tukumiaha i ramasan pɨk tukumiaha mə takevən. Trɨni mɨnuə iapkevən mhə, nənə Iasitu trɨpkuvehe mhə tukumiaha. Mətə trɨni mɨnuə iakevən, nənə takərhi pehe in ruvehe tukumiaha. ");
INSERT INTO tnk_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nənə nəpɨn in truvehe, tro pui nərmama səvəi tɨprənə i hətə sas narimnari me ia nɨkaren səvəi noien ərəha, noien atukwatukw, mɨne nərpwɨnien noien ərəha. ");
INSERT INTO tnk_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","In tro pui irəha hətə sas narimnari ia nɨkaren səvəi noien ərəha tɨ nəri nə mə irəha həpwəh nɨniien nɨpərhienien ia nirak. ");
INSERT INTO tnk_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","In tro pui irəha hətə sas narimnari ia nɨkaren səvəi noien atukwatukw, tɨ nəri nə mə iakamevən tɨ Tata Kumwesən, nənə kɨmiaha tihəpkətə mhə mwi iou. ");
INSERT INTO tnk_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","In tro pui irəha hətə sas narimnari me ia nɨkaren səvəi nərpwɨnien noien ərəha tɨ nəri nə mə Setan sə ramərɨmənu ia tɨprənə i, Kumwesən ruvəni raka mə trərpwɨn noien ərəha səvənhi. ");
INSERT INTO tnk_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Narimnari me rɨpɨk mwi nəha ikɨn takɨni pehe tukumiaha. Mətə ko hiəpkreɡi pam mhə nəha təkwtəkwuni. ");
INSERT INTO tnk_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nəpɨn Nənɨmwɨn i in nukune nɨpərhienien truvehe, in triri pen kɨmiaha ia nɨpərhienien me pam. In ko rɨpkɨni atukw a mhə nəɡkiariien səvənhi, mətə nəfe nəɡkiariien in rɨreɡi in trɨni. Nənə in trɨni irapw tukumiaha narimnari me səməme tuhəpkuvehe. ");
INSERT INTO tnk_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","In truvehi nəfe səiou iakuvei pen min, nənə mɨni irapw tukumiaha i. Ia noien nəha in truvehi utə nəɡhɨk. ");
INSERT INTO tnk_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Narimnari me pam səvəi Tata Kumwesən, irəha narimnari me səiou. Ro pen iakani nəɡkiariien i mə, ‘In truvehi nəfe səiou iakuvei pen min, nənə mani irapw tukumiaha i.’ ");
INSERT INTO tnk_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Trɨpko mhə tui hiəpwəh nətoniien iou, kurirə irə trɨpko mhə tui nənə hiətoni mwi iou.” ");
INSERT INTO tnk_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Iesu rɨni nəɡkiariien nəha nənə nərmama nepwɨn səvənhi kamhəres irəha me i mə, “Nəɡkiariien nəha nɨpwran rəfo irə? In rɨni pehe tukutaha i mə trɨpko mhə tui səpwəh nətoniien in, kurirə irə trɨpko mhə tui nənə sətoni mwi in. In rɨni mwi mə, ‘tɨ nəri nə mə iakamevən tɨ Tata Kumwesən.’” ");
INSERT INTO tnk_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ro iamɨnhi irə irəha kamhəni mə, “Nəɡkiariien i ‘trɨpko mhə tui,’ nɨpwran rəfo irə? Kɨtaha səreirei nəfe nəha in raməɡkiari irə.” ");
INSERT INTO tnk_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Iesu ruvəukurən raka mə irəha hokeikei mə tuhəres in nari riti, ro pen in rɨni pen tɨ nirəha i mə, “Rəfo? Iou iakɨməni mə, ‘Trɨpko mhə tui hiəpwəh nətoniien iou, kurirə irə trɨpko mhə tui nənə hiətoni mwi iou.’ ?Hiaməres kɨmiaha me tɨ nɨpwrai nəɡkiariien i? ");
INSERT INTO tnk_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Iakani nɨpərhienien tukumiaha i mə kɨmiaha tihəreɡi rərəha mhasək, mətə nərmama səvəi tɨprənə i tuhaɡien. Kɨmiaha tihəreɡi rərəha anan, mətə nəmisəien səkɨmiaha truvsini pehe ia naɡienien. ");
INSERT INTO tnk_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nəpɨn pran sə rɨpəmpəm nəpɨn səvənhi rukwakwa mə trərhi tɨni, in trɨreɡi rərəha tɨ nəri nə mə rɨno nəpɨn səvənhi mə trɨreɡi nəmisəien ia nɨpwran. Mətə kurirə nəpɨn tɨni rɨnətui, nənə in renouenou ia nəmisəien nəha. In rerɨn ramaɡien pɨk, tɨ nəri nə mə tɨni rɨnətui pehe ia tɨprənə i. ");
INSERT INTO tnk_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Noien nəha rəmwhen a ia kɨmiaha. Təkwtəkwuni nəha rerɨmiaha rəmisə, mətə kurirə irə iou takətoni mwi kɨmiaha, nənə rerɨmiaha traɡien. Iərmama riti ko rɨpko mhə mwi rerɨmiaha rəpou. ");
INSERT INTO tnk_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ia nəpɨn nəha sə truvehe, tihəpkəres mhə mwi nari riti miou. Iakani nɨpərhienien tukumiaha i trɨni mɨnuə hiəres Tata Kumwesən nari riti ia nəɡhɨk, in truvei pehe m kɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Meste pehe təkwtəkwuni hiəpkəres mhə Tata Kumwesən nari riti ia nəɡhɨk. Ramasan mə hiəres. In truvei pehe nəfe nari hiaməres i mə rerɨmiaha traɡien. ");
INSERT INTO tnk_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Iou iakani narimnari me i tukumiaha ia nusipekɨnien me. Mətə nəpɨn nəha ikɨn sə truvehe iou takəpwəh mwi nəɡkiariien m kɨmiaha ia nusipekɨnien me, mətə takəɡkiari ia Tata Kumwesən m kɨmiaha ia noien riti sə kɨmiaha tihəukurən amasan in. ");
INSERT INTO tnk_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ia nəpɨn nəha kɨmiaha tihəres ia nəɡhɨk. Həreɡi ro nəɡkiariien i sə iakani pehe tukumiaha. Iapkɨni mhə iamɨnhi irə mə iou takəɡkiari m Tata Kumwesən məres tukwini səkɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Rekəm. Kwa Tata Kumwesən in rokeikei kɨmiaha tɨ nəri nə mə kɨmiaha hiokeikei iou, nənə mamhəni nɨpərhienien mə iakuku pen tukwe in. ");
INSERT INTO tnk_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Pərhien iakuku pen tɨ Tata Kumwesən muvehe ia tɨprənə i. Nənə təkwtəkwuni takəpwəh tɨprənə i mɨrərɨɡ mevən tɨ Tata Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Mɨreɡi nərmama me səvənhi həni mə, “Təkwtəkwuni ipkusipekɨn mhə. Ikani atukwatukw a tukumaha. ");
INSERT INTO tnk_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Təkwtəkwuni kɨmaha iahəukurən mə ik ikukurən pam narimnari me. Iərmama riti trəres pehe nəresien riti tukw ik tɨ nəfe? Kurirə in rəres ik i, mətə ikuvəukurən raka nətərɨɡien səvənhi. Nəri i ro kɨmaha iahəni nɨpərhienien mə ikuku pen tɨ Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Mɨreɡi Iesu rɨni pen tɨ nirəha mə, “Kɨmiaha hiəni nɨpərhienien ia nirak nəha təkwtəkwuni? ");
INSERT INTO tnk_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Həreɡi ro, nəpɨn nəha rauvehe, ruvəuvehe raka, nəpɨn sə nərmama tuhərpwi kɨmiaha irə, hiaiu kɨrkɨri pam, mhəuvən kuatia kuatia imwəmiaha me, mhəpwəh əpa iou. Mətə ko iapkavən əpa mhə tɨ nəri nə mə kɨmrau səiou Tata. ");
INSERT INTO tnk_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Iakuvəni raka narimnari me i tukumiaha mə in i ia nirak tihəuvehi nəmərinuien. Ia tɨprənə i tuko nəmisəien m kɨmiaha, mətə tihəpwəh nehekɨrien, iou iakuvəuvehi irapw raka nɨskaiien səvəi tɨprənə i.” ");
INSERT INTO tnk_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Iesu rɨni pam nəɡkiariien me i, məkwətə ia nɨmaɡouaɡou, mɨni mə, “Tata, nəpɨn səiou ruvəuvehe raka. Uvehi utə nəɡhi nərɨm mə in mwi truvehi utə nəɡhɨm. ");
INSERT INTO tnk_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ikɨməuvehi pen nasoriien min mə trərɨmənu ia nərmama me pam, nənə muvei pen nɨmɨruien rerɨn m səməme ik ikɨməuvehi pen irəha min. ");
INSERT INTO tnk_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nənə nɨmɨruien rerɨn i nɨpwran mə nərmama tuhəukurən ik Kumwesən əpa pərhien, mhəukurən mwi Iesu Kristo sə ikɨnərhi pehe i. ");
INSERT INTO tnk_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Iou iakuvəuvehi utə raka nəɡhɨm ia tɨprənə i, mo pam wok sə ikuvei pehe miou mə tako. ");
INSERT INTO tnk_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nənə təkwtəkwuni, Tata, uvehi utə iou iakuvehe marə krau mik. Uvei pehe nasoriien miou rəmwhen ia sə iakɨnauvehi kupwən krau mik nəpɨn tɨprənə ramiwən ihi. ");
INSERT INTO tnk_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nərmama me i səməme hənaraka ia nərmama səvəi tɨprənə, ikuvei pehe irəha miou, iou iakɨno pui pen raka nəɡhɨm mɨnraha. Kupwən irəha səim. Ikuvei pehe irəha miou, nənə irəha həno nəɡkiariien səim. ");
INSERT INTO tnk_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Təkwtəkwuni nəha, irəha həukurən mə narimnari me pam səməme ikuvei pehe miou kamhəuku pehe tukw ik. ");
INSERT INTO tnk_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nəɡkiariien me səməme ikɨməni pehe tukw iou i, iou iakuvəni pen raka tɨ nirəha, nənə irəha həuvehi. Irəha həukurən mə iakɨməuku pehe pərhien tukw ik, nənə həni nɨpərhienien mə ik ikɨnərhi pehe iou. ");
INSERT INTO tnk_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Iou iakaməfwaki tɨ nirəha. Iapkəfwaki mhə tɨ nərmama me səvəi tɨprənə, mətə iakaməfwaki tɨ nərmama me nəha səməme ikɨməuvehi pehe irəha miou, tɨ nəri nə mə irəha nərmama me səim. ");
INSERT INTO tnk_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nərmama me səiou irəha pam nə səim. Nərmama me səim irəha pam nə səiou. Nənə irəha həuvəuvehe raka mamhəuvehi utə nəɡhɨk. ");
INSERT INTO tnk_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Trɨpko mhə tui iakəpwəh narəien ia tɨprənə i, mauvehe tukw ik, mətə nərmama me i tuhamarə ia tɨprənə i. Tata Ikinan, tikətui amasan tɨ nirəha ia nəɡhɨm, nəhaɡ sə ikɨməseɡi pehe miou. Tiko iamɨnhi irə mə irəha tuhəuvehe mho kuatia rəmwhen krau krauo kuatia. ");
INSERT INTO tnk_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nəpɨn iakɨnamarə kɨmaha mɨnraha iakamətui amasan tɨ nirəha ia nəɡhɨm, nəhaɡ sə ikɨməseɡi pehe miou. Iou iakɨnərer tukuahaɡ tɨ nirəha, nənə irəha riti rəpwəh nərueiien. Iərmama kuatia a ia nirəha rəruei, in nəha iərmama sə tukouraha in mə nəɡkiariien ia Nəkukuə Ikinan truvehe mukuə. ");
INSERT INTO tnk_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Təkwtəkwuni iakɨnauvehe tukw ik, mətə iakamɨni nəɡkiariien me i nəpɨn iakamarə ihi ia tɨprənə mə irəha mwi rerɨnraha traɡien rəmwhen ia iou rerɨk ramaɡien. ");
INSERT INTO tnk_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Iou iakuvəuvei pen raka nəɡkiariien səim mɨnraha. Ro iamɨnhi irə nərmama səvəi tɨprənə kamhəmwəki irəha, tɨ nəri nə mə rɨpko mhə irəha nərmama səvəi tɨprənə rəmwhen a ia iou rɨpko mhə iou iərmama səvəi tɨprənə. ");
INSERT INTO tnk_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Iapkəres mhə ik mə tikuvehi raka irəha ia tɨprənə i, mətə iakokeikei mə tikərəpinhə iəremhə ərəha nəha Setan mə in trəpwəh nevənien mouraha irəha. ");
INSERT INTO tnk_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Rɨpko mhə irəha nərmama səvəi tɨprənə rəmwhen a ia iou rɨpko mhə iou iərmama səvəi tɨprənə. ");
INSERT INTO tnk_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Tiko nəɡkiariien səim kani mə nɨpərhienien rəpərhi irəha pwəh həuvehe mhəmher, mho nərmama ikinan səim. ");
INSERT INTO tnk_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ik ikɨnərhi pehe iou iakuvehe ia tɨprənə i. Ia noien nəha iakərhi pen irəha həuvən ia tənəmtənə me. ");
INSERT INTO tnk_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Iakuvei pehe nɨmɨruien pam səiou mik mə takasitu ia nərmama me i. Iakuə irəha mwi tuhəuvehe mhəmher, mho nərmama ikinan pərhien səim.” ");
INSERT INTO tnk_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Iapkəfwaki əpa mhə tɨ nərmama me i, mətə iakaməfwaki mwi tɨ nərmama səməme tuhəreɡi nəvisauien səvənraha, nənə həreɡi həni nɨpərhienien ia nirak tukwe. ");
INSERT INTO tnk_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tata iakəfwaki mə irəha pam tuhəuvehe mho kuatia rəmwhen a ia krau, ik ia nirak iou ia niram. Iakəfwaki mə irəha tuhəuvehe mho kuatia a kɨtaha mik mə nərmama səvəi tɨprənə tuhəni nɨpərhienien mə ik ikɨnərhi pehe iou. ");
INSERT INTO tnk_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nasoriien i sə ikɨməuvehi pehe miou iakauvei pen mɨnraha mə irəha tuhəuvehe mho kuatia rəmwhen krau kuatia ");
INSERT INTO tnk_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","iou ia nirəha ik ia nirak. Iakuə irəha tuhəuvehe mho kuatia ia narimnari me pam mə nərmama me səvəi tɨprənə tuhətoni mhəukurən mə ik ikɨnərhi pehe iou, mhəukurən mwi mə ikokeikei nərmama me i səiou rəmwhen ikokeikei iou. ");
INSERT INTO tnk_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tata iakokeikei mə nərmama me i səməme ikɨməuvehi pehe miou irəha mwi tuharə kɨmaha mɨnraha ia kwopun iakamevən ikɨn. Iakokeikei mə irəha tuhətoni nasoriien səiou sə ikɨməuvehi pehe miou tɨ nəri nə mə ikɨnokeikei iou nəpɨn tɨprənə ramiwən ihi. ");
INSERT INTO tnk_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tata noien səim ratukwatukw. Nɨpərhienien nərmama səvəi tɨprənə i həreirei ik, mətə iou iakukurən ik. Nənə nərmama me i səiou həukurən mə ik ikɨnərhi pehe iou. ");
INSERT INTO tnk_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Iou iakɨno pui pen nəɡhɨm mɨnraha, nənə takarɨpɨn mamo pui pen nəɡhɨm iamɨnhi irə mə nokeikeiien i sə ikɨnokeikei iou irə tramarə ia nirəha, nənə iou mwi ia nirəha.” ");
INSERT INTO tnk_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iesu rɨni pam nəɡkiariien me nəha, mier irəha nərmama me səvənhi, mhəuvən mhəpi sɨmwɨn ia nəkwətənə nəha nəɡhɨn nə Ketron. Nəkwai nɨmai riti nəha ikɨn. Iesu mɨne nərmama me səvənhi həuvən pen fwe ia rerɨn. ");
INSERT INTO tnk_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jutas, iəmə nəha ruvei pen Iesu ia rəɡi nərmama səməme kamhəmwəki in, in mwi rukurən kwopun nəha, tɨ nəri nə mə nəpɨn me rɨpɨk Iesu mɨne nərmama me səvənhi hənamousəsɨmwɨn irəha me ikɨn. ");
INSERT INTO tnk_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ro iamɨnhi irə Jutas riri naruaɡən me nepwɨn səvəi nəkur Rom mɨne nərmama me nepwɨn səməme pris asori me mɨne Farisi me hərhi pen irəha. In riri irəha həuvən ia nəkwai nɨmai nəha, mhəuvehi kwənhiə me mɨne nuksepək mɨne narimnari me səvəi naruaɡənien. ");
INSERT INTO tnk_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Iesu ruvəukurən raka narimnari me pam sə tuko irə. Ro pen raraka ia nərmama me səvənhi mevən, mɨni pen tɨ nirəha i mə, “Kɨmiaha hiamətui sin?” ");
INSERT INTO tnk_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Mɨreɡi irəha həni mə, “Iesu iəmə Nasaret.” Mɨreɡi Iesu rɨni pen tɨ nirəha i mə, “Iou i in i.” (Jutas iəmə sə ruvei pen Iesu ia rəɡi nərmama me i kamhəmwəki in kamhərer irəha mɨnraha.) ");
INSERT INTO tnk_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nəpɨn Iesu rɨni pen tɨ nirəha i mə, “Iou i in i,” irəha havən təkutanraha mhəmwei irapw ia tɨprənə. ");
INSERT INTO tnk_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Nənə Iesu rəres mwi irəha mə, “Kɨmiaha hiamətui sin?” Mɨreɡi həni mə, “Iesu iəmə Nasaret.” ");
INSERT INTO tnk_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Mɨreɡi Iesu rɨni mə, “Iakuvəni raka tukumiaha i mə iou i in i. Mətə mə hiamətui iou, ramasan mə hiəpwəh nərmama me i səiou me pwəh hərərɨɡ mhəuvən imwənraha me.” ");
INSERT INTO tnk_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","In rɨni iamɨnhi irə mə nəɡkiariien i sə in rɨməni kupwən truvehe mukuə. “Tata. Iapkətə wau mhə ia nirəha riti sə ikɨməuvehi pehe miou.” ");
INSERT INTO tnk_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saemon Pita səvənhi riti nau səvəi naruaɡənien. In reivi nau nəha, mərai iərmama riti sə ramo tukwini nari m pris asori anan, mərai raka nɨfreɡɨn mwatuk. (Iotukwininari nəha nəɡhɨn nə Malkas.) ");
INSERT INTO tnk_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Mətə Iesu rɨni pen tɨ Pita i mə, “Ərpwi pen nau səim ia təmwhekɨn. Iou takaməkeikei mɨreɡi nəmisəien i rəmwhen ia kap riti sə Tata Kumwesən ruvei pehe miou mə takənɨmwi.” ");
INSERT INTO tnk_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nənə naruaɡən me səvəi nəkur Rom mɨne nəmə asori me səvənraha mɨne iotukwininari me səvəi nəmə asori me səvəi nəkur Isrel həkwtəmhiri Iesu, mhərihi tərini, ");
INSERT INTO tnk_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","mhəkupwən mhəiri in mhəuvən tɨ Anas. Irəha həiri pen in tɨ Anas tɨ nəri nə mə Anas in kaka səvəi Kaeafas, iəmə sə rauvehi wok səvəi pris asori anan ia nuk nəha. ");
INSERT INTO tnk_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaeafas in iəmə nəha rɨməni pen tɨ nəmə asori me səvəi nəkur Isrel mɨnuə ko iərmama kuatia remhə tɨ nəkur Isrel ramasan məpi raka kousi əpune nərmama həpɨk. ");
INSERT INTO tnk_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saemon Pita rukurirə Iesu. Iərmama riti mwi səvəi Iesu rukurirə mwi. Pris asori anan rukurən iəmə nəha mo pen kəseni in rukurirə ia Iesu rouuvnimwə pehe ia nɨkare nimwə səvəi pris asori anan. ");
INSERT INTO tnk_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Mətə Pita ramərer a fwe iruə ia kwəruə. Ro iamɨnhi irə iərmama nəha səvəi Iesu pris asori anan rukurən in rier mwi mevən iruə, məɡkiari m pran sə ramərer tukuahaɡ ia kwəruə mə trəseni Pita pwəh ruvnimwə pehe. ");
INSERT INTO tnk_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Prən sə ramərer tukuahaɡ ia kwəruə rɨni pen tɨ Pita i mə, “Ik mwi iərmama riti səvəi iəmə nəha uə rekəm?” Mɨreɡi Pita rɨni mə, “Rekəm. Rɨpko mhə iou iərmama riti səvənhi.” ");
INSERT INTO tnk_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nəpɨn nə nəpɨn səvəi nəkwieiien. Ro pen slef me mɨne iotukwininari me hərkwumen napw, mamhərer kuraukurau irə, mamhərhiəpw. Pita revən mərer irəha mɨnraha, mamərhiəpw mwi. ");
INSERT INTO tnk_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Nənə pris asori anan raməres Iesu nəresien me nepwɨn ia nɨkaren səvəi nərmama me səvənhi mɨne nəɡkiariien sə in ramahatən irəha irə. ");
INSERT INTO tnk_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Mɨreɡi Iesu rɨni pen tukwe in mə, “Iou iakɨməni irapw nəɡkiariien me səiou ia nəmri nərmama me pam. Ia nəpɨn me iakamahatən irəha ia nəkwai nimwəfwaki me mɨne ia nimwə səvəi Kumwesən, kwopun mi nəha nəkur Isrel me kamhousəsɨmwɨn irəha me ikɨn. Iapkɨni mhə nəɡkiariien səiou ia kwopun afafa. ");
INSERT INTO tnk_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Rəfo ikaməres pehe miou? Ramasam mə tikəres pen səməme nəha sə həuvəreɡi raka iou mə nəfe iakɨməni pen tɨ nirəha i. Irəha həukurən nəfe iakɨməni.” ");
INSERT INTO tnk_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nəpɨn Iesu rɨni nəɡkiariien me i, iotukwininari riti səvəi pris asori anan ramərer ipaka tukwe rəpwi nənimen, mɨni mə, “Rəfo ikaməɡkiari skai mɨne pris asori anan iamɨnhi?” ");
INSERT INTO tnk_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Mɨreɡi Iesu rɨni pen tukwe in mə, “Mə nəɡkiariien i iakɨni rɨpkatukwatukw mhə, ni irapw kwopun nəha iakəfwəkour ikɨn. Mətə mə nəɡkiariien i iakɨni ratukwatukw a ikəpwi iou tɨ nəfe?” ");
INSERT INTO tnk_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nənə Anas rərhi pen Iesu revən tɨ pris asori anan Kaeafas. Kɨpkɨfi raka mhə nəkwus sə kɨnərihi tərini rəɡɨn mi irə. ");
INSERT INTO tnk_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saemon Pita ramərer ihi ia nɨkare napw mamərhiəpw. Ro iamɨnhi irə irəha həni pen tukwe in mə, “Ik mwi iərmama riti səvəi iəmə nəha uə rekəm?” Mɨreɡi in rɨni mə, “Rekəm. Rɨpko mhə iou iərmama riti səvənhi.” ");
INSERT INTO tnk_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nərmama me nəha səməme kamho tukwini nari m pris asori anan irəha anan riti ia kwənəkwus sə Pita rərai raka nɨfreɡɨn rəres mə, “Iakɨnətoni ik kɨmirau iəmə nəha ia nɨmei nəmhien uə rekəm?” ");
INSERT INTO tnk_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Mɨreɡi Pita rɨni mwi mə, “Rekəm. Rɨpko mhə iou.” Təkwtəkwuni a mwi rəiə rakaka. ");
INSERT INTO tnk_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ia nəpnəpɨn anan, nəmə asori me səvəi nəkur Isrel həiri Iesu, mhəier ia nimwə səvəi Kaeafas, mhəuvən ia nimwə səvəi Paelat. (Paelat in iəmə Rom sə ramərɨmənu ia tənə Jutia. Nimwə səvənhi nəɡhɨn nə mə Praetoream.) Irəha atukwatukw həpkuvnimwə mhə kamo həuvehe mhəmkemɨk ia nɨkaren səvəi nəfwakiien səvənraha, nənə mhəpwəh naniien nəveɡɨnien nəha Pasova. ");
INSERT INTO tnk_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ro iamɨnhi irə Paelat rier irapw iruə mə trətə irəha, mɨni mə, “Nəfe i noien ərəha iəmə i ro kɨmiaha hiamərpwi tukwe?” ");
INSERT INTO tnk_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Mɨreɡi irəha həni pen tukwe in mə, “Rɨpkamo iəmə i rɨpko mhə noien ərəha riti, ko kɨmiaha iahəpkuvehi mhə in mhəuvehe tukw ik.” ");
INSERT INTO tnk_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Mɨreɡi Paelat rɨni pen tɨ nirəha i mə, “Ramasam mə kɨmiaha atukwatukw a hiəuvehi iəmə i, mhəkiri noien səvənhi pwəh resi pen loa səkɨmiaha.” Mɨreɡi nəmə asori me səvəi nəkur Isrel həni pen tukwe in mə, “Mətə kɨnise kɨmaha ko iahəpkousi əpune iərmama riti.” ");
INSERT INTO tnk_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nəri i rier pehe iamɨnhi mə nəɡkiariien Iesu ruvəni raka truvehe mukuə, nəɡkiariien sə raməɡkiari ia nemhəien səvənhi mə trəfemhə irə. ");
INSERT INTO tnk_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ro iamɨnhi irə Paelat rɨrərɨɡ muvnimwə mwi ia nimwə səvənhi, məkwein Iesu, mɨni pen tukwe in mə, “Ik kiɡ səvəi nəkur Isrel?” ");
INSERT INTO tnk_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Mɨreɡi Iesu rɨni mə, “Ik atukw ikani ianhi uə nərməpə kamhəni iou mamhəni pehe tukw ik i?” ");
INSERT INTO tnk_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Mɨreɡi Paelat rɨni mə, “Rɨpko mhə iou iəmə Isrel riti. Nəkur imwam me a mɨne pris asori me həuvei pehe ik ia rəɡɨk. Nəfe noien ərəha ikɨno?” ");
INSERT INTO tnk_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Mɨreɡi Iesu rɨni mə, “Nɨtətə səiou iakamərɨmənu irə rɨpkəmwhen mhə ia nɨtətə me səvəi kiɡ me ia tɨprənə i. Ko nɨtətə sə iakamərɨmənu irə rəmwhen ia nɨtətə me səvəi kiɡ me ia tɨprənə i, iotukwininari me səiou ko hənaruaɡən raka mhəpwəh nəseniien iou mə takevən ia rəɡi nəmə asori me səvəi nəkur Isrel. Mətə nɨtətə səiou iakamərɨmənu irə rɨpkəmwhen mhə ia nɨtətə me səvəi kiɡ me ia tɨprənə i.” ");
INSERT INTO tnk_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Mɨreɡi Paelat rɨni pen tukwe in mə, “Ro ianhi ik kiɡ riti?” Mɨreɡi Iesu rɨni mə, “Ik ikani mə iou kiɡ riti. Iakɨnətui pehe ia tɨprənə i tɨ nəri kuatia, mə takɨni irapw nəɡkiariien sə ro nɨpərhienien. Iərmama sə ramərer ia nɨpərhienien ramətərɨɡ nəɡkiariien səiou.” ");
INSERT INTO tnk_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Mɨreɡi Paelat rɨni pen tukwe in mə, “Nəfe nə nɨpərhienien?” Nənə nəpɨn Paelat rɨni pam nəɡkiariien i, rɨrərɨɡ mevən mwi mətə nəmə asori me səvəi nəkur Isrel fwe iruə, mɨni pen tɨ nirəha i mə, “Iapkətə mhə nari riti in ro rərəha. ");
INSERT INTO tnk_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Mətə noien riti səkɨmiaha hiamo ia Pasova me pam. Hiaməni pehe tukw iou i nəɡhi iərmama riti sə raməmak ia kalapus, nənə iakəseni in rier irapw mamevən. Ro iamɨnhi irə kɨmiaha hiokeikei mə takəseni iəmə i in kiɡ səkɨmiaha nəkur Isrel rier mamevən?” ");
INSERT INTO tnk_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Mɨreɡi irəha həkwein əpwəmwɨs mwi mə, “Rekəm! Kɨmaha iahəpwəh nokeikeiien iəmə nəha! Kɨmaha iahokeikei Parapas!” (Parapas in iəmə ramakres, mamousi iərmama.) ");
INSERT INTO tnk_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ia nəpɨn nəha Paelat ruvehi Iesu mɨni nəkwan mə naruaɡən me səvənhi tuhərisi in. ");
INSERT INTO tnk_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ro pen irəha həuvehi in mhərisi, nənə mhəuvehi rəhi mhəuvnhi kəfəfau səvəi kiɡ irə, mhəfəfau pen ia kənkapwə, nənə mhəuvehi mwi karkahu riti rəruerəv məpwəmwɨs məmwhen ia karkahu səvəi kiɡ, mharkahu pen min, ");
INSERT INTO tnk_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","mhəuvehe ipaka tukwe, mamhəni mə, “Ik kiɡ səvəi nəkur Isrel kɨmaha iahəsiai ik!” Irəha həni ianhi, nənə mhəpwi in. ");
INSERT INTO tnk_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Paelat rɨrərɨɡ revən mwi iruə, mɨni pen tɨ nirəha i mə, “Hətə ro. Iakauvehi in mauvehe təkwtəkwuni mə tihətoni in mhəukurən mə iapkətə mhə nari riti ro rərəha.” ");
INSERT INTO tnk_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ro iamɨnhi irə Iesu rier irapw pehe iruə, məfəfau ia rəhi nəha kuvnhi kəfəfau səvəi kiɡ irə, markahu karkahu nəha rəpwəmwɨs kala səvənhi rəmwhen ia tihinatis. Nənə Paelat rɨni pen tɨ nirəha i mə, “Hətə ro! Iəmə i in i!” ");
INSERT INTO tnk_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nəpɨn pris asori me mɨne iotukwininari me səvənraha hətoni Iesu, həkwein əpwəmwɨs mə, “Ərui tərini pen in ia nei kamarkuaui! Ərui tərini pen in ia nei kamarkuaui!” Mɨreɡi Paelat rɨni pen tɨ nirəha i mə, “Kɨmiaha əpa tihəuvehi in mhərui tərini pen ia nei kamarkuaui. Kwa iou iapkətə mhə nari riti ro rərəha.” ");
INSERT INTO tnk_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Mɨreɡi nəmə asori me səvəi nəkur Isrel həni pen tukwe in mə, “Səkɨmaha riti loa. Loa nəha rani mə iəmə i traməkeikei memhə tɨ nəri nə mə rɨni mə in Tɨni Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nəpɨn Paelat rɨreɡi nəɡkiariien i, rɨreɡi rehekɨr pɨk mwi. ");
INSERT INTO tnk_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ro pen rɨrərɨɡ muvnimwə mwi ia nimwə səvənhi, mɨni pen tɨ Iesu i mə, “Ik iəmə pəku?” Mətə Iesu rəpnapen. ");
INSERT INTO tnk_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ro pen Paelat rɨni pen tukwe in mə, “Rəfo ipkəɡkiari mhə miou? Rosi ikreirei mə iakauvehi nasoriien iakukurən nəseniien ikier mamevən, nənə iakauvehi mwi nasoriien iakukurən nɨniien mə tukərui tərini pen ik ia nei kamarkuaui?” ");
INSERT INTO tnk_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Mɨreɡi Iesu rɨni pen tukwe in mə, “Ko ipkasori mhə ia nirak iamɨnhi trɨni mɨnuə Kumwesən rɨpkuvei pehe mhə nasoriien nəha mik. Ro iamɨnhi irə iəmə nəha rɨməuvei pehe iou ia rəɡɨm nərəhaien sə in rɨno rərəha məpi raka nərəhaien i ikamo.” ");
INSERT INTO tnk_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ia nəpɨn nəha mamevən Paelat raməmwur mə trəseni Iesu rier mamevən, mətə nəmə asori me səvəi nəkur Isrel kamhəkwein əpwəmwɨs mə, “Trɨni mɨnuə ikəseni iəmə i rier mamevən, Kiɡ Sisa ko rɨpkɨni mhə mə in riti nə ik. Iərmama sə rɨni mə in kiɡ riti ramərui nəkwai Kiɡ Sisa.” ");
INSERT INTO tnk_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ro iamɨnhi irə nəpɨn Paelat rɨreɡi nəɡkiariien me nəha, riri Iesu mier irapw iruə, məkure ia kwopun raməkiri nəɡkiariien ikɨn. Kani kwopun nəha mə Kwopun keipeni kəruəterei me ikɨn. Nənə nəɡkiariien Hipru rani mə Kapata. ");
INSERT INTO tnk_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ro kurkwai nəpɨn ia ran ia nəpɨn nəha kaməpnəpenə narimnari me irə səvəi nəveɡɨnien asori nəha Pasova. Paelat rɨni pen tɨ nəmə asori me səvəi nəkur Isrel mə, “Hətə ro in i kiɡ səkɨmiaha.” ");
INSERT INTO tnk_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Mɨreɡi irəha həkwein əpwəmwɨs mə, “Uvehi raka iəmə i! Uvehi raka iəmə i! Ərui tərini pen in ia nei kamarkuaui!” Mɨreɡi Paelat rɨni pen tɨ nirəha i mə, “Kɨmiaha hiokeikei mə takərui tərini pen kiɡ səkɨmiaha ia nei kamarkuaui?” Mɨreɡi pris asori me həni mə, “Sisa əpa in kiɡ səkɨmaha. Kiɡ riti mwi riwən.” ");
INSERT INTO tnk_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ro pen Paelat ruvei pen Iesu ia rəɡi naruaɡən me səvənhi mə tuhərui tərini pen in ia nei kamarkuaui. ");
INSERT INTO tnk_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Nənə irəha həuvehi Iesu, mhəier ia taon, raməvrani nei kamarkuaui səvənhi, mamevən meste kwopun nəha kani mə Kerhə ia Iərmama. Ia nəɡkiariien Hipru rani mə Kolkota. ");
INSERT INTO tnk_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ia kwopun nəha irəha hərui tərini pen Iesu ia nei kamarkuaui, mhərui tərini pen mwi iərmama kəru ia nei kamarkuaui irəhar min, riti ia nɨkaren mwatuk, riti ia nɨkaren mour, Iesu ia kurkwanrau. ");
INSERT INTO tnk_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Paelat rɨrai nəɡkiariien riti, mɨni nəkwan mə tuhərui pen ia nei kamarkuaui səvəi Iesu. Nəɡkiariien nəha rɨni iamɨnhi irə mə: IESU, IƏMƏ NASARET, KIG SƏVƏI NƏKUR ISREL. ");
INSERT INTO tnk_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Nəkur Isrel me həpɨk həvsini nəɡkiariien nəha tɨ nəri nə mə kwopun nəha hərui tərini pen Iesu ia nei kamarkuaui ikɨn ipaka tɨ taon. Kɨmərai pen nəɡkiariien nəha ia nəɡkiariien mirəhar i Hipru mɨne Latin mɨne Krik. ");
INSERT INTO tnk_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ro iamɨnhi irə pris asori me səvəi nəkur Isrel həni pen tɨ Paelat i mə, “Tikəpwəh nɨrai penien mə ‘Kiɡ səvəi Nəkur Isrel.’ Mətə tikaməkeikei mɨrai pen mə, ‘Iəmə i rɨni mə in Kiɡ səvəi Nəkur Isrel.’” ");
INSERT INTO tnk_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Mɨreɡi Paelat rɨni mə, “Rekəm. Nəfe iakɨmərai pen iakɨmərai pen.” ");
INSERT INTO tnk_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nəpɨn naruaɡən me hənərui tərini pen raka Iesu ia nei kamarkuaui, həuvehi tɨnari me səvənhi, mhəuai ia kusen kefə. Kusen riti səvəi iaruaɡən riti. Irəha həuvehi mwi karkahu əpwəmwɨs səvənhi, mətə iərmama sə rɨmətiri karkahu nəha rɨpkrɨpɨn mhə tɨnari me. Rɨmətiri fwe irənhə meiwaiu meste inhərɨpw ia tɨnari kuatia. ");
INSERT INTO tnk_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ro iamɨnhi irə naruaɡən me həni pen tɨ nirəha me i mə, “Pwəh səpwəh neitehiien, mətə pwəh səuini pen kəpwier me pwəh rahatən mə sin truvehi səvənhi.” Noien nəha rier pehe mə nəɡkiariien ia Nəkukuə Ikinan truvehe mukuə, nəɡkiariien sə rɨni iamɨnhi irə mɨnuə, “Irəha həuai tɨnari me səiou ia nirəha me, nənə mhəuini pen kəpwier me tɨ karkahu səiou.” In i narimnari me nəha naruaɡən me nəha həno. ");
INSERT INTO tnk_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Mama səvəi Iesu, mɨne piəvi mama səvənhi, mɨne Meri pran səvəi Klopas, mɨne Meri Maktala, irəha kamhərer ipaka tɨ nei kamarkuaui səvəi Iesu. ");
INSERT INTO tnk_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Iərmama riti səvəi Iesu, sə Iesu rokeikei pɨk in, in mwi ramərer ipaka. Nəpɨn Iesu rətoni iəmə nəha mɨne mama səvənhi, rɨni pen tɨ mama səvənhi mə, “Prən i. Iəmə i in i nərɨm.” ");
INSERT INTO tnk_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nənə rɨni pen tɨ iərmama səvənhi mə, “Prən i in i mama səim.” Ro iamɨnhi irə ia nəpɨn atukwatukw nəha mamevən iərmama nəha səvəi Iesu ramətui amasan tɨ prən nəha rəmwhen ia in mama səvənhi. ");
INSERT INTO tnk_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Iesu rɨni pam nəɡkiariien i, mukurən mə narimnari me pam səməme in ruvehe mə tro, rɨno pam. Nənə mə tro nəɡkiariien ia Nəkukuə Ikinan ruvehe mukuə, in rɨni mə, “Iakɨnəkwakwa.” ");
INSERT INTO tnk_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nari riti raməkure ikɨn rukuər ia waen sə rəfiə. Ro pen irəha heitesi pen koten riti ia waen nəha, mhəpiri pen ia rəɡi nei riti kani mə hisop, nənə mhəuvehi utə pen ia tərhui Iesu. ");
INSERT INTO tnk_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Nəpɨn Iesu ruvətɨmwi raka waen nəha, rɨni mə, “Narimnari me pam iakɨno pam.” Nənə in rərpəsuk, məseni pen nɨmɨruien səvənhi, memhə. ");
INSERT INTO tnk_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nəpɨn nəha kaməpnəpenə irə narimnari me səvəi nəveɡɨnien asori nəha Pasova. Trakwakwi irə Sapat riti sə rasori musəpə ia Sapat me nepwɨn. Nəmə asori me səvəi nəkur Isrel həpwəh nokeikeiien mə nɨpwrai nəmə me nəha kahar tuamharəɡher ia nei kamarkuaui ia nəpɨn nəha. Ro pen həuvən mhəres Paelat mə trətefi nɨsunraha mə irəhar tuharemhə akwauakw nənə irəha həukurən nuvehi rakaien nɨpwranraha. ");
INSERT INTO tnk_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ro iamɨnhi irə naruaɡən me nepwɨn həuvən mhətefi nɨsui iəmə mi nəha kəru kərui tərini pen irau ia nei kamarkuaui irəhar Iesu. Hətefi sə rukupwən məɡher, nənə mhətefi mwi sə rukurirə i. ");
INSERT INTO tnk_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Mətə nəpɨn irəha həuvehe tɨ Iesu, mhətoni mə ruvamhə raka, həpwəh nətefiien nɨsun mi. ");
INSERT INTO tnk_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Mətə iaruaɡən riti ia nirəha rəpi nɨkau irə ia nitei, nənə təkwtəkwuni a mwi netə mɨne nui krouier. ");
INSERT INTO tnk_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Iərmama riti nəha ikɨn rɨnətə narimnari me nəha ia nənimen. In rɨnəɡkiari raka irə, mə kɨmiaha mwi hiəukurən nɨniien nɨpərhienien irə. Nəɡkiariien səvənhi ro nɨpərhienien. Nənə in rukurən mə in rani nəɡkiariien sə ro nɨpərhienien. ");
INSERT INTO tnk_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Kɨno narimnari me nəha mə nəɡkiariien i ia Nəkukuə Ikinan truvehe mukuə. Rɨni mə, “Tukəpwəh nətefiien nɨkəkrin riti.” ");
INSERT INTO tnk_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nənə nəɡkiariien riti mwi ia Nəkukuə Ikinan rɨni mə, “Irəha tuhəti pen mhətoni iəmə nəha hənəpi in ia nitei.” ");
INSERT INTO tnk_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kɨno pam narimnari me nəha nənə iəmə Aramatia riti nəɡhɨn nə Josef revən məres Paelat mə trəseni in ruvehi raka nɨpwrai Iesu. Josef in iərmama riti səvəi Iesu, mətə ramərkwafə in tɨ nəri nə mə ramhekɨr nəmə asori me səvəi nəkur Isrel. Paelat rəseni, ro pen Josef revən muvehi raka nɨpwrai Iesu. ");
INSERT INTO tnk_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikotimas, iəmə sə rɨmavən mətə Iesu ia nəpɨn, in mwi revən irau Josef, mauvehi kuse nari penpen mi nəha mɨr mɨne alos. Kuse nəri nəha in rauvehi nɨpamien səvənhi ipaka tɨ toti kilo. ");
INSERT INTO tnk_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Irau krouvehi nɨpwrai Iesu rouveɡi ia tɨnari kani mə linen irəhar nari penpen mi nəha mɨr mɨne alos. Noien nəha ramesi pen nəfe nəkur Isrel kamho ia iərmama remhə. ");
INSERT INTO tnk_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Nənə nəmhien riti ipaka tɨ kwopun nəha kɨnərui tərini pen Iesu ia nei kamarkuaui ikɨn. Ia reri nəmhien nəha nɨpəɡi kəruəterei riti sə vi kɨpkərkwafə raka mhə nɨpwrai iərmama remhə irə. ");
INSERT INTO tnk_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nəpɨn nəha nəpɨn nəkur Isrel kamhəpnəpenə tɨ Sapat irə. Nənə tɨ nəri nə mə nɨpəɡi kəruəterei nəha ipaka, irau krouəmri pen nɨpwrai Iesu irə. ");
INSERT INTO tnk_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sante ia nəpnəpɨn anan rapitpitəv ihi, Meri Maktala revən ia nɨpəɡi kəruəterei kɨnərkwafə nɨpwrai Iesu ikɨn, mətoni mə kəruəterei sə ramərer tukuahaɡ tərhui nɨpəɡ nəha kɨnəpəkɨr raka raka i. ");
INSERT INTO tnk_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ro pen Meri raiu mevən tɨ Saemon Pita mɨne iərmama riti mwi səvəi Iesu, sə Iesu rokeikei pɨk in, nənə mɨni pen tɨ nirau i mə, “Irəha həuvehi raka nɨpwrai Iərɨmənu səkɨtaha ia nɨpəɡi kəruəterei, nənə kɨmaha iahəreirei mə həmri pen in pəku.” ");
INSERT INTO tnk_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ro iamɨnhi irə Pita rier irau in riti nəha in mwi iərmama riti səvəi Iesu, krauaiu rauevən fwe ia nɨpəɡ. ");
INSERT INTO tnk_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Irau krauaiu pərpəri rauevən, mətə iəmə nəha in mwi iərmama riti səvəi Iesu rəvtənhi Pita, mukupwən mier pen fwe ia nɨpəɡ, ");
INSERT INTO tnk_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","mərpəsuk, məti puvnimwə, mətoni tɨnari me nəha linen kamhəmak, mətə in rɨpkuvnimwə mhə. ");
INSERT INTO tnk_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Nənə Saemon Pita rukurirə in muvehe, muvnimwə ia nɨpəɡ, mətoni tɨnari me nəha linen kamhəmak. ");
INSERT INTO tnk_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","In rətoni mwi tɨnari nəha kɨməveɡi kənkapwə Iesu irə rɨpkəmak pəri mhə irəha tɨnari me nəha linen, mətə kɨnərfe kəmri ia kwopun əpə. ");
INSERT INTO tnk_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nənə iərmama nəha səvəi Iesu, sə rukupwən mier pen fwe ia nɨpəɡ, in mwi ruvnimwə mətoni narimnari me nəha, nənə mɨni nɨpərhienien irə. ");
INSERT INTO tnk_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Mətə meste pehe nəpɨn nəha irau kroureirei ihi nɨpwrai nəɡkiariien me nəha ia Nəkukuə Ikinan səməme kamhəni mə Iesu traməkeikei mətui mwi ia nemhəien səvənhi.) ");
INSERT INTO tnk_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nənə iərmama mi nəha səvəi Iesu krourərɨɡ rauevən fwe imwənrau. ");
INSERT INTO tnk_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mətə Meri ramərer iruə ia nɨpəɡi kəruəterei mamasək. In ramasək ihi, mərpwəsuk, məti puvnimwə ia nɨpəɡ, ");
INSERT INTO tnk_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","mətoni aɡelo mi kəru tɨnari səvənrau rəpsan krauəkure ia kwopun nɨpwrai Iesu rɨnaməmak ikɨn, riti ia kənkapwə riti ia nɨsun. ");
INSERT INTO tnk_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nənə irau krouni pen tukwe in mə, “Prən i. Ikamasək tɨ nəfe?” Mɨreɡi Meri rɨni pen tɨ nirau i mə, “Irəha həuvehi raka nɨpwrai Iərɨmənu səiou, nənə iakreirei mə hənəmri pen in pəku.” ");
INSERT INTO tnk_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Meri rɨni pam nəɡkiariien i, muvsini in, mətoni Iesu ramərer ia kwopun nəha, mətə rɨreirei mə Iesu nəha. ");
INSERT INTO tnk_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Mɨreɡi Iesu rɨni pen tukwe in mə, “Prən i. Ikamasək tɨ nəfe? Ikamətui sin?” Mətə Meri rerɨn rɨrhi mə iəmə nə iəmə sə ramətui tɨ nəmhien nəha. Ro pen rɨni pen tukwe in mə, “Iəmə asori. Trɨni mɨnuə ik ikɨməuvehi raka nɨpwran, ni pehe tukw iou i kwopun nəha ikɨnəmri pen ikɨn, nənə iou takevən muvehi raka.” ");
INSERT INTO tnk_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Mɨreɡi Iesu rɨni pen tukwe in mə, “Meri.” Meri ruvsini in, məɡkiari pen min ia nəɡkiariien Hipru, mɨni mə, “Raponi.” (Raponi nɨpwran mə Iahatən.) ");
INSERT INTO tnk_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Mɨreɡi Iesu rɨni pen tukwe in mə, “Tikəpwəh nəɡherien ia nirak. Iapkutə mhə ihi mevən tɨ Tata Kumwesən. Mətə tikevən mətə piak me, mɨni pen tɨ nirəha i mə iakani iamɨnhi irə mə, ‘Iakautə mamevən tɨ Tata səiou mɨne Tata səkɨmiaha. Iakamevən tɨ Kumwesən səiou mɨne Kumwesən səkɨmiaha.’” ");
INSERT INTO tnk_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ro pen Meri Maktala revən, mɨni irapw tɨ nərmama me səvəi Iesu mə, “Iakɨnətə Iərɨmənu səkɨtaha,” marə mɨni mwi narimnari me i Iesu rɨməni pen tukwe. ");
INSERT INTO tnk_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nəpɨn nəha Sante. Ia nəruarəv nərmama me səvəi Iesu housəsɨmwɨn irəha me ia nəkwai nimwə riti, mhərəpinhə əknekɨn ia təpinhə me tɨ nəri nə mə həhekɨr nəmə asori me səvəi nəkur Isrel. Ia nəpɨn nəha Iesu ruvehe mərer ia kurkwanraha, mɨni pen tɨ nirəha i mə, “Nəmərinuien tramarə tukumiaha.” ");
INSERT INTO tnk_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","In rɨni pam nəɡkiariien i, nənə mahatən təmwki nil ia rəɡɨn mi mɨne təmwki nitei ia nɨkau irə. Nəpɨn nərmama me səvənhi hətoni Iərɨmənu səvənraha, rerɨnraha raɡien. ");
INSERT INTO tnk_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Nənə Iesu rɨni pen mwi tɨ nirəha i mə, “Nəmərinuien tramarə tukumiaha. Tata Kumwesən rərhi pehe iou iakuvehe. Ia noien nəha iou mwi iakamərhi pen kɨmiaha tihəuvən.” ");
INSERT INTO tnk_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nəpɨn in rɨni pam nəɡkiariien i, reiahaɡ pen ia nirəha, mɨni pen tɨ nirəha i mə, “Həuvehi Nənɨmwɨn Ikinan. ");
INSERT INTO tnk_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Trɨni mɨnuə kɨmiaha hiəni pen tɨ iərmama riti mə ‘Kumwesən trəpwəh nərpwɨnien noien ərəha me səim,’ nənə Kumwesən trəpwəh nərpwɨnien. Rəmwhen a mwi trɨni mɨnuə kɨmiaha hiəni pen tɨ iərmama riti mə, ‘Kumwesən trərpwɨn noien ərəha me səim,’ nənə Kumwesən trərpwɨn pen min.” ");
INSERT INTO tnk_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ia nəpɨn nəha Tomas, riti ia nərmama me twelef səvəi Iesu, kani mwi in mə “Mwirmwir” riwən irəha mɨnraha nəpɨn Iesu rɨməuvehe irə. ");
INSERT INTO tnk_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ro pen nərmama me səvəi Iesu səməme hənətoni in həni pen tɨ Tomas i mə, “Kɨmaha iahənətə Iərɨmənu səkɨtaha.” Mətə Tomas rɨni pen tɨ nirəha i mə, “Takaməkeikei mətoni təmwki nil ia rəɡɨn mi, mɨrapi ruei nil mi nəha ia nəkwai rəɡɨk. Təmwki nitei ia nɨkau irə takaməkeikei mɨrapi ia rəɡɨk. Mə iapko mhə iamɨnhi ko iapkɨni mhə nɨpərhienien irə.” ");
INSERT INTO tnk_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nəfwakiien riti ruvehe mukurau, nərmama me səvəi Iesu həuvnimwə mwi ia nimwə nəha, Tomas irəha mɨnraha. Nəri auər a hərəpinhə əknekɨn ia təpinhə me, mətə Iesu ruvehe mərer ia kurkwanraha, mɨni mə, “Nəmərinuien tramarə tukumiaha.” ");
INSERT INTO tnk_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Marə mɨni pen tɨ Tomas i mə, “Osə pehe nəkwai rəɡɨm, mɨrapi rəɡɨk mi. Osə pehe rəɡɨm, mɨrapi nɨkau ia nirak. Tikaməkeikei mɨni nɨpərhienien, məpwəh nɨniien mwi mə neikuəien.” ");
INSERT INTO tnk_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Mɨreɡi Tomas rɨni mə, “Iərɨmənu səiou mɨne Kumwesən səiou.” ");
INSERT INTO tnk_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Mɨreɡi Iesu rɨni pen tukwe in mə, “Ikani nɨpərhienien ia nirak tɨ nəri nə mə ikətə iou. Nərmama me nəha səməme həpkətə mhə iou, mətə kamhəni nɨpərhienien ia nirak, rerɨnraha traɡien.” ");
INSERT INTO tnk_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iesu rɨno nɨmtətien me rɨpɨk mwi ia nəmri nərmama me səvənhi iapkrai pen mhə irəha ia nəkukuə i. ");
INSERT INTO tnk_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Mətə səməme i iakɨmərai pen ia nəkukuə i iakrai pen mə kɨmiaha tihəni nɨpərhienien ia Iesu mə in nə Kristo, Tɨni Kumwesən. Iakuə kɨmiaha tihəni nɨpərhienien irə, nənə mhəuvehi nɨmɨruien ia nəɡhɨn. ");
INSERT INTO tnk_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kurirə ikɨn Iesu rier irapw mwi ia nəmri nərmama me səvənhi ia nɨkare nui asori Taepirias. In rier irapw ia nəmrɨnraha iamɨnhi irə: ");
INSERT INTO tnk_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nəpɨn riti Saemon Pita, mɨne Tomas sə kani in mə “Mwirmwir,” mɨne Nataniel sə ruku pen ia Kena ia tənə Kalili, mɨne tɨni Sepeti mi, mɨne iərmama kəru mwi səvəi Iesu housəsɨmwɨn irəha me ia kwopun kuatia. ");
INSERT INTO tnk_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Nənə Saemon Pita rɨni pen tɨ nirəha i mə, “Iakamevən takvi nəmu me.” Mɨreɡi irəha həni pen tukwe in mə, “Itə. Pwəh kɨtaha pam səuvən.” Ro pen irəha heiwaiu mhəputə ia nɨtətə ouihi riti, mhəuvən mhəvi net meste rɨran, mətə həpkuvi mhə nəmu riti. ");
INSERT INTO tnk_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nəpɨn rɨnamran Iesu ramərer ia nɨkare nui asori, mətə nərmama me səvənhi həreirei mə Iesu nəha. ");
INSERT INTO tnk_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Iesu rɨni pen tɨ nirəha i mə, “Nəkwərhakwərha me, nəmu riti nə hiəvi uə?” Mɨreɡi həni mə, “Rekəm.” ");
INSERT INTO tnk_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Mɨreɡi in rɨni pen tɨ nirəha i mə, “Herukw ro net səkɨmiaha ia nɨkare nɨtətə ouihi mwatuk, nənə tihətoni nepwɨn.” Ro iamɨnhi irə irəha herukw irapw net, mhəuvəreirei nɨvi utəien mwi tɨ nəri nə mə nəmu me həuvəukuər ia nəkwai net. ");
INSERT INTO tnk_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nənə iərmama səvəi Iesu, sə nəha Iesu rokeikei pɨk in, rɨni pen tɨ Pita i mə, “Kwa Iərɨmənu nəha səkɨtaha.” Ia nəpɨn nəha Saemon Pita rɨməpeki raka tɨnari me səvənhi maməvi nəmu me, mətə nəpɨn rɨreɡi mə Iərɨmənu nəha, in ruvei pen mwi tɨnari me səvənhi, məruərau irapw ia nui, meiai muvarei. ");
INSERT INTO tnk_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nərmama səvəi Iesu ia nəkwai nɨtətə ouihi həsuə a mhəuvarei, mhəvkəkini net sə nəmu me həukuər irə. Rɨpko mhə irəha isipwɨn tɨ nɨkare nui, mətə həsuə a rəmwhen ia hantret meta. ");
INSERT INTO tnk_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nəpɨn həuvarei irə hətoni bred mɨne nəmu me ramrɨmər pen ia nukumheəv ia napw. ");
INSERT INTO tnk_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Nənə Iesu rɨni pen tɨ nirəha i mə, “Həpeki nəmu me nepwɨn sə hiəpkuvi a i, mhəpeki mhəuvehe.” ");
INSERT INTO tnk_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ro iamɨnhi irə Saemon Pita rəputə ia nɨtətə ouihi, muvi parei net rukuər ia nəmu asori me irəha pam wan hantret fifti tri. Nəri auər a mə nəmu me həpɨk iamɨnhi, mətə net rɨpkəpəruəpəruə mhə. ");
INSERT INTO tnk_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Iesu rɨni pen tɨ nirəha i mə, “Həuvehe mhani nari.” Ia nəpɨn nəha nərmama me səvənhi həhekɨr. Irəha riti riwən rəres in mə, “Ik sin i?” Irəha həuvəukurən raka mə in nə Iərɨmənu səvənraha. ");
INSERT INTO tnk_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nənə Iesu ruvehe, muvehi bred, muvei pen mɨnraha, marə mo mwi iamɨnhi ia nəmu me. ");
INSERT INTO tnk_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","In i nəpɨn sə ro kahar irə Iesu rier irapw ia nəmri nərmama me səvənhi nəpɨn rɨnətui mwi ia nemhəien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nəpɨn irəha hənani raka nari, Iesu rɨni pen tɨ Saemon Pita i mə, “Saemon, tɨni Jon, ikokeikei pərhien iou məpi raka irəha i uə rekəm?” Mɨreɡi Pita rɨni pen tukwe in mə, “Ouəh, Iərɨmənu, ikukurən mə iakokeikei pərhien ik.” Mɨreɡi Iesu rɨni pen tukwe in mə, “Əkwməni kwəti sipsip me səiou.” ");
INSERT INTO tnk_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nənə Iesu rəres mwi sə ro kəru irə, mɨni mə, “Saemon, tɨni Jon, ikokeikei pərhien iou uə rekəm?” Mɨreɡi Pita rɨni pen tukwe in mə, “Ouəh, Iərɨmənu, ikukurən mə iakokeikei pərhien ik.” Mɨreɡi Iesu rɨni pen tukwe in mə, “Ətui amasan tɨ sipsip me səiou.” ");
INSERT INTO tnk_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Nənə Iesu rəres mwi sə ro kahar irə, mɨni mə, “Saemon, tɨni Jon, ikokeikei pərhien iou uə rekəm?” Pita rɨreɡi rərəha tɨ nəri nə mə Iesu rəres sə ro kahar irə mɨnuə “Ikokeikei pərhien iou uə rekəm?” Ro pen rɨni pen tukwe in mə, “Iərɨmənu, ikukurən narimnari me pam, mukurən mwi mə iakokeikei pərhien ik.” Mɨreɡi Iesu rɨni pen tukwe in mə, “Əkwməni sipsip me səiou. ");
INSERT INTO tnk_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Iakani nɨpərhienien tukw ik i fwe kupwən nəpɨn ikɨnamouihi irə ikɨnamarkahu atukw səim, mamavən ia kwopun pəku ikokeikei, mətə nəpɨn tikərɡharə, tikus atukw rəɡɨm mi, nənə iərmama əpə iti trarkahu pehe mik, muvehi ik ikevən ia kwopun sə ipkokeikei mhə mə tikevən ikɨn.” ");
INSERT INTO tnk_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Iesu rɨni nəɡkiariien i mahatən nəfe nemhəien Pita tremhə irə muvehi utə nəɡhi Kumwesən.) Nəpɨn rɨni pam, mɨni pen tɨ Pita i mə, “Kurirə iou.” ");
INSERT INTO tnk_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ia nəpɨn nəha Pita rəti kurirə, mətoni iərmama riti səvəi Iesu, sə Iesu rokeikei pɨk in, rakurirə ia nirau. Iərmama nə in nə iərmama sə fwe kupwən raməkure ipaka tɨ Iesu nəpɨn kamhani pəri nari irə, nənə məres pen in mə, “Iərɨmənu, sin nə truvei pen ik ia rəɡi nərmama səməme haməmwəki ik?” ");
INSERT INTO tnk_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nəpɨn Pita rətoni iəmə nəha rakurirə ia nirau, rɨni pen tɨ Iesu i mə, “Iərɨmənu mətə rəfo ia iəmə nəha?” ");
INSERT INTO tnk_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Mɨreɡi Iesu rɨni pen tukwe in mə, “Rəfo ikəres iəmə nəha miou? Trɨni mɨnuə iakokeikei mə in trɨmɨru mamevən meste nəpɨn sə takuvehe irə, səkɨmrau min əpa. Mətə ik tikukurirə iou.” ");
INSERT INTO tnk_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ro iamɨnhi irə nəɡkiariien riti rauvirɨs ia piəvtaha me mə iərmama nəha səvəi Iesu trɨpkemhə mhə. Mətə Iesu rɨpkɨni pen mhə tɨ Pita i mɨnuə “Iəmə nəha trɨpkemhə mhə.” In rɨni mə, “Rəfo ikəres iəmə nəha miou? Trɨni mɨnuə iakokeikei mə in trɨmɨru mamevən meste nəpɨn sə takuvehe irə, səkɨmrau min əpa.” ");
INSERT INTO tnk_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Iərmama nəha səvəi Iesu in a mwi nəha rani irapw narimnari me i, mamrai nəɡkiariien me i. Nənə kɨtaha səukurən mə nəɡkiariien səvənhi ro nɨpərhienien. ");
INSERT INTO tnk_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Nənə narimnari me rɨpɨk mwi nəha ikɨn Iesu rɨno. Tuko kɨrai pen pam irəha ia nəkukuə, rosi ko təkure tɨprənə i rɨpkəmwhen mhə mə trəkwtəmhiri nəkukuə me pam. ");
INSERT INTO tnk_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Iou riti Teofilas: Ia nəkukuə kupwən səiou sə iakuvərai raka mik iakuvəni raka narimnari me pam Iesu ramo mɨne nəɡkiariien me pam ramahatən nərmama me irə fwe kupwən. Iakɨməni fwe ia nukune wok səvənhi muvehe ");
INSERT INTO tnk_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","meste nəpɨn nəha in raməvəhaɡ m aposol me səvənhi səməme in rɨnərpwi rəɡɨn ia nirəha. In raməvəhaɡ mɨnraha, mauvei pen nəɡkiariien riti rauku pen tɨ Nənɨmwɨn Ikinan. Nəpɨn ruvei pen pam, kuvehi utə in revən fwe ia neiai. ");
INSERT INTO tnk_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nəpɨn Iesu ruvəreɡi raka nəmisəien səvənhi, rarə mwi nəpɨn foti. Ia nəpɨn me nəha ramier irapw tɨ aposol me nəha. Nəpɨn rɨpɨk ramərer ia nəmrɨnraha, mamo irəha hamətoni mə ruvəmɨru pərhien. Irəha kamhətə in, nənə in rani narimnari me ia nɨkaren səvəi nɨtətə sə Kumwesən ramərɨmənu irə. ");
INSERT INTO tnk_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nəpɨn riti raməni pəri nari irəha mɨnraha, nənə mɨni pen tɨ nirəha i mə, “Tihəpwəh nierien ia Jerusalem, mətə tihameitenhi Nənɨmwɨn Ikinan sə Tata səiou rɨno raka promes mə truvei pehe m kɨmiaha. Hiəuvəreɡi raka iou iakaməɡkiari irə fwe kupwən, mamɨni mə, ");
INSERT INTO tnk_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","‘Jon rɨno paptaes ia nui, mətə rɨpko mhə tui Kumwesən tro paptaes ia kɨmiaha ia Nənɨmwɨn Ikinan.’” ");
INSERT INTO tnk_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nənə nəpɨn riti mwi, nəpɨn aposol me housəsɨmwɨn irəha me, kamhəres pen Iesu i mə, “Iərɨmənu, tikərɨmənu ia nəkur Isrel nəha təkwtəkwuni rəmwhen ia kiɡ kupwən me səvənraha uə rekəm?” ");
INSERT INTO tnk_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Mətə Iesu rɨni pen tɨ nirəha i mə, “Tata səiou rauvehi nasoriien mɨnəmri raka nəpɨn me pam. Rɨpko mhə səkɨmiaha tihəukurən mə tɨnesən nəpɨn me nəha tuhəier irapw. ");
INSERT INTO tnk_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Mətə nəpɨn Nənɨmwɨn Ikinan truvehe ia kɨmiaha, tihəuvehi nɨskaiien. Nənə tihaməkeikei mhəuvən, mhəvisau irapw iou fwe Jerusalem, mɨne ia kwopun me pam fwe ia tənə Jutia mɨne Sameria, mhəuvən mheste tənəmtənə me pam.” ");
INSERT INTO tnk_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nəpɨn Iesu rɨni pam nəɡkiariien me nəha, kuvehi utə in rautə. Nərmama me səvənhi kamhəti pen mamhətoni in meste nəpuə riti rousəman. Kurirə irə həpkətoni mhə mwi in. ");
INSERT INTO tnk_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nəpɨn Iesu rautə mamevən, irəha kamhəkwətə ihi ia nɨmaɡouaɡou, nənə təkwtəkwuni a iəmə mi kəru səvənrau tɨnari rəpsan krouier irapw tɨ nirəha, rouərer ia nɨkarenraha, ");
INSERT INTO tnk_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","rouni mə, “Nəmə Kalili! Rəfo hiamərer ia kwopun i, mamhəti utə ia nɨmaɡouaɡou? Iesu i sə kuvehi raka tukumiaha, kuvehi utə revən fwe ia neiai, in truvehe rəmwhen a mwi hiənətoni rautə ia nɨmaɡouaɡou mamevən.” ");
INSERT INTO tnk_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kurirə ikɨn aposol me həier ia təkuər nəha kani mə Təkuər Olif mhərərɨɡ mamhəuvən fwe Jerusalem. (Təkuər nəha Olif raməkure ipaka tɨ Jerusalem rəmwhen ia wan kilometa.) ");
INSERT INTO tnk_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nəpɨn irəha həier pen fwe taon, mhəutə pen fwe ia rum nəha irənhə kwopun kamharə ikɨn. Nəɡhɨnraha me i: Pita, Jon, Jemes, Antru, Filip, Tomas, Patolomiu, Matiu, Jemes tɨni Alfeas, Saemon (iəmə sə kupwən rakurirə ia səməme haməmwur mə tuhəkoui irapw nəkur Rom), mɨne Jutas tɨni Jemes. ");
INSERT INTO tnk_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ia nəpɨn me nərmama me nəha nətərɨɡien səvənraha kuatia. Kamhousəsɨmwɨn irəha me, mamhəfwaki. Meri, mama səvəi Iesu, mɨne piəvi Iesu me, mɨne nɨpran səməme kamhəni nɨpərhienien ia Iesu irəha mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nəpɨn me nepwɨn həukurau, nənə piəvtaha me housəsɨmwɨn irəha me ia kwopun kuatia. (Irəha pam ipaka tɨ wan hantret twenti.) Nənə Pita rɨskəmter ia rerɨnraha mɨni mə, ");
INSERT INTO tnk_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Nərman, piak me, fwe kupwən Nənɨmwɨn Ikinan ruvei pen nəɡkiariien səvənhi m Kiɡ Tevɨt mə trukupwən mɨni irapw Jutas, iəmə sə rɨməiri nərmama me həuvən mhəkwtəmhiri Iesu. Nəɡkiariien nəha ruvəuvehe muvəukuə raka, tɨ nəri nə mə nəɡkiariien me pam kɨmərai pen ia Nəkukuə Ikinan tuhaməkeikei mhəuvehe mhəukuə. ");
INSERT INTO tnk_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jutas nəha fwe kupwən Iesu rɨnərpwi rəɡɨn irə mə truvehe mo aposol riti səvənhi kɨmaha min.” ");
INSERT INTO tnk_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Iəmə nəha rɨno noien ərəha, muvehi mane irə, muvehi mevən muvehi nəmri tɨprənə i. Fwe ia tɨprənə nəha in rɨmwei irapw, tɨpwɨn rəpəruə, nəninhə irə rier. ");
INSERT INTO tnk_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nərmama səməme kamharə fwe Jerusalem həreɡi nəvisauien səvənhi, nənə həuvei pen nəɡhi kwopun nəha ia nəɡkiariien səvənraha mə Akeltama. Nɨpwrai nəɡkiariien nəha in i mə Tɨprənə sə Netə Rɨnaiu Ikɨn.) ");
INSERT INTO tnk_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita rɨrɨpɨn nəɡkiariien mɨni mə, “Nəɡkiariien i sə kɨmərai pen ia nəkukuə nəha Ol Sam raməɡkiari ia Jutas. Rɨni mə, ‘Pwəh səvənhi rukwənu ruvehe mərkun. Iərmama trəpwəh narəien ikɨn.’ Kɨmərai pen mwi mə, ‘Pwəh iərmama riti mwi ruvehi təmwhekɨn, mo səvənhi wok.’ ");
INSERT INTO tnk_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Ro iamɨnhi irə kɨtaha tsaməkeikei mhəuvehi utə iərmama riti truvehi təmwki Jutas. Kɨmaha min tahəvisau irapw mə iahənətoni ia nəmrɨmaha mə Iesu rɨnətui mwi pərhien ia nemhəien səvənhi. Pwəh səuvehi utə iərman riti sə rɨnakurirə ia kɨmaha ia nəpɨn me pam nəha Iesu Iərɨmənu səkɨtaha rɨnamavən kɨmaha min. Rɨnostat mukurirə ia kɨmaha ia nəpɨn nəha Jon rɨnamo paptaes ia nərmama muvehe meste nəpɨn nəha kuvehi utə Iesu revən fwe ia neiai.” ");
INSERT INTO tnk_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita rɨni pen pam, nənə irəha həni irapw nəɡhi iərmama kəru. Nəɡhɨnrau Josef mɨne Matias (Josef nəha kaməkwein mwi in mə Pasapas mɨne Jastas.) ");
INSERT INTO tnk_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Nənə irəha həfwaki, mhəni mə, “Iərɨmənu, ikukurən nətərɨɡien səvəi nərmama me pam. Tiko mahatən ro m kɨmaha i mə iərman mi sə pəku nəha ikokeikei mə ");
INSERT INTO tnk_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","truvehe mo in aposol, muvehi təmwki Jutas, iəmə sə rɨnəpwəh wok nəha mə trevən ia kwopun atukwatukw səvənhi.” ");
INSERT INTO tnk_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nənə irəha həuini nəri sə ramahatən pen nari mə sin nəha truvehi wok nəha. Nənə nəri nəha rahatən pen mə Matias. Nənə həvsini pen in irəha aposol me eleven. ");
INSERT INTO tnk_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nəpɨn asori nəha Pentekos ruvəuvehe. Ia nəpɨn nəha nərmama pam səvəi Iesu housəsɨmwɨn irəha me ia kwopun kuatia. ");
INSERT INTO tnk_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Təkwtəkwuni a həreɡi nari riti rəmwhen ia nɨmətaɡi asori ruku pen ia nɨmaɡouaɡou muvnimwə masori ia nimwə nəha kamhəkure ikɨn. ");
INSERT INTO tnk_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Hətə nərami napw me həivə kɨrkɨri, mhəuvən, mhərer ia kənkapwənraha kuatia kuatia. ");
INSERT INTO tnk_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Irəha pam rerɨnraha ruvehe mukuər ia Nənɨmwɨn Ikinan. Nənə Nənɨmwɨn nəha ruvei pen nəɡkiariien mɨnraha hənaməɡkiari ia nəɡkiariien me səpəmsəpə. ");
INSERT INTO tnk_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ia nəpɨn nəha nəkur Isrel me həpɨk kamharə fwe Jerusalem. Irəha nəha nəməfwaki me həməuku pen fwe ia tənəmtənə me mhəuvehe. ");
INSERT INTO tnk_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nəpɨn həreɡi narimnari me nəha, housəsɨmwɨn pen irəha me ipaka tukwe. Irəha hamərkərinari tɨ nəri nə mə nəɡkiariien me səvənraha səpəmsəpə sə hənətui pen irə, irəha kamhəreɡi nərmama me səvəi Iesu kamhəɡkiari ia nəɡkiariien me nəha. ");
INSERT INTO tnk_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nənimenraha rier. Həreirei, mamhəni pen tɨ nirəha me i mə, “Hətə ro. Nərmama me nəha kamhəɡkiari irəha pam nəkur Kalili. ");
INSERT INTO tnk_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Mətə rəfo kɨtaha saməreɡi kamhəɡkiari ia nəɡkiariien me səkɨtaha me səpəmsəpə sə sənətui pehe irə? ");
INSERT INTO tnk_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kɨtaha i nəmə Patia, mɨne nəmə Metia, mɨne nəmə Elam. Kɨtaha nepwɨn samarə ia Mesopotemia, mɨne Jutia, mɨne Kapatosia, mɨne Pontas, mɨne Esia, ");
INSERT INTO tnk_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","mɨne Frijia, mɨne Pamfilia, mɨne Ijip, mɨne Krit, mɨne Arepia, mɨne tənə nəha Lipia ipaka tɨ Saerin. Kɨtaha nepwɨn həuku pen fwe ia Rom. Kɨtaha nepwɨn nəkur Isrel atukwatukw, nənə kɨtaha nepwɨn rɨpko mhə kɨtaha nəkur Isrel, mətə samarə ia narəien səvənraha. Mətə kɨtaha pam saməreɡi nərmama me nəha kamhəɡkiari ia nəɡkiariien me səkɨtaha me, mamhəni irapw wok asori me Kumwesən rɨno.” ");
INSERT INTO tnk_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nənə irəha nənimenraha rier. Həreirei, mamhəres pen irəha me i mə, “Nəri nəha nɨpwran rəfo irə?” ");
INSERT INTO tnk_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Mətə irəha me nepwɨn harɨs, mhəni mə, “Nərmama me nəha kamhənɨmwi waen, mamhakonə irə!” ");
INSERT INTO tnk_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Mətə Pita rɨskəmter irəha Eleven Aposol me, məɡkiari asori, mɨni pen tɨ nirəha i mɨnuə, “Nəmə Jutia mɨne kɨmiaha pam nərmama hiamarə ia Jerusalem, tiho mhətərɨɡ ro iou, pwəh iakɨni pehe nɨpwrai nəri nəha tukumiaha i. ");
INSERT INTO tnk_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Hiaməni mə nərmama me i hakonə ia waen, mətə rekəm. Irəha həpwəh nakonəien. Kwa naen klok a i ia nəpnəpɨn. ");
INSERT INTO tnk_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nəri nəha hiamətoni ramesi pen nəɡkiariien i Joel Profet rɨməni fwe kupwən: ");
INSERT INTO tnk_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Kumwesən rɨni mə, ‘Tramevən ipaka tɨ nəpɨn sampam, iou takərhi irapw nənɨmwɨn səiou trevən tɨ nərmama me pam. Nɨpwnətɨmiaha me nərman mɨne nɨpran tuhəni irapw nəɡkiariien sə ruku pen tɨ Nənɨmwɨn səiou. Ntəmaruə me səkɨmiaha me tuhətə vison me. Nərɡharə me səkɨmiaha me tuhəməkrəha. ");
INSERT INTO tnk_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ia nəpɨn nəha nərmama me səiou kani irəha mə iotukwininari me, nəri auər a mə irəha nərman uə nɨpran, mətə takərhi irapw Nənɨmwɨn səiou trevən tɨ nirəha, nənə irəha tuhəni irapw nəɡkiariien sə ruku pen tɨ Nənɨmwɨn səiou. ");
INSERT INTO tnk_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Tako narimnari me fwe irənhə ia nɨmaɡouaɡou. Nərmama tuhətoni, mhərkərinari irə. Ia təkure tənə tako nɨmtətien me: netə, mɨne napw, mɨne nɨse napw. ");
INSERT INTO tnk_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Meri truvehe mɨpitəv. Məkwə truvehe məruerəv məmwhen ia netə. Kurirə irə nəpɨn səvəi Iərɨmənu truvehe. Nəpɨn nəha trasori mopə ia nəpɨn me pam. ");
INSERT INTO tnk_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ia nəpɨn nəha nərmama me pam səməme tuhəkwein ia Iərɨmənu in truvehimɨru irəha.’ ");
INSERT INTO tnk_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Nəmə Isrel tiho ro mhəreɡi nəɡkiariien me i. Iesu nəha iəmə Nasaret Kumwesən rɨnahatən atukwatukw m kɨmiaha i mə in pərhien rərhi pehe i ruvehe tukumiaha. Nəpɨn Iesu rɨnamavən ia rerɨmiaha fwe kupwən, Kumwesən rauvei pen nɨskaiien min, ramo nɨmtətien me mɨne narimnari asori me hiamətoni hiamərkərinari irə rəmwhen hiəuvəukurən raka. ");
INSERT INTO tnk_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nəpɨn Kumwesən ruvei pen Iesu ia rəɡɨmiaha, in ro iamɨnhi irə mamesi pen a nətərɨɡien səvənhi mɨne nəfe in ruvəukurən raka fwe kupwən mə tro. Nənə kɨmiaha hiousi əpune Iesu ia noien nəha hiəno irə. Hiəmri pen in ia rəɡi nəmə ərəha me, nənə hərui tərini pen in ia nei kamarkuaui. ");
INSERT INTO tnk_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Mətə Kumwesən rɨfi Iesu ia nəmisəien səvəi nemhəien, mo in rətui mwi. In rɨno iamɨnhi irə tɨ nəri nə mə nemhəien ko rɨpkəkwtəmhiri mhə Iesu. ");
INSERT INTO tnk_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Rəmwhen ia nəɡkiariien i Kiɡ Tevɨt rɨməni irə mɨnuə: ‘Iakamətə ik krau mik Iərɨmənu səiou ia nəpɨn me. Ikamarə ipaka tukw iou. Nari riti riwən tro iou iakətəmnɨmwɨn. ");
INSERT INTO tnk_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ro iamɨnhi irə rerɨk raɡien pɨk. Tərhuk raməɡnəɡɨni ik Iərɨmənu səiou. Nɨpwrak mwi trarə amasan, məpwəh nehekɨrien, ");
INSERT INTO tnk_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","tɨ nəri nə mə nəpɨn takemhə tikəpwəh nəpwəhien iou iakarə Imwei Nəkur Həuvamhə. Tikəpwəh nəseniien nɨpwrai iəmə ikinan səim rɨmərɨr. ");
INSERT INTO tnk_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ikɨnahatən raka iou ia suatuk me səvəi nɨmɨruien. Tiko iou krau mik krauarə rerɨk ramaɡien.’ ");
INSERT INTO tnk_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Piak me, iakuə takɨni pehe tukumiaha i mə Kiɡ Tevɨt, kaha kupwən səkɨtaha, in rɨpkəɡkiari atukw a mhə irə. In ruvamhə. Kuvənɨmwi raka. Səvənhi kref raməmak ihi. Fwe tui meste pehe ipwet mɨne samətoni. ");
INSERT INTO tnk_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Mətə in profet riti. Rukurən amasan mə Kumwesən rɨməuvehi kwəsuahi mɨni pen tukwe in mɨnuə tɨ nəpɨn riti in ro kwənəkwus riti səvənhi ruvehi təmwhekɨn mərɨmənu. ");
INSERT INTO tnk_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Kiɡ Tevɨt rɨməkupwən mətoni Kristo nəha mə trətui mwi ia nemhəien səvənhi. In nəha Kiɡ Tevɨt rəɡkiari irə ia Ol Sam nəpɨn rɨni mɨnuə ‘Kumwesən trəpwəh nəpwəhien in ramarə Imwei Nəkur Həuvamhə. Nɨpwran trɨpkɨmərɨr mhə.’ ");
INSERT INTO tnk_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Iesu nəha, Kumwesən rɨnəsuəpwiri in ia nemhəien səvənhi. Kɨmaha i iahənətoni, mamhəni irapw mə ro nɨpərhienien. ");
INSERT INTO tnk_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kumwesən, tata səvəi Iesu, ruvehi utə in mukurei pen in ia nɨkaren mwatuk. In ruvei pen Nənɨmwɨn Ikinan min rəmwhen rɨno raka promes fwe kupwən mə tro. Iesu ruvehi Nənɨmwɨn nəha, mərhi pehe i. Nəri nəha hiamətə, mamhəreɡi Nənɨmwɨn Ikinan nəha. ");
INSERT INTO tnk_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kiɡ Tevɨt rəpwəh nutəien fwe ia neiai, mətə in atukwatukw nəha rəɡkiari ia Kristo, mɨni mə, ‘Kumwesən rɨni pen tɨ Iərɨmənu səiou mə, Əkure ia nɨkarek mwatuk ");
INSERT INTO tnk_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","meste tako nərmama səməme haməmwəki ik həuvehe, tikərpwi utə tɨpaɡe nɨsum mi ia nirəha.’ ");
INSERT INTO tnk_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ro iamɨnhi irə kɨmiaha pam nəkur Isrel tihaməkeikei mhəukurən mə Iesu nəha hiənərui tərini pen ia nei kamarkuaui, in nəha təkwtəkwuni Kumwesən ro in ruvehe mo Iərɨmənu mɨne Kristo.” ");
INSERT INTO tnk_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nəpɨn nərmama me nəha həreɡi nəɡkiariien səvəi Pita, rerɨnraha rəpou pɨk. Həres pen Pita mɨne aposol me i mə, “Piak me, təkwtəkwuni nəha tahəfo nəha?” ");
INSERT INTO tnk_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Mɨreɡi Pita rɨni pen tɨ nirəha i mə, “Kɨmiaha tihaməkeikei mhərərɨɡ ia noien ərəha me səkɨmiaha mhəuvehe pwəh iaho paptaes ia kɨmiaha ia nəɡhi Iesu Kristo. Tiho iamɨnhi irə mɨne nənə Kumwesən trəpwəh nərpwɨnien noien ərəha me səkɨmiaha. Kɨmiaha tihəuvehi Nənɨmwɨn Ikinan. ");
INSERT INTO tnk_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Promes nəha raməmak tukumiaha, maməmak mwi tɨ nərɨmiaha me, mɨne nərmama səməme kamharə isipwɨn. Raməmak tɨ nərmama me pam səməme Iərɨmənu Kumwesən səkɨtaha trəkwein ia nirəha.” ");
INSERT INTO tnk_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita rɨni irapw nəɡkiariien me rɨpɨk mwi tɨ nirəha i, maməkeikei mɨnraha, mamɨni mə, “Nərmama ipwet mɨne hamo noien ikou. Tiharaka ia nirəha tɨ nəri nə mə Kumwesən trərpwɨn noien ərəha me səvənraha.” ");
INSERT INTO tnk_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ia nəpɨn nəha nərmama me həpɨk həmwhen ia 3000 həni nɨpərhienien ia nəɡkiariien səvəi Pita, mhəuvehe, ko paptaes ia nirəha. ");
INSERT INTO tnk_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ia nəpɨn me irəha kamhousəsɨmwɨn irəha me, mamhətərɨɡ nəɡkiariien sə aposol me kamhahatən irəha irə. Kamhəkwsen bred, mamhani pəri nari, mamhəfwaki pəri. ");
INSERT INTO tnk_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Nərmama me pam kamhəhekɨr, tɨ nəri nə mə Kumwesən rauvei pen nɨskaiien m aposol me səvəi Iesu. Ia nɨskaiien nəha irəha kamho nɨmtətien me rɨpɨk mɨne narimnari me nərmama kamhətoni hamərkərinari irə. ");
INSERT INTO tnk_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nərmama me pam səməme kamhəni nɨpərhienien ia Iesu, kamharə pəri ia kwopun kuatia, mamhəuai narimnari me səvənraha mɨnraha me. ");
INSERT INTO tnk_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Irəha kamhəmri pen nəmri nari ia səvənraha tɨprənə mɨne nautə me mamhəuvehi mane irə. Nəpɨn nari riti riwən tɨ nirəha riti, kamhəuai mane nəha, mamhəuvei pen m iərmama nəha. ");
INSERT INTO tnk_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ia nəpɨn me kamhavən pəri, mamhəuvən fwe ia nimwə səvəi Kumwesən. Fwe ia nəkwai nimwə me səvənraha, kamhəkwsen bred, mamhani pəri nari. Rerɨnraha raɡien. ");
INSERT INTO tnk_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Kamhəɡnəɡɨni Kumwesən. Nəpɨn nərmama me hətoni irəha, kamhəsiai irəha. Ia nəpɨn me Iərɨmənu rauvehimɨru nərmama me nepwɨn mwi, nənə həuvehe mho kuatia irəha mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ia nəpɨn riti, tri klok ia nəruarəv, nəpɨn səvəi nəfwakiien ruvəuvehe. Pita mɨne Jon krouutə pen fwe ia nimwə səvəi Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Iərmama riti fwe ikɨn. Nəpɨn rɨnətui pehe nɨsun mi krouemhə ko rɨpkavən mhə. Ia nəpɨn me in me nepwɨn həuvehi mhəkure pen i ia nɨkare nimwə səvəi Kumwesən ipaka tɨ təpinhə nəha kani mə Təpinhə sə Ramasan. Nəpɨn nərmama me kamhəuvehe mə tuhəuvnimwə, iərmama nəha ramase mane mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pita mɨne Jon krouvehe ipaka mə trouuvnimwə ia nimwə səvəi Kumwesən. Nəpɨn iərmama nəha rətoni, rase mane mɨnrau. ");
INSERT INTO tnk_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pita mɨne Jon krouəti pen rouətə in. Pita rɨni mə, “Tiko məti pehe mətə kɨmrau.” ");
INSERT INTO tnk_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Iərmama nəha rəti pen mətə irau. Rerɨn ramrhi mə rosi trouvei pen nari riti min. ");
INSERT INTO tnk_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Mətə Pita rɨni pen tukwe in mə, “Səiou silva mɨne kol riwən, mətə nəfe iakauvehi takuvei pehe mik. Ia nəɡhi Iesu Kristo, iəmə Nasaret, tiko mərer mavən.” ");
INSERT INTO tnk_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pita ruvehi rəɡɨn mwatuk mɨvi utə. Təkwtəkwuni a iərmama nəha nɨsun mi krouvehe rouskai. ");
INSERT INTO tnk_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Rɨskəmter mavən, mukurirə ia Pita mɨne Jon, mharuvnimwə ia nimwə səvəi Kumwesən. Ramavən, maməruərau utə, maməɡnəɡɨni Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nərmama me pam həti pen mhətə iərmama nəha ramavən maməɡnəɡɨni Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Hətə həukurən mə iərmama nəha in nəha raməkure rerɨn mamase mane fwe ia nɨkare nimwə səvəi Kumwesən ipaka tɨ Təpinhə sə Ramasan. Irəha hərkərinari irə. Nənimenraha rier tɨ nəfe kɨno irə. ");
INSERT INTO tnk_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Iərmama nəha raməɡher pen ia Pita mɨne Jon. Nərmama pam haiu mhəuvehe tɨ nirəhar fwe ia kwopun nəha kani mə Vranda səvəi Solomon. Nənimenraha rier. ");
INSERT INTO tnk_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nəpɨn Pita rətə nərmama me nəha, rɨni pen tɨ nirəha i mə, “Nəmə Isrel. Rəfo hiamərkərinari ia iərmama i? Hiaməti pehe mamhətə kɨmrau tɨ nəfe? Hiaməfətərɨɡ irə? Ko kɨmrau iaromasan iərmama i ia səkɨmrau atukw nɨskaiien uə tɨ nəri nə mə kɨmrau iəmə ikinan mi? Rekəm! ");
INSERT INTO tnk_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Kumwesən səvəi Epraham mɨne Aesak mɨne Jekop, Kumwesən səvəi kaha kupwən me səkɨtaha, in ruvehi utə nəɡhi Iesu, iəmə sə ramo tukwini nari min. Iesu nəha hiəuvei pen ia rəɡi nəkur Rom. Nəpɨn Paelat rɨni mə trəseni Iesu rier irapw ia kalapus, hiərer ia nənime Paelat, mamhəni mə hiəpwəh nokeikeiien mə tro iamɨnhi irə. ");
INSERT INTO tnk_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Iesu nəha in iəmə atukwatukw mɨne iəmə ikinan, mətə kɨmiaha hiənəpwəh in, mhəres pen Paelat i mə trɨpkəseni mhə in rier irapw ia kalapus mətə trəseni a iərmama sə rɨnousi əpune iərmama rier irapw. ");
INSERT INTO tnk_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ia noien nəha hiənousi əpune Iəmə sə in Nukune Nɨmɨruien. Mətə Kumwesən rɨno in rətui mwi ia nemhəien. Kɨmaha iahənətoni nəri nəha, mamhəni irapw mə ro nɨpərhienien. ");
INSERT INTO tnk_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nəɡse nəɡhi Iesu nəha in nəha rɨno nɨsui iəmə i krouvehe rouskai. Hiamətoni iəmə i, mhəukurən in. In rɨni nɨpərhienien ia nəɡhi Iesu, mo pen ramərer ia nəmrɨmiaha nɨpwran rɨnəsanɨn pam. ");
INSERT INTO tnk_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Piak me iakukurən mə ia nəpɨn nəha hiənousi əpune Iesu, kɨmiaha mɨne nəmə asori me səkɨmiaha hiəreirei nəfe nəha hiamo. ");
INSERT INTO tnk_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Mətə ia noien nəha hiəno irə Kumwesən rɨno nəɡkiariien me səvənhi sə in rɨməuvei pen m profet kupwən me səvənhi həuvəuvehe mhəuvəukuə. Profet me nəha haməkupwən mhəni irapw mə Kristo səvənhi traməkeikei mɨreɡi nəmisəien. ");
INSERT INTO tnk_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ro iamɨnhi irə kɨmiaha tihaməkeikei mhərərɨɡ ia noien ərəha me səkɨmiaha pwəh Kumwesən raikuas raka nərəhaien me səkɨmiaha. ");
INSERT INTO tnk_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Trɨni mɨnuə hio iamɨnha irə, nəpɨn səvəi napwɨsien truku pen ia nəmri Kumwesən. In trərhi pehe Kristo sə kɨməni irapw fwe kupwən mə truvehe tukumiaha. Kristo nəha iakani in Iesu. ");
INSERT INTO tnk_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","In traməkeikei marə fwe ia neiai meste Kumwesən tro narimnari me həuvehe mho sə vi rəmwhen ia profet ikinan me səvənhi fwe kupwən həməni. ");
INSERT INTO tnk_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses rɨməni mə, ‘Iərɨmənu Kumwesən səkɨmiaha truvehi utə profet riti rəmwhen ruvehi utə iou. Profet nəha truku pen ia kɨmiaha in piəvɨmiaha riti. Tihaməkeikei mhətərɨɡ ia narimnari me pam profet nəha trɨni pehe tukumiaha i. ");
INSERT INTO tnk_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Trɨni mɨnuə iərmama riti rəpwəh nətərɨɡien ia profet nəha, Kumwesən truvehi raka in, məpwəh nəvsini penien in ia nərmama me səvənhi.’ ");
INSERT INTO tnk_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Samuel mɨne profet me pam səməme hənəkurirə pen i mhəuvehe həməni narimnari me i kamo ipwet mɨne. ");
INSERT INTO tnk_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nəkur Isrel, kɨmiaha nə nɨpwnəti profet kupwən me. Kɨmiaha nə nɨpwnəti kaha kupwən me. Promes nəha Kumwesən rɨməuvei pen mɨnraha in nə promes səkɨmiaha. In rɨməni pen tɨ Epraham i mə, ‘Iərmama riti truku pen ia kwənəkwus səim. Namasanien səiou truku pen irə, mevən tɨ nərmama me pam ia tənəmtənə me.’ ");
INSERT INTO tnk_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nəpɨn Kumwesən ruvehi utə Tɨni, in rukupwən mərhi pehe i tukumiaha nəkur Isrel mə trəkwein amasan m kɨmiaha, mo hiəpwəh nərəhaien me səkɨmiaha.” ");
INSERT INTO tnk_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Nəpɨn Pita mɨne Jon krauəɡkiari ihi m nərmama, pris me mɨne Satusi me həuvehe irəha iəmə asori səvəi naruaɡən me səməme kamhətui tɨ nimwə səvəi Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Niemaha rəpi irəha tɨ nəri nə mə Pita mɨne Jon krauahatən nərmama me, rauni mə Iesu rɨnətui mwi ia nemhəien səvənhi. Ia nəɡkiariien nəha krauahatən pen mə nərmama səməme həuvamhə tuhətui mwi. ");
INSERT INTO tnk_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nəmə asori me nəha həkwtəmhiri irau, mətə tɨ nəri nə mə rɨnaməruarəv, hosə pen irau ia kalapus mə trouəmak fwe ikɨn roueste trakwakwi. ");
INSERT INTO tnk_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mətə nərmama me səməme həməreɡi nəɡkiariien səvənrau, həpɨk ia nirəha həni nɨpərhienien ia Iesu. Kəvsini nərman me əpa səməme həni nɨpərhienien ia Iesu, irəha pam ipaka faef-taosen. ");
INSERT INTO tnk_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kɨni rakwakwi irə nəmə asori me səvəi nəkur Isrel mɨne elta me mɨne nahatən me səvəi Loa housəsɨmwɨn irəha me fwe Jerusalem. ");
INSERT INTO tnk_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Irəha housəsɨmwɨn irəha me irəha pris asori anan nəɡhɨn nə Anas, mɨne Kaeafas, mɨne Jon, mɨne Aleksanta, mɨne sin sin mwi irəha kwənəkwus səvəi pris asori anan. ");
INSERT INTO tnk_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Irəha həuvehi Pita mɨne Jon, mhərpwi irapw irau ia kurkwanraha, mhəres pen irau i mə, “Sin ruvei pehe nɨskaiien m kɨmirau uə irauo nəri i ia nəɡhi sin?” ");
INSERT INTO tnk_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ia nəpɨn nəha Pita rerɨn ruvehe mukuər ia Nənɨmwɨn Ikinan, rɨni pen tɨ nirəha i mə, “Kɨmiaha nəmə asori me səvəi nəkur Isrel mɨne elta me. ");
INSERT INTO tnk_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Təkwtəkwuni hiaməres pehe kɨmrau i ia namasanien sə iarouo m iərmama i nɨsun mi krouemhə. Hiaməres mə iarouəfo irə ro in ruvehe məsanɨn. ");
INSERT INTO tnk_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ramasan. Kɨmiaha pam i tihaməkeikei mhəukurən. Nəkur Isrel me pam mwi tuhaməkeikei mhəukurən. Iəmə i ramərer ia nəmrɨmiaha nɨsun mi krouskai, tɨ nəri nə mə iaromasan in ia nəɡhi Iesu Kristo, iəmə Nasaret. Hiənərui tərini pen in ia nei kamarkuaui, remhə, mətə Kumwesən rɨno in rətui mwi ia nemhəien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Iesu in iəmə nəha Nəkukuə Ikinan raməɡkiari irə, mamɨni mə, ‘Kəruəterei nəha kɨmiaha nəmə hiamuvrhəkɨn nimwə hiənuə rərəha, mhəpwəh, təkwtəkwuni nəha ruvəuvehe mɨno kəruəterei sə rəpi raka pam kəruəterei me, məkwtəmhiri əknekɨn pam nimwə.’” ");
INSERT INTO tnk_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Pita rɨrɨpɨn nəɡkiariien mɨni mə, “Iesu əpa rauvehi nɨskaiien tɨ nuvehimɨruien kɨtaha. Ia tənəmtənə me pam, iərmama riti mwi riwən Kumwesən rərhi pehe i mɨni mə tsaməkeikei mhahatətə ia nəɡhɨn mə in truvehimɨru kɨtaha.” ");
INSERT INTO tnk_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nəpɨn nəmə asori me hətoni mə Pita mɨne Jon krouəpwəh nehekɨrien ia nəmrɨnraha, hərkərinari irə. Hənətə sas mə irau iəmə auər a mi. Krouəpwəh nevənien ia kwopun sə kaukurən nari ikɨn. Irəha hamətərɨɡ tukwe, mhəukurən mə irau nəha krɨnamavən pəri irəha Iesu fwe kupwən. ");
INSERT INTO tnk_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Mətə ko həpwəh nɨniien nəɡkiariien riti, tɨ nəri nə mə hətoni iəmə nəha krɨnomasan nɨsun mi ramərer ia nɨkarenrau. ");
INSERT INTO tnk_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ia nəpɨn nəha nəmə asori me həni mə irəhar tuharevən fwe iruə. Nəpɨn harier irə, kamhəɡkiari mɨnraha me mə, ");
INSERT INTO tnk_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Tso nəfe ia iəmənmi nəha? Nəkur Jerusalem me pam həukurən mə krɨno nɨmtətien asori nəha. Ko kɨtaha səpwəh nɨniien mə neikuəien. ");
INSERT INTO tnk_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mətə rərəha mə nəɡkiariien nəha truvirɨs mevən mwi tɨ nərmama me. Pwəh sənise pen əknekɨn tɨ nirau i mə trouəpwəh mwi nɨniien nəɡhi Iesu i tɨ iərmama riti mwi.” ");
INSERT INTO tnk_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Irəha həkwein irəhar haruvnimwə pehe mwi. Həni pen tɨ Pita mɨne Jon mə trouəpwəh mwi nɨniien uə nahatənien nərmama me ia nəɡhi Iesu. ");
INSERT INTO tnk_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Mɨreɡi Pita mɨne Jon krouni mə, “Kɨmiaha əpa tihaməkeikei mhəkiri mə ratukwatukw ia nəmri Kumwesən mə kɨmrau taro nəkwan uə nəkwamiaha. ");
INSERT INTO tnk_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mətə kɨmaha ko iahəpwəh nəkwumwi təriniien tərhumaha. Tahaməkeikei mhəvisau irapw nəfe iahənətə mhəreɡi.” ");
INSERT INTO tnk_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nənə nəmə asori me hənise əknekɨn pen tɨ nirau i, mhərhi pen irau krauevən, mhəpkətə mhə suatuk riti tɨ nousiien irau. Rəknekɨn tɨ nirəha tɨ nəri nə mə nərmama me haməɡnəɡɨni Kumwesən tɨ nəfe irau krɨno ia iəmə nəha nɨsun mi krouemhə. ");
INSERT INTO tnk_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Iəmə nəha krɨnomasan in ia nəɡhi Iesu nuk səvənhi rəpi raka foti. ");
INSERT INTO tnk_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nəpɨn Pita mɨne Jon krouier, krouevən rouətə nərmama me səvəi Iesu, nənə rouəvisau narimnari me pris asori me mɨne nəmə asori me səvəi nəkur Isrel həməni pen tɨ nirau i. ");
INSERT INTO tnk_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nəpɨn irəha həreɡi, housəsɨmwɨn irəha me mhəfwaki pəri m Kumwesən, mhəni mə, “Iərɨmənu Asori ikɨno neiai mɨne tɨprənə mɨne təsi mɨne narimnari me pam ia nirəhar. ");
INSERT INTO tnk_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Fwe kupwən, nəɡkiariien səim sə ruku pen ia Nənɨmwɨn Ikinan, rier ia nɨpəɡi nəkwai iərmama səim sə ro tukwini nari mik, kaha səkɨmaha Kiɡ Tevɨt, mɨni mə, ‘Rəfo nərmama rɨpko mhə irəha nəkur Isrel niemaha raməpi irəha? Rəfo nərmama me ia tɨprənə i haməkure tɨ nətərɨɡien səvənraha, mətə hamo teki nari? ");
INSERT INTO tnk_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kiɡ me ia tɨprənə i həpnəpenə tɨ naruaɡənien. Nəmə asori me pam housəsɨmwɨn irəha me, mamhəni ərəha Iərɨmənu, mamhəni ərəha mwi Kristo səvənhi.’ ");
INSERT INTO tnk_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Kumwesən, nəɡkiariien nəha ro nɨpərhienien. Ia taon i Jerusalem, Kiɡ Herot mɨne Ponjes Paelat hənousəsɨmwɨn pəri irəha nərmama rɨpko mhə irəha nəkur Isrel mɨne nəkur Isrel. Irəha hənousəsɨmwɨn irəha me, mhəmwəki Iesu iəmə ikinan səim sə ramo tukwini nari mik. ");
INSERT INTO tnk_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Irəha həno narimnari me nəha mamhesi pen atukwatukw nəfe ikɨməni mə tuko ia nətərɨɡien səim. ");
INSERT INTO tnk_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Mətə Iərɨmənu, təkwtəkwuni tikreɡi ro nəɡkiariien skai me nəha nəmə asori me həməni pehe tukumaha i. Kɨmaha iahase ik mə tikasitu ia kɨmaha. Kɨmaha i nərmama iahamo tukwini nari mik. Pwəh iahəvisau irapw nəɡkiariien səim, mhəpwəh nehekɨrien. ");
INSERT INTO tnk_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Osə pehe rəɡɨm əsanɨn, momasan nərmama səməme nemhəien rarə ia nirəha. Ia nəɡhi Iesu, iəmə ikinan sə ramo tukwini nari mik, pwəh kɨmaha iaho nɨmtətien me mɨne narimnari me nərmama tuhətoni, hərkərinari irə.” ");
INSERT INTO tnk_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nəpɨn həfwaki pam, Kumwesən rɨkiukiu ia kwopun nəha kamhəkure ikɨn. Rerɨnraha ruvehe mukuər ia Nənɨmwɨn Ikinan. Nənə həuvən mhəni irapw nəɡkiariien səvəi Kumwesən, mhəpwəh nehekɨrien. ");
INSERT INTO tnk_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ia nəpɨn nəha nərmama səməme kamhəni nɨpərhienien ia Iesu, rerɨnraha mɨne nətərɨɡien səvənraha ro a kuatia. Riti ia nirəha riwən raməpwtɨɡ tɨ nautə me səvənhi, mɨni mə səvənhi əpa. Mətə həuai narimnari me mhəuvehi rəmwhen ia nirəha me. ");
INSERT INTO tnk_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Aposol me kamhəvisau irapw skai mə Iesu Iərɨmənu rɨnətui pərhien mwi ia nemhəien səvənhi. Nənə Kumwesən ramasitu asori ia nirəha ia namasanien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nərmama me səvəi Iesu riti ia nirəha riwən rɨni mə nari riwən təni tukwe, tɨ nəri nə mə sin sin ia nirəha səvənraha tɨprənə uə nimwə rarə həmri pen nəmri nari irə. Nəpɨn kuvehi nənimen, həuvehi mane, ");
INSERT INTO tnk_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","mhəuvən, mhəfate pen ia nɨsui aposol me. Nənə aposol me həuai, mhəuvei pen m nərmama səməme nari riwən tɨ nirəha. ");
INSERT INTO tnk_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Iərmama riti nəha ikɨn nəɡhɨn nə Josef. In iəmə Isrel sə ruku pen ia kwənəkwus səvəi Livae. Rɨnətui ia tənə əmwerɨs nəha Saepras. Aposol me həseɡi pen nəɡhɨn sə vi mə Panapas. Nɨpwrai nəɡkiariien nəha in i mə Iəmə sə Ramərpwi Əknekɨn Nərmama. ");
INSERT INTO tnk_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Josef i rəmri pen nəmri nari ia tɨprənə səvənhi. Nəpɨn kuvehi nənimen, ruvehi mane, mevən, mɨfate pen ia nɨsui aposol me. ");
INSERT INTO tnk_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Mətə iərmama riti nəɡhɨn nə Ananaeas mɨne pran səvənhi Safaera krouəmri pen nəmri nari ia səvənrau tɨprənə. ");
INSERT INTO tnk_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nəpɨn kuvehi nənimen, krouvehi mane, rouni pəri mə trouvehi raka nɨpərɨn səvənrau. Kurirə irə Ananaeas ruvehi nɨpərɨn a, mevən, mɨfate pen ia nɨsui aposol me, mameikuə mə mane me pam nəha rauvei pen. ");
INSERT INTO tnk_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pita rɨni mə, “Ananaeas, rəfo ikəseni Setan ruvehe mukuər ia rerɨm, mamo ikameikuə ia Nənɨmwɨn Ikinan? Nəmri tɨprənə sə kuvei pehe mik, rəfo ikəkwtəmhiri nɨpərɨn səim? ");
INSERT INTO tnk_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nəpɨn ikəpwəh nəmri penien ihi nəmri nari irə, tɨprənə ramo ihi səim irə. Nəpɨn ikuvehi mane, ia nəpɨn nəha mwi mane nəha ramo ihi səim irə. Mətə rəfo rerɨm rɨrhi mə tiko noien i? Ikəpwəh neikuəien ia nirak, mətə ikeikuə ia Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Nəpɨn Ananaeas rɨreɡi nəɡkiariien nəha, təkwtəkwuni a mwi rɨmwei memhə. Ntəmaruə me nepwɨn həskəmter, mhəveɡi nɨpwran, mhəuvehi mhəier, mhəuvən mhənɨmwi. Nərmama me həreɡi həhekɨr. ");
INSERT INTO tnk_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Nəpɨn aoa kahar rukurau, pran səvəi Ananaeas ruvnimwə pehe, mətə rəpwəh nukurənien mə səvənhi iərman ruvamhə. ");
INSERT INTO tnk_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pita rɨni pen tukwe in mə, “Tiko mɨni pehe ro tukw iou i mə nəmri tɨprənə sə kuvei pehe m kɨmirau, in pam i?” Mɨreɡi Safaera rɨni mə, “Ouəh, nəmri tɨprənə ihi nəha?” ");
INSERT INTO tnk_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Mətə Pita rɨni pen tukwe in mə, “Rəfo kɨmirau iərman səim irouni pəri mə tirouni mə mane me pam i? Ikukurən mə ko ikeikuə ia Nənɨmwɨn səvəi Iərɨmənu? Ətə ro! Nərmama səməme hamənɨmwi səim iərman, irəha fwe ia kwəruə. Tuhəuvehi mwi ik, mhəuvən fwe iruə.” ");
INSERT INTO tnk_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Təkwtəkwuni a Safaera rɨmwei ia nɨsui Pita memhə. Nəpɨn ntəmaruə me həuvnimwə pehe, hətə raməmak muvamhə. Nənə həuvehi, mhəier, mhənɨmwi ia nɨkare səvənhi iərman. ");
INSERT INTO tnk_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nakalasia me mɨne nərmama səməme həreɡi nəri nəha, irəha pam həhekɨr asori. ");
INSERT INTO tnk_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ia nəpɨn nəha aposol me kamhavən ia reri nərmama me, mamho nɨmtətien me rɨpɨk mɨne narimnari me rɨpɨk nərmama hətoni mhərkərinari irə. Ia nəpɨn me nərmama səməme kamhəni nɨpərhienien ia Iesu kamhousəsɨmwɨn irəha me ia vranda səvəi Solomon ia nimwə səvəi Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nəpɨn nərmama əpnapen a hətoni irəha, həɡnəɡɨni irəha, mətə həpwəh nevənien ipaka, tɨ nəri nə mə həhekɨr. ");
INSERT INTO tnk_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Mətə nərman me həpɨk mɨne nɨpran me həpɨk kamhəuvehe tɨ Iesu Iərɨmənu, mamhəni nɨpərhienien irə. ");
INSERT INTO tnk_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Aposol me kamho nɨmtətien me rɨpɨk ia Jerusalem. Ro pen nərmama me kamhəuvehi nərmama səməme nemhəien rarə ia nirəha, mhəuvehi, mhəuvən fwe ia suatuk, mhəmri pen irəha ia təkure nɨkoukau me mɨne kafete me. Irəha kamho iamɨnhi irə mɨnuə Pita ruvehe mukurau mətə nənɨmwɨn a trukurau pen ia nirəha, nənə irəha həuvehe mhəsanɨn. ");
INSERT INTO tnk_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nərmama me fwe ia rukwənu me ipaka tɨ Jerusalem, irəha mwi kamhəuvehi nərmama me səvənraha səməme nemhəien rarə ia nirəha mɨne səməme nənɨmwɨn ərəha me kamharə ia nirəha, kamhəuvehi irəha, mhəuvehe, nənə aposol me ho irəha pam həuvehe mhəsanɨn. ");
INSERT INTO tnk_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ia nəpɨn nəha pris asori anan mɨne Satusi me nepwɨn housəsɨmwɨn pəri irəha me. Rerɨnraha ramrhi ərəha aposol me səvəi Iesu. ");
INSERT INTO tnk_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Mo pen həkwtəmhiri irəha, mhəuvehi puvnimwə irəha ia kalapus. ");
INSERT INTO tnk_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Mətə ia nəpɨn irə aɡelo riti səvəi Iərɨmənu ruvehe məsevər ia təpinhə me səvəi nimwə nəha, miri irapw aposol me, mɨni pen tɨ nirəha i mə, ");
INSERT INTO tnk_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Tihəuvən mhərer ia nimwə səvəi Kumwesən, mamhəni irapw tɨ nərmama me nəɡkiariien me pam ia nɨkaren səvəi nɨmɨruien vi i.” ");
INSERT INTO tnk_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ia nəpɨn rɨnamran həuvən fwe ia nimwə səvəi Kumwesən mamhahatən nərmama rosi aɡelo rɨməni pen tukunraha i. Nəpɨn pris asori anan mɨne in me nepwɨn həuvehe, housəsɨmwɨn nəmə asori me səvəi nəkur Isrel. Nəmə asori me nəha hərhi pen nərmama nepwɨn mə tuhəuvən fwe kalapus, mhəuvehi aposol me, mhəuvehi mhəuvehe. ");
INSERT INTO tnk_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Mətə nəpɨn nərmama me nəha kərhi pen irəha həuvən ia kalapus, həpwəh nətoniien aposol me. Nənə hərərɨɡ, mhəni pen tɨ nəmə asori me i mə, ");
INSERT INTO tnk_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Kɨmaha iahəuvən mhətoni kalapus rəsisəɡ əknekɨn. Nərmama səməme kamhətui tɨ kwopun nəha kamhərer tukuahaɡ pam ia kwəruə me. Mətə nəpɨn həsevər ia təpinhə, kɨmaha iahəuvnimwə, mətə nərmama me nəha həiwən.” ");
INSERT INTO tnk_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nəpɨn pris asori me mɨne iəmə asori səvəi naruaɡən me səməme kamhətui tɨ nimwə səvəi Kumwesən həreɡi nəɡkiariien nəha, nətərɨɡien səvənraha rəvsausɨni pɨk tɨ aposol me. Həreirei mə nəfe ro irəha. ");
INSERT INTO tnk_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ia nəpɨn nəha iərmama riti ruvnimwə pehe, mɨni pen tɨ nirəha i mə “Nəmə me nəha hiənəsisəɡ tukuahaɡ ia nirəha, irəha fwe ia nimwə səvəi Kumwesən kamhahatən nərmama me.” ");
INSERT INTO tnk_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nənə iəmə asori səvəi naruaɡən me səməme kamhətui tɨ nimwə səvəi Kumwesən rɨskəmter, miri naruaɡən me nepwɨn səvənhi, mhəuvən, mhəkwtəmhiri aposol me, mhəiri irəha mhəuvehe. Mətə həpwəh nousiien irəha, tɨ nəri nə mə həhekɨr nərmama me. Kamo nərmama me həkwi irəha ia kəruəterei. ");
INSERT INTO tnk_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Irəha həuvehi aposol me mhəuvehe, mhərpwi irapw irəha ia nəmri nəmə asori me. Nənə pris asori anan rəɡkiari mɨnraha, ");
INSERT INTO tnk_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","mɨni mə, “Iahəuvəni pehe raka nəɡkiariien skai tukumiaha i mə tihəpwəh rə nahatənien nərmama ia nəɡhi iəmə nəha. Mətə hiənərui nəkwamaha. Hətə ro. Təkwtəkwuni nəha nərmama me pam ia Jerusalem həuvəreɡi raka nəɡkiariien səkɨmiaha. Rəfo mə tihərukwi pehe nemhəien səvəi iəmə nəha ia kɨmaha.” ");
INSERT INTO tnk_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Mətə Pita mɨne aposol me həni pen tɨ nəmə asori me i mə, “Kɨmaha tahaməkeikei mho nəkwai Kumwesən, rɨpko mhə nəkwai nərmama. ");
INSERT INTO tnk_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Kɨmiaha hiənousi əpune Iesu ia noien nəha hiəno irə, mhərukwi utə ia nei kamarkuaui. Mətə Kumwesən səvəi kaha kupwən me səkɨtaha rɨno rətui mwi ia nemhəien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Kumwesən i ruvəuvehi utə raka in mukurei pen in ia nɨkaren mwatuk mə in iəmə sə triri nərmama mɨne iəmə sə truvehimɨru nərmama. Kumwesən ro iamɨnha irə mə truvei pehe nəpɨn m kɨtaha nəkur Isrel. Trɨni mɨnuə sərərɨɡ ia noien ərəha me səkɨtaha, Kumwesən trenouenou noien ərəha me səkɨtaha, məpwəh nərɨpwɨnien. ");
INSERT INTO tnk_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kɨmaha iahənətə narimnari me nəha, mamhəvisau irapw mə ro nɨpərhienien. Nənɨmwɨn Ikinan sə Kumwesən rauvei pen m nərmama səməme hamo nəkwan in mwi ramərer kɨmaha min.” ");
INSERT INTO tnk_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nəpɨn nəmə asori me həreɡi nəɡkiariien səvəi aposol me niemaha rəpi irəha. Hənuə tuhousi əpune irəha. ");
INSERT INTO tnk_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Mətə iəmə asori riti nəha ikɨn ia rerɨnraha nəɡhɨn nə Kamaliel. In Farisi riti. In iahatən riti sə ramahatən Loa səvəi Moses. Nərmama pam kamhəsiai in. In rɨskəmter, mɨni pen tɨ naruaɡən me mə, “Tiho mhəuvehi nəmə i mhəier. Pwəh kɨmaha iahəɡkiari ouihi a.” ");
INSERT INTO tnk_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nəpɨn aposol me həier irə, Kamaliel rəɡkiari pen m nəmə asori me i mə, “Nəmə Isrel, tihətərɨɡ amasan tɨ nəfe hiamo ia nəmə me i. ");
INSERT INTO tnk_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Rerɨmiaha trɨrhi Teutas fwe kupwən. Rɨni mə in iərmama riti. Nərmama həpɨk, ipaka tɨ 400, həuvən mhəkurirə i. Mətə kousi əpune iəmə nəha. Nərmama səməme kamho nəkwan havən kɨrkɨri. Kusen səvənraha rəsas miwən. ");
INSERT INTO tnk_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kurirə ikɨn, ia nəpɨn sə kaməvsini nərmama me irə, Jutas iəmə Kalili rərer mɨvi nərmama həpɨk həuvən mhəkurirə i. Mətə in mwi kousi əpune. Nərmama səməme kamho nəkwan havən kɨrkɨri. ");
INSERT INTO tnk_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ro iamɨnhi irə iakuə takɨni pehe tukumiaha i mə, nəmə me i hamərer ia nəmrɨtaha ipwet, ramasan mə tihəpwəh irəha, mhəfi raka rəɡɨmiaha ia nirəha. Trɨni mɨnuə nəri nəha hamo ruku pen tɨ iərmama, trəsas miwən. ");
INSERT INTO tnk_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Mətə trɨni mɨnuə Kumwesən ramərer kurirə ia nirəha, ko hiəpwəh nɨniseien irəha. Tihətərɨɡ amasan tɨ nəfe hiamo ia nəmə me i. Kɨtaha səreirei, mətə rərəha mə tihətə sas kurirə mə hiamousari m Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ro iamɨnhi irə nəmə asori me ho rosi Kamaliel rɨməni pen tɨ nirəha i. Həkwein mwi aposol me həuvnimwə pehe, mhərisi irəha, mhənise pen əknekɨn tɨ nirəha mə tuhəpwəh nəvisauien mwi m nərmama ia nəɡhi Iesu, nənə mhəfi raka rəɡɨnraha ia nirəha. ");
INSERT INTO tnk_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Aposol me həier ia nəmri nəmə asori me səvəi nəkur Isrel, mamhaɡien, tɨ nəri nə mə Kumwesən rətə irəha mə həmwhen ko naurɨsien mɨnraha tɨ nəɡhi Iesu. ");
INSERT INTO tnk_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Nənə ia nəpɨn me kamhəuvən fwe ia nimwə səvəi Kumwesən, mamhəuvən mwi ia nimwə me, mamhərɨpɨn, mamhahatən nərmama me, mamhəvisau mɨnraha mə Iesu in Kristo. ");
INSERT INTO tnk_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nərmama me səvəi Iesu həuvehe mhəpɨk mwi. Ia nəpɨn nəha nəkur Isrel səməme kamhəɡkiari ia nəɡkiariien səvəi nəkur Kris həvisə irəha nəkur Isrel səməme kamhəɡkiari ia nəɡkiariien Hipru. Nəkur Isrel səməme kamhəɡkiari ia nəɡkiariien səvəi nəkur Kris həni mə ia nəpɨn me, nəpɨn kauvei pen mane mɨne nəveɡɨnien m nərmama me trasitu ia nirəha, kɨpkuvei pen mhə m nɨpran me səvənraha səməme nərman me səvənraha həuvamhə. ");
INSERT INTO tnk_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ro iamɨnhi irə, aposol me twelef həkwein pen nərmama me səvəi Iesu mə irəha pam tuhəuvehe. Nəpɨn həuvehe, aposol me həni pen tɨ nirəha i mə, “Kɨmaha iahaməvisau irapw nəɡkiariien səvəi Kumwesən. Rɨpkatukwatukw mhə mə tahəpwəh wok nəha mhəuvehe mhəsui raka nəveɡɨnien. ");
INSERT INTO tnk_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ro pen piəvmaha me, kɨmiaha tihərpwi rəɡɨmiaha ia nərman me sefen ia kɨmiaha nəɡhɨnraha ramasan, rerɨnraha rukuər ia Nənɨmwɨn Ikinan, nukurənien səvənraha rəpwəmwɨs. Kɨmaha tahəuvehi utə irəha mə tuhəsui raka nəveɡɨnien. ");
INSERT INTO tnk_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Mətə wok səkɨmaha tahaməfwaki, mamhəvisau irapw nəɡkiariien səvəi Kumwesən ia nəpɨn me.” ");
INSERT INTO tnk_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nərmama me pam səvəi Iesu rerɨnraha raɡien tɨ nəɡkiariien nəha səvəi aposol me. Hərpwi rəɡɨnraha ia Stifen, iərman riti nahatətəien səvənhi rɨskai, rerɨn rukuər ia Nənɨmwɨn Ikinan. Hərpwi mwi rəɡɨnraha ia Filip, mɨne Prokoras, mɨne Nikanor, mɨne Timon, mɨne Pamenas, mɨne Nikolas, iəmə Antiok. Rɨpko mhə in iəmə Isrel, mətə ramarə ia narəien səvənraha. ");
INSERT INTO tnk_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Irəha həiri nərman me nəha sefen, mhəuvehe, mhərer ia nəmri aposol me. Aposol me həmrutə rəɡɨnraha ia nirəha, məfwaki mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ia nəpɨn nəha nəɡkiariien səvəi Kumwesən rauvirɨs mamevən. Nərmama me səvəi Iesu fwe Jerusalem həuvehe mhəpɨk mwi. Pris me nepwɨn həuvehi nahatənien səvəi Iesu, mhahatətə irə. Pris me nəha həpɨk kwopti. ");
INSERT INTO tnk_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stifen in iərmama riti Kumwesən rauvei pen nɨskaiien min, mamasitu irə ia namasanien səvənhi. Nəpɨn riti Stifen ramavən ia reri nərmama, mamo nɨmtətien asori me mɨne narimnari me nərmama hətoni, hamərkəri asori nari irə. ");
INSERT INTO tnk_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Mətə nərmama me nepwɨn nəha ikɨn. Irəha nərmama səvəi nimwəfwaki riti səvəi nəkur Isrel kani mə Nimwəfwaki Səvəi Nərmama Me Kɨnɨfi Raka Nari ia Nirəha. Nepwɨn həuku pen fwe Saerin mɨne Aleksantria. Nepwɨn mwi həuku pen fwe Silisia mɨne Esia. Irəha həskəmter mamhousari m Stifen. ");
INSERT INTO tnk_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Mətə rəknekɨn tɨ nirəha. Ko həpkousi tərini mhə nəɡkiariien səvənhi, tɨ nəri nə mə Nənɨmwɨn Ikinan rauvei pen nukurənien min. ");
INSERT INTO tnk_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ro iamɨnhi irə hərəku pen nərmama nepwɨn mə tuheikuə irə. Nərmama me nəha həskəmter, mhəni mə, “Kɨmaha iahəreɡi iəmə i raməɡkiari ərəha ia Moses mɨne Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nəpɨn nərmama me mɨne nəmə asori me səvənraha mɨne nahatən me səvəi Loa həreɡi nəɡkiariien nəha, niemaha rəpi irəha. Həuvən tɨ Stifen, mhəkwtəmhiri, mhəuvehi mhəuvən, mhərpwi irapw in ia nəmri nəmə asori me səvəi nəkur Isrel. ");
INSERT INTO tnk_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Irəha hərpwi irapw nərmama nepwɨn mə tuheikuə ia Stifen. Nərmama me nəha həni mə, “Ia nəpɨn me iəmə i ramɨni ərəha kwopun ikinan i mɨne Loa səvəi Moses. ");
INSERT INTO tnk_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Iahəreɡi rɨni mə Iesu nəha iəmə Nasaret in trousi testesi nimwə səvəi Kumwesən, mərarki narəien sə Moses rɨməuvei pehe m kɨtaha, məmri səpə riti.” ");
INSERT INTO tnk_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nəmə asori me pam səvəi nəkur Isrel haməkure ia nousəsɨmwɨnien səvənraha, mamhəti pen mamhətə Stifen, mhətoni mə nənimen rəmwhen ia nəmri aɡelo riti. ");
INSERT INTO tnk_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ia nəpɨn nəha pris asori anan rɨni pen tɨ Stifen i mə, “Rəfo irə? Nəɡkiariien i ro nɨpərhienien?” ");
INSERT INTO tnk_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Mɨreɡi Stifen rɨni mə, “Piak me mɨne tata me, həreɡi ro. Fwe kupwən, nəpɨn kaha kupwən səkɨtaha Epraham rɨpkevən mhə ihi fwe Haran, Kumwesən asori rier irapw tukwe fwe Mesopotemia, ");
INSERT INTO tnk_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","mɨni pen tukwe in mə, ‘Tikier ia tənə imwam mɨne nəkur imwam, mier mevən fwe ia tɨprənə takahatən ik irə.’ ");
INSERT INTO tnk_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Epraham rier ia tənə Koltia, mevən marə fwe ia taon nəha Haran. Nəpɨn səvənhi tata remhə, Kumwesən rərui irapw mwi in ruvehe marə ia tɨprənə i sə hiamarə irə ipwet mɨne. ");
INSERT INTO tnk_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Mətə ia nəpɨn nəha Kumwesən rɨpkuvei pen mhə tɨprənə riti ia kwopun i mə tro səvənhi irə. Rɨpkuvei pen anan mhə kwənpərɨn riti min. Mətə rɨno promes a mə trɨpkuvei pen min mɨne nɨmwipwɨni me səməme tuhətui kurirə. Nəpɨn Kumwesən rɨməni promes nəha, tɨni Epraham ramiwən ihi. ");
INSERT INTO tnk_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nəɡkiariien sə Kumwesən rɨməni pen tɨ Epraham i ro iamɨnhi irə: ‘Nɨmwipwɨm me tuhəuvən mharə ia tɨprənə səvəi nərməpə. Nəkur ia kwopun nəha tuhəuvehi pen wok skai mɨnraha, mhometə irəha meste nuk fo hantret.’ ");
INSERT INTO tnk_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kumwesən rarə mɨni mwi mə, ‘Mətə iou takərpwɨn noien ərəha səvəi nəkur me nəha nɨmwipwɨm me tuhowok skai mɨnraha. Kurirə irə nɨmwipwɨm me tuhəier ia tənə nəha, mhəuvehe, mhəfwaki pehe miou ia kwopun i.’ ");
INSERT INTO tnk_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ia nəpɨn nəha Kumwesən rɨni mə Epraham mɨne kwənəkwus me səvənhi tukaməkeikei kuvehi ninhum mɨnraha. Noien nəha rahatən pen promes nəha Kumwesən rɨməuvei pen m Epraham. Kurirə irə tɨni Epraham rətui, nəɡhɨn nə Aesak. Nəpɨn ruvehi nəpɨn eit səvənhi, səvənhi tata ruvehi ninhum min. Nənə Aesak rərəhi Jekop. Nənə Jekop rərəhi nərman me irəha pam twelef. Irəha me nəha kaha kupwən me səkɨtaha. ");
INSERT INTO tnk_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Kaha kupwən me nəha səkɨtaha, rerɨnraha ramrhi ərəha piəvnraha Josef. Həuvehi pen in ia rəɡi nərmama me nepwɨn, mhəuvehi mane irə. Nərmama me nəha həuvehi Josef, mhəuvən fwe Ijip. Ia kwopun nəha Josef ramowok slef, mətə Kumwesən ramarə tukwe, ");
INSERT INTO tnk_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","mauvehi raka in ia nɨpəmpəmien me pam səvənhi. Nəpɨn Josef revən mərer ia nəmri Fero, kiɡ səvəi nəkur Ijip, Kumwesən ruvei pen namasanien mɨne nukurənien min. Ro pen Fero ruvei pen nasoriien m Josef. Nənə Josef ruvehe mo in iəmə asori ramətui amasan tɨ nəkur Ijip, nənə mamətui amasan mwi tɨ narimnari me sə kamo ia nəkwai nimwə səvəi Kiɡ Fero. ");
INSERT INTO tnk_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Kurirə ikɨn nəpɨn səvəi nukumhə ruvehe muvehi pam nəkur Ijip mɨne nəkur Kenan, mamo nərmama həmisə pɨk. Kaha kupwən me səkɨtaha hənamətui sənənraha nəveɡɨnien, mətə ruvəivən. ");
INSERT INTO tnk_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nəpɨn Jekop rɨreɡi nəvisauien mə nəveɡɨnien fwe Ijip, rərhi pen kaha kupwən me səkɨtaha mə tuhəuvən fwe ikɨn. Ro səvi tɨ nirəha tɨ nevənien ia kwopun nəha. ");
INSERT INTO tnk_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nəpɨn irəha həuvən səro kəru irə, nənə Josef rɨni pui in tɨ piəvni me, nənə Kiɡ Fero ruvehe mukurən nərmama ia kwənəkwus səvəi Josef. ");
INSERT INTO tnk_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Kurirə irə Josef rərhi pen nəɡkiariien revən tɨ səvənhi tata Jekop irəha nərmama me pam ia kwənəkwus səvənhi mə tuhəuvehe fwe Ijip. Irəha pam sefenti-faef nərmama. ");
INSERT INTO tnk_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Nəpɨn Jekop rɨreɡi nəɡkiariien nəha, reiwaiu mevən fwe Ijip. Kurirə ikɨn in mɨne kaha kupwən me səkɨtaha hemhə fwe ikɨn. ");
INSERT INTO tnk_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Nənə həuvehi nɨpwranraha mhərərɨɡ mhəuvən fwe taon nəha Sekem, mhənɨmwi irəha fwe ikɨn ia nɨpəɡ riti sə Epraham rɨməuvehi nənimen tɨ nɨpwnəti iəmə asori riti nəɡhɨn nə Hamor. ");
INSERT INTO tnk_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ruvəuvehe ipaka tɨ nəpɨn nəha Kumwesən truvei pen tɨprənə m kaha kupwən me səkɨtaha rəmwhen rɨno promes m Epraham fwe kupwən. Ia nəpɨn nəha nərmama me səkɨtaha fwe Ijip həuvehe mhasori mhəpɨk. ");
INSERT INTO tnk_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nənə kiɡ əpə ruvehe mərɨmənu ia nəkur Ijip, mətə rɨnapkukurən mhə Josef. ");
INSERT INTO tnk_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","In reikuə ia kaha kupwən me səkɨtaha, mamərhiərhi irəha mə tuhərui irapw nəkwərhakwərha me sə həpkətui a i mə tuhemhə. ");
INSERT INTO tnk_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ia nəpɨn atukwatukw nəha Moses rətui. In ramasan pɨk ia nəmri Kumwesən. Səvənhi tata mɨne mama krouətui amasan tukwe ia nəkwai nimwə səvənrau meste in ruvehi məkwə kahar. ");
INSERT INTO tnk_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nəpɨn irau krouəmri irapw iruə, prən ouihi səvəi Kiɡ Fero rətoni, mərəhi səvənhi, mətui amasan tukwe rəmwhen mə in tɨni anan. ");
INSERT INTO tnk_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Kɨnahatən Moses ia nukurənien me pam səvəi nəkur Ijip. Səvənhi nəɡkiariien mɨne wok krouəsanɨn. ");
INSERT INTO tnk_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Nəpɨn Moses reste nuk foti, rerɨn rɨrhi mə trevən mətoni piəvni me nəkur Isrel. ");
INSERT INTO tnk_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","In revən mətoni iəmə Ijip riti ramousi piəvni riti, mətə rɨpkatukwatukw mə tro irə iamɨnha irə. Ro pen Moses revən mə trasitu ia piəvni, mərpwɨn pen noien səvəi iəmə Ijip ramo. Rousi iəmə Ijip nəha, mousi əpune. ");
INSERT INTO tnk_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses rerɨn rɨrhi mə piəvni me tuhətoni mhəukurən mə Kumwesən ramərhi pen in mə truvehi raka irəha ia rəɡi nəkur Ijip. Mətə irəha həpkətə sas mhə irə. ");
INSERT INTO tnk_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kɨni rakwakwi irə Moses revən mwi mətoni iəmə Isrel kəru krouousi irau me. In revən mə trəmri nəmərinuien tɨ nirau i, mɨni mə, ‘Iəmənmi kɨmirau piəvmirau me a. Rəfo irouousi kɨmirau me?’ ");
INSERT INTO tnk_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Mətə iəmə sə ramousi ərəha anan piəvni rəsuə raka Moses, mɨni mə, ‘Sin rɨməuvehi utə ik mə tikərɨmənu ia kɨmaha məkiri noien səkɨmaha? ");
INSERT INTO tnk_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Rosi ikuə tikousi əpune iou rəmwhen ikɨnousi əpune iəmə Ijip nərineiv?’ ");
INSERT INTO tnk_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nəpɨn Moses rɨreɡi nəɡkiariien nəha, rap fwe Ijip, mevən mo in iərmama pwɨspwɨs ia tənə Mitia. Ia kwopun nəha tɨni kəru krouətui, iərman mi. ");
INSERT INTO tnk_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Kurirə irə nuk foti rukurau, nənə aɡelo riti səvəi Kumwesən rier pen tɨ Moses i fwe ia kwopun akwesakwes ikɨn, ipaka tɨ təkuər Sinae, mamərer ia nei riti napw rauək irə, mətə rɨpkahi əmwesi mhə. ");
INSERT INTO tnk_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses rətoni nei nəha rərkərinari irə. Nənə nəpɨn revən ipaka tukwe mə trəspau irə, reri Iərɨmənu ruvehe, mɨni mə, ");
INSERT INTO tnk_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Iou Kumwesən səvəi kaha kupwən me səim. Kumwesən səvəi Epraham mɨne Aesak mɨne Jekop.’ Moses rɨreɡi, mətə rehekɨr mətəmnɨmwɨn, məpwəh nəti penien mətoni. ");
INSERT INTO tnk_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Nənə Iərɨmənu rɨni pen tukwe in mə, ‘Uvehi raka səim put, tɨ nəri nə mə tɨprənə nə iakamərer ikɨn ro ikinan i. ");
INSERT INTO tnk_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Iou iakɨnətə raka nərmama me səiou fwe Ijip. Kamometə irəha. Iakuvəreɡi raka nasəkien səvənraha. Nənə iou iakeiwaiu irapw pehe i mə takuvehi raka irəha ia rəɡi nəkur Ijip. Tiko muvehe, təkwtəkwuni takərhi pen ik ikevən fwe Ijip.’ ");
INSERT INTO tnk_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","In nəha Moses sə kupwən nəkur Isrel həpwəh nokeikeiien in, mhəni pen tukwe in mə, ‘Sin rɨməuvehi utə ik mə tikərɨmənu ia kɨmaha məkiri noien səkɨmaha?’ Mətə Moses nəha in nəha Kumwesən rərhi pen aɡelo riti səvənhi rier pen tukwe ia kwəti nei, mərhi pen in revən mə trərɨmənu ia nəkur Isrel, muvehi raka irəha ia rəɡi nəkur Ijip. ");
INSERT INTO tnk_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses nəha riri irəha mhəier ia Ijip, mhəuvən fwe ia Təsi Əruverəv, mhəuvən mharə nuk foti fwe ia kwopun akwesakwes ikɨn. Nənə ia kwopun me nəha ramo nɨmtətien me mɨne narimnari me nərmama hətoni hamərkərinari irə. ");
INSERT INTO tnk_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moses nəha in nəha rɨməni pen tɨ nəkur Isrel i mə, ‘Kumwesən truvehi utə profet riti rəmwhen ruvehi utə iou. Profet nəha truku pen ia kɨmiaha in piəvɨmiaha riti.’ ");
INSERT INTO tnk_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moses nəha in nəha ramarə irəha nəkur Isrel nəpɨn kamhavən fwe ia kwopun akwesakwes ikɨn. In ramarə irəha kaha kupwən me səkɨtaha nəpɨn aɡelo nəha rəɡkiari min ia Təkuər Sinae. Kumwesən ruvei pen nəɡkiariien sə ramɨru m Moses mə truvei pehe m kɨtaha. ");
INSERT INTO tnk_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Mətə kaha kupwən me səkɨtaha həpwəh nokeikeiien mə tuho nəkwai Moses. Həsuə karen in. Nənə rerɨnraha rɨnamrhi Ijip. Hokeikei mə tuhərərɨɡ mhəuvən fwe ikɨn. ");
INSERT INTO tnk_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ro pen həni pen tɨ Eron i mə, ‘Tiko kumwesən me nepwɨn, pwəh həiri kɨtaha, tɨ nəri nə mə səreirei mə Moses nəha rɨməiri raka kɨtaha ia tənə Ijip ruvəwəku.’ ");
INSERT INTO tnk_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ia nəpɨn nəha irəha ho nənɨmwi kau riti. Nəpɨn həno pam, həpeki pehe nərimɨru me mə tuhousi əpune irəha mhəuvei pen m nənɨmwi kau nəha. Irəha haməɡnəɡɨni nəri nəha həno ia rəɡɨnraha. ");
INSERT INTO tnk_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ro iamɨnhi irə Kumwesən ruvehi pen təkutan mɨnraha, məpwəh irəha həuvən mhəfwaki pen m meri, məkwə, mɨne kəməhau me. Rəmwhen ia nəɡkiariien i kɨmərai pen ia nəkukuə səvəi profet me rani: ‘Nəkur Isrel. Ia nəpɨn nəha hiənarə nuk foti fwe kwopun akwesakwes ikɨn, nərimɨru me səməme hiamousi əpune, mamhəmri utə ia təkure nɨfatə, hiəuvei pehe miou uə rekəm? Rekəm. Hiəpwəh nuvei peheien miou. ");
INSERT INTO tnk_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mətə hiaməuvehi nimwə tapolen səvəi kumwesən nəha Molek, mɨne kəməhau səvəi kumwesən nəha səkɨmiaha Refan. Irau mi nəha kumwesən eikuə mi sə hiəno ia rəɡɨmiaha mə tihaməfwaki pen mɨnrau. Kɨmiaha hiamo iamɨnhi ro pen takuvehi raka kɨmiaha ia tɨprənə səkɨmiaha hiəuvən ia nɨkare Papilon.’ ");
INSERT INTO tnk_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Fwe ia kwopun akwesakwes ikɨn, Kumwesən rɨməni pen tɨ Moses i mə traməkeikei mo nimwə tapolen riti. Moses ro, mesi pen atukwatukw rəmwhen ia Kumwesən rɨno rətoni. Kurirə ikɨn kaha kupwən me səkɨtaha həuvehi nimwə tapolen nəha mamhəuvən. ");
INSERT INTO tnk_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Nəpɨn Josua riri kaha kupwən me səkɨtaha mə tuhəuvehe mhəuvehi raka tɨprənə ia rəɡi nəmə Kenan, həuvehi nimwə tapolen nəha, mhəuvehi mhəuvehe. Irəha kənamhəuvehe ia Kenan, Kumwesən raməkoui irapw nəmə ikɨn. Nimwə Tapolen nəha raməmak iamɨnhi meste nəpɨn səvəi Kiɡ Tevɨt. ");
INSERT INTO tnk_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Kiɡ Tevɨt nəha Kumwesən rerɨn raɡien tukwe. In rɨni pen tɨ Kumwesən i mə, ‘Ik Kumwesən səvəi Jekop. Ko ikəseni iou iako nimwə riti sə tikamarə irə?’ ");
INSERT INTO tnk_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Mətə Kumwesən rəpwəh nəseniien. Kiɡ Tevɨt rɨpko mhə nimwə riti səvəi Kumwesən. Solomon ro. ");
INSERT INTO tnk_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Mətə kɨtaha səukurən mə Kum wesən sə rasori anan, in rɨpkarə mhə ia nəkwai nimwə me səməme nərmama həno ia rəɡɨnraha. Rəmwhen ia nəɡkiariien i Profet Aesea rɨməni mə, ");
INSERT INTO tnk_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Neiai in jea səiou sə iakaməkure irə mamərɨmənu. Tɨprənə in nəri sə iakamərpwi utə tɨpaɡe nɨsuk mi irə. Kɨmiaha ko hio nimwə riti mə takarə irə? Kɨmiaha ko hio kwopun riti mə takapwɨs ikɨn? ");
INSERT INTO tnk_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Həni ro, sin rɨno narimnari me pam i? Iou əpa Kumwesən iakɨno.’” ");
INSERT INTO tnk_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stifen rɨni pen tɨ nəmə asori me i mə, “Kɨmiaha i kəmkapwəmiaha rɨskai. Nətərɨɡien səkɨmiaha rɨpitəv hiəmwhen ia nərmama səməme həreirei Iərɨmənu. Hiəpkreɡi mhə nəɡkiariien səvənhi. Hiamo rəmwhen kaha kupwən me səkɨmiaha. Ia nəpɨn me hiamənise nəfe nari Nənɨmwɨn Ikinan rani pehe tukumiaha i. ");
INSERT INTO tnk_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Rəfo? Profet riti nəha ikɨn kaha kupwən me səkɨmiaha həpkometə mhə in? Rekəm! Həmwəki pam irəha, mhousi əpune səməme haməkupwən mhəni irapw mə Iəmə Atukwatukw riti truvehe. Nənə nəpɨn Iəmə Atukwatukw nəha ruvehe, kɨmiaha hiəuvei pen in ia rəɡi nəmə Rom. Ia noien nəha hiousi əpune in. ");
INSERT INTO tnk_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kɨmiaha hiəuvəuvehi raka Loa səvəi Kumwesən sə naɡelo me həuvei pehe fwe kupwən, mətə hiamərui Loa nəha ia nəpɨn me.” ");
INSERT INTO tnk_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nəpɨn nəmə asori me səvəi nəkur Isrel həreɡi Stifen raməɡkiari, niemaha rəpi pɨk irəha. Kamhahi tərini revɨnraha tukwe. ");
INSERT INTO tnk_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Mətə Stifen rerɨn ruvehe mukuər ia Nənɨmwɨn Ikinan. Rəkwətə ia nɨmaɡouaɡou, mətoni nukuraanien asori ruku pen ia kwopun Kumwesən ramarə ikɨn, mətoni mwi Iesu ramərer ia nɨkare Kumwesən mwatuk. ");
INSERT INTO tnk_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Stifen rɨni mə, “Hətoni ro. Kəpuapen reitehi. Iakamətə Iəməti Iərmama fwe ia neiai ramərer ia nɨkare Kumwesən mwatuk.” ");
INSERT INTO tnk_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Mətə nəmə asori me səvəi nəkur Isrel hasək əpwəmwɨs, mho tukuahaɡ nəkwəreɡɨnraha. Irəha pam haiu, mhəuvən mə tuhəkwtəmhiri Stifen. ");
INSERT INTO tnk_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Irəha həkwtəmhiri Stifen, mhəuvehi, mhəier ia Jerusalem, mənamhəkwi in ia kəruəterei mə tremhə. Nərmama səməme haməuəsi Stifen həpeki raka karkahu əpwəmwɨs me səvənraha, mhəfate pen ia nɨsui iərmama riti nəɡhɨn nə Sol. ");
INSERT INTO tnk_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nəpɨn kamhəkwi Stifen, raməfwaki mɨni mə, “Iesu Iərɨmənu, tikuvehi nənɨmwɨk.” ");
INSERT INTO tnk_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kurirə irə rɨnɨmwi nukurhun mi, məkwein əpwəmwɨs, mɨni mə, “Iərɨmənu, tikəpwəh nərpwɨnien noien ərəha i irəha kamho ia nirak.” Nəpɨn rɨni iamɨnhi irə, in remhə. ");
INSERT INTO tnk_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Sol rerɨn raɡien a mə irəha housi əpune Stifen iamɨnhi. Nəpɨn Stifen ruvamhə raka, nəmə əfwaki me nepwɨn hənɨmwi nɨpwran mhasək asori tukwe. Ia nəpɨn nəha nərmama me nepwɨn həskəmter, mənamhometə asori nakalasia me fwe Jerusalem. Ro pen nakalasia me pam hap kɨrkɨri mhəuvən fwe ia kwopun me ia tənə Jutia mɨne Sameria. Aposol me əpa kamharə fwe Jerusalem. ");
INSERT INTO tnk_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sol mwi ramousari mə trouraha nakalasia me, mauvnimwə ia nimwə me kuatia kuatia, maməkwtəmhiri nərman mɨne nɨpran, mauvehi puvnimwə irəha ia kalapus. ");
INSERT INTO tnk_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Mətə irəha nəha hənap kɨrkɨri, mamhəuvən ia kwopun me, mamhəvisau irapw nəɡkiariien amasan səvəi Iesu. ");
INSERT INTO tnk_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip reiwaiu pehe ia taon riti fwe Sameria, maməvisau irapw Iesu Kristo m nərmama me fwe ikɨn. ");
INSERT INTO tnk_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nərmama pam kamhətərɨɡ amasan tɨ nəfe Filip rani, tɨ nəri nə mə raməɡkiari mamo nɨmtətien me. ");
INSERT INTO tnk_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Nərmama həpɨk nənɨmwɨn ərəha me həier ia nirəha, mamhasək əpwəmwɨs. Nərmama həpɨk mwi nɨsunraha me hemhə, ko həpkavən mhə, həuvehe mhəsanɨn. ");
INSERT INTO tnk_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ro pen nəkur ia taon nəha rerɨnraha raɡien asori. ");
INSERT INTO tnk_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Mətə iərmama riti nəɡhɨn nə Saemon, rɨnarə tui kwopti ia taon nəha, mamo nɨmtətien me ia nɨskaiien səvəi nəremhə me, mamo nəkur Sameria nənimenraha ramier. Saemon rani mə in iəmə asori. ");
INSERT INTO tnk_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Nəkur Sameria me pam kamhətərɨɡ ia nəɡkiariien səvənhi. Nəkwərhakwərha me men meste nəmə asori me kamhəni mə, “Iəmə i rauvehi nɨskaiien səvəi kumwesən nəha kani mə kumwesən asori.” ");
INSERT INTO tnk_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Irəha kamhətərɨɡ ia nəɡkiariien səvəi Saemon, tɨ nəri nə mə nəpɨn rɨpɨk ramo nɨmtətien me ia nɨskaiien səvəi nəremhə me, mamo nənimenraha ramier. ");
INSERT INTO tnk_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Mətə nəpɨn Filip raməvisau irapw Iesu Kristo mɨne nɨtətə sə Kumwesən ramərɨmənu irə, nərman me mɨne nɨpran me həni nɨpərhienien ia nəɡkiariien amasan səvənhi. Nənə ko paptaes ia nirəha. ");
INSERT INTO tnk_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saemon in mwi rɨni nɨpərhienien ia nəɡkiariien səvəi Filip. Nəpɨn kɨno raka paptaes irə, Saemon rukurirə ia Filip, mamətoni nɨmtətien me mɨne narimnari asori me Filip ramo ia nɨskaiien səvəi Kumwesən. Nəpɨn rətoni, nənimen rier. ");
INSERT INTO tnk_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kurirə irə, nəpɨn aposol me fwe Jerusalem həreɡi mə nəkur Sameria həuvəni raka nɨpərhienien ia nəɡkiariien səvəi Kumwesən, hərhi pen Pita mɨne Jon mə trouevən rouətə irəha. ");
INSERT INTO tnk_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Irau kroueiwaiu pen fwe Sameria, rouəfwaki tɨ nirəha mə irəha tuhəuvehi Nənɨmwɨn Ikinan, tɨ nəri nə mə ");
INSERT INTO tnk_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Nənɨmwɨn Ikinan rɨpkeiwaiu mhə ihi ia nirəha. Mətə kɨno paptaes əpa ia nirəha ia nəɡhi Iesu Iərɨmənu. ");
INSERT INTO tnk_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nəpɨn Pita mɨne Jon krouəmrutə rəɡɨnrau ia nukwənenraha, həuvehi Nənɨmwɨn Ikinan. ");
INSERT INTO tnk_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saemon rətoni mə aposol mi nəha krouəmrutə rəɡɨnrau ia nukwənenraha, nənə Kumwesən ruvei pen Nənɨmwɨn Ikinan mɨnraha. Ia nəpɨn nəha rətoni, Saemon ruvehi mane mə truvei pen mɨnrau, ");
INSERT INTO tnk_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","mɨni mə, “Rouvei pehe mwi nasoriien nəha miou. Iakokeikei mə takəmrutə rəɡɨk ia nukwəne nərmama pwəh irəha həuvehi Nənɨmwɨn Ikinan.” ");
INSERT INTO tnk_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Mɨreɡi Pita rɨni pen tukwe in mə, “Pwəh kɨmirau mane səim irouen ia napw, tɨ nəri nə mə ikuə tikuvehi nəmri nəri sə Kumwesən rauvei pen auər a m nərmama. ");
INSERT INTO tnk_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ikiwən ia wok i səkɨmaha, tɨ nəri nə mə nətərɨɡien səim rɨpkatukwatukw mhə ia nəmri Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Tikəpwəh noien ərəha i ikamo, məfwaki m Iərɨmənu, məres mə ko in renouenou nərəhaien səim, məpwəh nərpwɨnien nətərɨɡien ərəha i ikuə tiko. ");
INSERT INTO tnk_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Iakɨni iamɨnhi irə, tɨ nəri nə mə iakətə mə rerɨm ramakres pɨk. Nərəhaien rɨnərkwi ik.” ");
INSERT INTO tnk_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Mɨreɡi Saemon rɨni mə, “Kɨmirau tirouəfwaki miou, rouəres Iərɨmənu mə narimnari me i irauni tuhəpwəh nesteien iou.” ");
INSERT INTO tnk_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Kurirə ikɨn Pita mɨne Jon krouni irapw nəɡkiariien səvəi Iərɨmənu ia taon nəha, rouni mə ro nɨpərhienien i. Nəpɨn krouni sampam, krourərɨɡ rauevən fwe Jerusalem. Ia suatuk krauəvisau irapw nəɡkiariien amasan səvəi Iesu m nərmama me ia rukwənu me ia tənə Sameria. ");
INSERT INTO tnk_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ia nəpɨn nəha aɡelo riti səvəi Iərɨmənu rɨni pen tɨ Filip i mə, “Tikərer, mevən fwe prehi meste suatuk sə raku pen ia Jerusalem meiwaiu pen fwe Kasa.” (Suatuk nəha rukurau ia kwopun akwesakwes ikɨn.) ");
INSERT INTO tnk_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filip rərer mamevən, mətoni iəmə Itiopia riti. Iəmə nəha in Yunik riti. In iəmə asori. Ramətui amasan tɨ mane səvəi Kantis, prən asori sə ramərɨmənu ia nəkur Itiopia. Iəmə nəha ruvavən raka fwe Jerusalem məfwaki m Kumwesən, ");
INSERT INTO tnk_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","nənə mɨrərɨɡ mamevən fwe imwəni. In raməkure ia kat riti hos ravi, maməvsini nəkukuə nəha Profet Aesea rɨmərai. ");
INSERT INTO tnk_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nənə Nənɨmwɨn Ikinan rɨni pen tɨ Filip i mə, “Tiko mevən ipaka tɨ kat nəha hos ravi.” ");
INSERT INTO tnk_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ro pen Filip raiu mevən ipaka tukwe, mɨreɡi iəmə nəha raməvsini nəkukuə nəha Profet Aesea rɨmərai. Nənə rəres pen in i mə, “Ikaməvsini nəkukuə nəha, mukurən nɨpwran uə rekəm?” ");
INSERT INTO tnk_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mɨreɡi iəmə nəha rɨni mə, “Iou takəfukurən nɨpwran? Iərmama riti riwən mə trəusiəre pui pehe miou.” Rɨni pen tɨ Filip i mə trəputə məkure irau min. ");
INSERT INTO tnk_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Nəɡkiariien ia Nəkukuə Ikinan iəmə Itiopia nəha raməvsini in i mə: “Ho irə rəmwhen ia in sipsip riti, mhəiri, mhəuvən mə tuhousi əpune. Rəmwhen ia kwəti sipsip sə kaməkihi raka nɨmwherɨn ramərer mamətərɨɡ a, in mwi rəpwəh nəɡkiariien. ");
INSERT INTO tnk_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ho naurɨsien min, mhəuvei pen nərpwɨnien riti sə rɨpkatukwatukw mhə. Iərmama riti riwən trəɡkiari ia tɨni me, tɨ nəri nə mə housi əpune in, nɨmɨruien səvənhi rukwakwa a ia tɨprənə i.” ");
INSERT INTO tnk_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Iəmə Itiopia nəha rɨni pen tɨ Filip i mə, “Ni pehe ro tukw iou i mə sin nəha profet i raməɡkiari irə? In raməɡkiari atukw a irə uə raməɡkiari ia iərməpə?” ");
INSERT INTO tnk_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Nənə Filip rɨnaməɡkiari. Ro stat ia nəɡkiariien nəha iəmə Itiopia raməvsini ia Nəkukuə Ikinan, Filip raməvisau nəɡkiariien amasan səvəi Iesu min. ");
INSERT INTO tnk_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Irau krauesi suatuk nəha, rauevən, roueste kwopun riti nui ikɨn. Iəmə Itiopia rɨni mə, “Ətə ro, nui nəha. Ko iako paptaes uə nari riti nəha ro tukuahaɡ iou?” ");
INSERT INTO tnk_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Mɨreɡi Filip rɨni pen tukwe in mə, “Trɨni mɨnuə ikahatətə pərhien ia Iesu, ikukurən noien paptaes.” Mɨreɡi iəmə nəha rɨni mə, “Iakani nɨpərhienien ia Iesu mə in Tɨni Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ia nəpɨn nəha iəmə Itiopia rɨni mə kat səvənhi sə hos ravi trərer. Irau Filip kroueiwaiu irapw ia nui. Filip ro paptaes irə. ");
INSERT INTO tnk_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nəpɨn irau krouutə pehe ia nui, Nənɨmwɨn səvəi Iərɨmənu ruvehi raka Filip. Iəmə Itiopia rəpwəh mwi nətoniien, mətə ramesi pen suatuk səvənhi mamevən mamaɡien. ");
INSERT INTO tnk_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Mətə Filip rətoni mə in ramərer fwe taon nəha Astot. Kurirə ikɨn in revən ia rukwənu me, maməvisau irapw nəɡkiariien amasan səvəi Iesu meste nari fwe taon nəha Sisaria. ");
INSERT INTO tnk_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ia nəpɨn nəha Sol raməɡkiari skai ihi, mamɨni mə trousi əpune nərmama me səvəi Iərɨmənu. Rɨskəmter, mevən tɨ pris asori anan, ");
INSERT INTO tnk_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","məres pen in mə trɨrai nəkukuə me nepwɨn həuvən tɨ nimwəfwaki me səvəi nəkur Isrel fwe Tamaskes. Trɨni mɨnuə Sol rətoni nərmama me nepwɨn fwe ikɨn kamhesi pen Suatuk səvəi Iesu, nərman uə nɨpran, nəkukuə me nəha tuhəni sas pen mə Sol rauvehi nasoriien tɨ nəkwtəmhiriien irəha, mɨpeki pen irəha fwe Jerusalem. ");
INSERT INTO tnk_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sol rauvehe ipaka tɨ Tamaskes. Ia nəpɨn nəha nukuraanien riti ruku pen ia nɨmaɡouaɡou, məhiəpwɨn kurau kurau irə. ");
INSERT INTO tnk_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Sol rɨmwei irapw ia tɨprənə, mɨreɡi reri iərmama riti raməɡkiari mamɨni mə, “Sol, Sol, rəfo ikamometə Iou?” ");
INSERT INTO tnk_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Mɨreɡi Sol rəres mə, “Iəmə asori, ik sin i?” Mɨreɡi rɨni mə, “Iou i Iesu sə ikamometə. ");
INSERT INTO tnk_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Mətə tikərer, mevən fwe Tamaskes. Iərmama riti fwe ikɨn trɨni pehe tukw ik i nəfe nari tikaməkeikei mo.” ");
INSERT INTO tnk_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nərmama səməme kamhəkurirə ia Sol kamhərer kwənamrɨɡ. Irəha hamreɡi reri iərmama riti, mətə həpwəh nətoniien nɨpwran. ");
INSERT INTO tnk_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol rɨskəmter, mətui, mətə rəpwəh nətoniien nari. Ro pen irəha həuvehi rəɡɨn, mhəiri, mhəuvən fwe Tamaskes. ");
INSERT INTO tnk_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sol rəpwəh nətoniien nari meste nəpɨn kahar, mɨpkəni mhə nari, mɨpkənɨmwi mhə nari riti. ");
INSERT INTO tnk_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Iərmama riti səvəi Iesu ramarə ia Tamaskes nəɡhɨn nə Ananaeas. Iərɨmənu rɨni pen tukwe in ia vison riti mə, “Ananaeas.” Mɨreɡi rɨni mə, “Iou fa, Iərɨmənu.” ");
INSERT INTO tnk_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mɨreɡi Iərɨmənu rɨni pen tukwe in mə, “Tikərer mevən fwe ia nimwə səvəi Jutas. Nimwə nəha ramərer ia suatuk nəha kani mə Suatuk Atukwatukw. Tikevən fwe ikɨn məres iəmə Tasas riti nəɡhɨn nə Sol. In raməfwaki, ");
INSERT INTO tnk_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","mɨnətə vison riti. Ia vison nəha rətoni iərmama riti nəɡhɨn nə Ananaeas ruvnimwə pehe, məmrutə rəɡɨn mi irə mə trətə mwi nari.” ");
INSERT INTO tnk_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Mɨreɡi Ananaeas rɨni mə, “Mətə Iərɨmənu, nərmama həpɨk hənəvisau raka iərmama nəha miou, mhəni irapw noien ərəha me ramo ia nərmama me səim fwe Jerusalem. ");
INSERT INTO tnk_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Pris asori me həuvei pen nasoriien min mə truvehe ia kwopun i məkwtəmhiri nərmama səməme kamhəfwaki pehe mik.” ");
INSERT INTO tnk_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Mətə Iərɨmənu rɨni pen tukwe in mə, “Tiko mevən, iakɨnərpwi raka rəɡɨk irə. In trɨni irapw nəɡhɨk tɨ nərmama me rɨpko mhə irəha nəkur Isrel, mɨne kiɡ me, mɨne nəkur Isrel mwi. ");
INSERT INTO tnk_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Iou tako in rətoni mə traməkeikei mɨreɡi nəmisəien asori tɨ nəɡhɨk.” ");
INSERT INTO tnk_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ia nəpɨn nəha Ananaeas revən, muvnimwə ia nimwə nəha, məmri pen rəɡɨn mi ia Sol, mɨni mə, “Sol, piak, Iesu Iərɨmənu sə rɨməier pehe tukw ik ia suatuk nəha ikesi pen mauvehe, in i rərhi pehe iou mə takomasan nənimem. Nənə rerɨm truvehe mukuər ia Nənɨmwɨn Ikinan.” ");
INSERT INTO tnk_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ananaeas rɨni iamɨnhi irə, nənə təkwtəkwuni a nari riti rəmwhen ia rɨrevi nəmu raraka fwe ia nənime Sol mi. Sol rətə mwi nari, mɨskəmter, ko paptaes irə. ");
INSERT INTO tnk_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Nənə rəni nari, mɨreɡi nɨskaiien səvənhi ruvehe mwi, nənə mamarə nəpɨn me nepwɨn fwe Tamaskes irəha nərmama me səvəi Iesu. ");
INSERT INTO tnk_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Sol revən atukwatukw muvnimwə ia nimwəfwaki me səvəi nəkur Isrel, maməvisau irapw Iesu, mamɨni mə, “In Tɨni Kumwesən.” ");
INSERT INTO tnk_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nəpɨn nərmama me həreɡi, irəha pam hərkərinari ia Sol, mhəni mə, “Kwa iəmə i ramouraha nərmama me fwe Jerusalem səməme kamhəkwein nəɡhi Iesu i. Nənə ruvehe ia kwopun i mə trəkwtəmhiri irəha muvi irəha həuvən tɨ pris asori me. Mətə təkwtəkwuni rɨnəfo nəha?” ");
INSERT INTO tnk_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Mətə Sol ruvehe mɨskai pɨk, mamo nərmama me hətoni mə nɨpərhienien Iesu in Kristo. Ro pen nəkur Isrel me fwe Tamaskes səməme həpkɨni mhə nɨpərhienien ia Iesu ko həpkɨni mhə nəɡkiariien riti. ");
INSERT INTO tnk_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Nəpɨn rɨpɨk rukurau, nənə nəkur Isrel hərai sun mə tuhousi əpune Sol. ");
INSERT INTO tnk_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Mətə Sol rɨreɡi nətərɨɡien səvənraha. Ia nəpɨn mɨne ia ran, irəha kamhərer mwatuk ia kwəruə me səvəi taon, mamheitenhi in mə tuhousi əpune. ");
INSERT INTO tnk_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Mətə nəpɨn riti ia nəpɨn, nərmama nepwɨn səməme kamhəkurirə ia Sol, həvai pen Sol ia tənərɨpw, mhəuvehi irapw ia nɨkare nəpai sə rukurau kurau ia Tamaskes. ");
INSERT INTO tnk_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol revən fwe Jerusalem. Nəpɨn rapirapw fwe ikɨn, raməmwur mə tuhousəsɨmwɨn pəri irəha nərmama me səvəi Iesu. Mətə irəha pam kamhəhekɨr i, mhəpwəh nɨniien nɨpərhienien irə mə in iərmama riti səvəi Iesu. ");
INSERT INTO tnk_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Mətə Panapas ruvehe, miri in rouen rouətə aposol me. Nənə Panapas rɨni pen tɨ nirəha i mə, “Sol i rɨnətə Iərɨmənu ia suatuk, rɨnəɡkiari min. Fwe Tamaskes, Sol raməvisau irapw nəɡhi Iesu, məpwəh nehekɨrien.” ");
INSERT INTO tnk_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ro pen Sol ramarə irəha mɨnraha, mamavən fwe ia Jerusalem, maməvisau ia nəɡhi Iərɨmənu səkɨtaha, məpwəh nehekɨrien. ");
INSERT INTO tnk_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nəpɨn riti Sol raməɡkiari irəha nəkur Isrel səməme kamhəni nəɡkiariien Kris, mamhousari mɨnraha me. Mətə hənuə tuhousi əpune in. ");
INSERT INTO tnk_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nəpɨn piəvtaha me həreɡi, həuvehi Sol, mheiwaiu mhəuvən fwe ia təsi ia taon nəha Sisaria, mhərhi pen i ramevən fwe taon nəha Tasas. ");
INSERT INTO tnk_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ia nəpɨn nəha nakalasia me pam fwe tənə Jutia, mɨne tənə Kalili, mɨne tənə Sameria hamarə ia nəmərinuien. Iərmama riti riwən ramometə irəha. Nənɨmwɨn Ikinan ramasitu ia nirəha, mamərpwi əknekɨn irəha. Nəpɨn irəha kamhavən, mamhəsiai Iərɨmənu səvənraha, in ramo irəha kamhəpɨk mwi. ");
INSERT INTO tnk_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita ramevən ia kwopun me maməti pen nakalasia me. Ia nəpɨn nəha reiwaiu pehe mwi fwe ia taon nəha Lita mə trəti pen nərmama me səvəi Kumwesən fwe ikɨn. ");
INSERT INTO tnk_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Iərmama riti ia taon nəha nəɡhɨn nə Aeneas. Nuk eit ramapri a ia kafete. Nɨsun mi krouemhə ko rɨpkavən mhə. ");
INSERT INTO tnk_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita rɨni pen tukwe in mə, “Aeneas, Iesu Kristo tro amasan nɨpwram. Ərer, mərfe səim kafete.” Təkwtəkwuni a Aeneas rərer. ");
INSERT INTO tnk_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nərmama me pam fwe Lita mɨne Saron hətoni iəmə nəha hərərɨɡ mhəuvehe tɨ Iərɨmənu. ");
INSERT INTO tnk_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ia taon nəha Jopa, pran riti ramahatətə ia Iesu. Nəɡhɨn nə Tapita. Nɨpwrai nəhaɡ nəha ia nəɡkiariien Kris in i mə Tokas. Ia nəpɨn me prən nəha ramo wok amasan, mamasitu ia nərmama səməme nautə səvənraha riwən. ");
INSERT INTO tnk_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ia nəpɨn riti, in ruvehi nemhəien riti, memhə. Irəha haikuas ia nɨpwran, mhəmri pen ia nəkwai nimwə səvənhi ia rum riti fwe irənhə. ");
INSERT INTO tnk_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Taon nəha Jopa ipaka tɨ taon nəha Lita. Nəpɨn nərmama me səvəi Iesu fwe Jopa həreɡi Pita mə in fwe Lita, hərhi pen iərmama kəru mə trouevən rouni pen tukwe in mə tiruvehe akwauakw, mətoni ro irəha. ");
INSERT INTO tnk_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ro iamɨnhi irə Pita rərer, mukurirə ia nirau i. Nəpɨn harapirapw fwe imwei Tokas, həiri in mhəuvən fwe ia rum nəha irənhə. Nɨpran səməme nərman me səvənraha həuvamhə kamhərer kuraukurau Pita mamhasək, mamhasansani karkahu me mɨne tɨnari me Tokas rɨmətiri ia nəpɨn ramarə ihi irəha mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita rɨni pen tɨ nirəha i mə tuhəuvən fwe iruə. Nəpɨn həier irə, in rɨnɨmwi nukurhun mi məfwaki, muvsini, məti pen mətoni nɨpwrai prən nəha, mɨni mə, “Tapita, tiko mərer!” Tapita rɨfi nənimen. Nəpɨn rətoni Pita, rɨskəmter, məkure. ");
INSERT INTO tnk_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita ruvehi rəɡɨn, mɨvi utə rərer. Kurirə irə Pita rəkwein pen nərmama me səvəi Kumwesən mɨne nɨpran me səməme nərman me səvənraha həuvamhə həuvehe. Irəha hətoni mə Tapita ruvəmɨru. ");
INSERT INTO tnk_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kurirə irə kaməvisau nəri nəha ia kwopun me pam ia Jopa. Nərmama həpɨk həni nɨpərhienien ia Iərɨmənu. ");
INSERT INTO tnk_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Nənə Pita rarə əpwəmwɨs ia Jopa irau iərmama riti sə ramo narimnari me ia teki kau. Iərmama nəha nəɡhɨn nə Saemon. ");
INSERT INTO tnk_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Iərmama riti, nəɡhɨn nə Konilias, ramarə fwe Sisaria. In iaruaɡən riti səvəi Rom. In rasori ia naruaɡən me irəha pam hantret. Kani irəha mə Naruaɡən me səvəi Itali. ");
INSERT INTO tnk_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Konilias in iəməfwaki riti. In mɨne nərmama pam ia nəkwai nimwə səvənhi kamhəsiai Kumwesən. Konilias rauvei pen mane asori m nəkur Isrel trasitu ia nirəha. Ia nəpɨn me raməfwaki m Kumwesən səvənraha. ");
INSERT INTO tnk_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Nəpɨn riti, ipaka tɨ tri klok ia nəruarəv, Konilias rətoni vison riti. Ia vison nəha aɡelo riti səvəi Kumwesən ruvnimwə pehe, mɨni mə, “Konilias.” ");
INSERT INTO tnk_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Konilias rəti pen mətoni aɡelo nəha, mehekɨr, mɨni mə, “Iəmə asori, rəfo?” Mɨreɡi aɡelo rɨni mə, “Kumwesən ruvəreɡi raka nəfwakiien me səim, mətoni narimnari me səim sə ikauvei pen m nərmama səməme nautə səvənraha riwən. Rerɨn ramrhi ik. ");
INSERT INTO tnk_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Təkwtəkwuni tikərhi pen nərmama me nepwɨn həuvən fwe taon nəha Jopa pwəh həiri iərmama riti nəɡhɨn nə Saemon kani mwi in mə Pita mhəiri mhəuvehe. ");
INSERT INTO tnk_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","In ramarə ia nimwə səvəi iərmama riti sə ramo narimnari me ia teki kau. Nəɡhɨn nə Saemon. Nimwə səvənhi ipaka tɨ təsi.” ");
INSERT INTO tnk_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nəpɨn aɡelo rəpwəh in mamevən, Konilias rəkwein iərmama kəru sə krauo tukwini nari min, məkwein mwi iaruaɡən riti ia nirəha səməme kamho nəkwan. Iaruaɡən nəha in mwi iəməfwaki riti. Irəhar haruvehe ");
INSERT INTO tnk_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","nənə Konilias rɨni irapw narimnari me pam mɨnrahar, mərhi pen irəhar, harevən fwe Jopa. ");
INSERT INTO tnk_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kɨni rakwakwi irə, ia kurkwai nəpɨn ia ran, nəpɨn irəhar haruvehe ipaka tɨ taon nəha Jopa, Pita rutə pen fwe təkure nimwə mə trəfwaki. ");
INSERT INTO tnk_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Rɨreɡi nukumhə rɨnahi, mokeikei mə trəni nari. Nəpɨn irəha kamhəuvani ihi nəveɡɨnien sənəni, in rətoni vison riti. ");
INSERT INTO tnk_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ia vison nəha rətoni kəpuapen reitehi, nənə, nari riti rəmwhen ia tapolen asori kauvehi ia kona kefə səvənhi rameiwaiu irapw pehe ia tɨprənə. ");
INSERT INTO tnk_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ia nəkwai tapolen nəha, nərimɨru me səpəmsəpə mɨne snek me mɨne menu me i kamhəivə ia nɨmaɡouaɡou. ");
INSERT INTO tnk_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Pita rɨreɡi reri iərmama riti rɨni mə, “Pita, tiko mərer, mousi əpune nəri nə riti, məni.” ");
INSERT INTO tnk_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Mətə Pita rɨni mə, “Rekəm, Iərɨmənu! Iou iapkəni mhə ihi nari riti ikɨməni mə tukəpwəh nəniien, uə nari riti sə rəmkemɨk ia nənimem.” ");
INSERT INTO tnk_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Mɨreɡi reri iərmama nəha rəɡkiari mwi min mə, “Nəfe Kumwesən rɨməni mə rəmher, tikəpwəh nɨniien mə rəmkemɨk.” ");
INSERT INTO tnk_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Nəɡkiariien nəha ruvehe tɨ Pita m kahar, nənə tapolen nəha kuvehi utə revən fwe ia neiai. ");
INSERT INTO tnk_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Kurirə ikɨn Pita ramətərɨɡ mə trəfukurən nɨpwrai vison nəha in rɨnətoni. Iərmama kahar Konilias rərhi pen irəhar, harətui, mharənətə raka nimwə səvəi Saemon, mamharərer ia kwəruə səvənhi fwe iruə. ");
INSERT INTO tnk_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Irəhar harəkwein pen, mharəres mə, “Iərmama riti nəɡhɨn nə Saemon kani mwi in mə Pita ramarə ia kwopun i uə rekəm?” ");
INSERT INTO tnk_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita rerɨn ramrhi ihi vison nəha rɨnətoni mamətərɨɡ tukwe. Ia nəpɨn nəha Nənɨmwɨn Ikinan rɨni pen tukwe in mə, “Ətə ro. Iərmama kahar fwe kamharətui ik. ");
INSERT INTO tnk_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tikərer, meiwaiu, mevən kɨmiaha mɨnrahar. Tikəpwəh nehekɨrien, tɨ nəri nə mə iou iakərhi pehe irəhar haruvehe.” ");
INSERT INTO tnk_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ro iamɨnhi irə Pita reiwaiu, mevən tɨ iəmənmirəhar nəha, mɨni mə, “Iou i iərmama nə hiamarətui. Hiaruvehe tɨ nəfe?” ");
INSERT INTO tnk_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Mɨreɡi harni pen tukwe in mə, “Konilias, iəmə asori riti səvəi naruaɡən me, rərhi pehe kɨmrahar. In iəmə atukwatukw sə ramsiai Kumwesən. Nəkur Isrel me pam həɡnəɡɨni in mə in iəmə amasan riti. Aɡelo ikinan riti səvəi Kumwesən rɨni pen tɨ Konilias i mə trəkwein pehe ik mə tikevən fwe nimwə səvənhi pwəh in rɨreɡi nəɡkiariien səim.” ");
INSERT INTO tnk_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Mɨreɡi Pita rɨni pen tɨ nirəhar i mə “Kɨmirəhar tiharuvnimwə pehe pwəh sapri. Trakwakwi a saməuvən.” Kɨni rakwakwi irə, Pita rətui ia nəpnəpɨn, mhəier irəha mɨnrahar. Piəvtaha me nepwɨn səməme kamharə fwe Jopa həkurirə in. ");
INSERT INTO tnk_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Nənə rakwakwi mwi irə, həuvən mhapirapw fwe ia Sisaria. Konilias rameitenhi irəha. In rɨnoeite raka nərmama ia kwənəkwus səvənhi mɨne in me nepwɨn fwe ia nəkwai nimwə səvənhi. ");
INSERT INTO tnk_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Nəpɨn Pita ruvehe ipaka tɨ nimwə səvəi Konilias, Konilias ruvehe, mɨnɨmwi nukurhun mi ia nənimen, mamsiai in. ");
INSERT INTO tnk_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Mətə Pita rɨvi utə, mɨni mə, “Ərer, iou iakəmwhen a ia niram.” ");
INSERT INTO tnk_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Irau krouəɡkiari, rouuvnimwə. Nəpɨn Pita rəti pen mətoni nərmama həpɨk hənousəsɨmwɨn raka irəha me, ");
INSERT INTO tnk_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","in rɨni pen tɨ nirəha i mə, “Kɨmiaha i hiəuvəukurən raka mə Loa səkɨmaha nəkur Isrel raməsisəɡ əknekɨn kɨmaha. Ko iahəpkuvnimwə mhə ia nəkwai nimwə me səvəi nərmama me rɨpko mhə irəha nəkur Isrel uə mamhavən pəri kɨmaha mɨnraha. Mətə Kumwesən ro iakətoni mə ko iakəpwəh nɨniien mə iərmama riti in rəmkemɨk ia nənimen. ");
INSERT INTO tnk_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ro pen nəpɨn hiəkwein iou mə takuvehe, iakuvehe a, məpwəh nɨniien nari riti. Nənə təkwtəkwuni iakuə takəres kɨmiaha i mə hiəkwein pehe iou tɨ nəfe?” ");
INSERT INTO tnk_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Mɨreɡi Konilias rɨni mə, “Irəkahar ia nəruarəv, rəmwhen təkwtəkwuni, iakaməfwaki ia nəkwai nimwə səiou. Nənə iakətə iərmama riti ramərer ia nənimek. Tɨnari səvənhi rəpsan. ");
INSERT INTO tnk_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Rɨni pehe tukw iou i mə, ‘Konilias, Kumwesən ruvəreɡi raka nəfwakiien me səim. Rerɨn ramrhi narimnari me səim sə ikauvei pen m nərmama səməme nautə səvənraha riwən. ");
INSERT INTO tnk_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Tikərhi pen nərmama nepwɨn həuvən fwe taon nəha Jopa mə tuhəres iərmama riti nəɡhɨn nə Saemon Pita. Ramarə ia nimwə səvəi iərmama riti nəɡhɨn mwi nə Saemon. In iəmə sə ramo narimnari me ia teki kau. Nimwə səvənhi ipaka tɨ təsi.’ ");
INSERT INTO tnk_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Aɡelo nəha rɨni iamɨnhi, ro pen təkwtəkwuni a irə iakərhi pehe nərmama me nepwɨn tukw ik. Ik iko noien amasan muvehe tukumaha i. Təkwtəkwuni kɨmaha pam iahaməkure ia kwopun i ia nəmri Kumwesən, mamheitenhi mə tahəreɡi nəfe nəɡkiariien in ruvei pehe mik mə tikɨni pehe tukumaha i.” ");
INSERT INTO tnk_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ia nəpɨn nəha Pita rɨnaməɡkiari mɨni mɨnuə, “Iakətə pərhien mə Kumwesən ramo rəmnəmwhen ia nərmama me pam. ");
INSERT INTO tnk_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Trɨni mɨnuə iərmama riti ramsiai in, mamo noien amasan, Kumwesən trəkwein amasan irə. Nəri auər a mə iəmə nəha in iəmə Isrel uə in iərməpə. ");
INSERT INTO tnk_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","37","Kɨmiaha hiəukurən nəɡkiariien nəha Kumwesən rɨnərhi pen tɨ nəkur Isrel. Raməvisau nəɡkiariien amasan səvəi nəmərinuien kauvehi raku pen tɨ Iesu Kristo sə in Iərɨmənu səvəi narimnari me pam. Kɨnostat kɨni irapw nəɡkiariien amasan nəha ia tənə Kalili fwe kupwən nəpɨn Jon rɨnəvisau raka mə nərmama tuhaməkeikei mho paptaes. Kɨni irapw fwe ia kwopun me pam ia tənə Jutia. ");
INSERT INTO tnk_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Kɨmiaha hiəukurən mwi navənien səvəi Iesu, iəmə Nasaret. Fwe kupwən, Kumwesən ruvei pen Nənɨmwɨn Ikinan mɨne nɨskaiien min. Nənə tɨ nəri nə mə Kumwesən ramarə tukwe, Iesu ramevən ia kwopun me, mamo noien amasan. Nərmama səməme kamharə ia rəɡi Setan, in rapeki raka irəha, mamomasan irəha. ");
INSERT INTO tnk_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Kɨmaha i iahənətoni narimnari me nəha Iesu rɨno fwe tənə səvəi nəkur Isrel mɨne ia Jerusalem. Irəha hərui tərini pen in ia nei kamarkuaui, remhə. ");
INSERT INTO tnk_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Mətə ia nəpɨn səro kahar irə, Kumwesən ro in rətui mwi ia nemhəien səvənhi. Kurirə irə Iesu rier irapw tɨ nərmama. ");
INSERT INTO tnk_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","In rɨpkier irapw mhə tɨ nərmama me pam, mətə rier irapw tukumaha i səməme Kumwesən rɨnərpwi rəɡɨn ia kɨmaha mɨni mə tahətoni. Nəpɨn Iesu rɨnətui mwi ia nemhəien səvənhi, kɨmaha iahani pəri nari, mhənɨmwi pəri kɨmaha min. ");
INSERT INTO tnk_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","In rɨni pehe tukumaha i mə tahaməkeikei mhəvisau m nərmama, mhəni irapw mə Kumwesən ruvəuvehi utə raka in. Iesu nəha in nəha iərmama sə trəkiri noien me səvəi nərmama me pam, nərmama kamhəmɨru mɨne səməme həuvamhə. ");
INSERT INTO tnk_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Profet kupwən me pam həɡkiari ia Iesu nəha, mamhəni mə nərmama səməme kamhahatətə irə, tɨ nəri nə mə kamhəni nɨpərhienien ia nəɡhɨn, Kumwesən trenouenou noien ərəha me səvənraha, məpwəh nərpwɨnien.” ");
INSERT INTO tnk_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Nəpɨn Pita raməɡkiari ihi, Nənɨmwɨn Ikinan reiwaiu ia nərmama me pam nəha kamhətərɨɡ ia nəɡkiariien səvənhi. ");
INSERT INTO tnk_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Nəkur Isrel me nəha kamhəni nɨpərhienien ia Iesu haməuku pen fwe Jopa irəha Pita hamərkərinari tɨ nəri nə mə Kumwesən rərhi irapw Nənɨmwɨn Ikinan, muvei pen mwi m nərmama me nəha rɨpko mhə irəha nəkur Isrel. ");
INSERT INTO tnk_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Hamərkəri asori nari ia nirəha tɨ nəri nə mə kamhəreɡi irəha kamhəɡkiari ia nəɡkiariien me səpəmsəpə, mamhəɡnəɡɨni Kumwesən tɨ narimnari amasan me sə rɨno. Ia nəpɨn nəha Pita rɨni mə, ");
INSERT INTO tnk_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ko iərmama riti rəsisəɡ nərmama me nəha mɨni mə tuhəpwəh noien paptaes ia nui? Irəha həuvəuvehi raka Nənɨmwɨn Ikinan rəmwhen mwi ia kɨtaha.” ");
INSERT INTO tnk_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ro iamɨnhi irə Pita rɨni nəkwan mə tukaməkeikei ko paptaes ia nirəha ia nəɡhi Iesu Kristo. Nəpɨn kɨno raka paptaes ia nirəha, həres pen Pita mə trarə pəpɨm irəha mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Aposol me mɨne piəvtaha me fwe ia tənə Jutia həreɡi mə nərmama me rɨpko mhə irəha nəkur Isrel, irəha mwi həuvəni nɨpərhienien ia nəɡkiariien səvəi Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ia nəpɨn nəha Pita rutə pen fwe Jerusalem. Nəkur Isrel me nepwɨn fwe ikɨn kamhəni nɨpərhienien ia Iesu, mamhəni mwi mə nərmama me i rɨpko mhə irəha nəkur Isrel tuhaməkeikei mhəuvən kuvehi ninhum mɨnraha tɨ Loa səvəi Moses. Nəkur Isrel me i həski Pita, ");
INSERT INTO tnk_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","mhəni pen tukwe mə, “Rəfo ikuvnimwə məni pəri nari kɨmiaha nərmama me nəha kəpwəh nuvehiien ninhum mɨnraha?” ");
INSERT INTO tnk_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pita rɨskəmter, mɨni pen tɨ nirəha i narimnari me sə kɨno. In rɨni fwe nukunen muvehe, mɨni mə, ");
INSERT INTO tnk_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Kupwən, iakaməfwaki fwe taon nəha Jopa. Nənə iakətoni vison riti. Nari riti rəmwhen ia tapolen asori kauvehi ia kona kefə səvənhi ruku pen ia neiai meiwaiu irapw pehe ipaka tukw iou. ");
INSERT INTO tnk_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Iakəti pen mətə amasan ia nəkwan mətoni nərimɨru me sə həpou mɨne sə kamhəhekɨr mɨne snek me mɨne menu me sə kamhəivə ia nɨmaɡouaɡou. ");
INSERT INTO tnk_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nənə iakreɡi reri iərmama riti rɨni pehe tukw iou i mə, ‘Pita, tikərer, mousi əpune nəri nə riti, məni.’ ");
INSERT INTO tnk_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Mətə iakɨni mə, ‘Rekəm, Iərɨmənu! Iou iapkəni mhə ihi nari riti ikɨməni mə tukəpwəh nəniien, uə nari riti sə rəmkemɨk ia nənimem.’ ");
INSERT INTO tnk_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Mɨreɡi reri iərmama nəha ruku pen fwe ia neiai, mɨni mwi mə, ‘Nəfe nari Kumwesən rɨməni mə rəmher, tikəpwəh mwi nɨniien mə rəmkemɨk.’ ");
INSERT INTO tnk_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Nəɡkiariien nəha ruvehe tukw iou m kahar. Nənə kuvehi utə tapolen nəha revən mwi fwe ia neiai. ");
INSERT INTO tnk_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Təkwtəkwuni a irə, iərmama kahar haruvehe mharapirapw ia nimwə nəha iakamarə irə. Iərmama riti fwe Sisaria rɨnərhi pehe irəhar haruvehe tukw iou. ");
INSERT INTO tnk_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Nənə Nənɨmwɨn Ikinan rɨni pehe tukw iou i mə, ‘Tikevən kɨmiaha mɨnrahar, məpwəh nehekɨrien.’ Ro pen iakevən. Piəvtaha me i sikis irəha mwi həkurirə ia nirak. Iahəuvən, mhəuvnimwə ia nimwə səvəi iərmama riti fwe Sisaria. Nəɡhɨn nə Konilias. ");
INSERT INTO tnk_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Nənə in rɨni pehe tukumaha i mə rɨnətə aɡelo riti ramərer ia nəkwai nimwə səvənhi, mani pen tukwe in mə, ‘Tikərhi pen nərmama nepwɨn həuvən fwe taon nəha Jopa mhəiri iərmama riti nəɡhɨn nə Saemon Pita mhəiri mhəuvehe. ");
INSERT INTO tnk_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","In trɨni pehe nəɡkiariien riti tukw ik. Nəɡkiariien nəha truvehimɨru ik mɨne nərmama me pam ia nəkwai nimwə səim.’ ");
INSERT INTO tnk_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nənə ia nəpɨn nəha iakɨnaməɡkiari irə, Nənɨmwɨn Ikinan reiwaiu ia nirəha, mo rəmwhen rɨno ia kɨtaha fwe kupwən. ");
INSERT INTO tnk_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ia nəpɨn nəha rerɨk rɨrhi nəɡkiariien səvəi Iərɨmənu. In rɨməni mə ‘Jon rɨno paptaes ia nui, mətə Kumwesən tro paptaes ia kɨmiaha ia Nənɨmwɨn Ikinan.’ ");
INSERT INTO tnk_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Fwe kupwən, nəpɨn kɨtaha i nəkur Isrel səni nɨpərhienien ia Iesu Kristo Iərɨmənu səkɨtaha, Kumwesən ruvei pehe Nənɨmwɨn Ikinan m kɨtaha. Nənə sətoni ruvei pen rəmwhen a mwi m nərmama me nəha rɨpko mhə irəha nəkur Isrel. Ro iamɨnhi irə iou nəfe iərmama mə takərer məsisəɡ Kumwesən?” ");
INSERT INTO tnk_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pita rəɡkiari pam. Nənə nəpɨn həreɡi nəɡkiariien nəha, həpwəh mwi nəɡkiariien, mətə kamhəɡnəɡɨni Kumwesən mə, “Nəri nəha Kumwesən rɨno raka suatuk səvəi nərmama rɨpko mhə irəha nəkur Isrel, irəha mwi ko hərərɨɡ ia noien ərəha me səvənraha, nənə mhəuvehi nɨmɨruien.” ");
INSERT INTO tnk_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Nərmama me səvəi Iesu səməme hənap kɨrkɨri fwe kupwən, tɨ nəri nə mə kousi əpune Stifen nənə kənamometə mwi irəha, hap mhəuvən isipwɨn mheste nari fwe Fonisia, mɨne Saepras, mɨne Antiok, mamhəvisau irapw nəɡkiariien amasan səvəi Iesu m nəkur Isrel əpa. ");
INSERT INTO tnk_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Mətə nepwɨn, nəkur Saepras mɨne Saerin, həuvehe ia Antiok, mamhəvisau irapw Iesu Iərɨmənu m nəkur Kris mwi. ");
INSERT INTO tnk_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nɨskaiien səvəi Iərɨmənu ramarə mwi tɨ nirəha. Ro iamɨnhi irə nərmama həpɨk həni nɨpərhienien ia nəɡkiariien səvənraha, mhərari, mhəuvehe tɨ Iərɨmənu. ");
INSERT INTO tnk_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Nəpɨn kəvisau pen m nakalasia me fwe Jerusalem mə nərmama me nepwɨn fwe Antiok həuvəni nɨpərhienien ia Iərɨmənu, hərhi pen Panapas ramevən fwe ikɨn. ");
INSERT INTO tnk_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nəpɨn Panapas rier pen fwe Antiok, mətoni namasanien səvəi Kumwesən ramarə pərhien tɨ nirəha, rerɨn raɡien. In rərpwi əknekɨn irəha mamɨni mə, “Kɨmiaha pam tihaməkeikei mhəkwtəmhiri əknekɨn Iərɨmənu. Nətərɨɡien səkɨmiaha trəpwəh nɨmweiien.” ");
INSERT INTO tnk_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Panapas in iəmə amasan riti. Rerɨn rukuər ia Nənɨmwɨn Ikinan. Nahatətəien səvənhi rɨskai. In rɨvi nərmama həpɨk həuvehe tɨ Iərɨmənu. ");
INSERT INTO tnk_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kurirə irə rier mevən fwe Tasas mə trətui Sol. ");
INSERT INTO tnk_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nəpɨn rətoni, riri Sol rourərɨɡ rouvehe mwi ia Antiok. Meste nuk kuatia irau krouarə irəha nakalasia me fwe ikɨn, rouahatən nərmama me həpɨk. Fwe ia Antiok kɨməkupwən kɨseɡi pen nəhaɡ nəha “Kristin me” m nərmama me səvəi Iesu. ");
INSERT INTO tnk_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ia nəpɨn nəha profet me nepwɨn həuku pen fwe Jerusalem, mheiwaiu pehe Antiok. ");
INSERT INTO tnk_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Irəha riti nəɡhɨn nə Akapus rɨskəmter. Nənɨmwɨn Ikinan ruvei pen nəɡkiariien min mə trukupwən mɨni irapw mə rɨpko mhə tui nukumhə asori riti trahi nərmama pam ia tɨprənə i. (Nukumhə nəha ruvehe ia nəpɨn nəha Klotias ramərɨmənu ia nɨtətə səvəi nəkur Rom.) ");
INSERT INTO tnk_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Akapus rɨni irapw nəɡkiariien nəha ro pen piəvtaha me fwe Antiok rerɨnraha ramrhi mə tuhəuvei pen mane me nepwɨn rəmwhen tɨ nirəha kuatia kuatia, mhərhi pen i revən trasitu ia nərmama me səvəi Iesu səməme kamharə fwe ia tənə Jutia. ");
INSERT INTO tnk_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Nənə ho. Həuvei pen mane ia rəɡi Sol mɨne Panapas mə irau trouvehi, rouevən rouvei pen m elta me səvəi nəfwakiien fwe Jerusalem. ");
INSERT INTO tnk_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ia nəpɨn nəha Kiɡ Herot rɨnamometə nakalasia me nepwɨn, ");
INSERT INTO tnk_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","mɨni pen tɨ nərmama me səvənhi mə tuhəuvən mhəkwtəmhiri Jemes piəvi Jon. Irəha həuvən mhəkwtəmhiri, mhərai əpune in ia nau. ");
INSERT INTO tnk_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nəpɨn Herot rətoni mə nəkur Isrel rerɨnraha raɡien tɨ noien nəha, in revən, mərhi pen nərmama me səvənhi mə tuhəuvən mhəkwtəmhiri mwi Pita. Nometəien nəha kɨno ia nəpɨn atukwatukw səvəi Pasova mɨne nəveɡɨnien asori nəha nəkur Isrel hani bred sə yis riwən irə. ");
INSERT INTO tnk_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Nəpɨn həkwtəmhiri Pita, həuvehi puvnimwə ia kalapus. Herot ruvehi pen in ia rəɡi naruaɡən me kusen kefə. Naruaɡən me kefə ia kusen kuatia. Rerɨn rɨrhi mə nəveɡɨnien asori tro sampam, nənə in rɨvi irapw Pita ia nəmri nərmama. ");
INSERT INTO tnk_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pita raməmak ia kalapus, mətə nakalasia me kamhəfwaki m Kumwesən tukwe, mhəpkapwɨs mhə. ");
INSERT INTO tnk_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herot rerɨn ramrhi mə trakwakwi rɨvi irapw Pita ia nəmri nərmama. Ia nəpɨn nəha, ia nəpɨn, Pita ramapri ia kurkwai iaruaɡən mi kəru. Kərihi tərini in ia jen kəru. Iaruaɡən mi kəru krouərer ia təpinhə səvəi kalapus rouətui tɨ nərmama me fwe imwə mə riti trəpwəh napien. ");
INSERT INTO tnk_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Təkwtəkwuni a aɡelo riti səvəi Iərɨmənu rier irapw. Nɨpwran rəhiapw məhiəpwɨn rum nəha Pita ramapri ikɨn. Aɡelo nəha rousi nɨkare Pita, məsuəpwiri in, mɨni mə, “Əskəmter akwauakw!” Ia nəpɨn nəha jen rier raka ia rəɡi Pita. ");
INSERT INTO tnk_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Nənə aɡelo rɨni pen tukwe in mə, “Ətoti, muvehi pen səim put.” Pita rətoti, muvehi pen səvənhi put. Nənə aɡelo rɨni pen tukwe in mə, “Arkahu ia səim karkahu əpwəmwɨs, mukurirə iou.” ");
INSERT INTO tnk_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pita rier irapw ia rum səvənhi mukurirə aɡelo nəha, mɨpkukurən mhə mə nəfe nəha aɡelo ramo irə ro nɨpərhienien, mətə rerɨn rɨrhi mə raməməkrəha. ");
INSERT INTO tnk_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Irau krouəpi raka iaruaɡən sə ramərer kupwən mamətui tɨ nərmama me mə riti trəpwəh napien, rouəpi raka mwi iaruaɡən sə resi pen, roueste təpinhə sampam kɨno ia aean. Nərmama me kamhəukurau irə mamhəuvən fwe taon. Təpinhə nəha rəsevər atukw a tɨ nirau i, nənə irau krouier irapw, rouevən roueste suatuk riti. Təkwtəkwuni a aɡelo rəpwəh Pita mamevən. ");
INSERT INTO tnk_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ia nəpɨn nəha Pita rətə mukurən nəfe kɨno min, mɨni mə, “Təkwtəkwuni nəha iakukurən mə nɨpərhienien. Iərɨmənu rərhi irapw pehe aɡelo səvənhi, muvehi raka iou ia rəɡi Herot mɨne ia narimnari me sə nəkur Isrel rerɨnraha ramrhi mə tuko ia nirak.” ");
INSERT INTO tnk_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nəpɨn Pita rukurən, revən ia nimwə səvəi Meri, mama səvəi Jon sə nəɡhɨn riti mwi nə Mak. Nərmama həpɨk hənousəsɨmwɨn raka irəha me fwe ikɨn, mamhəfwaki. ");
INSERT INTO tnk_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita revən mɨkunkun ia təpinhə ia kwəruə fwe iruə. Rota, pran riti sə ramasitu, mamo tukwini nari fwe ia nəkwai nimwə səvəi Meri, in rɨreɡi, mevən ipaka tɨ təpinhə mamətərɨɡ. ");
INSERT INTO tnk_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nəpɨn rɨreɡi reri Pita, rukurən mə Pita nəha. Nənə rerɨn raɡien pɨk. Rota rəpwəh nəsevərien ia təpinhə, mətə raiu a, mɨrərɨɡ, mevən fwe nəkwai nimwə, mɨni pen tɨ nirəha i mə, “Pita i ramərer iruə.” ");
INSERT INTO tnk_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Mɨreɡi irəha həni pen tukwe in mə, “Ikamenɨn.” Mətə Rota rɨni mə, “Rekəm, iakani pərhien.” Mɨreɡi həni mə, “Rosi aɡelo nəha səvənhi uə?” ");
INSERT INTO tnk_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Mətə Pita rakunkun ihi ia təpinhə. Nənə irəha həuvən, mhəsevər ia təpinhə. Nəpɨn hətoni Pita, nənimenraha rier. ");
INSERT INTO tnk_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ia nəpɨn nəha Pita ruvehi utə rəɡɨn mɨrɨpwi tete irəha mə tuhafafa. Kurirə irə rɨni irapw Iərɨmənu rɨnəfuvehi raka in ia kalapus, marə mɨni mwi mə, “Kɨmiaha tihaməkeikei mhəvisau pen narimnari me i m Jemes mɨne piəvtaha me.” Nənə Pita rier, mevən ia kwopun əpə riti. ");
INSERT INTO tnk_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kɨni rakwakwi irə, ia nəpnəpɨn, naruaɡən me fwe ia kalapus kamhəhekɨr, mhəreirei mə Pita ruvəku. ");
INSERT INTO tnk_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Nəpɨn Herot ramətui amasan Pita, mətoni mə riwən, rəres pen naruaɡən me səməme kamhərer tukuahaɡ nərmama me fwe ia kalapus mə Pita ruvəwəku, mətə irəha həreirei. Ro pen Herot rɨni nəkwan mə tukousi əpune irəha. Kurirə ikɨn in rier ia tənə Jutia, meiwaiu pen fwe taon nəha Sisaria, mamarə fwe ikɨn. ");
INSERT INTO tnk_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ia nəpɨn nəha Herot niemaha raməpi pɨk tɨ nəkur Taea mɨne Saeton. Ro pen nəkur asori me səvəi taon mi nəha housəsɨmwɨn irəha me ia kwopun kuatia. Irəha həkupwən mhətoni Plastus, iərmama riti sə ramətui tɨ nimwə asori səvəi Kiɡ Herot. Irəha həres pen in i mə trasitu ia nirəha. Nəpɨn hənəres raka nasituien səvənhi, irəha min həuvən mhətoni Herot, mhəres pen in mə trəmri nəmərinuien, tɨ nəri nə mə nəkur Taea mɨne Saeton haməkwməni nərmama me fwe ia tənə səvənraha ia nəveɡɨnien sə rautə ia tənə səvəi Herot i. ");
INSERT INTO tnk_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Nənə Herot rəmri nəpɨn riti səvənhi trəɡkiari irə. Ia nəpɨn nəha rarkahu tɨnari səvəi kiɡ, məkure ia kwopun raməkiri nəɡkiariien ikɨn, maməɡkiari mɨnraha. ");
INSERT INTO tnk_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Mɨreɡi irəha həkwein əpwəmwɨs mə, “Reri kumwesən riti nəha. Rɨpko mhə reri iərmama.” ");
INSERT INTO tnk_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Təkwtəkwuni a aɡelo riti səvəi Kumwesən rousi Herot, tɨ nəri nə mə Herot rɨpkuvehi utə mhə nəɡhi Kumwesən. Nənə irər me hani nəninhə irə, remhə. ");
INSERT INTO tnk_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ia nəpɨn nəha nəɡkiariien səvəi Kumwesən rauvirɨs mamevən. Nərmama həpɨk mwi həni nɨpərhienien irə. ");
INSERT INTO tnk_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Panapas mɨne Sol krɨno sampam ia wok sə kɨnərhi pen irau tukwe. Kurirə irə krouier ia Jerusalem, rourərɨɡ, rouevən fwe Antiok. Jon sə nəɡhɨn riti mwi nə Mak irəhar mɨnrau. ");
INSERT INTO tnk_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Nakalasia me fwe Antiok, nepwɨn profet me mɨne nepwɨn nahatən me: Panapas, mɨne Sol, mɨne Simeon (Simeon in iəmə pitəv), mɨne Lusias (iəmə Saerin), mɨne Manaen (in rɨməpwinari pəri irau Herot Antipas, iəmə asori sə ramərɨmənu ia tənə Kalili). ");
INSERT INTO tnk_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ia nəpɨn riti, irəha həpkani mhə nari, mamhəfwaki m Iərɨmənu. Nənə Nənɨmwɨn Ikinan rɨni pen tɨ nirəha i mə, “Tihəmri əpə Panapas mɨne Sol. Iakɨnəkwein irau mə trouwok riti səiou.” ");
INSERT INTO tnk_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ro iamɨnhi irə irəha həpwəh mwi naniien nari, mhəmrutə rəɡɨnraha ia nirau, mhəfwaki mɨnrau, mhərhi pen irau mə trouevən rouowok. ");
INSERT INTO tnk_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Nəpɨn Nənɨmwɨn Ikinan rɨnərhi pen raka Panapas mɨne Sol, irau kroueiwaiu pen fwe taon nəha Selusia. Ia kwopun nəha krouəputə ia nɨtətə riti rouevən fwe ia tənə əmwerɨs nəha Saepras. ");
INSERT INTO tnk_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Nəpɨn krouapirapw fwe taon nəha Salamis, krouevən rouni irapw nəɡkiariien amasan səvəi Kumwesən fwe ia nəkwai nimwəfwaki me səvəi nəkur Isrel. Jonmak ramarə irəhar mɨnrau, mamasitu ia nirau. ");
INSERT INTO tnk_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Irəhar harevən mharəpi sɨmwɨn ia tənə əmwerɨs nəha, mharier pen ia taon nəha Pafos. Ia kwopun nəha harətoni kleva riti nəɡhɨn nə Parjisas. In iəmə Isrel riti. Ramɨni mə in profet, mətə neikuəien. ");
INSERT INTO tnk_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Kleva nəha ramowok irau Sejas Polas, iəmə Rom riti sə ramərɨmənu ia tənə əmwerɨs nəha Saepras, mukurən mwi nari. Nəpɨn riti Sejas Polas rəkwein Panapas mɨne Sol, in rokeikei mə trɨreɡi nəɡkiariien səvəi Kumwesən. ");
INSERT INTO tnk_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Mətə Parjisas sə nəɡhɨn riti mwi mə Elimas (nɨpwrai nəhaɡ nəha kleva) in ramərai raka nəɡkiariien səvənrau, mamousari mə truvsini nətərɨɡien səvəi iəmə asori nəha mə trəpwəh nɨniien nɨpərhienien ia Iesu. ");
INSERT INTO tnk_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Mətə Sol (kani mwi in mə Pol) rerɨn ruvehe mukuər ia Nənɨmwɨn Ikinan. In rəti pen mətoni kleva nəha, ");
INSERT INTO tnk_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","mɨni mə, “Ik tɨni Setan. Ik iəmə ikəmwəki narimnari amasan me pam. Rerɨm rukuər ia neikuəien mɨne nɨfeifeiien ərəha me. Nəpɨn me pam ikamo suatuk atukwatukw səvəi Iərɨmənu, ramikou. ");
INSERT INTO tnk_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ətə ro! Təkwtəkwuni nəha rəɡi Iərɨmənu raməmak ia niram. Nənimem trɨfwə. Tikəpwəh mwi nətoniien nɨranien rəpwəmwɨs kwopti.” Təkwtəkwuni a nari riti rəmwhen nɨse napw rɨpitəv muvehe muveɡi nənimen. Parjisas raman, mamətui iərmama riti truvehi rəɡɨn miri in. ");
INSERT INTO tnk_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nəpɨn iəmə asori nəha Sejas rətoni, nənimen rier tɨ nəɡkiariien səvəi Iərɨmənu sə krɨnouahatən in irə. Nənə in rɨni nɨpərhienien irə. ");
INSERT INTO tnk_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ia nəpɨn nəha Pol mɨne in me nepwɨn həputə ia nɨtətə riti fwe Pafos, mhəier, mhəuvən fwe Peka, taon riti ia profens nəha Pamfilia. Ia kwopun nəha Jonmak rəpwəh irəha mɨrərɨɡ mevən fwe Jerusalem. ");
INSERT INTO tnk_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Irəha həier fwe Peka, mhavən, mhəuvən fwe taon nəha Antiok ia profens nəha Pisitia. Ia Sapat həuvnimwə ia nəkwai nimwəfwaki səvəi nəkur Isrel, mhəkure. ");
INSERT INTO tnk_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Iərmama riti rəvsini irapw nəɡkiariien me nepwɨn ia Loa səvəi Moses mɨne nəɡkiariien me nepwɨn ia nəkukuə me səvəi profet kupwən me. Nəpɨn iərmama nəha rəvsini pam, nəmə asori me səvəi nimwəfwaki nəha hərhi pen nəɡkiariien revən tɨ Pol mɨne in me nepwɨn mɨni mə, “Piəvmaha me, trɨni mɨnuə nəɡkiariien riti hiənuə tihəni irapw mhasitu ia nərmama, həni irapw.” ");
INSERT INTO tnk_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ro iamɨnhi irə Pol rɨskəmter, muvehi utə rəɡɨn, mɨni mə: “Kɨmiaha nəkur Isrel mɨne kɨmiaha rɨpko mhə kɨmiaha nəkur Isrel mətə hiaməsiai Kumwesən səkɨmaha. Kɨmiaha pam tihətərɨɡ iou. ");
INSERT INTO tnk_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Fwe kupwən Kumwesən səkɨmaha nəkur Isrel rɨnərpwi rəɡɨn ia kaha kupwən me səkɨmaha. Nəpɨn nəkwərhakwərha me səvənraha həuvən mamharə fwe ia tənə Ijip, ro irəha həuvehe mhəpɨk. Ia nɨskaiien səvənhi, in riri raka irəha. ");
INSERT INTO tnk_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ia nuk foti, in ramarə irəha mɨnraha fwe ia kwopun akwesakwes ikɨn. Irəha kamho noien ərəha, mətə in rɨpkəpwəh mhə irəha ");
INSERT INTO tnk_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kurirə irə in rousi əpune nərmama me nəha kamharə ia tənə Kenan. Nərmama me nəha haməuku pen ia kwənəkwus me irəha pam sefen. Nəpɨn Kumwesən rousi əpune irəha mo sampam, in ruvei pen tənə səvənraha m kaha kupwən me səkɨmaha. Nənə ro səvənraha i. ");
INSERT INTO tnk_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Narimnari me nəha ruvehi nuk me irəha pam ipaka tɨ fo hantret fifti mɨne. Kurirə ikɨn Kumwesən ruvehi utə nərmama me nəha kani irəha mə ‘Jaj me.’ Irəha həiri kaha kupwən me səkɨmaha, mhəuvehe mheste nəpɨn səvəi Samuel Profet. ");
INSERT INTO tnk_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ia nəpɨn nəha kaha kupwən me səkɨmaha həres pen Kumwesən mə ko rəseni kiɡ riti rərɨmənu ia nirəha. Nənə Kumwesən ruvei pen Sol, tɨni Kis, mɨnraha. Sol nə ruku pen ia kwənəkwus səvəi Penjamin. In ramərɨmənu ia nirəha meste nuk foti. ");
INSERT INTO tnk_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kurirə ikɨn Kumwesən ruvehi raka Sol nəha, nənə muvehi utə Tevɨt mə truvehe mo kiɡ səvənraha. Kumwesən rəɡkiari irə, mɨni mə, ‘Iakɨnətə raka mə Tevɨt, tɨni Jese, in iərmama riti sə rerɨk rokeikei. In tro pam nəfe iakɨni pen tukwe.’ ");
INSERT INTO tnk_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Rəmwhen mə Kumwesən rɨno raka promes kupwən mə tro, in rərhi pehe iərmama riti ia kwənəkwus səvəi Kiɡ Tevɨt mə truvehe muvehimɨru nəkur Isrel. Iərmama nəha Iesu. ");
INSERT INTO tnk_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ia nəpɨn nəha Iesu rəpwəh ihi noien wok səvənhi, Jon raməvisau irapw m nəkur Isrel me pam mə irəha tuhaməkeikei mhərərɨɡ ia noien ərəha me səvənraha, nənə mho paptaes. ");
INSERT INTO tnk_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nəpɨn Jon ruvehe ipaka tɨ noien sampam ia wok səvənhi, ramɨni mə, ‘Rerɨmiaha ramrhi iou mə iou sin? Rɨpko mhə iou iərmama sə hiameitenhi. Mətə tihətərɨɡ iou. Iərmama riti nəha rauvehe kurirə ia nirak. Iapkəmwhen mhə mə takɨfi raka put ia nɨsun.’ ");
INSERT INTO tnk_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Nərman, piak me, kɨtaha səməme səməuku pen ia kwənəkwus səvəi Epraham, mɨne kɨmiaha iesa rɨpko mhə kɨmiaha nəkur Isrel, mətə hiaməsiai Kumwesən səkɨmaha, tukutaha i, Kumwesən rərhi pehe nəɡkiariien i sə rauvehimɨru nərmama. ");
INSERT INTO tnk_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Nəpɨn Iesu ruvehe, nərmama səməme kamharə fwe Jerusalem mɨne nəmə asori me səvənraha həpkətə sas mhə in, mhəreirei mwi nɨpwrai nəɡkiariien səvəi profet kupwən me kaməvisau irapw ia Sapat me pam. Ro iamɨnhi irə irəha ho nəɡkiariien me nəha həuvehe mhəukuə. Həkiri Iesu mə traməkeikei memhə. ");
INSERT INTO tnk_vpl VALUES ("AC13_28","074_13_28","ACT","13",