﻿USE sofia;
DROP TABLE IF EXISTS sofia.tnc_vpl;
CREATE TABLE tnc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tnc_vpl WRITE;
INSERT INTO tnc_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ikuᵽaka sime Jesús, Jã'merũkika Tuᵽarãte wã'maekaki majaroka. Tuᵽarã Maki kime. Ã'mitirikõrĩ je'e: jiitakaja ima sime kimajaroka. ");
INSERT INTO tnc_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ikuᵽakaja simaroyireka're ãrĩwa'ri Tuᵽarãro'si bojaĩjirimaji Isaías wãmeiki imaekakite o'oeka, Tuᵽarãte Kimakire jaika mirãka: “Miruᵽubaji aᵽika yirika bojarimajire yiᵽũatarãñu. Suᵽa imarĩ meyarũki ruᵽu yirika bojaweirimaji kimarãñu, ba'iaja nabaaika naja'ataokaro'si. ");
INSERT INTO tnc_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ᵽo'imajamatorã kimarãñurõ'õrã kire ã'mitirirĩ etarãñurãte jãjirokaᵽi ikuᵽaka kẽrĩrãñu: ‘Imatikaja, suᵽabatirã jia ᵽuᵽajoaekaja mija imabe, Maiᵽamakire ikuᵽarõ'õᵽiji etarãka simamaka. Ba'iaja baabekaja jia oyiaja ᵽuᵽajoabaraka mija imabe’, kẽrĩrãñu, Tuᵽarãte ãrĩka”, ãrĩwa'ri Isaías imaroyirekakite o'oeka. Juanre baarũkia ᵽuᵽajoaweibaraka i'suᵽaka Isaías imaroyikakite o'oeka. ");
INSERT INTO tnc_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","I'suᵽaka kio'oeka be'erõ'õ, ñoaka sajaritikarã Juanre etaeka ᵽo'imajare imaberikarõ'õrã. Suᵽa imarĩ, ᵽo'imajare ruᵽuko'a jũjebaraka, ikuᵽaka nare kijaika: “Ba'iaja mija baaika ja'atatirã Tuᵽarãrika bojariroka ãñu uᵽakaja mija baabe. I'suᵽaka mija baamaka ĩawa'ri, ba'iaja mija baakoᵽeikareka ye'kariabaraka Tuᵽarãte mijare wayuĩarãñu. I'suᵽaka mija baarãka be'erõ'õᵽi ruᵽuko'a mija jũjerũjebe”, Juanre nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Rĩkimarãja Judeakarã, suᵽabatirã Jerusalénkarãoka ᵽo'imajare kiᵽõ'irã etarijarika kire ã'mitiyaokaro'si. I'suᵽaka netamaka ritaja ᵽo'imajare imaeka wãjitãji, “Ikuᵽaka ba'iaja baaiki ñime”, ãrĩwa'ri Tuᵽarãte nabojaroyika be'erõ'õᵽi Jordán wãmeiriarã Juanre nare ruᵽuko'a jũjeroyika. ");
INSERT INTO tnc_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ruᵽuko'a nare jũjerimaji camello ᵽoyaᵽi kĩkeka jariroiki kimaeka. Suᵽabatirã wa'ibikirãwẽko ajeakaka kiwa'eyoka imaeka. I'suᵽakajaoka ẽorã ñimia, mumiokoaᵽitiyika ba'arijayuka kimaeka. ");
INSERT INTO tnc_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","8","—Yibe'erõ'õᵽi ᵽuri aᵽika etarãki. Yi'i ᵽuri, i'suᵽakamarĩka ñime. Yire tẽrĩwa'ribaji õñuka kimamaka, yi'i ᵽuri marãkã'ã baatirã kiũ'ᵽuko'a kuterã yuruᵽaberijĩki ñime. Tuᵽarãte mija ã'mitiriᵽẽamaka ĩawa'ri, okoaᵽitakaja mijare ruᵽuko'a yijũjeyu. Yibe'erõ'õᵽi etarãki ᵽuri Esᵽíritu Santo mijare ña'ajããrãki. I'suᵽaka mijare kibaarãka simamaka, Tuᵽarãte yaᵽaika uᵽakaja jia baarijayurã mija imarãñu,— ãᵽaraka Juanre nare wãrõroyika. ");
INSERT INTO tnc_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","I'sia ᵽoto Galilea ka'iaᵽi Nazaret wãmeika imaekarõ'õrã Jesúre a'rika. Toᵽi a'ririjari Juan ᵽõ'irã keyaeka. Torã keyaeka ᵽoto Jordán wãmeiriarã ruᵽuko'a Juanre kire jũjeka. ");
INSERT INTO tnc_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Riakaᵽi Jesúre marĩrĩkaekarõ'õjĩte wejeᵽemarã yu'awa'ri, kĩaeka ᵽoto, wejeᵽema wiritaeka. I'suᵽaka sabaaeka ᵽoto okoiᵽakoa uᵽaka imaekarã ña'rĩjãitirã Esᵽíritu Santore kireka ña'rĩro'ika. ");
INSERT INTO tnc_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","I'suᵽaka sabaaeka be'erõ'õjĩte wejeᵽemarõ'õᵽi, ikuᵽaka Tuᵽarãte ãrĩka: —Mi'i imaki Yimaki wãtaka ñoñuka. Jia jĩjimaka ñime mika,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Toᵽi mae ᵽo'imajamatorã Jesúre ke'ewa'rika Esᵽíritu Santo. ");
INSERT INTO tnc_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","I'suᵽaka kire kibaaeka ᵽoto ĩ'ᵽarã ᵽo'imajarakarĩmi Jesúre torã imataᵽaeka. Torã kimaeka ᵽoto, “¿Yaje ritaitaka Tuᵽarãte takaja yi'yuka kime?”, ãrĩwa'ri kire korirĩ Satanáre kiᵽõ'irã ᵽemakotowirika. I'suᵽaka kire kibaako'omakaja ba'iaja baaberikaki Jesús. Suᵽabatirãoka ᵽo'imajamato imaekarõ'õ simamaka, werika wa'iro'sitakaja imaekarõ'õ simako'omakaja ángelrãkare kire ĩarĩrĩroyika. ");
INSERT INTO tnc_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juanre wẽkomaka imariwi'iarã Herodete tarũjeka be'erõ'õ Galilearã Jesúre a'rika. Torã keyaeka ᵽoto, “Ikuᵽaka Tuᵽarãrika bojariroka ima”, ãrĩwa'ri ᵽo'imajare kiwãrõeka. ");
INSERT INTO tnc_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Torãjĩrã mae, —Mae sarã seyarũkia, koyiaja sajariwa'yu, mamarokaᵽi Tuᵽarãte ᵽo'imajare jã'meũ'murũkia. I'suᵽaka simamaka ba'iaja mija baaika i'yoᵽiᵽaraka saja'atatirã, Tuᵽarãrika bojariroka takaja mija ã'mitiriᵽẽabe kirirã mija imaokaro'si,— ãrĩwa'ri nare kiwãrõeka. ");
INSERT INTO tnc_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","I'tojĩrã mae, Galilea ᵽa'warijeᵽi a'ririjaᵽaraka, Simón, suᵽabatirã kibe'erõ'õkaki Andrés wa'ibaarimaja imaekarãte Jesúre ĩatõᵽoeka. I'suᵽakaja ᵽa'warã wãᵽua taabaraka nimaekarõ'õrã naᵽõ'irã keyaeka. ");
INSERT INTO tnc_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Naᵽõ'irã eyatirã, —Dajoa yika. Wa'ibaarimaja imariᵽotojo, mae ᵽuri yire ã'mitiriᵽẽawa'ri, ᵽo'imajare yiro'si rẽarimaja mijare ñimarũjerãñu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","I'suᵽaka nare kẽrĩka ᵽotojo sarãja nawãᵽua yiatatirã kika na'rika. ");
INSERT INTO tnc_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Toᵽi ate sa'riwa'ribaji a'ririjaᵽaraka, Santiago, kibe'erõ'õkaki Juanka nimaeka ᵽoto Jesúre nare ĩatõᵽoeka. Ĩ'rã ĩ'ᵽarã nimaeka Zebedeo makarã. Kũmuarã wãᵽua jiebaraka nimaeka. ");
INSERT INTO tnc_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","I'suᵽaka imaekarãte ĩatõᵽotirã nare kiakaeka. I'suᵽaka nare kẽᵽakã'ã kika na'rika naro'si mae. I'suᵽaka simamaka nakũmuarã naᵽaki Zebedeore tuika, kire jeyobaarimajaᵽitiyika. ");
INSERT INTO tnc_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Galilea ᵽa'warõ'õᵽi a'ritirã Caᵽernaúm wejearã kika wãrũrimajaᵽitiyika Jesúre eyaeka. Judíotatarãte jẽrĩtaroyikarĩmi simaeka ᵽoto narẽrĩriwi'iarã Jesúre kãkaeka. Torã kãkatirã mae ᵽo'imajare kiwãrõũ'mueka. ");
INSERT INTO tnc_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tuᵽarãte kire ãrĩrijayu uᵽakaja jia nare kiwãrõeka ã'mitiritirã, “Kiwãrõika uᵽaka wãrõirãte ã'mitirikoribeyurã yija ime. Jia wãjitãji ᵽuᵽajoaiki imarĩ tẽrĩtaka wãrõrimaji kime”, narĩᵽuᵽajoaeka. ");
INSERT INTO tnc_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","I'suᵽaka nimaekarõ'õrã ĩ'rĩka Satanárika ima ña'rĩjãikakite imaeka. —Jesús, Nazaretkaki, ¿dakoa oka mika yijareka imamaka, yijare mijo'ayu? ¿Koᵽakaja yijare riatatiyarĩji mi'tayu bai je'e? Mire ñiawãrũyu, Tuᵽarãte ᵽũataekaki mima imarĩ, ba'iaja baakoribeyuka mime,— Jesúre kẽrĩka akaserebaraka. ");
INSERT INTO tnc_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","I'suᵽaka kẽᵽakã'ã, —Mijaia'si. Kire mija'atabe,— Jesúre kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","I'tojĩte mae ᵽo'imajire taratatirã jãjia akasererikaᵽi ikiᵽi Satanárika kireka ima ᵽorika. ");
INSERT INTO tnc_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","I'suᵽaka ima ĩakoriberikarã imarĩ, ritaja torã imaekarãte marãkã'ã baawãrũberijĩka najarika. I'suᵽaka imawa'ri, natiyiaja ikuᵽaka narĩbu'aeka: —¿Marãkã'ã kibaayu? Mamaka wãrõrimiji simarijiyu. I'suᵽakajaoka kijã'meika uᵽakaja Satanárika ima ᵽariji kire yi'yua,— ᵽo'imajare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","I'suᵽaka kibaaekarõ'õjĩte ritaja Galilea ka'iakarãre sõrĩᵽataeka. ");
INSERT INTO tnc_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","I'suᵽaka baaweatirã Jesúre ᵽoriwa'rika narẽrĩriwi'iareka kimaekarõ'õᵽi. Santiago, Juan Jesúka a'rikarã Simón, Andréka ĩ'ᵽarãrika wi'iarã. ");
INSERT INTO tnc_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Torã neyaeka ᵽoto ikuᵽaka Jesúre narĩka: —Simón mañeko wãmarĩtaka imako. Suᵽa imarĩ koᵽeyurũkiareka takaja ᵽeyuko koime,— narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Toᵽi koᵽõ'irã eyatirã koᵽitakarã ñi'atirã kore kibaimi'mataeka. I'suᵽaka kore kibaaeka ᵽotojo wãmarĩa koimakoᵽeka koreka o'rika. I'suᵽaka jariwa'ri, nare ba'ariji'abaraka koimaeka mae. ");
INSERT INTO tnc_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","I'sirĩmi aiyate ka'raeka be'erõ'õ rĩkimarãja jĩñurã, Satanárika ima ña'rĩjãikarãteoka Jesús ᵽõ'irã ne'eeyaeka. ");
INSERT INTO tnc_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nimauᵽatiji i'sia wejeakarã rẽrĩkarã kimaeka wi'ikoᵽerekarã. ");
INSERT INTO tnc_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","I'suᵽaka nabaamaka, ritajakaka risirika nareka imaekarãte kijieka. Suᵽabatirãoka Satanárika ima ña'rĩjãikarãte jiebaraka, “Tuᵽarã Maki mime”, kire ãrĩwãrũrũkirã nimako'omakaja, sakijairũjeberika. ");
INSERT INTO tnc_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Toᵽi ate, bikitojo ñamiji ᵽo'imajamatorã Jesúre a'rika, Tuᵽarãka jairĩ. ");
INSERT INTO tnc_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","I'suᵽaka baarĩ ke'rika be'erõ'õ kimabeᵽakã'ã ĩawa'ri, Simón kijeyomarãᵽitiyika kire mo'arĩ na'rika. ");
INSERT INTO tnc_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Suᵽa imarĩ, kimaekarõ'õrã eyatirã, —Ritaja ᵽo'imajare mire mo'ayuma,— kire narĩeyaeka. ");
INSERT INTO tnc_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","I'suᵽaka kire narĩko'omakaja ikuᵽaka nare kiyi'rika: —Dajoa, aᵽewejearã Tuᵽarãrika mabojataᵽarĩ, i'suᵽakaro'siji yi'taeka simamaka,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","I'suᵽaka nare kẽrĩka be'erõ'õᵽi Galileaka'ia ritatojo kijeyomarãᵽitiyika kituritaᵽaeka mae. I'suᵽaka tuᵽaraka torã narẽrĩriwi'ia imaekarõ'õrã rakakaja kiwãrõroyika. I'suᵽaka baataᵽabaraka Satanárika ima ña'rĩjãikarãteoka kijieka. ");
INSERT INTO tnc_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","I'suᵽaka turitaᵽabaraka kimaeka ᵽoto kiᵽo'iarã kãmia ᵽo'ijirikakite Jesús ᵽõ'irã etaeka. Kiᵽõ'irã etatirã, kiwãjitãji kiñukuruᵽaeka kire jiyiᵽuᵽayeewa'ri. I'suᵽaka baatirã ikuᵽaka kire kẽrĩka: —Yire mijieriyaᵽaye'e, yire mijiebe.— ");
INSERT INTO tnc_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","I'suᵽaka kẽᵽakã'ã, Jesúre kire wayuĩaeka mae. Suᵽa imarĩ kire rabetirã ikuᵽaka kire kẽrĩka: —Ã'ã yiyaᵽaika sime. I'suᵽaka simamaka jia mijaᵽe mae,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","I'suᵽaka kire kẽrĩkarõ'õjĩteje kãmia kireka imakoᵽeka yayaeka. ");
INSERT INTO tnc_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","I'suᵽaka imakoᵽekakite a'rirã baaeka ruᵽu ikuᵽaka Jesúre kire ãrĩka: —Mia'mitiᵽe. Mire yibayaika majaroka ritaja ᵽo'imajare bojaᵽibabekaja, wãrũaja a'ritirã miᵽo'ia mibeaᵽe kurarãkakakite. Kire samibeawearãka ᵽoto Moisés imaekakite nare jã'meroyika uᵽakaja mibaabe. I'suᵽakajaoka jia miᵽo'ia jayua imarĩ, jĩjimaka imawa'ri ĩ'ᵽarã wĩ'ñaka wẽkoakaka Tuᵽarãro'si kurare joeĩjirã kire mijibe. I'suᵽaka kibaarãka be'erõ'õᵽi, “Kãmika rataki imakoᵽeroyiraᵽakiji jia kiᵽo'ia jayu mae”, ᵽo'imajare mireka ãrĩwãrũrãñu,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","I'suᵽaka kire kẽrĩko'omakaja ritaja ᵽo'imajare sakibojaᵽibaᵽataeka. I'suᵽaka kẽñua ã'mitiritirã, Jesús ᵽõ'irã rĩkimarãja ᵽo'imajare rẽrĩka kire ĩarika yaᵽawa'ri. I'suᵽaka nimaeka simamaka, wejeñe'metãjirã ᵽuri kituriberiroyika. I'suᵽaka simako'omakaja rĩkimarã ᵽo'imajare imabeyurõ'õrã ᵽuri kituritaᵽaroyika. I'suᵽaka kimaroyika simako'omakaja ritaja wejeakarã rĩkimarãja ᵽo'imajare kiᵽõ'irã etaeka. ");
INSERT INTO tnc_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","2","I'suᵽaka ñoaᵽañaka kimataᵽaeka be'erõ'õ, Caᵽernaúm wejearã Jesúre ᵽe'rietaeka ate. I'suᵽaka simamaka ã'mitiritirã, rĩkimarãja ᵽo'imajare kiᵽõ'irã rẽrĩka mae. I'suᵽaka baawa'ri wi'ia ᵽurutẽrĩbakarãja nimaeka. I'suᵽakajaoka simaeka ᵽẽteᵽẽ'rõtoᵽioka koᵽereka wã'ta. I'suᵽaka nimamaka nare kiwãrõeka mae. ");
INSERT INTO tnc_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","I'suᵽaka baabaraka kimaeka ᵽoto botarakamarãre kiᵽõ'irã etaeka. Ritaja kiᵽo'ia rĩ'meᵽatabeyukate kiᵽeyurũki ᵽemaᵽi ne'era'aeka. ");
INSERT INTO tnc_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Rĩkimarãja ᵽo'imajare imaeka imarĩ marãkã'ã baatirã kãkawãrũberiwa'ri, wi'iᵽema ĩ'rãtiji imaekarõ'õrã kire ne'emirĩwa'rika. Toᵽi mae, Jesúre imaeka ko'aᵽito wi'iruᵽututua naᵽoaeka. I'suᵽaka baatirã kiᵽeyurũkiaᵽi Jesús ᵽõ'irã kire naja'aruetaeka. ");
INSERT INTO tnc_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","“Jia yire yi'riwa'ri, i'suᵽaka nabaayu”, nareka kẽrĩᵽuᵽajoaeka. I'suᵽaka ᵽuᵽajoabaraka, —Yijeyomaki, mae ba'iaja mibaaikareka mireka sayijieyu,— ritaja kiᵽo'ia rĩ'meᵽatabeyukate kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","I'suᵽaka kire kẽrĩka ᵽoto, ikuᵽaka ᵽuᵽajoabaraka Moiséte jã'meka wãrõrimajare ruᵽajiyeka: “¿Dako baaerã i'suᵽakataka ĩ'ĩre jaiyu je'e? I'suᵽaka ãᵽaraka ‘Tuᵽarã uᵽakatakaja ñime’, kiõrĩkoᵽeyu ruku bai je'e. Tuᵽarã ĩ'rĩkaja imaki ba'iaja mabaaika jũjewãrũrimaji”, narĩᵽuᵽajoaeka. ");
INSERT INTO tnc_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","I'suᵽaka ᵽuᵽajoabaraka nimaeka Jesúre õrĩwãrũeka. —¿Dako baaerã suᵽa mija ᵽuᵽajoayu? ");
INSERT INTO tnc_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","¿Diroka kire ñarĩjĩkareka jia mija ᵽuᵽarijĩñu ruku? “Ba'iaja mibaaikareka jia mijayu mae”, kire ñarĩjĩka, “¿Yaje rita kire kẽrĩtiyayu?”, ni'ioka ãrĩwãrũberijĩka sime. “Mi'mitirã, miᵽeyurũkia me'ewa'ᵽe”, kire ñarĩjĩka ᵽuri ñañu uᵽakaja simamaka ĩatirã “Rita kẽñu”, yireka mija ãrĩrãñu. Ᵽo'imaja Ma'mi ñimamaka, Tuᵽarãte yire ᵽũataeka ika ka'iareka ba'iaja ᵽo'imajare baaika yijũjeokaro'si. Suᵽa imarĩ “Rita, i'suᵽaka kibaaokaro'si Tuᵽarãja kire jã'meiki”, yireka mija ãrĩwãrũerã, ikuᵽaka mijare yibeaerã baayu,— nare kẽrĩka. Torãjĩrã mae, ritaja kiᵽo'ia rĩ'meᵽatabeyuka imaekakite ikuᵽaka kẽrĩka: ");
INSERT INTO tnc_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Mi'mirĩkatirã miᵽeyurũkia me'eᵽe'riwa'ᵽe miwi'iarã,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Suᵽa kẽrĩka ᵽotojo kimi'mirĩkaeka. Ᵽo'imajare rĩkimarãja ĩaeka wãjitãji mi'mirĩkatirã, kiᵽeyurũkiaᵽitiyika kiᵽoriwa'rika. I'suᵽaka nare kibaabeamaka ĩatirã ritaja torã imaekarã ᵽo'imajare jĩjimaka jarika. Suᵽa imarĩ Tuᵽarãreka jia ᵽuᵽajoawa'ri ikuᵽaka narĩka: —Jiitakaja Tuᵽarãte baaika maekaka ᵽuri samaiyu. Ikuᵽaka kibaaika ĩakoribeyurã maimaroyiraᵽe ruᵽu,— narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Torãjĩrã ate, Jesúre ᵽa'warijerã a'rika. Rĩkimarãja ᵽo'imajare kiᵽõ'irã etamaka, Tuᵽarãrika nare kiwãrõeka. ");
INSERT INTO tnc_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Suᵽa nare baaweatirã, toᵽi o'riwa'rikõrĩ Leví, Alfeo makire kĩatõᵽoeka. Romatatarã ĩᵽarimarãro'si niñerũ jẽñeĩjirũkirõ'õrã ruᵽaki. Naro'si i'suᵽaka baarimaji imarĩ, ritaja ᵽo'imajare imᵽuesto kĩjirũjerijarika. Kire ĩatõᵽotirã ikuᵽaka Jesúre ãrĩka: —Dajoa yika.— I'suᵽaka kẽᵽakã'ã ã'mitiritirã, Levíre Jesúka a'rika mae. ");
INSERT INTO tnc_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kika ke'rika simamaka kiwi'iarã eyatirã Jesúre kika ba'aeka. I'suᵽakajaoka rĩkimarãja Romawejeakarã ĩᵽarimarãro'si nañu uᵽakaja waᵽa jẽñeĩjirimajare, suᵽabatirã aᵽerã “Ba'iaja baarimaja nime”, ᵽo'imajare ãrĩroyikarã ᵽariji Jesúka ba'aekarã. I'suᵽaka nabaaeka kire ã'mitiriᵽẽairã jariwa'ri. Suᵽabatirã kika wãrũrimajaoka imaekarã naka. ");
INSERT INTO tnc_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jesúre i'suᵽaka baabaraka imaeka ᵽoto fariseokaka ᵽuᵽajoairã imariᵽotojo, Moiséte jã'meka wãrõrimajare nare ĩaeka. Nare ĩatirã, ba'iaja baarimajaka imarika yaᵽabeyurã imarĩ, Jesúka wãrũrimajare ikuᵽaka narĩka: —¿Dako baaerã ba'iratarãka mijare wãrõrimajire ba'ayu?— narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","I'suᵽaka naᵽakã'ã ã'mitiritirã, ikuᵽaka Jesúre nare yi'rika: —Jia dako risiriji'yumarĩaja imarã ᵽuri ĩkobaarimajire yaᵽabeyurã. Wãmarĩa imarã ᵽuri ĩkobaarimajire nare ĩkobaarika yaᵽairã. I'suᵽakaoka sime yiro'si. “Ba'iaja baabeyurã yija ime”, ãñurãte jeyobaaokaro'simarĩa yi'taeka. “Ba'iaja yija baarijayuareka i'yoa yija ime”, ãñurãte ba'iaja baaika naja'ataokaro'si yi'taeka. I'suᵽaka simamaka naka ñimarijayu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ĩ'rãkuri, Juan ruᵽuko'a jũjerimajika wãrũrimaja, suᵽabatirã fariseokaka ᵽuᵽajoairã ĩ'rãrĩmi Tuᵽarãte takaja ᵽuᵽajoabaraka ba'abekaja imaroyikarã. I'suᵽaka nimarijayua ĩairã imarĩ, ikuᵽaka Jesúre najẽrĩaeka ĩ'rãrimarã: —Juanre wãrũekarã Tuᵽarãte takaja ᵽuᵽajoabaraka nimarĩmi ba'abeyurã. I'suᵽakajaoka fariseokaka ᵽuᵽajoairãte ime. ¿Dako baaerã mika wãrũirã ᵽuri i'suᵽaka baabeyurã je'e?— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","I'suᵽaka naᵽakã'ã ikuᵽaka nare kẽrĩka: —Ikuᵽaka sime. Naᵽitañi'aika niaerã no'yibojairã ᵽuri sĩawa'ri jĩjimaka imarã. Kika nimarõ'õjĩte takaja jĩjimakaᵽi kika naba'ayu ruᵽu. I'suᵽakajaoka imarã nime yika wãrũrimaja. Yika wãrũbaraka nima ᵽototakaja jĩjimaka ba'abaraka nime ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Yire nañi'arãñurĩmi ᵽuri, yika nimabesarãka simamaka, ba'iaja ᵽuᵽayurã nima imarĩ, ba'abekaja nimarãñu. ");
INSERT INTO tnc_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Aᵽeroka ã'mitirikõrĩ je'e: Saya bikijakaka, mamakaᵽi maᵽãijĩ'aberijĩka. Mamaᵽãiᵽi samaᵽãijĩ'ajĩka, samajũjeika ᵽoto, baie'ewa'ri bikijakato beriwa'ri jã'rĩbaji sajarijĩka simamaka. Ikuᵽaka ãrĩrikoᵽakaja sime saya bikijakakaᵽi mijare yibojawãrõika: Mamakukukaka majaroka mijare yiwãrõika mamarĩ imara'aekakuku ᵽitiyika mija ᵽuᵽajoarukea'si. ");
INSERT INTO tnc_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ã'mitirikõrĩ je'e: Iyaokoa mamaka ima wa'ibikirãwẽko ajea bikijaka baaeka wajorã maᵽaaberijĩka. Bikijaka wajorã samaᵽaamaka berijĩka simamaka. I'suᵽaka simako'omakaja i'suᵽakarãja samaᵽaajĩka, sarãja saririjĩñu. I'suᵽaka simamaka, mamaka ima iyaokoa wa'ibikirãwẽko ajeakaka baaeka mamawajorã samaᵽaajĩkareka jia simajĩñu. Ã'mitirikõrĩ je'e: mamakukukaka majaroka mijare yiwãrõika ã'mitiriᵽẽatirã, bikija mamarĩ mija baaroyika uᵽakatakaja baabekaja mija imabe,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Judíotatarãte jẽrĩtaroyikarĩmi rioa imaekarõ'õᵽi Jesúre tẽrĩo'rika kika imaekarãka. Torã a'ririjaᵽaraka kika wãrũrimajare õterikia e'etirã naba'aeka. ");
INSERT INTO tnc_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","I'suᵽaka sanaba'amaka ĩatirã, fariseokaka ᵽuᵽajoairã ikuᵽaka Jesúre najẽrĩaeka: —Yaje. Jẽrĩtarirĩmi ba'iraberika imabeyua. Mika wãrũrimaja õterikia e'etirã naba'aika, ba'irabeirã uᵽaka nabaayu. Irĩmi i'suᵽaka baarika jãjika maro'si sime,— fariseokaka ᵽuᵽajoairãte ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","I'suᵽaka kire narĩko'omakaja ikuᵽaka nare kiyi'rika: —Davidka imaroyikarã ba'arika naro'si imabeᵽakã'ã kẽsia imawa'ri, marãkã'ã nabaaeka ¿yaje mija õñu je'e? ");
INSERT INTO tnc_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ã'mitirikõrĩ je'e: Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'ia ajeakaka baaeka imaroyika ᵽoto, kurarãka ĩᵽamaki imatiyaiki Abiata wãmeiki kimaeka. Kẽsirabawa'ri Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã kãkatirã ᵽan imatiyaika Tuᵽarãte jia baawa'ri naᵽããroyikakaka Davidre ba'aeka. Moisés imaroyikaki kurarãka imarãtakaja “Sanaba'arũ”, kẽrĩka simako'omakaja i'suᵽaka kibaaeka. Sakiba'aeka ᵽoto kijeyomarãteoka Davidre saji'aeka. I'suᵽaka nare kiruᵽutamaka ĩatirã, Tuᵽarãte kire boebariberika,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","I'suᵽaka nare ãrĩweatirã, ikuᵽaka Jesúre nare ãrĩka ate: —Jia ᵽo'imajaro'si simaerã Tuᵽarãte jẽrĩtarirĩmi baaeka. “Jẽrĩtarirĩmi nimarũkiakaka takaja yi'ᵽaraka ᵽo'imajare imarãñu”, ãrĩwa'rimarĩa Tuᵽarãte nare ᵽo'ijiaeka. ");
INSERT INTO tnc_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Suᵽa imarĩ Ᵽo'imaja Ma'mi ñimamaka, jẽrĩtarirĩmi imarikakaka Tuᵽarãte yire jã'mewãrũrũjeka. I'suᵽaka ñima simamaka, “Ikuᵽaka irĩmi mija baabe, ika ᵽuri jiamarĩa ima”, ãrĩwãrũiki ñime,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","I'sia be'erõ'õ narẽrĩriwi'iarã Jesúre kãkaeka ate. Torã ĩ'rĩka kiᵽitaka baikõkotaekakite imaeka. ");
INSERT INTO tnc_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jesúre torã kãkamaka ĩatirã ikuᵽaka fariseokaka ᵽuᵽajoairãte ikuᵽaka ᵽuᵽajoaeka: “Jẽrĩtarirĩmi ba'irabebeyurã maima simako'omakaja, ¿kiᵽitaka baikõkotaekakite Jesúre jierãñu ruku?”, kireka narĩᵽuᵽajoaeka. “I'sirĩmi i'suᵽaka kibaarãkareka, kire mokabaarãñu. ‘Tuᵽarãte Moisés imaekakite o'orũjeka yi'riberiwa'ri ba'iaja kibaayu’, marĩrãñu”, narĩᵽuᵽajoaeka. ");
INSERT INTO tnc_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","I'suᵽaka naᵽuᵽajoako'omakaja ikuᵽaka Jesúre ãrĩka kiᵽitaka baikõkotaekakite: —Ᵽo'imaja wãjitãji mimi'mirĩkabe.— ");
INSERT INTO tnc_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","I'suᵽaka kire ãrĩweatirã, ikuᵽaka Jesúre ãrĩka torã imaekarãte: —¿Marãkã'ã jẽrĩtarirĩmi nimarijarirũ ãrĩwa'ri Tuᵽarãte i'sirĩmi maro'si ᵽo'ijiaeka je'e? ¿Jía, ba'ia, suᵽabatirã ᵽo'imajare tããrika, nare jããrika, diba'i jiibaji ima je'e?— nare kẽrĩka. I'suᵽaka nare kẽrĩko'omakaja okamarĩaja kire na'mitirika. ");
INSERT INTO tnc_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","I'suᵽaka nimamaka boebakaᵽi nare ĩabaraka, ba'iaja kiᵽuᵽarika simauᵽakaja kiᵽitaka baikõkotaekakite nawayuĩabeᵽakã'ã. I'suᵽaka imariᵽotojo mae ikuᵽaka kire kẽrĩka: —Miᵽitaka mitĩᵽatabe.— I'suᵽaka kire kẽrĩka ᵽotojo kiᵽitaka tĩᵽatatirã jia kijarika mae. ");
INSERT INTO tnc_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","I'sia kibaamaka ĩatirã fariseokaka ᵽuᵽajoairãte ᵽoriwa'rika Herodes ᵽo'imajaᵽitiyika jaiokaro'si. “¿Marãkã'ã baatirã Jesúre majããjĩñu?”, ãrĩokaika naka najaibu'aeka. ");
INSERT INTO tnc_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","I'sia be'erõ'õ kimaekarõ'õᵽi ᵽoriwa'ritirã Galilea ᵽa'warijerã Jesúre a'rika kika wãrũrimajaᵽitiyika. Torã ke'rika ᵽoto tokarã ᵽariji rĩkimarãja ᵽo'imajare kika a'rika. ");
INSERT INTO tnc_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Torãjĩrã mae, “Jiitaka Jesúre baabearijayu”, ᵽo'imajare ãᵽakã'ã ã'mitiriwa'ri, rĩkimarãja ᵽo'imajare kiᵽõ'irã etaeka. Judea, Jerusalén, Idumea, Jordánria i'siᵽẽ'rõtorã, Tiro suᵽabatirã Sidónkarã nimaeka. I'siaraka wejekarã ñoakurirã imarã imariᵽotojo kire ĩarĩ netaeka. ");
INSERT INTO tnc_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","I'suᵽaka netaeka imarĩ, rĩkimarãja jĩñurãte tããrijayuka kimamaka, “Kire yija rabejĩkareka, jia yija jarijĩñu”, ãrĩᵽuᵽajoawa'ri kire naraberiyaᵽaeka. I'suᵽaka simamaka kika wãrũrimajare ikuᵽakã'ã kẽrĩka: “Kũmua mija mo'abe, ᵽo'imajare rĩkimarãja yire rabewã'imarĩrijitoika simamaka. Yire natẽrĩtajĩkareka kũmuarã yijãijĩñu”, nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Suᵽabatirã Jesúre ĩatirã Satanárika ima ña'rĩjãikarã ĩ'rĩka uᵽakaja kiwãjitãji ñukuruᵽatirã ikuᵽaka nakasereroyika: —Tuᵽarã Makitakiji mime,— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","I'suᵽaka naᵽakã'ã, —Ᵽo'imajare samija bojaᵽiba'si,— jãjirokaᵽi nare kẽrĩroyika. ");
INSERT INTO tnc_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","15","I'sia be'erõ'õ ĩmimaᵽemarã mirĩwa'rirã kibaaeka ᵽoto, kire jiyuekarakamakire kiakaeka. Ĩmimaᵽemarã kika neyaeka ᵽoto ĩ'ᵽoũ'ᵽuarãe'earirakamarãre kiwã'maeka kijeyomarãro'si. I'suᵽaka nare baatirã, “Yirika ᵽo'imajare wãrõtaᵽarĩ mijare yiᵽũatarãñu. Suᵽabatirã Satanárika ima ña'rĩjãirãte ᵽo'imajareka ‘Mija ᵽoᵽe’, mija ãrĩrãka uᵽakaja naᵽorirãñu”, nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ĩ'ᵽoũ'ᵽuarãe'earirakamarã kiwã'maekarã ikuᵽaka nawãmea imaeka: Simón wãmeikiteje ĩ'ᵽaroka wãmeiki kimarika yaᵽawa'ri, Ᵽedro Jesúre kire wãmejĩ'aeka. ");
INSERT INTO tnc_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Aᵽerã kijeyomarã wãmea ikuᵽaka imaeka: Santiago, kibe'erõ'õkaki Juanᵽitiyika, Zebedeo makarã nimaeka. Ĩ'rã ĩ'ᵽarãte Boanerges Jesúre wãmeyeeka. Nokaᵽi samarĩjĩkareka, “Wĩᵽo makarã”, ãrĩrika simaeka. ");
INSERT INTO tnc_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Aᵽerã imaekarã: Andrés, Feliᵽe, Bartolomé, Mateo, Tomás, Alfeo maki Santiago, Tadeo, suᵽabatirã imaekaki, Simón, Celotekaka ᵽuᵽajoaeka mirãki. ");
INSERT INTO tnc_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Suᵽabatirã Judas Iscariote. Iki imaerã baaekaki Jesúre bojajããrimaji. ");
INSERT INTO tnc_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nare e'eweatirã, kika wãrũrimajaka wi'iarã ate Jesúre ᵽe'rika. Torã neyaeka ᵽoto rĩkimarãja ᵽo'imajare naᵽõ'irã rẽrĩka ate. Suᵽa imarĩ no'ojĩteoka maba'awãrũberijĩka naro'si simaeka. ");
INSERT INTO tnc_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","I'suᵽaka kire nabaaika ã'mitiriwa'ri, “Jiamarĩa ᵽuᵽajoaiki kime je'e mae”, kirĩrãre kireka ãrĩka. Suᵽa imarĩ kire akarĩ netaeka nawi'iarã kire e'ewa'yaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Moiséte jã'meka wãrõrimaja Jerusalénᵽi etaekarã ikuᵽaka Jesúreka ãrĩkarã: —Satanárika ima ĩᵽamaki Beelzebú kiᵽuᵽakarã ña'rĩjãikaki kime. Suᵽa imarĩ Beelzeburikaᵽi ba'iaja nareka ña'rĩjãikarãte kiᵽoatayu,— ãrĩwa'ri ba'iaja kireka najaika. ");
INSERT INTO tnc_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","I'suᵽaka naᵽakã'ã ã'mitiritirã, “I'suᵽakamarĩa sime”, ãrĩwa'ri nare bojaokaro'si Jesúre nare akaeka: —¿Yaje ikuᵽaka kirikaja Satanáre baajĩñu ruku? “Ᵽo'imajire ba'iaja jũaerã kireka miña'rĩjãibe”, ãrĩriᵽotojo ¿marãkã'ã baatirã “Kireka miᵽoᵽe”, ãrĩwa'ri kirikaja kẽrĩwãrũjĩñu ruku? I'suᵽakamarĩa sime. ");
INSERT INTO tnc_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ikuᵽaka sime aᵽea: Ĩ'rãtata imariᵽotojo najããribu'atirã, jia ĩ'rãtiji ᵽuᵽaritiirã nimawãrũberijĩñu. ");
INSERT INTO tnc_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","I'suᵽakajaoka simajĩñu ĩ'rãwi'irekaja imarãro'si. ");
INSERT INTO tnc_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","I'suᵽakajaoka simajĩñu Satanáro'si. Kirika imaka kijĩrĩjĩka jãjimarĩka jariwa'ri dakoa kibaawãrũberijĩñu,— Jesúre nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ikuᵽaka aᵽeroka nare kibojaeka ate: —Ĩ'rĩka o'yiokaki wi'iarã kiba'irĩjia ẽ'marĩ eyajĩkire, “Ãja'a, miro'si simarũ”, ãrĩwa'ri kire ĩjiberijĩki. I'suᵽaka baabeyuka kimamaka, o'yiokakire werika baatirã, kire kiᵽi'ᵽejĩka be'erõ'õᵽi ᵽuri kiba'irĩjia kẽ'majĩñu. I'suᵽakajaoka sime yiro'si. Satanáre tẽrĩwa'ribaji imaki imarĩ, Satanárika ima ña'rĩjãikarãreka yiᵽoatarijayu. I'suᵽaka baawa'ri kijã'mekoᵽeirãte kiro'si yikũmuriarijayu. Suᵽa imarĩ i'suᵽaka yibaaokaro'si yire jeyobaabeyuka kime Satanás,— Jesúre nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ikuᵽaka nare kibojañujuka: —Rita mijare ñañu. Ᵽo'imajare ritaja ba'iaja baarijayua, suᵽabatirã ritaja ba'iaja Tuᵽarãreka najaika, i'yoᵽi'riwa'ri kire sanaye'kariarũjemaka, ye'kariawãrũiki kime Tuᵽarã. ");
INSERT INTO tnc_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","I'suᵽaka simako'omakaja Esᵽíritu Santorikaᵽi Satanárika ima ña'rĩjãikarãre yijiemaka ĩatirã, “Beelzeburikaᵽi nare kijieyu”, ãñurãte, ba'iaja nabaaika ye'kariaberijĩki kime Tuᵽarã,— Jesúre nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“Beelzebú kiᵽuᵽakarã ña'rĩjãikaki imarĩ, i'suᵽaka Jesúre baawãrũyu”, kireka ĩ'rãrimakire ãrĩka ã'mitiritirã, i'suᵽaka Jesúre nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Torã ᵽo'imajaka jaibaraka Jesúre imaeka ᵽoto kiᵽakore etaeka, kibe'erõ'õkarãᵽitiyika. Torã eyatirã ᵽẽterãja natuika. Ᵽẽteᵽi imatirã kire nakarũjeka. ");
INSERT INTO tnc_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","I'suᵽaka naᵽakã'ã Jesús wã'tarã ruᵽataekarãte ikuᵽaka kire ãrĩka: —Miᵽako, mibe'erõ'õkarãᵽitiyika ᵽẽterã imarã. Mire niariyaᵽayu nañu,— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","I'suᵽaka naᵽakã'ã ikuᵽaka nare kẽrĩka: —¿Mako koime yiᵽako? ¿Nirã nime yibe'erõ'õkarã? Mae mijare yibojaerã baayu.— ");
INSERT INTO tnc_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Suᵽa nare ãrĩtirã kiᵽõ'irã ruᵽaekarãte ĩabaraka ikuᵽaka kẽrĩka: —Yibe'erõ'õkarã, suᵽabatirã yiᵽakoarãjaoka mija ime yika imarã. ");
INSERT INTO tnc_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mia je'e, ikuᵽaka sime: Tuᵽarãte yaᵽaika uᵽaka yi'yurã imarã yibe'erõ'õkarã, suᵽabatirã yiᵽakoarã,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","I'sia be'erõ'õ Galilea ᵽa'warijerã Jesúre wãrõeka ate. Torã rĩkimarãja ᵽo'imajare kiᵽõ'irã etaeka. I'suᵽaka nimamaka ĩawa'ri kũmuarã kijãiruᵽaeka. Ᵽo'imaja ᵽuri nimauᵽatiji ᵽa'warije ka'iareka oyiaja imaekarã. ");
INSERT INTO tnc_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","I'suᵽaka nimamaka ĩ'rãba'ikakamarĩaᵽi bojawãrõbaraka ikuᵽaka nare kẽrĩka: ");
INSERT INTO tnc_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","8","—Ã'mitirikõrĩ je'e: Õterimaji õterikiyaᵽea õterĩ ke'rika. Sakiõterũkirõ'õrã eyatirã sakitaaeka ᵽoto ĩ'rãri'o ma'arã jũjika wĩ'ñaka ba'aeka. Aᵽea ña'rĩka ãta watoᵽekarã kũᵽajĩ ka'ia imarõ'õrã. Torã ña'rĩka wãrũaja ᵽu'ririᵽotojo aiyaᵽeka sajoemaka jia rĩkoariberiwa'ri sajĩrĩka. Aᵽea ña'rĩka wi'siwatoᵽekarã. I'suᵽaka imaekarõ'õrã ña'rĩka ᵽuri ᵽu'ririᵽotojo jia jãjiberiwa'ri saruiberika. Aᵽea jia ka'ia imaekarõ'õrã ña'rĩka. I'suᵽarõ'õrã ña'rĩka ᵽuri jia jãjitirã ᵽu'rika. Suᵽa imarĩ ĩ'rãrijũki treinta rakao sarikarika, aᵽerijũki sesenta rakao, aᵽerijũki ᵽuri cien rakao rikarika,— ãrĩwa'ri nare kibojaeka. ");
INSERT INTO tnc_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","I'suᵽaka simamaka ikuᵽaka nare kẽrĩka mae: —I'tojĩrãja sime sakaka majaroka. Samija ã'mitiriwãrũye'e jia samija ᵽuᵽajoabe ᵽuri,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","I'sia be'erõ'õ Jesúre ĩ'rĩkaja imaeka ᵽoto kiᵽõ'irã imaekarã suᵽabatirã kika wãrũrimajaᵽitiyika rẽrĩtirã ikuᵽaka kire narĩka: —¿Marãkã'ã ãrĩrika mibojawãrõyu?— ");
INSERT INTO tnc_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","I'suᵽaka naᵽakã'ã, ikuᵽaka nare kẽrĩka: —Bikija ᵽo'imajare sõrĩberika simako'omakaja maekaka ᵽuri ritaja kirirãte jã'mebaraka jia mija imaerã Tuᵽarãte mijare sõrĩrũjerijayu. Aᵽerãte ᵽuri kire ã'mitiriᵽẽabeyurã nimamaka bojawãrõrikakakaᵽi yibojarijayu. ");
INSERT INTO tnc_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ã'mitirikõrĩ je'e, bikija Tuᵽarã majaroᵽũñurã no'oeka ikuᵽaka ãñua: “Saniaika simako'omakaja ĩabeyurã uᵽakaja nimarijayu. I'suᵽakajaoka yibojaika ã'mitiritiyariᵽotojo ã'mitiriᵽẽabeyurã uᵽakajaoka nimarijayu. I'suᵽaka imabekaja, kire takaja ã'mitiriᵽẽairã imawa'ri, ‘Ba'iaja yibaaika miye'kariabe’, ãrĩwa'ri Tuᵽarãte jẽñeirã nimajããeka. I'suᵽaka ãñurã nimarikareka sareka nare kiwayuĩajããeka”,— Jesúre nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Suᵽabatirã mae ikuᵽaka Jesúre nare ãrĩka ate: —¿Yaje õterikia õterimaji majaroka mija õrĩwãrũbeyu bai je'e? I'suᵽaka mijare yimajarobojako'a mija õrĩᵽũabesarãkareka, aᵽea mijare yibojakoᵽerãkaoka mija õrĩᵽũabesarãñu je'e,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","I'suᵽaka ãrĩtirã ikuᵽaka nare sakibojajiika: —Õterikia õterimaji ãrĩwa'ri mijare yibojako'a Tuᵽarãrika bojataᵽarimaji uᵽakaja sime. Suᵽa imarĩ Tuᵽarã majarouᵽakaja sime õterikiyaᵽea. ");
INSERT INTO tnc_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ĩ'rãrimarã ᵽo'imaja imarã ma'arã õterikiyaᵽea ña'ataeka uᵽaka imarã. I'suᵽaka imarã nimamaka Tuᵽarãrika na'mitirikoᵽeika be'erõ'õ Satanáre nareka saye'kariayu, kũᵽajĩji sanorĩkoᵽeikareka. ");
INSERT INTO tnc_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aᵽerã ᵽo'imaja imarã, ãta watoᵽekarã kũᵽajĩ ka'ia imarõ'õrã õterikiyaᵽea ña'rĩka uᵽaka imarã. Tuᵽarãrika ã'mitiritirã jĩjimaka nimakoᵽeyu. ");
INSERT INTO tnc_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","I'suᵽaka nimako'omakaja Tuᵽarãrika jia nare ña'rĩjãibeyurã imarĩ, nayi'yuaᵽi ãrĩwa'ri oka nare imamaka, suᵽabatirã saᵽareaoka aᵽerãte nare ĩariᵽe'yomaka, ñojimarĩji Tuᵽarãrika na'mitirikoᵽeika naja'atayu. ");
INSERT INTO tnc_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Aᵽerã ᵽo'imaja imarã wi'siwatoᵽekarã õteriki yaᵽea ña'rĩka uᵽaka imarã. Tuᵽarãrika ã'mitiririᵽotojo naᵽuᵽakarãja jiitaka oyiaja imarika jitoirã nime. I'suᵽakajaoka “Rĩkimakaja niñerũ yija rikarãka jia yija imarãñu”, ãᵽaraka waᵽuju naᵽuᵽaka nare ᵽakiyu. I'suᵽaka imawa'ri, sareka takaja ᵽuᵽaribaraka imarijayurã imarĩ, Tuᵽarãrika naye'kariyu. Suᵽa imarĩ saye'kariyurã imarĩ kiyaᵽaika uᵽakaja baabeyurã nime. ");
INSERT INTO tnc_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Aᵽerã ᵽuri Tuᵽarãrika jĩjimakaᵽi ã'mitiririjayurã. Ikuᵽaka nime: Jia ka'ikirõ'õrã õterikiyaᵽea ña'rĩka jia jãjia ᵽu'riwa'ri rĩkimakaja saruika. Ĩ'rãrijũki treinta rakao sarikarika, aᵽerijũki sesenta rakao, aᵽerijũki ᵽuri cien rakao rikarika. I'sia rikarika uᵽaka imarã nime Tuᵽarãrika jia ã'mitiriᵽẽairã. Jia kire yi'yurã imarĩ, kiyaᵽaika uᵽaka oyiaja baairã nime,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ikuᵽaka nare kẽrĩka ate: —Ᵽeria mawããyu, jia yaaboairõ'õ imarika yaᵽawa'ri. I'suᵽaka simamaka jotorokarã mu'aᵽããrũkimarĩa sime. ");
INSERT INTO tnc_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","I'suᵽakajaoka sime ika mijare yibojaika jia ᵽo'imajare õrĩᵽũabeyua simako'omakaja Tuᵽarãja “Ikuᵽaka sime”, kẽrĩrãka ᵽoto sanorĩrãñu. ");
INSERT INTO tnc_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mijare yibojaika jia mija õrĩwãrũriyaᵽaye'e, jia samija ᵽuᵽajoabe ᵽuri,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","I'suᵽakajaoka nare kẽrĩka: —Mijare ñañua mija ã'mitiriᵽẽabe. Samija ã'mitiriᵽẽaika ko'aᵽitorãja, “Ikuᵽaka simekã'ã”, mija ãrĩwãrũokaro'si Tuᵽarãte mijare jeyobaarãñu. I'suᵽaka ᵽemawa'ribaji kibaarãñu jiitakarãja mijare jeyobaarũkika imarĩ. ");
INSERT INTO tnc_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","I'suᵽakajaoka jiibaji õrĩrika yaᵽawa'ri sã'mitiyukate saᵽemawa'ribaji sakiõñaokaro'si Tuᵽarãte kire jeyobaarãñu. Sã'mitiriᵽẽariyaᵽabeyukate ᵽuri kũᵽajĩ kiõrĩkoᵽeika, Tuᵽarãte kireka saye'kariarãñu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","27","I'suᵽaka ᵽuᵽajoatirã ikuᵽakaoka Jesúre nare ãrĩka: —Maiᵽamaki Tuᵽarãrirã jiikuku kio'arũjerũkiakaka mijare yibojaerã baayu mae. Õterikiyaᵽea jia ᵽu'yu uᵽaka nime. Ĩakõrĩ je'e: Õterimajire õterikia õteika be'erõ'õ ñamiareka, ĩmiarekaoka, kikãñu ᵽoto, kãrĩbeyuka kima ᵽotooka sakiᵽu'rirũjemakamarĩa ᵽu'ritirã, saᵽu'riweiyu. I'suᵽaka sime “Sõñu uᵽakaja saᵽu'yu ikuᵽaka sime”, kẽrĩberiko'omakaja. ");
INSERT INTO tnc_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Jia ka'ia imawa'ri, sõñu uᵽakaja jãjia sajayurõ'õrãja ᵽu'ririjayua sime õterikia. Mamarĩ saᵽu'yu ᵽoto ritabijĩkaja sime. I'suᵽaka sima be'erõ'õ jo'babajijũki jariwa'ri saᵽũñuayu. Torãjĩrã koᵽakaja saruiyu mae. ");
INSERT INTO tnc_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Õterikia boᵽakã'ã ĩatirã, “Saye'eye'e”, ãrĩᵽuᵽajoatirã saba'iᵽite se'erĩ a'yu. Õterikia ᵽu'ririjayu uᵽakajaoka sime Tuᵽarãrirãro'si. “I'suᵽaka sime”, narĩwãrũberiko'omakaja, Tuᵽarãte yaᵽaika uᵽaka jia baairã nare kijarirũjerijayu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Aᵽeroka ikuᵽaka nare kibojaeka ate: —Tuᵽarãte ritaja kirirã imarãte jã'merũkiakaka jiibaji mija õñaokaro'si, ikuᵽaka majaroka mijare yiwãrõerã baayu. ");
INSERT INTO tnc_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Õterikia mostaza yaᵽea moteika uᵽaka nime Tuᵽarãrirã. Ritaja aᵽea õteriki yaᵽea kũᵽajĩbajirĩjiaka sime mostaza yaᵽea. ");
INSERT INTO tnc_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","I'suᵽaka simako'omakaja saᵽi ᵽu'ritirã aᵽea õteriki tẽrĩwa'ribaji ĩmirã saᵽu'riweiyu. I'suᵽaka imawa'ri rĩkimakaja ñoaka sarĩᵽia imamaka ijia jãjia yaaika ᵽoto wĩ'ñaka sarã ru'yu. Ã'mitirikõrĩ, i'suᵽakajaoka nime Tuᵽarãrirã naro'si. Mamarĩ rĩkimamarĩrãja kire ã'mitiriᵽẽairãte imako'omakaja, sabe'erõ'õbaji ᵽuri rĩkimarãja kire ã'mitiriᵽẽairãte imarijarirãñu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Norĩwaᵽu'ataekarõ'õjĩrã, i'suᵽaka rĩkimaka majarobojarikaᵽi ᵽo'imajare kibojawãrõroyika. ");
INSERT INTO tnc_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","I'suᵽakaᵽi oyiaja ᵽo'imajare kiwãrõroyika. Suᵽa simako'omakaja ĩ'rĩkaja kika wãrũrimajaᵽitiyika kimaroyika ᵽoto ᵽuri, bojawãrõrirokakaka jia nare kibojawaᵽu'ataroyika. ");
INSERT INTO tnc_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","I'sirĩmiji na'irã simaeka ᵽoto ikuᵽaka kika wãrũrimajare Jesúre ãrĩka: —Dajoa, ᵽa'wa mawaata'riwa'rirã.— ");
INSERT INTO tnc_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","I'suᵽaka kẽᵽakã'ã, ᵽo'imajare a'ribojaweatirã, Jesúre jãmaeka kũmurã najãika. Suᵽa imarĩ saᵽi naka ke'rika mae. Aᵽea kũmuareka imaekarãoka nabe'erõ'õ tẽrĩwa'rikarã. ");
INSERT INTO tnc_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Torã natẽrĩrijarika ᵽoto jãjia wĩrõa baeũ'mueka. Sabaemaka jãjia ᵽakuwa'ri kũmuarã jimarĩa okoa jãika. Suᵽa imarĩ kũmuarã okoa ᵽurueka mae. ");
INSERT INTO tnc_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","I'suᵽaka simako'omakaja kiruᵽuko'a ñu'takarã ᵽeatatirã kũmui'toᵽearã Jesúre kãrĩjãmaeka. I'suᵽaka kimamaka ĩatirã, kika wãrũrimajare kire tõrõeka. —Mia'mitiᵽe wãrõrimaji. Maña'mirã baayu. ¿Jia bai miro'si sime je'e?— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","I'suᵽaka naᵽakã'ã ã'mitiriwa'ri, mi'mirĩkatirã ikuᵽaka kẽrĩka: —Mibaea'si wĩrõa, i'suᵽakajaoka ᵽakuri,— sakẽᵽakã'ã so'rika mae. Wĩrõa baetiyika, suᵽabatirã okoa ᵽakurimarĩa jarika ");
INSERT INTO tnc_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Torãjĩrã mae, —¿Dako baaerã mija kĩkiko'o je'e? ¿Jia yire yi'riberiwa'ri “Yijare ĩarĩrĩwãrũiki kime”, yireka ãrĩbeyukajirã mija ime bai?— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","I'suᵽaka kẽrĩko'omakaja jimarĩa ᵽuᵽatawa'ri, “¿Maki kime ruku ĩ'ĩ? Wĩrõa, okoa ᵽariji kire yi'yua”, ãᵽaraka najẽrĩabu'aeka. ");
INSERT INTO tnc_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","I'suᵽaka simaeka be'erõ'õ Jesúre kika imaekarãᵽitiyika Gerasa ka'iarã tẽrĩeyaeka. ");
INSERT INTO tnc_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tẽrĩeyatirã Jesúre marĩwa'rika ᵽoto ĩ'rĩka Satanárika ima ña'rĩjãikakite kire torika. Majaka ãta wi'iarã nataroyikarõ'õᵽi Jesús ᵽõ'irã ketaeka. ");
INSERT INTO tnc_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Torã kimaeka wejabiritika uᵽaka oyiaja imaroyikaki imarĩ. Ᵽerumijiaᵽi kire naᵽi'ᵽeroyika simako'omakaja ñojimarĩji ᵽi'ᵽeberikaki uᵽaka kijariroyika. ");
INSERT INTO tnc_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ĩ'rãkurimarĩa kiãñaraka, kiᵽitakaoka kire naᵽi'ᵽeko'omakaja sakitũrũtataroyika. I'suᵽaka kimamaka ᵽo'imajare marãkã'ã kire baawãrũberiroyika. ");
INSERT INTO tnc_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","I'suᵽaka imaki imarĩ, ĩmi, ñamioka, ĩmima watoᵽekarã, majaka nataroyikarõ'õrã akaseretaᵽabaraka kituritaᵽaroyika. I'suᵽaka imataᵽabaraka tĩmarĩji ãtaᵽi kiᵽo'ia kiwa'etaᵽaroyika. ");
INSERT INTO tnc_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","I'suᵽaka kimaekarõ'õᵽi Jesúre ĩatirã kiᵽõ'irã kirĩrĩra'aeka. Kiᵽõ'irã eyatirã kiwãjitãji kiñukuruᵽaeka, “Marãkã'ã yibaaberijĩki kime”, kiᵽuᵽaka kire ãrĩka simamaka. ");
INSERT INTO tnc_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","I'suᵽaka kimamaka, ikuᵽaka Jesúre kire ãrĩka: —Mia'mitiᵽe Satanárika ima. Ĩ'ĩre kiᵽuᵽakareka mimarõ'õᵽi miᵽoᵽe,— kire kẽrĩka. I'suᵽaka kẽᵽakã'ã, —Jesús, Tuᵽarã tẽrĩrikaja imatiyaiki Maki mime. ¿Marãkã'ã yire mibaaerã baayu mae je'e? Tuᵽarãte ĩaika wãjitãji, “ ‘Ba'iaja mibaaika ᵽarea ba'iaja mire baabesarãki yi'i mae’, yire meᵽe”,— akasererikaᵽi Satanárika ima ña'rĩjãikakite ãrĩka Jesúre. ");
INSERT INTO tnc_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","I'suᵽaka kẽᵽakã'ã ikuᵽaka Jesúre kire ãrĩka: —¿Marãkã'ã miwãmea?— I'suᵽaka kire kẽᵽakã'ã, —Legión ñime, rĩkimarã ba'irã yija ima simamaka.— ");
INSERT INTO tnc_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Suᵽabatirã “Ika ka'iaᵽi yijare miᵽoata'si”, jimarĩ Jesúre kẽrĩrijarika. ");
INSERT INTO tnc_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","I'suᵽaka simaeka ᵽoto nakoyikurirã rĩkimakaja ba'abaraka jẽjewẽkoa ᵽa'itaeka ĩmimajã'ãreka. ");
INSERT INTO tnc_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","I'suᵽaka simamaka ikuᵽaka Satanárika ima kire ãrĩka: —Kireka yijare miᵽoataye'e, “Jẽjẽwẽko ᵽuᵽakarã mija ña'rĩjãibe”, yijare meᵽe,— ãᵽaraka kire najẽñeka. ");
INSERT INTO tnc_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","I'suᵽaka naᵽakã'ã, —Torã mija a'ᵽe,— nare kẽrĩka. Toᵽi mae ĩmirĩjireka ña'rĩjãitiirã imakoᵽekarãre ᵽorika, jẽjewẽkoa imaekarã ña'rĩjãiokaro'si. Suᵽa imarĩ jẽjewẽkoa dos mil rakamaki imaekarã Satanárika ima nare ña'rĩjãimaka jãjia narĩrĩwa'rika. Rĩrĩwa'ritirã ᵽusiᵽemarã eyatirã toᵽi naña'rĩka ᵽa'warã. I'suᵽaka baawa'ri nimauᵽatiji naña'miᵽataeka. ");
INSERT INTO tnc_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","I'suᵽaka sabaamaka sĩarĩrĩrimaja rĩrĩwa'ritirã, wejearã, wejematorãoka ᵽo'imajare sanabojaeka. Toᵽi mae “¿Dakoa suᵽa baaika?”, ãrĩwa'ri ᵽo'imajare ĩarĩ a'rika. ");
INSERT INTO tnc_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesúre imaekarõ'õrã eyatirã, ikuᵽaka Satanárika ima kireka ña'rĩjãika imakoᵽeroyikakite imamaka niaeka: “Jariroaka jããekaki, i'suᵽakajaoka kimaroyika uᵽakamarĩaja, jia kiᵽuᵽaka jaᵽakã'ã, ña'rĩyaaekaja ruᵽaki kime mae”, ᵽo'imajare ãrĩᵽuᵽajoaeyaeka. I'suᵽaka kimamaka ĩatirã, jimarĩa Jesúre nakĩkika “Tẽrĩritakiji kime”, ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Suᵽabatirã Satanárika ima kireka Jesúre ᵽoataekakaka, suᵽabatirãoka jẽjewẽkoa baaekakaka ĩãekarãte bojaeka aᵽerãte. ");
INSERT INTO tnc_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","I'suᵽaka kibaaika ã'mitiritirã Gerasakarã Jesúre kĩkiwa'ri nawejeaᵽi kiᵽe'ririka nayaᵽaeka. ");
INSERT INTO tnc_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","I'suᵽaka nimamaka toᵽi ᵽe'rira'aerã kũmuarã kijãika ᵽoto ikuᵽaka Satanárika ima kireka ᵽoritaᵽaekakite kire ãrĩka: —Mika a'ririka yaᵽatiyarĩji yiyaᵽayu yi'ioka,— kire kẽrĩkoᵽeka. ");
INSERT INTO tnc_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","I'suᵽaka kẽrĩko'omakaja ikuᵽaka Jesúre kire ãrĩka: —Yika a'ᵽekaja, miwi'iarã miᵽe'riwa'ᵽe. “Yire wayuĩaiki imarĩ, jia Maiᵽamakire yire baayu”, ãrĩwa'ri mirĩrãre mibojaokaro'si,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","I'suᵽaka kẽrĩka yi'riwa'ri kiᵽe'rika. Ᵽe'riwa'ritirã Decáᵽolireka imaeka wejearã Jesúre kire baaeka majaroka kibojataᵽaeka. I'suᵽaka kibaaeka ã'mitiritirã marãkã'ã ᵽo'imajare ãrĩwãrũberika, i'suᵽaka ima ã'mitirikoriberikarã imarĩ. ");
INSERT INTO tnc_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Torãjĩrã kũmua ke'rikaᵽiji Jesúre ᵽe'rira'aeka ate. Saᵽi ᵽe'rietatirã ᵽa'warijerã kirĩkamarika ᵽoto, rĩkimarãja ᵽo'imajare kiᵽõ'irã rẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","I'suᵽaka nimaeka ᵽoto judíorãkare rẽrĩriwi'i ĩᵽamaki, Jairo wãmeikite Jesús ᵽõ'irã etaeka. Suᵽabatirã kiwãjitãji kiñukuruᵽaeka. ");
INSERT INTO tnc_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Suᵽabatirã ikuᵽaka kire kẽrĩka: —Yimakore ᵽuᵽaririrã baayu. Miᵽitaka koᵽo'iarã mija'aᵽearika yiyaᵽatiyayu kojãjiokaro'si,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","I'suᵽaka kire kẽᵽakã'ã, Jesúre kika a'rika mae. Toᵽi koᵽakaja rĩkimarãja kĩĩrika ᵽo'imajare kika a'rika. ");
INSERT INTO tnc_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na'rika nawatoᵽekaᵽi ĩ'rãko wãmarĩa imaekakote torã imaeka. Ĩ'ᵽoũ'ᵽuarãe'earirakakuri wejejẽ'rãka koeyawa'rika ᵽu'uriweoko jĩsia ka'wisijũabaraka. ");
INSERT INTO tnc_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ĩ'rĩkaremarĩa ĩkobaarimajare kore nikobaarũjekoᵽeroyika. I'suᵽaka nabaaika waᵽa koniñerũ imakoᵽeka ritaja nare kõjiᵽataroyika. I'suᵽaka baariᵽotojo jã'rĩbaji kojaririjarika. ");
INSERT INTO tnc_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","I'suᵽaka baabaraka koimaeka ᵽoto “Wãmarĩa imarãte jimarĩa Jesúre bayayu”, ãrĩrika koã'mitiriroyika. I'suᵽaka simamaka koimaeka wã'tarã Jesúre etamaka ĩatirã, rĩkimarãja ᵽo'imajare imaeka watoᵽekaᵽi kiᵽẽterõ'õrã koeyaeka. ");
INSERT INTO tnc_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Jesúre imaekarõ'õrã eyatirã “Kijariroaka yiraberãkareka jia yijarirãñu”, kõrĩᵽuᵽajoaeka koᵽuᵽarõ'õᵽi. I'suᵽaka ᵽuᵽajoawa'ri kijariroaka korabeka mae. ");
INSERT INTO tnc_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","I'suᵽaka kobaaeka ᵽotojo koreka so'rika mae. “Risirika yireka imakoᵽeika o'yua mae”, kõrĩwãrũeka. ");
INSERT INTO tnc_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Kijarijoaka korabeka be'erõ'õ, “Tẽrĩrika ñimaᵽi ĩ'rĩkate tããñu”, kiᵽuᵽakaᵽi Jesúre ãrĩtika. Suᵽa imarĩ jorowa'ritirã ikuᵽaka ᵽo'imajare kẽrĩka: —¿Maki yijariroaka rabeko'oka?— ");
INSERT INTO tnc_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","I'suᵽaka kẽᵽakã'ã kika wãrũrimajare ikuᵽaka ãrĩka: —Miᵽõ'irã rĩkimarãja imarã mire rabeirã. ¿Marãkã'ã simamaka “¿Maki yijariroaka rabeko'oka?”, meñu?— ");
INSERT INTO tnc_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","I'suᵽaka kire narĩka simako'omakaja ᵽo'imajare ĩabaotabaraka kire rabekakite kimo'arijarika. ");
INSERT INTO tnc_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","I'suᵽaka kimaeka ᵽoto “Yi'i, risirika ñima yire o'yaokaro'si mire rabeko'oko”, ãrĩᵽuᵽajoawa'ri kiᵽõ'irã koeyaeka. I'suᵽaka koᵽuᵽaka imako'omakaja kire kĩkiwa'ri tarariᵽotojo kiwãjitãji koñukuruᵽaeka. I'suᵽaka baatirã kobaaeka uᵽakaja kire kobojaeka. ");
INSERT INTO tnc_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","I'suᵽaka kõᵽakã'ã, wayuĩarimaji imarĩ, ikuᵽaka kore kẽrĩka: —Mae mia'mitiᵽe yiwãyuĩaiko. Yire yi'riwa'ri, jia mijayu mae. “Yirisirika yire o'yua”, ãrĩwa'ri jĩjimaka miᵽe'riwa'ᵽe mae,— kore kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","I'suᵽaka kore kẽrĩka ᵽoto judíorãkare rẽrĩriwi'i ĩᵽamaki Jairo wi'iakarãre etaeka. Torã eyatirã ikuᵽaka Jairote narĩka: —Mimako ᵽuᵽaririko'oko. “Yimakore mibayaᵽe”, wãrõrimajire merĩa'si mae,— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","I'suᵽaka narĩko'omakaja, —Ba'iaja ᵽuᵽaribekaja, yire miyi'ᵽe,— Jesúre kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ᵽedro, Santiago, suᵽabatirã Santiago rĩ'ĩ Juan maekarakamarã tarãreje Jesúre akawa'rika. ");
INSERT INTO tnc_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Naka a'ritirã, rẽrĩriwi'i ĩᵽamaki wi'iarã jimarĩa oᵽaraka nimaekarõ'õrã keyaeka. ");
INSERT INTO tnc_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","I'suᵽaka nimamaka, ikuᵽaka nare kẽrĩeyaeka: —¿Dako baaerã mija oyu? Ᵽuᵽariribeyuko me'rõre ime. Kãrĩkako koime,— kẽrĩka oᵽaraka imaekarãte. ");
INSERT INTO tnc_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","“Koᵽakaja ᵽuᵽariritiyaekako koime”, ãrĩwa'ri Jesúre neeka. I'suᵽaka nimamaka ĩatirã, nare kiᵽorirũjeka. Suᵽabatirã ᵽuᵽaririkakote imaeka kurarakarã koᵽakiarã, suᵽabatirã kika imaekarã maekarakamarãᵽitiyika kikãkaeka. ");
INSERT INTO tnc_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Naka kãkatirã koᵽitakarã kore ñi'atirã ikuᵽaka kore kẽrĩka: —Talitá cum,— kore kẽrĩka. (Mokarokaᵽi marĩjĩkareka, “Me'rõ, mimi'mibe, mire ñañu”, ãrĩrika sime i'siroka). ");
INSERT INTO tnc_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","I'suᵽaka kẽrĩka ᵽotojĩji mi'mirĩkatirã, kojaarĩkawa'rika. Ĩ'ᵽoũ'ᵽuarãe'earirakakuri wejejẽ'rãka eyawa'yuko koimaeka. Õñia kojariᵽe'ᵽakã'ã ĩawa'ri, marãkã'ãoka ãrĩwãrũberijĩka najarika kika imaekarã, i'suᵽaka ima ĩakoriberikarã imarĩ. ");
INSERT INTO tnc_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","I'tojĩte, —Aᵽerãte samija boja'si,— nare kẽrĩka. Suᵽabatirã ba'arika koro'si nare ke'era'arũjeka. ");
INSERT INTO tnc_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Torãjĩrã mae, kika wãrũrimajaᵽitiyika Jesúre a'rika, kime'rãrĩ kimaeka wejearã. ");
INSERT INTO tnc_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Torã eyatirã jẽrĩtarirĩmi simaeka ᵽoto ᵽo'imajare kiwãrõũ'mueka judíorãkare rẽrĩriwi'iarã. Kire ã'mitiritirã, “Jiitakaja õñuka kime”, ãrĩwa'ri marãkã'ã narĩwãrũberika, i'suᵽaka jaikite ã'mitirikoriberikarã imarĩ. I'suᵽaka kibaamaka ikuᵽaka ᵽo'imajare kireka ãrĩka: —¿Marãkã'ã baatirã jiitakaja ĩ'ĩre õrĩᵽũayu? ¿Maki kire wãrõekaki ruku? Maikoribeyua ᵽariji ritaja baabeaiki kime,— narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Suᵽabatirã ikuᵽaka narĩka aᵽea: —María maki, õ'õrã yaᵽua yi'yerimaji kime. Suᵽabatirã Santiago, José, Judas, Simónᵽitiyika nama'miji kimema. Iki kima simamaka kibe'erõ'õkarã rõmijãoka õ'õrã makaja imarã,— torã imaekarãte ãrĩka. I'suᵽaka simamaka “Yija uᵽakaja imaki imarĩ imatiyabeyuka kime”, ãrĩwa'ri kire na'mitiriᵽẽariyaᵽaberika. ");
INSERT INTO tnc_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","I'suᵽaka naᵽuᵽajoamaka, ikuᵽaka nare kẽrĩka: —Tuᵽarãro'si bojaĩjirimajire “Jiitaka mare kibojayu”, ritaja ᵽo'imajare kireka ãñuka kime. I'suᵽaka simako'omakaja kiᵽo'ijirika wejeareka, kitã'omajataka ᵽuri i'suᵽaka ãrĩbeyurã,— kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Suᵽa imarĩ jia kire nayi'ribeᵽakã'ã, maikoribeyua nare kibeawãrũberika. I'suᵽaka imariᵽotojo ĩ'rãrimarãre takaja kiᵽitaka ja'aᵽeatirã wãmarĩa nimaeka nareka kijieka. ");
INSERT INTO tnc_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kitã'omajare kire ã'mitiriᵽẽabeᵽakã'ã marãkã'ã ãrĩwãrũberijĩka Jesúre jarika. I'suᵽaka imariᵽotojo aᵽea wejearã ᵽo'imajare wãrõtaᵽarĩ ke'rika mae. ");
INSERT INTO tnc_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ĩ'ᵽoũ'ᵽuarãe'earirakamarã kika wãrũrimaja imaekarãte Jesúre akaeka. Suᵽabatirã kirika nare ja'ajiyetirã, —Satanárika ima ᵽo'imajareka ña'rĩjãikarãte mija ᵽoatabe mijaro'sioka,— nare kẽrĩka. I'suᵽaka nare ãrĩweatirã ĩ'ᵽarimaki oyiaja Jesúre nare ᵽũataeka aᵽea wejeareka imaekarãte wãrõtaᵽaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","—Torã mija a'rirãka ᵽoto ᵽan, yaiᵽi'ia, niñerũoka mija e'ewa'ria'si. I'suᵽaka simako'omakaja mija tu'ua takaja mija e'ewa'ᵽe. ");
INSERT INTO tnc_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Suᵽabatirãoka ũ'ᵽuko'a, jariroaka mija jããika takaᵽiji mija a'ᵽe,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ikuᵽakaoka ate nare kẽrĩka: —Wejearã yirika bojarĩ mija eyaũ'murãñu, wi'itakarãja mija imabe, aᵽe wi'i, aᵽe wi'irã baabekaja. Aᵽea wejearã mija a'rirãka ᵽoto takaja toᵽi mija ᵽoᵽe. ");
INSERT INTO tnc_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mija eyarijarirãka wejerakakaja mijare e'etoriberiwa'ri, Tuᵽarãrika ã'mitiriᵽẽarika nayaᵽabesarãkareka, jãjiaᵽi nare jaika ka'wisijũabekaja nare mija ja'atabe. Toᵽi a'rirãka ᵽoto, ikuᵽaka mija baabe: Mija ũ'ᵽuko'arã ka'ia uyua eika mija ᵽajeᵽatebe “Yijare mija ã'mitiriᵽẽabeyua simamaka, Tuᵽarãte mijare ba'iaja mijare baarãñu”,— ãrĩwa'ri kika wãrũekarãte kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","I'suᵽaka nare kẽrĩka be'erõ'õ ᵽo'imajare wãrõrĩ na'rika mae. Suᵽa imarĩ naᵽõ'irã eyatirã ikuᵽaka nare narĩka: “Ba'iaja mija baaika ja'atatirã Tuᵽarãte mija ã'mitiriᵽẽabe”, neyaekarõ'õrã imaekarãte nabojarijarika. ");
INSERT INTO tnc_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","I'suᵽakajaoka Satanárika ima ña'rĩjãika imaekarãte nareka sanajieroyika. I'suᵽakajaoka rĩkimarãja wãmarĩa imaekarãte iyebakaᵽi yo'yebaraka, narisirika nareka ima no'ataroyika. ");
INSERT INTO tnc_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ritaja maikoribeyua Jesúre baabearoyika ã'mitiritirã ᵽo'imajare sabojaᵽibaeka. Ᵽo'imajare i'suᵽaka ãñua ĩᵽi Herodesoka sõrĩkaki. I'suᵽaka ᵽo'imajare ãñua ã'mitiritirã ikuᵽaka ĩ'rãrimarãre ãrĩka: —Juan, ᵽo'imajare ruᵽuko'a jũjerimajiji kime je'e aᵽeyari. Reyariᵽotojo ate õñia jarijĩki imarĩ, maikoribeyua kibeayu je'e aᵽeyari,— narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Aᵽerã ikuᵽaka ãrĩkarã: —Tuᵽarãro'si bojaĩjirimaji imaroyikaki Elías kime je'e aᵽeyari,— narĩka. I'suᵽaka narĩko'omakaja aᵽerimarã ᵽuri ikuᵽaka ãrĩkarã: —Bikija Tuᵽarãro'si bojaĩjirimaja imaroyikarã uᵽaka kime je'e aᵽeyari,— narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","I'suᵽaka najaimaka ã'mitiritirã, ikuᵽaka Herodete ãrĩka kiro'si: —Juan bikija kiruᵽuko'a yita'terũjekaki imariᵽotojo õñia jariᵽe'ritirã i'suᵽaka kibaabearijayu je'e aᵽeyari ate,— kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","I'suᵽaka kẽᵽakã'ã, Juanre najããerã baaeka ruᵽu, kirĩ'ĩ Feliᵽe rũmu Herodías wãmeikore ẽ'matirã Herodete koka imaeka. I'suᵽaka kibaamaka, ikuᵽaka Juanre kire ãrĩka: —Herodías mirĩ'ĩ rũmure me'maeka ba'iaja mibaayu, Tuᵽarãte jã'meika yi'riberiwa'ri,— ãrĩwa'ri kire kibojakoᵽeroyika. I'suᵽaka kẽᵽakã'ã, koka jia imarika yaᵽawa'ri Herodete kire ñi'arũjeka kisurararãkare. Kire ñi'atirã ᵽerumijiaᵽi ᵽi'ᵽetirã, wẽkomaka imariwi'iarã kire natarika. ");
INSERT INTO tnc_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","“I'suᵽaka kijaika waᵽa kire jããrika sime”, ãrĩᵽuᵽajoaekako imarĩ, Herodíare kire jããrũjerika yaᵽaeka. I'suᵽaka koᵽuᵽajoako'omakaja, Herodes ᵽuri “Tuᵽarãte yaᵽaika uᵽakaja jia wãjia baaiki Juanre ime”, ãrĩwa'ri jia jiyiᵽuᵽaka kireka õrĩkaki. Suᵽa imarĩ Juanre kojããrũjeriyaᵽako'omakaja kiyaᵽaberikoᵽeka. I'suᵽakajaoka Juanre bojaroyika jĩjimakaᵽi ã'mitirikaki imariᵽotojo “Kibojaika uᵽakaja yiyi'riye'e”, ãrĩriᵽotojo, sareka ña'rĩyaarĩ kimawãrũberika. ");
INSERT INTO tnc_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","I'suᵽaka Juanka kimako'omakaja “Ikuᵽaka yibaajĩkareka, yiᵽuᵽajoaika kitá'tewãrũberijĩñu je'e”, Herodíasre ãrĩᵽuᵽajoaekarĩmi seyaeka. I'suᵽaka kõrĩᵽuᵽajoaekarĩmi Herodete ᵽo'ijirika wejejẽ'rãka sarãkutorika. Suᵽa imarĩ kiro'si ba'irabeĩjirimaja ĩᵽarimarãre, suᵽabatirã surararãka ĩᵽarimarãreoka, Galilea ka'iakarã imatiyarimajareoka kiakaeka, “Mabayaarirã”, ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ritaja kiakaekarãte rẽrĩkarõ'õrã kãkatirã Herodías makore nare bayatããbeaeka jĩjimaka nimaokaro'si. “Jiitaka mare kobaabeayu”, Herodes kijeyomarãᵽitiyika ãrĩᵽuᵽajoaekarã. I'suᵽaka imawa'ri ikuᵽaka kore kẽrĩka: —¿Dakoa mire ñijirika miyaᵽayu maekaka jiitakaja mibaaika waᵽa? Miyaᵽaikaja mire ĩjirã i'suᵽaka ñañu. ");
INSERT INTO tnc_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mire ᵽakibeyuka yi'i, ika ka'iakaki ĩᵽi imarĩ, ritaja yiba'irĩjia waᵽajã'rĩakaka ñe'metãjirõ'õjĩrã mire ĩjijĩki imarĩ suᵽa mire ñañu,— Herodías makore kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","I'suᵽaka kore kẽᵽakã'ã, koᵽakore jẽrĩarĩ ko'rika mae. —¿Dakoa kire yijẽñerãñu ruku, ma'i?— kore kõrĩka. I'suᵽaka kõᵽakã'ã, —“Juan ᵽo'imajare ruᵽuko'a jũjerimaji ruᵽuko'a yiyaᵽayu”, kire meᵽe,— kore kõrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","I'suᵽaka kore kõᵽakã'ã, jajuaja a'ritirã koĩᵽamaki Herodes ᵽõ'irã koeyaeka. Kiᵽõ'irã eyatirã ikuᵽaka kire kõrĩka: —Juan ruᵽuko'a yiyaᵽayu. I'suᵽaka simamaka kimarõ'õrã a'ritirã, sata'tetirã, seroarã saᵽeatatirã yire samijibe maekakaja,— kire kõrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","I'suᵽaka kõᵽakã'ã jimarĩa Herodete ba'iaja ᵽuᵽarika. Juanre jããrika yaᵽabeririᵽotojo, mamarĩji kore kẽrĩka kijaita'ariyaᵽaberika. Ᵽo'imajare ã'mitirika wãjitãji, “Miyaᵽaikaja mire ñijirãñu”, kẽrĩtika simamaka, kojẽñeikaja kore kĩjirã baaeka. ");
INSERT INTO tnc_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","I'suᵽaka simamaka ñojimarĩji ĩ'rĩka kisurarate Juan ruᵽuko'a ta'terĩ kiᵽũataeka. ");
INSERT INTO tnc_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Torã eyatirã Juan ruᵽuko'a ta'tetirã, seroᵽemarã saᵽeatatirã sake'era'aeka. I'suᵽaka baarĩ ke'rikarõ'õᵽi ᵽe'rietatirã Herodías makore sakĩjika. Suᵽa imarĩ iko mae koᵽakore sĩjikako. ");
INSERT INTO tnc_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","I'suᵽaka Juanre nabaaeka ã'mitiritirã, kika wãrũeka mirãrãte kiᵽo'imirãka e'erĩ etaeka sayayeokaro'si. ");
INSERT INTO tnc_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","I'suᵽaka simaeka be'erõ'õ Jesúka wãrũrimaja kirika bojataᵽarĩ turikarãte ᵽe'rietaeka. Suᵽa imarĩ kiᵽõ'irã etatirã nawãrõtaᵽaeka majaroka kire nabojaeka. ");
INSERT INTO tnc_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","I'suᵽaka simaeka ᵽoto torã rĩkimarãja ᵽo'imaja i'tarijayurã, ᵽe'ririjayurãoka imaekarã. I'suᵽaka simamaka kika wãrũrimajaka no'ojĩteoka maba'awãrũberijĩka Jesúro'si simaeka. Suᵽa imarĩ ikuᵽaka kika imaekarãte kẽrĩka: —Dajoa, ᵽo'imajamatorã kũᵽajĩ majẽrĩtaerã,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","I'suᵽaka nare kẽrĩka be'erõ'õ, kũmuaᵽi ᵽo'imajamatorã naka ke'rika mae. ");
INSERT INTO tnc_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Na'rirã baaeka ruᵽu rĩkimarãja ĩawãrũekarã. I'suᵽaka nabaamaka ĩatirã, ritaja wejeakarãre rĩrĩwa'rika Jesúre a'rikarõ'õrã. I'suᵽaka baaekarã imarĩ, kijeyomarãᵽitiyika torã keyabeyukajiji torã neyaweitika jãjia rĩrĩwa'rikarã imarĩ. ");
INSERT INTO tnc_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","I'suᵽaka nabaaeka simamaka waata'rieyatirã marĩwa'rikõrĩ rĩkimarãja ᵽo'imajare imamaka Jesúre ĩaeka. Torã eyatirã, ovejawẽkoa nare ĩarĩrĩrimajire imabeyurã uᵽaka ᵽo'imajare imamaka kĩaeka. I'suᵽaka nimaeka Tuᵽarãrika nare wãrõrimajire imaberika simamaka. I'suᵽaka imaekarã nimamaka “Jia õrĩwãrũbeyurã nime. Suᵽa imarĩ marãkã'ã baawãrũberijĩñurã nime”, ãrĩwa'ri wayuĩaekaki imarĩ, ritajakaka nare kiwãrõũ'mueka mae. ");
INSERT INTO tnc_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Aiyate ka'rawa'rirã baaeka ᵽoto kika wãrũrimajare kika jairĩ etaeka. Ikuᵽaka kire narĩka: —Na'irã sajaritiyu mae. Ᵽõ'imamato sime õ'õ. Suᵽa imarĩ ba'arika imabeyua. ");
INSERT INTO tnc_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Suᵽa imarĩ wejekoyikurirã ba'arika waruaᵽaraka ᵽo'imajare imarõ'õrã sawaᵽaĩjiba'arĩ na'rirũ,— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","I'suᵽaka naᵽakã'ã ikuᵽaka nare kẽrĩka: —Mijaja ba'arika nare mija ji'abe.— I'suᵽaka kẽᵽakã'ã ikuᵽaka kire narĩka: —¿Ᵽan yija waᵽaĩjirãñu bai je'e waᵽajã'rĩtaka simako'omakaja? Rĩkimarãja ᵽo'imajare imamaka, dosciento rakato denario sawaᵽa simarãñu,— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","I'suᵽaka naᵽakã'ã ã'mitiritirã, ikuᵽaka nare kẽrĩka: —¿No'ojĩrãrakato ᵽan mija rikayu je'e? Mija ĩabe ruᵽu.— I'suᵽaka kẽᵽakã'ã, —Ĩ'rãᵽitarakatojĩkaja sime. Suᵽabatirã wa'iaoka ĩ'ᵽarãjĩkaja ima,— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","I'suᵽaka naᵽakã'ã ikuᵽaka nare kẽrĩka: —“Ritario'ro jia taya imarõ'õrã mija ruᵽabe”, ᵽo'imajare mija ãᵽe.— ");
INSERT INTO tnc_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","I'suᵽaka kẽᵽakã'ã, kẽrĩka uᵽakaja ᵽo'imajare nabaarũjeka. Suᵽa imarĩ nare najã'meka uᵽakaja nimaekarõ'õrã ĩ'rão'roreka cincuenta, aᵽerio'roreka cien rakamarã nimaeka. ");
INSERT INTO tnc_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Suᵽa imarĩ ᵽan ĩ'rãᵽitarakato imaeka, wa'ia ĩ'ᵽarã imaekaoka Jesúre e'erikaeka. Suᵽabatirã wejeᵽemarã yu'ayoitirã, “Jia mibaayu a'bi”, ãrĩweatirã, ᵽan kiña'kata'ruika mae. Suᵽabatirã “Ᵽo'imajare samija ᵽibabe”, ãrĩwa'ri kika wãrũrimajare sakĩjika mae. I'suᵽakajaoka kibaaeka ĩ'ᵽarã wa'ia imaeka ritaja ᵽo'imajaka sanaᵽibaba'aerã. ");
INSERT INTO tnc_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","I'suᵽaka kibaamaka ritaja ᵽo'imajare ba'aeka, jia ña'ᵽirika najarikarõ'õjĩrã. ");
INSERT INTO tnc_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Sabe'erõ'õ, ĩ'ᵽoũ'ᵽuarãe'earirakaᵽi'i ᵽururika kika wãrũrimajare rẽaeka naña'ᵽika ᵽiyia. ");
INSERT INTO tnc_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Cinco mil rakamarã ĩmirĩja nimaeka saba'aekarã. ");
INSERT INTO tnc_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","I'suᵽaka baaweatirã kika wãrũrimajare ikuᵽaka Jesúre ãrĩka: —Kũmuarã jãitirã i'siᵽẽ'rõtorã mija waata'riwa'ᵽe. Suᵽabatirã Betsaida wejearã yire mija ta'abe.— Kika wãrũrimajare waata'riwa'rika ᵽoto ᵽo'imajare a'yaokaro'si kimajaroka bojabaraka kimaeka ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","I'suᵽaka baaweatirã, ĩmimakarã kimarĩwa'rika, Tuᵽarãka jairĩ. ");
INSERT INTO tnc_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Aiyate ka'raeka be'erõ'õ Galilea ᵽa'wa ñe'metãjirãja kũmua eyawa'rika, sarijeᵽi rĩkamaritirã Jesúre ĩamaka. ");
INSERT INTO tnc_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Wĩrõa jãjia baemaka jãjia nawẽ'ãko'omakaja sa'ribeᵽakã'ã kĩaeka. Suᵽa imarĩ bikitojo ñamiji okoᵽemaᵽi turitirã nakoyikurirã keyaeka. Nare kio'riwa'rirã baatikarã kire niatõᵽoeka. ");
INSERT INTO tnc_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Okoᵽemaᵽi kituᵽakã'ã ĩatirã, jimarĩa nakasereka, “Ᵽo'imaja oᵽirekoa sime je'e”, ãrĩᵽuᵽajoawa'ri. I'suᵽaka nimaeka jẽrãko'atirã, ikuᵽaka nare kẽrĩka: —Rikitubaka mija jaᵽe, kĩkibekaja. Yi'iji ñime,— kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Suᵽa nare ãrĩtirã naᵽõ'i kũmuarã kijãika mae. Sarã kijãika ᵽoto wĩrõa o'rika mae. Suᵽa imarĩ i'suᵽaka kibaamaka ĩatirã marãkã'ã ãrĩwãrũberijĩka najarika, i'suᵽaka ĩakoriberikarã imarĩ. ");
INSERT INTO tnc_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Saruᵽubaji, ᵽan kũᵽajĩ imako'aᵽi ᵽo'imajare Jesúre ji'amaka ĩako'omakaja, “Tẽrĩwa'ribaji imaki Jesúre ime”, ãrĩbeyukajirã nimaeka, õrĩwãrũberikarã imarĩ. ");
INSERT INTO tnc_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ᵽa'wa waata'riwa'ritirã Genesaret wãmeika ka'iarã neyaeka. ");
INSERT INTO tnc_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Waata'rieyatirã nakũmua ji'aᵽããtirã namarĩwa'rika ᵽotojĩteje torã imaekarãte Jesúre ĩawãrũeka. ");
INSERT INTO tnc_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kire ĩatirã jajuaja na'rika aᵽerãte bojarĩ. Sã'mitiritirã wãmarĩa imaekarãte naᵽeyurũkiaᵽi ne'era'aeka kiᵽõ'irã. ");
INSERT INTO tnc_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ke'riroyikarõ'õrãja kũᵽajĩriwejerã, jo'bariwejerã, wi'imatorãoka, kiᵽõ'irã neyaroyika. Suᵽabatirã rĩkimarãja ba'irĩjia ĩjibaraka ᵽo'imajare imaekarõ'õrã, jĩñurãte naᵽããjiyeroyika nare kitããokaro'si. Kijariroaka kũᵽajĩji nare kiraberũjerika yaᵽawa'ri jimarĩa jĩñurãte kire akaeka. Kijariroaka rabekarakamarãreje narisirika o'riᵽataeka mae. ");
INSERT INTO tnc_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Fariseokaka ᵽuᵽajoairã, suᵽabatirã judíotatarãte jã'meka wãrõrimajaoka Jesús ᵽõ'irã etaekarã, Jerusalénrõ'õᵽi i'tatirã. ");
INSERT INTO tnc_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Kiᵽõ'irã eyatirã ĩ'rãrimarã kika wãrũrimajare ᵽitajũjebekaja ba'amaka niaeka. I'suᵽaka nabaamaka ĩatirã “Mañekiarã ᵽitajũjetirã oyiaja mare ba'arũjekarã. Kika wãrũrimaja ᵽuri ba'iaja baawa'ri ᵽitajũjebekaja ba'airã”, narĩᵽuᵽajoaeka. ");
INSERT INTO tnc_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","4","(Ikuᵽaka nime, fariseokaka ᵽuᵽajoairã, suᵽabatirã aᵽerã natã'omaja judíorãkaoka: Nañekiarãte baaroyika uᵽakaja yi'yurã imarĩ, “Tuᵽarãte jia yijare ĩajiyurũkiaro'si sime”, ãrĩwa'ri naba'aerã baaika ruᵽu naᵽuriakaja ᵽitajũjerioyiaja nabaayu. I'suᵽakajaoka nabaarijayu ba'arika waᵽaĩjiᵽe'rietatirã. Suᵽabatirã ko'a, jotoa, seroa ᵽeruakaka baaeka najũjerijayu. I'suᵽakajaoka nabaayu naba'awearijayu rakakaja ĩ'rãtiji naruᵽarikũmua jia najũjerijayu. “Mañekiarãte yijare wãrõeka yija yi'riberirika yaᵽabeyuka Tuᵽarã. Suᵽa imarĩ kĩaika wãjitãji ba'iaja baairã yija imakoreka nawãrõeka uᵽakaja yija baayu”, ãrĩᵽuᵽajoawa'ri, i'suᵽaka nabaakoᵽeyu). ");
INSERT INTO tnc_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Suᵽa imarĩ Jesúka wãrũirãte ᵽitajũjebekaja ba'amaka ĩatirã, —¿Dako baaerã mika wãrũrimaja ᵽuri mañekiarãte jã'meka yi'ribeyurã? Miabe, ᵽitajũjebekaja naba'ayu,— kire narĩka fariseokaka ᵽuᵽajoairã, suᵽabatirã judíorãkare jã'meka wãrõrimajaoka. ");
INSERT INTO tnc_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Sã'mitiritirã ikuᵽaka Jesúre nare ãrĩka: —“Tuᵽarãte yaᵽaika uᵽakaja jia baairã yija ime”, ãrĩriᵽotojo mija ᵽuᵽajoaika uᵽakamarĩa mija ime. I'suᵽaka mija imakaka ᵽuᵽajoaweibaraka, Tuᵽarãro'si bojaĩjiokaro'si Isaías imaekakite o'oeka: “Ikuᵽaka ika ᵽo'imajareka Tuᵽarãte ãñu: ‘Yire jiyiᵽuᵽaka õñurã uᵽaka najaiko'omakaja, naᵽuᵽarõ'õᵽi yire jiyiᵽuᵽayeebeyurã nime. ");
INSERT INTO tnc_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Suᵽabatirã ᵽo'imajare jã'meka uᵽakaja nawãrõikakakaja “Tuᵽarãte jã'meka sime”, narĩrijayu. Suᵽa imarĩ dakoa waᵽamarĩaja yire najiyiᵽuᵽayeekoᵽeyu’ ”, kio'oeka,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Toᵽi mae, ikuᵽaka Jesúre nare ãrĩka ate: —Tuᵽarãte jã'meika ã'mitiriᵽẽabeyurã imarĩ, mañekiarãte mijare wãrõeka ᵽuri jia mija ã'mitiriᵽẽayu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","I'suᵽakajaoka ikuᵽaka nare kẽrĩka: —Mañekiarãte wãrõeka takaja ã'mitiriᵽẽaokaro'si, Tuᵽarãte jã'meika ja'atarika ᵽuri jiitakaja õñurã mija imema. ");
INSERT INTO tnc_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ikuᵽaka Moiséte ãrĩka mija ĩabe: “Miᵽakire, miᵽakoreoka yi'riwa'ri jia nare mibaabe”, ãrĩwa'ri kio'oeka. I'suᵽakajaoka, “Ĩ'rĩka kiᵽakire, kiᵽakoreoka ba'iaja baarijayukate majããkoᵽejĩñu”, ãrĩwa'ri kio'oeka. ");
INSERT INTO tnc_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mija ᵽuri “Mañekiarãte ikuᵽaka mare wãrõeka”, ãrĩwa'ri sayi'yurã imarĩ, ikuᵽakakakaᵽi jã'merijayurã: “Yiᵽakire, yiᵽakoreoka jeyobaaberijĩki yi'i. Ritaja yirikaika Tuᵽarãro'si oyiaja ima. Iki ĩ'rĩkateje saᵽi yijeyobaarãñu”, ãñurãteje, “Jia nabaayu”, mija ãñu. ");
INSERT INTO tnc_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","“I'suᵽaka ᵽuᵽajoairãro'si, kiᵽakiarãte kĩarĩrĩberikoᵽejĩka marã imabeyua”, mija ãrĩrijayu. ");
INSERT INTO tnc_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","I'suᵽaka mija jaiyu, mañekiarãte baaroyiroka yi'yurã imarĩ, Tuᵽarãrika yi'ribeyurã mija jayu. Suᵽabatirãoka aᵽea rĩkimakaja ima i'suᵽaka mija baarijayua,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","16","I'suᵽaka nare ãrĩtirã ᵽo'imajare kiakaeka ikuᵽaka nare ãñaokaro'si: —Mae mija imauᵽatiji yire ã'mitiritirã mija õrĩᵽũabe. Ba'arika mija ba'aikamarĩa sime ba'iaja mijare baarũjeika Tuᵽarã ñakoareka. Mija ᵽuᵽakaᵽi “Ikuᵽaka yibaaye'e”, ãrĩᵽuᵽajoatirã ba'iaja mija baariᵽarea Tuᵽarãte mijare ĩariᵽe'yoyu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","I'suᵽaka nare ãrĩweatirã wi'itõsiarã kika wãrũrimajaᵽitiyika Jesúre nare kãkataᵽawa'rika mae. Wi'itõsiarã kika kãkatirã, —Ᵽo'imajare miwãrõko'akaka yijare mibojajiibe,— kika wãrũrimajare kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","I'suᵽaka naᵽakã'ã ikuᵽaka nare kẽrĩka: —¿Yiwãrõko'a jia mija ã'mitiriwãrũberiko'o bai je'e mijaro'sioka? “Ᵽo'imajare ba'aikamarĩa ba'iaja nare baarũjeika Tuᵽarã ñakoareka”, ñarĩko'ojĩkaja ¿mija õrĩwãrũberiko'o bai je'e? ");
INSERT INTO tnc_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Maba'aika maᵽuᵽaka ña'rĩjãibeyua. Maba'aika mañe'mearã takaja ña'rĩjãirijayua. Suᵽabatirãoka maᵽo'iaᵽi ᵽorirũkiaja sime,— nare kẽrĩka. (Suᵽa imarĩ “Ritaja maba'aika jãjibaarimajimarĩka Tuᵽarãte ime”, ãrĩwa'ri i'suᵽaka nare kẽrĩka). ");
INSERT INTO tnc_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ikuᵽakajaoka nare kibojajiika ate: —Ba'iaja ᵽuᵽajoairã imarã ba'iaja baarijayurã. I'suᵽaka imarã nimamaka, Tuᵽarã ñakoareka ba'iaja nare sabaarũjerijayu. ");
INSERT INTO tnc_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","I'suᵽaka imarã imarĩ, ba'iaja ᵽuᵽajoairã najayu. Suᵽabatirã “Yirũmumarĩko iko, yitĩmimarĩka ĩ'ĩ”, ãrĩrimarĩaja ba'iaja naka nabaawã'imarĩrijayu. Suᵽabatirã karee'erimaja, jããrimaja, rõmikirã imariᵽotojo aᵽerã rõmijãka ba'iaja baarijayurã, rõmijã tĩmiairã imakoᵽeirãoka i'suᵽakaja baarijayurã naro'si. ");
INSERT INTO tnc_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","I'suᵽakajaoka aᵽikate ba'irĩjia rikaika oakiyurã, ritaja dika jariwa'ririmarĩaja ba'iaja baarijayurã, ᵽakirimaja, suᵽabatirã nayaᵽaika uᵽakaja i'yoᵽiᵽekaja ba'iaja baarijayurã, aᵽerã jia kiro'si imarijayurãte ã'mijĩairã imarã. Suᵽabatirã aᵽerãte ba'iaja jaijairibiyaokaro'si ᵽakirika nareka jairijayurã, “Aᵽerãte tẽrĩwa'ribaji imatiyairã yija ime”, ãñurã, i'suᵽakajaoka Tuᵽarãte yaᵽaikakaka ᵽuᵽajoabekaja, waᵽuju naᵽuᵽaka nare ãñu uᵽakaja baarijayurã nime. ");
INSERT INTO tnc_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Naᵽuᵽarõ'õᵽi ba'iaja ᵽuᵽajoairã imarĩ, i'suᵽaka ritaja nabaarijayu. I'suᵽaka imarã nimamaka Tuᵽarã ñakoareka ba'iaja nimarijayu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","I'suᵽaka kibojaeka be'erõ'õ a'ritirã Tiro wãmeika wejewã'tarã Jesúre eyaeka. Torã keyaeka ᵽoto kareaja wi'iarã keyariyaᵽakoᵽeka. I'suᵽaka kiᵽuᵽajoaeka imako'omakaja ᵽo'imajare sõrĩtika. ");
INSERT INTO tnc_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","I'suᵽaka simamaka sã'mitiritirã ikuᵽarõ'õᵽiji ĩ'rãkote kiᵽõ'irã etaeka. Satanárika ima ña'rĩjãikako ᵽako koimaeka. I'suᵽaka komakore imamaka, kore kiwayuĩarika yaᵽawa'ri kiwãjitãji koñukuruᵽaeka. ");
INSERT INTO tnc_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Sirofeniciaka'iakako, judíotatamarĩko koimaeka. Toᵽi mae ikuᵽaka kire kõrĩka: —Yire mijeyobaabe. Yimako Satanárika ima ña'rĩjãikako koime. I'suᵽaka simamaka koᵽuᵽakareka simakoᵽeika miᵽoatarika yiyaᵽayu mae,— kire kõrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","I'suᵽaka kõᵽakã'ã ikuᵽaka kore kẽrĩka: —Mae judíotatarã, yika wãrũrimajaka takaja ñimarãñu ruᵽu. Suᵽa imarĩ mimakore jierĩ nare ya'ritaᵽajĩka, jiamarĩa naro'si simajĩñu. Ĩakõrĩ je'e: I'suᵽaka mire yibaajĩkareka ᵽuri me'rãka ña'ᵽibeyukajirã ba'arika ẽ'matirã nayaiwẽkorĩjãka yiji'aika uᵽaka nare yibaajĩñu,— kore kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","I'suᵽaka kẽᵽakã'ã, ikuᵽaka kire koyi'rika: —Rita meñu, ñiᵽamaki. I'suᵽaka simako'omakaja ba'arika ᵽeatarũkia rokarã me'rãka ba'aña'ruika saba'ayu yaiwẽkorĩjãka,— kõrĩka. (Ikuᵽaka ãrĩrika i'suᵽaka kire kõrĩka: “Mika wãrũrimajare wãrõbaraka mimako'omakaja, kũᵽajĩ yire mijeyobaarãka jia yiro'si simarãñu”). ");
INSERT INTO tnc_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","I'suᵽaka kõᵽakã'ã ikuᵽaka kore kẽrĩka: —Jia miᵽuᵽajoaika simamaka, i'suᵽaka yire miyi'yu. I'suᵽaka simamaka Satanárika imakoᵽeika ᵽoyua mimakoreka mae. Suᵽa imarĩ miwi'iarã miᵽe'riwa'ᵽe,— kore kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kowi'iarã ᵽe'rieyatirã koᵽeyurũkiᵽemarã jia jãjiko komakore ᵽeyumaka kõieyaeka. Koᵽakaja Satanárika ima koreka ᵽorikako. ");
INSERT INTO tnc_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","I'tojĩrã ate Tirowejeaᵽi Jesúre o'rika. Toᵽi o'riwa'ritirã Sidón wãmeika wejearã keyaeka. Toᵽi ke'rika, Decáᵽolisᵽi kio'rika. Suᵽabatirã toᵽi o'ritirã Galilea ᵽa'warã keyaeka. ");
INSERT INTO tnc_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Torã kimaeka ᵽoto ã'mitiribeyuka, jaiwãrũbeyuka kiᵽõ'irã ᵽo'imajare e'eeyaeka. Kire e'eeyatirã “Miᵽitaka kiᵽo'iarã mija'aᵽeabe kijiiokaro'si”, kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","I'tojĩte ã'mitiribeyukate kire takaja aᵽerõ'õrã ke'ewa'rika. Torã mae kika takaja kimaekarõ'õrã ã'mitiribeyuka ã'mukoᵽea ĩ'ᵽaᵽẽ'rõtowã'tarãja kiᵽitawãjoa kikãkataeka. Suᵽabatirã kiᵽitawãjoaᵽi rijo'kaka e'etirã kirẽrõkakarã kirabeka. ");
INSERT INTO tnc_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Suᵽabatirã wejeᵽemarã yoimiatatirã, kire wayuĩawa'ri Jesúre yiataeka. I'suᵽaka baatirã ikuᵽaka kire kẽrĩka mae: —Eᵽatá,— kire kẽrĩka. (Kiokaᵽi ᵽuri “Sawiritarũ”, ãrĩrika simaeka). ");
INSERT INTO tnc_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","I'suᵽaka kẽrĩka ᵽotojo ã'mitiribeyuka imakoᵽekakite ã'mitiyuka jarika. I'suᵽakajaoka jia jaiwãrũbeyuka kimakoᵽekareka jia jaiki kijarika mae. ");
INSERT INTO tnc_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","I'suᵽaka kire baaweatirã, ᵽo'imaja ᵽõ'irã etatirã ikuᵽaka Jesúre nare ãrĩka: —Aᵽerãte samija bojaᵽiba'si.— I'suᵽaka nare kẽrĩrijarika simako'omakaja, jãjibaji aᵽerãte sanabojarijariroyika. ");
INSERT INTO tnc_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","I'suᵽaka kibaamaka jĩjimaka imawa'ri, ikuᵽaka narĩka: —Ã'mitiribeyurã, jaiwãrũbeyurãte ᵽariji jieiki kime. I'suᵽaka simamaka ritaja kibaaika jiitakaja sime,— narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Torãjĩrã ate rĩkimarãja ᵽo'imajare kiᵽõ'irã rẽrĩka. Kika nimekã'ãja naba'arika ᵽurika mae. I'suᵽaka simamaka kika wãrũrimajare akatirã ikuᵽaka nare kẽrĩka: ");
INSERT INTO tnc_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Ĩrãre wayuoka ñoñu, maekarakarĩmi sajaritiyu yika nima. Suᵽa imarĩ naba'arika ᵽuyua mae. ");
INSERT INTO tnc_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Naba'arika ᵽuyua simamaka, “Mija ᵽe'ᵽe”, nare ñarĩjĩkareka, ma'a ñe'metãjirãja nakẽsirabaña'rĩjĩñu yoeᵽi i'taekarã ᵽariji nima simamaka. I'suᵽaka simamaka nare yiji'ariyaᵽayu ruᵽu, ba'aweatirã naᵽe'yaokaro'si,— kika wãrũrimajare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","I'suᵽaka kẽᵽakã'ã, ikuᵽaka kire narĩka: —Ᵽo'imajare imabeyurõ'õ simamaka, marãkã'ã baatirã ba'arika nare maji'awãrũberijĩka sime,— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","I'suᵽaka naᵽakã'ã ikuᵽaka kẽrĩka: —¿No'ojĩrã ba'arika mija rikayu je'e?— I'suᵽaka kẽᵽakã'ã, —Ĩ'ᵽotẽñarirakato sime ᵽan,— narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Toᵽi mae ᵽo'imajare ka'iarã kiruᵽarũjeka. Ᵽan e'erikatirã ikuᵽaka kẽrĩka: “Jia mibaayu Tuᵽarã”, kire kẽrĩka. Suᵽabatirã ᵽan ña'kata'ruitirã kika wãrũrimajare sakĩjika. Ĩ'rã ritaja ᵽo'imajare saᵽibaekarã mae. ");
INSERT INTO tnc_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Suᵽabatirãoka wa'imakarãka kũᵽajĩ imaeka. Wa'ia e'erikatirã, “Jia mibaayu Tuᵽarã”, kẽrĩka ate. Suᵽabatirã kika wãrũrimajare sakiᵽibarũjeka. ");
INSERT INTO tnc_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nimaeka uᵽatiji ᵽo'imajare ba'aeka, jia ña'ᵽirika najarikarõ'õjĩrã. Sabe'erõ'õ, ĩ'ᵽotẽñarirakaᵽi'i ᵽururika kika wãrũrimajare rẽaeka naña'ᵽika ᵽiyia. ");
INSERT INTO tnc_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Cuatro mil rakamarã eyaerã baakõrĩ nimaeka saba'aekarã. Naba'aweaeka be'erõ'õ nare ke'ribojaeka. ");
INSERT INTO tnc_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","I'sia be'erõ'õ kika wãrũrimajaka kũmuarã kijãika ate. Saᵽi Dalmanutaka'iarã na'rika. ");
INSERT INTO tnc_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Torã keyaeka ᵽoto kire korirã kiᵽõ'irã fariseokaka ᵽuᵽajoairãte eyaeka. “Majẽñerãka uᵽakaja kibaawãrũbesarãkareka ‘Tuᵽarãte ᵽũataekakimarĩka kime marĩye'e’ ”, narĩka. I'suᵽaka simamaka ikuᵽaka kire narĩka: —“Tuᵽarãte ᵽũataekaki kime”, mireka yija ãrĩrã, yija ĩakoribeyua yijare mibearika yija yaᵽayu,— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","I'suᵽaka naᵽakã'ã ã'mitiritirã, ba'iaja ᵽuᵽariwa'ri jãjia kiyiataeka kire yi'riberikarã nimamaka. I'suᵽaka imawa'ri ikuᵽaka nare kẽrĩka: —¿Dako baaerã maikoribeyua nare yibearika maekukukarãte yaᵽayu je'e? Ritama sime, mija ĩakoribeyua mijare beabesarãki yi'i,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Suᵽabatirã Galilea ᵽa'wa i'siᵽẽ'rõtorã kika wãrũrimajaᵽitiyika nare kiwaata'ritaᵽawa'rika. ");
INSERT INTO tnc_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Torã Jesúka a'rikõrĩ wãrũrimajare naba'arika ye'karirika. Suᵽa imarĩ ĩ'rãtojĩkaja ᵽan narikaeka kũmuarã. ");
INSERT INTO tnc_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","I'suᵽaka simamaka mae ikuᵽaka Jesúre nare ãrĩka: —Fariseokaka ᵽuᵽajoarika levadura uᵽaka sime. Suᵽa imarĩ samija rakajebe. I'suᵽakajaoka Herodere imakakaoka mija rakajebe,— kika wãrũrimajare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","I'suᵽaka nare kẽrĩka, norĩwãrũberika. I'suᵽaka kẽᵽakã'ã natiyiaja jaibu'abaraka ikuᵽaka narĩka: —Ᵽan marikabeᵽakã'ã, suᵽa kẽñu,— narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","I'suᵽaka najaika Jesúre õrĩka. Sõrĩtirã ikuᵽaka nare kẽrĩka: —¿Dako baaerã, “Ᵽan imabeyuakaka”, mija jaiyu? ¿Yire õrĩbeyukajirã mija ime ruku bai je'e? I'suᵽakajaoka, ¿ᵽuᵽajoarika õrĩᵽũaberitiyairãja mija ime bai? ");
INSERT INTO tnc_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Mija ñakoa imako'omakaja mija ĩawãrũbeyu. Suᵽabatirã ã'mukoᵽea mijareka imako'omakaja mija ã'mitiriwãrũbeyu. ¿Ĩ'rãᵽitarakato ᵽan cinco mil rakamarã imarã ᵽo'imajare yiji'araᵽakakaka mija ye'kariritiyu bai je'e? ¿Naba'araᵽaka be'erõ'õ, ᵽiyia dikarakaᵽi'i sajariwa'raᵽaka mija rẽaraᵽe je'e?— nare kẽrĩka. I'suᵽaka kẽᵽakã'ã, ikuᵽaka narĩka: —Ĩ'ᵽoũ'ᵽuarãe'earirakaᵽi'i yija ᵽorotaraᵽe.— ");
INSERT INTO tnc_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Ĩ'ᵽotẽñarirakato ᵽan, cuatro mil rakamarã ᵽo'imajare yiᵽibaraᵽaka, naba'araᵽe ᵽiyia saro'si, ¿dikarakaᵽi'i sajariwa'raᵽe je'e?— nare kẽrĩka. —Ĩ'ᵽotẽñarirakaᵽi'i saᵽiyia yija ᵽorotaraᵽe,— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","I'suᵽaka naᵽakã'ã ikuᵽaka nare kẽrĩka ate: —I'suᵽaka yi'riwãrũirã imariᵽotojo, ¿dako baaerã “Ᵽan marikabeyuakaka mare kibojabeyu”, ãrĩwãrũbeyurã mija ime ruᵽu bai je'e?— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","I'sia be'erõ'õ kika wãrũrimajaka Betsaida wejearã Jesúre eyaeka. Torã neyaeka ᵽoto ñakoãtimarĩkate ᵽo'imajare e'eetaeka kiᵽõ'irã. Torã kire e'eeyatirã kire kijierika yaᵽatiyawa'ri “Kire mirabebe”, ãᵽaraka kire najẽñeka. ");
INSERT INTO tnc_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","I'suᵽaka naᵽakã'ã Jesúre kire tĩtiwa'rika weje a'riwa'ri ᵽañakarã. Torã kire e'eeyatirã, rijo'kakaᵽi kiñakoa wi'etirã, kiᵽitaka kire kija'aᵽeaeka. Suᵽabatirã ikuᵽaka kire kẽrĩka: —¿Yaje miyoiyu?— ");
INSERT INTO tnc_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","I'suᵽaka kẽrĩka be'erõ'õ kũᵽajĩ kĩaũ'mueka. Suᵽa imarĩ ikuᵽaka kiyi'rika mae: —Mae ᵽuritaka kũᵽajĩ yiyoiwa'tawa'yu. I'suᵽaka simako'omakaja ᵽo'imajare ñiakoᵽemaka, yaᵽua rĩ'meika uᵽaka oyiaja simamaka ñiayu,— kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","I'suᵽaka kire kẽᵽakã'ã kiñakoarã Jesúre kiᵽitaka ja'aᵽeaeka ate. I'suᵽaka kire kibaaᵽe'aeka be'erõ'õᵽi ᵽuri, ĩ'rãkõ'rĩmatorãja ñakoaᵽaraka jia warioyiaja sõiᵽataeka kiro'si mae. ");
INSERT INTO tnc_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","I'suᵽaka kijaᵽakã'ã ikuᵽaka Jesúre kire ãrĩka: —Miwi'iarã miᵽe'riwa'ᵽe, wejeaᵽi o'ᵽekaja ᵽuri,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","I'sia be'erõ'õ Jesús kika wãrũrimajaᵽitiyika a'ririjarikõrĩ, Cesarea de Filiᵽo wãmeika wejekoyikurirã neyarijarika. Torã ma'aᵽi na'ririjarika ᵽoto, kika wãrũrimajare ikuᵽaka kijẽrĩaeka: —Yireka ᵽuᵽajoatirã, “¿Maki kime”, ᵽo'imajare yireka ãñu?— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Toᵽi, —Ikuᵽaka ᵽo'imajare mireka ãñu: “Juan ᵽo'imajare ruᵽuko'a jũjerimaji kime”, aᵽerã ᵽuri, “Elías imaekaki kime”, ãñurã. Aᵽerã imarã, “Bikija ĩ'rĩka Tuᵽarãro'si bojaĩjirimaji imaekaki kime”, mireka nañu,— narĩka. I'suᵽaka naᵽakã'ã ikuᵽaka nare kijẽrĩaeka: ");
INSERT INTO tnc_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—Mija je'e, “¿Maki kime”, yireka mija ãñu?— Toᵽiji ikuᵽaka Ᵽedrote kire yi'rika: —Mi'iji mime Jã'merũkika Tuᵽarãte wã'maekaki,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","I'suᵽaka kire kẽᵽakã'ã, —I'suᵽaka aᵽerãte mija bojaᵽiba'si ruᵽu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","I'tojĩte ikuᵽaka Jesúre nare wãrõũ'mueka: —Yi'iji imaki Ᵽo'imaja Ma'mi. Bikija i'suᵽakaja yireka Tuᵽarãte ᵽuᵽajoatika simamaka, ba'itakaja jũarũkikaro'si ñime. I'suᵽaka simamaka kurarãka ĩᵽarimarã, Moiséte jã'meka wãrõrimaja, suᵽabatirã judíorãka ĩᵽarimarãte yire ĩariᵽe'yotirã yire najããrũjerãñu. Suᵽa yire nabaako'omakaja maekarakarĩmi be'erõ'õjo õñia yijariᵽe'rirãñu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","I'suᵽaka nare sakibojaeka jia sanoñaokaro'si. I'suᵽaka Jesúre ãᵽakã'ã ã'mitiritirã, aᵽerõ'õrã Ᵽedrote kire e'ewa'rika. Torã mae, —“I'suᵽaka simarãñu”, yijare meñua mibojarika yaᵽabeyuka yi'i,— Ᵽedrote kire ãrĩkoᵽeka. ");
INSERT INTO tnc_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","I'suᵽaka kẽᵽakã'ã, jorowa'ri kika wãrũrimajare Jesúre ĩaeka. I'suᵽaka nare ĩatirã ikuᵽaka Ᵽedrote kẽrĩka: —Yika wãrũrimaji mima simamaka, yibe'erõ'õrã imarũkika mime. I'suᵽaka simamaka, marãkã'ã baatirã yire jã'merimajimarĩka mime. Suᵽa imarĩ, Satanáre jaika uᵽakaja mijaiyu. Tuᵽarãte yaᵽaika uᵽaka ᵽuᵽajoarikoᵽakaja waᵽuju ᵽo'imajare yaᵽaika uᵽakaja ᵽuᵽajoaiki mime,— Ᵽedrote kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","I'suᵽaka kire ãrĩweatirã aᵽerã kika wãrũrimajare, suᵽabatirã ritaja aᵽerã torã imaekarãte kiakaeka. Nare rẽrãkũ'atirã, ikuᵽaka kẽrĩka: —Ĩ'rĩka yiriki imarika yaᵽarãkiro'si, kiyaᵽaikakaka, suᵽabatirã kirikarãkakaka ᵽuᵽajoabekaja yire yi'ririᵽareaja ba'iaja kijũarãñu. Ikuᵽaka sime: Ba'iaja jũabaraka yaᵽua tetaeka kõkeiki kiyaᵽaika uᵽakaja baawãrũbeyuka. I'sirokaᵽi ᵽuᵽajoaiki imarĩ, yika a'rirũkika kime. ");
INSERT INTO tnc_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ba'iaja jũabaraka reyarika yaᵽaberiwa'ri “Jesúre yaᵽaika uᵽakaja baabesarãki yi'i”, ãñuka õñia imajiᵽarika tõᵽobesarãki. Yire ã'mitiriᵽẽaiki imawa'ri, yirika bojariroka kibojaika ã'mitiriᵽe'yowa'ri najããrãki ᵽuri õñia imajiᵽarika tõᵽorãki. ");
INSERT INTO tnc_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","37","Ĩ'rĩka õñia kima ᵽoto ba'irĩjiareka takaja ᵽuᵽariwa'ri ritaja tõᵽoiki ᵽuri, kireyarãka ᵽoto ba'iaja imarika tiyibeyurõ'õrã a'rirãki. Ritaja ba'irĩjia tõᵽoeka mirãki imariᵽotojo, dakoa imabeyua saᵽi õñia imajiᵽarika kiwaᵽaĩjirũkia. Suᵽa imarĩ ba'irĩjia kitõᵽokoᵽeka, dako waᵽamarĩaja kiro'si sajarirãñu. ");
INSERT INTO tnc_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ikuᵽaka sime ĩakõrĩ je'e: Maekaka ᵽo'imaja ba'iaja baarijayurã nima simamaka, Tuᵽarãte ja'atairã nime. Mia, i'suᵽaka imarãte ĩaika wãjitãji, yire yaᵽaberiwa'ri “Jesúrikimarĩka ñime, suᵽabatirã kiwãrõikaoka ã'mitiririyaᵽabeyuka ñime”, ãñurãte ᵽuri yiᵽe'rietarãñurĩmi i'suᵽakajaoka naka ñimarãñu yiro'sioka. I'suᵽaka naka ñimarãka simamaka “Yirirãmarĩrã mija ime”, nare ñarĩrãñu yiro'sioka. I'sia ᵽoto Ᵽo'imaja Ma'mi imarĩ, Yiᵽaki Tuᵽarãrika yaaboarikaᵽi yiᵽe'rietarãñu. Suᵽabatirãoka jiirã ángelrãka yika etarãñurã,— Jesúre ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ate ikuᵽaka Jesúre nare ãrĩka: —Rita sime, tẽrĩwa'ribaji kirikaᵽi Tuᵽarãte jã'merũkia eyarãñu. I'suᵽaka simamaka õñia nimañujuju, ĩ'rãrimarã õ'õrã yika imarãte sĩarãñu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ĩ'rõtẽñarirakarĩmi be'erõ'õ Ᵽedro, Santiago, Juan maekarakamarãre Jesúre ᵽusiᵽemarã akawa'rika. Torã neyaeka ᵽoto aᵽea ĩoika Jesúre jaᵽakã'ã niaeka. ");
INSERT INTO tnc_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kijariroaka boitakaja ya'tarika sajarika, samajũjekoᵽemakaoka ᵽemawa'ribaji boiya'tarika sajarika. ");
INSERT INTO tnc_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","I'suᵽaka Jesúre jarika ᵽoto, torã Elías, Moisés imaroyikarã kiᵽõ'irã ᵽemakotowirikarã. I'suᵽaka baatirã kika najaimaka maekarakamarã kiakawa'rikarãte sĩaeka. ");
INSERT INTO tnc_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","I'suᵽaka sima ĩatirã naᵽuᵽataeka. I'suᵽaka simamaka ᵽuᵽatawa'ri, marãkã'ã ãrĩwãrũberiwa'riji ikuᵽaka Ᵽedrote ãrĩka: —Mia'mitiᵽe wãrõrimaji, õ'õrã maimajĩka jiitaka sime. Mijaro'si maekarakawi'i ᵽesiwi'ia yija baarãñu. Miriwi'i, Moisériwi'i, suᵽabatirã Elíariwi'ioka yija baarãñu,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","I'suᵽaka kimaeka ᵽoto oko ũmakaka uᵽaka ruira'atirã nare sarubu'ataeka. I'suᵽaka baatirã ikuᵽaka nare sajaika sawatoᵽekaᵽi: —Ĩ'ĩ, kime Yimaki. Yiwãtaitakiji kime. Suᵽa imarĩ jia kire mija ã'mitiriᵽẽabe,— sãrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","I'suᵽaka nare sãrĩka be'erõ'õ, ĩabaotaerã baakõrĩ ĩ'rĩkaja Jesúre rĩkakamaᵽakã'ã niaeka mae. ");
INSERT INTO tnc_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ĩmimaᵽemarã nimaekarõ'õᵽi kika torã a'rikarãᵽitiyika Jesúre tu'ara'aeka ate. Natu'arijarika ᵽoto ikuᵽaka nare kẽrĩka: —Mija ĩako'a aᵽerãte mija boja'si. Yi'i, Ᵽo'imaja Ma'mire reyarãka simako'omakaja õñia yijariᵽe'rirãka be'erõ'õ aᵽerãte samija bojarãñu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","I'suᵽaka kẽrĩka jia yi'rikarã imarĩ, aᵽerãte sanabojaberika. I'suᵽaka simako'omakaja natiyiaja ᵽuri ikuᵽaka narĩbu'aeka: —¿Marãkã'ã ãrĩwa'ri “Reyariᵽotojo ate õñia yijariᵽe'rirãñu”, kẽrĩko'o ruku?— narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","I'suᵽaka ãrĩkarã imarĩ ikuᵽaka kire najẽrĩaeka: —¿Dako baaerã, “Ᵽo'imajare jã'merũkika Tuᵽarãte ᵽũãtaerã baarãka ruᵽu Elías imaki mamarĩ etaũ'murãki”, Moiséte jã'meka wãrõrimajare ãñu?— narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","I'suᵽaka naᵽakã'ã, —Rita sime suᵽa nañua. Elías imaekakite baaeka uᵽaka baarimaji etarãki mamarĩ. Etatirã, ritaja imatikaja nimaokaro'si ikuᵽaka ᵽo'imajare kẽrĩrãñu: “Koyiaja sajariwa'yu Tuᵽarãte ᵽũatarãkire etarũkia. I'suᵽaka simamaka Tuᵽarãte yaᵽaika uᵽakaja baabaraka, kire ta'atikaja mija imabe.” Ikuᵽaka ñañua õrĩriᵽotojo “Ketarãka ᵽotorã jia kire mabaaye'e”, ᵽo'imajare ãrĩᵽuᵽajoakoᵽeyu. I'suᵽaka naᵽuᵽajoaika simako'omakaja, ikuᵽaka kijũarãñu ãrĩwa'ri Tuᵽarãrika bikija o'ora'aekarãte yireka ãrĩka: “Ᵽo'imaja Ma'mire ba'iaja ã'mika jũarãñu. Suᵽabatirã ‘Tuᵽarãte ᵽũataekakimarĩka mime’, ãᵽaraka ᵽo'imajare kire ᵽe'yorãñu.” ");
INSERT INTO tnc_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Rita sime. Elías imaekaki uᵽaka baarimaji etatiraᵽaki mae. I'suᵽaka simamaka nayaᵽaika uᵽakaja ba'iaja ᵽo'imajare kire baaraᵽe. I'suᵽaka kijũarũkia uᵽakaja ãñua Tuᵽarãrika no'oeka ᵽũñurã,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Torãjĩrã mae aᵽerã kika wãrũrimaja ᵽõ'irã Jesúre ᵽe'rieyaeka ate. Torã keyaeka ᵽoto kika wãrũrimaja ᵽõ'irã rĩkimarãja ᵽo'imajare imaeka. Suᵽabatirã Moiséte jã'meka wãrõrimajare kika wãrũrimajaka okabojibu'abaraka nimamaka kĩaeyaeka. ");
INSERT INTO tnc_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","“Ikuᵽarõ'õᵽiji Jesúre etarãñu je'e”, ãrĩᵽuᵽajoabekaja imaekarã imarĩ, ketamaka ĩawa'ri, jĩjimaitakaja ᵽo'imajare jarika. Jĩjimaka jariwa'ri kiᵽõ'irã narĩrĩwa'rika kire jẽñarĩ. ");
INSERT INTO tnc_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","I'suᵽaka ᵽo'imajare imaekarõ'õrã eyatirã ikuᵽaka kika wãrũrimajare kijẽrĩaeka: —¿Dakoakaka naka mija okabojiko'o?— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","I'suᵽaka kẽᵽakã'ã, ikuᵽaka ĩ'rĩkate ᵽo'imaja watoᵽekaᵽi kire yi'rika: —Mia'mitiᵽe wãrõrimaji. Yimaki kiᵽuᵽakarã Satanárika ima kireka ña'rĩjãika imaki, suᵽabatirãoka okamarĩka kime. I'suᵽaka imaki kimamaka, miᵽõ'irã kire ye'era'ako'o. ");
INSERT INTO tnc_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ikuᵽaka kire sabaarijayu: Yimakire ba'iaja sabaaika rakakaja jãjia kire saña'atarijayu. I'suᵽaka kire sabaaika ᵽoto kirijeaᵽi jõᵽotakaja ᵽoririjayua. Suᵽabatirãoka kioᵽia kã'rĩᵽaatabaraka ritikaja kijiyirijayu. I'suᵽaka kimamaka “Yimaki ᵽuᵽakarã Satanárika ima ña'rĩjãikakite mija ᵽoatabe”, ñarĩkoᵽeko'o mika wãrũrimajare. Suᵽa ñarĩko'omakaja sanaᵽoatawãrũberiko'o,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","I'suᵽaka kẽᵽakã'ã ã'mitiritirã, ikuᵽaka Jesúre ãrĩka ᵽo'imajare: —Yika ñoaka yibaarijayua ĩarijayurã imariᵽotojo, “¿Yaje rita Tuᵽarãrikaᵽi yijare kijeyobaatiyajĩñu ruku?”, ãñurã mija ime bai je'e ruᵽu. I'suᵽaka imarã imarĩ, yire mija ã'mitiriᵽẽaokaro'si ¿no'ojĩrã takaja mijare yiwãrõrãñu je'e? Mae, yiᵽõ'irã me'rĩre mija e'era'abe,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","I'suᵽaka kẽᵽakã'ã Jesús ᵽõ'irã kire ne'ewa'rika. Jesúre ĩawa'ri, ikuᵽarõ'õᵽiji me'rĩreka imaekakire kire tarataeka. I'suᵽaka kire sabaamaka, jĩrĩña'rĩtirã kitũrũeka. I'suᵽaka baabaraka jõᵽoaja kirijokoᵽea jarika. ");
INSERT INTO tnc_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","I'suᵽaka kibaamaka ĩatirã ikuᵽaka kiᵽakire kijẽrĩaeka: —¿Dikarakakuri wejejẽ'rãka mimakire eyawa'yu i'suᵽaka kima?— kire kẽrĩka. I'suᵽaka kẽᵽakã'ã, ikuᵽaka kiyi'rika: —Kũᵽajĩka kimaeka ᵽotorãja i'suᵽaka yimakire imaũ'mueka. ");
INSERT INTO tnc_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ĩ'rãkurimarĩa ᵽekaõ'toarã Satanárika ima kire ña'ataraᵽe, suᵽabatirã okoarãoka kire saña'ataroyiraᵽe kire riatariyaᵽawa'ri. I'suᵽaka simamaka sakaka jiewãrũiki mimaye'e, yijare miwayuĩarãkareka yijaro'si kire mijiebe,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","I'suᵽaka kẽᵽakã'ã ã'mitiriwa'ri, ikuᵽaka kire kẽrĩka: —¿Dako baaerã, “Jiewãrũiki mimaye'e”, yire meñu je'e? Yire ã'mitiriᵽẽaiki mimarãkareka, “Dakoa ka'wisika imabeyua miro'si”, yire merĩrãñu,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","I'suᵽaka kẽᵽakã'ã ã'mitiritirã, ikuᵽaka kiᵽakire ãrĩka: —“Yimakire kijiejĩñu je'e aᵽeyari”, ãrĩwa'ri mire ña'mitiriᵽẽayu. Suᵽa imarĩ jiibaji mire ña'mitiriᵽẽaokaro'si yire mijeyobaabe,— akasererikaᵽi kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","I'suᵽaka jaibaraka Jesúre imaeka ᵽoto rĩkimabaji ᵽo'imajare naᵽõ'irã rĩrĩra'amaka kĩaeka. Rĩkimarãja ni'tamaka kĩaekarãre kiᵽõ'irã etabeyukaji ikuᵽaka Satanárika ima kẽrĩka: —Mia'mitiᵽe, ᵽo'imajare okamarĩa imaerã, ã'mitiribeyurã nimaokaro'sioka nare imarũjeiki mimamaka me'rĩ ᵽuᵽakareka mire yiᵽorirũjeyu. Suᵽabatirã aᵽekurioka kireka miña'rĩjãibesarãñu,— sakẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","I'suᵽaka kẽᵽakã'ã ã'mitiriwa'ri tĩmarĩji akasererikaᵽi, tararikaᵽitiyika kire sariaña'taeka. Suᵽa kire baatirã kiᵽuᵽakareka ña'rĩjãikakite ᵽorika mae. Kiᵽoritaᵽaeka be'erõ'õ ᵽuᵽaririkaki uᵽaka me'rĩte jarika. Toᵽi kire ĩatirã, “Koᵽakaja jĩrĩka kimajaka ime”, ᵽo'imajare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","I'suᵽaka narĩko'omakaja kiᵽitakaᵽi kire ñi'atirã Jesúre kire baimi'mataeka. Ikuᵽaka kire kibaaeka ᵽotojo jia rĩkamañuka kijarika mae. ");
INSERT INTO tnc_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","I'sia be'erõ'õ wi'iarã Jesúre kãkawa'rika. Torã kika wãrũrimajaka takaja kimaeka ᵽoto ikuᵽaka kire narĩka: —¿Dako baaerã yija ᵽuri Satanárika ima ᵽoatawãrũberiko'orã je'e?— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Toᵽi ikuᵽaka nare kiyi'rika: —Tuᵽarãte takaja jẽñetirã, i'suᵽaka ima mija ᵽoatawãrũrãñu. Ikiᵽi takaja sime i'suᵽaka baawãrũrika, dakoa imabeyua aᵽea,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Toᵽi no'rika ᵽoto Galilea ka'iarã a'ririjaᵽaraka kiwãrũrimajare kiwãrõrijarika. Nare wãrõbaraka kimaekarõ'õ ᵽo'imajare õrĩrika kiyaᵽaberika. Ikuᵽaka nare kiwãrõeka: —Ĩ'rĩka imaki yire bojajããrũkika ᵽo'imajare yire ñi'aokaro'si. Ᵽo'imaja Ma'mire ñi'atirã, najããrãñu. Suᵽa yire nabaako'omakaja maekarakarĩmi be'erõ'õ õñia yijariᵽe'rirãñu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","I'suᵽaka nare kijaibojarijarika kika wãrũrimajare õrĩwãrũberika. Sõrĩwãrũbeririᵽotojo, “ ‘Õrĩᵽũawãrũbeyurã mija ime ruᵽu bai je'e’, mare kẽrĩjĩñu aᵽeyari”, ãrĩᵽuᵽajoawa'ri kire sanajẽrĩaberika. ");
INSERT INTO tnc_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Toᵽi no'riwa'rika Caᵽernaúm wejearã neyaeka. Torã eyatirã wi'iarã nakãkaeka. Wi'itõsiarã nimaeka ᵽoto, ikuᵽaka nare kijẽrĩaeka: —Ma'aᵽi mai'tarijariko'o ᵽoto ¿dakoakaka mija jaibu'arijariko'o?— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","I'suᵽaka kẽrĩko'omakaja, kire nayi'riberika. “¿Maki imaki ruku imatiyaiki?”, ãrĩwa'ri ma'aᵽi i'tarijaᵽaraka najaibu'arijarika kire nabojaribi'aeka. ");
INSERT INTO tnc_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kire nayi'ribeᵽakã'ã, yuruᵽatirã kika wãrũrimajare kiakaeka. —Ĩ'rĩkate imatiyaiki imariyaᵽarãka, “Yiᵽemawa'ribaji imarã aᵽerã”, ãrĩwa'ri dako okamirãmarĩaja ritaja ᵽo'imajaro'si ba'irabeĩjirimaji kimarãñu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Suᵽa imarĩ nawatoᵽekarã imaekaki me'rĩre e'erikatirã ikuᵽaka nare kẽrĩka: ");
INSERT INTO tnc_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Ĩ'ĩ me'rĩ imatiyaikimarĩka kime. I'suᵽaka kimako'omakaja, yire yi'riwa'ri ĩ'rĩkate jia kire baajĩka, jia yire baarika koᵽakaja i'suᵽaka kire kibaayu. Suᵽabaawa'ri yire ᵽũataekakiteoka i'suᵽakaja baaiki kime,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ikuᵽaka Juanre kire bojaeka: —Wãrõrimaji, miwãmeaᵽi Satanárika ima ᵽoataraᵽakire yija ĩaraᵽe. Maka imakoribeyuka kimaraᵽe. Satanárika ima ᵽoatarika mijã'meberikaki kimamaka, “I'suᵽaka mibaa'si”, kire yija ãrãᵽe,— Juanre kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Suᵽa kire kẽᵽakã'ã, ikuᵽaka kiyi'rika: —Jia kibaaraᵽe. I'suᵽaka baaikite mija jãjibaa'si. Ĩ'rĩka yire ã'mitiriᵽẽawa'ri maikoribeyua kibaabeaika be'erõ'õ ba'iaja yire jaiyuyebeyuka kime. ");
INSERT INTO tnc_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ba'iaja mare baabeyuka imarĩ, maka imatikaki uᵽakaja kime. ");
INSERT INTO tnc_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Rita mijare yibojayu. Yirirã mija imamaka ĩawa'ri mijare jeyobaaikika jia jĩjimaka Tuᵽarãte imarãñu. Okoa kũᵽajĩ kisĩarãka ãrĩwa'ri ᵽariji “Jiika kime”, Tuᵽarãte kireka ãrĩrãñu. I'suᵽaka kibaaika waᵽa jia Tuᵽarãte kire jeyobaarãñu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Me'rĩre ĩatirã ikuᵽaka nare kẽrĩka: —Me'rãrĩjaka ima uᵽaka yire yi'yurãte imarijayu. Suᵽa simamaka, ba'iaja nare baarũjeikite jimarĩa ba'iaja Tuᵽarãte kire baarãñu. I'suᵽaka kijũakoreka aᵽikate ba'iaja kibaarũki ruᵽubaji, ãta jo'baka kiwãmuarã ji'abaatirã kire naña'metarikareka jia simajããeka kiro'si. ");
INSERT INTO tnc_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ba'iaja baarika mija ja'atabe. Ĩakõrĩ je'e: Mija ᵽitakaᵽi ba'iaja mija baarijariye'e samija toata'tabe saᵽi ba'iaja mija baakoreka. Mija ᵽitaka ĩ'rãᵽẽ'rõto imabeᵽakã'ã jiamarĩa mijaro'si simakoᵽeko'omakaja Tuᵽarã ᵽõ'irã mija a'rirãñu. Ĩ'ᵽaᵽẽ'rõto ᵽitaka mijareka imamaka, ba'iaja mija baaika, tẽrĩwa'ribaji ba'iaja mijaro'si simarãñu ba'iaja imarika tiyibeyurõ'õrã mija a'rirũkia. Ᵽeka jũ'rẽika yaribeyua ima torã. ");
INSERT INTO tnc_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Mija ũ'ᵽuaᵽi ba'iaja mija baarijariye'e ĩ'rãᵽẽ'rõto mija toata'tabe. Mija ũ'ᵽua ĩ'rãᵽẽ'rõto imabeᵽakã'ã jiamarĩa mijaro'si simakoᵽeko'omakaja Tuᵽarã ᵽõ'irã mija a'rirãñu. Ĩ'ᵽaᵽẽ'rõto mija ũ'ᵽua imamaka, ba'iaja mija baaika tẽrĩwa'ribaji ba'iaja mijaro'si simarãñu ba'iaja imarika tiyibeyurõ'õrã mija a'rirũkia. ");
INSERT INTO tnc_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mija ñakoaᵽi ba'iaja mija baarijarirãkarekaoka samija e'etabe. Mija ñakoa ĩ'rãᵽẽ'rõto imabeᵽakã'ã jiamarĩa mijaro'si simakoᵽeko'omakaja Tuᵽarã ᵽõ'irã mija a'rirũkirã mija jarirãñu. Ĩ'ᵽaᵽẽ'rõto mija ñakoa imamaka, ba'iaja mija baaika tẽrĩwa'ribaji ba'iaja mijaro'si simarãñu ba'iaja imarika tiyibeyurõ'õrã mija a'rirũkia. ");
INSERT INTO tnc_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ᵽeka jũ'rẽika yaribeyua ima torã. Suᵽa imarĩ jimarĩa naᵽo'ia bekoa ba'arijarirãka. ");
INSERT INTO tnc_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Mae imarã ᵽo'imaja ba'iaja jũaᵽatarũkirã nime. “Ᵽekaᵽi mooika be'erõ'õ rakajekaja maimaye'e”, ãrĩwãrũirã mija ime. I'suᵽakajaoka ba'iaja jũakoritirã, ba'iaja baarika mija ja'atarãñu, jiibaji Tuᵽarãte ã'mitiriᵽẽaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mija ĩabe. Ba'arika yukiraika simamaka jia sajayu. I'suᵽaka simako'omakaja okaka sima sawayu ᵽoto ᵽuri, marãkã'ã baatirãoka okaka samabaawãrũbeyu ate. I'suᵽaka simamaka sataarikaja sime i'tojĩrã. Yukira ᵽuᵽajoatirã, yukira majããmaka jia maba'arika jayu uᵽaka jia mija baabu'aikaᵽi ãrĩwa'ri jiibaji imarã mija jarirãñu. Suᵽa imarĩ Tuᵽarãte yaᵽaika uᵽakaja baarija'atabekaja mija imarijaᵽe dakoa okamirãmarĩaja mija imaokaro'si,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Caᵽernaúm wejeaᵽi imatirã Judea ka'iarã Jesúre a'rika. A'ririjarikõrĩ, torã eyatirã Jordán wãmeiria kiwaata'rika. Aᵽeᵽẽ'rõtorã keyaeka ᵽoto, rĩkimarãja ᵽo'imajare kiᵽõ'irã rẽrĩka ate. Neyairõ'õrãja, nare kiwãrõrijariroyika uᵽakaja nare kiwãrõeka. ");
INSERT INTO tnc_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ᵽo'imajare wãrõbaraka kimaeka ᵽoto fariseokaka ᵽuᵽajoairãte kiᵽõ'irã etaeka. “Jia kiyi'riwãrũberirũ”, ãrĩwa'ri ikuᵽaka kire najẽrĩaeka: —¿Ĩmirĩji kirũmure kija'ataika, ba'iaja baarika sime bai?— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","I'suᵽaka naᵽakã'ã ã'mitiritirã ikuᵽaka nare kiyi'rika: —¿Marãkã'ã Moiséte mijare jã'meka je'e?— ");
INSERT INTO tnc_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","I'suᵽaka kẽᵽakã'ã ã'mitiritirã, ikuᵽaka kire nayi'rika: —Ikuᵽaka simaeka Moisés imaroyikakite bojaeka: “Ĩ'rĩkate kirũmure taarika yaᵽajĩka, ᵽaᵽera kio'ojĩñu. ‘Mire yitaaerã baayu’, ãrĩwa'ri ᵽaᵽera o'oeka kore ĩjiweatirã naja'atabu'ajĩñu”, Moisés imaekakite ãrĩka,— fariseokaka ᵽuᵽajoairãte ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","I'suᵽaka naᵽakã'ã ã'mitiritirã, ikuᵽaka nare kẽrĩka: —Tuᵽarãte ã'mitiriᵽẽarika yaᵽaberikarã mija ñekiarãte imamaka i'suᵽaka Moiséte naro'si so'oeka. I'suᵽakajaoka sime mijaro'si. ");
INSERT INTO tnc_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","7","I'suᵽaka kibaaeka simako'omakaja ᵽo'imajare kiᵽo'ijiaeka ᵽotorãja “Ĩmirĩji suᵽabatirã rõmoreoka Tuᵽarãte ᵽo'ijiaeka. Suᵽa imarĩ rõmie'etirã kiro'siji ĩmirĩjite imarãñu koka. I'suᵽaka simamaka kiᵽakiarãre kõrõtaᵽatirã kiᵽuᵽayariji kimarãñu koka mae. ");
INSERT INTO tnc_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","I'suᵽaka imaki imarĩ kirũmuka ᵽuri rakakaja ᵽuᵽajoabeyurã najayu mae. Ĩ'ᵽarã imariᵽotojo ĩ'rĩka uᵽakaja sime naᵽuᵽaka”, ãrĩwa'ri sabojayu Tuᵽarãrika o'oeka ᵽaᵽera ᵽũñurã. ");
INSERT INTO tnc_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","“I'suᵽaka nimarũ”, Tuᵽarãte ãñua simamaka, mija rõmia taabekaja mija imabe,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wi'iarã kãkawa'ritirã kijaikakaka kika wãrũrimajare kire jẽrĩaeka. ");
INSERT INTO tnc_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","I'suᵽaka naᵽakã'ã ikuᵽaka nare kiyi'rika: —Mamarĩ kirũmu imaekakote ja'atatirã aᵽeko ke'ekoᵽeiko kirũmumarĩko koime Tuᵽarã ñakoareka. Kirũmumarĩkoteje kiwã'imañua mamarĩkako kirũmutakore ba'iuᵽakaja baawa'ri i'suᵽaka kibaayu. ");
INSERT INTO tnc_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","I'suᵽakajaoka sime rõmo kotĩmite ja'atatirã aᵽikaka kotĩmiarikoᵽeiki kotĩmimarĩka kime Tuᵽarã ñakoareka. Kotĩmitakimarĩkaka kowã'imañua simamaka mamarĩkaki kotĩmitakire ba'iuᵽakaja baawa'ri i'suᵽaka kobaayu,— Jesúre nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jesús ᵽõ'irã me'rãka ᵽo'imajare e'era'aeka. “Nare rabebaraka ‘Jia nare mibaabe, Tuᵽarã’, ãᵽaraka naro'si kijẽñerũ”, ãrĩᵽuᵽajoawa'ri kiᵽõ'irã me'rãka ne'ewa'rika. I'suᵽaka nabaamaka ĩatirã, ikuᵽaka Jesúka wãrũrimajare nare ãrĩka: —Jesúre najo'akoreka, kiᵽõ'irã nare mija e'era'a'si,— ᵽo'imajare narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","I'suᵽaka naᵽakã'ã ã'mitiritirã Jesúre boebarika. I'suᵽaka imawa'ri kika wãrũrimajare ikuᵽaka kibojaeka: —Yiᵽõ'irã me'rãka etarika mija jãjibaa'si. Jiiᵽuᵽarãte jia ã'mitiriᵽẽairã nime me'rãka. Nimauᵽaka yire ã'mitiriᵽẽairãte jia Tuᵽarãte imaruᵽutarãñu. ");
INSERT INTO tnc_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Rita mijare yibojayu. Me'rãrĩjaka jia yi'yuakaka ᵽuᵽajoatirã Tuᵽarãte jia mija yi'ririjarijĩñu. I'suᵽaka yi'ribeyurãte ᵽuri Tuᵽarãte e'etoribesarãñu kijã'merũkirãro'si imarãñurãte,— kika wãrũrimajare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","I'suᵽaka nare ãrĩweatirã me'rĩre ke'erikaeka. Ke'erikaeka rakamarãre naruᵽuko'arã kiᵽitaka ja'aᵽeatirã ikuᵽaka kẽrĩka: “Jia nare mibaabe”, ãᵽaraka Tuᵽarãte naro'si kijẽñeka. ");
INSERT INTO tnc_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Toᵽi Jesúre a'rirã baaeka ᵽoto kiᵽõ'irã ĩ'rĩka ĩmirĩjite rĩrĩeyaeka. Jesús wãjitãji ñukuruᵽatirã ikuᵽaka kire kẽrĩka: —Jiitaki mime wãrõrimaji. Tuᵽarãka õñia ñimajiᵽariyaᵽayu. I'suᵽaka imaokaro'si ¿marãkã'ã yibaajĩñu ruku?— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","I'suᵽaka kẽᵽakã'ã ã'mitiritirã, ikuᵽaka kire kẽrĩka: —¿Dako baaerã, “Jiitaki mime”, yire meñu je'e? Tuᵽarã ĩ'rĩkaja imaki jiika. ");
INSERT INTO tnc_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tuᵽarãka õñia imajiᵽarika miyaᵽarãkareka kijã'meika uᵽakaja miyi'ririjaᵽe. Ã'mitirikõrĩ je'e: “Ᵽo'imaja jããbekaja. Rõmika imako'omakaja, aᵽekoka wã'imarĩbekaja. Karee'erimarĩa sime. ‘Ba'iaja kibaaraᵽe’, ãᵽaraka waᵽuju aᵽerãte bojaᵽakibekaja. Ᵽo'imajare ba'iaᵽiji ᵽakitirã naniñerũ mija ẽ'ma'si. Miᵽaki, miᵽakoreoka jia mija ã'mitiriᵽẽabe”, ãᵽaraka sabojayu Tuᵽarã majaroᵽũñurã o'oeka. I'sia õñuka mime,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","I'suᵽaka kẽᵽakã'ã ã'mitiritirã, ikuᵽakã'ã kire kẽrĩka: —Mia'mitiᵽe wãrõrimaji. Tuᵽarãte jã'meika õrĩwa'ri yime'rãrĩrãja jia sayi'ririjarikaki ñime,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","I'suᵽaka kẽᵽakã'ã ã'mitiriwa'ri, Jesúre kire wayuĩaeka mae. Suᵽa imarĩ ikuᵽaka kire kẽrĩka: —Ĩ'rãba'ikaka mibaarika jariwa'yua ruᵽu. Miba'irĩjia aᵽerãte mijiᵽatabe sawaᵽa tõᵽoerã. Suᵽabatirã wayuoka baairãte samijibe. Suᵽa mibaarãkareka Tuᵽarã ᵽõ'irã eyatirã rĩkimabaji sawaᵽa mitõᵽorãñu. Suᵽa imarĩ ñañu uᵽakaja miyi'rirãka be'erõ'õᵽi yika wãrũrimaji imaokaro'si mi'tabe,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","I'suᵽaka kire kẽᵽakã'ã ã'mitiritirã, rĩkimakaja ba'irĩjika imaki imarĩ, ba'iaja kiᵽuᵽariwa'rika. ");
INSERT INTO tnc_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ke'rika be'erõ'õ kika wãrũrimajare ĩatirã ikuᵽaka Jesúre ãrĩka: —Rĩkimakaja ba'irĩjia rikairãro'si “Tuᵽarãte takaja yi'riwa'ri kiyaᵽaika uᵽakaja yibaarãñu”, ãrĩᵽuᵽajoarika ka'wisika sime,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","25","I'suᵽaka kẽᵽakã'ã ã'mitiritirã, marãkã'ã marĩwãrũberijĩka naro'si simaeka. I'suᵽaka nimamaka ikuᵽaka nare kibojaeka ate: —Mija ã'mitiᵽe yijeyomarã. “Ritaja Tuᵽarãte yaᵽaika uᵽakaja yibaaye'e”, ãrĩtirã kirirã najayaokaro'si ka'wisitaka sime ᵽo'imajaro'si. Ã'mitirikõrĩ je'e: Camello jo'baki imarĩ, ᵽeruᵽota koᵽea kiwaᵽu'ribeyu. I'suᵽakajaoka “Ñiᵽamaki kimamaka, Tuᵽarãte takaja yaᵽaika uᵽaka yibaarãñu”, rĩkimaka ba'irĩjia rikairãte ãrĩwãrũbesarãñu,— kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","I'suᵽaka kẽᵽakã'ã ã'mitirikoriberikarã imarĩ, natiyiaja jaibu'abaraka ikuᵽaka narĩka: —I'suᵽaka simarãkareka maki Tuᵽarãka õñia imajiᵽarũkika imabeyuka mirãkiyu,— narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","I'suᵽaka nimamaka ĩatirã ikuᵽaka Jesúre nare bojaeka: —Naᵽuᵽayariji tãrĩbeyurã ᵽo'imaja. I'suᵽaka simako'omakaja kire yi'yurãte Tuᵽarã ᵽõ'irã a'rirũkia, ritaja baawãrũiki kimamaka,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Suᵽa kẽᵽakã'ã, ikuᵽaka Ᵽedrote kire yi'rika: —Jia mia'mitiᵽe. Yija ba'irĩjia ja'ataraᵽarã imarĩ, mika yija imarijayu,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Toᵽi ikuᵽaka kire kiyi'rika: —Rita mijare yibojayu. Aᵽerãte Tuᵽarãrika bojarĩ a'yurã, narĩrãre ja'atawa'rirãñurã. Nabe'erõ'õkarã, naᵽaki, naᵽako, namakarã, nawi'ia suᵽabatirã narioaoka naja'atawa'ririjarirãñu, yirika bojariroka bojarĩ na'ririjarirãka ᵽoto. Yirirã imarĩ yirika bojaokaro'si narĩrãre ja'atawa'yurãte, jia Tuᵽarãte baarãñu. Maekaka ritaja rikabaraka nima rĩkimabaji Tuᵽarãte nare ĩjirãñu. Wi'ia, rioa, nabe'erõ'õkarã, naᵽakoarã suᵽabatirã rĩkimarãja makarãritiirã nimaerã Tuᵽarãte nare ja'atarãñu. I'suᵽaka simako'omakaja yire na'mitiriᵽẽaika simamaka ba'iaja aᵽerãte nare baarãñu. I'suᵽaka naro'si simarãka simako'omakaja õñia imajiᵽarika Tuᵽarãte nare ja'atarãñu. ");
INSERT INTO tnc_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Rĩkimarãja maekaka imatiyarimaja imakoᵽeirã, Tuᵽarã ᵽõ'irã neyarãka ᵽoto imatiyabeyurã najarirãñu. Aᵽerã rĩkimarãjaoka maekaka imatiyarimajamarĩrã imarã, Tuᵽarã ᵽõ'irã neyarãka ᵽoto imatiyairã najarirãñu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","I'suᵽaka nare kẽrĩka be'erõ'õ Jerusalénrã eyairõ'õrã imaeka ma'aᵽi na'rika. Torã a'ririjaᵽaraka kika wãrũrimajare kiruᵽutawa'rika. Kibe'erõ'õᵽi a'ᵽaraka ikuᵽaka najaibu'arijarika: “¿Dako baaerã kiruᵽu wayuᵽi'ribekaja Jerusalénrã ke'yu?”, narĩka. Kibe'erõ'õᵽi i'tarijarikarã ᵽo'imaja ᵽuri jimarĩa ba'iaja ᵽuᵽarikoᵽekarã. I'suᵽaka nimamaka ĩatirã, kika wãrũrimajaka takaja jaiokaro'si, ᵽo'imajamatorã nare ke'ewa'rika. Torã eyatirã “Ikuᵽaka simarãñu”, ãrĩwa'ri nare kibojaeka ba'iaja kire nabaariwã'imarĩrã baaekakaka. ");
INSERT INTO tnc_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Jia mija ã'mitiᵽe. Jerusalénrã ma'rirã baayu. Torã ĩ'rĩka imaki Ᵽo'imaja Ma'mire bojajããrũkika. I'suᵽaka kibaamaka kurarãka ĩᵽarimarã ᵽõ'irã, suᵽabatirã Moiséte jã'meka wãrõrimaja ᵽõ'irãoka yire ne'ewa'rirãñu. Suᵽa imarĩ yire ne'etorirãka ᵽoto “Majããrũkika kimarũ”, yireka narĩrãñu. Suᵽabatirã “Ãja'a, kire mija jããbe”, ãrĩwa'ri judíotatamarĩrãte yire nijirãñu. ");
INSERT INTO tnc_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Suᵽabatirã ba'iaja yire naᵽo'imajĩ'ĩrãñu. I'suᵽakajaoka yire narijo'kaᵽaterãñu. Ajeaᵽi yire naᵽajerãka be'erõ'õ yire najããrãñu. I'suᵽaka nabaako'omakaja, maekarakarĩmi be'erõ'õ õñia yijariᵽe'rirãñu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Toᵽi Zebedeo makarã Santiago, Juanᵽitiyika Jesús ᵽõ'irã eyatirã, ikuᵽaka kire narĩka: —Mia'mitiᵽe wãrõrimaji. Mire yija jẽñeika miyi'ririka yija yaᵽayu,— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","I'suᵽaka kire naᵽakã'ã, ikuᵽaka kiyi'rika: —¿Marãkã'ã mijaro'si yibaarika mija yaᵽayu?— ");
INSERT INTO tnc_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","I'suᵽaka kẽᵽakã'ã ikuᵽaka kire narĩka: —Ᵽemawa'ribaji wejeareka ritaja ᵽo'imajare mijã'merãñurĩmi seyarãka ᵽoto ikuᵽaka yijare mibaarika yija yaᵽayu: Ĩ'rĩkate ritaᵽẽ'rõto, aᵽikate kãkoᵽẽ'rõtoᵽi yijare miruᵽarũjebe mire jeyobaabaraka yija imaokaro'si,— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","I'suᵽaka naᵽakã'ã, ikuᵽaka nare kẽrĩka: —Yire mija jẽñekoᵽeikakaka jia õrĩwãrũbeyurã mija ime. Ba'iaja ᵽo'imajare yire jũarũjerãñu. Yijũarãka uᵽakaja jũaokaro'si ¿yaje mija rakajeᵽããwãrũjĩñu je'e mijaro'sioka?— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Ã'ã, rakajeᵽããwãrũjĩñurã yija,— kire narĩka. I'suᵽaka naᵽakã'ã ikuᵽaka nare kẽrĩka: —Rita mijare yibojayu. Ba'iaja yijũarãka uᵽakaja ba'iaja mija jũarãñu mijaro'sioka. ");
INSERT INTO tnc_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","I'suᵽaka simako'omakaja mija yaᵽaika uᵽaka mijare ñimarũjewãrũbeyu. Ritaᵽẽ'rõto, kãkoᵽẽ'rõtorã yika ruᵽarũkirãte Yiᵽaki Tuᵽarãte wã'marãñu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","I'suᵽaka kire narĩka, aᵽerã Jesúka wãrũrimaja ĩ'ᵽaᵽitarakamarã imaekarãte ã'mitirika. Suᵽa imarĩ Santiago, Juanre ã'mitiritirã, “ ‘Aᵽerãte tẽrĩwa'ribaji yija ime’, noñu ruku”, ãrĩwa'ri naboebarika. ");
INSERT INTO tnc_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","I'suᵽaka nimamaka ĩatirã, nare akatirã ikuᵽaka Jesúre nare ãrĩka: —Ritaja wejeakarã ĩᵽarimarã naᵽo'imajare jãjiaᵽi jã'merijayurã, nayaᵽaika uᵽakaja nare baawã'imaᵽaraka. I'suᵽaka nare nabaaika õñurã mija ime. ");
INSERT INTO tnc_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mija ᵽuri, nuᵽaka imabekaja. Yirirã imarãro'si ikuᵽaka sime: Mija watoᵽekarã ĩᵽi imariyaᵽaiki, “Ikuᵽaka ᵽo'imajare yaᵽayu”, ãrĩwa'ri nayaᵽaika uᵽakaja aᵽerãte jia kibaajĩkareka jia sime. ");
INSERT INTO tnc_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Imatiyarimaji imarika yaᵽaiki ᵽuri, aᵽerãte kijeyobaajĩkareka jia sime. I'suᵽaka imawa'ri naro'si ba'irabeĩjirimaji uᵽakaja kiba'iraberijarijĩkareka jia sime. ");
INSERT INTO tnc_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","I'suᵽaka simamaka, Ᵽo'imaja Ma'mi ñimako'omakaja “Yiro'si ᵽo'imajare ba'irabeĩjirũ”, ãrĩwa'rimarĩa õ'õrã yi'taeka. I'suᵽaka imabekaja ᵽo'imajare jeyobaarimaji imaokaro'si õ'õrã yi'taeka. Suᵽa imarĩ ba'iaja nabaaika waᵽa naro'si reyarĩ õ'õrã yi'taeka,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesús kika wãrũrimajaᵽitiyika Jericó wejearã nimaeka be'erõ'õ, toᵽi na'rika rĩkimarãja aᵽerãᵽitiyika. Naka ke'rika ma'arijerã ĩabeyuka Timeomaki, Bartimeore ruᵽaeka. Wayuoka baaiki imarĩ, niñerũ aᵽerãte kijẽñeroyika. ");
INSERT INTO tnc_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","“Jesús Nazaretkaki o'yuka”, naᵽakã'ã ã'mitiritirã jãjia akasererikaᵽi ĩabeyukate kire akaeka. —Mia'mitiᵽe Jesús. Ĩᵽi David imaekaki riᵽarãmi mime. Ritaja ᵽo'imajare mijã'meokaro'si Tuᵽarãte wã'maekaki, yire miwayuĩabe,— ĩabeyukate kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","I'suᵽaka kiakaseremaka ã'mitiriwa'ri, rĩkimarãja ᵽo'imajare kire waᵽeka “Miakaserea'si”, ãᵽaraka. I'suᵽaka narĩkoᵽeko'omakaja jãjibaji kiakasereka. —Mia'mitiᵽe David riᵽarãmi. Yire miwayuĩabe,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","I'suᵽaka kiakasereka ã'mitiritirã, Jesúre tuirĩkaeka mae. —Kire mija akabe yiᵽõ'irã ki'taokaro'si,— ᵽo'imajare kẽrĩka. Suᵽa kẽᵽakã'ã ĩabeyukate nakaeka. —Okajãjia mijaᵽe. Suᵽabatirã mimi'mirĩkabe. Jesúre mire akayu,— ᵽo'imajare kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","I'suᵽaka naᵽakã'ã ã'mitiritirã, ᵽemakato kijariroaka e'etatirã, mi'maari ñojimarĩji Jesús ᵽõ'irã ke'rika. ");
INSERT INTO tnc_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Kiᵽõ'irã keyaeka ᵽoto, ikuᵽaka Jesúre kire ãrĩka: —¿Marãkã'ã mire yibaarika miyaᵽayu?— —Mia'mitiᵽe wãrõrimaji. Jia ĩaiki yire mijariᵽe'rirũjerika yiyaᵽayu ate,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","I'suᵽaka kẽᵽakã'ã, ikuᵽaka kire kiyi'rika: —Yire ã'mitiriᵽẽawa'ri “Jesúre yire jierãñu”, merĩᵽuᵽajoamaka, mire yijieyu mae,— kire kẽrĩka. I'suᵽaka kẽrĩka ᵽotojo ĩabeyukate yoiki jarika mae. Suᵽa imarĩ, —Miᵽe'ririyaᵽaye'e, miᵽe'ᵽe mae,— Jesúre kire ãrĩka. I'suᵽaka kẽrĩko'omakaja Jesús be'erõ'õ ĩabeyuka imakoᵽekakite a'rika. ");
INSERT INTO tnc_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Jerusalén i'tara'arĩ Olivos wãmeika ĩmimakarã neyaeka. Torã ĩ'ᵽaweje wejea imaeka. Betagé, Betania wãmeika simaeka. Jerusalén koyikurirã eyatirã, ikuᵽaka kika wãrũrimaja ĩ'ᵽarãte kẽrĩka: —Maruᵽurõ'õrã imawejearã mija a'ᵽe. Torã burrowẽko makarãka ĩ'rĩka ji'aᵽããeka mija tõᵽorãñu. Ni'i ĩ'rĩkaoka ᵽo'imajire marĩᵽeikoribeyuka kime ruᵽu. Kire kutetirã, kire mija e'era'abe. ");
INSERT INTO tnc_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Aᵽerãte mijare jẽrĩamaka: “¿Dako baaerã kire mija e'ewa'yu?”, narĩrãka, ikuᵽaka mija yi'ᵽe: “Maiᵽamakire kire yaᵽayu. Suᵽa imarĩ sayija e'ewa'yu. Ñojimarĩji sakiᵽe'atarãñu ate”, ãrĩwa'ri nare mija bojabe,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","I'suᵽaka kẽrĩka ã'mitiritirã, na'rika. Torã eyatirã ma'arã burrowẽko makarãka niatõᵽoeka. Koᵽereka wã'tarã naji'aᵽããekaki kimaeka. Kire tõᵽotirã kire nakuteka. I'suᵽaka nabaamaka ĩatirã torã imaekarãre ikuᵽaka nare jẽrĩaeka: —¿Dako baaerã burrowẽko makarãka mija kuteyu?— narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","I'suᵽaka naᵽakã'ã ã'mitiritirã, Jesúre nare ãrĩrũjeka uᵽakaja nare nayi'rika. Suᵽa imarĩ “Jee, samija e'ewa'ᵽe”, narĩka burrowẽko ba'iᵽarã. ");
INSERT INTO tnc_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Suᵽa imarĩ Jesús ᵽõ'irã sane'ewarika. Suᵽabatirã sayaᵽãia nacamisa ᵽemarã nataᵽiaekaᵽi burrowẽko makarã ᵽemarã naᵽa'aeka. Saᵽa'aweatirã ne'eeyaeka ᵽotojo saᵽemarã kimarĩro'ika. ");
INSERT INTO tnc_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Rĩkimarãja ᵽo'imaja sayaᵽãia ᵽemakato e'etatirã ke'rika wãjitãji sanajitaᵽãᵽeka. “Yija ĩᵽamaki mime”, ãrĩwa'ri i'suᵽaka nabaaeka jiyiᵽuᵽaka kire õrĩwa'ri. Aᵽerã wejeriᵽũñua e'etirã ja'aᵽãᵽekarã ke'rika wãjitãji. ");
INSERT INTO tnc_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Suᵽa imarĩ Jesúre ruᵽutaekarã, kibe'erõ'õ imaekarãoka jimarĩ najiiwariarika jĩjimaka imawa'ri. —“¡Jiitaki kime Tuᵽarã!”, ᵽo'imajare ãrĩrũ. ¡Mare kijã'meokaro'si Maiᵽamakite ᵽũataekakire etayu! Jia Tuᵽarãte kire baarũ ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mañeki David imaekaki riᵽarãmite etayu mae. Suᵽa imarĩ jia maro'si sime Tuᵽarãte maro'si ᵽũataekakiᵽi ãrĩwa'ri. I'suᵽaka kibaamaka “Tuᵽarã, mabo'ikakuriᵽi imaki, tẽrĩwa'ribaji jiika mime”, nimauᵽatiji ᵽo'imajare ãrĩrũ,— ãrĩwa'ri najaika jĩjimaka imawa'ri. ");
INSERT INTO tnc_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","I'suᵽaka nañuju Jerusalén wejearã Jesúre eyaeka. Torã eyatirã Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã kikãkaeka. Torã kãkatirã ritaja kĩaᵽibataeka. I'sia be'erõ'õ sarã'irã baamaka, Betaniarã kiᵽe'riwa'rika, ĩ'ᵽoũ'ᵽuarãe'earirakamarã kika wãrũrimajaᵽitiyika. ");
INSERT INTO tnc_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Aᵽerĩmi Betaniawejeaᵽi no'riwa'rika. O'riwa'ritirã na'ririjarika ᵽoto Jesúre kẽsirabaeka. ");
INSERT INTO tnc_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Yoeᵽi higuera wãmeika õteriki ritajũkia õimaka kĩaeka. Jia ᵽũñuijũki sõimaka “Rĩkimakaja rikaika sime je'e”, kẽrĩᵽuᵽajoaeka. I'suᵽaka simako'omakaja sawã'tarã eyatirã saᵽũñutakaja simamaka kĩaeka. Rikamarĩa simaeka, sarikayu jẽ'rãmarĩa simaeka imarĩ. ");
INSERT INTO tnc_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Rikamarĩjũki simamaka ĩatirã, ikuᵽaka sakẽrĩka: —Aᵽekurioka mirika ᵽo'imajare ba'arũkimarĩa mimarãñu,— ãrĩwa'ri sakikumuᵽurika. I'suᵽaka kijaika kika wãrũirãte ã'mitirika. ");
INSERT INTO tnc_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ate Jerusalénwejearã eyatirã Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iᵽẽte imaekarõ'õrã kikãkaeka kika wãrũrimajaᵽitiyika. Torã kãkaeyatirã waruaᵽaraka, waᵽaĩjibaraka imaekarãte kĩaeka. Suᵽabatirã aᵽetatarãrika niñerũ o'ae'ebaraka imaekarãte ĩatirãoka nare kiᵽoataeka. Niñerũ o'arimajare naniñerũ ᵽeatarũkirõ'õ kituriña'ruᵽateka. Suᵽabatirãoka niñerũ e'eokaro'si okoiᵽakoa ĩjirimaja ruᵽarikũmua kituriña'rũeka. ");
INSERT INTO tnc_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","I'suᵽakajaoka, “Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iᵽẽteᵽi koyikuriji sime”, ãrĩwa'ri ba'irĩjia ne'ewa'riroyikarõ'õᵽi nare sake'ewa'rirũjeberika. ");
INSERT INTO tnc_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Suᵽabatirã ikuᵽaka ᵽo'imajare kiwãrõeka: —Kimajaroᵽũñurã o'oekarã ikuᵽaka Tuᵽarãte bojayu: “Ritaja tatarãte yika jaiokaro'si narẽrĩrũkiwi'i simarãñu yiwi'ia”, ãrĩwa'ri sabojayu Tuᵽarãrika o'oeka. Suᵽa imarĩ torã ba'irĩjia ĩjitirã niñerũ e'ebaraka mija ima kareba'arimaja wi'i uᵽaka samija baayu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","I'suᵽaka kẽᵽakã'ã ã'mitiritirã, “¿Marãkã'ã baatirã kire majããjĩñu?”, kurarãka ĩᵽarimarãre ãrĩᵽuᵽajoaeka, Moiséte jã'meka wãrõrimajaoka. “Jiitaka kiwãrõika”, ãrĩwa'ri ritaja ᵽo'imajare jaimaka ã'mitiritirã Jesúre nakĩkika. ");
INSERT INTO tnc_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Na'irã sajaᵽakã'ã Jerusalénrõ'õᵽi kika wãrũrimajaᵽitiyika Jesúre ᵽe'rika. ");
INSERT INTO tnc_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Aᵽerĩmi bikitojo na'rika ᵽoto higuerajũki rikamarĩa imaeka wã'tarã neyaeka. Torã eyatirã sarĩkoa ᵽitiyika ritaja jĩrĩᵽataeka simamaka niaeka. ");
INSERT INTO tnc_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Toᵽi mae Jesúre jaika mirãka Ᵽedrote ᵽuᵽajoatõᵽoeka. —Miabe wãrõrimaji. Samikumuᵽuraᵽaka be'erõ'õ sajĩrĩka ime mae,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","I'suᵽaka kẽᵽakã'ã ã'mitiritirã, ikuᵽaka Jesúre bojaeka kika wãrũrimajare: —Tuᵽarãte mija ã'mitiriᵽẽabe. “Kire yija jẽñerãka kiyi'rirãñu”, ãrĩᵽuᵽajoairã mija imabe. ");
INSERT INTO tnc_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Rita mijare ñañu. Tuᵽarãte ã'mitiriᵽẽaiki imarĩ, “Ĩmimaka riakarã ka'raña'rĩrũ”, kẽñu uᵽakaja kiro'si sabaarãñu. I'suᵽaka “Tuᵽarãte yiro'si baabesarãñu je'e”, ãrĩᵽuᵽajoabekaja mija jẽñebe. “Yijẽñeika uᵽakaja kiyi'rirãñu”, ãrĩᵽuᵽajoabaraka kire mija jẽñebe. I'suᵽaka mija ᵽuᵽajoarãkareka mija yaᵽaika uᵽakaja simarãñu. ");
INSERT INTO tnc_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Suᵽa imarĩ Tuᵽarãte jẽñetirã, “Yijẽñeika kiyi'ritiyayu”, mija ãrĩᵽuᵽajoabe mija ᵽuᵽakaᵽi. I'suᵽaka mija baarãkareka “Tuᵽarãte yi'rirãñu”, ãrĩwa'ri mijare yibojayu. ");
INSERT INTO tnc_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Tuᵽarãte jaibarakaja, mamarĩ ba'iaja aᵽerãte mijare baaika mija ye'kariᵽe. I'suᵽaka mija baabe, Maᵽaki mabo'ikakurirã imakioka ba'iaja mija baaika mijareka kiye'kariaokaro'si. I'suᵽaka simako'omakaja aᵽerãte ba'iaja baaika mija ye'kaririberijĩka, Maᵽaki mabo'ikakurirã imakioka ba'iaja mija baaika ye'kariaberijĩki kiro'si,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","I'sia be'erõ'õ Jerusalén wejearã ke'rika ate kika wãrũrimajaᵽitiyika. Torã eyatirã Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã kikãkaeka ᵽoto kurarãka ĩᵽarimarãre kiᵽõ'irã eyarĩkaeka, Moiséte jã'meka wãrõrimaja, suᵽabatirã judíorãka ĩᵽarimarãoka. ");
INSERT INTO tnc_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Torã eyatirã ikuᵽaka kire najẽrĩaeka: —¿Dako baaerã Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iaᵽi ᵽo'imajare miᵽoataraᵽe? Suᵽabatirã ¿makire jã'meikaᵽi i'suᵽaka mibaaraᵽe?— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","I'suᵽaka naᵽakã'ã, ikuᵽaka nare kiyi'rika: —Yi'ioka ĩ'rãba'ikaka mijare jẽrĩariyaᵽaiki. Yire mija yi'ᵽakã'ã ã'mitiritirã, yire jã'meiki wãmea mijare yibojarãñu. Ikuᵽaka mijare yijẽrĩariyaᵽayu: ");
INSERT INTO tnc_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Juanre ᵽo'imajare ruᵽuko'a jũjeokaro'si maki kire jã'mekaki? ¿Tuᵽarã kire jã'mekakikã'ã? ¿Ᵽo'imajaja kire jã'mekarã bai? Yire mija yi'ᵽe,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","I'suᵽaka kẽᵽakã'ã ã'mitiritirã, natiyiaja najaika. —¿Marãkã'ã kire mayi'rijĩñu ruku? “Juanre ᵽo'imajare ruᵽuko'a jũjerã Tuᵽarãte kire ᵽũataeka”, marĩjĩka, “¿Dako baaerã Juanre bojaraᵽaka mija yi'riberaᵽe?”, mare kẽrĩrãñu. ");
INSERT INTO tnc_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","I'suᵽaka simako'omakaja, “Ᵽo'imajaja Juanre jã'mekarã”, marĩjĩka, ᵽo'imajare mare boebarirãñu. “Tuᵽarã Juanre ᵽũataekaki kiro'si bojaĩjirimaji kimaokaro'si”, ᵽo'imajare ãrĩᵽuᵽajoaika simamaka, ¿marãkã'ã Jesúre mayi'rirãñu ruku?— natiyiaja najaibu'aeka. ");
INSERT INTO tnc_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Suᵽa imarĩ, —Õrĩbeyurã yija,— kire narĩka. I'suᵽaka naᵽakã'ã, —Jee, yire jã'mekaki wãmea mijare bojabesarãki yi'ioka,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Bojawãrõrikaᵽi ikuᵽaka ᵽo'imajare kiwãrõũ'mueka ate. —Ĩakõrĩ je'e: Ĩ'rĩka iyarioa õterimajire imaeka. Sõteweatirã sakiwaeta'teka. Suᵽabatirã iyaka mukerũkia kibaaeka iyaokoa e'eokaro'si. I'suᵽaka baaweatirã ĩmiᵽañakarã wi'ia kibaaeka sĩarĩᵽaraka nimarũkirõ'õ. I'suᵽaka baaweatirã aᵽerãte ikuᵽaka kẽrĩka: “Yirioa mija tuerãkareka iyaka mija e'erãkakaka mijare ñijirãñu.” Suᵽabatirã turitaᵽarĩ nare ke'ritaᵽaeka mae. ");
INSERT INTO tnc_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Iyaka rẽrĩka ᵽoto ĩ'rĩka kiro'si ba'irabeĩjirimajire kiᵽũataeka iyaka kiro'si imaeka ke'eokaro'si. ");
INSERT INTO tnc_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Iyarioarã keyaeka ᵽoto kire ñi'atirã rioa tuerimajare kire ᵽajeka, kire iyaka ĩjiriyaᵽaberiwa'ri. Toᵽi mae “Me'ᵽe”, kire narĩka. Suᵽa imarĩ dakomarĩaja kiᵽe'rieyaeka kire jã'meᵽũataekaki ᵽõ'irã. ");
INSERT INTO tnc_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Iyaka ke'eetabeᵽakã'ã ĩatirã, aᵽika ba'iraberimajire kiᵽũataeka iyaka kire e'erũjebaraka. Iyarioarã keyaeka ᵽoto, kiruᵽuko'arã kire naᵽajeta'ruika. I'suᵽaka kire baatirã tĩmarĩji kire najairiwã'imarĩka. ");
INSERT INTO tnc_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","I'suᵽaka kire nabaamaka ĩatirã, aᵽikate ate rioba'iᵽite ᵽũataeka. Torã keyamaka, rioa tuerimajare kire jããtorika mae. I'suᵽaka nare nabaawã'imaᵽakã'ã ĩawa'ri rĩkimarãre rioba'iᵽite ᵽũataeka. I'suᵽaka nare kiᵽũatako'omakaja ĩ'rãrimarãre jãjia naᵽajeka, aᵽerãte ᵽuri najããeka. ");
INSERT INTO tnc_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Suᵽa imarĩ kimaki ĩ'rĩkaja jariwa'rikaki mae. Jimarĩa kiwãtaki kimaeka. “Yimakire ᵽuri ‘Rioba'iᵽi maki kime’, ãrĩwa'ri kire nayi'rirãñu je'e”, kẽrĩᵽuᵽajoaeka. I'suᵽaka ᵽuᵽajoawa'ri kimakire ᵽiyia kiᵽũataeka mae. ");
INSERT INTO tnc_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","I'suᵽaka kiᵽuᵽajoaeka simako'omakaja rioba'iᵽi makire eyamaka ĩatirã, ikuᵽaka rioa tuerimajare jaibu'aeka: “Ika rioba'iᵽi maki kime. Kiᵽakire reyarãka be'erõ'õ kiro'si jariwa'rirũkia sime ika rioa. Kire majããerã ika rioa maro'si sajariwa'yaokaro'si”, narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","I'suᵽaka ᵽuᵽajoawa'ri kire ñi'atirã kire najããeka. Suᵽabatirã kiᵽo'ia riorijerã nataaeka. I'tojĩrãja sime ika majaroka,— Jesúre nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","I'suᵽaka nare bojaweatirã, ikuᵽaka ᵽo'imajare kijẽrĩaeka: —¿I'suᵽaka kiro'si ba'iraberimajare baaekarãte marãkã'ã rioba'iᵽite nare baarãñu ruku? Ikuᵽaka nare kibaarãñu: Rioa tuerimajare jããrĩ ke'rirãñu. Suᵽabatirã aᵽerãte rioa kĩarĩrĩrũjerãñu. ");
INSERT INTO tnc_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Mija ã'mitiᵽe. Tuᵽarã majaroᵽũñu ĩ'rãkõ'rĩmato ikuᵽaka bojaika ¿yaje mija ĩakoyu je'e? Ikuᵽaka Tuᵽarãro'si bojaĩjirimajire o'oeka: “Wi'ia baarimajare ãta ĩ'rõ taaeka. I'suᵽaka simako'omakaja, aᵽika i'sio ãtaᵽi wi'ia kibaamaka aᵽo ãta tẽrĩwa'ribaji imatiyaio sajarika. Nayaᵽaberikao imako'omakaja, i'sioᵽi ãrĩwa'riji maiᵽamaki Tuᵽarãte jia jiyia wi'ia baaeka. I'suᵽaka baaiki kimamaka, ‘Jiitaka sime’, jĩjimakaᵽi marĩᵽuᵽajoayu”, ãrĩwa'ri kibojaeka Tuᵽarãrika o'oekaki.— ");
INSERT INTO tnc_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","I'suᵽaka Jesúre ãᵽakã'ã ã'mitiritirã, judíotata ĩᵽarimarãre kire ñi'ariyaᵽaeka. “ ‘Rioa ba'iraberimaja uᵽaka nime’, mareka ãrĩwa'ri i'suᵽaka majaroka Jesúre mare bojako'o”, narĩᵽuᵽajoaeka. I'suᵽaka simako'omakaja ᵽo'imajare kĩkiwa'ri kire nañi'aberika. Suᵽa imarĩ toᵽi na'rika mae. ");
INSERT INTO tnc_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ĩ'rãrimaki fariseokaka ᵽuᵽajoairã, Herodes jeyomarãoka Jesús ᵽõ'irã eyaekarã, niᵽamarãre nare ᵽũataeka simamaka. “Jesúre jia yijare yi'riwãrũbesarãkareka, kire yija okabaarãñu”, ãrĩwa'ri kiᵽõ'irã neyaeka. ");
INSERT INTO tnc_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kiᵽõ'irã eyatirã ikuᵽaka narĩka: —Mia'mitiᵽe wãrõrimaji. Rita oyiaja bojaiki mime. Ᵽo'imajare mire jaiyuyekoᵽeika dakoa jo'abeyua mire. Imatiyairã, imatiyabeyurãro'sioka kĩkibekaja Tuᵽarãrikakaka wãrõiki mime. Suᵽa imarĩ ikuᵽaka mire yija jẽrĩayu: ¿Yaje Romawejeakaki ĩᵽire jã'meika uᵽakaja imᵽuestos kire yija waᵽaĩjijĩñu ruku? Kire yija waᵽaĩjijĩkareka ¿Moisés imaekakite jã'meka ba'iaja baairã yija jarijĩñu bai?— ");
INSERT INTO tnc_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","I'suᵽaka jiaᵽi kire narĩko'omakaja kire ᵽakirika naᵽakatarikoᵽeka Jesúre õrĩka. Suᵽa imarĩ ikuᵽaka nare kiyi'rika: —¿Dako baaerã mijare yiyi'yua ã'mitiritirã yire mija okabaariyaᵽayu? Ĩ'rãto niñerũ yiro'si mija e'era'abe ñiaokaro'si,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","I'suᵽaka kẽᵽakã'ã ã'mitiritirã, ĩ'rãto niñerũ kiro'si ne'era'aeka. Sĩatirã ikuᵽaka nare kẽrĩka: —¿Maki ᵽema sime samija ĩamaka? Suᵽabatirã, ¿maki wãmea sareka o'oeka sime?— nare kẽrĩka. I'suᵽaka kẽᵽakã'ã ikuᵽaka kire nayi'rika: —Ĩᵽi César ᵽema uᵽaka sime,— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","I'suᵽaka naᵽakã'ã ã'mitiritirã, ikuᵽaka nare kẽrĩka: —Ĩᵽi César rika ima kire samija ĩjibe. I'suᵽakajaoka Tuᵽarãrika ima kireje samija ĩjibe,— nare kẽrĩka. I'suᵽaka Jesúre ãᵽakã'ã ã'mitiritirã okamarĩaja najarika õrĩtiyaiki kime ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Suᵽa imarĩ ĩ'rãrimaki saduceokaka ᵽuᵽajoairãte eyaeka Jesúka jairĩ. “Ᵽo'imajare reyarãka be'erõ'õ õñia jariᵽe'ririka imabeyua”, ãñurã nimaeka. Suᵽa imarĩ Jesúre sakaka jẽrĩaokaro'si kiᵽõ'irã neyaeka. ");
INSERT INTO tnc_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Mia'mitiᵽe wãrõrimaji. Ikuᵽaka maro'si Moisés imaekakite o'oeka: “Kima'mi makarãmarĩaja rũmure kireyataᵽajĩka, kima'mi rũmu mirãkote kibe'erõ'õkakire e'ejĩka marã imabeyua kika komakarãrirã”, ãrĩwa'ri Moisés imaekakite o'oeka,— kire narĩka. Suᵽabatirã ikuᵽaka narĩka ate: ");
INSERT INTO tnc_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","—Ĩakõrĩ je'e: Bikija ĩ'rĩkate imaeka. Ĩ'rõtẽñarirakamarã kibe'erõ'õkarãre imaeka. Mamarĩ kirõmie'eũ'mueka nama'mi. Makarãmarĩaja kirũmure kireyataᵽaeka. ");
INSERT INTO tnc_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Suᵽa imarĩ kotĩmite reyataᵽamaka kibe'erõ'õkakite kore e'eka ate. I'suᵽakajaoka makarãmarĩaja kireyaeka kiro'si. Suᵽa imarĩ kibe'erõ'õjĩtekaki koka imaekaki. Nuᵽakajaoka kireyaeka. ");
INSERT INTO tnc_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","I'suᵽakaja oyiaja kirĩrãre ritaja koka imakoriᵽatakoᵽeka. Koka makarãririmarĩaja nareyaᵽataeka. Nareyaᵽataeka be'erõ'õ koreyaeka narũmu imakoᵽeroyikako. ");
INSERT INTO tnc_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","“Ᵽo'imaja reyariᵽotojo õñia jariᵽe'rirãñurã”, ãñuka mime. Karemarĩa rita bojaiki mimarãkareka, ¿ritaja narũmu koimaeka simamaka, ni'ika kotĩmiaritiyarãñu ruku õñia kojariᵽe'rirãka ᵽoto?— saduceokaka ᵽuᵽajoairãte ãrĩka Jesúre. ");
INSERT INTO tnc_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","25","I'suᵽaka kire naᵽakã'ã, ikuᵽaka kiyi'rika: —Tuᵽarã majaroᵽũñurã o'oeka õrĩbeyurã mija ime. Suᵽabatirã “Ritaja baawãrũiki kime Tuᵽarã”, ãrĩwãrũbeyurã mija. I'suᵽaka imarã imarĩ, rukubaka ᵽuᵽajoairã mija ime. Õñia najariᵽe'rirãka ᵽoto rõmie'ebesarãñurã ᵽo'imaja. I'suᵽakajaoka simarãñu rõmijãro'si. Tuᵽarãte imarõ'õkarã ángelrãka uᵽaka ᵽo'imajare imarãñu. ");
INSERT INTO tnc_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mae reyariᵽotojo õñia ᵽo'imajare jariᵽe'rirũkiakaka mijare yibojaerã baayu. ¿Moisés imaekakite o'oekakaka ĩakoribeyurã mija bai je'e? Yaᵽumakarãka jũ'rẽika watoᵽekaᵽi Tuᵽarãte ikuᵽaka ãrĩka Moisés imaekakite: “Mija ñeki Abraham imaekaki jia yire baarijayuka. I'suᵽakajaoka Isaac suᵽabatirã Jacob imaekarã jia yire baarijayurã”, Tuᵽarãte kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","“Ĩ'rã maekarakamarã jia yire baabaraka imarijayurã”, Tuᵽarãte ãrĩka, õñia nimamaka. Tuᵽarã ᵽõ'irã nime, reyaekarã imariᵽotojo naririberika simamaka. Suᵽa imarĩ “Õñia ᵽo'imajare jariᵽe'ribesarãñu”, ãñurã imarĩ, tẽrĩrikaja rukubaka ᵽuᵽajoairã mija ime,— saduceokaka ᵽuᵽajoairãte kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Toᵽi mae saduceokaka ᵽuᵽajoairãte Jesúka jaika ᵽoto Moiséte jã'meka wãrõrimajire sã'mitiritirã, “Jia Jesúre nare yi'yu”, kẽrĩᵽuᵽajoaeka. Suᵽa ãrĩwa'ri Jesús ᵽõ'irã ke'rika kire jẽrĩaokaro'si. —¿Dika sime Tuᵽarãte jã'meika imatiyaika?— ãrĩwa'ri Jesúre kijẽrĩaeka. ");
INSERT INTO tnc_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","30","Suᵽa imarĩ ikuᵽaka kire kiyi'rika: —Tuᵽarãte jã'meika imatiyaikakaka ikuᵽaka sabojayu: “Mija ã'mitiᵽe Israelka'iakarã. Tuᵽarã ĩ'rĩkaja imaki Maiᵽamaki. Aᵽerãte mawayuĩaika tẽrĩwa'ribaji jia maiᵽamaki Tuᵽarãte mayi'ririjarijĩñu. I'suᵽakajaoka ritaja õrĩriᵽuᵽakirã maimaᵽitiyika jia Tuᵽarãte mayi'rijĩñu. Suᵽabatirã ĩ'rãmijiᵽiji ᵽuᵽajoatirã jia kire mabaarijarijĩñu”, ãrĩwa'ri sabojayu imatiyaika Tuᵽarãte jã'meika. ");
INSERT INTO tnc_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","I'sia rokajĩtekaka ikuᵽaka bojaika: “Maᵽo'ia mawãtaika uᵽakajaoka aᵽerãte mawãtajĩñu.” Dika aᵽea ika ĩ'ᵽakurikaka Tuᵽarãte jã'meika tẽrĩwa'ribaji imatiyaika imabeyua,— Moiséte jã'meka wãrõrimajire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Suᵽa kẽᵽakã'ã ikuᵽaka Jesúre kiyi'rika: —Rita meñu wãrõrimaji. Ĩ'rĩkaja kime Tuᵽarã. Maki aᵽika imabeyuka kiuᵽaka imaki. I'suᵽaka meñua rita sime. ");
INSERT INTO tnc_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","“Aᵽerãte mawãtaika tẽrĩwa'ribaji jia Tuᵽarãte mayi'ririjarijĩñu. Ritaja õrĩriᵽuᵽakirã maimaᵽitiyika jia Tuᵽarãte mayi'rijĩñu. Suᵽabatirã ĩ'rãmijiᵽiji ᵽuᵽajoatirã jia kire mabaarijarijĩñu. I'suᵽakajaoka maᵽo'ia mawãtaika uᵽakaja aᵽerãteoka mawãtajĩñu”, ãrĩwa'ri mibojaika imatiyaika sime. Moisés imaekakite jã'meka uᵽakaja Tuᵽarãte jia baawa'ri wa'iro'si ri'ia kiro'si majoeĩjiyu. I'suᵽaka mabaaika jia ima simako'omakaja Tuᵽarãte mayi'ririjayua, suᵽabatirã aᵽerãte mawãtarijayuaoka, tẽrĩrikaja imatiyaika sime,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jia kiyi'ᵽakã'ã ã'mitiritirã, ikuᵽaka Jesúre kire ãrĩka: —Yire meñua ña'mitiyuareka, “Tuᵽarã, miyaᵽaika uᵽakatakaja yibaarãñu”, ãrĩwãrũrũkika mime. Kirikitaki mimatiyarika kũᵽajĩji mire jariwa'yua je'e,— kire kẽrĩka. I'suᵽaka Jesúre ãᵽakã'ã ã'mitiritirã, ni'i ĩ'rĩkaoka kire jẽrĩaberikaki mae, “Mare tẽrĩwa'ribaji õñuka kime”, ãrĩᵽuᵽajoawa'ri. ");
INSERT INTO tnc_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã wãrõbaraka kimaekarõ'õᵽi ikuᵽaka ᵽo'imajare kẽrĩka: —“Jã'merũkika Tuᵽarãte wã'maekaki David imaekaki riᵽarãmi kimarãñu”, nañu Moiséte jã'meka wãrõrimaja. ¿Yaje rita nañu ruku jee? ¿Yaje kiriᵽarãmitakioka kimarãñu je'e mijareka? ");
INSERT INTO tnc_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","I'suᵽaka naᵽuᵽajoaika simako'omakaja, kiriᵽarãmireka ĩᵽi Davidre jaika ᵽoto, “Ñiᵽamaki mime”, kireka kẽrĩka. I'suᵽaka simamaka, David imaekaki Esᵽíritu Santore kire jeyobaaekaᵽi ikuᵽaka kio'oeka: “Ñiᵽamakire ikuᵽaka Tuᵽarãte ãrĩka: ‘Ritaja ᵽo'imajare jã'merimaji mimarãñu. Suᵽa imarĩ yiritaᵽẽ'rõtorã miruᵽabe. I'suᵽaka mimarãka simamaka mimajamarãre yitẽrĩrãñu mire nayi'yaokaro'si’, Tuᵽarãte kire ãrĩka”, ãrĩwa'ri David imaekakire o'oeka. ");
INSERT INTO tnc_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Ñiᵽamaki mime”, ĩᵽi Davidre kire ãᵽakã'ã, ¿yaje ruku kiriᵽarãmitakiji kime je'e? Davidre tẽrĩwa'ribaji kimema,— nare kẽrĩka. Jia nare kiwãrõmaka ã'mitiritirã, rĩkimarãja torã imaekarãte jĩjimaka jarika. ");
INSERT INTO tnc_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ikuᵽaka ᵽo'imajare kiwãrõeka ate: —Moiséte jã'meka wãrõrimajare baarijayu uᵽaka mija baakoreka jia mija ᵽuᵽajoabe. Mija ĩabe, ikuᵽaka nabaarijayu. “Imatiyairã yija ime”, ãrĩᵽuᵽajoairã imarĩ, jariroaka jía jããtirã ᵽo'imajare ĩaika wãjitãji naturirijayu. Suᵽabatirã wejeñe'metãji na'ririjayu ᵽoto jiaᵽi aᵽerãte nare jẽñerika nayaᵽayu. ");
INSERT INTO tnc_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Rẽrĩriwi'iarã nakãkaika ᵽoto imatiyarimajare ruᵽarõ'õrã oyiaja naruᵽariyaᵽarijayu. Baya nabaarijayu ᵽoto i'suᵽakajaoka imarika nayaᵽayu. ");
INSERT INTO tnc_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","“Jia baairã maime”, ãrĩriᵽotojo, nañu uᵽakaja baabeyurã nime. Natĩmiarãte reyataᵽaekarãte ᵽakitirã, naba'irĩjia, nawi'iaoka nareka ne'marijayu. I'suᵽaka wayuoka baairãte wayuĩabeyurã imariᵽotojo ᵽo'imajare ĩaika wãjitãji, ñoaka Tuᵽarãka najaiyu. “Tuᵽarãte yaᵽaika uᵽakaja jia baairã nime”, ᵽo'imajare ãrĩᵽuᵽajoarũ ãrĩwa'ri i'suᵽaka kika najairijayu. I'suᵽaka nabaakoᵽeika jiamarĩa sime. I'suᵽaka ba'iaja nabaaika waᵽa, waᵽaĩjibaraka jimarĩa ba'iaja najũarãñu. Nuᵽaka mija baa'si jia mija ᵽuᵽajoabe,— Jesúre ãrĩka ritaja ᵽo'imajare. ");
INSERT INTO tnc_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã niñerũ jããrũkia wã'tarã Jesúre ruᵽaeka. Ᵽo'imajare niñerũ jããika kĩarijarika. Rĩkimaka ba'irĩjia rikairã rĩkimakaja niñerũ i'sikotorã jããekarã. ");
INSERT INTO tnc_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","I'suᵽaka nabaairõ'õrã wayuoka baaikote eyaeka. Kotĩmite reyataᵽaekako koimaeka. Ĩ'ᵽato niñerũ yabirĩjiaka i'sikotorã kojããeka. Cobrekaka simaeka imarĩ, waᵽajã'rĩmarĩa simaeka koniñerũjĩka. ");
INSERT INTO tnc_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Suᵽa imarĩ kika wãrũrimajare akatirã ikuᵽaka nare kẽrĩka: —Jia mija ã'mitiᵽe. Wayuoka baaiko imariᵽotojo jia Tuᵽarãro'si i'kore ĩjiyu. Rĩkimaka ba'irĩjirã ᵽemajĩrã ĩjiko koime. ");
INSERT INTO tnc_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Rĩkimakaja ba'irĩjirã ᵽuri rĩkimaka niñerũ rikairã. Sakaka nijika simako'omakaja rĩkimakaja sajariwa'yu narika ruᵽu. I'ko ᵽuri wayuoka baaiko imariᵽotojo korikaikajĩka simauᵽatiji ĩjiᵽataiko. Ba'arika kowaᵽaĩjirũkia imakoᵽeikaja Tuᵽarãte kõjiᵽatayu,— kika wãrũrimajare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'ia kimaekarõ'õᵽi kiᵽorika ᵽoto ikuᵽaka ĩ'rĩka kika wãrũrimajire kire ãrĩka: —Miabe wãrõrimaji. Jiitaka sime i'sia wi'ia. Jia jo'bari'o ãtakaka baaeka sime,— Jesúre kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","I'suᵽaka kẽᵽakã'ã ã'mitiriwa'ri, ikuᵽaka Jesúre kire yi'rika: —Maekaka jiiwi'i samija ĩaika simako'omakaja, ñamajĩ ᵽo'imajare kuyeᵽaterũkia sime. Suᵽa imarĩ ika wi'iakaka ãta ĩ'ᵽari'o tuaᵽeᵽeka ᵽeyubesarãka, saririᵽatarãka simamaka,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","I'sia be'erõ'õ Olivos wãmeika ĩmimaᵽemarã eyatirã Jesúre ruᵽaeka. I'sia ĩmima wãjitãji ñoakuri ᵽañakarã Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'ia imaeka. Ᵽedro, Santiago, Juan, Andréᵽitiyika Jesús ᵽõ'irã na'rika naro'siji kire jẽrĩaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Mibojaika, ¿marãᵽate i'suᵽaka simarãñu? I'suᵽaka simarũki ruᵽu, ¿dakoa yija ĩaũ'murãñu ruku?— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","I'suᵽaka naᵽakã'ã, ikuᵽaka nare kiyi'rika: —Jia mija ᵽuᵽajoabe aᵽerãte mijare ᵽakikoreka. ");
INSERT INTO tnc_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mija ĩabe. “Ᵽo'imajare yijã'meokaro'si Tuᵽarãte ᵽũataekaki ñime”, ãᵽaraka rĩkimarãja ᵽakirimajare eyarãñu. I'suᵽaka baawa'ri rĩkimarãja ᵽo'imajare naᵽakirãñu. ");
INSERT INTO tnc_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mija koyikurirã imarãñurãte jĩrĩrãka ã'mitiritirã, mija kĩkia'si. Aᵽewejeakarãre ᵽitã'mua jẽ'rãta'arãka ã'mitiritirã, mija kĩkia'sioka. I'suᵽaka simarijarirãka imariᵽotojo ñojimarĩtaka riribesarãka ritatojo wejea ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ĩ'rãtata jĩrĩrãñurã aᵽetataka. Suᵽabatirã ĩ'rãka'ireka imarã, aᵽeka'ireka imarãᵽitiyika jĩrĩrãñurã. Ĩ'rãrikõ'rĩmatorã ka'ia iyirãka. Suᵽabatirã ba'arika ᵽuᵽakã'ã, ba'arimarĩa ᵽo'imajare jarirãñu. I'suᵽaka jũairã imariᵽotojo satẽrĩwa'ribaji najũarijarirãñu ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Rakajekaja mija imabe. Mijare ñi'atirã ĩᵽarimarã ᵽõ'irã mijare ne'ewa'rirãñu. Suᵽabatirã rẽrĩriwi'itõsiarã mijare naᵽajeriwã'imarĩrãñu. Yire ã'mitiriᵽẽairã mija imamaka, ĩᵽarimarã wãjitãji mijare narĩkamarirũjerãñu. Na'mitirirãka wãjitãji yirika nare bojabaraka, “Jesúre ã'mitiriᵽẽairã yija ime”, mija ãrĩrãñu. ");
INSERT INTO tnc_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ritatojo wejea ririrã baarãka ruᵽu ritaja ᵽo'imajare yirika bojaᵽatarũkia simarãñu. ");
INSERT INTO tnc_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mijare ñi'atirã ĩᵽarimarã wãjitãji mijare ne'ewa'ᵽakã'ã, kĩkiwa'ri “¿Marãkã'ã nare mayi'rirãñu?”, ãrĩᵽuᵽajoabekaja mija imabe. Mija ãrĩrũkirõ'õjĩte eyarãka ᵽoto “Ikuᵽaka nare yija ãrĩrãñu”, ãrĩᵽuᵽajoairã mija imaokaro'si Esᵽíritu Santore mijare jeyobaarãñu. I'suᵽaka mijare kijeyobaarãka simamaka, ikiᵽi ãrĩwa'ri jia nare mija yi'riwãrũrãñu, mija õñu uᵽakaja mija ᵽuᵽajoikaᵽimarĩa,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ate nare kẽrĩka: —Yire yi'yurãte ikuᵽaka nabaarãñu. Ĩ'rĩka makarã imariᵽotojo yire yi'riᵽarea ĩ'rĩkate nañi'arũjerãñu kire najããokaro'si. Suᵽabatirã yire yi'yurã nimamaka naᵽakiji kimakarãte jããrũjerãki. I'suᵽakajaoka yire yi'yurãte ã'mijĩawa'ri naᵽakiarã majamarã jaritirã namakarãja nare jããrũjerãñurã. ");
INSERT INTO tnc_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yire ã'mitiriᵽẽairã mija imamaka ĩawa'ri, ritaja ᵽo'imajare mijare ã'mijĩarãñu. I'suᵽaka simako'omakaja yire yi'ririja'atabeyurãte takaja ba'iaja imarika tiyibeyurõ'õrã a'rirũkirã nimakoᵽeikareka Tuᵽarãte nare wayuĩarãñu. ");
INSERT INTO tnc_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Tuᵽarãte bojaĩjirimaji imaekakite o'oeka uᵽakaja “Ĩ'rãrĩmi Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã ĩ'rĩka ba'iaja baarimaji kimarũkimatorãja kimarãka mija ĩarãñu.” (Yi'i Marcos ika ᵽaᵽera yo'oika ĩarãñurã, jia samija õrĩwãrũbe). Tuᵽarãte yaᵽaberitiyaika kibaarãka ᵽoto Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'ia ba'iaja kijarirũjerãñu. I'suᵽaka simarãka ĩawa'ri, ñojimarĩji Judea ka'iarã imarãte ᵽusiarã ru'rimirĩrãkareka jia naro'si simarãñu. ");
INSERT INTO tnc_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kiwi'i ᵽemarã imarãki toᵽi ruitirã, kiba'irĩjia e'erĩ kiwi'iarã kãkabekaja ñojimarĩji kiru'rirũ. ");
INSERT INTO tnc_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Rioa ba'irabebaraka imarãkioka, wi'iarã ima kicamisa ᵽemaᵽi kijããrijayuto e'erĩ kiᵽe'riberijĩñu. ");
INSERT INTO tnc_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Rõmijã yata imarãñurãro'si ka'wisika simarãñu naru'yaokaro'si. Ũᵽubaka me'rãka rikarãñurãro'sioka i'suᵽakaja simarãñu. ");
INSERT INTO tnc_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ᵽu'ejẽ'rãka simarãka ᵽoto i'suᵽaka simakoreka Tuᵽarãte mija jẽñebe. ");
INSERT INTO tnc_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","I'suᵽaka simarãka ᵽoto ba'itakaja ritaja ᵽo'imajare jũarãñu. Tuᵽarãte wejea ᵽo'ijiaekarãja ba'iaja najũarijarika ᵽemawa'ribaji ba'iaja ᵽo'imajare jũarãñu i'sia ᵽoto. I'suᵽaka simarãka be'erõ'õᵽi ᵽuri aᵽekurioka i'suᵽaka imarũkiaro'si marĩa simarãñu mae. ");
INSERT INTO tnc_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","I'suᵽaka simako'omakaja “Ñoaitakaja i'suᵽaka jũabaraka nima'si, i'tojĩrãja simarũ”, Tuᵽarãte ãrĩrũkimarĩa simarikareka ritaja, ĩ'rĩkaoka jariwa'ririmarĩaja ᵽo'imajare ᵽurijããeka. I'suᵽaka imarũkia simako'omakaja kiwã'maekarãte wayuĩawa'ri ñoaitakamarĩaja i'suᵽaka kimarũjerãñu. ");
INSERT INTO tnc_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Mija ĩabe õ'õrã Cristore ime”, ĩ'rĩka mijare ãrĩᵽakikoᵽerãkite mija ã'mitiriᵽẽa'si. Aᵽika ãrĩkaki, “Mija ĩabe õ'õrã kime Mesías, Jã'merũkika Tuᵽarãte wã'maekaki kime”, mijare ãrĩrãkiteoka mija yi'ria'si. ");
INSERT INTO tnc_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Rĩkimarãja ᵽakirimajare eyarãñu. Ĩ'rãrimarã “Yi'i imaki Jã'merũkika Tuᵽarãte wã'maekaki”, ãrĩrãñurã. Aᵽerã imarãñurã “Yi'i imaki Tuᵽarãro'si bojaĩjirimaji”, ãñurã. Suᵽabatirã ᵽo'imajare ᵽakiokaro'si niakoribeyua nare baabearãñurã. Tuᵽarãte wã'maekarã ᵽariji nare ã'mitiriᵽẽarika yaᵽawa'ri, i'suᵽaka nabaakoᵽerãñu. ");
INSERT INTO tnc_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Jia õrĩwãrũtirã, “I'suᵽaka simarãka”, mija õrĩrã ikuᵽaka mijare ñañu. Suᵽa imarĩ rakajekaja mija imabe. ");
INSERT INTO tnc_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ba'iaja ᵽo'imajare jũarãka be'erõ'õ aiyate ñamita'rirãñu. Ñamikakioka yaaboabesarãki. ");
INSERT INTO tnc_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Tã'ᵽia ña'rĩrãka. Ritaja wejeᵽemareka ima Tuᵽarãte rĩ'merũjerãñu. ");
INSERT INTO tnc_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","I'suᵽaka simarãka ᵽotojĩ ritaja Ᵽo'imaja Ma'mire niarãñu ate. Oko ũmakaka watoᵽekaᵽi jia yaaboaika, suᵽabatirã tẽrĩwa'ribaji yirikaᵽi yi'tarãñu. ");
INSERT INTO tnc_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Tuᵽarãte imarõ'õkarã ángelrãkare yiᵽũatarãñu yiwã'maekarãte narẽaokaro'si. I'suᵽaka nare yijã'memaka ritatojo wejeareka ᵽo'imaja ima uᵽatataja rẽarĩ naᵽibirãñu. ");
INSERT INTO tnc_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Higuera wãmeika õterikiakaka ᵽuᵽajoabaraka mijare yiwãrõerã baayu mae. Higuera ritajũkia saᵽũñua so'aika ĩatirã, “Kũᵽajĩ sajariwa'yu ijijẽ'rãka seyarũkia”, marĩwãrũyu. ");
INSERT INTO tnc_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Suᵽa imarĩ yibojaika uᵽakaja simaũ'murãka ᵽoto, “Kũᵽajĩ sajariwa'yu Ᵽo'imaja Ma'mire etarũkia”, mija ãrĩwãrũrãñu mae. ");
INSERT INTO tnc_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Rita sime ika mijare yibojaika. Yibojaika uᵽakaja simarãka ᵽoto ĩ'rãrimarã maekaka imarãte õñia imarãñu ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ika ka'ia, wejeᵽemaoka ririrũki oyiaja sime. I'suᵽaka simako'omakaja yirika ᵽuri ririrũkimarĩa sime. ");
INSERT INTO tnc_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Maki õrĩbeyuka yetarũkirĩmikaka. Mabo'ikakurirã imarã ángelrãkaoka õrĩbeyurã. Yi'i, Tuᵽarã Maki imariᵽotojo ñorĩbeyuoka yi'i. Maᵽaki Tuᵽarã ĩ'rĩkaja õñuka yetarũkirĩmikaka. ");
INSERT INTO tnc_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","I'suᵽaka simamaka õrĩweitikaja mija imabe. Sõrĩbeyurã imarĩ, rakajekaja mija imarijaᵽe. ");
INSERT INTO tnc_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Jia mija ã'mitiᵽe, ika bojawãrõrikaᵽi mijare yibojaerã baaika: Ĩ'rĩka wi'iba'iᵽi imaekaki. Turitaᵽarĩ ke'rika ᵽoto, kiro'si ba'irabeĩjirimajare wi'ia kĩarĩrĩrũjeka. Ke'rirã baaeka ruᵽu “Ika mija ba'iraberika imarãka”, nare kẽrĩka. Koᵽereka tuerimaji “Yire ta'abaraka, õ'õrãja wi'ia ĩarĩᵽaraka mimabe”, kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kiuᵽakaja ya'rirãñu yiro'sioka. Suᵽa imarĩ jia yire ta'abaraka mija imabe, yi'tarũkia mija õrĩbeyua simamaka. “Na'irã, ñami ñe'metãji, karaka akarãka ᵽotojĩ, wãrĩrika ru'ara'arãka ᵽoto, i'tojĩte ki'tarãñu”, yireka ãrĩwãrũbeyurã mija ime. ");
INSERT INTO tnc_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ikuᵽarõ'õᵽiji etatirã, “¿Dako baaerã mija kãñu, yiyaᵽaika uᵽaka baabekaja?”, mijare ñarĩkoreka, rakajekaja mija imarijaᵽe. ");
INSERT INTO tnc_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mijaro'sitakamarĩa ikuᵽaka yibojaweiyu ritaja ᵽo'imajaro'si. Jia imatikaja yire ta'atikaja mija imarijaᵽe,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Toᵽi mae, ĩ'ᵽarĩmi sajariwa'rika Ᵽascua baya ruᵽu. Levadura rukeberika ᵽan naba'aribaya simaeka. I'sia ᵽoto ᵽo'imajare õrĩbeyuju Jesúre ñi'arika kurarãka ĩᵽarimarãre ᵽakatarikoᵽeka, Moiséte jã'meka wãrõrimajaᵽitiyika. “¿Dikaᵽi kire okabaatirã kire majããrũjejĩñu?”, ãᵽaraka najaibu'aeka. ");
INSERT INTO tnc_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ikuᵽaka ĩ'rãrimakire ãrĩka: —Ᵽascua baya simarãka ᵽoto Jesúre mañi'ajĩkareka, jimarĩa ᵽo'imajare boebarijĩñu. Boebariwa'ri ba'iaja nabaajĩkareka, marãkã'ã baatirã nare mokajããwãrũberijĩñu. Suᵽa imarĩ Ᵽascua baya simarãka ᵽoto, kire mañi'aberijĩñu ruᵽu,— narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","I'sia ruᵽubaji ᵽañaka Betania wejearã kimaeka ᵽotojĩ, Simón kãmia rabaeka mirãki wi'iarã Jesúre imaeka. Torã ba'abaraka nimaeka ᵽoto ĩ'rãko rõmore naᵽõ'irã eyaeka, ãta alabastro wãmeikakaka jotoa baaeka rikatirã. Satõsiareka nardo wãmeika iyebaka imaeka jia jiijĩsiakaka. Suᵽabatirãoka waᵽajã'rĩtakakaka simaeka. Alabastrojotoku'rea ᵽeᵽaru'atatirã Jesús ruᵽuko'arã iyebaka koyo'yeka kire jiyiᵽuᵽayeewa'ri. ");
INSERT INTO tnc_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","I'suᵽaka kire kobaamaka ĩatirã, jimarĩa ĩ'rãrimarãre kore boebarika. I'suᵽaka imawa'ri, —¿Dako baaerã kiruᵽuko'arã iyebaka koyo'yeyu? Waᵽuju sakowe'weᵽateyu. ");
INSERT INTO tnc_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","I'sia iyebaka trescientos denario rõ'õjĩrã waᵽajã'rĩa sime. Sawaᵽa tõᵽotirã wayuoka baairãte koĩjirĩ imakoᵽeyu,— ãᵽaraka ĩ'rãrimarãre jaibu'aeka natiyiaja. I'suᵽaka ãᵽaraka kore najaiyuyeka. ");
INSERT INTO tnc_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","I'suᵽaka naᵽakã'ã, ikuᵽaka Jesúre nare ãrĩka: —Koimaᵽarũ. Jia yire baawa'ri i'suᵽaka kobaayu. ");
INSERT INTO tnc_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mija watoᵽekarã imajiᵽarũkirã nime wayuoka baairã. Suᵽa imarĩ mija yaᵽarãka ᵽotojo nare mija jeyobaarijarijĩñu. Yi'i ᵽuri mijaka imajiᵽabesarãki. ");
INSERT INTO tnc_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Iko ᵽuri koᵽuᵽaka kore jiyuika uᵽakaja jia yire baaiko. Yireyarũki ruᵽu iyebaka jia jiijĩsia yire koyo'yeyu. Yire nayayerũkia ᵽuᵽajoaweiko uᵽaka i'suᵽaka yire kobaayu. ");
INSERT INTO tnc_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Rita ika mijare yibojayu. Ritaja wejeareka Tuᵽarãrika wãrõbaraka, jia yire kobaaeka mirãka ᵽo'imajare bojarijarirãñu. Suᵽa imarĩ jia kobaaeka ᵽuᵽajoabaraka, kore naye'kariribesarãñu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Torãjĩrã mae kurarãka ĩᵽarimarãka jairĩ Judas Iscariotere a'rika. Jesúka wãrũrimaja ĩ'ᵽoũ'ᵽuarãe'earirakamarãkaki imaki kimaeka. “Jesúre mija ñi'aokaro'si, kimarõ'õrã mijare ye'ewa'rirãñu”, nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","I'suᵽaka nare kibojamaka ã'mitiritirã, jĩjimaka najarika. I'suᵽaka jariwa'ri, —Niñerũ mire yija ĩjirãñu,— kire narĩka. Suᵽa imarĩ “Ᵽo'imajamatorã Jesúre nañi'aerã, ¿marãkã'ã nare yibaarũjerãñu ruku?”, Judare ãrĩᵽuᵽajoaũ'mueka. ");
INSERT INTO tnc_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ᵽascua baya ũ'muroyikarĩmi levadura rukeberika ᵽan naba'aribaya seyaeka. I'sirĩmi oveja makarãka jããtirã naba'aroyika. Egiᵽtoka'iarã nañekiarãte imaeka ᵽoto Tuᵽarãte nare tããeka ᵽuᵽajoabaraka i'suᵽaka nabaaroyika. Suᵽa imarĩ kika wãrũrimajare ikuᵽaka kire jẽrĩaeka: —¿No'orã ba'arika baaweirĩ yija a'ririka miyaᵽayu, Ᵽascua baya ᵽoto maba'arũkia?— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Toᵽi ĩ'ᵽarã kika wãrũrimajare ᵽũataweibaraka ikuᵽaka nare kẽrĩka: —Wejearã mija eyarãka ᵽoto torã ĩ'rĩka jotoaᵽi okoa kõkewa'yukate mija ĩatõᵽorãñu. Kibe'erõ'õ mija a'ᵽe. ");
INSERT INTO tnc_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Kibe'erõ'õ a'ritirã, wi'iarã kikãkarãñurõ'õ ĩatirã, ikuᵽaka ãᵽaraka saba'iᵽite mija jẽrĩabe: “Yijare wãrõrimaji ikuᵽaka ãrĩko'oka: ‘¿No'orã sime yika wãrũrimajaka, Ᵽascua baya ᵽoto ba'arũkia nabaaweirũkirõ'õ?’, kẽrĩko'o”, mija ãᵽe. ");
INSERT INTO tnc_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","I'suᵽaka mija ãᵽakã'ã ã'mitiritirã, ĩmiᵽẽ'rõtorã ima kuraraka jo'barõ'õjĩte mijare kibearãñu. Koᵽakaja najietikarõ'õ simarãñu. Suᵽa imarĩ i'sia kurarakarã maba'arũkia mija baaweibe,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","I'suᵽaka nare kẽrĩka be'erõ'õ, torã na'rika. Torã eyatirã Jesúre nare bojaeka uᵽakaja simamaka niaeka. Torã Ᵽascua bayarĩmi naba'arũkia nabaaeka mae. ");
INSERT INTO tnc_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Rã'iwa'ri neiᵽuᵽurõ'õ sajarika ᵽoto Jesúre torã eyaeka kika wãrũrimaja, ĩ'ᵽoũ'ᵽuarãe'earirakamarã kika imaroyikarãᵽitiyika. ");
INSERT INTO tnc_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Naka ba'abaraka ikuᵽaka nare kibojaeka: —Mija ã'mitiᵽe. Rita mijare yibojayu mae. Mawatoᵽekarã ĩ'rĩka imaki maka ba'ariᵽotojo, yimajãmarãre yire ñi'aokaro'si yire bojajããrũkika,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","I'suᵽaka kẽᵽakã'ã ã'mitiritirã, ba'iaja naᵽuᵽarika. Toᵽi mae nimarakamakiji ikuᵽaka kire ãᵽaraka najẽrĩaũ'mueka: —¿Yi'imarĩka i'suᵽaka baarãki ruku?— ãᵽaraka kire najẽrĩaeka. ");
INSERT INTO tnc_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Toᵽi mae ikuᵽaka nare kiyi'rika: —Ĩ'ᵽoũ'ᵽuarãe'earirakamaki seroarã yika ᵽan ñu'aba'airãkaki kime. ");
INSERT INTO tnc_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tuᵽarã majaroᵽũñurã sabojaika uᵽakaja simaerã baayu yiro'si. Ᵽo'imaja Ma'mi ñime. Yire ñi'atirã ᵽo'imajare yire jããrãñu. “Aᵽerãte kire ñi'arũ”, ãrĩwa'ri yire bojajããrãki ᵽuri, jimarĩa ba'iaja jũarãki. I'suᵽaka simamaka imaberiri kimakoᵽeka,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ba'abaraka nimekã'ãja ᵽan Jesúre e'eka. Sarikatirã, “Jia mibaayu Tuᵽarã”, kẽrĩka. I'suᵽaka ãrĩtirã sañakatarutirã nare sakĩjika. —Ãja'a, samija ba'abe. Ika ᵽan koᵽakaja yiᵽo'ia sime,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","24","Toᵽi ate ko'a ke'eka. Sarikatirã, “Jia mibaayu Tuᵽarã”, kẽrĩka. I'suᵽaka ãrĩtirã nare sakĩjika. Suᵽa imarĩ nimarakamakiji sanukueka be'erõ'õ ikuᵽaka nare kẽrĩka: —Ika iyaokoa koᵽakaja yiriwea sime. Riweajurubaraka yireyarãkaᵽi ãrĩwa'ri rĩkimarãre Tuᵽarãte tããrãñu. I'suᵽaka yireyamaka ĩatirã, “Ba'iaja nabaaika yijũjerãñu”, Tuᵽarãte ãrĩka uᵽakaja kibaarãñu mae. ");
INSERT INTO tnc_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Rita mijare ñañu mae, Tuᵽarãte yire jã'merũjerũkia seyabeyukaji iyaokoa mijaka ukuokaro'simarĩa ñime. Yijã'meũ'murãñurĩmi seyarãka ᵽoto ᵽuri, aᵽeuᵽaka, mamaka iyaokoa yukurãñu mae,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Suᵽa imarĩ Tuᵽarã baya koyaweatirã Olivos wãmeika ᵽusiarã na'rika. ");
INSERT INTO tnc_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Torã na'rika ᵽoto ikuᵽaka nare kẽrĩka: —Yire ã'mitiriᵽẽairã imariᵽotojo yire mija ja'atarãñu. Suᵽa imarĩ yire ja'atawa'ri rakakaja mija ᵽibiᵽaterãñu. Tuᵽarã majaroᵽũñurã ãñu uᵽakaja simarãñu. Ã'mitirikõrĩ je'e: “Oveja ĩarĩrĩrimajire yijããrãñu. I'suᵽaka yibaamaka kioveja ru'riᵽatarãka”, ãrĩwa'ri sabojayu. ");
INSERT INTO tnc_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Suᵽa imarĩ yire najããko'omakaja õñia yijariᵽe'rirãñu. I'suᵽaka imatirã mija ruᵽubaji Galileaka'iarã yeyarãñu. Suᵽabatirã torã mijare ye'etorirãñu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","I'suᵽaka kẽᵽakã'ã ã'mitiritirã, ikuᵽaka Ᵽedrote kire ãrĩka: —Aᵽerã ᵽuri nimarakamakiji mire ja'atarãñurã je'e. Yi'i ᵽuri mire ja'atabesarãki,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","I'suᵽaka kẽᵽakã'ã ã'mitiritirã, ikuᵽaka Jesúre kire ãrĩka: —Rita mire ñañu. Ire ñamiji karaka ĩ'ᵽakuri akaerã baarãka ruᵽubaji, maekarakakuri, “Jesúre õrĩbeyuka yi'i”, nare merĩrãñu,— Ᵽedrote kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","I'suᵽaka Jesúre kire ãrĩko'omakaja, ikuᵽaka Ᵽedrote kire ãrĩka: —Jẽno'otaka, “Mire ñorĩbeyu”, ãrĩbesarãki yi'i. Mikaja reyarũkika ᵽariji ñima simamaka, “Jesúre õrĩbeyuka yi'i”, ñarĩbesarãñu,— Ᵽedrote kire ãrĩka. Ᵽedrote ãrĩka uᵽaka oyiaja ĩ'rĩka uᵽakaja narĩka aᵽerãoka. ");
INSERT INTO tnc_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Toᵽi mae Getsemaní wãmeirõ'õrã na'rika. Torã eyatirã kika imaekarãre ikuᵽaka kẽrĩka: —I'torã Tuᵽarãka jairĩ ya'yu. Õ'õrãja mija ruᵽabe ruᵽu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Torãjĩrã Ᵽedro, Santiago suᵽabatirã Juanre, kika ke'ewa'rika. Torã na'ririjayukã'ãja jimarĩ kiwayuᵽi'riũ'mueka. ");
INSERT INTO tnc_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","I'suᵽaka imawa'ri ikuᵽaka nare kẽrĩka: —Yiᵽuᵽakaᵽi yiwayuᵽi'ritiyayu “Reyatiyaerã yibaayu”, ãñurõ'õjĩrã. Õ'õrã mija tuibe ruᵽu. Kãᵽekaja yire mija ta'abe,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Suᵽabatirã ñoakuriᵽañakarã ke'rika. Torã eyatirã ka'iarã mo'iᵽãñatirã, Tuᵽarãka kijaika ba'iaja ã'mika jũarika yaᵽaberikoᵽewa'ri. ");
INSERT INTO tnc_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kika jaibaraka ikuᵽaka kire kẽrĩka: —A'bi, ritaja baawãrũiki mime. Suᵽa imarĩ yire najããkoreka, yire mijeyobaarika yiyaᵽayu. I'suᵽaka mire yijẽñeko'omakaja yiyaᵽaika uᵽakamarĩa mibaakoᵽejĩkaoka marã imabeyua. Miyaᵽaika uᵽakaja simarũ,— Tuᵽarãte kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tuᵽarãka jaiweatirã kiᵽe'riwa'rika maekarakamarãte imaekarõ'õrã. Kãrĩrikarekaja nosika ᵽotojĩ naᵽõ'irã keyaeka. I'suᵽaka nimamaka ĩatirã, ikuᵽaka Ᵽedrore kẽrĩka: —¿Simón, dako baaerã mikãñu? ¿Ĩ'rãkuri aiyajẽrã rõ'õjĩrãjĩkaja kãᵽekaja imaberijĩka mime bai je'e? ");
INSERT INTO tnc_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Rakajekaja Tuᵽarãte jẽñebaraka mija imabe, ba'iaja mija baakoreka. “Tuᵽarãte yaᵽaika uᵽakaja yija baarãñu”, ãñurã imariᵽotojo, mija ᵽo'iaᵽi ᵽuri samija rakajeᵽããwãrũbeyu. Suᵽa imarĩ Tuᵽarãte yaᵽaika uᵽakaja mija baawãrũbeyu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","I'suᵽaka nare ãrĩweatirã Tuᵽarãka jairĩ ke'rika ate. Mamarĩ kire kijẽñeka uᵽakajaoka kire kẽrĩka ate. ");
INSERT INTO tnc_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","I'suᵽaka baaweatirã kijeyomarã ᵽõ'irã kiᵽe'riwa'rika. Jimarĩa õõmaka nare baaeka simamaka kãrĩkarã nimaeka. I'suᵽaka nimaekarõ'õrã naᵽõ'irã keyamaka, tũrũtirã kiruᵽu ni'yoᵽi'rika. Suᵽa imarĩ marãkã'ã kire ãrĩwãrũberijĩñurã nimaeka. ");
INSERT INTO tnc_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Suᵽa nimekã'ãja Tuᵽarãka jairĩ ke'rika ate. I'sia be'erõ'õ naᵽõ'irã etatirã, —¿I'suᵽakaja kãᵽarakaja mija imañuju ruᵽu? Koᵽakaja yire nañi'arijẽ'rãka seyayu mae. Ᵽo'imaja Ma'mite nañi'aokaro'si bojajããrimajire koᵽakaja etayuju mae. Ba'iaja baarimajare yire kiñi'arũjerã baayu. ");
INSERT INTO tnc_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mija mi'mibe. Dajoa kire matoyari,— kika wãrũrimajare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","I'suᵽaka Jesúre jaiyuju Judare etaeka. Jesúka wãrũrimaji ĩ'ᵽoũ'ᵽuarãe'earirakamarãkaki Judare imaeka. Rĩkimarãja ᵽo'imajare i'taeka kika. Sara, yaᵽua rikabaraka Jesúre ñi'arĩ ni'taeka. Kurarãka ĩᵽarimarã, Moiséte jã'meka wãrõrimaja, suᵽabatirã judíorãka ĩᵽarimarãre ᵽũataekarã nimaeka. ");
INSERT INTO tnc_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","“Ikuᵽaka kire yibaarãñu”, ãrĩwa'ri Judare nare bojatikarã nimaeka. —Jesúre mija ĩawãrũokaro'si u'surikaᵽi kire yijẽñerãñu. I'suᵽaka yibaarãka be'erõ'õ kire ñi'atirã jia kire mija ĩarĩrĩwa'ᵽe,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","I'suᵽaka nare kẽrĩweaeka be'erõ'õ Jesús ᵽõ'irã eyatirã ikuᵽaka kire kẽrĩka: —¿Yaje mime wãrõrimaji?— I'suᵽaka kire ãrĩtirã kire kiu'sueka. ");
INSERT INTO tnc_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","I'suᵽaka kibaamaka ĩatirã, Jesúre nañi'aeka. ");
INSERT INTO tnc_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","I'suᵽaka kire nabaamaka ĩatirã, Jesús wã'tarã rĩkamarikaki sara baiwararĩ ke'etaeka. Saᵽi kurarãka ĩᵽamaki imatiyaiki ba'irabeĩjirimaji ã'mua kitoakõrõtaeka. ");
INSERT INTO tnc_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","—¿Dako baaerã sara, yaᵽuaᵽitiyika yire ñi'arĩ mija i'tayu? ¿Karee'erimajire ñi'arirokaᵽi yire mija ñi'ariᵽakatayu bai? ");
INSERT INTO tnc_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ĩ'rãrĩmi jariwa'ririmarĩaja mija watoᵽekarã Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iareka mijare wãrõbaraka ñimaroyi. Torã ñimarijaraᵽaka ᵽoto yire ñi'arĩ mija etaberaᵽe ruᵽu. Yire mija ñi'aika, Tuᵽarã majaroᵽũñurã sabojaika uᵽakaja sime yiro'si,— Jesúre nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Suᵽa imarĩ kire nañi'amaka ĩatirã, kika wãrũrimajare nimauᵽatiji kire ru'ritaᵽawa'rika. ");
INSERT INTO tnc_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kire ne'ewa'rika ᵽoto ĩ'rĩka bikirimaji kibe'erõ'õᵽi a'ririjarikaki. Sayaᵽãijĩka takaja wã'ojĩ'atirã kimaeka. Kibe'erõ'õ ke'ririjarika ᵽoto torã imaekarãte kire ñi'aᵽe'rotaeka. ");
INSERT INTO tnc_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","I'suᵽaka kire baakoᵽewa'ri kisayaᵽãitakaja kireka naba'itatamaka, dakomarĩaja kiru'riwa'rika. ");
INSERT INTO tnc_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Suᵽabatirã kurarãka ĩᵽamaki imatiyaiki imaekaki wi'iarã Jesúre ne'ewa'rika. Kire ne'eeyaeka ᵽoto kurarãka ĩᵽarimarãre nimauᵽatiji torã rẽrĩka. Moiséte jã'meka wãrõrimaja, suᵽabatirã judíorãka ĩᵽarimarãoka rẽrĩkarã. ");
INSERT INTO tnc_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","I'suᵽaka nabaaeka ᵽoto Ᵽedrore ñoakuriᵽi a'ririjaᵽaraka kurarãka ĩᵽamaki imatiyaiki wi'i ᵽẽteta'teka imaekarõ'õrã keyaeka. Torã kãkatirã Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'ia tuerimajaka kiᵽekajũrĩruᵽaeka. ");
INSERT INTO tnc_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","I'suᵽaka simaeka ᵽoto kurarãka ĩᵽarimarã, suᵽabatirã judíotatarã ĩᵽarimarã imatiyaitataoka “¿Dakoaᵽi Jesúre majããrũjejĩñu?”, ãrĩwa'ri jaibu'abaraka nimaeka. Suᵽa imarĩ “Ikuᵽaka ba'iaja Jesúre baaraᵽe”, ãrĩwa'ri bojarũkirãte nayaᵽakoᵽeka. I'suᵽaka nayaᵽaeka simako'omakaja ba'iaja oka kireka imaeka natõᵽoberika. ");
INSERT INTO tnc_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","“Ika ba'iaja Jesúre baaraᵽe”, rĩkimarãja narĩᵽakiko'omakaja ĩ'rĩkate bojaeka uᵽakamarĩa nabojakoᵽeka. ");
INSERT INTO tnc_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Ĩ'rãrimarã mi'mirĩkatirã imabeyuaᵽiji ikuᵽaka ãᵽaraka kire nokabaaeka: —“Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'ia ᵽo'imajare baaeka yiᵽoaᵽaterãñu. I'suᵽaka simako'omakaja maekarakarĩmi be'erõ'õjo ate sayibaarãñu, ᵽo'imajare baaekamarĩa”, Jesúre ãᵽakã'ã yija ã'mitiraᵽe,— narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","I'suᵽaka bojariᵽotojo ĩ'rĩka uᵽakamarĩa rukubaka oyiaja nabojaᵽakikoᵽeka ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Suᵽa imarĩ kurarãka ĩᵽamaki imatiyaiki nimauᵽati wãjitãji mi'mirĩkatirã ikuᵽaka Jesúre kijẽrĩaeka: —¿Dako baaerã nare miokae'eberitiyayu je'e? ¿Dakoaᵽi ãrĩwa'ri i'suᵽaka tĩmarĩtakaja mire nokabaayu je'e?— kurarãka ĩᵽamakire kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","I'suᵽaka kẽrĩko'omakaja Jesúre kire okae'eberika. I'suᵽaka kimekã'ãja ikuᵽaka kurarãka ĩᵽamakite kire jẽrĩaeka ate: —¿Mi'iji bai mime Jã'merũkika Kiwã'maekaki, Tuᵽarã Maki?— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","I'suᵽaka kire kẽᵽakã'ã ikuᵽaka Jesúre kire yi'rika mae: —Ã'ã, yi'iji ñime. Suᵽabatirã ñamajĩ Tuᵽarã ᵽõ'i ritaᵽẽ'rõtorã Ᵽo'imaja Ma'mite ruᵽamaka mija ĩarãñu. Suᵽabatirã ĩmiᵽi oko ũmaka watoᵽekaᵽi yiruira'amakaoka mija ĩarãñu,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","I'suᵽaka kẽᵽakã'ã ã'mitiritirã, boebariwa'ri kiõñu uᵽakaja kijariroaka ᵽemakato kurarãka ĩᵽamakire baibebataeka. “ ‘Tuᵽarã uᵽakaja ñime’, kẽñu ruku”, ãrĩwa'ri i'suᵽaka kibaaeka. I'suᵽaka baawa'ri ikuᵽaka aᵽerã ĩᵽarimarãre kẽrĩka: —Dika ba'iaja baaiki kime aᵽerãte ãrĩrũkia jariwa'ribeyua mae, koᵽakaja ritaja ba'iaja kẽñua morĩwãrũᵽatayu. ");
INSERT INTO tnc_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mijaoka ã'mitiriko'orã ba'iaja Tuᵽarãreka kijaiko'a. Suᵽa imarĩ ¿marãkã'ã kire mabaarãñu je'e mijareka?— ãrĩwa'ri kijẽrĩaeka kĩᵽarimarã jeyomarã imaekarãte. I'suᵽaka kẽᵽakã'ã ã'mitiritirã, —Oka ba'iaja kiro'si ima simamaka jããrikaja sime kire,— nimarakamakiji narĩᵽataeka. ");
INSERT INTO tnc_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Suᵽabatirã ĩ'rãrimarã Jesúre rijo'kataᵽatebaraka kiñakoa ᵽi'ᵽetãtetirã kire naᵽajeka. Kire ᵽajebaraka ikuᵽaka kire najẽrĩaroyika: —¿Maki mire ᵽajeiki? Karemarĩa Tuᵽarãte mire bojarãkareka, “Iki yire ᵽajeko'oka”, merĩrãñu,— kire narĩwã'imarĩka. Kire e'ewa'ᵽaraka Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'ia tuerimajaoka kiᵽema ᵽajerijarikarã. ");
INSERT INTO tnc_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","I'suᵽaka ba'iaja Jesúre baabaraka wi'itõsiarã nimaeka ᵽoto ᵽẽterãja Ᵽedrote imaeka ruᵽu. Torã kimaeka ᵽoto kurarãka ĩᵽamaki imatiyaikiro'si ba'iraberirõmore kiᵽõ'irã etaeka. ");
INSERT INTO tnc_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ᵽedrote ᵽekaõ'to wã'tarã jũrĩruᵽamaka ĩatirã, ñoaka kire koyoirĩkaeka. Toᵽi ikuᵽaka kire kõrĩka: —Mi'ioka Jesús Nazaretkakika turiroyiraᵽaki mime,— kire kõrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","I'suᵽaka kire kõᵽakã'ã, ikuᵽaka kore kiyi'rika: —I'suᵽaka meñua õrĩbeyuka yi'i, mijaikaoka ã'mitiriwãrũbeyuka yi'i,— kore kẽrĩka. I'suᵽaka kore ãrĩweatirã, koᵽereka imaekarõ'õᵽi kiᵽoriwa'rika ᵽoto karaka akaeka. ");
INSERT INTO tnc_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Toᵽi ate kire ĩatõᵽotirã ikuᵽaka torã imaekarãte kõrĩka: —Ĩ'ĩ imaki Jesúka wãrũrimajakakijioka kime,— nare kõrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","I'suᵽaka kõᵽakã'ã “Kika wãrũrimajimarĩki yi'i”, Ᵽedrote ãrĩka ate. Ñoaᵽañaka imatirã ate torã imaekarãte ikuᵽaka kire ãrĩka: —Mi'ioka naka imaekaki, Galileakaki mime je'e aᵽeyari,— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","I'suᵽaka naᵽakã'ã ikuᵽaka nare kiyi'rika: —¡I'suᵽaka mija ãñukate õrĩberitiyaiki're yi'i! Waᵽuju yiᵽakijĩkareka ba'iaja Tuᵽarãte yire baajĩñu,— kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","I'suᵽaka kẽñukã'ãja ate karaka akaeka. Sakamaka ã'mitiritirã, Jesúre kire bojaeka kiᵽuᵽakarã kire ña'rĩjãirarika, “Ĩ'ᵽakuri karaka akaerã baarãka ruᵽu maekarakakuri, ‘Jesúre õrĩbeyuka yi'i’, merĩrãñu.” I'suᵽaka Jesúre ãrĩka kire ña'rĩjãiraᵽakã'ã, jimarĩa Ᵽedrote orika. ");
INSERT INTO tnc_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Suᵽabatirã aᵽerĩmi bikitojo ĩᵽarimarã imatiyarimaja nimauᵽatiji rẽrĩkarã ate. Kurarãka ĩᵽamarã, Moiséte jã'meka wãrõrimaja, suᵽabatirã judíorãka ĩᵽarimarãoka torã nimaeka. Rẽrĩtirã “Ikuᵽaka Jesúre mabaajĩñu”, ãᵽaraka najaibu'aeka. Toᵽi mae, Jesús ᵽitaka ᵽi'ᵽetirã Ᵽilato ᵽõ'irã kire ne'ewa'rika. ");
INSERT INTO tnc_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Kiᵽõ'irã kire ne'eeyaeka ᵽoto ikuᵽaka Ᵽilatore kire jẽrĩaeka: —¿Mi'i bai judíotatarã ĩᵽamaki?— kire kẽrĩka. I'suᵽaka kire kẽᵽakã'ã, ikuᵽaka Jesúre kire ãrĩka: —Mi'iji ãñuka i'suᵽaka,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Suᵽabatirã kurarãka ĩᵽamarã rĩkimaka ba'iaja Ᵽilato wãjitãji Jesúre nokabaaeka. ");
INSERT INTO tnc_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Suᵽa imarĩ ikuᵽaka Ᵽilatore kire jẽrĩaeka ate: —¿Dako baaerã miokae'eberitiyayu je'e? ¿Ritaja mire nokabaaika mia'mitiribeyu bai je'e?— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","I'suᵽaka kire kẽrĩko'omakaja Jesúre okae'eberika ruᵽu. Kiokae'ebeᵽakã'ã ĩawa'ri, i'suᵽaka imaekakite ĩakoriberiroyikaki imarĩ, marãkã'ã ãrĩberijĩka Ᵽilatore jarika. ");
INSERT INTO tnc_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ĩ'rãkuri wejejẽ'rã rakakaja Ᵽascua baya simaroyika ᵽoto ĩ'rĩka wẽkomaka imariwi'iarã imakite Ᵽilatore ᵽoataroyika. I'suᵽaka kibaaroyika simamaka ĩ'rĩka sareka imaekakite kiᵽoatarika ᵽo'imajare yaᵽaeka. ");
INSERT INTO tnc_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","I'suᵽaka nabaaeka ᵽoto wẽkomaka imariwi'iarã Barrabásre imaeka kika ba'iaja baaekarãᵽitiyika. Roma ĩᵽamakire yi'riberiwa'ri tokarã surararãkaka jĩᵽaraka ᵽo'imajare jããeka mirãki kimaeka. ");
INSERT INTO tnc_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Suᵽa imarĩ rĩkimarãja eyaekarã ikuᵽaka Ᵽilatore narĩka: —Mibaarijariroyika uᵽakaja, ĩ'rĩkate miᵽoatarika yija yaᵽayu,— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","I'suᵽaka kire naᵽakã'ã ikuᵽaka nare kẽrĩka: —¿Makire yiᵽoatarika mija yaᵽayu? ¿Yaje judíotatarã ĩᵽamakire yiᵽoatarika mija yaᵽayu je'e?— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","“Jesúre ã'mijĩairã imarĩ, yiᵽõ'irã kurarãka ĩᵽamarãre kire e'eetayu”, ãrĩᵽuᵽajoaekaki imarĩ, kire ᵽoatarika yaᵽakoᵽekaki imarĩ, i'suᵽaka kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Jesúre ᵽoatarika kiyaᵽako'omakaja kurarãka ĩᵽarimarã ᵽuri jãjirokaᵽi ikuᵽaka ritaja ᵽo'imajare ãrĩkarã: —“Barrabásre miᵽoatabe Jesús õ'toarã”, Ᵽilatore mija ãᵽe,— kurarãka ĩᵽamarãre ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","“Barrabásre miᵽoatabe”, naᵽakã'ã ã'mitiritirã ikuᵽaka Ᵽilatore nare yi'rika: —I'suᵽaka yibaarãkareka, “Judíotatarã ĩᵽamaki”, mija ãñukate ᵽuri ¿marãkã'ã yibaarãñu je'e?— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","I'suᵽaka kẽᵽakã'ã ã'mitiritirã, akasererikaᵽi, —¡Yaᵽua tetaekarã kire miᵽatakĩarũjeᵽabe!— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","I'suᵽaka narĩko'omakaja, —¿Dakoa ba'iaja kibaaeka je'e?— nare kẽrĩka. I'suᵽaka kẽᵽakã'ã, jãjibaji nakasereka ate, —¡Yaᵽua tetaekarã kire miᵽatakĩarũjebe!— narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Suᵽa imarĩ ᵽo'imajaka jia imarika yaᵽawa'ri Barrabásre kiᵽoataeka mae. Jesúre ᵽuri, ajeakaka ᵽajerũkia nabaaeka imaroyikaᵽi surararãkare kiᵽajerũjeka. I'suᵽaka kire nabaaeka be'erõ'õᵽi, “Yaᵽua tetaekarã kire ᵽatakĩarĩ mija e'ewa'ᵽe”, Ᵽilatore nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","I'suᵽaka kijã'meka simamaka toᵽi a'ritirã ĩᵽi Ᵽilato wi'itõsiarã nakãkaeka mae. Suᵽabatirã torã imaekarã surararãkare nakaeka nimauᵽatiji Jesús ᵽõ'irã narẽñaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","18","Wi'itõsiarã nimauᵽatiji rẽrĩᵽatatirã jairoᵽemakato iyayaᵽea uᵽaka ĩoika Jesúre najããwã'imarĩka, ĩᵽire jããroyikakaka. Suᵽabatirã ᵽotatãkobu'ya baatirã, kiruᵽuko'arã tuatirã ikuᵽaka kire nawaᵽeriwã'imarĩka: —Jia ritaja mire najiyiᵽuᵽayeerũ, judíotata ĩᵽamaki,— kire ãᵽaraka, ba'iaja kire najaiwã'imarĩka. ");
INSERT INTO tnc_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Suᵽabatirã yaᵽuaᵽi kiruᵽuko'arã ᵽajerijaᵽaraka kire narijo'kataᵽaterijarika. Kiwãjitãji ñukuruᵽatirã eewã'imaᵽaraka kire nawaᵽeka. “¿Mi'i imaki ĩᵽi imatiyaiki bai?”, ãᵽaraka kire nawaᵽeka. ");
INSERT INTO tnc_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kire eewã'imarĩweatirã kijairoᵽemakato iyayaᵽea uᵽaka ĩoika e'etirã mamarĩ kijããekatojo kire najããeka ate. Suᵽabatirã yaᵽua tetaekarã ᵽatakĩarĩ kire ne'ewa'rika mae. ");
INSERT INTO tnc_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kire ne'ewa'rika ᵽoto Simón, Cirenewejeakakire naᵽõ'irã etaeka. Alejandro, Rufoᵽitiyika ĩ'ᵽarã ᵽaki kimaeka. Jerusalénwejearã eyatirã Jesús wã'taᵽi Simónre o'riwa'rirã baaeka ᵽoto Jesúre naᵽatakĩarũkia yaᵽua tetaeka surararãkare kire kõkerũjeka. ");
INSERT INTO tnc_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Suᵽabatirã Gólgota wãmeirõ'õrã Jesúre ne'ewa'rika. “Ruᵽuko'a ũ'ã ᵽusia”, ãrĩrika simaeka Gólgota. ");
INSERT INTO tnc_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Torã eyatirã iyaokoa, mirra ĩkoa rukeka kire nasĩamaka sakiukuberika. ");
INSERT INTO tnc_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Torãjĩrã mae Jesúre kijariroaka e'etatirã, yaᵽua tetaekarã kire naᵽatakĩaeka. Kijariroaka yaᵽawa'ri ikuᵽaka narĩka: “Ni'i kijariroaka e'erika mairã”, ãᵽaraka barewã'imarĩrikaᵽi surararãkare sakorika. I'suᵽaka barewã'imarĩrirokaᵽi kijariroaka kijããekato ne'eka mae. ");
INSERT INTO tnc_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Bikitojo botarakaoteñarirakakuri aiyajẽrã eyawa'rika ᵽoto kire naᵽatakĩaeka mae. ");
INSERT INTO tnc_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kiruᵽuko'a bo'irã yaᵽuᵽãia o'oeka najĩ'ataeka. “Oka kireka imaeka ᵽareaja i'suᵽaka kijũayu”, narĩrũ ãrĩwa'ri i'suᵽaka nabaaeka. “Ĩ'ĩ kime judíotata ĩᵽamaki”, ãrĩwa'ri sarã no'ojĩ'aeka simaeka. ");
INSERT INTO tnc_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Torã ĩ'ᵽarã karee'erimajareoka naᵽatakĩaeka. Ĩ'rĩka kiritaᵽẽ'rõtoᵽi, aᵽika kikãkoᵽẽ'rõtorã nimaeka. ");
INSERT INTO tnc_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","I'suᵽaka Tuᵽarã majaroᵽũñureka sabojatika simamaka i'suᵽaka kiro'si simaeka. Ã'mitirikõrĩ je'e: “Ba'iaja baairãᵽitiyika kimamaka, ba'iaja baaiki kime kiro'si”, ᵽo'imajare kireka ãrĩrãñu, ãrĩwa'ri o'oeka simaeka. ");
INSERT INTO tnc_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jesús wã'taᵽi o'rikarã kire jiyiᵽuᵽayeeberiwa'ri naruᵽuko'a narĩ'meka. Ikuᵽaka ãrĩroyikarã: —¡Yaa! “Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'ia yiᵽoaᵽaterãñu. I'suᵽaka baatirã, maekarakarĩmi be'erõ'õ sayibaarãñu ate”, merãᵽe. ");
INSERT INTO tnc_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","I'suᵽaka baaiki mimaye'e, mirikaᵽi miõñu uᵽakaja miᵽo'ia mitãbe. Suᵽabatirãoka yaᵽua tetaekarã mire naᵽatakĩaikaᵽioka miruira'abe,— jaiyuyebaraka kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","32","Kurarãka ĩᵽarimarã, Moiséte jã'meka wãrõrimajaoka ikuᵽaka ãᵽaraka kire jaiyuyekarã: —Aᵽerãte tããekaki imariᵽotojo kiõñu uᵽakaja kiᵽo'ia ᵽuri kitãwãrũbeyu. Karemarĩa Mesías, Israelka'iakarã ĩᵽamakitaki kimarãkareka, kiruirãñu. Yaᵽua tetaekaᵽi kiruimaka ĩatirã, “Rita, ikiji mime”, kire marĩrãñu,— ᵽo'imajare narĩka. Jesús wã'tarã yaᵽua tetaekarã ᵽatakĩaekarãoka naka ĩ'rãtiji kire jaiyuyekarã. ");
INSERT INTO tnc_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Wãjitãji aiyate eyawa'rika ᵽoto wejea ñamita'rika. Maekarakakuri aiyajẽrã be'erõ'õjĩrã saborika ate. ");
INSERT INTO tnc_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Saborika ᵽoto jãjirokaᵽi ikuᵽaka Jesúre jaiwataeka: —Eloí, Eloí, ¿lama sabactani?— kẽrĩka. (Hebreo okaᵽi ikuᵽaka ãrĩrika simaeka: “Tuᵽarã, Yiᵽaki, ¿dako baaerã yire miarĩrĩrija'atayu?”, ãrĩrika simaeka). ");
INSERT INTO tnc_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kire ã'mitiritirã, ĩ'rãrimarã torã imaekarãte ikuᵽaka ãrĩka: —Tuᵽarãte bojaĩjirimaji imaekaki Elíasre kiakakoyu,— narĩka. ");
INSERT INTO tnc_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Suᵽa imarĩ ĩ'rĩka torã imaekaki okoarã samañu'amaka u'rie'eika e'erĩ rĩrĩwa'rikaki. Se'eetatirã iyaokoa kã'marikarã sakiñu'aeka. Suᵽabatirã Jesús rijearã yaᵽuaᵽi sakitaaruᵽakoᵽeka sakimi'mirĩtaokaro'si. I'suᵽaka kire baakoᵽetirã ikuᵽaka ᵽo'imajare kẽrĩka: —Jaika ruᵽu mija ta'abe. Elías imaekakire kire ruetamaka mairã,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","I'suᵽaka kẽrĩka be'erõ'õ jãjirokaᵽi akaseretirã Jesúre ᵽuᵽaririka mae. ");
INSERT INTO tnc_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kiᵽuᵽaririkarõ'õjĩte Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã, sayaᵽãia mo'rĩa baata'teka imaeka ĩmiᵽi beriruika ka'iarã eyabaka. ");
INSERT INTO tnc_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jesúre ᵽuᵽaririka ᵽoto surararãka ĩᵽamakire yaᵽua tetaeka wãjitãji yoirĩkamarĩka. Kiᵽuᵽariᵽakã'ã ĩatirã, —Tuᵽarã Makitakiji ĩ'ĩre imakoᵽeka mirãkiyu,— kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ñoakuriᵽañakaᵽi rõmijã ĩ'rãrimarãoka kiᵽuᵽariᵽakã'ã kire ĩaekarã. Nawatoᵽekarã nimaeka ikarakamarã aᵽerã: María Magdalena, suᵽabatirã María, José, kirĩ'ĩ Santiago ĩ'ᵽarã ᵽako koimaeka María. Suᵽabatirã aᵽeko Salomé imaekako. ");
INSERT INTO tnc_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Galileawejearã Jesúre imataᵽaeka ᵽoto kire jeyobaaeka mirãrã nimaeka ĩ'rã rõmijã. Rĩkimarãja rõmitika Jerusalénrã kika eyaekarãoka kiᵽuᵽariᵽakã'ã ĩaekarã. ");
INSERT INTO tnc_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Torã aᵽika, José Arimateawejeakakire imaeka. (Judíotatarã ĩᵽarimarã imatiyaitatakaki kimaeka). Suᵽabatirãoka jiyiᵽuᵽaka ᵽo'imajare kire õñuka kimaeka. “Tuᵽarãte wã'maekaki imarĩ, ritaja ᵽo'imajare jia Jesúre jã'merãñu”, ãrĩrikaoka õñuka Josére imaeka. Jesúre ᵽuᵽaririka ᵽoto rã'irikoyiaja sajaritika simamaka, kũᵽajĩji sajariwa'rika jẽrĩtarirĩmi ruᵽu jieweibaraka nimaroyikarĩmi ᵽuririka. Suᵽa imarĩ ñojimarĩji ãta wi'iarã Jesús majaka natariyaᵽaeka. Suᵽa simamaka okajãjia jaritirã kĩkirimarĩaja Ᵽilato ᵽõ'irã a'ritirã Jesús ᵽo'ia Josére jẽñeka. ");
INSERT INTO tnc_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","45","I'suᵽaka kẽᵽakã'ã ã'mitiritirã, “Yee, ¿koᵽakaja kiᵽuᵽariritiyu bai?”, Ᵽilatore ãrĩᵽuᵽajoaeka. Suᵽa imarĩ surara ĩᵽamakire Ᵽilatore akaeka “¿Yaje rita simatiyayu?”, kire ãñaokaro'si. “Rita sime”, surararãka ĩᵽamakire kire ãrĩka ã'mitiritirã, Jesús ᵽo'ia Josére ke'erũjeka. ");
INSERT INTO tnc_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","I'suᵽaka kẽᵽakã'ã ã'mitiritirã, Jesúre buteokaro'si ĩ'rãto sayaᵽãia boia jíakaka Josére waᵽaĩjika. Suᵽabatirã kiᵽo'ia ruerĩ ke'rika mae. Kire rueweatirã sayaᵽãiaᵽi Josére kire buteka. I'suᵽaka kire baatirã ãta wi'ia ᵽo'imajare baaekarã kire kitaeka. Sarã kire tatirã ãta jo'bakaᵽi sakitãteka. ");
INSERT INTO tnc_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena, María, José ᵽakoᵽitiyika kire kitaekarõ'õ niaeka. ");
INSERT INTO tnc_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jẽrĩtarirĩmi, aiyate ka'raeka be'erõ'õ María Magdalena, María Santiago ᵽako suᵽabatirã Salomé wãmeikoᵽitiyika maekarakakorã ruᵽuko'a wearũkia jia jiijĩsia nawaᵽaĩjika, Jesús ᵽo'iarã yo'yeokaro'si. ");
INSERT INTO tnc_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ba'irabeũ'murirĩmi bikitojo wãrĩrika ña'rĩᵽataeka ᵽoto na'rika ãta wi'iarã. Aiyate warara'aekarõ'õjĩte torã na'ririjarika. ");
INSERT INTO tnc_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Suᵽabatirã natiyiaja ikuᵽaka najaibu'arijarika: —Ãta jo'bakaᵽi ãta wi'ia natãteka, ¿maki maro'si se'etarãki ruku?— narĩbu'arijarika. Torã neyaeka ᵽoto ãta jo'baka aᵽerõ'õrã sataᵽamaka niaeka. ");
INSERT INTO tnc_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ãta aᵽerõ'õrã taᵽamaka ĩatirã, sarã nakãkawa'rika. Torã kãkawa'ritirã ĩaᵽũataerã baakõrĩ nakãkawa'rika koᵽeritaᵽẽ'rõtoᵽi, ĩ'rĩka bikirimaji saya boia jããikite ruᵽamaka niaeka. Kire ĩatirã rõmijãte ᵽuᵽatatiyaeka. ");
INSERT INTO tnc_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Naᵽuᵽatamaka ĩawa'ri, ikuᵽaka nare kẽrĩka: —Mija ᵽuᵽata'si. Jesús Nazaretkaki yaᵽua tetaekarã naᵽatakĩaraᵽakite mo'arĩ mija i'tayu. I'suᵽaka simako'omakaja kimabeyu õ'õrã. Kiᵽuᵽariᵽakã'ã õ'õrã kire nayayeraᵽaka be'erõ'õ koᵽakaja õñia kijariᵽe'yu. Mia, õ'õrã kire natakoᵽeraᵽarõ'õrã karemarĩa kimajĩka. ");
INSERT INTO tnc_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mija a'ᵽe. Kika wãrũrimaja mirãrãte, suᵽabatirã Ᵽedroreoka ikuᵽaka mija bojaᵽe: “Mija ruᵽubajirã Galilearã eyaokaro'si a'riweitiki Jesús. Mijare kibojatika uᵽakaja torã kire mija ĩatõᵽorãñu”, ãrĩwa'ri nare mija bojabe,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","I'suᵽaka kẽrĩka ã'mitiritirã, ᵽuᵽatatiyawa'ri tarabaraka rõmijãte ru'riᵽoriwa'rika. I'suᵽaka simaeka ĩatirã naᵽuᵽataeka simamaka, aᵽerãte samajaroka nabojaᵽibaberika. ");
INSERT INTO tnc_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Najẽrĩtaroyikarĩmi be'erõ'õkarĩmi bikitojo õñia Jesúre jariᵽe'rika. Bikitojo ñamiji õñia jariᵽe'ritirã María Magdalena ᵽõ'irã mamarĩtaka Jesúre ᵽemakotowiriũ'mueka. Ĩ'ᵽotẽñarirakamaki Satanárika ima koreka ña'rĩjãikarãte kiᵽoataeka mirãko koimaeka. ");
INSERT INTO tnc_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Kire ĩatirã, kika turitaᵽaeka mirãrãte bojarĩ ko'rika. Ba'iaja ᵽuᵽariwa'ri oᵽaraka nimaekarõ'õ naᵽõ'irã eyatirã ikuᵽaka nare kõrĩka: “Õñia Jesúre jayu ate. Kire ñiako'a simamaka ñañu”, ãᵽaraka nare kobojakoᵽeka. I'suᵽaka nare kobojako'omakaja kore nayi'riberika. ");
INSERT INTO tnc_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","I'suᵽaka nare kõrĩkoᵽeka be'erõ'õ ĩ'ᵽarã Jesúka wãrũeka mirãrã Jerusalénᵽi na'ririjarika ᵽoto nare kiᵽemakotowirika aᵽeaja ĩoiki jaritirã. ");
INSERT INTO tnc_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ᵽe'riwa'ritirã aᵽerã Jesúka wãrũeka mirãrãte sanabojaeka. “Jesúre yija ĩako'o”, nare nabojako'omakaja nare nayi'riberika ate. ");
INSERT INTO tnc_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","I'sia be'erõ'õ kika wãrũeka mirãrã ĩ'rõũ'ᵽuarãe'earirakamaki imaekarãre ba'aruᵽaekarõ'õrã Jesúre ᵽemakotowirika. Naᵽõ'irã ᵽemakotowiritirã, ikuᵽaka nare kẽrĩka: —Õñia yijariᵽe'raᵽaka be'erõ'õ, ¿dako baaerã aᵽerã yire ĩaraᵽarãte bojaraᵽaka mija yi'ririyaᵽaberitiyaraᵽe?— ãrĩwa'ri nare kiwaᵽeka. ");
INSERT INTO tnc_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","I'suᵽaka nare ãrĩtirã, ikuᵽaka nare kẽrĩka: —Ritatojo wejearã mija a'ᵽe, yirika ritaja ᵽo'imajare õrĩᵽatarũ, ãrĩwa'ri nare sabojataᵽaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yirika ã'mitiriᵽẽawa'ri, “Jesúre yi'yuka ñime mae”, ãrĩwa'ri kiruᵽuko'a jũjerũjeiki, ba'iaja imarika tiyibeyurõ'õrã a'ribesarãki. I'suᵽaka simako'omakaja yirika ã'mitiriᵽẽabeyukaro'si ᵽuri ba'iaja kibaaika waᵽa ba'iaja imarika tiyibeyurõ'õrã Tuᵽarãte kire ᵽũatarãñu. ");
INSERT INTO tnc_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Mija ĩabe. Ikuᵽaka yire ã'mitiriᵽẽairãte nabaabearãñu: Yirirã nimamaka tẽrĩwa'ribaji yirikaᵽi Satanárika ima ña'rĩjãikarãreka ᵽoatarijarirãñurã. Suᵽabatirãoka aᵽerã oka norĩbeyua najairãñu. ");
INSERT INTO tnc_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ãñaka nañi'akoᵽerãka, suᵽabatirã okoa rĩmaka nukukoᵽerãkaoka dakoa nare o'ribesarãñu. Ᵽo'imaja jĩñurã ᵽo'iarã naᵽitaka naja'aᵽearãka ᵽotojo ᵽo'imajare jãjirijarirãñu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","I'suᵽaka maiᵽamaki Jesúre nare ãrĩka be'erõ'õ Tuᵽarãte mabo'ikakurirã kire e'emiawa'rika. Suᵽa imarĩ kiᵽõ'irã kiritaᵽẽ'rõtoᵽi Jesúre ruᵽe mae, tẽrĩrikaja jiyiᵽuᵽaka õrĩrũkika imarĩ. ");
INSERT INTO tnc_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kimirĩwa'rika be'erõ'õ kika wãrũeka mirãrãte kirika bojataᵽarĩ a'rika. I'suᵽaka bojataᵽabaraka nimaeka ᵽoto, niakoribeyua ᵽo'imajare nabeaokaro'si Maiᵽamakite nare jeyobaaroyika, “Rita sime nabojaika”, ᵽo'imajare ãñaokaro'si. I'tojĩrãja sime ruᵽu.");
INSERT INTO tnc_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","¿Yaje mime Teófilo? Bikija ᵽaᵽera miro'si yiᵽũataũ'muraᵽe. Jesúre imaroyiraᵽaka, suᵽabatirã kiwãrõroyiraᵽakakaka saᵽi mire yibojaᵽũaraᵽe. Ritaja mire yibojaikareka mabo'ikakurirã Tuᵽarãte kire e'emiaekarõ'õjĩrã miro'si yo'otiyiraᵽe. Mabo'ikakurirã Tuᵽarãte kire e'emiaerã baaeka ruᵽu kirika bojariroka bojarimaja kiwã'maekarãka kimaeka. Esᵽíritu Santore kire jeyobamaka kiyaᵽaeka uᵽakaja nabaarũkiakaka nare kibojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Reyariᵽotojo õñia kijariᵽe'rika be'erõ'õ ĩ'rãkurimarĩa kimajaroka bojataᵽarũkirãte kiᵽemakotowiriroyika. Ĩ'ᵽarã ᵽo'imajarakarĩmi i'suᵽaka nare baabaraka Jesúre imaeka. “I'kitakijioka kime”, nañaokaro'si suᵽa kibaaroyika. Suᵽa baabaraka “Ikuᵽaka yire yi'yurãte jã'mebaraka Tuᵽarãte nare imaruᵽutarãñu mae”, ãᵽaraka nare kiwãrõrijarika. ");
INSERT INTO tnc_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ĩ'rãkuri naka rẽrĩtirã ba'abaraka kimaeka ᵽoto, ikuᵽaka Jesúre nare bojareka're: —Jerusalénrãja mija imabe ruᵽu. Maᵽaki Tuᵽarãte mijare bojaeka uᵽakaja Esᵽíritu Santore mijare kiᵽũatarãñu. Suᵽa imarĩ õ'õrãja kire mija ta'abe. Koᵽakaja mijare yibojaroyiraᵽaka ã'mitiriroyiraᵽarã mija ime. ");
INSERT INTO tnc_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Mamarĩ ᵽuri okoaᵽi takaja ruᵽuko'a ᵽo'imajare Juanre jũjeka. Maekaka ᵽuri no'ojĩrãmarĩaja Esᵽíritu Santore Tuᵽarãte mijare ña'ajããrãñu kiyaᵽaika uᵽakaja mija imawãrũokaro'si,— kika wãrũekarãte kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ĩ'rãrĩmi ate Jesúka rẽrĩtirã ikuᵽaka kire narĩka: —Yija ĩᵽamaki, “Maekaka ᵽuri Romatatarãte ᵽoatatirã Israel ka'iakarãre yijã'merãñu Tuᵽarãte ᵽũataekaki imarĩ”, ¿yaje meñu je'e?— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Suᵽa naᵽakã'ã ikuᵽaka nare kẽrĩka: —Marãkã'ã baatirã mija õrĩrũkimarĩa sime. Maᵽaki Tuᵽarã ĩ'rĩkaja sõñuka. ");
INSERT INTO tnc_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","I'suᵽaka simako'omakaja Esᵽíritu Santore mijare ña'rĩjãirãka ᵽoto, okajãjia mija jarirãñu. I'suᵽaka jariwa'ri aᵽea wejearã a'ritirã, yika imaekarã imarĩ, yimajaroka nare mija bojarãñu. Jerusalénrã, Judeaka'iarã, Samariaka'iarã, suᵽabatirã ritatojo wejearekaoka, yimajaroka mija bojarijarirãñu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","I'suᵽaka nare kẽrĩka be'erõ'õ, kire nayoiyukã'ãja, mabo'ikakurirã ke'rika. Oko ũmakakarã keyawa'rika ᵽoto koᵽakaja kiõiberika. ");
INSERT INTO tnc_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ke'ᵽakã'ã wejeᵽemarãja nañakoarika. I'suᵽaka nimekã'ãja ikuᵽarõ'õᵽiji ĩ'ᵽarã ángelrãka boia jariroaka jããekarã naᵽõ'irã ᵽemakotowirirĩkaekarã. ");
INSERT INTO tnc_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Toᵽi ikuᵽaka nare narĩka: —Galileakarã, wejeᵽemarãja mija ñakoaria'si mae. Mijaka imaroyiraᵽaki mabo'ikakurirã Tuᵽarãte kire e'emiamaka mija ĩaikijioka toᵽi mija ᵽõ'irã etarãki ate ke'yu uᵽakajaoka,— nare narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Olivos wãmeika ᵽusiarã nimaeka aᵽóstolrãka. I'sia be'erõ'õ Jerusalénrã naᵽe'rika mae, nimaekarõ'õᵽi koyikuriji simaeka simamaka. ");
INSERT INTO tnc_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Wejearã eyatirã wi'iarã neyaeka. Ĩmika wi'iareka mirĩwa'ritirã, kurarakarã ĩ'rãkõ'rĩmatorãja neyaeka. Ikuᵽati nimaeka torã eyaekarã: Ᵽedro, Juan, Santiago, Andrés, Feliᵽe, Tomás, Bartolomé, Mateo, Alfeo maki Santiago. Suᵽabatirã aᵽerã imaekarã Simón Celote, suᵽabatirã Santiago maki Judas. ");
INSERT INTO tnc_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Jesús be'erõ'õkarã, kiᵽako María, suᵽabatirã aᵽerã rõmijãᵽitiyika ĩ'rãkõ'rĩmatorãja narẽrĩroyika ĩ'rĩka uᵽakaja ᵽuᵽajoawa'ri Tuᵽarãka jairã. ");
INSERT INTO tnc_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","I'suᵽaka nabaaroyika ᵽoto Jesúre ã'mitiriᵽẽarĩ naka narẽrĩroyika, ciento veinte rõ'õjĩrã ᵽo'imaja nimaeka. Ĩ'rãkuri i'sirakamarã watoᵽekaᵽi mi'mirĩkatirã ikuᵽaka Ᵽedrore nare bojaeka: ");
INSERT INTO tnc_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Wãtaka ñoñurã, mija ã'mitiᵽe. Bikija mañeki David imaroyikaki Esᵽíritu Santore kire ãᵽakã'ã, Jesúre nañi'aerã Judare bojajããrũkiakaka, kio'oeka. ");
INSERT INTO tnc_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Mia je'e, yijakakiji Judare imakoᵽeroyiraᵽe. Jesúka yija imaokaro'si yijare kiwã'maeka uᵽakaja kiwã'maekaki. ");
INSERT INTO tnc_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(I'suᵽaka imariᵽotojo niñerũ yaᵽawa'ri Jesúre kibojajããraᵽe. Kibojajããraᵽaka waᵽa mirãka kiᵽe'ataraᵽakaᵽi ka'ia nawaruaraᵽe. Sarã mae kiruᵽuko'aᵽi ña'rĩtirã, kiñe'mea kijãwataraᵽe kitaᵽisia ᵽoriᵽateribaka. ");
INSERT INTO tnc_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","I'suᵽaka kibaaeka ã'mitiritirã, Acéldama Jerusalénkarãre sawãmejĩ'aeka i'sia ka'ia. Nokaᵽi, “Riweka'ia”, ãrĩrika simaeka). ");
INSERT INTO tnc_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ikuᵽaka Davidre bikija o'oeka: “Baiᵽarãmarĩa wi'ia jariwa'rirãka sarã imaekakite a'ritaᵽawa'rika simamaka. Aᵽika etatirã sarã imaberijĩki.” Toᵽi ᵽuri, “Aᵽika o'atirã kiba'iraberũ”, ãrĩwa'ri David imaroyikakite o'oeka uᵽakaja Judare baaeka. ");
INSERT INTO tnc_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","I'suᵽaka kibaaeka simamaka kire o'arika sime mae. Mia, maiᵽamaki Jesúre maᵽõ'irã imaroyiraᵽaka ᵽoto makaja imaroyiraᵽakite ma'eye'e. Juanre ruᵽuko'a Jesúre jũjemaka ĩaekaki, mabo'ikakurirã Jesúre a'rikarõ'õjĩrã maka imaroyiraᵽaki kimajĩñu. Suᵽabatirã reyariᵽotojo õñia Jesúre jariᵽe'rika be'erõ'õ kire ĩaekakioka kimarãkareka jia simarãñu,— Ᵽedrote nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Torãjĩrã mae, ĩ'ᵽarã torã imaekarãte nawã'maeka. “José, Matíasᵽitiyika nime jia ᵽuᵽakirã”, narĩka. José Barsabás kiwãmea imako'omakaja aᵽewãme Justo kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Torãjĩrã mae, —Yija ĩᵽamaki Jesús, mi'i imaki ritaja ᵽo'imajare ᵽuᵽajoaika õñuka. I'suᵽaka simamaka “Ĩ'ĩ kime Judas õ'toarã o'arũkika mijaka wãrõrimaji”, ãrĩwa'ri yijare miõrĩrũjebe. Mia je'e, Judas ᵽuri yijare a'ritaᵽaraᵽaki ba'iaja baarika yaᵽawa'ri. Suᵽa imarĩ maekaka ba'iaja baariwaᵽa tiyibeyurõ'õrã kime,— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Suᵽa imarĩ José wãmea ãtarã no'ojĩ'aeka, suᵽabatirã Matías wãmea aᵽorã. Toᵽi mae jotoarã jããtirã, sanajãjeeka mamarĩ ña'rĩrãñuo ĩaokaro'si. Sĩatirã, “Matías kime Tuᵽarãte wã'maiki”, narĩka. Torãjĩteᵽi ĩ'ᵽoũ'ᵽuarãe'earirakamakiro'si kijarika mae. ");
INSERT INTO tnc_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ᵽentecostés bayarĩmi seyaeka ᵽoto Jesúre yi'yurãte nimauᵽatiji ĩ'rãkõ'rĩmatorãja narẽrĩkũ'ika. ");
INSERT INTO tnc_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ikuᵽarõ'õᵽiji jãjia wĩrõa baeika uᵽaka sokaarika wejeᵽemaᵽi. I'sia wi'iarã ruᵽataekarã nimauᵽatiji jia sana'mitirika. ");
INSERT INTO tnc_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Suᵽabatirã ᵽekajũ'rẽika uᵽaka simamaka niaeka. I'suᵽaka ᵽekajũ'rẽikaᵽi ᵽibitirã nimaekarakamakireje saña'rĩᵽeika. ");
INSERT INTO tnc_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Saᵽi Tuᵽarãte ᵽũataekaki Esᵽíritu Santore nare ña'rĩjãika. Nareka ña'rĩjãitirã aᵽerã oka na'mitiribeyua imakoᵽeikaja nare kijaiwãrũrũjeka. I'suᵽaka kibaamaka nimaekarakamakiji rakakaja jairã najarika kijã'meka uᵽakaja. ");
INSERT INTO tnc_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","I'sia ᵽoto judíotatarã imariᵽotojo aᵽerõ'õrã ᵽo'ijirikarãoka Jerusalénwejearã imaekarã. I'sirokaᵽi ãrĩwa'ri rakaka oyiaja jairã nimaeka. I'suᵽaka imariᵽotojo jia Tuᵽarãte jiyiᵽuᵽayeeirã nimaeka. ");
INSERT INTO tnc_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","7","Torãjĩrã mae wĩrõa baeika uᵽaka okaaririka ã'mitiritirã, ĩ'rãoka torã rẽrĩkarã. Torã eyatirã rakakaja jairã imariᵽotojo nokarokaᵽi jairãte ã'mitiyurã nimaeka. I'suᵽaka simamaka jimarĩa naᵽuᵽataeka. Toᵽi natiyiaja ikuᵽaka najaibu'aeka: —Galileakarã nime. ");
INSERT INTO tnc_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Tokarã imariᵽotojo ¿marãkã'ã mija oka, suᵽabatirã yija oka ᵽariji najaiyuje'e? ");
INSERT INTO tnc_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","Ĩ'rãtatamarĩa maime. Mija ĩabe: Ᵽartia, Media, Elam, Mesoᵽotamia, Judea, Caᵽadocia, Ᵽonto, Asia, Frigia, Ᵽanfilia, Egiᵽto, suᵽabatirã Cirenewejea a'riwa'ri Libia, suᵽabatirã Romakarã maime. Creta, Arabiaᵽi i'taekarãoka imarã maka. Suᵽabatirã Romaᵽi i'taekarã, judíorãka, suᵽabatirã Tuᵽarãte jiyiᵽuᵽayeerijayurãoka imarã naro'si. Suᵽa imariᵽotojo, tẽrĩwa'ribaji jia Tuᵽarãte baarimajaroka mokaᵽiji maka Galileakarãre jairijiyu,— ãrĩbu'abaraka nimaeka. ");
INSERT INTO tnc_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ᵽuᵽatatiyawa'ri, marãkã'ã ãrĩrika imabeᵽakã'ã ikuᵽaka narĩka: —¿Dakoaᵽi ãrĩwa'ri suᵽa nabaayu?— ");
INSERT INTO tnc_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Suᵽabatirã aᵽerimarã ᵽuri, —Nukuwejabiyu,— ãᵽaraka ba'iaja neewã'imarĩka. ");
INSERT INTO tnc_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","I'suᵽaka nañua ã'mitiritirã, Ᵽedro, kijeyomarã ĩ'rõũ'ᵽuarãe'earirakamarã ᵽitiyika jia wããrõ'õrã nawirirĩkaeka. Torãjĩrã jãjirokaᵽi ikuᵽaka Ᵽedrote ãrĩka ritaja torã imaekarãte ã'mitiyaokaro'si: —Judíorãka aᵽerõ'õᵽi i'taekarã, suᵽabatirã Jerusalénkarãoka jia mija ã'mitiᵽe ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","“Nukuwejabiyu”, yijareka mija ãrĩko'omakaja wejabiribeyurã yija. Sajẽ'rãkamarĩa simamaka imabeyurã ruᵽu ukuwejabiyurã. ");
INSERT INTO tnc_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ikuᵽaka simatiyayu. Yijare mija ĩaika, “I'suᵽakaja simarãñu”, Tuᵽarãrika bojaĩjirimaji, Joel imaekakite ãrĩka. Mia je'e: ");
INSERT INTO tnc_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Õ'õjĩteᵽi ñamajĩ wejetiyia seyarãñurõ'õjĩrã Esᵽíritu Santore ritatojo wejeareka imarãte yiña'ajããrãñu. Suᵽa imarĩ mija makarã yirika bojarimaja nimarãñu. Bikirimajare ᵽuri wããrõ'õrãja yibaarũkia ñiarũjerãñu. I'suᵽaka simako'omakaja ᵽakiarãte ᵽuri nakãrõmarõ'õᵽi nare sayibearãñu. ");
INSERT INTO tnc_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Torãjĩrã mae, Esᵽíritu Santore yiña'ajããrãñu yijã'meika uᵽakaja baairãte. Rõmijãte, ĩmirĩjareoka i'suᵽaka yibaarãñu yirika bojariroka bojarimaja nimaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mija jẽrãko'abeyua wejeᵽemarã mijare yibearãñu. Suᵽabatirã ritaja wejeareka i'suᵽaka yibaamaka, ‘Tẽrĩriki kime Tuᵽarã’, ᵽo'imajare ãrĩrãñu. I'suᵽakajaoka ᵽitã'muaᵽi ᵽuyurã, suᵽabatirã ᵽeka jũ'rẽika ũmakaᵽuᵽakã'ã niarãñu. ");
INSERT INTO tnc_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Mia je'e, ĩmikaki aiyate neiñamita'rimaka, ñamikakioka, riwerõ'õjĩrã jũ'aka jarirãki. I'suᵽaka simarãka ᵽoto wejetiyia seyamaka, jia suᵽabatirã ba'iajaoka ᵽo'imajare baaeka ĩatirã, sawaᵽa maiᵽamaki Tuᵽarãte nare baarãñu. Imatiyairĩmi simarãñu i'suᵽaka kibaarãñurĩmi. ");
INSERT INTO tnc_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","‘Ñiᵽamaki, ba'iaja baaiki ñime. Ba'iaja yibaaika miye'kariabe’, yire ãrĩrãñurãte ᵽuri, ba'iaja nabaaeka waᵽa Tuᵽarãte nare baabesarãñu”, Tuᵽarãro'si Joelre o'oeka,— ãrĩwa'ri Ᵽedrote nare bojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Sabe'erõ'õjĩte ikuᵽaka Ᵽedrote nare ãrĩka ate: —Mija ã'mitiᵽe Israelkarã. Jesús Nazaretkaki Tuᵽarãrikaᵽi maikoribeyua mijare baabearoyikaki. I'suᵽaka Tuᵽarãte baaeka simamaka “Kijã'meka uᵽakaja Jesúre baaeka”, ãrĩwãrũirã mija ime. ");
INSERT INTO tnc_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","I'suᵽaka simako'omakaja, Jesúre ã'mijĩaraᵽarã, kire okabaaraᵽarã mija ime. Suᵽabatirã yaᵽua tetaekarã kire mija ᵽatakĩarũjeka. I'suᵽaka mija baarũkia õrĩtikaki Tuᵽarã ᵽuri. “Ba'iaja kire nabaarãka imako'omakaja yi'i ᵽuri jia ᵽuᵽajoawa'ri Jesúre ᵽũatarãki”, Tuᵽarãte ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ba'itakaja jũabaraka Jesúre reyako'omakaja Tuᵽarã ᵽuri õñia kire jariᵽe'rirũjekaki, reyariba'imarĩka Jesúre imaeka simamaka. ");
INSERT INTO tnc_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Suᵽa imarĩ mañeki, David, Jesúre imarãkakaka ᵽuᵽajoawa'ri, ikuᵽaka kio'oeka: “Maiᵽamaki, yikaja yire jeyobaabaraka mime. Suᵽa imarĩ wayuᵽi'ribeyuka yi'i. ");
INSERT INTO tnc_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Suᵽa imarĩ jĩjimaka yiᵽuᵽakaᵽi ñime. I'suᵽaka simamaka jĩjimakaᵽi mika yijaiyu. Suᵽabatirãoka ‘Reyariᵽotojo õñia yijariᵽe'rirãñu’, ãñuka ñime. ");
INSERT INTO tnc_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Maiᵽamaki, miyaᵽamaka, reyairãte nayayeirõ'õrã imarũkimarĩka ñime. Suᵽabatirã mirikitaki imawa'ri, miyaᵽaika uᵽakaja baarimaji ñimamaka yiᵽo'ia mirabarũjebesarãñu. ");
INSERT INTO tnc_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Suᵽa imarĩ õñia yire mijariᵽe'rirũjerãñu. Suᵽabatirã jia jĩjimaka ñimarãñu ate mika imawa'ri”, ãᵽaraka David imaekakire o'oeka're. ");
INSERT INTO tnc_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Mija ã'mitiᵽe yijeyomarã. Mañeki David imaekakite reyamaka õ'õrãja kire nayayeka suᵽakaja kimajaᵽema õiñujua ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Suᵽa imarĩ kiro'si imarũkiakakamarĩa ᵽuᵽajoabaraka suᵽa Davidre ãrĩka. Ñamajĩ imarũkiakaka bojarimaji kimaeka. I'suᵽaka imarĩ, “Ñamajĩ ĩ'rĩka yiriᵽarãmi kimarãñu Tuᵽarãte ᵽũatarũkika, yuᵽakajaoka ĩᵽi imarũkika”, ãrĩwa'ri David imaroyikakite ᵽuᵽajoaeka, Tuᵽarãte kire õrĩrũjemaka. ");
INSERT INTO tnc_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Sõñuka imarĩ, “Jã'merimaji Tuᵽarãte ᵽũatarãñuka reyariᵽotojo õñia jariᵽe'rirãki. Suᵽabatirã reyaekarãte imarõ'õrã imabesarãki imarĩ, kiᵽo'iaoka rababesarãka”, ãrĩwa'ri kio'oeka're. ");
INSERT INTO tnc_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jesúre reyaraᵽaka be'erõ'õ, kire yija ĩaraᵽe ate. Suᵽa imarĩ “Tuᵽarãja suᵽa kire baaraᵽaki”, yija ãrĩwãrũyu. ");
INSERT INTO tnc_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Mabo'ikakurirõ'õᵽi imatirã Tuᵽarãte akaeka Jesúre. Suᵽa imarĩ Tuᵽarãte imarõ'õrã kiritaᵽẽ'rõto jiyiᵽuᵽayeerũkirõ'õᵽi kiruᵽe mae. “Õ'õrã jã'mebaraka ñima uᵽakaja Esᵽíritu Santore miᵽũatabe”, Jesúre kẽrĩka. Suᵽa imarĩ Jesús mae yijare Esᵽíritu Santore ña'ajããekaki. Mae mija ĩako'a, mija ã'mitiriko'a, Esᵽíritu Santore yijare ña'rĩjãikakaka sime. ");
INSERT INTO tnc_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ate David imaekakirika ikuᵽaka mijare yibojayu. “Yi'iji i'suᵽaka ñimarãñu”, ãrĩwa'rimarĩa Davidre so'oeka. Dakoaᵽi ãrĩwa'ri ritikaja Tuᵽarã ᵽõ'irã kiᵽo'ia mirĩwa'riberijĩki iki. I'suᵽaka simamaka Jesúre mirĩwa'rirũkia simamaka ikuᵽaka Davidre o'oeka: “ ‘Yiritaᵽẽ'rõto jiyiᵽuᵽayeerũkirõ'õᵽi miruᵽabe, ");
INSERT INTO tnc_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","mimajamarãre yitẽrĩᵽatayuju’, Tuᵽarãte ãñu Ñiᵽamakire”, ãrĩwa'ri David imaekakite o'oeka. ");
INSERT INTO tnc_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Suᵽa imarĩ ritaja Israelkarã, ika jia mija õᵽe: Yaᵽua tetaekarã mija jããekakitejeoka Jesúre, Tuᵽarãte ᵽo'imaja ĩᵽamaki imarũjeka, suᵽabatirã Jã'merũkika kire kiwã'maeka,— ãrĩwa'ri Ᵽedrote nare bojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","I'suᵽaka kẽᵽakã'ã ã'mitiritirã, jimarĩa ba'iaja ᵽuᵽariwa'ri ikuᵽaka Ᵽedrorãkare narĩka: —¿Yija jeyomarã, marãkã'ã yija baarãñu je'e mae?— ");
INSERT INTO tnc_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Toᵽi ikuᵽaka nare kẽrĩka: —Ba'iaja mija baaika ja'atatirã jia mija imabe. Suᵽabatirã, ruᵽuko'a mija jũjerũjebe, “Yijare tããrimaji Jesúre ime”, ãrĩwa'ri. I'suᵽaka mija baamaka, ba'iaja mija baaika ye'kariatirã Esᵽíritu Santore Tuᵽarãte mijare ña'ajããrãñu. ");
INSERT INTO tnc_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Esᵽíritu Santore mijare kiᵽũatarãñu, suᵽabatirã mija makarã, mija riᵽarãmerã, suᵽabatirã yoeᵽi i'taekarãteoka. “Yimakarã uᵽakaja mija imarãñu”, kẽrĩka uᵽakaja yi'rirãñurã uᵽatireje Esᵽíritu Santo kiña'ajããrãñu,— Ᵽedrote ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Torãjĩrã mae ikuᵽaka nare kiokajããrijarika: —“Ba'iaja yija baaika yijareka ye'kariatirã, yijare mitããbe”, ãrĩwa'ri Tuᵽarãte mija jẽñebe ba'iaja imarika tiyibeyurõ'õrã ba'iaja baairã ᵽo'imajaᵽitiyika mija a'ria'si ãrĩwa'ri,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","I'suᵽaka kibojaeka jĩjimaka ã'mitiriwa'ri tres mil rakamaki Jesúre yi'rikarã. I'suᵽaka imawa'ri ruᵽuko'a najũjerũjeka mae. ");
INSERT INTO tnc_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Suᵽabatirã aᵽóstolrãkare wãrõika ã'mitirirã naᵽõ'irã narẽrĩroyika. Nawãrõika yi'riwa'ri sana'mitiriᵽẽarija'ataberika. Suᵽa imarĩ ĩ'rĩka ta'iarãja ᵽuᵽajoairã najarika mae. I'suᵽaka imawa'ri, ĩ'rãkuri jariwa'ririmarĩaja rẽrĩkũ'itirã naᵽibaba'aroyika, suᵽabatirã Tuᵽarãka najaika. Suᵽabatirã, “Ika ima Jesús ᵽo'ia uᵽaka ima. Mare tããrimaji kime”, ãrĩᵽuᵽajoabaraka ᵽan naᵽibaba'arijarika. ");
INSERT INTO tnc_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Aᵽóstolrãka rĩkimakaja maikoribeyua beaekarã, i'suᵽaka nabaarũkia Tuᵽarãte nare ja'ataeka simamaka. I'suᵽaka nabaaika ĩawa'ri jimarĩa ritaja Jerusalénkarãre ᵽuᵽataeka. ");
INSERT INTO tnc_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","45","Jesúre yi'yurã ᵽuri ĩ'rĩka ta'iarãja ᵽuᵽajoaekarã. Suᵽa imawa'ri natiyiaja nayaᵽaika uᵽakaja najeyobaabu'aeka. Aᵽerikuri naba'irĩjia, naka'iaoka nijika sawaᵽa e'etirã najeyomarãte yaᵽaika ko'aᵽitorãja niñerũ nare ĩjirã. ");
INSERT INTO tnc_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","47","Ĩ'rãrĩmi jariwa'ririmarĩaja, ĩ'rĩka ta'iarãja ᵽuᵽakirã imarĩ, Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'i ᵽẽterã narẽrĩroyika. Suᵽabatirã najeyomarãre akawa'ritirã nawi'iarã ᵽiyia Jesúre ba'aeka uᵽakaja ᵽan naᵽibaba'aeka kire jiyiᵽuᵽaka õrĩwa'ri. I'suᵽaka baatirã jiiroka ᵽuᵽaritirã ba'arika naᵽibaba'aroyika, Tuᵽarãte jiyiᵽuᵽaka õñurã imawa'ri. I'suᵽaka nabaamaka ĩatirã “Jiitaka baairã nime”, ritaja ᵽo'imajare nareka ãrĩᵽuᵽajoaeka. Ĩ'rãrĩmi uᵽakaja torã rĩkimabaji Maiᵽamakire tããekarãte ᵽubuwa'rika, kire yi'yurã kimarũjekarã imarĩ. ");
INSERT INTO tnc_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ĩ'rãrĩmi uᵽakaja rã'irã Tuᵽarãka jairĩ judíorãkare eyaroyika Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã. Torãjĩrã mae ĩ'rãrĩmi Ᵽedro, Juanᵽitiyika torã Tuᵽarãka jairĩ na'rika. ");
INSERT INTO tnc_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Torã ĩ'rĩka bitamaji ᵽo'ijirikakite koᵽerekarã ruᵽaeka. I'suᵽaka kimamaka ĩ'rãrĩmi uᵽakaja kijeyomarãre kire kõkewa'riroyika. I'suᵽaka kire baatirã koᵽereka Jiyurika ãñua wãmeika rõ'õrã kire naruᵽataroyika. Torã ruᵽatirã wayuoka kibaayu ãrĩwa'ri “Niñerũ kũᵽajĩ yire mija ĩjibe”, ãᵽaraka kimaeka. ");
INSERT INTO tnc_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ᵽedrorãkare torã kãkaerã baaeka ĩatirã, —Yire mija wayuĩabe kũᵽajĩ,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Toᵽi, —Õ'õrã miabe,— Ᵽedrote kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Suᵽa kẽᵽakã'ã “Mae kũᵽajĩ yire nijirãñu je'e”, ãrĩwa'ri jia nare kiyi'rika. ");
INSERT INTO tnc_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","—Niñerũ ᵽuri yire imabeyua. Aᵽeakaka imatiyaika mire yijeyobaarãñu. Jesucristo Nazaretkakire yire jã'mekaᵽi ãrĩwa'ri, “Mi'mirĩkatirã jia a'yuka mijaᵽe”, mire ñañu,— Ᵽedrote kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","I'suᵽaka kire ãrĩtirã kiᵽitaka ritaᵽẽ'rõtoᵽi ñi'atirã Ᵽedrote kire mi'marĩkaeka. I'suᵽaka kire kibaamaka kiũ'ᵽua, kiãñarakaoka jiika mae. ");
INSERT INTO tnc_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Suᵽa imarĩ kibu'rirĩkaeka. Suᵽabatirã Ᵽedrorãkaᵽitiyika Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã buᵽurĩkewa'ritirã kikãkawa'rika mae. “Jia Tuᵽarãte yire baayu, bitamaji uᵽaka ñimareka yire kijieyu”, ãrĩwa'ri jĩjimaka kimaeka. ");
INSERT INTO tnc_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Kituritaᵽamaka torã imaekarãre kire ĩaeka. Suᵽabatirãoka “¡Jiitaka Tuᵽarãte yire baayu!”, kẽᵽakã'ã na'mitirika. ");
INSERT INTO tnc_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Suᵽa imarĩ kire ĩatirã “Niñerũ jẽñebaraka Jiyurika ãñua wãmeika koᵽereka rõ'õrã ruᵽako'okaja kimema. ¿Marãkã'ã simamaka i'suᵽaka kijayu je'e?”, narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Bitamaji imakoᵽekaki, Ᵽedrorãkakaja kimajiᵽaeka. Tuᵽarã jiyiᵽuᵽaka õrĩriwi'i ᵽẽte Salomón wãmeika imaekarõ'õrã i'suᵽaka nimaeka. I'suᵽaka kima ĩatirã ᵽuᵽatawa'ri, rĩrĩra'atirã rĩkimarãja ᵽo'imajare torã etaeka. ");
INSERT INTO tnc_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Torã netamaka ĩatirã, ikuᵽaka Ᵽedrote nare ãrĩka: —Mija ᵽuᵽata'si yitã'omaja Israelka'iakarã. Yijaᵽi ãrĩwa'rimarĩa i'suᵽaka kijayu. Suᵽabatirã “Tẽrĩritarã imarĩ noñu uᵽakaja kire najieko'o”, yijareka mija ãrĩᵽuᵽajoa'si. Suᵽabatirã “Aᵽerã bo'ibajirã jia Tuᵽarãte yi'yurã imawa'ri suᵽa kire nabaako'o”, mija ãrĩa'sioka. ");
INSERT INTO tnc_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ikuᵽaka simatiyayu: Mañekiarã, Abraham, Isaac, suᵽabatirã Jacobrãkare jiyiᵽuᵽaka õrĩkaki Tuᵽarãte yaᵽaeka uᵽakaja baaekaki kime Jesús. I'suᵽaka kimamaka ritaja ᵽo'imajare jiyiᵽuᵽaka õrĩrũkika Tuᵽarãte kire imarũjeka. Kire ĩariᵽe'yowa'ri ĩᵽarimarãre kire mija okabaaeka “Kire mija jããbe”, ãrĩwa'ri. I'suᵽaka mija ãrĩko'omakaja Ᵽilato ᵽuri ba'iaja kire baarika yaᵽaberikoᵽekaki. ");
INSERT INTO tnc_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Tuᵽarãte yaᵽaika uᵽakaja baaiki Jesúre ᵽoatarikoᵽakaja Barsabás, ᵽo'imajare jããrimajiratakiteje Ᵽilatore mija ᵽoatarũjeka. ");
INSERT INTO tnc_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","I'suᵽaka baawa'ri ᵽo'imajare õñia imajiᵽarika ja'atarimajire mija jããrũjeka. I'suᵽaka kire mija baako'omakaja, Tuᵽarã ᵽuri õñia kire jariᵽe'rirũjekaki. Kire ĩaekarã imarĩ, “Õñia kime mae”, yija ãrĩwãrũyu. ");
INSERT INTO tnc_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ĩ'ĩ bitamaji imakoᵽeroyiraᵽakite õñurã mija ime. Jesúre yi'yurã yija imamaka kiũ'ᵽua kire kijieyu. Kire ĩatirã “Rita sime, Jesúre kire jieika”, mija ãrĩwãrũyu. ");
INSERT INTO tnc_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ñoñua sime yijeyomarã, mija ĩᵽarimarãᵽitiyika õrĩᵽũaberiwa'ri Jesúre mija jããrũjeka. ");
INSERT INTO tnc_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","“I'suᵽaka simarãñu”, Tuᵽarãte ãrĩka simamaka suᵽa simaraᵽe. Mia je'e, bikija ikuᵽaka Tuᵽarãro'si bojaĩjirimajare ãrĩka: “Cristore ba'iaja baawã'imarĩtirã kire najããrãñu”, narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Sõñurã imarĩ, “Ba'iaja kire yija baaraᵽaka yijareka samiye'kariabe”, Tuᵽarãte mija ãᵽe mijare sakiye'kariaokaro'si. I'suᵽaka mija baarãkareka mijare kijeyobaaika jia õñurã mija imarãñu. ");
INSERT INTO tnc_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","I'suᵽaka mija imamaka Cristore mija ᵽõ'irã Tuᵽarãte ᵽũatarãñu ate. Bikijarãja “Ĩ'ĩ nare Jã'merũkika”, Tuᵽarãte ãrĩtikaki kime Jesús. ");
INSERT INTO tnc_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Maekaka mabo'ikakurirã Jesucristore ime ruᵽu. “Mae ritatojo wejea jierĩ me'ᵽe”, Tuᵽarãte kire ãrĩrãñurĩmi õ'õrã etarũkika kime. Ika yibojaika uᵽakaja Tuᵽarãro'si bojaĩjirimaja bikija kirirã imai'tara'aekarãte ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mia je'e, ikuᵽaka Moisés imaroyikakite bojaeka mañekiarãte: “Maiᵽamaki Tuᵽarãro'si bojarimaji ñima uᵽakaja aᵽika kirika bojarimajire kiᵽũatarãñu. I'suᵽaka baarãñuka matataki imarãki, suᵽabatirã ritaja kẽrĩrãka uᵽakaja mija yi'ᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kẽñu uᵽakaja yi'ribeyurãte ᵽuri toᵽi kire ᵽoatatirã, kire kiriatarãñu”, ãrĩwa'ri Moisés imaroyikakite bojaeka.— ");
INSERT INTO tnc_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Aᵽea ikuᵽaka Ᵽedrote ãrĩka: —Samuel imaroyikaki, suᵽabatirã kibe'erõ'õ Tuᵽarãro'si bojaĩjirimajaoka, maekaka imarũkiakaka, simauᵽakaja bojaekarã naro'si. ");
INSERT INTO tnc_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Bikija, mañekiarãte Tuᵽarãte bojatika nabojaeka kiro'si bojaĩjirimaja. “Moiséte imaeka uᵽaka aᵽika yirika bojaĩjirimajire yiᵽũatarãñu”, ãrĩwa'ri mañekiarãte Tuᵽarãte bojatika simamaka, simauᵽakaja sime maro'si mae. Ikuᵽaka Abraham imaekakite Tuᵽarãte bojaeka: “Jia ritaja ᵽo'imajare yibaarãñu, miriᵽarãmiᵽi ãrĩwa'ri”, Tuᵽarãte kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Mia yijeyomarã Israelkarã, Tuᵽarãte yaᵽaika uᵽakaja baarimaji kime Jesús. Õ'õrã Tuᵽarãte kire ᵽũataeka ᵽoto mamarĩ maro'si kire kiᵽũataeka jia mare kibaaokaro'si. Ba'iaja mabaaika maja'ataokaro'si i'suᵽaka Israelkarãro'si kibaaeka,— Ᵽedrote nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","2","“Najããekaki imariᵽotojo õñia Jesúre jariᵽe'rika. I'suᵽaka kibaaeka simamaka mareoka Tuᵽarãte õñia jariᵽe'rirũjerãñu”, Ᵽedro Juanᵽitiyika ᵽo'imajare bojabaraka imaeka ᵽoto naᵽõ'irã netaeka kurarãka, saduceokaka ᵽuᵽajoairã, suᵽabatirã Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'ia ĩarĩrĩrimaja ĩᵽamakioka. Koᵽakaja na'mitiritika simamaka, jimarĩa boebaka nimaeka. ");
INSERT INTO tnc_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Suᵽa nabaamaka Ᵽedro, Juanka ĩ'ᵽarãte wẽkomaka imariwi'iarã nare ne'ewa'rika. Na'itakarã sajaᵽakã'ã “Waeroka bikitojo naka majaiye'e”, narĩᵽuᵽajoaeka. ");
INSERT INTO tnc_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","I'suᵽaka nare nabaako'omakaja, Jesús majaroka kibojamaka ã'mitiritirã sayi'yurãte rĩkimarãja imaeka. Mia je'e, ĩmirĩjatakaja majoajĩkareka cinco mil rakamarãrõ'õjĩrã Jesúre yi'yurãte imaeka Jerusalénreka. ");
INSERT INTO tnc_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","6","Toᵽi mae bikitojo Jerusalénrãjaoka, judíotatarã ĩᵽarimarã, suᵽabatirã Moisére jã'meka wãrõrimaja, suᵽabatirã ᵽakiarimarãᵽitiyika torã narẽrĩka. Kurarãka ĩᵽamaki imatiyaiki Anás, suᵽabatirã Caifás, Juan, Alejandrorãkaoka imaekarã. Suᵽabatirã Anás tã'õmajaoka torã imaekarã. ");
INSERT INTO tnc_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Suᵽa imarĩ Ᵽedro, Juanᵽitiyika wẽkomaka imariwi'iarã imaekarãte Anáre akarũjeka. Mae kiᵽõ'irã eyatirã kiwã'tarã narĩkataeka ᵽoto, ikuᵽaka nare kijẽrĩaeka: —¿Maki i'suᵽaka baarika mijare jã'meraᵽaki? Suᵽabatirã, ¿marãkã'ã simamaka bitamajite mija jieraᵽe?— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","I'suᵽaka kẽᵽakã'ã, Esᵽíritu Santore kire jeyobaamaka ikuᵽaka Ᵽedrote yi'rika: —Yija ĩᵽarimarã, ᵽakiarimarãoka, mija ã'mitiᵽe ruᵽu. Makire yijare jã'memaka bitamajite wãtawa'ri kire yija jieraᵽe ãrĩwa'ri mijare sayija bojaerã baayu mae. ");
INSERT INTO tnc_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Mija ã'mitiᵽe Israelkarã. Jesús Nazaretkakite jã'meikaᵽi ãrĩwa'ri ĩ'ĩ bitamajite yija jieraᵽe. I'suᵽaka yijare baarũjeraᵽakite yaᵽua tetaekarã mija jããraᵽaka simako'omakaja õñia Tuᵽarãte kire jariᵽe'rirũjeraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Mija ã'mitiᵽe, bikija David imaekakite ikuᵽaka o'oeka: “Wi'ia baarimaja, ãta i'rõ mija taaeka. I'suᵽaka simako'omakaja aᵽika i'sio ãtaᵽi wi'ia kibaamaka aᵽo ãta tẽrĩwa'ribaji imatiyaio sajarika”, ãrĩwa'ri David imaroyikakite o'oeka, Tuᵽarãte ᵽũatarũkikate ᵽuᵽajoaweibaraka. ");
INSERT INTO tnc_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Jesucristo ĩ'rĩkaja imaki ritatojo wejeareka ᵽo'imajare tããrũkika Tuᵽarãte ᵽũataekaki. Maki aᵽika imabeyuka Jesús uᵽaka baaiki,— Ᵽedrote nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ᵽedro, Juanᵽitiyika kĩkirimarĩaja najaimaka ã'mitiritirã, ĩᵽarimarãre ᵽuᵽataeka. “Jia ᵽaᵽera wãrũtiyaberikarã imariᵽotojo jiitakaja najaiyu, Jesús jeyomarã mirãrã imarĩ”, narĩᵽuᵽajoaeka. ");
INSERT INTO tnc_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Bitamajite Ᵽedrorãkaka imamaka ĩawa'ri, “Ba'iaja mija baayu”, ĩᵽarimarãre nare ãrĩwãrũberika. ");
INSERT INTO tnc_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","16","Torãjĩrã mae, ᵽẽterã ĩᵽarimarãre nare ᵽorirũjeka. Ᵽẽterã na'rika be'erõ'õ natiyiaja ikuᵽaka najaibu'aeka: —¿Marãkã'ã nare mabaarãñu mae? Ritaja Jerusalénkarãre õrĩᵽatayu bitamajite najieka. Suᵽa imarĩ “Waᵽuju ᵽakirimaja nime”, marĩwãrũberijĩka sime. ");
INSERT INTO tnc_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","I'suᵽaka simamaka bitamaji majaroka ã'mitiririmarĩa sime. Suᵽa imarĩ ikuᵽaka nare marĩye'e mae: “Jesúrika ᵽo'imajare mija jaimirĩrĩkawa'rirãkareka ba'iaja mija jũarãñu”, nare marĩye'e,— ãrĩwa'ri ĩᵽarimarãre jaibu'aeka. ");
INSERT INTO tnc_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","I'suᵽaka baaweatirã nimaekarõ'õrã nare akatirã, ikuᵽaka nare narĩka: —Jesúmajaroka ᵽo'imajare mija wãrõa'si mae,— nare narĩkoᵽeka. ");
INSERT INTO tnc_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","I'suᵽaka ĩᵽarimarãre nare ãᵽakã'ã, ikuᵽaka nare nayi'rika: —Mija ãñua yija yi'rijĩkareka, Tuᵽarãte yi'ribeyurã yija jarijĩñu. ¿Tuᵽarãte yi'ririkoᵽakaja, mijare yija yi'rijĩñu bai je'e? Tuᵽarãte ĩaika wãjitãji, ¿dika jiibaji imaje'e, mija ᵽuᵽajoaikareka? ");
INSERT INTO tnc_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Jesúre ãrĩka yija ã'mitirika mirãka, kibaaroyika yija ĩaekaoka, bojarija'ataberijĩrã yija ime,— narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","I'suᵽaka naᵽakã'ã, —Samija bojarimirĩrĩkawa'ria'si. I'suᵽaka mija baarãkareka, ba'iaja mija jũarãñu,— ĩᵽarimarãre nare ãrĩka. Bitamaji imakoᵽekakire tuᵽakã'ã ĩawa'ri, jia ᵽo'imajare jiyiᵽuᵽaka Tuᵽarãte õrĩka. Suᵽabatirã najiekaki, ĩ'ᵽarã ᵽo'imaja ᵽemawa'ribaji wejejẽ'rãka eyawa'yuka kimaeka. I'suᵽaka ᵽo'imajare imamaka kĩkiwa'ri ba'iaja Ᵽedrorãkare baabekaja ĩᵽarimarãre nare ᵽoataeka. ");
INSERT INTO tnc_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ᵽoriwa'ritirã najeyomarã ᵽõ'irã Ᵽedrorãkare eyaeka. Naᵽõ'irã eyatirã kurarãka, suᵽabatirã ᵽakiarimarãre jaika nare nabojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Sã'mitiritirã ĩ'rĩka ta'iarãja ᵽuᵽakirã imarĩ ikuᵽaka Tuᵽarãte najẽñeka: —Yija ĩᵽamaki, ritaja õñuka mime. Suᵽa imarĩ mi'ijioka imaki wejeᵽema, ka'ia, riaᵽakiaka, suᵽabatirã ritaja sareka imarũkia baaekaki. ");
INSERT INTO tnc_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Bikija, yija ñeki David, miyaᵽaika uᵽakaja baaroyikaki Esᵽíritu Santore kire jeyobaamaka ikuᵽaka kio'oeka: “¿Dako baaerã judíotatarã, judíotatamarĩrãoka Tuᵽarãte boebariwa'ri, ba'iuᵽakaja kire nabaariᵽuᵽajoaeka? ");
INSERT INTO tnc_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ritatojo wejeareka imarã ĩᵽarimarã, suᵽabatirã ᵽo'imajare imaruᵽutarimajaka rẽrĩtirã, imaweitikaja nimaeka ba'iaja mire baaerã. Suᵽabatirã ‘Jã'merimaji kimarũ’, ãrĩwa'ri miᵽũataekakiteoka ba'iaja baaokaro'si nimaeka”, ãrĩwa'ri kio'oeka. ");
INSERT INTO tnc_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Rita Davidre o'oeka uᵽakaja simaraᵽe yija wejearã. Ĩᵽi Herodes, suᵽabatirã Ᵽoncio Ᵽilato, aᵽetatarã, suᵽabatirã Israelka'iakarãoka ĩ'rĩka ta'iarãja ᵽuᵽaritiirã nimaeka. Miyaᵽaika uᵽaka baarimaji miᵽũataekakire ba'iaja baaokaro'si i'suᵽaka naᵽuᵽajoaeka. ");
INSERT INTO tnc_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bikijarãja “I'suᵽaka nabaarãñu”, merĩka uᵽakaja imawa'ri suᵽa nabaaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yija Ĩᵽamaki, yijare mia'mitiᵽe. “Ba'iaja mija jũarãñu”, yijare nañua miye'kariria'si. Jia mire yi'yurã yija imamaka yijare mijeyobaabe. Suᵽabatirãoka dako werikimarĩaja Jesús majaroka yija wãrõerã yijare mijeyobaabe. ");
INSERT INTO tnc_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Tẽrĩriki imarĩ wãmarĩa imarãte jiebaraka maikoribeyua mibeabe, “Jesúᵽi ãrĩwa'ri i'suᵽaka sime”, ᵽo'imajare ãñaokaro'si,— Tuᵽarãte narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tuᵽarãte najaiweaeka ᵽoto, nimaekarõ'õ ka'ia iyika. I'suᵽaka sabaaeka watoᵽekaᵽi, Esᵽíritu Santore nare ña'rĩjãika. Saᵽi ãrĩwa'ri dakoa werikimarĩaja Tuᵽarã majaroka ᵽo'imajare nabojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jesúre yi'yurã ĩ'rĩka ta'iarãja ᵽuᵽakirã imaekarã. Suᵽa imarĩ narikaika, “Yirikatakaja sime”, ãrĩbeyurã imarĩ “Maro'siji sime”, ãrĩwa'ri najeyomarãre najeyobaaeka. ");
INSERT INTO tnc_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","35","Ĩ'rãrimarã naro'siji ka'iareka imarã, suᵽabatirã wi'ia aᵽerãte nijirũkia nareka imarã, sawaᵽa niñerũ natõᵽoika aᵽóstolrãkare nijika, wayuoka baairãte najeyobaaerã. Suᵽa imarĩ nakaki ĩ'rĩkaoka wayuitaka baaikite imaberika. Suᵽabatirã Tuᵽarãte nare jeyobaamaka jiitakaᵽiji “Maiᵽamaki Jesús reyariᵽotojo õñia jariᵽe'rikaki”, ãrĩwa'ri aᵽóstolrãkare wãrõrija'ataberika. Suᵽa imarĩ Jesúre yi'yurã rakamarãja jĩjimaka nimaokaro'si Tuᵽarãte nare jeyobaaeka. ");
INSERT INTO tnc_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Mia, Jesúre yi'yurã watoᵽekareka José wãmeiki levita imaeka. Chiᵽre wãmeika jũmurikarã ᵽo'ijirikaki kimaeka. Aᵽóstolrãka, Josére Bernabé kiwãmea no'aeka. Griego okaᵽi, “Jĩjimaka aᵽerãte imarũjerimaji”, ãrĩrika simaeka. ");
INSERT INTO tnc_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Kiro'siji kika'ia kirikaeka José. I'sia aᵽikate kĩjika sawaᵽa tõᵽotirã aᵽóstolrãkare ĩjiokaro'si, wayuoka baairãte najeyobaaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ananías kirũmu Safiraᵽitiyika ᵽuri ikuᵽaka nabaaeka: Ananías kirũmuᵽitiyika narioa ĩjitirã sawaᵽa niñerũ natõᵽoeka. ");
INSERT INTO tnc_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ĩ'rãtiji ᵽuᵽakirã imarĩ ka'i waᵽa imaekakaka kũᵽajĩ naya'eka. Suᵽabatirã saᵽiyia aᵽóstolrãkare kĩjika ᵽoto, —Õ'õjĩrãja yitõᵽoko'o,— kẽrĩᵽakika. ");
INSERT INTO tnc_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","4","I'suᵽaka kẽᵽakã'ã ikuᵽaka Ᵽedrote kire ãrĩka: —Ananías, ¿dako baaerã Satanáre miyi'yu? Mirioaja sime mijiraᵽaka. ¿Sawaᵽa mire nawaᵽaĩjika mirikamarĩa sime bai je'e? I'suᵽaka simako'omakaja “Simaja riowaᵽa mijare ñijiᵽatayu”, merĩᵽakiyu. I'suᵽaka meñua yijare takajamarĩa miᵽakiyu. Tuᵽarãte, suᵽabatirã Esᵽíritu Santoreoka ᵽakiwa'ri suᵽa mibaayu,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","I'suᵽaka kire kẽrĩkarõ'õjĩteje Ananíare ᵽuᵽaririña'rĩka. I'suᵽaka ima ã'mitiritirã, jimarĩa tokarãre ᵽuᵽataeka. ");
INSERT INTO tnc_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Toᵽi mae ĩ'rãrimarã bikirimaja kire butetirã kire yayerĩ na'rika. ");
INSERT INTO tnc_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Torãjĩrã mae, maekarakakuri aiyajẽrã be'erõ'õ Ananías rũmu mirãkote etaeka, i'suᵽaka kibaaeka õrĩbekaja. ");
INSERT INTO tnc_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Koetaeka ᵽoto, —¿Simauᵽatiji bai sime ika riowaᵽa mija tõᵽoraᵽaka?— Ᵽedrote kore ãrĩka. —Ã'ã, simauᵽatiji sime,— kõrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","I'suᵽaka kõᵽakã'ã ikuᵽaka kore kẽrĩka: —¿Dako baaerã mitĩmika ĩ'rãtiji ᵽuᵽajoatirã, Tuᵽarãte ᵽũataekaki Esᵽíritu Santore miᵽakiyu je'e? Ᵽẽterã netara'ayu mitĩmite yayerĩ turiko'orã. Mire yayerĩ na'rirãñu ate,— kore kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","I'suᵽaka kẽrĩka ᵽotojo, koᵽuᵽaririña'rĩka koro'sioka. Torã kãkatirã, bikirimajare kore ĩatõᵽoeka. Toᵽi mae kore e'ewa'ritirã kotĩmite nayayekarõ'õrã kore nayayeka. ");
INSERT INTO tnc_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nimarakamakiji Jesúre yi'yurã, suᵽabatirã ritaja ᵽo'imaja, “I'suᵽaka sime're”, naᵽakã'ã ã'mitiritirã jimarĩa naᵽuᵽataeka. ");
INSERT INTO tnc_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","I'sia ᵽoto Jesúre yi'yurã ĩ'rĩka jariwa'ririmarĩaja ĩ'rĩka ta'iarãja ᵽuᵽakirã imarĩ, Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'i wã'tarã Ᵽórtico de Salomón wãmeirõ'õrã narẽrĩrijarika. Jerusalénkarãre ĩaeka wãjitãji Tuᵽarãte kirikaᵽi nare kijeyobaamaka rĩkimakaja maikoribeyu uᵽaka ima aᵽóstolrãkare baabeaeka. ");
INSERT INTO tnc_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Jesúre yi'yurãte jiyiᵽuᵽaka õrĩwa'ri “Jiirã nime Jesúre yi'yurã”, Jerusalénkarãre ãrĩko'omakaja marã kire yi'yurãka rẽrĩberikarã, “Werika sime je'e”, ãrĩᵽuᵽajoawa'ri. ");
INSERT INTO tnc_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Toᵽi rõmijã, ĩmirĩjaoka rĩkimabaji Maiᵽamakire yi'yurãte ᵽuburijarika. ");
INSERT INTO tnc_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Maikoribeyua uᵽaka ima Ᵽedrote baabeaeka ã'mitiritirã, wãmarĩa imarãte naᵽeyurũkiaᵽi e'era'atirã ma'arijerã nare naᵽããjiyeka. I'suᵽaka nabaaekarã, Ᵽedrote o'ririka nata'aeka, “Yire kiraberũ”, ãrĩwa'ri. “Mare kirabeberikoᵽerãkaoka, kirãrãrika mabo'iᵽi o'rirãkaᵽiji matãrĩrãñu je'e”, ãᵽaraka kire nata'aeka. ");
INSERT INTO tnc_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","I'suᵽakajaoka Jerusalén koyikuri imaekarã, wãmarĩa imarãte, suᵽabatirã naᵽuᵽakareka Satanárika nã'rĩjãikarãreoka naᵽõ'irã ne'ewa'rika. Toᵽi mae, i'suᵽaka nimauᵽatiji jia oyiaja najarika. ");
INSERT INTO tnc_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","I'sia ã'mitiritirã kurarãka ĩᵽamaki imatiyaiki, suᵽabatirã kijeyomarã saduceokaka ᵽuᵽajoairãoka aᵽóstolrãkare jimarĩa ã'mijĩ'aekarã ba'iaja naka imawa'ri. ");
INSERT INTO tnc_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","I'suᵽaka imawa'ri nare ñi'arũjetirã Jerusalénrã imaeka wẽkomaka imariwi'iarã, nare natarũjeka. ");
INSERT INTO tnc_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Torã nimaeka simako'omakaja i'siñamiji ángel Tuᵽarãte ᵽũataekakite naᵽõ'irã ᵽemakotowirika. Suᵽabatirã koᵽereka wiwatatirã nare kiᵽoataeka. ");
INSERT INTO tnc_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Nare ᵽoatatirã, —Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã mija a'ᵽe. Torã eyatirã, Tuᵽarã ᵽõ'irã õñia imajiᵽarikakaka ᵽo'imajare mija bojabe,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","I'suᵽaka kẽᵽakã'ã bikitojo ñamiji, Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã ᵽo'imajare nawãrõeka mae. I'suᵽaka nare wãrõbaraka nimaeka ᵽoto, kurarãka ĩᵽamaki imatiyaiki, kijeyomarãᵽitiyika, Israelka'iakarã ĩᵽarimarãre nakaeka, naka rẽñaokaro'si. Torãjĩrã wẽkomaka imariwi'iarã surararãkare naᵽũataeka aᵽóstolrãkare nakayaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Wẽkomaka imariwi'iarã eyatirã niamaka torã nimaberika. Torã ĩakoᵽetirã, surararãkare ᵽe'riwa'rika ĩᵽarimarãre bojarĩ. ");
INSERT INTO tnc_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Wẽkomaka imariwi'ia jia tãteka imarõ'õrã yija eyako'o. Satuerimajaoka sakoᵽerekarãja imako'orã. I'suᵽaka simako'omakaja koᵽereka wiwatatirã, yija ĩamaka, torã nimaberiko'o,— narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Sã'mitiritirã, kurarãka ĩᵽamaki suᵽabatirã Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'ia tuerimaja ĩᵽamakioka, marãkã'ã baaberijĩka najũaeka. Suᵽa imarĩ “¿Marãkã'ãtaka ruku simarãñu mae?”, narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","I'suᵽaka ãᵽaraka nimaeka ᵽoto ĩ'rĩka naᵽõ'irã eyatirã ikuᵽaka nare ãrĩkaki: —Mia, wẽkomaka imariwi'iarã mija takoᵽekarã, Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã ᵽo'imajare wãrõbaraka imarã maekaka,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Suᵽa kẽᵽakã'ã Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'ia tuerimaja ĩᵽamaki, kisurararãkaka aᵽóstolrãkare e'erĩ ke'rika. Naᵽõ'irã eyatirã ba'iuᵽakaja nare baabekaja nare ne'ewa'rika. “Ba'iaja nare mabaamaka, ãtaᵽi ᵽo'imajare mare jããrãñu je'e”, narĩᵽuᵽajoaeka kĩkiwa'ri. ");
INSERT INTO tnc_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nare e'ewa'ritirã, ĩᵽarimarã ᵽõ'irã nare ne'eeyaeka. Torã ne'eeyamaka ĩatirã ikuᵽaka kurarãka ĩᵽamakire nare ãrĩka: ");
INSERT INTO tnc_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Mijare taka ᵽuri “Jesús majaroka mija boja'si”, yija ãrãᵽe're. I'suᵽaka yija ãrãᵽaka simako'omakaja ritaja Jerusalénkarãre samija wãrõyu. Suᵽa imarĩ nimauᵽatiji sanorĩᵽatayu mae. “Naᵽareareka Jesúre najããeka”, yijareka mija ãñu,— kurarãka ĩᵽamakire nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Toᵽi ikuᵽaka aᵽóstolrãkaᵽitiyika Ᵽedrore kire yi'rika: —Tuᵽarã kime yi'ritiyarũkika, ᵽo'imaja bo'ibajirã imaki kimamaka. ");
INSERT INTO tnc_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jesús yaᵽua tetaekarã mija jããrũjekakite, Tuᵽarãte õñia jarirũjeka. Iki Tuᵽarã imaki, bikijarãja mañekiarãte jiyiᵽuᵽayeera'aekaki. ");
INSERT INTO tnc_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Mabo'ikakuriᵽi Tuᵽarãte kire akaeka simamaka kiritaᵽẽ'rõto jiyiᵽuᵽayeerũkirõ'õrã Jesúre ruᵽe maekaka. “Ᵽo'imaja ĩᵽamaki mimabe”, kire kẽrĩka. I'suᵽakajaoka ᵽo'imajare ba'iaja baaikareka tããrũkika Tuᵽarãte kire imarũjeka. “Mi'iᵽi ãrĩwa'ri Israel riᵽarãmerãte ba'iaja baaika naja'ataerã nareka sayiye'kariarãñu”, kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ritaja Jesúre imaroyiraᵽaka ĩaekarã imarĩ, ᵽo'imajare sayija bojarijayu. Suᵽabatirãoka “Rita sime nabojarijayua”, ᵽo'imajare ãñaokaro'si Esᵽíritu Santore i'suᵽaka baarijayu. Tuᵽarãte jã'meika yi'yurã rakakaja, Esᵽíritu Santore yijare kiña'ajããroyiraᵽe,— Ᵽedrote nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","I'suᵽaka kẽᵽakã'ã ã'mitiritirã, jimarĩa boebariwa'ri nare jããrika nari'kaeka. ");
INSERT INTO tnc_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Naᵽitiyika ĩ'rĩka fariseokaka ᵽuᵽajoaiki, Gamalielte imaeka. Moisés imaroyikakite jã'meka jiitakaja wãrõrimaji kimamaka ᵽo'imajare jiyiᵽuᵽaka kire õrĩka. Aᵽerã ĩᵽarimarãᵽitiyika jaiokaro'si wirirĩkatirã, toᵽi Ᵽedrorãkare kiᵽorirũjeka. ");
INSERT INTO tnc_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Suᵽabatirã ikuᵽaka kijeyomarãka kijaika: —Jia mija ã'mitiᵽe yitã'omaja Israeltatarã. Ĩ'rãre baarika mija yaᵽaikakaka, jia mija ᵽuᵽajoabe. ");
INSERT INTO tnc_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","¿Teudas wãsare baaroyikakaka mija ye'kariritiyu bai je'e? “Imatiyaiki imarĩ ᵽitã'mua Romakarãka ko'aᵽiritirã nare yiᵽoatarãñu maka'iaᵽi”, kẽrĩkoᵽeka be'erõ'õ dikarakakuri wejejẽ'rãkamarĩaja seyawa'yu. Sã'mitiritirã, “Rita sime je'e”, ãrĩwa'ri cuatro cientorakamarã Teudare nayi'rika. Simako'omakaja surararãkare kire jããeka. Suᵽa imarĩ kika imakoᵽekarãre nayaᵽayu uᵽaka ᵽibiᵽatemaka, kijã'mekoᵽekaoka ritaariberika. ");
INSERT INTO tnc_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Sabe'erõ'õ “I'siarakamarã ᵽo'imajare ime”, ãrĩwa'ri nawãmea no'oirĩmi seyaeka ᵽoto Galileakaki, Judare õ'õrã etaeka. Kireoka kijaika yi'riwa'ri rĩkimarãja ᵽo'imajare kika imakoᵽeka. Teudare nabaaeka uᵽakajaoka surararãkare kire baaeka. Suᵽa imarĩ kika imakoᵽekarãoka ᵽibiᵽatekarã. ");
INSERT INTO tnc_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","I'suᵽaka simaeka õrĩwa'ri “Ba'iaja baabekaja ĩ'rãre mija ja'atabe”, mijare ñañu. Waᵽuju naᵽuᵽaka nare ãñu uᵽakaja nabaaikareka ritaariberijĩka sime ãrĩwa'ri ñañu. ");
INSERT INTO tnc_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","I'simajaroka bojarĩ Tuᵽarãte ᵽũataraᵽarã nimajĩkareka ᵽuri marãkã'ã nare mija tá'tewãrũbesarãñu. Ba'iaja nare mija baariyaᵽarãkareka jia mija ᵽuᵽajoabe ruᵽu, Tuᵽarãte yaᵽaika uᵽakamarĩa mija baa'si,— Gamalielre nare ãrĩka. I'suᵽaka nare kẽᵽakã'ã, —Rita meñu,— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Torãjĩrã Ᵽedrorãkare nakaeka ate. Naᵽõ'irã netaeka ᵽoto nare ᵽajerũjetirã, —Jesús majaroka mijare bojarika imabeyua mae,— ãrĩtirã nare naᵽoataeka. ");
INSERT INTO tnc_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Toᵽi mae jĩjimakaᵽi Ᵽedrorãkare ᵽorika ĩᵽarimarã ᵽõ'iᵽi. “Jesúre yi'riwa'ri kire ja'atabeyurã imarĩ ba'iaja ᵽo'imajare mare baamaka, jiyiᵽuᵽaka Tuᵽarãte mare õñu”, Ᵽedrorãkare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","“Ᵽo'imajare tããokaro'si Tuᵽarãte ᵽũataekaki kime Jesús”, bojarika ĩᵽarimarãre jãjibaako'omakaja ᵽo'imajare Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã ĩ'rãrĩmi uᵽakaja aᵽóstolrãkare sawãrõroyika. Suᵽabatirãoka nawi'iarã ᵽo'imajare imarõ'õrã i'suᵽaka oyiaja nabaaroyika. ");
INSERT INTO tnc_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Torãjĩrã i'sijẽ'rãreka rĩkimabaji Jesúre yi'yurãte imarijarika. Suᵽa imarĩ griego oka jairã ikuᵽaka ãrĩkarã hebreo oka jairãte: —Ĩ'rãrĩmi uᵽakaja ba'arika ᵽibariᵽotojo, jia ĩ'rãtiji samija ĩjibeyu. Natĩmiarãte reyataᵽaekarã hebreo oka jairã rõmijãte takaja rĩkimabaji mija ĩjirijayu,— narĩka griego jairã. ");
INSERT INTO tnc_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","I'suᵽaka najaimaka ã'mitiritirã, Jesúre yi'yurãte nakaeka aᵽóstolrãka. Suᵽabatirã ikuᵽaka nare narĩka: —Yija wãrõrijayua ba'arika ᵽibarika ᵽemawa'ribaji imatiyaika sime yijaro'si ᵽuri. I'suᵽaka simamaka ba'arika takaja yija ᵽuᵽajoarikareka yija ima ja'atarimaja yija imajããeka. ");
INSERT INTO tnc_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","I'suᵽaka simamaka yija jeyomarã, ĩ'ᵽotẽñarirakamarã jia ᵽuᵽajoairã, jiyiᵽuᵽaka noñurã imawa'ri Esᵽíritu Santore jia yi'yurãte mija wã'mabe, “Ba'arika ᵽibarimaja mija imabe”, nare yija ãñaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Yija ᵽuri, Tuᵽarãte takaja jairimaja, suᵽabatirã kirika bojariroka wãrõrimaja imarã,— aᵽóstolrãkare nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","I'suᵽaka naᵽakã'ã “Rita sime”, ãñurã oyiaja nimaeka Jesúre yi'yurã. Suᵽa imawa'ri “Esteban imaki jia Tuᵽarãte yi'yuka imarĩ, kiyaᵽaika uᵽakaja baarijayuka Esᵽíritu Santore kire jeyobaamaka”, ãrĩwa'ri kire ne'eka. Suᵽabatirã ne'eka Feliᵽe, Ᵽrócoro, Nicanor, Timón, Ᵽármenas, suᵽabatirã Antioquíakaki Nicolás, judíorãkamarĩka imariᵽotojo jia nare yi'yukaᵽitiyika nimaeka ba'arika ᵽibarimaja ne'ekarã. ");
INSERT INTO tnc_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Suᵽabatirã aᵽóstolrãka ᵽõ'irã nare ne'ewa'rika. “Ĩ'rã nime ba'arika ᵽibarimaja yija wã'mako'orã”, nare narĩka. Suᵽabatirã aᵽóstolrãka naᵽitaka naruᵽuko'a ᵽemarã ja'aᵽeatirã, “Miyaᵽaika uᵽakaja nabaaokaro'si nare mijeyobaabe”, Tuᵽarãte najẽñeka. ");
INSERT INTO tnc_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Saᵽi ãrĩwa'ri Jesúrika bojariroka yi'yurãte bojaeka ã'mitiritirã rĩkimabaji sayi'yurãte Jerusalénrã ᵽuburijarika. Suᵽabatirãoka kurarãkaoka rĩkimarãja kimajaroka ã'mitiriᵽẽaekarã. ");
INSERT INTO tnc_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Tuᵽarãte kire jeyobaamaka jimarĩa maikoribeyua ᵽo'imajare ĩaeka wãjitãji Estebanre baabearoyika. ");
INSERT INTO tnc_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","I'suᵽaka baabaraka kimaekarõ'õrã judíorãkare rẽrĩriwi'iaᵽi i'taekarãte eyaeka ikuᵽaka kibaarijarika yaᵽaberiwa'ri. “Ᵽoyarãre a'ritaᵽaekawi'i”, ãrĩrika uᵽaka wãmeirõ'õ simaeka. Cirenekarã, Alejandríakarã, Ciliciakarã, suᵽabatirã Asiaka'iakarãᵽitiyika nimaeka torã rẽrĩkarã. Ĩ'rã Estebanka okabojikarã. ");
INSERT INTO tnc_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","I'suᵽaka kire nabaako'omakaja jia Estebanre nare yi'riwãrũeka, Esᵽíritu Santore kire jeyobaamaka. Suᵽa imarĩ marãkã'ã baatirã kire nokatẽrĩwãrũberika. ");
INSERT INTO tnc_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kire okatẽrĩwãrũberiwa'ri, aᵽerãte niñerũ nawaᵽaĩjika, Estebanre nabojajããokaro'si. Se'ekarã “Tuᵽarãte, suᵽabatirã Moisés imaroyikakiteoka Estebanre jaiyuyeraᵽaka ã'mitiraᵽarã yija ime”, ãrĩwa'ri aᵽerãte naᵽakibojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Naᵽakika ã'mitiritirã, jimarĩa wejeakarã, suᵽabatirã ᵽakiarimarã, Moisés imaroyikakite jã'meka wãrõrimajaoka kire boebariwa'ri Estebanre ñi'atirã judíorãka ĩᵽarimarã ᵽõ'irã kire ne'ewa'rika. ");
INSERT INTO tnc_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ĩᵽarimarã ᵽõ'irã kire ne'eeyaeka ᵽoto majaroka ᵽakirimajare nakaeka. Niñerũ nawaᵽaĩjimaka ikuᵽaka nabojaᵽakika: —Ĩ'rãkurimarĩa Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'ia suᵽabatirã Moiséte jã'mekaoka kijaiyuyemaka yija ã'mitiyu. ");
INSERT INTO tnc_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Suᵽabatirã “Jesús Nazaretkaki Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'ia kuyeᵽaterãki, suᵽabatirã Moisés imaekakite jã'meroyika saᵽi ᵽuᵽaika maima kio'arãñu”, i'suᵽaka Estebanre ãᵽakã'ã yija ã'mitiyu,— ãrĩwa'ri nabojaᵽakika. ");
INSERT INTO tnc_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Suᵽa imarĩ torã imaekarãte kire yoirĩkaeka. I'suᵽaka kire nabaamaka ángel ᵽema uᵽaka ya'tarika kiᵽema jarika. ");
INSERT INTO tnc_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Torãjĩrã mae ikuᵽaka Estebanre kẽrĩka kurarãka ĩᵽamaki imatiyaiki: —¿Yaje rita sime i'suᵽaka nañua?— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","I'suᵽaka kẽᵽakã'ã, ikuᵽaka kire kẽrĩka: —Mija ã'mitiᵽe yitã'omaja. Bikija mañeki Abraham imaekakite Mesoᵽotamiaka'iarã kimaeka ᵽoto tẽrĩwa'ribaji õñuka Tuᵽarãte kire ᵽemakotowirika, Haránwejearã ke'rirã baaeka ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ikuᵽaka sãñu Tuᵽarã majaroᵽũñurã: “Mimarõ'õ miᵽoritaᵽabe, suᵽabatirã mirĩrãreoka toᵽi me'ewa'ᵽe aᵽea ka'ia mire yibearãñurõ'õrã”, Tuᵽarãte kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","I'suᵽaka Tuᵽarãte kire ãᵽakã'ã ã'mitiritirã, Caldearõ'õᵽi ᵽoritirã Haránwejearã imarĩ ke'rika. Torã keyaeka be'erõ'õ mae kiᵽaki wãsare kire reyataᵽaeka. I'sia be'erõ'õ ika maka'iarã Abrahamre imaerã Tuᵽarãte kire ᵽũataeka. ");
INSERT INTO tnc_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","“Torã mimabe”, Tuᵽarãte kire ãrĩko'omakaja, saba'iᵽimarĩa kimaeka ruᵽu. Suᵽa imarĩ “Yirika sime ika ka'ia”, Abrahamre ãrĩwãrũberika. Toᵽi mae ikuᵽaka simatiyayu Tuᵽarãte kire ãrĩka: “I'sia ka'ia mire ñijirãñu. Mireyarãka be'erõ'õ, miriᵽarãmerãrika simarãñu”, kire kẽrĩka, makarãmarĩka kimako'omakaja. ");
INSERT INTO tnc_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Toᵽi ikuᵽaka Tuᵽarãte kire ãrĩka ate: “Ñamajĩ toᵽi ᵽoritirã aᵽerã ka'iarã miriᵽarãmerãte imarãñu. Torã nimarãka ᵽoto cuatro ciento rakakuri wejejẽ'rãkarõ'õjĩrã nare najã'mewã'imarĩrijarirãñu. ");
INSERT INTO tnc_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","I'suᵽaka simako'omakaja miriᵽarãmerãte ba'iaja nabaarãka waᵽa ba'iaja nare yibaarãñu yiro'si. Suᵽa yibaamaka toᵽi ᵽe'rira'atirã ika ka'iarã miriᵽarãmerãte etarãñu ate. Torã imatirã ñamajĩ yire jiyiᵽuᵽaka õrĩwa'ri yika najairijarirãñu”, Tuᵽarãte ãrĩka mañeki Abraham imaroyikakite. ");
INSERT INTO tnc_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Suᵽabatirã ikuᵽaka Abrahamre kẽrĩka ate: “Mire yibojaika ã'mitiriᵽẽatirã, ‘I'suᵽaka yibaarãñu’, merĩrãkareka, mimakire ᵽo'ijirirãka be'erõ'õ circuncisión kire mibaabe. ‘Tuᵽarãriki kime’, ãrĩwa'ri i'suᵽaka kire mibaarãñu”, Abrahamre kẽrĩka. I'suᵽaka Tuᵽarãte kire ãrĩka simamaka, kimaki Isaacre ᵽo'ijirika maekarakaotẽñarirakarĩmi seyawa'rika ᵽoto circuncisión Abrahamre kire baaeka. Suᵽabatirãoka Isaac, kimaki Jacobre i'suᵽakajaoka kibaaeka. Jacobooka i'suᵽakaja baaekaki kimakarã mañekiarã ĩ'ᵽoũ'ᵽuarãe'earirakamarã imaekarãre. ");
INSERT INTO tnc_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Jacob makarã, narĩ'ĩ Josére jimarĩa na'mijĩaeka, (naᵽakire wãtatiyaekaki kimamaka). Suᵽa imarĩ Egiᵽtokarãre kire ĩjitirã kiwaᵽa nare najẽñeka. Suᵽa kire nabaamaka Egiᵽtokarã naba'iraberimaji uᵽaka kimaokaro'si kire ne'ewa'rika. I'suᵽaka kire nabaako'omakaja Tuᵽarã ᵽuri jia kika imaekaki. ");
INSERT INTO tnc_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Egiᵽtorã Josére ba'iaja jũarũkia imakoᵽekareka Tuᵽarãte kire tããeka. I'suᵽaka kire kibaamaka tokaki ĩᵽi Faraón ᵽõ'irã Josére imaeka. I'suᵽaka kimaeka ᵽoto jia kiõrĩwãrũrũkia Tuᵽarãte ja'ataeka Josére. Saᵽi ãrĩwa'ri Faraónte jĩjimaka Joséka imarijarika. I'suᵽaka kika imawa'ri “Egiᵽtokarã imauᵽatireje yiwi'iakarãreoka jã'merimaji mimabe”, Faraónre kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","I'sia ᵽoto Egiᵽtorã ba'arika ᵽurika. Suᵽabatirã Canaán ka'iarekaoka i'suᵽakaja sajarika. Suᵽa imarĩ ba'arika imabeᵽakã'ã kẽsirabawa'ri, jimarĩa ba'iaja najũaeka. I'suᵽaka najũaeka mañekiarã no'orã ba'arika tõᵽowãrũberiwa'ri. ");
INSERT INTO tnc_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Suᵽa imarĩ mañeki Jacob, “Egiᵽtorã trigo nawaruayu're”, ãrĩrika majaroka ã'mitiriwa'ri, José ma'merãre kiᵽũataeka “Samija waᵽaĩjiaᵽe”, ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Suᵽa imarĩ torã ba'arika e'erĩ natuyarika. Sabe'erõ'õ torãjaoka na'rika ate. I'suᵽaka nabaamaka ikuᵽaka Josére nare ãrĩka: “Yire mija ĩawãrũbeyu, mija rĩ'ĩji ñime”, nare kẽrĩka. I'suᵽaka Josére nare ãrĩka majaroka ᵽo'imajare kire bojamaka, “Jee, hebreotataki kime kã'ã”, Faraónre ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Torãjĩrã mae, kirĩrã nimauᵽatiji kiᵽakiᵽitiyika setenta y cinco rakamarã imaekarãte Josére akarũjeka Egiᵽtorã nimaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Torãjĩrã mae, Egiᵽtorã imarĩ, Jacobre a'rika. Ñoaka torã kimaeka be'erõ'õ kireyaeka. Suᵽabatirã kimakarã mañekiarã wãsarãoka torãja reyaekarã. ");
INSERT INTO tnc_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Nareyaeka rakakaja Siquem wãmeirõ'õrã nare ne'ewa'rika, ãta wi'iarã namajaka tarĩ. Abraham wãsare Hamor makarãte waᵽaĩjikarõ'õ simaeka nare nataekarõ'õ. ");
INSERT INTO tnc_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","I'suᵽaka simako'omakaja rĩkimabaji Egiᵽtorã mañekiarãte imarijarika. I'suᵽaka nimekã'ãja, koyia sajaririjarika “Miriᵽarãmerãte ka'ia ñijirãñu”, ãrĩwa'ri Abrahamre Tuᵽarãte ãrĩka uᵽaka seyarũkia. ");
INSERT INTO tnc_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","I'suᵽaka simarijarika ᵽoto Josére imaroyika õrĩbeyuka, suᵽabatirã mañekiarãte imaroyikaoka jiyiᵽuᵽaka õrĩbeyuka Egiᵽtorã mamaka ĩᵽire imaeka. ");
INSERT INTO tnc_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Iki ĩᵽi imaekaki ᵽakibaraka ba'iaja mañekiarãte baaekaki. I'suᵽaka baabaraka, “Rõmijãre makarããritirã, ĩmirĩji kimajĩkareka kire mija taabe kijĩñaokaro'si”, nare kijã'meka. ");
INSERT INTO tnc_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","I'suᵽaka kijã'meka ᵽoto jiyuritakijĩka Moiséte ᵽo'ijirika. Suᵽa imarĩ maekarakamaki aiya kire ja'atabekaja kiᵽakiarãte kire ba'iarika. ");
INSERT INTO tnc_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","22","Marãkã'ã baatirã wi'iarã kire ya'ewãrũberiwa'ri kiᵽakore kire taaeka, toᵽi Faraón makore kire e'eeka komaki uᵽaka kire ba'iayaokaro'si. Koka kimarijayukã'ãja Egiᵽtokarãre ᵽuᵽajoaikakaka jia Moiséte õrĩwãrũeka. Suᵽa imarĩ jia jaiwãrũiki, suᵽabatirãoka imatiyaika oyiaja baaiki kimaroyika. I'suᵽaka kimamaka ĩatirã jia jiyiᵽuᵽaka kire norĩka. ");
INSERT INTO tnc_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ĩ'ᵽarã ᵽo'imajarakakuri wejejẽ'rãka keyaeka ᵽoto “Matikuri yitã'omajare ĩarĩ ya'riye'e mae”, kẽrĩᵽuᵽajoaeka. ");
INSERT INTO tnc_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Torã keyaeka ᵽoto, kitã'omajire kiᵽajeka ĩ'rĩka Egiᵽtoka'iakaki. Suᵽa kibaamaka, ruᵽuwaᵽae'erã baakõrĩ, Moiséte kire jããeka. ");
INSERT INTO tnc_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","“ ‘Egiᵽtoka'iakarãte ba'iaja mare baamaka mare e'eru'awa'ririmaji Tuᵽarãte jã'mekaki Moiséte ime’, yitã'omajare yire ãrĩrũ”, kẽrĩᵽuᵽajoaeka. I'suᵽaka kiᵽuᵽajoako'omakaja, sayi'ribeyurã uᵽaka nimaeka. ");
INSERT INTO tnc_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Toᵽi mae aᵽerĩmi ĩ'ᵽarã Israelkarã ᵽajairãte kĩaeka. Nare ĩatirã ikuᵽaka nare kẽrĩka: “Mija ã'mitiᵽe. ¿Dako baaerã ĩ'rãtomaja imariᵽotojo mija jĩñu?”, nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","I'suᵽaka kẽᵽakã'ã, Moiséte turitatirã ikuᵽaka ᵽajabaraka imaekakite kire ãrĩka: “¿Maki ‘Maiᵽamaki mimabe’, mire ãrãᵽaki? ");
INSERT INTO tnc_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿No'oka Egiᵽtoka'iakakire mijããraᵽaka uᵽaka yire jããerã mibaayukã'ã?”, Moiséte kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","I'suᵽaka kire kẽᵽakã'ã “Koᵽakaja Faraónte sõrĩrã baayu”, ãrĩwa'ri Egiᵽtoᵽi Madián ka'irõ'õrã Moiséte ru'riwa'rika. Torã mae rõmie'etirã ĩ'ᵽarã kimakarãrika. ");
INSERT INTO tnc_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Torãjĩrã ĩ'ᵽarã ᵽo'imajarakakuri wejejẽ'rã be'erõ'õ, ĩ'rãrĩmi Sinaí wãmeika ᵽusiwãta ᵽo'imajamatorã Moiséte imaeka. I'suᵽarõ'õrã imariᵽotojo, kiwã'tarã ĩ'rãbi yaᵽumakarãka jũ'rẽka watoᵽekaᵽi ángelte kire ᵽemakotowirika. ");
INSERT INTO tnc_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","32","Yaᵽumakarãka jũ'rẽika yoitirã, Moiséte ᵽuᵽataeka. Ᵽuᵽatariᵽotojo jia ĩatiyaokaro'si sawã'tabajirã ke'rika ᵽoto ikuᵽaka Tuᵽarãte kire ãrĩka: “Yi'i imaki Tuᵽarã. Miñekiarã Abraham, Isaac, Jacobrãka jiyiᵽuᵽaka norĩroyikaki”, kire kẽrĩka. Sã'mitiritirã kiᵽuᵽaka kĩkiwa'ri yaᵽumakarãka jũ'rẽka kiyoiberika. ");
INSERT INTO tnc_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Toᵽi mae ikuᵽaka maiᵽamaki Tuᵽarãte kire ãrĩka: “Õ'õrãja ñima simamaka ba'iaja baarũkimato sime. Suᵽa imarĩ miũ'ᵽuko'a e'etatirã yire mijiyiᵽuᵽayeebe. ");
INSERT INTO tnc_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yirirã Israelkarã, Egiᵽtorã ba'iaja najũamaka ñiayu. I'suᵽaka imawa'ri ba'iaja najaijoamaka ña'mitiyu. Suᵽa imarĩ ‘Egiᵽtokarã imarã judíorãkare ru'rirũ’, ãrĩwa'ri nare jeyobaarĩ yi'tako'o. Suᵽa imarĩ Egiᵽtorã mire yiᵽũatayu mae”, Tuᵽarãte ãrĩka Moiséte,— ãrĩwa'ri Estebanre bojaeka ĩᵽarimarãre. ");
INSERT INTO tnc_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Toᵽi ikuᵽaka kẽrĩka ate: —Aᵽika marĩka Moiséjeoka kime, mañekiarãte kire yi'riberiroyikaki. “Yija ĩᵽamaki marĩka mi'i. Suᵽa imarĩ ba'iaja yija baaika ĩarĩrĩrimajimarĩka mime”, mañekiarãte kire ãrĩka. I'suᵽaka narĩka simako'omakaja Tuᵽarãte Egiᵽtorã imaekarãre Moiséte e'ewa'rirũjeka niᵽamaki kimaokaro'si. Ika ñañua kũᵽajĩka yaᵽua jũ'rẽka watoᵽekaᵽi kiángelᵽi Tuᵽarãte bojaeka Moiséte. ");
INSERT INTO tnc_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","I'sia ᵽoto rĩkimakaja maikoribeyua baabeabaraka Egiᵽtorã Moiséte imaeka. I'suᵽaka baarika ᵽĩkowearitirã mañekiarãte ke'era'aeka mae. Toᵽi i'tarijaᵽaraka, riaᵽakiaka Oko Jũ'ayakareka, suᵽabatirãoka ᵽo'imajamatorã maikoribeyua Moiséte baabearijarika ĩ'ᵽarã ᵽo'imajarakakuri wejejẽ'rãkarõ'õjĩrã. ");
INSERT INTO tnc_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ikijioka imaekaki ikuᵽaka mañekiarãte bojaekaki: “Tuᵽarãte yire ãrĩka uᵽakaja kiro'si jaiĩjirimaji i'tarãki aᵽika. I'suᵽaka Tuᵽarãro'si baarimaji matã'omajijioka imarãki”, Moiséte nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","I'sia bojaekakijioka kimaeka mañekiarãka Sinaí wãmeika ᵽusiwãta ᵽo'imajamatorã rẽrĩroyikaki. I'suᵽaka imabaraka ĩ'rĩkaja ᵽusiᵽemarã marĩwa'ritirã ángelka jairĩ ke'rika. Torã Moiséte eyaeka ᵽoto Tuᵽarãte jã'meka ángelte kire bojaeka. Sabe'erõ'õ kire kibojaekakaka mañekiarãte bojarimaji kimaeka Moisés. Suᵽa imarĩ maimajiᵽarũkiakaka kibojaeka uᵽakaja simara'aeka maro'sioka. ");
INSERT INTO tnc_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","I'suᵽaka simako'omakaja kibojaeka uᵽaka ima mañekiarãte yi'riberiroyika. I'suᵽaka imawa'ri, Egiᵽtorã ᵽe'ririka nayaᵽaeka ate. ");
INSERT INTO tnc_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","I'suᵽaka simaeka ᵽoto ᵽusiᵽemarã Moiséte imekã'ãja, ikuᵽaka kima'mi Aarónte narĩka: “No'orã kime mirĩ'ĩ, Egiᵽtoka'iarã maimaraᵽaka ᵽoto mare e'era'araᵽaki. Torã kime morĩberijĩki kime mae. Suᵽa imarĩ, jẽrãka yija jiyiᵽuᵽayeerũkirãte mibaaᵽo'ijiabe. Mare imaruᵽutarimajaka maimajĩkareka, jia maro'si simarãñu. I'suᵽarãre imarãkareka ma'ririyaᵽairõ'õrãja mare na'rirũjerãñu”, Aarónte narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","I'suᵽaka ᵽuᵽajoawa'ri wa'ibikirãwẽko makarãka uᵽaka ĩoika jẽrãka nabaaeka. I'suᵽaka saᵽo'ijiatirã wa'iro'sia sanajoeĩjiroyika. Suᵽabatirã nabaaᵽo'ijiaeka jiyiᵽuᵽaka õrĩwa'ri nabayaarika. ");
INSERT INTO tnc_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","I'suᵽaka nabaamaka Tuᵽarãte nare ĩarĩja'ataeka, “Nayaᵽayu uᵽakaja nabaarũ”, ãrĩwa'ri. Suᵽa imawa'ri tã'ᵽia, aiyaka, ñamikaki aiyateoka jiyiᵽuᵽayeebaraka nimaeka. Ĩakõrĩ je'e: Tuᵽarãro'si bojaĩjirimaji imaroyikaki Amós ikuᵽaka ãrĩkaki: “Israelkarã, yire mija ã'mitiᵽe ruᵽu. Ĩ'ᵽarã ᵽo'imajarakakuri wejejẽ'rãka ᵽo'imajamatorã mija imataᵽaeka ᵽoto yire jiyiᵽuᵽayeeberikarã, wa'iro'sia yiro'si mija joeĩjiberika. ");
INSERT INTO tnc_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Yire jiyiᵽuᵽayeerimarĩaja mija ᵽuᵽaka mijare ãrĩka uᵽakaja mija baaeka jiyiᵽuᵽaka õñurã mija ime. Ĩakõrĩ je'e: Kũᵽajĩka wi'ia baatirã, sareka Moloc wãmeikite kõketirã mija jiyiᵽuᵽayeerijariroyika. I'suᵽakajaoka tã'ᵽi uᵽaka mija baaekaki Refán wãmeikiteoka jiyiᵽuᵽaka mija õrĩroyika. I'suᵽaka mija baamaka, Babilonia a'riwa'rirã mijare yitaarãñu”, Tuᵽarãte ãrĩka,— ãrĩwa'ri Estebanre bojaeka ĩᵽarimarãre. ");
INSERT INTO tnc_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Toᵽi ikuᵽaka nare kẽrĩka ate: —Mañekiarãte ᵽo'imajamatorã imaroyireka ᵽoto cabra ajeakaka baaeka wi'i wã'tarã imatirã Tuᵽarãte najiyiᵽuᵽayeeroyireka. I'sia imaeka “Tuᵽarãte makaja ime”, ãrĩwa'ri kire najiyiᵽuᵽayeerũkirõ'õ. Ᵽusiᵽemarã Tuᵽarãte kire sabeaeka uᵽakaja ᵽo'imajamatorã ruitirã Moiséte sabaarũjeka. ");
INSERT INTO tnc_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Toᵽi mae Moiséte reyaeka be'erõ'õ Josuére kiõ'toarã o'aeka. Kio'aeka be'erõ'õ i'sia wi'ia namakarã mirãrãte e'ewa'rika Canaán wãmeirõ'õrã. Na'rikarõ'õ namajamarã ka'ia simako'omakaja, naka jĩrĩkarãte Tuᵽarãte ᵽoataeka. Cabra ajeaᵽi wi'ia nabaaroyika imaeka ruᵽu Davidre judíotatarãte jã'meyukã'ãja. ");
INSERT INTO tnc_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Jia jĩjimaka Tuᵽarãte imaeka mañekiarã ĩᵽamaki David imaroyikakika. Suᵽa imarĩ Tuᵽarãka jĩjimaka imawa'ri kitã'omajaᵽitiyika Tuᵽarãte jiyiᵽuᵽaka kiõñaokaro'si wi'ia kiro'si baarika kiᵽuᵽajoakoᵽeka. I'suᵽaka simako'omakaja Tuᵽarãte kire sabaarũjeberika. ");
INSERT INTO tnc_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","David maki Salomón ᵽuri Tuᵽarãro'si wi'ia baaekaki mae. ");
INSERT INTO tnc_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","I'suᵽaka simako'omakaja ᵽo'imajare baaeka wi'iarã imabeyuka kime Tuᵽarã, ᵽemawa'ribaji imatiyaiki imarĩ. Mia je'e ikuᵽaka bikija kiro'si bojaĩjirimajire o'oeka: ");
INSERT INTO tnc_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","50","“Ritajakaka ĩᵽamaki ñime. Suᵽabatirã yi'iji imaki ritaja ᵽo'ijiaekaki. Suᵽa imarĩ yiro'si wi'ia mija baarãka, ¿yikoyiaja simarãñu bai je'e?”, Tuᵽarãte ãrĩka,— ãrĩwa'ri Estebanre bojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","I'suᵽaka nare ãrĩweatirã, ikuᵽaka nare kẽrĩka ate: —Mija ã'mitiᵽe, Tuᵽarãte yi'ririyaᵽabeyurã mija ime. Suᵽabatirãoka kirika ã'mitiririyaᵽabeyurã mija ime. I'suᵽaka imawa'ri mañekiarã wãsarã uᵽakaja Esᵽíritu Santore yi'ribeyurã mija ime mijaro'sioka. ");
INSERT INTO tnc_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ritaja Tuᵽarãro'si bojaĩjirimajare ba'iaja jũarũjerimaja mija ñekiarãte imaeka. Suᵽabatirãoka Tuᵽarãte yaᵽaika uᵽakaja yi'ririjayuki etarũkia bojarimajare najããeka mija ñekiarã. Suᵽa imarĩ maekakaja ketaeka ᵽotojo “Kire najããrũ”, ãrĩwa'ri kire mija okabaaeka. ");
INSERT INTO tnc_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Tuᵽarãte jã'meika mija yi'ribeyu, ángelrãkaᵽi ãrĩwa'ri mija ñekiarãre Tuᵽarãte sabojaeka simako'omakaja,— Estebanre ãrĩka ĩᵽarimarãre. ");
INSERT INTO tnc_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","I'suᵽaka kẽᵽakã'ã yaiwẽkoa boibayua uᵽaka noᵽia Estebanre nabeaeka, boebatakaja jariwa'ri. ");
INSERT INTO tnc_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","I'suᵽaka nabaako'omakaja, Esᵽíritu Santore jia kire jeyobaaikaki imarĩ, yu'awa'ri ĩaerã baakõrĩ, yaaboaika Tuᵽarãrika kĩaeka. Suᵽabatirã Tuᵽarã ritaᵽẽ'rõtorã Jesúre rĩkamarika. ");
INSERT INTO tnc_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","I'sia ĩatirã, ikuᵽaka ĩᵽarimarãre kẽrĩka: —¡Aya! Mabo'ikakurirã ñiayu mae. Tuᵽarã ritaᵽẽ'rõtoᵽi Ᵽo'imaja Ma'mire rĩkamayu,— Estebanre ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Torãjĩrãja ᵽuri koᵽakaja kijaika ã'mitiririka yaᵽaberiwa'ri, na'mukoᵽea natãteka. I'suᵽaka baatirã okajãjirokaᵽi akaserebaraka kiᵽõ'irã narĩrĩwa'rika. ");
INSERT INTO tnc_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Suᵽabatirã weje a'riwa'rirã kire ne'ewa'rika, ãtaᵽi kire jããriataokaro'si. Torã kire e'eeyatirã najariroaka ᵽemakato e'etatirã, Saulote sanijika sakĩarĩñaokaro'si. Sakĩarĩñukã'ãja ãtaᵽi Estebanre najããbareũ'mueka. ");
INSERT INTO tnc_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","I'suᵽaka kire nabaayukã'ãja, ikuᵽaka Jesúre kẽrĩka: —Ñiᵽamaki Jesús, yire me'etoᵽe,— kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","I'suᵽaka ãrĩweatirã ñukuruᵽatirã, akasererikaᵽi, —¡Ñiᵽamaki, ba'iaja yire nabaaika nareka samiye'kariabe!— Jesúre kẽrĩka. I'suᵽaka kijaika be'erõ'õjĩte koᵽakaja kiᵽuᵽaririka mae. ");
INSERT INTO tnc_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","3","Toᵽi mae, jia Tuᵽarãte yi'yurã imaekarã judíotatarã Estebanre nayayeka. I'suᵽaka kire baatirã ñajoabaraka jimarĩa kire norika. I'sirĩmijioka tokarã Jesúre yi'yurãka jiamarĩa imarijayurãte ba'iaja nare baaũ'mueka. Ĩakõrĩ je'e: Saulo, “Estebanre najããᵽarũ”, ãrĩᵽuᵽajoaekaki, i'suᵽakaja ba'iaja nare ᵽuᵽajoarũjerã baaekaki. Ĩ'rãwi'i jariwa'ririmarĩaja mo'abaraka Jesúre yi'yurãte tõᵽotirã ĩmirĩja, rõmijãteoka wẽkomaka imariwi'iarã nare kitaroyika. I'suᵽaka simamaka Judea ka'iarã, suᵽabatirã Samaria ka'iarã Jesúre yi'yurãte ru'riwa'rika. I'suᵽaka aᵽerãte baaeka imako'omakaja aᵽóstolrãka ᵽuri Jerusalénrãja tuikarã. ");
INSERT INTO tnc_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jerusalénrõ'õᵽi ru'riwa'rikarã imariᵽotojo aᵽerõ'õrã eyatirã Jesúrika bojariroka nawãrõeka. ");
INSERT INTO tnc_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Feliᵽe Jerusalénᵽi ru'riwa'ritirã, Samariaka'iarã imawejearã eyaekaki. Torã eyatirã, “Ᵽo'imajare tããokaro'si suᵽabatirã nare jã'merimaji kimaokaro'si Tuᵽarãte kire ᵽũataeka”, ãrĩwa'ri Jesúrikakaka Feliᵽere nare bojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Torãjĩrã mae, rĩkimarãja ᵽo'imajare kiᵽõ'irã rẽrĩka kire ã'mitiririyaᵽawa'ri. Suᵽabatirã, maikoribeyua kibaabeamakaoka ĩawa'ri kibojaeka jiaᵽi na'mitirika. ");
INSERT INTO tnc_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","I'suᵽaka maikoribeyua baabeabaraka rĩkimarã ᵽo'imaja ᵽuᵽakarã Satanárika ima ña'rĩjãikarãreka Feliᵽete ᵽoataeka. I'suᵽaka kibaamaka nareka imaekarã akaserebaraka ᵽorika. Suᵽabatirãoka rĩkimarãja bitamajareoka kijieka. ");
INSERT INTO tnc_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Suᵽa imarĩ i'sia wejeakarãre jĩjimaarika. ");
INSERT INTO tnc_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","11","I'sia wejearã Simónre imaeka. Ĩ'rãkuri wejejẽ'rãmarĩa ye'oiki imarĩ, kiᵽuᵽakaᵽi baabeabaraka kimaroyika. I'suᵽaka baarijaᵽaraka “Yi'i imaki imatiyaiki”, tokarãre kẽrĩroyika. I'suᵽaka nare kibaamaka rĩkimarãja imatiyairã, imatiyabeyurã ᵽariji kire nayi'rika. “Tuᵽarãte kire jeyobaamaka tẽrĩtaki kime”, ãrĩwa'ri jiyiᵽuᵽaka noñuka kimaeka. ");
INSERT INTO tnc_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","I'suᵽaka nimako'omakaja Feliᵽe ᵽuri Jesucristorika bojariroka nare wãrõekaki. “Tuᵽarãte ᵽũataekaki kime Jesús. Suᵽabatirãoka kire yi'yurã ᵽuri jia Tuᵽarãte nare imaruᵽutarãñu”, ãrĩwa'ri nare kibojaeka. I'sia ã'mitiritirã Jesúre ĩmirĩja, rõmijãoka kire nayi'rika. I'suᵽaka imawa'ri Feliᵽete naruᵽuko'a najũjerũjeka “Koᵽakaja Jesúre yi'yurã yija ime mae”, ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simónoka, ye'oiki imariᵽotojo, Jesúrika bojariroka yi'ritirã ruᵽuko'a kijũjerũjeka. Torãjĩteᵽi mae Feliᵽeka kijeyoariũ'mueka. Kika imarijaᵽaraka Tuᵽarãrikaᵽi maikoribeyua Feliᵽete baabeamaka ĩatirã marãkã'ã baaberijĩkarõ'õjĩrã Simónre jarika i'suᵽaka ima ĩakoriberikaki imarĩ. ");
INSERT INTO tnc_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Aᵽóstolrãka Jerusalénᵽi, “Samariaka'iakarã rĩkimarãja Tuᵽarãrika na'mitiriᵽẽayu”, ãrĩrika na'mitirika. I'suᵽaka simamaka Samariarã Ᵽedro suᵽabatirã Juanka ĩ'ᵽarãte naᵽũataeka. ");
INSERT INTO tnc_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Samariaka'iarã eyatirã torã Jesúre ã'mitiriᵽẽairã ruᵽuko'a jũjekarã imariᵽotojo “Tuᵽarãte ᵽũataekaki Esᵽíritu Santore nareka imabeyurã nime ruᵽu”, narĩwãrũeka. I'suᵽaka nimamaka “Esᵽíritu Santore nare ña'rĩjãirũ”, ãrĩwa'ri Tuᵽarãte naro'si najẽñeka. ");
INSERT INTO tnc_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Suᵽabatirã Jesúre ã'mitiriᵽẽairãte ĩ'rĩkate jariwa'ririmarĩaja naruᵽuko'a narabemaka Esᵽíritu Santore nare ña'rĩjãika. ");
INSERT INTO tnc_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Ᵽedrorãka nare narabemaka Esᵽíritu Santore nare ña'rĩjãimaka Simónre ĩaeka. I'sia ĩatirã niñerũ nare ĩjirika yaᵽawa'ri ikuᵽaka nare kẽrĩka: —Mija baaeka uᵽaka yibaamaka Esᵽíritu Santore nare ña'rĩjãirika yiyaᵽayu yiro'sioka. Suᵽa imarĩ ika sime i'suᵽaka yire mija baarũjerũki waᵽa,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","I'suᵽaka kẽᵽakã'ã, ikuᵽaka Ᵽedrote kire ãrĩka: —Waᵽamarĩaja Tuᵽarãte ja'ataika, mawaᵽaĩjirũkimarĩa sime. I'suᵽaka miᵽuᵽajoaika simamaka, miniñerũᵽitiyika ba'iaja imarika tiyibeyurõ'õrã me'rirũ ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ba'iaja miᵽuᵽajoaika õñuka Tuᵽarã. Suᵽa imarĩ, yijaka aᵽerãte Esᵽíritu Santore ña'ajããrimajimarĩka mime. ");
INSERT INTO tnc_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Koᵽakaja mae ba'iaja miᵽuᵽaka mireka ñiawãrũyu. Mia, Tuᵽarãte tẽrĩrika imakakaᵽi yija baarijayua mioakiyu. Suᵽabatirã ba'itakaja baarimaji imarĩ, marãkã'ã baatirã aᵽe uᵽaka imarimajimarĩka mime. Ba'itakaja miᵽuᵽajoaika ja'atatirã Tuᵽarãte mijẽñebe, “Ba'iaja yiᵽuᵽajoaika yireka miye'kariabe”, ãrĩwa'ri,— Ᵽedrote kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","I'suᵽaka kẽᵽakã'ã ikuᵽaka Simónre kire ãrĩka: —Maiᵽamaki Tuᵽarãka yiro'si mija jaibe. “I'suᵽaka mijũarãñu”, yire meñua jũarika yaᵽabeyuka yi'i ᵽuri,— Ᵽedrorãkare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","I'sia be'erõ'õ Jesúre baaroyika niaeka mirãka, suᵽabatirã nare kibojaroyikakaka tokarãre nabojaeka. Ᵽo'imajare wãrõweatirã, Jerusalénrã ᵽe'riwa'rikõrĩ Samariaka'iarã wejerakakaja Jesúrika nawãrõrijarika. ");
INSERT INTO tnc_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","I'sia be'erõ'õ Tuᵽarã Feliᵽe ᵽõ'irã ángelte ᵽũataekaki ikuᵽaka kire kẽñaokaro'si: —Jerusalénrã me'ᵽe. Torã meyarãka ᵽoto, Gaza wãmeika wejearã a'yu ma'arã me'ᵽe. Yaᵽumatoᵽi o'yuma'a sime i'sima'a,— Feliᵽete kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Suᵽa imarĩ kire kẽrĩka uᵽakaja Feliᵽete a'rika mae. Toᵽi a'ririjaᵽaraka Etioᵽíaka'iakakire kĩaeka. Etioᵽíaka'iakarã ĩᵽamakore niñerũ ĩarĩrĩrijeyobaarimaji imatiyaiki kimaeka. Jerusalénrã Tuᵽarãte jiyiᵽuᵽayeerĩ turikaki, torãjĩte kiᵽe'rieyawa'rika. ");
INSERT INTO tnc_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Kawarure kitũrũrũkiaᵽi kire yierijayukã'ãja Tuᵽarãro'si bojarimaji Isaías wãsare o'oekakaka kĩarijarika. ");
INSERT INTO tnc_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Torãjĩrã mae, ikuᵽaka Esᵽíritu Santore ãrĩka Feliᵽete: —Kire eyatirã, kiwãtaᵽiji me'ririjaᵽe,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Suᵽa imarĩ kire rĩrĩeyatirã, Tuᵽarãte bojaĩjirimaji Isaíare o'oekakaka ĩabaraka kijaiᵽatemaka, kiã'mitirika. Toᵽi mae, —Torã mijaiᵽateika ¿yaje miõrĩwãrũyu?— Feliᵽete kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","I'suᵽaka kẽᵽakã'ã, —“I'suᵽaka sãñu”, ãrĩwãrũbeyuka yi'i, maki yire sabojabeyua simamaka,— kire kẽrĩka mae. Toᵽi mae, —Yiᵽõ'irã mimarĩjãibe yire samiwãrõkaro'si,— Etioᵽíakakire kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Isaías Tuᵽarãrika o'oeka kijaiᵽatekarõ'õ ikuᵽaka bojaeka: “Oveja jããokaro'si ne'ewa'yu uᵽakaja ĩ'rĩkate ne'ewa'rirãñu. Kiᵽoya nata'amaka oveja akaserebeyua sima uᵽakaja ba'iaja kire nabaako'omakaja kiakaserebesarãñu. ");
INSERT INTO tnc_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Rĩkimarãja ᵽo'imajare ĩarãka wãjitãji ba'iaja kire nabaarãñu. ‘Ba'iaja baaiki kime’, kireka naᵽakã'ã ki'yoᵽi'rirãñu ba'iaja baabesarãki imarĩ. Suᵽabatirã ᵽo'imajare kire jããmaka, kiriᵽarãmerã imabesarãñurã”, ãrĩwa'ri o'oekarõ'õ Etioᵽíakakire jaiᵽateka. ");
INSERT INTO tnc_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Suᵽa imarĩ kiᵽõ'irã Feliᵽete marĩjãika. —Tuᵽarãro'si bojaĩjirimajite o'oekakaka ĩatirã yire mibojabe. ¿Yaje kirikakakaja kio'oeka bai? ¿Aᵽikareka ᵽuᵽajoawa'ri i'suᵽaka kio'oeka kã'ã?— Feliᵽete kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Toᵽi mae, Isaíare o'oekakaka ã'mitiritirã, ikuᵽaka Feliᵽete kire ãrĩka: —Isaías i'suᵽaka o'oekaki Jesúre ba'iaja jũarũkiakaka ᵽuᵽajoawa'ri.— Suᵽabatirã jía Jesúmajaroka kire kibojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","A'ririjari ma'arijerã ᵽa'wa imaekarõ'õrã neyaeka. —Ĩakõrĩ, õ'õrã sime okoa. Maekaka ruᵽuko'a yire mijũjebe ñarĩjĩka ¿yaje rukuya jia simajĩñu?— Etioᵽíakakire kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","I'suᵽaka kẽᵽakã'ã, ikuᵽaka kire kẽrĩka: —Yi'ritiyarĩji Jesucristore miyi'rijĩka, ruᵽuko'a mire yijũjerãñu.— I'suᵽaka kẽᵽakã'ã, —Ã'ã, Tuᵽarã Makiji kime Jesucristo,— Etioᵽíakakire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Suᵽa imarĩ “Õ'õrã mituibe”, tũrũrũkia tuarimajite ãrĩtirã, saᵽi merĩrĩkatirã ᵽa'warã natu'arĩkaeka Feliᵽete Etioᵽíakaki ruᵽuko'a jũjeokaro'si. ");
INSERT INTO tnc_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ᵽa'waᵽi namarĩrĩkaeka ᵽoto, ikuᵽarõ'õᵽiji Feliᵽete Esᵽíritu Santore e'ewa'rika. Sabe'erõ'õ ᵽuri Etioᵽíakakire kire ĩaberika ate. I'suᵽaka simako'omakaja jĩjimakaᵽi Etioᵽíakakire o'rika. ");
INSERT INTO tnc_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Aᵽewejearã Esᵽíritu Santore kire e'ewa'rika be'erõ'õ, “Azotowejearã ñimekã'ã mae”, Feliᵽete ãrĩᵽuᵽajoaeka. Toᵽi o'riwa'rikõrĩ wejerakakaja Jesúrika wãrõrijaᵽaraka Cesareawejearã keyaeka. ");
INSERT INTO tnc_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo Jesúre yi'yurãte jããrika ri'kawa'ri ba'iaja nareka kijairoyika ruᵽu. Suᵽa imarĩ “Ba'iaja nare yibaaerã”, ãrĩwa'ri kurarãka ĩᵽamaki imatiyaiki ᵽõ'irã ke'rika. ");
INSERT INTO tnc_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","“Ĩ'ĩ Saulo, yiᵽũataiki Jesúre ã'mitiriᵽẽairãte kiñi'arũ”, ãrĩwa'ri ᵽaᵽera kio'ookaro'si kijẽñeka, Damascorã judíorãkare rẽrĩriwi'ia imaruᵽutarimajare beaokaro'si. —Ika mijã'meikaᵽi nare ñiatõᵽorãka uᵽakaja ĩmirĩja, rõmijãteoka ñi'atirã Jerusalénrã nare ye'era'arãñu,— Saulote kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Suᵽa imarĩ ma'aᵽi a'ririjari Damasco wejearã keyaerã baaekarõ'õjĩte, ikuᵽarõ'õᵽiji mabo'ikakuriᵽi yaaboaika kire jããta'aeka. ");
INSERT INTO tnc_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Toᵽi mae marãkã'ã baaberiwa'ri sarãja Saulote ña'rĩka. Torãjĩte mae, ikuᵽaka kire sãrĩka: —Saulo, Saulo, ¿dako baaerã ba'iaja yire mibaariwã'imañu?— kire sãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sã'mitiritirã, —¿Maki mime je'e Ñiᵽamaki?— kẽrĩka. —Ba'iaja mibaawã'imarĩrijayuka Jesús ñime,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","I'suᵽaka kire ãrĩtirã, —I'suᵽaka baarikoᵽakaja, mi'mitirã, Damascorã me'ᵽe. Torã meyarãka ᵽoto, “Ikuᵽaka mibaabe”, ĩ'rĩkate mire ãrĩrãñu,— Saulote kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sauloka a'rikarã, sajaikakite ã'mitiririᵽotojo kire niatõᵽoberika. Ᵽuᵽataekarã imarĩ torã najiyirĩkataeka suᵽabatirã jaiberijĩkaoka najarika. ");
INSERT INTO tnc_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sabe'erõ'õ mi'mirĩkatirã yoibaotaerã kibaakoᵽeka. Torãjĩrã mae õibeyua kiñakoa jarika simamaka Damascorã kijeyomarãre kire tĩtiwa'rika. ");
INSERT INTO tnc_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Torã kire ne'eeyaeka be'erõ'õ maekarakarĩmi yoibeyuka, ba'abekaja, suᵽabatirã dakooka ukurimarĩaja Saulote imaeka. ");
INSERT INTO tnc_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","I'sia wejearã Jesúre yi'yuka, ĩ'rĩka Ananías wãmeikite imaeka. Makãrãrũñuroka uᵽakaᵽi kire ᵽemakotowiritirã, —¿Yaje mime Ananías?— Jesúre kire ãrĩka. —Ã'ã Ñiᵽamaki, õ'õrã ñime,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","—Ã'ã, mae Wãjima'a wãmeirõ'õᵽi me'ᵽe. I'sima'aᵽi a'ririjari Judas wi'iarã meyarãñu. Torã eyatirã “¿Yaje õ'õrã Saulo, Tarsowejeakakire ime?”, kire meᵽe. Mia, i'suᵽaka merĩrãñu yire jẽñebaraka imaki kimamaka. ");
INSERT INTO tnc_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Makãrãrũñuroka uᵽakaᵽi ikuᵽaka kiro'si simako'o: Ĩ'rĩka Ananías wãmeikite kire yibeako'o. Suᵽa imarĩ kiᵽõ'irã kãkaeyatirã miᵽitaka kiᵽemarã mija'aᵽearãka ᵽoto, ate yoiki kijarirãka, kire yibeako'o,— Ananíare kẽrĩka ");
INSERT INTO tnc_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","I'suᵽaka kire kẽᵽakã'ã ikuᵽaka Ananíare ãrĩka: —Jimarĩa kimajaroka ña'mitiyu, Jerusalénkarã mire yi'yurãte ba'iaja kibaarijayuakaka. ");
INSERT INTO tnc_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Suᵽabatirã kurarãka ĩᵽamarãre kire jã'meᵽũatamaka, õ'õrã Saulote etaeka. Suᵽa imarĩ mire ã'mitiriᵽẽairã yija imamaka, wẽkomaka yijare baaokaro'si Jerusalénrã yijare e'ewa'ririmaji kime,— Ananíare kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","I'suᵽaka kẽrĩko'omakaja ikuᵽaka Jesúre kire bojaeka: —Mire ñañu uᵽakaja kiᵽõ'irã me'ᵽe. Yimajaroka ᵽo'imajare wãrõrimaji kimaerã kire yiwã'maeka. Judíotatarã, judíotatamarĩrã, suᵽabatirã niᵽarimarãteoka sawãrõrimaji kimarãñu. ");
INSERT INTO tnc_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","I'suᵽaka baarimaji kimamaka “Saᵽi ĩ'rãkurimarĩaja jimarĩa ba'iaja mijũarãñu”, kire ñarĩrãñu,— kireka Jesúre ãrĩka Ananíare. ");
INSERT INTO tnc_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Torãjĩrã kiᵽõ'irã Ananíare a'rika mae. Kimaeka wi'irã kiᵽõ'irã eyatirã kiᵽitaka Saulo ᵽemarã kija'aᵽeaeka. Suᵽabatirã ikuᵽaka kire kẽrĩka: —Yijeyomaki mia'mitiᵽe. Maiᵽamaki Jesús, mi'tarijaraᵽaka ᵽoto mire ᵽemakotowiraᵽakiji, yire ᵽũatako'oka miñakoa jiirũ ãrĩwa'ri. Suᵽabatirãoka Esᵽíritu Santore mire ña'rĩjãirũ ãrĩwa'ri ᵽariji yire kiᵽũatayu,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","I'suᵽaka kẽrĩkarõ'õjĩteje, wa'itĩti uᵽaka ĩoika Saulo ñakoaᵽi ña'rĩka. Torãjĩrã ᵽuri jia kiñakoa jarika. I'suᵽaka kire kibaamaka, kimi'mirĩkaeka ᵽoto Ananíare kire ruᵽuko'a jũjeka. ");
INSERT INTO tnc_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","I'suᵽaka kijarika be'erõ'õ ba'atirã okajãjia kijarika. I'suᵽaka jaritirã ñoaᵽañaka Jesúre yi'yurãka Damascorã kimaeka. ");
INSERT INTO tnc_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Torãjĩrã mae judíorãkare rẽrĩriwi'iarã kãkatirã, Jesúrika bojariroka wãrõbaraka “Tuᵽarã Maki kime Jesús”, Saulote nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","I'suᵽaka kibaamaka, koᵽakaja ᵽo'imajare ᵽuᵽataeka. —Mia, ĩ'ĩji kime Jesúre yi'yurãte ba'iaja baarimaji Jerusalénrã. Õ'õrã kime Jesúre yi'yurãte ñi'atirã, kurarãka ĩᵽamarã ᵽõ'irã nare e'ewa'yaokaro'si,— ᵽo'imajare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","I'suᵽaka naᵽuᵽajoako'omakaja Tuᵽarãte kire jeyobaamaka, jiibaji Jesúrika bojariroka kibojamirĩrĩkawa'rika. “Rita sime, Jã'merũkika Tuᵽarãte wã'maekaki kime Jesús”, nare kẽrĩroyika. Jia sakibojamaka, Damascokarã judíorãka ĩᵽarimarã marãkã'ã kire nokatẽrĩwãrũberika. ");
INSERT INTO tnc_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Damascorã ñoatakaja sawãrõbaraka Saulote imamaka, “Kire majããerã”, judíorãka Jesúre yi'ribeyurãte ãrĩᵽuᵽajoaeka. ");
INSERT INTO tnc_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Suᵽa imarĩ ñami, ĩmioka kire naᵽãñaroyika wejeaᵽi ᵽoriwa'rirũkirõ'õ koᵽerekarã kire jããokaro'si. I'suᵽaka nabaako'omakaja Saulote sõrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kiõrĩka simamaka kibojaeka yi'yurãte kire jeyobaaeka, kiru'yaokaro'si. Torãjĩrã mae, ñami wejea nata'tekarõ'õᵽi imatirã ᵽi'i uᵽaka ĩoikarã kire jããtirã aᵽeᵽẽ'rõtorã kire naruetaeka kiru'yaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Toᵽi, ru'riwa'ritirã Jerusalénrã keyaeka mae. Torã Jesúre yi'yurãka jeyoaririka kiyaᵽakoᵽeka. I'suᵽaka kiyaᵽako'omakaja “Jesúre yi'ribeyuka kime Saulo ᵽuri”, ãrĩwa'ri kire nakĩkika. ");
INSERT INTO tnc_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","I'suᵽaka nimako'omakaja, Bernabé wãmeiki, Saulote jeyobaaekaki. “Mi'tabe, aᵽóstolrãkaka majairã”, kire kẽrĩka. Sauloka naᵽõ'irã eyatirã ikuᵽaka Bernabére nare ãrĩka: —Saulo kime ĩ'ĩ, ma'aᵽi ke'ririjayukã'ã maiᵽamaki Jesúre kire ᵽemakotowirika. Suᵽabatirã kika kijaika. I'suᵽaka Jesúre kire baaeka be'erõ'õ Damascorã dako werikimarĩaja ᵽo'imajare Jesúrika bojariroka wãrõraᵽaki kime,— Bernabére nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","I'suᵽaka nare kẽᵽakã'ã “Maka imarũkika Saulote ime mae”, kireka narĩka. I'suᵽaka naᵽakã'ã, Jerusalénrã naka kimaeka. Naka imarijari dako werikimarĩaja tokarãre Jesúrika kibojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Judíotatarã imariᵽotojo griego oka jairãka Saulote jaibaraka imaeka. Tuᵽarã majaroᵽũñu ãñua nare bojabaraka, “Sãñu uᵽakaja Jã'merũkika Tuᵽarãte wã'maekaki kime Jesús”, nare kẽrĩka. I'suᵽaka kẽᵽakã'ã ã'mitiriwa'ri kire jããrika nari'kaeka. ");
INSERT INTO tnc_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","I'suᵽaka kika nima ã'mitiriwa'ri, Cesarearã kijeyomarãre kire e'ewa'rika. Torã eyatirã Tarsowejearã kire naᵽe'riwa'rirũjeka. ");
INSERT INTO tnc_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","I'sia ᵽoto ᵽuri Judea, Samaria, suᵽabatirã Galilea ka'iarãoka ba'iaja Jesúre yi'yurãte jũaberika. Suᵽa simamaka Esᵽíritu Santore nare jeyobaamaka jĩjimakaᵽi Jesúre jiibaji yi'yurã nimamirĩrĩkawa'rika. Suᵽa imarĩ rĩkimabaji Jesúre yi'yurãte imarijarika. Suᵽabatirãoka ritaja jiyiᵽuᵽaka Maiᵽamakire õᵽaraka nimarijarika. ");
INSERT INTO tnc_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Suᵽa imarĩ Jesúre yi'yurãte ĩ'rãweje jariwa'ririmarĩaja Ᵽedrote ĩataᵽaroyika. I'suᵽaka imawa'ri Lida wãmeirõ'õrã naᵽõ'irã turirĩ keyaeka. ");
INSERT INTO tnc_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Torã eyatirã Eneas wãmeikite kĩaeka. Bitamaji imarĩ, maekarakaotẽñarirakakuri wejejẽ'rãka keyawa'rika kikãrĩrũkirõ'õrãja ᵽeyubaraka. ");
INSERT INTO tnc_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Torãjĩrã mae, ikuᵽaka Ᵽedrote kire ãrĩka: —Eneas, mia'mitiᵽe, Jesucristore mire jieyu mae. Suᵽa imarĩ mimi'mirĩkabe. Suᵽabatirã mikãrĩrũkia mibuᵽebe,— kire kẽrĩka. I'suᵽaka kire kẽrĩkarõ'õjĩteje, bitamaji imakoᵽekakite mi'mirĩkaeka. ");
INSERT INTO tnc_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Rĩkimarãja Lidakarã suᵽabatirã Sarónka'iakarãoka ĩaekarã suᵽa kibaaeka. Suᵽa imarĩ nimauᵽatiji Jesúre yi'yurã oyiaja najarika. ");
INSERT INTO tnc_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ĩ'rãko Joᵽe wãmeirõ'õkako Tabitá wãmeikote imaeka, Jesúre yi'yuko. Griego okaᵽi ᵽuri Dorcas wãmeiko koimaeka. Jiiko ᵽo'irõmo imarĩ wayuoka baairãte jia kojeyobaaroyika. ");
INSERT INTO tnc_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","I'suᵽaka imariᵽotojo ikuᵽarõ'õᵽiji wãmarĩa jariwa'ri koreyaeka mae. Koreyamaka ĩatirã reyairãte nabaaika uᵽakaja koᵽo'ia najũjeka korĩrã. Suᵽabatirã ĩmiᵽẽ'rõtorã imaeka kurarakarã koro'siji kore nataeka. ");
INSERT INTO tnc_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","I'suᵽaka kore baatirã “Lidarã Ᵽedrote ime”, ᵽo'imajare ãñua Joᵽekarã Jesúre yi'yurãte ã'mitirika. Sã'mitiritirã ĩ'ᵽarãte Ᵽedrote akarĩ naᵽũataeka, koyikurirãja kimaeka simamaka. Kiᵽõ'irã eyatirã ikuᵽaka kire narĩka: —Dajoa wãrũaja yijaka.— ");
INSERT INTO tnc_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","I'suᵽaka naᵽakã'ã ã'mitiriwa'ri, naka Ᵽedrote a'rika Joᵽerã. Torã eyatirã Dorcas majaka nataekarõ'õrã kire ne'ewa'rika. Suᵽa imarĩ koᵽõ'irã rĩkimarãja natĩmiarãte reyataᵽaekarãre oᵽaraka imamaka kĩaeka. Ketamaka kiᵽõ'irã narẽrĩka kika jaiokaro'si. —Dorcate reyaerã baaraᵽaka ruᵽu rĩkimakaja saya yijare koᵽu'aĩjiraᵽe,— ãᵽaraka Ᵽedrote sanabeaeka. ");
INSERT INTO tnc_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","I'suᵽaka kire naᵽakã'ã, —Mija ᵽoriwa'ᵽe ruᵽu,— nare kẽrĩka. Naᵽoriwa'rika be'erõ'õ, ñukuruᵽatirã Tuᵽarãka kijaika. Kika jaiweatirã, reyaekakote jorowa'ri ĩatirã, —Tabitá mimi'mibe,— kore kẽrĩka. I'suᵽaka kẽrĩka ᵽotojo koñakoa wiritaeka. Suᵽa imarĩ Ᵽedrote ĩatirã komi'miruᵽaeka. ");
INSERT INTO tnc_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Toᵽi mae, koᵽitakaᵽi ñi'atirã Ᵽedrote kore mi'mataeka. Suᵽabatirã “Mija ᵽoᵽe ruᵽu”, kẽrĩkarãte kiakaeka. —Koᵽakaja õñia kojayu. Ate kore mija ĩaraᵽe mae,— Jesúre yi'yurã natĩmiarã reyataᵽaekarã, suᵽabatirã aᵽerã najeyomarãreoka kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","I'suᵽaka kojarika ritaja Joᵽekarãre ã'mitiriᵽataeka. Sã'mitiritirã rĩkimarãja Jesúre nayi'rika. ");
INSERT INTO tnc_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Sabe'erõ'õ torã ñoaka Ᵽedrote imaeka, wa'iro'si ajea ba'iraberimaji Simón ᵽõ'irã. ");
INSERT INTO tnc_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Cesareawejearã Cornelio wãmeikite imaeka. Torã rĩkimarãja surararãka Italiakarãkaki imatirã ĩ'rãᵽitarakamarã ᵽo'imajarakamaki surararãka ĩᵽamaki kimaeka. ");
INSERT INTO tnc_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Judíorãkimarĩka imariᵽotojo Tuᵽarãte jiyiᵽuᵽaka õñuka, kiwi'iareka imarãᵽitiyika. Judíorãka wayuoka baairãte rĩkimakaja niñerũ jeyobaarimaji, suᵽabatirãoka Tuᵽarãte jaijiᵽaki kimaeka. ");
INSERT INTO tnc_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","I'suᵽaka kimamaka ĩ'rãrĩmi tres rõ'õjĩrã aiyate eyawa'rika ᵽoto makãrãrũñuroka uᵽakaᵽi Tuᵽarãte ᵽũataekaki ángelte kiᵽõ'irã etaeka. Jia Corneliore kire ĩatiyaeka. Suᵽabatirã kiᵽõ'irã kãkaeyatirã, —Cornelio,— ángelte kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Toᵽi mae, kireka ñakoariji, —Aya, ¿marãkã'ã sime je'e ñiᵽamaki?— ᵽuᵽatawa'ri kire kẽrĩka. I'suᵽaka kẽᵽakã'ã —Tuᵽarãte mijeñerijayu rakakaja mire kiã'mitiyu. Suᵽabatirã wayuoka baairãte mijeyobaaikarekaoka jĩjimaka kime. I'suᵽaka mimamaka mireka ᵽuᵽajoajiᵽaiki kime. ");
INSERT INTO tnc_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Suᵽa imarĩ Joᵽewejearã imaki Simónre akarĩ a'rirũkirãte miᵽũatabe. Kiwãmeaoka Ᵽedro. ");
INSERT INTO tnc_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Aᵽika Simón wa'iro'si ajea ba'iraberimaji riaᵽakirijerã imaki ᵽõ'irã kime. Torã Simón Ᵽedrote natõᵽorãñu miᵽũatarãñurã,— ángelte kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","I'suᵽaka kire ãrĩweatirã ángelte a'rika. Sabe'erõ'õ ĩ'ᵽarã kiba'iraberimaja, suᵽabatirã ĩ'rĩka surara jia Tuᵽarãte yi'yuka imaekakiteoka kiakaeka. ");
INSERT INTO tnc_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Suᵽa imarĩ kiᵽõ'irã netaeka ᵽoto, ángelte kire ãrĩkakaka Corneliore nare bojaeka. Nare sabojaweatirã Joᵽerã nare ke'rirũjeka. ");
INSERT INTO tnc_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","I'suᵽaka kẽᵽakã'ã a'ritirã, aᵽerĩmi wãjitãji aiya simaeka ᵽoto Joᵽe koyikurirã neyaeka. I'tojĩte wi'i ruᵽututuarã Ᵽedrote mirĩka Tuᵽarãka jairĩ. ");
INSERT INTO tnc_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Tuᵽarãka jaibaraka kimaeka ᵽoto koᵽakaja kikẽsirabaeka. I'suᵽaka kimamaka aᵽerãte ba'arika kiro'si baayukã'ãja ikuᵽaka makãrãrũñuroka uᵽakaᵽi kiro'si simaeka: ");
INSERT INTO tnc_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Mabo'ikakurirã kĩaeka ᵽoto sayaᵽãia jo'bato ĩ'ᵽaᵽẽ'rõto ñi'atirã maja'aruetaika uᵽaka saruira'aeka. ");
INSERT INTO tnc_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Satõsiarã ritajakaka wa'iro'sia, wa'iro'siwẽkoa ᵽariji imaeka. Wa'ibikirãka uᵽaka tuyua, wiyua, suᵽabatirã yiibaraka tuyuaoka simaeka. ");
INSERT INTO tnc_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Suᵽa imarĩ ĩmiᵽi ikuᵽaka Ᵽedrote sajaikorika: —Ᵽedro mimi'mibe. Samijããba'abe,— kire sãrĩkorika. ");
INSERT INTO tnc_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","I'sia oka ã'mitiritirã ikuᵽaka kiyi'rika: —Marãkã'ã baatirã yibaaberijĩka Ñiᵽamaki, Moisés wãsare jãjibaaeka ba'akoribeyuka ñime ruᵽu.— ");
INSERT INTO tnc_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Toᵽi ate sajaikorika —“Jãjika yiro'si sime”, merĩa'si, Tuᵽarãte ba'arũjeika ᵽuri “Miba'abe”,— mabo'ikakuriᵽi sãrĩkorika. ");
INSERT INTO tnc_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Maekarakakuri i'suᵽaka Ᵽedrote sabaaeka. Sabe'erõ'õᵽi mae sayaᵽãia Tuᵽarãte e'eka. ");
INSERT INTO tnc_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","I'sia ĩawa'ri “¿Dako baaerã suᵽa yire sabaayu jee?”, Ᵽedrote ãrĩᵽuᵽajoaeka. I'suᵽaka ᵽuᵽajoabaraka kimekã'ãja, “No'orã Simónre ime”, ãᵽaraka ᵽo'imajare jẽrĩarijariji, Simón wi'iarã neyaeka Corneliore ᵽũataekarã. ");
INSERT INTO tnc_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Torã eyatirã ikuᵽaka najẽrĩaeka: —¿Õ'õrã yaje Simón Ᵽedro wãmeikite ime?— narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Kĩaeka mirãka ᵽuᵽajoabaraka kimekã'ãja, Esᵽíritu Santore kire jaika, —Mia'mitiᵽe. Maekarakamaki ĩmirĩja mire mo'arĩ etairã. ");
INSERT INTO tnc_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Mae miruiwa'ᵽe, naka me'yaokaro'si “¿Yaje judíorãkamarĩrãka ya'rijĩñu je'e?”, ãrĩᵽuᵽajoabekaja mimabe. Yiᵽũatairã nime,— Esᵽíritu Santore kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Suᵽa imarĩ, Corneliore ᵽũataekarã maekarakamaki ᵽõ'irã Ᵽedrote ruiwa'rika. —Yi'iji ñime mija mo'aiki. ¿Dakoa ãrĩwa'ri mija i'tako'o?— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","I'suᵽaka kẽᵽakã'ã ikuᵽaka nayi'rika: —Yija ĩᵽamaki Cornelio miᵽõ'irã yijare ᵽũataraᵽaki. Jiika ᵽo'imaji kime Cornelio. Suᵽabatirã Tuᵽarãte jiyiᵽuᵽayeeiki. Ritaja judíotatarãoka kire jiyiᵽuᵽayeeirã. Suᵽa imarĩ ikuᵽaka ángelte kire ãrãᵽe're: “Mia'mitiᵽe Cornelio, Simón Ᵽedrote miakaᵽũabe. Suᵽabatirã mire kibojarãka jia mia'mitiᵽe”, ángelte yija ĩᵽamakire ãrãᵽe,— Simón Ᵽedrote narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Suᵽa naᵽakã'ã, —Õ'õrã kãkara'atirã yiᵽõ'irã mija kãᵽe ruᵽu,— Ᵽedrote nare ãrĩka. Aᵽerĩmi ᵽuri naka Ᵽedrote a'rika mae. Joᵽewejeakarã ĩ'rãrimarã Jesúre yi'yurãoka, naka jeyoariwa'rikarã. ");
INSERT INTO tnc_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Aᵽerĩmi Cesareawejearã neyaeka. Neyaerã baaeka ruᵽu, kirĩrã suᵽabatirã kijeyomarãᵽitiyika rẽrĩtirã Corneliore imaeka, “Simón Ᵽedrote bojarãka ma'mitiriye'e”, ãrĩwa'ri nare kioyibojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Torã neyaeka ᵽoto Ᵽedrote e'etorirĩ Corneliore ᵽorika. Suᵽabatirã Corneliore ñukuruᵽaeka kire jiyiᵽuᵽayeeokaro'si. ");
INSERT INTO tnc_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","I'suᵽaka kibaamaka kiᵽitakarã ñi'atirã, —Mimi'mibe. Miuᵽakaja ᵽo'imaji ñime yiro'sioka,— Ᵽedrote kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","I'suᵽaka kẽᵽakã'ã kimi'mika mae. Suᵽa imarĩ jaibu'arikaᵽiji wi'iarã nakãkaeka mae. Torã kãkawa'ritirã rĩkimarãja ᵽo'imaja rẽrĩkarãte Ᵽedrote ĩaeka. ");
INSERT INTO tnc_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","I'suᵽaka nimamaka ĩatirã, ikuᵽaka Ᵽedrote nare bojaeka: —Yija judíotatarã aᵽetatarãᵽitiyika rukubaka imarika, suᵽabatirã naᵽõ'irã turirikaoka jãjibaairã yija ime. I'siakaka õrĩwãrũirã mija ime. I'suᵽaka simako'omakaja Tuᵽarã ᵽuri ikuᵽaka yire bojaraᵽaki: “ ‘Jãjibaarimarĩa sime’, ñañua ‘Jãjibaarika sime’, mija ãrĩa'si”, Tuᵽarãte yire ãrãᵽe. Suᵽa imarĩ “Judíotataki imariᵽotojo aᵽetatarãka rukubaka ñima jãjibaarũkimarĩa sime”, ñarĩwãrũyu maekaka ᵽuri. ");
INSERT INTO tnc_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Suᵽa imarĩ Cornelio majaroka yire nabojaraᵽaka ᵽotojo ñojimarĩji miᵽõ'irã yi'taraᵽe. Suᵽa imarĩ ¿marãkã'ã ãrĩwa'ri oka yire mija ᵽũataraᵽe?— Ᵽedrote nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","I'suᵽaka kẽᵽakã'ã, ikuᵽaka Corneliore kire ãrĩka: —Botarakarĩmi sajaritiyu tres rõ'õjĩrã aiyate eyawa'raᵽaka ᵽoto, Tuᵽarãka jaibaraka ñimaraᵽaka be'erõ'õ. Ikuᵽarõ'õᵽiji ángelte saya yaaboaika jããtirã yiᵽõ'irã kiᵽemakotowiraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Toᵽi ikuᵽaka yire kẽrãᵽe mae: “Cornelio. Tuᵽarãte mijẽñeika jĩjimakaᵽi kiã'mitiyu. Suᵽabatirã wayuoka baairãte mijeyobaaika jiaoka kiro'si sime. Saᵽi ãrĩwa'ri jia mire kibaayu. ");
INSERT INTO tnc_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Suᵽa imarĩ Joᵽewejearã imaki Simón Ᵽedro wãmeikite miakarũjebe. Aᵽika Simón wa'iro'si ajea ba'iraberimaji wi'iarã kime riaᵽakirijerã”, ángelte yire ãrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","I'suᵽaka yire kibojamaka ã'mitiriwa'ri, ñojimarĩji oka mire yiᵽũataraᵽe. Jia oka mi'tayu õ'õrã. Tuᵽarãte ĩaika wãjitãji yija rẽrĩko'o kioka simauᵽatiji õñaokaro'si. Tuᵽarãte mire bojaika yija ã'mitiririyaᵽayu,— Corneliore kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Sã'mitiritirã, ikuᵽaka Ᵽedrote jaiũ'mueka mae: —“Aᵽerimarãre kiwãtaika ᵽemawa'ribaji ĩ'rãtatareje wãtabeyuka kime Tuᵽarã”, ñarĩwãrũyu mae. ");
INSERT INTO tnc_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ritatojo wejeareka ᵽo'imajatata imauᵽatirekaja jiyiᵽuᵽaka kire õrĩwa'ri, kiyaᵽaika uᵽakaja baairãka jĩjimaka kimarijayu. ");
INSERT INTO tnc_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Yija tã'omaja Israel wãsa riᵽarãmerãro'si Jesucristo, ritatojo wejeareka imarã ĩᵽamakite baaekaᵽi ãrĩwa'ri jia Tuᵽarãka nimarũkiakaka nare kibojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","38","Mamarĩ Galileaka'iarã, suᵽabatirã ritaja Judea ka'iareka Jesús Nazaretkakire baaeka õñurã mija ime. Ᵽo'imajare wãrõbaraka Juanre naruᵽuko'a jũjeyukã'ãja, mae kirikaᵽi baawãrũiki Jesúre kimaũ'murũjeka Tuᵽarã. Suᵽabatirã Esᵽíritu Santore kire kija'ataeka. I'suᵽaka kibaaekaki imarĩ, Galileakarãre suᵽabatirã Judeaka'iakarãreoka jia kibaaeka. Suᵽa imarĩ ritaja Satanáre ba'iaja jũarũjeroyikarãte kitããroyireka. I'suᵽaka kibaaroyireka, Tuᵽarãte kika imaeka simamaka. ");
INSERT INTO tnc_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Yija, aᵽóstolrãka, Jerusalénwejearã, suᵽabatirã judíotatarã ka'iarã ritaja Jesúre baaeka ĩaekarã. Sabe'erõ'õ Jerusalénrã judíotatarã ĩᵽarimarãte yaᵽua tetaekarã kire jããrũjeka. ");
INSERT INTO tnc_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","I'suᵽaka kire nabaako'omakaja maekarakarĩmireka, Tuᵽarã ᵽuri Jesúre õñia jarirũjekaki. Suᵽabatirã Jesúre yijare kiᵽemakotowiataeka. ");
INSERT INTO tnc_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Judíotatarãte nimauᵽatiremarĩa Jesúre ᵽemakotowirirã Tuᵽarãte baaeka. Mamarĩtaka kiwã'maekarã yija imamaka i'suᵽaka kibaaeka, “Õñia Jesúre ime ate”, yija ãrĩwãrũokaro'si. Ate õñia Jesúre jariᵽe'rika be'erõ'õ kika ba'aekarã yija ime. ");
INSERT INTO tnc_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","“ ‘Õñia imarãte suᵽabatirã reyaekarãteoka, ba'iaja nabaaeka waᵽa nare jẽñerimaji mimabe’, ãrĩwa'ri Tuᵽarãte yire jã'meka ãrĩwa'ri ᵽo'imajare mija bojabe”, Jesúre yijare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Tuᵽarãro'si bojaĩjirimaja imaeka rakamakiji Jesúre imarũkiakaka ᵽuᵽajoawa'ri no'oeka. Suᵽa imarĩ Jesúre yi'yurãte ba'iaja baaeka waᵽa Tuᵽarãte ye'kariarũkiakaka no'oeka,— Ᵽedrote nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","I'suᵽaka ãᵽaraka Ᵽedrote imekã'ãja Esᵽíritu Santore nare ña'rĩjãika. ");
INSERT INTO tnc_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Suᵽa imawa'ri ĩ'rãrokamarĩa ᵽo'imaja oka norĩbeyuaja jaibaraka nimaeka Tuᵽarãte jiyiᵽuᵽayeebaraka. Sĩatirã “Judíorãkamarĩrãteoka Esᵽíritu Santore ña'rĩjãiyu mae”, ãrĩwa'ri naᵽuᵽataeka judíorãka Ᵽedroka ĩ'rãtiji etaekarã. ");
INSERT INTO tnc_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Toᵽi ikuᵽaka judíorãkare Ᵽedrote ãrĩka ate: —Mija ã'mitiᵽe yijeyomarã. Muᵽakajaoka Esᵽíritu Santore nare ña'rĩjãimaka õ'õrã imarãte ĩ'rĩkaoka “Ruᵽuko'a nare mija jũjea'si”, ãrĩrika imaberijĩñu,— judíorãkare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Suᵽabatirã, —“Jesucristore yi'riwa'ri kirirã maime mae”, ãrĩwa'ri ruᵽuko'a mija jũjerũjebe,— Corneliorãkare kẽrĩka. Suᵽa imarĩ naruᵽuko'a najũjeka Ᵽedroka imaekarã. Sabe'erõ'õ, —Me'ria'si ruᵽu. Yijaka mimabe ñojimarĩji ruᵽu,— Ᵽedrote narĩka Cornelioka imaekarã. ");
INSERT INTO tnc_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Toᵽi mae, aᵽóstolrãka, suᵽabatirã Judeaka'iakarã Jesúre ã'mitiriᵽẽaekarãoka, “Judíotatamarĩrã imariᵽotojo, Jesúre na'mitiriᵽẽayu're”, ãrĩka majaroka na'mitirika. ");
INSERT INTO tnc_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","3","Suᵽa imarĩ Jerusalénrã Ᵽedrote ᵽe'rieyaeka ᵽoto, ikuᵽaka kire narĩka: —¿Dako baaerã judíotatamarĩrã wi'iarã mikãkaraᵽe? Suᵽabatirãoka ¿marãkã'ã ãrĩwa'ri naka miba'araᵽe?— Ᵽedrote narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","5","I'suᵽaka kire naᵽakã'ã ikuᵽaka wãjirokaᵽi Ᵽedrote nare bojajiika: —Joᵽewejearã Tuᵽarãte jaibaraka ñimaraᵽaka ᵽoto ikuᵽaka simaraᵽe. Makãrãrũñuroka uᵽakaᵽi ikuᵽaka yire saᵽemakotowiraᵽe: Mabo'ikakuriᵽi sayaᵽãia jo'bato ĩ'ᵽaᵽẽ'rõto ñi'atirã maja'aruetaika uᵽaka ĩoika ima yiᵽõ'irã etaraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","“¿Dakoa satõsiareka ima?”, ãrĩwa'ri jia sañiatiyaraᵽe. Ritajakaka wa'iro'sia, wa'iro'siwẽkoa ᵽariji imaraᵽaka. Wa'ibikirãka uᵽaka tuyua, wiyua, suᵽabatirã yiibaraka tuyuaoka simaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Sañiawearaᵽaka ᵽoto mabo'ikakuriᵽi ikuᵽaka yire sãrĩkoraᵽe: “Ᵽedro mimi'mibe. Jããtirã samiba'abe”, yire sãrĩkoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Marãkã'ã baatirã yibaaberijĩka Ñiᵽamaki, Moisés wãsare jãjibaaeka ba'akoribeyuka ñime ruᵽu”, ãrĩwa'ri yiyi'raᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Suᵽa ñaᵽakã'ã ikuᵽaka yire sãrĩkoraᵽe ate: “ ‘Jãjika yiro'si sime’, merĩa'si, Tuᵽarãte ba'arũjeika ᵽuri ‘Miba'abe’ ”, sãrĩkoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Maekarakakuri i'suᵽaka yire sãrãᵽe. Sabe'erõ'õᵽi mae Tuᵽarãte sayaᵽãia e'emiaraᵽe mabo'ikakurirã. ");
INSERT INTO tnc_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ikuᵽarõ'õᵽiji i'suᵽaka simaraᵽaka be'erõ'õ maekarakamaki ᵽo'imajare ñimaraᵽarõ'õrã eyaraᵽe. Cesareawejeakaki Cornelio nare ᵽũataraᵽaki, yire ne'eayaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","“Netarãka ᵽoto, ba'iaja ᵽuᵽaribekaja naka me'ᵽe”, Esᵽíritu Santore yire ãᵽakã'ã, ya'raᵽe. Suᵽabatirã ĩ'rõtẽñarirakamarã Jesúre ã'mitiriᵽẽairã yika õ'õrã imarã yijeyoa turaᵽarã. Naka mae Cornelio wi'iarã yija kãkaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Yija kãkaeyaraᵽaka ᵽoto, ikuᵽaka Corneliore yijare bojaraᵽe: “Yiwi'iareka ñimaraᵽaka ᵽoto ángelte yire ᵽemakotowirirĩkaraᵽe. Mia je'e ikuᵽaka yire kẽrãᵽe: ‘Joᵽewejearã Simónre akarĩ a'rirũkirãte miᵽũatabe. Ᵽedrooka kire nañu. ");
INSERT INTO tnc_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Mija ᵽõ'irã eyatirã, “Mire, miwi'iareka imarãteoka ba'iaja imarika tiyibeyurõ'õrã mija a'rirũkia imakoᵽeikareka ikuᵽaka Tuᵽarãte mijare tããrãñu”, ãrĩwa'ri mijare kibojarãñu’, Corneliore yijare ãrãᵽe”, ángelte kire ãrĩka bojabaraka. ");
INSERT INTO tnc_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","I'suᵽaka yire kẽrãᵽaka be'erõ'õ, yi'i ate nare bojaũ'muraᵽaki. Nare yijaiũ'muraᵽaka ᵽotojo, ikuᵽarõ'õᵽi Esᵽíritu Santore nare ña'rĩjãiraᵽe, mare mamarĩ kibaaraᵽaka uᵽakajaoka. ");
INSERT INTO tnc_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","I'suᵽaka simakaka ĩawa'ri, Maiᵽamakire bojaeka yiᵽuᵽajoatõᵽoraᵽe. Mia, ikuᵽaka kẽrĩka: “Bikijarã ᵽuri okoaᵽi Juanre ruᵽuko'a mijare jũjeka. Tuᵽarã ᵽuri Esᵽíritu Santo mijare ña'ajããrãki, kiyaᵽaika uᵽakaja baawãrũirã mija imaokaro'si”, i'suᵽakajaoka mamarĩrãja Jesúre mare bojatika. ");
INSERT INTO tnc_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Jesucristore yi'yurã maimamaka, Esᵽíritu Santore Tuᵽarãte mare ña'ajããraᵽaka uᵽakaja judíorãkamarĩrã nimako'omakaja nareoka Esᵽíritu Santore kiña'ajããraᵽe. I'suᵽaka Tuᵽarãte nare baamaka “I'suᵽakamarĩa sime. Judíorãkamarĩrã mija ᵽuri marãkã'ã baatirã yijaka imaberijĩrã mija”, ãrĩberijĩka ñimaraᵽe,— Ᵽedrote nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","I'suᵽaka kẽᵽakã'ã kire najẽrĩatiyika. Toᵽi mae ikuᵽaka naᵽuᵽaka no'aeka: —Jiitakaja baaiki kime Tuᵽarã. Judíorãkamarĩrãteoka ba'iaja nabaaika naja'atarãka, nare kiye'kariarãñu jia kika nimajiᵽarũ,— ãrĩwa'ri narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","I'sia ruᵽubaji Jesúre yi'ribeyurã Estebanre jããekarã. Suᵽabatirã aᵽerã kiuᵽaka imaekarã Jesúre yi'yurãteoka ba'iaja nabaaeka. Suᵽa imarĩ ĩ'rãrimarã Jesúre yi'yurã Feniciaka'iarã, Chiᵽrejũmurikarã imawejeareka, suᵽabatirã Antioquía wejearãoka naru'riwa'rika. Torã eyatirã, judíorãkare takaja Jesúrika bojariroka nabojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Aᵽerã ᵽuri, Chiᵽrekarã, Cirenekarã a'ritirã Antioquíarã eyaekarã. Torã eyatirã judíorãkamarĩrã imaekarãteoka maiᵽamaki Jesúrika nabojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","“Jia nabojawãrũrũ”, ãrĩwa'ri Tuᵽarãte nare jeyobaaeka. Suᵽa imarĩ rĩkimarãja Jesúrika nabojaeka ã'mitiritirã, mamarĩ nayi'rikoᵽeroyika naja'ataeka, kire yi'riwa'ri. ");
INSERT INTO tnc_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Antioquíawejearã Jesúre nayi'yua majaroka, Jerusalénkarã Jesúre yi'yurãte ã'mitirika. Sã'mitiritirã Antioquíarã Bernabére naᵽũataeka. ");
INSERT INTO tnc_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Suᵽa kire naᵽakã'ã ke'rika. Torã eyatirã, Tuᵽarãte jia nare baaeka kĩaeyaeka. I'suᵽaka nimaeka ĩatirã ikuᵽaka jĩjimakaᵽi nare kibojaeka: —Ika mija ima uᵽakaja jiibaji Jesúre mija yi'ririmirĩrĩkawa'ᵽe,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Esᵽíritu Santore kire jeyobaaikaᵽi jiiᵽuᵽaki kimaeka. Tuᵽarãte yaᵽaika uᵽakaja oyiaja imaki imarĩ, jia Jesúre yi'yuka Bernabére imaeka. Suᵽa imarĩ rĩkimarãja kibojaeka ã'mitiritirã, Jesúre nayi'rika. ");
INSERT INTO tnc_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","I'sia be'erõ'õ Tarso wãmeika wejearã Bernabéte a'rika, Saulote mo'arĩ. ");
INSERT INTO tnc_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Kire tõᵽotirã, “Dajoa Antioquíarã”, kire kẽrĩka. Suᵽa kire kẽᵽakã'ã ĩ'ᵽarã najeyoariwa'rika torã. Ĩ'rãkuriwejejẽ'rãka torã nimaeka, Jesúre yi'ririmajaka. Torã imatirã rĩkimarãre Jesúrika nawãrõeka. I'sia wejeakarã Jesúre yi'yurãtejeoka “Cristianorãka nime”, ᵽo'imajare ãrĩũ'mueka. ");
INSERT INTO tnc_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","I'sia ᵽotojo Jerusalénkarã, Tuᵽarãro'si bojaĩjirimajare eyaeka Antioquíarã, Jesúre yi'yurãte rẽrĩtirã imaekarõ'õrã. ");
INSERT INTO tnc_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","30","Torã eyaekarãkaki ĩ'rĩka imaekaki Agabo wãmeiki. Jesúre yi'yurãte rẽrĩtirã imaekarõ'õrã eyatirã, Esᵽíritu Santore jeyobaaikaᵽi ᵽuᵽajoatirã, ikuᵽaka nare kẽrĩka: “Ritatojo ka'iarã nakẽsirabarãñu, ba'arika torã ᵽurirãka simamaka”, Agabote nare ãrĩka. (Ñamajĩbaji ba'arika torã ᵽurika Romawejea ĩᵽamaki Claudiore imaeka ᵽoto). Sã'mitiritirã, “Judeakarãre ba'iaja jũaerã baayu're, niñerũ nare maᵽũataye'e”, Antioquíakarã Jesúre yi'yurãte ãrĩka. Narĩka uᵽakaja, narikaeka ko'aᵽitorãja Saulo, Bernabéᵽitiyika ĩ'ᵽarãwã'taja nijika, “Judeakarã Jesúre yi'yurãte imaruᵽutarimajare samija ĩjibe”, ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","I'sia ᵽoto ritaja Jesúre yi'yurã uᵽatireje ba'iaja Herodere kisurararãkare baarũjeũ'mueka. Suᵽa imarĩ ĩ'rãrimarã nare imaruᵽutarimajare wẽkomaka imariwi'iarã nataeka. ");
INSERT INTO tnc_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Suᵽabatirã, Juan ma'mi Santiagore nañi'aᵽakã'ã, “Kiwãmua mija toata'tabe”, nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","4","I'suᵽaka kẽrĩka ã'mitiritirã, jĩjimaka judíorãka ĩᵽarimarãre jarika. Toᵽi jĩjimaka nimamaka ĩawa'ri ᵽan levadura rukeberika naba'aroyikarĩmi Ᵽedroteoka kiñi'arũjeka wẽkomaka imariwi'iarã kire tayaokaro'si. Ᵽedrote ru'rikoreka jia kisurararãkare kĩarĩrĩrũjeka Herodes. Botarakatata imatirã rakaka tatareka botarakarimarã nimaeka. I'sirakamarã imarĩ, —Botarakamaki oyiaja mija o'arijarirãñu kire tuerikareka,— nare kẽrĩka. Suᵽabatirã “Ᵽascua baya o'riwa'rirãka ᵽoto, ᵽo'imajare ĩarãka wãjitãji Ᵽedrote ba'iaja jaiwã'imarĩtirã, kire yijããrũjerãñu”, Herodes ᵽuᵽaka imaeka. ");
INSERT INTO tnc_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Suᵽa imarĩ ĩ'rãrĩmi uᵽakaja jiitakaja Ᵽedrote natueka. I'suᵽaka nima ã'mitiritirã, kijeyomarã Jesúre yi'yurã jimarĩa Tuᵽarãte kiro'si jaiĩjika. ");
INSERT INTO tnc_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Torã kimaeka ñami simakoᵽeka Herodete kire jããrũjerũkirĩmi. Mia, wẽkomaka imariwi'iarã ĩ'ᵽarã surararãka kire tuerimaja watoᵽekarã ĩ'ᵽamiji ᵽerumijiaᵽi ᵽi'ᵽekaki kikãrĩᵽañaeka. Ĩarĩrĩtiyarũkirõ'õ simamaka aᵽerã surararãka koᵽerekarã tuekarã. ");
INSERT INTO tnc_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ikuᵽarõ'õᵽiji, ángelte kiᵽõ'irã etaeka. Suᵽabatirã kimaeka kurara yaaboaeka jãjia jãta'airõ'õ jarika. Toᵽi mae, kãrĩka imaekaki Ᵽedrote ángelte rabetõrõtaeka. Kitũrũeka ᵽoto, —Wãrũaja mimi'mibe,— kire kẽrĩka. I'suᵽaka kire kẽrĩka ᵽotojo ᵽerumijiaᵽi kiᵽita arikaka naᵽi'ᵽekoᵽeka kutueka. ");
INSERT INTO tnc_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","I'suᵽaka kijarika ᵽoto, —Mijariroaka mijããũ'mube, miũ'ᵽuko'aoka,— Ᵽedrote kẽrĩka. Toᵽi ikuᵽaka kire kẽrĩka ate: —Mijariroaka ᵽemakatooka mijããbe. Suᵽabatirã yibe'erõ'õ mi'tabe,— ángelte kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","I'suᵽaka kire kẽᵽakã'ã, Ᵽedrote kibe'erõ'õ a'rika. I'suᵽaka baariᵽotojo “Suᵽa sime”, marĩwãrũberijĩka simaeka kiro'si. “¿Yaje ritaitaka sime je'e?”, ãrĩriᵽotojo “Makãrãrũñuroka uᵽaka yiro'si sime je'e”, kẽrĩᵽuᵽajoaeka. ");
INSERT INTO tnc_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","A'ririjariji mamarĩkaki surarate tueirõ'õ o'ritirã, aᵽikate imarõ'õoka no'rika. Sa'riwa'ri jiyiakaka ᵽeruakaka baaeka wejekuraraka koᵽerekarã neyaeka ᵽoto sõñu uᵽakaja sawiritaeka. Toᵽi ᵽoritirã na'ririjayukã'ãja ikuᵽarõ'õᵽiji ángelte ririwa'rika. I'suᵽaka simamaka ĩ'rĩkaja Ᵽedrote tuika. ");
INSERT INTO tnc_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Toᵽi mae, “Rita sime. Kãrãrũrĩbeyuka yi'i. Herodete yire jããkoreka yire kiᵽoaerã ángelte kiᵽũatayu Tuᵽarã. I'suᵽaka simamaka judíorãka ĩᵽamarã ba'iaja yire nabaariᵽakatayuareka, yiwaᵽu'yu mae”, Ᵽedrote ãrĩᵽuᵽajoaeka. ");
INSERT INTO tnc_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","13","I'suᵽaka kiᵽuᵽaka imekã'ãja Juan Marcos ᵽako, María wi'iarã ke'rika. Satõsirõ'õrã rĩkimarãja Tuᵽarãte jaibaraka ᵽo'imajare imaeka. I'suᵽaka nimaekarõ'õrã eyatirã koᵽerekaᵽi, —¿Yaje mija ime?— nare kẽrĩka. Sã'mitiritirã ĩ'rãko torã ba'iraberimajo, Rode, koᵽerekarã eyarĩkaritirã, ã'mitirikako, “¿Maki kime?”, ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Sakowierã baaeka ruᵽu, Ᵽedrote jaika koã'mitiriwãrũeka. Sã'mitiriwãrũtirã jĩjimaka jariwa'ri koᵽereka wiebekaja, —Ᵽẽterã Ᵽedrote imakoyu,— ãrĩwa'ri torã imaekarãte bojarĩ ko'rika. ");
INSERT INTO tnc_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","I'suᵽaka nare kõᵽakã'ã, —Miwejabiyu je'e,— kore narĩka. Toᵽi, —Ritama ñañu,— nare kõrĩka. I'suᵽaka nare kõᵽakã'ã, —Kire ĩarĩrĩka mirãki ángel kime je'e aᵽeyari,— kore narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","I'suᵽaka narĩko'omakaja, —¿Yaje mija ime?— ᵽẽteᵽi Ᵽedrote ãrĩrĩkamarika. I'suᵽaka simamaka koᵽereka wiwatatirã kire ĩawa'ri koᵽakaja naᵽuᵽataeka. ");
INSERT INTO tnc_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","I'suᵽaka nimamaka, kiᵽitaka kimimataeka “Kareaja mija imabe”, ãrĩwa'ri. Toᵽi mae, “Wẽkomaka imariwi'iarã ñimako'orõ'õᵽi ikuᵽaka Tuᵽarãte yire baako'o”, nare kẽrĩka. I'suᵽaka nare ãrĩtirã, —Majeyomarã Jesúre yi'yurãte samija bojabe. Suᵽabatirã i'suᵽakajaoka mija ãᵽe Santiagoreoka,— nare kẽrĩka. I'suᵽaka nare ãrĩweatirã aᵽerõ'õrã ke'rika. ");
INSERT INTO tnc_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kiru'rika ñamibikitojo torã ĩarĩrĩrimaja imaekarã surararãkare jimarĩa ba'iaja ᵽuᵽarika Ᵽedrote imabeᵽakã'ã ĩatirã. “¿Marãkã'ã Ᵽedrote baatiyako'o je'e? Ba'itakajama sime”, narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Kimabeᵽakã'ã ĩatirã, Herodete kire mo'arũjeka. Kire natõᵽobeᵽakã'ã Herodete nare jẽrĩaᵽeatiyaeka. I'suᵽaka nare kijẽᵽakã'ã marãkã'ã nayi'riwãrũberijĩka simaeka naro'si. Suᵽa imarĩ Herodete nare jããrũjeka mae. I'suᵽaka nare baatirã Judeaᵽi ke'rika Cesarearã imarĩ. ");
INSERT INTO tnc_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Tirowejeakarã suᵽabatirã Sidónwejeakarãka jiamarĩa imawa'ri boebaka naka Herodete imaeka. I'suᵽaka tokarãka imawa'ri, niñerũ e'eokaro'si ba'arika nare ᵽũatarika kika'iakarãre kijãjibaaeka. Herodes ka'iaᵽi naba'arika e'etoyurã nimaeka Tirowejeakarã suᵽabatirã Sidónwejeakarãoka. Suᵽa imarĩ ĩ'rĩka uᵽaka ᵽuᵽajoawa'ri Herodes ᵽõ'irã okajierĩ ᵽo'imajare naᵽũataeka. Herodete najairã baaeka ruᵽu, kijeyomaki imatiyaiki, Blastoka najaika. Jiaᵽi kire najaiẽjemaka “Jia mika imariyaᵽairã nime”, ãrĩwa'ri Blastore kire ãrĩka. I'suᵽaka kẽᵽakã'ã, “Ĩ'rãrĩmi naka yijairãñu ruᵽu”, Herodete kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Naka kijairã baaekarĩmi, ĩᵽi imarĩ, jia jariroaka ĩᵽarimarãre jããroyika uᵽakakaka kijããeka. Suᵽabatirã ĩᵽire ruᵽaroyikarõ'õrã imatirã, torã rẽrĩkarãre kijaika. ");
INSERT INTO tnc_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Torãjĩrã mae, sã'mitiritirã, —Mia, majiyiᵽuᵽayeeroyikite mare jaiyu, ĩmirĩji uᵽakamarĩa kime,— ãᵽaraka jimarĩa ᵽo'imajare akasereka jĩjimaka imawa'ri. ");
INSERT INTO tnc_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","I'suᵽaka ãᵽaraka nimaeka ᵽoto, Tuᵽarãte ᵽũataekaki ángel, jimarĩ ba'iaja Herodete kimarũjeka. “I'suᵽaka yireka ãrĩbekaja Tuᵽarãte mija jiyiᵽuᵽayeebe”, kẽrĩbeririᵽareareka, wãjua Herodete ba'ariataeka. ");
INSERT INTO tnc_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","I'suᵽaka simaeka be'erõ'õ Jesúre yi'yurãte kirika bojamaka rĩkimabaji sayi'yurãte ᵽubueka. ");
INSERT INTO tnc_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","I'tojĩtejeoka Bernabé, Sauloᵽitiyika Jerusalénkarãre niñerũ ĩjirĩ na'rika. Nare ĩjiweatirã, Juanre Antioquíarã ne'ewa'rika. Juanrejeoka nawãmeyeeka Marcos. ");
INSERT INTO tnc_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioquíarã Jesúre yi'yurãte rẽrĩbaraka imaroyika. Ĩ'rãrimarã nakarã jia kirika bojawaᵽu'atarimaja Tuᵽarãte nare imarũjeka. I'suᵽaka imarã imariᵽotojo, “Ikuᵽaka ᵽo'imajare mija bojawaᵽu'atarijaᵽe”, ãrĩwa'ri kiro'si bojaĩjirimaja ᵽariji nimaeka. Mia, Bernabé, Simón (kirejeoka narĩka Neika), Lucio Cirenekaki, Menahem Galileakaki (ĩᵽi Herodesᵽitiyika ᵽakiarikaki), suᵽabatirã Saulooka imaekaki naka. ");
INSERT INTO tnc_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Maiᵽamakika jaiokaro'si rẽrĩtirã torã nimaeka. Suᵽa imarĩ Tuᵽarãte ᵽuᵽajoabaraka ba'abekaja kire jaibaraka nimaeka. I'suᵽaka nimaeka ᵽoto ikuᵽaka Esᵽíritu Santore nare ãrĩka: —Bernabé, Sauloteoka yiyaᵽaika uᵽakaja baarimaja nimaokaro'si nare ye'eraᵽe. Suᵽa imarĩ yimajaroka wãrõtaᵽarĩ nare mija ᵽũatabe nare yijã'metika uᵽakaja,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","I'suᵽaka kẽrĩka ã'mitiritirã ba'abekaja Tuᵽarãka jaibaraka nimaeka ruᵽu. Suᵽabatirã, Bernabéro'si, Sauloro'sioka jaiĩjibaraka naᵽo'iarã naᵽitaka naja'aᵽeamomeka, Tuᵽarãte nare jeyobaarũ ãrĩwa'ri. I'suᵽaka baatirã nare na'rirũjeka. ");
INSERT INTO tnc_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Suᵽa imarĩ Esᵽíritu Santore nare ãrĩka uᵽakaja Seleuciarã Saulote a'rika, Bernabéᵽitiyika. Torã eyatirã waᵽuruᵽi na'rika Chiᵽre wãmeika jũmurikarã. ");
INSERT INTO tnc_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Torã, Salamina wãmeika wejea imaekarõ'õrã namarĩka. Torã eyatirã judíorãkare rẽrĩriwi'iarã Tuᵽarãrika nawãrõeka. Juan Marcos naka imaekaki, nare jeyobaarimaji imarĩ. ");
INSERT INTO tnc_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","8","I'sia jũmurikareka turitaᵽabaraka Ᵽafoswejea wãmeirõ'õrã neyaeka. Neyaekarõ'õrã judíotataki Barjesús wãmeikite imaeka. Elimas wãmeiki kimaeka griego okaᵽi ᵽuri. Maikoribeyua beaᵽakibaraka “Tuᵽarãro'si jairimaji ñime”, ᵽo'imajare ãrĩrijayuka kimaeka. Jũmurika ĩᵽamaki Sergio Ᵽauloka jeyoayuka kimaeka. Sergio Ᵽaulo ᵽuri jia õrĩwãrũrika ᵽuᵽajoaiki kimaeka. I'suᵽaka imawa'ri Tuᵽarãrika ã'mitirirã Bernabé, Sauloteoka kiakarũjeka. Elimas, maikoribeyua beaᵽakirimaji ᵽuri Bernabé, Sauloᵽitiyika naᵽuᵽajoaika uᵽakamarĩa ᵽuᵽajoaekaki. Suᵽa imarĩ “Jesucristorika najaika mia'mitiriᵽẽa'si”, i'sia wejeakaki ĩᵽire kẽrĩrijarika. ");
INSERT INTO tnc_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","10","Suᵽa imarĩ Esᵽíritu Santore jeyobaaekaᵽi kire ĩarĩkatirã ikuᵽaka Saulote kire ãrĩka (kiwãmeaoka imaeka Ᵽablo): —Satanáre yaᵽaika uᵽakaja baarimaji mime. Suᵽabatirã ritaja jia ima yaᵽabeyuka mime. Saᵽi ãrĩwa'ri ᵽakibaraka ba'iaja ᵽo'imajare mibaarijayu. Maiᵽamaki Tuᵽarãrika bojarirokamarĩa mibojaᵽakiyu. I'suᵽaka mibaaika mija'atabe. ");
INSERT INTO tnc_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","I'suᵽaka mibaaika waᵽa maekakaja ba'iaja Tuᵽarãte mire jũarũjerã baayu. Suᵽa imarĩ miñakoa yarirã baaika mae. I'suᵽaka simamaka ĩabeyuka mimatarãñu. Aiyate yaaika ᵽariji miabesarãñu,— Ᵽablote kire ãrĩka. I'suᵽaka kẽrĩka ᵽotojo kiñakoa ta'sikã'ãja ririwa'rika mae. I'suᵽaka imawa'ri kire tĩtirimaji ĩ'rĩkate kiyaᵽakoᵽeka. ");
INSERT INTO tnc_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","I'suᵽaka kijaᵽakã'ã ᵽuᵽatawa'ri jũmurika ĩᵽamaki ᵽuri, Jesúre kiã'mitiriᵽẽaeka. “Ritaitaka sime nabojaika”, ãrĩwa'ri sakiyi'rika. ");
INSERT INTO tnc_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Toᵽi mae, Ᵽablo kijeyomarãᵽitiyika Ᵽafoswejeaᵽi nakũmujãika Ᵽanfilia ka'ia, Ᵽerge wãmeirõ'õ wejearã a'yaokaro'si. Torã nare maatatirã Juan Marcos ᵽuri Jerusalénrã ᵽe'rikaki. ");
INSERT INTO tnc_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Toᵽi mae, Ᵽergeᵽi imatirã Antioquíawejearã na'rika, Ᵽisidiaka'iwãta imaekarõ'õrã. Toᵽi imatirã jẽrĩtarirĩmi simaeka ᵽoto, judíorãkare rẽrĩriwi'iarã nakãkaeka. ");
INSERT INTO tnc_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Torã naruᵽayukã'ãja Moisés imaekakite jã'mekakaka suᵽabatirã Tuᵽarãro'si bojaĩjirimajare o'oekakaka ĩabaraka ĩ'rĩkate sajaiᵽateka. Kibojaeka be'erõ'õ, judíorãka rẽrĩriwi'i ĩᵽarimarã Bernabé, Ᵽabloᵽitiyika ĩ'ᵽarãte ikuᵽaka narĩᵽũaeka: —Yija jeyomarã, jia majaroka yijareka mija bojarũkia simaye'e, maekaka samija bojabe,— nare narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","I'suᵽaka naᵽakã'ã, Ᵽablote mi'mirĩkaeka. “Jaibekaja mija ã'mitiᵽe ruᵽu”, ãrĩwa'ri kiᵽitaka kimimataeka. Torãjĩrã ikuᵽaka nare kẽrĩka: —Yija jeyomarã Israelkarã, suᵽabatirã judíorãkamarĩrã imariᵽotojo jia Tuᵽarãte yi'yurãoka, jia samija ã'mitiᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Jiyiᵽuᵽaka kire moñuka Tuᵽarãja, Israel ka'iareka imarã ñekiarãte wã'maekaki. Nare wã'matirã jia Tuᵽarãte nare baaeka. Egiᵽtoka'iarã nimaeka, naka'iarãmarĩa nimako'omakaja rĩkimabaji nakãrĩᵽoyaokaro'si nare kijeyobaaeka. Narejeoka kirikaᵽi Egiᵽtoka'iarã nimaeka ᵽoto kiru'rirũjeka. ");
INSERT INTO tnc_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Toᵽi ru'ritirã, ᵽo'imajamatorã ĩ'ᵽarã ᵽo'imajarakakuri wejejẽ'rãka Israeltatarãte imaeka. Torã ĩ'rãkurimarĩa kire ã'mitiriᵽẽabekaja nimako'omakaja nare ĩarĩrĩrimaji Tuᵽarãte imaeka. ");
INSERT INTO tnc_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Canaán wãmeika ka'iakarã ĩ'ᵽotẽñarirakatatarãte Tuᵽarãte riataeka, naka'ia Israeltatarã ñekiarãte kĩjiokaro'si. ");
INSERT INTO tnc_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Suᵽa imarĩ Egiᵽtoka'iarã nimaũ'mueka be'erõ'õ Canaán ka'ia ne'maekarõ'õjĩrã cuatrocientos cincuentarakakuri wejejẽ'rãka sajarika. Sabe'erõ'õ, Samuel, Tuᵽarãro'si bojaĩjirimaji kimaerã baaeka ruᵽu, Israeltatarãte ĩarĩrĩrimaja nimaokaro'si ĩ'rãrimarãre Tuᵽarãte imarũjeka. ");
INSERT INTO tnc_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Samuelte nare imaruᵽutayukã'ãja “Ĩ'rĩka yija ĩᵽamaki yija yaᵽayu”, mañekiarãte ãrĩka Tuᵽarãte. I'suᵽaka naᵽakã'ã, Saúl, Quis maki, niᵽamaki kimaerã Tuᵽarãte kire wã'maeka. Suᵽa imarĩ ĩ'ᵽarã ᵽo'imajarakakuri wejejẽ'rãka rõ'õjĩrã ĩᵽi kimaeka. Benjamín imaekaki riᵽarãmerã riᵽarãmi kimaeka Saúl. ");
INSERT INTO tnc_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","I'tojĩrã be'erõ'õ Saúlre ᵽoatatirã Davidre ĩᵽi Tuᵽarãte imarũjeka. “David, Jesé maki, yiᵽuᵽajoaika uᵽakaja ᵽuᵽajoaiki imaki ñiamaka. I'suᵽaka imaki imarĩ yiyaᵽaika uᵽakaja kibaarãñu”, Tuᵽarãte kireka ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","David riᵽarãmerã riᵽarãmi kimaeka Jesús. Bikija Tuᵽarãte bojara'atika uᵽakaja Israel ka'iakarãre kitããokaro'si Tuᵽarãte kire ᵽũataeka. ");
INSERT INTO tnc_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesúre etaerã baaeka ruᵽubaji Juan, Israelkarãre Tuᵽarãrika wãrõekaki. Suᵽa imarĩ ritaja tokarãre ikuᵽaka kẽrĩka: “Ba'iaja mija baaika ja'atatirã ruᵽuko'a mija jũjerũjebe”, nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Suᵽabatirã kireyaerã baaeka ruᵽuᵽañaka uᵽakaja ikuᵽaka Juanre ãrĩka: “ ‘Tuᵽarãte ᵽũataekakiji kime’, yireka mija ãrĩkoᵽeyu. Jẽno'o i'suᵽakamarĩa sime. No'ojĩrãmarĩaja sajariwa'yu yire ᵽemawa'ribaji imakite etarũkia”, Juanre nare ãrĩka're,— ãrĩwa'ri Ᵽablote nare bojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","—Yijeyomarã Abraham riᵽarãmerã, suᵽabatirã judíorãkamarĩrã imariᵽotojo jia Tuᵽarãte yi'yurãoka, jia mija ã'mitiᵽe. Jesúre yi'riwa'ri ba'iaja imarika tiyibeyurõ'õrã ma'rirũkia imakoᵽeikareka Tuᵽarãte mare tããekakaka mare kiã'mitirirũjeyu. ");
INSERT INTO tnc_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","I'suᵽaka simako'omakaja Jerusalénkarã suᵽabatirã niᵽarimarãoka, “Mare tããrimaji kime”, ãrĩwãrũberikarã. Suᵽabatirã jẽrĩtarirĩmi rakakaja Tuᵽarãro'si bojaĩjirimajare o'oeka ĩatirã aᵽerãte sabojako'omakaja sanorĩwãrũberika. I'suᵽaka imawa'ri Jesúre ĩariᵽotojo, “Tuᵽarãte ᵽũataekaki kime”, narĩwãrũberika. Saᵽi ãrĩwa'ri Jesúre najããrũjemaka, Tuᵽarãro'si bojaĩjirimajare o'oeka uᵽakaja sajarika. ");
INSERT INTO tnc_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","“Ikaᵽi kiᵽareayu”, ãrĩwãrũbeyurã imariᵽotojo, “Kire mijããrũjebe”, ãrĩwa'ri Ᵽilatore naᵽakatarika. ");
INSERT INTO tnc_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","I'suᵽaka baawa'ri Jesúre najããmaka, Tuᵽarãro'si bojaĩjirimajare o'oeka uᵽakaja sajarika. I'suᵽaka kire nabaaeka be'erõ'õ yaᵽua tetaekareka kimakoᵽekarõ'õᵽi aᵽerãte kire rueka. I'suᵽaka kire baatirã ãta wi'iarã kire natarika. ");
INSERT INTO tnc_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","I'suᵽaka kire nabaako'omakaja Tuᵽarãte õñia kire jariᵽe'rirũjeka. ");
INSERT INTO tnc_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Galileaᵽi Jerusalénrã kika a'rika mirãrãte ĩ'rãkurimarĩa kiᵽemakotowirika. I'suᵽaka nare kibaabeaeka ĩaeka mirãrã nime maekakaoka “Rita sime, õñia jarikaki Jesús”, ãrĩwa'ri ᵽo'imajare bojarimaja. ");
INSERT INTO tnc_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Suᵽa imarĩ Bernabéᵽitiyika jía majaroka mijare yibojaetayu. “Jia nare yibaarãñu”, ãrĩwa'ri mañekiarãte Tuᵽarãte bojaeka uᵽakaja mare kibaaeka nariᵽarãmerã mirãrã maimamaka. Mia, Jesúre najããeka simako'omakaja õñia kire kijariᵽe'rirũjeka. I'suᵽaka Tuᵽarãte baarũkia ᵽuᵽajoaweibaraka Salmo segundo wãmeĩᵽũñurã ikuᵽaka Davidre o'oeka: “Maki, yimakitakiji mima simamaka, mae ritaja ᵽo'imajare sañorĩrũjeyu”, Tuᵽarãte ãrĩka Jesúreka ᵽuᵽajoabaraka. ");
INSERT INTO tnc_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Kireyako'omakaja õñia kire yijariᵽe'rirũjerãka simamaka reyarũkimarĩka kimarãñu mae”, Tuᵽarãte ãrĩka. I'suᵽaka simamaka ikuᵽaka sãñu kimajaroᵽũñurã: “Davidre ñarĩtika uᵽakaja, jia mijare baarimajiji ñimarãñu”, Tuᵽarãte ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Mia aᵽea: “Jiyiᵽuᵽaka mire õñuka imarĩ, miyaᵽaika uᵽakaja baaiki ñime. I'suᵽaka simamaka, yiᵽo'ia rabakoreka õñia yire mijariᵽe'rirũjerãñu”, ãᵽaraka Davidre o'oeka. ");
INSERT INTO tnc_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Õñia kimaeka ᵽoto Tuᵽarãte yaᵽaika uᵽaka baaiki Davidre imaeka. I'sia be'erõ'õ kireyaeka. Kireyamaka kiñekiarãte nayayeka wã'tarã kire nataeka. Torã kiᵽo'ia rabaeka. Suᵽa imarĩ aᵽikate ᵽuᵽajoawa'ri majaroka kio'oeka. ");
INSERT INTO tnc_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Jesús ᵽuri rababerikaki Tuᵽarãte õñia kire jariᵽe'rirũjeka simamaka. ");
INSERT INTO tnc_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Mija ã'mitiᵽe yijeyomarã, ikuᵽaka mija õrĩrika yija yaᵽayu: Moiséte jã'meka ma'mitiriᵽẽakoᵽemaka, ba'iaja mabaaikareka mare tããbeyuka Tuᵽarã. I'suᵽaka simako'omakaja Jesúre ã'mitiriᵽẽairãte takaja ba'iaja baarikareka Tuᵽarãte ye'kariayu. Suᵽa imarĩ Jesúre baaekaᵽi ãrĩwa'ri, ba'iaja baakoribeyurã maime Tuᵽarã ñakoareka. ");
INSERT INTO tnc_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","41","Rakajekaja mija imabe, bikija Tuᵽarãro'si bojaĩjirimajare bojaeka uᵽaka mijare sima'si ãrĩwa'ri. Mia je'e, ikuᵽaka sime: “ ‘Jia mija ã'mitiᵽe yire eebaraka, yire jaiwã'imañurãoka. Mija ruᵽurõ'õrã ima ikuᵽarõ'õᵽiji mijare ᵽuᵽatarãka. I'suᵽaka baawa'ri, mijare sariatarãñu. Mija ĩarãka wãjitãji majẽrãko'abeyua yibearãñu. Ĩ'rĩkate mijare sabojarikareka samija õrĩwãrũberijããeka’, Tuᵽarãte ãrĩka”, ãrĩwa'ri kirika bojarimajire o'oeka,— ãrĩwa'ri Ᵽablote wãrõeka Antioquíakarãre. ");
INSERT INTO tnc_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","I'suᵽaka jaiweatirã Ᵽablorãkare ᵽoriwa'rika judíorãka rẽrĩriwi'iaᵽi. Naᵽoriwa'rika ᵽoto, —Aᵽea jẽrĩtarikareka ate yijare sawãrõrĩ mija i'tabe,— nare narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Toᵽi naᵽoriwa'rika ᵽoto rĩkimarãja judíorãkare Ᵽablo, Bernabéᵽitiyika nayejoariwa'rika. Suᵽabatirã judíorãkamarĩrã imariᵽotojo Moiséte jã'meka yi'riwa'ri judíorãkare baaroyika uᵽakaja baarimajaoka naka a'rikarã. I'suᵽaka nabaamaka ikuᵽaka Ᵽablorãkare nare bojaeka: —“Mare wayuĩariwa'ri Jesúre reyaekaᵽi ãrĩwa'ri jĩjimaka Tuᵽarãte maka ime”, ãrĩwa'ri mijare yija bojako'a mija yi'ririja'ata'si,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","I'sia be'erõ'õ jẽrĩtarirĩmi imaekareka, rĩkimabaji i'sia wejeakarãre torã rẽrĩka Tuᵽarãrika ã'mitiyaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","I'suᵽaka nabaamaka jiamarĩa simaeka judíotatarã ĩᵽarimarãro'si. I'sirokaᵽi ãrĩwa'ri Ᵽablote bojamaka ã'mitiritirã aᵽerõ'õrã oyiaja nayi'rika. Suᵽabatirã kiwãrõeka okae'ebaraka ba'iuᵽakaja kire najairiwã'imarĩka. ");
INSERT INTO tnc_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","I'suᵽaka nabaamaka, okajãjiaᵽi ikuᵽaka Ᵽablorãkare nare ãrĩka: —Judíorãka mija imamaka Tuᵽarãrika mijare yibojaũ'mutiraᵽe. I'suᵽaka simako'omakaja samija yi'ribeyu ruᵽu. I'siaᵽi ãrĩwa'ri, Tuᵽarãka õñia imajiᵽarika yaᵽabeyurã uᵽakaja mija ime. Mijare yija bojaika yaᵽabeyurã mija imamaka judíorãkamarĩrãte Tuᵽarãrika yija bojaerã baayu mae. ");
INSERT INTO tnc_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Mia, ikuᵽaka Tuᵽarãte yijare ãrĩka: “Judíorãkamarĩrã ᵽõ'irãoka mire yiᵽũatayu yimajaroka mibojaerã. ‘Ritaja ᵽo'imajare Tããrũkikate yi'yurãte takaja õñia kika Tuᵽarãte imajiᵽarũjerãñu’, ãᵽaraka ritaja ᵽo'imajare mibojabe”, ãrĩwa'ri Tuᵽarã majaroᵽũñurã sabojayu,— nare narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","I'suᵽaka naᵽakã'ã judíorãkamarĩrã imaekarã jĩjimaka imawa'ri “Jiitaka sime Tuᵽarãrika bojariroka”, narĩka. I'suᵽaka imawa'ri kika õñia imajiᵽarũkirãte kire ã'mitiriᵽẽaeka. ");
INSERT INTO tnc_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Suᵽa imarĩ Ᵽablo, Bernabéᵽitiyika nabojaeka ã'mitiritirã tokarã sakoyikuri imaekarãoka sabojaᵽibaekarã. ");
INSERT INTO tnc_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","I'suᵽaka simako'omakaja judíorãka ĩᵽarimarã ᵽuri i'sia wejeakarã imatiyairãte suᵽabatirã judíorãka ᵽuᵽajoaimiji yi'yurã rõmijã imatiyairãᵽitiyika najaibu'aeka. Bernabé Ᵽabloka boebaka imawa'ri, ᵽo'imajare naboibataeka. I'suᵽaka baawa'ri toᵽi nare naᵽoataeka. ");
INSERT INTO tnc_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","I'sia wejeaᵽi naᵽorika ᵽoto nu'ᵽuarã ka'ia eika naᵽajeᵽateka. “Ika wejeakarã Jesúrika bojariroka ã'mitiririᵽe'yoirã imarĩ ba'iaja najũarũkiareka waᵽu'ribeyurã nime”, ãrĩwa'ri i'suᵽaka nabaaeka. I'suᵽaka baatirã, Iconio wãmeika wejearã na'rika. ");
INSERT INTO tnc_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","I'suᵽaka nabaako'omakaja Antioquíawejearã nabojaeka yi'rikarã ᵽuri jĩjimaka imaekarã. Suᵽabatirã Esᵽíritu Santore nare jeyobaamaka ritaja Tuᵽarãte yaᵽaeka uᵽakaja nabaarijarika. ");
INSERT INTO tnc_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Iconiowejearã eyatirã judíorãkare rẽrĩriwi'irã Ᵽablorãkare kãkaeka. Suᵽabatirã Jesúrika bojariroka nare nabojaeka. Sanabojamaka, judíorãka, judíorãkamarĩrãoka rĩkimarãja sanayi'rika. ");
INSERT INTO tnc_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","I'suᵽaka simako'omakaja ĩ'rãrimarã judíorãka Jesúre ã'mitiriᵽẽaberiwa'ri judíorãkamarĩrã imaekarã Ᵽablorãkare naboebayaokaro'si nare waᵽuju najaiᵽakirijarika. I'suᵽaka nabaamaka, “Ba'irã nime”, nareka narĩᵽuᵽajoaeka. ");
INSERT INTO tnc_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","I'suᵽaka nare nabaata'ako'omakaja Iconiorã ñoaka Ᵽablorãkare imataᵽaeka. Torã imataᵽabaraka okajãjirã imarĩ, “Ᵽo'imajare wayuĩawa'ri jia Cristore mare baaeka”, ãrĩwa'ri namajarobojataᵽaeka. “Ritatakama sime”, ᵽo'imajare ãñaokaro'si, majẽrãko'abeyua ᵽariji Ᵽablorãkare beaerã Tuᵽarãte nare jeyobaaeka. ");
INSERT INTO tnc_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","I'suᵽaka simako'omakaja tokarãre ĩ'rĩka ta'iarãja ᵽuᵽajoaberika. Mia je'e: Ĩ'rãrimarã judíorãka uᵽaka ᵽuᵽajoariᵽotojo aᵽerã Ᵽablorãka uᵽaka ᵽuᵽajoaekarã. ");
INSERT INTO tnc_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Suᵽabatirã Ᵽablorãkare ba'iaja baariᵽuᵽajoawa'ri, judíorãka, judíorãkamarĩrã, ĩᵽarimarãkaoka jaitirã, “Ãtaᵽi Ᵽablorãkare majããye'e”, narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","I'suᵽaka nareka narĩka rakajewa'ri, Licaonia ka'iarã Ᵽablorãkare ru'riwa'rika. Torã eyatirã tokarãre Jesúrika bojariroka nabojataᵽaeka. Listra wãmeirõ'õ suᵽabatirã Derbe wãmeika wejearãoka sanawãrõtaᵽaeka. I'suᵽakajaoka nabaaeka sawã'tarã imaekarãte. ");
INSERT INTO tnc_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","9","Listrarã ĩ'rĩka bitamaji turiwãrũbekaja ᵽo'ijirikakite imaeka. Tokarãre Ᵽablote jaimaka kiã'mitiriruᵽaeka kiro'si. Kire ĩarĩkatirã, “ ‘Yire jiejĩki Tuᵽarã’, ãrĩᵽuᵽajoaiki kime”, Ᵽablote kireka ãrĩᵽuᵽajoaeka. ");
INSERT INTO tnc_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Toᵽi mae, —Mi'mitirã jia meyarĩkaᵽe,— Ᵽablote kire ãrĩka. I'suᵽaka kire kẽrĩka ᵽotojo bu'rirĩkatirã kituriũ'mueka. ");
INSERT INTO tnc_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","I'suᵽaka nabaamaka ĩawa'ri, —Yeeja'a, ĩ'rã ĩ'ᵽarã majiyiᵽuᵽayeeroyirã nime. Ᵽo'imaja ᵽo'iuᵽakaᵽi ña'rĩjãitirã ĩmiᵽi maᵽõ'irã netayu,— ãrĩwa'ri tokarãre akasereka aᵽetomaja okaᵽi. ");
INSERT INTO tnc_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","I'suᵽaka imawa'ri Bernabére Zeus, narĩka, suᵽabatirã Ᵽablote Hermes narĩka, “Zeusro'si jia bojawaᵽu'atarimaji kime”, ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","I'sia wejeata'i a'riwa'ri rõ'õrã Zeusre jiyiᵽuᵽayeeriwi'ia imaeka. Tokaki kura uᵽaka naro'si imaekaki Ᵽablorãkare jiyiᵽuᵽayeeriyaᵽaekaki. Suᵽa imarĩ wa'ibikirãwẽkoarã õ'õrika ja'aᵽeatirã, wejeakuraraka koᵽerekarã sake'ewa'rika. Torã eyatirã wa'ibikirãwẽkoa jããrika nayaᵽaeka, Ᵽablorãkare jiyiᵽuᵽayeeokaro'si. ");
INSERT INTO tnc_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","15","I'suᵽaka naro'si nabaariyaᵽamaka ĩatirã, Ᵽablorãkare najariroaka baibebaruika. “Jiamarĩa mija baariyaᵽayuma”, ãrĩwa'ri i'suᵽaka nabaaeka. Suᵽabatirã, ᵽo'imaja watoᵽekarã jorobaraka jãjirokaᵽi ikuᵽaka nare najẽrĩaeka: —¿Dako baaerã i'suᵽaka mija baariyaᵽayu? ¡Mija uᵽaka ᵽo'imajajaoka yija ime! Tuᵽarãrika bojariroka mijare bojarĩ yija i'tayu, mija õñu uᵽakaja mija baaᵽo'ijiaekarãte mija jiyiᵽuᵽayeerija'ataokaro'si. I'suᵽaka simamaka Tuᵽarã õñia imajiᵽakite mija jiyiᵽuᵽayeebe. Mia je'e, iki imaki ka'ia, wejeᵽema, riaᵽakiakaoka, suᵽabatirã ritaja sareka imaoka ᵽo'ijiaekaki. ");
INSERT INTO tnc_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Bikija imaekarã nayaᵽaika uᵽakaja waᵽuju imaja jiyiᵽuᵽayeera'aekarã. Sayaᵽaberiko'omakaja, Tuᵽarãte nare saja'atarũjeberika. ");
INSERT INTO tnc_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Kire najiyiᵽuᵽayeeberiko'omakaja jia nare kibaaeka, “Jia baaiki Tuᵽarãte ime”, narĩwãrũokaro'si. Mia, okoa kijarirũjeyu, jia ba'arika bikiokaro'si. I'suᵽaka ima ba'atirã ña'ᵽirika maimaerã, suᵽabatirã jĩjimaka maimaerã mare kijeyobaayu,— Ᵽablorãkare nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","I'suᵽaka narĩko'omakaja wa'ibikirãwẽkoa ᵽo'imajare jããriyaᵽaeka Ᵽablorãkare jiyiᵽuᵽayeeokaro'si. I'suᵽaka nabaamaka ĩawa'ri, “Yijare jiyiᵽuᵽayeewa'ri ᵽuri wa'ibikirãwẽkoa mija jãã'sima”, Ᵽablote ᵽo'imajare ãrĩtataeka. ");
INSERT INTO tnc_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Torãjĩrã judíorãka Antioquíakarã suᵽabatirã Iconiokarãoka etaekarã. Torã eyatirã torã imaekarãre kire nokabaaeka Ᵽablote niariᵽe'yoerã. I'suᵽaka naᵽakã'ã Ᵽablote ãtaᵽi najããbareka. Toᵽi “Koᵽakaja kire mariatayu mae”, ãrĩwa'ri weje a'riwa'rirã kire nayiewa'rika. ");
INSERT INTO tnc_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","I'suᵽaka nabaako'omakaja Jesúre yi'yurãte kiᵽõ'irã eyaeka ᵽoto Ᵽablote jãjika. I'suᵽaka imawa'ri wejearã naka kiᵽe'riwa'rika ate. Aᵽerĩmi mae Derbe wãmeirõ'õrã ke'rika Bernabéᵽitiyika. ");
INSERT INTO tnc_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Torã eyatirã Jesúrika bojariroka ᵽo'imajare nawãrõeka. Sanabojamaka ã'mitiritirã rĩkimarãja sanayi'rika. Torã imatatirã, Listrarã, Antioquíarã, Iconiorãoka ate nawi'ituririjarika ᵽe'ririjaᵽaraka. ");
INSERT INTO tnc_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Wejerakakaja neyarijarikarõ'õrã Jesúre ã'mitiriᵽẽairãᵽitiyika najaika. Sanajaimaka ã'mitiriwa'ri, jiibaji Jesúre yi'riwa'ri okajãjia tokarãre jarika. “Jesúre mija yi'yua mija ja'ata'si. Tuᵽarãte jã'meirõ'õrã maeyaerã baarãka ruᵽu rĩkimakaja ba'iaja jũarijarirũkirã maime”, ãᵽaraka nabojarijarika. ");
INSERT INTO tnc_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Wejerakakaja neyarijarika uᵽakaja Jesúre yi'yurãte imaruᵽutarimaja imarũkirãte nawã'maeka. Maiᵽamaki Jesúre jiyiᵽuᵽayeewa'ri ba'abekaja ruᵽu ikuᵽaka kire najaika: “Õ'õrã mirirãte imaruᵽutarimajare jia mijeyobaabe”, Ᵽablorãkare kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","I'suᵽaka nabaaeka be'erõ'õ Ᵽisidiarõ'õᵽi o'riwa'ritirã Ᵽanfiliaka'iarã neyaeka. ");
INSERT INTO tnc_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ᵽerge wãmeika wejearã Jesúrika bojariroka wãrõweatirã, Atalía, riaᵽakirijerã imaekarõ'õrã na'rika. ");
INSERT INTO tnc_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Atalíarõ'õᵽi kũmujãitirã Siria ka'iarã imaeka Antioquíarõ'õrã na'ririjarika. Mamarĩ i'sia wejearã Jesúrika bojariroka nabojataᵽaerã baaeka ruᵽu, “Mirika ba'iraberika nare mija'ataeka uᵽaka oyiaja nabaawãrũerã nare mijeyobaabe”, Jesúre ã'mitiriᵽẽaekarãte ãrĩka Tuᵽarãte. Suᵽa imarĩ narĩka uᵽakaja baataᵽaweatirã Antioquíarã Ᵽablorãkare ᵽe'rietaeka. ");
INSERT INTO tnc_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Torã ᵽe'rietatirã Jesúre ã'mitiriᵽẽaekarãte narẽrĩrũjeka. Suᵽabatirã ritaja Tuᵽarãte nare jeyobaaekakaka tokarãre nabojaeka. “Jia Tuᵽarãte yijare jeyobaaraᵽe. Suᵽa imarĩ judíorãkamarĩrã imarãoka Jesúrika bojariroka jia ã'mitiyurã imarĩ Jesúre nayi'yu”, ãrĩwa'ri nabojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ñoaka torã Jesúre ã'mitiriᵽẽairãka Ᵽablorãkare imaeka. ");
INSERT INTO tnc_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Antioquíarã nimaeka ᵽoto Judeaka'iaᵽi judíorãka Jesúre yi'yurãte etaeka. Torã eyatirã Jesúre yi'rikarãte judíotatarãkare baaroyika nare nawãrõeka. —Bikija Moisés imaekakite jã'meka uᵽaka circuncisión mija baabesarãkareka, Tuᵽarãte mijare tããbesarãñu,— nare narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","I'suᵽaka narĩka ã'mitiritirã Ᵽablorãkaro'si jiamarĩa simaeka. Suᵽa imarĩ ĩ'ᵽaᵽẽ'rõtorãja jãjiaᵽi najaibu'aeka. Suᵽa imarĩ “Ritamarĩa simeje'e nawãrõika”, ãrĩᵽuᵽajoawa'ri Jerusalénrã Ᵽablote kijeyomaki Bernabéᵽitiyika, suᵽabatirã ĩ'rãrimarã naka imaekarãteoka na'rirũjeka, aᵽóstolrãka, suᵽabatirãoka Jesúre yi'yurãte imaruᵽutairãka jaiokaro'si. “Torã eyatirã ‘¿Dako baaerã circuncisión baarika sime?’, ãrĩwa'ri nare mija jẽᵽe”, narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Toᵽi a'ritirã Fenicia, Samaria ka'iarãoka eyatirã, Jesúre yi'rikarãte ikuᵽaka nabojaeka: “Judíorãkamarĩrã imariᵽotojo yija bojaika yi'riwa'ri jiyiᵽuᵽaka norĩkoᵽeka ja'atatirã Jesúre yi'yurã”, ãrĩwa'ri nare nabojaeka. Suᵽa narĩka ã'mitiritirã jĩjimaka najarika. ");
INSERT INTO tnc_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jerusalénrã neyaeka ᵽoto aᵽóstolrãka, suᵽabatirã Jesúre yi'yurã, nare imaruᵽutarimajaoka jia nare e'etorikarã. Toᵽi mae, Tuᵽarãᵽi ãrĩwa'ri ritaja nabaaroyika majaroka nare nabojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","I'suᵽaka naᵽakã'ã, ĩ'rãrimarã fariseokaka ᵽuᵽajoairã imariᵽotojo Jesúre yi'rikarã imarĩ, aᵽerã Jesúre yi'yurãka jairã nami'mirĩkaeka. —Judíotatamarĩrã imariᵽotojo Jesúre yi'yurãteoka circuncisión baarika, suᵽabatirã Moiséte jã'meka uᵽakaja yi'ririka sime,— narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Suᵽa imarĩ aᵽóstolrãka, Jesúre yi'yurãte imaruᵽutarimajaoka rẽrĩkarã sajaiokaro'si. ");
INSERT INTO tnc_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ñoaka jaibaraka nimaeka be'erõ'õ, mi'mirĩkatirã ikuᵽaka Ᵽedrote nare ãrĩka: —Yuᵽaka imarã, mija ã'mitiᵽe. Bikija mijakakiteje e'etirã, Tuᵽarãte yire ᵽũataeka judíorãkamarĩrãte Jesús majaroka yibojaerã. Sã'mitiritirã Jesúre nayi'rirũ ãrĩwa'ri nare sayibojaeka. I'suᵽaka mijare ñañua õñurã mija ime. ");
INSERT INTO tnc_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","9","Tuᵽarã imaki ritaja ᵽo'imajare ᵽuᵽajoaika õñuka. I'suᵽaka imaki imarĩ “Judíorãkamarĩrãoka yirirã nimarũ”, ãrĩwa'ri Esᵽíritu Santore nare kiña'ajããeka, mare kiña'ajããeka uᵽakaja. Suᵽa imarĩ “Judíorãkamarĩrã nimamaka ba'iaja nabaaika nareka yiye'kariabesarãñu”, kẽrĩberika. Muᵽakaja Jesúre yi'yurã nimamaka kireyaekaᵽi ãrĩwa'ri ba'iaja nima nareka jõjotatirã jiiᵽuᵽarã nare kimarũjeka. ");
INSERT INTO tnc_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","I'suᵽaka simako'omakaja “Jĩjimaka mijaka Tuᵽarãte imaerã mija baarũkia jariwa'yua ruᵽu”, Jesúre yi'yurãte mija ãrĩrijayu. I'suᵽaka jã'mebeyuka maekaka Tuᵽarã. I'suᵽakamarĩa simako'omakaja mija ᵽakatayuaᵽi ãrĩwa'ri jiamarĩa mijaka Tuᵽarãte ime. Mia, Moisés imaekakite jã'meka simaja yi'riwãrũberikarã mañekiarãoka. Sanayi'riᵽatawãrũberika uᵽakajaoka maro'si sime maekaka. ");
INSERT INTO tnc_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ikuᵽaka simatiyayu: Jia maiᵽamaki Jesúre mare baaekaᵽi ãrĩwa'ri ba'iaja mabaaikareka Tuᵽarãte mare tããyu. I'suᵽakajaoka judíorãkamarĩrãro'si sime,— Ᵽedrote nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","I'suᵽaka Ᵽedrote ãrĩka ã'mitiritirã nimauᵽatiji nokata'rika. I'suᵽaka nimaeka ᵽoto, Tuᵽarãᵽi ãrĩwa'ri maikoribeyu uᵽaka ima judíorãkamarĩrãte nabaabeaeka, Ᵽablo, Bernabéᵽitiyika nare nabojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Sabe'erõ'õjĩte Santiagote ikuᵽaka ãrĩka: —Ñañua jia mija ã'mitiᵽe yijeyomarã. ");
INSERT INTO tnc_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Judíorãkamarĩrã majaroka Simónre mare bojaweayu. Sã'mitiritirã, “Judíotatamarĩrãteoka kirirã nimaerã jia Tuᵽarãte baaũ'mueka”, marĩwãrũyu. ");
INSERT INTO tnc_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","I'suᵽakajaoka Tuᵽarãro'si bojaĩjirimajare bikija o'oeka: ");
INSERT INTO tnc_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“David wi'ia ᵽo'imajare riatako'omakaja ñamajĩ ate jia sabaaᵽe'aokaro'si yetarãñu. ");
INSERT INTO tnc_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","18","I'suᵽaka yibaarãñu ‘Tuᵽarãte mayi'riye'e’, judíorãkamarĩrã yiwã'maekarãte ãñaokaro'si. Yi'i, mija ĩᵽamakiji, i'suᵽaka ñañu, bikijarãja yirirãte sõrĩrũjera'aekaki imarĩ.” ");
INSERT INTO tnc_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ika yijaiweaikaᵽi ãrĩwa'ri: Matã'omajamarĩrã imarã ba'iaja nabaaika ja'atairã nime Tuᵽarãte yi'riwa'ri. I'suᵽaka simamaka, “Mañekiarãte imara'aeka uᵽakaja baarika sime”, nare ãrĩrũkimarĩa sime. ");
INSERT INTO tnc_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","21","I'suᵽaka nare ãrĩbekaja, ᵽaᵽera nare maᵽũataye'e ikuᵽaka nare okajããokaro'si: “Waᵽuju imaja jẽrãka jiyiᵽuᵽaka õrĩwa'ri sawã'tarã ri'ia naᵽããeka mija ba'a'si. Rõmikirã, tĩmiairã, rõmimarĩrã, tĩmiamarĩrãoka ba'iaja baabekaja mija imabe. Suᵽabatirãoka wa'iro'sia sawãmua namokoru'ataeka mija ba'a'si, i'suᵽakajaoka sariwea.” Jẽrĩtarirĩmi rakakaja judíorãkare rẽrĩriwi'iarã i'suᵽaka nabojara'aeka nimataᵽaekarõ'õrã. Suᵽa imarĩ, i'suᵽaka ñañu, jiyubeyua judíorãkare naka jarikoreka,— Santiagore nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","I'suᵽaka kẽᵽakã'ã, aᵽóstolrãka, Jesúre yi'yurãte imaruᵽutarimaja, suᵽabatirã kire yi'yurã nimauᵽatiji ikuᵽaka ãrĩkarã: “I'suᵽaka mare kibojaika simamaka, ĩ'rãrimarã maka imarãte maᵽũataerã Ᵽablorãkaka ika ᵽaᵽera ne'ewa'rirã”, narĩka. Sayi'rikarã imarĩ Judas (kirejeoka narĩka Barsabás) suᵽabatirã Silas nimaeka Antioquíarã Ᵽablorãkaka jeyoariwa'rirũkirã. Jesúre yi'yurãte imaruᵽutarimaja nimamaka i'suᵽaka nare nabaaeka. ");
INSERT INTO tnc_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ikuᵽaka sabojaeka i'sia ᵽaᵽera: “Aᵽóstolrãka, suᵽabatirã kire yi'yurãte imaruᵽutarimaja ika ᵽaᵽera ᵽũatairã. Antioquía, Siria, Ciliciarõ'õrã imarãro'si oka yija ᵽũatayu. Judíorãkamarĩrã imariᵽotojo Jesúre yi'yurã imarĩ, yija jeyomarã mija ime. ");
INSERT INTO tnc_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ikuᵽaka sime, mia: Ĩ'rãrimarã yijakarã mija ᵽõ'irã eyatirã rukubaka nare naᵽuᵽajoarũjeraᵽe ãrĩrika majaroka yija ã'mitiyu. I'suᵽaka mijare wãrõrĩ nare yija ᵽũataekamarĩrã nime. ");
INSERT INTO tnc_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","27","I'suᵽaka simamaka ĩ'rĩka ta'iarãja ᵽuᵽajoatirã ‘Naka jairimajare maᵽũataye'e’, yija ãñu. I'suᵽaka ᵽuᵽajoawa'ri, Judas, Silas, wayuoka moñurã Ᵽablo, Bernabéᵽitiyika mija ᵽõ'irã yija ᵽũatarãñu. Ᵽablorãka aᵽerãte nare jããrika yaᵽakoᵽeko'omakaja Jesúrika bojariroka bojarija'atabeyurã imarã nime ĩ'ᵽarã naruᵽuko'amarã. Mija ᵽõ'irã eyatirã ika yija o'oika uᵽakaja mijare bojarimaja nime. ");
INSERT INTO tnc_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Esᵽíritu Santore yijare jeyobaaikaᵽi ᵽuᵽajoairã imarĩ, ‘Mañekiarãte imara'aeka uᵽakaja yi'ririka sime’, mijare yija ãrĩᵽakataribeyu. Suᵽa imarĩ ika takaja mijare yija ãñu: ");
INSERT INTO tnc_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","‘Waᵽuju imaja jẽrãka jiyiᵽuᵽaka õrĩwa'ri sawã'tarã ri'ia naᵽããika mija ba'a'si. Suᵽabatirã wa'iro'sia mija jããika ᵽoto sariwea juruikaoka mija ba'a'si. Sawãmua namokoru'ataikaoka ba'abekaja. Mia, rõmikirã, tĩmiairã, rõmimarĩrã, tĩmiamarĩrãoka ba'iaja baabekaja mija imabe.’ Samija yi'rirãkareka, jia mija imarãñu, mijare yija ãñu. Jia mija imabe”, ãrĩwa'ri no'oeka. ");
INSERT INTO tnc_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","I'suᵽaka nare ãrĩtirã nare sane'ewa'rirũjeka. I'suᵽaka na'ᵽakã'ã Antioquíarã eyatirã Jesúre yi'yurãte narẽrãtaeka. Narẽrĩka ᵽoto ᵽaᵽera nare nijika. ");
INSERT INTO tnc_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Nare nijika ĩatirã jĩjimaka tokarãre jarika, jia nare sabojaeka simamaka. ");
INSERT INTO tnc_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Suᵽa imarĩ Judas, Silasoka Tuᵽarãro'si bojaĩjirimaja imarĩ, tokarã Jesúre yi'yurã imaekarãte rĩkimarãre kirika nabojawãrõeka. I'sia majaroka ã'mitiritirã jiibaji Jesúre yi'riwa'ri okajãjia najarika. ");
INSERT INTO tnc_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Torã nuᵽaka imaekarãka imatatirã “Yijare ᵽũataraᵽarã ᵽõ'irã yija ᵽe'rirã baayu mae”, narĩka. I'suᵽaka naᵽakã'ã “Jia nimarũ mijare ᵽũataraᵽarã”, nare narĩka Tuᵽarãte yi'yurã. ");
INSERT INTO tnc_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","35","Toᵽi naᵽe'riwa'rika ᵽoto Antioquíarã Ᵽablo, Bernabéᵽitiyika natuika Jesúrika bojariroka bojarĩ aᵽerã najeyomarãᵽitiyika. ");
INSERT INTO tnc_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Suᵽa imarĩ ĩ'rãrĩmi ikuᵽaka Ᵽablote ãrĩka Bernabére: —Jesúrika mawãrõekarãte ĩarĩ ma'rirã, Jesúre yi'yurãte marãkã'ã ime ãrĩwa'ri.— ");
INSERT INTO tnc_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","I'suᵽaka kẽᵽakã'ã, “Jee, dajoa, suᵽabatirã Juan Marcore maka ma'ewa'riye'e”, Bernabére kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","I'suᵽaka kẽrĩko'omakaja, Ᵽablote yaᵽaberika, “Ᵽanfiliarã yija imaeka ᵽoto yijare ja'atatirã Jerusalénrã Juan Marcore yijare ᵽe'ritaᵽawa'rika”, ãrĩwa'ri kibojaeka. Suᵽa imarĩ Ᵽablote kire akariyaᵽaberika ate. ");
INSERT INTO tnc_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","I'suᵽaka simamaka ñoaka najaibu'aeka simako'omakaja ĩ'rĩka uᵽakaja naᵽuᵽajoaberika. I'suᵽaka imawa'ri ᵽibitirã rakaka oyiaja na'rika. Juan Marcos, Bernabéka waᵽuruᵽi, Chiᵽre wãmeika jũmurikarã na'rika. ");
INSERT INTO tnc_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ᵽablo jeyomaki Silas imaekaki kika a'rirũkika. Torã na'rirã baaeka ruᵽu jia Tuᵽarãte nare baarũ ãrĩwa'ri, naro'si kire najẽñeka tokarã Jesúre ã'mitiriᵽẽairã. I'suᵽaka nabaaeka be'erõ'õ koᵽakaja na'rika mae. ");
INSERT INTO tnc_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Torã a'ririjarikõrĩ Siriarã, suᵽabatirã Ciliciarõ'õrãoka Jesúrika bojariroka nabojaeka. Jesúre yi'rikarãka jaitirã jiibaji Jesúre yi'ᵽaraka okajãjia nimaerã i'suᵽaka Ᵽablorãkare nare jeyobaaeka. ");
INSERT INTO tnc_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Toᵽi Ᵽablorãkare Derbewejearã a'ritirã, Listra wãmeika wejearã neyaeka. Torã eyatirã Jesúre ã'mitiriᵽẽaikite niatõᵽoeka. Timoteo wãmeiki kimaeka. Kiᵽako imaekako judíotatako, Jesúre yi'yuko. Kiᵽaki ᵽuri griegotataki kimaeka. ");
INSERT INTO tnc_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listrawejeakarã, suᵽabatirã Iconiowejeakarã Jesúre ã'mitiriᵽẽairã jia ᵽuᵽajoabaraka najaika Timoteoreka. ");
INSERT INTO tnc_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","I'sia õrĩwa'ri Timoteore naka a'ririka Ᵽablote yaᵽaeka. Naka ke'rika ruᵽubaji, circuncisión Ᵽablote kire baaeka. “Judíotatamarĩki kiᵽakire imamaka circuncisión Timoteore kibaarũjeberika. I'suᵽaka kireka nimauᵽatiji noñu”, ãrĩwa'ri i'suᵽaka Ᵽablote kire baaeka judíotatarãte kire ĩariᵽe'yoa'si ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Listrarã nimaeka be'erõ'õ aᵽea wejearã na'rika. Suᵽa imarĩ Timoteore naka jeyoariwa'rika. Ĩ'rãweje jariwa'ririmarĩaja ikuᵽaka Jesúre yi'yurãte nabojarijarika: “Jerusalénrã aᵽóstolrãka suᵽabatirã Jesúre yi'yurãte imaruᵽutarimajare rẽrĩtirã ikuᵽaka mijare narĩᵽũayu: ‘“Judíotatarã ñekiarãte imara'aeka uᵽakaja yi'ririka sime”, mijare yija ãrĩbeyu.’ Ĩ'rãriroka takaja mija yi'rijĩñu”, aᵽóstolrãkare ãrãᵽakakaka nare nabojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","I'suᵽaka naᵽakã'ã ã'mitiriwa'ri, Jesúre yi'rikatatarãre jiibaji kire ã'mitiriᵽẽamirĩrĩkawa'rika. Suᵽabatirã ĩ'rãrĩmi uᵽakaja rĩkimabaji naᵽuburijarika. ");
INSERT INTO tnc_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Asiaka'iarã Jesúrika bojariroka nabojataᵽaarika naᵽuᵽajoako'omakaja, toᵽi no'rirũkimarĩa simaerã Esᵽíritu Santore nare õrĩrũjeka. Suᵽa imarĩ Frigiaka'ia, Galaciaka'iarã Ᵽablorãkare o'ritaᵽawa'rika. ");
INSERT INTO tnc_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Toᵽi o'riwa'ritirã Misiaka'ia ta'irõ'õrã neyaeka. Toᵽi Bitiniaka'iarã a'ririka naᵽuᵽajoakoᵽeka. I'suᵽaka simako'omakaja Esᵽíritu Santore toᵽi nare a'rirũjeberika. ");
INSERT INTO tnc_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Misiaka'iaᵽi o'riwa'ritirã Tróade wãmeika wejearã natu'aeyaeka. ");
INSERT INTO tnc_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","I'sia wejearã eyatirã i'sirĩmi ñami makãrãrũñuroka uᵽakaᵽi Macedoniakakire rĩkamaᵽakã'ã Ᵽablote ĩaeka. —Õ'õrã Macedoniarã mi'tabe, yijare jeyobaaokaro'si,— Macedoniakakire Ᵽablote ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","“Ikuᵽaka yikarãrũrĩko'o”, Ᵽablote ãᵽakã'ã ã'mitiriwa'ri, “Macedoniarã kirika bojariroka wãrõrĩ Tuᵽarãte mare ᵽũatayu”, yija ãrãᵽe. Suᵽa imarĩ a'yaokaro'si yija ba'irĩjia yija jieraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tróade wejeaᵽi kũmujãitirã, wãjiaja Samotracia wãmeika jũmurikarã yija a'raᵽe. Aᵽerĩmi Neáᵽolisrã yija eyaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Toᵽi Filiᵽosrã yija a'raᵽe. Rĩkimarãja Romawejeakarãre imaraᵽe torã. Macedonia ka'iareka imatiyaiweje simaraᵽe. Ñoaᵽañaka yija imaraᵽe torã. ");
INSERT INTO tnc_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Jẽrĩtarirĩmi simaraᵽaka ᵽoto weje a'riwa'ri imaraᵽaka riakarã yija turaᵽe. “I'sia wejearã imarãte Tuᵽarãka jairijayurõ'õ sime je'e”, yija õrĩkoᵽeraᵽe. Torã eyatirã, yija eyaruᵽarimomeraᵽe. Toᵽi ruᵽarĩjĩ, torã rẽrĩbaraka imaraᵽarã rõmijãte Jesúrika bojariroka yija bojaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ĩ'rãko Lidia wãmeiko, Tiatirawejeakako, naka imaraᵽako. Suᵽabatirã sayaᵽãia jía iyayaᵽea ĩoika waruaka ĩjirirõmo koimaraᵽe. Judíorãkamarĩko imariᵽotojo Tuᵽarãte jiyiᵽuᵽaka õñuko imarĩ, Ᵽablote jaimaka Tuᵽarãte kore ã'mitiriᵽẽarũjeraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Jesúre koã'mitiriᵽẽamaka, ruᵽuko'a kore yija jũjeraᵽe suᵽabatirã korĩrãreoka. I'suᵽaka kore yija baaraᵽaka be'erõ'õ ikuᵽaka yijare kojairaᵽe: —“Ritaoka Jesúre yi'yuko koime”, mija ãrĩye'e, mija i'tabe yiwi'iarã,— jiaᵽi yijare kõrãᵽe. I'suᵽaka kõᵽakã'ã kowi'iarã tuirĩ yija a'raᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ĩ'rãrĩmi ᵽo'imajare Tuᵽarãka jairoyikarõ'õrã a'rikõrĩ bikirirõmore yija ĩatõᵽoraᵽe. Satanárika ima ña'rĩjãikako koimaraᵽe. I'suᵽaka imaraᵽako imarĩ, ñamajĩ wejeareka o'rirũkia kobojaraᵽe. Suᵽa imarĩ koĩᵽarimarãre rĩkimaka niñerũ tõᵽoraᵽe, i'suᵽaka bojaiko koimamaka. ");
INSERT INTO tnc_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Iko bikirirõmo yija be'erõ'õᵽi rĩrĩra'atirã ikuᵽaka koakasereraᵽe: —Ĩ'rã ĩmirĩja imarã imatiyaiki Tuᵽarãte yi'yurã. “Jesúre mija yi'rirãkareka, mijare kitããrãñu”, ãrĩwa'ri mijare nabojayu,— ãrĩokaika ritaja ᵽo'imajare kobojaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ĩ'rãrĩmi uᵽakaja i'suᵽaka kire koakasererĩrĩka. I'suᵽaka jajua kobaata'amaka ĩawa'ri, ba'iaja simaeka Ᵽabloro'si. Suᵽa imarĩ jororĩkatirã Satanárika ima koreka ña'rĩjãikakite ikuᵽaka Ᵽablote ãrĩka: —Jesucristorikaᵽi koreka mire yiᵽorirũjeyu,— Ᵽablote ãrĩka Satanárika ima. I'suᵽaka kẽrĩka ᵽotojo kore ña'rĩjãikoᵽekakite koreka ᵽorika. ");
INSERT INTO tnc_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Koreka kiᵽoritaᵽaeka be'erõ'õ, ñamajĩ o'rirũkia kobojawãrũberika mae. I'suᵽaka koimamaka ĩatirã, “Aᵽekurioka ate niñerũ tõᵽobesarãñurã maime mae”, koĩᵽarimarãre ãrĩᵽuᵽajoaeka. Suᵽa imarĩ Ᵽablote, Silareoka naboebarika. Suᵽa baatirã nare ñi'atirã wejeñe'metãji imatiyairõ'õ ĩᵽarimarã ᵽõ'irã nare ne'ewa'rika. ");
INSERT INTO tnc_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ĩᵽarimarã wãjitãji nare e'eeyatirã ikuᵽaka narĩka: —Ĩrã judíotatarã mawejeakarãre rukubaka ᵽuᵽajoarũjerimaja imarã. I'suᵽaka imarã imarĩ mawejearã oka naᵽo'ijiayu mae. ");
INSERT INTO tnc_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Romatatarãre baaroyika uᵽakamarĩa nawãrõrijayu. Suᵽa imarĩ nawãrõika uᵽaka mabaaberijĩñu,— narĩka niᵽarimarãre. ");
INSERT INTO tnc_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","I'suᵽaka naᵽakã'ã ã'mitiriwa'ri, Ᵽablorãkare jimarĩa naboebaeka ᵽo'imaja. Suᵽa imarĩ nare naᵽajeũ'mueka. Toᵽi jariroaka nare ne'etarũjeka i'sia wejeakarã ĩᵽarimarã. Suᵽabatirã wajoaᵽi nare naᵽajerũjeka. ");
INSERT INTO tnc_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","I'suᵽaka jãjiaᵽi nare ᵽajetirã, wẽkomaka imariwi'iarã nare natarũjeka. Suᵽabatirã, —Jia nare miarĩᵽe naru'rikoreka,— wẽkomaka imariwi'ia ĩarĩrĩrimajire narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","I'suᵽaka ĩᵽarimarãre ãᵽakã'ã ã'mitiriwa'ri, wẽkomaka imariwi'i tõsibajirã imaeka kurarakarã maᵽoriwãrũberijĩrõ'õrã nare kitarika. Suᵽabatirã nu'ᵽua yaᵽuᵽãia koᵽeru'aika watoᵽekarã kiᵽi'ᵽeka. ");
INSERT INTO tnc_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","I'suᵽaka kibaako'omakaja Ᵽablo, Silasᵽitiyika Tuᵽarãka jaitirã ñami ᵽoto nabayakoyaeka. Aᵽerã wẽkomaka imariwi'iarã imaekarã nabayakoyamaka ã'mitirikarã. ");
INSERT INTO tnc_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ikuᵽarõ'õᵽiji ka'ia jãjia iyika. Suᵽabatirã wẽkomaka imariwi'ia iyika. I'suᵽaka sabaayuju koᵽereka wiritaᵽataeka. I'suᵽaka sabaamaka torã imaekarãte ᵽerumijia nare naᵽi'ᵽeka kutuᵽataeka. ");
INSERT INTO tnc_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","I'suᵽaka simamaka wẽkomaka imariwi'i ĩarĩrĩrimajire tũrũeka. Ĩ'rãkoᵽereka rakakaja wiritaᵽataeka imamaka, ĩawa'ri, “Wẽkomaka imariwi'iarã imakoᵽeirãte ru'riᵽatayu je'e”, kẽrĩᵽuᵽajoakoᵽeka. Suᵽa imarĩ kisara e'etirã kiõñu uᵽakaja jããririrã kibaakoᵽeka. ");
INSERT INTO tnc_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","I'suᵽaka kibaaerã baaeka ᵽoto ikuᵽaka Ᵽablote kire ãrĩka: —¡Miᵽo'ia jããbekaja! Yija imauᵽatiji õ'õrã yija imaᵽatayu.— ");
INSERT INTO tnc_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Suᵽa imarĩ yaaboaika wẽkomaka imariwi'ia ĩarĩrĩrimajire jẽñeka. Suᵽabatirã Ᵽablorãka ᵽõ'irã rĩrĩkãkawa'ritirã nawãjitãji kiñukuruᵽaeka, kĩkiwa'ri tarabaraka. ");
INSERT INTO tnc_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Aᵽerõ'õrã nare e'ewa'ritirã, ikuᵽaka nare kijẽrĩaeka: —¿Marãkã'ã yibaajĩñu, ba'iaja yibaaikareka Tuᵽarãte yire wayuĩaokaro'si?— kẽrĩka Ᵽablorãkare. ");
INSERT INTO tnc_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","I'suᵽaka kẽᵽakã'ã, ikuᵽaka nayi'rika: —Maiᵽamaki Jesucristore mia'mitiriᵽẽarãkareka, Tuᵽarãte mire tããrãñu, suᵽabatirã mirĩrãreoka,— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Suᵽabatirã maiᵽamaki Jesucristorika bojariroka kire nabojaeka. Kiwi'iarã imaekarãteoka nabojaᵽataeka. ");
INSERT INTO tnc_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","I'siñamiji nare naᵽajeka kãmia kijũjeka Ᵽablorãkareka. I'suᵽaka nare baaweatirã kiruᵽuko'a kijũjerũjeka, kirirãreoka. ");
INSERT INTO tnc_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","I'sia be'erõ'õ kiwi'iarã Ᵽablorãkare kiakawa'rika nare ba'ariji'aokaro'si. “Tuᵽarãte yi'yurã yija ime mae”, ãrĩwa'ri kirĩrãᵽitiyika jia jĩjimaka nimaeka mae. ");
INSERT INTO tnc_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Bikitojo i'sia wejeakarã ĩᵽarimarã surararãkare ᵽũataekarã, wẽkomaka imariwi'ia ĩarĩrĩrimajire bojarĩ, —Nare mija'atabe mae, na'yaokaro'si.— ");
INSERT INTO tnc_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Suᵽa imarĩ wẽkomaka imariwi'ia ĩarĩrĩrimaji ikuᵽaka ãrĩkaki Ᵽablote: —Ĩᵽarimarãre jã'meika uᵽakaja mijare yija'ataerã baayu. Suᵽa imarĩ dakoa ba'iaja ᵽuᵽaribekaja mija a'ᵽe mae,— kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","I'suᵽaka kẽᵽakã'ã ã'mitiriwa'ri, ikuᵽaka Ᵽablote bojaeka surararãkare: —Dakoa ᵽarea yijare imaberiko'omakaja ika wejea ĩᵽarimarã ᵽo'imaja wãjitãji yijare naᵽajerũjeraᵽe. I'suᵽaka yijare nabaarũjeraᵽe ¿dakoa ba'iaja nabaako'o? ãᵽekaja. Suᵽabatirã ika wẽkomaka imariwi'iarã yijare natarũjeraᵽe. Romakarã uᵽaka yija imako'omakaja najã'meika yi'ribekaja i'suᵽaka yijare nabaaraᵽe. Suᵽa imarĩ maekaka ᵽo'imajare õrĩbeyukaji yijare naja'atariyaᵽakoᵽeyu. I'suᵽakamarĩa simarãñu. Noñu uᵽakaja yijare ᵽoarĩ ni'tarũ,— Ᵽablote ãrĩka surararãkare. ");
INSERT INTO tnc_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","I'suᵽaka kẽᵽakã'ã ã'mitiritirã ĩᵽarimarãre bojarĩ surararãkare a'rika. I'suᵽaka nabojamaka ã'mitiritirã, Romakarãja Ᵽablorãkare imamaka õrĩwãrũtirã ĩᵽarimarãre kĩkika. ");
INSERT INTO tnc_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Suᵽa imarĩ Ᵽablorãka ᵽõ'irã okajierĩ ĩᵽarimarãre a'rika. I'suᵽaka baaweatirã, nare naja'ataeka. “Aᵽea wejearã mija a'ᵽe ruᵽu”, jiaᵽi nare narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Wẽkomaka imariwi'iaᵽi ᵽoritirã Lidia wi'iarã Ᵽablorãkare a'rika. Torã eyatirã Jesúre ã'mitiriᵽẽaekarãte narẽrãtaeka. Jesúrikakaka nare nabojaeka jiibaji Jesúre yi'ᵽaraka okajãjia nimaerã. I'suᵽaka naka najaika be'erõ'õ aᵽea wejearã na'rika mae. ");
INSERT INTO tnc_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Filiᵽoswejeaᵽi a'ritirã, Anfíᵽoliswejea, suᵽabatirã Aᵽoloniawejeaᵽi Ᵽablorãkare o'ririjarika. I'sia be'erõ'õ Tesalónica wãmeika wejearã neyaeka. I'sia wejearã judíotatarãte rẽrĩriwi'ia imaeka. ");
INSERT INTO tnc_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ᵽablo, kibaaroyika uᵽaka baarĩ, judíotatarãte rẽrĩriwi'iarã a'rikaki. Suᵽabatirã maekarakakuri jẽrĩtarirĩmi Tuᵽarãrika bojariroka torã rẽrĩtirã imaekarãte kibojawaᵽu'ataeka. Tuᵽarãro'si bojaĩjirimaja imaekarãte o'oeka ᵽuᵽajoatirã, ikuᵽaka ᵽo'imajare kibojaeka: ");
INSERT INTO tnc_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","—“Ᵽo'imajare Jã'merũkika, Tuᵽarãte ᵽũatarãñuka ba'iaja jũarãki. Suᵽabatirã kireyarãñu. Reyakoᵽeriᵽotojo ate õñia kijariᵽe'rirãñu”, ãrĩwa'ri Tuᵽarãro'si bojaĩjirimajare ãrĩo'oekakiji kime Jesucristo, mare Jã'merũkika Tuᵽarãte wã'maekaki,— Ᵽablote nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","I'suᵽaka kẽᵽakã'ã ã'mitiriwa'ri, ĩ'rãrimarã judíotatarã Jesúre yi'rikarã mae. Suᵽa imarĩ Ᵽablo, Silasᵽitiyika ĩ'rĩka uᵽakaja ᵽuᵽajoaekarã imarĩ nare najeyoarika. Rĩkimarãja judíotatamarĩrã imariᵽotojo Tuᵽarãte jiyiᵽuᵽayeekarãte kibojamaka ã'mitiritirã, Jesúreoka na'mitiriᵽẽaeka mae. Rĩkimarã tokarã rõmijã imatiyairã Jesúre ã'mitiriᵽẽaekarã naro'si. Ĩ'rãjaoka jeyoarikarã Ᵽablote, Silasᵽitiyika. ");
INSERT INTO tnc_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ᵽablorãkare rĩkimarãja ᵽo'imajare ã'mitiriᵽẽamaka ĩawa'ri, tokarã judíotatarãte Ᵽablorãkare ã'mijĩaeka. Suᵽa imarĩ i'sia wejeareka imaekarã ba'iaja baairãte narẽrãtaeka. “Yijare mija jeyobaabe. Ika wejeareka imarã wãjitãji Ᵽablorãkare ba'iaja majairãñu, Ᵽablorãkare naboebayaokaro'si ᵽo'imaja”, judíotatarãte nare ãrĩka. I'suᵽaka baawa'ri, rĩkimarãja ᵽo'imajare narẽrãtaeka. Suᵽa imarĩ Jasón wi'iarã Ᵽablorãkare mo'arĩ na'rika, nare e'eᵽoatirã ᵽo'imajare nare ĩjiriyaᵽawa'ri. ");
INSERT INTO tnc_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nare tõᵽoberiwa'ri, Jasónre, suᵽabatirã ĩ'rãrimarã Jesúre ã'mitiriᵽẽaekarãte ĩᵽarimarã ᵽõ'irã ne'ewa'rika. Ikuᵽaka jãjirokaᵽi ĩᵽarimarãre nabojaeka: —Ᵽablo, Silasᵽitiyika rĩkimakaja wejeareka rukubaka oka baataᵽaraᵽarã imarã. Mawejearãoka rukubaka baarĩ netayu. ");
INSERT INTO tnc_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ĩ'ĩ Jasón kiwi'iarã nare e'etoraᵽaki. Ĩ'rĩka Jesús wãmeikireka, “Iki kime ĩᵽi imatiyaiki”, ãrĩwa'ri maiᵽamaki Césarte jã'meka yi'ribeyurã nime,— niᵽamarãre narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","I'sia oka ã'mitiriwa'ri i'sia wejeakarã, niᵽarimarãᵽitiyika jiamarĩa naro'si simaeka. ");
INSERT INTO tnc_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","“Mijare yija ja'atarika mija yaᵽaye'e, yijare mija waᵽaĩjibe”, narĩka Jasónrãkare. Suᵽa imarĩ ĩᵽarimarãre nawaᵽaĩjika. ");
INSERT INTO tnc_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Sarã'ika be'erõ'õ ñami Jesúre ã'mitiriᵽẽaekarã Ᵽablorãkare naᵽũataeka Bereawejearã. Torã eyatirã judíotatarãte rẽrĩriwi'iarã nakãkaeka. ");
INSERT INTO tnc_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Bereawejeareka imaekarã Tesalónicawejeakarãre jiibaji Ᵽablorãkare ã'mitiririyaᵽaekarã. Torã Jesúrika bojariroka kibojamaka jia jĩjimakaᵽi na'mitirika. Suᵽabatirã kire ã'mitiritirã, “¿Yaje Tuᵽarã oka ãñu uᵽakaja yijare kibojayu?”, ãrĩwa'ri Tuᵽarã majaroᵽũñu niarijarika. ");
INSERT INTO tnc_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","“Rita sime kibojaika”, ãrĩwa'ri rĩkimarãja judíorãkare Jesúre yi'rika. I'suᵽakajaoka ĩ'rãrimarã judíotatamarĩrã imatiyairã ĩmirĩja, rõmijãᵽitiyika Jesúre yi'rikarã. ");
INSERT INTO tnc_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","“Berearã Ᵽablote Tuᵽarãrika bojarikaroka bojayu”, ãrĩwa'ri majaroka Tesalónicakarã judíotatarãte ã'mitirika. I'sia ã'mitiriwa'ri naboebarika. Suᵽa imarĩ Bereawejearã a'ritirã ᵽo'imajare rukubaka naᵽuᵽajoarũjeka. Suᵽa imarĩ Bereawejeakarã Ᵽablote boebarikarã. ");
INSERT INTO tnc_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","I'suᵽaka nimaeka ã'mitiriwa'ri, ñojimarĩji ĩ'rãrimarã tokarã Jesúre ã'mitiriᵽẽairã Ᵽablote riaᵽakirijerã e'ewa'rikarã. Silas, Timoteoᵽitiyika ᵽuri tuikarã, naka a'ribekaja. ");
INSERT INTO tnc_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Riaᵽakiakarã tu'aeyatirã waᵽuruᵽi Atenas wãmeika wejearã Ᵽablote ne'ewa'rika. Torã kire taritirã Berearã naᵽe'rika ate. Naka Ᵽablote majaroka ᵽũataeka, “Silas, Timoteoᵽitiyika ñojimarĩᵽañakaja ni'tarũ”, ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Silare, Timoteoᵽitiyika ta'abaraka Atenawejearã ĩataᵽarĩ Ᵽablote a'rika. I'sia wejearã rĩkimaka waᵽuju imaja jẽrãka najiyiᵽuᵽayeeika ĩawa'ri ba'iaja kiᵽuᵽaritiyaeka. ");
INSERT INTO tnc_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Suᵽa imarĩ judíorãkare rẽrĩriwi'iarã Jesúrika Ᵽablote bojaeka judíotatarãte, suᵽabatirã judíotatamarĩrã imariᵽotojo Tuᵽarãte jiyiᵽuᵽayeekarãte. I'suᵽakajaoka ĩ'rãrĩmi jariwa'ririmarĩaja wejeñe'metãji turitaᵽarãte i'sirokajaoka Ᵽablote bojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Tokarã eᵽicureoskaka wãrũrimaja, suᵽabatirã estoicoskaka wãrũrimajaoka Ᵽabloka nokatotoeka. Jesús majaroka, suᵽabatirã reyakoᵽeriᵽotojo ate õñia kijariᵽe'rika majaroka nare kibojaeka. Suᵽa imarĩ ĩ'rãrimarã ikuᵽaka ãrĩkarã: —¿Dakoakaka õrĩᵽũabeyukate i'suᵽaka jaiyu?— narĩka. Aᵽerã ᵽuri: —Aᵽeto wejeakarã najiyiᵽuᵽayeeroyirãreka kijaiyu je'e aᵽeyari,— narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Suᵽa imarĩ “Areóᵽago wãmeirõ'õrã dajo majaiari”, ãrĩwa'ri Ᵽablote ne'ewa'rika. Torã rẽrĩtirã imaekarã ĩᵽarimarãre ikuᵽaka ãrĩka: —Mamaka majaroka mibojaika ã'mitiririka yija yaᵽayu. ");
INSERT INTO tnc_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Yija ã'mitirikoribeyua majaroka miwãrõyu. ¿Marãkã'ã ãrĩrika miwãrõyu? Yijare mibojabe ruᵽu,— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Atenakarã, suᵽabatirã aᵽeto ka'iakarã torã imaekarã mamaka ᵽuᵽajoariroka ᵽuᵽajoabaraka jaikarã, aᵽea baabekaja. Suᵽa imarĩ mamakukukaka majaroka Ᵽablote bojarika na'mitiririyaᵽaeka. ");
INSERT INTO tnc_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Suᵽa imarĩ nawatoᵽekaᵽi mi'mirĩkatirã ikuᵽaka Ᵽablote nare bojaeka Areóᵽago wãmeirõ'õrã: —Mija ã'mitiᵽe Atenareka imabayurã. Rĩkimaka jẽrãka jiyeka mija jiyiᵽuᵽayeemaka ñiayu. ");
INSERT INTO tnc_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Mija wejearã, turitaᵽabaraka jẽrãka jiyiᵽuᵽayeerĩ mija rẽrĩrijayurõ'õ rakakaja ñiataᵽaraᵽe. Ĩ'rãkõ'rĩmato ikuᵽaka ãrĩo'oekarõ'õ yitõᵽoraᵽe: “Õ'õ sime Maikoribeyukate jiyiᵽuᵽayeerũkirõ'õ”, ãrĩo'oeka simaraᵽe. Mija õrĩbeyuka majaroka yibojaerã baayu mae. ");
INSERT INTO tnc_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Ika ka'ia, ritatojo ika wejeareka ima ᵽo'ijiaekaki Tuᵽarã. Ritaja ika ka'iareka imarã, mabo'ikakurirã imarã ĩᵽamaki imarĩ, ᵽo'imajare baaᵽo'ijiaeka kire jiyiᵽuᵽaka õrĩriwi'iarãmarĩa kime. ");
INSERT INTO tnc_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Dika jariwa'ribeyua kiro'si. Kiro'si mabaarijitokoᵽeika yaᵽabeyuka. Iki imaki ritaja õñia maimarũkia mare ja'ataiki. ");
INSERT INTO tnc_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Mamarĩtaka ĩmirĩjite takaja Tuᵽarãte ᵽo'ijiaeka. Ikiᵽi ãrĩwa'riji ritaja ᵽo'imajatatarãte Tuᵽarãte kãrĩᵽoaeka. Ika ka'iarã rakakaja nimaokaro'si Tuᵽarãte nare ᵽibataeka kiyaᵽaeka uᵽakaja. Iki imaki “Ika ka'iareka nimarãñu, suᵽabatirã i'tojĩrã wejeareka õñia nimarãñu”, ãrĩrũkika. ");
INSERT INTO tnc_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","I'suᵽaka Tuᵽarãte baaeka “¿Marãkã'ã Tuᵽarãte morĩjĩñu je'e?”, ᵽo'imajare ãrĩrũ ãrĩwa'ri. “Yire õrĩriyaᵽawa'ri yirirã ᵽo'imajare imarũ”, Tuᵽarãte ãrĩka. Kire morĩriyaᵽajĩkareka ᵽuri, yoerãmarĩaja Tuᵽarãte ime. Makaja imaki kime. ");
INSERT INTO tnc_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","“Tuᵽarãᵽi ãrĩwa'ri õñia maime, marĩ'meyu, suᵽabatirã ika ka'iarã mare kimarũjeyu. Kimaberirikareka maimaberijããeka.” Ikuᵽaka ãᵽaraka ĩ'rãrimarã mijaro'si majarobojarimajare o'oeka: “Tuᵽarã makarã maime”, ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","I'suᵽaka simamaka “Ikuᵽaka kime Tuᵽarã”, ãrĩᵽuᵽajoawa'ri, ãtakaka, orokaka, ᵽlatakakaoka najiyiᵽuᵽayeerũkika ᵽo'imajare jia baaᵽo'ijiako'omakaja, Tuᵽarã makarã imarĩ “I'suᵽaka nabaaᵽo'ijiaeka ĩoiki Tuᵽarãte ime je'e”, marĩᵽuᵽajoaberijĩñu. ");
INSERT INTO tnc_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","I'suᵽaka ᵽo'imajare jia õrĩᵽũabeririᵽotojo ba'iaja baaeka waᵽa Tuᵽarãte nare jẽñeberika ruᵽu. I'suᵽakamarĩa sime maekaka. Suᵽa imarĩ maekaka ritaja ba'iaja mabaaika ja'atarika Tuᵽarãte mare jã'meyu. ");
INSERT INTO tnc_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ñamajĩ ba'iaja ᵽo'imajare baaika waᵽa kijẽñerũkirĩmi õrĩtiiki Tuᵽarã. Jia oyiaja baaiki imarĩ, nabaaeka takaja sawaᵽa nare kijẽñerãñu. Ĩ'rĩka kiwã'maekaki i'suᵽaka baarãki. “Reyakoᵽeriᵽotojo õñia Tuᵽarãte kire jariᵽe'rirũjeka simamaka Cristo imaki Tuᵽarãte wã'maekaki”, ritaja ᵽo'imajare ãrĩwãrũyu,— Ᵽablote nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Õñia jariᵽe'ririkakaka ã'mitiriwa'ri eebaraka Ᵽablote ĩ'rãrimarãre boiwã'imarĩka. I'suᵽaka nabaako'omakaja aᵽerã ᵽuri ikuᵽaka ãrĩkarã: —Ate samijaiᵽe'arika ã'mitiririka yija yaᵽayu,— Ᵽablote narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Suᵽabatirã rẽrĩbaraka nimaekarõ'õᵽi Ᵽablote ᵽoritaᵽawa'rika. ");
INSERT INTO tnc_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ĩ'rãrimarã kiuᵽaka ᵽuᵽajoatirã Jesúre ã'mitiriᵽẽaekarã. Ĩ'rĩka Dionisio wãmeiki naka imaekaki, Areóᵽago rẽrĩroyikarãkaki. Ĩ'rãko Dámaris wãmeikooka Jesúre ã'mitiriᵽẽaekako. Suᵽabatirã aᵽerãoka kire yi'rikarã naro'si. ");
INSERT INTO tnc_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","I'sia be'erõ'õ Atenawejeaᵽi Ᵽablote a'rika, Corintowejearã. ");
INSERT INTO tnc_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Torã eyatirã ĩ'rĩka Aquila wãmeiki, Ᵽontoka'iakakika Ᵽablote tõᵽobu'aeka. Aquila kirũmu Ᵽriscilaᵽitiyika Italiaka'iaᵽi a'ritirã Ᵽablo ruᵽubaji Corintorã neyaweika. Romakaki ĩᵽi Claudio wãmeiki Italiaka'iarã judíotatarãte imarika yaᵽaberiwa'ri, nare kiᵽoataeka. Suᵽa imarĩ Corintorã Aquilate a'rika kirũmuᵽitiyika, judíotatarã imarĩ. Sabe'erõ'õ naᵽõ'irã wi'iturirĩ Ᵽablote a'rika. ");
INSERT INTO tnc_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ᵽablo uᵽakaja sayaᵽãia mo'rĩakakaᵽi Aquilate wi'ia baaeka kirũmuᵽitiyika. Suᵽa imarĩ ĩ'rãkõ'rĩmatorãja ba'irabeokaro'si naka kituika nawi'iarã. ");
INSERT INTO tnc_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ĩ'rãkuri jẽrĩtarirĩmi jariwa'ririmarĩa judíorãkare rẽrĩriwi'iarã Jesúrika bojariroka bojarĩ Ᵽablote a'riroyika. Judíotatarã suᵽabatirã judíotatamarĩrãteoka Jesúrika na'mitiriᵽẽaokaro'si nare kijaiẽjeriyaᵽaeka. ");
INSERT INTO tnc_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","I'sia be'erõ'õ, Macedoniaᵽi i'tatirã, Silas, Timoteoᵽitiyika neyaeka Ᵽablo ᵽõ'irã Corintowejearã. Neyaeka ᵽoto kiba'iraberika ja'atatirã Jesúrika bojarirokatakaja bojabaraka Ᵽablote imaeka. Ikuᵽaka judíotatarãte wãrõbaraka kijaika: “Jã'merũkika Tuᵽarãte wã'maekaki, kirejeoka yija ãñu Jesús”, kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","I'suᵽaka kẽrĩko'omakaja, aᵽerã aᵽeuᵽaka ᵽuᵽajoawa'ri, jajua kire baata'aekarã. Suᵽabatirã ba'iaja kire naᵽiᵽeka. I'suᵽaka naᵽakã'ã ã'mitiriwa'ri, kijariroaka kijããᵽateka “Koᵽakaja mijare yokajããkoᵽeko'o”, ãrĩᵽuᵽajoawa'ri. Suᵽabatirã ikuᵽaka kẽrĩka: —Tuᵽarãte yire jã'meka uᵽakaja kirika bojariroka mijare yibojakoᵽeyu. Suᵽa imarĩ mija reyarãñurĩmi ba'iaja imarika tiyibeyurõ'õrã mija a'rirãka, oka yire imabesarãka. Suᵽa imarĩ mija ã'mitiririyaᵽabeyua ĩawa'ri, irĩmiᵽi judíotatamarĩrã imarãte Jesúrika bojariroka yibojaũ'muerã baayu,— kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Toᵽi ᵽoriwa'ritirã Ticio Justo wi'iarã Ᵽablote a'rika ᵽo'imajare wãrõrĩ. Judíorãkamarĩki imariᵽotojo Tuᵽarãte jiyiᵽuᵽaka õrĩkaki kimaeka Ticio Justo. Kiwi'i wã'tarã simaeka judíorãkare rẽrĩriwi'ia. ");
INSERT INTO tnc_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Crisᵽo wãmeiki imaekaki judíorãkare rẽrĩriwi'i ĩᵽamaki. Iki, kirĩrãoka maiᵽamaki Jesúre ã'mitiriᵽẽairã nimaeka. I'suᵽakajaoka Corintowejeakarã Jesúrika ã'mitiritirã rĩkimarãja kire ã'mitiriᵽẽaekarã. Suᵽabatirã ruᵽuko'a najũjerũjeka. ");
INSERT INTO tnc_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","10","Ĩ'rãñami makãrãrũñuroka uᵽakaᵽi Jesúre jaika Ᵽablote, —Mikaja ñime. Suᵽa imarĩ mikĩkia'si. Aᵽerã ba'iaja mire baawãrũbesarãñurã. Okajãjia jaritirã yimajaroka ᵽo'imajare mibojajiᵽabe. Ika wejeareka rĩkimarãja yire ã'mitiriᵽẽarũkirã imamaka, samibojarija'ata'si,— Ᵽablote kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Suᵽa imarĩ Corintorã ĩ'rãkuri wejejẽ'rã aᵽejẽ'rã ñe'metãjirã ᵽo'imajare Jesúrika bojariroka bojabaraka kimaeka. ");
INSERT INTO tnc_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","I'sia be'erõ'õ Galión wãmeiki Acaya ka'iarã ĩᵽi kimaeka ᵽoto ĩ'rĩka uᵽaka oyiaja ᵽuᵽajoawa'ri Ᵽablote judíotatarãte ñi'aeka. Suᵽabatirã Galión wãjitãji kire ne'ewa'rika. ");
INSERT INTO tnc_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ikuᵽaka kire nabojaeka: —“Ikuᵽaka Tuᵽarãte majiyiᵽuᵽayeeyu”, ãrĩwa'ri Moiséte yijare jã'meka uᵽakamarĩa kiwãrõtaᵽe ĩ'ĩ,— Galiónre narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ᵽablote jairã baaeka ᵽotojo ikuᵽaka Galiónre nare ãrĩka: —Ba'iaja baaiki kimarikareka, suᵽabatirã Romatatarãre jã'meika yi'ribeyuka kimarikareka, mijare ña'mitirijĩñu imakoᵽeyu. ");
INSERT INTO tnc_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Mija õñu uᵽakaja mija jã'meika simamaka, mija ᵽuᵽayariji oka mija jiebe. Yi'i ᵽuri i'sia oka jierimaji marĩka imarika yaᵽaiki,— judíotatarãte kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Suᵽabatirã judíotatarãte Galiónre ᵽoatarũjeka surararãkare. ");
INSERT INTO tnc_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Suᵽabatirã judíorãkare rẽrĩriwi'i ĩᵽamaki Sóstenere nañi'aeka ᵽo'imaja. I'suᵽaka baatirã Galión wãjitãji kire naᵽajeka. I'suᵽaka nabaako'omakaja, “¿Dako baaerã kire mija ᵽajeyu?”, Galiónre ãrĩberika. “Marã imabeyua yire”, kẽrĩᵽuᵽajoaeka. ");
INSERT INTO tnc_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Corintorã matikuri Ᵽablote imaeka ruᵽu. I'sia be'erõ'õ Jesúre ã'mitiriᵽẽaekarãte kimajaroka kibojaeka a'yaokaro'si. Suᵽabatirã Aquila, kirũmu Ᵽriscilaᵽitiyika Siriaka'iarã a'yaokaro'si, Cencreaswejearã natu'awa'rika. Cencreaswejeaᵽi na'rirã baaeka ruᵽu, “Tuᵽarã, miwãjitãji mire yibojaraᵽaka uᵽakaja yibaako'o”, ãrĩwa'ri kiruᵽua Ᵽablote wi'eᵽaterũjeka. ");
INSERT INTO tnc_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Waᵽuruᵽi a'ritirã Éfesowejea ᵽaᵽitakarã neyaeka. Torã eyatirã Aquila, kirũmu Ᵽriscilaᵽitiyika torã natuika. Ᵽablo ᵽuri marĩwa'ritirã, judíorãkare rẽrĩriwi'iarã eyatirã, “Jã'merũkika Tuᵽarãte wã'maekaki kime Jesús”, ãrĩwa'ri nare jaiẽjerĩ. ");
INSERT INTO tnc_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Matikuriji naka kimarika judíotatarãte yaᵽakoᵽeka. I'suᵽaka simako'omakaja Ᵽablo ᵽuri yaᵽaberikaki. ");
INSERT INTO tnc_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Suᵽa imarĩ ikuᵽaka nare kimajarobojaeka toᵽi o'yaokaro'si: —Ĩ'rãrĩmi Tuᵽarãte yaᵽarãkareka, mijare ĩarĩ yi'tarãñu ate,— nare kẽrĩka. I'sia be'erõ'õ waᵽuruᵽi Éfesowejeaᵽi ke'rika. ");
INSERT INTO tnc_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Cesarea ᵽaᵽitakarã eyatirã Jerusalénkarã Jesúre ã'mitiriᵽẽaekarã ᵽõ'irã Ᵽablote wi'ituriwa'rika. Naka imatirã Antioquíarã ke'rika ate. ");
INSERT INTO tnc_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Torã kimataᵽaeka be'erõ'õ ke'riũ'mueka ate. Galaciaka'iarã imatirã, toᵽi Frigiaka'iarãoka keyaeka. I'sia ka'iareka Jesúre ã'mitiriᵽẽairã imaekarãte Jesúrika bojariroka kiwãrõtaᵽaeka. I'suᵽaka kiwãrõmaka ã'mitiriwa'ri, jiibaji Jesúre yi'riwa'ri okajãjia najarika. ");
INSERT INTO tnc_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","I'sia ᵽoto ĩ'rĩka judíotataki Aᵽolos wãmeiki Éfesorã eyaekaki. Alejandríawejeakaki kimaeka. Ᵽo'imajare ĩaika wãjitãji jia jaiwãrũiki kimaeka. Suᵽabatirã Tuᵽarã majaroᵽũñu o'oeka jia kiõrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","“Jesúre yaᵽaika uᵽakaja maimajĩñu”, aᵽerãte wãrõmaka, jia ã'mitiriᵽẽaekaki kimako'omakaja Juanre ruᵽuko'a ᵽo'imajare jũjekakaka takaja õñuka kimaeka ruᵽu. Tẽrĩtaka Jesús majaroka õrĩberikoᵽeriᵽotojo kiõrĩkarõ'õjĩrã kireka wãjiaja okajããbaraka jĩjimakaᵽi ᵽo'imajare kibojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ĩ'rãrĩmi judíorãkare rẽrĩriwi'iarã, dakoa kĩkirimarĩaja jia ᵽo'imajaka kijaika. Aquila kirũmu Ᵽriscilaᵽitiyika kijaimaka ã'mitirikarã. Kijaika be'erõ'õ kika jaiokaro'si aᵽeᵽañarõ'õrã kire ne'ewa'rika. Jesúrika jia kiõrĩᵽũawãrũberikakaka jia kire nabojawaᵽu'ataeka. ");
INSERT INTO tnc_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","I'sia be'erõ'õ Acayaka'iakarãre Jesúrika bojariroka bojarĩ ke'ririyaᵽaeka. “Jia sime. Me'ᵽe”, narĩka Éfesokarã Jesúre ã'mitiriᵽẽaekarã. Suᵽa imarĩ “Aᵽolore jia mija e'etoᵽe”, ãrĩwa'ri ᵽaᵽera no'oeka Acayaka'iakarãro'si. Torã eyatirã jia nare kijeyobaaeka. “Jesúre mija yi'ᵽe”, Tuᵽarãte ãrĩkarã nimaeka. ");
INSERT INTO tnc_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ᵽo'imaja wãjitãji, Tuᵽarã majaroᵽũñu o'oekakaka bojabaraka, —Jã'merũkika Tuᵽarãte wã'maekaki kime,— ãrĩwa'ri judíotatarãre kiwãrõeka. I'suᵽaka jiitaka nare kibojamaka, “I'suᵽakamarĩa sime”, judíotatarãte ãrĩwãrũberika. ");
INSERT INTO tnc_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Aᵽolore Corintowejearã imañujuju, ᵽusi watoᵽekarã imaeka ka'ia o'riwa'ritirã Éfesowejearã Ᵽablote eyaeka. Torã eyatirã Jesúre ã'mitiriᵽẽaekarã ĩ'rãrimarãre kĩatõᵽoeka. ");
INSERT INTO tnc_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Suᵽa imarĩ ikuᵽaka nare kijẽrĩaeka: —Jesúre mija ã'mitiriᵽẽaraᵽaka ᵽoto ¿yaje Esᵽíritu Santore mijare ña'rĩjãiraᵽe?— nare kẽrĩka. I'suᵽaka kẽᵽakã'ã ikuᵽaka kire nayi'rika: —“Esᵽíritu Santore ima”, maki yijare bojaberaᵽaki,— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Suᵽa imarĩ Ᵽablote nare jẽrĩaeka: —¿Makire yi'riwa'ri ruᵽuko'a mija jũjerũjeraᵽe?— nare kẽrĩka. —Juanre wãrõeka uᵽakaja ruᵽuko'a yijare najũjeraᵽe,— narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","I'suᵽaka naᵽakã'ã ikuᵽaka Ᵽablote nare ãrĩka: —Ᵽo'imaja ba'iaja nabaaika ja'ataekarãre ruᵽuko'a Juanre jũjeka. Suᵽabatirã ikuᵽaka Juanre nare bojaeka: “Yibe'erõ'õ etarũkikate mija yi'ririjaᵽe”, ãrĩwa'ri kiwãrõeka. I'suᵽaka kẽrĩkakiji kime Jesús,— Ᵽablote nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","I'suᵽaka ã'mitiritirã, naruᵽuko'a najũjerũjeka “Maiᵽamaki Jesúre yi'yurã yija ime”, ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Suᵽabatirã kiᵽitaka Ᵽablote naᵽo'iarã ja'aᵽeaeka ᵽoto Esᵽíritu Santore nare ña'rĩjãika. I'suᵽaka simamaka norĩbeyua imakoᵽeka oka najaika. Suᵽabatirã Tuᵽarãte nare õrĩrũjeka nabojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ĩ'ᵽoũ'ᵽuarãe'earirakamaki rõ'õjĩrã nimaeka. ");
INSERT INTO tnc_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Maekarakamaki aiya jẽrĩtarirĩmi rakaka judíorãkare rẽrĩriwi'iarã nare kibojaeka na'mitiriᵽẽaokaro'si ᵽo'imajare jaiẽjeriyaᵽaiki Ᵽablote imaeka. “Ikuᵽaka Jesúre yi'yurãte jã'mebaraka Tuᵽarãte nare imaruᵽutarãñu”, ãrĩwa'ri kĩkirimarĩaja nare kibojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","I'suᵽaka simako'omakaja ĩ'rãrimarã kijaika ã'mitiriᵽẽaberikarã, aᵽekurioka sã'mitiririka yaᵽaberikarã ate. Ᵽo'imaja wãjitãji Jesúre ᵽo'imajare tããika majaroka ba'iaja najaika. Suᵽa imarĩ nare a'ritaᵽatirã Jesúre ã'mitiriᵽẽaekarãte kika ke'ewa'rika, Tirano wãmeiki wãrõriwi'iarã. Torã ĩ'rãrĩmi jariwa'ririmarĩaja nare kiwãrõroyika. ");
INSERT INTO tnc_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Torã ĩ'ᵽakuri wejejẽ'rãka wãrõbaraka kimaeka. Suᵽa imarĩ Asia wãmeika ka'iakarã, judíotatarã, judíotatamarĩrã imaekarãoka maiᵽamaki Jesúrika bojariroka ã'mitiriᵽataekarã. ");
INSERT INTO tnc_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ᵽabloᵽi ãrĩwa'riji rĩkimakaja maikoribeyua Tuᵽarãte beaeka. ");
INSERT INTO tnc_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Suᵽa imarĩ Ᵽablote rabeka mirãka sayaᵽãia, jariroakaoka ᵽo'imaja jĩñurã ᵽõ'irã ne'ewa'ᵽakã'ã narisirika o'riroyika. Suᵽabatirã Satanárika ima ña'rĩjãikarãteoka ᵽorikarã. ");
INSERT INTO tnc_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","14","I'sia ᵽoto ĩ'rãrimarã judíotatarã ᵽo'imajareka Satanárika ima ña'rĩjãika imaekarãte naᵽoatataᵽaeka. Ᵽablote ĩaji'awa'ri, “ ‘Jesús, Ᵽablote kireka bojaiki wãmeaᵽi nareka mija ᵽoᵽe’, marĩũ'mukoyeye'e”, narĩka. I'suᵽaka baairã uᵽakajaoka Esceva, kurarãka ĩᵽamaki makarãte baataᵽaeka. Ĩ'ᵽotẽñarirakamaki nimaeka. ");
INSERT INTO tnc_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ĩ'rãrĩmi i'suᵽaka narĩko'omakaja, ikuᵽaka Satanárika ima nare yi'rika: —Jesúre ñoñu, suᵽabatirã Ᵽabloteoka yijẽrãko'ayu. Mijare ᵽuri ñiawãrũbeyu. ¿Marã je'e mija?— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Suᵽabatirã Satanárika ima ña'rĩjãikite naᵽõ'irã teritaeka. Tẽrĩrikaja jãjiaᵽi ba'iaja nare kibaaeka. Suᵽabatirã najariroakaoka kibaiwa'ruika. Suᵽa imarĩ riwejuᵽaraka wi'iaᵽi naru'riwa'rika. ");
INSERT INTO tnc_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Éfesowejeakarã nimauᵽatiji, judíotatarã suᵽabatirã judíotatamarĩrãoka i'sia majaroka ã'mitiriᵽataekarã. Sã'mitiritirã nakĩkika. “Tẽrĩritaki kime Jesús”, ãrĩwa'ri rĩkimarã maiᵽamaki Jesúre jiyiᵽuᵽaka õrĩkarã mae. ");
INSERT INTO tnc_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","I'sia majaroka ã'mitiriwa'ri ba'iaja nabaaika rĩkimarãja Jesúre ã'mitiriᵽẽaekarãte bojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Suᵽabatirã ikuᵽaka ye'okirãre baaeka ĩ'rãrimarã ye'oroka koririmajare: Ye'orokakaka bojaika naᵽaᵽera, ᵽo'imaja wãjitãji e'ewa'ritirã najoeka. I'sia ᵽaᵽera najoeriataeka cincuenta mil rakato ᵽlata rõ'õjĩrã waᵽajã'rĩa ririka. ");
INSERT INTO tnc_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","I'suᵽaka simamaka maiᵽamaki Jesús majaroka ĩ'rãkõ'rĩmatomarĩa saᵽibimaka, rĩkimarãja Jesúre na'mitiriᵽẽaeka. ");
INSERT INTO tnc_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","I'suᵽaka so'rika be'erõ'õ Jerusalénrã ᵽe'ririka Ᵽablote ᵽuᵽajoaeka. “Macedoniaka'ia, suᵽabatirã Acayaka'ia yo'riwa'rirãñu. Jerusalénrã ñimarãka be'erõ'õ, Romawejearã a'ririka ima yiro'si”, kẽrĩᵽuᵽajoaeka. ");
INSERT INTO tnc_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","I'suᵽaka ãrĩᵽuᵽajoatirã Timoteo suᵽabatirã Erastoka kire jeyobaarimajare kiruᵽu kiᵽũataeka Macedoniaka'iarã. Iki ᵽuri Asiaka'iarã matikuriji kituika ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ᵽablote Éfesorã imaeka ᵽoto, “Jesús ĩ'rĩkaja imaki ᵽo'imajare tããrimaji”, ãrĩwa'ri ᵽo'imajare yaᵽabeᵽakã'ã jimarĩa oka naᵽo'ijiaeka i'sia wejearã. ");
INSERT INTO tnc_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Demetrio wãmeiki kimaeka i'sia oka bitamataũ'muekaki. Artemisare najiyiᵽuᵽayeerũkiwi'i uᵽaka ĩoikarĩjaka ᵽlatakaka baarimaji kimaeka. Aᵽerãoka kiuᵽaka baarimaja imarĩ, aᵽerãte sĩjibaraka rĩkimakaja niñerũ natõᵽoroyika. ");
INSERT INTO tnc_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Suᵽa imarĩ kire jeyobaarimajare, suᵽabatirã nuᵽakajaoka ba'iraberimajareoka kirẽrãtaeka. Suᵽabatirã ikuᵽaka nare kẽrĩka: —Maa, ika ba'irabeirã ᵽuri, rĩkimaka niñerũ tõᵽoirã maime. ");
INSERT INTO tnc_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","¿Ᵽablote ᵽo'imajare bojaika ã'mitirikoribeyurã mija bai? “Mija õñu uᵽakaja baatirã mija jiyiᵽuᵽayeeika, jiyiᵽuᵽayeerũkimarĩa sime”, kẽñu. Kijaika ã'mitiritirã rĩkimarãja ᵽo'imajare kire ã'mitiriᵽẽayu. Éfeso wejeakarã takajamarĩa kire ã'mitiriᵽẽairã. Ritaja Asia ka'iarã imarã kire ã'mitiriᵽẽairã oyiaja nime. ");
INSERT INTO tnc_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ba'iaja maro'si simarãñu. Suᵽa imarĩ mabaaᵽo'ijiaika ᵽo'imajare waruaribesarãñu. Suᵽa simamaka sawaᵽa matõᵽowãrũbesarãñu. Suᵽabatirã Artemisare jiyiᵽuᵽayeeriwi'iarã ᵽo'imajare a'ribesarãñu. Ritaja Asiaka'iarã, suᵽabatirã ritatojo wejeareka Artemisare jiyiᵽuᵽaka õñurã. I'suᵽaka simako'omakaja, Ᵽablote ã'mitiriᵽẽawa'ri “Imatiyaikamarĩko Artemisare ime”, ᵽo'imajare ãrĩrãñu,— Demetriore nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","I'suᵽaka kẽᵽakã'ã ã'mitiritirã, jimarĩa naboebarika. Suᵽabatirã ikuᵽaka ãᵽaraka nakasereka: —¡Éfesokarãre jiyiᵽuᵽayeerijayuko, Artemisa jiitako koime!— narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Nakasereka ã'mitiritirã, rĩkimarã ᵽo'imajare naᵽõ'irã a'rika. Ĩ'rãoka boebaritirã, akaserekarã. Suᵽa imarĩ ritaja wejeareka oka ᵽo'ijirika. I'suᵽaka simamaka Gayo, Aristarco Ᵽabloka jeyoariwa'rikarãte nañi'aeka. Macedoniakarã nimaeka. Ᵽo'imajare rẽrĩriwi'iarã nare ne'ewa'rika. ");
INSERT INTO tnc_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Kijeyomarãre jaijeyobaarĩ torã Ᵽablote kãkariyaᵽakoᵽeka. Kãkarika kiyaᵽamaka ĩatirã, “Mikãka'si”, Jesúre ã'mitiriᵽẽaekarãte kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ĩ'rãrimarã i'sia ka'ia ĩᵽarimarãre torã imaeka. Ᵽablo jeyomarã imarĩ, majaroka kiro'si ᵽũataekarã: “Naka ĩ'rãtiji baabekaja”, ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Rẽrĩrũkikõ'rĩmatorã rukubaka nakasereka. Aᵽeuᵽaka, aᵽeuᵽaka nakaseremomeka. Ĩ'rĩka uᵽaka ᵽuᵽajoaberiwa'ri rukubaka ᵽuᵽajoabaraka nimaeka. “¿Dakoa baaerã yija rẽrĩko'o?”, narĩwãrũberika. ");
INSERT INTO tnc_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Judíotataki naka imaekaki Alejandrore ᵽo'imaja wãjitãji naro'si kire jairũjekarã judíorãka. Torã rẽrĩtirã imaekarãte jaiokaro'si, Alejandrote kiᵽitaka mi'mataeka “Mija jaia'si ruᵽu”, ãrĩwa'ri. I'suᵽaka kibaako'omakaja nokata'riberika. “Dakoa oka imabeyua judíorãkaro'si”, ãrĩwa'ri nare kibojaerã baakoᵽeka. ");
INSERT INTO tnc_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Judíotataki kimaeka õrĩwa'ri judíorãkamarĩrãte tẽrĩwa'ribaji akasereka, —¡Éfesokarãre jiyiᵽuᵽayeerijayuko, Artemisa jiitako koime!— Ĩ'ᵽakuri aiyajẽrãrõ'õjĩrã i'suᵽaka ĩ'rĩka uᵽakaja akaserebaraka nimaeka. ");
INSERT INTO tnc_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ĩ'rĩka tokaki imaruᵽutarimaji ᵽo'imajare okata'rirũjekaki, suᵽabatirã ikuᵽaka nare kẽrĩka: —Mija ã'mitiᵽe Éfeso wejeareka imarã. Majiyiᵽuᵽayeeiko Artemisa wi'ia ĩarĩrĩrimaja maime ika wejeareka imarã. Suᵽabatirã koᵽo'ijẽrãka ĩmiᵽi ña'rĩka maiarĩrĩrijayu. “I'suᵽaka imarã nime”, ritaja ᵽo'imajare ãrĩwãrũᵽatayu mareka. ");
INSERT INTO tnc_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Nirã ᵽo'imaja “Ᵽakirika sime”, ãrĩbeyurã. Suᵽa imarĩ mija jo'ria'si, i'tojĩrãja samija ja'atabe. Ba'iaja mija baa'si, jia mija ᵽuᵽajoabe. ");
INSERT INTO tnc_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ĩrã ĩmirĩja mija e'era'airã majiyiᵽuᵽayeeiko Artemisarika karee'ebeyurã. Suᵽabatirã ba'iaja koreka jaibeyurã nime. ");
INSERT INTO tnc_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Demetriore kika ba'irabeirãᵽitiyika aᵽerãte nare okabaajĩkareka, niᵽarimarã ᵽõ'irã oka jierĩ nare e'ewa'ritirã jia simajĩñu. Oka naro'si imajĩkareka, ĩᵽarimarãre nabojajĩñu. Ĩᵽarimarã, jã'merimaja nime oka jierimaja. ");
INSERT INTO tnc_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Aᵽea oka bojarika mija yaᵽajĩka, Romakarãre jã'meka ãñu uᵽakaja ĩᵽarimarãre rẽrĩrãka ᵽoto nawãjitãji mija bojajĩkareka jia simajĩñu. ");
INSERT INTO tnc_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Mia, ¿marãkã'ã Romatatarã ĩᵽarimarãte ᵽuᵽajoarãñu ruku i'suᵽaka ᵽo'imajare oka ᵽo'ijiamaka? Ikuᵽaka naᵽuᵽajoarãñu je'e aᵽeyari: “Mare boebariwa'ri ĩ'rãᵽẽ'rõtorãja mare nabaariyaᵽayu Éfesokarã”, narĩᵽuᵽajoarãñu je'e. I'suᵽaka simamaka werika maro'si simajĩñu. Suᵽa imarĩ “¿Marãkã'ã oka imamaka, i'suᵽaka ᵽiᵽebaraka mija ime?”, Romatatarãte ãrĩrãkareka, marãkã'ã nare yi'riwãrũberijĩka maime,— torã imaruᵽutarimajite ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Sabe'erõ'õ “I'tojĩrãja simarũ”, ãrĩtirã nare kiᵽe'rirũjeka. ");
INSERT INTO tnc_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","I'suᵽaka oka imaeka be'erõ'õ Jesúre ã'mitiriᵽẽaekarãte Ᵽablote akaeka. Ke'rirã baaeka ruᵽu “Jesúre yi'ririjariwa'ri jia mija imabe”, ãrĩwa'ri naka kijaika. I'suᵽaka ãrĩtirã, nare kimajaroka kibojaeka a'yaokaro'si. Suᵽabatirã Macedoniaka'iarã ke'rika. ");
INSERT INTO tnc_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Macedoniaka'iarã a'ririjaᵽaraka ĩ'rãweje uᵽakaja Jesúre ã'mitiriᵽẽaekarã ᵽõ'irã kituririjarika. Naᵽõ'irã eyatirã “Jia Jesúre ã'mitiriᵽẽabaraka okajãjia mija imabe”, nare kẽrĩka. I'sia be'erõ'õ Greciaka'iarã keyaeka. ");
INSERT INTO tnc_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Maekarakamaki aiya torã kimaeka be'erõ'õ Siriaka'iarã waᵽuruᵽi a'rirã kibaaeka. I'suᵽaka simako'omakaja judíotatarãte kire jããerã nari'kaika majaroka kiã'mitirika. Suᵽa imarĩ “Yi'taraᵽarõ'õrã Macedoniaka'iarã yiᵽe'riwa'rirãñu bo'iᵽi”, Ᵽablote ãrĩᵽuᵽajoaeka. ");
INSERT INTO tnc_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Kika jeyoariwa'raᵽarã ikarakamaki yija imaraᵽe: Sóᵽater Bereakaki Ᵽirro maki, Segundo suᵽabatirã Aristarco, Tesalónicawejeakarã, Gayo Derbewejeakaki, Timoteo suᵽabatirã Tíquico, Trófimo Asiaka'iakarã, suᵽabatirã yi'i Lucas. I'siarakamarã Ᵽabloka yija jeyoariwa'raᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Filiᵽoswejea eyatirã, yijaka imaraᵽarãte a'riweiraᵽe Tróadewejearã yijare ta'arĩ. ");
INSERT INTO tnc_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ᵽan levadura rukebekaja ba'aribayarã yija imaraᵽaka be'erõ'õ Filiᵽosᵽi yija a'raᵽe waᵽuruᵽi. Ĩ'rãᵽitarakarĩmi be'erõ'õ Tróadewejearã yija eyaraᵽe. Yija ruᵽu a'raᵽarã, yija jeyomarãre torã yija eyaraᵽe. Torã ĩ'ᵽotẽñarirakarĩmi yija imaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ba'irabeũ'murirĩmi yija rẽrãᵽe Jesúre yi'yurãᵽitiyika. Maro'si Jesúre reyaeka ᵽuᵽajoabaraka kijã'meka uᵽakaja ᵽan ᵽibaba'aerã yija rẽrãᵽe. Yija ba'aerã baaraᵽaka ruᵽu Ᵽablote yijare bojaraᵽe. Aᵽerĩmi ke'rirã baaraᵽaka simamaka yijare kiwãrõyuju ñami ñe'metãji seyaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","I'sia wi'ia maekarakakuku yuraika ima wi'ireka, ᵽiyikukurõ'õrã rẽrĩtirã yija imaraᵽe. Rĩkimakaja yaaboaika imaraᵽaka i'sia kurarakarã. ");
INSERT INTO tnc_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Suᵽa imarĩ ĩ'rĩka bikirimaji Eutico wãmeiki ĩmirã kurarakaᵽi yoirũkia koᵽereka imaraᵽarõ'õrã ruᵽaraᵽaki. Ñoaka Ᵽablote jaimaka, koᵽakaja õõmaka bikirimajite riaraᵽaka. Koᵽakaja kãrĩtiyawa'ri kiña'rãᵽe mae. Ᵽoriwa'ritirã kire yija kõae'ekoᵽeraᵽe. Koᵽakaja reyaekaki kimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Suᵽa imarĩ ruiwa'ritirã, kimajakarã eyaᵽañaritirã Ᵽablote kire wã'wojĩ'araᵽe. Suᵽabatirã ikuᵽaka yijare kẽrãᵽe: —Mija ᵽuᵽata'si. Õñia jariᵽe'yuka kime,— yijare kẽrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","I'sia be'erõ'õ Ᵽabloᵽitiyika yija mirĩwa'raᵽe ate. Torã mirĩeyatirã ᵽan kiᵽibaraᵽe. Yija ba'araᵽaka be'erõ'õ jairĩji Ᵽablote wãrãᵽe. I'sia be'erõ'õ Asowejearã turitaᵽarĩ ke'raᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Jia jãjika bikirimajite jaᵽakã'ã, kiwi'iarã ᵽo'imajare kire e'ewa'raᵽe. I'suᵽaka kimamaka jia jĩjimaka najaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ᵽablote ãrãᵽaka uᵽakaja waᵽuruᵽi Asowejearã yija a'raᵽe. Toᵽi waᵽuruᵽi a'ritirã kire yija ta'araᵽe, ma'aᵽi ke'raᵽaka simamaka. ");
INSERT INTO tnc_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Asorã keyaraᵽaka ᵽoto waᵽuruᵽi kire yija jããtoraᵽe. Kire jããtoritirã Mitilene wãmeika wejearã yija a'raᵽe mae. ");
INSERT INTO tnc_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Aᵽerĩmi toᵽi yija a'raᵽaka be'erõ'õ Quío wãmeika jũmurika yija o'raᵽe. Aᵽerĩmi Samos wãmeika jũmurikarã yija eyaraᵽe. Toᵽi a'ritirã aᵽerĩmi Miletowejearã yija eyaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","“Asiaka'iarã Jesúre ã'mitiriᵽẽairã ᵽõ'irã ya'rijĩkareka yiba'ejĩñu”, Ᵽablote ãᵽakã'ã ã'mitiriwa'ri, Éfesowejea wãjiaja yija o'ritaᵽawa'raᵽe. “Jerusalén wejearã Ᵽentecostés baya ĩaokaro'si wãrũaja ma'rijĩkareka jia simajĩñu”, ãrĩᵽuᵽajoawa'ri, “Jajuaja ma'riye'e”, Ᵽablote yijare ãrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Miletorã imatirã, Éfesowejearã Jesúre ã'mitiriᵽẽairãte imaruᵽutarimajare Ᵽablote oka ᵽũataraᵽe: “Mija i'tabe õ'õrã. Éfesorã a'riberijĩka ñime”, ãrĩwa'ri nare kibojaᵽũaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Suᵽa imarĩ yija ᵽõ'irã neyaraᵽaka ᵽoto ikuᵽaka Ᵽablote nare ãrãᵽe: —Mamarĩ Asiaka'iarã eyatirã jia mijaka ñimaroyiraᵽaka mija õñu. ");
INSERT INTO tnc_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mijaka ñimaraᵽaka ᵽoto Maiᵽamakiro'si ba'irabeĩjibaraka, “Mija tẽrĩwa'ribaji õñuka ñime”, ãrĩberaᵽaki yi'i. Suᵽabatirãoka ᵽo'imajare Jesúre ã'mitiriᵽẽabeyua ĩawa'ri yoraᵽe. Suᵽabatirã judíotatarãte ba'iaja baaokaro'si yire nari'kamaka ba'iaja yijũaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Jesúrika bojariroka mijare yibojaraᵽaka ᵽoto, dakoa jia bojarika mijaro'si ma'rãᵽããberaᵽaki yi'i. “Kirika bojariroka ã'mitiritirã jia nimarũ”, ãrĩwa'ri mijare sayibojaᵽataraᵽe. Rĩkimarã wãjitãji, suᵽabatirã mija wi'iarãoka mijare sayibojaroyiraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","“Ba'iaja mija baaika ᵽuᵽajoariwa'ri samija ja'atabe. I'suᵽaka Tuᵽarãte yi'ririka yaᵽawa'ri maiᵽamaki Jesucristore mija ã'mitiriᵽẽabe”, ãrĩwa'ri judíotatarã suᵽabatirã judíotatamarĩrã imarãteoka yibojaroyiraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Esᵽíritu Santore yire jã'meika uᵽakaja maekaka Jerusalénrã ya'rirã baayu. Torã yire o'rirũkia õrĩbeyuka yi'i. ");
INSERT INTO tnc_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ikatakaja mijare yibojawãrũyu. Ritaja wejearã ya'ririjayurõ'õrã ikuᵽaka Tuᵽarãro'si bojaĩjirimajare yire bojayu Esᵽíritu Santore nare sõrĩrũjemaka: “Wẽkomaka imariwi'iarã mire natarãñu. Suᵽabatirã ba'iaja mijũarãñu”, yire nañu. ");
INSERT INTO tnc_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Maiᵽamakiro'si yiba'iraberũkia yire kija'ataeka jia simauᵽatiji yibaawearãka be'erõ'õ yire najããjĩkareka marã imabeyua. “Ᵽo'imajare wayuĩawa'ri Kimakire Tuᵽarãte reyarũjeka mare tããokaro'si”, ãrĩwa'ri ᵽo'imajare yibojaerã maiᵽamaki Jesúre yire ᵽũataeka. ");
INSERT INTO tnc_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Kire ã'mitiriᵽẽairãte Tuᵽarãte jia jã'merãñu”, ãrĩwa'ri ritaja mijare yibojaraᵽe. Mae ᵽuri “Aᵽekurioka yire niabesarãñu”, mijareka ñarĩᵽuᵽajoayu. ");
INSERT INTO tnc_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","Ritaja Tuᵽarãte ᵽo'imajare bojariyaᵽaraᵽaka uᵽakaja mijare yibojaraᵽe, kũᵽajĩ ma'rãᵽããbekaja. Suᵽa imarĩ ika mijare yibojayu: Ĩ'rĩka mijakaki Tuᵽarã ᵽõ'irã eyabesarãkareka, kireje oka imarãka, yiremarĩa. ");
INSERT INTO tnc_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Suᵽa imarĩ rakajekaja mija õñu uᵽakaja jia mija ᵽuᵽajoabe, Jesúre yaᵽaika uᵽakaja mija baarijayaokaro'si. I'suᵽakajaoka Éfesowejearã ᵽe'rieyatirã, Esᵽíritu Santore mijare jã'meika uᵽakaja jia Jesúre ã'mitiriᵽẽairãte mija ĩarĩᵽe. Maiᵽamaki Jesúre maro'si riwejurubaraka reyaekaᵽi ãrĩwa'riji, Tuᵽarãrirã maime. Suᵽa simamaka jia nare mija imaruᵽutabe, oveja ĩarĩrĩrimajare ĩarĩñu uᵽaka. ");
INSERT INTO tnc_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Yiᵽuᵽajoaikareka, ya'ritaᵽarãka be'erõ'õ aᵽerã, ᵽakirimajaroka bojarimajare etarãñu. Yaia oveja saba'ariataika uᵽaka Jesúre ã'mitiriᵽẽairãte ᵽakirimajaroka nawãrõrãñu, Jesúre nayi'ririja'atarũ ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Mija watoᵽeka ĩ'rãrimarã imarã ᵽariji ᵽakirimajaroka Jesúre yi'yurãte wãrõrãñurã. “Yija ᵽuᵽajoaika uᵽaka naᵽuᵽajoarũ naro'sioka”, ãrĩwa'ri suᵽa nabaarãñu. ");
INSERT INTO tnc_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Suᵽa imarĩ rakajekaja mija imabe Jesúrika bojariroka imatiyaika mija ã'mitiriᵽẽarija'atakoreka. Maekarakakuri wejejẽ'rãka, ñami, ĩmioka mijare yiwãrõraᵽaka mija õrĩrijaᵽe. Ĩ'rãkurimarĩa oᵽaraka mijare yokajããroyiraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Yijeyomarã, mijaro'si Tuᵽarãka yijairã baayu, mijare kĩarĩñaokaro'si. “Mare wayuĩawa'ri ba'iaja mabaaika waᵽa, Tuᵽarãte ye'kariayu”, ãrĩwa'ri mija ᵽuᵽajoamaka, jiibaji kirika bojariroka mija ã'mitiriᵽẽaerã Tuᵽarãte mijare jeyobaarãñu. Suᵽa imarĩ “Yirirãte jia yibaarãñu”, kẽrĩka uᵽakaja Tuᵽarãte baarãñu. ");
INSERT INTO tnc_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Aᵽerã niñerũ, najariroakaoka oakiriberaᵽaki yi'i. ");
INSERT INTO tnc_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ikuᵽaka simaraᵽe: Ñoñu uᵽakaja ba'irabetirã ba'arika, jariroaka yitõᵽoraᵽe. Suᵽabatirã yika imaraᵽarãteoka yitõᵽoĩjiraᵽe. I'sia õñurã mija ime. ");
INSERT INTO tnc_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ritaja yiba'irabeka ĩaᵽatawa'ri, “Ᵽablote baaika uᵽaka, jia maba'irabejĩñu sawaᵽaᵽi wayuoka baairãte majeyobaaokaro'si”, mija ãrĩwãrũeka. Ikuᵽaka maiᵽamaki Jesúre bojaraᵽaka mija ye'kariria'si: “Se'etoyukate tẽrĩwa'ribaji jĩjimaka kime sĩjirimaji”, Jesúre ãrĩka,— Ᵽablote nare ãrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","I'suᵽaka Ᵽablote ãrãᵽaka be'erõ'õ naka ñukuruᵽatirã Tuᵽarãka kijairaᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Tuᵽarãka kijaiwearaᵽaka ᵽoto oᵽaraka kire nawã'ojĩ'araᵽe, suᵽabatirã kiye'tearã nu'suraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","“Aᵽekurioka yire ĩabesarãñurã mija mae”, Ᵽablote ãrĩka simamaka, jimarĩa ba'iaja naᵽuᵽaraᵽe. I'sia be'erõ'õ ᵽaᵽitakarã kire najeyoariwa'raᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Jesúre ã'mitiriᵽẽairãte a'ribojaweatirã waᵽururã yija jãiraᵽe. Suᵽabatirã wãjiaja Cos wãmeika jũmurikarã yija a'raᵽe. Aᵽerĩmi Rodas wãmeika jũmurikarã yija a'raᵽe. Toᵽi Ᵽátararã yija eyaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Suᵽa imarĩ marĩrũkirõ'õrã yija imaraᵽaka ᵽoto, “Feniciaka'iarã sa'rirã baayu ika waᵽuru”, naᵽakã'ã, i'sia waᵽuruᵽi yija a'raᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","A'ririjari Chiᵽre wãmeika jũmurika yija ĩao'raᵽe. Wejerĩrĩka ᵽẽ'rõtoᵽi yija o'raᵽe i'sia jũmurika. Siriaka'i wãjitãji yija a'ririjaraᵽe. Waᵽuruᵽi ne'ewa'raᵽaka ba'irĩjia Tirowejearã namaataerã torã yija ᵽããraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Torã Jesúre ã'mitiriᵽẽairãte ĩatõᵽotirã ĩ'ᵽotẽñarirakarĩmi naka yija imaraᵽe. “Jerusalénrã Ᵽablote ba'iaja jũarãñu”, ãrĩwa'ri Esᵽíritu Santore nare õrĩrũjemaka, “Jerusalénrã me'ria'si”, kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","I'suᵽaka narĩko'omakaja ĩ'ᵽotẽñarirakarĩmi be'erõ'õ a'rirã yija baaeka ate. Torã Jesúre ã'mitiriᵽẽairã imaraᵽarã, narõmia, namakarãoka yijaka wejeaᵽi jeyoariwa'ritirã ᵽaᵽitakarã eyaraᵽarã. Ᵽõ'sirõ'õrã eyatirã ĩ'rãkõ'rĩmatorãja ñukuruᵽatirã Tuᵽarãka yija jairaᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","I'sia be'erõ'õ nare yija majaroka yija bojaraᵽe a'yaokaro'si. I'suᵽaka baaweatirã waᵽururã yija jãiraᵽe. Ĩ'rã ᵽuri toᵽi ᵽe'raᵽarã. ");
INSERT INTO tnc_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tirowejeaᵽi a'ritirã Tolemaidawejearã yija eyaraᵽe. Torã eyatirã Jesúre ã'mitiriᵽẽairãte ĩatõᵽotirã “¿Yaje mija ime?”, nare yija ãrãᵽe. Suᵽabatirã ĩ'rãrĩmi naka yija imaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Aᵽerĩmi toᵽi a'ritirã Cesarea wãmeika wejearã yija eyaraᵽe. Torã eyatirã Jesúrika bojariroka bojataᵽarimaji Feliᵽe wi'iarã yija a'raᵽe. Iki imaekaki ĩ'ᵽotẽñarirakamarãkaki Jerusalénrã Jesúre ã'mitiriᵽẽairã aᵽóstolrãkare jeyobaarũkika najã'mekaki. ");
INSERT INTO tnc_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Botarakakorã makarõmiki kimaraᵽe. Tĩmiamarĩrã nimaraᵽe. Suᵽabatirã Tuᵽarãte nare õrĩrũjeikakaka aᵽerãte bojarimaja rõmijã nimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Torã ĩ'rãrĩmimarĩa yija imatiraᵽakarã, Judeaka'iaᵽi Tuᵽarãro'si bojaĩjirimaji, Agabo wãmeikite etaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Yija ᵽõ'irã eyatirã Ᵽablo wa'eyoka kiwareraᵽe. Saᵽi kiõñu uᵽakaja kiũ'ᵽua, kiᵽitaka kiᵽi'ᵽeraᵽe. Suᵽabatirã ikuᵽaka kibojaraᵽe: —“Jerusalénrã ikuᵽaka judíotatarãte ika wa'eyoba'iᵽite ᵽi'ᵽerãñu. Kire ᵽi'ᵽetirã judíotatamarĩrã imarãte kire nijirãñu”, ãrĩwa'ri Esᵽíritu Santore yire bojayu,— Agabote ãrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","I'suᵽaka kẽᵽakã'ã ã'mitiriwa'ri “Jerusalénrã me'ria'si”, ãrĩwa'ri Ᵽablote yija bojaraᵽe Cesareakarãᵽitiyika. ");
INSERT INTO tnc_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","I'suᵽaka yija ãrĩko'omakaja ikuᵽaka Ᵽablote yi'raᵽe: —Mija oria'si. Mija oᵽakã'ã ĩawa'ri, yirĩomayu. I'suᵽaka simako'omakaja yiᵽuᵽaka ᵽuri simauᵽakaja ima. Jerusalénrã yire naᵽi'ᵽerãka takamarĩa, yire jããrika nari'karãkareka, “Yire mija jãã'si”, ñarĩbesarãñu. Maiᵽamaki Jesúre jã'meka uᵽakaja baarimaji ñime,— Ᵽablote yijare ãrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Yija ãrãᵽaka uᵽaka kiyi'ribeᵽakã'ã, i'tojĩrãja kire yija jaiẽjerija'ataraᵽe. Suᵽabatirã ikuᵽaka kire yija ãrãᵽe: —Maiᵽamakire yaᵽaika uᵽakaja simarũ.— ");
INSERT INTO tnc_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","I'suᵽaka ãrĩweatirã yija ba'irĩjia jieweatirã Jerusalénrã yija a'raᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Cesareawejeakarã ĩ'rãrimaki Jesúre ã'mitiriᵽẽairãka yijaka jeyoariwa'raᵽarã. Ĩ'rĩka Mnasón wãmeiki wi'iarã yijare ne'ewa'raᵽe torã tuiokaro'si. Chiᵽrekaki mirãki kimaraᵽe. Ĩ'rãjẽ'rãmarĩa Jesúre ã'mitiriᵽẽatiki kimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Jerusalénrã yija eyaraᵽaka ᵽoto jia jĩjimakaᵽi Jesúre ã'mitiriᵽẽairãte yijare e'etoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Aᵽerĩmi bikitojo Santiago ᵽõ'irã wi'iturirĩ Ᵽabloka yija a'raᵽe. Nimauᵽatiji Jesúre ã'mitiriᵽẽairãte imaruᵽutarimaja imaᵽataraᵽarã Santiago ᵽõ'irã. ");
INSERT INTO tnc_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","“¿Yaje mija ime?”, ãrĩweatirã, “Judíotatamarĩrãte Jesúrika bojariroka yibojamaka, jimarĩ jia Tuᵽarãte baaraᵽe”, ãrĩwa'ri ritaja o'rikakaka Ᵽablote nare bojaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","I'sia ã'mitiritirã jĩjimaka imawa'ri, “Jiitaka baaiki kime Tuᵽarã”, narãᵽe. Suᵽabatirã ikuᵽaka Ᵽablote narãᵽe: —Yija jeyomaki, matatarã rĩkimarãja imarã Jesúre yi'yurã. Kire ã'mitiriᵽẽairã imariᵽotojo Moiséte jã'meka uᵽaka oyiaja mabaarijayu ruᵽu. I'sia miõñu. ");
INSERT INTO tnc_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Aᵽerã ᵽuri õ'õrã imarãte ikuᵽaka bojairã: “Judíotatamarĩrã ka'iarã Ᵽablote imataᵽaᵽoto ‘Moisés imaekakite jã'meroyika mayi'rija'atajĩñu’, ãrĩwa'ri judíorãka torã imarãte kibojayu. I'suᵽakajaoka ‘Mija makarã circuncisión baarika, suᵽabatirã matatarãte baarijariroyika yi'ririja'atarika sime’, kẽñu”, ĩ'rãrimarãte ãrĩrijayu,— Ᵽablote narãᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","—Metaika norĩrãñu. “Kireka ᵽo'imajare bojakoᵽeika majaroka ritamarĩa sime”, nañaokaro'si ¿marãkã'ã mibaarãñu? ");
INSERT INTO tnc_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ikuᵽaka mibaajĩkareka jia simajĩñu. Õ'õrã maka botarakamaki ĩmirĩja imarã, “Miaika wãjitãji ikuᵽaka yija baarãñu”, Tuᵽarãte ãrĩkarã nime. “Tuᵽarãte yija ãrĩka uᵽakaja, yija baaraᵽe”, ãrĩwa'ri, Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã naruᵽua wi'eᵽaterũjerĩ na'rirãñu. ");
INSERT INTO tnc_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Mi'ioka naka me'ᵽe. Ba'iaja nabaaikareka jũjerika yaᵽawa'ri judíotatarãre baaroyika uᵽaka naka mibaabe. Oveja joeĩjiokaro'si mijaro'si samiwaruaᵽe. Tuᵽarãro'si sajoeĩjitirã, kurarãkare mija ruᵽua mija wi'eᵽaterũjebe “Tuᵽarãte yija ãrĩka uᵽakaja, yija baaraᵽe”, ãrĩwa'ri. I'suᵽaka mibaamaka ĩawa'ri, “ ‘Moiséte jã'meroyika yi'ribeyuka Ᵽablote ime’, aᵽerãte ãñua ᵽuri ᵽakirika sime. Simauᵽakaja kiyi'yu”, matatarãte ãrĩrãñu. ");
INSERT INTO tnc_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Judíotatamarĩrã Jesúre ã'mitiriᵽẽairãte ᵽaᵽera yija ᵽũataraᵽe. Ikuᵽaka bojabaraka naro'si yija o'oraᵽe: “Ikatakaja mijare yija bojaᵽũayu: Waᵽuju imaja jẽrãka jiyiᵽuᵽaka õrĩwa'ri ri'ia naᵽããikakaka mija ba'a'si. Riweaoka mija ukua'si. I'suᵽakajaoka wa'iro'sia wãmua namokoru'ataeka ri'ia mija ba'a'si. Suᵽabatirã rõmikirã, tĩmiakirã, rõmimarĩrã, tĩmiamarĩrãoka ba'iaja baabekaja mija imabe”, ãrĩwa'ri yija o'oraᵽe,— Ᵽablote narãᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Suᵽa imarĩ aᵽerĩmi botarakamaki imaekarãte Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã Ᵽablote e'ewa'rika. Ba'iaja nabaaika najũjeroyika uᵽaka naka kibaaeka. I'suᵽaka baatirã, ikuᵽaka kurarãkare kibojaeka: “Ikarakarĩmi sajariwa'yu ruᵽu ba'iaja yija baaika yija jũjewearũkia. Ᵽiyirĩmi seyarãka ᵽoto Tuᵽarãro'si oveja mija joeĩjirika yija yaᵽayu, yija imarakamakiro'si”, nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ĩ'ᵽotẽñarirakarĩmi seyaerã baaeka ᵽoto Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã Ᵽablote imamaka, ĩ'rãrimarã Asiaka'iakarã judíotatarãte kire ĩatõᵽoeka. Jãjirokaᵽi ᵽo'imaja wãjitãji ba'iaja kireka akaserebaraka kire nañi'aeka. ");
INSERT INTO tnc_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ikuᵽaka kire nokabaaeka: —Yija tã'omaja, Israeltatarã, yijare mija jeyobaabe. Ĩ'ĩ ĩmirĩji imaki ba'iaja mare jaitaᵽarimaji. I'suᵽakajaoka “Moiséte jã'mekakaka mayi'rirũkimarĩa sime”, ãᵽaraka ᵽo'imajare kibojaᵽibayu. Suᵽabatirã ika Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'ia ba'iaja jaiyuyeiki kime. Judíotatamarĩrãte ᵽariji Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã ke'eetamaka ba'ia sakimarũjeyu Tuᵽarã ñakoareka,— ãrĩwa'ri aᵽerãte nabojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(I'sia ruᵽubaji ĩ'rãrirĩmi wejeñe'metãji Trófimo wãmeikiᵽitiyika Ᵽablote imamaka niaeka. Éfesowejeakaki kimaeka Trófimo. Suᵽa imarĩ, “Kika kime je'e”, ãrĩᵽuᵽajoakoᵽewa'ri “Judíotatamarĩkate Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã ke'ewa'yu”, narĩkoᵽeka). ");
INSERT INTO tnc_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã oka ᵽo'ijirika majaroka ã'mitiriwa'ri, i'sia wejeareka imaekarãte torã rĩrĩwa'rika. Ᵽablote ñi'atirã kire nayieᵽoaeka. I'sia wi'iaᵽi ᵽoritirã, simauᵽatiji koᵽereka natãteᵽataeka, torã oka ᵽo'ijirikoreka. ");
INSERT INTO tnc_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","I'suᵽaka kire jããerã nabaaeka ᵽoto, Jerusalénwejeareka imaekarãte oka ᵽo'ijiaeka majaroka Romakaki surararãka ĩᵽamakire ã'mitirika. ");
INSERT INTO tnc_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","I'sia majaroka ã'mitiritirã kisurararãkare, suᵽabatirã kirokajĩtekarã ĩᵽarimarã imaekarãteoka kiakaeka. Suᵽabatirã rĩrĩwa'ritirã rukubaka ᵽuᵽajoabaraka ᵽo'imajare boebarikarõ'õrã neyaeka. Surara ĩᵽamakire kisurararãkaᵽitiyika ketamaka ĩawa'ri, Ᵽablote naᵽajerija'ataeka. ");
INSERT INTO tnc_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Suᵽa imarĩ surara ĩᵽamaki Ᵽablote ñi'arũjekaki kisurararãkare. Kire ñi'atirã, ĩ'ᵽamiji ᵽerumijiaᵽi nare kire kiᵽi'ᵽerũjeka. Suᵽabatirã ᵽo'imajare kijẽrĩaeka: “¿Maki kime ĩ'ĩ? ¿Dakoa kibaako'a?”, kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Rakaka oyiaja ᵽuᵽajoawa'ri akasererikaᵽi najaika. Nakaseretaruᵽamaka ã'mitiriwãrũberiwa'ri, “I'suᵽaka oka kireka ime”, kẽrĩwãrũberika. Suᵽa imarĩ surararãka wi'iarã Ᵽablote ke'ewa'rirũjeka surara ĩᵽamaki. ");
INSERT INTO tnc_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","36","Surara wi'iarã kire ne'ewa'ᵽakã'ã ĩatirã rĩkimarãja ᵽo'imajare kibe'erõ'õ a'rika. “Kire mija jããᵽabe”, ãᵽaraka nakasererĩ'rĩka. Surara wi'ia mirĩrũkirõ'õrã neyaeka ᵽoto, jãjibaji boebariwa'ri okajãjia najarika. Suᵽa imarĩ ᵽo'imajare kire jãã'si ãrĩwa'ri Ᵽablote surararãkare e'emiawa'rika. ");
INSERT INTO tnc_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Surara wi'iarã kire ne'ekãkaerã baaeka ᵽoto, ikuᵽaka niᵽamakire Ᵽablote ãrĩka griego okaᵽi: —Mika jairika yiyaᵽayu,— kẽrĩka. I'sia ã'mitiritirã, —¿Yaje griego oka jaiki mime? ");
INSERT INTO tnc_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","“Bikitakamarĩa Egiᵽtokakite cuatro mil rakamaki ba'iaja baairãka jeyoariwa'ritirã ᵽo'imajamatorã kimaruᵽutaeka. Roma ĩᵽarimarãre ĩ'rãᵽẽ'rõtorãja kibaariyaᵽakoᵽeka. I'suᵽaka baaraᵽaki kime”, mireka ñarĩᵽuᵽajoako'o. I'suᵽaka yiᵽuᵽajoakoᵽeko'omakaja griego oka mijaikareka, Egiᵽtokakimarĩka mime,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","I'suᵽaka kẽᵽakã'ã ikuᵽaka Ᵽablote kire ãrĩka: —Jẽno'o aᵽika ñime. Judíotataki ñime yi'i ᵽuri. Tarso wãmeika wejeakaki ñime. Imatiyaiweje Ciliciaka'iarã sime. ¿Yaje ᵽo'imajaka yire mijairũjejĩñu?— Ᵽablote kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","I'suᵽaka kẽᵽakã'ã, —Naka mijaibe,— kire kẽrĩka. Suᵽa imarĩ mirĩrũkirõ'õrã rĩkamaritirã ᵽo'imajare wiriwirijayaokaro'si kiᵽitaka kimi'mataeka. Ᵽo'imajare okata'rika be'erõ'õ hebreo okaᵽi Ᵽablote jaika: ");
INSERT INTO tnc_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Yijeyomarã judíorãka, ᵽakiarimarãoka mija ã'mitiᵽe ruᵽu. “Dakoa oka kire imabeyua”, mija ãñaokaro'si yimajaroka mijare yibojaerã baayu ruᵽu,— Ᵽablote ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Nokaᵽi kijaimaka ã'mitiriwa'ri, wiriwiri najaritiyaeka. Ikuᵽaka Ᵽablote nare bojaeka: ");
INSERT INTO tnc_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","—Judíotatakiji ñime yiro'si oka. Cilicia ka'ia, Tarso wãmeika wejeareka ᵽo'ijirikaki ñime. Suᵽabatirã õ'õ Jerusalénrã yiᵽakiarika. Gamaliel wãmeikiᵽi ãrĩwa'riji ᵽaᵽera yiwãrũraᵽe. Mañekiarãte jã'mekakaka jia yiwãrũraᵽe. Maekaka Tuᵽarãte mija yi'yu uᵽakaja yi'ririka yiyaᵽaroyiraᵽe yiro'si oka. ");
INSERT INTO tnc_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","“Jia Tuᵽarãte yi'yuka ñime”, ãrĩwa'ri, Jesúre ã'mitiriᵽẽairãte ba'iaja jũaerã suᵽa yibaaraᵽe. Aᵽerikuri nare yijããrũjeraᵽe. Ĩmirĩja, rõmijãteoka ñi'awa'ritirã wẽkomaka imariwi'iarã nare yitarũjeraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Kurarãka ĩᵽamaki imatiyaiki suᵽabatirã ĩᵽarimarã imatiyarimajaoka “I'suᵽaka kibaaraᵽe”, yireka ãrĩwãrũirã. Ĩ'rãjaoka ᵽaᵽera yire baaĩjiraᵽarã, matã'omaja Damascowejeakarãre yibearũkia imakoᵽeraᵽaka. I'sia ᵽaᵽera e'etoritirã, so'oeka yire jã'meika uᵽakaja Jesúre ã'mitiriᵽẽairãte mo'arĩ ya'rikoᵽeraᵽe. Jerusalénrã nare e'era'atirã ĩᵽarimarãte wẽkomaka nare baarũjerã yibaakoᵽeraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","I'suᵽaka baarĩ ĩmi ñe'metãji ma'aᵽi ya'raᵽaka ᵽoto, Damascowejewã'tarã ñimaraᵽaka ᵽoto, ikuᵽarõ'õᵽiji wejeᵽemaᵽi jãjia yaaboaika yire yaaraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Suᵽa imarĩ ka'iarã yiña'rãᵽe mae. Suᵽabatirã ikuᵽaka yire sajaikoraᵽaka ña'mitiraᵽe: “Saulo, Saulo, ¿dako baaerã ba'iaja yire mibaarijayu?” ");
INSERT INTO tnc_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","I'sia ã'mitiriwa'ri ikuᵽaka yiyi'raᵽe: “¿Ñiᵽamaki, maki mime?”, ñarãᵽe. I'suᵽaka ñaᵽakã'ã ikuᵽaka kiyi'raᵽe: “Yi'iji ñime Jesús, Nazaretkaki. Ba'iaja mibaarijayuki ñime”, yire kẽrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","I'suᵽaka sayaaboamaka ĩatirã yika a'raᵽarãre ᵽuᵽataraᵽe. I'suᵽaka sayaaboamaka ĩatirã yika a'raᵽarãre ᵽuᵽataraᵽe. Ĩ'rã ᵽuri i'suᵽaka yaaboaraᵽaka ĩakoᵽeriᵽotojo yire jairaᵽaki oka na'mitiriberaᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","I'suᵽaka yire kijaimaka ã'mitiriwa'ri kire yijẽrĩaraᵽe: “¿Marãkã'ã yibaarika miyaᵽayu Ñiᵽamaki?”, ñarãᵽe. I'suᵽaka ñaᵽakã'ã ikuᵽaka yire kiyi'raᵽe: “Mi'mitirã Damascorã me'ᵽe. Torã ĩ'rĩkate mire bojarãñu ritaja mibaarũkia miro'si yija'ataeka”, yire kẽrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","I'sia yaaboaika ñiaraᵽaka ᵽoto yiñakoyaraᵽe. Suᵽa imarĩ yika a'raᵽarã Damascorã yire tĩtieyaraᵽarã. ");
INSERT INTO tnc_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Torã ĩ'rĩka Ananías wãmeikite imaraᵽe. Moisés imaekakite jã'mekakaka simauᵽakaja yi'riᵽataiki kimaraᵽe. Tokarã judíotatarã, “Jia baaiki kime”, ãrĩwa'ri kireka najairaᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","I'sia wejearã yeyaraᵽaka be'erõ'õ yiᵽõ'irã Ananíare etaraᵽe. Yiwã'tarã rĩkamaritirã ikuᵽaka yire kẽrãᵽe: “Yijeyomaki Saulo, miyoibe ate.” Ikuᵽarõ'õᵽiji kire ñiaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Suᵽa imarĩ ikuᵽaka yire kẽrãᵽe: “Tuᵽarã, mañekiarãte jiyiᵽuᵽayeeroyikakite wã'maiki mime kiyaᵽaika uᵽakaja mibaarũkia miõñaokaro'si. Suᵽabatirã kiᵽũataekaki, ba'iaja baakoribeyukate miaerã, suᵽabatirã kijaika mia'mitiyaokaro'si Tuᵽarãte miᵽõ'irã kire ᵽũataraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Jesús majaroka mibojataᵽarijarirãñu. Miaeka mirãka, mia'mitirikaoka ritaja ᵽo'imajare mibojataᵽarãñu. ");
INSERT INTO tnc_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Miba'ea'si. Jesúre ã'mitiriᵽẽatirã, ba'iaja mibaaika kijũjerã kire mijẽñebe. Suᵽabatirã ruᵽuko'a mijũjerũjebe”, yire kẽrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Ñoaᵽañaka Jerusalénrã imakoᵽeka yiᵽe'riwa'raᵽe. Torã ĩ'rãrĩmi Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã Tuᵽarãka jairĩ ya'raᵽe. Tuᵽarãka jaikõrĩ makãrãrũñuroka uᵽakaᵽi Maiᵽamakire jaimaka ñiaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Toᵽi ikuᵽaka yire kẽrãᵽe: “Ñojimarĩji Jerusalén wejeaᵽi me'ᵽe. Õ'õrã imarã ᵽo'imaja yimajaroka nare mibojakoᵽemaka ã'mitiriᵽẽabesarãñurã”, yire kẽrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","I'suᵽaka kẽᵽakã'ã ã'mitiritirã ikuᵽaka kire yiyi'raᵽe: “Maiᵽamaki, õ'õrã imarã ritaja yibaaeka mirãka õñurã. Mire ã'mitiriᵽẽabaraka judíorãkare rẽrĩriwi'iarã imarãte e'eᵽoatirã wẽkomaka imariwi'iarã nare yitaroyiraᵽe. Suᵽabatirã nare yiᵽajewã'imarĩroyiraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Mimajaroka bojarimaji Estebanre najããmaka yiyoirĩkamarãᵽe. Kire jããbaraka jariroaka nawarataraᵽaka ĩarĩrĩrimaji ñimaraᵽe. Suᵽa imarĩ Estebanre jããweatirã, ‘I'suᵽakaja kire mabaajĩka jia sime’, ñarĩᵽuᵽajoaraᵽe yiro'sioka”, Maiᵽamakire ñarãᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","I'suᵽaka ñarĩko'omakaja ikuᵽaka yire kiyi'raᵽe: “Me'ᵽe. Yoerã mire yiᵽũatayu judíotatamarĩrãte miwãrõkaro'si”, yire kẽrãᵽe,— ãrĩwa'ri ᵽo'imajare Ᵽablote bojaeka. ");
INSERT INTO tnc_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","I'suᵽaka judíotatamarĩrãreka kẽrĩka ᵽoto ᵽo'imajare kire ã'mitiritiyika. Ate boebariwa'ri akasererikaᵽi kire naᵽiᵽeka. —Kireyaᵽarũ. Õñia imaberijĩki kime,— narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ña'rĩyaarĩmarĩaja naᵽiᵽeka. Suᵽabatirã najariroaka ᵽemakato waratatirã ka'ia uyuakaka ĩmirã nabaremiaruika. “Boebaka yija ime”, ãrĩrika i'suᵽaka nabaaeka. ");
INSERT INTO tnc_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","I'suᵽaka nabaamaka ĩawa'ri, surara ĩᵽamaki kisurararãkare nawi'iarã Ᵽablote ke'ekãkawa'rirũjeka. “¿Dakoa oka imamaka, ᵽo'imajare mire ã'mijĩayu?”, ãrĩwa'ri, “Ᵽablote ajeaᵽi mija ᵽajebe”, surara ĩᵽamakire nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Kire ᵽajerã naᵽi'ᵽerĩkaweaeka ᵽoto ikuᵽaka Ᵽablote jaika tokaki ĩᵽamakire: —¿Ĩ'rĩka Romatatakite mija ᵽajejĩka jia simajĩñu ruku? ¿Ba'iaja yibaaika ĩakoribekaja yire mija ᵽajerã baayu bai?— Ᵽablote kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","I'suᵽaka kẽᵽakã'ã ã'mitiritirã, kĩᵽamaki ᵽõ'irã a'ritirã, ikuᵽaka kire kibojaeka: —Jia mirakajebe, i'suᵽaka mibaarũki ruᵽu. Ĩ'ĩ ĩmirĩji miᵽajerũjeiki Romatataki kime,— kẽrĩka surara ĩᵽamakire. ");
INSERT INTO tnc_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","I'suᵽaka kẽᵽakã'ã ã'mitiriwa'ri surara ĩᵽamakire ikuᵽaka Ᵽablote jẽrĩaeka: —¿Yaje rita sime Romatataki mima?— —Ikijioka ñime,— Ᵽablote ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","—Rĩkimaka yiwaᵽaĩjiraᵽe Romatataki imaokaro'si,— surara ĩᵽamakire kire ãrĩka. I'suᵽaka kẽᵽakã'ã, —Romatataki ᵽo'ijirikakiji ñime,— Ᵽablote ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Suᵽa imarĩ kire ᵽajerika yaᵽakoᵽekarã kĩkiwa'ri aᵽerõ'õrã kire na'ritaᵽawa'rika. “Ba'iaja Romatatakite yiᵽajerũjekoᵽeyu”, ãrĩwa'ri surararãka ĩᵽamakioka kĩkikaki. ");
INSERT INTO tnc_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","“¿Dakoa oka imamaka, ᵽo'imajare Ᵽablote ã'mijĩaeka?”, ãrĩwa'ri aᵽerĩmi, kurarãka ĩᵽamarã, judíotatarã ĩᵽarimarã imatiyaitataoka surararãka ĩᵽamakire rẽrãtaeka. Suᵽabatirã Ᵽablote ᵽerumijia kutetirã, nawãjitãji kire e'ewa'ritirã kire kija'arĩkaeka. ");
INSERT INTO tnc_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Judíotatarã ĩᵽamarãre ĩarĩkatirã ikuᵽaka Ᵽablote ãrĩka: —Yitã'omaja, õñia ñimatiyikuriji Tuᵽarãte yaᵽaika uᵽaka baarimaji ñime. Suᵽa imarĩ kiwãjitãji jajumarĩaja ñime,— Ᵽablote nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","I'sia ã'mitiritirã kurarãka ĩᵽamaki imatiyaiki, Ananías wãmeiki Ᵽablo ᵽõ'irã rĩkamarikarãte “Kirijea mija ᵽaaᵽe”, kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","I'suᵽaka nabaamaka ikuᵽaka Ᵽablote kire ãrĩka: —“Jia baaiki ñime”, ãñuka imariᵽotojo, ba'iaja mibaayu. Suᵽa imarĩ sawaᵽa ba'iaja mijũaerã Tuᵽarãte ba'iaja mire baarãñu. “Moiséte jã'meika yi'ribeyuka mime”, yireka merĩko'omakaja kijã'meika yi'ribekaja yire miᵽemaᵽaarũjeyu,— Ᵽablote ãrĩka kurarãka ĩᵽamaki imatiyaikire. ");
INSERT INTO tnc_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","I'suᵽaka kẽᵽakã'ã ã'mitiriwa'ri, torã imaekarãte ikuᵽaka Ᵽablote ãrĩka: —Tuᵽarãte wã'maekaki kurarãka ĩᵽamaki imatiyaikite ba'iaja mijaiyu.— ");
INSERT INTO tnc_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","I'suᵽaka naᵽakã'ã ã'mitiritirã, ikuᵽaka Ᵽablote ãrĩka: —Yitã'omaja, “Kurarãka ĩᵽamaki imatiyaiki kime je'e”, ñarĩwãrũbeyu. “Mija ĩᵽamakire jaiyuyebekaja”, ãrĩwa'ri Tuᵽarã majaroᵽũñu bojaika. “Ĩᵽamaki imatiyaiki kime”, ñarĩwãrũrikareka, kire yijaiyuyeberijããeka,— Ᵽablote ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Judíotatarã ĩᵽarimarã rakaka oyiaja ᵽuᵽajoairã nimaeka. Ĩ'rãrimarã saduceokaka ᵽuᵽajoaekarã, aᵽerã fariseokaka ᵽuᵽajoaekarã. I'sia õrĩwa'ri ikuᵽaka jãjirokaᵽi Ᵽablote jaika: —Yitã'omaja, fariseokaka ᵽuᵽajoaiki ñime yiro'sioka. Yirĩrãoka i'suᵽakaja ᵽuᵽajoairã imarã. “Reyakoᵽeriᵽotojo ᵽo'imajare õñia jariᵽe'rirãñu ate”, ãrĩᵽuᵽajoaiki ñime. I'suᵽaka ᵽuᵽajoaiki ñimamaka, mija wãjitãji “Oka kire ima”, ãrĩwa'ri i'suᵽaka yire mija jẽrĩayu,— Ᵽablote nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","I'suᵽaka kẽᵽakã'ã ã'mitiriwa'ri, saduceokaka ᵽuᵽajoairã okatotoũ'muekarã fariseokaka ᵽuᵽajoairãka, rakakaja ᵽuᵽajoaekarã imarĩ. ");
INSERT INTO tnc_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Ikuᵽaka nañu saduceokaka ᵽuᵽajoairã: “Reyairã ᵽo'imaja ate õñia jariᵽe'ribesarãñurã, ángelrãkaoka imabeyurã, suᵽabatirã Satanárika imaoka imabeyua”, narĩᵽuᵽajoayu. Fariseokaka ᵽuᵽajoairã ᵽuri, i'suᵽaka ãrĩᵽuᵽajoabeyurã). ");
INSERT INTO tnc_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Suᵽa imarĩ rakaka oyiaja ᵽuᵽajoairã imarĩ, jãjirokaᵽi nokatotoeka ruᵽu. Toᵽi mae Moiséte jã'meka wãrõrimaja mi'mirĩkaekarã jaiokaro'si. Fariseokaka ᵽuᵽajoairã nimaeka naro'sioka. —Dika ba'iaja baabeyuka kime ĩ'ĩ. Damascorã ke'raᵽaka ᵽoto ángelte kire jairaᵽe je'e aᵽeyari. “I'suᵽakamarĩa sime”, marĩberijĩñu,— ãrĩwa'ri najaibu'aeka. ");
INSERT INTO tnc_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Jimarĩa jãjirokaᵽi okatotobu'abaraka, boebaitaka nimamaka ĩawa'ri, “Ᵽablote ba'iaja baawã'imarĩtirã kire najããriatarãñu je'e”, surara ĩᵽamakire ãrĩᵽuᵽajoaeka. Suᵽa imarĩ kisurararãkare akatirã ikuᵽaka nare kijã'meka: “Ᵽablote nawatoᵽekaᵽi e'eᵽoatirã mija wi'iarã kire mija taᵽe ate”, nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","I'siñami Ᵽablo ᵽõ'irã maiᵽamaki Jesúre ᵽemakotowirika. Kiwã'tarã eyarĩkaritirã, ikuᵽaka Jesúre kire ãrĩka: —Okajãjia mimabe Ᵽablo. Jerusalénrã mima ᵽoto yimajaroka mibojaika uᵽakajaoka Romawejearã mimarãka ᵽoto mibojarãñu,— Ᵽablote kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Aᵽerĩmi ĩ'rãrimarã judíotatarã takaja kareaja rẽrĩtirã, “Ᵽablote majããjĩñu”, narĩᵽuᵽajoaeka. “Õñia kimarãkarõ'õjĩrã maba'abesarãñu, suᵽabatirã okoa mukubesarãñuoka. Kire majããbesarãkareka, Tuᵽarãte mare jããrũ”, natiyiaja narĩbu'aeka. ");
INSERT INTO tnc_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ĩ'rĩka uᵽakaja i'suᵽaka jaibu'abaraka imaekarã ĩ'ᵽarãᵽo'imajarakamarã tẽrĩwa'ribajirõ'õjĩrã nimaeka. ");
INSERT INTO tnc_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","I'sia be'erõ'õ kurarãka ĩᵽamarã, judíorãka ĩᵽarimarãka jairĩ na'rika. Naᵽõ'irã eyatirã ikuᵽaka narĩka: —Yija ĩ'rĩka uᵽaka ᵽuᵽajoawa'ri, “Ᵽablote õñia imarãkarõ'õjĩrã, ba'abekaja, okoa ukubekaja maimaye'e. Kire majããbesarãkareka, Tuᵽarãte mare jããrũ”, yija ãrĩko'o. ");
INSERT INTO tnc_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Mija, judíotatarã ĩᵽarimarã imatiyaitatarãoka ikuᵽaka mija baajĩkareka jia simajĩñu: Maekakaja surara ĩᵽamakire oka mija ᵽũatabe, waeroka bikitojo mija ᵽõ'irã Ᵽablote ke'era'arũ. “Yaje rita oka ᵽarea kire imarika yija õrĩriyaᵽayu. Suᵽa imarĩ õ'õrã Ᵽablote me'era'abe”, ãrĩᵽakitirã oka kire mija ᵽũatabe. I'suᵽaka mija ãrĩrãkareka õ'õrã Ᵽablote etabeyukajiji kire yija jããtorirãñu,— narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ᵽablo ᵽaka'imaki i'suᵽaka oka imamaka õrĩkaki. Suᵽa imarĩ i'sia oka Ᵽablote bojarĩ, surara wi'iarã kikãkaeka. ");
INSERT INTO tnc_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Torã eyatirã Ᵽablote kibojaeka. Suᵽa imarĩ torã imaekaki ĩ'rĩka surara ruᵽuko'amakite Ᵽablote akaeka. —Ĩ'ĩ bikirimajire miᵽamaki ᵽõ'irã me'ewa'ᵽe. Oka bojaerã kibaarijiyu,— Ᵽablote kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","I'suᵽaka kẽᵽakã'ã ã'mitiritirã surararãka ĩᵽamaki ᵽõ'irã kire ke'ewa'rika. Ikuᵽaka kĩᵽamakite kibojaeka: —Yija ĩarĩñuka Ᵽablo yire akatirã, “Ĩ'ĩre miᵽamaki ᵽõ'irã me'ewa'ᵽe”, kẽᵽakã'ã kire ye'era'ako'o. Mire oka bojarika kiyaᵽarijiyu,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","I'suᵽaka kẽᵽakã'ã ã'mitiriwa'ri, aᵽerõ'õ ᵽañakarã kire e'ewa'ritirã kire kijẽrĩaeka, —¿Dakoa yire bojarika miyaᵽayu?— kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Suᵽa imarĩ ikuᵽaka kire kibojaeka: —Judíotatarã ĩ'rĩka uᵽakaja ᵽuᵽajoawa'ri niᵽarimarã wãjitãji Ᵽablote mija e'ewa'yaokaro'si oka ᵽũatarãñurã. “Yaje rita oka kire imarika õrĩrika yija yaᵽayu”, narĩᵽakirãñu. ");
INSERT INTO tnc_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","I'suᵽaka mijare narĩkoᵽemaka miyi'ria'si. Naka imarã ĩ'ᵽarã ᵽo'imajarakamarã tẽrĩwa'ribajirõ'õjĩrã ma'a ñe'metãji Ᵽablote jããerã nata'arãñu. “Ᵽablote õñia kimarãkarõ'õjĩrã, ba'abekaja, okoa ukubekaja maimarãñu. Kire majããbesarãka, Tuᵽarãte mare jããrũ”, ãñurã nime. Mire najẽñerãka uᵽakaja mijã'merũkia ta'atikaja nime,— surara ĩᵽamakire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","—Me'ᵽe. Yire mibojaika aᵽerãte mibojaᵽiba'si,— surara ĩᵽamakire kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Suᵽa kibaaeka be'erõ'õ surararãka ĩᵽamaki, kirokajĩte imaekarã ĩᵽarimarã ĩ'ᵽarãte akatirã ikuᵽaka nare kibojaeka: —Ire ñami nueve rõ'õjĩrã aiyate eyawa'rirãka ᵽoto Cesarearã Ᵽablote mija e'ewa'rirãñu. Ikarakamaki mijaka a'rirãñurã: Doscientorakamarã imarãñurã ũ'ᵽuaᵽi a'rirãñurã. Suᵽabatirã setenta rakamarã a'rirãñurã kawaru ᵽemaᵽi. Suᵽabatirã doscientorakamarã imarãñurã bejoarikawa'ririmaja. ");
INSERT INTO tnc_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Suᵽabatirã kiᵽemaᵽi Ᵽablote a'yaokaro'si kawaru tõᵽoweitikaja mija imabe. Ĩᵽi Félix ᵽõ'irã õñikaja Ᵽablote eyarika yiyaᵽayu,— nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ikuᵽaka ãrĩwa'ri naka surara ĩᵽamakire ᵽaᵽera ᵽũataeka Félixre: ");
INSERT INTO tnc_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Yi'i Claudio Lisias ika ᵽaᵽera ᵽũataiki. ¿Yaje mime Félix, ĩᵽi imatiyaiki? ");
INSERT INTO tnc_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Judíotatarã ĩ'ĩ Ᵽablote ñi'atirã kire jããerã nabaakoᵽeraᵽe. ‘Romatataki kime’, naᵽakã'ã ã'mitiriwa'ri, kire najãã'si ãrĩwa'ri yisurararãkaᵽitiyika a'ritirã kire yija ẽ'maraᵽe nareka. ");
INSERT INTO tnc_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","‘I'siakaka oka kire ima’, naᵽakã'ã ã'mitiyaokaro'si, judíotatarã ĩᵽarimarã imatiyaitata ᵽõ'irã Ᵽablote ye'ewa'raᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","‘Yija ñekiarãte jã'mekakaka yi'ribeyuka kime’, ãrĩwa'ri kire naboebaraᵽe. Ᵽablo ᵽuri Romakarã ĩᵽarimarãre jã'meika yi'ribeyukamarĩka imarĩ, wẽkomaka imariwi'iarã imaberijĩki, majããberijĩkioka. ");
INSERT INTO tnc_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Judíotatarã kire jããrika nari'kaika õrĩtirã miᵽõ'irã kire yiᵽũatayu. Kire okabaarimajareoka yiᵽũatayu. Suᵽa imarĩ torã na'yu ‘Ikuᵽaka sime oka kiro'si’, mire nañaokaro'si. I'tojĩrãja sime”, ãrĩwa'ri Félixre ᵽaᵽera kiᵽũataeka. ");
INSERT INTO tnc_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Suᵽa imarĩ surara ĩᵽamakire jã'meka uᵽakaja Ᵽablote e'ewa'ritirã Antíᵽatriswejearã neyaeka. ");
INSERT INTO tnc_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Aᵽerĩmi surararãka ũ'ᵽuaᵽi a'rikarãte nawi'iarã ᵽe'rieyaeka ate. Cabaru ᵽemaᵽi a'rikarã takaja Ᵽabloᵽitiyika o'rikarã. ");
INSERT INTO tnc_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Cesarearã eyatirã ĩᵽi Félixre ᵽaᵽera naja'ataeka. Suᵽabatirã Ᵽablote kiᵽõ'irã natarika. ");
INSERT INTO tnc_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","I'sia ᵽaᵽera ĩaweatirã ikuᵽaka Ᵽablote kijẽrĩaeka: —¿No'okaki mime?— kire kẽrĩka. I'suᵽaka kẽᵽakã'ã, —Ciliciaka'iakaki ñime,— Ᵽablote ãrĩka. I'suᵽaka kẽᵽakã'ã ã'mitiriwa'ri, ");
INSERT INTO tnc_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","—“Mire ᵽarea ima”, ãrĩrĩ mire okabaarimajare etarãka ᵽoto nare mijairika ña'mitirirãñu ruᵽu,— Félixre kire ãrĩka. Suᵽa imarĩ, ĩᵽi Herodes wãsare baarũjekawi'iarã kisurararãkare kire kĩarĩrĩrũjeka. ");
INSERT INTO tnc_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ĩ'rãᵽitarakarĩmi be'erõ'õ kurarãka ĩᵽamaki imatiyaiki Ananías, suᵽabatirã judíotatarã ᵽakiarimarãᵽitiyika Cesarearã neyaeka. Nare jaiĩjirĩ Térbulo wãmeikite naka eyaeka. Cesarearã eyatirã ĩᵽi ᵽõ'irã na'rika, “Ᵽablote oka ima”, ãrĩrĩ. ");
INSERT INTO tnc_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Suᵽa imarĩ ĩᵽi Félixre akaeka Ᵽablote. “Oka Ᵽablote ima”, ãrĩwa'ri ikuᵽaka Tértulote ãrĩka Félixre: —Jia mibaayu ñiᵽamaki. Miõñuaᵽi ãrĩwa'riji, werika imabeyua maro'si. Suᵽabatirã jia mijẽrãko'aikaᵽi ritaja jiibaji simamaka ika ka'iareka imarãte jia mijeyobaayu. ");
INSERT INTO tnc_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","I'suᵽaka mibaarijayua õrĩtirã ritaja ᵽo'imajare jĩjimaka mika ime. “Ñiᵽamaki jia yija jiyiᵽuᵽayeeiki, jia mibaayu”, yija ãñu. ");
INSERT INTO tnc_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ima aᵽea miba'iraberika je'e. Suᵽa imarĩ ñoaka mika yijaiberijĩñu miba'iraberika yiriatakoreka. Ñojimarĩji yijaika mia'mitiᵽe ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ĩ'ĩ imaki, Ᵽablo kiokaᵽi ᵽo'imajare rukubaka ᵽuᵽajoarũjeiki. Ĩ'rãwejerãmarĩa turitirã judíotatarãte rukubaka kiᵽuᵽajoarũjetaᵽe. Jesús Nazaretkakire ã'mitiriᵽẽairã ruᵽuko'amaki kime. ");
INSERT INTO tnc_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'ia Tuᵽarã ñakoareka ba'iaja baarũjeriyaᵽawa'ri torã kãkaberijĩrã uᵽarãka torã kikãkaraᵽe. Suᵽa imarĩ kire yija ñi'araᵽe. Yija ñekiarãte jã'meka uᵽaka, “Oka kire ima”, ãrĩrika yija yaᵽakoᵽeraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","I'suᵽaka baarika yija yaᵽako'omakaja surara ĩᵽamaki, Lisias yija ᵽõ'irã eyatirã, okajãjia baatirã yijareka Ᵽablote kẽ'maraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ikuᵽaka yijare kẽrãᵽe: “ ‘Oka Ᵽablote ima’, ãrĩrika mija yaᵽarãkareka, ika ka'i ĩᵽamaki Félix ᵽõ'irã mija a'ᵽe”, yijare kẽrãᵽe. Suᵽa imarĩ, ñiᵽamaki Félix, miõñu uᵽakaja kire jẽrĩakõrĩ je'e ᵽarea kire imakaka. I'suᵽaka mijẽrĩarãka be'erõ'õ “Kire nokabaaika rita sime”, merĩrãñu,— Tértulote ãrĩka Félixre. ");
INSERT INTO tnc_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Torã judíotatarã kika imaekarãoka “Rita sime”, ãrĩkarã. ");
INSERT INTO tnc_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Suᵽa imarĩ Félix jẽrãbaaekaki Ᵽablote kiᵽitakaᵽi, “Mijaibe”, ãrĩwa'ri. I'suᵽaka kibaamaka ĩatirã, Ᵽablote jaiũ'mueka, —Ñoñu, ika ka'iarã bikija ĩᵽi imaũ'muekaki mime. Suᵽa imarĩ miwãjitãji “Dakoa oka imabeyua yiro'si”, ãrĩwa'ri jĩjimakaᵽi yijairã baayu. ");
INSERT INTO tnc_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ĩ'ᵽoũ'ᵽuarãe'earirakarĩmi rõ'õjĩrãja seyawa'yu ruᵽu Jerusalénrã Tuᵽarãte jiyiᵽuᵽayeerĩ yituraᵽaka be'erõ'õ. “Rita sime je'e”, merĩrãkareka, aᵽerãte mijẽᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Marãᵽateoka Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã rẽrĩtirã imarãka yokatotomaka ĩaberaᵽarã ĩ'rã. Suᵽabatirã simauᵽatiji judíorãkare rẽrĩriwi'ia yituriroyiraᵽarõ'õrã rẽrãᵽarãre rukubaka ᵽuᵽajoarũjeberaᵽaki yi'i. Jerusalén wejeareka oka yiᵽo'ijiaberaᵽaka simamaka, “I'suᵽaka Ᵽablote ba'iaja baaraᵽaka ᵽoto kire yija ĩaraᵽe”, maki ãrĩwãrũberijĩki. ");
INSERT INTO tnc_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Suᵽa imarĩ “Ᵽablote yija okabaaika ritataka sime”, narĩwãrũberijĩñu. ");
INSERT INTO tnc_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ika mijare yibojawaᵽu'aerã baayu. Tuᵽarã, yiñekiarãte jiyiᵽuᵽayeekakite jiyiᵽuᵽaka ñoñu yiro'sioka. I'suᵽaka imariᵽotojo Jesúre yijare wãrõeka uᵽakaja Tuᵽarãte yijiyiᵽuᵽayeeyu. Judíotatarã ĩᵽarimarã ᵽuri “Jesúrika bojariroka ᵽakirimajaroka sime”, ãñurã. Tuᵽarãte yi'yuka imarĩ, Moisés imaekakite jã'mekakaka, suᵽabatirã Tuᵽarãro'si bojaĩjirimajare o'oekaoka yi'yuka ñime. ");
INSERT INTO tnc_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","“Nimauᵽatiji reyairãte ate Tuᵽarãte õñia jariᵽe'rirũjerãñu”, ĩ'rãrimarã õ'õrã imarãte ãñu uᵽaka ãñuka ñime yiro'sioka. Ba'iaja baairã reyairãte, jia baarijayurã reyairãteoka i'suᵽaka kibaarãñu. ");
INSERT INTO tnc_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Suᵽa imarĩ jia oyiaja yibaariyaᵽayu, Tuᵽarã wãjitãji, ᵽo'imaja wãjitãjioka, yire oka imakoreka. ");
INSERT INTO tnc_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Ĩ'rãjẽ'rãmarĩa, aᵽea wejearã turitaᵽatirã, Jerusalénrã yiᵽe'rietaraᵽe. Torã ᵽe'rieyatirã wayuoka baairãte niñerũ yiᵽibaraᵽe. Suᵽabatirã Tuᵽarãte jiyiᵽuᵽayeebaraka wa'iro'sia kiro'si torã yijoeĩjirũjeraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iareka i'suᵽaka baabaraka ñimaraᵽaka ᵽoto ĩ'rãrimarã judíotatarã yire ĩatõᵽoraᵽarã. Yija tatarã ba'iaja nabaarijayua najũjeika uᵽakaja yibaawearaᵽaka ᵽoto, yire niatõᵽoraᵽe. I'sia ᵽoto rĩkimarã imaberaᵽarã ᵽo'imaja yika, suᵽabatirãoka, oka imaberaᵽaka. ");
INSERT INTO tnc_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Aᵽerã judíotatarã Asiaka'iakarã ᵽuri yire ĩatõᵽotirã oka ᵽo'ijiaraᵽarã. I'suᵽaka imarã imarĩ “Oka kire ima”, ãrĩwa'ri, bojarĩ ni'tarũ maekakaja. ");
INSERT INTO tnc_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Bojarĩ ni'tabesarãkareka, ĩrã õ'õrã imarãja bojarũ. Ĩ'ᵽoũ'ᵽuarãe'earirakarĩmi rõ'õjĩrãja seyawa'yu ruᵽu Jerusalénrã yija judíotatarã ĩᵽarimarã imatiyaitata wãjitãji yimajaroka nare yibojaraᵽaka be'erõ'õ. Õ'õrã imarã, sã'mitiraᵽarã imarĩ “Ikuᵽaka Ᵽablote ba'iaja baaraᵽe”, ãrĩwa'ri yijare nabojajĩkareka jia simajĩñu. ");
INSERT INTO tnc_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Aᵽeyari “Reyariᵽotojo ate õñia jariᵽe'rirãñurã ᵽo'imaja”, ika takaja jãjirokaᵽi torã ñarãᵽaka ã'mitiritirãja “Oka kire ima”, mija ãñuje'e,— Ᵽablote ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Jesúre ᵽo'imajare ã'mitiriᵽẽaika majaroka õrĩtikaki Félixre imaeka imarĩ ikuᵽaka nare kẽrĩka: —I'tojĩrãja ña'mitirirãñu ruᵽu. Surara ĩᵽamaki Lisiare etarãka ᵽoto, “Oka kire ima, oka imabeyua kiro'si”, ñarĩrãñu,— Félixre ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Suᵽa imarĩ ikuᵽaka surara ĩᵽamakire kẽrĩka: —Wẽkomaka imariwi'iarã Ᵽablote mija ĩarĩᵽe. Torã tĩmarĩji kire mija baa'si. Kijeyomarãre etarãkareka kire najeyobamaka mija jãjibaa'si,— kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","I'sia wãrĩwa'ri aᵽerĩmirõ'õjĩrã be'erõ'õ Félixre etaeka ate kirũmu Drusilaᵽitiyika. Judíotatako koimaeka. Torã eyatirã Ᵽablote kiakarũjeka. Ketaeka ᵽoto, Jesucristore ã'mitiriᵽẽarikakaka kibojamaka Félixre ã'mitirika. ");
INSERT INTO tnc_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ikuᵽaka Ᵽablote kire bojaeka: “ ‘Jia ĩ'rãtiji ᵽuᵽajoawa'ri i'suᵽaka mija imabe’, ãrĩwa'ri Tuᵽarãte mare bojayu. Ba'iaja baarika mare jitoko'omakaja ba'iaja baabekaja maimajĩñu. Ĩ'rãrĩmi ba'iaja mabaaika waᵽa Tuᵽarãte mare jẽñerãñu”, Ᵽablote ãrĩka. I'suᵽaka kẽᵽakã'ã ã'mitiriwa'ri, Félixre ᵽuᵽataeka. —Me'ᵽe ruᵽu. Dakoa baabekaja ñimarãñurĩmi ate mire yakarãñu i'siakaka rĩkimabaji ña'mitiyaokaro'si,— Ᵽablote kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","“Niñerũ yire kĩjirãkareka, kire yija'atarãñu”, ãrĩᵽuᵽajoawa'ri, ñemeaja Ᵽablote kiakaeka, kika jairã. I'suᵽaka simako'omakaja kiyaᵽaeka uᵽakamarĩa Ᵽablote baaeka. ");
INSERT INTO tnc_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","I'suᵽaka kibaayukã'ãja ĩ'ᵽakuri wejejẽ'rãka so'rika. I'sia be'erõ'õ ĩᵽi kimaekareka Félixre ᵽorika. Suᵽabatirã Ᵽorcio Festo wãmeiki kiõ'toarã ĩᵽi jãikaki. Félix ĩᵽamaki kimaeka kiᵽorirã baaeka ruᵽu judíotatarãᵽitiyika jia imarika yaᵽawa'ri Ᵽablote kija'ataberika ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festo ĩᵽi imarĩ kikãkaeka be'erõ'õ maekarakarĩmi simaeka ᵽoto Cesareaᵽi imatirã Jerusalénrã turirĩ ke'rika. ");
INSERT INTO tnc_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Torã keyaeka ᵽoto kurarãka ĩᵽamarã suᵽabatirã, judíotatarã ĩᵽarimarã imatiyairã “Oka ima Ᵽablote”, ãrĩwa'ri Festore bojarĩ netaeka. ");
INSERT INTO tnc_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","—Jia yijare mibaabe. Õ'õ Jerusalénrã Ᵽablote etaerã kire miakaᵽũabe,— ãrĩwa'ri Festore naᵽakatarika. Saruᵽubaji natiyiaja ikuᵽaka najaika simamaka: “Ᵽablote kiakarãka ᵽoto ma'a ñe'metãjirõ'õrã kire majããye'e.” ");
INSERT INTO tnc_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","I'suᵽaka naᵽakã'ã, ikuᵽaka Festore nare ãrĩka: —Cesarearã wẽkomaka imariwi'iarã Ᵽablote ime. “Suᵽa imarĩ ñojimarĩji yiᵽuᵽayariji torã ya'rirãñu”, ñarĩᵽuᵽajoayu. ");
INSERT INTO tnc_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Yika na'rirũ ĩ'rãrimarã ĩᵽarimarã mijaka imarã. Oka kire imarãkareka ᵽuri, yika a'ritirã, “Oka kire ima”, narĩrũ,— Festore nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Ĩ'ᵽaᵽitarakarĩmi Jerusalénrã imatirã, Cesarearã Festore ᵽe'riwa'rika ate. Aᵽerĩmi oka jieriwi'iarã ke'rika. Torã eyatirã Ᵽablote kiakaeka. ");
INSERT INTO tnc_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ᵽablote kãkaeyaeka ᵽoto judíotatarã Jerusalénᵽi i'taekarãte kiᵽõ'irã narãkutorirĩkaeka. “Rĩkimakaja oka kire ima”, ãrĩkoᵽeriᵽotojo, “I'siakaka oka kire ima”, narĩwaᵽu'awãrũberika. ");
INSERT INTO tnc_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","I'suᵽaka naᵽakã'ã ã'mitiritirã, “Oka yire imabeyua”, ãrĩwa'ri ikuᵽaka Ᵽablote ãrĩka: —Yija judíotatarãte jã'meika ã'mitiriᵽẽabeyukamarĩki ñime. Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã ba'iaja baarĩ kãkaberaᵽaki yi'i. Suᵽabatirã Ĩᵽi Césarte yi'ribeyukamarĩki yi'i,— Ᵽablote ãrĩka torã ã'mitiriruᵽaekarãte. ");
INSERT INTO tnc_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Judíotatarãka jia imarika yaᵽawa'ri, ikuᵽaka Ᵽablote kijẽrĩaeka Festo: —¿Yaje Jerusalénrã me'ririyaᵽayu? Jerusalénrã ᵽo'imajare ĩarãka wãjitãji, “¿Yaje oka mire ima?”, ãrĩwa'ri yijẽrĩarika, “¿Yaje miyaᵽayu?”,— Festore kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","I'suᵽaka kẽᵽakã'ã ã'mitiriwa'ri, ikuᵽaka Ᵽablote yi'rika: —Jẽno'o. Õ'õrã miwãjitãji yirĩkame “Oka mire imabeyua, oka ima miro'si”, yire meñaokaro'si. I'suᵽaka õ'õrã baarimaji Ĩᵽi Césarte mire imarũjemaka, õ'õrãja yire mijẽrĩabe. Judíotatarãte ba'iaja yibaaberaᵽaka jia miõñu. ");
INSERT INTO tnc_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ba'iaja yibaaeka miõrĩrãkareka ᵽuri, yire mijããrũjebe. “Yire mijããrũjea'si”, ãrĩberijĩki yi'i. “Oka kiro'si ima”, yireka nokabaaika ritamarĩa simarãkareka, ĩ'rĩkaoka judíotatarã ᵽõ'irã yire mija ᵽũatawãrũberijĩñu. Suᵽa imarĩ, Ĩᵽi César kiᵽuᵽakarãja, “Oka mire ima, oka mire imabeyua”, yire kẽrĩrika yiyaᵽayu,— Ᵽablote ãrĩka Festore. ");
INSERT INTO tnc_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","I'suᵽaka kẽᵽakã'ã ã'mitiriwa'ri, kire jaijeyobaarimajaka Festore jaika. Suᵽabatirã ikuᵽaka Ᵽablote kẽrĩka: —Suᵽa sime, “Ĩᵽi Césare yire ãrĩrika yiyaᵽayu”, meᵽakã'ã ã'mitiriwa'ri, kiᵽõ'irã mire yija ᵽũatarãñu,— Festore kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","I'sia wãrĩwa'ri aᵽerĩmirõ'õjĩrã ĩᵽi imatiyaiki Agriᵽa wãmeiki kibe'erõ'õkako Bereniceᵽitiyika, Cesarearã neyaeka. Festore mamaka ĩᵽi jãika simamaka, “Jia mimabe”, kire ãrĩrĩ na'rika. ");
INSERT INTO tnc_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ñoaᵽañaka torã imatirã Ᵽablo majaroka Festore bojaeka ĩᵽi Agriᵽare. —Ĩᵽi Félixre imaeka ᵽoto wẽkomaka imariwi'iarã ĩ'rĩkate kitaeka, õ'õrãja kime ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Jerusalénrã ñimaraᵽaka ᵽoto kurarãka ĩᵽamarã suᵽabatirã judiorãka ĩᵽarimarã, “Oka kire imamaka kire majããjĩkareka jia simajĩñu”, yire narãᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ikuᵽaka nare yiyi'raᵽe: “Yija Romatatarãte jã'meika ikuᵽaka sime: ‘Oka kire ima’, ãñurã wãjitãji rĩkamaᵽaraka, ‘Ikuᵽaka simamaka, oka yire imabeyua’, nare kẽrĩbeyukaji kire jããrika imabeyua”, nare ñarĩka. ");
INSERT INTO tnc_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Suᵽa imarĩ õ'õrã judíotatarãte etaraᵽaka ᵽoto, yiba'eberaᵽe. Aᵽerĩmi ĩᵽarimarãre oka jieirõ'õrã naka eyatirã, Ᵽablote yakarũjeraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Yiᵽuᵽarõ'õᵽi, “ ‘I'siakaka ba'iaja baaraᵽaki kime’, õ'õrã etairã judíotatarãte kireka ãrĩrãñu je'e”, ñarĩᵽuᵽajoakoᵽeraᵽe. I'suᵽakamarĩa simaraᵽe. Aᵽeakaka oyiaja kire nokabaaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","“Tuᵽarãte yija jiyiᵽuᵽayeerijayu uᵽaka yi'ribeyuka kime”, ãrĩwa'ri “Oka kire ima”, kireka narãᵽe. Suᵽabatirã ĩ'rĩka Jesús wãmeikireka “Reyakoᵽeriᵽotojo ate õñia kijariᵽe'rika”, Ᵽablote ãᵽakã'ã kire nokabaaraᵽe. I'sia takaja nabojaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Marãkã'ã i'siakaka nare jẽrĩawãrũberiwa'ri ikuᵽaka Ᵽablote yijẽrĩaraᵽe: “ ‘Jerusalénrã, oka kire ima, oka kire imabeyua’, ãrĩwa'ri, oka najieirõ'õrã ¿yaje me'ririyaᵽayu?”, kire ñarĩkoᵽeraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","“Jẽno'o, Romakaki ĩᵽi César, ‘Oka kire ima, oka kire imabeyua’, yire kẽrĩrika yiyaᵽayu”, Ᵽablote ãrãᵽe. I'suᵽaka kẽᵽakã'ã ã'mitiriwa'ri, “Romawejearã kiᵽõ'irã mire yiᵽũatarãkarõ'õjĩrã wẽkomaka imariwi'iarã mimarãñu ruᵽu”, kire ñarãᵽe,— Festore ãrĩka Agriᵽate. ");
INSERT INTO tnc_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Suᵽa imarĩ ikuᵽaka Agriᵽate ãrĩka Festore: —Yi'ioka Ᵽablote jairika ã'mitiriyaᵽaiki.— —Jee, waeroka bikitojo kijaimaka mia'mitirirãñu,— Festore kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Suᵽa imarĩ bikitojo Agriᵽa, Bereniceᵽitiyika, Ᵽablote jaimaka ã'mitirirĩ neyaeka. Torã eyatirã “Tẽrĩrikaja imatiyairã nime”, ᵽo'imajare ãrĩᵽuᵽajoaokaro'si jía jariroaka waᵽajã'rĩakaka jããtirã, rẽrĩrũki wi'iarã nakãkaeka. Surararãka ĩᵽamarãᵽitiyika, suᵽabatirã i'sia wejeareka ĩᵽarimarã imatiyairãᵽitiyika nakãkaeka. Nakãkamaka ĩatirã, Festore akarũjeka Ᵽablote. ");
INSERT INTO tnc_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ᵽablote etamaka ĩatirã, torã rẽrĩtirã imaekarãte ikuᵽaka Festore ãrĩka: —Ñiᵽamaki Agriᵽa, suᵽabatirã yijaka rẽrĩtirã imarã, mija ĩabe, ĩ'ĩ kime Ᵽablo. Rĩkimarãja judíotatarã “Oka kire imamaka, kireyaᵽajĩñu”, ãrĩwa'ri akaserebaraka kire nokabaarijayu yire, Jerusalénrã suᵽabatirã õ'õ Cesarearãoka. ");
INSERT INTO tnc_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Yiᵽuᵽajoaikareka, oka imatiyaika imabeyua kiro'si. Suᵽa imarĩ “Kireyaᵽarũ”, ñarĩwãrũbeyu. “Maiᵽamaki César wãjitãji, ‘I'siakaka oka mire ima, i'sia oka mire imabeyua’, yire kẽrĩrika yiyaᵽayu”, kẽrãᵽaka uᵽakaja “Ĩᵽi ᵽõ'irã kire yiᵽũatarãñu”, ñarĩᵽuᵽajoayu. ");
INSERT INTO tnc_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","“I'siakaka Ᵽablote oka imatiyaika”, ãrĩwa'ri ñiᵽamakiro'si ᵽaᵽera yo'owãrũbeyu. Suᵽa imarĩ Ᵽablote yakako'o, kire mijẽñaokaro'si rita bojarikareka ñiᵽamaki Agriᵽa. I'suᵽaka mijẽrĩarãka be'erõ'õ i'sia oka ã'mitiritirã ĩᵽi César ro'si yo'orãñu. ");
INSERT INTO tnc_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Waᵽuju “I'siakaka oka kire ima”, ãrĩwãrũberikoᵽeriᵽotojo, Ᵽablote yiᵽũatajĩka waᵽuju õrĩᵽũabeyuka uᵽaka yibaajĩñu,— Festore kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","I'suᵽaka kẽᵽakã'ã ã'mitiriwa'ri, Ᵽablote kijairũjeka Agriᵽa. —Miõñu uᵽakaja, “Oka yire imabeyua”, ãrĩwa'ri mibojabe,— kẽrĩka. I'suᵽaka kẽᵽakã'ã ã'mitiritirã, Ᵽablote kiᵽitaka mi'mataeka jiyiᵽuᵽaka ĩᵽire õrĩwa'ri. Suᵽabatirã ikuᵽaka kijaika mae: ");
INSERT INTO tnc_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","3","—Ñiᵽamaki Agriᵽa, mia'mitiyaokaro'si jĩjimakaᵽi yijairã baayu. Yija judíotatarãte baarijayua jia miõñu. Ᵽuᵽajoatirã yija jaikaoka jia miõñu. Suᵽa imarĩ judíotatarãte, “Oka kire ima”, ãñuakaka mae sayibojaerã baayu. Jia jajumarĩaja ritaja yibojaika mia'mitiᵽe,— Ᵽablote kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","—Yitã'omaja judíotatarã ritaja ñimaeka mirãka õñurã nime. Yiwejeareka me'rĩ ñimaeka suᵽabatirã Jerusalénrã ñimataᵽaeka mirãkaoka jia noñu. “Me'rãrĩrãja mañekiarãte baaroyika uᵽakaja kiyi'rika”, yireka nañu ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Yitatarã fariseokaka ᵽuᵽajoairã, ĩ'rã imarã tẽrĩrikaja Moisés imaekakite jã'meroyikakaka yi'yurã. Me'rĩ ñimaeka ᵽotorãja fariseokaka naᵽuᵽajoaika yiᵽuᵽajoaroyika. “I'suᵽaka kimaroyika”, narĩjĩka, rita sime. ");
INSERT INTO tnc_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","“Reyairãte ate õñia yijariᵽe'rirũjerãñu”, ãrĩwa'ri Tuᵽarãte bojaᵽũaeka yija ñekiarãte. Mia, i'suᵽaka yiᵽuᵽajoamaka, “Oka kire ima”, ãrĩwa'ri õ'õrã yire ne'era'ayu. ");
INSERT INTO tnc_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","“Tuᵽarãte ãrĩka uᵽakaja kibaarãñu”, ãrĩwa'ri nata'ayu judíorãka ĩ'ᵽoũ'ᵽuarãe'earirakatata imarã. Suᵽa imarĩ ĩmi, ñamioka Tuᵽarãte jiyiᵽuᵽayeebaraka nime. Nuᵽakaja i'siakaka yiᵽuᵽajoako'omakaja “Oka kire ima”, yireka nañu. ");
INSERT INTO tnc_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","“Reyairãte õñia Tuᵽarãte jariᵽe'rirũjerãñu”, ãñurã imariᵽotojo ¿dako baaerã “Jesúre õñia jariᵽe'riberika”, mija ãñu je'e, judíotatarã õ'õrã imarã?— Ᵽablote ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Aᵽea ikuᵽaka Ᵽablote jaika: —“Jesús Nazaretkakire ã'mitiriᵽẽairãte ba'iaja yibaaᵽarũ”, ñarĩroyiraᵽe ruᵽu mamarĩ. ");
INSERT INTO tnc_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","I'suᵽaka yiᵽuᵽajoaraᵽaka uᵽakaja yibaaraᵽe Jerusalénrã. Kurarãka ĩᵽamarãre jã'memaka, Jesúre ã'mitiriᵽẽairãte wẽkomaka imariwi'iarã yitarũjeroyiraᵽe. Jesúre yi'yurãte najããmaka, “I'suᵽaka mabaaᵽajĩñu”, ñarĩᵽuᵽajoaraᵽe yiro'si. ");
INSERT INTO tnc_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ĩ'rãkurimarĩa Jesúre ã'mitiriᵽẽairãte ba'iaja yibaaraᵽe, “Jesúre yi'ribeyurã yija ime”, narĩrũ ãrĩwa'ri. Ritaja judíorãkare rẽrĩriwi'irã nare e'ekãkatirã i'suᵽaka ba'iaja nare yibaaroyiraᵽe. Suᵽabatirã, jimarĩa nare boebariwa'ri aᵽewejearã ya'raᵽe ba'iaja nare baaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Kurarãka ĩᵽamarãre jã'meika yi'riwa'ri i'suᵽaka baarĩ Damascowejearã ya'raᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ñiᵽamaki Agriᵽa, ma'aᵽi ya'ririjaraᵽaka ᵽoto, aiyate tẽrĩwa'ribaji jãjia yaaboaika ñiaraᵽe ĩmiñe'metãji seyawa'raᵽaka ᵽoto. I'suᵽaka yaaboaraᵽaka ããtika yire jããta'araᵽaka suᵽabatirã yika a'raᵽarãteoka. ");
INSERT INTO tnc_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Suᵽa imarĩ yija imarakamarãja yija ña'rãᵽe ka'iarã. Suᵽabatirã hebreo okaᵽi ikuᵽaka yire sajaimaka ña'mitiraᵽe: “Saulo, Saulo, ¿dako baaerã ba'iaja yire mibaarijayu?”, ãrĩwa'ri sajaikoraᵽe ĩmiᵽi. “I'suᵽaka mibaakoᵽeika miᵽo'iaja ba'iaja mibaayu. Ᵽota miterujĩkareka, mire sayi'arãñu. I'suᵽaka baariuᵽaka mibaayu”, ãrĩwa'ri yire sajaikoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","I'suᵽaka sajaimaka, “¿Maki mime je'e Ñiᵽamaki?”, ñarãᵽe. I'suᵽaka ñaᵽakã'ã ikuᵽaka Maiᵽamakire yire ãrãᵽe: “Yi'iji oka ñime, Jesús ba'iaja mibaaiki. ");
INSERT INTO tnc_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Mimi'mirĩkabe. ‘Yiyaᵽaika uᵽakaja kibaarũ’, ãrĩwa'ri, miᵽõ'irã yiᵽemakotowiyu. Suᵽa imarĩ yimajaroka ᵽo'imajare mibojaᵽibarãñu. Maekaka miaika, suᵽabatirã ñamajĩ mire yibearũkiaoka ᵽo'imajare mibojaᵽibarãñu. ");
INSERT INTO tnc_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Judíotatarã, suᵽabatirã judíotatamarĩrã imarãte mire jããrika ri'karãka ᵽoto mika ñimarãñu. ‘Ritaja ᵽo'imajare yimajaroka Ᵽablote bojarũ’, ãrĩwa'ri naᵽõ'irã mire yiᵽũatayu. ");
INSERT INTO tnc_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Naᵽõ'irã mire yiᵽũatayu, aᵽeuᵽaka naᵽuᵽajoaokaro'si. Suᵽa imarĩ ᵽakirimajaroka yi'ribekaja, rita imakaka norĩwãrũrãñu. Suᵽabatirã Satanáre ĩ'rãᵽẽ'rõtorãja baatirã, Tuᵽarãte yaᵽaika uᵽakaja nabaarãñu. I'suᵽaka Tuᵽarãte na'mitiriᵽẽarãka ba'iaja nabaakoᵽeika kiye'kariarãñu. Suᵽa imarĩ kirirã nimajiᵽarãñu”, ãrĩwa'ri yire sajaikoraᵽe,— Ᵽablote ãrĩka Agriᵽate. ");
INSERT INTO tnc_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","—Ñiᵽamaki Agriᵽa, i'suᵽaka ĩmiᵽi kijaimaka ã'mitiriwa'ri, kẽrãᵽaka uᵽakaja Jesúre yiyi'raᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Kẽrãᵽaka uᵽakaja Damascokarãre Jesúrika bojariroka yibojaũ'muraᵽe. I'sia be'erõ'õ Jerusalénkarã Judea ka'iakarãre nimauᵽatiji, suᵽabatirã judíotatamarĩrãteoka kimajaroka yibojataᵽaraᵽe. “Ba'iaja mija baaika ja'atatirã, Tuᵽarãte yaᵽaika uᵽakaja mija ᵽuᵽajoabe. Suᵽabatirã jia baabaraka mija imabe, ‘Tuᵽarãte yi'yurã nime’, aᵽerãte ãrĩwãrũokaro'si”, nare ñarãᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","I'suᵽaka yibojamaka ã'mitiriwa'ri, Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã judíotatarãte yire ñi'araᵽe. Suᵽabatirã yire najããriyaᵽaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","I'suᵽaka nabaariyaᵽako'omakaja, Tuᵽarãte yire jeyobaaraᵽe. Maekakaoka Tuᵽarãte yire jeyobaayu ruᵽu. Suᵽa imarĩ õ'õrã ᵽo'imaja imatiyarimajare, suᵽabatirã waᵽuju imabayurãteoka Tuᵽarãrika yibojayu. “I'suᵽaka simarãñu”, Moisés imaekakite bojatika uᵽakaja, suᵽabatirã Tuᵽarãro'si bojaĩjirimajare bojatika uᵽakaja i'siakaka mijare yibojayu. ");
INSERT INTO tnc_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Moisés suᵽabatirã Tuᵽarãro'si bojaĩjirimajaoka ikuᵽaka narĩka: “Tuᵽarãte ᵽũatarãñuka ba'iaja jũatirã, reyarũkika. Iki imarãki reyakoᵽeriᵽotojo mamarĩji õñia jariᵽe'rirãki. Ate õñia jariᵽe'ritirã Judíotatarã, judíotatamarĩrãteoka kitããrũkia nare kiõrĩrũjerãñu”, ãrĩwa'ri no'oeka. Nabojaeka uᵽakaja simaraᵽe,— Ᵽablote nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","I'suᵽaka “Oka yire imabeyua”, ãrĩwa'ri Ᵽablote jaiyukã'ãja jãjirokaᵽi Festore jaita'taeka, —¡Waᵽuju jaiwejabiyuka mime Ᵽablo! Tẽrĩtaka ᵽaᵽera miwãrũeka simamaka rukubaka miᵽuᵽajoayu,— Festore kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","I'suᵽaka kẽᵽakã'ã ã'mitiriwa'ri, ikuᵽaka Ᵽablote yi'rika: —Jẽno'o ñiᵽamaki Festo, waᵽuju jaiwejabiribeyuka yi'i. Jia ᵽuᵽajoatirã yijaiyu, suᵽabatirã ritaitaka oyiaja sime. ");
INSERT INTO tnc_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Maiᵽamaki Agriᵽa, yijaikakaka jia õrĩᵽũaiki. Suᵽa imarĩ kĩkirimarĩaja i'siakaka kiwãjitãji yijaiyu. Wããrõ'õrãja Jesúre wãrõeka, i'suᵽakajaoka ᵽo'imajare kijeyobaaeka. Suᵽa imarĩ Jesús majaroka nimauᵽatiji ᵽo'imajare ã'mitiriᵽataika uᵽakaja, ikioka sã'mitiriᵽataraᵽaki ñarĩᵽuᵽajoayu,— Festore kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","—Ñiᵽamaki Agriᵽa, Tuᵽarãro'si bojaĩjirimajare bojaeka ¿yaje mia'mitiriᵽẽayu? “Sã'mitiriᵽẽaiki kime”, mireka ñarĩᵽuᵽajoayu,— Ᵽablote kire ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","—¿I'suᵽaka yire mijaikajĩkaᵽi “Jesúre kiã'mitiriᵽẽarãñu”, yireka merĩᵽuᵽajoayu bai?— Agriᵽate ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","I'suᵽaka kẽᵽakã'ã ã'mitiriwa'ri, ikuᵽaka Ᵽablote kire ãrĩka: —Rĩkimaka majaroka yijaijĩka, kũᵽajĩ yijaijĩkaoka, miro'si Tuᵽarãte yijẽñeyu. Suᵽabatirã õ'õ yijaika ã'mitiyurã ritajaro'si Tuᵽarãte yijẽñeyu, Jesúre ña'mitiriᵽẽaika uᵽaka mija ã'mitiriᵽẽaokaro'si. I'suᵽaka simako'omakaja yuᵽaka ᵽerumijiaᵽi ᵽi'ᵽekarã mija imarika yiyaᵽabeyu,— Ᵽablote nare ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","31","I'suᵽaka kẽrĩka be'erõ'õ Agriᵽa, Festo, Berenice torã nimaeka uᵽatiji aᵽerõ'õrã na'rika, ikuᵽaka natiyiaja jaiokaro'si: —Dakoa oka imabeyua kiro'si. Suᵽa imarĩ “Kireyaᵽarũ”, maki kireka ãrĩberijĩki. I'suᵽakajaoka wẽkomaka imariwi'iarãoka kimaberijĩñu,— narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Suᵽa imarĩ Agriᵽate ikuᵽaka ãrĩka Festore: —“Ĩᵽi César ᵽõ'irã oka jierika yiyaᵽayu”, kẽrĩberirikareka, maekaka kire maja'atajĩñu imakoᵽeyu,— kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Torãjĩrã mae, “Ᵽablote, suᵽabatirã kika wẽkomaka baariwi'iarã imarãteoka Italiaka'iarã maᵽũatajĩñu”, ĩᵽarimarãre ãrĩka ᵽoto surara ĩᵽamaki Julio wãmeikite Italiaka'iarã yijare ne'ewa'rirũjeraᵽe. Ĩᵽi César surara wãmeitatarã ĩᵽamaki kimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Suᵽa imarĩ Adramitio wãmeika wejeaᵽi i'taeka waᵽururã jãitirã yija a'riũ'muraᵽe ate. Asia ka'iareka ima wejea ᵽaᵽitaka turitaᵽarĩ a'yua simaraᵽe i'sia waᵽuru. Ĩ'rĩka Aristarco wãmeikite yijaka a'raᵽe. Macedonia ka'iarã Tesalónica wejeakaki kimaraᵽe iki. ");
INSERT INTO tnc_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Cesareaᵽi yija a'raᵽe. Aᵽerĩmi Sidónwejearã yija eyaraᵽe. Torã eyatirã jia Ᵽablote ĩawãrũwa'ri jia Juliore kire baaraᵽe. I'sia wejeareka imarã kijeyomarãre Ᵽablote ĩarika yaᵽamaka jãjibaaberaᵽaki Julio, “Kire jariwa'yua, ba'irĩjia kire nijirãñu je'e”, ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Sidónᵽi yija o'raᵽaka ᵽoto jãjia wĩrõa yijare baeraᵽaka. Wãjia a'riwãrũberiwa'ri Chiᵽre wãmeika jũmurika jãjitaka wĩrõa baeberaᵽaka ᵽẽ'rõtoᵽi yija o'raᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Ciliciaka'ia, Ᵽanfiliaka'ia, wãjitãji yija o'raᵽe. Toᵽi o'ritirã Liciaka'iarã Mira wãmeika wejearã yija eyaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Torã eyatirã surara ĩᵽamaki Julio Italiaka'iarã a'yua ĩ'rãkũmu waᵽuru kĩatõᵽoraᵽe. Alejandríakaka simaraᵽe i'sia waᵽuru. Sarã yija jãiraᵽe saᵽi a'yaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Jãjia wĩrõa baemaka, ĩ'rãrĩmimarĩa a'ritirã, ka'wisi be'erõ'õ Cnido wãmeika wejea ko'aᵽito yija eyaraᵽe. Wãjitãji sayija o'ritaᵽaraᵽe. Yija a'raᵽaka wãjitãji jãjia wĩrõa baemaka, wãjia yija a'riwãrũberaᵽe. Wejerĩrĩka ᵽẽ'rõtorã tẽrĩwa'ritirã Salmona wãmeika wejearã yija o'raᵽe. Suᵽabatirã Creta wãmeika jũmurika, wĩrõa rãrĩta'airõ'õᵽi yija a'ririjaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Toᵽi rãkuwa'ritirã, ka'wisi be'erõ'õ Lasea wãmeika wejewã'tarã, Buenos Ᵽuertos nawãmeyeeirõ'õrã yija eyaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Ĩ'rãrĩmimarĩa sajaritiraᵽe yija a'riũ'muraᵽaka be'erõ'õ. Ᵽu'ea koyiaja sajariwa'raᵽaka simamaka werika simaraᵽe riaᵽakiaka mae. Suᵽa imarĩ ikuᵽaka Ᵽablote nare okajããraᵽe: ");
INSERT INTO tnc_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","—Yijeyomarã yiᵽuᵽajoaikareka õ'õᵽi mo'yua, werika simarãñu maro'si. Waᵽuru ña'mirãka, suᵽabatirã waruakaoka ña'miᵽatarãka je'e. Maririrãñu je'e aᵽeyari,— Ᵽablote nare ãrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","I'suᵽaka kẽrĩko'omakaja surara ĩᵽamakire kire ã'mitiriᵽẽaberaᵽe. Waᵽuru ĩᵽamaki, suᵽabatirã waᵽuru temarĩkarimajire takaja kiã'mitiriᵽẽaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","“Ᵽu'ea simarãka ᵽoto marakajeᵽããbesarãñu õ'õrã”, ãrĩᵽuᵽajoawa'ri, i'sia ᵽaᵽitakarã ᵽu'ea nare o'ririka aᵽerãte yaᵽaberaᵽe, yijaka a'raᵽarã. Suᵽa imarĩ “Fenicewejearã Cretajũmurikarã ma'riye'e. Torã ᵽu'ea mareka o'rirũ”, narãᵽe. Ka'arirõ'õ ᵽañaka simamaka waᵽuru ᵽããrũkirõ'õrã jãjia wĩrõa baeberijĩka simaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Wejerĩrĩkaᵽi jãjimarĩa wĩrõa baemaka ĩawa'ri, “Fenicerã maeyarãñu je'e”, narĩᵽuᵽajoaraᵽe. I'suᵽaka ᵽuᵽajoatirã Creta jũmurika rijeᵽẽ'rõtoᵽi yija rãkuũ'muraᵽe ate. ");
INSERT INTO tnc_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","I'sia be'erõ'õ no'ojĩrãmarĩaja jãjitaka ma'karoka ᵽẽ'rõtoᵽi waᵽururã wĩrõa eiũ'muraᵽaka. Jãjia wĩrõa Nordeste wãmeika simaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Jãjia wĩrõa waᵽuru baemaka wãjitãji yija a'riwãrũberaᵽe. Suᵽa simamaka wĩrõa e'ewa'raᵽaka uᵽakaja yija a'raᵽe mae. ");
INSERT INTO tnc_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Kũᵽajĩka jũmurika Cauda wãmeika rãrĩta'aiᵽẽ'rõtoᵽi jãjitaka baetiyabeyurõ'õ yija o'raᵽe. Suᵽa imarĩ ka'wisi be'erõ'õ kũmumakarãka naji'abaawa'raᵽaka ne'eraᵽe. Waᵽurureka sayieᵽããtirã sanaᵽi'ᵽeraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Sanamaajããraᵽaka be'erõ'õ ᵽãukãrõaᵽi waᵽuru naᵽi'ᵽeraᵽe jiyia sañi'aokaro'si, wĩrõa baemaka saña'mia'si ãrĩwa'ri. I'sia be'erõ'õ, “Sirte wãmeika ᵽõ'sirõ'õrã wĩrõa baeᵽũatarãkareka ᵽuri saweriᵽañarañu”, ãrĩᵽuᵽajoawa'ri, wĩrõa sarã eirũkia sayaᵽãia narueraᵽe mae, waᵽuru jãjia turikoreka. Suᵽa imarĩ wĩrõa baeᵽũataraᵽaka uᵽakaja yija a'raᵽe mae. ");
INSERT INTO tnc_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Suᵽa imarĩ aᵽerĩmi wĩrõa jãjia baetẽatamaka, waᵽurureka imaraᵽaka waruaka riaᵽakiakarã nabareũ'muraᵽe wiibaaᵽañaka sajayaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Aᵽerĩmi ate waᵽurureka imaraᵽaka ᵽãukãrõa, sayaᵽãia, waᵽuru tuarũkia ba'irĩjia riaᵽakiakarã nabareraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ĩ'rãrĩmimarĩa jimarĩ okoa ũmakaka imamaka, tã'ᵽia, aiyakaoka õiberaᵽaka. Suᵽabatirã yijare jãjia wĩrõa eimaka, “Õñia imaberijĩka maime”, yija ãrĩᵽuᵽajoaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Ĩ'rãrĩmimarĩa ba'abekaja yija imaraᵽe. Suᵽa imarĩ i'suᵽaka simamaka ĩawa'ri mi'mirĩkatirã ikuᵽaka Ᵽablote jairaᵽe: —Creta ᵽaᵽitakarã yijairaᵽaka mija yi'ririkareka, ikuᵽaka ba'iaja majũaberijããraᵽe. Suᵽabatirã waᵽuru bitamarĩberijããraᵽaka, waruakaoka ririberijããraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Maekaka ᵽuri mija wayuᵽi'ria'si. Ika waᵽuru ririko'omakaja, ĩ'rĩkaoka makaki riribesarãñuki. ");
INSERT INTO tnc_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ikuᵽaka sime: Ñiᵽamaki Tuᵽarã, kiyaᵽaika uᵽakaja yiyi'ririjayuka, ñami yiᵽõ'irã ángelte kiᵽũatako'o. ");
INSERT INTO tnc_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Yiᵽõ'irã eyatirã, ikuᵽaka yire kibojako'o: “Ᵽablo, mikĩkia'si. Romawejearã eyatirã ĩᵽi César wãjitãji, ‘Oka yire imabeyua’, kire merĩrãñu. Suᵽabatirã Tuᵽarãte mijẽñemaka mire kiã'mitiraᵽe. Suᵽa imarĩ mika waᵽuruᵽi a'yurã nimauᵽatiji tãrĩᵽatarãñurã”, ángelte yire ãrĩko'o. ");
INSERT INTO tnc_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Suᵽa imarĩ okajãjia mija imabe yijeyomarã. Tuᵽarãte yi'riwa'ri “Ángelte bojaika uᵽakaja simarãñu”, ñarĩᵽuᵽajoayu. ");
INSERT INTO tnc_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","I'suᵽaka simako'omakaja, jũmurikarã waᵽuru eirãka ᵽoto torã matuirãñu,— Ᵽablote yijare ãrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ĩ'ᵽakuri jẽrĩtarika seyawa'raᵽe Adriático wãmeika riaᵽakiakareka sayaᵽairõ'õrãja wĩrõa yijare baeᵽũataraᵽaka ruᵽu. I'siñami ñe'metãjirõ'õjĩrã, “Ka'iarã maeyaerã baayu”, waᵽuru tuarimajare ãrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Suᵽabatirã ñutakãrõaᵽi ãta kãrõbaatirã “¿No'ojĩrã ĩki sime?”, ãrĩwa'ri najẽrãbaaraᵽe. Treinta y seis metros rõ'õjĩrã ĩki simaraᵽe. Ñoaᵽañakarã ate najẽrãbaamaka veintisiete metros rõ'õjĩrã ĩki simaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ãtarã eiwa'ri yija ñamia'si ãrĩwa'ri, botarakao wakaika ᵽota ᵽakiaka ñutakãrõa ñoakaᵽi kãrõbaatirã waᵽuru itoᵽeᵽẽ'rõtoᵽi sanaña'metaraᵽe. Waᵽuru meñamaka sabaiᵽarũ ãrĩwa'ri i'suᵽaka nabaaraᵽe. I'suᵽaka baatirã ñojimarĩji sawãrĩrika yaᵽawa'ri Tuᵽarãte najẽñeraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","I'suᵽaka simeje waᵽuru tuarimajare ru'ririka ᵽuᵽajoaraᵽe. Suᵽa imarĩ waᵽuru ᵽũ'earã, wakaika ᵽota ᵽakiaka ña'metaerã nabaayu ãñu uᵽakaja kũmumakarãka nayieña'taraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","I'suᵽaka nabaamaka ĩawãrũwa'ri, surararãka suᵽabatirã niᵽamakireoka ikuᵽaka Ᵽablote bojaraᵽe: —Waᵽuru tuarimajare rurirãkareka, mija tãrĩwãrũbesarãñu,— surararãkare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","I'suᵽaka kẽᵽakã'ã ã'mitiriwa'ri, kũmumakarãka ᵽi'ᵽekoᵽeka nayiita'ruiraᵽe, “Sõñu uᵽakaja sameñaᵽarũ”, ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Bikitojo ñamiji neiᵽuᵽurõ'õ ikuᵽaka Ᵽablote yijare ãrãᵽe: —Mija ba'abe ᵽañakama kũᵽajĩ. Ĩ'ᵽakuri jẽrĩtarika sajaritiyu, wayuᵽi'ᵽaraka, ba'abekaja mija ima. ");
INSERT INTO tnc_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Mae mija ba'abe ᵽañakama kũᵽajĩ. “Jia rikitubaritirã, mija tãrĩrãñu”, ãrĩwa'ri mijare yiba'arũjeyu. Mija wayuᵽi'ria'si. Ĩ'rĩkaoka mijakarã reyabesarãñurã,— Ᵽablote yijare ãrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Suᵽabatirã ᵽan e'etirã, “Jia mibaayu”, Tuᵽarãte kẽrãᵽe yija ĩaraᵽaka wãjitãji. Suᵽabatirã kũᵽajĩ ña'kata'arĩ e'etirã kiba'araᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","I'suᵽaka kibaamaka ĩawa'ri, okajãjia yija jaraᵽe. Suᵽa imarĩ yija imarakamakiji sayija ba'araᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Doscientos setenta y seis rakamaki ᵽo'imaja yija imaraᵽe i'sia waᵽuruᵽi a'raᵽarã. ");
INSERT INTO tnc_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Yija ba'ariyaᵽaraᵽarõ'õjĩrã yija ba'araᵽe. Ba'aweatirã trigo nabareraᵽe, waᵽuru wiibaka jayaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Sawãrãᵽaka ᵽoto waᵽuru tuarimajare jũmurika ĩarikoᵽeriᵽotojo “I'suᵽaka wãmeika sime i'sia jũmurika”, narĩwãrũberaᵽe. I'suᵽaka simako'omakaja jũmuri ritakarã ᵽõ'sia õimaka ĩatirã, “Torã maᵽããye'e”, narĩᵽuᵽajoaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Suᵽa imarĩ wakaika ᵽota ᵽakiaka waᵽuru ñi'aokaro'si mamarĩ naña'metaeka nayiitataraᵽe. Suᵽa imarĩ ĩkirã okowatoᵽekarãja satuika. Suᵽabatirã waᵽuru temarĩkarũkia sarĩ'mekoreka naᵽi'ᵽekoᵽeka nakuteᵽateraᵽe ate sanatemarĩkaokaro'si. Suᵽabatirã wĩrõa eirũkia sayaᵽãia saruᵽurõ'õᵽi imaekato namiataraᵽe. Suᵽa imarĩ ᵽõ'siᵽẽ'rõtorã waᵽuru waawa'raᵽaka mae. ");
INSERT INTO tnc_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Torã sawaawa'raᵽaka ᵽoto koᵽakaja waᵽuru riarijerã eyaerã baaraᵽaka ᵽoto ᵽõ'siarã waᵽuru eitiraᵽe. Suᵽa imarĩ koᵽakaja saᵽũ'erõ'õᵽi ᵽõ'siarã sayairaᵽe. Marãkã'ã baatirã mo'riberijĩka simekã'ãja waᵽuru i'toᵽeᵽẽ'rõtoᵽi jãjia saᵽa'kumaka sawa'riũ'muraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","I'suᵽaka sabaamaka ĩawa'ri, wẽkomarãre najããerã baaraᵽe surararãka. “Nare majããᵽajĩñu, nabariru'ria'si ãrĩwa'ri”, narĩbu'araᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","I'suᵽaka narĩko'omakaja surara ĩᵽamaki ᵽuri Ᵽablote õñia imarika yaᵽaraᵽaki. Suᵽa imarĩ kisurararãkare nare kijããrũjeberaᵽe. —Mija bariwãrũirã wãrũaja bariwa'ritirã riarijerã mija a'ᵽe mae,— kẽrãᵽe waᵽurureka imaraᵽarãte mamarĩ. ");
INSERT INTO tnc_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Suᵽabatirã aᵽerã bariwãrũbeyurãte, —Waᵽuru ᵽãimirãkaᵽi mija a'ᵽe,— kẽrãᵽe. Suᵽa imarĩ ĩ'rĩkaoka riririmarĩaja ka'iarã yija eyaᵽataraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Riarijerã eyatirã, “Malta wãmeika sime ika jũmurika”, yija ãrĩwãrũraᵽe mae. ");
INSERT INTO tnc_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","I'sia ka'iakarã jia yijare baaraᵽarã. Okoa jaraᵽaka imarĩ, jijia simamaka ᵽeka naᵽẽ'araᵽe. I'suᵽaka baatirã, “Mija ᵽekajũᵽe”, yijare narãᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Suᵽa imarĩ ᵽeka ᵽõᵽoa Ᵽablote rẽaraᵽe. I'sia ᵽeka kisĩaraᵽaka ᵽoto ᵽeka jũ'rẽika ru'riwa'ri saᵽi ãñaka ᵽoraᵽaka. Kiᵽitakarã sakã'rĩjĩ'ĩaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Ãñaka kire kukumaka ĩatirã, i'sia ka'iareka imaraᵽarã ikuᵽaka natiyiaja najaibu'araᵽe: —Ᵽo'imajare jããrimaji kimarijiyu ĩ'ĩ. Suᵽa imarĩ riaᵽakiakarã kiriribeᵽakã'ã jiyiᵽuᵽaka moñuko jia ᵽuᵽajoawa'ri ba'iaja kibaaika waᵽa kire koriatarũjeyu mae,— narãᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","I'suᵽaka narĩko'omakaja Ᵽablo ᵽuri ᵽekaõ'toarã ãñaka terataraᵽaki. Dakoaoka kire baaberaᵽaka. ");
INSERT INTO tnc_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ritaja torã imaraᵽarã ᵽuri “Kire saᵽĩᵽirãñu je'e, suᵽabatirã ñojimarĩji kiᵽuᵽaririña'rĩrãñu je'e”, narĩkoᵽeraᵽe. I'sia be'erõ'õ ñoaka ta'akoᵽetirã kijĩrĩbeᵽakã'ã ĩawa'ri, aᵽe uᵽaka naᵽuᵽajoaraᵽe ate: “Majiyiᵽuᵽayeerijayuka ᵽo'imaja ᵽo'iaᵽi ña'rĩjãitirã ketayu mae”, narãᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ᵽeka õ'towã'tarã simaraᵽe ĩ'rãkõ'rĩmato ka'ia jũmurikarã imarã ĩᵽamakirika. Ᵽublio wãmeiki kimaraᵽe iki. Kiwi'iarã yijare e'etoritirã maekarakarĩmi torã yija imaraᵽaka ᵽoto jimarĩ jia yijare kibaaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Torã yija imaraᵽaka ᵽoto Ᵽublio ᵽaki, yoyaka, joᵽirika ᵽitiyika kijĩrĩbayuraᵽe. Kiᵽõ'irã ĩarĩ Ᵽablote a'raᵽe. Kiᵽõ'irã eyatirã Tuᵽarãte kijẽñeraᵽe. Suᵽabatirã kiᵽitaka wãmarĩa imaraᵽaki ᵽemarã kija'aᵽearaᵽaka ᵽoto kijãjiraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","I'suᵽaka kibaamaka ã'mitiriwa'ri, i'sia jũmurikareka aᵽerã wãmarĩa imaraᵽarãte kiᵽõ'irã etaraᵽe. Suᵽa imarĩ wãmarĩa nima o'raᵽaka nareoka. ");
INSERT INTO tnc_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Yijare ã'mitiriᵽẽairã imarĩ, jia yijare nabaaraᵽe. Yija a'rirã baaraᵽaka ruᵽu ritaja yija ba'awa'rirũkia yijare nijiraᵽe dakoa jariwa'ririmarĩaja. ");
INSERT INTO tnc_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Maekarakamaki aiyaka i'sia jũmurikarã yija imaraᵽaka be'erõ'õ a'yaokaro'si waᵽururã yija jãiraᵽe ate. Ᵽu'ea o'yaokaro'si torã tuika simaraᵽe i'sia waᵽuru. Alejandría wãmeirõ'õᵽi i'taeka simaraᵽe. Saᵽũ'erõ'õᵽi, jẽrãka najiyiᵽuᵽayeeika Cástor, suᵽabatirã Ᵽólux ruᵽuko'a uᵽaka baaeka simaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","I'sia waᵽuruᵽi a'ritirã Siracusa wãmeika wejea ᵽaᵽitakarã yija eyaraᵽe. Maekarakarĩmi torã yija imaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Toᵽi Regiowejearã yija eyaraᵽe. Wejerĩrĩkaᵽi wĩrõa baeraᵽaka jia yijare jeyobaaraᵽaka. Suᵽa imarĩ aᵽerĩmiji Ᵽozzuolirã eyatirã torã yija marãᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","I'sia wejeareka aᵽerã Jesúre yi'yurãte yija ĩatõᵽoraᵽe. “Yija ᵽõ'irã ĩ'rãkuri jẽrĩtarika mija tuibe”, yijare narãᵽe. I'sia be'erõ'õ ma'aᵽi yija a'riũ'muraᵽe Romawejearã. ");
INSERT INTO tnc_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Romareka Jesúre yi'yurã yija a'raᵽaka õrĩweitirã nimaraᵽe. Yoe naro'si simako'omakaja ma'arã yijare torirĩ netaraᵽe. Ĩ'rãrimarã, Foro de Aᵽio wãmeika wejearã yijare toraᵽarã. Suᵽabatirã aᵽerã Tres Tabernas wãmeika wejearã yijare toraᵽarã. Torã nare ĩatõᵽotirã, “Jia mibaayu”, Tuᵽarãte kẽrãᵽe Ᵽablo. Suᵽa imarĩ jia jĩjimakaᵽi okajãjia kimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Romarã yija eyaraᵽaka be'erõ'õ wẽkomaka imariwi'iarã Ᵽablote nataberaᵽe. Kiyaᵽaika uᵽakaja kiro'siji wi'iarã kire nimarũjeraᵽe. Torã ĩ'rãrĩmi uᵽakaja ĩ'rĩka surara kire tueroyiraᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Keyaeka be'erõ'õ maekarakarĩmireka judíotatarã imatiyarimajare Ᵽablote akarũjeka. Narẽrĩᵽataeka ᵽoto ikuᵽaka nare kibojaeka: —Yijeyomarã, dikaoka ba'iaja judíotatarãte baaberaᵽaki yi'i. Mañekiarãte baaroyikakakaoka ba'iaja jaiberaᵽaki yi'i. I'suᵽaka yibaaberiko'omakaja matatarã Jerusalénrã yire nañi'araᵽe. I'sia be'erõ'õ surara ĩᵽamakite Cesarearã yire ᵽũataraᵽe, “Oka kire ima, oka kire imabeyua”, ãrĩwa'ri Romakarãre yire jẽrĩaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Yire jẽrĩatirã yire ja'atarika nayaᵽakoᵽeraᵽe, “Dika oka mire imabeyua. Suᵽa imarĩ mire jããriatarika imabeyuaoka”, ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","I'suᵽaka simako'omakaja matatarã yire ja'atarika yaᵽaberaᵽarã. Suᵽa imarĩ “Ñiᵽamaki Romakaki, ‘Oka miro'si ima, oka mire imabeyua’, yire kẽrĩrika yiyaᵽayu”, ñarãᵽe. Roma ĩᵽamaki wãjitãji matatarãte yokabaaokaro'simarĩa i'suᵽaka ñarãᵽe. ");
INSERT INTO tnc_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Suᵽa imarĩ i'sia mijaka jaiokaro'si, mijare yakarũjeᵽũako'o. Judíotatarãte ta'aroyiki Jesucristo kime. Kire ã'mitiriᵽẽaiki ñimamaka, ᵽerumijiaᵽi ᵽi'ᵽekaki ñime,— Ᵽablote ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","I'suᵽaka kẽᵽakã'ã ikuᵽaka kire narĩka: —Oka mire imakaka ᵽaᵽera Judeaka'iakarãre ᵽũataika e'etoribeyurã yija. Matã'omaja toᵽi i'taraᵽarãoka dakoa mireka ba'iaja jaietaberaᵽarã. ");
INSERT INTO tnc_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","“Jiamarĩa sime ᵽo'imajare Jesúre ã'mitiriᵽẽarika”, ãrĩrikakaka oyiaja yija ã'mitiyu. Suᵽa imarĩ ika mamaka ᵽuᵽajoarikakaka, mi'i ᵽuri, ¿marãkã'ã samiᵽuᵽajoayu? I'siakaka yija ã'mitiririyaᵽayu,— kire narĩka. ");
INSERT INTO tnc_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Suᵽa imarĩ “I'sirĩmi marẽrĩye'e je'e”, narĩka. I'suᵽaka ãrĩweatirã naᵽibika. Najẽ'rãᵽããekarĩmi seyaeka ᵽoto rĩkimarãja ᵽo'imajaka jeyoariwa'ritirã neyaeka Ᵽablote imaekarõ'õrã. Narẽᵽakã'ã ĩatirã, “Ikuᵽaka Jesúre yi'yurãte jã'mebaraka Tuᵽarãte nare imaruᵽutarãñu”, ãrĩwa'ri Ᵽablote bojaeka. Bikitojo ñamiji kibojaũ'mueka, rã'itakarã kibojatiyika. Moisés imaroyikakite o'oekakaka suᵽabatirã Tuᵽarãro'si bojaĩjirimajare o'oekakakaoka kibojaeka “Jesúre na'mitiriᵽẽarũ”, ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Ĩ'rãrimarã Ᵽablote jaika jia ã'mitirikarã. Aᵽerã ᵽuri sã'mitiriᵽẽaberikarã. ");
INSERT INTO tnc_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Suᵽa imarĩ ĩ'rĩka uᵽakaja ᵽuᵽajoaberiwa'ri nokabojiũ'mueka. Naᵽibirã baaeka ruᵽu “Ĩ'rãrimarã yire ã'mitiririyaᵽabeyurã”, ãrĩᵽuᵽajoawa'ri, ikuᵽaka Ᵽablote nare bojaeka: —Isaíaᵽi ãrĩwa'ri ikuᵽaka wãjia Esᵽíritu Santore bojaeka mañekiarãte: ");
INSERT INTO tnc_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","“Ikuᵽaka judíotatarãte yiro'si mija bojaᵽe: ‘Ĩ'rãkurimarĩa yibojaika ã'mitirikoᵽeriᵽotojo, samija õrĩᵽũawãrũbesarãñu. Yibaaroyika ĩakoᵽeriᵽotojo, “I'suᵽaka Tuᵽarãte baayu”, mija ãrĩwãrũbesarãñu.’ ” ");
INSERT INTO tnc_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ikuᵽakaoka Tuᵽarãte ãrĩka Isaíare: “Yirika yi'ririyaᵽabeyurã imarĩ, sõrĩᵽũawãrũbeyurã nime. Suᵽa imarĩ na'mukoᵽea natãteyu. Suᵽabatirã naᵽĩᵽiyu, dakoa ĩakoreka. Yirika nayi'riyaᵽarikareka, nare ñañua, nare yibojaikaoka norĩᵽũajããeka. I'suᵽaka imawa'ri, ba'iaja nabaaika naja'atarikareka, nare yitããjããeka”, Tuᵽarãte ãrĩka Isaíare. ");
INSERT INTO tnc_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","Maekakaoka mija judíotatarã Tuᵽarãrika bojariroka ã'mitiriyaᵽabeyurã ruᵽu. Suᵽa imarĩ Tuᵽarãte ᵽo'imajare tããrimajaroka, judíotatamarĩrã imarãte bojarika simarãñu. Ĩ'rã ᵽuri sã'mitiritirã jĩjimaka sayi'rirãñurã,— Ᵽablote nare ãrĩka. I'suᵽaka kẽᵽakã'ã ã'mitiriwa'ri, natiyiaja okatotobaraka judíotatarãte a'rika. ");
INSERT INTO tnc_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Ĩ'ᵽakuri wejejẽ'rãka jia Ᵽablote torã imaeka. Wi'iareka kima waᵽa waᵽaĩjibaraka kimaeka. Torã kire ĩarĩ etaroyikarã rakamakiteje jia ke'etoriroyika. ");
INSERT INTO tnc_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Kĩkirimarĩaja, “Ikuᵽaka Jesúre yi'yurãte jã'mebaraka Tuᵽarãte nare imaruᵽutarãñu mae”, ãrĩwa'ri nare kibojaroyika. Suᵽabatirã maiᵽamaki Jesucristorika kiwãrõroyika. I'suᵽaka bojabaraka Ᵽablote imaeka ᵽoto makioka “Jesús majaroka miwãrõa'si”, kire ãrĩberika. I'tojĩrãja sime ruᵽu.");
INSERT INTO tnc_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","¿Yaje mija ime Corintokarã? Yi'i Ᵽablo, Sóstenes majeyomakika, “Jia nimarũ”, mijare yija ãrĩᵽũayu ika ᵽaᵽeraᵽi. Kiyaᵽaeka uᵽakaja aᵽóstol ñimaokaro'si Tuᵽarãte yire wã'maeka. Suᵽa imarĩ Jesucristorika bojariroka wãrõtaᵽaiki ñime. ");
INSERT INTO tnc_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Mija Corintowejeakarãoka Tuᵽarãte jiyiᵽuᵽaka õñurã imarĩ, jia kire baawa'ri mija rẽrĩrijayu. Jesucristorirã mija imamaka Tuᵽarãte mijare wã'maeka kirirã mija imaokaro'si. I'suᵽaka kibaaeka “Ba'iaja baabekaja nimarũ”, ãrĩwa'ri. I'suᵽaka oyiaja sime ritaja wejeareka Jesucristore ã'mitiriᵽẽairãro'si. Maiᵽamaki kima uᵽakaja ritajaro'sioka niᵽamaki kime Jesucristo. ");
INSERT INTO tnc_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Maᵽaki Tuᵽarã, suᵽabatirã maiᵽamaki Jesucristoreoka “Jia nare mija baabe”, ãᵽaraka mijaro'si nare yija jẽñerijayu. I'suᵽakaja yija baayu jĩjimaka ᵽuᵽaᵽaraka mijare nimarũjeokaro'si. ");
INSERT INTO tnc_vpl VALUES ("C11_4","076_1_4","1CO","1","4","5","Jesucristorirã mija imamaka jia Tuᵽarãte mijare jeyobaarijayu. I'suᵽaka kibaamaka, “Jia mibaayu Tuᵽarã”, kire ñarĩrijayu. Suᵽa imarĩ kioka jia mija jaiokaro'si, suᵽabatirã kirikakaka jia mija õrĩwaᵽu'awãrũokaro'si mijare kijeyobaayu. I'suᵽakajaoka ritaja kiyaᵽaika uᵽakaja mija baawãrũokaro'si kirika Tuᵽarãte mijare ja'atayu Jesúrirã mija imamaka. ");
INSERT INTO tnc_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","I'suᵽaka mijaro'si kibaaeka simamaka, “Jesucristorika bojariroka yijare nabojaeka rita sime”, mija ãrĩwãrũeka. ");
INSERT INTO tnc_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Suᵽa imarĩ maiᵽamaki Jesucristore etarũkirĩmi ta'abaraka mija ima ᵽoto jia mijare jeyobaarijaᵽaraka Tuᵽarãte ime. I'suᵽaka jia mijare kibaamaka dakoa jariwa'ribeyua mijaro'si, kirika mija ba'irabewãrũrijayaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","I'suᵽakajaoka Jesucristore mija ã'mitiriᵽẽarija'ata'si ãrĩwa'ri Tuᵽarãte mijaka imajiᵽarãñu. Suᵽa imarĩ maiᵽamaki Jesucristore ᵽe'rietarãñurĩmi “Oka nareka ima”, maki mijareka ãrĩwãrũbesarãki. ");
INSERT INTO tnc_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Suᵽa imarĩ “ ‘Ikuᵽaka yibaarãñu’, kẽrĩka uᵽakaja Tuᵽarãte mare baarãñu”, ãrĩwãrũirã mija ime. Suᵽabatirãoka iki Tuᵽarãja imaki Kimaki Jesucristo Maiᵽamakika jia jĩjimaka maimabu'arijarirã mare wã'maekaki. ");
INSERT INTO tnc_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Mija ã'mitiᵽe yijeyomarã. Jesucristore ᵽũataekaki ñima imarĩ ikuᵽaka mijare ñañu: Ĩ'rĩkate ᵽuᵽajoairokaᵽiji mija imabe, rakaka ᵽuᵽajoabekaja. I'suᵽaka mija baarãkareka ĩ'rĩka ta'iarãja mija imarãñu. ");
INSERT INTO tnc_vpl VALUES ("C11_11","076_1_11","1CO","1","11","12","“Rakakaja ᵽuᵽajoabaraka Corintokarãre ime”, Cloe tã'omajare yire ãñu. “ ‘Ᵽablote yija ã'mitiriᵽẽayu’, ‘Yija ᵽuri Aᵽolore ã'mitiriᵽẽairã.’ Suᵽabatirã ‘Ᵽedrote ã'mitiriᵽẽairã yija ime’, ãñurã, aᵽerã ‘Jesúre yija ã'mitiriᵽẽayu’, ãñurã naro'sijioka imarã”, ãrĩwa'ri yire nabojayu. ");
INSERT INTO tnc_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","¿Dako baaerã i'suᵽaka mija jaibu'ayu je'e? “Cristo ĩ'rĩkaja kime Maiᵽamaki”, ãñurã imariᵽotojo “¿Rĩkimarãja maĩᵽarimarãre ime”, ãñurã uᵽaka mija ime bai je'e? ¿Yi'i bai yaᵽua tetaekarã mijaro'si reyaĩjiekaki? “¿Ᵽablorirã yija imaye'e”, ãᵽaraka ruᵽuko'a mija jũjerũjeka bai je'e? Jẽno'o Jesúrirã imawa'ri ruᵽuko'a mija jũjerũjeka. ");
INSERT INTO tnc_vpl VALUES ("C11_14","076_1_14","1CO","1","14","15","Mija ᵽõ'irã imarã, Crisᵽo suᵽabatirã Gayore ruᵽuko'a yijũjeraᵽe. Saᵽi ãrĩwa'ri “Kiuᵽaka oyiaja ᵽuᵽajoairã yija imamaka, Ᵽablote yijare ruᵽuko'a jũjeka”, mija ãñaokaro'simarĩa simaraᵽe. Suᵽa imarĩ ĩ'ᵽarãte takaja ruᵽuko'a yijũjeka simamaka, “Jia sime yiro'si”, ñarĩᵽuᵽajoayu. ");
INSERT INTO tnc_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","(Ã'ã, mae aᵽea ñoñu. Estéfanas rĩrãre ruᵽuko'a yijũjeka. I'suᵽaka baaekaki ñimako'omakaja aᵽerã imabeyurã ruᵽuko'a yijũjekarã ñoñuareka). ");
INSERT INTO tnc_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","“Ruᵽuko'a mijũjetaᵽaaᵽe”, ãrĩwa'rimarĩa Jesúre yire ᵽũataeka. “Ᵽo'imajare tããrimaji kime Cristo”, ãᵽaraka “Yirika bojariroka mibojataᵽaᵽe”, ãrĩwa'ri yire kiᵽũataeka. Jiyurika yoka ã'mitiririjiyuwa'ri ᵽo'imajare yire yi'rirũ ãrĩwa'rimarĩa Jesúrika bojariroka yiwãrõyu. Yiᵽuᵽaka yire ãñu uᵽaka jiyurika na'mitiyuaᵽitakaja nare yiwãrõrikareka “Mare tããwa'ri yaᵽua tetaekarã Cristore reyaeka”, ãrĩrika õrĩbeyurã ᵽo'imajare imajããeka. ");
INSERT INTO tnc_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Suᵽa imarĩ Jesucristore yaᵽua tetaekarã naᵽatakĩaekakaka majaroka ã'mitirikoᵽetirã, “Waᵽuju õrĩᵽũamarĩ oka sime”, nañu ba'iaja imarika tiyibeyurõ'õrã a'rirũkirã. Tuᵽarãte yi'riwa'ri kiᵽõ'irã a'rirũkirã ᵽuri, “Tẽrĩwa'ribaji imaki imarĩ, ika majarokaᵽi Tuᵽarãte mare tããrãñu”, ãñurã maime. ");
INSERT INTO tnc_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Mija ĩabe, ikuᵽaka sabojayu mamarĩji kiro'si o'orimajire Tuᵽarã majaroᵽũñurã o'oeka: “ ‘Jia ᵽuᵽajoarika õñurã imarĩ, jiitaka sime yija wãrõika’, nañua dako waᵽamarĩa ñamajĩ naro'si sayijarirũjerãñu. Jia naᵽuᵽajoakoᵽeika ñiariᵽe'yorãñu”, Tuᵽarãte ãrĩka o'oeka ᵽũñurã. ");
INSERT INTO tnc_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Jesúre reyaekaᵽi ãrĩwa'ri bikija sabojatika uᵽakaja sajarika. Suᵽa imarĩ jia ᵽuᵽajoarika õñurã, noñuaᵽi Tuᵽarãte õrĩwãrũbeyurã. I'suᵽakajaoka Moisés imaroyikakite jã'meka wãrõrimaja, saᵽi natããrũkimarĩa sime. Suᵽabatirã naᵽuᵽaka nare ãñu uᵽakaja ᵽuᵽajoatirã jia jaiwãrũrijayurãoka, saᵽi Tuᵽarã ᵽõ'irã eyawãrũbesarãñurã. I'suᵽaka ᵽuᵽajoairãre dakoa waᵽamarĩa naᵽuᵽajoaika jarirũjeiki kime Tuᵽarã. ");
INSERT INTO tnc_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Ritaja jẽrãko'awãrũᵽataiki imarĩ, “Naᵽuᵽajoaikaᵽi yire õrĩbesarãñurã ᵽo'imaja”, Tuᵽarãte ãrĩka. I'suᵽaka simamaka ikuᵽaka simarika kiyaᵽaeka: Kirika bojariroka yi'yurãte ba'iaja jũarũkia imakoᵽekareka Tuᵽarãte nare tããeka, “Waᵽuju ᵽakiriroka sime Jesucristorika bojariroka”, kire ã'mitiriᵽẽabeyurãte ãrĩko'omakaja. ");
INSERT INTO tnc_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","“Karemarĩa rita ima Ᵽablote yijare bojarikareka, maikoribeyua Tuᵽarãte jeyobaaikaᵽi yijare kibaabeajããeka”, judíotatarãte ãrĩᵽuᵽajoayu. Judíorãkamarĩrã ᵽuri, “Yija õñumijikakamarĩa Jesucristorika bojariroka imamaka, sayija yaᵽabeyu”, ãrĩᵽuᵽajoairã. ");
INSERT INTO tnc_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Tuᵽarãte yi'yurã ᵽuri, “Maro'si yaᵽua tetaekarã Jesúre reyaeka”, ãñua majaroka bojarijayurã maime. Samabojarika ã'mitiririyaᵽabeyurã imarĩ, judíotatarãte saᵽe'yoyu. Judíotatamarĩrãoka sã'mitiritirã, “Waᵽuju õrĩᵽũamarĩ oka sime”, nañu naro'si. ");
INSERT INTO tnc_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","I'suᵽaka narĩko'omakaja ĩ'rãrimaki judíorãka, suᵽabatirã judíorãkamarĩrãoka Tuᵽarãte wã'maekarã imarĩ, Jesúrika bojariroka ã'mitiritirã sayi'yurã maime. Suᵽa imarĩ “Cristoᵽi ãrĩwa'ri mare tããekaki imarĩ, ritaja tẽrĩwa'ribaji kime Tuᵽarã. Suᵽabatirãoka ritaja õñuka kime”, marĩᵽuᵽajoarijayu. ");
INSERT INTO tnc_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Tuᵽarã õrĩwãrũriroka õrĩwãrũbeyurã imarĩ, “Kimakire reyaerã Tuᵽarãte ᵽũatamaka waᵽuju õrĩᵽũabekaja kibaaeka”, nañu kire ã'mitiriᵽẽabeyurã. “Dika jariwa'ririmarĩa yija õñu”, narĩkoᵽeko'omakaja, norĩkoᵽeika tẽrĩwa'ribaji sime Tuᵽarãte õñua. I'suᵽakajaoka, “Kimakire reyaerã kiᵽũatamaka tẽrĩrimarĩka kimaeka”, nañu. I'suᵽaka narĩko'omakaja “Tẽrĩribajirã yija ime”, narĩkoᵽeika i'suᵽakamarĩa sime. Kimakire ᵽũatawa'ri nare tẽrĩwa'ribaji kimaeka. ");
INSERT INTO tnc_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Mija ã'mitiᵽe yijeyomarã. “Kũᵽajĩjikaja õrĩᵽũairã nime”, ᵽo'imajare mijareka ãrĩko'omakaja Tuᵽarãte mijare wã'maeka. Suᵽabatirã kũᵽajĩjikajaoka mijakarã ᵽo'imajare jã'merimaja imaeka. I'suᵽakajaoka nimaeka imatiyarimaja makarã mija watoᵽekarã. ");
INSERT INTO tnc_vpl VALUES ("C11_27","076_1_27","1CO","1","27","28","Tuᵽarãte mijare wã'maeka “Jia õrĩᵽũabeyurã nime”, kire õrĩbeyurãre mijareka ãrĩko'omakaja. “Jia õñurã yija ime”, ãrĩkoᵽekarãte “Ba'iaja maᵽuᵽajoayu”, narĩwãrũrũ ãrĩwa'ri, i'suᵽaka kibaaeka. Suᵽabatirã i'suᵽakajaoka baawa'ri “Imatiyabeyurã nime”, narĩkarãte Tuᵽarãte wã'maeka kirirã nimaokaro'si. I'suᵽaka kibaaeka “Tẽrĩrã yija ime”, ãrĩkoᵽekarãte wayuᵽi'rirũ ãrĩwa'ri. Suᵽabatirã ᵽo'imajare jiyiᵽuᵽaka õrĩbeyurãte kiwã'maeka, Tuᵽarãte yi'ribeyurãte jiyiᵽuᵽayeeikakaka “Dako waᵽamarĩa sime”, ᵽo'imajare ãrĩwãrũokaro'si. ");
INSERT INTO tnc_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","I'suᵽaka baaiki Tuᵽarãte imamaka, kĩaika wãjitãji, “Imatiyaiki ñimamaka, yire miwã'maeka”, ãrĩᵽuᵽajoarika imabeyua. ");
INSERT INTO tnc_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","I'suᵽaka simamaka Tuᵽarãᵽi ãrĩwa'ritakaja Jesúre yi'yurã majayu. Kimakiᵽi ãrĩwa'ri mare kitããeka õñurã imarĩ, “Ritaja ᵽuᵽaiki kime”, marĩwãrũyu. Cristore reyaekaᵽi ãrĩwa'ri ba'iaja mabaakoᵽeka waᵽakoyika simamaka jiirã maime kiñakoareka mae. Suᵽa imarĩ kirirã mare jarirũjekaki imarĩ, ba'iaja mabaako'omakaja saja'atabaraka jiaᵽiji kika imarijayurã Tuᵽarãte mare imarũjeyu. ");
INSERT INTO tnc_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","I'suᵽaka maro'si kibaaeka simamaka, ikuᵽaka sabojayu kioka o'oeka ᵽũñurã: “Maᵽuᵽayariji maimakaka jĩjimaka bojabekaja Tuᵽarãte maro'si baarijayuakaka takaja jĩjimakaᵽi mabojarijariye'e”, ãrĩwa'ri sabojayu. ");
INSERT INTO tnc_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Mija ᵽõ'irã yeyaraᵽaka ᵽoto Tuᵽarãrika bojariroka, ᵽo'imajare ã'mitirikoribeyua mijare yiwãrõũ'muraᵽaka jia mija õᵽe yijeyomarã. “ ‘Jiitaka õñuka kime’, yireka narĩrũ”, ãrĩwa'rimarĩa mijare sayiwãrõraᵽe. I'suᵽaka jaibekaja, jia mija õrĩwaᵽu'airokaᵽi mijare yiwãrõraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Mija ᵽõ'irã ñimaraᵽaka ᵽoto “Yaᵽua tetaekarã Jesúre reyaekakaka takaja nare yibojaye'e”, ãrĩwa'ri mijare yibojaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Mija ᵽõ'irã yeyaraᵽaka ᵽoto “Nare bojawaᵽu'atawãrũberijĩki ñime”, ãrĩwa'ri wãjiaja yitararaᵽe. ");
INSERT INTO tnc_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Cristore reyaekakaka mijare yibojaraᵽaka “Jia õñurã yija ime”, ãñurãte jairokaᵽimarĩa mijare yibojaraᵽe. “ ‘Ᵽablote jia bojaika simamaka Cristore yija ã'mitiriᵽẽayu’, narĩrũ”, ãrĩwa'rimarĩa mijare sayibojaraᵽe. I'suᵽaka imabekaja, Esᵽíritu Santorikaᵽi maikoribeyua mijare yibaabearaᵽaka ĩawa'ri yibojaraᵽaka mija ã'mitiriᵽẽaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","I'suᵽaka simamaka jia jẽrãko'airã uᵽaka jiaᵽi yijaiiroka mija ã'mitiriᵽẽarikoᵽakaja Tuᵽarãrika ĩatõᵽowa'ri Jesucristore mija yi'ririka yiyaᵽaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Suᵽa simako'omakaja jía ᵽuᵽaka yija wãrõyu Jesucristorika jia õñurãte. Kire ã'mitiriᵽẽabeyurã ᵽuri, suᵽabatirã niᵽarimarã naro'siji, naᵽuᵽamiji tĩᵽikaᵽi najaika uᵽaka yija wãrõbeyu. Niᵽarimarãre reyarãñurĩmi nakaja saririrãñu norĩkoᵽeika. ");
INSERT INTO tnc_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","I'suᵽaka simamaka Tuᵽarãrikaᵽi mijare yija wãrõyu. Ika wejea kiᵽo'ijiaerã baaeka ruᵽubajirã, “Ikuᵽaka baatirã ᵽo'imajare yitããrãñu, suᵽabatirã jiitakaja nare yibaarãñu”, kẽrĩtika. Ruᵽu i'siroka ᵽo'imajare Tuᵽarãte õrĩrũjeberika imakoᵽeika nare yija wãrõyu. ");
INSERT INTO tnc_vpl VALUES ("C12_8","076_2_8","1CO","2","8","9","Iroka i'sia ni'i ĩ'rĩkaoka ĩᵽarimarãkaki õrĩwaᵽu'abeyua. Norĩwaᵽu'arikareka Maiᵽamaki tẽrĩrikaja imatiyaikite yaᵽua tetaekarã najããberijããeka. Iroka norĩwaᵽu'aberiko'omakaja, ikuᵽaka kiro'si bojaĩjirimajite o'oekakaka morĩye'e: “Jĩjimakaᵽi kire õñurãte jia imarũkia Tuᵽarãte jieweitika ᵽo'imajare ĩakoribeyuakaka. Suᵽabatirã aᵽekurioka naᵽuᵽajoabeyua, i'suᵽakajaoka na'mitirikoribeyua”, sabojayu Tuᵽarã majaroka o'oeka ᵽũñurã. ");
INSERT INTO tnc_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","I'suᵽaka ᵽo'imajare õrĩberika simako'omakaja, maekaka ᵽuri sayija õñu Esᵽíritu Santore yijare sõrĩrũjemaka. I'suᵽaka Esᵽíritu Santore baayu dakoa jariwa'ririmarĩa õñuka imarĩ. Suᵽa imarĩ ritaja Tuᵽarãte ᵽuᵽajoaimiji ᵽariji õrĩᵽataiki kime. ");
INSERT INTO tnc_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Ᵽo'imaja matiyiaja, “Iki i'suᵽaka ᵽuᵽajoaiki mae”, ãrĩᵽuᵽajoawãrũbu'abeyurã maime. I'suᵽaka imarã maimamaka, ĩ'rĩka ᵽo'imajire ᵽuᵽajoaika, ĩ'rĩkaja kiõrĩrũkia sime. I'suᵽakajaoka sime Esᵽíritu Santoro'si ĩ'rĩkaja Tuᵽarãte ᵽuᵽajoaika ritaja kiõñua. ");
INSERT INTO tnc_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Jesúre ã'mitiriᵽẽabeyurã naro'siji naᵽuᵽamiji tĩᵽikaᵽi nabojakoᵽeika ã'mitiriᵽẽabeyurã yija ime. Esᵽíritu Santore wãrõika takaja yija ã'mitiriᵽẽayu. Jia Tuᵽarãte mare ja'ataekakaka morĩwãrũerã Esᵽíritu Santore maro'si kiᵽũataeka. ");
INSERT INTO tnc_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","I'suᵽaka simamaka Esᵽíritu Santore yijare wãrõikaᵽi yija jaiyu. Kire ã'mitiriᵽẽairã imarĩ, yijare kijeyobaaikaᵽi aᵽerã kire ã'mitiriᵽẽairãte yija wãrõwaᵽu'atayu. Yija ᵽuᵽajoaimiji tĩᵽikaᵽimarĩa wãrõrimaja yija ime. ");
INSERT INTO tnc_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Tuᵽarãte nayi'ribeᵽakã'ã Esᵽíritu Santore nare ña'rĩjãiberikarã ᵽuri, kijeyobaaikaᵽi nare yija bojaika ã'mitiriwãrũbeyurã. “Waᵽuju õrĩᵽũaberi oka sime”, narĩᵽuᵽajoayu. ");
INSERT INTO tnc_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Esᵽíritu Santore nare ña'rĩjãikarã ᵽuri ᵽo'imajare imarijayua ĩatirã, “Ikuᵽaka sime jia baarika, ika ᵽuri ba'iaja baarika ima”, ãrĩᵽuᵽajoawãrũirã. Jesúre yi'ribeyurã ᵽuri Esᵽíritu Santore ña'rĩjãiberikarã imarĩ, “I'suᵽaka ba'iaja nabaayu”, ĩ'rĩkaoka ãrĩberijĩki yijareka. ");
INSERT INTO tnc_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","I'suᵽaka mijare yo'oᵽũayu ikuᵽaka Tuᵽarã oka ᵽũñu o'oekarã sabojaika simamaka: “Maiᵽamaki Tuᵽarãte ᵽuᵽajoaika maki õrĩbeyuka. I'suᵽakajaoka maki kire wãrõberijĩki”, ãrĩwa'ri sabojayu Tuᵽarã oka ᵽũñu. I'suᵽaka simako'omakaja Cristore ᵽuᵽajoaimijikakaᵽi maᵽuᵽajoarijayu Esᵽíritu Santore mare ña'rĩjãikarã imarĩ. ");
INSERT INTO tnc_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Mija ã'mitiᵽe yijeyomarã. Mija ᵽõ'irã ñimaraᵽaka ᵽoto aᵽerõ'õkarã Esᵽíritu Santore ña'rĩjãitikarãte yiwãrõraᵽaka uᵽakamarĩa mijare yiwãrõraᵽe. Tuᵽarãte jia yi'riwãrũbeyukajirã mija imamaka, mijaro'siji mija ᵽuᵽamiji ba'ia tĩᵽikarã mija imaraᵽaka imarĩ me'rãka wãrõũ'muika uᵽaka Cristorika mijare yiwãrõraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","I'suᵽaka mija imaraᵽaka simamaka jia Jesucristore yi'yurãte õñuakaka mijare yiwãrõberaᵽe ruᵽu. Maekakaoka i'suᵽakaja ka'wisikakaka mijare yiwãrõwãrũbeyukaji ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","I'suᵽaka mijare ñañu Tuᵽarãte õrĩbeyurãte baaika uᵽakaja baarika yaᵽairã mija ime ruᵽu ãrĩwa'ri. Ã'mitirikõrĩ je'e. Mija tiyiaja oakiᵽaraka mija jaiyuyebu'arijayu. I'suᵽaka mija imamaka, ĩatirã, “Esᵽíritu Santore ña'rĩjãiberikarã uᵽaka ᵽuᵽajoawa'ri nayaᵽaika uᵽakaja nabaariyaᵽayu”, mijareka ñañu. ");
INSERT INTO tnc_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","I'suᵽaka imawa'ri, “Ᵽablote ã'mitiriᵽẽairã imarã yija ᵽuri”, ĩ'rãrimarãre ãᵽakã'ã, “Jẽno'o, Aᵽolore yi'yurã yija ᵽuri”, ãᵽaraka mija ãrĩbu'arijayu. I'suᵽaka mija imamaka, Tuᵽarãte yi'ribeyurãte baaika uᵽakaja mija baarijayu ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Yi'i Ᵽablo, Aᵽoloᵽitiyika Tuᵽarãrika ba'iraberimaja yija ime. I'suᵽaka simamaka, yija wãrõraᵽaka yi'riwa'ri Jesúre mija ã'mitiriᵽẽaraᵽe. “Ikuᵽaka rakakaja baarimaja mija imarãñu”, ãrĩwa'ri Maiᵽamakire yijare jã'meka uᵽakaja yija ba'irabeyu. ");
INSERT INTO tnc_vpl VALUES ("C13_6","076_3_6","1CO","3","6","7","Yi'i mijare mamarĩ wãrõũ'muraᵽaki. Yibe'erõ'õ Aᵽolo i'suᵽakajaoka mijare wãrõrijaraᵽaki. I'suᵽaka simako'omakaja Tuᵽarã ĩ'rĩkaja imatiyaiki imarĩ, Jesúre yi'yurã mijare jarirũjetirã, saᵽi jia kirika mija õrĩmirĩrĩkawa'yaokaro'si jia mijare jeyobaarijayuka. I'suᵽaka kimamaka, mamarĩ kirika bojariroka aᵽerãte wãrõrimaja, sabe'erõ'õᵽi sabojawaᵽu'atarimajaoka imatiyabeyurã imarã. ");
INSERT INTO tnc_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Tuᵽarãrika bojariroka mamarĩ wãrõrimaja, sabe'erõ'õᵽi bojawaᵽu'atarimajaka ĩ'rãtijiji ba'irabeirã nime. Kirika naba'irabekamijikaka kiõñua simamaka sawaᵽa jia Tuᵽarãte nare baarãñu. ");
INSERT INTO tnc_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Yi'i, Aᵽoloᵽitiyika ĩ'rĩka uᵽakaja ᵽuᵽajoatirã Tuᵽarãrika takaja ba'iraberimaja yija ime. Kirirã mija imamaka, mija ᵽõ'irã Tuᵽarãte yijare ᵽũataeka. ");
INSERT INTO tnc_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Suᵽa imarĩ jia yire jeyobaatirã, mamarĩtaka kirika bojariroka mijare yiwãrõũ'muerã Tuᵽarãte mija ᵽõ'irã yire ᵽũataeka. Sabe'erõ'õᵽi aᵽerã mijare sawãrõrimaja imarã mae. Jia wãjia ᵽuᵽajoabaraka sanawãrõrijarirãkareka jia simarãñu. ");
INSERT INTO tnc_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","I'suᵽaka simamaka ikuᵽaka ãᵽaraka mamarĩ mijare yiwãrõũ'mueka: “Jesucristoᵽi Tuᵽarãte mare tããyu”, ãᵽaraka mijare yiwãrõraᵽe. Aᵽeuᵽakaᵽi Tuᵽarãte mare tããrũkia maki mijare wãrõberijĩki. ");
INSERT INTO tnc_vpl VALUES ("C13_12","076_3_12","1CO","3","12","13","I'suᵽaka simako'omakaja ĩ'rãrimarã imarã wãjimiji Tuᵽarãrika bojariroka wãrõruᵽutairã. Aᵽerã ᵽuri kirika wãrõrimaja imariᵽotojo i'suᵽakamarĩa baairã. Cristore wã'marãñurĩmi, wããrõ'õrãja “Ika jia ima, ika ᵽuri jiamarĩa ima mirãkiyu”, ãᵽaraka kirika maba'irabeka mirãka jia ĩatiyarĩji sakĩarãñu marãkã'ã sime ãrĩwa'ri. Ĩakõrĩ je'e. Wejejẽ'rãkaja simaokaro'si jiyiakaka wi'ia mabaajĩñu. Jiamarĩakaka samabaajĩka ᵽuri, wejejẽ'rãkaja simaberijĩñu. Wããrõ'õrãja “Jiamarĩakaka wi'ia nabaaraᵽe”, ᵽo'imajare ãrĩrãñu. ");
INSERT INTO tnc_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Jia ᵽo'imajare nawãrõeka mirãka kĩarãkareka ᵽuri, “Jia sime”, kẽrĩrãñu. Suᵽa imarĩ sĩatirã jia sawaᵽa Cristore nare baarãñu. ");
INSERT INTO tnc_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Ᵽo'imajare jia wãrõberikarãte ba'irabekoᵽeka ĩatirã ᵽuri “Jiamarĩa sime”, kẽrĩrãñu. Suᵽa imarĩ naba'iraberiwaᵽa tõᵽobeririᵽotojo, Cristoka imarũkirã nimarãñu imarika. Ã'mitirikõrĩ je'e: ikuᵽaka sime: Wi'iba'iᵽi kiwi'ia oomaka, kiru'yu uᵽaka imarã nimarãñu. Ritaja kiwi'iareka ima ooᵽatariᵽotojo saba'iᵽi ᵽuri ru'riᵽorikaki imarĩ, tãñuka. I'suᵽaka simarãñu wãjimijiᵽi wãrõberikarãro'si. ");
INSERT INTO tnc_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Esᵽíritu Santore ña'rĩjãikarã imarĩ, mija watoᵽekarã Tuᵽarãte imamaka, jiyiᵽuᵽaka kire õrĩriwi'i uᵽaka torã mija ime. ¿I'siakaka õrĩbeyurã mija ime bai je'e? ");
INSERT INTO tnc_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Tuᵽarãka imarã maimamaka, ba'iaja baabekaja maimarika kiyaᵽayu. Suᵽa imarĩ ĩ'rãrimarãre rukubaka wãrõikaᵽi jiamarĩa Jesúre yi'yurãre nimabu'arũjeika ᵽareaja ba'iaja Tuᵽarãte nare jũarũjerãñu. ");
INSERT INTO tnc_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Mija ᵽuᵽakarãja ᵽakirimaja mija jaria'si. Tuᵽarãte yi'riᵽe'yobaraka naro'siji naᵽuᵽamiji tĩᵽikaᵽi imarãte õñua ã'mitiriᵽẽatirã “Jia õñurã yija ime”, mija ãrĩa'si. I'suᵽaka ᵽuᵽakirãre bojaika yi'ribekaja Tuᵽarãte õñutakaja mija ã'mitiriᵽẽajĩka jia sime. I'suᵽaka mija baamaka ĩatirã “Õrĩbeyurã nime”, mijareka narĩko'omakaja, Tuᵽarãte ĩaika wãjitãji ᵽuri jia õñurã mija ime. ");
INSERT INTO tnc_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","I'suᵽaka Tuᵽarãte mijare ĩaika simamaka kire yi'ribeyurãte “Jia õñurã yija ime”, ãrĩkoᵽeika dakowaᵽamarĩa sime Tuᵽarãro'si. Ã'mitirikõrĩ je'e. Ikuᵽaka sabojayu kimajaroᵽũñurã: “ ‘Tẽrĩrika õñurã imarĩ, aᵽerãte bo'ibajirã yija ime’, narĩᵽuᵽajoakoᵽeikaᵽiji jiamarĩa Tuᵽarãte naro'si sabaarãñu”, ãrĩwa'ri sabojayu. ");
INSERT INTO tnc_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Toᵽi aᵽea ikuᵽaka sabojayu: “ ‘Yire yi'ririᵽe'yoirãte ᵽuᵽajoaika ñorĩᵽatayu. “Ritaja õrĩᵽatairã yija ime”, narĩko'omakaja, norĩkoᵽeika dakoa waᵽamarĩa sime’, Tuᵽarãte ãñu”, ãrĩwa'ri sabojayu. ");
INSERT INTO tnc_vpl VALUES ("C13_21","076_3_21","1CO","3","21","22","Suᵽa imarĩ mijare wãrõrimajare ĩatirã “Ĩ'ĩre yija ã'mitiriᵽẽayu, aᵽerã wãrõrimajare tẽrĩwa'ribaji õñuka kimamaka”, ãᵽaraka jĩjimaka mija ᵽuᵽaria'si. Jia jĩjimaka mija imaokaro'si ritaja Tuᵽarãte mijare ja'atayu. Yi'i Ᵽablo, Aᵽolo, Ᵽedroᵽitiyika kirika bojariroka mijare yija wãrõerã mija ᵽõ'irã yijare kiᵽũataeka. Jia mija imarũkia mijaro'si kibaatika simamaka õñia mija imatiyikuri, reyaekarã mija imarãka ᵽotooka jia Tuᵽarãka mija imarãñu. Suᵽabatirãoka maekaka, ñamajĩ mija imarijarirũkia jia mijaro'si simarijarirãñu. Ã'mitirikõrĩ je'e, ritaja õ'õrã imakaka, jia oyiaja mijaro'si sime. ");
INSERT INTO tnc_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","I'suᵽaka mijaro'si simarijayu Cristore yi'yurã mija ima simamaka. Suᵽa imarĩ ᵽemawa'ribaji mija wãrõrimaja ᵽuᵽajoabekaja ikuᵽaka sime: Mija ruᵽuko'amaki kime Cristo. I'suᵽakajaoka Cristo ruᵽuko'amaki kime Tuᵽarã. ");
INSERT INTO tnc_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","“Jesúrikaitakaja ba'iraberimaja nime”, yijareka mija ãrĩᵽuᵽajoabe. I'suᵽaka simamaka yijare kiᵽũataeka Tuᵽarãrika bojariroka ᵽo'imajare ã'mitirikoribeyumiji imakoᵽekakaka yija wãrõerã. ");
INSERT INTO tnc_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Ikuᵽaka sime ba'irabeĩjirimaja imarikakaka: Ba'iraberika nare naja'ataekareka jia naba'iraberika ime jĩjimaka ĩᵽarimarãre naka imaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Mija ĩabe, ikuᵽaka sime kirika yiba'iraberikakaka. “Jesúre yaᵽaika uᵽakaja jia Ᵽablote ba'irabeyu”, mija ãrĩjĩka, mija ãrĩberijĩkaoka marãkã'ã imabeyua yiro'si. Suᵽabatirãoka ritaja aᵽerãte i'suᵽaka yire ãrĩberikoᵽejĩka marãkã'ã imabeyua. “¿Yaje ritaitaka jia Jesúrika yiba'irabeyu jee? Jiamarĩa yiba'irabeyu je'e aᵽeyari”, ãrĩwãrũbeyuka ñime ñoñu uᵽakaja ᵽuri. ");
INSERT INTO tnc_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Yiᵽuᵽajoaikareka jia Jesúrika yiba'irabeyu. I'suᵽaka simako'omakaja, “Oka imabeyua yire”, ãrĩrũkimarĩa sime. Maiᵽamaki Jesús ĩ'rĩkaja õñuka, “Jia Ᵽablote yirika ba'irabeyu”, ãrĩrika. ");
INSERT INTO tnc_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Suᵽa imarĩ kiᵽe'rietarãñurĩmi mabaakoᵽeka ᵽo'imajare õrĩbeyua wããrõ'õrãja sakibojarãñu. I'suᵽakajaoka kibaarãñu maᵽuᵽajoaeka mirãkakaka. I'sia ᵽoto ĩ'rĩka uᵽakaja kirika maba'irabeka mirãka simamaka ĩatirã mabaaeka uᵽakaja sawaᵽa mare kibaarãñu. Suᵽa simamaka ketarũki ruᵽubajirã, aᵽerãte baaika ĩatirã “Ba'iaja baairã mija ime”, ãᵽekaja maimaye'e. ");
INSERT INTO tnc_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Mija ã'mitiᵽe yijeyomarã. Ĩ'rĩka ta'iarãja mija imaokaro'si yirikakaka suᵽabatirã Aᵽolorika kakaoka mijare yibojayu. Suᵽa imarĩ simara'aeka uᵽakaja mija ᵽuᵽajoaerã ikuᵽaka sabojayu: “Ᵽo'imajareka mija jairã ᵽoto Tuᵽarã majaroᵽũñu ãñu ᵽemawa'ribajirã mija baa'si”, ãrĩwa'ri sãñu. Suᵽa imarĩ “Yijare wãrõrimaji ᵽuri mijariki wãrõrimajire tẽrĩwa'ribaji jia õñuka kime”, mija ãrĩbu'a'si. ");
INSERT INTO tnc_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Dakoa aᵽea aᵽikate tẽrĩwa'ribaji mijare imarũjeika imabeyua. Ritaja mija baawãrũika Tuᵽarãte mijare ja'ataeka sime. I'suᵽaka mijare kija'ataeka simamaka “Yija õñu uᵽakaja jia kirika yija ba'irabewãrũyu”, mija ãrĩa'si. ");
INSERT INTO tnc_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Suᵽabatirã “Maekaka ᵽuri ritaja Tuᵽarãrikakaka õñurã yija ime”, mija ãrĩkoᵽeyu. I'suᵽakajaoka “Kirika yija ba'irabewãrũerã ritaja Esᵽíritu Santore yijare ja'ataᵽataeka”, mija ãrĩᵽuᵽajoakoᵽeyu, yiᵽuᵽajoaikareka. Cristoka jã'mebeyukajirã yija imako'omakaja ¿mija ᵽuri kika jã'merimaja jaritirã bai je'e? Karemarĩtaka mija ᵽuᵽajoaika uᵽaka simarikareka, yijaro'sioka jia simajããeka mija uᵽaka kika jã'merimaja yija imaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Aᵽe uᵽaka sime yiᵽuᵽakareka yiro'si ᵽuri. “Aᵽóstolrãka yija imako'omakaja jiyiᵽuᵽaka ᵽo'imajare õrĩbeyurã uᵽaka Tuᵽarãte yijare ᵽũataeka”, yija ãrĩwãrũyu. Ĩakõrĩ je'e: Surararãkare ñi'aekarã uᵽaka imawa'ri, niᵽamakite jã'meika ᵽoto, ᵽo'imajare ĩaika wãjitãji reyarũkirã uᵽaka yija ime. I'suᵽaka simamaka nimauᵽatiji ᵽo'imaja, suᵽabatirã ángelrãkaoka yijaro'si simarãka uᵽakaja ĩabaraka imarã. ");
INSERT INTO tnc_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Jesucristore yaᵽaika uᵽakaja yija baamaka “Dako õrĩbeyuratarã nime”, ᵽo'imajare yijareka ãrĩᵽuᵽajoayu. “Yija ᵽuri, Cristorirã yija imamaka, dika jariwa'ririmarĩa yijare kiõrĩrũjeyu”, mija ãrĩᵽuᵽajoakoᵽeyu. “Tuᵽarãro'si jia baakoᵽeirã nime”, ĩ'rãrimarãre yijareka ãñu. Mija ᵽuri “Tẽrĩwa'ribaji kiro'si baairã Tuᵽarãte yijare imarũjeyu”, mija ãrĩᵽuᵽajoakoᵽeyu. Suᵽabatirã jĩjimaka ᵽo'imajare mijaka imako'omakaja yijare jiyiᵽuᵽaka norĩbeyu. ");
INSERT INTO tnc_vpl VALUES ("C14_11","076_4_11","1CO","4","11","12","Bikija ba'iaja yija jũara'aeka uᵽakaja maekakaoka yija jũarijayu ruᵽu. Ĩ'rãkurimarĩa yija kẽsirabarijayu, okoa ukurijitokoᵽeko'omakaja okoa yijaro'si jia yija tõᵽowãrũbeyu. I'suᵽakajaoka jarirorõ'õ, yija o'ajããrũkia imaberirijayua yijaro'si. Ba'iuᵽaka yijare baawã'imaᵽaraka ᵽo'imajare yijare ᵽajewã'imarĩrijayu. Suᵽabatirã wi'imarĩrã yija ime. Tuᵽarãrika bojariroka yija wãrõika simako'omakaja yija imarũkiwaᵽa, yija ba'arũkiwaᵽaoka tõᵽoerã jimarĩa ba'irabejĩaᵽarijayurã. Ba'iaja ᵽo'imajare yijare jaiwã'imarĩko'omakaja, ba'irokaᵽi nare yija okae'ebeyu. I'suᵽaka baabekaja “Jia nare mijeyobaabe, Tuᵽarã”, ãᵽaraka naro'si kire yija jẽñerijayu. Ba'iaja yijare nabaata'ako'omakaja nare yija ruᵽuwaᵽae'ebeyu. ");
INSERT INTO tnc_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Ba'iaja yijareka najaiyuyeko'omakaja jiaᵽiji naka yija imarijayu. Burua uᵽaka yijare norĩrijayu. Bikija niaᵽe'yora'aeka uᵽakaja maekakaoka i'suᵽakaja niaᵽe'yoirã yija imarijayu ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Mijare waᵽewa'rimarĩa ikuᵽaka mijaro'si yo'oyu. Mamakarãka mawãtaika uᵽaka mijare yiwãtayu. Suᵽa imarĩ mijare okajããwa'ri ikuᵽaka mijaro'si yo'oyu. ");
INSERT INTO tnc_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Diez mil rakamarã Jesúrika bojariroka mijare wãrõrimajare imakoᵽeko'omakaja yi'i ĩ'rĩkaja ᵽuri kirika mijare wãrõũ'muraᵽaki. Mijare yibojamaka ã'mitiritirã Jesúrirã mija jarika. I'suᵽaka mijare wãrõũ'muraᵽaki imarĩ, mijaᵽaki uᵽakaja ñime. ");
INSERT INTO tnc_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Mijaᵽaki uᵽakaja imaki ñimamaka yibaaraᵽaka uᵽakaja mija baarika yiyaᵽayu. ");
INSERT INTO tnc_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","I'suᵽaka mija imarika yaᵽawa'ri Timoteore jiibaji mijare wãrõerã torã kire yiᵽũatayu. Yimaki uᵽakaja wãtaka ñoñuki imarĩ, Maiᵽamakire yaᵽaika uᵽakaja baaiki kime Timoteo. Suᵽa imarĩ mijare yiwãrõtiraᵽaka mirãkaja mijare kiwãrõrãñu je'e ate. Suᵽabatirã “Jesúre yi'yuka imarĩ, ikuᵽaka Ᵽablote imarijayu”, ãrĩwa'ri mijare kibojarãñu. I'sirokajaoka aᵽerã Jesúre yi'yurãte yiwãrõtaᵽarijayu. ");
INSERT INTO tnc_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","“Maᵽõ'irã ᵽuri Ᵽablote etabesarãñu je'e mare kĩkiwa'ri”, ãrĩwa'ri ĩ'rãrimarã mija ᵽõ'ikarãre jiiwariarikoᵽeyu. ");
INSERT INTO tnc_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","“Tuᵽarãte yire ᵽũatarãrĩmi, mijare ĩarĩ ya'rirãñu”, ñarĩᵽuᵽajoayu. Mija ᵽõ'irã yeyarãñurĩmi, marãkã'ã imawa'ri i'suᵽaka najaiyu ãrĩwa'ri naka sayikorirãñu. “Waᵽuju jairimirãtakaja sanajaiyu je'e aᵽeyari”, ãrĩwa'ri nare ñiaeyarãñu. I'suᵽakajaoka karemarĩtaka Esᵽíritu Santore nare jeyobaaikaᵽi najaika uᵽakaja kika naba'iraberika jia naro'si simamaka ñiaeyarãñu. ");
INSERT INTO tnc_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Naᵽuᵽajoaika uᵽakaja najairijayuaᵽi takaja Tuᵽarãrika naba'iraberijarirãkareka dako waᵽamarĩa simarãñu. Tuᵽarãte jã'mekarã ᵽuri kijeyobaaikaᵽi ãrĩwa'ri kirika ba'iraberijayurã. ");
INSERT INTO tnc_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","I'suᵽaka simamaka, ikuᵽaka mijare yijẽrĩayu mae: ¿Marãkã'ã mija yaᵽayu? “¿Dako baaerã ba'iaja mija baabu'akũ'ñu?”, ãrĩwa'ri ¿mijare yiwaᵽeeyarika mija yaᵽayu bai? Ba'iaja baarika ja'ataekarã mija imamaka, ¿jĩjimakaᵽi mija ᵽõ'irã yeyarika mija yaᵽayukã'ã? ");
INSERT INTO tnc_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Aᵽea ikuᵽaka ima. Mijakaki majaroka ikuᵽaka ña'mitiyu. “Kiᵽaki rũmuka ba'iaja kiwã'imarĩrijayu”, ãrĩwa'ri sime kimajaroka. I'sia ima ba'itakaja kibaaika. Aᵽerã ᵽuri Tuᵽarãte yi'ribeyurã imariᵽotojo i'suᵽakaitaka baabeyurã. ");
INSERT INTO tnc_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","I'suᵽaka mija watoᵽekareka ba'iaja baabaraka imakite imako'omakaja “Aᵽerã tẽrĩwa'ribaji jia Jesúre yi'yurã yija ime”, ãᵽaraka ¿jĩjimaka mija imarijayu bai je'e? I'suᵽaka imabekaja ba'iaja kibaamaka i'yoᵽi'riwa'ri mijaka kire mija imarũjea'si. ");
INSERT INTO tnc_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Wããrõ'õrã mijaka imabeririᵽotojo yiᵽuᵽakaᵽi ᵽuri mija ᵽõ'irã ñimarijayu. Mijaka imabeririᵽotojo, “Ikuᵽaka ba'iaja kibaaika waᵽa kiwaᵽakoyirũ”, ãrĩᵽuᵽajoaweitikakiji ñime. ");
INSERT INTO tnc_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","“Ba'iaja baaiki kimamaka ikuᵽaka sawaᵽa kijũarãñu”, ãñaokaro'si mija rẽrĩrika yiyaᵽayu. I'suᵽaka mija baarãka ᵽoto yiᵽuᵽakaᵽi ᵽuri mija ᵽõ'irã imaki uᵽakaja ñimarãñu. Suᵽabatirã i'suᵽakajaoka maiᵽamaki Jesucristore mijare jeyobaarãñu. ");
INSERT INTO tnc_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","I'suᵽaka simamaka rẽrĩtirã mija jairãka be'erõ'õ kire mija ĩaᵽẽa'si, kiyaᵽaika uᵽakaja Satanáre kire baaokaro'si. I'suᵽaka ba'iaja kijũarãñu kiᵽuᵽaᵽe'yaokaro'si. Suᵽa imarĩ maiᵽamaki Jesucristore ᵽe'rietarãrĩmi kire kitããrãñu. ");
INSERT INTO tnc_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","I'suᵽaka ba'iaja baaikite mija watoᵽekarã imakoᵽeko'omakaja, “Aᵽerã tẽrĩwa'ribaji jia Jesúre yi'yurã yija ime”, ãᵽekaja mija imabe. Mija ĩabe. Ᵽan baaokaro'si kũᵽajĩji levadura marukekoᵽeko'omakaja, jia koyirika sarukuka uᵽaka sime ba'iaja baarikakaka. Ba'iaja baaikite mija watoᵽekarã imajĩka ba'iaja baairã uᵽaka oyiaja mija jariᵽatajĩñu. ¿I'suᵽaka simakaka õrĩbeyurã bai je'e mija? ");
INSERT INTO tnc_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","I'suᵽaka mijaro'si simakoreka mija watoᵽekarã kire mija imarũjea'si, Tuᵽarãte yaᵽaika uᵽaka oyiaja baairã mija imaokaro'si. Mija ĩabe, Ᵽascua baya naro'si jẽ'rãta'yu ᵽoto simauᵽatiji levadura nawi'iarã ima judíorãkare taarijayu. Levadura bikijaka nawi'iarã ima uᵽaka naro'si sime ba'iaja baarika naᵽuᵽajoamaka. Suᵽa imarĩ “Aᵽekurioka ba'iaja baarũkimarĩrã maimaye'e”, ãrĩwa'ri levadura nawi'iarã ima nataarijayu. I'suᵽakajaoka Ᵽascua baya ᵽoto oveja weiwa'yua najããrijayu uᵽaka ba'iaja Jesúre maro'si jũaeka. Ba'iaja mabaaika maro'si waᵽaĩjiwa'ri kireyaeka õñurã imarĩ, ba'iaja baarika maja'ataye'e. ");
INSERT INTO tnc_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Suᵽabatirã “Jimarĩa ba'iaja Jesucristore jũaeka mare tããokaro'si”, ãrĩwa'ri ritaja ba'iaja mabaarijayua ja'atatirã jĩjimakaᵽi, wãjimiji takaja ᵽuᵽajoabaraka maimarijariye'e, ᵽakirimarĩaja. ");
INSERT INTO tnc_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Bikija mamarĩ ᵽaᵽera mijare yiᵽũataũ'muraᵽakaᵽi ikuᵽaka mijare yibojaraᵽe: “Rõmijã ĩmirĩjaka baariwã'imarĩrijayurã, i'suᵽakajaoka ĩmirĩja rõmijãka baariwã'imarĩrijayurãka mija jeyoaria'si”, ãᵽaraka o'oekaᵽi mijare yibojaᵽũaraᵽe bikija. ");
INSERT INTO tnc_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","I'suᵽaka mijare ñarãᵽe, “Jesúre yi'ribeyurãte mija waᵽata'ritaᵽabe”, ãrĩwa'rimarĩa. Ikuᵽaka nime Jesúre yi'ribeyurã: Rõmijã ĩmirĩja aᵽerãka wã'imarĩrijayurã uᵽaka nime, rĩkimakaja niñerũ rikariᵽotojo rĩkimabaji yaᵽarijayurã. I'suᵽakajaoka karee'erimaja, suᵽabatirã waᵽuju imaja jẽrãka jiyiᵽuᵽayeerijayurã nime Jesúre yi'ribeyurã. I'suᵽaka baarimaja rĩkimarãja nima simamaka, naka imarika yaᵽaberiwa'ri ᵽo'imajamatorã mija a'rijĩñu. I'suᵽaka simako'omakaja maki i'suᵽakaitaka baaberijĩki. ");
INSERT INTO tnc_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","“Ikuᵽaka mija baabe”, ãrĩwa'ri i'suᵽaka mijaro'si yo'oᵽũaeka. “Jesucristore yi'yurã yija ime”, ãrĩriᵽotojo rõmijã ĩmirĩja aᵽerãka wã'imarĩrijayurãka mija jeyoaria'si. Suᵽabatirãoka rĩkimakaja niñerũ rikariᵽotojo rĩkimabaji yaᵽarijayurã, i'suᵽakajaoka waᵽuju imaja jẽrãka jiyiᵽuᵽayeerijayurã, aᵽerãte jaiyuyeirã, wejabiaikaka ukutirã wejabiririjayurã, suᵽabatirã waᵽuju ᵽakitirã karee'erimajakaoka mija jeyoaria'si. Suᵽabatirãoka naka mija ba'arijaria'si. ");
INSERT INTO tnc_vpl VALUES ("C15_12","076_5_12","1CO","5","12","13","Jesúre yi'ribeyurãte ba'iaja baamaka “Ikuᵽaka nare mabaaye'e”, ãñaokaro'simarĩa maime. Tuᵽarã ĩ'rĩkaja imaki ba'iaja nabaaekaᵽi ãrĩwa'ri sareka jiamarĩa nare baarũkika. I'suᵽaka simako'omakaja muᵽaka Jesucristore yi'yurã imariᵽotojo ba'iaja nabaaika ja'atarika yaᵽabeyurãka jeyoaribekaja maimaye'e. Ã'mitirikõrĩ je'e, ikuᵽaka sabojayu Tuᵽarãrika bojariroka o'oeka ᵽũñurã: “Mija ᵽõ'irã ba'iaja baabaraka imarijayukaka mija jeyoaria'si”, ãrĩwa'ri sabojayu. ");
INSERT INTO tnc_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Aᵽea mijare ñañu mae. Mija bojajããbu'arãka be'erõ'õ, Jesúre yi'yurã ᵽõ'irã ĩ'rãtiji sajierĩ a'ᵽekaja, Jesúre yi'ribeyurã ĩᵽarimarã ᵽõ'irã sajierĩ mija a'yu. ¿I'suᵽaka naᵽõ'irã mija baaika i'yoᵽi'ribeyurã bai je'e mija? ");
INSERT INTO tnc_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Jesúre yi'yurã imarĩ, ñamajĩ õ'õrã ate kiᵽe'rietarãñurĩmi ritaja ᵽo'imajare baaeka mirãka ĩabaraka “Ika jiamarĩa ima, ika ᵽuri jia ima”, ãrĩrũkirã maime. ¿Yaje sõrĩwãrũirã mija ime je'e? Ika ka'iareka imarãte wã'marũkirã imariᵽotojo ¿maekaka dakomarĩjĩkaja oka dajaka imakoᵽeika mija jiewãrũbeyu bai je'e? ");
INSERT INTO tnc_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Ángelrãkare baaeka mirãka ᵽariji wã'marũkirã imarĩ, õ'õrã dakomarĩjĩkaja oka mijare imakaka jia ĩawãrũrimaja mija ime. ");
INSERT INTO tnc_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","I'suᵽaka imarũkirã imariᵽotojo ¿dako baaerã oka mijareka ima mija tiyiaja sajiebekaja Cristore yi'ribeyurã ᵽõ'irã sajierĩ mija a'ririjayu je'e? ");
INSERT INTO tnc_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Mija i'yoᵽi'yaokaro'si i'suᵽaka mijare yibojayu. ¿Ni'i ĩ'rĩkaoka mija watoᵽekakaki jiiᵽañaka õrĩᵽũatirã okajiewãrũiki imaberitiyaikiji bai je'e? Imakoᵽeiki je'e aᵽeyari yiᵽuᵽajoaikareka. ");
INSERT INTO tnc_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Suᵽa simako'omakaja ĩ'rãrimarã mijaka imarã okajierikoᵽakaja, nokatotorijayu. Jã'rĩbaji sime ĩᵽarimaki Jesúre yi'ribeyurã ᵽõ'irã a'ritirã, nawãjitãji nabojajããbu'aika. ");
INSERT INTO tnc_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","I'suᵽaka mija tiyiaja mija bojajããbu'arijayua, Jesúre yi'yurã baarũkimarĩa sime. I'suᵽaka baarikoᵽakaja ĩ'rãrimarãre ba'iaja mijare baakoᵽeika samija rakajeᵽããbe. “Yire jaita'aᵽakitirã me'maeka i'suᵽaka simaᵽarũ”, ãᵽaraka mija imabu'abe. ");
INSERT INTO tnc_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","I'suᵽaka baarikoᵽakaja ĩ'rãrimarã mija ᵽõ'irã ᵽo'imajare jaita'aᵽakitirã karee'erimaja imarijayurã. Najeyomarã Jesúre yi'yurã imariᵽotojo i'suᵽaka nare ba'iaja nabaarijayu. ");
INSERT INTO tnc_vpl VALUES ("C16_9","076_6_9","1CO","6","9","10","“Ba'iaja yija baarijayua marã imabeyua Tuᵽarãro'si”, ãᵽaraka ᵽuᵽajoabekaja mija imabe. “Ba'iaja baarimaja imarĩ, Tuᵽarãte jã'meirõ'õrã eyarũkirãmarĩrã nimarãñu”, ãñua ¿mija õrĩbeyu bai? Mija ã'mitiᵽe, ikuᵽaka nabaayu ba'iaja baairã: Rõmijã ĩmirĩjaka wã'imarĩrijayurã uᵽaka nime, suᵽabatirã waᵽuju imaja jẽrãka jiyiᵽuᵽayeerijayurã. I'suᵽakajaoka ĩmirĩja rõmikirã, rõmijã tĩmiakirãoka jeyoika jaritikarã imariᵽotojo aᵽerãka yaᵽabu'arijayurã, suᵽabatirã ĩmirĩja natiyiaja yaᵽabu'arijayurã. Suᵽabatirã karee'erimaja, suᵽabatirã rĩkimakaja niñerũ rikairã imariᵽotojo rĩkimabaji niñerũ yaᵽarijayurãoka imarã. Aᵽerimarã imarã wejabiaikaka ukutirã wejabiririjayurã, aᵽerãte jaiyuyeirã. Suᵽabatirã aᵽerã imarã aᵽerãte rikaika jaiᵽakitirã nare ẽ'marijayurã. I'suᵽaka baarimaja Tuᵽarã ᵽõ'irã eyabesarãñurã. Suᵽa imarĩ nuᵽaka ba'iaja baariᵽotojo “Tuᵽarã ᵽõ'irã eyarũkirã maime”, mija ãrĩᵽuᵽajoarijaria'si. ");
INSERT INTO tnc_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Bikija ᵽuri nimauᵽaka baabaraka ĩ'rãrimaki mija imaeka ruᵽu. Maekaka ᵽuri i'suᵽaka baabeyurã mija imaokaro'si Esᵽíritu Santore mijare jeyobaayu Jesucristore mijaro'si reyaeka simamaka. Ba'iaja mija baaekareka Tuᵽarãte mijare tããeka, suᵽabatirã kirirã mijare kimarũjeka mae. I'suᵽakajaoka “Ba'iaja nabaaeka waᵽa yire waᵽariabeyurã nime”, Tuᵽarãte mijareka ãñurã mija ime mae. ");
INSERT INTO tnc_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","Ikuᵽaka ĩ'rãrimarã mija watoᵽekareka imarãre ãñu: “Maekaka Jesúre yi'yurã imarĩ, ritaja yija yaᵽaika uᵽakaja baajĩrã yija ime”, narĩkoᵽeyu. I'suᵽaka simako'omakaja “Ritaja mabaariyaᵽarijayuareka ĩ'rãriba'ikaka jiamarĩa imarijayua sime maro'si. Suᵽabatirã ĩ'rãriba'i mabaarijayua, marãkã'ã baatirã maja'atawãrũberijĩka sime maro'si. Suᵽa imarĩ i'suᵽaka mabaaberjĩñu”, ñañu. ");
INSERT INTO tnc_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","Ĩ'rãrimarã ikuᵽaka ãñurã: “Ba'arika maba'aika ña'rĩjãirũkiaro'si sime ñe'mea. I'suᵽakaja mamarĩrãja Tuᵽarãte ᵽo'ijiatikarã maime. I'suᵽaka imarã imarĩ, imajiᵽarũkimarĩa sime mañe'mea, ba'arikaoka”, narĩkoᵽeyu. Kẽsia mare baamaka, ba'arijayurã maimako'omakaja rõmitika ĩmirĩjaka ba'iaja wã'imañua baarika mare jitoika naka baarimajamarĩrã maime. Cristore yaᵽaika uᵽakaja baairã maimaokaro'si Tuᵽarãte mare ᵽo'ijiaeka. Kirirã imarĩ, maᵽo'iaᵽi i'suᵽaka baarũkirã maime. ");
INSERT INTO tnc_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Tuᵽarãte kirikaᵽi maiᵽamaki Jesucristore õñia kijariᵽe'rirũjeka uᵽakajaoka mare kibaarãñu. ");
INSERT INTO tnc_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","I'suᵽaka imarã imarĩ, Jesúᵽo'iakakaja sime maᵽo'ia Tuᵽarãte ĩamaka. I'suᵽaka ima õñurã mija ime. ¿I'suᵽaka imariᵽotojo rõmitika ĩmirĩjaka wã'imañua niñerũᵽi waᵽaĩjitirã, mija yaᵽaika uᵽaka koka mija baaika jia sime bai? ");
INSERT INTO tnc_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Ikuᵽaka mijare ãrĩrika ñarĩko'o, ĩ'rĩka uᵽakaja imarã nime Tuᵽarãte ĩamaka. Ika ñañua õrĩwãrũekaja mija imabe. Tuᵽarã majaroᵽũñurã o'oeka ikuᵽaka bojaika: “Rõmiki kirũmuᵽitiyika ĩ'rĩka uᵽakaja imarã”, ãrĩwa'ri sabojayu. ");
INSERT INTO tnc_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Rõmika imarikakaka sabojaika uᵽakaja, Cristorirã maima simamaka kika ĩ'rĩka uᵽakaja ᵽuᵽairã maime Tuᵽarãte ĩamaka. ");
INSERT INTO tnc_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","I'suᵽaka mare kĩaika simamaka, ba'iaja baabekaja maimaye'e. I'suᵽaka baairã ᵽuri, aᵽerãka ba'iaja wã'imarĩwa'ri ĩ'rĩka ᵽo'i uᵽakaja naka imarã. Suᵽa imarĩ naᵽo'ia nabitatayu. Aᵽea ba'iaja baarika uᵽakamarĩa sime rõmitika ĩmirĩjaka ba'iaja wã'imañuaka baarika. ");
INSERT INTO tnc_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Esᵽíritu Santore mare ña'ajããiki kime Tuᵽarã. I'suᵽaka mare kiña'rĩjãika ᵽoto maᵽo'iaja kiwi'iuᵽaka ima kiro'si. ¿Samija õrĩkoᵽeyu bai je'e? I'suᵽaka simamaka Tuᵽarãrika sime maᵽo'ia, maro'sitakajamarĩa. ");
INSERT INTO tnc_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","Mija ĩabe. Kirirã maimaerã Jesúre reyaĩjiekaᵽi ãrĩwa'ri kirirã Tuᵽarãte mare imarũjeka. I'suᵽaka simamaka, maimarijayuareka kiyaᵽaika uᵽaka oyiaja baabaraka jiyiᵽuᵽaka kire mija õᵽe. ");
INSERT INTO tnc_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Õrĩrika yaᵽawa'ri ᵽaᵽeraᵽi yire mija jaiᵽũãika mijare yibojaerã baayu mae. “Tuᵽarãte yaᵽaika uᵽakaja imawa'ri kirũmuka baabekaja kimajĩka ¿yaje jia simajĩñu ruku?”, ãᵽaraka yire mija jẽrĩaᵽũaika. ");
INSERT INTO tnc_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Suᵽa imarĩ ikuᵽaka mijare yibojaerã baayu mae: Torã rĩkimarãja ba'iaja baabaraka mija ima simamaka, rõmie'ekaki imaki ᵽuri dakoa okamirãmarĩaja kirũmuka imarimaji kime. I'suᵽakajaoka sime rõmoro'si. ");
INSERT INTO tnc_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Rõmika imakiro'si koyaᵽaika uᵽakaja kiyi'ririjarirãkareka jia simarãñu. I'suᵽakajaoka koimarãñu kirũmu koro'si. ");
INSERT INTO tnc_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","I'suᵽaka simamaka “Yiᵽuᵽajoaika uᵽakaja yibaaye'e”, kotĩmite kõrĩberijĩñu. I'suᵽakajaoka sime ĩmirĩjiro'si. ");
INSERT INTO tnc_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Suᵽa imarĩ tĩmiaiko tĩmite baarika yaᵽamaka “Jẽno'o, baabekaja imarimajaja maimaye'e”, mija ãrĩrijayua mija ja'atabe. I'suᵽakajaoka sime ĩmirĩji rõmika imakiro'si. “Tuᵽarãka jaiokaro'sitakaja mako'aᵽiribu'arijayua maja'ataerã ruᵽu”, ãrĩwa'ri ĩ'ᵽarã wã'tarãja sanayi'ribu'ajĩkareka jia sime. Sabe'erõ'õᵽi ᵽuri nima uᵽakaja nimarijarijĩñu, Satanáre yaᵽaika uᵽaka ba'iaja aᵽerãka mija baawã'imarĩbu'aa'si ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Mija ko'aᵽiribu'arijayua ja'atarũkimarĩa mijaro'si simako'omakaja, Tuᵽarãka jairã baaeka kũᵽajĩ ja'atatirã i'suᵽaka mija imatarijarijĩñu mija yaᵽajĩkareka. “I'suᵽaka oyiaja mija baarijaᵽe”, ãrĩwa'ri mijare jã'merimajimarĩka ñime. ");
INSERT INTO tnc_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Rõmimarĩkaja ñimako'omakaja jo'ribekaja ñima uᵽaka oyiaja ritaja ᵽo'imajare imarikareka jia simajããeka yireka ᵽuri. I'suᵽaka simakoᵽeko'omakaja ĩ'rĩka ta'iarãja imabeyurã maime. I'suᵽaka maima simamaka marakakaja maimarũkia Tuᵽarãte mare ja'ataeka. Suᵽabatirã rõmikirãja, rõmimarĩkajaoka jia maimaokaro'si mare kijeyobaayu. ");
INSERT INTO tnc_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Mae rõmijã natĩmirãre reyataᵽaekamarã, ĩmirĩja narõmia reyataᵽaekarãre ikuᵽaka ñañu: “Rõmimarĩa maekaka ñima uᵽaka, ĩmirĩja rõmimarĩa imarã, i'suᵽakajaoka rõmijã tĩmiamarĩa imarã mija imarijarijĩka jia sime. ");
INSERT INTO tnc_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","I'suᵽaka simako'omakaja rakajeᵽããwãrũbeyurã ᵽuri ne'ebu'ajĩka marã imabeyua, dako okamirãmarĩaja nimarijayaokaro'si.” ");
INSERT INTO tnc_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Mae “Ikuᵽaka Maiᵽamakire jã'meka”, ãrĩwa'ri tĩmiakirãre, rõmikirãreoka yibojaerã baayu ate: Tĩmiakirã imarã mija ja'atabu'a'si. Ñoñu uᵽakaja yiᵽuᵽajoaikaᵽimarĩa ikuᵽaka mijare yibojayu, i'suᵽakaja Maiᵽamakire jã'meka simamaka. ");
INSERT INTO tnc_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","Ĩ'rãko kotĩmite ja'atatirã aᵽika ĩmirĩjika tĩmiaririka imabeyua. Aᵽikaka tĩmiaribekaja kotĩmi imatikakikaja jia imaᵽe'rirã kika oka kojiejĩka jia sime. I'suᵽakajaoka sime ĩmirĩjiro'si. ");
INSERT INTO tnc_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Mae ate Jesúre yi'yuka kire yi'ribeyukoka ne'ebu'aekakaka mijare yibojaerã baayu. Maiᵽamakire bojaekamarĩa sime ika. Yiᵽuᵽajoaika uᵽakaja ikuᵽaka mijare yibojayu: Ikuᵽaka simarijayu ĩ'rãrimarãro'si: Jesúre yi'ribeyurã oyiaja imabu'atirã, be'erõ'õᵽi ᵽuri ĩ'rĩka kire yi'yuka. I'suᵽaka imariᵽotojo mija rõmia mijare ja'atarika yaᵽabesarãka nare mija ja'ata'si. ");
INSERT INTO tnc_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","I'suᵽakajaoka sime rõmijã Jesúre yi'ribeyurãka tĩmiarikarãro'si. Jesúre yi'ribeyurã imariᵽotojo mijaka nimariyaᵽamaka nare mija ja'ata'si. ");
INSERT INTO tnc_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Mija tĩmiarã Jesucristore yi'ribeyurã nimako'omakaja, ĩ'ᵽarã imariᵽotojo ĩ'rĩka uᵽakaja mija ime Tuᵽarãte ĩamaka, kirirã uᵽaka mijare kĩarĩrĩrijayu. I'suᵽakajaoka ĩmirĩja Jesúre yi'yurãro'si sime. I'suᵽakamarĩa simarikareka, kirirãmarĩrã mija makarãte imajããeka Tuᵽarãte ĩamaka. Kirirã uᵽaka mijare kĩamaka ᵽuri jiaᵽi mija makarãte kĩarĩrĩrijayu. ");
INSERT INTO tnc_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Jesúre yi'yuka rũmu Jesúre yi'ribeyuko imarĩ, kire koja'atariyaᵽajĩka, koyaᵽayu uᵽakaja ko'rijĩka marã imabeyua. I'suᵽakajaoka ĩmirĩji Jesúre yi'ribeyuka kirũmu Jesúre yi'yukote kija'atariyaᵽamaka kiyaᵽayu uᵽakaja kibaajĩñu. I'suᵽaka nayaᵽayu uᵽakaja “Na'riᵽarũ”, ñañua simako'omakaja ja'atabu'abekaja mija imajĩkareka jiibaji simajĩñu. I'suᵽakaja ᵽo'imajaka okamirãmarĩaja maimarika Tuᵽarãte yaᵽayu. ");
INSERT INTO tnc_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","“Jia natĩmiarãka imawa'ri Jesucristore nayi'rirãñu je'e naro'sioka aᵽeyari”, ãrĩwa'ri i'suᵽaka rõmijãro'si ñañu. I'suᵽakajaoka sime ĩmirĩjaro'si. ");
INSERT INTO tnc_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Rakakaja maimaokaro'si Tuᵽarãte mare ja'ataeka. Suᵽa imarĩ mare kiwã'maeka ᵽoto maimara'aeka uᵽakaja maimarijarijĩkareka jia sime. Jesúre yi'yurãte rẽñurõ'õrã yeyaika rakakaja iroka nare yibojarijayu. ");
INSERT INTO tnc_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Ĩ'rãrimarã Jesúre nayi'rirã baaeka ruᵽubajirã judíotatarã imarĩ, circuncisión baatikarã imarã. “Mae Jesúre yi'yuka imarĩ circuncisión kurare yire baakoᵽeka yo'arãñu”, ãrĩrika imabeyua. Ĩ'rãrimarã Jesúre nayi'rirã baaeka ruᵽubajirã judíorãkamarĩrã imarĩ, circuncisión baaberikarã imarã. “Jesúre yi'riwa'ri circuncisión yibaaerã judíotatakaki jayaokaro'si”, ãrĩrika imabeyua. ");
INSERT INTO tnc_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Circuncisión baaekarã, circuncisión baaberikarã maimajĩkaoka marã imabeyua. Tuᵽarãte mare jã'meika uᵽakaja baarika sime imatiyaika. ");
INSERT INTO tnc_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Suᵽa imarĩ Tuᵽarãte mare wã'maeka ᵽoto maimara'aeka uᵽaka maimarijariye'e. ");
INSERT INTO tnc_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Mia, Jesúre yi'yurã imariᵽotojo aᵽerãte ba'irabeĩjibaraka “Ba'itaka naᵽoyarã yija ime”, mija ãrĩa'si. I'suᵽaka simako'omakaja mijare naja'atarãkareka ᵽuri wãjiaja mija ᵽoᵽe. ");
INSERT INTO tnc_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Ikuᵽaka sime: Aᵽerãro'si ba'irabeĩjirimaja mija imakoᵽejĩka marã imabeyua. Jesúre yi'yurã mija jarirũki ruᵽubaji ba'iaja baariroka yi'yurã mija imaeka. Maekaka ᵽuri Jesúrirã mija imamaka, i'suᵽaka mija imakoᵽeka kija'ataekarã mija ime kiyaᵽaika uᵽaka baaokaro'si. I'suᵽakajaoka aᵽerãte ba'irabeĩjirimajamarĩrãoka, kire yi'yaokaro'si mijare kiwãmamaka ᵽuri kiro'si ba'irabeĩjirimaja uᵽaka mija ime mae. ");
INSERT INTO tnc_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Ba'iaja Jesúre jũaeka waᵽa kirirã maimaerã Tuᵽarãte mare wã'maeka. Suᵽa imarĩ Tuᵽarã ĩ'rĩkaja kime Maiᵽamaki imatiyaiki. I'suᵽaka simamaka, “Jia Tuᵽarãka mija imarijitoye'e yija ãñu uᵽakaja mija imabe”, ãñurãte mija yi'ria'si. ");
INSERT INTO tnc_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Mija ã'mitiᵽe yijeyomarã. Tuᵽarãte mare wã'maeka ᵽoto maimaeka uᵽakaja maimamirĩrĩkawa'rijĩkareka jia sime. I'suᵽaka maimamaka jĩjimaka Tuᵽarãte maka imarijarirãñu. ");
INSERT INTO tnc_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Mae ᵽaᵽeraᵽi yire mija jẽrĩaᵽũaraᵽakakaka mijare yibojaerã baayu ate. “Ikuᵽaka tĩmiamarĩrãre, rõmimarĩrãteoka Maiᵽamakire nare jã'meyu”, ãrĩwãrũbeyuka yi'i. I'suᵽaka simako'omakaja Jesúre yire jeyobaarijayuaᵽi yiᵽuᵽajoaikakaka wãjiroka mijare yibojaerã baayu. Suᵽa imarĩ yire mija ã'mitiriᵽẽarika yiyaᵽayu. ");
INSERT INTO tnc_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","“Cristore mija yi'yuaᵽi ãrĩwa'ri ba'itakaja jiamarĩaᵽi mijare nabaata'arijayua simamaka rõmimarĩa mija ima uᵽakaja mija imarijarijĩkareka jia sime”, ñarĩᵽuᵽajoayu. ");
INSERT INTO tnc_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","“Rõmie'etika imarã, mija rõmia mija ja'ata'si. Rõmimarĩa imarã rõmie'erika ᵽakataᵽekaja mija imabe”, mijare ñañu. ");
INSERT INTO tnc_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","I'suᵽaka ñañua simako'omakaja ĩ'rĩka ĩmirĩji rõmie'erika yaᵽajĩkite rõmie'ejĩka marã imabeyua. I'suᵽakajaoka tĩmiaririyaᵽaiko, ba'iaja baawa'rimarĩa kotĩmiarirãñu. Ka'wisika jũarijayurã maime maekaka. I'suᵽaka simamaka rõmika jaritikarã, tĩmiaika jaritikarãro'si ka'wisibaji simarãñu. I'suᵽaka mijaro'si sima'si ãrĩwa'ri “Rõmimarĩaja mija imarijarijĩkareka jia sime”, ãrĩwa'ri i'suᵽaka mijare yibojayu. ");
INSERT INTO tnc_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Mija ã'mitiᵽe yijeyomarã. “No'ojĩrãmarĩaja sajariwa'yu õ'õrã maima ᵽurirũkia. Suᵽa imarĩ aᵽeakaka ᵽuᵽajoatiyabekaja Cristorika maba'iraberijariye'e”, ãrĩwa'ri ikuᵽaka mijare yibojayu: Rõmika imarã rõmimarĩrã uᵽakaja kirika mija ba'iraberijaᵽe. ");
INSERT INTO tnc_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","Ba'iaja ᵽuᵽayurã, ba'iaja mija ᵽuᵽayu takaja ᵽuᵽajoabekaja mija imabe. Jĩjimaka imarãoka, jĩjimaka imarikatakaja mija ᵽuᵽaribekaja mija imabe. I'suᵽakajaoka waruaka rĩkimaka waᵽaĩjirijayurã, sarekaja ᵽuᵽaribekaja mija imabe, “Õ'õrã ñoaka õñia imarũkimarĩrã maime”, ãrĩᵽuᵽajoawãrũirã imarĩ. ");
INSERT INTO tnc_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","“Maekaka ritaja mabaarijayua, ritaja ima maikaoka imajiᵽarũkimarĩa sime”, ãñurã imarĩ, sareka ᵽuᵽajoatiyabekaja maimaye'e. ");
INSERT INTO tnc_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Ba'iaja mija ᵽuᵽaririka yiyaᵽabeyu. Maiᵽamakirika ba'irabeiki ᵽuri rõmimarĩka imarĩ, Jesúre yaᵽaikakaka takaja ᵽuᵽayuka. ");
INSERT INTO tnc_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","Rõmika imaki ᵽuri kirũmure jia jĩjimaka kika imaerã jia koka imarikakaka ᵽuᵽajoarijayuka. ");
INSERT INTO tnc_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","Ĩakõrĩ je'e, ikuᵽaka sime kiro'si: Tuᵽarãte yaᵽaika uᵽaka, suᵽabatirã kirũmure yaᵽaika uᵽakajaoka ᵽuᵽajoarijayuka kime. I'suᵽakajaoka sime rõmijãro'si. Tĩmiamarĩrã maiᵽamaki Jesucristorika ba'iraberika ᵽuᵽajoairã, “Ritaja kiro'si yija baarijayua ĩatirã jĩjimaka Cristore imarũ”, ãrĩrika ᵽuᵽajoarijayurã. Tĩmiairã ᵽuri natĩmiarãte jia jĩjimaka imaerã nimarũkiakakaoka ᵽuᵽajoarijayurã. ");
INSERT INTO tnc_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","“Mija tĩmiaria'si, i'suᵽakajaoka mija rõmie'ea'si”, mijare ãrĩbeyuki yi'i. Tuᵽarãte yaᵽaika uᵽakaja jia mija imarika yaᵽawa'ri i'suᵽaka mijare ñañu, aᵽerõ'õrã mija ᵽuᵽajoakoreka. ");
INSERT INTO tnc_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Bikijarãja kirũmuro'si kijaiᵽããtikakote ĩ'rĩkate e'ebeyua simamaka, “Koᵽakaja ᵽakiako kojayu mae, kore ye'eᵽaye'e”, ãrĩᵽuᵽajoawa'ri kore ke'ejĩka marã imabeyua. ");
INSERT INTO tnc_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Aᵽika ᵽuri kiᵽuᵽaka kire ãñu uᵽakaja rõmimarĩaja kimajĩka marã imabeyua. Maki jãjiaᵽi kire jã'meberijĩki imarĩ, kiyaᵽaika uᵽakaja jo'ribekaja kimarũ ãrĩwa'ri. Suᵽabatirãoka rõmimarĩaja imarika rakajeᵽããwãrũtirã i'suᵽaka kimajĩka jia sime. ");
INSERT INTO tnc_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","I'suᵽaka simamaka kirũmuro'si imatikakore e'eiki ᵽuri jia baaiki. I'suᵽaka simako'omakaja rõmimarĩaja imarika ᵽuᵽajoaiki imaki satẽrĩwa'ribaji jia ᵽuᵽajoaiki. ");
INSERT INTO tnc_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Tĩmiaika jaritikako kotĩmite õñia imañujukã'ãja aᵽikaka imaberijĩko. Kotĩmite reyajĩka be'erõ'õᵽi ᵽuri, aᵽika Jesúre yi'yukakajaoka kotĩmiarijĩkareka jia sime. ");
INSERT INTO tnc_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","I'suᵽaka simako'omakaja aᵽikate tĩmiaririka ᵽuᵽajoabekaja koimajĩka jiibaji koimajĩñu yireka. Yi'ioka Esᵽíritu Santore yire jeyobaaikaᵽi i'suᵽaka ãrĩrijiyuka. ");
INSERT INTO tnc_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Waᵽuju imaja jẽrãka jiyiᵽuᵽayeewa'ri wa'iro'si ri'ia sawãjitãji ji'aika uᵽaka naᵽããrijayuakaka ᵽaᵽeraᵽi yire mija jẽrĩaᵽũaraᵽaka mijare yibojaerã baayu mae. “Waᵽuju naᵽuᵽajoaika uᵽakaja nabaaeka sime”, ãrĩwãrũirã maime. I'suᵽaka simako'omakaja “Aᵽerãte tẽrĩwa'ribaji õñurã yija ᵽuri”, ãrĩkoᵽeirã mija ime. I'suᵽaka ᵽuᵽajoabekaja, jia wayuĩabu'abaraka majeyobaabu'arijariye'e. ");
INSERT INTO tnc_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","“Jia dakoa jariwa'ririmarĩaja õrĩᵽũairã jaritikarã yija ime”, ãᵽaraka waᵽuju jaiirã jia õrĩᵽũabeyurã imarã ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","Aᵽerã ᵽuri, jĩjimakaᵽi Tuᵽarãte noñua imarĩ, “Yirirã nime”, kẽñurã nime. ");
INSERT INTO tnc_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","“Waᵽuju imaja jẽrãka jiyiᵽuᵽayeebaraka wa'iro'si ri'ia naji'aekakaka maba'ajĩka”, mija ãñuakaka mijare yibojaerã baayu mae. “Waᵽuju imaja jiyiᵽuᵽaka noñua õñimarĩa sime. Tuᵽarã ĩ'rĩkaja imaki imatiyaiki”, ãrĩwãrũirã maime. ");
INSERT INTO tnc_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Waᵽuju imaja jiyiᵽuᵽayeerimaja ᵽuri “Wejeᵽemarã õika, ka'iarã ima oka majiyiᵽuᵽayeerũkia sime”, narĩᵽuᵽajoakoᵽeyu. Rita nañu, rĩkimakaja sime waᵽuju imaja najiyiᵽuᵽayeekoᵽeika. ");
INSERT INTO tnc_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","I'suᵽaka naᵽuᵽajoaika simako'omakaja, “Maᵽaki Tuᵽarã ĩ'rĩkaja imaki majiyiᵽuᵽayeetiyarũkika. Ritaja ᵽo'ijiaekaki imarĩ, kiyaᵽaika uᵽakaja mabaaerã mare kiᵽo'ijiaeka. I'suᵽaka simamaka Jesucristo ĩ'rĩkaja kime Maiᵽamaki. Ikiᵽi ãrĩwa'ri ritaja jia wejea Tuᵽarãte baaeka. Suᵽabatirã ikiᵽi ãrĩwa'ri õñia imajiᵽarika maro'si ima”, ãrĩᵽuᵽajoairã maime. ");
INSERT INTO tnc_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","I'suᵽaka maᵽuᵽajoako'omakaja aᵽerimarã Jesúre yi'yurã imariᵽotojo jia sakaka õrĩwaᵽu'abeyukajirã. Jesúre yi'yurã nimaerã baaeka ruᵽubajirã waᵽuju imaja jẽrãka najiyiᵽuᵽayeeka. “Ᵽo'imaja baarirata sime”, ãrĩwãrũbeyurã nime ruᵽu. Suᵽa imarĩ tuᵽarãreka je'awa'ri “Ba'arika naᵽããkoᵽeka mirãka yija ba'aika sajiyiᵽuᵽayeewa'ri yija baayu”, narĩᵽuᵽajoayu. I'suᵽaka ᵽuᵽajoawa'ri sanaba'akoᵽeika “Kire yi'ririja'ataiki uᵽaka yibaayu Tuᵽarãte ĩamaka”, ãñurã najayu. ");
INSERT INTO tnc_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","I'suᵽaka simako'omakaja ba'irĩjia maba'aika, maba'abeyuaoka imatiyabeyua sime Tuᵽarãro'si. “Samaba'abesarãkareka Tuᵽarãte mare wayuĩarãñu”, ãrĩrika ᵽuri imabeyua. I'suᵽakajaoka “Samaba'arãkareka jĩjimaka Tuᵽarãte maka imarãñu je'e”, ãñaokaro'simarĩaoka sime. ");
INSERT INTO tnc_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","“Dakoa mare jãjibaabeyua”, ãñurã mija imako'omakaja mija yaᵽaika uᵽakaja imarika mija rakajebe. I'suᵽaka mija imamaka jia Tuᵽarãte yi'riwaᵽu'abeyukajirãte ĩajĩkareka, mija ima uᵽakaja nabaajĩñu je'e. “Tuᵽarãreka jia sime, jiamarĩa sime je'e”, ãrĩwãrũbeyurã nimamaka ba'iaja nare mija baaruᵽutaika. ");
INSERT INTO tnc_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Ikuᵽaka sime: Jia õrĩwãrũirã imawa'ri “Waᵽuju imaja jẽrãkaro'siji ri'ia naᵽããkoᵽeka mirãka samaba'aye'e”, ãrĩwa'ri ba'arĩ sajiyiᵽuᵽayeeriwi'iarã mija kãkayu. I'suᵽaka samija ba'amaka ĩawa'ri, “Naba'aika uᵽakaja sayiba'arãñu yiro'sioka”, jia Tuᵽarãte yi'riwaᵽu'abeyukajikate ãrĩrãñu kiro'si. ");
INSERT INTO tnc_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","I'suᵽaka simamaka “Waᵽuju imajaro'si ri'ia naᵽããkoᵽeka mirãka maba'ajĩka marã imabeyua”, ãrĩwa'ri, mija ba'amaka ĩatirã, jia Tuᵽarãte yi'riwaᵽu'abeyukajikate saba'awa'ri ba'iaja kibaaᵽe'ayu ate. “Jia õrĩwãrũirã yija”, ãñurã imariᵽotojo mija jeyomakiro'si ba'iaja kibaaika waᵽa Cristore reyaĩjika simako'omakaja ba'iaja kire mija baaruᵽatayu. I'suᵽaka baawa'ri Cristore kiyi'rikoᵽeika ja'atatirã mamarĩ kimaeka mijirãja kijayua ba'itakaja sime. ");
INSERT INTO tnc_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","I'suᵽaka baawa'ri ba'iaja Jesucristore yi'yurãte mija baaruᵽutayu. “I'suᵽaka yija baamaka, ba'iaja yijaro'si simarãñu”, ãrĩwãrũriᵽotojo, i'suᵽaka mija baaika ĩatirã i'suᵽakajaoka aᵽerãte baayu. I'suᵽaka mija baaika naro'si takajamarĩa ba'iaja ima. “Yirirãte ba'iaja nabaaika simamaka, i'suᵽakajaoka yire nabaayu”, mijareka Cristore ãrĩᵽuᵽajoayu. ");
INSERT INTO tnc_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Suᵽa imarĩ ikuᵽaka mijare ñañu: “Ritaja yibaajĩka ĩaji'atirã yibaaika uᵽakaja baawa'ri ba'iaja aᵽikate jũaa'si ãrĩwa'ri i'suᵽaka yibaaberijĩñu.” ");
INSERT INTO tnc_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Ritaja Tuᵽarãte mare jãjibaabeyua yibaajĩkareka, marã imabeyua. ¿Aᵽóstolmarĩka ñime bai je'e? ¿I'suᵽakajaoka maiᵽamaki Jesúre ĩaeka mirãmarĩka ñime bai je'e? I'suᵽakajaoka aᵽea, “Ᵽablote wãrõmaka ã'mitiritirã Jesúre mayi'riũ'muraᵽe”, ¿mija ãrĩbeyu bai? ");
INSERT INTO tnc_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","“Aᵽóstolmarĩka Ᵽablote ime”, aᵽerãte ãrĩko'omakaja mijareka ᵽuri i'suᵽaka ᵽuᵽajoarika imabeyua je'e. Yiwãrõraᵽaka ã'mitiritirã Jesúre mija yi'raᵽaka simamaka, “Cristo ᵽũatarimaki kime Ᵽablo”, ãñurã mija ᵽuri. ");
INSERT INTO tnc_vpl VALUES ("C19_3","076_9_3","1CO","9","3","4","Ᵽo'imajare yire kẽrãjaimaka ã'mitiritirã ikuᵽaka nare yiyi'yu: Aᵽóstolrãka yija imakaka mija ᵽuᵽajoabe. Mijare wãrõrimaja yija imamaka, yijare mija ji'aika, okoa yijare mija sĩaika e'etoririmaja yija ima mija õñu. ");
INSERT INTO tnc_vpl VALUES ("C19_5","076_9_5","1CO","9","5","6","Mia, aᵽóstolrãka, Ᵽedro, Jesús be'erõ'õkarã narõmiaᵽitiyika Jesúre yi'yurãte turirijayu ᵽoto nare jeyobaarũkirã. Suᵽa imarĩ ritaja nare mija jeyobaaika uᵽakajaoka mija baarũkirã yija ime. Aᵽóstolrãka imarĩ, mijare yija wãrõko'omakaja ¿yijare ruku mija jeyobaaberijĩñu bai je'e? I'suᵽaka simako'omakaja, Bernabéka ba'irabetirã yija yaᵽaika yija tõᵽorijayu. ");
INSERT INTO tnc_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","Mija õᵽe. Waᵽa tõᵽoirã nime surararãka. I'suᵽakajaoka, iyaka õteiki sarikayu ᵽoto ¿kãkaerãmarĩa sakiõteyu bai je'e? Aᵽea mia: Oveja ĩarĩrĩrimaji sũᵽeokoa kibikerijayu ᵽoto ¿sukuberijĩki bai je'e mijareka? ");
INSERT INTO tnc_vpl VALUES ("C19_8","076_9_8","1CO","9","8","9","I'suᵽakamarĩa sime, maba'irabeikaᵽi ãrĩwa'ri sawaᵽa matõᵽoyu. Yija takajamarĩa imarã i'suᵽaka ãñurã. Tuᵽarãrika bojariroka o'oeka ᵽũñurãoka i'suᵽakaja sabojayu. Tuᵽarã ikuᵽaka Moisés imaekakite kio'orũjeka: “Trigo yaᵽea wa'ibikirãwẽkoa rĩ'kati'baaruirãka ‘Sakaka kũᵽajĩ kiba'arũ’, ãrĩwa'ri kiõmea mija ᵽi'ᵽea'si”, ãrĩwa'ri sabojayu Tuᵽarã oka ᵽũñurã. “Wa'ibikirãwẽko takaja jia kimarũ”, ãrĩwa'rimarĩa i'suᵽaka Tuᵽarãte bojaeka. ");
INSERT INTO tnc_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","Ᵽo'imajaro'si ᵽariji ᵽuᵽajoawa'ri i'suᵽaka Tuᵽarãte bojaeka. Ã'mitirikõrĩ je'e: Rioa ba'iraberimaja, suᵽabatirã trigo yaᵽea ka'rerimajaoka “Sakaka kũᵽajĩ yitõᵽoye'e yiro'sioka”, ãrĩᵽuᵽajoawa'ri sanaba'irabeyu. ");
INSERT INTO tnc_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","Suᵽa imarĩ Tuᵽarãrika mijare wãrõũ'muraᵽarã imarĩ, “Mare najeyobaarũ”, mijareka yija ãrĩᵽuᵽajoaika, ¿jiamarĩa sime bai je'e? ");
INSERT INTO tnc_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","Aᵽerã Jesucristorika wãrõrimajare “Mare wãrõrimaja nimarũ”, ãrĩwa'ri “Nare majeyobaaerã”, ãrĩᵽuᵽajoairã mija ime. I'suᵽaka mija ᵽuᵽajoaika simamaka, “Mamarĩtaka mare wãrõũ'muraᵽarã nime Ᵽablorãka. Suᵽa simamaka nare majeyobaatiyaye'e”, aᵽerãte tẽrĩwa'ribaji yijareka mija ãrĩᵽuᵽajoatiyarũkirã yija ime. I'suᵽaka simamaka “Yijare mija jeyobaabe”, mijare yija ãrĩjĩka, jia simakoᵽeyu. I'suᵽaka simako'omakaja, mijare yija jẽñeberaᵽe. “Niñerũ tõᵽoerã Ᵽablorãkare Jesúrika bojariroka wãrõyu”, ᵽo'imajare ãrĩᵽuᵽajoarikareka yija wãrõika na'mitiriᵽẽaberijããeka. Suᵽa imarĩ rĩkimakaja yija yaᵽaika imako'omakaja sarakajeᵽããwa'ri mijare yija jẽñeberaᵽe. ");
INSERT INTO tnc_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã wa'iro'sia ᵽo'imajare kiro'si tarijayu. Sajããtirã kiro'si najoeĩjirijayuakakaja torã ba'iraberimajare ba'arijayua jia õñurã mija ime. Bikijarãja “Yire najoeĩjirãkakaka naba'arãñu”, Tuᵽarãte ãrĩtika. ");
INSERT INTO tnc_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","I'suᵽakaja sime Jesúrika bojariroka wãrõrimajaro'si. Maiᵽamaki Jesúre ãrĩka “Nawãrõeka waᵽa koᵽakaja nare jeyobaarũkirã nime naka wãrũekarã.” ");
INSERT INTO tnc_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","“Tuᵽarã ᵽũatairãre majeyobaaye'e”, ãrĩka simako'omakaja ĩ'rãkurioka mijare yijẽñeberaᵽe. Yiwãrõriwaᵽa mijare jẽñebeyuka imarĩ, kẽsia yijĩrĩkoᵽejĩka marã imabeyua yiro'si. Ikuᵽaka mijaro'si yo'oika “Yire mija ĩjibe”, ãrĩwa'rimarĩa sayo'oyu. “Waᵽamarĩaja Jesúrika bojariroka yibojataᵽarijayu”, ãrĩwa'ri jĩjimaka ñime. ");
INSERT INTO tnc_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","I'suᵽaka ᵽuᵽajoaiki imariᵽotojo Jesúrika bojariroka ᵽo'imajare wãrõiki imarĩ, “Jiitaki ñime”, ñarĩᵽuᵽajoabeyu. Kirika yibojataᵽaerã Jesucristore ᵽũatariki imarĩ, yire kijã'meka uᵽakaja baarijarirũkika ñime. Ᵽo'imajare kirika yiwãrõberirikareka yire kijã'meka uᵽaka baabeyuka ñimajĩñu. ");
INSERT INTO tnc_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","Ñoñu uᵽakaja ᵽuᵽajoatirã yiwãrõrikareka ᵽuri, “Sawaᵽa yire nijirũ”, ñarĩjããeka. I'suᵽakamarĩa sime. Cristore yire jã'meka uᵽakaja baaiki imarĩ, aᵽerãte yiwãrõrijayu. Suᵽa imarĩ yire najeyobaamaka, suᵽabatirã najeyobaaberikoᵽemakaoka nare yiwãrõrijarirãñu. ");
INSERT INTO tnc_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","Ikuᵽaka sime yiro'si: Sawaᵽa tõᵽorikoᵽakaja, “Kire ã'mitiriᵽẽairãre Tuᵽarãte tããrũ”, ãᵽaraka yiwãrõyu. Suᵽa imarĩ mijare yiwãrõika waᵽa yiwaᵽajẽñejĩka simako'omakaja mijare yiwaᵽajẽñeberaᵽe. I'suᵽaka baaiki imarĩ, jĩjimaka ñime. ");
INSERT INTO tnc_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","Suᵽa imarĩ yire nawaᵽaĩjibeyua simamaka marãkã'ã baatirã ᵽo'imajare yire jã'mewãrũbeyu. I'suᵽaka simako'omakaja jia ᵽuᵽaiki imarĩ, “Rĩkimabaji ᵽo'imaja Jesucristore na'mitiriᵽẽarijarirũ”, ãrĩwa'ri i'suᵽaka yibaayu. ");
INSERT INTO tnc_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","Mija ĩabe: Judíotatarãka ñima ᵽoto, nima uᵽakaja ñimarijayu. I'suᵽaka ñimamaka “Jesúrika bojariroka nare yibojarãka ᵽoto yire ã'mitiriᵽe'yorimarĩaja, sanayi'rirũ”, ãrĩwa'ri i'suᵽaka ñimarijayu. I'suᵽakajaoka Moisés imaekakite jã'meka yi'yurãka ñima ᵽoto nuᵽakaja ñimarijayu. I'siakaka yi'riberirũkika imariᵽotojo Jesúre na'mitiriᵽẽarika yaᵽawa'ri, i'suᵽaka yibaayu. ");
INSERT INTO tnc_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","Judíotatamarĩrã imarĩ Moisére jã'meka õrĩbeyurãte Jesúrika bojariroka yibojarijayu. Naka ñima nuᵽakaja baariᵽotojo, Tuᵽarãte ĩamaka ba'ia baabekaja, Jesucristore yaᵽaika uᵽakaja yibaarijayu “Jia Jesucristore nayi'rirũ”, ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","Jia Tuᵽarãrika õrĩwaᵽu'aberiwa'ri “Iroka takaᵽi imawa'ri jia kika maimajĩñu je'e”, ãñurãka ñima ᵽoto, nuᵽakaja ñimarijayu. Ritaja najãjibaaikakaka niaika wãjitãji baabeyuka yi'i. Jia naka ñimamaka, yiwãrõika ã'mitiritirã “Jiibaji Jesucristore na'mitiriᵽẽarũ”, ãrĩwa'ri i'suᵽaka naka ñimarijayu. Ᵽo'imaja aᵽetatarãka ñima ᵽoto nuᵽakaja ñimarijayu. I'suᵽaka yibaarijayu “Kire ã'mitiriᵽẽairãte Jesúre tããrãñu”, ãrĩwa'ri yiwãrõika ã'mitiritirã ĩ'rãrimarãre kire yi'yaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","“Kire ã'mitiriᵽẽairãte Jesúre tããrãñu”, ãñuakaka ᵽo'imajare ã'mitiriᵽataokaro'si i'siakaka yiba'irabeyu. “Naᵽitiyika yijare jia Tuᵽarãte baarũ”, ãrĩwa'ri i'suᵽaka yibaarijayu. ");
INSERT INTO tnc_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","“Tuᵽarã ᵽõ'irã jía yija tõᵽorãñu”, ãrĩwa'ri kiyaᵽaika uᵽakaja baabaraka mija imarijaᵽe. Ã'mitirikõrĩ je'e. Rĩrĩrika ᵽo'imajare koyu ᵽoto, rĩkimarãja nime rĩrĩrimaja. Nakaki ĩ'rĩkaja imaki tẽrĩrũkika. Iki imaki jãjia rĩrĩtirã aᵽerãte ruᵽubajirã eyaiki imarĩ, sawaᵽa tõᵽoiki. Mamarĩ eyaũ'muiki uᵽaka jia okajãjiaᵽi Tuᵽarãte yaᵽaika uᵽakaja baabaraka mija imabe. ");
INSERT INTO tnc_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","Narĩrĩrã baaika ruᵽu “Aᵽerãte yitẽrĩye'e”, ãrĩwa'ri ĩ'rãrĩmi uᵽakaja narĩrĩkoririjayu. Rĩrĩkoᵽaraka ka'wisitaka najũayu sawaᵽa tõᵽoerã. Suᵽa imarĩ rĩᵽaraka tẽñukate ᵽũñuakaka kĩkeka bu'ya nijiyu kiruᵽuko'arã tuaokaro'si. Ᵽũñuakaka imarĩ, ñoaka imarũkimarĩa sime. I'suᵽakamarĩa sime maro'si ᵽuri. Sawaᵽa imajiᵽarũkia mo'abaraka maimarijayu. ");
INSERT INTO tnc_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","“Ikuᵽaka yibaarika Tuᵽarãte yaᵽayu”, ãrĩᵽuᵽajoawãrũtirã Tuᵽarãrika yiba'irabeyu. Ĩ'rĩka waᵽuju rĩrĩkoᵽeiki uᵽakamarĩa yibaayu. Aᵽea ĩakõrĩ je'e. Ĩ'rĩkaka yitutebu'ajĩka ᵽoto, waᵽuju kotorõ'õrãja tuteberijĩki yi'i. “Ikuᵽaka Tuᵽarãte yaᵽayu”, ãrĩwãrũtirã kirika yiba'irabeyu. ");
INSERT INTO tnc_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","I'suᵽaka ñimarijayu nare yiwãrõeka be'erõ'õ i'yoa yiᵽo'ia yibaakoreka. Suᵽa imarĩ “Jia Tuᵽarãrika yiba'iraberũ”, ãrĩwa'ri ka'wisijũariᵽotojo yirakajeᵽããrijayu. Jia kirika yiba'irabeika waᵽa kiᵽõ'irã yitõᵽoye'e ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Mija ã'mitiᵽe yija jeyomarã. Bikija judíotatarã ñekiarã imaekarã majaroka mija ye'kariria'si. Nimauᵽatiji oko ũmakakarokaᵽi Tuᵽarãte nare ruᵽutawa'rika. Suᵽabatirã Egiᵽtoka'iakarãre ru'ᵽaraka Okojũaka wãmeika riaᵽakiaka ũ'ᵽuaᵽi natẽrĩwaata'yaokaro'si nare kijeyobaaeka. ");
INSERT INTO tnc_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","I'suᵽaka Riaᵽakiaka Okojũaka wãmeika tẽrĩwaata'riwa'ri, oko ũmakakarokaᵽi turitaᵽawa'ri Moiséte bojaeka ã'mitiriᵽẽairã najarika. Cristore yi'riwa'ri ruᵽuko'a majũjerũjeika uᵽakaja naro'si simaeka. ");
INSERT INTO tnc_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","Suᵽabatirã ĩmiᵽi Tuᵽarãte ña'atarijarika maná nimarakamakiji naba'arijarika. ");
INSERT INTO tnc_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","I'sia be'erõ'õ okoa nare jitomaka, ãta watoᵽekaᵽi Tuᵽarãte okoa jururũjeka sanukuokaro'si. Sukutirã, natãrĩka. Ãta watoᵽekaᵽi okoa juruika takajamarĩa nare tããeka. Kire jẽrãko'abeyurã nimako'omakaja na'yu uᵽakaja Cristore nare ĩarĩrĩka imarĩ, ikiji i'suᵽaka naro'si baaĩjikaki. Ĩakõrĩ je'e: I'sia ãta uᵽaka Cristore imaeka. ");
INSERT INTO tnc_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","Tuᵽarã ĩ'rĩkaja kibaawãrũikaᵽi ba'arika, okoa nare kĩjika simako'omakaja rĩkimarãja Tuᵽarãte yaᵽaeka uᵽaka nabaaberika. Ba'iaja nabaarijarika simamaka, jĩjimaka Tuᵽarãte naka imaberika. Suᵽa imarĩ kire nayi'riberika ᵽi'iwa'ri ᵽo'imajamatorã nareyarijarika. ");
INSERT INTO tnc_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","“I'suᵽaka yija ñekiarãre jũaeka”, ãrĩwãrũriᵽotojo nabaaeka uᵽaka baabekaja maimaye'e. ");
INSERT INTO tnc_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","Suᵽa imarĩ waᵽuju imaja jẽrãka ĩ'rãrimarã yija ñekiarãte jiyiᵽuᵽayeeka uᵽaka mija baa'si. Ritaja nimarijarika mirãkakaka Tuᵽarã majaroᵽũñurã ikuᵽaka sabojayu: “Waᵽuju imaja jiyiᵽuᵽayeebaraka, ukurũkia ukuwejabiᵽaraka, ba'abaraka nimaeka. Suᵽabatirã ba'iaja baawã'imaᵽaraka nabayatããeka”, ãrĩwa'ri sabojayu. ");
INSERT INTO tnc_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","I'suᵽaka baawa'ri ĩmirĩja rõmijãᵽitiyika ba'iaja baawã'imaᵽaraka nimaeka. Saᵽi ãrĩwa'ri 23,000 rakamarã ĩ'rãrĩmiji nareyaᵽataeka. I'suᵽaka najũaeka õñurã imarĩ nabaaeka uᵽaka baabekaja maimaye'e. ");
INSERT INTO tnc_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","Ika ruᵽubajirã, ba'iaja nabaarijarika simako'omakaja “Maiᵽamakite ba'iaja mare baabesarãñu”, ãrĩwa'ri ĩ'rãrimarã yija ñekiarãre baaeka uᵽaka mabaaberiye'e. I'suᵽaka ba'iaja nabaaeka ĩawa'ri ãñaka naᵽõ'irã kiᵽũataeka saᵽi ĩ'rãrimarãre jĩñaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","Ikuᵽaka sime aᵽea ĩakõrĩ je'e: Niᵽamaki kimaerã Tuᵽarãte wã'maekakire nakẽrãjaika ĩ'rãrimarã. “Moisére kiwã'maberiri imakoᵽeraᵽe Tuᵽarã”, ãrĩwa'ri ba'iaja nabaariᵽareaja ĩ'rĩka ángel Tuᵽarãte ᵽũataeka nare kiriataokaro'si. I'suᵽaka najũaeka simamaka nabaaeka uᵽaka baabekaja mija imabe. ");
INSERT INTO tnc_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","Ritaja yija ñekiarãro'si simaeka uᵽakaja o'oeka sime Tuᵽarã oka ᵽũñurã. Wejetiyia eyaerã baawa'ri i'suᵽakajaoka maro'si sime ika majaroka. I'suᵽaka najũaeka õrĩtirã, nabaaeka uᵽaka ba'iaja mabaakoreka kiriᵽũñurã o'oeka sime. ");
INSERT INTO tnc_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Suᵽa imarĩ “Tuᵽarãte yi'ririkakaka jia õrĩtirã imarĩ, ba'iaja mabaabeyu”, ãrĩriᵽotojo ba'iaja baarika marakajejĩñu. ");
INSERT INTO tnc_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Suᵽa imarĩ “Ba'iaja baarika yijare jitoika uᵽaka jũabeyurã je'e aᵽerã”, mija ãrĩᵽuᵽajoaika, ritamarĩa sime. I'suᵽakajaoka sime aᵽerãro'sioka. Mijare kẽrĩka uᵽakaja jeyobaarũkika kime Tuᵽarã. Suᵽa imarĩ “Ba'iaja baarika yijare jitoika”, ãrĩᵽuᵽajoariᵽotojo, mija ᵽuᵽaka mijare ãñu uᵽaka baabekaja mija imawãrũrijayu. Ba'iaja baarika mijare jitokoᵽerãka ᵽoto kirika Tuᵽarãte mijare ja'atarãñu. I'suᵽaka kibaamaka samija rakajeᵽããrãñu. ");
INSERT INTO tnc_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","Suᵽa imarĩ ikuᵽaka mijare ñañu yijeyomarã. Ba'iaja waᵽuju imaja jẽrãka ᵽo'imajare jiyiᵽuᵽaka õñua ĩaᵽẽabekaja mija imabe. ");
INSERT INTO tnc_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","Jia õrĩᵽuᵽakirã imarĩ, “Rita Ᵽablote mare bojayu”, ãrĩᵽuᵽajoawãrũirã mija ime. ");
INSERT INTO tnc_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","Ᵽiyia Jesúre ba'aekakaka ᵽuᵽajoabaraka maba'arãka ᵽoto, “Yiriwea sime iyaokoa”, ãᵽaraka maro'si kija'ataeka simamaka iyaokoa maᵽibaukurijayu. Suᵽa imarĩ sukuerã baaeka, “Jia mibaayu Jesús. Ba'iaja yija baaika waᵽaĩjirã yijaro'si mireyaeka”, ãñaokaro'si marẽrĩrijayu. I'suᵽaka mabaaika simamaka “Kirirã maime”, marĩrijayu. Suᵽabatirã “Yiᵽo'ia sime ᵽan”, ãrĩwa'ri maro'si sakija'ataeka simamaka, saᵽibaba'aerã baaeka, “Yaᵽua tetaekarã Jesúre maro'si reyaĩjikatatarã maime”, mañu. ");
INSERT INTO tnc_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Jesúrirã maima simamaka ĩ'rãtokakaja ᵽan maᵽibaba'arijayu. I'suᵽaka mabaaika simamaka, rĩkimarã imariᵽotojo Tuᵽarãka ĩ'rĩka ta'iarãja imarã maime. ");
INSERT INTO tnc_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","Israel ka'iakarãre baarijayua ᵽuᵽajoaikõrĩ je'e. Wa'iro'si ri'ia Tuᵽarãte najoeĩjirijayuakakaja kũᵽajĩ naba'arijayu. I'suᵽaka ba'airã imarĩ ĩ'rĩka uᵽakaja Tuᵽarãte jiyiᵽuᵽayeeirã nime. ");
INSERT INTO tnc_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","I'suᵽaka simako'omakaja “Waᵽuju imaja jẽrãka ᵽo'imajare baaeka simamaka, wa'iro'si ri'itakaja sanijirijayua, imatiyabeyua sime”, ãrĩwa'ri i'suᵽaka mijare ñañu. ");
INSERT INTO tnc_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","Ikuᵽaka simatiyayu mijare yibojaika: Tuᵽarãte õrĩbeyurã waᵽuju imajaro'si ri'ia naᵽããika ᵽoto Satanárika ima jiyiᵽuᵽayeewa'ri suᵽa nabaayu. Suᵽa imarĩ i'suᵽaka baairãka jeyoaᵽaraka mija ba'aika ᵽoto Tuᵽarãte jiyiᵽuᵽayeerikoᵽakaja, Satanárika ima jiyiᵽuᵽaka mija õñu. Suᵽa imarĩ i'suᵽaka mija baaika yiyaᵽabeyu. ");
INSERT INTO tnc_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","Maiᵽamaki Cristore reyaekakaka ᵽuᵽajoawa'ri iyaokoa ᵽibaukubaraka, ᵽan ᵽibaba'abaraka imarijayurã maime kirirã imarĩ. I'suᵽaka imarã imarĩ, waᵽuju imaja jiyiᵽuᵽayeeriwi'irã ba'arika naᵽããikakaka ba'abekaja, ukubekajaoka mija imabe Satanárika imaᵽitiyika mija jeyoarikoreka. ");
INSERT INTO tnc_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","“Yirirã imariᵽotojo ba'irãka najeyoarijayu”, ãrĩwa'ri Maiᵽamakire boebarirũjebekaja maimaye'e. Kire tẽrĩwa'ribaji baawãrũbeyurã imarĩ ba'iaja mijare kibaarũkiareka tãrĩwãrũbesarãñurã mija ime. ");
INSERT INTO tnc_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","Mia je'e, ikuᵽaka imaja yi'yurã mija ime: “Tuᵽarãreka marã imabeyua yijaro'si yija yaᵽaika uᵽakaja baarika”, ãrĩwa'ri mija bojayu. I'suᵽaka maᵽuᵽaka mare ãñua simako'omakaja ritaja mabaariyaᵽaika mare jeyobaabeyua sime. I'suᵽakajaoka Tuᵽarãte yaᵽaika baairã majayaokaro'si ritaja mabaariyaᵽaika mabaajĩka ᵽoto mare jeyobaabeyua sime. ");
INSERT INTO tnc_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Suᵽa imarĩ jia maimarũkitakaja ᵽuᵽajoabekaja aᵽerãte jia imaokaro'si nare jeyobaarikaoka maᵽuᵽajoaye'e. ");
INSERT INTO tnc_vpl VALUES ("C110_25","076_10_25","1CO","10","25","26","Mia, ika ka'iareka ima ritaja Tuᵽarãte ᵽo'ijiaeka sima imarĩ dika jariwa'ririmarĩaja kirika oyiaja sime. Saᵽi ãrĩwa'ri ritaja maba'aika jia oyiaja ima. I'suᵽaka simamaka wa'iro'si ri'ia aᵽea ritaja nawaᵽaĩjirõ'õ “¿Waᵽuju imaja jiyiᵽuᵽayeeriwi'ikakamarĩ bai sime?”, ãrĩwa'ri jẽrĩabekaja sawaᵽaĩjitirã, mija yo'aba'abe. ");
INSERT INTO tnc_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","Jesúre yi'ribeyuka, “Yiᵽõ'irã mija ba'araᵽe”, ãrĩwa'ri, mijare kibojarãka, mija a'rirãka, kiruᵽutaba'arãka uᵽakaja kire yi'ribi'abekaja mija ba'abe. Suᵽabatirã “¿No'okaka sime ika ri'ia?”, ãᵽaraka jẽrĩabekaja samija ba'abe. ");
INSERT INTO tnc_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","Suᵽa simako'omakaja “Waᵽuju imaro'si naᵽããika mirãka simamaka ba'iaja sime je'e aᵽeyari”, ĩ'rĩkate mijare ãrĩrãkareka, kire wayuĩawa'ri, mija ba'a'si. I'suᵽaka mija baamaka kiwayuᵽi'ribesarãñu. ");
INSERT INTO tnc_vpl VALUES ("C110_29","076_10_29","1CO","10","29","30","“Ritaja ba'arika oyiaja sime”, mija ãñua simako'omakaja, “ ‘Samija ba'a'si’, ãñukate ba'iaja ᵽuᵽaria'si”, ãrĩwa'ri i'suᵽaka mijare ñañu. Mija ã'mitiᵽe. “Ritaja maba'aika marã imabeyua”, ãñuka imarĩ, aᵽerãte ba'iaja baawa'rimarĩa sayiba'aika imarĩ, ¿dako baaerã ĩ'rãrimarã jaijairiᵽareaja sayiba'aja'atajĩñu je'e? Suᵽabatirã ba'aerã baaeka “Jia mibaayu Tuᵽarã”, ñarĩrijayua simamaka ba'iaja yireka jairijaririka imabeyua. ");
INSERT INTO tnc_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Ikuᵽaka simatiyayu mija ĩabe. Ritaja maba'aika rakakaja, maba'abeyu ᵽotooka, mukurijayu rakakaja, i'suᵽakajaoka ritaja mabaarijayu rakakaja, Tuᵽarãte yaᵽaika uᵽaka oyiaja mabaarijariye'e ᵽo'imajare jiyiᵽuᵽaka kire õñaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","Suᵽa imarĩ “Jia Jesucristore nayi'rirũ”, ãrĩwa'ri judíotatarã, judíotatamarĩrãoka, aᵽerã Jesúre yi'yurãre ba'iaja mija baaruᵽutakoreka, jia mija ᵽuᵽajoabe. ");
INSERT INTO tnc_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","Yi'i ᵽuri ikuᵽaka ᵽuᵽajoaiki: Ritaja yibaaika jĩjimakaᵽi ᵽo'imajare ĩarika yiyaᵽayu. Suᵽa imarĩ ñimarũkia takaja yiᵽuᵽaribeyu. “Jesúre ã'mitiriᵽẽawa'ri jia ᵽo'imajare imarũ”, ãrĩwa'ri, ba'iaja imarika tiyibeyurõ'õrã na'rirũkia imakoᵽeikareka Tuᵽarãte nare tããrika yiyaᵽayu. ");
INSERT INTO tnc_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","Jesúre wã'maekaki imarĩ kire ã'mitiriᵽẽawa'ri kimaeka uᵽakaja yibaayu yiro'si. Suᵽa imarĩ yibaaika uᵽakaja mija baabe mijaro'sioka. ");
INSERT INTO tnc_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","Mija ã'mitiᵽe yijeyomarã. Mijare yiwãrõraᵽaka uᵽakaja baarijayurã mija ime. Suᵽa imarĩ samija ye'kariribeyua simamaka jĩjimaka ñime. ");
INSERT INTO tnc_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","Aᵽea ikuᵽaka ima mija õrĩrika yiyaᵽayu. Ĩmirĩja ruᵽuko'amaki kime Jesús. I'suᵽakajaoka rõmijãro'si nime natĩmiarã. I'suᵽakajaoka Jesús ruᵽuko'amaki kime Tuᵽarã. ");
INSERT INTO tnc_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","Narẽrĩriwi'iarã Tuᵽarãte najaika ᵽoto, kirika kiro'si bojaĩjibaraka sayaᵽãiaᵽi naruᵽuko'arã ja'aᵽeabekaja ĩmirĩjare jairijayu. Ĩ'rĩka ᵽuri kiruᵽuko'a kija'aᵽearikareka “Yiruᵽuko'amakimarĩka kime Cristo”, ãñu uᵽaka kire jiyiᵽuᵽayeebeyuka uᵽaka kibaayu. ");
INSERT INTO tnc_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","Rõmijã ᵽuri, Tuᵽarãte jaibaraka, kirika bojariroka kiro'si bojaĩjibarakaoka, naruᵽuko'arã sayaᵽãiaᵽi ja'aᵽeaeka imarũkirã nime. Rõmo koruᵽuko'arã ja'aᵽeabeyuko ᵽuri kotĩmite jiyiᵽuᵽaka õrĩbeyuko uᵽaka kobaayu. Koruᵽua wi'eᵽatekako uᵽaka i'yoa imako. ");
INSERT INTO tnc_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","I'suᵽaka simamaka koruᵽuko'arã ja'aᵽearika yaᵽabeyuko ᵽuri, sarekaja koruᵽua kowi'eᵽataᵽarũ. Saᵽi ãrĩwa'ri “Jiamarĩa yiro'si sime”, ãñuko imarĩ, koruᵽuko'arã koja'aᵽearũ. ");
INSERT INTO tnc_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","I'suᵽaka simako'omakaja narẽrĩriwi'iarã Tuᵽarãte najairãka ᵽoto ĩmirĩja ᵽuri naruᵽuko'arã ja'aᵽearũkimarĩrã imarã Tuᵽarãte kirika uᵽakaja kiᵽo'ijiaeka maimamaka. I'suᵽaka mare kibaaeka simamaka “Ritaja jia baaiki Tuᵽarã”, mañu. I'suᵽakajaoka ĩmirĩjika rũmu imarĩ, koruᵽuko'arã ja'aᵽeaiko koime “Kore imaruᵽutarimaji kotĩmite ime”, mañaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","Ikuᵽaka sime: Ĩmirĩjire Tuᵽarãte ᵽo'ijiaeka ᵽoto rõmo yatawi'iũ'aᵽimarĩa kire kiᵽo'ijiaeka. Rõmore ᵽuri ĩmirĩji yatawi'iũ'a e'etatirã kiᵽo'ijiaeka. ");
INSERT INTO tnc_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","Suᵽa imarĩ, ĩmirĩjite jeyomarĩa imamaka, ĩawa'ri rõmore Tuᵽarãte ᵽo'ijiaeka. Rõmore, jeyomarĩa imamaka, ĩawa'rimarĩa. ");
INSERT INTO tnc_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","Suᵽa imarĩ “Yijare imaruᵽutarimaja imarĩ, yija ruᵽuko'amarã nime yija jeyomarã”, ãrĩwa'ri naruᵽuko'arã ja'aᵽeatirã, narẽrĩriwi'iarã najaika ᵽoto jia sime rõmijãro'si. Suᵽabatirã i'suᵽaka nabaamaka ĩawa'ri “Jia sime”, ángelrãkare ãñaokaro'si, naruᵽuko'arã rõmijãre ja'aᵽearũ. ");
INSERT INTO tnc_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","I'suᵽaka simako'omakaja, maiᵽamaki Jesucristore yi'yurã imarĩ, rõmijã naro'siji, ĩmirĩja naro'sijioka imaberijĩrã. Ĩ'rãtiji ᵽuᵽariwa'ri jeyoaᵽaraka imarũkirã maime. ");
INSERT INTO tnc_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","Ã'mitirikõrĩ. Ĩmirĩji yatawi'iũ'aᵽi rõmore Tuᵽarãte ᵽo'ijiaeka. I'suᵽaka simako'omakaja rõmijãᵽi ᵽo'ijiyurã maime. Ĩ'ᵽarãwã'taja Tuᵽarãte ᵽo'ijiaekarã oyiaja maime. ");
INSERT INTO tnc_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","Jia ᵽuᵽajoaeka mija imabe. Rẽrĩriwi'iarã sayaᵽãia ruᵽuko'arã ja'aᵽeabekaja Tuᵽarãte kojaijĩka ¿yaje jia simajĩñu je'e mijareka? Jẽno'o jiamarĩa simajĩñu. ");
INSERT INTO tnc_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","Suᵽabatirãoka, “Ruᵽua jĩ'ĩbeyurã watoᵽekarã ĩ'rĩka ĩmirĩjite ruᵽua jĩ'ĩjĩka i'yoa simajĩñu kiro'si”, ãrĩᵽuᵽajoaᵽatairã maime. ");
INSERT INTO tnc_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","Rõmore ᵽuri ruᵽua ñoaka kojĩ'ĩmaka jiyuriko kore maiyu. Suᵽa imarĩ ruᵽua ñoaka jĩ'ĩwa'ri koruᵽuko'arã ja'aᵽeaiko koime. ");
INSERT INTO tnc_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","Ika mijare yibojaika ã'mitiririyaᵽaberiwa'ri “I'suᵽakamarĩa sime”, ĩ'rãrimarãre ãrĩrãkareka ikuᵽaka nare ñarĩrãñu: Yija uᵽaka aᵽea wejeareka Jesúre ã'mitiriᵽẽabaraka imarã “Nare yija bojarijayua yi'riwa'ri ĩ'rãtiji oyiaja simauᵽakaja sabaarijayurã nime”, ãrĩwa'ri yibojayu. ");
INSERT INTO tnc_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","Mae ate ika mijaro'si yo'oyu: Tuᵽarãte jiyiᵽuᵽayeeokaro'si rẽrĩtirã jia imarikoᵽakaja ba'iaja mija baabu'arijayua simamaka “Jia oyiaja baairã mija ime”, mijareka ñarĩbeyu. ");
INSERT INTO tnc_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","“Narẽrĩrijayu ᵽoto ĩ'rãtiji ᵽuᵽajoaberiwa'ri ba'iaja naro'si simarijayu”, nañua mija majaroka ña'mitiyu. “Rita sime je'e aᵽeyari”, ñarĩᵽuᵽajoayu. ");
INSERT INTO tnc_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","Jia ĩ'rãtiji imabu'aberiwa'ri mija ᵽibikoᵽejĩka marã imabeyua je'e. Mija rakakaja mija ãrĩᵽuᵽajoairoka õrĩwãrũtirã, “Ĩ'rã nime wãjia ᵽuᵽajoatirã Tuᵽarãte yaᵽaika uᵽakaja baairã”, marĩwãrũyu. ");
INSERT INTO tnc_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","Jesúre ᵽiyia ba'aeka uᵽaka rẽrĩtirã mija ba'aika ᵽoto mija wãjitãji takaja ᵽuᵽajoairã imarĩ, Maiᵽamakire jiyiᵽuᵽayeebeyurã uᵽaka mija baayu. ");
INSERT INTO tnc_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","Ĩaikõrĩ je'e. Ba'arika mija ba'aika ᵽoto wayuoka baairãte ᵽibabekaja mija ba'ayu “Yijarikaja sime”, ãrĩwa'ri. I'suᵽaka mija baamaka, ba'arimarĩa imarãre kẽsirabarijayu. Aᵽerã ᵽuri jia rĩkimaka ba'atirã, jĩjimakaᵽi ukuwejabiririjayurã. ");
INSERT INTO tnc_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","¿Jia sime bai je'e? Mijaro'siji ba'arika mija yaᵽaye'e mija wi'iarã a'ritirã mija ba'abe. Aᵽerã jia ba'atõᵽobeyurãte ĩaika wãjitãji mija ba'aika ba'iaja i'yoa nare mija jũarũjeyu. Suᵽabatirã Jesúre ã'mitiriᵽẽairã nimako'omakaja nare ĩariᵽe'yoirã uᵽaka mija baayu. I'suᵽaka mija baaika õrĩwa'ri, “Jia baairã mija ime”, ¿mijare ñarĩrãñu bai je'e? Jẽno'o, jiamarĩa sime. ");
INSERT INTO tnc_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","Maiᵽamakire yire wãrõekakaka, koᵽakaja mijare yiwãrõtiraᵽe. I'suᵽaka simako'omakaja mijare sayibojaerã baayu ate. Maiᵽamaki Jesúre nañi'aerã Judare bojajããeka ñami, ᵽan Jesúre e'erikaeka. ");
INSERT INTO tnc_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","Se'erikatirã, “Jia mibaayu Tuᵽarã”, kẽrĩka. Sañakatarutirã ikuᵽaka kika wãrũrimajare kẽrĩka: “Ãja'a, mija ba'abe. Ika sime yiᵽo'ia. Mijaro'si yireyarãñu. Yireyarãka be'erõ'õ mijaro'si yibaaeka mirãka mija ᵽuᵽajoabe. Yire ᵽuᵽajoarija'ataberiwa'ri ikuᵽakaja rẽrĩbaraka samija ba'arijaᵽe”, kika wãrũrimajare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","Naba'aeka be'erõ'õ i'suᵽakajaoka iyaokoko'a Jesúre e'erikaeka. Torãjĩrã ikuᵽaka nare kẽrĩka: “Ãja'a, mija ukube. Mijaro'si riwejurubaraka yireyarãñu. ‘Kiriweaᵽi ãrĩwa'ri ikuᵽaka jia ᵽo'imajare yibaarãñu’, Tuᵽarãte ãrĩka uᵽakaja simarijarirãñu mae. Yireyarãka be'erõ'õ mijaro'si yibaaeka mirãka ᵽuᵽajoabaraka yire ye'kariᵽekaja ikuᵽaka rẽrĩtirã samija ukurijaᵽe”, nare kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","Ᵽan maba'arãka, iyaokoa mukurãka koᵽakaja maro'si Jesúre reyaeka. Maiᵽamakire etarãkarõ'õjĩrã jẽrãika, ikuᵽaka baawa'ri maro'si Jesúre reyaekakaka ᵽo'imajare mija baabeayu. ");
INSERT INTO tnc_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","Ikuᵽaka simatiyayu: Jesúre ã'mitiriᵽẽairãte wayuĩabeyuka imariᵽotojo Maiᵽamakire ᵽiyia ba'aeka uᵽaka kibaajĩka, jiamarĩa baaiki kime. I'suᵽaka baaiki ᵽuri maro'sitaka Maiᵽamakire riwejurubaraka reyaeka õrĩwãrũberiwa'ri, ba'iaja kibaayu. ");
INSERT INTO tnc_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","I'suᵽaka simamaka Maiᵽamakire ᵽiyia ba'aekakaka ba'aerã baaeka, ukuerã baaekaoka jia maᵽuᵽajoaye'e. “Cristorirãre wayuĩabekaja ba'itakaja nare yibaayu”, maᵽuᵽakaᵽi marĩjĩkareka, ba'iaja nare mabaarijayua maja'atajĩñu. ");
INSERT INTO tnc_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","Jesúrirãre wayuĩabeyurã imariᵽotojo ᵽan waᵽuju maba'amaka, iyaokoa mukumakaoka ba'iaja Tuᵽarãte mare jũarũjerãñu. ");
INSERT INTO tnc_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","I'suᵽaka simamaka waᵽuju saba'aekarã rĩkimarãja mija rũetaayu. I'suᵽaka imawa'ri ĩ'rãrimarãre reyarijayu. ");
INSERT INTO tnc_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","Maba'aerã baarãka ruᵽu maimakaka ᵽuᵽajoatirã aᵽerãte mawayuĩabeyua maja'ataye'e. I'suᵽaka mabaamaka sawaᵽa Tuᵽarãte mare waᵽajẽñebesarãñu. ");
INSERT INTO tnc_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","Maiᵽamakite ba'iaja mare jũarũjeyu ate ba'iaja mabaaᵽe'akoreka. I'suᵽaka baawa'ri kire yi'ribeyurãte ba'iaja baarũkirĩmi seyarãka ᵽoto naka ba'iaja mare kijũarũjebesarãñu. ");
INSERT INTO tnc_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","Yijeyomarã, Jesúre ᵽiyia ba'aekakaka ba'aerã baaeka mija rẽrĩrãka, ĩ'rĩka jariwa'ririmarĩaja ĩ'rãtiji jajumarĩaja mija ba'abe. ");
INSERT INTO tnc_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","Mija wi'iaᵽi jia ña'ᵽirika ba'atirã rẽrĩriwi'iarã mija a'ᵽe kẽsia torã mijare baakoreka. Rẽrĩriwi'iarã mija ba'aika ᵽuri jia mija ña'ᵽiokaro'simarĩaja ima. I'suᵽaka ĩ'rãtiji jia jajumarĩa mija ba'arãkareka ba'iaja Tuᵽarãte mijare baabesarãñu. Mija ᵽõ'irã eyatirã aᵽeakaka mijare yibojarãñu. ");
INSERT INTO tnc_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","Mae aᵽea ᵽaᵽeraᵽi yire mija jẽrĩaᵽũataeka mijare yibojaerã baayu. Jia ᵽuᵽajoabaraka Cristorika maba'irabewãrũerã Esᵽíritu Santore mare ja'ataekakaka mija õrĩrika yiyaᵽayu yijeyomarã. ");
INSERT INTO tnc_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","Jesúre mija yi'rirã baaeka ruᵽubajirã, Satanárika ᵽakiriroka yi'rira'aekarã imarĩ, waᵽuju imaja jẽrãka jiyeka maka jaibeyua mija jiyiᵽuᵽayeeka. ");
INSERT INTO tnc_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","Suᵽa imarĩ ikuᵽaka mijare yibojaũ'muyu: “Ba'iaja Jesúre jũarũ”, ãrĩbeyuka kime Esᵽíritu Santore kireka ña'rĩjãikamaki. Suᵽabatirã Esᵽíritu Santore jeyobaaikaᵽi takaja “Maiᵽamakitaki kime Jesús”, ĩ'rĩkate ãrĩwãrũrijayu. ");
INSERT INTO tnc_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","Cristorika ĩ'rĩka uᵽakaja maba'irabewãrũokaro'si kirika Esᵽíritu Santore mare ja'atayu. Rakakaja mabaarũkia mare kija'ataika simako'omakaja Esᵽíritu Santo ĩ'rĩkaja imaki mare saja'atarimaji. ");
INSERT INTO tnc_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","Tuᵽarãte yaᵽaika uᵽakaja Maiᵽamakirika maba'irabeyu. Rakakaja kirika maba'irabeika simako'omakaja Maiᵽamaki ĩ'rĩkaro'siji maba'iraberijayu. ");
INSERT INTO tnc_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","Kirika Tuᵽarãte mare ja'atayu, Jesúre yi'yurãte jia majeyobaaokaro'si. Marakakaja aᵽeba'ikaka kija'ataika imako'omakaja, Tuᵽarã ĩ'rĩkaja i'suᵽaka baaiki. ");
INSERT INTO tnc_vpl VALUES ("C112_7","076_12_7","1CO","12","7","8","Ikuᵽaka Esᵽíritu Santore rakakaja mare ja'ataeka majeyobaabu'awãrũokaro'si: Ĩ'rãrimarãre “Jia ᵽuᵽajoatirã bojawãrũirã nimarũ”, ãrĩwa'ri norĩwãrũokaro'si Esᵽíritu Santore nare ja'atayu. Aᵽerã ᵽuri Tuᵽarãte kirika jia nare õrĩwaᵽu'atarũjeyu, “Ᵽo'imajare sanabojawãrũrũ”, ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","Aᵽerã imarã “Yija jẽñeika uᵽakaja Tuᵽarãte yi'ririjarirãñu”, ãñurã. Jĩñurãte natããwãrũerã kirika Esᵽíritu Santore ja'ataekarã nime aᵽerã. ");
INSERT INTO tnc_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","Esᵽíritu Santo kirikaᵽi aᵽerãte jeyobaaiki maikoribeyua nabaabeawãrũerã. Aᵽerã “Nare yibojaika ã'mitiritirã yiro'si bojawaᵽu'atarimaja nimarũ”, ãrĩwa'ri kirika Esᵽíritu Santore nare ja'atayu. Aᵽerã imarã, “Ĩ'ĩ kime Esᵽíritu Santore jã'meikaᵽi jaiki. Ĩ'ĩ ᵽuri Satanárika ima kire jã'memaka i'suᵽaka jaiki”, narĩwãrũokaro'si Esᵽíritu Santore nare jeyobaayu. Na'mitiribeyua aᵽerã oka imakoᵽeikaja najaiwãrũerã Esᵽíritu Santore jeyobaayu aᵽerãte. I'suᵽakajaoka na'mitiribeyua simako'omakaja aᵽerãte jaika uᵽakaja nabojarikatawãrũerã kijeyobaayu aᵽerãte. ");
INSERT INTO tnc_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","Ĩ'rĩkaja kime Esᵽíritu Santo kirikaᵽi mabaarijayu rakakaja mare ja'ataiki. Kiyaᵽaika uᵽaka oyiaja mabaawãrũerã i'suᵽaka mare kijeyobaayu. ");
INSERT INTO tnc_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","Maᵽo'iarã ritaja imariᵽotojo ĩ'rã ᵽo'iji sime. Ã'mitirikõrĩ je'e. Ᵽitaka, ñakoa, ã'mua, ũ'ᵽua ritaja ima maᵽo'iarã. I'suᵽakajaoka maime Jesucristore ã'mitiriᵽẽairã. Rĩkimarãja imariᵽotojo Cristore oyiaja ã'mitiriᵽẽairã imarĩ, jeyobaabu'abaraka ĩ'rĩka uᵽaka oyiaja imarã maime. ");
INSERT INTO tnc_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","Ritaja tatarã maime. Judíotatarã, judíotatamarĩrãoka, suᵽabatirã aᵽerãte ba'irabeĩjirã imarĩ, nayaᵽaika uᵽaka baawãrũbeyurã, aᵽerã imarã nabaariyaᵽaika uᵽaka baawãrũrijayurã. I'suᵽaka maimako'omakaja ruᵽuko'a majũjerũjeka ᵽoto ĩ'rĩka ta'iarãja Esᵽíritu Santore mare imarũjeka. Jesucristore ã'mitiriᵽẽatirã Esᵽíritu Santore ña'rĩjãikarã oyiaja majarika. ");
INSERT INTO tnc_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","Ĩ'rã ᵽo'iji maᵽo'ia imariᵽotojo ritaja sime sareka. ");
INSERT INTO tnc_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","Ũ'ᵽua jaika imarikareka, “Ᵽitaka uᵽakamarĩa ñima simamaka, ᵽo'iarekamarĩa ñime”, ãrĩkoᵽeko'omakaja ᵽo'iarekaja ima sime. ");
INSERT INTO tnc_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","I'suᵽakajaoka ã'mua jaika simarikareka, “Ñakomarĩa ñima simamaka, ᵽo'iarekamarĩa ñime”, ãrĩriᵽotojo ᵽo'iarekajaoka ima sime. ");
INSERT INTO tnc_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","Ñakotaojo maᵽo'ia imarikareka, dakoaᵽi ma'mitiriberijããeka. Ã'mutakaja simarikarekaoka dakoaᵽi mawĩ'ĩberijããeka. ");
INSERT INTO tnc_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","Ikuᵽaka sime. Maᵽo'ia imarũkia kiyaᵽaeka uᵽakaja Tuᵽarãte mare ᵽo'ijiaeka. I'suᵽakajaoka sime Jesucristore yi'yurãro'si. “Rĩkimarãja imariᵽotojo ĩ'rãtata uᵽaka nimarãñu”, Tuᵽarãte ãrĩtika sime. ");
INSERT INTO tnc_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","Ĩ'rãba'ikakaja maᵽo'ia imarikareka ᵽo'imarĩa simajããeka. ");
INSERT INTO tnc_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","Ikuᵽaka simatiyayu: Maᵽo'iareka ritaja mareka simako'omakaja ĩ'rãᵽo'iji sime maᵽo'ia. I'suᵽakajaoka maime Jesúre ã'mitiriᵽẽairã. Rĩkimarãja imariᵽotojo ĩ'rĩka uᵽaka oyiaja ᵽuᵽajoawa'ri jeyobaabu'airã maime. ");
INSERT INTO tnc_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","Ñakoa jaika imarikareka “Yire jeyobaabeyua sime ᵽitaka”, sãrĩberijããeka. I'suᵽakajaoka ruᵽuko'a jaika imarikareka “Yire jeyobaabeyua sime ũ'ᵽua”, sãrĩberijããeka. ");
INSERT INTO tnc_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","Ikuᵽaka sime: Maᵽo'iakaka ima “Dako waᵽamarĩa sime yiro'si”, mañurõ'õ simakoᵽeko'omakaja imatiyaika sime. ");
INSERT INTO tnc_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","Maᵽo'iareka ima “Jiyurimarĩa sime”, ãrĩᵽuᵽajoawa'ri jiibaji aᵽerãte sayoiokaro'si jia samairĩrĩrijayu. I'suᵽakajaoka aᵽea maᵽo'iareka ima ritaja ᵽo'imajare ĩakoreka jariroaka jããtirã oyiaja maime. ");
INSERT INTO tnc_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","I'suᵽaka simako'omakaja ĩ'rãrikõ'rĩmato ima maᵽo'iareka sĩarĩrĩrimarĩaja jariroaka rã'rĩta'aᵽatabeyurõ'õ. Kiyaᵽaeka uᵽakaja maᵽo'ia Tuᵽarãte mare ᵽo'ijiaeka. I'suᵽaka kibaaeka simamaka maᵽo'iareka ima “Imatiyabeyua sime yiro'si”, mañua simakoᵽeko'omakaja jiibaji mairĩñurõ'õ sime. ");
INSERT INTO tnc_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","Maᵽo'iareka ritaja mareka simako'omakaja ĩ'rãtiji oyiaja sajeyobaabu'ayu. I'suᵽakajaoka maime maro'si. Rĩkimarãja maima simako'omakaja ĩ'rĩka uᵽakaja ᵽuᵽairã imarĩ, majeyobaabu'arijayu. ");
INSERT INTO tnc_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","Ĩ'rãkõ'rĩmato maᵽo'ia mare yi'arãka ᵽoto mare yi'abeyurõ'õ ᵽariji sayi'aᵽatayu. Suᵽabatirã ĩ'rãkõ'rĩmato maᵽo'ia jiyurika ᵽo'imajare ĩaikaᵽi ritaja jĩjimaka maime. I'suᵽakajaoka maime Jesúre ã'mitiriᵽẽairã maro'si. Maka imakite ba'iaja ᵽuᵽarirãka, maimauᵽatiji kika ba'iaja maᵽuᵽariᵽatarãñu. Suᵽabatirãoka maka imakite jĩjimaka imarãka, maimauᵽatiji kika jĩjimaka maimaᵽatarãñu. ");
INSERT INTO tnc_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","Ikuᵽaka simatiyayu: Jesúrika ba'irabebaraka jeyobaabu'arijayurã imarĩ, ĩ'rĩka ta'iarãja Jesús ᵽo'iuᵽakaja imarã maime. I'suᵽaka simamaka ĩ'rĩka uᵽakaja imatiyairã oyiaja maimarijayu. Maka imaki ĩ'rĩkate maro'si õ'totoirãka maimauᵽatiji Jesúrika ba'irabeirãro'si jiamarĩa simarãñu. ");
INSERT INTO tnc_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","I'suᵽaka Jesús ᵽo'iuᵽaka ĩ'rĩka ta'iarãja maimamaka, ĩ'rĩka jariwa'ririmarĩa kirika ba'iraberika Tuᵽarãte mare ja'atayu majeyobaabu'aokaro'si. Mamarĩtaka ĩ'rãrimarãre Tuᵽarãte wã'maeka aᵽóstolrãka nimaokaro'si. I'suᵽaka kibaaeka narokabajirã ĩ'rãrimarãre naᵽuᵽarõ'õᵽi nare kẽñua kiro'si bojaĩjirimaja nare kimarũjeyu. Narokajĩte aᵽerã kirika bojariroka wãrõrimaja, suᵽabatirãoka aᵽerã Tuᵽarã ĩ'rĩkaja kibaawãrũika maikoribeyua bearũkirãro'si nare kimarũjeyu. I'suᵽakajaoka aᵽerimarã jĩñurãte tããrimaja nare kimarũjeyu. Aᵽerã imarã aᵽerãte jeyobaarũkirã, suᵽabatirã Tuᵽarãte yi'yurã jia natiyiaja ba'iraberuᵽutarimaja nimaerã aᵽerimarãre kijeyobaarijayu. I'suᵽakajaoka aᵽetomaja oka na'mitiribeyua imakoᵽeikaja najaiwãrũerã kijeyobaayu. ");
INSERT INTO tnc_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","Ĩ'rãba'ikaka takaja kiro'si maba'iraberãmarĩa Tuᵽarãte ritaja ima mare ja'atayu. Ã'mitirikõrĩ je'e: Ĩ'rĩka ta'iarãja Jesucristorika bojataᵽarimaja oyiaja marĩrã maime. I'suᵽakajaoka ĩ'rĩka ta'iarãja Tuᵽarãte mare õrĩrũjeika kiro'si bojaĩjirimaja oyiaja marĩrã maime. Suᵽabatirã ĩ'rĩka ta'iarãja kirika bojariroka wãrõrimaja oyiajamarĩa maime. I'suᵽakajaoka ĩ'rĩka ta'iarãja Tuᵽarã uᵽaka maikoribeyua baabearũkirãmarĩrã maime. ");
INSERT INTO tnc_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","Ĩ'rĩka ta'iarãja jĩrĩrimajare tããrimaja oyiaja marĩrã, suᵽabatirã ĩ'rĩka ta'iarãja majaiwãrũbeyua oka imakoᵽeika jaiwãrũrimaja oyiaja marĩrã maime. Najaika ã'mitiritirã, “Ikuᵽaka ãrĩrika nañu”, ãrĩwãrũrimaja oyiaja marĩrã maime. ");
INSERT INTO tnc_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","“Jia jeyobaabu'aokaro'si Esᵽíritu Santore mare jeyobaaikaᵽi imatiyaika yibaariyaᵽayu”, ãrĩwa'ri Tuᵽarãte mija jẽñebe. I'suᵽaka mija baarãkareka jia simarãñu. I'suᵽaka mija ãrĩrũkia simako'omakaja tẽrĩwa'ribaji imaroka mijare yiwãrõerã baayu mae. ");
INSERT INTO tnc_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","Ritaja aᵽetomaja oka jairã imariᵽotojo, suᵽabatirã ángelrãkare jaika ᵽariji jaiwãrũirã imariᵽotojo, aᵽerãte wayuĩabeyurã maimajĩka, “Dakoa waᵽamarĩaja najaiyu”, ᵽo'imajare mareka ãrĩjĩñu. ");
INSERT INTO tnc_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","Tuᵽarãro'si bojaĩjirimaja maimaokaro'si ritaja mare kiõrĩrũjerikareka, aᵽerãte mawayuĩaberijĩka, dakoaᵽi ãrĩwa'ri imatiyairã maimaberijããeka. I'suᵽaka imarã imarĩ karerõ'õᵽi ritaja imarũkiakaka mare kibojarikareka, suᵽabatirã ritaja Tuᵽarãte mare ja'ataika morĩrikarekaoka, dako waᵽamarĩa simajããeka. Suᵽabatirãoka jia Tuᵽarãte yi'riwa'ri “Ika ᵽusia miwiarĩkabe Tuᵽarã”, maᵽakã'ã kire mañu uᵽakaja kiyi'rijĩka simako'omakaja aᵽerãte mawayuĩaberijĩka, dakowaᵽamarĩa simajĩñu. ");
INSERT INTO tnc_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","Wayuoka baairãte jeyobaawa'ri marikaika ritaja ĩjiriᵽotojo, aᵽerãte mawayuĩaberijĩka, dakoa sawaᵽa Tuᵽarã ᵽõ'irã matõᵽoberijĩñu. Tuᵽarãrika bojariroka wãrõrika maja'atabeᵽakã'ã “Tuᵽarã majamarãre yire joeriataᵽarũ”, marĩjĩka simako'omakaja aᵽerãte mawayuĩaberijĩka, dakoa sawaᵽa jia matõᵽoberijĩñu. ");
INSERT INTO tnc_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","Mija ĩabe. Ikuᵽaka sime wayuĩabu'arikakaka: Ᵽo'imajare ba'iaja mare baako'omakaja, sarakajeᵽããekaja maimaye'e. Sarakajeᵽããirã imarĩ, nare boebaririka imabeyua. Suᵽabatirã “Aᵽerã yijare jiibaji imarã”, ãrĩwa'ri nare ã'mijĩabekaja maimaye'e, ritaja imarã rokarã maimaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","Ᵽo'imajare i'yoᵽi'rikoreka niaika wãjitãji ba'iaja nare mabaabeabesarãñu. Suᵽabatirã maro'si wãjitãji takaja jia ᵽuᵽajoabekaja jia ᵽo'imajare imarikakaka ᵽuᵽajoarika sime. I'suᵽakajaoka ba'ijĩkaja mare naᵽakã'ã nare boebaririmarĩa sime. Aᵽea i'suᵽakajaoka aᵽikate mare ba'iaja baako'omakaja ñoaka saᵽi boebaka imaᵽañarimarĩa sime. ");
INSERT INTO tnc_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","Ᵽo'imajare ba'iaja baaika ĩatirã, “Ba'iaja baairã nime”, ãᵽaraka jĩjimaka imarimarĩa sime. I'suᵽaka imabekaja Tuᵽarãte yaᵽaika uᵽakaja baairã imarãte ĩatirã jĩjimaka maimarãñu. ");
INSERT INTO tnc_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","Wayuĩariᵽuᵽakirã imarĩ, aᵽerãte ba'iaja mare baako'omakaja nareka majaibeyu. Jia nare ᵽuᵽajoawa'ri “Õrĩᵽũarũkirã nimamirĩrĩkawa'rirãñu je'e ruᵽu”, marĩᵽuᵽajoayu. Ba'iaja rakajeᵽããbaraka aᵽerãte wayuĩarija'atarika imabeyua. ");
INSERT INTO tnc_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","Wãtaka ᵽo'imajare õrĩrika ja'atarũkimarĩa sime. Tuᵽarãte mare ãñua kiro'si mabojaĩjika ᵽuri tiyirãka. I'suᵽakajaoka simarãñu ᵽo'imaja oka majaibeyua Tuᵽarãte mare jairũjeika, suᵽabatirã morĩrã Tuᵽarãte mare ja'ataeka. ");
INSERT INTO tnc_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","Ikuᵽaka sime: Maekaka õrĩᵽũarika Tuᵽarãte mare ja'ataika simako'omakaja ritaja õrĩᵽatabeyurã maime. I'suᵽakajaoka mare kiõrĩrũjeika kiro'si mabojaĩjirũkia morĩᵽatabeyuaoka. ");
INSERT INTO tnc_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","I'suᵽaka maima simako'omakaja kiᵽõ'irã maeyarãka ᵽoto ᵽuri jia õrĩwãrũtiyairã Tuᵽarãte mare jarirũjerãñu. Suᵽa imarĩ i'sirĩmi seyarãka ᵽoto maekaka morĩkoᵽeika waᵽamarĩa jarirãka. ");
INSERT INTO tnc_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","Mija ĩabe: Me'rĩ ñimaeka ᵽoto, ritaja jia yijaiwãrũberika ruᵽu. Suᵽabatirã, yiᵽuᵽaka, suᵽabatirã õrĩwaᵽu'atarikakakaoka, i'suᵽakaja simaeka ruᵽu yiro'si. Ᵽakiariwa'ri yime'rãrĩ ñimaeka uᵽakamarĩa ñimarijayu mae. ");
INSERT INTO tnc_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","I'suᵽakajaoka maekaka maro'si simañuju ruᵽu, ritaja Tuᵽarãrika morĩwãrũbeyua simamaka. Ũᵽeria majakaᵽi maᵽema mayaakoᵽeika uᵽakaja maime Tuᵽarãrikakaka jia morĩbesarãka. I'suᵽaka simako'omakaja ñamajĩ Tuᵽarã ᵽõ'irã eyatirã, kire mairãñu. I'sia ᵽoto mare kiõrĩᵽataika uᵽakajaoka kire morĩwãrũᵽatarãñu maro'sioka. ");
INSERT INTO tnc_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","I'suᵽaka simamaka maekarakaba'ikaka ima maekaka mabaarijarirũkia. Ĩakõrĩ je'e: Jia Tuᵽarãte ã'mitiriᵽẽarijaᵽaraka maimarijariye'e. Suᵽabatirã “Kiᵽõ'irã maeyarãka ᵽoto mare kẽñu uᵽakaja jia mare kibaarãñu”, ãrĩᵽuᵽajoabaraka imarijarirũkia sime. I'suᵽakajaoka ᵽo'imajare jia wayuĩabaraka maimarijariye'e. Maekarakaba'ikaka mabaarijarirũkia imako'omakaja wayuĩabu'arikakaka sime tẽrĩwa'ribaji imatiyaika. ");
INSERT INTO tnc_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","Suᵽa imarĩ ᵽo'imajare jia mawayuĩarijariye'e. I'suᵽakajaoka “Ᵽo'imajare miro'si yija bojaĩjiwãrũerã yijare miõrĩrũjeika yijare mija'atabe”, ãᵽaraka Tuᵽarãte mija jẽñebe. ");
INSERT INTO tnc_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","Ikuᵽaka sime: Rẽrĩtirã nimarõ'õrã oka kiõrĩbeyuaᵽi jaikite ᵽo'imajare ã'mitiriwãrũbeyua. Kiᵽuᵽaka simamaka Tuᵽarã ĩ'rĩkateje saᵽi kijaiyu. ");
INSERT INTO tnc_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","Aᵽika ᵽuri Tuᵽarãte kire bojarũjeika ᵽo'imajare bojaiki. Kire ã'mitiritirã, jiibaji Tuᵽarãte nayi'rirãñu. I'suᵽakajaoka jia okajãjia imatirã Tuᵽarãte yaᵽaika uᵽaka nabaaokaro'si, suᵽabatirã jiiᵽuᵽarã nimaerã i'suᵽaka kibojayu. ");
INSERT INTO tnc_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","Oka kiõrĩbeyuaᵽi Tuᵽarãte jaiki, i'suᵽaka kibaaika kiro'si takaja jia sime. Tuᵽarãrika na'mitiyuaᵽi aᵽerãte bojaikite ᵽuri sã'mitiritirã jia ᵽo'imajare sõrĩwaᵽu'atarijayu. I'suᵽaka kibaaika simamaka jia Jesúre yi'yurãte kiwãrõrijayu. ");
INSERT INTO tnc_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","Ĩ'rĩka jariwa'ririmarĩa aᵽetatarã oka mija õrĩbeyua imakoᵽeika mija jaiwãrũrikareka, jia simajããeka yiro'si. I'suᵽaka jia simako'omakaja aᵽerã oka kiõrĩbeyua kijaika tẽrĩwa'ribaji imatiyaika sime Tuᵽarãro'si bojaĩjirika. Aᵽerã oka kijaika ᵽo'imajare ã'mitiriwãrũbeyua ĩ'rĩka bojarikatarimajite imajĩka ᵽuri jia sime. ");
INSERT INTO tnc_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","Mija ã'mitiᵽe yijeyomarã. Mija ᵽõ'irã eyatirã mija ã'mitiribeyua yijaijĩka, dako waᵽamarĩa mijaro'si simajĩñu. Tuᵽarãte yire õrĩrũjeika mijare yibojajĩka ᵽuri jia mijaro'si simajĩñu. I'suᵽakajaoka sime Tuᵽarãrika mija ã'mitiyurokaᵽi yiwãrõika. ");
INSERT INTO tnc_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","Ã'mitirikõrĩ je'e. Ĩ'rĩkate ma'saka jia ᵽuᵽuwãrũbeyua ã'mitiritirã, “I'siroka kiᵽuᵽuyu”, ãrĩwãrũbeyurã maime. I'suᵽakajaoka arᵽa wameikaᵽi bayaoka jia kibirewãrũbeᵽakã'ã, “I'siakaka kibireyu”, marĩwãrũberijĩñu. ");
INSERT INTO tnc_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","Aᵽea ima. Surararãkare akarimajire tromᵽeta wãmeika jia kiᵽuᵽuwãrũberijĩka, namajamarãka jĩrĩrã imatikaja nimawãrũberijĩñu. ");
INSERT INTO tnc_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","I'suᵽaka sime, aᵽetatarã oka mija õrĩbeyua mija jaikoᵽeika ã'mitiriwãrũberiwa'ri, “I'suᵽaka ãrĩrika nañu”, aᵽerãte ãrĩwãrũberijĩñu. I'suᵽaka simamaka, waᵽuju ko'torõ'õrãja jairã uᵽakaja mija baajĩñu. ");
INSERT INTO tnc_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","Rita sime, ika ritatojo wejeareka ritajatata ᵽo'imaja rakakaja noka najaiyu. I'suᵽaka simako'omakaja ĩ'rãtataja imarã imarĩ najaika ã'mitiribu'awãrũirã. ");
INSERT INTO tnc_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","I'suᵽaka simako'omakaja majeyomarãkaki ña'mitiribeyuaᵽi yika kijaijĩka ĩ'rãtiji yija ã'mitiribu'abeᵽakã'ã, “Aᵽetomaji uᵽaka kime”, ñarĩrãñu. I'suᵽakajaoka yireka kiᵽuᵽajoarãñu kiro'sioka. ");
INSERT INTO tnc_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","I'suᵽaka mijaro'si simakoreka, Esᵽíritu Santore ja'atarijayua yaᵽairã imarĩ, “Jesúre yi'yurãte yija jeyobaarũkia yijare mija'atarika yija yaᵽayu”, kire mija ãrĩrijaᵽe. ");
INSERT INTO tnc_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","I'suᵽaka simamaka aᵽerãte jeyobaarika ᵽuᵽajoairã imarĩ, “Esᵽíritu Santo yire jeyobaaikaᵽi aᵽerã oka ñorĩbeyua yijaiko'omakaja aᵽerãte jia sayibojarikataokaro'si mirikakaka yire mija'atabe”, ãᵽaraka Tuᵽarãte mija jẽñerijaᵽe. ");
INSERT INTO tnc_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","Ikuᵽaka sime: Tuᵽarãte jiyiᵽuᵽayeebaraka aᵽerã oka ñorĩbeyua yiᵽuᵽakarã yire ña'rĩjãikaᵽi uᵽakaja kire jairiᵽotojo, “I'suᵽaka yijaiyu”, ñarĩwãrũbeyu. ");
INSERT INTO tnc_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","I'suᵽaka simamaka ikuᵽaka mabaaye'e: Aᵽerikuri aᵽerã oka morĩbeyua maᵽuᵽakarã mare ña'rĩjãikaᵽi uᵽakaja Tuᵽarãte majairijariye'e, i'suᵽakajaoka mabayakoyaye'e. Aᵽerikuri ᵽuri morĩwaᵽu'ataikaᵽi kika majairijariye'e, i'suᵽakajaoka kiro'si mabayakoyarijarirãñu. ");
INSERT INTO tnc_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","Ika mijare yibojaika uᵽakaja mija baabe. I'suᵽaka mija baaberijĩkareka, sã'mitiriberiwa'ri “Jia mibaayu Tuᵽarã”, mijare ã'mitiririmajare ãrĩwãrũberijĩñu. ");
INSERT INTO tnc_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","Kire jiyiᵽuᵽayeebaraka, “Jia mibaayu Tuᵽarã”, jia mañua simako'omakaja, majaika ã'mitiriberiwa'ri jiibaji kire nayi'riwãrũbeyu. ");
INSERT INTO tnc_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","Mijare tẽrĩwa'ribaji ñorĩbeyua oka imakoᵽeika jaiwãrũiki ñime. I'suᵽaka imaki imarĩ, “Jia mibaayu Tuᵽarã”, saᵽi kire ñañu. ");
INSERT INTO tnc_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","I'suᵽaka simako'omakaja Jesúre yi'yurãka rẽrĩtirã diez mil rakaroka na'mitiribeyuaᵽi nare yijaijĩka dakowaᵽamarĩaja simajĩñu. Na'mitiriwãrũikaᵽi ᵽuri ĩ'rãᵽitarakarokatakaja nare yibojako'omakaja sanõrĩwãrũjĩka jiibaji sime yiro'si. ");
INSERT INTO tnc_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","Me'rãka jia õrĩᵽũabeyukajirã uᵽaka mija ᵽuᵽajoa'si yijeyomarã. I'suᵽaka simako'omakaja me'rãrĩjaka ba'iaja baakoribeyurã uᵽaka Tuᵽarãte yaᵽaika ᵽuᵽajoabaraka ᵽakiayurã uᵽaka jia mija imabe. ");
INSERT INTO tnc_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","Mija ĩabe, ikuᵽaka Tuᵽarã majaroᵽũñurã sabojayu: “Judíotatarã ᵽõ'irã aᵽetomajare yiᵽũatarãñu aᵽea okaᵽi nare najaiokaro'si yire ã'mitiribeyurã nimamaka. I'suᵽaka nare yibaako'omakaja, yire nayi'ribesarãñu ruᵽu”, ãrĩwa'ri sabojayu Tuᵽarã oka ᵽũñurã. ");
INSERT INTO tnc_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","Suᵽa imarĩ i'suᵽaka Tuᵽarãte mare jairũjeka “Wẽkomaka yijare baarãki Tuᵽarã”, kire ã'mitiririᵽe'yoirãte ãrĩwãrũokaro'si. Maro'si ᵽuri kirika Tuᵽarãte mare õrĩrũjeika mabojamaka “Maka kime”, marĩwãrũyu. ");
INSERT INTO tnc_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","Ikuᵽaka sime: Mija rẽñurõ'õrã aᵽerã oka mija õrĩbeyua ĩ'rĩka uᵽakaja jaibaraka mija imajĩka ᵽoto, Jesúre yi'ribeyurãte mija ᵽõ'irã eyajĩñu. I'suᵽaka mija jairijayu ᵽoto ĩakoribeyurã imarĩ, “Wejabisimajataka ĩ'rãre ime”, mijareka narĩrãñu. ");
INSERT INTO tnc_vpl VALUES ("C114_24","076_14_24","1CO","14","24","25","I'suᵽaka baabekaja Tuᵽarãro'si bojaĩjibaraka mija imarõ'õrã ĩ'rĩka Jesúre yi'ribeyuka kãkatirã, Tuᵽarãte mijare õrĩrũjeikarõ'õjĩrãja mija bojarãka jia sakiõrĩwãrũᵽatarãñu. Suᵽa imarĩ, “Ba'iaja baatiyaiki ñime. Ya'erõ'õrã yiᵽuᵽajoakoᵽeika Tuᵽarãte õñua”, kẽrĩrãñu. Suᵽabatirã Tuᵽarãte jiyiᵽuᵽayeewa'ri ñukuruᵽatirã, “¡Mijaka Tuᵽarãte ime mirãkiyu!”, kẽrĩrãñu. ");
INSERT INTO tnc_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","Mija ã'mitiᵽe yijeyomarã. Ikuᵽaka mija baarijaᵽe mija rẽrĩrijarirãka ᵽoto: Ĩ'rãrimarã imarã bayakoyariyaᵽairã. Aᵽerã imarã wãrõrika yaᵽairã. Suᵽabatirã Tuᵽarãte nare õrĩrũjeika bojariyaᵽairã nime aᵽerã. Aᵽerimarã imarã norĩbeyua simako'omakaja aᵽea okaᵽi jairika yaᵽairã. Suᵽabatirãoka imarã sabojarikatariyaᵽairã. Ritaja mija baarijayuaᵽi Jesúre yi'yurãte jiibaji kire nayi'yaokaro'si nare mija jeyobaarijarijĩka jia sime. ");
INSERT INTO tnc_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","Aᵽerã oka mija õrĩbeyua mija jairiyaᵽaye'e, ĩ'ᵽarã, maekarakamaki rõ'õjĩrãja samija jaibe. Ĩ'rĩka mamarĩ, aᵽika kirokajĩrã mija jairijaᵽe. Ma'mitiribeyurokaᵽi jaikite jairãka be'erõ'õ aᵽika sabojarikatarãñuka, aᵽerãte sã'mitiyaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","Bojarikatarimajire imabesarãkareka, mija rẽñurõ'õrã aᵽerokaᵽi jaibekaja mija imabe. Ĩ'rãrimarãja aᵽerõ'õrã Tuᵽarãka i'suᵽaka mija jairijaᵽe. ");
INSERT INTO tnc_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","I'suᵽakajaoka, Tuᵽarãte mijare õrĩrũjeika mija bojariyaᵽarãka, ĩ'ᵽarã, maekarakamaki rõ'õjĩrã mija jaibe. Ĩ'rĩkaja mamarĩ aᵽika kirokajĩrã mija jairijaᵽe. I'suᵽaka mija jaimaka aᵽerã Jesúre yi'yurã jia sã'mitirirãñurã, “Rita, Esᵽíritu Santore kire õrĩrũjeikaᵽi kijaiyu”, narĩwãrũrãñu. ");
INSERT INTO tnc_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","Ĩ'rĩkate jaika ᵽoto aᵽika sã'mitiriruᵽakite kijairũkia Tuᵽarãte kire õrĩrũjejĩkareka, mamarĩji jaiũ'muikite okata'rijĩñu aᵽikate jaiũ'muokaro'si jia sime. ");
INSERT INTO tnc_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","Ĩ'rĩkaja mamarĩ kirokajĩrã aᵽika Tuᵽarãro'si bojaĩjirimajare jaimaka ĩ'rĩka jariwa'ririmarĩaja mija jaiwãrũrijarirãñu. I'suᵽaka mija baarãka, jiibaji Tuᵽarãrika õrĩwa'ri okajãjia ᵽuᵽaᵽaraka jia mija imarãñu. ");
INSERT INTO tnc_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","Tuᵽarãro'si bojaĩjirimaji ᵽuri, sakibojarũkirõ'õjite ta'awãrũiki kiᵽuᵽayariji. Aᵽerãte jairãka ᵽoto okamarĩaja kime ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","Rukubaka baarika yaᵽabeyuka kime Tuᵽarã. Suᵽa imarĩ ritaja jiyiᵽuᵽaka õrĩbu'abaraka mija rẽrĩrijarirãka jia simarãñu. I'suᵽaka oyiaja aᵽerã Jesúre yi'yurãte baarijayua sime narẽrĩrijayurõ'õ rakakaja. ");
INSERT INTO tnc_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","Rẽrĩtirã mija imarãka ᵽoto, jairĩ wiriwa'ribekaja ĩmirĩjate jaikatakaja ã'mitirirũkirã nime rõmijã. Kotĩmite ã'mitirirũkiko koime, i'suᵽakaja Moiséte o'oeka simamaka. ");
INSERT INTO tnc_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","Kojẽrĩariyaᵽajĩka, nawi'iarã ᵽe'rieyatirã kotĩmite sakojẽrĩarũ. Mia, narẽrĩriwi'iarã ĩ'rãko rõmore jairãka, “¿Dako baaerã i'yoᵽiᵽekaja kojaiyu?”, aᵽerãte ãrĩᵽuᵽajoarãñu. ");
INSERT INTO tnc_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","¿Marãkã'ã mija ᵽuᵽajoayu je'e? Mamarĩ Tuᵽarãrika bojaũ'muekamarĩrã mija ime. I'suᵽakajaoka mija tarãja kirika bojariroka yi'rikamarĩrã mija ime. I'suᵽaka simako'omakaja ¿aᵽerã Jesúre yi'yurãte baarijayu uᵽaka baarũkimarĩrã mija ime bai je'e? Jẽno'o i'suᵽakamarĩa sime. ");
INSERT INTO tnc_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","“Tuᵽarãte yijare kiõrĩrũjeika bojaĩjirimaja yija ime”, ãñurã imarã je'e torã. I'suᵽakajaoka “Kirikaᵽi ba'irabeokaro'si Esᵽíritu Santore yijare ja'atayu”, aᵽerã ãñurã mijakarã. “I'suᵽaka kijeyobaairã yija ime”, ãñurã nimaye'e, “Maiᵽamakire jã'meika uᵽakaja Ᵽablote maro'si o'oyu”, naro'sioka narĩrũ. ");
INSERT INTO tnc_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","“Maiᵽamakire jã'meka uᵽakamarĩa Ᵽablote bojayu”, ãñukate, “Kiᵽuᵽajoaika uᵽakaja kijaiyu”, Tuᵽarãte kireka ãrĩrãñu. ");
INSERT INTO tnc_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","Mija ã'mitiᵽe yijeyomarã. Ikuᵽaka simatiyayu maimarũkia: “Tuᵽarãte yire ãñua bojawãrũiki ñimaerã yire kijeyobaarika yiyaᵽayu”, ãᵽaraka kire mija jẽñebe. I'suᵽaka simako'omakaja, aᵽerã oka na'mitiribeyua jairãte jãjibaarũkimarĩa sime. ");
INSERT INTO tnc_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","Mija rẽrĩrijayu rakakaja, jia oyiaja mija imabe rukubaka baabekaja. ");
INSERT INTO tnc_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","Yijeyomarã, Jesúrikakaka mijare yiwãrõraᵽaka jia mija õrĩrika yiyaᵽayu. Ika majaroka bikija mija yi'riũ'mutika sime. Sayi'rikarã imarĩ, jia Jesúre yi'ririjayurã mija imarijayu. ");
INSERT INTO tnc_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","Mijare yiwãrõraᵽaka ã'mitiriᵽẽawa'ri Cristore mija yi'ririja'atabesarãkareka ba'iaja mija jũarũkia imakoᵽeikareka Tuᵽarãte mijare wayuĩarãñu. I'suᵽaka mija baabesarãkareka, dakowaᵽamarĩa kire mija yi'rikoᵽeika jarirãka. ");
INSERT INTO tnc_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","Imatiyairoka mijare yiwãrõraᵽe Cristore mamarĩ yire sawãrõraᵽaka uᵽakaja. Ikuᵽaka sime ĩakõrĩ je'e: Ba'iaja mabaaika waᵽa Cristore reyaekakaka mijare yibojaraᵽe. I'suᵽaka Tuᵽarã majaroᵽũñurã bojatika uᵽakaja sajarika. ");
INSERT INTO tnc_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","“Ãta wi'iarã kire natako'omakaja, maekarakarĩmi be'erõ'õ Tuᵽarãte õñia kire jarirũjeka ate”, ãrĩwa'ri bikija sabojatika Tuᵽarãrika o'oeka ᵽũñurã. ");
INSERT INTO tnc_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","I'suᵽaka simamaka õñia kijarika be'erõ'õ Ᵽedrote kire ĩaeka. I'sia be'erõ'õ ĩ'ᵽoũ'ᵽuarãe'earirakamaki kika wãrũeka mirãrã ᵽõ'irã kiᵽemakotowirika mae. ");
INSERT INTO tnc_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","I'sia be'erõ'õ 500 rakamaki bo'ibajirã kire yi'yurã imaekarã ᵽõ'irã keyaeka. I'suᵽaka kibaaeka ĩaeka mirãrã, rĩkimarãja õñia imarã ruᵽu. Ĩ'rãrimarã ᵽuri reyatikarã. ");
INSERT INTO tnc_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","I'suᵽaka simaeka be'erõ'õ Santiago ᵽõ'irãoka keyaeka. Sabe'erõ'õ nimauᵽatiji kirika bojariroka nabojataᵽaerã kijã'mekarã ᵽõ'irãoka keyaeka. ");
INSERT INTO tnc_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","Nabe'erõ'õᵽi yireoka kiᵽemakotowiraᵽe. Aᵽerã aᵽóstolrãkare kiwã'maeka uᵽakamarĩa aᵽóstol yire kimarũjeraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","“Yire tẽrĩwa'ribaji imatiyairã aᵽerã aᵽóstolrãkare ime”, ñarĩᵽuᵽajoayu. Mia, Jesúre yi'yurãte ba'iaja baaiki ñimaeka ruᵽu. I'suᵽaka ñimako'omakaja aᵽóstol ñimaokaro'si Tuᵽarãte yire wã'maeka. ");
INSERT INTO tnc_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","Yire wayuĩawa'ri, kirika ba'iraberimaji ñimaokaro'si Tuᵽarãte yire jã'meka. Jiitaka yire kibaaeka simamaka kirika jia yiba'irabeyu. Saᵽi ãrĩwa'ri “Yirika bojataᵽarimaji kimarũ ãrĩwa'ri kire yiᵽũatakoᵽeka”, yireka ãrĩbeyuka Tuᵽarã. Aᵽerã aᵽóstolrãka imarãte ᵽemawa'ribaji Tuᵽarãrika ba'irabeiki ñimaeka jia Tuᵽarãte yire jeyobaaeka takaᵽiji. ");
INSERT INTO tnc_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","Aᵽóstolrãkare Tuᵽarãrika mijare wãrõeka, suᵽabatirã mijare yiwãrõraᵽakaoka, marãkã'ã imabeyua ĩ'rãtiji ima simamaka. Sã'mitiritirã samija yi'raᵽe. ");
INSERT INTO tnc_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","Aᵽóstolrãka ĩ'rãtiji oyiaja bojairã yija ime. “Kireyaeka simako'omakaja õñia Cristore jarika ate”, ãrĩwa'ri yija bojarijayu. Mijare sayija bojako'omakaja ¿dako baaerã “Õñia jariᵽe'rirũkimarĩrã maime mareyarãka be'erõ'õ”, ĩ'rãrimarã tokarãre ãñu je'e? ");
INSERT INTO tnc_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","Ĩakõrĩ je'e: Reyariᵽotojo õñia jariᵽe'rirũkimarĩrã maimaberirikareka karemarĩa Cristore õñia jariᵽe'riberijããeka. ");
INSERT INTO tnc_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","I'suᵽaka simaberirikareka kirika bojariroka yija wãrõika jiamarĩa imajããeka. Suᵽabatirãoka dakoa waᵽamarĩaja Cristore mija yi'rijããeka. ");
INSERT INTO tnc_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","Reyariᵽotojo õñia jariᵽe'ririka imaberirikareka Tuᵽarãreka mijare ᵽakirimaja yija imajããeka, “Õñia Cristore kijariᵽe'rirũjeka”, ãᵽaraka. ");
INSERT INTO tnc_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","I'suᵽakajaoka reyarijayurãte õñia jariᵽe'ririka imaberirikareka, Cristooka õñia jariᵽe'riberijããekaki. ");
INSERT INTO tnc_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","I'suᵽaka Jesúro'si simaberirikareka waᵽuju kire mija yi'rijããeka. I'suᵽakamarĩa simarikareka ba'iaja mabaaikareka Tuᵽarãte mare wayuĩaberijããeka. ");
INSERT INTO tnc_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","I'suᵽakajaoka õñia Cristore jariberirikareka, kire yi'rikarã mirãrã reyaekarã ba'iaja imarika tiyibeyurõ'õrã na'rika. ");
INSERT INTO tnc_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","I'suᵽaka simarikareka, ᵽakirika yi'rikoᵽewa'ri, “Jesucristo uᵽaka, Tuᵽarãte õñia mare jariᵽe'rirũjerãñu”, ãrĩwa'ri õñia maimatiyikuriji jia kire yi'ririkareka jiamarĩtaka simajããeka. Ba'iaja jũariᵽotojo kire yi'rija'atabeyurã imarĩ, waᵽuju kire yi'rikoᵽeirã maimarikareka, ritaja ᵽo'imaja ᵽemawa'ribaji mare nawayuĩãjããeka. ");
INSERT INTO tnc_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","I'suᵽakamarĩa sime. Cristore reyaeka simako'omakaja Tuᵽarãte õñia kire jarirũjeka. Suᵽa imarĩ iki imaki mamarĩ õñia jariᵽe'riũ'muekaki. I'suᵽakajaoka kire yi'yurã uᵽatiji i'suᵽaka oyiaja jarirãñurã. ");
INSERT INTO tnc_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","Mamarĩ imaũ'muekakire ba'iaja baaekaᵽi ãrĩwa'ri reyarika imaũ'mueka ᵽo'imajaro'si. I'suᵽaka simako'omakaja Jesúre maro'si reyaĩjiekaᵽi ãrĩwa'ri õñia jariᵽe'rirũkia maro'si ᵽo'ijirika. ");
INSERT INTO tnc_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","Adán imaekaki riᵽarãmerã imarĩ, reyarũkirãro'si oyiaja maime. I'suᵽaka simako'omakaja Cristore yi'riwa'ri kirirã majarika simamaka Tuᵽarãte mare õñia jarirũjerãñu. ");
INSERT INTO tnc_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","Suᵽa imarĩ sõrĩtikaja maimarijayu. Cristo imaki reyariᵽotojo wããrõ'õrãja mamarĩ õñia jariᵽe'riũ'muekaki. Ñamajĩ ketarãka ᵽoto kire yi'rika mirãrãte i'suᵽakajaoka naro'si simarãñu. ");
INSERT INTO tnc_vpl VALUES ("C115_24","076_15_24","1CO","15","24","25","Ritaja Tuᵽarãte ĩariᵽe'yomijiᵽi jã'meirãte kitẽrĩrãka be'erõ'õ wejetiyia seyarãñu. I'suᵽaka nare baatirã “Koᵽakaja yimajãmarãre yitẽrĩtiyu. Mae miyaᵽaika uᵽakaja ritaja mijã'mebe”, Kiᵽaki Tuᵽarãte kẽrĩrãñu. I'suᵽaka Cristore baarãñu “Nare mitẽrĩtiyarãñurĩmi rõ'õjĩrãja ritajare jã'merimaji mire ñimarũjerãñu”, Tuᵽarãte kire ãᵽakã'ã. ");
INSERT INTO tnc_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","I'suᵽaka simarãka ᵽoto ᵽo'imajare reyaika ᵽariji Cristore tiyetarãñu. Saᵽi ãrĩwa'ri ritaja majamarãika maimaoka tiyiᵽatarãka. ");
INSERT INTO tnc_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","Mia je'e, ikuᵽaka sabojayu Tuᵽarãrika o'oeka ᵽũñurã: “Ritaja ĩᵽamaki imarũkikaro'si Tuᵽarãte kire ᵽũataeka”, ãrĩwa'ri sabojayu. I'suᵽaka simako'omakaja Tuᵽarãte ᵽuri jã'mebeyuka kime Cristo, “Ritajate yiro'si mijã'mebe”, kire kẽrĩka simamaka. ");
INSERT INTO tnc_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","Suᵽa imarĩ ritaja kimajamarãre Cristore tẽrĩrãka be'erõ'õᵽi nimauᵽatireje jã'merimaji kijarirãñu. Suᵽabatirã “Mae ñiᵽamaki mime”, Tuᵽarãte kẽrĩrãñu. I'suᵽaka kire kẽᵽakã'ã ritaja dika jariwa'ririmarĩa ĩᵽamaki Tuᵽarãte jarirãñu. ");
INSERT INTO tnc_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","“Reyariᵽototaka õñia jariᵽe'ririka imabeyua”, aᵽerãte ãrĩkoᵽeikakaka mijare yibojaerã baayu mae. I'suᵽaka ãrĩᵽuᵽajoariᵽotojo ¿dako baaerã aᵽerãteje reyaekarãro'si ruᵽuko'a najũjerũjeyu ĩ'rãrimarã je'e? Reyaekarã õñia jariᵽe'ririka imaberirikareka ᵽuri, waᵽuju dakowaᵽamarĩaja ruᵽuko'a naro'si najũjeĩjikoᵽejããeka. ");
INSERT INTO tnc_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","Yijaro'si ᵽuri, Tuᵽarãrika yija wãrõika ᵽoto werika sime, rĩkimarãja yijare jããrika ri'kairãte imamaka. ¿Marãkã'ã ãrĩwa'ri werika yijaro'si simako'omakaja sayija wãrõrija'atabeyu ruᵽu bai je'e? ");
INSERT INTO tnc_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","Rita mijare ñañu yijeyomarã. Ĩ'rãrĩmi jariwa'ririmarĩaja yire jããrika nari'kayu. I'suᵽaka yiro'si simako'omakaja mijare yiwãrõikaᵽi jia Jesucristore mija yi'yua simamaka jĩjimaka ñimarijayuaoka rita ima. ");
INSERT INTO tnc_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","Éfesowejearã yiwãrõraᵽaka ᵽoto, yaiwẽkoa boebaitaka ima uᵽaka imawa'ri yire jããrika ri'kakoᵽeraᵽarã yire yi'ririyaᵽaberaᵽarã. I'suᵽaka yire nabaamaka “Reyariᵽotojo õñia majariᵽe'rirũkia imabeyua”, ãñuka ñimarikareka dako baaerã ba'iaja jũariᵽotojo nare wãrõka'wisijũaberijããekaki yi'i. Reyariᵽotojo õñia majariᵽe'rirũkia imaberirikareka ᵽuri “Ñoaka õñia imarũkimarĩrã maime. Suᵽa imarĩ õñia maimatiyikuriji mayaᵽaika uᵽakaja ukubaraka, ba'abaraka maimaerã”, ãᵽaraka Jesúre yi'ribeyurãte baaika uᵽakaja baairã maimajããeka maro'si. ");
INSERT INTO tnc_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","I'suᵽaka simamaka waᵽuju bojaᵽakirimajare mija ã'mitiriᵽẽa'si. Ikuᵽaka sime: Ba'iaja baairãka mija jeyoarirãka, jia baarijayurã imariᵽotojo nuᵽaka ba'iaja baairã mija jarirãñu mijaro'sioka. ");
INSERT INTO tnc_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","Jia wãjirokaᵽi mija ᵽuᵽajoaᵽe'awa'ri ba'iaja baarika mija ja'atabe. Mija ᵽõ'irã ĩ'rãrimarã Tuᵽarãte õrĩbeyurã imarã je'e. Mija i'yoᵽi'yaokaro'si i'suᵽaka mijare ñañu. ");
INSERT INTO tnc_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","“Reyariᵽotojo õñia reyaekarãte jariᵽe'rirãñu”, ñañua simako'omakaja, ikuᵽaka ĩ'rãrimarãre jẽrĩajĩñu je'e: “¿Marãkã'ã simamaka reyaeka imariᵽotojo naᵽo'ia õñia jariᵽe'ritiyarãka ruku? I'suᵽakajaoka ¿marãkã'ã ĩoirã nimarãñu ruku koᵽakaja rabaekarã imariᵽotojo?”, nañu. ");
INSERT INTO tnc_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","I'suᵽaka yire jẽrĩairã jia ᵽuᵽajoabeyurã imarã. Ikuᵽaka sime ĩakõrĩ je'e: Õterikiyaᵽea moteika sajetakaja rabaika. I'suᵽaka simako'omakaja satõsirõ'õrã imaᵽi saᵽu'yu. Sajea rababerijĩkareka, marãkã'ã baatirã saᵽu'riberijĩñu. ");
INSERT INTO tnc_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","Ĩakõrĩ je'e: Trigo wãmeika õterikia, sayaᵽeaᵽi motemaka saᵽu'yu, samoteika uᵽakamarĩa. ");
INSERT INTO tnc_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","Samoterãka be'erõ'õ ᵽu'ritirã Tuᵽarãte yaᵽatika uᵽakaja sajayu. Suᵽa imarĩ õterikiba'i ima uᵽakaja saᵽu'ririjayu saro'si. ");
INSERT INTO tnc_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","Suᵽabatirã i'suᵽakajaoka sime ika. Ã'mitirikõrĩ je'e: Wa'ia, wa'iro'sia, wĩ'ñaka, ᵽo'imajaoka ĩ'rĩka ta'iarã oyiajamarĩa ᵽo'ikirã maime. ");
INSERT INTO tnc_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","I'suᵽakajaoka mabo'ikakurirã imarũkiaro'siji Tuᵽarãte torã ᵽo'ijiaeka. Suᵽabatirã õ'õrã imarũkirãteoka kibaaeka. Ĩ'rãtijitakamarĩaja imariᵽotojo ĩ'ᵽaba'iwã'taja jiyurika sime. ");
INSERT INTO tnc_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","Aiyate yaaika uᵽakamarĩa kiyaaboayu ñamikaki aiya. I'suᵽakajaoka sime tã'ᵽia saro'si. Tã'ᵽirãka natiyiaja rakaka oyiaja ya'tairã nime. ");
INSERT INTO tnc_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","I'suᵽakajaoka maimarãñu maro'si. Reyaekakite mayayerãka be'erõ'õ kiᵽo'ia rabarãka. I'suᵽaka simako'omakaja Tuᵽarãte õñia kire jarirũjerãka be'erõ'õ ᵽuri, imajiᵽarũkikaja imarĩ, aᵽekurioka reyarũkimarĩka kimarãñu. ");
INSERT INTO tnc_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","Reyaekakite mayayeika, jiamarĩa ima kiᵽo'ia mayayeyu. I'suᵽaka simako'omakaja õñia kijariᵽe'rirãrõ'õjĩrã ᵽuri jia jiyurika, rikitubaka kiᵽo'ia jarirãka. ");
INSERT INTO tnc_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","“Jia ika ka'iareka nimarũ”, ãrĩwa'ri Tuᵽarãte mare ᵽo'ijiaeka. I'suᵽaka simako'omakaja mareyarãka be'erõ'õ õñia mare kijarirũjerãka ᵽoto jiibaji kika imarũkirã maime. Õ'õrã õñia maime maᵽo'iaᵽi. I'suᵽaka simamaka Tuᵽarã ᵽõ'irã eyatirãoka aᵽeuᵽakakaka ᵽo'iaᵽi maimarãñu, torã jia imarũkia. ");
INSERT INTO tnc_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","Ikuᵽaka sabojayu Tuᵽarã majaroᵽũñurã: “Mamarĩtaka Adán wãmeiki ᵽo'imajire Tuᵽarãte ᵽo'ijiaeka. Suᵽabatirã õñika kire kimarũjeka”, ãrĩwa'ri sabojayu. Cristo ᵽuri, Adán uᵽakamarĩa imaki, mareyarãka ᵽoto Tuᵽarã ᵽõ'irã õñia mare imajiᵽarũjerimaji kime. ");
INSERT INTO tnc_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","I'suᵽaka simako'omakaja õ'õrã maᵽo'ia ima saᵽiji õñia mabo'ikakurirã kika maimajiᵽarũkimarĩa sime ruᵽu. Mareyarãka be'erõ'õ mare kija'atarãñu ᵽo'i imarãka ᵽuri mabo'ikakurirã kika maimajiᵽarũkia. ");
INSERT INTO tnc_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","Mamarĩ imaũ'muekakite ka'iaᵽi Tuᵽarãte ᵽo'ijiaeka. Saᵽi ãrĩwa'ri õ'õrã imarũkikaro'siji kimaeka. Kibe'erõ'õ Cristo ᵽuri mabo'ikakurikaki imaki. ");
INSERT INTO tnc_vpl VALUES ("C115_48","076_15_48","1CO","15","48","49","Ika ka'iareka imarã maimamaka, Adán ᵽo'ia imaeka uᵽakaja sime maᵽo'ia. Ĩmirã Tuᵽarã ᵽõ'irã õñia majarirãka ᵽoto ᵽuri, Jesúᵽo'ia uᵽakaja maᵽo'ia imarãka. I'suᵽaka maro'si simamaka, kiuᵽaka maimarijariye'e mae. ");
INSERT INTO tnc_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","Ikuᵽaka mijare yibojaerã baayu yijeyomarã: Maekaka ima maᵽo'ia wejejẽ'rãkaja imarũkimarĩa imarĩ, Tuᵽarãte ritaja jã'merõ'õrã imabesarãka. ");
INSERT INTO tnc_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","Mija ã'mitiᵽe. Ᵽo'imajare õrĩberika mijare yibojaerã baayu. Cristore ᵽe'rietaerã baarãka ruᵽu ritaja reyaᵽataekarãmarĩa maimarãñu. I'suᵽaka simako'omakaja ĩ'rĩka uᵽakaja Tuᵽarãte maᵽo'ia o'aᵽatarãñu. ");
INSERT INTO tnc_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","Ikuᵽarõ'õᵽiji maᵽĩ'rũtaika uᵽaka maᵽo'ia Tuᵽarãte o'arãñu. Tromᵽeta wãmeika okaarirãka ᵽoto, “Wejetiyia seyayu mirãkiyu”, marĩwãrũrãñu. Sokaarirãka ᵽoto reyakoᵽekarãre mamaka naᵽo'iaᵽi õñia jariᵽe'rirãñu. I'sirĩmi õñia imarãñurãteoka naᵽo'ia Tuᵽarãte o'arãñu. ");
INSERT INTO tnc_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","Maekaka maᵽo'ia ima rabarũkia ima simamaka kika õñia maimajiᵽarũkiaᵽi Tuᵽarãte mare so'arãñu. I'suᵽaka kibaarãñurã imarĩ aᵽekurioka reyarũkimarĩa maimarãñu. ");
INSERT INTO tnc_vpl VALUES ("C115_54","076_15_54","1CO","15","54","55","I'suᵽaka Tuᵽarãte mare baarãñu kimajaroᵽũñurã sabojaeka uᵽakaja simamaka. Mia je'e: “Maᵽo'ia mare o'awa'ri ᵽo'imajare reyaika Tuᵽarãte tiyetamaka, reyarika imabesarãka. Suᵽa simamaka ‘Yija reyarãñu’, ãrĩwa'ri kĩkirika imabesarãka maro'si”, sabojayu. ");
INSERT INTO tnc_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","Ba'iaja baawa'ri mareyarãñu. Tuᵽarãte jã'meika yi'ribeyurãte reyarika simamaka i'suᵽaka mare sariatayu. ");
INSERT INTO tnc_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","I'suᵽaka simako'omakaja maiᵽamaki Jesucristoᵽi ba'iaja imarika tiyibeyurõ'õrã ma'rirũkia imakoᵽekareka mare kitããmaka “Jiitaka mibaayu Tuᵽarã”, jĩjimakaᵽi kire marĩrijayu. ");
INSERT INTO tnc_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","I'suᵽaka simamaka ᵽuᵽarukubekaja, jia Jesucristore yi'ᵽaraka mija imabe yijeyomarã. Suᵽabatirãoka “Waᵽuju Tuᵽarãro'si yija ba'irabekoᵽeyu”, ãrĩᵽuᵽajoabekaja, jiaᵽi kirika mija ba'iraberijaᵽe. ");
INSERT INTO tnc_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","Aᵽerã Jesúre yi'yurãte jeyobaabaraka niñerũ mija rẽarũkiakaka mijare yijaierã baayu mae. Jesúre yi'yurã Galacia ka'iakarãre yibojaraᵽaka uᵽakaja mija baajĩkareka jia sime mijaro'sioka. ");
INSERT INTO tnc_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","Ikuᵽaka mija baabe: Domingo rakakaja mija tõᵽorijayu uᵽaka kũᵽajĩritirĩjaka mija jierijaᵽe. I'suᵽaka mija baarijayua simamaka, yeyarãñurĩmi imatikaja simarãñu. ");
INSERT INTO tnc_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","Mija ᵽõ'irã eyatirã, Jerusalénrã niñerũ e'ewa'rirũkirãte “Ĩrã nime se'ewa'rirũkirã”, mija ãrĩrãñu. Suᵽa imarĩ “Jiirã ᵽo'imaja nime. Nare mija e'etoᵽe”, ãrĩwa'ri ᵽaᵽera nare yo'oĩjirãñu Jerusalénkarãre nabeaeyaerã. ");
INSERT INTO tnc_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","“Naka ya'riye'e je'e”, ñarĩᵽuᵽajoarãkareka, naka ya'rirãñu. ");
INSERT INTO tnc_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","Õ'õᵽi a'ritirã Macedonia wejearã yeyarãñu. Toᵽi turitaᵽabaraka mija wejea Corintorã yeyarãñu. ");
INSERT INTO tnc_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","Ñoaᵽañaka mija ᵽõ'irã ñimarãñu je'e aᵽeyari. Ᵽu'ejẽ'rãkarõ'õjĩrã torã ñimarãñu je'e aᵽeyari. I'sia be'erõ'õ aᵽea wejea yiyaᵽairõ'õrãja ya'yaokaro'si yire imabeyuakaka yire mija ĩjijeyobaarãkareka jia simarãñu yiro'si. ");
INSERT INTO tnc_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","Jajuaᵽi mija ᵽõ'irã ĩawa'ririka yaᵽabeyuka yi'i. I'suᵽaka simamaka, karemarĩtaka Maiᵽamakire yaᵽarãka ᵽoto ñoaka mija ᵽõ'irã ñimarãñu je'e. ");
INSERT INTO tnc_vpl VALUES ("C116_8","076_16_8","1CO","16","8","9","I'suᵽaka simako'omakaja Éfeso wejearã yituirãñu Ᵽentecostés baya o'rirãñurõ'õjĩrã. Õ'õrãja ñimariyaᵽayu ruᵽu rĩkimarãja yiwãrõika ĩaᵽe'yoirãte imako'omakaja, rĩkimarãjaoka Tuᵽarãrika yiwãrõika jia sana'mitiririyaᵽaika simamaka. ");
INSERT INTO tnc_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","Timoteore mija ᵽõ'irã eyarãka ᵽoto jia kire mija baabe mijare kĩkibekaja kimaokaro'si. I'suᵽaka kire mija baabe yuᵽakajaoka Maiᵽamakirika ba'irabeiki kimamaka. ");
INSERT INTO tnc_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","Ba'iaja kire baabekaja kire mija e'etoᵽe. Suᵽabatirã jia kire mija jeyobaabe yiᵽõ'irã ĩarĩ ketaokaro'si. “I'suᵽaka kire mija baabe”, ñañua simamaka ketarika yita'ayu, aᵽerã Jesúre yi'yurãᵽitiyika. ");
INSERT INTO tnc_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","“¿Marãᵽate majeyomaki Aᵽolore etarãñu ate?”, ãᵽaraka ᵽaᵽeraᵽi yire mija jẽrĩaeka ñiaraᵽe. Suᵽa imarĩ aᵽerã Jesúre yi'yurãka mija ᵽõ'irã turirĩ keyaokaro'si kire yiᵽakatarikoᵽeraᵽe. I'suᵽaka yibaako'omakaja, “Torã ya'ririka Tuᵽarãte yaᵽayu maekaka”, kẽrĩᵽuᵽajoabeyu ruᵽu. Suᵽa imarĩ “Mae ya'rijĩkareka jia sime”, kẽrĩᵽuᵽajoarãñurĩmi mija ᵽõ'irã turirĩ ke'rirãñu je'e. ");
INSERT INTO tnc_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","Jia ᵽuᵽajoatirã rakajetikarãja mija imabe. Suᵽabatirã maiᵽamaki Jesucristore yi'ririja'atabekaja, okajãjiaᵽi mija ᵽuᵽajoabe. ");
INSERT INTO tnc_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","Rakakaja ritaja mija baarijayua aᵽerãte wayuĩarikaᵽitiyika oyiaja samija baarijaᵽe. ");
INSERT INTO tnc_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","Estéfanas imaki, kika imarãᵽitiyika Acaya ka'iakarã mamarĩtaka Tuᵽarãrika yibojaraᵽaka yi'riũ'muraᵽarã. Suᵽa imarĩ maekaka aᵽerã Jesúre yi'yurãte jeyobaarimaja imarĩ, i'suᵽakajaoka nabaarijayu naro'si. I'suᵽaka simaraᵽaka õñurã mija ime. ");
INSERT INTO tnc_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","I'suᵽaka simamaka jiaᵽi nare mija yi'ririjaririka yiyaᵽayu. I'suᵽakajaoka naka Tuᵽarãrika ba'iraberimajaka jia mija imarika yiyaᵽayu. ");
INSERT INTO tnc_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","Mija tã'omaja Estéfanas, Fortunato suᵽabatirã Acaicotatarãre etamaka jia jĩjimaka ñime. Mija ᵽuri yoeᵽi imarã imarĩ, yire jeyobaawãrũbeyurã. I'suᵽaka simamaka mija ᵽõ'ikarã yiᵽõ'irã etairã tarãja ᵽuri yire jeyobaairã. ");
INSERT INTO tnc_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","Okajãjia mija imaerã mijare najeyobaaika uᵽakaja yiᵽõ'irã etatirã okajãjia ñimaerã yire najeyobaayu. I'suᵽaka baairãte majiyiᵽuᵽayeejĩkareka jia sime. ");
INSERT INTO tnc_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","Asia ka'iakarã Jesúre yi'yurã, “Jia nimarũ”, mijare ãrĩᵽũairã. Aquila, kirũmu Ᵽrisca, suᵽabatirã nawi'iarã Maiᵽamakire yi'riwa'ri rẽñurãoka, “Jia nimarũ”, mijare ãrĩᵽũairã. ");
INSERT INTO tnc_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","Õ'õkarã muᵽaka Jesúre yi'yurãoka, “Jia nimarũ”, mijare ãrĩᵽũairã naro'si. Tuᵽarãte yi'yurã imarĩ, jia jĩjimakaᵽi mija jẽñetoribu'abe. ");
INSERT INTO tnc_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","Yi'i Ᵽablo, ñoñu uᵽakaja “Jia nimarũ”, ãrĩwa'ri ikuᵽaka yiᵽitakaᵽi mijaro'si yo'oᵽũayu. ");
INSERT INTO tnc_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","Torã maiᵽamaki Jesucristore yaᵽabeyurãte “Ba'iaja Tuᵽarãte nare baarũ”, ãrĩwa'ri i'suᵽaka mijare ñañu. “No'ojĩrãmarĩaja Maiᵽamakire ᵽe'rietarũkirĩmi seyaᵽarũ”, ãrĩwa'ri yaᵽatiyaiki ñime. ");
INSERT INTO tnc_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","“Jia maiᵽamaki Jesúre mijare baarijarirũ”, mijare ñarĩᵽũayu. ");
INSERT INTO tnc_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","I'suᵽakajaoka “Jesucristore ã'mitiriᵽẽairã mija imamaka, jimarĩtakaja nare yiwayuĩayu”, mijareka ñarĩᵽũatayu. I'tojĩrãja sime ruᵽu.");
INSERT INTO tnc_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","¿Yaje mija ime yijeyomarã? Yi'i Ᵽablo, yijeyomaki Timoteoᵽitiyika, “Jia nimarũ”, mijareka yija ãñu. Tuᵽarãte yire jã'meikaᵽi ãrĩwa'ri Jesucristorika bojariroka bojataᵽarimaji ñime. Corintowejeareka suᵽabatirã Acayaka'iarãoka imarã Tuᵽarãte jiyiᵽuᵽayeeokaro'si rẽrĩrijayurãro'si ika ᵽaᵽera yiᵽũatayu. ");
INSERT INTO tnc_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","Maᵽaki Tuᵽarã, suᵽabatirã maiᵽamaki Jesucristoᵽitiyika jia mijare nabaarũ. Suᵽabatirãoka jia ᵽuᵽaᵽaraka mija imaokaro'si mijare najeyobaarũ. ");
INSERT INTO tnc_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","Maiᵽamaki Jesucristo Ᵽakika jĩjimaka imawa'ri “Jia mibaayu Tuᵽarã”, kire yija ãrĩrijayu. Maᵽaki imarĩ, mare kiwayuĩayu. Suᵽabatirã ba'iaja maᵽuᵽaririjayu ᵽoto mare jeyobaaokaro'si maka imaki kime Tuᵽarã. ");
INSERT INTO tnc_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","Ritaja ka'wisika yijaro'si simako'omakaja ba'iaja yija ᵽuᵽarikoreka yijare jeyobaaerã Tuᵽarãte yijaka imajiᵽe. Suᵽa imarĩ yijare kijeyobaaika uᵽakaja aᵽerã ka'wisika jũairãte ba'iaja naᵽuᵽarikoreka nare yija jeyobaawãrũyu. ");
INSERT INTO tnc_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","Cristore yi'yurã imarĩ, ba'iaja kijũaeka uᵽakaja yija jũayu yijaro'sioka. I'suᵽaka simako'omakaja Cristorirã yija imamaka, ba'iaja yija ᵽuᵽarikoreka Tuᵽarãte yijare jeyobaayu. ");
INSERT INTO tnc_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","Jesucristorika bojariroka bojariᵽareaja ba'iaja yija jũarijayu. I'suᵽaka simako'omakaja, sayija rakajeᵽããrijayu jia mijare jeyobaaokaro'si. I'suᵽaka mijaro'si yija imamaka Cristore mija yi'yua ja'atabeyurã mija imarijarirãñu. Ba'iaja yija jũarijayu ᵽoto Tuᵽarãte yijare jeyobaarijayu. I'suᵽaka yija imarijayua õñurã imarĩ, ba'iaja jũariᵽotojo okajãjia imawa'ri samija rakajeᵽããyu mijaro'si. ");
INSERT INTO tnc_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","Yija uᵽakaja Cristore yi'yurã imarĩ, ba'iaja jũarijayurã mija ime. Suᵽa imarĩ “Yijare kijeyobaaika uᵽakaja Tuᵽarãte nare jeyobaarãñu, jia kire nayi'yaokaro'si”, mijareka ãrĩᵽuᵽajoairã imarĩ, ba'iaja yija ᵽuᵽaribeyu. ");
INSERT INTO tnc_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","Mija ã'mitiᵽe yija jeyomarã. Asia ka'iarã tuᵽaraka jimarĩa ba'iaja yija jũaraᵽakakaka mija õrĩrika yija yaᵽayu. Jimarĩtaka ba'iaja jũawa'ri, okajãjimarĩa sarakajeᵽããwãrũbeyurã rõ'õjĩrãrãja yija jaraᵽe. Suᵽa imarĩ “Reyarũkirãja yija ime je'e mae”, ãrĩᵽuᵽajoabaraka ba'iaja yija ᵽuᵽaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","Suᵽabatirã “Najããrũkirãja yija ime”, yija ãrĩᵽuᵽajoaraᵽe. Suᵽa imarĩ yija ᵽuᵽayariji marãkã'ã yija ᵽo'ia ĩarĩrĩwãrũbeyu. I'suᵽaka simako'omakaja “Reyaekarã imakoᵽeirãte ᵽariji õñia jariᵽe'rirũjeiki imarĩ, Tuᵽarã ĩ'rĩkaja imaki yijare ĩarĩrĩwãrũiki”, yija ãrĩwãrũerã i'suᵽaka yijaro'si simaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","“Yija reyaerã baayu”, yija ãrĩtiraᵽakarã werikareka Tuᵽarãte yijare o'ataraᵽe. Suᵽa imarĩ, “Ñamajĩoka i'suᵽaka oyiaja Tuᵽarãte werikareka yijare baajiᵽarijarirãñu”, ãrĩᵽuᵽajoawa'ri ba'iaja yija ᵽuᵽaritiyabeyu. ");
INSERT INTO tnc_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","I'suᵽaka yijaro'si simaerã Tuᵽarãte mija jẽñeĩjirijayuaᵽi ãrĩwa'ri yijare kijeyobaarijayu. Jia Tuᵽarãte yijare jeyobaamaka ĩawa'ri, “Jia mibaayu Tuᵽarã. Mire yija jẽñeika uᵽakaja mibaaraᵽe Ᵽablorãkaro'si”, rĩkimarãja ᵽo'imajare kire ãrĩrãñu. ");
INSERT INTO tnc_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","Aᵽea ikuᵽaka ᵽuᵽajoawa'ri jĩjimaka yija ime. “Tuᵽarãte yaᵽaika uᵽakaja wããrõ'õrãja ᵽo'imajare jia yija baarijayu, nare ᵽakibekaja”, yija ᵽuᵽarõ'õᵽi yija ãrĩᵽuᵽajoayu. Ika wejeareka imarã waᵽuju ᵽuᵽajoatirã nawãrõika uᵽaka mijaka yija imawãrũbeyu. I'suᵽakamarĩa sime, Tuᵽarãte yijare jeyobaamaka jia mijaka yija imawãrũrijayu. ");
INSERT INTO tnc_vpl VALUES ("C21_13","077_1_13","2CO","1","13","13","Suᵽa imarĩ rukubaka mija ᵽuᵽajoaokaro'simarĩa ᵽaᵽera o'otirã mijaro'si sayija ᵽũatarijayu. Yija wãrõika jia mija õñaokaro'si mijaro'si sayija o'oyu. ");
INSERT INTO tnc_vpl VALUES ("C21_14","077_1_14","2CO","1","14","14","Ika mijare yibojaika, “Ᵽablo kijeyomarãᵽitiyika wãjia bojairã nime”, jia ãrĩwãrũbeyukajĩrã ĩ'rãrimarãre ime ruᵽu. Ĩ'rãrĩmi jia yijare õrĩtirã “Ĩ'rã ᵽuri jiitaka yijare wãrõekarã”, yijareka nimauᵽatiji narĩrika yija yaᵽayu. I'suᵽakajaoka maiᵽamaki Jesucristore ᵽe'rietarãñurĩmi “Jia yijare ã'mitiriwa'ri mire nayi'rika”, jĩjimakaᵽi kire yija ãrĩrãñu. ");
INSERT INTO tnc_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","“Jia yika nime je'e. Suᵽa imarĩ Macedonia ka'iarã ya'rirãka ᵽoto naᵽõ'iᵽi yo'rirãñu mamarĩ”, ñarĩᵽuᵽajoakoᵽeraᵽe. I'suᵽaka yibaarikareka ĩ'ᵽakuri mija ᵽõ'irã eyawa'ri jiibaji mijare yijeyobaajããeka. ");
INSERT INTO tnc_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","“Macedonia ka'iarã ya'rirãka ᵽoto naᵽõ'i ñimatawa'rirãñu, suᵽabatirã yiᵽe'rirãka ᵽotooka i'suᵽakajaoka yibaarãñu ate”, ñarĩᵽuᵽajoakoᵽeraᵽe. “Judeaka'iarã yeyawãrũokaro'si Corintowejeakarã yire jeyobaarãñurã”, ñarĩᵽuᵽajoaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","“¿Jia ᵽuᵽajoarimarĩaja i'suᵽaka yijare kẽrãᵽe bai je'e”, yireka mija ãrĩᵽuᵽajoayu bai? Tuᵽarãte õrĩbeyurã ᵽuri nañu uᵽakaja baabeyurã imarĩ, “Ã'ã, i'suᵽaka yibaarãñu”, ãrĩriᵽotojo ñamajĩ ate “Jẽno'o, aᵽe uᵽaka yibaarãñu”, ãñurã. I'suᵽaka ãrĩbeyuka ñime yi'i ᵽuri. ");
INSERT INTO tnc_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","Kẽñu uᵽakaja baaiki kime Tuᵽarã. I'suᵽakajaoka, “Ikuᵽaka yibaarãñu”, ñañua aᵽe uᵽaka baabeyuka ñime. ");
INSERT INTO tnc_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","Kẽñua uᵽakaja baarijayuka Tuᵽarã Maki Jesucristo. Suᵽa imarĩ “Ã'ã ikuᵽaka yibaarãñu”, ãrĩriᵽotojo, aᵽe uᵽaka baabeyuka kime. Kirika bojariroka mijare yija wãrõrijayu, yi'i Ᵽablo, Silvano suᵽabatirã Timoteoᵽitiyika. I'suᵽaka simamaka “Ikuᵽaka yija baarãñu”, ãrĩriᵽotojo aᵽe uᵽaka yija baabeyu yijaoka. ");
INSERT INTO tnc_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","“Ikuᵽaka jia yibaarãñu yirirãte”, kẽrĩka uᵽakaja ritaja Tuᵽarãte baaeka Kimaki Jesucristoᵽi ãrĩwa'ri. Suᵽa imarĩ jia Jesucristoᵽi mare kibaarijayua õñurã imarĩ “Rita, kẽrĩka uᵽakaja baaiki kime”, ãrĩwa'ri Tuᵽarãte majiyiᵽuᵽayeerijayu. ");
INSERT INTO tnc_vpl VALUES ("C21_21","077_1_21","2CO","1","21","22","Jesucristore mayi'yua maja'atakoreka Tuᵽarãte mare jeyobaayu. Suᵽa imarĩ ikijioka kime Jesucristorirã maimaokaro'si mare wã'maekaki. Suᵽabatirã kirirã maima beaokaro'si Esᵽíritu Santore maᵽuᵽakarã kiña'ajããeka. I'suᵽaka kibaamaka, “ ‘Jia yirirãte yibaarãñu’, kẽrĩka uᵽakaja Tuᵽarãte mare baarãñu”, marĩᵽuᵽajoayu. ");
INSERT INTO tnc_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","“Mija ᵽõ'irã ya'rirãñu”, ñarãᵽaka mijare ᵽakiberaᵽaki yi'i. Okajãjiaᵽi mijare okajããriyaᵽaberiwa'ri mija ᵽõ'irã ya'riberaᵽe ruᵽu. Tuᵽarãte ĩaika wãjitãji ikuᵽaka mijare ñañua rita sime. ");
INSERT INTO tnc_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","Mijare okajããtikarã imariᵽotojo, “Ikuᵽaka mija baabe, ikuᵽaka ᵽuri mija baa'si”, ãrĩwa'ri mijare jã'meriyaᵽabeyurã yija. Cristore yi'ritikarã mija imamaka, jĩjimaka mija imaokaro'si wãrõbaraka mijare jeyobaarika yija yaᵽayu. ");
INSERT INTO tnc_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","Bikija mija ᵽõ'irã eyatirã, mija ᵽuᵽaᵽe'rirã okajãjia mijare yijaimaka ba'iaja mija ᵽuᵽaraᵽe. I'suᵽaka simako'omakaja, “Tuᵽarãte yaᵽaika uᵽaka baabeyurãte ᵽuri yokajããrãñu je'e ruᵽu”, ñarĩᵽuᵽajoaraᵽe. I'suᵽaka simamaka “Ba'iaja naᵽuᵽaria'si ate”, ãrĩwa'ri mija ᵽõ'irã turirĩ ya'ribeyukaji ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","Jĩjimaka yire imarũjerimaja mija ime. Suᵽa imarĩ okajãjiaᵽi mijare yijaijĩka ba'iaja ᵽuᵽariwa'ri, marã aᵽerã jĩjimaka yire imarũjerimaja imaberijĩñurã. ");
INSERT INTO tnc_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","“I'suᵽaka naᵽuᵽarijĩñu”, ãrĩwãrũtirã ba'iaja mija ᵽuᵽaririka yaᵽaberiwa'ri mija ᵽõ'irã ya'ribeyu ruᵽu. Mija ᵽõ'irã yeyarũki ruᵽu mijaka okajierika yaᵽawa'ri “Ikuᵽaka mija baabe”, ãᵽaraka ᵽaᵽera takaja mija ᵽõ'irã yiᵽũataraᵽe. Okajietirã ba'iaja ᵽuᵽaᵽekaja jĩjimaka yire ᵽuᵽarirũjerũkirã mija imaokaro'si mijare sayiᵽũataraᵽe. Suᵽa imarĩ “Naᵽõ'irã yeyarãka ᵽoto jia simamaka ĩatirã jĩjimaka nimarãñu je'e naro'sioka”, ñarĩᵽuᵽajoayu. ");
INSERT INTO tnc_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","I'sia ᵽaᵽera mijaro'si yo'oraᵽaka ᵽoto jimarĩa ba'iaja yiᵽuᵽaraᵽe yoraᵽarõ'õjĩrã. Suᵽa simako'omakaja sĩatirã ba'iaja mija ᵽuᵽayaokaro'simarĩa ᵽaᵽera mijare yiᵽũataraᵽe. “Jia mare wayuĩaiki kime Ᵽablo”, mija ãrĩwãrũokaro'si mijare sayiᵽũataraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","Ba'iaja mija watoᵽekarã baaraᵽakite jia imarika yaᵽawa'ri jãjia kire mija baaraᵽakakaka mijaro'si yo'oerã baayu mae. Ba'iaja kibaaraᵽaka ã'mitiritirã, ba'iaja yiᵽuᵽaraᵽaka simamaka saᵽemawa'ribaji mija imaraᵽe je'e, mijaro'sioka. I'suᵽaka simako'omakaja “Ba'itakaja mijare ᵽuᵽarirũjetiyaberaᵽaki kimaraᵽe je'e”, ñañu ba'itakaja kijũarika yaᵽaberiwa'ri. ");
INSERT INTO tnc_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","Ba'iaja kibaaraᵽaka simamaka mija rẽrãᵽaka ᵽoto “Ikuᵽaka kire mabaaye'e kiᵽuᵽaᵽe'yaokaro'si”, mija ima uᵽatiᵽañakaja ãrĩtirã i'suᵽaka kire mija baaraᵽe. I'suᵽaka simamaka maekaka ᵽuri ᵽuᵽaᵽe'yuka kijayua simamaka koᵽakaja samija ja'atabe. ");
INSERT INTO tnc_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","I'suᵽaka kire baabekaja, ba'iaja kibaakoᵽekareka ye'kariritirã jia kire mija jeyoaᵽe ate. I'suᵽaka kika mija imabe, tẽrĩritakaja ba'iaja ᵽuᵽariwa'ri “Marãkã'ã baatirã jia naka imawãrũbeyuka yi'i”, kẽrĩᵽuᵽajoakoreka. ");
INSERT INTO tnc_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","Kika mija jeyoaᵽakã'ã, “Rita yire nawayuĩayu ate”, kẽñaokaro'si i'suᵽaka kika mija imarika yiyaᵽayu. ");
INSERT INTO tnc_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","Kire yibaarũjeraᵽaka uᵽakaja mija yi'rirã ᵽaᵽera mijare yiᵽũataraᵽaka imarĩ, “Maekakaoka nare ñañu uᵽakaja baairã nime”, mijareka ãrĩᵽuᵽajoaiki ñime. ");
INSERT INTO tnc_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","Suᵽa imarĩ ba'iaja baakoᵽekakite ba'iaja baaeka mija ye'karirirãkareka i'suᵽakajaoka simarãñu yiro'sioka. Yire ba'iaja kibaaika imakoᵽejĩka sareka kire yiwayuĩajĩñu. Ĩ'rĩka uᵽakaja jĩjimaka mija imarika yaᵽawa'ri Cristore ĩaika wãjitãji i'suᵽaka ñimarijayu. ");
INSERT INTO tnc_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","Kire mawayuĩaye'e, ba'iaja ᵽuᵽawa'ri Satanáre yaᵽaika uᵽakaja kibaa'si. I'suᵽakajaoka maro'si sima'si, majeyomakite mawayuĩajĩñu. Satanáre mare ᵽakiriyaᵽaikakaka õñurã maime. ");
INSERT INTO tnc_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","Tróadewejearã yeyaraᵽaka ᵽoto Maiᵽamakire yire jeyobaaikaᵽi ãrĩwa'ri imatikaja ᵽo'imajare imaraᵽe yire na'mitiyaokaro'si. Suᵽa imarĩ Jesúrika bojariroka nare yiwãrõmaka jĩjimakaᵽi tokarãre yire ã'mitiraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","I'suᵽaka simako'omakaja Tróaderã majeyomaki Titore imabeᵽakã'ã ba'iaja yiᵽuᵽaraᵽe. Torãjĩrã mae, tokarãre yimajaroka bojaweatirã Macedoniaka'iarã ya'raᵽe Titore mo'arĩ. ");
INSERT INTO tnc_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","Ba'iaja yiᵽuᵽariko'omakaja Cristorirã yija imamaka dakoa imabeyua yijare tẽrĩrũkia mae. Suᵽa imarĩ “Jiitaka mibaayu Tuᵽarã”, ãᵽaraka jia yija ᵽuᵽarijayu. Suᵽabatirã Cristorika bojariroka bojaᵽibarimaja yija imaokaro'si Tuᵽarãte yijare ᵽũataeka ritaja ᵽo'imajare sõñaokaro'si. I'suᵽaka simamaka ĩ'rãkõ'rĩmato jariwa'ririmarĩaja sayija bojataᵽamaka ã'mitiritirã, Cristore nayi'yu. Ĩakõrĩ je'e, ikuᵽaka sime: Maᵽaõmea majoeika ᵽoto ritaja sajĩsia ᵽibika ritaja ᵽo'imajare wĩ'ĩka uᵽaka simarijayu. ");
INSERT INTO tnc_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","Cristorika bojariroka yija bojaᵽibamaka ĩawa'ri jĩjimaka Tuᵽarãte yijaka ime. Kirika yija wãrõtaᵽa, Tuᵽarã ᵽõ'irã a'rirũkirã, suᵽabatirãoka ba'iaja imarika tiyibeyurõ'õrã a'rirũkirã ᵽariji sã'mitiririjayurã. ");
INSERT INTO tnc_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","Cristore yi'riberirika ima, “Ba'iaja imarika tiyibeyurõ'õrã a'ririwaᵽaka”, ãrĩwa'ri nare yija bojamaka nayi'ribeyu Cristorika yija wãrõika ã'mitiririyaᵽabeyurã. Tuᵽarã ᵽõ'irã a'rirũkirãro'si ᵽuri nare yija wãrõika nayi'yu õñia nimajiᵽarũkiroka naro'si simamaka. I'suᵽaka Cristorika yija wãrõrijayua ᵽemawa'ribaji imatiyaika simamaka Tuᵽarãte yijare jeyobaaberirikareka, marãkã'ã baatirã wãjia sayija bojawãrũberijããeka. ");
INSERT INTO tnc_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","I'suᵽaka ñañua simako'omakaja, rĩkimarãja nime niñerũ tõᵽoriyaᵽawa'ri takaja Cristorika bojariroka wãrõtaᵽarimaja. Nuᵽaka baarijaribeyurã yija ᵽuri. Jesúrirã imarĩ, kirika bojariroka ᵽakirimarĩaja ᵽo'imajare wãrõerã Tuᵽarãte ᵽũatairã yija ime. I'suᵽaka ᵽuᵽajoairã yija ima simamaka kĩaika wãjitãji wãjirokaᵽi yija wãrõrijayu. ");
INSERT INTO tnc_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","I'suᵽaka yo'oko'omakaja “Yija imarã imatiyarimaja”, ãrĩwa'rimarĩa i'suᵽaka mijare yija bojayu. Aᵽerã wãrõrimaja ᵽuri “Imatiyarimaja yija ime”, ãrĩkoᵽerijayurã. Mija ᵽõ'irã netarijayu ᵽoto ᵽaᵽera naro'si aᵽerãte o'oeka mijare nabearijayu. I'suᵽaka mijare nabeaika ᵽaᵽera ima, “Jia wãrõirã nime”, ãrĩwa'ri nawãrõirõ'õkarãre no'orũjerijayua. I'suᵽakajaoka aᵽerõ'õrã na'yu ᵽoto mijare nawãrõikakaka ᵽaᵽera no'orũjerijayu. Yija ᵽuri, i'suᵽaka baabeyurã. ");
INSERT INTO tnc_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","Mijaja imarã “Jia wãrõirã yija ime”, ãᵽaraka ᵽaᵽera yija bearũkirã uᵽaka yijaro'si imarã. Yija wãrõika yi'riwa'ri ba'iaja mija baaika ja'atatirã aᵽeuᵽaka mija o'amaka ĩatirã, “Jia Cristorika bojariroka Ᵽablorãkare nare wãrõyu”, ritaja ᵽo'imajare ãrĩᵽuᵽajoarijayu. I'suᵽaka mija baaika yija ᵽuᵽakarã sayija õñu. ");
INSERT INTO tnc_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","Cristo ᵽaᵽera maika uᵽaka imarã mija ime. Kirika bojariroka yija wãrõikaᵽi ãrĩwa'ri Cristore mija ᵽuᵽaka jia o'aika ritaja ᵽo'imajare ĩawãrũᵽatayu. Aᵽerã wãrõrimaja ᵽaᵽera o'oeka narikaika uᵽakamarĩa mija ime. Tuᵽarã, õñia imajiᵽarimaji Esᵽíritu Santore mija ᵽuᵽakarã mijare kiña'ajããeka simamaka i'suᵽaka sime. Moisés imaroyikakiro'si ãtaᵽãiarã Tuᵽarãte o'oeka uᵽakamarĩa sime mae. I'suᵽakamarĩa simamaka maᵽuᵽaka Esᵽíritu Santojo mare o'arijayuka. ");
INSERT INTO tnc_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","Jia mijare yija wãrõerã Cristore yijare jeyobaayu. I'suᵽaka simamaka “Nare yija wãrõikaᵽi ãrĩwa'ri Cristore yaᵽaika uᵽaka baairã nime”, Tuᵽarãte ĩaika wãjitãji yija ãrĩwãrũyu. ");
INSERT INTO tnc_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","I'suᵽaka jĩjimaka yija ãñua simako'omakaja yija ᵽuᵽayariji yija õñuaᵽi ãrĩwa'rimarĩa jia yija wãrõyu. Tuᵽarãte yijare jeyobaaikaᵽi ãrĩwa'ri takaja ritaja yija baawãrũyu. ");
INSERT INTO tnc_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","Tuᵽarãjaoka imaki kimajaroka mamakukukaka bojaĩjirimaja yija imaokaro'si yijare jeyobaaiki. Suᵽa imarĩ “Yimakire ã'mitiriᵽẽairãte yitããrãñu”, Tuᵽarãte ãñua bojaika sime mamakukukaka majaroka. Suᵽa imarĩ bikija Moisés imaroyikakite o'oeka ãrĩroyika uᵽakamarĩa yija wãrõyu mae. Esᵽíritu Santoᵽi ãrĩwa'ri maᵽuᵽaka o'amaka kire mayi'rirũkiakaka sabojayu mamakukukaka majaroka. Bikija Tuᵽarãte jã'meka o'oeka yi'rikoᵽeirã ᵽuri nareyarãka be'erõ'õ kika imajiᵽabesarãñurã. I'suᵽakamarĩa sime mamakukukaka majaroka yi'yurãro'si ᵽuri. Esᵽíritu Santore nare ña'rĩjãimaka Tuᵽarãka õñia nimajiᵽarãñu ãrĩwa'ri sabojayu. ");
INSERT INTO tnc_vpl VALUES ("C23_7","077_3_7","2CO","3","7","8","Kijã'meika ãta ᵽãiarã o'otirã, Moisés imaroyirekakite mamarĩ Tuᵽarãte kire saja'ataeka. I'sia kire kija'ataekarĩmi Tuᵽarãte kĩaeka be'erõ'õ simamaka jimarĩ jãjia Moisés ᵽema yaaboaeka. I'suᵽaka simamaka Israeltatarã marãkã'ã baatirã sarakajeᵽããberiwa'ri kiᵽema niariyaᵽaberika. Bikija Tuᵽarãte jã'meka jiitaka simaeka. I'suᵽaka simaeka koᵽakaja Moisés ᵽema jãjia yaaboaeka. Suᵽa imariᵽotojo ĩ'rãrĩmi uᵽakaja sariririjarika. Bikija Tuᵽarãte jã'meka o'oeka jãjia yaaboaikaᵽitiyika ᵽo'imajaro'si kire sakija'ataeka simako'omakaja sayi'riwãrũberiwa'ri, Tuᵽarã ᵽõ'irã ᵽo'imajare a'riberika ãrĩwa'ri sabojayu. Mamarĩ kijã'meroyika yaaboaikaᵽitiyika sakija'ataeka simako'omakaja satẽrĩwa'ribaji jia sime ika mamakukukaka majaroka. Suᵽa imarĩ õñia imajiᵽarũkiakaka Esᵽíritu Santore maro'si e'era'aeka. I'suᵽaka ima imarĩ, ñamajĩ aᵽerikurioka ᵽurirũkimarĩa sime. ");
INSERT INTO tnc_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","Bikija Moisés imaroyikakite kijã'merũkia Tuᵽarãte kire ĩjikakaka ᵽuri sayi'riberiwa'ri “Tuᵽarãte yaᵽaika uᵽaka ᵽo'imajare baabeᵽakã'ã ba'iaja nare kimarũjerãñu”, sãñu. I'suᵽaka imariᵽotojo jãjia yaaboaikaᵽi setaeka. Ika mamakukukaka majaroka ᵽuri Tuᵽarãte ĩaika wãjitãji wãjia ᵽo'imajare imarũjerikakaka mare bojaika. Suᵽa imarĩ bikijakaka jãjia yaaboaikaᵽi setako'omakaja mamakukukaka ᵽuri tẽrĩwa'ribaji imatiyaika majaroka sime. ");
INSERT INTO tnc_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","Jia simaroyika mamarĩ Moiséte jã'meroyika. Suᵽa simako'omakaja satẽrĩwa'ribaji imatiyaika sime ika mamakukukaka majaroka. I'suᵽaka maᵽuᵽajoaika simamaka, “Mamarĩ imara'aeka majaroka imatiyabeyua sime mae”, marĩᵽuᵽajoayu. ");
INSERT INTO tnc_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","Ñoaka imarũkimarĩa imariᵽotojo Moiséte jã'meroyika jãjia yaaboaika watoᵽekaᵽi etaeka. I'suᵽaka simamaka, ika mamakukukaka majaroka Tuᵽarãte mare ja'ataeka ᵽuri imajiᵽarũkia imarĩ, tẽrĩwa'ribaji imatiyaika sime. ");
INSERT INTO tnc_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","“Imajiᵽarũkia sime”, jia õrĩwãrũirã imarĩ, kĩkirimarĩaja ᵽo'imajare sayija wãrõrijayu. ");
INSERT INTO tnc_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","Imajiᵽarũkia simamaka, Moisés imaroyirekaki uᵽaka yija imabeyu. Kiᵽema jãjia yaaboaeka yaririjarika Israelkarãre ĩakoreka sayaᵽãiaᵽi kiᵽema kirãrĩta'aroyika. Kiᵽema jãjia yaaboaeka yaririjarika ãrĩrikoᵽakaja mamarĩ Moiséte jã'meroyika tiyirijayua. ");
INSERT INTO tnc_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","I'suᵽaka simarijariko'omakaja Israelkarã ᵽuri satiyirijayua ã'mitiriᵽẽaberikarã imarĩ, maekakaoka i'suᵽakaja imañujurã ruᵽu. I'suᵽaka imarã nimamaka, Moiséte jã'meroyirekakaka niaika ᵽoto, “Koᵽakaja Tuᵽarãte satiyetaeka”, ãrĩwãrũbeyurã nime. I'suᵽaka imabekaja, Cristore takaja yi'yurã nimajĩkareka ᵽuri jia sanorĩwãrũjĩñu. ");
INSERT INTO tnc_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","I'suᵽaka imariᵽotojo maekaka ᵽariji Moiséte o'oeka wãrũriᵽotojo sanorĩwãrũbeyukaji ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","I'suᵽaka simakoᵽeko'omakaja Maiᵽamakire ĩ'rãrimarãre yi'riũ'mumaka ĩatirã nare kijeyobaayu “Saniawãrũrũ”, ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","Esᵽíritu Santoᵽi ãrĩwa'ri Maiᵽamakire mare jeyobaayu. I'suᵽaka mare jeyobaabaraka maka kimarijayua simamaka, Moiséte jã'meroyika mayi'rikoᵽeka ja'atatirã, Cristore yaᵽaika uᵽakaja baawãrũirã maime mae. ");
INSERT INTO tnc_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","Koᵽakaja jia sõrĩwaᵽu'atairã jariwa'ri, Maiᵽamakire ᵽuᵽajoarijaᵽaraka, tẽrĩwa'ribaji kima morĩwãrũrijayu mae. I'suᵽaka maimaᵽi ĩ'rãrĩmi uᵽakaja jiibaji Maiᵽamaki uᵽakaja maimarijarirã Esᵽíritu Santore maᵽuᵽaka mare o'arijayu. ");
INSERT INTO tnc_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","Yijare wayuĩawa'ri, yijare wã'matirã kimajaroka mamakukukaka ᵽo'imajare wãrõrimaja Tuᵽarãte yijare imarũjeka. I'suᵽaka simamaka, ba'iaja aᵽerikuri yijaro'si simarijayua imako'omakaja, sayija wãrõrija'atabeyu. ");
INSERT INTO tnc_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","Suᵽa imarĩ aᵽerãte kareaja i'yoa baarijayu uᵽaka baabeyurã yija ime. I'suᵽakajaoka “Jia ᵽo'imajare yijare yi'rirũ”, ãrĩwa'ri waᵽuju nare ᵽakibeyurã yija ime. I'suᵽaka imarã imarĩ, Tuᵽarãrika bojariroka aᵽemijiᵽi so'atirã yija õñu uᵽakaja yija ᵽuᵽajoaika wãrõbeyurã yija ime. Suᵽa imarĩ Tuᵽarãte ĩaika wãjitãji jia wãjiroka norĩwaᵽu'atawãrũirokaᵽi ᵽo'imajare Tuᵽarãrika yija wãrõyu. I'suᵽaka yija baamaka “Ᵽakibeyurã nime”, ᵽo'imajare yijareka ãrĩwãrũyu. ");
INSERT INTO tnc_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","I'suᵽaka yija wãrõika simako'omakaja “Ᵽablorãkare wãrõika ĩ'rãrimarãre õrĩwaᵽu'atabeyu”, ãñurã mija ime ĩ'rãrimarã. Ikuᵽaka sime: Maiᵽamakire yi'ririyaᵽaberiwa'ri, ba'iaja imarika tiyibeyurõ'õrã a'rirũkirã imarĩ, yija wãrõika norĩwaᵽu'atawãrũbeyu. ");
INSERT INTO tnc_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","Cristore nayi'ribeyuaᵽi ãrĩwa'ri ᵽo'imajare kiᵽakika uᵽakaja Satanáre nare imarũjerijayu ruᵽu. Suᵽa imarĩ Jesúrika tẽrĩwa'ribaji imatiyaiki bojariroka õrĩwaᵽu'atabeyaka nare kimarũjerijayu. I'suᵽaka nimarijayua simamaka, “Tuᵽarãte ima uᵽakaja Jesúre ime”, narĩwãrũbeyu. ");
INSERT INTO tnc_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","Jesucristore jiyiᵽuᵽaka õñurã imarĩ, yija baarijayuakaka takaja ᵽuᵽajoabaraka ᵽo'imajare wãrõbeyurã yija. “Imatiyairã Ᵽablorãkare ime mirãkiyu”, mija ãrĩrika yaᵽaberiwa'ri i'suᵽaka yija baabeyu. I'suᵽaka baabekaja “Jesucristo kime Maiᵽamaki”, ãᵽaraka yija wãrõrijayu. Suᵽa imarĩ mijare ĩarĩᵽaraka yija ba'irabeĩjirã Jesúre yijare ᵽũataeka simamaka, kiyaᵽaeka uᵽakaja yija baarijayu. ");
INSERT INTO tnc_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","Tuᵽarã ᵽuri ika wejea rubu'ataeka, neia simakoᵽekareka saborirũjekaki. I'suᵽakajaoka Cristore yija õrĩberikoᵽekareka, yijare kire kiõrĩwãrũrũjeka. Suᵽa imarĩ Jesucristore yija yi'ᵽakã'ã Tuᵽarãja tẽrĩriki kimaoka yija ᵽuᵽarõ'õrã yijare õrĩrũjeraᵽaki. ");
INSERT INTO tnc_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","Tẽrĩtakakaka Tuᵽarãrika bojarĩ kiᵽũataekarã imariᵽotojo “Tẽrĩrirã yija ime”, ãrĩbeyurã yija. Ĩakõrĩ je'e: Waᵽajã'rĩmarĩa jotoka'i jototõsiarã waᵽajã'rĩa jãma uᵽaka imarã yija ime. I'suᵽaka simamaka yija ᵽuᵽakarã Tuᵽarãrika yijareka imarã yija ime. Suᵽa imarĩ “Naᵽuᵽajoaikaᵽimarĩa wãrõrimaja nime. Tuᵽarã tẽrĩrikaja imakite nare jeyobaaikaᵽi jia nabaayu”, ᵽo'imajare yijareka ãrĩwãrũyu mae. ");
INSERT INTO tnc_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","Ᵽo'imajare Jesúrika bojariroka wãrõriᵽareaja, ĩ'rãkurimarĩa ba'iaja yija jũarijayu. I'suᵽaka simako'omakaja, sarãja sayija ja'atarijaribeyu. I'suᵽakajaoka “¿Marãkã'ã yija baarãñu mae?”, ãrĩᵽuᵽajoako'omakaja “Tuᵽarãte yijare ja'atayu”, ãrĩbeyurã yija ime. ");
INSERT INTO tnc_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","Rĩkimarãja yijare ã'mijĩairãte imako'omakaja Tuᵽarã ᵽuri yijare ja'atabeyuka. Ĩ'rãkurimarĩa yijare jããrika ri'kakoᵽeirã imarĩ, yijare nakãmibaaeka simako'omakaja Tuᵽarãte yijare jeyobaaika simamaka yijare najããwãrũbeyu. ");
INSERT INTO tnc_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","Yija turirijayurõ'õ rakakaja nime ĩ'rãrimarã yijare jããrika ri'karijayurã. Jesúre najããeka uᵽakajaoka yijare najããriyaᵽayu. I'suᵽakajaoka ba'iaja kijũaeka uᵽakaja jũariᵽotojo jia sayija rakajeᵽããmaka ĩawa'ri, “Naᵽuᵽakareka Jesúre imamaka, kirikaᵽi i'suᵽaka nime”, ᵽo'imajare ãrĩwãrũokaro'si suᵽa yija imarijayu. ");
INSERT INTO tnc_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","Jesúrika bojariroka yija wãrõriᵽareareka, ĩ'rãrĩmi uᵽakaja yijare jããrika nari'kaika watoᵽekarekaja yija imarijayu. I'suᵽaka yijaro'si simako'omakaja “Jesúre naᵽuᵽakareka imaᵽi ãrĩwa'ri kiuᵽaka jia sanarakajeᵽããrijayu”, yijareka ᵽo'imajare ãrĩwãrũokaro'si i'suᵽaka yija jũarijayu. ");
INSERT INTO tnc_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","I'suᵽaka ba'iaja yija jũaika simako'omakaja, yija wãrõika ã'mitiritirã samija yi'yuaᵽi ãrĩwa'ri Tuᵽarãka õñia mija imajiᵽarãñu. ");
INSERT INTO tnc_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","I'suᵽaka simamaka ba'iaja yija ᵽuᵽaribeyu. Mija ĩabe, ikuᵽaka sãñu Tuᵽarã majaroᵽũñu o'oekarã: “Tuᵽarãte yi'yuka imarĩ, kirika bojariroka ᵽo'imajare yiwãrõyu”, ĩ'rĩkate ãrĩka. I'suᵽakajaoka yija ᵽuᵽajoayu yijaro'si. Tuᵽarãte ã'mitiriᵽẽairã imarĩ, kirika bojariroka ja'atarimarĩaja yija wãrõrijayu. ");
INSERT INTO tnc_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","I'suᵽaka ᵽuᵽajoairã imarĩ, ᵽo'imaja yijare jããrika ri'kakoᵽeika yija kĩkibeyu. Maiᵽamaki Jesucristo reyaekakite õñia Tuᵽarãte jariᵽe'rirũjeka ate. Suᵽa imarĩ Jesúrirã yija imamaka, “Yija reyakoᵽeko'omakaja õñia Tuᵽarãte yijare jariᵽe'rirũjerãñu ate”, yija ãrĩᵽuᵽajoayu. I'suᵽakajaoka mijare kibaarãñu. Suᵽabatirã kimarõ'õrã Tuᵽarãte mare e'ewa'rirãñu. ");
INSERT INTO tnc_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","Suᵽa simamaka, “Jia mijaro'si simarũ”, ãrĩwa'ri ba'iaja jũariᵽotojo Tuᵽarãrika bojariroka mijare yija wãrõrijayu. I'suᵽaka yija baaika simamaka ĩ'rãrĩmi uᵽakaja rĩkimabaji Jesucristore yi'yurã ᵽo'imajare imarijayu. Kire nayi'yuaᵽi ãrĩwa'ri jia Tuᵽarãte nare baamaka “Mare wayuĩaiki imarĩ, jia Tuᵽarãte mare baayu”, narĩrijayu. Suᵽa imarĩ “Tẽrĩrikaja imatiyaiki kime”, ãrĩwa'ri ᵽo'imajare kire jiyiᵽuᵽayeerijayu. ");
INSERT INTO tnc_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","I'suᵽaka simamaka ba'iaja ᵽuᵽaᵽekaja Jesúrika bojariroka ja'atarimarĩaja yija wãrõrijayu. Yija ᵽo'ia ba'iaja jũabaraka rũetaka sajaririjariko'omakaja ĩ'rãrĩmi uᵽakaja yija ᵽuᵽaka okajãjia imaokaro'si Tuᵽarãte yijare jeyobaarijayu. ");
INSERT INTO tnc_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","Ritaja wejea yija turitaᵽarõ'õ ba'iaja yija jũarijayua ᵽuri wejejẽ'rãkaja imarũkimarĩa sime. Suᵽa yija jũako'omakaja, “Kika õñia yija imajiᵽarũkia ᵽuri tẽrĩwa'ribaji jia imarũkia sime yijaro'si”, ãrĩᵽuᵽajoawa'ri, maekaka jimarĩ ba'iaja yija jũakoᵽeika marã imabeyua yijaro'si. ");
INSERT INTO tnc_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","Suᵽa imarĩ ika ka'iareka yija ĩarijayua ᵽuri ᵽurirũkia sime. I'suᵽakamarĩa yija ĩabeyua ᵽuri imajiᵽarũkia ima. I'suᵽaka simamaka, maekaka yija ĩarijayua ᵽuᵽajoatiyabekaja yija ime. Mabo'ikakurirã maimarũkiakaka ᵽuri sĩabeririᵽotojo sayija ᵽuᵽajoatiyarijayu. ");
INSERT INTO tnc_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","Ika maᵽo'ia wejejẽ'rãkaja õñia imarũkiro'simarĩa sime, ñojimarĩji reyarũkia. I'suᵽaka simako'omakaja “Mareyarãka be'erõ'õ õñia mare jariᵽe'rirũjetirã maᵽo'ia Tuᵽarãte mare o'arãñu”, marĩᵽuᵽajoayu. I'suᵽaka mare kibaarũki ᵽo'iᵽuri maekaka maᵽo'ia ima uᵽakamarĩa imarãka, õñia imajiᵽarũkia imarĩ. ");
INSERT INTO tnc_vpl VALUES ("C25_2","077_5_2","2CO","5","2","2","Ika ka'iareka imabaraka ka'wisika majũarijayu ᵽoto Tuᵽarã ᵽõ'irã mamaka ᵽo'iaᵽi imarika maᵽuᵽajoarijayu. ");
INSERT INTO tnc_vpl VALUES ("C25_3","077_5_3","2CO","5","3","3","Yiaᵽuᵽaka takaᵽijimarĩa Tuᵽarã ᵽõ'irã maimarãka simamaka i'suᵽaka ñañu. Mamaka ᵽo'ia mare kio'arãkaᵽi kiᵽõ'irã maimarãñu. ");
INSERT INTO tnc_vpl VALUES ("C25_4","077_5_4","2CO","5","4","4","Ba'iaja imarikareka rũñurã imariᵽotojo dakoa okamirãmarĩaja aᵽekukurã imarika maimariᵽuᵽajoayu. I'suᵽaka maᵽuᵽajoaika, “Ᵽo'imarĩrã maimariyaᵽayu”, ãrĩwa'rimarĩa samaᵽuᵽajoayu. Wããrõ'õrã maima ja'atatirã, reyariba'ikakamarĩa ᵽo'ikirã maimariyaᵽayu. ");
INSERT INTO tnc_vpl VALUES ("C25_5","077_5_5","2CO","5","5","5","Suᵽa imarĩ mareyarãka be'erõ'õᵽi, ᵽo'ia mare kija'atarãkaᵽi maimaokaro'si Tuᵽarãte mare ᵽo'ijiaeka. Suᵽa imarĩ “Tuᵽarã imaki i'suᵽaka mare baarũkika”, marĩwãrũokaro'si Esᵽíritu Santore mare kiña'ajããeka. ");
INSERT INTO tnc_vpl VALUES ("C25_6","077_5_6","2CO","5","6","6","I'tojĩteᵽi ãrĩwa'ri maka kima moñua simamaka, Tuᵽarãte mayi'yu. Õ'õrã maima ᵽoto ᵽuri, maiᵽamaki Jesucristo ᵽõ'irã maimabeyua simako'omakaja “Mareyarãka be'erõ'õᵽi ᵽuri kika maimarãñu”, jĩjimaka marĩrijayu. ");
INSERT INTO tnc_vpl VALUES ("C25_7","077_5_7","2CO","5","7","7","Maekaka wããrõ'õrã kire maibeyukajia simamaka i'suᵽaka mañu. Jesúre yi'yurã imarĩ, “Mare kẽrĩka uᵽakaja maro'si simarãñu”, marĩᵽuᵽajoayu samaibeyua simako'omakaja. ");
INSERT INTO tnc_vpl VALUES ("C25_8","077_5_8","2CO","5","8","8","Suᵽa imarĩ “Tuᵽarãte ãrĩka uᵽaka baaiki imarĩ maᵽo'ia mare kio'arãñu”, mañu. I'suᵽaka simamaka, reyatirã sarekaja Maiᵽamakika maimariyaᵽakoᵽeyu. ");
INSERT INTO tnc_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","I'suᵽaka ᵽuᵽajoariᵽotojo ika ka'iareka õñia maimatiyikuriji jĩjimaka kĩajiyuika mabaarijayu. Õ'õrã maima ᵽoto mabaarijayu uᵽakajaoka mareyarãka be'erõ'õᵽi maimarãñurõ'õrã mabaarãñu. I'suᵽaka imarijarirũkirã maime. ");
INSERT INTO tnc_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","I'suᵽaka simamaka ritaja ika wejeareka kiro'si mabaaĩjika ĩ'rãrĩmi Cristore ĩarãñu. I'suᵽaka kibaarãñurĩmi jia, ba'iaoka kiro'si mabaaĩjika ko'aᵽitorãja sawaᵽa matõᵽorãñu. ");
INSERT INTO tnc_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","I'suᵽaka kiro'si yija baaĩjika “Kĩarũkia sime”, ãrĩwa'ri Tuᵽarãrika bojariroka ᵽo'imajare yi'yaokaro'si jia oyiaja nare yija wãrõrijayu sayija õrĩwãrũirõ'õjĩrãja. I'suᵽaka yija baaika, suᵽabatirãoka kiyaᵽaika uᵽakaja yija imarijayua õñuka Tuᵽarã. I'suᵽaka simamaka samija õñu je'e mijaro'sioka. ");
INSERT INTO tnc_vpl VALUES ("C25_12","077_5_12","2CO","5","12","12","Mija ĩabe. “Jiirã nime”, yijareka mija ãñaokaro'simarĩa i'suᵽaka mijare yija bojayu ate. I'suᵽaka baabekaja “Ᵽablorãkare waᵽuju mija jaiyuyeyu”, yijare jaiyuyeirãte mija ãñaokaro'si mijare sayija bojarijayu. Ikuᵽaka nime yijare jaiyuyeirã: “Jia wãrõrimaja nime”, ᵽo'imajare nareka ãñaokaro'si nawãrõrijayu. I'suᵽaka baariᵽotojo “¿Yaje yija ᵽuᵽarõ'õᵽi ᵽuri jia Tuᵽarãka yija ime?”, narĩri imakoᵽeyu. ");
INSERT INTO tnc_vpl VALUES ("C25_13","077_5_13","2CO","5","13","13","Tuᵽarãte yijiyiᵽuᵽayeetiyariᵽareaja “Waᵽuju wejabiritikakiji kime Ᵽablo”, ĩ'rãrimarãre yireka ãrĩkoᵽeika, marã imabeyua yiro'si. I'suᵽaka narĩko'omakaja “Jia õrĩᵽũairã imarĩ, Tuᵽarãrika bojariroka jia yijare nawãrõrijayu”, yijareka mija ãrĩᵽuᵽajoajĩka jia sime. Jia mijare jeyobaaokaro'si i'suᵽaka yija baayu. ");
INSERT INTO tnc_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","“Cristore mare wayuĩatiyayu”, ãrĩᵽuᵽajoairã imarĩ, jẽrĩtarimarĩaja kirika bojariroka yija wãrõrijayu. Mare wayuĩawa'ri ba'iaja mabaaika waᵽa maro'si kireyaĩjika simamaka, kika reyaekarã uᵽakaja maime maro'sioka. ");
INSERT INTO tnc_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","Ritaja ᵽo'imajare wayuĩawa'ri ba'iaja nabaaeka waᵽa Jesúre naro'si reyaĩjika. Ikijioka imaki reyariᵽotojo õñia jariᵽe'rikaki. Suᵽa imarĩ “Jĩjimaka maimarũkia takaja ᵽuᵽajoabekaja maimaye'e mae”, ãrĩᵽuᵽajoawa'ri kĩarijiyuika takaja mabaarijariye'e. ");
INSERT INTO tnc_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","Suᵽa imarĩ ᵽo'imajare ĩatirã “I'suᵽaka nime”, Tuᵽarãte õrĩbeyurãte ãrĩka uᵽaka yija ãrĩbeyu mae. Cristore yi'ribeyukajirã yija imaroyiraᵽaka ᵽoto ᵽuri “Muᵽakaja imaki kime”, kireka ãrĩᵽuᵽajoairã yija imaroyiraᵽe. Maekaka ᵽuri jia Cristore yi'yurã imarĩ, aᵽe uᵽaka kireka yija ᵽuᵽajoayu. ");
INSERT INTO tnc_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","Suᵽabatirã Jesucristoriki ᵽuri Tuᵽarãte kiᵽuᵽaka o'aekaki imaki. Bikija kimaroyika mirãkareka aᵽeuᵽaka kiᵽuᵽaka o'aekaki imarĩ, mamarokaᵽi oyiaja ᵽuᵽajoaiki kime mae. ");
INSERT INTO tnc_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","Tuᵽarã ĩ'rĩkaja imaki maᵽuᵽaka o'aiki. Bikija ᵽuri kire jo'ata'arimaja maimaeka simako'omakaja Jesucristore reyaekaᵽi ãrĩwa'ri “Jia yika mija imabe”, Tuᵽarãte mare ãrĩka. Suᵽa imarĩ i'sia majaroka ᵽo'imajare yija wãrõikaᵽi jia kika nimaerã, nare bojarimajaro'si yijare kiᵽũataeka. ");
INSERT INTO tnc_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","Mija ĩabe, ikuᵽaka sime ᵽo'imajare yija wãrõika: Ritaja ᵽo'imaja Tuᵽarãte jo'ata'arimaja uᵽaka nimako'omakaja jia kika nimarika kiyaᵽaeka. Suᵽa imarĩ ritaja ba'iaja nabaaika waᵽa Jesucristore naro'si reyaĩjiokaro'si kire kiᵽũataeka. Suᵽabatirã kire nayi'yuaᵽi ãrĩwa'ri dakoa oka nare imabeyua Tuᵽarãte ĩaika wãjitãji. Suᵽa imarĩ jĩjimakaᵽi kirirã nare kimarũjeyu. Ika majaroka ritaja ᵽo'imajare yija wãrõtaᵽaokaro'si Tuᵽarãte yijare ᵽũataeka. ");
INSERT INTO tnc_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","I'suᵽaka simamaka Cristoro'si kirika bojariroka bojaĩjirimaja yija ime. Ᵽo'imajare yija bojaika Tuᵽarãja etatirã kibojari koᵽakaja nare sayija bojayu. I'suᵽaka yija ima simamaka, “Kirika bojariroka yi'riwa'ri jia kika mija imabe”, ᵽo'imajare yija ãñuaᵽi ãrĩwa'ri Tuᵽarãte nare okajããrijayu. ");
INSERT INTO tnc_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","Mija ĩabe. Ĩ'rãkurioka ba'iaja baakoribeyuka Jesúre imako'omakaja, ba'iaja baarimaji uᵽaka reyarũkika Tuᵽarãte kire imarũjeka. I'suᵽaka kibaaekaᵽi ba'iaja mabaaika waᵽa kiwaᵽakoyika simamaka “Ba'iaja nabaaikaᵽitiyika nimabesarãñu mae Yimakirirã imarĩ”, mareka Tuᵽarãte ãñu. ");
INSERT INTO tnc_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","Tuᵽarãte yijare jeyobaamaka kimajaroka wãrõrimaja imarĩ, ikuᵽaka mijare yija ãñu: “Mijare wayuĩabaraka, jia Tuᵽarãte mijare baaika simamaka jia kire ã'mitiriᵽẽarijaᵽaraka mija imabe. Kire mija yi'riᵽakiwã'imarĩa'si.” ");
INSERT INTO tnc_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","Mija ĩabe, kimajaroka o'oeka imaᵽi ikuᵽaka kẽrĩka: “Mijare yijeyobaarũkirĩmi seyaeka ᵽoto, mija jẽñerijayua ã'mitiritirã jia mijare yijeyobaaeka ba'iaja mija jũaekareka mija waᵽu'yaokaro'si”, ãrĩwa'ri sabojayu. Mija ã'mitiᵽe yija jeyomarã. Maekaka ᵽuri ᵽo'imajare ã'mitiritikaja, suᵽabatirã ba'iaja nabaaikareka nare tããerã imatikakiji Tuᵽarãte imarijayu. Suᵽa imarĩ maekaka ᵽuri, kire najẽñerãka uᵽakaja kibaarãñu. ");
INSERT INTO tnc_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","Kirika bojariroka wãrõtaᵽabaraka ba'iaja yija baabeyu, “Ᵽakirimajaroka nawãrõyu je'e”, ᵽo'imajare yijareka ãrĩa'si ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("C26_4","077_6_4","2CO","6","4","4","Suᵽa imarĩ “Rita sime, wãjia Tuᵽarãro'si ba'irabeĩjirimaja nime”, ᵽo'imajare ãñaokaro'si Tuᵽarãte yaᵽaika uᵽakaja baabaraka yija imarijayu. Suᵽa imarĩ ĩ'rãkurimarĩa ba'iaja aᵽerãte yijare baako'omakaja nare yija ruᵽuwaᵽae'ebeyu. I'suᵽakajaoka ba'iaja yija jũarijayu ᵽoto, sarekaja ᵽuᵽaᵽekaja Tuᵽarãte yaᵽaika uᵽakaja baabaraka yija ime. Mija ĩabe, ikuᵽaka sime ba'iaja yija jũarijayua: ");
INSERT INTO tnc_vpl VALUES ("C26_5","077_6_5","2CO","6","5","5","Yijare naᵽajerijayua, wẽkomaka imariwi'iarãoka ĩ'rãkurimarĩa yijare natatikoᵽeyu. Aᵽerikuri boebarã oyiaja rẽrĩtirã, ᵽiᵽerikaᵽi “Nare majããerã”, ãᵽaraka nakasererijayu. Suᵽabatirã rĩkimakaja ba'iraberika yijaro'si imamaka, jimarĩa aᵽerikuri yija rũrĩrijayu. I'suᵽakajaoka ñamiareka kãᵽekaja yija imarijayua, aᵽerikuri ba'arika imabeyu ᵽotooka yija kẽsirabarijayu. ");
INSERT INTO tnc_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","Ritaja i'suᵽaka ima yija rakajeᵽããrijayua ĩawa'ri, “Rita sime Tuᵽarãte yaᵽaika uᵽakaja Ᵽablorãkare baarijayu”, ᵽo'imajare yijareka ãñu. I'suᵽaka simamaka, jiiᵽuᵽarã imarĩ, jiirokaᵽi yija imarijayu. I'suᵽakajaoka jia Tuᵽarãrika bojariroka õñurã yija ime. Suᵽabatirã yija yaᵽabeyua ᵽo'imajare yijare baako'omakaja sayija rakajeᵽããrijayu. Tuᵽarãte yaᵽaika uᵽakaja baairã imarĩ, jia ᵽo'imajare wayuĩawa'ri, nare yija jeyobaayu. Esᵽíritu Santore yijareka ña'rĩjãika imarĩ, kirikaᵽi jia yijare kijeyobaarijayu. I'suᵽakajaoka ᵽakirimarĩa, ᵽo'imajare wayuĩairã imarĩ, jia nare yija baarijayu. ");
INSERT INTO tnc_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","Tuᵽarãte yijare jeyobaaikaᵽi kimajaroka bojaika uᵽakaja sayija wãrõrijayu kiyaᵽaika uᵽakaja simaokaro'si. I'suᵽaka kirika bojariroka yija wãrõrijayu ᵽoto, jia yija imamaka ĩawa'ri “Jiᵽuᵽairã imarĩ, rita yijare nabojayu”, narĩrãñu. ");
INSERT INTO tnc_vpl VALUES ("C26_8","077_6_8","2CO","6","8","8","Ĩ'rãrimarã imarã yijare jiyiᵽuᵽayeeirã, aᵽerimarã ᵽuri jẽno'o. I'suᵽakajaoka ĩ'rãrimarã “Jia baarijayurã nime”, ãñurã imariᵽotojo, aᵽerã ᵽuri i'suᵽaka ãrĩbeyurã. Tuᵽarãte ᵽũataekarã yija imako'omakaja “Waᵽuju ᵽakirimaja nime”, ĩ'rãrimarãre yijareka ãrĩkoᵽeyu. ");
INSERT INTO tnc_vpl VALUES ("C26_9","077_6_9","2CO","6","9","9","Rĩkimarãjaoka nime yijare õrĩriᵽotojo, “Ba'iratarã nime”, yijareka ãñurã. “Reyarũkirãja nime”, yijareka narĩko'omakaja, õñia yija ime ruᵽu. I'suᵽakajaoka jimarĩa ba'iaja yijare nabaaika simako'omakaja reyabeyukajirã yija ime ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("C26_10","077_6_10","2CO","6","10","10","I'suᵽaka simamaka aᵽerikuri jimarĩa ba'iaja ᵽuᵽariᵽotojo Maiᵽamakire jia yijare baarijayua ᵽuᵽajoawa'ri jĩjimaka yija imarijayu. I'suᵽakajaoka wayuoka baairã imariᵽotojo Tuᵽarãrika bojariroka yija wãrõikaᵽi ãrĩwa'ri rĩkimarã jia Tuᵽarãte nare baarũkiakaka natõᵽoyu. Maekaka dakomarĩrã yija imako'omakaja Jesúrirã yija imamaka, ritaja jia oyiaja kirika Tuᵽarãte yijare ja'atayu. ");
INSERT INTO tnc_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","Mija ã'mitiᵽe yija jeyomarã, Corintowejeakarã. Ritaja yija ᵽuᵽajoaika ya'erimarĩaja mijare yija bojayu, mijare wayuĩatiyairã imarĩ. ");
INSERT INTO tnc_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","I'suᵽaka mijaka yija imako'omakaja mija ᵽuri rakajerimakiji yijaka imarã. ");
INSERT INTO tnc_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","Ĩ'rĩka kimakarãte wãtawa'ri naka kijaika uᵽaka mijare yija bojarijayu. Suᵽa imarĩ ba'iaja imabekaja mijare yija wayuĩaika uᵽakaja yijare mija wayuĩabe mijaro'sioka. ");
INSERT INTO tnc_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","Cristore yi'ribeyurãka rĩrãkibiritiirã mija ima'si. Tuᵽarãte yaᵽaika uᵽaka baairã, ba'iaja baarijayurãᵽitiyika ĩ'rãtiji ᵽuᵽajoabaraka imawãrũberijĩrã. Mia je'e i'siroka morĩwãrũokaro'si sime neirõ'õ boirõ'õka rukubaka imaberijĩka ãñua. ");
INSERT INTO tnc_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","I'suᵽakajaoka, Cristo majamaki imarĩ, kika ĩ'rãtiji ᵽuᵽajoawãrũbeyuka kime Satanás. I'suᵽakajaoka Cristore yi'yurã kire yi'ribeyurãka ĩ'rãtiji ᵽuᵽajoabaraka imawãrũbeyurã. ");
INSERT INTO tnc_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","Naᵽuᵽaka nare ãñu uᵽakaja ᵽuᵽajoatirã waᵽuju imaja jẽrãka nabaaeka jiyiᵽuᵽaka noñua Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã imaberiri imakoᵽeika. I'suᵽakajaoka sime maro'si. Tuᵽarã õñia imajiᵽaki maᵽuᵽakarã ña'rĩjãitikarã imarĩ, i'suᵽaka waᵽuju ima jiyiᵽuᵽayeerãka jeyoaritiyabekaja maimaye'e. Mia, Tuᵽarãja ikuᵽaka bojaekaki kimajaroᵽũñurã: “Yire yi'yurã ᵽuᵽakareka ñimajiᵽarãñu. Nimarõ'õᵽiji naka ñimarijarirãñu. Suᵽa imarĩ najiyiᵽuᵽayeerũkika ñimarãñu. I'suᵽakajaoka yirirã nimarãñu naro'si”, ãrĩwa'ri sabojayu kimajaroᵽũñurã. ");
INSERT INTO tnc_vpl VALUES ("C26_17","077_6_17","2CO","6","17","17","Ikuᵽaka kẽñu aᵽea: “Yirika yi'ribeyurãka ĩ'rãtiji ᵽuᵽakirã mija ima'si. Suᵽabatirã nare mija jeyoaritiya'si, yiyaᵽabeyu uᵽaka naka mija baakoreka. Ñañu uᵽakaja mija baarãkareka, yirirã mija imamaka, jĩjimaka mijaka ñimarãñu”, mare kẽñu. ");
INSERT INTO tnc_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","“I'suᵽaka mijare yibaarãñu Mijaᵽaki uᵽaka imawa'ri. I'suᵽaka mijare yibaamaka yimakarã mija imarãñu”, ãrĩwa'ri kibojayu Maiᵽamaki ritaja tẽrĩwa'ribaji imatiyaiki. ");
INSERT INTO tnc_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","Mija ã'mitiᵽe yija jeyomarã. I'suᵽaka Tuᵽarãte mare bojaeka maro'siji ima. Suᵽa imarĩ Tuᵽarãte ĩaika wãjitãji ba'iaja baariyaᵽaberiwa'ri kiyaᵽabeyua, suᵽabatirã maᵽuᵽajoaika uᵽakaja baabekaja maimaye'e. Ritaja i'suᵽaka imarijayua ja'atatirã, Tuᵽarãte oyiaja jiyiᵽuᵽayeewa'ri, kiyaᵽaika uᵽakaja baabaraka maimaye'e. ");
INSERT INTO tnc_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","Yija jeyomarã, yijare mija wayuĩabe. “Ba'iaja baairã nime”, ĩ'rãrimarãre yijareka ãrĩko'omakaja, nirãreoka yija yaᵽaika uᵽaka ba'iaja baaberaᵽarã yija. I'suᵽakajaoka aᵽerãte ba'iaja baarũjekoribeyurã yija ime. Suᵽabatirãoka yijaro'si niñerũ tõᵽorika yaᵽawa'riji ᵽo'imajare waᵽuju ᵽakiberaᵽarã yija. ");
INSERT INTO tnc_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","“I'suᵽaka yijareka jairã mija ime”, ãrĩwa'rimarĩa mijare sayibojayu. Koᵽakaja jimarĩa mijare yija wãtatiyayu bikija mijare ñarĩtiraᵽe. I'suᵽaka simamaka, mijaka yija imarijayua, yija reyarãñu rõ'õjĩrãrãja mijare yija wayuĩarija'atabesarãñu. ");
INSERT INTO tnc_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","I'suᵽaka simamaka, “Nare yibojaika uᵽakaja yire nayi'rirãñu”, mijareka ñarĩᵽuᵽajoayu. “Jia Tuᵽarãte yaᵽaika uᵽakaja baairã nime Corintowejeakarã”, ãrĩᵽuᵽajoawa'ri jĩjimaka mijaka ñime. Suᵽa imarĩ ba'iaja yija jũarijayua simako'omakaja jiitakaja yiᵽuᵽayu. ");
INSERT INTO tnc_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","Tróaderõ'õᵽi Macedonia ka'iarã yija etaraᵽaka be'erõ'õ ĩ'rãkurioka jiiᵽañaka jẽrĩtakoribeyukajirã yija imaraᵽe. I'suᵽakajaoka yija eyairõ'õ rakakaja ba'iaja oka yijare imarijariroyiraᵽaka. I'suᵽaka simamaka, jimarĩa tokarãre yijaka okabojiroyiraᵽe. Ba'iaja ᵽuᵽaririka yijaro'si simarijariroyiraᵽe aᵽea. ");
INSERT INTO tnc_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","I'suᵽaka yijaro'si simarijariroyiraᵽaka simako'omakaja Titore yija ᵽõ'irã etamaka jia yija ᵽuᵽaraᵽe. Ba'iaja ᵽuᵽarijayurãte okajãjia imarũjeiki imarĩ, Tuᵽarãte yijare jeyobaaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","Titore õ'õrã etaraᵽakaᵽi takaja ãrĩwa'rimarĩa jĩjimaka yija ime. Mija ᵽõ'irã kimaraᵽaka ᵽoto, jia mija imamaka kĩaraᵽaka imarĩ jĩjimakaᵽi õ'õrã ketaraᵽe. Saᵽi ãrĩwa'ri jĩjimaka yija ime yijaro'sioka. Ikuᵽaka Titore yijare bojaetaraᵽe: “ ‘Ba'iaja yija ima ã'mitiritirã Ᵽablote ba'iaja ᵽuᵽayu’, ãrĩwa'ri i'suᵽakajaoka Corintokarãre ime naro'si. Suᵽa imarĩ jimarĩa mire niariyaᵽayu. Suᵽabatirãoka mire wãtawa'ri miyaᵽaika uᵽakaja nabaarijayu”, ãrĩwa'ri kibojaetaraᵽe. Sã'mitiritirã, tẽrĩwa'ribaji jĩjimaka ñime mae. ");
INSERT INTO tnc_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","Suᵽabatirã bikija ᵽaᵽera mijare yiᵽũataraᵽaka ĩatirã ba'iaja mija ᵽuᵽaraᵽakakaka ña'mitiraᵽe. I'suᵽaka simako'omakaja “I'sia ᵽaᵽera yiᵽũataberiri imakoᵽeraᵽe”, ãrĩᵽuᵽajoabeyuka yi'i. Ᵽaᵽera mijare yiᵽũataraᵽaka ᵽoto “Sĩatirã ba'iaja naᵽuᵽarirãñu je'e”, ñarĩᵽuᵽajoakoᵽeraᵽe. I'suᵽaka simako'omakaja, ba'iaja mija ᵽuᵽaraᵽaka ñojimarĩji mijareka so'raᵽe. ");
INSERT INTO tnc_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","Suᵽa imarĩ sĩatirã ba'iaja mija ᵽuᵽayuaᵽi ãrĩwa'rimarĩa jĩjimaka ñime. Ikuᵽaka sime ã'mitirikõrĩ je'e: “Ba'iaja baarika ja'atatirã Tuᵽarãte yaᵽaika uᵽaka oyiaja nabaarijayu mae”, kẽrĩetaraᵽaka ã'mitiriwa'ri jĩjimaka ñime. I'suᵽaka simarika Tuᵽarãte yaᵽamaka i'suᵽaka mijaro'si simaraᵽe. Suᵽa imarĩ jiaro'si imaraᵽakaja ba'iaja mija ᵽuᵽarika simamaka, “Yija ᵽaᵽeraᵽi ba'iaja nare yija baaberaᵽe”, yija ãrĩᵽuᵽajoayu. ");
INSERT INTO tnc_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","Ba'iaja mabaaika ĩatirã ba'iaja Tuᵽarãte mare ᵽuᵽarirũjeyu. I'suᵽaka kibaamaka, saja'atatirã kiyaᵽaika uᵽaka oyiaja mabaaokaro'si i'suᵽaka mare kibaayu. I'suᵽaka simamaka ba'iaja mabaaika ye'kariatirã, tĩmarĩji mare kibaarũkia imareka mare sakitããyu. Saᵽi ãrĩwa'ri ba'iaja ᵽuᵽarijaribeyurã maime. Toᵽi Tuᵽarãte yi'ribeyurã ᵽuri, ba'iaja nabaaikareka ba'iaja ᵽuᵽariᵽotojo “Sayija ja'ataerã yijare miwayuĩabe”, Tuᵽarãte ãrĩbeyurã. Suᵽa imarĩ kiᵽõ'irã a'rirũkimarĩrã nime. ");
INSERT INTO tnc_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","Ã'mitirikõrĩ je'e. Tuᵽarãte yaᵽaika uᵽaka mijaro'si yo'oraᵽaka ĩatirã, ba'iaja mija ᵽuᵽaraᵽe. I'suᵽaka imariᵽotojo jia yijaka imariyaᵽawa'ri ñojimarĩji ikuᵽaka mija jaraᵽe: “I'tojĩrãja, ba'iaja mibaarijayua mija'atabe”, mija watoᵽekareka imakite mija ãrãᵽe. Suᵽabatirã “¿Dako baaerã ñoaitakaja ‘Sareka kimaᵽarũ’, ãrĩrũjeirã uᵽaka mabaaraᵽe jee?”, ãᵽaraka i'yoᵽiyurã mija jaraᵽe. “Ñojimarĩji oka yija jiebeririᵽareaja, tĩmarĩji Tuᵽarãte yijare baarãñu je'e”, mija ãrĩᵽuᵽajoaraᵽe. I'suᵽaka imarã imarĩ yire jiyiᵽuᵽaka õrĩwa'ri jimarĩa yire mija ĩariyaᵽayu. Suᵽa imarĩ mija watoᵽekarã ba'iaja baaraᵽakite tĩmarĩji mija baaraᵽe ki'yoᵽiyaokaro'si. Suᵽa jia baaraᵽarã mija imamaka dakoa oka imabeyua mijaro'si mae. ");
INSERT INTO tnc_vpl VALUES ("C27_12","077_7_12","2CO","7","12","12","I'suᵽaka mija baarũkiakaka mijaro'si yo'oraᵽaka simako'omakaja ba'iaja baaraᵽakite, suᵽabatirãoka sajũarimajire takaja ᵽuᵽajoawa'rimarĩa sayo'oraᵽe. Tuᵽarãte ĩaika wãjitãji “Rita, jia Ᵽablote majiyiᵽuᵽayeeyu”, ãñurã mija jayaokaro'si mijaro'si sayo'oĩjiraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","Suᵽa imarĩ yiᵽaᵽera ĩatirã jia yire mija yi'yua ã'mitiritirã okajãjia yija jayu. Suᵽabatirã, jaibaraka mijaka Titore imaraᵽaka simamaka, jia ᵽuᵽayuka kime mae. Jĩjimaka kimamaka ĩawa'ri, tẽrĩwa'ribaji jĩjimaka yija jayu mae. ");
INSERT INTO tnc_vpl VALUES ("C27_14","077_7_14","2CO","7","14","14","Mija ᵽõ'irã ke'rirã baaraᵽaka ᵽoto “Jia mire e'etoritirã, Corintokarãre mire yi'rirãñu”, Titore ñarĩtiraᵽe. Kire ñarãᵽaka uᵽakaja mija baaraᵽe. Suᵽa imarĩ dikaᵽi ãrĩwa'ri kirokaᵽi i'yoᵽi'ribeyuka yi'i mae. “Jia mire nabaarãñu”, ãrĩwa'ri Titore yija bojaraᵽaka rita kire yija ãrãᵽe mirãkiyu. I'suᵽakajaoka ĩ'rãkuri uᵽakaja mijare yija bojaraᵽaka rita simaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C27_15","077_7_15","2CO","7","15","15","Jia kika imarika yaᵽawa'ri jiyiᵽuᵽakaᵽi kire mija e'etoraᵽe. Suᵽabatirã jiajaoka kire mija yi'raᵽe. Ritaja i'suᵽaka kire mija baaeka mirãka ᵽuᵽajoabaraka jiibaji mijare kiwayuĩarijayu mae. ");
INSERT INTO tnc_vpl VALUES ("C27_16","077_7_16","2CO","7","16","16","Suᵽa imarĩ “Tuᵽarãte yaᵽaika uᵽaka oyiaja baabaraka nimarãñu”, ãᵽaraka jĩjimaka mijaka ñime mae. ");
INSERT INTO tnc_vpl VALUES ("C28_1","077_8_1","2CO","8","1","1","Mija ã'mitiᵽe yija jeyomarã. Ritaja Macedoniakarã Jesúre yi'yurã majaroka mijare yija bojaerã baayu. Nare wayuĩawa'ri jia Tuᵽarãte nare jeyobaaika uᵽakajaoka aᵽerãte jia oyiaja nabaarijayu naro'si. ");
INSERT INTO tnc_vpl VALUES ("C28_2","077_8_2","2CO","8","2","2","Rĩkimakaja ba'iaja aᵽerãte nare ka'wisijũarũjeko'omakaja jĩjimaka nime. Suᵽabatirã wayuokatakaja baairã imariᵽotojo aᵽerãte jeyobaarika ᵽuᵽajoawa'ri rĩkimarãja niñerũ narẽaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C28_3","077_8_3","2CO","8","3","3","I'suᵽaka jĩjimakaᵽi narẽaraᵽaka yiñakoaᵽi ñiaraᵽaka simamaka, “Rita sime”, ñañu. Nijirũkia imarõ'õjĩrãja ĩjiriᵽotojo wayuoka baairãte wayuĩawa'ri, narikataka tuikoᵽeikakaka ᵽariji nare nijiraᵽe. Nare sayijẽñeberiko'omakaja wayuoka baairãte jeyobaawa'ri niñerũ yire nijiraᵽe naᵽõ'irã saye'ewa'yaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("C28_4","077_8_4","2CO","8","4","4","“Jesúre yi'yurã wayuoka baairã Jerusalénreka imarãte yija jeyobaayu. Suᵽa imarĩ ika niñerũ naro'si mija e'ewa'ᵽe”, ãᵽaraka yijare sanaja'ataraᵽe, nare jeyobaatiyawa'ri. “I'suᵽaka nare jeyobaatirã jĩjimaka yija imarãñu”, ãrĩwa'ri i'suᵽaka nabaaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C28_5","077_8_5","2CO","8","5","5","“Õ'õjĩrãja najeyobaakoᵽejĩka marã imabeyua”, yija ãrĩᵽuᵽajoaraᵽe sanarẽaerã baaraᵽaka ruᵽu. I'suᵽaka yija ᵽuᵽajoaraᵽaka simako'omakaja satẽrĩwa'ribaji jia nabaaraᵽe. Sanarẽaerã baaeka ikuᵽaka narãᵽe mamarĩ: “Jesús, yija ĩᵽamaki, miyaᵽaika uᵽakaja yija baarãñu.” Suᵽabatirãoka Tuᵽarãte yaᵽaika uᵽakaja baairã imarĩ, “Yijare mija bojarãka uᵽakaja yija yi'rirãñu”, narãᵽe yijareoka. ");
INSERT INTO tnc_vpl VALUES ("C28_6","077_8_6","2CO","8","6","6","Suᵽa imarĩ mijaro'sioka jĩjimakaᵽi niñerũ rẽabaraka mija ima e'ebaraka Titore imaerã torã kire yija ᵽũataraᵽe. Ikijioka imaki mamarĩtaka niñerũ rẽarikakaka mijare jaiũ'muraᵽaki. I'suᵽakajaoka jĩjimakaᵽi samija rẽaweaerã “Nare kijeyobaarũ”, ãrĩwa'ri mija ᵽõ'irã kire yija ᵽũataraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C28_7","077_8_7","2CO","8","7","7","Suᵽa imarĩ tẽrĩwa'ribaji Tuᵽarãrikakaka jia õñurã imarĩ, i'suᵽaka jia tokarãre mija jeyobaabe. I'suᵽakajaoka “Rita ãñuka kime”, ãrĩwa'ri, Jesucristore oyiaja jia mija yi'ririjayu. Suᵽabatirã kirika bojariroka õñurã imarĩ, jia samija bojawãrũyu. I'suᵽaka baabaraka jimarĩa ᵽo'imajare jeyobaairã mija ime. Suᵽabatirãoka yijare jia wãtatiyairã mija ime. Suᵽa imarĩ wayuoka baairãte tẽrĩrikaja wayuĩawa'ri jia nare mija jeyobaabe. ");
INSERT INTO tnc_vpl VALUES ("C28_8","077_8_8","2CO","8","8","8","Mijare jã'merimarĩa sime, bojarika simamaka i'suᵽaka ñañu. “Jerusalénreka imarãte yija jeyobaarãñu”, ãrĩwa'ri Macedoniakarãre yijare ãrãᵽaka mija õrĩrika yaᵽawa'ri mijare sayibojayu. Sã'mitiritirã “Maro'sioka nare majeyobaaerã”, mija ãrĩrika yaᵽawa'ri i'suᵽaka mijare yibojayu. I'suᵽaka nare mija jeyobaamaka ĩatirã, “Ritaoka aᵽerãte wayuĩairã nime”, mijareka ñarĩwãrũrãñu. ");
INSERT INTO tnc_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","“Jia mare baaiki kime maiᵽamaki Jesucristo”, ãrĩwãrũirã imarĩ, wayuoka baairãte jeyobaarika ᵽuᵽajoairã mija imabe. Tuᵽarãte imarõ'õrã tẽrĩwa'ribaji imatiyaiki imariᵽotojo mijare wayuĩawa'ri saja'atatirã ᵽo'imaji kiᵽo'ijirika. Ika ka'iarã kimariᵽareaja wayuoka baaiki uᵽaka kimaeka. I'suᵽaka kimaeka, jia Tuᵽarãka dakoa jariwa'ririmarĩaja mija imaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("C28_10","077_8_10","2CO","8","10","10","Jia mija imarika yaᵽawa'ri mijare yokajããerã baayu. Bikija o'raᵽajẽ'rãrã mija baaũ'muraᵽakarã ate mija ᵽuᵽajoarika yiyaᵽayu. “Wayuoka baairãte majeyobaaerã”, ãrĩwa'ri aᵽerã ruᵽubajirã jĩjimakaᵽi niñerũ mija rẽaũ'muraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C28_11","077_8_11","2CO","8","11","11","Mamarĩ jĩjimakaᵽi samija baaũ'mutiraᵽaka uᵽakajaoka mija rikaikarõ'õjĩrãja ĩjibaraka jĩjimakaᵽiji samija rẽawearika yiyaᵽayu. ");
INSERT INTO tnc_vpl VALUES ("C28_12","077_8_12","2CO","8","12","12","Marikaika ko'aᵽitorãja maijijĩka jia sime. Jeyobaarika yaᵽawa'ri sakĩjika simamaka ĩ'rãtiji oyiaja sime Tuᵽarãro'si. Marikaika tẽrĩwa'ribaji mare jẽñebeyuka kime Tuᵽarã. ");
INSERT INTO tnc_vpl VALUES ("C28_13","077_8_13","2CO","8","13","13","Mija rikaika ᵽemawa'ribajirã aᵽerãte jeyobaatirã wayuoka mija baaerãmarĩa i'suᵽaka mijare ñañu. Ĩ'rãtijiji mija imaokaro'si i'suᵽaka mijare ñañu. ");
INSERT INTO tnc_vpl VALUES ("C28_14","077_8_14","2CO","8","14","14","Mija ᵽuri maekaka wayuoka nabaaika ᵽoto rĩkimakaja mija rikayu. I'suᵽaka simamaka nare mija jeyobaabe. Ñamajĩ wayuoka mija baarãka ᵽoto ĩ'rã ate rĩkimakaja rikarãñurã je'e aᵽeyari. I'suᵽaka simajĩkareka mijare najeyobaarãñu. Suᵽa baawa'ri ĩ'rãtiji rikaokaro'si jia mija jeyobaabu'arãñu. ");
INSERT INTO tnc_vpl VALUES ("C28_15","077_8_15","2CO","8","15","15","I'suᵽakajaoka Tuᵽarã majaroᵽũñurã Moisés imaroyikakite bojaeka ikuᵽaka ãñua: “Rĩkimakaja maná ayeekarã, kũᵽajĩ ayeekarãte sanaᵽibaeka. Suᵽa imarĩ kũᵽajĩ ayekoᵽekarãro'si nayaᵽaeka uᵽakaja simaeka, suᵽabatirã rĩkimaka ayeekarãro'sioka saᵽiyia tuiberika”, ãrĩwa'ri sabojayu. ");
INSERT INTO tnc_vpl VALUES ("C28_16","077_8_16","2CO","8","16","16","Mijare yijeyobaariyaᵽaika uᵽakajaoka Titore mijare jeyobaariyaᵽayu kiro'si. Tuᵽarãte i'suᵽaka kire ᵽuᵽajoarũjeka simamaka “Jia mibaayu Tuᵽarã”, kire ñañu. ");
INSERT INTO tnc_vpl VALUES ("C28_17","077_8_17","2CO","8","17","17","“Nare jeyobaaokaro'si naᵽõ'irã me'ᵽe ate”, kire ñaᵽakã'ã, jia jĩjimakaᵽi Titore yire yi'raᵽe. I'suᵽaka kire ñarĩbeyukajikã'ãja, jimarĩa mija ᵽõ'irã a'ririyaᵽatikiji kimaraᵽe. Suᵽa imarĩ kiyaᵽaika uᵽakaja mijare ĩarĩ ke'rirã baayu mae. ");
INSERT INTO tnc_vpl VALUES ("C28_18","077_8_18","2CO","8","18","18","Titoka ĩ'rĩka majeyomakite mija ᵽõ'irã yija ᵽũatayu. Mija õñuka imarĩ, Jesucristorika bojariroka jia bojawaᵽu'atawãrũiki kimamaka ritaja Jesucristore ã'mitiriᵽẽairã jia jiyiᵽuᵽaka kire noñuka kime. ");
INSERT INTO tnc_vpl VALUES ("C28_19","077_8_19","2CO","8","19","19","Ñamajĩ Corintoᵽi niñerũ yija e'ewa'rirãka ᵽoto, Jerusalénrã yijaka ke'rirã kire naᵽũataraᵽe. Torã eyatirã wayuoka baairãte jeyobaawa'ri niñerũ yija ĩjirãñu. I'suᵽaka yija baamaka ĩatirã, “Ritaoka wayuoka baairãte jeyobaairã nime Jesúre yi'yurã”, yijareka ᵽo'imajare ãrĩᵽuᵽajoarãñu. I'suᵽaka imawa'ri maiᵽamaki Jesucristore najiyiᵽuᵽayeerãñu. ");
INSERT INTO tnc_vpl VALUES ("C28_20","077_8_20","2CO","8","20","20","“Rĩkimakaja niñerũ narẽaraᵽaka jia naba'iaribeyu”, ãrĩwa'ri yijareka nakẽrãjairika yaᵽabeyurã yija. I'suᵽaka simakoreka ĩ'rĩka yijaka a'rirũkika imatiiki. ");
INSERT INTO tnc_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","Ba'iaja yijare nakẽrãjairika yaᵽaberiwa'ri jia oyiaja Tuᵽarãte ĩaika wãjitãji yija baarãñu. Suᵽabatirã ᵽo'imajare ĩaika wãjitãji i'suᵽakajaoka yija baarãñu. ");
INSERT INTO tnc_vpl VALUES ("C28_22","077_8_22","2CO","8","22","22","Suᵽabatirã imaki aᵽika majeyomaki mija ᵽõ'irã naka yiᵽũataerã baaiki ate. Kire õñurã imarĩ, “Jia ba'irabeiki kime”, yija ãñu. Ĩ'rãkurimarĩa jia jeyobaatiki kimamaka i'suᵽaka yija ãñu. “Jia yi'yurã nime Corintowejeakarã”, Titore ãᵽakã'ã ã'mitiritirã mijare jeyobaarĩ ke'ririyaᵽatiyayu mae. ");
INSERT INTO tnc_vpl VALUES ("C28_23","077_8_23","2CO","8","23","23","Suᵽa imarĩ Titore, aᵽerã ĩ'ᵽarã majeyomarãᵽitiyika mija ᵽõ'irã yiᵽũatarãñu. Jia Titore õñurã mija ime. Yijeyomaki imarĩ, yuᵽakaja mijare kiwãrõrijayu. Kika ĩ'ᵽarã nime aᵽerã majeyomarã jia Jesúre yi'yurã. “Jia Jesucristore nayi'yu”, ãrĩwa'ri Macedoniakarãre kika ᵽũataekarã nime. I'suᵽaka nimamaka ĩatirã jia Cristore jiyiᵽuᵽaka noñu nimauᵽatiji. ");
INSERT INTO tnc_vpl VALUES ("C28_24","077_8_24","2CO","8","24","24","Mija ᵽõ'irã neyarãka ᵽoto jia nare mija e'etorika yiyaᵽayu. I'suᵽaka mija baamaka, “Ritaoka nare yaᵽairã nime”, Macedoniakarãre ãrĩᵽuᵽajoarãñu. I'suᵽaka simamaka “ ‘Corintokarãre jia nare e'etorirãñu’, Ᵽablote yijare ãrãᵽaka rita sime”, narĩᵽuᵽajoarãñu. ");
INSERT INTO tnc_vpl VALUES ("C29_1","077_9_1","2CO","9","1","2","“Jesucristore yi'yurã wayuoka baairãte jeyobaaokaro'si jiaᵽi niñerũ narẽayu”, mijareka ãñuka imariᵽotojo mijaro'si sakaka yo'oerã baayu ruᵽu. Acayaka'iareka Corintorã imarãte bikija o'raᵽajẽ'rã wayuoka baairãte mija jeyobaarika ᵽuᵽajoaũ'muraᵽakakaka jĩjimakaᵽi õ'õrã Macedoniaka'iakarãre yibojarijayu. I'suᵽaka yibojaika ã'mitiritirã jĩjimaka jariwa'ri “Maro'sioka i'suᵽakaja wayuoka baairãte majeyobaaye'e”, ãᵽaraka rĩkimarãja Macedoniaka'iakarãoka jĩjimakaᵽi niñerũ ĩjiriyaᵽairã. ");
INSERT INTO tnc_vpl VALUES ("C29_3","077_9_3","2CO","9","3","4","I'suᵽaka mijare ãrĩriᵽotojo yiruᵽurõ'õ Titorãkare mija ᵽõ'irã yiᵽũataweiyu niñerũ rẽaweirika mijare najeyobaaokaro'si. Ĩ'rãrimarã Macedoniakarãre yika jeyoariwa'rirãñu je'e aᵽeyari. I'suᵽaka simamaka Titorãkare mijare jeyobaarãñu “ ‘Rita sime wayuoka baairãte jeyobaaokaro'si niñerũ rẽaweatikarã nimatiyu’, yijare merãᵽaka simako'omakaja, niñerũ narẽaweabeyu ruᵽu”, Macedoniakarãre yija eyarãka ᵽoto yijare ãrĩkoreka. “Jia wayuoka baairãte jeyobaarika yaᵽairã nime”, aᵽerãte yija ãñua simako'omakaja i'suᵽaka mija baabesarãkareka nawãjitãji i'yoa yija jũarãñu. Suᵽabatirã i'suᵽakajaoka mija jũarãñu je'e mijaro'sioka. ");
INSERT INTO tnc_vpl VALUES ("C29_5","077_9_5","2CO","9","5","5","I'suᵽaka simakoreka “Yiruᵽu a'riweitirã nare mija jeyobaaweiaᵽe”, ãrĩwa'ri majeyomarã Titorãkare mija ᵽõ'irã yiᵽũataweiyu. Niñerũ mija rẽaũ'muraᵽaka mija rẽaweaokaro'si mijare najeyobaarãñu. Suᵽa imarĩ torã yeyarãka ᵽoto, sarẽaweatika mija imarãñu. Suᵽabatirãoka “Ñojimarĩji samaĩjirika Ᵽablote ᵽakatayu”, ãrĩrika imabesarãka. Jia wayuoka baairãte jeyobaariyaᵽawa'ri jĩjimakaᵽi mija ĩjirijarirãkareka jia simarãñu. ");
INSERT INTO tnc_vpl VALUES ("C29_6","077_9_6","2CO","9","6","6","Nare ĩjirã baaeka ikuᵽaka mija ᵽuᵽajoabe: Rĩkimaka ba'arika õtebeyuka kũᵽajĩji ba'arika rikaiki. Rĩkimaka ba'arika õteriᵽuᵽaiki ᵽuri rĩkimakaja ba'arika rikaiki. Ikuᵽaka ãrĩrika sime samarĩjĩkareka: Rita jia wayuoka baairãte jeyobaarika yaᵽawa'ri ĩjirijayukate jia Tuᵽarãte jeyobaarãñu. Kirikaika wãtariᵽotojo kũᵽajĩ ĩjikite ᵽuri kũᵽajĩ sawaᵽa Tuᵽarãte ĩjirãñu. ");
INSERT INTO tnc_vpl VALUES ("C29_7","077_9_7","2CO","9","7","7","Suᵽa imarĩ “Õ'õjĩrãja yija ĩjirãñu”, mija ãrĩᵽuᵽajoairõ'õjĩrãja mija ĩjirijaᵽe. Wãtariᵽotojo mija ĩjijĩkareka ᵽuri jiamarĩa simajĩñu. Suᵽabatirã mija ĩjiriyaᵽaberiko'omakaja aᵽikate mijare ᵽakataᵽakã'ã ã'mitiritirã, mija ĩjijĩkaoka jiamarĩa sime. Mija ᵽuᵽakarãja ĩjirika yaᵽawa'ri mija ĩjijĩka ᵽuri jia sime. Jĩjimakaᵽi aᵽerãte jeyobaarijayurãka jĩjimaka Tuᵽarãte ime. ");
INSERT INTO tnc_vpl VALUES ("C29_8","077_9_8","2CO","9","8","8","I'suᵽaka simamaka mija yaᵽaika ᵽemawa'ribaji mijare kija'atarãñu jia aᵽerãte mija jeyobaarijayaokaro'si. Jia nare mija baamaka ĩatirã mijare kija'ataika ĩ'rãkuri uᵽakaja dakoa jariwa'ribesarãka mijaro'si. ");
INSERT INTO tnc_vpl VALUES ("C29_9","077_9_9","2CO","9","9","9","Mija ĩabe. Ikuᵽaka sãñu Tuᵽarã majaroᵽũñurã o'oeka: “Tuᵽarãte jiyiᵽuᵽayeeiki imaki kirikaika wãtarimarĩaja wayuoka baairãte jeyobaarijayuka. Suᵽa imarĩ jia kibaaeka mirãka ye'karirimarĩaja jia Tuᵽarãte kire baajiᵽarãñu”, ãrĩwa'ri sabojayu. ");
INSERT INTO tnc_vpl VALUES ("C29_10","077_9_10","2CO","9","10","10","Tuᵽarã imaki õterikiyaᵽea moterũkia maro'si imarũjerijayuka. Ikijioka imaki õterikiyaᵽeaᵽi ba'arika ᵽo'imajare imaokaro'si baarijayuka. I'suᵽaka baaiki imarĩ, ritaja jia mijare kija'atarijayu, saᵽi aᵽerãte jia mija jeyobaarijayaokaro'si. I'suᵽaka mija jeyobaarijayuaᵽi ãrĩwa'ri rĩkimarãja aᵽerãte jia imarũjeiki kime Tuᵽarã. ");
INSERT INTO tnc_vpl VALUES ("C29_11","077_9_11","2CO","9","11","11","Suᵽabatirã dakoa jariwa'ririmarĩaja rikatirã jia aᵽerãte ĩ'rãkuri uᵽakaja mija jeyobaarũkia mijare kija'atarãñu. Suᵽa imarĩ torã eyatirã mija jeyobaaika nare yija ja'atarãka ᵽoto, “Jia mibaayu Tuᵽarã”, ãᵽaraka kire najiyiᵽuᵽayeerãñu. ");
INSERT INTO tnc_vpl VALUES ("C29_12","077_9_12","2CO","9","12","12","Ika mija ĩjikaᵽi jia majeyomarã Jerusalénrã wayuoka baairãte mija imarũjerũkitakajamarĩa simarãñu. Suᵽabatirãoka i'suᵽaka mija baaikaᵽi ãrĩwa'ri, “Jia mibaayu Tuᵽarã”, ãᵽaraka jiibaji kire najiyiᵽuᵽayeerãñu. ");
INSERT INTO tnc_vpl VALUES ("C29_13","077_9_13","2CO","9","13","13","I'suᵽaka mija baamaka, “Waᵽuju ᵽakibekaja ritaitaka Jesúrika bojariroka yi'yurã nime”, mijareka narĩᵽuᵽajoarãñu. Suᵽabatirã nare jeyobaatirã, i'suᵽakajaoka aᵽerãte mija jeyobaarãka simamaka, jia Tuᵽarãte najiyiᵽuᵽayeerãñu. ");
INSERT INTO tnc_vpl VALUES ("C29_14","077_9_14","2CO","9","14","14","Suᵽabatirãoka “Mare najeyobaaerã Tuᵽarãte nare jeyobaaraᵽakaᵽi, ãrĩwa'ri jia mare nabaayu”, narĩrãñu. I'suᵽaka simamaka “Jia yijare nabaayu”, ãrĩwa'ri jia jĩjimaitakaᵽiji Tuᵽarãte mijaro'si najẽñeĩjirijarirãñu. ");
INSERT INTO tnc_vpl VALUES ("C29_15","077_9_15","2CO","9","15","15","Jia nare baarũkirã mija ima ᵽuᵽajoatirã jĩjimaka ñime. I'sia tẽrĩwa'ribaji jia mare baawa'ri Kimakire Tuᵽarãte maro'si ᵽũataeka. Sõñurã imarĩ, dika aᵽea marãkã'ã ãrĩrika imabeyua maro'si. Suᵽa imarĩ maimauᵽatiji “Jiitaka mibaayu Tuᵽarã”, kire marĩrijariye'e. ");
INSERT INTO tnc_vpl VALUES ("C210_1","077_10_1","2CO","10","1","1","Yi'i Ᵽablo, oka mijaka jierika yaᵽaiki imarĩ, ika mijare yibojaerã baaika mija ã'mitiririka yiyaᵽayu. Ᵽo'imajare wayuĩarimaji imarĩ, jiaᵽiji Jesúre nare jairoyika uᵽakaja mijaka yijairiyaᵽayu yiro'si. Tokarã ĩ'rãrimarã ikuᵽaka yireka ãñurã: “Maka kima ᵽoto kĩkirimakiji maka Ᵽablote jairijayu. Aᵽerõ'õrã imatirã ᵽaᵽeraᵽi maro'si kio'oika ᵽoto ᵽuri okajãjiaᵽi maro'si sakio'oyu”, ãᵽaraka yireka najaiyuyerijayu. ");
INSERT INTO tnc_vpl VALUES ("C210_2","077_10_2","2CO","10","2","2","I'suᵽaka simamaka waᵽuju ba'iaja yireka jairãte mija ã'mitiritiya'si. Yire mija yi'ritiyabe, saᵽi ãrĩwa'ri mija ᵽõ'irã eyatirã okajãjia mijare yijaikoreka. I'suᵽaka mijare yijaiberikoᵽerãkaoka, “Jesucristore yi'ribeyurã uᵽaka Ᵽablote ime”, ãñurãte ᵽuri okajãjiaᵽi jairika yiᵽuᵽajoayu. ");
INSERT INTO tnc_vpl VALUES ("C210_3","077_10_3","2CO","10","3","3","Rita sime, mija uᵽakajaoka ᵽo'imaja yija ime yijaro'sioka. Jesucristore yi'ribeyurãka yija imarijayua simako'omakaja nimarijayu uᵽakataka baarijaribeyurã yija ime. I'suᵽaka simamaka, noñu uᵽakaja ᵽuᵽajoatirã ᵽo'imajare okabojirijayu uᵽakamarĩa ᵽakirimiji majaroka yija jaita'ruirijayu. ");
INSERT INTO tnc_vpl VALUES ("C210_4","077_10_4","2CO","10","4","4","Tuᵽarãte yi'ribeyurãte jia jaikoᵽeika uᵽakamarĩaja tẽrĩwa'ribaji Tuᵽarãrikaᵽi ᵽo'imajare yija wãrõrijayu. I'suᵽaka nare yija wãrõmaka, “Waᵽuju ᵽakirimiji majaroka yija yi'rikoᵽeyu rukuya”, ᵽo'imajare ãrĩwãrũrijayu. I'suᵽakajaoka ritaja ᵽakirimiji majaroka yi'yurãte yijare okae'emakaoka nare yija okatẽrĩrijayu sanaja'ataokaro'si. ");
INSERT INTO tnc_vpl VALUES ("C210_5","077_10_5","2CO","10","5","5","“Tuᵽarãrika jia wãjia imamiji ã'mitiritirã jia kire norĩrũ”, ãñurã imarĩ, jia naᵽuᵽajoakoᵽeikaᵽi wãrõrimajare yija okatẽrĩwãrũyu Tuᵽarãte jeyobaaikaᵽi. Suᵽabatirã “Aᵽerã jiibaji ᵽuᵽajoairã yija ime”, ãrĩᵽuᵽajoawa'ri, naᵽuᵽajoaimiji Tuᵽarãte nare õrĩrũjebeyua sime. Suᵽa imarĩ yija wãrõika yi'riwa'ri, naᵽuᵽaᵽe'yu. Suᵽabatirã Tuᵽarãte yijare jeyobaamaka, Cristore yaᵽaika uᵽaka oyiaja ᵽo'imajare yija ᵽuᵽajoarũjerijayu. ");
INSERT INTO tnc_vpl VALUES ("C210_6","077_10_6","2CO","10","6","6","Mija ᵽõ'irã yija eyarãka ᵽoto Jesucristore yaᵽaika uᵽakaja mija yi'rirãka jia simarãñu. Kire yi'ribesarãñurãte ᵽuri sawaᵽa yija yaᵽarãka uᵽakaja yija baarãñu. ");
INSERT INTO tnc_vpl VALUES ("C210_7","077_10_7","2CO","10","7","7","Mija ᵽõ'irã ima mija ĩawãrũbe: Ĩ'rãrimarã mija watoᵽekarã “Jesucristore ᵽũataekarã yija ime”, ãñurã. I'suᵽaka ãñurã imarĩ, “Ᵽablorãka Jesucristore ᵽũataekarãjaoka imarã naro'si”, narĩrũ. ");
INSERT INTO tnc_vpl VALUES ("C210_8","077_10_8","2CO","10","8","8","“Maiᵽamaki Jesucristore ᵽũataekarã imarĩ, mijare okajããbaraka yija wãrõyu”, ñañu. I'suᵽaka mijare ñaᵽakã'ã “ ‘Yire na'mitiriᵽẽarũ’, ãrĩwa'ri i'suᵽaka mare kẽñu”, yireka mija ãrĩᵽuᵽajoayu je'e. “Cristore mija yi'yua bitatarikoᵽakaja jiibaji Cristore mija yi'ririjayaokaro'si mijare yija jeyobaaerã, maiᵽamaki Jesucristore yijare ᵽũataraᵽe”, ñañu. I'suᵽaka simamaka “Cristore ᵽũataekakimarĩka Ᵽablote ime”, waᵽuju yireka ãñuaᵽi maki yire i'yoᵽi'rirũjewãrũbesarãki. ");
INSERT INTO tnc_vpl VALUES ("C210_9","077_10_9","2CO","10","9","9","“Makĩkirika yaᵽawa'ri ᵽaᵽeraᵽi okajãjia mare kijaiᵽũarijayu”, mija ãrĩᵽuᵽajoajĩkareka i'suᵽakamarĩa sime. ");
INSERT INTO tnc_vpl VALUES ("C210_10","077_10_10","2CO","10","10","10","Mija ĩabe. Ĩ'rãrimarã mija watoᵽekareka imarã yire jaiyuyebaraka, ikuᵽaka ãñurã: “Ᵽaᵽera mare kio'oikaᵽi okajãjia jairiᵽotojo maka kima ᵽoto ᵽuri wayuoka Ᵽablote baaroyi”, nañu. “Suᵽabatirãoka yijare kiwãrõroyika ᵽoto, ã'mitirijiyubeyua uᵽaka kijaikoᵽeroyi”, ãᵽaraka yire najaiyuyerijayu. ");
INSERT INTO tnc_vpl VALUES ("C210_11","077_10_11","2CO","10","11","11","I'suᵽaka yireka jairijayurã: “Maka kimabeyu ᵽoto ᵽaᵽeraᵽi okajãjia mare kijaika uᵽakajaoka maka kimarãka ᵽoto mare kibaarãñu je'e”, narĩrũ. ");
INSERT INTO tnc_vpl VALUES ("C210_12","077_10_12","2CO","10","12","12","I'suᵽaka simako'omakaja mija ᵽõ'irã ĩ'rãrimarã “Tẽrĩrirã marãkã'ã mabaaberijĩka yija ime”, naᵽuᵽarõ'õᵽi ãñurã. Suᵽabatirã “Aᵽerãte tẽrĩwa'ribaji Tuᵽarãro'si jairimaja yija ime”, ãñurã nime, i'suᵽakataka ãrĩrika ᵽe'yoiki yi'i ᵽuri. Natiyiaja nima ĩajiyutirã, i'suᵽaka narĩrijayu. I'suᵽaka naᵽuᵽaka imarã imarĩ, rukubaka naᵽuᵽajoayu. ");
INSERT INTO tnc_vpl VALUES ("C210_13","077_10_13","2CO","10","13","13","I'suᵽakajaoka “Ritaja ĩ'rãweje jariwa'ririmarĩaja ᵽo'imajare yija wãrõerã Tuᵽarãte yijare ᵽũataeka”, ãrĩbeyurã yija. Ikuᵽaka sime: Jesucristorika wãrõrimajamatorã Tuᵽarãte yijare ᵽũataeka imarõ'õ watoᵽekareka sime Corintowejea. Suᵽa imarĩ “Kijã'meikaᵽi mijare yija wãrõyu”, mijare yija ãrĩrijayua rita ima. ");
INSERT INTO tnc_vpl VALUES ("C210_14","077_10_14","2CO","10","14","14","Mijare yija wãrõmaka, “¿Dako baaerã Ᵽablorãkare mija ã'mitiyu?”, mijare narĩko'omakaja, nare ruᵽubajirã Jesúrika bojariroka mijare yija wãrõũ'muraᵽe. Mija ᵽõ'irã Tuᵽarãte yijare ᵽũataberirikareka ᵽuri, “Mijare wãrõirã yija ime”, mijare yija ãrĩberijããeka. I'suᵽakamarĩa sime. Mijare wãrõrimaja yija imaerã Tuᵽarãte mija ᵽõ'irã yijare ᵽũataeka. ");
INSERT INTO tnc_vpl VALUES ("C210_15","077_10_15","2CO","10","15","15","Suᵽabatirãoka ĩ'rãrimarãre jaikoᵽeika uᵽakamarĩa yija jaiyu. Aᵽerãte nare wãrõmaka Jesucristore ᵽo'imajare yi'yua ĩatirã “Nare yija wãrõmaka i'suᵽaka nime”, ãrĩᵽakirijaribeyurã yija. Ikuᵽaka yija yaᵽayu: Jia Jesucristore yi'yurã mija jarirãka rĩkimabaji ᵽo'imajare Jesúrika bojariroka yija bojarãñu. ");
INSERT INTO tnc_vpl VALUES ("C210_16","077_10_16","2CO","10","16","16","Suᵽa imarĩ i'suᵽaka simarãka ᵽoto mija a'riwa'ribajirã imarãte Jesucristorika bojariroka bojarĩ a'ririka yija yaᵽayu. Wãrõrimajamatorã yija eyarãka, Jesúrika bojariroka ã'mitirikoribeyurãte sayija wãrõrãka ᵽoto “Ikuᵽaka jia nare yija wãrõraᵽe”, yija ãrĩjĩka jia sime. ");
INSERT INTO tnc_vpl VALUES ("C210_17","077_10_17","2CO","10","17","17","I'suᵽaka jĩjimakaᵽi nabaarijayuakaka ĩ'rãrimarãre jaikoᵽeko'omakaja, ikuᵽaka sabojayu Tuᵽarã majaroᵽũñurã o'oeka: “Maᵽuᵽayariji mabaaikakaka jĩjimaka bojabekaja Tuᵽarãte maro'si baarijayuakaka takaja jĩjimakaᵽi mabojarijariye'e”, ãrĩwa'ri sabojayu. ");
INSERT INTO tnc_vpl VALUES ("C210_18","077_10_18","2CO","10","18","18","Suᵽa imarĩ ĩ'rĩka “Jia wãrõiki ñime”, kẽrĩkoᵽejĩka, dakowaᵽamarĩa sime. “Ĩ'ĩ kime jia wãrõiki”, Tuᵽarãte ãrĩrijayukate ᵽuri, “Jiitaki kime”, marĩwãrũyu maro'sioka. ");
INSERT INTO tnc_vpl VALUES ("C211_1","077_11_1","2CO","11","1","1","“Imatiyaiki ñime”, ãᵽaraka aᵽerãte bojabaraka õrĩᵽũabeyurãte ãñu uᵽaka yijaiko'omakaja yire mija ã'mitiriᵽẽarika yiyaᵽayu ruᵽu. I'suᵽaka mija ᵽõ'irã ᵽakirimiji majaroka wãrõirãte ã'mitiᵽaraka mija rakajeᵽããika uᵽakaja yireoka mija rakajeᵽããbe ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("C211_2","077_11_2","2CO","11","2","2","Jesucristore takaja mija ã'mitiriᵽẽarijaririka yiyaᵽayu. Ã'mitirikõrĩ je'e: Ĩ'rãko rõmo aᵽikaka baakoribeyuko kotĩmi imarukikaka takaja koᵽuᵽajoayu. I'suᵽaka koima uᵽakajaoka Cristore oyiaja ã'mitiriᵽẽairã mija ime. Yi'i imaki i'suᵽaka mija imaerã mamarĩ mijare wãrõũ'muraᵽaki. Suᵽa imarĩ Tuᵽarãte ᵽuᵽajoaika uᵽakajaoka mijare yiᵽuᵽajoayu yiro'si. “Jesúre na'mitiriᵽẽarija'ata'si”, ãrĩwa'ri i'suᵽaka ñimarijayu. ");
INSERT INTO tnc_vpl VALUES ("C211_3","077_11_3","2CO","11","3","3","Mia. Bikija Satanáre ãñakarã ña'rĩjãitirã Eva imaroyikakote jia kijaiᵽakika. “I'suᵽakajaoka nare kibaarãñu je'e aᵽeyari”, mijareka ñarĩᵽuᵽajoayu. “Jia Jesucristore õñurã imariᵽotojo ᵽakirimiji majaroka ã'mitiritirã Cristore jia nayi'ribesarãñu je'e”, ãᵽaraka ba'iaja mijareka yiᵽuᵽayu. ");
INSERT INTO tnc_vpl VALUES ("C211_4","077_11_4","2CO","11","4","4","Ikuᵽaka sime: Aᵽerã waᵽuju kotorõ'õᵽiji wãrõrĩ netamaka, “Ikuᵽaka Jesúre ime”, ñarĩka uᵽakamarĩa nawãrõko'omakaja jĩjimakaᵽi nare mija ã'mitiyu. I'suᵽakajaoka yija wãrõika ã'mitiriᵽẽawa'ri Esᵽíritu Santore mijare ña'rĩjãikarã imariᵽotojo, kima uᵽakamarĩakaka mijare nabojaᵽakã'ã “Rita, i'suᵽaka kimekã'ã”, mija ãñu. Suᵽabatirãoka “Ikuᵽaka ba'iaja mabaaika waᵽa Jesucristore maro'si waᵽaĩjika”, ñarĩka uᵽakamarĩa nawãrõko'omakaja nare mija ã'mitiririjayu. ¿Dako baaerã jĩjimakaᵽi naᵽakimajaroka mija ã'mitiyu je'e? ");
INSERT INTO tnc_vpl VALUES ("C211_5","077_11_5","2CO","11","5","5","“Tuᵽarãte ᵽũataekarã aᵽerãte tẽrĩwa'ribaji õñurã yija ime”, ãᵽaraka nawãrõrijarikoᵽeyu. I'suᵽakaja ãñurã imariᵽotojo “Yibo'ibajirã imabeyurã nime”, ñarĩᵽuᵽajoayu. ");
INSERT INTO tnc_vpl VALUES ("C211_6","077_11_6","2CO","11","6","6","Jia jaiwãrũtiyairãte jaika uᵽaka jaibeririᵽotojo Tuᵽarãrika bojariroka jia wãjia õñuka ñime. I'suᵽaka simamaka kimajaroka jia mijare yibojawaᵽu'atawãrũraᵽe. Ĩ'rãkurimarĩa yire ã'mitirika mirãrã imarĩ, “Jia Tuᵽarãrika õñuka Ᵽablote ime”, yireka ãrĩwãrũirã mija ime. ");
INSERT INTO tnc_vpl VALUES ("C211_7","077_11_7","2CO","11","7","7","Tuᵽarãrika bojariroka mijare yiwãrõraᵽaka ᵽoto sawaᵽa mijare jẽñeberaᵽaki yi'i. I'suᵽaka yibaamaka, “Imatiyairãte baaika uᵽakamarĩa baaiki kime”, ãᵽaraka yireka mija jaiyuyeyu je'e. “Tuᵽarãka jia nimarũ”, ãrĩwa'ri waᵽamarĩaja jia mijare yijeyobaaraᵽe. ¿Yaje jiamarĩtakaja sime je'e i'suᵽaka mijare yibaaraᵽaka? Jẽno'o, jia baawa'ri i'suᵽaka mijare yibaaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C211_8","077_11_8","2CO","11","8","8","Aᵽerã Jesúre ã'mitiriᵽẽairãte niñerũ yire ᵽũataraᵽaka e'etoritirã mijare wãrõbaraka ñimaraᵽe. Mijare jẽñebeyuka ñimako'omakaja, aᵽetata Cristore yi'yurã yire saᵽũataraᵽarã. ");
INSERT INTO tnc_vpl VALUES ("C211_9","077_11_9","2CO","11","9","9","Mija ᵽõ'irã ñimaraᵽaka ᵽoto wayuoka yibaaraᵽe. I'suᵽaka imariᵽotojo mija ᵽõ'irã jia ñimaerã, “Yire mija jeyobaabe”, mijare ãrĩberaᵽaki yi'i. Macedonia ka'iakarã Cristore yi'yurã mija ᵽõ'irã eyatirã jia ñimawãrũerã wayuoka yibaaika yire nijiraᵽe. Ĩ'rãkurioka niñerũ mijare jẽñekoriberaᵽaki yi'i. Maekakaoka i'suᵽakaja ñime ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("C211_10","077_11_10","2CO","11","10","10","Jesúre wãjia yiᵽuᵽaka jarirũjekaki imarĩ, wãjia kibojaeka uᵽakaja mijare yibojayu yiro'sioka. “Mijare sawaᵽa jẽñebekaja yiwãrõrijayu”, ñañu. I'suᵽaka ñañuaᵽi jĩjimaka ñime. I'suᵽaka ñimamaka ĩ'rãrimarã Acayaka'iakarã Corintorã imarãte yire jaiyuyekoᵽeika marã imabeyua. ");
INSERT INTO tnc_vpl VALUES ("C211_11","077_11_11","2CO","11","11","11","Mijare jẽñebeyuka imarĩ, ¿mijare wayuĩabeyuka ñime bai je'e? Jẽno'o i'suᵽakamarĩa sime. Jimarĩa mijare wayuĩaiki imarĩ, i'suᵽaka yibaayu. Tuᵽarãoka jia sõñuka i'suᵽaka mijaka ñima. ");
INSERT INTO tnc_vpl VALUES ("C211_12","077_11_12","2CO","11","12","12","Suᵽa imarĩ mijare waᵽa jẽñerimarĩaja yiwãrõrijarirãñu. Waᵽuju ᵽakirika wãrõrimaja ᵽuri sawaᵽa mijare jẽñerijayurã. “Tuᵽarãro'si Ᵽablorãkare ba'irabeĩjika uᵽakaja yija ba'iraberijayu”, narĩᵽakika mija ãrĩwãrũokaro'si, waᵽamarĩaja mijare yija wãrõrijayu. ");
INSERT INTO tnc_vpl VALUES ("C211_13","077_11_13","2CO","11","13","13","Tuᵽarãte aᵽóstolrãkamarĩrã nime i'suᵽaka baairã. Ᵽakirimaja imarĩ, “Jesúrika bojariroka yija wãrõerã kiᵽũataekarãoka yija ime yijaro'si”, narĩᵽakirijayu. ");
INSERT INTO tnc_vpl VALUES ("C211_14","077_11_14","2CO","11","14","14","I'suᵽaka narĩrũkia õrĩtikaja ñimaraᵽe. Satanásoka ángelrãka jia baairã uᵽaka ᵽemakotowiyuka aᵽerikuri, ᵽo'imajare ᵽakiokaro'si. ");
INSERT INTO tnc_vpl VALUES ("C211_15","077_11_15","2CO","11","15","15","I'suᵽaka kimarijayua simamaka, “Kire yi'yurã ᵽuri koᵽakaja kiuᵽaka jayurã”, mijare ñañu. Suᵽa imarĩ “Tuᵽarãro'si yija jã'meika simamaka ikuᵽaka mija baabe jia kika mija imaokaro'si”, nañu Satanáro'si ba'irabeĩjirimaja ᵽo'imajare ᵽakibaraka. I'suᵽaka nabaaikaᵽi “Jia Tuᵽarãro'si ba'irabeĩjirã nime”, ᵽo'imajare ãrĩᵽuᵽajoarika nayaᵽayu. Ba'iaja nabaaika waᵽa tẽrĩrikaja ĩ'rãrĩmi ba'iaja jũarũkirã nime. ");
INSERT INTO tnc_vpl VALUES ("C211_16","077_11_16","2CO","11","16","16","Ikuᵽaka jairimaji marĩka imariᵽotojo ĩ'rĩka “Ikuᵽaka jia baaiki ñime”, ãrĩwa'ri bojataᵽarimaji uᵽaka yijairã baayu. I'suᵽaka yijaikoᵽeko'omakaja, “Jia õrĩᵽũabeyuka kime Ᵽablo”, yireka mija ãrĩᵽuᵽajoa'si. I'suᵽaka simaberikoᵽerãkaoka “Jia õrĩᵽũabeyuka uᵽaka Ᵽablote jaiyu”, yireka mija ãrĩkoᵽeko'omakaja, i'suᵽaka yijairãñu. Koᵽakaja ᵽakirimajaroka wãrõrimajare ã'mitiyurã mija ime. Suᵽa imarĩ nare mija ã'mitiririjayu uᵽakaja yire mija ã'mitiᵽe ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("C211_17","077_11_17","2CO","11","17","17","Ika mijare yijaika uᵽakamarĩa mijare jaijĩki maiᵽamaki Jesucristo ᵽuri. Kiuᵽaka jaibekaja õrĩᵽũabeyurãte jairijayu uᵽaka yijaiyu. ");
INSERT INTO tnc_vpl VALUES ("C211_18","077_11_18","2CO","11","18","18","Ritaja wejeareka imarã uᵽaka “Ikuᵽaka jia baairã yija ime”, ãñurã mija watoᵽekarã ima simamaka nuᵽakaja mijare yijairã baayu yiro'sioka. ");
INSERT INTO tnc_vpl VALUES ("C211_19","077_11_19","2CO","11","19","19","“Jia õñurã yija ime”, ãñurã imakoᵽeriᵽotojo “Tuᵽarãte ᵽũataekarã yija ime”, ãᵽaraka õrĩᵽũabeyurãte jaikaja mija ã'mitiriᵽẽarijayu. Suᵽa imarĩ yireoka mija ã'mitirirãñu je'e. ");
INSERT INTO tnc_vpl VALUES ("C211_20","077_11_20","2CO","11","20","20","Naᵽoyarã uᵽaka mijare naba'iariko'omakaja nare mija e'etoririjayu. “Mijare yija wãrõika waᵽa yijare mija waᵽaĩjibe”, mijare narĩrijayua akata'abekaja nañu uᵽakaja nare samija ĩjirijayu. Suᵽabatirã jia nimarijarirũkitakaja ᵽuᵽajoatirã nayaᵽaika uᵽakaja mijare nabaarũjerijayu. Suᵽabatirãoka mija ĩᵽarimarãtarã uᵽaka mijare naba'iaririjayu. I'suᵽakajaoka jia nare mija yi'ribeyu ᵽareareka mijare naᵽemaᵽaarijayu. Ritaja i'suᵽaka mijare nabaako'omakaja sarũᵽekaja nawãrõika mija ã'mitiriᵽẽarijayu. ");
INSERT INTO tnc_vpl VALUES ("C211_21","077_11_21","2CO","11","21","21","“Okajãjimarĩrã nime”, yijareka mija ãñurã imarĩ, mijare nabaarijayu uᵽakaja yija baawãrũbeyu. ¿I'suᵽaka mijare yija baabeyua, jiamarĩa ruku sime je'e mijaro'si? Mae ate ĩ'rãrimarã “Ikuᵽaka jia baairã yija ime”, ãᵽaraka bojataᵽarimaja uᵽaka mijare yijairã baayu. I'yorimarĩaja i'suᵽaka nañua simamaka, i'suᵽakajaoka yijaiye'e yiro'sioka. ");
INSERT INTO tnc_vpl VALUES ("C211_22","077_11_22","2CO","11","22","22","Hebreotatarã imarĩ, “Aᵽerãte tẽrĩwa'ribaji imatiyairã yija ime”, nañu. I'suᵽaka narĩkoᵽeika marã imabeyua, hebreotatakijioka ñime yiro'si. Aᵽea “Israelka'iakarã imarĩ, Tuᵽarãrirã yija ime”, nañu. Yi'ioka Israel ka'iakakiji ñime yiro'si. Suᵽabatirã “Abraham riᵽarãmerã yija ime”, nañu. Abraham rĩᵽarãmijioka ñime yiro'sioka. ");
INSERT INTO tnc_vpl VALUES ("C211_23","077_11_23","2CO","11","23","23","Suᵽabatirãoka “Jia Jesúro'si ba'irabeĩjirã yija ime”, nañu. (I'suᵽakaja õrĩᵽũabeyuka uᵽaka yijairijayu yiro'si). Nare ᵽemawa'ribaji Jesúro'si ba'irabeĩjirimaji ñime. Mija ĩabe. “Cristoro'si yija ba'irabeĩjiyu”, waᵽuju nañua simako'omakaja yi'i ᵽuri jimarĩtakaja kiro'si ba'irabeĩjirijayuka. Suᵽabatirã nare ᵽemawa'ribaji wẽkomaka imariwi'iarã ᵽo'imajare yire tarijayu, Tuᵽarãrika yiwãrõriᵽarea. I'suᵽakajaoka nare tẽrĩwa'ribaji yire naᵽajeroyiraᵽe. Suᵽabatirãoka ĩ'rãkurimarĩa yire jããrika nari'kakoᵽeraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C211_24","077_11_24","2CO","11","24","24","Ĩ'rãᵽitarakakuri yire nañi'araᵽe. Yire nañi'aroyiraᵽaka rakakaja treinta y nueve rakakuri ajeaᵽi yire naᵽajeroyiraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C211_25","077_11_25","2CO","11","25","25","Suᵽabatirã maekarakakuri tĩmarĩtakaja yaᵽuaᵽi yire naᵽajeraᵽe. Suᵽabatirã yire jããerã ĩ'rãkuri ãtaᵽi yire najããbarekoᵽeraᵽe. Saᵽi ya'raᵽaka waᵽuru maekarakakuri ña'miraᵽaka. Ĩ'rãkuri yiña'miraᵽaka ᵽoto ĩ'rãrĩmi suᵽabatirã ĩ'rã ñami riaᵽakiakareka yaᵽuarã ñi'ajĩ'ĩkaki ñimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C211_26","077_11_26","2CO","11","26","26","I'suᵽakajaoka jimarĩtakaja Tuᵽarãrika bojariroka wãrõtaᵽabaraka yituriroyiraᵽe. I'suᵽaka turitaᵽabaraka tẽrĩrikaja werika yijũarijayu. Ã'mitirikõrĩ je'e. Riaka werikirõ'õ, kareba'arimajare werika imarõ'õ yituritaᵽaroyiraᵽe. Suᵽabatirã yitã'omaja imariᵽotojo werika imarã ᵽõ'irã, suᵽabatirãoka aᵽetatarãte werika imarõ'õrã yituritaᵽaroyiraᵽe. I'suᵽakajaoka wejea jo'baka werika imarõ'õrã, wejemato, riaᵽakiaka werika imarõ'õrãoka yituritaᵽaraᵽe. Suᵽabatirã waᵽuju “Jesúre ã'mitiriᵽẽairã yija ime”, ãrĩriᵽotojo werika imarã watoᵽekarã yituritaᵽaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C211_27","077_11_27","2CO","11","27","27","Niñerũ yiba'ariwaᵽa tõᵽoerã ka'wisika ba'irabebaraka ĩ'rãkurimarĩa kãrĩrimarĩaja yiwãrĩroyiraᵽe. I'suᵽakajaoka ĩ'rãkurimarĩa ba'arika, okoa jia yiro'si imaberiroyiraᵽaka imamaka, aᵽerikuri ᵽuri kẽ'sitakaja ñimaroyiraᵽe. I'suᵽakajaoka rĩkimaka jariromarĩka ñimaraᵽaka simamaka jimarĩa jijia yijũaroyiraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C211_28","077_11_28","2CO","11","28","28","I'suᵽaka ñimakaka takajamarĩa ba'iaja yiᵽuᵽaraᵽe. “¿Marãkã'ã nime ruku aᵽewejeakarã Jesúre ã'mitiriᵽẽairã? ¿Yaje rita jia kire nayi'ririjayu ruku?”, ãrĩᵽuᵽajoabaraka jimarĩa ba'iaja yiᵽuᵽarijayu. ");
INSERT INTO tnc_vpl VALUES ("C211_29","077_11_29","2CO","11","29","29","Jesucristore jia ã'mitiriᵽẽatiyabeyurã imarĩ, ba'iaja baabaraka, ba'iaja naᵽuᵽayua ñiaika ᵽoto, nuᵽakaja ba'iaja ᵽuᵽayuka ñime yiro'sioka. Suᵽabatirã Jesúre ã'mitiriᵽẽaikite ba'iaja baarũjeirãka ᵽuri boebaka ñime. ");
INSERT INTO tnc_vpl VALUES ("C211_30","077_11_30","2CO","11","30","30","Yibaaikakaka jairika yiro'si simajĩkareka ritaja ka'wisika yire so'raᵽakakaka ã'mitiritirã “Okajãjimarĩki kime”, ĩ'rãrimarãre ãñuakaka yijairã baayu. ");
INSERT INTO tnc_vpl VALUES ("C211_31","077_11_31","2CO","11","31","31","Ika mijare yibojaika, “Rita Ᵽablote ãñu”, Tuᵽarãte yireka ãrĩwãrũyu. Maiᵽamaki Jesús Ᵽaki majiyiᵽuᵽayeejiᵽarũkika kimamaka, kĩaika wãjitãji ritaitaka mijare yibojayu. ");
INSERT INTO tnc_vpl VALUES ("C211_32","077_11_32","2CO","11","32","32","Ikuᵽaka yijũaraᵽe: Damasco wãmeika wejearã ñimaraᵽaka ᵽoto, “Ᵽablote ñi'atirã wẽkomaka nabaarũ”, ãrĩwa'ri, wejeta'irõ'õrã ima koᵽerekarã surararãkare kiᵽũataraᵽe, tokaki ĩᵽi Aretas rokajĩte jã'merimaji. ");
INSERT INTO tnc_vpl VALUES ("C211_33","077_11_33","2CO","11","33","33","Yire wẽkomaka nabaarika yaᵽariᵽotojo yire nare kiñi'arũjewãrũberaᵽe. I'sia wejea ta'tekarã kũᵽajĩka koᵽereka imaraᵽarõ'õ ᵽi'iuᵽakaᵽi yire jããtatirã aᵽeᵽẽ'rõtorã yijeyomarãre yire ruetaraᵽe. Okajãjimarĩka imariᵽotojo i'suᵽaka Tuᵽarãte yire jeyobaaraᵽaka simamaka toᵽi yiru'raᵽe. ");
INSERT INTO tnc_vpl VALUES ("C212_1","077_12_1","2CO","12","1","1","Naᵽuᵽayariji ᵽuᵽajoatirã ᵽakirimajaroka wãrõrimajare mijare bojarika yiyaᵽabeyu. I'suᵽaka simako'omakaja “Tuᵽarãte ᵽũataekaki Ᵽablote ime”, yireka ãñurã mija jariberiko'omakaja makãrãrũñuroka uᵽakaᵽi Maiᵽamakire yire beaeka mirãkakaka mijare yibojaerã baayu mae. ");
INSERT INTO tnc_vpl VALUES ("C212_2","077_12_2","2CO","12","2","3","Bikija mabo'ikakuri ᵽiyikuku kimarõ'õrã Tuᵽarãte yire e'eeyaraᵽaka be'erõ'õ botarakaoũ'ᵽuarãe'earirakakuri wejejẽ'rãka seyawa'yu mae. Torã yire ke'eeyaeka, “I'suᵽaka baatirã yire ke'eeyaeka”, ãrĩwãrũbeyuka yi'i. ¿Yaje rita ritikataka yire ke'ewa'raᵽe jee, yiᵽuᵽakatakaja ke'ewa'raᵽe je'e aᵽeyari? Tuᵽarã ĩ'rĩkaja sõñuka. Rita sime, “I'suᵽaka baatirã yire ke'eeyaeka”, ãrĩwãrũbeririᵽotojo “Jiirõ'õrã Tuᵽarãte yire e'eeyaeka”, ñañu ate. ");
INSERT INTO tnc_vpl VALUES ("C212_4","077_12_4","2CO","12","4","4","Torã yeyaraᵽaka ᵽoto ᵽo'imaja okaᵽi mabojawãrũbeyua ña'mitiraᵽe. Torã ña'mitirika mirãka yire bojarũjebeyuka Tuᵽarã. ");
INSERT INTO tnc_vpl VALUES ("C212_5","077_12_5","2CO","12","5","5","I'suᵽaka yiro'si simaraᵽakaᵽi “Õrĩᵽũatiyaiki ñime”, ãrĩjĩka uᵽaki imakoᵽeriᵽotojo suᵽa ñarĩbeyu. Yiᵽuᵽayariji ᵽo'imajare yijaika ᵽoto tẽrĩrimarĩka ñima nare yijairijayu. ");
INSERT INTO tnc_vpl VALUES ("C212_6","077_12_6","2CO","12","6","6","“Ikuᵽaka yiro'si simaraᵽe”, ãᵽaraka jĩjimakaᵽi ᵽo'imajare yibojataᵽarikareka, ᵽakirimaji uᵽakamarĩa ñimajããeka ᵽakirimajaromarĩa bojaiki imawa'ri. I'suᵽaka simako'omakaja, “Ikuᵽaka yiro'si simaraᵽe”, ãrĩwa'ri tẽrĩritaki uᵽaka jĩjimakaᵽi ᵽo'imajare sabojataᵽabeyuka yi'i, “Aᵽerã ᵽemawa'ribaji õrĩᵽũatiyaiki Ᵽablote ime”, yireka narĩrika yaᵽaberiwa'ri. I'suᵽaka ñimaberiko'omakaja jia yibaarijayua ĩatirã, i'suᵽakajaoka yiwãrõrijayua ã'mitiritirã, yire norĩrika ᵽuri yiyaᵽayu. ");
INSERT INTO tnc_vpl VALUES ("C212_7","077_12_7","2CO","12","7","7","Makãrãrũñuroka uᵽakaᵽi Tuᵽarãte yire bearaᵽaka tẽrĩrikaja imatiyaikakaka imaraᵽaka. I'suᵽaka beariᵽotojo, “Aᵽerãte tẽrĩwa'ribaji imatiyaiki ñime”, ñarĩrika yaᵽaberiwa'ri Satanárikakaka ya'rarika yire rĩkaraᵽakareka Tuᵽarãte yire ĩarĩrĩberaᵽe. Suᵽa imarĩ ᵽota mare ᵽaaika be'erõ'õ maka'wisijũarijayu uᵽaka yire simarijayu. ");
INSERT INTO tnc_vpl VALUES ("C212_8","077_12_8","2CO","12","8","8","“Yiya'raika yire mibayabe”, ãrĩwa'ri maekarakakuri Maiᵽamakire yijẽñekoᵽeraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C212_9","077_12_9","2CO","12","9","9","I'suᵽaka kire ñaᵽakã'ã, ikuᵽaka yire kiyi'raᵽe: “Jẽno'o, mire yibayaberiko'omakaja, mire yiwayuĩaikaᵽi ãrĩwa'ri yijeyobaaika takaja miyaᵽayu. Mia, marãkã'ã baaberijĩka mima ᵽoto jiibaji mika imawa'ri mire jeyobaarimajiro'siji ñime”, kẽrãᵽe. Suᵽa imarĩ i'suᵽaka ñimakaka jĩjimakaᵽi yijairijayu. I'suᵽaka simako'omakaja, “Cristorika kire ja'ataikaᵽi jia kiro'si Ᵽablote ba'iraberijayu”, ᵽo'imajare yireka ãrĩwãrũyu mae. ");
INSERT INTO tnc_vpl VALUES ("C212_10","077_12_10","2CO","12","10","10","I'suᵽaka simamaka Cristoriki imarĩ, marãkã'ã baaberijĩki imariᵽotojo yiᵽuᵽaka ᵽuri jia ima. Ĩ'rãkurimarĩa ba'iaja ᵽo'imajare yire jaiwã'imarãᵽe “Ki'yoᵽi'rirũ”, ãᵽaraka. Suᵽabatirãoka yiyaᵽaika imaberiroyiraᵽaka yiro'si. I'suᵽakajaoka ĩ'rãkurimarĩa jajua ᵽo'imajare yire baata'araᵽe. Suᵽabatirã Jesúrika bojariroka yiwãrõmaka, ĩ'rãkurimarĩa ka'wisika yijũaraᵽe. I'suᵽaka simako'omakaja jĩjimaka ñime ãrĩᵽuᵽajoabaraka, “Marãkã'ã baawãrũberiwa'ri iamarĩa imarãka Cristore jeyoariyaᵽatiyayu.” I'suᵽaka simamaka rikitubamarĩa ñimakoᵽeikareka jia Cristore yire jeyobaayu. ");
INSERT INTO tnc_vpl VALUES ("C212_11","077_12_11","2CO","12","11","11","Koᵽakaja õrĩᵽũabeyuka uᵽaka yimajãrobojaweayu. “Yija ᵽõ'irã Tuᵽarãte ᵽũataekaki imarĩ, mare wãrõrimaji Ᵽablote ime”, mija ãrĩbeyua simamaka ñoñu uᵽakaja i'suᵽaka mijare ñañu. “Waᵽamarĩki Ᵽablote ime”, Tuᵽarãrika wãrõkoᵽeirãte yireka ãñu uᵽakaja ñimajããeka Tuᵽarãte yire jeyobaaberirikareka. I'suᵽaka simako'omakaja “Jiitaka wãrõrimaja nime”, mija ãrĩkoᵽeirã yire ᵽemawa'ribajimarĩrã nime. Suᵽa imarĩ “Tuᵽarãte kire jeyobaamaka jia Ᵽablote mare wãrõyu”, mija ãrĩri imakoᵽeraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C212_12","077_12_12","2CO","12","12","12","Mia, mija ᵽõ'irã ñimaraᵽaka ᵽoto aᵽóstol imarĩ maikoribeyu uᵽaka ima mijare yibearijaraᵽe. Ĩ'rãkurimarĩa samija ĩaeka simamaka “Rita oka, Tuᵽarãte ᵽũataekaki Ᵽablote ime”, yireka mija ãrĩri imakoᵽeraᵽe. ");
INSERT INTO tnc_vpl VALUES ("C212_13","077_12_13","2CO","12","13","13","“Aᵽerã Jesucristore ã'mitiriᵽẽairãte jiyiᵽuᵽayeeriᵽotojo, mare ᵽuri Ᵽablote jiyiᵽuᵽayeebeyu”, mija ãñua ¿rita sime bai je'e? “Yire mija jeyobaabe jia ñimaerã”, aᵽerãte ñarãᵽaka uᵽaka mijare ãrĩberaᵽaki imariᵽotojo ĩ'rãtiji oyiaja jiyiᵽuᵽaka mijare ñoñu. I'suᵽaka simako'omakaja “Aᵽerãte kijẽñeraᵽaka uᵽakaja, yijare kijẽñeri imakoᵽeraᵽe”, ãrĩwa'ri yireka mija jairijayu. ¿Yaje rita ba'iaja mijare yibaaraᵽe je'e? Ba'iaja mijare baaberaᵽaki imarĩ, marãkã'ã baatirã “Jiamarĩa yibaaraᵽakareka yire mija wayuĩabe”, mijare ñarĩwãrũbeyu. ");
INSERT INTO tnc_vpl VALUES ("C212_14","077_12_14","2CO","12","14","14","Ĩ'ᵽakuri mija ᵽõ'irã yituritika. Suᵽa imarĩ maekarakakurireka mija ᵽõ'irã turirĩ a'yaokaro'si mae ᵽuritaka yiᵽuᵽajoaũ'muyu ate. Ã'mitirikõrĩ je'e: Makarãirã ᵽuri namakarãte yaᵽaika tõᵽoerã niñerũ jierijayurã. Me'rãrĩjaka ᵽuri naᵽakiarãro'si i'suᵽaka baabeyurã. Toᵽi ãrĩwa'ri yimakarã uᵽaka yireka mija imamaka, mija ᵽõ'irã ñimarãka ᵽoto niñerũ mijare jẽñebesarãki yi'i. Mijare ᵽuri jia yika mija imarika yiyaᵽarãñu, jia mijare yiwãrõrimirĩrĩkawa'yaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("C212_15","077_12_15","2CO","12","15","15","Mijare wayuĩawa'ri mijare yijeyobaariyaᵽayu. “Jesúre na'mitiriᵽẽarũ”, ãrĩwa'ri ritaja yibaawãrũika uᵽakaja rũrĩtiyaika rõ'õjĩrã mijare yijeyobaarijarirãñu. Jia mijare wayuĩaiki ñimamaka yire mija wayuĩabesarãkareka, ba'iaja yiᵽuᵽarirãñu. ");
INSERT INTO tnc_vpl VALUES ("C212_16","077_12_16","2CO","12","16","16","Mijaka ñimaraᵽaka ᵽoto dakoa mijare yijẽñeberaᵽaka õñurã mija ime. I'suᵽaka simako'omakaja, “Ritaja ᵽakirika jia õñuka imarĩ, Ᵽablote mijare ᵽakiyu niñerũ mijare karee'eokaro'si”, ĩ'rãrimarãre yireka ãñu je'e. ");
INSERT INTO tnc_vpl VALUES ("C212_17","077_12_17","2CO","12","17","17","“Maᵽõ'irã kiᵽũataraᵽarãᵽioka Ᵽablote mare ᵽakika”, ¿mija ãrĩᵽuᵽajoayu bai je'e? Jẽno'o mijare ᵽakiberaᵽaki yi'i. ");
INSERT INTO tnc_vpl VALUES ("C212_18","077_12_18","2CO","12","18","18","Titore aᵽika Jesúre ã'mitiriᵽẽaikiᵽitiyika mija ᵽõ'irã yiᵽũataraᵽe niñerũ mija rẽawearika najeyobaaokaro'si. ¿Yaje Titore mijare ᵽakiraᵽe je'e? Jẽno'o mijare ᵽakikoriberaᵽaki kime. Yuᵽakaja jia ᵽuᵽajoaiki imarĩ, mijare jeyobaariyaᵽawa'ri jia Tuᵽarãrika bojariroka mijare kiwãrõeka, niñerũ mijare jẽñebekaja. ");
INSERT INTO tnc_vpl VALUES ("C212_19","077_12_19","2CO","12","19","19","“Ba'iaja baabeyurã nime”, yijareka ãrĩwa'ri jĩjimaka yijaka mija imaokaro'si takajamarĩa, i'suᵽaka mijare ñañu. Ikuᵽaka simatiyayu, ĩakõrĩ je'e: Jesúrirã imarĩ, kiyaᵽaika uᵽakaja mijare yija jairijayu Tuᵽarãte ĩaika wãjitãji. Mija ã'mitiᵽe yija jeyomarã. Ritaja mijare yija bojarijayua, “Jiibaji Jesúre na'mitiriᵽẽarijarirũ”, ãrĩwa'ri mijare sayija bojayu. ");
INSERT INTO tnc_vpl VALUES ("C212_20","077_12_20","2CO","12","20","20","Mijareka ᵽuᵽajoabaraka ba'iaja yiᵽuᵽarijayu. “Mija ᵽõ'irã yeyarãka ᵽoto ba'iaja baabaraka mija imarãka ñiaeyarãñu je'e aᵽeyari”, mijareka ñarĩᵽuᵽajoarijayu. Waᵽabu'abaraka, suᵽabatirã aᵽerãte oakiᵽaraka mija imarãka ñiaeyarãñu je'e. I'suᵽakajaoka boebaᵽaraka, suᵽabatirã rakakaja naᵽuᵽajoaika uᵽakaja baawa'ri jia jeyoaribekaja mija imarijayuaoka ñiarãñu je'e. I'suᵽakajaoka okabaaᵽakibu'abaraka, suᵽabatirã waᵽuju jaijairika baabaraka mija imarãka ñiarãñu je'e. Aᵽerãte tẽrĩwa'ribaji ᵽuᵽajoairã uᵽaka baabaraka, suᵽabatirã rakakaja ᵽuᵽajoawa'ri rukubaka mija rẽñua ñiaeyarãñu je'e aᵽeyari. Suᵽabatirã, “Jesúre yaᵽaika uᵽakaja baabekaja nimañuju je'e”, ñarĩᵽuᵽajoaika uᵽaka mija imamaka ĩatirã mijaka yiboebarirãñu. I'suᵽakajaoka jĩjimaka yika mija imabesarãñu mijaro'sioka. ");
INSERT INTO tnc_vpl VALUES ("C212_21","077_12_21","2CO","12","21","21","Ate mija ᵽõ'irã yeyarãka ᵽoto ba'iaja baabaraka mija ima ñiaeyarãkareka “Nare yiwãrõraᵽaka uᵽakaja yi'ribeyurã nime”, ãrĩwa'ri Tuᵽarã wãjitãji yi'yoᵽi'rirãñu. Suᵽabatirã “Bikija rĩkimarãja ba'iaja nabaaeka saja'atabekaja dajaka nabaarijayu je'e aᵽeyari. Suᵽabatirãoka ba'iaja rõmijãte nabaariwã'imarĩrijayu. I'suᵽakajaoka naᵽuᵽajoarijayu uᵽakaja wããrõ'õ ba'iaja nabaarijayu ruᵽu”, ãᵽaraka ñiaeyarãka, ba'itakaja yiᵽuᵽarirãñu. ");
INSERT INTO tnc_vpl VALUES ("C213_1","077_13_1","2CO","13","1","1","Ika ya'rirã baaikaᵽi maekarakakuri mija ᵽõ'irã yeyarãñu. Torã eyatirã Tuᵽarã majaroᵽũñu o'oekarã ãñu uᵽakaja yibaarãñu. Mia je'e: “Ĩ'rĩkate ba'iaja baamaka ĩaekarã jaijeyobaabaraka ĩ'ᵽarã, maekarakamarã ‘Rita sime. I'suᵽakatakaoka kibaaraᵽe’, ãñurãte imajĩkareka, okajierika sime kika”, ãrĩwa'ri sabojayu. ");
INSERT INTO tnc_vpl VALUES ("C213_2","077_13_2","2CO","13","2","2","Bikija ĩ'ᵽakuri mija ᵽõ'irã yituraᵽakareka, ba'iaja baairãte jia yokajããraᵽe “Ba'iaja nabaaika naja'atarũ”, ãrĩwa'ri. Mae mija ᵽõ'irã imabeririᵽotojo ᵽaᵽeraᵽi, “Ba'iaja mija baaika mija ja'atabe”, ñañu ba'iaja baarijayurãte. Aᵽerãᵽitiyika ba'iaja baabaraka nimamaka ñiaeyarãkareka, ba'iaja nabaaika waᵽa tĩmarĩji nare yibaarãñu. ");
INSERT INTO tnc_vpl VALUES ("C213_3","077_13_3","2CO","13","3","3","“ ‘Rita Cristore õñuaᵽi mibojarijayu’, yija ãrĩwãrũokaro'si, kirika yijare mibeabe”, mija ãñua sime. I'suᵽaka simamaka, kirikaᵽi tĩmarĩji nare yibaamaka ĩawa'ri “Cristore jã'meika uᵽakaja kirikaᵽi jairijayuka Ᵽablote ime”, yireka mija ãrĩwãrũrãñu je'e. Okajãjimarĩa imabeyuka Cristo mijaka. Ba'iaja baairãte jiamarĩa jũaokaro'si kirika baabearimaji kime. ");
INSERT INTO tnc_vpl VALUES ("C213_4","077_13_4","2CO","13","4","4","Muᵽaka ᵽo'iki imariᵽotojo, yaᵽua tetaekarã kire naᵽatakĩaeka simamaka, okajãjimarĩki uᵽaka Cristore reyaeka mija õñu. I'suᵽaka kire nabaako'omakaja, Tuᵽarãrikaᵽi ãrĩwa'ri õñia kime mae. Cristorirã imarĩ, kiuᵽakaja okajãjimarĩrã yija ime ᵽo'imajare yijare ĩamaka. I'suᵽaka simako'omakaja kirirã imarĩ, Tuᵽarãrikaᵽi ãrĩwa'ri kiyaᵽaika uᵽakaja yija baarijayu. I'suᵽaka imarã imarĩ, saᵽi ãrĩwa'ri mija ᵽõ'irã ba'iaja baairãte tĩmarĩji yija baarãñu, jia nayi'rirũ ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("C213_5","077_13_5","2CO","13","5","6","Mija ĩabe. Cristore mija yi'yua ᵽuᵽajoatirã “¿Yaje rita Jesucristore yi'yurã maime?”, mija ãrĩᵽuᵽajoabe. “¿Mija ᵽuᵽakareka Cristore ña'rĩjãikarã mija ima õrĩbeyurã mija bai je'e?” Toᵽi ᵽuri “Jesúre maᵽuᵽakarã ña'rĩjãiberikarã maime”, ãñurã ᵽuri kire yi'ribeyurã nime. I'suᵽaka simakoᵽeko'omakaja “ ‘Jia kire yi'yurã yija ime’, ãñurã mija ime”, mijareka ñarĩᵽuᵽajoayu. Suᵽa imarĩ mamarĩtaka kirika bojariroka mijare yija bojaraᵽaka ã'mitiritirã jia kire mija yi'raᵽaka simamaka, “Rita, Cristore nare õrĩrũjeikaᵽi Ᵽablorãkare yijare bojarijayu”, ãrĩwãrũirã mija ime. ");
INSERT INTO tnc_vpl VALUES ("C213_7","077_13_7","2CO","13","7","7","Ba'iaja baabaraka mija ima yija ĩaeyarãkareka, Cristore yijare sajã'metika simamaka, jiamarĩa mijare yija jũarũjerãñu. I'suᵽaka mijare yija baarãkareka “Cristore nare jã'meikaᵽi i'suᵽaka Ᵽablorãkare mare baayu”, mija ãrĩwãrũrãñu. I'suᵽaka mijare baariyaᵽaberiwa'ri ba'ia mija baakoreka Tuᵽarãte mijaro'si yija jẽñeĩjirijayu. Suᵽa imarĩ Tuᵽarãte yaᵽaika uᵽakaja mija baarãkareka ᵽuri, ba'iaja mijare yija baabesarãñu. Suᵽa mijare yija baabeᵽakã'ã ĩatirã “Yaje rukuya Cristore jã'meikaᵽi tĩmarĩji yijare nabaatiyajĩñu”, yijareka mija ãrĩkoᵽejĩkaoka, marã imabeyua yijaro'si. I'suᵽaka simako'omakaja kiyaᵽaika uᵽaka oyiaja mija baaritakaja yija yaᵽayu. ");
INSERT INTO tnc_vpl VALUES ("C213_8","077_13_8","2CO","13","8","8","Suᵽa imarĩ mija ᵽõ'irã yija eyarũki ruᵽu kiyaᵽaika uᵽakaja baatikarã mija imarãkareka ᵽuri kijã'meikaᵽi ba'iaja mijare yija jũarũjebesarãñu. Kiyaᵽaika uᵽakaja Cristore yijare jã'metikarã imarĩ, mijare jeyobaarimaja yija ime, ba'ia uᵽakaja mijare baabekaja. ");
INSERT INTO tnc_vpl VALUES ("C213_9","077_13_9","2CO","13","9","9","Suᵽa imarĩ mija ᵽõ'irã eyatirã, jia Cristore yi'yurã mija ima ĩawãrũtirã okajãjiaᵽi mijare yijaibesarãñu. “Okajãjimarĩrã imarĩ, Cristorikaᵽi Ᵽablorãkare beabeyu”, yijareka mija ãrĩkoᵽejĩka, marã imabeyua yijaro'si. Jia mija yi'ᵽakã'ã ĩawa'riji, jia jĩjimaka imarũkirãja yija ime. Suᵽabatirã “Mire ã'mitiriᵽẽawa'ri miyaᵽaika uᵽaka oyiaja nabaarũ”, ãrĩwa'ri, Tuᵽarãte mijaro'si yija jẽñerijayu. ");
INSERT INTO tnc_vpl VALUES ("C213_10","077_13_10","2CO","13","10","10","I'suᵽaka simamaka mija ᵽõ'irã eyatirã, okajãjiaᵽi mijare yijairiyaᵽabeyu. Suᵽa imarĩ ya'rirã baaika ruᵽu, ika ᵽaᵽera mijare yiᵽũatayu jiibaji Jesúre yi'ᵽaraka mija imaokaro'si. I'suᵽaka mijare baarimaji ñimaokaro'si Maiᵽamakite yijare jã'meka. Suᵽa imarĩ kire mija yi'yua bitatarikoᵽakaja jiibaji kire mija yi'ririjayaokaro'si mijare yija jeyobaarijayu. ");
INSERT INTO tnc_vpl VALUES ("C213_11","077_13_11","2CO","13","11","11","Õ'õjĩrãja mijaro'si yo'oyu yijeyomarã. Jia mija imabe, Jesúre yaᵽaika uᵽaka oyiaja baabaraka. Ritaja ika ᵽaᵽeraᵽi mijare yibojaika jia ã'mitiriᵽẽabaraka mija imabe. Ĩ'rĩka uᵽakaja ᵽuᵽajoabaraka, oka imarijarirãkaoka jiaᵽi sajiebaraka mija imabe. I'suᵽaka mija baamaka, Tuᵽarã, mare wayuĩarimajire, mijaka imajiᵽarãñu. Suᵽabatirã jĩjimaka mare imarũjeiki kime. ");
INSERT INTO tnc_vpl VALUES ("C213_12","077_13_12","2CO","13","12","12","Jesúre ã'mitiriᵽẽairã imarĩ, mija rẽrĩrijayu ᵽoto jia jĩjimakaᵽi jẽñebu'abaraka mija imarijaᵽe. ");
INSERT INTO tnc_vpl VALUES ("C213_13","077_13_13","2CO","13","13","13","Õ'õkarã Jesúre ã'mitiriᵽẽairã, “Jia nimarũ”, ãrĩwa'ri oka mijaro'si naᵽũatayu. ");
INSERT INTO tnc_vpl VALUES ("C213_14","077_13_14","2CO","13","14","14","“Jia nare mibaabe”, ãrĩwa'ri maiᵽamaki Jesucristore mijaro'si yijẽñeyu. “Suᵽabatirã Tuᵽarãte mijare wayuĩaika jia õñurã mija imaokaro'si, suᵽabatirãoka Esᵽíritu Santo jia mijaka imajiᵽarijayuka kimarũ”, ãrĩwa'ri ritaja mijaro'si yijẽñeĩjirijayu yijeyomarã. I'tojĩrãja sime ruᵽu.");
INSERT INTO tnc_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","Yijeyomarã Filiᵽoskarã, Jesucristore jia baaikaᵽi kirirã imarijayurã, suᵽabatirã kire yi'yurãte imaruᵽutarimaja, i'suᵽakajaoka nare jeyobaarimaja “Jia mija imabe”, ãrĩwa'ri oka mijaro'si yija ᵽũatayu. Yi'i Ᵽablo, yijeyomaki Timoteoᵽitiyika mijaro'si sayija ᵽũatayu Jesucristoro'si ba'irabeĩjirimaja imarĩ. ");
INSERT INTO tnc_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","Suᵽa imarĩ, Maᵽaki Tuᵽarã, suᵽabatirã maiᵽamaki Jesucristoreoka “ ‘Jia dako okamirãmarĩaja nimarũ’, ãrĩwa'ri jia nare mija jeyobaabe”, ãᵽaraka mijaro'si nare yija jẽñerijayu. ");
INSERT INTO tnc_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","Mijareka yiᵽuᵽajoarijayu rakakaja “Jia mibaayu”, Tuᵽarãte narĩrijayu. ");
INSERT INTO tnc_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","5","Suᵽabatirã Tuᵽarãte mijaro'si yijẽñeika rakakaja jĩjimakaᵽi kire yijairijayu. Tuᵽarãte mija yi'riũ'muekarõ'õjĩteᵽi, maekakaoka aᵽerãte Jesúrika bojariroka bojataᵽabaraka yire mija jeyobaarijayua simamaka i'suᵽaka yibaarijayu. ");
INSERT INTO tnc_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","Rita sime, jia Tuᵽarãte mija ᵽuᵽaka baaũ'mutika simamaka, kiyaᵽaika uᵽakaja mija imamirĩrĩkawa'yaokaro'si mijare kijeyobaarijarirãñu, Jesucristore etarãñurĩmi rõ'õjĩrãrãja. ");
INSERT INTO tnc_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","Mijare wãtaiki imarĩ, i'suᵽaka mijareka yiᵽuᵽajoayu. Yire jeyobaariᵽuᵽakirã imarĩ, ĩ'rãkurimarĩa yiyaᵽaika yire mija ᵽũatarijayu. Mia je'e, wẽkomaka imariwi'iarã imariᵽotojo Jesúrika bojarirokakaka yaᵽabeyurã wãjitãji “Ikuᵽaka sime”, ãrĩwa'ri nare okae'ebaaraka, yibojajiirijayu. I'suᵽaka yibaayu ᵽo'imajare yibojawãrõrũkia Tuᵽarãte yire ja'ataeka simamaka. I'suᵽaka ñimarijayua simamaka jia ñimaokaro'si yire mija ᵽũatarijayua jia sime. ");
INSERT INTO tnc_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","Jesucristore wãtaka mijare õñuaᵽi ãrĩwa'ri i'suᵽakajaoka mijaka ñima Tuᵽarãte õñua. I'suᵽaka imaki imarĩ jimarĩa mijare ñiariᵽakatayu ate. ");
INSERT INTO tnc_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","11","I'suᵽaka imawa'ri, ikuᵽaka Tuᵽarãte mijaro'si yijaiĩjirijayu. “Jia mire õrĩrijaᵽaraka miyaᵽaika uᵽakaja imamirĩrĩkawa'yurã imarĩ jiibaji wayuĩabu'airã nimarũ. I'suᵽaka imawa'ri miyaᵽaika uᵽaka imarika najẽrãko'arũ”, ãrĩwa'ri Tuᵽarãte mijaro'si yijaiĩjirijayu. I'suᵽaka yiyaᵽayu “Jia baarijaririka ja'atabekaja nimarũ”, ãrĩwa'ri. Suᵽa mija imamaka ĩatirã “Dakoa okamirãmarĩaja jia yika nima nareka ñoñu”, Cristore ᵽe'rietarãñurĩmi mijareka kẽrĩrika yiyaᵽayu. Suᵽabatirãoka Jesucristore mijare jeyobaaikaᵽi “Tuᵽarãte yaᵽaika uᵽakaja baarijayurã nimarũ mae”, mijareka ñañu. Suᵽa imarĩ mijare kijeyobaamaka ĩatirã, “Tẽrĩwa'ribaji jia baaiki Tuᵽarãte ime”, ãᵽaraka aᵽerãte kire jiyiᵽuᵽayeeokaro'si naro'sioka kire yijaiĩjirijayu. ");
INSERT INTO tnc_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","Yijeyomarã, Jesúrika bojariroka yiwãrõriᵽareareka ba'iaja yijũaika simako'omakaja, ᵽo'imajare yibojarija'atabeyua sime. I'suᵽaka yiro'si simako'omakaja rĩkimarãja aᵽerã yibojaika ã'mitiriwãrũtirã kire nayi'ririjayuakaka jia mija õrĩwãrũbe. ");
INSERT INTO tnc_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","Mia je'e, “Cristore kiyi'yu ᵽi'iwa'ri wẽkomaka imariwi'iarã kime”, ika wejea ĩᵽamaki wi'ia ĩarĩrĩrimaja surararãkare yireka ãrĩrijayu. Suᵽabatirã ᵽo'imaja ritaja ika wejeareka imarãoka i'suᵽaka yireka ᵽuᵽajoarijayurã. ");
INSERT INTO tnc_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","Suᵽa imarĩ, Cristore yi'ririja'ataberiwa'ri wẽkomaka imariwi'iarã ñima õrĩwa'ri, rĩkimarãja ika wejearã Maiᵽamakire yi'yurã jiibaji kirika bojarijayurã ba'iaja jũarika kĩkibekaja. ");
INSERT INTO tnc_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","15","I'suᵽaka simako'omakaja, ĩ'rãrimarã ᵽuri, “Wẽkomaka imariwi'iarã Ᵽablote ima marã imabeyua”, ãñurã. I'suᵽaka ãñurã imarĩ, “Ᵽablote bojaikakaka ã'mitiriberiwa'ri rĩkimabaji yijare ã'mitiriᵽẽairãte imarãñu je'e”, nañu yibaarijayuakaka oakiyurã. Aᵽerã ᵽuri jia yika imawa'ri jiaᵽi Cristorika bojariroka bojarijayurã. ");
INSERT INTO tnc_vpl VALUES ("PP1_16","080_1_16","PHP","1","16","16","I'suᵽaka yire wayuĩairã imarĩ, “Tuᵽarãᵽi ãrĩwa'ri wẽkomaka imariwi'iarã Ᵽablote ime. Suᵽa imarĩ Romawejeakarã ĩᵽarimarã Cristorika bojariroka bojarika nayaᵽabeyua simako'omakaja Ᵽablote sanajẽrĩamaka, nawãjitãji jia yi'riwãrũiki kime”, ãñurã nime. ");
INSERT INTO tnc_vpl VALUES ("PP1_17","080_1_17","PHP","1","17","17","Aᵽerã imarã yire ᵽemawa'ribaji imarika yaᵽakoᵽewa'ri “Cristorika bojariroka yija wãrõmaka yijare takaja ã'mitiriᵽẽairãte imarãñu je'e. I'suᵽaka simamaka sã'mitiritirã yijare oakiriwa'ri, wẽkomaka imariwi'iarã kimarõ'õᵽi ba'iaja Ᵽablote ᵽuᵽarirãñu”, narĩkoᵽeyu. ");
INSERT INTO tnc_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","19","I'suᵽaka nabaarijayua marã imabeyua yiro'si. Ritaja Cristorika bojariroka nawãrõrijayuaᵽi ãrĩwa'ri jĩjimaka ñime. I'suᵽaka imarijayuka imarĩ, “Tuᵽarãte yiro'si mija jẽñeĩjimaka, suᵽabatirã Esᵽíritu Santore yire jeyobaamaka ᵽariji ritaja yijũaika jia oyiaja yiro'si sawaᵽu'rirãñu”, ñarĩᵽuᵽajoayu. ");
INSERT INTO tnc_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","I'suᵽaka ᵽuᵽajoaiki imarĩ, ĩᵽarimarã wãjitãji naka yijairãka ᵽoto, “Dakoa i'yomarĩaja jaiki ñimarijarirãñu”, ãñuka ñime. Suᵽa imawa'ri Cristorika bojariroka jia wãjia yibojarijariroyika uᵽakaja nare sayibojariyaᵽayu. Suᵽa imarĩ yire najẽrĩawearãka ᵽoto, yire najããkoᵽejĩka, yire naᵽoatajĩkaoka, marã imabeyua yiro'si. Ritaja yibaarijayua Cristore jiyiᵽuᵽayeerũkiakaka simarika yiyaᵽayu. ");
INSERT INTO tnc_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","22","Suᵽa imarĩ, yire najããbesarãkareka ritaja yibaarijayuaᵽi jia Cristore jiyiᵽuᵽayeebaraka ᵽo'imajare imarika yiyaᵽayu. Yire najããkoᵽerãkaoka jiibaji yiro'si simarãñu Cristoka jia imarũkika ñima simamaka. I'suᵽaka simako'omakaja yire naᵽoatarãkarekaoka, Cristorika bojariroka yibojamaka rĩkimarãja sã'mitiriᵽẽarãñurã. Suᵽa imarĩ, “¿Dika jiitaka imatiyaika je'e?”, ãrĩwãrũbeyuka ñime. ");
INSERT INTO tnc_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","I'suᵽaka simamaka “Ika ĩ'ᵽaba'iwã'taja jia yiro'si ima”, ñarĩwãrũbeyu. I'suᵽaka simako'omakaja reyatirã mabo'ikakurirã jiibaji kika imarika simarãñu je'e yiro'si ñarĩᵽuᵽajoarijayu. ");
INSERT INTO tnc_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","I'suᵽaka yiᵽuᵽaka imako'omakaja mijare jeyobaabaraka õñia imarika yiyaᵽayu jiibaji mijaro'si simaerã. ");
INSERT INTO tnc_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","Suᵽa imarĩ “Jiibaji Tuᵽarãte yi'ᵽaraka jĩjimaka kika nimaokaro'si nare wãrõbaraka, naka ñimarãñu ate”, ãrĩᵽuᵽajoaiki ñime. ");
INSERT INTO tnc_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","Toᵽi wẽkomaka imariwi'iarã ñima be'erõ'õ mija ᵽõ'irã yeyarãka ᵽoto, “Wẽkomaka imariwi'iarã kimaraᵽarõ'õᵽi Ᵽablote miᵽoaeka jiitaka kire mibaayu”, Jesucristore ãᵽaraka jia jĩjimaka mija imarãñu. ");
INSERT INTO tnc_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","28","I'suᵽaka simako'omakaja, wẽkomaka imariwi'iarã yiro'si simarãka uᵽakaja simakoᵽerãka marã imabeyua. Jia Cristorika bojariroka yi'yurã imarĩ, sabojaika uᵽakaja jia baabaraka mija imarijaᵽe. I'suᵽaka mija baabe mija ᵽõ'irã yeyarãka uᵽarãka, yeyabesarãkarekaoka jia ĩ'rãtiji ᵽuᵽajoairã imawa'ri, Cristore yi'ririja'atabeyurã mija ima ñoñaokaro'si. I'siaᵽi ãrĩwa'ri, aᵽerãte mijare okabaako'omakaja ĩ'rĩka ta'iarãja imarã imarĩ, Jesúrika bojariroka mijare yiwãrõraᵽaka uᵽakaja mija imarijayua ñorĩrãñu. I'suᵽaka imarã imawa'ri ba'iaja mijare baarijayurã ruᵽu wayuᵽi'ribekaja mija imabe. I'siareka mija ima ĩatirã “Rita, Tuᵽarãka õñia imajiᵽarũkirã nime. Yija ᵽuri ba'iaja nare jaiwã'imañurã yija imariᵽareareka, ba'iaja imarika tiyibeyurõ'õrã a'rirũkirã imarã”, narĩᵽuᵽajoarãñu. Mijare yibojaika uᵽatiji Tuᵽarãtakiji imaki ritaja sabaarimaji. ");
INSERT INTO tnc_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","I'suᵽaka imaki imarĩ, jia mijare baawa'ri kirirãro'si Tuᵽarãte mijare wã'maeka, “Yimakire yi'ᵽaraka nimarũ, suᵽabatirãoka jia kire yi'riwa'ri ba'iaja jũabaraka nimarũ”, ãrĩwa'ri. Suᵽa imarĩ kire mija yi'yua ja'atabekaja mija imamaka ĩatirã aᵽerãoka Cristore yi'rirãñurã. ");
INSERT INTO tnc_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","Suᵽa imarĩ mija ᵽõ'irã ñimaraᵽaka ᵽoto ba'iaja yire nabaaraᵽaka mija ĩaraᵽaka uᵽakaja jũairã mija ime mijaro'sioka mae. I'suᵽakajaoka õ'õ Romawejearã aᵽerãte ba'iaja yire baaika majaroka mija ã'mitiyu ate. ");
INSERT INTO tnc_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","2","Kirirã mija imamaka, jia ᵽuᵽaᵽaraka mija imaokaro'si Cristore mijare jeyobaayu. I'suᵽakajaoka mijare kiwãtayu iamarĩaja mija imakoreka. Suᵽabatirãoka rĩrãkibiᵽaraka Esᵽíritu Santore mijaka imarijayu. Toᵽi jia Cristore mare wayuĩaika simamaka jĩjimaka ñimaokaro'si ikuᵽaka mija imarika yiyaᵽayu: Mija jeyomarãka ĩ'rãtiji ᵽuᵽakirã mija imabe. I'suᵽakajaoka ritaja mija imauᵽatiji, jia wayuĩabu'abaraka ĩ'rĩka ta'iarãja imawa'ri, Cristore yaᵽaika uᵽakaja ĩ'rãrokarekaja ña'rĩyaarĩji ᵽuᵽajoairã mija imabe. ");
INSERT INTO tnc_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","Aᵽerãte ᵽemawa'ribaji imarika yaᵽabekaja mija imarijaᵽe. I'suᵽakajaoka “Ᵽo'imajare yijare jiyiᵽuᵽayeerũ”, ãrĩwa'ri mija baaikakaka mija jaia'si. I'siroka ᵽuᵽajoaberiwa'ri “Yijare tẽrĩwa'ribaji imatiyairã nime je'e aᵽeyari aᵽerã”, ãrĩwa'ri jiyiᵽuᵽaka nare mija õrĩrijaᵽe. ");
INSERT INTO tnc_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","Mijaro'si takaja jia mija imarũkia ᵽuᵽajoabekaja aᵽerãte jia imarũkiakakaoka mija ᵽuᵽajoarijaᵽe. ");
INSERT INTO tnc_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","I'suᵽaka mijare ñañu Jesucristore imaekarokaᵽiji õrĩtirã kiuᵽaka mija imarijayaokaro'si. Ĩakõrĩ je'e, ikuᵽaka sime: ");
INSERT INTO tnc_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","Tuᵽarãka ĩ'rãtiji imariᵽotojo, “Tẽrĩriki Tuᵽarãte ima uᵽakaja ñima yija'atabesarãñu”, ãrĩbeyuka Cristore imaeka. ");
INSERT INTO tnc_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","I'suᵽaka ãrĩbekaja, tẽrĩwa'ribaji kima ja'atatirã, ᵽo'imaji kiᵽo'ijirika. Suᵽabatirã ba'irabeĩjirimaji imatiyabeyuka uᵽaka kijarika. ");
INSERT INTO tnc_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","Suᵽa imarĩ ika ka'iarã kimaeka ᵽoto, “Yire ᵽemawa'ribajika mime”, ãñuka uᵽaka Kiᵽakire kiyi'ririjarika. I'suᵽaka imaekaki imarĩ, ba'iaja baarimajare najããroyika uᵽaka yaᵽua tetaekarã kire naᵽatakĩaeka, sarã kireyaokaro'si ᵽariji Tuᵽarãte kiyi'rika. ");
INSERT INTO tnc_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","Suᵽabatirã kireyaeka be'erõ'õ õñia kire jariᵽe'rirũjetirã, ikuᵽaka Tuᵽarãte kire ãrĩka: “Ritaja ima ᵽemawa'ribajirã jiyiᵽuᵽaka õrĩrũkika mimabe. Suᵽa imarĩ ritaja imarã ᵽemawa'ribaji ĩᵽi mimarãñu”, kire kẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","I'suᵽaka Tuᵽarãte kire ãrĩka seyarãka ᵽoto nimauᵽatiji kiᵽoiji'aekarã: Mabo'ikakurirã imarã, õ'õrã imarãoka, ka'irokareka imarã ᵽariji Jesúre najiyiᵽuᵽayeerãñu. ");
INSERT INTO tnc_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","Nawãjitãji kimarãka ᵽoto “Ritaja imarã ĩᵽamaki Jesucristore ime”, wããrõ'õrãja ritaja imarãte kire ãrĩrãñu. I'suᵽaka baawa'ri Kiᵽaki Tuᵽarãteoka jiyiᵽuᵽaka norĩrãñu. ");
INSERT INTO tnc_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","Yijeyomarã, i'suᵽaka Cristore baaeka ᵽuᵽajoawa'ri i'suᵽakajaoka Tuᵽarãte mija yi'rijĩñu. Mija ᵽõ'irã ñimaraᵽaka ᵽoto jia kire yi'yurã mija imamaka ñiaraᵽe. Maekaka ᵽuri mija ᵽõ'irã ñimabeyua simamaka torã ñimaraᵽaka ᵽoto jia kire mija yi'raᵽaka uᵽakaja jiibaji kire yi'ᵽaraka mija imarika yiyaᵽayu. Suᵽa imarĩ ba'iaja mija jũarũkiareka Tuᵽarãte mijare satããeka simamaka kire kĩkibaraka, kiyaᵽaika uᵽakaja mija baarijaᵽe. ");
INSERT INTO tnc_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","I'suᵽaka mijare ñañu “Yiyaᵽaika takaja baariᵽuᵽakirã nimarũ”, ãrĩwa'ri Tuᵽarãte mijare jeyobaarijayua simamaka. ");
INSERT INTO tnc_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","14","Ã'mitirikõrĩ je'e: Mija baaika uᵽakaja, ba'iaja jaibu'abekaja, jĩjimakaᵽi mija imarijaᵽe. ");
INSERT INTO tnc_vpl VALUES ("PP2_15","080_2_15","PHP","2","15","16","I'suᵽaka mijare ñañu, oka baabekaja, jia wãjiroka oyiaja baarijayurã mija imaokaro'si. Suᵽa imarĩ ika wejeareka ba'iaja baarimaja watoᵽekarã imariᵽotojo, “Tuᵽarãte yaᵽaika uᵽaka baairã nime. Dakoa oka imabeyua nareka”, mijareka narĩrãñu. I'suᵽaka jia baairã mija imarãkareka, Tuᵽarãte yaᵽairoka nare mija bearãñu. Suᵽa imarĩ Cristore ᵽe'rietarãñurĩmi “Nare yibojaeka uᵽakaja baarijayurã nime”, ãᵽaraka jĩjimakaᵽi kire sayibojarãñu. ");
INSERT INTO tnc_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","18","Tuᵽarãte yaᵽaika uᵽakaja Jesúrika bojariroka yibojariᵽareaja, yire najããrũjerãñu je'e aᵽeyari. I'suᵽakajaoka sayi'yurã imawa'ri, ba'iaja mija jũarijayua simako'omakaja mijaka jĩjimaka ñime. I'suᵽaka imaki imarĩ i'suᵽakajaoka yika mija imarika yiyaᵽayu yiro'si. ");
INSERT INTO tnc_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","Maiᵽamaki Jesúre yaᵽarãka uᵽakaja, ñojimarĩji mija ᵽõ'irã Timoteore yiᵽũatarãñu je'e, yimajaroka mijare kibojamaka jia mija ᵽuᵽayaokaro'si. I'suᵽaka simarãkareka õ'õrã ate kiᵽe'rietarãka ᵽoto mija majaroka yire kibojamaka ã'mitiritirã jia yiᵽuᵽarirãñu yiro'sioka. ");
INSERT INTO tnc_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","Jia mija imarika ᵽuᵽajoatiyaiki kimamaka, mija ᵽõ'irã kire yiᵽũatariyaᵽayu. Maki aᵽika kiuᵽaka ᵽuᵽajoaiki imabeyuka õ'õrã. ");
INSERT INTO tnc_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","Aᵽerã ᵽuri narĩmijitakaja nimarũkiakaka ᵽuᵽajoabaraka imarã. I'suᵽaka imawa'ri Jesucristore yaᵽaika uᵽaka baarijaririka ᵽuᵽajoabeyurã nime. ");
INSERT INTO tnc_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","I'suᵽaka ᵽuᵽajoairãte ima simako'omakaja, “Timoteo ᵽuri Jesucristore yaᵽaika uᵽakaja baarijayuka”, ãrĩwa'ri mija õñuka kime. I'suᵽaka kireka mija õñua imarĩ, “Kimaki uᵽakaja jia Ᵽablote kijeyobaarijayu, rĩkimabaji Cristorika bojariroka yi'yurãte imarika yaᵽawa'ri”, kireka ãñurã mija ime. ");
INSERT INTO tnc_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","Suᵽa imarĩ, “Ikuᵽaka ĩᵽarimarãre yire baarãñu”, ñarĩwãrũrãka ᵽoto, Timoteore mija ᵽõ'irã yiᵽũatarãñu yimajaroka mijare kibojaerã. ");
INSERT INTO tnc_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","Suᵽabatirã “Yi'ioka ñamajĩ naᵽõ'irã ya'rirãñu je'e aᵽeyari”, ñarĩᵽuᵽajoayu. I'suᵽaka yibaajĩka, ñiᵽamakire yire jeyobaarãkaᵽi ãrĩwa'ri suᵽa simarãñu. ");
INSERT INTO tnc_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","Majeyomaki Eᵽafroditore yire jeyobaaerã mija ᵽũataraᵽaka jia sime. Yijũaika uᵽakaja ba'iaja jũaiki kime kiro'si Cristorika bojariroka wãrõrimaji imarĩ. Suᵽabatirã “Cristorika bojariroka mija boja'si”, sã'mitiriᵽe'yoirãte ãñua imako'omakaja, yire jeyobaarimaji kime Eᵽafrodito. Jia yire jeyobaarimaji kimako'omakaja mija ᵽõ'irã kire yiᵽe'ataerã baayu. ");
INSERT INTO tnc_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","Ikuᵽaka sime: “Wãmarĩa yijaraᵽaka majaroka ã'mitiritirã, ba'iaja Filiᵽoskarãre ᵽuᵽayu je'e”, ãrĩwa'ri ba'iaja ᵽuᵽayuka imarĩ, mijare ĩarika kiyaᵽayu. ");
INSERT INTO tnc_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","Rita simaraᵽe, kũᵽajĩkaro'siji kireyarũkia jariwa'rikoᵽeko'omakaja Tuᵽarãte kire wayuĩamaka kitãrãᵽe. Yire ᵽariji wayuĩawa'ri, “Wẽkomaka imariwi'iarã kima ᵽoto ba'iaja kiᵽuᵽayua ᵽemawa'ribaji Eᵽafroditore reyamaka ba'iaja Ᵽablote ᵽuᵽaria'si”, ãrĩwa'ri, Tuᵽarãte kire tããraᵽe. ");
INSERT INTO tnc_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","I'suᵽaka simamaka ñojimarĩji mija ᵽõ'irã kire yiᵽe'ataerã baayu. Suᵽa imarĩ jia dakoa risirika ba'ijũaberikaki uᵽakaja mija ᵽõ'irã keyamaka ĩatirã jĩjimaka mija imarãñu. I'suᵽaka kire yiᵽe'atarãka be'erõ'õᵽi ᵽuri, ba'iaja ᵽuᵽaritiyabekaja ñimarãñu yi'ioka. ");
INSERT INTO tnc_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","30","Ñoakurirã mija ima simamaka marãkã'ã baatirã Cristorika bojariroka yiwãrõika yire mija jeyobaawãrũbeyu. “Kire kijeyobaarũ”, ãrĩwa'ri mija ᵽũataraᵽaki ᵽuri jia yire jeyobaaiki. I'suᵽaka imaki imariᵽotojo koiteje kireyakoᵽeraᵽaka simamaka jia jiyiᵽuᵽaka kire mija õᵽe. Jia jãjika mija ᵽõ'irã keyamaka jĩjimakaᵽi kire mija e'etoᵽe mija uᵽakaja Maiᵽamakiriki kima simamaka. Suᵽabatirã, i'suᵽakajaoka jia jiyiᵽuᵽaka mija õᵽe kiuᵽaka imarãte. ");
INSERT INTO tnc_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","Yijeyomarã, jia jĩjimaka mija imabe “Jesucristorirã yija ime”, ãrĩwa'ri. Bikija mijaro'si yo'oraᵽakakaka, maekakaoka jiaᵽi so'otirã mijare yiᵽũatayu ate, sĩatirã waᵽuju ᵽakirimajaroka bojarimajare mija yi'rikoreka. ");
INSERT INTO tnc_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","Werika yaiwẽkoa uᵽaka ba'iaja baairã nime. Suᵽa imarĩ ᵽakirikaᵽi sawãrõrimajare rakajekaja mija imabe. Suᵽabatirã “Tuᵽarãrirã imaokaro'si circuncisión baarika sime”, narĩᵽakirijayu. ");
INSERT INTO tnc_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","“Circuncisión baaekarã imarĩ Tuᵽarãrirã yija ime”, narĩkoᵽeika. Maa ᵽuri Tuᵽarãrirã maime. Cristore yi'yurã ᵽuri Esᵽíritu Santore mare jeyobaamaka Tuᵽarãte jia jiyiᵽuᵽaka morĩrijayu. Suᵽabatirã Jesucristore majiyiᵽuᵽayeeyu “Maro'si kireyaekaᵽi Tuᵽarãte mare wayuĩarijayu”, ãrĩwa'ri jĩjimaka maimarijayu. “Maᵽo'ia mabaaikaᵽi ãrĩwa'ri Tuᵽarãrirã majarirãñu”, ãrĩbeyurã maime. ");
INSERT INTO tnc_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","5","Karemarĩa yiñekiarãte ᵽuᵽajoaekaroka yiᵽuᵽajoarikareka “Moisére jã'mekakaka aᵽerãte yi'yua ᵽemawa'ribajirã jia sayi'yuka ñime”, ãñuka ñimajĩñu. Ĩakõrĩ je'e, ikuᵽaka ñimaeka bikija: “Tuᵽarãriki kimarũ”, ãrĩwa'ri ĩ'ᵽotẽñarirakarĩmi yiᵽo'ijirika be'erõ'õ circuncisión yire nabaaeka. Benjamín imaekakaki riᵽarãmi ñime judíotataki imarĩ. Suᵽabatirã aᵽika yiñekijioka kimaeka Abraham. Ĩ'rãtomajaja nimaeka yiñekiarã. I'suᵽaka imaekarã imarĩ, judíotatarã tiyiaja tĩmiaribu'atirã namakarãrikaki imarĩ, judíotataki takiji ñime. Suᵽa imarĩ fariseokaka ᵽuᵽajoaiki ñimaeka. I'suᵽakajaoka Moisés imaroyikakite Tuᵽarãte jã'mekakaka jia jiyiᵽuᵽaka sõᵽaraka sayi'yuka ñimakoᵽeka ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","I'suᵽaka sayi'ritiyawa'ri, “Cristore yi'yurã ᵽuri Moiséte jã'mekakaka riatarika ᵽakatayurã imarã”, ãrĩᵽuᵽajoakoᵽebaraka jimarĩa ba'iaja nare baawã'imañuka ñimaroyika. I'suᵽaka ñimamaka, “Moiséte jã'meka yi'ribeyuka Ᵽablote ime”, marã yireka ãrĩberiroyirekarã. ");
INSERT INTO tnc_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","8","I'suᵽaka ñimaeka simako'omakaja “Saᵽi ãrĩwa'ri, jĩjimaka Tuᵽarãte yika ime”, ãrĩbeyuka ñime mae. Maekaka ᵽuri Cristore yi'yuka ñimamaka bikija ñimakoᵽeroyiraᵽaka waᵽamarĩa ima. Suᵽabatirãoka maiᵽamaki Jesucristore õrĩrika ritaja tẽrĩwa'ribaji ima simamaka ritaja imakoᵽeika waᵽamarĩa ima yiro'si. Jiibaji kire õrĩriyaᵽawa'ri, “Ritaja yibaaroyiraᵽaka mirãka jia Tuᵽarãka ñimarũkiro'simarĩaja sime mirãkiyu”, ãrĩwãrũiki ñime mae. Suᵽa imarĩ ritaja yiro'si jiitaka imaeka mirãka ja'ataekaki ñime, Cristorikitakaja jayaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("PP3_9","080_3_9","PHP","3","9","9","Kiriki imarĩ, “Moiséte jã'meka yi'riwa'ri Tuᵽarãka jia ñime”, ñarĩbeyu. Cristore yi'riwa'ri takaja ᵽuri jia Tuᵽarãka ñime. Saᵽi ãrĩwa'ri Tuᵽarã ñakoreka ba'iaja baabeyuka ñime mae. ");
INSERT INTO tnc_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","Suᵽa imarĩ, ikuᵽaka simamaka jiibaji Cristore ñorĩriyaᵽayu: Reyariᵽotojo Tuᵽarãte õñia kire jarirũjekaᵽi ãrĩwa'ri kiyaᵽaika uᵽakaja ñimariyaᵽayu. Suᵽabatirãoka kika rĩrãkibiyuka imarĩ, ba'iaja Cristore jũaeka uᵽakaja Tuᵽarãte yi'riwa'ri ba'iaja yijũarãkareka, marã imabeyua. I'suᵽaka imawa'ri Cristore reyaeka uᵽakaja jia Tuᵽarãte yiyi'ririyaᵽayu yireyarãka rõ'õjĩrã. ");
INSERT INTO tnc_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","I'suᵽaka ñime, “Yireyarãka be'erõ'õᵽi õñia Tuᵽarãte yire jarirũjerãñu”, ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","Ritaja mijaro'si yo'oika “Yi'i ᵽuri koᵽakaja sayi'riᵽatatirã Tuᵽarãte yaᵽaika uᵽakaja jaritiki mae”, ãrĩwa'rimarĩa ñañu. I'suᵽaka simamaka, Cristore ima uᵽakaja imarika yaᵽawa'ri kiyaᵽairokaᵽi ñimarijayu, saja'atabekaja. I'suᵽaka yibaarijayu kiuᵽakaja jia baaiki ñimaerã yire kiwã'maeka simamaka. ");
INSERT INTO tnc_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","Mija ã'mitiᵽe yijeyomarã. “Cristore ima uᵽaka takaja jaritiki ñime”, ãrĩbeyuka yi'i. Ikuᵽaka sime: Jia sareka baabaraka ñimaroyiraᵽaka ᵽuri ᵽuᵽajoarija'atarijayuka ñime. Saᵽuᵽajoabekaja yiruᵽurõ'õ Cristore yaᵽaika uᵽaka oyiaja yiᵽuᵽajoarijayu. Kiyaᵽaika uᵽakaja yibaaokarãka rõ'õjĩrãja yibaarãñu. ");
INSERT INTO tnc_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","Cristore imarokaᵽi imaki jaririka yaᵽawa'ri, õñia ñimatiyikuriji i'suᵽaka baarika ja'atabeyuka ñime. I'suᵽaka baawa'ri, sawaᵽa yitõᵽorãñu Tuᵽarã ᵽõ'irã yeyarãka ᵽoto. Suᵽa imarĩ Jesucristore yiro'si reyaeka simamaka mabo'ikakurirã Tuᵽarãte yire imarũjerãñu õñia Jesúka ñimajiᵽaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","Suᵽa imarĩ, yiᵽuᵽajoaika uᵽaka oyiaja mija ᵽuᵽajoabe ritaja jia Cristore yi'yurã uᵽatiji. I'suᵽaka imariᵽotojo aᵽerõ'õᵽañakarã mija ᵽuᵽajoaika waarĩkajĩkareka jia samija õñaokaro'si Tuᵽarãte mijare jeyobaarãñu. ");
INSERT INTO tnc_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","Mia je'e: Tuᵽarãte yaᵽaika morĩwaᵽu'atatika rõ'õjĩrãrãja kiyaᵽaika uᵽakaja maimaye'e. ");
INSERT INTO tnc_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","Yijeyomarã, suᵽa imarĩ, Tuᵽarãte yaᵽaika uᵽaka ñimara'aeka uᵽakaja mija imarijaᵽe mijaro'si. Mija wãjitãji yija baaraᵽaka uᵽakaja torã imarãte baarijaᵽakã'ã nareka ĩaji'abaraka mija imabe. ");
INSERT INTO tnc_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","19","Ĩ'rãrimarã ᵽuri “Cristore yi'yurã yija ime”, ãrĩriᵽotojo, ba'iaja imarijayurã. Suᵽabatirãoka ba'iaja baarika maja'ataokaro'si yaᵽua tetaekarã Cristore reyaekakaka waᵽamarĩa uᵽakaja naro'si sime. Tuᵽarãte yaᵽaika uᵽaka baabekaja, naᵽuᵽakaᵽi nabaarijitoika uᵽakaja baarijayurã nime. Suᵽabatirãoka, i'yorimarĩaja jĩjimakaᵽi najeyomarãre sanabojarijayu. I'suᵽaka nabaarijayu Cristore yi'ribeyurãte baaika takaja ᵽuᵽajoairã imarĩ. I'simijiᵽi ãrĩwa'ri ba'iaja imarika tiyibeyurõ'õrã a'rirũkirã nime. I'suᵽaka nimarijayuakaka ĩ'rãkurimarĩa mijare yibojatika uᵽakaja, mijare sayibojaᵽe'ayu ate ba'iaja nareka ᵽuᵽariwa'ri. ");
INSERT INTO tnc_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","Jesucristore yi'yurã maimamaka, maro'si ᵽuri i'suᵽakamarĩa sime, mabo'ikakuri maimajiᵽarũkirõ'õ maro'si ima simamaka. Suᵽabatirãoka “Mabo'ikakurirõ'õᵽioka maiᵽamaki Jesucristore i'tarãñu ba'iaja majũarũkia imaekareka mare tããrĩ”, ãrĩᵽuᵽajoawa'ri jĩjimaka maime. ");
INSERT INTO tnc_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","Suᵽa imarĩ maᵽo'ia reyarũkia imakoᵽeika kio'arãñu jiika kima uᵽaka simaokaro'si. I'suᵽaka mare kibaarãñu ritaja baawãrũᵽataiki imarĩ. ");
INSERT INTO tnc_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","Suᵽa imarĩ, yijeyomarã, jia mija ã'mitiᵽe. Mijare wãtaka õñuka imarĩ, jimarĩa mijare ñiariyaᵽayu. Jĩjimakaᵽi mijareka ñarĩᵽuᵽajoarijayu. I'suᵽaka mijare yo'oika uᵽakaja jia maiᵽamakire Jesucristore jia yi'ᵽaraka mija imarijaᵽe. ");
INSERT INTO tnc_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","Jiama mijare ñañu Evodia, Síntiqueᵽitiyika ĩ'ᵽakorãwã'taja ĩ'rãko uᵽakaja mija ᵽuᵽajoabe, Maiᵽamakire yi'riwa'ri kirirã mija ima simamaka. ");
INSERT INTO tnc_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","Suᵽa imarĩ tokaki, jia yire jeyobaaraᵽaki, jia Evodia, Síntiqueᵽitiyika ĩ'ᵽakorãre mijeyobaabe oka najiebu'arũ ãrĩwa'ri. I'suᵽaka ñañu Cristorika bojariroka bojabaraka torã ñimaraᵽaka ᵽoto jia yire jeyobaaraᵽarã nimamaka. I'suᵽaka yika nimaraᵽaka ᵽoto imaraᵽakioka Clemente, suᵽabatirã ritaja aᵽerã yire jeyobaarimaja. Yire jeyobaaraᵽarã, “Ikarakamarã nime yika imajiᵽarũkirã”, ãrĩwa'ri nawãmea kiᵽõ'irã Tuᵽarãte o'ojĩ'aekarã. ");
INSERT INTO tnc_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","Mija ĩabe. Maiᵽamakirirã mija ima ᵽuᵽajoawa'ri mija jĩjimaaᵽe. Suᵽabatirã i'sirokaoka ate mijare ñarĩᵽe'ayu jĩjimaitakaja mija imarijaᵽe ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","6","Suᵽabatirãoka jia oyiaja aᵽerãte mija baarijaᵽe “Jiiᵽuᵽarã nime”, ritaja mijareka nañaokaro'si. Ikuᵽaka mija õᵽe: No'ojĩrãmarĩaja sajariwa'yu õ'õrã Maiᵽamakire etarũkia. Saᵽi ãrĩwa'ri wayuᵽiribekaja mija imabe. Ba'iaja ᵽuᵽarikoᵽakaja mija yaᵽaikareka Tuᵽarãte jẽñebaraka mija imarijaᵽe. Mañu uᵽakaja ã'mitiyuka kimamaka, “Jiitaka oyiaja yire mibaayu Tuᵽarã”, kire ãᵽaraka mija imarijaᵽe. ");
INSERT INTO tnc_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","Ka'wisika jũariᵽotojo ba'iaja ᵽuᵽaᵽekaja mija imaerã, Tuᵽarãte mijare jeyobaarijarirãñu Jesucristorirã mija imamaka. Suᵽa imarĩ ka'wisika jũariᵽotojo “¿Marãkã'ã simamaka ba'iaja ᵽuᵽaᵽekaja sareka maime?”, ãñurã mija imarãñu. ");
INSERT INTO tnc_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","Yijeyomarã, ikuᵽaka sime: Wãjimijikaka oyiaja ᵽuᵽajoabaraka mija imarijaᵽe. I'suᵽakajaoka ᵽo'imajare jiyiᵽuᵽaka õrĩrikakaka, jiiroka takaᵽi oyiaja imarikakakaoka mija ᵽuᵽajoabe. Suᵽabatirã jiitakaja ima simamaka jĩjimaka ᵽo'imajare ã'mitiyu oyiaja ᵽuᵽajoabaraka mija imabe. ");
INSERT INTO tnc_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","Suᵽabatirãoka, mijare yiwãrõraᵽaka uᵽakaja baabaraka mija imabe. Ritaja yibaaraᵽaka, mijare yijairaᵽakaoka koᵽakaja õñurã mija ime. I'suᵽaka baabaraka mija imarãkareka okamirãmarĩaja mijare imarũjebaraka Tuᵽarãte mijakaja imajiᵽarijarirãñu. ");
INSERT INTO tnc_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","Jia yire mija baayu, yire wayuĩawa'ri yiyaᵽaika yire mija ᵽũataika. Suᵽa imarĩ, jĩjimakaᵽi “Jiitaka yire mibaayu”, Tuᵽarãte ñañu. Ñoaka yire saᵽũataerã mija ba'eraᵽaka simako'omakaja “Marãkã'ã saᵽũataberiwa'ri suᵽa nabaaraᵽe je'e”, mijareka ñarĩᵽuᵽajoayu. ");
INSERT INTO tnc_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","“Jimarĩtakaja sayiyaᵽakoᵽeraᵽe”, ãrĩwa'rimarĩa i'suᵽaka ñañu, rĩkimaka yirikajĩka, dakomarĩa ñimakoᵽeikaoka yiyaᵽaika uᵽakaja jĩjimakaᵽi oyiaja imawãrũtikaki ñime. ");
INSERT INTO tnc_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","I'suᵽaka simamaka yiba'arũkia ima ᵽoto, simabeyu ᵽotooka Cristore yire jeyobaaika simamaka okamirãmarĩaja ñimarijayu. Suᵽabatirãoka wayuoka baaiki ñima ᵽoto, yiyaᵽaika yireka ima ᵽotooka jĩjimaka oyiaja ñime. ");
INSERT INTO tnc_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","Cristore yire jeyobaamaka, ritaja ka'wisika, ka'wisimarĩaoka i'suᵽaka imawãrũtikaki ñime. ");
INSERT INTO tnc_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","I'suᵽaka ñimako'omakaja yire jeyobaawa'ri niñerũ yire mija ᵽũataraᵽaka jiitakaja yire mija baaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","16","Filiᵽoskarã, yire mija jeyobaaraᵽakaᵽi ãrĩwa'ri mija ka'ia Macedoniaᵽi ya'raᵽe aᵽerõ'õrã wãrõtaᵽaokaro'si. Mamarĩtaka Cristorika bojariroka yi'yurã mija jaraᵽaka be'erõ'õ i'suᵽaka yire mija jeyobaaraᵽe. Aᵽerõ'õkarã ᵽuri nare yiwãrõmaka Cristore ã'mitiriᵽẽaraᵽarã imariᵽotojo, i'suᵽaka yire jeyobaaberaᵽarã. Mija ᵽuri, Tesalónicawejearã ñimaraᵽaka ᵽoto ĩ'rãkurimarĩa niñerũ yire ᵽũataraᵽarã. ");
INSERT INTO tnc_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","“Ate i'suᵽakajaoka niñerũ yire mija ᵽũatajiᵽarika yiyaᵽayu”, ãrĩwa'rimarĩa i'suᵽaka mijare ñañu. Jia yire mija baamaka sawaᵽa jia Tuᵽarãte mijare ja'atarika ᵽuri yiyaᵽayu. ");
INSERT INTO tnc_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","Yire mija ᵽũataraᵽaka ᵽuri simaja Eᵽafroditore yire ĩjiraᵽe. Yire sakĩjiraᵽaka ᵽoto sañiamaka yiᵽuᵽajoaraᵽaka ᵽemawa'ribajirã yiro'si mija ᵽũataeka mirãkiraᵽe. I'suᵽaka mija baaraᵽakaᵽi ãrĩwa'ri jia jĩjimaka Tuᵽarãte mijaka ime. ");
INSERT INTO tnc_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","Suᵽabatirã ritaja jia oyiaja ima ĩᵽamaki kime Tuᵽarã. I'suᵽaka imaki imarĩ Jesucristorirã mija imamaka ritaja mija yaᵽaika uᵽakaja mijare ĩjirimaji kime. ");
INSERT INTO tnc_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","I'suᵽaka simamaka Maᵽaki Tuᵽarãte jĩjimakaᵽi majiyiᵽuᵽayeejiᵽaye'e. I'suᵽaka oyiaja simarijarirũ. ");
INSERT INTO tnc_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","Mae torã imarã, Cristore ã'mitiriᵽẽairãro'si “Jia mija imabe”, ãrĩwa'ri oka yiᵽũatayu. Suᵽabatirã yika Jesúre yi'ᵽaraka imarãoka i'suᵽakajaoka mijaro'si ᵽũatairã. ");
INSERT INTO tnc_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","I'suᵽakajaoka ritaja Cristore yi'yurã õ'õrã imarãte mijareka ãñu. Suᵽabatirã Romakaki ĩᵽiro'si ba'iraberimaja Cristore yi'yurã i'suᵽakajaoka ãñurã. ");
INSERT INTO tnc_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","Jia maiᵽamaki Jesucristore mijare baarijarirũkirãro'siji mija imarũ mijareka ñañu. I'tojĩrãja sime ruᵽu.");
INSERT INTO tnc_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","¿Yaje mija ime Tesalónicawejeakarã? Yi'i Ᵽablo, suᵽabatirã majeyomarã Silvano, Timoteoᵽitiyika ika ᵽaᵽera mijaro'si yija ᵽũatayu. I'suᵽaka mijaro'si sayija ᵽũatayu Maᵽaki Tuᵽarãrirã, suᵽabatirã maiᵽamaki Jesucristorirãoka mija imamaka. I'suᵽaka simamaka Maᵽaki Tuᵽarãte jia mijare baarũ, jia mija imaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("H11_2","082_1_2","1TH","1","2","3","I'suᵽakajaoka mijaka jĩjimaka imawa'ri, “Jia mibaayu Tuᵽarã”, mijaro'si kire yija ãrĩrijayu. I'suᵽaka mijaro'si yija baarijayu, mijaka yija imaroyiraᵽaka ᵽoto, Jesucristore yi'yurã imarĩ, jia kiro'si mija baaroyiraᵽaka yija õñua simamaka. Ã'mitirikõrĩ je'e: Wayuĩabu'airã imarĩ, jia mija jeyobaabu'aroyiraᵽe. I'suᵽakajaoka “Rita sime maiᵽamaki Jesucristore ate ᵽe'rietarũkia”, ãñurã imarĩ, ba'iaja jũarika mija rakajeᵽããrijariroyiraᵽe. I'suᵽaka mija imamaka, ĩ'rãkurimarĩa Maᵽaki Tuᵽarãte mijaro'si yija jẽñeĩjirijayu. ");
INSERT INTO tnc_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","Mija ã'mitiᵽe yijeyomarã, Tuᵽarãte mijare wayuĩarijayu. I'suᵽakajaoka “Tuᵽarãte nare wã'maeka”, yija ãrĩᵽuᵽajoayu mijareka. ");
INSERT INTO tnc_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","Jesucristorika bojariroka mijare yija wãrõu'muraᵽaka ᵽoto okatakaᵽimarĩa mijare sayija wãrõraᵽe. Esᵽíritu Santore yijare jeyobaaraᵽakaᵽi ãrĩwa'ri jia mijare sayija wãrõraᵽe. I'suᵽaka yija baaraᵽaka simamaka “Rita sime ika majaroka”, ãrĩᵽuᵽajoawãrũraᵽarã imarĩ, samija ã'mitiriᵽẽatiyaraᵽe. Suᵽabatirãoka mija ᵽõ'irã yija imaraᵽaka ᵽoto jia yija baaroyiraᵽaka ĩaraᵽarã imarĩ, “Jia maimaokaro'si maᵽõ'irã netaraᵽe. Ritaitaka oka namajaroka ma'mitiriroyi mirãkiyu”, ãrĩwãrũraᵽarã mija ime. I'suᵽaka ᵽuᵽajoaraᵽarã mija imamaka, “Tuᵽarãte wã'maekarã nime”, mijareka yija ãrĩᵽuᵽajoayu. ");
INSERT INTO tnc_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","Tuᵽarãrika bojariroka mija yi'ᵽakã'ã ĩawa'ri, aᵽerãte ba'iaja mijare baako'omakaja, Esᵽíritu Santore jeyobaaraᵽakaᵽi ãrĩwa'ri jĩjimakaᵽi samija ã'mitiraᵽe. “Ᵽablorãkaro'si, Jesúro'sioka i'suᵽakaja simaeka”, ãrĩwãrũwa'ri, jĩjimakaᵽi sã'mitiritirã samija yi'raᵽe mijaro'sioka. ");
INSERT INTO tnc_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","I'suᵽaka mijaro'si simaraᵽaka simamaka Macedonia ka'iareka imarã suᵽabatirã Acaya ka'iarãoka jia mija imaroyiraᵽaka ĩaji'araᵽarã imarĩ, mija uᵽakajaoka tokarã Jesucristore ã'mitiriᵽẽarijayurãte baaroyiraᵽe naro'si. ");
INSERT INTO tnc_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","Suᵽa imarĩ Maiᵽamakirika bojariroka Macedonia ka'iakarã, Acaya ka'iakarã takajamarĩa imaraᵽarã sã'mitiraᵽarã. Suᵽabatirã “Jesúrika bojariroka jia yi'yurã nime”, mijareka narĩᵽuᵽajoarijayu. I'suᵽaka simamaka, aᵽerãte dirokaᵽi ãrĩwa'ri rĩkimaitakaja yija bojaberijĩka sime, koᵽakaja ritaja sana'mitiriwãrũtiika simamaka. ");
INSERT INTO tnc_vpl VALUES ("H11_9","082_1_9","1TH","1","9","10","I'suᵽaka simamaka, “Jesucristorika bojariroka nare mija wãrõeka jia Tesalónicakarãre yi'yu”, ãrĩwa'ri yijare nabojayu. “ ‘Waᵽuju imaja jẽrãka jiyiᵽuᵽaka norĩkoᵽeroyiraᵽaka ja'ataraᵽarã nime, Tuᵽarã õñia imakite takaja jiyiᵽuᵽayeewa'ri. Suᵽabatirãoka Tuᵽarã Maki, Jesús mabo'ikakurirã maekaka imaki õ'õrã etarũkika kime. Ikiji imaki ᵽo'imajare kire jããeka simakoᵽeko'omakaja õñia Tuᵽarãte kire jarirũjeka. Suᵽa imarĩ ba'iaja wẽkomakareka maimarũkia imakoᵽeikareka Jesúre mare tããeka. I'suᵽaka simamaka jia Tuᵽarãka imarã imarĩ, Jesúre etarũkia jĩjimakaᵽi ta'abaraka maimaerã’, ãᵽaraka ᵽo'imajare bojabaraka nimarijayu”, ãrĩwa'ri yijare nabojayu. ");
INSERT INTO tnc_vpl VALUES ("H12_1","082_2_1","1TH","2","1","2","Mija ã'mitiᵽe yija jeyomarã. Mija ᵽõ'irã eyarĩ yija a'raᵽaka ᵽoto Filiᵽoswejearã mamarĩ yija eyaũ'muraᵽe. Torã yija imaraᵽaka ᵽoto yijare jiyiᵽuᵽayeebekaja jimarĩa ba'iaja yijare nabaaraᵽe. Mija wejearã yija eyaraᵽaka ᵽoto rĩkimarãja yijare jo'ata'airãte imako'omakaja okajãjia yija imaokaro'si Tuᵽarãte yijare jeyobaaraᵽe. Suᵽa imarĩ, “Ika majaroka mija bojaᵽibarika yija yaᵽabeyu”, mija wejeakarãre yijare ãrĩkoᵽeko'omakaja, kirika bojarirokakakaᵽi kĩkirimarĩaja mijare yija bojaraᵽe. Suᵽa yija baaraᵽaka õrĩtiirã imarĩ, “Jia maimaerã Ᵽablorãkare mare wãrõraᵽe. Maᵽõ'irã nimaraᵽaka ᵽoto rĩkimarãja ᵽo'imaja Jesucristorika bojariroka yi'raᵽarã”, yijareka ãñurã mija ime. ");
INSERT INTO tnc_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","I'suᵽaka simamaka waᵽuju jairimirãkamarĩa mijare yija majarobojaroyiraᵽe. Rita imaroka mijare yija wãrõraᵽe. Suᵽabatirã mijare yija ᵽakiberaᵽe. Jía yija tõᵽookaro'si ba'iaja ᵽuᵽarirokaᵽimarĩa mijare yija bojaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","Yijare õrĩwãrũiki imarĩ, “Yiyaᵽaika uᵽakaja baairã nime”, yijareka ãrĩᵽuᵽajoaekaki Tuᵽarã. Suᵽa imarĩ yijare kiᵽũataeka kirika bojariroka yija wãrõokaro'si. I'suᵽaka simamaka kiyaᵽaika uᵽakaja yija baarijayu. Ã'mitirikõrĩ je'e: ikuᵽaka sime: Tuᵽarãte jĩjimaka yijaka imarika takaja yaᵽarijayurã yija ime. Jĩjimaka ᵽo'imaja yijaka imarũ ãrĩwa'rimarĩa nare yija wãrõyu. ");
INSERT INTO tnc_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","Yija wãrõraᵽaka mija ã'mitirijiyuokaro'si waᵽuju jia mijaka jaiberaᵽarã yija. I'suᵽakajaoka niñerũ sawaᵽa tõᵽokaro'simarĩa mijare sayija wãrõraᵽe. Tuᵽarãte yijare ĩaika wãjitãji rita mijare ãñurã yija ime. ");
INSERT INTO tnc_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","Suᵽa imarĩ “Jiitarã mija ime”, ᵽo'imajare yijareka ãñaokaro'simarĩa mijare sayija wãrõraᵽe. ");
INSERT INTO tnc_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","Aᵽóstolrãka yija imako'omakaja, mijare jã'merũkirã uᵽarã yija imakoᵽeraᵽe. I'suᵽaka baarimarĩaja rõmo komakarãte wayuĩaiko imarĩ nare kowãtaika uᵽakaja mijare yija baaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","Mijare wayuĩawa'ri jĩjimakaᵽi Tuᵽarãrika bojariroka mijare yija wãrõriyaᵽatiyaraᵽe. I'siatakajaro'simarĩa, ritaja yija baawãrũikarõ'õjĩrãja mijare yija jeyobaariyaᵽaraᵽe, mijare wayuĩairã imarĩ. ");
INSERT INTO tnc_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","Mija ã'mitiᵽe yijeyomarã. Mija ᵽõ'irã yija imaraᵽaka ᵽoto jãjia yija ba'iraberaᵽaka mija õñu. Yija ba'iraberiwatoᵽekarekaja Tuᵽarãrika bojariroka mijare yija wãrõraᵽe waᵽamarĩaja. Ñami, ĩmi ᵽariji i'suᵽaka yija baaraᵽe yija yaᵽaraᵽaka mijare jẽñekoreka. ");
INSERT INTO tnc_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","Mija ᵽõ'irã yija imaraᵽaka ᵽoto jia oyiaja mijaka yija imaroyiraᵽe. I'suᵽaka imaroyiraᵽarã imarĩ, Tuᵽarãte yaᵽaika uᵽakatakaja yija baarijariroyiraᵽe. I'suᵽaka yija imamaka ĩawa'ri, “Jia oyiaja baarijayurã nime”, yijareka ãñurã mija ime. I'suᵽaka simamaka yijare mija ĩaika uᵽakajaoka Tuᵽarãte yijare ĩayu kiro'si. ");
INSERT INTO tnc_vpl VALUES ("H12_11","082_2_11","1TH","2","11","11","Suᵽa simamaka “Jiitakaja yijare nawãrõraᵽe”, yijareka ãñurã mija ime. Suᵽa simamaka ĩ'rĩka kimakire wayuĩaika uᵽakaja jia mijare yija baamaka mija õñu. ");
INSERT INTO tnc_vpl VALUES ("H12_12","082_2_12","1TH","2","12","12","I'suᵽaka baaraᵽarã imarĩ, jia ᵽuᵽaᵽaraka okajãjia mija imaerã “Tuᵽarãte yaᵽaika uᵽaka oyiaja mija baarijaᵽe jĩjimaka mijaka kimaokaro'si”, ãᵽaraka mijare yija bojaroyiraᵽe. I'suᵽaka mijare yija bojaroyiraᵽe jiitakaᵽi mijare kiwã'mayu kijã'merũkirã mija imaokaro'si. Suᵽabatirã mijare kiakayu tẽrĩwa'ribaji kima mija õñaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","Suᵽa imarĩ, Tuᵽarãrika bojariroka mijare yija bojaraᵽaka ᵽoto, “Naᵽuᵽaka nare ãñua ᵽuᵽajoaᵽakitirãmarĩa yijare nawãrõraᵽe. Rita Tuᵽarãrika bojariroka sime”, ãrĩᵽuᵽajoairã mija imaraᵽe. Rita mija ᵽuᵽajoayu, Tuᵽarãrika bojariroka sime. Sayi'yurã mija imamaka, kiyaᵽaika uᵽaka oyiaja mija baawãrũerã mijare kijeyobaarijayu. I'suᵽaka simamaka, mijare ᵽuᵽajoawa'ri, “Jia mibaayu Tuᵽarã”, kire yija ãrĩrijayu. ");
INSERT INTO tnc_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","Yijeyomarã, Judeaka'iakarã, Jesucristore jiyiᵽuᵽaka õñaokaro'si rẽrĩrijayurã uᵽaka mija jayu mae. Mija wejeakarãre ba'iaja mijare baata'amaka ba'iaja mija jũarijayu uᵽakajaoka najũarijayu Judeaka'iarã Jesucristorirã naro'si. ");
INSERT INTO tnc_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","Ã'mitirikõrĩ je'e: Judíorãka kire yi'riberikatata nimaeka maiᵽamaki Jesucristore jããekarã. Nañekiarãoka i'suᵽakaja baarijarikarã Tuᵽarãro'si bojaĩjirimaja imaroyirekarãte. I'suᵽaka baara'aekarã uᵽaka imarã maekakaoka ĩ'rãkurimarĩa nawejeaᵽi yijare ᵽoatarijayurã. I'suᵽaka imarã imarĩ, ritaja ᵽo'imajare majamarã nime. Suᵽa imarĩ ba'iaja Tuᵽarãte naka ime. ");
INSERT INTO tnc_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","Ritaja ᵽo'imaja majamarã imarĩ, “Judíotatamarĩrãteoka Jesúre tããriyaᵽayu”, ãrĩwa'ri nare yija bojamaka judíotatarãre yijare sabojarũjebeyu. Rĩkimakaja ba'iaja nabaarijayua imatika imako'omakaja ĩ'rãrĩmi uᵽakaja ba'iaja nabaarijayu. Bikijarãja i'suᵽaka nabaarijarika ĩara'aekaki imarĩ, “Ba'iaja nabaarijayu waᵽa ba'iaja nare yijũarũjerũkirĩmi no'ojĩrãmarĩa sajariwa'yu sarã seyarũkia”, Tuᵽarãte ãrĩᵽuᵽajoayu. ");
INSERT INTO tnc_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","Mija ã'mitiᵽe yijeyomarã. Mijare yija ᵽe'ritaᵽaraᵽaka be'erõ'õᵽi no'ojĩrãmarĩaja mijareka yija ᵽuᵽajoaraᵽe ate. Mija ᵽõ'irã imabeririᵽotojo yija ᵽuᵽakaᵽi ᵽuri mija ᵽõ'irã imarã uᵽakaja yija imaraᵽe. Suᵽa imarĩ, ate jimarĩa mija ᵽõ'irã a'rirã yija rutukoᵽeraᵽe. ");
INSERT INTO tnc_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","Yi'i Ᵽablo ĩ'rãkurimarĩa mija ᵽõ'irã a'ririka yirutukoᵽeraᵽe. I'suᵽaka ñimako'omakaja, Satanáre yiro'si satá'teroyiraᵽe. ");
INSERT INTO tnc_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","I'suᵽaka mijareka ᵽuᵽajoairã imarĩ, maiᵽamaki Jesúre etarãka ᵽoto, ikuᵽaka kire yija ãrĩrãñu: “Tesalónicakarã mirika bojariroka nare yija wãrõraᵽaka ᵽoto, jia sayi'raᵽarã. Suᵽa imarĩ, ja'atarimarĩaja jia sayi'rimirĩrĩkawa'yurã nime”, ãrĩwa'ri jĩjimakaᵽi kire yija bojarãñu. I'suᵽaka kire bojarũkirã imarĩ, mijaka yija imariyaᵽayu ate. Aᵽerã tẽrĩwa'ribaji mijareka ᵽuᵽajoawa'ri, jĩjimaka yija ime. ");
INSERT INTO tnc_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","Rita sime, jia mijareka ᵽuᵽaritirã jĩjimaka yija õñurã mija ime. ");
INSERT INTO tnc_vpl VALUES ("H13_1","082_3_1","1TH","3","1","2","I'suᵽaka simamaka mija majaroka ã'mitiririka yaᵽairã imarĩ, sarakajeᵽããwãrũberiwa'ri yija jeyomaki Timoteore mija ᵽõ'irã yija ᵽũataraᵽe. Yuᵽakajaoka Tuᵽarãte ba'irabeĩjirimaji imarĩ, Jesucristorika bojariroka bojataᵽarimaji kima õñurã mija ime. I'suᵽaka imaki kimamaka, jiibaji Jesucristore mija yi'yaokaro'si, suᵽabatirã ba'iaja jũariᵽotojo, sarakajeᵽããekaja mija imaokaro'si mija ᵽõ'irã kire yija ᵽũataraᵽe. Yija ĩ'ᵽarã ᵽuri Atenas wãmeika wejearã tuiraᵽarã. ");
INSERT INTO tnc_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","Ba'iaja jũawa'ri, ba'iaja naᵽuᵽaria'si ãrĩwa'ri Jesucristorika bojariroka mija ja'atakoreka mija ᵽõ'irã kire yija ᵽũataraᵽe. Ã'mitirikõrĩ je'e: Jesúre yi'yurã maimamaka, aᵽerãte ba'iaja mare baayu. “I'suᵽakaja yire yi'yurãro'si simarãñu”, Tuᵽarãte ãrĩtika simamaka, kire yi'ᵽaraka sarakajeᵽããrũkirã maime. ");
INSERT INTO tnc_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","I'suᵽakajaoka mijaka yija imaraᵽaka ᵽoto “Jesúre yi'yurã mija imamaka, ba'iaja aᵽerãte mijare baarãñu”, ãrĩwa'ri mijare yija bojatiraᵽe. Mijare yija bojaraᵽaka uᵽakaja mijaro'si simaraᵽaka simamaka, jia sõrĩwãrũtikarã mija ime mae. ");
INSERT INTO tnc_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","I'suᵽaka simamaka “Jesucristore naja'ataokaro'si Satanáre koᵽakaja nare ᵽakitiraᵽe je'e aᵽeyari”, ãrĩwa'ri ba'iaja mijareka yiᵽuᵽaraᵽe. I'suᵽakajaoka “Nare kitẽrĩrãkareka waᵽuju waᵽamarĩa nare yija wãrõkoᵽeraᵽaka jarirãka je'e aᵽeyari”, mijareka ñarĩᵽuᵽajoaraᵽe. I'suᵽaka jũairã mija imamaka, mija majaroka õrĩrika rakajeᵽããwãrũberiwa'ri Timoteore mija ᵽõ'irã yiᵽũataraᵽe. ");
INSERT INTO tnc_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","Mae mija ᵽõ'irã turaᵽaki Timoteore õ'õrã ᵽe'rietayu. Suᵽa imarĩ õ'õrã etatirã mijamajaroka yijare kibojayu. Ikuᵽaka kẽñu: “Jesucristore jia yi'ririjayurã nime ruᵽu, ãrĩwa'ri. Suᵽabatirã i'suᵽakajaoka wayuĩabu'airã nime. ‘Mijareka jia yija ᵽuᵽajoayu’, nañu”, ãrĩwa'ri yijare kibojaetayu. Suᵽabatirãoka “ ‘Yijare mija ĩariyaᵽarijayu uᵽakajaoka mijare ĩarika yija yaᵽakoᵽeroyi’, nañu”, ãrĩwa'ri kibojayu. ");
INSERT INTO tnc_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","I'suᵽaka mijareka kẽñua ã'mitiritirã “Jesúre nayi'ririja'atabeyu mirãkiyu”, ãrĩwa'ri ba'iaja jũarijayurã imariᵽotojo jĩjimaka yija ime. ");
INSERT INTO tnc_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","“Cristore jiaᵽi yi'riñujurã nime ruᵽu”, kẽᵽakã'ã ã'mitiritirã jia yija ᵽuᵽayu mae. ");
INSERT INTO tnc_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","I'suᵽaka mija imamaka, mijareka ᵽuᵽajoabaraka, “Jia mibaayu Tuᵽarã”, yija ãrĩrija'atabeyu. I'suᵽakajaoka Tuᵽarãka yija jaika ᵽoto, “Jesucristore jia yi'yurã nimamaka jia mibaayu”, ãrĩᵽuᵽajoawãrũtirã jia jĩjimaka mijare yija õñu. ");
INSERT INTO tnc_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","Ĩmiareka, ñamiareka ᵽariji Tuᵽarãte yija jẽñerijayu, mija ᵽõ'irã yija eyaokaro'si yijare kijeyobaaerã. Mija ᵽõ'irã yija a'ririyaᵽayu, jiibaji Jesucristore mija ã'mitiriᵽẽaokaro'si mija õrĩbeyua mijare yija wãrõerã. ");
INSERT INTO tnc_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","Mija ᵽõ'irã ĩarĩ yija a'rirã Maᵽaki Tuᵽarã, suᵽabatirã maiᵽamaki Jesucristore jia yijare jeyobaarũ. ");
INSERT INTO tnc_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","Jiibaji wayuĩabu'abaraka mija imarijarirã Maiᵽamakire mijare jeyobaarũ, i'suᵽakaja mijaro'sioka aᵽerãte mija wayuĩaerã kijeyobaarũ. I'suᵽaka mijare kibaarũ, mijare yija wayuĩamirĩrĩkawa'yu uᵽakaja mija imaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","I'suᵽaka maiᵽamaki Jesúre yija jẽñeyu, jia oyiaja mija baaerã kijeyobaaokaro'si. I'suᵽaka mijare kijeyobaamaka, wãjia ᵽuᵽajoairã mija imarãñu. Suᵽa imarĩ, maiᵽamaki Jesúre, kirirãka ᵽe'rietarãñurĩmi, Maᵽaki Tuᵽarãte ĩarãka wãjitãji, dakoa okamirãmarĩaja mija imarãñu. Ikuᵽaka oyiaja simarijarirũ. ");
INSERT INTO tnc_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","Mae ate yija jeyomarã, aᵽea mijaro'si yo'oerã baayu. “Ikuᵽaka mija imarãkareka, jĩjimaka Tuᵽarãte mijaka imarãñu”, ãrĩwa'ri mijare yija wãrõraᵽe. “I'suᵽakaja imarijayurã nime ruᵽu”, mijareka yija ãñu. Kiyaᵽaika uᵽaka oyiaja jiibaji mija baarijaririka yija yaᵽayu. I'suᵽaka mijare yija okajããrijayu mijare yija wãrõokaro'si Maiᵽamakire yijare jã'meka simamaka. ");
INSERT INTO tnc_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","Maiᵽamaki Jesúre yijare jã'meka uᵽakaja yija wãrõraᵽaka õrĩtikarã mija ime. ");
INSERT INTO tnc_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","Suᵽa imarĩ rõmimarĩka, tĩmiamarĩko, suᵽabatirã rõmiki, tĩmiaiko, ba'iaja baabu'arika imabeyua. Kirirã mija ima simamaka, kiyaᵽaika uᵽaka oyiaja mija baarika Tuᵽarãte yaᵽayu. ");
INSERT INTO tnc_vpl VALUES ("H14_4","082_4_4","1TH","4","4","5","Mija rõmimarĩrã, tĩmiamarĩrãka waᵽuju baabekaja mija imabe. Tuᵽarãte yi'ribeyurã ᵽuri, ba'iuᵽakaja baariwã'imarĩrijayurã. Nabaaika uᵽaka baabekaja mija imabe mija ᵽuri. I'suᵽaka baabekaja, rakajeᵽããrikakaka õrĩwãrũirã mija imabe. I'suᵽaka imarã imarĩ Tuᵽarãte yaᵽaika uᵽakaja baabaraka ᵽo'imajare jiyiᵽuᵽaka õñurã mija imarãñu. ");
INSERT INTO tnc_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","Suᵽa imarĩ, i'suᵽaka ba'iaja mija baawã'imarĩa'si, rĩrãkibiᵽaraka mijaka imarãte ba'iaja mija baakoreka. “I'suᵽaka baairãte ba'iaja Tuᵽarãte baarãñu”, ãrĩwa'ri mijare yija bojatiraᵽe. ");
INSERT INTO tnc_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","Ba'iaja mabaaerãmarĩa Tuᵽarãte mare wã'maeka. Kirirã imarĩ, kiyaᵽaika uᵽaka oyiaja baabaraka maimarika kiyaᵽayu. ");
INSERT INTO tnc_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","Tuᵽarãte yi'yurã imariᵽotojo, ika yija wãrõika yaᵽabeyurã, yijare takajamarĩa ĩariᵽe'yoirã. I'suᵽaka imawa'ri Tuᵽarãteoka yi'ribeyurã nime. Esᵽíritu Santore Tuᵽarãte mijareka ña'ajããeka, ba'iaja nabaaika naja'atarũ ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","Mija ã'mitiᵽe, wayuĩabu'arikakaka mijare yibojaerã baayu. Mija wayuĩabu'aokaro'si Tuᵽarãte mijare wãrõtika simamaka yija ᵽuri, dakoa ãrĩwa'ri sakaka mijaro'si o'obeyurã. ");
INSERT INTO tnc_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","Rita, jia wayuĩabu'airã mija ime. I'suᵽaka imarã imarĩ, ritaja Macedonia ka'iareka Jesúre yi'yurãte jia mija wayuĩayu. I'suᵽaka simamaka, jiibaji nare mija wayuĩamirĩrĩkawa'ririka yija yaᵽayu. ");
INSERT INTO tnc_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","I'suᵽaka oyiaja dakoa okamirãmarĩaja, mija ᵽuᵽayariji jia mija imabe. Suᵽabatirãoka ba'irabebaraka imarãte ba'iaja baata'abekaja mija imabe. I'suᵽaka baabekaja jia imaerã mija ᵽuᵽayarijĩkaja ba'irabebaraka mija imabe mijare yija bojaeka uᵽakaja. ");
INSERT INTO tnc_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","I'suᵽaka mija baarãka dakoa wayuoka baaberiwa'ri aᵽerãte ba'iaja baata'abekaja mija imarãñu. I'suᵽaka mija baamaka ĩatirã Jesúre yi'ribeyurã ᵽariji jia jiyiᵽuᵽaka mijare norĩrãñu. ");
INSERT INTO tnc_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","Mija ã'mitiᵽe yija jeyomarã. Jesucristore yi'rika mirãrãte reyaekakaka mijare yija bojaerã baayu, ba'iaja mija ᵽuᵽarikoreka. “Reyakoᵽeriᵽotojo õñia najaribesarãñu ate”, ãrĩwa'ri naruᵽurõ'õ jĩjimakaᵽi ᵽuᵽajoabekaja nime Tuᵽarãte yi'ribeyurã ᵽuri. Suᵽa imarĩ wayuᵽi'ritiyairãja nime. Nimauᵽaka mija imarika yija yaᵽabeyu. Mija ᵽuri “Jesúre yi'rika mirãrã imarĩ reyaekarã õñia jaritirã Tuᵽarã ᵽõ'irã a'rirãñurã”, ãrĩᵽuᵽajoairã. ");
INSERT INTO tnc_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","“Jesúre reyariᵽotojo õñia Tuᵽarãte kire jariᵽe'rirũjeka”, ãrĩᵽuᵽajoawãrũirã imarĩ, “Jesúre ã'mitiriᵽẽaeka mirãrãteoka õñia Tuᵽarãte jariᵽe'rirũjerãñu. Suᵽabatirã mabo'ikakuriᵽi Jesúre ᵽe'rietarãka ᵽoto, kika nare ke'ewa'rirãñu”, ãrĩwãrũirã maime. ");
INSERT INTO tnc_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","Maiᵽamakite yire õrĩrũjekakaka sime ika mijare yibojaika. Maiᵽamakire ᵽe'rietarãrĩmi kire yi'rika mirãrã reyariᵽotojo õñia jariᵽe'ritirã, kiᵽõ'irã a'rirãñurã. Õ'õrã õñia imañujurãoka naka ĩ'rãtiji oyiaja kiᵽõ'irã a'rirãñurã. ");
INSERT INTO tnc_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","Ikuᵽaka simarãñu: Maiᵽamakire jã'memaka mabo'ikakuri jãjia okaarirãka. Suᵽabatirã ángelrãka ĩᵽamakite jãjirokaᵽi jairãñu, i'suᵽakajaoka Tuᵽarã tromᵽeta okaarirãka. I'suᵽaka sokaarirãka watoᵽekaᵽi maiᵽamaki Jesucristojo ruira'arãki mabo'ikakuriᵽi. Oko ũmakakarã kimarãka ᵽoto kire ã'mitiriᵽẽaeka mirãrã reyaekarãte õñia jariᵽe'rirãñu. ");
INSERT INTO tnc_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","Suᵽabatirã Jesúre ã'mitiriᵽẽairã õñia imarãteoka õñia kijarirũjeirãᵽitiyika oko ũmakaka imarõ'õrã Tuᵽarãte mare akamiarãñu. Torã a'ritirã Maiᵽamakika mako'aᵽirirãñu, kika imajiᵽaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","I'suᵽaka imarũkia õñurã imarĩ, jia rikitubakaᵽi sakaka jaibu'abaraka mija imabe. “I'sia ᵽoto reyaeka mirãrã maka õñiaja nimarãñu ate mirãkiyu”, ãñurã imarĩ ba'iaja ᵽuᵽaritiyabekaja mija imabe. ");
INSERT INTO tnc_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","Yijeyomarã, “I'sirĩmi ketarãñu Maiᵽamaki. I'sijẽ'rã rõ'õjĩte simarãñu”, ãrĩwa'ri mijaro'si ãrĩo'obeyuka yi'i. ");
INSERT INTO tnc_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","I'suᵽaka ñañu “ ‘I'sirĩmi Jesucristore etarãñu je'e’, ãrĩwãrũberirika sime”, ãrĩrika õñurã mija imamaka. “I'tojĩte mawi'iarã kareba'arimajire etarãñu”, marĩwãrũbeyu uᵽaka sime Maiᵽamakire etarũkia. ");
INSERT INTO tnc_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","I'sia ᵽoto, “Koᵽakaja dakoa jũarũkimarĩrã maime”, ãrĩwa'ri ᵽuᵽajoabaraka ᵽo'imajare imatirãka ᵽoto, ikuᵽarõ'õᵽiji ba'itakaja naro'si simarãñu. I'suᵽaka najũarãka ᵽoto, marãkã'ã baatirã ĩ'rĩkaoka nakaki ru'riwãrũbesarãki. Ã'mitirikõrĩ je'e: Ikuᵽarõ'õᵽiji rõmore makarãrirã ᵽakatayu uᵽaka simarãñu. Makioka satá'tebesarãki. ");
INSERT INTO tnc_vpl VALUES ("H15_4","082_5_4","1TH","5","4","5","Yijeyomarã mija ᵽuri, ketarũkia õrĩtikarã imarĩ, ikuᵽarõ'õᵽiji ketarãka ᵽoto ᵽuᵽatabesarãñurã. Jesúre yi'ribeyurãro'si ᵽuri morĩbeyu ᵽoto, ñami kareba'arimajire etaika uᵽakaja simarãñu. Nima uᵽakamarĩa imarã imarĩ, ketarũkia ta'airã mija. ");
INSERT INTO tnc_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","I'suᵽaka simamaka, kãrĩtikarã uᵽakamarĩa, Maiᵽamakire etarũkia ta'atikaja maimaye'e. Suᵽabatirãoka Tuᵽarãte yaᵽabeyuakaka rakajekaja maimaye'e. Tuᵽarãte õrĩbeyurã ᵽuri kãrĩtikarã uᵽakaja imarã ketarũkia õrĩbeyurã imarĩ. ");
INSERT INTO tnc_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","Ã'mitirikõrĩ je'e: Tuᵽarãte yi'ribeyurã, ñami makãñu ᵽoto morĩbeyu uᵽaka, Jesúre ᵽe'rietarũkia õrĩbeyurã nime. I'suᵽakajaoka ñami ukuwejabiyurãte rakajebekaja ima uᵽakaja nime. ");
INSERT INTO tnc_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","Tuᵽarãte yi'yurã ᵽuri, boirõ'õ simamaka jia ritaja ĩairã uᵽaka imarã maime. I'suᵽaka maima simamaka, kiyaᵽabeyua rakajekaja, jia oyiaja baabaraka maimaye'e. “Kẽñu uᵽakaja baaiki kime Jesús”, ãrĩwa'ri jia kire mayi'riye'e. Suᵽabatirãoka jia mawayuĩabu'aye'e. “Jesúre yi'yurã maimamaka ba'iaja mabaaika waᵽa Tuᵽarãte ba'iaja mare baabesarãñu”, ãrĩwa'ri ᵽuᵽajoaweitikaja maimarãñu. I'suᵽaka oyiaja ᵽuᵽajoabaraka maimarijariye'e Satanáre ba'iaja mare baata'akoᵽeka mayi'rikoreka. ");
INSERT INTO tnc_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","“Ba'iaja nabaaika waᵽa ba'iaja nare yibaarãñu”, ãrĩwa'rimarĩa Tuᵽarãte mare wã'maeka. Maiᵽamaki Jesucristore reyaekaᵽi ãrĩwa'ri mare sawaᵽa kijẽñebesarãñu. ");
INSERT INTO tnc_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","Jia mare baawa'ri maro'si kireyaeka kika maimajiᵽaokaro'si. Suᵽa imarĩ, kiᵽe'rietarãñurĩmi õñia imarãte, reyaekarãteoka mare ke'ewa'rirãñu kika maimajiᵽaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","I'siakaka õrĩtirã imarĩ, jaibu'abaraka, jeyobaabu'abaraka, jĩjimakaᵽi rikitubaka mija imarijaᵽe. ");
INSERT INTO tnc_vpl VALUES ("H15_12","082_5_12","1TH","5","12","13","Mija ã'mitiᵽe yijeyomarã. Mija ᵽõ'irã imarã imaruᵽutarimaja, “Jesucristore yaᵽaika uᵽaka mabaarijariye'e”, ãrĩwa'ri mijare okajããrijayurã. I'suᵽaka jia mijare nimaruᵽutaika simamaka jiyiᵽuᵽaka nare mija õrĩrika yiyaᵽayu. Nare mija wayuĩarijaᵽe. I'suᵽakajaoka ritajaka jia mija imabe. ");
INSERT INTO tnc_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","Yijeyomarã, mija ᵽõ'irã ba'irabebekaja imarãte, “Ᵽuᵽaᵽe'ritirã, mija ba'irabebe”, ãrĩwa'ri okajãjiaᵽi mija bojabe. Mija ᵽõ'irã imarã ba'iaja ᵽuᵽaribaraka imarãte, jia okajãjia naᵽuᵽajoaokaro'si nare mija jeyobaabe. I'suᵽakajaoka Tuᵽarãte yaᵽabeyuakaka rakajebeyurã, suᵽabatirã jia Tuᵽarãte yi'ribeyukajirãteoka mija jeyobaabe. Jajumarĩaja jia jĩjimakaᵽi ritajaka mija imabe. I'suᵽaka mija imarijaririka yija yaᵽayu. ");
INSERT INTO tnc_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","Jia mija ᵽuᵽajoabe. Aᵽerãte ba'iaja mijare baakoᵽeko'omakaja nare mija ruᵽuwaᵽae'ea'si. I'suᵽaka baabekaja jia oyiaja mija imabu'abe. Suᵽabatirã ritaja wejeareka imabayurãkaoka i'suᵽakaja mija imarijaᵽe. ");
INSERT INTO tnc_vpl VALUES ("H15_16","082_5_16","1TH","5","16","18","Tuᵽarãte ᵽuᵽajoabaraka jĩjimaka mija imarijaᵽe. I'suᵽakajaoka kika mija jairijayua mija ja'ata'asi. I'suᵽakajaoka jia, jiamarĩaoka mijaro'si simarãka, “Jia mibaayu Tuᵽarã”, kire mija ãrĩrijaᵽe. Jesucristorirã mija imamaka, i'suᵽaka mija baarika Tuᵽarãte yaᵽayu. ");
INSERT INTO tnc_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","Mija watoᵽekareka Esᵽíritu Santore mijare jeyobaarãka ᵽoto kire mija ã'mitiriᵽe'yoa'si. Ĩakõrĩ je'e: i'suᵽaka mija baajĩka okoaᵽi ᵽekaõ'toa yataika uᵽaka mija baajĩñu. ");
INSERT INTO tnc_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","I'suᵽakajaoka, “Ikuᵽaka Esᵽíritu Santore yire õrĩrũjeika”, ãrĩwa'ri Tuᵽarãro'si bojaĩjirimajare bojaikakaka ã'mitiriᵽe'yobekaja mija imabe. ");
INSERT INTO tnc_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","Sã'mitiriᵽe'yobekaja “¿Yaje rita Tuᵽarãrikataka najaiyu? Noñu uᵽakaja ᵽuᵽajoatirã najaiyu je'e aᵽeyari”, ãrĩwa'ri jia mija ã'mitiᵽe ruᵽu. “Rita Tuᵽarãrika najaiyu”, mija ãrĩwãrũrãrõ'õjĩrã ᵽuri nare mija yi'ᵽe. ");
INSERT INTO tnc_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","Ritaja Tuᵽarãte yaᵽabeyua mija ã'mitiriᵽẽa'si. ");
INSERT INTO tnc_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","Tuᵽarã imaki jia ña'rĩyaarĩji maimaokaro'si mare jeyobaarimaji. I'suᵽaka simamaka ikuᵽaka mijaro'si kire yija jẽñerijayu: “ ‘Ba'iaja baabekaja jia oyiaja baabaraka nimarũ’, ãrĩwa'ri nare mijeyobaabe. Suᵽa imarĩ, mire takaja ã'mitiriᵽẽabaraka nare mimarũjebe”, ãrĩwa'ri kire yija ãrĩrijayu. I'suᵽakajaoka, “Jia oyiaja baabaraka Jesúre na'mitiriᵽẽarũ, kiyaᵽaika uᵽakaja ᵽuᵽajoabaraka nimarũ”, ãrĩwa'ri Tuᵽarãte yija jẽñeĩjirijayu. Suᵽa imarĩ, maiᵽamaki Jesucristore ᵽe'rietarãñurĩmi dikaoka ba'iaja baabeyurã mija imarika yija yaᵽayu. ");
INSERT INTO tnc_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","I'suᵽaka maimaokaro'si, “Yire takaja mija ã'mitiriᵽẽabe”, Tuᵽarãte ãrĩka. I'suᵽaka mare jã'meiki imarĩ, kiyaᵽaika uᵽakaja mabaawãrũerã jia mare jeyobaarijarirũkika kime. ");
INSERT INTO tnc_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","Yijeyomarã, yijaro'sioka Tuᵽarãte mija jẽñeĩjibe. ");
INSERT INTO tnc_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","Mija rẽrĩrãka ᵽoto jĩjimakaᵽi mija jẽñabu'abe, Jesúrirã imarĩ. ");
INSERT INTO tnc_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","Tokarã Jesúre ã'mitiriᵽẽairã imarã uᵽatikaja rẽrĩtirã, ika ᵽaᵽera nare mija jaibojabe. Ritaja sã'mitirika Maiᵽamakire yaᵽamaka i'suᵽaka mijare yijã'meyu. ");
INSERT INTO tnc_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","“Maiᵽamaki Jesucristore jia mijare baarũ”, ãrĩwa'ri kire yijẽñerijayu. I'tojĩrãja sime ruᵽu.");
INSERT INTO tnc_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","Jesucristore yi'yurã Tesalónicawejeakarã, ¿yaje mija ime? Yi'i Ᵽablo, suᵽabatirã majeyomarã Silvano, Timoteoᵽitiyika ika ᵽaᵽera mijaro'si yija ᵽũatayu, Maᵽaki Tuᵽarãrirã, maiᵽamaki Jesucristorirãoka mija imamaka. ");
INSERT INTO tnc_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","“Jia Tesalónicakarãre mija baabe”, ãrĩwa'ri Maᵽaki Tuᵽarãte, suᵽabatirã maiᵽamaki Jesucristoreoka mijaro'si yija jẽñerijayu. I'suᵽakajaoka yija baayu jia dako okamirãmarĩaja mijare nimarũjeokaro'si. ");
INSERT INTO tnc_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","Mija ã'mitiᵽe yijeyomarã, jiibaji Jesucristore yi'riwa'ri, ĩ'rãrĩmi uᵽakaja jiibaji mija wayuĩabu'arijayua simamaka “Jia mibaayu Tuᵽarã”, kire yija ãrĩrijayu mijareka yija ᵽuᵽajoaika rakakaja. Suᵽa imarĩ, i'suᵽaka Tuᵽarãte yija ãrĩrijayua jia sime. ");
INSERT INTO tnc_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","I'suᵽakajaoka, yija eyarijayurõ'õrã, aᵽerã Jesúre yi'yurãte i'suᵽaka mija imakaka jĩjimakaᵽi yija bojarijayu. “Tesalónicawejeakarã jia Tuᵽarãte yi'yurã imarĩ, kire yi'ririja'atabeyurã. I'suᵽakajaoka wayuᵽi'ribekaja, okajãjia ᵽuᵽajoairã nime, aᵽerãte ba'iaja nare baako'omakaja, sanarakajeᵽããrijayu”, ãrĩwa'ri nare yija bojayu. ");
INSERT INTO tnc_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","Tuᵽarãte yi'yurã mija imamaka, aᵽerãte ba'iaja mijare baayu. I'suᵽaka simako'omakaja “Tuᵽarãte ãñu uᵽakaja kibaarãñu”, ãñurã imarĩ kire mija yi'ririja'atabeyu. Suᵽa imarĩ “Ba'iaja nare imabeyua”, mijareka ãrĩwa'ri ritajare kijã'merãka ᵽoto kika mijare kimarũjerãñu. I'suᵽaka Tuᵽarãte baarũkia õrĩwa'ri, “Rita, jia oyiaja baaiki kime”, ãrĩwãrũirã maime. ");
INSERT INTO tnc_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","Jia wãjioyiaja baaiki imarĩ, ba'iaja mijare baairãte ba'iaja kibaarãñu. ");
INSERT INTO tnc_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","Maekaka ba'iaja jũairã imariᵽotojo i'suᵽaka oyiaja imajiᵽarũkimarĩrã mija ime, ĩ'rãrĩmi sakitiyetarãka simamaka. I'suᵽakajaoka yijaro'si ba'iaja yija jũakoᵽeika kitiyetarãñu. Maiᵽamaki Jesús, kiángelrãka tẽrĩtaka baawãrũirãᵽitiyika ki'tarãka ᵽoto i'suᵽaka kibaarãñu. Mabo'ikakuriᵽi ki'tarãñu, ᵽeka jũ'rẽika uᵽaka jãjia yaaboaika watoᵽekaᵽi. ");
INSERT INTO tnc_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","Torãjĩte Tuᵽarãte õrĩriyaᵽabeyurã imarĩ, Jesúrika bojarirokaoka ã'mitiriᵽe'yoirãte ba'iaja kibaarãñu. ");
INSERT INTO tnc_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","Ba'iaja jũajiᵽarũkirã nimamaka, Maiᵽamakire imarõ'õ tá'teka oyiaja naro'si imajiᵽarãka. Tẽrĩwa'ribaji kirikaᵽi jiitaka kiyaaboaika ĩarũkimarĩrãro'si nimarãñu. ");
INSERT INTO tnc_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","I'suᵽaka kibaarãñu Jesúre ate etarãñurĩmi. Suᵽa imarĩ jĩjimakaᵽi kirirãte kire e'etorirãñu. Kire ĩatirã “Jiitaki kime. Tẽrĩwa'ribaji jia mare baaiki kime”, ãrĩwa'ri kire najiyiᵽuᵽayeerãñu. Mijare yija wãrõraᵽaka yi'yurã imarĩ, naka mija imarãñu mijaoka. ");
INSERT INTO tnc_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","Ika ᵽuᵽajoawa'ri Tuᵽarãte mijaro'si yija jẽñejiᵽarijayu. Kiyaᵽaika uᵽakaja baairã mija imaokaro'si mijare kiakaeka. Suᵽa imarĩ, kiyaᵽaika uᵽaka mija baamaka ĩawa'ri “Nare yakaikaᵽi ãrĩwa'ri yirirã najayua jia sime mae”, kẽñaokaro'si, kire yija jẽñerijayu. Suᵽabatirã “Simauᵽatiji jia baarika nayaᵽaika nabaawãrũokaro'si nare mijeyobaabe. Suᵽabatirã mire yi'riwa'ri nabaarijayua jia saweiokaro'si mirikaᵽi nare mijeyobaabe”, ãᵽaraka kire yija jẽñerijayu. ");
INSERT INTO tnc_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","I'suᵽaka ᵽo'imajare ĩarãka wãjitãji jia mija baamaka ĩawa'ri maiᵽamaki Jesucristore najiyiᵽuᵽayeerãñu. Kirirã mija ima simamaka, i'suᵽakajaoka mijare kibaarãñu. Tuᵽarã, maiᵽamaki Jesucristoᵽitiyika jia mijare nabaamaka i'suᵽaka mijaro'si simarãñu. ");
INSERT INTO tnc_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","Mija ã'mitiᵽe yija jeyomarã. Maiᵽamaki Jesucristore etarãñu ate kika maimaokaro'si mare rẽarĩ. I'suᵽaka simarãka simamaka ketarũkirĩmikaka mijare yiwãrõerã baayu mae. ");
INSERT INTO tnc_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","Ikuᵽarõ'õᵽiji, “Koᵽakaja Jesúre etarijẽ'raka seyatiyu”, ãrĩwa'ri ĩ'rãrimarãre mijare bojaᵽakimaka ã'mitiritirã, õrĩᵽũabeyurã uᵽakataka rukubaka mija ᵽuᵽajoa'si. Suᵽabatirã “Rita mijare ñañu. Esᵽíritu Santo yijare sõrĩrũjeraᵽaki”, narĩᵽakikoᵽemakaoka nare mija yi'ria'si. I'suᵽakajaoka “Ᵽaᵽeraᵽi Ᵽablote yijare sabojayu”, naᵽakã'ã nare mija ã'mitiriᵽẽa'si. ");
INSERT INTO tnc_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","I'suᵽaka mijare ãrĩkoᵽeirãte mija bojaᵽakirũjea'si. Ketaerã baarũki ruᵽu ikuᵽaka simarãñu: Tuᵽarãte ja'atatirã “Kimajamarã yija ime”, ãrĩwa'ri ᵽo'imajare kire yi'ribesarãñu. I'tojĩte Ba'iaja baarimijikaka jã'meikite etarãñu. Ikiji kime “Ba'iaja imarika tiyibeyurõ'õrã yiᵽũatarũkika”, bikijarãja Tuᵽarãte ãrĩkaki. ");
INSERT INTO tnc_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","Ikuᵽaka Ba'iaja baarimijikaka jã'meikite baarãñu: Ritaja jiyiᵽuᵽaka ᵽo'imajare õrĩrijayua imakoᵽeika nareka kijãjibaarãñu. Tuᵽarã majamaki kima imarĩ, “Tẽrĩrikiji ñime, yire takaja mija ã'mitiriᵽẽabe”, ᵽo'imajare kẽrĩrãñu. I'suᵽaka kiᵽuᵽaka ima simamaka Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã kãkatirã imatiyairõ'õrã eyaruᵽaritirã, “Tuᵽarãja yi'i”, kẽrĩᵽakirãñu. ");
INSERT INTO tnc_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","Mijaka ñimaraᵽaka ᵽoto i'suᵽaka imarũkiakaka mijare yibojawãrõtiraᵽe. “Ye'kariribeyurã nimarijiyu”, mijareka ñarĩᵽuᵽajoayu. ");
INSERT INTO tnc_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","Ba'iaja baarimijikaka jã'meiki i'tawãrũbeyukajika maekaka. “Ikuᵽaka simamaka ki'tawãrũbeyu ruᵽu. Ketarũkirĩmi ruᵽubajirãja ketakoreka kire satá'teyu ruᵽu”, ãrĩwa'ri mijare yibojaraᵽaka õñurã mija ime. ");
INSERT INTO tnc_vpl VALUES ("H22_7","083_2_7","2TH","2","7","8","Suᵽa simako'omakaja, ᵽo'imajare õrĩwãrũbeyuaᵽi, ba'iaja wejeareka Satanáre baaũ'mutiyu. I'suᵽaka baariᵽotojo, wããrõ'õrãja etarũkikate etawãrũbeyu ruᵽu. Kire tá'teikite kire ĩaᵽẽabesarãka ᵽoto ᵽuri ritaja ᵽo'imaja wãjitãji Ba'iaja baarimijikaka jã'meikite etarãñu. I'suᵽaka kima imako'omakaja maiᵽamaki Jesúre kire tẽrĩrãñu. Ketarãñurĩmi tẽrĩwa'ribaji kibaawãrũika beawa'ri, kiᵽuritarãkaᵽiji kire kiriatarãñu. ");
INSERT INTO tnc_vpl VALUES ("H22_9","083_2_9","2TH","2","9","9","Ika yibojaika ruᵽubajirã, ikuᵽaka simarãñu: Satanárikaᵽi ãrĩwa'ri Ba'iaja baarimijikaka jã'meiki ritaja maikoribeyua ᵽo'imajare beaᵽakirĩ etarãki. ");
INSERT INTO tnc_vpl VALUES ("H22_10","083_2_10","2TH","2","10","10","Ritaja ba'iaja baawãrũiki imarĩ, ba'iaja imarika tiyibeyurõ'õrã a'rirũkirãte saᵽi kiᵽakirãñu. Tuᵽarãrika bojariroka yi'ririyaᵽaberiwa'ri, ba'iaja imarika tiyibeyurõ'õrã na'rirãñu. Kirika bojariroka nayi'ririkareka ᵽuri saᵽi natãrĩrũkia simajããeka. ");
INSERT INTO tnc_vpl VALUES ("H22_11","083_2_11","2TH","2","11","11","Sanayi'riberika simamaka, Tuᵽarãte rukubaka nare ᵽuᵽajoarũjerãñu Ba'iaja baarimijikaka jã'meiki ᵽakirimajaroka nayi'yaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("H22_12","083_2_12","2TH","2","12","12","Tuᵽarãrika bojariroka ã'mitiriᵽẽabekaja, jĩjimakaᵽi ba'iaja baarijayurãte ba'iaja imarika tiyibeyurõ'õrã a'yaokaro'si i'suᵽaka kibaarãñu. ");
INSERT INTO tnc_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","Mija ã'mitiᵽe yija jeyomarã, jia Maiᵽamakire wayuĩairã. Wejea kiᵽo'ijiaeka ᵽotorãja kitããrũkirã mija imaokaro'si Tuᵽarãte wã'matikarã mija ime. Suᵽa imarĩ, Esᵽíritu Santore mijare jeyobaaikaᵽi ba'iaja baarika ja'atatirã, kirika bojariroka yi'riwa'ri õñia mija imajiᵽaokaro'si i'suᵽaka Tuᵽarãte baaeka. I'suᵽaka mijaro'si simaeka ᵽuᵽajoawa'ri “Jia mibaayu Tuᵽarã”, mijaro'si yija ãrĩja'atabesarãñu. ");
INSERT INTO tnc_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","Jesucristorika bojariroka mijare yija wãrõekaᵽi ãrĩwa'ri Tuᵽarãte mijare wã'maeka. I'suᵽaka simamaka, mabo'ikakurirã maeyarãka ᵽoto ritaja ima tẽrĩwa'ribaji kirika maiᵽamaki Jesucristore bearãñu. I'suᵽakajaoka simarãñu mijaro'sioka kika. ");
INSERT INTO tnc_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","Yijeyomarã, i'suᵽaka imarũkirã imarĩ, Jesucristore mija yi'yua ja'atarimarĩaja mija imabe. Ritaja wãjirokakaka mijare yija wãrõraᵽaka, suᵽabatirã ᵽaᵽeraᵽi mijare yija o'oraᵽakaoka mija ã'mitiriᵽẽarijaᵽe. ");
INSERT INTO tnc_vpl VALUES ("H22_16","083_2_16","2TH","2","16","17","Jia Maᵽaki Tuᵽarã mare baaiki, suᵽabatirã mare wayuĩaiki imarĩ, jĩjimaka ᵽuᵽajoabaraka maimaerã mare kijeyobaaeka. “Kika õñia maimajiᵽarãñu”, ãrĩwa'ri sata'abaraka jia jĩjimaka mare ᵽuᵽarirũjeiki kime. Suᵽa imarĩ, jia oyiaja baabaraka, ba'iaja jairimarĩaja mija imaokaro'si mijare kijeyobaarũ maiᵽamaki Jesucristoᵽitiyika. ");
INSERT INTO tnc_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","Mae ᵽiyia mijare yibojaerã baayu yijeyomarã. Ñojimarĩji Maiᵽamakirika bojariroka aᵽerõ'õrã yija bojaᵽibaokaro'si Tuᵽarãte mija jẽñebe. Suᵽabatirãoka kirika bojariroka ã'mitiriwa'ri jia jĩjimaka samija yi'raᵽaka uᵽakaja aᵽerãte sayi'yaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","I'suᵽakajaoka, ba'iaja baairãte ba'iaja yijare baakoreka, Tuᵽarãte nare tá'terã yijaro'si kire mija jẽñebe. I'suᵽaka mija baabe rĩkimarãja aᵽerã Jesucristore ã'mitiriᵽẽariyaᵽabeyurãte ima simamaka. ");
INSERT INTO tnc_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","I'suᵽaka imarijayurãte ima simako'omakaja mare ja'atabeyuka kime Maiᵽamaki. I'suᵽaka imaki imarĩ kire mija yi'ririja'atakoreka mijare kijeyobaarãñu. Suᵽabatirã Satanáre ba'iaja mijare baakoreka, mijaro'si kire kitá'terãñu. ");
INSERT INTO tnc_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","“Kẽñu uᵽakaja baaiki kime Maiᵽamaki. Suᵽa imarĩ, kire yi'yurã nimamaka, jia oyiaja Tesalónicakarãre baawãrũokaro'si nare kijeyobaarãñu. I'suᵽaka simamaka nare yija ãrĩka uᵽakaja nayi'ririjarirãñu”, mijareka yija ãrĩrijayu. ");
INSERT INTO tnc_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","Suᵽabatirã “Tuᵽarãte nare wayuĩaika norĩwãrũrũ. Suᵽabatirãoka ba'iaja jũariᵽotojo mirakajeᵽããeka uᵽakaja sanarakajeᵽããwãrũokaro'si nare mijeyobaabe”, ãrĩwa'ri maiᵽamaki Jesúre mijaro'si yija jẽñeĩjirijayu. ");
INSERT INTO tnc_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","Mija ã'mitiᵽe yijeyomarã. Maiᵽamaki Jesucristore mare jã'memaka, ikuᵽaka mijare yija jã'meyu: Ĩ'rĩka Jesúre yi'yuka imariᵽotojo ba'iraberiyaᵽabeyukaka mija jeyoaria'si. Yija wãrõeka uᵽaka baabeyuki kime. ");
INSERT INTO tnc_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","Mija ᵽõ'irã yija imaraᵽaka ᵽoto ba'irabebekaja imaberaᵽarã yija. I'suᵽaka yija baaraᵽaka mija ĩaraᵽaka simamaka, i'suᵽakajaoka mija baabe mijaro'si. ");
INSERT INTO tnc_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","Suᵽabatirã mijaba'arika waᵽamarĩaja yija ba'aberaᵽe. Mijare takaja jẽñebekaja, ĩmiareka, ñamiarekaoka, jãjia yija ba'iraberaᵽe yija yaᵽaraᵽaka yijare mija ĩjikoreka. ");
INSERT INTO tnc_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","Mijare wãrõrimaja yija imamaka, yijare mija jeyobaarũkirã imariᵽotojo mijare sayija jẽñeberaᵽe. Yijare ĩatirã “Nuᵽakaja mabaaye'e maro'sioka”, mija ãñaokaro'si suᵽa yija baaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","Mijaka yija imaraᵽaka ᵽoto, “Ba'iraberiyaᵽabeyuka ᵽuri ba'abekaja kimarũ”, mijare yija ãrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","I'suᵽaka yija ãrãᵽaka simako'omakaja “Maekaka ĩ'rãrimarã nawatoᵽekarã ba'irabebekaja imarã. Suᵽabatirãoka aᵽerã jia ba'iraberijayurãte najo'ayu're”, ãrĩwa'ri yijare nabojayu. ");
INSERT INTO tnc_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","“Jia imaokaro'si, aᵽerãte jo'arimarĩaja mija ba'irabebe mijaro'siji, mija ba'iraberiwaᵽaᵽiji mija yaᵽaika mija waᵽaĩjiokaro'si”, ãrĩwa'ri nare yija jã'meᵽũayu, maiᵽamaki Jesucristore jã'meka uᵽakaja. ");
INSERT INTO tnc_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","Mija ã'mitiᵽe yijeyomarã. Jia mija baarijayua mija rũrĩa'si. ");
INSERT INTO tnc_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","Ĩ'rãrimarã ika ᵽaᵽera yo'oeka yi'ribeyurã imarã je'e aᵽeyari. I'suᵽaka nimamaka “Ĩ'rã imarã Ᵽablote jã'meika yi'ririyaᵽabeyurã”, ãrĩwãrũtirã naka mija jeyoaria'si. I'suᵽaka nare mija baarãkareka ni'yoᵽi'rirãñu. I'suᵽaka mija baabe naᵽuᵽaᵽe'rirũ ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","I'suᵽaka nare baariᵽotojo nare mija majamarãria'si. Jesúre yi'yurã nimamaka, nare mija okajããbe ba'iaja nabaarijarikoreka. ");
INSERT INTO tnc_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","Jia maimaokaro'si mare jeyobaaiki kime Maiᵽamaki. I'suᵽaka simamaka, ĩ'rãkuri uᵽakaja jĩjimakaᵽi jia mija imaokaro'si mijare kijeyobaarũ. Suᵽabatirã ritaja mijaka kimajiᵽarũ. ");
INSERT INTO tnc_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","“Jia nimarũ”, ãᵽaraka yi'i Ᵽablo yiᵽitakaᵽi ika mijaro'si yo'oyu. I'suᵽakaja satiyiyu ᵽaᵽera yo'oika. I'suᵽaka o'oiki ñime. Sĩawa'ri “Rita oka Ᵽablote ᵽũataeka sime”, mija ãrĩwãrũokaro'si. ");
INSERT INTO tnc_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","Ritaja mija imauᵽatireje jia maiᵽamaki Jesucristore baajiᵽarũ. I'tojĩrãja sime ruᵽu.");
INSERT INTO tnc_vpl VALUES ("JM1_1","089_1_1","JAS","1","1","1","Yaje mija ime yijeyomarã. Tuᵽarã, suᵽabatirã maiᵽamaki Jesucristore yaᵽaika uᵽakaja baarijayuka Santiago ñime ika ᵽaᵽera mijaro'si ᵽũataiki. Ba'iaja jũawa'ri ᵽibikarã, aᵽetomaja watoᵽekarã ĩ'ᵽoũ'ᵽuarãe'earirakatata judíorãka imarãro'si ika yo'oyu. ");
INSERT INTO tnc_vpl VALUES ("JM1_2","089_1_2","JAS","1","2","2","Mija ã'mitiᵽe yijeyomarã. Ba'iaja jũarijayurã imariᵽotojo “Jia oyiaja yijaro'si simarãñu”, jĩjimaka ãrĩᵽuᵽajoairã mija imabe. ");
INSERT INTO tnc_vpl VALUES ("JM1_3","089_1_3","JAS","1","3","4","Suᵽa imarĩ ba'iaja mijaro'si simarijariko'omakaja jiibaji Tuᵽarãte ã'mitiriᵽẽairã mija jaririjayu. I'suᵽakajaoka “Kire mayi'rija'ataberiye'e”, ãrĩwãrũirã mija ime. Suᵽa imarĩ ba'iaja mijaro'si simarijariko'omakaja, wayuᵽi'ribekaja kire yi'riwa'ri samija rakajeᵽããrãñu. I'suᵽaka imawa'ri jiibaji Tuᵽarãte yaᵽaika uᵽakaja imarã mija jaᵽakã'ã dakoa mijaro'si jariwa'ribesarãka. ");
INSERT INTO tnc_vpl VALUES ("JM1_5","089_1_5","JAS","1","5","5","Suᵽa imarĩ “Ba'iaja yijũaika ᵽoto, ikuᵽaka ñimarika Tuᵽarãte yaᵽayu”, mija ãrĩwãrũberiye'e, kire samija jẽñebe. I'suᵽaka mija baamaka jiaᵽi mijare sakiõrĩrũjerãñu, ritaja nayaᵽaika uᵽaka ᵽo'imajare jeyobaarimaji imarĩ. ");
INSERT INTO tnc_vpl VALUES ("JM1_6","089_1_6","JAS","1","6","8","Toᵽi ᵽuri kire jẽñebaraka, “Yijare sakiõrĩrũjebesarãñu je'e aᵽeyari”, mija ãrĩᵽuᵽajoa'si. Õrĩkõrĩ je'e: Rukubaka ᵽuᵽajoabaraka imarijayurã ĩ'rãrokaᵽiji ña'rĩyaarĩji imawãrũbeyurã. Saᵽi ãrĩwa'ri, “Tuᵽarãte yija jẽñeika uᵽakaja yijare sakija'atabesarãñu je'e”, ãñurã nimamaka, dakoa nare kiõrĩrũjebesarãñu. ");
INSERT INTO tnc_vpl VALUES ("JM1_9","089_1_9","JAS","1","9","9","Mija ã'mitiᵽe aᵽeroka: “Wayuoka baairã imariᵽotojo, Jesucristore yija ã'mitiriᵽẽaika simamaka, Tuᵽarã ñakoareka imatiyairã yija ime”, ãñurã ᵽuri jĩjimaka imarijayurã. ");
INSERT INTO tnc_vpl VALUES ("JM1_10","089_1_10","JAS","1","10","10","Mia, ba'irĩjia rĩkimakaja rikairãoka, ñoaka nare imarũjerũkimarĩa simamaka, Jesucristore yi'yurã jariwa'ri “Imatiyarimajamarĩrã yija imaroyikã'ã”, ãñurã ᵽuri jĩjimaka imarijayurã. ");
INSERT INTO tnc_vpl VALUES ("JM1_11","089_1_11","JAS","1","11","11","Õrĩkõrĩ je'e: Ñoaka ijia yaamaka taya jĩñua. I'suᵽakajaoka sõ'õrika jĩrĩwa'ri jũjika saro'si. Suᵽa imarĩ jiyurika sõibeyu. Maeje mijare yibojaweaika uᵽaka nime rĩkimaka ba'irĩjia rikairã. “Rĩkimabaji mayaᵽarijayua matõᵽoerã”, ãᵽaraka sawaᵽa niñerũ mo'arĩji reyarũkirã nime. ");
INSERT INTO tnc_vpl VALUES ("JM1_12","089_1_12","JAS","1","12","12","Ka'wisika jũarijayurã imariᵽotojo okajãjirã imarĩ, samarakajeᵽããrijayua ĩatirã “Jia yire nayi'yu”, Tuᵽarãte mareka ãrĩrãñu. Suᵽa imarĩ “Yika rĩrãkibiriwa'ri yire yi'ririjayurãte õñia imajiᵽarika yija'atarãñu”, Tuᵽarãte ãrĩka simamaka jia mare kibaarãñu. ");
INSERT INTO tnc_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","13","Suᵽa imarĩ ba'iaja mija baarijitoika, “Tuᵽarã yire sajã'meiki”, ãᵽekaja mija imabe. Tuᵽarã imaki, ba'iaja baarijitobeyuka, suᵽabatirã, ba'iaja mare baarũjebeyuka. ");
INSERT INTO tnc_vpl VALUES ("JM1_14","089_1_14","JAS","1","14","15","I'suᵽaka simako'omakaja, maᵽuᵽakarãja ba'iaja baarika ᵽuᵽajoatirã, “Jia simaᵽajĩñu je'e yiro'si”, marĩrijayu. I'suᵽaka maᵽuᵽajoaikaᵽi ãrĩwa'ri ba'iaja mabaarijayu. Suᵽabatirãoka ba'ioyiaja baarijayurã maimarijarirãka, ba'iaja imarika tiyibeyurõ'õrã a'rirũkirã maimarãñu. ");
INSERT INTO tnc_vpl VALUES ("JM1_16","089_1_16","JAS","1","16","16","I'suᵽaka simamaka, “Tuᵽarãja yijare sajã'meiki ba'iaja yija baaokaro'si”, ãrĩwa'ri ᵽakirika mija ᵽuᵽajoa'si yijeyomarã. ");
INSERT INTO tnc_vpl VALUES ("JM1_17","089_1_17","JAS","1","17","17","I'suᵽaka mare imarũjebeyuka imarĩ, jia Maᵽaki Tuᵽarãte mare baayu, kiyaᵽaika uᵽakaja maimamirĩrĩkawa'yaokaro'si. I'suᵽaka baarimaji Tuᵽarãjaoka kime, aiyaka, tã'ᵽia ritaja ᵽo'ijiaekaki. Kiᵽo'ijiaeka ᵽuri sarã'rãrika, sayaaboaikaoka o'arijayua simako'omakaja Tuᵽarã ᵽuri kimarijayuareka o'abeyuka imarĩ, jia ima oyiaja mare ja'atajiᵽarimaji kime. ");
INSERT INTO tnc_vpl VALUES ("JM1_18","089_1_18","JAS","1","18","18","Suᵽa imarĩ kiyaᵽairokaᵽi kirika rita bojariroka mayi'ᵽakã'ã õñia kika maimajiᵽarũkia Tuᵽarãte mare ja'atatika. Suᵽa imarĩ “Yirirã nimarũ”, mareka kẽrĩtika simamaka ritaja kiᵽo'ijiaekareka mamarĩjiji kire yi'riũ'muekarã maime. ");
INSERT INTO tnc_vpl VALUES ("JM1_19","089_1_19","JAS","1","19","19","Yijeyomarã, ika mijare yibojaerã baaika mija ye'kariritiya'si. Tuᵽarãrika rita bojariroka mijare jaibojarãñurãte jiaᵽi mija ã'mitiriᵽẽabe. I'suᵽakajaoka mija ᵽuᵽakareka ima ñojimarĩtaka nare bojabekaja mija imabe. Suᵽabatirã ñojimarĩji nare mija boebaria'si. ");
INSERT INTO tnc_vpl VALUES ("JM1_20","089_1_20","JAS","1","20","20","Toᵽi ᵽuri waᵽuju boebayurã maimarãkareka, jiirokaᵽi maimarika Tuᵽarãte yaᵽaika uᵽaka majaribesarãñu. ");
INSERT INTO tnc_vpl VALUES ("JM1_21","089_1_21","JAS","1","21","21","I'suᵽakajaoka ritaja ba'iaja baarika imakaka mija ja'atabe. Suᵽabatirãoka “Tẽrĩriki ñime”, ãrĩkoᵽeikite ᵽuᵽajoaika uᵽaka ᵽuᵽajoabekaja mija imabe. I'suᵽaka imawa'ri, Tuᵽarãrika bojariroka mijare kiõrĩrũjeikakaka takaja jiaᵽi mija yi'ririjaᵽe. I'suᵽaka mija imarãkareka ᵽuri ba'iaja imarika tiyibeyurõ'õrã mija a'rirũkia imakoᵽeikareka Tuᵽarãte mijare tããrãñu. ");
INSERT INTO tnc_vpl VALUES ("JM1_22","089_1_22","JAS","1","22","24","Õrĩwãrũikõrĩ je'e: Ũᵽeriaᵽi ĩ'rĩkate kiᵽema yaeriᵽotojo jiamarĩa ima rũ'rẽbekaja ke'rirãka i'suᵽakaja satuirãñu. Ñojimarĩ i'suᵽakaja ima kiye'karirirãñu. I'suᵽaka mija imajĩñu Tuᵽarãrika bojariroka ã'mitiririᵽotojo samija yi'riberijĩkareka. Tuᵽarãrika bojariroka ã'mitiritirã sãñu uᵽakaja yi'rirũkia sime. Suᵽa mabaabesarãkareka ᵽuri, “Tuᵽarãte yi'yurã yija ime”, mañua, moñu uᵽakaja maᵽakiyu. ");
INSERT INTO tnc_vpl VALUES ("JM1_25","089_1_25","JAS","1","25","25","Tuᵽarãrika bojariroka jia wãrũbaraka sayi'ririjayukate ᵽuri, ba'iaja baarika kire saja'atarũjerijayu. Rita sime Tuᵽarãrika bojariroka. Suᵽa imarĩ saye'kariribekaja, sajã'meika uᵽakaja baarijayukate, ritajareka jia kire sakijeyobaarijarirãñu. ");
INSERT INTO tnc_vpl VALUES ("JM1_26","089_1_26","JAS","1","26","26","Aᵽerimarã ᵽuri “Tuᵽarã ñakoareka, kire jiyiᵽuᵽaka õñurã imarĩ, kiyaᵽaika uᵽakaja baarijayurã yija ime”, ãñurã. I'suᵽaka ãñurã imariᵽotojo ba'iaja najairijayua ja'atabeyurã imarĩ, noñu uᵽakaja ᵽakirimaja nime. I'suᵽaka imarã nimamaka “Tuᵽarãte jiyiᵽuᵽaka õñurã yija ime”, narĩkoᵽeika waᵽamarĩa sajayu. ");
INSERT INTO tnc_vpl VALUES ("JM1_27","089_1_27","JAS","1","27","27","Maᵽaki Tuᵽarãreka ikuᵽaka nime kire jiyiᵽuᵽaka õñurã: Ᵽakiamarĩrã jarikarã wayuoka baairãte, suᵽabatirã natĩmiaka reyataᵽaekarãteoka jia jeyobaairã, i'suᵽakajaoka ba'iaja baarimajare ima uᵽaka jaribeyurã nime. ");
INSERT INTO tnc_vpl VALUES ("JM2_1","089_2_1","JAS","2","1","1","Mija ã'mitiᵽe yijeyomarã. Ritaja ima ᵽemawa'ribajirã imatiyaiki maiᵽamaki Jesucristore ima simamaka, jiyiᵽuᵽaka kire morĩrijayu. “Jia kire yi'yurã yija ime”, ãñurã imariᵽotojo, wayuoka baairãte wayuĩabekaja, ba'irĩjia rĩkimaka rikairãte takaja jia jiyiᵽuᵽaka õrĩrijayurã mija ime. ");
INSERT INTO tnc_vpl VALUES ("JM2_2","089_2_2","JAS","2","2","2","Mia je'e: Karemarĩa mija rẽrĩrijayurõ'õrã ĩ'rĩka waᵽajã'rĩakaka jariroaka jããtirã, sajeyoa i'suᵽakajaoka kiᵽitawãjoarã taka'ratatirã etaiki. Aᵽika imaki wayuoka baaiki imarĩ, jariromajaka jããtirã etaiki. ");
INSERT INTO tnc_vpl VALUES ("JM2_3","089_2_3","JAS","2","3","4","Jia jariroaka jããtirã etaikite jiyiᵽuᵽaka õrĩwa'ri, “Ikarã miruᵽabe”, mija ãñu. Wayuoka baaikite ᵽuri, “Torãja mirĩkamaᵽe, merĩberiye'e torãja miruᵽaᵽabe”, mija ãrĩrijayu. I'suᵽaka wayuoka baairãte ãñurã imariᵽotojo, “Imatiyairã nime”, ãrĩwa'ri jia rĩkimakaja ba'irĩjia rikairãte mija baairokaᵽi ᵽuri ba'iaja mija baayu. I'suᵽaka simamaka ĩ'rãtiji jiyiᵽuᵽaka õrĩbu'aberiwa'ri, ĩ'rĩka ta'iarãja imarijaribeyurã mija ime. ");
INSERT INTO tnc_vpl VALUES ("JM2_5","089_2_5","JAS","2","5","5","Ate jia mija ã'mitiᵽe yijeyomarã. “Yire mija ã'mitiriᵽẽabe”, Tuᵽarãte ãrĩkaroka yi'yurã rĩkimarãja nime wayuoka baariᵽotojo sayi'yurã. “Wayuoka baairã ba'iratarã nime”, Tuᵽarãte yi'ribeyurãte nareka ãrĩrijayua imariᵽotojo, Jesucristore yi'yurã nimamaka, “Jiibaji kire yi'yurã najarirũ”, ãrĩwa'ri jia Tuᵽarãte nare jeyobaarijarirãñu. Suᵽa imarĩ kẽrĩka uᵽakaja kika rĩrãkibiriwa'ri kire yi'ririjayurã kijã'merũkirõ'õrã eyarũkirã imarã. ");
INSERT INTO tnc_vpl VALUES ("JM2_6","089_2_6","JAS","2","6","7","I'suᵽaka kẽrĩka simako'omakaja wayuoka baairãte jiyiᵽuᵽaka õrĩbeyurã mija ime. Wayuoka baairãreka i'suᵽaka õrĩriᵽotojo, rĩkimaka ba'irĩjia rikairãte takaja jiyiᵽuᵽaka õrĩrijayurã mija ime. “¿Naᵽareareka ba'iaja majũarijayu”, mija ãrĩwãrũbeyu bai je'e? Mia: Ba'iaja mijare baawa'ri ĩᵽarimarã ᵽõ'irã mijare okabaarĩ ne'ewa'ririjayu. Suᵽabatirã jiitakiji Jesúre imako'omakaja kirika bojariroka ã'mitiririᵽe'yowa'ri ba'iaja kireka jaiyuyeirã nime. Jesúrirã imariᵽotojo ¿dikaᵽi ãrĩwa'ri jia nareka mija ᵽuᵽajoayu je'e? ");
INSERT INTO tnc_vpl VALUES ("JM2_8","089_2_8","JAS","2","8","8","Ikuᵽaka maiᵽamaki Jesúre mare jã'meka: “Miᵽo'ia miwãtaika uᵽakaja aᵽerãteoka miwayuĩabe”, ãrĩwa'ri sabojayu Tuᵽarã majaroᵽũñureka. I'suᵽaka sareka ãñua mija yi'rirãkareka jia baairã mija imarijarirãñu. ");
INSERT INTO tnc_vpl VALUES ("JM2_9","089_2_9","JAS","2","9","9","Ika mijare ñañua õñurã imariᵽotojo, jia mijare eyairãte takaja mija wayuĩamaka, “Mija õñu uᵽakaja ba'iaja baairã mija jayu, yijã'meika yi'ribeyurã imarĩ”, Tuᵽarãte mijare ãñu. ");
INSERT INTO tnc_vpl VALUES ("JM2_10","089_2_10","JAS","2","10","10","Mare kijã'meika simaja yi'yurã imariᵽotojo, ĩ'rãba'i mayi'ribeyua imarãkareka, “Ba'iaja baairã nime yijã'meika yi'ribeyurã imarĩ”, mareka kẽrĩrãñu. ");
INSERT INTO tnc_vpl VALUES ("JM2_11","089_2_11","JAS","2","11","11","Ikuᵽaka sime aᵽeba'i Tuᵽarãte bojaeka: “Rõmikirã, i'suᵽakajaoka tĩmiakirã, aᵽerãka ba'iaja baawã'imaᵽekaja mija imabe. Suᵽabatirãoka ᵽo'imajare jããbekaja mija imabe”, mare kẽrĩka. Rõmikirã ᵽuri i'suᵽaka kẽrĩka yi'ᵽaraka imarã, aᵽerãka ba'iaja baawã'imarĩbeyurã imariᵽotojo ᵽo'imajare mija jããrãkareka kijã'meika yi'ribeyurã mija imarãñu. ");
INSERT INTO tnc_vpl VALUES ("JM2_12","089_2_12","JAS","2","12","13","Ba'iaja baarika maja'ataokaro'si kirika bojariroka Tuᵽarãte mare õrĩrũjeyu. I'suᵽaka simamaka samayi'rika, mayi'riberikaoka ĩatirã simauᵽakaja sawaᵽa mare kibaarãñu. Suᵽa imarĩ mokaᵽi, maimabaayu uᵽakaja aᵽerãte mija wayuĩabe. Ĩakõrĩ je'e: Aᵽerimarãre wayuĩabekaja imarã, nare wayuĩabekaja sawaᵽa Tuᵽarãte nare jẽñerãñu. Aᵽerãte wayuĩabaraka imarã ᵽuri “Wayuĩarikaᵽi Tuᵽarãte yijare ĩarãñu”, ãrĩwa'ri jĩjimaka imarã. ");
INSERT INTO tnc_vpl VALUES ("JM2_14","089_2_14","JAS","2","14","14","Mija ã'mitiᵽe yijeyomarã. Ĩ'rĩka “Cristore yi'yuka ñime”, ãrĩriᵽotojo, Tuᵽarãte yaᵽaika uᵽaka aᵽerãte kijeyobaabesarãka, dakowaᵽamarĩa kijaikoᵽeika jarirãka. I'suᵽaka simamaka “Cristore yi'yuka ñime”, kẽñutakaᵽiji Tuᵽarãte tããrũkimarĩka kime. ");
INSERT INTO tnc_vpl VALUES ("JM2_15","089_2_15","JAS","2","15","16","Ã'mitirikõrĩ je'e: Ĩ'rãrimarã muᵽaka Tuᵽarãte yi'yurãte kẽsia baajĩka, suᵽabatirã jariroakaoka wayuoka nabaajĩka ĩariᵽotojo, “Ba'arika, jariroakaoka jia mija tõᵽoerã Tuᵽarãte jia mijare baarũ”, ãrĩrimĩrãkaja mija ãñua jiamarĩa sime. I'suᵽaka ãrĩriᵽotojo nare jeyobaariᵽuᵽamarĩrã mija imajĩka waᵽamarĩaja simajĩñu nare mija jaikoᵽeika. ");
INSERT INTO tnc_vpl VALUES ("JM2_17","089_2_17","JAS","2","17","17","I'suᵽakajaoka sime Tuᵽarãte yi'ririkakaka. “Tuᵽarãte yi'yurã yija ime”, ãñurã imariᵽotojo aᵽerãte jeyobaariᵽuᵽamarĩrã nimajĩka, kire yi'riberiwa'ri suᵽa nabaajĩñu. ");
INSERT INTO tnc_vpl VALUES ("JM2_18","089_2_18","JAS","2","18","18","Yijaika yi'riberiwa'ri ikuᵽaka ĩ'rãrimarãre yire ãrĩjĩñu je'e aᵽeyari: “¿Yaje Tuᵽarãte miyi'ritiyayu je'e mi'ioka?”, yire narĩjĩñu. I'suᵽaka naᵽakã'ã, “Ã'ã, Tuᵽarãro'si jia yibaarijayuaᵽi kire yi'yuka ñima mijare yibeayu”, nare ñarĩrãñu. I'suᵽaka imaki imarĩ, jia nabaarijayua yire nabeabeᵽakã'ã, “Jia Tuᵽarãte yi'yurã nime”, nareka ãrĩwãrũbeyuka yi'i. Yire ᵽuri ritaja jia yibaarijayua ĩatirã, “Rita, jia Tuᵽarãte yi'yuka kime”, narĩwãrũrãñu. ");
INSERT INTO tnc_vpl VALUES ("JM2_19","089_2_19","JAS","2","19","19","Naᵽuᵽajoaikaᵽi ᵽuri “Ĩ'rĩkaja kime Tuᵽarã”, ãrĩᵽuᵽajoairã nime. Rita sime. I'suᵽaka rita ima najaika simako'omakaja aᵽerãte wayuĩabeyurã nimamaka, “Tuᵽarãte yi'yurã nime”, nareka marĩwãrũbeyu. Ĩakõrĩ je'e: “Ĩ'rĩkaja kime Tuᵽarã”, ãrĩᵽuᵽajoairã nime Satanárika ima naro'si. Sõñurã imariᵽotojo tararikaᵽi kire nakĩkirijayu nare kiwẽkomabaarũkirã imarĩ. ");
INSERT INTO tnc_vpl VALUES ("JM2_20","089_2_20","JAS","2","20","21","Jia mija ã'mitiᵽe õrĩᵽũariᵽuᵽamarĩrã. Aᵽerãte jeyobaabeyurã mija imamaka, dako waᵽamarĩa sime Tuᵽarãte yi'yu uᵽaka mija imakoᵽeika. Sõñurã mija imaerã mañeki Abraham imaroyikaki majarokakaka mijare yibojaerã baayu mae. Jia Tuᵽarãte yi'yuka imawa'ri kimakireje kiro'si kijoeĩjirã baakoᵽeka. I'suᵽaka kibaamaka ĩawa'ri, “Jiitakaja yi'yuka kime Abraham”, Tuᵽarãte kireka ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("JM2_22","089_2_22","JAS","2","22","23","Tuᵽarãte jiitakarãja yi'ritiyaiki imarĩ kiyaᵽaeka uᵽakaja Abrahamre baaeka. I'suᵽaka kibaaekaᵽi “Jiitakaja Tuᵽarãte yi'rimirĩrĩkawa'yuki kijarika”, kireka ãrĩwãrũirã mija ime. Bikijarã ikuᵽaka Tuᵽarã majaroka bojaĩjirimajire o'oeka: “Jia Tuᵽarãte yi'yuka Abrahamre imaeka. Suᵽa imarĩ ‘Dako okamirãmarĩaja jia yika kima ñoñu’, Tuᵽarãte ãrĩka”, sãñu. I'suᵽaka kireka kẽrĩka be'erõ'õ Tuᵽarãte yi'ritiyawa'ri kimakireje kiro'si kijããerã baakoᵽeka simamaka Tuᵽarã majaroᵽũñurã o'oeka rita ima. Suᵽabatirãoka “ ‘Yijeyomaki mime’, Abrahamre kẽrĩka”, sãñu. ");
INSERT INTO tnc_vpl VALUES ("JM2_24","089_2_24","JAS","2","24","24","I'suᵽaka Abrahamre baaeka õñurã imarĩ, “ ‘Tuᵽarãte yija yi'yu’, mañujĩkatakaᵽimarĩa jia kika majayu”, ãrĩwãrũirã maime. Kire yi'riwa'ri, kiyaᵽaika uᵽakaja baabaraka maimarãkareka “Dakoa okamirãmarĩrãja jia yika nima ñoñu”, Tuᵽarãte mareka ãrĩrãñu. ");
INSERT INTO tnc_vpl VALUES ("JM2_25","089_2_25","JAS","2","25","25","Ikuᵽaka sime aᵽea: Niñerũ e'eokaro'si ĩmirĩjaka ba'iaja wã'imarĩrirõmo imariᵽotojo ikuᵽaka Rahab imaroyikakote baaeka Tuᵽarãte yi'riwa'ri. Judíorãka ĩᵽamarãre ᵽũataekarãre etamaka ĩatirã, “Mija majamarãre mijare jãã'si, yiwi'iarã mija ru'rikãkabe. Suᵽabatirã ma'a mija ru'riwa'rirũkirõ'õ mijare yibojarãñu”, nare kõrĩka jia nare baawa'ri. I'suᵽaka kobaamaka ĩatirã, “Jiitaka baaiko koime”, Tuᵽarãte koreka ãrĩka. ");
INSERT INTO tnc_vpl VALUES ("JM2_26","089_2_26","JAS","2","26","26","Õrĩkõrĩ je'e: Maᵽo'ia õñimakimarĩa simajĩka dakoaᵽi ãrĩwa'ri õñia imaberijĩka. I'suᵽaka imarika uᵽakajaoka sime, Tuᵽarãte yaᵽaika uᵽakaja baaberikoᵽeriᵽotojo, “Kire yi'yurã yija ime”, marĩkoᵽejĩka. ");
INSERT INTO tnc_vpl VALUES ("JM3_1","089_3_1","JAS","3","1","1","Yijeyomarã, ĩ'rĩka uᵽakaja Tuᵽarãrika bojariroka wãrõrimaja oyiaja imarika mija ᵽuᵽajoa'si. Ĩ'rãrimarãja sawãrõrimaja mija imajĩkareka jia simajĩñu. Ikuᵽaka mija õñu: Tuᵽarãrika nare nawãrõika uᵽakaja nayi'riberijĩkareka, aᵽerã ᵽemawa'ribaji sawaᵽa nare Tuᵽarãte jẽñerãñu. ");
INSERT INTO tnc_vpl VALUES ("JM3_2","089_3_2","JAS","3","2","2","Rĩkimakaja sime ba'iaja mabaaika. I'suᵽaka simako'omakaja, sarakajeᵽããtirã jia jaibaraka imarã tarãja nime ritaja Tuᵽarãte yaᵽaika uᵽakaja baawãrũrijayurã. ");
INSERT INTO tnc_vpl VALUES ("JM3_3","089_3_3","JAS","3","3","3","Kũᵽajĩka marẽrõkaka imako'omakaja, saᵽi jaibaraka rĩkimaka ba'iaja maᵽoajiyeyu. Ã'mitirikõrĩ je'e: ikuᵽaka sime ba'iaja majaika: Jo'baki kawarute imakoᵽeko'omakaja kũᵽajĩka ᵽerumijia kirijokoᵽearã maᵽi'ᵽeikaᵽi ãrĩwa'ri kire mabaarũjeika uᵽakaja yi'yuka kime. ");
INSERT INTO tnc_vpl VALUES ("JM3_4","089_3_4","JAS","3","4","4","I'suᵽakajaoka sime jo'baka kũmua saro'si. Wĩrõa jãjia baeko'omakaja kũᵽajĩka wẽrũᵽãiaᵽi samatemarĩkawãrũyu, ma'ririyaᵽairõ'õrã sa'ririka yaᵽawa'ri. ");
INSERT INTO tnc_vpl VALUES ("JM3_5","089_3_5","JAS","3","5","5","I'suᵽakajaoka sime marẽrõkaka. Kũᵽajĩka simako'omakaja saᵽi ãrĩwa'ri aᵽerãreka ba'iaja majaiyu, “Imatiyairã imarĩ, aᵽerãte ᵽemawa'ribajirã yija ime”, ãrĩᵽuᵽajoawa'ri. Mia, i'suᵽakajaoka sime ᵽeka saro'si. Kũᵽajĩtakajĩkaᵽi mawããika imariᵽotojo jo'baka rioᵽakiaka sajoeyu. ");
INSERT INTO tnc_vpl VALUES ("JM3_6","089_3_6","JAS","3","6","6","I'suᵽaka sime marẽrõkaka. Saᵽi ba'iaja jaibaraka rĩkimarã aᵽerãte ba'iaja majũarũjeyu. Majaika ã'mitiritirã “Ritaoka ba'iaja baairã nime”, aᵽerãte mareka ãrĩwãrũrijayu. Ba'iaja jaiwa'ri maimarika mabitatarijayu. Suᵽabatirã aᵽerãte ba'iaja baairã majarirũjeyu. Satanáre ba'iaja mare jairũjemaka, i'suᵽaka maro'si simarijayu. ");
INSERT INTO tnc_vpl VALUES ("JM3_7","089_3_7","JAS","3","7","7","Mia. Ritaja ba'irĩjia ima, wĩ'ñaka, ãñaka, suᵽabatirã riakakakaoka ᵽo'imajarũjewãrũirã maime. ");
INSERT INTO tnc_vpl VALUES ("JM3_8","089_3_8","JAS","3","8","8","I'suᵽaka simako'omakaja ba'iaja majaika ᵽoto, “I'suᵽaka jaibekaja maimaye'e”, ãrĩwãrũbeyurã maime, sarakajeᵽããwãrũberiwa'ri. I'suᵽakajaoka ãñaka mare kukuika ᵽoto sayi'aika uᵽaka majaikaᵽi ba'iaja aᵽerãte maimarũjeyu. ");
INSERT INTO tnc_vpl VALUES ("JM3_9","089_3_9","JAS","3","9","10","I'suᵽaka simamaka “Jia yijare mibaayu”, Maᵽaki Tuᵽarãte ãñurã imariᵽotojo, “Ba'iaja najũarũ”, ãrĩwa'ri aᵽerãreka majairijayu. Yijeyomarã, i'suᵽaka jaiyuyebu'abekaja maimaye'e, “Ñima uᵽakaja nimarũ”, ãrĩwa'ri Tuᵽarãte ᵽo'ijiaekarã maimamaka. ");
INSERT INTO tnc_vpl VALUES ("JM3_11","089_3_11","JAS","3","11","11","Õrĩkõrĩ je'e: ¿Okokoᵽea jia waria okoa ᵽoataika, jũ'akaᵽitiyika rukubaka ᵽorijĩka rukuya mijareka? ");
INSERT INTO tnc_vpl VALUES ("JM3_12","089_3_12","JAS","3","12","12","I'suᵽakajaoka higuerajũki imariᵽotojo olivo wãmeika õterikirika uᵽaka ruiberijĩka. I'suᵽakajaoka iyaka, higuerarika uᵽaka rikariberijĩka. Suᵽa imarĩ okoa rukubaka imabeyu uᵽaka aᵽerãreka ba'iaja jaibekaja maimaye'e yijeyomarã. ");
INSERT INTO tnc_vpl VALUES ("JM3_13","089_3_13","JAS","3","13","13","Ĩ'rĩka mija ᵽõ'irã “Tuᵽarãte yaᵽaikakaka õrĩᵽuᵽaiki ñime”, ãñukate imajĩkareka jia oyiaja kibaajĩñu. I'suᵽakajaoka aᵽerãte ᵽemawa'ribaji imabekaja, jia nare kijeyobaarijarijĩñu. I'suᵽaka kibaamaka ĩatirã, “Jia õrĩᵽuᵽaiki imawa'ri, jia baawãrũiki kime”, aᵽerãte kireka ãrĩrãñu. ");
INSERT INTO tnc_vpl VALUES ("JM3_14","089_3_14","JAS","3","14","14","Aᵽerãte oakiriwa'ri nare mija ã'mijĩarãka, suᵽabatirã aᵽerãte ᵽemawa'ribaji imarika mijaro'si takajĩkaja ᵽuᵽajoariᵽotojo, “Jia õrĩᵽuᵽairã yija ime”, ãᵽaraka jĩjimakaᵽi aᵽerãte mija jaikoᵽeyu. I'suᵽaka imawa'ri jia wãjia imakoᵽeikakaka mija ã'mitiriᵽe'yorijayu. ");
INSERT INTO tnc_vpl VALUES ("JM3_15","089_3_15","JAS","3","15","15","I'suᵽaka imarã Tuᵽarãte yaᵽaika uᵽakamarĩa ᵽuᵽajoawa'ri, õrĩᵽuᵽakirãmarĩrã nime. Wejeareka imarãte ᵽuᵽajoairokaᵽi nimarijayu. Suᵽabatirãoka Esᵽíritu Santore ã'mitiriᵽẽabekaja, ba'iaja naᵽuᵽaka nare ãñua Satanárikaᵽi i'taika sime. ");
INSERT INTO tnc_vpl VALUES ("JM3_16","089_3_16","JAS","3","16","16","I'suᵽakajaoka nare oakiᵽaraka aᵽerãte na'mijĩarãka, suᵽabatirã “Nare ᵽemawa'ribaji õñurã yija ime”, narĩrãka rukubaka ᵽuᵽajoairã jariwa'ri, i'suᵽakajaoka ritaja nayaᵽaika uᵽakaja ba'iaja baairã najarirãñu. ");
INSERT INTO tnc_vpl VALUES ("JM3_17","089_3_17","JAS","3","17","17","I'suᵽaka mare simakoreka, ikuᵽaka sime Tuᵽarãte yaᵽaika uᵽaka imarikakaka: Jia oyiaja baabaraka, suᵽabatirãoka jia aᵽerãka imariyaᵽawa'ri oka naka jiebaraka maimarijarirãñu. I'suᵽaka simamaka aᵽerãte ãñua ã'mitiritirã, mayaᵽaikatakaja ᵽuᵽajoabekaja, jia nare mawayuĩarãñu. Suᵽabatirãoka wayuĩabu'awa'ri jia ĩ'rãtiji jeyobaabu'abaraka maimarijariye'e. I'suᵽakajaoka waᵽuju ᵽakibu'abekaja, mañu uᵽakaja baabaraka maimaye'e. ");
INSERT INTO tnc_vpl VALUES ("JM3_18","089_3_18","JAS","3","18","18","Suᵽabatirã aᵽerãka jia imarijariwa'ri, oka jiebaraka jia natiyiaja nimaerã aᵽerãte jeyobaarimaja ᵽuri jiitakaja baairã imarã. I'suᵽaka imarã nimamaka, najeyobaairãoka jia imarã jarirãñurã naro'si. ");
INSERT INTO tnc_vpl VALUES ("JM4_1","089_4_1","JAS","4","1","1","I'suᵽaka yi'ribu'abeyurã imarĩ mija tiyiaja jãjirokaᵽi ba'iaja jaibu'arika imarijayua mijaro'si. Ĩakõrĩ je'e: Mija ᵽuᵽaka mijare ãñu uᵽakaja baariyaᵽawa'ri Tuᵽarãte yaᵽaika uᵽaka mija baabeyu. ");
INSERT INTO tnc_vpl VALUES ("JM4_2","089_4_2","JAS","4","2","2","I'suᵽaka imarã imarĩ mija yaᵽaika uᵽaka mijare imarũjebeyurãte mija ri'kakoᵽeyu. Nayaᵽaika uᵽaka ima tõᵽowãrũirãte ĩatirã nare mija oakiririjayu nuᵽaka satõᵽowãrũbeyurã imarĩ. Marãkã'ã baatirã satõᵽowãrũbeyurã imarĩ, boebariwa'ri okajãjiaᵽi mija ᵽiᵽebu'arijayu. I'suᵽaka mijaro'si sime mija yaᵽaika Tuᵽarãte mija jẽñerijaribeyua simamaka. ");
INSERT INTO tnc_vpl VALUES ("JM4_3","089_4_3","JAS","4","3","3","Kire mija jẽñekoᵽeika ᵽoto ba'iaᵽiji kire mija jẽñeika simamaka mijare sakija'atabeyu. Mia je'e: Mijaro'sitakaja ᵽuᵽajoabaraka Tuᵽarãte mija jẽñekoᵽeyu, jĩjimaka mija imarũkitakaja ᵽuᵽajoarijayurã imarĩ. ");
INSERT INTO tnc_vpl VALUES ("JM4_4","089_4_4","JAS","4","4","4","I'suᵽaka imawa'ri Tuᵽarãte yaᵽabeyurãte ima uᵽaka mija ime mijaro'si. Tuᵽarãte yi'ribeyurã ᵽuri, õñia nimatiyikuriji nayaᵽaika takaja ᵽuᵽajoawa'ri ba'iaja baarijayurã nime. Nuᵽaka ᵽuᵽajoawa'ri ba'iuᵽakaja Tuᵽarãte baawã'imarĩrimaja uᵽaka mija jayu. ");
INSERT INTO tnc_vpl VALUES ("JM4_5","089_4_5","JAS","4","5","5","Rita sime, ĩakõrĩ je'e. Ikuᵽaka sabojayu Tuᵽarã majaroᵽũñurã kire bojaĩjirimajire o'oeka: Mare kiᵽo'ijiaeka simamaka, “Yire oyiaja ã'mitiriᵽẽatiyairã nimarũ”, ãrĩwa'ri Tuᵽarãte mare wayuĩayu. ");
INSERT INTO tnc_vpl VALUES ("JM4_6","089_4_6","JAS","4","6","6","I'suᵽaka simamaka “Jia ᵽo'imajare yire ã'mitiriᵽẽarũ”, ãrĩwa'ri nare jeyobaarika ᵽuᵽajoarijayuka kime Tuᵽarã. Rita ñañu ĩakõrĩ je'e: “Naᵽuᵽaka nare ᵽakimakaja ‘Õrĩtiyairã yija ime’, ãñurãte jeyobaabeyuka kime Tuᵽarã. ‘Aᵽerãte ᵽemawa'ribaji imabeyurã yija ime’, ãñurãte ᵽuri jia kijeyobaayu”, ãrĩwa'ri sabojayu kimajaroᵽũñurã. ");
INSERT INTO tnc_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","7","I'suᵽaka ima ᵽuᵽajoawa'ri “Tuᵽarã, ñiᵽamaki mime”, ãrĩwa'ri kiyaᵽaika uᵽaka oyiaja baabaraka mija imabe. Saᵽi mija imarãkareka Satanáre mija ᵽe'yomaka mijare ba'iaja baarũjewãrũberiwa'ri mijareka kiru'rirãñu. ");
INSERT INTO tnc_vpl VALUES ("JM4_8","089_4_8","JAS","4","8","8","Tuᵽarãka jiibaji rĩrãkibiᵽaraka mija imarãkareka jiibaji mijare kiwayuĩarãñu. Mija ã'mitiᵽe ba'iaja baairã. I'suᵽaka mijare baaiki kimamaka ba'iaja mija baaika ja'atatirã, jia oyiaja mija imarijaᵽe. I'suᵽakajaoka ba'iaja ᵽuᵽajoabekaja “Tuᵽarãte yaᵽaika takaja yija baarãñu”, ãrĩwa'ri ĩ'rãrokaᵽiji ña'rĩyaarĩji mija imabe. ");
INSERT INTO tnc_vpl VALUES ("JM4_9","089_4_9","JAS","4","9","9","Mia je'e: Ba'iaja baariᵽotojo jĩjimaka mija imarijayu. I'suᵽaka imabekaja, “Ba'itakaja baairã yija ime”, ãᵽaraka rĩomarĩtirã mija ᵽuᵽaᵽe'ᵽe. ");
INSERT INTO tnc_vpl VALUES ("JM4_10","089_4_10","JAS","4","10","10","Toᵽi mae kireka ᵽemawa'ribaji mija ᵽuᵽaka baabeyurã mija ima ĩatirã “Imatiyairã nimajiᵽarũ”, Tuᵽarãte mijareka ãrĩrãñu. ");
INSERT INTO tnc_vpl VALUES ("JM4_11","089_4_11","JAS","4","11","11","Mija ã'mitiᵽe yijeyomarã. Ba'iaja jaiwã'imarĩbu'abekaja mija imabe. Suᵽabatirã “Ba'iaja imawa'ri ba'iaja jũarũkirã nime”, nareka mija ãrĩrijaria'si. Ika mijare ñañua yi'ᵽekaja ba'iaja mija jeyomarãreka jaiwã'imañurã mija imarãkareka ᵽuri, “Mija ᵽo'ia mija wãtaika uᵽakaja aᵽerãte mija wãtabe”, ãrĩwa'ri Tuᵽarãte jã'meika yi'ribeyurã mija imarãñu. “Tuᵽarãte jã'meika yi'rirũkimarĩa sime”, ãñurã uᵽaka “Ba'iaja jũarũkirã nime”, mija ãrĩkoᵽeyu. ");
INSERT INTO tnc_vpl VALUES ("JM4_12","089_4_12","JAS","4","12","12","I'suᵽaka simako'omakaja Tuᵽarã ĩ'rĩkaja imaki “Ikuᵽaka jia mija baabe”, ãrĩwa'ri mare jã'mewãrũiki. Suᵽa imarĩ Tuᵽarãjaoka imaki ritaja ᵽo'imajare baaika ĩawãrũtirã, ba'iaja imarika tiyibeyurõ'õrã na'rirũkia imaekareka nare jeyobaaiki. I'suᵽakajaoka, ikijioka imaki ba'iaja imarika tiyibeyurõ'õrã ᵽo'imajare ᵽũatarimaji. ¿Tuᵽarã ĩ'rĩkaja i'suᵽaka baarimajire imako'omakaja mija jeyomarãreka “Ba'iaja baarimaja nime”, ãrĩwãrũirã mija ime bai je'e? ");
INSERT INTO tnc_vpl VALUES ("JM4_13","089_4_13","JAS","4","13","13","Mia je'e. “Ireje ma'riberiye'e, waeroka aᵽea wejearã a'ritirã ĩ'rãkuri wejejẽ'rãkareka mawaruaka ĩjiᵽatatirã rĩkimakaja niñerũ matõᵽoari”, ãᵽaraka jĩjimaka mija imarijayu ĩ'rãrimarã. I'suᵽaka ãñurãte yokajããerã baayu mae. ");
INSERT INTO tnc_vpl VALUES ("JM4_14","089_4_14","JAS","4","14","14","“Waeroka i'suᵽaka yijaro'si simarãñu”, mija ãrĩwãrũbeyua sime. Ñoaka õñia imarũkimarĩrã maime. Ĩakõrĩ je'e: Bikitojo namasika ruika ñojimarĩji ririᵽataika uᵽaka maime. ");
INSERT INTO tnc_vpl VALUES ("JM4_15","089_4_15","JAS","4","15","15","“Tuᵽarãte yaᵽajĩkareka, õñia yija imatiyikuri ikuᵽaka yija baarãñu, isiaoka yija baajĩñu”, mija ãrĩrãka jia simarãñu mijaro'si. ");
INSERT INTO tnc_vpl VALUES ("JM4_16","089_4_16","JAS","4","16","16","I'suᵽaka simako'omakaja Tuᵽarãte yaᵽaika ᵽuᵽajoabekaja mija ᵽuᵽayariji mija baarũkitakaja bojarijaᵽaraka jĩjimaka mija ime. I'suᵽaka mija bojakoᵽeika yaᵽabeyuka Tuᵽarã. ");
INSERT INTO tnc_vpl VALUES ("JM4_17","089_4_17","JAS","4","17","17","Suᵽa imarĩ ika mijaro'si yo'orijayua ĩatirã, “Ikuᵽaka maimarika Tuᵽarãte yaᵽayu're”, ãrĩwãrũriᵽotojo samija baabesarãkareka, ba'iaja baairã mija imarãñu. ");
INSERT INTO tnc_vpl VALUES ("JM5_1","089_5_1","JAS","5","1","1","Dakoa wayuoka baabeyurã imariᵽotojo Tuᵽarãte yi'ribeyurã, yire mija ã'mitiritiyabe. Ñamajĩ ba'iaja jũarũkirã imarĩ ba'itakaja ᵽuᵽaribaraka mija imabe. ");
INSERT INTO tnc_vpl VALUES ("JM5_2","089_5_2","JAS","5","2","2","Mia je'e, ritaja mija rikaika rabaika uᵽaka sime. Suᵽabatirã, jía jariroaka mija rikakoᵽeikaoka butu ba'arikaro'siji sime. ");
INSERT INTO tnc_vpl VALUES ("JM5_3","089_5_3","JAS","5","3","3","Suᵽabatirã mija oro, i'suᵽakajaoka mija niñerũ rĩkimakaja tõᵽotirã samija jietaruᵽamaka bitamarĩka uᵽaka sajayu. I'suᵽaka simamaka ĩawa'ri “Wayuoka baairãte saᵽi najeyobaari imakoᵽeyu”, aᵽerãte mijareka ãrĩrãñu. No'ojĩrãmarĩaja wejetiyia seyarũkia jariwa'riko'omakaja rĩkimabaji niñerũ mija mo'arijayu. Saᵽi ãrĩwa'ri ba'iaja baarika tiyibeyurõ'õrã a'rirũkirãja mija ime. ");
INSERT INTO tnc_vpl VALUES ("JM5_4","089_5_4","JAS","5","4","4","Aᵽea, mija õteriki rioa ba'iraberimajare waᵽaĩjibeyurã mija ime. I'suᵽaka mija baaika ĩaiki kime Tuᵽarã. Suᵽabatirã “Jia naro'si yija ba'irabeko'omakaja, yijare nawaᵽaĩjibeyu”, mijareka nañua ã'mitiyuka kime. ");
INSERT INTO tnc_vpl VALUES ("JM5_5","089_5_5","JAS","5","5","6","Suᵽabatirã ba'iaja baabeyurãteje mija okabaarijayu ĩᵽarimarã wãjitãji. I'suᵽaka nare mija baariᵽareareka ĩ'rãrimarã wayuoka baairãteje najããroyika. I'suᵽaka ba'iaja nare mija baamaka, marãkã'ã mabaaberijĩka naro'si simamaka ba'iaja nare mija baaeka narakajeᵽããeka. Dika jariwa'ririmarĩaja rikairã imarĩ õñia mija imatikurijĩkaja mija baariyaᵽaika uᵽakaja baarijayurã mija ime. Ikuᵽaka sime ã'mitirikõrĩ je'e: Wa'ibikirãwẽkoa najããerã baaika ruᵽu rĩkimakaja sanaji'ayu jia ũkirika sajarirãka ᵽoto sajããokaro'si. I'suᵽarã mija imamaka “Õñia nimarõ'õjĩtejĩka takaja jia nimakoᵽeyu, ba'iaja jũarũkirã imariᵽotojo”, Tuᵽarãte mijareka ãñu. ");
INSERT INTO tnc_vpl VALUES ("JM5_7","089_5_7","JAS","5","7","7","Yijeyomarã wãtaka ñoñurã, mae aᵽea ate mijare yibojaerã baayu. Ã'mitirikõrĩ je'e: Aᵽerãte ba'iaja mijare baariwã'imarĩko'omakaja Maiᵽamakire i'tarũkia ᵽuᵽajoabaraka kiyaᵽaika uᵽakaja baabaraka mija imarijaᵽe. Mia aᵽea, ikuᵽaka õterikia õterimajire ime: Sakiõterãka be'erõ'õ ᵽu'erõ'õ seyarãka ᵽoto “Jãjia yiro'si jariwa'ri jia saruirãñu je'e”, ãrĩwa'ri jajumarĩaja sakita'ayu. ");
INSERT INTO tnc_vpl VALUES ("JM5_8","089_5_8","JAS","5","8","8","I'suᵽakajaoka mija imarijaᵽe mijaoka, Maiᵽamakire ᵽe'rietarũkia ta'abaraka kiyaᵽaika uᵽaka baarija'atabekaja. “No'ojĩrãmarĩaja sajariwa'yu ᵽo'imajare baaika mirãka ĩarĩ ketarũkia”, ãrĩwa'ri i'suᵽaka mija imabe. ");
INSERT INTO tnc_vpl VALUES ("JM5_9","089_5_9","JAS","5","9","9","Yijeyomarã, “Ba'iaja baarimajarata nime”, ãᵽaraka Tuᵽarãte yi'yurãreka jaibu'abekaja mija imabe, sawaᵽa Maiᵽamakite ba'iaja mijare jũarũjekoreka. “No'ojĩrãmarĩaja sajariwa'yu kiᵽe'rietarũkia”, ãrĩwa'ri i'suᵽaka mijare ñañu. ");
INSERT INTO tnc_vpl VALUES ("JM5_10","089_5_10","JAS","5","10","10","Yijeyomarã, ã'mitirikõrĩ je'e. Ikuᵽaka nimaeka Tuᵽarãro'si bojaĩjirimaja: Ba'iaja ᵽo'imajare nare baako'omakaja, sarakajeᵽããbaraka Tuᵽarãro'si bojaĩjirijaᵽaraka nimaeka. I'suᵽaka nimaeka simamaka nimaeka uᵽakaja mija imabe mijaro'si. ");
INSERT INTO tnc_vpl VALUES ("JM5_11","089_5_11","JAS","5","11","11","Õrĩkõrĩ je'e: Ba'iaja jũariᵽotojo Tuᵽarãte yi'riwa'ri sarakajeᵽããrijayurãreka “Jiirã nime Tuᵽarã ñakoareka”, ãñurã maime. I'suᵽaka kimaeka Job imaroyikaki kiro'si. Ĩ'rãba'imarĩa ba'iaja jũariᵽotojo Tuᵽarãte yi'ririja'atabeyuka kimaeka. Suᵽa imarĩ ba'iaja kijũaeka be'erõ'õᵽi ᵽuri jia imarika kitõᵽoeka õñurã mija ime. Suᵽa simamaka “Mare wayuĩatiyaiki imarĩ, jia Tuᵽarãte mare baarũkirã maime”, ãñurã mija ime. ");
INSERT INTO tnc_vpl VALUES ("JM5_12","089_5_12","JAS","5","12","12","Yijeyomarã ikuᵽaka sime aᵽea imatiyaikakaka: “Ikuᵽaka yija baarãñu”, mija ãñu be'erõ'õ simauᵽakaja mija baarijaᵽe. Rita mija ãñua, “Tuᵽarã ᵽariji õñuka yija ãñua”, mija ãrĩa'si. Suᵽa imarĩ rita ãrĩrijayurã mija imamaka, “Jee”, mija ãrĩrãka, “Jẽno'o”, mija ãrĩrãkaoka, mijare nayi'rirãñu. I'suᵽaka imarã mija imamaka, sawaᵽa Tuᵽarãte mijare jẽñebesarãñu. ");
INSERT INTO tnc_vpl VALUES ("JM5_13","089_5_13","JAS","5","13","13","Aᵽea mia. Ka'wisika mija jũaika ᵽoto, “Tuᵽarã, yire mijeyobaabe”, kire mija ãrĩrijaᵽe. I'suᵽakajaoka jĩjimaka mija imarãka ᵽoto Tuᵽarãte jiyiᵽuᵽayeebaraka mija bayakoyabe. ");
INSERT INTO tnc_vpl VALUES ("JM5_14","089_5_14","JAS","5","14","15","I'suᵽakajaoka ĩ'rĩkate wãmarĩa jarirãka ᵽoto Cristorika yi'yurãte imaruᵽutarimajare mija akabe. Nare mija akamaka wãmarĩa imaki ᵽõ'irã etatirã kũᵽajĩ iyebaka kiᵽo'iarã nabu'arãñu. Suᵽabatirã “Marãkã'ã baawãrũberiwa'ri Tuᵽarã ᵽuri kire tããrãki”, ãrĩwa'ri kire najẽñemaka, wãmarĩa imakite jãjirãñu. Suᵽabatirã ba'iaja kibaaeka kireka imajĩkarekaoka sareka kire kiwayuĩarãñu. ");
INSERT INTO tnc_vpl VALUES ("JM5_16","089_5_16","JAS","5","16","16","I'suᵽaka wayuĩaiki Tuᵽarãte imamaka ba'iaja mija baaika mija bojabu'abe. Samija bojabu'arãka be'erõ'õᵽi mija tiyiaja Tuᵽarãte mija jẽñebe sareka mijare kijieokaro'si. Tuᵽarãte yaᵽaika uᵽakaja jiiᵽuᵽarã maimarãkareka, kire majẽñeika uᵽakaja jiaᵽi mare ã'mitiritirã tẽrĩwa'ribaji mare jeyobaarũkika kime. ");
INSERT INTO tnc_vpl VALUES ("JM5_17","089_5_17","JAS","5","17","17","Tuᵽarãro'si bojaĩjirimaji, Elías imaroyirekaki, muᵽaka ᵽo'imajiji imaekaki kiro'si. I'suᵽaka imariᵽotojo, Israel ka'iarã okoa jaririka yaᵽaberiwa'ri Tuᵽarãte kijẽñeka uᵽakaja, maekarakakuri wejejẽ'rã aᵽejẽ'rã ñe'metãjirõ'õjĩrã okoa jariberika. ");
INSERT INTO tnc_vpl VALUES ("JM5_18","089_5_18","JAS","5","18","18","I'suᵽaka simaeka be'erõ'õ, torã okoa jaririka yaᵽawa'ri Tuᵽarãte kijẽñemaka okoa jarika ate. I'suᵽaka sabaaeka be'erõ'õᵽi jia õterikia ruika mae. ");
INSERT INTO tnc_vpl VALUES ("JM5_19","089_5_19","JAS","5","19","20","Mija ã'mitiᵽe yijeyomarã. Mija watoᵽekarã ĩ'rĩka Tuᵽarãte yaᵽaika uᵽaka imarika õrĩriᵽotojo saja'atawa'ri ba'iaja baarimaji jarijĩkite, mija jeyobaabe. Jia Jesucristore yi'yuka kijariᵽe'aokaro'si kire jeyobaaiki ᵽuri jia kire baarãki. Ika jia mija õᵽe: I'suᵽaka jia kire kijeyobaamaka, rĩkimaka ba'iaja kibaaikareka Tuᵽarãte kire saye'kariarãñu. I'suᵽaka simamaka kireyarãka ᵽoto ba'iaja jũarika tiyibeyurõ'õrã ke'rirũkia imakoᵽeikareka kire kitããrãñu. I'tojĩrãja sime ruᵽu.");
INSERT INTO tnc_vpl VALUES ("J11_1","092_1_1","1JN","1","1","1","Yijeyomarã, “Ikuᵽaka Jesucristore ime”, ãrĩwa'ri mijaro'si yo'oerã baayu mae. Ã'mitirikõrĩ je'e: Tuᵽarãte ãñu uᵽakaja mare baabeaiki imarĩ, imajiᵽarũkirã mare imarũjerimaji kime. Suᵽabatirãoka wejea ᵽo'ijirirã baaeka ruᵽubajirã imatikaki kime. Yija õñu uᵽakaja kire yija ã'mitirika, kire yija ĩaeka, suᵽabatirã kire raberoyikarã imarĩ, i'suᵽaka mijare sayibojayu. ");
INSERT INTO tnc_vpl VALUES ("J11_2","092_1_2","1JN","1","2","2","Kika yija imaroyika ᵽoto kire yija ĩaeka simamaka, “Rita sime”, ãrĩwa'ri mijare sayibojaerã baayu. Ã'mitirikõrĩ je'e: Iki Jesucristojo imaki mareyarãka ᵽoto õñia kika mare imajiᵽarũjerũkika. Suᵽabatirãoka, Kiᵽaki Tuᵽarãka imajiᵽaroyikaki kimaeka. I'suᵽaka simamaka, Tuᵽarãte yija ᵽõ'irã kire ᵽũataeka kire yija ĩaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("J11_3","092_1_3","1JN","1","3","3","I'suᵽaka simamaka yija ĩaeka, yija ã'mitirika mirãkaoka mijare yibojayu yijaka ĩ'rĩka uᵽakaja mija ᵽuᵽajoaokaro'si. Maᵽaki Tuᵽarãte, Kimaki Jesucristoᵽitiyika ĩ'rĩka uᵽakaja naᵽuᵽaka ima uᵽakaja ᵽuᵽajoairã yija ime yijaro'si. Suᵽa imarĩ, i'suᵽakajaoka mija imarika yaᵽawa'ri ikuᵽaka mijaro'si yo'oyu. ");
INSERT INTO tnc_vpl VALUES ("J11_4","092_1_4","1JN","1","4","4","Ikuᵽaka mijare sayibojayu ĩ'rĩka uᵽaka oyiaja ᵽuᵽajoatirã jĩjimaka maimaerã. ");
INSERT INTO tnc_vpl VALUES ("J11_5","092_1_5","1JN","1","5","6","Mija ã'mitiᵽe. “Ba'iaja baariroka imabeyua Tuᵽarãreka”, ãᵽaraka Jesúre yijare bojaraᵽe. Ikuᵽaka sime: Ba'iaja baarijayurã imariᵽotojo “Tuᵽarãte ᵽuᵽajoaika uᵽakajaoka ᵽuᵽakirã yija ime yijaro'si”, ãñurã ᵽuri jairimirãkatakaja sajairiwã'imañurã. I'suᵽaka imawa'ri, wãjiroka ima yi'ribeyurã nime. ");
INSERT INTO tnc_vpl VALUES ("J11_7","092_1_7","1JN","1","7","7","I'suᵽaka baabekaja Tuᵽarãte ᵽuᵽajoaika uᵽaka jia oyiaja baabaraka maimarãka ᵽuri, ĩ'rĩka uᵽakaja maimarijarirãñu. I'suᵽaka simamaka Kimaki Jesucristore maro'si riwejurubaraka reyaĩjikaᵽi ãrĩwa'ri ritaja ba'iaja mabaarijayua mareka kiye'kariarijayu. ");
INSERT INTO tnc_vpl VALUES ("J11_8","092_1_8","1JN","1","8","8","“Ba'iaja baabeyurã yija ime”, ãñurã ᵽuri, waᵽuju imaja yi'yurã imariᵽotojo noñu uᵽakaja naᵽo'iaja ᵽarebaarijayurã. Ĩ'rãjaoka imarã wãjiroka ᵽuᵽajoarika yaᵽaberirijayurã. ");
INSERT INTO tnc_vpl VALUES ("J11_9","092_1_9","1JN","1","9","9","I'suᵽaka baabekaja “Ikuᵽaka ba'iaja yibaayu”, ãᵽaraka wããrõ'õrãja Tuᵽarãte samabojarãkareka, sakiye'kariarijarirãñu. I'suᵽaka mare baatirã “Oka nare imabeyua mae”, mare kẽrĩrãñu. I'suᵽaka jia mare kibaarãñu wãjirokaᵽi kẽñu uᵽaka oyiaja baaiki imarĩ. ");
INSERT INTO tnc_vpl VALUES ("J11_10","092_1_10","1JN","1","10","10","“Ba'iaja baairã oyiaja ᵽo'imajare ime”, Tuᵽarãte ãrĩtika sime. I'suᵽaka simako'omakaja “Ba'iaja baakoribeyurã yija ime”, ãñurã ᵽuri “Tuᵽarãte ãñua ᵽakirika sime”, ãñurã uᵽaka nime. ");
INSERT INTO tnc_vpl VALUES ("J12_1","092_2_1","1JN","2","1","1","Ã'mitirikõrĩ je'e. Yimakarã uᵽakaja wãtaka ñoñurã mija ime. Suᵽa imarĩ, ba'iaja mija baakoreka, ikuᵽaka mijaro'si yo'oyu. Aᵽerikuri ba'iaja mabaarijayua simako'omakaja, Jesucristore maro'si Maᵽaki Tuᵽarãka jaiĩjirijayu. Tuᵽarãte ĩarijiyuika oyiaja baaiki imarĩ, i'suᵽaka maro'si baawãrũiki kime. ");
INSERT INTO tnc_vpl VALUES ("J12_2","092_2_2","1JN","2","2","2","I'suᵽaka baaiki imarĩ, ba'iaja mabaaika waᵽa maro'si kireyaeka, saᵽi ãrĩwa'ri ba'iaja mabaaika Tuᵽarãte mare ye'kariarũkia simamaka. Maro'si takajamarĩa, ritaja ᵽo'imajaro'si ᵽariji i'suᵽaka simaokaro'si suᵽa kibaaeka. ");
INSERT INTO tnc_vpl VALUES ("J12_3","092_2_3","1JN","2","3","3","Ikuᵽaka sime: Tuᵽarãte jã'meika uᵽakaja yi'riwa'ri, “Kire õñurã maime”, marĩwãrũyu. ");
INSERT INTO tnc_vpl VALUES ("J12_4","092_2_4","1JN","2","4","4","“Tuᵽarãte õñurã yija ime”, ãrĩriᵽotojo, kijã'meika yi'ribeyurã ᵽuri, waᵽuju ᵽakirimaja nime. I'suᵽaka nabaarijayu Tuᵽarãrikakaka wãjia ima uᵽaka imarijaribeyurã. ");
INSERT INTO tnc_vpl VALUES ("J12_5","092_2_5","1JN","2","5","5","Tuᵽarãte jã'meika uᵽakaja baarijayuka ᵽuri, kire yaᵽatiyarĩji yaᵽaiki. I'suᵽaka imawa'ri, “Tuᵽarãka ĩ'rãtiji ᵽuᵽaika maime”, marĩwãrũrãñu. ");
INSERT INTO tnc_vpl VALUES ("J12_6","092_2_6","1JN","2","6","6","Suᵽa imarĩ, “Tuᵽarãka ĩ'rãtiji ᵽuᵽakirã maime”, mañaokaro'si Jesucristore imaroyika uᵽakaja imarijaririka sime. ");
INSERT INTO tnc_vpl VALUES ("J12_7","092_2_7","1JN","2","7","7","Yijeyomarã, ika ᵽaᵽeraᵽi maekaka jã'merikakaka ᵽo'ijiyumarĩa mijare yibojayu. Bikijarãja mawayuĩabu'arũkia mija ã'mitiriũ'mura'atikaja sime. ");
INSERT INTO tnc_vpl VALUES ("J12_8","092_2_8","1JN","2","8","8","Maejekakamarĩa simako'omakaja, ᵽo'imajare wayuĩabaraka Jesucristore imaroyika ᵽuᵽajoatirã “Mamamiji yi'rimirĩrĩkawa'rirũkiaro'si sime”, marĩwãrũyu mae. Mijaoka sã'mitiriᵽẽairã imawa'ri aᵽerãte wayuĩairã mija imarijayu mae. Suᵽa imarĩ, “Ba'iaja baarika ja'atatirã, mamaka jia imarũkia yijare beairã nime”, ᵽo'imajare mijareka ãñu. ");
INSERT INTO tnc_vpl VALUES ("J12_9","092_2_9","1JN","2","9","9","Ĩ'rĩka, “Ba'iaja baabekaja Tuᵽarãka ĩ'rãtiji ᵽuᵽajoabaraka ñime”, ãrĩriᵽotojo, Cristore yi'yukate ĩariᵽe'yoiki Tuᵽarãka jia imabeyuka ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("J12_10","092_2_10","1JN","2","10","10","Cristore yi'ririjayurãte wayuĩaiki ᵽuri, Tuᵽarãte ᵽuᵽajoaika uᵽaka jia oyiaja baarijayuka kime. I'suᵽaka imaki imarĩ, ba'ia ᵽuᵽajoaberiwa'ri jia oyiaja Tuᵽarãka kimarijayu. ");
INSERT INTO tnc_vpl VALUES ("J12_11","092_2_11","1JN","2","11","11","Suᵽabatirã Cristore yi'yurãte ĩariᵽe'yoiki ᵽuri Tuᵽarãka ĩ'rãtiji ᵽuᵽajoabeyuka kime. I'suᵽaka baarijari, Tuᵽarãrikakaka yi'ririyaᵽabeyuka imarĩ, ba'iaja kibaarijarirãñu. Õrĩkõrĩ je'e: Neirõ'õrã mawejaᵽayu uᵽaka imaki kime. ");
INSERT INTO tnc_vpl VALUES ("J12_12","092_2_12","1JN","2","12","12","Yimakarã uᵽakaja wãtaka ñoñurã, “Jesucristore reyaekaᵽi ãrĩwa'riji ba'iaja mabaaika Tuᵽarãte mare saye'kariaeka”, ãñurã mija imamaka, ika ᵽaᵽera mijaro'si yo'oyu. ");
INSERT INTO tnc_vpl VALUES ("J12_13","092_2_13","1JN","2","13","13","Ᵽakiarimarã, jia Cristore yi'yurã imarĩ, mija ã'mitiᵽe mijaro'sioka. Wejea ᵽo'ijirirã baaeka ruᵽubajirã imaũ'muekakite õñurã mija imamaka, ika ᵽaᵽera mijaro'si yo'oᵽũayu. Mija ã'mitiᵽe bikirimaja, kire yi'rimirĩrĩkawa'yurã. Satanás, ba'iaja baarimajite ĩ'rãᵽẽ'rõtorãja taairã mija ime. I'suᵽaka imarã mija imamaka, ika ᵽaᵽera mijaro'si yo'oyu. ");
INSERT INTO tnc_vpl VALUES ("J12_14","092_2_14","1JN","2","14","14","Yimakarã uᵽaka wãtaka ñoñurãro'si sayo'oyu ika, Maᵽaki Tuᵽarãte õñurã mija imamaka. Mija ᵽakiarimarã, wejea ᵽo'ijirirã baaeka ruᵽubajirã imaũ'muekakite õñurã mija imamaka, ika ᵽaᵽera mijaro'si yo'oᵽũayu. Mija bikirimaja, okajãjirã imawa'ri, Tuᵽarãrika bojariroka jia yi'ririjayurã mija ime. Suᵽa imarĩ, Satanás, ba'iaja baarimajite ĩ'rãᵽẽ'rõtorãja taairã mija ime. I'suᵽaka mija imamaka, ika ᵽaᵽera mijare yiᵽũatayu. ");
INSERT INTO tnc_vpl VALUES ("J12_15","092_2_15","1JN","2","15","15","Ika wejeareka ba'iaja baarimajare baarijayuakaka baarika ᵽuᵽaᵽekaja mija imabe. Suᵽabatirãoka ba'irĩjia mija yaᵽaikareka takaja mija ᵽuᵽaria'si. Wejeareka ba'iaja imakoᵽeika yaᵽatiyaiki ᵽuri, Maᵽaki Tuᵽarãte yaᵽabeyuka kime. ");
INSERT INTO tnc_vpl VALUES ("J12_16","092_2_16","1JN","2","16","16","Ika wejeareka ba'iaja baarimajare ᵽuᵽajoairokaᵽi mija ᵽuᵽajoa'si. Ã'mitirikõrĩ, ikuᵽaka ᵽuᵽajoairã nime: Ba'iaja baaritakaja yaᵽawa'ri, naᵽuᵽaka nare ãñu uᵽaka ba'iaja nabaarijayu. Suᵽabatirã ritaja ima jiyurika ĩawa'ri, ritaja rikarika nayaᵽayu. I'suᵽakajaoka “Mia. Dakoareka wayuoka baabeyuka ñime”, ãrĩwa'ri jĩjimaka nare simaᵽakirũjeyu. I'suᵽaka ba'iaja nabaarijayua ika wejeakarã ᵽo'imajaᵽiji ᵽo'ijiyua imarĩ, Maᵽakirikamarĩa sime. ");
INSERT INTO tnc_vpl VALUES ("J12_17","092_2_17","1JN","2","17","17","Ika wejeareka Tuᵽarãte yi'ribeyurã, suᵽabatirã ba'iaja nabaarijitoikaoka ᵽurirãka. Tuᵽarãte yaᵽaika uᵽaka oyiaja baairã ᵽuri õñia imajiᵽarãñurã. ");
INSERT INTO tnc_vpl VALUES ("J12_18","092_2_18","1JN","2","18","18","Mija ã'mitiᵽe yijeyomarã. Kũᵽajĩji sajariwa'yu wejetiyiarã seyarũkia. I'suᵽaka simaerã baarãka ruᵽu “Cristore Jo'ata'aikite i'tarãñu”, ãrĩwãrũtikarã mija ime. I'suᵽaka simarãka simako'omakaja, aᵽerã rĩkimarãja Cristore jo'ata'airã imatirijayurã maekakaoka. I'suᵽaka simamaka, “Koyiaja sajariwa'yu wejetiyiarã maeyarũkia”, marĩᵽuᵽajoawãrũrijayu. ");
INSERT INTO tnc_vpl VALUES ("J12_19","092_2_19","1JN","2","19","19","Ikuᵽaka nime, ã'mitirikõrĩ je'e: “Maka imakoᵽeraᵽarã Jesucristore mayi'yurokamarĩa yi'rikoᵽeirã nimaraᵽe”, nareka ãrĩwãrũirã maime. I'suᵽaka imawa'ri mare nakõrõtaᵽaraᵽe. I'suᵽaka Jesucristore mayi'yu uᵽakaja nimarikareka ᵽuri mare nakõrõtaᵽaberijããeka. Suᵽa nabaamaka, “Jesucristorirãmarirã nime”, marĩwãrũrijayu. ");
INSERT INTO tnc_vpl VALUES ("J12_20","092_2_20","1JN","2","20","20","Mija ᵽuri jia rita wãjimijikaka Tuᵽarãrika õñurã imarã. I'suᵽaka mija ime Esᵽíritu Santore mijareka Jesúre ña'ajããeka simamaka. I'suᵽaka mijare kibaaeka simamaka, “Ika nawãrõika rita sime, ika ᵽuri ᵽakirika ima”, ãrĩwãrũirã mija ime. ");
INSERT INTO tnc_vpl VALUES ("J12_21","092_2_21","1JN","2","21","21","Rita ima õrĩbeyurã mija imamakamarĩa ikuᵽaka mijaro'si yo'oyu. Rita ima mija õrĩwãrũyu. I'suᵽakajaoka rita wãjimijikakamarĩa ĩ'rãrimarãre wãrõraᵽaka ã'mitiritirã, “Ᵽakirimaja nime”, ãrĩwãrũirã mija imamaka, ika ᵽaᵽeraᵽi mijare sayibojayu. ");
INSERT INTO tnc_vpl VALUES ("J12_22","092_2_22","1JN","2","22","22","Ikuᵽaka nañu ᵽakirimaja: “Jã'merũkika Tuᵽarãte wã'maekakimarĩka kime Jesús.” I'suᵽaka ᵽakirimaja Cristore jo'ata'airã nime. Suᵽa imawa'ri “Jesús Ᵽakimarĩka Tuᵽarãte ime, suᵽabatirã Kimakimarĩka kime Jesús”, ãñurã nime ᵽakirimaja. ");
INSERT INTO tnc_vpl VALUES ("J12_23","092_2_23","1JN","2","23","23","“Tuᵽarãmakimarĩka kime Jesús”, ãñuka ᵽuri, Tuᵽarãrikimarĩka kime. “Tuᵽarã Makitaki Jesúre ime”, ãñuka ᵽuri Jesús Ᵽakika ĩ'rãtijiji ᵽuᵽaiki kime. ");
INSERT INTO tnc_vpl VALUES ("J12_24","092_2_24","1JN","2","24","24","Cristorika bojariroka ã'mitiᵽaraka mija imara'aeka ã'mitiriᵽẽabaraka mija imabe. I'suᵽaka mija baarijarirãkareka Jesús, Kiᵽakika ĩ'rãtiji ᵽuᵽaᵽaraka rĩrãkibiritiirã mija imarijarirãñu. ");
INSERT INTO tnc_vpl VALUES ("J12_25","092_2_25","1JN","2","25","25","I'suᵽaka simarãñu, “Yire ã'mitiriᵽẽairã õñia imajiᵽarãñurã”, Jesucristore mare ãrĩtika simamaka. ");
INSERT INTO tnc_vpl VALUES ("J12_26","092_2_26","1JN","2","26","26","Ã'mitirikõrĩ je'e: Ĩ'rãrimarã naᵽuᵽajoaika uᵽakaja waᵽuju ᵽakirika mijare wãrõriyaᵽairã. I'suᵽaka õñurã imarĩ, rakajekaja mija imaokaro'si ika ᵽaᵽera mijaro'si yo'oᵽũayu. ");
INSERT INTO tnc_vpl VALUES ("J12_27","092_2_27","1JN","2","27","27","Jesucristore mijareka Esᵽíritu Santo ña'ajããekarã imarã mija ᵽuri. Mijaka imaki imarĩ, mijare wãrõrimaji Esᵽíritu Santore imarijayu. I'suᵽaka imarã imarĩ, aᵽerãte mijare wãrõrika yaᵽabeyurã mija ime. Dika jariwa'ririmarĩa, ᵽakirimarĩaja Esᵽíritu Santore mijare wãrõrijayurã imarĩ, rita imatiyaika mijare kiwãrõrijayu uᵽakaja mija imarijaᵽe. I'suᵽaka imawa'ri Jesucristoka ĩ'rãtiji ᵽuᵽaᵽaraka jia mija imarijaᵽe. ");
INSERT INTO tnc_vpl VALUES ("J12_28","092_2_28","1JN","2","28","28","Yimakarã uᵽakaja wãtaka ñoñurã, ika jia mija ã'mitiᵽe. Jesúka ĩ'rãtijiji ᵽuᵽaᵽaraka, kiyaᵽaika uᵽakaja jia mija imarijaᵽe. I'suᵽaka mija baarijarirãkareka, ate ketarãñurĩmi kiñakoareka i'yoᵽi'ribekaja mija imarãñu. ");
INSERT INTO tnc_vpl VALUES ("J12_29","092_2_29","1JN","2","29","29","“Tuᵽarãte ĩarijiyuika oyiaja baaiki kime Jesús”, mija ãrĩwãrũika simamaka, “Jia oyiaja baarijayurã nime Tuᵽarã makarã”, ãrĩwãrũirã mija ime. ");
INSERT INTO tnc_vpl VALUES ("J13_1","092_3_1","1JN","3","1","1","Mija ã'mitiᵽe. Maᵽaki Tuᵽarã imaki mare wayuĩatiyaiki. I'suᵽaka maka imawa'ri, “Yimakarã mija ime”, mare kẽñu. Rita sime i'suᵽaka mare kẽñua, kimakarã tarãjaoka maime. I'suᵽaka simako'omakaja, rĩkimarãja nime ᵽo'imaja i'suᵽaka maima ĩawãrũbeyurã. Tuᵽarãte õrĩbeyurã imarĩ, kimakarã maima niawãrũbeyu. ");
INSERT INTO tnc_vpl VALUES ("J13_2","092_3_2","1JN","3","2","2","Mija ã'mitiᵽe yijeyomarã. Tuᵽarã makarã maime mae. I'suᵽaka simako'omakaja kimakarã maimamaka, ñamajĩ aᵽeuᵽaka mare kimarũjerũkia ᵽuri, mare kiõrĩrũjebeyua sime. Maekaka sõrĩbeyurã imariᵽotojo “Jesúre etarãñurĩmi ᵽuri, kire ĩawa'ri kima uᵽakaja maimarãñu”, ãrĩwãrũirã maime. ");
INSERT INTO tnc_vpl VALUES ("J13_3","092_3_3","1JN","3","3","3","“Rita, kima yija ĩarãñu”, ãñurã ba'iaja baabekaja nimarijayu, “Cristore ba'iaja baakoribeyu uᵽaka yija imariyaᵽayu”, ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("J13_4","092_3_4","1JN","3","4","4","Ba'iaja baarijayurã ᵽuri Tuᵽarãte jã'meika yi'ribeyurã imarã. Mia, kijã'meika yi'riberirika sime ba'iaja baarika. ");
INSERT INTO tnc_vpl VALUES ("J13_5","092_3_5","1JN","3","5","5","I'suᵽaka simamaka, ba'iaja baakoribeyuka Jesucristore ima õñurã mija ime. I'suᵽaka imaki imawa'ri, “ ‘Ba'iaja nabaaika yiwaᵽakoyimaka, ba'iaja baaᵽe'abekaja nimarũ’, ãrĩwa'ri, ika ka'iarã ketaeka”, ãrĩwãrũirã mija ime. ");
INSERT INTO tnc_vpl VALUES ("J13_6","092_3_6","1JN","3","6","6","Jesúka rĩrãkibiritiirã imarã, ba'iaja baarijaribekaja nime. Ba'iaja baarijayurã ᵽuri Jesucristore jẽrãkoaberiwa'ri kika ĩ'rãtiji ᵽuᵽaribeyurã imarã. ");
INSERT INTO tnc_vpl VALUES ("J13_7","092_3_7","1JN","3","7","7","Yimakarã uᵽakaja wãtaka ñoñurã, “Ba'iaja mabaajĩka marã imabeyua”, mijare bojayurãte mija ã'mitiriᵽẽa'si. Tuᵽarãte yaᵽaika uᵽakaja baarijayurã mija imajĩkareka, Cristo jia oyiaja baaiki uᵽaka mija ime. ");
INSERT INTO tnc_vpl VALUES ("J13_8","092_3_8","1JN","3","8","8","Ba'ioyiaja baarijayuka ᵽuri Satanáre kire jã'meika uᵽakaja baarijayuka imaki. I'suᵽaka ñañu, wejea ᵽo'ijirirã baaeka ruᵽubajirã ba'iaja baarimajiji imara'aekaki Satanáre imatika simamaka. I'suᵽaka imara'aekaki imarĩ ba'iaja ᵽo'imajare kibaarũjerijayua riataokaro'si õ'õrã Tuᵽarã Makire etaeka. ");
INSERT INTO tnc_vpl VALUES ("J13_9","092_3_9","1JN","3","9","9","Ba'iaja baabeyuka Tuᵽarãte imamaka, i'suᵽakajaoka nime kimakarã naro'si. Jia oyiaja imarũkirã Tuᵽarãte nare jarirũjeika simamaka ba'iaja baarũkimarĩrã nime. ");
INSERT INTO tnc_vpl VALUES ("J13_10","092_3_10","1JN","3","10","10","Ikuᵽaka nime Tuᵽarãrirã, suᵽabatirã Satanárirã. Mia je'e: “Jesucristore yi'yurã yija ime”, ãrĩriᵽotojo, Tuᵽarãte ĩajiyubeyua baairã kirirãmarĩrã nime. Suᵽabatirã Tuᵽarãte yi'yurãte ba'iuᵽakaja õñurãoka kirirãmarĩrãoka imarã. ");
INSERT INTO tnc_vpl VALUES ("J13_11","092_3_11","1JN","3","11","11","Bikijarãja Cristore mija yi'riũ'muekarõ'õjĩteᵽi “Matiyiaja jia mawayuĩabu'arijariye'e”, ãñua õrĩtirã mija ime. ");
INSERT INTO tnc_vpl VALUES ("J13_12","092_3_12","1JN","3","12","12","Caín imaekakite baaeka uᵽaka mabaaberijĩñu. Satanáre yi'riwa'ri jiiᵽuᵽaki kibe'erõ'õkaki imaekakite kijããeka. Ikuᵽaka ãrĩwa'ri kire kijããeka. Ã'mitirikõrĩ je'e: Ba'ika imarĩ, “Jiika kime yirĩ'ĩ”, ãᵽaraka kire ã'mijĩawa'ri i'suᵽaka kire kibaaeka. ");
INSERT INTO tnc_vpl VALUES ("J13_13","092_3_13","1JN","3","13","13","Mija ã'mitiᵽe yijeyomarã. Ika wejeareka ba'iaja baarimaja imarãte mijare ã'mijĩamaka, “Aya, ¿dako baaerã yijare na'mijĩayu?”, ãrĩᵽuᵽajoabekaja mija imabe. ");
INSERT INTO tnc_vpl VALUES ("J13_14","092_3_14","1JN","3","14","14","Cristore yi'ribeyukajirã maimaroyika ᵽoto reyatikarã uᵽakaja maimaeka ruᵽu Tuᵽarãte ñakoareka. Maekaka ᵽuri õñia imajiᵽarũkirã imarĩ, aᵽeuᵽaka maᵽuᵽaka mare o'aekarã maime. I'suᵽaka maima õñurã maime aᵽerã kire yi'yurãte mawayuĩarijayua simamaka. Nare wayuĩabeyurã ᵽuri reyatika uᵽakaja imarã. ");
INSERT INTO tnc_vpl VALUES ("J13_15","092_3_15","1JN","3","15","15","I'suᵽaka simamaka Cristore yi'yukate ã'mijĩaiki ᵽuri kire jããrimaji uᵽakaja kime, Tuᵽarãte ĩamaka. Suᵽabatirã “Ᵽo'imajare jããrimaji õñia imajiᵽarũkimarĩkaja kime”, ãrĩwãrũirã mija ime. ");
INSERT INTO tnc_vpl VALUES ("J13_16","092_3_16","1JN","3","16","16","Ikuᵽaka sime: Jesucristore maro'si reyaekakaka õñurã imarĩ, “Mare wayuĩaiki kime”, ãrĩwãrũirã maime. Sõñurã imarĩ, i'suᵽakajaoka aᵽerã kire yi'yurãte wayuĩawa'ri mareyarãka rõ'õjĩrã jẽrãika nare jeyobaabaraka maimarijariye'e. ");
INSERT INTO tnc_vpl VALUES ("J13_17","092_3_17","1JN","3","17","17","Aᵽeroka, kikoyiaja ba'irĩjia rikaiki, “Tuᵽarãka rĩrãkibiritiiki ñime”, ãrĩriᵽotojo Jesúre yi'yurã wayuoka baairãte jeyobaabeyuka kima simamaka i'suᵽaka kẽrĩkoᵽeika ᵽakirika oyiaja kiro'si jayua. ");
INSERT INTO tnc_vpl VALUES ("J13_18","092_3_18","1JN","3","18","18","Wãtaka ñoñurã, rita jia aᵽerãte wayuĩariᵽuᵽakirã imawa'ri nare majeyobaarijariye'e. Moka mirãkaᵽi takaja nare mawayuĩakoᵽejĩka ᵽuri jiamarĩa sime. ");
INSERT INTO tnc_vpl VALUES ("J13_19","092_3_19","1JN","3","19","19","I'suᵽaka nare wayuĩariᵽuᵽakirã imarĩ, nare jeyobaarijayurã nime. Suᵽa imarĩ “Tuᵽarãte rita wãjia bojaika yi'ririjayurã maime”, marĩwãrũrijayu. I'suᵽaka simamaka Tuᵽarãte ĩaika wãjitãji kĩkirimarĩaja maimarijayu. ");
INSERT INTO tnc_vpl VALUES ("J13_20","092_3_20","1JN","3","20","20","“Tuᵽarãrika bojariroka jia yi'ribeyurã yija ime je'e”, maᵽuᵽaka ãñuaja ba'iaja maᵽuᵽarirãkareka, “Jia Tuᵽarãka maimabesarãñu je'e”, marĩᵽuᵽajoarijayu. Ba'iaja maᵽuᵽayua simako'omakaja, saᵽemawa'ribaji mare wayuĩaiki Tuᵽarãte ime. Suᵽabatirãoka maimarijayuakaka ritaja õñuka kime. I'suᵽaka imaki imarĩ, ba'iaja maᵽuᵽayuareka mare jeyobaawãrũiki kime. ");
INSERT INTO tnc_vpl VALUES ("J13_21","092_3_21","1JN","3","21","21","Yijeyomarã, mija ã'mitiᵽe. Moñu uᵽakaja ba'iaja maᵽuᵽaribesarãkareka, kĩkibekaja maimarijarirãñu Tuᵽarãte ĩaika wãjitãji. ");
INSERT INTO tnc_vpl VALUES ("J13_22","092_3_22","1JN","3","22","22","Suᵽabatirãoka Tuᵽarãte ãñua yi'riwa'ri kiyaᵽaika uᵽakaja baairã maimamaka, kire majẽñeika ᵽoto mayaᵽaika uᵽakaja mare kiyi'rirãñu. ");
INSERT INTO tnc_vpl VALUES ("J13_23","092_3_23","1JN","3","23","23","Mija ã'mitiᵽe, ikuᵽaka Tuᵽarãte mare jã'meka: “Yimaki Jesucristore yi'ᵽaraka mija imarijaᵽe. Suᵽabatirã mijare kijã'meka uᵽakaja wayuĩabu'abaraka mija imabe.” ");
INSERT INTO tnc_vpl VALUES ("J13_24","092_3_24","1JN","3","24","24","I'suᵽaka kẽrĩka jiyiᵽuᵽaka õrĩrijayurã ᵽuri Tuᵽarãte yaᵽaika uᵽakaja kika ĩ'rãtiji ᵽuᵽajoairã imarĩ rĩrãkibiritiirã imarã. Esᵽíritu Santore mare kiña'ajããeka simamaka, i'suᵽaka maima moñu. ");
INSERT INTO tnc_vpl VALUES ("J14_1","092_4_1","1JN","4","1","1","Mija ã'mitiᵽe yijeyomarã. “Tuᵽarã oka bojaĩjirimaja yija ime Esᵽíritu Santore yijare jeyobaamaka”, ãñurãte mija ᵽõ'irã etarãñu. I'suᵽaka naᵽakã'ã “¿Yaje rita oka Esᵽíritu Santore nare jeyobaaikaᵽi nawãrõtiyayu je'e?”, ãrĩwa'ri jia nare mija ã'mitiᵽe. “Ᵽakirimaja nimarãkareka nare mayi'riberiye'e”, ãrĩwa'ri i'suᵽaka mijare ñañu. Ika wejea sareka maima ritatojoreka rĩkimarãja ᵽakiriwãrõrimajare ime. ");
INSERT INTO tnc_vpl VALUES ("J14_2","092_4_2","1JN","4","2","2","“Maᵽo'ia uᵽaka kiᵽo'ijirirã ika wejeareka Tuᵽarãte ᵽũataekaki kime Jesucristo”, ãñua wãrõrãñurãte ᵽuri “Rita oka, Esᵽíritu Santore jeyobaaikaᵽitaka jairã nime”, nareka mija ãrĩwãrũrãñu. ");
INSERT INTO tnc_vpl VALUES ("J14_3","092_4_3","1JN","4","3","3","Aᵽerimarã ᵽuri i'sirokaᵽi wãrõbeyurã imarĩ, Esᵽíritu Santore jeyobaaikaᵽimarĩa wãrõirã nime. I'suᵽaka nabaayu, Cristore Jo'ata'aikirikakaka wãrõrimaja imarĩ. I'suᵽaka simamaka “I'suᵽaka ima wãrõrimajare imarãñu”, ãñua õrĩtikarã mija ime. Maekakaoka “Ika wejea ritatorekaja nimatiyu i'suᵽaka ima wãrõrimaja”, ãrĩwa'ri mijare yibojayu. ");
INSERT INTO tnc_vpl VALUES ("J14_4","092_4_4","1JN","4","4","4","Mija ã'mitiᵽe wãtaka ñoñurã. Tuᵽarãrirã mija ime. Suᵽabatirã ᵽakimajaroka nawãrõika mija ã'mitiriᵽe'yoyu. Satanáre ᵽakirika wãrõrimajare jeyobaako'omakaja ĩ'rãᵽẽ'rõtorãja nare mija baayu Satanáre tẽrĩwa'ribaji õñuka kimamaka Tuᵽarã. ");
INSERT INTO tnc_vpl VALUES ("J14_5","092_4_5","1JN","4","5","5","Tuᵽarãte yaᵽabeyumiji wãrõrimaja ᵽuri ᵽo'imajare waᵽuju ᵽuᵽajoairokaᵽiji wãrõirã. I'suᵽaka nawãrõmaka, ika ritatojo wejeareka imarãte nare ã'mitiriᵽẽayu Tuᵽarãte õrĩberiwa'ri. ");
INSERT INTO tnc_vpl VALUES ("J14_6","092_4_6","1JN","4","6","6","Maa ᵽuri, Tuᵽarãrirã maime. I'suᵽaka simamaka mawãrõrijayua ã'mitiriᵽẽairã nime Tuᵽarãte yi'yurã ᵽuri. Tuᵽarãte yi'ribeyurã ᵽuri, mawãrõrijayua ã'mitiriᵽe'yoirã. Suᵽa imarĩ nawãrõika ã'mitiritirã, “Ika rita bojariroka sime. I'sia ᵽuri waᵽuju ᵽakirimajaroka sime”, ãrĩwãrũirã maime. ");
INSERT INTO tnc_vpl VALUES ("J14_7","092_4_7","1JN","4","7","7","Mija ã'mitiᵽe yijeyomarã, mawayuĩabu'arijariye'e, aᵽerãte mare wayuĩarũjerijayuki Tuᵽarãte ima simamaka. Suᵽa imarĩ wayuĩabu'arijayurã nime Tuᵽarã makarã, suᵽabatirã jia kire õñurã nime. ");
INSERT INTO tnc_vpl VALUES ("J14_8","092_4_8","1JN","4","8","8","Ᵽo'imajare wayuĩarimaji Tuᵽarãte imamaka, wayuĩabu'abeyurã ᵽuri kire õrĩbeyurã nime. ");
INSERT INTO tnc_vpl VALUES ("J14_9","092_4_9","1JN","4","9","9","Ikuᵽaka Tuᵽarãte maro'si baaeka mare wayuĩawa'ri: Kimaki ĩ'rĩkaja imakiteje maro'si kiᵽũataeka õñia maimajiᵽarũ ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("J14_10","092_4_10","1JN","4","10","10","Ikuᵽaka sime aᵽerãte wayuĩarika: Tuᵽarãte mayaᵽaika uᵽakamarĩa sime. Ikuᵽaka sime, ĩakõrĩ je'e: Tẽrĩrikaja mare wayuĩawa'ri Kimakire maro'si Tuᵽarãte ᵽũataeka kireyaekaᵽi ãrĩwa'ri ba'iaja mabaaika ye'kariaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("J14_11","092_4_11","1JN","4","11","11","Mija ã'mitiᵽe yijeyomarã, i'suᵽaka Tuᵽarãte jimarĩa mare wayuĩatiyaeka simamaka, mawayuĩabu'ajĩñu maaoka. ");
INSERT INTO tnc_vpl VALUES ("J14_12","092_4_12","1JN","4","12","12","Maki imabeyuka Tuᵽarãte ĩaiki. I'suᵽaka simako'omakaja mawayuĩabu'ajĩkareka kika ĩ'rãtiji ᵽuᵽakirã maime. Suᵽabatirã kiuᵽakaja mare kijarirũjeyu. Suᵽa imarĩ kire yaᵽatiyarĩji yaᵽairã majayu. ");
INSERT INTO tnc_vpl VALUES ("J14_13","092_4_13","1JN","4","13","13","Tuᵽarãte Esᵽíritu Santore mare ña'ajããeka simamaka, “Kika ĩ'rãtiji ᵽuᵽakirã maime, suᵽabatirã kiuᵽakaja mare kijarirũjeyu”, ãrĩwãrũirã maime. ");
INSERT INTO tnc_vpl VALUES ("J14_14","092_4_14","1JN","4","14","14","Suᵽabatirã yija ĩaeka mirãka mijare yija bojaerã baayu. Ritatojo wejeareka imarãte tããrimaji imarũkikaro'si Kimakire maro'si ᵽũataekaki Maᵽaki. ");
INSERT INTO tnc_vpl VALUES ("J14_15","092_4_15","1JN","4","15","15","“Tuᵽarã Maki kime Jesús”, ãñurã ᵽuri, Tuᵽarãka ĩ'rãtiji ᵽuᵽakirã nime. I'suᵽakajaoka naka kime kiro'si. ");
INSERT INTO tnc_vpl VALUES ("J14_16","092_4_16","1JN","4","16","16","Tuᵽarãte mare wãtaika koritiirã imarĩ, mare kiwayuĩaikakaka yi'ririjayurã maime. Mija ĩabe: Ᵽo'imajare wayuĩarijayuka kime Tuᵽarã. Suᵽa imarĩ, kiuᵽakaja aᵽerãte wayuĩarijayurã ᵽuri, Tuᵽarãka ĩ'rãtiji ᵽuᵽakirã nime, suᵽabatirã kiuᵽakaja nare kijarirũjeyu. ");
INSERT INTO tnc_vpl VALUES ("J14_17","092_4_17","1JN","4","17","17","I'suᵽaka imarã imarĩ, Tuᵽarãte yaᵽaika uᵽakaja ᵽo'imajare wayuĩairã majayu. Suᵽa simamaka ᵽo'imajare kiwã'marãñurĩmi seyarãka ᵽoto “Ba'iaja mare kibaarãñu je'e”, ãrĩwa'ri kĩkibekaja maimarãñu, Jesucristore imarijarika uᵽakaja õ'õrã maimarijayua simamaka. ");
INSERT INTO tnc_vpl VALUES ("J14_18","092_4_18","1JN","4","18","18","Tuᵽarãte yaᵽatiyarĩji yaᵽairã imarĩ kire makĩkibesarãñu. I'suᵽaka imawa'ri kire makĩkirũkia imakoᵽeika ĩ'rãᵽẽ'rõtorãja mataayu. “Ba'iaja yibaaika waᵽa ba'iaja Tuᵽarãte yire baarãñu je'e”, ãrĩᵽuᵽajoairã ᵽuri saruᵽu kĩkibaraka ba'iaja ᵽuᵽayurã. “I'suᵽaka nimamaka jia kire yaᵽatiyarĩji yaᵽabeyukajirã nime ruᵽu”, nareka marĩwãrũyu. ");
INSERT INTO tnc_vpl VALUES ("J14_19","092_4_19","1JN","4","19","19","Mamarĩji Tuᵽarãte mare wayuĩaũ'mutika simamaka, kire, suᵽabatirã ᵽo'imajareoka yaᵽatiyarĩji yaᵽarijayurã maime maaoka. ");
INSERT INTO tnc_vpl VALUES ("J14_20","092_4_20","1JN","4","20","20","“Tuᵽarãka rĩrãkibiritiiki ñime”, ãrĩriᵽotojo, aᵽika kire yi'yukate ĩariᵽe'yoiki ᵽuri ᵽakirimaji kime. Wããrõ'õrã imarãte wayuĩabeyuka ᵽuri, wããrõ'õrãja imabeyuka Tuᵽarãteoka yaᵽawãrũbeyuka kime. ");
INSERT INTO tnc_vpl VALUES ("J14_21","092_4_21","1JN","4","21","21","Ikuᵽaka Tuᵽarãte mare jã'meka: “Yire mija yaᵽarãkareka Jesúre yi'yurãteoka mija wayuĩabe.” ");
INSERT INTO tnc_vpl VALUES ("J15_1","092_5_1","1JN","5","1","1","“Mare kitããerã Tuᵽarãte wã'maekaki kime Jesús”, ãrĩwa'ri sayi'yurã ᵽuri Tuᵽarã makarã nime. Suᵽabatirã Maᵽaki Tuᵽarãte yaᵽatiyarĩji yaᵽairã imarĩ, kire yi'yurãteoka nawayuĩayu. ");
INSERT INTO tnc_vpl VALUES ("J15_2","092_5_2","1JN","5","2","2","I'suᵽaka simamaka Tuᵽarãte yaᵽawa'ri i'suᵽakajaoka kijã'meika ãñu uᵽakaja yi'riwa'ri “Kire yi'yurãte wayuĩarũkirã maime”, marĩwãrũrijayu. ");
INSERT INTO tnc_vpl VALUES ("J15_3","092_5_3","1JN","5","3","3","Tuᵽarãte jã'meika yi'yurã imarĩ, “Tuᵽarãte yaᵽatiyarĩji yaᵽarijayurã maime”, marĩwãrũyu. Suᵽabatirãoka “Kijã'meika ka'wisitakamarĩaja sime”, marĩwãrũyu. ");
INSERT INTO tnc_vpl VALUES ("J15_4","092_5_4","1JN","5","4","4","I'suᵽaka mañu Tuᵽarã makarã imawa'ri, wejearitatorãja ima ba'iaja baarimijikaka ĩ'rãᵽẽ'rõtorãja mataarijayu. I'suᵽaka ba'iaja baarimijikaka nabaaika uᵽakaja mabaabeyu Jesucristore yi'riwa'ri. ");
INSERT INTO tnc_vpl VALUES ("J15_5","092_5_5","1JN","5","5","5","Suᵽabatirã “Tuᵽarã Maki kime Jesús”, ãrĩrijayurã imarã, wejeareka ima ba'iaja baabeyurã. ");
INSERT INTO tnc_vpl VALUES ("J15_6","092_5_6","1JN","5","6","8","Õ'õrã kimaeka ᵽoto maekarakaba'ikaka kireka õrĩwa'ri “Tuᵽarãte ᵽũataekaki kime Jesucristo”, mañu. Mamarĩ, okoaᵽi Jesucristore kiruᵽuko'a jũjerũjeka. Suᵽabatirãoka sabe'erõ'õᵽi yaᵽua tetaekareka riwejurubaraka kireyaeka. I'suᵽakajaoka rita ãñuka imarĩ, “Tuᵽarã Maki kime Jesucristo”, Esᵽíritu Santore mare ãrĩrijayu. Ika maekarakaba'i õñurã imawa'ri, “Tuᵽarã Maki kime Jesucristo”, marĩwãrũyu. Jesúre kiruᵽuko'a jũjerũjeka, suᵽabatirã yaᵽua tetaekareka kiriwejurueka, Esᵽíritu Santore mare bojarijayua maekarakawãme imariᵽotojo ĩ'rãtiji oyiaja sabojayu. ");
INSERT INTO tnc_vpl VALUES ("J15_9","092_5_9","1JN","5","9","9","Ᵽo'imajare mare ãñua yi'rirũkia oyiaja sime. I'suᵽaka simako'omakaja “Yimaki kime ĩ'ĩ”, Tuᵽarãte ãrĩkaroka takaja ima saᵽemawa'ribajirã mayi'rirũkia. ");
INSERT INTO tnc_vpl VALUES ("J15_10","092_5_10","1JN","5","10","10","Tuᵽarã Makire yi'yurã ᵽuri, “Kimakireka Tuᵽarãte bojaeka rita sime”, ãrĩwa'ri naᵽuᵽakarã sõñurã nime. “Tuᵽarã Makimarĩka Jesúre ime”, ãñurã ᵽuri Tuᵽarãte kireka bojaeka yi'ribeyurã nime. I'suᵽaka ãñurã imarĩ, “Waᵽuju ᵽakirika sime ‘Yimaki Jesúre ime’, Tuᵽarãte ãñua”, narĩrijayu. ");
INSERT INTO tnc_vpl VALUES ("J15_11","092_5_11","1JN","5","11","11","Mija ã'mitiᵽe, ikuᵽaka sime Tuᵽarãte kireka bojaekakaka: Kimakiᵽi ãrĩwa'ri õñia mare kimajiᵽarũjeka. ");
INSERT INTO tnc_vpl VALUES ("J15_12","092_5_12","1JN","5","12","12","Tuᵽarã Makika ĩ'rãtiji ᵽuᵽakirã, õñia kika imajiᵽatiirã imarã. Kika ĩ'rãtiji ᵽuᵽamarĩrã ᵽuri kika õñia imajiᵽabeyurã. ");
INSERT INTO tnc_vpl VALUES ("J15_13","092_5_13","1JN","5","13","13","Tuᵽarã Makire yi'yurã imarĩ, kika õñia imajiᵽarã mija ime. I'sia jia mija õñaokaro'si ika ᵽaᵽera o'otirã mijaro'si yiᵽũatayu. ");
INSERT INTO tnc_vpl VALUES ("J15_14","092_5_14","1JN","5","14","14","I'suᵽaka simamaka jia kika ĩ'rãtiji ᵽuᵽakirã imarĩ “Tuᵽarãte yaᵽairokaᵽi kire majẽñerãkareka, mare kiã'mitiriᵽẽarãñu”, ãñurã maime. ");
INSERT INTO tnc_vpl VALUES ("J15_15","092_5_15","1JN","5","15","15","“Mare ã'mitiriᵽẽaiki kime Tuᵽarã”, ãñurã imarĩ, “Kire majẽñeika uᵽakaja mare ja'ataiki kime”, ãrĩᵽuᵽajoairãoka maime. ");
INSERT INTO tnc_vpl VALUES ("J15_16","092_5_16","1JN","5","16","16","Ikuᵽaka sime aᵽea: Ĩ'rĩka Jesúre yi'yuka, mija watoᵽekakaki imariᵽotojo ba'iaja kibaaika mija ĩarãkareka, Tuᵽarãte kiro'si mija jẽñeĩjibe. Ba'iaja jũarũkiwaᵽa imakoᵽeikareka Tuᵽarãte ye'kariariba'ikaka simaye'e i'suᵽaka kiro'si mija baarãka. I'suᵽaka kiro'si mija baamaka ba'iaja kibaaikareka Tuᵽarãte kire wayuĩarãñu ate jia kika kimaokaro'si. Aᵽeba'i ba'iaja baarika ima, sawaᵽa ba'iaja imarika tiyibeyurõ'õrã a'rirũkia. I'suᵽaka ĩ'rĩkate baarãkareka, “Kiro'si Tuᵽarãte mija jẽñebe”, mijare ãrĩbeyuka yi'i. ");
INSERT INTO tnc_vpl VALUES ("J15_17","092_5_17","1JN","5","17","17","Ritaja ba'iaja mabaaika jiamarĩa oyiaja ima Tuᵽarãte ĩaika wãjitãji. I'suᵽaka simako'omakaja, ba'iaja mabaaika simauᵽatimarĩa sime Maiᵽamakire imarõ'õ mare tá'terũkia. ");
INSERT INTO tnc_vpl VALUES ("J15_18","092_5_18","1JN","5","18","18","Ikuᵽaka moñu: Tuᵽarãmakarã imarĩ ba'iaja baarijaribeyurã maime, Tuᵽarã Makire mare ĩarĩñua simamaka. Suᵽa imarĩ Satanáre ba'iaja mare baarũjewãrũbeyu. ");
INSERT INTO tnc_vpl VALUES ("J15_19","092_5_19","1JN","5","19","19","“Tuᵽarã makarã maime”, ãrĩwãrũirã maime. Kire yi'ribeyurã ika wejearitatojoreka imarãte ᵽuri ba'iaja Satanáre baarũjerijayu. ");
INSERT INTO tnc_vpl VALUES ("J15_20","092_5_20","1JN","5","20","20","Mia je'e, ikuᵽakaoka moñua sime: Ika maima ka'iarã Tuᵽarã Makire ᵽo'ijirika. Suᵽabatirã Tuᵽarã imatiyaikite moñaokaro'si mare kiõrĩwãrũrũjeka. Suᵽabatirã Kimaki Jesucristoka ĩ'rãtiji uᵽakaja ᵽuᵽakirã imarijayurã imarĩ, Tuᵽarãrirãoka maime. Ikiji Tuᵽarã kime, suᵽabatirã ikijioka kime mare õñia imajiᵽarũjeiki. ");
INSERT INTO tnc_vpl VALUES ("J15_21","092_5_21","1JN","5","21","21","Yijeyomarã, i'suᵽaka kima õñurã imarĩ, waᵽuju ᵽo'imajare baaᵽo'ijiaeka mija yi'ririjaria'si. I'tojĩrãja sime ruᵽu.");
INSERT INTO tnc_vpl VALUES ("RV1_1","096_1_1","REV","1","1","1","Ika ᵽaᵽerareka o'oeka bojaika ikuᵽarõ'õᵽiji imarũkiakaka. I'suᵽaka imarũkia kiyaᵽaika uᵽaka baarijayurãte sõñaokaro'si Kimaki Jesucristore sakija'ataeka Tuᵽarã, nare sakibojaokaro'si. Suᵽa imarĩ ángelte yiᵽõ'irã kiᵽũataeka yire sakiõrĩwãrũrũjeokaro'si. Juan, kiyaᵽaika uᵽaka baarijayuka ñime. ");
INSERT INTO tnc_vpl VALUES ("RV1_2","096_1_2","REV","1","2","2","Yi'i Juan, yire ᵽemakotowiritirã ángelte ritaja yire bearaᵽakarõ'õjĩrãja yibojayu, saᵽemawa'ribaji ᵽañakarãja ᵽeawa'ri ᵽakibekaja. I'suᵽaka yiro'si simaraᵽe Tuᵽarãrika bojariroka Jesucristore yire õrĩrũjemaka. ");
INSERT INTO tnc_vpl VALUES ("RV1_3","096_1_3","REV","1","3","3","I'suᵽaka ima ikuᵽarõ'õᵽiji etararirãka simamaka ikuᵽaka mijare ñañu mae. Suᵽa imarĩ ika ñañua bojarimaja, suᵽabatirã sayi'rirãñurãoka jia jĩjimaka imarijarirãñurã. ");
INSERT INTO tnc_vpl VALUES ("RV1_4","096_1_4","REV","1","4","5","Mae, Asia ka'iarã ĩ'ᵽotẽñarirakawejeareka Jesúre yi'ririjaᵽaraka imarãro'si ika yo'oyu yi'i Juan. Suᵽa imarĩ Tuᵽarã, Jesucristo, Esᵽíritu Santoᵽitiyika maekarakamarã jia mijare najeyobaarũ, jia naka mijare imarũjewa'ri. Bikija imara'aekaki imariᵽotojo maekakaoka imarijayuka Tuᵽarãte ime. I'suᵽakajaoka ñamajĩ imajiᵽarãki kime. I'suᵽakajaoka Tuᵽarãte jã'meruᵽa wãjitãji imarijayurã ĩ'ᵽotẽñarirakamarã imarã. Esᵽíritu Santo ritaja õrĩᵽataiki kime ãrĩrikoᵽakaja i'suᵽaka kiwãjitãji nimarijayu. Suᵽabatirã Jesucristo imaki Kiᵽakire ãñua uᵽakatakaja bojarimaji. I'suᵽaka imaki imarĩ, reyariᵽotojo õñia kijariᵽe'rika ate. I'suᵽaka kibaaũ'muekaᵽi ãrĩwa'ri rĩkimarãja reyariᵽotojo sabe'erõ'õ õñia jariᵽearãñurã ate. Suᵽa imarĩ ritatojo wejeareka ĩᵽamarãre jã'meiki kime. I'suᵽakajaoka mare wãtawa'ri maro'si riwejurubaraka kireyaekaᵽi ba'iaja mabaaika kiwaᵽakoyika. ");
INSERT INTO tnc_vpl VALUES ("RV1_6","096_1_6","REV","1","6","6","I'suᵽaka mare kibaaeka simamaka, kijã'merũkirãro'siji maimarãñu. Suᵽabatirã kurarãka uᵽakajaoka Kiᵽaki Tuᵽarãte yaᵽaika uᵽakaja baarimaja maime. Suᵽa imarĩ, “Ritaja ĩᵽamaki imarĩ dika jariwa'ririmarĩaja jã'mewãrũᵽataiki kime. I'suᵽaka kimamaka aᵽea ima ᵽemawa'ribaji jiitakaja jiyiᵽuᵽaka morĩrũkika kime”, ãᵽaraka jĩjimaka kika maimarijarirãñu. I'suᵽaka oyiaja imarijarirũkikaro'si simarũ. ");
INSERT INTO tnc_vpl VALUES ("RV1_7","096_1_7","REV","1","7","7","Ikuᵽaka imarũkiaoka jia mija õrĩrijaᵽe, ĩakõrĩ je'e: Oko ũmaka watoᵽekaᵽi Cristore i'tarãñu. Ritatojo wejeareka imarã, suᵽabatirã kire jããekarã ᵽarijioka ĩaᵽatarãñurã i'suᵽaka imarãka. “Ba'iaja yijare kijũarũjerãñu”, ãrĩwa'ri orirãñurã. I'suᵽaka simarũ. ");
INSERT INTO tnc_vpl VALUES ("RV1_8","096_1_8","REV","1","8","8","Ikuᵽaka kibojayu: “Alfa, Omega uᵽaka imaki ñime. Alfa ñime ñañu ritaja ᵽo'ijiaekaki imarĩ. Suᵽabatirã Omega ñañua ‘Ñamajĩ wejea tiyirũjerũkika ñime’, ãrĩrika sime. Ritaja ima tẽrĩwa'ribaji imaki ñime. Bikija imara'aekaki imariᵽotojo maekakaoka imarijayuka ñime. Suᵽabatirã yi'ijioka imaki imajiᵽarijarirũkika”, ãrĩwa'ri Tuᵽarãte bojayu. ");
INSERT INTO tnc_vpl VALUES ("RV1_9","096_1_9","REV","1","9","9","Yi'i Juan, Jesucristore yi'yuka ñime mija jeyomaki imarĩ. Mija uᵽakaja Tuᵽarãte yire jã'mẽrũkikaoka ñime yiro'si. I'suᵽaka imaki imarĩ, mija uᵽakajaoka ᵽo'imajare yire ba'iaja jũarũjerijayu, Maiᵽamakirirã uᵽatiji i'suᵽaka oyiaja jũarũkirã maima simamaka. I'suᵽaka jũariᵽotojo Jesucristore ã'mitiriᵽẽaiki imarĩ, sayirakajeᵽããyu. Suᵽa imarĩ Ᵽatmos wãmeirõ'õ jũmurikarã yire nataaraᵽe Tuᵽarãrika bojariroka yibojaraᵽaka ᵽareaja wẽkomakareka ñimaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("RV1_10","096_1_10","REV","1","10","10","Domingorĩmi Tuᵽarãte jiyiᵽuᵽayeebaraka ñimaraᵽaka ᵽoto, Esᵽíritu Santorikaᵽi yire ña'ajããekaki. Ikuᵽarõ'õᵽiji makãrãrũñuroka uᵽakaᵽi yire kĩarũjeraᵽe. I'suᵽaka ñimaraᵽaka ᵽoto yiᵽẽterõ'õᵽi tromᵽeta naᵽuᵽuika jãjia okaayurõ'õjĩrã jãjirokaᵽi ĩ'rĩkate jaimaka ña'mitiraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV1_11","096_1_11","REV","1","11","11","Toᵽi mae ikuᵽaka yire kẽrĩkoraᵽe: —Maekaka mire yibeaika ᵽaᵽerarã samio'obe. Suᵽabatirã Asiaka'iarã Jesúre yi'yurã ĩ'ᵽotẽñarirakawejeareka imarãro'si samiᵽũatabe. Ikuᵽaka wãmeika sime wejea samiᵽũatarũkirõ'õ: Éfeso, Esmirna, Ᵽérgamo, Tiatira, Sardes, Filadelfia, suᵽabatirã Laodiceakarã nime,— kẽrĩkoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV1_12","096_1_12","REV","1","12","12","Torãjĩrã mae “¿Maki torã yire jaiki?”, ãᵽaraka jorowa'ri yiyoiraᵽe kire ĩarika yaᵽawa'ri. Yoirã baakõrĩ ĩ'ᵽotẽñarirakabi ᵽeritẽrĩa yaaboaika orokaka baaeka imamaka ñiaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV1_13","096_1_13","REV","1","13","13","Suᵽabatirã sawatoᵽekarã ĩ'rĩka ᵽo'imaji uᵽaka ĩoikite imaraᵽe. Kijariroaka saya uᵽaka ima kiũᵽusikarõ'õjĩrã ñoaka jããiki kimaraᵽe. I'suᵽakajaoka orokaka baaeka kikãrĩmaki wãjitãji jããᵽiaekaki kimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV1_14","096_1_14","REV","1","14","14","Suᵽabatirã kiruᵽuko'a kiruᵽua boitaka sõiraᵽe. Kiñakoa ᵽuri ᵽeka jũ'rẽika uᵽaka õiraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV1_15","096_1_15","REV","1","15","15","I'suᵽakajaoka kiũ'ᵽua bronce najoeika ᵽoto ya'taika uᵽaka sõiraᵽe. Kijaika ãta jãjia we'rirĩkaika uᵽaka okaaraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV1_16","096_1_16","REV","1","16","16","Suᵽabatirã kiᵽitaka ritaᵽẽ'rõtoᵽi ĩ'ᵽotẽñarirakamaki tã'ᵽia kirikaraᵽe. Kirijokoᵽeaᵽi ĩ'ᵽaᵽẽ'rõtowã'taja oᵽijieka sara wararaᵽaka. Kiᵽema jiitakaja aiyate yaaika uᵽaka õiraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV1_17","096_1_17","REV","1","17","17","Torãjĩrã mae kire ĩakoᵽekaja kiwãjitãji ña'rĩtirã, jaiberijĩka, rĩ'meberijĩka yijaraᵽe. I'suᵽaka yibaamaka kiᵽitaka ritaᵽẽ'rõtoᵽi yire rabetirã, ikuᵽaka yire kẽrãᵽe: —Mikĩkia'si. Ritaja ᵽo'ijiaekaki imarĩ, suᵽabatirã ñamajĩ wejea tiyirũjerũkika ñime. ");
INSERT INTO tnc_vpl VALUES ("RV1_18","096_1_18","REV","1","18","18","Õñia imajiᵽarũkika ñime, reyariᵽotojo õñia yijariᵽe'rika be'erõ'õ aᵽekurioka reyarũkimarĩka ñima simamaka. I'suᵽaka imaki imarĩ, nareyaikareka ᵽo'imajare e'etorirũkika ñime õñia nimajiᵽaokaro'si. Suᵽabatirãoka toᵽi nare ja'ajiyerũkimarĩka ñime. Suᵽa imarĩ reyaeka mirãrãte imarõ'õ koᵽereka wierimajiji ñime,— yire kẽrãᵽe makãrãrũñuroka uᵽakaᵽi yiᵽõ'irã ᵽemakotowiritirã. ");
INSERT INTO tnc_vpl VALUES ("RV1_19","096_1_19","REV","1","19","19","I'suᵽaka yire ãrĩweatirã ikuᵽaka yire kẽrãᵽe ate: —Maekaka, ñamajĩ imarũkiaro'si samiaika simamaka ika miaika uᵽakaja samio'obe. ");
INSERT INTO tnc_vpl VALUES ("RV1_20","096_1_20","REV","1","20","20","Mia, ritaᵽẽ'rõto ĩ'ᵽotẽñarirakamaki tã'ᵽia yirikaika ĩariᵽotojo, “I'suᵽakaro'si simekã'ã”, ãrĩwãrũbeyuka mime. Ikuᵽaka imarũkiaro'si i'suᵽaka sime: Ĩ'ᵽotẽñarirakamarã tã'ᵽia miaika ima ĩ'ᵽotẽñarirakawejekarã yire ã'mitiriᵽẽarimajare imaruᵽutarimaja ãrĩrikoᵽakaja. I'suᵽakajaoka sime ᵽeritẽrĩa yaaboaika miaika. Ĩ'ᵽotẽñarirakawejerã yire yi'yurãte ime ãrĩrikoᵽakaja sime,— yire kẽrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV2_1","096_2_1","REV","2","1","1","I'tojĩrã, yire ᵽemakotowiraᵽakire ikuᵽaka yire ãrãᵽe ate: —Éfesoreka imaki yire ã'mitiriᵽẽarimajare imaruᵽutarimajiro'si ikuᵽaka mio'obe: “Ĩ'ᵽotẽñarirakamarã tã'ᵽia rikaiki, i'siarakatẽrĩoka ᵽeritẽrĩ watoᵽekarã turitaᵽaki imarĩ ikuᵽaka yibojayu: ");
INSERT INTO tnc_vpl VALUES ("RV2_2","096_2_2","REV","2","2","2","Ã'mitirikõrĩ je'e. Ritaja mija baarijayua õñuka ñime. I'suᵽaka simamaka, ᵽo'imajare yire yi'ririka yaᵽawa'ri mija ka'wisijũayu. I'suᵽakajaoka aᵽerãte ba'iaja mijare baako'omakaja yire mija yi'ririja'atabeyua jia ñoñua sime. I'suᵽakajaoka ‘Cristorika bojariroka bojarimaja yija ime’, ĩ'rãrimarãre ãrĩᵽakiko'omakaja, ‘¿Yaje rita nañu?’, ãñurã mija ime. Suᵽa imarĩ nabaarijayua jia ĩawãrũtirã, i'suᵽakajaoka nawãrõika ã'mitiritirã, ‘Waᵽuju ᵽakibaraka ba'iaja baairã nime’, mija ãñua ñorĩᵽataika sime. ");
INSERT INTO tnc_vpl VALUES ("RV2_3","096_2_3","REV","2","3","3","I'suᵽaka imarijayurã imarĩ, aᵽerãte ba'iaja mijare baako'omakaja yire ã'mitiriᵽẽarija'atabeyurã mija ime. Ka'wisika imarijayuareka wayuᵽi'ᵽekaja sarakajeᵽããrijayurã imarĩ, yire mija yi'yua ja'atabeyurã mija ime. ");
INSERT INTO tnc_vpl VALUES ("RV2_4","096_2_4","REV","2","4","4","I'suᵽaka simako'omakaja mamarĩtaka yire yi'riũ'mubaraka yika mija rĩrãkibiraᵽaka uᵽakamarĩa imarã mija jayu mae. I'suᵽaka simamaka mijaka jia jĩjimaka imabeyukajika ruᵽu yi'i. ");
INSERT INTO tnc_vpl VALUES ("RV2_5","096_2_5","REV","2","5","5","Suᵽa imarĩ, yika rĩrãkibiriwa'ri jia yire mija yi'riũ'muraᵽarõ'õ ᵽuᵽaᵽe'ritirã, ‘Jia mika yija imaraᵽaka uᵽakamarĩa yija jayua ba'itaka sime’, ãñurã mija jaᵽe. Suᵽa ãᵽaraka mamarĩ yika jia imatiyawa'ri jia mija baaraᵽaka uᵽakaja mija baabe ate. I'suᵽaka mija baabesarãka no'ojĩrãmarĩaja mija ᵽeritẽrĩa yaaboabaraka imakoᵽeika mijareka se'marĩ yetarãñu. I'suᵽaka yibaarãkareka yire jiyiᵽuᵽayeerimajare rẽrĩrijaribesarãñu torã mae. ");
INSERT INTO tnc_vpl VALUES ("RV2_6","096_2_6","REV","2","6","6","Mae mijare ñañu, jia yika mija imaraᵽaka uᵽakamarĩa jayurã imariᵽotojo ĩ'rãba'i jia mija baayu ñiamaka. Nicolaítas tatarãte ba'iaja baaika mija ĩariᵽe'yoika jia sime. I'suᵽakajaoka sime yiro'si. ");
INSERT INTO tnc_vpl VALUES ("RV2_7","096_2_7","REV","2","7","7","Mija ã'mitiᵽe ritaja wejeareka yire yi'ᵽaraka imarijayurã. Jia samija õrĩᵽũariyaᵽaye'e, Esᵽíritu Santore yire jeyobaaikaᵽi yibojaika jia mija ã'mitiᵽe. Ba'iaja nabaakoᵽeka naja'atayu Satanáre ĩ'rãᵽẽ'rõtorãja baairã. I'suᵽaka baarãñurãte Tuᵽarã rioñe'metãji õñioyaᵽurika nare yiji'arãñu”, ãrĩwa'ri mio'obe,— yire kẽrãᵽe makãrãrũñuroka uᵽakaᵽi yire ᵽemakotowiraᵽaki. ");
INSERT INTO tnc_vpl VALUES ("RV2_8","096_2_8","REV","2","8","8","Saᵽemajĩrã ikuᵽaka yire kẽrãᵽe ate: —Esmirna wejearã yire ã'mitiriᵽẽarimajare imaruᵽutarimajiro'si ikuᵽaka mio'obe: “Ritaja ᵽo'ijiaekaki imarĩ, suᵽabatirã ñamajĩ wejea tiyirũjerũkika ñime. Yi'ijioka imaki reyariᵽotojo õñia jariᵽe'rikaki. I'suᵽaka jarikaki imarĩ ikuᵽaka mire ñañu: ");
INSERT INTO tnc_vpl VALUES ("RV2_9","096_2_9","REV","2","9","9","Mia je'e. Ba'iaja mijare nabaamaka, jiamarĩa mija jũarijayua õñuka ñime. Suᵽabatirã wayuoka baairã mija imaoka ñorĩᵽataika sime. I'suᵽaka mija ima simako'omakaja Tuᵽarãte mijare saja'ataekaᵽi ãrĩwa'ri, imatiyaika rikairã mija ime. I'suᵽakajaoka ‘Judíorãka imarĩ, Tuᵽarãrirãtakaja yija ime’, ãᵽaraka, ‘Ba'iaja baarimaja nime’, ãᵽaraka mijareka kẽ'rãjairimajareoka õñuka ñime. I'suᵽaka nabaayu Tuᵽarãte yi'riberiwa'ri Satanáre yaᵽaika uᵽaka baarijayurã imarĩ. ");
INSERT INTO tnc_vpl VALUES ("RV2_10","096_2_10","REV","2","10","10","Wẽkomaka imariwi'iarã ba'iaja mija jũarijarirãka kĩkibekaja mija imabe. I'suᵽaka Satanáre nare ᵽuᵽajoarũjemaka ĩ'rãrimarãre torã natarãñu. Yire mija ã'mitiriᵽẽaika mija ja'atarika yaᵽakoᵽewa'ri i'suᵽaka mijare kibaata'arãñu ĩ'ᵽaᵽitarakarĩmirõ'õjĩrã. I'suᵽaka jũariᵽotojo mijare najããrãkarõ'õjĩrãoka, yire mija ã'mitiriᵽẽarija'ata'si. I'suᵽaka samija rakajeᵽããrãkareka, ‘Õñia imajiᵽarũkirã nimarũ’, mijareka ñarĩrãñu. ");
INSERT INTO tnc_vpl VALUES ("RV2_11","096_2_11","REV","2","11","11","Mija ã'mitiᵽe ritaja wejeareka yire yi'ᵽaraka imarijayurã. Jia samija õrĩᵽũariyaᵽaye'e, Esᵽíritu Santore yire jeyobaaikaᵽi yibojaika jia mija ã'mitiᵽe. Ba'iaja jũariᵽotojo yire ã'mitiriᵽẽabaraka imarijayurã ᵽuri, ba'iaja jũarika tiyibeyurõ'õrã yiᵽũatarãñurãka a'rirũkimarĩrã nime”, ãrĩwa'ri mio'obe,— yire ᵽemakotowiraᵽakire mijare bojayu. ");
INSERT INTO tnc_vpl VALUES ("RV2_12","096_2_12","REV","2","12","12","Torãjĩrã ate yire ᵽemakotowiraᵽakire ikuᵽaka yire ãrãᵽe: —Ᵽérgamo wejearã yire ã'mitiriᵽẽarimajare imaruᵽutarimajiro'si ikuᵽaka mio'obe: “Mia je'e ikuᵽaka ñañu ĩ'ᵽaᵽẽ'rõto oᵽika sara rikaiki imarĩ. ");
INSERT INTO tnc_vpl VALUES ("RV2_13","096_2_13","REV","2","13","13","Ritaja mija imarijayua ñiaika simamaka, Satanáre jã'meirõ'õrã mija imaoka ñorĩᵽatayu. Torã imariᵽotojo yire yi'riwa'ri Satanáre ã'mitiriᵽẽabeyurã mija ime. Mia je'e, torã jia yire yi'riwa'ri Antiᵽas wãmeikite yirika bojariroka bojaja'atabeyuka kimamaka, kire najããeka. I'suᵽaka tokarãre kire baako'omakaja yire mija yi'yua ja'atabeyurã mija imaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV2_14","096_2_14","REV","2","14","15","I'suᵽaka simako'omakaja Balaam imaroyirekaki, Balac imaroyikate kiwãrõekamijikaka yi'yurãte ã'mitiriᵽẽarijayurã nime ĩ'rãrimarã mija ᵽõ'irã. Suᵽa imarĩ jĩjimaka mijaka imabeyukajika yi'i. Mia je'e, ikuᵽaka sime Balaamre wãrõekamijikaka: ‘Israelkarãre ikuᵽaka mibojabe ba'iaja nabaaokaro'si: “Jẽrãka jiyeka jiyiᵽuᵽaka õrĩwa'ri, wa'iro'si ri'ia yija ᵽããrijayua mija ba'arãka marã imabeyua. I'suᵽakajaoka yija tã'omaja rõmitikaka mija yaᵽaika uᵽakaja mija wã'imarĩkoᵽebe”’, ãrĩwa'ri Balaamre kire wãrõeka. Bikija Israelkarãre Balaamre wãrõeka yi'riwa'ri ba'iaja nabaaeka. I'suᵽakajaoka ĩ'rãrimarãre mija watoᵽekarã ba'iaja baarijayu Nicolaítas tatarãte wãrõika yi'riwa'ri. ");
INSERT INTO tnc_vpl VALUES ("RV2_16","096_2_16","REV","2","16","16","I'suᵽaka simamaka ‘Ᵽakirimajaroka ã'mitiriᵽẽawa'ri ba'iaja mija baa'si’, nare ãrĩbeyurã mija imarãkareka no'ojĩrãmarĩaja mija ᵽõ'irã yeyarãka ᵽoto yirijokoᵽearã sara imaᵽi ba'iaja nare yibaarãñu sana'mitiriᵽẽarija'atabeᵽakã'ã. ");
INSERT INTO tnc_vpl VALUES ("RV2_17","096_2_17","REV","2","17","17","Mija ã'mitiᵽe ritaja wejeareka yire yi'ᵽaraka imarijayurã. Jia samija õrĩᵽũariyaᵽaye'e, Esᵽíritu Santore yire jeyobaaikaᵽi yibojaika jia mija ã'mitiᵽe. Ba'iaja nabaaika ja'ataeka imarãte ᵽuri ba'arika maikoribeyua maná wãmeika yiji'arãñu. Suᵽabatirã ãta boia mamaka wãmea sarã o'oeka ima nare ñijirãñu, so'oeka marãoka ĩawãrũbeyua simarãñu. I'suᵽaka simako'omakaja se'etorirãki ĩ'rĩkaja sĩawãrũrãki”, ãrĩwa'ri mio'obe,— makãrãrũñuroka uᵽakaᵽi yire ᵽemakotowiraᵽakire bojaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV2_18","096_2_18","REV","2","18","18","Toᵽi ikuᵽaka makãrãrũñuroka uᵽakaᵽi ᵽemakotowiraᵽakire yire ãrãᵽe ate: —Tiatirarã yire ã'mitiriᵽẽarimajare imaruᵽutarimajiro'si ikuᵽaka o'otirã miᵽũatabe: “ ‘Ᵽeka jũrẽika uᵽaka yiñakoa ya'taiki ñime. I'suᵽakajaoka, bronce najoemaka saya'taika uᵽaka saya'tayu ñu'ᵽua’, yi'i Tuᵽarã Makiji mijare yibojayu. ");
INSERT INTO tnc_vpl VALUES ("RV2_19","096_2_19","REV","2","19","19","Ritaja mija baaika õrĩᵽataiki ñime. Suᵽa imarĩ ‘Ᵽo'imajare wayuĩarimaja, suᵽabatirã yire ã'mitiriᵽẽairã nime’, mijareka ñarĩrijayu. I'suᵽakajaoka ritaja aᵽerãte mija jeyobaaika õrĩᵽataiki ñime. Yire ã'mitiriᵽẽairã mija imamaka, ba'iaja aᵽerãte mijare baarijayu. I'suᵽaka mijare nabaako'omakaja yire mija ã'mitiriᵽẽaika ja'atabeyurã mija ime. I'suᵽaka simamaka ‘Mamarĩ yire nayi'riũ'muraᵽaka ᵽemawa'ribaji jia baairã nime’, mijareka ñañu. ");
INSERT INTO tnc_vpl VALUES ("RV2_20","096_2_20","REV","2","20","20","I'suᵽaka simako'omakaja ikuᵽaka mija baarijayu: Ĩ'rãko rõmo Jezabel wãmeikote ba'iaja jaiko'omakaja ‘Koᵽakaja, mijaitiyibe mae’, kore ãᵽekaja wiriwirikã'ãja kore mija ã'mitirikoᵽeyu. Suᵽa imarĩ mijaka jiitakaja jĩjimaka ñimabeyukaji ruᵽu. Mia je'e ikuᵽaka kõrĩrijayu: ‘Tuᵽarãro'si jaiĩjirirõmojo ñime.’ I'suᵽaka imako imarĩ ‘Aᵽerãka mija yaᵽaika uᵽakaja mija wã'imarĩkoᵽebe. I'suᵽakajaoka jẽrãka jiyiᵽuᵽayeewa'ri saᵽõ'irã wa'iro'si ri'ia naᵽããika mija ba'akoᵽejĩka’, ãᵽaraka kobojaᵽakirijayu. I'suᵽaka kõᵽakã'ã ã'mitiritirã, rukubaka ᵽuᵽajoairã jariwa'ri, yire yi'yurãte ba'iaja baayu. ");
INSERT INTO tnc_vpl VALUES ("RV2_21","096_2_21","REV","2","21","21","I'suᵽaka simamaka ba'iaja kobaaika ja'atarika yaᵽawa'ri, yita'akoᵽeraᵽe ruᵽu. I'suᵽaka simako'omakaja, ba'iaja kowã'imarĩrijayua ja'atariyaᵽabeyuko koime. ");
INSERT INTO tnc_vpl VALUES ("RV2_22","096_2_22","REV","2","22","22","Mia, i'suᵽaka koima simamaka, ‘Jimarĩa wãmarĩa jaritirã, kokãrĩᵽeyurũkiareka ba'iaja kojũaᵽeyurãñu’, koreka ñañu. Suᵽabatirã koka wã'imarĩrijayurã uᵽatireje i'suᵽakajaoka yibaarãñu i'suᵽaka ima ja'atabekaja nimarãkareka. ");
INSERT INTO tnc_vpl VALUES ("RV2_23","096_2_23","REV","2","23","23","Suᵽabatirã kowãrõika ã'mitiriᵽẽawa'ri i'sirokaᵽi imarijayurãteoka yiriataᵽatarãñu. I'suᵽaka yibaarãka ĩatirã, ‘Ritaja maᵽuᵽajoaika õrĩᵽataiki kime’, yireka narĩwãrũrãñu ika wejeareka yire yi'yurã uᵽatiji. Suᵽabatirãoka ‘Maimarijayu uᵽakaja, tẽrĩrika ima, ᵽemakaᵽañakaja imaoka mare sakiwaᵽajaiyu’, mija ãrĩwãrũrãñu. ");
INSERT INTO tnc_vpl VALUES ("RV2_24","096_2_24","REV","2","24","25","Tiatirareka imarã ĩ'rãrimarã ᵽuri kowãrõika ã'mitiriᵽẽabeyurã. ‘Ikuᵽaka sime imatiyaika bojariroka makioka õrĩbeyua’, ãrĩwa'ri ᵽakirirõmore wãrõika ã'mitiriᵽẽarimajare mijare bojako'omakaja samija ã'mitiririᵽe'yoyu. ‘Imatiyaika bojariroka sime’, narĩᵽakiyu Satanárika simako'omakaja. I'suᵽaka ima ã'mitiririᵽe'yoirã mija imamaka aᵽea mijare jã'mebesarãki yi'i. Mae mijare ñarĩrã baaika uᵽakatakaja mija imarijaᵽe. Mia je'e: Yiᵽe'rietarũkia ta'abaraka jia yire ã'mitiriᵽẽarija'atabekaja mija imarijaᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV2_26","096_2_26","REV","2","26","28","Yire ã'mitiriᵽẽarija'atabekaja, suᵽabatirã õñia nimatiyikuri yiyaᵽaika uᵽaka baarija'atabeyurãte ikuᵽaka ñarĩrãñu: ‘Ritaja wejeakarãre mijã'mebe’, Yiᵽakire yire ãrĩka uᵽakaja, ‘Ritaja wejeakarãre jã'meirã mija imarãñu’, nare ñarĩrãñu. I'suᵽaka simamaka Tuᵽarãte yi'ririyaᵽabeyurã ritatojo ika wejeareka imarãte wã'imakaja mija riatarãñu. Suᵽabatirã yire ã'mitiriᵽẽarija'atabeyurã mija imamaka, wãrĩrika ru'ara'aerã baaika ᵽoto tã'ᵽia õaika mijare yija'atarãñu ‘Ba'iaja baarika tẽñurã nime’, ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("RV2_29","096_2_29","REV","2","29","29","Mija ã'mitiᵽe ritaja wejeareka yire yi'ᵽaraka imarijayurã. Jia samija õrĩᵽũariyaᵽaye'e, Esᵽíritu Santore yire jeyobaaikaᵽi yibojaika jia mija ã'mitiᵽe”, ãrĩwa'ri mio'obe,— yire kibojaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV3_1","096_3_1","REV","3","1","1","I'sia ᵽemajĩrã ikuᵽaka yire kẽrãᵽe ate: —Sardes wejeareka yire ã'mitiriᵽẽairãte imaruᵽutarimajiro'si ikuᵽaka mio'oĩjibe: “Ĩ'ᵽotẽñarirakamarã uᵽaka tẽrĩwa'ribaji imatiyaiki Esᵽíritu Santo ᵽuᵽakaᵽi baarijayuka ñime. Suᵽabatirã ĩ'ᵽotẽñarirakamarã tã'ᵽia rikaiki ñime. Mia je'e: Ritaja mija baaika õrĩᵽataiki ñime. Mijare ĩatirã ‘Cristore jia yi'yurã nime’, ᵽo'imajare mijareka ãrĩko'omakaja yireka ᵽuri yiyaᵽaika uᵽaka baabeyurã imarĩ, yire ã'mitiriᵽẽabeyurã uᵽakaja mija ime. ");
INSERT INTO tnc_vpl VALUES ("RV3_2","096_3_2","REV","3","2","2","¡Jia mija ᵽuᵽajoabe! Yire yi'ribeyurã uᵽakaja mija jayua simamaka, jia ᵽuᵽaᵽe'ritirã yire mija ã'mitiriᵽẽabe ate, yire mija yi'yua mija ja'atakoreka. Tuᵽarã ñakoarekaoka kiyaᵽaika uᵽakataka baabeyurã mija ime ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("RV3_3","096_3_3","REV","3","3","3","Suᵽabatirã mamarĩ yirika bojariroka mija wãrũũ'muraᵽakakaka jia mija ᵽuᵽajoaᵽe'abe. I'suᵽaka jia sõrĩwaᵽu'aᵽe'atirã, ba'iaja mija baaika mija ja'atabe. I'suᵽaka mija baabesarãkareka, ikuᵽarõ'õᵽiji karee'erimajire etaika uᵽakaja mija õrĩbeyurõ'õᵽiji mija ᵽõ'irã etatirã mijare sayiwaᵽajairãñu. ");
INSERT INTO tnc_vpl VALUES ("RV3_4","096_3_4","REV","3","4","4","I'suᵽaka simako'omakaja, ĩ'rãrimarã takaja imarã Sardereka ba'iaja baabeyurã. I'suᵽaka imarã ᵽuri jariroaka ka'imarĩa jããirã uᵽaka imarã. Suᵽa imarĩ ‘Ba'iaja baariᵽe'yoirã imarĩ, jia boia jariroaka jããtirã yika nimarãñu’, ñañua jia sime. ");
INSERT INTO tnc_vpl VALUES ("RV3_5","096_3_5","REV","3","5","5","I'suᵽaka simamaka imarãreje Satanáre ĩ'rãᵽẽ'rõtorãja baairãte jariroaka jia boia yijããrũjerãñu. Suᵽa imarĩ ‘Ikarakamarã nime yika imajiᵽarũkirã’, ᵽaᵽera ᵽũñurã ãñua yirũ'rẽbesarãñu. I'suᵽakajaoka, Yiᵽakire ĩarãka wãjitãji, suᵽabatirãoka kiángelrãkare ĩarãka wãjitãji ‘Yire yi'yurã nime’, nareka ñarĩrãñu. ");
INSERT INTO tnc_vpl VALUES ("RV3_6","096_3_6","REV","3","6","6","Mija ã'mitiᵽe ritaja wejeareka yire yi'ᵽaraka imarijayurã. Jia samija õrĩᵽũariyaᵽaye'e, Esᵽíritu Santore yire jeyobaaikaᵽi yibojaika jia mija ã'mitiᵽe”, ãrĩwa'ri mio'obe,— yire kibojaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV3_7","096_3_7","REV","3","7","7","—Toᵽi ate Filadelfia wejeareka yire ã'mitiriᵽẽairãte imaruᵽutarimajiro'si ikuᵽaka mio'oĩjibe: “Tuᵽarãᵽi imarijayuka imarĩ ñañu uᵽakaja baarijayuka ñime. Suᵽabatirã ĩᵽi David imaroyikaki riᵽarãmi imarĩ, kiuᵽakajaoka Tuᵽarãrirãre jã'merimaji ñime. I'suᵽaka simamaka ĩ'rĩkate yijã'merũkirõ'õrã kãkaokaro'si koᵽereka yiwierãka, maki satãtewãrũberijĩki. Suᵽabatirãoka ĩ'rĩkate sarã kãkakoreka koᵽereka yitãterãka maki wieberijĩki. ");
INSERT INTO tnc_vpl VALUES ("RV3_8","096_3_8","REV","3","8","8","Ritaja mija baarijayua õñuka ñime. Ᵽo'imajare mijare ĩaikareka ᵽuri ‘Imatiyarimaja nime’, mijareka ãrĩbeyurã. I'suᵽaka mijareka nañua simako'omakaja yiwãrõeka jia yi'ririjayurã mija ime. Suᵽabatirãoka aᵽerãte kĩkiwa'ri ‘Jesucristore yi'ribeyurã yija’, ãrĩbeyurã mija ime. Mija ĩabe, maki mijare jãjibaakoreka, koᵽereka mijaro'si yiwieyu, yibojariroka mija wãrõrijayaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("RV3_9","096_3_9","REV","3","9","9","Mija ã'mitiᵽe. Torã imarã ᵽakirika jaibaraka ‘Tuᵽarãrirã yija ime’, ãrĩriᵽotojo Satanáre yaᵽaika uᵽaka baarijayurã. I'suᵽaka imarã nimamaka ñamajĩ mija wãjitãji nare yiñukuruᵽarũjerãñu mijare najiyiᵽuᵽayeeokaro'si. I'suᵽaka nare yibaarãñu ‘Jesucristore wãtairã nime’, mijareka nañaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("RV3_10","096_3_10","REV","3","10","10","‘Ba'iaja aᵽerãte mijare baako'omakaja, yire ã'mitiriᵽẽabaraka mija imabe’, mijare ñarãᵽaka uᵽakaja yi'yurã mija ime. Suᵽa imarĩ ritaja ᵽo'imajare ba'iaja jũarijẽ'rãka seyarãka ᵽoto mijare ĩarĩᵽaraka ñimarijarirãñu. I'tojĩte ritatojo wejeareka imarãte ĩatirã ‘Ĩrã imarã ba'iaja jũawa'ri ᵽuᵽaᵽe'ritirã yire ã'mitiriᵽẽairã, aᵽerimarã ᵽuri jẽno'o bajijayurã’, ñarĩwãrũrãñu. ");
INSERT INTO tnc_vpl VALUES ("RV3_11","096_3_11","REV","3","11","11","Mia, no'ojĩrãmarĩa ikuᵽarõ'õᵽiji eyarũkika ñime. I'suᵽaka simamaka yire mija ã'mitiriᵽẽarijayua ja'atabekaja mija imabe. I'suᵽaka mija imamaka, ñamajĩ jiibaji Tuᵽarãte mijare baarãñu. Suᵽa imarĩ ba'iaja baairãte mija ã'mitiriᵽẽa'si. ");
INSERT INTO tnc_vpl VALUES ("RV3_12","096_3_12","REV","3","12","12","Yire ã'mitiriᵽẽarija'atabesarãñurãte, Yiᵽaki ᵽõ'irã yeyarũjerãñu. Suᵽa imarĩ Yiᵽaki Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã bota ima uᵽaka torã imajiᵽarũkirãro'si nimarãñu, toᵽi ᵽorirũkimarĩrã. I'suᵽaka nimamaka, maekarakawãme nare yiwãmejĩ'arãñu. Ikuᵽaka sime i'sia: Yiᵽaki Tuᵽarã wãmea, mamaka Jerusalén wãmea, suᵽabatirã mamaka yiwãmea nareka yo'oekarã nimarãñu. Ikuᵽaka sime: Ĩmiᵽi Yiᵽakire wejea mamaka ruetarãñu. ");
INSERT INTO tnc_vpl VALUES ("RV3_13","096_3_13","REV","3","13","13","Mija ã'mitiᵽe ritaja wejeareka yire yi'ᵽaraka imarijayurã. Jia samija õrĩᵽũariyaᵽaye'e, Esᵽíritu Santore yire jeyobaaikaᵽi yibojaika jia mija ã'mitiᵽe”, ãrĩwa'ri mio'obe.— ");
INSERT INTO tnc_vpl VALUES ("RV3_14","096_3_14","REV","3","14","14","Torãjĩrã yire ᵽemakotowiraᵽakire ikuᵽaka yire jairaᵽe ate: —Laodiceawejeareka yire ã'mitiriᵽẽairãte imaruᵽutarimajiro'si ikuᵽaka mio'oĩjibe: “ ‘Yi'iᵽi ãrĩwa'ri Tuᵽarãte ᵽuᵽajoaika uᵽakaja simaokaro'si baarimaji ñime. Ritaja ñarĩka uᵽakaja baawa'ri, wãjiroka Tuᵽarãte ima bojarijayuka ñime. Suᵽabatirã yi'iᵽi ãrĩwa'rijioka ritatojo ika wejeareka ima Tuᵽarãte ᵽo'ijiaeka. I'suᵽaka imaki kime, ika mijare bojaiki’, ãrĩwa'ri naro'si mio'obe. ");
INSERT INTO tnc_vpl VALUES ("RV3_15","096_3_15","REV","3","15","15","Ritaja mija baaika õrĩᵽataiki ñime. Yire yi'ririja'atabeyurã mija imako'omakaja, ‘Jiibaji kika marĩrãkibiᵽakã'ã jia sime’, yireka ãrĩbeyurã mija ime. I'suᵽaka imarã imarĩ, ukurũkia ijitakamaria, suᵽabatirã jijitakamarĩa uᵽaka mija ime. I'suᵽaka mija imarika yaᵽabeyuka yi'i. ");
INSERT INTO tnc_vpl VALUES ("RV3_16","096_3_16","REV","3","16","16","I'suᵽaka yika imarã mija imamaka, jiamarĩa imawa'ri, koᵽakaja mijare yija'ataerã baayu mae. ");
INSERT INTO tnc_vpl VALUES ("RV3_17","096_3_17","REV","3","17","17","Mia, ‘Ritaja Tuᵽarãrikakaka õrĩwãrũirã maime. Suᵽa imarĩ rĩkimakaja ba'irĩjia rikairã uᵽaka imawa'ri, dakoa mare jariwa'ribeyua’, mija ãñu. I'suᵽaka mija ãrĩko'omakaja, yiñakoareka imatiyaika õrĩᵽũabeyurã mija ime jia yire ã'mitiriᵽẽabeyurã imarĩ. Ba'irĩjimarirã, suᵽabatirã jariromarĩrã, yoibeyurã uᵽaka mija ime mijare ñiaikareka. ");
INSERT INTO tnc_vpl VALUES ("RV3_18","096_3_18","REV","3","18","18","I'suᵽaka mija imamaka, ikuᵽaka mijare yibojaerã baayu mae. Mija ã'mitiᵽe, yire yi'riᵽẽawa'ri jia okajãjia mija imariyaᵽaye'e, ba'iaja mija ᵽuᵽaka ima ja'atatirã, yire mija jẽñebe. I'suᵽaka mija baamaka ‘Tuᵽarãte yaᵽaika uᵽakaja maimaye'e’, ãñurã mijare ñimarũjerãñu. Ĩakõrĩ je'e: I'suᵽaka mija imamaka, oro rukuberika yireka waruayurã uᵽaka yirika imatiyaikakaka mija õrĩwaᵽu'arãñu. Jariromarĩrã imarĩ i'yoa jũarikoᵽakaja jariroaka boia yire jẽñetirã sajããirã uᵽaka mija imabe yiñakoareka ba'iaja baabeyurã mija imaokaro'si. I'suᵽakajaoka jia ĩaokaro'si ñakoĩkoa yaᵽairã uᵽaka kĩkirimarĩa yire mija jẽñebe yiᵽuᵽajoaika õñurã mija imaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("RV3_19","096_3_19","REV","3","19","19","Mija ã'mitiᵽe. Wãtaka ñoñurã uᵽatata yokajããmaka, ba'iaja mija baaika mija ja'atabe. Saja'atatirã yire takaja ã'mitiriᵽẽairã mija imabe. ");
INSERT INTO tnc_vpl VALUES ("RV3_20","096_3_20","REV","3","20","20","Mija ĩabe, ‘Naka rĩrãkibiᵽaraka ñimarũ’, ãrĩwa'ri mijare yakayu. I'suᵽaka simamaka yoka ã'mitiriᵽẽatirã, ‘Ã'ã, i'suᵽakaja mika yija imarũ’, yire ãñurãka jia ñimarãñu. ");
INSERT INTO tnc_vpl VALUES ("RV3_21","096_3_21","REV","3","21","21","Suᵽa imarĩ ba'iaja jũariᵽotojo yire ã'mitiriᵽẽarija'atabekaja imarijayurãte, mabo'ikakurirõ'õrã yire jã'mejeyobaarimaja ñimarũjerãñu. Yiᵽakire yi'ririja'atabeyuka imarĩ, kire jã'mejeyobaarimaji ñima uᵽakaja nimarãñu yika naro'si. ");
INSERT INTO tnc_vpl VALUES ("RV3_22","096_3_22","REV","3","22","22","Mija ã'mitiᵽe ritaja wejeareka yire yi'ᵽaraka imarijayurã. Jia samija õrĩᵽũariyaᵽaye'e, Esᵽíritu Santore yire jeyobaaikaᵽi yibojaika jia mija ã'mitiᵽe”, ãrĩwa'ri mio'obe,— yire kibojaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV4_1","096_4_1","REV","4","1","1","I'suᵽaka simaraᵽaka be'erõ'õ ikuᵽaka simaraᵽe ate: Mabo'ikakurirã koᵽereka wieka imamaka ñiaraᵽe. Sañiaraᵽaka ᵽoto tromᵽeta jãjia okaayu uᵽakaᵽi yire jaiũ'muraᵽakite ikuᵽaka yire ãrãᵽe ate: —Õ'õrã mi'tabe, ñamajĩ imarũkiakaka mire yibeaokaro'si,— yire kẽrĩkoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV4_2","096_4_2","REV","4","2","2","Toᵽi mae makãrãrũñuroka uᵽakaᵽi ñimaraᵽaka ᵽoto mabo'ikakurirã Esᵽíritu Santore yire eyarũjeraᵽe. Torã eyatirã ĩᵽi ruᵽarikũmuareka ĩ'rĩkate ruᵽamaka ñiaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV4_3","096_4_3","REV","4","3","3","Ãta jasᵽe, suᵽabatirã cornalina ya'tarika ima uᵽaka ya'taiki kimaraᵽe torã ruᵽaraᵽaki. Torã ruᵽaraᵽaki wã'tarã ne'eᵽurea, esmeralda wãmeika ãta uᵽaka ya'taika imaraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV4_4","096_4_4","REV","4","4","4","Suᵽabatirã kiruᵽaraᵽarõ'õrã ĩ'rĩka ᵽo'imaji baatirã botarakamaki ᵽakiarimarã saya boia jããtiirã kiwã'tarã narãkuruᵽaraᵽe ruᵽarikũmuaᵽitiyika. Ĩᵽarimarãro'si simaraᵽe ruᵽarikũmua. Suᵽabatirã orokaka baaeka bu'ya tuaekarã nimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV4_5","096_4_5","REV","4","5","5","Suᵽabatirã nañe'metãji niᵽamakire ruᵽaraᵽakũmuᵽi wĩᵽoa yaajiyeika uᵽaka sabaaraᵽe. I'suᵽaka baawa'ri jãjitaka wĩᵽoa jaika uᵽaka sokaaraᵽe. Kiruᵽaraᵽaka wãjitãji ĩ'ᵽotẽñarirakabi ᵽeka jũ'rẽika imaraᵽaka. I'suᵽaka ᵽeka jũ'rẽraᵽaka Esᵽíritu Santo koᵽakaja ima simaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV4_6","096_4_6","REV","4","6","6","I'suᵽakajaoka Tuᵽarã ruᵽarikũmuwãjitãji riaᵽakiaka jia waria okoika imaraᵽaka. Suᵽabatirã, botarakamarã maikoribeyu uᵽaka ĩoirã watoᵽekarã kiruᵽaraᵽe. Naᵽemaᵽẽ'rõtoᵽi, naᵽẽterõ'õᵽioka rĩkimakaja ñakokirã nimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV4_7","096_4_7","REV","4","7","7","Mamarĩ õiũ'muraᵽaki yaia león uᵽaka ĩoika imaraᵽaki. Aᵽika imaraᵽaki wa'ibikirãwẽko uᵽaka ĩoiki. Kibe'erõ'õjĩte kimaraᵽe ᵽo'imaja ᵽema uᵽakaja ᵽemaiki. Ᵽiyika imaraᵽaki awaᵽakiaka wiyu uᵽaka imaki. ");
INSERT INTO tnc_vpl VALUES ("RV4_8","096_4_8","REV","4","8","8","Maikoribeyurã uᵽaka ĩoirã nimaraᵽaka imarĩ, ĩ'rõtẽñarirakato kajekirã nimaraᵽe. Naᵽo'iareka rĩkimakaja ñakoirã nimaraᵽe, nakajerokarõ'õᵽioka. Ĩmi, ñami ᵽariji Tuᵽarãte jiyiᵽuᵽayeebaraka ikuᵽaka nabayakoyarijayu: —Ba'iaja baakoribeyuka mime. Ba'iaja baakoribeyuka mime. Ba'iaja baakoribeyuka mime. I'suᵽakajaoka ritaja ima tẽrĩwa'ribaji imaki mime. I'suᵽakajaoka bikija imara'aekaki imariᵽotojo, maekakaoka imarijayuka mime. Suᵽabatirã mi'ijioka imaki imajiᵽarijarirũkika,— ãᵽaraka nabayakoyaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV4_9","096_4_9","REV","4","9","9","Ĩᵽire kiruᵽarikũmuarã ruᵽamaka ĩatirã kire jiyiᵽuᵽayeebaraka ikuᵽaka narĩrijayu: —Ritaja ima ᵽemawa'ribajirã jiitakiji mime. Suᵽa imarĩ mi'i ĩ'rĩkaja tẽrĩrikaja jiyiᵽuᵽaka õrĩrũkika mimarijayu. Jiitaka mibaayu,— ãᵽaraka reyariba'imarĩka imakite najiyiᵽuᵽayeeyu. ");
INSERT INTO tnc_vpl VALUES ("RV4_10","096_4_10","REV","4","10","10","Ĩ'rãkurimarĩa i'suᵽaka baabaraka nima ᵽoto veinticuatro rakamarã ᵽakiarimarã kiwãjitãji mo'iᵽãñawa'yurã reyariba'imarĩka imakite jiyiᵽuᵽayeebaraka. Suᵽabatirã nabu'ya orokaka baaeka e'etatirã kiwã'tarã ᵽããjiyetirã ikuᵽaka kire narĩrijayu ate: ");
INSERT INTO tnc_vpl VALUES ("RV4_11","096_4_11","REV","4","11","11","—Yija ĩᵽamaki Tuᵽarã, mi'i ĩ'rĩkaja imaki jiyiᵽuᵽaka yija õrĩrũkika. Suᵽabatirã mi'ijioka imaki ritaja ᵽo'ijiaekaki, miyaᵽaeka uᵽakaja miᵽo'ijiaeka ritaja imañujua ruᵽu. I'suᵽaka simamaka ikuᵽaka ᵽo'imajare mire ãrĩrijarirũkika mime: “Ritaja ima ᵽemawa'ribajirã jiitakiji imarĩ, mi'i ĩ'rĩkaja tẽrĩrikaja jiyiᵽuᵽaka õrĩrũkika mime. I'suᵽakajaoka ritaja jã'merimaji mime”,— kire narãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV5_1","096_5_1","REV","5","1","1","I'suᵽaka simaraᵽaka be'erõ'õ ĩᵽire kiruᵽarikũmuarã ruᵽaraᵽaki ᵽitaka ritaᵽẽ'rõtoᵽi ᵽaᵽera buᵽeka kirikamaka ñiaraᵽe. Saᵽemarã, sarokaᵽioka o'oeka, suᵽabatirã ĩ'ᵽotẽñarirakaba'i ᵽaᵽatãteka simaraᵽe sareka. ");
INSERT INTO tnc_vpl VALUES ("RV5_2","096_5_2","REV","5","2","2","Toᵽi mae ángel tẽrĩwa'ribaji imatiyaiki ᵽemakotowiritirã ikuᵽaka ãrãᵽaki: —¿Maki imaki Tuᵽarã ñakoareka, ika ᵽaᵽera buᵽeka ᵽaᵽatãteka bebetirã sawierũkika?— ãrĩwa'ri jãjirokaᵽi kijẽrĩakoᵽeraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV5_3","096_5_3","REV","5","3","4","I'suᵽaka kẽrĩko'omakaja ni'ioka, ĩmirã imaki, ika wejeareka imakioka, suᵽabatirã marokakakurikakioka sawierũkika Tuᵽarã ñakoareka imaberaᵽaki. Ĩ'rĩka sĩatirã jairimajire imabeᵽakã'ã ĩawa'ri jimarĩa yoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV5_5","096_5_5","REV","5","5","5","I'suᵽaka ñimamaka ĩatirã, ĩ'rĩka ᵽakiaki ikuᵽaka yire bojaraᵽaki: —I'tojĩrãja mioritiyibe. Õ'õrã miyoibe mae. Õ'õrã ĩ'rĩkate ime Satanáre tẽrĩkaki. León jãjika uᵽaka ĩᵽi marãkã'ã mabaaberijĩki Judátatarãkaki, suᵽabatirã David ĩᵽi imaroyirekaki riᵽarãmi imarĩ, ĩ'ᵽotẽñarirakakuku ᵽaᵽera ᵽaᵽatãteka wierũkika kime,— ãrĩwa'ri yire kibojaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV5_6","096_5_6","REV","5","6","6","I'suᵽaka simaraᵽaka ᵽoto, ᵽakiarimarã watoᵽeka, suᵽabatirã botarakamarã maikoribeyu uᵽaka imaraᵽarã watoᵽekarã, ĩᵽi ruᵽarikũmua imaraᵽarõ'õrã ĩ'rĩka Oveja weiwa'yua uᵽaka ĩoikite imaraᵽe. Ᵽo'imajare kire jããeka kãmia kire imako'omakaja õñia imakite ñiaraᵽe. Suᵽabatirã ĩ'ᵽotẽñarirakabi wakaiki kimaraᵽe okajãjiki imarĩ. Toᵽi i'sirakaojoka ñakoika kimaraᵽe. Esᵽíritu Santo, tẽrĩritakire ika ka'ia ĩ'rãkõ'rĩmatomarĩa Tuᵽarãte ᵽũatayu ãrĩrikoᵽakaja simaraᵽe kiñakoa. ");
INSERT INTO tnc_vpl VALUES ("RV5_7","096_5_7","REV","5","7","7","Toᵽi mae Tuᵽarã ruᵽarikũmurõ'õrã ke'raᵽe ᵽaᵽera buᵽeka e'erĩ. Sarã keyaraᵽaka ᵽoto kiᵽitaka ritaᵽẽ'rõtoᵽi Tuᵽarãte kire sĩjiraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV5_8","096_5_8","REV","5","8","8","I'suᵽakajaoka botarakamarã maikoribeyu uᵽaka imaraᵽarã, suᵽabatirã veinticuatro rakamarã ᵽakiarimarã, kiwãjitãji namo'iᵽãñawa'raᵽe kire jiyiᵽuᵽayeewa'ri. Nimarakamarãja baya koyabaraka nabirerijayua arᵽa rikatirã, i'suᵽakajaoka orokaka seroa narikaraᵽe. Sareka sajãitaraᵽe samajoemaka jia jiijĩsia ooika. Sanajoeika ũmakaka mirĩwa'yua, Tuᵽarãte yi'yurã kire najẽñerijayu uᵽakaja imaraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV5_9","096_5_9","REV","5","9","10","Suᵽabatirã kiwãjitãji mo'iᵽãñawa'raᵽarã ikuᵽaka mamaroka ma'mitirikoribeyua bayakoyaraᵽarã: —Ᵽo'imajare mire jããeka. I'suᵽaka mire nabaako'omakaja ritaja wejeareka imarã ᵽo'imajaro'si, i'suᵽakajaoka ritaja ᵽo'imajatatarãte imabayu uᵽakaja, suᵽabatirã noka ima uᵽakaja jaibaraka imarãte mireyaeka riweaᵽi ãrĩwa'ri ba'iaja nabaaika miwaᵽakoyika, Tuᵽarãrirã nimaokaro'si. I'suᵽaka mibaaeka simamaka kurarãka uᵽakaja, Miᵽaki Tuᵽarãte yaᵽaika uᵽakaja baairã nime naro'si. Suᵽabatirãoka mi'iᵽi ãrĩwa'ri ritatojo wejeareka imarãte jã'mewãrũrũkirã nime. I'suᵽaka simamaka mi'ijioka imaki ᵽaᵽera buᵽeka wierũkika,— ãᵽaraka nabayakoyaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV5_11","096_5_11","REV","5","11","11","Torãjĩrã ate, Tuᵽarã ruᵽarikũmu wã'tarã botarakamarã maikoribeyu uᵽaka imaraᵽarã, suᵽabatirã veinticuatro rakamarã ᵽakiarimarãre ima ᵽẽterõ'õᵽi, naruᵽurõ'õᵽioka rĩkimarãja ángelrãka imaraᵽarãre bayakoyaraᵽe. Rĩkimarãja majoaᵽataberijĩñurã nimamaka ñiaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV5_12","096_5_12","REV","5","12","12","Toᵽi mae jãjirokaᵽi ikuᵽaka nabayakoyaraᵽe: —Ᵽo'imajare ba'iaja baaikareka nare tããwa'ri, Oveja weiwa'yua uᵽaka imakite reyaeka. I'suᵽaka baaekaki imarĩ tẽrĩriki, suᵽabatirãoka jia wãjia õñuka kime. I'suᵽakajaoka dika jariwa'ririmarĩa jã'mewãrũiki kimamaka, ritaja kirika oyiaja sime. I'suᵽakaja imaki imarĩ kire oyiaja jiyiᵽuᵽayeerũkika kime. Suᵽabatirã “Ritaja ima tẽrĩwa'ribaji jiitakiji kime”, ᵽo'imajare ãrĩrũkika Oveja weiwa'yua uᵽaka imakite ime,— ãᵽaraka jiyiᵽuᵽakaᵽi ángelrãkare kireka bayakoyaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV5_13","096_5_13","REV","5","13","13","Suᵽabatirã ritaja õñirã Tuᵽarãte ᵽo'ijiaekarã mabo'ikakurirã imarã, õ'õrã imarãoka jaimaka ña'mitiraᵽe. I'suᵽakajaoka ka'ia watoᵽekarã imarã, okowatoᵽekareka ima ᵽariji jaimaka ña'mitiraᵽe. Suᵽabatirãoka Tuᵽarã, Oveja weiwa'yua uᵽaka imakite ᵽariji jiyiᵽuᵽayeebaraka ikuᵽakã'ã nabayakoyaraᵽe: —Ĩᵽi kiruᵽarikũmuareka ruᵽakite, kiwã'tarã Oveja weiwa'yua uᵽaka imakiteoka majiyiᵽuᵽayeerũkirã nime. Jiyiᵽuᵽaka mijare õrĩrijariwa'ri, “Jiitarã mija ime”, ritaja mijare narĩrijarirũ. Ritaja ima ᵽemawa'ribajirã jiitarãja, suᵽabatirã ritaja jã'merimaja imarijayurã mija ime. I'suᵽaka oyiaja simarijarirũ,— nareka najaikoᵽakã'ã ña'mitiraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV5_14","096_5_14","REV","5","14","14","Toᵽi mae, —I'suᵽaka oyiaja baarijarirũkia simarũ,— botarakamarã maikoribeyu uᵽaka imaraᵽarãte ãrĩkoraᵽe. Suᵽa imarĩ i'tojĩteje, ĩᵽiruᵽarikũmuarã ruᵽaraᵽakite, suᵽabatirã Oveja weiwa'yua uᵽaka imakite jiyiᵽuᵽayeewa'ri veinticuatro rakamarã ᵽakiarimarãre nawãjitãji mo'iᵽãñawa'raᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV6_1","096_6_1","REV","6","1","1","I'suᵽaka simaraᵽaka be'erõ'õ Oveja weiwa'yua uᵽaka imakite, mamarĩkakuku ᵽaᵽera buᵽeka ᵽaᵽatãteka kiwiemaka ñiaraᵽe. Torãjĩrã mae, botarakamarã maikoribeyu uᵽaka imaraᵽarãkaki wĩᵽoa jãjitaka jã'mitaika uᵽaka jaibaraka ikuᵽaka ãrãᵽaki: —Mi'tabe.— ");
INSERT INTO tnc_vpl VALUES ("RV6_2","096_6_2","REV","6","2","2","I'suᵽaka kẽᵽakã'ã ĩaᵽũataerã baakõrĩ, ĩ'rĩka kawaru boikate i'tarijaᵽakã'ã ñiaraᵽe. Kiᵽemarã tuyuraᵽaki tẽmuᵽãia rikatirã, kiruᵽuko'arã bu'ya Tuᵽarãte kire tuaekaki kimamaka ñiaraᵽe. Saᵽi ãrĩwa'ri tẽrĩrimaji imarĩ, aᵽeka'iarã imarãte tẽrĩrijari ke'raᵽe mae. ");
INSERT INTO tnc_vpl VALUES ("RV6_3","096_6_3","REV","6","3","3","Suᵽabatirã Oveja weiwa'yua uᵽaka imaki ate aᵽekuku ᵽaᵽera buᵽeka ᵽaᵽatãteka kiwieraᵽaka ᵽoto ikuᵽaka aᵽika maikoribeyu uᵽaka imaraᵽakite ãrĩkoraᵽe: —Mi'tabe.— ");
INSERT INTO tnc_vpl VALUES ("RV6_4","096_6_4","REV","6","4","4","I'suᵽaka kẽᵽakã'ã kawaru jũ'akite i'tarijaᵽakã'ã ñiaraᵽe. Kiᵽemarã tuyuraᵽakite sara ᵽo'imajare jããrũkia Tuᵽarãte ĩjikakite imamaka ñiaraᵽe. Ᵽo'imajare jããbu'abaraka imaokaro'si Tuᵽarãte jã'mekaki kimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV6_5","096_6_5","REV","6","5","5","I'kire a'ritaᵽaraᵽaka be'erõ'õ Oveja weiwa'yua uᵽaka imaki aᵽekuku ᵽaᵽera buᵽeka ᵽaᵽatãteka kiwieraᵽe. I'tojĩte ate aᵽika maikoribeyu uᵽaka imaraᵽakite ãrĩkoraᵽe, —Mi'tabe.— Torãjĩrã yoirã baakõrĩ kawaru neikate ñiaraᵽe. Kiᵽemarã tuyuraᵽaki no'ojĩrã rĩkia jẽrãbaarũkia rikaiki kimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV6_6","096_6_6","REV","6","6","6","Suᵽabatirã maikoribeyurã uᵽaka imaraᵽarã watoᵽekaᵽi ikuᵽaka sãrĩkoraᵽe kawaru ᵽemarã tuyuraᵽakite: —Trigo, suᵽabatirã cebada ĩjitirã kũᵽajĩrĩti niñerũ sawaᵽa e'erũkia samijarirũjebe. I'suᵽaka simamaka ĩ'rãrĩmi ba'iraberiwaᵽa ĩ'rãwajojĩkaja trigo tõᵽorika simarãñu. I'suᵽakajaoka simarãñu ĩ'rãrĩmi ba'iraberiwaᵽa maekarakawajojĩka cebada tõᵽorika simarãñu. I'suᵽaka simako'omakaja, olivoᵽitiyika, iyaka ĩ'ᵽaba'i õterikia mirũetarirũjebesarãñu. Iyaokoa, olivo iyebaka yo'arũkiaoka waᵽajã'rĩmarĩa mijarirũjerãñu,— ãᵽaraka sajaikoraᵽe kawaru ᵽemarã tuyuraᵽakite. ");
INSERT INTO tnc_vpl VALUES ("RV6_7","096_6_7","REV","6","7","7","I'kire a'raᵽaka be'erõ'õ, aᵽekuku ᵽaᵽera buᵽeka ᵽaᵽatãteka Oveja weiwa'yua uᵽaka imakite wieraᵽe. I'suᵽaka kibaaraᵽaka be'erõ'õjĩte ikuᵽaka ᵽiyika maikoribeyu uᵽaka imaraᵽaki ãrĩkoraᵽaki: —Mi'tabe.— ");
INSERT INTO tnc_vpl VALUES ("RV6_8","096_6_8","REV","6","8","8","Suᵽa kẽrãᵽaka be'erõ'õjĩte, ᵽo'ibosirika jũaiki uᵽaka ĩoika ᵽoyaiki kawarute ñiaraᵽe. Kiᵽemareka tuyuraᵽaki reyarika jã'merimaji wãmeiki kimaraᵽe. Kibe'erõ'õ imaraᵽaki, “Reyaeka mirãrãte imarõ'õ”, wãmeiki kimaraᵽe. I'suᵽaka nimaraᵽaka ᵽoto ikuᵽaka Tuᵽarãte nare ãrĩkoraᵽe: —Ika wejeareka imarã ᵽo'imaja ᵽitã'muaᵽi, kẽsiaᵽi, risirikaᵽi, makaᵽoyamajakaᵽioka mija jããᵽatabe. I'suᵽaka baawa'ri ritaja ᵽo'imajare botarakario'ro ᵽibatirã ĩ'rão'ro ᵽurirãñu,— kẽrĩkoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV6_9","096_6_9","REV","6","9","9","Torãjĩrã ate aᵽekuku ᵽaᵽera buᵽeka ᵽaᵽatãteka Oveja weiwa'yua uᵽaka imakite wieraᵽe. Suᵽa kibaaraᵽaka ᵽoto joeĩjiritẽrĩ wã'tarã najããekarãte imamaka ñiaraᵽe. I'suᵽaka torã nimamaka ñiaraᵽarã õñia nimaeka ᵽoto Tuᵽarã majaroka wãrõbaraka “Jesúre yi'yurã yija ime”, nañua ja'atabeyurã nimamaka Tuᵽarãte ã'mitiriᵽẽabeyurãre jããekarã nimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV6_10","096_6_10","REV","6","10","10","Ĩ'rã mae jãjirokaᵽi ikuᵽaka ãrãᵽarã: —Ritaja jã'merimaji, ĩ'rãkuri ba'iaja baakoribeyuka mime, suᵽabatirã wãjia bojarijayuka imarĩ, meñu uᵽakaja baaiki mime. I'suᵽaka simamaka, yijare jããraᵽarãte ba'iaja baamaka ĩatirã, “Ba'iaja imarika tiyibesarãka mijaro'si”, nare merĩrũkia, ¿no'ojĩrã yaje sarã seyarũkia jariwa'yua?— kire narãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV6_11","096_6_11","REV","6","11","11","I'suᵽaka naᵽakã'ã saya uᵽaka jariroaka jia boia nare kĩjiraᵽe. Nare sĩjitirã, —Jajua baabekaja mija imabe. Aᵽerã imañujurã ruᵽu mija uᵽakaja yimajaroka bojarimaja. Saᵽi'iwa'ri ba'iaja baarimajare nare jããrũkirã nime,— Tuᵽarãte ãrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV6_12","096_6_12","REV","6","12","12","Torãjĩrã ate, aᵽekuku ᵽaᵽera buᵽeka ᵽaᵽatãteka Oveja weiwa'yua uᵽaka imakite wieraᵽe. I'suᵽaka kibaaraᵽakarõ'õjĩte jãjia ka'ia iyiraᵽaka. I'suᵽaka sabaaraᵽaka ᵽoto ĩmikaki aiyate ta'sikã'ãja ririwa'raᵽe. Suᵽabatirã ñamikaki jũ'aitakaja riwerõ'õjĩrã jaraᵽaki kiro'si. ");
INSERT INTO tnc_vpl VALUES ("RV6_13","096_6_13","REV","6","13","13","Suᵽabatirã tã'ᵽia ka'iarã jũjiraᵽaka, rĩkimaka higuerarika wĩrõa baeᵽatemaka jũjika uᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV6_14","096_6_14","REV","6","14","14","Torãjĩrã mae wejeᵽema ñe'metãjirã ta'ritatirã sariraᵽe. I'tojĩteje ᵽusia, jũmurika imakoᵽeikaoka aᵽerõ'õrã oyiaja Tuᵽarãte wiataᵽataraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV6_15","096_6_15","REV","6","15","15","I'suᵽaka simamaka ãta wi'iarã, ᵽusiareka ãta watoᵽekarã ᵽo'imajare ru'raᵽe. Ĩᵽarimarã, suᵽabatirã jã'merimaja, imatiyarimaja, imatiyabeyurãoka, suᵽabatirã aᵽerãro'si ba'iraberimaja, aᵽerãro'si ba'irabeĩjibeyurãoka, sareka naru'rikãkaraᵽe. I'suᵽakajaoka rĩkimaka niñerũ rikairã, wayuoka baairãᵽitiyika ritaja ᵽo'imajare sarã ru'raᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV6_16","096_6_16","REV","6","16","17","Suᵽabatirã ikuᵽaka ᵽusia narãᵽe mae: —Yijare mika'ratãtebe ĩᵽi ruᵽarikũmuarã ruᵽaraᵽakite yijare ĩatõᵽokoreka. Suᵽabatirãoka Oveja weiwa'yua uᵽaka imakite ba'iaja yijare jũarũjekoreka. Koᵽakaja i'suᵽaka ᵽo'imajaro'si imarũkirĩmi yijare seyayu mae. I'suᵽaka simamaka ni'ioka sareka ru'riwãrũbesarãki,— ãᵽaraka ᵽusia najairaᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV7_1","096_7_1","REV","7","1","1","Torãjĩrã mae botarakamarã ángelrãkare ñiaraᵽe. Ĩ'rĩka jã'ãtiᵽẽ'rõtoᵽi rĩkamaraᵽaki. Aᵽika wayeruᵽitikaᵽi, aᵽika rĩkamaraᵽaki wejerĩrĩkaᵽi. Suᵽabatirã aᵽika aᵽeᵽẽ'rõto wejerĩrĩkaᵽi rĩkamaraᵽaki. I'suᵽaka rĩkamaritirã wĩrõa riabo'i, yaᵽubo'irã, ka'iarã baekoᵽeikaoka nabaetiyirũjeraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV7_2","096_7_2","REV","7","2","2","Torãjĩrã aᵽika ángel jã'ãtikaᵽi i'tamaka ñiaraᵽe, Tuᵽarã, õñia imajiᵽarimaji wãmea kio'ojĩ'arũkia rikatirã. Suᵽabatirã aᵽerã ángelrãka riaᵽakiaka, ka'ia Tuᵽarãte ba'iaja baarũjekarã ᵽõ'irã etatirã jãjirokaᵽi ikuᵽaka nare kẽrãᵽe: ");
INSERT INTO tnc_vpl VALUES ("RV7_3","096_7_3","REV","7","3","3","—Yaᵽua, riaka, ka'ia mija bitata'si, Tuᵽarãte yaᵽaika uᵽakaja baarimaja kũ'arã kiwãmea yija o'ojĩ'arãñu ruᵽu. I'suᵽaka nare yija baarãka be'erõ'õᵽi ᵽuri, samija bitataᵽuarãñu,— nare kẽrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV7_4","096_7_4","REV","7","4","8","Torãjĩrã mae, —Nimauᵽatiji ᵽuri 144,000 rakamarã nime Israelkarã Tuᵽarã wãmea yija o'ojĩ'arũkirã,— sãrĩkoraᵽaka ña'mitiraᵽe. Ã'mitirikõrĩ je'e: ikuᵽaka wãmeirã nimaraᵽe ĩ'ᵽoũ'ᵽuarãe'earirakatata imaraᵽarã: Judá imaroyirekaki tatakarã doce mil rakamarã imaraᵽarã. Toᵽi aᵽerã i'siarakamarã oyiaja nimaraᵽe ikuᵽaka wãmeirã: Rubén, Gad, Aser, Neftalí, Manasés, Simeón, Leví, Isacar, Zabulón, José, Benjamín Ĩ'ᵽoũ'ᵽuarãe'earirakatata nimaraᵽe. Ĩ'rãtata uᵽakaja doce mil rakamarã nimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV7_9","096_7_9","REV","7","9","9","I'sia be'erõ'õ Tuᵽarã ruᵽarikũmu wãjitãji, suᵽabatirã Oveja weiwa'yua uᵽaka imaki wãjitãji rĩkimarãja ᵽo'imajare rĩkamaᵽakã'ã ñiaraᵽe. Ĩ'rãka'ikarãmarĩrã, ĩ'rãwejekarãmarĩrã, ritaja ᵽo'imaja oka jairã, suᵽabatirãoka ritaja ᵽo'imajatata uᵽatikarã nimaraᵽe. Suᵽa imarĩ marãkã'ã baatirã majoaᵽuaberijĩñurã nimaraᵽe. Nimauᵽatiji saya boia jããtirã ne'ejĩjoa ĩoika rikabaraka nimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV7_10","096_7_10","REV","7","10","11","Toᵽi mae jĩjimaka imawa'ri jãjirokaᵽi ikuᵽaka narãᵽe: —Tuᵽarãte jã'mebaraka ruᵽarijayurõ'õrã ruᵽaki, suᵽabatirã Oveja weiwa'yua uᵽaka imakiᵽitiyika ĩ'ᵽarãwã'taja jiamarĩareka mare tããrimaja nime,— naᵽakã'ã ña'mitiraᵽe. I'suᵽaka ᵽo'imajare ãñukã'ãja, Tuᵽarã ruᵽarikũmu wã'tarã botarakamarã maikoribeyu uᵽaka imarãte imaraᵽe. Suᵽabatirã veinticuatro rakamarã ᵽakiarimarãre ima ᵽẽterõ'õᵽi, naruᵽurõ'õᵽioka ritaja ángelrãkare rĩkajiyeraᵽe. Toᵽi nimauᵽatiji kiruᵽarikũmu wãjitãji Tuᵽarãte jiyiᵽuᵽayeebaraka namo'iᵽãñawa'raᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV7_12","096_7_12","REV","7","12","12","Suᵽabatirã kire jiyiᵽuᵽaka õrĩwa'ri, ikuᵽaka jaibaraka nimaraᵽe: —Rita sime. “Jiitakiji mime”, mire ᵽo'imajare ãrĩrijarirũkika mime. I'suᵽakajaoka ritaja ᵽemawa'ribajirã jiitakiji mime, ritaja õñuka, “Jiitaka yijare mibaarijayu”, mire ᵽo'imajare ãrĩrijarirũkika mime. Ritaja ᵽo'imaja jiyiᵽuᵽaka mire õñurã, tẽrĩritakiji mimamaka, maki aᵽika mire ᵽemawa'ribaji tẽrĩriki imabeyuka. Tuᵽarã, i'suᵽaka oyiaja miro'si simajiᵽarijarirũ,— ãᵽaraka nimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV7_13","096_7_13","REV","7","13","13","I'suᵽaka narãᵽaka be'erõ'õ, ĩ'rĩka ᵽakiakite ikuᵽaka yire ãrãᵽe: —¿Marã nime saya uᵽaka ima jariroaka boia jããtirã imarã? ¿No'okarã nime?— yire kẽrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV7_14","096_7_14","REV","7","14","14","Suᵽa kẽᵽakã'ã ikuᵽaka kire yiyi'raᵽe: —Õrĩbeyuka yi'i. Mi'i ᵽañaka õñuka je'e, yire samibojabe,— kire ñarãᵽe. I'suᵽaka kire ñaᵽakã'ã ikuᵽaka yire kibojaraᵽe: —Jimarĩ jũarũkijẽ'rãka seyamaka sareka aᵽerãte nare ba'iaja baamaka rakajeᵽããwa'ri nareyarijarika simako'omakaja Jesúre yi'ririja'ataberikarã nime. I'suᵽaka imarã imarĩ, ba'iaja baakoribeyurã nime Tuᵽarãte ĩamaka. Suᵽa imarĩ Oveja weiwa'yua uᵽaka imaki riweaᵽi nasaya uᵽaka ima jariroaka jũjetirã, jia boioyiaja jããtirã uᵽaka nime. ");
INSERT INTO tnc_vpl VALUES ("RV7_15","096_7_15","REV","7","15","15","I'suᵽaka simamaka ĩᵽire kiruᵽarikũmuarã ruᵽaraᵽaki wãjitãji kire jiyiᵽuᵽayeebaraka nime. Suᵽabatirã kiwi'iarã, ĩmi, ñamioka kiyaᵽaika uᵽakaja baarijayurã imarĩ, dakoa jũarũkimarĩrã nime, Tuᵽarãte nare ĩarĩrĩrijarirãñurã imarĩ. ");
INSERT INTO tnc_vpl VALUES ("RV7_16","096_7_16","REV","7","16","16","Suᵽabatirã kẽsirababeyurã, okoa ukurijitobeyurã, suᵽabatirã aiyaᵽekareka ijia jũarũkimarĩrã nimarãñu. ");
INSERT INTO tnc_vpl VALUES ("RV7_17","096_7_17","REV","7","17","17","I'suᵽaka nimaerã Tuᵽarã ruᵽarikũmuwãjitãji imaki imarĩ, jia oveja tuerimaji uᵽaka Oveja weiwa'yua uᵽaka imakite nare ĩarĩrĩrãñu kiro'si. Suᵽabatirã õñio okoa imarõ'õrã nare sasĩarĩ kiruᵽutawa'rirãñu. Suᵽa imarĩ “Aᵽekurioka ba'iaja jũarũkimarĩrã, i'suᵽakajaoka oriᵽe'arũkimarĩrã nimarũ”, ãᵽaraka jia Tuᵽarãte nare baarãñu,— ãrĩwa'ri yire kibojaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV8_1","096_8_1","REV","8","1","1","Torãjĩrã mae Oveja weiwa'yua uᵽaka imaki ĩ'ᵽotẽñarirakakuku ᵽaᵽera buᵽeka ᵽaᵽatãteka ima kiwieraᵽe. Sakiwieraᵽakarõ'õjĩte treinta minuto rõ'õjĩrã mabo'ikakurirõ'õ ña'kikã'ãja jaraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV8_2","096_8_2","REV","8","2","2","I'suᵽaka simaraᵽaka be'erõ'õ ĩ'ᵽotẽñarirakamarã ángelrãkare Tuᵽarã wãjitãji narĩkamaᵽakã'ã ñiaraᵽe. Suᵽabatirã ĩ'ᵽotẽñarirakao tromᵽeta Tuᵽarãte nare ĩjikarã nimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV8_3","096_8_3","REV","8","3","3","I'tojĩrã ate aᵽika ángel orokaka baaeka õñioka ᵽearũkia rikatirã etaraᵽaki. Tuᵽarãte jiyiᵽuᵽayeewa'ri joeĩjiritẽrĩa orokaka baaeka wãjitãji ᵽemaari keyarĩkaraᵽe. Torã kimaraᵽaka ᵽoto, rĩkimakaja õñioka ima ĩᵽi ruᵽarikũmuarã ruᵽaraᵽakite kire ĩjiraᵽe joeĩjiritẽrĩarã kijoeokaro'si. Tuᵽarãro'si sajoeĩjibaraka kirirãre kire jẽñeraᵽaka kiᵽõ'irã eyaraᵽaka ũmakakaka ĩ'rãtiji. ");
INSERT INTO tnc_vpl VALUES ("RV8_4","096_8_4","REV","8","4","4","Õñioka kijoeika ũmakajiijĩsia ᵽitiyika kire najẽñerijayua Tuᵽarã ᵽõ'irã eyaraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV8_5","096_8_5","REV","8","5","5","Torãjĩrã õñioka ᵽearũkia kirikaraᵽakarã Tuᵽarãte jiyiᵽuᵽayeebaraka joeĩjiritẽrĩakaka ᵽeka ya'tarika sarã kijããᵽorotaraᵽe. I'suᵽaka sabaatirã ika wejearitatorãja sakiwe'aña'taraᵽe. Suᵽa kibaaraᵽakarõ'õjĩte jimarĩa jãjia wĩᵽoa yaaraᵽaka. Jãjia jaitirã yoeᵽi aᵽea jã'mijiyeriokabayuraᵽe. Torãjĩte ka'ia iyiraᵽaka mae. ");
INSERT INTO tnc_vpl VALUES ("RV8_6","096_8_6","REV","8","6","6","Torãjĩrã mae, tromᵽeta ᵽuᵽuokaro'si sarikatikaja ĩ'ᵽotẽñarirakamarã ángelrãkare imaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV8_7","096_8_7","REV","8","7","7","Mamarĩtaka saᵽuᵽuraᵽakite ᵽuᵽuraᵽakaka, ĩ'rãtiji riwerukubaka okoa jiyikaᵽitiyika ᵽeka ya'tarika jũjiraᵽaka. I'suᵽaka sabaaraᵽaka be'erõ'õᵽi ka'ia wejeareka ima ñe'metãji rokajĩrã ru'arĩ ojibakarãja ooraᵽaka. I'suᵽakajaoka yaᵽua, taya õñia ñe'metãji rokajĩrã ooraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV8_8","096_8_8","REV","8","8","8","Kirokajĩte imaraᵽakite ᵽuᵽuraᵽaka ᵽoto ᵽusia rĩkamaka uᵽaka jũ'rẽtirã riaᵽakiakarã saña'raᵽe. Suᵽabatirã riaᵽakiaka ñe'metãji rokajĩrã sokoa riwearo'si jaraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV8_9","096_8_9","REV","8","9","9","I'suᵽaka simamaka riaᵽakiakareka imakoᵽeika ñe'metãji rokajĩrã jĩrĩᵽataraᵽaka. I'tojĩrã rõ'õjĩrãjaoka kũmuᵽakiaka sareka imaraᵽaka ña'miᵽataraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV8_10","096_8_10","REV","8","10","10","I'tojĩrã aᵽika ángel ᵽuᵽuraᵽaki ate. I'kire ᵽuᵽuraᵽakarõ'õjĩte, ĩmiᵽi tã'ᵽiᵽakiaka ᵽeka jũ'rẽika uᵽaka jũ'rẽña'rãᵽaka ñiaraᵽe. Riaka, suᵽabatirã okoa koᵽeaᵽi juruika nukuroyika imaoka ñe'metãji rokajĩrã ru'ajĩ'ari saña'raᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV8_11","096_8_11","REV","8","11","11","I'suᵽaka baaraᵽaki Jĩmia wãmeiki tã'ᵽire imaraᵽe. Ikiᵽi ãrĩwa'ri ñe'metãji rokajĩrã ru'ajĩ'ari jĩmia okoa jaraᵽaka. I'suᵽaka simamaka sukutirã rĩkimarãja ᵽo'imajare reyaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV8_12","096_8_12","REV","8","12","12","I'tojĩte kirokajĩkaki ángelte ᵽuᵽuraᵽe. Sakiᵽuᵽuraᵽaka ᵽoto aiyaka, ñamikakioka, ñe'metãji rokajĩrã sayaaboaika ruirĩkaraᵽaka. Rĩkamakaja tã'ᵽiaoka imaraᵽaka ñe'metãji rokajĩrã ririᵽatarijaraᵽaka. I'suᵽaka imawa'ri botarakakuri aiyajẽrã rõ'õjĩrã ĩ'rãrĩmi uᵽakaja aiyate neiñamita'raᵽe. Ñamikaki i'tojĩrãjaoka ñoaka ĩ'rãñami uᵽakaja neiñamita'ririjaraᵽaki. ");
INSERT INTO tnc_vpl VALUES ("RV8_13","096_8_13","REV","8","13","13","Toᵽi mae yu'awa'ri ĩaerã baakõrĩ awaka wiraᵽaka ñiaraᵽe. Iki mae jãjirokaᵽi ikuᵽaka ãrĩkoraᵽaki: —Aya, ba'itakaja ritatojo wejeareka imarãte jũaerã baayu. Maekarakamarã ángelrãka tromᵽeta ᵽuᵽubeyukajirã imarãte saᵽuᵽurãñu ᵽoto i'suᵽaka simarãñu,— kẽrĩkoraᵽaka ña'mitiraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV9_1","096_9_1","REV","9","1","1","Torãjĩrã aᵽika saᵽuᵽuraᵽaki. I'kire saᵽuᵽuraᵽakarõ'õjĩte tã'ᵽi uᵽaka ĩoika ña'rãᵽaka ate. I'ki imaraᵽaki koᵽea tiyibeyua wierũkia Tuᵽarã kire ĩjikaki. ");
INSERT INTO tnc_vpl VALUES ("RV9_2","096_9_2","REV","9","2","2","Suᵽa imarĩ, saᵽi mae koᵽea kiwieraᵽe. Sakiwieraᵽaka ᵽoto, ᵽeka jãjia jũ'rẽwa'ri ũmakaᵽuyu uᵽaka saᵽi ᵽoraᵽaka. I'sia ritatojo wejeᵽemarã koyimaka aiyate neiñamita'raᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV9_3","096_9_3","REV","9","3","3","I'suᵽakajaoka ũmaka watoᵽekaᵽi rĩkimakaja ñimia kãrĩᵽoraᵽaka no'ojariwa'ririmarĩa ritatojo wejeareka simaraᵽe. Ñimia imako'omakaja kũaᵽarãka uᵽaka tuteika Tuᵽarãte nare imarũjeraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV9_4","096_9_4","REV","9","4","4","Suᵽa imarĩ “Taya, yaᵽua, õterikia ᵽuri mija bitata'si”, ãrĩwa'ri Tuᵽarãte okajããeka simaraᵽe. “ ‘Tuᵽarãriki kime ĩ'ĩ’, ãñua wãmea nakũ'areka o'ojĩ'abeyurãte oyiaja ba'iaja mija baabe”, Tuᵽarãte ãrĩtikarã simaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV9_5","096_9_5","REV","9","5","5","“Ba'iaja ᵽo'imajare mija jũarũjebe”, Tuᵽarãte ãrĩkarã nimako'omakaja, “Ᵽo'imajare mija jããbe”, kẽrĩberikarã nimaraᵽe. Suᵽa imarĩ ĩ'rãᵽitarakamarã aiyarõ'õjĩrã ᵽo'imajare tutebaraka nare kimarũjeraᵽe. I'suᵽaka kijã'meraᵽakaᵽi ãrĩwa'ri nare satuteka kũaᵽarãka tuteika yi'aika uᵽaka nare sayi'amaka jimarĩa ba'iaja najũaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV9_6","096_9_6","REV","9","6","6","I'suᵽaka simarãka ᵽoto jimarĩa ᵽo'imajare reyariᵽakata'rikoᵽerãñu. I'sia yaᵽariᵽotojo reyawãrũbeyurã nimarãñu. ");
INSERT INTO tnc_vpl VALUES ("RV9_7","096_9_7","REV","9","7","8","Ñiaraᵽakareka ñimi uᵽaka imakoᵽeraᵽarã kawarurãka jĩñaokaro'si imatikarã uᵽakaja nimaraᵽe. Suᵽabatirã ᵽo'imaᵽema uᵽaka ᵽemakirã, orokaka baaeka bu'ya naruᵽuko'arã tuaekarã, suᵽabatirã rõmitiruᵽua uᵽaka ruᵽukirã nimaraᵽe. Noᵽia ᵽuri yaioᵽia uᵽaka ĩoika imaraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV9_9","096_9_9","REV","9","9","9","I'suᵽaka imaraᵽarã imarĩ ᵽeruakaka baaeka wa'itĩtia ĩoika jããirã nimaraᵽe. Nawiraᵽaka ᵽoto jimarĩ sokaarikoraᵽe, ka'iaᵽi tũrũrũkia yiewa'ᵽaraka rĩkimaka kawaru rĩñua okaayu uᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV9_10","096_9_10","REV","9","10","10","Ĩ'rãjaoka ñimia imariᵽotojo kũaᵽarãka uᵽaka ᵽĩkokirã imaraᵽarã. I'suᵽaka imaraᵽarã imarĩ ĩ'rãᵽitarakamarã aiyarõ'õjĩrã ᵽo'imajare tutebaraka nimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV9_11","096_9_11","REV","9","11","11","Suᵽabatirã niᵽamaki ángel mirãki imaroyikaki, koᵽea tiyibeyua ĩᵽamaki kimaraᵽe. Hebreo okaᵽi kiwãmea imaraᵽaka Abadón. Suᵽabatirã griego okaᵽi ᵽuri Aᵽolión wãmeiki kimaraᵽe. Riatarimaji ãrĩrika simaraᵽe i'suᵽaka kiwãmea imaraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV9_12","096_9_12","REV","9","12","12","I'suᵽaka simaraᵽe mamarĩtaka ba'iaja jũaũ'murũkia. Mija ĩabe, i'sia be'erõ'õᵽi ĩ'ᵽakurikaka jariwa'riñujuraᵽaka ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("RV9_13","096_9_13","REV","9","13","13","I'suᵽaka simaraᵽaka be'erõ'õ aᵽika tromᵽeta ᵽuᵽuraᵽaki. Kiᵽuᵽuraᵽakarõ'õjĩte Tuᵽarã wãjitãji kire joeĩjiritẽrĩa orokaka baaeka botarakaba'i wakaika imaraᵽaka watoᵽekaᵽi sajaikoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV9_14","096_9_14","REV","9","14","14","Suᵽabatirã torã tromᵽeta ᵽuᵽuraᵽaki ángelte ikuᵽaka sãrãᵽaka ña'mitiraᵽe: —Riaᵽakiaka Éufrates wãmeiriarijerã botarakamarã ángelrãka ji'aᵽairãte mikototabe,— sãᵽakã'ã ña'mitiraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV9_15","096_9_15","REV","9","15","15","I'suᵽaka sãrĩkoraᵽaka ᵽoto botarakamarã ángelrãkate kikototaraᵽe. Ritatojo wejeareka imarã ᵽo'imajare ñe'metãji rokajĩrã najããᵽuaokaro'si, “I'siwejejẽ'rãreka, i'ki aiyareka, i'sirĩmireka, i'tojĩrã aiyajẽraka imarãka ᵽoto nare mija jããbe”, ãrĩwa'ri kijã'metikarã nimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV9_16","096_9_16","REV","9","16","16","Nare kikototaraᵽaka be'erõ'õ rĩkimarãja surararãka kawaru ᵽemarã tuyumaka ñiaraᵽe. I'suᵽaka nimaraᵽaka ᵽoto, “Doscientos millones rakamarã nime”, sãrĩkoraᵽaka ña'mitiraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV9_17","096_9_17","REV","9","17","17","Suᵽa imarĩ makãrãrũñuroka uᵽakaᵽi naro'si oyiaja ᵽeruakaka baaeka jããirã nimamaka ñiaraᵽe. Jũ'aᵽañaka ya'tarika, suᵽabatirã neiᵽañakarãja jĩ'mia, suᵽabatirã aᵽea azufre uᵽaka jũ'siᵽoa simaraᵽe najĩrĩriko'a. I'suᵽakajaoka kawaru imariᵽotojo yaia león ruᵽuko'a uᵽaka ruᵽuko'akirã nimaraᵽe. Narijokoᵽeaᵽi ᵽeka, ũmakaka ᵽoraᵽaka, suᵽabatirã dajaka jĩsia azufre saᵽijioka ᵽoraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV9_18","096_9_18","REV","9","18","18","I'siarakaba'i kawaru rijokoᵽeareka ᵽoraᵽakaᵽi ãrĩwa'ri, ritatojo wejeareka imarã ᵽo'imajare ñe'metãji rokajĩrã ᵽuajiyeraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV9_19","096_9_19","REV","9","19","19","Suᵽabatirã ãñaruᵽuko'a uᵽaka ᵽĩkoika imatiirã, narijokoᵽeaᵽi, naᵽĩkorõ'õᵽioka ᵽo'imajare jããrika õñurã nimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV9_20","096_9_20","REV","9","20","20","Rĩkimarãja ᵽo'imajare najããraᵽaka ĩariᵽotojo, ba'iaja nabaarijayua ja'ataberaᵽarã aᵽerimarã ruᵽu. Suᵽabatirãoka Satanárika ima jiyiᵽuᵽayeerimaja imarĩ, waᵽuju imaja jẽrãka oro, ᵽlata, bronce, ãtakaka, yaᵽuakakaoka baabaraka nimaroyiraᵽe jiyiᵽuᵽaka noñaokaro'si. Nabaaraᵽaka yoibeyua, turibeyua, ã'mitiribeyua simako'omakaja jiyiᵽuᵽaka sõrĩrijaᵽaraka nimarijaraᵽe ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("RV9_21","096_9_21","REV","9","21","21","Suᵽabatirã ᵽo'imajare jããrika, ye'oaᵽi aᵽerãte nabitarijayua, rõmitika nawã'imañua, nakaree'erijayuaoka ja'atabeyurã nimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV10_1","096_10_1","REV","10","1","2","I'suᵽaka simamaka ñiaraᵽaka be'erõ'õ, ĩ'rĩka ángel jãjika ũmakakaᵽi butekaki, mabo'ikakuriᵽi ruira'amaka ñiaraᵽe. Mae mia, kiruᵽuko'a bo'i ne'eᵽurea imaraᵽaka. Kiᵽema aiyaka uᵽaka yaarĩkaiki imatirã kiñika ᵽeka jũ'rẽika uᵽaka kimaraᵽe. Ikijioka ᵽaᵽera buᵽekajĩka wietikaja rikaraᵽaki. Kiũ'ᵽua ritaᵽẽ'rõto riaᵽakiakarã rĩ'kariᵽotojo, aᵽeᵽẽ'rõtoᵽi ᵽuri bo'irã kirĩ'karaᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV10_3","096_10_3","REV","10","3","3","Suᵽabatirã yaia león akaika uᵽaka jãjirokaᵽi kiakaseremaka, ĩ'ᵽotẽñarirakakuri wĩᵽoa kire yi'rikoraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV10_4","096_10_4","REV","10","4","4","Wĩᵽoa jaikoraᵽaka uᵽaka yo'oerã baamaka, mabo'ikakurirõ'õᵽi ikuᵽaka yire sãrĩkoraᵽe: —Wĩᵽoa jairaᵽaka aᵽerãte miboja'si. Suᵽabatirã samio'oa'si,— yire sãrĩkoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV10_5","096_10_5","REV","10","5","7","Torãjĩrã ate ĩ'rãᵽẽ'rõto kiũ'ᵽua riaᵽakiakarã rĩkamarĩtirã aᵽeᵽẽ'rõto ka'iarã rĩkamañukate ritaᵽẽ'rõto kiᵽitaka ĩmirã mi'matatirã, ikuᵽaka kẽrãᵽe: —Tuᵽarã õñia imajiᵽaki wejeᵽema, ka'ia, riaᵽakiaka suᵽabatirã ritaja sareka ima ᵽo'ijiaekaki. I'suᵽaka simamaka, rita sime kĩaika wãjitãji ikuᵽaka ñañua: Koᵽakaja i'tojĩrãja sime mae, dakoa mata'arũkia imabeyua aᵽea. Ᵽiyika ángelte ᵽuᵽurãka ᵽoto “Ikuᵽaka yibaarãñu”, kẽrĩka uᵽakaja Tuᵽarãte baarãñu. Bikija ᵽuri ritaja ᵽo'imajare kibojaberika ruᵽu. I'suᵽaka simako'omakaja kiro'si bojaĩjirimajare takaja sakibojaeka. I'suᵽaka simamaka nare kibojaeka uᵽakaja simarãñu ᵽiyikate saᵽuᵽurãka ᵽoto,— kẽrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV10_8","096_10_8","REV","10","8","8","Toᵽi ate ĩmiᵽi ikuᵽaka yire sãrĩkoraᵽe: —Ángel, ĩ'rãᵽẽ'rõto kiũ'ᵽua riaᵽakiakarã rĩkamarĩtirã, aᵽeᵽẽ'rõto bo'irã rĩkamañuka ᵽõ'irã me'ᵽe. Kiᵽõ'irã a'ritirã ᵽaᵽera buᵽeka kirikaika me'ebe,— yire sãrĩkoraᵽaka ña'mitiraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV10_9","096_10_9","REV","10","9","9","I'suᵽaka sãrĩkoraᵽaka ã'mitiritirã kiᵽõ'irã ya'raᵽe. Kiᵽõ'irã eyatirã ᵽaᵽera buᵽeka kireka yijẽñeraᵽe. Toᵽi ikuᵽaka yire kẽrãᵽe: —Ãja'a, samiba'abe. Samiba'arãka ᵽoto mumioko uᵽaka mirijokoᵽearã sajariko'omakaja mise'kurarirãñu,— yire kẽrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV10_10","096_10_10","REV","10","10","10","I'suᵽaka kẽᵽakã'ã, se'etirã, yiba'araᵽe. Sayiba'araᵽaka be'erõ'õ mumiokoa mukuika uᵽaka yirijokoᵽearã sajaraᵽe. I'suᵽaka simako'omakaja sayiba'araᵽaka be'erõ'õ yiñe'meã yire yi'araᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV10_11","096_10_11","REV","10","11","11","Toᵽi ikuᵽaka yire kẽrãᵽe ate: —Ᵽo'imatata imauᵽatiji, naka'iareka noka jaibaraka imarã uᵽatiro'si, suᵽabatirã ritaja ĩᵽarimarãre, “Ikuᵽaka mijare simaerã baayu”, Tuᵽarãro'si bojaĩjirika ima mire ate,— ángelte yire ãrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV11_1","096_11_1","REV","11","1","1","I'sia be'erõ'õ jẽrãbaarũkia ángelte yire ĩjiraᵽe. Sĩjitirã ikuᵽaka Tuᵽarãte ãñua ángelte yire ãrãᵽe: —Ikaᵽi yire jiyiᵽuᵽaka õrĩriwi'ia mijẽrãbaaᵽe, suᵽabatirãoka sareka joeĩjiritẽrĩa mijẽrãbaabe. I'suᵽakajaoka yiwi'iarã dikarakamarã yire jiyiᵽuᵽayeerimajare imarika mijoabe. ");
INSERT INTO tnc_vpl VALUES ("RV11_2","096_11_2","REV","11","2","2","Yiwi'iᵽẽte ĩ'rãkõ'rĩmato ᵽuri mijẽrãbaa'si, yire yi'ribeyurãte imarũkirõ'õ simarũ ãrĩwa'ri nare ñijikarõ'õ simamaka. Ĩ'rã imarã maekarakakuri wejejẽ'rãka aᵽejẽ'rã ñe'metãjirã Jerusalénwejeakarãre ba'iaja baataᵽarijarirãñurã. ");
INSERT INTO tnc_vpl VALUES ("RV11_3","096_11_3","REV","11","3","3","Suᵽa simako'omakaja ĩ'ᵽarã yire jaiwaᵽu'ataĩjirimajare yiᵽũatarãñu. Jariromajaka kĩkeka najããmaka ĩatirã “Ba'iaja yija baaikareka yija ᵽuᵽaᵽe'riri imakoᵽeyu”, ᵽo'imajare ãrĩrũ ãrĩwa'ri. Maekarakakuri wejejẽ'rãka aᵽejẽ'rã ñe'metãjirõ'õjĩrã nare ñorĩrũjeika ᵽo'imajare bojabaraka imarãñurã,— Tuᵽarãro'si ángelte yire ãrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV11_4","096_11_4","REV","11","4","4","Ika ĩ'ᵽaba'i uᵽaka imarã nime Tuᵽarãte jaiwaᵽu'ataĩjirimaja, ĩakõrĩ je'e: Wejeĩᵽamaki Tuᵽarã wãjitãji olivo ĩ'ᵽajũki, suᵽabatirã i'siarakabijioka ᵽeritẽrĩa yaaboaika uᵽaka nime. ");
INSERT INTO tnc_vpl VALUES ("RV11_5","096_11_5","REV","11","5","5","Suᵽa imarĩ namajamarãre ba'iaja nare baakoᵽemaka, narijokoᵽeaᵽi jũ'rẽᵽoyua. I'suᵽaka ima simamaka saᵽi nare najoeriataᵽatayu. ");
INSERT INTO tnc_vpl VALUES ("RV11_6","096_11_6","REV","11","6","6","Suᵽabatirã okoa najarirũjebeᵽakã'ã, jaribesarãka. Suᵽa imarĩ “Tuᵽarãro'si jaibaraka yija imarãka wejejẽ'rãrõ'õjĩrã okoa jaribesarãka”, nañu. I'suᵽakajaoka okoa riwearo'si jarirãka, suᵽabatirã ika wejeareka imarãteoka ba'iaja najũaerã nayaᵽaika uᵽakaja baarimaja nime. ");
INSERT INTO tnc_vpl VALUES ("RV11_7","096_11_7","REV","11","7","7","Torãjĩrã, Tuᵽarãte jaiwaᵽu'ataĩjibaraka nima ᵽuyarirãka ᵽoto werikaᵽakiaki koᵽea tiyibeyurõ'okakite naka jĩrĩ mirĩeyarañu. I'suᵽaka baawa'ri, nare kijããrãñu. ");
INSERT INTO tnc_vpl VALUES ("RV11_8","096_11_8","REV","11","8","8","I'suᵽaka nare baatirã ma'a ñe'metãjirã nare kiᵽããjiyerãñu, wejeareka bikija yaᵽua tetaekarã niᵽamakire naᵽatakĩaekarõ'õrã. Torã imatiyaika wejeareka imarã ba'iaja baairã imarĩ, Sodoma, suᵽabatirã Egiᵽtoka'iakarãre ba'iaja baaroyika uᵽaka baairã nime. ");
INSERT INTO tnc_vpl VALUES ("RV11_9","096_11_9","REV","11","9","9","Maekarakarĩmi imaeka aᵽerĩmi wãjitãji aiyarõ'õjĩrã namajaka torã imarãka. Torãjĩrã ritaja ᵽo'imatatarãte namajaka ĩarãñu. Namajaka ĩariᵽotojo nare ã'mijĩaekarã imarĩ, nare nayayerũjebesarãñu. ");
INSERT INTO tnc_vpl VALUES ("RV11_10","096_11_10","REV","11","10","10","Torãjĩrã mae, jaiwaᵽu'atarimajare reyamaka, rĩkimarãja ᵽo'imajare jĩjimaka jarirãñu. I'suᵽaka imawa'ri “Maekaka koᵽakaja ĩ'ᵽarã ba'iaja mare baata'arimajare riyu”, ãᵽaraka rẽrĩtirã jĩjimakaᵽi ba'irĩjia ᵽibabu'abaraka nimarãñu. ");
INSERT INTO tnc_vpl VALUES ("RV11_11","096_11_11","REV","11","11","11","Suᵽa nimaraᵽaka ᵽoto maekarakarĩmi be'erõ'õ aᵽerĩmi ĩmi ñe'metãjirõ'õjĩrã simaraᵽaka ᵽoto, õñia Tuᵽarãte nare jarirũjeraᵽe ate. I'suᵽaka nare kibaamaka, nami'mirĩkarãka ĩatirã, jimarĩa ᵽo'imajare nare kĩkiraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV11_12","096_11_12","REV","11","12","12","Toᵽiji mabo'ikakuriᵽi, —Õ'õrã mija i'tabe,— jãjirokaᵽi nare sãrĩkoraᵽe. Sã'mitiritirã, nare ã'mijĩarimaja ñakoarekaja, oko ũmaka watoᵽekaᵽi na'raᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV11_13","096_11_13","REV","11","13","13","Mabo'ikakurirã na'raᵽakarõ'õjĩte jimarĩ jãjia ka'ia iyiraᵽaka. I'suᵽaka sabaamaka rĩkimaitakaja wi'ia imaraᵽakakaka kũᵽajĩ sakuyuᵽateraᵽe. I'suᵽaka baawa'ri siete mil rakamarã ᵽo'imajare sariataraᵽe. Õñia jariwa'raᵽarã ᵽuri sĩatirã ᵽuᵽatawa'ri “Tẽrĩritakaji mabo'ikakurirã imakite ime”, narãᵽe Tuᵽarãreka. ");
INSERT INTO tnc_vpl VALUES ("RV11_14","096_11_14","REV","11","14","14","Mamarĩrokajĩtekaka ba'iaja jũarũkia ima koᵽakaja yibojaweayu. Sabe'erõ'õjĩte no'ojĩrãmarĩaja ba'iaja najũarika jariwa'raᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV11_15","096_11_15","REV","11","15","15","Ka'ia jimarĩ jãjia iyiraᵽaka be'erõ'õ, ᵽiyika ángelte tromᵽeta ᵽuᵽuraᵽe. Sakiᵽuᵽuraᵽaka ᵽoto mabo'ikakurirõ'õᵽi rĩkimarãja jãjirokaᵽi ikuᵽaka narĩkoraᵽe: —Ritatojo wejeareka imarãte najã'meika koᵽakaja Tuᵽarãte tiyetayu mae. Maiᵽamaki Tuᵽarã, suᵽabatirã Cristoᵽitiyika, ᵽo'imaja ĩᵽamarã najayu. Suᵽa imarĩ ritatojo wejeareka imarãte jã'mejiᵽarimaji kimarãñu,— narĩkoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV11_16","096_11_16","REV","11","16","17","I'suᵽaka simekã'ãja veinticuatro rakamarã ᵽakiarimarã Tuᵽarã wãjitãji ĩᵽarimarãre ruᵽarũkiareka naruᵽaraᵽe. Saᵽi mi'mitirã ka'iareka namo'iᵽãñawa'raᵽe, Tuᵽarãte jiyiᵽuᵽayeewa'ri. Toᵽi ikuᵽaka narãᵽe: —Yija ĩᵽamaki Tuᵽarã, ritaja ima ᵽemawa'ribaji imaki mime. Suᵽa imarĩ bikija imara'aekaki imariᵽotojo, maekakaoka imaki mime. Jia mibaayu yija ĩᵽamaki, tẽrĩriki imarĩ, maekaka ritatojo wejeareka imarã ᵽo'imajare jã'merimaji mijayu. ");
INSERT INTO tnc_vpl VALUES ("RV11_18","096_11_18","REV","11","18","18","Mia je'e, nimauᵽatiji ᵽo'imatata mire yi'ribeyurã jimarĩa mire naᵽe'yorijarika. I'suᵽaka ĩatirã, nare miboebaritiyaeka. Suᵽa imarĩ reyaeka mirãrã ba'iaja nabaaeka ᵽareareka nare ba'iaja mibaarũkirĩmi koᵽakaja seyayu mae. Simako'omakaja mire yi'yurãte ikuᵽaka mibaarãñu: Miro'si bojawaᵽu'atarimaja, ĩᵽarimarã, suᵽabatirã imatiyabeyurãoka, mire yi'riwa'ri jia nabaaeka mirãka simamaka sawaᵽa jia nare mibaarãñu mae. Ika wejeareka ᵽo'imajare riatarijayurã ᵽuri, nare miriatarãñurĩmi seyayu mae,— narãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV11_19","096_11_19","REV","11","19","19","I'sia be'erõ'õ mabo'ikakurirã Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'ia wieka ñiaraᵽe. Satõsiarã imatiyaikoto imaraᵽaka. I'sikoto tõsiarã “Ikuᵽaka yire yi'yurãro'si yibaarãñu”, ãñua o'oeka imaraᵽaka. Sañiaraᵽaka ᵽoto ikuᵽarõ'õᵽiji jãjia wĩᵽoa ᵽaaraᵽakarõ'õjĩte ka'iaoka iyiraᵽaka. Suᵽabatirã okojiyia werikitaka jũjiraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV12_1","096_12_1","REV","12","1","2","Sabe'erõ'õ mabo'ikakurirã imatiyaika ᵽemakotowiᵽakã'ã ñiaraᵽe. Mia, aiyate yaaika uᵽaka saya jããekako koimaraᵽe. Ñamikakirã rĩkamañukoreka ĩ'ᵽoũ'ᵽuarãe'earirakamaki tã'ᵽia kobu'yareka imaraᵽaka. Yataarikako imawa'ri sarikarika ᵽakataᵽaraka ba'iaja kojũaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV12_3","096_12_3","REV","12","3","3","Be'erõ'õjĩte ate ñiaraᵽe: Kowã'tarã kajuyaiᵽakiaka uᵽaka ĩoika jũ'aᵽakiaka, ĩ'ᵽotẽñarirakao ĩᵽarimarã bu'yakaka tuaeka ruᵽuko'aika simaraᵽe. Suᵽabatirãoka ĩ'ᵽaᵽitarakabi sawaka imaraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV12_4","096_12_4","REV","12","4","4","Tã'ᵽia ñe'metãji rokajĩrã kiᵽĩkoaᵽi kiᵽaña'ruiraᵽe. Suᵽabatirã rõmo wã'tarã keyarĩkaraᵽe, komakarãka ᵽo'ijiᵽakã'ã ba'aokaro'si. ");
INSERT INTO tnc_vpl VALUES ("RV12_5","096_12_5","REV","12","5","5","I'suᵽaka kimekã'ãja ritaja ᵽo'imaja ĩᵽamaki imarũkikate korikaraᵽe. Tuᵽarãte ᵽũataekaki imarĩ, jia jã'mewãrũrũkika kimaraᵽe. Kajuyaiᵽakiaka uᵽaka ĩoika kire ba'ariyaᵽamaka kire korikaraᵽaka be'erõ'õ Tuᵽarãte ruᵽarõ'õrã kire kija'aᵽearaᵽe, kika jã'merimaji kimaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("RV12_6","096_12_6","REV","12","6","6","I'suᵽaka kibaaraᵽaka ᵽotojo ᵽo'imajamatorã kiᵽako mirãkote ru'raᵽe. “Õ'õrã jia kore ñiarĩrĩrãñu”, Tuᵽarãte ãrĩtikarõ'õrã ko'raᵽe. Torã koimaraᵽaka ᵽoto maekarakakuri wejejẽ'rã aᵽejẽ'rã ñe'metãjirõ'õjĩrã kore ĩarĩᵽaraka Tuᵽarãte imaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV12_7","096_12_7","REV","12","7","7","I'suᵽaka kore kibaaraᵽaka be'erõ'õ mabo'ikakurirõ'õrã ᵽitã'muareka imarãte ñiaraᵽe. Miguelrirã ángelrãka, kajuyaiᵽakiaka uᵽaka ĩoikirirãka najĩrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV12_8","096_12_8","REV","12","8","8","I'suᵽaka simako'omakaja Miguelrãkare natẽrĩwãrũberaᵽe. Suᵽa imarĩ mabo'ikakuri Tuᵽarãte imarõ'õrã imarũkimarĩrã najaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV12_9","096_12_9","REV","12","9","9","I'suᵽaka nare baatirã kajuyaiᵽakiaka uᵽaka ĩoikire kirirãᵽitiyika Tuᵽarãte ᵽoataraᵽe ika ka'iarã takaja nimaokaro'si. Tuᵽarãte ᵽoataraᵽakiji kime Satanás wãmeiki. Ikijioka imaki bikija ãñakarã ña'rĩjãiroyikaki. Suᵽabatirã ritatojo wejeareka imarãte ᵽakirimaji kime. I'suᵽakajaoka Diablo wãmeika kime ba'iaja jaita'arimaji ãrĩrirokaᵽi. ");
INSERT INTO tnc_vpl VALUES ("RV12_10","096_12_10","REV","12","10","10","Torãjĩrã mae jãjirokaᵽi ikuᵽaka sãrĩkoraᵽe: —Koᵽakaja Tuᵽarãte yi'ririjaᵽaraka imarã ᵽo'imajare tããrũkirĩmi seyayu. Suᵽabatirã ritaja ima tẽrĩwa'ribaji imaki imarĩ, ritaja wejeareka ᵽo'imajare kijã'meũ'muyu. Suᵽabatirã “Yiro'si ritaja wejeareka imarãte mijã'mebe”, Tuᵽarãte kire ãñua simamaka, nare jã'merimaji Cristore ime kiro'si. I'suᵽaka kime Tuᵽarã, Satanáre ᵽoataekaki imarĩ. Kiᵽoataekaki imaki Jesúre yi'yurãte ba'iaja baata'arimaji. Ĩmi, ñami ᵽariji Tuᵽarãte ĩaika wãjitãji muᵽaka Cristore yi'yurãte jaita'rubaraka, “Ba'irã nime”, Tuᵽarãte ãrĩrijarikoᵽeiki. ");
INSERT INTO tnc_vpl VALUES ("RV12_11","096_12_11","REV","12","11","11","I'suᵽaka nare kijaiᵽakiko'omakaja, Oveja weiwa'yua uᵽaka imakite reyaeka riweaᵽi ba'iaja nabaarijayua kijũjemaka, Satanáre tẽrĩkarã majeyomarã. “ ‘Jesúrika bojariroka mawãrõmaka õrĩwãrũbeyurãte mare jããrãñu je'e’, marĩko'omakaja okajãjiaᵽi rakajebekaja maimaye'e. Suᵽa imarĩ samabojarija'ata'si”, narĩᵽuᵽajoaeka. I'suᵽaka imawa'ri ba'ikate natẽrĩka. ");
INSERT INTO tnc_vpl VALUES ("RV12_12","096_12_12","REV","12","12","12","Satanáre õ'õrã imawãrũbeᵽakã'ã, jia jĩjimaka maime mae. Mija ka'iareka imarã ᵽuri, suᵽabatirã waᵽuruᵽi riaᵽakiakareka imarijayurãteoka ba'iaja sabaarãñu. I'suᵽaka mijaro'si simarãñu mija ᵽõ'irã Satanáre ruiwa'yua simamaka. “Ñojimarĩji Tuᵽarãte wẽkomaka yire baarũkia jariwa'yua”, ãrĩwa'ri jimarĩa kiboebayu mae. Suᵽa imarĩ ba'iaja mijare jũarũjebaraka kimarijayu,— sãrĩkoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV12_13","096_12_13","REV","12","13","13","“Mabo'ikakurireka ñimaᵽi koᵽakaja ka'iarã Tuᵽarãte yire ᵽoatayu”, ãrĩwa'ri makarããraᵽako mirãko rõmore sarĩrãᵽe kajuyaiᵽakiaka uᵽaka ĩoika. ");
INSERT INTO tnc_vpl VALUES ("RV12_14","096_12_14","REV","12","14","14","Kore kirĩrĩko'omakaja awaᵽakikajea ĩ'ᵽato jo'barito Tuᵽarãte kore ĩjiraᵽe kowiyaokaro'si. Suᵽa imarĩ ᵽo'imajamatorã eyaerã kajuyaiᵽakiaka uᵽaka ĩoika kowiritaᵽawa'raᵽe. Torã maekarakakuri wejejẽ'rãka aᵽejẽ'rã ñe'metãjirã ba'arika kore ji'abaraka Tuᵽarãte kore ĩarĩrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV12_15","096_12_15","REV","12","15","15","Koru'ᵽakã'ã ĩatirã, kore jããrika kiri'kakoᵽeraᵽe. Suᵽa imarĩ kirijokoᵽeaᵽi rĩkimakaja okoa kiᵽoataraᵽe kore ña'metarika yaᵽakoᵽewa'ri. ");
INSERT INTO tnc_vpl VALUES ("RV12_16","096_12_16","REV","12","16","16","I'suᵽaka kibaako'omakaja Tuᵽarãte kore jeyobaamaka, ka'ia ru'ritaraᵽarõ'õrã okoa kiᵽoatakoᵽeraᵽaka ririwa'raᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV12_17","096_12_17","REV","12","17","17","I'suᵽaka simamaka ĩatirã, jimarĩa rõmore kiboebaraᵽe. Kore jããwãrũberiwa'ri koriᵽarãmerãka jĩrĩrĩ ke'raᵽe. Ĩ'rã nimaraᵽe, Tuᵽarãte jã'meika yi'yurã, suᵽabatirã ritaja Jesucristore nare bojaekakaka ja'atabeyurã. ");
INSERT INTO tnc_vpl VALUES ("RV12_18","096_12_18","REV","12","18","18","Toᵽi mae riaᵽakirijerã kajuyaiᵽakiaka uᵽaka ĩoikite tuirĩkaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV13_1","096_13_1","REV","13","1","2","I'sia be'erõ'õ ĩ'rĩka werikaᵽakiaki maikoribeyukate riaᵽakiakaᵽi marĩra'araᵽe. Ĩ'ᵽotẽñarirakao ruᵽuko'a, suᵽabatirã ĩ'ᵽaᵽitarakabi bu'ya tuaeka wakaiki kimaraᵽe. Suᵽabatirã jiamarĩa Tuᵽarãreka jaika kiruᵽuko'a uᵽatikaja o'ojĩ'aeka kimaraᵽe. Yaiuᵽaka ĩoiki imariᵽotojo oso wãmeika uᵽaka jo'baka ũ'ᵽuiki kimaraᵽe. Suᵽabatirã león rijokoᵽe uᵽaka simaraᵽe kirijokoᵽea. Kajuyaiᵽakiaka uᵽaka ĩoiki kiõñua kire ja'ataekaki kimaraᵽe. Suᵽa imarĩ, “Yiruᵽarikũmuarã ĩᵽi uᵽaka miruᵽabe. Tẽrĩtaka ñima uᵽaka mire ñimarũjeyu. Suᵽabatirã ritaja wejeareka imarã ᵽo'imajare yijã'meika uᵽaka nare mijã'mebe”, kajuyaiᵽakiaka uᵽaka ĩoikite kire ãrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV13_3","096_13_3","REV","13","3","3","Ĩ'rõ kiruᵽuko'arã matãrĩberijĩkarõ'õjĩrã jo'baka kãmimirãka yayaeka sareka imaraᵽaka. I'suᵽaka imariᵽotojo “¿Dako baaerã kireyatiyaberika jee?”, ãᵽaraka rĩkimarãja ritatojo wejeareka imarã kire yi'ririjayurãte imaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV13_4","096_13_4","REV","13","4","4","Suᵽabatirãoka, kajuyaiᵽakiaka uᵽaka ĩoikite jiyiᵽuᵽayeebaraka ᵽo'imajare imaraᵽe, werikaᵽakiakite kijã'merũkia kija'atamaka. I'suᵽakajaoka werikaᵽakiakite jiyiᵽuᵽayeebaraka ikuᵽaka narãᵽe: —Maki aᵽika ĩ'ĩ rõ'õjĩrã imaki imabeyuka, suᵽa imarĩ marã ᵽitã'muareka kire tẽrĩwãrũberijĩrã,— ãᵽaraka nimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV13_5","096_13_5","REV","13","5","6","“Yi'i ĩ'rĩkaja imaki tẽrĩwa'ribaji imatiyaiki. Maki aᵽika ñima uᵽaka imabeyuka”, werikaᵽakiakite ãrãᵽe. I'suᵽaka ãᵽaraka, “Tuᵽarãte ima uᵽaka imaki yi'i”, ba'iaja ãᵽaraka kimaraᵽe, “I'suᵽaka jaibekaja mimabe”, Tuᵽarãte kire ãrĩbeᵽakã'ã. Suᵽa imarĩ maekarakakuri wejejẽ'rãka aᵽejẽ'rã ñe'metãjirõ'õjĩrã “Tuᵽarã, kika imarã, kimarõ'õ oka waᵽamarĩa ima”, ãᵽaraka ba'iaja ᵽo'imajare jairuᵽutabaraka kimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV13_7","096_13_7","REV","13","7","7","I'suᵽakajaoka Tuᵽarãte ã'mitiriᵽẽairãte tẽrãᵽaki kimaraᵽe. Suᵽabatirã ritatojo wejeareka imabayurãte jã'merimaji kijaraᵽe, “Jẽno'o, ba'iaja nare mibaa'si”, Tuᵽarãte kire ãrĩbeyukaji simamaka ruᵽu. ");
INSERT INTO tnc_vpl VALUES ("RV13_8","096_13_8","REV","13","8","8","Ritatojo wejeareka imaraᵽarã ima uᵽatiᵽañakaja kire jiyiᵽuᵽayeeirã oyiaja jaraᵽarã. Oveja weiwa'yua uᵽaka imaki, najããekakite rikaraᵽaᵽũñurã nawãmea o'oberikarã nimaraᵽe. Ika wejea Tuᵽarãte ᵽo'ijiaerã baaeka ruᵽubajirã “Ĩrã nimarãñu yire yi'riwa'ri õñia imajiᵽarũkirã”, ãrĩwa'ri nawãmea kiᵽaᵽera ᵽũñurã Jesúre o'otikarã nime. ");
INSERT INTO tnc_vpl VALUES ("RV13_9","096_13_9","REV","13","9","9","Tuᵽarãte bojaika mija õrĩwaᵽu'atariyaᵽaye'e jia samija ã'mitiᵽe: ");
INSERT INTO tnc_vpl VALUES ("RV13_10","096_13_10","REV","13","10","10","“Yirirã imawa'ri Cristore na'mitiriᵽẽamaka wẽkomaka imariwi'iarã ĩ'rãrimarãre ne'ewa'rirãñu”, Tuᵽarãte ãñua uᵽakaja naro'si simarãñu. I'suᵽakajaoka “Aᵽerimarã najããrũkirã nime”, kẽñu uᵽakaja naro'si simarãñu. Suᵽa simamaka yirirã imarĩ, i'suᵽaka jũariᵽotojo, rakajeᵽããeka mija imabe. Suᵽabatirã, yire mija yi'yua ja'atabekaja mija imabe. ");
INSERT INTO tnc_vpl VALUES ("RV13_11","096_13_11","REV","13","11","11","I'sia be'erõ'õ aᵽika weriki waᵽuju ko'torõ'õᵽiji ka'iaᵽi kiwararĩkamaka ñiaraᵽe. Ĩ'ᵽabi waka yabirĩjaka oveja weiwa'yua waka uᵽaka wakaiki imariᵽotojo, kajuyaiᵽakiaka jairaᵽaka uᵽaka kijairaᵽe kiro'si. ");
INSERT INTO tnc_vpl VALUES ("RV13_12","096_13_12","REV","13","12","12","Mamarĩkaki werikaᵽakiaka kãmimirãka yayaekakite jã'meraᵽaka uᵽakaja kibaaraᵽe. Suᵽa imarĩ jiyiᵽuᵽaka ritaja ᵽo'imajare kire yi'yaokaro'si kibe'erõ'õjĩ etaraᵽakite kiro'si ba'iraberaᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV13_13","096_13_13","REV","13","13","13","I'suᵽaka mamarĩkakiro'si ba'irabewa'ri maikoribeyua uᵽaka kibaaroyiraᵽe. Ã'mitirikõrĩ je'e, ikuᵽaka ᵽariji kibaaroyiraᵽe: Ᵽo'imajare ĩaika wãjitãji ᵽeka jũ'rẽika ĩmiᵽi kiña'aroyiraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV13_14","096_13_14","REV","13","14","14","I'suᵽaka mamarĩkakite jeyobaairokaᵽi ba'irabewa'ri ritatojo wejeareka imarã ᵽo'imajare kiᵽakiraᵽe. I'suᵽaka nare kiᵽakimaka, “Tuᵽarã uᵽakaja imaki kime”, mamarĩkakireka ãrĩᵽuᵽajoairã najaraᵽe. Mamarĩkaki matãrĩberijĩka uᵽaka kãmia yayaeka mirãki jẽrãka ᵽo'imajare kibaaᵽo'ijiarũjeraᵽe. I'suᵽaka kibaaraᵽe “Ba'itakaja ᵽo'imajare ᵽakibekaja mimabe”, Tuᵽarãte kire ãrĩbeᵽakã'ã. ");
INSERT INTO tnc_vpl VALUES ("RV13_15","096_13_15","REV","13","15","15","I'suᵽaka Tuᵽarãte kire ãrĩberaᵽaka simamaka, mamarĩkaki jẽrãka kiyiatarũjeraᵽe. Ᵽo'imaja uᵽaka jaika sakijarirũjeraᵽe. I'suᵽaka imawa'ri, “Yire jiyiᵽuᵽaka õrĩbeyurã, jããrũkirã oyiaja imarãñurã”, ãrĩwa'ri sajairaᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV13_16","096_13_16","REV","13","16","16","Toᵽi imaraᵽarã uᵽatireje mamarĩkaki wãmea kio'ojĩ'arũjeraᵽe. Ĩ'rãrimarã naᵽitaka ritaᵽẽ'rõtorã, aᵽerimarã nakũ'arã kiwãmea o'ojĩ'aekarã nimaraᵽe. Imatiyarimaja, imatiyabeyurãoka, rĩkimakaja niñerũ rikairã, wayuoka baairã, jia naᵽuᵽayariji imarãteoka, aᵽerãte naᵽoyarã uᵽakaja ba'irabeĩjirimajareoka ni'ioka jariwa'ririmarĩaja mamarĩkaki werikaᵽakiaki wãmea kio'ojĩ'arũjeraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV13_17","096_13_17","REV","13","17","17","Sawaᵽa waᵽaĩjirika nari'kako'omakaja kiwãmea o'ojĩ'aberikarãte nayaᵽakoᵽeraᵽaka ĩjirika kijãjibaaraᵽe. I'suᵽakajaoka simaraᵽe kiwãmea o'ojĩ'abeyurã niñerũ tõᵽoerã ba'irĩjia ĩjirika imaberaᵽaka. Kire ĩawãrũrũkia koᵽakaja kiwãmea, suᵽabatirã kinúmero simaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV13_18","096_13_18","REV","13","18","18","Kiwãme koᵽakaja simaraᵽe 666. Ᵽo'imaja wãmea ãrĩrika simaraᵽe samarĩjĩkareka. “I'suᵽaka ãrĩrikoᵽakaja sime”, ãrĩwãrũokaro'si jia samija ĩawãrũbe. ");
INSERT INTO tnc_vpl VALUES ("RV14_1","096_14_1","REV","14","1","1","I'suᵽaka simaraᵽaka be'erõ'õ Sión wãmeika ᵽusiᵽemarã Oveja weiwa'yua uᵽaka imakite rĩkamaᵽakã'ã ñiaraᵽe. Ciento cuarenta y cuatro mil rakamarã ᵽo'imajare kika imaraᵽe. Nakũ'arã kiwãmea, Kiᵽaki wãmeaoka nareka o'ojĩ'amo'mekarã nimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV14_2","096_14_2","REV","14","2","2","Sabe'erõ'õjĩte mabo'ikakurirõ'õᵽi ikuᵽaka sokaarikoraᵽe ate. Ãta jãjia okaayu uᵽaka, wĩᵽoa jãjia ᵽaaika uᵽaka, suᵽabatirã rĩkimarãja arᵽa birebaraka nimarõ'õ uᵽaka sokarĩkamarãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV14_3","096_14_3","REV","14","3","3","Botarakamarã maikoribeyu uᵽarã, suᵽabatirã veinticuatro rakamarã ᵽakiarimarã ĩᵽire ruᵽaraᵽaka wãjitãji imaraᵽarã. Nawãjitãji ciento cuarenta y cuatro mil rakamarã mamaka baya koyabaraka imaraᵽarã. Nirã aᵽerã imaberaᵽarã nabayakoyaraᵽaka õñurã. Ritatojo wejeareka imarãte Satanáre jã'merũkiareka waᵽu'rikarã nimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV14_4","096_14_4","REV","14","4","4","Waᵽuju rõmitika baariwã'imarĩbeyurã uᵽaka imarika ᵽuᵽajoairã, waᵽuju ima jiyiᵽuᵽayeebeyurã imarĩ, Tuᵽarãte takaja jiyiᵽuᵽayeeirã nimaraᵽe. Suᵽabatirãoka Oveja weiwa'yua uᵽaka imakite a'yu uᵽakaja, kika a'ririjayurã. Ritatojo wejeareka imaraᵽarãre ĩatirã kirirã, Tuᵽarãrirãoka nimaerã ba'irokareka mamarĩ kitããekarã nimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV14_5","096_14_5","REV","14","5","5","Suᵽa imarĩ ĩ'rĩkaoka ᵽakirimaji imaberaᵽaki naka, Tuᵽarãte ĩaika wãjitãji ᵽaremarirã nimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV14_6","096_14_6","REV","14","6","6","Sabe'erõ'õ ĩ'rĩka ángelte mabo'ikakurirõ'õrã wiᵽakã'ã ñiaraᵽe. Iki imaraᵽaki, “Kimakiᵽi ãrĩwa'ri ᵽo'imajare õñia imajiᵽarũkia Tuᵽarã ja'ataikaki”, majaroka o'ariba'imarĩa ãñua bojarimaji. Ritaja ka'iareka dikaoka jariwa'ririmarĩa, suᵽabatirã ᵽo'imajatata jariwa'ririmarĩa, noka imabayu uᵽakaja jairã, suᵽabatirã ritaja wejeareka imarãte sabojarimaji kimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV14_7","096_14_7","REV","14","7","7","Suᵽa imarĩ ikuᵽaka jãjirokaᵽi kijaikoraᵽe: —Ritaja ima tẽrĩwa'ribaji imaki Tuᵽarãte imamaka, saᵽi ãrĩwa'ri kire mija jiyiᵽuᵽayeebe. I'suᵽaka ñañu ᵽo'imajare ba'iaja baaika waᵽa jẽñerũkirĩmi seyaika simamaka. Tuᵽarã imaki wejeᵽema, ka'ia, riaka, okoa juruᵽoajiyeikaoka baaekaki. I'suᵽaka baaekaki kimamaka jiyiᵽuᵽaka kire õrĩrũkirã mija ime,— ángelte ãrĩkoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV14_8","096_14_8","REV","14","8","8","Sabe'erõ'õ aᵽika ángelte wiraᵽaka ñiaraᵽe. Ikuᵽaka kijaikoraᵽe: —Babiloniawejea, suᵽabatirã sareka imarãte ba'iaja baariᵽareareka Tuᵽarãte sariataraᵽe. Babiloniakarã ba'iaja ritatojo wejeareka imarã Tuᵽarãte naja'ataokaro'si baata'airã imaraᵽarã,— ángelte ãrĩkoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV14_9","096_14_9","REV","14","9","10","I'sia be'erõ'õ aᵽika ángelte ñiaraᵽe. I'kioka ikuᵽaka jãjirokaᵽi jaikoraᵽaki: —Werikaᵽakiakite jiyiᵽuᵽayeeirã, suᵽabatirã kijẽrãka nabaaᵽo'ijiaraᵽakite jiyiᵽuᵽayeeirãoka, kiwãmea naᵽitakarã, nakũ'arã o'ojĩ'arũjekarãte boebariwa'ri Tuᵽarãte ba'iaja nare jũarũjerãñu. Mia je'e, i'suᵽaka nimamaka sawaᵽa azufre ᵽeka jũ'rẽirõ'õrã ba'iaja jũarĩ na'rirãñu. Tuᵽarãrirã ángelrãkare ĩarãka wãjitãji, suᵽabatirã Oveja weiwa'yua uᵽaka imakite ĩarãka wãjitãjioka, ba'iaja najũarãñu. ");
INSERT INTO tnc_vpl VALUES ("RV14_11","096_14_11","REV","14","11","11","Ba'iaja nabaaeka ᵽareaja nare joerãka ũmakaka ᵽuri tiyirũkimarĩa imarãka. I'suᵽaka werikaᵽakiaki uᵽaka imaraᵽakite jiyiᵽuᵽaka õñurã, suᵽabatirã kijẽrãka baaekaoka jiyiᵽuᵽayeewa'ri kiwãmea o'ojĩ'aekarã ba'iaja jũajiᵽarãñurã,— kẽrĩkoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV14_12","096_14_12","REV","14","12","12","I'suᵽaka simamaka, Tuᵽarãrirã, kijã'meika yi'ᵽaraka Jesúreoka yi'ririjayurã imarĩ, kire yi'ririja'atarimarĩa sime naro'si. ");
INSERT INTO tnc_vpl VALUES ("RV14_13","096_14_13","REV","14","13","13","I'sia be'erõ'õ mabo'ikakuriᵽi ikuᵽaka yire sãrĩkoraᵽe: —Mire yibojaika mio'obe. Maiᵽamaki Jesúre yi'ririja'atabekaja reyaekarã, jĩjimaka mija imabe,— yire sãrĩkoraᵽe. I'suᵽaka sãrĩkoraᵽaka ã'mitiritirã, ikuᵽaka Esᵽíritu Santore ãrĩkoraᵽe: —Rita sime, i'suᵽakatakajaoka simarũ. Ka'wisi be'erõ'õ naba'iraberijayua ja'atatirã, najẽrĩtarãñu. Mabo'ikakurirã neyarãka ᵽoto, ba'iaja jũaekarã imariᵽotojo kiyaᵽaika uᵽakaja jia nabaaeka õñuka imarĩ, jia sawaᵽa Tuᵽarãte nare baarãñu,— Esᵽíritu Santore ãrĩkoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV14_14","096_14_14","REV","14","14","14","I'tojĩrã oko ũmakaka boia ima ᵽemarã ᵽo'imaji uᵽaka imakite ruᵽamaka ñiaraᵽe. Orokaka baaeka bu'ya tuaekaki sara oᵽika rikaiki kimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV14_15","096_14_15","REV","14","15","15","Torãjĩrã mae, aᵽika ángel Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iaᵽi kiᵽoᵽakã'ã ñiaraᵽe. Oko ũmakaᵽemarã ruᵽaraᵽakite jãjirokaᵽi ikuᵽaka ãrĩkoraᵽe: —Koᵽakaja ka'iareka ima õterikia rabaerã baaika mae, suᵽa imarĩ sata'teᵽatetirã same'eᵽatabe,— kire kẽrĩkoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV14_16","096_14_16","REV","14","16","16","I'suᵽaka kẽᵽakã'ã ã'mitiritirã, ta'teᵽatetirã oko ũmakaka ᵽemarã ruᵽaraᵽakite se'eraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV14_17","096_14_17","REV","14","17","17","I'sia be'erõ'õ, ĩmirã Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iaᵽi aᵽika ángelte ᵽoraᵽe ate. I'kioka sara oᵽika rikaraᵽaki kiro'si. ");
INSERT INTO tnc_vpl VALUES ("RV14_18","096_14_18","REV","14","18","18","I'sia be'erõ'õ, aᵽika ángel, joeĩjiritẽrĩa ĩarĩrĩrimaji, aᵽika ᵽõ'irã ke'ᵽakã'ã ñiaraᵽe. Toᵽi mae oᵽika sara rikaraᵽakite jãjirokaᵽi ikuᵽaka kẽrĩkoraᵽe: —Ka'iareka ima iyaka rẽñua mae. Suᵽa imarĩ misara oᵽikaᵽi sata'tetirã same'ebe,— kire kẽrĩkoᵽakã'ãja ña'mitiraᵽe. (Kire na'mitiriᵽẽaberika waᵽa Jesúre nare jẽñerãñu ãrĩrikoᵽakaja simaraᵽe i'suᵽaka baarika). ");
INSERT INTO tnc_vpl VALUES ("RV14_19","096_14_19","REV","14","19","19","I'suᵽaka kẽᵽakã'ã ã'mitiritirã, kisaraᵽi ka'iareka imaraᵽaka õterikia ta'teᵽatetirã ke'eraᵽe. Se'etirã, sokoa bikerũkirõ'õrã sakitaaraᵽe. “Ᵽo'imajare ba'iaja baaika ĩatirã jimarĩa ba'iaja Tuᵽarãte nare jũarũjerãñu”, ãrĩrika uᵽaka sime i'sia. ");
INSERT INTO tnc_vpl VALUES ("RV14_20","096_14_20","REV","14","20","20","Suᵽa imarĩ weje a'riwa'rirã iyaka narĩ'kaᵽa'seraᵽe. Sanarĩ'kaᵽa'semaka riaka uᵽaka sajururaᵽe riwea. Suᵽabatirã trescientos kilómetro rõ'õjĩrã yoerã sajuruwa'raᵽe. I'suᵽaka baawa'ri kawaru wãmujã'ãrõ'õjĩrã ĩkiria saaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV15_1","096_15_1","REV","15","1","1","I'sia be'erõ'õ mabo'ikakurirõ'õrã aᵽea maikoribeyua imatiyaikakaka ñiaraᵽe. Ángelrãka ĩ'ᵽotẽñarirakamarã narakakaja ba'iaja ᵽo'imajare jũarũkiakaka narikaraᵽe. Jimarĩa ᵽo'imajare boebariwa'ri, saᵽi ᵽiyia ba'iaja Tuᵽarãte nare jũarũjerãñu, “Ba'iaja nabaarijayua naja'atarũ”, ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("RV15_2","096_15_2","REV","15","2","2","Suᵽabatirã riaᵽakiaka jia waria okoika ᵽeka jũ'rẽika uᵽaka ima rukubaka imaria simamaka ñiaraᵽe. I'siriarijerã rĩkimakaja ᵽo'imajare rĩkajiyeraᵽe. Werikaᵽakiaki uᵽaka imaki, suᵽabatirã kijẽrãka ᵽo'imajare baaeka jiyiᵽuᵽayeebeyurã, suᵽabatirãoka kinúmero jĩ'ĩtabeyurã imarĩ werikaᵽakiakite tẽrĩkarã nimaraᵽe. Suᵽabatirãoka arᵽa Tuᵽarãte nare ĩjika ᵽariji narĩkajiyeraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV15_3","096_15_3","REV","15","3","3","Saᵽi Tuᵽarãro'si kiᵽo'imajare imaruᵽutarimaji imaroyirekaki, Moiséte bayakoyaroyireka mirãka bayakoyabaraka nimaraᵽe. I'suᵽakajaoka Oveja weiwa'yua uᵽaka imakite jiyiᵽuᵽayeokaro'si ikuᵽaka nabayakoyaraᵽe: —Tuᵽarã, ritaja ima tẽrĩwa'ribaji imaki imarĩ, ritaja ima ᵽemawa'ribaji jiitaka mibaaika ime. Jia wãjirokaᵽi meñu uᵽakaja jia oyiaja baaiki mime. Ĩ'rãkõ'rĩmato ka'iareka jariwa'ririmarĩa ᵽo'imaja ritaja ĩᵽamaki imajiᵽarijayuka mime. ");
INSERT INTO tnc_vpl VALUES ("RV15_4","096_15_4","REV","15","4","4","Yija ĩᵽamaki, marã mire kĩkibekaja, suᵽabatirãoka mire jiyiᵽuᵽayeebekaja imabesarãñurã. Mi'i ĩ'rĩkaja ĩ'rãkurioka ba'iaja baakoribeyuka mimamaka, i'suᵽaka nimarãñu. Ritatojo wejeareka mire yi'ribeyurãte jiaᵽi miwẽkomabaarãka ᵽoto ritaja ᵽo'imaja ima uᵽatataja miᵽõ'irã rẽrĩrãñurã mire jiyiᵽuᵽayeeokaro'si,— bayakoyabaraka narãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV15_5","096_15_5","REV","15","5","5","I'suᵽaka bayakoyabaraka nimaraᵽaka be'erõ'õ mabo'ikakurirõ'õrã Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã kima kuraraka wiritamaka ñiaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV15_6","096_15_6","REV","15","6","6","Torã Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iaᵽi ĩ'ᵽotẽñarirakamarã ángelrãka ba'iaja ᵽo'imajare jũarũkia rikairãte ᵽoᵽakã'ã ñiaraᵽe. Jariroaka jia boia ka'imarĩa jããtirã, wa'eyoka orokaka õñimaki wãjitãjirõ'õjĩrã jẽrãyua naji'araᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV15_7","096_15_7","REV","15","7","7","Torãjĩrã mae ĩ'ᵽotẽñarirakato seroa orokaka baaeka botarakamarã maikoribeyu uᵽaka imaraᵽarãkakite rikaraᵽe. Suᵽa imarĩ ĩ'ᵽotẽñarirakamarã ángelrãkare nimarakamakireje sakĩjimaka ñiaraᵽe. Kire yi'ribeyurã rĩkimarãja ᵽo'imajare imamaka, Tuᵽarã, õñia imajiᵽarimajire boebayuakaka õñijĩĩrika ᵽururaᵽaka sareka. ");
INSERT INTO tnc_vpl VALUES ("RV15_8","096_15_8","REV","15","8","8","Seroa nare kĩjiraᵽaka ᵽoto Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã ũmakaka ᵽururaᵽaka. I'suᵽaka sabaaraᵽe ritaja ima ᵽemawa'ribajirã jiitakiji Tuᵽarãte ima beawa'ri. Tẽrĩritakiji imakite torã imaraᵽaka simamaka, i'suᵽaka simaraᵽe. Ĩ'ᵽotẽñarirakamarã ángelrãkare ba'iaja ᵽo'imajare jũarũkia rikairãte saba'irabetiyibeyukaji ũmakaka torã ᵽurumaka, makioka kãkaberijĩrõ'õ simaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV16_1","096_16_1","REV","16","1","1","Sabe'erõ'õ Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iaᵽi ikuᵽaka ĩ'ᵽotẽñarirakamarã jãjirokaᵽi ángelrãkare sãrĩkoraᵽaka ña'mitiraᵽe ate: —Tuᵽarãte ĩariᵽe'yoirã ᵽo'imajare ba'iaja jũaerã, seroareka mija rikaika õñijĩĩrika ka'iarã mija we'aña'tabe. I'suᵽaka samija baabe, Tuᵽarãte boebayuakaka sarã ima simamaka,— sãrĩkoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV16_2","096_16_2","REV","16","2","2","Toᵽi mae mamarĩkaki ángelte seroareka kirikaraᵽaka ka'iarã kiwe'aña'taraᵽe. I'suᵽaka kibaaraᵽaka ᵽoto werikaᵽakiaki jẽrãka nabaaekakite jiyiᵽuᵽayeeirã, suᵽabatirã kiwãmea o'ojĩ'aekarãte naᵽo'iarã dajaka ã'mika kãmia nare ᵽo'ijiraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV16_3","096_16_3","REV","16","3","3","Kibe'erõ'õjĩ imaraᵽaki ángelte seroaᵽi kirikaraᵽaka riaᵽakiakarã kiwe'aña'taraᵽe. Sakiwe'aña'taraᵽaka ᵽoto, reyaekarã riweuᵽakaja okoa jararaᵽaka mae. I'suᵽaka sabaamaka, riaᵽakiakareka ima, ba'irĩjiaka ritaja jĩrĩᵽataraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV16_4","096_16_4","REV","16","4","4","Ĩ'ᵽarã be'erõ'õjĩkaki ángel seroaᵽi kirikaraᵽaka riakarã, suᵽabatirã okokoᵽeaᵽi ᵽoyurõ'õrã sakiwe'aña'taraᵽe. I'suᵽaka kibaaraᵽaka ᵽoto riwearo'si okoa jaraᵽaka saro'si mae. ");
INSERT INTO tnc_vpl VALUES ("RV16_5","096_16_5","REV","16","5","5","Ángel okoa ĩarĩrĩrimajire ikuᵽaka jaikoraᵽe: —Tuᵽarã, jia wãjirokaᵽi meñu uᵽakaja jia oyiaja baaiki mime. I'suᵽakajaoka bikija imara'aekaki imariᵽotojo, maekakaoka imarijayuka mime. I'suᵽaka simamaka ᵽo'imajare ba'iaja baaika ĩakoᵽeka boebariwa'ri, ikuᵽaka nare mibaayu: ");
INSERT INTO tnc_vpl VALUES ("RV16_6","096_16_6","REV","16","6","6","Miyi'yurãte najããmaka, jimarĩa nariwea jururaᵽaka. Suᵽabatirã miro'si bojaĩjirimajare i'suᵽakajaoka nabaaraᵽe. I'suᵽaka baaraᵽarã nimamaka okoa naro'si imabeᵽakã'ã, “Riwearo'si jayuaja nukurũ”, meñua jia sime,— kẽrĩkoraᵽe ángel okoa ĩarĩrĩrimaji. ");
INSERT INTO tnc_vpl VALUES ("RV16_7","096_16_7","REV","16","7","7","I'suᵽaka kẽrĩkoraᵽaka be'erõ'õ joeĩjiritẽrĩa imarõ'õᵽi ikuᵽaka kire sayi'rikoraᵽe: —Rita sime Tuᵽarã, i'suᵽakatakaoka sime. Yija ĩᵽamaki, ritaja ima tẽrĩwa'ribaji imatiyaikiji mime. Ritaja ĩawãrũiki imarĩ, ᵽo'imajare ba'iaja baaeka imarõ'õjĩrãja jiirokaᵽi nare sawaᵽa jẽñeiki mime,— sãrĩkoraᵽe toᵽi. ");
INSERT INTO tnc_vpl VALUES ("RV16_8","096_16_8","REV","16","8","8","Maekarakamarã be'erõ'õjĩkaki ángel seroaᵽi kirikaraᵽaka aiyakarã sakiwe'aña'taraᵽe. I'suᵽaka kibaaraᵽaka ᵽoto aiyaᵽeka jãjia ᵽo'imajare joeraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV16_9","096_16_9","REV","16","9","9","I'suᵽaka kibaaraᵽakaᵽi oobaraka ba'itakaja ᵽo'imajare jũaraᵽe. I'suᵽaka nare sabaako'omakaja, ba'iaja nabaaika ja'atabekaja nimaraᵽe. Suᵽabatirã kijã'meraᵽakaᵽi ritaja ba'iaja jũawa'ri Tuᵽarãte jiyiᵽuᵽayeerika ᵽo'imajare yaᵽaberaᵽe. I'suᵽaka imawa'ri kire jiyiᵽuᵽayeerikoᵽakaja ba'iaja Tuᵽarãreka jaibaraka nimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV16_10","096_16_10","REV","16","10","11","Botarakamarã be'erõ'õjĩ imaraᵽaki ángelte, ikuᵽaka baaraᵽe: Werikaᵽakiaki jã'meruᵽarikũmu ᵽemarã seroareka kirikaraᵽaka kiwe'aña'taraᵽe. I'suᵽaka kibaaraᵽaka ᵽoto jã'mebaraka kimaraᵽarõ'õ neiñamita'raᵽaka. I'suᵽaka imawa'ri ritaja nare sayi'amaka marã baaberiwa'ri narẽrõkaka ᵽariji nakukurijaraᵽe. I'suᵽaka imariᵽotojo ba'iaja nabaaika ja'atabekaja, Tuᵽarã, mabo'ikakurirõ'õrã jã'merimajireka ba'iaja jaibaraka nimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV16_12","096_16_12","REV","16","12","12","Ĩ'rãᵽitarakamarã be'erõ'õjĩte imaraᵽaki ángelte seroaᵽi kirikaraᵽaka riaᵽakiaka Éufrates wãmeiriarã sakiwe'aña'taraᵽe. I'suᵽaka kibaamaka riaka sarekaja ᵽõᵽoraᵽaka. I'suᵽaka sajaraᵽe jã'ãtika ᵽẽ'rõtoᵽi i'taraᵽarã ĩᵽarimarãre nasurararãkaᵽitiyika nawaata'yaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("RV16_13","096_16_13","REV","16","13","13","I'suᵽaka simaraᵽaka be'erõ'õ Satanárika ima maekarakamarã ĩᵽaruka uᵽaka ĩoika ñiaraᵽe. Ĩ'rĩka imaraᵽaki kajuyaiᵽakiaka uᵽaka ĩoiki rijokoᵽeaᵽi ᵽoraᵽaki. Aᵽika ĩᵽaruka ᵽoraᵽaki werikaᵽakiaki rijokoᵽeaᵽi. Aᵽika ĩᵽaruka imaraᵽaki weriki waᵽuju ᵽakibaraka, “Tuᵽarãro'si bojaĩjirimaji ñime”, ãrãᵽaki rijokoᵽeaᵽi ᵽoraᵽaki. ");
INSERT INTO tnc_vpl VALUES ("RV16_14","096_16_14","REV","16","14","14","Ĩ'rã maekarakamarã Satanárika ima ĩᵽaruka uᵽaka ĩoirã imaraᵽarã maikoribeyua baabearimaja. I'suᵽaka simamaka ritatojo wejeareka imarã ĩᵽarimarãte, nasurararãkaᵽitiyika ĩ'rĩka jariwa'ririmarĩa narẽrĩrũjeraᵽe. Tuᵽarã, ritaja ima tẽrĩwa'ribaji imaki, ᵽiyia ᵽo'imajare ba'iaja baaika waᵽa kijẽñerãrĩmi seyarãka ᵽoto ᵽitã'mua ᵽo'ijiataokaro'si torã na'raᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV16_15","096_16_15","REV","16","15","15","“Yire mija ã'mitiᵽe”, Jesucristore ãrĩkoraᵽe: “ ‘I'tojĩte mawi'iarã kareba'arimajire etarãñu’, mija ãrĩwãrũbeyu mijaro'si ima uᵽaka sime yetarũkia saro'si. Yetarũkia ta'abaraka yiyaᵽaika uᵽakaja baabaraka imatikaja imarãñurã ᵽuri jĩjimaka imarãñurã. I'suᵽaka imarã imarĩ, rakajetikaja najariroaka jããtikarãja imarã uᵽaka nimarãñu. I'suᵽaka imarãñurã ᵽuri jariromarĩa imawa'ri aᵽerã wãjitãji i'yoᵽi'ribeyurã uᵽaka nimarãñu”, kẽrĩkoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV16_16","096_16_16","REV","16","16","16","Suᵽa imarĩ Satanárika ima ka'iareka imarã ĩᵽarimarãre narẽrĩrũjerãrõ'õ Harmagedón wãmeika sime boarikarõ'õ Hebreo okaᵽi. ");
INSERT INTO tnc_vpl VALUES ("RV16_17","096_16_17","REV","16","17","17","Ᵽiyika ángel seroaᵽi kirikaraᵽaka waᵽuko'torõ'õrã sakiwe'aña'taraᵽe. I'suᵽaka kibaaraᵽaka ᵽoto Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'iarã kiruᵽarikũmua imarõ'õᵽi ikuᵽaka jãjirokaᵽi sajaikoraᵽe: —Koᵽakaja satiyiyu mae,— sãrĩriokaabayuraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV16_18","096_16_18","REV","16","18","18","I'suᵽaka sãrĩkoraᵽaka tiyiwa'raᵽarõ'õjĩte wĩᵽoa yaataira'katirã, ᵽaaraᵽaka. Suᵽabatirã werika okaaribaraka ka'ia jãjia iyiraᵽaka, sareka ᵽo'imajare imaeka ᵽoto siyika ᵽemawa'ribajirã. ");
INSERT INTO tnc_vpl VALUES ("RV16_19","096_16_19","REV","16","19","19","Siyiraᵽakaka ĩ'rãtiji Babiloniawejea imakoᵽeraᵽaka maekarakaweje uᵽaka sajarirĩkaraᵽe. I'suᵽakajaoka ritaja wejeareka imakoᵽeika wejea ririᵽataraᵽaka. Babiloniakarã ba'iaja nabaaika ye'kariribeyuka imarĩ, nare boebariwa'ri ba'itakaja naᵽareareka Tuᵽarãte nare jũarũjeraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV16_20","096_16_20","REV","16","20","20","I'suᵽakajaoka ka'ia iyimaka jũmurika, suᵽabatirã ᵽusia ririᵽataraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV16_21","096_16_21","REV","16","21","21","Suᵽabatirã ĩmiᵽi okojiyia cuarenta y cinco kilos rõ'õjĩrã ima jũjiraᵽaka. I'suᵽaka jũjiraᵽaka nare ᵽa'semaka jimarĩa ba'iaja Tuᵽarãreka jaibaraka ᵽo'imajare imaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV17_1","096_17_1","REV","17","1","1","Suᵽabatirã ĩ'ᵽotẽñarirakamarã ángelrãka seroa rikaraᵽarãkakite yiᵽõ'irã etaraᵽe. Toᵽi mae ikuᵽaka yire kẽrãᵽe: —Õ'õrã mi'tabe, rĩkimaka riamakairõ'õrã ima ba'iaja baariwejea, sakaka mire yibojaerã baayu. Mia je'e: Ritaja ĩmirĩjaka wã'imarĩtiyaiko uᵽaka sareka imarã nimamaka, Tuᵽarãte ba'iaja nare jũarũjerãñu. ");
INSERT INTO tnc_vpl VALUES ("RV17_2","096_17_2","REV","17","2","2","I'suᵽaka i'sia wejeakarãre ba'iaja nare baaruᵽutamaka, ritatojo wejeareka imarã ĩᵽarimarãre ba'iaja naka baaraᵽe. Ĩmirĩjaka wã'imarĩrirõmote ba'iaja nare baaruᵽutaeka imarĩ, ikuᵽaka nimaraᵽe i'sia wejeakarã: Waᵽuju imaja jiyiᵽuᵽaka õñurã imarĩ, ritatojo wejeareka imarãte jiyiᵽuᵽaka sanoñaokaro'si maerumajaka uᵽaka nare nimarũjeraᵽe,— ángelte yire ãrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV17_3","096_17_3","REV","17","3","3","I'suᵽaka yire kẽrãᵽaka ᵽoto Esᵽíritu Santore jeyobaaikaᵽi ãrĩwa'ri ikuᵽaka yire sabaaraᵽe: Ĩ'rĩka ángel ᵽo'imajamatorã yire e'ewa'raᵽaki. Torã eyatirã werikaᵽakiaki jũ'aka imaraᵽaki ᵽemarã rõmore roᵽamaka ñiaraᵽe. Tuᵽarãte jaiyuyerikakaka wãmea o'oeka kireka jĩ'ĩjiyeraᵽaka. Suᵽabatirã ĩ'ᵽotẽñarirakao ruᵽuko'a, ĩ'ᵽaᵽitarakabi wakaiki kimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV17_4","096_17_4","REV","17","4","4","Kosaya iyayaᵽea uᵽaka ĩoika, suᵽabatirã jũ'aka imaraᵽaka. Suᵽabatirã rĩkimakaja, orokaka, suᵽabatirã ãta waᵽajã'rĩakaka, ᵽerlas wameikakaka baaekaoka kojiioka koᵽo'iareka imaraᵽaka. Suᵽabatirãoka ikuᵽaka seroa orokaka baaeka ᵽururika: Noñu uᵽakaja ᵽuᵽajoatirã dajaitakaja nabaaeka waᵽuju imaja kojiyiᵽuᵽayeerijayua, suᵽabatirãoka ba'itakaja kowã'imañua korikaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV17_5","096_17_5","REV","17","5","5","Ikuᵽaka ãrĩrikoᵽakaja kokũ'arã majẽrãko'abeyua wãmea o'ojĩ'aeka imaraᵽaka. Ã'mitirikõrĩ je'e: “Babiloniawejea”, ãñua simaraᵽe kowãmea. “Ritajaka ba'iaja baawã'imarĩrimajare wãrõrimajo imarĩ, naᵽako uᵽaka koime. Suᵽabatirã ritaja ba'ia Tuᵽarãte yaᵽabeyuakaka ᵽo'imajare wãrõrimaja Babiloniawejeakarãre ime”, ãrĩrika simaraᵽe kokũ'arã o'ojĩ'aeka. ");
INSERT INTO tnc_vpl VALUES ("RV17_6","096_17_6","REV","17","6","6","Kore ñiawãrũmaka, ikuᵽaka koimaraᵽe: Iyaokoa ukutirã wejabiyuko uᵽaka koimaraᵽe. Tuᵽarãrirã, suᵽabatirã kirika bojariroka yi'riwa'ri bojarimajare najããraᵽaka riwea koᵽakaja simaraᵽe i'sia iyaokoa. I'suᵽaka koimamaka marãkã'ã ãrĩberijĩka yijaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV17_7","096_17_7","REV","17","7","7","I'suᵽaka ñimamaka, ikuᵽaka ángelte yire bojaraᵽe: —¿Dako baaerã i'suᵽaka mime? Rõmo miako'oko, “Ikuᵽakaro'si simekã'ã”, merĩwãrũokaro'si mire sayibojawaᵽu'ataerã baayu. Suᵽabatirã werikaᵽakiaki ĩ'ᵽotẽñarirakao ruᵽuko'aiki, ĩ'ᵽaᵽitarakabi wakaiki kore e'ewa'ᵽakã'ã miako'oki, “Ikuᵽakaro'si simekã'ã”, jia merĩwãrũerã ĩ'ᵽaba'iwã'taja mire sayibojawaᵽu'ataerã baayu. ");
INSERT INTO tnc_vpl VALUES ("RV17_8","096_17_8","REV","17","8","8","Werikaᵽakiaki miako'oka bikija õñia kimaraᵽe ruᵽu. Imariᵽotojo maekaka ᵽuri kimabeyu. I'suᵽaka simako'omakaja torã kime morĩbeyu ᵽoto koᵽea tiyibeyurõ'õᵽi ᵽorira'atirã kimarãñu. I'suᵽaka kibaamaka ĩatirã, jimarĩa ritatojo wejeareka imarãte ᵽuᵽatarãñu. I'suᵽaka imariᵽotojo sabe'erõ'õᵽi ᵽuri Tuᵽarãte kire riatarũkirõ'õrã ke'rirãñu. Kiᵽaᵽera ᵽũñurã Tuᵽarãte nawãmea o'oberikarã nime werikaᵽakiaki uᵽaka imakite ĩatirã ᵽuᵽatarũkirã. Ika wejea kiᵽo'ijiaerã baaeka ruᵽubajirã kiᵽaᵽera ᵽũñurã Tuᵽarãte o'oeka, “Ikarakamarã nime õñia imajiᵽarũkirã”, ãrĩwa'ri sakio'oeka. ");
INSERT INTO tnc_vpl VALUES ("RV17_9","096_17_9","REV","17","9","9","Sarekaja ã'mitiriwãrũikiro'si ᵽuri õrĩrũkia sime. Ĩ'ᵽotẽñarirakao ruᵽuko'aiki miako'a ĩ'ᵽotẽñarirakabi ᵽusi uᵽaka sime. I'suᵽakajaoka koime rõmo saᵽemarã roᵽako'oko. Aᵽeroka ĩ'ᵽotẽñarirakamarã ĩᵽarimarã uᵽaka sime kiruᵽuko'a. ");
INSERT INTO tnc_vpl VALUES ("RV17_10","096_17_10","REV","17","10","10","I'suᵽaka simako'omakaja ĩ'rãᵽitarakamarã nime ĩᵽarimarã bikija reyaekarã. Nabe'erõ'õ tuikaki imaki maekaka ᵽo'imajare jã'merijayuka. Kibe'erõ'õjĩ imarũkika ᵽuri õibeyukajika ruᵽu. Ñamajĩ ᵽuri matikurijĩkaja ᵽo'imajare kijã'mekoᵽerãñu. I'suᵽaka imariᵽotojo Tuᵽarãte ãrĩrãka uᵽakaja kiro'si simarãñu. ");
INSERT INTO tnc_vpl VALUES ("RV17_11","096_17_11","REV","17","11","11","Werikaᵽakiaki imaroyirekaki, maekaka ᵽuri õñia imabeririᵽotojo ñamajĩ ᵽuri nabe'erõ'õ ᵽiyia jã'merimaji kimarãñu. Ĩ'ᵽotẽñarirakamarã jã'meka mirãrãte jã'meka uᵽakaja jã'merimaji kimarãñu. I'suᵽaka ba'iaja kibaarãka be'erõ'õᵽi ᵽuri Tuᵽarãte riatarũkikaro'siji kime. ");
INSERT INTO tnc_vpl VALUES ("RV17_12","096_17_12","REV","17","12","12","Ĩ'ᵽaᵽitarakabi waka miako'a, ĩ'ᵽaᵽitarakamaki ĩᵽarimarã uᵽaka ima. I'suᵽaka simako'omakaja, ᵽo'imajare jã'meũ'mubeyukajirã nime ruᵽu. Ñamajĩ werikaᵽakiakika jã'merũkirãro'si nime. I'suᵽaka baarimaja imariᵽotojo ñoaka jã'mebaraka nimabesarãñu. ");
INSERT INTO tnc_vpl VALUES ("RV17_13","096_17_13","REV","17","13","13","Ĩ'ᵽaᵽitarakamarã imariᵽotojo ĩ'rĩka ta'iarãja ᵽuᵽajoairã nimarãñu. I'suᵽaka imarã imarĩ, “Miyaᵽaika uᵽakaja mibaarika yaᵽawa'ri mikaja mire jeyobaabaraka yija imarãñu”, werikaᵽakiakite narĩrãñu. ");
INSERT INTO tnc_vpl VALUES ("RV17_14","096_17_14","REV","17","14","14","I'suᵽaka imawa'ri Oveja weiwa'yua uᵽaka imakika najĩrĩrãñu. Suᵽa simako'omakaja nare kitẽrĩrãñu. Suᵽa imarĩ aᵽerã imatiyarimaja tẽrĩwa'ribaji imaki imarĩ suᵽa kibaarãñu. Suᵽabatirã ĩᵽarimarãtarã imarã ĩᵽamaki kime. Oveja weiwa'yua uᵽaka imakika imarã Tuᵽarãte wã'maekarã imarĩ, kire ye'kariribekaja kiyaᵽaika uᵽakaja baarijayurã nime,— ángelte yire ãrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV17_15","096_17_15","REV","17","15","15","Ikuᵽaka aᵽea ángelte yire bojaraᵽe: —Rõmore ruᵽairõ'õrã, rĩkimakaja ima riamaka miako'a, ᵽo'imaja koᵽakaja riamaka ime. Suᵽa imarĩ ĩ'rã wejekarã jariwa'ririmarĩa, ĩ'rãtata ᵽo'imaja ᵽããwa'rimarĩa, suᵽabatirã naka'iareka imabayurã uᵽatataja sime miako'a. ");
INSERT INTO tnc_vpl VALUES ("RV17_16","096_17_16","REV","17","16","16","Ĩ'ᵽaᵽitarakamaki ĩᵽarimarã werikaᵽakiaki uᵽaka imakika miako'orã, rõmore ĩariᵽe'yorimaja nime. Suᵽa imarĩ ba'iaja kore baawa'ri, ritaja koba'irĩjia ẽ'matirã jariromarĩko kore naja'atarãñu. Suᵽa imarĩ kore jããtirã, kori'ia ba'aᵽuatirã, koũ'a ᵽuri ᵽekarã najoeriatarãka. Iko rõmore ima uᵽaka ima weje simamaka i'suᵽaka sanariatarãñu. ");
INSERT INTO tnc_vpl VALUES ("RV17_17","096_17_17","REV","17","17","17","I'suᵽaka i'sia wejeakarãre nabaarãñu kiᵽuᵽajoaika uᵽakaja Tuᵽarãte nare baarũjemaka. Suᵽabatirã ĩ'rĩka ta'iarãja ᵽuᵽajoawa'ri werikaᵽakiakite niᵽamaki nimarũjerãñu. Suᵽa imarĩ kiyaᵽaika uᵽakaja kire najeyobaarãñu, “Koᵽakaja sajẽ'rãka ñarĩkarã seyayu mae”, Tuᵽarãte ãrĩrãñu rõ'õjĩte. ");
INSERT INTO tnc_vpl VALUES ("RV17_18","096_17_18","REV","17","18","18","I'ko rõmo miako'oko ba'itaka wejea koᵽakaja koime. I'suᵽaka simamaka tokarã ĩᵽarimarã aᵽea wejeakarã ĩᵽarimarãte jã'merimaja imarã,— ángelte yire ãrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV18_1","096_18_1","REV","18","1","1","I'suᵽaka simaraᵽaka be'erõ'õ mabo'ikakurirõ'õᵽi ángel jã'merimajite ruira'amaka ñiaraᵽe. Jãjia ya'tariki imarĩ, ka'ia ritatojo kiyaaboaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV18_2","096_18_2","REV","18","2","2","I'tojĩrã mae, jãjirokaᵽi ikuᵽaka kẽrĩkoraᵽe: —Babiloniawejea ririrũkiaro'si sime. I'suᵽakajaoka sareka imakoᵽeirãte ᵽurirãñu. I'suᵽaka baawa'ri Satanárika ima wejea, suᵽabatirã ritaja wiriba'ia, ba'irĩji dajaka wejearo'si sajarirãñu. ");
INSERT INTO tnc_vpl VALUES ("RV18_3","096_18_3","REV","18","3","3","Mia, ikuᵽaka baarijayurã nimaraᵽe: Babiloniakarã ba'iaja baarirõmo uᵽaka imarĩ, ritatojo wejeareka imarãte waᵽuju imaja jiyiᵽuᵽaka õñurã najayaokaro'si nare sĩawejabiarijayuko koime. Suᵽa imarĩ ritatojo wejeareka imarã ĩᵽarimarã ba'iaja koka nabaaraᵽe. I'suᵽakajaoka aᵽerõ'õkarãreka ba'irĩjia waᵽajã'rĩakaja yaᵽatiyawa'ri, sanawaᵽaĩjiraᵽe. Suᵽa imarĩ ritatojo wejeareka waruomarãre rĩkimakaja niñerũ tõᵽoirã najaraᵽe,— ángelte ãrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV18_4","096_18_4","REV","18","4","4","I'suᵽaka kẽrãᵽaka be'erõ'õ mabo'ikakurirõ'õᵽi ikuᵽaka Tuᵽarãro'si sãrĩkoraᵽe: —Yire ã'mitiriᵽẽarijayurã, i'sia wejearã mija ima'si. I'suᵽakajaoka ba'iaja nabaaraᵽaka uᵽaka baabekaja mija imabe, ba'iaja najũaraᵽaka uᵽaka mija jũakoreka. ");
INSERT INTO tnc_vpl VALUES ("RV18_5","096_18_5","REV","18","5","5","Tokarãre ba'itakaja baarijaᵽaraka ima koᵽakaja ñiarũñaayu,— kiro'si sãrĩkoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV18_6","096_18_6","REV","18","6","6","I'suᵽaka simamaka boebariwa'ri ba'iaja baarimajare riatarũkirãte ikuᵽaka sãrĩkoraᵽe: —Aᵽerãte ba'iaja nabaaraᵽaka simamaka, saᵽemawa'ribaji ba'iaja nare mija baarãñu. ");
INSERT INTO tnc_vpl VALUES ("RV18_7","096_18_7","REV","18","7","8","Mia je'e, rĩkimakaja dakoa jariwa'ririmarĩaja rikairã nime. “Imatiyairã maime”, ãrĩᵽuᵽajoairã imarĩ, nayaᵽaika uᵽakaja nabaarijayu. I'suᵽaka nabaarijayu ko'aᵽitorõ'õjĩrãja ba'iaja nare mija jũarũjebe. “Jã'merimaja rõmijã maime. Natĩmiarã nare reyataᵽamaka ba'iaja ᵽuᵽayurã uᵽakamarĩa maime”, ãrĩᵽuᵽajoairã nimako'omakaja, ĩ'rãrĩmi tokarãre ba'iaja jũarãñu. Suᵽa imarĩ reyairã, kẽsia jũarũkirã, suᵽabatirã aᵽerã ba'iaja ᵽuᵽaririkarekaja imarãñurã riomaka imawa'ri. Suᵽabatirã nawejea oorãka. Ika ñañu ritaja i'sia wejeareka imarãte yijoeriatarãka simamaka. I'suᵽaka ñañu ritaja ima tẽrĩwa'ribaji yirikaᵽi sayibaarãka simamaka,— Tuᵽarãro'si sãrĩkoᵽakã'ã ña'mitiraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV18_9","096_18_9","REV","18","9","9","—I'sia wejea ooriᵽakã'ã ĩatirã, jimarĩa aᵽea ka'iareka imarã ĩᵽarimarãre ba'iaja ᵽuᵽarirãñu, “Nimamaka dako jariwa'ririmarĩaja yija yaᵽaika uᵽakaja naka yija baakoᵽeroyiraᵽe”, ãᵽaraka. I'suᵽaka ĩᵽarimarãre ãrĩrãñu Babiloniakarãka ba'iaja baarijeyoarika mirãrã. ");
INSERT INTO tnc_vpl VALUES ("RV18_10","096_18_10","REV","18","10","10","I'suᵽaka simako'omakaja Babiloniakarãka ba'iaja jũarika yaᵽaberiwa'ri ñoakurirãja natuirãñu. Toᵽi oᵽaraka ikuᵽaka narĩrãñu: “¡Aya! Jimarĩa jo'baka wejeᵽakiaka imariᵽotojo sooriyu. Ritaja ima aᵽeriweje bo'ibajirã imatiyairõ'õ simakoᵽeraᵽe. I'suᵽaka simako'omakaja tokarãre ba'iaja baariᵽareareka ikuᵽarõ'õᵽiji i'suᵽaka Tuᵽarãte sabaayu”, nawejeareka imabayurã ĩᵽarimarãre ãrĩrãñu. ");
INSERT INTO tnc_vpl VALUES ("RV18_11","096_18_11","REV","18","11","14","I'suᵽakajaoka oro, ᵽlata, ãta waᵽajã'rĩa, ᵽerlas, sayaᵽãia waᵽajã'rĩakaka, suᵽabatirã jia jiijĩsia jĩaikakaka yaᵽua waᵽajã'rĩa ima, marfilkaka nabaaeka, ᵽeruakaka, suᵽabatirã broncekakaoka nabaaekakaka, ayabaka, suᵽabatirã jiijĩsia naᵽo'ia imaerã iyebaka naᵽukerũkia, suᵽabatirã canela, ba'irĩjia ba'arika rukerũkia jiibaji jĩsika, iyaokoa, iyebaka yo'aba'arũkia, trigo, trigo jía oyeka, naᵽoyarã, wa'ibikirãwẽkoa, oveja, kawaru, suᵽabatirãoka kawaruᵽi tũrũrũki uᵽaka na'ririjayuaoka, ritaja õ'õrã yija bojaekarakaba'i Babiloniakarãre e'etoᵽaraka imakoᵽeroyiraᵽe. I'suᵽaka simamaka ĩakoᵽeka ritaja waruaka nare ĩjirimaja mirãrã oribaraka nimarãñu. I'suᵽaka nimarãñu ritaja narikakoᵽeika ᵽuᵽajoawa'ri, “No'orã aᵽekurioka sayija ĩjibesarãñu mae. Jíakaka nayaᵽakoᵽeroyiraᵽaka, suᵽabatirã ritaja ba'irĩjia waᵽajã'rĩa narikakoᵽeroyiraᵽaka ᵽitiyika naririwa'yu mae, aᵽekurioka sanarikaerãmarĩa”, narĩrãñu. ");
INSERT INTO tnc_vpl VALUES ("RV18_15","096_18_15","REV","18","15","15","Suᵽa imarĩ Babiloniarã ba'irĩjia ĩjitirã rĩkimakaja niñerũ tõᵽokoᵽeka mirãrã, soorãñurĩmi yoeᵽi oribaraka nimarãñu, “Naka ĩ'rãtiji ba'iaja torã yija jũaa'si”, ãrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("RV18_16","096_18_16","REV","18","16","16","Toᵽi imatirã ikuᵽaka ba'iaja ᵽuᵽaribaraka narĩrãñu: “¡Aya! Ba'itakaja sabaayu Babiloniawejea. Rõmo jiyuritaka imakote ima uᵽaka imaweje simakoᵽeroyiraᵽe. Suᵽabatirã sayaᵽãia waᵽajã'rĩa iyayaᵽea ĩoika suᵽabatirã jũ'aka jããtirã, rĩkimakaja kojiioka koᵽo'ireka imaraᵽaka, orokaka baaeka, suᵽabatirã ãta waᵽajã'rĩakaka baaeka, ᵽerlas wameikakaka baaeka uᵽaka imaweje simakoᵽeroyiraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV18_17","096_18_17","REV","18","17","17","Suᵽabatirãoka ritaja narikakoᵽeroyiraᵽaka ñojimarĩji ooᵽataika”, ba'irĩjia torã ĩjikoᵽeroyikarãte ãrĩrãñu. Waᵽuru ĩᵽarimarã, naro'si ba'iraberimaja, suᵽabatirã waᵽuruᵽi waruaka e'ewa'ritirã ĩjirimaja ñoakuriᵽi i'suᵽaka imarãka ĩañumarãñurã. ");
INSERT INTO tnc_vpl VALUES ("RV18_18","096_18_18","REV","18","18","18","I'suᵽakajaoka ate, Babilonia oobaraka jimarĩa sũmakaᵽuᵽakã'ã ĩawa'ri ᵽañebaabaraka ikuᵽaka nakasererãñu: “I'siweje imaroyiraᵽarõ'õjĩrã ima weje imabeyua mae”, narĩrãñu. ");
INSERT INTO tnc_vpl VALUES ("RV18_19","096_18_19","REV","18","19","19","Tẽrĩrikaja ba'iaja ᵽuᵽariwa'ri naruᵽuko'areka ka'ia naᵽearãñu. I'suᵽaka baatirã ᵽañebaabaraka ikuᵽaka narĩrãñu: “¡Aya! Ba'itakaja sabaayu Babiloniawejea imakoᵽeroyiraᵽaka. Waᵽuru jo'baka rikairã saᵽi waruaka torã e'ewa'ᵽaraka nare ĩjitirã, rĩkimakaja niñerũ tõᵽokoᵽeroyiraᵽarã. Ñojimarĩji sooᵽatayu mae”, narĩrãñu waᵽurureka imarã,— mabo'ikakurirõ'õᵽi Tuᵽarãro'si sãrĩkoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV18_20","096_18_20","REV","18","20","20","Torãjĩrã ikuᵽaka sajaikoᵽakã'ã ña'mitiraᵽe ate: —I'sia wejea ooᵽatamaka ĩatirã, jĩjimaka mija imabe mabo'ikakurirõ'õreka imarã. Kirika bojariroka mija bojaerã Cristore ᵽũataekarã, Tuᵽarãte nare ãñua bojaĩjirimajaoka, suᵽabatirã Tuᵽarãte yi'yurã uᵽatiji jĩjimaka mija jaᵽe. I'suᵽaka mija imabe torã imaroyiraᵽarãte ba'iaja mijare baawã'imarĩka waᵽa ba'iaja najũaika simamaka,— sãrĩkoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV18_21","096_18_21","REV","18","21","21","Torãjĩrã ate aᵽika ángel jãjikate ñiaraᵽe. Suᵽa imarĩ, jo'baka ãta trigo mukerũkia uᵽaka ima e'etirã riakarã kiyiataraᵽe. I'suᵽaka sabaatirã, ikuᵽaka kẽrãᵽe: —Ãta yiyiataika uᵽakaja, Babilonia Tuᵽarãte riataᵽatarãñu. Suᵽa imarĩ aᵽekurioka ᵽo'imajare ĩaᵽe'arũkimarĩa simarãñu. ");
INSERT INTO tnc_vpl VALUES ("RV18_22","096_18_22","REV","18","22","22","I'suᵽaka simamaka torã arᵽa birebaraka nabayakoyarijayua, suᵽabatirã ma'saka naᵽuᵽurijayua, tromᵽeta naᵽuᵽurijayua, aᵽekurioka ã'mitirirũkimarĩa sajarirãñu. Suᵽa imarĩ i'sia wejeareka jia oyiaja ba'irĩjia baarika õñurã aᵽekurioka sarã ba'irabebaraka imabesarãñurã. I'suᵽakajaoka simarãñu trigo oyerimajaro'sioka. ");
INSERT INTO tnc_vpl VALUES ("RV18_23","096_18_23","REV","18","23","23","I'suᵽakajaoka jia yaaboabaraka torã ima aᵽekurioka yaaboabaraka imabesarãka. Suᵽabatirã jĩjimaka ᵽitañi'awa'ri nimarijayua imabesarãka mae. Mija ã'mitiᵽe Babiloniawejeakarã. Ritatojo wejeareka imabayurã bo'ibajirã waruamarã mijakarã imakoᵽeraᵽe. Mija ye'oaᵽi ritatojo wejeareka imarãte mija ᵽakiraᵽe mija waruaka takaja nayaᵽatiyaokaro'si. Suᵽa imarĩ Tuᵽarãte jiyiᵽuᵽayeebeyurã najaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV18_24","096_18_24","REV","18","24","24","Tuᵽarãte nare ãñua bojaĩjirimajare, suᵽabatirã kire yi'yurãte, i'suᵽakajaoka ritaja ᵽo'imajatatakarãre jããbaraka mija imaroyiraᵽe. I'suᵽaka mija baaroyiraᵽaka waᵽa ba'itakaja mija jũayu mae,— ãta jo'baka riakarã yiataraᵽakite ãrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV19_1","096_19_1","REV","19","1","1","I'suᵽaka simaraᵽaka be'erõ'õ rĩkimarã mabo'ikakuriᵽi najaimaka ña'mitiraᵽe. Ikuᵽaka jãjirokaᵽi narĩkoraᵽe: —“Aleluya. Tẽrĩrikaja jiika maiᵽamaki Tuᵽarãte ime”, kireka marĩrijariye'e. I'ki Tuᵽarãja imaki ba'iaja imarika tiyibeyurõ'õrã ma'rirũkia imakoᵽekareka mare tããekaki. Ritaja ima bo'ibajirã imaki kime, suᵽabatirã ritaja ima ᵽemawa'ribajirã jiitakiji kime. ");
INSERT INTO tnc_vpl VALUES ("RV19_2","096_19_2","REV","19","2","2","“Ba'iaja ritajaka wã'imarĩtiyaikote yiwẽkomabaarãñu”, rita ãñuka imarĩ, waᵽujumarĩa ba'iaja kore kibaayu. Ba'iaja kobaaekaᵽi ritatojo wejeareka imaekarãte ba'iaja koimaruᵽutaeka. I'suᵽaka simamaka Tuᵽarãte yaᵽaika baaroyiraᵽarãte jããekakote, i'suᵽaka kobaaroyiraᵽaka ĩaraᵽaki imarĩ, kore kiriataraᵽe mae,— narĩriokabayuraᵽe mabo'ikakurirõ'õᵽi. Ba'iaja ritajaka wã'imarĩtiyaiko uᵽaka ᵽo'imajare Babiloniawejeakarã ba'iaja imaruᵽutairã imamaka i'suᵽaka narãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV19_3","096_19_3","REV","19","3","3","Suᵽabatirã ikuᵽaka narĩriokabayuraᵽe ĩ'rãjaoka ate: —“Tẽrĩrikaja jiika maiᵽamaki Tuᵽarãte ime”, kireka marĩrijariye'e, Babiloniawejea ooeka ũmakaᵽuritiyirũkimarĩa ima simamaka,— narĩkoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV19_4","096_19_4","REV","19","4","4","I'suᵽaka narĩkoraᵽaka ᵽoto, Tuᵽarã ruᵽarikũmu wãjitãji veinticuatro rakamarã ᵽakiarimarã, suᵽabatirã botarakamarã maikoribeyu uᵽaka imaraᵽarãte mo'iᵽãñawa'raᵽe. Toᵽi imatirã ikuᵽaka narãᵽe: —I'suᵽaka nañua rita sime. Tẽrĩrikaja jiika maiᵽamaki Tuᵽarãte ime,— narãᵽe kire jiyiᵽuᵽayeewa'ri. ");
INSERT INTO tnc_vpl VALUES ("RV19_5","096_19_5","REV","19","5","5","I'suᵽaka simaraᵽaka be'erõ'õ Tuᵽarã ruᵽarikũmua imarõ'õᵽi ikuᵽaka sajaikoraᵽe: —“Tẽrĩrikaja jiika mime”, ãᵽaraka jĩjimaka Tuᵽarãka maimaye'e. Ᵽo'imajare ĩaika wãjitãji imatiyarimaja, imatiyabeyurã uᵽaka imakoᵽeirãoka, ritaja kiyaᵽaika uᵽakaja kiro'si baarijayurã kire jiyiᵽuᵽayeebaraka jĩjimaka maimarijariye'e,— sãrĩkoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV19_6","096_19_6","REV","19","6","6","I'suᵽaka simaraᵽaka be'erõ'õ, rĩkimarãja jairiokabayurã, suᵽabatirã ãta okaayu uᵽaka, suᵽabatirã wĩᵽoa jaika uᵽaka baatirã ikuᵽaka narĩkoraᵽe: —Aleluya. I'suᵽaka imaki imarĩ, ritajare kijã'merijayu. Suᵽa imarĩ “Ritaja imabo'ibajirã tẽrĩrikiji imaki kime”, ãᵽaraka kire majiyiᵽuᵽayeerijariye'e. ");
INSERT INTO tnc_vpl VALUES ("RV19_7","096_19_7","REV","19","7","7","Oveja weiwa'yua uᵽaka imakite ᵽitañi'airã uᵽaka mija imarĩmi seyayu mae. I'suᵽaka simamaka Tuᵽarãte jĩjimakaᵽi jiyiᵽuᵽaka õᵽaraka maimaye'e, kika maimajiᵽarãka imarĩ. Oveja weiwa'yua uᵽaka imaki jeyomakore ketarũkia jĩjimakaᵽi ta'atikaja koima uᵽaka kiruᵽu nimarijayu. ");
INSERT INTO tnc_vpl VALUES ("RV19_8","096_19_8","REV","19","8","8","Jíakaka boia ka'imarĩa jariroaka najããrũkia Tuᵽarãte nare ĩjiraᵽe,— sãrĩkoraᵽe. Najããika ka'imarĩa ima, “Ba'iaja baabekaja Tuᵽarãte yi'yurã”, ãrĩrikoᵽakaja simaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV19_9","096_19_9","REV","19","9","9","Sarokajĩte ikuᵽaka ángelte yire ãrãᵽe ate: —Mae mire ñarĩrã baaika jia samio'obe: “Oveja weiwa'yua uᵽaka imakite ᵽitañi'aika uᵽaka baarãka baya niaerã kioyibojaekarãre jĩjimaka jarirãñu jiitaka Tuᵽarãte nare baamaka”, ãñua mio'obe,— ángelte yire ãrãᵽe. Suᵽabatirã, —Rita sime ika mire yibojaika, Tuᵽarãrika bojariroka imatiyaika simamaka,— yire kẽrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV19_10","096_19_10","REV","19","10","10","I'suᵽaka kẽᵽakã'ã, jiyiᵽuᵽaka kire õrĩwa'ri kiwãjitãji yimo'iᵽãñaraᵽe. —Mimo'iᵽãña'si yiwãjitãji. Mima uᵽakaja, suᵽabatirã mijeyomarã Jesúre yi'yurã uᵽakajaoka Tuᵽarãte yaᵽaika baaiki ñime yiro'si. Suᵽabatirã “Ikuᵽaka kime Tuᵽarã”, ãrĩwa'ri Jesúre wãrõekakaka bojarijayurã maime. I'suᵽaka ĩ'rãtiji bojarijayurã maimamaka, Tuᵽarãte takaja mijiyiᵽuᵽayeetiyabe,— ángelte yire ãrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV19_11","096_19_11","REV","19","11","11","I'suᵽaka kẽrãᵽaka be'erõ'õ, mabo'ikakurirã koᵽereka uᵽaka wiritamaka ñiaraᵽe. Sawiritaraᵽaka ᵽoto kawaru boika torã rĩkamaraᵽaki ᵽemarã, ĩ'rĩka ᵽo'imajire tuyuraᵽe. “Kẽrĩrijayu uᵽakaja baaiki, wãjimiji bojarimaji”, wãmeiki kimaraᵽe kireka tuyuraᵽaki. Wãjia ᵽo'imajare jã'meiki, suᵽabatirã kimajamarãre ba'iaja baaeka ᵽi'iwa'ri ᵽitã'mua ᵽo'ijiaiki kimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV19_12","096_19_12","REV","19","12","12","Kiñakoa ᵽeka jũrẽika uᵽaka yaaboaraᵽaka. Kiruᵽuko'areka rĩkimakaja niᵽarimarã mirãrã bu'ya tuaekaki kimaraᵽe. Wãmea kireka o'ojĩ'aeka, i'ki ĩ'rĩkaja kiõñua simaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV19_13","096_19_13","REV","19","13","13","Riwearã ñu'aeka saya uᵽaka jariroaka jããiki kimaraᵽe. “Tuᵽarãte nare ãñu uᵽakaja ᵽo'imajare baabeaiki ñime”, ãñua wãmeiki kimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV19_14","096_19_14","REV","19","14","14","Suᵽa imarĩ kisurararãka mabo'ikakurirã jariro boia ka'imarĩa jããekarã imaraᵽarã. Suᵽabatirã kawaru boirã ᵽemarã tuyutirã kibe'erõ'õ na'ririjaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV19_15","096_19_15","REV","19","15","15","Naruᵽurõ'õ a'ririjaraᵽaki rijokoᵽeareka sara oᵽika imaraᵽaka. Sara koᵽakaja kioka imarãñu. I'suᵽaka kiokaᵽi kimajamarãre ĩ'rãᵽẽ'rõtorãja kibaarãka simamaka. I'suᵽaka imawa'ri ritaja jã'mewãrũiki imarĩ, ba'iaja baarimajare baaika ĩariᵽe'yowa'ri nare kiwẽkomabaarãñu. Ritaja ima tẽrĩwa'ribaji imaki Tuᵽarãte nare boebaᵽakã'ã ba'itakaja nare baarimaji kimarãñu kiro'si. ");
INSERT INTO tnc_vpl VALUES ("RV19_16","096_19_16","REV","19","16","16","Kijariroakarã suᵽabatirã kirijoarãoka ikuᵽaka ãñua o'oeka jĩ'ĩtaraᵽaka: “Ĩ'ĩ kime ritaja ĩᵽarimarã ĩᵽamaki, suᵽabatirãoka ritaja imatiyarimajare jã'merimaji”, ãñua simaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV19_17","096_19_17","REV","19","17","18","I'suᵽaka simaraᵽaka be'erõ'õ ĩ'rĩka ángelte aiyakareka rĩkamaᵽakã'ã ñiaraᵽe. Wejeᵽemareka wiyua wayurika rabarika ba'arimajaka simamaka ikuᵽaka jãjirokaᵽi nare kẽrãᵽe: —Tuᵽarãte mijaro'si baaweirãka mija ĩara'abe. Kawaru boiareka tuyukate jããᵽaterãkakaka rẽrĩra'atirã ᵽo'imaja rabarika mija ba'araᵽe. Ĩᵽarimarã, suᵽabatirã jãjirã, kawarurãka, naᵽemaᵽi a'ririjayurãteoka suᵽabatirã surararãka ĩᵽarimarã, naᵽuᵽayariji imarijayurã, toᵽi i'suᵽakajaoka aᵽerãte ba'irabeĩjirimaja, imatiyarimaja, imatiyarimajamarĩrãoka nari'ia mija ba'araᵽe,— ángelte nare ãrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV19_19","096_19_19","REV","19","19","20","I'suᵽaka simaraᵽaka be'erõ'õ werikaᵽakiaki uᵽaka imaraᵽaki ritaja ĩᵽarimarã nasurararãkaᵽitiyika nare kirẽamaka ñiaraᵽe. Suᵽabatirã torã imaraᵽaki kijeyomakioka “Yi'i imaki Tuᵽarãro'si bojaĩjirimaji”, ãrĩkoᵽebaraka werikaᵽakiakite ĩaika wãjitãji maikoribeyua baabeawa'ri, werikaᵽakiaki jẽrãka jiyiᵽuᵽaka õrãᵽarã ᵽo'imajare, suᵽabatirã kiwãmea o'ojĩ'araᵽarãre kiᵽakiraᵽe. I'suᵽaka imaraᵽarãte rẽrãᵽe, kawaru ᵽemarã tuyuraᵽaki, suᵽabatirã kisurararãkaᵽitiyika ᵽitã'mua ko'aᵽi'yaokaro'si. Kawaru boika ᵽemarã tuyuraᵽaki naka jĩᵽaraka ĩ'ᵽarã ba'iaja baarimajare kiñi'araᵽe. Suᵽa imarĩ werikaᵽakiaki, suᵽabatirã, “Tuᵽarãro'si bojaĩjirimaji ñime”, ãrĩroyiraᵽakiteoka õñirãja ᵽeka azufreᵽi jũ'rẽiritarã nare kitaaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV19_21","096_19_21","REV","19","21","21","Suᵽabatirã ĩᵽarimarã, nasurararãkaᵽitiyika etaraᵽarãte ᵽuri kawaru boika ᵽemarã tuyuraᵽaki kirijokoᵽearã sara imaraᵽakaᵽi ba'iuᵽakaja nare jããᵽateraᵽaki. I'suᵽaka simamaka dajaka ima ba'aika wayurika koᵽakaja ña'ᵽiraᵽaka kijããᵽateraᵽarã ri'ia ba'abaraka. ");
INSERT INTO tnc_vpl VALUES ("RV20_1","096_20_1","REV","20","1","1","I'sia be'erõ'õ, mabo'ikakurirõ'õᵽi ᵽerumijia jo'baka, kajuyaiᵽakiaka uᵽaka ĩoikite kiᵽi'ᵽerũkia rikatirã ángelte ruira'amaka ñiaraᵽe. Suᵽabatirã koᵽea tiyibeyua ima kiwierũkiaoka kirikaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV20_2","096_20_2","REV","20","2","3","Ruietatirã kajuyaiᵽakiaka uᵽaka ĩoikite kiñi'araᵽe. Mia je'e mae, i'suᵽaka kibaaraᵽaki kime Satanás, bikija ãñaka uᵽaka ĩoiki ᵽo'ijiritirã ᵽakiroyirekaki. Kire ñi'atirã ᵽerumijiaᵽi ángelte kire ᵽi'ᵽeraᵽe, ñoaka mil rakakuri wejejẽ'rã rõ'õjĩrã koᵽea tiyibeyurõ'õrã kimaokaro'si. Suᵽabatirã sareka kire kitãteraᵽe ñoaka ᵽo'imajare ᵽakibekaja kimaokaro'si. I'sia be'erõ'õᵽi ᵽuri matikuriji kimaerã kire kija'ataerã baaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV20_4","096_20_4","REV","20","4","4","Toᵽi mae jã'mebaraka naruᵽairõ'õrã ruᵽajiyeraᵽarãte ñiaraᵽe. Mia je'e mae, Jesúre ye'kaririberiwa'ri, kimajaroka ja'atabeyurã, werikaᵽakiakire kijẽrãkaᵽitiyika jiyiᵽuᵽayeeberiwa'ri kiwãmea nakũ'arã, suᵽabatirã naᵽitakarã o'ojĩ'aberika mirãrã nimaraᵽe. Suᵽa imarĩ wãmua natoata'ruekarã imariᵽotojo, õñia jariᵽe'ritirã mil rakakuri wejejẽ'rãka Cristoka jã'merimaja nimaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV20_5","096_20_5","REV","20","5","5","Aᵽerã reyaekarã ᵽuri mil rakakuri wejejẽ'rãka kijã'merãka be'erõ'õrã õñia jariᵽe'rirũkirã imaraᵽarã. ");
INSERT INTO tnc_vpl VALUES ("RV20_6","096_20_6","REV","20","6","6","Suᵽa imarĩ wãmua natoata'ruekarãte mamarĩji õñia Tuᵽarãte jariᵽe'rirũjemaka jĩjimaka nimarãñu. Kire ã'mitiriᵽẽairã imarĩ, aᵽekurioka nareyabesarãñu. Suᵽa imarĩ Tuᵽarãte yaᵽaika kurarãkare baaika uᵽaka baarimaja nimarãñu. I'suᵽakaja Cristoro'sioka baarimaja imarĩ, mil rakakuri wejejẽ'rãka kika najã'merãñu. ");
INSERT INTO tnc_vpl VALUES ("RV20_7","096_20_7","REV","20","7","7","Mil rakakuri wejejẽ'rãka o'rirãka be'erõ'õ ja'atarũkika kime Satanás. ");
INSERT INTO tnc_vpl VALUES ("RV20_8","096_20_8","REV","20","8","9","Toᵽi ᵽoritirã Gog wãmeirã, suᵽabatirã Magog wãmeirãte kiyaᵽaika uᵽakaja baarũjebaraka kimarãñu ate. Gog, suᵽabatirã Magog koᵽakaja ritatojo wejeareka Tuᵽarãte yaᵽabeyutatarã nimarãñu. I'sirokaᵽi nare kiᵽakirãka ã'mitiritirã ritaja ka'iaᵽi narẽrĩrãñu, ᵽitã'mua Tuᵽarãrirãka ko'aᵽi'yaokaro'si. Tẽrĩrikaja rĩkimarã nimarãñu ritaja tatakarã ᵽo'imaja. Suᵽa imarĩ, Tuᵽarãte wãtaka õñurãre imaweje namoraᵽe. I'suᵽaka nabaako'omakaja ĩmiᵽi ᵽeka Tuᵽarãte kimajamarãre ña'atarãñu, nimauᵽatiji nooriyaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("RV20_10","096_20_10","REV","20","10","10","I'suᵽakajaoka ᵽeka azufreᵽi jũ'rẽiritarã Satanáre, ᵽo'imajare ᵽakirimajire, kitaarãñu. I'sia ruᵽubaji sarekajaoka werikaᵽakiaki, suᵽabatirã “Tuᵽarãte bojaĩjirimaji ñime”, ãrĩᵽakiroyikakite kitaaekarõ'õrã simaraᵽe. I'suᵽaka nare kibaamaka ĩmiareka, ñamiarekaoka ba'iaja jũarĩji torã nimarãñu. ");
INSERT INTO tnc_vpl VALUES ("RV20_11","096_20_11","REV","20","11","11","I'suᵽaka simaraᵽaka be'erõ'õ jo'baka tẽrĩriki ruᵽarikũmua boitaka imaraᵽakarã ĩ'rĩkate ruᵽamaka ñiaraᵽe. Ritaja ima bo'ibajirã tẽrĩrikiji kimamaka, kĩaraᵽaka wãjitãji ritatojo wejea riraᵽaka. I'suᵽaka baawa'ri aᵽekurioka maiberijĩka sajaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV20_12","096_20_12","REV","20","12","13","Riaᵽakiakarã ña'miririkarã ᵽuᵽamirãka suᵽabatirã reyaekarã ᵽuᵽamirãka tuikarõ'õrã ima ᵽoatirã õñia kijariᵽe'rirũjeraᵽe ate. Reyaeka mirãrã õñia jariᵽe'ritirã, torã ruᵽaraᵽaki wãjitãji narĩkajiyemaka ñiaraᵽe. Imatiyarimaja, imatiyabeyurãoka nimaraᵽe. Torã narĩkajiyeraᵽaka ᵽoto ᵽaᵽera ᵽũñu Tuᵽarãte wieraᵽe. I'siᵽũñurã ritaja ᵽo'imajare baaeka mirãka o'oeka imaraᵽaka. I'suᵽaka simamaka sareka ĩatirã, “Ikuᵽaka baaeka mirãrã mija ime”, torã ruᵽaraᵽakite nare ãrãᵽe. Suᵽabatirã “Ikarakamarã nime yika imarũkirã”, ãrĩwa'ri kio'oeka ᵽũñuoka kiwieraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV20_14","096_20_14","REV","20","14","15","I'sia be'erõ'õ reyaeka mirãrãte imaeka mirãrõ'õ rẽrãrĩ e'etirã ᵽeka azufreᵽi jũ'rẽiritarã Tuᵽarãte sataaraᵽe. Suᵽabatirã ᵽaᵽera ᵽũñurã “Ikarakamarã nime yika imajiᵽarũkirã”, ãñua kirikaraᵽaᵽũñurã nawãmea o'ojĩ'aberikarãte ĩatirã ᵽeka jũ'rẽiritarã nare kitaaraᵽe. I'suᵽaka baawa'ri aᵽekurioka nare kĩabesarãñu. ");
INSERT INTO tnc_vpl VALUES ("RV21_1","096_21_1","REV","21","1","1","Ritatajo ka'ia, riaᵽakiaka, wejeᵽema riraᵽaka be'erõ'õ, mamaka ate Tuᵽarãte ka'ia, wejeᵽema ᵽo'ijiamaka ñiaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV21_2","096_21_2","REV","21","2","2","I'suᵽaka simamaka jia oyiaja baabaraka nimarũkirõ'õ mamaka Jerusalén Tuᵽarã ᵽõ'iᵽi ruira'atirã saña'rĩᵽañamaka ñiaraᵽe. Ĩakõrĩ je'e: Rõmo ᵽitañi'aerã baaeka kotĩmite kore ĩajiyuokaro'si saya jia jããweitirã koima uᵽaka jiyurika imarõ'õ simaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV21_3","096_21_3","REV","21","3","3","I'suᵽaka sabaaraᵽaka be'erõ'õjĩte, Tuᵽarã ruᵽarikũmua imarõ'õᵽi ikuᵽaka jãjirokaᵽi sãrĩkoraᵽe: —Mija ĩabe. ¡Ᵽo'imajaka Tuᵽarãte ime mae! I'suᵽaka simamaka, “Mabo'ikakurireka Tuᵽarãte ime”, ãrĩrika imabeyua. Ᵽo'imajaka Tuᵽarãte ima simamaka, i'suᵽakajaoka nime naro'si, “Yija ĩᵽamaki mime”, kire ãᵽaraka. ");
INSERT INTO tnc_vpl VALUES ("RV21_4","096_21_4","REV","21","4","4","Tuᵽarãka imarimaja nimamaka reyarika, ba'iaja ᵽuᵽaririka, oririka, ã'mika najũakoᵽekaoka imabesarãka mae. Suᵽabatirã nare kijiyiᵽuᵽayeerãñu ate norikoreka. I'suᵽaka simarãñu bikija ba'iaja jũarika imakoᵽeka imabeᵽakã'ã,— sãrĩkoraᵽe mabo'ikakurirõ'õᵽi. ");
INSERT INTO tnc_vpl VALUES ("RV21_5","096_21_5","REV","21","5","5","Torãjĩrã kiruᵽarikũmuarã ruᵽatiirã ikuᵽaka Tuᵽarãte yire ãrĩkoraᵽe: —Miabe, ritaja bikija imakoᵽeroyireka, mamaka oyiaja sõ'toarã yo'ayu mae,— kẽrĩkoraᵽe. I'suᵽakajaoka, —Ika mire yibojaika uᵽakaja samio'obe. Mire ᵽakibeyuka yi'i. Mire yibojaika uᵽakaja ñamajĩ simarãñu,— yire kẽrĩkoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV21_6","096_21_6","REV","21","6","6","I'suᵽaka yire ãrĩweatirã, ikuᵽaka yire kibojakoraᵽe ate: —Koᵽakaja ritaja yijieyu mae. I'suᵽaka simamaka Alfa, Omega uᵽaka imaki ñime. Alfa ñime ñañu ritaja ᵽo'ijiaekaki imarĩ. I'suᵽakajaoka Omega ñañua “Ñamajĩ wejea tiyirũjerũkika ñime”, ãrĩrika sime. Okoa ukurika mare jitotiyaika uᵽaka yire ᵽuᵽajoatirã, yire jẽñeirãte ba'iaja najũaeka be'erõ'õ yiᵽõ'irã netarãka ᵽoto õñio okoa waᵽamarĩaja nare yisĩarãñu nimajiᵽaokaro'si. ");
INSERT INTO tnc_vpl VALUES ("RV21_7","096_21_7","REV","21","7","7","I'suᵽakajaoka yibaarãñu yire ã'mitiriᵽẽarija'atabesarãñurãte. Yire takaja jiyiᵽuᵽaka õrĩrãñurã ᵽuri, yimakarã uᵽakaja yika imarãñurã. ");
INSERT INTO tnc_vpl VALUES ("RV21_8","096_21_8","REV","21","8","8","Jesúre ã'mitiriᵽẽabeyurã ᵽuri ikuᵽaka baarijayurã: “Ᵽo'imajare mare ã'mijĩa'si”, ãrĩwa'ri kire ã'mitiriᵽẽabeyurã, i'suᵽakajaoka yiyaᵽabeyua baairã, ᵽo'imaja jããrimaja, nayaᵽaika uᵽakaja rõmitikaka wã'imarĩrijayurã, suᵽabatirã ᵽo'imajare bitarijayurãteoka wẽkomaka yibaarãñu. I'suᵽakajaoka waᵽuju imaja jẽrãka jiyiᵽuᵽayeeirã, suᵽabatirã ᵽakirimajareoka ᵽeka jũ'rẽiritarã nare yitaarãñu aᵽekurioka nare ĩakoreka,— yire kẽrĩkoraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV21_9","096_21_9","REV","21","9","9","I'suᵽaka simaraᵽaka be'erõ'õ ĩ'rĩka ángelte yiᵽõ'irã etaraᵽe. Iki imaraᵽaki ĩ'ᵽotẽñarirakamarãkaki ba'iaja ᵽo'imajare jũarũkia seroarã rikaeka mirãki. Mae, ikuᵽaka yire kẽrãᵽe: —Dajoa, Oveja weiwa'yua uᵽaka imaki rũmuro'si imarũkikote mire yibeaerã,— yire kẽrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV21_10","096_21_10","REV","21","10","10","I'suᵽaka yire kẽrãᵽaka be'erõ'õ, Esᵽíritu Santore yire jeyobaamaka ikuᵽaka yire sabearaᵽe: Ᵽusia jo'baka ĩmitakarãja ima ruᵽututuarã yire ke'ewa'raᵽe. Torã kika yeyaraᵽaka ᵽoto ba'iaja baarũkimato, mamaka Jerusalénwejea Tuᵽarã ᵽõ'iᵽi ruira'atirã saña'rĩᵽañaraᵽaka yire kibearaᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV21_11","096_21_11","REV","21","11","11","Mia je'e, i'siwejea ᵽuri Tuᵽarãte yaaboaikaᵽiji yaaboaiweje imaraᵽaka. I'suᵽaka imawa'ri ãta jasᵽe wãmeika jia waria mayoiwaᵽu'ataika uᵽaka õirõ'õ simaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV21_12","096_21_12","REV","21","12","13","I'sia wejerijerã jia ĩmirã jaarãkueka simaraᵽe. Suᵽabatirã ĩ'ᵽoũ'ᵽuarãe'earirakao koᵽerekaika simaraᵽe. Jã'ãtiᵽẽ'rõtoᵽi maekaraka koᵽereka, wayeruᵽitiᵽẽ'rõtoᵽi i'siaraka koᵽerekajaoka. Suᵽabatirã wejerĩrĩka ᵽẽ'rõtoᵽioka i'siraka koᵽereka, ma'karoka ᵽẽ'rõtoᵽi i'tojĩrãjaoka koᵽerekaika simaraᵽe. Israelkarã ĩ'ᵽoũ'ᵽuarãe'earirakatatarã imarã wãmea ĩ'rãba'iji koᵽereka rakakaja o'ojĩ'aeka imaraᵽaka. I'suᵽakajaoka koᵽereka rakakaja ĩ'rãrimaki ángelrãkare sareka rĩkaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV21_14","096_21_14","REV","21","14","14","I'suᵽaka simamaka, ãta ᵽããtateka õrĩa'si ãrĩwa'ri ĩ'ᵽoũ'ᵽuarãe'earirakao sajã'ãrã ãta jo'bari'okaᵽi turiruᵽamo'meka simaraᵽe. Ĩ'ᵽawãjoũ'ᵽuarãe'earirakamaki Oveja weiwa'yua uᵽaka imakite ᵽũataekarã, aᵽóstolrãka wãmea jĩ'ĩtaraᵽaka, nimaraᵽaka uᵽatiji ãta imaraᵽaka simamaka. ");
INSERT INTO tnc_vpl VALUES ("RV21_15","096_21_15","REV","21","15","15","Ángel yika jairaᵽaki wejea kijẽrãbaarũkia orokaka baaeka rikaraᵽaki, koᵽereka, suᵽabatirã ãta ᵽããtateka jẽrãbaarũkiaro'si. ");
INSERT INTO tnc_vpl VALUES ("RV21_16","096_21_16","REV","21","16","16","Suᵽa imarĩ sakijẽrãbaamaka, dos mil doscientorakakuri kilómetro rõ'õjĩrã oyiaja sajẽrãka simaraᵽe, sajo'baka, sañoakaoka. ");
INSERT INTO tnc_vpl VALUES ("RV21_17","096_21_17","REV","21","17","17","Ãta ᵽããtateka ᵽo'imajare jẽrãbaaikaᵽi sakijẽrãbaamaka, sesenta y cinco metros rõ'õjĩrã mo'rĩa simaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV21_18","096_21_18","REV","21","18","18","Jasᵽe wãmeika ãtakaka baaeka simaraᵽe wejea ãta ᵽããtateka. Suᵽabatirã aᵽeaᵽi rukebekaja orotakakaka baaekaweje simaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV21_19","096_21_19","REV","21","19","19","Suᵽabatirã ãta ᵽããtateka rokarã ĩ'ᵽoũ'ᵽuarãe'earirakao ãta ima, jia jiyurika ãta waᵽajã'rĩakaka baaeka simaraᵽe. Mamarĩkao, jasᵽe, jia waria ya'tarikakaka imaraᵽaka. Rokajĩkao zafiro wejeᵽema jĩ'mia uᵽaka imaraᵽaka. Ĩ'ᵽorokajĩkao wãmea ágata ᵽũñua uᵽaka jĩ'mia imaraᵽaka. Maekarakaorokajĩkao esmeralda imaraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV21_20","096_21_20","REV","21","20","20","Suᵽabatirã botarakaorokajĩkao ãta ónice jũ'aka boiaᵽitiyika yariraka imaraᵽaka. Ĩ'rãᵽitarakaorokajĩkao jia jũ'aka cornalina imaraᵽaka. Ĩ'rõtẽñarirakaorokajĩkao jũ'siᵽoa crisólito imaraᵽaka. Ĩ'ᵽotẽñarirakaorokajĩkao jĩ'mia berilo imaraᵽaka. Maekarakaotẽñarirokajĩkao jũ'siᵽoa toᵽacio imaraᵽaka. Botarakaotẽñarirokajĩkao crisoᵽrasa jĩ'miajaoka imaraᵽaka. Ᵽiyio bo'io wejeᵽema uᵽaka jĩ'mia ãta jacinto imaraᵽaka. Ᵽiyio imaraᵽaka amatista arebosiakaka. ");
INSERT INTO tnc_vpl VALUES ("RV21_21","096_21_21","REV","21","21","21","Ĩ'ᵽoũ'ᵽuarãe'earirakato koᵽereka ñiaraᵽe. Sarakakaja ĩ'rõ ᵽerlakaka baaeka simaraᵽe. Suᵽabatirãoka wejeñe'metãji imaraᵽaka ma'a aᵽeaᵽitiyika rukubekaja orotakakaka baaeka imaraᵽaka. ");
INSERT INTO tnc_vpl VALUES ("RV21_22","096_21_22","REV","21","22","22","I'sia wejeareka Tuᵽarãte jiyiᵽuᵽaka õrĩriwi'ia ĩatõᵽoberaᵽaki yi'i. Maiᵽamaki Tuᵽarã ritaja ima bo'ibajirã tẽrĩrikaja imaki, suᵽabatirã Oveja weiwa'yua uᵽaka imakiteoka naᵽõ'irãja nimamaka nayaᵽairõ'õrãja ᵽo'imajare nare jiyiᵽuᵽayeeraᵽe. I'suᵽaka simamaka nare jiyiᵽuᵽayeerũki wi'ia imabeyurõ'õ simaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV21_23","096_21_23","REV","21","23","23","I'suᵽakajaoka ritaja ima ᵽemawa'ribajirã jiitakiji Tuᵽarãte imaraᵽarõ'õ imarĩ, ikiji torã yaaboaraᵽaki. Suᵽabatirã Oveja weiwa'yua uᵽaka imakioka i'suᵽakajaoka kiyaaboaraᵽe. Suᵽa imarĩ aiyate yaaika, ñamikakite yaaboaikaoka yaᵽabeyurõ'õ simaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV21_24","096_21_24","REV","21","24","24","I'sia wejea yaaboaikaᵽi ritatojo wejeareka imarãte jia imarijarirãñu. Niᵽarimarã narikarijayua waᵽajã'rĩa imatiyaikakaka e'era'atirã Tuᵽarãte nijirãñu kire jiyiᵽuᵽaka õrĩwa'ri. ");
INSERT INTO tnc_vpl VALUES ("RV21_25","096_21_25","REV","21","25","25","I'suᵽaka nabaarũkirõ'õ imarĩ, wiekaja koᵽereka imajiᵽarijarirũkirõ'õ simarãñu. I'suᵽaka simarãñu ñamia imabesarãñurõ'õ imarĩ. ");
INSERT INTO tnc_vpl VALUES ("RV21_26","096_21_26","REV","21","26","26","Torã ritaja waᵽajã'rĩa imatiyaikakaka ritatojo wejeareka imarãoka narikaika e'era'atirã Tuᵽarãte nijirãñu kire jiyiᵽuᵽayeewa'ri. ");
INSERT INTO tnc_vpl VALUES ("RV21_27","096_21_27","REV","21","27","27","I'suᵽaka simamaka Tuᵽarãte yaᵽabeyua imarũkimarĩrõ'õ imarĩ ba'iaja baarimaja, ᵽakirimajareoka sakãkabesarãñu. Oveja weiwa'yua uᵽaka imaki ᵽaᵽera ᵽũñurã, “Ikarakamarã nime yika imarũkirã”, ãrĩwa'ri nawãmea sareka o'ojĩ'aekarã takaja kãkarũkirõ'õ simarãñu. ");
INSERT INTO tnc_vpl VALUES ("RV22_1","096_22_1","REV","22","1","1","I'suᵽaka yire kibearaᵽaka be'erõ'õ, jia waria ima riaka õñio okoraka imajiᵽarũkiria ángelte yire bearaᵽe. Tuᵽarã ruᵽarikũmua, suᵽabatirã Oveja weiwa'yua uᵽaka imaki ruᵽarikũmuarã saruᵽaka imaria simaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV22_2","096_22_2","REV","22","2","2","Wejeñe'metãji ma'a imaraᵽakarã sañe'metãjite juruteᵽaria simaraᵽe. Suᵽabatirã i'siriarijereka ĩ'ᵽaᵽẽ'rõto wã'tarãja õñio yaᵽua rĩkajiyeraᵽaka. Ĩ'rĩka aiya o'atarimarĩaja ruirijayua simamaka, ĩ'rãkuri wejejẽ'rãkareka ĩ'ᵽoũ'ᵽuarãe'earirakakuri ruirijayua simaraᵽe. Ritatojo wejeareka imarãte jiiokaro'si õñioka simaraᵽe saᵽũñua. ");
INSERT INTO tnc_vpl VALUES ("RV22_3","096_22_3","REV","22","3","3","Suᵽabatirã Tuᵽarãte ĩariᵽe'yoika imabeyurõ'õ simamaka, “Ba'iaja simarũ”, kẽrĩrũkimato simarãñu. Torã Tuᵽarãrika, suᵽabatirã Oveja weiwa'yua uᵽaka imaki ruᵽarikũmua imarãka. I'suᵽaka simamaka ritaja torã imarãñurã Tuᵽarãte yaᵽaika uᵽaka oyiaja baabaraka kire najiyiᵽuᵽayeerijarirãñu. ");
INSERT INTO tnc_vpl VALUES ("RV22_4","096_22_4","REV","22","4","4","Maekaka maki Tuᵽarãte ĩabeyua simako'omakaja, wejea mamaka kiᵽo'ijiarãñurõ'õrã ᵽuri kire ĩarika imarãka. Suᵽabatirã kiwãmea nakũ'areka kio'ojĩ'arãñu. ");
INSERT INTO tnc_vpl VALUES ("RV22_5","096_22_5","REV","22","5","5","Suᵽabatirã maiᵽamaki Tuᵽarãja nare kiyaaboarãñurõ'õ imarĩ, aiyaka, yaaboaika yaᵽabeyurõ'õ simarãñu. Suᵽabatirãoka ñamia imabeyurõ'õ simarãñu. I'suᵽakajaoka torã kika jã'mebaraka nimajiᵽarãñu. ");
INSERT INTO tnc_vpl VALUES ("RV22_6","096_22_6","REV","22","6","6","I'sia be'erõ'õ ikuᵽaka ángelte yire ãrãᵽe ate: —Ritaja makãrãrũñuroka uᵽakaᵽi Tuᵽarãte mire ĩarũjeika, mire kiã'mitirirũjeikaoka rita ima. I'suᵽaka simamaka ritaja mire yibojaika uᵽakaja simarãñu. Maiᵽamaki Tuᵽarã imaki kiro'si bojaĩjirimajare jia jaiwãrũerã nare jeyobaarijayuka. I'suᵽaka imaki imarĩ, ikijioka imaki ika ritaja mire yibojaerã yire ᵽũataraᵽaki,— yire kẽrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV22_7","096_22_7","REV","22","7","7","Suᵽabatirã ikuᵽaka yire kẽrãᵽe ate: —Ikuᵽaka Jesúre ãñu: “Mija ã'mitiᵽe. Ñojimarĩji mija ᵽõ'irã ya'rirãñu ate. I'suᵽaka simamaka, ika majaroka ‘Ikuᵽaka simarãñu’, ãrĩwa'ri Tuᵽarãte bojaekakaka o'oeka ᵽũñurã yi'yurã jĩjimakaᵽi imarãñurã”, kẽrĩbojayu,— ángelte yire ãrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV22_8","096_22_8","REV","22","8","8","Juan ñime ika ritaja ĩatirã, sã'mitiritirãoka so'oiki. Ángelte yire sabearaᵽaka ᵽoto jiyiᵽuᵽaka kire õrĩwa'ri kiwãjitãji yimo'iᵽãñaraᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV22_9","096_22_9","REV","22","9","9","Ikuᵽaka ᵽuri yire kẽrãᵽe: —Mimo'iᵽãña'si. Miuᵽakaja Tuᵽarãte yaᵽaika uᵽakaja baaiki ñime yiro'sioka. Tuᵽarãro'si bojaĩjirimaja, suᵽabatirã ika ᵽaᵽera ᵽũñu o'oeka yi'yurã uᵽakaja imaki ñime. I'suᵽaka simamaka, Tuᵽarãte takaja mijiyiᵽuᵽayeebe,— ángelte yire ãrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV22_10","096_22_10","REV","22","10","10","Torãjĩrã ate ikuᵽaka yire kẽrãᵽe: —Ika majaroka mio'oika, ᵽo'imajare miõrĩrũjebe, samio'oika uᵽakaja simarũkia koyiaja jariwa'yua simamaka. ");
INSERT INTO tnc_vpl VALUES ("RV22_11","096_22_11","REV","22","11","11","Koyiaja sajariwa'ᵽakã'ã, ba'iaja baarimaja ᵽuri nima uᵽakaja nabaarijaririyaᵽaye'e nayaᵽaika uᵽakaja nimaᵽarũ. I'suᵽakajaoka ba'iaja ᵽuᵽajoairã naᵽuᵽaka nare ãñu uᵽakaja naᵽuᵽajoaᵽarũ. Suᵽabatirã “Jia baairã nime”, Tuᵽarãte nare ãñurã ᵽuri jĩjimaka kiyaᵽaika baabaraka nimarũ. I'suᵽakajaoka Tuᵽarãte jiyiᵽuᵽaka õrĩwa'ri ba'iaja baarika ja'atarika yaᵽairãja sanaja'atarijarirũ,— ángelte yire ãrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV22_12","096_22_12","REV","22","12","12","Ikuᵽaka Jesúre ãrãᵽe: —Mija ĩabe. Ñojimarĩji mija ᵽõ'irã ya'rirãñu ate. Mija ᵽõ'irã eyatirã ᵽo'imajare baaeka uᵽakaja jia baaekarãte, i'suᵽakajaoka ba'iaja baaekarãte simauᵽakaja sawaᵽa nare yibaarãñu. ");
INSERT INTO tnc_vpl VALUES ("RV22_13","096_22_13","REV","22","13","13","I'suᵽaka yibaarãñu Alfa, Omega uᵽaka imaki imarĩ. Yi'iᵽi ãrĩwa'riji ritaja simaũ'mueka. Suᵽabatirã yi'iᵽi ãrĩwa'rijioka ritaja ima tiyirãka. ");
INSERT INTO tnc_vpl VALUES ("RV22_14","096_22_14","REV","22","14","14","Ba'iaja nabaaika jũjerũjekarã saya uᵽaka ima jariroaka ka'imarĩa jããirã uᵽaka imarã. Ĩ'rãtarãja imarã wejea mamaka Tuᵽarãte ᵽo'ijiarãñurõ'õrã kãkarũkirã. Suᵽabatirãoka torã eyatirã õñio yaᵽurika ba'arũkirã. I'suᵽaka imarãñurã imawa'ri, jĩjimaka torã nimarijarirãñu. ");
INSERT INTO tnc_vpl VALUES ("RV22_15","096_22_15","REV","22","15","15","Mia je'e: Aᵽerãte bitarijayurã, nare sajitoika uᵽakaja aᵽerãka wã'imarĩrijayurã, ᵽo'imajare jããrijayurã, waᵽuju imaja jẽrãka jiyiᵽuᵽayeeirã, suᵽabatirã ᵽakirikaᵽiji imarijayurã, Tuᵽarãte yaᵽabeyua baawa'ri, kiᵽõ'irã aᵽekurioka eyabesarãñurã. ");
INSERT INTO tnc_vpl VALUES ("RV22_16","096_22_16","REV","22","16","16","I'suᵽaka simamaka yi'i, Jesús, i'sia majaroka mijare ángelte bojaerã kire yiᵽũataeka, yire yi'riwa'ri rẽrĩrijaᵽaraka jĩjimakaᵽi sõrĩwãrũrijayurã mija imamaka. David imaroyikaki riᵽarãmi mirãki ñime. Yireka ᵽuᵽajoaweitirã “Wãrĩrika ru'ara'aerã baaika ruᵽujĩte warara'aiki tã'ᵽia jo'baki uᵽaka Tuᵽarãte ᵽũatarãki kimarãñu”, Moisés imaekakite o'oeka,— Jesúre ãrãᵽe. ");
INSERT INTO tnc_vpl VALUES ("RV22_17","096_22_17","REV","22","17","17","Esᵽíritu Santo, suᵽabatirã Oveja weiwa'yua uᵽaka imaki jeyomako ĩ'rãtiji oyiaja jairã. —Mija i'tabe Cristore yi'yurã mija jayaokaro'si,— ᵽo'imajare nañu. I'suᵽakajaoka aᵽerãte narĩrũ sã'mitiyurã naro'si. —Õñio okoa ukurika mijare jitomaka, waᵽamarĩaja sukurĩ mija i'tabe,— nañu. ");
INSERT INTO tnc_vpl VALUES ("RV22_18","096_22_18","REV","22","18","18","—Ika ᵽaᵽera jaiika ã'mitiririjarirãñurãte, yi'i, Jesús ikuᵽaka nare sabojarijayuka: Ika ᵽaᵽera ᵽũñurã o'oeka ima ᵽemawa'ribaji noñu uᵽakaja ᵽuᵽajoatirã o'orãñurãte ba'iaja Tuᵽarãte baarãñu ika ᵽaᵽera ᵽũñurã ãñu uᵽakaja. ");
INSERT INTO tnc_vpl VALUES ("RV22_19","096_22_19","REV","22","19","19","Suᵽabatirã ika ñañua waᵽuju ᵽakibaraka ĩ'rãriba'i e'etairã õñio yaᵽurika ba'arũkimarĩrã nimarãñu. I'suᵽaka imarãñurã imarĩ, wejea mamaka Tuᵽarãte ᵽo'ijiarãñurõ'õrã eyarũkimarĩrã nime. Iᵽũñurã ñañu uᵽakaja simarãñu ba'iaja baarimajaro'si. ");
INSERT INTO tnc_vpl VALUES ("RV22_20","096_22_20","REV","22","20","20","“Rita iᵽũñurã sãñu”, ãñuka imarĩ, “Ñojimarĩji mija ᵽõ'irã ya'rirãñu ate”,— Jesúre ãñu. —Meñu uᵽakaja simarũ. Mi'tabe Ñiᵽamaki Jesús,— mire ñañu. ");
INSERT INTO tnc_vpl VALUES ("RV22_21","096_22_21","REV","22","21","21","Maiᵽamaki Jesús ritaja jia oyiaja Tuᵽarãrirãte kibaarũ. I'suᵽaka oyiaja simarijarirũ. I'tojĩrãja sime ruᵽu.");
ALTER TABLE tnc_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
