﻿USE sofia;
DROP TABLE IF EXISTS sofia.tnaNT_vpl;
CREATE TABLE tnaNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tnaNT_vpl WRITE;
INSERT INTO tnaNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristo da David, Abraham chenu detse sa familia jenetia bataji puana. Beju ye cuana da pamapa mecuana sa ebani cuana derejiji yani Abraham chenu peje jenetia epupiruani. ");
INSERT INTO tnaNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham chenu da Isaac chenu sa tata puidha. Isaac chenu da Jacob chenu sa tata puidha. Jacob chenu da Judá chenu sa tata puidha. ");
INSERT INTO tnaNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá chenu da Fares chenu, Zara chenu detse sa tata puidha. Tamar chenu da tuatse sa cuara puidha. Fares chenu da Esrom chenu sa tata puidha. Esrom chenu da Aram chenu sa tata puidha. ");
INSERT INTO tnaNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram chenu da Aminadab chenu sa tata puidha. Aminadab chenu da Naasón chenu sa tata puidha. Naasón chenu da Salmón chenu sa tata puidha. ");
INSERT INTO tnaNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón chenu da Booz chenu sa tata puidha. Rahab chenu da Booz chenu sa cuara puidha. Booz da Obed chenu sa tata puidha. Rut chenu da Obed chenu sa cuara puidha. Obed chenu da Isaí chenu sa tata puidha. ");
INSERT INTO tnaNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí chenu da echua puji David chenu sa tata puidha. Da su piada tunca pushi ejaitiana familia cuana jaitianatana. David, Betsabé chenu detse da Salomón chenu sa tata detse puidha. Betsabé chenu da Urías chenu sa ehuane puidha. ");
INSERT INTO tnaNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón chenu da Roboam chenu sa tata puidha. Roboam chenu da Abías chenu sa tata puidha. Abías chenu da Asa chenu sa tata puidha. ");
INSERT INTO tnaNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa chenu da Josafat chenu sa tata puidha. Josafat chenu da Joram chenu sa tata puidha. Joram chenu da Uzías chenu sa tata puidha. ");
INSERT INTO tnaNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías chenu da Jotam chenu sa tata puidha. Jotam chenu da Acaz chenu sa tata puidha. Acaz chenu da Ezequías chenu sa tata puidha. ");
INSERT INTO tnaNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías chenu da Manasés chenu sa tata puidha. Manasés chenu da Amón chenu sa tata puidha. Amón chenu da Josías chenu sa tata puidha. ");
INSERT INTO tnaNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías chenu da Jeconías chenu sa tata puidha. Da tiempo su Jeconías mebajataina templo su. Da tiempo su Babilonia soldado cuana ja pamapa israelita cuana eteri puji dusutana Babilonia yahua su. Da su piada tunca pushi ejaitiana familia cuana jaitianatana. ");
INSERT INTO tnaNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jeconías chenu da Salatiel chenu sa tata puidha. Salatiel chenu da Zorobabel chenu sa tata puidha. ");
INSERT INTO tnaNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel chenu da Abiud chenu sa tata puidha. Abiud chenu da Eliaquim chenu sa tata puidha. Eliaquim chenu da Azor chenu sa tata puidha. ");
INSERT INTO tnaNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor chenu da Sadoc chenu sa tata puidha. Sadoc chenu da Aquim chenu sa tata puidha. Aquim chenu da Eliud chenu sa tata puidha. ");
INSERT INTO tnaNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud chenu da Eleazer chenu sa tata puidha. Eleazer chenu da Matán chenu sa tata puidha. Matán chenu da Jacob chenu sa tata puidha. ");
INSERT INTO tnaNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob chenu da José sa tata puina. José da María sa yahue puina. María da Jesús sa cuara puina. Beju Jesús da Cristo. ");
INSERT INTO tnaNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Beju piada tunca pushi ejaitiana familia cuana putaidha Abraham chenu jenetia David chenu teje. David chenu jenetia Babilonia soldado cuana ja pamapa israelita cuana Babilonia yahua su dusutana teje beju piada tunca pushi ejaitiana familia cuana putaidha. Israelita cuana dusutana huecuana jenetia Cristo bataji puana teje beju piada tunca pushi ejaitiana familia cuana putaidha ");
INSERT INTO tnaNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Beju uja Jesús bataji puana: Mesa cuara María ja José yahueti jamitsuti tiatana. José neje jahuetiji mahue su hue, Espíritu Santo ja María dheji ametana. ");
INSERT INTO tnaNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Beju José ja María dheji shanapatana su, María neje jameseatija pudhaana. Tueda da deja saida, butsepi putsu, tsada mahue batana cristiano cuana bahue paputa puji. Da putsu, cuatsa mahue María neje jameseatija pudhaana. ");
INSERT INTO tnaNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Beju José ja tueda ai cuana epibatani cama, Diusu sa ángel ja tueda tahui su uja atana: —José, David chenu sa ebacua, be tsada mahue baji María neje ehuaneti puji. Tueda tusa yanana bataji epu da Espíritu Santo jenetia beju. ");
INSERT INTO tnaNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","María da piada ebacua chidi ebacuinati. Tueda yanana chidi sa Jesús ebani miada eicha. Daja da banime epu, tusa cristiano cuana tuna sa jucha cuana jepuiti d'eji su yameta putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Beju daja da tueda ai cuana puana, cuaja Diusu sa profeta Isaías chenu ja biahua tiempo deretaidha batame. Uja deretaidha: ");
INSERT INTO tnaNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Deja shanapa bue mahue epuna da dheji epu. Ebacuinati piada ebacua. Tueda ebacua sa ebani da Emanuel epu. Tueda ebani da, “Diusu ecuana neje yani”, epuani. ");
INSERT INTO tnaNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Beju José id'ecuina putsu, cuaja ángel ja tahui su tueda cuatsasiatana nime, daja atana. María neje jahuanetiana. ");
INSERT INTO tnaNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Jahuanetiana biame, José ja María aimue ehuane nime quinatana mahue yanana chidi bataji puana teje. Beju yanana bataji puana su, José ja Jesús ebani ichatana. ");
INSERT INTO tnaNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús da Belén ejude su bataji puana. Tueda ejude da Judea provincia su anina. Da tiempo su Jesús bataji puana su, dapia echua puji Herodes banime anina. Da su beju bahue eni deja cuana pia yahua uqueda id'eti ecuinanani bene jenetia Jerusalén ejude su cuinatana. ");
INSERT INTO tnaNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Cuina putsu, uja quisabatana huecuana: —¿Quepia da judío cuana sa echua puji bataji puana? Beju ecuanaju sa yahua jenetia atujai ecuanaju bana. Tueda atujai jepuiti yanana bataji puana ecuanaju bahue puana. Da putsu beju, ecuanaju pueitia tu emitsutsua puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Beju bahue eni deja cuana ja daja quisabatana putsu, Herodes japibatipeitiana, tueda da judío cuana sa echua puji putsu. Pamapa cristiano cuana Jerusalén ejude quitana di japibatipeititana. ");
INSERT INTO tnaNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Da su beju Herodes ja pamapa judío sacerdote cuana sa echua puji cuana ihuatana. Pamapa Moisés chenu sa jacuatsasiati ebuetsuaji cuana di ihuatana. Beju uja quisabatana huecuana: —¿Quepia da Diusu sa Jabeituti Deja bataji epu? ");
INSERT INTO tnaNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Da su uja jeutsutana huecuana: —Beju Belén ejude, Judea provincia su bataji epu, cuaja Diusu sa profeta Miqueas chenu ja biahua tiempo deretaidha batame. Uja deretaidha: ");
INSERT INTO tnaNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Belén ejude da Judea provincia su ejude huai chidi papu biame, ejude aida epu, tueda ejude jenetia Echua Puji ecuinana putsu. Tuahueda quema israelita cristiano cuana saida ecuatsasiatayu. Daja deretaidha profeta Miqueas chenu ja. ");
INSERT INTO tnaNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Da su Herodes ja bahue eni deja cuana cuatsa mahue ihuatana. Quisabatana huecuana ai tsine su ai hora su atujai bapirutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Quisabape putsu, beju bahue eni deja cuana Belén ejude su beitutana. Uja atana huecuana: —Meputique dapia ejude su. Mequisachacutique tueda yanana jepuiti. Teje putsu, mequisaque ema yama di tu emitsutsuati puji. Tuna ebaseainia je, Herodes ja daja quisatana huecuana, yanana Jesús manuameja adhaatana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Da su bahue eni deja cuana echua puji Herodes id'abape putsu, putitana huecuana. Beju mecuana sa yahua jenetia tuna bapirutana atujai tuna hui su putiana tuna ehuidusu puji. Daja putiana atujai yanana Jesús yani teje. Dapia da netiseuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Bahue eni deja cuana ja dapia atujai netiseuana ba putsu, beidaji putana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ete su enubihu je, yanana Jesús batana huecuana tusa cuara María neje. Ba putsu, janana chidi butse su tururutana huecuana tu emitsutsua puji. Oro, incienso, mirra yanana tiatana huecuana. Tueda tiajiji ai cuana chujeneda saida puina. ");
INSERT INTO tnaNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Da su beju Diusu ja bahue eni deja cuana tahui su cuatsasiatana Herodes peje je pasiapatita mahue huecuana puji. Da putsu, jasiapatitaibana huecuana tuna sa yahua su pia edid'i je. Aimue echua puji Herodes quisa atana huecuana mahue yanana Jesús jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Beju bahue eni deja cuana jasiapatitaibana su, Diusu sa ángel José peje su tahui su bataji puana. Uja cuatsasiatana José: —Tipeida netianaque. Yanana, mesa cuara neje jududuque Egipto yahua su. Dapia meanitique yama mi neicha equisa teje. Beju Herodes ja yanana Jesús echacutani tu emanuame puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Da su José netianana. Yanana Jesús, mesa cuara neje da dhidha su tipeida putiana Egipto yahua su. ");
INSERT INTO tnaNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Dapia Egipto yahua su anititana huecuana Herodes emanu teje. Beju daja puana, cuaja Diusu sa profeta chenu ja biahua tiempo deretaidha batame. Uja Diusu sa profeta Oseas chenu deremetaidha: “Egipto yahua jenetia quema ebacua yama siapameibana.” ");
INSERT INTO tnaNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Beju bahue eni deja cuana ja Herodes mue jei a atana putsu, Herodes ebia su duininiana. Pamapa Belén ejude su aniji beta maraji teje deja yanana cuana manuamemetana. Pamapa Belén ejude naja su aniji beta maraji teje deja yanana cuana di manuamemetana. Daja Herodes ja deja yanana cuana manuamemetana, beta mara beju bahue eni deja cuana ja atujai bapirutana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Pamapa tueda ai cuana daja puana, cuaja Diusu sa profeta Jeremías chenu ja biahua tiempo deretaidha batame. Uja deretaidha: ");
INSERT INTO tnaNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramá ejude su aniji cristiano cuana ebia su epadarititani. Cuaja paciencia pu taji mahue jabatitana huecuana, yanana chidi cuana manutana putsu. Daja profeta Jeremías chenu ja deretaidha. ");
INSERT INTO tnaNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Da su beju Herodes manuana su, Diusu sa ángel neicha tahui su José peje su bataji puana, Egipto yahua su anina su. Uja ángel ja José cuatsasiatana: ");
INSERT INTO tnaNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Beju netianaque. Yanana, mesa cuara neje jasiapatique Israel yahua su. Yanana Jesús manuameja pudhaana Herodes beju manujiji. ");
INSERT INTO tnaNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Da su beju José ja yanana, mesa cuara neje Israel yahua su jasiapatibana. ");
INSERT INTO tnaNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Beju da tiempo su Herodes chenu sa ebacua Arquelao banime da Judea provincia su echua puji puina mesa tata chenu eturuca. José da Arquelao echua puji epuani bahue pu putsu, iyuame puana Belén ejude su esiapati puji. Da su ángel neicha tahui su José peje su bataji puana. “Be Judea provincia su meputiji”, ángel ja cuatsasiatana. Da su José Galilea provincia su putiana yanana, mesa cuara neje. ");
INSERT INTO tnaNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Galilea su cuinati putsu, Nazaret ejude su anititana huecuana. Beju daja pamapa tueda ai cuana puana, cuaja Diusu sa profeta chenu cuana ja deretaidha batame. Cristiano cuana ja Jesús, “Nazareno”, yata, deretaidha huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Da tiempo su Juan Bautista d'anita yahua su Judea yahua su cristiano cuana quisaquisa atanetina. ");
INSERT INTO tnaNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Uja quisaquisa punetina: —Diusu peje su mepibaturucatique, Diusu ecuatsasiati beju enariatiani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Biahua tiempo da Diusu sa quisa puji Isaías chenu ja deretaidha Juan jepuiti. Uja deretaidha: Piada etsui jubida d'anita yahua su uja epuani: “Mebasetatique Echua Puji epue su puji.” ");
INSERT INTO tnaNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Beju Juan sa ejud'uji da camello einua etad'i jenetia, mesa eturisiji ebiti jenetia puina. Dhequere aida, huasa ena diataina. ");
INSERT INTO tnaNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Pamapa Jerusalén ejude su, Judea yahua su Jordán ena naja je aniji cuana tu peje su pue bahue putaina tu eid'aba puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Pamapa Diusu peje su tuna sa jucha cuana jatuaquisatitana cuana Juan ja yahui neje ichaderatana Diusu sa puji Jordán ena su. ");
INSERT INTO tnaNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Juan ja fariseo, saduceo cuana dapia eneti batana putsu, uja atana huecuana: —Micuaneda da bacua d'aida cuana nime. Micuaneda ema peje su epusiu yahui neje Diusu sa puji eichaderameti puji Diusu sa castigo jubida jenetia ejududu puji. Beju micuaneda mu Diusu peje su japibaturucatija mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Da su beju equene mepibaturucatique Diusu peje su. Saida, butsepi mepuniunetique, yahui neje jaichaderatiji mahue su. ");
INSERT INTO tnaNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Be ebia su aida mebatiji, micuaneda da Abraham chenu sa familia jenetia biame. Da neje mu mue ai biame beju. Yama micuana butsepi equisainia, Diusu ja ye tumu cuana di Abraham chenu sa ebacua cuana tsa piata cua. ");
INSERT INTO tnaNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Beju hacha basetajiji eneti aqui cuana eque puji. Pamapa equi cuana ejaja saida pu bue mahue equepeta. Cuati su ed'ed'apeta pamapa. Daja Diusu ja yatayu tu peje su japibaturucatija mahue cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Enei hue, yama Diusu peje su japibaturucatijiji cuana yahui neje eichaderainia Diusu sa puji. Daja yama yahui neje eichaderainia huecuana ene quita japibaturucatitana Diusu sa puji ebame puji. Yama yahui neje micuana eichaderainia biame, pia epusiu ema tije. Tuahueda micuana eichaderata Diusu sa puji Espíritu Santo sa tucheda neje. Tueda da ema ebia su huaraji tucheda putsu, aimue ema tupu mahue tu emebaja puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tueda epusiu cristiano cuana arusa pu cua nime etsabihue puji. Ejaja chujemame eichaderata etsabi jenetia. Ejaja beju eichasetata tusa ichaseta jude ete su. Etsabi mu da cuati su ed'ed'ata. Beju pamapa tu peje su jei eputani cuana da ejaja nime. Diusu neje cielo su yanienititayu huecuana. Pamapa tu jei aja mahue yatani cristiano cuana da etsabi nime. Cuati castigo su epuenititayu huecuana. Dapia cuati da tiju bue mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Da su beju Jesús Jordán ena su pueana Galilea yahua jenetia. Juan peje su pueana Juan ja tu yahui neje paichaderata puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Beju equene su Juan ja aimue aja atana mahue. Uja tuahueda Jesús atana: —Beju miqueda ema yahui neje Diusu sa puji ichadera taji biame, mida ema peje su pueitia yama mi yahui neje eichadera puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Da su Jesús ja Juan uja atana: —Daja hue aque, yama mi ecuatsasiainia nime. Pamapa Diusu sa jacuatsasiati cuana etse sa a taji. Da su Juan ja Jesús Diusu sa puji ichaderatana yahui neje. ");
INSERT INTO tnaNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesús ena jenetia cuinanana su, cielo jadhatiana. Espíritu Santo ebuteni huaitucu nime beju Jesús ja batana. Tueda Jesús bia su netiuteana. ");
INSERT INTO tnaNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Da hora su Diusu cielo jenetia uja puana: —Ye da quema ibuneda ebacua. Tu neje ema beidaji. ");
INSERT INTO tnaNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Da su beju Espíritu Santo ja Jesús d'anita yahua su dusutana Ishahua ja papirubata puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Dapia d'anita yahua su Jesús dhemanuana, pushi tunca tsine diadiaji mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Da su Ishahua ja tueda nariatana tu epiruba puji. Tuahueda Jesús uja atana: —Ahua mida Diusu sa ene quita ebacua su, cuatsasiaque ye tumu cuana ai dia taji cuana su patsapiati. ");
INSERT INTO tnaNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Da su Jesús ja uja Ishahua jeutsutana: —Aimue daja yama ya mahue. Uja derejiji yani: “Aimue cristiano cuana ai dia taji cuana neje bahui eid'e yanita mahue. Pamapa Diusu sa mimi neje di eid'e yanita huecuana.” ");
INSERT INTO tnaNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Da su Ishahua ja Jesús Jerusalén ejude sa templo matina du dusutana. ");
INSERT INTO tnaNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Dapia Jesús uja atana: —Ahua mida Diusu sa ene quita Ebacua su, tenaque yahua su u jenetia, uja derejiji yani putsu: Diusu ja ángel cuana ecuatsasiata mi painatsihuata huecuana puji. Tuna sa eme neje mi einatsuta huecuana mique ehuatsi tumu su edhapujuti mahue puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Da su Jesús ja Ishahua uja jeutsutana: —Aimue yama daja ya mahue. Daja huecha uja derejiji yani: “Be abaji mique Diusu.” ");
INSERT INTO tnaNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Da su Ishahua ja Jesús dusutana emata bauda matina su. Da jenetia pamapa ye mundo sa ejude aida cuana Jesús bametana. ");
INSERT INTO tnaNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Uja Ishahua ja atana: —Ahua mida ema butse su, tururu putsu, ema emitsutsua su, yama mi pamapa ye ejude aida cuana etiape miada ecuatsasia puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Da su Jesús ja Ishahua uja jeutsutana: —Netideraque ema naja jenetia, Ishahua. Daja huecha derejiji yani: “Mique Diusu bahui mitsutsua taji. Tueda bahui mique mebaja taji.” ");
INSERT INTO tnaNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Da su beju Ishahua netiderana Jesús peje jenetia. Netiderana su, ángel cuana Jesús peje su cuinatana tu emebaja puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Beju Juan Bautista terijiji yani Jesús bahue puana su, Galilea yahua su putiana. ");
INSERT INTO tnaNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazaret ejude su cuinati putsu, jaitianana Capernaum ejude su dapia yaniti puji. Tueda ejude da bai maje su anina. Tueda ejude da Zabulón, Neftalí yahua detse naja su anina. ");
INSERT INTO tnaNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Beju tueda ai cuana puana, cuaja Isaías chenu ja biahua tiempo deretaidha batame. Uja deretaidha: ");
INSERT INTO tnaNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabulón yahua su aniji cuana ja hueda jubida batana. Daja huecha Neftalí yahua su aniji cuana ja batana. Tueda yahua detse da Galilea yahua, Jordán ena chu maje yani. Dapia dueji judío mahue cuana yani. ");
INSERT INTO tnaNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Tuneda apuda su yani biame, beju hueda jubida batana huecuana. Manu su hue yanita huecuana biame, beju Diusu sa hueda tuna peje su cuinana. ");
INSERT INTO tnaNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Da tsine jenetia da Jesús quisaquisa pupiruana uja: —Mepibaturucatique, Diusu ecuatsasiati beju enariatiani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesús ja Galilea bai maje je epuhu je, beta deja detse batana. Piada Simón Pedro banime. Pia Andrés banime. Tuatseda edue tatse puina. Esia puji putsu, tarrafa siatasaina tse bai su. ");
INSERT INTO tnaNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesús ja uja atana tse: —Metseda se cuana jemi bahue. Ema tije meaque. Jiahue jenetia yama metseda cristiano cuana ema peje su duseji yame. ");
INSERT INTO tnaNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Da hora su hue tarrafa cuana ichajusiatana tse Jesús ebuque puji. Beju putiana tse Jesús neje. ");
INSERT INTO tnaNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Chuadera pad'i puti putsu, Jesús ja pia beta deja detse batana. Piada Jacobo banime. Pia Juan banime. Tuatseda edue tatse puina. Tuatse sa tata Zebedeo banime. Canoa aida su netina tuatse sa tata neje. Tarrafa cuana jabasetatitasaina huecuana. Jesús ja ihuatana tse. ");
INSERT INTO tnaNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Da su beju tuatseda metse sa tata canoa su ichajusiatana Jesús ebuque puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Beju Jesús da pamapa Galilea yahua je putiana. Pamapa jadhitati jude ete cuana su cristiano cuana buetsuatana. Diusu ecuatsasiati jepuiti quisaquisa puana. Pamapa cristiano cuana sa tsapiapiati chiqui cuana saisiametana. ");
INSERT INTO tnaNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Siria yahua su aniji cristiano cuana di Jesús jepuiti bahue putana. Pamapa tsapiapiati chiquiji, nedaji cuana dusutana huecuana Jesús peje su. Einid'u madhadaji, riaria neje enimetaitanani, ase bue mahue cuana dusutana huecuana. Beju Jesús ja pamapa saisiametana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Dueji cristiano cuana ja Jesús tije atana. Galilea yahua, piada tunca ejude cuana, Jerusalén ejude, Judea yahua, Jordán ena chu maje je jenetia beju puetana huecuana Jesús tije ya puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesús ja cristiano cuana dueji ba putsu, murucu aida bia su tsuatiana. Dapia aniuteana. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Mesa discípulo cuana tu naja su anibareretana putsu, Jesús ja buetsuapirutana huecuana uja: ");
INSERT INTO tnaNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Nimebeidaji da Diusu ebia su shanapaja cuana, Diusu ecuatsasiati su yanienititayu huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","‘Nimebeidaji da enimepibapibatani cuana, Diusu ja epacienciatayu huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","‘Nimebeidaji da nimemitsida cuana, Diusu ja yahua etiata huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","‘Nimebeidaji da Diusu peje su nimebutsepi puja eputani cuana, Diusu ja tu peje su nimebutsepi yametayu huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","‘Nimebeidaji da pia ichenubaji cuana, Diusu ja daja huecha eichenubatayu huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","‘Nimebeidaji da muesumu butsepiji cuana, Diusu ebatayu huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","‘Nimebeidaji da cristiano cuana neje saida ani bahue cuana, Diusu ja mesa ebacua cuana yatayu putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","‘Nimebeidaji da Diusu jepuiti sufri eputani cuana, Diusu ecuatsasiati su yanienititayu huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","‘Ahua pia cuana ja micuana emadhabata, nedaneda yata su, ahua ema jepuiti bid'umimi neje micuana etuaquisata su, nimebeidaji mepuque, Diusu ja micuana dapia cielo su ebia su pamapa ai saida cuana etiatayu putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Beju daja da biahua tiempo cristiano madhada cuana ja Diusu sa profeta chenu cuana madhabataidha. Daja Jesús ja buetsuatana huecuana. Jesús ja daja hue cristiano cuana buetsuainiame atana: ");
INSERT INTO tnaNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","—Micuaneda da banu pu cua nime cristiano cuana duju su. Ahua banu sa bueda etaitana su, ¿cuaja ni da banu neicha bueda puyu cua? Mue ai puji saida beju banu. Ejusia puji bahui beju cristiano cuana ja patidhitidhiata puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","‘Micuaneda da hueda pu cua nime cristiano cuana Diusu sa ene quita quisa cuana ebuetsua puji. Ejude da emata bia su yani beju cuaja jarubuti taji mahue. Pamapa cristiano cuana ja tueda ejude ebatani. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Hueda huitsu putsu, aimue detse etse d'iti neje biateri cua mahue. D'eji su hueda pautsuneti ete dume su yanita cuana pajurabata puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Daja huecha cristiano cuana duju su micuaneseda hueda nime pu taji. Beju cristiano cuana ja micuana sa ai saida yainia cuana ba putsu, micuana sa Tata Diusu cielo su yani sa puji saida emimita huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","‘Aimue ema pue Moisés chenu sa jacuatsasiati cuana etaitanamepe puji mahue. Daja huecha aimue ema pue Diusu sa profeta chenu cuana sa jabuetsuati cuana etaitanamepe puji mahue. Beju ema pueana tueda jacuatsasiati, jabuetsuati cuana yamepe puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Enei hue, yama micuana equisainia, buepa, mundo yani tupu, tueda jacuatsasiati cuana da aimue etaitana mahue pamapa pu taji ai cuana epupe teje. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ahua quebata ja huai chidi jacuatsasiati biame jei aja mahue yata su, ahua tuahueda cristiano cuana daja ebuetsuata su, tueda da tije eni epu Diusu ecuatsasiati su. Ahua quebata ja pamapa jacuatsasiati cuana jei yata su, ahua tuahueda cristiano cuana daja ebuetsuata su, tueda da ebia su aida epu Diusu ecuatsasiati su. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Yama micuana butsepi equisainia, micuaneseda fariseo, jabuetsuati ebuetsuaji cuana ebia su nimebutsepi pu taji Diusu ecuatsasiati su enubi puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","‘Beju micuaneda bahue Moisés chenu ja ecuana sa tata chenu cuana jacuatsasiati cuana tiataidha. Piada jacuatsasiati uja epuani: “Be deja manuameji puji. Quebata ja pia emanuameta su, tueda matse taji.” ");
INSERT INTO tnaNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Beju yama mu tueda jacuatsasiati eyapaca. Yama micuana uja equisainia, ahua quebata mesa edue neje eduinini su, matsejiji epu. Daja huecha ahua quebata ja mesa edue emadhabata su, tata edhi huaraji cuana sa matse taji. Ahua quebata ja mesa edue eduininibata su, cuati castigo su puti cua. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","‘Ahua miada altar su eirutsuaji edusuti su, ahua dapia altar su mida mique edue neje aimue mi saida mahue epibati su, da su altar butse su mique eirutsuaji ichaque. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Putiyuque tueda edue peje su tu neje saida pamapa ebasetati puji. Beju mique edue neje jabasetati putsu, jasiapatique altar su mique eirutsuaji Diusu peje su eirutsua puji. Diusu mitsutsuaji mahue su, mique edue neje jabasetati taji. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","‘Beju yama micuana ebuetsuainia, ahua quebata mique manu ja mi echujebajata su, ahua tuahueda mi huaraji peje su edusuta su, edid'i su hue mebasetatique saida huaraji peje su cuinatiji mahue su, mi huaraji peje su emenajatiata mahue puji. Ahua mahue su, huaraji ja mi policia cuana peje su emenajatiata. Da su mi eteriichata huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Enei hue beju, yama micuana equisainia, dapia mida yaniti pamapa mique manu echujetiape teje. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","‘Micuaneda bahue Moisés chenu sa jacuatsasiati uja epuani: “Be pia sa ebutse neje mequinatiji.” ");
INSERT INTO tnaNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Beju yama mu micuana uja equisainia, ahua quebata deja ja epuna eutsatabata su, tueda da mesa enime su jucha aida epuani, tueda epuna neje jaquinati cua nime putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","‘Ahua mique bai eni bene etua ja mi jucha yameta su, huija putsu, uqueda jusiaque. Ebia su saida quita piada etua mahue cielo su enubi puji, aimue betana etua neje cuati castigo su eputi mahue puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ahua mique bai eni bene eme ja mi jucha yameta su, riji putsu, uqueda jusiaque. Ebia su saida quita piada eme mahue cielo su enubi puji, aimue betana eme neje cuati castigo su eputi mahue puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","‘Micuaneda bahue ecuana sa tata chenu cuana sa jacuatsasiati uja derejiji yani: “Quebata mesa ehuane mesiaja epuani su, ehuane mesiata cua, jamesiati quirica derejiji tia putsu.” Daja cuatsasiataidha tata chenu cuana ja. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Beju yama mu micuana equisainia, ahua quebata deja ja mesa ehuane jucha mahue biame emesiata su, ahua tueda epuna pia deja neje neicha jahueti cua su, tueda equene yahue ja epuna jucha aida yametani, epuna pia deja neje jahuetiana putsu. Mesa beta puji yahue eichacua ja di jucha aida yata, epuna mesiajiji neje jahuanetiana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","‘Micuaneda bahue tata chenu cuana sa jacuatsasiati uja derejiji yani: “Mique jamitsuti Diusu bahue neje Diusu butse su ape taji.” ");
INSERT INTO tnaNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Beju yama mu micuana equisainia, be ai papu jepuiti Diusu bahue mepuji. Be cielo jepuiti Diusu bahue mepuji, tueda da Diusu sa ani jude putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Be mundo jepuiti Diusu bahue mepuji, Diusu sa jatidhiti jude putsu. Be Jerusalén ejude jepuiti Diusu bahue mepuji, Echua Puji sa ejude putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Be micuana sa echua jepuiti Diusu bahue mepuji. Ahua daja micuaneda epu su, Diusu jepuiti micuaneda Diusu bahue epuani, Diusu bahui bahue cuaja micuana sa echuaina epu putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Be Diusu bahue mepuji. Tupu saida micuaneda ahua “Ehe” ahua “Mahue” epu puji. Ishahua tije eputani cuana bahui ebia su Diusu bahue pu bahueta. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","‘Micuaneda bahue tata chenu cuana sa jacuatsasiati uja derejiji yani: “Ahua quebata ja pia sa etua ejemita su, huecha tuseda di pajemita. Daja huecha etse.” ");
INSERT INTO tnaNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Beju yama mu micuana uja equisainia: Be mebiahuanatiji deja madhada cuana neje. Ahua quebata ja mi ebuichetani su, bupe ebu di tiaque. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ahua quebata ja mique camisa mejemija yatani su, tiaque hue. Mique saco di tiaque hue. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ahua quebata ja mi mesa quipi piada kilómetro yabuametani su, beju beta kilómetro abuque. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Quebata ja mi ai papu ebajata su, tiaque hue. Ahua quebata ja mi ai prestaja yatani su, prestaque hue. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","‘Micuaneda bahue tata chenu cuana sa jacuatsasiati uja derejiji yani: “Mique eshanapa ibuneda baque. Mique majai duininibaque.” ");
INSERT INTO tnaNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Beju yama mu micuana uja equisainia: Micuana sa majai cuana ibuneda mebaque. Micuana madhabaji, neda aji cuana sa puji di Diusu mebajaque. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ahua micuaneda daja ya su, micuaneda da Tata Diusu sa ene quita ebacua cuana epu. Tuahueda id'eti ed'iametani cristiano madhada, saida cuana bia su tupupai. Nai di edajajametani cristiano nimebutsepi, nimebutsepi mahue cuana bia su tupupai. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ahua micuaneda micuana ibuneda ebatani cuana bahui ibuneda ebainia su, ¿ai puji saida ni da tueda pu cua? Daja Diusu shanapaji mahue a bahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ahua micuaneda micuana sa eshanapa cuana bahui emitsu su, ¿ai puji saida ni da tueda pu cua? Daja Diusu shanapaji mahue cuana a bahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Beju micuaneseda butsepi, saida pamapa ai su pu taji, micuana sa Tata Diusu cielo su yani da saida, butsepi putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","‘Be cristiano cuana butse su ai saida cuana meaji micuana echamata huecuana puji bahui. Ahua micuaneda daja ya su, aimue Tata Diusu ja micuana cielo su echuje etiata mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Puri quitaita cuana micuaneda etsahua su, be aidhe biame mequisaji. Be bubeta cuana ja yatani nime meaji. Tuneda da puri cuana tsahua putsu, pamapa cristiano cuana mecuana sa quisata tsada. Jadhitati jude ete cuana su, ejude duje di mecuana sa quisata tsada. Daja yatani huecuana cristiano cuana ja saida pabata huecuana puji. Beju yama micuana ene putsu equisainia, ahua cristiano cuana tuna jepuiti saida emimita su, tueda da mecuana sa echuje pu cua nime. Aimue Diusu ja echuje etiata huecuana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Da putsu beju, puri quitaita cuana micuaneda etsahua su, be aidhe biame quisaja meaji. Ahua daja micuaneda ya su, Diusu ja micuana echuje etiatayu. Tsahuataja cuana cuatsa mahue tsahua taji. Be aidhe biame bahue papu micuaneda yainia ai cuana. Be micuana sa eshanapa quitaita cuana biame bahue paputa. Beju micuana sa Tata Diusu ja pamapa micuaneda etsia neje yainia ai saida cuana ebatani putsu, micuana echuje etiatayu. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","‘Be Diusu memitsuji bubeta cuana ja emitsutani nime. Tuneda da jadhitati jude ete cuana su, ejude duje di mecuana sa netita tsada Diusu emitsu puji, cristiano cuana ja pachamata huecuana puji. Beju yama micuana ene putsu equisainia, ahua cristiano cuana tuna jepuiti saida emimita su, tueda da mecuana sa echuje pu cua nime. Aimue Diusu ja echuje etiata huecuana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Da putsu, micuaneda Diusu mitsuja su, micuana sa ete su menubique. Meterique ete. Tata Diusu neje bahui meanique tu emitsu puji. Beju pamapa micuaneda etsia neje ai ebajainia cuana Diusu ja id'aba putsu, micuana etiatayu. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","‘Beju micuaneda Diusu emitsunia je, be tueda hue atiyu atiyu meaji. Daja da Diusu mue shanapa cuana ja a bahue. Tuna sa piba su tueda hue atiyu atiyu a putsu, Diusu ja eid'abata pepe eputani huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Be tuna nime mepuji. Micuana sa ai mahue ai cuana beju Tata Diusu bahue, micuaneda bajaji mahue su. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Da putsu, uja mitsume meaque: Ecuanaju sa Tata, cielo su yani, mique ebani iyuda papu. Cuatsasiapiruenique ye mundo su. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mique ai tsada cuana bahui cristiano cuana ja ye mundo su paata, cuaja cielo su aniji cuana ja yatani nime. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Pamapa tsine ecuanaju tiaque ai dia taji cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Perdonaque ecuanaju sa jucha cuana, cuaja ecuanaju madhada aji cuana eperdonainia nime. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Be ecuanaju Ishahua peje su pirubameji. Tusa eme jenetia d'eji su ecuanaju aque. Tucheda neje cuatsasiaenique. Daja papu. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","‘Daja hue micuaneseda Diusu mitsu taji. Ahua micuaneda micuana madhada aji cuana eperdona su, daja huecha Tata Diusu ja micuaneda di eperdonatayu. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ahua aimue micuaneda micuana madhada aji cuana perdonaja mahue ya su, daja huecha Tata Diusu ja micuana sa jucha cuana aimue eperdonata mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","‘Beju micuaneda ayuna epuani je, be etacuamadhatiani ebuji mepuji. Daja bubeta cuana pu bahue cristiano cuana ja tuneda ayuna eputani pabata puji. Beju yama micuana ene putsu equisainia, tueda da tuneseda puji echuje pu cua nime. Aimue Diusu ja echuje etiata huecuana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Beju micuaneda mu ayuna epuani je, meburucuatique, mepesutique aimue cristiano cuana micuaneda ayuna epuani bahue paputa mahue puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Micuana sa Tata Diusu bahui bahue papu. Tuahueda micuana echuje etiatayu. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","‘Be meradanetiaji ai cuana ye mundo su, beju pamapa etaitanape putsu. Rahuirahui epupeta. Tsena ja ediapeta. Tsi puji cuana ja etsita. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ebia su saida ai saida cuana cielo su eradanetia puji. Dapia mu da aimue ai biame emadhatiani mahue. Aimue musu, tsi puji yani mahue. Dapia mu da aimue ai biame etaitanape mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Quepia micuana sa ai saida cuana eradaneti su, dapia micuaneda anija epu. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","‘Micuana sa etua da lámpara nime micuana sa equita sa puji. Ahua micuana sa etua saida su, saida echamati. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ahua micuana sa etua saida mahue su, aimue saida echamati mahue. Daja huecha ahua micuaneda ai madhada cuana su bahui epibatiani su, apuda saida su micuaneda epuniuneti. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","‘Beju aiya biame beta echua puji tupupai mebajata cua mahue. Piada echua puji bahui hue mebaja taji. Pia cuana mu aimue tsada ba taji mahue. Daja huecha ahua etse Diusu mebajaja su, aimue detse etse Diusu mebaja cua mahue chipilu ebia su tsada ebainia neje tupupai. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","‘Be ebia su mepibapibaji ai dia taji, ejud'uji cuana jepuiti. ¿Ai puji saida ni da ye ai cuana jepuiti ebia su epibapiba puji? ");
INSERT INTO tnaNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mechamaque d'ia janana cuana. Banabana bue mahue. Huiru putsu, ichaseta bue mahue biame, Tata Diusu ja emihuatani huecuana. Micuaneda mu d'ia janana cuana ebia su chujeme Diusu peje su. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Aimue detse etse ebia su bauda bauna cua mahue, pibapiba putsu. Daja huecha aimue detse etse sa ai dia taji cuana ani cua mahue, ebia su pibapiba putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","‘¿Ai puji ni da micuaneda ejud'uji jepuiti ebia su epibapibani? Mechamaque shasha cuana. Ania chidi emurutani mudu, badu bue mahue ta biame. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Beju yama micuana ene putsu equisainia, aimue echua puji Salomón chenu jajud'utidha ania shasha cuana nime mahue, tueda da ebia su chipiluji puidha biame. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Shasha neje Diusu ja nutsa ania chidi yatani. Beju jiahue quita nutsa shasha neje ania chidi biame, mueta beju sarajiji cuati puji bahui saida epuani. Mepibatique nutsa cuana su. Ahua Diusu ja nutsa cuana ania chidi shasha neje yatani su, ¿aimue jia maida micuana Diusu ja ejud'utayu mahue? ¿Jucuaja su ni da micuaneda Diusu peje su aimue enimetucheatiani mahue? ");
INSERT INTO tnaNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Da su be ebia su mepibapibaji ai dia taji, ejud'uji cuana jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Daja Diusu peje su jei eputani mahue cuana pu bahue. Beju micuaneda mu da aimue daja epu mahue, micuana sa aimue ai cuana Tata Diusu bahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Equene Diusu bahui tsada mebaque. Tu butse su nimebutsepi bahui tsada mebaque. Ahua micuaneda daja ya su, Tata Diusu ja micuana pamapa ai saida cuana etiatayu. ");
INSERT INTO tnaNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Be ebia su mepibapibaji micuaneda cuaja mueta epu cuana su. Tsine meamea Diusu ja micuana etsahuatayu. ");
INSERT INTO tnaNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","2","‘Be pia cuana metuaquisaji. Ahua micuaneda pia cuana etuaquisa su, daja huecha Diusu ja micuaneda di eturuca etuaquisatayu, cuaja micuaneda pia cuana etuaquisainia nime. ");
INSERT INTO tnaNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Jucuaja su ni da micuaneda pia edue sa etua su ai d'ape chidi echamainia, beju micuana sa etua quitaita dume su aqui riji aida esa biame? ");
INSERT INTO tnaNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ahua micuana sa etua su aqui riji aida esa su, ¿cuaja ni da micuana sa edue sa etua su ai d'ape chidi jemicuina cua? ");
INSERT INTO tnaNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Bubeta micuaneda! Equene tsuhu mejemique aqui riji aida micuana sa etua jenetia. Daja a putsu, saida eba ai d'ape chidi edue sa etua su esa ejemi puji. Beju micuaneda jucha aidaji putsu, pia jucha huai chidi cuana micuaneseda puji cuaja tuaquisa taji mahue. Equene tsuhu micuana sa jucha mebasetatique pia cuana tuaquisaji mahue su. ");
INSERT INTO tnaNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","‘Aimue detse etse chujeneda ai cuana uchi, cuchi cuana jusiatia cua mahue, tueda chujeneda ai cuana tidhitidhiata cua putsu. Ejusiatiaji beju tsuita cua uchi, cuchi cuana ja. Daja huecha Diusu sa jabuetsuati ai cuana id'abaja mahue cuana be mequisaji. ");
INSERT INTO tnaNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","‘Mebajaque Diusu. Ahua micuaneda Diusu ebaja su, tuahueda micuana etiatayu. Chacu putsu, micuaneda etejeyu. Meturubaderaque. Turuba putsu, etsequed'iatiyu. ");
INSERT INTO tnaNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","‘Ahua micuana sa ebacua cuana ja pan ebajatani su, ¿ai micuaneda tumu etia bata? ");
INSERT INTO tnaNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ahua micuana sa ebacua cuana ja se ebajatani su, ¿ai micuaneda bacua etia bata? ");
INSERT INTO tnaNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Micuaneda deja juchaji cuana biame, micuana sa ebacua cuana ai saida cuana tia bahue. Beju Diusu mu da ebia su saida putsu, tu bajaji cuana ebia su ai saida cuana tia bahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","‘Da su cuaja micuana sa tsada pia cuana ja micuana yata su, daja micuaneda di meaque huecuana. Daja Moisés chenu ja cuatsasiataidha mesa jacuatsasiati cuana su. Diusu sa profeta chenu cuana ja di daja deretaidha. ");
INSERT INTO tnaNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","‘Beju menubique eteriji upahai chidi je. Cuati castigo su ecuinahu edid'i mu pahaida. Mesa eteriji di pahaida. Da da dueji cristiano cuana enubitani. ");
INSERT INTO tnaNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Beju Diusu peje su ecuinahu edid'i mu da beju upahai chidi hue. Mesa eteriji di beju upahai chidi hue. Da da quejucua chidi hue cristiano cuana enubitani. ");
INSERT INTO tnaNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","‘Merejatique bid'umimi puji cuana neje. Tuneda, “Ecuanaju da Diusu sa puji emimiani”, eputani. Tuneda huisha nime nimeme micuana peje su epuetani biame, beju micuana duju su iba d'aida nime eputani huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Tuna sa ai puiti cuana jepuiti hue micuaneda eshanapaeni tuneda saida ahua mahue. Aimue detse etse junu requerequeji jenetia ejaja saida huiru cua mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Beju pamapa equi saida cuana mu ejaja saida eputani. Daja huecha pamapa equi saida mahue cuana ejaja saida mahue eputani. ");
INSERT INTO tnaNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Beju equi saida mu aimue detse ejaja saida mahue pu cua mahue. Daja huecha equi saida mahue aimue detse ejaja saida pu cua mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pamapa equi saida mahue cuana ejaja saida pu bue mahue beju que putsu, d'ed'a taji. ");
INSERT INTO tnaNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Beju micuaneda deja bid'umimi puji cuana eshanapaeni, tuna sa ai puiti madhada cuana ba putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","‘Piada piada cuana ja ema: “Echua Puji”, yatani biame, ahua Diusu sa tsada aja mahue eputa huecuana su, aimue cielo su enubita huecuana mahue. Quema Tata Diusu sa tsada aji cuana bahui cielo su enubitayu. ");
INSERT INTO tnaNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Beju castigo tsine ecuina su, jucuada cristiano cuana ja ema equisata uja: “Echua Puji, ecuanaju da mique ebani su mimiana. Einid'u madhada cuana cristiano cuana peje jenetia ecuanaju jusiacuinana mique ebani neje. Mique ebani neje da jucuada ai nimetiuda aida cuana ecuanaju ana.” ");
INSERT INTO tnaNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Beju daja ema yata huecuana su, yama uja ejeutsu huecuana: “Aimue yama micuana shanapa. Menetideraque ema peje jenetia, micuaneda da cristiano madhada putsu.” ");
INSERT INTO tnaNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","‘Quebata ja quema jabuetsuati yatani su, tueda da ete muduji deja bahue eni nime. Tueda deja ja ete mudutana eti jude saida bia su. ");
INSERT INTO tnaNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Beju nai jubida puana putsu, ena aida nubiana. Jubida dhapujutana ete. Beni ja di ete dhapujutana jubida. Beju dhapujutana biame, mue dajajame atana ete, eti jude saida bia su ajiji putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Beju quebata ja quema jabuetsuati aimue yatani mahue su, tueda da ete muduji deja bue mahue nime. Tueda deja ja ete mudutana yahua saida mahue bia su. ");
INSERT INTO tnaNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Beju nai jubida puana putsu, ena aida nubiana. Jubida dhapujutana ete. Beni ja di ete dhapujutana jubida. Beju dajajana ete, ebia su dhapujutana putsu. Taitanapetana pamapa beju. Daja nime quema jabuetsuati aja mahue yatani cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Daja Jesús ja buetsuapetana su, cristiano cuana ebia su nimetiunetitana, Jesús ja huaraji aida mimi neje buetsuatana huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Mesa jabuetsuati quitaita cuana buetsuatana. Aimue jacuatsasiati ebuetsuaji cuana nime buetsuame atana mahue. Tuna ebia su saida buetsuataina, tuneda pia sa jabuetsuati cuana buetsuataina putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Beju Jesús ja cristiano cuana buetsuape putsu, murucu aida je buteana. Dueji cristiano cuana ja tije atana. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Piada deja lepraji ja Jesús nariatana. Tu butse su tururu putsu, uja atana Jesús: —Echua Puji, ahua mique tsada su, miada ema saisiame cua. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Da su Jesús ja deja d'apabatana. Uja atana deja: —Tsada quema. Mida esaisi. Jesús daja epuani cama, deja lepraji saisiana. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Neicha Jesús ja atana deja: —Be aidhe biame quisaji. Jabametitique sacerdote peje su tuahueda mi saisijiji pabata puji. Da su beju Diusu irutsuaque, cuaja Moisés chenu sa jacuatsasiati epuani batame, pamapa cristiano cuana ja mida saisijiji pashanapata puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Da su beju Jesús Capernaum ejude su putibana. Dapia ejude su romano soldado cuana sa capitán ja Jesús uja bajatana: ");
INSERT INTO tnaNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Echua Puji, quema emebajaji da nedaji ete su esa. Ruburubu bue mahue. Ebia su sufri epuani tueda neda neje. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Da su Jesús ja capitán uja atana: —Eputi da ema tu esaisiame puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Capitán ja uja jeutsutana: —Echua Puji, ema mu aimue aidhe eni mahue quema ete su mida enubi puji. Beju mi yani jenetia cuatsasiaque hue quema emebajaji pasaisi puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ya di quema echua puji sa jacuatsasiati ema su yani. Daja huecha quema soldado cuana yani. Quema jacuatsasiati ema su yanita huecuana. Pamapa quema jacuatsasiati cuana yatani huecuana. Quema emebajaji cuana ja di quema jacuatsasiati cuana yatani. Da su ema bahue ahua miada u jenetia hue cuatsasia cua su, quema emebajaji saisi cua. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesús ja daja id'aba putsu, nimetiunetiana. Mesa ebuqueji cuana uja atana: —Ene putsu, yama micuana equisainia, pamapa Israel yahua je aimue yama aidhe biame ye deja nime ba. Aimue aidhe biame Diusu peje su tu enimetucheatiani nime yama ba. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ene putsu, jucuada israelita mahue cristiano cuana ye capitán nime pamapa mundo je cielo su enubita. Dapia yaniuteta huecuana Abraham, Isaac, Jacob chenu cuana neje ediadia puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Beju Diusu ecuatsasiati da israelita cuana sa puji biame, aimue pamapa tuneda enubita mahue. Jucuada tuneda uqueda, apuda su Diusu ja ebeituta. Dapia apuda su ebia su epata, etsedhaitita ebia su sufri eputa huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Da su Jesús ja neicha hue capitán atana: —Putiyuque mique ete su. Mi jei puitia batame beju epu. Da hora su beju emebajaji saisiana. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Da su beju Jesús da Pedro sa ete su putiana. Dapia Pedro sa ehuane sa cuara nedaji saina. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesús ja tusa eme inatana cama, beju saisiana. Da su epuna netiana putsu, bapirutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Beju dhidha su cristiano cuana ja einid'u madhadaji cuana dusutana Jesús peje su. Mesa mimi neje hue tuahueda einid'u madhada cuana jusiacuinatana cristiano cuana peje jenetia. Pamapa dapia nedaji cuana di saisiametana. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Beju daja puana, cuaja Diusu sa profeta Isaías chenu ja deretaidha batame. Uja derejiji yani: “Tuahueda ecuana sa ai neda cuana saisiametana.” ");
INSERT INTO tnaNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Beju Jesús ja dueji cristiano cuana tu ebarereatani batana putsu, cuatsasiatana discípulo cuana bai chu maje paaniapetuta huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Dapia piada jacuatsasiati ebuetsuaji ja Jesús atana: —Ebuetsuaji, yama mi tije aja quepia mi epuhu su. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús ja jeutsutana: —Cuacuacuacua cuana sa rara yanita. D'ia cuana sa esaji yanita. Beju quema mu ai mahue quepia echua epahuati puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Da su pia Jesús sa ebuqueji ja uja atana: —Echua Puji, quema tata papa putsu chu, yama mi tije ya. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Da su Jesús ja tueda jeutsutana: —Jiahue ema tije aque. Diusu shanapaji mahue cuana ja hue tuna sa manujiji cuana papapata. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Da su beju Jesús da discípulo cuana neje canoa aida su nubiana bai epetu puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Yanipetutasa cama, beni ebia su jubida pupiruana. Ena netianametana aida. Canoa dume su ena nubiana. Daja epuani biame, Jesús da canoa dume su tahuisaina. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Da su discípulo cuana ja tueda id'edeatana. Jubida atana huecuana uja: —¡Echua Puji, d'eji su ecuanaju aque! ¡Beju canoa yaninubiani! ");
INSERT INTO tnaNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesús ja jeutsutana huecuana: —¿Ai puji ni da micuaneda iyuame cuatajuse epuani? ¿Jucuaja su micuaneda aimue Diusu peje su enimetucheatiani mahue? Jesús daja mimi putsu, netianana. Beni, bai d'ayatana. Da su beju mitanasaisiana pamapa. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Discípulo cuana beju nimetiunetitana. Tuneda cama uja jaquisatitana: —¿Ai deja jia ye? Beni ja biame tueda eid'abatani. Bai ja di tusa jacuatsasiati eiyubatani. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesús da bai chu maje satsuati putsu, beta deja einid'u madhadaji detse dapia panteo jenetia cuinanana. Tuatseda einid'u madhadaji putsu, ebia su ate cristiano cuana neje puina. Da putsu, cristiano cuana dapia edid'i su aimue jaitianaja mahue putaina. Beju tuatseda Jesús peje su janariatiana. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tsiatsia neje uja Jesús atana tse: —Jesús, Diusu sa Ebacua, ¿ai mique etseju neje yani? ¿A da miada etseju castigo su ebeitu, etseju sa castigo hora cuinaji mahue su? ");
INSERT INTO tnaNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Chuadera beju dueji cuchi cuana diadianiunetitaina. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Beju einid'u madhada cuana ja Jesús atana: —Ahua miada ecuanaju ye deja detse peje jenetia ejusiacuina su, d'eji ecuanaju tiaque cuchi cuana sa equita cuana su enubi puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Da su Jesús ja d'eji tiatana huecuana. Beju einid'u madhada cuana deja detse peje jenetia cuinana putsu, cuchi cuana sa equita cuana su nubitana huecuana. Nubitana su, cuchi cuana jududutana bai su. Bai equehuehueji butsepi je dajajautetana. Dajajaute putsu huidipetana. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Da su beju cuchi quinaji cuana tipei pume ejude su tipeida jududutana. Dapia beju pamapa cuaja ai puana cuana quisapupirutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Da su pamapa ejude cristiano cuana putitana Jesús peje su ebati puji. Tu peje su cuinati putsu, beju jubida Jesús bajapirutana huecuana papuenitiyu tuna sa yahua jenetia puji. Da su Jesús putibana. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Da su beju Jesús canoa aida su nubiana. Neicha bai su anipetutaibana u maje je. Satsuati putsu, mesa ejude su putibana. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Dapia Jesús yani su, deja ase bue mahue chahui su dusutana huecuana. Beju Jesús ja nedaji duseji cuana tu peje su ebia su enimetucheatitani ba putsu, uja atana nedaji: —Deja, janimetucheatique, yama mique jucha cuana perdonaitia putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Da su piada piada jabuetsuati ebuetsuaji, dapia netitana cuana tuneda cama japibatitana uja: “¿Ai deja ja juchaji cuana perdonata cua bata? Diusu ja bahui juchaji cuana perdonata cua. Ye Jesús ja mesa mimi neje Diusu emadhabatani. Beju Diusu puja epuani.” ");
INSERT INTO tnaNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Da su Jesús ja tuna sa piba cuana eshanapatani putsu, uja atana huecana: —¿Ai puji micuaneda daja madhada epibatiani? ");
INSERT INTO tnaNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ahua yama deja, “Mique jucha cuana yama eperdonainia”, ya su, ahua yama, “Netianaque, aseque”, ya su, beju quema puji mu tupupai hue. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Daja yama deja yainia micuana ebame puji, ye mundo su ema tucheda eni cristiano cuana sa jucha cuana eperdona puji. Da su Jesús ja uja deja nedaji cuatsasiatana: —Netianaque. Mique chahui jemitsuaque. Putiyuque mique ete su. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Da su beju deja netianana. Mesa ete su saisijiji putibana. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Cristiano cuana ja ba putsu, ebia su nimetiunetitana huecuana. Diusu sa puji saida mimitana huecuana, Diusu ja Jesús daja tucheda tiatana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Beju da jenetia Jesús putiana. Chuadera pad'i deja Mateo banime batana. Tueda impuesto chujebaja jude su anina. Jesús ja tueda uja atana: —Tije ema aque. Da su Mateo netianana Jesús ebuque puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jesús da Mateo sa ete su putiana mesa discípulo cuana neje ediadia puji. Tuna neje misha su ediadia puji deja juchaji cuana anitaina. Impuesto chujebajaji cuana di anitaina. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Da su fariseo cuana ja ba putsu, discípulo cuana uja quisabatana huecuana: —¿Jucuaja su ni micuaneda impuesto chujebajaji, juchaji deja cuana neje ediadiani? ");
INSERT INTO tnaNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús ja fariseo daja equisabatani id'abatana putsu, uja atana huecuana: —Beju jaiduenetiji da aimue saida cuana sa puji mahue. Nedaji cuana sa puji bahui. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Uja Diusu ja deremetaidha mesa quirica su: “¿Ai puji saida ni da pu cua ema peje su animalo cuana eirutsua emitsutsua puji, micuaneda edue cuana aimue ibuneda ebainia mahue biame?” Da su jabuetsuati taji Diusu puidha derejiji ai cuana. Aimue ema pue butsepi ebatitani cuana ema peje su eihua puji mahue. Juchaji cuana bahui eihua puji ema pueana Diusu peje su papibaturucatita huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Da su beju Juan Bautista sa ebuqueji cuana ja Jesús nariatana. Uja quisatana huecuana: —Ecuanaju fariseo cuana neje tupupai ayuna epuani. ¿Jucuaja su ni da mique discípulo cuana aimue ayuna eputani mahue? ");
INSERT INTO tnaNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús ja bahue quisa neje uja jeutsutana huecuana: —¿Ai jahuaneti tsine su ihuajiji cuana ebia su japadaritita cua bata, ehuanetisa deja tuna neje yani tupu? Ehuanetisa deja tuna neje yani tupu, ihuajiji cuana aimue ayuna eputa mahue. Tueda ihuajiji cuana duju jenetia ejemicuinata su chu, da hora su ihuajiji cuana ayuna eputa, aimue tueda tuna neje yani mahue putsu. Daja nime da quema discípulo cuana. Aimue ayuna eputani mahue huecuana, ema tuna neje yani hue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","‘Aimue detse etse ejud'uji edhi remetia cua mahue pia eped'u eichacua neje. Beju tueda remetia eichacua ja ejud'uji edhi d'iuta cua. Da su d'iujiji detse ebia su ainameta cua. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Daja huecha aimue vino eichacua etse emeji edhi su ichaseta cua mahue. Ahua daja etse a cua su, vino eichacua ja emeji pujuta cua. Da su vino, emeji neje tupupai taitana cua. Da putsu, vino eichacua emeji eichacua su icha taji. Daja a putsu, pamapa saida epu. Vino, emeji neje tupupai saida epu. Daja Jesús ja bahue quisa neje buetsuatana huecuana. Mesa jabuetsuati eichacua cuana da vino, eped'u eichacua nime. Fariseo cuana sa jabuetsuati cuana mu emeji, ejud'uji edhi nime. Beju aimue huamahuama ehuaruti mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Beju Jesús ja daja ebuetsuatani cama, piada judío cuana sa edusuji cuinana. Jesús butse su tururuana. Tururu putsu, uja atana Jesús: —Quema ebaquepuna beju jiahue quita manuitia. Pueque ema neje quema ete su. Dapia mique eme tu bia su ichaque tu eid'eyu puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Da su Jesús netiana putsu, tu neje putiana. Discípulo cuana di tu neje putitana. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Beju tuneda epuhu cama, piada epuna nedaji ja Jesús etibeini je nariatana. Tueda epuna piada tunca beta ejaitiana mara aimue mesa ami riji puja mahue puana. Beju naria putsu, Jesús sa ejud'uji tihue d'apabatana. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Uja epuna japibatiana: “Ahua mesa ejud'uji biame yama d'apaba cua su, ema saisi cua beju.” ");
INSERT INTO tnaNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesús da jababarereati putsu, epuna batana. Beju uja atana: —Epuna chidi, janimetucheatique. Mi ema peje su jei puitia putsu, beju mida saisitia. Da hora su hue epuna saisiana. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Beju Jesús da edusuji sa ete su cuinati putsu, mui turuji deja cuana ebasetatitani epapapapati puji batana. Cristiano cuana di ebia su epadarititani batana. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Da su uja Jesús ja atana huecuana: —Mecuinanaque u jenetia. Epuneje aimue emanu mahue. Tueda mu etahuisa hue. Da su cristiano cuana tu neje jaid'ebatitana, Jesús ja daja atana huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Da su etseque su cuinanametana huecuana. Epuneje esa su nubiana. Mesa eme ina putsu, id'emetaibana. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Beju Jesús ja epuneje id'emetaibana jepuiti, cristiano cuana pamapa tueda yahua je ebia su quisaquisa putana. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús da jenetia cuinanana su, beta deja padha detse ja tije atana. Beju tsiatsia neje uja bajatana tse: —¡Jesús, David chenu sa familia jenetia, ibunebaque etseju! ");
INSERT INTO tnaNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesús da ete su cuinati putsu, nubitiana. Deja padha detse ja nariatana. Da su Jesús ja tuatseda uja quisabatana: —¿A da metseda jei epuani yama metse tuaji yame puji? Da su jeutsutana tse: —Ehe, Echua Puji. Jei epuani etseju. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Da su Jesús ja tuatse sa etua d'apaba putsu, uja atana tse: —Beju daja papu cuaja metse jei epuani batame. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Da hora su beju tuaji puana tse. Jesús ja jubida cuatsasiatana tse aimue tuatseda aidhe papu paquisata mahue puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Jesús ja daja cuatsasiatana biame, pamapa cuaja Jesús ja atana tueda yahua je quisapuniunetiana. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Beju tuatseda ete jenetia cuinanana su, deja mimi bue mahue Jesús peje su dusutana pia cuana ja. Tueda deja einid'u madhadaji puina. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesús ja einid'u madhada deja peje jenetia jusiacuinatana su, deja mimipiruana. Dapia aniji cristiano cuana nimetiunetitana. Uja putana huecuana: —Quetsunu su biame ecuana sa yahua su ye nimetiuda aida cuana ba bue mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Beju fariseo cuana sa tsada mahue puana. Uja atana huecuana: —Ye deja ja nimetiuda ai cuana yatani Ishahua sa tucheda neje. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Beju Jesús da ejude meamea ebuetsua puniunetiana. Jadhitati jude ete cuana je buetsuatana. Diusu sa ai quisa saida cuana quisaquisa puniunetiana. Pamapa piapiati nedaji cuana saisiametana. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Daja ba putsu, Jesús ja ebia su ichenubatana cristiano cuana, huisha cuana equinaji mahue nime batana huecuana putsu. Ebia su jatacuamadhatitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Da su Jesús ja mesa discípulo cuana uja atana: —Enei hue, dueji yani ehuiru puji biame, ehuiruji cuana beju pishihue. Cristiano cuana da ejaja esuru ehuiru puji quitaita nime. ");
INSERT INTO tnaNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Diusu da huiruhuiru emetse nime. Mebajaque tueda mesa quisaquisa puji cuana cristiano cuana peje su pabeituta puji, mesa quisa saida cuana tuna peje su quisaquisa epu puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Da su beju Jesús ja mesa piada tunca beta ejaitiana discípulo cuana tu peje su ihuatana. Huaratiatana huecuana einid'u madhada cuana cristiano cuana peje jenetia ejusiacuina puji, pamapa piapiati nedaji cuana esaisiame puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Ye da discípulo cuana sa ebani cuana: Simón. Mesa pia ebani da Pedro. Andrés. Pedro sa edue. Jacobo. Juan sa edue. Juan. Jacobo sa edue. Tuatseda da Zebedeo sa ebacua detse. Felipe. Bartolomé. Tomás. Mateo. Tueda da impuesto chujebajaji. Jacobo. Alfeo sa ebacua. Lebeo. Mesa pia ebani da Tadeo. Simón. Partido cananista jenetia. Judas Iscariote. Tueda da Jesús menajatiaji. Tuneda da Cristo sa piada tunca beta ejaitiana discípulo cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Da su beju Jesús ja mesa discípulo cuana beitutana quisaquisa epu puji. Uja cuatsasiatana huecuana: —Be meputiji judío cuana yani mahue su. Be menubiji Samaria yahua su. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Israel yahua cristiano cuana peje su bahui meputique. Tuneda da huisha jeitid'ujiji nime. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Uja mequisatique huecuana: “Beju Diusu ecuatsasiati enariatiani.” ");
INSERT INTO tnaNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nedaji, lepraji cuana mesaisiametique. Manujiji cuana meid'edeatique. Einid'u madhada cuana mejusiacuinatique cristiano cuana peje jenetia. Be cristiano cuana mechujebajaji, Diusu ja mesa tucheda micuana cha tia hue atana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","‘Be chipilu, shitara medusutiji. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Piada ejud'uji cama hue medusutique. Be beta medusutiji. Piada pulucu butseji cama hue medusutique. Piada cama hue eituneji medusutique. Micuana id'abaji cuana sa micuana sa ai ediaji cuana tia taji, pamapa mudu puji cuana sa inatsu taji echuje putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","‘Beju micuaneda quebata ejude su cuinati putsu, dapia da piada deja butsepi mechacuque. Tusa ete su meanique. Tueda ete su hue meanique tueda ejude jenetia ecuinana teje. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Quebata ete su micuaneda enubiani je, uja memitsuque ete emetse: “Diusu ja menimepijajametaque.” ");
INSERT INTO tnaNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ahua ete su aniji cuana ja micuana sa quisa saida cuana eid'abata su, Diusu ja eibunebata huecuana, cuaja micuaneda mitsuana batame. Ahua ete su aniji cuana ja micuana sa quisa saida cuana aimue eid'abata mahue su, aimue Diusu ja eibunebata huecuana mahue. Da su micuana sa enubihu je, jamitsuti mimi tuneseda puji aimue saida mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ahua micuana id'abaja mahue yatani huecuana su, mecuinanaque tueda ete ahua ejude jenetia. Micuana sa pulucu jenetia med'i metaraque, Diusu tuna neje eduininiani pashanapata huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Enei hue, yama micuana yainia, castigo tsine ecuina su, Diusu ja tueda ejude su aniji cristiano cuana Sodoma, Gomorra ejude detse su aniji cristiano cuana ebia su ecastigatayu. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","‘Meid'abaque ema. Micuaneda da huisha nime. Yama micuana ebeituinia deja iba d'aida cuana nime duju su. Da su nimemitsida biame, pirida mepuque. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Merejatique, cristiano cuana ja micuana huaraji cuana peje su emenajatiata putsu. Jadhitati jude ete cuana su micuana eicheta huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Huaraji aida cuana butse su micuana etuaquisata huecuana, micuaneda quema ebuqueji cuana putsu. Da su tuna butse su eneti su, ema jepuiti micuaneda equisanetiacuinati. Judío mahue cuana butse su di ema jepuiti equisanetiacuinati. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Da hora su micuana huaraji aida butse su edusuta huecuana su, be mepibapibaji cuaja micuaneda jajeutsutime epu. Micuaneda emimi hora su Diusu ja micuana mimi cuana etiata ejeutsu puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Beju Espíritu Santo quitaita ja mesa piba cuana micuana peje jenetia emimi. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","‘Da tiempo su beju cristiano cuana ja ema peje su jei eputani cuana huaraji cuana peje su emenajatiata pamanuameta huecuana puji. Edue cama emenajatiatita. Tata cuana ja mecuana sa ebacua cuana emenajatiata. Daja huecha ebacua cuana ja mecuana sa tata cuana emenajatiata pamanuameta huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Pamapa cristiano cuana ja micuana eduininibata ema jepuiti. Daja biame, quebata emanu teje ema peje su daja hue enimetucheaderati su, tueda da d'eji su epueni. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ahua piada ejude su micuana eichetani huecuana su, pia ejude su mejududuque. Beju micuaneda pamapa Israel yahua sa ejude cuana je quisaquisa pupeji mahue su, ema epueicha. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","‘Beju ebuetsuatiani da aimue mesa ebuetsuaji ebia su aida pu cua mahue. Daja huecha emebajaji aimue mesa emetse ebia su aida pu cua mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ema da micuana sa Echua Puji, Ebuetsuaji. Cristiano cuana ema pa Ishahua peje jenetia eputani. Daja ema emadhabatani huecuana biame, micuaneda ema ebia su emadhabata huecuana, micuaneda da quema emebajaji cuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","‘Beju daja papu biame, be jamadhabatiji cuana meiyubaji. Pamapa ai etsia piba neje ajiji ai cuana Diusu ja ebameta. Pamapa etsia quisa cuana Diusu ja cristiano cuana eshanapameta. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Da su yama micuana etsia neje ebuetsuainia cuana jubida mequisaque. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ate cristiano cuana be meiyubaji. Micuana manuameta cua huecuana biame, aimue micuana sa enid'u mu cuaja madhada ata cua mahue. Beju Diusu bahui iyuba taji, tuahueda cristiano cuana manuame putsu, tuna sa enid'u cuana cuati castigo su beituta cua. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","‘D'ia janana chujeneda mahue ebaja puji biame, aimue detse yahua su dajaja cua mahue, ahua Tata Diusu sa tsada mahue su. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Beju pamapa micuana sa echuaina cuana idadajiji. Piada piada cama Diusu ja eshanapatani. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Da su be iyuame mepuji, micuaneda da Diusu peje su d'ia janana ebia su chujeji putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","‘Ahua quebata cuana, “Ecuanaju da Jesús sa ebuqueji cuana”, cristiano cuana butse su eputa su, da su ema, “Tuneda da quema puji cuana”, quema Tata Diusu butse su epu. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Daja huecha quebata cuana, “Jesús neje ecuanaju sa mue ai biame a taji”, eputa su, ema, “Tuna neje quema mue ai biame a taji”, quema Tata Diusu butse su epu. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","‘Beju ye mundo su ema pueana cristiano cuana pasajasajatita puji. Ema pueana putsu, aimue cristiano cuana tuneda cama huamahuama saida edusutita mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ema jepuiti ebacua mesa tata neje eduininibati. Ebaquepuna mesa cuara neje eduininibati. Ebacuasane mesa yahue sa cuara neje eduininibati. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Beju familia cama quitaita da eduininibatita ema jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","‘Quebata quema ebuqueji puja epu su, ema mesa tata, cuara detse, ebacua cuana ebia su ibuneda pabata. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Quebata quema ebuqueji puja epu su, tuseda ema tije a taji emanu teje. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Quebata ja cuaja ebia su saida quita ani taji echacuta su, pamapa etaitanamepeta. Quebata ja mu cuaja ebia su saida quita ani taji echacuta mahue su, ema ibuneda ebatani putsu, tueda da saida Diusu neje eid'e epueniti. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Beju Jesús ja mesa discípulo cuana daja hue hue uja quisainiame atana: —Quebata ja micuana ebatsuta su, tuahueda ema ebatsutani pu cua nime. Quebata ja ema ebatsuta su, tuahueda Tata Diusu ebatsutani pu cua nime, Diusu ja ema beitutana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Beju quebata ja Diusu sa profeta ebatsuta su, Diusu ja profeta sa echuje huecha tueda cha tiayu hue yata. Quebata ja deja nimebutsepi saida ebatsuta su, Diusu ja deja nimebutsepi sa echuje huecha tueda cha tiayu hue yata. ");
INSERT INTO tnaNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Quebata ja quema ebuqueji ai chidi neje biame etsahuata su, beju Diusu ja tueda saida echuje etiatayu. Daja Jesús ja mesa discípulo cuana quisapetana. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Beju Jesús ja mesa piada tunca beta ejaitiana discípulo cuana daja quisape putsu, beitutana huecuana. Tueda di tu mehua putiana dapia yahua sa ejude cuana je quisaquisa epu puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Da tiempo su Juan Bautista terijiji anina. Terijiji yani biame, Jesús ja ai yatani cuana shanapatana. Da su Juan ja beta mesa ebuqueji detse Jesús peje su beitutana tu equisaba puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jesús peje su cuinati putsu, beju quisabatana tse uja: —¿A da mida ecuanaju eid'uainia Diusu sa Jabeituti Deja cuaja Juan Bautista quisa puana nime? ¿Ahua ecuanaju pia eid'ua? ");
INSERT INTO tnaNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Beju Jesús ja jeutsutana tse: —Mequisatique Juan pamapa ai metse ebainia, eid'abainia cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mequisatique yama padha cuana beju tuaji yainia. Turu cuana yasemeinia. Lepraji cuana esaisiameinia. Jaid'abati bue mahue cuana eid'abameinia. Manujiji cuana eid'edeainia. Puri cuana peje su Diusu sa quisa saida cuana ema quisaquisa epuani d'eji su paputa huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mequisatique Juan be ema peje su panimetuchearijiti. Quebata ema peje su daja hue enimetucheaderati su, tueda da beidaji epu. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Da su Juan sa jabeituti detse jasiapatibana su, Jesús ja dapia netina cristiano cuana uja quisapirutana Juan jepuiti: —¿Ai eje ni da micuaneda putiana d'anita yahua su Juan peje su? ¿Ai eba puji micuaneda putiana? ¿Ahua bue enana beni ja ehuaidhutaneti nime eba puji micuaneda putiana? ");
INSERT INTO tnaNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Ahua deja ejud'uji chujeneda neje jud'ujiji eba puji micuaneda putiana? Beju deja ejud'uji chujeneda neje jud'ujiji cuana da echua puji sa ete aida su bahui yanita. Aimue d'anita su yanita huecuana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Beju, ¿ai eba puji micuaneda d'anita yahua su putiana? ¿A da Diusu sa profeta micuaneda batiana? Enei hue, Juan Bautista da pamapa Diusu sa equene profeta chenu cuana ebia su aida. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juan jepuiti Diusu sa quirica su uja derejiji yani: Quema quisa puji yama ebeitu mi hui su cristiano cuana pabasetatita mi epue su puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yama micuana ene putsu yainia, Juan Bautista da pamapa cristiano cuana ebia su aida. Beju daja biame, quebata ai eni mahue biame da Diusu ecuatsasiati su, tueda da Juan ebia su aida. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","‘Beju Juan da Diusu ecuatsasiati epusiu quisaquisa pupiruana jenetia, dueji cristiano cuana tueda quisa saida cuana su jubida neje jei eputani. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Juan quisaquisa pupiruji mahue su, pamapa Diusu sa equene profeta chenu cuana quisaquisa putaidha Diusu ecuatsasiati epusiu jepuiti. Moisés chenu ja di Diusu ecuatsasiati jepuiti deretaidha. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Beju Juan da Diusu sa profeta Elías chenu nime tuchedame Diusu ecuatsasiati epusiu cristiano cuana equisa puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ahua micuaneda id'ajararaji su, meid'abaque. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","‘¿Cuaja ni da jiahue tiempo cristiano cuana? Tuneda da yanana chidi cuana etseque je esitutitani nime. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Uja tsiatsia neje yatani huecuana mecuana sa eshanapa cuana: “Ecuanaju mui turuana micuaneda beidaji etiritiri puji. Beju micuaneseda tsada mahue puana, paja puana putsu. ¡Jade! Da su beju ecuanaju beidaji mahue satsu cuana satsuana micuaneda epa puji. Daja biame, micuaneda paja mahue puana, beidaji puja puana putsu. Beju ecuanaju micuana cuaja beidaji ame taji mahue ebainia.” Beju tueda jasitutiji yanana cuana nime jiahue tiempo cristiano cuana mu. Cuaja beidaji ame taji mahue huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juan Bautista ja pia cristiano cuana neje aimue diadiaina mahue. Vino di aimue id'itaina mahue. Da putsu, micuaneda, “Juan einid'u madhadaji”, epuani. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Yama mu ai papu ediainia cristiano cuana neje. Vino di eid'inia. Da putsu, micuaneda, “Jesús da diadia aida, jaid'iti aida”, epuani. Micuaneda ema pa juchaji, echujebajaji cuana sa eshanapa epuani, ema tuna neje diadia bahue putsu. Beju micuana sa japitsati piba cuana da saida micuaneseda puji bahui. Micuaneda ema, Juan daja emadhabainia biame, etseju da Diusu sa piba saida cuana yainia ebameinia. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Daja Jesús ja fariseo cuana quisape putsu, piada piada ejude cuana su aniji cuana d'ayapirutana. Tueda ejude je aniji cuana aimue Diusu peje su japibaturucatitana mahue, Jesús ja tuna duju su ebia su ai nimetiuda cuana atana biame. Beju uja d'ayapirutana huecuana: ");
INSERT INTO tnaNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Aba quitaita Corazín, Betsaida ejude detse su aniji cuana! Tueda ejude detse su dajucua ai nimetiuda cuana yama ana biame, aimue Diusu peje su japibaturucatija putana huecuana mahue. Ahua Diusu ja biahua tiempo su Tiro, Sidón ejude detse su tueda nimetiuda aida cuana ataidha su mu detse, dapia anitaidha cristiano cuana Diusu peje su japibaturucatitaidha detse. Tuna sa jucha cuana jepuiti ebia su janimepibapibametitaidha detse. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Beju yama micuana equisainia, Diusu sa castigo tsine ecuina su, Diusu ja Corazín, Betsaida ejude detse su aniji cuana Tiro, Sidón ejude detse su anitaidha cuana ebia su ecastigatayu. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Daja huecha Capernaum ejude su aniji cuana yatayu. “Diusu ja ecuana cielo su edusutsuatita”, eputani huecuana biame, beju Diusu ja cuati castigo su ebeituta huecuana. Ahua Diusu ja biahua tiempo su Sodoma ejude su tueda nimetiuda aida cuana ataidha su mu detse, dapia anitaidha cristiano cuana Diusu peje su japibaturucatitaidha detse. Da su aimue detse Diusu ja Sodoma ejude taitanamepeta cua puidha mahue. Jiahue teje beju tueda ejude ani cua hue. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Yama micuana equisainia, Diusu sa castigo tsine ecuina su, Diusu ja Capernaum ejude su aniji cuana Sodoma ejude su anitaidha cuana ebia su ecastigatayu. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Da su beju Jesús ja Tata Diusu mitsutana uja: —Quema Tata, yama mi emitsutsuainia. Mida da aida eni. Mida da cielo, mundo emetse. Nimemitsida cuana bahui miada shanapameana mique piba cuana. Bahue eni ebatitani cuana mu aimue shanapameana mahue mique piba cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Daja mique tsada. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jesús ja cristiano cuana daja hue quisainiame atana uja: —Quema Tata Diusu ja ema pamapa ai cuana menajatiatana. Aimue ema aiya biame saida eshanapaenitani mahue. Quema Tata Diusu ja bahui ema saida eshanapaenitani. Daja huecha aimue quema Tata Diusu aiya biame eshanapaenitani mahue. Yama bahui tueda saida eshanapaeninia, ema tusa ebacua putsu. Quebata quema tsada cuana bahui quema Tata Diusu yama eshanapameinia. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Pamapa jucha, pibapiba jabuti, jaduitiji cuana ema peje su papueta yama ejanahuame huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ahua ema tije yata huecuana su, aimue yama jubida ecuatsasia huecuana mahue. Ema jepuiti mebuetsuatique. Ema da paciencia aidaji, nimemitsida. Ema neje micuana saida enimepijaja. ");
INSERT INTO tnaNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Quema jacuatsasiati cuana da aimue tadada mahue ya puji. Aimue quipi biqueda saida yabuinia nime mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Da tiempo janahua tsine su Jesús, mesa discípulo cuana neje d'ije duje ejaitianasa je, discípulo cuana ja eju cuana raridujudujuatana, dhemanu putsu. Ejaja iruruatana huecuana edia puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fariseo cuana ja daja ba putsu, discípulo cuana tuaquisatana huecuana. Uja Jesús atana huecuana: —Chamaque, mique discípulo cuana janahua tsine su emudumudutani. Daja a taji mahue janahua tsine su, jacuatsasiati cuana daja epuani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Da su Jesús ja uja jeutsutana huecuana quisaba neje: —¿Aimue jia maida micuaneda mimiameana mahue cuaja David chenu ja ataidha mesa ebuqueji cuana neje, dhemanutaidha huecuana su? ");
INSERT INTO tnaNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tueda nubidha Diusu sa templo su pan iyuda edia puji. Ebuqueji cuana pan iyuda tiataidha padiata huecuana puji. Beju tueda pan iyuda mu sacerdote cuana sa bahui dia taji puidha. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Aimue jia maida micuaneda mimiameana mahue sacerdote cuana jepuiti Moisés chenu sa quirica su? Tueda sacerdote cuana templo su emudumudutani putsu, janahua tsine su aimue ejanahuatani mahue. Tuneseda puji beju jucha mahue janahua tsine su emudumudu puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Beju yama micuana butsepi equisainia, ema da sacerdote cuana ebia su aida. Cristiano cuana sa ema sacedote cuana ebia su iyuda ba taji. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Aimue micuaneda Diusu sa derejiji yani mimi eshanapainia mahue. Uja Diusu puidha mesa quirica su: “Tsada quema micuaneda cristiano cuana eibuneba puji. Ahua aimue micuaneda eibuneba mahue su, ¿ai puji saida ni da micuaneda animalo cuana ema peje su eirutsua puji? Ebia su saida quita cristiano cuana eibuneba puji aimue ai eirutsuaji cuana eirutsua puji mahue.” Beju aimue micuaneda tueda Diusu sa mimi eshanapainia mahue. Micuaneda jucha mahue cuana tuaquisa bahue, aimue eibunebainia huecuana mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Da su beju meshanapaenique ema da janahua tsine emetse. Quema bahui janahua tsine su ai a taji cuana cuatsasia taji, ema da Diusu sa Jabeituti Deja putsu. Beju daja Jesús ja jeutsutana fariseo cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Da su beju Jesús fariseo cuana peje jenetia putiana. Jadhitati jude ete su putiana. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tueda ete su deja mechehui anina. Fariseo cuana di dapia netitaina. Tuneda Jesús jubida tuaquisaja atana putsu, uja Jesús quisabatana huecuana: —¿Ahua saida janahua tsine su nedaji esaisiame puji? ");
INSERT INTO tnaNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Da su Jesús ja uja jeutsutana huecuana: —Ahua quebata micuana sa huisha janahua tsine su rara su dajaja cua su, ¿aimue jia maida micuaneda ejemicuina mahue? ");
INSERT INTO tnaNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Beju deja da huisha ebia su chujeme. Da su saida da janahua tsine su ai saida cuana ya puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Da su Jesús ja deja mechehui uja cuatsasiatana: —Piraraque mique ebai. Beju deja ja mesa ebai epiraratani cama, saisiana mesa eme. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Dapia enetita fariseo cuana beju jubida duininitana. Tuneda cama uja jaquisabatitana: “¿Jucuaja ni da ecuaneda Jesús manuameme a cua?” ");
INSERT INTO tnaNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Da su Jesús cuinanana jadhitati jude ete jenetia, fariseo cuana sa japibati madhada cuana bahue pu putsu. Dueji cristiano cuana tu tije putitana. Pamapa nedaji cuana Jesús ja saisiameniunetitana. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Tueda saisijiji cuana cuatsasiatana tu jepuiti quisa paputa mahue huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Daja atana Jesús ja, cuaja Diusu sa profeta Isaías chenu biahua tiempo quisaquisa puidha batame. Uja Diusu puidha, Isaías chenu ja deretaidha: ");
INSERT INTO tnaNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ye da quema emebajaji. Yama tueda dhareana. Yama tueda ebia su ibuneda ebainia. Tu neje ema beidaji. Quema Espíritu Santo sa tucheda yama tueda etia. Pamapa ye mundo su ejude cuana su aniji cuana tuahueda butsepi ecuatsasiata. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Aimue tueda epucuicuina mahue. Aimue ejude duje jubida emimi mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nimetucheda mahue cuana enimetucheametayu. Ebia su japibachucuatiji cuana etsahuatayu. Pamapa huaraji cuana pishitiame putsu, butsepi neje ecuatsasiata. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Pamapa cristiano cuana tu peje su enimeid'uatita. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Beju piada deja padha, mimi bue mahue Jesús peje su dusutana huecuana. Tueda deja einid'u madhadaji puina. Jesús ja tueda saisiametana putsu, beju jabatimimipiru puana. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Pamapa cristiano cuana ba putsu, beju nimetiunetitana huecuana. Da su tuneda cama uja jaquisabatitana: —¿Ye jia da Diusu sa Jabeituti Deja? ");
INSERT INTO tnaNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Beju fariseo cuana ja tsada mahue batana cristiano cuana Jesús jepuiti daja pamimita. Da su cristiano cuana uja atana huecuana: —Ye Jesús da aimue Diusu peje jenetia mahue. Einid'u madhada cuana cristiano cuana peje jenetia ejusiacuinatani Ishahua sa tucheda neje. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Beju Jesús bahue puana tu jepuiti fariseo cuana daja eputani. Da su uja atana huecuana: —Ahua quebata huaraji aida sa cristiano cuana esajasajata su, ahua tuneda cama eichetita su, beju tueda huaraji aida sa tucheda etaitanapeyu. Quebata familia edue cama, ejude su aniji cuana eichetita su, tuneda quitana etaitanape. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Daja huecha ahua Ishahua ja quitaita mesa einid'u madhada cuana jusiata cua su, mesa tucheda etaitanape. Aimue mesa einid'u madhada quitaita ejusiata mahue. Ahua daja yata su, tueda quitaita emajaitiani pu cua nime. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Beju micuaneda cristiano cuana peje jenetia yama einid'u madhada cuana ejusiacuinainia Ishahua sa tucheda neje epuani. Ahua daja su, ¿aidhe sa tucheda neje micuana sa ebuqueji cuana ja einid'u madhada cuana ejusiacuinatani? Jiahue yama micuana equisaba. ¿Aimue jia maida Diusu sa tucheda neje einid'u madhada cuana ejusiacuinatani huecuana mahue? Da su, ¿jucuaja su micuaneda yama einid'u madhada cuana Ishahua sa tucheda neje ejusiacuinainia epuani? Micuana sa ebuqueji cuana ja ebametani micuaneda da japitsatijiji. Aimue yama Ishahua sa tucheda neje einid'u madhada cuana cristiano cuana peje jenetia ejusiacuinainia mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yama einid'u madhada cuana ejusiacuinainia Diusu sa Espíritu Santo sa tucheda neje bahui. Diusu ja mu tueda ai nimetiuda cuana yatani micuana duju su. Aimue Ishahua ja tueda ai nimetiuda cuana ema yametani mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","‘Ahua tsi puji ja deja tucheda sa ai cuana tsija su, equene tsuhu risi taji. Daja a putsu bahui, tsi puji ja tusa ai cuana mejemita cua. Daja huecha yama Ishahua a cua, ema tu ebia su tucheda putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","‘Quebata ja aimue ema saida ebatani mahue, tueda ema neje emajaitiani. Quebata ema neje echuduchuduani mahue, tuahueda eberebereatani. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","‘Diusu ja quebata juchaji papu biame perdonata cua. Ahua quebata quema puji madhada hue emimiani su, tueda Diusu ja perdonata cua. Beju aimue Diusu ja eperdonata mahue Espíritu Santo sa puji madhada hue emimitani cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jesús ja daja hue fariseo cuana quisainiame atana uja: —Equi saida da ejaja saida epuani. Equi saida mahue mu ejaja saida mahue epuani. Pamapa equi cuana ejaja jepuiti etse eshanapainia. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Beju micuaneda da deja ate, bacua d'aida nime. Ai saida mimi cuana a bue mahue, micuaneda da deja madhada hue putsu. Beju etse emimiani, cuaja etse epibainia batame. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Saida epibatiani deja beju ai saida cuana jepuiti bahui emimiani. Daja huecha madhada hue epibatiani deja beju ai madhada cuana bahui emimiani. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ene putsu, yama micuana equisainia, Diusu sa castigo tsine su pamapa micuaneda mimi madhada mimiana cuana jepuiti ejeutsutiyu. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ahua micuana sa mimi cuana da saida, ahua madhada hue Diusu ja ebata. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Da su beju piada piada fariseo, jacuatsasiati ebuetsuaji cuana ja Jesús uja atana: —Ebuetsuaji, piada nimetiuda aida aque. Bameque ecuanaju ahua mida ene quita Diusu sa Jabeituti Deja su. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesus ja atana huecuana: —Beju micuaneda da deja madhada bubeta cuana. Micuaneda ema ebajainia yama nimetiuda aida ya puji biame, aimue yama ya mahue. Cuaja Diusu sa profeta Jonás chenu puidha, tueda da micuaneseda puji nimetiuda aida papu. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Cuaja Jonás chenu se aida sa edhe su quimisha tsine badeidha nime, daja nime ema tumu epa sepulcro su quimisha tsine esa. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nínive ejude su anitaidha cristiano cuana Diusu peje su japibaturucatitaidha, Jonás chenu ja Diusu sa quisa saida 8uana quisaquisa ataidha huecuana su. Beju jiahue upia ema Jonás chenu ebia su aida biame, aimue micuaneda quema quisa cuana jei aja mahue yainia. Aimue micuaneda Diusu peje su japibaturucatija mahue, cuaja Nínive ejude su anitaidha cristiano cuana putaidha nime. Da putsu, Diusu ja micuana ematsetayu. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Biahua tiempo echua puji aida epuna chenu uqueda yahua jenetia putidha echua puji Salomón chenu peje su mesa bahue eni quisa cuana eid'aba puji. Beju jiahue upia ema Salomón chenu ebia su bahue eni biame, aimue micuaneda quema euisa id'abaja yainia mahue. Da putsu, Diusu ja micuana ematsetayu castigo tsine su, micuaneda quema bahue eni quisa cuana id'abaja mahue ana putsu, cuaja tueda echua puji aida epuna chenu ja Salomón chenu sa bahue eni quisa cuana id'abataidha nime. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jesús ja daja hue buetsuainiame atana uja: ‘Einid'u madhada deja peje jenetia ecuinanani su, d'anita yahua je yaseni janahua jude echacu puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Aimue teje yatani su, epibapirutiani uja: “Ema pasiapati ema cuinanaitia ete su.” Da su beju deja peje su esiapatiani su, tueda deja da ete saida, memahue, basetajiji nime ebatani. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Da su neicha ecuinana pia siete tu ebia su madhada einid'u cuana eduse puji. Beju pamapa su deja sa equita dume su enubitani dapia yaniti puji. Da su tueda deja biahua puina ebia su madhada epuani. Daja da pamapa cristiano madhada cuana epu. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Beju Jesús ja ete su cristiano cuana daja equisatani cama, mesa cuara, edue cuana cuinatana. Etseque su hue netisenatana huecuana. Jesús neje jamitsutija pudhaatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Da su piada ja Jesús uja quisatitana: —Mique cuara, edue cuana etseque su enetita. Mi neje jamitsutija huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Da su Jesús ja jeutsutana uja: —Yama da micuana equisa aidhe quema cuara, edue cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Da su Jesús ja mesa discípulo cuana mehuitu putsu, uja atana: —Ye cuana da quema cuara, edue cuana pu cua nime. ");
INSERT INTO tnaNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Quebata cuana ja Diusu sa tsada ai cuana yatani, tuneda da quema cuara, edue cuana pu cua nime. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Beju pia tsine Jesús ete jenetia cuinanana. Bai maje su puti putsu, aniuteana. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tu peje su dueji cristiano cuana jadhitapirutitana putsu, Jesús canoa aida su nubiana. Dapia canoa dume su aniuteana. Cristiano cuana bai maje su anititana. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Da su Jesús ja bahue quisa cuana neje buetsuapirutana huecuana uja: ");
INSERT INTO tnaNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","—Beju piada deja putiana ejaja cuana ehuararati puji. Ehuararatani cama, piada piada ejaja cuana edid'i je dajajatana. D'ia janana cuana pue putsu, beju edid'i je dajajatana ejaja cuana diapetana. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Pia ejaja cuana dajajatana tumu med'i pamuda mahue su. Beju tipeida huid'atatana. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Med'i pamuda mahue putsu, beju sarapetana huid'atatana cuana, id'eti sinada puana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Pia ejaja cuana junu quid'aji cuana duju su dajajatana. Beju murutana cuana junu quid'aji cuana ja babubabuatana. Babubabuatana putsu, beju manuamepetana. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pia ejaja cuana mu med'i saida su dajajatana. Saida murutana. Dueji ejaja putana. Piada piada equi cuana cien ejaja putana. Pia cuana sucuta tunca ejaja putana. Pia cuana quimisha tunca ejaja putana. Daja jajucuatitana ejaja cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ahua micuaneda id'ajararaji su, beju meid'abaque. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Da su discípulo cuana ja Jesús quisabatana uja: —¿Jucuaja ni da miada bahue quisa neje bahui cristiano cuana ebuetsuainia? ");
INSERT INTO tnaNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Da su Jesús ja jeutsutana huecuana uja: —Diusu ja micuaneda bahui tu ecuatsasiati etsia ai quisa cuana eshanapametani. Aimue pia cuana mu eshanapametani mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Quebata ja Diusu sa piba shanapaja su, Diusu ja mesa piba cuana ebia su eshanapameenitayu. Quebata ja aimue shanapaja mahue su, Diusu ja tueda aimue ai biame eshanapameta mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Da putsu, yama bahue quisa neje bahui ebuetsuainia huecuana. Tuneda echamatani biame, aimue ebatani huecuana mahue. Eid'abatani huecuana biame, aimue eshanapatani huecuana mahue. Da putsu, yama bahue quisa neje ebuetsuainia huecuana, aimue shanapaja yatani huecuana mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Isaías chenu ja biahua tiempo uja deretaidha tuna jepuiti: Tuneda eid'abatani biame, aimue eshanapatani huecuana mahue. Echamatani huecuana biame, aimue ebatani huecuana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Daja eputani huecuana, mecuana sa muesumu tadada putsu. Aimue id'abaja, baja yatani huecuana mahue. Aimue saida shanapaja yatani huecuana mahue. Aimue ema peje su pueja eputani huecuana mahue yama esaisiame huecuana puji. ‘Daja da Isaías ja deretaidha biahua tiempo tueda cristiano cuana jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Daja hue Jesús ja mesa discípulo cuana quisainiame atana: —Beju micuaneda beidaji epuani yama ai ana cuana ebainia putsu, quema quisa saida cuana eid'abainia putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ene putsu, yama micuana equisainia, biahua tiempo profeta, Diusu peje su jei eputani chenu cuana ja jiahue micuaneda ebainia cuana baja adhaataidha. Jiahue quema micuaneda eid'abainia quisa cuana di id'abaja adhaataidha huecuana. Cuaja a taji mahue bataidha huecuana, biahua tiempo jenetia anitaidha putsu. Beju micuaneda mu beidaji, ema neje yani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","‘Meid'abaque ema. Yama micuana equisa ejaja cuana huararaji bahue quisa cuaja epuani. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Piada piada ejaja cuana edid'i su dajajatana. Daja nime da Diusu sa quisa eid'abatani cuana. Id'aba putsu, aimue eshanapatani huecuana mahue. Ishahua pue putsu, tueda Diusu sa quisa cuana mecuana sa muesumu su yani emejemitani. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Beju pia ejaja cuana dajajatana tumu med'i pamuda mahue su. Daja nime da pia Diusu sa quisa eid'abatani cuana. Tipeida, beidaji neje tueda quisa cuana eid'abatani huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Quejucua tsine hue saida eputani huecuana. Beju ema jepuiti mecuana sa sufri pu taji su, neicha hue equene su puina nime eputaniyu. Da su cuaja d'au pamuda ehuid'atatani cuana emanutani nime, daja tuneda quema quisa saida cuana jenetia enetideratani sufrimiento cuana jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Beju pia ejaja cuana dajajatana junu quid'aji cuana duju su. Daja nime da pia Diusu sa quisa eid'abatani cuana. Diusu sa quisa cuana eid'abatani huecuana biame, ye mundo sa madhada ai cuana ebia su tsada ebatani huecuana. Chipilu di ebia su tsada ebatani huecuana. Tuneda quitaita ebaseatitani, tueda ai cuana ema ebia su tsada ba putsu. Cuaja junu quid'aji cuana ja saida emurutani cuana etaitanamepetani nime, daja da ye mundo sa ai madhada cuana ja tueda quema quisa eid'abatani cuana emadhatiatani. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Beju pia ejaja cuana mu dajajatana med'i saida su. Daja nime da pia Diusu sa quisa eid'abatani cuana. Butsepi eshanapatani huecuana. Cuaja med'i saida su ejaja cuana ebia su ejucuatitani nime, daja Diusu sa puji ebia su ai mudu saida cuana yatani huecuana. Ejaja jajucuatitana nime da huecuana. Piada piada cien ejaja putana. Pia sucuta tunca ejaja putana. Pia quimisha tunca ejaja putana. Daja da mecuana sa Diusu sa puji mudu saida cuana ejucuatitani. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Beju Jesús ja pia bahue quisa discípulo cuana uja quisatana: —Diusu ecuatsasiati da uja: Piada deja ja arusu ejaja banatana te su. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Beju dhidha su pamapa etahuitasa su, te emetse neje eduininiani deja te su putiana arusu duje id'ene madhada ebana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Beju arusu saida muruana su, id'ene madhada di arusu neje tupupai muruana. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Da su te quinaji cuana ja ba putsu, emetse quisatitana huecuana uja: “Echua puji, ¿que je bataji pujiji arusu duju su id'ene madhada? ¿Aimue jia maida ejaja saida ecuaneda banana mahue? ¿A mique tsada ecuanaju id'ene madhada emutsuti?” ");
INSERT INTO tnaNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","29","Da su emetse ja uja jeutsutana huecuana: “Ema duininibaji ja id'ene madhada banatana. Be memutsuji tsuhu. Cuapuitime arusu di id'ene neje tupupai micuaneda mutsu cua. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ebia su saida tupupai pamuru. Beju eraja tiempo ecuina su, mudu puji cuana yama te su ebeitu id'ene madhada cuana arusu neje tupupai pamutsuta huecuana puji. Da su id'ene madhada cuana jeji a putsu, parisita huecuana ed'ed'a puji. Beju arusu quema ichaseta jude su paichasetata huecuana.” ‘Daja da Diusu ja eichaderatayu chujemame tu peje su jei eputani cuana jei puja mahue cuana peje jenetia. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Da su Jesús ja pia bahue quisa discípulo cuana quisatana. Uja atana huecuana: —Diusu ecuatsasiati da mostaza ejaja nime. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tueda ejaja da pamapa pia ejaja cuana ebia su huai chidi biame, bana putsu, pamapa pia equi cuana ebia su aida emuruani. D'ia janana cuana echa su esaji cuana yatitani. Daja da Diusu ecuatsasiati epupiruani mostaza ejaja nime. Da su beju aida epuani. Equene quejucua chidi cristiano cuana tu peje su jei eputani biame, da su beju pamapa ejude su aniji cuana jei eputayu. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesús ja pia bahue quisa neje discípulo cuana quisatana uja: —Diusu ecuatsasiati da levadura harina bebajiji dume su nime. Epuna ja levadura harina neje ehuarutani. Tueda levadura ja pamapa harina bebajiji etutsuametani. Daja nime da Diusu ecuatsasiati. Equene quejucua chidi cristiano cuana tu peje su jei eputani biame, da su beju pamapa ejude su aniji cuana jei eputayu. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesús ja cristiano cuana tueda ai cuana buetsuatana bahue quisa cuana neje bahui. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Daja puana Jesús, cuaja Diusu sa profeta chenu ja biahua tiempo deretaidha batame. Uja Diusu puidha, profeta chenu ja deretaidha: Yama bahue quisa neje bahui ebuetsua huecuana. Diusu sa etsia quisa cuana yama bahue quisa neje equisa huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesús ja cristiano cuana buetsuape putsu, ete su putibana. Discípulo cuana neje ete su nubiana. Nubi putsu, discípulo cuana ja tueda uja atana: —Quisaque ecuanaju butsepi cuaja epuani mique id'ene madhada jepuiti bahue quisa. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Da su Jesús ja uja quisatana huecuana: ");
INSERT INTO tnaNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","—Mundo da te pu cua nime. Ema da te emetse pu cua nime. Ema da ejaja huararaji pu cua nime, cristiano cuana yama saida equisainia putsu. Arusu ejaja cuana da ema peje su jei eputani cuana pu cua nime. Id'ene madhada da ema peje su jei puja mahue cuana pu cua nime. Tuneda da Ishahua sa cristiano cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Id'ene madhada banaji da Ishahua pu cua nime. Eraja tiempo da Diusu sa castigo tsine epusiu pu cua nime. Rajarajaji cuana da Diusu sa ángel cuana pu cua nime. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Beju cuaja id'ene madhada ejemitsuatani huecuana ed'ed'a puji nime, daja ángel cuana ja yatayu cristiano madhada cuana, Diusu sa castigo tsine ecuina su. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Da hora su beju yama quema ángel cuana ebeitu pamapa cristiano cuana jucha ameji, ai madhada yatani cuana Diusu ecuatsasiati jenetia ejemicuina puji, cuati castigo su ejusianubia huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Dapia epadaritita, etsedhaitita, ebia su sufri eputa huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Diusu sa dharejiji cuana mu Tata Diusu sa ecuatsasiati su beidaji neje yanienititayu. Ahua micuaneda id'ajararaji su, beju meid'abaenique. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Daja hue Jesús ja buetsuainiame atana huecuana: —Diusu ecuatsasiati da chipilu yahua ped'u su erubuani pu cua nime. Piada deja ja tueda chipilu etejetani su, neicha dapia hue erubuataniyu. Beju putiyu putsu, beidaji neje mesa pamapa ai cuana eirupetani tueda yahua ped'u tipeida ebaja puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","‘Daja huecha Diusu ecuatsasiati da perla chujeneda saida pu cua nime. Piada iruiruji deja da pamapa ejude cuana je epuniuneti perla chujeneda, saida cuana eteje puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Beju piada perla ebia su aida, chujeneda teje putsu, beidaji neje mesa pamapa ai cuana eirutani tueda perla tipeida ebaja puji. Daja nime quema quisa saida cuana. Chipilu erubuani, perla chujeneda pu cua nime. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","‘Diusu ecuatsasiati da tarrafa aida pu cua nime. Esia puji deja cuana ena su jusia putsu, dueji tsapiapiati se cuana ejemitsuatani huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tarrafa beju sejea su, eriretsuatani huecuana emaje su. Dapia se cuana edharepirutani huecuana. Pamapa se saida cuana beju d'iti cuana su eichasetatani huecuana. Pamapa saida mahue se cuana beju ejusiatani huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Daja da epu castigo tsine su, ye mundo epupe su. Da hora su Diusu sa ángel cuana ja eichaderatayu chujemame Diusu sa dharejiji cuana cristiano madhada cuana peje jenetia. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Dhare putsu, cristiano madhada cuana cuati castigo su ejusinubiata huecuana. Dapia tueda cristiano madhada cuana ebia su epadaritita, etsedhaitita, ebia su sufri eputa huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Beju daja Jesús ja discípulo cuana buetsuatana. Buetsuape putsu, uja quisabatana huecuana: —¿A da micuaneda eshanapainia quema quisa? Da su jeutsutana huecuana uja: —Ehe, Echua Puji. Eshanapainia ecuanaju. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Da su Jesús ja uja atana huecuana: —Ahua quebata Moisés chenu sa jacuatsasiati ebuetsuaji da quema jabuetsuati su jei epu su, beta ai chujeneda saida detse mesa pu cua nime. Jacuatsasiati edhi, quema jabuetsuati eichacua di mesa tupupai yani, ahua ema peje su jei epu su. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Beju Jesús ja daja quisape putsu, mesa ejude Nazaret su putiana. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Dapia cuinati putsu, jadhitati jude ete su buetsuapirutana. Dapia cristiano cuana tu jepuiti nimetiutana. Tuneda cama jaquisabatitana uja: —¿Que jenetia jia da ye deja tueda bahue eni ai cuana jabuetsuatiana? ¿Cuaja ni da tuahueda ye ai nimetiuda cuana ame yatani? ");
INSERT INTO tnaNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Aimue jia maida tueda carpintero José sa ebacua mahue? Mesa cuara da María. Mesa edue cuana da Jacobo, José, Simón, Judas. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Mesa dudu cuana di upia yanita. Beju pamapa mesa familia cuana upia ecuana duju su yanita. Da su, ¿cuaja ni da tueda ai bahue eni cuana nime bahue pu cua? ");
INSERT INTO tnaNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Da putsu, aimue Jesús peje su jei putana huecuana mahue. Da su Jesús ja uja atana huecuana: —Diusu sa profeta sa ejude quitaita su aniji cristiano cuana ja aimue tueda saida ebatani mahue. Mesa familia quitaita cuana ja di aimue tueda saida ebatani mahue. Pia ejude su aniji cuana ja bahui profeta saida ebatani. ");
INSERT INTO tnaNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Da su Jesús ja dapia mesa ejude quitaita su quejucua hue ai nimetiuda cuana atana, dapia cristiano cuana tu peje su jei puja mahue putana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Da tiempo su echua puji Herodes Antipas da huaraji aida puina Galilea yahua su. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tuahueda Jesús jepuiti id'abatana putsu, mesa emebajaji cuana uja atana: —Tueda Jesús da Juan Bautista manujiji cuana duju jenetia id'eyujiji. Da putsu, tueda tucheda eni ai nimetiuda aida cuana ya puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Daja mimiana Herodes Antipas Juan Bautista manuametana putsu. Equene Juan teriichanubiametana. Daja Herodes ja Juan atana, Juan ja tueda tuaquisatana putsu. Juan ja Herodes Antipas jubida d'ayatana, Herodes Antipas ja mesa edue Felipe sa ehuane Herodías neje jahuanetiana putsu, Felipe eid'e hue biame. Da putsu, Herodes Antipas ja Juan teriametana. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Uja equene Juan ja Herodes Antipas jubida d'ayatana: —Be Herodías mique ehuane nime dusuji, Felipe neje jahuanetijiji tupu. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Da su Herodes Antipas ja Juan tipeida manuameja adhaatana. Daja biame, mue manuame atana, cristiano cuana iyuba putsu, Juan da Diusu sa quisa puji batana huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Da su beju Herodes Antipas sa tu bataji puana tsine cuinana su, Herodías sa ebaquepuna ihuajiji cuana butse su tu mehua tiritiriana. Beju Herodes Antipas sa ebia su tsada puana. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Da su Herodes ja epuneje uja atana: —Diusu bahue ema epu. Ai papu mique jabajati cuana yama mi etia, mique tiritiri quema ebia su tsada putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Da su epuneje mesa cuara neje jaquisabatiana. Herodías ja tueda uja quisatana: —Bajatique Juan Bautista sa echua dhepe su. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Beju daja epuneje ja bajatana su, Herodes Antipas ebia su jatacuamadhatiana. Ihuajiji cuana butse su Diusu bahue puana putsu, daja mesa a taji puana. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Beju da hora su cuatsasiatana soldado cuana Juan pachuarijitita huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Da su beju echua dusetana huecuana dhepe su. Epuneje menajatiatana huecuana. Da su tuahueda mesa cuara tiaderatana. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Juan sa ebuqueji cuana mesa equita dusu putsu, papatana huecuana. Da su Jesús quisatitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesús ja shanapa putsu, mue aidhebiame ani eti jude su putiana tu mehua yaniti puji. Canoa aida su putiana. Beju cristiano cuana bahue puputsu, pamapa ejude jenetia cuinanatana huecuana Jesús tije ya puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesús beju chu maje cuinati putsu, cristiano cuana murida je putitana tu etejetiyu puji. Jesús ja canoa aida jenetia cuinana putsu, dueji cristiano cuana tu peje su epusiu batana. Jesús ja ba putsu, ebia su bataichenu batana huecuana. Pamapa nedaji cuana saisiamepirutana. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Beju tsinecua edhememehu su discípulo cuana ja Jesús uja quisatana: —Beju tsinecua edhememehu. Ye cristiano cuana sa ete cuana uqueda. Da putsu, beituyuque huecuana ejude cuana naja je tuna sa ai dia taji cuana pachacutitita huecuana puji, beju upia mu mue ai biame ani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesús ja jeutsutana huecuana: —Aimue da eputitayu mahue. Micuaneda hue memihuaque huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Da su uja atana huecuana: —Beju pishica pan chidi cuana, beta se chidi detse bahui ecuanaju sa yani. Ai detse tueda tupu pu cua. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Da su Jesús ja cuatsasiatana huecuana: —Pan chidi cuana, se detse meduseque. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jesús ja cristiano cuana cuatsasiatana pamapa paniuteta huecuana puji nutsa bia su. Pamapa aniutetana su, Jesús ja pishica pan chidi cuana, se detse di inatana. Cielo huabata jachamati putsu, diusulupai atana Tata Diusu. Pan cuana, se detse ped'uped'ua putsu, discípulo cuana menajatiatana cristiano cuana paberereatiata huecuana puji. Discípulo cuana ja cristiano cuana eberereatiatani cama, pan, se ped'u cuana jajucuatitana. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Beju pamapa cristiano cuana diadiatana tupu. Pan cuana, se detse beju puchu puana. Eped'u cuana chudutana huecuana. Piada tunca beta ejaitiana d'iti cuana sejeatana huecuana puchu cuana neje. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Beju pishica mil deja cuana diadiatana. Dueji epuna, yanana cuana dapia anitaina. Tuneda di diadiatana tupu. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Da su beju Jesús ja mesa discípulo cuana canoa aida su nubiametana bai papetuta huecuana puji tu hui su. Tuna yanipetutahu cama, Jesús ja cristiano cuana tuna sa ete cuana je beitupetaibana. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Beju tuna pupetitaiba su, Jesús murucu aida bia su tsuatiana tu mehua quejucua hora chidi yaniti puji, Diusu emitsu puji. Beju dhidha teje dapia tu mehua aniana. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Mesa discípulo cuana da bai dusete su anipetutasaina cama, beni ja ena jubida dhapujutana putsu, ena canoa su nubipiruana. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Beju huenahua su Jesús batana huecuana ena bia je quitaita yasesiu. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Daja ba putsu, rubutanapirutana huecuana. Jubida tsiatsiatana huecuana, iyuame pu putsu. Uja tsiatsia neje mimitana huecuana: —¡Beju enid'u ecuaneda ebainia! ");
INSERT INTO tnaNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Da su Jesús ja jubida uja atana huecuana: —¡Menimetucheatique! ¡Beju ema hue! ¡Be iyuame mepuji! ");
INSERT INTO tnaNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pedro ja atana Jesús: —Echua Puji, ahua enei hue mida su, tsahuaque ema mi peje su ena bia je ecuinati puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Da su Jesús ja Pedro jeutsutana: —Pueque hue da. Pedro canoa jenetia cuinana putsu, ena bia je asepiruana Jesús peje su. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Beju beni jubida epuneti ba putsu, Pedro tipeida iyuame puana. Ena su nubipiruana. Enubiani jabati putsu, jubida tsiatsia neje uja atana Jesús: —¡Echua Puji, tsahuaque ema! ");
INSERT INTO tnaNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Da hora su beju Jesús ja Pedro eme su inatana. Uja atana Pedro: —¿Jucuaja su ni mi ema peje su mue janimetucheati? ");
INSERT INTO tnaNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Beju tuatseda canoa su nubitiana su, beni mitanana. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Canoa dume su Jesús butse su tururutana huecuana pamapa. Uja atana huecuana: —Enei hue, mida da Diusu sa Ebacua. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Daja anipetutitana huecuana. Genesaret yahua su satsuatitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Beju tueda yahua su aniji cristiano cuana ja Jesús ba putsu, pamapa ejude su aniji cuana quisametana huecuana. Da su cristiano cuana bahue pu putsu, pamapa nedaji cuana dusetana huecuana Jesús peje su. ");
INSERT INTO tnaNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Jesús sa ejud'uji tihue dhucuana d'apabaja atana huecuana. Pamapa ejud'uji d'apabatana cuana beju saisitana. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Da su beju piada piada fariseo, jacuatsasiati ebuetsuaji cuana ja Jesús nariatana. Jerusalén ejude jenetia puetana huecuana Jesús yaba puji, tu etuaquisadhaa puji. Beju uja quisabatana huecuana Jesús: ");
INSERT INTO tnaNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Jucuaja su mique discípulo cuana ja ecuana sa tata chenu sa puiti cuana jei aja mahue? Beju aimue tuna sa eme erucuatitani huecuana mahue ediadia puji ecuana sa puiti daja biame. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Da su Jesús ja uja quisatana huecuana: —Micuaneda Diusu sa jacuatsasiati cuana aimue aja yainia mahue, micuana sa ai puiti cuana bahui aja putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Uja Diusu ja cuatsasiataidha: “Iyubaque mique tata detse. Ahua quebata papu mesa tata detse emadhabata su, tueda pamanu.” ");
INSERT INTO tnaNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Beju micuaneda mu cristiano cuana tsapia hue ebuetsuainia uja: “Ahua quebata papu mesa chipilu Diusu etiata su, beju aimue mesa tata, cuara detse chipilu neje tsahua taji mahue, pamapa Diusu tiatana putsu.” ");
INSERT INTO tnaNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Beju aimue daja epuani mahue Diusu sa jacuatsasiati. Micuaneda micuana sa puiti cuana bahui buetsua putsu, tueda jacuatsasiati cuanaai eni mahue nime yameinia. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Micuaneda da bubeta cuana. Diusu ja uja butsepi ataidha micuana jepuiti Isaías ja deretaidha: ");
INSERT INTO tnaNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ye cristiano cuana ja ema eiyubatani mimi neje bahui. Aimue ema ene putsu tuna sa muesumu neje eiyubatani huecuana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","¿Ai puji saida tuna sa ema peje su jamitsutsuati cuana pu cua? Beju tueda da yanacane hue, tuna sa jabuetsuati quitaita cuana bahui ebuetsuatani huecuana putsu. Aimue quema jabuetsuati cuana mu ebuetsuatani huecuana mahue. Daja Diusu puidha micuana jepuiti Isaías chenu ja deretaidha. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Da su Jesús ja cristiano cuana uja atana: —Meid'abaque ema. Meshanapaenique. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Etse ediainia cuana ja aimue detse etse madhata cua mahue. Beju etse emimiani cuana ja mu ene putsu etse emadhatani. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Da su discípulo cuana ja Jesús naria putsu, uja atana huecuana: —Echua Puji, fariseo cuana da duininitaitia, mique mimi cuana daja id'aba putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Da su Jesús ja uja jeutsutana huecuana: —Pamapa Tata Diusu ja banatana mahue equi cuana chu ed'auna emutsupeta. Daja huecha Diusu ja id'ene madhada nime cristiano cuana emutsupeta cuati castigo su ebeitueniyu puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Be jatacuamadhatiji fariseo cuana neje, beju padha nime huecuana putsu. Padha nime huecuana biame, cristiano cuana huidusuja eputani huecuana. Da su padha nime cama pahuidusutita huecuana. Ahua piada padha ja pia padha ehuidusuta su, betana su rara su edajajati tse. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Beju Pedro ja Jesús atana: —Quisaque ecuanaju cuaja mique quisa epuani. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Da su Jesús ja atana huecuana: —¿A da micuaneda di pia cuana nime aimue eshanapainia mahue? ");
INSERT INTO tnaNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Beju pamapa ediatiani ai cuana ecuatsa je enubiani putsu, edhe su ecuinahu. Da su beju equita jenetia ecuinanani. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Aimue detse tueda ai cuana ja deja madhata cua mahue. Mimi madhada cuana ja mu ecuatsa jenetia ecuinanani putsu, deja emadhatani, tueda mimi madhada cuana muesumu jenetia ecuinanani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Beju cristiano cuana sa muesumu madhada hue putsu, pamapa ai madhada cuana yatani huecuana. Cristiano emanuametani huecuana. Pia sa ebutse quinaji eputani huecuana. Utsatada madhada cuana yatani huecuana. Tsi eputani huecuana. Bid'umimi eputani huecuana. Pia sa ebani cha jemitsua hue yatani huecuana. Beju pamapa tueda ai madhada cuana yatani huecuana, tuna sa muesumu madhada hue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tueda ai madhada cuana muesumu jenetia ecuinanani ja cristiano cuana emadhatani. Beju ahua etse jamerucuatiji mahue ediadia su, aimue etse emadhati mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Da su beju Jesús da jenetia cuinanana. Tiro, Sidón ejude detse naja su beju putiana. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Dapia yahua su piada judío mahue epuna tu peje su pueana. Tueda epuna da Canaan yahua jenetia puina. Tuahueda jubida Jesús tsiatsia neje uja bajatana: —¡Echua Puji, David chenu sa familia jenetia, ibunebaque ema! Quema ebaquepuna einid'u madhadaji. Tuneda ebia su sufri yametani. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesús ja mue jeutsu epuna. Da su mesa discípulo cuana ja uja atana: —Cuadeque tueda epuna, ecuana tije etsiatsiasiu putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Da su Jesús ja epuna atana uja: —Diusu ja ema beitutana tu peje jenetia judío jeitid'ujiji cuana peje su bahui. Beju aimue mida judío mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Da su epuna ja Jesús naria putsu, tu butse su tururuana. Jubida uja Jesús bajatana: —¡Echua Puji, tsahuaque ema! ");
INSERT INTO tnaNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Da su Jesús ja epuna jeutsutana uja: —Saida mahue ebacua sa jana mejemi putsu, uchi cuana etia puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Beju daja Jesús ja jeutsutana biame, epuna ja uja atana: —Ehe, Echua Puji, mida ene putsu butsepi emimiani biame, uchi cuana ja di puchu cuana emetse sa misha jenetia yahua su edajajatani cuana ediatani. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Da su Jesús ja epuna uja atana: —Epuna, ebia su mida ema peje su enimetucheatiani yama ebainia. Da putsu beju, mique jabajati daja papu. Da hora jenetia epuna sa ebaquepuna beju saisibana. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Da su beju Jesús da jenetia Galilea bai maje je jaitianana. Murucu aida su tsuati putsu, dapia aniuteana. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tu peje su dueji cristiano cuana puepirutana. Pamapa piapiati nedaji cuana dusetana huecuana. Tida, padha, mimi bue mahue, bai riji cuana beju dusetana huecuana tuahueda pasaisiameta huecuana puji. Beju Jesús ja saisiametana huecuana pamapa. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Da su cristiano cuana ebia su nimetiunetitana, pamapa tueda nedaji cuana saida, saisijiji ba putsu. Diusu saida mitsutsuapirutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesús ja cristiano cuana dueji ba putsu, discípulo cuana uja atana: —Ebataichenubainia yama ye cristiano cuana. Beju quimisha tsine upia ema neje yanita putsu, jana mahue ta beju. Yama beituja mahue huecuana tuna sa ete su diadiaji mahue. Cuapuitime edid'i su nimetaitanata cua huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Da su mesa discípulo cuana ja uja quisabatana: —¿Que jenetia ni da ecuana teje cua jana tupu dajucua cristiano cuana emihua puji? Ye eti jude su aimue aidhe biame ani ai dia taji cuana ebaja puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Da su Jesús ja quisabatana huecuana: —¿Quejucua pan chidi cuana micuana sa yani? Beju jeutsutana huecuana: —Siete pan chidi cuana ecuanaju sa yani. Quejucua chidi se cuana di ecuanaju sa yani. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Da su Jesús ja cuatsasiatana cristiano cuana yahua su paaniuteta puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Beju siete pan chidi, se cuana di ina putsu, diusulupai Diusu atana. Pan chidi, se cuana ped'uped'ua putsu, discípulo cuana menajatiatana cristiano cuana paberereatiata huecuana puji. Discípulo cuana ja cristiano cuana eberereatiatani cama, pan, se ped'u cuana jajucuatitana. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Beju pamapa cristiano cuana diadiatana tupu. Pan chidi, se cuana beju puchu puana. Eped'u cuana chudutana huecuana. Siete d'iti cuana sejeatana huecuana puchu cuana neje. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Pushi mil deja cuana diadiatana. Jucuada epuna, yanana cuana dapia anitaina. Pamapa tuneda di diadiatana tupu. ");
INSERT INTO tnaNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Da su beju Jesús ja cristiano cuana beitutana tuna sa ete cuana je. Beituyu putsu, canoa aida su nubiana Magdala yahua su eputi puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseo, saduceo cuana da Jesús peje su putitana mimi neje yaba puji, tu etuaquisa puji. Da su Jesús bajatana huecuana piada nimetiuda aida paata puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Beju Jesús ja jeutsutana huecuana uja: ");
INSERT INTO tnaNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","—Tsinecua su micuaneda buepa echamainia ahua saida ahua mahue ehuenati eshanapa puji. Daja huecha apudaya su buepa chama putsu, beju micuaneda bahue tsine saida epu ahua mahue. Micuaneda da bubeta cuana. Buepa ba putsu, micuaneda nai epu ahua mahue eshanapainia. Daja biame, aimue micuaneda mu Diusu ja ai yatani cuana eshanapainia mahue, quema ai nimetiuda ajiji cuana ba putsu. Mue shanapa micuaneda Diusu ja ema ye nimetiuda aida yametani. ");
INSERT INTO tnaNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Micuaneda da deja bubeta, ate cuana. Micuaneda ema ebajainia yama nimetiuda aida ya puji. Beju aimue yama ya mahue. Cuaja Diusu sa profeta Jonás chenu puidha, tueda da micuaneseda puji nimetiuda aida papu. Beju Jesús ja netiajusia huecuana putsu, putiana. ");
INSERT INTO tnaNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Da su Jesús, mesa discípulo cuana neje bai chu maje anipetutiana. Beju discípulo cuana ja jana edusu puji setatana. ");
INSERT INTO tnaNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesús ja uja atana huecuana: —Merejatique fariseo, saduceo cuana sa levadura neje. ");
INSERT INTO tnaNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Da su discípulo cuana uja jaquisabatitana: —¿Cuaja su Jesús daja epuani? Mue ecuaneda pan duse aitia putsu jia, daja epuani. ");
INSERT INTO tnaNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús ja tuna daja equisatitani shanapatana. Da su uja quisabatana huecuana: —¿Jucuaja su daja micuaneda epuani? Aimue micuaneda ema peje su jubida enimetucheatiani mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Jiahue teje jia maida micuaneda aimue eshanapainia mahue? ¿Aimue jia maida micuaneda cuaja yama pishica mil deja cuana pishica pan chidi cuana neje mihuana epibainia mahue? ¿Quejucua d'iti cuana puchu cuana neje micuaneda sejeana? ");
INSERT INTO tnaNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Aimue jia maida micuaneda cuaja yama pushi mil deja cuana siete pan chidi cuana neje mihuana epibainia mahue? Da tsunu, ¿quejucua d'iti cuana puchu cuana neje micuaneda sejeana? ");
INSERT INTO tnaNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Jucuaja su micuaneda aimue eshanapainia mahue? Beju aimue ema pan jepuiti quisa puitia mahue, micuana yama levadura jepuiti quisaitia su. ");
INSERT INTO tnaNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Da su beju ye chu discípulo cuana ja shanapaenitana Jesús ja quisatana huecuana fariseo, saduceo cuana sa jabuetsuati cuana neje parejatita puji. Aimue pan sa levadura neje parejatita puana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Da su beju Jesús, mesa discípulo cuana neje Cesarea Filipo yahua su putiana. Dapia mesa discípulo cuana uja quisabatana: —¿Cuaja ni da cristiano cuana ema jepuiti eputani? ");
INSERT INTO tnaNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Beju jeutsutana huecuana: —Piada piada mida pa Juan Bautista chenu id'eyujiji eputani. Pia cuana mida pa Eliás chenu id'eyujiji eputani. Pia cuana mida pa Jeremías chenu id'eyujiji eputani. Pia cuana mida pa pia Diusu sa profeta eputani. ");
INSERT INTO tnaNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesús ja quisabatana huecuana: —¿Aidhe ni da ema pu cua micuaneda epibatiani? ");
INSERT INTO tnaNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Da su Simón Pedro ja Jesús jeutsutana uja: —Mida da Diusu sa Jabeituti Deja. Diusu eid'e eni sa Ebacua da mida. ");
INSERT INTO tnaNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Da su Jesús ja Pedro atana: —Beidaji mida, Simón, Jonás sa ebacua. Butsepi mida jajeutsutaitia, quema Tata Diusu ja mida shanapametana putsu. Aimue aidhe deja ja biame mida tueda shanapametana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Beju yama mida equisainia, mique ebani da Pedro. Tueda ebani tumu epuani. Yama quitaita edhareinia quema dharejiji cuana pamapa ejude jenetia. Aimue Ishahua, einid'u madhada cuana ja tuna epishitiata mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Pamapa mique piba su aja yainia, aja mahue yainia cuana Diusu ja etsabatayu. ");
INSERT INTO tnaNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Da su Jesús ja discípulo cuana cuatsasiatana, tueda da Diusu sa Jabeituti Deja aidhe biame paquisata huecuana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Da hora jenetia Jesús ja mesa discípulo cuana quisapirutana cuaja pia cuana ja tu emanuameta. Jerusalén ejude su mesa puti taji quisatana huecuana. Judío cuana sa ehuidusuji, sacerdote huaraji aida, jacuatsasiati ebuetsuaji cuana ja cuaja Jesús ebia su sufri yameta quisatana huecuana. Cuaja tu emanuameta huecuana quisatana huecuana. Beju emanuameta huecuana su, quimisha tsine jaitianaja su, tueda eid'eyu manujiji cuana duju jenetia quisatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Daja Jesús ja quisapetana huecuana su, Pedro ja tueda chuadera dusutana. Chuadera tu mehua dusu putsu, d'ayapirutana Jesús uja: —Aimue Diusu sa tsada epu mahue mida daja yata huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Beju Jesús ja Pedro chamaeni putsu, uja atana: —Netideraque ema naja jenetia, Ishahua. Mida da ema naja su d'eji mahue eneti yama Diusu sa tsada ya puji. Deja cuana sa piba bahui mi emimiani. Aimue mi Diusu sa piba diuana mu emimiani mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Da su Jesús ja mesa discípulo cuana uja atana: —Quebata ja ema tije aja su, pamapa muesumu neje ema tije paata. ");
INSERT INTO tnaNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tusa manu teje ema tije paata, manuameja paata huecuana biame. Ema pamapa mesa ai cuana quitaita ebia su tsada pabata. ");
INSERT INTO tnaNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Ai puji saida ni da etse sa pamapa mundo sa chipilu cuana paani pu cua, etse cuati castigo su eputi biame. ¿Ai etse d'eji su epu puji chujetia cua bata? ¡Mahue! ");
INSERT INTO tnaNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Diusu sa Jabeituti Deja da ema. Quema Tata Diusu sa tucheda neje ema esiapatiyu. Pamapa quema ángel cuana neje ema esiapatiyu pamapa cristiano cuana ejuzgayu puji. Cuaja pamapa tuna ye mundo su atana cuana batame yama eturuca echuje etiayu huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ene putsu, yama micuana butsepi equisainia, piada piada micuaneda upia eneti aimue emanu mahue Diusu ecuatsasiati eba teje. ");
INSERT INTO tnaNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Beju sucuta tsine jaitianaja su, Jesús ja Pedro, Jacobo, Juan cuana dusutana murucu aida bia su. Tuneda bahui dusutana. ");
INSERT INTO tnaNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Dapia cuinati putsu, Jesús japiatiana tuna butse su. Mesa ebu id'eti nime cuarecuare puana. Mesa ejud'uji pasapasa cuarecuare hueda nime puana. ");
INSERT INTO tnaNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Da su Elías, Moisés chenu detse bataji puana eid'e batana huecuana. Jesús neje quisaquisa epuani tse batana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Da su Pedro ja Jesús uja atana: —Echua Puji, saida ecuaneda upia pamapa su meanija. Quimisha epahuaneti cuana ecuanaju paaiti, ahua mique tsada su. Piada miqueda puji, piada Moisés sa puji, piada Elías sa puji ecuanaju paaiti. ");
INSERT INTO tnaNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Beju Pedro daja emimiani cama, judu cuarecuare ja dunutana huecuana. Judu duju jenetia Tata Diusu ja atana huecuana uja: —Ye da quema ibuneda Ebacua. Tu neje ema beidaji. Tueda bahui meid'abaenique. ");
INSERT INTO tnaNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Da su tueda quimisha discípulo cuana ja daja Tata Diusu epuani id'aba putsu, ebia su iyuame putana. D'epesatana huecuana yahua su. ");
INSERT INTO tnaNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Da su Jesús tuna peje su janariatiana. D'apaba putsu, uja atana huecuana: —Menetianaque. Be iyuame mepuji. ");
INSERT INTO tnaNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Da su jababarereati huecuana putsu, Jesús tu mehua batana huecuana. Aimue Moisés, Elías detse netina mahue beju. ");
INSERT INTO tnaNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Da su beju murucu aida jenetia ebutetasa cama, Jesús ja uja atana huecuana: —Be aidhe biame mequisaji tsuhu micuaneda baitia ai cuana. Beju ema manujiji cuana duju jenetia enetianayu tsine su chu quisa mepuque. ");
INSERT INTO tnaNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tuneda murucu jenetia ebutesa cama uja Jesús quisabatana huecuana: —¿Jucuaja su ni da jacuatsasiati ebuetsuaji cuana ja cristiano cuana uja ebuetsuatani: “Diusu sa Jabeituti Deja pueji mahue su, Elías chenu sa equene pue taji.”? Beju mida Diusu sa Jabeotito deja pueana biame, aimue ecuanaju Elías chenu bana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Da su Jesús ja jeutsutana huecuana uja: —Ene putsu, Elías chenu ema equene pueana cristiano cuana ebaseta puji, ema painatsuta huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Beju tueda pueana biame, aimue shanapatana huecuana mahue. Madhada hue atsutana huecuana tu emanuame teje. Daja huecha cuaja tueda atana huecuana nime, ya di sufri yameta huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Da hora su chu, tueda quimisha discípulo cuana ja shanapaenitana Jesús Juan Bautista jepuiti quisa puana. Beju Juan da Diusu sa profeta Elías chenu nime puina, da su chu shanapaenitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Beju cristiano cuana yanita su cuinatana huecuana su, piada deja ja Jesús nariatana. Tu butse su tururu putsu, uja atana: ");
INSERT INTO tnaNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Echua Puji, ichenubaque quema ebacua einid'u madhadaji. Ai hora papu enimetaitanani. Cuati, ena su dajaja bahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Yama upia duseitia mique discípulo cuana peje su tu pasaisiameta huecuana puji. Beju cuaja jusiacuina taji mahue batana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Da su Jesús ja anititana discípulo cuana d'ayapirutana uja: —¡Ai! ¿Jucuaja su jia micuaneda jei puja mahue? ¿Que tupu teje jia quema micuana neje ani taji? ");
INSERT INTO tnaNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Edeahue dusetana huecuana su, Jesús ja einid'u madhada d'ayatana. D'aya putsu, edeahue peje jenetia cuinanametana. Da hora jenetia beju edeahue saisiana. ");
INSERT INTO tnaNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Cristiano cuana putitaibana su, discípulo cuana ja Jesús uja quisabatana: —¿Jucuaja su ni da ecuanaju einid'u madhada cuaja jusiacuina taji mahue baitia? ");
INSERT INTO tnaNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Jesús ja jeutsutana huecuana: —Micuaneda einid'u madhada cuaja jusiacuina taji mahue baitia, Diusu peje su micuaneda huai chidi hue enimetucheatiani putsu. Ene putsu, yama micuana equisainia, ahua micuaneda Diusu peje su mostaza ejaja chidi nime aihua dhucuana enimetucheati su, da su micuaneda ye emata: “U jenetia pia eti jude su puderaque”, cuatsasia cua. Ahua daja micuaneda ecuatsasia su, beju emata epudera. Pamapa ai atadhada eni cuana a cua, Diusu peje su enimetucheatiani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Beju Jesús da mesa discípulo cuana neje Galilea yahua je epuniuneti cama, quisapirutana huecuana cuaja deja madhada cuana ja tueda menajatiame yata emanuame puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Beju emanuameta huecuana biame, quimisha tsine jaitianaja su, tueda eid'eyu manujiji cuana duju jenetia quisatana huecuana. Daja Jesús ja quisapetana huecuana su, ebia su jatacuamadhatitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesús da mesa discípulo cuana neje Capernaum ejude su cuinatiana su, templo sa impuesto echujebajaji deja cuana ja Pedro batitana. Uja Pedro quisabatana huecuana: —¿A da mique ebuetsuaji ja templo sa impuesto echujetiata? ");
INSERT INTO tnaNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro ja jeutsutana huecuana: —Ehe, echujetiata da. Da su ete su nubiana su, Pedro mimiji mahue su, Jesús ja tueda uja quisabatana: —Quisaque ema, Simón, ¿aidhe cuana da ye mundo sa echua puji huaraji cuana ja impuesto cuana echujebajatani? Ahua tuna sa cristiano quitaita cuana, ahua extranjero cuana? ");
INSERT INTO tnaNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro ja jeutsutana uja: —Extranjero cuana. Da su Jesús ja atana: —Da su beju tuna sa cristiano quitaita cuana sa aimue chujetia taji mahue. Daja huecha yama templo sa impuesto aimue quema chujetia taji mahue, ema Diusu sa Jabeituti Deja putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Daja biame, yama impuesto echujetia eduininita mahue puji. Esia putique bai su. Equene se miada ejemitsua su, ecuatsa su piada chipilu eteje. Tueda chipilu neje beju chujetiatique impuesto. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Da su beju discípulo cuana janariatitana Jesús peje su. Uja quisabatana huecuana: —¿Quebata ecuanaju ebia su aida epu Diusu ecuatsasiati su? ");
INSERT INTO tnaNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Da su Jesús ja piada yanana ihuatana. Tuna duju su netia putsu, uja quisatana huecuana: ");
INSERT INTO tnaNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","—Ene putsu, yama micuana butsepi equisainia, etse sa nimemitsida pu taji ye yanana nime Diusu ecuatsasiati su enubi puji. Ahua aimue daja epu mahue su, aimue micuaneda Diusu ecuatsasiati su enubi mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Quebata micuaneda yanana nime nimemitsida epu su, tueda da ebia su aida epu Diusu ecuatsasiati su. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Quebata ja piada ema peje su jei epuani cristiano saida ebatsuta su, tueda da ema quitaita saida ebatsutani pu cua nime. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","‘Quebata ja piada eichacua ema peje su jei epuani cristiano tusa Diusu peje su janimetucheati etaitanameta su, tuseda puji ebia su saida pamanu bai dueda su tueda eichacua jei epuani cristiano sa janimetucheati taitanameji mahue su hue. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Beju ye mundo su jucuada ai cuana yani cristiano cuana sa Diusu peje su janimetucheati cuana etaitaname puji. Quebata ja daja etaitanameta huecuana su, Diusu ja tueda ematsetayu. ¡Aba tueda, ahua pia cuana daja etaitanameta su! ");
INSERT INTO tnaNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","‘Miada eme ahua ehuatsi neje jucha ya su, riji putsu, jusiaque uqueda. Ebia su saida meriji, huatsiriji cielo su eid'e eni eputi puji, aimue cuati castigo su meji, huatsiji eputi mahue puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Daja huecha ahua miada etua neje jucha ya su, huijajuseque. Ebia su saida tua mahue cielo su eid'e eni eputi puji, aimue cuati castigo su tuaji eputi mahue puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","‘Be quebata ja biame ema peje su eichacua jei eputani cristiano cuana mue ai puji saida nime mebaji. Butsepi yama micuana equisainia, Diusu ja mesa ángel cuana ebeitutani tuna saida ebata puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Beju ema pueana Diusu peje jenetia jeitid'ujiji cuana d'eji su ya puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","‘Mepibaenique. Ahua quebata sa cien huisha ani cua su, ahua piada mesa jeitid'u cua su, ¿aimue jia maida tuahueda mesa pia huisha cuana taraca su terijiji eichajusiata mahue tueda piada jeitid'ujiji huisha echacuti puji? ");
INSERT INTO tnaNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ahua etejetita su, ene putsu beidaji epu. Terijiji enetita cuana jenetia ebia su beidaji epu, piada tejeyu putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Daja nime da Tata Diusu sa tsada mahue piada biame mesa jadhareti eichacua cristiano pataitana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","‘Ahua mique edue ja mi ai jucha yata su, butseatique tu jucha yatani jepuiti. Ahua tusa jucha eshanapata su, da su neicha miada mique edue saida yameinia. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ahua tuahueda shanapaja mahue yata su, da su beju piada ahua beta edue detse neje neicha putique tu peje su tuatse butse su di tusa jucha jepuiti equisaba puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ahua tuatse butse su di shanapaja mahue yata su, beju mequisatique pamapa edue cuana neicha tusa jucha jepuiti paquisabata huecuana puji. Ahua tuahueda pamapa edue cuana butse su shanapaja mahue su, da su tueda Diusu peje su jei puja mahue deja nime hue mebaque. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","‘Ene putsu, yama micuana equisainia, pamapa micuana sa tupupai piba su aja yainia, aja mahue yainia cuana Diusu ja etsabatayu. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","‘Ahua micuana duju jenetia beta tupupai epibatiani Diusu ebaja puji, beju Tata Diusu ja metse sa jabajati etiatayu. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Quepia beta ahua quimisha quema dharejiji cuana edhitatitani su, dapia ema yani tuna duju su. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Da su beju Jesús quisa pupeja su, Pedro ja tueda uja quisabatana: —Echua Puji, ¿quejucua nuati quema edue perdona taji? ¿Ahua siete nuati teje? ");
INSERT INTO tnaNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Da su Jesús ja Pedro jeutsutana: —Aimue siete nuati bahui mahue. Daja hue mique pamapa hora su perdona taji. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","‘Beju Diusu ecuatsasiati da uja: Piada echua puji huaraji aida anina. Da su mesa emebajaji cuana sa manu cuana tu peje su dusetana ebaseta puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mesa equene emebajaji deja tu peje su dusetana. Tuseda manu dueji echua puji peje su puina. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Beju aimue mesa chipilu anina mahue manu echujetia puji. Da su echua puji ja mesa emebajaji cuana cuatsasiatana tueda deja, tusa ehuane, ebacua cuana neje pamapa tusa ai cuana di pairuta huecuana puji, tusa manu echujetia puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Da su tueda deja echua puji butse su tururuana. Jubida bajatana uja: “Echua puji, paciencia tsuhu puque ema neje. Pamapa quema manu mi neje yani yama echujetia.” ");
INSERT INTO tnaNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Da su echua puji ja ibunebatana deja. Mesa manu perdona putsu, d'eji su atana deja. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Beju deja ete jenetia cuinana putsu, piada mesa ebuqueji tsutana. Tueda ebuqueji sa tu peje su manu chidiji puina. Da su tipeida deja ja ebuqueji inatana enaja su. Najapuduja adhaa putsu, uja atana ebuqueji: “¡Chujetiaque ema mique manu!” ");
INSERT INTO tnaNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Da su ebuqueji deja butse su tururuana. Jubida bajatana: “Paciencia puque ema neje. Pamapa quema manu cuana mida yama echujetia.” ");
INSERT INTO tnaNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Beju deja ja tsada mahue batana. Teriichanubiametana ebuqueji dapia paani puji tusa manu echujetiapeti teje. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Da su pia ebuqueji cuana ja ba putsu, ebia su duininitana huecuana. Echua puji peje su putitana huecuana pamapa cuaja putana cuana tu butsepi equisa puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Da su beju echua puji ja ihuametana deja. Deja echua puji peje su cuinati putsu, uja echua puji ja tueda atana: “Mida da deja ebia su ate. Cuaja yama mique manu perdonaitia nime, daja mique ebuqueji sa manu miqueda perdona taji aitia. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Cuaja yama mida ibunebaitia nime, daja mique ebuqueji miqueda ibuneba taji aitia.” ");
INSERT INTO tnaNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Da su echua puji ebia su duinini putsu, cuatsasiatana deja pacastigata huecuana puji, pateriichanubiata huecuana puji deja ja pamapa mesa manu echujetiata teje. ");
INSERT INTO tnaNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Daja Jesús ja perdona jepuiti quisa cuana quisapetana huecuana. Daja hue quisainiame atana huecuana uja: —Cuaja echua puji ja deja castigatana nime, daja da quema Tata Diusu ja micuana yatayu, ahua micuaneda micuana sa edue cuana perdonaja mahue yainia su. ");
INSERT INTO tnaNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesús ja tueda ai cuana quisape putsu, Galilea yahua jenetia cuinanana Judea yahua su eputi puji. Tueda yahua da Jordán ena id'eti ecuinanani bene su anina. ");
INSERT INTO tnaNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Beju dueji cristiano cuana ja tije atana. Dapia Jesús ja pamapa nedaji cuana saisiametana. ");
INSERT INTO tnaNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Da su beju piada piada fariseo cuana ja Jesús nariatana mimi neje tu yaba puji. Uja Jesús quisabatana huecuana: —¿Ai jepuiti da, etse sa ehuane neje jamesiati cua? ¿Cuaja jacuatsasiati cuana epuani? ");
INSERT INTO tnaNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Da su Jesús ja jeutsutana huecuana uja: —¿Aimue jia maida micuaneda mimiameana mahue Diusu sa quirica? Tueda quirica su Moisés chenu ja uja deretaidha: “Equene su Diusu ja deja, epuna ataidha.” ");
INSERT INTO tnaNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Neicha Moisés chenu ja deretaidha uja: “Da putsu, deja ja mesa tata, cuara detse ichajusia taji mesa ehuane neje yaniti puji. Beju tuatseda mu piada hue pu cua nime epu.” ");
INSERT INTO tnaNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Beju daja Diusu sa quirica su epuani. Aimue Diusu ja tuatseda beta nime ebatani mahue. Piada nime hue ebatani tse. Da putsu beju, aimue detse aidhe sa biame jamesiati taji pu cua mahue, Diusu ja tuatseda dunemetana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Daja da Jesús ja fariseo cuana jeutsutana. Da su Jesús neicha quisabatana huecuana uja: —Ahua enei hue mida epuani su, ¿jucuaja su ni da, da su Moisés chenu ja cuatsasiataidha deja ja quirica derejiji neje ehuane mesiata cua? ");
INSERT INTO tnaNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Da su Jesús ja jeutsutana huecuana: —Micuana sa tata chenu cuana sa ebia su tsada puidha putsu, Moisés chenu ja daja cuatsasiataidha. Beju epupiruji su, aimue Diusu ja tsada mahue bataidha. ");
INSERT INTO tnaNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Moisés chenu ja daja cuatsasiataidha biame, yama mu micuana uja equisainia: Ahua quebata yahue ja mesa ehuane jucha mue biame emesiata su, ahua tueda deja pia epuna neje ehuaneti su, tuahueda jucha aida yatani. Daja huecha quebata deja meseajiji epuna neje ehuaneti su, tuahueda di jucha aida yatani. ");
INSERT INTO tnaNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jesús da daja mimipe putsu, discípulo cuana ja tueda quisatana uja: —Ahua daja su mu, cuaja jahuanetija pu taji mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","12","Da su Jesús ja atana huecuana: —Ehe, butsepi micuaneda emimiani biame, beju aimue detse pamapa su jabutsenetiji mahue anita cua mahue. Piada piada cuana aimue ebutsenetitani mahue, daja hue bataji eputani jenetia huecuana putsu. Pia cuana aimue ebutsenetitani mahue, deja cuana ja micuana sa equita etsapiatani putsu. Daja huecha pia cuana aimue ebutsenetitani mahue Diusu bahui tuna mehua emebaja puji. Beju Diusu ja jabutsenetija mahue cuana etsahuatani daja hue paaniti puji. Da su quebata daja anija su, daja paani. ");
INSERT INTO tnaNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Da su beju piada piada yanana chidi cuana Jesús peje su dusetana huecuana Jesús ja mesa eme tuna bia su huana putsu, tuneseda puji Diusu ebajata puji. Beju discípulo cuana sa tsada mahue puana. Yanana chidi duseji cristiano cuana d'ayapirutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Da su Jesús ja discípulo cuana uja atana: —Yanana chidi cuana d'eji metiaque ema peje su papueta, Diusu ecuatsasiati da tuna nime cuana su putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jesús daja epuani je, mesa eme yanana chidi cuana bia su huanatana. Daja ape putsu, da jenetia beju putiana. ");
INSERT INTO tnaNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Piada deja Jesús peje su putiana. Uja quisabatana: —Echua Puji, mida da saida. ¿Ai ni quema a taji Diusu neje cielo su eid'e yanieniti puji? ");
INSERT INTO tnaNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Da su Jesús ja tueda jeutsutana: —¿Jucuaja su miada ema saida yainia? Diusu bahui da saida. Ahua mida cielo su eid'e anienija su, Moisés chenu sa jacuatsasiati cuana apeque. ");
INSERT INTO tnaNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Da su deja ja neicha Jesús quisabatana: —¿Quebata jacuatsasiati cuana quema a taji? Jesús ja deja jeutsutana: —Be cristiano manuameji. Be pia sa ebutse quinaji. Be tsi puji. Be bid'umimi puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mique tata, cuara detse iyubaque. Mida quitaita ibuneda ebatiani nime, daja pia cuana ibuneda baque. ");
INSERT INTO tnaNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Da su deja ja Jesús atana: —Beju pamapa tueda jacuatsasiati cuana yama butsepi yainia ema yanana jenetia jiahue teje. ¿Ai pia ni da quema a taji yani? ");
INSERT INTO tnaNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Beju Jesús ja tueda uja atana: —Ahua mida nimebutsepi puja su, irutique pamapa mique ai cuana. Pamapa mique chipilu cuana puri cristiano cuana tiaque. Tiape putsu, tije ema aque. Ahua daja ya su, cielo su pamapa ai eichacua cuana mique yani. ");
INSERT INTO tnaNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Beju deja ja daja id'aba putsu, ebia su jatacuamadhapirutiana, tueda ebia su chipiluji putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Da su deja putibana su, Jesús ja mesa discípulo cuana uja atana: —Ene putsu, yama micuana equisainia, atadhada chipiluji cuana Diusu ecuatsasiati su enubi puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ebia su atasaida caballo acusha id'aja je ejaitiana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Da su discípulo cuana da Jesús daja epuani id'aba putsu, ebia su nimetiunetitana huecuana. Uja jaquisabatitana huecuana: —¿Aidhe jia da d'eji su pu cua? ");
INSERT INTO tnaNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Beju Jesús ja tuna chama putsu, uja atana huecuana: —Cristiano cuana aimue tuna mehua quitaita hue d'eji su jaatita cua mahue. Diusu sa puji mu mue ai biame atadhada mahue. Beju Diusu ja aidhe papu biame d'eji su ata cua. ");
INSERT INTO tnaNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Da su Pedro ja Jesús uja atana: —Echua Puji, ecuanaju beju pamapa ecuanaju sa ai cuana ichajusiana mi tije ya puji. Da su, ¿ai da miada ecuanaju etia? ");
INSERT INTO tnaNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús ja Pedro jeutsutana: —Ene putsu, yama micuana equisainia, ema cielo jenetia esiapati hora ecuina su, ema ecuatsasiapiruti su, pamapa ai cuana eichacua yayu. Beju micuaneda ema tije ana putsu, ema esiapati hora su yama micuana huaraji aida cama yameyu. Pamapa israelita cuana ema neje micuaneda ecuatsasiatiyu. ");
INSERT INTO tnaNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Da hora su beju pamapa ema tije atana cuana yama echuje etiayu. Pamapa ete, edue, tata, cuara, ebacua, yahua cuana, ema emebaja puji ichajuseatana cuana yama ebia su dueji eturuca etiayu. Beju eid'e yanienitita huecuana Diusu neje cielo su. ");
INSERT INTO tnaNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Upia ye mundo su ai eni mahue eputani cuana da Diusu ja equene aida yametayu tu ecuatsasiati su. Daja huecha equene, aida eputani cuana da ai eni mahue tije eputayu Diusu ecuatsasiati su. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","‘Diusu ecuatsasiati da uja: Beju piada yahua emetse aida anina. Tueda da apudaya eni eni cuinanana huiruhuiruji cuana echacuti puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Teje putsu, mudu tsine quejucua echujetia jabutsepiatitana huecuana. Beju emetse ja te su beitutana huecuana ehuiruhuiru puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Da su beju neicha apudaya las nueve tupu su beju cuinanana. Pia deja mudu mahue cuana ejude su tejetana. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Da su emetse ja atana huecuana: “Meputique micuaneda di quema te su ehuiruhuiru puji. Yama micuana echujetia pia equene mudu puji cuana neje tupupai.” Da su putitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Neicha emetse cuinanana beju buepatia su. Pia deja mudu mahue cuana tejetana. Tuneda daja huecha atana emetse ja. Beju buepatia badeute uqueda su las tres tupu su neicha cuinanana. Pia deja mudu mahue cuana teje putsu, daja huecha atana. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Neicha beju cuinanana emetse tsinecua enariatiani su las cinco tupu su. Ejude su pia deja mudu mahue tejetana. “¿Jucuaja su micuaneda upia mudu mahue eneti?” atana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Da su tuneda jeutsutana: “Beju aimue aiya biame ecuanaju tia.” Da su emetse ja uja atana huecuana: “Meputique micuaneda di quema te su ehuiruhuiru puji. Micuaneda tsinecua enariatiani su, emudumudupiru biame, yama micuana pia equene mudu puji cuana echujetia nime tupupai echujetia.” ");
INSERT INTO tnaNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Beju dhidha cuinana su, emetse ja pamapa mudu puji cuana ihuametana. Uja emetse ja mudu puji cuana sa edusuji atana: “Chujetiaque mudu puji cuana. Equene chujetiapiruque tije nubitaitia mudu puji cuana. Da su pia equene nubitaitia mudu puji cuana chujetiaque.” ");
INSERT INTO tnaNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Da su tije tsinecua nubitaitia mudu puji cuana emetse butse su netisenatana. Beju pamapa su piada mudu tsine echuje quitana inatsutana, tsinecua nubitaitia biame. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Da su beju equene apudaya nubitana mudu puji cuana macha netisenatana emetse butse su. Tuneda japibatitana ebia su dueji echuje einatsu pepe putana. Daja pibatana biame, piada mudu tsine echuje bahui inatsutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Beju duininitana huecuana emetse neje. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Da su uja emetse atana huecuana: “Ye mudu puji cuana tsinecua nubitaitia biame, miada ecuanaju neje tupupai chujetiaitia huecuana. Beju piada hora chidi hue mudumudutaitia huecuana. Ecuanaju mu tsine tupu id'eti sinada duje jubida mudumuduitia. Da su, ¿jucuaja su miada ecuanaju chujetiaitia tupu huecha hue chujetiaitia huecuana?” ");
INSERT INTO tnaNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Beju emetse ja uja jeutsutana huecuana: “Eshanapa cuana, aimue micuana yama madhada hue echujetiainia mahue. Daja micuana sa jamitsuti ema neje puitia dajucua micuana yama piada mudu tsine echujetia puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Da su meinatsuque micuana sa echuje. Beju meputiyuque. Quema tsada yama tsinecua nubitaitia mudu puji cuana micuana sa echuje tupu huecha echujetia. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ai papu biame yama a cua, quema chipilu putsu. ¿Jucuaja su micuaneda enimepuani, yama saida neje mudu puji cuana echujetiainia, ba putsu?” ");
INSERT INTO tnaNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Daja da Jesús ja bahue quisa neje buetsuapetana huecuana. Neicha quisatana huecuana uja: —Diusu ecuatsasiati da beju uja: Upia ye mundo su ai eni mahue nime ebatani cuana da Diusu ecuatsasiati su equene, aida eputa. Daja huecha ye mundo su equene, aida eputani cuana da ai eni mahue tije eputayu Diusu ecuatsasiati su. Dueji ihuajiji cuana eputani biame, beju ucua chidi hue dharejiji cuana eputani. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús da mesa discípulo cuana neje Jerusalén ejude su epuhu je, chujemame dusutana huecuana. Uja atana huecuana: ");
INSERT INTO tnaNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Beju Jerusalén ejude su ecuaneda epuhu. Tueda ejude su ema emenajatiata sacerdote huaraji aida, jacuatsasiati ebuetsuaji cuana peje su. Beju ema romano soldado cuana peje su emenajatiata huecuana ema pamanuameta huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ema neje eshishatita, eicheta huecuana. Curusu su ema etatata huecuana. Beju quimisha tsine jaitianaja su, ema eid'eyu. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Da su beju Jacobo, Juan detse sa cuara ja Jesús nariatana tuatse neje. Zebedeo da metse sa tata puina. Tuatse sa cuara da Jesús butse su tururuana tu ebaja puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Da su Jesús ja epuna quisabatana: —¿Ai mique tsada? Beju epuna ja Jesús atana uja: —Mi ecuatsasiati su quema ebacua detse mi neje pacuatsasiati. Piada mique bai eni bene, pia mique d'ani bai bene paaniute. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Da su Jesús ja epuna jeutsutana uja: —Ene putsu, micuaneda ebia su ebajainia, aimue butsepi epibatiani mahue putsu. Quebata da ema ecuatsasiati su huaraji aida puja epu su, tuseda equene ebia su sufri pu taji. ¿A da, da su metseda sufri pu cua ema sufri epu nime? Da su Jacobo, Juan detse ja Jesús uja jeutsutana: —Ehe, sufri etseju pu cua, mi epu nime. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Da su Jesús ja uja atanatse: —Ene putsu, ema jepuiti metseda sufri epu biame, aimue quema puji dhare taji mahue aidhe biame ema naja su yaniute puji. Quema Tata ja bahui edhareta. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Beju pia piada tunca discípulo cuana ja id'aba putsu, tuatse neje duininitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Da su Jesús ja pamapa su ihuatana tu naja su. Uja atana huecuana: —Micuaneda bahue pamapa ejude sa huaraji aida cuana ja ebia su tucheda neje cristiano cuana ecuatsasiatani. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Beju micuaneda mu aimue daja epu mahue. Quebata micuaneda huaraji aida puja epu su, tuseda pia cuana mebaja taji. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Quebata micuaneda ehuidusuji puja epu su, pia cuana sa emebajaji pu taji. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ema da Diusu sa Jabeituti Deja biame, ema pueana ye mundo su aniji cristiano cuana emebaja puji. Aimue ema pue cristiano cuana ja ema pamebajata puji. Beju ema pueana emanu puji, dueji cristiano cuana d'eji su paputa puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Beju Jericó ejude jenetia cuinanatana huecuana su, dueji cristiano cuana ja tije atana Jesús. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Edid'i su beju beta deja padha detse anina. Tuatseda Jesús ejaitianasa bahue puana putsu, jubida tsiatsiapiruana tse uja: —¡Echua Puji, David chenu sa familia jenetia, ibunebaque etseju! ");
INSERT INTO tnaNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Beju Jesús sa ebuqueji cuana ja: —¡Mitanaque! —atana deja padha detse. “Mitanaque”, atana huecuana biame, cha ebia su hue daja hue tsiatsiana tse. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Da su beju Jesús netianana. Ihuatana padha detse. Uja quisabatana tse: —¿Ai ni metse sa yama cuaja ya tsada? ");
INSERT INTO tnaNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Uja jeutsutana tse: —Echua Puji, tuaji etseju aque. ");
INSERT INTO tnaNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Da su Jesús ja tuatseda ibunebatana. Tuatse sa etua d'apabatana putsu, da hora su hue padha detse jabatiana. Da su beju Jesús tije apirutana tse. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Beju Betfagé ejude chidi su nariatana huecuana. Tueda ejude da Jerusalén ejude, Olivo murucu aida naja su anina. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ejude butse su cuinati putsu, Jesús ja mesa beta discípulo detse cuatsasiatana uja: —Meputique tueda ejude chidi su. Dapia da metse eba piada asunu jananaji risijiji eneti. Pidhu putsu, meduseque. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ahua aiya metse: “¿Jucuaja puji metse daja yainia?” yata su, uja mequisaque tueda: “Echua Puji ja etsatani. Beju tipeida ebeitutayu.” ");
INSERT INTO tnaNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Beju daja Jesús ja cuatsasiatana tse, cuaja Diusu sa profeta chenu ja deretaidha batame. Uja Diusu ja deremetaidha mesa quirica su: ");
INSERT INTO tnaNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Quisaque Jerusalén ejude su aniji cuana uja: “Mechamaque, micuana sa Echua Puji nimemitsida epusiu. Tueda micuana peje su epusiu asunu janana bia je.” ");
INSERT INTO tnaNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Da su discípulo detse da putiana. Cuaja Jesús ja cuatsasiatana batame, daja atana tse. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Asunu janana, mesa cuara neje dusetana tse. Da su discípulo cuana ja mecuana sa ebia jud'uji asunu janana bia su ichatana. Beju Jesús ja asunu janana bianitana. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Dueji cristiano cuana ja di mecuana sa ebia jud'uji cuana jajemititana. Beju huanatana huecuana Jesús epuhu edid'i su. Pia cuana ja aqui echa cuana dheutana. Jesús epuhu edid'i su ichatana huecuana. Daja cristiano cuana ja a bahue ataina, huaraji aida cuana epuetani su. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Dueji cristiano cuana Jesús neje Jerusalén ejude su putitana. Pia cuana Jesús ehui su, pia cuana tije. Pamapa mimi neje tsiatsiapirutana uja: —¡Saida memimija ye David chenu sa familia jenetia deja sa puji! ¡Tueda epusiu Diusu sa ebani su! ¡Diusu ja tueda paibunebata! ¡Gloria Tata Diusu! Daja tsiatsiatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Da su Jesús Jerusalén ejude su nubiana su, pamapa cristiano cuana tipeijianatana. Uja tuneda cama jaquisabatitana: —¿Aidhe ni da ye deja? ");
INSERT INTO tnaNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Pia cuana ja jajeutsutitana uja: —Tueda da Diusu sa profeta Jesús banime, Nazaret ejude, Galilea provincia jenetia. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Da su beju Jesús templo su nubiana. Dapia iruiruji, bajabajaji cuana etseque su cuadejusiacuinatana. Chipilu turucaji sa misha cuana busiapapetana. Huaitucu iruji cuana sa aniude cuana di busiapapetana. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Uja Jesús ja atana huecuana: —Diusu sa quirica su uja derejiji yani: “Quema ete da pamapa cristiano cuana sa ema mitsu jude ete epu.” Micuaneda mu tsi puji sa ete ana. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Beju dapia templo su piada piada padha, tida deja cuana ja Jesús nariatana. Jesús ja saisiametana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Dapia yanana chidi cuana ba putsu uja tsiatsiatana huecuana: “¡Gloria ye David chenu sa familia jenetia deja!” Daja tsiatsiatana huecuana, Jesús ja nimetiuda aida cuana yatani ba putsu. Beju sacerdote huaraji aida, jacuatsasiati ebuetsuaji cuana ja yanana chidi cuana neje ebia su duininitana, yanana chidi cuana Jesús sa puji daja saida mimitana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Da su uja Jesús atana huecuana: —¿Aimue jia maida miada yanana chidi cuana daja etsiatsiatani eid'abainia mahue? ¿Ai puji miada d'eji etiainia daja patsiatsiata huecuana puji? Da su Jesús ja jeutsutana huecuana uja: —Ehe, eid'abainia yama. Aimue micuaneda epibainia mahue Diusu sa quirica su daja ema jepuiti derejiji yani. Uja da epuani: Yanana chidi cuana ja mi jepuiti saida emimita. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Da su beju Jesús mimipe putsu, ichajusiatana huecuana. Betania ejude chidi su putiana dapia etahui puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Beju apudaya eni eni Jesús cuinanana Jerusalén ejude su eputi puji. Edid'i su epuhu je, beju dhemanuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Higuera equi edid'i naja su batana. Da su janariatiana equi sa ejaja edia puji. Enariahu cama, jaja mahue batana. Eina cama bahui beju puina. Da su Jesús ja higo equi uja atana: —Aimue mi beju quetsunu su biame jajaji epuicha mahue. Da hora su beju equi saranetiana. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Da su discípulo cuana ja equi sarajiji eneti ba putsu, nimetiunetitana huecuana. Jesús quisabatana huecuana: —¿Jucuaja ni da ye equi tipeida saranetitia? ");
INSERT INTO tnaNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús ja jeutsutana huecuana: —Ene putsu, yama micuana equisainia, ahua micuaneda Diusu peje su enimetucheatiani su, daja detse yama equi aitia nime, micuaneda a cua. Daja ebia su detse micuaneda a cua. Ahua micuaneda Diusu peje su enimetucheatiani su, ye emata uja cuatsasia cua: “U jenetia mar su puderaque.” Beju da su emata epudera. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Pamapa micuaneda Diusu ebajainia cuana tuahueda etiatayu, ahua tu peje su enimetucheati su. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Da su beju Jesús templo su nubiana. Dapia cristiano cuana buetsuapirutana. Jesús dapia eneti cama, sacerdote huaraji aida, judío cuana sa tata edhi ehuidusuji cuana ja naria putsu, uja quisabatana huecuana: —¿Aiya mida huaratiatana ye ai cuana ya puji? ");
INSERT INTO tnaNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Da su Jesús ja jeutsutana huecuana uja: —Equene yama micuana equisaba. Ahua micuaneda ema ejeutsu su, beju yama di micuana ejeutsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Aiya Juan Bautista huaratiatana cristiano cuana Diusu sa puji yahui neje eichadera puji? ¿Diusu ja, ahua cristiano ja? Da su tuneda cama uja jaquisatitana: —Ahua ecuaneda, “Diusu ja Juan huaratiatana”, ejeutsu su, tuahueda, “Da su, ¿jucuaja su micuaneda aimue Juan peje su jei puana mahue?” ecuana equisabata. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ahua ecuaneda, “Cristiano ja Juan huaratiatana”, ejeutsu su, da su pamapa cristiano cuana ecuana neje eduininita, Juan da Diusu sa profeta ebatani huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Da su Jesús uja jeutsutana huecuana: —Aiya jia Juan huaratiatana bue mahue ecuanaju. Jesús ja atana huecuana: —Da su yama di, aiya ema huaratiatana aimue micuana equisa mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús ja daja hue quisainiame atana huecuana uja: —Meid'abaque ye quema quisa cuana. Piada deja sa beta ebacua anina. Tuahueda piada ebacua uja atana: “Ebacua, putique te su emudumudu puji.” ");
INSERT INTO tnaNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Da su ebacua ja, “Tsada mahue quema”, jeutsutana mesa tata. Daja jeutsutana biame, japibaturucati putsu, beju putiana te su emudumudu puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Da su beju pia ebacua daja huecha quisatana te su pamudumuduti puji. Pia ebacua ja, “Ehe, tata, eputi da ema”, jeutsutana biame, mue puti puana. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Da su, ¿quebata ebacua detse ja mesa tata sa tsada atana? Beju jeutsutana huecuana: —Equene ebacua ja mesa tata sa tsada atana. Jesús ja atana huecuana uja: —Ene putsu, yama micuana equisainia, juchaji impuesto echujebajaji, epuna chuamadhada cuana japibaturucati putsu, Diusu ecuatsasiati su beju enubitayu. Micuaneda mu aimue enubiyu mahue, japibaturucatija mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan Bautista ja micuana cuaja anime butsepi pu taji ebuetsua puji pueana. Beju micuaneda da sacerdote, judío cuana sa ehuidusuji cuana epuani biame, aimue Juan sa jabuetsuati cuana jei ana mahue. Juchaji impuesto echujebajaji, epuna chuamadhada cuana mu jei putana. Beju micuaneda tuneda daja japibaturucatitana ba putsu, aimue Diusu peje su tuna nime japibaturucatija puana mahue. Aimue Juan sa jabuetsuati cuana jei ana mahue. Da su micuaneda da tije puji ebacua nime hue, jei puja mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesús daja hue quisainiame atana huecuana uja: —Meid'abaque ye pia bahue quisa. Piada emetse ja uva jude banametana. Baname putsu, taracametana. Uva pudu jude ametana. Ete pacha baqui bauda di ametana uva jude einatsihua puji. Da su beju tueda emetse ja uva jude pia mudu puji deja cuana menajatiatana pamuduta huecuana puji. Menajatia putsu, emetse putiana pia yahua su. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Beju huiruhuiru tiempo cuinana su, emetse ja mesa emebajaji cuana beitutana mudu puji deja cuana peje su emetse sa tupu pachujebajata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Beju tueda mudu puji deja cuana ja emetse sa emebajaji cuana madhada neje batsutana. Piada ichetana huecuana. Pia manuametana huecuana. Pia maracatana huecuana tumu neje. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Da su emetse ja neicha beitutana emebajaji cuana. Beju daja huecha mudu puji deja cuana ja madhada neje batsutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","‘Da su beju emetse ja mesa ebacua macha beitutana mudu puji deja cuana peje su. Uja emetse japibatiana: “Tueda da quema ebacua quitaita putsu, eiyubata huecuana.” ");
INSERT INTO tnaNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Beju mudu puji deja cuana ja emetse sa ebacua ba putsu, tuneda cama jaquisatitana uja: “Ye ebacua da uva jude emetse epu, mesa tata emanu su. Da su tueda pamanuametija yahua emetse ecuaneda epu puji.” ");
INSERT INTO tnaNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Da su ebacua ina putsu, uva jude jenetia jemicuinatana huecuana. Dapia etseque su emetse sa ebacua manuametana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jesús ja quisape putsu, uja quisabatana huecuana: —Uva jude emetse ecuinayu su, ¿cuaja ni da tuahueda yata tueda mudu puji deja madhada cuana? ");
INSERT INTO tnaNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Da su uja jeutsutana huecuana: —Emetse ja mudu puji deja madhada cuana pamapa emanuamepeta. Uva jude pia mudu puji deja saida cuana emenajatiata, pia huiruhuiru tiempo su mesa tupu patiata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Da su Jesús ja atana huecuana: —¿Aimue jia maida micuaneda Diusu sa quirica mimiameana mahue? Uja derejiji yani: Ete muduji cuana ja yapiruji tumu jusiaderatana biame, tueda tumu macha beju Diusu ja dharetana. Tueda pia tumu cuana ebia su saida ametana. Tueda da nimetiuda ecuaneda ebainia. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Beju micuaneda da ate tueda mudu puji deja madhada cuana nime. Diusu ja micuana aimue enubiameta mahue tu ecuatsasiati su. Pia tu jei yatani cuana mu enubiametayu, Diusu sa tupu tiatana huecuana putsu, mudu puji deja saida cuana ja atana nime. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Quebata da Diusu sa jadhareti tumu bia su edajaja su, beju tueda eped'uped'uati. Ahua tumu etse bia su edajaja su, etse emedimediata. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Da su sacerdote huaraji aida, fariseo cuana ja Jesús sa mimi cuana id'abatana putsu, beju jashanapatitana huecuana Jesús tuna jepuiti mimiana. ");
INSERT INTO tnaNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Da putsu, Jesús inaja adhaatana huecuana tu emanuame puji. Beju cristiano cuana iyubatana huecuana putsu, cuaja ina taji mahue batana huecuana, cristiano cuana ja Jesús da Diusu sa profeta batana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Neicha Jesús ja cristiano cuana buetsuapirutana bahue quisa cuana neje. Uja atana huecuana: ");
INSERT INTO tnaNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Uja da Diusu ecuatsasiati: Piada echua puji ja jahuaneti tsine atana mesa ebacua sa puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Emebajaji cuana beitutana ihuajiji cuana paihuatita huecuana puji. Beju ihuajiji cuana aimue putija putana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Da su neicha echua puji ja pia emebajaji cuana beitutana. Uja cuatsasiatana huecuana: “Mequisatique ihuajiji cuana papueta huecuana beju, pamapa quema jana cuana basetajiji putsu. Quema huaca, pia animalo tseida cuana beju manuameitia. Mequisatique papueta huecuana, pamapa basetajiji putsu.” Da su beju putitana emebajaji cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Daja quisatana huecuana biame, beju ihuajiji cuana ja jei aja mahue atana. Piada piada cuana mecuana sa te su putitana. Pia cuana eiruiru puji putitana. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Pia cuana ja emebajaji cuana ina putsu, nedaneda atana huecuana emanuame teje. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Da su beju echua puji ebia su duininiana tuna neje. Mesa soldado cuana beitutana ihuajiji deja manuameji madhada cuana pamanuametita huecuana puji, tuna sa ejude di pad'ed'ata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Daja a putsu, neicha echua puji ja mesa emebajaji cuana ihuatana. Uja cuatsasiatana huecuana: “Pamapa beju basetajiji. Be neicha ihuaji tueda equene ihuajiji madhada cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Meputique ejude duje. Pamapa micuaneda eteje cuana meihuaque quema jahuaneti tsine su papueta huecuana puji.” ");
INSERT INTO tnaNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Da su emebajaji cuana putitana ejude duje. Pamapa tejetana cuana dusetana huecuana jahuaneti tsine su. Jucuada saida, saida mahue cuana dusetana huecuana. Da putsu, echua puji sa ete sejeana cristiano cuana neje. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Da su echua puji nubiana ihuajiji cuana eba puji. Beju ihuajiji cuana duju su piada deja jahuaneti tsine su eputi puji jud'uderaji mahue puina batana. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Da su echua puji ja deja uja atana: “Eshanapa, ¿jucuaja su mida daja jud'ujime nubitia?” Beju aimue deja ja jeutsu atana. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Da su echua puji ja emebajaji cuana cuatsasiatana uja: “Mehuatsirisique. Eme detse di merisique. Beju mejusiacuinaque etseque, apuda su. Dapia da ebia su epa, etsedhaiti beju, ebia su sufri epu putsu.” ");
INSERT INTO tnaNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Dueji ihuajji cuana eputani biame, beju ucua chidi hue dharejiji cuana eputani. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Beju Jesús daja quisape putsu, fariseo cuana putitaibana. Japibapirutitana huecuana cuaja quisababapebape putsu, Jesús mimi madhada emimiame puji, tu etuaquisa puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Da su beju fariseo cuana ja piada piada mecuana sa, Herodes sa ebuqueji cuana beitutana Jesús peje su tu mimi madhada pamimiameta huecuana puji, quisababapebape putsu. Beju Jesús tuaquisaja adhaatana huecuana. Jesús peje su cuinati putsu, uja quisabatana huecuana: —Ebuetsuaji, bahue ecuanaju mida butsepi quisa epuani. Miada Diusu sa ene quita quisa cuana ebuetsuainia. Pamapa cristiano cuana miada tupupai ebainia. Aida puji, puri cuana beju miada tupupai ebainia. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Da putsu, quisaque ecuanaju, ¿ahua saida ecuaneda impuesto cuana romano echua puji aida echujetia puji ahua mahue? ");
INSERT INTO tnaNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Beju Jesús shanapatiana tuna madhada piba neje daja quisabatana. Ahua Jesús, “Saida echujetia puji”, epu su, da su judío cuana tu neje eduininita. Ahua, “Saida mahue echujetia puji”, epu su, da suromano soldado cuana ja einata. Da putsu, Jesús ja uja jeutsutana huecuana: —Beju micuaneda da bubeta cuana. ¿Jucuaja su micuaneda ema mimi neje pitsameja yainia? ");
INSERT INTO tnaNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Piada chipilu metiaque ema. Da su beju piada chipilu tiatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Chipilu ina putsu, Jesús ja quisabatana huecuana uja: —¿Aidhe sa ebu eimea, ebani da ye chipilu bia su derejiji yani? ");
INSERT INTO tnaNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Da su jeutsutana huecuana: —Tueda ebu eimea, ebani da romano echua puji aida sa beju. Da su Jesús ja atana huecuana uja: —Da su beju metiaque echua puji aida sa epuani ai cuana. Diusu di metiaque tuseda epuani ai cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jésus sa jajeutsuti id'aba putsu, nimetiunetitana huecuana. Beju putitaibana huecuana, basea putsu, cuaja Jesús pitsame taji mahue batana huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tueda tsine su huecha hue piada piada saduceo cuana Jesús peje su putitana. Tueda saduceo cuana da, manujiji cuana neicha eid'etayu aimue jei putana mahue. Da su uja Jesús atana huecuana: ");
INSERT INTO tnaNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Ebuetsuaji, Moisés chenu ja buetsuataidha uja: “Ahua quebata deja bacua mahue emanu su, manujiji sa edue ahue manujiji neje jahuaneti taji, ebacua cuana edue manujiji sa bataji epu puji.” ");
INSERT INTO tnaNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Beju siete edue cuana anitaina. Edue equene puji jahuanetiana. Beju bacua mahue manuana. Da su tu tije puji edue da manujiji sa ahue manujiji neje jahuanetiana. Tueda macha beju manuana bacua mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tu tije puji edue macha daja huecha puana. Beju pamapa tije puji edue cuana daja cama putana ahue manujiji neje. Beju manutana huecuana pamapa. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Da su beju epuna macha manuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Da su ahua ene mi epuani nime enetianatayu huecuana su, ¿quebata edue sa jia da tueda epuna ehuane epu? epuna? ");
INSERT INTO tnaNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Da su Jesús ja uja jeutsutana huecuana: —Beju ebia su epitsatiani micuaneda ye ai cuana jepuiti, Diusu sa mimi derejiji yani mue shanapa putsu, Diusu ja pamapa ai atadhada cuana ata cua, jei epuani mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Diusu ja manujiji cuana enetianametayu su, aimue neicha ebutsenetita huecuana mahue, cielo su Diusu sa ángel cuana nime eputa huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Beju yama micuana butsepi equisainia manujiji cuana jepuiti. Ene putsu, neicha eid'etayu huecuana, micuaneda jei epuani mahue biame. ¿Aimue jia maida micuaneda Diusu sa quirica su mimiameana mahue? ");
INSERT INTO tnaNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Uja Diusu ja Moisés chenu ataidha mesa quirica su derejiji yani: “Ema da Abraham, Isaac, Jacob cuana sa Diusu.” Beju manutaidha huecuana biame, Diusu neje eid'e yanita huecuana, Diusu da eid'e cuana sa bahui Diusu putsu. Da putsu, micuaneda epitsatiani. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Beju cristiano cuana ja Jesús sa jajeutsuti id'aba putsu, nimetiunetitana huecuana, mesa jabuetsuati jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Beju fariseo cuana ja shanapatana Jesús ja saduceo cuana mitanametana. Da su beju jadhitatitana huecuana jacuatsasiati ebuetsuaji cuana neje. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Piada jacuatsasiati ebuetsuaji ja quisaba putsu, Jesús abaja atana. Uja Jesús quisabatana huecuana: ");
INSERT INTO tnaNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Ebuetsuaji, ¿quebata Diusu sa jacuatsasiati da pia cuana ebia su aida? ");
INSERT INTO tnaNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Da su Jesús ja jeutsutana uja: —Beju uja da Diusu sa jacuatsasiati ebia su aida: “Ibuneda baque Diusu pamapa mique muesumu neje.” ");
INSERT INTO tnaNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tueda da pamapa Diusu sa pia jacuatsasiati cuana ebia su aida. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Beju pia tije jacuatsasiati di daja huecha aida. Uja da epuani: “Cuaja mida quitaita ibuneda ebatiani nime, daja mique pia cuana ibuneda ba taji.” ");
INSERT INTO tnaNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tueda jacuatsasiati detse da pamapa Moisés chenu sa jacuatsasiati, profeta chenu cuana sa jabuetsuati cuana ebia su aida quita. Quebata ja ye beta jacuatsasiati detse yata su, tuahueda pamapa Moisés chenu sa jacuatsasiati, profeta chenu cuana sa jabuetsuati cuana yatani. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Fariseo cuana dhitajiji yani cama, Jesús ja quisabatana huecuana uja: —¿Cuaja micuaneda epibatiani Diusu sa Jabeituti Deja jepuiti? ¿Aidhe da tusa tata? Da su fariseo cuana ja Jesús jeutsutana: —Beju tueda da echua puji David chenu sa ebacua. ");
INSERT INTO tnaNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Da su Jesús ja quisabatana huecuana uja: —Ahua ene quita tueda da David chenu sa familia jenetia bataji puana su, ¿cuaja ni da, da su David chenu ja tueda, “Quema Echua Puji”, ataidha? Beju uja Espíritu Santo ja David chenu daja mimiametaidha: ");
INSERT INTO tnaNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Tata Diusu ja quema Echua Puji uja ataidha: “Aniuteque quema bai eni bene yama pamapa mique majai cuana pishitiame putsu, mique ema su eicha teje.” ");
INSERT INTO tnaNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ahua ene quita Diusu sa Jabeituti Deja da David chenu sa familia jenetia bataji puana su, ¿cuaja ni da da su David chenu ja quitaita tueda, “Quema Echua Puji”, ataidha? ");
INSERT INTO tnaNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Da su beju aimue quebata ja biame cuaja jeutsu taji mahue batana. Mitanatana huecuana. Da tsine jenetia aiya biame Jesús ai quisabayuja atana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Da su beju Jesús ja cristiano mesa discípulo cuana uja atana: ");
INSERT INTO tnaNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Moisés chenu sa jacuatsasiati ebuetsuaji, fariseo cuana tueda jacuatsasiati cuana tuneda bahui cristiano cuana buetsua bahue pepe hue eputani. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Da su Moisés chenu sa jacuatsasiati cuana micuana ebuetsuatani huecuana su, jei a taji. Jabuetsuati cuana jei yainia biame, aimue micuaneseda tuna yatani nime a taji mahue, bubeta huecuana putsu. “Ye paatija”, eputani huecuana biame, pia ai hue yatani huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Cuaja tuchea taji mahue cristiano cuana ebatani biame, jacuatsasiati jubida etiatani huecuana, tuneda quitaita tueda jacuatsasiati a bue mahue biame. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Pamapa yatani huecuana cristiano cuana ja aida pabata huecuana puji. Diusu sa mimi derejiji quirica ped'u cuana su ejud'uji nabai su, emata su dusu bahueta huecuana. Mecuana sa ejud'uji tihue cuana su pia cristiano cuana sa ebia su pahaida blonda cuana jaichati bahueta huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Tuneseda tsada aniude saida eni bahui tsine cuana su misha naja su yaniute puji. Jadhitati jude ete su di daja huecha aniude saida eni bahui tuneseda tsada. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Tuneseda tsada cristiano cuana ja, ejude duje tsu putsu, iyuda neje pamitsuta huecuana. Tsada saida tuneseda cristiano cuana ja, “Ebuetsuaji”, paata. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","‘Beju aimue micuaneda mu daja fariseo cuana nime ya mahue. Be tsada mebaji cristiano cuana ja micuana, “Ebuetsuaji”, yata puji, micuaneda da pamapa tupupai edue cama putsu. Beju micuaneseda piada Ebuetsuaji bahui yani. Tueda da Cristo. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Be aidhe biame, “Tata”, meaji ye mundo su, micuaneseda piada Tata bahui cielo su yani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Be tsada mebaji cristiano cuana ja micuana, “Echua puji”, tata puji, Cristo bahui micuana sa Echua Puji putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Quebata ja micuana duju su pia cuana emebajata su, tueda da pia cuana ebia su aida epu. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Quebata da tueda quita ebia su aida puja ebati su, Diusu ja tueda mue ai eni mahue nime yatayu. Quebata da ai emi mahue ebati su, tueda Diusu ja ebia su aida yatayu. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","‘¡Aba, jacuatsasiati ebuetsuaji, fariseo cuana, micuaneda da bubeta cuana putsu! Cristiano cuana micuaneda aimue Diusu ecuatsasiati su panubi yainia mahue, micuaneda quitaita aimue enubi mahue biame. Cristiano cuana nubija eputani biame, micuaneseda tsada mahue panubita huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","‘¡Aba, jacuatsasiati ebuetsuaji, fariseo cuana, micuaneda da bubeta cuana putsu! Micuaneda ahue manujiji cuana sa ete cuana mejemi bahue. Tsabauda risha cuana micuaneda a bahue tuna butse su micuana iyuda neje pabata huecuana puji. Da putsu, Diusu ja micuana pia cuana ebia su ematsetayu cuati castigo su. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","‘¡Aba, jacuatsasiati ebuetsuaji, fariseo cuana, micuaneda da bubeta cuana putsu! Micuaneda pamapa ejude je puti bahue cristiano cuana ebuetsua puji, micuana sa puiti cuana tije paata huecuana puji. Da su tuneda micuana ebia su quitaita madhada hue eputa. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","‘¡Aba, micuaneda, ehuidusuji padha cuana nime putsu! Uja micuaneda cristiano cuana ebuetsuainia: “Ahua quebata mu templo jepuiti Diusu bahue epu su, aimue tuseda mesa jamitsuti a taji mahue. Ahua quebata mu templo sa oro jepuiti Diusu bahue epu su, da su beju tuseda mesa jamitsuti a taji.” ");
INSERT INTO tnaNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Micuaneda da padha bue mahue cuana nime. ¿Ai oro templo ebia su iyuda bata? Templo ja beju oro iyuda yatani. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Daja huecha micuaneda uja ebuetsuainia cristiano cuana: “Ahua quebata altar jepuiti Diusu bahue epu su, aimue tuseda mesa jamitsuti a taji mahue. Ahua quebata mu altar bia su eirutsuaji jepuiti Diusu bahue epu su, da su beju tuseda mesa jamitsuti a taji.” ");
INSERT INTO tnaNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Beju micuaneda da padha, bue mahue cuana nime. ¿Ai eirutsuaji altar bia su iyuda bata? Altar ja beju eirutsuaji iyuda yatani. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ene putsu, yama micuana equisainia, ahua quebata altar jepuiti Diusu bahue epu su, tueda da altar bia su eirutsuaji jepuiti di Diusu bahue epuani pu cua nime. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Daja huecha quebata templo jepuiti Diusu bahue epu su, tueda da Diusu jepuiti di Diusu bahue epuani pu cua nime, Diusu templo dume su yani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Daja huecha quebata cielo jepuiti Diusu bahue epu su, tueda da Diusu ani jude jepuiti di Diusu bahue epuani pu cua nime, Diusu dapia yani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","‘¡Aba, jacuatsasiati ebuetsuaji, fariseo cuana, micuaneda bubeta putsu! Pamapa micuana sa enubiani ai cuana sa piada décimo chidi hue eichaderainia Diusu sa puji biame, butsepi puniuneti ai cuana esetainia. Ibuneda mahue micuaneda. Aimue micuaneda pia ebia su saida jabuetsuati cuana ebuetsuainia mahue. Aimue cristiano cuana Diusu butse su butsepi paputa puji ebuetsuainia mahue. Aimue ebuetsuainia huecuana mahue huamahuama paibunebatita huecuana puji. Aimue ebuetsuainia huecuana mahue Diusu peje su panimetucheatita huecuana puji. Tueda jabuetsuati saida cuana di micuaneseda buetsua taji yainia. Beju aimue micuaneda mu daja yainia mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Micuaneda da ehuidusuji padha cuana nime! Diusu sa jacuatsasiati ebia su saida cuaja a taji mahue ebainia. Beju ai eni mahue jacuatsasiati, ai puiti cuana mu micuaneda atasaida ebainia. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","‘¡Aba, jacuatsasiati ebuetsuaji, fariseo cuana! Micuaneda da emeji dume adhida nime, ebia je bahui saida, rucuajiji. Micuaneda di ebia je bahui saida nime. Muesumu su mu ai piapiati madhada micuana sa yani. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariseo padha nime, equene micuana sa muesumu jabasetati taji. Da su beju ebia je macha saida epu. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","‘¡Aba, jacuatsasiati ebuetsuaji, fariseo cuana! Beju micuaneda da sepulcro nime. Ebia je bahui saida, ania chidi pasane batame. Beju edume su mu manujiji cuana sa etsau neje sejeajiji. Pamapa ai adhida cuana neje sejeajiji. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Daja nime da micuaneda. Cristiano cuana butse su micuaneda saida nime ebametiani. Beju micuana sa muesumu su mu pamapa ai madhada cuana ape taji mahue yani. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","‘¡Aba, jacuatsasiati ebuetsuaji, fariseo cuana! Micuaneda Diusu sa profeta chenu cuana sa sepulcro cuana saida baseta bahue. Uja micuaneda pu bahue: “Ahua ecuanaju tata edhi chenu cuana sa tiempo su anidha su, beju aimue ecuanaju Diusu sa profeta chenu cuana manuame cua aidha mahue.” ");
INSERT INTO tnaNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Beju yama micuana butsepi equisainia, micuana sa tata edhi chenu cuana ja Diusu sa profeta chenu cuana manuametaidha. Micuaneda di tuna manuameji cuana nime. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Da su meapeque micuana sa tata edhi chenu cuana ja apirutaidha ai madhada cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","‘¡Micuaneda da bacua d'aida nime! Aimue Diusu sa jamatseti su d'eji su epu mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Da su yama micuana peje su ebeitu profeta, deja bahue eni ebuetsuaji cuana. Piada piada tuneda micuaneda, curusu su tata putsu, emanuame. Pia cuana micuaneda eiche jadhitati jude ete cuana su. Ejude meamea micuaneda tijetije ya huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Micuana peje su cama Diusu sa enime epu, profeta cuana manuametaidha huecuana jepuiti. Manuamejiji putaidha profeta cuana da Abel chenu jenetia Equene Abel chenu jenetia Berequías chenu sa ebacua Zacarías chenu teje micuaneda peje su cama Diusu sa enime epu. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ene putsu, yama micuana equisainia, jiahue tiempo cristiano cuana da juchaji eputa pamapa biahua tiempo manuametaidha cuana jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","‘¡Uja Jesús puana Jerusalén ejude su aniji cristiano cuana jepuiti: —Jerusalén ejude su aniji cristiano cuana, micuaneda Diusu sa profeta cuana manuame bahue! ¡Tumu neje maraca bahue micuana peje su Diusu ja ebeitutani cuana! ¡Quejucua nuati biame yame micuana dhitaja adhaana, huaripa ja yanana cuana edhitatani enabai ema su nime! ¡Beju micuaneseda tsada mahue puana! ");
INSERT INTO tnaNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","39","Da su ema meid'abaenique. Yama micuana eichajusia. Beju aimue micuana ema eba mahue, ema esiapati teje. Ema esiapati su, da su ema jepuiti micuaneda uja epu: “Diusu ja tueda paibunebata, Diusu sa ebani su epusiu putsu.” ");
INSERT INTO tnaNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Pia tsine Jesús templo jenetia cuinanana su, tu epuhu cama, discípulo cuana ja nariatana. Templo da ania, saida jepuiti quisapirutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Da su Jesús ja atana huecuana uja: —Mechamaque ye templo. Butsepi yama micuana equisainia, tumu aida cuana jenetia ajiji biame, edajajape. Aimue piada tumu biame pia tumu bia su yaniti mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Da su Jesús, discípulo cuana neje Olivo murucu su tsuatiana. Dapia Jesús aniuteana su, discípulo cuana ja nariatana tu equisaba puji uja: —Quisaque ecuanaju, ¿quetsunu da templo edajajape? ¿Ai nimetiuda ni da ecuanaju eba, mi jasiapatiji mahue su? ¿Ai nimetiuda ni da ecuanaju eba, jamatseti tsine cuinaji mahue su? ");
INSERT INTO tnaNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Da su Jesús ja atana huecuana: —Merejatique. Be mebaseametiji. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Beju ema jasiapatiji mahue su, ebia su quema ebani neje epueta. “Ema da Cristo”, eputa huecuana. Beju bid'umimi puji eputa huecuana. Jucuada cristiano cuana ebaseata huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ema jasiapatiji mahue su, ebia su emajaitita ye mundo su, micuaneda eid'aba. Be merubutanaji. Daja da epu, mundo pupeji mahue su. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Beju piada ejude su aniji cuana eichetita pia ejude su aniji cuana neje. Mid'e, chiqui epu. Yahua eruburubu pamapa yahua je. Beju daja da equene epu, mundo pupeji mahue su. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tueda ai nimetiuda cuana da epupiruji. Ebia su sufri eputa tsuhu ye mundo su aniji cristiano cuana, mundo pupeji mahue su. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","‘Beju micuana emenajatiata huecuana huaraji cuana peje su nedaneda ya puji, emanuame puji. Micuana eduininibata huecuana, micuaneda da quema dharejiji cuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Beju da tiempo su dueji Diusu tije aji cuana ja tije yarijita. Mecuana sa Diusu peje su janimetucheati cuana etaitanametita huecuana. Tuneda cama duininida ebatita. Beju emenajatiatita huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Da tiempo su ema cuinaji mahue su, dueji bid'umimi puji cuana bataji epu. Uja eputa huecuana: “Ecuanaju Diusu sa puji butsepi emimiani.” Beju aimue tuneda mu Diusu peje jenetia mahue. Dueji cristiano cuana ebaseata huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Da tiempo su ebia su jucha epu putsu, cristiano cuana huamahuama tsada mahue ebatita. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Beju quebata da Diusu peje su emanu teje daja hue ebia su enimetucheaderati su, tueda da d'eji su epueni. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pamapa yahua je Diusu sa quisa saida cuana quisapejiji epu su, da hora su beju mundo epupe. Da su ema esiapatiyu. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","‘Diusu sa profeta Daniel chenu ja deretaidha tueda Diusu sa ai saida cuana madhaji deja jepuiti. Beju meshanapaque ye quema quisa cuana. Tueda deja madhadada templo su ebia su iyuda ani jude su Diusu pu cua nime enetiti. Micuaneda ye ai cuana eba su, da su micuaneseda jududu tiempo beju cuinaitia. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Judea yahua su aniji cuana emata cuana su pajududuta. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Da hora su quebata da mesa ete epa pachata bia su yani su, bute putsu, tipeida pajududu. Be ete su panubi mesa ai cuana ejemicuinati puji. Butsepi hue pajududu. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Beju da hora su quebata da te su yani su, be pasiapati mesa ete su mesa ejud'uji ejemicuinati puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Aba quitaita epuna dheiji, edhereji cuana! Putadhada tuneseda ejududu puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Diusu mebajaque, be huinahuina badi cuana su ejududu hora papu. Daja huecha be janahua tsine su, ejududu hora papu. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Da tiempo su cristiano cuana ebia su sufri eputa. Quetsunu su biame daja sufri pu bue mahue ta biame, beju da tsunu su sufri eputa huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ahua Diusu ja tueda sufrimiento tiempo aimue ubu hora hue yata mahue su, aimue aidhe biame d'eji su epu mahue. Beju Diusu ja tueda sufrimiento tiempo ubu hora hue yatayu mesa dharejiji cuana d'eji su paputa puji, tuahueda ibuneda ebatani huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","‘Ahua quebata ja micuana, “U hue da Cristo”, yata su, be jei mepuji, jucuada deja cuana Cristo nime ebametita putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Diusu sa quisa puji cuana nime ebametita huecuana biame, tuneda da jabaseatiji cuana. Pamapa ai nimetiuda aida cuana yatayu huecuana. Diusu sa dharejiji cristiano cuana baseaja yadhaatayu huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Beju yama jiahue micuana butsepi equisainia, tueda ai cuana cuinaji mahue su. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Da putsu, ahua quebata ja micuana, “Dapia d'anita yahua su Cristo yani”, yatani su, be jei mepuji. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Beju ema neicha esiapati su, pamapa cristiano cuana ja ema epusiu ebata. Tserutseru sa hueda nime da quema jasiapati epu ye mundo su cristiano cuana ja ebata. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ai ihui esa su, samani cuana tipeida edhitatitani nime, daja huecha ema tipeida esiapati ye mundo su aniji cristiano cuana ecastiga puji, beju ebia su madhada hue eputa huecuana su. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","‘Tueda sufrimiento tiempo beju ejaitianani cama, id'eti, badi da yapuna. Atujai cuana edajajata. Cielo quitana eruburubu. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Da su pamapa cristiano cuana ja ema cielo jenetia epusiu ebata. Judu duje quema hueda, tucheda neje ema epusiu ebata huecuana. Beju ema epue su, pamapa ye mundo su cristiano cuana da ebia su epata, iyuame pu putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Pututu jubida eturuta su, yama quema ángel cuana ebeitu ye mundo su pamapa quema dharejiji cuana padhitata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","—Mepibatique equi cuana. Beju eina eichacua chidi eturucatitani su, da su jad'iati badi cuana enariatiani micuaneda eshanapainia. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Daja huecha tueda nimetiuda iyuda ai cuana ba putsu, ema epusiu tiempo huedhue beju. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ene putsu, yama micuana equisainia, pamapa tueda ai nimetiuda ebapirutani cuana aimue emanuta mahue tsuhu ema epueicha teje. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Beju cielo, mundo epupe biame, quema mimi mu aimue epupe mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","‘Aidhe biame bue mahue ai tsine su ema esiapati ye mundo su. Angel cuana biame bue mahue. Ema biame bue mahue. Tata Diusu quitaita bahui bahue ai hora su ema esiapati. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","‘Beju Noé chenu sa tiempo su puidha nime, daja da epu, ema esiapati su. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Da tiempo su Diusu ja cristiano cuana nai, ena neje manuamepeji mahue su, diadiataina, jaid'ititaina, jabutsenetitaina huecuana Noé chenu arca su nubidha teje. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Aimue jei putaidha mahue huecuana Diusu sa jamatseti jubida epusiu. Tueda nai, ena jamatseti pupiruidha su chu, Diusu peje su japibatitaidha huecuana. Ena ja beju manuamepetaidha huecuana pamapa. Daja huecha cristiano cuana jei puja mahue eputa, ema jasiapatiji mahue su. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ema esiapati tiempo su beta deja detse te su emudumudusa epu. Beju piada Diusu ja edusuta. Pia mu enetiti. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Da tiempo su beta epuna detse edudududusa epu. Beju piada Diusu ja edusuta. Pia mu yaniti. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","‘Da putsu, menimepitique, micuaneda ema esiapati hora bue mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Beju jiahue yama micuana bahue quisa neje equisa. Ete emetse ai hora su tsi puji mesa ete su enubiani bahue pu putsu, aimue detse tahui cua mahue. Aimue tsi puji ete su panubi yata mahue tsi papu puji. Etse epibatiani mahue hora quitaita su beju tsi puji ete su enubiani. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Daja micuaneseda ete emetse nime janimepitijiji ani taji, micuaneda epibatiani mahue hora quitaita su beju ema ye mundo su esiapati putsu. Mepibaenitique ye quema mimi cuana su. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","‘Ete emetse ecuinanani su, pamapa mesa emebajaji cuana piada emebajaji emenajatiajusianatani saida pabata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ahua tueda emebajaji ja pamapa saida ebata su, ete emetse ja tueda saida echujetiata, jasiapati putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tueda emebajaji saida ebia su aida ai cuana emenajatiajusianata. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ahua tueda emebajaji ja saida pamapa ai cuana ebata mahue su, ete emetse ja tueda ecastigata, jasiapati putsu. Tueda emebajaji uja madhada hue japibati cua: “Quema echua puji mu aimue beju tipeida esiapati mahue.” ");
INSERT INTO tnaNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ahua tuahueda pia emebajaji cuana icheta cua su, da su ete emetse ja tueda jubida castigata cua, jasiapati putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tueda echua puji ete emetse da esiapati emebajaji madhada ja tu eid'uatani mahue hora su. ");
INSERT INTO tnaNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Da su emebajaji madhada ete emetse ja ejusiacuinata. Castigo jude su ebeituta. Dapia ebia su epata, etsedhaitita ebia su sufri eputa huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","‘Diusu ecuatsasiati da beju uja: Piada tunca epuneje anitaina. Lámpara metse cama, jahuaneti tsine su putitana huecuana ehuaneti eid'ua puji, ehuaneti cuinaja su, tsu putsu, tsine ete su ebuque puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Beju pishica jabasetatiji mahue putaina. Pia pishica mu beju jabasetatijiji putaina. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Tueda pishica jabasetatiji mahue cuana ja aimue aceite dusutana mahue lámpara cuana esejea puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Tueda pia pishica jabasetatijiji cuana ja aceite tupu dusutana emeji chidi su, mecuana sa lámpara cuana neje tupupai. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Beju ehuaneti mue cuinapuda puana putsu, tahuitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Da su dhidha dusete su tsiatsia id'abatana huecuana uja epuani: “¡Ehuaneti beju epusiu! ¡Mecuinanaque tu etsu puji!” ");
INSERT INTO tnaNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Da su pamapa epuneje cuana netianatana lámpara cuana ehuitsuti puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Beju tueda pishica jabasetatiji mahue epuneje cuana ja pia pishica epuneje cuana uja bajatana: “Metiaque ecuanaju huai chidi micuana sa aceite, ecuanaju sa ehueitiani putsu.” ");
INSERT INTO tnaNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Da su pishica jabasetatijiji epuneje cuana ja uja jeutsutana huecuana: “Mahue. Ahua ecuanaju micuana etia su, ecuanaju sa macha da ehueiti. Da su aimue tupu epu mahue ecuaneseda puji. Mebajatitique aceite iruji cuana peje su.” ");
INSERT INTO tnaNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Da su beju tipeida putitana huecuana ebajatiti puji. Tuneda putitana cama beju ehuaneti cuinana. Da su pishica jabasetatijiji epuneje cuana da ehuaneti neje ete su nubitana jahuaneti tsine eba puji. Nubi putsu, ete teritana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Da su beju tueda pia pishica aceite bajaji epuneje cuana cuinataibana su, ete terijiji batana huecuana. Ete terijiji ba putsu, uja tsiatsiatana huecuana: “¡Echua puji, tsequed'iaque ecuanaju!” ");
INSERT INTO tnaNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Da su beju echua puji ja jeutsutana huecuana uja: “Ene putsu, mue yama micuana shanapa.” ");
INSERT INTO tnaNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jesús ja daja quisape putsu, uja atana huecuana: —Da su beju janimepitijiji meanique, aimue micuaneda eshanapainia mahue ai hora jia ema ye mundo su esiapati putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","‘Diusu ecuatsasiati da beju uja: Piada deja pia yahua su putiana. Beju putiji mahue su, deja ja mesa emebajaji cuana tu peje su ihuatana. Pamapa mesa chipilu cuana menajatiatana huecuana chipilu cuana payapacameta huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","‘Equene emebajaji pishica mil chipilu tiatana. Beta puji emebajaji beta mil chipilu tiatana. Quimisha puji emebajaji piada mil chipilu tiatana. Tuna sa tucheda tupu chipilu tiatana. Daja tiape putsu, emetse putiana. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Da su pishica mil chipilu tiatana emebajaji ja, inatsu putsu, pia pishica mil yapacametana. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Beta mil chipilu tiatana emebajaji ja, daja huecha inatsu putsu, pia beta mil yapacametana. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Piada mil chipilu tiatana emebajaji ja, inatsu putsu, rubuaichatana rara su. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","‘Beju pia mara su emetse cuinaibana su, mesa emebajaji cuana tu peje su ihuatana quejucua chidi chipilu yapacametana huecuana eshanapa puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Da su equene pishica mil tiatana emebajaji cuinana tu peje su. Piada tunca mil chipilu cuana emetse menajatiatana. Uja tuahueda emetse atana: “Echua puji miada ema pishica mil chipilu tiana. U hue piada tunca mil chipilu cuana yama mi etiainiayu. Beju pia pishica mil chipilu cuana yama yapacameana.” ");
INSERT INTO tnaNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Da su emetse ja tueda atana: “¡Saipie! Mida da emebajaji saida. Miada saida ana quejucua chidi chipilu neje putsu, yama mi huaraji aida yayu. Beju ema neje anitique. Beidaji puque ema neje.” ");
INSERT INTO tnaNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Da su beju beta mil tiatana emebajaji macha cuinana emetse peje su. Pushi mil chipilu cuana emetse menajatiatana. Uja tuahueda emetse atana: “Echua puji, miada ema beta mil chipilu cuana tiana. U hue pushi mil chipilu cuana yama etiainiayu.” ");
INSERT INTO tnaNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Da su emetse ja tueda atana: “¡Saipie! Mida da emebajaji saida. Miada saida ana quejucua chidi chipilu neje putsu, yama mi huaraji aida yayu. Beju ema neje anitique. Beidaji puque ema neje.” ");
INSERT INTO tnaNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Da su beju tije piada mil tiatana emebajaji macha cuinana emetse peje su. Piada mil chipilu cuana bahui emetse menajatiatana. Uja tuahueda emetse atana: “Echua puji, yama eshanapainia mida da deja iyuda. Miada da pia sa mudu neje mique chipilu eyapacameinia yama eshanapainia putsu, ema iyuame puana. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Da putsu, yama mique piada mil chipilu cuana rara su rubuaichana. Beju u hue mique piada mil chipilu.” ");
INSERT INTO tnaNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Da su emetse ja emebajaji uja jeutsutana: “Mida da emebajaji tunada, ate. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Mida bahue puana ema deja iyuda putsu, tueda chipilu banco su dhucuana ichati taji ana dapia payapacati puji ema esiapati teje.” ");
INSERT INTO tnaNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Da su emetse ja dapia eneti cuana cuatsasiatana uja: “Memejemique tusa piada mil chipilu. Metiaque tueda chipilu yama pishica mil tiana emebajaji. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Quebata sa yani, tueda yama etia ebia su quita. Quebata sa yani mahue, tueda yama emejemi quejucua mesa ai chidi yani cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ye emebajaji mue ai puji saida medusuque. Etseque, apuda su mejusiaque. Dapia ebia su epa, etsedhaiti ebia su sufri epu putsu.” ");
INSERT INTO tnaNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","‘Beju ema esiapati su, Echua Puji Aida epu. Quema ani jude su ema yaniute ecuatsasia epu puji. Quema ángel cuana ja ema ebareta. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ema butse su yama pamapa cristiano cuana edhitame. Yama eichaderayu huecuana, Diusu sa dharejiji cuana chujemame madhada cristiano cuana duju jenetia. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Beju Diusu sa dharejiji cuana, huisha nime, quema bai eni bene yama eicha. Madhada cristiano cuana, cabra nime, quema d'ani bai bene eicha. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Da su beju quema bai eni bene Diusu sa dharejiji cuana yama uja ya: “Menubique ema ecuatsasiati su, quema Tata Diusu ja micuana ibunebatana putsu. Meinatsuque micuaneseda puji Diusu ja basetataidha ai cuana. Mundo bataji puidha jenetia tuahueda tueda ai saida cuana basetapirutaidha micuaneseda puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Beju ema dhemanuana su, micuaneda ema mihuana. Ema jaid'itija puana su, micuaneda ema id'imeana. Ema extranjero puana biame, micuaneda ema saida batsuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ejud'uji quema hueitiana su, micuaneda ema tiana. Nedaji ema puana su, micuaneda ema peretiana. Terijiji ema aniana su, micuaneda ema batiana.” ");
INSERT INTO tnaNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Da su beju, tueda Diusu sa dharejiji cuana ja ema equisabata uja: “Echua Puji, ¿quetsunu mi ecuanaju mihuana, id'imeana? ");
INSERT INTO tnaNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Quetsunu mi ecuanaju saida batsuana extranjero nime? ¿Quetsunu mi ecuanaju ejud'uji tiana? ");
INSERT INTO tnaNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Quetsunu mi ecuanaju nedaji su peretiana? ¿Quetsunu ecuanaju mi terijiji yani su batiana?” ");
INSERT INTO tnaNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Da su yama ejeutsu huecuana uja: “Ene putsu yama micuana equisainia, ahua micuaneda quebata quema edue daja saida ana su, beju micuaneda ema a cua nime daja ana.” ");
INSERT INTO tnaNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","‘Da su beju quema d'ani bai bene madhada cristiano cuana yama uja ya: “Menetideraque ema peje jenetia, micuaneda mu ate cristiano cuana putsu. Cuati castigo su meputique. Tueda cuati castigo da Diusu ja basetatana Ishahua, mesa einid'u madhada cuana sa puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Beju ema dhemanuana su, aimue micuaneda ema mihuaja ana mahue. Ema jaid'itija puana su, aimue micuaneda ema id'imeja ana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ema extranjero puana biame, aimue micuaneda ema saida batsuana mahue. Ejud'uji quema hueitiana su, aimue micuaneda ema tiaja ana mahue. Nedaji ema puana su, aimue micuaneda ema peretiana mahue. Terijiji ema aniana su, aimue micuaneda ema batiana mahue.” ");
INSERT INTO tnaNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Da su beju tueda cristiano ate cuana ja ema equisabata uja: “Echua Puji, ¿quetsunu jia da mi ecuanaju daja madhada hue ana?” ");
INSERT INTO tnaNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Da su yama ejeutsu huecuana uja: “Ene putsu, yama micuana equisainia, aimue micuaneda quebata quema edue nimemitsida saida bana mahue putsu, micuaneda ema a cua nime daja madhada hue ana. ");
INSERT INTO tnaNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Da su beju tueda cristiano ate cuana cuati castigo su yama ebeitueni. Diusu sa dharejiji cuana mu cielo su, Diusu neje eid'e yanienititayu. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesús ja mesa discípulo cuana pamapa tueda ai cuana buetsuape putsu, uja atana huecuana: ");
INSERT INTO tnaNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Micuaneda bahue beta tsine hue beju pascua tsine puji. Da tsine su ema emenajatiata, curusu su ema patatata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Beju Jesús emimiani hora quitaita su sacerdote huaraji aida, jacuatsasiati ebuetsuaji, judío cuana sa tata edhi ehuidusuji cuana beju jadhitatitana. Sacerdote banime sa ete aida su jadhitatitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Dapia Jesús cuaja ina putsu, manuameme ya jaquisatitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Uja jaquisatitana huecuana: —Be painatija Jesús pascua tsine su. Ahua daja ecuaneda ya su, cristiano cuana detse janimetipeitita cua. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Beju Jesús da Simón sa ete su Betania ejude su anina. Equene Jesús ja tueda lepraji su saisiametana. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Beju dapia ete su yani cama, piada epuna ja Jesús nariatana. Tueda epuna ja chujeneda saida puida emeji su dusutana. Jesús misha naja su yani cama, epuna ja tusa echua bia su puida d'uichatana. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Da su beju discípulo cuana duininipirutana, epuna ja daja yatani ba putsu. Uja atana huecuana: —¿Ai puji ni da ye epuna ja daja ataitia? ");
INSERT INTO tnaNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ahua ecuaneda ye chujeneda saida puida iru cua su, dueji chipilu cuana ecuaneseda ani cua puri cristiano cuana etia puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Beju Jesús ja id'abatana huecuana putsu, uja atana huecuana: —¿Ai puji ni da micuaneda daja madhada emimiani ye epuna jepuiti? Tuahueda ema saida atana beju. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Puri cristiano cuana da micuana neje pamapa hora su yanita. Ema mu aimue micuana neje daja yani mahue. Quejucua tiempo chidi hue ema micuana neje yaniti. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ye epuna ja ema bia su d'uichataitia puida ema papaji pu cua nime. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ene putsu, yama micuana equisainia, quepia papu Diusu sa quisa saida cuana quisaquisa eputani su, ye eoyba ja ataitia di quisa eputa tu jiahue quita ataitia pamapa cristiano cuana ja pashanapata puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Da su beju Judas Iscariote da sacerdote huaraji aida cuana peje su putiana. Tueda Judas da Jesús sa discípulo puina. Tuna peje su putiana cuaja Jesús menajatiame ya equisa puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Beju uja atana Judas ja sacerdote aida cuana: —¿Quejucua chipilu micuaneda ema tia cua, ahua Jesús micuana yama menajatia cua su? Da su sacerdote cuana ja Judas quimisha tunca chipilu cuana tiatana. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Da hora jenetia beju Judas ja ai hora jia Jesús tu mehua epu id'uatana sacerdote cuana tipeida equisati puji, Jesús painata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Beju pan levadura mahue tsine epupiruani su, discípulo cuana ja Jesús quisabatana: —¿Quepia mique tsada ecuanaju ebaseta pascua tsine su ediadia puji? ");
INSERT INTO tnaNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Da su Jesús ja jeutsutana huecuana: —Meputique ejude su. Dapia piada deja sa ete su meputique. Mequisatiquetueda uja: “Echua Puji ja mi uja equisametani: ‘Quema manu hora beju nariatiani. Mique ete su ema pascua tsine su ediadia quema discípulo cuana neje.’” ");
INSERT INTO tnaNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Da su cuaja Jesús ja cuatsasiatana nime, atana tse. Pascua tsine jana basetatana tse. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Beju dhidha su Jesús, mesa discípulo cuana neje tuna ediadia ete su putiana. Dapia misha naja su aniutetana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ediadiatani cama, Jesús ja uja atana huecuana: —Ene putsu, yama micuana equisainia, piada ja micuaneda ema emenajatia deja madhada cuana peje su. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Da su ebia su jatacuamadhatitana huecuana. Piada piada ja Jesús quisabatana uja: —Echua Puji, ¿yama jia? ¿Ahua yama? ");
INSERT INTO tnaNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Da su Jesús ja jeutsutana huecuana: —Ema neje tupupai dhepe su ediadiani ja ema emenajatiata. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Beju ema sufri epu, cuaja Diusu sa quirica su derejiji yani batame. ¡Aba quitaita, ema menajatiaji epu deja! Ebia su saida quita tuseda puji bataji epu mahue puji puina. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Da su Judas ja di Jesús quisabatana: —Echua Puji, ¿ahua yama? Jesús ja tueda jeutsutana: —Ehe, miada. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tuneda beju ediadiatani cama, Jesús ja pan jemitsua putsu, diusulupai Diusu atana. Pan ped'uped'ua putsu, discípulo cuana herereatiatana. Uja atana huecuana: —Mediaque. Ye pan da quema equita pu cua nime. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Daja huecha vinoji emeji jemitsua putsu, diusulupai Diusu atana. Vinoji emeji berereatiatana huecuana. Uja atana huecuana: —Pamapa su meid'ique ye emeji jenetia. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ye vino da quema ami pu cua nime. Quema ami ed'uichati putsu, Diusu ja cristiano cuana mesa jamitsuti eichacua etiata. Dueji cristiano cuana eperdonatayu, quema ami ed'uichati putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Yama micuana equisainia, aimue ema eid'iicha mahue, quema Tata Diusu ecuatsasiati su micuana neje eid'i teje. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Da su beju diadiape putsu, Disusu sa puji satsutana huecuana. Satsupe putsu, Olivo murucu su putitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Dapia cuinati putsu, Jesús ja uja atana huecuana: —Pamapa micuaneda ema mehua ejusianetia ye dhidha su. Daja micuaneda ya, cuaja Diusu sa quirica su epuani batame. Beju uja epuani: “Yama huisha quinaji emanuame su, huisha cuana eberebereatita.” ");
INSERT INTO tnaNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ema biame, beju eid'eyu. Id'eyu putsu, ema micuana equene Galilea yahua su eputi dapia micuana emitsu puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Da su Pedro ja Jesús uja atana: —Echua Puji, pia cuana ja mi ejusianetiata biame, aimue mi yama mu daja ya mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Da su Jesús ja tueda jeutsutana: —Pedro, ene putsu, mi yama yainia, ye dhidha su quitaita da quimisha nuati mida uja emimi: “Mue yama Jesús shanapa.” Huaripa deja queji mahue su, daja mida epu quimisha nuati. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Da su Pedro ja uja jubida atana Jesús: —Mi neje quema manu taji biame, aimue mi yama ejusianetia mahue. Beju pamapa pia discípulo cuana di daja putana. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Da su beju Jesús da mesa discípulo cuana neje cuinatiana Getsemaní banime et jude su. Dapia cuinati putsu, Jesús ja discípulo cuana uja atana: —Meaniuteque upia. Yama Diusu emitsuti chuadera. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jesús ja Pedro, Jacobo, Juan cuana bahui tu neje dusutana. Pia cuana mu dapia hue anititana. Chuadera cuinati putsu, beju Jesús ebia su jatacuamadhapirutiana. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Da su mesa quimisha discípulo cuana uja atana: —Ebia su ema etajiatiani. Emanu nime ema ebatiani. Meanique upia. Ema neje meid'enique. Be metahuiji. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Da su Jesús chuadera pad'i puderatiana. Dapia beju d'epesa putsu, Diusu mitsupirutana. Uja Diusu bajatana: —Quema Tata, miqueda puji mu pamapa ai cuana atasaida. D'eji su aque ema curusu su sufrimiento epusiu jenetia. Daja biame, mique tsada bahui papu. Ba quema tsada mu papu. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Da su beju quimisha discípulo cuana peje su jasiapati putsu, etahuitasa huecuana batana. Uja Pedro atana: —¿A da aimue micuaneseda tucheda anitia mahue ema neje piada hora chidi dhucuana eid'eni puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Beju meid'enique. Diusu memitsuniaque Ishahua ja micuana epirubata mahue puji. Ene putsu, micuaneda jucha aja mahue yainia biame, daja micuaneda yainia, nimetucheda mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Beju neicha Jesús chuadera pad'i putiana Diusu emitsu puji. Uja atana Diusu: —Tata, ahua aimue miada ema ye sufrimiento jenetia d'eji su aja mahue su, beju saipie hue. Mique tsada bahui papu. Quema mu mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Da su beju neicha quimisha discípulo cuana peje su jasiapati putsu, etahuitasa huecuana batana. Tahui mecuana sa a taji mahue putsu, beju tahuitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Da su Jesús ja neicha ichajusiatana huecuana Diusu emitsu puji. Quimisha nuati puji Diusu mitsutana. Cuaja equene su Diusu mitsutana. Cuaja equene su Diusu mitsutana nime, daja huecha atana quimisha nuati puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Beju daja mitsupe putsu, neicha jasiapatibana quimisha discípulo cuana peje su. Uja atana huecuana: —¿Ahua micuana etahuisa tsuhu? Beju mejanahuasaque hue. Beju tupu saida, juchaji deja cuana sa eme su ema emenajatiata hora cuinaitia putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Menetianaque. Meputija. Mechamaque, ema menajatiaji epu deja beju epusiu. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús da discípulo cuana neje daja epuani cama, Judas tu peje su cuinana. Tu neje jucuada deja cuana espadaji aida, judío cuana sa tata edhi ehuidusuji cuana ja beitutana huecuana Jesús painata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Tuneda cuinatiji mahue su, Judas ja uja bahuequisatana huecuana: —Quebata yama ebudhi, tueda da Jesús. Tueda meinaque. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Da su Judas ja Jesús naria putsu, “Ebuetsuaji”, yainia je, budhitana. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Da su Jesús ja tueda uja atana: —Eshanapa, ai ya puji mi pueitia, aque hue. Da su beju deja cuana ja Jesús inatana edusu puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Da hora su piada Jesús sa discípulo ja espada neje pia deja sa eid'aja siquijusiatana. Tueda deja da sacerdote aida sa emebajaji puina. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Da su Jesús ja tueda discípulo uja atana: —Biuyuque mique espada. Quebata da espada neje eicheti su, tueda da espada neje emanu. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Bahue puque, ahua yama quema Tata baja cua su, tuahueda siete tunca ejaitiana mil ángel cuana quema beituta cua ema pabianetiata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Beju aimue daja yama ebaja mahue. Jiahue ema risijiji mecuana sa dusu taji, cuaja Diusu sa quirica su derejiji yani batame. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Da su Jesús ja tu inaja puetana deja cuana uja quisabatana: —¿Ai puji ni da micuaneda pueitia espadaji, aquiriji metse cama? ¿Ai ema tsi puji bata? Pamapa tsine ema templo su aniana cristiano cuana ebuetsua puji. Aimue micuaneda ema inana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Beju daja epuani, cuaja Diusu sa profeta chenu cuana ja deretaidha batame Diusu sa quirica su. Da su beju discípulo cuana pamapa jududupetana. Jesús tu mehua jusianetiatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Da su beju Jesús dusutana huecuana sacerdote cuana sa echua puji aida butse su, Caifás banime. Dapia jacuatsasiati ebuetsuaji, judío cuana sa tata edhi edhuidusuji cuana di netitaina. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Beju Pedro ja uqueda uqueda tije atana Jesús ete taraca etsequeini teje. Taraca su nubi putsu, Pedro aniuteana piada piada huaraji aida sa soldado cuana naja su, cuaja Jesús yata huecuana eba puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Da su pamapa tueda huaraji aida cuana ja Jesús tuaquisaja atana tu emanuame puji. Bid'umimi neje tuaquisaja atana huecuana tu manu neje, ematseta puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Beju jucuada jatuaquisatiji cuana ja bid'umimi neje Jesús tuaquisatana biame, aimue teje atana huecuana tu ematseta puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Uja putana jatuaquisatiji bid'umimi puji cuana: —Ye Jesús da uja puana: “Yama ye Diusu sa templo jusiaute cua. Quimisha tsine jenetia yama neicha netianameyu cua.” Beju daja tueda jatua quisatiji bid'umimi puji cuana ja atana. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Da su sacerdote sa echua puji aida netiana putsu, Jesús uja quisabatana: —¿Jucuaja su ni miada ye jatuaquisatiji cuana aimue ejeutsuinia mahue? ");
INSERT INTO tnaNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Beju Jesús ja mue jeutsuja a. Da su sacerdote aida ja uja Jesús atana: —Diusu sa ebani su yama mi ecuatsasiainia, butsepi ecuanaju quisaque. ¿A da mida Diusu sa Ebacua? ");
INSERT INTO tnaNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Da su Jesús ja jeutsutana. —Ehe, ema da. Diusu aida, tucheda eni sa bai eni bene yani micuaneda ema eba. Buepa su judu duju su ema epusiu micuaneda eba. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Daja id'aba putsu, sacerdote aida ja mesa ebia jud'uji d'iud'iujatana, ebia su duinini putsu. Uja atana pia cuana: —Beju ye deja ja Diusu madhabataitia mesa mimi neje. ¿Ai puji ni ecuaneda pia jatuaquisatiji cuana chacu cua. Micuaneda quitaita beju id'abaitia tusa mimi madhada cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Beju ¿cuaja micuaneseda piba? ¿Tueda juchaji ahua mahue? Da su jeutsutana huecuana uja: —Tueda da juchaji. Pamanu beju. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Da su Jesús ebu su0 equedi neje quid'uatana huecuana. Ichetana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Pia cuana ja Jesús tuarisi putsu, ebu su ichepirutana huecuana. Daja iche putsu, uja atana huecuana: —Ahua ene mida Diusu sa Jabeituti Deja su, quisaque ecuanaju aiya mida ebu su ichetaitia. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Beju daja Jesús yatani huecuana cama, Pedro etseque su anina. Piada sacerdote aida sa emebajaji epuneje ja nariatana. Tuahueda Pedro uja atana: —Mida di tueda Galilea yahua jenetia deja Jesús neje puniunetina. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Da su Pedro ja uja jeutsutana: —Bue mahu ema ai jepuiti mida emimiani. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Da su beju Pedro taraca etibeini su epuhu cama, pia emebajaji epuneje ja batana. Uja atana epuneje ja dapia netitana cuana: —¡Mechamaque jichu deja! Tueda di tueda Nazaret ejude jenetia deja Jesús neje puniunetina. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Beju neicha Pedro ja uja atana: —Mue yama shanapa tueda deja. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Da su dapia enetita cuana ja Pedro nariatana. Tu chama putsu, uja atana huecuana: —Ene putsu, mida da tueda deja sa ebuqueji. Ecuanaju eshanapainia mique mimi jepuiti. Galilea cuana sa mimi nime mique mimi. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Da su Pedro Diusu bahue pupiruana. Uja jeutsutana huecuana: —Beju yama micuana quisaitia aimue yama tueda deja shanapa. Diusu ja ema pamatseta, ahua ema bid'umimi epuani su. Da hora quitaita su Pedro mimipeitia su beju huaripa deja queiana. ");
INSERT INTO tnaNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Da su Pedro japibatiana Jesús sa uja mimi cuana su: “Huaripa deja queiji mahue su, mida, ‘Mue yama Jesús shanapa’, epu quimisha nuati.” Da su Pedro taraca jenetia tipeida cuinana putsu, jubida pana. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Beju ehuenani su, pamapa sacerdote aida cuana, tata edhi ehuidusuji cuana neje jadhitatitana. Tuneda jaquisatitana cuaja Jesús manuameme ya. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jesús risijiji dusutana huecuana huaraji aida Poncio Pilato banime peje su. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Beju Judas ebia su jatacuamadhatiana, Jesús manuameja yatani huecuana bahue pu putsu. Beju putiana sacerdote huaraji aida, tata edhi ehuidusuji cuana peje su quimisha tunca chipilu cuana tu tiatana huecuana etiatiyu puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Tiatiyu putsu, uja atana huecuana: —Ema da jucha aida puitia, deja jucha mahue yama menajatiaitia putsu. Da su jeutsutana huecuana uja: —Ecuanaju sa mu mue ai biame a taji. Tueda mu miqueda. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Da su Judas ja chipilu cuana huararatana templo su. Huarara putsu, templo jenetia cuinanana. Beju janajaribiatiana. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Da su sacerdote aida cuana chipilu cuana chudutana. Tuneda cama jaquisatitana uja: —Aimue ye chipilu templo sa caja su ecuaneda icha cua mahue, ye chipilu da deja emanuame puji tiajiji putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Da su yahua eped'u bajatana huecuana chipilu neje. Tueda yahua da extranjero judío mahue emanutani cuana epapa puji. Tueda yahua ped'u da Eicha Jutu Muduji Jude banime puina. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Da tsine jenetia cristiano cuana ja tueda yahua ped'u Ami Yahua ebani ichatana. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Beju daja puana, cuaja biahua tiempo Diusu sa profeta Jeremías chenu ja deretaidha batame. Uja deretaidha: “Tueda quimisha tunca echuje tupu hue israelita cuana ja ichatana. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Tueda chipilu neje Eicha Jutu Muduji Jude banime bajatana huecuana. Daja yama ana, cuaja Diusu sa tsada puana batame.” ");
INSERT INTO tnaNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Da su Jesús dusutana huecuana huaraji aida Pilato butse su. Beju tuna cuinatana su, Pilato ja uja quisabatana Jesús: —¿A da mida judío cuana sa echua puji? Da su Jesús ja Pilato jeutsutana uja: —Ehe, ema da cuaja mi mimitia batame. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Beju sacerdote huaraji aida, tata edhi ehuidusuji cuana ja Jesús tuaquisatana su, aimue Jesús ja jeutsuja atana huecuana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Da su Pilato ja Jesús uja atana: —¿Mue mi id'aba mi etuaquisatani huecuana? ¿Jucuaja su ni mi aimue ejeutsutiani mahue? ");
INSERT INTO tnaNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Da su Pilato nimetiunetiana, Jesús ja mue jeutsu huecuana putsu. Beju tuahueda cuaja pibape taji mahue batana. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Beju tsine epueti cama, Pilato ja piada terijiji d'eji tia bahue puina. Daja mesa puiti puina. Quebata terijiji cristiano cuana ja edharetani, tueda da Pilato ja d'eji tia bahue puina. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Beju piada terijiji anina Barrabás banime. Pamapa cristiano cuana ja tueda shanapataina. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Da su Pilato ja cristiano cuana quisabatana uja: —¿Quebata deja micuaneseda tsada yama d'eji etia puji? ¿Barrabás ahua Jesucristo? Mequisaque ema. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Daja Pilato ja quisabatana cristiano cuana, sacerdote aida cuana ja Jesús duininiba putsu, tu peje su menajatiatana bahue pu putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Beju Pilato ja tueda ai cuana ebutsepia puji ebatani cama, mesa ehuane tu quisametana uja: “Be cuaja biame aji tueda deja, dhidha su yama pia iyuda tahuibaja putsu.” ");
INSERT INTO tnaNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Beju sacerdote huaraji aida, tata edhi ehuidusuji cuana ja cristiano cuana jubida bahue quisatana Pilato uja pajeutsuta huecuana puji: “Barrabás d'eji tiaque. Jesús manuameque.” ");
INSERT INTO tnaNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Da su Pilato ja neicha quisabatana cristiano cuana uja: —D'eji tiaque Barrabás. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Da su Pilato ja quisabatana huecuana: —¿Ai ni da ema pu cua Jesucristo neje? Da su pamapa su jubida tsiatsiatana uja: —¡Curusu su tataque! ");
INSERT INTO tnaNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Da su Pilato ja uja atana huecuana: —¿Ai madhada ni da ye deja ja atana? Da su neicha jeutsutana huecuana uja: —¡Curusu su tataque! ");
INSERT INTO tnaNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Beju Pilato ja cristiano cuana janimetipeitija eputani batana. Mesiaja mahue Jesús yatani huecuana batana. Da putsu, yahui paduseta cuatsasiatana. Beju yahui dusetana su, Pilato jamerucuatiana cristiano cuana butse su. Uja atana huecuana: —Aimue ema juchaji mahue ye deja jucha mahue emanuame puji. Uja da ema emerucuatiani micuaneda bahue epu puji ema jucha mahue. Beju micuaneda da juchaji epu, ye deja manuameja yainia putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Da su uja jeutsutana huecuana: —Ecuanaju da ecuanaju sa ebacua cuana neje beju ejeutsu tu emanu jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Da su beju Pilato ja Barrabás d'eji tiatana. Jesús huacabiti neje icheme putsu, menajatiatana curusu su patatata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Da su soldado cuana ja Jesús dusutana huaraji aida Pilato ete su. Dueji soldado cuana Jesús yani su jadhitatitana. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Mesa ebia jud'uji mejemitana huecuana. Pia ebia jud'uji idhiria tu bia su ichatana huecuana, tu neje eshishati puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Corona junu aquid'aji bauda jenetia atana huecuana. Da neje chuajud'utana huecuana. Mesa eme bai eni bene su huara ichatana huecuana. Daja a putsu, tu butse su tururutana huecuana tu peje eshishati puji. Uja atana huecuana: —¡Viva judío cuana sa echua puji! ");
INSERT INTO tnaNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Da su beju Jesús quid'uatana huecuana equedi neje. Huara neje chuataratana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Beju shishape putsu, ebia jud'uji idhiria mejemitana huecuana. Neicha mesa ebia jud'uji quitaita neje jud'utana huecuana. Da su beju Jesús dusutana huecuana curusu su etata puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Beju eputahu cama, piada deja Cirene yahua jenetia tsutana huecuana. Tueda da Simón banime puina. Tueda jubida cuatsasiatana huecuana Jesús sa curusu pamapata puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Daja cuinatitana huecuana Calavera banime eti jude su. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Dapia Jesús vino huiaja neje huarujiji tiatana huecuana paid'ita puji. Jesús ja tsaba putsu, id'ija mahue atana. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Beju Jesús curusu su tata putsu, soldado cuana ja mesa ejud'uji inatana. Aiya ejud'uji edusuta eba puji, suerte atana huecuana. Daja beju puana, cuaja biahua tiempo Diusu sa profeta chenu ja deretaidha batame. Uja derejiji yani: “Suerte a putsu, quema ejud'uji tuneda cama jaberereatiatitana.” ");
INSERT INTO tnaNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Da su beju soldado cuana dapia aniuteana einatsihua puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Curusu su Jesús sa echua bia su mimi cuana deretaidha huecuana. Tueda mimi uja puana: “Ye da Jesús, judío cuana sa Echua Puji.” ");
INSERT INTO tnaNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Daja huecha beta tsi puji detse macha tu naja su tata putsu, badeanatana huecuana. Piada, Jesús sa bai eni bene, pia, d'ani bai bene. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Da su jaitianatana cuana ja Jesús madhabatana uja: ");
INSERT INTO tnaNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Mida templo jusiaute putsu, quimisha tsine jenetia enetianameyu, epuani putsu, jiahue quita buteque curusu jenetia. Mi mehua d'eji su jaatique. Ahua mida Diusu sa ene quita Ebacua su, beju buteque. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Daja huecha sacerdote huaraji aida, jacuatsasiati ebuetsaji, fariseo, tata edhi ehuidusuji cuana dapia anitaina. Tuneda cama uja jaquisatitana: ");
INSERT INTO tnaNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ye deja ja pia cuana d'eji su a bahue biame, jiahue quita tu mehua cuaja d'eji su jaati taji mahue ebatiani. Ahua tueda ene quita Israel sa Echua Puji su, pabute ecuanaju tu peje su jei epu puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tueda pa Diusu peje su janimetucheatiana. Daja huecha Diusu sa ebacua pa epuani. Ahua ene daja su, ahua Diusu ja tueda ibuneda ebatani su, da su jiahue quita Diusu ja tueda d'eji su paata. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Beju Jesús naja su curusu su tatajiji ebade tsi puji ja di Jesús madhabatana. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Beju buepatia jenetia badeute uqueda teje apunana. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Da hora su Jesús jubida tsiatsiana uja: —Quema Tata Diusu, quema Tata Diusu, ¿jucuaja su mi ema jusiabadeanaitia? ");
INSERT INTO tnaNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Piada piada dapia netitaina cuana ja Jesús daja etsiatsiani id'aba putsu, uja putana huecuana: —Diusu sa profeta Elías chenu eihuatani. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Da su piada deja ja huapese nime vino edhi, tsetseda su tsabiatana. Aqui huiri bauda huitsana su icha putsu, Jesús sa ecuatsa su atsuatana tu paid'iti puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Beju da je netitaina cuana ja deja atana uja: —Id'ua taji tsuhu. Pabatija, ahua Elías chenu epue tu curusu jenetia ejemiute puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Da su neicha Jesús jubida tsiatsiana. Daja tsiatsia putsu, beju manuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Da hora quitaita su templo dume su telón aida, bauda, pamuda badeji beju ebia jenetia ema su cuata jabud'iutiana. Beju yahua di ruburubuana. Tumu aida cuana di jadhatitana. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Sepulcro cuana di jatsequed'iatitana. (Daja biame, mue netianayu putana manujiji cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jesús id'eibana su chu, dueji Diusu peje su jei eputani manujiji cuana macha id'etaibana. Tueda sepulcro jatsequed'iatijiji cuana jenetia netianataibana huecuana. Ejude Jerusalén su putitana huecuana. Dapia jucuada cristiano cuana ja batana huecuana.) ");
INSERT INTO tnaNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Beju curusu naja su Jesús inatsihuaji soldado cuana mecuana sa capitán neje ebia su iyuame putana, yahua eruburubuani, pamapa pia ai nimetiuda cuana ba putsu. Da su beju uja jaquisatitana huecuana: —Ene putsu, ye deja da Diusu sa Ebacua. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Jucuada epuna cuana di dapia curusu huabata netitaina. Galilea yahua jenetia Jesús buquetaina huecuana tu etsahua puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tuna duju su María Magdalena, Jacobo, José detse sa cuara María banime netina. Zebedeo sa ehuane di dapia netina. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Beju tsinecua dhememeta su piada deja saida, chipiluji José banime pueana. Tueda Arimatea ejude jenetia puina. Tueda da di Jesús tije aji puina. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Huaraji Pilato peje su putiana Jesús sa equita ebaja puji. Da su Pilato ja cuatsasiatana Jesús sa equita José patiata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Tiatana huecuana su, José ja equita dusutana. Ebabuji saida neje babutana. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Equita babu putsu, mesa tumu epa sepulcro eichacua su huananubiatana. Sepulcro tsequeini tumu aida neje teri putsu, putibana. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Dapia sepulcro butse su María Magdalena, pia María neje anina. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Beju pia huenati sacerdote huaraji aida, fariseo cuana Pilato peje su putitana. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Uja Pilato atana huecuana: —Echua puji, ecuanaju epibainia tueda bid'umimi puji Jesús, “Quimisha tsine jenetia ema eid'eyu”, puana. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Da putsu, cuatsiasiaque mique soldado cuana ja sepulcro painatsihuata quimisha tsine puji, cuapuitime Jesús sa equita mesa discípulo cuana ja dhidha su jemicuinata cua putsu. Beju equita jemicuina putsu, “Jesús id'eitiba”, cristiano cuana quisata cua huecuana. Da su tueda Jesús sa equene bid'umimi cuana ebia su aida pu cua. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Da su Pilato ja uja atana huecuana: —Beju micuaneseda soldado yani. Micuaneda hue sepulcro meinatsihuatique micuana sa tsada tupu. ");
INSERT INTO tnaNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Da su putitaibana huecuana. Tumu aida bia su sello ichatana huecuana. Templo sa soldado cuana ichatana huecuana sepulcro painatsihuata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Janahua tsine beju jaitianaja su, beju domingo tsine ehuenani su, María Magdalena, pia María neje, sepulcro su neicha jasiapatiana. ");
INSERT INTO tnaNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tuatse ecuinahu su, yahua jubida ruburubuana. Diusu sa ángel cielo jenetia bute putsu. Tuahueda sepulcro eteriji tumu aida ichaderatana. Tumu bia su aniuteana epuna detse ja batana. ");
INSERT INTO tnaNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tueda ángel da tserutseru nime, huedame batana tse. Mesa ejud'uji da pasane, cuarecuare batana tse. ");
INSERT INTO tnaNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Inatsihuaji soldado cuana ja ángel ba putsu, ebia su riariatana huecuana, iyuame epuani je. Yahua su manudajajapetana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Da su ángel ja epuna detse uja atana: —Be iyuame mepuji. Ema bahue metseda Jesús tatajiji echacuinia. ");
INSERT INTO tnaNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Aimue upia mahue. Beju id'eitiba, cuaja tueda equene quisa puana batame. Mechamaque tu esa mane eti jude. Beju mue ai biame. ");
INSERT INTO tnaNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Jiahue quita beju meputique mesa discípulo cuana peje su. Uja mequisatique huecuana: “Jesús manujiji cuana duju jenetia beju id'eitiba. Tueda mu beju Galilea yahua su putiba dapia micuana emitsu puji. Dapia micuaneda tueda eba.” ");
INSERT INTO tnaNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Da su beju epuna detse tipeida putibana discípulo cuana daja equisati puji. Iyuame, beidaji neje putibana tse. ");
INSERT INTO tnaNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Beju tuatseda epuhu cama, Jesús ja tsu putsu, mitsutana tse. Jesús naria putsu, ebia su beidaji neje mesa etsaja su id'amitana tse. ");
INSERT INTO tnaNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Da su Jesús ja atana tse uja: —Be iyuame mepuji. Mequisatique quema edue cuana Galilea yahua su paputita huecuana. Dapia ema ebata huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Epuna detse epuhu cama, piada piada inatsihuaji soldado cuana ejude su putitaibana sacerdote huaraji aida cuana pamapa cuaja ai puana cuana equisati puji. ");
INSERT INTO tnaNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Da su sacerdote huaraji aida cuana tata edhi ehuidusuji cuana peje su putitana tuna equisati puji. Tuneda cama soldado cuana jucuada chipilu etia puji jabutsepiatitana. ");
INSERT INTO tnaNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Chipilu etiainia je, uja atana huecuana: —Mequisatique cristiano cuana uja: Dhidha su Jesús sa discípulo cuana ja mesa equita jemicuinata sepulcro jenetia. ");
INSERT INTO tnaNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ahua huaraji aida Pilato ye ai cuana bahue epu su, beju ecuanaju micuana ebianetia tu butse su. ");
INSERT INTO tnaNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Da su beju soldado cuana ja chipilu ina putsu, putitana huecuana cristiano cuana daja equisati puji. Da putsu beju, jiahue teje judío cuana daja hue jei eputani. ");
INSERT INTO tnaNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Da su discípulo cuana quepia Jesús ja quisatana eti jude su putitana. ");
INSERT INTO tnaNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jesús ba putsu, ebia su beidaji neje mitsutsuatana huecuana. Daja biame, piada piada cuana mu jei puja mahue tsuhu putana. ");
INSERT INTO tnaNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Da su Jesús ja naria putsu, uja atana huecuana: —Ema da cielo, yahua su huaraji, ebia su aida, tucheda. ");
INSERT INTO tnaNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Da putsu, meputique pamapa ejude cuana su aniji cristiano cuana peje su. Ema tije aji meatique huecuana. Diusu sa puji meichaderatique huecuana yahui neje. Daja meaque Tata Diusu, Ebacua, Espíritu Santo sa ebani su. ");
INSERT INTO tnaNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mebuetsuatique huecuana, pamapa yama micuana jacuatsasiati tiana cuana. Bahue mepuque, ema pamapa hora su micuana neje yani. Beju pamapa ai cuana epupe teje, ema micuana neje yani. Daja papu.");
INSERT INTO tnaNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ye quirica da Jesucristo jepuiti quisa epuani. Cuaja tusa quisa saida cuana pupiruana quisa epuani. Cristo da Diusu sa Ebacua ye quirica su quisa epuani. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Biahua tiempo da cuaja Diusu Cristo jepuiti quisa puidha ai cuana profeta Isaías chenu ja uja deretaidha: Quema quisa pui yama ebeitu mi hui su cristiano cuana pabasetatita mi epue su puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Deja jubida quisaquisa epuani d'anita yaua su. Uja tueda epuani: “Mebasetatique Ecua Puji ecuina su puji.” ");
INSERT INTO tnaNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Da su beju Juan Bautista cuinana. Quisaquisa pupiruana cristiano cuana peje su Diusu peje su papibaturucatita huecuana puji. D'anita yahua su quisaquisa puana. Pamapa cristiano cuana ejude cuana jenetia Juan peje su putitana tusa quisaquisa cuana eida'aba puji. Ahua Diusu peje su epibaturucatita huecuana su, ahua tuseda puji yahui neje eichaderatita huecuana su, Diusu ja mecuana sa jucha cuana eperdonatayu. Daja Juan Bautista quisaquisa puana cristiano cuana peje su. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Beju pamapa cristiano cuana Juan peje su putitana tu eid'aba puji. Judea yahua, Jerusalén ejude jenetia putitana huecuana. Juan ja cristiano cuana yahui neje Jordán ena su Diusu sa puji ichaderatana, mecuana sa jucha cuana jatuaquisatitana huecuana su. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan sa ejud'uji camello sa einua etad'i jenetia puina. Ebiti jenetia da mesa eturisiji puina. Mesa jana da dhequere aida, huasa ena puina. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Beju Juan cristiano cuana peje su uja quisaquisa puana: —Pia ema tije epusiu. Tueda da ema ebia su huaraji aida putsu, ema mu mue ai eni mahue tu emebaja puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yama micuana yahui neje Diusu sa puji eichaderainia biame, tuahueda micuana Diusu sa puji eichaderata Espíritu Santo sa tucheda neje. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Da tiempo su Jesús cuinanana Nazaret ejude jenetia. Tueda ejude da Galilea yahua su anina. Da su beju Jesús da Juan Bautista peje su cuinana. Cuinana putsu, Juan ja tueda Diusu sa puji ichaderatana yahui neje Jordán ena su. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jordán ena jenetia cuinanana tse su, buepa jadhatiana Jesús ja batana. Espíritu Santo huaitucu nime tu bia su ebutesa Jesús ja batana. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Tata Diusu buepa jenetia jubida mimiana uja: —Mida da quema ibuneda Ebacua. Mi neje ema beidaji. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Da hora su beju Espíritu Santo ja Jesús d'anita yahua su dusutana. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Dapia Jesús pushi tunca tsine aniana. Animalo d'aida cuana di dapia anitaina. Dapia Ishahua ja Jesús nariatana tu epiruba puji, jucha yamedhaa puji. Da su beju Diusu sa ángel cuana butetana Jesús etsahua puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Beju Juan Bautista teriichatana huecuana su, Jesús Galilea yahua su putiana Diusu sa quisa saida cuana quisaquisa eputi puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Uja mesa quisaquisa puana: —Beju tiempo cuinaitia. Diusu ecuatsasiati beju nari. Mepibaturucatique Diusu peje su. Jei mepuque Diusu sa quisa saida cuana su d'eji su epu puji. Daja Jesús quisaquisa puniunetiana. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Galilea yahua bai maje je Jesús yaseniuneti je, Simón, mesa edue Andrés neje tsutana. Tarrafa aida neje se cuana inatasaina tse. Esia bahui tuatse sa mudu puina. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Da su Jesús ja atana tse uja: —Metseda se cuana memi bahue. Ema tije meaque. Yama metseda cristiano cuana ema peje su duseji yame. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Da hora su hue tarrafa cuana ichajusiatana tse Jesús ebuque puji. Beju putiana tse Jesús neje. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesús chuadera aseti putsu, beta deja Jacobo, Juan banime tsutana. Tuatseda edue ta tse puina. Tuatse sa tata Zebedeo banime. Pamapa tuneda canoa dume su anitaina. Tarrafa cuana basetatasaina huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Beju Jesús ja ihuatana tse tu tije paata puji. Da su beju tuatse sa tata Zebedeo, etsahuaji cuana ichajusiatana tse. Daja ichajusia putsu, Jesús tije atana tse. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Beju Capernaum ejude su cuinatitana huecuana. Janahua tsine su Jesús jadhitati jude ete su nubiana cristiano cuana ebuetsua puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tuahueda ebuetsuatani su, dapia yanita cristiano cuana nimetiunetitana, Jesús ja huaraji aida mimi neje buetsuatana huecuana putsu. Mesa jabuetsuati quitaita cuana buetsuatana. Aimue jacuatsasiati ebuetsuaji cuana nime buetsuame atana mahue. Tuna ebia su saida buetsuatana, pia sa jabuetsuati cuana bahui buetsua bahue putaina huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Da hora su beju piada deja einid'u madhadaji jadhitati jude ete su nubiana. Tuahueda tsiatsia neje Jesús uja atana: ");
INSERT INTO tnaNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Jesús, Nazaret ejude jenetia, ¿ai da miqueda ecuanaju neje a taji? ¿A mida pueitia ecuanaju ecastiga puji? Beju yama mi eshanapainia. Mida da Diusu sa Ebacua. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Da su Jesús ja einid'u madhada jubida cuatsasiatana uja: —Mitanaque. Cuinanaque ye deja peje jenetia. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Da hora su einid'u madhada ja deja eriariametani cama, jubida tsiatsiana. Tsiatsia putsu, deja mesiatana. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Pamapa yanita cristiano cuana ja ba putsu, nimetiunetitana huecuana. Da su tuneda cama jaquisabatitana uja: —¿Ai jabuetsuati cuana da ye? Ye Jesús ja einid'u madhada cuana huaru jubida cuatsasia bahue. Beju tuneda jei yatani. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Da putsu, tipeida pamapa cristiano cuana Galilea yahua su Jesús jepuiti bahue putana. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Da su beju Jesús jadhitati jude ete jenetia cuinanana su, Jacobo, Juan neje Simón, Andrés detse sa ete su putiana. Ete su cuinati putsu, nubitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simón sa ehuane sa cuara nedaji saina batana huecuana. Dapia yanita cuana ja epuna nedaji esa Jesús quisatana. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Da su beju Jesús ja epuna nedaji esa nariatana. Tusa eme ina putsu, beju netiainametana. Da hora su mesa neda jaitianana beju. Da su epuna saisi putsu, mebajapirutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Beju yapunahu su, dapia yanita cuana ja nedaji cuana dusepirutana Jesús peje su. Einid'u madhadaji cuana di dusetana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Pamapa ejude su aniji cristiano cuana ete tsequeini su jadhitatitana. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús ja dueji nedaji cuana sa tsapiapiati neda cuana saisiametana. Dueji einud'u madhada cuana jusiacuinatana cristiano cuana peje jenetia. Einid'u madhada cuana ja Jesús shanapatana putsu, Jesús ja aimue d'eji tiatana huecuana mahue pamimita puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Beju pia tsine id'eti cuinanaji mahue su, Jesús netianana. Ete jenetia cuinanana ejude tsahua su dapia tu mehua Diusu emitsu puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Da su Simón ja mesa ebuqueji cuana neje Jesús chacutitana. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jesús teje putsu, uja quisatana huecuana: —Beju pamapa ja mi echacutani. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Da su Jesús ja uja atana huecuana: —Meputija pia ejude nari cuana su, da je di ema quisaquisa epu puji. Daja epu puji ema pueana. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Da su Jesús quisaquisa puniunetiana pamapa Galilea yahua je. Pamapa jadhitati jude ete cuana su quisaquisa puana. Einid'u madhada cuana jusiacuinatana cristiano cuana peje jenetia. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Beju piada lepraji deja Jesús nariatana. Jesús butse su tururu putsu, uja atana: —Ahua mique tsada su, miada ema saisiame cua. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús ja deja bataichenu batana putsu, mesa eme neje deja d'apabatana. D'apaba putsu, Jesús ja deja atana uja: —Tsada quema Mida esaisi. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Da hora su deja saisiana beju. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Da su Jesús ja jubida cuatsasiatana uja: ");
INSERT INTO tnaNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Be aidhe biame quisaji. Jabametitique sacerdote peje su tuahueda mi saisijiji pabata puji. Da su beju Diusu irutsuaque, cuaja Moisés chenu sa jacuatsasiati epuani nime, pamapa cristiano cuana ja mida saisijiji pashanapata puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Da su beju deja putibana. Aimue atana mahue cuaja Jesús ja cuatsasiatana nime. Tipeida quisa pupiruana cuaja Jesús ja saisiameme atana. Daja deja ebia su quisa puana putsu, Jesús ejude cuana su cuaja nubisaita taji mahue jabatiana. Ejude jenetia uqueda putiana biame, dapia cristiano cuana ja Jesús batitana. Que jenetia papu cristiano cuana tu peje su putitana. ");
INSERT INTO tnaNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Jesús da quejucua tsine jenetia Capernaum ejude su jasiapatiana. Beju pamapa ejude su aniji cuana ja shanapatana. ");
INSERT INTO tnaNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Dueji cristiano cuana jadhitatitana Jesús yani ete su. Ete dume su d'eji mahue puana. Etseque su di d'eji mahue puana. Da su Jesús Tata Diusu sa quisa saida cuana quisaquisa punetina ete dume su. ");
INSERT INTO tnaNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Beju tu quisaquisa epuneti cama, pushi deja cuana cuinatana. Piada deja ase bue mahue chahui su mapabetana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Dueji cristiano cuana anitaina putsu, cuaja Jesús naria taji mahue batana huecuana. Da putsu, ete epa pachata su raranetana huecuana Jesús eneti butse su. Beju rara a putsu, deja ase bue mahue chahui su rara je butemetana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Da su beju Jesús nimetiuana, tueda pushi deja cuana sa janimetucheati cuana ba putsu. Da putsu, deja uja atana: —Deja, yama mique jucha cuana perdonaitia. ");
INSERT INTO tnaNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Beju pia jacuatsasiati ebuetsuaji cuana dapia anitaina. ");
INSERT INTO tnaNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Uja japibatitana huecuana: “¿Cuaja su ni da ye deja uja emimiani? Tuahueda Diusu emadhabatani mesa mimi neje. ¿Ai deja ja jucha cuana perdonata cua bata? Tata Diusu ja bahui jucha cuana perdonata cua. Beju Diusu puja epuani tueda.” Daja japibatitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Beju Jesús ja tuna sa piba cuana shanapa putsu, uja quisabatana huecuana: —¿Ai puji micuaneda daja madhada epibatiani? ");
INSERT INTO tnaNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ahua yama deja, “Mique jucha cuana yama eperdonainia”, ya su, ahua yama, “Netianaque. Jemitsuaque mique chahui. Aseque”, ya su, quema puji mu tupupai hue. ");
INSERT INTO tnaNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Daja yama deja yainia micuana ebame puji, ye mundo su ema tucheda eni cristiano cuana sa jucha cuana eperdona puji. Da su Jesús ja uja deja nedaji cuatsasiatana: ");
INSERT INTO tnaNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Netianaque. Mique chahui jemitsuaque. Putiyuque mique ete su. ");
INSERT INTO tnaNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Da hora su beju deja netianana. Mesa chahui jemitsua putsu, ete jenetia cuinanana. Beju pamapa dapia aniji cuana nimetiunetitana. Diusu saida mitsutsuatana huecuana. Uja putana huecuana: —Quetsunu biame ecuanaju uja ai ba bue mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Neicha Jesús putiana bai maje su. Pamapa cristiano cuana ja Jesús nariatana su, tuahueda buetsuatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Buetsuape putsu, Jesús asepiruana cama, Leví batana. Leví da impuesto chujebajaji jude su anina. Tueda da Alfeo sa ebacua puina. Da su Jesús ja Leví uja atana: —Tije ema aque. Da su Leví netiana putsu, tije apirutana Jesús. ");
INSERT INTO tnaNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Beju Jesús, mesa discípulo cuana neje Leví sa ete su putiana ediadia puji. Jucuada impuesto chujebajaji, juchaji cuana dapia anitaina, tuneda da Jesús tije ataina putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Beju jacuatsasiati ebuetsuaji, fariseo cuana ja Jesús impuesto chujebajaji, juchaji cuana neje ediadiani batana. Tuneda ba putsu, uja quisabatana discípulo cuana: —¿Jucuaja su da Jesús impuesto chujebajaji, juchaji cuana neje ediadiani? ");
INSERT INTO tnaNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesús ja id'aba putsu, uja jeutsutana huecuana: —Jaiduenetiji da aimue saida cuana sa puji mahue. Nedaji cuana sa puji bahui. Daja huecha aimue ema pue cristiano butsepi ebatitani cuana eihua puji mahue. Beju ema pueana juchaji cuana eihua puji, d'eji su paputa huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Beju Juan tije aji cuana, fariseo tije aji cuana neje tupupai quejucua tsine puji ayuna putanina. Da su piada piada cristiano cuana ja Jesús quisabatana: —Juan tije aji cuana quejucua tsine puji ayuna putanina. Daja huecha fariseo tije aji cuana eputani. ¿Cuaja su jia da mique discípulo cuana aimue ayuna eputani mahue? ");
INSERT INTO tnaNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Da su Jesús ja quisabatana huecuana: —¿Ai jahuaneti tsine su ihuajiji cuana ayuna puta cua bata, ehuanetisa deja tuna neje yani tupu? Ehuanetisa deja tuna neje yani tupu, ihuajiji cuana aimue ayuna eputa mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tueda ihuajiji cuana duju jenetia eijemicuinata su chu, da hora su ihuajiji cuana ayuna eputa, aimue tueda tuna neje yani mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mesa jabuetsuati cuana bata saida epu puji, Jesús ja daja hue quisainiame atana huecuana: —Aimue detse etse ejud'uji edhi remetia cua mahue pia eped'u eichacua neje. Beju tueda remetia eichacua ja ejud'uji edhi d'iuta cua. Da su tueda d'iujiji detse ebia su ainameta cua. ");
INSERT INTO tnaNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Daja huecha aimue vino eichacua etse emeji edhi su ichaseta cua mahue. Ahua daja etse a cua su, vino eichacua ja emeji pujuta cua. Da su vino, emeji neje tupupai taitana cua. Da putsu, vino eichacua emeji eichacua su ichaseta taji. Daja a putsu, pamapa saida epu. Vino, emeji neje tupupai saida epu. Daja Jesús ja bahue quisa neje buetsuatana huecuana. Mesa jabuetsuati eichacua cuana da vino, eped'u eichacua nime. Fariseo cuana sa jabuetsuati cuana mu emeji, ejud'uji edhi nime. Beju aimue huamahuama ehuaruti mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pia janahua tsine Jesús, mesa discípulo cuana neje d'ije duje ejaitianasa je, discípulo cuana ja eju cuana raridujudujuatana, dhemanu putsu. Ejaja iruiruatana huecuana edia puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fariseo cuana ja daja ba putsu, discípulo cuana tuaquisatana huecuana. Uja Jesús atana huecuana: —Chamaque, mique discípulo cuana janahua tsine su emudumudutani. Daja a taji mahue janahua tsine su, jacuatsasiati cuana daja epuani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Da su Jesús ja uja quisabatana huecuana: —¿Aimue jia maida micuaneda mimiameana mahue cuaja David chenu ja ataidha mesa ebuqueji cuana neje, dhemanutaidha huecuana su? ");
INSERT INTO tnaNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiatar sacerdote cuana sa echua puji aida puidha tiempo su, tueda nubidha Diusu sa templo su pan iyuda edia puji. Ebuqueji cuana pan iyuda tiataidha padiata huecuana puji. Beju tueda pan iyuda mu sacerdote sa bahui dia taji puidha. ");
INSERT INTO tnaNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Daja huecha Diusu ja janahua tsine ichataidha cristiano cuana sa puji, tuna ejanahuata puji. Da puji bahui Diusu ja janahua tsine ichataidha. Beju daja biame, cristiano cuana ja ai saida cuana ata cua janahua tsine su. ");
INSERT INTO tnaNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ema da Diusu sa Jabeituti Deja. Ema da janahua tsine emetse putsu, yama bahui cristiano cuana ebame ahua ai a taji, ahua ai a taji mahue janahua tsine su. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Neicha Jesús nubiana jadhitati jude ete su. Dapia piada deja mechehui anina. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Piada piada dapia Jesús cuadhiji cuana netitaina ahua Jesús ja janahua tsine su deja esaisiameta ahua mahue eba puji. Ahua daja Jesús ja deja esaisiameta su, da su tuneda Jesús etuaquisata. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Daja mecuana sa piba puana biame, Jesús ja deja mechehui uja cuatsasiatana: —Pueque upia. Netianaque ecuanaju duju su. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Da su Jesús ja dapia yanita ebaji cuana uja quisabatana: —¿Ai ni da su saida ya puji janahua tsine su? ¿Ahua saida janahua tsine su ai saida cuana ya puji? ¿Ahua ai madhada cuana ya puji? ¿Ahua saida janahua tsine su quebata d'eji su ya puji? ¿Ahua pamanu ja puji? Mepibaenique. ¿Ai ni saida ya puji janahua tsine su? Beju pamapa dapia yanita cuana mitanatana. Cuaja jeutsu taji mahue batana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesús ja chamapebarereatana huecuana pibapiba, duinini neje, tuna sa muesumu cuana tadada ba putsu. Da su Jesús ja deja mechehui cuatsasiatana: —Piraraque mique ebai. Beju deja ja mesa ebai piraratana. Mesa eme beju saida puibana. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Fariseo cuana beju daja ba putsu, tipeida cuinanatana. Echua puji Herodes sa deja cuana neje jadhitatitana huecuana. Tuneda cama cuaja Jesús emanuame puji jaquisatitana. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Da su beju Jesús bai su putiana mesa discípulo cuana neje. Dueji cristiano cuana tu tije putitana. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Galilea, Judea, Idumea yahua, Jerusalén ejude000netia puetana huecuana. Jordán ena chu bene, ejude detse banime Tiro, Sidón jenetia di puetana huecuana. Jesús ja ai nimetiuda cuana yatani shanapatana huecuana su, tu peje su puetana eba puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Cristiano cuana dueji putsu, Jesús ja mesa discípulo cuana cuatsasiatana canoa paduseta huecuana dapia enubi puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jesús ja jucuada cristiano cuana saisiametana putsu, pamapa nedaji cuana jadhitatitana tu peje su. Janunununuati huecuana Jesús ed'apaba puji. Da putsu, Jesús canoa su nubiana. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Einid'u madhadaji cuana ja di Jesús chamatana su, tipeida tu butse su sanatana huecuana. Uja tsiatsiatana huecuana: —Mida da Diusu sa Ebacua. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Da su Jesús ja einid'u madhada cuana jubida cuatsasiatana uja: —Be daja cristiano cuana quisaji. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Da su beju Jesús putiana murucu aida su. Tsua putsu, mesa dharejiji deja cuana ihuatana tu peje su. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Beju piada tunca beta ejaitiana deja cuana dharetana. Huaratiatana huecuana tu ebuqueta huecuana puji, mesa quisa saida cuana quisaquisa paputita puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Tucheda tiatana huecuana einid'u madhada cuana cristiano cuana peje jenetia ejusiacuina puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Uja banimeta huecuana: Simón. Jesús ja tueda Pedro ebani tiatana. Jacobo. Juan sa edue. Tata Zebedeo sa ebacua. Juan. Jacobo sa edue. Tata Zebedeo sa ebacua. Jesús ja tuatseda Tiri esitu ebani tiatana. Andrés. Felipe. Bartolomé. Mateo. Tomás. Jacobo. Alfeo sa ebacua. Tadeo. Simón. Tueda da cananista partido jenetia. Judas Iscariote. Tueda da Jesús menajatiaji. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Da su beju Jesús pia ete su putiana ediadia puji. Neicha beju cristiano cuana dueji jadhitatitana. Da putsu, Jesús, mesa discípulo cuana neje cuaja diadia taji mahue jabatiana. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mesa edue cuana ja shanapa putsu, putitana huecuana tu yani su da jenetia mecuana sa ete su Jesús edusu puji. Daja dusuja adhaatana huecuana, “Jesús beju chuataitanajiji”, cristiano cuana eputani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Beju jacuatsasiati ebuetsuaji cuana Jerusalén ejude jenetia dapia anitaina. Tuneda di Jesús madhabatana. Uja atana huecuana: —Ye Jesús da Ishahuaji. Pamapa mesa ai nimetiuda yatani cuana beju Ishahua sa tucheda neje yatani. Einid'u madhada cuana ejusiacuinatani Ishahua sa tucheda neje. Daja Jesús madhabataina huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Da su Jesús ja tu naja su ihuatana huecuana. Bahue quisa cuana neje quisapirutana huecuana uja: —¿Ai Ishahua tu mehua jajusiacuinati cua bata? ");
INSERT INTO tnaNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ahua quebata huaraji aida sa cristiano cuana esajasajata su, ahua tuneda cama eichetita su, beju tueda huaraji aida sa tucheda etaitanapeyu. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Daja huecha quebata familia edue cama eichetita su, tueda familia da etaitanape. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Daja huecha ahua Ishahua ja quitaita mesa einid'u madhada cuana jusiata cua su, mesa tucheda etaitanape. Aimue mesa einid'u madhada quitaita ejusiata mahue. Ahua daja yata su, tueda quitaita emajaitiani pu cua nime. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","‘Daja huecha aidhe deja tucheda sa ete su nubija tsi epu puji, equene deja tucheda risi taji. Deja risi putsu, da su etse tsi pu cua. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","‘Meid'abaenique. Yama micuana jubida equisainia, ai jucha papu biame cristiano cuana ja yatani, Diusu ja perdonata cua. Tu neje madhada hue emimitani cuana perdonata cua. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Daja biame, quebata Espíritu Santo neje madhada hue emimi su, tueda aimue Diusu ja eperdonata mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Tuneda da, “Jesús da Ishahuaji”, putana putsu, Jesús ja daja jubida quisatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Da su beju Jesús sa cuara, edue cuana cuinatana. Ete etsequeini su netisenatana huecuana. Jesús ete etsequeini su pacuinana puji quisametana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Beju cristiano cuana Jesús pehue je ete dume su anitaina. Uja Jesús quisatana huecuana: —Mique cuara, edue cuana etsequeini su enetita. Beju echacutani huecuana mi. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Da su Jesús ja quisatana huecuana uja: —Yama micuana equisa aidhe quema cuara, edue cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Mesa discípulo cuana mehuitu putsu, uja quisatana huecuana: —Ye cuana da quema cuara, edue cuana pu cua nime. ");
INSERT INTO tnaNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Quebata cuana ja Diusu sa tsada ai cuana yatani, tuneda da quema cuara edue cuana pu cua nime. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Neicha Jesús ja cristiano cuana buetsuapirutana bai maje su. Tu peje su dueji cristiano cuana jadhitapirutitana putsu, canoa aida su nubiana. Dapia canoa dume su aniuteana. Cristiano cuana bai maje su anititana. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Da su Jesús ja bahue quisa cuana neje buetsuapirutana huecuana uja: ");
INSERT INTO tnaNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Meid'abaque ema. Piada deja putiana ejaja cuana ehuararati puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ehuararatani cama, piada piada ejaja cuana edid'i je dajajatana. D'ia janana cuana pue putsu, pamapa ejaja cuana diapetana. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Pia ejaja cuana tumuji med'i pamuda mahue su dajajatana. Beju tipeida huid'atana. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Med i pamuda mahue putsu, beju saratana huid'atana cuana, id'eti sinada puana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Pia ejaja cuana junu aquid'aji cuana duju su dajajatana. Beju murutana cuana junu quid'aji cuana ja manuametana, babubabuatana putsu. Jaja mahue putana. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pia ejaja cuana mu med'i saida su dajajatana. Saida murutana. Dueji ejaja putana. Piada piada equi cuana da quimisha tunca ejaja putana. Pia cuana sucuta tunca ejaja putana. Pia cuana cien ejaja putana. Daja jajucuatitana ejaja cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Daja Jesús ja buetsuapetana huecuana. Buetsuape putsu, uja quisatana huecuana: —Ahua quebata id'ajararaji su, meid'abaque. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Da su cristiano cuana putitaibana su, Jesús sa piada tunca beta ejaitiana discípulo cuana ja Jesús nariatana pia eid'abaji cuana neje. Uja quisabatana huecuana: —¿Cuaja jia da tueda bahue quisa cuana epuani? ");
INSERT INTO tnaNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Da su Jesús ja jeutsutana huecuana uja: —Diusu ja micuaneda bahui tu ecuatsasiati etsia ai quisa cuana eshanapametani. Aimue pia cuana mu eshanapametani mahue. Diusu ja mesa ai cuana bahue quisa neje bahui ebuetsuatani. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Daja Diusu ja yatani huecuana, tuneda ebatani biame, mue ba a cua nime. Eid'abatani huecuana biame, mue shanapa a cua nime. Daja Diusu ja yatani huecuana papibaturucatita huecuana mahue puji, tuahueda paperdonata huecuana mahue puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Da su Jesús ja quisabatana huecuana: —¿Ahua micuaneda ye bahue quisa mue shanapa su, cuaja jia micuaneda pia bahue quisa cuana shanapame a cua? ");
INSERT INTO tnaNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tueda deja ja Diusu sa mimi ehuararatani nime. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Piada piada ejaja cuana edid'i su dajajatana. Daja nime da Diusu sa quisa eid'abatani cuana. Id'aba putsu, aimue eshanapatani huecuana mahue. Beju Ishahua pua putsu, tueda Diusu sa quisa cuana mecuana sa muesumu su yani emejemitani. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Beju pia ejaja cuana dajajatana tumu med'i pamuda mahue su. Daja nime da pia Diusu sa quisa eid'abatani cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tipeida, beidaji neje tueda quisa cuana eid'abatani huecuana. Quejucua tsine hue saida eputani huecuana. Beju ema jepuiti mecuana sa sufri pu taji su, neicha hue equene su puina nime eputaniyu. Da su cuaja d'au pamuda ehuid'atatani cuana emanutani nime, daja tuneda quema quisa saida cuana jenetia enetideratani sufrimiento cuana jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Beju pia ejaja cuana dajajatana junu quid'aji cuana duju su. Daja nime da pia Diusu sa quisa eid'abatani cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Diusu sa quisa cuana eid'abatani huecuana biame, ye mundo sa madhada ai cuana ebia su tsada ebatani huecuana. Chipilu di ebia su tsada ebatani huecuana. Tuneda quitaita ebaseatitani, tueda ai cuana ema ebia sa tsada ba putsu. Cuaja junu quid'aji cuana ja saida emurutani cuana etaitanamepetani nime, daja da je mundo sa ai madhada tueda quema quisa eid'abatani cuana emadhatiatani. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Beju pia ejaja cuana mu dajajatana med'i saida su. Daja nime da pia Diusu sa quisa eid'abatani cuana. Butsepi eshanapatani huecuana. Cuaja med'i saida su ejaja cuana ebia su ejucuatitani nime, daja Diusu sa puji ebia su ai mudu saida cuana yatani huecuana. Ejaja jajucuatitana nime da huecuana. Piada piada cien ejaja putana. Pia sucuta tunca ejaja tunca. Pia quimisha tunca ejaja putana. Daja da mecuana sa Diusu sa puji mudu saida cuana ejucuatitani. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Da su Jesús ja quisabatana huecuana: —¿Ai micuaneda hueda d'iti ducu neje ebiad'utua bata? ¿Ai micuaneda hueda huaracha ema su eicha bata? ¿Aimue jia maida etse huaracha bia su hueda enetiainia mahue? ");
INSERT INTO tnaNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Pamapa ai rubuajiji cuana batasaida epu. Pamapa ai rubuajiji etsia piba cuana Diusu ja cristiano cuana eshanapameta. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ahua quebata id'ajararaji su, beju paid'abata quema quisa cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesús ja daja hue quisainiame atana huecuana: —Saida meid'abaque. Cuaja micuaneda pia cuana ejuzgainia nime, daja ebia su Diusu ja micuana ejuzgata. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Quebata ja Diusu sa piba shanapaja su, Diusu ja mesa piba cuana ebia su eshanapameenitayu. Quebata ja aimue shanapaja mahue su, Diusu ja tueda aimue ai biame eshanapameta mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Neicha hue Jesús ja quisatana huecuana: —Uja nime da Diusu ecuatsasiati. Deja ja ejaja cuana te su huararatana. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Deja etahuiani, enetianani cama, ejaja cuana ehuid'atapirutani. ¿Cuaja jia da ejaja cuana murume eputani? Deja bue mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Med'i jenetia da huid'ata putsu, ecuinanapirutani. Da tije mesa equi ecuinanani. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Equi tije da mesa eju. Esara su beju, deja ja tipeida eraritani, mesa tiempo cuinana putsu. Daja da Diusu sa mimi cristiano cuana duju su jajucuatime epuani. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesús ja daja hue quisainiame atana huecuana uja: —¿Ai nime jia da Diusu ecuatsasiati? ¿Ai bahue quisa cuana neje jia yama micuana quisa cua, micuana ebuetsua puji? ");
INSERT INTO tnaNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Diusu ecuatsasiati da mostaza ejaja chidi nime. Tueda ejaja da pamapa pia ejaja cuana ebia su huai chidi biame, bana putsu, beju pamapa pia equi chidi cuana ebia su aida emuruani. Echa aida cuana sa tanana su d'ia janana cuana ejanahuatani. Daja da Diusu ecuatsasiati epupiruani mostaza ejaja nime. Da su beju aida epuani. Equene quejucua chidi cristiano cuana tu peje su jei eputani biame, da su beju pamapa ejude su aniji cuana jei eputayu. Daja Jesús ja buetsuatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Tueda bahue quisa cuana neje Jesús ja cristiano cuana buetsuatana. Diusu sa mimi buetsuatana huecuana bahue quisa cuana neje. Cristiano cuana que tupu tuna eshanapata teje Jesús ja buetsuatana huecuana. Bahue quisa cuana neje bahui buetsuatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Mesa discípulo cuana mu cristiano cuana aimue su tusa quisa cuana id'abata saida mimi cuana neje shanapametana. Aimue bahue quisa neje bahui buetsuatana huecuana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Beju dhidha puana su, Jesús ja discípulo cuana uja atana: —Meanipetutija chu maje. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Da su cristiano cuana ichajusia putsu, Jesús mesa discípulo cuana neje canoa dume su nubiana. Pia canoa cuana dapia saina. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tuna yanipetusa cama, beni ebia su jubida pupiruana. Ena putsuapiruana beju. Canoa dume su nubipiruana. Ena enubiani putsu, canoa sejepiruana. Beju nubicueana. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesús mu tahuisaina canoa tiani su. Mesa echua beju echua pahuaji bia su saina. Da su discípulo cuana ja tueda id'edeatana. Jubida Jesús quisatana huecuana: —¡Echua Puji, canoa enubiani beju! Ahua ecuaneda huidi cua su, ¿aimue jia mique ai biame piba yani mahue? ");
INSERT INTO tnaNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Beju Jesús id'ecuina putsu, beni d'ayatana. Bai cuatsasiatana uja: —¡Mitanaque! Da hora su beni netitiana. Bai mitanana. Pamapa beju mitanasaisiana. ");
INSERT INTO tnaNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Da su Jesús ja quisabatana huecuana: —¿Cuaja su micuaneda iyuame epuani? ¿Aimue jia maida micuaneda Diusu peje su enimetucheatiani mahue? ");
INSERT INTO tnaNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tuneda beju ebia su rubutanatana putsu, jaquisatitana huecuana uja: —¿Ai deja jia ye? Beni ja biame tueda eid'abatani. Bai ja di tusa jacuatsasiati eiyubatani. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Da su beju bai chu maje satsuatana huecuana. Tueda yahua da banime Gadara. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesús canoa jenetia cuinanana cama, piada deja ja tsutana. Tueda deja panteo jenetia cuinanana. Tueda einid'u madhadaji puina. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Sepulcro cuana duju su anina. Aimue aiya biame tueda cuaja risi taji mahue batana. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Quejucua nuati biame beju mesa ebai detse cadena neje risitaina huecuana. Mesa ehuatsi detse di piama sepo su tamitaina huecuana. Beju tuahueda cadena tibitaina. Piama sepo beju ped'uped'uataina. Mue aidhe biame anina mahue tu nime tuchedame tu emitaname puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tsine, dhidha tueda jubida jejeina. Panteo, emata cuana su jubida jejeina. Tu mehua tumu neje equita jasiquiti bahue puina. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Beju Jesús uqueda jenetia batana putsu, Jesús peje su jududutiana. Jesús butse su sanana. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Da su einid'u madhada ja tsiatsiana uja: —Mida da Diusu sa Ebacua. ¿Ai mique ema neje yani? Be ema castigo su beituji, yama mi Diusu sa ebani neje jubida ebajainia. Daja einid'u madhada ja Jesús atana, Jesús ja tueda, “Mesiaque ye deja”, atana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Da su Jesús ja einid'u madhada quisabatana uja: —¿Ai ni mi banime? Tuahueda jeutsutana: —Quema ebani da Legión, ecuanaju dueji putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Da su tuahueda Jesús jubida bajatana: —Be beituji ecuanaju ye yahua jenetia. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Chuadera beju jucuada cuchi cuana anitaina. Tueda cuchi cuana diadianiunetitaina murucu bia su. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Da su einid'u madhada cuana ja jubida bajatana Jesús: —Beituque ecuanaju cuchi cuana su. D'eji tiaque ecuanaju cuchi cuana sa equita dume su enubi puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Da su beju Jesús ja einid'u madhada cuana d'eji tiatana su, cuinanatana huecuana deja peje jenetia. Beju nubitana huecuana cuchi cuana sa equita dume su. Tueda cuchi cuana beta mil pucue putaina. Da su cuchi cuana jududutana. Bai equehuehueji butsepi je dajajautetana. Pamapa nubitana bai su. Beju huidipetana cuchi cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Da su cuchi quinaji cuana jududutana ejude, te cuana je aniji cristiano cuana equisati puji. Pamapa cuaja ai puana quisatana huecuana. Beju cristiano cuana ja tueda ai cuana id'abatana su, putitana huecuana eba puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesús yani su cuinati putsu, deja einid'u madhadaji puina yani batana huecuana. Tueda saida, jajud'uti yani batana huecuana. Mesa piba beju butsepi puina. Einid'u madhadaji mahue beju batana huecuana. Daja ba putsu, rubutanatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Beju tueda ai cuana baji cuana ja quisatana huecuana pamapa ai cuaja Jesús ja atana. Deja einid'u madhadaji, cuchi cuana jepuiti beju quisatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Da su ejude, te cuana jenetia cuana ja jubida Jesús bajapirutana tuna sa yahua jenetia papuenitiyu puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Da su beju Jesús canoa dume su enubiani cama, deja saisijiji ja uja bajatana Jesús: —Dusuque ema. Mi neje putija ema. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Beju Jesús sa tsada mahue puana. Cuatsasiatana deja uja: —Putiyuque mique ete su, mique edue cuana peje su. Quisatiyuque cuaja yama miqueda puji aitia. Cuaja mi yama ibunebame aitia mique edue cuana quisatiyuque. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Da putsu beju, deja putibana. Tueda yahua su aniji cuana quisapirutana beju. Dapia tueda yahua su piada tunca ejude cuana anina. Pamapa tueda ejude cuana je cuaja Echua Puji Jesucristo ja tuseda puji atana quisa pupiruana. Da su cristiano cuana id'aba putsu, nimetiunetitana huecuana beju. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesús beju bai u maje jasiapatibana canoa su. Tu esatsuani cama, dueji cristiano cuana ja tu peje su jadhitatitana. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Piada deja ja Jesús nariatana dapia bai maje su. Tueda da Jairo banime puina. Tueda da echua puji puina judío cuana sa jadhitati jude ete su. Tuahueda Jesús ba putsu, tu butse su turusatiana. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Jubida Jesús bajatana uja: —Quema ebaquepuna chidi emanu piba esa beju. Pueque. Ichatique mique eme tu bia su pasaisi puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Da su Jesús tu neje putiana ebaquepuna nedaji butse esa su. Dueji cristiano cuana di tu neje putitana. Jesús naja je janunununuati putitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Beju tuna duju su piada epuna nedaji puniunetina. Tueda epuna sa piada tunca beta ejaitiana mara mesa ami riji puja mahue puana. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Jucuada jaiduenetiji cuana ja ebia su hue ametana. Epuna ja pamapa mesa chipilu neje esaisi puji chujetiadhaatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Cha ebia su hue puana. Tuahueda Jesús ja ai atana cuana shanapataina putsu, uja japibatiana: “Ahua mesa ejud'uji dhucuana yama d'apaba cua su, saisi cua ema.” Da su Jesús etibeini bene nariatana. Tusa ejud'uji d'apabatana. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Da hora su mesa ami riji puana. Epuna jajinebatiana mesa equita beju saida. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Epuna ja ejud'uji d'apabatana su, Jesús aidhe saisitia tu d'apaba putsu, jajinebatiana. Da putsu, jababarereatiana cristiano cuana duju su. Uja quisabatana huecuana: —¿Aiya da quema ejud'uji d'apabataitia? ");
INSERT INTO tnaNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Da su mesa discípulo cuana ja jeutsutana: —Beju miada ebainia, jucuada ja mi ed'apabatani. ¿Jucuaja su mida daja equisabatiani? ");
INSERT INTO tnaNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesús jababarereatiana aiya tu d'apabatana eba puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Jesús ja ebatani ba putsu, epuna riariapiruana. Ebia su iyuame puana. Da su epuna ja Jesús naria putsu, tu butse su turusatiana. Uja atana Jesús: —Yama mida d'apabaitia. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Da su Jesús ja epuna quisatana: —Epuna chidi, ema peje su mi jei puitia putsu, beju mi saisitia. Puchiditiyuque. Ye neda ja aimue mi yata mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Daja Jesús emimiani cama, piada piada cristiano cuana Jairo sa ete jenetia cuinanatana. Uja quisatana huecuana Jairo: —Mique ebaquepuna beju manuitia. ¿Ai puji detse Echua Puji yanacane puti cua? ");
INSERT INTO tnaNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesús eid'abainia mue bid'u puana. Uja Jairo atana: —Be iyuame puji. Ema peje su bahui janimetucheatique su, mique ebaquepuna esaisi. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Da su quimisha discípulo cuana bahui dusutana Jairo sa ete su. Pedro, Juan, Jacobo dusutana. Juan da Jacobo sa d'au puina. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairo sa ete su cuinati putsu, Jesús ja jucuada cristiano cuana enetita batana. Jubida japadarititanina huecuana batana. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesús ete su nubi putsu, quisabatana huecuana uja: —¿Cuaja su da micuaneda daja epadaritiani? Epuneje mu aimue emanu mahue. Tueda mu etahuisa hue. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Daja Jesús emimiani su, id'ebatana huecuana. Da su Jesús ja jusiacuinatana huecuana etseque su. Jusiacuina putsu, epuneje esa su nubiana. Epuneje sa tata, cuara tu neje nubiana. Quimisha discípulo cuana di nubitana. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Da su Jesús ja epuneje sa eme ina putsu, uja atana: —Epuneje chidi, yama mi netianaque yainia. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Da hora su beju epuneje netianana. Beju asepiruana. Tueda da piada tunca beta ejaitiana maraji puina. Pamapa echamatitaneti cuana ba putsu, ebia su nimetiunetitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesús ja jubida cuatsasiatana huecuana: —Be mequisaji aidhe biame ai cuaja puitia cuana. Memihuaque epuneje chidi. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Da su beju Jesús tueda ete jenetia putibana. Mesa ejude su jasiapatibana. Mesa discípulo cuana ja buquetana. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Beju janahua tsine putsu, Jesús jadhitati jude ete su putiana. Dapia buetsuapirutana cristiano cuana. Tuneda Jesús sa quisa cuana id'aba putsu, nimetiunetitana huecuana. Jaquisabatitana huecuana uja: —¿Que jenetia jia da ye deja tueda ai cuana jabuetsuatiana? ¿Aiya jia da tueda tueda ai cuana buetsuatana? ¿Cuaja tueda ai nimetiuda cuana jabuetsuatime puana? ");
INSERT INTO tnaNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Aimue jia maida tueda carpintero mahue? ¿Aimue jia maida tueda María sa ebacua mahue? ¿Aimue jia maida tusa d'au cuana da Jacobo, José, Juda, Simón eputani mahue? ¿Aimue jia maida mesa dudu cuana upia ejude su yanita mahue? Beju daja mimitana huecuana Jesús jepuiti. Aimue tu peje su jei puja mahue putana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Da su Jesús ja atana huecuana uja: —Diusu sa profeta sa ejude quitaita su aniji cristiano cuana ja aimue tueda saida ebatani mahue. Mesa familia quitaita cuana ja di aimue tueda saida ebatani mahue. Pia ejude su aniji cuana ja bahui profeta saida ebatani. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tu peje su jei puja mahue putana putsu, Jesús ja dapia mesa ejude su aimue nimetiuda ai cuana cuaja a taji mahue batana. Ucua chidi hue nedaji saisiametana, eme detse tuna bia su huana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesús ja nimetiubatana huecuana, tu peje su jei puja mahue eputani ba putsu. Da putsu, pamapa pia ejude nari cuana je bahui quisaquisa puniunetiana. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Da su beju Jesús ja mesa piada tunca beta ejaitiana discípulo cuana ihuatana tu peje su. Beta beta beitutana huecuana. Huaratiatana huecuana einid'u madhada cuana cristiano cuana peje jenetia pajusiacuinata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Jubida quisatana huecuana uja: —Pamapa su medusutique piada huara bahui yase puji. Be medusutiji pan, maricu, chipilu cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Pulucu meichatique. Piada ejud'uji cama bahui medusutique. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","‘Ahua quebata ete su micuana enubiti su, dapia bahui meanique, ejude su yani tupu. Tueda ete su bahui micuana sa ani taji ejude jenetia ecuinana teje. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ahua quebata ejude su aniji cristiano cuana ja aimue micuana saida ebatsuta mahue su, tueda ejude jenetia mecuinanaque. Cuinana putsu, metaraque tueda ejude sa med'i micuana sa pulucu jenetia Diusu tuna neje eduininiani pashanapata huecuana puji. Beju Diusu ja tuneda Sodoma, Gomorra ejude detse su aniji cuana ebia su ecastigatayu, castigo tsine epue su. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Da su putitana huecuana. Quisaquisa pupirutana huecuana cristiano cuana Diusu peje su papibaturucatita puji, jucha cuana paichaderata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Discípulo cuana ja jucuada einid'u madhada cuana cristiano cuana peje jenetia jusiacuinatana. Jucuada nedaji cuana saisiametana huecuana. Aceite neje echua su papi putsu, nedaji cuana saisiametana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Da tiempo su pamapa cristiano cuana ja Jesús shanapatana. Tu jepuiti mimitana huecuana. Beju echua puji Herodes Antipas ja Jesús jepuiti cristiano cuana emimitani id'abatana. Piada piada cristiano cuana uja putaina: —Juan Bautista beju eid'e. Manujiji cuana duju jenetia netianaibana putsu, nimetiuda ai cuana yatani. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pia cuana mu uja putaina: —Tueda da profeta Elías. Pia cuana di uja putaina: —Tueda da Diusu sa profeta. Tueda da biahua tiempo profeta chenu cuana nime. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Beju Herodes Antipas ja tueda ai cuana id'aba putsu, uja puana: —Ye da Juan Bautista id'eyujiji. Yama tueda chuarijiana biame, jiahue eid'e beju. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Jiahue pad'i hue Herodes Antipas ja inametana Juan eteriichanubiame puji. Herodías sa tsada jepuiti, teriichanubiametana Juan. Herodes Antipas sa edue Felipe banime puina. Herodías da Felipe sa ehuane puina. Jiahue mu beju mahue. Echua puji Herodes Antipas tu neje jahuanetija puana putsu, Felipe peje jenetia mejemitana. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Da tiempo da Juan eid'e hue puina putsu, uja quisatana Herodes Antipas: —Be Herodías mique ehuane nime dusuji, mesa yahue Felipe eid'e tupu. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Da putsu, Herodías ja Juan dujubatana. Manuameja atana Juan. Daja biame, cuaja manuame taji mahue batana. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Juan da Diusu sa deja butsepi putsu, Herodes Antipas ja tueda iyubatana. Da putsu, manuameja mahue atana Juan. Juan quisaquisa puina su, Herodes Antipas ja id'abataina. Juan ja quisaquisa neje Herodes Antipas ebia su pibapibametaina. Daja biame, Herodes Antipas sa tsada puina Juan eid'aba puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Beju Herodes Antipas sa ebani tsine cuinana su, mesa eshanapa chipiluji, soldado sa echua puji, huaraji aida cuana Galilea yahua jenetia ihuatana. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Da su beju Herodías sa ebaquepuna pamapa ihuajiji cuana butse su tiritiriana. Tu mehua tiritiri putsu, pamapa ihuajiji cuana beidaji ametana. Da putsu, echua puji Herodes Antipas ja epuneje uja atana: —Bajaque ema ai papu mique tsada epuani. Beju yama mi etia. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Diusu bahue pu putsu, epuneje uja atana: —Miada ai ema ebajainia yama mi etia. Quema yahua edusete teje mi etia. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Da su epuneje cuinana putsu, mesa cuara peje su tipeida putiana uja equisaba puji: —¿Ai ni da yama baja cua? Da su beju Herodías ja pibatana cuaja emanuame Juan puji. Uja jeutsutana epuneje: —Juan Bautista sa echua bajatique. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Da su epuneje echua puji Herodes Antipas peje su tipeida jasiapatiana. Uja atana beju: —Jiahue quita hue tiaque ema Juan Bautista sa echua, dhepe su icha putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Da su echua puji Herodes Antipas ebia su jatacuamadhatiana. Ihuajiji cuana butse su Diusu bahue puana putsu, tia taji mesa puana. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Da hora su Herodes Antipas ja piada soldado ihuatana. Juan peje su beitutana tusa echua eduseta puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Soldado Juan peje su cuinati putsu, chuarijitana Juan. Daja a putsu, dusutana echua dhepe su. Epuneje menajatiatana. Inatsu putsu, epuneje ja echua mesa cuara tiaderatana. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Juan sa discípulo cuana id'aba putsu, beju putitana Herodes Antipas peje su Juan sa equita ebajati puji. Da su tusa equita dusu putsu, papatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Da su beju discípulo cuana jasiapatibana Jesús peje su. Cuaja ai buetsuatana, ai atana cuana Jesús quisatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Da putsu, Jesús ja discípulo cuana uja atana: —Meputija cristiano cuana yani mahue su huai chidi cama ejanahua puji. Jucuada cristiano cuana siapati eputani putsu, aimue mecuana sa d'eji ediadia puji biame. Da su aidhe cuana mue ani su putitana huecuana tuna mehua yani puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Canoa aida su nubi putsu, pudhaatitana huecuana cristiano cuana mue ani su. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Cristiano cuana ja tuna eputahu beju batana putsu, Jesús shanapaenitana huecuana. Pamapa ejude cuana jenetia cristiano cuana jududutana quepia Jesús epuhu eti jude su. Beju equene cuinatitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesús ja canoa jenetia cuinana putsu, dueji cristiano cuana tu id'ua eputani batana. Jesús ja bataichenu batana huecuana, huisha cuana equinaji mahue nime huecuana putsu. Da su buetsuapirutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Beju tsinecua su, mesa discípulo cuana ja nariatana. Uja Jesús quisatana huecuana: —Beju da tsinecua. Aimue ete cuana u je. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Beituque ye cristiano cuana pia ejude, te cuana je, ai chidi papu biame pachacutita huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Da su Jesús ja uja jeutsutana huecuana: —Micuaneda hue memihuaque huecuana. Da su uja Jesús quisabatana huecuana: —¿Ai ecuanaju pamapa sa puji beta cien tsine mudu echuje neje pan tupu baja cua bata? ");
INSERT INTO tnaNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Da su Jesús ja quisabatana huecuana: —¿Quejucua pan chidi cuana micuana sa yani? Mebatique. Da su putitana huecuana eba puji. Beju jasiapati putsu, Jesús quisatana huecuana: —Pishica pan chidi cuana, beta se chidi detse bahui yani beju. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Da su Jesús ja cuatsasiatana discípulo cuana ja cristiano cuana dujiduji nutsa bia su paaniutemeta puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Da su beju dujiduji aniutetana huecuana pamapa. Pia cuana cien putana, pia cuana pishica tunca putana. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesús ja pan cuana, se detse chidi ina putsu, buepa huabata jachamatiana. Diusulupai Diusu atana. Diusulupai ape putsu, pan cuana, se detse chidi ped'uped'uatana. Mesa discípulo cuana menajatiatana cristiano cuana paberereatiata huecuana puji. Discípulo cuana ja cristiano cuana eberebereatiatani cama, pan, se ped'u cuana jajucuatitana. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Pamapa cristiano cuana beju diadiatana tupu. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Beju pan, se puchu puana. Da su eped'u cuana chudutana huecuana. Piada tunca beta ejaitiana d'iti cuana sejeatana huecuana puchu cuana neje. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Beju diadiatana cuana da pishica mil deja putaina. Jucuada epuna, yanana cuana di diadiatana tupu. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Da su beju Jesús ja mesa discípulo cuana nubiametana canoa aida su Betsaida ejude su paanipetutita huecuana puji, tu equene pacuinatita huecuana puji. Tuna yanipetutahu cama, Jesús ja cristiano cuana tuna sa ete cuana je beitupetaibana. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Beitupe putsu, Jesús murucu aida bia su tsuatiana Tata Diusu emitsu puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Beju apuda puana su, discípulo cuana canoa su bai dusete su anipetutasaina. Jesús mu tu mehua yahua su netina. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Da su Jesús ja batana huecuana canoa su yanita bai dusete su. Beni ja jubida dhapujutana putsu, discípulo cuana cuaja tarutarueni taji mahue, jad'uitijiji Jesús ja batana. Huenahua puana su, Jesús ja nariatana huecuana, bai bia je aseti putsu. Butsepi jaitiana epu puji pudhaana. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Discípulo cuana ja tueda ena bia je ejaitianasa ba putsu, ai enid'u pepe japibatitana huecuana. Beju seniame putsu, tsiatsiapirutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Da su Jesús ja jubida mitsutana huecuana uja: —Menimetucheatique. Ema hue da. Be iyuame mepuji. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Da su Jesús canoa su nubiana. Da hora su beni mitanana. Discípulo cuana ebia su nimetiutana. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Mue japibati huecuana cuaja Jesús ja pishica pan, beta se neje dajucua cristiano cuana tupu mihuatana su, tuna sa piba cuana tadada tsuhu putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Da su beju anipetu putsu, bai chu maje satsuatitana huecuana. Tueda yahua Genesaret banime puina. Dapia canoa aida risitana huecuana bai queque su. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Jesús canoa jenetia ecuinanasa cama, dapia yanita cuana ja tueda shanapatana. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Shanapa putsu, jududupirutana huecuana pamapa pia cuana equisati puji. Da su nedaji cuana chahui su dusutana huecuana Jesús peje su. ");
INSERT INTO tnaNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Quepia Jesús ejaitiana su dapia nedaji cuana huanatana huecuana. Quepia yahua d'eji chidi su beju dapia huanatana huecuana. Ahua ejude, te cuana su, que je Jesús putiana je, dapia nedaji cuana huanatana huecuana. Jesús jubida bajatana huecuana aji tusa ejud'uji tihue dhucuana pad'apabata huecuana puji. Da su quebata nedaji cuana ja tusa ejud'uji d'apabatana su, beju saisitana. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Beju fariseo, jacuatsasiati ebuetsuaji cuana Jerusalén ejude jenetia puetana Jesús peje su. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Discípulo cuana diadiataina jamerucuatiji mahue beju batana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Tuneda buetsuataina ediadia puji jamerucuati taji, daja da judío tata chenu cuana sa puiti puidha putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Fariseo cuana iruiru jude jenetia jasiapati putsu, equene erucuatitani huecuana ediadia puji. Jamerucuatiji mue su, aimue ediadiatani huecuana mahue. Beju jucuada mecuana sa ai puiti cuana anitaina. Emeji cuana rucuataina huecuana. Jutu cuana di rucuataina huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Da putsu, fariseo, jacuatsasiati ebuetsuaji cuana ja Jesús atana uja: —Mique discípulo cuana mu jamerucuati bue mahue ediadia puji. Cuaja ecuana sa tata chenu cuana sa puiti puidha nime, aimue yatani huecuana mahue. ¿Cuaja su jia daja eputani huecuana? ¿Cuaja su jia ediadiatani huecuana jamerucuatiji mahue? ");
INSERT INTO tnaNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Da su Jesús ja jeutsutana huecuana: —Micuaneda da bubeta cuana. Profeta Isaías chenu butsepi quisa puidha micuana jepuiti. Uja Tata Diusu ja tueda deremetaidha: Ye cristiano cuana ja ema eiyubatani mimi neje bahui. Aimue ema ene putsu tuna sa muesumu neje eiyubatani huecuana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","¿Ai puji saida tuna sa ema peje su jamitsutsuati cuana pu cua? Beju tueda da yanacane hue, tuna sa jabuetsuati quitaita cuana bahui ebuetsuatani huecuana. Aimue quema jabuetsuati cuana mu ebuetsuatani huecuana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Micuaneda Diusu sa jacuatsasiati cuana ichadera putsu, deja sa ai puiti cuana bahui yainia. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés chenu uja puidha: “Iyubaque mique tata detse. Ahua quebata papu mesa tata detse emadhabata su, tueda pamanu.” ");
INSERT INTO tnaNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Beju daja Moisés chenu buetsuataidha biame, micuaneda mu etsapiainia tusa jabuetsuati saida cuana. Uja micuaneda ebuetsuatani: “Quebata papu mesa chipilu Diusu etiata su, beju aimue mesa tata, cuara detse chipilu neje tsahua taji mahue, pamapa Diusu tiatana putsu.” ");
INSERT INTO tnaNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Daja micuaneda ebuetsuainia putsu, Diusu sa jacuatsasiati cuana etaitanameinia. Tueda jacuatsasiati cuana ai eni mahue nime micuaneda yameinia. Daja nime ebia su jucuada ai madhada cuana di micuaneda yainia. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Neicha Jesús ja cristiano cuana ihuatana. Uja quisapirutana huecuana: —Meid'abaque ema. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Meshanapaenique. Etse ediainia cuana ja aimue detse etse madhata cua mahue. Beju etse emimiani cuana ja mu ene putsu etse emadhatani. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Quebata idajararaji su, paidábata. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Da su beju Jesús ja cristiano cuana jusiaicha putsu, ete su nubiana discípulo cuana neje. Nubipe putsu, discípulo cuana ja Jesús quisabatana uja: —¿Cuaja epuani mique quisa cuana? ");
INSERT INTO tnaNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Da su Jesús ja jeutsutana huecuana: —¿A da micuaneda di pia cuana nime aimue eshanapainia mahue? Beju pamapa ediatani ai cuana ecuatsa je enubiani putsu, edhe su ecuinahu. Da su beju equita jenetia ecuinanani. Aimue detse tueda ai cuana ja deja madhata cua mahue. Jesús ja tueda quisa neje pamapa jana da saida buetsuatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Daja hue buetsuainiame atana huecuana uja: —Mimi madhada cuana ja mu ecuatsa jenetia ecuinanani putsu, deja emadhatani, muesumu jenetia ecuinanani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Pamapa ai madhada cuana cristiano cuana sa piba jenetia ecuinanani. Tueda piba madhada cuana ja cristiano cuana jucha yametani. Tueda piba madhada ja tsi puji, jamanuametiji, pia sa ebutse neje jaquinatiji, pia sa ai cuana utsatabaji, jabaseatiji, envidia puji, mimi aida, aida jabatiji, saida piba mahueji yametani huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Pamapa tueda madhada ai cuana cristiano cuana sa piba jenetia ecuinanani. Tueda ai cuana ja bahui juchaji yametani cristiano cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Da su beju Jesús tueda yahua jenetia putiana. Tiro, Sidón detse yahua naja su putiana. Dapia Jesús piada ete su nubiana. Tsada mahue mesa puana aiya pashanapata tu dapia yani. Uba hora quita chidi jarubutija pudhaana. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Piada epuna ja Jesús yani id'abatana. Mesa ebaquepuna chidi einid'u madhadaji puina. Epuna Jesús peje su pue putsu, tu butse su turusatiana. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Tueda epuna da judío mahue pia yahua jenetia puina. Beju epuna ja Jesús uja bajatana: —Jusiacuinaque einid'u madhada quema ebaquepuna peje jenetia. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Da su Jesús ja epuna uja jeutsutana: —Equene beju ebacua cuana padiadiata tupu. Saida mahue ebacua cuana sa jana mejemi putsu, uchi cuana etia puji. Ema equene pueana judío cuana emebaja puji. Beju judío cuana ja pamapa extranjero cuana uchi nime bame yatani. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Da su epuna ja jeutsutana uja: —Ehe, Echua Puji, mida ene putsu butsepi emimiani biame, uchi cuana ja di puchu cuana emetse sa misha jenetia yahua su edajajatani cuana ediatani. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesús ja epuna sa jajeutsuti id'aba putsu, uja jeutsutana: —Puchiditiyuque mique ete su. Miada ema saida jeutsuitia putsu, mique ebaquepuna beju saisitia. Einid'u madhada beju cuinanaitia tu peje jenetia. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Da su epuna mesa ete su putiyu putsu, ebaquepuna chidi tahui jude su einid'u madhadaji mahue beju batana. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús Tiro yahua jenetia putiana. Sidón yahua je jaitianana. Piada tunca ejude cuana je di jaitiana putsu, Galilea bai su cuinatiana. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Piada piada cuana ja deja jaid'abati bue mahue dusutana Jesús peje su. Tueda mimi bue mahue puina. Da su Jesús bajatana huecuana tusa eme deja nedaji bia su pahuanata puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Da su Jesús ja deja nedaji chuadera dusutana. Mesa emejatsa detse nedaji sa eid'aja detse su nubiametana. Da su emejatsa su equedi icha putsu, nedaji sa yana d'apabatana. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Buepa huabata jabatsuati putsu, Jesús janasiatiana. Uja quisatana deja: —¡Jatsequed'iatique! ");
INSERT INTO tnaNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Da hora su quitaita deja sa eid'aja detse jad'eatiana. Saida beju mimi bahue puibana. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Da su Jesús ja dapia aniji cristiano cuana cuatsasiatana be aidhe biame paquisata huecuana puji. Beju jucuada nuati daja jubida cuatsasiatana biame, ebia su quita, cuaja Jesús ja ai cuana atana quisa putana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Pamapa nimetiunetitana huecuana. Uja jaquisatitana huecuana: —Tuahueda pamapa ai cuana ebia su saida yatani. Jaid'abati bue mahue cuana biame eid'abametaniyu. Mimi bue mahue cuana di emimiametaniyu. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Neicha hue beju dueji cristiano cuana jadhitatitana. Ai ediaji mahue anitana huecuana. Da su Jesús ja mesa discípulo cuana ihuatana tu peje su. Uja quisatana huecuana: ");
INSERT INTO tnaNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Yama ye cristiano cuana bataichenuda ebainia. Beju quimisha tsine ema neje anitana huecuana. Jiahue aimue mecuana sa ai dia taji ani. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ahua yama tuna sa ete cuana su diadiaji mahue ebeitu huecuana su, nimetaitanata cua huecuana edid'i su, piada piada cuana uqueda jenetia puetana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Da su discípulo cuana ja uja atana Jesús: —Ecuaneda d'anita yahua su yani beju. ¿Ai ecuaneda dajucua cuatajuse cristiano cuana mihua cua bata? ");
INSERT INTO tnaNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Da su Jesús ja quisabatana huecuana: —¿Quejucua pan chidi micuana sa yani? Beju jeutsutana huecuana: —Siete pan chidi yani. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Da su Jesús ja cristiano cuana cuatsasiatana paaniuteta huecuana yahua bia su puji. Pan chidi cuana ina putsu, diusulupai Tata Diusu atana. Pan cuana ped'uped'ua putsu, discípulo cuana menajatiatan paberereatiata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tuneseda ucua chidi se cuana di anitaina. Jesús ja neicha diusulupai Tata Diusu a putsu, cuatsasiatana discípulo cuana se cuana paberereatiata huecuana puji. Discípulo cuana ja cristiano cuana eberereatiatani cama, pan, se ped'u cuana jajucuatitana. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Beju cristiano cuana diadiatana tupu. Siete d'iti d'ucu eped'u cuana neje sejeatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Diadiatana cristiano cuana da pushi mil pucue putaina. Da su beju Jesús ja tuna sa ete cuana su beitutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Canoa aida su nubiana mesa discípulo cuana neje. Beju putitana huecuana Dalmanuta yahua su. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tueda yahua su da fariseo cuana Jesús peje su puetana. Jubida neje jasatsiapirutitana Jesús neje. Uja bajatana huecuana: —Ai nimetiuda aque. Bameque ecuanaju, ahua ene Diusu mi neje yani su. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Daja Jesús atana huecuana tu yaba puji. Da su Jesús jubida janasiati putsu, uja puana: —Jiahue tiempo cristiano cuana ja daja hue bajainiame ema yatani ai nimetiuda cuana. Enei hue yama micuana equisainia, aimue yama ai nimetiuda cuana ya mahue ye cristiano cuana sa puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Da su Jesús ja fariseo cuana ichajusia putsu, canoa su nubiana. Bai chu maje putiana. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Beju discípulo cuana ja jana tupu edusu puji, setatana. Piada pan chidi bahui jadusutitana huecuana canoa su. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Da su Jesús ja uja quisatana huecuana: —Merejatique fariseo cuana, echua puji Herodes Antipas sa levadura neje. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Da su discípulo cama jaquisatitana: —Mue ecuaneda pan duse aitia putsu jia, Jesús daja epuani. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús shanapatana cuaja jaquisatitana huecuana. Uja quisabatana huecuana: —¿Cuaja su jia micuaneda cama daja equisatiani? ¿Jucuaja su micuaneda cuaja shanapa taji mahue ebainia? ");
INSERT INTO tnaNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Beju tuaji biame, aimue micuaneda ebainia mahue. Id'ajararaji biame, aimue eid'abainia mahue. ¿Jucuaja su micuaneda pan jepuiti emimiani? ¿Jucuaja su micuaneda epitsatiani, ecuana sa pan ehueitiani su? ");
INSERT INTO tnaNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Ai micuaneda mue piba bata yama pishica pan chidi neje pishica mil deja mihuana? ¿Quejucua d'iti cuana puchu cuana neje micuaneda sejeana? Da su jeutsutana huecuana: —Piada tunca beta ejaitiana d'iti cuana sejeana. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jesús ja daja hue quisabainiame atana huecuana: —Yama siete pan chidi cuana pushi mil cristiano cuana mihuana su, da tsunu, ¿quejucua d'iti cuana puchu cuana neje micuaneda sejeana? Da su jeutsutana huecuana: —Siete d'iti cuana ecuanaju sejeana. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jesús ja quisabatana huecuana uja: —Da su, ¿jucuaja su micuaneda daja japitsatime epuani, ecuanaju sa pan tupu mahue ba putsu? ¿Jucuaja su detse micuaneda mue shanapa tsuhu a cua? Beju aimue ema pan jepuiti mimitia mahue, micuana yama levadura jepuiti quisaitia su. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Da su cuinatana huecuana Betsaida ejude su. Dapia piada piada cristiano cuana ja deja padha Jesús peje su dusutana. Jubida bajatana huecuana Jesús ja deja padha pad'apabata puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesús ja deja padha sa eme ina putsu, ejude tsahua su huidusutana. Equedi neje papitana deja sa etuabeji su. Mesa eme detse di deja sa etua bia su huanatana. Daja a putsu, Jesús ja deja quisabatana: —¿A mi jabati cua? ");
INSERT INTO tnaNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Jachamati putsu, deja ja uja jeutsutana: —Cuaja jabaeniti taji mahue ema ebatiani. Yama cristiano cuana aqui nime eputaniuneti ebainia. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Neicha hue Jesús ja mesa eme detse deja sa etua bia su huanatana. Da su deja jubida jachamatiana. Beju saisi puana. Pamapa ai cuana saida batana beju. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesús ja deja tusa ete su beitu putsu, uja quisatana: —Butsepi mique ete su putiyuque. Be jasiapatiji ejude su. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Dapia yahua su beju piada ejude anina. Tueda ejude da echua puji Filipo sa ejude Cesarea banime. Tueda ejude tsahua je pia ejude huai chidi cuana anitaina. Dapia Jesús putiana mesa discípulo cuana neje. Tuneda yasetaneti cama, Jesús ja quisabatana huecuana: —¿Cuaja da cristiano cuana ema jepuiti eputani? ¿Aidhe da ema eputani huecuana? ");
INSERT INTO tnaNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Da su tuneda uja jeutsutana: —Piada piada mida da Juan Bautista id'eyujiji eputani. Pia cuana mida da Elías chenu eputani. Pia cuana mida pa pia Diusu sa profeta eputani. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Da su Jesús ja quisabatana huecuana: —¿Cuaja micuaneda quisa epuani? ¿Aidhe ni da ema? Pedro ja uja Jesús jeutsutana: —Mida da Cristo. Diusu sa Jabeituti Deja da mida. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Da su Jesús ja cuatsasiatana huecuana: —Be aidhe biame mequisaji. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yasetaneti cama, Jesús ja tu jepuiti uja buetsuapirutana huecuana: —Ema da Diusu sa Jabeituti Deja. Ebia su sufri quema pu taji. Tata edhi ehuidusuji cuana, sacerdote aida, jacuatsasiati ebuetsuaji cuana ema tsada mahue ebata. Ema da emanuameta huecuana. Beju quimisha tsine jenetia ema enetianayu. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesús ja saida, butsepi quisatana huecuana. Quisapetana huecuana su, Pedro ja Jesús chuadera dusu putsu. Jesús d'ayapirutana. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Da su Jesús jababarereati putsu, chamatana huecuana. Pedro uja d'ayatana: —Ishahua, netideraque ema naja jenetia, aimue mi Diusu sa piba cuana mu emimiani mahue. Deja cuana sa piba bahui mi emimiani. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","35","Da su beju Jesús ja mesa discípulo, Cristiano cuana ihuatana tu peje su. Uja quisapirutana huecuana: —Quebata ja ema tije aja su, pamapa muesumu neje ema tije paata. Ema pamapamesa ai cuana quitaita ebia su tsada pabata. Ema tije paata, manuameja paata biame. ");
INSERT INTO tnaNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Ai puji ni da etse pamapa mundo sa chipilu cuana gana pu cua, etse cuati castigo su eputi biame? ");
INSERT INTO tnaNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Ai etse d'eji su epu puji chujetia cua bata? ");
INSERT INTO tnaNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Quebata da cristiano juchaji cuana butse su ema jepuiti, quema quisa cuana jepuiti di ebidhu su, ya di tu jepuiti ebidhu, ema neicha esiapati su. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús ja daja hue quisainiame atana huecuana: —Ene putsu, yama butsepi micuana equisainia, hue enetita piada piada cuana aimue emanuta tsuhu mahue Diusu ecuatsasiati tucheda ecuina ebayu teje. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Beju sucuta tsine jaitianajiji su, Jesús ja Pedro, Jacobo, Juan cuana dusutana murucu aida bia su dapia chujemame paanita huecuana puji. Jesús tuna butse su japiatiana. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Mesa ejud'uji cuarecuare pasapasa puana. Aimue quebata d'acuad'acuaji ja biame, daja pasada ata cua mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Da su Elías, Moisés chenu detse eid'e bataji puana batana huecuana. Jesús neje quisaquisa epuani tse batana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Da su Pedro ja Jesús uja atana: —Echua Puji, saida ecuaneda upia pamapa su meanija. Quimisha epahuaneti cuana ecuanaju paaiti, ahua mique tsada su. Piada miqueda puji, piada Moisés sa puji, piada Elías sa puji ecuanaju paaiti. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Quimisha discípulo da ebia su iyuame putana putsu, Pedro ja daja Jesús quisatana. Cuaja ai biame mimi taji mahue putana huecuana, ebia su iyuame putana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Da hora su judu ja dunutana huecuana. Diusu ja judu jenetia atana huecuana uja: —Ye da quema ibuneda Ebacua. Tueda bahui meid'abaenique. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Da hora su jababarereati putsu, aimue Moisés, Elías chenu detse batana huecuana mahue. Jesús bahui eneti batana hecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Da su beju murucu jenetia ebutetasa cama, Jesús ja cuatsasiatana huecuana uja: —Be aidhe biame mequisaji tsuhu micuaneda baitia ai cuana. Beju ema manujiji cuana duju jenetia enetianayu tsine su chu, quisa mepuque. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Da su beju aimue aidhe biame quisatana huecuana mahue ai cuaja puana cuana. Tuneda murucu jenetia ebutesa cama, jaquisabatitana huecuana uja: —¿Cueja jia da Jesús sa mimi cuana epuani? ¿Jucuaja su, “Manujiji cuana duju jenetia ema enetianau”, epuani? ");
INSERT INTO tnaNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Da su beju Jesús uja quisabatana huecuana: —¿Jucuaja su ni da jacuatsasiati ebuetsuaji cuanaja, “Diusu sa Jabeituti Deja pueji mahue su, Elías chenu sa pue taji”, cristiano cuana ebuetsuatani? Beju mida Diusu sa Jabeituti Deja pueana biame, aimue ecuanaju Elías chenu bana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Da su Jesús ja jeutsutana huecuana: —Enei hue, piada deja Elías chenu nime Diusu su Jabeituti Deja hui su pue taji, pamapa cristiano cuana ebaseta puji. Yama micuana butsepi equisainia, tueda ema hui su pueana beju. Tueda da Juan Bautista puina. Cristiano cuana ja mu tueda madhada hue a putsu, manuametana huecuana, Daja huecha ya di sufri epu. Cristiano cuana ja ema tsada mahue ba putsu, ema emanuameta huecuana. Daja da epu, cuaja profeta chenu cuana ja deretaidha batame. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Beju tuneda pia discípulo cuana peje su cuina putsu, dueji cristiano cuana yani batana huecuana. Tuna duju su pia discípulo cuana anitaina batana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Piada piada jacuatsasiati ebuetsuaji cuana tuna neje jubida jasatsiatitanetina batana huecuana. Beju cristiano cuana ja Jesús ba putsu, nimetiutana huecuana. Jesús peje su jududutana huecuana tu emitsu puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Da su Jesús ja discípulo cuana quisabatana: —¿Ai ni micuana esatsiatineti tuna neje? ");
INSERT INTO tnaNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Beju piada deja ja cristiano cuana duju jenetia jeutsutana: —Ebuetsuaji, quema ebacua einid'u madhadaji. Tuahueda quema ebacua mimi bue mahue ametana. Da putsu, mi peje su yama duseitia. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Quepia papu quema ebacua tueda einid'u madhada ja einatani putsu, yahua su ejusiautetani. Beju ecuatsa je equedi pura epuani. Etsedhaitiani beju. Mesa equita tadada epuani. Beju mique discípulo cuana yama bajaitia, einid'u madhada quema ebacua peje jenetia pajusiacuinata huecuana puji. Beju cuaja a taji mahue bataitia huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Da su Jesús ja anititana discípulo cuana d'ayapirutana uja: —¡Ai! ¿Jucuaja su jia micuaneda jei puji mahue? ¿Que tupu teje jia quema micuana neje ani taji? ¿Que tupu teje jia quema micuana tuchea taji? ");
INSERT INTO tnaNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Da su dusetana huecuana. Einid'u madhada ja Jesús batana su, edeahue sa equita riatana. Yahua su dajajametana. Edeahue busiapa pupiruana. Ecuatsa je equedi pura pupiruana. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Da su Jesús ja edeahue sa tata quisabatana: —¿Quejucua tiempo jenetia mique ebacua daja? Daja ja jeutsutana Jesús: —Yanana jenetia daja hue. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Quejucua nuati biame cuati, ena su jusiautetana einid'u madhada ja emanuame puji. Ahua miada a cua su, ibunebaque ecuanaju. Tsahuaque ecuanaju. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Da su Jesús ja tueda uja quisabatana: ¿Jucuaja su miada ema, “Ahua miada a cua su”, epuani? Quebata Diusu peje su jei epuani su, pamapa ai cuana atasaida tuseda puji epu. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Da su edeahue sa tata tsiatsia neje atana: —Ema mi peje su jei epuani. Tsahuaque ema ebia su jei ema papu puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesús ja ebia su cristiano cuana edhitatitani ba putsu, einid'u madhada jubida cuatsasiatana: —Einid'u madhada id'aja mahue, mimi bue mahue jaatiji, cuinanaque ye edeahue peje jenetia. Be neicha hue nubitiji. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Beju einid'u madhada tsiatsia putsu, jubida neicha edeahue riatana. Daja a putsu, beju mesiataibana. Edeahue beju emanu nime pu huanana. Da putsu da, pamapa enetita cuana, “Edeahue beju manuitia”, putana. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesús ja edeahue sa eme ina putsu, netianametaibana. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Da su cristiano cuana putitaibana su, ete su nubiana discípulo cuana neje. Chujemame ete su nubi putsu, Jesús quisabatana huecuana uja: —¿Jucuaja su ni da ecuanaju einid'u madhada cuaja cuatsasia taji mahue baitia? ");
INSERT INTO tnaNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Da su Jesús ja jeutsutana huecuana: —Ahua etse tueda einid'u madhada cuatsasiaja su, equene jubida Diusu baja taji ayuno neje. Da neje bahui etse tueda mu ejusiacuinainia. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Beju da jenetia putitana huecuana. Galilea yahua je jaitianatana huecuana. Jesús ja mesa discípulo cuana buetsuataina putsu, tsada mahue mesa puina cristiano cuana ja eshanapata quepia tuneda yanita. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Jesús ja discípulo cuana uja atana: —Ema da Diusu sa Jabeituti Deja. Ema emenajatiata huecuana deja madhada cuana peje su cuana peje su ema pamanuameta huecuana puji. Beju quimisha tsine jenetia manujiji cuana duju jenetia ema enetianayu. Daja Jesús ja quisatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tuneda mu cuaja shanapa taji mahue batana Jesús sa mimi cuana. Iyubatana huecuana Jesús equisaba puji cuaja mesa quisa epuani. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Da su beju cuinatitana huecuana Capernaum ejude su. Ete su beju yani cama, Jesús ja discípulo cuana quisabatana: —¿Ai ni da micuaneda cama edid'i je jasatsiabetaitia? ");
INSERT INTO tnaNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Beju cuatsa mahue putana huecuana. Tuna duju su quebata da ebia su aida quita epuani jepuiti jasatsiabetitana huecuana. Jajeutsutija mahue putana huecuana, bidhu putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Da su beju Jesús aniuteana. Aniute putsu, ihuatana huecuana tu peje su. Uja quisatana huecuana: —Quebata micuana duju su aida puja su, equene beju pamapa sa huai chidi, emebajaji pu taji. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Da su tuna duju su piada yanana chidi Jesús ja netianametana. Id'amitana yanana chidi. Daja yanana id'ami putsu, uja quisatana discípulo cuana: ");
INSERT INTO tnaNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Quebata ja piada ye yanana nime quema ebani su ebatsuta su, ema ebatsutani pu cua nime beju. Daja huecha quebata ja ema ebatsuta su, Tata Diusu di ebatsutani, tuahueda ema beitutana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Da su Juan ja Jesús atana: —Ebuetsuaji, bana ecuanaju piada deja ja mique ebani su einid'u madhada cuana ejusiacuinatani cristiano cuana peje jenetia. Ecuanaju neje mue puniuneti putsu, ecuanaju, “Be aji”, ana. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Da su Jesús ja atana huecuana: —Be memenahueji tueda deja. Ahua quebata ja nimetiuda ai cuana quema ebani su yatani su, aimue ema neje madhada hue epuani mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Aimue ecuanaju neje puniuneti biame, tueda da ecuana sa eshanapa. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mepibaenique, quebata ja micuana ai chidi neje biame etsahuata su, micuaneda Cristo sa putsu, Diusu ja tueda saida echuje etiatayu. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","‘Quebata ja piada eichacua ema peje su jei epuani cristiano tusa Diusu peje su janimetucheati etaitanameta su, tuseda puji ebia su saida pamanu bai dueda su tueda eichacua jei epuani cristiano sa janimetucheati taitanameji mahue su hue. Beju ye mundo su jucuada ai cuana yani cristiano cuana sa Diusu peje su janimetucheati cuana etaitaname puji. Quebata ja daja etaitanameta huecuana su, Diusu ja tueda ematsetayu. ¡Aba tueda, ahua pia cuana daja etaitanameta su! ");
INSERT INTO tnaNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ahua mique eme ja mi jucha yameta su, rijique. Ebia su saida quita piada eme neje cielo su enubi puji, aimue meji cuati castigo su eputi mahue puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Dapia cuati castigo jude su cuati utsu pupe bue mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ahua mique ehuatsi ja mi jucha yameta su, rijique. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ebia su saida quita piada ehuatsi neje cielo su enubi puji, aimue huatsiji cuati castigo su eputi mahue puji. Dapia cuati castigo jude su cuati utsu pupe bue mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ahua mique etua ja mi jucha yameta su, huijajusiaque. Ebia su saida quita piada etua neje cielo su enubi puji, aimue tuaji cuati castigo su eputi mahue puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Dapia cuati castigo jude su cuati utsu pupe bue mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","‘Cuaja aicha bia su banu eichatani nime, daja da cuati castigo su cuati utsu neje ebiaichata. ");
INSERT INTO tnaNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Banu da saida. Ahua banu mesa patseda etaitana su, ¿cuaja ni da banu neicha saida patseda puyu cua? Micuaneda banu nime mepuque saida huamahuama yaniti puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Da su beju Jesús cuinanana Capernaum ejude jenetia. Judea yahua su putiana. Jordán ena chu maje anipetutiana. Neicha hue dueji cristiano cuana tu peje su jadhitatitana. Da su Jesús ja buetsuapirutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Beju piada piada fariseo cuana ja Jesús nariatana mimi neje tu yaba puji. Da su Jesús quisabatana huecuana: —¿Ahua saida deja ja quirica derejiji neje mesa ehuane emesiaenita puji? ");
INSERT INTO tnaNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Da su Jesús ja quisabatana huecuana uja: —¿Cuaja ni Moisés chenu ja cuatsasiataidha? ");
INSERT INTO tnaNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tuneda jeutsutana: —Moisés chenu ja deja cuana d'eji tiataidha quirica derejiji neje ehuane emesiaenita puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Da su Jesús ja quisatana huecuana: —Judío cristiano cuana nimetadada putsu, Moisés chenu ja daja cuatsasiataidha. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Uja Moisés chenu deretaidha: “Equene su Diusu ja deja, epuna ataidha.” ");
INSERT INTO tnaNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Neicha Moisés chenu ja deretaidha uja: “Da putsu, deja ja mesa tata, cuara detse ichajusia taji mesa ehuane neje yaniti puji. Beju tuatseda mu piada hue pu cua nime epu.” Beju daja Diusu sa quirica su epuani. Aimue Diusu ja tuatseda beta nime ebatani mahue. Piada nime hue ebatani tse. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Da putsu beju, aimue detse aidhe sa biame jamesiati taji pu cua mahue, Diusu ja tuatseda dunemetana putsu. Daja Jesús ja jeutsutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Da su beju ete su tuna mehua anitana su, discípulo cuana ja Jesús quisabatana tusa jabuetsuati jenetia. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús beju jeutsutana huecuana uja: —Ahua quebata yahue ja mesa ehuane jucha mue biame emesiata su, ahua pia neje ehuaneti su, da su tuahueda jucha aida yatani. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Daja huecha ahua quebata ehuane ja mesa yahue jucha mue biame emesiatu su, ahua pia neje yahueti su, tueda epuna ja di jucha aida yatani. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Da su beju piada piada yanana chidi cuana Jesús peje su dusetana huecuana, Jesús ja mesa eme tuna bia su huana putsu, tuneseda puji Diusu ebajata puji. Beju discípulo cuana sa tsada mahue puana. Yanana chidi duseji cristiano cuana d'ayapirutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesús ja daja ba putsu, discípulo cuana neje duininiana. Tuahueda atana huecuana uja: —D'eji metiaque yanana cuana ema peje su papueta. Be menahueji huecuana, Diusu ecuatsasiati da tuna nime cuana sa putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ene putsu, yama micuana equisainia, etse sa nimemitsida pu taji ye yanana cuana nime Diusu ecuatsasiati su enubi puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Da su Jesús ja yanana cuana id'amitana. Mesa eme detse yanana cuana bia su huana putsu, Diusu peje su ibuneda neje menajatiatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesús epupiruhu cama, piada deja tu peje su jududubeana. Tu butse su beju tururuana. Da su deja ja Jesús quisabatana: —Echua Puji, mida da saida. ¿Ai ni quema a taji Diusu neje cielo su eid'e yanieniti puji? ");
INSERT INTO tnaNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Da su Jesús ja tueda jeutsutana: —¿Jucuaja su miada ema, saida, yainia? Diusu bahui da saida. Ahua mida cielo su eid'e anienija su, Moisés chenu sa jacuatsasiati cuana apeque. Da su deja ja neicha Jesús quisabatana: —¿Quebata jacuatsasiati cuana quema a taji? ");
INSERT INTO tnaNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Jesús ja deja jeutsutana: —Be cristiano manuameji. Be pia sa ebutse quinaji. Be tsi puji. Be bid'umimi puji. Mique tata, cuara detse iyubaque. Mida quitaita ibuneda ebatiani nime, daja pia cuana ibuneda baque. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Da su deja ja Jesús atana: —Beju pamapa tueda jacuatsasiati cuana yama butsepi yainia ema yanana jenetia jiahue teje. ¿Ai pia ni da quema a taji yani? ");
INSERT INTO tnaNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Beju Jesús ja tueda uja atana: —Ahua mida nimebutsepi puja su, irutique pamapa mique ai cuana. Pamapa mique chipilu cuana puri cristiano cuana tiaque. Tiape putsu, tije ema aque. Ahua daja ya su, cielo su pamapa ai eichacua cuana mique yani. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Beju deja ja daja id'aba putsu, ebia su jatacuamadhapirutiana, tueda ebia su chipiluji putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","25","Da su deja putibana su, Jesús ja mesa discipulo cuana uja atana: —Ene putsu, yama micuana equisainia, atadhada chipiluji cuana Diusu ecuatsasiati su enubi puji. Ebia su atasaida caballo acusha id'aja je ejaitiana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Da su discípulo cuana da Jesús daja epuani id'aba putsu, ebia su nimetiunetitana huecuana. Uja jaquisabatitana huecuana: —¿Aidhe jia da d'eji su pu cua? ");
INSERT INTO tnaNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Beju Jesús ja tuna chama putsu, uja atana huecuana: —Cristiano cuana aimu tuna mehua quitaita hue d'eji su jaatita cua mahue. Diusu sa puji mu mue ai biame atadhada mahue. Beju Diusu ja aidhe papu biame d'eji su ata cua. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Da su Pedro ja Jesús uja atana: —Echua Puji, ecuanaju beju pamapa ecuanaju sa ai cuana ichajusiana mi tije ya puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Da su Jesús ja Pedro jeutsutana uja: —Enei hue yama micuana equisainia, quebata ja mesa edue, dudu, tata, cuara, ehuane, yanana cuana, daja huecha ete, te cuana ema jepuiti eichajusiata su, Diusu ja tueda ai ichajusiajiji cuana ebia su dueji eturuca etiatayu ye mundo su. Daja biame, cristiano cuana ja madhada hue tueda yatayu. Beje Diusu ja tueda cielo su eid'e yameenititayu. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Da su beju jiahue equene, aida eputani cuana da ai eni mahue tije eputayu. Daja huecha jiahue ai eni mahue tije eputani cuana da equene aida eputayu. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Beju tuneda edid'i su yaseneti cama, Jerusalén ejude su epuhu je, Jesús da discípulo cuana hui su putiana. Discípulo cuana iyuame neje Jesús tije putitana. Da su neicha hue Jesús ja chujemame ihua putsu, quisapirutana huecuana. Ai cuaja epu tu jepuiti quisapirutana huecuana uja: ");
INSERT INTO tnaNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Meid'abaque. Ecuaneda Jerusalén ejude su epuhu. Dapia sacerdote huaraji aida, jacuatsasiati ebuetsuaji cuana peje su ema emenajatiata. Romano soldado cuana peje su ema emenajatiata huecuana ema pamanuameta huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ema neje eshishatita huecuana. Equedi neje ema equid'uata huecuana. Eicheta huecuana ema. Daja a putsu, ema emanuameta huecuana. Beju quimisha tsine ejaitiana su, ema manujiji cuana duju jenetia enetianayu. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedeo sa ebacua Jacobo, Juan detse ja Jesús nariatana. Uja Jesús bajatana tse: —Ebuetsuaji, tiaque etseju sa jabajati. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Da su Jesús ja quisabatana tse: —¿Ai ni da yama metseseda puji a cua? ");
INSERT INTO tnaNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Beju jeutsutana tse uja: —D'eji tiaque etseju mi neje ecuatsasia epu puji, mi ecuatsasiati su. Piada mique bai eni bene, pia mique d'ani bai bene etseju paaniute. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Da su Jesús ja tuatseda jeutsutana: —¿Ai metseda ebajainia ai cuana bahue bata? ¿Ai metseda sufri pu cua, manu cua ema epu nime bata? ");
INSERT INTO tnaNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Da su tuatseda jeutsutana Jesús uja: —A cua detse etseju. Da su Jesús ja quisatana tse uja: —Enei hue, ema sufri epu nime, daja metseda di sufri epu. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Daja biame, aimue metse sa jabajati yama tia cua mahue. Quema bai eni bene, quema d'ani bai bene metseda yaniute puji aimue quema puji aimue quema puji dhare taji mahue. Tata Diusu ja bahui tueda aniude detse tiata cua. Mesa beta dharejiji detse bahui etiata. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Da su beju pia discípulo cuanaja id'aba putsu, duininitana huecuana Jacobo, Juan detse neje. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Da su Jesús ja pamapa su ihuatana tu naja su. Uja atana huecuana: —Micuaneda bahue pamapa ejude sa huaraji aida cuana ja ebia su tucheda neje cristiano cuana ecuatsasiatani. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Beju micuaneda mu aimue daja epu mahue. Quebata micuaneda huaraji aida puja epu su, tuseda pia cuana mebaja taji. Quebata micuaneda ehuidusuji puja epu su, pia cuana sa emebajaji pu taji. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ema da Diusu sa Jabeituti Deja biame, ema pueana ye mundo su aniji cristiano cuana emebaja puji. Aimue ema pue cristiano cuana ja ema pamebajata puji. Beju ema pueana emanu puji, dueji cristiano cuana d'eji su paputa puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Da su pia ejude su cuinatitana huecuana. Tueda ejude banime Jericó. Ejude jenetia ejaitianatani huecuana su, dueji cristiano cuana ja buquenatana huecuana. Beju edid'i buahua su ejude chu bene piada deja padha anina. Tueda deja banime Bartimeo puina. Tueda da Timeo sa ebacua puina. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jesús enariatiani id'abatana putsu, tsiatsiapiruana uja: —¡Jesús, David chenu sa familia jenetia, ibunebaque ema! ");
INSERT INTO tnaNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Da su pia cuana ja deja d'ayatana. —Mitanaque —atana huecuana. Da su cha ebia su hue jubida tsiatsiana deja uja: —¡Jesús, David chenu sa familia jenetia, ibunebaque ema! ");
INSERT INTO tnaNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Da su Jesús netisenana. Cuatsasiatana huecuana uja: —Meihuaque deja padha. Da su deja padha ihua putsu, uja atana huecuana: —Janimetucheatique. Netianaque, tuahueda mi eihuatani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Deja ja beju mesa ebiad'amaji jusia putsu, tenana. Jesús nariatana. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Da su Jesús ja tueda quisabatana uja: —¿Ai ni mique yama cuaja a cua? Padha ja beju jeutsutana: —Ebuetsuaji, ema jabatija. ");
INSERT INTO tnaNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Da su Jesús ja cuatsasiatana deja: —Puchiditiyuque. Ema peje su mi jei puitia putsu, saisitia mi beju. Da hora su beju padha jabatiana. Jesús tije apirutana edid'i je. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Beju Jerusalén ejude nariatana huecuana. Dapia beta ejude chidi Jerusalén ejude naja su anina. Tueda ejude chidi detse Betfagé, Betania banime puina. Tueda ejude detse Olivo murucu aida butse su anina tse. Beju murucu su cuinati putsu, Jesús ja beta discípulo detse beitutana ehui su. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Uja quisatana tse: —Meputique ejude chidi su. Dapia asunu chidi risijiji eneti metseda eba. Tueda asunu chidi aiya biame tsuhu aimue bianibaji mahue. Mepidhuque tueda. Mejetique beju upia. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ahua aiya metse: “¿Jucuaja su metseda daja yainia?” equisabata su, mequisaque tueda uja: “Echua Puji ja etsatani. Beju tipeida ebeitutayu.” ");
INSERT INTO tnaNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Da su beju putiana tse. Asunu chidi risijiji ete etsequeini su batana tse. Da su asunu chidi pidhutana tse. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Pidhu putsu, piada piada eneti cristiano cuana uja quisabatana tse: —¿Ai da metse epuani? ¿Ai puji metseda asunu chidi epidhuinia? ");
INSERT INTO tnaNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tuatseda beju quisatana huecuana, cuaja Jesús ja cuatsasiatana batame. Da su d'eji tiatana huecuana edusuta tse puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Beju asunu chidi Jesús peje su dusutana tse. Ebia jud'uji cuana asunu bia su ichatsuatana discípulo cuana ja. Daja ape putsu, Jesús ja asunu bianitana. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Dueji cristiano cuana ja tuna sa ebia jud'uji cuana huanatana Jesús epuhu edid'i hui su. Pia cuana ja tumi nime sa ebai cuana dheu putsu, huanatana huecuana. Daja cristiano cuana ja a bahue ataina, huaraji aida cuana epuetani su. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","10","Beju equene eputahu cristiano cuana, daja huecha tije eputasiu cristiano cuana di tsiatsiatana uja: —¡Gloria, Tata Diusu sa Jabeituti Deja epusiu! ¡Tueda da echua puji David chenu sa familia jenetia! ¡Diusu sa ebani su tueda epusiu! ¡Diusu ja tueda paibunebata! ¡Gloria Tata Diusu! ¡Saida pacuatsasiaenita! ");
INSERT INTO tnaNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Da su Jesús Jerusalén ejude su nubiana. Templo su di nubiana. Nubi putsu, pamapa ai bajusiapetana. Beju tsinecua eni putsu, Jesús, mesa piada tunca beta ejaitiana discípulo cuana neje Betania ejude su putiana. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pia tsine Betania ejude jenetia cuinanatana huecuana. Jesús beju dhemanuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Uqueda jenetia higo equi inaji batana. Beju equi nariatana ahua ejaja ebade eba puji. Equi su cuinati putsu, eina cama beju batana. Aimue tsuhu higo jajaji puina mahue, aimue ejaja tiempo mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Da su Jesús ja higo equi uja atana: —U jenetia su be aiya biame mique ejaja padiatayu. Mesa discípulo cuana ja beju id'abatana. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tuneda da Jerusalén ejude su cuina putsu, Jesús templo su nubiana. Dapia iruiruji, bajabajaji cuana etseque su cuadejusiacuinatana. Chipilu turucaji sa misha cuana busiapapetana. Huaitucu iruji cuana sa aniude cuana di busiapapetana. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Aimue aidhe biame d'eji tiatana mahue tuna ai papu cuana pabutita puji templo dume su. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Uja atana huecuana: —Diusu sa quirica su uja derejiji yani: “Quema ete da pamapa cristiano cuana sa ema mitsu jude ete epu.” Micuaneda mu tsi puji sa ete ana. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Da su da sacerdote aida, jacuatsasiati ebuetsuaji cuana ja Jesús sa mimi id'aba putsu, cuaja tueda manuame ya puji pibapirutana huecuana. Aimue da hora su Jesús inatana huecuana mahue, cristiano cuana tusa sa jabuetsuati cuana tsada putana putsu. Sacerdote aida, jacuatsasiati ebuetsuaji cuana ja cristiano cuana iyubatana. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Beju dhidha puana su, Jesús ejude jenetia putiana, mesa discípulo cuana neje. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pia tsine apudaya enieni ete jenetia beju cuinanatana su, higo equi eneti je jaitianatana huecuana. Chu d'auna higo equi saranetiajiji batana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Da su Pedro ja pibatana Jesús ja mimi neje higo equi madhatana. Tuahueda uja atana Jesús: —Ebuetsuaji, chamaque higo equi miada mueta madhaja puicha. Beju jiahue saranetiajiji. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Da su Jesús ja atana huecuana: —Jei mepuque Diusu peje su. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ene putsu, yama micuana equisainia, quebata ja papu ye emata, “U jenetia mar su puderaque”, yata su, beju daja da epu, ahua tueda Diusu peje su jei epuani su. Ahua aimue jei epuani mahue su, aimue detse daja pu cua mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yama micuana equisainia, micuaneda Diusu ebaja su, jei jubida mepuque tu peje su. Diusu peje su jei pu putsu, tuahueda micuana sa jabajati etiatayu. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Micuaneda Diusu bajaji mahue su, equene pia cuana perdona taji. Ahua micuana sa aidhe neje ai madhada yani su, perdona taji. Daja huecha micuana sa Tata Diusu ja cielo su yani micuana sa jucha cuana eperdonata. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ahua micuaneda perdonaja mahue ya su, daja huecha micuana sa Tata Diusu ja micuana sa jucha cuana aimue eperdonata mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Da su beju Jerusalén ejude su jasiapatitana huecuana. Jesús templo dume su yaseniuneti cama, sacerdote aida, jacuatsasiati ebuetsuaji, tata edhi ehuidusuji cuana ja Jesús nariatana. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Uja Jesús quisabatana huecuana: —¿Aiya mida huaratiatana ye ai cuana ya puji? ");
INSERT INTO tnaNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Da su Jesús ja jeutsutana huecuana: —Equene yama micuana equisaba. Ahua micuaneda ema ejeutsu su, beju yama di micuana ejeutsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Aiya Juan Bautista huaratiatana cristiano cuana Diusu sa puji yahui neje eichadera puji? ¿Diusu ja ahua cristiano ja? ");
INSERT INTO tnaNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Da su tuneda cama uja jaquisatitana: —Ahua ecuaneda, “Diusu ja Juan huaratiatana”, ejeutsu su, tuahueda, “Da su, ¿jucuaja su micuaneda aimue Juan peje su jei puana mahue?” ecuana equisabata. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ahua ecuaneda, “Cristiano ja Juan huaratiatana”, ejeutsu su, da su pamapa cristiano cuana ecuana neje eduininita, Juan da Diusu sa profeta ebatani huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Da su Jesús uja jeutsutana huecuana: —Aiya jia Juan huaratiatana bue mahue ecuanaju. Jesús ja atana huecuana: —Da su yama di, aiya ema huaratiatana aimue micuana equisa mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Neicha hue Jesús ja quisatana huecuana bahue quisa neje: —Beju anina piada deja. Tueda deja uva jude banatana. Taracatana beju. Tumu pachata aida edusete su rara atana uva ena epudu puji. Ete pacha baqui bauda di atana da bia jenetia uva jude pamapa einatsihua puji. Da su beju deja ja pia cuana uva jude menajatiatana paquinata huecuana puji, tuneseda dajucua uva cuana ejemitita puji. Beju daja a putsu, emetse pia yahua su putiana. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Huiru taji tiempo beju cuinana su, emetse ja piada emebajaji deja beitutana uva jude quinaji cuana peje su emetse sa tupu patiata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tueda uva jude quinaji cuana ja emebajaji ina putsu, beju ichetana. Beitutaibana emebajaji ai biame tiaji mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Da su beju emetse ja pia emebajaji beitutana tuna peje su. Uva jude quinaji cuana ja tueda ina putsu, tumu neje nedaneda a putsu, madhabatana huecuana madhabatana. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Neicha hue beju emetse ja pia emebajaji beitutana. Tueda mu beju manuametana huecuana. Daja huecha atana huecuana pia emebajaji cuana. Pia cuana ichetana huecuana. Pia cuana mu manuametana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","‘Beju emetse sa piada hue mesa anina ebeitu puji. Tueda da mesa ibuneda ebacua puina. Tije da beju mesa ebacua beitutana tuna peje su. Emetse japibatiana uja: “Quema ebacua da enei hue eiyubata huecuana.” ");
INSERT INTO tnaNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Beju uva quinaji madhada cuana ja emetse sa ebacua ba putsu, jaquisatitana huecuana, “Tueda da emetse sa ebacua. Tueda da ye pamapa ai cuana emetse epu. Pamanuametija tueda. Da su ecuaneda ye uva jude emetse cuana epu beju”. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Da su emetse sa ebacua ina putsu, manuametana huecuana. Uva jude jenetia etseque su tusa equita jusiacuinatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Da su Jesús ja quisabatana cristiano cuana: —¿Cuaja ni da emetse ja uva jude quinaji ate cuana yata? Tueda jasiapati putsu, uva jude quinaji ate cuana emanuameta. Daja a putsu, uva jude pia mudu puji cuana emenajatiata. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","‘Beju Diusu sa quirica su uja derejiji yani: Ete muduji cuana ja yapiruji tumu jusiaderatana biame, tueda tumu macha beju Diusu ja dharetana. Tueda pia tumu cuana ebia su saida ametana. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tueda da nimetiuda ecuaneda ebainia. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Beju judío cuana su ehuidusuji cuana ja Jesús tuna jepuiti mimiana jashanapatitana putsu, Jesús inaja adhaatana huecuana. Mue ina atana huecuana, cristiano cuana iyuba putsu. Beju putitaibana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Da su beju fariseo cuana Jesús peje su puetana tu quisababapebape putsu, Jesús mimi madhada emimiame puji, tu etuaquisa puji. Herodes Antipas sa deja cuana di tuna neje puetana. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Beju Jesus quisatana huecuana uja: —Ebuetsuaji, ecuanaju bahue mida butsepi emimiani. Miada Diusu sa ene quita jabuetsuati cuana ebuetsuainia. Pamapa cristiano cuana miada tupupai ebainia. Aida puji, puri cuana miada tupupai ebainia. Da putsu, quisaque ecuanaju, ¿ahua saida ecuaneda romano echua puji aida impaesto echujetia puji, ahua mahue? ");
INSERT INTO tnaNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Beju jashanapatiana tuna madhada piba neje daja quisabatana. Ahua Jesús, “Saida echujetia puji”, epu su, da su judío cuana tu neje eduininita. Ahua, “Saida mahue echujetia puji”, epu su, da su romano soldado cuana ja einata. Da putsu, Jesús ja uja jeutsutana huecuana: —Beju micuaneda da bubeta cuana. ¿Jucuaja su micuaneda ema mimi neje pitsameja yainia? Piada chipilu metiaque ema. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Da su beju piada chipilu tiatana huecuana. Chipilu ina putsu, Jesús ja quisabatana huecuana uja: —¿Aidhe sa ebu eimea, ebani da ye chipilu bia su derejiji yani? Da su jeutsutana huecuana: —Tueda ebu eimea, ebani da romano echua puji aida sa beju. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Da su Jesús ja atana huecuana uja: —Da su beju metiaque echua puji aida sa epuani ai cuana. Diusu di metiaque tuseda epuani ai cuana. Da su nimetiutana huecuana Jesús sa jajeutsuti jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tueda tsine su huecha hue piada piada saduceo cuana Jesús peje su putitana. Tueda saduceo cuana da, manujiji cuana neicha eid'etayu aimue jei putana mahue. Da su uja Jesús uja atana huecuana: ");
INSERT INTO tnaNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Ebuetsuaji, Moisés chenu ja buetsuataidha uja: “Ahua quebata deja bacua mahue emanu su, manujiji sa edue ahue manujiji neje jahuaneti taji, ebacua cuana edue manujiji sa bataji sa bataji epu puji.” ");
INSERT INTO tnaNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Beju siete edue cuana anitaina. Edue equene puji jahuanetiana. Beju bacua mahue manuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Da su tu tije puji edue da manujiji sa ahue manujiji neje jahuanetiana. Tueda macha beju manuana bacua mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tu tije puji edue macha daja huecha puana. Beju pamapa tije puji edue cuana daja cama putana ahua manujiji neje. Beju manutana huecuana pamapa. Da su beju epuna macha manuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Da su ahua ene mi epuani nime enetianatayu huecuana su, ¿quebata edue sa jia da tueda epuna ehuane epu? ");
INSERT INTO tnaNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Da su Jesús ja uja jeutsutana huecuana: —Beju ebia su epitsatiani micuaneda ye ai cuana jeputi, Diusu sa mimi derejiji yani mue shanapa putsu, Diusu ja pamapa ai atadhada cuana ata cua, jei epuani mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Diusu ja manujiji cuana enetianametayu su, aimue neicha ebutsenetita huecuana mahue, cielo su Diusu sa ángel cuana nime eputa huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Beju yama micuana butsepi equisainia manujiji cuana jepuiti. Ene putsu, neicha eid'etayu huecuana, micuaneda jei epuani mahue biame. ¿Aimue jia maida micuaneda Diusu sa quirica su mimiameana mahue? Uja Diusu ja Moisés chenu ataidha mesa quirica su derejiji yani: “Ema da Abraham, Isaac, Jacob cuana sa Diusu.” ");
INSERT INTO tnaNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Beju manutaidha huecuana biame, Diusu neje eid'e yanita huecuana, Diusu da eid'e cuana sa bahui Diusu putsu. Da putsu, micuaneda epitsatiani. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Beju piada jacuatsasiati ebuetsuaji dapia aniana. Tuahueda Jesús ja ejeutsutani id'abapetana pamapa. Jesús ja saida saduceo cuana jeutsutana pepe puana. Beju uja quisabatana Jesús: —¿Quebata jia Diusu sa jacuatsasiati ebia su aida quita? ");
INSERT INTO tnaNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","30","Da su Jesús ja jeutsutana: —Beju ye jacuatsasiati da ebia su aida quita: “Id'abaque, Israel. Ecuana sa Diusu mu piada hue. Ibuneda baque Diusu pamapa mique muesumu neje.” Tueda da Diusu sa equene jacuatsasiati. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Pia tije jacuatsasiati da daja nime huecha. Uja epuani: “Cuaja mida quitaita ibuneda ebatiani nime, daja mique pia cuana ibuneda ba taji.” Tueda jacuatsasiati detse da pamapa pia jacuatsasiati cuana ebia su aida. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Da su ebuetsuaji ja Jesús atana: —Enei hue daja, ebuetsuaji. Diusu mu piada hue. Aimue pia ani tu ebia su aida. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ecuaneseda Diusu ibuneda ba taji pamapa muesumu neje. Daja huecha ecuaneseda ibuneda ba taji, cuaja ecuaneda quitaita ibuneda ebatiani nime. Tueda da pamapa Diusu peje su tiumejiji eirutsuatiani cuana altar bia su ebia su saida quita. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Beju ebuetsuaji ja daja saida mimiana putsu, Jesús ja tueda uja atana: —Huai chidi hue mique ai mahue Diusu eshanapaeni puji. Jesús ja daja saida jacuatsasiati ebuetsuaji cuana jeutsutana putsu, da hora jenetia aimue aiya biame tu quisabayuja atana mahue mimi neje tu ebasea puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Pia tsine Jesús templo dume su ebuetsua punetina. Uja cristiano cuana quisabatana: —Jacuatsasiati ebuetsuaji cuana, “Diusu sa Jabeituti Deja da David chenu sa ebacua”, eputani. ¿Cuaja ni da, da su David chenu ja tueda, “Quema Echua Puji”, ataidha? ");
INSERT INTO tnaNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Espítu Santo ja David chenu quitaita mimiametaidha uja: Tata Diusu ja quema Echua Puji uja: ataidha: “Aniuteque quema bai eni bene ema neje tupupai ecuatsasia epu puji, yama mi neje jamajaiti cuana pishitiame putsu, mique eme su eicha teje.” ");
INSERT INTO tnaNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ahua ene quita Diusu sa Jabeituti Deja da David chenu sa familia jenetia bataji puana su, ¿cuaja ni da, da su David chenu ja quitaita tueda, “Quema Echua Puji”, ataidha? Beju dapia cristiano cuana ja beidaji neje id'abatana Jesús. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús ja cristiano cuana daja hue quisainiame atana uja: —Merejatique jacuatsasiati ebuetsuaji cuana neje. Tuneseda ebia su tsada ejud'uji bauda neje ejude duje epuniuneti puji. Tsada mecuana sa cristiano cuana ja iyuda neje saida pamitsuta. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Jadhitati jude ete cuana, tsine ete cuana su aniude eni bahui echacutani huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ahue manujiji cuana sa ai ete cuana mejemi bahueta huecuana. Diusu sa puji risha tsabauda cuana pu bahueta huecuana cristiano cuana ja saida pabata huecuana puji. Da putsu, pia cuana ebia su Diusu ja casigo etiata huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Neicha Jesús da templo su anina. Quepia cristiano cuana ja chipilu eichatani emeji naja su anina. Chamachama netina cristiano cuana ja emeji su eichatani. Ebia su chipiluji deja cuana ja jucuada eichatani Jesús ja batana. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Beju tije piada epuna ahue manujiji pueana. Beja chipilu chidi hue ichatana. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesús ja epuna ja eichatani ba putsu, mesa discípulo cuana ihuatana. Uja atana huecuana: —Ene putsu, yama micuana equisainia, ye ahue manujiji puri ja pamapa pia chipiluji cuana ebia su ichataitia. ");
INSERT INTO tnaNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Pia cuana ja mecuana sa chipilu puchu epuani ichataitia. Ye puri epuna ichenu ja mu mesa yani chidi cuana ichapetaitia. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Beju Jesús, mesa discípulo cuana neje templo jenetia ecuinatasa cama, tumu butsama jenetia templo ajiji batana huecuana. Da su piada discípulo ja Jesús uja atana: —Ebuetsuaji, chamaque ye ete, nimetiuda tumu butsama jenetia ajiji. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Da su Jesús ja jeutsutana uja: —Pamapa miada ye ete butsama ebainia cuana edajajape beju. Aimue piada tumu biame pia bia su yaniti mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Beju Olivo murucu aida su cuinatitana huecuana. Dapia murucu su jucuada aceituna aque cuana netitaina. Tueda emata chidi da templo butse su uqueda pad'i anina. Dapia Jesús aniuteana. Da su Pedro, Jacobo, Juan, Andrés cuana ja Jesús chujemame etsia quisa neje quisabatana uja: ");
INSERT INTO tnaNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Quisaque ecuanaju, ¿quetsunu jia templo edajaja? Dajajaji mahue su, ¿ai nimetiuda ni da ecuanaju eba? ");
INSERT INTO tnaNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Da su Jesús ja jeutsutana huecuana uja: —Merejatique. Be aiya biame micuana mebasea taji. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Jucuada deja cuana quema ebani su epueta. Tuneda da, “Ema da Cristo”, pu putsu, dueji cristiano cuana ebaseata huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","‘Micuaneda emajaitita quisa eid'aba su, be merubutanaji. Equene tueda ai cuana sa daja pu taji. Daja biame, aimue tsuhu pamapa epupe mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Equene beju ejude cuana huamahuama emajaitita. Yahua jubida erireta. Mid'e da epu pamapa yahua je. Ebia su cristiano cuana enimetipeitita. Tueda ai cuana da epupiruji sufrimiento cuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","‘Merejatique micuaneda quitaita. Ejude huaraji cuana peje su micuana emenajatiata huecuana. Judío cuana sa jadhitati jude ete su micuana eicheta huecuana. Huaraji aida butse su micuana edusuta huecuana ema jepuiti. Da su tuna butse su micuaneseda ema quisanetiacuina taji. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Beju pamapa pupeji mahue su, equene pamapa yahua cuana je, Diusu sa quisa saida cuana quisaquisa epupeta. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Da hora su micuana huaraji aida butse su edusuta huecuana su, be mepibapibaji cuaja micuaneda jajeutsutime epu. Micuaneda emimi hura su Diusu ja micuana mimi cuana etiata ejebutsu puji. Beju Espíritu Santo quitaita ja mesa piba cuana micuana peje jenetia emimi. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Da tiemp su beju cristiano cuana ja ema peje su jei eputani cuana huaraji cuana peje su emenajatiata pamanuameta huecuana puji. Edue cama emenajatiatita. Tata cuana ja mecuana sa ebacua cuana emenajatiata. Daja huecha ebacua cuana ja mecuana sa tata cuana emenajatiata pamanuameta huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Pamapa cristiano cuana ja micuana ebia su eduininibata ema jepuiti. Daja biame, quebata emanu teje ema peje su daja hue enimetucheaderati su, tueda da d'eji su epueni. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","‘Profeta Daniel chenu ja deja madhada eni jepuiti deretaidha. Cuaja Diusu sa ai cuana tuahueda emadhabata Daniel chenu ja deretaidha. Da su tueda deja madhada eni Diusu sa templo su yani micuaneda eba su, beju mejududuque. Judea yahua su aniji cuana pajududuta emata cuana su. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Da hura su quebata da mesa ete epa pachata bia su yani su, bute putsu, be ete su panubi ai biame ejemicuinati puji. Butsepi hue pajududu. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Quebata da te su yani su, be ete su pasiapati mesa ejud'uji ejemicuinati puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Aba epuna dheji, bacua edhereji cuana epu da tiempo su, putadhada tuneseda ejududu putsu! ");
INSERT INTO tnaNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Diusu mebajaque, be huinahuina badi cuana su ejududu hora papu. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Da tiemp su cristiano cuana ebia su sufri eputa. Quetsunu su biame daja sufri pu bue mahue ta biame, beju da tsunu su sufri eputa huecuana. Aimue neicha daja nime jubida sufrimiento cuana epu mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Diusu ja tueda sufrimiento tiempo ubu hora hue yata, mesa dharejiji cuana d'eji su paputa puji. Ahua tueda sufrimiento tiempo ubu hora yata mahue su, aimue aidhe biame d'eji su epu mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","‘Beju da tiempo su ahua quebata ja micuana, “Mechamaque, u hue da Cristo”, yata su, be jei mepuji. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Jucuada deja madhada cuana, “Ema da Cristo”, eputa. Daja huecha, “Ema, da Diusu sa quisaquisa puji”, eputa huecuana. Nimetiuda ai cuana yata huecuana. Diusu sa dharejiji cuana di baseaja yadhaata huecuana, nimetiuda ai cuana a putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Micuaneda janimepitijiji meanique, beju yama micuana ye ai cuana jepuiti equene quisana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","‘Tueda sufrimiento tiemp ejaitianani cama, id'eti, badi da yapuna. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Atujai cuana edajajata. Pamapa buepa su yani ai cuana da eruburubuta. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Da hora su beju ema ebute cielo jenetia. Pamapa cristiano cuana ja ema ebata. Buepa judu duju je pamapa Diusu sa hueda, tucheda neje beju ema ebutesa pamapa ja ebata. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Da tiempo su quema ángel cuana yama ebeitu pamapa ye mundo su quema dharejiji cuana padhitata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","‘Mepibaenique aque cuana. Beju eina eichacua chidi cuana eturucatiani su, da su micuaneda eshanapainia jad'iati badi cuana enariatiani. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Daja huecha tueda nimetiuda ai cuana ba putsu, meshanapaque ema epusiu tiempo beju huedhue. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ene putsu, yama micuana equisainia, pamapa tueda ai nimetiuda ebapirutani cuana aimue emanuta mahue tsuhu ema epueicha teje. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Beju cielo, mundo epupe biame, quema mimi mu aimue epupe mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","‘Aidhe biame bue mahue ai tsine su ema esiapati ye mundo su. Angel cuana biame bue mahue. Ema biame bue mahue. Tata Diusu quitaita bahui bahue ai hora su ema esiapati. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","‘Da su daja hue janimepitijiji meanique. Daja hue Diusa memitsuderaque, tueda hora quetsunu ecuina bue mahue micuaneda putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Beju bahue quisa neje yama micuana equisa. Piada ete emetse uqueda eputiani su, eichajusiatani mesa ete emebajaji cuana sa eme su. Emetse ja putiji mahue su, metse su hue mudu cuana etiataniyu huecuana. Ete quinaji di ecuatsasiatani pamapa ai cuana saida paquinata puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","Beju daja huecha da ema ete emetse nime. Micuaneda bue mahue ai hora ema esiapati. Ahua yapupuhu su, ahua dhidha dusete su, ahua huaripa deja equeini su, ahua apudaya su, ai hora jia ema ecuina micuaneda bue mahue. Da putsu, beju daja hue janimepitijiji meanique. Ahua cuapuitime ema ecuina su, yama micuana janimepitijiji mahue huacuina cua. ");
INSERT INTO tnaNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Yama micuana, pia cuana nime, tupupai jubida equisainia. Janimepitijiji meanique. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Beju beta tsine hue beju anina pascua tsine epu puji. Tueda tsine su pan levadura mahue dia bahue putaina huecuana. Da su sacerdote aida, jacuatsasiati ebuetsuaji cuana ja cuaja Jesús basea putsu, eteriicha puji japibatitana. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tuneda cama uja jaquisatitana: —Be painatija Jesús pascua tsine su. Ahua daja ecuaneda ya su, cristiano cuana detse janimetipeitita cua. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús beju Betania ejude su putiana. Dapia cuinati putsu, Simón sa ete su nubiana. Tueda da Simón Lepraji banime puina. Beju tuneda ediadiatani cama, piada epuna tuna ediadiatani su pueana. Tuahueda alabastro emeji chidi dusetana. Emeji chidi su chujeneda saida puida badeina. Tueda puida nardo banime. Tueda da chujeneda saida puina. Da su epuna ja emeji chidi cuatsad'iatana. Cuatsad'ia putsu, Jesús sa echua bia su puida d'uichatana. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Da su piada piada dapia yanita cuana epuna neje duininitana. Tuneda cama uja jaquisabatitana: —¿Ai puji jia ye epuna ja yanacane d'uichataitia ye chujeneda puida? ");
INSERT INTO tnaNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ye puida da piada mara pu cue mudu chuje tupu. Ahua ecuaneda iru cua su, dueji chipilu cuana ecuaneseda ani cua puri cuana etsahua puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Da su Jesús ja uja atana huecuana: —Be ye epuna med'ayaji. ¿Jucuaja su jia micuaneda tu neje eduininiani? Tuahueda quema puji saida atana. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Beju puri cuana micuana neje pamapa hora su yanita. Ai hora papu micuaneseda tsada su saida tsahua cua huecuana. Beju ema mu aimue micuana neje daja yani uteuteti mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ye epuna ja mesa yani tupu ataitia. Puida quema equita bia su d'uichataitia ema papaji pu cua nime. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ene putsu, yama micuana equisainia, quepia papu Diusu sa quisa saida cuana quisaquisa eputani su, ye epuna ja ataitia di quisa eputa tu jiahue quita ataitia pamapa cristiano cuana ja pashanapata puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Da su piada Jesús sa discípulo Judas Iscariote sacerdote aida cuana peje su putiana cuaja Jesús tuna peje su menajatiame ya equisa puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Sacerdote cuana ja Judas daja epuani id'aba putsu, beidaji putana huecuana. Da su chipilu etia jamitsuti tiatana huecuana. Da hora jenetia Judas japibapirutiana cuaja Jesús sacerdote cuana peje su emenajatia puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Beju pascua tsine cuinana. Equene tsine su pamapa cristiano cuana ja huisha janana pascua tsine puji manuametana. Tueda huisha janana irutsuatana huecuana Diusu peje su. Da su discípulo cuana ja quisabatana Jesús: —¿Quepia mique tsada ecuanaju ebaseta pascua tsine su ediadia puji, pascua tsine yati puji? ");
INSERT INTO tnaNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Da su Jesús ja beitutana beta discípulo detse. Tuahueda uja quisatana tse: —Meputique ejude su. Dapia piada deja yahui matu jadusuti metseda etsu. Tije meatique tueda. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Tueda enubiti ete su, ete emetse echacu. Mequisaque ete emetse uja: “Ebuetsuaji ja mi equisabametani uja: ‘¿Quepia d'eji yani pascua tsine jana edia puji quema discípulo cuana neje?’” ");
INSERT INTO tnaNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Da su tueda ete emetse ja diadia jude aida, basetajiji ete ebaque su ebameta. Dapia mebasetaque jana. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Da su ejude su putiana tse. Daja cuaja Jesús puana batame, pamapa ai cuana batana tse. Pamapa basetatana tse tsine su puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Apuda puana su, Jesús, mesa discípulo cuana neje putiana tueda ete su. Beju diadiapirutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ediadiatani cama, Jesús ja quisatana huecuana uja: —Ene putsu, yama micuana equisainia, micuana duju su piada ja ema emenajatiata sacerdote cuana peje su. Tueda da ema neje upia ediadiani jiahue quita. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Da su ebia su jatacuamadhatitana huecuana. Piada piada tuneda Jesús quisabatana: —¿Yama jia? ¿Ahua yama? ");
INSERT INTO tnaNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús ja jeutsutana huecuana: —Micuana duju su yani beju. Ema neje dhepe su ediadiani ja da ema emenajatiata. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Beju ema sufri yameta huecuana, cuaja Diusu sa quirica su derejiji yani batame. ¡Aba, ema menajatiaji epu deja! Ebia su saida quita tuseda puji, bataji epu mahue puji puina. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Da su beju tuneda ediadiatani cama, Jesús ja pan jemitsua putsu, diusulupai Diusu atana. Pan ped'uped'ua putsu, berereatiatana huecuana. Daja ape putsu, atana huecuana uja: —Mediaque ye pan chidi. Ye da quema equita pu cua nime. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Daja mimipe putsu, vinoje emeji jemitsuatana. Diusulupai Diusu a putsu, emeji berereatiatana huecuana. Beju pamapa su jaid'ititana. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Da su Jesús ja atana huecuana uja: —Ye vino da quema ami pu cua nime. Quema ami ed'uichati neje Diusu ja mesa jamitsuti eichacua cristiano cuana etiata. Diusu ja dueji cristiano cuana eperdonatayu, quema ami ed'uichati putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ene putsu, yama micuana equisainia, aimue yama eid'iicha ye vino mahue Diusu ecuatsasiati su eid'i teje. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Da su beju tuneda diadiape putsu, Diusu sa puji satsutana huecuana. Satsupe putsu, Olivo murucu aida su putitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Dapia cuinati putsu, Jesús ja atana huecuana uja: —Pamapa micuaneda ema mehua ejusianetia ye dhida su. Daja micuaneda ya, cuaja Diusu sa quirica su epuani batame. Beju uja epuani, “Yama huisha quinaji emanuame su, huisha cuana eberebereatita.” Ema emanu biame, beju eid'eyu. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Id'eyu putsu, ema micuana equene Galilea yahua su eputi dapia micuana emitsu puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Da su Pedro ja Jesús uja atana: —Echua Puji, pia cuana ja mi ejusianetiata biame, aimue mi yama mu daja ya mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Da su Jesús ja tueda jeutsutana: —Pedro, ene putsu, mi yama yainia, ye dhidha su quitaita da quimisha nuati mida uja emimi: “Mue yama Jesús shanapa.” Huaripa deja queiji mahue su, daja mida epu quimisha nuati. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Da su Pedro ja uja jubida atana Jesús: —Mi neje quema manu taji biame, aimue mi yama ejusianetia mahue. Beju pamapa pia discípulo cuana di dajaputa putana. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Da su tuneda putitana pia ania eti jude chidi Getsemaní banime su. Dapia Jesús ja uja quisatana discípulo cuana: —Meaniuteque upia, ema da Diusu neje emitsutiani tupu. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Da su Jesús ja Pedro, Jacobo, Juan cuana tu neje chuadera pad'i dusutana. Beju Jesús ebia su jatacuamadhapirutiana. Ebia su iyuame pupiruana mesa enime su. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Uja quisatana huecuana: —Ebia su da ema etajiatiani. Emanu nime ema ebatiani. Meanique upia. Meid'enique. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Da su chuadera pad'i Jesús putiana. Beju yahua su d'epesatiana Diusu emitsupiru puji. Bajatana Diusu curusu su sufri pu taji jenetia d'eji su paata puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Beju uja Diusu atana: —Quema Tata, miqueda puji mu pamapa ai cuana atasaida. D'eji su aque ema curusu su sufrimiento epusiu jenetia. Daja biame, mique tsada bahui papu. Be quema tsada mu papu. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Da su Jesús jasiapatibana discípulo cuana yanita su. Etahuitasa beju batana huecuana. Da su quisabatana Pedro: —Simón, ¿a mi etahuisa? ¿Aimue mique tucheda anitia mahue, piada hora dhucuana eid'eni puji? Ene putsu, micuaneda ema buqueja biame, nimepishihue. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Beju meid'enique. Janimepitijiji meanique. Diusu memitsuniaque Ishahua ja micuana epirubata mahue puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Neicha Jesús chuadera pad'i putiana Diusu neje emitsuti puji. Equene Diusu bajatana nime, neicha hue Diusu bajatana. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Diusu mitsupe putsu, Jesús jasiapatibana. Neicha etahuitasa huecuana batana. Tahui mecuana sa a taji mahue putsu, beju tahuitana huecuana. Da su cuaja jeutsu taji mahue Jesús batana huecuana, bidhu putsu. Neicha quimisha nuati puji Jesús chuadera puderatiana Diusu neje emitsuti puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Mitsupe putsu, jasiapatiichana discípulo cuana peje su. Uja quisabatana huecuana: —¿Ahua micuana etahuisa tsuhu? Beju mejanahuasaque hue. Beju tupu saida, juchaji deja cuana sa eme su ema emenajatiata hora cuinaitia putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Menetianaque. Meputija beju. Mechamaque, ema menajatiaji epu deja beju epusiu. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús, discípulo cuana neje daja emimiani cama, Judas dueji deja cuana neje puetana. Espadaji, aquiriji metse cama puetana huecuana. Sacerdote, huaraji aida, jacuatsasiati ebuesuaji, tata edhi ehuidusuji cuana ja tueda deja cuana beitutana Jesús painata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas ja deja cuana Jesús einati puji uja equene quisatana huecuana: —Quebata yama ebudhi, beju tueda da Jesús. Meinaque tueda. Saida risieni putsu, medusuenique. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Da su Judas ja tipeida nariatana Jesús. “Ebuetsuaji”, yainia je, budhitana. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Da su beju deja cuana ja Jesús inatana. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Piada discípulo ja mesa espada jemitana. Da neje sacerdote sa emebajaji sa eid'aja siquijusiatana. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Da su Jesús ja quisabatana huecuana: —¿A da micuaneda pueitia ema eina puji espada, aquiriji metse cama? ");
INSERT INTO tnaNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","¿Ai ema tsi puji bata? Pamapa tsine micuana duju su templo su yama buetsuaina biame, aimue micuaneda ema inana mahue. Beju daja epuani ye ai cuana, cuaja Diusu sa quirica su derejiji yani batame. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Da su pamapa mesa discípulo cuana jududutana. Jesús jusianetiatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Beju piada edeahue ja Jesús tije atana ed'amaji neje bahui babujiji. Tueda di da deja cuana ja inadhaatana. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Inadhaatana huecuana su, edeahue jududuana, ebabuji jusiaicha putsu. Beju jahuijati jududuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesús dusutana huecuana sacerdote aida cuana peje su. Dapia da pamapa sacerdote huaraji aida, tata edhi, ehuidusuji jacuatsasiati ebuetsuaji cuana beju jadhitatitana. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro uqueda uqueda tije atana Jesús, sacerdote sa echua puji aida sa ete etseque teje. Dapia soldado cuana naja su aniuteana. Tuna neje jayutianina cuati naja su. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pamapa sacerdote huaraji aida, ejude sa ehuidusuji edhi cuana dhitatana. Tuneda cama jaquisabatitana cuaja Jesús tuaquisa putsu, emanuame puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Piada piada deja cuana ja Jesús tuaquisatana tsapiapiati bid'umimi cuana neje. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tuneda netianatana etuaquisa puji bid'umimi neje. Uja putana huecuana: ");
INSERT INTO tnaNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Ecuanaju da id'abana Jesús puana uja: “Ye deja cuana sa jamuduti templo yama ejusiautepe. Quimisha tsine su pia templo yama enetianameyu. Tueda aimue deja cuana sa jamuduti mahue.” ");
INSERT INTO tnaNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Beju daja etuaquisatani huecuana biame, aimue mecuana sa jatuaquisati cuana tupupai puana mahue. Beju huaruhuaru mimitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Da su sacerdote sa echua puji aida netianana pamapa cristiano cuana butse su. Uja quisabatana Jesús: —¿Jucuaja su ni miada ye jatuaquisatiji cuana aimue ejeutsuinia mahue? ");
INSERT INTO tnaNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Beju Jesús aimue jajeutsutiana mahue. Da su neicha sacerdote sa echua puji aida ja quisabatana: —¿A da mida Diusu sa Jabeituti Deja? ¿A da mida Diusu sa Ebacua? ");
INSERT INTO tnaNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Da su Jesús ja jeutsutana uja: —Ehe, ema da. Diusu aida, tucheda eni sa bai eni bene yani micuaneda ema eba. Buepa su judu duju su ema epusiu micuaneda eba. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Da su sacerdote aida ja daja id'aba putsu, mesa ejud'uji d'iud'iujatana, ebia su duinini putsu. Uja quisabatana pia cuana: —¿Ai puji ni da ecuaneseda pia jatuaquisatiji tsada pu cua? ");
INSERT INTO tnaNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Beju micuaneda quitaita id'abaitia tusa mimi madhada cuana. Tuahueda Diusu madhabatana tusa mimi neje, tueda da Diusu sa Ebacua puana putsu. ¿Cuaja micuaneda epibatiani? Da hora su Jesús matsetana huecuana pamanu puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Da su beju Jesús quinaji soldado cuana ja tueda quid'uapirutana equedi neje. Jesús tuarisitana huecuana. Ichepirutana huecuana eme neje. Daja a putsu, quisabatana huecuana uja: —Shanapaque aiya mi ichetaitia. Quisaque ecuanaju. Beju daja atana huecuana Jesús. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Beju daja ete dume su Jesús yatani huecuana cama, Pedro etseque su aniana. Dapia piada epuneje tu naja su pueana. Tueda epuneje da sacerdote aida sa emebajaji puina. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Epuneje ja Pedro eyutiani ba putsu, chamaenitana. Da su epuneje ja Pedro uja atana: —Mida di Jesús neje puniunetiana. Ema bahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Beju Pedro ja jeutsutana: —Yama mue shanapa tueda. Bue mahue ema ai jepuiti mida emimiani. Da su Pedro taraca etsequeini su netiderana. Da hora quitaita su huaripa deja queiana. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Neicha hue epuneje ja Pedro chamaenitana. Chama putsu, quisapirutana pia enetita cuana uja: —Ye deja da Jesús sa ebuqueji. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Neicha hue Pedro uja bid'umimi neje jajeutsutiana: —Yama mue shanapa tueda. Da su pad'i dapia echamachamataneti cuana ja quisatana Pedro: —Enei hue, mida di Jesús sa ebuqueji. Mida da Galilea yahua jenetia ecuanaju mique mimi cuana jepuiti eshanapainia. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Da su Pedro jubida mimi madhada neje Diusu bahue puana. Uja atana: —Yama mue shanapa tueda. ");
INSERT INTO tnaNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Da hora quitaita su beju neicha huaripa deja queiana. Huaripa deja queiana putsu. Jesús sa equene mimi cuana su Pedro japibatiana uja: “Qimisha nuati mida, ‘Yama mue shanapa Jesús’, epu, beta nuati huaripa deja queiji mahue su.” Da su Pedro Jesús sa equene mimi cuana piba putsu, jubida papiruana. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pia tsine apudaya su sacerdote huaraji aida cuana, tata edhi ehuidusuji, jacuatsasiati ebuetsuaji cuana jadhitatitana. Beju Jesús risi putsu, huaraji aida Pilato peje su dusutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Tu peje su acuinatitana huecuana su, Pilato ja Jesús quisabatana uja: —¿A da mida judío cuana sa Echua Puji? Jesús ja jeutsutana Pilato: —Ehe, ema da cuaja mi emimiani nime. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Beju sacerdote huaraji aida cuana ja pamapa ai cuana jepuiti neicha Jesús tuaquisatana Pilato butse su. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Da su Pilato ja Jesús quisabatana: —¿Jucuaja su mi aimue ejeutsutiani mahue? Ye deja cuana ja pamapa ai cuana jepuiti mi etuaquisatani. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesús ja mue jajeutsuti putsu, Pilato nimetiuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Beju pamapa mara ye tsine puji piada terijiji Pilato ja d'eji su a bahue. Cristiano cuana ja edharetani quebata d'eji su ya puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Beju terijiji anina piada deja Barrabás banime. Tueda deja manuameji puina. Romano soldado cuana neje jamajaitiana. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Da su Pilato peje su jadhitatitana huecuana piada terijiji dhare putsu, d'eji su ya puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","12","Beju Pilato bahue puana sacerdote aida cuana Jesús duininibatana, cristiano cuana ja Jesús tije atana putsu. Da putsu, Jesús menajatiatana huecuana tu peje su tuahueda pamanuameta puji. Pamapa ye ai cuana Pilato bahue puana. Tueda sacerdote aida cuana ja cristiano cuana cuatsasiatana Pilato pabajata puji, tuahueda Barrabás d'eji su paata puji. Da su Pilato ja cristiano cuana uja quisabatana: —¿A da micuana sa tsada judío cuana sa Echua Puji yama d'eji su ya puji? Beju jeutsutana huecuana: —Mahue. D'eji su aque Barrabás. Pilato ja quisabatana huecuana: —¿Ai ni micuaneseda tsada yama ya micuaneda judío cuana sa Echua Puji yainia neje? banime yainia neje? ");
INSERT INTO tnaNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Da su jubida tsiatsia neje jeutsutana huecuana: —¡Tataque tueda curusu su! ");
INSERT INTO tnaNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato ja quisabatana huecuana: —¿Jucuaja su? ¿Ai madhada ni da tuahueda atana? Da su cha ebia su hue tsiatsiatana huecuana: —¡Tataque tueda curusu su! ");
INSERT INTO tnaNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Beju daja cristiano cuana sa ebia su tsada puana putsu, Pilato ja Barrabás d'eji su atana beidaji yame huecuana puji. Cuatsasiatana soldado cuana huaca biti neje Jesús paicheta huecuana puji. Iche putsu, curusu su patatata huecuana cuatsasiatana. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Da su beju soldado cuana ja Jesús dusutana huaraji aida sa ete etsequeini su. Dapia pamapa soldado cuana jadhitatitana. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jesús sa ejud'uji huijatana huecuana. Huija putsu, jud'utana huecuana ebabuji idhiria neje. Junu quid'aji bauda jenetia corona atana huecuana. Jesús sa echua su ichatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Daja a putsu, eshishatiani je, Jesús bid'ida apirutana huecuana. Uja putana huecuana: —¡Viva, judío cuana sa Echua Puji! ");
INSERT INTO tnaNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Aqui riji neje chuatarapirutana huecuana. Tu bia su quid'uatana huecuana equedi neje. Tu butse su tururutana huecuana, eshishatiani je. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Jashishapeti putsu, ebabuji idhiria mejemitana huecuana. Neicha Jesús jud'utana huecuana tusa ejud'uji quitaita neje. Daja a putsu, beju dusutana huecuana curusu su etata puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Beju eputahu cama, piada deja tsutana huecuana Simón banime. Tueda da ejude su epuhu tsutana. Tueda da Alejandro, Rufo detse sa tata puina. Tueda da Cirene ejude jenetia puina. Soldado cuana ja tueda cuatsasiatana Jesús sa curusu pamapata puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Da su beju Jesús dusutana huecuana Gólgota banime murucu eti jude su. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Dapia da vino, mirra neje huarujiji id'imeja atana huecuana. Beju id'ija mahue atana Jesús ja. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Da su beju curusu su tatatana huecuana. Suerte a putsu, Jesús sa ejud'uji cuana jaberereatiatitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Beju apudaya las nueve tupu su. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jesús bia su curusu su deretana huecuana uja: “Ye da judío cuana sa Echua Puji.” Daja deretana huecuana ai jepuiti Jesús matsejiji cristiano cuana ebame puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tu neje tupupai tsi puji detse pia curusu detse su tatatana huecuana. Piada mesa bai eni bene, pia mesa d'ani bai bene badeanatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Beju daja puana, cuaja biahua tiempo Diusu sa quirica su deretaidha batame. Uja derejiji yani: “Deja madhada detse dhedeje su ichatana huecuana.” ");
INSERT INTO tnaNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Beju ejaitianatasa cuana ja Jesús madhabatana. Echua huajia putsu, uja atana huecuana: —Mida, templo jusiautepe putsu, quimisha tsine jenetia neicha yama enetianameyu, puana. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Puana putsu, jiahue quita curusu jenetia buteque. D'eji su jaatique. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Daja sacerdote aida, jacuatsasiati ebuetsuaji cuana putana. Beju jashishatitana huecuana Jesús neje. Uja tuneda cama jaquisatitana: —Tuahueda pia cuana d'eji su atana biame, aimue tueda tu mehua d'eji su yatiani mahue. Ahua jiahue quita tueda curusu jenetia ebute su, beju ecuaneda jei epu tueda da judío cuana sa Echua Puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tu naja su tatajiji detse ja di Jesús madhabatana. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Beju buepatia su pamapa yahua apunana. Quimisha hora puji apuda puana. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Quimisha hora jaitianana su, Jesús jubida tsiatsiana uja: —¡Ai, quema Diusu! ¡Ai, quema Diusu! ¿Jucuaja su mi ema jusiabadeanaitia? ");
INSERT INTO tnaNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Piada piada dapia enetita cuana ja Jesús id'aba putsu, uja putana: —Tuahueda Elías chenu eihuatani. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Da su piada deja ja huapese nime vino edhi tsetseda su tsabiatana. Aqui huiri bauda huitsana su icha putsu, Jesús sa ecuatsa su atsuatana tu paid'iti puji. Da su deja ja enetita cuana uja quisatana: —Id'ua taji tsuhu. Pabatija ahua Elías chenu epue curusu jenetia tueda ejemiute puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Da su Jesús jubida tsiatsia putsu, manuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Da hora quitaita su templo dume su telón aida, bauda, pamuda badeji beju ebia jenetia ema su cuata jabud'iutiana. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Curusu butse su soldado cuana sa echua puji netina. Cuaja Jesús tsiatsia putsu, manuana ba putsu, uja puana: —Enei hue, ye deja da Diusu sa Ebacua puina. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Curusu uqueda piada piada epuna cuana di chamachamanetitaina. Tuna duju su María Magdalena, Jacobo, José detse sa cuara María di netina. Salomé di netina. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tueda quimisha epuna cuana ja Jesús tije ataina. Jesús Galilea yahua su puniunetina su, tueda quimisha epuna cuana ja ai chidi cuana su Jesús tsahuatana. Pia epuna cuana di dapia netitana tuna neje. Tuneda di Jesús buquetaina Jerusalén ejude su. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Beju viernes apuna puina. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Janahua tsine cuinaji mahue tsuhu puina putsu, piada deja José banime cuinana. Tueda da Arimatea ejude jenetia puina. Piada judío cuana sa ehuidusuji aida puina. Ebia su Diusu peje su janimetucheatiana. Diusu ecuatsasiati ed'uataina. Da su tueda janimetucheati putsu, putiana Pilato peje su Jesús sa equita ebaja puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Beju Pilato da nimetiuana, Jesús manupudana jepuiti. Da su soldado cuana sa echua puji ihuatana tu equisaba puji ahua ene daja. Uja Pilato ja echua puji quisabatana: —¿A da ene Jesús manuitia? Echua puji ja jeutsutana Pilato: —Ehe, Jesús manuitia beju. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Da su Pilato ja daja id'aba putsu, José d'eji tiatana Jesús sa equita pajemiuteta puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Da su José putiana ebabuji chujeneda saida ebajati puji. Jesús sa equita jemiute putsu, babutana. Daja a putsu, tumu epa sepulcro su huananubiatana. Sepulcro etsequeini tumu butsama neje teritana. ");
INSERT INTO tnaNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Beju María Magdalena ja batana quepia Jesús sa equita huananubiatana huecuana. José sa cuara María ja di batana. ");
INSERT INTO tnaNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Beju janahua tsine jaitianana su, María Magdalena, María, Jacobo sa cuara, Salomé cuana ja ai puida bajatana Jesús sa equita etsitsipe puji. ");
INSERT INTO tnaNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Beju domingo tsine su apudaya enieni putitana huecuana Jesús huananubiajiji esa su. ");
INSERT INTO tnaNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Edid'i su yaseneti je, jaquisabatitana huecuana uja: —¿Aiya ni da tumu butsama sepulcro etsequeini jenetia ecuana sa eichaderata? ");
INSERT INTO tnaNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Beju sepulcro su cuinatana su, tumu butsama ichaderajiji batana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Sepulcro su nubi putsu, piada edeahue nime bai eni bene yani batana huecuana. Tueda ejud'uji pasane, baudaji batana huecuana. Daja ba putsu, epuna cuana rubutananetitana. ");
INSERT INTO tnaNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Da su tuahueda uja atana huecuana: —Be merubutanaji. Micuaneda Jesús curusu su tatajiji echacuinia. Aimue upia yani mahue. Beju id'eitiba. Mechamaque upia tueda huanatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Pedro, pia discípulo cuana di mequisatique. Mepibametique huecuana cuaja Jesús ja tuna equene quisatana ai cuana, tu manuji mahue su. Mepibametique huecuana Jesús da id'eyu putsu, tuna equene Galilea yahua su ecuinati. Dapia tuahueda emitsuta huecuana, cuaja tuahueda quisatana huecuana batame. ");
INSERT INTO tnaNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Da su beju quimisha epuna cuana cuinanatana. Jududutana huecuana sepulcro jenetia. Riariatana huecuana, ebia su rubutana putsu. Beju aimue aidhe biame quisatana huecuana mahue. Cuatsa mahue putana huecuana, rubutana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Beju domingo su semana epupiruani su, Jesús apudaya enieni manujiji duju jenetia netianaibana. Equene bataji puana María Magdalena peje su. Tueda María Magdalena peje jenetia Jesús ja equene siete einid'u madhada jusiacuinatana. ");
INSERT INTO tnaNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Beju tueda putiana Jesús sa ebuqueji cuana equisati puji. Tuna peje su cuinati putsu, ebia su epatani huecuana batana. ");
INSERT INTO tnaNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Da su María ja quisatana huecuana uja: —Beju Jesús eid'e beju. Yama tueda baitia. Daja jubida neje quisatana huecuana biame, aimue María jei atana huecuana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Da su beju Jesús bataji puana beta discípulo detse peje su. Pia batame jabametiana putsu, mue shanapa atana tse. Tuatseda te edid'i su epuniuneti cama, Jesús bataji puana tuatse peje su. ");
INSERT INTO tnaNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Da su tuatseda Jerusalén ejude su jasiapatibana pia discípulo cuana equisati puji. Daja huecha tuneda jei aja mahue atana. ");
INSERT INTO tnaNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tije beju Jesús da mesa piada tunca piada ejaitiana discípulo cuana peje su bataji puana. Tuneda ediadiatani cama, Jesús bataji puana. Tu peje su jei puja mahue, muesumu tadada ta putsu, d'ayatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","D'ayape putsu, uja atana huecuana: —Meputique pamapa ye mundo sa ejude cuana je. Diusu sa quisa saida cuana pamapa ye mundo sa aniji cuana peje su quisaquisa meputique. ");
INSERT INTO tnaNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ahua aidhe papu biame jei epu su, ahua Diusu sa puji yahui neje eichaderati su, beju tueda d'eji su epu. Ahua jei puja mahue su, tueda da matsejiji epu. ");
INSERT INTO tnaNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Beju pamapa ema peje su jei eputani cuana ja ai nimetiuda cuana yatayu. Quema ebani tucheda neje einid'u madhada cuana cristiano cuana peje jenetia ejusiacuinatayu huecuana. Pia yana eichacua cuana su emimita huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bacua ejemitsuata huecuana biame, aimue cuaja biame yata huecuana mahue. Ahua ai veneno eid'ita huecuana su, aimue cuaja biame yata huecuana mahue. Ahua mecuana sa eme cuana nedaji cuana bia su ehuanata su, beju esaisita huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Echua Puji Jesús ja discípulo cuana daja quisape putsu, cielo su tsuatibana Diusu sa bai eni bene yaniute puji. Da su beju discípulo cuana putitaibana. ");
INSERT INTO tnaNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pamapa ejude cuana je Diusu sa quisa saida cuana quisaquisa pupirutana. Cuaja cristiano cuana d'eji su puta cua quisa pupirutana huecuana. Echua Puji Jesús quitaita ja tsabatana huecuana cristiano cuana butse su, ai nimetiuda cuana a putsu. Daja papu.");
INSERT INTO tnaNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ibuneda Teófilo, mi peje su ye quirica yama ebeituinia pamapa Jesús ja ecuana duju su atana cuana equisa puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Jesús batana cuana ja tu ai atana cuana ema quisaenitana. Tuneda Cristo sa quisa saida cuana quisaquisa putana. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Saida yama pibana tueda ai cuana edere puji, pamapa tueda ai cuana yama butsepi quisachacuana putsu. Beju jiahue cuaja pupirume puana pamapa tueda ai cuana yama butsepi edereinia mi etiame puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ye quirica mi etiameinia mi buetsuatana Cristo jepuiti ai cuana saida eshanapa puji. Beju jiahue mida yama tueda ai cuana equisa. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Da tiempo su Herodes Judea yahua sa echua puji puina. Tueda yahua su piada sacerdote di anina. Tueda banime puina Zacarías. Tuahueda pia sacerdote neje Diusu mebajataina templo su. Tueda sacerdote cuana da Abías cuana puina. Zacarías sa ehuane Elisabet banime puina. Tueda di Zacarías nime Aarón chenu sa familia jenetia puina. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Tuatseda Diusu butse su nimebutsepi puina. Aiya biame cuaja tuaquisa taji mahue tse batana huecuana. Pamapa Diusu sa jacuatsasiati cuana jei ataina tse. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Betana su bacua mahue edhi puina tse, Elisabet jabuacuati bue mahue puina putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Beju Abías cuana sa jaturucati tsine cuinana su, Zacarías dharetana huecuana iyuda eti jude su enubi puji, Diusu butse su insensario neje ejudua puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Beju Zacarías ja ejuduatani tupu, pamapa cristiano cuana etseque su Diusu neje jamitsunetitanetina. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Da hora su Diusu sa ángel Zacarías peje su bataji puana. Bai eni bene altar su ángel neticuinana. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Angel ba putsu, Zacarías rubutanana. Cuaja pu taji mahue jabanetiatiana. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Da su ángel ja Zacarías uja atana: —Zacarías, be iyuame puji. Diusu ja mique jabajati id'abatana. Elisabet beju ebacuati. Tueda yanana Juan miada ebaniicha. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Metseda ebia su beidaji epu. Tueda yanana bataji epu su, jucuada cristiano cuana di beidaji eputa. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mique ebacua deja aida epu Diusu sa puji. Aimue vino tsetseda id'i bahue epu mahue. Tu bataji puji mahue jenetia Espíritu Santo sa tucheda mesa yani epu. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Tuahueda dueji israelita cuana Diusu peje su neicha esiapametayu. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Tueda da Echua Puji Jesucristo hui su epu. Tueda ebia su nimetucheda epu, cuaja profeta Elías chenu puidha nime. Tata cuana, mecuana sa ebacua cuana neje saida yameta. Diusu jei aja mahue cuana ebuetsuata Diusu sa jacuatsasiati cuana jei paata huecuana puji. Cristiano cuana ebasetata Echua Puji saida einatsu puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Daja ángel ja Zacarías atana. Da su Zacarías ja ángel uja quisabatana: —¿Cuaja ni da ye ai cuana pu cua? Etseju mu beju edhi. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Da su ángel ja Zacarías uja jubida jeutsutana: —Ema da Gabriel banime. Ema da Diusu sa ani jude butse su eneti tu emebaja puji. Diusu ja ema mi peje su beitutana ye quisa saida mi equisa puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Da su beju mida mimi bue mahue epu yanana bataji epu teje, miada quema jaquisati mue jei aitia putsu. Cuaja mi yama equisainia nime, beju daja epu. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Da cama beju, etseque su cristiano cuana ja Zacarías ecuinana id'uatanetina. Uja tuneda japibatitana: “¿Jucuaja su da ebia su etsunutani Zacarías?” ");
INSERT INTO tnaNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Beju Zacarías cuinana putsu, cuaja mitsu taji mahue cristiano cuana batana. Eme neje bahui shanapametana huecuana. “Zacarías tahui su nime jia da ai bataitia. Da putsu, cuaja mimi taji mahue ebatiani”, japibatitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Beju mesa mudumudu taji tsine cuana pupeana su, Zacarías mesa ete su jasiapatibana. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Quejucua tsine jaitianana su, beju Elisabet dheji puana. Pishica badi mesa ete jenetia mue cuinana puana. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Uja tueda japibatiana: “Diusu ja ema ibunebatana. Beju u jenetia su aimue cristiano cuana ema neje eid'ebatita mahue, ema bacuaji putsu.” ");
INSERT INTO tnaNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet sucuta badi dheji yani su, Diusu ja ángel Gabriel beitutana María peje su. María sa ete Nazaret ejude su anina. Tueda ejude Galilea yahua su anina. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Beju María deja shanapa bue mahue puina. José neje yahueti jamitsuti mesa anina. Tueda José da echua puji David chenu sa familia jenetia puina. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Beju ángel María naja su janariatiana putsu, uja atana: —María, yama mi equisainia, Diusu ja mi pia epuna cuana ebia su eibunebatani. Beju tueda mi neje yani. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Da su María nimetiuichana, ángel sa mimi id'aba putsu. Uja ángel quisabatana: —¿Jucuaja su mi ema daja emitsuinia? ");
INSERT INTO tnaNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Angel María jeutsutana: —María, be iyuame puji. Diusu ja mi dharetana. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Jiahue mida dheji epu. Piada ebacua mida ebacuinati. Tueda ebacua miada Jesús ebani eicha. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tueda da ebia su aida epu, Diusu Aida sa Ebacua putsu. Diusu ja tueda huaraji aida eichata. Echua puji David chenu puidha nime, daja Diusu ja tueda Echua Puji eichata. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Israelita cuana sa Echua Puji tueda epu ecuatsasiaenita huecuana puji. Tu ecuatsasiati aimue epupe mahue beju. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Da su María ja ángel quisabatana: —¿Cuaja ni da pu cua ye ai cuana, aimue ema deja shanapa bue mahue putsu? ");
INSERT INTO tnaNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Da su ángel ja María jeutsutana: —Espíritu Santo da mi peje su epue. Diusu Aida ja mi judu padha nime neje ebabuta. Da su beju tueda yanana bataji epu Diusu sa puji ichaderajiji epu. Diusu sa Ebacua epu. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mique edue puji Elisabet di bacuaji epu, punatia biame. Cristiano cuana, “Elisabet jabacuati bue mahue”, mimitaina biame, beju bacuaji epu. Sucuta badi tueda dheji beju. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Diusu sa puji mu mue ai biame atadhada mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Da su María ángel uja atana: —Ema da Diusu sa emebajaji. Daja Diusu ja ema paata, cuaja miada ema equisainia batame. Mimipe putsu, ángel putibana. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Beju quejucua tsine jaitianana su, María tipeida putiana Zacarías, Elisabet detse sa ejude su. Tueda ejude da Judea yahua emata chidi cuana duju su anina. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Dapia cuinati putsu, Zacarías sa ete su nubiana. Elisabet mitsutana. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabet ja María sa jamitsuti id'aba putsu, mesa edhe su yanana ruburubuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Da su Espíritu Santo ja Elisabet uja jubida quisametana: —Diusu ja mi pamapa pia epuna cuana ebia su ibunebatana. Mique ebacua di daja huecha ibunebatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Ai eni ema bata miada ema eperejeu puji, mida da quema Echua Puji sa cuara putsu? ");
INSERT INTO tnaNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Miada ema mitsuana su, quema yanana edhe su ruburubuana, tueda beidaji pu putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Beidaji mida, Diusu sa jaquisati su mi jei puana putsu. Pamapa Diusu ja mi quisatana cuana epupe. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Da su María uja puana: Yama Diusu emitsutsuainia. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Tuahueda ema beidaji ametana. Tueda da ema D'eji su Aji. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ema ai eni mahue papu biame, ema ibunebatana. Jiahue jenetia pamapa cristiano cuana quema puji saida emimita, ");
INSERT INTO tnaNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Diusu tucheda ja ai saida nimetiuda cuana ema peje su atana putsu. Tueda da saida, butsepi. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Pamapa tu eiyubatani cuana eibunebatani. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ai aida cuana atana. Ebia su aida jabatiji cuana pishitiametana. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Huaraji aida, tucheda eni cuana dajajametana. Beju nimemitsida cuana aida atana. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Diusu shanapaja cuana tusa ai cuana shanapameenitana. Diusu shanapaeni bahue epudhaatani cuana mu aiji mahue jusiaderatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Cuaja ecuana sa tata chenu cuana Diusu ja mesa jamitsuti ataidha batame, daja jiahue israelita cuana ibunebatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Abraham chenu mesa jamitsuti tiataidha uja: “Yama mida eibuneba. Pamapa mique bataji epusiu familia cuana di yama eibunebaeniti.” Da nime tu mebajaji israelita cuana tsahuatana, cuaja mesa jamitsuti tiataidha huecuana batame. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Da su María quimisha badi aniana Elisabet sa ete su. Da su beju jasiapatibana mesa ete su. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Beju Elisabet sa neda pu taji tsine cuinana su, deja janana bataji puana. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Pamapa Elisabet sa familia, tu naja su aniji cuana tu peje su putitana epereti puji. Diusu ja Elisabet ibunebatana bahue putana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Beju ocho tsine su yanana dusutana ehuitsanasiqui puji. Pamapa tuneda Zacarías ebani ichaja putana. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Beju Elisabet sa tsada mahue puana. Uja atana huecuana: —Mahue, Juan da banime epu quema yanana. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Da su cristiano cuana ja Elisabet uja atana: —¿Jucuaja su ni? Aimue piada biame mique familia cuana duju su Juan banime ani cua mahue. Beju bahue mida ecuana sa puiti. Etse sa familia quitaita sa ebani cuana jenetia dhare taji ebani eicha puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Da su beju tuneda seña neje Zacarías quisabatana uja: —¿Ai ebani mique tsada ebacua sa epu? ");
INSERT INTO tnaNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Da su Zacarías ja quirica su uja deretana: “Mesa ebani da Juan epu.” Da su pamapa su nimetiunetitana. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Da hora su beju neicha Zacarías mimipiruibana. Diusu sa puji saida mimipiruana. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tu naja su netiji cuana jubida nimetiunetitana. Tueda yahua je aniji cuana jaquisatitana cuaja puana ai cuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ebia su japibatitana huecuana ye ai cuana jepuiti. Huamahuama uja jaquisabatitana huecuana: —¿Ai deja jia ye yanana epu? Diusu sa tucheda Juan neje yani batana huecuana putsu, daja jaquisatitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Espíritu Santo Zacarías peje su pue putsu, uja mimiametana: ");
INSERT INTO tnaNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Beju pamitsutsuatija israelita cuana sa Diusu, ecuana peje su pueitia beju ecuana d'eji su ya puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ecuana Salvador tucheda tiatana. Tueda da David chenu sa familia jenetia. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Biahua tiempo Diusu ja mesa profeta chenu cuana uja quisaquisa ametaidha: ");
INSERT INTO tnaNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","“Yama Salvador ebeitu israelita cuana peje su tuna sa majai cuana peje jenetia d'eji su epu puji, tuna duininibaji cuana peje jenetia di d'eji su epu puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Aimue da yama eseta mahue quema tuna neje jamitsuti cuana. Beju yama eichenuba huecuana.” Daja Diusu sa profeta chenu cuana quisaquisa ametaidha. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Uja Diusu ja Abraham chenu mesa jamitsuti tiataidha: ");
INSERT INTO tnaNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","“Yama israelita cuana tuna sa majai cuana peje jenetia d'eji su yayu ema saida iyuame mahue neje pamebajata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Tuneda ema saida, butsepi neje pamebajata, eid'e yani tupu.” Daja Diusu ja Abraham chenu ataidha. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Beju quema ebacua chidi, mida Diusu aida sa quisaquisa puji epu. Echua Puji hui su mi epuniuneti cristiano cuana ebaseta puji, tueda saida pabatsuta huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Echua Puji ja mesa cristiano cuana d'eji su yatayu. Tuna sa jucha cuana eperdonatayu. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Beju Diusu ja daja ecuana yameta, tuahueda ecuana ebia su eibunebatani putsu. Tusa quisa saida cuana hueda nime cielo jenetia ecuana peje su. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Jucha su epuniuneti cuana Diusu ja mesa quisa saida cuana eshanapametayu. Emanu puji iyuame eputani cuana di eshanapametayu. Tuneseda puji tueda quisa saida cuana da hueda nime. Tuahueda ecuana enimepijajametayu. Quema ebacua chidi, pamapa ye ai saida cuana miada cristiano cuana eshanapame. Daja Zacarías satsuana mesa ebacua jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Beju yanana Juan saida, nimetucheda, jubida sehuana. Beju deja puana su, d'anita yahua su netina. Dapia tu mehua netina israelita cuana peje su quisaquisa epupiru teje. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Da tiempo su romano echua puji huaraji aida anina. Tueda Augusto banime puina. Tuahueda cuatsasiatana pamapa ejude cuana je censo paata puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Da tiempo su Siria yahua sa echua puji Cirenio banime puina. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Da su pamapa cristiano cuana tuna sa ejude cuana su jasiapatitana ebani quirica su eichameti puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Da putsu, José Galilea yahua su Nazaret ejude jenetia cuinanana María neje Judea yahua su eputi puji. Tuatseda Judea yahua su putiana Belén ejude su. Tueda ejude su David chenu bataji puidha. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","José da David chenu sa familia jenetia putsu, dapia putiana tse quirica su ebani eichameti puji. María neje ehuaneti jamitsuti mesa anina. Beju dheji puana María. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Belén su yani su, nedaji pu taji tsine mesa cuinana. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Dapia equene yanana mesa bataji puana. Beju edunuji neje babutana. Animalo cuana sa ete dume su yanana huanatana, tuatse cuinatiana ejude su quepia nubi taji mahue jabatiana tse putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belén ejude chu bene huisha quinaji cuana anitaina yahua nutsaji d'eji su. Dhidha su huisha cuana inatsihuataina huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Beju Diusu sa ángel tuna peje su bataji puana. Hueda jubida ja jurabatana huecuana putsu, ebia su rubutanatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Angel ja uja quisatana huecuana: —Be iyuame mepuji. Yama micuana ai saida cuana equisa. Pamapa cristiano cuana da beidaji epu, ye quema quisa saida id'aba putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Beju jiahue David chenu sa ejude Belén su micuana D'eji su Ahi bataji puitia. Tueda da Echua Puji Cristo. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Butsepi yama micuana equisainia. Meputique eba puji. Micuaneda eteje yanana dunujiji esa animalo cuana sa ete su. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Da su ángel ja quisapetana huecuana su, dueji ángel cuana di cielo jenetia bataji puana. Jubida Diusu mitsutsuatana huecuana uja: ");
INSERT INTO tnaNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Aida Tata Diusu papueni cielo su. Pamapa yahua su tu beidaji yametani cuana panimepijajameta. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Da su beju ángel cuana cielo su jasiapatitaibana su, huisha quinaji cuana uja huamahuama jaquisatitana: —Meputija Belén ejude su ángel ja jiahue quita ecuana quisataitia ai cuana ebati puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Da su tipeida putitana huecuana ejude su. Dapia animalo ete su cuinati putsu, María, José, yanana chidi esa beju batana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ye ai cuana ba putsu, ángel ja yanana jepuiti tuna quisatana ai cuana cristiano cuana quisapirutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Pamapa id'abatana cuana beju nimetiunetitana. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","María mue ai mimi biame pu. Cuatsa mahue japibatiana, huisha quinaji cuana daja mimitana id'aba putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Da su beju huisha quinaji cuana jasiapatitaibana. Diusu mitsutsuanataibana huecuana. Ebia su diusulupai Diusu atana huecuana, tueda ai nimetiuda cuana ba putsu. Cuaja ángel ja quisame atana huecuana batame, beju daja puana. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Beju ocho tsine su yanana dusutana tse ehuitsanasiqui puji. Jesús ebani ichatana yanana. María d eji puji mahue su, ángel ja Jesús ebani paichata atana. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Da tiempo su epuna cuana nedaji pu putsu, templo su ecuana sa puti taji erucuati puji, daja Moisés sa acuatsasiati cuana puina putsu. Da su beju yanana Jesús Jerusalén ejude su dusutana tse Diusu emenajatia puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Daja atana tse, cuaja Diusu sa quirica su derejiji yani batame. Beju uja derejiji yani: “Equene bataji epu ebacua da iusu sa puji ichaderajiji papu.” ");
INSERT INTO tnaNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Da su beju María sa jarucuati tiempo jaitianana su, Diusu peje su irutsuatitana, cuaja Diusu sa jacuatsasiati cuana puina batame. Huaitucu butseji ahua bid'id'i butseji tuatseseda irutsua taji puina. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Da tiempo su piada deja Simeón banime Jerusalén ejude su anina. Tueda deja saida puina. Diusu ebia su iyubataina. Diusu peje su janimeid'uatina Diusu ja israelita cristiano cuana d'eji su paata puji. Espíritu Santo da Simeón neje anina. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Tuahueda equene Simeón shanapametana Diusu sa Jabeituti Deja baji mahue aimue emanu mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Da su Espíritu Santo ja Simeón templo su nubiametana. Da hora su Jesús sa tata, cuara detse ja tu templo su dusutana Diusu sa jacuatsasiati yape puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón ja yanana Jesús ba putsu, jemitsuatana. Diusu uja mitsutsuatana: ");
INSERT INTO tnaNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Tata Diusu, beju ema pamanu, mique Jabeituti Deja baitia putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Beidaji ema, Salvador baitia putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Miada cristiano cuana bameana. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mi jepuiti judío mahue cuana ebuetsuata. Israelita cuana da beidaji eputa, tueda tuna sa Echua Puji aida epu putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Beju José, María detse nimetiuana, Simeón sa mimi cuana Jesús jepuiti id'aba putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Da su Simeón ja, “Diusu ja meibunebataque”, atana huecuana. Tuahueda María uja quisatana: —María, id'abaque ema. Ye yanana jepuiti ebia su israelita cuana castigo su epuenitita. Daja huecha pia cuana ebia su d'eji su eputa. Tueda da Diusu sa Jabeituti Deja putsu, jucuada tueda tsada mahue ebata. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Jucuada cristiano cuana sa etsia piba cuana ebametita. Pamapa tueda ai cuana ja mique muesumu enebameta. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Beju dapia templo su piada epuna punatia Diusu sa quisaquisa puji anina. Tueda Ana banime puina. Mesa tata Fanuel banime. Tueda da Aser sa familia jenetia puina. Epuneje quitaita su hue, jahuetiana. Siete mara hue jaquinatiana tse. Da su manuana mesa yahue. Mue neicha jahuetiyu puana. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ocho tunca pushi ejaitiana maraji puina. Cuinana bue mahue templo jenetia. Dapia Diusu mebajataina dhidha, tsine. Ayuna pu putsu, Diusu mitsu bahue puina. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Da su Simeón emimineti cama, Ana ja nariatana huecuana. Naria putsu, beidaji neje Diusu diusulupai apirutana. Diusulupai apetana su, yanana Jesús jepuiti beju cristiano cuana quisapirutana. Tueda cristiano cuana ja di Diusu sa Jabeituti Deja id'uataina israelita cristiano cuana d'eji su ya puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Da su beju jacuatsasiati cuana ape putsu, José, mesa familia chidi neje Galilea yahua su mesa ejude quitaita Nazaret su jasiapatibana. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Beju yanana Jesús saida, tucheda, bahue eni sehuana. Diusu ja tueda ebia su ibunebataina. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Pamapa mara José, María neje Jerusalén ejude su puti bahue puina pascua tsine ebati puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Beju Jesús piada tunca beta ejaitiana maraji su, mesa tata detse ja Jerusalén ejude su dusutana pascua tsine ebati puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tsine pupeana su, José, María Jerusalén ejude jenetia cuinanana Nazaret ejude su esiapati puji. Beju Jesús mu Jerusalén ejude su anitiana. Mesa tata detse bue mahue puina. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Tuatseda japibatiana Jesús cristiano cuana neje epubeyu pepe puana tse. Piada tsine jaitianana su, tuatseda Jesús chacupirutana tse eshanapa cuana duju su. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mue teje atana tse putsu, jasiapatibana tse Jerusalén ejude su Jesús echacu puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Quimisha tsine jenetia Jesús templo su tejetana tse. Dapia tueda netina Moisés sa jacuatsasiati ebuetsuaji cuana duju su. Quisaquisa punetina tuna neje. Daja huecha quisabatanetina huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tuna sa jaquisabati cuana saida jeutsutaina. Pamapa eid'abaji cuana nimetiunetitana, Jesús ja Diusu sa mimi shanapaenitana putsu, tueda bahue eni ba putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Beju mesa tata detse tu ba putsu, nimetiuana tse. Da su María ja Jesús uja quisabatana: —Quema ebacua chidi, ¿jucuaja su mida etseju daja aitia? Etseju mi ebia su chacudhaana. Chacudhaa putsu, ebia su pibapibana. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Da su Jesús ja jeutsutana tse: —¿Ai puji ni da metseda ema echacuinia? ¿Bue mahue jia maida metseda quema tata sa ai cuana quema a taji? ");
INSERT INTO tnaNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Beju Jesús sa mimi cuana tuatseda mue shanapa atana tse. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Da su tuatse neje Jesús jasiapatibana Nazaret ejude su, tuatse sa eme su hue tsuhu yani putsu. María ja mu pamapa tueda ai cuana enime su ichasetatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Daja tucheda, bahue eni sehuanetiame puana Jesús. Diusu ja tueda tsabatana. Pamapa cristiano cuana ja di Jesús tsabatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Da tiempo su Roma ejude su piada echua puji huaraji aida puina. Tueda da Tiberio banime puina. Piada tunca pishica ejaitiana mara jacuatsasaitiana beju. Da tiempo su Pilato Judea yahua sa romano huaraji aida puina. Herodes Antipas Galilea yahua sa echua puji puina. Mesa edue Felipe Iturea, Traconite yahua detse sa echua puji puina. Lisanias Abilinia yahua sa echua puji puina. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás, Caifás detse da pamapa sacerdote cuana sa echua puji aida puina. Da tiempo su Diusu Juan neje jamitsutina d'anita yahua su. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Juan da ejude meamea ena Jordán maje detse su puniunetina quisaquisa epu puji. Cristiano cuana peje su quisaquisa puana tuna sa piba cuana Diusu peje su papibaturucatita huecuana puji, Diusu peje su yahui neje paichaderatita huecuana puji. Daja tuneseda pu taji puina Diusu ja tuna sa jucha cuana paperdonata puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Biahua tiempo da Diusu sa quisaquisa puji Isaías chenu ja Juan jepuiti uja deretaidha: Piada etsui jubida d'anita yahua su uja epuani: “Mebasetatique Echua Puji epue su puji.” ");
INSERT INTO tnaNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Pamapa ebutsepiati da saida beju. Pamapa cuadhata emata cuana da epaipeti. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Pamapa turituri da ebutsepiati. Pamapa rudurudu da emedimediapeti. Diusu ja cristiano cuana d'eji su yata pamapa ja eshanapata. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Da su cristiano cuana Juan peje su putitana tuahueda. Diusu peje su yahui neje paichaderata huecuana puji. Beju Juan ja uja ataina huecuana: —Micuaneda da bacua d'aida cuana nime. Micuaneda ema peje su epusiu yahui neje Diusu sa puji eichaderameti puji Diusu sa castigo jubida jenetia ejududu puji. Beju micuaneda mu Diusu peje su japibaturucatija mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Equene mepibaturucatique Diusu peje su. Saida, butsepi mepuniunetique, yahui neje jaichaderametiji mahue su. Be ebia su aida mebatiji, micuaneda da Abraham chenu sa familia jenetia putsu. Tueda mu mue ai biame beju. Yama micuana butsepi equisainia, Diusu ja ye tumu cuana jenetia di Abraham chenu sa ebacua cuana ata cua, ahua tuseda tsada su. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Beju hacha basetajiji eneti aqui cuana eque puji. Pamapa aqui cuana ejaja saida pu bue mahue equepeta. Cuati su ed'ed'apeta pamapa. Daja Diusu ja yatayu tu peje su japibaturucatija mahue cuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Da su cristiano cuana ja Juan quisabatana: —¿Ai ni da ecuanaju da su a cua beju? ");
INSERT INTO tnaNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan ja jeutsutana huecuana: —Quebata sa beta ejud'uji yani, pia jud'uji mahue piada tia taji. Quebata sa ai dia taji cuana tupu yani, pia ai dia taji mahue sajatia taji. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Beju impuesto chujebajaji cuana di puetana yahui neje Diusu sa puji eichaderameti puji. Tuneda Juan quisabatana uja: —Ebuetsuaji, ¿ai ni da ecuanaju a cua? ");
INSERT INTO tnaNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Da su Juan ja jeutsutana huecuana: —Be mechujebajaji ebia su. Tupuajiji hue mechujebajaque, cuaja jacuatsasiati epuani batame. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Beju soldado cuana di puetana yahui neje Diusu sa puji eichaderameti puji. Daja huecha quisabatana huecuana: —¿Ai ni da ecuanaju a cua? Da su Juan ja jeutsutana huecuana: —Be memejemiji ai biame cristiano cuana. Be cristiano cuana icheja meaji chipilu emejemi puji. Be bid'umimi neje tuaquisaji cristiano cuana chipilu emejemi puji. Beidaji mepuque micuana sa echuje neje. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Beju Diusu sa Jabeituti Deja cristiano cuana ja ebia su id'uataina. Da putsu, “¿Juan jia da Diusu sa Jabeituti Deja?” japibatitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Juan ja beju uja quisatana pamapa huecuana: —Aimue ema mu Diusu sa Jabeituti Cristo mahue. Tueda mu ema tije epusiu. Enei hue yama micuana Diusu sa puji eichaderainia yahui neje. Beju tuahueda mu micuana Diusu sa puji eichaderata Espíritu Santo sa tucheda neje. Tueda da ema ebia su huaraji tucheda. Aimue ema tupu mahue tu emebaja puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tueda epusiu cristiano cuana arusu pu cua nime etsabihue puji. Ejaja chujemame eichaderata etsabi jenetia. Ejaja beju eichasetata tusa ichaseta jude ete su. Etsabi mu da cuati su ed'ed'ata. Beju pamapa tu peje su jei eputani cuana da ejaja nime. Diusu neje cielo su yanienititayu huecuana. Pamapa tu jei aja mahue yatani cristiano cuana da etsabi nime. Cuati castigo su epuenititayu huecuana. Dapia cuati da tiju bue mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Daja Juan ja cristiano cuana quisatana Diusu sa quisa saida cuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Echua puji Herodes Antipas d'ayatana, tusa edue Felipe sa ehuane Herodías neje jahuanetiana putsu, Felipe eid'e hue biame. Pia ai madhada cuana ataina bia su di Juan ja Herodes Antipas d'ayatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Beju Herodes Antipas ja Juan jei aja mahue atana. Pia ai madhada cuana daja hue aniame atana. Juan teriichametana. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Beju Juan terijiji mahue su, cristiano cuana Diusu sa puji ichaderataina yahui neje. Jesús di Juan peje su putiana Diusu sa puji yahui neje eichaderameti puji. Da su Juan ja Jesús ichaderatana Diusu sa puji. Jaichaderameti putsu, Jesús Diusu neje jamitsutiana. Jamitsutiana cama, cielo jadhatiana. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Espíritu Santo huaitucu nime bute putsu, Jesús bia su netiuteana. Da sa beju Diusu cielo jenetia uja puana: —Mida da quema ibuneda ebacua. Mi neje ema beidaji. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Beju José ja Jesús sehuametana. Jesús da quimisha tunca maraji su, beju quisaquisa pupiruana. Buetsuapirutana cristiano cuana. Ye cuana da Jesús sa familia chenu cuana sa ebani: José da Elí sa ebacua puina. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí da Matat sa ebacua puidha. Matat da Leví sa ebacua puidha. Leví da Melqui sa ebacua puidha. Melqui da Jana sa ebacua puidha. Jana da José sa ebacua puidha. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José da Matatías sa ebacua puidha. Matatías da Amós sa ebacua puidha. Amós da Nahum sa ebacua puidha. Nahum da Esli sa ebacua puidha. Esli da Nagai sa ebacua puidha. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai da Maat sa ebacua puidha. Maat da Matatías sa ebacua puidha. Matatías da Semei sa ebacua puidha. Semei da José sa ebacua puidha. José da Judá sa ebacua puidha. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá da Joana sa ebacua puidha. Joana da Resa sa ebacua puidha. Resa da Zorobabel sa ebacua puidha. Zorobabel da Salatiel sa ebacua puidha. Salatiel da Neri sa ebacua puidha. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri da Melqui sa ebacua puidha. Melqui da Adi sa ebacua puidha. Adi da Cosam sa ebacua puidha. Cosam da Elmodam sa ebacua puidha. Elmodam da Er sa ebacua puidha. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er da Josué sa ebacua puidha. Josué da Eliezer sa ebacua puidha. Eliezer da Jorim sa ebacua puidha. Jorim da Matat sa ebacua puidha. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat da Leví sa ebacua puidha. Leví da Simeón sa ebacua puidha. Simeón da Judá sa ebacua puidha. Judá da José sa ebacua puidha. José da Jonán sa ebacua puidha. Jonán da Eliaquem sa ebacua puidha. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquem da Melea sa ebacua puidha. Melea da Mainán sa ebacua puidha. Mainan da Matata sa ebacua puidha. Matata da Natán sa ebacua puidha. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán da David sa ebacua puidha. David da Isaí sa ebacua puidha. Isaí da Obed sa ebacua puidha. Obed da Booz sa ebacua puidha. Booz da Salmón sa ebacua puidha. Salmón da Naasón sa ebacua puidha. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón da Aminadab sa ebacua puidha. Aminadab da Aram sa ebacua puidha. Aram da Esrom sa ebacua puidha. Esrom da Fares sa ebacua puidha. Fares da Judá sa ebacua puidha. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá da Jacob sa ebacua puidha. Jacob da Isaac sa ebacua puidha. Isaac da Abraham sa ebacua puidha. Abraham da Taré sa ebacua puidha. Taré da Nacor sa ebacua puidha. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor da Serug sa ebacua puidha. Serug da Ragau sa ebacua puidha. Ragau da Peleg sa ebacua puidha. Peleg da Heber sa ebacua puidha. Heber da Sala sa ebacua puidha. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala da Cainán sa ebacua puidha. Cainán da Arfaxad sa ebacua puidha. Arfaxad da Sem sa ebacua puidha. Sem da Noé sa ebacua puidha. Noé da Lamec sa ebacua puidha. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec da Matusalén sa ebacua puidha. Matusalén da Enoc sa ebacua puidha. Enoc da Jared sa ebacua puidha. Jared da Majalaleel sa ebacua puidha. Majalaleel da Cainán sa ebacua puidha. ");
INSERT INTO tnaNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán da Enós sa ebacua puidha. Enós da Set sa ebacua puidha. Set da Adán sa ebacua puidha. Adán da Diusu sa ebacua puidha beju. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Da su Jesús Jordán ena jenetia jasiapatibana. Espíritu Santo ja tueda d'anita yahua su dusutana. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Dapia d'anita yahua su Jesús pushi tunca tsine aniana. Beju dhemanuana, pushi tunca tsine diadiaji mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Da su Ishahua pueana tu epiruba puji. Tuahueda Jesús uja atana: —Ahua mida Diusu sa ene quita ebacua su, cuatsasiaque ye tumu cuana ai dia taji cuana patsapiati. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Da su Jesús ja jeutsutana Ishahua: —Mahue. Aimue daja yama ya mahue. Uja derejiji yani: “Aimue cristiano cuana ai dia taji cuana bahui neje eid'e yanita mahue. Pamapa Diusu sa mimi neje di eid'e yanita huecuana.” ");
INSERT INTO tnaNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Da su Ishahua ja Jesús dusutana emata bauda matina su. Da jenetia pamapa ye mundo su ejude aida cuana Jesús bametana. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Uja Ishahua ja Jesús atana: —Pamapa ye ejude aida cuana da quema. Ye cuana yama inatsuidha. Aidhe biame detse yama tia cua ye ejude aida cuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Da su ahua mida ema butse su tururu putsu, ema emitsutsua su, yama mi etia pamapa ye ejude aida cuana miada ecuatsasia puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Da su Jesús ja Ishahua jeutsutana: —Netideraque ema naja jenetia, Ishahua. Diusu sa quirica su uja derejiji yani: “Mique Diusu bahui mitsutsua taji. Tueda bahui mique mebaja taji.” ");
INSERT INTO tnaNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Da su Ishahua ja Jesús dusutana Jerusalén ejude su. Templo matina su tsuatiana tse. Dapia tuahueda Jesús uja atana: —Ahua mida Diusu sa ene quita ebacua su, tenaque yahua su u jenetia, uja derejiji yani putsu: ");
INSERT INTO tnaNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Diusu ja ángel cuana ecuatsasiata mi painatsihuata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Tuna sa eme neje mi einatsuta huecuana mique ehuatsi tumu su edhapujuti mahue puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Da su Jesús ja Ishahua uja jeutsutana: —Aimue ema daja epu mahue. Daja huecha uja derejiji yani: “Be abaji mique Diusu.” ");
INSERT INTO tnaNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Da su beju Ishahua quejucua tiempo puji hue netiderana Jesús peje jenetia, mue cuaja piruba taji mahue ba putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús Galilea yahua su jasiapatiana. Espíritu Santo sa tucheda mesa anina. Pamapa tueda yahua su aniji cristiano cuana ebia su mimiana Jesús jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jesús ja cristiano cuana buetsuataina pamapa judío cuana sa jadhitati jude ete cuana su. Pamapa su tuseda puji saida mimitana. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Da su Jesús Nazaret ejude su putibana. Tueda ejude su sehuana. Beju janahua tsine cuinana su, jahitati jude ete su nubiana, cuaja tusa puiti batame. Nubi putsu, beju netianana Tata Diusu sa quirica jubida emimiame puji, pia cuana ja paid'abata puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Diusu sa profeta Isaías chenu ja deretaidha quirica beju menajatiatana huecuana. Da su uja mimiamepirutana: ");
INSERT INTO tnaNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Espíritu Santo sa tucheda quema yani. Diusu ja ema huaratiatana mesa quisa saida cuana quisaquisa epu puji cristiano puri cuana peje su. Ema beitutana ebia su epibapibatani cuana beidaji yameyu puji, jucha sa eme su yanita cuana d'eji su ya puji, padha cuana tuasaida yameyu puji, pamapa nedaneda ajiji cuana d'eji su ya puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Tuahueda ema cristiano cuana peje su beitutana Diusu ja jiahue tuneda d'eji su yataniyu equisa puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Daja mimipe putsu, quirica teritana. Jadhitati jude ete sa tsahuaji quirica tia putsu, beju aniuteana. Pamapa jadhitatijiji yanita cuana ja daja hue chamainiame Jesús atana. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Da su neicha Jesús mimipiruana. Uja quisatana huecuana: —Ye yama mimiameitia Diusu sa mimi cuana micuana butse su jiahue quita beju equitanainiayu. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Da su beju pamapa su saida mimitana Jesús sa puji. Nimetiunetitana huecuana, tusa mimi cuana da saida putsu. Tuneda cama uja jaquisabatitana huecuana: —¿Aimue jia maida ye José sa ebacua mahue? ");
INSERT INTO tnaNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús ja atana huecuana: —Micuaneda da ema quisaja uja: “Jaidueneti bahue su, mi mehua hue jaiduenetique. Cuaja mi Capernaum ejude su nimetiuda aida cuana ana nime, upia mique ejude su macha daja aque.” Daja micuaneda epibatiani. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jesús ja daja hue quisainiame atana huecuana uja: —Enei hue yama micuana equisainia, Diusu sa profeta aimue saida ebatsutani huecuana mahue tusa ejude quitaita su. Biahua tiempo Diusu sa profeta cuana aimue israelita cuana ja saida batsutaidha huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Madhada ahue manujiji cuana anitaidha, Diusu sa profeta Elías chenu eid'e su. Da tiempo su quimisha mara edusete aimue nai puidha mahue putsu, pamapa yahua je mid'e puidha. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Diusu ja aimue Elías chenu beitu israelita ahue manujiji peje su tuseda Elías patsahuata puji, israelita cuana ja aimue tueda saida batsutaidha mahue putsu. Beju Diusu ja Elías beitutaidha pia yahua jenetia epuna ahue manujiji peje su tuahueda Elías patsahuata puji. Tueda epuna israelita mahue puidha. Sarepta ejude su anidha Sidón ejude naja su. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Da tiempo su di madhada nedaji cuana Israel yahua su anitaidha. Dueji lepraji cuana anitaidha, Diusu sa profeta Eliseo chenu anidha su. Beju aimue tuneda mu piada biame saisiametaidha mahue, israelita cuana ja aimue Eliseo saida batsutaidha mahue putsu. Beju Eliseo ja piada israelita mahue deja bahui saisiametaidha. Tueda deja Naamán banime Siria yahua jenetia. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Da su pamapa jadhitatijiji cuana beju ebia su duininitana, Jesús sa quisa id'aba putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Netiana putsu, Jesús dusutana huecuana ejude tsahua su. Tueda ejude da emata bia su anina. Da su Jesús emata queque su dusutana huecuana. Da jenetia nunujusiauteja adhaatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jesús mu beju tuna duje jaitiana putsu, putibana. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Da su Jesús Capernaum ejude su putibana. Tueda ejude da Galilea yahua su anina. Dapia tuahueda cristiano cuana buetsuapirutana pamapa janahua tsine cuana su. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Beju cristiano cuana ebia su nimetiunetitana, Jesús ja huaraji aida mimi neje buetsuatana huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Dapia jadhitati jude ete su deja einid'u madhadaji anina. Tueda uja tsiatsiana: ");
INSERT INTO tnaNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Jesús, cuinanaque ecuanaju peje jenetia. ¿Ai ni da miqueda ecuanaju neje a taji? ¿A mida pueitia ecuanaju ecastiga puji? Yama mi eshanapainia. Mida da Diusu sa Ebacua. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Da su Jesús ja einid'u madhada jubida cuatsasiatana uja: —¡Mitanaque! ¡Cuinanaque ye deja peje jenetia! Da hora su einid'u madhada ja deja jusiautetana yahua su cristiano cuana butse su. Daja a putsu, deja peje jenetia beju cuinanana. Mue cuaja biame a deja. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Da su pamapa su rubutanatana huecuana. Tuneda cama uja jaquisabatitana: —¿Ai jabuetsuati cuana da ye? Ye Jesús ja einid'u madhada cuana huaru jubida cuatsasia bahue. Beju tuneda jei yatani. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Da putsu, pamapa tueda yahua je aniji cuana Jesús jepuiti bahue putana. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Da su beju Jesús jadhitati jude ete jenetia cuinanana. Simón sa ete su putiana. Ete su nubi putsu, Simón sa ehuane sa cuara ebia su nedaji saina batana. Dapia aniji cuana ja Jesús jubida bajatana epuna pasaisiameta puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Da su Jesús epuna naja su janariati putsu, neda jubida d'ayatana. Beju epuna saisiana. Da su netiana putsu, epuna saida bapirutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Beju id'eti enubihu su, tsapiapiati nedaji cuana dusupirutana huecuana Jesús peje su. Tuahueda mesa eme tuna bia su ichatana putsu, saisiametana huecuana pamapa. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Einid'u madhada cuana da jucuada nedaji cuana peje jenetia jusiacuinatana. Tueda einid'u madhada cuana uja tsiatsiatana: —Mida da Diusu sa Ebacua. Da su Jesús ja einid'u madhada cuana jubida d'ayatana pamitanata huecuana puji. Daja einid'u madhada cuana ja Jesús atana, tueda da Diusu sa Jabeituti Deja bahue putana huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Beju pia tsine apudaya Jesús ejude jenetia cuinanana tu mehua chujemame yaniti puji. Cristiano cuana ja tueda chacutaina. Tu peje su putitana huecuana su, Jesús nahueja adhaatana huecuana tuna peje jenetia eputi mahue puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Da su beju Jesús ja uja atana huecuana: —Diusu ecuatsasiati jepuiti da quema quisati taji yani pia ejude cuana su. Da puji ema Diusu ja beitutana. ");
INSERT INTO tnaNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Da su Jesús pamapa Galilea yahua je puniunetina. Diusu sa quisa saida cuana judío cuana sa jadhitati jude ete cuana je quisaquisa puana. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Beju pia tsine Jesús da Galilea bai maje su netina. Jucuada cristiano cuana tu eneti su cuinatana. Ebia su janariatitana putsu, janunununuatitana huecuana, Diusu sa quisa saida cuana id'abaja putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Beju canoa aida beta saina bai maje su memahue. Canoa emetse cuana ja tarrafa cuana bai maje su rucuatasaina. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Piada canoa Simón sa puina. Tueda canoa aida su Jesús nubiana. Da su Jesús ja Simón cuatsasiatana uja: —Nunuque canoa edume su pad'i yama da jenetia cristiano cuana equisa puji, d'eji mahue putsu. Beju da jenetia Jesús ja cristiano cuana buetsuapirutana. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Quisape putsu, Jesús ja Simón atana: —Canoa dusuque dueda su. Tarrafa siaque esia puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Da su Simón ja Jesús uja atana: —Ebuetsuaji, yanacane ecuanaju esia pudhidhaja. Mue ecuanaju ai biame jemitsua. Beju miada ema ecuatsasiainia putsu, yama tarrafa pasiaiti. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Beju eriretsuainia je, jad'iupirutiana tarrafa, se ebia su nubinetiana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Da su pia esia puji cuana pia canoa su ihuatana huecuana tuna patsahuata puji. Beju puetana huecuana. Jucuada se cuana jemitsuatana huecuana. Beta canoa aida sejeatana huecuana. Canoa detse que chidi hue aninubicueana, ebia su sejeajiji putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Beju Simón Pedro ja tueda ba putsu, Jesús butse su tururuana. Tuahueda uja Jesús atana: —Mida da ebia su saida. Ema mu juchaji putsu, saida mahue ema mi naja su eneti puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Daja mimiana Simón, ebia su rubutana putsu, nimetiuda aida batana putsu. Pamapa tu neje esia puji cuana di rubutanatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Simón sa ebuqueji Jacobo, Juan detse di rubutanana. Tuatse sa tata da Zebedeo banime puina. Da su beju Jesús ja Simón uja atana: —Be iyuame puji. Beju jiahue jenetia miada cristiano cuana eduse ema peje su. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Da su canoa aida detse murida su riretsua putsu, Jesús tije apirutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesús pia ejude su netina su, piada deja lepraji pueana tu eba puji. Jesús peje su cuina putsu, tu butse su d'epesatiana. Uja atana Jesús: —Echua Puji, ahua mique tsada su, miada ema saisiame cua. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Da su Jesús ja deja d'apaba putsu, uja atana deja: —Tsada quema mida esaisi. Beju Jesús daja epuani cama, deja lepraji saisiana. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesús ja tueda cuatsasiatana uja: —Be aidhe biame quisaji yama mi saisiameitia. Jiahue quita hue putique sacerdote peje su tuahueda mi saisijiji bataque puji. Da su beju Diusu irutsuaque, cuaja Moisés chenu sa jacuatsasiati epuani batame, pamapa cristiano cuana ja mida saisijiji pashanapata puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Beju cristiano cuana Jesús ja ai atana cuana bahue pupetana. Pamapa su tu peje su putija pudhaatana tusa mimi eid'aba puji. Nedaji cuana tu peje su dusuja adhaatana huecuana tuahueda pasaisiameta puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Beju Jesús mu quepia cristiano cuana mue ani su putiana Diusu neje emitsuti puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Pia tsine Jesús ja cristiano cuana buetsuatanina. Piada piada fariseo, jacuatsasiati ebuetsuaji cuana di dapia anitaina. Tuneda pamapa Galilea, Judea yahua jenetia puetana. Jerusalén ejude jenetia di beju puetana huecuana. Pamapa dapia aniji cuana ja Diusu sa tucheda batana, Jesús ja nedaji cuana saisiametana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jesús ja ete dume su cristiano cuana buetsuatanetina cama, pia deja cuana macha cuinatana. Deja ase bue mahue mapabetana huecuana. Ete dume su Jesús eneti su nubiameja adhaatana huecuana ase bue mahue Jesús butse su ehuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Cuaja nubi taji mahue jabatitana huecuana, d'eji mahue putsu. Da su beju ete epa pachata bia su ase bue mahue dusutsuatitana huecuana. Piada piada teja cuana dhiratana huecuana. Beju rara atana huecuana ete bia su. Tueda rara je chahui su deja ase bue mahue butemetana huecuana cristiano cuana duju su Cristo butse su. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesús beju nimetiuana, tueda deja cuana tu peje su ebia su enimetucheatiani ba putsu. Da su ase bue mahue uja atana: —Deja, mique jucha cuana yama perdonaitia beju. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Da su jacuatsasiati ebuetsuaji, fariseo cuana tuneda cama uja jaquisabatitana: “¿Ai deja jia ye? Tuahueda Diusu eduininiametani tusa mimi neje. Aimue aiya biame cristiano cuana sa jucha cuana perdonata cua mahue. Diusu ja bahui jucha cuana perdonata cua.” ");
INSERT INTO tnaNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Beju Jesús ja tuna sa piba cuana shanapatana putsu, uja quisatana huecuana: —¿Ai puji micuaneda daja madhada epibatiani? ");
INSERT INTO tnaNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ahua yama deja, “Mique jucha cuana yama eperdonainia”, ya su, ahua yama, “Netianaque, aseque”, ya su, beju quema puji mu tupupai hue. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Daja yama deja yainia micuana ebame puji, ye mundo su ema tucheda eni cristiano cuana sa jucha cuana eperdona puji. Da su Jesús ja uja deja nedaji cuatsasiatana: —Netianaque. Mique chahui jemitsuaque. Putiyuque mique ete su. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Daja yatani cama, beju ase bue mahue tuna butse su netianana. Tusa chahui jemitsuatana. Tusa ete su putibana. Diusu ebia su mitsutsuanataibana. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Pamapa dapia aniji cristiano cuana ebia su nimetiunetitana. Diusu mitsutsuatana huecuana. Iyuame neje tuneda cama uja putana: —Beju jiahue ecuaneda ai nimetiuda saida cuana baitia. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jesús da ete jenetia cuinana putsu, deja impuesto chujebajaji batana etseque su yani. Tueda da impuesto chujebaja jude su aniana. Tueda Leví banime puina. Da su Jesús ja uja tueda cuatsasiatana: —Tije ema aque. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Da su Leví netianana. Pamapa mesa ai cuana ichajusiatana Jesús neje epuniuneti puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Beju Leví ja Jesús sa puji tsine aida atana mesa ete su. Dapia tsine su jucuada deja impuesto chujebajaji cuana anitaina. Pia deja cuana di tuna neje anitaina. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Beju fariseo, jacuatsasiati ebuetsuaji cuana ja Jesús sa discípulo cuana jubida tuaquisapirutana, discípulo cuana deja juchaji cuana neje ediadiatani ba putsu. Uja tuaquisapirutana huecuana: —¿Jucuaja su ni micuaneda impuesto chujebajaji, juchaji deja cuana neje ediadiani? ");
INSERT INTO tnaNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Da su Jesús ja daja id'aba putsu, uja fariseo cuana jeutsutana: —Jaiduenetiji da aimue saida cuana sa puji mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nedaji cuana sa puji bahui. Aimue ema pue cristiano butsepi cuana eihua puji mahue. Beju ema pueana juchaji cristiano cuana eihua puji Diusu peje su papibaturucatita huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Da su beju fariseo cuana ja Jesús quisabatana: —Juan Bautista sa discípulo, fariseo sa discípulo cuana ebia su ayuna eputani. Templo su ebia su Diusu emitsutani huecuana. Mique discípulo cuana ja mu aimue daja yatani mahue. Pamapa tsine beju ediadiatani huecuana. ¿Jucuaja su ni daja yatani huecuana: ");
INSERT INTO tnaNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús ja jeutsutana huecuana: —¿Ai jahuaneti tsine su ihuajiji cuana ayuna puta cua bata, ehuanetisa deja tuna neje yani tupu? Ehuanetisa deja tuna neje yani tupu, ihuajiji cuana aimue ayuna eputa mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tueda ihuajiji cuana duju jenetia ejemicuinata su chu, da hora su ihuajiji cuana ayuna eputa, aimue tueda tuna neje yani mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Da su Jesús ja bahue quisa neje buetsuatana huecuana uja: —Aimue detse etse ejud'uji eichacua eped'u jemita cua mahue ejud'uji edhi eremetia puji. Ahua daja yata su, ejud'uji eichacua aimue saida epu mahue. Daja huecha ejud'uji edhi di aimue saida epu mahue, eped'u eichacua ejud'uji edhi neje aimue saida epu mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Daja huecha aimue vino eichacua etse emeji edhi su ichaseta cua mahue. Ahua daja etse a cua su, vino eichacua ja emeji epujuta. Da su vino, emeji neje tupupai taitana cua beju. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Da putsu, vino eichacua da emeji eichacua su ichaseta taji. ");
INSERT INTO tnaNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Daja a putsu, pamapa saida epu. Vino, emeji neje tupupai beju saida epu. Ahua quebata ja vino edhi eid'ita su, aimue vino eichacua tsada ebata mahue. “Edhi da ebia su saida”, tueda epu. Daja Jesús ja bahue quisa neje buetsuatana huecuana. Tusa jabuetsuati cuana da eped'u eichacua, vino eichacua nime. Fariseo cuana sa jabuetsuati cuana mu ejud'uji edhi, emeji edhi nime. Aimue huamahuama ehuaruti mahue. Jesús sa jabuetsuati eichacua cuana su etse jei epu su, aimue jabuetsuati edhi cuana tsada ebayu mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Pia janahua tsine su Jesús, mesa discípulo cuana neje d'ije duje ejaitianasa je, discípulo cuana ja eju cuana raridujudujuatana, dhemanu putsu. Ejaja iruruatana huecuana edia puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Piada piada fariseo cuana ja daja ba putsu, discípulo cuana tuaquisatana huecuana uja: —Daja a taji mahue janahua tsine su, jacuatsasiati cuana daja epuani putsu. ¿Jucuaja su ni micuaneda daja yainia? ");
INSERT INTO tnaNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Da su Jesús ja uja jeutsutana huecuana quisaba neje: —¿Aimue jia maida micuaneda mimiameana mahue cuaja David chenu ja ataidha mesa ebuqueji cuana neje, dhemanutaidha huecuana su? ");
INSERT INTO tnaNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tueda nubidha Diusu sa templo su pan iyuda edia puji. Ebuqueji cuana pan iyuda tiataidha padiata huecuana puji. Beju tueda pan iyuda mu sacerdote cuana sa bahui dia taji puidha. David chenu da dhemanu putsu, iyuda pan diataidha, jacuatsasiati aimue daja anidha biame. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Daja huecha ema da janahua tsine emetse. Quema bahui janahua tsine su ai a taji cuana cuatsasia taji, ema Diusu sa Jabeituti Deja putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pia janahua tsine su Jesús jadhitati jude ete su nubiana cristiano cuana ebuetsua puji. Dapia piada deja mechehui anina. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jacuatsasiati ebuetsuaji, fariseo cuana ja Jesús cuadhibatana ahua Jesús ja janahua tsine su deja mechehui esaisiameta, aimue aidhe sa biame janahua tsine su mudumudu taji mahue putsu, ahua Jesús ja daja yatani ba putsu, etuaquisa puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Beju Jesús mu bahue puana mecuana sa piba madhada cuana. Daja biame, deja mechehui uja atana: —Netianaque. Eduju su netitique. Beju deja daja netitiana. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Da su Jesús ja ebuetsuaji fariseo cuana uja atana: —Yama micuana equisaba. ¿Ai ni da su saida ya puji janahua tsine su? ¿Ahua saida janahua tsine su ai saida cuana ya puji? ¿Ahua ai madhada cuana ya puji? ¿Ahua saida janahua tsine su quebata d'eji su ya puji? ¿Ahua pamanu ya puji? ");
INSERT INTO tnaNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Da su Jesús ja bajusiapetana huecuana. Deja mechehui cuatsasiatana uja: —Piraraque mique ebai. Beju deja ja mesa ebai epiraratani cama, saisiana mesa eme. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Daja ba putsu, dapia enetita cuana beju jubida duininitana. Tuneda cama jaquisabatitana: “¿Jucuaja ni da ecuaneda Jesús manuameme a cua?” ");
INSERT INTO tnaNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pia tsine su Jesús murucu aida su putiana Diusu emitsu puji. Pamapa dhidha Diusu neje jamitsutiana. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Beju huenahua su ihuatana mesa discípulo cuana. Pamapa discípulo cuana duje jenetia piada tunca beta ejaitiana dharetana beju. Apóstol cuana banime atana. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Uja banime putana huecuana: Simón. Jesús ja Pedro ebani mesa ichatana. Andrés. Simón sa edue puana. Jacobo. Juan. Felipe. Bartolomé. Mateo. Tomás. Jacobo. Alfeo sa ebacua puana. Simón. Partido cananista banime su punetina. Tueda partido da soldado romano cuana neje jaicheti bahue putaina. Judas. Jacobo sa edue puana. Judas Iscariote. Jesús menajatiaji epu. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Da su beju Jesús apóstol cuana neje murucu aida jenetia buteana. Yahua pamapa su cuinatana huecuana. Jucuada cristiano cuana cuinatana tuna peje su. Judea yahua, Tiro, Sidón, Jerusalén ejude cuana jenetia cuinatana huecuana. Tuneda puetana Jesús eid'aba puji pasaisiameta huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Einid'u madhadaji cuana di Jesús ja saisiametana. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Pamapa su Jesús d'apabaja atana, tueda ebia su tucheda esaisiameji puana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Da su Jesús ja mesa discípulo cuana chama putsu, uja buetsuapirutana huecuana: —Nimebeidaji da Diusu ebia su shanapaja cuana, Diusu ecuatsasiati su yanienititayu huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","‘Nimebeidaji da Diusu peje su nimebutsepi puja putana cuana, Diusu ja tu peje su nimebutsepi yametayu huecuana putsu. ‘Epatani cuana, beidaji mepuque. Da su chu da micuaneda eid'ebati. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","‘Ahua cristiano cuana micuana eduininibata su, beidaji mepuque. Ahua etseque su micuana ejusiatani su, beidaji mepuque. Micuana emadhabatani su, beidaji mepuque. Ahua micuana mue ai eni mahue nime ebata huecuana su, beidaji mepuque. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ahua micuana daja yatani huecuana ema jepuiti su, da su ebia su beidaji mepuque, Diusu ja micuana cielo su pamapa ai saida etiatayu putsu. Beju daja da biahua tiempo cristiano madhada cuana ja Diusu sa profeta chenu cuana madhabataidha. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","‘Aba, chipiluji cuana, ye yahua su bahui beju beidaji eputani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","‘Aba, pamapa ai tupuji cuana, beju edhemanuta putsu. ‘Aba, jiahue quita eid'ebatiani cuana. Beju epibapiba putsu, ebia su epata huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","‘Aba, micuaneda, cristiano cuana micuaneseda puji saida emimitani biame. Daja biahua tiempo tata edhi chenu cuana profeta bid'umimi puji cuana sa puji putaidha. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","‘Beju ema eid'abatani cuana yama uja equisainia: Micuana duininibaji cuana ibuneda mebaque. Saida mebaque huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Micuana sa puji madhada hue emimitani cuana sa puji saida memimique. Micuana emadhabatani cuana sa puji Diusu mebajaque. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ahua aiya micuana ebuichetani su, bupe ebu di metiaque. Ahua aiya micuana sa saco emejemitani su, micuana sa camisa di tia taji. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ahua aiya micuana ai ebajatani su, metiaque hue. Ahua aiya micuana sa ai cuana emejemita su, be mechujebajaji. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Cuaja micuana sa tsada pia cuana ja micuana yata su, daja micuaneda di meaque huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","‘Ahua micuaneda micuana ibuneda ebatani cuana bahui ibuneda ebainia su, ¿ai puji saida ni da tueda pu cua? Beju Diusu shanapaji mahue cuana ja daja a bahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ahua micuaneda micuana ai saida yatani cuana bahui saida yainia su, ¿ai puji saida jia tueda pu cua? Beju Diusu tsada mahue cuana ja daja yatani. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ahua micuaneda pia cuana presta yainia micuana ai saida eturuca patiata huecuana puji, ¿ai puji saida jia tueda pu cua? Beju Diusu tsada mahue cuana ja daja yatani tuneseda puji ai saida cuana paata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Beju micuana duininibaji cuana micuaneseda ibuneda ba taji. Saida mebaque huecuana. Meprestaque huecuana. Be eturuca ai etiata huecuana meid'uaji. Diusu ja bahui micuana eturuca etiatayu beju. Daja a putsu, micuaneda Diusu ja yatani nime yayu, tueda da ebia su saida pamapa cristiano cuana neje putsu. Tusa ebacua cuana ebameti. Beju Diusu da ebia su saida cristiano saida, ate cuana neje. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Da putsu, micuana sa Tata Diusu nime micuaneseda saida pu taji. Pamapa cristiano cuana meichenubaque. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","‘Be pia cuana metuaquisaji. Ahua micuaneda pia cuana etuaquisa su, Diusu ja micuaneda eturuca etuaquisatayu, cuaja micuaneda pia cuana etuaquisainia nime. Beju micuaneseda perdona taji. Ahua micuaneda cristiano cuana eperdona su, Diusu ja micuana daja huecha yatayu. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Metiaque pia cuana. Ahua daja micuaneda ya su, Diusu ja micuana daja huecha ebia su quita eturuca etiatayu. Cuaja micuaneda pia cuana yainia nime, daja huecha Diusu ja micuana yatayu. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Daja Jesús ja buetsuatana huecuana. Pia bahue quisa neje uja buetsuatana huecuana: —Aimue detse padha ja pia padha huidusuta cua mahue. Ahua daja huidusuja yata su, da su betana su rara su edajajati tse. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Beju ebuetsuatiani da aimue mesa ebuetsuaji ebia su aida pu cua mahue. Jabuetsuapeti putsu, chu mesa ebuetsuaji nime pu cua. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","‘¿Jucuaja su ni da micuaneda pia edue sa etua su ai d'ape chidi echamainia? Beju micuana sa etua quitaita dume su aqui riji aida esa micuaneda aimue echamatiani mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ahua micuana sa etua su aqui riji aida esa su, ¿cuaja ni da micuana sa edue sa etua su ai d'ape chidi jemicuina cua? ¡Bubeta micuaneda! Equene tsuhu mejemique aqui riji aida micuana sa etua jenetia. Daja a putsu, saida eba ai d'ape chidi edue sa etua su esa ejemi puji. Beju micuaneda jucha aidaji putsu, pia jucha huai chidiji cuana aimue tuaquisa taji mahue. Equene tsuhu micuana sa jucha mebasetatique, pia cuana tuaquisaji mahue su. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","‘Beju pamapa equi saida cuana ejaja saida eputani. Daja huecha pamapa equi saida mahue cuana mu ejaja saida mahue eputani. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Pamapa equi cuana ejaja jepuiti etse eshanapainia. Aimue detse etse junu requerequeji jenetia ejaja saida huiru cua mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Deja saida da ai saida cuana bahui emimiani, mesa piba cuana saida putsu. Deja ate mu ai madhada cuana bahui emimiani, mesa piba cuana madhada hue putsu. Beju etse emimiani cuana da etse sa piba cuana jenetia. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","‘Micuaneda ema, “Echua Puji”, yainia biame, aimue quema jabuetsuati yainia mahue. Yanacane hue ema micuaneda, “Echua Puji”, yainia. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Quebata ja quema jabuetsuati yatani, tueda da ete a bahue deja nime. Tuahueda ete mudupirutana yahua saida bia su. Equene ete eti jude saida basetatana. Dapia ete atana. Da su beju ena aida nubiana su, jubida dhapujutana ete. Dhapujutana biame, beju aimue dajajame atana, yahua saida bia su ajiji putsu. Daja nime da quema jabuetsuati aji cristiano cuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Quebata ja mu quema jabuetsuati aimue yatani mahue, tueda da ete a bue mahue deja nime. Tuahueda ete mudutana yahua jutujutuji bia su. Beju ena aida nubiana su, jubida dhapujutana ete. Jubida dhapujutana putsu, ete dajajametana. Taitanapetana pamapa beju. Daja nime da quema jabuetsuati aja mahue yatani cristiano cuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesús ja cristiano cuana buetsuape putsu, Capernaum ejude su putibana. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Dapia piada romano capitán anina. Tueda da soldado romano sa echua puji puina. Tuahueda mesa emebajaji ebia su ibuneda bataina. Tueda emebajaji da emanu piba saina. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Capitán ja cristiano cuana id'abatana Jesús jepuiti emimitani. Da su beju piada piada judío deja edhi cuana beitutana Jesús peje su tu pabajata huecuana puji, capitán sa ete su Jesús paputi puji, mesa emebajaji pasaisiametita puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Beju tuneda Jesús naria putsu, bajapirutana huecuana uja: —Tueda capitán da deja saida. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Israelita cristiano cuana ebia su ibuneda ebatani. Tuahueda quitaita jadhitati jude ete ametana tuneseda puji. Da su saipie hue miada tueda etsahuati puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Da su beju Jesús tuna neje putiana. Capitán sa ete naja su ecuinatahu su, capitán ja mesa eshanapa cuana beitutana Jesús pamitsuta huecuana puji. Uja Jesús quisatana huecuana: —Echua Puji, ecuanaju sa capitán uja mi equisametani: “Ema mu aimue aidhe eni mahue quema ete su mida enubi puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Da putsu, mue ema puti mi peje su mi ebaja puji. Beju mi yani jenetia hue cuatsasiaque quema emebajaji pasaisi puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ya di quema echua puji sa jacuatsasiati ema su yani. Beju quema yani soldado cuana quema jacuatsasiati ema su di. Pamapa quema jacuatsasiati cuana yatani huecuana. Quema emebajaji cuana ja di quema jacuatsasiati cuana yatani. Da su ema bahue ahua miada u jenetia hue ecuatsasia su, quema emebajaji saisi cua. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesús ja tueda quisa id'aba putsu, nimetiunetiana. Mesa ebuqueji cuana uja atana: —Ene putsu, yama micuana equisainia, pamapa Israel yahua je aimue yama aidhe biame ye deja nime ba. Aimue aidhe biame Diusu peje su tu enimetucheatiani nime yama ba. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Beju capitán sa quisa puji cuana jasiapatitaibana su, emebajaji saida batana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Da su beju Jesús discípulo cuana neje Naín ejude su putiana. Jucuada cristiano cuana di tuna neje putitana. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ejude naja su Jesús ja jucuada cristiano cuana ejude jenetia ecuinanatani batana. Piada manujiji epapa puji edusutahu huecuana batana. Tueda manujiji da epuna ahue manujiji sa piada quita ebacua puina. Jucuada ejude sa aniji cristiano cuana ja buquetana. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Beju Jesús ja epuna ba putsu, bataichenu batana. Uja epuna atana: —Be paji. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Da su Jesús cajón naja su janariatiana. Beju d'apabatana. Da su cristiano cuana netisenatana. Jesús ja manujiji mitsutana uja: —Edeahue, ¡Netianaque! ");
INSERT INTO tnaNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Da su beju manujiji anitsua putsu, mimipiruana. Jesús ja edeahue tusa cuara menajatiatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Pamapa dapia netitana cuana ebia su iyuame putana. Diusu sa puji saida mimipirutana huecuana uja: —Beju piada Diusu sa profeta aida, tucheda bataji puitia ecuanaju duju su. Diusu beju buteitia mesa cristiano cuana etsahua puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Da su beju pamapa Judea yahua je bahue putana cristiano cuana tueda ai nimetiuda Jesús ja atana. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Beju Juan Bautista terijiji yani biame, pamapa Jesús ja atana cuana bahue puana, mesa discípulo cuana ja tueda pamapa saida quisatana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Da su Juan ja beta mesa discípulo detse Jesús peje su beitutana tu paquisabatita tse puji uja: “¿A da mida ecuanaju eid'uainia Diusu sa Jabeituti Deja, cuaja Juan Bautista quisa puana nime, ahua ecuanaju pia eid'ua?” ");
INSERT INTO tnaNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Da su Juan sa jabeituti detse Jesús peje su putiana. Jesús peje su cuinati putsu, uja quisabatana tse: —Juan Bautista ja etseju beitutaitia mi equisaba puji. ¿A pa da mida Diusu sa Jabeituti Deja, ahua mahue? ¿A da ecuanaju pia id'ua? ");
INSERT INTO tnaNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Beju Jesús ja nedaji cuana esaisiametasa hora cuinatiana tse. Pamapa nedaji, einid'u madhadaji, padha cuana esaisiametasa batana tse. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Da su Jesús ja jeutsutana tse uja: —Mequisatique Juan pamapa ai metse ebainia, eid'abainia cuana. Mequisatique yama padha cuana beju tuaji yainia. Turu cuana yasemeinia. Lepraji cuana esaisiameinia. Jaid'abati bue mahue cuana eid'abameinia. Manujiji cuana eid'e yameiniayu. Puri cuana peje su Diusu sa quisa saida cuana ema quisaquisa epuani d'eji su paputa huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mequisatique Juan be ema peje su panimetucheaderarijiti. Quebata ema peje su daja hue enimetucheaderati su, tueda da beidaji epu. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Da su Juan sa jabeituti detse jasiapatibana su, Jesús ja dapia netina cristiano cuana quisapirutana Juan jepuiti. Uja atana huecuana: —¿Ai eje ni da micuaneda putiana d'anita yahua su Juan peje su? ¿Ai eba puji micuaneda putiana? ¿Ahua bue enana beni ja ehuaidhutaneti nime eba puji micuaneda putiana? ");
INSERT INTO tnaNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Ahua deja ejud'uji chujeneda neje jud'ujiji eba puji micuaneda putiana? Beju deja ejud'uji chujeneda neje jud'ujiji cuana da echua puji sa ete aida su bahui yanita. Aimue d'anita yahua su yanita huecuana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Beju, ¿ai eba puji micuaneda d'anita yahua su putiana? ¿A da Diusu sa profeta micuaneda batiana? Enei hue, Juan Bautista da pamapa Diusu sa equene profeta chenu cuana ebia su aida. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juan jepuiti Diusu sa quirica su uja derejiji yani: Quema quisaquisa puji yama ebeitu mi hui su cristiano cuana pabasetatita mi epue su puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yama micuana ene putsu yainia, Juan Bautista da pamapa cristiano cuana ebia su aida. Beju daja biame, quebata huai chidi biame da Diusu ecuatsasiati su, tueda da Juan ebia su aida. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Da su beju dapia aniji cristiano, echujebajaji cuana ja id'aba putsu, tuneda cama, “Diusu da butsepi quita”, jaquisatitana. Equene Juan ja Diusu peje su ichaderatana huecuana yahui neje. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Beju dapia fariseo, jacuatsasiati ebuetsuaji cuana anitaina. Tuneda di Jesús sa quisa cuana id'abatana. Diusu sa ai cuana tsada mahue putsu, aimue Juan peje su jaichaderametitana huecuana mahue Diusu sa puji yahui neje. Juan da Diusu sa puji quisaquisa puana biame, aimue tsada mahue batana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Da su beju Jesús ja cristiano cuana uja atana: —¿Cuaja ni da jiahue tiempo cristiano cuana? ");
INSERT INTO tnaNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Tuneda da yanana chidi cuana etseque je esitutitani nime. Uja tsiatsia neje yatani huecuana mecuana sa eshanapa cuana: “Ecuanaju mui turuana micuaneda beidaji etiritiri puji. Beju micuaneseda tsada mahue puana, paja puana putsu. ¡Jade! Da su beju ecuanaju beidaji mahue satsu cuana satsuana micuaneda epa puji. Daja biame, micuaneda paja mahue puana, beidaji puja puana putsu. Beju ecuanaju micuana cuaja beidaji ame taji mahue ebainia.” Beju tueda jasitutiji yanana cuana nime jiahue tiempo cristiano cuana mu. Cuaja beidaji ame taji mahue huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Juan Bautista ja pia cristiano cuana neje aimue diadiaina mahue. Vino di aimue id'itaina mahue. Da putsu, micuaneda, “Juan einid'u madhadaji”, epuani. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Yama mu ai papu ediainia cristiano cuana neje. Vino di eid'inia. Da putsu, micuaneda, “Jesús da diadia aida, jaid'iti aida”, epuani. Micuaneda ema pa juchaji, echujebajaji cuana sa eshanapa epuani, ema tuna neje diadia bahue putsu. Beju micuana sa japitsati piba cuana da saida micuaneseda puji bahui. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Micuaneda etseju daja emadhabainia biame, etseju da Diusu sa piba saida cuana yainia, ebameinia. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Beju piada fariseo ja Jesús ihuatana mesa ete su ediadia puji. Jesús da tusa ete su nubi putsu, aniuteana. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Beju tueda ejude su piada epuna chuamadhada anina. Tueda epuna Jesús fariseo sa ete su yani id'aba putsu, dapia putiana tu eba puji. Emeji chidi dusutana. Emeji chidi su chujeneda saida puida badeina. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Da su Jesús peje su cuinati putsu, tusa ehuatsi bia su epuna turusatiana. Beju papiruana. Mesa tuana neje Jesús sa ehuatsi rucuapirutana. Mesa echuaina neje ehuatsi muriatana. Da su epuna ja Jesús sa ehuatsi budhi putsu, puida ehuatsi bia su d'uichatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Da su Jesús ihuaji fariseo uja japibatiana: “¿Ai puji ni Jesús ja ye epuna chuamadhada panariati yatani? Tueda da aimue Diusu sa ene quita profeta mahue. Ahua tueda da Diusu sa ene quita profeta pu cua su, da su aimue detse ye epuna nariameta cua mahue, tueda epuna chuamadhada putsu.” ");
INSERT INTO tnaNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Da su beju Jesús ja fariseo uja atana: —Simón, yama mi ai chidi quisaja. Simón ja Jesús jeutsutana: —Ebuetsuaji, quisaque hue ema. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Da su Jesús ja Simón uja atana: —Beta deja ja chipilu prestaji metse sa manu puina. Piada pishica nuati cien manume puina. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pia pishica tunca manume puina. Beju betana su cuaja chujetia taji mahue batana tse. Da su tueda chipilu prestaji ja perdonatana tse, tuatseda cuaja chujetia taji mahue batana putsu. Beju jeutsuque ema, ¿quebata tuatseda chipilu prestaji ibuneda ebia su quita ebata? ");
INSERT INTO tnaNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón ja Jesús jeutsutana: —Manu dueji puina ja ebia su quita ibuneda ebata, ema epibatiani. Jesús ja tueda atana: —Enei hue daja. Saida mi ema ejeutsuinia. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Da su Jesús ja epuna mehuitu putsu, Simón uja atana: —Chamaque ye epuna. Ema mique ete su nubiana su, aimue mi ema huatsirucuame. Ye epuna ja quema ehuatsi rucuataitia mesa tuana neje. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mesa echuaina neje muriataitia. Beju aimue miada ema budhitia mahue. Ye epuna ja mu quema ehuatsi daja hue budhiniame atana ema nubitia jenetia. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Aimue miada quema echua bia su aceite d'uichana mahue. Ye epuna ja mu puida quema ehuatsi bia su d'uichataitia. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Da su yama mi equisainia, ye epuna ja mesa ibuneda ema bametaitia, mesa jucha ebia su cuana yama perdonaitia putsu. Enei hue, quebata mesa jucha huai chidi perdonajiji, daja huecha huai chidi hue tuahueda ibuneda ebata. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Da su Jesús ja epuna atana: —Pamapa mique jucha cuana yama eperdonainia. ");
INSERT INTO tnaNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Beju pia ihuajiji yanita cuana uja tuneda cama jaquisabapirutitana: —¿Ai ni da tueda pia sa jucha cuana eperdona puji? ");
INSERT INTO tnaNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Da su Jesús ja epuna daja hue quisainiame atana: —Beju mi d'eji su puitia, ema peje su jei puitia putsu. Puchiditiyuque. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Da su beju Jesús puniunetiana pia ejude cuana je. Diusu ecuatsasiati jepuiti quisaquisa puniunetiana. Piada tunca beta ejaitiana apóstol cuana ja buquetana. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Piada piada epuna cuana ja di buquetana. Tueda epuna cuana beju equene nedaji, einid'u madhadaji putaina. Jesús ja saisiametana huecuana putsu, buquetana huecuana. Piada tuneda María Magdalena banime. Jesús ja tu peje jenetia siete einid'u madhada cuana jusiacuinatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Pia epuna di Juana banime puina. Tusa yahue Chuza banime puina. Tuahueda echua puji Herodes Antipas sa ai cuana quinataina. Pia epuna di Susana banime puina. Jucuada pia cuana di anitaina. Jesús, discípulo cuana tsahuataina huecuana ai dia taji cuana su tuna sa chipilu quitaita neje. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Pamapa ejude cuana jenetia jucuada cristiano cuana cuinanatana Jesús eba puji. Pia tsine jadhitatitana huecuana Jesús peje su. Bahue quisa neje Jesús ja buetsuapirutana huecuana uja: ");
INSERT INTO tnaNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Beju piada deja putiana ejaja cuana ehuararati puji. Ehuararatani cama, piada piada ejaja cuana edid'i je dajajatana. Da su beju tidhitidhiatana cristiano cuana ja. D'ia janana cuana pue putsu, beju edid'i je dajajatana ejaja cuana diapetana. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Pia ejaja cuana dajajatana tumu med'i pamuda mahue su. Beju tipeida huid'atatana. Med'i pamuda tsabida mahue putsu, beju sarapetana, huid'atatana cuana id'eti sinada puana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Pia ejaja cuana junu quid'aji cuana duju su dajajatana. Beju murutana cuana junu quid'aji cuana ja manuametana, babubabuatana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pia ejaja cuana mu med'i saida su dajajatana. Saida murutana. Dueji ejaja putana. Pamapa ejaja cuana cien ejaja teje putana. Jesús ja daja cristiano cuana quisape putsu, uja mimi jubida neje atana huecuana: —Ahua micuaneda id'ajararaji su, meid'abaque. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Da su mesa discípulo cuana ja Jesús quisabatana: —¿Jucuaja ni da mique bahue quisa epuani? ");
INSERT INTO tnaNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesús ja jeutsutana huecuana: —Diusu ja micuaneda bahui tu ecuatsasiati etsia ai quisa cuana eshanapametani. Pia cristiano cuana yama bahue quisa neje bahui ebuetsuainia. Tuneda echamatani biame, aimue ebatani huecuana mahue. Eid'abatani huecuana biame, aimue eshanapatani huecuana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","‘Beju yama micuana equisa cuaja ejaja cuana huararaji jepuiti quisa epuani. Ejaja cuana da Diusu sa quisa saida nime. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Edid'i je dajajatana ejaja cuana da Diusu sa quisa eid'abatani cuana nime. Ishahua pue putsu, tueda Diusu sa quisa cuana mecuana sa muesumu su yani emejemitani, Diusu peje su jei pu putsu, d'eji su paputa huecuana mahue puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Tumu med'i pamuda mahue su dajajatana ejaja cuana da Diusu sa quisa eid'abatani cuana nime. Quejucua hora puji hue beidaji neje jei eputani. Pia cuana tuna neje eduininitani su, Diusu peje jenetia enetideratani. Tuna putaina nime, neicha hue eputaniyu. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Junu quid'aji cuana duju su dajajatana ejaja cuana da Diusu sa quisa eid'abatani cuana nime. Daja biame, tuna puina nime su hue eputaniuneti. Ye mundo sa ai cuana bahui ebia su epibatani huecuana. Chipilu bahui mecuana sa nimeneda. Tuna sa ai utsatada madhada cuana bahui mecuana sa tsada. Pamapa tueda ai madhada cuana ja Diusu peje su janimetucheati cuana etaitanametani. Diusu sa quisa saida cuaja jucua taji mahue muesumu su. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Med'i saida su dajajatana ejaja cuana da Diusu sa quisa saida jei yatani cuana nime. Id'aba putsu, jei yatani huecuana. Diusu sa mimi tuna sa muesumu su ejucuapirutiani. Diusu peje su daja hue enimetucheaderatitani huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","‘Aimue detse etse hueda huitsu putsu, biateri cua mahue. Daja huecha tahui jude huaracha ema su netia cua mahue. Beju d'eji su netia taji ete pajurabata puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Pamapa ai rubuajiji cuana beju batasaida epu. Pamapa ai rubuajiji etsia piba cuana Diusu ja cristiano cuana eshanapameta. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","‘Meid'abaenique. Quebata ja Diusu sa piba shanapaja su, Diusu ja mesa piba cuana ebia su eshanapameenitayu. Quebata ja aimue shanapaja mahue su, Diusu ja tueda aimue ai biame eshanapameta mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Da su beju Jesús sa cuara, edue cuana tu eneti ete su cuinatana. Cuaja naria taji mahue batana huecuana Jesús, cristiano cuana ebia su dueji netitaina putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Da su piada ja Jesús uja atana: —Mique cuara, edue cuana etseque su enetita. Mi neje jamitsutija huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Da su Jesús ja dapia tu id'abaji cuana uja atana: —Diusu sa jabuetsuati eid'abatani, aja yatani cuana da quema cuara, edue cuana pu cua nime. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Pia tsine Jesús, mesa discípulo cuana neje canoa aida su nubiana. Tuahueda atana huecuana uja: —Meanipetutija chu maje. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Da su beju putitana huecuana. Yanipetutahu cama, Jesús tahuisatiana. Beni jubida pupiruana putsu, canoa dume su ena nubiametana. Beju sejepiruana putsu, nubicueana. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Da su Jesús id'edeatana huecuana. Uja atana huecuana: —¡Echua Puji! ¡Echua Puji! ¡Beju canoa yaninubiani! Jesús id'ecuina putsu, bai, beni d'ayatana. Da su mitanasaisiana pamapa. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tuahueda discípulo cuana atana: —¿Jucuaja su micuaneda Diusu peje su aimue enimetucheatiani mahue? Beju rubutana putsu, tuneda cama jaquisabatitana uja: —¿Ai deja jia ye? Beni ja biame tueda eid'abatani. Bai ja di tusa jacuatsasiati eiyubatani. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Beju chu maje Gadara banime yahua su satsuatiana huecuana. Tueda yahua Galilea yahua butse su anina. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Cuinatitana huecuana putsu, Jesús canoa jenetia cuinanana. Piada deja ja dapia ejude jenetia Jesús nariatana. Tueda einid'u madhadaji puina quejucua mara biame. Jud'uji mahue puniunetiana. Aimue ete su anija puina mahue. Panteo cuana duju su bahui ani bahue puina. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Quejucua nuati biame einid'u madhada ja tueda inataina. Dapia aniji cristiano cuana ja tueda cadena neje risirisia bahue putaina mesa eme, ehuatsi su. Beju tuahueda cadena tibitibiataina. Einid'u madhada ja tueda d'anita yahua su jududuametaina. Deja Jesús ba putsu, tu butse su d'epesatiana. Da su Jesús ja einid'u madhada uja cuatsasiatana: —¡Cuinanaque ye deja peje jenetia! Jesús ja daja cuatsasiatana su, deja einid'u madhadaji ja Jesús tsiatsia neje quisabatana uja: —Jesús, Diusu Aida sa Ebacua, ¿ai mique ema neje yani? Yama mi jubida ebajainia, be ema castigo su beituji. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Da su Jesús ja tueda quisabatana: —¿Ai ni mi banime? Tuahueda jeutsutana: —Ema Legion banime. Daja jajeutsutiana, dueji eni einid'u madhada cuana deja sa equita dume su anitaina putsu. Tueda ebani da Dueji Eni epuani. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Da su beju einid'u madhada cuana ja Jesús uja bajatana: —Be beituji ecuanaju castigo aida, apuda eni pupe bue mahue su. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Beju chuadera murucu su jucuada cuchi cuana diadianiunetitaina. Da su Jesús uja bajatana huecuana: —D'eji tiaque ecuanaju cuchi cuana sa equita su enubi puji. Da su beju Jesús ja d'eji tiatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Einid'u madhada cuana deja peje jenetia cuinana putsu, cuchi cuana sa equita cuana su nubitana. Nubitana cama, cuchi cuana jududutana bai su. Bai equehuehueji butsepi je dajajautetana. Beju pamapa huidipetana. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Cuchi quinaji cuana ja daja ba putsu, rubutanatana. Ejude su, te cuana je beju jududutana huecuana cristiano cuana equisati puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Da su cristiano cuana Jesús peje su putitana cuaja ai puana cuana eba puji Jesús yani su. Cuinati putsu, deja einid'u madhadaji puina saida, Jesús sa ehuatsi su jajud'uti yani batana huecuana. Da su beju iyuame pupirutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Dapia cuaja Jesús ja ataitia batana cuana ja pamapa butsepi quisatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Da putsu, cristiano cuana ja Jesús bajapirutana papuenitiyu tuna sa yahua jenetia, ebia su iyuame putana huecuana putsu. Da su Jesús canoa aida su nubiana eputiyu puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Deja saisijiji ja Jesús uja bajatana: —Dusuque ema. Mi neje putija ema. Beju Jesús ja tueda uja atana: ");
INSERT INTO tnaNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Mahue. Putiyuque mique edue cuana peje su. Cuaja Diusu ja mi saisiametana quisatique huecuana. Da su deja mesa ete su putibana. Pamapa ejude je quisa pupiruana Jesús ja cuaja ataitia cuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Beju Jesús anipetutibana chu maje. Dapia cristiano cuana ja beidaji neje tsutana, ebia su id'uatana huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Beju piada deja Jesús butse su d'epesatiana. Tueda Jairo banime puina. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Mesa piada ebaquepuna anina. Piada tunca beta ejaitiana maraji puina. Nedaji pu taji mahue saina. Da su deja ja Jesús bajatana mesa ete su paputi puji, ebaquepuna pasaisiameta puji. Da su beju Jesús putiana. Dueji cristiano cuana tu neje putitana d'eji mahue. Beju janunununuati putana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tuna duju su piada epuna nedaji putiana. Piada tunca beta ejaitiana mara mue mesa ami riji puja mahue puana. Jucuada jaiduenetiji cuana ja cuaja iduene taji mahue batana. Epuna ja pamapa mesa chipilu apetana. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tueda epuna ja Jesús etibeini bene nariatana. Jesús sa ejud'uji tihue d'apabatana. Da hora su beju mesa ami riji puana. Beju saisiana. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Da su Jesús ja uja quisabatana huecuana: —¿Aiya da ema d'apabataitia? Pamapa ja Jesús jeutsutana: —Mue mi aiya biame d'apaba. Beju Pedro ja Jesús uja atana: —Echua Puji, ebia su cristiano cuana ja mi yenunuyenunu yatani. ¿Jucuaja su miada daja equisabainia? ¿Aimue jia maida ye cristiano cuana ja mi ed'apabatani mahue? ");
INSERT INTO tnaNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Beju neicha Jesús ja atana huecuana: —¿Aiya da ema d'apabataitia? Jajinebataitia da ema aidhe saisitia quema tucheda neje, ema d'apaba putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Da su beju epuna Jesús butse su tururuana. Riariapiruana, Jesús ja cuaja tu atana shanapatana putsu. Pamapa cristiano cuana butse su epuna ja cuaja d'apabame atana Jesús quisapetana. Tu saisiana di quisatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Da su Jesús ja epuna atana: —Epuna chidi, ema peje su mi jei puitia putsu, beju mida saisitia. Puchiditiyuque beidaji. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Beju Jesús emimiani cama, piada deja cuinana Jairo sa ete jenetia. Tuahueda Jairo uja atana: —Mique ebaquepuna beju manuitia. ¿Ai puji detse yanacane puti cua Echua Puji? ");
INSERT INTO tnaNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Beju Jesús ja id'aba putsu, Jairo uja atana: —Be iyuame puji. Ema peje su bahui enimetucheati su, mique ebaquepuna beju esaisi. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Da su ete su cuinati putsu, Jesús sa tsada mahue puana cristiano cuana panubi. Pedro, Jacobo, Juan cuana, yanana sa tata, cuara detse bahui ete su panubi atana. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ete dume su pamapa su japadarititanina batana. Da su Jesús ja atana huecuana uja: —Be mepadaritiji. Epuneje mu aimue emanu mahue. Tueda mu etahuisa hue. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Beju jaid'ebatitana huecuana tu neje, yanana manuitia batana huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Da su beju Jesús ja yanana sa eme ina putsu, jubida cuatsasiatana: —Yanana chidi, netianaque. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Beju yanana id'eibana. Id'e putsu, netianana. Da su Jesús ja cuatsasiatana mesa tata detse uja: —Memihuaque yanana. ");
INSERT INTO tnaNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Yanana sa tata detse da ebia su nimetiunetiana putsu, Jesús ja cuatsasiatana tse uja: —Be aidhe biame mequisaji ai cuaja puitia cuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús ja mesa piada tunca beta ejaitiana discípulo cuana dhitametana. Huaratiatana huecuana pamapa ai einid'u madhada cuana cristiano cuana peje jenetia ejusiacuina puji, tsapiapiati nedaji cuana esaisiame puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Beitutana huecuana Diusu ecuatsasiati jepuiti quisa paputita puji, cristiano cuana esaisiame puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Uja Jesús ja cuatsasiatana huecuana: —Be eituneji, shitara, ai dia taji, chipilu cuana medusutiji. Beju equita su cama bahui ejud'uji medusutique. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Quebata ejude su cuinati putsu, piada ete su hue meanitique. Tueda ete su hue meanique ejude jenetia ecuinana teje. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Quepia micuana batsuja mahue yatani huecuana su, mecuinanaque tueda ejude jenetia. Cuinana putsu, metaraque tueda ejude sa med'i micuana sa pulucu jenetia Diusu tuna neje eduininiani pashanapata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Da su beju cuinanatana huecuana. Pamapa ejude su putitana huecuana. Diusu sa quisa saida quisaquisa putana huecuana. Nedaji cuana saisiametana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Echua puji Herodes Antipas bahue puana pamapa ai Jesús ja atana cuana. Tueda japitsapitsatiana, cristiano cuana ja Jesús jepuiti tsapiapiati quisatana huecuana putsu. Piada piada cuana, “Tueda da Juan Bautista id'eyujiji”, putana. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Pia cuana, “Diusu sa quisaquisa puji Elías chenu beju bataji puitia”, putana. Pia cuana, “Pia Diusu sa profeta chenu beju id'eitiba”, putana. Da putsu, Herodes Antipas ebia su japitsapitsatiana. Cuaja shanapa taji mahue batana. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Da su tueda puana: —Yama quitaita Juan chuarijiameana. ¿Aidhe jia da ye deja pamapa ai nimetiuda cuana yatani? Beju Herodes ja Jesús baja atana. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Apóstol cuana Jesús peje su jasiapatibana su, tuna pamapa ai atana cuana Jesús quisatana huecuana. Da su Jesús ja dusutana huecuana Betsaida ejude etsahua su cristiano cuana mue ani su, tuna neje bahui ubu hora chidi yani puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Beju ejude aniji cristiano cuana bahue pu putsu, Jesús peje su putitana huecuana. Da su Jesús ja batsutana huecuana. Diusu ecuatsasiati jepuiti quisapirutana huecuana. Nedaji cuana di saisiametana. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Beju tsinecua edhememehu su apóstol cuana ja Jesús uja atana: —Beituque ye cristiano cuana ejude cuana naja je tuna sa ai dia taji cuana pachacutita huecuana puji, beju upia mu mue ai biame ani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesús ja uja atana huecuana: —Micuaneda hue memihuaque huecuana. Da su Jesús jeutsutana huecuana uja: —Beju pishica pan chidi cuana, beta se chidi detse bahui ecuanaju sa yani. ¿Ahua mique tsada ecuanaju jana ebajati ye cristiano dueji cuana sa puji? ");
INSERT INTO tnaNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Beju pishica mil pucue deja cuana anitaina. Jesús ja discípulo cuana cuatsasiatana: —Cristiano cuana meaniutemeque dujiduji pishica tunca cama. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Beju daja atana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Pamapa cristiano cuana aniutetana su, Jesús ja pan cuana, se detse di inatana. Buepa huabata jachamati putsu, diusulupai Tata Diusu atana. Pan cuana, se detse ped'uped'ua putsu, discípulo cuana menajatiatana cristiano cuana paberereatiata huecuana puji. Discípulo cuana ja cristiano cuana eberereatiatani cama, pan, se ped'u cuana jajucuatitana. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Beju pamapa cristiano cuana diadiatana tupu. Pan cuana, se detse beju puchu puana. Eped'u cuana chudutana huecuana. Piada tunca beta ejaitiana d'iti cuana sejeatana huecuana puchu cuana neje. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Pia tsine Jesús discípulo cuana neje bahui aniana. Pia cristiano cuana beju aimue ani putana. Jesús da discípulo cuana chuadera tu mehua Diusu neje jamitsutiana. Jamitsupeti putsu, discípulo cuana peje su janariatiana. Uja quisabatana huecuana: —¿Cuaja ni da cristiano cuana ema jepuiti eputani? ");
INSERT INTO tnaNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Da su jeutsutana huecuana uja: —Piada piada mida pa Juan Bautista chenu id'eyujiji eputani. Pia cuana mida pa Elías chenu id'eyujiji eputani. Pia cuana di mida pa pia Diusu sa profeta eputani. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Da su Jesús ja quisabatana huecuana: —¿Aidhe ni da ema micuaneda epibatiani? Beju Pedro ja jeutsutana: —Mida da Cristo, Diusu sa Jabeituti Deja. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Da su beju Jesús ja discípulo cuana jubida cuatsasiatana: —Be aidhe biame mequisaji aidhe ema. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ema da Diusu sa Jabeituti Deja biame, ebia su sufri pu taji. Beju judío cuana sa ehuidusuji, sacerdote, huaraji aida, jacuatsasiati ebuetsuaji cuana ja ema jusiadera putsu, emanuameta huecuana. Quimisha tsine ejaitiana su, ema eid'eyu manujiji cuana duju jenetia. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Da su Jesús ja mesa discípulo cuana uja atana: —Quebata ja ema tije aja su, pamapa muesumu neje ema tije paata. Ema pamapa mesa ai cuana quitaita ebia su tsada pabata. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tusa manu teje ema tije paata, manuameja paata huecuana biame. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Ai puji saida ni da etse sa pamapa mundo sa chipilu cuana paani pu cua, cuati castigo su etse eputi biame? ");
INSERT INTO tnaNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Quebata da cristiano cuana butse su ema jepuiti, quema quisa cuana jepuiti di ebidhu su, ya di tu jepuiti ebidhu, ema esiapati su. Da su ema Echua Puji Huaraji Aida epu. Quema Tata Diusu sa gloria neje, pamapa tusa ángel cuana neje ema esiapati. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ene putsu, yama micuana equisainia, hue enetita piada piada cuana aimue emanuta tsuhu mahue Diusu ecuatsasiati ebayu teje. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ocho tsine beju jaitianana su, Jesús murucu aida bia su tsuatiana Diusu neje emitsuti puji. Pedro, Jacobo, Juan cuana ja buquetana. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Dapia Jesús Diusu neje emitsutiani cama, tuna butse su jabupiatiana. Mesa ejud'uji cuarecuare pasapasa puana. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Da su Elías, Moisés chenu detse bataji puana eid'e batana huecuana. Jesús neje quisaquisa epuani batana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Cuaja Jesús sufri pu putsu, emanu Jerusalén ejude su Jesús neje jaquisatiana tse. Hueda cuarecuare ja biababutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Beju Pedro, Jacobo, Juan cuana ebia su tahuija putana biame, id'etaniana huecuana, tueda quimisha deja sa hueda ba putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Moisés, Elías detse beju eputiyupiba epuani su, Pedro ja Jesús atana: —Echua Puji, saida ecuaneda upia pamapa su meanija. Quimisha epahuaneti cuana ecuanaju paaiti, ahua mique tsada su. Piada miqueda puji, piada Moisés sa puji, piada Elías sa puji ecuanaju paaiti. Pedro beju mue jashanapati cuaja emimiani, ebia su iyuame pu putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Daja Pedro emimiani cama, judu ja beju dunutana huecuana. Da su beju Pedro, Jacobo, Juan cuana ebia su iyuame putana. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Judu duju jenetia Tata Diusu ja atana huecuana uja: —Ye da quema ibuneda Ebacua. Tueda bahui meid'abaenique. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tata Diusu mimipeana su, beju Jesús tu mehua batana huecuana. Moisés, Elías detse aimue beju batana huecuana. Da su cuatsa mahue anitana huecuana. Mue aidhe biame quisatana huecuana mahue tuna batana ai cuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pia huenati murucu aida jenetia butetana huecuana. Ebutesa su, jucuada cristiano cuana ja Jesús tsutitana. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Piada deja ja cristiano cuana duju su Jesús jubida uja atana: —Echua Puji, chamaque quema piada quita ebacua. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Einid'u madhada ja tueda ina putsu, etsiatsiametani jubida. Tseitsi nime edajajametani. Equedi bahui purapura mesa ecuatsa su epuani. Tueda einid'u madhada ja quema ebacua emadhatani. Mesiaja mahue yatani. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Beju yama mique discípulo cuana bajaitia einid'u madhada pajemicuinata huecuana puji. Cuaja jemicuina taji mahue bataitia huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Da su Jesús ja anititana discípulo cuana d'ayapirutana uja: —¡Ai! ¿Jucuaja su jia micuaneda jei puja mahue? ¿Que tupu teje jia quema micuana neje ani taji? ¿Que tupu teje jia quema micuana etuchea taji? Meduseque edeahue mimi bue mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Edeahue janariatiana su, einid'u madhada ja dajajametana. Jubida edeahue riariametana. Da su Jesús ja einid'u madhada d'ayatana su, beju saisibana edeahue. Jesús ja deja tusa ebacua saida menajatiataibana. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Beju pamapa batana cristiano cuana ebia su nimetiunetitana, Diusu ebia su tucheda, aida batana huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Beju cristiano cuana enimetiutani cama, Jesús ja mesa discípulo cuana quisapirutana: —Meid'abaenique ema. Be mesetaji. Ema da Diusu sa Jabeituti Deja. Ema emenajatiata huecuana deja madhada cuana peje su pamanuameta huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Beju discípulo cuana ja Jesús sa quisa aimue shanapatana mahue, tuseda tsada mahue putsu. Iyuame putana huecuana tu equisaba puji cuaja mesa quisa epuani. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Da su beju discípulo cuana jacuicuinapirutitana. ¿Quebata jia tuna duju su ebia su aida? jacuicuinatitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Beju Jesús jashanapatiana daja yacuicuinatitani huecuana. Da su yanana chidi inachidi putsu, tu naja su ichatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Discípulo cuana uja atana: —Ye yanana da ema peje su jei eputani nimemitsida cuana nime. Quebata ja saida ebatsuta huecuana su, tuahueda ema ebatsutani pu cua nime. Daja huecha quebata ja ema ebatsuta su, tuahueda quema Tata Diusu ebatsutani pu cua nime, Diusu ja ema beitutana putsu. Quebata micuana duju su nimemitsida epuani su, tueda da ebia su aida micuana duju su epu. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Da su beju Juan ja Jesús uja atana: —Echua Puji, pia deja ja einid'u madhada cuana cristiano cuana peje jenetia ejusiacuinatani ecuanaju bana. Beju ecuanaju tueda, “Be daja aji”, ana, aimue tueda ecuanaju neje epuniunetiani mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Da su beju Jesús ja Juan uja atana: —Be tueda deja memenahueji. Quebata deja ecuana neje madhada hue epuani mahue, tueda da ecuana sa eshanapa beju. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesús cielo su eputi tiempo beju enariatiani putsu, janimetucheatiana Jerusalén ejude su eputi puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Equene tu hui su pia discípulo cuana beitutana. Piada ejude su Samaria yahua su cuinatitana huecuana tahui jude ete ebasetati puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Beju samaritano cristiano cuana ja dapia ejude su aimue Jesús batsuja atana mahue, tueda Jerusalén ejude su epuhu shanapatana huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Da su Jesús sa discípulo Jacobo, Juan detse ja daja id'aba putsu, Jesús uja atana tse: —Echua Puji biahua tiempo Diusu sa profeta Elías chenu ja cristiano madhada cuana cuati neje taitanamepetaidha. Beju jiahue, ¿a mique tsada ecuanaju Diusu ebaja cuati pabeituta puji, tueda samaritano cristiano cuana etaitanamepe puji? ");
INSERT INTO tnaNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Beju Jesús sa tsada mahua putsu, discípulo detse jubida d'ayatana, daja quisabatana tse su. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Da su pia ejude su putitana huecuana etahui puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Beju edid'i su tuna eputahu cama, piada deja ja Jesús nariatana. Uja tuahueda atana: —Echua Puji, mi yama tije aja quepia mi epuhu su. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Da su Jesús ja atana deja: —Cuacuacuacua cuana sa rara yanita. D'ia cuana sa esaji yanita. Beju quema mu ai mahue quepia echua epahuati puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Da su beju neicha Jesús ja pia deja atana uja: —Tije ema aque. Tuahueda Jesús atana uja: —Echua Puji, quema tata papa putsu chu, mi yama tije ya. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Da su Jesús ja atana: —Diusu shanapaji mahue cuana ja hue tuna sa manujiji cuana papapata. Miada mu puti putsu, Diusu ecuatsasiati epusiu ai quisa cuana cristiano cuana quisatique. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Beju pia deja ja macha Jesús uja atana: —Echua Puji, yama mi tije aja. Equene tsuhu d'eji tiaque ema quema ete su eputi puji, quema familia cuana neje emitsutitiyu puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Da su Jesús ja tueda uja atana: —Ahua quebata ema tije yapirutani biame, jasiapatija epu su, tueda saida mahue Diusu emebaja puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Da su beju Jesús ja siete tunca deja cuana dharetana. Beta beta beitutana huecuana tu hui su tu eputi ejude cuana je. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Uja cuatsasiatana huecuana: —Enei hue, dueji yani ehuiru puji biame, ehuiriji cuana beju pishihue. Cristiano cuana da ejaja esuru ehuiru puji quitaita nime. Diusu da huiruhuiru emetse nime. Mebajaque tueda mesa quisaquisa puji cuana cristiano cuana peje su pabeituta puji, mesa quisa saida cuana tuna peje su quisaquisa epu puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Beju meputique. Yama micuana cristiano madhada cuana peje su ebeituinia. Micuaneda da duqueji cuana iba cuana duju su nime epu. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Be shitara, chipilu medusuji. Piada pulucu butseji bahui medusutique. Pime hue meputique. Be aidhe biame memitsuji edid'i su. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Quebata ete su nubi putsu, uja ete emetse cuana memitsutique: “Diusu ja menimepijajametaque.” ");
INSERT INTO tnaNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ahua tueda ete su cristiano saida cuana yanita su, da su micuana sa jamitsuti da tuneseda puji paaniti beju. Ahua dapia cristiano saida mahue cuana yanita su, da su micuana sa jamitsuti mejemiyuque. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Quebata ejude cuinati putsu, piada ete su hue mecuinatique. Tueda ete su hue meanique ejude jenetia ecuinana teje. Mediaque, meid'ique tuna sa ai dia taji, id'i taji cuana, tuneseda mihua taji, micuaneda da Diusu sa mudu puji cuana putsu. Be ete ete measeji. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ejude su cuinati putsu, ahua micuana cristiano cuana ja saida ebatsutani su, tuna etiatani ai dia taji cuana mediaque. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Dapia nedaji yanita cuana mesaisiameque. Uja mequisatique: “Beju Diusu ecuatsasiati enariatiani.” ");
INSERT INTO tnaNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ahua quebata ejude su aniji cuana ja aimue micuana saida ebatsuta mahue su, mecuinanaque ejude duje. Uja jubida cristiano cuana mequisaque: ");
INSERT INTO tnaNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Micuana sa ejude sa med'i chidi ecuanaju sa pulucu cuana jenetia ecuanaju etarasaisisaisia. Uja ecuanaju yainia, micuaneda ecuanaju sa quisa jusiaderana putsu. Meshanapaenique, Diusu ecuatsasiati enariatiani.” Daja micuaneseda pu taji. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Enei hue, yama micuana yainia, Diusu sa castigo tsine ecuina su, Diusu ja tueda ejude su aniji cristiano cuana Sodoma ejude su anitaidha cristiano cuana ebia su ecastigatayu. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","‘¡Aba quitaita Corazín, Betsaida ejude detse su aniji cristiano cuana. Tueda ejude detse su dajucua ai nimetiuda cuana yama ana biame, aimue Diusu peje su japibaturucatija putana huecuana mahue. Ahua Diusu ja biahua tiempo Tiro, Sidón ejude detse su tueda nimetiuda aida cuana ataidha su mu detse, dapia anitaidha cristiano cuana Diusu peje su japibaturucatitaidha detse. Tuna sa jucha cuana jepuiti ebia su janimepibapibametitaidha detse. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Diusu sa castigo tsine ecuina su, Diusu ja Corazín, Betsaida ejude detse su aniji cuana Tiro, Sidón ejude detse su anitaidha cuana ebia su ecastigatayu. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Daja huecha Diusu ja Capernaum ejude su aniji cuana yatayu. “Diusu ja ecuana cielo su edusutsuatita”, eputani huecuana biame, beju Diusu ja cuati castigo su ebeituta huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Da su beju Jesús ja discípulo cuana atana: —Quebata ja micuana jei yata su, tuahueda ema jei yatani pu cua nime. Daja huecha quebata ja micuana ejusiaderatani su, tuahueda ema ejusiaderatani pu cua nime, yama micuana beituana putsu. Daja huecha quebata ja ema ejusiaderatani su, tuahueda Diusu ejusiaderatani pu cua nime, Diusu ja ema beitutana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jesús ja siete tunca beitutana deja cuana beju jasiapatitana tu peje su. Jasiapati putsu, uja Jesús atana huecuana: —Echua Puji, einid'u madhada cuana ja ecuanaju iyubatana, mique ebani su ecuanaju cuatsasiana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Da su Jesús ja atana huecuana: —Beju yama Ishahua bana cielo jenetia edajajani dharara nime. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yama micuana tucheda tiana bacua, asi ja aimue micuana cuaja biame yata mahue puji, einid'u madhada cuana ja aimue micuana cuaja biame yata mahue puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Be beidaji mepuji, ahua einid'u madhada cuana micuana eiyubatani su. Ebia su beidaji mepuque, micuaneda da Diusu sa dharejiji cuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Da hora su beju Espíritu Santo ja Jesús beidaji ebia su ametana. Jesús ja mesa Tata Diusu uja mitsutana: —Quema Tata, yama mi emitsutsuainia. Mida da aida eni. Mida da cielo, mundo emetse. Nimemitsida cuana bahui miada shanapameana mique piba cuana. Bahue eni ebatitani cuana mu aimue shanapameana mahue mique piba cuana. Daja mique tsada. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","‘Quema Tata Diusu ja ema pamapa ai cuana menajatiatana. Aimue ema aiya biame saida eshanapaenitani mahue. Quema Tata Diusu ja bahui ema saida eshanapaenitani. Daja huecha aimue quema Tata Diusu aiya biame eshanapaenitani mahue. Yama bahui tueda saida eshanapaeninia, ema tusa ebacua putsu. Quebata quema tsada cuana bahui quema Tata Diusu yama eshanapameinia. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Da su Jesús ja discípulo cuana chama putsu, uja atana huecuana: —Quebata cuana ja ema ebatani, beidaji eputani. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Biahua tiempo Diusu sa profeta, echua puji chenu cuana ja jiahue micuaneda ebainia cuana baja adhaataidha. Jiahue quema micuaneda eid'abainia quisa cuana di id'abaja adhaataidha huecuana. Beju cuaja a taji mahue bataidha huecuana, biahua tiempo jenetia anitaidha putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Pia tsine beju piada Moisés chenu sa jacuatsasiati ebuetsuaji Jesús peje su putiana mimi neje tu yaba puji cristiano cuana butse su. Tuahueda Jesús quisabatana uja: —Echua Puji, ¿ai ni da quema a taji cielo su eid'e yanieniti puji? ");
INSERT INTO tnaNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús ja deja jeutsutana uja: —Quisaque ema, ¿cuaja ni da derejiji yani Moisés chenu sa jacuatsasiati cuana su? ");
INSERT INTO tnaNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Da su jacuatsasiati ebuetsuaji ja Jesús jeutsutana: —“Ibuneda baque Diusu pamapa mique muesumu neje. Cuaja mida quitaita ibuneda ebatiani nime, daja mique pia cuana ibuneda ba taji.” Daja derejiji yani. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Da su Jesús ja tueda uja atana: —Saida mida jajeutsutaitia. Ahua miada ye jacuatsasiati ya su, da su cielo su mida eid'e yanienitiyu beju. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ebuetsuaji ja Jesús quisabatana neicha: —¿Quebata jia quema edue? ");
INSERT INTO tnaNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Da su Jesús ja bahue quisa neje jeutsutana deja uja: —Piada deja Jerusalén ejude jenetia cuinanana Jerico ejude su eputi puji. Edid'i je tu epuhu cama, tsi puji cuana ja tueda inatana. Pamapa mesa ai cuana mejemipetana huecuana. Madhada iche putsu, beju cuataibana huecuana. Deja manuamecue putsu, jahuijati jusiahuanatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Beju piada sacerdote edid'i je jaitianana. Deja ichenu esa batana biame, sacerdote butsepi hue pejaitianatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tije beju piada deja jaitianana. Tueda da templo sa etsahuaji puina. Deja ichenu esa batana biame, tueda di butsepi hue pejaitianatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Da su beju piada samaritano deja edid'i je jaitianasaina. Tuahueda deja ichenu esa ba putsu, bataichenubatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Beju nariatana deja. Etsi cuana babutana. Mesa animalo quitaita bia su ichatsuatana. Tu ecuinati ete su dusutana. Dapia quinatana deja. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pia huenati samaritano eputiyu puji ete emetse chipilu tiatana. Chipilu ete emetse tia putsu, uja atana: “Quinaque ye deja ichenu. Ahua manu yanidera su, ema esiapati su, yama mi echujetia.” ");
INSERT INTO tnaNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Da su Jesús bahue quisa neje quisape putsu, uja jacuatsasiati ebuetsuaji quisabatana: —¿Quebata tueda quimisha deja cuana edue nime jadusutiana deja ichenu neje? ");
INSERT INTO tnaNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Beju jacuatsasiati ebuetsuaji ja Jesús jeutsutana: —Tueda samaritano ja deja ichenu quina putsu, edue nime batana. Da su Jesús ja ebuetsuaji uja atana: —Jade, miada daja huecha atique. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús da discípulo cuana neje pia ejude su cuinana. Dapia beta epuna edue tatse Marta, María banime anina. Tuatseda Jesús batsutana tse. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Beju María Jesús sa ehuatsi su aniuteana tusa quisa eid'aba puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta mu daja hue mudumudusana, ebia su mesa ai a taji cuana anina putsu. Da su Marta ja Jesús nariatana tu uja equisa puji: —Echua Puji, quema edue María ja aimue ema etsahuatani mahue. Cuatsasiaque beju tueda ema patsahuata puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Da su Jesús ja Marta jeutsutana: —Marta, Marta, mique ai a taji cuana ja mi ebia su epibapibametani. ");
INSERT INTO tnaNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","María ja ebia su saida quita dharetaitia, quema mimi cuana id'abaja ataitia putsu. Aimue yama tueda emejemiyu mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Pia tsine Jesús Diusu neje jamitsutianina. Beju jamitsupetiana su, mesa discípulo cuana ja tueda bajatana uja: —Echua Puji, Juan Bautista ja mesa discípulo cuana bahuetsuatana cuaja Diusu neje jamitsutime. Beju ecuanaju di daja buetsuaque. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Da su Jesús ja buetsuapirutana huecuana: —Uja micuaneda Diusu mitsume ya: Ecuanaju sa Tata Diusu, cielo su yani, mique ebani cristiano cuana ja paiyubata. Cuatsasiapiruenique ye mundo su. Mique ai tsada cuana bahui cristiano cuana ja ye mundo su paata, cuaja cielo su aniji cuana ja yatani nime. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Pamapa tsine ecuanaju tiaque ai dia taji cuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Perdonaque ecuanaju sa jucha cuana, cuaja ecuanaju madhada aji cuana eperdonainia nime. Be ecuanaju Ishahua peje su pirubameji. Tusa eme jenetia d'eji su ecuanaju aque. Daja papu. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Uja Jesús ja daja hue buetsuainiame atana huecuana bahue quisa neje: —Piada deja putiana dhidha dusete mesa eshanapa sa ete su pan ebajati puji. Uja bajatana: ");
INSERT INTO tnaNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","“Eshanapa, tiaque ema quimisha pan cuana, pia quema eshanapa beju quema ete su cuinaitia putsu. Mue ai biame quema ani tu etia puji.” ");
INSERT INTO tnaNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Da su eshanapa ja ete dume jenetia uja jeutsutana: “Cuaja tia taji mahue mi yama ebainia, beju terisaisiajiji putsu. Quema ebacua cuana neje ema etahuisa. Cuaja netiana taji mahue tsuhu ema mi etia puji.” ");
INSERT INTO tnaNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Jesús ja bahue quisa quisape putsu, daja hue quisainiame atana huecuana uja: —Yama micuana butsepi equisainia, tueda deja ja daja hue mesa eshanapa bajanetiame atana mesa eshanapa ja pan tiatana teje. Beju tueda eshanapa ja pan etiata pacuayu puji. Aimue eshanapa su mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Da putsu, yama micuana butsepi equisainia, Diusu micuaneda ebaja su, tuahueda micuana etiatayu. Da su memebajaque Diusu. Beju mechacuderaque. Chacu putsu, micuaneda etejeyu. Meturubaderaque. Turuba putsu, etsequed'iatiyu. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","‘Ahua micuana sa ebacua cuana ja pan ebajatani su, ¿ai da micuaneda tumu etia bata? Ahua micuana sa ebacua cuana ja se ebajatani su, ¿ai da micuaneda bacua etia bata? ");
INSERT INTO tnaNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ahua micuana sa ebacua cuana eja ebajatani su, ¿ai micuaneda asi etia bata? ");
INSERT INTO tnaNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Micuaneda deja juchaji cuana biame, micuana sa ebacua cuana ai saida cuana tia bahue. Beju Diusu mu da ebia su saida putsu, tu bajaji cuana ebia su ai saida cuana tia bahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Pia tsine Jesús ja deja mimi bue mahue peje jenetia einid'u madhada jusiacuinatana. Jusiacuinatana su, beju deja mimiana. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Piada piada deja madhada cuana ba putsu, tuneda cama uja jaquisatitana: —Ye Jesús da aimue Diusu peje jenetia mahue. Beju einid'u madhada cuana cristiano cuana peje jenetia ejusiacuinatani Ishahua sa tucheda neje. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Pia cuana ja Jesús bajatana nimetiuda aida Diusu peje jenetia paata puji. Daja Jesús bajatana huecuana tu yaba puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesús ja tuna sa piba madhada cuana shanapa putsu, uja atana huecuana: —Ahua quebata huaraji aida sa cristiano cuana esajasajata su, ahua tuneda cama eichetita su, beju tueda huaraji aida sa tucheda etaitanapeyu. Daja huecha quebata familia edue cama eichetita su, tueda familia da etaitanape. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Daja huecha ahua Ishahua ja quitaita mesa einid'u madhada cuana jusiata cua su, mesa tucheda etaitanape. Aimue mesa einid'u madhada quitaita ejusiata mahue. Ahua daja yata su, tueda quitaita emajaitiani pu cua nime. Beju micuaneda, cristiano cuana peje jenetia yama einid'u madhada cuana ejusiacuinainia Ishahua sa tucheda neje, epuani. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ahua daja su, ¿aidhe sa tucheda neje micuana sa ebuqueji cuana ja einid'u madhada cuana ejusiacuinatani? Jiahue yama micuana equisaba. ¿Aimue jia maida Diusu sa tucheda neje einid'u cuana ejusiacuinatani huecuana mahue? Da su, ¿jucuaja su micuaneda, yama einid'u madhada cuana Ishahua sa tucheda neje ejusiacuinainia, epuani? Micuana sa ebuqueji cuana ja ebametani micuaneda da japitsatijiji. Aimue yama Ishahua sa tucheda neje einid'u madhada cuana cristiano cuana peje jenetia ejusiacuinainia mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Yama einid'u madhada cuana ejusiacuinainia Diusu sa Espíritu Santo sa tucheda neje bahui. Diusu ja mu tueda ai nimetiuda cuana yatani micuana duju su. Aimue Ishahua ja tueda ai nimetiuda cuana ema yametani mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","‘Deja tucheda metseji sa ai cuana beju aimue aiya biame tsita cua mahue, mesa ete saida ebianetiatani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ahua pia deja ebia su tucheda quita pue cua su, tuahueda upia yani deja pishitiameta cua. Tusa metse, pamapa tusa ai cuana pishitiame putsu, mejemita cua. Daja huecha ema Ishahua ebia su tucheda tu epishitiame puji, tusa einid'u madhada cuana ejusiacuina puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","‘Quebata ja aimue ema saida ebatani mahue, tueda da ema neje emajaitiani. Daja huecha quebata ema neje echuduchuduani mahue, tuahueda eberebereatani. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","‘Einid'u madhada deja peje jenetia ecuinanani su, d'anita yahua je yaseni janahua jude echacu puji. Aimue teje yatani su, epibapirutiani uja: “Ema pasiapati ema cuinanaitia ete su.” ");
INSERT INTO tnaNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Da su beju deja peje su esiapatiani su, tueda deja da ete saida, memahue, basetajiji nime ebatani. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Da su neicha ecuinana pia siete tu ebia su madhada einid'u cuana eduse puji. Beju pamapa su deja sa equita dume su enubitani dapia yaniti puji. Da su tueda deja equene puina ebia su madhada epuani. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús daja emimiani cama, piada epuna uja tsiatsiana: —¡Diusu ja mique cuara paibunebata, tuahueda mi sehuametana putsu! ");
INSERT INTO tnaNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Da su Jesús ja epuna atana: —Beju ebia su saida Diusu ja mesa mimi id'aba putsu jei yatani cuana paibunebata. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Beju cristiano madhada cuana ebia su jadhitatisana Jesús peje su. Tuahueda daja hue quisainiame atana huecuana uja: —Beju micuaneda da deja madhada, bubeta cuana. Micuaneda ema ebajainia yama nimetiuda aida ya puji. Aimue yama ya mahue. Cuaja Diusu sa profeta Jonás chenu puidha, tueda da micuaneseda puji nimetiuda aida papu. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Da tiempo Jonás chenu quitaita nimetiuda ai cuana ataidha Níneve ejude su anitaidha cristiano cuana sa puji. Daja huecha jiahue ema quitaita da nimetiuda aida nime epuani ye tiempo cristiano cuana sa puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Biahua tiempo echua puji aida epuna uqueda yahua jenetia pueidha echua puji Salomón chenu peje su mesa bahue eni quisa cuana eid'aba puji. Beju jiahue upia ema Salomón chenu ebia su bahue eni biame, aimue micuaneda quema quisa id'abaja yainia mahue. Da putsu, Diusu ja micuana ematsetayu castigo tsine su, micuaneda quema bahue eni quisa cuana id'abaja mahue ana putsu, cuaja tueda echua puji aida epuna ja Salomón chenu sa bahue eni quisa cuana id'abataidha nime. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nínive ejude su anitaidha cristiano cuana ja di ye tiempo cristiano cuana etuaquisata Diusu sa castigo tsine ecuina su. Da tiempo su Nínive ejude su anitaidha cristiano cuana peje su Jonás Diusu sa quisa cuana quisaquisa puidha su, pamapa tuneda Diusu peje su japibaturucatitaidha. Jiahue quita beju upia ema yani Jonás chenu ebia su aida epuani biame, ye cristiano cuana ja aimue ema id'abaja yatani mahue. Da putsu, Diusu ja ebia su ecastigata huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","‘Aimue detse aiya biame hueda huitsu putsu, biaterita cua mahue. Beju d'eji su hueda eichata ete dume pajurabata puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Micuana sa etua da lámpara nime micuana sa equita sa puji. Ahua micuana sa etua saida su, saida echamati. Ahua micuana sa etua saida mahue su, aimue saida echamati mahue. Daja huecha ahua micuaneda ai madhada cuana su bahui epibatiani su, apuda saida su micuaneda epuniuneti. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Merejatique be micuana sa hueda padhamuti. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ahua micuana sa equita saida, hueda, apuda mahue su, da su beju pamapa saida ebati lámpara sa hueda ja micuana ejurabatani nime. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Beju Jesús ja buetsuapetana huecuana su, piada fariseo ja Jesús mesa ete su dusutana ediadia puji. Ete su cuinati putsu, Jesús nubiana. Misha su aniuteana jamerucuatiji mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Da su fariseo nimetiunetiana, Jesús jamerucuatiji mahue ediadiani ba putsu. Fariseo daja nimetiunetiana, judío cuana sa puiti diadiaji mahue su emerucuatitani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Da su Jesús ja tueda jubida d'ayatana uja: —Micuaneda da emeji dume adhida pu cua nime, ebia je bahui saida, rucuajiji. Micuaneda di ebia je bahui saida nime. Edume su mu ai piapiati madhadaji micuana sa yani. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Aimue micuaneda epibatiani mahue Diusu ja equita neje tupupai enid'u di atana. Micuaneda equita bahui rucua bahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Enime dume su di mebasetatique. Da chu beju pamapa rucuapejiji epu. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","‘¡Aba, fariseo cuana, micuaneda bubeta putsu! Pamapa micuana sa enubiani ai cuana sa piada décimo chidi hue eichaderainia Diusu sa puji biame, butsepi punuineti ai cuana esetainia. Ibuneda mahue micuaneda. Aimue micuaneda pia ebia su saida jabuetsuati cuana ebuetsuainia mahue. Aimue cristiano cuana Diusu butse su butsepi paputa puji ebuetsuainia mahue. Aimue ebuetsuainia huecuana mahue huamahuama paibunebatita huecuana puji. Aimue ebuetsuainia huecuana mahue Diusu peje su panimetucheatita huecuana puji. Tueda ai saida cuana di micuaneseda buetsua taji yainia pia Moisés sa jacuatsasiati cuana neje tupupai. Beju aimue micuaneda mu daja yainia mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","‘¡Aba micuaneda fariseo cuana! Micuaneseda tsada jadhitati jude ete cuana su aniude ebia su saida cuana su anija bahui. Ejude duje micuaneseda tsada cristiano cuana ja micuana iyuda neje emitsuta. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","‘¡Aba micuaneda fariseo, jacuatsasiati ebuetsuaji cuana! ¡Micuaneda da bubeta cuana! Micuaneda da sepulcro bataji mahue edume su ebadeta ai adhida cuana nime. Cristiano cuana da bia je yasetani su, enid'umadhatitani huecuana. Daja huecha cristiano cuana enimemadhatitani, micuana sa ai puiti madhada cuana tije a putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Da su piada jacuatsasiati ebuetsuaji ja Jesús atana uja: —Echua Puji, miada ecuanaju di emadhabainia tueda mimi neje. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús ja tueda uja atana: —¡Aba micuaneda jacuatsasiati ebuetsuaji cuana di! Micuaneda cristiano cuana Diusu sa ebani su jubida neje ebia su ai cuana yameinia. Micuana sa jacuatsasiati cuana da tadada cristiano cuana ja yata puji. Daja pia cuana jubida neje yameinia biame, micuaneda mu aimue daja dhucuana yainia mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","‘¡Aba micuaneda! Micuana sa tata chenu cuana ja Diusu sa profeta cuana manuametaidha. Beju jiahue micuaneda tuna sa sepulcro cuana saida yainia. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Da neje saipie hue daja manuametaidha huecuana ebametiani. Micuaneda da tata edhi chenu cuana neje tupupai. Tuneda profeta cuana manuametaidha. Beju micuaneda sepulcro cuana yainia. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","‘Da putsu, Diusu bahue eni uja puidha: “Yama quema profeta, apóstol cuana ebeitu micuana peje su. Beju micuaneda ebia su eduinini tuna neje. Piada piada micuaneda emanuame. Pia cuana tijetije ya.” ");
INSERT INTO tnaNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Micuana peje su cama Diusu sa enime epu, profeta cuana manuametaidha huecuana jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Manuamejiji putaidha profeta cuana da Abel jenetia Zacarías teje micuaneda peje su cama Diusu sa enime epu. Zacarías da tije enieni manuametaidha huecuana altar iyuda eti jude detse dhede je su. Yama micuana butsepi equisainia, Diusu ja micuana echujebajata tuna sa manu jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","‘¡Aba micuaneda jacuatsasiati ebuetsuaji cuana! Micuaneda Diusu sa mimi buetsuaja yainia biame, aimue micuaneda tueda mimi eshanapainia mahue. Pia cuana di micuaneda aimue butsepi eshanapameinia mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Da su beju Jesús daja mimipeana su, fariseo, jacuatsasiati ebuetsuaji cuana tu neje ebia su duininipirutana. Jesús ebia su quisabapirutana huecuana madhada piba neje. ");
INSERT INTO tnaNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Uja japibatitana huecuana: “Cuapuitime madhada hue Jesús ejeutsuti su, beju ecuaneda tuaquisa cua.” ");
INSERT INTO tnaNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Beju ebia su dueji cristiano cuana Jesús yani su jadhitatitana. Dueji huecuana putsu, janunununuati putana huecuana. Da su Jesús ja mesa discípulo cuana quisapirutana uja: —Merejatique fariseo cuana neje, tuneda da bubeta putsu. Madhada ai cuana yatani huecuana rubuajiji. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tuna sa ai madhada cuana da levadura harina bebajiji su nime. Levadura ja bebajiji etutsuametani nime, daja da tuna sa ai piba madhada cuana batasaida ebametita. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Pamapa tuna sa etsia piba madhada cuana ebametita. Pamapa ai etsia piba neje ajiji ai cuana Diusu ja ebameta. Pamapa etsia quisa cuana Diusu ja cristiano cuana eshanapameta. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","‘Quema eshanapa cuana, be ate cristiano cuana butse su iyuame mepuji. Micuana manuameta cua huecuana biame, aimue micuana sa enid'u mu cuaja madhada ata cua mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Diusu bahui meiyubaque. Tuahueda equita manuameta putsu, cuati castigo su etse beituenita cua. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","‘Beju pishica d'ia janana beta chipilu chidi chuje. Chujeneda mahue biame, aimue Diusu ja esetatani mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Micuaneda beju d'ia janana cuana ebia su chuje eni Diusu butse su. Aimue tuahueda micuana esetatayu mahue. Pamapa micuana sa echuaina cuana idadajiji. Piada piada cama Diusu ja eshanapatani. Da su be iyuame mepuji, micuaneda da Diusu peje su d'ia janana cuana ebia su chujeji putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","‘Ahua quebata quema puji cristiano cuana butse su saida equisanetiacuinati su, yama di ángel cuana, Diusu butse su tuseda puji saida equisanetiacuina. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ahua quebata cristiano cuana butse su ema tsada mahue ebata su, yama di ángel cuana, Diusu butse su tueda tsada mahue eba. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","‘Pamapa ema madhabaji cuana Diusu ja perdonata cua, Espíritu Santo madhabaji cuana mu aimue Diusu ja perdonata cua mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","‘Beju deja madhada cuana ja duinini putsu, micuana jadhitati jude ete cuana su, huaraji aida cuana butse su ema jepuiti edusuta su, be ebia su mepibapibaji cuaja micuaneda jeutsume ya. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Da hora su Espíritu Santo ja cuaja micuaneda ejeutsuti puji mimi cuana etiata. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","‘Da su beju pia deja ja cristiano cuana duju su Jesús uja atana: —Echua Puji, cuatsasiaque quema edue etseju sa tata chenu sa ai cuana quema tupu pasajatiata. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Da su Jesús ja tueda atana uja: —¿Aiya ni da ema mique ai cuana ebaji ichatana? ");
INSERT INTO tnaNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jesús ja daja hue quisainiame atana huecuana: —Merejatique. Ye mundo sa ai cuana be ebia su tsada mebaji. Aimue ai cuatajuse tsada mahue saida etse yani puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Da su Jesús ja bahue quisa neje buetsuatana huecuana: —Beju deja chipiluji saida anina. Jucuada mesa te cuana anina. Puiti eni mesa te cuana puana. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Da su japibapirutiana uja: “Beju quema ete chidi cuana da tupu mahue pamapa quema ejaja cuana eichasetati puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Da su quema ete chidi cuana ebereberea pia eichacua aida ya puji. Dapia pamapa quema ejaja cuana yama eichaseta. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Da su quema pamapa ai cuana tupu epu quejucua mara puji putsu, beidaji ema epu. Ejanahua da ema. Eid'iti, ediadia da ema.” ");
INSERT INTO tnaNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Beju Diusu ja tueda deja atana: “Deja, aimue mida saida epibatiani mahue. Ye dhidha quitaita su mida emanu. Da su beju pamapa mique ebia su ichasetajiji ai cuana, ¿aidhe sa puji ni da epu?” ");
INSERT INTO tnaNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Daja da quebata ja tuseda puji bahui ebia su ai cuana edhitatani. Chipiluji biame, Diusu sa ai cuana su mu pia puri. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","23","‘Be ebia su mepibapibaji ai dia taji, ejud'uji cuana jepuiti. ¿Ai puji saida ye ai cuana jepuiti ebia su epibapiba puji? ");
INSERT INTO tnaNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mechamaque d'ia janana cuana. Banabana, huirujiji ejaja cuana ichaseta bue mahue ta biame, Tata Diusu ja emihuatani huecuana. Micuaneda mu d'ia janana cuana ebia su chujeme Diusu peje su. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Aimue detse etse ebia su bauda bauna cua mahue, pibapiba putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Daja huecha aimue detse etse sa ai dia taji cuana ani cua mahue, ebia su pibapiba putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","‘¿Ai puji ni da micuaneda ejud'uji jepuiti ebia su epibapibani? Mechamaque shasha cuana. Ania chidi emurutani mudu bue mahue, badu bue mahue ta biame. Beju yama micuana ene putsu equisainia, aimue echua puji Salomón chenu jajud'utidha ania shasha cuana nime mahue, tueda da ebia su chipiluji puidha biame. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Shasha neje Diusu ja nutsa ania chidi yatani. Beju jiahue quita nutsa shasha neje ania chidi. Mueta beju sarajiji cuati puji bahui saida epuani. Mepibatique nutsa cuana su. Ahua Diusu ja nutsa cuana ania chidi shasha neje yatani su, ¿aimue jia maida micuana Diusu ja ejud'utayu mahue? ¿Jucuaja su ni da micuaneda Diusu peje su aimue enimetucheatiani mahue? ");
INSERT INTO tnaNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Da su be ebia su mepibapibaji ai dia taji, ejud'uji cuana jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Daja Diusu peje su jei eputani mahue cuana pu bahue. Beju micuaneda mu da aimue daja epu mahue, micuana sa aimue ai cuana Tata Diusu bahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Equene Diusu bahui tsada mebaque. Tu butse su nimebutsepi bahui tsada mebaque. Ahua micuaneda daja ya su, Tata Diusu ja micuana pamapa ai saida cuana etiatayu. Be ebia su mepibapibaji micuaneda cuaja mueta epu cuana su. Tsine meamea Diusu ja micuana etsahuatayu. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","‘Quema ibuneda cuana, be iyuame mepuji. Micuaneda da quejucua chidi biame, Diusu ja micuana ecuatsasiameta tu neje tu ecuatsasiati su. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Meiruque micuana sa ai cuana. Aiji mahue cuana metiaque. Daja a putsu, Diusu ja micuana pamapa ai saida cuana etiata cielo su. Dapia da aimue micuana sa ai biame ehueiti mahue, aiya biame etsita mahue, musu ja emadhatiata mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Quepia micuana sa ai saida cuana eradaneti su, dapia da micuaneda anija epu. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","‘Meid'abaenique ema. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Emebajaji ja mesa echua puji eid'uatani nime, mepuque. Echua puji jahuaneti tsine jenetia esiapati su, mesa ete su ecuinatiyu su, emebajaji sa id'eni taji tu etsequed'ia puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Echua puji beju esiapati su, emebajaji beidaji epu, echua puji ja tu eid'eni ehuacuinata putsu. Daja huecha echua puji di beidaji epu. Echua puji quitaita ja emebajaji yaniutemeta misha su. Tuahueda emebajaji jana emederuta. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Echua puji dhidha dusete ahua huenahua pacuina biame, ahua tuahueda emebajaji eid'eni ebasenata su, beju beidaji emebajaji epu. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ye di meshanapaque. Ahua ete emetse ai hora tsi puji ecuina bahue pu cua su, tueda detse id'eni cua. Aimue detse tsiameta cua mahue mesa ai cuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Daja nime micuaneseda janimepitijiji ani taji. Micuaneda aimue ema eid'uainia mahue hora su, da hora su ema esiapati. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Da su Pedro ja Jesús quisabatana: —¿A da mique jabuetsuati ecuanaju sa puji bahui ahua pamapa cristiano cuana sa puji di? ");
INSERT INTO tnaNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesús ja Pedro jeutsutana: —Quema jabuetsuati cuana quebata papu cuana sa puji. Ete emetse ecuinanani su, pamapa mesa emebajaji cuana piada emebajaji emenajatiajusianatani saida pabata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ahua tueda emebajaji ja pamapa saida ebata su, ete emetse ja tueda saida echujetiata, jasiapati putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tueda emebajaji saida ebia su aida ai cuana emenajatiajusianata. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ahua tueda emebajaji ja saida pamapa ai cuana ebata mahue su, ete emetse ja tueda ecastigata, jasiapati putsu. Tueda emebajaji uja madhada hue japibati cua: “Quema echua puji mu aimue beju tipeida esiapati mahue.” Ahua tuahueda pia emebajaji cuana icheta cua su, ahua ebia su diadia cua, jaid'iti cua, tsetse cua su, da su ete emetse ja tueda jubida castigata cua, jasiapati putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tueda echua puji ete emetse da esiapati emebajaji madhada ja tu eid'uatani mahue hora su. Da su emebajaji madhada ete emetse ja ejusiacuinata. Castigo jude su ebeituta. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","‘Ahua emebajaji mesa echua puji sa ai tsada cuana bahue biame, da su ebia su echua puji ja tueda castigata cua, emebajaji bahue biame, mue a putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ahua emebajaji mesa echua puji sa ai tsada cuana bahue mahue putsu, aimue yata mahue su, tupuajiji hue echua puji ja ecastigata. Quebata Diusu ja ebia su etiatani, tueda Diusu ja ebia su ebajata. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","‘Ye mundo su ema pueana putsu, cristiano cuana esajasajatita. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Beju quema ebia su sufri pu taji. Da putsu, ema ebia su epibapibani ema sufri epupe teje. Tsada quema ye sufrimiento cuana tipeida papupe. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Beju ye mundo su ema pueana cristiano cuana pasajasajatita puji. Ema pueana putsu, aimue cristiano cuana tuneda cama huamahuama saida edusutita mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","53","Ema jepuiti ebacua mesa tata neje eduininibati. Ebaquepuna mesa cuara neje ecuininibati. Ebacuasane mesa yahue sa cuara neje eduininibati. Beju familia quitaita da eduininibatita ema jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús ja daja hue quisainiame atana huecuana uja: —Micuaneda mu bubeta. Judu cuana enetianani ba putsu, nai epu micuaneda eshanapainia. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Que jenetia beni epuani shanapa putsu, bahue micuaneda ahua huinahuina epu, ahua ed'iati. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Beju micuaneda da bubeta cuana. Micuaneda bahue epuani ahua mueta saida ehuena, ahua mahue, buepa chama putsu. Daja biame, Diusu ja micuana duju su cuaja ai yatani cuana eshanapainia mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","‘¿Jucuaja su ni micuaneda butsepi japibatija mahue? ");
INSERT INTO tnaNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","59","Yama micuana bahue quisa neje equisa. Ahua quebata mique manu ja mi echujebajatani su, tuahueda mi huaraji peje su dusuji mahue su, saida mebasetatique mi huaraji peje su emenajatiata mahue puji. Ahua mahue su, huaraji ja mi policia peje su emenajatiata. Mi eteriichata huecuana. Enei hue yama mi equisainia, dapia mida yaniti pamapa mique manu echujetiape teje. ");
INSERT INTO tnaNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Da hora su pia cuana ja cuaja romano huaraji aida Pilato ja piada piada Galilea yahua deja cuana manuameme atana Jesús quisatana. Tuna animalo cuana Diusu peje su eirutsuatasa cama, Pilato ja manuamemetana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Da su Jesús ja atana huecuana uja: —¿Ai pamapa pia deja cuana ebia su juchaji huecuana putsu, manuametana huecuana bata? ");
INSERT INTO tnaNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aimue daja mahue. Micuaneda di daja yata, ahua micuaneda Diusu peje su aimue epibaturucati mahue su. ");
INSERT INTO tnaNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Mepibatique piada tunca ocho ejaitiana cristiano cuana manutana Siloé sa torre Jerusalén ejude su, tuna bia su dajajana su. ¿Ai pamapa pia Jerusalén ejude su aniji cristiano cuana ebia su juchaji huecuana putsu, daja manume putana huecuana bata? ");
INSERT INTO tnaNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aimue daja mahue. Micuaneda di daja tipeida manume epu, ahua Diusu peje su aimue epibaturucati mahue su. ");
INSERT INTO tnaNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesús ja bahue quisa neje quisatana huecuana uja: —Piada deja sa higuera equi netina. Da su tueda putiana ahua jajaji equi eba puji. Beju jaja mahue batana. ");
INSERT INTO tnaNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Da su mesa emebajaji uja atana: “Quimisha mara ema beju epueni ye higo equi ahua jajaji eba puji. Pamapa epue jaja mahue yama ebainia. Da putsu, quejusiauteque tueda eti jude su pia equi saida ebana puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Da su emebajaji ja equi emetse uja atana: “Echua puji, ye mara paneti hue tsuhu. Yama med'i peda putsu, saida etsajahuama. ");
INSERT INTO tnaNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ahua pia mara jajaji epu su, paneti. Ahua mahue su, quejusiaute taji.” ");
INSERT INTO tnaNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Beju pia janahua tsine su Jesús ja jadhitati jude ete su cristiano cuana buetsuatanina. ");
INSERT INTO tnaNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Dapia piada epuna tud'i anina. Tueda piada tunca ocho ejaitiana mara daja puina. Einid'u madhada ja tueda tud'i ametana. Cuaja jabutsepiati taji mahue jabatina. ");
INSERT INTO tnaNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesús ja epuna ihua putsu, uja atana: —Epuna, beju mida saida. ");
INSERT INTO tnaNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Da hora su tusa eme epuna bia su huanatana su, epuna jabutsepiatiana. Epuna Diusu sa puji saida mimipiruana. ");
INSERT INTO tnaNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Da su beju jadhitati jude ete sa ehuidusuji ebia su duininiana, Jesús ja janahua tsine su saisiametana putsu. Dapia enetita cristiano cuana uja quisatana: —Beju pishica tsine yani emudumudu puji. Tueda tsine cuana su mepueque esaisiameti puji. Be mepueji janahua tsine su. ");
INSERT INTO tnaNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Da su Jesús ja tueda jeutsutana: —Mida da bubeta. ¿Aimue jia maida janahua tsine su mique juye, asunu epidhuinia mahue eid'imeti puji? ");
INSERT INTO tnaNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Beju ye epuna ichenu Ishahua ja piada tunca ocho ejaitiana mara tueda neda neje risijiji quinatana. ¿Aimue jia maida yama ye epuna tusa neda jenetia d'eji su a cua mahue, janahua tsine biame? Tueda da mi nime Abraham chenu sa familia jenetia. ");
INSERT INTO tnaNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Beju dapia Jesús sa majai enetita cuana bidhunetitana, daja Jesús mimiana putsu. Pamapa pia cristiano cuana mu beidaji putana, Jesús ja nimetiuda aida cuana atana ba putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesús ja cristiano cuana daja hue buetsuainiame atana: —¿Ai nime jia da Diusu ecuatsasiati? ");
INSERT INTO tnaNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Beju mostaza ejaja huai chidi nime da. Tueda ejaja huai chidi etse ebanainia su, aida esehuani. D'ia janana cuana echa su esaji yatitani. ");
INSERT INTO tnaNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Neicha Jesús quisabatana huecuana uja: —¿Ai nime jia da Diusu ecuatsasiati? ");
INSERT INTO tnaNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Beju levadura harina bebajiji dume su nime da. Epuna ja levadura harina neje ehuarutani. Tueda levadura ja pamapa harina bebajiji etutsuametani. Daja nime da Diusu ecuatsasiati. Equene quejucua chidi cristiano cuana tu peje su jei eputani biame, da su beju pamapa ejude su aniji cuana jei eputayu. ");
INSERT INTO tnaNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Beju Jesús Jerusalén ejude su epuhu cama, ejude meamea puniunetina cristiano cuana ebuetsua puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Da su piada ja Jesús uja quisabatana: —Echua Puji, ¿ahua ucua chidi hue d'eji su eputa? Da su Jesús ja jeutsutana uja: ");
INSERT INTO tnaNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Quema jabuetsuati cuana da eteriji upa ai chidi nime. Quebata tueda jabuetsuati cuana yata su, tueda cielo su enubi. Dueji cristiano cuana cielo su nubija eputa biame, aimue enubita mahue, quema jabuetsuati cuana aja mahue ta huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ete emetse ja ete eterita su, aimue detse etseque su enetita cuana nubita cua mahue. Eteriji jubida turuba putsu, uja etsiatsiata huecuana: “Echua Puji, tsequed'iaque ecuanaju enubi puji.” Da su ete emetse ja, “Mue yama micuana shanapa que jenetia micuaneda.” ");
INSERT INTO tnaNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Da su ete emetse uja yapiruta huecuana: “Ecuanaju mi neje diadiana, jaid'itiana. Miada ecuanaju sa ejude su buetsuana.” ");
INSERT INTO tnaNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Beju ete emetse ja uja ejeutsuta huecuana: “Jubida yama micuana yainia, menetideraque ema naja jenetia, madhada aji cuana micuaneda putsu.” Jesús ja daja hue quisainiame atana huecuana: —Daja huecha micuaneda cielo su enubi puji Diusu jubida ebaja biame, aimue tuahueda menubique yata mahue. Aimue micuana shanapaja yata mahue. Tu naja jenetia uqueda cuati castigo su micuana ebeituenitayu. ");
INSERT INTO tnaNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Dapia micuaneda ebia su epa, etsedhaiti Abraham, Isaac, Jacobo, profeta chenu cuana Diusu neje yanienita ba putsu. Daja micuaneda epa, etsedhaiti, tuna neje cuaja ani taji mahue ebati putsu, micuaneda etseque su castigo su yanieniti putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Pamapa yahua jenetia cristiano cuana cielo su enubita. Dapia yaniuteta huecuana ediadia puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Da su piada piada jiahue ai eni mahue cristiano cuana da equene aida eputa cielo su. Daja huecha piada piada jiahue equene aida puji cuana da dapia tije puji eputayu. ");
INSERT INTO tnaNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tueda tsine su huecha piada piada fariseo cuana cuinatana Jesús peje su. Uja Jesús atana huecuana: —Puenitique u jenetia, Herodes Antipas ja mi manuameja yatani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Da su Jesús ja atana huecuana uja: —Meputique Herodes Antipas peje su. Uja jida a taji mahue. Mequisatique: “Jiahue, mueta yama einid'u madhadaji, nedaji cuana esaisiame. Chumueta beju yape.” ");
INSERT INTO tnaNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ema da jiahue, mueta, chumueta beju ejaitiana Jerusalén ejude su ecuinati teje. Aimue detse ema aiya jiahue manuameta cua mahue, Diusu sa profeta cuana Jerusalén ejude su bahui manuame bahueta huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Da su Jesús Jerusalén ejude su aniji cristiano cuana jepuiti uja puana: —Jerusalén ejude su aniji cuana, micuaneda Diusu sa profeta cuana manuame bahue. Micuana peje su Diusu ja ebeitutani profeta cuana tumu neje maraca bahue. Quejucua nuati biame yama micuana dhitaja adhaana huaripa ja mesa yanana cuana edhititani enabai ema su nime. Beju aimue micuaneseda tsada puana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Da su meid'abaenique ema. Beju yama micuana ichajusia. Aimue micuaneda ema eba mahue ema esiapati teje. Da su ema esiapati su, micuaneda, “Diusu ja tueda paibunebata, Diusu sa ebani su epusiu putsu”, ema jepuiti epu. ");
INSERT INTO tnaNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Pia janahua tsine su Jesús piada fariseo sa echua puji sa ete su putiana ediadia puji. Pia fariseo cuana ja Jesús einatsihuatani. ");
INSERT INTO tnaNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Dapia tu butse su deja etsu anina. ");
INSERT INTO tnaNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Da su Jesús ja fariseo cuana quisabatana: —¿Ahua saida deja nedaji janahua tsine su esaisiame puji, ahua mahue? ");
INSERT INTO tnaNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Beju mitananetitana huecuana. Da su Jesús ja deja nedaji inatana. Saisiame putsu, beitutana deja. ");
INSERT INTO tnaNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Neicha Jesús ja fariseo cuana atana: —Ahua micuana sa juye, asunu rara su dajaja cua su, ¿aimue jia maida micuaneda da jenetia ejemicuina mahue, janahua tsine biame? ");
INSERT INTO tnaNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Da su beju cuaja jajeutsuti taji mahue jabatitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesús ja ihuajiji cuana ja aniude eni cuana misha naja je echacutani batana. Da su uja quisatana huecuana: ");
INSERT INTO tnaNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Ahua mi tsine su eihuatani huecuana su, be aniude eni chacuji. Cuapuitime pia ihuajiji mi ebia su aida pue cua su, tsine emetse ja mi netianameta cua mi ebia su aida ihuajiji yaniuteme puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Tuahueda mi, “Tiaque tueda aniude eni ye deja”, ata cua. Da su beju bidhu putsu, pia aniude eni mahue su miqueda aniute taji. ");
INSERT INTO tnaNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mi tsine su eihuatani huecuana su, aniuteque aniude eni mahue su. Da su mi tsine emetse ja, “Aniuteque dapia aniude eni su”, yata su, pamapa dapia ihuajiji yanita cuana ja mi ebia su aida ebata. ");
INSERT INTO tnaNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Quebata da tueda quita ebia su aida puja ebati su, Diusu ja tueda mue ai eni mahue nime yatayu. Daja huecha quebata da ai eni mahue ebati su, tueda Diusu ja ebia su aida yatayu. ");
INSERT INTO tnaNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesús ja tu ihuaji puana deja quisatana uja: —Mi tsine epuani su, be mique eshanapa, familia cuana, chipiluji deja cuana ihuaji. Ahua miada eihua huecuana su, tuneda mi daja huecha eihuata, mique jasetati eturuca. ");
INSERT INTO tnaNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Beju mi tsine epuani su, puri, ase bue mahue, tida, padha cuana mique ihua taji. ");
INSERT INTO tnaNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Daja a putsu, beidaji mida epu, mida cuaja chujetia taji mahue ebata huecuana putsu. Beju Diusu ja nimebutsepi cristiano cuana eid'emetayu su, cielo su mida ebia su echujetiata. ");
INSERT INTO tnaNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Beju misha naja su yani deja ja Jesús uja atana: —Quebata Diusu ecuatsasiati su ediadia su, tueda beidaji epu. ");
INSERT INTO tnaNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Da su Jesús ja deja jeutsutana uja: —Piada deja tsine aida puana. Dueji cristiano cuana ihuatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tsine hora beju cuinana su, tsine emetse ja mesa emebajaji cuana ihuajiji cuana ihuametana. Uja quisametana huecuana: “Mepueque beju, pamapa ai cuana basetajiji putsu.” ");
INSERT INTO tnaNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Beju pamapa ihuajiji cuana jaibuneba bajatitana. Piada uja puana: “Jiahue quita yama yahua eped'u bajaitia. Beju tueda quema bati taji.” ");
INSERT INTO tnaNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Pia uja puana: “Beju pishica juye butseji cama yama jiahue quita bajaitia. Tueda tsuhu quema jabati taji.” ");
INSERT INTO tnaNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Pia uja puana: “Jiahue quita ema ehuanepetiani. Da putsu, aimue da ema eputi mahue.” ");
INSERT INTO tnaNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Da su beju emebajaji jasiapati putsu, tsine emetse pamapa quisatana. Beju tsine emetse jubida duininiana. Tuahueda emebajaji uja cuatsasiatana: “Putique ejude duju je. Jetique pamapa puri, ase bue mahue, tida, padha cuana.” ");
INSERT INTO tnaNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Da su beju emebajaji putiana. Neicha jasiapati putsu, tsine emetse uja atana: “Echua puji, pamapa mique jacuatsasiati beju yama aitia. Daja biame, yani hue d'eji pia cuana sa puji.” ");
INSERT INTO tnaNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Da su tsine emetse ja emebajaji uja cuatsasiaderatana: “Neicha ejude duju je putique. Pia cuana ihuatique papueta huecuana quema ete paseje puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Pamapa equene yama ihuana cuana aimue piada biame quema tsine su ediadia mahue.” Atadhada Cristo tije ya puji ");
INSERT INTO tnaNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Beju jucuada cristiano cuana Jesús tije ataina. Da su Jesús ja uja atana huecuana: ");
INSERT INTO tnaNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Ahua quebata ja ema tije aja su, tuahueda ema tusa tata, cuara detse ebia su ibuneda pabata. Daja huecha ema tusa ehuane, ebacua cuana, edue cuana ebia su ibuneda pabata. ");
INSERT INTO tnaNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Quebata quema ebuqueji puja su, tuseda ema tije a taji emanu teje. ");
INSERT INTO tnaNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ahua quebata ja ete baqui bauda aja su, equene tsuhu quejucua chujeme epu piba taji. Ahua mesa tupu yani yape puji piba taji. ");
INSERT INTO tnaNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Beju apiru putsu, cuaja ape taji mahue tuahueda ebata su, cristiano cuana tu neje eid'ebatita. ");
INSERT INTO tnaNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Uja eputa huecuana: “Tueda deja ja apiru putsu, cuaja ape taji mahue batana.” ");
INSERT INTO tnaNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ahua quebata huaraji aida pia huaraji aida neje jaichetija pu cua su, equene tsuhu uja saida mesa japibati taji: “Quema soldado cuana da piada tunca mil yani. Quema majai sa soldado cuana da beta tunca mil yani. ¿Cuaja jia da ahua yama pishitiame cua, ahua mahue? ");
INSERT INTO tnaNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tueda huaraji mesa soldado cuana pishihue ba putsu, su da emebajaji cuana pia huaraji aida peje su uqueda hue su ebeituta tuatse sa ai enime cuana pabasetatita puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Da su beju quebata ja ema tije aja su, equene pamapa mesa ai cuana ichajusiape taji. ");
INSERT INTO tnaNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","‘Beju banu da saida. Ahua banu sa bueda etaitana su, ¿cuaja ni da banu neicha bueda puyu cua? ");
INSERT INTO tnaNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mue ai puji saida beju banu. Aimue ehuamaji biame saida mahue. Jusia taji hue beju. Pamapa id'ajararaji su, meid'abaenique ema. ");
INSERT INTO tnaNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jesús ebuetsua epuani cama, jucuada echujebajaji, juchaji cuana tu peje su puetana tu eid'aba puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Daja ba putsu, fariseo, jacuatsasiati ebuetsuaji cuana ja Jesús uja madhabatana: —Ye Jesús ja juchaji cuana saida ebatsutani. Tuna neje ediadiani. ");
INSERT INTO tnaNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Da su Jesús ja bahue quisa neje quisatana huecuana: ");
INSERT INTO tnaNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Ahua quebata micuana sa cien huisha cuana yani su, ahua piada ejeitid'u su, tueda nueve tunca nueve ejaitiana huisha cuana eichajusia piada jeitid'ujiji echacuti puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Teje putsu, beidaji neje miada emapabeyu. ");
INSERT INTO tnaNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ete su acuina putsu, pamapa mique edue, eshanapa cuana eihua. Uja mida epu: “Beidaji ema neje mepuque. Ye piada quema huisha jeitid'ujiji beju yama tejeitiba.” ");
INSERT INTO tnaNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Yama micuana butsepi equisainia, daja huecha cielo su aniji cuana beidaji eputani, piada juchaji Diusu peje su epibaturucatiani su. Nueve tunca nueve ejaitiana d'eji su cuana ebia su beidaji eputani huecuana piada japibaturucatiana jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","‘Epuna sa piada tunca chipilu yani su, da jenetia piada chipilu etaitana su, da su hueda eutsuata ete etahua puji. Etahuata chipilu taitanajiji eteje teje. ");
INSERT INTO tnaNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Teje putsu, mesa eshanapa cuana eihuatita. Uja epuna ja yata huecuana: “Beidaji ema neje mepuque. Ye piada quema chipilu taitanajiji beju yama tejeitiba.” ");
INSERT INTO tnaNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yama micuana equisainia, daja huecha Diusu sa cielo su aniji ángel cuana beidaji eputa, piada juchaji Diusu peje su epibaturucatiani su. ");
INSERT INTO tnaNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús ja daja hue buetsuainiame atana cristiano cuana: —Piada deja sa beta ebacua anina. ");
INSERT INTO tnaNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Da su ebacua tije puji mesa tata uja atana: “Tata, mi manuji mahue su hue, quema tupu mique chipilu ema tiaque.” Da su tata ja betana ebacua detse sajatiatana pamapa mesa chipilu. ");
INSERT INTO tnaNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Beju quejucua tsine sa ebacua tije puji pamapa mesa ai cuana jadhitatiana. Pia yahua uqueda su putiana. Dapia pamapa mesa chipilu cuana apetana, pamapa mesa ai utsatada madhada cuana yainia je. ");
INSERT INTO tnaNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Chipilu mesa pupeana su, dhemanupiruana, mid'e cuinana tueda yahua su putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Da su mudumudupiruana. Cuchi quinaji puana. ");
INSERT INTO tnaNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ebia su edhemanuani putsu, cuchi cuana sa jana diaja atana. Aimue aiya biame tueda mihuaja atana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Da su beju tueda uja pibapibana: “Quema tata sa emebajaji cuana sa jana tupu yani. Beju ema tusa ebacua biame, upia ema diadiaja emanu. ");
INSERT INTO tnaNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Pasiapati hue ema quema tata peje su. Tueda yama uja ya: ‘Tata, ema Diusu butse su juchaji puitia. Daja huecha mi butse su. ");
INSERT INTO tnaNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Be ema baji mique ebacua nime. Mique mudu puji nime hue ema baque.’” ");
INSERT INTO tnaNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Da su beju putibana mesa tata peje su. Uqueda su hue tueda ecuinahu mesa tata ja batana. Tata ja ba putsu, ebia su ibunebatana mesa ebacua. Da su tipeida jududutiana ebacua etsunetia puji. Tsunetia putsu cama hue, id'ami putsu, budhitana ebacua. ");
INSERT INTO tnaNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Da su ebacua ja mesa tata uja atana: “Quema tata, ema Diusu butse su juchaji puitia. Daja huecha mi butse su. Da putsu, be ema baji mique ebacua nime.” ");
INSERT INTO tnaNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Da su beju tata ja mesa emebajaji cuana cuatsasiatana uja: “Meduseque ejud'uji eni. Duse putsu, mejud'uque. Metara emeyatsa su meichaque. Pulucu di meichaque ehuatsi su. ");
INSERT INTO tnaNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Huaca emud'u tseida memanuameque. Tsine mepuja. ");
INSERT INTO tnaNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ye quema ebacua manujiji nime puana. Beju eid'e jasiapataitiba. Tueda tsunuda taitanajiji biame, jiahue ecuaneda tejeitiba.” Da su beju tsine pupirutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","‘Daja tuna eputasa cama, ebacua edhi te jenetia cuinaibana. Ete su ecuinasayu je, beidaji eturuturutani huecuana id'abatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Da su piada emebajaji quisabatana: “¿Ai da micuaneda epuani?” ");
INSERT INTO tnaNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Emebajaji ja ebacua edhi jeutsutana uja: “Beju mique d'au cuinaitiba saida.” ");
INSERT INTO tnaNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Da su ebacua edhi ebia su duininiana, daja id'aba putsu. Tsine su nubija mahue puana. Da su mesa tata tu enubiame puji cuinanana. ");
INSERT INTO tnaNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ebacua edhi ja mesa tata uja atana: “Ema dajucua mara mi neje saida mudumuduana biame, aimue mi quema puji mu tsine a. Aimue huisha janana dhucuana quema puji mu manuame ema quema eshapanapa cuana neje tsine su ediadia puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Beju jiahue cuinaitiba mique ebacua a taji mahue. Tuahueda mique chipilu epuna chuamadhada neje apejiji. Daja biame, miada huaca emud'u tseida manuameitia tuseda puji tsine ya puji.” ");
INSERT INTO tnaNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Da su tata ja ebacua edhi uja jeutsutana: “Ibuneda ebacua, mida mu ema neje hue yani. Pamapa quema ai cuana miqueda cama beju. ");
INSERT INTO tnaNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Jiahue da saida tsine epu puji, mique d'au cuinaitiba putsu. Tueda manujiji nime puana. Beju eid'e jasiapataitiba. Tueda tsunuda taitanajiji biame, jiahue ecuanaju tejeitiba. ");
INSERT INTO tnaNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús ja discípulo cuana daja hue quisainiame atana: —Deja chipiluji beju anina. Mesa piada mudu puji sa edusuji anina. Da su beju edusuji ja tusa ai cuana aimue saida bataina mahue pia cuana ja deja chipiluji quisatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Da su deja chipiluji ja edusuji ihuatana. Ihua putsu, uja atana: “Ema equisatani huecuana miada quema ai cuana aimue saida ebainia mahue. Da su pamapa manu quirica cuana ema menajatiaque, aimue mida quema edusuji beju epu mahue putsu.” ");
INSERT INTO tnaNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Da su edusuji jubida japibapirutiana uja: “¿Cuaja ni da ema epu, quema emetse ema ejusiacuinatani putsu? Aimue quema tucheda te su emudumudu puji. Ebidhuani ema limosna ebaja puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Beju bahue ema cuaja yama aitime ya. Saida yama ya quema emetse sa manu cuana, saida ema mecuana sa ete cuana su pabatsuta huecuana puji, quema mudu beju aimue su.” ");
INSERT INTO tnaNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Da su tueda edusuji ja emetse sa manu cuana piada piada ihuatana. Equene manuji uja quisabatana: “¿Quejucua mi manume quema emetse peje su?” ");
INSERT INTO tnaNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tueda deja ja jeutsutana: “Cien emeji aida cuana aceite neje sejeajiji da quema manu.” Da su edusuji ja tueda uja atana: “¡Jade! Jiahue quita hue chujetiaque dusetete pai bahui. Daja chujetia putsu, beju mi manu mahue epu.” ");
INSERT INTO tnaNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Pia manuji macha pueana. Edusuji ja tueda quisabatana: “¿Quejucua mique manu quema emetse peje su?” Da su manuji deja ja uja jeutsutana: “Cien d'iti cuana trigo neje sejeajiji da quema manu.” Da su edusuji ja tueda uja atana: “¡Jade! Jiahue quita hue chujetiaque ocho tunca bahui. Daja chujetia putsu beju, mi manu mahue epu.” Daja edusuji ja atana manuji cuana ja tu saida ebatsuta puji tuseda beju aimue mudu su. ");
INSERT INTO tnaNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Jesús ja daja hue quisainiame atana huecuana: —Tueda edusuji ate da nimeji eni. Enei hue, ye mundo su cristiano cuana da tuneda cama daja nimeji eni eputani. Diusu sa cristiano cuana mu aimue daja mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","‘Yama micuana equisainia, micuaneseda aimue daja a taji mahue. Be chipilu neje eshanapa cuana mechacuji. ¿Ai da neje cielo su enubi bata? ");
INSERT INTO tnaNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","‘Quebata ja ucua chidi saida ebatani su, daja huecha dueji ai cuana di saida ebata. Quebata ja ucua chidi saida mahue ebatani su, daja huecha dueji ai cuana su di saida mahue ebata. ");
INSERT INTO tnaNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ahua micuaneda ye mundo sa ai cuana aimue saida ebainia mahue su, aimue Diusu ja mesa ai cuana cielo su emenajatiata mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ahua micuaneda pia cuana sa ai cuana aimue saida ebainia mahue su, aimue Diusu ja micuaneseda quitaita ai cuana etiata mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","‘Beju aiya biame beta echua puji tupupai mebajata cua mahue. Piada echua puji bahui hue mebaja taji. Pia cuana mu aimue tsada ba taji mahue. Daja huecha ahua etse Diusu mebajaja su, aimue detse etse Diusu mebaja cua mahue chipilu ebia su tsada ebainia neje tupupai. ");
INSERT INTO tnaNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Beju dapia netitana fariseo cuana ja daja Jesús epuani id'aba putsu, jaid'ebatitana huecuana, tuneseda ebia su chipilu tsada puina putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Da su Jesús ja uja atana huecuana: —Cristiano cuana ja micuana saida nime ebatani biame, Diusu ja mu micuana sa muesumu madhada eshanapaenitani. Cristiano cuana ja saida ebatani cuana da Diusu ja tsada mahue ebatani. ");
INSERT INTO tnaNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","‘Beju Juan da Diusu ecuatsasiati epusiu quisaquisa pupiruana jenetia dueji cristiano cuana tueda quisa saida cuana su jubida neje jei eputani. Juan quisaquisa pamapa pupiruji mahue su, Diusu sa equene profeta chenu cuana quisaquisa putaidha Diusu ecuatsasiati epusiu jepuiti. Moisés chenu ja di Diusu ecuatsasiati jepuiti deretaidha. ");
INSERT INTO tnaNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","‘Beju Diusu sa jacuatsasiati cuana da butsepi. Buepa, yahua pamapa epupe biame, aimue tueda jacuatsasiati cuana mu epupe mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","‘Ahua quebata deja ja mesa ehuane jucha mue biame emesiata su, ahua pia neje ehuaneti su, tuahueda jucha aida yatani. Daja huecha epuna di. Ahua quebata deja mesiajiji epuna neje ehuaneti su, tueda deja ja di jucha aida yatani. Daja huecha epuna di. ");
INSERT INTO tnaNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesús ja cristiano cuana daja hue quisainiame atana uja: —Beju piada deja chipiluji anina. Mesa ejud'uji da ebia su saida chujeneda eni puina. Pamapa tsine tsine aida a bahue puina. ");
INSERT INTO tnaNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Daja huecha piada deja puri anina. Tueda Lázaro banime. Chadi cama mesa equita puina. Deja chipiluji sa ete tsequeini su yahua su anina. ");
INSERT INTO tnaNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Tueda Lázaro ichenu ja deja chipiluji sa jana puchu neje sejeja pudhaana. Uchi cuana ja tusa chadi cuana tseutaina. ");
INSERT INTO tnaNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Da su beju Lázaro manuana. Angel cuana ja tueda dusutana Abraham peje su dapia tu neje saida paanieniti puji. Da su beju deja chipiluji di manuana su, papatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Cuati castigo su puenitiana. Da jenetia uqueda Lázaro saida, beidaji Abraham neje yani batana. ");
INSERT INTO tnaNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Da su deja chipiluji ja Abraham uja tsiatsia neje bajatana: “Tata Abraham, ibunebaque ema. Beituque Lázaro ema peje su. Tusa emehuituji yahui su paped'ata quema yana etsabiata puji, ye cuati castigo su ebia su ema sufri epuani putsu.” ");
INSERT INTO tnaNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Da su Abraham ja tueda uja jeutsutana: “Edue, japibatique mida mundo su eid'e anina hora su mi saida anina. Lázaro mu mundo su aimue saida anina mahue. Jiahue beju tueda upia pamapa aiji saida yanieni. Miqueda mu jiahue sufri dapia pueni taji. ");
INSERT INTO tnaNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ed'eji su, cuaja jaitiana taji mahue equehuehueji dueda, etse dhede je su yani putsu.” ");
INSERT INTO tnaNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Beju deja ja Abraham jeutsutana uja: “Da su, Tata Abraham, yama mi jubida ebajainia, beituque Lázaro quema tata sa ete su mundo su. ");
INSERT INTO tnaNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Dapia quema pishica edue cuana yani. Lázaro ja pamapa butsepi paquisatita huecuana ye cuati castigo su aimue tuneda di ema nime papueta mahue puji.” ");
INSERT INTO tnaNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Da su Abraham ja tueda uja atana: “Tuneseda Moisés chenu sa jacuatsasiati cuana yani. Diusu sa profeta chenu cuana ja deretaidha quirica cuana di beju mecuana sa yani. Tueda quirica derejiji cuana jei paata huecuana. Ahua daja yata huecuana su, aimue mi yani su epueta huecuana mahue.” ");
INSERT INTO tnaNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Da su deja ja uja jeutsutana: “Mahue, Tata Abraham, ebia su saida ahua piada manujiji u jenetia tuna peje su paputi tuna equisati puji. Da su beju Diusu peje su epibaturucatitayu huecuana.” ");
INSERT INTO tnaNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham ja tueda uja atana: “Ahua Moisés chenu sa jacuatsasiati cuana jei aja mahue yata huecuana su, ahua Diusu sa profeta chenu cuana sa quirica cuana jei aja mahue yata huecuana su, da su piada manujiji u jenetia eid'eyu tuna equisati puji biame, aimue epibaturucatita huecuana mahue.” ");
INSERT INTO tnaNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","2","Da su Jesús ja discípulo cuana uja atana: —Quebata ja piada eichacua ema peje su jei epuani cristiano tusa Diusu peje su janimetucheati etaitanameta su, tuseda puji ebia su saida pamanu bai dueda su, tueda eichacua jei epuani cristiano sa janimetucheati taitanameji mahue su hue. Beju ye mundo su jucuada ai cuana yani cristiano cuana sa Diusu peje su janimetucheati cuana etaitaname puji. Quebata ja daja etaitanameta huecuana su, Diusu ja tueda ematsetayu. ¡Aba tueda, ahua pia cuana daja etaitanameta su! ");
INSERT INTO tnaNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ahua mique edue ja mi ai jucha yata su, butseatique tu jucha yatani jepuiti. Ahua tusa jucha shanapa putsu, epibaturucati su, da su perdonaque. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Quejucua nuati jia miqueda puji tuahueda mi ai jucha yata su, ahua tueda, “Perdonaque ema”, epu su, beju perdona taji. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apóstol cuana ja Jesús uja atana: —Echua Puji, tsahuaque ecuanaju Diusu peje su jubida enimetucheati puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Da su Jesús ja jeutsutana huecuana uja: —Ahua micuaneda Diusu peje su mostaza ejaja chidi nime aihua dhucuana enimetucheatiani su, da su micuaneda ye aqui uja cuatsasia cua: “U jenetia mar su puderaque.” Ahua daja micuaneda ecuatsasia su, beju aqui epudera. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","‘Mique emebajaji te jenetia jubida mudumudupe putsu, jasiapatiba su, ¿ai miada, “Aniuteque, diadiaque”, ya bata? ");
INSERT INTO tnaNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Miada tueda, “Jana quema basetatique. Equene ema ediadiani tsuhu baque. Tije chu mida ediadia”, ya. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Ai miada emebajaji emudumuduani putsu, “Diusulupai”, ya bata? ");
INSERT INTO tnaNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Daja huecha da Diusu neje. Tusa jacuatsasiati a putsu, uja puque: “Emebajaji saida mahue da ema, quema a taji ai cuana bahui yainia putsu.” ");
INSERT INTO tnaNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesús Jerusalén ejude su epuhu cama, Samaria, Galilea yahua detse dhede je jaitianana. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Piada ejude chidi su ecuinahu cama, piada tunca lepraji deja cuana tsutana ejude esacuinaji su. Beju aimue Jesús nariatana huecuana mahue, lepraji ta huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Uqueda jenetia tsiatsiatana huecuana uja: —¡Echua Puji Jesús, ibunebaque ecuanaju! ");
INSERT INTO tnaNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Da su Jesús ja atana huecuana: —Meputique sacerdote cuana peje su. Beju tuna eputahu cama, saisitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Piada tuneda saida beju jabati putsu, jasiapatibana Jesús diusulupai ya puji. Diusu jubida mitsutsuatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesús butse su turusati putsu, Diusulupai atana. Tueda da samaritano deja puina. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Da su beju Jesús ja enetita cuana atana: —¿Aimue jia maida piada tunca yama saisiameitia mahue? ¿Juque ni da pia cuana? ");
INSERT INTO tnaNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ye judío mahue deja samaritano bahui jasiapataitia beidaji neje Diusu emitsutsua puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Da su Jesús ja deja atana: —Netianaque. Putiyuque. Mida ema peje su jei puitia putsu, beju saisitia. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pia tsine fariseo cuana ja Jesús uja quisabatana: —¿Quetsunu jia da Diusu ecuatsasiati ecuina? ");
INSERT INTO tnaNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Jesús ja jeutsutana huecuana: —Aimue micuaneda Diusu ecuatsasiati ba cua mahue, micuana duju su bataji mahue yani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Da su Jesús ja discípulo cuana uja atana: —Beju ema eputi tiempo ecuina. Aimue micuana neje ema yani mahue. Da tiempo su micuaneda ema ecuatsasiatiani baja ya biame, aimue ema eba mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Beju piada piada cuana uja eputa: “Jesús beju jasiapataitiba. Dapia tueda yani.” Be jei meaji huecuana. Be ema mechacutiji. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ema esiapati su, pamapa cristiano cuana ja ema jasiapatiana saida eshanapata. Tserutseru pamapa ja ebatani nime daja ema ebata huecuana, ema esiapati su. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Equene quema ebia su sufri pu taji. Cristiano cuana ja ema tsada mahue ebata. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noé chenu sa tiempo su puidha nime, daja da epu, ema esiapati su. Diusu tsada mahue bataidha huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Da tiempo su Diusu ja cristiano cuana manuamepeji mahue su, diadiataidha, jaid'ititaidha, jabutsenetitaidha huecuana Noé chenu arca su nubidha teje. Aimue jei putaidha mahue huecuana Diusu sa jamatseti jubida epusiu. Tueda nai, ena jamatseti pupiruidha su chu, Diusu peje su japibatitaidha huecuana. Ena ja beju manuamepetaidha huecuana pamapa. Daja huecha cristiano cuana jei puja mahue eputa, ema jasiapatiji mahue su. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Daja huecha biahua tiempo cristiano cuana puidha Lot chenu anidha tiempo su. Da tiempo su beju diadiataidha, jaid'ititaidha, bajabajataidha, iruirutaidha, banabanataidha, ete cuana ataidha huecuana. Beju pamapa ataidha huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lot chenu ejude Sodoma jenetia cuinanaidha su, beju cuati dajajaidha ejude Sodoma bia su. Pamapa tueda ejude su aniji cuana manupetaidha. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Daja da epu cristiano cuana neje, ema ye mundo su esiapati su. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","‘Da tiempo su ahua quebata mesa ete epa pachata bia su yani su, bute putsu, tipeida pajududu. Be ete su panubi mesa ai cuana ejemicuinati puji. Ahua quebata te su yani su, tipeida pajududu. Be ejude su pasiapati. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mepibaque Lot chenu sa ehuane cuaja puidha. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Quebata ja ye mundo sa ai cuana ebia su tsada ebatani su, tueda quita etaitanamepeti. Quebata ja ye mundo sa ai cuana tsada mahue ebatani su, tueda da eid'e epueni. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Da tiempo su ema esiapati su, beta tahui jude su etahui sa epu. Beju piada Diusu ja edusuta. Pia mu eichajusiata. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Beta epuna edudududusa epu. Beju piada edusuta. Pia mu eichajusiata. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Beta deja te su emudumudusa epu. Daja huecha piada edusuta. Pia mu eichajusiata. ");
INSERT INTO tnaNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Da su beju Jesús quisabatana huecuana uja: —¿Echua Puji, ¿quepia jia da tueda ai cuana epu? Jesús jeutsutana: —Ai ihui esa su, samani cuana tipeida edhitatitani nime, daja huecha ema tipeida esiapati ye mundo su aniji cristiano cuana ecastiga puji, beju ebia su madhada hue eputa huecuana su. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús ja discípulo cuana bahue quisa neje daja hue buetsuainiame atana. Pamapa hora su mecuana sa jamitsuti taji yani Diusu neje buetsuatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Uja quisatana huecuana: —Piada ejude su huaraji anina. Tueda da Diusu jei aja mahue atana. Aimue cristiano cuana saida ibuneda batana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Dapia ejude su epuna ahue manujiji anina. Tueda epuna huaraji peje su siapati puana mesa jatsahuati ebaja puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Huaraji ja epuna tsahuaja mahue atana equene su. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Da su chu beju tueda uja japibatiana: “Aimue yama Diusu jei yainia mahue, cristiano cuana saida ibuneda ebainia mahue biame, tueda epuna yama etsahua, tuahueda ema jubida ebajatani putsu. Beju siapati epuneti baja mahue ema.” ");
INSERT INTO tnaNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Daja tueda huaraji madhada japibatiana. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Daja huecha Diusu ja mesa jadhareti cristiano cuana etsahuata, tsine, dhidha tu ebajatani huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Enei hue, tuahueda tipeida etsahuata huecuana. ¿Cuaja jia da ema ye mundo su esiapati su, ahua Diusu peje su enimetucheatiani cuana yama eba, ahua mahue? ");
INSERT INTO tnaNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Beju dapia piada piada enetita cuana ebia su aida japibatitana. Pia cristiano cuana ai eni mahue nime bataina huecuana. Da su Jesús ja bahue quisa neje quisatana huecuana uja: ");
INSERT INTO tnaNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Beta deja templo su putiana Diusu emitsuti puji. Tuatseda piada fariseo puina. Tueda ebia su aida jabatina. Diusu butse su nimebutsepi jabadhaatina. Beju pia deja impuesto chujebajaji puina. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Da su fariseo ja uja Diusu mitsutana: “Diusulupai, Tata Diusu, aimue ema juchaji pia cristiano cuana nime mahue. Aimue ema juchaji ye impuesto chujebajaji deja nime mahue. Aimue pia cuana yama baseana mahue. Aimue ema pia epuna neje jaquinatiana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Piada semana su beta nuati ema ayuna epuani. Quema pamapa ai cuana jenetia piada décimo yama mi etiainia.” Daja fariseo ja Diusu mitsutana. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Beju impuesto chujebajaji nimemitsida chuadera netina. Yahua huabata bahui netina. Jatseduturutiana, jubida juchaji jabati putsu. Uja Diusu mitsutana: “Tata Diusu, ibunebaque ema, ema juchaji putsu.” Daja impuesto chujebajaji deja ja Diusu mitsutana. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yama micuana butsepi equisainia, tueda deja Diusu ja perdonatana. Fariseo mu aimue Diusu ja perdonatana mahue, ebia su aida jabatiana putsu. Beju ebia su aida ebatiani cuana Diusu ja ai eni mahue yatayu. Ai eni mahue ebatiani cuana Diusu ja aida yatayu. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Da su beju piada piada yanana chidi cuana Jesús peje su dusetana huecuana Jesús ja mesa eme tuna bia su huana putsu, tuneseda puji Diusu ebajata puji. Beju discípulo cuana sa tsada mahue puana. Yanana chidi duseji cristiano cuana d'ayapirutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Da su Jesús ja discípulo cuana uja atana: —Yanana chidi cuana d'eji metiaque ema peje su papueta, Diusu ecuatsasiati da tuna nime cuana sa putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ene putsu, yama micuana equisainia, etseseda nimemitsida pu taji ye yanana cuana nime Diusu ecuatsasiati su enubi puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Piada judío cuana sa edusuji ja Jesús uja quisabatana: —Echua Puji, mida da saida. ¿Ai ni quema a taji Diusu neje cielo su eid'e yanieniti puji? ");
INSERT INTO tnaNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","20","Da su Jesús ja tueda jeutsutana: —¿Jucuaja su miada ema saida yainia? Diusu bahui da saida. Ahua mida cielo su eid'e anienija su, aque Moisés chenu sa jacuatsasiati cuana. Da sa deja ja neicha Jesús quisabatana: —¿Quebata jacuatsasiati cuana quema a taji? Jesús ja deja jeutsutana: —Be jamanuametiji puji. Be pia sa ebutse quinaji. Be tsi puji. Be bid'umimi puji. Mique tata, cuara detse iyubaque. Mida quitaita ibuneda ebatiani nime, daja pia cuana ibuneda baque. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Da su deja ja Jesús atana: —Beju pamapa tueda jacuatsasiati cuana yama butsepi yainia ema yanana jenetia jiahue teje. ¿Ai pia ni da quema a taji yani? ");
INSERT INTO tnaNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Beju Jesús ja tueda uja atana: —Ahua mida nimebutsepi puja su, irutique pamapa mique ai cuana. Pamapa mique chipilu cuana puri cristiano cuana tiaque. Tiape putsu, tije ema aque. Ahua daja ya su, cielo su pamapa ai eichacua cuana mique yani. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Beju deja daja id'aba putsu, ebia su jatacuamadhapirutiana, tueda ebia su chipiluji putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Da su deja putibana su, Jesús ja mesa discípulo cuana uja atana: —Ene putsu, yama micuana equisainia, atadhada chipiluji cuana Diusu ecuatsasiati su enubi puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ebia su atasaida caballo acusha id'aja je ejaitiana puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Da su discípulo cuana ja Jesús daja epuani id'aba putsu, ebia su nimetiunetitana huecuana. Uja jaquisabatitana huecuana: —¿Aidhe jia da d'eji su pu cua? ");
INSERT INTO tnaNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Beju Jesús ja tuna chama putsu, uja atana huecuana: —Cristiano cuana aimue tuna mehua quitaita hue d'eji su jaatita cua mahue. Diusu sa puji mu mue ai biame atadhada mahue. Beju Diusu ja aidhe papu biame d'eji su ata cua. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Da su Pedro ja Jesús uja atana: —Echua Puji, ecuanaju beju pamapa ecuanaju sa ai cuana ichajusiana mi tije ya puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Da su Jesús ja Pedro jeutsutana: —Enei hue, quebata ja mesa tata, ehuane, edue, ebacua cuana ema jepuiti eichajusiata su, Diusu ja tueda ai ichajusiajiji cuana ebia su dueji eturuca etiatayu ye mundo su. Dapia cielo su tueda eid'e yameenititayu. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús ja mesa discípulo cuana uja atana: —Jerusalén ejude su ecuanaju epuhu. Dapia ema emanuameta huecuana, cuaja Diusu sa profeta chenu cuana ja biahua tiempo deretaidha batame. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Judío mahue, Diusu shanapa bue mahue deja cuana peje su ema emenajatiata huecuana. Tueda deja madhada cuana ema neje eshishatita. Ema emadhabata huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Tuneda ema eicheta. Equedi neje ema equid'uata. Daja a putsu, ema emanuameta huecuana. Quimisha tsine ejaitiana su, ema enetianayu manujiji cuana duju jenetia. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Beju discípulo cuana ja aimue shanapatana mahue Jesús ja equisatani cuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jericó ejude su esacuinaji su deja padha edid'i su anina chipilu ebaja puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tueda deja padha jucuada cristiano cuana ejaitianatasa id'abatana. Da su beju quisabatana: —¿Aidhe da ejaitianasa? ");
INSERT INTO tnaNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Beju jeutsutana huecuana: —Jesús da ejaitianasa. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Da su deja padha jubida tsiatsiapiruana uja: —¡Jesús, David chenu sa familia jenetia, ibunebaque ema! ");
INSERT INTO tnaNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Beju ehui su eputahu cuana ja d'ayatana deja padha aimue patsiatsia mahue puji. Beju d'ayatana huecuana biame, deja padha cha ebia su hue tsiatsiana uja: —¡Jesús, David chenu sa familia jenetia, ibunebaque ema! ");
INSERT INTO tnaNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Da su beju Jesús netisenana. Tuahueda cuatsasiatana huecuana deja padha tu peje su paduseta puji. Beju deja padha tu butse su dusetana su, Jesús ja quisabatana: ");
INSERT INTO tnaNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Ai mique tsada yama ya puji? Da su padha ja jeutsutana: —Echua Puji, jabatija ema. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Da su Jesús ja tueda atana: —Daja papu. Ebati mida, ema peje su jei puitia putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Da hora su hue deja padha beju jabatiana. Jesús tije yahu je. Diusu mitsutsuapirutana. Pamapa dapia cristiano cuana di Diusu mitsutsuapirutana. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","3","Jesús da Jericó ejude je epuniuneti su, piada deja ja tueda baja adhaatana. Tueda da Zaqueo banime puina. Tueda da impuesto chujebajaji cuana sa edusuji puana. Pamapa tueda impuesto chujebajaji cuana da ebia su chipiluji eni putana, cristiano cuana basea bahue huecuana putsu. Beju ye Zaqueo ja cuaja ba taji mahue batana Jesús, ebia su dueji cristiano cuana putsu, Zaqueo da deja ubu chidi hue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Da su beju Jesús ehui su jududutiana. Jesús ejaitiana edid'i buahua su aqui su tsuana Jesús eba puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Beju Jesús dapia cuinati putsu, Zaqueo aqui su ebade batana. Da su Jesús ja Zaqueo ja uja mitsutana: —Zaqueo, tipeida buteque. Jiahue da ema mique ete su yaniti. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Da su Zaqueo tipeida buteana. Beidaji neje tuahueda Jesús dusutana tusa ete su. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Beju pia cristiano cuana sa tsada mahue putana. Tuneda cama uja jaquisatitana: “Jesús da impuesto chujebajaji deja juchaji sa ete su putia.” ");
INSERT INTO tnaNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Da su beju Zaqueo ja Jesús uja atana: —Echua Puji, quema chipilu edusete da puri cristiano cuana yama etia. Pamapa yama baseana cuana beju yama pushi nuati eturucayu huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús ja Zaqueo jeutsutana: —Mida da Tata Abraham chenu sa familia jenetia biame, juchaji puina. Jiahue beju mida da d'eji su. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ema da Diusu peje jenetia pueana mi nime juchaji cuana d'eji su ya puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Beju neicha hue Jerusalén edid'i je putitana huecuana. Jesús neje puniunetiji cuana Jesús ja ecuatsasiapiruta Jerusalén ejude su cuinati putsu, pepe putana huecuana. Tuneda jiahue quita beju Diusu ecuatsasiapiruti pepe putana huecuana. Beju aimue daja tuna pibatana nime puana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Da putsu, Jesús ja bahue quisa neje buetsuatana huecuana uja: —Piada deja aida pia yahua uqueda su putiana huaraji aida enubiameti puji tusa yahua su neicha hue esiapatiyu puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Beju eputi puji tueda deja ja piada tunca mesa emebajaji cuana ihuatana. Pamapa su dajucua cama chipilu tiatana. Uja cuatsasiatana huecuana: “Ye chipilu neje memudumuduque chipilu eyapaca puji ema esiapati teje.” ");
INSERT INTO tnaNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Beju dapia aniji cristiano cuana sa tsada mahue puana tueda deja tuna sa huaraji papu puji. Da su beju tu tije quisa puji beitutana huecuana. “Be panubiameta ye deja ecuanaju sa huaraji puji”, ametana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Beju daja putana biame tueda deja da huaraji aida nubiametana. Da su beju jasiapatibana tusa ejude su huaraji aida ebani neje cuinayu putsu, tusa piada tunca emebajaji cuana ihuatana, quejucua chidi chipilu yapacajijita huecuana eshanapa puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Da su beju equene puji emebajaji cuinana tu peje su. Tuahueda deja huaraji aida uja atana: “Echua Puji, mique chipilu miada ema tiana jayapacatijiji piada tunca nuati.” ");
INSERT INTO tnaNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Da su huaraji aida ja emebajaji atana: “¡Saipie! Mida da emebajaji saida. Miada saida ana quejucua chidi chipilu neje putsu, yama mi piada tunca ejude cuana sa huaraji enubiame.” ");
INSERT INTO tnaNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Pia emebajaji macha cuinana. Tuahueda uja atana: “Echua Puji, mique chipilu miada ema tiana jayapacatijiji pishica nuati.” ");
INSERT INTO tnaNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Huaraji aida ja jeutsutana: “¡Saipie hue! Yama mi pishica ejude cuana sa huaraji enubiame.” ");
INSERT INTO tnaNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Da su beju pia emebajaji macha cuinana tu peje su. Tuahueda atana: “Echua Puji, u hue mique chipilu miada ema tiana. Ichasetana yama dhiri ped'u su. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Iyubana mi yama mida da deja jubida jacuatsasiati bahue. Miada mejemi bahue pia sa ai cuana. Pia sa ai ejaja cuana huiru bahue.” ");
INSERT INTO tnaNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Da su huaraji aida ja emebajaji uja atana: “Mida emebajaji madhada hue. Bahue mi puana ema deja piba tucheda epuani. Beju bahue mi puana yama mejemi bahue pia sa ai cuana. Yama pia sa ai ejaja cuana huiru bahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Tueda pamapa mida bahue puana biame, ¿jucuaja su ni aimue quema chipilu banco su dhucuana ichana mahue dapia chipilu eyapacati puji ema esiapati teje?” ");
INSERT INTO tnaNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Beju huaraji aida ja dapia enetita cuana uja cuatsasiatana: “Memejemique yama tiana chipilu. Metiaque tueda chipilu equene cuinana emebajaji saida, tuahueda quema chipilu yapacametana piada tunca nuati putsu.” ");
INSERT INTO tnaNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Da su tuneda huaraji jeutsutana: “Echua puji, tuseda mu yani.” ");
INSERT INTO tnaNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Huaraji aida ja jeutsutana huecuana: “Beju yama butsepi equisainia, quebata sa yani tueda da yama etia ebia su quita. Quebata sa aimue yani mahue, tueda da yama emejemi quejucua mesa ai chidi yani cuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Beju meduseque tueda ema duininida ebatani cuana. Tuneda aimue ema tsada batana mahue tuna sa huaraji epu puji. Beju meduseque huecuana ema peje su. Memanuameque ema butse su.” ");
INSERT INTO tnaNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesús buetsuape putsu, neicha putiana Jerusalén ejude edid'i je. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Beta ejude chidi esacuinaji su cuinana. Tueda ejude chidi detse Betfagé, Betania banime puina. Tueda ejude chidi detse murucu aida Olivo banime naja su anina. Da su Jesús ja beta discípulo detse cuatsasiatana uja: ");
INSERT INTO tnaNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Tueda ejude chidi butse su meputique. Ejude enubiji su piada asunu risijiji eneti metseda eba. Tueda asunu chidi aiya biame tsuhu aimue bianiji mahue. Pidhu putsu, meduseque. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ahua aiya metse, “¿Jucuaja su metse daja yainia?” equisabata su, mequisaque tueda uja: “Echua Puji ja etsatani.” ");
INSERT INTO tnaNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Da su tuatseda putiana. Pamapa batana tse, cuaja Jesús ja quisatana tse batame. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tuatseda asunu epidhutani cama, emetse cuana ja quisabatana tse: —¿Ai puji metse asunu epidhuinia? ");
INSERT INTO tnaNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tuatseda jeutsutana: —Echua puji ja etsatani. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Da su asunu dusutana tse Jesús peje su. Discípulo cuana ja asunu bia su ebia jud'uji ichatsua putsu, Jesús da bia su ichatsuatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Daja putitana Jerusalén ejude su. Cristiano cuana ja tuna sa ebia jud'uji cuana Jesús hui su huanatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Olivo murucu tsaja su cuinatitana su, pamapa Jesús sa ebuqueji cuana beidaji neje Diusu jubida mitsutsuatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Uja tsiatsiatana huecuana: —¡Gloria, Tata Diusu sa Jabeituti Deja epusiu! ¡Tueda de echua puji David chenu sa familia jenetia! ¡Diusu sa ebani su tueda epusiu! ¡Diusu ja tueda paibunebata! ¡Gloria Tata Diusu! Daja tsiatsiatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Da su piada piada fariseo cuana ja Jesús uja atana: —Echua Puji, d'ayaque mique ebuqueji cuana be daja patsiatsiata huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesús ja jeutsutana huecuana: —Yama micuana butsepi equisainia, aimue yama d'aya mahue. Ahua tuneda emitanata su, tumu cuana da etsiatsiata. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Da su beju Jesús Jerusalén ejude naja su janariati putsu, papiruana tueda ejude jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Uja Jesús puana: —Jerusalén ejude su aniji cuana, ema da pueitia micuana saida epijajame puji. Beju micuaneda tsada mahue bana putsu, jiahue quita mu beju cuaja a taji mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Micuana sa majai cuana ja mida ebareta. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Micuana emanuamepeta huecuana. Micuana sa ete cuana edajajamepeta huecuana. Aimue piada tumu biame pia bia su yaniti mahue. Pamapa su epaimeta huecuana. Ye pamapa uja epu, Diusu micuana peje su pueana su, aimue micuaneda shanapaja mahue ana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Da su beju Jesús templo su nubiana. Iruiruji, bajabajaji cuana etseque su cuadejusiacuinatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Uja atana huecuana: —Beju uja derejiji Diusu sa quirica su: “Quema ete da pamapa cristiano cuana sa ema mitsu jude ete epu.” Beju micuaneda mu tsi puji sa ete ana. ");
INSERT INTO tnaNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Pamapa tsine Jesús ja cristiano cuana buetsuatana templo su. Da su beju sacerdote cuana sa echua puji, jacuatsasiati ebuetsuaji, Jerusalén ejude sa ehuidusuji cuana jaquisabatitana uja: “¿Cuaja ni da ecuaneda Jesús iname a cua emanuame puji?” ");
INSERT INTO tnaNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Beju cuaja ina taji mahue batana huecuana, cristiano cuana Jesús naja su jaid'abatitanina putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Pia tsine Jesús templo su netina. Cristiano cuana Diusu sa quisa saida cuana buetsuatanetina. Ebuetsuataneti cama, beju sacerdote cuana sa echua puji, jacuatsasiati ebuetsuaji, tata edhi ehuidusuji cuana Jesús peje su puetana. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Uja quisabatana huecuana: —Quisaque ecuanaju, ¿aiya mida huaratiatana ye ai cuana ya puji? ");
INSERT INTO tnaNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Da su Jesús ja jeutsutana huecuana uja: —Yama di micuana equisaba. Mejeutsuque ema. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Aiya Juan Bautista beitutana quisaquisa epu puji? ¿Diusu, ahua deja ja? Mejeutsuque ema. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Da su beju tuneda cama jaquisatitana uja: —¿Cuaja ni da ecuaneda jeutsume a cua? Ahua ecuaneda, “Diusu ja Juan beitutana”, ejeutsu su, Jesús ja ecuana uja equisabata: “Da su, ¿jucuaja su ni aimue micuaneda Juan jei ana mahue?” ");
INSERT INTO tnaNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Daja huecha ahua ecuaneda, “Deja ja Juan beitutana”, ejeutsu su, cristiano cuana ja ecuana tumu neje emaracata, Diusu ja Juan beitutana epibatitani huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Da su Jesús jeutsutana huecuana uja: —Bue mahue ecuanaju aiya Juan beitutana. Cuaja jeutsu taji mahue mi ecuanaju ebainia. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Da su Jesús ja atana huecuana: —Daja huecha aiya ema huaratiatana aimue yama micuana equisa mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Beju Jesús ja cristiano cuana daja hue buetsuainiame atana uja bahue quisa neje: —Piada deja ja uva jude bana putsu, pia deja cuana menajatiatana echuje su. Da su pia yahua su putiana quejucua mara puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Beju huiruhuiru badi cuinana su, deja ja mesa emebajaji beitutana uva jude echuje ebajati puji. Uva jude quinaji deja cuana ja emebajaji ina putsu, ichetana huecuana. Emetse peje su emebajaji beitutaibana huecuana echujetiaji mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Da su beju emetse ja pia emebajaji beitutana tuna peje su neicha echujebajati puji. Daja huecha atana huecuana emebajaji. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Neicha hue emetse ja pia emebajaji beitutana. Uva jude quinaji cuana ja nedaneda a putsu, emebajaji beitutaibana emetse peje su. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","‘Da putsu, emetse japibatiana uja: “Quema piada quita ibuneda ebacua yama ebeitu uva jude quinaji cuana peje su. Quema ebacua putsu, eiyubata huecuana.” ");
INSERT INTO tnaNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Beju uva jude quinaji cuana ja emetse sa ebacua ba putsu, tuneda cama jaquisatitana uja: “Tueda da emetse sa ebacua. Ahua ecuaneda tu manuame su, pamapa emetse sa ai cuana ecuaneseda puji pu cua. Da su ecuaneda ye yahua emetse pu cua.” ");
INSERT INTO tnaNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Da su beju emetse sa ebacua etsahua su rirena putsu, manuametana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Da su Jesús ja tu id'abaji cuana uja quisabatana: —¿Cuaja jia da emetse ja tueda uva jude quinaji ate cuana yata? Beju jasiapati putsu, tueda mudu puji ate cuana emanuamepeta. Uva jude pia mudu puji cuana emenajatiata. Daja cristiano cuana ja id'aba putsu, uja Jesús atana huecuana: —Be Diusu ja daja papu paata. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Da su beju Jesús ja tuna chama putsu, uja atana huecuana: —Micuaneda mue ema jei a. Da su, ¿cuaja ni da Diusu sa quirica su derejiji epuani? Beju uja epuani: Ete muduji cuana ja yapiruji tumu jusiaderatana biame, tueda tumu macha beju Diusu ja dharetana. Tueda pia tumu cuana ebia su saida ametana. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Quebata Diusu sa jadhareti tumu bia su edajaja su, beju tueda eped'uped'uati. Ahua tumu etse bia su edajaja su, etse emedimediata. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Sacerdote cuana sa echua puji, jacuatsasiati ebuetsuaji cuana ja da hora su quitaita Jesús inaja adhaatana, Jesús tuna jepuiti mimiana jashanapatitana huecuana putsu. Beju aimue Jesús inatana huecuana mahue, cristiano cuana iyubatana huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Da su piada piada deja cuana beitutana huecuana Jesús ecuadhita huecuana puji. Deja saida cuana nime jabametitana huecuana. Jesús quisabape neje madhada hue ejeutsume putsu, huaraji peje su etuaquisa puji adhaatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Da putsu, Jesús uja atana huecuana: —Ebuetsuaji, bahue ecuanaju mida butsepi emimiani. Miada Diusu sa ene quita jabuetsuati cuana ebuetsuainia. Pamapa cristiano cuana miada tupupai ebainia. Aida puji, puri cuana miada tupupai ebainia. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Da putsu, quisaque ecuanaju, ¿ahua saida ecuaneda romano echua puji aida impuesto echujetia puji, ahua mahue? ");
INSERT INTO tnaNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Beju Jesús jashanapatiana tuna madhada piba neje daja quisabatana. Ahua Jesús, “Saida echujetia puji”, epu su, da su judío cuana tu neje eduininita. Ahua, “Saida mahue echujetia puji”, epu su, da su romano soldado cuana ja einata. Da putsu, Jesús ja uja jeutsutana huecuana: —Beju micuaneda da bubeta cuana. ¿Jucuaja su micuaneda ema mimi neje pitsameja yainia? ");
INSERT INTO tnaNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Piada chipilu metiaque ema. Da su beju piada chipilu tiatana huecuana. Chipilu inatsu putsu, Jesús ja quisabatana huecuana uja: —¿Aidhe sa ebu eimea, ebani da ye chipilu bia su derejiji yani? Da su jeutsutana huecuana: —Tueda ebu eimea, ebani da romano echua puji aida sa. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Da su Jesús ja atana huecuana uja: —Da su metiaque echua puji aida sa epuani ai cuana. Diusu di metiaque tuseda epuani ai cuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jesús da saida jajeutsutiana putsu, aimue cuaja tuaquisa taji mahue batana huecuana cristiano cuana butse su. Ebia su nimetiunetitana huecuana, Jesús ja daja saida jeutsutana putsu. Beju mitanatana huecuana. Mue Jesús quisabaicha atana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tueda tsine su huecha hue piada piada saduceo cuana Jesús peje su putitana. Tueda saduceo cuana da manujiji cuana neicha eid'etayu aimue jei putana mahue. Da su uja Jesús atana huecuana: ");
INSERT INTO tnaNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Ebuetsuaji, Moisés chenu ja buetsuataidha uja: “Ahua quebata deja bacua mahue emanu su, manujiji sa edue ahue manujiji neje jahuaneti taji ebacua cuana edue manujiji sa bataji epu puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Beju siete edue cuana anitaina. Edue equene puji jahuanetiana. Beju bacua mahue manuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Da su tije puji edue da manujiji sa ahue manujiji neje jahuanetiana. Tueda macha beju manuana bacua mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Tu tije puji edue macha daja huecha puana. Beju pamapa tije puji edue cuana daja cama putana ahue manujiji neje. Beju manutana huecuana pamapa. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Da su beju epuna macha manuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Da su ahua ene mi epuani nime enetianatayu huecuana su, ¿quebata edue sa jia da tueda epuna ehuane epu? ");
INSERT INTO tnaNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesús ja uja jeutsutana huecuana: —Ye mundo su cristiano cuana ebutsenetitani. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Beju eid'etayu cuana mu aimue neicha ebutsenetitayu mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Aimue emanutaicha huecuana mahue, ángel cuana nime eputa huecuana putsu. Diusu sa ebacua cuana eputa huecuana, tu neje cielo su eid'e yanieniti putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Beju Moisés chenu ja quitaita ecuana bahue yametani manujiji cuana beju eid'etayu. Diusu ja tueda equi janana utsu pupe bue mahue jenetia mitsu putsu, uja ataidha: “Ema da Abraham, Isaac, Jacob cuana sa Diusu.” ");
INSERT INTO tnaNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Da su Diusu da eid'e cuana sa Diusu. Abraham, Isaac, Jacob cuana manutaidha biame, beju Diusu neje eid'e yanienita huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Da su piada piada jacuatsasiati ebuetsuaji cuana ja Jesús uja atana: —Echua Puji, saida miada jeutsuitia. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Da putsu, saduceo cuana ja aimue Jesús neicha quisabaja atana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús ja uja atana huecuana: —¿Cuaja micuaneda epibatiani Diusu sa Jabeituti Deja jepuiti? ¿A da tueda David chenu sa ebacua? ");
INSERT INTO tnaNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David ja quitaita uja deretaidha Salmos quirica su: Tata Diusu ja quema Echua Puji uja ataidha: ");
INSERT INTO tnaNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","“Aniuteque quema bai eni bene ema neje tupupai ecuatsasia epu puji, yama mi neje jamajaiti cuana pishitiame putsu, eme su eicha teje.” ");
INSERT INTO tnaNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Jucuaja su detse Diusu sa Jabeituti Deja da David chenu sa ebacua pu cua, David chenu ja quitaita “Quema Echua Puji” tueda ataidha putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Beju pamapa cristiano cuana ja Jesús ja mesa discípulo cuana uja yatani id'abatana: ");
INSERT INTO tnaNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Merejatique jacuatsasiati ebuetsuaji cuana neje. Tuneseda ebia su tsada ejud'uji bauda neje ejude duje epuniuneti puji. Tsada mecuana sa cristiano cuana ja iyuda neje saida pamitsuta. Jadhitati jude ete, tsine ete cuana su aniude eni bahui echacutani huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ahue manujiji cuana sa ete cuana mejemi bahueta huecuana. Cristiano cuana ja saida pabata huecuana puji risha tsabauda cuana pu bahueta. Da putsu, Diusu ja pia cuana ebia su castigo etiata huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Pia tsine Jesús templo su netina. Chipiluji deja cuana ja chipilu dueji erubiutasa emeji su Jesús ja batana. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ahue manujiji puri di mesa beta chipilu chidi ichapetana Jesús ja batana. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Da su Jesús ja cristiano cuana uja atana: —Enei hue, yama micuana yainia, ye ahue manujiji puri ja pamapa pia chipiluji cuana ebia su ichataitia. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tueda chipiluji cuana ja mecuana sa puchu epuani chipilu cuana ichataitia. Aimue mecuana sa chipilu ichape huecuana. Jucuada chipilu mecuana sa anideraitia. Beju ye epuna puri ichenu ja mu pamapa mesa yani chipilu ichapetaitia. Mesa ediaji chidi ebajati puji biame ichapetaitia. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Beju piada piada discípulo cuana templo jepuiti mimitanina. Tueda templo da tumu ania cuana neje ajiji. Cristiano cuana ja ai ania chidi cuana tiatana templo su eribaicha puji. Da su beju Jesús ja uja atana huecuana: ");
INSERT INTO tnaNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Ye templo edajajametayu tsine ecuina. Ye micuaneda tumu ania ebainia cuana pamapa edajajamepeta. Aimue piada tumu biame pia bia su yaniti mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Da su beju Jesús quisabatana huecuana uja: —Echua Puji, ¿quetsunu da ye ai cuana daja epu? ¿Cuaja ni ecuanaju shanapame a cua ye ai cuana daja epu? ");
INSERT INTO tnaNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Da su Jesús ja jeutsutana huecuana: —Tueda ai cuana puji mahue su, jucuada quema ebani su epueta. “Ema da Cristo. Ema tije meaque”, eputa huecuana. Beju be tije meaji huecuana. Merejatique tuna neje. Be mebaseametiji. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ejude cuana emajaitita quisa micuaneda eid'aba su, be merubutanaji. Ema jasiapatiji mahue su, beju ye ai cuana uja epupiru. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesús ja daja hue quisainiame atana huecuana: —Ejude cuana huamahuama emajaitita. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Yahua jubida erireta. Mid'e da epu. Tsapiapiati ai neda cuana ecuina pamapa yahua cuana je. Nimetiuda ai iyuda cuana cielo su cristiano cuana ja ebata. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","‘Beju tueda ai cuana daja puji mahue su, micuana tijetije a putsu, einata huecuana, micuaneda ema peje su jei epuani putsu. Jadhitati jude ete cuana su micuana edusuta huecuana ematse puji. Micuana eteriichata huecuana. Huaraji cuana butse su micuana edusuta huecuana. Pamapa tueda ai cuana micuana yata huecuana, micuaneda ema peje su jei epuani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Beju micuaneda tuna butse su ema jepuiti equisanetiacuinati. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Be mepibapibaji tuna butse su cuaja emimi puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Yama quitaita micuana da hora su mimi cuana etia tuna saida ejeutsu puji. Aimue micuana epishitiata huecuana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Beju micuana sa tata, edue, eshanapa cuana huaru micuana neje eduininita ema jepuiti. Micuana emenajatiata huecuana huaraji cuana peje su. Piada piada micuana emanuameta huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Pamapa cristiano cuana ja micuana eduininibata ema jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Beju micuana sa piada echuaina biame aimue etaitana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Daja biame, ahua micuaneda Diusu peje su enimetucheati su, cielo su tu neje eid'e yanienitiyu. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","‘Beju soldado cuana ja Jerusalén ejude ebareta su, bahue mepuque tipeida Jerusalén ejude etaitanape. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Da hora su Judea yahua su aniji cristiano cuana pajududuta emata cuana su. Daja huecha Jerusalén ejude su aniji cristiano cuana tueda ejude jenetia pacuinanata. Te su aniji cuana be ejude su pasiapatita. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","De tsine su castigo jubida epu, cuaja Diusu sa quirica su derejiji yani batame. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Aba epuna dheji, bacua edhereji cuana da tiempo su, yahua su ebia su neda epu putsu! Castigo jubida ecuina cristiano cuana peje su. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Piada piada cuana emanuta, jaicheti putsu. Pia cuana eteri puji edusuta huecuana pia yahua cuana su. Da jenetia su beju judío mahue cuana ja Jerusalén ejude yanitita Diusu ja d'eji etiata huecuana teje. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","‘Ema jasiapatiji mahue su, ai iyuda cuana id'eti, badi, atujai cuana su epu. Ye mundo su aniji cristiano cuana ebia su erubutanata, mar sa id'apadada cuana ebia su etsatineti id'aba putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Jucuada cristiano cuana enimetaitanata, iyuame pu putsu. “¿Cuaja jia da ye mundo epu?” eputa huecuana. Pamapa cielo su aniji ai cuana jubida eriariapeta. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Da su beju ema cielo jenetia ebutesa cristiano cuana ja ebata. Judu duje tucheda, hueda neje ema epusiu ebata huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Beju tueda ai iyuda cuana epupiruta su, beidaji neje menimetucheatique, tipeida micuaneda d'eji su epu putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesús ja bahue quisa neje daja hue quisainiame atana huecuana: —Mepibatique aqui cuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Beju eina eichacua chidi eturucatitani su, da su jad'iati badi cuana enariatiani micuaneda eshanapainia. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Daja huecha tueda ai nimetiuda cuana ba putsu, meshanapaque Diusu ecuatsasiati beju huedhue. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","33","Ene putsu, yama micuana equisainia, pamapa tueda ai nimetiuda ebapirutani cuana aimue emanuta mahue tsuhu ema epueicha teje. Beju cielo, mundo epupe biame, quema mimi mu aimue epupe mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","‘Merejatique. Ema esiapati su, be yama micuana tueda ai madhada cuana yainia mebiateje. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Daja da epu ye mundo su aniji cuana neje. Ema esiapati tsine da tuneseda puji jupacha nime epu. Tipeida ema esiapati tuna ecastiga puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Da su janimepitijiji meanique. Diusu daja hue memitsuderaque. Ahua daja micuaneda ya su, pamapa tueda ai iyuda cuana epusiu jenetia d'eji su epu ema butse su saida ebameti puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Tsine, Jesús ja cristiano cuana buetsuataina templo su. Dhidha su Olivo murucu aida su putiana dapia ehuena teje yaniti puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Cristiano cuana pamapa apudaya templo su putitana Jesús eid'aba puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Beju pascua tsine hue quita hue su. Tueda tsine su cristiano cuana ja pan levadura mahue dia bahue putaina. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Sacerdote sa echua puji, jacuatsasiati ebuetsuaji cuana uja jaquisabatitana: “¿Cuaja ni da ecuaneda cristiano cuana duininiameji, mahue manuame a cua Jesús?” Beju daja jaquisabatitana huecuana, cristiano cuana iyuba putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Da su Ishahua ja Judas Iscariote pibametana Jesús pamenajatiata puji. Tueda Judas da Jesús sa apóstol puina. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Da su beju Judas templo su putiana sacerdote sa echua puji, templo quinaji cuana neje equisati puji. Cuaja Jesús menajatiame ya quisatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Da su beidaji putana huecuana. Tipeida Judas chipilu etia jamitsuti tiatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas ja jei atana huecuana. Da hora jenetia pibapirutana huecuana cuaja Jesús menajatiame ya puji cristiano cuana mahue su. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pascua tsine beju cuinana. Tueda tsine su cristiano cuana ja pan levadura mahue dia bahue putaina. Huisha janana Diusu peje su irutsua bahue putaina huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Da su Jesús ja Pedro, Juan detse uja cuatsasiatana: —Mebasetatique ecuaneda pascua tsine jana edia puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tuatseda Jesús quisabatana: —¿Quepia ni da etseju baseta cua? ");
INSERT INTO tnaNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús ja jeutsutana tse: —Ejude enubiji su piada deja yahui matu jadusuti metseda etsu. Tije meatique tueda. Tueda enubiti ete su metse ete emetse echacu. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ete emetse uja meaque: “Echua Puji ja mi uja equisabametani: ‘¿Quepia d'eji yani yama quema discípulo cuana neje pascua tsine jana edia puji?’” ");
INSERT INTO tnaNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Da su ete emetse ja diadia jude aida, basetajiji ete ebaque su ebameta. Dapia mebasetaque jana. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Da su putiana tse. Cuaja Jesús ja tuatseda quisatana batame tejetana tse. Dapia d'eji su pascua tsine jana basetatana tse. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tsine beju cuinana su, Jesús, mesa apóstol cuana neje tueda ete su cuinana. Beju aniutetana huecuana tsine jana edia puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Da su Jesús ja uja atana huecuana: —Ema manuji mahue su, ye pascua tsine yama saida baja yainia micuana neje. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Yama micuana butsepi equisainia, aimue yama ye tsine ebaicha mahue Diusu ecuatsasiati ecuina teje. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Da su Jesús ja vinoji emeji jemitsuatana. Diusulupai Tata Diusu a putsu, apóstol cuana uja atana: —Ye vino micuaneda cama meberereatiatique. Meid'ipeque. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Yama micuana equisainia, aimue yama ye vino eid'iicha mahue Diusu ecuatsasiati ecuina teje. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Da su beju pan jemitsuatana. Diusulupai Tata Diusu a putsu, pan ped'uped'uatana. Apóstol cuana pan ped'u cuana berereatiatana. Uja atana huecuana: —Ye pan ped'ujiji da quema equita pu cua nime. Ye quema equita da Diusu peje su eirutsuati micuaneseda puji. Mediapeque, ema piba putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Daja huecha vinoji emeji atana, diadiape putsu. Uja Jesús ja atana huecuana: —Ye vino da quema ami d'uichajiji pu cua nime. Quema ami d'uichajiji putsu, Diusu ja cristiano cuana mesa jamitsuti eichacua etiata. Quema ami ed'uichati putsu, Diusu ja micuana eperdonata. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","‘Jiahue quita ema menajatiaji epu deja upia ema neje ediadiani. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Beju ema sufri yameta huecuana, cuaja Diusu sa quirica su derejiji yani batame. ¡Aba, ema menajatiaji epu deja! ");
INSERT INTO tnaNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Da su beju tuneda cama uja jaquisabatitana: “¿Aidhe jia?” ");
INSERT INTO tnaNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Da su beju, quebata tuneda ebia su aida, jacuicuinatitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Da putsu Jesús ja atana huecuana uja: —Ye mundo sa huaraji cuana ja cristiano cuana jubida neje ecuatsasiatani. Tueda huaraji cuana da emetse nime cristiano cuana ja ebatani. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Micuaneda mu be daja mepuji. Quebata micuaneda ebia su aida puja su, tueda da micuana sa emebajaji pu taji. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Aidhe jia ebia su aida, ahua deja misha su ediadiani, ahua mesa emebajaji? Deja misha su yani da emebajaji ebia su aida. Beju ema da micuana sa emebajaji pu cua nime. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","‘Micuaneda ema neje aniana, ema sufri epuani tupu. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Da putsu beju, yama micuana huaraji aida eicha. Quema Tata Diusu ja ema huaraji aida ichatana nime, daja nime yama micuana yayu. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Micuaneda ema neje ediadiati quepia yama ecuatsasia su. Micuaneda huaraji aida sa aniude su yaniute pamapa israelita cristiano cuana ecuatsasia puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesús ja Pedro atana: —Simón, Ishahua ja Diusu bajatana micuana jubida yaba puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Beju yama Diusu jubida bajana tu peje su mique janimetucheati cuana ehueiti mahue puji. Da su beju mida ema peje su enimetucheatiicha su, nimetucheameque mique edue cuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Da su Simón ja Jesús uja atana: —Echua Puji, ema da mi tije epu emanu teje. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús ja Pedro jeutsutana: —Pedro, yama mi butsepi equisainia, jiahue dhidha huaripa deja queiji mahue su, “Aimue yama Jesús shanapa”, quimisha nuati mida epu. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Da su beju Jesús ja quisabatana huecuana uja: —Mepibatique. Yama micuana shitara, chipilu, pulucu mahue beituana su, ¿a da micuana sa ai cuana hueitiana? Da su jeutsutana huecuana uja: —Mahue. Aimue ecuanaju sa hueiti puana. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Da su Jesús ja atana huecuana uja: —Beju jiahue mu jadusuti taji. Quebata shitaraji, chipiluji beju padusuta. Quebata espadaji mahue su, mesa saco pairuta espada ebaja puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Enei hue yama micuana equisainia, ema jepuiti Diusu sa quirica su derejiji yani cuana daja pu taji. Uja derejiji yani ema jepuiti: “Cristiano cuana ja Diusu sa Jabeituti Deja matsetana deja madhada cua nime.” Pamapa ema jepuiti derejiji yani mimi cuana daja epu. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Da su Jesús atana huecuana uja: —Echua Puji, hue upia beta espada yani. Da su Jesús ja jeutsutana huecuana: —Beju tupu. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Da su beju Jesús, discípulo cuana neje ete jenetia cuinanana putsu, Olivo murucu aida su putiana. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Dapia cuinati putsu, discípulo cuana uja atana: —Daja hue Diusu memitsuderaque Ishahua ja aimue micuana jucha yameta mahue puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Da su Jesús, discípulo cuana peje jenetia chuadera pad'i putiana. Dapia tururuana Diusu neje emitsu puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Uja Diusu atana: —Tata, d'eji su ema aque curusu su sufrimiento epusiu jenetia. Daja biame, mique tsada bahui papu. Be quema tsada mu papu. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","44","Tueda jubida sufri epuani putsu, ebia su Diusu neje jamitsutiana. Mesa hueu da ami ed'ud'uani nime puana, tueda ebia su jubida sufri epuani putsu. Ángel tu peje su bataji puana cielo jenetia tu enimetucheame puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Da su beju Jesús netiana putsu, discípulo cuana peje su putiana. Ebia su epibapibatani huecuana putsu, pamapa su tahuitana huecuana Jesús ja batana. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Da su Jesús ja uja atana huecuana: —¿Jucuaja su micuaneda etahuisa? Menetianaque. Diusu memitsuniaque Ishahua ja micuana epirubata mahue puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús ja discípulo cuana daja equisatani cama, jucuada deja cuana beju cuinatana. Judas ja huidusucuinatana huecuana. Tueda da Jesús sa discípulo puina. Beju Jesús nariatana budhi neje tu emitsu puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Judas ja Jesús budhitana su, Jesús ja uja atana: —Judas, ¿ebudhinia je miada Diusu sa Jabeituti Deja emenajatiainia? ");
INSERT INTO tnaNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Beju discípulo cuana ja ba putsu, uja quisabatana huecuana: —Echua Puji, ¿ahua ecuanaju espada neje jabiahuanati cua? ");
INSERT INTO tnaNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Da hora su hue piada discípulo ja sacerdote cuana sa echua puji sa emebajaji sa bai eni bene eid'aja siquijusiatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Da su beju Jesús ja cuatsasiatana huecuana: —Da teje hue. Be daja meaji. Jesús daja emimiani je, emebajaji sa eid'aja d'apabatana. Beju saisiametana eid'aja. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Da su beju Jesús ja tu edusu puji puetana deja cuana chamatana. Uja atana huecuana: —Micuaneda pueitia espada, aquiriji cuana neje ema eina puji, ema tsi puji pu cua nime. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ema templo su pamapa tsine micuana neje yani su, ¿jucuaja su ni da aimue micuaneda ema inana mahue? Beju ye da micuana sa hora, ema epishitiame puji, Ishahua ja micuana daja ema ai madhada ya puji yametani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Da su Jesús inatana huecuana. Sacerdote cuana sa echua puji aida sa ete su dusutana huecuana. Beju Pedro tuna tije putiana uqueda uqueda. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ete su cuinati putsu, pia cuana ja cuati turutana etsequeini su. Cuati naja su aniutetana huecuana. Da su Pedro di cuati naja su tuna duju su aniuteana. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Piada emebajaji epuna ja Pedro cuati naja su yani batana. Epuna ja Pedro chamasaisiatana. Tueda uja puana: —Ye deja da Jesús neje puniunetina. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Beju Pedro ja epuna atana: —Epuna, aimue yama tueda eshanapainia mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Su pad'i su piada deja ja Pedro ba putsu, uja atana: —Mida da Jesús sa piada ebuqueji. Beju Pedro ja tueda deja atana: —Deja, aimue ema mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Beju piada hora tupu su neicha pia deja uja puana: —Enei hue, ye deja Jesús neje puniunetina, tueda Galilea yahua jenetia huecha putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Da su beju Pedro ja tueda deja uja atana: —Deja, yama mue shanapa ai jia mida emimiani. Da hora su beju Pedro emimiani su, huaripa deja queiana. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Da su Jesús jababarereati putsu, Pedro chamatana. Pedro cuaja Jesús ja tu quisatana su, japibatiana uja: “Jiahue dhidha huaripa deja queiji mahue su, ‘Aimue yama Jesús shanapa’, mida epu quimisha nuati.” ");
INSERT INTO tnaNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Da su beju Pedro etseque su cuinana putsu, ebia su pana. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jesús inatsihuaji deja cuana tu neje jashishatitana. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Jesús tuarisi putsu, ebu su ichepirutana huecuana. Uja Jesús atana huecuana: —Quisaque ecuanaju aiya mida ichetaitia. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Pia mimi madhada cuana neje Jesús madhabatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Beju huenana su, judío cuana sa huaraji aida cuana jadhitatitana. Tata edhi ehuidusuji, sacerdote huaraji aida, jacuatsasiati ebuetsuaji cuana jadhitatitana. Tuna butse su Jesús dusutana huecuana. Da su Jesús quisabatana huecuana uja: ");
INSERT INTO tnaNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—¿A da mida Diusu sa Jabeituti Deja? Quisaque ecuanaju. Da su Jesús ja jeutsutana huecuana: —Ahua yama micuana, “Ema da Diusu sa Jabeituti Deja”, ya su, aimue micuaneda ema jei ya mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ahua yama micuana equisaba su, aimue micuaneda ema ejeutsu mahue. Daja huecha aimue micuaneda ema emesia mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Beju jiahue jenetia ema Diusu aida, tucheda eni sa bai eni bene su yani micuaneda eba. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Da su quisabatana huecuana uja: —¿A da mida Diusu sa Ebacua? Jesús ja jeutsutana huecuana: —Ehe. Ema da. Micuaneda quitaita daja epuani. ");
INSERT INTO tnaNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Da su beju jaquisatitana huecuana: —¿Ai puji ni da ecuaneda pia jatuaquisatiji cuana tsa cua? Beju da ecuaneda quitaita id'abaitia tusa mimi madhada cuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Da su pamapa su netiana putsu, Jesús dusutana huecuana romano huaraji aida Pilato peje su. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tu butse su Jesús uja tuaquisapirutana huecuana: —Ye deja ja cristiano cuana enimetipeimetani. Tuahueda cristiano cuana romano echua puji aida impuesto pachujetiata mahue ebuetsuatani. Ed'eji su tueda pa judío cuana sa echua puji epuani. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Da su beju Pilato ja Jesús quisabatana: —¿A da mida judío cuana sa echua puji? Jesús ja jeutsutana: —Ehe. Ema da, cuaja mida epuani batame. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Da su Pilato ja sacerdote huaraji aida, pia dapia aniji cristiano cuana uja atana: —Mue yama ye deja sa ai jucha biame ba. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Da su beju cha ebia su hue Jesús tuaquisatana huecuana uja Pilato butse su: —Ye deja ja cristiano cuana ebia su enimetipeimetani. Galilea yahua su pupiruana. Jiahue upia Jerusalén ejude su di daja yatani. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Daja id'aba putsu, Pilato ja quisabatana huecuana: —¿Da su jia da ye deja Galilea yahua jenetia? ");
INSERT INTO tnaNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pilato jeutsutana huecuana uja: —Ehe. Da jenetia tueda. Da su beju Pilato ja Jesús beitutana echua puji Herodes Antipas peje su tueda ai enime cuana pabata puji, Herodes Antipas da Galilea yahua sa echua puji puina putsu. Da tsine su huecha tueda Jerusalén ejude su anina. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Beidaji puana, Jesús ba putsu, tu yatani nimetiuda ai cuana jepuiti bahue puana putsu. Da su beju ebia su Jesús bajapirutana pia nimetiuda aida paata puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Jesús ebia su piapiati ai cuana quisabatana biame, mue jeutsu atana. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Dapia da sacerdote huaraji aida, jacuatsasiati ebuetsuaji cuana ja Jesús jubida tuaquisatana Herodes Antipas butse su. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Da su beju Herodes Antipas ja mesa soldado cuana neje Jesús ai eni mahue nime batana. Jesús jud'utana huecuana huaraji sa ejud'uji chujeneda neje, tu neje eshishatiani je. Daja ape putsu, Herodes Antipas ja Jesús neicha Pilato peje su beitutana. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Da tsine su Pilato, Herodes Antipas neje eshanapa jaatiana tse. Equene mu duininida jabatina tse. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Da su beju Pilato ja sacerdote huaraji aida, ejude sa huaraji, pamapa cristiano cuana ihuatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Uja atana huecuana: —Micuaneda ye deja ema peje su duseitia, tuahueda cristiano cuana enimetipeimetani pu putsu. Beju yama tueda saida quisabaenitia micuana butse su. Mue yama mesa ai jucha biame ba, cuaja micuaneda tu etuaquisainia nime. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes Antipas ja di aimue mesa ai jucha biame batana mahue, Jesús neicha ema peje su beitutana putsu. Beju ye deja ja aimue ai madhada biame a yama tu emanuame puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Da su yama tueda huacabiti neje iche putsu, emesiayu. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Beju pamapa pascua tsine su Pilato ja piada terijiji mesia bahue puina cristiano cuana beidaji yame puji. Da su tueda pascua tsine su Jesús mesiaja adhaatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Da su cristiano cuana bahue pu putsu, uja tsiatsiatana huecuana: —Barrabás da mesiaque. Jesús mu be mesiaji. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Tueda Barrabás da deja manuameji puina. Romano soldado cuana neje jamajaitiana. Da putsu, tueda teriichanubiametana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato ja cristiano cuana neicha quisatana, Jesús mesiaja putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Beju cristiano cuana id'aba putsu, cha ebia su jubida tsiatsiatana huecuana uja: —¡Curusu su tataque! ¡Curusu su tataque! ");
INSERT INTO tnaNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Beju neicha quimisha nuati puji Pilato ja cristiano cuana atana: —¿Ai puji ni? ¿Ai jucha ni da tuahueda atana? Mue yama ye deja sa ai jucha biame ba. Da su yama huacabiti neje iche putsu, emesia. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Beju cha ebia su hue cristiano cuana uja tsiatsiatana jubida: —¡Curusu su tataque! ");
INSERT INTO tnaNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Da su ebia su daja tsiatsiatana huecuana putsu, Pilato ja tuna sa tsada atana beju. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Deja manuameji Barrabás mesiatana. Jesús tuna sa tsada epuani paata huecuana puji menajatiatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Da su beju Jesús dusutana huecuana tu curusu su etata puji. Edusutahu huecuana su, piada deja Simón banime soldado cuana inatana. Tueda deja da Cirene yahua jenetia puina. Tueda cuatsasiatana soldado cuana ja curusu pamapata puji. Da su tuahueda Jesús tije curusu mapatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jucuada cristiano cuana tije putitana. Daja huecha jucuada epuna cuana di Jesús tije panatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesús ja tu tije ebia su epatahu ba putsu, uja atana huecuana: —Jerusalén ejude jenetia epuna cuana, be mepaji ema jepuiti. Beju micuaneseda puji, daja huecha micuana sa ebacua cuana sa puji bahui mapaque. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Beju tsine iyuda cuana ecuina. Da tsine su bacua mahue cuana beidaji eputa. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Da tsine su cristiano cuana ja emata cuana ebajata uja: “Ecuanaju bia su medajajaque ecuanaju erubuti puji.” ");
INSERT INTO tnaNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Jiahue ema daja yatani huecuana biame, ebia su ai madhada cuana micuana yata huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Beju beta deja tsi puji detse Jesús neje dusutana huecuana etata puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Da su Calavera banime eti jude su cuinatitana huecuana su, dapia Jesús curusu su tatatana huecuana. Beta tsi puji deja detse di curusu detse su tatatana huecuana. Piada Jesús sa bai eni bene, pia d'ani bai bene tatatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesús etatatani huecuana cama, uja tuahueda Diusu atana: —Tata, perdonaque ye cuana, bue mahue ta huecuana putsu. Da su beju soldado cuana ja suerte atana Jesús sa ejud'uji tuneda cama eberereatiati puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Pamapa cristiano cuana dapia chamachamanetitaina. Tata edhi ehuidusuji cuana Jesús neje jashishatitana. Uja putana huecuana: —Tuahueda pia cuana d'eji su atana. Ahua tueda ene quita Diusu sa Jabeituti Deja su, da su tu mehua d'eji su paati. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldado cuana ja di Jesús neje jashishatitana. Vino najaitianajiji tiaja adhaatana huecuana tu eid'ita puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Tuneda di Jesús uja atana: —Ahua ene quita mida judío cuana sa Echua Puji su, mi mehua d'eji su jaatique. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Beju curusu su mesa echua bia su mimi cuana deretana huecuana. Quimisha yana cuana su deretana huecuana. Griego, latín, hebreo banime yana cuana su deretana huecuana uja: “Ye da judío cuana sa echua puji.” ");
INSERT INTO tnaNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Piada tu naja su badejiji tsi puji ja Cristo uja madhabatana: —Ahua ene mida Cristo su, mi mehua d'eji su jaati putsu, etseju di d'eji su aque. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pia tsi puji ja mu daja epuani id'aba putsu, d'ayatana uja: —Miqueda mu aimue Diusu iyuda mahue, mida di emanu biame. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Etseda sufri epuani beju emanu teje, ai madhada cuana ana putsu. Ye deja ja mu mue ai madhada biame a. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Da su beju tuahueda Jesús uja bajatana: —Jesús, pibaque ema, mi ecuatsasiati su ecuinati su. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Da su Jesús ja tueda jeutsutana: —Enei hue yama mi butsepi equisainia, jiahue tsine mida ema neje cielo su yaniti. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Beju buepatia biame, apuda puana buepatia badeute uqueda teje, id'eti apunana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Da hora quitaita su templo dume su telón aida, bauda, pamuda badeji ebia jenetia ema su cuata jabud'iutiana. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Da hora su Jesús uja tsiatsiana: —Tata, yama quema enid'u mi emenajatiainia. Daja emimiani je, manuana beju. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Soldado cuana sa capitán tueda ai cuana chama putsu, Diusu saida mitsutsuatana. Uja puana: —Enei hue, ye deja mu da jucha mahue epu mane. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Pamapa chamatana cristiano cuana ebia su epibapibani je, jachuainati putsu, putitaibana. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesús sa eshanapa cuana bahui anititana. Jesús tije aji Galilea yahua jenetia epuna cuana di anititana. Uqueda jenetia pamapa tueda ai cuana chamatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Beju piada deja anina José banime. Tueda Arimatea ejude Judea yahua jenetia puina. Deja saida, butsepi, judío cuana sa piada ehuidusuji puina. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Diusu ecuatsasiati id'uataina. Da putsu, tuseda mu tsada mahue puana pia ehuidusuji cuana ja Jesús atana cuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Da su beju Pilato peje su putiana Jesús sa equita ebaja puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Curusu jenetia equita jemiute putsu, ebabuji saida neje babutana. Sepulcro su huananubiatana. Tueda sepulcro tumu epa su ye chu ajiji puina. Aidhe biame tsuhu huananubiajiji mahue puina. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Beju viernes tsine puina. Tueda tsine su cristiano cuana jabasetati bahue puina janahua tsine su puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Da su Jesús tije aji Galilea yahua jenetia epuna cuana putitana Jesús sa equita quepia, cuaja huananubiajiji esa eba puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Da su ete su jasiapati putsu, ai puida cuana basetatana huecuana Jesús sa equita bia su eicha puji. Janahua tsine beju cuinana su, pamapa su janahuatana deja jacuatsasiati putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Domingo tsine su apudaya enieni su epuna cuana Jesús huananubiajiji esa su jasiapatitana. Ai puida cuana basetajiji beju dusutana huecuana. Pia epuna cuana ja di buquetana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Dapia cuinati putsu, aimue tumu aida neje sepulcro terijiji mahue batana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Beju sepulcro dume su nubi putsu, aimue Jesús sa equita esa batana huecuana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Daja ba putsu, tuna enimetiuni cama, beta deja tuna naja su bataji puana. Jud'uji pasane cuarecuareji puina tse. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tuatse ba putsu, epuna cuana tud'isatiana yahua su cuata tuatse butse su, rubutanatana huecuana putsu. Da su deja detse ja uja epuna atana: —¿Ai puji ni da micuaneda Cristo eid'e echacuinia manujiji jude su? ");
INSERT INTO tnaNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Aimue tueda upia esa mahue. Beju id'eitiba. Mepibatique tuahueda micuana Galilea yahua su anina su, uja atana: “Ema emenajatiata huecuana deja juchaji cuana peje su. Ema curusu su etatata huecuana biame, quimisha tsine jenetia ema eid'eyu.” Daja micuana equene Jesús ja quisatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Da su beju Jesús sa mimi cuana su japibatitana. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Apóstol, pia jei eputani cuana peje su putitaibana huecuana. Cuaja Jesús id'eyume puana pamapa quisa pupeana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ye quisa duseji epuna cuana da banime María Magdalena, Juana, María Jacobo sa cuara. Pia epuna cuana di tuna neje anitaina. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Apóstol cuana ja epuna sa quisa cuana aimue jei atana mahue, tseitsi nime hue tuna sa quisa batana huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Beju Pedro ja mu tueda quisa id'aba putsu, tipeida jududutiana sepulcro su ebati puji. Cuinati putsu, sepulcro dume chamatana. Ebabuji bahui tanujajiji yani batana. Da su jasiapatiana mesa ete su. Ebia su Pedro nimetiuana, daja ai cuana ba putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tueda tsine su quitaita beta Jesús peje su jei epuani detse Emaús ejude su puhuina. Tueda ejude da Jerusalén ejude jenetia piada tunca piada ejaitiana kilómetro uquedame puina. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tuatseda betana su pamapa ai cuaja puitia cuana quisaquisa puhuina. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Quisaquisa epuani cama, Jesús quitaita tuatse peje su janariati putsu, tuatse neje asepiruana. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Beju tuatseda Jesús batana biame, mue shanapa atana tse. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Da su beju Jesús ja quisabatana tse uja: —¿Ai quisaquisa metse epuani, yaseneti cama? ¿Jucuaja su ni da metseda ebia su epibapibani? ");
INSERT INTO tnaNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Piada tuatseda Cleofas banime ja. Jesús jeutsutana uja: —Beju pamapa Jerusalén ejude su aniji cuana bahue cuaja ai cuana puana. ¿Cuaja ni da mida bue mahue Jerusalén ejude jenetia biame? ");
INSERT INTO tnaNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Da su Jesús ja uja quisabaderatana tse: —¿Jucuaja da ai pujiji? Da su Jesús uja quisapirutana tse: —Jesús Nazaret ejude jenetia da profeta tucheda puina. Pamapa mesa ai jaati, mimi cuana da tucheda saida puina Diusu, cristiano cuana butse su. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Sacerdote huaraji aida, tata edhi ehuisdusuji cuana ja tueda menajatiatana, matse putsu, curusu su pamanuameta huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tuahueda pamapa israelita cristiano cuana d'eji su yata ecuanaju japibadhaatiana. Beju jiahue neje quimisha tsine manuametana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Piada piada epuna cuana ja ecuanaju rubutanametana. Tuneda apudaya enieni Jesús huananubiajiji esa su putitana. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Tusa equita aimue beju batana huecuana. Da su beju tipeida jasiapatitana ecuanaju peje su. Angel detse pa batana huecuana. Tueda ángel detse ja pa Jesús da eid'e ecuanaju atana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Da su beju piada piada ecuanaju sepulcro su putitana eba puji. Beju tuneda batana, cuaja epuna cuana ja ecuanaju quisatana batame. Daja biame, Jesús mue ba atana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Da su beju Jesús uja atana tse: —Metseda beju bue mahue eni. Atadhada metseda profeta chenu cuana sa mimi cuana derejiji yani su jei epu puji. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Aimue jia maida equene Cristo sa sufri pu taji puina mahue, tusa gloria su nubiji mahue su? ");
INSERT INTO tnaNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Da su Jesús ja buetsuapirutana tse pamapa Diusu sa Cristo jepuiti derejiji yani mimi cuana. Moisés chenu ja deretaidha quirica cuana jenetia, profeta chenu cuana ja deretaidha quirica cuana teje buetsuapirutana tse. Tueda quirica Cristo jepuiti quisa epuani cuana Jesús ja edid'i su epuhu je, pibametana tse. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Da su beju ejude su cuinati putsu, Jesús daja hue jaitianaja pudhaana. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Beju aimue tuatseda pajaitiana atana mahue. Tuatseda Jesús uja atana tse: —Upia hue etseju neje anitique, beju yapunani putsu. Da su Jesús tuatse neje ete su nubiana. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Misha su aniuteana huecuana ediadia puji. Aniute putsu, Jesús ja pan inatana. Diusulupai Tata Diusu atana. Beju pan ped'u putsu, tiatana tse. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Da hora su shanapatana tse tueda da Jesús. Daja tuatse epuani cama, Jesús tuatse butse su taitanana. Da su tuatseda jaquisatiana uja: ");
INSERT INTO tnaNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","—Enei hue, etseju sa muesumu beidaji puana, tuahueda etseju Diusu sa mimi derejiji yani edid'i su buetsuatana su. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Da su beju tipeida jasiapatiana tse Jerusalén ejude su. Dapia piada tunca piada ejaitiana apóstol cuana pia jei eputani cuana neje tsutana tse. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tuatseda uja atana huecuana: —Enei hue, Echua Puji id'eibana Simón ja batana. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Da su beju pamapa ai cuaja batana tse quisatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Beju daja equisatitani cama, Jesús bataji puana tuna duju su. Bataji pu putsu, mitsutana huecuana uja: —Menimepijajaque. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Beju ebia su rubutanatana huecuana, enid'u ebainia pepe putana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Da su Jesús ja atana huecuana uja: —¿Ai puji ni micuaneda erubutanani? ¿Jucuaja su ni micuaneda aimue jei epuani mahue? ");
INSERT INTO tnaNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mechamaque quema eme, ehuatsi su etsi cuana. Beju ema hue da. Chamaeni putsu, med'apabaque ema. Aimue ema enid'u mahue. Ema quitaji beju. Enid'u mu quita mahue. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Da su Jesús ja mesa eme, ehuatsi detse bametana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Beju tuneda beidaji eputani biame, aimue jei puja quita putana huecuana mahue, ebia su nimetiunetitana huecuana putsu. Da su Jesús ja atana huecuana uja: —¿Ahua micuana sa yani ai dia taji cuana? ");
INSERT INTO tnaNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","Da su Jesús se esina ped'u chidi, piada huasa ena matu chidi tiatana huecuana su, tune butse su diatana. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Diape putsu, uja Jesús ja atana huecuana: —Ema micuana neje anina su hue, ema manuameji mahue su, yama micuana pamapa cuaja ema epu quisana. Beju jaitianana, cuaja yama micuana quisana batame. Pamapa ema jepuiti derejiji yani ai cuana beju puana. Tueda ai cuana derejiji yani Moisés chenu, profeta chenu cuana sa quirica cuana su. Daja huecha Salmos quirica su derejiji yani ai cuana beju daja puana. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Da su beju Jesús ja Diusu sa quirica su tu jepuiti derejiji yani ai cuana shanapametana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Uja atana huecuana: —Uja da derejiji yani: “Cristo manu putsu, quimisha tsine jenetia eid'eyu. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Pamapa yahua je tusa ebani su tusa quisa saida cuana quisaquisa eputa. Equene Jerusalén ejude su quisaquisa epupiruta pamapa yahua je quisaquisa epupe teje. Cristo sa ebani su quisaquisa eputa cristiano cuana Diusu peje su papibaturucatita puji. Daja eputa huecuana su, Diusu ja tuna sa jucha cuana eperdonatayu.” ");
INSERT INTO tnaNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Beju bahue micuaneda pamapa ye ai cuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yama micuana peje su Espíritu Santo ebeitu, cuaja quema Tata Diusu ja micuana jamitsuti tiatana batame. Meanique upia Jerusalén ejude su Diusu sa Espíritu Santo tucheda micuana peje su cielo jenetia ecuina teje. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Da su beju Jesús ja Jerusalén ejude tsahua su Betania ejude chidi naja su dusutana huecuana. Dapia mesa eme detse jemitsua putsu, “Tata Diusu ja meibunebataque”, atana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Daja a putsu, Jesús tuna peje jenetia cielo su tsuatibana. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Da su beju discípulo cuana beidaji jubida neje jasiapatitana Jerusalén ejude su. ");
INSERT INTO tnaNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Pamapa tsine templo su anitaina huecuana Diusu emitsutsua puji. Daja papu.");
INSERT INTO tnaNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Equene beju Jesucristo anidha. Ye mundo aniji mahue su, beju anidha. Tata Diusu bameji epuani. Ye mundo su pueana cristiano cuana peje su Tata Diusu ebameti puji. Tueda da Diusu putsu, equene jenetia Tata Diusu neje anidha. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Equene pamapa ai cuana ajiji mahue su, tueda mu Tata Diusu neje anidha beju. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tu jepuiti Tata Diusu ja pamapa ai cuana ataidha. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tu jepuiti pamapa su eid'e eputani. Cuaja id'eti ja cristiano cuana hueda etiatani nime, daja tuahueda Diusu sa quisa saida cuana cristiano cuana equisatani. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Apuda ja hueda cuaja dhamu taji mahue ebatani nime, daja da ai madhada cuana ja mesa jabuetsuati saida cuana aimue nahuebata cua mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Jesucristo ja buetsuapiruji mahue su, piada deja anina. Tueda Juan Bautista banime puina. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Diusu ja cristiano cuana peje su tueda beitutana Jesucristo jepuiti quisaquisa papu puji, Jesús peje su jei paputa huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Beju aimue Juan Tata Diusu bameji puina mahue. Tueda pueana Jesucristo jepuiti cristiano cuana peje su quisaquisa epu puji bahui. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jesucristo ja mu butsepi neje Tata Diusu bametana cristiano cuana peje su. Tueda ye mundo su pueana cristiano cuana Diusu sa ene quita quisa saida cuana equisa puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ye mundo su anina biame, Tata Diusu ja tu jepuiti pamapa ai cuana ataidha biame, cristiano cuana ja mue shanapa atana. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Mesa judío cristiano quitaita cuana peje su pueana biame, aimue batsutana huecuana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pamapa tu batsu putsu, jei putana cuana mu Diusu sa ebacua cuana atana. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Cristiano cuana da bacuaji eputani mecuana sa utsatada jenetia hue. Diusu ja mu ecuana mesa ebacua yatani, cuaja mesa tsada epuani nime bahui. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jesucristo da Diusu bameji epuani. Tueda da deja bataji puana. Ecuana duju su ibuneda neje ye mundo su puniunetina. Butsepi mimiana. Tata Diusu sa piada quita Ebacua putsu, ebia su saida puina beju ecuanaju bana. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan Bautista da tu jepuiti uja quisa puana: —Ye Jesucristo jepuiti ema quisaquisa puana. Ema tije epusiu biame, ema ebia su aida, ema bataji puji mahue su, tueda anidha putsu. Daja Juan Bautista Jesucristo jepuiti cristiano cuana peje su quisa puana. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jesucristo ja ecuana ebia su mesa jaibunebati tiatana, ecuana ebia su ibuneda ebatani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisés chenu ja ecuana jacuatsasiati jubida cuana bahui tiataidha. Beju Jesucristo ja mu ecuana ebia su ibunebatana. Mesa ene quita quisa saida cuana ecuana buetsuatana. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Beju aimue quetsunu su biame aiya Tata Diusu ba. Tusa piada quita Ebacua ja bahui tueda batana, tu naja su yani putsu. Tuahueda ecuana cuaja Diusu quisatana. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalén ejude su aniji cuana ja sacerdote cuana, mecuana sa etsahuaji cuana neje beitutana Juan Bautista peje su. Putitana huecuana Juan peje su, aidhe tueda, equisaba puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Da su Juan ja uja jeutsutana huecuana: —Aimue ema Diusu sa Jabeituti Deja mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Beju neicha quisabatana huecuana Juan: —¿Aidhe da mida? ¿A da mida Diusu sa profeta Elías chenu id'eyujiji? Juan ja jeutsutana huecuana uja: —Aimue ema Elías chenu mahue. Da su neicha quisabatana huecuana: —¿A da mida tueda Diusu sa profeta epusiu ecuanaju eid'uainia? Juan ja jeutsutana huecuana: —Mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Neicha Juan quisabatana huecuana: —Da su, ¿aidhe da mida? Beju quisaque ecuanaju, ecuanaju beituji cuana ecuanaju sa quisa taji putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Da su Juan ja uja jeutsutana huecuana: —Ema da deja quisaquisa epuani d'anita yahua su. Cuaja Diusu sa profeta Isaías chenu quisa puidha batame, daja jubida yama cristiano cuana equisainia: “Mebasetatique Echua Puji ecuina su puji.” ");
INSERT INTO tnaNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Da su fariseo sa jabeituti cuana ja neicha Juan quisabatana: —Da su, ¿ai puji ni miada cristiano cuana eichaderainia Diusu sa puji yahui neje, mida Diusu sa Jabeituti Deja, Elías chenu, Diusu sa profeta mahue biame? ");
INSERT INTO tnaNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Da su Juan ja jeutsutana huecuana: —Yama cristiano cuana eichaderainia Diusu sa puji yahui neje. Beju piada deja mu micuana duju su yani. Mue micuaneda shanapa tsuhu tueda. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tueda ema tije epusiu biame, ema ebia su aida epuani. Aimue ema tupu mahue tu emebaja puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Beju daja Juan, fariseo cuana sa jabeituti cuana neje mimiana Betábara banime ejude naja su, Jordán ena chu maje. Tueda ena su Juan ja cristiano cuana Diusu sa puji ichaderatasaina yahui neje. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Pia huenati Jesús Juan peje su putiana. Juan ja Jesús ba putsu, uja cristiano cuana atana: —Mechamaque. Tueda deja da Diusu peje su eirutsua puji Huisha Janana nime. Tueda emanu cristiano cuana sa jucha cuana edhipa puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Uja yama equene micuana quisana tu jepuiti: “Ema tije piada deja epusiu. Ema tije epusiu biame, tueda da ema ebia su aida, ema bataji puji mahue su, tueda anidha putsu.” ");
INSERT INTO tnaNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yama quitaita aimue tueda shanapaina mahue. Beju jiahue yama Diusu sa puji eichaderainia israelita cuana yahui neje tueda da Diusu sa Jabeituti Deja tuna eshanapame puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Juan ja daja hue cristiano cuana quisainiame atana: —Aimue yama tueda shanapaina mahue. Su pad'i beju Espíritu Santo cielo jenetia ebuteni huaitucu nime yama bana. Jesús bia su netiuteana. Equene Diusu ja ema uja atana: “Quebata deja bia su Espíritu Santo, bute putsu, yaniti su, tueda da quema Jabeituti Deja. Tuahueda cristiano cuana quema puji eichaderata Espíritu Santo sa tucheda neje.” ");
INSERT INTO tnaNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Beju tueda yama bana. Yama micuana butsepi equisainia, tueda deja da Diusu sa Ebacua. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Pia huenati neicha Juan dapia aniana. Beta tu buqueji detse di tu neje aniana. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Juan ja Jesús ejaitianasa ba putsu, ebuqueji detse uja atana: —Mechamaque tueda deja. Tueda da Tata Diusu peje su eirutsua puji Huisha Janana nime. Tueda emanu cristiano cuana sa jucha cuana edhipa puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Juan sa ebuqueji detse ja daja id'aba putsu, Jesús tije apirutana tse. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesús jababarereati putsu, tuatseda tu tije epuhu batana. Da su uja atana tse: —¿Ai metse echacuinia? Da su jeutsutana tse uja: —Ebuetsuaji, ¿quepia mique ete? ");
INSERT INTO tnaNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesús ja jeutsutana tse: —Mepueque eba puji. Da su beju tu neje putiana tse quepia tu yani su. Beju tsinecua epuani putsu, Jesús buquetana tse yapuna teje. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tuatseda piada banime puina Andrés. Tueda da Simón Pedro sa edue puina. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Da su beju Andrés tipeida putiana mesa edue Pedro echacu puji. Tu tsu putsu, uja quisatana Pedro: —Beju etseju Diusu sa Jabeituti Deja Cristo tejeitia. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Da su Andrés ja Simón dusutana Jesús yani su. Jesús ja Simón ba putsu, uja atana: —Mida Simón banime. Mida da Jonás sa ebacua. Jiahue jenetia beju mida Pedro banime epu. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Pia huenati Jesús putija puana Galilea yahua su. Da hora su Jesús ja Felipe tsutana. Tsu putsu, uja atana: —Tije ema aque. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe da Andrés, Pedro detse sa ejude jenetia puina. Tueda ejude Betsaida banime puina. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Da su beju Felipe ja Natanael chacutitana. Tejeti putsu, uja quisatana Natanael: —Baitia da ecuanaju piada deja Jesús banime. Tueda da José sa ebacua Nazaret ejude jenetia. Moisés chenu ja tu jepuiti deretaidha mesa jacuatsasiati quirica su. Diusu sa profeta chenu cuana ja di tu jepuiti deretaidha. Tueda da Diusu sa Jabeituti Deja. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Da su Natanael ja atana: —¿Ai saida cuana Nazaret ejude jenetia cuinana cua bata? Felipe ja jeutsutana uja: —Pueque eba puji. Da su putiana tse Jesús eba puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Beju Jesús ja Natanael enariatisiu ba putsu, uja atana: —Hue upia epusiu deja israelita quitaita. Tueda da deja butsepi, jabaseati bue mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Da su Natanael ja uja Jesús quisabatana: —¿Cuaja ni miada ema eshanapainia? Jesús ja tueda jeutsutana: —Felipe ja mi ihuaji mahue su, yama mi baitia higuera equi ema su eneti mane, ema dapia mue neti biame. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Da su Natanael ja Jesús uja atana: —Ebuetsuaji, ene putsu, mida da Diusu sa Ebacua. Mida da israelita cuana sa Echua Puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Da su Jesús ja tueda uja atana: —Beju mida ema peje su jei epuani, “Yama mi higuera equi ema su eneti baitia”, yama mi aitia putsu. Beju yama ebia su aida nimetiuda ai cuana yayu miada eba. ");
INSERT INTO tnaNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","‘Ene putsu, yama pamapa micuana butsepi equisainia, cielo ed'ianeti jenetia Diusu sa ángel cuana butenuati, tsuanuati ema emebaja puji micuaneda eba. ");
INSERT INTO tnaNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Quimisha tsine beju jaitianana su, Caná ejude su jahuaneti tsine puana. Tueda Caná ejude da Galilea yahua su anina. Jesús sa cuara dapia tsine su anina. ");
INSERT INTO tnaNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesús di mesa discípulo cuana neje dapia anina. ");
INSERT INTO tnaNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Beju vino pupeana su, Jesús sa cuara ja tueda atana uja: —Beju pupeitia vino. ");
INSERT INTO tnaNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Da su Jesús ja mesa cuara uja jeutsutana: —Mama, be ema cuatsasiaji, quema hora cuinaji mahue putsu. Beju quema hora ecuina su, da su yama nimetiuda aida yayu. ");
INSERT INTO tnaNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Da su mesa cuara ja emebajaji cuana uja atana: —Cuaja tuahueda micuana ecuatsasiatani, meaque. ");
INSERT INTO tnaNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Beju sucuta matu memahue cuana tumu jenetia ajiji netitaina. Tueda matu cuana dume su judío cuana yahui ichaseta bahue putaina mecuana sa jarucuati cuana puji, cuaja mecuana sa ai puiti cuana batame. Matu meamea ocho tunca ahua cien litro enubiani. ");
INSERT INTO tnaNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Da su beju Jesús ja emebajaji cuana uja cuatsasiatana: —Mesejeaque pamapa ye matu cuana yahui neje. Da su emebajaji cuana ja matu cuana sejeasaisiatana. ");
INSERT INTO tnaNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Beju sejeasaisiatana huecuana putsu, Jesús ja uja atana huecuana: —Huai chidi metsehuaque. Medusuque tsine emetse peje su. Da su beju daja atana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Yahui vino puji japiatiana. Tsine emetse ja id'ibatana vino. Bue mahue puina que jenetia tueda vino. Emebajaji cuana bahui bahue putaina, matu cuana yahui neje sejeasaisiatana huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Da su tsine emetse ja jahuanetaitia deja ihua putsu, uja atana: —Pamapa cristiano cuana ja tsine cuana su vino saida equene eid'imetani. Ihuajiji cuana beju vino saida quita ebia su jaid'ititana su, tije vino saida mahue eid'imetani beju. Miada mu vino ebia su saida ichasetaitia tije su puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Tueda nimetiuda aida Jesús ja atana Galilea yahua, Caná ejude su. Da neje Jesús ja mesa tucheda cristiano cuana equene bametana. Da hora jenetia mesa discípulo cuana tu peje su jei pupirutana. ");
INSERT INTO tnaNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Da su beju Jesús putiana Capernaum ejude su. Mesa cuara, edue, discípulo cuana ja buquetana. Dapia Capernaum ejude su quejucua tsine puji anititana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Da su beju Jesús Jerusalén ejude su putiana, judío cuana sa pascua tsine enariatiani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Dapia templo su juye, huisha, huaitucu cuana deja cuana ja eirutasa Jesús ja batana. Daja huecha cristiano cuana sa puji chipilu eturucatani batana. ");
INSERT INTO tnaNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tueda ai cuana ba putsu, Jesús duininiana. Huacabiti a putsu, da neje templo jenetia jusiacuinatana huecuana pamapa. Iruiruji deja cuana, huisha, juye cuana, pamapa beju jusiacuinatana. Chipilu turucaji cuana sa chipilu yahua su huararajusiatana, mecuana sa misha cuana busiapa putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Huaitucu iruji cuana Jesús ja uja atana: —¡Mejemicuinaque pamapa ye ai cuana! ¡Quema Tata sa ete da aimue iruiru jude mahue! ");
INSERT INTO tnaNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Mesa discípulo cuana ja ye ai cuana ba putsu, pibatana huecuana uja Diusu sa mimi epuani: “Diusu, mique ete yama ebia su erejainia.” ");
INSERT INTO tnaNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Da su judío cuana ja Jesús quisabatana: —¿Aiya mi huaratiatana ye ai cuana daja ya puji? ");
INSERT INTO tnaNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús ja jeutsutana huecuana: —Ahua micuaneda ye templo edajajame su, quimisha tsine jenetia yama neicha enetianameyu. ");
INSERT INTO tnaNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Da su judío cuana ja uja atana: —¿Ai miada ye templo quimisha tsine jenetia ape cua bata? Pushi tunca sucuta ejaitiana mara jenetia ecuanaju ye templo mudupeana. ");
INSERT INTO tnaNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Beju Jesús daja mimiana mesa equita jepuiti. Aimue judío cuana sa templo jepuiti mimiana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jesús id'eibana su, da su discípulo cuana japibatitana Jesús sa templo jepuiti mimi cuana su. Tueda mimi cuana su jei putana huecuana. Daja huecha Diusu sa derejiji mimi su jei putana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Beju Jesús Jerusalén ejude su tsine eba puji yani cama, jucuada ai nimetiuda cuana atana. Dueji cristiano cuana tu peje su jei putana, nimetiuda ai cuana batana huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Daja biame, aimue Jesús sa cristiano cuana ainietuche biame puana mahue, tuna sa muesumu madhada hue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Aimue detse aiya biame tueda quisata cua mahue cuaja cristiano cuana, tuahueda shanapasaisiasaisiatana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Dapia piada fariseo anina. Tueda da Nicodemo banime. Judío cuana sa ehuidusuji puina. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jesús peje su dhidha su putiana. Cuinati putsu, uja atana Jesús: —Ebuetsuaji, bahue ecuanaju mida Diusu peje jenetia pueana ecuanaju ebuetsua puji. Bahue ecuanaju Diusu mi neje yani, miada nimetiuda aida cuana yainia putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Da su Jesús ja tueda uja atana: —Ene putsu, yama mi butsepi equisainia, ahua etse cielo su Diusu neje anienitija su, neicha eichacua bataji epuani nime etse sa pu taji. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Da su Nicodemo ja Jesús quisabatana: —¿Cuaja ni da deja neicha bataji pu cua? ¿Ai deja mesa cuara sa edhe su nubiti putsu, neicha bataji pu cua bata? ");
INSERT INTO tnaNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús ja Nicodemo jeutsutana: —Ene putsu, yama mi butsepi equisainia, ahua etse cielo su Diusu neje anienitija su, equene nimeeichacua pu taji, quema quisa cuana su jei pu putsu. Espíritu Santo di mesa ani taji. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Quebata tata, cuara peje jenetia bataji epuani su, tueda da tuatse sa ebacua. Quebata mu Espíritu Santo ja nimeeichacua yametani su, tueda da Diusu sa ebacua. Tu neje cielo su yanienitiyu. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Be nimetiuji, daja mi yama equisainia putsu. Pamapa sa neicha eichacua bataji epuani nime pu taji, ahua cielo su nubija su. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Beni epuani que jenetia papu. Etse eid'abainia etsatiani bahui. Beju da aimue bataji mahue. Bue mahue etse que jenetia epueni, daja huecha quepia epuhu. Daja nime da Espíritu Santo. Aimue etse tueda ebainia mahue biame, Espíritu Santo ja cristiano cuana neicha nimeeichacua bataji yametani. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Da su Nicodemo ja Jesús quisabatana: —¿Cuaja ni da ye ai cuana pu cua? ");
INSERT INTO tnaNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús ja tueda jeutsutana: —¿Cuaja ni mida ye ai cuana bue mahue, israelita cuana sa ebuetsuaji aida biame? ");
INSERT INTO tnaNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ene putsu, ema bahue ai cuana, yama bana ai cuana di yama mi equisainia biame, aimue mida quema quisa cuana su jei epuani mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Yama mi ye mundo sa ai cuana equisainia biame, aimue mida ema peje su jei epuani mahue. Da su, ¿cuaja detse mi ema peje su jei pume pu cua, ahua cielo jenetia ai cuana yama mi equisa su? ");
INSERT INTO tnaNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","‘Aimue aidhe biame cielo su tsuatiana mahue, jasiapati putsu, cuaja yani cristiano cuana equisa puji. Beju ema da Diusu sa Jabeituti Deja. Ema mu cielo jenetia pueana cristiano cuana cuaja yani equisa puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Biahua tiempo Moisés chenu ja bacua eimea jemitsuataidha d'anita yahua su, cristiano cuana ja bacua chama putsu, pasaisitayu huecuana puji, ahua bacua ja ediatani huecuana su. Bacua ja ediatani cuana saisitaidha, bacua eimea chama putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Daja huecha ema ejemitsuatayu huecuana. Quebata ema peje su jei epu su, tueda cielo su eid'e epuenitiyu. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","‘Tata Diusu ja pamapa cristiano cuana ebia su ibuneda batana putsu, mesa piada quita ebacua ye mundo su beitutana mecuana sa jucha cuana jepuiti emanu puji. Quebata tu peje su jei epuani su, aimue matsejiji epu mahue. Tueda da d'eji su pu putsu, cielo su Diusu neje eid'e yanienitiyu. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Aimue Diusu ja mesa Ebacua beitu ye mundo su cristiano cuana ematse puji mahue. Tueda beitutana cristiano cuana d'eji su paputa puji, tu peje su jei pu putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","‘Quebata Diusu sa Ebacua peje su jei epu su, aimue tueda Diusu ja ematsetayu mahue. Quebata mu Diusu sa Ebacua peje su jei puja mahue su, tueda da beju matsejiji epu, aimue Diusu sa piada quita Ebacua peje su jei puana mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Diusu sa Ebacua da hueda nime mundo su pueana cielo jenetia. Pamapa tu peje su jei eputani mahue cuana da matsejiji epu, aimue ai saida cuana aja mahue atana huecuana putsu. Ai madhada cuana bahui mecuana sa tsada ya puji. Tuneda da apuda su yasetaniuneti cuana nime. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Pamapa ai madhada yatani cuana sa tsada mahue Diusu sa jabuetsuati cuana. Tuneseda tsada mahue pia ja, “Micuaneda mu jucha bahui yainia”, ataja mahue. Beju tuneda da apuda su ai madhada aji cuana nime. Tsada mahue mecuana sa cristiano cuana ja ebata tuna apuda su ai madhada yatani cuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Beju ai saida yatani cuana mu Diusu sa ai tsada cuana bahui yatani, cristiano cuana ja tuneda ai saida cuana yatani pabata huecuana puji. Tuneda da hueda su ai saida aji cuana nime. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Da su beju Jesús Jerusalén ejude jenetia cuinanana. Mesa discípulo cuana neje putiana Judea yahua su. Dapia quejucua tsine anitiana huecuana. Cristiano cuana Diusu sa puji yahui neje ichaderatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan Bautista ja di cristiano cuana yahui neje Diusu sa puji ichaderatana Enón banime eti jude su, dapia ena aida saina putsu. Tueda Enón eti jude da Salim banime ejude naja su anina. Da su cristiano cuana dapia putitana Juan ja yahui neje Diusu sa puji paichaderata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tueda ai cuana da daja puana, Juan Bautista teriichaji mahue su. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Beju pia judío cuana Juan sa ebuqueji cuana neje jacuicuinapirutitana jarucuati ai cuana jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Da su ebuqueji cuana ja uja quisatana Juan: —Ebuetsuaji, tueda deja mi neje Jordan ena chu maje aniana ja jiahue cristiano cuana eichaderatani yahui neje. Pamapa ja tueda tije yatani beju. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Da su Juan ja jeutsutana huecuana uja: —Diusu ja pamapa saida yatani. Tuahueda bahui ecuana eichatani cuaja mesa tsada. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mepibaque yama micuana quisana ai cuana. Aimue ema Cristo mahue. Tu hui su ema Diusu ja beitutana. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Jahuaneti tsine su yahueti epuna da yahue sa puji bahui. Aimue mesa eshanapa sa puji mahue. Yahue sa eshanapa dapia tu neje beidaji yani. Cuaja eshanapa yahue neje beidaji epuani nime, daja da ya di ebia su beidaji, cristiano cuana ja Cristo tije yatani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Tueda da ebia su aida papu beju. Ema mu mue ai eni mahue papu. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jesucristo da cielo jenetia pueana putsu, pamapa cristiano cuana ebia su aida. Cristiano cuana ja ye mundo sa ai cuana jepuiti bahui emimitani. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Beju tuahueda mu cielo su batana, id'abatana ai cuana cristiano cuana equisatani, tueda da jenetia putsu. Beju daja biame, mue aidhe biame tu peje su jei pu. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","34","Tuahueda Diusu sa ene quita mimi cuana equisatani, Diusu ja tueda beitutana putsu. Da su quebata tusa mimi cuana su jei epuani su, tuahueda Diusu butsepi ebametani. Diusu sa Jabeituti Deja ja Diusu sa ene quita quisa cuana equisatani, Diusu ja mesa Espíritu Santo tucheda tueda tiatana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tata Diusu ja mesa Ebacua ebia su ibuneda ebatani putsu, pamapa ai cuana tu ema su ichatana. ");
INSERT INTO tnaNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Quebata Diusu sa Ebacua peje su jei epu su, tueda cielo su eid'e epueniti Diusu neje. Quebata tu peje su jei puja mahue epu su, aimue cielo su eid'e epuenitiyu mahue. Diusu ja tueda cuati castigo jude su ebeitutayu, tu neje ebia su eduininiani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Fariseo cuana ja beju id'abatana Jesús sa ebuqueji cuana da Juan Bautista sa ebia su dueji. Aimue Jesús quitaita ja cristiano cuana Diusu sa puji ichaderatana mahue. Mesa discípulo cuana ja bahui cristiano cuana Diusu sa puji ichaderatana yahui neje. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Da su Jesús ja fariseo cuana ja id'abatana shanapa putsu, Judea yahua jenetia cuinanana Galilea yahua su eputi puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Samaria yahua je mesa jaitiana taji puina Galilea yahua su ecuinati puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Beju Sicar banime ejude su Samaria yahua su cuinatiana. Biahua tiempo Jacob chenu ja yahua ped'u mesa ebacua José chenu tiataidha Sicar ejude naja su. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Dapia yahua ped'u su yahui rara dueda anina. Tueda Jacob sa yahui rara banime puina. Jesús da jaduitijiji cuinana putsu, yahui rara queque su aniuteana. Beju buepatia yeuque puina. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Mesa discípulo cuana ejude su putitana ai dia taji cuana ebajati puji. Beju putitana su, piada epuna yahui rara su pueana yahui ejemitsua puji. Da su Jesús ja tueda uja atana: —Tiaque ema yahui. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Da su beju epuna ja Jesús quisabatana: —Mida da judío biame, miada ema yahui ebajainia. ¿Cuaja ni da miada ema emitsuinia, ema da samaritana biame? (Judío cuana sa mu aimue ai biame a taji samaritano cuana neje.) ");
INSERT INTO tnaNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Da su Jesús ja jeutsutana: —Epuna, ahua mida Diusu sa ai saida yani miqueda puji bahue pu cua su, ahua miada aidhe neje mi emitsutiani shanapa cua su, da su miada ema baja cua. Miada ema baja cua su, yama mi eid'e jaametiji yahui etia. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Da su epuna ja Jesús uja atana: —Deja, aimue mique emeji. Ye yahui rara mu dueda. ¿Que jenetia detse miada ema tia cua yahui ema eid'e epu puji? ");
INSERT INTO tnaNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Beju ecuana sa tata Jacob chenu ja ye yahui rara ichajusiataidha ecuana sa puji. Ye yahui rara jenetia tueda id'itaidha. Tusa ebacua cuana ja di u jenetia id'itaidha. Tusa animalo cuana ja di id'itaidha. ¿Ai mida tu ebia su aida bata? ");
INSERT INTO tnaNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Da su Jesús ja jeutsutana uja: —Pamapa ja ye yahui eid'ita biame, neicha jaid'itija huecuana epu. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Quebata ja mu yama etia yahui eid'ita su, tueda da aimue jaid'itija epuicha mahue. Tueda yama etia yahui da tusa enime su ena putiputi nime epu. Tueda yama etia yahui da eid'e jaametiji. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Da su beju epuna ja Jesús uja bajatana: —Deja, tiaque ema tueda yahui ema jaid'itija epuicha mahue puji, aimue ye yahui rara su yahui ejemitsua puji epueicha mahue puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Da su Jesús ja atana uja: —Ihuatique mique yahue. Duseque upia. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Epuna ja jeutsutana: —Ahue mahue ema. Da su Jesús ja uja atana epuna: —Enei hue mi emimiani. Aimue mique yahue yani mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Beju pishica mique yahue cuana anina. Jiahue mi edusu deja mu aimue mique yahue mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Epuna ja ye mimi id'aba putsu, Jesús uja atana: —Da su mida jia da Diusu sa profeta. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ecuanaju sa tata samaritano chenu cuana ja upia ye emata su Diusu mitsutsuataidha. Beju judío cuana mu, “Jerusalén ejude su bahui cristiano cuana ja Diusu mitsutsua taji”, eputani. Da su, ¿quepia ni da ecuanaju sa mitsutsua taji Diusu? ");
INSERT INTO tnaNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Da su Jesús ja jeutsutana: —Epuna, jei puque quema mimi su. Tiempo beju ecuina micuaneda aimue ye emata su, Jerusalén ejude su biame eputi mahue Diusu emitsutsua puji. Quepia papu etse yani su Diusu mitsutsua taji. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Micuaneda samaritano cuana ja mue Diusu shanapa. Ecuanaju judío cuana ja mu beju Diusu eshanapaeninia. Diusu ja piada judío deja dharetana cristiano cuana d'eji su paata puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Beju jiahue jenetia da Diusu mitsutsuaji cuana ja mecuana sa muesumu su bahui Diusu emitsutsuata. Daja da Diusu sa tsada. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Diusu da Espíritu. Da su tu mitsutsuaja cuana ene quita mecuana sa muesumu su mitsutsua taji. Cuaja tusa mimi epuani batame, mitsutsua taji. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Da su epuna ja Jesús atana: —Beju bahue ema Diusu sa Jabeituti Deja epue cristiano cuana d'eji su ya puji. Tueda da Cristo banime. Beju tu epue su, ecuanaju pamapa saida equisaenita. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Da su Jesús ja epuna uja atana: —Tueda da ema. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Da hora su beju discípulo cuana cuinatana. Nimetiunetitana huecuana, Jesús epuna neje quisaquisa epuneti ba putsu. Mue quebata biame tuneda quisa baja a, ai epuna sa tsada puana, ai jepuiti quisquisa punetina tse. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Da su epuna ja yahui matu jusianetia putsu, ejude su putibana. Dapia cristiano cuana quisapirutana uja: ");
INSERT INTO tnaNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Meputija piada deja eba puji. Tuahueda pamapa yama ana ai madhada cuana ema butsepi quisataitia. ¿Aimue jia maida tueda Diusu sa Jabeituti Deja mahue? ");
INSERT INTO tnaNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Da su pamapa ejude su aniji cristiano cuana Jesús yani su putitana. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Cristiano cuana tu peje su cuinaji mahue su, discípulo cuana ja Jesús uja atana: —Ebuetsuaji, diadiaque. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Beju Jesús ja jeutsutana huecuana: —Quema mu yani jana ebia su saida mue micuaneda shanapa. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Da su discípulo cama jaquisabatitana uja: —¿Aiya jia da beju mihuataitia? ");
INSERT INTO tnaNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesús ja mecuana sa jaquisabati cuana shanapa putsu, uja atana huecuana: —Diusu sa tsada mudu cuana yape bahui quema puji jana pu cua nime. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Micuaneda mimi bahue uja: “Pushi badi yani hue tsuhu ehuiruhuiru puji.” Beju yama mu micuana yainia, jiahue da huiruhuiru tiempo. Daja huecha micuaneda, “Aimue cristiano cuana Jesús peje su jei eputa mahue tsuhu”, epuani biame, yama mu micuana equisainia, jiahue quita ema peje su jei eputayu huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Quebata ehuiruhuiruta cuana chujetiajiji eputa. Daja huecha banabanaji cuana chujetiajiji eputa. Beju beidaji eputa huecuana echuje neje. Daja huecha ema jepuiti quisaquisa eputani cuana, cristiano cuana ema peje su jei yametani cuana neje tupupai beidaji eputa, cristiano cuana d'eji su eputa ebata huecuana su. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","38","Micuana equene pia cuana da cristiano cuana ema jepuiti quisquisa pupirutana. Tuneda da banabanaji cuana nime. Jiahue yama micuana ebeitu cristiano cuana peje su ema peje su jei yame huecuana puji. Micuaneda da huiruhuiruji cuana nime. Ene quita ecuana sa mimi nime uja epuani: “Piada piada cuana ja ebanatani. Pia cuana ja ehuirutani.” ");
INSERT INTO tnaNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Da su beju dueji ejude su aniji cristiano cuana Jesús peje su jei putana, epuna ja daja quisatana huecuana su. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Cristiano cuana Jesús yani su cuinatana su, uja jubida bajatana huecuana: —Upia ecuanaju neje anitique. Da su Jesús beta tsine anitiana tuna neje. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ebia su jucuada cristiano cuana tu peje su jei putana, tusa quisa cuana id'aba putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Da su tuneda epuna uja atana: —Beju jiahue ecuanaju Jesús peje su jei epuani, tusa quisa cuana quitaita id'aba putsu. Aimue mique quisa su bahui mahue ecuanaju jei epuani. Beju da ecuanaju bahue, ene quita da tueda Diusu sa Jabeituti Deja. Tueda da ye mundo su aniji cuana D'eji su Aji. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","44","Beta tsine jaitianana su, Jesús Samaria yahua jenetia cuinanana Galilea yahua su eputi puji, dapia bataji puana putsu. Beju Jesús uja puana, “Diusu sa profeta aimue saida ebatani huecuana mahue tusa ejude quitaita su.” ");
INSERT INTO tnaNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jesús Galilea yahua su cuinati putsu, dapia cristiano cuana ja tueda saida batsutana, tuahueda Jerusalén ejude su pascua tsine su nimetiuda aida cuana yatani batana huecuana putsu. Da putsu, Jesús saida batsutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","47","Da su beju Jesús Caná ejude su jasiapatiana. Tueda ejude da Galilea yahua su anina. Tueda ejude su Jesús ja yahui vino su tsapiatana. Piada deja huaraji aida Capernaum ejude jenetia Caná ejude su putiana, Jesús dapia yani shanapa putsu. Mesa ebacua nedaji emanu piba Capernaum ejude su saina. Tu peje su cuinati putsu, Jesús uja bajatana: —Putique quema ete su quema ebacua emanu piba esa esaisiame puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Da su Jesús ja uja atana: —Yama nimetiuda aida cuana yainia jepuiti bahui micuaneda ema peje su jei epuani. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Beju deja huaraji ja Jesús neicha jubida bajatana: —Echua Puji, tipeique. Beju quema ebacua emanu. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Da su Jesús ja atana: —Jasiapatique mique ete su. Beju mique ebacua saida. Da su beju deja jasiapatibana mesa ete su, Jesús peje su jei pu putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Beju mesa ete su ecuinabuyu su, mesa emebajaji cuana ete jenetia cuinanatana tu emitsu puji. Uja deja quisatana huecuana: —Beju mique ebacua mu saida. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Da su deja ja quisabatana huecuana: —¿Ai hora su ni da quema ebacua saisipiruja puicha? Da su jeutsutana huecuana: —Mueta buepatia badeute chidi saisipiruja puicha. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Da su deja japibatiana uja: “Enei hue, da hora su Jesús ja, ‘Beju mique ebacua saida’, ema ata puicha.” Da su beju deja Jesús peje su jei puana pamapa mesa familia neje. ");
INSERT INTO tnaNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Beju tueda da Jesús sa beta puji nimetiuda aida, Galilea yahua su cuinati putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Da su Jesús Jerusalén ejude su jasiapatiana judío cuana sa tsine eba puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ejude tipe je pirica aida, baqui bauda tumu jenetia ajiji anina. Pirica sa eteriji cuana anitana. Piada banime Huisha Eteriji. Tueda eteriji naja su rara aida yahui eseje anina. Tueda yahui rara banime Betesda. Equeque je beju pishica ania chidi tambo cuana anitaina. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Dapia dueji nedaji cuana sataina yahui ecuamucuamu eid'ua puji. Padha, tida, ase bue mahue cuana beju dapia sataina. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Uja mecuana sa piba puina: “Piada piada hora cuana su Diusu sa ángel bute putsu, yahui rara ehuarusiapa bahue. Da su yahui ehuarusiapatani su, nedaji cuana sa yahui su tipeida nubi taji. Piada nedaji bahui equene yahui su enubiani su, tueda beju saisi cua.” Daja mecuana sa piba puina. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Beju dapia piada deja ase bue mahue saina. Quimisha tunca ocho ejaitiana maraji beju nedaji. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesús ja tueda deja esa batana putsu, shanapatana dajucua mara nedaji saina. Da su Jesús ja deja quisabatana uja: —¿A da mida saisija? ");
INSERT INTO tnaNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nedaji ja tueda jeutsutana: —Ehe, tata. Beju mue da quema aidhe biame ema yahui su enubiameta puji, ángel ja yahui ehuarusiapatani su. Pamapa nuati ema nubija epudhaani. Beju pia nedaji ema equene enubiani. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Da su Jesús ja uja cuatsasiatana deja: —Netianaque. Jemitsuaque mique masha. Beju aseque. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Da hora quitaita su hue beju saisiana. Masha jemitsua putsu, asepiruana. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Beju dapia judío cuana sa ehuidusuji cuana deja saisijiji neje duininitana, masha jemitsuatana janahua tsine su putsu. Uja deja atana huecuana: —Jiahue mu janahua tsine putsu, aimue mique masha abu taji mahue. Aimue mique mudumudu taji mahue janahua tsine su, daja jacuatsasiati yani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Da su deja ja jeutsutana huecuana: —Beju ema saisiameji deja ja uja ema cuatsasiataitia: “Jemitsuaque mique masha. Beju aseque.” ");
INSERT INTO tnaNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Da su quisabatana huecuana: —¿Aiya mida daja cuatsasiataitia? ");
INSERT INTO tnaNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Beju deja ja tu cuatsasiaji cuaja bame taji mahue batana, Jesús da hora su taitanana dueji cristiano cuana duju su putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pia tsine deja saisijiji Jesús ja tsutana templo su. Uja atana deja: —Jiahue mi beju saida. Be neicha jucha puji. Daja mahue su, ebia su mida epu. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Da su beju deja saisijiji judío cuana sa ehuidusuji cuana peje su putiana tuna equisati puji. Uja quisatana huecuana: —Tueda ema saisiameji deja da Jesús banime. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Da su beju da hora jenetia judío cuana sa ehuidusuji cuana Jesús manuameja apirutana, Jesús ja janahua tsine su cristiano cuana saisiametana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Da su Jesús ja judío cuana sa ehuidusuji cuana uja atana: —Beju jiahue teje quema Tata Diusu ja tusa ai tsada cuana bahui yatani. Yama di daja huecha yainia, etseju tupupai yani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Da putsu beju, judío cuana sa ehuidusuji cuana ja ebia su manuameja atana Jesús, tueda Tata Diusu neje tupupai puana putsu, Diusu da tusa tata quitaita puana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Da su Jesús ja judío cuana sa ehuidusuji cuana uja atana: —Ema da Diusu sa Ebacua biame, aimue quema tsada cuana bahui yainia mahue. Quema Tata Diusu ja yatani ai cuana yama ebainia bahui yainia. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Quema Tata ja ema ebia su ibuneda ebatani putsu, pamapa tuahueda ai yatani cuana ema ebametani. Tuahueda ema ebia su aida ai nimetiuda cuana ebameta yama ya puji, micuaneda enimetiu puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Cuaja quema Tata ja manujiji cuana eid'e yametani nime, daja huecha yama di quebata quema tsada cuana eid'e yame. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Quema Tata ja aimue cristiano cuana ejuzgata mahue. Ema mu huaratiatana cristiano cuana ejuzga puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Da putsu, cristiano cuana ja quema Tata eiyubatani nime, daja huecha ema eiyubata huecuana. Quebata ja aimue ema eiyubatani mahue, aimue quema Tata di eiyubatani mahue, tuahueda ema beitutana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","‘Ene putsu, yama micuana equisainia, quebata ja quema mimi cuana eid'abata, ema beituji peje su di jei epu su, tueda da d'eji su epu. Cielo su eid'e yanienitiyu. Aimue Diusu ja tueda ematsetayu mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ene putsu, yama micuana equisainia, beju hora cuinaitia cristiano cuana ja quema quisa cuana paid'abata puji. Quebata quema quisa cuana su jei epu su, tueda eid'e epueni. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Quema Tata ja cristiano cuana eid'e ameenita cua. Yama di cristiano cuana eid'e ameeni cua, quema Tata Diusu da puji ema huaratiatana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Daja huecha ema huaratiatana cristiano cuana ejuzga puji, ema da Diusu sa Jabeituti Deja putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Be menimetiuji, yama daja yainia su. Beju hora ecuina pamapa manujiji cuana ja quema etsui eid'abata puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Pamapa manujiji cuana sepulcro cuana jenetia enetianatayu. Pamapa ai saida atana cuana da Diusu neje cielo su eid'e epuenitayu. Pamapa ai madhada atana cuana mu Diusu ja ematsetayu. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","‘Aimue yama quema piba jenetia yainia mahue. Cuaja quema Tata ja ema equisatani, daja yama cristiano cuana equisainia. Yama yainia ai cuana da butsepi, Diusu sa tsada bahui yama yainia putsu. Da putsu, yama cristiano cuana butsepi ejuzgainia. Diusu ja ema ye mundo su beitutana. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Aimue yama quema puji bahui equisanetiacuinainia mahue. Ahua daja yama a cua su, aimue chujeji mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Beju pia yani ema quisanetiacuinaji. Tueda jei a taji, ema jepuiti ene quita, butsepi emimiani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Jesús ja daja hue quisainiame atana ehuidusuji cuana: —Beju micuaneda Juan Bautista quisabameana. Tuahueda butsepi micuana jeutsutana. Quema puji saida quisanetiacuinatana. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Juan sa quisa ema jepuiti beju butsepi biame, quema mu tsada mahue quebata deja ja ema equisanetiacuinata puji. Daja biame, ahua micuaneda Juan sa ema jepuiti quisa su jei epu su, beju d'eji su epu. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan sa quisa cuana da hueda nime micuaneseda puji. Ahua etse sa hueda yani su, da su apuda su etse saida ase cua. Daja huecha Juan ja micuana cuaja Diusu peje su janariatime pu cua quisatana. Ubu hora hue micuaneda beidaji neje id'abana. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Beju jiahue ema upia yani Juan ebia su aida. Tata Diusu quitaita ja ema huaratiatana ye ai nimetiuda aida cuana ya puji. Micuaneda bahue Tata Diusu ja ema beitutana, yama ai nimetiuda aida cuana yainia ba putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tata Diusu quitaita ja ema equisanetiacuinatani. Tuahueda quitaita ema beitutana. Micuaneda quetsunu su biame tueda id'aba bue mahue, quetsunu su biame tueda ba bue mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Aimue micuaneda Diusu peje su jei epuani mahue, quema quisa cuana su jei puja mahue putsu. Beju tuahueda quitaita ema beitutana. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Micuaneda Diusu sa quirica yanacane jubida emimiameinia. Tueda quirica su micuaneda cuaja eid'e epueni echacuinia. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Beju tueda quirica ja ema equisanetiacuinatani biame, aimue micuaneda ema peje su jei puja mahue epuani eid'e epueni puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","‘Quema mu tsada mahue cristiano cuana ja ema aida pabata. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Yama eshanapaeninia aimue micuaneda Diusu ibuneda ebainia mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ema Tata Diusu ja beitutana biame, beju micuaneda aimue ema batsuja yainia mahue. Ahua pia micuana peje su epue, Diusu ja beitujiji mahue biame, micuaneda saida ebatsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Micuaneda cama bahui huamahuama saida jabatija. Ahua Diusu ja micuana saida ebata, ahua mahue, beju micuaneseda puji mu mue ai biame piba. ¿Cuaja detse micuaneda ema peje su jei pume pu cua, daja a putsu? ");
INSERT INTO tnaNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Beju aimue quema puji micuana tuaquisa taji mahue quema Tata Diusu butse su. Moisés chenu quitaita ja micuana etuaquisata Diusu butse su, micuaneda tusa jacuatsasiati cuana su enimeid'uadhaatiani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ahua micuaneda Moisés sa jadereti cuana su jei puana su, ema peje su di micuaneda jei pu cua, tuahueda ema jepuiti deretaidha putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ahua aimue micuaneda Moisés chenu sa jadereti cuana su jei epuani mahue su, ¿cuaja ni da micuaneda yama equisainia ai cuana su jei pume pu cua? Daja Jesús ja judío cuana sa ehuidusuji cuana quisatana. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Da su beju pia tsine Jesús Galilea bai chu maje anipetutiana. Tueda huecha Tiberias banime puina. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Dueji cristiano cuana ja tije atana, Jesús ja piapiati nedaji cuana saisiametana batana huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Da su Jesús mesa discípulo cuana neje murucu aida su tsuatiana tuna neje yaninuati puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Judío cuana sa pascua tsine beju hue quita puina. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesús ja dueji cristiano cuana tu yani su eputasiu ba putsu, uja Felipe quisabatana: —¿Quepia ni da ecuaneda jana ebaja pamapa ye cristiano cuana emihua puji? ");
INSERT INTO tnaNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Daja Jesús ja Felipe atana cuaja tu ejeutsuti eba puji. Jesús mu da bahue saisia puina cuaja cristiano cuana mihuame ya.) ");
INSERT INTO tnaNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Da su Felipe ja uja jeutsutana Jesús: —Beju beta cien mudu tsine echuje tupu mahue, pan baja putsu, ye cristiano cuana emihuape puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Da su Simón Pedro sa edue Andrés ja Jesús atana: ");
INSERT INTO tnaNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Hue upia yanana chidi sa pishica pan chidi cuana, beta se chidi detse bahui yani. Beju, ¿ai detse ye chidi tupu pu cua dajucua cristiano cuana sa? ");
INSERT INTO tnaNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Da su Jesús ja discípulo cuana cuatsasiatana uja: —Cristiano cuana meaniutemeque. Dapia eti jude da nutsaji puina putsu, pamapa su beju aniutetana. Pishica mil deja cuana anitaina. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Da su Jesús ja pan pishica inatana. Diusulupai Tata Diusu a putsu, pan cuana discípulo cuana tiatana cristiano cuana paberereatiata huecuana puji. Daja huecha atana se detse. Pan, se eberereatiatani huecuana cama, jajucuatiana. Pamapa su diadiatana tupu. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Beju sejetana huecuana su, Jesús ja discípulo cuana cuatsasiatana: —Mechuduque puchu cuana ai biame pasituti mahue puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Da su jana puchu chudutana huecuana. Piada tunca beta ejaitiana d'iti cuana sejeatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Da su cristiano cuana ja Jesús ja atana ba putsu, uja putana huecuana: —Enei hue, ye da Diusu sa profeta ecuaneda eid'uainia. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Da su Jerusalén ejude su Jesús dusuja adhaatana huecuana mecuana sa echua puji ya puji. Jesús ja mu daja tuna sa piba shanapa putsu, tuna peje jenetia netiderana. Murucu aida cuana duju su putiana tu mehua yaniti puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tueda dhidha su discípulo cuana bai su butetana. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Jesús cuinaji mahue ba putsu, canoa aida dume su nubitana huecuana bai epetua puji, dhidha cuinaitia beju putsu. Capernaum ejude su cuinatija putana huecuana. Tueda ejude da bai chu maje anina. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Beju tuna yanipetutahu su, beni jubida pupiruana. Ena beju aida netianana. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tuna pishica ahua sucuta kilómetro uquedame tupu su, ena bia je quita hue yasesiu Jesús batana huecuana. Beju jubida rubutanapirutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Da su Jesús ja atana huecuana uja: —¡Ema hue! ¡Be merubutanaji! ");
INSERT INTO tnaNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Da su beidaji neje Jesús batsutana huecuana canoa dume su. Da hora quitaita hue beju canoa satsuana tuna eputahu yahua su. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Beju ehuenani su, Jesús ja mihuatana cristiano cuana da quepia Jesús ja mihuatana huecuana eti jude su putitana Jesús echacuti puji, Jesús mue anipetuti discípulo cuana neje batana huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Beju tuna dapia quisaquisa epuneti cama, pia canoa aida cuana dapia satsuatana. Tueda canoa cuana da Tiberias ejude jenetia puetana. Tueda ejude da bai u maje chuadera anina. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Da su cristiano cuana Jesús, discípulo cuana di mue dapia ani bahue pu putsu, anipetutitana huecuana canoa aida cuana su Jesús echacuti puji. Capernaum ejude su putitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Cristiano cuana Jesús yani su cuinati putsu, uja tueda quisabatana huecuana: —Ebuetsuaji, ¿quetsunu mi cuinana upia? ");
INSERT INTO tnaNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Da su Jesús ja jeutsutana huecuana: —Ene putsu, yama micuana equisainia, micuaneda ema echacuinia, yama micuana saida mihuana putsu. Aimue micuaneda ema chacu, ema peje su jei puja putsu mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Be mechacuji epupe jana. Mechacuque pupe bue mahue jana. Tueda jana ja micuana Diusu peje su eid'e yameenitayu. Tueda jana yama etiainia, ema Diusu sa Jabeituti Deja putsu. Da puji Tata Diusu ja ema ye mundo su beitutana. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Da su tuneda Jesús quisabatana: —¿Ai ni da ecuanaju a cua Diusu beidaji yame puji? ");
INSERT INTO tnaNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús ja jeutsutana huecuana: —Diusu sa tsada micuaneda mesa Jabeituti Deja peje su jei epu puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Da su Jesús uja quisabatana huecuana: —Aque pia nimetiuda aida ecuanaju mi peje su jei epu puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ecuana sa tata chenu cuana ja cielo jenetia pan nime maná banime diataidha pamapa tsine d'anita yahua su. Uja Diusu sa quirica derejiji yani: “Moisés chenu ja maná cielo jenetia tiataidha padiata huecuana puji.” ");
INSERT INTO tnaNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Da su Jesús ja atana huecuana: —Ene putsu, yama micuana equisainia, aimue Moisés chenu ja tata chenu cuana maná jana cielo jenetia tiataidha mahue. Quema Tata Diusu ja mu tiataidha huecuana. Jiahue beju quema Tata ja micuana eid'e jaametiji pan etiatani. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Cuaja biahua tiempo su Diusu ja maná jana cielo jenetia tata chenu cuana tiataidha ediadia puji nime, daja da ema jiahue beitutana. Ema da maná jana cielo jenetia nime. Quebata quema quisa saida cuana su jei epu su, eid'e Diusu neje cielo su epueni. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Da su Jesús atana huecuana uja: —Echua Puji, tiaenique ecuanaju tueda jana pamapa tsine. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Da su Jesús ja atana huecuana: —Beju ema da eid'e jaametiji pan nime cielo jenetia buteana cristiano cuana eid'e yame puji. Cuaja jana ja equita eid'e yametani nime, daja da yama cristiano cuana eid'e yameeniyu, ahua ema peje su jei eputa huecuana su. Beidaji eputa huecuana sejejiji cuana nime. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Beju yama micuana quisaitia, micuaneda ema baitia biame, aimue ema peje su jei puja mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Quema Tata ja bahui cristiano cuana ema peje su jei yametani. Quebata ema peje su jei epu su, aimue yama tueda ejusiacuina mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Aimue ema ye mundo su pue quema ai tsada cuana ya puji. Quema Tata sa ai tsada cuana ya puji bahui ema pueana. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Quema Tata sa tsada aimue ema peje su jei putana cuana pataitana mahue puji. Beju tiempo epupe su, manujiji cuana enetianata su, yama enetianameyu huecuana ema neje cielo su paputita huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ye mundo su ema epueicha su, yama enetianameyu huecuana. Tueda da Diusu sa tsada yama ya puji. Beju daja Jesús quisatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Da putsu, judío cuana sa ehuidusuji cuana ja Jesús tuaquisapirutana, Jesús, “Ema da eid'e jaametiji pan cielo jenetia buteana”, puana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Uja jaquisatitana huecuana: —¿Aimue jia maida ye Jesús José sa ebacua mahue? Beju tusa tata detse ecuaneda eshanapaeninia. Daja biame, ¿jucuaja su ni da tueda, “Ema da cielo jenetia buteana”, epuani? ");
INSERT INTO tnaNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Da su Jesús ja uja atana huecuana: —Memimirijique quema puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tata Diusu ja ema beitutana. Aimue detse aidhe biame ema peje su jei pu cua mahue, Diusu ja tueda jei yametani mahue su. Pamapa ema peje su jei eputani cuana yama enetianameyu, ema epueicha su. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Diusu sa profeta chenu cuana sa quirica su uja derejiji yani: “Diusu ja pamapa su ebuetsuata.” Da su quebata quema Tata sa jabuetsuati cuana ebuetsuati su, ema peje su jei epuyu. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","‘Mue aiya biame Tata Diusu ba. Yama bahui bana, tu peje jenetia ema pueana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ene putsu, yama micuana butsepi equisainia, ahua quebata ema peje su jei epu su, tueda eid'e epueni. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ema da eid'e jaametiji pan nime. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Micuana sa tata chenu cuana ja d'anita yahua su maná jana diataidha biame, beju manutaidha huecuana pamapa. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ema mu da eid'e jaametiji jana nime cielo jenetia. Quebata ja tueda pan ediata su, aimue tueda emanueni mahue beju. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ema da eid'e jaametiji pan nime cielo jenetia buteana. Quebata ja tueda eid'e jaametiji pan ediata su, tueda da eid'e epueni. Beju tueda pan da quema equita. Yama quema equita Diusu peje su curusu su eirutsuati cristiano cuana cielo su eid'e papuenita puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Da su beju judío cuana sa ehuidusuji cuana tuneda cama jacuicuinatitana uja: —¿Cuaja ni da ye deja ja mesa equita tiata cua ecuana edia puji? ");
INSERT INTO tnaNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Da su Jesús ja atana huecuana: —Ene putsu, yama micuana equisainia, ahua micuaneda aimue quema equita edia mahue su, ahua quema ami aimue eid'i mahue su, aimue micuaneda cielo su eputiyu mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Quebata ja quema equita ediata su, quema ami di eid'ita su, tueda cielo su eputiyu. Yama tueda enetianameyu, tiempo epupe su. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Quema equita da jana eni quitaita. Daja huecha quema ami da eid'iji eni quitaita. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Quebata ja quema equita ediata su, quema ami eid'ita su, tueda ema neje dunejiji yani. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ema beituji Tata da eid'e. Da putsu, ema tu jepuiti eid'e. Daja huecha quebata ja ema ediata su, beju tueda eid'e epueni. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ema da jana cielo jenetia buteana. Yama micuana tueda jana jepuiti equisainia. Tueda jana mu da aimue maná jana nime mahue. Micuana sa tata chenu cuana ja d'anita yahua su maná jana diataidha biame, beju manutaidha huecuana pamapa. Quebata ja mu tueda jana ediata su, tueda aimue emanueni mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Daja Jesús ja cristiano cuana buetsuatana tuna sa jadhitati jude ete su Capernaum ejude su. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Dueji Jesús sa ebuqueji cuana ja daja tusa mimi cuana id'aba putsu, uja jaquisatitana: —Tueda tusa mimi cuana da atadhada. ¿Aiya detse tusa equita diata cua? Tsada mahue ecuanaju sa tueda ai quisa cuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Da su Jesús ja tuneda cama daja equisatitani shanapa putsu, uja quisabatana huecuana: —¿A da quema quisa cuana madhada hue micuaneseda puji? ¿A da micuaneda ema peje su jei purijija quema quisa cuana jepuiti? ");
INSERT INTO tnaNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ahua aimue jiahue micuaneda ema peje su jei puja mahue su, ¿cuaja ni ema peje su jei pume pu cua, ema cielo su etsuahu ba putsu biame? ");
INSERT INTO tnaNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Equita da nid'uji su, beju eid'e. Daja huecha quebata quema quisa su jei epu su, tueda eid'e epueni. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Beju piada piada micuaneda aimue ema peje su jei epuani mahue tsuhu. Daja Jesús ja atana huecuana, tu peje su jei puja mahue eputani cuana equene su hue shanapatana putsu. Daja huecha aiya tu emenajatiata. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Da su Jesús ja atana huecuana: —Da putsu, yama micuana quisaitia uja: Aimue detse aidhe biame ema peje su jei pu cua mahue, Diusu ja tueda jei yametani mahue su. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Da hora su beju jucuada Jesús sa ebuqueji cuana ja buquerijitana. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Da su beju Jesús ja mesa piada tunca beta ejaitiana discípulo cuana uja quisabatana: —¿A da micuaneda di putiyuja? ");
INSERT INTO tnaNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Da su Simón Pedro ja Jesús jeutsutana uja: —Echua Puji, ¿aidhe peje su ni da ecuanaju puti cua, mique quisa cuana bahui eid'e jaametiji. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ecuanaju beju mi peje su jei puana, mida da nimebutsepi, Diusu peje jenetia putsu. Eid'e eni Diusu sa Ebacua da mida ecuanaju eshanapaeninia. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Da su Jesús ja jeutsutana huecuana: —Yama quitaita micuana dhareana biame, piada micuaneda beju Ishahua sa emebajaji. ");
INSERT INTO tnaNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Daja Jesús mimiana, Judas Iscariote ja tueda emenajatiata bahue puina putsu. Judas da discípulo epuani biame, Jesús menajatiataji epu. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Da su beju Jesús Galilea yahua je aseana. Aimue Judea yahua su anija puana mahue, dapia judío cuana sa ehuidusuji cuana ja tueda manuameja atana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","3","Beju judío cuana sa erere tsine banime enariatiani putsu, Jesús sa edue cuana ja tueda uja atana: —Be upia anitiji. Putique Judea yahua su dapia tsine eba puji. Dapia mique ebuqueji cuana ja di miada ai nimetiuda yainia cuana pabata. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","A mi cristiano cuana ja shanapataja su, tuna butse su ai nimetiuda aida mique a taji. Be rubuajiji ai nimetiuda cuana aji. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Daja mimitana huecuana, tu peje su jei putana mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Da su Jesús ja atana huecuana: —Quema puti hora cuinaji mahue tsuhu. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Micuaneda bahui meputique. Micuaneseda puji mu saida eputi puji, Diusu tsada mahue cuana da micuana neje aimue eduininitani mahue putsu. Ema neje bahui eduininitani huecuana, tuna ai jucha cuana yatani yama etuaquisainia putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Meputique tsine eba puji. Aimue ema eputi mahue tsuhu. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Da su Jesús anitiana. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Beju mesa edue cuana tsine su putitana su, Jesús di tije putiana. Cuatsa mahue rubuajiji putiana. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Judío cuana sa ehuidusuji cuana ja Jesús chacudhaatana tsine su cristiano cuana duju su. —¿Juque pa da tueda deja? —putana huecuana. Uja cristiano cuana quisabatana huecuana: —¿Ahua micuaneda mue ba tueda deja? ");
INSERT INTO tnaNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","13","Cristiano cuana ja ehuidusuji cuana ebia su iyubatana putsu, mue tuneda jajeutsuti putana. Tuneda cama cuatsa mahue etsia quisa jaatitana huecuana. Jesús jepuiti jaquisatitana huecuana. Piada piada, “Tueda da deja butsepi”, putana. Pia cuana, “Tueda da deja madhada, cristiano cuana baseaji putsu”, putana. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Beju tsine edusete su Jesús templo su nubiana cristiano cuana ebuetsuapiru puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Da su judío cuana sa ehuidusuji cuana nimetiunetitana. Uja Jesús quisabatana huecuana: —Aimue mida jabuetsuatiji mahue biame, ¿cuaja ni da mida bahue eni pamapa ai cuana pu cua? ");
INSERT INTO tnaNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús ja jeutsutana huecuana: —Yama ebuetsuainia ai cuana da aimue quema jabuetsuati quitaita mahue. Tueda da Tata Diusu sa jabuetsuati cuana. Tuahueda ema beitutana mesa jabuetsuati cuana cristiano cuana ebuetsua puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Quebata ja Diusu sa ai tsada cuana yatani su, tueda bahue epu quema jabuetsuati cuana da Diusu peje jenetia. Aimue quema piba hue ebuetsuainia mahue tueda bahue epu. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Quebata tuseda puji saida emimiani su, tueda quita aida cristiano cuana ja pabata mesa tsada. Quebata mu tu beituji sa puji saida emimiani su, tueda da deja saida, butsepi, cristiano cuana ja tu beituji aida pabata mesa tsada putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","‘Ene mu da Moisés chenu ja micuana jacuatsasiati cuana tiataidha. Micuaneda ema manuameja yainia, tueda jacuatsasiati yama yainia mahue epuani putsu. ¿Ai puji ni da micuaneda ema manuameja yainia, micuaneda quitaita tueda jacuatsasiati yainia mahue biame? ");
INSERT INTO tnaNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Da su Jesús atana huecuana uja: —Mida da tseitsi. ¿Aiya mida manuameja yatani? ");
INSERT INTO tnaNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","23","Jesús ja uja jeutsutana huecuana: —Yama deja janahua tsine su saisiameana putsu, micuaneda ema manuameja yainia. Beju micuaneda quitaita mudumudu bahue janahua tsine su. Moisés chenu ja cuatsasiataidha deja yanana chidi cuana huitsanasiqui taji ocho tsineji su. Ecuana sa tata chenu cuana Moisés chenu ja equene daja ataidha. Da su beju janahua tsine biame, micuaneda deja yanana chidi ehuitsanasiquinia, tusa ocho tsine etsutiani su. Beju, ¿ai puji ni da su micuaneda ema manuameja yainia, deja nedaji saisiameana putsu? ");
INSERT INTO tnaNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ahua micuaneda juzgaja su, butsepi neje mejuzgaque. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Da su pia Jerusalén su aniji cuana tuneda cama uja jaquisabatitana: —¿Aimue jia maida ye deja ecuana sa ehuidusuji cuana ja manuameja yatani mahue? ");
INSERT INTO tnaNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Hue upia cristiano cuana buetsua epuneti. ¿Jucuaja su aimue einatani huecuana mahue? ¿Da su mu jia tuneda di tu peje su beju jei eputani? ¿Da su mu jia tuneda di tueda da Diusu sa Jabeituti Deja jei eputani? ");
INSERT INTO tnaNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Da su pia cuana ja atana huecuana uja: —¡Mahue! Aimue tueda Diusu sa Jabeituti Deja mahue. Ecuanaju mu bahue saisia quepia Jesús bataji puana. Diusu sa Jabeituti Deja beju ecuina su, aimue aidhe biame bahue epu mahue que jenetia pueitia. Daja jaquisatitana huecuana Cristo jepuiti, japitsati putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesús ja id'aba putsu, jubida jeutsutana huecuana: —¿Ai micuaneda ema eshanapainia bata? ¿Ai micuaneda que jenetia ema epusiu bahue bata? Ema da ene quita Diusu peje jenetia pueana. Tuahueda quitaita ema huaratiatana. Micuaneda aimue shanapa tueda. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yama mu tueda eshanapaeninia, tu neje ema anina putsu. Tuahueda ema micuana peje su beitutana. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Da su judío cuana sa ehuidusuji cuana ja Jesús inaja adhaatana, risi putsu, edusu puji. Beju aimue aiya biame ina atana, aimue mesa ina hora putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Dueji cristiano cuana tu peje su jei putana. Uja tuneda jaquisatitana: —Ye da Diusu sa Jabeituti Deja. ¿Ai puji ni da ecuaneda pia id'ua cua? ¿Aiya detse da tueda nimetiuda aida cuana ata cua, ye deja ja yatani nime? ");
INSERT INTO tnaNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseo, sacerdote huaraji aida cuana ja cristiano cuana daja eputani shanapa putsu, templo sa soldado cuana beitutana huecuana Jesús eina puji dhahua. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Da su Jesús ja cristiano cuana uja atana: —Quejucua tsine puji hue beju ema micuana neje yaniti. Da su beju ema esiapatiyu ema beituji peje su. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Micuaneda ema echacudhaa. Aimue micuaneda ema eteje mahue, dapia ema yaniti putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Da su ehuidusuji cuana uja jaquisabatitana tuneda cama: —¿Quepia jia da eputi tueda ecuaneda aimue eteje mahue? Cuapuitime pia yahua su eputi pia cristiano cuana ebuetsuati puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Ai ni da tueda quisa epuani? ");
INSERT INTO tnaNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Tije tsine beju epupeni su, Jesús netianana. Cristiano cuana jubida neje uja atana: —Quebata cuana jaid'itija eputani su, mepueque ema peje su eid'iti puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Uja Diusu sa quirica su derejiji yani: “Quebata ema peje su jei epuani su, mesa enime su eid'e jaametiji yahui putiputi nime.” ");
INSERT INTO tnaNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Beju Jesús sa mimi cuana da uja epuani: Tu peje su jei eputani cuana ja Espíritu Santo ebatsuta tuna sa muesumu su. Beju aimue tsuhu tueda Espíritu Santo pueji mahue, Jesús cielo su mesa Tata Diusu peje su putiji mahue tsuhu putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Cristiano cuana ja Jesús sa mimi id'aba putsu, tuneda cama jacuicuinapirutitana. Piada piada cuana uja putana: —Enei hue, ye deja da Diusu sa profeta pue taji. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Pia cuana ja uja jeutsutana huecuana: —¡Mahue! Ye deja da Diusu sa Jabeituti Deja quitaita. Beju pia cuana di uja putana: —¿Quepia detse ye Jesús da Diusu sa Jabeituti Deja pu cua, tueda Galilea yahua jenetia putsu? Diusu sa Jabeituti Deja aimue detse Galilea yahua jenetia pue cua mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Diusu sa quirica su Diusu sa Jabeituti Deja Judea yahua, Belén ejude jenetia mesa pue taji epuani. Echua puji David chenu sa familia jenetia mesa pue taji epuani. Tueda Belén ejude da echua puji David chenu sa ejude. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Daja da cristiano cuana mimitana. Ai jia Jesús puina cuaja jaduneti taji mahue jabatitana huecuana. Jasajasajatitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Pia cuana ja mu Jesús risi putsu, dusuja adhaatana. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Da su beju templo sa soldado cuana jasiapatitana fariseo, sacerdote huaraji aida cuana peje su. Soldado cuana cuinatana su, fariseo cuana ja uja quisabatana huecuana: —¿Jucuaja su ni micuaneda mue Jesús duse? ");
INSERT INTO tnaNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Da su uja jeutsutana huecuana: —Aimue aidhe biame mimi tueda deja nime. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Da su fariseo cuana ja jubida d'ayatana huecuana uja: —¡Ai! Micuaneda di jia beju baseataitia. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Ai fariseo, sacerdote huaraji aida cuana ja tueda deja jei a atana bata? ");
INSERT INTO tnaNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Cristiano jacuatsasiati shanapa bue mahue cuana bahui tu peje su jei eputani. Da su Diusu ja pamatseta huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Beju fariseo Nicodemo di dapia anina. (Tueda da equene putiana Jesús peje su dhidha su.) Tuahueda uja atana huecuana: ");
INSERT INTO tnaNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Aidhe biame ecuaneda cuaja matse taji mahue ebainia id'abaji mahue. Daja ecuaneseda jacuatsasiati cuana epuani beju. ");
INSERT INTO tnaNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Da su jubida jeutsutana huecuana uja: —¿Ai puji mida daja emimiani? ¿Ai mida di tu nime Galilea yahua jenetia bata? Mimiameenique Diusu sa quirica su. Aimue Diusu sa profeta piada biame Galilea yahua jenetia ecuina mahue. Daja da quirica su epuani. Da su, ¿cuaja jia da Jesús Diusu sa profeta pu cua, tueda Galilea yahua jenetia putsu? ");
INSERT INTO tnaNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Da su beju tuneda mimipetana su, putitaibana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Da su beju Jesús da murucu aida Olivo banime su putiana. Dapia anidhidhana. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Beju pia huenati su templo su jasiapatiana. Pamapa cristiano cuana tu peje su janariatiana. Jesús aniute putsu, buetsuapirutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Da su beju Moisés chenu sa jacuatsasiati buetsuaji, fariseo cuana Jesús yani su putitana. Epuna chuamadhada Jesús peje su dusetana huecuana. Tueda epuna pia deja neje biatejetana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Beju dapia cristiano cuana duju su epuna netia putsu, Jesús uja atana huecuana: —Ebuetsuaji, ye epuna da ecuanaju biatejeitia pia deja neje. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Tueda ecuanaju tumu neje chuatara taji yainia, daja Moisés chenu sa jacuatsasiati epuani putsu. Beju, ¿cuaja ni mida epibatiani? ");
INSERT INTO tnaNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Daja Jesús quisabatana huecuana, ahua madhada hue ejeutsuti Moisés chenu sa jacuatsasiati jepuiti eba puji. Da su Jesús tud'isana. Tusa emehuituji neje yahua su derepirutana. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Beju tuneda daja hue quisabainiame atana putsu, Jesús netianana. Uja atana huecuana: —Quebata micuaneda jucha mahue, tuahueda epuna tumu neje pachuatarapiruta. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Daja mimipe putsu, neicha tud'isana. Yahua su daja hue dereiniame atana. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Da su bezu piada putiyu putana huecuana. Edhi cuana equene piada putiyu putana. Da su pamapa pia cuana tije pupetitaibana. Jesús da epuna neje bahui anitiana. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Da su Jesús netiana putsu, epuna eneti tu mehua batana. Tuahueda epuna quisabatana uja: —Epuna, ¿juque da mi tuaquisaji cuana? ¿A mida aiya biame mue matse? ");
INSERT INTO tnaNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Epuna ja jeutsutana uja: —Ehe, Echua Puji, ai mahue. Da su Jesús ja epuna atana: —Da su aimue yama biame mi ematse mahue. Puchiditiyuque. Be jucha puichaji beju. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Daja hue neicha Jesús ja cristiano cuana quisainiame atana uja: —Ema da hueda nime. Yama micuana Diusu sa jabuetsuati cuana ebuetsuainia saida, butsepi micuana edusuti puji. Quebata quema jabuetsuati cuana su epuniuneti su, tueda da hueda su epuniuneti cristiano nime. Aimue apuda su epuniuneti cristiano nime mahue. Tueda da beju nimeeichacua. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Da su fariseo cuana ja Jesús uja atana: —Mida mi mehua equisanetiacuinatiani. Da putsu, mique mimi aimue chujeji mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús ja jeutsutana huecuana: —Ema quema puji saida equisanetiacuinatiani biame, quema mimi cuana beju chujeji, ema bahue que jenetia ema pueana, quepia ema epuhu putsu. Micuaneda mu bue mahue que jenetia ema pueana, quepia ema eputi. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Micuaneda ema juzgaja yainia, butsepi shanapaji mahue biame. Yama mu beju aimue jiahue micuana ejuzgainia mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ahua jiahue yama juzga a cua su mu, beju butsepi yama micuana ejuzga, quema Tata ema beituji ja di ema neje micuana ejuzgata putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ahua beta jatuaquisatiji detse tupupai equisanetiacuinati su, jei a taji. Daja derejiji Moisés chenu sa jacuatsasiati quirica su. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Jade. Ema quema puji saida equisanetiacuinatiani. Quema Tata ema beituji ja di quema puji saida equisanetiacuinatiani. Da su etseju tupupai equisanetiacuinatiani. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Da su Jesús quisabatana huecuana uja: —¿Quepia mique tata? Jesús ja jeutsutana huecuana: —Micuaneda aimue ema shanapa. Daja huecha quema Tata di aimue shanapa. Ahua micuaneda ema shanapa cua su, quema Tata di detse micuaneda shanapa cua. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Daja mimiana Jesús, templo su ebuetsua epuneti je. Beju tueda netina chipilu irutsuaji emeji cuana naja su. Mue aiya biame tueda ina atana, tusa ina hora beju cuinaji mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Neicha Jesús ja ehuidusuji, fariseo cuana uja quisatana: —Beju ema eputiyu. Quepia ema eputi aimue micuaneda puti cua mahue, micuaneda micuana sa jucha cuana neje emanueni putsu. Micuaneda ema echacu biame, aimue ema eteje mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Da su tuneda cama jaquisabatitana huecuana: —¿Jucuaja su jia da ecuaneda aimue puti cua mahue quepia tu eputi su? ¿Cuaja jia, a da emanuameti? ");
INSERT INTO tnaNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesús ja atana huecuana: —Micuaneda ye yahua sa puji. Ema mu cielo sa puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Da putsu, yama micuana butsepi equisainia, micuana sa jucha cuana neje beju emanueni, ahua aimue micuaneda ema peje su jei epu mahue su. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Da su Jesús quisabatana huecuana: —¿Aidhe da mida? Jesús ja jeutsutana huecuana: —Beju yama micuana, aidhe da ema, butsepi quisana, ema mimipiruana jenetia. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Dueji micuaneseda ai madhada yani yama micuana ematse puji. Beju aimue jiahue daja ya mahue. Quema Tata ja ema quisatana bahui yama jiahue micuana equisainia. Tusa quisa cuana da ene quita butsepi. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Beju mue shanapa atana huecuana Jesús da Tata Diusu jepuiti mimiana. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Da putsu, Jesús ja daja hue uja quisainiame atana huecuana: —Micuaneda ema curusu su ejemitsua su, da hora su micuaneda eshanapa ema da Diusu sa Jabeituti Deja. Tu peje jenetia pueana. Tusa jabuetsuati cuana bahui yama micuana quisana. Aimue quema piba cuana bahui mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ema beituji quema Tata da ema neje yani pamapa hora su. Aimue ema mehua ema emesiatani mahue, tusa ai tsada cuana bahui yama yainia putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesús beju daja mimiana su, dueji cristiano cuana jei putana tu peje su. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Da su Jesús ja atana huecuana uja: —Ahua micuaneda quema jabuetsuati cuana jubida jei yaeni su, quema ene quita ebuqueji cuana epu. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Diusu sa ene quita mimi eshanapayu. Tueda mimi shanapa putsu, micuana d'eji su epueniyu. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Da su fariseo cuana ja Jesús quisatana uja: —Tseitsi nime mida emimiani. ¿Ai jepuiti ni da ecuananju d'eji su pu cua? ¿Ai ecuanaju esclavo cuana bata? Quetsunu su biame ecuanaju esclavo pu bue mahue, ecuanaju da Abraham chenu sa ebacua cuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Da su Jesús ja atana huecuana: —Ene putsu, micuana yama yainia, cuaja esclavo emetse sa eme su yani nime, daja da micuaneda jucha sa eme su yani. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Esclavo da aimue familia quitaita mahue. Ebacua bahui da familia quitaita epuani. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ahua Diusu sa Ebacua ja micuana d'eji su yameta su, da su micuaneda d'eji su epuenipeyu. Aimue jucha sa eme su yaniti mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Micuaneda da Abraham chenu sa familia jenetia biame, ema manuameja yainia, quema quisa micuaneseda tsada mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Quema Tata ja ema quisatana cuana bahui yama micuana equisainia. Micuaneda mu beju micuana sa tata sa tsada bahui yainia. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Da su Jesús jeutsutana huecuana uja: —Beju ecuanaju sa tata da Abraham chenu. Jesús ja atana huecuana: —Ahua ene quita micuaneda Abraham chenu sa ebacua cuana epuani su, tu ataidha nime micuaneda di a cua. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Micuaneda ema manuameja ana, “Diusu ja ema butsepi buetsuatana”, ema pueana putsu. Beju Abraham chenu ja mu aimue ye ai madhada cuana a bue mahue puidha, cuaja micuaneda yainia nime. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Micuaneda da yainia, cuaja micuana sa tata chenu cuana ja ataidha nime. Da su Jesús jeutsutana huecuana: —Aimue ecuanaju cha teje ajiji ebacua cuana mahue. Diusu quitaita da ecuanaju sa tata. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Da su Jesús ja atana huecuana uja: —Ahua Diusu da micuaneseda tata pu cua su, micuaneda detse ema ibuneda ba cua, ema tu peje jenetia pueana putsu. Aimue ema quema ebani su pue. Tata Diusu ja quitaita ema beitutana. Tusa ebani su ema pueana. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Micuaneseda quema jabuetsuati tsada mahue putsu, aimue quema quisa cuana eshanapainia mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Micuana sa tata da Ishahua. Micuaneda tusa tsada cuana bahui yainia, micuaneda tuseda puji putsu. Ishahua da equene jenetia manuame bahue puidha. Tueda butsepi mimi bue mahue. Bid'umimi bahui emimiani. Daja hue tueda mu epuani. Tueda equene jenetia bid'umimi puidha. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Beju yama micuana butsepi emimiani biame, aimue micuaneda ema peje su jei epuani mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Aimue aiya biame ema jucha jepuiti tuaquisata cua mahue. ¿Jucuaja su ni micuaneda ema jei aja mahue, ema butsepi emimiani biame? ");
INSERT INTO tnaNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Quebata Diusu sa dharejiji epuani su, tuahueda Diusu sa quisa cuana id'abaja yatani. Micuaneda mu Diusu sa mimi id'abaja mahue yainia, aimue tuseda puji mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Da su beju fariseo cuana ja Jesús uja atana: —Enei hue, mida da mue ai puji saida samaritano nime. Mida da einid'u madhadaji. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús ja jeutsutana huecuana uja: —Aimue ema einid'u madhadaji mahue. Yama quema Tata Diusu bahui eiyubainia. Aimue micuaneda ema eiyubainia mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Tsada mahue quema cristiano cuana ja ema aida pabata puji. Quema Tata sa tsada bahui ema aida papu. Pamapa ema aida baja mahue yatani cuana tuahueda ematsetayu. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ene putsu, yama micuana equisainia, quebata ja quema mimi cuana jei yata su, aimue tueda emanueni mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Da su neicha Jesús jeutsutana huecuana: —Ene putsu, mida einid'u madhadaji. ¿Cuaja su mi daja emimiani? Abraham chenu manuidha. Diusu sa profeta cuana di manutaidha. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Ai mida tuna ebia su aida bata? ¿Aidhe pepe jia mida epuani? ");
INSERT INTO tnaNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Da su Jesús ja jeutsutana huecuana: —Ahua ema quema puji quitaita equisanetiacuinatiani su, aimue chujeji mahue. Aimue ema saida equisanetiacuinatiani mahue quema puji. Quema Tata Diusu mu da quema puji saida equisanetiacuinatiani. Tueda quema Tata micuaneda, “Ecuanaju sa Diusu”, epuani biame, beju aimue daja mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mue micuaneda shanapa tueda. Yama bahui tueda eshanapainia. Ahua ema, “Aimue yama shanapa tueda”, pu cua su, ema micuaneda nime bid'umimi puji pu cua. Yama mu yainia tu ema yametani ai cuana, yama tueda eshanapainia putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Micuana sa tata Abraham chenu da beidaji puidha, ema yahua su epusiu bahue pu putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Da su Jesús atana huecuana uja: —Beju aimue mique pishica tunca mara yani mahue biame, mida, Abraham chenu bana, epuani. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Beju Jesús ja uja jeutsutana huecuana: —Ene putsu, yama micuana butsepi equisainia, Abraham chenu bataji puji mahue su, beju ema anidha. ");
INSERT INTO tnaNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Da su tuneda daja id'aba putsu, tumu cuana inatana huecuana Jesús emaracadhaa puji. Da su beju Jesús templo jenetia cuinanana, judío cuana sa ehuidusuji cuana ja tumu echudutasa cama. Cristiano cuana duje jaitianana bataji mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Da su beju Jesús pia eti jude su epuhu je, piada deja padha batana. Tueda deja padha bataji puana. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Discípulo cuana ja Jesús uja quisabatana: —Ebuetsuaji, ¿jucuaja su da tueda deja daja padha bataji puana? ¿Ahua tusa tata detse sa jucha jepuiti, ahua tusa jucha quitaita jepuiti? ");
INSERT INTO tnaNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús ja jeutsutana huecuana: —Aimue ai sa jucha jepuiti tueda padha bataji puana mahue. Daja bataji puana yama cristiano cuana Diusu tucheda ebameti puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Beju ema ye mundo su yani tupu, Diusu sa ai tsada cuana quema a taji yani. Tiempo epusiu da aimue ema yani mahue puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ema da hueda nime, ye mundo su ema yani tupu. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jesús daja mimipe putsu, yahua su quituatana. Equedi neje rutu chidi susiatana. Tueda rutu ichatana padha sa etua bia su. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Da su uja cuatsasiatana deja padha: —Jarucuatitique Siloé banime yahui rara su. (Tueda ebani Siloé, “Beitujiji”, epuani.) Da su beju deja padha putiana. Erucuatiani cama beju, jabatiana. Tusa ete su saida jasiapatibana. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Pamapa tu shanapaji cristiano cuana ja ba putsu, uja jaquisabatitana huecuana: —¿Aimue jia maida ye deja padha chipilu bajataina mahue? ");
INSERT INTO tnaNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Da su piada piada cuana ja jeutsutana uja: —Ehe, tueda quitaita da. Beju pia cuana ja mu jeutsutana uja: —Aimue tueda mahue. Beju daja quitaita mu da. Da su deja saisijiji ja jeutsutana huecuana: —Enei hue, ema da tueda quitaita. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Da su beju quisabatana deja huecuana uja: —¿Cuaja ni mida jiahue ebatiani? ");
INSERT INTO tnaNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Deja ja jeutsutana huecuana: —Tueda deja Jesús banime ja rutu chidi a putsu, quema etua bia su ichatana. Daja a putsu, ema, “Jarucuatique Siloé banime yahui rara su”, cuatsasiatana. Da su ema putiana erucuati puji. Dapia erucuatiani cama, beju ema jabatiana. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Da su beju quisabatana huecuana neicha: —¿Juque da tueda deja? Da su deja ja uja jeutsutana huecuana: —Bue mahue ema. ¿Juque jia? ");
INSERT INTO tnaNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Da su beju deja saisijiji dusutana huecuana fariseo cuana peje su. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesús ja janahua tsine su deja saisiametana putsu, fariseo cuana ja deja jubida quisabaja atana tuahueda pamapa butsepi paquisata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Da su fariseo cuana ja quisabape putsu, deja ja uja jeutsutana huecuana: —Tuahueda rutu chidi ichatana quema etua bia su. Da su ema jarucuatiana. Beju jiahue ema saida ebatiani. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Piada piada fariseo cuana uja putana: —Ye aji deja mu aimue Diusu peje jenetia mahue, tuahueda janahua tsine aimue eiyubatani mahue putsu. Pia fariseo cuana di uja putana: —Aimue Jesús deja juchaji mahue, ai nimetiuda saida cuana bahui yatani putsu. Beju daja hue tuneda cama jacuicuinatitana. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Da su neicha deja quisabatana huecuana: —¿Cuaja ni mida epuani tueda deja Jesús jepuiti? Da su deja ja jeutsutana huecuana uja: —Tueda mu da Diusu sa profeta yama epibainia. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Beju fariseo cuana aimue jei putana mahue tueda deja padha puina. Da putsu, deja sa tata detse jetitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Cuinati putsu, fariseo cuana ja quisabatana tse. —¿A da ye deja metse sa ebacua? ¿A da ene quita tueda padha bataji puana? ¿Cuaja ni da, da su jiahue beju tueda ebatiani? ");
INSERT INTO tnaNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Beju deja sa tata detse ja jeutsutana huecuana: —Ye deja da etseju sa ebacua padha bataji puana beju etseju eshanapainia. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Bue mahue etseju cuaja jabatime pujiji. Bue mahue etseju aiya tueda saisiametana. Mequisabaque tueda. Tuahueda micuana quisata cua, beju deja putsu. Tueda quitaita beju bahue cuaja saisime pujiji. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tata detse ja daja jeutsutana fariseo cuana, ebia su iyubatana tse putsu. Quebata da, “Jesús da Diusu sa Jabeituti Deja”, epu su, fariseo cuana ja jadhitati jude ete su aimue panubi yata mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Da putsu, daja jeutsutana tse, ebia su iyubatana tse putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Da su fariseo cuana ja neicha deja saisijiji ihua putsu, uja atana huecuana: —Diusu butse su neicha pamapa butsepi quisaque ecuanaju. Bahue ecuanaju Diusu ja mi saisiametana. Tueda bahui mique diusulupai a taji. Aimue tueda deja Jesús ja mi saisiameta cua mahue, juchaji putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Da su deja ja jeutsutana huecuana: —Ema bue mahue ahua tueda juchaji, ahua mahue. Ema padha puina biame, jiahue beju ema ebatiani. Tueda quitaita bahui beju ema bahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Da su neicha quisabatana huecuana uja: —¿Cuaja ni mida atana mi ebati puji? ");
INSERT INTO tnaNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Da su deja ja jeutsutana huecuana: —Beju yama micuana quisaitia beju. Mue micuaneda ema jei a. ¿Ai puji ni da ema neicha quisa pu cua? ¿Da su mu jia micuaneda di Jesús buqueja? ");
INSERT INTO tnaNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Beju deja ja daja jeutsu putsu, fariseo cuana ja uja madhabapirutana: —Miada tueda deja Jesús ebuqueinia. Ecuanaju mu Moisés chenu sa jacuatsasiati cuana bahui yainia. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ecuanaju bahue eni Diusu ja Moisés chenu mitsutaidha. Tueda deja Jesús mue ecuanaju shanapa que jenetia jia. ¿Aiya jia da tueda huaratiatana? Mue ecuanaju shanapa. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Da su deja ja jeutsutana huecuana: —¿Cuaja ni da pu cua? Tuahueda ema tuaji atana biame, micuaneda bue mahue aiya jia tueda huaratiatana. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Bahue eni ecuaneda aimue Diusu ja juchaji cuana eid'abatani mahue. Tusa ai tsada aji cuana bahui da eid'abatani. Pamapa tu eiyubatani cuana eid'abatani. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Quetsunu su biame ecuaneda id'aba bue mahue aiya deja padha bataji pujiji tuaji yametani. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ahua ye deja Jesús da Diusu peje jenetia mahue su, ¿cuaja ni da tuahueda tueda nimetiuda aida cuana ata cua? ");
INSERT INTO tnaNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Da su uja jeutsutana huecuana: —Mida jucha neje bataji puana putsu, aimue miqueda puji ecuanaju buetsua taji mahue. Da su fariseo cuana ja cuatsasiatana judío cuana sa jadhitati jude ete su deja panubi mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Beju Jesús ja fariseo cuana ja deja padha saisijiji daja atana shanapatana. Da su deja neje neicha jatsuti putsu, uja quisabatana: —¿A mi jei epuani Diusu sa Jabeituti Deja peje su? ");
INSERT INTO tnaNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Da su deja ja jeutsutana uja: —Ebuetsuaji, aimue yama tueda shanapa. Quisaque ema aidhe ni da tueda ema tu peje su jei epu puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús ja deja jeutsutana: —Beju da tueda miada ebainia. Tu neje mida quisaquisa epuani. Ema da beju. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Da su deja Jesús butse su tururu putsu, uja atana: —Echua Puji, jei ema mi peje su epuani. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Da su beju Jesús puana: —Ema ye mundo su pueana Diusu sa ai tsada cuana ya puji, Diusu eshanapatani mahue cuana Diusu eshanapame puji, daja huecha Diusu eshanapainia epudhaatani cuana Diusu eshanapata mahue huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Da su beju dapia netitaina fariseo cuana tusa mimi id'aba putsu, uja quisabatana Jesús: —¿Ai ecuanaju Diusu sa puji padha bata? ");
INSERT INTO tnaNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús ja jeutsutana huecuana: —Ahua micuaneda Diusu mue shanapa a cua su, aimue micuaneda juchaji pu cua mahue. Beju micuaneda mu da juchaji, micuaneda, “Ecuanaju Diusu eshanapainia”, epuani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Daja hue Jesús ja quisainiame atana huecuana: —Ene putsu, yama micuana equisainia, quebata da huisha taraca etsequeini je aimue enubiani mahue, tueda da tsi puji. Quebata da taraca je, tsua putsu, enubiani, tueda da tsi puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Quebata da huisha taraca etsequeini je enubiani, tueda da huisha quinaji. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Etsequeini quinaji ja huisha quinaji eshanapatani. Beju enubiametani. Huisha cuana ja di huisha quinaji eshanapatani. Tueda huisha quinaji ja pamapa su piada piada mesa huisha cuana eshanapaenitani. Pamapa su ebanishanapatani. Huisha cuana taraca jenetia etseque su ehuidusutani. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tuna ehui su epuhu. Huisha cuana tu tije eputitani, tu eshanapatani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pia deja shanapaji mahue aimue detse tu tije putita cua mahue. Tu peje jenetia ejududutani hue, tueda mue shanapa putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Daja Jesús ja quisatana huecuana huisha taraca jepuiti. Beju mue shanapa atana huecuana. Da su beju Jesús ja neicha uja quisatana huecuana uja: ");
INSERT INTO tnaNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","—Ene putsu, yama micuana equisainia, huisha cuana taraca sa eteriji je nubi putsu, beju saida edume su yanita. Daja huecha ema peje su jei eputani cuana yama saida equinainia. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Dueji bid'umimi ebuetsuaji cuana ja ema peje su jei eputani cuana bid'umimi buetsuaja eputani huecuana biame, aimue jei yata huecuana mahue. Tueda bid'umimi ebuetsuaji cuana da taraca jenetia huisha tsiji cuana nime. Huisha cuana ja pia sa etsui id'abaja mahue yatani nime, daja da ema peje su jei eputani cuana bid'umimi ebuetsuaji cuana peje su jei puja mahue eputani. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","‘Ema da taraca etsequeini nime. Cuaja huisha taraca etsequeini je enubiani d'eji su taraca dume su epu puji nime, daja da quebata ema peje su jei epuani cuati castigo jenetia d'eji su epu. Cuaja huisha ediadia puji cuinananuati epuani nime, daja da yama pamapa ema peje su jei eputani cuana pamapa ai saida cuana etiayu. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","‘Tsi puji epueni huisha etsi puji, emanuame puji bahui. Ema mu pueana cristiano cuana nimeeichacua, beidaji eni ya puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ema da huisha quinaji saida nime. Huisha quinaji saida ja mesa huisha cuana equinatani emanu teje. Daja huecha da ema emanu ema peje su jei eputani cuana sa puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mudu puji ja iba epusiu ba putsu, ejududuani. Huisha cuana ejusianetiatani, tuseda mahue putsu. Beju iba ja huisha cuana einatani putsu, eberebereametani. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mudu puji ejududuani, bianetiaja mahue putsu. Echuje bahui mesa tsada. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","‘Beju ema da huisha quinaji saida nime. Cuaja huisha cuana ja huisha quinaji eshanapatani nime, daja da ema peje su jei eputani cuana ema eshanapatani. Yama di eshanapainia huecuana. Daja huecha yama quema Tata Diusu eshanapainia. Tuahueda di ema eshanapatani. Cuaja huisha quinaji manu cua huisha cuana ebianetiainia je nime, daja da ema emanu ema peje su jei eputani cuana sa puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Cuaja huisha quinaji sa pia huisha cuana yani pia taraca cuana je nime, daja da quema yani pia ema peje su jei eputani cuana pia yahua cuana su. Tuneda di pamapa quema jabuetsuati cuana yatayu. Ema neje dunejiji yanitiyu huecuana pamapa pia ema peje su jei eputani cuana neje. Ema da mecuana sa Echua Puji epu. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","‘Tata Diusu ja ema ebia su ibuneda ebatani, ema quema dharejiji cuana sa puji emanu putsu. Ema emanu biame, neicha ema eid'eyu. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Aiya biame detse ema manuameta cua. Beju ema da emanu, daja quema tsada putsu. Daja huecha ema quitaita eid'emetiyu, quema Tata ja ema daja epu puji huaratiatana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Beju fariseo cuana ja Jesús sa quisa cuana id'abatana su, neicha tuneda cama jacuicuinatitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Uja piada piada cuana putana: —¿Ai puji ni da ecuaneda ye deja tseitsi eid'abainia, tueda einid'u madhadaji putsu? ");
INSERT INTO tnaNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Da su pia cuana ja uja jeutsutana: —Ahua tueda einid'u madhadaji su, aimue detse daja mimi cua mahue. ¿Ai einid'u madhada ja padha cuana tuaji ata cua bata? Daja da jacuicuinatitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Beju huinahuina badi cuana puina. Cristiano cuana ja templo sa tsine batanina Jerusalén ejude su. Jesús di dapia anina. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Salomón sa Corredor je templo su aseniunetiana. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tueda dapia yaseniuneti cama, beju judío cuana sa ehuidusuji cuana ja baretana. Duinini neje uja quisabatana huecuana: —¿Cuaja su mi ecuanaju mue quisa butsepi? ¿A da mida Diusu sa Jabeituti Deja? Beju jiahue quita butsepi quisaque ecuanaju. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Da su Jesús ja jeutsutana huecuana uja: —Beju yama micuana quisana biame, mue micuaneda ema jei a. Nimetiuda ai cuana yama yainia quema Tata sa tucheda neje. Micuaneda daja ba putsu, bahue pu taji aidhe da ema. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Beju micuaneda mu aimue ema peje su jei puja epuani mahue, quema dharejiji cuana mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Quema dharejiji cuana ja bahui ema eshanapatani. Yama di eshanapainia huecuana. Tuneda ema tije yatani. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yama eid'e yameeninia huecuana. Aimue matsejiji eputa huecuana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","30","Aiya biame quema eme jenetia mejemita cua mahue. Quema Tata ja ema peje su jei ametana huecuana. Daja huecha aiya biame tusa eme jenetia di mejemita cua huecuana mahue, tueda pamapa pia cuana ebia su aida putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Daja id'aba putsu, ehuidusuji cuana ja tumu jemitsuatana Jesús emaracadhaa puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Da su Jesús ja atana huecuana: —Yama micuana butse su jucuada ai nimetiuda cuana ana quema Tata sa tucheda neje. ¿Quebata nimetiuda jepuiti micuaneda ema maracaja yainia? ");
INSERT INTO tnaNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Da su jeutsutana huecuana uja: —Aimue ai nimetiuda cuana mi ana jepuiti ecuanaju mi maracaja yainia mahue. Beju ecuanaju mi emaracati, miada Diusu emadhabainia putsu. Mida da deja hue biame, Diusu neje tupupai puja epuani. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Da su Jesús ja jeutsutana huecuana: —Uja jacuatsasiati su derejiji yani Diusu ja ataidha: “Micuaneda da diusu cuana.” ");
INSERT INTO tnaNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tueda derejiji cuana mu a taji epuani. Pamapa Diusu sa mimi jei yatani cuana Diusu ja diusu cuana yatani. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Micuaneda yama Diusu emadhabainia epuani, “Ema Diusu sa Ebacua”, ema puana putsu. Beju Diusu ja quitaita ema ichaderatana. Ye mundo su ema beitutana. Da putsu, ema, “Ema da Diusu sa Ebacua”, epuani. Aimue yama Diusu emadhabainia quema quisa cuana neje. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ahua quema Tata sa ai yatani cuana aimue yama a su, be ema jei meaji. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Micuaneda quema quisa su jei puja epuani mahue biame, jei mepuque ema peje su, yama ai nimetiuda cuana yainia putsu. Bahue mepuenique quema Tata Diusu neje etseju piada hue epuani. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Da su neicha Jesús inaja adhaatana huecuana risijiji edusu puji. Daja biame, tuna peje jenetia putiana Jordán ena su. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jordán ena su cuinati putsu, anipetutiana chu maje. Dapia Juan Bautista ja yahui neje cristiano cuana ichaderapirutana eti jude su putiana. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Dueji cristiano cuana putitana tu peje su. Uja jaquisatitana huecuana: —Enei hue, Juan ja aimue ai nimetiuda cuana a biame, tu quisa puana Jesús jepuiti beju butsepi. ");
INSERT INTO tnaNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Da su dueji dapia eti jude su aniji cuana Jesús peje su jei putana. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Beju piada deja nedaji anina Lázaro banime. Betania ejude su anina. María, Marta detse sa edue puina. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Tueda María ja equene puida Jesús sa ehuatsi bia su d'uichatana. Mesa echuaina neje ehuatsi muriatana. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Da su betana edue epuna detse ja Jesús peje su deja cuana beitutana tu equisa puji. Uja Jesús quisametana tse: —Echua Puji, mique ibuneda eshanapa beju nedaji esa. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesús ja id'aba putsu, uja puana: —Aimue tueda emanu mahue. Tueda da nedaji puana Diusu da aida, tucheda cristiano cuana ebame puji. Tueda neda jepuiti ya di tucheda ebameti. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6","Beju nedaji jepuiti equisatani huecuana biame, Jesús da beta tsine anibana. Lázaro, tusa beta edue epuna neje, ebia su ibuneda batana biame, beta tsine anibana. Mue da hora su puti Lázaro peje su. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Beta tsine jaitianana su, Jesús ja mesa discípulo cuana, “Meputija neicha Judea yahua su Lázaro esa su”, atana. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Da su discípulo cuana ja tueda atana uja: —Ebuetsuaji, quetsunu hue mi judío cuana ja dapia yahua su manuameja adhaatana tumu neje. Daja biame, mi neicha putija dapia epuani. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Da su Jesús ja atana huecuana: —Beju piada tunca beta ejaitiana hora tsine sa yani. Ahua etse tsine su yaseni su, aimue etse ehuatsitud'itiani mahue, hueda yani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ahua etse dhidha su yaseni su, beju etse jahuatsitud'iti cua, hueda aimue putsu. Da su, be ai piba biame mepuji. Aimue ema cuaja biame yata huecuana mahue, quema manu hora cuinaji mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Neicha Jesús ja atana huecuana: —Ecuana sa eshanapa Lázaro mu etahuisa. Yama da eid'edeatiyu. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Da su discípulo cuana ja Jesús uja atana: —Echua Puji, ahua ene etahuisa su da, esaisiyu. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Daja Jesús ja discípulo cuana quisatana, Lázaro manuana shanapatana biame. Da su Lázaro etahuisa pepe hue putana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Da putsu, Jesús ja neicha butsepi quisatana huecuana: —Lázaro beju manuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Saida hue micuaneseda puji ema dapia mue ani puana, beju micuaneda ema peje su ebia su jei epu putsu. Meputija Lázaro eba puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Da su beju pere Tomás ja pia discípulo cuana uja atana: —Beju ecuaneda di tu neje meputija tu neje tupupai memaracata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesús Betania ejude su cuinati putsu, Lázaro pushi tsine sepulcro su huananubiajiji beju puina. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania ejude beta kilómetro edusete uquedame Jerusalén ejude naja su anina. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Da putsu, puetana jucuada judío cuana Jerusalén ejude jenetia María, Marta detse epacienciabaja puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta ja Jesús ecuinahu shanapa putsu, cuinanana tu emitsu puji. María mu ete su aniana. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta ja Jesús mitsu putsu, uja atana: —Echua Puji, mi upia ani su mu, aimue detse quema edue manu cua puina mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Beju daja puana biame, bahue ema Diusu ja pamapa mi ebaja cuana etiata. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús ja Marta uja atana: —Mique edue neicha eid'eyu beju. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Da su Marta ja Jesús uja atana: —Ehe, beju pamapa epupe su, manujiji cuana enetianata su, da tsine su quema edue di enetianayu beju ema bahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Da su Jesús ja Marta uja atana: —Ema da manujiji cuana eid'e ameji. Quebata ema peje su jei epuani su, emanu biame, beju neicha eid'eyu. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Pamapa eid'e ema peje su jei eputani cuana di, manu putsu, aimue emanuenita huecuana mahue. ¿A mi ye quema mimi su jei epuani? ");
INSERT INTO tnaNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Da su Marta ja jeutsutana: —Ehe, Echua Puji, mida da Diusu sa Ebacua. Mida da Diusu sa Jabeituti Deja ecuanaju beju id'uaitia, ema jei epuani. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta daja mimipe putsu, María ihuatitana. Etsia quisa neje, “Ebuetsuaji beju cuinaitia. Eihuametani mi”, Marta ja María quisatana. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","María ja id'aba putsu, beju cuinanana Jesús ebati puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús da ejude tsahua su hue tsuhu netiana, Marta ja netiajusiatana su hue. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Beju judío cuana mu ete su anitana María, Marta detse epacienciabaja puji. María tipeida cuinanana batana huecuana. Tueda sepulcro su epadariti puji epuhu pepe putana huecuana putsu, tije atitana huecuana tu neje epadariti puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Da su María beju Jesús eneti su cuinatiana su, tu butse su tururuana. Uja atana Jesús: —Echua Puji, mi upia ani su mu, aimue detse quema edue manu cua puina mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesús ja María, judío cuana neje pamapa su epatani ba putsu, echucuata jatacuamadhatiana. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Da su Jesús ja quisabatana huecuana: —¿Quepia Lázaro huananubiajiji esa? Uja jeutsutana huecuana: —Echua Puji, pueque eba puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Da su beju Jesús pana. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Judío cuana ja Jesús epani ba putsu, uja jaquisatitana huecuana: —Mechamaque cuaja ebia su ibuneda bataina Lázaro. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pia cuana ja mu uja atana: —Tuahueda padha cuana tuaji aji putsu, ¿jucuaja su ni da mue ai biame a atana mahue Lázaro emanu mahue puji? ");
INSERT INTO tnaNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús da neicha jatacuamadhatiana, sepulcro su enariatiani je. Tueda sepulcro murucu epa su anina. Tumu aida neje terijiji puina. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesús ja uja atana huecuana: —Mejemique tumu. Da su Marta ja atana: —Echua Puji, beju jia madhada hue huanime, pushi tsine manujiji putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús ja Marta uja jeutsutana: —Beju yama mi quisaitia Diusu da ebia su tucheda miada eba, ahua mida ema peje su jei epu su. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Da su tumu aida jemideratana huecuana su, Jesús buepa huabata pu putsu, uja Diusu atana: —Tata, yama mi diusulupai yainia, miada ema eid'abainia putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Pamapa quema jabajati cuana miada ema etiainia bahue ema. Beju ye upia cristiano cuana butse su jiahue quita yama mi ebajainia miada ema beituana pashanapata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Daja Diusu mitsupe putsu, Jesús jubida tsiatsiana uja: —¡Lázaro, cuinanaque! ");
INSERT INTO tnaNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Da hora su beju manujiji cuinanana sepulcro jenetia. Tusa eme, ehuatsi detse dhiri ped'u bauda neje babujiji puina. Tusa echua di babujiji puina. Pamapa tusa equita da babujiji puina beju. Da su Jesús ja cuatsasiatana huecuana: —Mepidhuque tu eputiyu puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Daja ba putsu, dueji María neje putitana judío cuana da Jesús peje su jei putana. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Tuna duju su piada piada mu Jerusalén ejude su putitana Jesús ja daja atana fariseo cuana equisati puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Da su beju fariseo, sacerdote huaraji aida cuana jadhitatitana. Uja jaquisatitana huecuana: —¿Cuaja jia ecuaneda epu? Ye deja ja jucuada ai nimetiuda aida cuana yatani. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ahua tueda daja hue epu su, pamapa cristiano cuana ja da tueda tije yatayu. Tueda echua puji ametayu cua huecuana. Aimue romano huaraji cuana ja tsada ebata mahue. Tuna sa soldado cuana ja ecuana sa templo etaitanamepeta. Ecuaneda di emanuamepetayu huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Beju piada sacerdote Caifás banime dapia anina. Tueda da pamapa sacerdote sa echua puji puina tueda mara puji. Tuahueda uja atana huecuana: —Micuaneda mu ai biame bue mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ebia su saida tueda deja Jesús pamanu ecuaneda emanu mahue puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Beju Diusu ja Caifás daja mimiametana, Jesús da judío cristiano cuana jepuiti emanu putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Aimue judío cuana jepuiti bahui tueda emanu mahue. Pamapa pia Diusu sa dharejiji cuana sa puji di pamapa yahua je manu taji puina tu neje edunemeta huecuana puji. Daja Diusu ja Caifás mimiametana, tueda da sacerdote ebia su aida puina putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Da su da tsine jenetia judío cuana sa huaraji aida cuana jaquisatitana cuaja Jesús manuameme ya puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Da putsu beju, Jesús aimue cristiano cuana duju je puniunetiana mahue. Beju Judea yahua jenetia cuinanana. Efraín ejude banime su putiana. Tueda ejude da d'anita yahua naja su anina. Dapia beju quejucua tsine puji anitiana mesa discípulo cuana neje. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Judío cuana sa pascua tsine beju enariatiani su, dueji cristiano cuana pamapa pia yahua cuana jenetia Jerusalén ejude su putitana. Tsine cuinatiji mahue su hue, Jerusalén su putitana huecuana erucuati puji, Diusu butse su saida epu puji, daja tuna sa jacuatsasiati putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Pamapa ejude je Jesús quisabaniunetiatana huecuana. Templo su cuinati putsu, uja jaquisatitana huecuana: —¿Cuaja jia ahua Jesús tsine puji epue, ahua mahue? ");
INSERT INTO tnaNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Fariseo, sacerdote huaraji aida cuana ja cuatsasiatana cristiano cuana, ahua Jesús quepia ebainia je quisa paputa huecuana puji. Daja atana huecuana, tu inaja putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Beju sucuta tsine yani hue pascua tsine puji Jesús da Lázaro sa ete su Betania ejude su putiana. Tueda Lázaro da Jesús ja equene id'emetaibana. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Dapia jana atana huecuana Jesús sa puji. Lázaro di tu neje diadiana. Marta ja jana derutana. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Da su beju mesa edue María ja litro edusete chujeneda saida puida dusetana. Tueda puida nardo banime puina. Duse putsu, Jesús sa ehuatsi bia su d'uichatana. Da su muriatana mesa echuaina neje. Ehuani neje ete sejeatana. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Beju Judas Iscariote di dapia anina. Jesús sa piada discípulo puina. Tueda quitaita ja Jesús emenajatiata puina. Tuahueda María ja daja yatani ba putsu, uja puana: ");
INSERT INTO tnaNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Tueda puida da piada mara pucue mudu chuje tupu. ¿Jucuaja su ni da aimue ecuaneda iruitia mahue puri cuana etsahua puji? ");
INSERT INTO tnaNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Beju Judas ja aimue puri cuana ibunebatana mahue. Tsi puji bahui da tueda puina. Discípulo cuana sa chipilu quinaji puina putsu, chipilu shitara su tsi bahue puina. Da putsu, Judas daja puana. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Da su beju Jesús ja Judas atana: —Be daja puji. María ja quema manu tsine cuinaji mahue su, ema puida neje papitana. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Puri cuana da micuana neje pamapa hora su yanita. Ai hora papu micuaneseda tsada su, tsahua cua huecuana. Ema mu aimue micuana neje daja yani mahue. Quejucua tiempo chidi hue ema micuana neje yaniti. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Beju dueji judío cuana ja Jesús Betania ejude su yani shanapapirutana. Da su tueda ejude su beju putitana huecuana Jesús ebati puji. Lázaro di ebati puji putitana huecuana, tueda id'eibana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Sacerdote huaraji aida cuana ja Lázaro di manuameja adhaatana, tu id'eibana jepuiti, dueji cristiano cuana Jesús peje su jei putana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Cristiano cuana sacerdote cuana peje jenetia netideratasaina Jesús tije ya puji. Da putsu, sacerdote cuana ja Lázaro di manuameja atana. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Dueji cristiano cuana Jerusalén su putitana pascua tsine ebati puji. Pia huenati su bahue putana huecuana Jesús Jerusalén ejude su enubi. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Da su beju tumi ina nime eina cuana dheutana huecuana. Da neje ejude tsahua su putitana huecuana Jesús etsu puji. Jesús ba putsu, tsiatsiapirutana huecuana uja: —¡Gloria, Tata Diusu sa Jabeituti Deja epusiu! ¡Diusu sa ebani su tueda epusiu! ¡Diusu ja tueda paibunebata! ¡Tueda da israelita cuana sa Echua Puji! ¡Gloria Tata Diusu! ");
INSERT INTO tnaNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Da su beju Jesús ja asunu chidi bianitana, cuaja Diusu sa quirica su derejiji yani batame. Uja derejiji yani: ");
INSERT INTO tnaNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Be iyuame mepuji Jerusalén ejude su aniji cristiano cuana. Mechamaque micuana sa Echua Puji epusiu asunu bia je.” ");
INSERT INTO tnaNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Beju discípulo cuana ja tueda mimi mue shanapa cuaja epuani. Jesús cielo su putibana su, da su chu beju shanapaenitana huecuana cuaja epuani tueda derejiji mimi cuana. Daja Jesús sa pu taji puina Jerusalén ejude su, Diusu sa quirica su daja derejiji putsu, shanapatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Equene Lázaro id'eibana batana cuana ja pia cristiano cuana ejude su butsepi pamapa quisatana. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Da putsu, pamapa su ejude jenetia cuinanatana Jesús etsu puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Da su fariseo cuana tuneda cama jaquisatitana uja: —Mebaque hue, pamapa cristiano cuana tu tije epuhu. ¿Cuaja ni ecuaneda a cua? ");
INSERT INTO tnaNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Beju dapia Jerusalén ejude su piada piada extranjero cuana Grecia yahua jenetia anitaina pascua tsine eba puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ye cuana ja da Felipe nariatana. Uja atana huecuana: —Tata, Jesús baja ecuanaju. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Da su Felipe ja Andrés quisatitana. Tuatseda Jesús quisatitana cuaja extranjero cuana putana. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Da su Jesús ja id'aba putsu, uja atana: —Beju quema manu hora enariatiani. Manu putsu, ema neicha eid'eyu. Cristiano cuana ema ba putsu, ema pamapa pia cuana ebia su tucheda eni eshanapata huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Yama micuana butsepi equisainia, quema manu da piada trigo ejaja yahua su papaicha cua nime. Ahua ejaja yahua su mue dajaja su, ahua med'i neje mue biapapa su, da su piada hue yaniti. Beju ahua yahua su papajiji su, jucuada ejaja cuana ehuiruti. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Quebata ja Diusu jei aja mahue yata su, aimue tueda Diusu neje cielo su eid'e epueniti mahue. Quebata ja mu emanu teje Diusu jei yata su, tueda saida Diusu neje cielo su eid'e epueniti. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Quebata ja ema mebajaja yata su, ema tije paata. Beju quepia ema yani su dapia da ema neje quema emebajaji cuana paanitita. Quebata ja ema emebajatani, quema Tata Diusu ja tueda saida echuje etiatayu. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","‘Beju jiahue mu ema ebia su etacuamadhatiani. ¿Ai yama, “Tata Diusu, d'eji su ema aque ye sufrimiento epusiu jenetia”, ebaja bata? Aimue daja yama quema Tata ebaja mahue, ema emanu puji pueana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Da su Jesús ja mesa Tata Diusu uja atana: —Tata, cristiano cuana bameque mida da ebia su aida, tucheda eni. Jesús beju daja mimipeana su, Tata Diusu ja cielo jenetia uja atana: —Beju yama quema tucheda bameana. Neicha yama daja yayu. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Dapia eneti cristiano cuana ja Diusu sa etsui id'aba putsu, piada piada, “Etiriani beju”, putana. Pia cuana mu, “Angel ja tueda quisatana”, putana. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Da su Jesús ja atana huecuana: —Tueda etsui da mimiana micuana sa saida equisa puji. Aimue quema puji mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Tiempo cuinaitia beju Diusu ja ye mundo su aniji cuana ejuzga puji. Cristiano madhada cuana sa echua puji Ishahua ejusiata beju. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Yama dueji cristiano cuana ema peje su jei yameyu, judío cuana ja curusu su ema ejemitsuata su. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Tueda mimi neje Jesús ja cristiano cuana cuaja tueda emanu shanapametana. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Da su cristiano cuana ja Jesús uja atana: —Beju ecuana sa jacuatsasiati quirica cuana su, “Diusu sa Jabeituti Deja da eid'e epueni. Aimue emanu mahue”, derejiji yani. Da su, ¿jucuaja su mida, “Diusu sa Jabeituti Deja curusu su ejemitsuatayu”, epuani? ¿Aidhe da ye Diusu sa Jabeituti Deja? ");
INSERT INTO tnaNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Da su Jesús ja jeutsutana huecuana: —Ema da hueda nime. Quejucua tsine hue micuana neje ema yaniti micuana Diusu sa jabuetsuati cuana ebuetsua puji. Jei mepuque ema peje su, micuana neje ema yani tupu, micuaneda matsejiji epu mahue puji. Be apuda su puniunetiji cuana nime mepuji. Tuneda da castigo su eputita. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ema da hueda nime. Jei ema meaque, ema micuana neje yani tupu. Jei ema peje su pu putsu, micuaneda hueda su epuniunetiani cristiano cuana nime epu, Diusu sa ebacua cuana micuaneda epu. Beju mimipe putsu, Jesús da cristiano cuana peje jenetia putiana tu mehua yaniti puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesús da jucuada ai nimetiuda aida cuana atana biame, judío cuana tu peje su jei puja mahue putana. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Tuna jepuiti Diusu sa profeta Isaías chenu ja quirica su uja deretaidha: Diusu, aimue aiya biame ecuanaju sa mi jepuiti quisa su jei putana mahue. Miada mique tucheda bameana biame, aimue jei puja putana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Beju cuaja jei a taji mahue batana huecuana. Uja Isaías chenu ja deretaidha neicha: ");
INSERT INTO tnaNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Diusu ja padha nime, nimetadada ametana huecuana jei paputa mahue huecuana puji. Daja Diusu ja atana huecuana aimue pabatita, pashanapatita mahue puji, daja huecha be pasiapatita Diusu peje su tuahueda pasaisiameta huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Jesús ye mundo su pueji mahue su, Isaías ja tueda tucheda eni shanapataidha. Da putsu, daja Isaías chenu ja Jesús jepuiti deretaidha. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Beju daja biame, jucuada judío cuana Jesús peje su jei putana. Piada piada ehuidusuji cuana di tu peje su jei putana. Cuatsa mahue jei putana huecuana, fariseo cuana ebia su iyuda putsu. Quisa puja mahue putana huecuana, Jesús peje su jei putana jepuiti, cuapuitime fariseo cuana ja jadhitati ete su mue nubiame ata cua huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Diusu ebia su fariseo cuana iyubatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Da su beju Jesús ja uja jubida quisatana cristiano cuana: —Aidhe de ema peje su jei epuani, tueda da ema beituji peje su di jei epuani. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Aiya da ema ebatani, daja huecha ema beituji di ebatani. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ema da hueda nime. Quebata ema peje su jei epu, aimue apuda su epuniunetitani cuana nime epu mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","48","Mue ema ye mundo su pue cristiano cuana ematse puji mahue. Beju yama pueana cristiano cuana d'eji su ya puji. Ahua aiya quema quisa cuana mue aja mahue yata su, Diusu ja tueda ematsetayu. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Aimue ema quema piba cuana emimiani mahue. Tata Diusu ja ema cuatsasiatana ai cuana bahui yama equisainia. ");
INSERT INTO tnaNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Bahue ema ahua cristiano cuana quema Tata sa jabuetsuati cuana jei yata su, cielo su eid'e epuenitayu huecuana. Da putsu, quema Tata ja ema equisatani cuana bahui yama ebuetsuainia. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Beju piada tsine hue anina pascua tsine puji. Jesús bahue puana mesa manu hora beju janariatiana mesa Tata peje su eputi puji. Mesa dharejiji cuana ye mundo su yani ebia su ibuneda batana mesa manu teje. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesús mesa discípulo cuana neje ediadiani cama, Ishahua ja Judas Iscariote ja Jesús pamenajatiata puji pibametana. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús quitaita bahue puana tueda Diusu peje jenetia pueana. Daja huecha Diusu peje su esiapatiyu. Diusu ja tueda pamapa pia huaraji cuana ebia su aida, tucheda atana, Jesús bahue puana. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Da su misha jenetia netianana. Mesa ebia jud'uji huijatana. Paño neje jatimairisitiana. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Emeji su yahui icha putsu, discípulo cuana sa ehuatsi rucua barereatana. Daja a putsu, paño neje ehuatsi muriatana. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jesús ja Simón Pedro sa ehuatsi rucuaja atana su, Pedro ja uja atana: —Echua Puji, ¿a da miada quema ehuatsi erucua? ");
INSERT INTO tnaNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús ja Pedro jeutsutana: —Beju jiahue aimue miada eshanapainia mahue cuaja yama yainia. Pia tsine chu da miada eshanapa. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Beju Pedro ja Jesús atana: —Aimue miada quema ehuatsi erucua mahue, mida da quema Echua Puji putsu. Da su Jesús ja Pedro atana: —Ahua mique ehuatsi yama erucua mahue su, aimue miqueda ema neje ai biame a taji mahue beju. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Da su Pedro ja Jesús uja atana: —Echua Puji, ahua daja su, quema eme, echua di rucuaque. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesús ja tueda atana: —Quebata nahuijiji sa mu ehuatsi bahui neicha rucua taji, equita pamapa saida rucuajiji putsu. Diusu ja jucha dhipajiji cuana da rucuajiji cuana nime. Micuaneda mu saida, rucuajiji nime beju. Daja biame, aimue micuaneda pamapa su saida, rucuajiji nime mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Daja Jesús puana, Judas ja tueda emenajatiata bahue puana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Tuna sa ehuatsi Jesús ja rucuape putsu, mesa ebia jud'uji jajud'utibana. Beju neicha misha su aniutetiyu putsu, uja discípulo cuana atana: —¿Ahua eshanapainia micuaneda cuaja yama micuana aitia? ");
INSERT INTO tnaNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Beju micuaneda ema, Ebuetsuaji, Echua Puji, yainia. Enei hue, daja da ema. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Beju ema da micuana sa Ebuetsuaji, Echua Puji biame, micuana sa ehuatsi yama rucuaitia emebajaji pu cua nime. Da su micuaneda cama di huamahuama micuana sa jamebajati taji. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Daja yama micuana aitia micuaneda cama di memebajatique puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ene putsu, yama micuana equisainia, emebajaji da aimue mesa emetse ebia su aida pu cua mahue. Daja huecha beitujiji da aimue tu beituji ebia su aida pu cua mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ahua micuaneda ye quema quisa cuana ya su, beju micuaneda beidaji epu. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","‘Quema jadhareti cuana yama eshanapainia. Beju piada ja micuaneda ema emenajatia, cuaja uja Diusu sa quirica su derejiji yani batame: “Ema neje diadia bahue epu, tueda ema neje madhada hue netianana.” ");
INSERT INTO tnaNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Jiahue yama micuana ye ai cuana equisainia, daja puji mahue su. Beju daja epu su, micuaneda ye yama equisainia epiba. Piba putsu, micuaneda ema peje su jei epu. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ahua quebata ja quema jabeituti saida ebatsuta su, tuahueda ema saida ebatsutani pu cua nime. Daja huecha ahua quebata ja ema saida ebatsuta su, tuahueda ema beituji di saida ebatsutani pu cua nime. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesús daja mimipe putsu, echucuata jatacuamadhapirutiana. Uja atana huecuana: —Ene putsu, yama micuana equisainia, piada ja micuaneda ema emenajatia deja madhada cuana peje su. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Da su discípulo cuana tuneda cama jachamapirutitana. Quebata jia da pu cua tuna duju su shanapaja atana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Beju Jesús ja ibuneda bataina discípulo da Jesús naja su anina. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Tueda discípulo da Simón Pedro ja seña neje shanapametana Jesús paquisabata puji uja: “¿Aiya mi emenajatiata?” ");
INSERT INTO tnaNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Da su Jesús peje su janariaderati putsu, uja quisabatana: —Echua Puji, ¿aidhe da? ");
INSERT INTO tnaNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús ja jeutsutana: —Pan ped'u beju yama etsabia. Quebata yama etia, tueda da. Da su Jesús ja pan ped'u tsabiatana. Tsabia putsu, Judas Iscariote tiatana. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas ja pan ped'u einatsutani cama, Ishahua ja tueda madhada pibametana. Da su Jesús ja Judas atana: —Mi aja yainia, tipeida atique beju. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Mue quebata pia discípulo cuana ja biame shanapa atana cuaja Jesús ja Judas daja cuatsasiatana. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas chipilu quinaji puana putsu, discípulo cuana ja Jesús ja Judas ebeitutani ba putsu, tsine puji ai chidi ebajati puji pepe putana huecuana, ahua chipilu puri cuana etiati puji pepe putana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Da su Judas ja pan ped'u inatsu putsu, cuinanana. Beju apuda puina. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas cuinanana su, Jesús ja pia discípulo cuana uja atana: —Beju jiahue da cristiano cuana ja ema ebia su tucheda ebata, Tata Diusu sa tucheda quema yani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Diusu ja ema mesa tucheda tia putsu, pamapa ja ebata. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Edue cuana, quejucua hora puji hue ema micuana neje yani. Micuaneseda puji mu cuaja puti taji mahue ema eputi su. Cuaja yama judío cuana sa ehuidusuji cuana quisana nime, daja yama micuana jiahue quita equisainia. Micuaneda da ema echacu biame, ema yani su micuaneda cuaja puti taji mahue ebati. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Beju jiahue yama micuana pia jacuatsasiati eichacua etiainia: Ibuneda mebatique micuaneda cama huamahuama. Cuaja yama micuana ibuneda ebainia nime, daja huecha micuaneda cama huamahuama ibuneda mebatique. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ahua micuaneda daja huamahuama ibuneda ebati su, pamapa cristiano cuana ja micuaneda da quema ebuqueji cuana eshanapata. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro ja Jesús uja quisabatana: —Echua Puji, ¿quepia mi epuhu? Jesús ja jeutsutana: —Quepia ema epuhu su aimue mida jiahue ema ebuque mahue. Pia tsine chu mida ema ebuque. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Da su Pedro ja Jesús atana: —Echua Puji, ¿jucuaja su ni mi yama aimue buque cua mahue? Jiahue quita ema manu cua mi jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Da su Jesús ja Pedro jeutsutana uja: —¿A da ene mida manu cua ema jepuiti? Yama mi butsepi equisainia, huaripa deja queiji mahue su, mida, “Aimue yama Jesús shanapa”, quimisha nuati epu. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","‘Be ebia su mepibajucuatiji. Cuaja micuaneda Diusu peje su enimetucheatiani nime, daja huecha ema peje su di menimetucheatique. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Beju cielo su quema Tata Diusu sa jucuada ani jude cuana yani. Yama micuana butsepi equisainia. Aimue ema bid'umimi epuani mahue. Ema da eputi ani jude micuaneseda ebasetati puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Beju ani jude basetati putsu, ema esiapati micuana edusu puji, dapia micuaneda ema neje yanieniti puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Beju micuaneda eshanapainia quepia ema eputi; daja huecha cuaja ema eputi. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Da su Tomás ja Jesús atana: —Echua Puji, mue ecuanaju shanapa quepia mi eputi. Bue mahue ecuanaju cuaja mi eputi. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús ja jeutsutana: —Ema da Diusu peje su epuhu edid'i nime. Ema ene quita, butsepi emimiani. Ema jepuiti cristiano cuana eid'e epuenitayu. Ema peje su jei pu putsu bahui, cristiano cuana Tata Diusu peje su cuinatita cua. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ahua ene quita micuaneda aidhe ema eshanapainia su, quema Tata di micuaneda shanapa cua. Beju micuaneda Tata Diusu eshanapaeninia, ema bana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Da su Felipe ja Jesús atana: —Echua Puji, bameque ecuanaju Tata Diusu. Tueda beju ecuanaju sa tupu. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús ja Felipe jeutsutana: —Felipe, dajucua tiempo micuana neje ema yani biame, ¿mue miada ema shanapa tsuhu? Quebata ja ema batana, tuahueda Tata Diusu di batana. Da su, ¿ai puji ni miada ema ebajainia yama micuana Tata Diusu ebame puji? ");
INSERT INTO tnaNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Aimue mida jei epuani mahue ema Diusu neje piada hue epuani? Beju yama micuana quisana cuana da aimue quema piba jenetia mahue. Tueda mu Tata Diusu sa piba jenetia bahui. Tata Diusu ema neje yani putsu, mesa ai tsada cuana yatani ema jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Jei ema meaque, ema Diusu neje beju piada hue epuani. Ahua aimue micuaneda quema mimi cuana su jei puja mahue su, da su yama yainia nimetiuda ai cuana jepuiti dhucuana ema peje su jei mepuque. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ene putsu, yama micuana equisainia, quebata ema peje su jei epuani, tuahueda di yama ai cuana ana nime yatayu. Beju ebia su aida ai nimetiuda cuana yatayu, ema Tata Diusu peje su eputi putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ahua micuaneda quema tsada epuani cuana ebaja su, beju yama etiayu cristiano cuana ema aida pabata puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yama micuana sa jabajati cuana yayu, ahua micuaneda quema ai tsada cuana ya su. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","‘Ahua micuaneda ema ibuneda ebainia su, quema jacuatsasiati cuana meaque. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Yama quema Tata Diusu ebajati pia Etsahuaji micuana peje su pabeituta puji, micuana neje paanieniti puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Tueda da Espíritu Santo banime. Tuahueda Diusu sa ene quita jabuetsuati cuana micuana ebuetsuata. Diusu tsada mahue cristiano cuana ja aimue tueda batsuta cua mahue, aimue tueda eshanapatani mahue huecuana putsu. Beju micuaneda mu tueda eshanapainia, micuana neje yani putsu. Micuana neje tueda yanienitiyu. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Aimue yama micuana emesia mahue, micuana peje su ema esiapatiyu putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Quejucua hora jenetia beju Diusu tsada mahue cristiano cuana ja aimue ema ebata mahue. Micuaneda mu ema eba. Ema da eid'e epueni putsu, micuaneda di eid'e epueniyu. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Espíritu Santo micuana peje su ecuina su, da hora su micuaneda bahue epueniyu ema Tata Diusu neje beju piada hue epuani. Daja huecha micuaneda di ema neje piada hue epuani micuaneda bahue epueni. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Quebata ja ema ibuneda ebatani, tuahueda quema jacuatsasiati cuana yapetayu. Ema ibuneda baji cuana quema Tata ja ibuneda ebata. Yama di ibuneda eba huecuana. Ema eshanapameeni huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Da su beju pia discípulo Judas banime Iscariote mahue ja Jesús quisabatana uja: —Echua Puji, ¿jucuaja su mida ecuanaju peje su bahui eshanapameeniti, pia cuana peje su mu mahue? ");
INSERT INTO tnaNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Da su Jesús ja jeutsutana: —Quebata ja ema ibuneda ebatani, tuahueda quema jacuatsasiati cuana yapetayu. Beju quema Tata ja tueda ibuneda ebata. Ema, quema Tata tu neje yanienitiyu. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Quebata ja ema mue ibuneda ebatani mahue, tuahueda quema jacuatsasiati cuana aimue aja yata mahue. Beju ye yama equisainia cuana da ema beituji Tata sa quisa cuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","‘Jiahue micuana neje ema yani tupu, yama tueda ai cuana micuana equisainia. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ema micuana neje aimue beju su, Tata Diusu neje etseju Espíritu Santo ebeitu tuahueda beidaji meametaque, metsahuataque puji. Tuahueda pamapa ema jepuiti ai cuana micuana ebuetsuata. Daja huecha pamapa yama micuana quisana cuana epibameta. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","‘Beju micuana yama nimepijajajiji eichajusiayu. Yama micuana enimepijajameinia. Diusu peje su jei puja mahue cristiano cuana aimue nimepijajata cua mahue. Yama bahui detse ene quita nimepijajame cua. Be metacuamadhatiji. Be iyuame mepuji. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Beju micuaneda ema eputiyu id'abaitia. Ema esiapatiyu micuana neje neicha yani puji id'abaitia. Ahua micuaneda ene ema ibuneda ebainia su, beidaji micuaneda epu, ema Tata Diusu peje su eputi putsu, tueda ema ebia su aida putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Jiahue ema putiji mahue su, yama micuana ye ai cuana equisainia. Beju ema eputi su, micuaneda ye yama equisainia ai cuana epiba. Piba putsu, micuaneda ema peje su jei epu. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","‘Beju ema Ishahua ja enariatasiu. Tueda da Diusu tsada mahue cuana sa echua puji. Da putsu, aimue quema tiempo yani mahue micuana neje equisati puji. Beju daja biame, aimue Ishahua ema ebia su tucheda mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pamapa quema Tata ja ema cuatsasiatana cuana daja yama yainia Diusu tsada mahue cristiano cuana ja yama Diusu ibuneda ebainia pashanapata puji. Tusa ai cuana bahui yama yainia pashanapata huecuana puji. Beju menetianaque. Meputija. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesús ja cristiano cuana daja hue quisainiame atana: —Ema da uva equi nime. Quema Tata Diusu da uva equi quinaji nime. Ema peje su jei eputani cuana da echa chidi cuana nime. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Uva quinaji ja echa cuana ejaja pu bue mahue echadheutani jajaji paputa puji. Daja huecha quema Tata Diusu ja ema peje su jei eputani cuana ebuetsuatani tu butse su saida, nimebutsepi papuniuneti huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Beju micuaneda da nimebutsepi, quema jabuetsuati cuana jei ana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Cuaja micuaneda ema neje dunejiji yani nime, daja hue ema neje dunejiji anime mepuque. Piada echa bahui aimue detse jajaji pu cua mahue. Echa da equi mahue su, aimue detse jajaji pu cua mahue. Daja huecha micuaneda cuaja nimbebutsepi pu taji mahue, ahua ema neje dunejiji mahue su. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","‘Ema da equi nime. Micuaneda da echa cuana nime. Quebata da ema neje daja hue dunejiji anime epuani, tuahueda jucuada ai saida cuana Diusu sa puji yata. Ahua aimue micuaneda daja hue ema neje dunejiji mahue su, aimue ai saida cuana Diusu sa puji a cua mahue, micuana mehua putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Quebata da aimue ema neje dunejiji yani mahue, tueda da echa sarajiji nime. Beju jusiaderajiji epu. Cuati su ed'ed'a puji bahui saida. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","‘Ahua micuaneda ema neje daja hue dunejiji anime epu su, ahua quema jabuetsuati cuana daja hue aniame ya su, da su Diusu ja micuana sa jabajati ai cuana etiatayu. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Beju Diusu sa tsada micuaneda ai saida cuana ya. Ahua micuaneda daja ya su, quema ene quita ebuqueji cuana epu. Quema Tata Diusu sa tucheda cristiano cuana ebame. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Yama micuana ibuneda ebainia, cuaja quema Tata ja ema ibuneda ebatani nime. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tueda ibuneda neje meanique. Ahua micuaneda quema jacuatsasiati cuana yainia su, daja micuaneda tueda ibuneda neje yaniti. Daja quema Tata sa ibuneda neje ema yani, yama tusa jacuatsasiati cuana yapeinia putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","‘Daja yama micuana quisana micuaneda ema neje ebia su beidaji epu puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yama micuana ecuatsasiainia uja: Ibuneda mebatique huamahuama, cuaja yama micuana ibuneda ebainia nime. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ahua etse mesa eshanapa cuana ebia su ibuneda ebainia su, tuna sa eturuca etse manu cua. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ahua micuaneda quema jacuatsasiati cuana yape su, beju quema eshanapa cuana epu. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Aimue micuana yama emebajaji cuana nime ebainia mahue. Emetse ja mesa emebajaji cuana aimue pamapa mesa piba cuana equisatani mahue. Yama mu pamapa quema Tata ja ema ai quisatana cuana micuana quisapeana, micuaneda da quema eshanapa cuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Aimue micuaneda ema dhareana mahue. Beju yama mu micuana dhareana. Yama micuana huaratiana micuaneda ai saida eni cuana ya puji. Da su Tata Diusu ja pamapa micuana sa jabajati cuana micuana etiatayu, ahua micuaneda quema tsada epuani cuana ebaja su. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Neicha yama micuana ecuatsasiainia: Huamahuama ibuneda mebatique. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","‘Ahua Diusu tsada mahue cristiano cuana ja micuana eduininibata su, mepibatique ema equene duininibatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ahua micuaneda da Diusu tsada mahue cuana pu cua su, da su micuana ibuneda bata cua huecuana, tuna nime micuaneda tupupai pu cua su. Beju yama micuana dhareana Diusu tsada mahue cristiano cuana duju jenetia. Da putsu, micuana eduininibatani huecuana, aimue micuaneda tuna nime mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mepibaenique quema jaquisati cuana: “Emebajaji da aimue mesa emetse ebia su aida pu cua mahue.” Quebata cuana ja quema jabuetsuati cuana jei yatani, daja huecha micuana sa jabuetsuati cuana di jei yata huecuana. Ema nedaneda ameji cuana ja daja huecha micuaneda di nedaneda yametayu. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Daja madhada hue micuana yata huecuana, micuaneda da quema dharejiji putsu, aimue ema beituji Tata eshanapatani mahue huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","‘Ahua ema tuna equisa puji mue pue pu cua puana su, aimue detse tuneda juchaji puta cua puina mahue. Beju tuneda mu juchaji, yama equisainia huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Quebata ema eduininibatani, tuahueda quema Tata di eduininibatani. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ahua yama tuna duju su ai nimetiuda aida cuana ana mahue pu cua su, aimue tuneda juchaji puta cua puina mahue. Mue aiya biame daja nimetiuda aida cuana yama yainia nime atana mahue. Quema ai nimetiuda aida cuana batana huecuana biame, ema eduininibatani huecuana. Quema Tata neje di eduininibatani huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Tuna sa jacuatsasiati quitaita su uja derejiji yani: “Tuneda ema duininibatana, ema jucha mahue biame.” ");
INSERT INTO tnaNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","‘Beju yama Espíritu Santo Etsahuaji micuana peje su ebeitu. Tuahueda micuana Diusu sa ene quita, butsepi jabuetsuati cuana eshanapametayu. Micuana etsahuata, enimetucheameta. Tueda Diusu peje jenetia micuana peje su ecuinati. Tueda ema jepuiti saida quisa enetiacuinatayu. ");
INSERT INTO tnaNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Micuaneda di ema jepuiti saida quisa enetiacuinayu, ema neje equene jenetia aniana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","‘Daja yama micuana quisana micuana enimetucheame puji, ema peje su jei epuriji mahue puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Micuana duininibaji cuana ja jadhitati jude ete su menubique mahue yata. Diusu sa tsada yatani pepe eputani huecuana, micuana manuame putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Daja yatayu huecuana, Tata Diusu, ema mue shanapa putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Jiahue yama micuana tueda ai cuana equisainia. Beju tueda tiempo madhada ecuina su, micuaneda epiba yama tueda ai cuana butsepi quisana. ‘Ye chu beju yama micuana tueda ai cuana equisainia. Ema micuana neje yani putsu, aimue equene yama tueda ai cuana quisana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Quema Tata peje su ema puti hora beju enariatiani. Daja biame, mue quebata ja biame micuaneda ema uja quisaba: “¿Quepia mida eputi?” ");
INSERT INTO tnaNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Beju micuaneda ebia su epibapibani, yama micuana tueda ai cuana equisainia putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ene putsu, yama micuana butsepi yainia, ebia su saida micuaneseda puji ema eputi puji. Ahua ema eputi mahue su, aimue Espíritu Santo epue mahue micuana etsahua puji. Ahua ema eputi su, yama tueda ebeitu micuana peje su. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","11","Tueda epue su, cristiano cuana da juchaji eshanapameta, ema peje su aimue jei eputani huecuana mahue putsu. Beju aimue micuaneda ema eba mahue. Ema Tata Diusu peje su eputi putsu, cristiano cuana tu peje su butsepi pu cua, ahua ema peje su jei eputa huecuana su. Daja Espíritu Santo ja cristiano cuana eshanapametayu. Tueda epue su, ye mundo emetse Ishahua matsejiji cristiano cuana eshanapameta. Da putsu, Diusu ja pamapa ema peje su jei puja mahue cuana di ematsetayu. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","‘Beju pia ai quisa cuana yama micuana quisaja yainia. Aimue micuana equisa mahue, jiahue micuaneda cuaja shanapa taji mahue ebainia putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Espíritu Santo epue su, micuana pamapa Diusu sa ene quita jabuetsuati cuana butsepi eshanapametayu. Cuaja epu ai cuana micuana eshanapametayu. Tata Diusu sa jabuetsuati cuana bahui ebuetsuatayu. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Tueda quema puji saida emimi. Quema piba cuana micuana eshanapameenitayu. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Quema Tata Diusu da ema neje beju piada hue epuani. Pamapa tusa ai cuana da quea di epuani. Tuahueda micuana tueda ai cuana pamapa saida eshanapameenitayu. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","‘Quetsunu quita hue beju ema eputiyu. Aimue micuaneda ema eba mahue beju, Tata Diusu peje su ema eputi putsu. Quejucua tsine beju ejaitiana su, micuaneda ema neicha ebayu. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jesús daja mimipeana su, discípulo cuana huamahuama jaquisabatitana uja: —¿Jucuaja su da tueda, “Quetsunu quita hue ema eputiyu. Aimue micuaneda ema eba mahue. Quejucua tsine beju ejaitiana su da, micuaneda neicha ema ebayu, Tata Diusu peje su ema eputi putsu”, epuani? ");
INSERT INTO tnaNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Cuaja ni da epuani, “Quetsunu quita hue beju ema eputiyu”? Mue shanapa ecuaneda. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús jashanapatiana discípulo cuana ja tu quisabaja atana. Da su uja atana huecuana: —Micuaneda bahue puja quetsunu ema eputi. Daja huecha ema esiapati. Beju micuaneda mue shanapa. Da putsu, micuaneda daja huamahuama jaquisabatiana. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ene putsu, yama micuana equisainia, micuaneda ebia su pibapiba putsu, jubida epa, ema emanuameta huecuana su. Ema peje su jei puja mahue cristiano cuana mu beidaji eputa. Beju micuaneda ebia su epibapiba biame, beidaji epu, ema neicha hue bayu putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Tueda da epuna nedaji puja epuani su, enebatiani nime. Ebia su epibapibani, mesa cuina hora beju ecuinani putsu, ebia su mesa neda epuani putsu. Beju yanana chidi bataji epuani su, aimue epuna ja neda cuana epibatani mahue, yanana chidi jepuiti beju ebia su beidaji epuani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Daja huecha da micuaneda. Jiahue micuaneda ebia su epibapibani. Beju ema micuana peje su esiapatiyu su, beidaji ebia su micuaneda epu. Aiya biame detse micuana neicha ebia su pibapibametayu cua beju. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","‘Da tsine su aimue ema micuaneda ai cuana ebajayu mahue, Tata Diusu ja pamapa micuana sa jabajati cuana etiatayu putsu, ahua micuaneda quema tsada epuani cuana ebaja su. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Jiahue teje aimue micuaneda quema ai tsada cuana Diusu bajaji mahue. Diusu mebajaque hue. Baja putsu, tuahueda etiatayu beidaji micuaneda epu puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","‘Aimue tsuhu yama micuana mimi id'abata saida neje quisana Tata Diusu jepuiti. Bahue quisa cuana neje bahui yama micuana equene buetsuana. Hora beju ecuina su, yama micuana butsepi equisa Tata Diusu jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Da hora su micuaneda quema ai tsada cuana Diusu ebaja. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Aimue quema Diusu baja taji micuaneseda puji mahue, tuahueda micuana ebia su ibuneda ebatani putsu. Daja micuana ibuneda ebatani, micuaneda ema ibuneda ebainia putsu, daja huecha ema tu peje jenetia pueana jei puana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Beju ema Tata Diusu peje jenetia cuinanana ye mundo su epue puji. Jiahue yama ye mundo eichajusia quema Tata peje su esiapati puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Da su discípulo cuana ja Jesús atana: —Beju jiahue miada ecuanaju saida butsepi equisainia. Aimue ecuaneseda quisaba taji mahue beju. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Miada pamapa ai cuana eshanapaeninia beju ecuanaju ebainia. Da putsu, jei ecuanaju mida Diusu peje jenetia pueana. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Da su Jesús ja jeutsutana huecuana: —¿A da enei hue micuaneda ema jei yainia? ");
INSERT INTO tnaNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Beju hora cuinaitia piada piada micuaneda ejududu ema jepuiti. Ema mehua micuaneda ema eichajusia. Daja biame, aimue ema mehua ema yaniti mahue, quema Tata Diusu ema neje yani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Tueda ai cuana yama micuana butsepi equisainia nimepijajajiji mepuque puji. Ye mundo su micuaneda yani tupu, beju sufri epu. Daja biame, nimetucheda mepuque, ema ebia su tucheda micuana etsahua puji, yama Ishahua, cristiano madhada cuana pishitiameana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesús beju daja quisa pupe putsu, buepa huabata pu putsu, Diusu mitsupirutana uja: —Tata, quema manu hora beju cuinaitia. Cuaja yama mida tucheda eni cristiano cuana bameana nime, daja huecha bameque huecuana ema tucheda eni. ");
INSERT INTO tnaNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Miada ema huaratiana cristiano cuana sa puji. Ema huaratiana putsu, ema peje su jei epuani cristiano cuana yama eid'e yameeniyu. ");
INSERT INTO tnaNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mida da piada quita eid'e eni Diusu. Miada ema ye mundo su beituana. Quebata ja etseda eshanapatani, tueda da cielo su eid'e epueni. ");
INSERT INTO tnaNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","‘Beju yama cristiano cuana mique tucheda bameana. Miada ema cuatsasiana ai cuana beju yama apeitia. ");
INSERT INTO tnaNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Equene ye mundo aniji mahue su, ema mi neje cielo su ebia su tucheda anidha. Tata, jiahue bameque neicha tueda quema tucheda cristiano cuana ja pabata puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","‘Miada mique dharejiji cuana eme peje su jei ameana. Beju yama mi jepuiti buetsuana huecuana. Mique jacuatsasiati cuana beju jei atana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Jiahue eshanapaenitani huecuana pamapa miada ema tiana jabuetsuati cuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ema mi peje jenetia pueana beju eshanapaenitani huecuana. Miada ema tiana jabuetsuati cuana beju yama buetsuapeana huecuana. Tueda jabuetsuati cuana su jei putana huecuana. Ema mi peje jenetia pueana jei putana huecuana. Miada ema beituana jei putana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","‘Tuneseda puji bahui mi yama ebajainia, mique dharejiji cuana putsu, miada ema peje su jei ameana huecuana putsu. Aimue yama mi ebajainia mahue ema peje su jei puja mahue cristiano cuana sa puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Pamapa ema peje su jei eputani cuana da mique dharejiji cuana eputani. Saida, butsepi epuniunetiani huecuana putsu, cristiano cuana ja ema jepuiti saida emimitayu. ");
INSERT INTO tnaNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","‘Aimue ema ye mundo su yaniti mahue. Beju tuneda mu yanitita. Mi yani su ema eputi. Tata, quinaenique ye miada ema peje su jei ameana cuana. Tuneda cama dunejiji paanita, etseda dunejiji yani nime. ");
INSERT INTO tnaNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Beju miada ema peje su jei ameana huecuana. Ema tucheda tiana neje yama quinana huecuana ema tuna neje yani tupu, ema peje su jei papurijita mahue puji. Aimue mecuana sa ema peje su janimetucheati cuana taitanametana huecuana mahue. Piada ja bahui taitanametana, cuaja derejiji yani batame. Beju Jesús ja mesa Tata daja hue mitsutsuainiame atana uja: ");
INSERT INTO tnaNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","—Tata, jiahue ema mi peje su eputi. Ema upia yani tupu, yama mida bajana tuneseda puji, ema nime beidaji paputa huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Yama mique jabuetsuati cuana buetsuana huecuana. Ema nime aimue tuneda ye mundo sa puji mahue putsu, mi tsada mahue baji cuana eduininibatani huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Aimue mi yama ebajainia mahue ye mundo jenetia ejemicuina huecuana puji. Beju yama mi ebajainia miada Ishahua peje jenetia ebianetia huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Beju aimue ema ye mundo sa puji mahue. Daja huecha tuneda di ema nime aimue ye mundo sa puji mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ichaderaque huecuana miqueda puji bahui. Butsepiameque huecuana mique ene quita jabuetsuati cuana neje. ");
INSERT INTO tnaNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Miada cristiano cuana peje su ema beituana nime, daja huecha yama tuneda di ebeitu cristiano cuana peje su. ");
INSERT INTO tnaNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Da puji ema miqueda puji eichaderatiani. Daja huecha yama eichaderainia huecuana. Mique jabuetsuati bahui yama ebuetsuainia huecuana mique ai saida cuana bahui paata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","‘Aimue tuneseda puji bahui mi yama ebajainia mahue. Tuna tije ema peje su jei eputani cuana sa puji di yama mi ebajainia tuneda cama saida, dunejiji huamahuama paanita puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tata, cuaja etseda dunejiji yani nime, daja tuneda di huamahuama dunejiji paanita cristiano cuana miada ema beituana jei paputa puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mique tucheda miada ema tiana beju yama tuneda di tiana tuneda cama etseda nime dunejiji paanita puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ema tuna neje dunejiji yani. Mida ema neje dunejiji yani. Da su tuneda di huamahuama dunejiji paanita cristiano cuana ja miada ema beituana pashanapata puji. Cuaja miada ema ibuneda ebainia nime, daja miada ibuneda ebainia huecuana cristiano cuana ja pashanapata. ");
INSERT INTO tnaNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","‘Tata, miada ema peje su jei ameana huecuana. Quema tsada quepia ema yani su ema neje paanitita huecuana. Daja huecha quema tsada quema mi neje cielo su anina su, tucheda pabata huecuana. Ye mundo ai mahue su, miada ema ibuneda baidha. Da tiempo su miada mique tucheda ema tiaidha. ");
INSERT INTO tnaNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tata, mida da nimebutsepi. Ema peje su jei puja mahue cristiano cuana ja aimue mi eshanapatani mahue. Beju yama mu mi eshanapaeninia. Ye quema discípulo miada ema peje su beituana cuana ja di miada ema beituana eshanapatani. ");
INSERT INTO tnaNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Beju yama mida shanapameana huecuana. Cuaja miada ibuneda ebainia huecuana, yama shanapameana huecuana. Daja yama ana huecuana tuneda huamahuama ibuneda pabatita puji, ya di tuna neje paanieniti puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesús daja mimipe putsu, mesa discípulo cuana neje Cedrón ena muri banime chu maje putiana. Dapia chujemame olivo equi eti jude anina. Jesús tueda eti jude su nubiana discípulo cuana neje. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Beju Judas ja di tueda eti jude shanapataina, dapia Jesús discípulo cuana neje jadhitatina putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Da su beju Judas di dapia cuinatiana jucuada templo sa soldado cuana neje. Fariseo, sacerdote huaraji aida cuana ja beitutana huecuana Jesús eina puji. Tueda soldado cuana beju metseji, huedaji cama putana. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesús mu pamapa cuaja epu ai cuana bahue puina. Da su tuahueda quisabatana huecuana uja: —¿Aidhe da micuaneda echacuinia? ");
INSERT INTO tnaNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Tuneda jeutsutana: —Jesús Nazaret ejude jenetia ecuanaju echacuinia. Da su Jesús ja jeutsutana huecuana: —Beju ema da. Judas di soldado cuana neje netiana. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesús, “Beju ema da”, puana su, yahua su bishi je dajaja putana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Da su Jesús ja neicha quisabatana huecuana: —¿Aidhe da micuaneda echacuinia? Beju neicha jeutsutana huecuana: —Jesús Nazaret ejude jenetia ecuanaju echacuinia. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Da su Jesús ja uja atana huecuana: —Beju yama micuana, “Ema da”, aitia. Ye quema ebuqueji cuana beju paputitayu, ema bahui micuaneda echacuinia putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Daja puana, cuaja equene Jesús ja Tata Diusu atana batame: “Mue quebata biame taitana miada ema peje su jei eputani tiana cuana jenetia.”) Da su aimue soldado cuana ja discípulo cuana inatana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Beju Simón Pedro ja mesa espada jemicuinatana. Piada deja sa eid'aja bai eni bene siquijusiatana. Tueda deja Malco banime puina. Tueda da sacerdote cuana sa echua puji sa emebajaji puina. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Da su Jesús ja Pedro uja d'ayatana: —Biuyuque mique espada, Tata Diusu sa tsada ema padusuta huecuana puji putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Da su beju soldado cuana ja Jesús ina putsu, risitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Anás sa ete su dusutana huecuana. Anás da Caifás sa ehuane sa tata puina. Caifás da sacerdote cuana sa echua puji puina tueda mara puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Equene Caifás ja judío cuana uja atana: “Ebia su saida tueda deja Jesús pamanu ecuaneda emanu mahue puji.” ");
INSERT INTO tnaNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Beju Simón Pedro, pia discípulo neje Jesús tije putiana Anás sa ete teje. Tueda pia discípulo ete etseque su taraca dume su nubiana. Da dume su Jesús quinataina huecuana. Tueda discípulo ja sacerdote sa echua puji shanapataina putsu, taraca etsequeini quinaji epuneje ja d'eji tiatana tu panubi puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedro ja mu mue sacerdote sa echua puji shanapa atana putsu, taraca etsequeini quinaji epuneje ja aimue d'eji tiatana mahue tu panubi puji. Da su beju Pedro taraca etseque su netitiana. Da su tueda pia discípulo ja taraca etsequeini quinaji epuneje bajatana Pedro panubi puji. Da su Pedro nubiametana. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Pedro enubiani cama, etsequeini quinaji epuneje ja tueda quisabatana uja: —¿Aimue jia maida mida tueda deja sa piada ebuqueji mahue? Da su Pedro ja jeutsutana: —Aimue ema mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Beju huinada putsu, soldado, emebajaji cuana ja cuati turutana. Pamapa su cuati naja su jayutitanetina. Pedro di dapia cuati naja su tuna neje jayutinetina. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Beju Pedro cuati naja su eyutineti cama, Anás ja Jesús quisabapirutana tusa discípulo cuana, jabuetsuati cuana jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Da su Jesús ja uja jeutsutana Anás: —Beju yama pamapa cristiano cuana butse su bata saida buetsuana jadhitati ete jude cuana, templo su. Mue yama rubuajiji aidhe biame buetsua. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Ai puji miada ema equisabainia? Quisabatique ema id'abaji cuana. Tuneda quisataque cuaja yama buetsuame ana cuana. Beju tuneda bahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesús beju daja mimiana su, pia templo sa soldado dapia eneti ja buahuapatsitana. Tuahueda Jesús uja atana: —Be daja jeutsuji sacerdote cuana sa echua puji aida. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Da su Jesús ja jeutsutana: —Ahua ema madhada hue mimitia su, da su quisaque ema ai madhada ema puitia. Ahua ema madhada mahue mimitia su, ¿ai puji ni da miada ema buahuapatsitia? ");
INSERT INTO tnaNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Da su Anás ja Jesús risijiji dusuametana sacerdote cuana sa echua puji aida Caifás peje su. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Daja Jesús equisabatani huecuana cama, Pedro cuati naja su jayutinetina. Beju tu naja su netiji cuana ja quisabatana: —¿Aimue jia maida mida tueda deja sa ebuqueji mahue? Da su Pedro ja jeutsutana uja: —¡Mahue! Aimue ema mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Beju pia sacerdote cuana sa echua puji sa emebajaji dapia netina. Mesa edue puji puina Pedro ja id'aja siquijusiatana. Tuahueda Pedro quisabatana: —¿Aimue jia maida yama mida Jesús neje bana olivo equi eti jude su mahue? ");
INSERT INTO tnaNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Da su Pedro ja neicha jeutsutana: —¡Mahue! Da hora su quitaita beju huaripa deja queiana. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Da su beju Caifás sa ete jenetia cuinati putsu, Jesús dusutana huecuana huaraji aida Pilato sa ete aida su. Beju ehuenani puina. Tueda judío cuana da extranjero judío mahue romano sa ete su mue nubi putana. Ahua judío mahue cuana sa ai cuana ed'apabata huecuana su, aimue pascua tsine bata cua huecuana mahue. Da putsu, mue nubi putana huecuana romano huaraji aida Pilato sa ete su. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilato hue tuna peje su cuinanana tuna equisa puji. Tuahueda uja quisabatana huecuana: —¿Ai jepuiti ni micuaneda ye deja etuaquisainia? ");
INSERT INTO tnaNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Da su jeutsutana huecuana: —Ye deja ja aimue ecuanaju sa tata chenu cuana sa jacuatsasiati cuana yatani mahue. Da putsu, ecuanaju mi peje su duseitia. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato ja atana huecuana: —Medusuque hue tueda. Mematsetique tueda, cuaja micuana sa jacuatsasiati epuani batame. Da su judío cuana sa ehuidusuji cuana ja jeutsutana Pilato: —Ecuanaju sa mu aidhe biame cuaja manuame taji mahue, miqueda bahui tueda jacuatsasiati cuana a taji putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Daja equene Jesús puana extranjero judío mahue cuana ja tueda emanuameta jepuiti.) ");
INSERT INTO tnaNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Da su Pilato mesa ete aida su neicha nubitiyu putsu, Jesús ihuatana. Beju uja quisabatana: —¿A da mida judío cuana sa echua puji? ");
INSERT INTO tnaNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús ja uja jeutsutana: —¿A da ene mida bahue puja? ¿Ahua miada ema daja equisabainia, pia cuana ja mi ema jepuiti quisataitia putsu? ");
INSERT INTO tnaNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato ja Jesús jeutsutana: —¿Ai ema judío deja bata? Sacerdote huaraji aida cuana ja quitaita mi ema peje su dusetaitia. Beju, ¿ai madhada miada ana? Quisaque ema. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Da su Jesús ja Pilato jeutsutana uja: —Aimue ema ye mundo su ecuatsasiatiani mahue. Ahua ye mundo su ema jacuatsasiati cua su, quema ebuqueji cuana tuna neje jaichetita cua aimue ema painata huecuana mahue puji. Beju aimue daja puana mahue, ema ye mundo su aimue ecuatsasiatiani mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Da su Pilato ja Jesús quisabatana: —¿Da su jia mida echua puji? Jesús ja tueda jeutsutana: —Ehe, ema da cuaja mi epuani nime. Da puji ema bataji puana. Ema ye mundo su pueana mimi ene quita, butsepi cristiano cuana equisa puji. Beju pamapa mimi ene quita, butsepi id'abaji cuana bahui ema tije yata. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Da su Pilato ja uja Jesús quisabatana: —¿Ai ene quita, butsepi mimi yani bata? Pilato daja quisabape putsu, cuinanatiana etseque su judío ehuidusuji cuana neje emitsuti puji. Uja atana huecuana: —Ye deja da jucha mahue yama ebainia. ");
INSERT INTO tnaNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pamapa pascua tsine su piada terijiji mesia bahue ecuanaju. Da su yama ye judío cuana sa echua puji Jesús emesia. ¿Jucuaja ni da micuaneseda piba? ");
INSERT INTO tnaNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Da su jubida neje Pilato uja biatsiatsiatana huecuana: —¡Be tueda deja mesiaji! ¡Barrabás bahui mesiaque! Tueda Barrabás da tsi puji puina. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Da su beju Pilato ete su neicha nubiana. Tuahueda soldado cuana cuatsasiatana Jesús huacabiti neje paicheta huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Da su junu aquid'aji bauda jenetia corona a putsu, Jesús sa echua su ichatana huecuana tu neje eshishati puji. Daja a putsu beju, Jesús jud'utana huecuana ebiad'amaji idhiria neje. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Mimi neje Jesús bid'ida a putsu, madhabapirutana huecuana uja: —¡Viva judío cuana sa echua puji! Daja epuani je, buahuapatsitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Da su Pilato neicha cuinanana judío ehuidusuji cuana peje su. Uja atana huecuana: —Mechamaque. Yama tueda ejemicuinainia micuaneda bahue epu puji tueda jucha mahue yama ebainia. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Pilato emimiani cama, Jesús jemicuinatana huecuana. Corona aquid'aji bauda jenetia ajiji tusa echua su anina. Ebiad'amaji idhiria neje jud'ujiji. Da su Pilato ja atana huecuana: —¡U hue da ye deja! ¡Mechamaque! ");
INSERT INTO tnaNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Sacerdote huaraji aida, templo sa soldado cuana ja Jesús ba putsu, jubida neje biatsiatsiapirutana huecuana uja: —¡Metataque curusu su! ¡Metataque curusu su! Da su Pilato ja atana huecuana: —Beju micuaneda hue metatatique, ye deja jucha mahue yama ebainia putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Beju judío ehuidusuji cuana ja Pilato jubida neje jeutsutana: —Tueda da Diusu sa Ebacua jabametiana. Da putsu, tuseda manu taji, cuaja ecuanaju sa jacuatsasiati epuani batame. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato ja tueda mimi cuana id'aba putsu, ebia su iyuame pupiruana. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Neicha dusutana Jesús ete dume su. Dapia tueda quisabatana uja: —¿Que jenetia da mida? Jesús ja mue jeutsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Da su Pilato ja neicha quisabatana: —¿Ema mi jeutsuja mahue yainia? Bahue puque, quema tucheda yani mi curusu su etata puji, ahua mi d'eji su ya puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Da su Jesús ja jeutsutana: —Miqueda mu mue ai biame ema neje a taji, ahua Diusu sa tsada mahue su. Da su ema mi peje su menajatiatana cuana da mi ebia su jucha aida eputani. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Da hora jenetia Pilato ja cuaja Jesús mesiame ya puji chacutana. Beju judío ehuidusuji cuana ja mu mue d'eji tia atana. Ebia su jubida biatsiatsiatana huecuana uja: —Ahua miada tueda deja d'eji etia su, aimue mida mique echua puji aida sa eshanapa epu mahue. Tueda Jesús echua puji puja putsu, romano echua puji aida neje emajaitiani. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato ja tueda mimi cuana id'aba putsu, Jesús pajemicuinata huecuana cuatsasiatana. Huaraji sa aniude su aniuteana. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Beju piada tsine pascua tsine yani hue su. Buepatia puina. Da su Pilato ja judío cuana sa ehuidusuji cuana uja atana: —¡Hue upia micuana sa echua puji! ");
INSERT INTO tnaNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Beju ebia su jubida biatsiatsiatana huecuana: —¡Pamanu! ¡Pamanu! ¡Metataque hue curusu su! Da su Pilato ja quisabatana huecuana: —¿Ai yama micuana sa echua puji curusu su etata bata? Beju sacerdote huaraji aida cuana ja Pilato uja jeutsutana: —Aimue tueda da ecuanaju sa echua puji mahue. Ecuaneda da Roma ejude su echua puji sa emebajaji cuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Da su mimipetana huecuana su, Pilato ja Jesús menajatiatana soldado cuana peje su tu curusu su patatata huecuana puji. Beju dusutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Da su beju cuinanatana huecuana curusu eti jude Calavera banime murucu su. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Dapia cuinati putsu, Jesús curusu su tatatana huecuana. Beta deja detse di tatatana huecuana pia beta curusu detse su. Piada Jesús sa bai eni bene netiatsuatana huecuana. Pia d'ani bai bene netiatsuatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato ja soldado cuana cuatsasiatana curusu su Jesús sa echua bia su padereta puji. Da su uja deretana huecuana: “Ye da Jesús Nazaret ejude jenetia. Tueda da judío cuana sa Echua Puji.” ");
INSERT INTO tnaNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jucuada judío cuana ja tueda mimi cuana mimiametana, tueda eti jude Jerusalén ejude naja su anina putsu. Tueda mimi cuana quimisha yana su deretana huecuana. Hebreo, griego, latín yana cuana su deretana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Da putsu beju, sacerdote huaraji aida cuana Pilato peje su putitana tu uja equisa puji: —Be dereji uja: “Judío cuana sa Echua Puji.” Dereque uja: “Tueda pa da judío cuana sa Echua Puji.” ");
INSERT INTO tnaNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Da su Pilato ja atana huecuana: —Cuaja yama dereitia beju, daja hue paaniti. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jesús sa ejud'uji cuana pushi soldado cuana ja tuneda cama jasajasajatiatitana. Jesús sa ebia jud'uji ebia su saida, chujeneda puina. Rusujiji mahue tad'ijiji. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Da su soldado cuana uja jaquisatitana: —Be pad'iutija pushi eped'u su ye ejud'uji. Ebia su saida suerte paatija quebata sa puji epu. Beju uja derejiji yani Diusu sa quirica su: “Quema ejud'uji jasajasajatiatitana huecuana. Tueda ejud'uji puji suerte atana huecuana.” Beju daja soldado cuana ja atana, cuaja Diusu sa quirica su biahua tiempo deretaidha batame. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Beju curusu naja su Jesús sa cuara anina. Mesa cuara sa d'ana María di anina. Tueda da Cleofas sa ehuane puina. María Magdalena di tuatse neje beju anina. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Da su Jesús ja mesa cuara bautetana. Mesa discípulo ibuneda di bautetana. Jesús ja tuatse baute putsu, uja mesa cuara atana: —Mama, hue upia mique ebacua puji eneti. Tuahueda mi ebata mique ebacua quitaita pu cua nime. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Da su beju mesa discípulo uja atana: —Hue upia mique cuara puji eneti. Baque tueda mique cuara quitaita pu cua nime. Beju da tsine jenetia María anipiruana tueda discípulo sa ete su. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Da su beju Jesús bahue puana pamapa beju apejiji. Pamapa Tata Diusu ja tueda tiatana ai cuana apetana. Da su uja puana: —Jaid'itija ema. Daja Jesús puana, cuaja Diusu sa quirica su derejiji yani batame. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Beju dapia da emeji vino patseda neje sejeajiji anina. Huapese nime tsabiatana huecuana vino tsetseda su. Da su hisopo equi echa huitsana su huapese nime icha putsu, Jesús sa ecuatsa su atsuatana huecuana tu edhibita puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesús ja vino tsetseda tsaba putsu, uja puana: —Pamapa apejiji beju. Daja mimipe putsu, beju mesa echua jahueririati putsu, manuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Beju piada tsine pascua tsine yani hue su. Judío ehuidusuji cuana sa tsada mahue puana equita cuana curusu cuana su pabadeta puji, janahua tsine hue quita putsu. Tueda da tsine iyuda epuani putsu, equita cuana curusu cuana su pabadeta mecuana sa tsada mahue puana. Da putsu, Pilato bajatana huecuana curusu cuana su tatajiji cuana sa etidada cuana pajarijariameta tuna pamanupudata puji. Daja huecha bajatana huecuana equita cuana pajemiuteta curusu cuana jenetia, janahua tsine cuinaji mahue su. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Da su beju soldado cuana putitana curusu cuana eneti su. Equene Jesús neje tatajiji detse sa etidada cuana jarijariatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jesús peje su macha janariatitana huecuana su, tueda manujiji batana huecuana. Da putsu, aimue tusa etidada jarijariatana huecuana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Piada soldado ja Jesús sa atsupa su lanza neje d'acuatana. Beju ami, yahui cuinanana. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Tueda ai cuana da yama quitaita bana. Ema butsepi quisa epuani micuaneda jei epu puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Tueda ai cuana daja puana, cuaja uja Diusu sa quirica su derejiji yani batame: “Aimue tusa etsau jarijariatana huecuana mahue.” ");
INSERT INTO tnaNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Pia su derejiji yani uja: “Ed'acuaji cuana ja tueda echamata.” ");
INSERT INTO tnaNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Beju daja pupeana su, José Arimatea ejude jenetia Pilato peje su putiana Jesús sa equita ebajati puji. José da Jesús sa rubuajiji ebuqueji puina, judío ehuidusuji cuana iyubatana putsu. José ja Jesús sa equita dusutana, Pilato ja tueda d'eji tiatana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo ja di José tsahuatana. Tueda Nicodemo da equene dhidha su putiana Jesús peje su tu neje quisaquisa epu puji. Quimisha tunca kilo especias dusetana Jesús sa equita epapi puji. Tueda especias da banime mirra, áloes neje huarujiji. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Da su beju José, Nicodemo detse ja Jesús sa equita dusutana. Equita babutana tse ebabuji bauda neje. Tueda ebabuji da puida huanime puina, especias su tsabiajiji putsu. Daja judío cuana a bahue puina manujiji cuana sepulcro su ehuananubia puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Dapia Jesús curusu su tatatana huecuana naja su beju eti jude ania chidi anina. Dapia rara aida, eichacua anina tumu epa su aidhe biame tsuhu huananubiaji mahue puina. Tueda rara aida sepulcro puji puina. ");
INSERT INTO tnaNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Da dume su Jesús sa equita huananubiatana tse. Tuatseda beju tipei neje daja atana, janahua tsine hue quita putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Janahua tsine jaitiana su, beju domingo tsine huenatiana. Dhemedheme su hue María Magdalena sepulcro su putiana. Beju rara terijiji mahue batana. Beju sepulcro eteriji tumu aida beju ichaderajiji puina. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Da su María jududutiana Simón Pedro peje su. Jesús ja ibuneda bataina discípulo di Pedro neje anina. María ja uja quisatana tse: —Beju Echua Puji chenu sa equita dusutana huecuana. Mue ecuanaju shanapa quepia jia ichatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Da su Pedro tueda pia discípulo neje putiana sepulcro su. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Betana su jududutiana. Tueda pia discípulo Pedro ebia su tipeida jududutiana. Equene sepulcro su cuinatiana. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Sauteana sepulcro dume echama puji. Ebabuji bauda bahui esa batana. Beju mue nubiti puana sepulcro su. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tije beju Pedro cuinatiana. Tueda mu sepulcro dume su nubiana. Tuahueda di ebabuji bauda esa batana. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ed'eji su, Jesús sa echua babuji tanujajiji chujemame yani batana. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Da su equene cuinana discípulo di sepulcro su nubiana. Pamapa daja ai cuana ba putsu, jei puana. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Daja ai puana cuana teje mue shanapa atana tse quirica su derejiji mimi cuana Jesús jepuiti. Tueda mimi cuana Jesús eid'eyu manujiji cuana duju jenetia puana ye chu, da hora su shanapatana tse. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Da su tueda discípulo detse jasiapatibana tuatse sa ete su. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Beju María Magdalena anitiana sepulcro tsequeini su epa puji. Epani cama, sauteana sepulcro dume echama puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Beju beta ángel detse ejud'uji pasaneji Jesús sa equita saina eti jude su yani batana. Piada ángel echua bene anina. Pia ehuatsi bene anina. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tuatseda María uja quisabatana: —Epuna, ¿jucuaja su ni mi epani? María ja jeutsutana: —Ema epani, quema Echua Puji chenu dusutana huecuana putsu. Bue mahue ema quepia huanatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Daja emimipeni cama, María jababarereatiana. Beju Jesús eneti batana. Ebainia biame, mue shanapa atana. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Da su Jesús ja María quisabatana uja: —¿Jucuaja su ni mi epani? ¿Aidhe miada echacuinia? Beju María japibatiana tueda eti jude quinaji pepe puana. Da su uja jeutsutana: —Tata, ahua miada equita dusuana su, quisaque ema quepia miada huanana yama tueda edusu puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Da su Jesús ja: —¡María! —atana. María ja id'aba putsu, uja atana: —¡Ebuetsuaji! ");
INSERT INTO tnaNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Da su Jesús ja cuatsasiatana uja: —Be ema nahueji, ina putsu. Mesiaque ema, quema Tata peje su puti taji putsu. Putique quema edue cuana peje su. Quisatique huecuana ema ecuana sa Tata Diusu yani su etsuatiyu. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Da su beju María ja pia discípulo cuana peje su putiana Echua Puji eid'e batana equisati puji. Jesús ja tueda quisatana cuana di quisatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Tueda domingo tsine su huecha hue, dhidha su beju dueji Jesús sa ebuqueji cuana jadhitatijiji anitana ete su. Jateriti dhitajiji anitaina huecuana, judío ehuidusuji cuana iyuba putsu. Beju ete terijiji biame, Jesús tuna duju su bataji puana. Mitsutana huecuana uja: —Menimepijajaque. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Daja epuani je, Jesús ja mesa eme, atsupa bametana huecuana. Beju beidaji putana huecuana, tu ba putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Neicha Jesús ja atana huecuana: —Menimepijajaque. Cuaja quema Tata Diusu ja ema beitutana nime, daja yama micuana ebeituinia quema quisa saida cuana cristiano cuana quisaquisa meatique puji. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Da su Jesús ja tuna bia je juju putsu, uja atana huecuana: —Mebatsuque Espíritu Santo. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ahua micuaneda quebata cuana sa jucha cuana eperdona su, beju perdonajiji tuna sa jucha cuana epu. Ahua aimue micuaneda quebata cuana sa jucha cuana eperdona mahue su, beju aimue perdonajiji mahue tuna sa jucha cuana epu. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Beju piada discípulo da Tomás banime puina. Mesa esitu ebani Pere puina. Aimue tueda anina mahue, Jesús tuna duju su jabametiana su. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jesús aimue su, Tomás pueana. Pia discípulo cuana ja tueda quisatana uja: —Ecuanaju da baitia Echua Puji beju eid'e. Da su Tomás ja uja atana huecuana: —Aimue ema jei epuani mahue. Ahua quema eme huitsana tusa etsi cuana su biuji mahue su, aimue ema jei epu mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Beju ocho tsine jaitianana su, neicha Jesús sa discípulo cuana jadhitatitana ete su. Tomás di tuna neje anina. Beju ete terijiji biame, Jesús tuna duju su bataji puana. Uja mitsutana huecuana: —Menimepijajaque. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Da su Jesús ja Tomás uja atana: —Mique ema huitsana biuque quema eme, atsupa etsi cuana su. Be jei puja mahue puji. Jiahue beju jei puque. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Da su Tomás ja Jesús atana: —¡Mida da quema Echua Puji, Diusu! ");
INSERT INTO tnaNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús ja tueda atana: —Tomás, jiahue mi ema peje su jei puitia, ema baitia putsu. Beidaji quebata cuana ema baji mahue biame, jei eputa su. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Beju Jesús ja jucuada pia nimetiuda aida cuana atana mesa discípulo cuana butse su. Tueda nimetiuda aida cuana aimue ye quirica su derejiji yani mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Quejucua hue ye quirica su dereana micuaneda Jesucristo da Diusu sa Ebacua shanapa putsu, tu peje su jei epu puji. Beju tu peje su jei pu putsu, micuaneda cielo su tu neje eid'e epuenitiyu. ");
INSERT INTO tnaNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pia tsine Jesús neicha jabametiana mesa discípulo cuana peje su Tiberias bai maje su. ");
INSERT INTO tnaNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Dapia anitaina: Simón Pedro. Tomás. Tusa esitu ebani da Pere. Natanael. Tueda da Caná yahua jenetia Galilea yahua su. Zebedeo sa ebacua detse. Pia Jesús sa discípulo detse di. Tueda siete discípulo cuana dapia bai maje su anitaina. ");
INSERT INTO tnaNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Da su beju Pedro ja atana huecuana uja: —Ema da esia epu. Da su uja atana huecuana: —Ecuanaju di mi neje eputi. Beju canoa aida su nubitana huecuana esia epu puji. Tueda dhidha su mu mue ai se biame jemi atana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Beju ehuenani su, Jesús bai maje su bataji puana. Discípulo cuana ja tueda mue shanapa atana. ");
INSERT INTO tnaNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Da su Jesús ja tsiatsia neje uja atana huecuana: —Tata cuana, ¿a da mue micuaneda se jemi aja? Beju jeutsutana huecuana: —Ai mahue. ");
INSERT INTO tnaNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Da su Jesús ja atana huecuana: —Mesiaque tarrafa canoa bai eni bene su. Dapia micuaneda ejemi. Beju daja atana huecuana. Daja a putsu, tarrafa cuaja riretsua taji mahue batana huecuana, dueji se cuana nubiana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Da su Jesús ja ibuneda bataina discípulo ja Pedro uja atana: —¡Tueda da Echua Puji! Beju Pedro mudumudusaina ebia jud'uji mahue. Tueda mimi id'aba putsu, tipeida jajud'utiana. Ena su beju tenatiana Jesús peje su betsa neje ecuinati puji. Canoa da cien metro uquedame bai maje jenetia saina. ");
INSERT INTO tnaNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Pia discípulo cuana mu emaje su cuinatana canoa neje. Tarrafa se neje sejeajiji riretana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Emaje su cuinati putsu, cuati tid'e batana huecuana. Etid'e bia su se esa batana huecuana. Pan di anina. ");
INSERT INTO tnaNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Da su Jesús ja atana huecuana: —Jiahue quita jemitia se cuana quejucua meduseque. ");
INSERT INTO tnaNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Da su Simón Pedro canoa aida su nubitiana. Tarrafa se aida cuana neje sejeajiji murida su riretsuatana. Beju cien pishica tunca quimisha ejaitiana se cuana tarrafa su badeina. Dajucua se cuana biame, mue jad'iuti tarrafa. ");
INSERT INTO tnaNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Da su Jesús ja atana huecuana: —Mepueque ediadia puji. Beju aimue tuneda quebata ja biame, “¿Aidhe da mida?” Jesús quisabatana mahue, tueda da Echua Puji shanapaenitana huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Da su Jesús ja pan, se ina putsu, berereatiatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Da neje su beju quimisha nuati Jesús bataji puana discípulo cuana peje su. ");
INSERT INTO tnaNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Diadiape putsu, Jesús ja Simón Pedro uja quisabatana: —Simón, Jonás sa ebacua, ¿a da miada ema ye cuana ebia su ibuneda ebainia? Pedro ja tueda jeutsutana: —Ehe, Echua Puji, mida bahue yama mi ibuneda ebainia. Jesús ja tueda cuatsasiatana: —Da su quema jabuetsuati cuana ema peje su jei eputani eichacua cuana buetsuaque. Quinachidique huecuana, cuaja huisha quinaji ja mesa huisha cuana equinatani nime. ");
INSERT INTO tnaNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Neicha beta nuati puji Jesús ja Pedro quisabatana uja: —Simón, Jonás sa ebacua, ¿a da miada ema ibuneda ebainia? Pedro ja tueda jeutsutana: —Ehe, Echua Puji, mida bahue yama mi ibuneda ebainia. Jesús ja tueda cuatsasiatana: —Da su quema jabuetsuati cuana ema peje su jei eputani cuana buetsuaque. ");
INSERT INTO tnaNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Neicha quimisha nuati puji beju Jesús ja Pedro quisabatana uja: —Simón, Jonás sa ebacua, ¿a da miada ema ibuneda ebainia? Beju Pedro nimepupad'iana, Jesús ja tueda daja quimisha nuati quisabatana putsu. Da su uja jeutsutana Jesús: —Echua Puji, mida pamapa bahue. Yama mi ibuneda ebainia mida bahue. Jesús ja tueda cuatsasiatana: —Da su quema jabuetsuati cuana ema peje su jei eputani cuana buetsuaque. ");
INSERT INTO tnaNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ene putsu, yama mi butsepi equisainia, mida edeahue quita su, mi mehua quepia mi putija su putina. Beju mida edhi epu su, mique ebai epirarata pia cuana ja mi erisi puji. Edusuta huecuana mi quepia mi putija mahue su. ");
INSERT INTO tnaNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Da mimi neje Jesús ja Pedro quisatana cuaja tu jepuiti manume epu. Manu putsu, Pedro ja Diusu tucheda cristiano cuana ebameta. Da su beju Jesús ja Pedro atana uja: —Tije ema aque. ");
INSERT INTO tnaNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Da su beju Pedro Jesús neje yaseniuneti tupu, tueda jababarereatiana. Jesús ja ibuneda bataina discípulo batana tuatse tije epusiu. (Tueda discípulo Jesús sa etsedu su japahuatiana, pascua tsine jana diatana huecuana su. Tuahueda uja Jesús quisabatana pascua tsine su: “Echua Puji, ¿quebata ecuanaju mi emenajatia?”) ");
INSERT INTO tnaNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Beju Pedro ja tueda discípulo ba putsu, uja Jesús quisabatana: —Echua Puji, ¿cuaja ni da tueda manume epu? ");
INSERT INTO tnaNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Da su Jesús ja Pedro jeutsutana: —Ahua quema tsada su, tueda eid'e papu ema esiapati teje, mue miqueda mu ai biame a taji. Tije hue ema aque. ");
INSERT INTO tnaNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Da hora jenetia edue cama jaquisatitana tueda discípulo aimue emanu mahue. Daja pibatana huecuana biame, Jesús ja aimue daja Pedro atana mahue pia discípulo jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Beju ema da tueda discípulo. Ema da Juan. Butsepi yama tueda ai cuana yama edereinia. ");
INSERT INTO tnaNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Pia dueji ai cuana Jesús ja atana. Ahua tueda ai cuana derepe cua su, ye mundo tupu mahue pu cua ebia su quirica cuana eichaseta puji. Daja papu.");
INSERT INTO tnaNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofilo, neicha mi yama quirica etiameinia. Equene mi yama quirica tiameana su pamapa Jesús ja ai atana, buetsuatana cuana mi yama quisana. ");
INSERT INTO tnaNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Pamapa ai puana cuana yama mi butsepi quisana Jesús cielo su tsuatibana teje. Beju cielo su tsuatiyuji mahue su, mesa apóstol cuana tije jacuatsasiati cuana tiatana Espíritu Santo sa tucheda neje. ");
INSERT INTO tnaNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jesús manujiji cuana duju jenetia id'eibana apóstol cuana ja beju batana. Aimue emanu mahue batana huecuana, tuna peje su eid'e jabametiana putsu. Pushi tunca tsine tu yani tupu, tuna peje su quejucua nuati biame jabametiana. Diusu ecuatsasiati jepuiti ai cuana buetsuatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Equene Jesús ja uja cuatsasiatana huecuana: —Be mecuinanaji Jerusalén ejude jenetia. Meanitique ejude su. Tata Diusu ja Espíritu Santo micuana peje su ebeituta teje, meid'uaque. Biahua tiempo Tata Diusu puidha cuaja yatayu, daja mesa jamitsuti puidha putsu. Equene yama micuana quisana, Tata Diusu ja Espíritu Santo ebeitu. ");
INSERT INTO tnaNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juan Bautista ja cristiano cuana yahui neje Diusu sa puji ichaderatana. Beju quejucua tsine jenetia Espíritu Santo epueyu. Tuahueda micuana Diusu sa puji eichaderata mesa tucheda neje. Daja Jesús ja mesa apóstol cuana quisatana, cielo su tsuatiyuji mahue su. ");
INSERT INTO tnaNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Pia tsine Jesús neje jadhitatitana huecuana su, uja Jesús quisabatana huecuana: —Echua Puji, ¿a da jiahue quita extranjero soldado cuana miada ebeitu ecuana sa yahua jenetia? ¿A da jiahue miada ecuana sa yahua d'eji ya? ¿A da jiahue israelita cuana sa Echua Puji mida epu? ");
INSERT INTO tnaNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Da su Jesús ja jeutsutana huecuana uja: —Ye ai cuana epu tiempo Tata Diusu bahui bahue. Aimue micuaneda bahue papu puji mahue. ");
INSERT INTO tnaNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Beju micuaneseda cristiano cuana quisa taji bahui ema jepuiti. Espíritu Santo micuana peje su epue tucheda neje. Tuahueda micuana etucheata ema jepuiti quisaquisa epu puji. Jerusalén ejude su aniji cristiano cuana micuaneda equene equisa. Tuna butse su ema jepuiti mequisanetiacuinatique. Da su Judea, Samaria yahua detse su aniji cuana di mequisatique. Pamapa yahua je aniji cristiano cuana mequisatique ema jepuiti. Pamapa tuna butse su ema jepuiti mequisanetiacuinatique. ");
INSERT INTO tnaNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Daja Jesús ja cuatsasiatana huecuana, Olivo Murucu bia su edhitatitani huecuana su. Da su beju Jesús daja mimipe putsu, Diusu ja tueda tuna duju jenetia jemitsuatana buepa su. Judu duju su taitanana. Mue bayu huecuana beju. ");
INSERT INTO tnaNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Tuneda buepa huabata echamatitaneti mane cama, tuna naja su beta deja bataji puana ejud'uji pasaneji. Tuatseda da ángel detse puina. ");
INSERT INTO tnaNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Uja quisabatana tse apóstol cuana: —Galilea yahua jenetia deja cuana, ¿ai puji micuaneda buepa huabata echamachamaneti? Diusu ja mu Jesús buepa su jemitsuatana micuana duju jenetia. Tueda Jesús huecha hue neicha esiapatiyu, cuaja micuaneda etsuabuyu baitia nime. ");
INSERT INTO tnaNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Da su beju tuneda Jerusalén ejude su jasiapatitaibana Olivo Murucu jenetia. Aimue uqueda anina mahue. Aimue piada kilómetro puina mahue. ");
INSERT INTO tnaNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Beju ejude su cuinati putsu, ete su nubititana huecuana. Ebaque ete su nubitana huecuana. Dapia anitaina huecuana. Ye cuana da uja banime: Pedro. Jacobo. Juan. Andrés. Felipe. Tomás. Bartolomé. Mateo. Jacobo. Tueda da Alfeo sa ebacua puina. Simeón. Tueda da partido cananista banime su punetina. Judas. Tueda da Jacobo sa edue puina. ");
INSERT INTO tnaNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Jesús sa edue cuana di dapia anitaina. Jesús sa cuara María, pia epuna cuana neje di anina. Ye cuana da dunejiji anitaina. Diusu neje jamitsuti bahue putana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Pia tsine neicha dapia dueji Diusu peje su jei eputani cuana jadhitatitana. Que chidi hue piada cien beta tunca putaina huecuana. Beju Pedro netianana uja tuna equisa puji: ");
INSERT INTO tnaNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Edue cuana, biahua tiempo Espíritu Santo ja ecuana sa echua puji David chenu deremetaidha Judas Iscariote jepuiti. Tueda Judas ja soldado cuana ehuidusuta Jesús yani su tu einame puji David chenu ja deretaidha. Cuaja David chenu ja deretaidha batame, beju daja puana. ");
INSERT INTO tnaNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jesús ja Judas di dharetana ecuanaju neje tupupai mesa apóstol epu puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Beju deja madhada cuana ja Judas chipilu tiatana quepia Jesús yani ebameta puji. Tueda chipilu neje Judas ja yahua ped'u bajatana. Dapia yahua su dajaja putsu, jadhepujutiana. Mesa etsama cuana cuinanana. ");
INSERT INTO tnaNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalén ejude su aniji cristiano cuana beju bahue putana. Da su tueda yahua ped'u Ami Yahua ebani ichatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ecuana sa echua puji David chenu ja pamapa tueda ai cuana quirica su deretaidha. Tueda quirica banime Diusu sa Satsu cuana (Salmos). Uja deretaidha: Tusa ete mesiajiji paneti beju. Be aidhe biame dapia paani. Pia su daja huecha deretaidha: Pia mu da tusa eturuca papu. ");
INSERT INTO tnaNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Da su uja Pedro ja quisainiame atana huecuana: —Beju jiahue mu pia deja ecuaneda edhare Judas sa eturuca ecuana neje tupupai cristiano cuana Cristo id'eibana equisa puji. Ecuaneseda dhare taji quebata jia ecuana neje tupupai puniunetipiruana Jesús neje. Aiya jia batana Juan Bautista ja Jesús Diusu sa puji yahui neje ichaderatana, aiya jia batana Jesús buepa su etsuabuyu, tueda icha taji Judas sa eturuca. Piada ecuaneseda dhare taji apóstol puji, Jesús id'eibana quisanetiacuinaji papu puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Beju beta deja bahui anina Judas sa eturuca epu puji. Piada José Justo banime puina. Mesa pia ebani Barsabás puina. Pia Matías banime puina. ");
INSERT INTO tnaNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Da su uja Diusu mitsutana huecuana: —Echua Puji, miada cristiano cuana sa piba cuana eshanapaeninia. Beju jiahue quita ecuanaju bameque quebata ye deja detse miada dhareja Judas sa eturuca mi emebaja puji, beju Judas apóstol mahue putsu. Mesa castigo su beju putibana. ");
INSERT INTO tnaNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Da su suerte atana huecuana putsu, Matías puana. Tueda dharetana huecuana apóstol epu puji Judas sa eturuca. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Siete semana jenetia Jesús id'eibana su, pamapa jei eputani edue cuana jadhitatitana piada ete su pentecostés tsine eba puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Dhita putsu, beni jubida saida ebutesiu nime buepa jenetia id'abatana huecuana. Ete dume su tuna yani su hue, daja id'abatana huecuana beni jubida nime. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Metse su hue cuati utsu yana nime tuna bia su ebade batana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Da su beju Espíritu Santo tuna peje su pueana tucheda neje. Shanapametana huecuana tuna bue mahue yana su emimi puji. Pia mimi cuana su beju mimipirutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Da tiempo su pamapa yahua jenetia puejiji judío cristiano cuana Jerusalén ejude su anitaina. Diusu emitsutsua puji puetana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tuneda di beni jubida epusiu nime id'abatana. Da su beju jadhitatitana putsu, apóstol cuana tsapiapiati yana su emimitani id'abatana huecuana. Id'aba putsu, nimetiunetitana huecuana beju. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tuneda cama daja jaquisabatitana: —¿Jucuaja su ecuaneda metse su hue eid'abainia ecuana sa yana cuana? Ye deja cuana ecuana sa mimi cuana emimitani. ¿Aimue jia maida Galilea yahua jenetia huecuana mahue? ");
INSERT INTO tnaNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Cuaja ni da tuneda jabuetsuatime putaitia ecuana sa yana cuana? ");
INSERT INTO tnaNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","10","Beju upia yanita pamapa yahua je aniji cristiano cuana. Judío cuana, Diusu iyubaji judío mahue cuana pia yahua cuana jenetia upia yanita. Hue yani beju Partia, Media, Elam, Mesopotamia, Judea, Capadocia, Ponto, Asia, Frigia, Panfilia, Egipto, Libia yahua cuana jenetia. Cirene, Roma ejude detse jenetia di cristiano cuana puetaitia. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Creta, Arabia yahua jenetia cristiano cuana di yanita. Beju pamapa ecuaneda ecuana sa yana cuana su ye deja cuana emimitani eid'abainia. Diusu ja ai nimetiuda saida atana cuana emimitani huecuana ecuaneda id'abainia metse su hue ecuana sa yana su. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","¿Ai jia da epuani ye nimetiuda ai cuana? Daja hue tuneda cama jaquisabatitana, ebia su nimetiutana huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","14","Beju pia cuana ja mu piada tunca beta ejaitiana apóstol cuana emimitani eid'aba putsu, tuneda cama uja jaquisatitana: —¡Aah! Tuneda tsetseji beju. Vino tsetseda ebia su id'itaitia huecuana. Da putsu, uja emimitani huecuana. Da su Pedro ja jubida jeutsutana huecuana uja: —Judío deja cuana, Jerusalén ejude su aniji cuana, meid'abaenique ema. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ecuaneda mu aimue tsetsejiji mahue, cuaja micuaneda epibainia nime, apudaya hue putsu. Bahue micuaneda judío cuana aimue apudaya jaid'iti bahueta mahue. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Cuaja biahua tiempo Diusu sa profeta Joel chenu deretaidha batame, jiahue micuaneda ebainia. Uja Joel chenu ja deretaidha: ");
INSERT INTO tnaNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Uja Diusu puidha: “Tiempo epupeni su, yama Espíritu Santo ebeitu pamapa cristiano cuana peje su. Micuana sa ebacua, ebaquepuna cuana cuaja epu ai cuana quisa eputa. Edeahue, tata edhi cuana cuana yama equisa tahui su nime. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Da tiempo su quema deja, epuna emebajaji cuana peje su yama Espíritu Santo ebeitu. Tuahueda cuaja epu ai cuana equisameta. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Buepa, yahua su yama ai nimetiuda cuana yayu. Ami, cuati, judu epu. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Id'eti da yapuna. Badi da ami nime epiati. Tueda ai nimetiuda cuana bataji epu, quema castigo tsine cuinaji mahue su. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Tueda tiempo iyuda su quebata ema peje su jei epuani cuana yama d'eji su ya. Daja puidha Diusu, Joel chenu ja deretaidha. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pedro ja daja hue quisainiame atana huecuana uja: —Israel deja cuana, meid'abaenique ema. Jesús Nazaret ejude jenetia da Diusu sa Jabeituti Deja. Tu jepuiti Diusu ja ai nimetiuda saida cuana atana micuana duju su. Beju micuaneda quitaita bana. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Micuaneda Jesús menajatiana deja ate cuana peje su, curusu su patatata huecuana puji. Micuaneda Jesús manuamemeana. Beju daja pamapa puana, cuaja Diusu ja biahua tiempo pibataidha batame. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Beju Jesús manuana biame, Diusu ja tueda id'emetaibana, aimue detse cua su biame manueni cua puina mahue. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Biahua tiempo echua puji David chenu ja Jesús jepuiti deretaidha uja: Quema Echua Puji, pamapa hora su mi yama echamainia. Mida da ema naja su quema bai eni bene yani ema ebianetia puji. Da putsu, quema aimue iyuame. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nimebeidaji da ema. Mimi beidaji cuana emimiani. Ema emanu biame, bahue ema miada ema eid'e yameyu. Da putsu, mi peje su ema enimetucheati, ema emanu biame. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ema da mique ibuneda emebajaji. Aimue miada ema manu su, ejusiahuana mahue. Aimue quema equita eihuiame mahue, miada ema eid'emeyu putsu. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Miada ema eid'e yame jamitsuti tiana. Ema beidaji yameyu, mida ema neje yaniti putsu. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Da su beju Pedro ja daja hue quisainiame atana huecuana uja: —Edue judío cuana, mepibaenique quema mimi cuana. Ecuana sa echua puji David chenu beju manuidha. Sepulcro su huananubiataidha huecuana. Jiahue cama bataji hue mesa sepulcro. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David chenu da Diusu sa profeta puidha. Diusu ja tueda jamitsuti tiataidha uja: “Piada mique epusiu utsecua cuana mi nime Echua Puji ya.” ");
INSERT INTO tnaNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Beju David chenu bahue puidha tueda utsecua epusiu Cristo epu. Da putsu, Diusu ja Cristo eid'emetayu, David chenu puidha. Cristo emanu biame, aimue Diusu ja tueda emanu su ejusiahuanata mahue. Tusa equita aimue eihuiameta mahue. Daja David chenu puidha. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Beju cuaja David chenu puidha batame, daja puana. Diusu ja Cristo id'emetaibana, ecuanaju bana. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Cielo su Tata Diusu sa bai eni bene putibana. Diusu ja tueda huaraji aida atana. Huaraji aida putsu, Cristo ja Espíritu Santo tucheda beitutana ecuana peje su. Cuaja biahua tiempo Diusu ja mesa jamitsuti tiataidha batame, daja ecuana yatani. Ye micuaneda ebainia, eid'abainia nimetiuda ai cuana beju da mu Espíritu Santo ja yatani. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Aimue David chenu quitaji cielo su tsuatidha mahue. Cristo jepuiti bahui mimidha. Uja deretaidha: Tata Diusu ja quema Echua Puji uja mitsutana: “Aniuteque quema bai eni bene ema neje ");
INSERT INTO tnaNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tupupai ecuatsasia epu puji, yama mi neje jamajaiti cuana pishitiame putsu, mique eme su eicha teje.” ");
INSERT INTO tnaNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","‘Da putsu, pamapa israelita cuana bahue papuenita micuaneda Jesús manuameana biame, tueda huecha Diusu ja Echua Puji Salvador ichatana. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Beju cristiano cuana ja Pedro sa quisa id'aba putsu, ebia su jatacuamadhatitana huecuana. Uja quisabatana huecuana apóstol cuana: —¿Jucuaja ni ecuanaju pu cua? ");
INSERT INTO tnaNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Da su Pedro ja jeutsutana huecuana uja: —Mepibaturucatique Diusu peje su. Yahui neje meichaderametique Diusu sa puji Jesús sa ebani su. Da su micuana sa jucha cuana Diusu ja edhipata. Espíritu Santo micuana peje su ebeituta, cuaja mesa jamitsuti puidha batame. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tueda mesa jamitsuti cuana da micuaneseda puji. Micuana sa epusiu utsecua, pia yahua uqueda je aniji cuana sa di. Tueda jamitsuti cuana da pamapa Diusu ihuatana cuana sa puji. Tuna peje su di Espíritu Santo ebeituta. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pedro ja jubida quisatana huecuana: —Menetideraque cristiano madhada cuana jenetia. Jei mepuque Jesucristo peje su. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Da tsine beju quimisha mil cristiano cuana jei putana Jesucristo peje su. Diusu sa puji yahui neje jaichaderametitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Da su apóstol sa jabuetsuati cuana su puniunetitana huecuana. Saida huamahuama jadusutitana huecuana. Daja hue jadhitatitana huecuana Diusu emitsu puji, Echua Puji sa cena di edia puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Pamapa cristiano cuana nimetiunetitana, Diusu ja apóstol cuana ai nimetiuda saida cuana yametani ba putsu. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Pamapa Cristo peje su jei eputani cuana daja hue saida huamahuama jadunetitana. Tuneda cama jatsahuatitana. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Piada piada cuana mesa ai cuana jairutitana pia chipilu mahue cuana etia puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Pamapa tsine templo su putitana huecuana Diusu emitsutsua puji. Tuna sa ete cuana su jadhitatitana beidaji, nimemitsida neje ediadia puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Diusu mitsutsuatana huecuana. Cristiano cuana ja pamapa jei eputani cuana saida batana. Pamapa tsine Cristo ja pia cristiano cuana d'eji su atana. Da su tu peje su jei eputani cuana jajucuatitana beju. ");
INSERT INTO tnaNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Pia tsine buepatia badeute su, Pedro, Juan detse templo su putiana. Da hora su judío cuana templo su jadhitati bahue putaina Diusu emitsu puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Templo sa enubiji da Ania Chidi banime puina. Dapia deja tida anina. Daja hue tida bataji puana. Templo su enubitani cuana chipilu baja bahue puina. Mesa eshanapa cuana ja pamapa tsine templo sa enubiji su dusutaina. ");
INSERT INTO tnaNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Beju Pedro, Juan detse templo su enubihu cama, deja tida ja chipilu bajatana tse. ");
INSERT INTO tnaNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Da su Pedro, Juan detse ja deja chamatana. Chama putsu, Pedro ja uja deja cuatsasiatana: —Chamaque etseju. ");
INSERT INTO tnaNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Da su deja ja chamatana tse, ahua tuatseda chipilu etiata pepe. Pedro ja daja hue quisainiame atana deja uja: ");
INSERT INTO tnaNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","—Aimue quema chipilu yani mahue biame, jiahue yama mi etsahua. Jesucristo Nazaret ejude jenetia sa ebani su mi yama ecuatsasiainia, netianaque, aseque. ");
INSERT INTO tnaNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Da su Pedro ja deja sa bai eni eme su ina putsu, rirenetianatana. Da hora su mesa ehuatsi, madataji detse jatucheatiana. ");
INSERT INTO tnaNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Deja tenanetiana putsu, asepiruana. Da su Pedro, Juan detse neje templo su nubiana. Etenatsuani je, Diusu mitsutsuapirutana jubida. ");
INSERT INTO tnaNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Beju pamapa cristiano cuana ja deja saisijiji batana. ");
INSERT INTO tnaNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Tueda templo sa enubiji su chipilu bajabajaina bahueta huecuana putsu, nimetiunetitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Pamapa cristiano cuana templo sa etetihue ema su jududutitana eba puji. Tueda etetihue ema da Salomón sa Etetihue Ema banime. Dapia deja saisijiji ja Pedro, Juan detse emesiatani batana huecuana. Da su nimetiunetitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pedro ja cristiano cuana ba putsu, uja atana huecuana: —Israelita deja cuana, ¿jucuaja su ni micuana enimetiuni? ¿Ai etseju ye deja asemeitia bata? ¡Mahue! Diusu ja ye deja asemetaitia. ");
INSERT INTO tnaNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","14","Ecuana sa tata Abraham, Isaac, Jacob chenu cuana sa Diusu ja ye ai nimetiuda ataitia. Jesús da tusa Ebacua. Tata Diusu ja Jesús ebia su aida atana pamapa cristiano cuana butse su. Micuaneda Jesús huaraji aida Pilato peje su menajatiana. Jesús da nimebutsepi, jucha mahue putsu, Pilato ja mesiaja adhaatana. Beju micuaneda tsada mue bana. Micuaneseda tsada puana Pilato ja deja manuameji pamesiata. ");
INSERT INTO tnaNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jesús ja ecuana eid'e yametani biame, micuaneda tueda manuameana. Beju Diusu ja tueda id'emetaibana. Ecuanaju tueda eid'e bana. ");
INSERT INTO tnaNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Tu peje su etseju enimetucheatiani putsu, ye deja tida saisiamejiji. Hue micuaneda beju echamainia. Jiahue micuana sa jachamati butse su beju deja saisiametaitia Diusu ja. ");
INSERT INTO tnaNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","‘Edue judío cuana, bahue ema micuaneda micuana sa huaraji cuana neje Jesús manuameana shanapasetaji mahue Jesús da Diusu sa Jabeituti Deja. ");
INSERT INTO tnaNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Beju Diusu ja Jesús sufri ametana, cuaja mesa profeta chenu cuana mimiametaidha batame. ");
INSERT INTO tnaNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Da su jiahue meturucatique micuana sa japibati madhada cuana. Mesiapatique Tata Diusu peje su. Daja a putsu, Diusu ja micuana sa jucha cuana edhipata. ");
INSERT INTO tnaNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ahua micuaneda daja ya su, Diusu ja micuana ebia su eibunebata, micuana peje su Jesucristo ebeituta. Diusu ja tueda micuana sa Salvador biahua tiempo jenetia ichataidha. ");
INSERT INTO tnaNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Tueda Jesús cielo su mesa ani taji, que tupu Diusu ja pamapa ebasetapeta teje. Daja Diusu puidha, mesa profeta chenu cuana deretaidha. ");
INSERT INTO tnaNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisés ja ecuaneseda tata chenu cuana uja quisataidha: “Ecuana sa Tata Diusu ja ema ichatana micuana ehuidusu puji. Ema tije da Diusu ja pia profeta israelita cuana duju jenetia edhareta micuana ehuidusu puji. Jei meaque pamapa tu cuaja emimiani cuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Quebata cuana ja tu id'abaja mahue Diusu ja ematsetayu. Mesa dharejiji israelita cristiano cuana peje jenetia jemicuina putsu, etaitanametayu huecuana.” ");
INSERT INTO tnaNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","‘Biahua tiempo profeta Samuel chenu mimipiruidha tueda ai cuana jepuiti. Pamapa tu tije profeta chenu cuana di tueda ai cuana jepuiti mimitaidha. ");
INSERT INTO tnaNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Diusu ja mesa profeta chenu cuana tiataidha jamitsuti cuana da micuaneseda puji. Micuana sa saida puji Diusu ja ecuana sa tata chenu cuana mesa jamitsuti tiataidha. Uja Diusu ja ataidha tata Abraham chenu: “Yama pamapa yahua aniji cristiano cuana eibuneba mique epusiu tije familia cuana jepuiti.” ");
INSERT INTO tnaNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Diusu ja mesa Ebacua id'emetaibana su, equene micuana peje su beitutana micuana eibuneba puji, micuaneda micuana sa ai puiti madhada cuana eichadera puji. Daja Pedro ja Jerusalén ejude su aniji cristiano cuana quisatana. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Beju Pedro, Juan detse ja cristiano cuana daja equisatani cama, piada piada sacerdote, saduceo cuana cuinatana. Templo sa soldado cuana sa echua puji di tuna neje cuinatana. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ebia su duininitana huecuana Pedro, Juan detse neje, Diusu ja Jesús id'emetaibana cristiano cuana ebuetsuatani tse putsu. Daja huecha cristiano cuana di id'etayu cua, Cristo peje su jei pu putsu, ebuetsuatani tse. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Da su beju Pedro, Juan detse inatana huecuana. Beju apunana putsu, teriichatana huecuana pia tsine equisaba puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Cristiano cuana Pedro, Juan detse sa mimi cuana id'abata putsu, jucuada jei Cristo peje su putana. Jei putana deja cuana beju pishica mil pucue putana. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pia tsine huaraji, tata edhi ehuidusuji, Diusu sa jacuatsasiati ebuetsuaji cuana jadhitatitana Jerusalén ejude su. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Tuna neje Anás anina. Tueda da pamapa sacerdote cuana sa echua puji aida puina. Mesa ebacua Juan, Alejandro detse di dapia anina. Mesa ebaquepuna sa yahue Caifás di anina. Anás sa pia familia cuana anitaina. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Da su cuatsasiatana Pedro, Juan detse tuna butse su paduseta huecuana puji. Duse putsu, tuna butse su netianametana tse. Uja quisabatana huecuana: —¿Ai sa jacuatsasiati su metseda ye ai cuana yainia? ");
INSERT INTO tnaNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","Da su Espíritu Santo ja Pedro jeutsutsahuatana uja: —Huaraji cuana, tata edhi ehuidusuji cuana, micuaneda etseju equisabainia cuaja tueda deja tida saisime puana. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Da su etseju micuana equisainia pamapa israelita cristiano cuana di bahue paputa. Ye deja tida micuana butse su eneti beju Jesucristo Nazaret ejude jenetia ja saisiametana. Tueda Jesús quitaita micuaneda curusu su tatana biame, Diusu ja id'emetaibana. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","12","Micuaneda da ete muduji yapiruji tumu madhabaji cuana nime. Daja nime micuaneda Cristo ana. Micuaneda madhabana biame, Diusu ja tueda dharetana cristiano cuana D'eji su Aji papu puji. Aimue ye mundo su pia yani mahue cristiano cuana d'eji su ya puji. Aimue Diusu ja pia ebani ichatana mahue. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Beju tueda dhitajiji huaraji cuana nimetiutana Pedro, Juan detse ja huaraji mimi neje jeutsutana huecuana su. Tuatseda jabuetsuatiji mahue biame, daja saida jajeutsutiana tse batana huecuana. Da su beju shanapatana huecuana ye detse tuqueda Jesús sa ebuqueji puina. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ed'eji su deja saisijiji tuatse neje eneti ba putsu, cuaja mimi taji mahue jabatitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Da su soldado cuana cuatsasiatana huecuana tueda quimisha deja cuana ubu hora puji pajemicuinata huecuana puji, tuneda cama tueda ai cuana equisati puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Jaquisabatitana huecuana uja: —¿Cuaja ni da ecuaneda ye deja detse a cua? Beju nimetiuda aida atana tse. Cuaja su biame bid'umimi pu taji mahue, pamapa Jerusalén ejude su aniji cristiano cuana ja batana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pacuatsasiatija jubida neje ye deja detse aimue neicha Jesucristo jepuiti pamimi mahue puji. Da su cristiano cuana tueda nimetiuda aida setata cua beju. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Da su ihuatana quimisha deja cuana padusetaicha huecuana puji. Duse putsu, huaraji cuana ja jubida cuatsasiatana huecuana: —Jiahue jenetia beju be neicha aidhe peje su Jesucristo jepuiti mimiji. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Da su Pedro, Juan detse ja jeutsutana huecuana: —Mepibaenique, ¿quebata da ebia su saida Diusu butse su, ahua Tata Diusu etseju eid'aba, ahua micuaneda? ");
INSERT INTO tnaNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Cuaja ai etseju bana, id'abana cuana cuaja detse etseju quisa purijime pu cua. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Da su neicha jubida huaraji cuana ja quisatana huecuana: —Ahua micuaneda tueda ai cuana quisa epuriji mahue su, ecuanaju micuana ecastigayu. Da su mesiatana huecuana. Aimue castigatana huecuana mahue, cristiano cuana ja Diusu jubida mitsutsuatana putsu, Pedro, Juan detse ja deja tida saisiametana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Beju deja saisijiji sa pushi tunca mara ejaitiana tupu anina putsu, tueda nimetiuda aida puitia bata. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Da su Pedro, Juan detse d'eji su puana su, tuatse sa ebuqueji cuana peje su putiana. Cuaja sacerdote aida, tata edhi ehuidusuji cuana putana tuatseda quisatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Da su beju pamapa tueda ai cuana id'aba putsu, beidaji neje Diusu mitsutana huecuana uja: —Ecuana sa Tata Diusu, miada buepa, yahua, mar aida ichaidha. Pamapa ai cuana miada ichaidha. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Biahua tiempo Espíritu Santo ja mique emebajaji David chenu deremetaidha mique ai puidha cuana. Uja deremetaidha: ¿Jucuaja su pamapa ejude aniji cuana enimetipeitani? ¿Jucuaja su yanacane ai cuana epibatani huecuana? ");
INSERT INTO tnaNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ye mundo sa echua puji cuana, pamapa ejude cuana sa huaraji cuana jadhitatitana Tata Diusu, Cristo detse neje emajaiti puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","‘Upia Jerusalén ejude su echua puji Herodes, Poncio Pilato detse judío mahue extranjero, israelita cuana neje jadhitatitana mique Ebacua butsepi Jesús neje emajaiti puji. Miada huaraji aida puji Jesús ichana biame, tu neje duininitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Cuaja miada biahua tiempo su pibana batame, daja atana huecuana Jesús. Cuaja miada tsada baidha, beju daja puana. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Jiahue baque cuaja ecuanaju eduininibatani huecuana. Madhada aja yatani huecuana. Nimetucheaque ecuanaju mique quisa saida cuana cristiano cuana peje su quisaquisa epu puji iyuame mahue neje. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Cristiano cuana saisiameque. Ai nimetiuda cuana aque mique Ebacua Jesús sa ebani su. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Da su Diusu mitsupe putsu, tuna yanita ete riariapiruana. Espíritu Santo ja nimetucheametana huecuana. Da jenetia mue mecuana sa iyuame putana Diusu sa quisa saida cuana cristiano cuana peje su quisaquisa epu puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Beju pamapa Jesús peje su jei eputani cuana da dunejiji anitaina. Tuna sa ai chidi cuana tuneda cama jatiatitaina. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Apóstol cuana da Diusu sa tucheda neje daja hue quisaquisa puderatana. Jesús id'eibana quisa cuana beju quisaquisa putana huecuana cristiano cuana peje su. Diusu ja ebia su ibunebatana pamapa jei eputani cuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Jei eputani edue cuana sa mue ai biame pishihue pu. Piada piada cuana ja mecuana sa yahua, ete cuana irutana. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Iru putsu, chipilu apóstol cuana tiatana edue puri cuana etsahua puji. Da su apóstol cuana ja tueda chipilu berereatiatana edue cuana peje su cuaja mecuana sa ai ehueitiani batame ai chidi cuana pishihue papu mahue puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Beju anina piada deja José banime. Tueda da Leví sa familia jenetia. Chipre edhapupu su bataji puana. Apóstol cuana ja tusa pia ebani Bernabé ichatana. Tueda ebani da, Nimebeida Jaametiji, epuani. ");
INSERT INTO tnaNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Tuahueda mesa piada yahua irutana. Iru putsu, chipilu tiatana apóstol cuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Beju piada deja anina Ananías banime. Mesa ehuane Safira banime puina. Tuatseda yahua irutana. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Iru putsu, quejucua chipilu ichasetatana tse. Dajucua chipilu apóstol cuana tiatana tse pamapa pu cua nime. Da su uja Ananías apóstol cuana quisatana: —Yama micuana etiainia pamapa chipilu beju. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Da su Pedro ja tueda atana: —Ananías, Ishahua ja piba madhada mi ametana. Miada Espíritu Santo bid'umimi aitia, quejucua chipilu ichaseta putsu. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tueda miada iruana yahua miqueda puana. ¿Da chuje chipilu inatsuana aimue jia maida miqueda puana mahue? ¿Ai puji mida, “Pamapa chipilu micuana yama etiainia”, bid'umimi puitia? Bid'umimi miada aitia Diusu, aimue deja mahue. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Tueda mimi cuana id'aba putsu, Ananías emanu dajajana. Pamapa bahue putana cuana rubutanatana. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Edeahue cuana Ananías sa equita babubabuatana. Babu putsu, dusutana huecuana epapati puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Da su quimisha hora jaitianana su, Safira cuinana. Bue mahue puina Ananías manuitia. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Da su Pedro ja quisabatana tueda: —Quisaque ema, ¿a da metse ene quita dajucua su iruitia yahua? Safira jeutsutana: —Ehe. Dajucua su etseju iruana beju. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Da su Pedro quisabatana: —¿Ai puji metseda betana su Espíritu Santo bid'umimi aitia? Beju jiahue quita ecuinatasa mique yahue dusuji cuana mida macha edusu puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Da hora su beju emanu dajajana Safira. Edeahue cuana cuina putsu, epuna emanu esa batana huecuana. Da su dusutana huecuana mesa yahue naja su epapati puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Beju pamapa jei eputani, id'abaji cuana ebia su rubutanatana. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Apóstol cuana ja jucuada ai nimetiuda cuana daja hue aniunetiatana cristano cuana duju su. Jei eputani cuana Salomón sa Etetihue Ema su jadhitati bahue putaina. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Pia cristiano cuana aimue tuna nariaja atana mahue, tuna saida ebatani biame. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Jucuada deja, epuna cristiano cuana Echua Puji Jesucristo peje su jei putana. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Cristiano cuana nedaji cuana ichacuinatana d'eji su siju bia su tsaunuji huanacuinatana. Cuapuitime Pedro ejaitianani su, mesa tanana tuna bia je dajaja cua, pasaisita huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Pia Jerusalén ejude naja je ejude cuana jenetia cristiano cuana cuinatana Jerusalén ejude su. Tuna sa nedaji cuana dusetana huecuana. Einid'u madhadaji cuana di dusetana huecuana. Beju pamapa saisitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Da su beju sacerdote sa echua puji aida, saduceo cuana duininitana, cristiano cuana ja apóstol cuana tije yatani putsu. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Da su apóstol cuana ina putsu, teriichanubiatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Dhidha su Diusu sa ángel ja tuna teriichajiji yani ete tsequed'iatana. Apóstol cuana huidusutana etseque su. Angel ja uja atana huecuana: ");
INSERT INTO tnaNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Meputique templo su. Daja hue quisaquisa puderaque Diusu sa quisa eichacua cuana cristiano cuana peje su. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Da su apudaya enieni putitana huecuana templo su. Dapia buetsuapirutana cristiano cuana. Beju sacerdote cuana sa echua puji aida, tu buqueji, tata edhi ehuidusuji cuana jadhitatitana. Soldado cuana beitutana huecuana apóstol cuana tuna butse su eduse puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Beju soldado cuana apóstol cuana teriichajiji yani su cuinati putsu, apóstol cuana mue ani batana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Da su jasiapatitaibana huecuana tuna equisa puji uja: —Ete etsequeini cuana saida terijiji ecuanaju bana. Einatsihuaji soldado cuana etsequeini su netitana biame, ete dume su mue aidhe biame beju ecuanaju bana. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Da su sacerdote sa echua puji aida, templo sa soldado cuana sa echua puji, sacerdote aida cuana daja id'aba putsu, cuaja shanapa taji mahue batana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Da hora su piada deja tuna peje su cuinana. Cuina putsu, uja quisatana huecuana: —Micuana teriichanubiana deja cuana da templo su yanita. Cristiano cuana ebuetsuatani huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Da su soldado sa echua puji, mesa soldado neje apóstol cuana peje su putiana tuna einatiicha puji. Cuatsa mahue dusutana huecuana, cristiano cuana iyuba huecuana putsu. Cuapuitime cristiano cuana ja tuna tumu neje maracata cua, japibatitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Neicha apóstol cuana dusutana huecuana huaraji cuana peje su. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Da su apóstol cuana jubida d'ayapirutana huecuana uja: —Ecuaneda micuana be neicha Jesús jepuiti cristiano cuana buetsuaji cuatsasiana. Beju aimue micuaneda ecuana jei ana mahue. Jiahue beju pamapa Jerusalén ejude aniji cristiano cuana micuana sa jabuetsuati cuana id'abatana. Micuaneda ecuanaju etuaquisainia cristiano cuana butse su. Daja pa micuaneda epuani, ecuanaju pa da tueda deja Jesús manuameana. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Da su Pedro ja pia apóstol cuana neje jeutsutana huecuana uja: —Ecuanaju sa mu Diusu id'aba taji, aimue deja cuana mahue, daja ecuanaju sa jacuatsasiati putsu. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Micuaneda Jesús manuameana, curusu su tata putsu. Beju ecuana sa tata chenu sa Diusu ja mu tueda id'emetaibana. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Cielo su tu naja su dusutaibana. Israel sa Echua Puji D'eji su Aji tueda ichatana. Jiahue micuana sa jucha cuana dhipata cua, ahua micuana sa piba madhada cuana jenetia eturucati su. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ecuanaju da tueda ai cuana quisanetiacuinaji. Daja huecha Espíritu Santo. Tueda Espíritu Santo Diusu ja pamapa tu jei yatani cuana peje su beitutana. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Da su beju huaraji aida cuana ja daja id'aba putsu, ebia su duininitana huecuana apóstol cuana neje. Piada piada tuneda manuameja atana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Daja biame, piada fariseo Gamaliel banime tuna duju su anina. Tuseda tsada mahue puana pamanuameta huecuana puji. Moisés sa jacuatsasiati ebuetsuaji puina. Pamapa cristiano cuana ja tueda ibuneda bataina. Netiana putsu, cuatsasiatana apóstol cuana etseque su pajemicuinata huecuana ubu hora chidi. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Beju apóstol cuana etseque su yanita su, tuahueda judío cuana sa huaraji cuana uja apirutana: —Deja israelita cuana, meid'abaque ema. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Mepibaenitique. Merejatique cuaja micuaneda ye deja cuana ya. ¿Aimue jia maida micuaneda piba deja Teudas banime mahue? Tueda deja aida puja puana. Pushi cien deja cuana ja tu buquetaina. Beju soldado cuana ja manuametana su, tusa ebuqueji cuana jaberebereatitana. Tusa jabuetsuati cuana setatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Tueda ai cuana jaitianatana su, censo anina. Da tiempo pia deja Judas banime bataji puana Galilea yahua jenetia. Tueda di deja aida puja puana. Da su neicha jucuada deja cuana tije ataina. Soldado huaraji cuana neje jamajaititana huecuana. Daja huecha soldado cuana ja manuametana su, tusa ebuqueji cuana beju jaberebereatitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","39","Beju jiahue quita yama micuana equisainia, be madhada meaji ye deja cuana. Ahua tuneda Tata Diusu sa deja cuana su, da su, ¿ai puji detse micuaneda madha cua huecuana? Aimue detse micuaneda pishitia cua huecuana mahue. Cuapuitime Tata Diusu neje hue micuaneda jamajaiti cua. Ahua aimue tuneda Diusu sa deja cuana mahue su, ahua deja aida puja bahui eputani huecuana su, da su cuaja Teudas, Judas detse puana nime etaitanata huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Daja Gamaliel ja quisapetana huecuana su, jei putana huecuana. Aimue apóstol cuana manuametana huecuana mahue. Da su apóstol cuana padusetaicha cuatsasiatana huecuana. Dusutana huecuana su, huacabiti neje ichemetana huecuana. Mesiaji mahue su, jubida cuatsasiatana huecuana uja: —Jiahue jenetia su be neicha aidhe peje su Jesucristo jepuiti mimiji. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Da su beju apóstol cuana cuinanana. Ebia su beidaji puana, Jesús sa puji sufri ametana huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Da su pamapa tsine templo su putitana huecuana cristiano cuana Jesús jepuiti ebuetsua puji. Pamapa ete je di putitana huecuana Diusu sa quisa saida cuana ebuetsua puji. Diusu ja, cuaja tu puidha batame, Jesús beitutana cristiano cuana D'eji su Aji papu puji buetsuatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Da tiempo su Cristo peje su jei eputani edue cuana dueji anitaina. Ebia su jajucuatitana huecuana. Beju judío jei eputani cuana duju su pia Grecia yahua jenetia edue cuana di anitaina. Griego yana su mimitaina huecuana. Aimue beidaji puana huecuana mahue, judío edue cuana ja aimue saida batana huecuana mahue putsu. Uja atana huecuana: —Aimue micuaneda griego ahue manujiji epuna edue cuana saida equinainia mahue. Tuna sa ediaji cuana aimue tupu etiainia mahue. ");
INSERT INTO tnaNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Da su piada tunca beta ejaitiana apóstol cuana ja dhitametana huecuana pamapa. Uja quisatana huecuana: —Edue cuana, ecuanaju sa Diusu sa quisa saida cuana buetsua taji. Aimue detse ecuanaju buetsuariji cua mahue edue cuana sa ai dia taji cuana eba puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Da su micuaneseda siete deja butsepi, bahue eni cuana icha taji edue cuana sa ai dia taji cuana pabata huecuana puji. Espíritu Santo sa tucheda mecuana sa paanita. Edue cuana ja saida pabata huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Da su ecuanaju sa Diusu neje bahui jamitsuti taji. Tusa quisa cuana ecuanaju sa cristiano cuana quisaquisa pu taji bahui. ");
INSERT INTO tnaNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Beju pamapa edue cuana daja cama japibatitana. Siete deja cuana dharetana huecuana. Uja mecuana sa ebani cuana: Esteban. Tuahueda Diusu peje su ebia su enimetucheatiani. Espíritu Santo sa tucheda ebia su mesa anina. Felipe. Prócoro. Nicanor. Timón. Parmenas. Nicolás. Antioquía ejude jenetia puina. Judío mahue puina. Equene Antioquía ejude su judío cuana sa Diusu peje su jei puana. ");
INSERT INTO tnaNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Da su beju apóstol cuana butse su netiatana huecuana. Apóstol cuana ja mecuana sa eme siete deja cuana sa echua bia su icha putsu, Diusu bajatana tuahueda paibunebata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Beju dueji cristiano cuana Diusu sa quisa saida cuana id'abatana. Jerusalén ejude su Cristo peje su jei eputani cuana ebia su jajucuatitana. Jucuada sacerdote cuana di Jesús peje su jei putana. ");
INSERT INTO tnaNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Diusu ja Esteban tucheametana ebia su ai nimetiuda cuana ya puji cristiano cuana duju su. ");
INSERT INTO tnaNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Da su beju piada piada deja cuana Esteban neje mimicuicuinapirutana. Judío cuana sa jadhitati jude ete jenetia puetana huecuana. Tueda jadhitati jude ete Esclavo D'eji Pujiji Cuana sa banime. Cirene, Alejandría ejude detse, Cilicia, Asia yahua detse jenetia puetana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Beju jubida mimicuicuinatana huecuana biame, Esteban tuna ebia su saida mimiana Espíritu Santo ja tueda saida, butsepi jeutsumetana huecuana putsu. Cuaja tuchea taji mahue batana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Da su pia deja cuana chipilu tiatana huecuana. Cuatsa mahue uja quisatana huecuana: —Cristiano cuana uja mequisatique: Ecuanaju Esteban id'abaitia Diusu, Moisés chenu sa puji madhada puitia. ");
INSERT INTO tnaNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Da su tata edhi ehuidusuji, Moisés chenu sa jacuatsasiati ebuetsuaji cuana Esteban neje duinini putsu, inatana huecuana dhitajiji huaraji aida cuana peje su edusu puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Deja bid'umimi puji cuana di dusutana huecuana Esteban bid'umimi neje patuaquisata huecuana puji. Uja putana huecuana: —Ye deja Diusu sa templo sa puji, Moisés chenu sa jacuatsasiati cuana sa puji madhada hue puitia. ");
INSERT INTO tnaNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ecuanaju tueda id'abaitia uja puitia: “Ye templo iyuda pa da Jesús Nazaret ejude jenetia ja ejusiauteta. Tueda pa da Moisés chenu ja ecuana tiataidha ai puiti cuana Jesús ja eturucata.” ");
INSERT INTO tnaNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Da su pamapa dapia yanita cuana ja Esteban jubida chamatana. Mesa ebu da ángel sa ebu nime cuarecuare batana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Da su sacerdote sa echua puji aida ja Esteban quisabatana uja: —¿A da ene mi etuaquisatani huecuana? ");
INSERT INTO tnaNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Da su Esteban ja uja jeutsutana huecuana: —Judío deja, tata edhi cuana, meid'abaenique ema. Biahua tiempo ecuana sa tata Abraham chenu Mesopotamia yahua su anidha. Dapia anitaidha cristiano cuana caldeo banime puidha. Dapia tu peje su ecuana sa Tata Diusu Aida bataji puidha. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Uja Abraham chenu cuatsasiataidha: “Anideraque ye yahua jenetia. Mique edue cuana ichajusiaque. Putiyuque yama mi ebameti yahua su.” ");
INSERT INTO tnaNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Da su Abraham chenu caldeo cuana sa yahua jenetia aniderataidha. Haran yahua su putiana dapia yaniti puji. Dapia tusa tata manuidha su, upia ye ecuana sa yahua su Diusu ja tueda beitutaidha. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Da tiempo su aimue Diusu ja Abraham chenu yahua tiataidha mahue. Aimue etidhiti puji biame tiataidha mahue yahua. Beju Tata Diusu ja uja mitsutaidha Abraham chenu: “Mida, mique tije epusiu familia cuana ye yahua yama etia.” Daja Diusu puidha, Abraham chenu sa ebacua cuana anidha mahue su. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Diusu ja Abraham chenu daja hue quisainiame ataidha uja: “Pia cuana sa yahua su yama mique tije epusiu familia cuana ebeitu tuna sa esclavo cuana epu puji. Dapia aniji cuana ja nedaneda yatayu huecuana. Pushi cien mara cuana puji beju esclavo eputa huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Da putsu, tueda yahua su aniji cuana yama ecastigayu, mique tije epusiu familia cuana nedaneda ametana putsu. Da su mique tije epusiu familia cuana tueda yahua emesia putsu, upia yahua su epueta huecuana ema emitsutsua puji.” Daja Diusu ja Abraham chenu ataidha. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Da su beju Diusu ja Abraham chenu cuatsasiataidha: “Pamapa bataji epuani deja cuana huitsanasiqui taji. Daja a putsu, quema puji eputa huecuana. Da su beju Abraham chenu sa ebacua Isaac bataji puidha su, huitsanasiquitaidha ocho tsineji beju su. Isaac ja daja huecha mesa ebacua Jacob ataidha, bataji puidha su. Jacob ja di mesa piada tunca beta ejaitiana ebacua cuana daja huecha ataidha. Tueda ebacua cuana pamapa ecuana sa tata cuana putaidha. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","‘Jacob ja José pia ebacua cuana ebia su ibunebataidha putsu, José neje duininitaidha huecuana. Da su beju José inataidha huecuana Egipto deja cuana peje su eiru puji. Deja cuana ja baja putsu, José Egipto yahua su dusutaidha esclavo epu puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Daja biame, Diusu ja José inatsihua putsu, d'eji su ataidha. Diusu ja Egipto yahua sa echua puji José saida bametaidha. José tiataidha tu pamapa ai bahue epu puji. Da su echua puji ja José Egipto huaraji aida ichataidha. Daja huecha mesa ete su puji huaraji aida ataidha. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","‘Da tiempo su beju Egipto, Canaán yahua detse su mid'e puidha putsu, cristiano cuana ebia su sufri putaidha. Ecuana sa tata chenu cuana sa ai dia taji mahue putaidha. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Da su Jacob Egipto su ai dia taji cuana yani bahue puidha su, mesa ebacua cuana dapia equene puji beitutaidha. José da deja beju puina putsu, mue shanapa mesa edue cuana ja. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Neicha beta nuati puji hue Egipto yahua su putitaidha huecuana su, José ja quisataidha huecuana uja: “Ema da micuana sa edue José.” José ja mesa edue cuana echua puji aida shanapametaidha. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Da su José ja jemiametaidha mesa tata, pamapa edue cuana Canaán yahua jenetia Egipto yahua su. Beju siete tunca pishica ejaitiana cristiano cuana puidha. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Da su beju Jacob Egipto yahua su cuinaidha. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Dapia manuidha, mesa piada tunca beta ejaitiana ebacua cuana neje. Canaan yahua Siquem ejude su dusutaidha huecuana tumu epa su sepulcro cuana ajiji ehuananubia huecuana puji. Equene Abraham chenu ja tueda sepulcro eti jude Hamor chenu sa ebacua cuana bajataidha Siquem ejude naja su. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","‘Beju tiempo cuinaidha Tata Diusu ja ecuana sa tata chenu cuana Egipto yahua jenetia ehuidusuta, cuaja Diusu ja Abraham chenu jamitsuti tiataidha batame. Dueji jajucuatitaidha huecuana Egipto yahua su. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Da tsunu pia Egipto yahua sa echua puji anidha. Tuahueda mu mue José shanapa ataidha. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nedaneda ataidha ecuana sa tata chenu cuana. Cuatsasiataidha ecuana sa tata chenu cuana mecuana sa yanana cuana pajusiata pamanupeta huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Da tiempo su Moisés chenu bataji puidha. Diusu ja tueda saida bataidha. Quimisha badi mesa tata detse quinataidha. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Beju d'iti su yanana icha putsu, ena bia su ichataidha tse. Echua puji sa ebaquepuna ja yanana d'iti dume su ebade ba putsu, mesa ete su dusutaidha mesa ebacua quitaita nime esehuame puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Pamapa Egipto yahua su aniji cuana sa ai puiti cuana, sehua putsu, jabuetsuatidha. Deja aida puidha. Mimi neje cristiano cuana jei ame bahue puina. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","‘Beju pushi tunca maraji su, putidha mesa edue cristiano israelita cuana ecuadhibati puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tuna peje su cuinati putsu, piada egipcio deja ja israelita deja eichetani bataidha. Da su beju israelita deja bianetiataidha, egipcio deja manuametaidha putsu. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisés chenu tuna jei yata pepe puidha tuna sa ehuidusuji epu puji. Tueda tuna jei yata pepe puidha Diusu ja tueda beitutaidha tuna d'eji su ya puji. Beju aimue daja mecuana sa piba puidha mahue. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Pia tsine neicha putiana. Beta israelita detse eichetisa bataidha. Uja quisataidha tse: “Be meichetiji, metseda edue tatse hue putsu. ¿Jucuaja metse eichetiani?” ");
INSERT INTO tnaNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Da su edue icheji deja ja Moisés chenu nunu putsu, uja ataidha: “¿Aiya mida ecuanaju sa ehuidusuji ichatana? ");
INSERT INTO tnaNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿A da miada ema emanuame, cuaja miada egipcio deja manuameja puicha nime?” ");
INSERT INTO tnaNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Da su Moisés chenu jududuidha, tueda mimi id'aba putsu. Madián yahua su putidha extranjero nime yaniti puji. Dapia jahuaneti putsu, beta bacuame puidha. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","‘Beju pushi tunca mara Moisés chenu d'anita yahua su anidha. Tueda d'anita yahua Emata Sinai banime naja su anidha. Dapia Diusu ja Moisés chenu mitsutaidha. Moisés chenu equi eutsuneti bataidha. Eutsuneti biame, mue jajuditi equi. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Da su Moisés chenu nimetiuidha. Nariataidha equi eba puji. Da su Diusu sa etsui id'abataidha equi jenetia. Uja Diusu ja ataidha: ");
INSERT INTO tnaNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Ema da mique tata chenu cuana sa Diusu. Ema da Abraham, Isaac, Jacob chenu cuana sa Diusu.” Da su Moisés chenu riariapiruidha, iyuame putsu. Echama puji di iyubataidha. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Diusu ja tueda cuatsasiataidha: “Jahuijatique mique pulucu, yahua iyuda mi etidinetia putsu. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yama bana cuaja egipcio deja cuana ja quema israelita cristiano cuana nedaneda yatani. Daja huecha yama id'abana tuna sa tsiatsia cuana. Beju u hue ema yani tuna d'eji su ya puji. Mi yama Egipto yahua su ebeitu.” ");
INSERT INTO tnaNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","‘Equene su israelita cuana tsada mahue bataidha Moisés chenu tuna sa ehuidusuji epu puji. “¿Aiya mida ecuanaju sa echua puji ichataitia?” ataidha huecuana biame, Diusu ja tueda huecha ichataidha mecuana sa ehuidusuji epu puji, tuna d'eji su paata puji. Daja Diusu ja Moisés chenu huaratiame ataidha equi eutsuneti jenetia, mitsu putsu. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Da su Moisés chenu ja ecuana sa tata chenu cuana Egipto yahua jenetia jemicuinataidha. Jucuada nimetiuda ai cuana Egipto yahua, Mar Dherena su ataidha. Pushi tunca mara d'anita yahua su eputaniuneti cama, ai nimetiuda cuana ataidha. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Tueda Moisés chenu quitaita ja equene israelita chenu cuana quisataidha uja: “Cuaja Diusu ja ema micuana sa ehuidusuji ichatana nime, daja huecha pia profeta micuana sa edue cuana jenetia edhareta micuana sa ehuidusuji epu puji. Jei meaque pamapa tu cuaja emimiani cuana.” ");
INSERT INTO tnaNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","D'anita yahua su Moisés chenu ecuana sa tata chenu cuana neje anidha. Angel ja Moisés chenu quisataidha Sinai Emata su. Tueda ángel ja Diusu sa jacuatsasiati quitaita cuana Moisés chenu tiataidha ecuana sa tata chenu cuana etiadera puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","‘Beju ecuana sa tata chenu cuana ja jei aja mahue ataidha. Tsada mahue bataidha huecuana Moisés chenu. Neicha hue Egipto yahua sa ai puiti madhada cuana tsada bataidha huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Da su tuneda Aarón ataidha uja: “Moisés chenu Sinai Emata su putiana. Ecuana Egipto yahua jenetia jemicuinatana biame, bue mahue ecuanaju cuaja jia da puitia. Da su aque ecuanaju sa puji pia diusu cuana ecuana pahuidusta puji.” ");
INSERT INTO tnaNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Da su huaca janana eimea ataidha huecuana. Animalo cuana manuametaidha huecuana, huaca janana diusu eimea peje su eirutsua puji. Da su beidaji putaidha huecuana, daja ai cuana yainia je. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Id'eti, badi, atujai cuana mitsutsuataidha huecuana. Da putsu, Diusu ja jusiataidha huecuana. Uja derejiji yani profeta sa quirica su: Israelita cristiano cuana, micuaneda pushi tunca mara d'anita yahua su epuniuneti cama, pia diusu eimea cuana peje su bahui animalo cuana irutsuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Diusu eimea Moloc sa iyuda ete micuana sa anina. Daja huecha diusu eimea Renfán sa atujai eimea micuana mitsutsuana. Tueda eimea cuana micuaneda quitaita ana emitsutsua puji. Da putsu, yama micuana sa yahua jenetia ejemicuinayu Babilonia yahua su ebeitu puji, esclavo epu puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Da su Esteban ja quisainiame atana huecuana uja: —Beju d'anita yahua su ecuana sa tata chenu cuana ja Diusu sa iyuda ete dusutaidha. Da dume su tusa jacuatsasiati cuana ichasetataidha. Cuaja Diusu ja Moisés chenu bametaidha batame, daja ete ataidha huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Josué chenu ja ecuana sa tata chenu cuana huidusutaidha pia yahua su aniji cristiano cuana neje emajaiti puji su, Diusu sa iyuda ete di dusutaidha huecuana. Da tiempo su Diusu ja ecuana sa tata chenu cuana tueda yahua su aniji cristiano cuana jemicuinametaidha tueda yahua ecuana sa tata chenu cuana sa papu puji. Ecuana sa tata chenu cuana ja iyuda ete quinataina echua puji David chenu sa tiempo teje. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Beju Diusu ja David chenu ebia su saida bataidha. Da su David chenu ja Diusu sa templo aida aja adhaataidha. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","David chenu sa ebacua Salomón chenu ja templo ataidha. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Aimue Diusu Aida deja sa jaati ete dume su yani mahue. Tueda jepuiti biahua tiempo Diusu quisa puidha mesa profeta chenu ja quirica su deretaidha uja: ");
INSERT INTO tnaNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Cielo da quema ani jude. Da jenetia yahua su aniji cristiano cuana yama ecuatsasiania. Aimue detse micuaneda quema janahua jude a cua mahue, ema micuana ebia su aida putsu. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Aimue jia maida yama pamapa ai cuana aidha mahue? ");
INSERT INTO tnaNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Da su Esteban daja hue quisainiame atana huecuana uja: —Beju micuaneda da chuatadada Diusu peje su jei puja mahue cuana nime. Jaduininibatiji da micuaneda Diusu id'abaja mahue cuana nime. Espíritu Santo jei aja mahue. Cuaja micuana sa tata chenu cuana ja ataidha nime, daja huecha micuaneda yainia. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Micuana sa tata chenu cuana pamapa Diusu sa profeta cuana madhabataidha. Tueda profeta cuana ja, “Diusu sa Jabeituti Deja butsepi epue”, quisataidha biame, tata chenu cuana ja manuametaidha huecuana. Beju jiahue Diusu sa Jabeituti Deja Jesús pueana. Micuaneda tueda madhaba putsu, manuameana. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Angel cuana ja ecuana sa tata chenu cuana Diusu sa jacuatsasiati cuana tiataidha biame, aimue micuaneda aja yainia mahue. Daja Esteban ja sacerdote aida cuana atana. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Da su beju Esteban sa quisa id'aba putsu, ebia su duininitana huecuana. Jatsedhaititana huecuana, ebia su duinini putsu. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Daja biame, Espíritu Santo ja Esteban nimetucheametana. Esteban buepa huabata jachamati putsu, Tata Diusu aida, tucheda cielo su yani batana. Jesús di batana Diusu sa bai eni bene su eneti. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Da su Esteban ja quisatana huecuana uja: —Mechamaque. Yama buepa ed'ianeti ebainia. Diusu sa Jabeituti Deja Jesús yama ebainia Diusu sa bai eni bene su eneti. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Da mimi cuana id'aba putsu, mecuana sa eid'aja cuana jadunutitana huecuana. Jubida tsiatsiapirutana huecuana. Paije hue Esteban inatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ejude tipe su dusutana huecuana. Dapia cuinati putsu, ebia jud'uji jajemititana huecuana. Da su Esteban maracapirutana huecuana. Tumu siaji cuana ja mecuana sa ebia jud'uji piada deja Saulo banime menajatiatana tuahueda paquinata puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Da su beju emaracataneti huecuan cama, Esteban ja Diusu mitsutana uja: —Echua Puji Jesús, batsuque quema enid'u. ");
INSERT INTO tnaNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Da su tururuneti putsu, tsiatsia neje jubida Diusu bajatana uja: —Echua Puji, be cuaja biame aji ye ema manuameji cuana. Daja pu putsu, emanu dajajana. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Beju Saulo Esteban manuameji cuana neje tupupai japaitiana. Da tsine jenetia Jesús peje su jei eputani cristiano cuana jubida chacupirutana huecuana. Da su pamapa jei eputani cuana jududupetana Judea, Samaria yahua detse su. Apóstol cuana mu Jerusalén ejude su anitaina. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Piada piada Diusu eiyubatani deja cuana ja Esteban papatana. Ebia su japadarititana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Da su beju Saulo ja Jesús peje su jei eputani cuana apeja atana. Ete meamea puniunetiana Cristo peje su jei eputani deja, epuna cuana ina putsu, eteriichame puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Beju jududutana cuana jaberebereatitana pia ejude cuana je. Quepia tuna putiana Diusu sa quisa saida cuana quisatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe piada ejude Samaria yahua su putiana. Dapia cristiano cuana Cristo jepuiti quisaquisa apirutana. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ai nimetiuda cuana di atana. Da su cristiano cuana ja tusa Cristo jepuiti quisa cuana id'abatana. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Felipe ja einid'u madhadaji cuana saisiametana. Einid'u madhada cuana tsiatsia neje cristiano cuana peje jenetia cuinanatana. Ase bue mahue, tida cuana saisimetana. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Da su tueda ejude su aniji cristiano cuana beidaji putana. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","11","Beju tueda ejude su piada deja anina Simón banime. Equene mau puina. Tuahueda cristiano cuana baseataina, nimetiuda ai cuana a putsu. Tueda deja aida jabametina pamapa Samaria yahua su aniji cristiano cuana peje su. Quejucua mara puji cristiano cuana ja tueda aida bataina. Tusa quisa cuana su jei putaina huecuana. Da su pamapa cristiano cuana, chipiluji cuana ja biame tueda id'abaenitana. Uja putaina huecuana: —Diusu ja Simón etucheametani ai nimetiuda aida cuana ya puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Da su beju Felipe Diusu ecuatsasiati, Jesucristo jepuiti quisaquisa puana su, jucuada deja, epuna cuana tusa quisa cuana su jei putana. Yahui neje Diusu sa puji jaichaderatitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Beju Simón di jei puana. Yahui neje Diusu sa puji jaichaderati putsu, Felipe buquepirutana. Tueda nimetiuana, Felipe ja ai nimetiuda aida cuana atana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jerusalén ejude su aniji apóstol cuana ja Samaria yahua su aniji cristiano cuana Diusu sa quisa saida cuana su jei putana id'abatana su, Pedro, Juan detse beitutana huecuana Samaria yahua su pabatita tse puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Cuinati putsu, Diusu bajatana tse tuahueda tuna peje su Espíritu Santo pabeituta puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Yahui neje Diusu sa puji Echua Puji Jesús sa ebani su jaichaderametitana huecuana biame, Espíritu Santo mue cuina tsuhu puana tuna peje su. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Da su Pedro, Juan detse ja jei eputani cuana sa echua bia su tuatse sa eme huanatana su, Espíritu Santo tuna peje su cuinana. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Beju Simón ja batana su, apóstol detse chipilu tiaja atana. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Uja bajatana tse: —Cuaja ame ye nimetiuda aida buetsuaque ema yama di daja ya puji, quebata cristiano bia su quema eme huana putsu, Espíritu Santo tu peje su pacuina puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Da su Pedro ja Simón atana: —Pataitana mique chipilu mi neje tupupai, miada Diusu ja etiatani ai cuana chipilu neje bajaja aitia putsu. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Aimue mique ai biame a taji ecuanaju yainia ai cuana neje, mique muesumu Diusu butse su butsepi mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Beju japibaturucatique mique piba madhada cuana. Bajaque Diusu cuapuitime tuahueda mi perdonata cua, mida piba madhada cuana pibaitia biame. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mida envidia jubida epuani. Jucha sa eme su mi yani yama ebainia. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Da su Simón ja Pedro bajatana uja: —Mebajaque Diusu quema puji, be ema cuaja biame metse puitia nime paata mahue puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Da su jucuada Samaria yahua su ejude meamea Diusu sa quisa saida cuana quisaquisa puana tse. Quisaquisa pupe putsu, Jerusalén ejude su jasiapatibana tse. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Dapia edid'i Jerusalén ejude jenetia Gaza ejude teje saina. Tueda edid'i d'anita yahua je saina. Diusu sa ángel ja Felipe uja cuatsasiatana: —Beni bene putique, Jerusalén ejude jenetia Gaza ejude su ecuinahu edid'i je. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Da su Felipe putiana. Tueda edid'i su piada deja Jerusalén ejude jenetia Etiopía yahua su epuhu tejetaibana. Tueda da eunoco puina. Etiopía yahua su aniji cristiano cuana sa echua puji epuna Candace banime sa huaraji aida puina. Echua puji Candace sa chipilu quinaji puina. Dapia Jerusalén ejude su Diusu mitsutsuape putsu, beju epubuyu je. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Mesa carroza neje esiapatibuyu je, Diusu sa quirica Isaías chenu ja deretaidha mimiametana. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Da su Espíritu Santo ja Felipe cuatsasiatana: —Janariatitique jichu carroza su. Tu neje tupupai jududutique. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Da su Felipe carroza su cuinatiana su, deja ja Isaías chenu ja deretaidha quirica emimiametani id'abatana. Felipe ja tueda quisabatana uja: —¿A mi eshanapainia cuaja mi emimiameinia? ");
INSERT INTO tnaNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Beju deja ja Felipe jeutsutana: —Cuaja shanapa taji mahue ebainia. Aimue aidhe biame ema eshanapame puji. Da su deja ja Felipe ihuatana tu naja su carroza su paaniute puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Beju uja derejiji yani tu emimiametani quirica su: Huisha emanuame puji nime tueda dusutana huecuana. Cuaja huisha janana cuatsa mahue epuani einuadedetasa huecuana su nime, daja tueda cuatsa mahue jatiatiana. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Aimue aiya biame biahuanaja atana mahue. Manuametana huecuana putsu, bacua mahue puana. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Da su mimiame putsu, deja ja Felipe quisabatana: —¿Isaías chenu ja ai sa puji emimiani? ");
INSERT INTO tnaNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Da su Felipe ja tu mimiametana ai cuana buetsuapirutana. Pamapa buetsuapirutana Jesús jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Tuatse epuhu cama, ena edid'i naja su batana. Da su deja ja atana uja: —Hue upia ena esa. Ichaderaque ema Diusu sa puji yahui neje. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Da su Felipe ja deja atana: —Ahua pamapa muesumu neje mi jei epuani su, da su mi yama Diusu sa puji yahui neje eichadera. Deja ja uja jeutsutana: —Jesucristo da Diusu sa Ebacua ema jei epuani. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Da su deja ja carroza netisename putsu, ena su buteana tse. Beju Felipe ja deja Diusu sa puji yahui neje ichaderatana. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Da su ena jenetia cuinanana tse su, deja beidaji neje jaitianana. Mue beju jabatiyu tse. ");
INSERT INTO tnaNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Espíritu Santo ja Felipe Azoto ejude su dusutana. Dapia Felipe Diusu sa quisa saida cuana quisaquisa puana. Pia ejude cuana je di quisaquisa puniunetiana Cesarea ejude teje putiana beju. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Da tiempo su beju Saulo ja Jesús peje su jei eputani cuana jubida tijetije ataina etaitanamepe huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Da putsu, sacerdote aida peje su putiana quirica neje tu pahuaratiata puji, Cristo peje su deja ahua epuna jei eputani cuana Damasco ejude su jadhitati jude ete cuana su einati puji. Ina putsu, Jerusalén ejude su ebeitu puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Da su quirica inatsu putsu, Saulo putiana. Beju edid'i su Damasco ejude naja su hueda jubida batana buepa jenetia ebuteni. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Daja ba putsu, yahua su dajajana. Etsui id'abatana uja: —Saulo, Saulo, ¿jucuaja puji miada ema tijetije yainia? ");
INSERT INTO tnaNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Da su Saulo ja quisabatana uja: —¿Aidhe da mida, tata? Beju jeutsutana: —Ema da Jesús. Tijetije miada yainia da ema. Mida quitaita neda yatiani, ema tijetije a putsu. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Da su Saulo riariana, iyuame pu putsu. Uja atana: —Echua Puji, ¿ai mique tsada yama ya? Da su Echua Puji ja Saulo uja atana: —Netianaque. Putiyuque Damasco ejude su. Dapia pia ja mi equisata ai miada ya. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Beju Saulo sa ebuqueji cuana rubutananetitana. Cuaja mimi taji mahue jabatitana huecuana. Etsui id'abatana huecuana biame, mue aidhe biame ba huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Beju Saulo netianana su, cuaja jabati taji mahue jabatiana. Tu buqueji cuana ja meina putsu, riretana huecuana Damasco ejude su. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Dapia ejude su quimisha tsine cuaja jabati taji mahue jabatiana. Mue diadia, jaid'iti puana quimisha tsine teje. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Beju tueda ejude su piada deja anina Ananías banime. Beju Echua Puji Jesús tu peje su bataji puana tahui su nime. Uja Ananías mitsutana: —¡Ananías! Ananías ja jeutsutana: —Ehe, Echua Puji, hue ema upia. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Da su Echua Puji ja Ananías cuatsasiatana uja: —Netianaque. Putiyuque Judas sa ete su. Tueda ete calle Butsepi banime su yani. Chacuque Tarso ejude jenetia deja Saulo banime. Tueda Diusu neje emitsutiani miada eba. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Mique eme tu bia su huanaque tu esaisiame puji. Tahui su nime yama tueda quisana mida tu peje su eputi. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Da su Ananías ja jeutsutana uja: —Echua Puji, tueda Saulo ja mique dharejiji cuana Jerusalén ejude su chacutaina tuna ai madhada cuana ya puji. Daja ema quisatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Beju jiahue upia pueitia mi peje su jei eputani cuana ina putsu, eteriicha puji. Sacerdote aida cuana ja tueda huaratiatana daja paata huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Da su Echua Puji Jesús ja Ananías atana uja: —Putiyuque. Yama Saulo dhareana ema emebajata puji. Quema quisa saida cuana tueda quisaquisa epu. Judío mahue, mecuana sa huaraji aida, judio cuana peje su quisaquisa epu. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Tueda ebia su sufri epu ema jepuiti. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Da su Ananías Saulo yani su putiana. Tu peje su cuinati putsu, mesa eme tu bia su huanatana. Uja Saulo atana: —Edue Saulo, mi edid'i su bana Jesús ja ema mi peje su beitutaitia mi esaisiame puji. Espíritu Santo sa tucheda mique paaniti puji ema pueitia. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Da hora su epeji nime mesa etua jenetia dajajatana. Beju jabati puana neicha tu puina nime. Da su Saulo Diusu sa puji yahui neje jaichaderametiana. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Diadia putsu, neicha tucheda puibana. Jei eputani cuana neje quejucua tsine aniana Damasco ejude su. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Saulo judío cuana sa jadhitati jude ete cuana su, Jesús da Diusu sa Ebacua, quisaquisa pupiruana. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Pamapa tu id'abaji cuana nimetiutana. Tuneda cama uja jaquisabatitana: —¿Aimue jia maida ye deja Jerusalén ejude su jei eputani cuana inaji puina mahue? ¿Aimue jia maida upia di pueana jei eputani cuana eina puji mahue? ");
INSERT INTO tnaNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Beju Saulo ebia su janimetucheatiana. Jubida quisaquisa puana. Jesús da Diusu sa Jabeituti Deja Damasco ejude su aniji judío cuana bametana. Cuaja jeutsu taji mahue batana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","24","Da putsu, judío cuana tu neje ebia su duininitana. Saulo bahue puana tu manuameja putana huecuana. Dhidha, tsine ejude sa esacuinaji su id'uataina huecuana Saulo emanuame puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Beju tueda ejude sa tumu pirica pahaida, baqui bauda anina. Da su dhidha su jei eputani cuana ja Saulo d'iti aida dume su pirica jenetia butemetana tu d'eji su ya puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Da su beju Saulo Jerusalén ejude su putibana. Dapia jei eputani cuana neje jadhitatija pudhaana. Iyubatana huecuana putsu, mue jadhitati putana huecuana, Saulo jaturucatiana aimue jei aja mahue atana huecuana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Daja biame, Bernabé ja Saulo apóstol cuana peje su dusutana. Tuahueda pamapa butsepi quisatana huecuana. Cuaja Saulo ja Jesús edid'i su ba putsu, daja huecha cuaja Jesús ja tueda mitsutana quisatana huecuana. Daja huecha cuaja Saulo ja Damasco ejude su aniji cuana Cristo jepuiti quisaquisa puana quisatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Da su beju Saulo tuna neje asepiruana. Jesús sa quisa saida cuana Jerusalén ejude su jubida quisaquisa pupiruana. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Beju tueda ejude su griego yana su mimi bahue judío cuana anitaina. Saulo janimetucheati putsu, tuna neje Jesús jepuiti jacuicuinatiana. Da putsu, Saulo manuameja adhaatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Da su piada piada jei eputani cuana bahue pu putsu, Saulo dusutana huecuana Cesarea ejude su. Da jenetia Tarso ejude su beitutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Da su Judea, Galilea, Samaria yahua cuana su aniji jei eputani cuana saida, janimetucheatitana, Saulo ja aimue tijetije a huecuana putsu, tueda beju Cristo peje su jei puana putsu. Diusu ebia su iyubatana huecuana. Espíritu Santo ja ebia su tsahuatana huecuana putsu, dueji cristiano cuana jei putana. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Da su Pedro jei eputani cuana peje su ejude meamea puniunetiana tuna eba puji. Lida ejude su aniji edue cuana teje putiana. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Dapia piada deja nedaji Eneas banime tsutana. Ocho mara quitana saina, ase bue mahue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Da su Pedro ja tueda atana: —Eneas, netianaque, Jesucristo ja mi esaisiametani putsu. Mique siju mapaque. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Da hora su quitaita beju Eneas netianana. Da putsu, pamapa Lida, Sarón ejude detse su aniji cuana Jesús peje su jei putana. Mecuana sa equene ai puiti cuana ichaderatana huecuana Echua Puji Jesucristo tije ya puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Da tiempo su Jope ejude su Jesús peje su jei epuani epuna anina. Tueda banime Tabita. Griego yana su Dorcas banime. Tueda ai saida cuana a bahue puina. Puri cuana tsahua bahue puina. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Da su beju neda pu putsu, manuana. Eshanapa cuana ja padu putsu, ebaque ete su equita huanatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Beju Jope ejude da Lida ejude naja su anina. Da su Jope ejude su aniji jei eputani cuana Pedro Lida ejude su yani bahue pu putsu, beta edue detse beitutana huecuana Lida ejude su Pedro equisati puji. Cuinati putsu, Pedro atana tse uja: —Jiahue quita hue tipeida meputija Jope ejude su. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Da su Pedro tuatse neje putiana. Cuinati putsu, Pedro ete ebaque su equita esa su huidusutana huecuana. Dapia ahue manujiji cuana jadhitatitana. Beju japadarititasaina huecuana. Ahue manujiji epuna cuana ja Pedro ba putsu, Tabita ja tuneseda puji ejud'uji rusutana cuana bametana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Da su Pedro ja epuna cuana edume jenetia cuinanametana. Tururu putsu, Diusu bajatana Tabita sa puji. Daja a putsu, Tabita emanu esa chamatana. Uja atana: —¡Tabita, netianaque! Da yatani cama, Tabita jabatiana. Pedro ba putsu, anitsuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedro ja mesa eme inatana tu enetianame puji. Da su jei eputani, ahue manujiji epuna cuana ihuatana. Tabita eid'e beju menajatiatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Jope ejude su aniji cristiano cuana beju bahue pu putsu, ebia su Jesús peje su jei putana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Da su Pedro Jope ejude su quejucua tsine aniana ebiti d'imiaji Simón sa ete su. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Cesarea ejude su piada deja aniana Cornelio banime. Tueda da soldado cuana sa capitán puina. Mesa batallón Italiano banime. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Tuahueda, pamapa mesa familia neje Diusu iyubataina. Ebia su Diusu mitsutsuataina. Puri cuana ebia su chipilu tia bahue puina. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Beju pia tsine buepatia badeute uqueda Diusu sa ángel ja tahui su nime tueda mitsutana uja: —¡Cornelio! ");
INSERT INTO tnaNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Daja Cornelio id'aba putsu, iyuame puana. Uja jeutsutana ángel: —¿Ai eje mi, tata? Da su beju ángel ja jeutsutana: —Diusu ja mique jabajati cuana id'abatana. Daja huecha miada puri cristiano cuana chipilu tiana batana. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Da su jiahue quita deja cuana beituque Jope ejude su Simón Pedro upia paduseta huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Dapia ebiti d'imiaji Simón sa ete su yani. Tueda ete da mar maje su yani. Tuahueda miada cuaja ya equisata. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Angel mimipe putsu, putibana su, Cornelio ja beta mesa emebajaji ihuatana. Piada soldado di ihuatana. Tueda soldado da mesa eshanapa puina. Tueda di Diusu iyuba bahue puina. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Pamapa cuaja ángel ja atana butsepi quisape putsu, Jope ejude su beitutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Pia tsine buepatia su Jope ejude su beju enariatitasa huecuana cama, Pedro ete pachata bia su anitsuana Diusu emitsu puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Beju diadiaja puana. Jana eid'uainia cama, tahui su nime batana. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Buepa etsequed'iatiani batana tahui su nime. Sábana aida nime buepa jenetia yahua su pushi ebatsu dhitarisijiji ebutesiu batana. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Pamapa animalo cuana sábana aida nime dume su ebade batana. Pamapa pushi tame etsedu neje aseji animalo cuana, pamapa d'ia cuana batana. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Da su Diusu ja Pedro uja cuatsasiatana: —¡Netianaque, Pedro! ¡Manuameque! ¡Diadiaque! ");
INSERT INTO tnaNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Da su Pedro ja jeutsutana: —¡Mahue, Echua Puji! Ye aicha rejada edia puji, cuaja ecuana sa ai puiti cuana batame. Dia bue mahue ema. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Da su neicha Diusu ja Pedro atana: —¡Be daja mimiji! Quebata ai yama saida ebainia cuana, be rejada baji. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Daja Pedro ja quimisha nuati tahui su nime batana. Da su sábana aida nime buepa su tsuatibana. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedro id'ecuina putsu, ebia su pibapibana uja: “¿Ai pa da yama tahui su nime baitia?” Da su Pedro daja epibapibani cama, Cornelio sa jabeituti deja cuana eteriji su cuata cuinatana. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Simón sa ete quisababetana huecuana uja: —¿A da ye ete su Pedro yani? ");
INSERT INTO tnaNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pedro mu daja hue pibapibaderana. Da su Espíritu Santo ja tueda atana uja: —Quimisha deja cuana beju cuinataitia mi eba puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Jiahue quita buteque. Putiyuque tuna neje ai pibapiba mahue neje, yama beituitia huecuana putsu. Saida batsuque huecuana, judío mahue huecuana biame. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Da su Pedro buteana deja cuana peje su. Uja atana huecuana: —Ema da Pedro micuana echacuinia. ¿Ai puji ni da micuana ema echacuinia? ");
INSERT INTO tnaNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Da su jeutsutana huecuana uja: —Capitán Cornelio ja ecuanaju mi peje su beitutana. Tueda da deja butsepi, Diusu iyuba bahue putsu. Pamapa judío cristiano cuana ja tueda saida ebatani. Diusu sa ángel ja uja cuatsasiatana capitán Cornelio: “Dusemeque Pedro upia mique ete su. Id'abaenique cuaja tuahueda mi equisatayu.” ");
INSERT INTO tnaNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Da su Pedro ja deja quimisha cuana ete dume su nubiametana. Beju saida batsutana huecuana. Pia tsine Pedro, deja quimisha cuana neje Jope ejude jenetia cuinanana. Tuna neje pia jei eputani cuana di putitana. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pia tsine Cesarea ejude su, Cornelio sa ete su cuinatitana huecuana. Dapia Cornelio ja id'uatana huecuana pamapa mesa edue, eshanapa ihuajiji cuana neje. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pedro ete eteriji su cuata cuinana su, Cornelio ja cuinana putsu, tsutana. Tururuana Pedro butse su tu emitsutsua puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Da su Pedro ja Cornelio atana: —¡Netianaque! Be tururuji ema butse su, ema mu mi nime deja hue putsu. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Da su Pedro Cornelio neje emimiani cama, ete dume su nubiana tse. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Dueji cristiano cuana anitaina Pedro ja batana. Da su Pedro ja uja atana huecuana: —Micuaneda bahue rejada judío cuana, judío mahue cuana neje yani puji. Daja huecha rejada tuna sa ete cuana su enubi puji. Daja biame, tu butse su pamapa cristiano cuana tupupai cama Diusu ja ema buetsuatana. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Da putsu, ema pueitia micuana peje su, micuaneda ema ihuameitia su. Da su beju mequisaque ema, ¿ai puji micuaneda ema ihuameitia? ");
INSERT INTO tnaNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Da su Cornelio ja jeutsutana Pedro: —Pushi tsine ye hora tupu su ema quema ete su ayuna puanina. Diusu neje emitsutiani cama, deja ejud'uji pasane cuarecuareji ema butse su bataji puana. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Uja ema mitsutana: “Cornelio, Diusu ja mique jabajati cuana id'abatana. Daja huecha miada puri cristiano cuana chipilu tiana bana. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Da su jiahue quita deja cuana beituque Jope ejude su Simón Pedro upia paduseta huecuana puji. Dapia ebiti d'imiaji Simón sa ete su yani. Tueda ete da mar maje su yani. Tueda epue su, mida equisata.” ");
INSERT INTO tnaNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Daja ángel ja ema atana. Beju da hora su hue mi yama ihuameana. Saipie mida pueitia beju. Hue ecuanaju pamapa Diusu butse su yani. Da su quisaque ecuanaju pamapa Diusu ja mi tiatana quisa saida cuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Da su Pedro uja quisaquisa pupiruana: —Jiahue yama eshanapaeninia Diusu ja pamapa cristiano cuana tupupai ebatani. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Aidhe papu cristiano cuana Diusu iyuba putsu, saida eputaniuneti su, Diusu ja saida ebatsuta huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Diusu ja mesa Cristo jepuiti quisa saida cuana israelita cuana peje su equene quisametana neicha tu neje saida paputa huecuana puji. Beju tueda Jesucristo da pamapa cristiano cuana sa Echua Puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","38","Micuaneda bahue cuaja ye ai cuana puana judío cuana sa yahua su. Equene Juan Bautista quisaquisa puana. Da su Diusu ja Espíritu Santo beitutana Jesús peje su mesa tucheda etia puji. Tueda Jesús ja Galilea yahua su ai saida cuana apirutana. Pamapa ejude meamea puniunetiana ai saida cuana ya puji. Ishahua sa tucheda ema su aniji cristiano cuana d'eji su atana. Daja atana, Diusu sa tucheda mesa anina putsu. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Jesús ja Judea yahua, Jerusalén ejude su atana ai cuana ecuanaju bana. Ecuanaju tueda ai cuana cristiano cuana equisainia. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Da su beju cristiano cuana ja Jesús curusu su badeanatana biame, Diusu ja tueda netianametaibana quimisha tsine jenetia. Tueda ecuanaju eid'e bana, ecuanaju peje su bahui eid'e jabametiana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Aimue jabametiana mahue pamapa cristiano cuana peje su. Diusu ja ecuanaju biahua tiempo dharetana ye ai cuana cristiano cuana equisa puji. Ecuanaju Jesús neje diadiana, tu id'eibana su. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Tuahueda ecuanaju cuatsasiatana cristiano cuana peje su quisaquisa epu puji, Diusu ja Jesús pamapa manujiji, eid'e cuana sa ejuzgaji huaraji aida ichatana. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Biahua tiempo jenetia profeta chenu cuana ye ai cuana jepuiti quisa putaidha. Aidhe papu Jesucristo peje su jei epu su, mesa jucha cuana Diusu ja edhipata, putaidha huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Beju Pedro daja emimiani cama, Espíritu Santo tu eid'abatani cuana bia su buteana. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Pedro neje puetana judío edue cuana nimetiunetitana, Diusu ja Espíritu Santo judío mahue cuana tiatana putsu. Da su judío mahue cuana Diusu mitsutsuapirutana. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Eshanapa mahue yana su beju mimipirutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Da su Pedro ja judío edue yanita cuana uja atana: —Ye cristiano cuana judío mahue papu biame, Diusu ja Espíritu Santo tiatana huecuana ecuanaju nime. ¿Aimue jia maida ye cuana di Diusu sa puji yahui neje ichadera taji mahue? ");
INSERT INTO tnaNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Da su Pedro ja cuatsasiatana paichaderata huecuana puji Jesucristo sa ebani su. Da su beju Cornelio ja Pedro, pia judío edue cuana neje bajatana tuna neje quejucua tsine puji paaniti huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Jerusalén ejude su aniji apóstol, edue cuana id'abatana judío mahue cuana Diusu sa quisa saida su jei putana. ");
INSERT INTO tnaNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","3","Da su Pedro Jerusalén ejude su jasiapatiana su, pia edue ja tueda tuaquisatana uja: —¿Jucuaja su mida judío mahue cuana neje diadiana? ");
INSERT INTO tnaNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Da su Pedro ja pamapa butsepi quisatana huecuana uja: ");
INSERT INTO tnaNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Jope ejude su ema Diusu emitsutsuainia cama, tahui su nime yama bana. Tahui su nime yama sábana aida nime buepa jenetia ema peje su ebutesiu bana. ");
INSERT INTO tnaNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Pushi ebatsu dhitarisijiji ebutesiu bana. Da dume su pamapa pushi tame, etsedu neje aseji animalo cuana, pamapa d'ia cuana badetaina. ");
INSERT INTO tnaNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Da su Diusu ja ema cuatsasiatana: “Netianaque, Pedro. Manuameque. Diadiaque.” ");
INSERT INTO tnaNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Da su yama jeutsuana: “Mahue, Echua Puji. Dia bue mahue ema rejada aicha.” ");
INSERT INTO tnaNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Da su neicha Diusu ja ema atana: “Be daja mimiji. Quebata ai yama saida ebainia cuana, be rejada baji.” ");
INSERT INTO tnaNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Daja yama quimisha nuati bana. Da su sábana aida nime buepa su tsuatibana. ");
INSERT INTO tnaNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Da hora su quitaita quimisha deja cuana Cesarea ejude jenetia ema peje su cuinatana. ");
INSERT INTO tnaNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Espíritu Santo ja ema uja cuatsasiatana: “Putiyuque ye deja cuana neje ai pibapiba mahue neje.” Da su tuna neje ema putiana Cornelio sa ete su. Ye edue cuana di ema neje putitana. ");
INSERT INTO tnaNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Dapia Cornelio ja ecuanaju quisatana mesa ete su ángel tu peje su jabametiana. Uja ángel ja cuatsasiatana: “Deja cuana beituque Jope ejude su Pedro paduseta huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Cuaja mida, mique familia cuana neje d'eji su pu cua equisata.” ");
INSERT INTO tnaNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Da su beju Cornelio sa ete dume su ema quisaquisa epuani cama, Espíritu Santo tueda judío mahue cuana bia su buteana, cuaja ecuana peje su equene buteana nime. ");
INSERT INTO tnaNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Da hora su yama pibana Jesús ja equene ecuana uja atana: “Enei hue Juan ja cristiano cuana Diusu sa puji yahui neje ichaderatana. Micuana Espíritu Santo sa tucheda neje Diusu sa puji yama eichadera.” ");
INSERT INTO tnaNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Beju Diusu ja Espíritu Santo tiatana huecuana, Echua Puji Jesucristo peje su jei putana su, cuaja ecuana equene tiatana nime yama bana. Diusu ja tueda judío mahue cristiano cuana saida batsutana putsu, da su, ¿ai ni da ema Diusu, “Mahue”, ya puji? ");
INSERT INTO tnaNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Da su beju Jerusalén ejude su aniji edue cuana Pedro sa quisa daja id'abatana su, mitananetitana huecuana. Diusu mitsutsuapirutana huecuana uja: —Diusu ja judío mahue cuana di d'eji etiatani tu peje su panimeturucatita huecuana puji, d'eji su paputa huecuana puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Beju Esteban manuametana huecuana su, pia edue cuana di tijetije apirutana huecuana. Piada piada edue cuana Chipre edhapupu su, Fenicia yahua su, Antioquía ejude su jududutana. Dapia Diusu sa quisa saida cuana judío cuana peje su bahui quisaquisa putana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Piada piada tuneda Chipre edhapupu jenetia, Cirene ejude jenetia putaina. Antioquía ejude su cuinatana huecuana. Judío mahue cuana peje su Jesucristo sa quisa saida cuana quisaquisa putana huecuana. Cuaja Jesús peje su jei pu putsu, d'eji su pume puta cua quisaquisa putana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Echua Puji Jesucristo sa tucheda mecuana sa anina. Dueji cristiano cuana Jesucristo peje su jei putana. ");
INSERT INTO tnaNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jerusalén ejude su aniji jei eputani edue cuana ja tueda ai cuana id'aba putsu, Bernabé beitutana Antioquía ejude su. ");
INSERT INTO tnaNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Tueda ejude su cuinatiana su, beidaji puana, Diusu ja atana ai cuana ba putsu. Saida neje quisatana huecuana Echua Puji peje su panimetucheaderatita puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabé da deja saida puina. Espíritu Santo sa tucheda mesa anina. Echua Puji Jesucristo peje su ebia su janimetucheatina. Dueji cristiano cuana Jesucristo peje su huidusutana. ");
INSERT INTO tnaNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Da su beju Bernabé Tarso ejude su putiana Saulo echacuti puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Dapia ejude su teje putsu, jasiapatibana Saulo neje Antioquía ejude su. Dapia ejude su piada mara anitiana tse jei eputani edue cuana neje. Dueji cristiano cuana buetsuatana tse. Dapia Antioquía ejude su aniji jei eputani mahue cuana ja Cristo peje su jei eputani cuana cristiano ebani ichatana. ");
INSERT INTO tnaNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Da tiempo su pia Diusu sa quisa puji cuana Jerusalén ejude jenetia cuinatana Antioquía ejude su. ");
INSERT INTO tnaNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Tuneda piada banime Agabo. Da su edue cuana jadhitatitana su, Agabo tuna duju su netianana. Espíritu Santo ja tueda cuaja ai cuana epu quisaquisa ametana. Pamapa yahua je mid'e epu quisaquisa puana. (Beju daja puana romano echua puji aida Claudio banime anina tiempo su.) ");
INSERT INTO tnaNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Mid'e putsu, pamapa Antioquía ejude su aniji jei eputani edue cuana ja Judea yahua su aniji edue cuana tsahuaja atana. Tuna sa tupu teje chipilu ichatana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Saulo, Bernabé detse huaratiatana huecuana tueda chipilu edue cuana sa ehuidusuji cuana peje su Judea yahua su padusuta tse puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Da tiempo su echua puji Herodes Agripa ja piada piada jei eputani cuana tijetije apirutana. ");
INSERT INTO tnaNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Juan sa edue Jacobo espada neje manuametana. ");
INSERT INTO tnaNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Jacobo manuame putsu, judío jei eputani mahue cuana beidaji ametana. Da su Herodes Agripa ja daja beidaji eputani huecuana ba putsu, Pedro di inametana eteriichame puji. Daja Herodes Agripa ja atana levadura mahue pan pascua tsine epuneti tupu. ");
INSERT INTO tnaNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Herodes Agripa ja Pedro cristiano cuana butse su tuaquisaja adhaatana, pascua tsine ejaitiana su tu emanuame puji. Da putsu, Herodes Agripa ja cuatsasiatana soldado cuana saida painatsihuata huecuana puji. Da su beju piada tunca sucuta ejaitiana soldado cuana ja Pedro inatsihuatana. Pushi pushi jaturucatitana huecuana tu einatsihua puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pedro terisaisiajiji yani tupu, jei eputani cuana ja jubida Diusu bajatana tuseda puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Da su beju dhidha su Herodes Agripa ja Pedro risiametana beta cadena neje apudaya tueda emanuameme puji. Pedro tahuisaina tu inatsihuaji soldado detse dhede je su. Pia soldado detse eteriji su netina einatsihua puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Da hora su Diusu sa ángel Pedro peje su bataji puana. Pedro terijiji yani su hueda jubida puana. Da su ángel ja Pedro pehued'apabatana tu eid'edia puji. Uja Pedro cuatsasiatana: —Tipeida netianaque. Da hora su quitaita cadena detse dajajana tusa emebaja jenetia. ");
INSERT INTO tnaNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Angel ja neicha cuatsasiatana Pedro: —Jajud'utique. Mique pulucu, ebiad'amaji jaichati putsu, ema tije pueque. ");
INSERT INTO tnaNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Da su beju Pedro ja ángel tije atana. Tueda mu tahui epuani pepe hue puana. ");
INSERT INTO tnaNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Pedro naja su aniji soldado detse jusiaichatana tse. Pia beta soldado detse eteriji su eneti dhede je jaitianana tse. Piama jenetia taraca etsequeini su cuinati putsu, etsequeini beju tusa piba hue jatsequed'iatiana. Da su d'eji su cuinana tse. Chuadera pad'i aseti putsu, ángel ja Pedro jusianetiatana. ");
INSERT INTO tnaNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Beju Pedro tu mehua netitiana. Uja japibatiana: “Aimue tuque ema tahui epuani mahue. Diusu ja mesa ángel beitutana ema Herodes Agripa sa eme jenetia ejemicuinata puji. Daja huecha judío cristiano cuana sa eme jenetia di ema jemicuinataitia, ema ai madhada aja adhaatana huecuana biame.” ");
INSERT INTO tnaNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Beju daja epibatiani je, María sa ete su putiana. Tueda da Juan Marcos sa cuara puina. Tueda ete su dueji edue cuana dhitajiji anitaina. Diusu bajatanina huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Da su Pedro ja eteriji turubatana su, emebajaji epuneje Rode banime netianana ebati puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pedro sa etsui id'aba putsu, beju shanapatana Pedro etsequeini su eneti. Ebia su beidaji pu putsu, tsequed'iaji mahue jududusiapana ete dume su pia cuana equisa puji. Uja atana huecuana: —Beju Pedro etsequeini su eneti. ");
INSERT INTO tnaNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Da su epuneje uja atana huecuana: —¡Tseitsi nime mida! Da su Rode neicha jubida atana huecuana uja: —¡Enei hue, butsepi yama micuana equisainia! Da su jaquisabatitana huecuana: —Aimue tueda mahue. Tu inatsihuaji ángel hue. Da su mu jia beju manujiji. ");
INSERT INTO tnaNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Daja tuna equisatitani cama, Pedro ja daja hue eteriji turubanetiatana. Beju tsequed'iatana huecuana su, Pedro eneti batana huecuana. Eneti ba putsu, nimetiunetitana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Da su Pedro ja mesa eme jemitsuatana pamitanata huecuana puji. Pamapa ai cuaja puana cuana quisapirutana huecuana. Cuaja Echua Puji Jesús ja tueda jemicuiname atana quisatana huecuana. Uja cuatsasiatana huecuana: —Mequisatique Jacobo, pia edue cuana di. Da su Pedro putiana. ");
INSERT INTO tnaNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Apudaya su beju soldado cuana janimetipeititana, Pedro ai mahue ba putsu. Uja jaquisabatitana huecuana: —¿Juque jia Pedro? ");
INSERT INTO tnaNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Da su Herodes Agripa ja chacuametana. Mue teje atana huecuana putsu, einatsihuaji soldado cuana d'ayatana. Beju manuametana huecuana. Da su beju Herodes Agripa Judea yahua jenetia cuinanana, Cesarea ejude su eputi puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Da su beju Herodes Agripa Tiro, Sidón ejude detse su aniji cristiano cuana neje duininiana. Da su japaititana huecuana Herodes neje ebutsepiati puji. Tu peje su putitana huecuana tueda paduininiriji puji. Daja atana huecuana, Herodes Agripa ja mecuana sa ai dia taji cuana tiataina putsu. Herodes Agripa sa huaraji aida Blasto banime ja tsahuatana huecuana Herodes Agripa neje ebutsepiati puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Da su beju pia tsine Herodes Agripa jajud'uderatiana ania tuna emitsu puji. Mesa huaraji ani jude su cuinati putsu, aniuteana. Da jenetia saida quisaquisa atana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Da su id'abatana huecuana su, uja putana huecuana: —¡Ye mu Diusu! ¡Aimue deja mahue! ");
INSERT INTO tnaNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Da hora su Diusu sa ángel ja jubida neda ametana Herodes Agripa, tueda Diusu nime jabametiana putsu. Huerehuere sutsu ja diajiji manuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Da su beju jei eputani cuana Diusu sa quisa saida cuana daja hue quisaquisa puniunetideratana pamapa ejude cuana je. Dueji cristiano cuana Jesús peje su jei putana. ");
INSERT INTO tnaNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabé, Saulo detse ja Jerusalén ejude su aniji cuana dhitajiji chipilu menajatiatana su, Antioquía ejude su jasiapatibana tse. Tuatse neje Juan Marcos putiana. ");
INSERT INTO tnaNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Beju Antioquía ejude su aniji jei eputani cuana duju su profeta, ebuetsuaji cuana anitaina. Tuneda da uja banime: Bernabé. Simón. Mesa esitu ebani da Negro puina. Lucio. Tueda Cirene ejude jenetia puina. Manaén. Tueda Echua Puji Herodes Felipe neje sehuana. Saulo. ");
INSERT INTO tnaNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Da su jadhitatitani huecuana su, ayuna epuani je, Echua Puji Jesucristo mitsutsuatana huecuana. Daja eputani cama, Espíritu Santo ja uja atana huecuana: —Bernabé, Saulo detse medhareque quema mudu paata tse puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Da su ayuna pu putsu, Diusu mitsupe putsu, edue cuana ja mecuana sa eme Bernabé, Saulo detse sa echua su huanatana. Da neje saida beitutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Beju Espíritu Santo ja beitutana Saulo, Bernabé Seleucia ebuteji su. Tueda ebuteji su barco su aniuteana tse Chipre banime edhapupu su eputi puji. ");
INSERT INTO tnaNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Juan Marcos di tuatse neje puniunetina tuatse etsahua puji. Beju edhapupu su cuinati putsu, Salamina ejude sa ebuteji su satsuatiana huecuana. Dapia judío cuana sa jadhitati jude ete cuana su Diusu sa quisa saida cuana quisaquisa pupirutana huecuana. ");
INSERT INTO tnaNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Pamapa edhapupu je aniji ejude cuana peje su puniunetitana huecuana. Pafos ebuteji teje cuinatitana huecuana. Dapia piada judío deja Barjesús banime tsutana huecuana. Mesa pia ebani da Elimas puina. Tueda da mau, bid'umimi aida puji puina. “Ema da Diusu sa quisaquisa puji”, pu bahue puina. ");
INSERT INTO tnaNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Tueda edhapupu sa huaraji aida Sergio Paulo sa eshanapa puina. Tueda da huaraji aida, bahue eni puina. Da su tuahueda Bernabé, Saulo detse ihuametana, Diusu sa quisa saida cuana id'abaja atana putsu. ");
INSERT INTO tnaNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Da su beju mau Elimas ja shanapa putsu, Bernabé,