﻿USE sofia;
DROP TABLE IF EXISTS sofia.tmd_vpl;
CREATE TABLE tmd_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tmd_vpl WRITE;
INSERT INTO tmd_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jisas Krais nuö nöhönɨŋ maduebö nuŋ bla yöxɨm yöxɨp höuöilmel rön nugwo yöx pön hömä akuyöbö yadɨba rɨmɨdla. Nöbö dib Ebraham yöxɨm yöxɨp duön, kiŋ Depid nugwo yöx pön hömä. Depid nuŋ yöxɨm yöxɨp duön, Jisas Krais nugwo yöx pön hömä. ");
INSERT INTO tmd_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Akuyöbö almä: Ebraham nuŋ Aisak yöx pön höŋa. Aisak nuŋ Jekop yöx pön höŋa. Jekop nuŋ piöŋö, Juda yöxön, pɨgnɨŋ nöbö pɨg maga agɨpa yöx pön höŋa. ");
INSERT INTO tmd_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda nuŋ mö Tama pɨsaŋ mɨdön, Peres Sera yöŋö yöx pön höŋa. Peres nuŋ Hesron yöx pön höŋa. Hesron nuŋ Ram yöx pön höŋa. ");
INSERT INTO tmd_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram nuŋ Aminadap yöx pön höŋa. Aminadap nuŋ Nason yöx pön höŋa. Nason nuŋ Salmon yöx pön höŋa. ");
INSERT INTO tmd_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon nuŋ Boas yöx pön höŋa. Boas nuöm nuŋwa Rehap. Boas nuŋ Obed yöx pön höŋa. Obed nuöm nuŋwa Rut. Obed nuŋ Jesi yöx pön höŋa. ");
INSERT INTO tmd_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi nuŋ kiŋ Depid yöx pön höŋa. Depid nuŋ Solomon yöx pön höŋa. Solomon nuöm nuŋ aku, höd Yuraia pɨmɨn wöröxɨm, mai Depid pön mönö, Solomon yöx pön höŋa. ");
INSERT INTO tmd_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon nuŋ Riaboam yöx pön höŋa. Riaboam nuŋ Abaija yöx pön höŋa. Abaija nuŋ Esa yöx pön höŋa. ");
INSERT INTO tmd_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Esa nuŋ Jihosapat yöx pön höŋa. Jihosapat nuŋ Joram yöx pön höŋa. Joram nuŋ Asaia yöx pön höŋa. ");
INSERT INTO tmd_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Asaia nuŋ Jodam yöx pön höŋa. Jodam nuŋ Ehas yöx pön höŋa. Ehas nuŋ Hesekaia yöx pön höŋa. ");
INSERT INTO tmd_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaia nuŋ Manasa yöx pön höŋa. Manasa nuŋ Emos yöx pön höŋa. Emos nuŋ Josaia yöx pön höŋa. ");
INSERT INTO tmd_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia nuŋ Jekonaia yöx pön hön, pɨgnɨŋ nöbö adö bli yöx pön höŋa. Wop aku, taun dib Babilon nöbö mö hön, Isrel nöbö mö bla nag nɨg pön Babilon dumä. ");
INSERT INTO tmd_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pön dumɨdmä, Jekonaia piaku mɨdön, Sialtiel yöx pön höŋa. Isrel nöbö mö ñɨŋ Babilon röböxön mögörɨb Juda höbkal duim aku, Sialtiel nuŋ Serababel yöx pön höŋa. ");
INSERT INTO tmd_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serababel nuŋ Abaiad yöx pön höŋa. Abaiad nuŋ Eliakim yöx pön höŋa. Eliakim nuŋ Eso yöx pön höŋa. ");
INSERT INTO tmd_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Eso nuŋ Sedok yöx pön höŋa. Sedok nuŋ Ekim yöx pön höŋa. Ekim nuŋ Elaiad yöx pön höŋa. ");
INSERT INTO tmd_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elaiad nuŋ Eliesa yöx pön höŋa. Eliesa nuŋ Matan yöx pön höŋa. Matan nuŋ Jekop yöx pön höŋa. ");
INSERT INTO tmd_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop nuŋ Josep yöx pön höŋa. Mö Maria Josep nölmä. Maria nuŋ Jisas yöx pön höŋa. Jisas nuŋ Krais me rɨmɨdöia. ");
INSERT INTO tmd_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Makwam, nöso an Ebraham nuŋ yöxmɨn yöxɨm yöxɨp u höuöilmel rɨm akuyöbö ragpɨd adokwebö kwo (14) duöŋ aku, mai nöso kiŋ Depid yöx pön hömä. Yöx pön höm, Depid nuŋ piöŋö yöxmɨn yöxɨm yöxɨp u höuöilmel röŋ aku kwo algör ragpɨd adokwebö kwo (14) dumɨn, mai Babilon nöbö hör piakuyöbö hön ñɨgö nag nɨg pön mögörɨb ñɨŋa dumä. Pön dumɨn, mai piöŋö iswob yöxɨp u höuöilmel rɨm akuyöbö ragpɨd adokwebö kwo (14) dumɨn mönö, mai Krais nugwo yöx pön hömä. ");
INSERT INTO tmd_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisas Krais nugwo yöx pön höm mönö aku yadɨba rɨmɨdla. Jisas nuöm Maria, Josep nölmɨn, nuŋ pɨsaŋ yönölöŋ wöhö, ñɨŋ nugumɨn Maria ha wöta mɨdöŋa. Inöm Leia nuŋ keir rɨmɨn, ha wöta mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Makwam nöbönɨŋ nuŋwa Josep nöbö waiö makwam, mönö diba yadölöŋ; rɨb akwör yöxön yadöŋa, “Ha wöta mɨd aku, nöbö mö bla yad nölmön, nuŋ möigw yöxöna. Makwam, tar yad abnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josep aliö rɨbyöx nugwöŋ aku, jɨ pɨxmag yuö bö inɨmö nugwöŋa, Nöbö Diba ejol nuŋ i nugwo yadöŋa, “Josep, Depid ha nuŋwa! ‘Mö aku, pöd raŋ pɨnö?’ rön, rɨbyöx nugumɨjɨnö; amɨn pö. Ha wöta mɨd aku, Inöm Lei akwör rɨmɨn mɨda. ");
INSERT INTO tmd_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mai ha aku yöx pön haŋ nuŋ dib röxön, nöbö mö nuŋ akuyöbö ap kib mag gwogwo röi pɨx aku örɨx abön makwam, ib nuŋwa Jisas rane,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Alöŋ aku, Nöbö Diba nuŋ mönö nuŋwa yadɨb nöbö i yad nölöŋa nugwön nuŋ piöŋö al aliö cönɨŋö, rön yadöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Nuŋ yadöŋa, “Ha mö i nöbö i pɨsaŋ yönen wöhö, ha wöta mɨdön, ha i yöx pön haŋ, ib nuŋwa Emanuel me cöñɨŋö,” röŋa. Emanuel mönö il aku, God an pɨsaŋ mɨda. ");
INSERT INTO tmd_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Makwam Josep inɨmö hölɨmön öbɨlön, Nöbö Diba ejol nuŋwa mönö yadöŋ aku pön, mö Maria nugwo mɨ pɨnö, rön rɨbyöx nugwöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Höd Josep Maria pɨsaŋ yönölöŋ wöhö, Maria ha aku yöx pön höm, Josep ha aku ib nuŋwa Jisas, me rön, Maria nugwo mɨ aŋadö pöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Makwam Herod Judia Propins kiŋ mɨdmɨd wop aku, Maria Jisas yöx pön höŋ Betlehem taun, mögörɨb Judia mibɨl yöra. Yöx pön höm, nöbö gupö nugw ri abɨb bla, naiö wölmɨd möl sebö Jerusalem hön, nöbö mö piaku yad nugwön yadmä, ");
INSERT INTO tmd_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Juda nöbö mö, Kiŋ an, me röi aku nugwo yöx pön höia! Wopik nɨgmɨn mɨd pikai? An mögörɨb ana naiö wöl hömɨd möl sö mɨdön nugumɨn gupö aku wöxnö nɨga; nugwöl aku, ib nuŋwa yadɨŋ bɨl sö duaŋ, me rön, hölɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Aliö rɨmɨdmɨn, kiŋ Herod mönö aku nugwön, nöbö mö pik ñɨŋ ha aku nugwo rɨbyöx nugwön nɨ nugweñɨŋadö, rön, rɨb mɨga yöxöŋa. Jerusalem nöbö mö akuyöbö magalɨg algör rɨb mɨga yöxmä. ");
INSERT INTO tmd_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Makwam kiŋ Herod, God ap höjöpal ur nölɨb nöbö dib bla aipam, God lo mönö yad nölɨb nöbö bla aipam, wö rɨm hömɨdmɨn yadöŋa, “God mönö yadɨb nöbö piaku Krais nugwo yöx pön höñ mögörɨb kai?” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Aliö rɨmɨdmɨn yadmä, “God mönö yadɨb nöbö i, maduar mönö kai kɨtön rɨg yadöŋ mag akwör, nugwo yöx pön höñ Betlehem taun, mögörɨb Judia yuadö. God mönö yadɨb nöbö aku God Mönö kai kɨtön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Mögörɨb Judia yuadö mögörɨb mɨga hörɨrör mɨd makwam, mögörɨb Betlehem nugwaŋ mögörɨb ulmɨdö i röxg mɨjön aku, jɨ Nöbö Dib aku mögörɨb aliö akuyöbö hön, nöbö mö nɨ Isrel akuyöbö ñɨgö nugwidɨx mɨjöna. Aiön aku, Betlehem ib diba mɨjönɨŋö,’ rö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Aliö rɨmɨdmɨn, kiŋ Herod nugwön, du rɨb wä yöx nugub nöbö bla ñɨgö tar yad wö rɨm hömɨdmɨn yadöŋa, “Wop kaiyöbö gupö aku wöxnö nɨgöŋ?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Aliö rɨmɨn, nugwo mönö aku yad nölmɨn, ñɨgö Betlehem yad abön inakmönö hörön yadöŋa, “Ñɨŋ du ha aku hölu nugw ri abön, höbkal hön yadɨŋ, nɨ aipam duön ib nuŋwa yadmön bɨl sö duaŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kiŋ Herod aliö rɨmɨn, ñɨŋ dumɨn nugugɨrön, gupö ñɨŋ naiö wölmɨd adaku nugwim aku höd höd dumɨn nugugɨrön, ñɨŋ mai dumä. Gupö aku dumɨd dumɨd, ha kiaia aku mɨdöŋ rama mibɨl yöra pisö gö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Almɨn nugwön ñɨŋ gupö aku nugumɨn, wä rɨmɨn nugugɨrön, ñɨŋ mɨ ödöriö wahax pɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ram möl bö duön nugumɨn, ha kiaia aku nuöm Maria pɨsaŋ mɨdöŋa. Ñɨŋ du höxmax yuön, ha kiai aku iba yadmɨn bɨl sö dumɨdɨm nugwön, yogw ñɨŋ bla höjöxön, ha aku nugwo ap wä bli nölmä. Gol bli, pia hölɨŋ wä höb bli, wel röbö hölɨŋ wä höb bli nölmä. ");
INSERT INTO tmd_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Makwam ñɨŋ pɨxmag yuö kwo hölɨmön inɨmö nugumɨn, God yadöŋa, “Höbkal Herod mɨda dumɨjeñɨŋe!” röŋa. Makwam, rɨg yadöŋ akwör nugwön, höbkal ödöi hör i dumɨdön, rɨba ram ñɨŋa dumä. ");
INSERT INTO tmd_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Makwam rɨb wä yöx nugub nöbö bla ñɨŋ algör dumä nugugɨrön, Josep inɨmö nugumɨn, ejol i hön nugwo yadöŋa, “Herod ha kiai aku pɨl pal nɨgɨnö, rön, hölu nuguba rɨmɨda. Makwam, ha kiaia nuömarö hogwa rɨmgör yölɨŋön, bör mögörɨb Ijip duö. Hanö rɨmön kwönö nagö höbkal hanö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ejol aliö rɨmɨn, Josep pɨxmag yuö mibɨl kwo öbɨlön, ha kiaia nuömarö hogwa yölɨŋön mögörɨb Ijip duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Yölɨŋ pön duöŋ aku, Nöbö Diba nuŋ mönö nuŋwa yadɨb nöbö i nugwo yad nölmɨn, nuŋ nugwön mönö aku kai kɨtön yadöŋa, “Ha na aku Ijip yöbö wö rɨmön hö,” röŋa. Makwam Josep nuömarö du Ijip mɨdɨm, Herod wöröxɨm nugwön, mai höuöil hömä. ");
INSERT INTO tmd_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Makwam Herod nuŋ nugwöŋa, rɨb wä yöx nugub nöbö bla, nuŋ rɨg yadöŋ mag akuyöbö rölim. Aliö nugumɨn, nugwo mɨ ölɨsö diba wölmɨn yadöŋa, “Nɨ alöi aku, ha kiaia nöbö diba mɨdɨba rɨmɨd aku nɨ pödpöd rön nugwo pɨl pal nɨgɨnö?” rön nugwöŋa. Jɨ nuŋ rɨb i yöx nugwön yadöŋa, “Nöbö rɨb wä yöx nugub bla ñɨgö gupö aku wöxnö nɨg wop aku, nɨ yad nöl ri abön dumä. Makwam nɨ nugula, Betlehem il yöra ha yöx pön höm, kɨm mös yön bla aipam, ha mai yöx pön höi bla aipam, pɨl pal nɨgöñ aku, ha aku aipam pɨl pal nɨgöñɨŋö,” röŋa. Aliö rön, nöbö nuŋ bli yad abmɨn duön, ha Betlehem yuadö mɨdim bla magalɨg pɨl pal ab pörmä. ");
INSERT INTO tmd_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Betlehem ha pɨl pal nɨgmä aku, God mönö yadɨb nöbö Jeremaia cönɨŋö, rön, rɨg kai kɨtöŋ mag akwör rɨmä. Jeremaia mönö aku kai kɨtön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rama taun kau aku lɨb pɨlaŋ, mönö diba nɨgön, ib diba immɨjöña. Mö Resel yöxɨm yöxɨŋ yöxɨp u höuöilmel cön bla, lɨb pɨlaŋ immɨjöña. Ha nuŋ bla wöröx pöcöña nugwön nöbö mö bli ñɨgö yad pɨb maga mɨdenɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Makwam mai nöbö dib Herod wöröxɨm, Josep Ijip piaku mɨdön hölɨmön inɨmö nugumɨn, Nöbö Diba ejol nuŋ i hön nugwo yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Nöbö ha kiaia pɨl pal abɨba rɨmɨdim bla mödö wöröxöi makwam, mönaŋ nuömarö hogwa ñɨgö yölɨŋön, höuöil mögörɨb Isrel duanö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ejol aliö rɨmɨn, Josep ha nuömarö hogwa yölɨŋön, höbkal Isrel duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Makwam uröpɨnmɨn, mönö i yadmä, “Herod wöröxɨm, ha nuŋwa Akeleas Judia Propins nöbö mö piaku nugwidɨx mɨdö,” rɨmä. Aliö rɨmɨdmɨn, Josep nuŋ Akeleas mɨd mögörɨb aku pöd raŋ dinö, rön, ipöxöŋ aku, jɨ hölɨmön inɨmö nugumɨn God nugwo yadöŋa, “Mögörɨb Judia höbkal dumɨjɨnö, mögörɨb Galili duanö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Aliö rɨmɨn, Josep mönɨŋ hagap yölɨŋön Nasaret taun duön mɨdmɨdöia. Dumä aku, God mönö yadɨb nöbö bla akuyöbö cönɨŋö, rön, rɨg kai kɨtim mag akwör röŋa. Ñɨŋ kai kɨtön yadmä, “Nugwo nöbö Nasaret yöbö, me cöñɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nasaret mɨdim wop mibɨl aku, Jon röbö pal nölɨb nöbö aku hön, mögörɨb Judia mibɨl yöra, mögörɨb nöbö mö mɨga mɨdmɨdölöi, mögörɨb rɨg kap mibɨl piaku mɨdmɨn nugugɨrön, nöbö mö bla hömɨn, nuŋ ñɨgö mönö yad nölmɨda. ");
INSERT INTO tmd_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ñɨgö yad nölön yadmɨda, “Womiöx mɨda, God nöbö mö pön nugwidɨx mɨjöna. Makwam, ap kib mag gwogwo röi aku, pödpöd rɨmɨn aliö alölɨŋö, rön, röböxne,” rɨmɨda. ");
INSERT INTO tmd_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon ñɨgö mönö yad nölmɨd aku, God mönö yadɨb nöbö Aisaia maduar cönɨŋö, rön, rɨg kai kɨtöŋ mag akwör röŋa. Aisaia mönö aku kai kɨtön yadöŋa, “Nöbö i, mögörɨb nöbö mö mɨga mɨdölöi, mögörɨb rɨg kap mibɨl yöraku du mɨdön, wö rön yajöna, ‘Nöbö Diba hömɨda! Ödöia höña pisö pibö rɨg mɨjön bla, pɨd pɨlɨx rɨg mɨjön bla, pɨn wöd höimöl ri abön mɨjne,’ cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Makwam Jon wölɨj nuŋ aku, hön kamel panö pön rim wölɨj i yömön, hön kau uña amanö nɨgmɨda. Ap nɨmɨb nuŋ aku, baŋ pabladö aku aipam, böm röbö aku aipam nɨmmɨda. ");
INSERT INTO tmd_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Wop aku, Jerusalem mɨdim nöbö mö bla aipam, mögörɨb Judia yuadö mɨdim nöbö mö bla aipam, röbö Jodan il piaku mɨdim nöbö mö bla aipam, ñɨŋ magalɨg Jon mɨdöŋ yöra dumä. ");
INSERT INTO tmd_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Jon mɨdöŋ yöra duön, ap kib mag gwogwo rim bla wöxnö yad pörɨm nugugɨrön, Jon ñɨgö röbö Jodan yuö yax nölmɨda. ");
INSERT INTO tmd_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Makwam Perisi nöbö bla aipam, Sadiusi nöbö bla aipam nöbö mɨga, Jon anɨŋ röbö pal nölaŋ, me rön, hömɨdmɨn, Jon ñɨgö yadyöxön yadöŋa, “Ñɨŋ kas gwogwo ruai! Agö magɨm rɨm ipöxön bör hömɨdöi? ‘Röbö palɨŋ, God nöbö mö nöi piaku ñɨgö yadyöxön wop aku, an yadyöxenɨŋö,’ rön, bör höiŋönö ä? ");
INSERT INTO tmd_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ñɨŋ röbö yaxnöb cöñ aku, ap kib mag gwogwo röi aku, pödpöd rɨmɨn aliö alölɨŋö, rön, röböxön, mɨd ri aböña. Almɨjöñ aku, nöbö mö piaku nugwöña, ñɨŋ ap kib mag gwogwo rɨmɨdöi aku mödö röböxöia. ");
INSERT INTO tmd_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Makwam ñɨŋ rɨb i yöx nugwöña, ‘An nöso maduebö Ebraham halöu ha nuŋwa mɨdöla nugwön God anɨŋ mag gwogwo i renɨŋö,’ rön, rɨb aku yöxmɨjeñ. Ebraham halöu ha nuŋwa mɨdölɨŋö, röi aku hör ap! God rɨg bɨlɨk pön, Ebraham halöu ha nuŋ piaku rɨ nɨgnöb, rön, rɨ nɨgöxa! Makwam, ‘Nöbö waiö Ebraham yöxmɨn yöx höuöilmel rön an keir yöx pön hö nɨgöiŋö,’ röi aku, mönö aliö akuyöbö yadmɨjeñ. ");
INSERT INTO tmd_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Nugw ri aböña! God bɨ aku ila alɨg römalɨba yua mämäl gɨ mɨda. Bɨ i mag nɨmɨb wä bli yaxen aku, nuŋ römaxdörön pɨ rɨn ab wiöna. ");
INSERT INTO tmd_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ñɨŋ ap kib mag gwogwo röi aku, pödpöd rɨmɨn aliö alölɨŋö, rön, röböxöñ aku, nɨ ñɨgö röbö akwör pal nöina. Makwam nöbö nɨ mai hön aku, nuŋ nɨ röxgɨb yöi; nuŋ nöbö dib ödöriö, nɨ nöbö ulmɨdö. Nɨ nugwo nugwön möigw yöxna. Yam uñ nuŋwa pɨrag yönɨb maga mɨdöl. Nɨ ñɨgö röbö akwör pal nölmɨdla jɨ nöbö aku nuŋ hön, ñɨgö Inöm Leia pal nölön, rɨn pina alɨg pal nöiöna. ");
INSERT INTO tmd_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","“Nuŋ wit maga göj waŋ, ödör pön hö rɨg palpatöi mag akuyöbö rɨba rɨmɨda. Wit mag nɨmɨb bla hör nɨgön, wit yöj rɨb rɨb bla hör nɨgöna. Aliö rön, wit mag nɨmɨb nuŋ bla pɨrag du ram möla nɨgöna; jɨ rɨb rɨb bla pön du rɨn öim yönmɨd möl bö wiönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Wop aku, Jisas nuŋ, Jon nɨ röbö pal nölaŋ, me rön, mögörɨb Galili röböxön, röbö Jodan yuö duön, ");
INSERT INTO tmd_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jon nugwo yadöŋa, “Nɨ röbö pal nölö,” röŋa. Jisas aliö rɨmɨn, Jon yadöŋa, “Naŋ döŋö nɨ röbö pal nöilax. Aku nɨ pödpöd rön nagö röbö pal nöin?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Aliö rɨmɨn, Jisas yadöŋa, “Naŋ yadmɨdlö adaku röböxön, nɨ rɨg yadmɨdɨl mag akwör cɨnɨŋ aku, God rɨg yad yad mag akwör cɨnɨŋö,” röŋa. Aliö rɨmɨn Jon, “Mɨ yadlaŋö,” rön, Jisas nugwo röbö pal nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jon Jisas nuŋ röbö pal nölmɨn nugugɨrön, Jisas röbö halaia hön nugumɨn, adöx sö waglöxɨm möla rödmɨn, God Inöma nuŋ yöur döpwö röxg bɨbɨ rɨ pɨn Jisas göröŋa. ");
INSERT INTO tmd_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Aliö alɨp höm nugugɨrön, mönö i God mögörɨb adöx yöd röul adö kau sö pik pön yadöŋa, “Ha wä mɨdö kɨ, ha madmag yöbö nɨ ödöriö. Nɨ nugwo nugumön, nɨ mɨ wä rö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Wop aku God Inöma Jisas nugwo yölɨŋön, mögörɨb nöbö mö mɨdmɨdölöi, mögörɨb rɨg akwör mɨd mibɨl piaku pön dumɨn, kɨjakia nuŋ Jisas ap kib mag gwogwo bli cönɨŋönö wöhö, rön rɨ nugwöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jisas mögörɨb rɨg kap piaku ap i nɨmölöŋ wöhö, wop akuyöbö padokwo padök paŋyöbö i höuöiliö hö pɨn du adokwebö mɨj bö (40) mil pɨxmag yuö alɨg hör ör mɨdöŋa. Alön hör ör mɨdɨm, nugwo mɨ kiö diba pɨlmɨn, ");
INSERT INTO tmd_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","kɨjakia Jisas nugwo rɨba nölmön, mag gwogwo i raŋ me rön hön, Jisas nugwo yadöŋa, “Nɨ God Ha nuŋwa mɨdlö, rɨlö aku, rɨg kɨyöbö yadaŋ bred nɨgaŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Aliö rɨmɨn, Jisas paiŋö yadöŋa, “God Mönö aku kai kɨtön yadmä, ‘Nöbö mö bred akwör nɨmön kömö mɨdeñɨm; God mönö rɨg yad aku magalɨg nugw pöñ aku, kömö mɨjöñɨŋö,’ röiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jisas aliö rɨmɨn, kɨjaki Jisas nugwo yölɨŋ pön du taun dib lei Jerusalem duön, God höjöpalɨb rama mɨ bɨl pisö urim ram aku pön wölu nɨgön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Nɨ God Ha nuŋwa mɨdlö, rɨlö aku, mämäliö mɨgrö bö pɨñɨrö. God Mönö aku kai kɨtön yadmä, ‘God ejol nuŋ bla yadaŋ, nagö imag ñɨŋa bli yöra pɨ gɨ mɨjöñ aku, rɨg i yamsö nagö aku pɨnön renɨŋö,’ röiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Aliö rɨmɨn, Jisas paiŋö yadöŋa, “Ehöu! God Mönö aku mönö um bli kwo kai kɨtön yadmä, ‘God Nöbö Dib aku, nuŋ nöbö mɨ yadɨb mönö inakmönö hörɨb nöbö, me rɨmɨjeñɨŋe,’ röiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Jisas aliö rɨmɨn, kɨjaki Jisas nugwo pön du önöŋ ajmag pɨd dib sö wöluön, mögörɨb wä wä kiŋ hörɨrör nugwidɨx mɨdim bla Jisas nugwo yabuön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Naŋ höxmax yuön, ib na yadaŋ bɨl sö duaŋ, nɨ mögörɨb pi bɨlɨk magalɨg naŋör nöinö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Aliö rɨmɨn, Jisas nuŋ kɨjakia yadöŋa, “Seten nagö hör pikwo duö! God Mönö aku kai kɨtön yadmä, ‘God Nöbö Diba ib nuŋ akwör yadɨŋ bɨl sö duaŋ; mabö nuŋ akwör cɨne,’ röiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jisas aliö rɨmɨdmɨn nugwön kɨjakia nuŋ, Jisas nuŋ ap gwogwo bli cönɨŋö, rön, rɨ rɨ öliöxön, Jisas nugwo röböxön dumɨn nugugɨrön, ejol bli hön, Jisas höñ yöra mɨdön nugwidɨx mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Wop aku röbö pal nölɨb nöbö Jon nugwo nag nɨgmä. Jisas mönö aku yöxön, mögörɨb Galili höuöil duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Duön taun nuŋwa Nasaret mɨdölöŋ; du mɨdöŋ taun ulmɨdö Kapaneam, mögörɨb Sebiulan Naptalai mibɨl yöra mɨd Ban Yuö Galili pö yöra. ");
INSERT INTO tmd_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jisas mögörɨb aku duön, nöbö mö piaku ñɨgö mönö wä aku yad nölɨp yönmɨd makwam, God mönö yadɨb nöbö Aisaia cönɨŋö, rön, rɨg kai kɨtöŋ mag akwör röŋa. Nuŋ yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","“Mögörɨb Sebiulan nɨgön Naptalai nɨgön, Ban Yuö Galili pö yöra, Röbö Jodan naiö du rödɨp pɨmɨd ir kwo röxiö, Juda nöbö mö yöi mögörɨb Galili yöraku mɨdöi akuyöbö ñɨŋ mɨ mil diba mödö nugwöia. Pɨxmag yuö piaku mɨdön wöröxbä maga röŋ aku, jɨ mil dib aku mödö nugwöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jisas wop aku ila nɨgön, nöbö mö akuyöbö ñɨgö God mönö wä aku yad nöl yön gɨrön yadöŋa, “Ap kib mag gwogwo röi aku, pödpöd rɨmɨn aliö alölɨŋö, rön, röböxöña. Womiöx mɨda, God nöbö mö pön mögörɨb adöx yöd röul adö kau sö nugwidɨx mɨjön; wop maiyöbö öim pöx mɨdmɨdöi aku, wopik wöxnö nɨgö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisas Ban Yuö Galili pö pö duön nugwöŋa, nöbö dölöm pɨb nöbö hödpɨg hogwa uben abön dölöm pɨmɨdmä. Nöbö hödpɨg hogwa, nöbö i ib nuŋwa Saimon, nöbö i ib nuŋwa Edru. Saimon ib nuŋ i Pita me rɨmɨdöia. ");
INSERT INTO tmd_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jisas nöbö hogwa nugwön yadöŋa, “Ñɨŋ nɨ mai höi. Nɨ ñɨgö rɨmön, ñɨŋ hödpɨg nöbö hogwa, dölöm pɨmɨdöi adö röböxön, nöbö mö pɨb nöbö mɨjöñɨŋe,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jisas aliö rɨmɨn, rɨg yadöŋ akwör nugwön, dölöm pɨmɨdim uben bla röböxön, Jisas mai dumä. ");
INSERT INTO tmd_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Makwam mɨŋi uplöb duön nugumɨn, Jems Jon yöŋö nuö Sebedi pɨsaŋ alebö möla mɨd gɨrön, uben hö gɨ gɨrön mɨdmä. Jisas nugwön, nöbö hogwa wö rɨm, ");
INSERT INTO tmd_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ñɨŋ nuö Sebedi alebö yöraku röböxön Jisas mai dumä. ");
INSERT INTO tmd_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas mögörɨb Galili mibɨl bla rɨ yön gɨrön, Juda mögum rɨb ram piaku piaku duön, God nöbö mö pön nugwidɨx mɨdɨb mönö wä aku, nöbö mö piaku ñɨgö yad nöl yön gɨrön, agap ap bɨlɨm nöbö mö röŋ akuyöbö rɨmɨn kömö nɨgmɨda. ");
INSERT INTO tmd_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jisas almɨdmɨn, mögörɨb Siria nöbö mö bla magalɨg haiwo aku nugwön, nöbö mö agap ap bɨlɨm röŋ akuyöbö pön höm, Jisas rɨmɨn kömö nɨgmɨda. Nöbö mö piaku, bli ap röŋa; bli mɨxɨñ ölɨŋ diba pɨlöŋa; bli ragwo ha öim nɨgöŋa; bli mämäga mömöinö palmɨn, pɨn bɨrön gɨl gɨl rɨmɨdmä; bli iŋ wajmag lɨd pɨlöŋa; jɨ nöbö mö ap agap bɨlɨm röŋ akuyöbö pön höm, Jisas rɨmɨn magalɨg kömö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Makwam Galili nöbö mö nɨgön, Dekapolis nöbö mö nɨgön, Jerusalem nöbö mö nɨgön, Judia nöbö mö nɨgön, röbö Jodan pö kwo nöbö mö nɨgön, magalɨg Jisas dumɨn nugugɨrön, mai dumä. ");
INSERT INTO tmd_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisas, nöbö mö mɨg piaku nugwön, wölu önöŋ ajmag pɨd sö nöbö nuŋ akuyöbö mɨgan kwo pɨsaŋ römɨd gɨ mɨdön, ñɨgö mönö yad nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jisas nuŋ ñɨgö yad nöl gɨrön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Nöbö mö bla, an nöbö mö waiö yöi, God nuŋwör anɨŋ rɨ nöiönɨŋö, rön, God nugwo yad nugwöñ bla, God ñɨgö pön mögörɨb adöx yöd röul adö kau sö nugwidɨx mɨjön makwam, ñɨŋ mɨ wahax pɨmɨdɨŋ. ");
INSERT INTO tmd_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nöbö mö immɨdöi bla, God ñɨgö yad pön makwam, ñɨŋ mɨ wahax pɨmɨdɨŋ. ");
INSERT INTO tmd_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nöbö mö höimöliö tar mɨdöi bla, ñɨŋ mögörɨb il kɨ pöñ makwam, ñɨŋ mɨ wahax pɨmɨdɨŋ. ");
INSERT INTO tmd_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nöbö mö, God yadöŋ mag akwör cɨnɨŋö, rön, nugwöi bla, God ñɨgö nugwidɨx mɨjön makwam, ñɨŋ mɨ wahax pɨmɨdɨŋ. ");
INSERT INTO tmd_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nöbö mö bli ñɨŋ nöbö mö bli uliöxön pɨ ösös rɨ ri aböñ aku, God ñɨgö paiŋö algör ör uliöxön pɨ ösös rɨ ri abön makwam, ñɨŋ mɨ wahax pɨmɨdɨŋ. ");
INSERT INTO tmd_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nöbö mö God nugwo rɨb paŋyöbö iör yöx nugwöi bla, God nugwo nugwöñ makwam, ñɨŋ mɨ wahax pɨmɨdɨŋ. ");
INSERT INTO tmd_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nöbö mö nugwöña, nöbö mö bli nuö pɨlön rɨmɨjöñ aku, ñɨŋ hön yajöña, ‘Ñɨŋ mag akuyöbö almɨjeñ, tar mɨjne,’ rön, wöhö cöñ akuyöbö, God ñɨgö halöu ha nɨ bɨlɨm, me cön, makwam, ñɨŋ mɨ wahax pɨmɨdɨŋ. ");
INSERT INTO tmd_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nöbö mö ñɨŋ God rɨg yad mag akwör cɨnɨŋö, rön, rɨmɨdɨŋ, nöbö mö bli ñɨgö rɨ gwogwam rɨmɨjöñ aku, God ñɨgö pön mögörɨb adöx yöd röul adö kau sö nugwidɨx mɨjön makwam, ñɨŋ mɨ wahax pɨmɨdɨŋ. ");
INSERT INTO tmd_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Nöbö mö piaku, ñɨgö Jisas nöbö mö nuŋ bɨlɨm me rön rɨ gwogwam rön, inakmönö hörön, yad höimöuöñ aku, ñɨŋ mɨ ödöriö wahax pöña. ");
INSERT INTO tmd_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Maduar God mönö yadɨb nöbö akuyöbö ñɨgö kwo paŋ mag akwör rɨmä. Makwam, ñɨŋ algön nör rɨmɨjöñ aku, rɨb diba yöxmɨjeñ; God ana mögörɨb adöx yöd röul adö kau sö pɨ ösös rɨ ri abönɨŋö, rön kwönö, ñɨŋ mɨ ödöriö wahax pɨnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jisas mönö aku yadön yadöŋa, “Nöbö mö mögörɨb mɨgrö kɨ mɨdöi akuyöbö usö ñɨŋa, ñɨgö mɨdöia. Makwam usö aku ida pal mag du pöraŋ yörbö id yönen; mɨ aŋadö gwogwo rö, rön, röbɨl patön ki bö aböña. ");
INSERT INTO tmd_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Taun diba pɨd sö mɨdön, umad gɨ mɨdɨb maga mɨden; mɨ ödöriö wöxnö mɨjöna. Mag aliö akuyöbö, nöbö mö mögörɨb mɨgrö kɨ mɨdöi akuyöbö, ñɨŋ hötɨkö mil ñɨŋa röxg mɨdöia. ");
INSERT INTO tmd_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nöbö mö akuyöbö hötɨkö urön wi yöj mo möl böisö umadeñ. Bɨl yöra sö cɨx nɨg gɨŋ mil abaŋ, nöbö mö ram möl yuadö bla magalɨg nugw ri aböña. ");
INSERT INTO tmd_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Makwam mag aliö akuyöbö, ñɨŋ nöbö mö piaku ñɨgö pɨ ösös rɨ ri abɨŋ, nöbö mö piaku ñɨgö nugwön, Nuö ñɨŋa adöx yöd röul adö kau sö mɨd akwör ib nuŋwa yadɨŋ bɨl sö diöna. ");
INSERT INTO tmd_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ñɨŋ yajöña, Jisas hö aku, God Mosɨs nugwo lo mönö yadöŋ mönö adaku aipam, God mönö yadɨb nöbö bli yadim mönö adaku aipam, röböxɨŋ me rön hö, cöñ aku, jɨ aku maku yöi! Nɨ höl aku, God mönö yadɨb nöbö bla cönɨŋö, rim mag akuyöbö magalɨg cɨnö, rön, höla. ");
INSERT INTO tmd_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nɨ ñɨgö mɨ ödöriö yadmɨdla. Adöx sö mögörɨb mɨgrö kɨ pɨsaŋ hölögɨpöna, jɨ lo mönö aku rɨb ul mɨŋi hölögɨpen; magalɨg öim mɨjöna. Mönö agamö agamö röŋ aku, magalɨg rɨg yadöŋ mag akwör cöna. ");
INSERT INTO tmd_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","“Makwam, nöbö mö bɨl kai God lo mönö aku nugwön, mönö ul mɨŋi röböxnö, rön, nöbö mö akuyöbö amnör yad nölaŋ röböxöñ aku, God nöbö mö pön nugwidɨx mɨdɨb wop aku, ib ñɨŋa pɨn diöna. Jɨ nöbö mö bɨl kai God lo mönö nugwön, nugw ri abön, nöbö mö piaku ñɨgö yad nöl ri abmɨjöñ aku, God nöbö mö pön nugwidɨx mɨjön wop aku, ib ñɨŋa wöliöna. ");
INSERT INTO tmd_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Perisi nöbö piaku aipam, God lo mönö yad nölɨb nöbö bla aipam, ‘God rɨg yadmɨd mag akwör rölɨŋö,’ röi aku, jɨ ñɨŋ hör mönö akwör yadön, God rɨg yadmɨd mag akwör rölöi, wöhö. Ñɨŋ keir piöŋö, God mönö rɨg yadmɨd akuyöbö akwör nugwön ödöriö mɨda akwör mai diöña. Aiöñ aku makwam, God ñɨgö pön wölu adöx yöd röul adö kau sö nugwidɨx mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Maduar nöhönɨŋ apɨnɨŋ maduebö akuyöbö God lo mönö yadmɨdöi aku, ñɨŋ mɨdö nugwöia. Ñɨŋ yadmɨdöia, ‘Nöbäpö pɨl pal nɨgmɨjeñ. Nöbö i, nöbö i pɨl pal nɨgön aku, mönö diba nugwönɨŋö,’ rɨmɨdöia. ");
INSERT INTO tmd_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mönö aku nugwöi aku, jɨ weik nɨ ñɨgö yad ri aböna. Nöbö i, nöbö i nugwaŋ ölɨsö waiön aku, mönö diba nugwöna. Nöbö i, nöbö i iba mag pɨn diön aku, Juda Kansol bla hö mögum rön, nugwo mönö diba yajöña. Nöbö i, nöbö i nugwo yajöna, ‘Nagö nöbö u,’ me cön aku, mögörɨb rɨn hör yönmɨd möl bö dubä maga ra. ");
INSERT INTO tmd_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Makwam, nagö God höjöpal ur nölɨb apa pön du rɨgpɨd rola höjöpal ur nöinöb, haul nöbö mölöu nöbö nagö nugwön pɨsaŋ nuö pilö akuyöbö mönö mɨdö, cɨnö aku, ");
INSERT INTO tmd_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","God höjöpal ur nölɨb ap aku rɨgpɨd rola röböxön, nöbö aku pɨsaŋ mönö nɨg ri abön, wopik tar paŋör nɨgiö nɨgön mɨdɨŋö, rön, höbkal hö ap aku God höjöpal ur nölö. ");
INSERT INTO tmd_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ap agapɨm rɨ gwogwam cöñ aku, ñɨgö mönö diba yadɨba pön ödöi mibɨl yöra dumɨdɨŋ nugugɨrön, ñɨgö pɨsaŋ mönö aku nɨg pal wöröxön, pɨ nɨgiö nɨgön mɨjöña. Nöi mɨjön aku, ñɨgö pön du nöbö diba iŋsö rola nɨgɨŋ, nuŋ piöŋö ñɨgö pön ömdö nöbö nölaŋ, ñɨgö pön du nag nɨgöña. ");
INSERT INTO tmd_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nɨ ñɨgö mɨ ödöriö yadmɨdla, ap rɨb ñɨŋ aku aŋadö rɨba wöd pörön diöña. ");
INSERT INTO tmd_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Makwam mönö i yadim aku, aku kwo algör nugwöia. Mönö aku yadmä, ‘Nöbö mö kib mag yön mɨjeñɨŋö,’ rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Makwam nɨ ñɨgö yadmɨdla, nöbö i mö i nugwön, nugwo rɨlöxmö rön rɨbyöx nugwön aku, God nugwaŋ, nöbö aku rɨb nuŋ maga mö aku kib pɨsaŋ yöñöna. ");
INSERT INTO tmd_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Makwam, mämäg mɨrɨx adö nugwaŋ, ap kib mag gwogwo rɨb maga rɨmɨjön aku, mämäg adaku röd aböña. Akuyöbö aiöñ aku, mämäg paŋ adöi ör mɨdaŋ kömö diöña. Nöi mɨjön aku, ñɨŋ ap kib mag gwogwo rön, mɨñ rɨn nöi yönmɨd möl bö dubä maga ra. ");
INSERT INTO tmd_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Makwam imag mɨrɨx pɨlö aku kwo algör, ap kib mag gwogwo rɨb maga rɨmɨjön aku, römaxdör aböña. Akuyöbö aiöñ aku, iŋpɨlö paŋ adöi ör mɨdaŋ kömö diöña. Nöi mɨjön aku, ñɨŋ ap kib mag gwogwo rön, mɨñ rɨn nöi yönmɨd möl bö dubä maga ra. ");
INSERT INTO tmd_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ñɨŋ nugwöia, mönö i yadmä, ‘Nöbö i mönɨŋ nuŋwa röböxnöb, mö kɨ aŋadö röböxnö, rön, köp mei kɨtön, mö aku nugwo nölön mönö, aŋadö röböxönɨŋö,’ rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Makwam nɨ ñɨgö yadmɨdla: nöbö i, mönɨŋ nuŋwa nöbö i kib pɨsaŋ yönen wöhö, nöbönɨŋ nuŋwa mönɨŋ hör röböxön aku, mag gwogwo cöna. Mö aku nugwo akuyöbö alön röböxaŋ, du nöbö yoŋyöbö i pön aku, nöbö aku nuŋ mönɨŋ nuŋwa röböxön makwam, nuŋ alaŋ mönö, mönɨŋ nuŋwa nöbö kib mag yönɨb mö i röxgöna. Makwam nöbö kai mö aku pön aku, nuŋ kwo algör mö kib mag yönɨb nöbö i röxgöna. ");
INSERT INTO tmd_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Maduar mönö i yadmä aku, aku kwo algör nugwöia. Mönö aku yadmä, ‘Ñɨŋ Nöbö Diba mämäg il rol nuŋwa mönö mɨ ödöriö yajöñ aku, rɨg yajöñ akuyöbö akwör cöña. God nuŋ nugugu mɨda nugwön rɨg yajöñ maga akwör cɨne,’ rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Makwam nɨ ñɨgö yadmɨdla: mönö i yajnöb rön, ‘God mämäg il rol aku mi yadmɨdlö,’ rön yadmɨjeñ. ‘Mögörɨb adöx yöd röul adö kau sö mɨd aku, mi yadmɨdlö,’ rön yadmɨjeñ; mögörɨb yöraku God hogw rol kiŋ nuŋwa rola römɨd gɨ mɨda. ");
INSERT INTO tmd_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","‘Mögörɨb mɨgrö kɨ kwo mɨd aku mi yadmɨdlö,’ rön yadmɨjeñ; God hogw rol kiŋ nuŋwa rola römɨdön, yödpɨlö nuŋwa mögörɨb mɨgrö kɨ röb gɨ mɨda. ‘Jerusalem mɨd aku mi yadmɨdlö,’ rön yadmɨjeñ; aku Kiŋ Dib ödöriö taun dib nuŋwa maku. ");
INSERT INTO tmd_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","‘Yöcmac na mɨd aku mi yadmɨdlö,’ rön yadmɨjeñ. Ñɨŋ keir rɨŋ, yöcmac panö ñɨŋa paŋyöbö i hal mönö pɨxɨm wölen. ");
INSERT INTO tmd_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Aku, ‘Cɨnö’ rön, ‘Cɨnö’ akwör rö; ‘Röinö’ rön, ‘Röinö’ akwör rö. Mönö yadön wab i kwo yajöñ aku, kɨjaki ñɨgö rɨba nölaŋ yajöña. ");
INSERT INTO tmd_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Makwam mönö i yadmä aku kwo algör nugwöia. Mönö aku yadmä, ‘Mämäga pɨn gul rɨŋ mönö, ñɨŋ paiŋö aipam pɨn gul rɨ aböña. Aj maga pal kɨtuŋ mönö, ñɨŋ paiŋö aipam pal kɨtinö,’ rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Jɨ nɨ ñɨgö yadmɨdla: nöbö i ñɨgö rɨ gwogwam rɨmɨdaŋ mönö, nugwo paiŋö rɨ gwogwam rɨmɨjeñ. Nöbö i ñɨgö alguna palaŋ mönö, pikwo rɨŋ adöi wobiö paiöna. ");
INSERT INTO tmd_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nöbö i hön ñɨgö mönö diba yadön, ‘Ap uñ nagö aku nɨ nölö,’ rɨmɨdaŋ mönö, ap uñ akwör nölmɨjeñ, ij ap uñ aku wobiö nöiöña. ");
INSERT INTO tmd_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nöbö i ñɨgö yad nugwön, ‘Ap yogw kɨ rag du yöra abön hane,’ rɨmɨjön aku, höj nugumɨjeñ; yajön yöra nugu gɨrön, rag padɨx du hör piaku abön höña. ");
INSERT INTO tmd_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nöbö mö bli ñɨgö, ‘Anɨŋ ap bli nöine,’ rɨmɨdɨŋ, amnör nöiöña. Makwam nöbö mö bli ñɨgö, ‘Anɨŋ ap bli hör nölɨŋ, mai paiŋö nölɨŋö,’ rɨmɨdɨŋ, röböxmɨjeñ, amɨn nöiöña. ");
INSERT INTO tmd_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mönö i yadmä aku kwo algör nugwöia. Mönö aku yadmä, ‘Haul hödpɨg ñɨŋ bla ñɨŋ madmag nɨgön; nöbö mö pɨlgɨb imgɨb ñɨŋ bla ñɨŋ haŋaj mäp yuö nugune,’ rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Jɨ nɨ ñɨgö yadmɨdla: nöbö mö pɨlgɨb imgɨb ñɨŋ bla, ñɨŋ madmag nɨgön; nöbö mö ñɨgö rɨ gwogwam röi piaku, ñɨŋ God höjöpalön yajöña, ‘Naŋ ñɨgö nugwidɨx mɨd ri abanö,’ cöña. ");
INSERT INTO tmd_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","“Ñɨŋ akuyöbö aiöñ aku, Nuö ñɨŋa adöx yöd röul adö kau sö mɨd aku, halöu ha nuŋwa ödöriö mɨjöña. Nuŋ rɨmɨn, naiö mil abmɨn, nöbö mö mag wä rɨmɨdöi piaku aipam, nöbö mö mag gwogwo rɨmɨdöi piaku aipam, mila abmɨda. Nuŋ rɨmɨn, ruö pɨlmɨn, nöbö mö mag wä rɨmɨdöi bla ap möriwö ñɨŋ bla wölmɨn, nöbö mö mag gwogwo rɨmɨdöi bla ap möriwö ñɨŋ bla aipam ap wöla. ");
INSERT INTO tmd_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ñɨŋ nöbö mö ñɨgö madmag nɨgöi piaku pɨ ri aböñ aku, nöbö takis pöi bla rɨg rɨmɨdöi mag akwör cöña. Almɨjöñ aku, God nagö pöd raŋ wahax pön ñɨgö ap wä nöiön? ");
INSERT INTO tmd_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ñɨŋ haul nöbö mölöu nöbö ñɨŋ bla akwör yadön wahax pöñ aku, nöbö mö God rɨbyöx nugwölöi bla, nöbö mö hör bla ñɨgö rɨg rɨmɨdöi mag akwör cöña. ");
INSERT INTO tmd_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","“Makwam, Nuö adöx yöd röul adö kau sö rɨ ri ab gɨ mɨd mag akuyöbö, ñɨgö kwo algör mag wä akwör rön rɨ ri aböña. ");
INSERT INTO tmd_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Makwam ñɨŋ, ib diba pɨnɨŋö, rön, nöbö mö mämäg il rol ñɨŋ akwör God rɨg yad mag akwör rɨŋö, rön, röi aku, Nuö ñɨŋa adöx yöd röul adö kau sö mɨd aku nuŋ nugwön ñɨgö paiŋö ap wä i nölen. ");
INSERT INTO tmd_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Nöbö mö bli, God nugw pölɨŋö, rön, inakmönö hörön röia. Ib diba pɨnɨŋö, rön, ñɨŋ nöbö mö lɨblɨb mɨdö bla rɨg ap bli nöinöb, Juda mögum rɨb rama nöbö mö mɨga mɨjöñ yuadö aku mönö ödöi diba nöbö mö mɨga uhömɨjöñ akuyöbö duön, nöbö mö mämäg il rol yöra nöiöña. Aiöñ aku nɨ ñɨgö yadmɨdla: ib diba pɨnɨŋö, rön, ñɨŋ paiŋö pöñ apa maku; Acö ñɨgö ap bli kwo nölen. Ñɨŋ almɨdöi mag akuyöbö almɨjeñ. ");
INSERT INTO tmd_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","“Makwam ñɨŋ nöbö mö lɨblɨb rɨ mɨdö bla ap nöinöb, wöxnö nölmɨjeñ; ");
INSERT INTO tmd_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","tar umadiö nöiöña. Ap agapɨm tar rɨmɨdöi aku, Nuö ñɨŋa magalɨg nugw aku, agap ap bɨlɨm cöña nugwön, ñɨgö paiŋö ap wä nöiöna. ");
INSERT INTO tmd_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ñɨŋ God höjöpainöb cöñ aku, nöbö mö bli, God rɨbyöx nugwölɨŋö, rön, inakmönö hörön rɨg rɨmɨdöi mag akuyöbö almɨjeñ. Ñɨŋ nöbö mö bli an nugwɨŋ, ib diba pɨnɨŋö, rön, du Juda mögum rɨb ram mibɨl piaku mɨdön mönö du ödöi römögɨl bla mɨdön, nöbö mö mämäg il yöra God höjöpalöia. Alöi akuyöbö nɨ ñɨgö yadmɨdla, ib diba pɨnɨŋö, rön, ñɨŋ paiŋö pöñ apa maku; God nuŋ mönö ñɨŋ aku yöxenɨm. ");
INSERT INTO tmd_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Makwam, ñɨŋ God höjöpainöb cöñ aku, ram ñɨŋa ram möl yuebö wöluön, uba idɨxön, Acö ana mämäga nugwölöl Nöbö aku höjöpaiöña. Ap kai tar umadiö röi aku, Nuö ñɨŋa magalɨg nugw aku, agap ap bɨlɨm rɨmɨdɨŋ nugwön, mönö ñɨŋa yöxön, ñɨgö paiŋö ap wä nöiöna. ");
INSERT INTO tmd_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Nöbö mö God Mönö nugwölöi bla, höjöpainöb, mönö mɨxɨla pöxöia. Rɨb ñɨŋ akwör yöxön yadöia, ‘Mönö mɨxɨla pɨxɨŋ nuŋ nugwönɨŋö,’ röia. ");
INSERT INTO tmd_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Makwam ñɨŋ mag akuyöbö almɨjeñ. Mönö kai ñɨŋ Nuö ñɨŋa höjöpainöb cöñ aku, nuŋ höd nugwa. ");
INSERT INTO tmd_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Makwam, God höjöpainöb rön, aliö yajöña, ‘Acö ana, naŋ adöx yöd röul adö kau sö mɨdlö; nöbö mö ib nagö yadɨŋ mɨ bɨl sö duaŋ. ");
INSERT INTO tmd_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Naŋ nöbö mö pön nugwidɨx mɨjɨnö wop aku rɨmgör haŋ. Mögörɨb adöx yöd röul adö kau sö naŋ rɨg yadlö akuyöbö yöxön mai duöi aku, an mögörɨb mɨgrö kɨ algör rɨg yadlö nugwön mai duŋ. ");
INSERT INTO tmd_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Naŋ wop paŋ paŋ anɨŋ ap nuöm nɨg nöilö mag akuyöbö, wopik kɨ kwo algör an ap mag bli kwo algör nölö. ");
INSERT INTO tmd_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nöbö mö bli anɨŋ rɨ gwogwam röia nugwön röböxöl aku, an ap kib mag gwogwo röl aku, naŋ mag gwogwo ana aku algör nugwön röböxö. ");
INSERT INTO tmd_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kɨjaki an pɨxmɨn, mag gwogwo rɨba maga ra aku, naŋ anɨŋ nugwidɨx mɨdaŋ, an ap kib mag gwogwo i röinɨŋ. Nöbö mag gwogwo akwör rɨmɨd Nöbö Gwogwo aku, naŋ ödöi nugwo wobaŋ, an mɨd ri abnɨŋa. Naŋör Kiŋ keiryöbö mɨdlö; naŋör ölɨsö keiryöbö ödöriö mɨdlö; naŋör mil keiryöbö alɨg mɨdlö; öim öim mag aliö akwör mɨjöna. Mag aliö akuyöbö aku mag waiö,’ cöña. ");
INSERT INTO tmd_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Nöbö mö bli ñɨgö mɨ rɨ gwogwam rɨmɨdɨŋ nugwön röböxöñ aku, Nuö ñɨŋa adöx yöd röul adö kau sö mɨd aku ap kib mag gwogwo ñɨŋ rɨmɨjöñ aku kwo algör nugwön röböxöna. ");
INSERT INTO tmd_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Jɨ nöbö mö bli ñɨgö rɨ gwogwam rɨmɨdɨŋ nugwön röböxeñ aku, Nuö ñɨgö ap kib mag gwogwo ñɨŋ rɨmɨjöñ aku kwo algör nugwön röböxen. ");
INSERT INTO tmd_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ñɨŋ ap mag möjnöb, nöbö mö God nugwo rɨbyöx nugwölɨŋö, rön, inakmönö hörön röi mag akuyöbö, almɨjeñ. Ñɨŋ, ‘An mab ab gɨba alɨg alɨg mɨdɨŋ, nöbö mö nugwön yajöña, “God rɨbyöx nugwön, ap mödön rɨmɨdöi aku, mab ab gɨba alɨg alɨg mɨdöiŋö,” cöñɨŋö,’ rön, inakmönö hörön akuyöbö alöia. Nɨ ñɨgö mɨ ödöriö yadmɨdla: nöbö mö an nugwɨŋ, me rön, cöñ mag aku, nöbö mö piaku nugwön ib ñɨŋa yadɨŋ bɨl sö diön aku, jɨ God ñɨgö ap wä nölen. ");
INSERT INTO tmd_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ñɨŋ piöŋö ap nɨmɨb bla mödön rɨmɨjöñ aku, mab ab gɨba alɨg mɨdmɨjeñ. Röbö pal ri abön, wel röbö pɨlön, kwom rön, mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Akuyöbö almɨjöñ aku, ñɨgö nöbö mö ap mag mödöi piaku, me rön, nugweñ. Ap tar röi aku, Nuö ñɨŋa, an mämäga nugwölöl Nöbö aku, nuŋ magalɨg nugwa aku, ñɨgö paiŋö nölön ap wä nöiöna. ");
INSERT INTO tmd_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Makwam mögörɨb mɨgrö kɨ ap wä wä akuyöbö pɨ mögum cɨnɨŋö, rön, rɨb aliö yöx nugumɨjeñ. Aku agapɨm: ap piaku pɨ mögum rɨmɨjöñ aku, sɨpnö nɨmön, lɨduön, kib pön, cöña. ");
INSERT INTO tmd_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Makwam, ap wä ñɨŋ akuyöbö, God mögörɨb adöx yöd röul adö kau sö pɨ mögum rɨŋ, sɨpnö nɨmenɨm, lɨduenɨm, kib peñɨm, mɨd bör mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ap wä ñɨŋa mögörɨb mɨgrö kɨ pɨ mögum rɨmɨjöñ aku, rɨb ñɨŋa mɨjön mögörɨb mɨgrö kɨ ör; ap wä ñɨŋa God mögörɨb adöx yöd röul adö kau sö pɨ mögum rɨmɨjöñ aku, rɨb ñɨŋa diön paŋ sar. ");
INSERT INTO tmd_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mämäga mɨxɨñ hötɨkö mil röxg mɨda. Mämäg ñɨŋ aku wä mɨdaŋ, mil wä abaŋ nugw ri aböña. ");
INSERT INTO tmd_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Jɨ mämäg ñɨŋ aku gwogwo raŋ, mɨxɨñ ñɨŋ aku pɨxmag guyöna. Mil aböxa jɨ aŋadö pɨxmag guraŋ, ap i nugweñ. Ñɨŋ mila nugwölöi aku, pɨxmag rɨg gur aliö mɨdöia. ");
INSERT INTO tmd_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Nöbö paŋyöbö i, nöbö dib mös mabö rɨ nölɨb maga mɨdöl. Aku agapɨm: nöbö dib i nugwo nugwaŋ wä rɨmɨdaŋ, i röböxöna: jɨ nöbö dib i nugwo nugwaŋ wä rɨmɨdaŋ, i röböxöna. Makwam, ñɨŋ rɨg ap wä mögörɨb mɨgrö kɨ mɨd akuyöbö nugumɨn wä rɨmɨn, God nugwo röböxbä maga ra aku, nugw ri aböña. ");
INSERT INTO tmd_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Mag aliö akuyöbö nɨ ñɨgö yadmɨdla: ap pikai yöbö nɨmön mɨjnɨŋ, wölɨja pikai yöbö yömön mɨjnɨŋö, rön, rɨb diba yöxmɨjeñ. Kömö mɨdɨb mag aku ap dib; ap mag nɨmɨb mag ap ulmɨdö. Wopik mɨdöl kɨ, mɨxɨña ap yöbö; mɨxɨña wölɨj röbɨb aku ap ulmɨdö. Almɨn nugwön, God ñɨgö rɨ nɨgöŋ aku, nuŋ ap nɨmɨb, wölɨj mɨxɨñ röbɨb, ap ulmɨdö piaku nölenɨŋö, rön, rɨbyöx nugwöiŋ ä? ");
INSERT INTO tmd_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ñɨŋ nugwöia, yöur bla ap iñ yuölöi; wit ap bla ödör pön hö mögum rölöi. Jɨ Nuö ñɨŋa adöx yöd röul adö kau sö mɨd aku ñɨgö nugwidɨx mɨdmɨn, ap nɨmöia. Makwam, yöur bla hör ap jɨ nuŋ ap mag rɨm nɨmöi aku mɨ, ñɨgö kwo algör nölenɨŋö, rön, rɨbyöx nugwöiŋ ä? ");
INSERT INTO tmd_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Owa, rɨb mɨga yöxön mönö, mɨŋi uplöb mɨdön wöröxnɨŋö, rön, rɨbyöx nugwöiŋ ä? ");
INSERT INTO tmd_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Makwam pödpöd rɨmɨn wölɨj ap akuyöbö rɨb mɨga yöxmɨdöi? Ap kia wölön pɨpɨl yax bla, mabö rölöi, wölɨj rölöi. ");
INSERT INTO tmd_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Jɨ kiŋ Solomon rɨg mɨga mɨdmɨn ud wä wabɨl ri abön rɨmɨd aku, ap pɨpɨl piaku röxgɨb ud wä wabɨlön rölöŋ. ");
INSERT INTO tmd_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ap pɨpɨl piaku hör ap. Öim mɨden wöhö, weik yöbö mɨdön, laŋ yöbö uröia. Makwam God hör ap piaku rɨ nɨgön ud wabɨl nöl ri ab aku, pödpöd rɨmɨn an nugwidɨx mɨdenɨŋö, rön, rɨbyöx nugwöi? Ñɨŋ aliö rɨbyöx nugwöñ aku, ñɨŋ God nugw pɨ ri abölöi. ");
INSERT INTO tmd_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Makwam, ap kai nɨmön, röbö kai nɨmön, wölɨj kai röbön cɨnɨŋö, rön, rɨb diba yöxmɨjeñ. ");
INSERT INTO tmd_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nöbö mö God Mönö nugwölöi piaku, ap piaku pɨnɨŋö, rön, rɨb diba aku aliö yöx nugwöia. Jɨ ñɨŋ nugwöia, Nuö ñɨŋa adöx yöd röul adö kau sö mɨd aku, ñɨŋ ap bɨl kai mɨdöl aku nugwa. ");
INSERT INTO tmd_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Makwam, God nöbö mö bli pön nugwidɨx mɨjön aku, an kwo algör pönɨŋö, rön, rɨb paŋyöbö akwör yöx nugwöña; God nuŋ rɨg yadöŋ maga akwör rɨ mɨjnɨŋö, rön, rɨb paŋyöbö akwör yöx nugwöña; ñɨŋ akuyöbö alɨŋ diön aku, ap nɨmɨb, röbö nɨmɨb, wölɨj röbɨb, ap piaku magalɨg ñɨgö nöiöna. ");
INSERT INTO tmd_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Makwam, laŋ lonkwo agapɨm rön mɨjnɨŋö, rön, rɨb dib aku yöxmɨjeñ. Wopik aku weik. Weik ör ömörö bli mɨd aku, paŋ akwör rɨbyöx nugwöña. ");
INSERT INTO tmd_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“An nöbö mö wä bɨlɨm, me rön, nöbö mö bli ñɨŋ rɨb gwogwo yöx nugumɨjöñ aku, mönö aku höbkal ñɨŋör höna. ");
INSERT INTO tmd_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Makwam, nugw ri aböña. Ñɨŋ nöbö mö bli ñɨgö rɨmɨjöñ aku, God ñɨŋ mag paiŋö cöna. Ñɨŋ nöbö mö bli nugwön mönö diba yadmɨjöñ aku, God ñɨŋ kwo algör mönö diba yajöna. ");
INSERT INTO tmd_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Bäpö mea mämäg ñɨŋa bɨcepa mɨd aku, pödpöd rɨmɨn bäpö mea aku hör ap, me rön, pɨgnaŋ ap bɨcep mea mämäg nuŋwa mɨd aku nugwön yadmɨdöi? ");
INSERT INTO tmd_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","5","Naŋ inakmönö hörɨb nöbö. Bäpö mea mämäg ñɨŋa pöröb gɨ mɨd aku höd pɨ ab gön, mämäga ix nugw ri abön, pɨgnaŋ ap bɨcep mämäg yuö nuŋwa mɨd aku, ‘Pɨ abnö,’ rön yajöña. ");
INSERT INTO tmd_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","God ap lei nuŋ bla, wöñö höpebö bla nölmɨjeñ. Köme wödö bla, hön bla mɨdöiŋö, rön, pɨ abmɨjeñ. Aku agapɨm: pɨ aböñ aku, ñɨŋ rɨb wademɨl hörön, höuöil hön ñɨgö öbɨxöña. ");
INSERT INTO tmd_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ap agapɨm mɨden aku, God nugwo yad nugwɨŋ ñɨgö nöiöna. Makwam ap bli hölu nugwöñ aku, pöña. Anɨŋ uba rödö, rön, pal gigu rɨŋ, ub ñɨgö röjöna. ");
INSERT INTO tmd_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Aku agapɨm: nöbö mö God nugwo yad nugwöñ aku, rɨg yad nugwöñ mag akwör cöna. Ap hölu nugwöñ aku ñɨgö yabuöna. Makwam, uba rödö, rön, pal gigu rɨŋ, rɨg yajöñ akuyöbö nugwön röjöna. ");
INSERT INTO tmd_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ñɨŋ nöbö nuö bla, halöu ha ñɨŋ i bred i nölö raŋ, ñɨŋ rɨg nöiöñɨŋönö ä? ");
INSERT INTO tmd_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Owa jɨ, dölöm i nölö raŋ, kas i nöiöñɨŋönö ä? Akuyöbö aleñ. ");
INSERT INTO tmd_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ñɨŋ nöbö mö waiö yöi aku, jɨ halöu ha ñɨŋ bla ap wä bla akwör nöiöña. Nuö ñɨŋa adöx yöd röul adö kau sö mɨd Nöbö waiö ödöriö aku, inakmönö hören; ñɨŋ yad nugwöñ aku, nuŋ ñɨgö ap wä nöiöna. ");
INSERT INTO tmd_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Makwam ñɨŋ keir, nöbö mö piaku ñɨŋ anɨŋ mag aku rɨŋ, mag aku rölɨŋ, me rön nugwöi mag akuyöbö, ñɨŋ paŋ mag akwör ñɨgö nöbö mö piaku rɨmɨjöña. Mosɨs God lo mönö pön kai kɨtöŋ mönö aku aipam, God mönö yadɨb nöbö kai kɨtim mönö aku aipam, ila maku. ");
INSERT INTO tmd_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“Rɨn nöi yönmɨd möl bö dub ubalɨj dib aku wöxnö nugwön ödöi diba du ri abmɨdöia. Nöbö mö mɨg mɨŋa ödöi dib aku dumɨdöia. Makwam, ñɨŋ nugw ri abön, ubalɨj ulmɨdö aku diöña. Öim mɨdɨb ubalɨj aku ubalɨj ulmɨdö. Ödöi ulmɨdö aku dinöb rön mɨŋi rɨ öliöxön dumɨdöia. Nöbö mö paŋ paŋ ñɨŋör, ödöi ulmɨdö aku hölu nugwön dumɨdöia. ");
INSERT INTO tmd_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Makwam nöbö mö God mönö yadmɨdölɨŋö, rön, inakmönö hörön yadöi bla, hön sipsip höimölɨb wä akuyöbö röxgɨb höñ aku, jɨ hön mɨd gɨrön, wöñö höpebö nöbö mö öbɨx nɨg mag akuyöbö ñɨgö cöña. Makwam, nugw ri aböña. ");
INSERT INTO tmd_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nöbö mö mɨd ri aböi akuyöbö tatal röxgɨb höña, jɨ ñɨŋ ap kib mag gwogwo rɨmɨjöñ akuyöbö nugwön, ñɨgö nugw ri aböña. Ñɨŋ nugwöia, nag hör kaigap alɨg bla mag nɨmɨb aku yaxaŋ kɨtu nɨmeñ. ");
INSERT INTO tmd_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Bɨ blaku algör cöna. Mag göja nɨmɨb bɨ bla, mag wopa yaxen. Bɨ wopa mag nɨmölɨba bla, mag göj nɨmɨba yaxen. ");
INSERT INTO tmd_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Bɨ mag wä yaxen akuyöbö, römaxdörön pön du rɨn yuö aböña. ");
INSERT INTO tmd_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Makwam, nöbö mö piaku rɨg cöñ maga nugwön, nöbö mö adaku nöbö mö wä, nöbö mö adaku nöbö mö gwogwo, me rön, nugwöña. ");
INSERT INTO tmd_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Nöbö mö nɨ, ‘Nöbö Dib an!’ ‘Nöbö Dib an!’ me röi aku magalɨg, God ñɨgö pön nugwidɨx mɨjönɨŋö, rön, rɨba aliö yöx nugumɨjeñ. Acö na adöx yöd röul adö kau sö mɨd aku rɨg yad mag akuyöbö röi nöbö mö piakwör ñɨgö pön wölu adöx yöd röul adö kau sö nugwidɨx mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","God nöbö mö mönö diba yajön wop aku, nöbö mö mɨg mɨŋa nɨ yajöña, ‘Nöbö Dib, an nöbö mö naŋ akwör. Ib naŋ akwör yadön, mönö naŋa yad nölmɨŋa. Ib naŋ akwör urön, ap nöbö mö ragwo ha yuö wölöŋ piaku yad abmɨŋa. Ib naŋ akwör urön, ap rölɨbä akuyöbö mɨga rɨmɨŋö,’ cöña. ");
INSERT INTO tmd_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nɨ aliö yajöñ aku, jɨ nɨ ñɨgö yajɨna, ‘Nɨ ñɨŋ nugumɨdöi; ñɨŋ mag gwogwo akwör röia, hör pikwo di!’ cɨna. ");
INSERT INTO tmd_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","25","“Nöbö rɨbyöx nugw ri abɨb i ram nuŋwa winöb, rɨg rol sö wiöna. Mai hödal diba hön, ruö diba pɨlön, röbö hadö hön cön aku, jɨ ram nuŋwa rɨg rol sö ur gö nɨgön aku, pal gɨlɨx ab gɨlɨx rɨ pön duen. Makwam mag aliö akuyöbö, nöbö mö mönö na nugwön, nugw pön, rɨg yadmɨdɨl mag akuyöbö rɨmɨjöñ bla. ");
INSERT INTO tmd_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","27","“Makwam nöbö rɨbyöx nugw ri aben i ram nuŋwa winöb, rɨg jɨmi rola wiöna. Mai hödal diba hön, ruö diba pɨlön, röbö hadö hön, ram nuŋ aku aŋadö pal gɨlɨx ab gɨlɨx rɨ pön diöna. Makwam mag aliö akuyöbö, nöbö mö mönö na nugwön rɨg yadmɨdɨl maga reñ akuyöbö,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Jisas mönö aku yad pörmɨn nugugɨrön, nöbö mö mɨg mɨŋa hö mɨdim akuyöbö nugwön yadmä, “God lo mönö yad nölɨb nöbö an bla mönö rɨg yadöi akuyöbö yadölöm; nuŋ mönö rɨbyöx nugw ri abön yadö,” rön aiö waiö rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisas önöŋ ajmag pɨd sö mɨdöŋ aku röböxön, höñ bö pɨn dumɨn nugugɨrön, nöbö mö mɨg mɨŋa nugwo mai pɨ dumä. ");
INSERT INTO tmd_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Makwam nöbö uj höpebö nɨgöŋ i, Jisas mɨdöŋ il yöra duön, höxmax yuön, iröpa ubɨlön yadöŋa, “Nöbö Dib. Naŋ nɨ raŋ wä cɨnöb, raŋ, wä cöna. Nɨ wä cön aku, nɨ God höjöpalɨb ram möl yuadö duba rɨmɨdɨl aku, nɨ wöhö reñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Aliö rɨmɨn, Jisas iŋpɨlö mɨlkap abön nöbö aku pɨ nugwön yadöŋa, “Nɨ rɨmɨdla; nagö kömö nɨgaŋ,” me rɨmɨn, wop mɨd akwör nugwo kömö nɨgmɨn nugugɨrön, ");
INSERT INTO tmd_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jisas nöbö aku nugwo yadöŋa, “Nagö rɨmön kömö nɨg aku, nöbö mö bli yad nölmɨjɨnö, wöhö. Du God ap höjöpal ur nölɨb nöbö bla akwör yabuön yajɨnö, ‘Nɨ kömö nɨga nugwi!’ rö. Aliö rön, Mosɨs rɨg yadöŋ maga, yöur i God nugwo pal höjöpal ur nölö. Alön rɨmɨdaŋ, nöbö mö akuyöbö nugwön yajöña, ‘Nuŋ kömö nɨgö aku döŋö almɨdö,’ cöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisas taun ulmɨdö Kapaneam dumɨn nugugɨrön, ami nöbö mɨga nugwidɨx mɨdmɨd nöbö dib i, Jisas nɨ rɨ nölaŋ, me rön, hön Jisas nugwo yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Nöbö Dib, mabö rɨ nölɨb nöbö na aku nuŋ ap diba rɨmɨn, mɨxɨña ölɨŋ pɨlmɨn, memexöl; rama wöröxmɨdö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Aliö rɨmɨn, Jisas yadöŋa, “Nɨ du nugwo rɨmön kömö nɨgönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Jisas aliö rɨmɨn, ami nöbö dib aku yadöŋa, “Nöbö Dib, nɨ nöbö diba mɨdölöxisöŋö naŋ ram na harax. Nɨ nugula aku, ami nöbö dib bli nɨ nugwidɨx mɨdɨm, nɨ piöŋö ami nöbö bli ñɨgö nugwidɨx mɨdön, ‘Dine,’ rɨmön, duöia; ‘Höne,’ rɨmön, höia. Nöbö na mabö ra aku nugwo, mabö piaku al aliö rö, rɨmön ra. Mag akuyöbö, nagö hör, ‘Kömö nɨgaŋ,’ me raŋ, nugwo kömö nɨgönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Aliö rɨmɨn Jisas aiö rön, nöbö mö mai dumɨdim akuyöbö ñɨgö yadöŋa, “Mögörɨb pad piakuyöbö nöbö kɨ, jɨ nuŋ God rɨ mag akuyöbö nugw ri abön mönö aliö yada. Nöbö an Isrel yöbö i, God nugw pɨ gö nɨgön rɨg yad akuyöbö i yadmɨn, nɨ nugwöi. ");
INSERT INTO tmd_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Makwam, mai nöbö mö pad piaku piaku, God nöbö mö pön adöx yöd röul adö kau sö nugwidɨx mɨjön mibɨl yöra duön, Ebraham, Aisak, Jekop nöbö pɨsaŋ römɨdön, ap mɨga nɨmön, mɨ ödöriö wahax pɨ mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ñɨŋ al gɨrön du mɨjöña, jɨ nöbö mö an Isrel yöbö piaku, du mibɨl yöraku mɨdɨbä maga mɨdöl. God ñɨgö yad abaŋ, du mɨjöñ rɨŋadö pɨxmag gur möl bö. Ñɨŋ im gɨrön möb nɨgön ajmaga öb gɨlɨx ab gɨlɨx rɨ nɨm gɨr mɨjöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Aliö yadön, Jisas ami nöbö dib aku nugwo yadöŋa, “Nagö höuöil duö! Nugw pön rɨg yad nugulö mag akwör cönɨŋö,” röŋa. Jisas aliö rɨmɨn, nuŋ rama duön nugumɨn, nöbö nuŋwa ap röŋ aku, Jisas rɨg yadöŋ mag mɨd akwör kömö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Makwam Jisas Pita rama duön nugumɨn, Pita nɨmemö aku, mɨxɨñ piaku rɨn röxg yönmɨn, äbäñ rola wöröxmɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jisas nugwön, du Pita nɨmemö imaga pɨ nugumɨn, wop mɨd akwör kömö nɨgmɨn, nuŋ öbɨlön, Jisas ap maga pɨdɨlu nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Höxi röŋ mag aku, ragwo kap nöbö mö bla aipam, nöbö mö ap röŋ bla aipam, pön du Jisas mɨdöŋ yöra hömɨdmɨn, nuŋ ragwo ha bla yad abɨm röu dumɨn, nöbö mö ap röŋ bla rɨmɨn kömö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nuŋ alöŋ aku, God mönö yadɨb nöbö Aisaia, maduar rɨg cönɨŋö, rön, kai kɨtöŋ mag akwör röŋa. Nuŋ kai kɨtön yadöŋa, “Anɨŋ ap röŋ akuyöbö rɨmɨn kömö nɨgöŋa. Ap agap apɨm anɨŋ rɨ gwogwam röŋ bla yad abmɨn mɨd ri abölɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisas nugumɨn, nöbö mö mɨga akwör hö nugwo wob yuö nɨgmɨn, nöbö nuŋ bla ñɨgö yadöŋa, “Bana möxön ir kwo duŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Jisas aliö rɨmɨn nugugɨrön, God lo mönö yad nölɨb nöbö i hön nugwo yadöŋa, “Mönö yad nölɨb nöbö. Nagö mögörɨb pikai pikai dinö aku, nɨ nagö pɨsaŋ dinö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Aliö rɨmɨn, Jisas yadöŋa, “Wöñö höpebö bla, ñɨŋ mögö möl bla hölɨmmɨdöia. Yöur bla, yör ñɨŋ hölɨmɨb aku mɨda. Makwam nɨ Nöbö Ha nuŋwa hölɨmɨb möla mɨdölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Makwam Jisas nugw pöŋ nöbö i yadöŋa, “Nöbö Dib, nɨ nagö pɨsaŋ dinam jɨ nɨ yöwö ran, acö wöröxaŋ hogw pɨlön, nagö pɨsaŋ yönmɨjnɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Aliö rɨmɨn, Jisas yadöŋa, “Nöbö mö nɨ nugw pölöi bli wöröxöñ aku, nöbö mö nɨ nugw pölöi bli pön du hogw piöña; jɨ nagö han nɨ pɨsaŋ duŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisas röbö alebö pön duba rɨmɨn, nöbö nuŋ bla pɨsaŋ dumä. ");
INSERT INTO tmd_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ban yuö mibɨl kwo dumɨdmɨn nugugɨrön, rɨb pia hödal diba ödöriö höm, röbö wöd hön, röbö alebö aku pɨ höuöilbä maga röŋa. Makwam Jisas nuŋ inɨmö höl gɨ mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nöbö nuŋ bla nugwo du röböum öbɨlmɨn yadmä, “Nöbö Dib! Hödal diba höm anɨŋ pɨ höuöilbä rɨmɨn, röbö nɨmɨbä maga rɨ aku, naŋ anɨŋ kömö pö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Aliö rɨmɨdmɨn, Jisas ñɨgö yadöŋa, “Pödpöd rɨmɨn ipöxmɨdöi? Ñɨŋ mönö na ulul bli nugw pölöiŋönö ä?” röŋa. Aliö rön, öbɨlön yadmɨn, hödala hömɨdöŋ aku ödör pɨmɨn, röbö wöd hömɨdöŋ aku aipam aŋöi nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Almɨn, ñɨŋ aiö waiö rön yadmä, “Nöbö ölɨsö kɨ nöbö pödiöm yadɨm nugwön hödal diba hömɨd aku ödör pɨmɨn, röbö wöd hömɨd aku höx rödɨm du aŋöi nɨg owa?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisas röbö möxön, mögörɨb Gadara ir kwo uröpɨnɨm nugwön, ragwo kap nöbö hogwa nöbäpö hogw pɨlmɨdöi rɨg möl piakuyöbö höröpɨnmä. Ragwo ha mɨdöŋ nöbö hogwa aku, nöbö höpebö ödöriö hogwa mɨdmä. Ñɨŋ mɨdmɨdöi yöra nöbö mö bli dumɨdölöi. ");
INSERT INTO tmd_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Makwam ñɨŋ nöbö hogwa hö gɨrön, Jisas nugwo yadmä, “God Ha nuŋwa. Pödpöd rɨba hömɨdlö? Anɨŋ ölɨŋ höb diba pɨ nölɨba hömɨdlanö owa agapɨm? Wop naŋa anɨŋ mögörɨb gwogwo yad abɨb wop aku hölö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Makwam wop mɨd akwör, hön mɨga amñö nɨmmɨdim igöp il yöraku, ");
INSERT INTO tmd_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ragwo ha bla nöbö hogwa wöl gɨ mɨdim piaku, Jisas nugwo yad gögö rön yadmä, “Anɨŋ yad abnöb cɨnö aku, yadaŋ duön hön mɨdöi pi kwo yuö wölɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Aliö rɨmɨn, Jisas “Dine,” rɨmɨn, nöbö hogw aku röböxön, du hön bla yuö wölumä. Yuö wölumɨn hön bla bɨrɨg ipalɨp rɨgaj gwogwo rɨp duön, röbö yuö bö pɨnön, röbö nɨmön, magalɨg wöröx pörmä. ");
INSERT INTO tmd_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Makwam nöbö hön urmɨdöi bla, rɨg röŋ aku nugwön, rɨmgör taun aku duön, Jisas agap ap bɨlɨm röŋ aku, ragwo kap nöbö hogwa agap ap bɨlɨm röŋ mönö aku, nöbö mö piaku magalɨg yad nölmä. ");
INSERT INTO tmd_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yad nölmɨdmɨn, nöbö mö tauna mɨdim piaku magalɨg Jisas nugwo nuguŋö rön, hö nugwo nugwön, yad gögö rön yadmä, “Mögörɨb an kɨ röböxön hör piaku duö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisas iswob röbö alebö pön, bana möxön, mögörɨb nuŋ hölɨmmɨd ir kwo wöluöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Jɨ nöbö mö bli, nöbö iŋ wajmag lɨd pɨlöŋ i, Jisas raŋ kömö nɨgaŋ, me rön, nugwo rɨp nɨg rag hö Jisas mɨdöŋ yöra pön hömä. Makwam, Jisas raŋ kömö nɨgönɨŋö, rön nugwim mag akwör, Jisas iŋ wajmag lɨd pɨlöŋ nöbö aku nugwo yadöŋa, “Ha mɨg! Rɨbyöx gɨba alɨg mɨdö. Ap kib mag gwogwo rɨlö bla nugwön röböxmɨdlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jisas aliö rɨmɨn, God lo mönö yad nölɨb nöbö bla bli yadmä, “Nöbö kɨ God yad höimöuön yadmɨdö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Makwam Jisas nuŋ ñɨŋ rɨbyöx nugwim aku nuŋ keir nugwön yadöŋa, “Ñɨŋ pödpöd rɨmɨn nɨ rɨb gwogwo yöxön aliö yadmɨdöi? ");
INSERT INTO tmd_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nɨ nugwo, ‘Ap kib mag gwogwo rɨlö aku nugwön röböxmɨdlö,’ rɨmön, ñɨgö wä cönɨŋönö ö ‘Öbɨl duö!’ rɨmön, ñɨgö wä cön? Mönö kai yadmön ñɨgö wä cön? ");
INSERT INTO tmd_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Weik ñɨŋ nugwöña, Acö God nɨ Nöbö Ha nuŋwa yad nɨgöŋa nugwön, mögörɨb il kɨ hön, ap kib mag gwogwo röi aku nugwön röböxnö,” röŋa. Jisas aliö rön, nöbö iŋ wajmag lɨd pɨlöŋ aku nugwo yadöŋa, “Öbɨlön, köp naŋ aku röd ragön, ram nagö duö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jisas aliö rɨmɨn, nöbö aku öbɨlön köp nuŋ pɨda aku röd ragön ram nuŋwa duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ram nuŋwa dumɨn nugugɨrön, nöbö mö bla nugwön, God yadɨm Jisas hön rɨmɨda, rön, ipöx gɨrön, nöbö i mögörɨb il kɨ mag akuyöbö aliö almɨn nugwölölɨŋö, rön, God iba yadmɨn bɨl sö duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas mögörɨb aku röböxön, möl i duön nugwöŋa, takis pɨb mabö rɨmɨd nöbö i ram möla yuadö römɨd gɨ mɨdöŋa. Nöbö aku ib nuŋwa Matiu. Jisas nugwo nugwön yadöŋa, “Nɨ pɨsaŋ hane!” röŋa. Aliö rɨmɨn, Matiu öbɨlön Jisas pɨsaŋ duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jisas nöbö nuŋ bla pɨsaŋ Matiu rama duön, ap nɨmmɨdɨm nugugɨrön, takis pɨb nöbö bla aipam, nöbö ap kib mag gwogwo rɨmɨdöi nöbö bla aipam, mɨg mɨŋa hön Jisas nöbö nuŋ bla pɨsaŋ ap nɨmɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ap nɨmmɨdɨm, Perisi nöbö bla nugwön, Jisas nöbö nuŋ bla ñɨgö yadmä, “Mönö yad nölɨb nöbö ñɨŋ aku, nuŋ pödpöd rɨmɨn, takis pɨb nöbö bla aipam, nöbö mö ap kib mag gwogwo röi bla aipam, pɨsaŋ paŋör ap nɨmmɨdönö owa?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Aliö rɨmɨdmɨn, Jisas mönö aku audiöx nugwön yadöŋa, “Nöbö mö ap röl bla, uj wobɨb nöbö bla duölöi; nöbö mö ap rɨ bla akwör uj wobɨb nöbö bla duöia. ");
INSERT INTO tmd_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Makwam God mönö i yadöŋ il aku nugw ri abön mɨjöña. Nuŋ yadöŋa, ‘Nɨ ap höjöpal ur nöiöñ aku, nɨ wä ren; jɨ nöbö mö piaku ñɨgö uliöxön ösös rɨ ri abön rɨmɨjöñ aku, nɨ wä cönɨŋö,’ röŋa. Makwam nɨ höl aku, nöbö mö, an nöbö mö wä, mɨd ri abölɨŋö rön rɨbyöx nugwöi bla, ñɨgö hölu nugw pɨba höi; nɨ nöbö mö, an ap kib mag gwogwo rölɨŋö rön rɨbyöx nugwöi bla akwör hölu nugw pɨnö rön hölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Wop i, röbö pal nölɨb nöbö Jon nöbö nuŋ bla, Jisas mɨdöŋ yöra hön yadmä, “An aipam, Perisi nöbö bla aipam, wop bli, God nugwör rɨbyöx nugunɨŋö, rön, ap nɨmölöl. Makwam nöbö nagö bla pödpöd rɨmɨn paŋ mag akwör rölöiŋö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Aliö rɨmɨdmɨn, Jisas ñɨgö yadöŋa, “Nöbö mö bla, nöbö mö pɨba rɨmɨd nöbö aku pɨsaŋ mɨjöñ wop aku, mɨ ödöriö wahax pɨ gɨrön ap nɨmöña; makwam nöbö bli hön nöbö aku nugwo pön, pön diöñ wop aku, lɨb pɨlaŋ ap mödön nɨmeñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Makwam Jisas nuŋ ñɨgö mönö i höd röxön yadöŋa, “Wölɨj yoŋyöbö i pön, wölɨj hödyöbö lɨduön ödöcön möla aku lɨdɨxeñ. Makwam pödpöd raŋ lɨdɨxeñ? Almɨjöñ aku, wölɨja lɨdu lɨl rɨ pɨnlö riaŋ, waglöxön möl diba röjöna. ");
INSERT INTO tmd_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Makwam röbö wain aku, aku kwo algör. Wain yoŋyöbö aku rön, pɨ hön meme uñ wödö möla aku un nɨgeñ. Aku agapɨm: aliö almɨjöñ aku, röbö wain kömö aku wölön, pɨnpɨn yadön, hön meme uñ aku paxdörön, hör diöna. Makwam, röbö wain kömö aku pön, hön meme uñ kömö möla pɨ un nɨg gɨŋ algör mɨ wä cönɨŋönö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas mönö aku yadmɨn nugugɨrön, Juda nöbö dib i Jisas mɨdöŋ yöra hön, höxmax yuön yadöŋa, “Halöu na mɨ aŋadö wöröx makwam nagö du nugwo pɨ nugwaŋ, öbɨlaŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Aliö rɨmɨn, Jisas nöbö nuŋ bla pɨsaŋ öbɨlön, nöbö aku pɨsaŋ dumä. ");
INSERT INTO tmd_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Makwam mö i, haña pɨn gör mɨdmɨn, kɨm akuyöbö möl sö yönöŋa. Akuyöbö almɨn, rɨb nuŋwa akwör yöx nugwön, “Jisas wölɨj nuŋ mɨxɨl diba rɨb piakwör pɨ nugumön, nɨ wä cönɨŋö,” rön, Jisas dumɨn nugugɨrön, höglöm adö duön, wölɨj nuŋwa pɨ nugwöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Pɨ nugumɨn, Jisas höuöiliö mö aku nugwön yadöŋa, “Nɨ nugw pɨlö makwam, nagö wä ra. Rɨbyöx gɨba alɨg mɨdane,” röŋa. Aliö rɨmɨn, ap nugwo rɨmɨd aku wop mɨd akwör wä rɨmɨn, haña pɨnmɨdöŋ aku gö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Makwam Jisas nöbö mö piaku röböxön dumɨd dumɨd, nöbö diba ram aku uröpɨnön nugumɨn, namag pɨr gɨrön, mönö diba nɨgmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jisas nugwön ñɨgö yadöŋa, “Ñɨŋ hör pikwo di! Halöu kɨ wöröxöl; hör inɨmö hölɨmmɨdö,” röŋa. Aliö rɨmɨn, nugwo yad imöumä. ");
INSERT INTO tmd_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Makwam Jisas nöbö mö piaku ñɨgö yad rɨŋö bö abön, ram möl yuadö duön, halöu wöröxöŋ aku nugwo iŋpɨlö pɨ nugumɨn, öbɨlöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Akuyöbö almɨn, mönö aku piöx rag mögörɨb piaku magalɨg dumä. ");
INSERT INTO tmd_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Makwam Jisas mögörɨb aku röböxön dumɨn nugugɨrön, nöbö mämäg we wölöŋ hogwa nugwo mai rɨ gɨrön ajmöla aj halön yadmä, “Depid Ha nuŋwa! An nöbö hogwa uliöxane!” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Aliö rɨmɨdmä jɨ Jisas nuŋ ram möl yuadö duöŋa. Nöbö hogwa aku mai hön ram aku höröpɨnmɨn, Jisas nöbö hogwa yadöŋa, “Ñɨŋ nöbö hogwa, nɨ ñɨgö rɨmön kömö nɨgönɨŋö, rön, nɨ hö yadmɨdöia? Nɨ yöwö cɨna, ñɨŋ rɨbyöx nugwöia mämäg ñɨŋa ix nugwöñɨŋönö wöhö?” röŋa. Aliö rɨmɨn, yadmä, “Yöwö. Nöbö Dib, anɨŋ aliö rɨbyöx nugwölɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Aliö rɨmɨn, Jisas mämäg ñɨgö hogwa pɨ nugwön yadöŋa, “Nɨ nugw pöi makwam, rɨg yadöi mag akwör cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jisas aliö rɨmɨn, mämäg ñɨgö hogwa wä rɨmɨn, ix nugum nugugɨrön, Jisas ñɨgö nöbö hogwa mönö ölɨsö yadön yad ri abön yadöŋa, “Nöbö mö piaku, Jisas rɨmɨn anɨŋ wä rö, rön, yad nölmɨjeñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Jisas aliö röŋ aku, jɨ ñɨŋ nöbö hogwa duön, nöbö mö mögörɨb mibɨl piaku magalɨg yad nölmɨn duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Makwam ñɨŋ nöbö hogwa dum nugugɨrön, nöbö mö bli, ragwo kap nöbö albeña höbkalöŋ nöbö i pön Jisas mɨdöŋ yöra pön hömä. ");
INSERT INTO tmd_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jisas ragwo kap nöbö aku ragwo ha bla yad abmɨn, mönö wä pöŋa. Almɨn, nöbö mö akuyöbö aiö rön yadmä, “Mögörɨb Isrel kɨ, nöbö i mag akuyöbö almɨn nugwölölɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Makwam Perisi nöbö bla yadmä, “Nuŋ ragwo ha bla nuö ñɨŋa ölɨsö pön mɨ, ragwo ha bla yad abɨm röu duöiŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Makwam Jisas nuŋ taun ulmɨdö bla aipam, taun dib bla aipam rɨp yön gɨrön, Juda mögum rɨb ram bla duön, Kiŋ diba nöbö mö pön nugwidɨx mɨdɨb mönö wä aku yad nölöŋa. Jɨ nöbö mö akuyöbö ñɨgö ap agap apɨm röŋ aku, aku kwo algör rɨm kömö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jisas nugwöŋa, nöbö mö piaku hön sipsip bla nugwidɨx mɨdɨb nöbö i mɨdöl akuyöbö alɨg mɨdmä. Rɨb diba yöxön amɨn mɨdmä, jɨ ñɨgö rɨ nölɨb nöbö i mɨdölöŋ. Makwam Jisas nugwön mɨ ödöriö ögwö yöxön, ");
INSERT INTO tmd_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","nöbö nuŋ bla ñɨgö yadöŋa, “Möriwö ap mag mɨga u gɨ mɨda, jɨ pɨliöx rag höb nöbö mö mɨga mɨdölöi. ");
INSERT INTO tmd_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Makwam, ñɨŋ nöbö möriwö mɨnöbö aku nugwo yad nugwɨŋ, pɨliöx rag höb nöbö mö bli kwo agal abaŋ, pɨliöx rag nugwo ada höŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas nöbö nuŋwa akuyöbö möl sö wö rɨm hömɨdmɨn yadöŋa, “Nɨ keir ñɨgö ab yadmɨdɨl aku mɨ, ragwo ha bla yad abnöb, yad aböña. Nöbö mö ap agap apɨm cön blaku algör ör rɨŋ, kömö nɨgönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jisas nuŋ mönö pön dub akuyöbö möl sö yad aböŋ nöbö bla, ib ñɨŋ bla maku, nöbö i Saimon, ib nuŋwa i Pita rɨmɨdöia; nöbö i Edru, Pita hödnɨŋ nuŋ aku; nöbö i Jems, Sebedi ha nuŋwa; nöbö i Jon, Jems pɨgnɨŋ nuŋ aku; ");
INSERT INTO tmd_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","nöbö i Pilip; i Batolomiu; i Tomas; i Matiu, nuŋ takis pɨmɨda; nöbö i Jems, Alpias ha nuŋwa; nöbö i Tadias; ");
INSERT INTO tmd_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","nöbö i Saimon, ib nuŋwa i Selot rɨmɨdöia; nöbö i Judas Iskariot, nuŋ mai Jisas höuöu röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas nöbö nuŋ piaku ñɨgö mönö wä mabö aku rɨŋ, me rön, yad hörɨrör ab gɨr yadöŋa, “Ñɨŋ Juda nöbö mö yöi mibɨl bla aipam, Sameria ada mɨdöi mibɨl bla aipam, dumɨjeñ. ");
INSERT INTO tmd_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Jɨ ñɨŋ du nöbö mö an Isrel, nöbö mö ñɨŋ God nugwo rɨbyöx nugwölöi bla, ñɨŋ yad nöl gɨrön yajöña, ");
INSERT INTO tmd_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","“God nöbö mö pön nugwidɨx mɨdɨb wop aku mödö igöp hö,” cöña. ");
INSERT INTO tmd_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ñɨŋ nöbö mö ap cön bla rɨŋ, kömö nɨgöna. Ñɨŋ nöbö mö aŋadö wöröxöñ bla rɨŋ, höuöil öbiöña. Ñɨŋ nöbö mö uj höpebö nɨgön bla rɨŋ, wä cöna. Ragwo kap nöbö mö ragwo ha bla yad abɨŋ, röu diöña. Acö an nuarö ñɨgö hör mabö rɨ nölöl mag akuyöbö, ñɨŋ kwo algör ör nöbö mö piaku hör mabö rɨ nöiöña. ");
INSERT INTO tmd_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Rɨg mag gol, rɨg mag silpa, rɨg mag paskwolö bli pɨrag dumɨjeñ. ");
INSERT INTO tmd_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yogw, wölɨj, yam uñ, sauö, ap akuyöbö alɨg rag dumɨjeñ. Aku agapɨm: nöbö mö mabö rɨ nöiöñ bla, ñɨŋ ñɨgö ap mag rɨŋ nɨmöña. ");
INSERT INTO tmd_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Makwam taun i mönö ram yöj lɨglɨg agrö i uröpɨnɨŋ, nöbö mö ñɨgö yad wahax pöñ akuyöbö nugwön, ñɨŋ pɨsaŋ ör mɨdön, mögörɨb hör piaku dinöb cöñ wop akwör, ñɨŋ röböxön diöña. ");
INSERT INTO tmd_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","14","Makwam ram i du gɨrön, “Ñɨŋ mɨdöiŋ ä!” rɨŋ, “Yöwö, mɨdöla; wä höiŋö,” rɨmɨdɨŋ, ram aku yuadö diöña. Makwam ñɨgö mönö na yad nölɨŋ, wahax pön nugweñ aku, röböx dinöb, bɨcep cep yamsö ñɨŋ bö cɨrɨp gɨ mɨjön aku, pɨ lɨl rɨ abön diöña. ");
INSERT INTO tmd_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nɨ ñɨgö mɨ ödöriö yadmɨdla: mönö diba yadɨb wop aku, Sodom Gomora nöbö mö ölɨŋ höb ulul pöña; nöbö mö ñɨgö peñ piaku, mɨ ödöriö ölɨŋ höb diba pöña. ");
INSERT INTO tmd_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Makwam nugwi! Nɨ ñɨgö hön sipsip röxgɨb nöbö mö wöñö höpebö röxg mɨdöi mibɨl akuyöbö agal abmɨdla. Makwam, rɨbyöx nugw ri ab gɨrön, tar ñɨŋ yad nöl gɨr mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Aku nöbö mö bli ñɨgö pɨ cɨcɨ nɨgön, pön Juda mögum rɨb ram akuyöbö duŋ, kansol ñɨŋ bla hö mönö diba yadön, ñɨgö paiöña. Makwam, nugw ri aböña. ");
INSERT INTO tmd_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ñɨgö nöbö nɨ, me rön, pɨxɨp pön gapman nöbö dib mönö kiŋ mɨjöñ yöra pön duŋ, ñɨŋ mönö wä nɨ aku, nöbö dib bla aipam, Juda nöbö mö yöi mögörɨb dib pad piakuyöbö aipam, ñɨgö yad nöiöña. ");
INSERT INTO tmd_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Ñɨgö mönö diba yajöñ aku, mönö kai yajnɨŋ owa mönö pödpödiö yajnɨŋö, rön, ipöx gɨrön, rɨb mɨga yöxmɨjeñ. Ñɨŋ yadɨŋ nugugɨrön, God Nuö ñɨŋa Inöm nuŋwa ñɨŋ pɨsaŋ mɨd aku, rɨb wä nölaŋ, rɨb ñɨŋ hör i yöx nugwön yadeñ; God Nuö ñɨŋa Inöm nuŋwa ñɨgö rɨg yajön akwör yajöña. ");
INSERT INTO tmd_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Wop aku, nöbö höd bla öbɨlön, pɨgnɨŋ nöbö ñɨŋ bla, pɨl pal nɨgɨŋ, me rön, nöbö dib bla höuöu cöña. Nuö bla öbɨlön, halöu ha ñɨŋ bla pɨl pal nɨgɨŋ, me rön, nöbö dib bla höuöu cöña. Halöu ha bla öbɨlön, nuö nuöm ñɨŋ bla höglöm nölön al gɨr mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nɨ adö mɨjöñ aku, nöbö mö akuyöbö magalɨg ñɨŋ nugwɨŋ, ölɨsö diba wöiöna. Makwam nöbö mö yön ususör rön, nɨ pɨsaŋ mɨjöñ bla, wop maiyöbö aku haŋ, God ñɨgö pöna. ");
INSERT INTO tmd_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Makwam möl i duŋ, ñɨgö rɨ gwogwam rɨmɨjöñ aku, bör möl i diöña. Nɨ ñɨgö mi yadmɨdla, Isrel taun piaku nöbö mö piaku ñɨgö yad nölɨp duölɨbör mɨdɨŋ, nɨ Nöbö Ha nuŋwa höna. ");
INSERT INTO tmd_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","“Halöu ha skul pɨmɨdöi bla diba mɨdɨm, yad nölɨb nöbö ñɨŋ bla ulmɨdö mɨdölöi. Makwam yad nölɨb nöbö rɨg mɨdöi mag akwör mɨjnɨŋö, rön, skul pöia. Nöbö mö mabö rɨ nölöi bla diba mɨdɨm, nöbö mö ñɨgö nugwidɨx mɨdöi akuyöbö mo mɨdölöi. Mabö röi aku, nöbö mö diba rɨg mɨdöi mag akwör mɨjnɨŋö, rön, mabö röia. Mag akuyöbö, nöbö mö nɨ bla, nɨ rɨg mɨdöi mag akuyöbö mɨjnɨŋö, rön, röia. Makwam nöbö mö bla nɨ yad höimöuön, nɨ Bielsebul me röi mag akuyöbö, ñɨgö mabö rɨ nölɨb nöbö nɨ akuyöbö algör yad höimöuön mönö gwogwo yajöña mɨ. ");
INSERT INTO tmd_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ñɨŋ nöbö mö bla nugwön ipöxmɨjeñ. Mönö kai wopik pöröb gɨ mɨd aku, mai wöxnö nɨgöna. Ap kai tar röi bla, mai wöxnö nugwöña. ");
INSERT INTO tmd_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mönö na ñɨgö umadiö yajɨn aku, ñɨŋ du nöbö mö piaku wöxnö yad nöiöña. Mönö na ñɨgö rɨmɨj möl piaku yajɨn aku, ram cölöbö sö wöluön, mönö diba yad nölɨŋ nugwöña. ");
INSERT INTO tmd_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Ñɨŋ nöbö mö pɨl pal nɨgöi nöbö bla nugwön ipöxmɨjeñ. Ñɨŋ hör uñ wab akwör pɨl pal nɨgöña; inöm aku alɨg pal nɨgɨb maga mɨdöl. Ipöxnöb cöñ aku, Nöbö Dib nöbö mö mɨxɨñ aipam inöm aipam rɨn nöi yönmɨd möl bö abɨb nöbö akwör ipöxöña. ");
INSERT INTO tmd_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Yöur ulul bla hör ap. Rɨg paskwolö mag paŋyöbö i abön mös pöia. Hör ap aku, jɨ Nuö ñɨŋa ñɨgö nugugu mɨd aku, i hör pɨn bɨrenɨm. ");
INSERT INTO tmd_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Yöj panö ñɨgö aku, God magalɨg iŋ wöda. ");
INSERT INTO tmd_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Makwam ipöxmɨjeñ. Yöur bla mɨ ap ulmɨdö bɨlɨm; ñɨŋ ap yöbö mɨdöia. ");
INSERT INTO tmd_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Nöbö mö yönɨm nɨ adö mɨdön, nöbö mö piaku ñɨgö wöxnö yad nöiöñ akuyöbö, nɨ paiŋö Acö na adöx yöd röul adö kau sö mɨd aku nugwo, nɨ adö mɨdöiŋö, rön, wöxnö yajɨna. ");
INSERT INTO tmd_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Makwam nöbö mö kai, nɨ cɨrɨp ri abölön, nöbö mö pɨsaŋ mɨjöñ mibɨl yöraku yajöña, nöbö aku nɨ nugumɨdöiö, rɨmɨjöñ akuyöbö, nɨ paiŋö Acö na adöx yöd röul adö kau sö mɨd aku nugwo, nöbö mö kɨyöbö nɨ nugumɨdöiö, cɨna. ");
INSERT INTO tmd_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Nɨ mögörɨb il kɨ höl aku, ‘Jisas nuŋ mögörɨb il kɨ hö aku, tar mɨd ri abönɨŋö,’ rön, rɨb aku yöxmɨjeñ. Nɨ höl aku mɨ, nöbö mö akuyöbö mönö diba yadön nuö piöña. ");
INSERT INTO tmd_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Akuyöbö aiöna: ha bla öbɨlön, nuö nöbö pɨsaŋ nuö piöña. Halöu bla öbɨlön, nuöm nöbö pɨsaŋ nuö piöña. Ha ñɨŋ bla mönɨŋ nöbö öbɨlön, apɨnɨŋ nöbö pɨsaŋ nuö piöña. ");
INSERT INTO tmd_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Akuyöbö almɨjöñ aku, ram ñɨŋa paŋyöbö akwör mɨdöi bla, ñɨŋ keir nuö nuö pɨmɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Nöbö mö bɨl kai, nuö nuöm mönö halöu ha bla akwör madmag nɨgön, nɨ madmag nɨgeñ aku, nöbö mö na mɨdɨb maga mɨden. ");
INSERT INTO tmd_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nöbö mö bɨl kai bɨ katlö watlö wab ñɨŋa pɨrag pɨd nɨg ragön nɨ mai heñ aku, nöbö mö na mɨdɨb maga mɨden. ");
INSERT INTO tmd_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nöbö mö bɨl kai, nɨ keir mɨdön mɨd ri abnö, cöñ aku, rɨn hör yönmɨd möl bö diöña. Nöbö mö bɨl kai piöŋö yajöña, nɨ Jisas adö mɨdmön, nɨ pɨl pal nɨgnöb pɨl pal nɨgɨŋ, me cöñ aku, kömö öim öim mɨdɨb maga pöña. ");
INSERT INTO tmd_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ñɨŋ duŋ, nöbö mö bli ñɨgö yad wahax pöñ aku, nɨ aipam yad wahax pöña. Makwam nɨ yad wahax pöñ aku, Nöbö nɨ yad abmɨn höm aku nugwo aipam yad wahax pöña. ");
INSERT INTO tmd_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nöbö kai, God mönö yadɨb nöbö i nugwön yajöna, ‘Hö nöbö mɨdö kɨ, God mabö ra aku mɨ nugwo pɨnö,’ rön, pön aku, mag wä cöna. God mönö yadɨb nöbö aku pɨ ösös rɨ ri abön aku, mai God nuŋ nugwo algör ör pɨ ösös rɨ ri aböna. Nöbö kai, God nöbö mö waiö nuŋwa i nugwön yajöna, ‘Hö nöbö mɨdö kɨ, God nöbö waiö nuŋwa mɨ nugwo pɨnö,’ rön, pön aku, mag wä cöna. God nöbö mö waiö nuŋwa pɨ ösös rɨ ri abön aku, mai God nuŋ nugwo paŋ mag akwör cöna. ");
INSERT INTO tmd_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Makwam nöbö kai, nöbö hör nɨ i nugwön, Jisas nöbö nuŋ aku, me rön, röbö un rag hö nöiön aku, God nugwaŋ, wä raŋ, paiŋö uplöbenɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisas nöbö nuŋwa akuyöbö möl sö piaku ñɨgö al aliö rɨmɨdɨŋ, me rön, yad nöl ri abön, mögörɨb aku röböxön, taun hör il mebla aku duön, nöbö mö akuyöbö ñɨgö mönö yad nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Makwam röbö pal nölɨb nöbö Jon naga mɨdön, Krais agö magɨm röŋ mönö aku nugwön, nöbö nuŋ bli yad abmɨn, Krais mɨdöŋ yöra uröpɨnön, ");
INSERT INTO tmd_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","nugwo yad nugwön yadmä, “Anɨŋ yad nölö, naŋ nöbö ‘Krais’ me rön, öim pöx mɨdmɨdöl akwör hölanö owa an nöbö hör i keir pöx mɨjnɨŋö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Aliö rɨmɨn, Jisas ñɨgö yadöŋa, “Ñɨŋ Jon mɨd yöra duön yajöña, ‘An duön mämäg ana keir nugwön, an keir rɨmɨj palön yöxöla, ");
INSERT INTO tmd_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","nöbö aku nöbö mö mämäg we wöl bla rɨmɨn, mämäga ix nugwöia. Nöbö mö yödpɨlö gwogwo rɨ bla rɨmɨn, ödöia yön ri aböia. Nöbö mö uj höpebö nɨg bla rɨmɨn, wä ra. Nöbö mö rɨmɨj möl idɨxön rɨ bla rɨmɨn, rɨmɨj möla börmɨn mönö yöxöia. Nöbö mö wöröxöi bla rɨmɨn, höbkal öbɨlöia. Nöbö mö lɨblɨb mɨdö bla algör Krais mönö waiö aku yadmɨn nugwöiŋö,’ cöña. ");
INSERT INTO tmd_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Makwam mönö i yajöña, ‘Nöbö mö nɨ nugw pön, rɨb i rɨb i yöx nugweñ bla, mɨ ödöriö wahax pɨmɨjɨnö,’ rɨ gö,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Aliö rɨmɨn, Jon nöbö nuŋ bla dumɨn nugugɨrön, Jisas nöbö mö hö mɨdim akuyöbö ñɨgö Jon mönö mag aku yadön yadöŋa, “Ñɨŋ höd mögörɨb rɨg kap mibɨl piaku duim wop aku, agapɨm nuguba duim? Mugumö yöd paŋyöbö i hödal öñöña pɨ pikwo pik rɨ i nuguba duim? ");
INSERT INTO tmd_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Owa agapɨm nuguba duim? Nöbö wölɨj wä wä akwör yömöi nöbö i nuguba duim? Nöbö wölɨj wä wä pɨnɨŋö, rön nugwöi bla, nöbö dib ram kɨtɨb wä akuyöbö hölɨmmɨdöia. Ñɨŋ Jon mɨdmɨd mögörɨb ör mibɨl yöra hölɨmmɨdölöi. ");
INSERT INTO tmd_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Makwam ap agapɨm nuguba duim? Hör duölim. God mönö yadɨb nöbö Jon nuguba dumä. Nöbö God mönö yadɨba hönɨŋö, rön, pöx mɨdmɨdöi nöbö aku maku pal. Makwam Jon nuŋ God mönö yadɨb nöbö akwör yöi. ");
INSERT INTO tmd_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jon nugwo rɨbyöx nugwön, maduar ör God nuŋ Ha nuŋwa nugwo mönö yadöŋ mönö aku, God Mönö mag bö kai kɨtön yadmä, ‘Mönö yadɨb nöbö na aku, yad abmön höd duön, nöbö mö piaku yad nöl ri abaŋ, mai naŋ keir dinaŋö,’ rön kai kɨtmä. ");
INSERT INTO tmd_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ñɨgö yadmɨdla, nöbö mö mögörɨb mɨgrö kɨ mɨdöi bla i Jon röxg mɨdölöi. Makwam God nöbö mö hör pön du adöx yöd röul adö kau sö nugwidɨx mɨjön akuyöbö, ñɨŋ Jon röxgɨba mɨdeñɨm; God nuŋ nöbö mö hör ödöriö bla pɨ ri abön raŋ, nöbö mö wä nuŋwa mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Röbö pal nölɨb nöbö Jon hön mönö wä yad nölöŋ wop aku ila nɨgön, nöbö mö piaku, God anɨŋ pön du adöx yöd röul adö kau sö nugwidɨx mɨjönɨŋö, rön, mönö aku mɨ ususör rɨp duön duön, weik kwo algör mɨ ususör rɨmɨdöia. ");
INSERT INTO tmd_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","“God mönö yadɨb nöbö kai kɨtim mönö aku aipam, Mosɨs God lo mönö kai kɨtöŋ aku aipam, ila makwam, God Mesaia nugwo yad abmɨn, nuŋ nöbö mö piaku ñɨgö pön nugwidɨx mɨjöna. Mönö aku algör yadɨp hön hön rɨba Jon höŋa. ");
INSERT INTO tmd_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Makwam mönö yadɨba rɨmɨdɨl kɨ pöñɨŋönö wöhö nɨ nugwöi. God Jon nugwo yadmɨn, hön nöbö mö piaku ñɨgö mönö yad nölöŋ aku, God Mönö kai kɨtön, rɨg cönɨŋö, rim mag akwör röŋa. Kai kɨtön yadmä, God mönö yadɨb nöbö Ilaija röxgɨb nöbö i hönɨŋö, rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ñɨŋ nöbö mö rɨmɨj möla mɨjön bla, mönö yadmɨdɨl kɨ rɨmɨj pal nugw ri aböña. ");
INSERT INTO tmd_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Nöbö mö wopik wop kɨ mɨdöi bla nɨ nugula, ñɨŋ halöu ha kiai bli ap sɨmaim röi yöra römɨdön, halöu ha kiai bli ajmöla aj halön ñɨgö yadöi mag akuyöbö röxg mɨdöia. ");
INSERT INTO tmd_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ñɨŋ yadöia, ‘An namö pɨrmɨn, ñɨŋ pödpöd rɨmɨn höx wödölöi? An wopal imbä akuyöbö yadmɨn, ñɨŋ pödpöd rɨmɨn imölöiŋö?’ rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Mag akuyöbö, God Jon nugwo agal abmɨn hön, wop bli ap maga nɨmölön, röbö wain nɨmölön rɨm, yadöia, ‘Nöbö kɨ nuŋ agapɨm yöj nɨgɨm akuyöbö al?’ röia. ");
INSERT INTO tmd_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Makwam Nöbö Ha aku höm yadöia, ‘Nöbö ap diba nɨmön, röbö wain nɨmön, nöbö takis pöi bla pɨsaŋ yönön, nöbö mö ap kib mag gwogwo röi bla pɨsaŋ yönön rö,’ röia. Makwam nöbö mö God Mönö aku nugw pön, ösös rɨ ri abön, wä mɨd ri abön rɨmɨjöñ aku, nöbö mö piaku nugwön yajöña, ‘God Mönö aku mönö mag wä mɨdö,’ me cöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","21","Jisas taun diba höd rɨ yönön, ap rölɨbä mag cɨmala mɨga akwör rɨmɨn, nöbö mö akuyöbö nugumä aku, jɨ ñɨŋ pödpöd rɨmɨn ap kib mag gwogwo rölɨŋö, rön, ap kib mag gwogwo rɨmɨdöi mag aku röböxön, Jisas nugw pölim. Akuyöbö almɨdmɨn, Jisas ñɨgö yadyöxön yadöŋa, “Korasin taun nöbö mö bla! Betsaida taun nöbö mö bla! Ap rölɨbä mag cɨmal bla rɨmön nugumä. Makwam ap kib mag gwogwo röi aku röböxön nɨ nugw pölöi. Akuyöbö alöi aku, ñɨŋ mönö diba ödöriö yöxöña. Taun dib Taia Juda nöbö mö yöi piaku, taun dib Saidon Juda nöbö mö yöi piaku, ap rölɨbä piaku ñɨgö algör ör rɨmɨdlöx aku, ñɨŋ ap kib mag gwogwo rɨmɨdöi bla röböxön, yogw lɨdu gɨb bli yömön, rɨn haui nɨg gɨr mɨdöyɨxa. ");
INSERT INTO tmd_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Makwam, mönö diba yadɨb wop aku, Taia nöbö mö aipam, Saidon nöbö mö aipam, mönö ulmɨdö mɨŋi yöxöña; makwam ñɨŋ Korasin nöbö mö aipam, Betsaida nöbö mö aipam, mönö diba yöxöña. ");
INSERT INTO tmd_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Kapaneam nöbö mö bla, wop aku ñɨŋ adöx yöd röul adö kau sö dueñ; mɨ aŋadö rɨn hör yönmɨd möl bö diöña. Ap rölɨbä mibɨl ñɨŋ yörɨk rɨm aku, taun dib Sodom rɨmɨdlöx aku, ñɨŋ ap kib mag gwogwo rɨmɨdöi akuyöbö röböxön, wopik kömö mɨdöyɨxa. ");
INSERT INTO tmd_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Adakwör nɨ ñɨgö mi yadmɨdla, mönö diba yadɨb wop aku, Sodom nöbö mö piaku mönö ulmɨdö mɨŋi yöxöña; ñɨŋ Kapaneam nöbö mö mönö diba yöxöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Wop aku Jisas nuŋ Nuö yadöŋa, “Acö, nɨ ib nagö yadmön bɨl sö duaŋ. Naŋ Nöbö Dib, adöx yöd röul adö kau sö aipam, mögörɨb il kɨ aipam nugwidɨx mɨdlö aku, rɨb naŋ keir yöx nuguman wä rɨ mag akuyöbö, nöbö mö rɨb wä yöx nugwön nugwölɨŋö, röi akuyöbö, ñɨgö mönö nɨ yadmɨdɨl il aku yad nölöiö; makwam nöbö mö halöu ha kiai röxgɨba mɨdöi akuyöbö ñɨgö rɨb wä nölman, mönö na yadmɨdɨl il aku yad wöxnö nɨglö aku, nagö wä rö rɨlaŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jisas aliö rön yadöŋa, “Acö ölɨsö nuŋwa mɨd aku döŋö, nɨ nöla. Nöbö mö bli nɨ nugw ri abön rölöi; Acö nuŋwör nɨ nugwa. Nör Acö nugwo nugw ri abla. Makwam nöbö mö rɨb wä nöinö, rön, nugun akuyöbö, ñɨgö rɨb wä nölmön, Acö nugwo nugwöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Jisas aliö rön yadöŋa, “Ñɨŋ nöbö mö ap yogw diba ömörö ipɨtmɨn öim rag yönön rɨb mɨga yöxön mɨdöi bla, nɨ pöl höŋ nugwön ap yogw dib ömörö ipɨtmɨn öim rag yönmɨdöi aku, nɨ keir öröu pɨmön aŋöi nɨgöña. ");
INSERT INTO tmd_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nɨ nöbö höimölɨb wä mɨda tar mɨdla; ölɨsö rödöin; makwam, nɨ pöl höñ aku, mabö na rɨ nöiöña, höbwab rɨb madmag ñɨgö yuö kwo aŋöi nɨgöna. ");
INSERT INTO tmd_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ñɨŋ nɨ pöl hön mabö na rɨmɨjöñ aku, pɨ ömörö rɨ nölen; womiöx nöiöna. ");
INSERT INTO tmd_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Juda God höjöpalɨb wop aku, Jisas nöbö nuŋ bla pɨsaŋ wit möriwö mibɨla du gɨrön, nöbö nuŋ bla kiö pɨlɨm, wit mag piaku bli pɨlɨl rɨ pön, uñ pal abön, nɨm gɨr dumɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Akuyöbö almɨdmɨn, Perisi nöbö piaku nugwön, Jisas nugwo yadmä, “Lo mönö ana yad gɨ mɨda, nöbö mö God höjöpalɨb wop aku mabö rɨmɨdölöi. Makwam nöbö naŋ bla pödpöd rɨmɨn God höjöpalɨb wop mabö rölɨb kɨ, wit maga uñ pal abmɨdöi owa?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Aliö rɨmɨdmɨn, Jisas ñɨgö yadöŋa, “Depid maduar ör nöbö nuŋ bla pɨsaŋ kiö pɨlmɨn, God höjöpalɨb ram aku uröpɨnön, bred God mämäg il rol yöra nɨgön, nöbö hör nɨmmɨdölöi, God ap höjöpal ur nölɨb nöbö piakwör nɨmmɨdöi bred aku, ñɨgö yad nugumɨn nugwo nölmɨn, nöbö nuŋ bla pɨsaŋ nɨmɨmä. Makwam kiö pɨlmɨn alim haiwo aku, God Mönö bö kai kɨtim aku ñɨŋ nugwölöi ä? ");
INSERT INTO tmd_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Ñɨŋ Mosɨs God Mönö kai kɨtöŋ aku nugwölöiŋödö. Nuŋ kai kɨtön yadöŋa, ‘Nöbö God ap höjöpal ur nölɨb nöbö piaku, God höjöpalɨb wop aku, God höjöpalɨba ram möl yuadö du mɨdön, mabö röia. Makwam God ñɨgö mönö diba yadenɨŋö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Makwam nɨ ñɨgö yadmɨdla, God höjöpalɨb ram aku ap dib yöi; yörɨk nugumɨdöi kɨ döŋö ap dibɨm. ");
INSERT INTO tmd_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Makwam mönö i God Mönö kai kɨtim aku, nugw ri abölöiŋ ä? Mönö aku kai kɨtön yadmä, ‘Nöbö mö nɨ ap pal höjöpal ur nöiöñ aku, nɨ wä ren; nöbö mö mɨdö bla uliöxöñ aku, nɨ wä cönɨŋö,’ rɨmä. Mönö aku nugwön rölöi aku mɨ, nöbö nɨ bla mag wä rɨmɨdmɨn nugugɨrön, ñɨŋ nöbö nɨ pia yadyöxön yadöia. ");
INSERT INTO tmd_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","‘God höjöpalɨb wop! God höjöpalɨb wop!’ me röi aku, jɨ Nöbö Ha nuŋwa akwör God höjöpalɨb wop aku nugwidɨx mɨdö, rön, rɨb aku yöx nugwölöi. ");
INSERT INTO tmd_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisas mögörɨb aku röböxön, mögörɨb i duön, Juda mögum rɨb ram möla yuadö duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Makwam ram möl yuadö aku nöbö imag po röŋ i mɨdöŋa. Nöbö mö hö mɨdim bla, Jisas mönö bli yadaŋ nugwo pön du mönö diba yajnɨŋö, rön, nugwo inakmönö hörön yadmä, “God höjöpalɨb wop kɨ, nöbö mö kömö nɨgɨb mönö wöhö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Aliö rɨmɨdmɨn, Jisas ñɨgö yadöŋa, “Hön sipsip ñɨŋ i God höjöpalɨb wop kɨ ulöm möla pɨn diön aku, pɨ aböñɨŋönö wöhö? Pa abɨb maga ra. ");
INSERT INTO tmd_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Makwam hön sipsip aku hör ap. Nöbö mö aku ap dib. God höjöpalɨb wop kɨ kömö nɨgaŋ, me rön cɨnɨŋ aku, mönö mɨdölö, cɨnɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jisas aliö rön, nöbö imag po röŋ aku nugwo yadöŋa, “Imaga mɨlkap abö!” röŋa. Aliö rɨmɨn, imaga mɨlkap aböŋa. Alöŋa nugwön imag po röŋ aku aŋadö wä rɨmɨn, imag adöi wä mɨdöŋ akuyöbö mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Almɨn nugwön, Perisi nöbö bla du mögum rön, nugwo alɨp alɨp duön pɨl pal nɨgnɨŋö, rön, mönö nɨg nugumɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Almɨdmɨn, Jisas nugwön, mögörɨb aku röböxön, möl i duba rön duöŋa. Dumɨn nugugɨrön, nöbö mö mɨg mɨŋa nugwo mai dumä. Almɨdmɨn, nöbö mö ap röŋ bla, nuŋ rɨmɨn magalɨg kömö nɨgmɨn nugugɨrön, ");
INSERT INTO tmd_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ñɨgö yadöŋa, “Nöbö aku al aliö rö, rön, yadmɨjeñɨŋö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jisas alöŋ aku, God mönö yadɨb nöbö Aisaia cönɨŋö, röŋ mag akwör röŋa. Nuŋ kai kɨtön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Nɨ aŋadö yad nɨgɨl nöbö kɨ, mabö na rɨ nöiöna. Nɨ nugumön, nɨ mɨ wä rɨ nöbö aku maku. Nɨ nuŋ madmag nɨgla. Inöm na aku nugwo pɨsaxmɨn, nöbö mö ñɨŋ agö magɨm rön römɨd ri abɨb mönö na aku, nöbö mö magalɨg yad nöiöna. ");
INSERT INTO tmd_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Makwam nuŋ nöbö mö piaku nugwaŋ ölɨsö wölaŋ, mönö i yaden. Nöbö mö mɨdöi bla, nör nugwɨŋ, me rön, aj halön yaden. ");
INSERT INTO tmd_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nöbö mö nugwölöi bla ñɨgö tar yad nöl ri aböna. Hötɨkö wöröxɨb maga rɨm, wel röbö unön nɨgɨm yönmɨd mag akuyöbö ñɨgö yajöna. Nuŋ aliö alɨp diön aku, God rɨg yad adakwör mɨ aŋadö wöluaŋ, ap kib mag gwogwo rɨb adaku mɨ aŋadö pɨn pal diöna. ");
INSERT INTO tmd_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nöbö mö mögörɨb adadö bla algör, nugwo rɨbyöx gɨba pöxmɨjöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ragwo kap nöbö i, mämäga we wölɨm, mönö pɨmɨdölöŋ nöbö aku pön, Jisas mɨdöŋ yöra pön hömä. Jisas ragwo ha aku yad abmɨn, mämäga ix nugwön, mönö pön röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nöbö mö mɨdim bla, Jisas röŋ aku nugwön, aiö rön yadmä, “Nöbö kɨ nöso Depid Ha nuŋwa öim pöx mɨdmɨdöl akuyöbö röxgö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Makwam Perisi nöbö bla mönö aku nugwön, rɨb ñɨŋ bla akwör ix nugwön yadmä, “Nöbö aku God ölɨsö pön yad aböl; nuŋ ragwo ha bla nuö ñɨŋa Bielsebul ölɨsö pön yad abö,” rön rɨbyöx nugumä. ");
INSERT INTO tmd_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","26","Makwam rɨbyöx nugumä aku, Jisas nuŋ keir nugwön, ñɨgö yadöŋa, “Seten öbɨlön, nöbö mö nuŋwa bli yad abön aku, pödpödiö nöbö diba mɨjön? Mögörɨb i, ñɨŋ keir nuö nuö yadön asɨx hörɨrör nɨgöñ aku, pɨn bɨcöña. Mögörɨb dib i mönö nöbö mö il paŋyöbö i, ñɨŋ keir nuö nuö yadön asɨx hörɨrör nɨgöñ aku, wä ren. Ñɨŋ mag akuyöbö yadmɨdöi aku, jɨ Seten nuŋ yam nuŋ keir akuyöbö ñɨŋ yad aben. ");
INSERT INTO tmd_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Nɨ yadöia, ‘Ragwo ha bla nuö ñɨŋa Bielsebul ölɨsö pön yad ablaŋö,’ röi aku, jɨ ñɨŋ nɨ yadɨŋ nugunöm: nöbö ñɨŋ keir bla Bielsebul ölɨsö aku pön ragwo ha akuyöbö yad abmɨdöiŋönö owa? Ñɨŋ keir yajöña, ‘Nöbö mö i mag aliö akuyöbö alɨb maga mɨdölö,’ cöña. ");
INSERT INTO tmd_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","“Makwam nɨ God Inöma ölɨsö pön, ragwo ha piaku yad abmɨdɨl aku, pödpöd rɨmɨn God nuŋ nöbö mö pön nugwidɨx mɨdɨb wop aku mödö hö mɨk, me rön, nɨ pölöiŋönö? ");
INSERT INTO tmd_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Nöbö ölɨsö ödöriö i mɨdaŋ, ap nuŋ bla pɨba dueñɨm. Nuŋ mɨ aŋadö nag nɨg gö nɨgön, yoŋ duön ap nuŋ bla pöña. ");
INSERT INTO tmd_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Nöbö mö nɨ pɨsaŋ mɨdöi bla, nöbö mö yölɨŋön nɨ pöl höña. Makwam nöbö mö nɨ yöi bla, nöbö mö nɨ höba rɨmɨdöi akuyöbö, rɨbɨx aböña. ");
INSERT INTO tmd_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Makwam, ñɨŋ nugw ri aböña. Nöbö mö bla ap kib mag gwogwo agap bɨlɨm rɨmɨjöñ aku, God nugwön röböxöna. Nöbö mö God mönö röd aböñ aku, algör God nugwön röböxöna. Makwam God Inöma mönö röd aböñ aku, God nugwön röböxen. ");
INSERT INTO tmd_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nöbö Ha nuŋ aku nugwo mönö gwogwo yajöñ aku, God nugwön röböxöna. Jɨ Inöm Leia nugwo mönö gwogwo yajöñ aku, wopik aipam, mai piaku aipam, God nuŋ rɨbyöx nugu gör mɨdön röböxen. ");
INSERT INTO tmd_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ñɨŋ nɨ pödpöd rɨmɨn yadöi, ‘Bielsebul ölɨsö pön mabö wä aku rö,’ röi? Bɨ wä bla mag waiö yaxöna; bɨ gwogwo bla mag gwogwo yaxöna. Bɨ maga yaxön aku nugwön, bɨ aku bɨ waiö bɨ aku bɨ gwogwo, me cöña. ");
INSERT INTO tmd_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ñɨŋ kas halöu ha mɨdön aliö yadmɨdöia. Ñɨŋ nöbö mö gwogwo makwam mɨ, pödpödiö mönö wä yajöñ? Nöbö mö mönö yadöi akuyöbö nugunɨŋ aku, höbwab rɨb madmag ñɨgö kwo pödiö mɨd aku nugunɨŋa. ");
INSERT INTO tmd_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nöbö mö wä akuyöbö, höbwab rɨb madmag yuö ñɨŋ kwo ap wä mɨda nugwön ösös rɨ ri aböia; nöbö mö gwogwo akuyöbö, höbwab rɨb madmag ñɨŋ kwo ap gwogwo mɨda nugwön mag gwogwo röia. ");
INSERT INTO tmd_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nugw ri aböña. Mai mönö diba yadɨb wop aku, God nöbö mö ñɨgö magalɨg, mönö amnör yadön, nöbö mö bli rɨ gwogwam rɨmä aku, pödpöd rɨmɨn aliö yadöiŋö, rön, ñɨgö yadyöxöna. ");
INSERT INTO tmd_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Makwam, ñɨŋ keir yajöñ mönö akwör God nugwön yadaŋ, kömö diöñɨŋönö ölɨŋ höb pöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","God lo mönö yad nölɨb nöbö bli nɨgön, Perisi nöbö bli nɨgön, hön Jisas nugwo yadmä, “Mönö yad nölɨb nöbö! Ap rölɨbä akuyöbö i raŋ, an nugunɨŋ aku, God nagö yad abmɨn hölaŋö cɨnɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Aliö rɨmɨdmɨn, Jisas yadöŋa, “Ñɨŋ nöbö mö ap kib mag gwogwo akwör rön, God mönö yadöŋ aku nugwölöi. Ap rölɨbä akuyöbö i raŋ nuguŋö, röi aku, jɨ ñɨgö ap i rɨmön nugweñ. God mönö yadɨb nöbö Jona nugwo röŋ mag akwör nɨ kwo algör raŋ nugwöña. ");
INSERT INTO tmd_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Maduar ör dölöm dib aku Jona nugwo pɨ alɨg höxnaŋ röbmɨn, höbwab yuö kwo wop mös paŋ mɨdön höuöil höŋa. Mag akuyöbö, nɨ Nöbö Ha nuŋwa, algör wop mös paŋ mögörɨb mibɨl piaku mɨdön höuöil höna. ");
INSERT INTO tmd_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Maduar Jona duön, taun dib Ninepa nöbö mö ñɨgö yadmɨn, ap kib mag gwogwo rim akuyöbö yadkap röböxön, God nugw pɨmä. Jona hör nöbö aku yadmɨn nugumä; ñɨŋ weik mɨd Nöbö Dib kɨ mönö yad aku pölöi. Makwam, mai mönö diba yadɨb wop aku, Ninepa nöbö ñɨŋ öbɨlön ñɨgö mönö diba yadɨŋ, ñɨŋ mönö diba yöxöña. ");
INSERT INTO tmd_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Kwin dib, mögörɨb Siba yöbö aku, maduar röŋ mag akuyöbö nugwöia. Mögörɨb nuŋwa pad piaku mö aku, jɨ Juda kiŋ dib Solomon rɨb wä yöx nugw ri abɨb nöbö aku mönö nuguba höŋa. Solomon hör nöbö aku, jɨ nuŋ aliö alöŋa; jɨ pödpöd rɨmɨn Nöbö Dib weik mɨd kɨ mönö yad aku nugwölöi? Mai mönö diba yadɨb wop aku, Siba kwin öbɨlön ñɨgö mönö diba yadaŋ, ñɨŋ mönö diba yöxöña. ");
INSERT INTO tmd_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Kɨjaki yam nuŋwa ragwo ha bla hö nöbö mö yuö wöl mɨdön, mai röpɨn duön, nöbö mö bli yuö wöinö, rön, nugw yön wöhö nugwön, ");
INSERT INTO tmd_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","höbkal hön nugwaŋ, nöbö höd röböx diön aku mögedö wä mɨda mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nuŋ nugwön, ragwo ha gwogwo nuŋ röxgɨb yöi wöhö, mɨ ragwo ha gwogwo ödöriö, akuyöbö mɨj sö yölɨŋön pön hön, nöbö aku yuö nuŋ kwo wöliöña. Akuyöbö alaŋ, höd mɨd gwogwo röxg mɨdöŋ mag akuyöbö yöi; mai mɨdɨb nuŋwa mɨ ödöriö gwogwo cöna. Ñɨŋ nöbö mö wopik mɨdöia ñɨŋ ap kib mag gwogwo höd rɨ mɨdmɨdöi akuyöbö yöi, mai mɨ ap kib mag gwogwo ödöriö rɨmɨjöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas nöbö mö akuyöbö ñɨgö mönö yadmɨn nugugɨrön, pɨgnɨŋ nuöm nöbö nuŋ bla rɨŋadö bö hön yadmä, “An Jisas nugwo mönö yadɨba hölɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Aliö rɨmɨdmɨn, nöbö i ram möl yuadö wöluön Jisas yadöŋa, “Nam pɨgnaŋ nöbö rɨgɨr hö mönö yadɨba rɨŋö bö mɨdöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Aliö rɨmɨn, Jisas paiŋö yadöŋa, “Mam na, haul nöbö na yönɨmɨm?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jisas aliö rön, iŋpɨlö mɨlkap abön nöbö nuŋ pia yabuön yadöŋa, “Mam na, haul nöbö na mɨdöi mɨk! ");
INSERT INTO tmd_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nöbö mö, Acö na adöx yöd röul adö kau sö mɨd aku, mönö yad akuyöbö nugwön rɨg yad mag akwör röi nöbö mö akuyöbö, haul nöbö na, mölöu na, mam nöbö na mɨdöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Wop paŋyöbö akwör, Jisas rama röböxön du Ban Yuö Galili pö yöra römɨdɨm, ");
INSERT INTO tmd_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","3","nöbö mö mɨga hön nugwo wob yuö nɨgmä. Akuyöbö almɨdmɨn nugwön nuŋ du röbö alebö rola römɨdön, duön röbö mibɨl yörkwo mɨdmɨn nugugɨrön, nöbö mö röbö halaia yöraku öbɨl gɨ mɨdmä. Jisas nöbö mö akuyöbö ñɨgö mönö höd röxön mönö mɨga akwör yad nölöŋa. Yad nöl gɨr yadöŋa, “Nöbö i wita wölaŋ, me rön, wit maga aku pön du möriwö rɨb bla abmɨjöna. ");
INSERT INTO tmd_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Wit maga pɨ abaŋ, bli ödöi rol yöra pɨnaŋ, yöur bla hön nɨmöña. ");
INSERT INTO tmd_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Bli rɨg rol mögö ulul mɨjön yöra pɨnön, rɨmgör mogw bɨrön ");
INSERT INTO tmd_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","jɨ jöjö yuö bö duen aku, naiö nɨgaŋ wöröxöna. ");
INSERT INTO tmd_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Bli nag kaigap mibɨl piaku pɨnön wöiöna, jɨ nag aku höu wobön pal nɨmaŋ, wöröxöna. ");
INSERT INTO tmd_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Jɨ bli mögö wä rol yöra pɨnön, wöl ri abaŋ, maga magöri maga cöna. Bli padokwo padök mös mös höuöiliö hö wölu amñaxɨb sö (100) yaxöna; bli padokwo padök mös höuöiliö hö du adokwebö ragpɨd kwo (60) yaxöna; bli padokwo paŋyöbö i höuöiliö hö wölu mɨj sö (30) yaxöna. ");
INSERT INTO tmd_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ñɨŋ nöbö mö rɨmɨj möla mɨjön bla, mönö yadmɨdɨl kɨ rɨmɨj pal nugw ri abne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jisas aliö rɨmɨn, nöbö nuŋ bla hön, nugwo yad nugwön yadmä, “Nöbö mö akuyöbö ñɨgö pödpöd rɨmɨn mönö höd röxön aliö rɨlaŋö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Aliö rɨmɨn, Jisas yadöŋa, “God nöbö mö nuŋwa pön nugwidɨx mɨdɨb mönö umad gɨ mɨdmɨd aku, ñɨgö rɨba nölaŋ nugwöña, jɨ nöbö mö piaku nugweñ. ");
INSERT INTO tmd_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nöbö mö mönö na nugwön nugw pöi akuyöbö, mönö bli kwo nugwön, ila nugw ri aböña; jɨ nöbö mö mönö na nugwön nugw pölöi akuyöbö, mönö ulmɨdö nugwöi aku aŋadö yöm cöna. ");
INSERT INTO tmd_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ñɨgö mönö höd röxön yadɨl aku, ñɨŋ mämäg aipam rɨmɨj aipam mɨd aku, jɨ rɨg yada maku, me rön, nugwölöi. ");
INSERT INTO tmd_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Alöi aku, God mönö yadɨb nöbö Aisaia höd cönɨŋö, rön, rɨg kai kɨtöŋ mönö mag akwör röia. Mönö mag aku kai kɨtön yadöŋa, ‘Mönö nugwöñ aku, jɨ mönö rɨg yada aliö, me rön, röx nugwön ila nugweñ. Mämäg nugwöñ aku, jɨ ap i nugweñ. ");
INSERT INTO tmd_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nöbö mö kɨyöbö mönö na yadmɨdɨl aku ñɨŋ ipɨtmɨn nugwölöi. God Mönö nugwɨŋ, anɨŋ raŋ, nöbö mö nuŋwa mɨdɨbä maga rö, rön, rɨmɨj möla pidɨxön, mämäga ipax gɨ mɨdöiŋö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","17","“Makwam, ñɨŋ nugwölöi; jɨ God ñɨgö rɨb wä nölmɨn nugwöi aku wahax pöña. Nɨ ñɨgö mi yadmɨdla, God mönö yadɨb nöbö bla aipam, God Mönö yadmɨd mag akwör nugwön rɨmɨdöi nöbö mö bla aipam, nöbö mö mɨga Mesaia nugunɨŋö, rɨmɨdmä aku, jɨ mämäga ñɨŋa nɨ nugwölim, mönö na yöxölim. Makwam weik ñɨŋ nɨ mämäga nugwön, audiöx nugumɨdöi aku wahax pöña. ");
INSERT INTO tmd_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Makwam mönö höd röxön yadɨl aku, nöbö wit maga pön du möriwö aböŋ haiwo aku, ila yadmön nugune,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","“Wit maga bli ödöia pɨnaŋ, yöur bla hön nɨmöñɨŋö, rɨl aku, nöbö mö akuyöbö, God nöbö mö pön nugwidɨx mɨdɨb mönö wä aku nugwöñ aku, jɨ il aku nugweña nugwön Nöbö Gwogwo nuŋ raŋ aŋadö uplöböñɨŋö, rön, yadmɨdla. ");
INSERT INTO tmd_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","“Makwam maga bli rɨg rol mögö ulul mɨjön yöra pɨnön, rɨmgör mogw bɨrön, jɨ jöjö yuö bö du ölɨsö pɨlen aku, naiö nɨgaŋ wöröxönɨŋö, rɨl aku, nöbö mö bla mönö na yöudöŋdöŋ nugwöñ wop aku, wahax pöña, jɨ wopik ör nöbö mö bli hön, nöbö mö mönö na nugwöñ akuyöbö rɨb gwogwo yöxön, kwolmal röxg mɨdön, ñɨgö rɨ gwogwam cöña nugwön nöbö mö mönö na höd pim piaku, wopik mönö na aku uplöbön, rɨb ada bli yöx nugwöñɨŋö, rön, yadmɨdla. ");
INSERT INTO tmd_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mag bli nag kaigap mibɨl piaku pɨñönɨŋö, rɨl aku, nöbö mö akuyöbö mönö na aku nugwöñ aku, jɨ möriwö kul, ram, hön, yu senap, köme ulnöu löpöi ap bla akwör rɨbyöx nugwön, God mönö wä aku röböxöña nugwön ap nɨmɨb bli yaxenɨŋö, rön, yadmɨdla. ");
INSERT INTO tmd_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Makwam maga bli mögö wä rol yöra pɨnön, wöl ri abön, mag mɨga yaxönɨŋö, rɨl aku, nöbö mö bla mönö na aku nugw pön, mɨ ödöriö pɨ cɨcɨ nɨgön, bli rɨ ri abmɨjöña, bli mɨ ödöriö rɨ ri abmɨjöña, bli rɨ ri abön mag keiryöbö ödöriö rɨmɨjöñɨŋö, rön, yadmɨdlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisas ñɨgö mönö wab i kwo mönö höd röxön yadöŋa, “God nöbö mö pön nugwidɨx mɨjön aku, haiwo urmɨdɨl mag kɨyöbö cöna. Nöbö dib i wit mag bla wölaŋ, me rön, rag du möriwö rɨb nuŋ bla aböna. ");
INSERT INTO tmd_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Jɨ pɨxmag yuö bö hölɨm diöñ mag aku, kwolmal nöbö i ap iñ gwogwo bli pön hön, mibɨla abön diöna. ");
INSERT INTO tmd_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Makwam, wit iñ wä aku wöiöna, jɨ ap iñ gwogwo aku aipam wöiöna. ");
INSERT INTO tmd_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Alaŋ, mabö rɨ nölɨb nöbö bla hön nöbö dib aku nugwo yajöña, ‘Nöbö dib! Ap iñ wä bla akwör pön du möriwö rɨb aku ablö aku ap iñ gwogwo bla pikai yöbö hön alɨg wölmɨd?’ cöña. ");
INSERT INTO tmd_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nuŋ ñɨgö paiŋö yajöna, ‘Nöbö kwolmal nɨ i pön hö abö,’ cöna. Makwam ñɨŋ yajöña, ‘An duön ap iñ gwogwo wölmɨd piaku röd abnɨŋönö pöd cɨnɨŋ owa?’ cöña. Nöbö möriwö rɨb mɨnöbö aku paiŋö yadön yajöna, ");
INSERT INTO tmd_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Ehöu! Wop kɨ, ap iñ gwogwo piaku pɨ mölöd abnö, rɨmön, duön ap iñ wä bli alɨg pɨ mölöd abɨb maga mɨda! ");
INSERT INTO tmd_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Röböx gɨŋ mösör wölaŋ. Makwam wölön mag yaxaŋ, röxɨb wop aku nöbö ap ödörɨb nɨ bla yajɨna, “Ap iñ gwogwo piaku pɨ rödön, rag du rogwa rogwa rɨ nɨgɨŋ, rɨna urɨŋ yön bɨcuaŋ; jɨ wit mag bla akwör pɨ mögum rön, rag du wit mag nɨgɨb yuadö möl na aku nɨgne,” cɨnö,’ cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Jisas ñɨgö mönö i piöŋö höd röxön yadöŋa, “Nöbö i bɨ masted mag ulmɨdö aku rag du möriwö rɨb nuŋ aku abmɨdaŋ, wöl dib röxön padö pɨlaŋ, yöur bla hön löx bla hörɨrör rin wiöña. Makwam mag akuyöbö, God nöbö mö pön, mögörɨb wä nuŋwa adöx yöd röul adö kau sö nugwidɨx mɨjön aku maku,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisas mönö i piöŋö höd röxön yadöŋa, “Mö bla ap is röi aku, pɨ wit mag pia wi yöj diba möl bö abön alɨg pɨ höuöilmel rɨm, apa wöl dib röxa. Mag aliö akuyöbö, God nöbö mö pön, mögörɨb wä adöx yöd röul adö kau sö nugwidɨx mɨjön aku maku,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisas nöbö mö akuyöbö ñɨgö mönö bli yad nöinöb rön wöxnö yadmɨdöl; mönö höd akwör röxön ñɨŋ yad nölmɨda. ");
INSERT INTO tmd_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Alöŋ aku, God mönö yadɨb nöbö i höd cönɨŋö, rön, rɨg kai kɨtöŋ mag akwör röŋa. Nuŋ mönö aku kai kɨtön yadöŋa, “Mögörɨb maduar ör rɨ nɨgöŋ wop aku ila nɨgön, mɨdɨp duön weik mɨdöl wop kɨ, mönö nugwölim aku, mönö höd röxɨb mönö akwör ñɨgö yad nöinö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisas aliö rön, nöbö mö akuyöbö ñɨgö röböxön, ram möl yuadö dumɨn nugugɨrön, nöbö nuŋwa akuyöbö möl sö hön nugwo yadmä, “Ap iñ gwogwo möriwö yuö wölö, rön, mönö höd röxön yadlö aku, anɨŋ yadaŋ nuguŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Aliö rɨmɨn, Jisas yadöŋa, “Nöbö ap iñ wä abö rɨl aku, nɨ Nöbö Ha nuŋwa. ");
INSERT INTO tmd_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","39","Möriwö, me rɨl aku, mögörɨb mɨgrö kɨ magalɨg. Ap iñ wä, me rɨl aku, God pön nugwidɨx mɨjön nöbö mö akuyöbö. Nöbö ap iñ gwogwo pön hö abmɨn wölö, rɨl aku, nɨ nugumɨn ölɨsö wöl nöbö kɨjaki aku nuŋwör yadla. Ap iñ gwogwo wölö, rɨl aku, kɨjaki nöbö mö nuŋ akuyöbö ñɨŋ yadla. Makwam wit mag göj ub wop, me rɨl aku, mögörɨb mɨgrö kɨ hölögɨpɨb wop aku yadla. Nöbö ödör rag höb, me rɨl aku, ejol akuyöbö yadla. ");
INSERT INTO tmd_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ap amnör wöl bla rödön, rag du rɨn yön mɨd möl bö aböñɨŋö, rɨl aku, mögörɨb mɨgrö kɨ hölögɨpön wop aku maku, me rɨla. ");
INSERT INTO tmd_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nöbö Ha nuŋwa ejol nuŋ akuyöbö ñɨgö yad abaŋ, hön, nöbö mö ap kib mag gwogwo röi bla aipam, nöbö mö nöbö mö bli ñɨgö yadmɨdɨm, ñɨŋ ap kib mag gwogwo röi bla aipam, ejol ñɨŋ hön ñɨgö pön, ");
INSERT INTO tmd_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","rɨn hör yönmɨd möl bö abɨŋ, ölɨŋ pɨlaŋ nugugɨrön, ajmaga öbɨx gɨg yuön imöñɨŋö, rön, yadla. ");
INSERT INTO tmd_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Wop aku, Acö ñɨŋa nöbö mö pön adöx yöd röul adö kau sö nugwidɨx mɨjön akuyöbö, ñɨŋ naiö mila röxg ab gɨ mɨjöña. Ñɨŋ nöbö mö rɨmɨj möla mɨjön bla, mönö yadmɨdɨl kɨ rɨmɨj pal nugw ri aböña. ");
INSERT INTO tmd_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Makwam God nöbö mö pön nugwidɨx mɨdɨb aku, haiwo aliö kɨyöbö mɨda. Nöbö i duön nugwöna, rɨg mag bɨyöja maduar ör umadim i möriwö yuö mɨjöna. Nuŋ nugwön, ap bli nɨgön nugumab ri abön, rama diöna. Duön, ñɨñɨ diba nɨgön, ap nuŋ bla magalɨg sɨm rön, rɨg pön, rag duön, möriwö aku wobön, du rɨg mag bɨyöj aku pöna. ");
INSERT INTO tmd_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","“Makwam God nöbö mö pön nugwidɨx mɨdɨb aku, haiwo aliö kɨyöbö mɨda. Nöbö sɨm rɨb akuyöbö köme wödö mag mɨj ulmɨdö ‘pöl’ aku hölu nugw yönön, köme wödö mag wä mɨdöi nugwön, rama duön, ap ñɨŋ bla magalɨg sɨm rön, rɨg pön, rag du köme wödö mag wä aku woböna. ");
INSERT INTO tmd_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“God nöbö mö pön nugwidɨx mɨdɨb aku, haiwo aliö kɨyöbö mɨda. Nöbö mö bli ubena rag duön, röbö yuö abɨŋ, dölöm mɨg mɨŋa hön möla wölöia. ");
INSERT INTO tmd_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Akuyöbö alɨŋ, ubena pön pɨxɨp rɨb ki kwo duön, dölöm wä bla hölu pɨ dölöm nɨgɨb wi yöj möla nɨgön, dölöm gwogwo bla pɨ aböia. ");
INSERT INTO tmd_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mögörɨb mɨgrö kɨ hölögɨpön wop aku mag akuyöbö aliö aiöna. God ejol nuŋ bla hön, nöbö mö God Mönö rɨg yad akwör cöñ bla pɨ hör nɨgön, nöbö mö God Mönö rɨg yad akwör rölöi bla pɨ hör nɨgön, ");
INSERT INTO tmd_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","pön du rɨn nöi yönmɨd möl bö aböña. Abɨŋ ölɨŋ pɨlaŋ, ajmag ñɨŋa öbɨx gɨg yuön, im gɨr mɨjöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jisas aliö rön yadöŋa, “Nɨ mönö yadɨl bla nugwöiŋönö ö?” röŋa. Aliö rɨmɨn, nöbö nuŋ bla yadmä, “Yöwö, nugwölɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Aliö rɨmɨn, Jisas yadöŋa, “Ñɨŋ höd God lo mönö akwör yad mɨdmɨdöi aku, jɨ wopik ñɨŋ God nöbö mö pön nugwidɨx mɨdɨb mönö wä yadɨl aku nugwöiŋönö. Aliö nugwön ñɨŋ wopik nöbö mö piaku yad nöiöñ aku, ñɨŋ God Mönö wä hödyöbö aku aipam, God Mönö wä yoŋyöbö aku aipam yad nöiöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Makwam Jisas nuŋ mönö höd röxön mönö yadöŋ aku yad pörön, taun nuŋwa Nasaret duön, Juda mögum rɨb ram möl yuadö duön, nöbö mö akuyöbö ñɨgö yad nölɨm, ñɨŋ nugwön aiö waiö rɨmä. Ñɨŋ piöŋö yadmä, ‘Nöbö kɨ nuŋ pödpödiö rɨb ölɨsö yöx nugwön ap rölɨbä akuyöbö aliö rɨmɨdö?’ rɨmä. Mai piöŋö yadmä, ");
INSERT INTO tmd_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","56","“Nöbö kɨ nuö nuöm, pɨgnɨŋ nölöunɨŋ nöbö nuŋ bla, an pɨsaŋ mɨdöi aku, jɨ nuŋ pödpödiö nöbö dib röxg mɨdön, mönö hör yadön, ap rölɨbä aliö mag cɨmal akuyöbö rɨmɨd? Nuö nuŋwa nöbö kapeda; nuöm Maria; pɨgnɨŋ nöbö nuŋ bla Jems aku, Josep aku, Saimon aku, Judas aku. Makwaim nuŋ pödpödiö hön aliö almɨdö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Aliö rön, ñɨŋ Jisas nugwo rɨb gwogwo yöxön, nuŋ yadöŋ mönö aku yöxölim. Makwam Jisas ñɨgö yadöŋa, “God mönö yadɨb nöbö bla mögörɨb pad piaku duön yadmɨn, mi yadöiŋö, rön, nugwöña; jɨ mögörɨb ñɨŋ keira yadmɨn, inakmönö hörmɨdöiŋö, rön, mönö ñɨŋa yöxeñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Mönö yadöŋ aku nugwölim makwam, mögörɨb aku ap rölɨbä akuyöbö mɨga rölöŋ. ");
INSERT INTO tmd_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Makwam gapman nöbö dib Herod mögörɨb Galili nugwidɨx mɨdmɨd aku, Jisas nuŋ agö magɨm röŋ mönö aku nugwön, ");
INSERT INTO tmd_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","du mabö rɨ nölɨb nöbö nuŋ bli ñɨgö yadöŋa, “Nöbö Jisas ap rölɨbä akuyöbö rɨmɨd aku, nuŋ nöbö hör yöi; nuŋ röbö pal nölɨb nöbö Jon akwör. Nugwo pɨl pal nɨgɨm aku, jɨ höbkal öbɨlön hö mɨd aku, mag cɨmal rölɨbä aliö piaku rɨmɨdö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Makwam Herod nuŋ Jon nugwo nag nɨgön, pɨl pal nɨgöŋ mönö il aku aliö mɨda. Herod nuŋ pɨgnɨŋ Pilip mönɨŋ Herodias pön dumɨn, Jon Herod nugwo yadöŋa, “Naŋ akuyöbö ailö aku, mag wä i röiö. Nöbö i pɨgnɨŋ nuŋwa kömö mɨdaŋ nobɨlnɨŋ nuŋwa penɨŋö,” röŋa. Jon aliö rɨmɨn, Herodias nuŋ Herod mönö aku yadöŋa nugwön Herod Jon nugwo pön du nag nɨgön, pɨl pal nɨgɨnö, rön rɨbyöx nugwöŋ aku, jɨ nöbö mö bla, Jon nugwo God mönö yadɨb nöbö an, me rɨmä aku nugwön ipöxön nɨg duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Makwam mai Herod nuöma nugwo yöx pön höŋ wop akwör, nöbö mö mɨg mɨŋa hö mögum rön, ap mag ur nɨmɨba rɨmä. Wop aku, Herodias halöu nuŋ aku hön mibɨl yöra höx wödmɨn, Herod nugumɨn, mɨ wä röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Almɨn, nuŋ halöu aku nugwo mönö yadön yadöŋa, “Nɨ mönö mi yadön döŋö nagö yadmɨdla, nagö ap i yad nugumɨjɨnö aku, amnör pɨ nöinö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Aliö rɨmɨn, halöu aku, nuöma rɨg yadöŋ akuyöbö nugwön yadöŋa, “Röbö pal nölɨb nöbö Jon yöcmac maga aku, kwosö möl bö nɨgön, rag hö nölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Aliö rɨmɨn, Herod nugumɨn lɨb pɨlöŋa, jɨ nöbö mö bla nugugu mɨdɨm nugugɨrön, halöu aku nugwo wöxnö mönö mi yad nɨgön yadöŋa, “Naŋ ap i yad nugumɨjɨnö aku, amnör pɨ nöinö,” röŋ aku nugwön, nöbö bli yad abmɨn, du Jon naga mɨdöŋ yöra duön, göliöd nuŋwa römaxdörön, ");
INSERT INTO tmd_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","yöcmac maga pɨ kwosö möl bö nɨgön, rag hö halöua nölmä. Nölmɨn, nuŋ piöŋö rag duön nuöm nuŋwa nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Makwam Jon nöbö nuŋ bla hön, nöbäpö högia rag du hogw pɨlön, du Jisas nugwo yad nölmä. ");
INSERT INTO tmd_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisas mönö aku nugwön, du mögörɨb hör möl i mɨjɨnö, rön, röbö alebö pön, mögörɨb aku röböxön duöŋa. Dumɨn nöbö mö piaku, Jisas dumɨd yöra mai duŋö, rön, mögörɨb ñɨŋ bla röböxön, il ila duön, Jisas duba rɨmɨdöŋ piaku dumä. ");
INSERT INTO tmd_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jisas nuŋ piöŋö mögörɨb möl aku höröpɨnön, röbö alebö röböxön, rɨb yöra hön nugumɨn, nöbö mö mɨg mɨŋa mɨdmä. Ñɨgö nugumɨn, lɨb pɨlɨm, nöbö mö ap röŋ akuyöbö rɨmɨn, kömö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Makwam pɨgöŋ mag aku, nöbö nuŋ bla Jisas mɨdöŋ yöra hön, nugwo yadmä, “Womiöx pɨxmag gurɨba rɨmɨda. Ap mag nɨmɨb wopa maduö padɨxa. Ki mögörɨb kɨ. Nöbö mö mɨg kɨyöbö yadaŋ, ram mibɨl pi bɨlɨk duön, ap maga ñɨŋ bli wob nɨmɨŋ,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Aliö rɨmɨdmɨn, Jisas ñɨgö yadöŋa, “Ehöu, ñɨŋ dueñ. Ñɨgö keir ñɨŋ ap mag cɨne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Aliö rɨmɨn, yadmä, “An ap mag mɨga mɨdöl. Hör bred mag akuyöbö mömɨd sö dölöm mös mɨdö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Aliö rɨmɨn, Jisas yadöŋa, “Ap piaku pɨrag hö nɨ nöi,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Aliö rɨmɨn, nöbö mö akuyöbö ñɨgö yadmɨn, ap panö rol bla römɨdmɨn nugugɨrön, bred pɨda aku pön, dölöm hogwa aku pön, laxiö pisö nugwön, God nugwo ri abö rön, bred aku pɨ gɨlɨxön, nöbö nuŋ bla nölɨm nugugɨrön, ñɨŋ pɨ gɨrön, nöbö mö akuyöbö nuöm nɨg nölmä. Dölöm aku algör rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Al gör nuöm nɨg nölmɨn, nɨmmɨdɨm, nɨmmɨdɨm, wöta bɨrɨm, nɨm pörɨb maga mɨdölöŋ. Rɨb rɨb röböxim blaku, Jisas nöbö nuŋ bla yogw akuyöbö möl sö piöxmɨn, aŋadö aja wölöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nöbö mö ap nɨmim piaku, mö bla wöhö, halöu ha ulul bla wöhö, nöbö akwör paip tausan aliö duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jisas, nöbö nuŋ bla ñɨŋ röbö ir kwo duŋ, me rön, yadɨm ñɨŋ röbö alebö pön dumɨdmɨn nugwön nuŋ nöbö mö akuyöbö ñɨgö yad abön, ");
INSERT INTO tmd_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","nuŋ keir God höjöpalɨba önöŋ pɨd i duöŋa. Mɨdɨm, mögörɨba höxi gurmɨdöŋ aku nuŋ paŋyöbö mɨdö akwör nuŋ öñör pɨd sö mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Makwam nöbö nuŋ bla röbö alebö pön röbö yuö mibɨl kwo dum nugugɨrön, hödal diba hön, röbö alebö aku mɨñ pɨ höuöilbä maga röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mag aku rama yöudöŋdöŋ ör löuba rɨmɨdöŋ makwam, Jisas röbö panö rola röbɨp hön, nöbö nuŋ bla mɨdim yöra hömɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ñɨŋ nugwön, “Aku nöbäpö höjöl i hömɨdö!” rön, ölölö rɨmɨn ipöxön, aiö diba rön gɨlö rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jisas piöŋö ñɨgö yadöŋa, “Ipöxmɨjeñ! Nör hömɨdlö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Aliö rɨmɨn, Pita yadöŋa, “Nöbö Dib! Nagör hömɨjɨnö aku, nɨ aipam yadaŋ, röbö panö rol aku röbɨp inöm,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","30","Aliö rɨmɨn, Jisas yadöŋa, “Makwam, hane!” röŋa. Aliö rɨmɨn, Pita röbö alebö aku röböxön, röbö panö rola röbɨp Jisas mɨdöŋ yöra dumɨd dumɨd mibɨl yöra wön nugumɨn, hödal öñöña hömɨn, röbö göuja sö sö rɨm hömɨdöŋa. Almɨdöŋ aku nuŋ ipöxön, röbö yuadö pɨn du gɨrön, wö diba rön yadöŋa, “Nöbö Dib! Nagö nɨ yadkap pö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Aliö rɨmɨn, Jisas rɨmgör nugwo pɨ cɨcɨ nɨgön yadöŋa, “Nugw pɨb mag nagö aku mɨ met wa. Pödpöd rɨmɨn rɨb mös yöxlö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Aliö rön, Jisas Pita pɨsaŋ röbö alebö möla dum nugugɨrön, hödal diba hömɨdöŋ aku ödör pöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Almɨn nugwön, nöbö nuŋ röbö alebö möl bö römɨd gɨ mɨdim bla, Jisas ib nuŋwa yadmɨn bɨl sö dumɨn nugugɨrön yadmä, “Mɨ! Naŋ God Ha nuŋ ödöriö!” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Makwam ñɨŋ röbö bana möxön, mögörɨb Genesaret pö ir kwo wölumä. ");
INSERT INTO tmd_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Uröpɨnɨm, nöbö mö mɨdmɨdöi akuyöbö Jisas nugwo nugwön, Jisas nuŋwör hö rön, nöbö mö mögörɨb il piakuyöbö magalɨg wö rɨmɨn, nöbö mö ap röŋ bla magalɨg pön hömä. ");
INSERT INTO tmd_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Pön höm, Jisas nugwo yad gögö rön yadmä, “Anɨŋ yöwö ran, nöbö mö ap rɨ kɨyöbö, wölɨj nagö pɨ nugwɨŋ, kömö nɨgaŋ,” me rɨmä. Aliö rɨmɨn, nuŋ yöwö rɨmɨn, nöbö mö wölɨj nuŋwa pɨ nugwim bla ñɨgö magalɨg kömö nɨgmɨn wä röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Makwam wop aku, Perisi nöbö bli, lo mönö yad nölɨb nöbö bli, Jerusalem yöbö hön Jisas nugwo yadmä, ");
INSERT INTO tmd_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nöbö naŋ kɨyöbö, pödpöd rɨmɨn nöso auso hacörö wacörö nöbö mönö öim aku röböxön, imag ñɨŋa röbö äbäd abön rölöi, hör ör ap pɨ nɨmöi?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Aliö rɨmɨdmɨn, Jisas paiŋö yadöŋa, “Ñɨŋ pödpöd rɨmɨn God Mönö nuŋ aku röböxön, nöso auso hacörö wacörö nöbö rɨg rim mag akwör rɨmɨdöi? ");
INSERT INTO tmd_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","God nuŋ yadöŋa, ‘Nuö nuöm ñɨgö pɨ ösös rɨ ri abne,’ röŋa. God mönö i yadön yadöŋa, ‘Nöbö i nuö nuöm hogwa mönö gwogwo bli yajön aku, ñɨŋ nöbö aku nugwo pɨl pal nɨgɨŋ,’ me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","7","Makwam ñɨŋ mönö aku ödöriar yad nölölöi. Nöbö i, acö mam yöŋö röböxnö, cön aku, ñɨgö yajöna, ‘Acö mam yöŋö, nɨ ap wä bli ñɨŋ nöbö hogwa nöilöxa, jɨ rɨg ñɨŋ nöbö hogwa nölɨb rɨg aku, wopik nɨ God nugwo nöinö, rɨla, nugwön rɨg ñɨŋ nöbö hogwa nölɨb i mɨdölö,’ cöna. Almɨn, ñɨŋ nugwön yadöia, ‘Ñɨŋ akuyöbö alöi aku, mönö mɨdölö,’ röia. Aliö röi aku, ‘God Mönö yadmɨdölɨŋö,’ röi aku, jɨ ñɨŋ inakmönö höröia; ñɨŋ keir rɨg yadöi mag akwör rölöi. Ñɨŋ mönö aliö akuyöbö nöbö mö piaku ñɨgö yad nölöi aku, God mönö yadɨb nöbö Aisaia nuŋ nöbö ñɨgö röxgɨb aku algör rɨbyöx nugwön, mönö mɨ ödöriö i kai kɨtöŋa. Mönö aku kai kɨtön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","9","‘Nöbö mö kɨyöbö inakmönö hörön yadöia, “God Nöbö Dib an,” me röi aku, jɨ hör mönö akwör yadöia; nɨ madmag nɨgölöi. Nɨ höjöpalön, hör mönö akwör yadöia. God Mönö nöbö mö akuyöbö ñɨgö yad nölmɨdölɨŋö, röi aku, jɨ nöbö mögörɨb il kɨyöbö ñɨŋ keir yadmɨdöi mönö akwör pön yad nöl yönmɨdöiŋö!’ rö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jisas aliö rön, nöbö mö mɨdim bla wö rɨm hömɨdmɨn yadöŋa, “Mönö yadmɨdɨl kɨ nugw ri aböña! ");
INSERT INTO tmd_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nöbö mö piaku ap mag bla amnör nɨmɨŋ, höbwab ñɨgö bö pɨ duön pɨx pɨlöl; höbwab ñɨgö bö rɨb gwogwo yöxön mönö gwogwo yadöi akwör pɨx pɨlɨm alɨg mɨdöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Makwam Jisas nöbö nuŋ bla hön Jisas nugwo yadmä, “Perisi nöbö bla mönö yadlö aku nugum, nagö ölɨsö wöl aku, nagö nugulaŋö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Aliö rɨmɨn, Jisas yadöŋa, “Aku mönö mɨdöl. Acö na adöx yöd röul adö kau sö mɨd aku, ap iñ nuŋwa yuöl bla magalɨg il alɨg röd aböna. ");
INSERT INTO tmd_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nöbö piaku ñɨŋ mämäg we. Nöbö mämäg we i, nöbö mämäg we i yölɨŋ pön diön aku, mösör ulöm möla pɨn bɨcöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Jisas aliö rɨmɨdmɨn, Pita yadöŋa, “Mönö aku mönö höd röx yadlö il aku anɨŋ yad nölaŋ nuguŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","17","Aliö rɨmɨn, Jisas yadöŋa, “Ñɨŋ nugwölöi aku, ñɨŋ kwo algör nugwölöiŋ ä? Nugwi! Ap agap bɨlɨm nɨmöi bla, God nugumɨn, mönö mɨdöl. Aku hör nɨmön, höb alɨg yax aböia. ");
INSERT INTO tmd_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Höbwab yuö ñɨŋ bö rɨb gwogwo yöxöi akwör rɨmɨn, pɨxa alɨg mɨdöia. ");
INSERT INTO tmd_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Rɨb ñɨŋa keir yöxön, rɨb gwogwo yöxöi rɨb mag aku, nöbö mö pɨl pal nɨgön, mö kib nöbö kib rön, ap bla kib pön, mönö diba yajöñ wop aku inakmönö hörön, nöbö mö bli ñɨŋ yad höimöuön, röia. ");
INSERT INTO tmd_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Alöi aku makwam, God nugumɨn pɨxa alɨg mɨdöia; makwam ap nɨmɨba, imaga röbö äbäd ri abölön, amɨn ap pɨ nɨmöi aku, God nugum pɨx pɨlölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisas mögörɨb Genesaret aku röböxön, mögörɨb dib taun diba mös Taia Saidon mibɨl piaku duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Duön mögörɨb Kenan piaku mɨdmɨn, mögörɨb piaku mö i hö Jisas nugwo yadöŋa, “Nöbö Dib, Depid Ha nuŋwa, nɨ ögwö yöxö! Halöu na aku ragwo ha wöl gɨ mɨdɨm, mɨd ri abölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Aliö rɨmɨn, Jisas paiŋö yadölöŋ. Jɨ nöbö nuŋ bla hön, Jisas nugwo ususör rön yadmä, “Mö kɨ anɨŋ mai hö gɨrön, mönö ua nɨgmɨda. Nugwo yad abɨŋ duaŋ!” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Aliö rɨmɨn, Jisas yadöŋa, “God nɨ yad abmɨn höm aku, Juda nöbö mö God nugwo röböxöi bla, ñɨgör pɨnö, rön, hömö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Aliö rɨmɨn, Juda mö yöi aku hön, Jisas mɨdöŋ il yöra höxmax yuön yadöŋa, “Nöbö Dib, nɨ rɨ nölö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Aliö rɨmɨn, Jisas yadöŋa, “Ap maga halöu ha an nölɨb aku, pödpöd raŋ pɨ wöñö bla abnɨŋö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Jisas aliö rɨmɨn, mö aku paiŋö yadöŋa, “Nöbö Dib, mi yadlö aku, jɨ nöbö dib bla ap nɨmɨŋ, rɨb rɨb bla äbäñ mo pɨnaŋ, wöñö bla aipam nɨmöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Aliö rɨmɨn, Jisas yadöŋa, “Mö mɨg, nɨ nugw pɨ gö nɨglö makwam, yad nugulö ap aku cɨnö,” röŋa. Aliö rɨmɨn nugugɨrön, ragwo ha wop mɨd akwör halöua röböxön röu dumɨn, nugwo kömö nɨgmɨn wä röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas höuöil Ban Yuö Galili rɨb pö ir kwo wöluön, höña pisö rɨp wölu pɨd sö römɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Römɨd gɨ mɨdɨm nugugɨrön, nöbö mö mɨg mɨŋa, nöbö mö yödpɨlö gwogwo röŋ bla, mämäg we wölöŋ bla, iŋ wajmag kakabail um nɨgöŋ bla, albeña höuöilmɨn mönö pɨmɨdölim bla, ap agap apɨm röŋ bla magalɨg pön hön, Jisas mɨdöŋ yödpɨlö il yöra nɨgɨm nugugɨrön, ñɨgö rɨmɨn kömö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Akuyöbö almɨn, nöbö mö piaku nugwön, aiö rön yadmä, “An Isrel nöbö mö God an aku mɨ God wä mɨdöm. Nöbö mö albeñ höbkalöŋ bla rɨmɨn, mönö pöia; nöbö mö iŋ wajmag kakabail um nɨgöŋ bla rɨmɨn, wä ra; nöbö mö yödpɨlö gwogwo röŋ bla rɨmɨn, yön ri abmɨdöia; nöbö mö mämäg we wölöŋ bla rɨmɨn, mämäg ix nugumɨdöiŋö,” rön, ib nuŋwa yadmɨn bɨl sö duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisas nöbö nuŋwa akuyöbö möl sö ñɨgö wö rɨ yadɨm, hömɨdmɨn, yadöŋa, “Nöbö mö pik nɨ ñɨgö ögwö yöxmɨdla. Wop mös paŋ nɨ pɨsaŋ mɨdöia, jɨ ñɨŋ ap mag mɨdöl. Ñɨgö hör yad abmön, duön ödöi um yöra mämäg mömöinö palaŋ, göur du pɨn bɨrɨb maga mɨdö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jisas aliö rɨmɨn, nöbö nuŋ bla yadmä, “Mögörɨb nöbö mö mɨga mɨdölöi mibɨl kɨyöbö, ap maga pikai yöbö hölu nugwön pön hön, nöbö mö mɨg kɨyöbö nölɨŋ nɨmöñɨŋö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Aliö rɨmɨn, Jisas yadöŋa, “Bred mag ñɨŋa pödpödiö mɨd?” röŋa. Aliö rɨmɨn, yadmä, “Bred akuyöbö mɨj sö dölöm ulul bli alɨg mɨdö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Aliö rɨmɨn, Jisas nöbö mö akuyöbö ñɨgö yadmɨn, mɨgrö aku römɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ñɨŋ almɨdɨm nugugɨrön, nuŋ bred mag akuyöbö mɨj sö pön, dölöm ulul bla aipam pön, God nugwo ri ablaŋö, rön, pɨ gɨlɨxön, nöbö nuŋ bla nölmɨn, ñɨŋ piöŋö pön nuöm nɨgön nöbö mö nölmä. ");
INSERT INTO tmd_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Akuyöbö alön nuöm nɨg nölɨm, nɨmmɨdɨm, nɨmmɨdɨm, wöta bɨrɨm, nɨm pörɨb maga mɨdölöŋ. Rɨb rɨb röböxim blaku, Jisas nöbö nuŋ bla yogw akuyöbö mɨj sö pɨ piöxmɨn, aŋadö aja wölöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nöbö mö ap nɨmim piaku, mö piaku yöi, halöu ha ulul bla yöi, nöbö akwör po tausan duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Makwam aliö ap nɨmön, Jisas nöbö mö piaku ñɨgö yad abön, nuŋ röbö alebö pön, mögörɨb Magadan ir kwo duön, mögörɨb mibɨl piaku duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Perisi nöbö bli, Sadiusi nöbö bli, Jisas agamö rɨmɨdaŋ nugwön nugwo yad höimöunɨŋö, rön, hön nugwo yadmä, “Nagö nɨ Mesaia mɨdlö, rɨlö aku, ap rölɨbä i raŋ an nugwön, God adöx yöd röul adö kau sebö ölɨsö nuŋwa nölmɨn rɨmɨdlaŋö, rön nugunɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yad nugumɨn, Jisas yadöŋa, “Naiö rödɨp duön, adöx yöd sö höbä höbä höraŋ nugugɨrön yajöña, ‘Ruö röx ri abönɨŋö,’ cöña. ");
INSERT INTO tmd_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Pɨxmag alɨg naiö wölɨba raŋ rön höbä höbä hörön mɨjöi wobön raŋ nugugɨrön yajöña, ‘Ruö pɨlɨba rɨmɨdö,’ cöña. Akuyöbö alön nugw ri abön röi aku, jɨ nɨ wopik ap agap apɨm rɨmɨdɨl kɨ, ñɨŋ nugwöi aku, jɨ ila nugwölöi. ");
INSERT INTO tmd_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ñɨŋ nöbö mö weik mɨdöi bla, mɨd ri abölöi, God nugwo rɨbyöx nugwölöi. Ap rölɨbä akuyöbö i raŋ nuguŋö, rɨmɨdöi aku, nɨ ap i rɨmön nugweñ. Nöbö Jona rɨg röŋ mag akwör raŋ nugwöñɨŋö,” röŋa. Jisas aliö rön, ñɨgö röböxön möl i duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisas nöbö nuŋ bla pɨsaŋ röbö alebö pön, röbö bana ir kwo wöluön nugumɨn, bred bla uplöb hön rag hölim. ");
INSERT INTO tmd_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Aliö nugwön Jisas nöbö nuŋ bla ñɨgö yadöŋa, “Perisi nöbö, Sadiusi nöbö, is ñɨŋ aku nugw ri abne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jisas aliö rɨmɨn nugwön, nöbö nuŋ bla ñɨŋ keir yad nugwob nugwob rön yadmä, “An bred ragölöl makwam, aliö yadmɨdö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","9","Makwam Jisas ñɨŋ yadmɨdim aku nuŋ keir nugwön yadöŋa, “Ñɨŋ pödpöd rɨmɨn bred ragölölɨŋö, rön, nuö nuö yadmɨdöi? Ñɨgö nɨ nugw pɨ cɨcɨ nɨgölöi. Nöbö akuyöbö paip tausan mɨdim wop aku, bred mag akuyöbö mömɨd sö pön, pɨ gɨlɨx nölmön, nɨmön rɨb rɨb rɨböx rɨböxɨp rim akuyöbö yogw pödiö piöxim aja wölöŋ? ");
INSERT INTO tmd_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","“Makwam mai piöŋö, nöbö akuyöbö po tausan mɨdim wop aku, bred mag akuyöbö mɨj sö pön, pɨ gɨlɨx nölmön, nɨmön rɨb rɨb rɨböx rɨböxɨp rim akuyöbö yogw pödiö piöxim aja wölöŋ? ");
INSERT INTO tmd_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Wop aku ñɨŋ keir mɨdön bred yogw piöxim aku, jɨ weik mönö höd röx yadɨl aku nugwön, ‘Bred ap rön yadmɨdö,’ röia. Bred ap me rön yadmɨdöi. Perisi nöbö bla aipam, Sadiusi nöbö bla aipam, is ñɨŋa ñɨgö pɨb maga rö, rön yadmɨdlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jisas aliö rɨmɨn, ñɨŋ nugumä ap is bred alɨg nɨgöi aku yadölöŋ; Perisi nöbö bla aipam, Sadiusi nöbö bla aipam, mönö yad nölöi aku yöxölɨŋ, me rön, mönö höd röxön yadöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Mai Jisas taun dib Sisaria Pilipai mibɨl yöra uröpɨnön, nöbö nuŋ bla ñɨgö yad nugwön yadöŋa, “Nöbö mö akuyöbö Nöbö Ha nuŋwa agö nöböm me röi?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Jisas aliö rɨmɨn, nöbö nuŋ bla yadmä, “Bli röbö pal nölɨb nöbö Jon me röia; bli Ilaija me röia; bli Jeremaia me röia; bli God mönö yadɨb nöbö i me röiŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Aliö rɨmɨn, Jisas ñɨgö yadöŋa, “Makwam ñɨŋ keir nɨ yönɨm me rön nugwöiŋö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Jisas aliö rɨmɨn, nöbö nuŋwa Saimon Pita yadöŋa, “Nagö Mesaia aku, God Nöbö Kömö Ha nuŋwa ödöriö aku,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Aliö rɨmɨn, Jisas yadöŋa, “Jona ha nuŋwa Saimon. Mönö yadlö aku, wä yadlö. Naŋ rɨb ödöriö yöx nugulö aku, hör piaku höl; Acö na adöx yöd röul adö kau sö mɨd akwör nagö rɨbyöx nölmɨn, nagö ödöriö akwör nugulö. ");
INSERT INTO tmd_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","“Nɨ nagö yadmɨdla nagö Pita. Rɨb wä yöxlö aku, nɨ nöbö mö nɨ piaku piaku yölɨŋ pön hön, cöc na rɨg rola nɨgna. Wöröxɨb mag aku cöc na raŋ, pɨn bɨrɨb maga nɨgöl. ");
INSERT INTO tmd_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","“God mögörɨb adöx yöd röul adö kau sö kai waba naŋ nöina. Nagö mögörɨb il kɨ mɨdön, mag ada kai nugwön ödöriö mɨdölö, rön, wöhö rɨmɨjɨnö aku, God adöx yöd röul adö kau sö algör wöhö cöna. Makwam mag ada kai nugwön ödöriö akwör mɨdö, rön, yöwö rɨmɨjɨnö aku, God adöx yöd röul adö kau sö algör yöwö cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jisas aliö rön nöbö nuŋ bla ñɨgö yadöŋa, “Nöbö mö akuyöbö ñɨgö, nɨ Mesaia, me rön, yadmɨjeñɨŋe,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Wop mibɨl yöraku, Jisas nöbö nuŋ bla ñɨgö, nöbö piaku nɨ al aliö aiöñɨŋö, rön, wöxnö yadön yadöŋa, “Nɨ mai Jerusalem dumön, mönö pɨ nuöm nɨgɨb nöbö bla nɨgön, God ap höjöpal ur nölɨb nöbö dib bla nɨgön, God lo mönö yad nölɨb nöbö bla nɨgön, nɨ ölɨŋ höb pɨ nölön pɨl pal nɨgöña. Makwam wop mös mɨdön, wop paŋ aku höbkal öbinö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Jisas aliö rɨmɨn, Pita, Jisas nugwo pön du rɨb yörakwo duön, mɨ ususör rön yadön yadöŋa, “Nöbö Dib! Nagö akuyöbö alölaŋ! Mönö aku yad ri aböiö. God nagö nugwidɨx mɨdaŋ, akuyöbö alölaŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Aliö rɨmɨn, Jisas höuöiliö Pita nugwo yadöŋa, “Seten, nɨ röböxön duö! Nɨ pödpöd rɨmɨn wöhö rön yadmɨdlö? God rɨg rɨbyöx nugw mag akuyöbö nugwöiö; nöbö mö rɨbyöx nugwöi rɨb akwör yöx nugwön yadmɨdlanö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jisas aliö rön, nöbö nuŋ bla ñɨgö yadöŋa, “Nöbö mö kai kai nɨ adö mɨjnɨŋö, rɨmɨjöñ aku, ap mögörɨb il kɨ rɨb diba yöx nugwöi aku röböxön, mɨxɨñ ñɨŋa keir rɨb diba yöx nugwöi aku röböxön, bɨ katlö watlö waba pɨ ragpɨd nɨg ragön nɨ mai höŋ. ");
INSERT INTO tmd_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nöbö mö kai, nɨ Jisas nugw pɨmön wä renɨŋö, rön, rɨbyöx nugwön aku, kömö mɨden; makwam nöbö mö kai, nɨ Jisas nugw pön mɨdmön, nɨ agö magɨm rɨmɨjöñ aku mönö mɨdölö, cön aku, öim kömö mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","“Nöbö mö kai ap mögörɨb rol il kɨ pɨnö, rön, raŋ diön aku, rɨb dib nuŋwa paŋ adakwör diön aku, kömö öim mɨdɨb maga pen. Owa ap wä nuŋwa God nölön kömö öim mɨdɨb maga pönɨŋönö? Mɨ wöhö! ");
INSERT INTO tmd_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Mai nɨ Nöbö Ha nuŋwa, Acö mil maga ölɨsö pön, ejol bla pɨsaŋ höuöiliö hön wop aku, mönö diba nɨgön, nöbö mö agap ap bɨlɨm röi akuyöbö nugwön, ñɨgö paiŋö nöina. ");
INSERT INTO tmd_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Nɨ ñɨgö mɨ ödöriö yadmɨdla, ñɨŋ nöbö mö mɨdöi kɨyöbö, bli kömö mɨjöñ aku, Nöbö Ha nuŋwa nöbö mö pön adöx yöd röul adö kau sö nugwidɨx mɨdɨb wop aku, Nöbö Ha nuŋwa haŋ nugugɨrön, nugwo nugwöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Jisas mönö aku yadön, wop akuyöbö iŋösu bö mɨdön, Pita, Jems, Jems pɨgnɨŋ Jon yama yölɨŋön, önöŋ ajmag pɨd sö wöluön, hör mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Alön mɨdɨm nugugɨrön, Jisas mɨxɨñ nuŋ aku keiryöbö wöxnö nɨgön, haŋaj mämäg yuö naiö röxg nɨgmɨn, wölɨj nuŋwa mil abɨm mil pör gɨ mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Almɨn nugugɨrön, ñɨŋ nugumɨn, God mönö yadɨb nöbö Mosɨs Ilaija yöŋö höd wöröxim hogw aku ñɨŋ hön Jisas pɨsaŋ mönö nɨgmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ñɨŋ aku nugwön, Pita nuŋ Jisas yadöŋa, “Nöbö Dib. An yörɨk mɨdöl aku, wä rɨm mɨdöla. Nagö yöwö ran, ram bötö mös paŋ urön, nagö i, Mosɨs i, Ilaija i,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita aliö rɨmɨn nugugɨrön, mɨjöi lei wab i hön, ñɨgö magalɨg pöröb yuö aböŋa. Pöröb yuö abmɨn nugugɨrön, mönö i mɨjöi yuö sö pik yadöŋa, “Ha madmag yöbö nɨ kɨ, nɨ mɨ wä ra. Agö mönö bɨlɨm yajön aku nugw pɨne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mönö aku aliö höm nugwön, Jisas nöbö nuŋ bla rɨb mɨga yöxön, ipöxön, du mɨgrö pɨn bɨrön, haŋaj mämäg yuö ñɨŋ ada mɨgrö bö nɨg cɨrmä. ");
INSERT INTO tmd_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jisas hön ñɨgö pɨ nugwön yadöŋa, “Ipöxmɨjeñ. Öbine!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Aliö rɨmɨn, öbɨlön nugumɨn, Jisas nuŋwör mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Makwam höña pibö pɨn du gɨrön, Jisas ñɨgö yadöŋa, “Wopik agö magɨm rɨmɨdmɨn nugwöi aku, nöbö mö akuyöbö yad nölmɨjeñ. Mai Nöbö Ha nuŋwa wöröxön öbiön wop aku, nöbö mö akuyöbö ñɨgö yad nöiöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jisas aliö rɨmɨn, nugwo yadmä, “Lo mönö yad nölɨb nöbö bla pödpöd rɨmɨn yadöi, ‘Ilaija höd hömɨdaŋ, mai Mesaia mögörɨb il kɨ hönɨŋö,’ röiŋö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Aliö rɨmɨn, Jisas yadöŋa, “Mi yadöia. Mönö aku mɨda: ‘Ilaija höd hön, ñɨgö yad nöl ri abmɨdaŋ, mai Mesaia höna.’ ");
INSERT INTO tmd_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Makwam nugwi. Ilaija mödö höŋ aku, jɨ höm nugwo nugwölim. Rɨb ñɨŋa keir yöx nugwim mag akwör nugwo rɨ gwogwam rɨmä. Nöbö Ha nuŋ aku nugwo algör cöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jisas aliö rɨmɨn, nöbö nuŋ bla nugumɨn, Jisas Ilaija iba urön yadöŋ aku, jɨ röbö pal nölɨb nöbö Jon nugwör yadöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Makwam ñɨŋ up bö pɨn duön nugumɨn, nöbö mö mɨg mɨŋa mɨdmä. Nöbö i, nöbö mö mɨdim mibɨl yöraku hön, Jisas mɨdöŋ yöra höxmax yuön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Nöbö Dib. Ha na ögwö yöxö. Nuŋ u pɨlɨm mɨd ri abön röl. Nuŋ öim duön, rɨn yuö yönmɨd mibɨl akuyöbö aipam, röbö yuö piaku aipam alɨp du pɨn bɨrmɨda. ");
INSERT INTO tmd_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nɨ nöbö nagö bla mɨdöi piaku pön dumön, ñɨŋ pɨsö pɨl öliöxön röböxöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Aliö rɨmɨn, Jisas yadöŋa, “Ñɨŋ nöbö mö weik wop kɨ mɨdöi bla, God nugwo rɨbyöx nugwön nugw pölöi; God rɨg yadmɨd mag akuyöbö rölöi. Wop kai ñɨŋ nugw pön keir rɨmɨjöñ? Ha aku pön nɨ mɨdɨl yörɨk pön höi,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jisas aliö rɨmɨn, ha aku pön hömɨdɨm, Jisas ragwo ha nugwo yuö wölöŋ aku yadmɨn, röpɨn dumɨn, wop akwör wä röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Almɨn, Jisas nöbö nuŋ bla nuŋ mɨdöŋ yöra hön, ñɨŋ ñɨŋör mɨdön, nugwo yad nugwön yadmä, “Pödpöd rɨm, ragwo ha nugwo yuö wölöŋ aku, an yad ab wöhö nugwön röböxöl?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Aliö rɨmɨn, Jisas yadöŋa, “Nugw pɨb mag ñɨŋ aku met wa aku döŋö, yad ab wöhö nugwön röböxöia. Makwam nugwi! Nugw pɨb mag ñɨŋ aku bɨ masted iñ mag ulmɨdö rɨg mɨd aliö akuyöbö mɨjön aku, agap apɨm yadmɨjöñ aku, rɨg yajöñ mag akwör cöna. Önöŋ ajmag kɨ, ‘Hör pikwo duö,’ rɨmɨjöñ aku, diöna. ");
INSERT INTO tmd_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Makwam ragwo ha yuö wöl aku, hör yad abɨb maga nɨgöl. Ap maga mödön, God höjöpal gör mɨjöñ aku, yad aböñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jisas nöbö nuŋ bla pɨsaŋ mögörɨb Galili hön mögum rön ñɨgö yadöŋa, “Womiöx mɨda, Nöbö Ha nuŋwa nugwo pön du nöbö mö bli nölɨŋ, ");
INSERT INTO tmd_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nugwo aŋadö pɨl pal nɨg gɨŋ wöröxön aku, jɨ wop mös mɨdön, wop paŋ aku höbkal öbiönɨŋö,” röŋa. Jisas aliö rɨmɨn, nöbö nuŋ bla nugwo ögwö yöxön rɨb mɨga yöxmä. ");
INSERT INTO tmd_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Makwam mai, Jisas nöbö nuŋ bla pɨsaŋ taun ulmɨdö Kapaneam uröpɨnön, nöbö God höjöpalɨb rama takis pɨb bla ñɨŋ hön Pita nugwo yadmä, “Mönö yad nölɨb nöbö ñɨŋ aku takis nöla aipam?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Aliö rɨmɨn, Pita yadöŋa, “Yöwö, nuŋ takis nöla aipam,” me röŋa. Pita aliö rön, ram möl yuadö dumɨn nugugɨrön, Jisas nuŋ höd yadön Pita nugwo yad nugwön yadöŋa, “Rɨb nagö pödiö yöx nugulö? Gapman nöbö dib bla takis rɨga pikai yöbö pöi? Nöbö mö ñɨŋ keir bla akuyöbö pöiŋönö nöbö mö pad piakuyöbö pöi?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Jisas aliö rɨmɨn, Pita yadöŋa, “Nöbö mö pad bla akuyöbö pöiŋö,” röŋa. Aliö rɨmɨn, Jisas yadöŋa, “Mɨ, nöbö ñɨŋ keir bla akuyöbö takis nölölöi. ");
INSERT INTO tmd_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Makwam an nölöinɨŋ aku, ñɨŋ ölɨsö wölɨb maga ra. Makwam, nagö ban yuö kwo duön, nag huk abön, dölöm höd pɨnö aku, ajmöla pɨ kalön nugwaŋ, rɨg mag paŋyöbö mei ajmöla mɨjöna. Pɨ rag hön takis an nöbö hogwa aku nölö,” röŋa. Jisas aliö rɨmɨn, Pita duön rɨg yadöŋ mag akwör röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jisas nöbö nuŋ bla hön nugwo yad nugumä, “Nöbö mö God pön, mögörɨb adöx yöd röul adö kau sö nugwidɨx mɨdɨb bla, yönɨm nöbö mö diba mɨjönɨŋö?” rön yadmä. ");
INSERT INTO tmd_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Aliö rɨmɨdmɨn, Jisas ha ulmɨdö i wö rɨm, höm, pön mämäg il rol ñɨgö yöra öbɨl nölön, ");
INSERT INTO tmd_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","yadöŋa, “Nɨ ñɨgö mɨ ödöriö yadmɨdla, ñɨŋ halöu ha ulul bla rɨg rɨbyöx nugwöi mag aliö akwör yöx nugweñ aku, God mögörɨb adöx yöd röul adö kau sö dueñ. ");
INSERT INTO tmd_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Makwam, nöbö mö an nöbö mö diba mɨdölölɨŋö, rön, ha ulmɨdö kɨyöbö röxg mɨjöñ aku mɨ, God nöbö mö nuŋwa pön nugwidɨx mɨjön mibɨl yöra, nöbö mö diba röxg mɨjöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Makwam nöbö mö nɨ nugw pön, halöu ha ulmɨdö kɨyöbö aliö pɨ ösös ri aböñ aku, ñɨgör wöhö, nɨ aipam pɨ ösös ri aböña. ");
INSERT INTO tmd_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Makwam nöbö mö bli hön, halöu ha nɨ rɨbyöx nugw pöi akuyöbö, ñɨgö ap kib mag gwogwo mag aku rɨ yabuŋ, ñɨŋ nɨ uplöbön ap kib mag gwogwo cöña. Nöbö mö aliö alɨba cöñ aku, höd rɨg dib i göliöda nɨgiö nag pɨ nɨg gö nɨgön, pön du ban yuö dib aböyɨx aku waiö. Kömö mɨdön, aliö mag gwogwo ödöriö rɨmɨjöñ aku, ölɨŋ höb diba pöña. ");
INSERT INTO tmd_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Nöbö mö mögörɨb il kɨ mɨdöi akuyöbö mɨ ömörö diba pöña. Mag gwogwo rol aku rön, nöbö mö bli ñɨgö rɨba nölɨŋ, mag aku rön i pɨn bɨcöñ aku, mɨ rɨ gwogwam cöna. Mag rol aku höd rɨmɨdöia, weik röia, mai algör ör rɨmɨjöña. Aliö cön aku, jɨ nöbö mö mag aku rɨ yabuöñ piaku, mɨ ölɨŋ höb keiryöbö ödöriö pɨmɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Iŋ wajmag ñɨŋ aku nugwöña, ap kib mag gwogwo rɨba rɨmɨjön aku, iŋ wajmag aku römaxdör aböña. Akuyöbö alöñ aku, ap kib mag gwogwo rɨb ada röböxön, God mögörɨba duön öim mɨjöña. Nöi aku, iŋ wajmag mös alɨg mɨjön aku mɨd ri abeñɨm, ap kib mag gwogwo rɨb adakwör rɨp dumɨdön, mögörɨb bɨ yuö keir öim yönmɨd möl bö diöña. ");
INSERT INTO tmd_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","“Makwam mämäg ñɨŋ aku nugwöña, ap kib mag gwogwo rɨba rɨmɨjön aku, mämäg adaku pɨn gul rɨ aböña. Akuyöbö alöñ aku, ap kib mag gwogwo rɨb adaku röböxön, God mögörɨba duön öim mɨjöña. Nöi aku, mämäg mös alɨg mɨjön, aku mɨd ri abeñɨm, ap kib mag gwogwo rɨb adaku rɨp dumɨdön, mögörɨb bɨ yuö keir öim yönmɨd möl bö diöña. ");
INSERT INTO tmd_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ñɨŋ nugw ri aböña, halöu ha ulul bla hör ap bɨlɨm, me rön, rɨb aliö yöx nugumɨjeñ. Nɨ ñɨgö yadmɨdla, halöu ha ulul piaku ejol ñɨŋ bla, Acö na mämäg il rol nuŋ aku mögörɨb adöx yöd röul adö kau sö mɨdöia. ");
INSERT INTO tmd_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","“Nöbö Ha nuŋ aku, nöbö mö yöm röi akuyöbö, ñɨgö pɨba höŋa. ");
INSERT INTO tmd_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Nöbö i hön sipsip nuŋwa padokwo padök mös mös höuöiliö hö wölu amñaxɨb sö (100) mɨjöna. Makwam paŋyöbö i yöm rɨmɨjön aku, nuŋ pödpöd cön? Sipsip nuŋ bli ñɨŋ röböxaŋ, ap panö panö nɨmmɨdɨŋ nugugɨrön, yöm cön sipsip nuŋ aku hölup diöna. ");
INSERT INTO tmd_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Du hölumɨd hölumɨd nugwön aku pön, mɨ ödöriö wahax pöna. Ñɨgö mi yadmɨdla, hön sipsip nuŋwa bla magalɨg wahax pa, jɨ hön sipsip nuŋ i yöm raŋ, hölu nugup dumɨd dumɨd pön aku, sipsip akwör mɨ ödöriö wahax pöna. ");
INSERT INTO tmd_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Makwam mag aliö akuyöbö, Acö ñɨŋa adöx yöd röul adö kau sö mɨd aku, halöu ha ulul nuŋ i yöm rölaŋ, me rön, nugu gör mɨda. ");
INSERT INTO tmd_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nöbö mö haul mölöu cɨnö piaku, nöbö i nagö rɨ gwogwam rɨmɨjön aku, naŋ piöŋö duön, nugwo pɨsaŋ tar mɨdön, nagö agö magɨm röŋ aku wöxnö yadö. Aliö alaŋ, nuŋ yöxön aku, haul nölöu nöbö naŋ bla ödöriö mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Makwam naŋ akuyöbö alaŋ, nuŋ nugwen aku, naŋ duön, haul mölöu nöbö mö mös yölɨŋ pön haŋ, ñɨŋ nugugu mɨdɨŋ nugugɨrön, naŋ nöbö aku pɨsaŋ mönö nɨgö. ");
INSERT INTO tmd_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Makwam naŋ akuyöbö alaŋ, nuŋ mönö yöxen aku, nöbö mö cöc höi akuyöbö magalɨg nugugu mɨdɨŋ nugugɨrön, mönö aku yad nölö. Naŋ akuyöbö alaŋ, nugw pen aku, nugwo röböxö. Nöbö aku nöbö mö God Mönö nugwölön, takis pɨb nöbö aku nuŋ mag akuyöbö almɨdö, rön, nugwo röböxö. ");
INSERT INTO tmd_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Makwam, nɨ ñɨgö mi yadmɨdla, mögörɨb rol il kɨ wöhö rɨmɨjöñ aku, God nuŋ adöx yöd röul adö kau sö mɨdön, algör ör wöhö cöna; makwam yöwö rɨmɨjöñ aku, nuŋ kwo algör yöwö cöna. ");
INSERT INTO tmd_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Nɨ ñɨgö yadmɨdla, nöbö mö mös mögörɨb il kɨ mɨdön, mönö yad ödör paŋyöbö i nɨgön, Acö na adöx yöd röul adö kau sö mɨd aku nugwo yad nugumɨjöñ aku, rɨg yad nugwöñ mag akwör cöna. ");
INSERT INTO tmd_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Makwam nöbö mö mös mönö mös paŋɨm, nɨ rɨbyöx nugwön, hön mögum rɨmɨjöñ aku, nɨ ñɨgö mibɨl yöraku mɨjɨnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita Jisas mɨdöŋ il yöra hön yadöŋa, “Nöbö Dib. Nöböhöd i nɨ rɨ gwogwam rɨmɨjöñ aku, wop pödiö aliö rɨ gwogwam rɨmɨdaŋ, nɨ nugwön röböxɨn? Wop akuyöbö mɨj sö mönö ä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Pita aliö rɨmɨn, Jisas yadöŋa, “Wop akuyöbö mɨj sö wöhö; nagö nöbö aku nagö rɨ gwogwam cön aku nugwön röböxnöb cɨnö aku, padokwo padök padokwo padök akuyöbö mɨj sö raŋ nugwön röböxö. ");
INSERT INTO tmd_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","God nöbö mö pön mögörɨb adöx yöd röul adö kau sö nugwidɨx mɨjön aku, haiwo aliö kɨyöbö mɨda. Kiŋ i nuŋ mabö rɨ nölɨb nöbö nuŋ bli ñɨgö rɨg bli nölön, ‘Mai paiŋö nölɨŋ,’ me cöna. Mai nuŋ rɨbyöx nugwön yajöna, ‘Ñɨŋ ap rɨb nɨ bla paiŋö nölɨŋ,’ me cöna. ");
INSERT INTO tmd_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Rɨba mɨd aku paiŋö nölɨŋ, me rön, nöbö i nuŋ rɨg rɨp padokwo padök mɨga ap rɨb nuŋwa diba mɨjön nöbö aku wö raŋ, pön höña. ");
INSERT INTO tmd_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Makwam nöbö mɨd aku paiŋö nuŋwa mɨ dib mɨjön makwam, paiŋö nölɨb maga mɨden. Aliö alaŋ, nöbö dib aku nugwön, nöbö mabö rɨb nuŋ bli yajöna, ‘Nuŋ al mag akuyöbö, nugwo pön, mönɨŋ halöu ha ap nuŋ agap apɨm mɨd piaku magalɨg pön du sɨm rɨ pöñ rɨg aku rag hö nɨ nöine,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Aliö raŋ, nöbö mɨd aku höxmax yuön, kiŋ aku nugwo yad gögö rön yajöna, ‘Nagö nɨ ögwö yöxön pöx mɨdaŋ, ap rɨb nagö piaku magalɨg rɨba wöjɨnö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Yadaŋ, kiŋ aku nugwo uliöxön, ap rɨb na aku röböx duö, cöna. ");
INSERT INTO tmd_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Kiŋa aliö rön ap rɨb nuŋwa röböxaŋ nugugɨrön, mabö rɨ nölɨb nöbö aku nuŋ piöŋö duön nugwaŋ, nöbö nuŋ pɨsaŋ mabö rɨmɨd nöbö i mɨjöna. Nugwo nugwön, göliöda pɨ cɨcɨ nɨgön yajöna, ‘Nagö rɨg rɨp paŋyöbö i nölɨm aku rɨba wödö!’ cöna. ");
INSERT INTO tmd_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Aliö raŋ, nöbö nuŋ pɨsaŋ mabö rɨmɨjön aku höxmax yuön yad gögö rön yajöna, ‘Nagö nɨ ögwö yöxön pöx mɨdaŋ, ap rɨb nagö piaku rɨba wöjɨnö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Yadaŋ, nöbö aku mönö nugwo aku nugwen; nuŋ yajöna, ‘Nagö pön du nag nɨgmön, ap rɨb aku rɨba wöjɨnö akwör yoŋ rɨŋadö dinaŋö,’ rön, nugwo pön du nag nɨgöna. ");
INSERT INTO tmd_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Alaŋ, nöbö nuŋ pɨsaŋ mabö rɨmɨdöi bla ñɨgö höbwaba gwogwo raŋ, duön kiŋ aku nugwo mönö piaku magalɨg yad nöiöña. ");
INSERT INTO tmd_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Yad nölɨŋ, kiŋ aku, nöbö nuŋ aku wö raŋ höŋ yajöna, ‘Nagö mɨ ödöriö nöbö gwogwo. Nagö nɨ im nölman, nɨ nagö uliöxön, ap rɨb nɨ nagö mɨd aku röböxla. ");
INSERT INTO tmd_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Naŋ piöŋö pödpöd rɨmɨn, nöbö nagö pɨsaŋ mabö rɨlö aku nugwo algör uliöxön röböxöiadö?’ cöna. ");
INSERT INTO tmd_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nöbö aku nöbö nuŋ pɨsaŋ mabö rɨmɨd aku nugwo ögwö yöxen makwam, kiŋa ölɨsö rödön, mabö rɨ nölɨb nöbö nuŋ aku nugwo pön du nag nɨgɨb yöra nugwidib nöbö bla nölön yajöna, ‘Nugwo nag nɨgaŋ, ölɨŋ pɨlaŋ nugu gɨr mɨdön, ap rɨb na akuyöbö magalɨg rɨba wöd pörön röu duaŋ,’ me cöna. ");
INSERT INTO tmd_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ñɨŋ nöbö mö haul mölöu nöbö ñɨŋ akuyöbö mag akuyöbö almɨjeñ aku, Acö na adöx yöd röul adö kau sö mɨd aku, ñɨgö kwo paŋ mag akwör cöna. Makwam, nöbö mö haul mölöu nöbö ñɨŋ bla ñɨgö rɨ gwogwam rɨmɨjöñ aku, ñɨgö uliöxön, madmag nɨgön kwönö, röböxnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisas mönö aku yad pörön, mögörɨb Galili röböxön, mögörɨb Judia, röbö Jodan yuö pö kwo duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Dumɨdmɨn, nöbö mö mɨg mɨŋa mai umɨn nugugɨrön, nöbö mö ap röŋ bla Jisas rɨmɨn kömö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Makwam Perisi nöbö bla, Jisas nugwo yad nugwɨŋ, mönö gwogwo bli yajönɨŋönö, rön, hön yad nugumä, “God Mosɨs nugwo yad nölöŋ lo mönö aku, mö i ap ulmɨdö i rɨ gwogwam cön aku, nöbönɨŋa nugwo yad abnöb, yad abönɨŋönö wöhö? Nagö agö rɨbɨm yöx nugulö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Aliö rɨmɨn, Jisas yadöŋa, “God Mönö kai kɨtim aku ñɨŋ mämäg nɨg nugwölöi ä? Mögörɨb maduar rɨ nɨgöŋ wop aku, nöbö i, mö i, rɨ nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","God rɨg yadöŋ, ‘Mag akuyöbö, nöbö i nuö nuöm pɨsaŋ mɨdön, mö pön, nuö nuöm röböxön, ñɨŋ mönöbö hogwa nɨgiö nɨgön hölɨmön mɨdɨŋ, mɨxɨñ paŋyöbö iör mɨjönɨŋö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Aku mɨ, God yadaŋ mɨxɨñ ñɨŋa mös mɨden wöhö; wopik nɨgiö nɨgɨŋ mɨxɨñ paŋyöbö i nɨgön aku, nöbö i hön, ñɨgö yadön pɨ wabröt hörɨrör nɨgen, wöhö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jisas aliö rɨmɨn, Perisi nöbö bla nugwo yadmä, “Makwam agapnöb Mosɨs mönö i kai kɨtön yadöŋa, ‘Mö yad abnöb, mö kɨ aŋadö röböxmɨdla, rön kwönö, köp mei kai kɨt nölön yad abnö,’ rö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Aliö rɨmɨdmɨn, Jisas yadöŋa, “Ñɨŋ nöbö mö mönö nugw pölöi makwam, Mosɨs aliö yadöŋa. Makwam God nöbö mö maduar rɨ nɨgöŋ wop aku, aliö almɨdölöi. ");
INSERT INTO tmd_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Makwam nɨ ñɨgö yadmɨdla, nöbö kai, mönɨŋ nuŋwa nöbö i pɨsaŋ yönen wöhö, hör ör röd abön, mö yoŋyöbö pön aku, mö kib pöna nugwön God nugwaŋ mɨ gwogwo cöna; nuŋ mö kib pɨb nöbö aku,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jisas aliö rɨmɨn, nöbö nuŋ bla yadmä, “Nöbö piaku mö ñɨŋa hör röd abeñɨŋö, rɨlö aku, ha nöbö mɨdön mö peñ aku waiar,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Aliö rɨmɨdmɨn, Jisas yadöŋa, “Nöbö magalɨg hör mɨdɨbä maga mɨdöl. God nöbö hör mɨdɨŋ, me rön, yad nɨgöŋ bla akwör, hör mɨdɨbä maga ra. ");
INSERT INTO tmd_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nöbö bli, ñɨŋ mɨgɨn lɨpia mɨdölɨm yöx pön höi bla, mö pölöi. Nöbö bli, nöbö bli mɨgɨn lɨpia pön röi piaku, mö pölöi. Makwam nöbö bli, God nöbö mö pön adöx yöd röul adö kau sö nugwidɨx mɨdɨb mabö aku rɨŋö, rön, mö pölöi. Ñɨŋ ha nöbö mɨjnɨŋö, rön, ha nöbö mɨjöñ aku waiar,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nöbö mö piaku, “Jisas imag nuŋwa halöu ha an bla yöcmac rol sö nɨgön, God höjöpal röb nölaŋ,” me rön, pön hömɨdɨm, jɨ nöbö nuŋ bla ñɨŋ riö jɨ nugugu mɨd yadyöxmä. ");
INSERT INTO tmd_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Almɨdɨm, Jisas nuŋ halöu ha piaku wö rɨm hömɨdmɨn nugugɨrön, nöbö nuŋ bla yadöŋa, “Pödpöd rɨmɨn ñɨgö aliö yadyöxmɨdöi? Halöu ha ulul piaku röböxɨŋ nɨ höŋ. God nöbö mö pön adöx yöd röul adö kau sö nugwidɨx mɨdɨb aku, halöu ha ulul aliö mɨdö bla akuyöbö,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jisas aliö rön, imag iŋsö nuŋwa halöu ha ulul yöcmac rol sö nɨgön, mögörɨb adöi duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nöbö i Jisas mɨdöŋ yöra hön yadöŋa, “Mönö yad nölɨb nöbö. Nɨ agap ap waiöm rön, öim mɨdɨb maga pɨn?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Aliö rɨmɨn, Jisas yadöŋa, “Nɨ pödpöd rɨmɨn, ap waiö mɨkai, me rön, yad nugumɨdlö? God paŋyöbö akwör Nöbö waiö. Makwam naŋ öim öim mɨjɨnöb, rön kwönö, lo mönö yadön kai kɨtim bla nugwön rɨg yad mag akwör rane,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Jisas aliö rɨmɨn, yadöŋa, “Lo ada kai aliö yadmɨdlö?” röŋa. Aliö rɨmɨn, Jisas yadöŋa, “Nöbö mö pɨl pal nɨgmɨjɨnö; nöbö mö kib mag yönmɨjɨnö; ap kib pɨmɨjɨnö; mönö diba yajöñ aku, inakmönö hörmɨjɨnö; ");
INSERT INTO tmd_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","nauö nam yöŋö rɨg yajöñ mönö akwör yöxön mai duö; naŋ naŋ keir madmag rɨg nɨglö mag akuyöbö, nöbö mö hör akwebö algör madmag nɨgane,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jisas aliö rɨmɨn, ha nöbö aku yadöŋa, “Lo mönö piaku magalɨg nugw pörla. Makwam nɨ agap ap waiöm rön, kömö öim mɨdɨb maga pɨnö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Aliö rɨmɨn, Jisas yadöŋa, “Mɨd ri abnö, rön kwönö, ap nagö blaku magalɨg sɨm rön, rɨg pön, lɨblɨb rɨ nöbö mö mɨdö bla nölö. Naŋ almɨjɨnö aku mɨ, mɨd ri abɨb rɨb mag nagö aku mɨjön God mögörɨb adöx yöd röul adö kau sö. Makwam nɨ rɨg yadmɨdɨl mag akuyöbö rön, han nɨ pɨsaŋ yönmɨdɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Jisas aliö rɨmɨn, ha nöbö aku ap nuŋ mɨga mɨdöŋ aku, mönö aku nugwön, rɨb mɨga yöx nugu gɨrön duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Makwam nuŋ aliö dumɨn nugugɨrön, Jisas nöbö nuŋ bla ñɨgö yadöŋa, “Nɨ ñɨgö mɨ ödöriö yadmɨdla, nöbö mö rɨg ap ñɨŋ mɨga mɨjön akuyöbö, God nugwo mɨŋi rɨ öliöxön rɨbyöx nugw pɨŋ, nuŋ ñɨgö pön adöx yöd röul adö kau sö nugwidɨx mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Hön kamel bla, kai mauöla nag aböi möl aku dinöb diöña; jɨ nöbö mö ap mɨga mɨd piaku, God nugwo mɨŋi rɨ öliöxön rɨbyöx nugw pɨŋ, ñɨgö pön nugwidɨx mɨjönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jisas nöbö nuŋ bla mönö aku nugwön, rɨb diba yöxön yadmä, “Makwam nöbö waiö aku, God pön adöx yöd röul adö kau sö pön duenɨŋö, rɨlö aku, nöbö mö kaiyöbö pön diön?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Aliö rɨmɨdmɨn, Jisas ñɨgö nugu gɨrön yadöŋa, “Nöbö mö ñɨŋ ñɨŋ keir rɨbä maga nɨgöl. God nuŋwör makwam, agap apɨm cɨnöb, cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jisas aliö rɨmɨdmɨn, Pita yadöŋa, “Mɨ! An ap an bla magalɨg röböxön, naŋ pɨsaŋ ör cɨrɨpön yönöl aku, an paiŋö agapɨm pɨnɨŋö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Aliö rɨmɨn, Jisas yadöŋa, “Nɨ ñɨgö mi yadmɨdla, mai piaku nɨ mil ölɨsö mag keiryöbö alɨp hön, nöbö mö magalɨg nugwidɨx mɨjɨna. Wop aku mɨ, ñɨgö nöbö nɨ mai yönmɨjöñ piaku yadmön, Isrel nöbö mö il hörɨrör akuyöbö möl sö piaku, ñɨŋ nugwidɨx mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nöbö mö nɨ nugw pön, ram rɨb, pɨgnɨŋ nölöunɨŋ, nuö nuöm, halöu ha nöbö nuŋ bla, möriwö rɨb, ap bɨl kai bɨl kai röböxöñ nöbö mö aku, God ñɨgö uplöben; ap piaku ñɨgö paiŋö mɨga akwör nölön, öim mɨdɨb maga ñɨgö nöiöna. ");
INSERT INTO tmd_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Makwam nöbö mö wopik höd dumɨdöi bla, mai mɨg mɨŋa mɨ höglöm adö bö mɨjöña. Makwam nöbö mö wopik höglöm adö bö mɨdöi bla, mai mɨg mɨŋa mɨ höd sö mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jisas aliö rön yadöŋa, “God nöbö mö pön nugwidɨx mɨdɨb wop aku, haiwo aliö kɨyöbö mɨda. Nöbö wain möriwö mɨnöbö i, nɨ du nöbö bli pön hömön, möriwö na mabö rɨŋ, me rön, ruö yöudöŋdöŋ röxöŋ maga aku öbɨlön, du nöbö bli hölu nugwön, ");
INSERT INTO tmd_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ñɨgö rɨg silpa mag paŋ paŋ nöinö, rön, ñɨgö pɨsaŋ mönö paŋyöbö i nɨg ödör nɨgön, yad abaŋ, du wain möriwö nuŋ aku mabö rɨmɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Makwam naiö ul mɨŋi bɨl yöra sö wöiön mag aku, du ap sɨmaim rɨb yöra duön nugwöna, nöbö bli hör mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ñɨgö nugwön yajöna, ‘Ñɨŋ kwo algör du mabö na rɨmɨjöñ aku, nɨ ñɨgö rɨga ödöriö akwör nöinö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Aliö yadaŋ, du möriwö nuŋ aku rɨmɨjöña. Makwam naiö mibɨl yör kɨpisö mag aku aipam, naiö pikwo raŋ höxi gurmɨjön mag aku aipam, mönö akwör yadön, nöbö bli alɨg paŋ, mabö nuŋ aku rɨmɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Naiö röd pɨba rɨmɨjön mag aku, iswob ap sɨmaim rɨb yöra duön nugwöna, nöbö bli kwo hö mɨdɨb ör mɨjöña. Ñɨgö yajöna, ‘Ñɨŋ pödpöd rɨmɨn wop kɨ mabö rölön, mɨ hör mɨdöi?’ cöna. ");
INSERT INTO tmd_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Yadmɨdaŋ, nugwo yajöña, ‘Nöbö i anɨŋ mabö i nölölö,’ cöña. Yadmɨdɨŋ, ñɨgö yajöna, ‘Ñɨŋ algör du wain möriwö na aku cɨne,’ raŋ, du möriwö rɨmɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Pɨgön mag aku, wain möriwö mɨnöbö aku, nöbö nugwidɨx mɨdɨb nuŋ aku nugwo yajöna, ‘Nagö duön, mabö na rɨmɨdöi nöbö bla ñɨgö yadaŋ, höŋ, nöbö mai yadmön höi bla, rɨg ñɨgö aku höd nölön, nöbö höd yadmön höi bla, rɨg ñɨgö aku mai nölanö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Yadaŋ, nugwidɨx mɨjön nöbö dib aku, nöbö piaku ñɨgö wö raŋ hömɨdɨŋ, nöbö naiö röd paŋ nugugɨrön, hö mabö cöñ bla, hö rɨg ñɨŋ aku höd pöña. ");
INSERT INTO tmd_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Makwam ñɨŋ aliö pɨŋ nugugɨrön, nöbö höd yadɨŋ, hö mabö cöñ bla rɨbyöx nugwöña, ‘An rɨg diba pɨnɨŋö,’ cöñ aku, jɨ pɨ gɨrön nugwɨŋ, ñɨŋ rɨg paŋyöbö mɨd akwör pöña. ");
INSERT INTO tmd_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pön, rɨba nöbö wain möriwö mɨnöbö aku pɨsaŋ nuö nuö yadön yajöña, ");
INSERT INTO tmd_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘An pödpöd rɨmɨn, nöbö mai höi bla rɨg pöi aliar an pöl? An pɨxmag alɨg öbɨlön, naiö ñɨñɨ rɨmɨn nugugɨrön, mabö rɨmɨdɨm rɨmɨdɨm ipɨt makwam, jɨ nöbö hö ul mɨŋi mabö röi rɨga nöilö rɨg aliar anɨŋ nöilaŋö!’ cöña. ");
INSERT INTO tmd_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Yadmɨdɨŋ, nöbö möriwö mɨnöbö aku nugwön, nöbö ñɨŋ i nugwo yajöna, ‘Nöbö mɨg, nugwö! Nagö rɨ gwogwam röi. Nagö rɨga rɨg nöinö rɨl akwör nöila. ");
INSERT INTO tmd_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","15","Nöbö mai höi piaku, nöbö höd höi piaku pɨsaŋ nɨg nuguguba nöinöb, nöina. Aku ap nɨ. Makwam, nöbö bli pödpöd raŋ wöhö cöñ? Ñɨgö amnör nöil aku, nagö pödpöd rɨmɨn ölɨsö wöl? Rɨg nöil aku pön ram nagö duanö!’ cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jisas haiwo aku urön yadöŋa, “Nöbö mö mai mɨdöi piaku, höd mɨjöña; nöbö mö höd mɨdöi piaku, mai mɨjöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisas Jerusalem du gɨrön, ödöi mibɨl yöra, nöbö nuŋwa akuyöbö möl sö ñɨgö pön hör rɨb piaku duön, ñɨŋ keir mɨdön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ñɨŋ nugwi! An Jerusalem duŋ, Nöbö Ha nuŋwa nugwo höuöu rön, nugwo pön du God ap höjöpal ur nölɨb nöbö dib bla aipam, lo mönö yad nölɨb nöbö bla aipam, imag rol ñɨgö nɨgɨŋ, ñɨŋ nugwo mönö diba yadön yajöña, ‘Nöbö kɨ nugwo pɨl pal nɨgɨb,’ me cöña. ");
INSERT INTO tmd_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Aliö rön, Juda nöbö yöi akuyöbö ñɨgö nölɨŋ, nugwo yad höimöuön, uplöb palön, pön du bɨ katlö watlö höñ sö pɨl pal nɨg gɨŋ wöröxöna. Wop mös mɨdön, wop paŋ aku höbkal öbiönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sebedi ha nuŋ mös, nuöma ha hogwa yölɨŋön, Jisas mɨdöŋ yöra hön, iröpa ubɨlön yadöŋa, “Nɨ mönö i mɨdam hömɨdlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Aliö rɨmɨn, Jisas yadöŋa, “Mönö aku mɨkai?” röŋa. Aliö rɨmɨn, yadöŋa, “Nɨ wä cön aku, mai nagö kiŋ mɨdön, nöbö mö nugwidɨx mɨjɨnö wop aku, ha nɨ hogwa höñ nagö yöra römɨjöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Aliö rɨmɨn, Jisas yadöŋa, “Mönö nɨ yad nugumɨdöi aku, nugw ri abmɨdölöi. Röbö acɨxa nɨ nɨmɨba rɨmɨdɨl aku, ñɨŋ nöbö hogwa algör nɨmöñɨŋöd?” röŋa. Jisas aliö rɨmɨn, nöbö hogwa yadmä, “Yöwö! An nɨmnɨŋö!” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Aliö rɨmɨn, Jisas yadöŋa, “Mi yadmɨdöia. Röbö acɨxa nɨmɨba rɨmɨdɨl aku nɨmöña. Jɨ nöbö kai imag mɨrɨx nɨ ada mɨjön, nöbö kai imag cökö nɨ ada mɨjön aku nɨ yadöin; aku Acö ap nuŋ; nuŋ keir rɨg rɨbyöx nugw mag akwör cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nöbö nuŋ hogw aku mönö aku aliö rɨmɨdmɨn, nöbö nuŋ akuyöbö ragpɨd sö mönö aku nugumɨn, ölɨsö wölɨm, hödpɨg nöbö yadyöxmä. ");
INSERT INTO tmd_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jisas piöŋö nöbö nuŋ akuyöbö magalɨg yadɨm hömɨdmɨn yadöŋa, “Ñɨŋ nugwöia, Juda nöbö mö yöi piaku, kiŋ ñɨŋa ususör rön, nugwidɨx mɨdöia; nöbö dib ñɨŋa mönö agapɨm yajöñ aku, ñɨŋ mönö nuŋwa nugwön, anau pön, mai diöña. ");
INSERT INTO tmd_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Makwam ñɨŋ röi mag akuyöbö rɨmɨjeñ. Nöbö kai nöbö diba mɨjön aku, nöbö haŋal mɨdöi röxg mɨdön, nöbö mö adö bli mabö rɨ nölɨb nöbö akuyöbö mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nöbö kai nöbö dib ödöriö mɨjön aku, nöbö haŋal mɨdöi röxg mɨdön, nöbö mö adö bli nag mabö rɨ nölɨb nöbö akuyöbö mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nöbö Ha nuŋ aku, nöbö mö bla ñɨŋ mabö na rɨŋ me rön hölöŋ; mabö ñɨgö rɨ nölɨp dumɨdön, mai ap kib mag gwogwo röi piaku höj rɨ wöröxmön, ñɨŋ kömö duŋ, me rön, hö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Makwam Jisas taun dib Jeriko röböxön dumɨn nugugɨrön, nöbö mö mɨg mɨŋa nugwo mai dumä. ");
INSERT INTO tmd_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nöbö mämäg we hogwa ödöi kwol yöra römɨd gɨ mɨdɨm nugugɨrön, “Jisas hömɨdö,” rɨmɨn nugwön, ajmöla aj halön yadmä, “Depid Ha nuŋwa, anɨŋ ögwö yöxanö!” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Aliö rɨmɨn, nöbö mö akuyöbö ñɨŋ nöbö hogwa jɨ nugugu mɨd yadön yadmä, “Mönö ua nɨgmɨjeñ!” rɨmä. Aliö yadmä aku, jɨ mönö ñɨŋ aku yöxölim, ajmöla aj halön yadmä, “Depid Ha nuŋwa, anɨŋ ögwö yöxanö!” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Aliö rɨmɨdmɨn, Jisas aŋöi nɨgön, nöbö hogwa yad wö rön yadöŋa, “An pödpöd raŋ, me rön, nɨ yad wö rɨmɨdöi?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Jisas aliö rɨmɨn, yadmä, “Nöbö Dib, mämäga ana we wöl aku raŋ ix nuguŋö!” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Aliö rɨmɨn, Jisas ñɨgö nöbö hogwa ögwö yöxön, mämäg ñɨŋa pɨ nugum, rɨmgör mämäga ix nugumɨn nugugɨrön, nuŋ dumɨn mai dumä. ");
INSERT INTO tmd_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jisas nöbö nuŋ bla pɨsaŋ Jerusalem u igöp igöp rön, mögörɨb ulmɨdö Betpagi, Olip Pɨda womiöx uröpɨnmä. Uröpɨnön, nöbö nuŋ mös yad abön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Ñɨŋ nöbö hogwa ram yöj lɨglɨg agrö pö kwo duön nugwöña, hön donki nuöm hagap hogwa wabɨl nɨg gɨŋ mɨjöña. Nugwön, naga yauön pön höña. ");
INSERT INTO tmd_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Makwam nöbö i hön, pödpöd rɨba hön donki an aku yau pön dumɨdöiŋö, rɨmɨjöñ aku, paiŋö yajöña, ‘Nöbö Diba mabö mɨdɨm, yadmɨn pɨba hölɨŋö,’ rɨŋ, rɨmgör yöwö raŋ, pön hönö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Makwam ñɨgö nöbö hogwa yad abɨm duim aku, God mönö yadɨb nöbö i cöñɨŋö, rön, rɨg kai kɨt nɨgöŋ mag akwör röŋa. Nuŋ yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Jerusalem nöbö mö ñɨŋ yajöña, ‘Kiŋ nöbö höimölɨb ñɨŋ aku, hön donki rola römɨdön, ñɨgö hömɨda. Nuŋ hön donki ha rol aku römɨdön hömɨdö,’ cöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Makwam Jisas nöbö nuŋ agal abɨm duim hogw aku rɨg yadöŋ mag akwör, ");
INSERT INTO tmd_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","hön donki nuöma aipam, ha maua aipam pön hömɨdmɨn, nöbö nuŋ bla wölɨj mɨxɨla rödön, hön donki rol sö nɨgmɨn, Jisas rola römɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nöbö mö mɨga, Nöbö Diba hömɨdö, rön, wölɨj mɨxɨl ñɨŋ rol sö röbmɨdöi akuyöbö rödön, ödöi diba yödmä. Bli du köp panö, bɨ panö bla römaxdörön rag hö ödöi diba yödmä. ");
INSERT INTO tmd_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nöbö mö akuyöbö Jisas nugwo pɨ mibɨl nɨg du gɨrön aja halön yadmä, “Nugwi! Depid yöxɨm yöxɨp hön yöx aku, hömɨd mɨk. Nugwo wä rö rɨmɨdöla! Nöbö Diba nugwo agal abmɨn hömɨd nöbö mɨk, nugwo wä rö rɨmɨdölɨŋö!” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisas Jerusalem uröpɨnmɨn nugugɨrön, nöbö mö bla magalɨg yad nugwön yadmä, “Nöbö aku agö nöböm?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Aliö rɨmɨn, nöbö mö Jisas pɨsaŋ hömä akuyöbö yadmä, “Nöbö kɨ mɨ Jisas, God mönö yadɨb nöbö Nasaret mögörɨb Galili yöbö aku,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisas God höjöpalɨb rama ram möl yuadö duön nugwöŋa, nöbö mö bla ap sɨm rɨ mɨdmä. Nuŋ nugwön, ñɨgö magalɨg rɨbɨx abön, äbäñ wab rɨg nɨgön, nuö nuö imcɨxön rim akuyöbö pɨ göur abön, nöbö yöur sɨm rön, bäpö rola römɨdmɨdim piaku, pɨ göur aböŋa. ");
INSERT INTO tmd_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Akuyöbö alön ñɨgö yadyöxön yadöŋa, “God Mönö kai kɨtim aku, God yadöŋa, ‘Ram na aku nɨ höjöpalɨb rama, jɨ ñɨŋ alöi aku, nöbö ap kib pɨb ram i röxgö,’ rö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Makwam Jisas nuŋ God höjöpalɨb rama ram möl yuadö mɨdmɨn nugugɨrön, nöbö mö mämäg we wölöŋ bli, nöbö mö yödpɨlö gwogwo röŋ bli hömɨdmɨn, ñɨgö rɨmɨn kömö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nuŋ ap rölɨbä akuyöbö rɨmɨn, halöu ha ulul bla wö rɨ gɨrön yadmä, “Nagö ri ablaŋö rɨmɨdöla! Depid Ha nuŋwa! Isaune!” rɨmä. Makwam ñɨŋ akuyöbö almɨdmä aku, God ap höjöpal ur nölɨb nöbö dib bla aipam, lo mönö yad nölɨb nöbö bla aipam nugumɨn, ñɨgö mɨ ölɨsö wölöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ölɨsö wölmɨn, yadmä, “Nagö yadmɨdöi aku nugumɨdlanö ä?” rɨmä. Aliö rɨmɨn, Jisas ñɨgö yadöŋa, “Yöwö! Yadmɨdöi aku nugumɨdla aku, jɨ ñɨŋ mönö bli kai kɨtön yadmä, ‘God, nagö rɨmɨjɨnö nugwön, halöu ha ulul halöu ha kiai bla ib nagö yadɨŋ adöx sö diönɨŋö,’ rɨmä. Ñɨŋ mönö kai kɨtim aku, mämäg nɨg nugwölöiŋ ä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Aliö rön, ñɨgö röböxön, du ram yöj lɨglɨg agrö Betani hölɨmöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Löumɨn Jisas höuöil Jerusalem duba ödöi mibɨl yöra dumɨn, nugwo kiö pɨlɨm, ");
INSERT INTO tmd_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","nugumɨn ödöi diba pedöx pedöyɨx bɨ kaucö römö i mɨdöŋa. Bɨ il yöra duön nugumɨn, maga yaxölöŋ; panö bla akwör mɨdöŋa. Alɨg mɨdmɨn, Jisas yadöŋa, “Nagö mai mag i yaxöinaŋö!” röŋa. Aliö rɨmɨn nugugɨrön, wop mɨd akwör bɨ kaucö römö wöröxöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Almɨn, nöbö nuŋ bla nugwön, aiö rön yadmä, “Pödpödiö bɨ römö kɨ rɨmgör wöröxö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Aliö rɨmɨn, Jisas ñɨgö yadöŋa, “Nɨ ñɨgö mi yadmɨdla, an yadɨŋ God algör ör cönɨŋö, rön kwönö, rɨb mös yöxmɨjeñ, rɨb paŋyöbö iör yöx nugwöñ aku, cöna. Makwam bɨ kaucö wöröxöŋa akwör yöi; önöŋ ajmag pɨd dib kɨ kɨrɨrɨ rɨp röbö yuö mibɨl dib kwo duö, cöñ aku, diöna. ");
INSERT INTO tmd_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","“Makwam ñɨŋ God nugw pön, nugwo yad nugwöñ aku, rɨg yajöñ mag akwör cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisas God höjöpalɨb rama duön, nöbö mö akuyöbö ñɨgö mönö yad nölɨm nugugɨrön, God ap höjöpal ur nölɨb nöbö dib bla aipam, mönö pɨ nuöm nɨgɨb nöbö bla aipam hön nugwo yadmä, “Nagö yönɨm mag akuyöbö rane, rɨm, nugwön alɨp yönmɨdlö ö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Aliö rɨmɨdmɨn, Jisas paiŋö yadöŋa, “Nɨ ñɨgö mönö i yad nugumön, nɨ yad nölɨŋ, nɨ paiŋö yön yadmɨn mabö rɨmɨdɨl aku ñɨgö yad nöina. ");
INSERT INTO tmd_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jon nöbö mö akuyöbö ñɨgö röbö pal nölöŋ aku, nuŋ keir rɨbyöx nugwön höŋ mönö God yadɨm hön akuyöbö alöŋ?” röŋa. Jisas aliö rɨmɨn, ñɨŋ ñɨŋ keir nuö nuö yad nugup duön yadmä, “An, ‘God agal abmɨn hön alöŋa,’ rɨmɨjnɨŋ aku, anɨŋ yajöna, ‘Makwam, Jon yad aku pödpöd rɨmɨn nugw pölöiŋö?’ cöna. ");
INSERT INTO tmd_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Makwam an nöbö mö piaku ipöxöla. An, ‘Jon rɨb nuŋwa keir yöxön hön alöŋa,’ rɨmɨjnɨŋ aku, nöbö mö bla ölɨsö röjöña. Rɨb ñɨŋ aku, Jon nuŋ God mönö yadɨb nöbö i höŋa,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Aliö rön Jisas nugwo yadmä, “An nugwölölɨŋö,” rɨmä. Aliö rɨmɨn, Jisas ñɨgö yadöŋa, “Ñɨŋ nɨ yad nölölöi aku, nɨ paiŋö yön yadmɨn nɨ hön rɨmɨdɨl aku, ñɨgö kwo algör yad nölöinö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jisas aliö rön yadöŋa, “Makwam ñɨŋ agö rɨbɨm yöxmɨdöi? Nöbö i ha nuŋ mös mɨjöna. Ha nuŋ höd aku nugwo yajöna, ‘Ha mɨg! Weik wain möriwö aku du mabö rö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Yadaŋ, ha nuŋwa yajöna, ‘Nɨ du röinö,’ rön, mai piöŋö höbkal rɨbyöx nugwön, du wain möriwö rɨmɨjöna. ");
INSERT INTO tmd_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nuö piöŋö du ha pɨga algör yad nugwaŋ, yajöna, ‘Yöwö, cɨnö!’ cön aku, jɨ du ren. ");
INSERT INTO tmd_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Makwam ha hogw aku, yön nuö yajön mag akuyöbö cön?” röŋa. Aliö rɨmɨn, Juda nöbö dib piaku yadmä, “Ha nuŋ höd akwör nuö rɨg yajön mag akwör cönɨŋö,” rɨmä. Aliö rɨmɨn, Jisas yadöŋa, “Nɨ ñɨgö mi yadmɨdla, ñɨŋ hör mɨdmɨn nugugɨrön, nöbö takis pöi bla aipam, nöbö kib pɨb mö bla aipam, God nöbö mö pön adöx yöd röul adö kau sö nugwidɨx mɨjön mögörɨb aku, ñɨgö röb höx rɨ nɨgön diöña. ");
INSERT INTO tmd_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Röbö pal nölɨb nöbö Jon aku, ñɨŋ agö magɨm rɨŋ God nugwo wä cön aku, ñɨgö yad nölöŋa, jɨ mönö nuŋ aku pölim. Nöbö takis pɨb piaku aipam, nöbö kib pɨb mö piaku aipam, ñɨŋ Jon mönö yadöŋ mag aku nugwön, pɨmä. Pim aku ñɨŋ mödö nugumä aku, jɨ ñɨŋ keir, Jon mönö aku pön, ap kib mag gwogwo röi aku, pödpöd rɨmɨn aliö alölɨŋö, rön, röböxölöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisas yadöŋa, “Weik mönö höd röxön i alɨg yadɨba rɨmɨdɨl kɨ nugwi. Nöbö möriwö rɨb mɨnöbö i nag wain möriwö aku rɨ yuön, kul wobön, nag wain maga pal caku rɨb möla i cöna. Rɨ nɨgön, nag wain maga kib nɨmöñam, nugugu mɨjnɨŋö, rön, ram mɨxɨl dib i urön, nöbö bli yajöna, ‘Ñɨŋ nag möriwö na aku nugwidɨx mɨjöña, mai mag yaxön göj waŋ, nɨ bli, ñɨŋ bli pɨne,’ rön, mögörɨb mɨ pad piaku diöna. ");
INSERT INTO tmd_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nag wain mag aku göj waŋ nugugɨrön, nöbö nuŋ akuyöbö ñɨgö yajöna, ‘Wain möriwö nɨ bla duön, nöbö mabö nugwidɨx mɨdöi piaku yadön, nag wain mag na bli rag höi,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ñɨŋ wain möriwö uröpɨnɨŋ, nöbö wain möriwö mabö rɨmɨjöñ piaku öbɨlön, nöbö i nugwo paiöña, nöbö i nugwo mɨ aŋadö pɨl pal nɨg gɨŋ wöröxöna, nöbö i nugwo rɨg röd paiöña. ");
INSERT INTO tmd_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Akuyöbö alɨŋ, nöbö nag wain möriwö mɨnöbö aku, nöbö nuŋ adöi piöŋö yad aböna. Yad abaŋ, dumɨdɨŋ, nöbö nag wain möriwö mabö rɨmɨjöñ piaku ñɨgö kwo paŋ mag akwör cöña. ");
INSERT INTO tmd_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Akuyöbö alɨŋ, nöbö wain möriwö mɨnöbö aku yajöna, ‘Ha na agal abmön, mönö nugwo aku nugwöñɨŋö,’ rön, yad abaŋ diöna. ");
INSERT INTO tmd_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ha nuŋwa uröpɨnaŋ, nöbö wain mabö rɨ mɨjöñ piaku nugwo nugwön, ñɨŋ ñɨŋ keir yajöña, ‘Nöbö möriwö mɨnöbö ha nuŋ aku hömɨd kɨ. Nuö mai wöröxaŋ, ap möriwö bɨlɨk ha nuŋwa pöna. Makwam, nugwo pɨl pal nɨgɨŋ wöröxaŋ, mai ap möriwö bɨlɨk magalɨg pɨnɨŋö,’ cöña. ");
INSERT INTO tmd_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Aliö rön, nugwo pön du möriwö rɨŋadö piaku duön, mɨ aŋadö pɨl pal nɨgöña. ");
INSERT INTO tmd_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Akuyöbö almɨjöñ aku, mai nöbö nag wain möriwö mɨnöbö aku hön, ñɨgö agö magɨm cönɨŋö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jisas aliö rɨmɨn, yadmä, “Nöbö gwogwam cöñ piaku ñɨgö rɨmɨdaŋ, ölɨŋ höb dib ödöriö pön wöröxöña; mai nöbö mö yoŋyöbö pön, ñɨgö nag wain möriwö aku yad nɨgön, wañ pɨlaŋ rɨmɨjöña. Nag wain maga göj yön wop aku, ödör rag du nuŋ nöiöñɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Aliö rɨmɨn, Jisas yadöŋa, “God Mönö kai kɨtim aku nugwölöiŋödö. Ñɨŋ kai kɨtön yadmä, ‘Nöbö ram urɨb bla, ñɨŋ rɨg ram urɨba rön, rɨg i pön yadmä, “Rɨg kɨ rɨg gwogwo gɨ röböxnɨŋö,” rɨmä. Makwam Nöbö Diba nuŋwör rɨmɨdmɨn, rɨg akwör ram nuŋwa mɨ rɨg wä mɨdö mɨda. Nöbö Diba nuŋ akuyöbö almɨdmɨn, an nugwön aiö waiö rɨmɨdölɨŋö,’ rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Rɨg waiö röböxöi aku, God ñɨgö Juda ada röböxön, nöbö mö hör akuyöbö, ap nugwo nölɨba nöiöñ akuyöbö, ñɨgö pön nugwidɨx mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nöbö mö rɨg rol aku pɨn bɨcöñ akuyöbö, ñɨgö uplöb paiöna; jɨ rɨg aku mölöd pɨnön, nöbö mö palölö cön akuyöbö, mɨ aŋadö palɨx döbdö raŋ diönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","God ap höjöpal ur nölɨb nöbö dib bla aipam, Perisi nöbö bla aipam, Jisas mönö höd röxön yadöŋ aku, ñɨgör yadöŋ aku nugwön, ");
INSERT INTO tmd_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","nugwo nag nɨgnɨŋö, rön, rɨbyöx nugwim aku, jɨ nöbö mö piaku, Jisas nugwo God mönö yadɨb nöbö, me rɨmä aku, anɨŋ yadyöxöñɨŋö, rön, nugwo ap i rɨb maga mɨdölöŋ. ");
INSERT INTO tmd_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisas iswob mönö höd röxön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“God nöbö mö pön nugwidɨx mɨdɨb aku, haiwo aliö kɨyöbö mɨda: “Nöbö kiŋ i ha nuŋ aku mö pɨba raŋ, ap diba nɨmɨba, ap mag rag hö mögum rɨmɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Akuyöbö alön, nöbö nuŋ bli yad abön yajöna, ‘Nöbö mö yad nɨgɨm piaku du yadɨŋ höŋ, ap diba nɨmɨŋö,’ cöna. Aliö raŋ, ñɨŋ du nöbö mö adaku ñɨgö yajöña aku, jɨ ñɨŋ röböxöña. ");
INSERT INTO tmd_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Akuyöbö alɨŋ, nöbö nuŋ bli piöŋö iswob yad abön yajöna, ‘Ñɨŋ du nöbö mö adaku ñɨgö yajöña, “Kiŋ aku, hön kau dib bli, hön kau ha mau bli pal urön, ap piaku magalɨg rɨ pɨdɨluön, ‘Höne’ rɨ gö,” me cɨnö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Aliö raŋ, ñɨŋ du yajöña aku, jɨ mönö ñɨgö aku ki bö aböña. Bli ap möriwö ñɨŋ bla diöña; bli rɨg mabö ñɨŋ bla rɨmɨjöña; ");
INSERT INTO tmd_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","bli, kiŋ nöbö nuŋ piaku rɨ gwogwam rön, pɨl pal nɨg gɨŋ wöröxöña. ");
INSERT INTO tmd_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Akuyöbö alɨŋ, kiŋ aku nugwaŋ, höbwab nuŋwa gwogwo raŋ, ami nöbö nuŋ bla agal abaŋ, du nöbö mö nöbö nuŋ pɨl pal nɨgöña piaku ñɨgö magalɨg pɨl pal pör nɨgön, taun dib ñɨŋ aku ur cɨlɨŋ diöña. ");
INSERT INTO tmd_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Makwam mabö rɨ nölɨb nöbö nuŋ piaku ñɨgö yajöna, ‘Ap mag akuyöbö mödö pɨdɨluöl aku, jɨ nöbö mö höd wö rɨm piaku höb maga rölöi. ");
INSERT INTO tmd_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Makwam, ñɨŋ ödöi römögɨl bla duön, nöbö mö nugwöñ akuyöbö, ñɨgö magalɨg, “Höŋ ap diba nɨmɨŋö,” rön, amɨn yölɨŋ pön höŋ, ap diba nɨmɨŋö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Aliö raŋ, nöbö nuŋ bla du ödöi römögɨl bla duön, nöbö mö wä bla, nöbö mö gwogwo akuyöbö ñɨgö magalɨg, ‘Höŋ ap diba nɨmɨŋö,’ rön, amɨn yölɨŋ pönaŋ, nöbö mö pön ap diba nɨmöñ rama yuadö duön, cɨcɨ rɨg mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Kiŋ aku piöŋö, nöbö mö höi piaku nugunö, rön, ram möl yuadö bö duön nugwöna, nöbö i, ap nɨmɨb wölɨja röböi aku röben wöhö, hör mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Alaŋ, nugwo yajöna, ‘Nöbö mɨg! Pödpöd rɨmɨn, mö pön ap nɨmɨba wölɨj röböi aku röböiö wöhö, hör ör höladö?’ cöna. Yadaŋ, nöbö aku mönö paiŋö i yaden. ");
INSERT INTO tmd_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Aku kiŋ aku nöbö nuŋ piaku ñɨgö yajöna, ‘Nöbö kɨ iŋ wajmag nugwo bla nag nɨgön, pön du cɨcɨbö yuö piaku abɨŋ, nöbö mö piaku pɨsaŋ ajmaga öb gɨlɨx gɨrön, möb ewö rön im gɨr mɨdɨŋ,’ me cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jisas haiwo aku ur pörön, ñɨgö yadöŋa, “God nöbö mö mɨg mɨŋa yad wö cöna, jɨ ñɨgö magalɨg pen. Nöbö mö mösör hogwi iör pönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Makwam Perisi nöbö piaku, Jisas nugwo mönö kai yadɨŋ, paiŋö yadaŋ nugwön, nugwo pön du nag nɨgnɨŋö, rön, mönö yad nugwob nugwob rön, ");
INSERT INTO tmd_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","nöbö ñɨŋ keir bli, Herod nöbö nuŋ bli pɨsaŋ agal abɨm, ñɨŋ Jisas mɨdöŋ yöra hön yadmä, “Mönö yad nölɨb nöbö. Naŋ nöbö mönö mɨ ödöriö akwör yadmɨdlö. Naŋ nöbö mö nugwön ipöxöiö. God rɨg yad mag akwör nugwön, nöbö mö yad nölmɨdlö. ");
INSERT INTO tmd_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Makwam, naŋ rɨb kai yöx nugulö? An Isrel nöbö mö, Sisa nöbö diba taun dib Rom yöbö aku, nugwo takis nölɨb mönö nölölɨbɨm, wöhö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Aliö rɨmɨn, Jisas rɨb gwogwo ñɨŋa nugwön yadöŋa, “Nɨ pödpöd rɨba inakmönö hörɨp hön, aliö yad nugumɨdöi? ");
INSERT INTO tmd_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ñɨŋ takis nölöi rɨg mag i nölɨŋ, nugunöm!” röŋa. Aliö rɨmɨn, nugwo rɨg mag i rag hö nölmä. ");
INSERT INTO tmd_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jisas rɨg mag aku nugwön ñɨgö yadöŋa, “Rɨg mag kɨ, nöbö inöm kɨ yönɨm inöma mɨd? Ib aku yönɨm iba mɨd?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Jisas aliö rɨmɨn, yadmä, “Aku nöbö dib Sisa,” me rɨmä. Aliö rɨmɨn, Jisas ñɨgö yadöŋa, “Makwam, Sisa ap nuŋwa mɨjön aku Sisa nöiöña. God ap nuŋwa mɨjön aku God nöiöña!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Aliö rɨmɨn, ñɨŋ rɨb mɨga yöx nugwön, nugwo röböx dumä. ");
INSERT INTO tmd_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Wop akwör, Sadiusi nöbö bli Jisas mɨdöŋ yöra hömä. Sadiusi nöbö mö piaku yadmɨdöia, nöbö mö wöröxön höbkal öbɨleñɨŋö, rɨmɨdöia. ");
INSERT INTO tmd_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ñɨŋ Jisas mɨdöŋ yöra hön yadmä, “Mönö yad nölɨb nöbö. Mosɨs yadöŋa, ‘Nöbö i mö pön, halöu ha yöx pön hen wöhö, hör wöröxöna, pɨgnɨŋ nuŋwa mö aku pön, halöu ha nuŋ piaku, me rön, yöx pön hönɨŋö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Makwam, nöbö il alɨg akuyöbö mɨj sö mɨjöña. Nöbö höd aku mö pön, halöu ha yöx pön hen wöhö, hör wöröxöna. Alaŋ, pɨgnɨŋ nöbö agñɨŋ rɨbyöbö aku piöŋö mö akwör pöna. ");
INSERT INTO tmd_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pɨgnɨŋ nöbö agñɨŋ rɨbyöbö aku piöŋö mö aku pön, algön nör halöu ha yöx pön hen wöhö, hör wöröxöna. Makwam, pɨgnɨŋ igwö wölö aku mö aku pön, algön nör halöu ha yöx pön hen wöhö, hör wöröxöna. Paŋ mag akwör rɨp dumɨd dumɨd, nöbö il akuyöbö mɨj sö piaku, magalɨg halöu ha yöx pön heñ wöhö, hör ör wöröx pöcöña. ");
INSERT INTO tmd_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Alɨŋ mönö mö aku algör wöröxöna. ");
INSERT INTO tmd_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nöbö il aku ñɨŋ magalɨg mö aku pɨmä. Makwam, nöbö mö wöröxöi bla öbiöñ wop aku, mö aku yönɨm pön?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Aliö rɨmɨn, Jisas ñɨgö paiŋö yadöŋa, “Ñɨŋ God Mönö mɨd aku aipam, God ölɨsö mɨd aku aipam, nugwölöi makwam, gwogwam yadön yadöia, ‘Nöbö mö akuyöbö wöröxön öbɨleñɨŋö,’ röia. ");
INSERT INTO tmd_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nöbö mö öbiöñ wop aku, mö piaku nöbö peñ, nöbö piaku mö peñ. Ejol adöx yöd röul adö kau sö mɨdöi piaku rɨg mɨdöi mag akuyöbö rɨg mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ñɨŋ, ‘Nöbö mö wöröxön öbɨleñɨŋö,’ röi aku, God Mönö kai kɨtim bli nugwölöi ä? ");
INSERT INTO tmd_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","God yadöŋa, ‘Nɨ Ebraham, Aisak, Jekop, God ñɨŋ aku nɨ mɨdlö,’ röŋa. Nöbö piaku aŋadö wöröxöyɨx aku, God nöbö höd wöröxim piaku ñɨgö yadön, ‘God ñɨŋ aku nɨ mɨdlö,’ rölöx. Nöbö wöröxɨm, hogw pɨlim piaku kömö mɨdöi makwam, ñɨgö yadöŋa, ‘God ñɨŋ aku nɨ mɨdlö,’ rɨ gö,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jisas mönö aku yad nölmɨn, nöbö mö mɨdim akuyöbö nugwön aiö waiö rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jisas mönö aku yad ri abmɨn, Sadiusi nöbö bla mönö i paiŋö yadɨb maga nɨgölöŋ. Jɨ Perisi nöbö bli, Jisas alön röŋ aku nugwön Jisas mɨdöŋ yöra hömä. ");
INSERT INTO tmd_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Nöbö ñɨŋ lo mönö nugw ri abön röŋ i, Jisas pödi yajönɨŋö, rön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mönö yad nölɨb nöbö. Lo mönö aku, mönö ada kai mönö dib ödöriö mɨd?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Aliö rɨmɨn, Jisas yadöŋa, “Madmag nagö aku magalɨg, rɨb mag nagö aku magalɨg, ölɨsö nagö magalɨg, God Nöbö Dib nagö akwör mɨ ödöriö madmag nɨgön. ");
INSERT INTO tmd_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mönö dib höd sö ödöriö aku maku. ");
INSERT INTO tmd_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mönö dib agñɨŋ rɨbyöbö aku piöŋö alɨg mɨda: naŋ naŋ keir madmag rɨg nɨglö mag akwör, nöbö mö hör akwebö wobiö madmag nɨgö. ");
INSERT INTO tmd_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mönö hogwa aku yadɨl kɨ, Mosɨs lo mönö kai kɨtöŋ mönö piaku magalɨg aipam, God mönö yadɨb nöbö bla kai kɨtim mönö piaku magalɨg aipam, mönö il dib ödöriö aku mönö mɨ hogwa akwör,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Perisi ada hö mögum rön mɨdɨm nugugɨrön, Jisas ñɨgö mönö i yad nugwön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ñɨŋ Mesaia aku nugwo agö rɨbɨm yöx nugwöi? Nugwo nöbö kai ha nuŋ me rön nugwöi?” röŋa. Jisas aliö rɨmɨn, yadmä, “Depid ha nuŋ,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Aliö rɨmɨn, Jisas yadöŋa, “God Inöma nuŋ Depid nugwo rɨba nölɨm nugugɨrön, Depid nuŋ Mesaia aku nugwo ‘Nöbö Dib nɨ’ me röŋa. Depid yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Nöbö Diba mönö yadön, Nöbö Dib na yada, “Naŋ imag mɨrɨx nɨ adö mɨdaŋ, nɨ rɨmön, pɨlgɨb nagö bla yödpɨlö nagö moa mɨjöñɨŋö,” rö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Mesaia aku, Depid nuö maduebö nuŋ me röi aku, jɨ Depid nuŋ Mesaia nugwo ‘Nöbö Dib nɨ’ me röŋa. Makwam, ñɨŋ agö rɨbɨm yöx nugwöi?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jisas nuŋ mönö yad ri abmɨn, ñɨŋ nugwo paiŋö yadɨb maga nɨgölöŋ aku, almɨn ipöxön mönö, mai Jisas nugwo mönö bli kwo yad nugwölim. ");
INSERT INTO tmd_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Mai wop i, Jisas nöbö nuŋ bla aipam, nöbö mö bli aipam, ñɨgö mönö yadön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Lo mönö yad nölɨb nöbö bla aipam, Perisi nöbö bla aipam, Mosɨs yöra pön, God lo mönö Mosɨs maduar ör kai kɨtöŋa aliar yad nölöia. ");
INSERT INTO tmd_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Makwam, nöbö piaku ñɨŋ God lo mönö agamö cöñ aku nugw pön mai diöña; jɨ ñɨŋ cöñ mag aku nugwön, mai duön rɨmɨjeñ. God lo mönö yad nölöi aku, jɨ ñɨŋ ñɨŋ keir mönö aku mai duön rölöi. ");
INSERT INTO tmd_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ap piaku cöña, ap piaku rɨmɨjeñɨŋö, röi aku, mönö mɨga akwör yadöia. Ñɨŋ yadöi aku, yogw ömörö dib ödöriö algör, nöbö mö akuyöbö ñɨgö rag nölöi aku, jɨ ñɨgö uliöxön bli pɨ nuöm nɨgölöi. ");
INSERT INTO tmd_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nöbö mö piaku anɨŋör nugwɨŋ, me rön, God Mönö kai kɨtim mönö bli pɨ möigw yöd sö nɨgön, imag bla nɨgön yönöia. An God nöbö nuŋ blaku, me rɨŋ, me rön, wölɨj mɨxɨl dib nag rɨba alɨg wä bla röbön röia. ");
INSERT INTO tmd_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ñɨŋ ap dib nɨmɨb mibɨl aku diönɨŋönö Juda mögum rɨb ram piaku duön, nöbö dib bäpö römɨdöi rol akwör römɨdöia. ");
INSERT INTO tmd_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Rɨb ñɨŋa yöx nugwöi aku, nöbö mö mɨga mɨdöi mibɨl piaku duŋ, ‘Mönö yad nölɨb nöbö dib hömɨdlaŋe!’ rɨŋ, anɨŋ wä cönɨŋö, rön, nugwöia. ");
INSERT INTO tmd_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Jɨ ñɨŋ haul hödpɨg il paŋyöbö i mɨdöi makwam, ñɨgö, ‘Yad nölɨb nöbö dib nɨ,’ me rön yajmɨjeñ. Yad Nölɨb Nöbö Dib ñɨŋa paŋyöbö iör mɨda. ");
INSERT INTO tmd_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mögörɨb il kɨ nöbö i, ‘Acö nöbö dib nɨ,’ me rön yadmɨjeñ. Nuö ñɨŋa paŋyöbö iör mɨd mögörɨb adöx yöd röul adö kau sö yöraku. ");
INSERT INTO tmd_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ñɨŋ kwo paiŋö ñɨgö, ‘Yad nölɨb nöbö dib nɨ,’ me rön yajmɨjeñ. Yad nölɨb nöbö dib ñɨŋa paŋyöbö iör, Mesaia akwör mɨda. ");
INSERT INTO tmd_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ñɨŋ mibɨl yöraku, nöbö mö kai nuŋ nöbö mö diba röxg mɨjön aku, nuŋ mabö rɨ nölɨb nöbö i röxg mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nöbö mö ib ñɨŋa keir yadɨŋ bɨl sö diön bla, ib ñɨŋa pɨn diöna; jɨ nöbö mö ib ñɨŋa keir yadɨŋ bɨl sö duen bla, mai ib diba mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ñɨŋ God lo mönö yad nölɨb nöbö bla aipam, Perisi nöbö bla aipam, ñɨŋ inakmönö hörön rɨ gwogwam rɨb nöbö. God ñɨgö rɨ gwogwam cöna. Ñɨŋ keir God nöbö mö pön adöx yöd röul adö kau sö nugwidɨx mɨdɨb möl aku dumɨjeñ. Jɨ nöbö mö duba rɨmɨdöi bla ödöi ñɨŋa woböia. ");
INSERT INTO tmd_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Ñɨŋ God lo mönö yad nölɨb nöbö bla aipam, Perisi nöbö bla aipam, ñɨŋ inakmönö hörön rɨ gwogwam rɨb nöbö. God ñɨgö rɨ gwogwam cöna. Ñɨŋ mö wösrö ram alɨg kib pöia. Mag aku, nöbö mö anɨŋ nugwɨŋ, me rön, God nugwo mönö mɨxɨl kapa inakmönö hörön yadöia. Alöi aku mɨ, ölɨŋ höb dib ödöriö pöña. ");
INSERT INTO tmd_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ñɨŋ God lo mönö yad nölɨb nöbö bla aipam, Perisi nöbö bla aipam, ñɨŋ inakmönö hörön rɨ gwogwam rɨb nöbö. God ñɨgö rɨ gwogwam cöna. Nöbö mö akuyöbö mönö ana yöxön mai duŋ, me rön, mögörɨb pad piaku hölu nugw yönön, bli nugwön yad nölɨŋ, ñɨŋ keir kɨjaki nöbö nuŋwa mɨdöi akuyöbö yöi, ñɨŋ kɨjaki nöbö mö nuŋ mɨrɨx ödöriö mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Nöbö mö akuyöbö ñɨgö God ödöi nɨgöŋ aku yabu ri abölɨŋe, röi aku, jɨ ñɨŋ nöbö mämäg we bɨlɨm, ñɨŋ keir nugwölöi! Akuyöbö alöi aku, mönö dib ödöriö mɨda. Nöbö mö piaku ñɨgö inakmönö hörön yadöia, ‘An, “God höjöpalɨb rama mɨd aku, mi yadmɨdölɨŋö,” cɨnɨŋ aku, mai röböxnɨŋö, cɨnɨŋ aku, röböxnɨŋa. Makwam rɨg gol pön, ap God höjöpalɨb rama ram möl yuadö bö rim piaku, iba aku yad gɨr, “Mi yadmɨdölɨŋö,” cɨnɨŋ aku, rɨg yajnɨŋ mag akwör cɨnɨŋa; röböxöinɨŋö,’ röia. ");
INSERT INTO tmd_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ñɨŋ nöbö mämäg we, nöbö u! Ñɨŋ rɨb kai yöxöi: gol aku ap ödöriö mönö God höjöpalɨb ram leia aku ap yöböm? Ap ödöriö aku, God höjöpalɨb ram lei nuŋ aku. Ram leia mɨjön aku, ap ram möla mɨda aipam leia mɨjöna mɨ. ");
INSERT INTO tmd_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mönö i algör ör, nöbö mö bla ñɨgö inakmönö hörön yadöia, ‘An, “God rɨgpɨd nuŋwa mɨd aku mi yadmɨdölɨŋö,” cɨnɨŋ aku, mönö mi yajnɨŋ aku hör ap; mai rɨb i yöx nugwön, röböxnɨŋö, cɨnɨŋ aku, röböxnɨŋa. Makwam, ap God rɨgpɨd rol yöra pal God höjöpal ur nölöi piaku, ib aku yad gɨr, “Mi yadmɨdölɨŋö,” cɨnɨŋ aku, mai rɨb hör i yöx nugwön, keir rɨb maga nɨgen; rɨg yajnɨŋ mag akwör cɨnɨŋö,’ röia. ");
INSERT INTO tmd_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ñɨŋ nöbö rɨb mɨdöl piaku, ap kaim ap dibɨm? Ap pal God höjöpal ur nölöi ap aku mönö rɨgpɨd rol yöra höjöpal ur nölöi ap akum? Ap ödöriö maku, rɨgpɨd aku. Rɨgpɨd rol yöra mɨjön makwam, ap aku God nugwo nölɨb maga cöna. ");
INSERT INTO tmd_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Makwam ‘Rɨgpɨda mɨd aku, mi yadmɨdölɨŋö,’ cöñ aku, rɨgpɨd rol aku ap rag hö urmɨdöia alɨg yajöña. ");
INSERT INTO tmd_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Makwam ‘God höjöpalɨb rama mɨd aku, mi yadmɨdölɨŋö,’ cöñ aku, aku God ram nuŋwa nugwön God ib nuŋwa alɨg yajöña. ");
INSERT INTO tmd_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","‘Adöx yöd röul adö kau sö mɨd aku, mi yadmɨdölɨŋö,’ cöñ aku, God hogw rol kiŋ römɨd mɨd yöra nugwön hogw rol kiŋ aku aipam, God hogw rol kiŋ aku römɨd mɨd kau aku aipam mɨd aku, mi yadmɨdölɨŋö, cöña. ");
INSERT INTO tmd_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ñɨŋ God lo mönö yad nölɨb nöbö bla aipam, Perisi nöbö bla aipam, ñɨŋ inakmönö hörön rɨ gwogwam rɨb nöbö. God ñɨgö rɨ gwogwam cöna. Nöbö mö bli ñɨgö yadöi mönö adaku ñɨŋ keir rölöi. Pöm acɨxa, ap amnör möriwö wöl aku nugumɨn, ap yöbö röxgmɨn, iŋ wödɨm, ragpɨd sö dumɨn, God nugwo paŋyöbö i nöinɨŋö, rön, öim ap ñɨŋa God nugwo nölöia. Ap ulul akuyöbö öim alöia, jɨ pödpöd rɨmɨn mönö il ödöriö aku mag akuyöbö alölöi? Ñɨgö nöbö mö gwogwo cön adaku rɨmɨjeñ; ödöriö wä cön mag akwör cöña. Ñɨŋ uliöxön pɨ ri aböña. Cɨnɨŋö, cöñ aku, cöña. ");
INSERT INTO tmd_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nöbö mö akuyöbö ñɨgö ödöi yabunɨŋö, röia, jɨ ñɨŋ keir nöbö mämäg we. Ap ulul piaku nugumɨn, ap yöbö röxga, jɨ ap dib ap iba wöxnö mɨd piaku nugwölöi. ");
INSERT INTO tmd_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ñɨŋ God lo mönö yad nölɨb nöbö bla aipam, Perisi nöbö bla aipam, ñɨŋ inakmönö hörön rɨ gwogwam rɨb nöbö. God ñɨgö rɨ gwogwam cöna. Kwosö namag ñɨŋ bla röxgɨb, rɨŋadö adö bla röbö äbäd ri abön röi aku, jɨ yuö bö ap kib mag gwogwo piaku aja wöl gɨ mɨda. An ap mɨga pɨnɨŋö, rön, mɨxɨñ ana keir ösös rɨ ri abönɨŋö, röia. ");
INSERT INTO tmd_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ñɨŋ Perisi nöbö piaku rɨb mɨdöl. Kwosö namag ñɨŋ bla yuö bö röbö äbäd ri aböyɨx aku, rɨŋadö adö bla alɨg mɨd ri aböyɨxa. ");
INSERT INTO tmd_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ñɨŋ God lo mönö yad nölɨb nöbö bla aipam, Perisi nöbö bla aipam, ñɨŋ inakmönö hörön rɨ gwogwam rɨb nöbö. God ñɨgö rɨ gwogwam cöna. Nöbäpö rɨg möl bla hogw pɨlön, mölaja idɨxön, göñö leia nɨgmɨn, nöbö mö bla nugumɨn, ri aba, jɨ ulöm möl bö nöbäpö yöd bla mämlö hölɨŋ gwogwo hömɨda; ñɨŋ kwo algör alɨg mɨdöia. ");
INSERT INTO tmd_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ñɨŋ kwo algör, mɨxɨñ rɨŋadö nugwöl aku, ñɨŋ nöbö waiö röxg mɨdöia, jɨ yuö ñɨŋ bö, inakmönö bla aipam, ap kib mag gwogwo bla aipam, ap piaku aja wöl gɨ mɨda. ");
INSERT INTO tmd_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ñɨŋ God lo mönö yad nölɨb nöbö bla aipam, Perisi nöbö bla aipam, ñɨŋ inakmönö hörön rɨ gwogwam rɨb nöbö. God ñɨgö rɨ gwogwam cöna. God mönö yadɨb nöbö maduar ör pɨlɨm hogw pɨlim hogwaj rola ud wabɨl nöl ri ab gɨrön yadöia, ");
INSERT INTO tmd_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","‘Nöso auso nöbö mag akuyöbö, an God mönö yadɨb nöbö akuyöbö ñɨgö pɨl pal nɨgölölɨx,’ me röia. ");
INSERT INTO tmd_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Makwam aliö röi aku, God mönö yadɨb nöbö bla ñɨgö pɨl pal nɨgmɨdöi il aku mɨ an mɨdölɨŋö, rön, yadöia. ");
INSERT INTO tmd_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Makwam, nöso auso nöbö mag gwogwo rɨmä akuyöbö, ñɨgö kwo algör cɨnɨŋö, rön cöñ aku, paŋ mag akwör ri! ");
INSERT INTO tmd_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ñɨŋ kas halöu ha bɨlɨk. Mai God nöbö mö mönö diba yadön, rɨn hör yönmɨd möl bö abön wop aku, ñɨŋ ipöxön pödpödiö hör piaku diöñ? Mɨ wöhö! Ödöi ñɨŋ i mɨdenɨm! ");
INSERT INTO tmd_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Makwam, nɨ ñɨgö yadmɨdla, nɨ God mönö yadɨb nöbö bli, rɨb wä yöx nugub nöbö bli, mönö yad nölɨb nöbö bli yad abmön, ñɨgö mɨdɨba umɨjöña, bli pɨl pal nɨgöña, bli bɨ katlö watlö höñ sö pɨl pal nɨgöña, bli Juda mögum rɨb ram möl yuadö piaku pön paiöña, bli bör dumɨdɨŋ nugugɨrön, rɨbɨx mögörɨb adadö aböña. ");
INSERT INTO tmd_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Makwam mɨ, God nöbö mö wä nuŋwa akuyöbö, maduar ör pɨlɨm hö akuyöbö, mönö ömörö ragöña. Adam ha nuŋwa, mag wä rɨ ri abmɨd nöbö Ebol aku, hödnɨŋ nuŋwa pɨgnɨŋ nuŋwa pɨlön, pɨlɨp hön, pɨlɨp hön, mai Berekaia ha nuŋwa Sekaraia nugwo, God höjöpalɨb rama ram möl yuadö kwo, rɨg pön rim rɨgpɨda yörkwo mɨdmɨn nugugɨrön, nugwo mibɨl yöra pɨl pal nɨgmä. ");
INSERT INTO tmd_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nɨ ñɨgö mi yadmɨdla: alöi ap piaku, mönö aku ñɨgö weik mɨdöi kɨyöbö höuöil höna. ");
INSERT INTO tmd_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem nöbö mö, nöbö mö lɨblɨb rɨ nɨ mɨdö bɨlɨk. God mönö yadɨb nöbö God ñɨgö aböŋ nöbö piaku, mögörɨb ñɨgö bla höm, rɨg rödön öim pɨl pal nɨgöia. Nɨ ñɨgö kulakul nuöma ha bla rɨg rɨ akuyöbö, pön hö upɨc mo na nɨgɨnö, rön nɨgɨl aku, jɨ nɨ nugwön röböxöia. ");
INSERT INTO tmd_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","God nuŋ God höjöpalɨb ram ñɨŋ aku röböx duöŋa; yör akwör mɨda. ");
INSERT INTO tmd_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Wopik nɨ nugweñ; mai, ‘God anɨŋ, me rön, agal aböŋ Nöbö wä kɨ yöwi wä hömɨdö,’ cöñ wop akwör iswob nɨ nugwöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas God höjöpalɨb ram aku röböxön, rɨŋadö dum nugugɨrön, nöbö nuŋ bla nugwo yadmä, “God höjöpalɨb ram wä kɨyöbö nugwö!” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Aliö rɨmɨdmɨn, Jisas ñɨgö yadöŋa, “Ñɨŋ ap piaku magalɨg nugwön yadmɨdöi aku, jɨ nɨ ñɨgö mɨ ödöriö yadmɨdla, mai ram kɨ hajalöñ aku, rɨg i rɨg i rola mɨdenɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisas du Olip Pɨd sö römɨd gɨ mɨdmɨn nugugɨrön, nöbö nuŋ rogwa ñɨŋ ñɨŋör hön Jisas nugwo tar yad nugwön yadmä, “God höjöpalɨb rama hajalöñɨŋö, rɨlö aku, wop kai mag akuyöbö cöñ? An ap agapɨm raŋ nugwön, nagö womiöx höba rɨman nugugɨrön, mögörɨb il kɨ hölögɨpɨba rɨmɨdö, rön nugunɨŋö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Aliö rɨmɨdmɨn, Jisas yadöŋa, “Ñɨŋ mɨ ödöriö nugw ri aböña. Nöbö mö bli ñɨgö inakmönö hörön yajöña. ");
INSERT INTO tmd_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nöbö mɨga hön, inakmönö hörön, ib na urön yajöña, ‘Nör Krais,’ me cöña. Nöbö mö mɨga inakmönö höröñ mönö aku yöxön nugw pöña. ");
INSERT INTO tmd_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Womiöx yöraku nuö nuö pɨlɨŋ, bu diba raŋ nugwöña; pad piaku nuö nuö piöñ aku, haiwo akwör haŋ nugwöña. Alaŋ nugwön, wop yoŋyöbö wöxnö nɨgɨba rɨmɨdö, rön, ipöxmɨjeñ. Aku hör nuö nuö pɨlmɨjöña. Wop maiyöbö aku mai döŋö wöxnö nɨgöna. ");
INSERT INTO tmd_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nöbö mö möl bli öbɨlön, nöbö mö möl bli pɨsaŋ nuö nuö rɨmɨjöña. Möl bli kiŋ öbɨlön, möl bli kiŋ pɨsaŋ nuö nuö pɨlmɨjöña. Mögörɨb bla magalɨg mɨmön paŋ, kiö diba wöröxmɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Almɨdaŋ, ñɨgö mö ha nɨmɨm ölɨŋa rɨg pɨlmɨd mag akuyöbö raŋ, womiöx mɨdö, rön, nugwöña. ");
INSERT INTO tmd_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ñɨŋ nöbö mö na mɨjöñ aku döŋö, nöbö mö mögörɨb akuyöbö magalɨg ñɨgö höxön mönö, pön du nag nɨgön, rɨ gwogwam rön, mɨ aŋadö pɨl pal nɨgöña. ");
INSERT INTO tmd_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wop aku, God nugw pöi nöbö mö akuyöbö mɨga nugw pɨb mag ñɨŋa röböxön, nöböhöd möhöd nöbö ñɨŋ bla keir nugwɨŋ, ölɨsö wölaŋ, ñɨgö pön nöbö kwolmal imag rola nɨgöña. ");
INSERT INTO tmd_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Makwam nöbö mö mɨga hön, “An God mönö yadɨb nöbö bɨlɨm,” me rön, inakmönö hörɨŋ, nöbö mö mɨga inakmönö höröñ mönö aku yöxön nugw pöña. ");
INSERT INTO tmd_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nöbö mö piaku mag gwogwo rol aku rɨŋ rɨŋ, magalɨg paŋ mag adakwör rɨbyöx nugwön, madmag nɨgɨb adaku uplöböña. ");
INSERT INTO tmd_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Makwam nöbö mö bɨl kai God mönö wä aku nugw pɨ cɨcɨ nɨgön, rɨg yad mag akwör rön, nöbö mö hör piaku madmag nɨgön rɨ gör mɨjöñ piaku, God nöbö mö piaku ñɨgö magalɨg kömö pöna. ");
INSERT INTO tmd_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Makwam God nöbö mö pön nugwidɨx mɨdɨb mönö wä aku, mögörɨb hör adadö nöbö mö hörɨrör piaku piaku magalɨg yad nölɨm du pörɨba rɨmɨd aku mɨ, wop aku mai wöxnö nɨgöna. ");
INSERT INTO tmd_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Makwam God mönö yadɨb nöbö Daniel maduar rɨg yadöŋ mag akwör cöna. Nuŋ yadöŋa, ‘Ñɨŋ nugwöña, God höjöpalɨb rama ram möl lei yuadö aku, ap hölul mɨ rɨ gwogwam ödöriö rɨb i öbɨl gɨ mɨjönɨŋö,’ röŋa. (Ñɨŋ nöbö mö mönö kɨ wopik ör mämäg nɨg nugumɨdöi bla, mönö kɨ il aku nugw ri aböña!) ");
INSERT INTO tmd_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ñɨŋ nöbö mö mögörɨb Judia mɨjöñ bla, ap gwogwo aku nugwön, rɨmgör bör önöŋ ajmag bla diöña. ");
INSERT INTO tmd_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nöbö mö ram cölöbö sö mɨjöñ bla, ap ana bli pɨnɨŋö, rön, höbkal ram möl yuadö dueñɨm. ");
INSERT INTO tmd_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nöbö mö möriwö rɨba yönmɨjöñ bla, wölɨj mɨxɨla pɨnɨŋö, rön, höbkal rama dueñɨm. ");
INSERT INTO tmd_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Makwam wop aku mö ha wöta alɨg mɨjöñ bla aipam, mö halöu ha kiaia kau nölmɨjöñ bla aipam, bör du öliöxöña. ");
INSERT INTO tmd_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","“Makwam God höjöpalön yajöña, ruö ij rɨ wop aku mönö God höjöpalɨb wop aku bör duöinɨŋö, cöña. ");
INSERT INTO tmd_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Aku agapɨm, God maduö ib hör i mögörɨb rɨ nɨgöŋ wop aku ila nɨgön, mɨdɨp hön weik mɨdöl wop kɨ, ap gwogwo aliö akuyöbö rölöŋ; mai mag akuyöbö alenɨm. ");
INSERT INTO tmd_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Hör möxisöŋö, ap gwogwo aku öim rɨm, nöbö mö magalɨg wöröx pöröyɨxa. Makwam Nöbö Diba, nuŋ pön nöbö mö bla ñɨgö rɨbyöx nugwön, wöhö raŋ, ap gwogwo aku hör ul mɨŋi cöna. ");
INSERT INTO tmd_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Wop aku nöbö mö bli ñɨgö yajöña, ‘Nugwi! Krais mɨd mɨk! Krais mɨd mɨkwo!’ me cöñ aku, jɨ mi yadöiŋö, rön, nugumɨjeñ. ");
INSERT INTO tmd_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nöbö mö bli, God yad nɨgöŋ nöbö mö bla, adöi an ada höŋ, me rön, inakmönö hörön yajöña, ‘Nɨ mɨ Krais; mɨ nɨ God mönö yadɨb nöbö i,’ me rön, ap rölɨbä akuyöbö bli cöña. Makwam God yad nɨgöŋ nöbö mö piaku peñ, wöhö. ");
INSERT INTO tmd_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Makwam, nugw ri aböña. Ap agap bɨlɨm mai bö cön aku, nɨ ñɨgö mödö yadmön nugwöi makwam, nugw ri ab gɨr mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Makwam, nöbö mö bli hön ñɨgö yajöña, ‘Krais hön mɨd mögörɨb rɨg kap mibɨl piaku,’ me rɨmɨjöñ aku, piaku dumɨjeñ. Bli yajöña, ‘Krais hön umad gɨ mɨd pik,’ me rɨmɨjöñ aku, mi yadöiŋö, rön nugumɨjeñ. ");
INSERT INTO tmd_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nɨ Nöbö Ha nuŋwa hön wop aku, añɨgölö ñɨrmɨn, ömegö amej rogwa yau hörɨm mɨlkap rɨb sö rɨb bö du mag akuyöbö alaŋ nugugɨrön, nɨ alɨp höna. ");
INSERT INTO tmd_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Hön mönö döuyö urapɨm i wöröx gɨ mɨjön aku, yöur hön rɨböña. ");
INSERT INTO tmd_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Makwam ömörö dib aku rɨp du pöraŋ nugugɨrön, naiö aku mil aben; röun aku mil aben; adöx sö gupö bla kɨtu pɨñöña; adöx sö ap bla memexön bɨröb i rɨ yönɨbör yönmɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Wop aku, Nöbö Ha nuŋwa höba raŋ nugugɨrön, adöx sö mag keiryöbö raŋ, nöbö mö mögörɨb adadö hörɨrör mɨdöi akuyöbö nugwön imɨjöña. Nöbö Ha nuŋwa Nuö ölɨsö pön, mil wä keiryöbö alɨg mɨjöi wabi bɨl yörsak haŋ nugugɨrön, nugwöña. ");
INSERT INTO tmd_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Namag diba pɨrɨŋ nugugɨrön, ejol nuŋ bla yad abaŋ, ñɨŋ duön, Nöbö Ha nuŋwa, pɨnö, rön yad nɨgöŋ nöbö mö bla pɨba, mögörɨb mɨgrö kɨ rɨg mɨde mɨde aliar pia pia duön, hölu pön nugwo pöl höña. ");
INSERT INTO tmd_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ñɨŋ nugwöia, bɨ röui panö yösa nɨgön, womiöx gö nɨgɨba rɨmɨn nugugɨrön, naiö nɨgɨba rɨmɨdö, rön nugwöia. ");
INSERT INTO tmd_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mag aliö akuyöbö, mai bö ap yadɨl piaku raŋ nugugɨrön, ‘Nöbö Ha nuŋwa höuöil höb wop aku wopik mɨ womiöx mɨda; mag ulul mɨŋi mɨdön, höröpɨnöñɨŋö,’ rön, nugwöña. ");
INSERT INTO tmd_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nɨ ñɨgö mi yadmɨdla, nöbö mö weik mɨdöi bla wöröxeñ, kömö mɨdɨŋ nugugɨrön, ap piaku magalɨg cöna. ");
INSERT INTO tmd_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Adöx sö, mögörɨb mɨgrö kɨ pɨsaŋ hölögɨpöna, jɨ God Mönö mag nuŋwa hölögɨpen. ");
INSERT INTO tmd_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Nɨ mag kaiyöbö, wop kaiyöbö hön wop aku, nöbö mö nugwölöi; ejol bla nugwölöi; nɨ keir God Ha aku, jɨ nɨ aipam nugwöi; Acö nuŋwör keir nugwa. ");
INSERT INTO tmd_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Nɨ Nöbö Ha nuŋwa höbkal hön wop aku, Noa mɨdöŋ wop aku, rɨg mɨdmɨdöi mag akwör rɨmɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Maduar ör Noa mɨdöŋ wop aku, bana wölön nöbö mö akuyöbö ñɨgö pɨ yuö abölöŋ wop aku, ñɨŋ ap nɨm gɨr, röbö nɨm gɨr, nöbö mö pɨ gɨr, algör mɨdɨm nugugɨrön, Noa bɨyöj möla dumɨn, röbö hön ñɨgö magalɨg pɨ yuö aböŋa. ");
INSERT INTO tmd_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Makwam ñɨŋ ap i cönɨŋö, rön, nugwölɨmem; röbö aku ñɨgö pɨ yuö abɨm nugugɨrön yoŋwö nugumä. Mai nɨ Nöbö Ha nuŋwa hön wopa, mag aliö akuyöbö cöna. ");
INSERT INTO tmd_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Wop aku, nöbö mös möriwö rɨba mabö rɨmɨjöñ aku, nöbö i pɨna, i röböxna. ");
INSERT INTO tmd_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Makwam mö mös wit mag pia rɨba, wit maga pal pad piöpi rɨmɨjöñ aku, mö i pɨna, i röböxna. ");
INSERT INTO tmd_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Nöbö Dib ñɨŋa hön wop aku nugwölöi makwam, nugw ri ab gɨr mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nöbö ram mɨnöbö aku, ap kib pɨb nöbö aku wop kai hön aku nugwöxisöŋö, nugw ri aböxa; ram nuŋwa pal waglöx yuadö kwo wölu ap nuŋ piaku kib pölöx. ");
INSERT INTO tmd_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Makwam mag aliö akuyöbö, ñɨŋ kwo algör pɨdɨlu ri abön mɨjöña. Almɨdköp, Nöbö Ha nuŋwa henɨŋö, rön, uplöb wöhamö rön mɨjöñ wop akwör höna. ");
INSERT INTO tmd_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Nöbö dib i adöi dinöb rön, nöbö kai mabö rɨ ri abön aku nugwo yad nɨgön yajöna, ‘Mabö na rɨ nölöi nöbö piaku ñɨgö nugwidɨx mɨdön, ap mag ñɨgö piaku nuöm nɨg ri ab gɨrön rɨ mɨdane,’ rön, diöna. ");
INSERT INTO tmd_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mai höbkal hön nugwöna, yadöŋ mag akwör cöna. Aliö nugwön nugwo mɨ ödöriö pɨ ösös raŋ nugugɨrön, mabö rɨ nölɨb nöbö nuŋwa mɨ ödöriö wahax pɨmɨjöna. ");
INSERT INTO tmd_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nɨ ñɨgö mi yadmɨdla, nugwo yad nɨgaŋ, ap nuŋ bla magalɨg nugwidɨx mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Makwam nuŋ yad nɨgön nöbö aku mɨdɨp duön, nöbö diba weik henɨŋö, rön, ");
INSERT INTO tmd_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","mabö nuŋwa rɨ nölɨb nöbö piaku ñɨgö mɨ göj göj palön, du röbö nɨmön u pɨlöi nöbö bla pɨsaŋ ap nɨmön, röbö nɨmön rɨ mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mabö rɨ nölɨb nöbö aku, nöbö diba yadkap henɨŋö, rön, uplöb mɨjön wop akwör, nöbö diba höna. ");
INSERT INTO tmd_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Hön, nugwo mɨ rɨ gwogwam rön, nöbö mö inakmönö hörön, “An Nöbö Diba nöbö mö nuŋwa mɨdölɨŋö,” rön, inakmönö hörön yadöi nöbö mö piaku pɨsaŋ yad aböna. Yad abaŋ, ñɨŋ du ajmaga öbɨx gɨg yuön, im gör mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“God nöbö mö pön nugwidɨx mɨdɨb wop aku, haiwo aliö kɨyöbö cöna. Nöbö i mö pɨba rɨmɨda. Halöu mö akuyöbö ragpɨd sö ap diba nɨmɨba diöña. Halöu mö piaku, nöbö aku nugwo du ödöi um yöra nugwön yölɨŋ pön rama hönɨŋö, rön, hötɨkö hörɨrör pön diöña. ");
INSERT INTO tmd_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Makwam halöu mö piaku, akuyöbö mömɨd sö rɨbyöx nugw ri aböña; akuyöbö mömɨd sö rɨbyöx nugw ri abeñ. ");
INSERT INTO tmd_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Halöu mö rɨbyöx nugw ri abeñ piaku, hötɨkö pön, hötɨkö urɨb röbö bli alɨg pɨrag dueñ. ");
INSERT INTO tmd_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Makwam halöu mö rɨbyöx nugw ri aböñ piaku, hötɨkö pön, hötɨkö urɨb röbö bli balol möla unön, alɨg pɨrag diöña. ");
INSERT INTO tmd_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Makwam halöu mö piaku ñɨŋ magalɨg uröpɨnön, pöx mɨdɨŋ mɨdɨŋ, mö pɨba cön nöbö aku rɨmgör hen aku, inɨmö pɨlaŋ inɨmö hölɨm diöña. ");
INSERT INTO tmd_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Makwam pɨxmag yuö mibɨl kwo, nöbö mö bli wö rön yajöña, ‘Mö pɨba rɨmɨd nöbö aku weik hömɨda. Nugwo du ödöi um yöra nugwön, yölɨŋ pön höi,’ cöña. ");
INSERT INTO tmd_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Aliö rɨmɨdɨŋ, halöu mö akuyöbö ragpɨd sö magalɨg öbɨlön, hötɨkö wik ñɨŋ bla rɨ ri aböña. ");
INSERT INTO tmd_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Akuyöbö alön, halöu mö rɨbyöx nugw ri abeñ rogw aku, halöu mö rɨbyöx nugw ri aböñ rogw aku ñɨgö yajöña, ‘Hötɨkö an bla wöröxc wöröxc rɨmɨd aku, röbö ñɨgö bla anɨŋ bli nöine,’ cöña. ");
INSERT INTO tmd_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Aliö rɨmɨjöñ aku, jɨ halöu mö rɨbyöx nugw ri aböñ rogw aku yajöña, ‘Ehöu! An röbö ana ñɨgö bli nöinɨŋ aku, röbö an met yöna. Ñɨŋ röbö wobön pɨb ram piaku duön, röbö ñɨŋ keir wobnö,’ cöña. ");
INSERT INTO tmd_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Aliö rɨmɨdɨŋ, röbö wobön pɨb ram piaku diöñ mag aku, mö pɨba rɨmɨjön nöbö aku nuŋ ödöi rɨmgör höröpɨñöna. Halöu mö rɨbyöx nugw ri aböñ rogw aku, nöbö aku pɨsaŋ ram möla yuadö duŋ nugugɨrön, nuŋ uba idɨxöna. ");
INSERT INTO tmd_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Mai piöŋö halöu mö rɨbyöx nugw ri abeñ rogw aku höröpɨnön yajöña, ‘Nöbö dib! Nöbö dib! Uba ana rödö,’ cöña. ");
INSERT INTO tmd_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Aliö rɨmɨdɨŋ, yajöna, ‘Nɨ ñɨgö mi yadmɨdla, nɨ ñɨgö nugumɨdöi pal,’ cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jisas mönö aku yadön nöbö mö bla yadöŋa, “Makwam, ñɨŋ Nöbö Diba wop kaim mag kaim hön makwam nugwölöi aku, nugw ri abön mɨjɨnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Makwam haiwo urɨba rɨmɨdɨl kɨ mag aliö kɨyöbö cöna. Nöbö dib i mögörɨb pad piaku dinöb, mabö rɨ nölɨb nöbö nuŋ piaku ñɨgö wö raŋ höŋ, ap nuŋ bla nugwidɨx mɨdɨŋ, me rön, ñɨgö nöiöna. ");
INSERT INTO tmd_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","16","Nöbö nuŋ piaku, mabö rɨg cöñ cöñ akuyöbö nugwön, rɨg maga nuöm nɨgön, nöbö i nugwo paip tausan nölön, i nugwo tu tausan nölön, i nugwo wan tausan nöiöna. Nölön, nuŋ du piaku mɨdaŋ nugugɨrön, nöbö paip tausan pön aku, rɨg maga aku pön, sɨm rɨ pön du höuöilmel rön, rɨg maga paip tausan hör umi pöna. ");
INSERT INTO tmd_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nöbö tu tausan pön aku, aku kwo algör, rɨg maga aku pön, sɨm rɨ pön du höuöilmel rön, rɨg maga tu tausan hör umi pöna. ");
INSERT INTO tmd_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Makwam nöbö rɨg mag wan tausan pön aku, rag duön, ulöm pön mögö nöiöna. ");
INSERT INTO tmd_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Mai mɨdɨp duön, mabö rɨ nölɨb nöbö piaku nöbö dib ñɨŋ aku höuöil hön, rɨg maga nöil aku pödpöd röiŋö, rön, ñɨgö yad nugwöna. ");
INSERT INTO tmd_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yad nugwaŋ, nöbö paip tausan pön aku, rɨg mag nuŋ aku rag hö nölön yajöna, ‘Nöbö dib, nugwö! Nagö nɨ rɨg mag paip tausan nölmö akwör nɨ rɨg mag pɨd aku pön, sɨm rɨ höuöilmel rɨp hön, rɨg maga paip tausan hör umi pɨl pɨd aku mɨk,’ me cöna. ");
INSERT INTO tmd_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Yadaŋ, nöbö dib aku paiŋö yajöna, ‘Wä ra. Nagö mabö rɨ nölɨb nöbö waiö. Nagö mabö na rɨ nöl ri ab nöilö makwam, ailö maku. Nagö ap ulmɨdö aku aliö ösös rɨ ri ablö aku, nagö yadmön, ap dib bla nugwidɨx mɨjɨnö. Nagö ram na hön, mɨ ödöriö wahax pɨ gɨr mɨdane,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Nöbö rɨg mag tu tausan pön aku, aku kwo algör rɨg mag nuŋ aku rag hö nölön yajöna, ‘Nöbö dib. Nagö nɨ rɨg mag tu tausan nölmö akwör nɨ rɨg mag pɨd aku pön, sɨm rɨ höuöilmel rɨp hön, rɨg maga tu tausan hör umi pɨl pɨd aku mɨk,’ me cöna. ");
INSERT INTO tmd_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Yadaŋ, nöbö dib aku paiŋö yajöna, ‘Wä ra. Nagö mabö rɨ nölɨb nöbö waiö. Nagö mabö na rɨ nöl ri ab nöilö makwam, ailö maku. Nagö ap ulmɨdö aku aliö ösös rɨ ri ablö aku, nagö yadmön, ap dib bla nugwidɨx mɨjɨnö. Nagö ram na hön, mɨ ödöriö wahax pɨ gɨr mɨdane,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Makwam nöbö rɨg mag wan tausan pön aku, rɨg maga nuŋ aku rag hö nölön yajöna, ‘Nöbö dib. Nɨ nagö nugula; nagö nöbö ölɨsöm. Nöbö mö naŋ bli kul wölɨb ñɨŋ röi bla, nagö hör pɨliöx rag hö nɨmlö. ");
INSERT INTO tmd_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nagö ailö mag akuyöbö, nɨ ipöxla, rɨg mag pɨd nölmö aku rag hön, ulöm röx mögö nölmön mɨdmɨd aku, weik rɨg mag nagö rag hö nölmɨdɨl aku mɨk,’ me cöna. ");
INSERT INTO tmd_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Yadaŋ, nöbö dib aku yajöna, ‘Nagö nöbö gwogwo mabö rölɨb nöbö ipɨtɨbɨm. Nöbö mö nɨ kul wölɨb röi bla, hör ap pɨliöx rag hö nɨmlö, rɨlö ä? ");
INSERT INTO tmd_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Makwam, nagö rɨg mag nɨ kɨ pön du rɨg rama nɨglaxisöŋö, weik nɨ hön rɨg mag hör um bli alɨg hör pɨlöx,’ me cöna. ");
INSERT INTO tmd_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Aliö rön, nöbö nuŋ bla ñɨgö yajöna, ‘Akuyöbö al aku, rɨg mag wan tausan aku röd pön, ten tausan mɨd nöbö aku nugwo nöli. ");
INSERT INTO tmd_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Rɨb nöbö mö piaku, ñɨgö bli kwo rol ab nölɨŋ, pön mɨd ri aböña; jɨ mabö rölɨb nöbö mö piaku, ap ulmɨdö ñɨŋ mɨd aku ruöx pɨŋ, hör mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Makwam mabö röl nöbö aku nugwo pön du mɨ pɨxmag gur cɨcɨbö yuö abɨŋ, nöbö mö ajmag öbɨx gɨg yuön, im gɨr mɨdöi alebö bö pɨsaŋ mɨjönɨŋö,’ cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Nöbö Ha nuŋwa Kiŋ diba mɨdön, mil ölɨsö wä keiryöbö alɨp hön wop aku, ejol bla magalɨg pɨsaŋ hön, hogw rol Kiŋa römɨd gɨ mɨdɨb rol aku römɨdaŋ, ");
INSERT INTO tmd_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","nöbö mö mögörɨb hör piaku piaku mɨdöi akuyöbö magalɨg hön, mämäg il nuŋwa mögum rɨŋ nugugɨrön, ñɨgö nuöm nɨg adöi hör nɨgön, adöi hör nɨgöna. Nöbö hön sipsip hön meme uröi nöbö bla, hön sipsip bla hör möl i abön, hön meme bla hör möl i abön röi mag akuyöbö cöna. ");
INSERT INTO tmd_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nöbö mö hön sipsip röxg mɨdöi bla nugwön, pɨ imag mɨrɨx adö nɨgön, nöbö mö hön meme röxg mɨdöi bla nugwön, pɨ imag cökö adö nɨgöna. ");
INSERT INTO tmd_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nuŋ Kiŋ diba makwam, nöbö mö imag mɨrɨx adö ñɨgö yajöna, ‘Acö ñɨgö pɨ ri ab makwam, mɨ ödöriö wahax pi. Nuŋ mögörɨb maduar rɨ nɨgöŋ wop aku, yör ñɨgö aku röb nɨgöŋa. Hön yör waiö aku pi. ");
INSERT INTO tmd_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Aku agapɨm: nɨ kiö pɨlɨm, ap mag röia. Nɨ röbö dep pɨlɨm, röbö nölöia. Nɨ mögörɨb pad piaku nöbö hömön, nɨ yad wahax pön, pön du ram ñɨŋa nɨgöia. ");
INSERT INTO tmd_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nɨ wölɨj mɨdölmɨn, nɨ wölɨja nölöia. Nɨ ap rɨmɨn, nɨ ösös rɨ ri aböia. Naga mɨdmön, nɨ u nugwöiŋö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Aliö yadmɨdaŋ, nöbö mö wä bla nugwo paiŋö yajöña, ‘Nöbö Dib. Wop kai nagö kiö pɨlɨm, ap mag röl? Wop kai nagö röbö dep pɨlɨm, röbö nölöl? ");
INSERT INTO tmd_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Wop kai nagö pad piaku nöbö höman, nagö wahax pön, pön du ram an nɨgöl? Wop kai naŋ wölɨj mɨdölmɨn, nagö wölɨj nölöl? ");
INSERT INTO tmd_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Wop kai nagö ap röŋ mönö nag mɨdmö, an u nagö nugwöl?’ cöña. ");
INSERT INTO tmd_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Aliö yadɨŋ, Kiŋ aku yajöna, ‘Haul nɨ hör i ösös rɨ ri abön röi mag akuyöbö, nɨ algör ösös rɨ ri ablaŋö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ñɨgö aliö rön, nöbö mö imag cökö adaku mɨjöñ akuyöbö ñɨgö yajöna, ‘God ñɨgö nugwön rɨb gwogwo yöx nugumɨda. Nuŋ kɨjaki nugwo aipam, ejol nuŋ bla aipam, ñɨgö ölɨŋ pɨlaŋ nugugɨrön mɨdɨŋ, me rön, yör ñɨŋa rɨn hör yönmɨd yöra rɨ nɨgöŋa. Ñɨŋ nöbö mö gwogwo, ölɨŋ höb diba pɨmɨjöñ bla, nɨ röböxön, rɨn hör yönmɨd möl bö di. ");
INSERT INTO tmd_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Aku agapɨm: nɨ kiö pɨlmɨn, ap mag rölim. Nɨ röbö dep pɨlmɨn, röbö nölölim. ");
INSERT INTO tmd_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nɨ mögörɨb pad piaku nöbö hömön, nɨ yad wahax pön, pön du ram ñɨŋa nɨgölim. Nɨ wölɨj mɨdölmɨn, nɨ wölɨja nölölim. Nɨ ap röŋ mönö nag mɨdɨm aku, ñɨgö hön nɨ ösös rɨ ri abölöiŋö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Kiŋ aku aliö yadmɨdaŋ, nugwo yajöña, ‘Nöbö Dib. Wop kai nagö kiö pɨlɨm, ap mag rölöl? Wop kai nagö röbö dep pɨlɨm, röbö nölölöl? Wop kai nagö pad piaku nöbö höman, nagö wahax pön, pön du ram an nɨgölöl? Wop kai nagö wölɨj mɨdölmɨn, nagö nölölöl? Wop kai nagö ap röŋ mönö nag mɨdmö aku, an u nagö nugwölölɨŋö?’ cöña. ");
INSERT INTO tmd_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Aliö yadɨŋ, Kiŋ aku paiŋö yajöna, ‘Nɨ ñɨŋ mi yadmɨdla, ñɨŋ nöbö mö hör nɨ i ösös rɨ ri abölöi makwam, nɨ algör ösös rɨ ri abölöiŋö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Aliö rön, ñɨgö yad abaŋ duön, öim öim ölɨŋ pɨlaŋ nugugɨrön mɨdɨb yöra diöña; jɨ nöbö mö wä nuŋ bla yadaŋ, ñɨŋ öim öim kömö mɨdɨb mögörɨb yör waiö diöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisas mönö aku yadön, nöbö nuŋwa akuyöbö möl sö piaku ñɨgö yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ñɨŋ nugwöia, wop mös mɨdön, Pasopa wop dib aku weik, me rön, hö mögum rön hör mɨjöña. Jɨ ñɨŋ algör hö mögum rön, nɨ Nöbö Ha nuŋ aku, pɨ gapman nöbö dib akuyöbö nölön yajöña, ‘Nugwo bɨ katlö watlö höñ sö pɨl pal nɨgɨŋ,’ me cöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Makwam God ap höjöpal ur nölɨb nöbö dib bla aipam, mönö pɨ nuöm nɨgɨb nöbö bla aipam hön, God ap höjöpal ur nölɨb nöbö dib ödöriö Kaiapas ram dib nuŋ aku mögum rön, ");
INSERT INTO tmd_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Jisas nugwo pödpöd rön, tar pɨ cɨcɨ nɨgön, pɨl pal nɨgnɨŋö, rön, mönö yad nɨgmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Makwam ñɨŋ yadmä, “Pasopa ap nɨmɨb hör mɨdɨb wop kɨ, an alön rɨŋ, nöbö mö magöri rɨg mɨdöi kɨyöbö nuö nuö pɨb maga ra. Makwam, weik röböxön, wop i nugwo pɨl pal nɨgnɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","7","Jisas ram yöj lɨglɨg agrö Betani du mɨdön, Saimon uj höpebö höd nɨgöŋa nöbö aku ram nuŋwa du römɨdön ap nɨmmɨdmä. Ap nɨmmɨdmɨn nugugɨrön, mö i ap wel röbö hölɨŋ wä höb, rɨg diba woböi aku, balol alɨg pön hön, Jisas yöcmac sö rola höröŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","9","Hörmɨn, Jisas nöbö nuŋ bla nugum, höbwab ñɨŋa gwogwo rɨmɨn, yadmä, “Wel aku pön duön rɨg diba pön, nöbö mö ap mɨdöl bla ñɨgö nölɨbä rɨgɨb aku, jɨ pödpöd rɨmɨn aliö nöi hör owa?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Mönö aku yadmɨdmɨn, Jisas nuŋ keir nugwön, ñɨgö yadöŋa, “Mö kɨ nuŋ nɨ mag wä rɨ ri ab aku, pödpöd rɨmɨn aliö rɨmɨdöi? ");
INSERT INTO tmd_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nöbö mö ap mɨdöl piaku ñɨŋ pɨsaŋ öim mɨjöña, jɨ nɨ ñɨŋ pɨsaŋ öim mɨdöinɨŋ. ");
INSERT INTO tmd_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nöbö mö wöröxɨm, nöbäpö hogw pɨlɨba rön, wel röbö nɨg nölön pön du hogw pɨlöia. Nɨ hogw pɨlɨba rön rɨmɨdöi makwam, nuŋ wel röbö aku mɨxɨñ na nɨg nöla. ");
INSERT INTO tmd_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Makwam nɨ ñɨgö mi yadmɨdla, mai mögörɨb mɨgrö kɨ hör piaku piaku magalɨg, mönö waiö na aku yad gɨr, mö kɨ alön rɨ mag kɨ haiwo urön alöŋ aku uplöbeñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","15","Wop aku, Jisas nöbö nuŋwa Judas Iskariot, Jisas nugwo höuöu rɨ pön du nölmön pɨl pal nɨgɨŋ, me rön, God ap höjöpal ur nölɨb nöbö dib bla ñɨgö yadɨba duöŋa. Duön yadöŋa, “Nɨ Jisas nugwo höuöu rɨ pön hön ñɨgö nöin aku, nɨ paiŋö agapɨm nöiöñɨŋö?” röŋa. Aliö rɨmɨn, nugwo silpa mag padokwo paŋyöbö i höuöiliö hö wölu mɨj sö (30) nölmä. ");
INSERT INTO tmd_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nölmɨn, Judas nuŋ, “Nɨ pödpöd rön Jisas nugwo höuöu rɨmön, nugwo pɨ cɨcɨ nɨgön pön diöñɨŋö,” rön, aku rɨbyöx nugugu mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mai ap nɨmɨb diba Bred Is Mɨdölö röi wop aku ila nɨgmɨn, wop agñɨŋ yöbö akwör, nöbö nuŋ bla Jisas mɨdöŋa hön yadmä, “Pasopa sipsip ha pal nɨmɨb wop aku womiöx mɨda. Makwam, an ram kai duön ap nɨmɨb yöra pɨdɨlu ri abnɨŋ?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Aliö rɨmɨdmɨn, Jisas ñɨgö yadöŋa, “Ñɨŋ taun dib aku duön, nöbö i mɨd yöraku ram nuŋwa duön nugwo yajöña, ‘Mönö yad nölɨb nöbö yada, “Wop na aku igöp mɨdam, nöbö nɨ bla pɨsaŋ hön sipsip ha pal ur nɨmɨnɨŋ ram nagö aku,” me rö,’ cɨne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jisas aliö rɨmɨn, nöbö nuŋ bla yadöŋ akuyöbö nugwön, duön hön sipsipa ram aku pal urön, rɨ pɨdɨlu ri abmä. ");
INSERT INTO tmd_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Höxi röŋ mag aku, nöbö nuŋwa akuyöbö möl sö bla pɨsaŋ römɨdön, ");
INSERT INTO tmd_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ap nɨm gɨr yadöŋa, “Nɨ ñɨgö mi yadmɨdla, ñɨŋ nöbö i nɨ höuöu rɨ pön diönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jisas aliö rɨmɨn, nöbö nuŋ piaku rɨb mɨga yöxön, paŋ paŋ nugwo yad nugu gɨrön yadmä, “Nöbö Dib! Nɨ yadlaŋ ä?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Aliö rɨmɨdmɨn, yadöŋa, “Nöbö nɨ pɨsaŋ kwosö möl paŋyöbö i nɨmmɨdöl kɨ, nɨ höuöu rɨ pön diöna. ");
INSERT INTO tmd_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","God Mönö aku maduar kai kɨtön rɨg yadim mag akuyöbö, nɨ höuöu rɨ pön duön, pɨl pal nɨg gɨŋ wöröxɨn aku, jɨ nöbö nɨ höuöu rɨ pön diön aku, God nöbö aku nugwo rɨ gwogwam cöna. Nuöma nugwo yöx pön hölöxisöŋö waiö. Makwam yöx pön höm, mɨd gɨr aliö alön cön aku, mai ölɨŋ höb diba ödöriö pönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jisas aliö rɨmɨn, nöbö nuŋ Judas, nugwo höuöu rɨba röŋ aku yadöŋa, “Mönö yad nölɨb nöbö. Nɨ yadöianö ä?” röŋa. Aliö rɨmɨn Jisas yadöŋa, “Mɨ nagö yadmɨdlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ap nɨm mɨd gɨrön, Jisas breda pön, God nugwo ri ablaŋe rön, pɨ gɨlɨxön, nöbö nuŋ bla ñɨgö nöl gɨrön yadöŋa, “Ñɨŋ pɨ nɨmi. Aku mɨxɨñ na aku,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Aliö rön, röbö wain namag aku, algör pön, God nugwo ri ablaŋe rön, ñɨgö nöl gɨrön yadöŋa, “Ñɨŋ magalɨg nɨmi. ");
INSERT INTO tmd_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Aku hañ na pɨñön aku. Pɨnaŋ, God höd gör yadöŋ mönö aku ölɨsö pɨlaŋ diöna. Pɨnaŋ, nöbö mö mɨga ap kib mag gwogwo röi akuyöbö, God nugwön röböxönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Jisas aliö rön yadöŋa, “Nɨ ñɨgö yadmɨdla, röbö wain kɨ weik bli kwo nɨmöin. Mai, God nöbö mö pön adöx yöd röul adö kau sö nugwidɨx mɨdɨb wop akwör, nɨ iswob ñɨŋ pɨsaŋ röbö wain yoŋyöbö nɨmnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Aliö yadön, nöbö nuŋ bla pɨsaŋ God iba yadɨŋ bɨl sö dub wopal i yad gɨrön, Olip Pɨda dumä. ");
INSERT INTO tmd_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jisas yadöŋa, “God Mönö aku kai kɨtön yadmä, ‘Nɨ hön sipsip urɨb nöbö aku nugwo pal nɨgmön, hön sipsip nuŋ bla magalɨg bör diöñɨŋö,’ rɨmä. Aliö yadmä aku mɨ, mɨdiö pɨxmag yuö mibɨl kwo ñɨŋ magalɨg nɨ röböxön bör diöña. ");
INSERT INTO tmd_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Makwam nɨ wöröxön öbɨlön, mögörɨb Galili höd dumɨjɨna, ñɨŋ mai yöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Jisas aliö rɨmɨn, Pita yadöŋa, “Nöbö magalɨg nagö röböxön höglöm nölɨbä maga röia, jɨ nɨ akuyöbö alöinö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Pita aliö rɨmɨn, Jisas yadöŋa, “Nɨ nagö mönö mi yadmɨdla, pɨxmag yuö mibɨl kwo yöur kulakula wö rölɨbör mɨjön wop aku, ‘Jisas nugwo nugumɨdöiö,’ rön, wab mös paŋ yajnaŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Jisas aliö rɨmɨn, Pita ususör rön yadöŋa, “Nɨ pɨl pal nɨgnöb, pɨl pal nɨgöñ aku jɨ, ‘Jisas nöbö nɨ yöi,’ me rön yadöinö,” röŋa. Jisas nöbö nuŋ bla magalɨg algör Pita rɨg yadöŋ akwör yadmä. ");
INSERT INTO tmd_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jisas nöbö nuŋ bla pɨsaŋ Getsemani bɨ yuö duön, nöbö nuŋ bli ñɨŋ yadöŋa, “Ñɨŋ yörɨk römɨd gɨ mɨjöña. Nɨ yörkwo duön, Acö nugwo höjöpal gɨr mɨjɨnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jisas aliö rön, Pita, Sebedi ha nuŋ mös Jems Jon yöŋö rɨgɨr ñɨgö yölɨŋön duöŋa. Du gɨrön, Jisas nuŋ rɨb mɨga yöxön, ");
INSERT INTO tmd_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ñɨŋ nöbö ada yadöŋa, “Nɨ ömörö diba rɨmɨn, madmag na ölɨŋa kai rɨbi röxɨm, wöröxɨb maga rɨmɨda. Ñɨŋ yörɨk mɨdön, nɨ nugugu mɨjɨnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jisas aliö rön, ñɨgö yöraku yad nɨgön, nuŋ hör womiöx yörakwo duön, iröpa ubɨlön, haŋaj mämäg yuö aku mögö bö cɨrön, God höjöpalön yadöŋa, “Acö, ap nɨ rɨba rɨmɨd aku, wöhö cɨnöb, wöhö rö. Jɨ nɨ rɨbyöx nugul adaku rɨmɨjɨnö; rɨb naŋ keir rɨg yöxlö mag akwör rane,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jisas aliö rön, höbkal hön nugumɨn, nöbö nuŋ bla inɨmö hölɨm gɨ mɨdmä. Jisas Pita nugwo yadöŋa, “Ñɨŋ ul mɨŋi nɨ mämäp pɨ mɨdölöiŋ ä? ");
INSERT INTO tmd_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ap gwogwo rɨb maga rö, rön, God höjöpal gɨr mɨjöña. Rɨb ñɨŋa rɨb maga ra, jɨ mɨxɨñ ñɨŋa höx rɨ pɨnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jisas aliö rön, iswob du Nuö höjöpalön yadöŋa, “Ap nɨ cɨnöb raŋ ölɨŋ höb pɨn aku, röböxɨb maga mɨdöl aku, amɨn raŋ; rɨb naŋ keir rɨg yöxlö mag akwör rane,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jisas aliö rön, iswob höuöil hön nugumɨn, nöbö nuŋ bla inɨmö göj nɨgɨm, hölɨm gɨ mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jisas höuöil duön, Nuö höd höjöpalön rɨg röŋ mag akwör iswob höjöpalön, ");
INSERT INTO tmd_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","höuöil hön, nöbö nuŋ akuyöbö ñɨgö yadöŋa, “Ñɨŋ mɨxɨñ ñɨŋa höx rɨ pɨnɨm, hölɨm gɨ mɨdöiŋ ä? Nöbö ruai nugwi! Nöbö nɨ Nöbö Ha nuŋwa höuöu rön, nöbö ap kib mag gwogwo röi piaku nölɨba rɨmɨda. ");
INSERT INTO tmd_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Öbɨlɨŋ duŋ! Nugwi! Nɨ höuöu rɨ nöbö hömɨd mɨk,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas mönö yadmɨn nugugɨrön, nöbö nuŋwa akuyöbö möl sö i, Judas, God ap höjöpal ur nölɨb nöbö dib bla aipam, mönö pɨ nuöm nɨgɨb nöbö bla aipam, nugwo rɨg yadmä aliar, nöbö ñɨŋ mɨg mɨŋa akwör höröpɨnmä. Ñɨŋ yu mɨxɨl ölɨsö me bli palɨb kaiö bli pön rag hömä. ");
INSERT INTO tmd_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas höd ñɨgö yad nɨgön yadöŋa, “Nɨ du nöbö i nugwo wahax pön, alguna bɨmɨl nɨmmɨjɨn aku, nöbö maku, me rön, nugwo pɨ cɨcɨ nɨgön, pön di,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Makwam Judas nuŋ Jisas mɨdöŋ yöra rɨmgör hön, “Mönö yad nölɨb nöbö, nagö mɨdlö ä?” rön, nugwo alguna bɨmɨl nɨmöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Almɨn, Jisas yadöŋa, “Nöbö mɨk. Rɨba rɨmɨdlö ap aku yadkap rö!” röŋa. Jisas aliö rɨmɨn, nöbö Judas pɨsaŋ hömä akuyöbö Jisas nugwo pɨ cɨcɨ nɨgmä. ");
INSERT INTO tmd_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jisas pɨ cɨcɨ nɨgɨm nugugɨrön, Jisas nöbö nuŋ i yu mɨxɨl ölɨsö nuŋ me pugul pön, God ap höjöpal ur nölɨb nöbö dib ödöriö aku nöbö mabö nuŋwa rɨ nölmɨd nöbö i, nugwo rɨmɨj adöi mɨ aŋadö römal cö gɨ aböŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Almɨn, Jisas nugwo yadöŋa, “Yu mɨxɨl ölɨsö pɨlö aku höbkal möla röbö. Nöbö mö yu mɨxɨl ölɨsö pön nuö nuö rɨmɨjöñ akuyöbö, adakwör wöröxöña. ");
INSERT INTO tmd_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nɨ ‘Acö ake!’ rɨlöxisöŋö aku, nuŋ rɨmgör ejol rogw akuyöbö möl sö hörɨrör yad abmɨn, hön nɨ nugwidɨx mɨdöyɨxa. ");
INSERT INTO tmd_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Makwam höd gör God Mönö aku kai kɨtön, nɨ al aliö rön wöröxönɨŋö, rim makwam, akuyöbö alaŋ. Mag nɨ i keir rɨmɨjɨn aku, wä renɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Makwam Jisas nöbö nugwo pɨba höm piaku ñɨgö yadöŋa, “Nɨ öim du God höjöpalɨb ram aku römɨdön, nöbö mö akuyöbö ñɨgö mönö yad nöil aku, jɨ nɨ pölöim. Weik piöŋö, yu mɨxɨl ölɨsö alɨg, palɨb kaiö alɨg pɨrag hö, ap kib pɨb nöbö i röxgɨb nɨ pɨba hömɨdöi. ");
INSERT INTO tmd_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ñɨŋ almɨdöi aku, God mönö yadɨb nöbö bla God Mönö kai kɨtön rɨg yadim mag akwör rɨmɨdöiŋö,” röŋa. Makwam wop aku, Jisas nöbö nuŋ bla magalɨg nugwo röböxön bör dumä. ");
INSERT INTO tmd_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Makwam God lo mönö yad nölɨb nöbö bla aipam, mönö pɨ nuöm nɨgɨb nöbö bla aipam, hö mögum rɨmɨdim nöbö Kaiapas God ap höjöpal ur nölɨb nöbö dib ödöriö aku ram nuŋwa yörakwam, Jisas nugwo pɨ cɨcɨ nɨgön, pön ram aku dumä. ");
INSERT INTO tmd_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Makwam Pita nuŋ mai mai duön, rama rɨŋadö bö mɨdön, God höjöpalɨb rama ömdö nöbö bla pɨsaŋ römɨdön, agö magɨm cöñɨŋö, rön, nugugu mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","God ap höjöpal ur nölɨb nöbö dib bla aipam, Juda Kansol dib bla aipam yadmä, “An nöbö inakmönö hörɨb nöbö bli ñɨgö yad nugwɨŋ, ñɨŋ mönö i yadɨŋ, ödöriar mɨdaŋ, mönö il aku maku, me rön, Jisas nugwo pɨl pal nɨgnɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Aliö yadmä aku, jɨ mönö aku hörɨrör dumɨn, Jisas nugwo pɨl pal nɨgɨb il i mɨdölöŋ. Alöŋ aku, jɨ mai nöbö mös hön yadmä, ");
INSERT INTO tmd_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Nöbö kɨ yadöŋa, ‘God höjöpalɨb ram aku pɨ gɨlɨx abön, mödö wop mös paŋ iswob ur nɨgɨnö,’ rö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Aliö rɨmɨdmɨn, God ap höjöpal ur nölɨb nöbö dib ödöriö aku, Jisas nugwo yadöŋa, “Mönö nagö yadmɨdöi aku, naŋ paiŋö i yadöinö ä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Aliö rɨmɨn, Jisas paiŋö mönö i yadölöŋ. Almɨn, God ap höjöpal ur nölɨb nöbö dib ödöriö aku yadöŋa, “Weik mönö diba yadɨba mɨdöl kɨ, inakmönö hörön yadmɨjɨnö. God öim kömö mɨd aku, algör nugugu mɨda. Makwam, anɨŋ ödöriar yadö: nagö Mesaia aku, God Ha nuŋ mönö wöhö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Aliö rɨmɨn, Jisas yadöŋa, “Naŋ yadlö maku. Makwam ñɨŋ magalɨg nugwi! Nɨ ñɨgö yadmɨdla, nɨ Nöbö Dib ölɨsö keiryöbö ödöriö aku imag mɨrɨx nuŋ ada mɨdön, mɨjöi wab bɨl yör sö hön mögörɨb il kɨ hömɨjɨn aku nugwöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jisas aliö rɨmɨn, God ap höjöpal ur nölɨb nöbö dib ödöriö aku, wölɨj nuŋ bla hör pɨ waglöx gɨrön yadöŋa, “Nuŋ God ib aku yad höimöumɨn nugwöia! Makwam, nöbö mö bli yad nugwöinɨŋ. Nuŋ gwogwam rɨ aku wöxnö yad maku pal. ");
INSERT INTO tmd_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Makwaim ñɨŋ rɨb pödiö yöxmɨdöi?” röŋa. Aliö rɨmɨn, yadmä, “Mi yad maku pal; wöröxön paŋyöbö makwör,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Aliö yadön, haŋaj mämäg yuö nuŋ ada höpöl pɨlön, palön, rɨmä. Bli Jisas mämäg yuö nuŋwa pöröb nölön, algun nuŋwa akuyöbö pal gɨr, ");
INSERT INTO tmd_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","yadmä, “Nagö Mesaia aku, yön nagö palmɨd aku, an yadaŋ nuguŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Makwam Pita mönö diba yadɨb rama rɨŋadö bö römɨd gɨ mɨdöŋ makwam, God ap höjöpal ur nölɨb nöbö dib ödöriö aku mabö nugwo rɨ nölmɨd halöu i hön nugwo yadöŋa, “Nagö Jisas nöbö Galili yöbö aku pɨsaŋ mɨdlaŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Aliö rɨmɨn, Pita nöbö mö bla magalɨg nugugu mɨdɨm nugugɨrön, yadöŋa, “Mönö naŋ yadmɨdlö aku nɨ nugwöiö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pita aliö rön, öbɨlön, du ubalɨja il yöra mɨdmɨn nugugɨrön, ram aku mabö rɨmɨdöŋ mö i hön, Pita nugwo nugwön, nöbö mö mɨdim akuyöbö ñɨgö yadöŋa, “Nuŋ nöbö Jisas Nasaret yöbö aku pɨsaŋ mɨdmɨn nugulö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Aliö rɨmɨn, Pita wai nölön yadöŋa, “Nɨ mɨ ödöriö yadmɨdla, yadmɨdöi nöbö aku nɨ nugumɨdöiö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ul mag mɨŋi mɨdön, nöbö mö Pita pɨsaŋ öbɨl gɨ mɨdim bla nugwo yadmä, “Mör yadöla. Nagö nöbö ñɨŋ i. Aj il ñɨŋ rɨg yadöi akuyöbö naŋ kwo aliar yadlaŋe,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Aliö rɨmɨn, Pita bölölö rön yadöŋa, “Nɨ ñɨgö mɨ ödöriö yadmɨdla. Hör aku, God nɨ ölɨŋ höb pɨ nöiön aku waiar. Nöbö ñɨŋ yadmɨdöi aku nɨ nugumɨdöiö!” röŋa. Aliö rɨmɨn nugugɨrön, rɨba yöur kulakula wö röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kulakul wö rɨm, Pita Jisas mönö nugwo höd yadöŋ aku rɨbyöx nugwön rɨb mɨxɨla yöxöŋa. Aku agapɨm: Jisas yadöŋa, “Yöur kulakula wö rölɨbör mɨjön mag aku, ‘Jisas nugwo nugumɨdöiö,’ rön, wop mös paŋ yajnaŋö,” röŋa. Aku rɨbyöx nugwön, rɨb mɨga yöxön, rɨŋadö duön, mɨ göj imöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ruö yöudöŋdöŋ röxöŋa nugwön, God ap höjöpal ur nölɨb nöbö dib bla aipam, mönö pɨ nuöm nɨgɨb nöbö bla aipam, mönö yad nugwob du mönö paŋyöbö i yad ödör nɨgön, Jisas nugwo pɨl pal nɨgnɨŋö, rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Makwam, Jisas nugwo nag nɨgön, pön duön gapman nöbö dib gapna Pailot nölmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Makwam Jisas nugwo mönö diba yadön, pɨl pal nɨgɨba rɨmɨdɨm nugwön, Judas, pödpöd rɨmɨn nɨ Jisas nugwo höuöu rɨlö, rön, rɨg maga pöŋ aku, God ap höjöpal ur nölɨb nöbö dib bla aipam, mönö pɨ nuöm nɨgɨb nöbö bla aipam, röd pön du ñɨŋ nölɨba rön, God höjöpalɨb rama duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Duön, rɨg mag piaku ñɨgö nöl gɨr yadöŋa, “Jisas gwogwam röl aku, jɨ nɨ nugwo höuöu rɨl aku, mödö wöröxöna. Makwam, nɨ ödöriö mag gwogwo rɨlö,” röŋa. Aliö rɨmɨn, ñɨŋ yadmä, “Aku ap an yöi. Naŋ keir ailaŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Aliö rɨmɨn, Judas rɨg mag nölmä aku God höjöpalɨb ram möl yuadö abön, du nag nɨmöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","God ap höjöpal ur nölɨb nöbö dib bla, rɨg maga aku pön yadmä, “Rɨg kɨ, nöbö pɨl pal nɨgnɨŋö, rön, höuöu rɨmɨŋ makwam, God nölɨb maga mɨdölö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Aliö yadön, mönö yad nugwob duön yadmä, “Pad nöbö hön wöröxɨŋ, pön du hogw pɨlɨb aku, mögörɨb möl i wobɨŋö,” rön, du nöbö i mögö wödön wi yöja rɨmɨd mögörɨb möl aku wobmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mögörɨb möl aku, höuöu rɨ nölim rɨg aku pön wobim makwam, mai nöbö mö mögörɨb möl aku iba “Mögörɨb Hañ Kap” me rɨmä. Weik kwo algör mögörɨb möl aku iba “Mögörɨb Hañ Kap” me röia. ");
INSERT INTO tmd_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Makwam ñɨŋ mögörɨb wobmä aku, God mönö yadɨb nöbö Jeremaia höd rɨg yadön kai kɨtöŋ mag akwör rɨmä. Nuŋ God Mönö aku um mɨŋi kai kɨtön yadöŋa, “Ñɨŋ rɨg silpa mag padokwo paŋyöbö i höuöiliö hö wölu mɨj sö (30) aku, Juda nöbö mö yadim rɨg aku piöx rag duön, ");
INSERT INTO tmd_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","nöbö mögö wödön wi yöja rɨmɨd mögörɨb möl aku wobmä. Nöbö Diba nɨ rɨg yadöŋ mag akwör röiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisas nugwo pön duön, gapman nöbö dib Pailot mɨdöŋ yöra dum nugugɨrön, Pailot Jisas nugwo yadöŋa, “Nagö Juda ada kiŋ dib ñɨŋa mɨdlö ä?” röŋa. Aliö rɨmɨn, Jisas yadöŋa, “Mi yadlö maku pal,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Makwam God ap höjöpal ur nölɨb nöbö dib bla aipam, mönö pɨ nuöm nɨgɨb nöbö bla aipam, nugwo mönö bli yadmɨdɨm, nuŋ paiŋö mönö i yadölöŋ. ");
INSERT INTO tmd_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Almɨn, gapman nöbö dib Pailot yadöŋa, “Nagö ailaŋö, rön, mönö hörɨrör yadmɨdöi aku, naŋ nugwöianö ä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Aliö rɨmɨn, Jisas mönö paiŋö i yadölmɨn, Pailot rɨb mɨga yöxöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","19","Makwam Pailot nuŋ mönö pɨ nuöm nɨgɨb nöbö dib bla hogw rola römɨd gɨ mɨdmɨn nugugɨrön, mönɨŋa mönö i yadmɨn, höm yadöŋa, “Nɨ maduö pɨxmag yuö kwo inɨmö nugula, mönö diba yadmɨdlö nöbö aku nöbö waiö mɨdöm. Nugwo mönö ölɨsö yadmɨjɨnö. Nɨ inɨmö nugul aku rɨb mɨga yöxmɨdlö,” röŋa. Makwam Pailot rɨb nuŋ keir akwör yöx nugwöŋa, Jisas ap i rölöŋ; nöbö dib pia ñɨŋ nugwo nugum, ölɨsö wölmɨn, pön höia. Makwam, nɨ agö magɨm rön, nugwo yad abmön diönɨŋö, rön, rɨb aku yöx nugwöŋa. Makwam Rom gapna nöbö dib aku öim kɨm aku kɨm aku Juda ada Pasopa wop dib aku, ñɨgö kɨlabɨs nöbö ñɨŋa keir yad nugumɨdöi aku, hör yau abmɨda. Wop aku, nöbö gwogwo ödöriö i naga mɨdöŋa; ib nuŋwa Barabas. Nöbö mö mɨga akwör hö mögum rɨmɨdim bla, Pailot ñɨgö yadöŋa, “Ñɨgö nöbö kai hör yad abɨn? Jisas, Mesaia aku me röi aku mönö Barabasɨm yad abɨn?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Aliö rɨmɨn, God ap höjöpal ur nölɨb nöbö dib bla aipam, mönö pɨ nuöm nɨgɨb nöbö bla aipam, nöbö mö akuyöbö yadmä, “Ñɨŋ Pailot nugwo yadɨŋ, Barabas yau abön kwönö, Jisas nugwo pɨl pal nɨgaŋ,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Makwam Pailot nöbö mö hö mögum rɨ mɨdim bla ñɨgö yadöŋa, “Nöbö hogw kɨ, nöbö kai yau abɨn?” röŋa. Aliö rɨmɨn yadmä, “Barabas yau abane,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Aliö rɨmɨn, Pailot yadöŋa, “Aliö yadmɨdöi aku, Jisas Mesaia aku me röi aku, nugwo pödpöd cɨnö?” röŋa. Aliö rɨmɨn, ñɨŋ magalɨg yadmä, “Nugwo bɨ katlö watlö um sö pɨl pal nɨgɨŋ!” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Aliö rɨmɨn, Pailot yadöŋa, “Aku agapɨm? Nuŋ ap agapɨm rɨ gwogwam rɨ?” röŋa. Aliö rɨmɨn, mönö yadöŋ aku yöxölön, mönö wör wöriö yadmä, “Nugwo bɨ katlö watlö um sö pɨl pal nɨgɨŋ! Nugwo bɨ katlö watlö um sö pɨl pal nɨgɨŋ!” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Aliö rɨmɨn, Pailot rɨbyöx nugwöŋa, mönö na yöxeñ; jɨ mönö bli kwo ñɨŋ yad nugumön, nuö nuö pɨb maga rö, rön rɨbyöx nugwöŋa. Aliö rɨbyöx nugwön, nöbö mö piaku mämäg il rol ñɨŋa imaga röbö pɨ äbäd abön, ñɨgö yadöŋa, “Nöbö kɨ nugwo pɨl pal nɨgɨba rɨmɨdöi aku, mönö aku nɨ hen; ñɨŋ keir höbkal yönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Aliö rɨmɨn, nöbö mö piaku magalɨg yadmä, “Aku nöbäpö yöj ana keir! Hañ nuŋwa an wob paŋ, rɨba ha an bla pöna! Mönö aku, an aipam halöu ha an bla aipam pönɨŋö!” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Aliö rɨmɨdmɨn, Pailot Barabas ñɨŋa yau abön, Jisas nugwo ami nöbö nuŋ bla nölmɨn, ñɨŋ naga pön Jisas palmä. Akuyöbö almɨn, Pailot nuŋ Jisas nugwo bɨ katlö watlö um sö pɨl pal nɨgɨŋ, me rön, ami nöbö nuŋ bla ñɨŋ nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gapna Pailot ami nöbö nuŋ bla, Jisas nugwo pön, pön du ram dib ñɨŋ aku duön, ami nöbö hör piaku ñɨgö magalɨg wö rɨmɨn, ");
INSERT INTO tmd_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","hö mögum rön, wölɨj nuŋwa röd abön, wölɨj paskwolö, nöbö dib yömöi akuyöbö i rag hö, nugwo yöm nölmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Yöm nölön, nag kaigap alɨg bla pön hön, kiŋ adö röbön röi usaŋ akuyöbö i rön, nugwo nɨg nölön, nöbö dib bla kaiö pöiŋö, rön, aiwölö yöd mɨxɨl i pön Jisas nugwo imag mɨrɨx pɨlö nölön, hön nugwo höxmax yuön, yad höimöu gɨr yadmä, “Nöbö dib nagö hömɨdlanö ä? Juda ada kiŋ ñɨŋa nagö hömɨdlanö ä?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Aliö yadön, nugwo höpöl pɨlön, aiwölö yöd aku ruöx pön, nugwo yöcmaca palmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Makwam Jisas nugwo aliö yad höimöuön, wölɨj paskwolö nugwo yöm nölim aku pɨ röd abön, wölɨj nuŋwa keir yöm nölön, nugwo bɨ katlö watlö um sö pɨl pal nɨgɨba yölɨŋ pön dumä. ");
INSERT INTO tmd_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ödöi mibɨl yöra du gɨrön nugumɨn, Sairini taun yöbö nöbö i hömɨdöŋa. Ib nuŋwa Saimon. Nugwo möigw palön, ususör rön yadmä, “Jisas nugwo pɨl pal nɨgɨb bɨ katlö watlö wab kɨ pɨrag duö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Aliö rɨmɨn, nuŋ pɨrag gɨr, mögörɨb Golgota pɨda dumä. Golgota rɨmɨdöi aku mönö il aku, “Nöbäpö Yöcmac Yöj Lei.” ");
INSERT INTO tmd_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Makwam pɨd aku uröpɨnön, ami nöbö bla röbö wain pön, röbö acɨx i pön, alɨg pɨ römerömö rön, Jisas nölmä jɨ nuŋ nɨm nugwön röböxöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jisas nugwo bɨ katlö watlö um sö pɨl pal nɨgön, wölɨj nuŋ bla nuöm nɨg hörɨrör pɨba, höbai sadu akuyöbö wobön pɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Akuyöbö alön, Jisas nugwo bɨ katlö watlö um sö pɨl pal nɨgim il yöra römɨdön nugwidɨx mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jisas nugwo pɨl pal nɨgön, bɨ katlö watlö höñ sö kai kɨtmä: ");
INSERT INTO tmd_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Makwam Jisas nugwo pɨl pal nɨgön, nöbö ap kib pɨb hogwa, i adöi, i adöi, pɨl pal nɨgmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Nöbö mö ödöi diba uhömɨdim bla, yöcmaca kwatkwat rön, nugwo yad höimöuön yadmä, “Nagö God Ha nuŋ aku! God höjöpalɨb ram aku pɨ hajal abön, wop mös paŋ iswob ur nɨgɨnö, rɨlö makwaim, bɨ katlö watlö um sö röböx pɨnaŋ, an nuguŋö!” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","God ap höjöpal ur nölɨb nöbö dib aipam, lo mönö yad nölɨb nöbö aipam, mönö pɨ nuöm nɨgɨb nöbö aipam, ñɨŋ algör nugwo yad höimöuön yadmä, ");
INSERT INTO tmd_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Nöbö mö bli ñɨgö rɨmɨdmɨn kömö duöia, jɨ nuŋ keir alɨb maga mɨdöl. Isrel Kiŋ dib an aku, bɨ katlö watlö um sö röböxön, mɨgrö il kɨ pɨnaŋ, mi yadö, rön, nugwo nugw pɨnɨŋa. ");
INSERT INTO tmd_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nuŋ God nugw pön yada, ‘Nɨ God Ha nuŋ,’ me ra. God nuŋ keir algör rɨbyöx nugumɨjön aku, weik hön nugwo kömö paŋ,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ap kib pɨb nöbö hogwa Jisas pɨsaŋ pɨl pal nɨgim, ñɨŋ kwo algör Jisas nugwo mönö gwogwo akwör yadmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Wop aku naiö mibɨl yör kɨpisö mag aku, pɨxmag gurɨm, mɨdɨp duön naiö pibö pik röŋ mag aku iswob mil pöröŋa. ");
INSERT INTO tmd_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Naiö pibö röŋ mag aku, Jisas wö diba rön yadön yadöŋa, “Eli, Eli, lama sabaktani,” röŋa. Mönö yadöŋ aku, “God nɨ. God nɨ. Nɨ pödpöd rɨmɨn röböxlaŋö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Aliö rɨmɨn, nöbö mö bli il yöraku mɨdim bla nugwön yadmä, “God mönö yadɨb nöbö Ilaija yad wö rɨmɨdö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Aliö yadön, nöbö i du ap rɨb sɨ höx akuyöbö wab i pön rag hö, röbö wain acɨxa aku pɨlön, aiwölö yöda pön idu pɨlön, nölmön nɨmaŋ, me rön, nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Akuyöbö alön nölmɨn, nöbö bli yadmä, “Röböxi! Dar nugugu mɨjnɨm. Ilaija hön nugwo kömö pönɨŋönö pödpöd cönɨŋö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Makwam Jisas iswob wö diba rɨ yadön, inöm nuŋwa God nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Wop akwör, God höjöpalɨb rama ram möl yuadö kwo ubalɨja idɨxim ñapñap uñ mɨxɨl dib aku, mibɨla rɨb sö nɨgön waglöxiö rɨb bö pɨnmɨn adöi hör adöi hör duöŋa. Almɨn nugugɨrön, mɨmön pön, rɨg bla pal bebö rön, ");
INSERT INTO tmd_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","nöbäpö rɨg möla hogw pɨlön idɨxim bla, möla rödɨm, God nöbö mö lei nuŋwa höd wöröxim hogw pɨlim bla, mɨga rɨmɨn, höbkal öbɨlmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Öbɨlön, rɨg möla rɨŋadö duön, Jisas öbɨlöŋ wop aku ñɨŋ Jerusalem taun dib leia duön wöxnö nɨgɨm, nöbö mö mɨga ñɨgö nugumä. ");
INSERT INTO tmd_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Makwam mɨmön pön, agö magɨm röŋ aku nugwön, ami nöbö dib aku aipam, nöbö nuŋ bla pɨsaŋ mɨdim bla aipam, ñɨŋ ölölö rɨmɨn ipöxön, madmag ñɨŋa dumɨn nugugɨrön yadmä, “Mɨ! Nöbö kɨ nuŋ mɨ ödöriö God Ha nuŋ akwör!” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Makwam mö mɨga hön, hör ör yörkwo mɨdön nugugu mɨdmä. Mö piaku Jisas nugwo rɨ nölɨba Galili yöbö hömä. ");
INSERT INTO tmd_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mö mɨdim adaku, i Maria Magdala aku, i Jems Josep yöŋö nuöm ñɨŋa Maria aku, i Sebedi ha nuŋ hogwa nuöm aku. ");
INSERT INTO tmd_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Rɨb nöbö ödöriö i, Josep, Arimatia taun yöbö aku, nuŋ Jisas nöbö nuŋwa i mɨdöŋa. Nöbö aku, Jisas wöröxɨm nugwön, pɨgö pɨgö mɨdöŋ mag aku hön, gapna Pailot nugwo, Jisas högia pɨnönö wöhö rɨm, Pailot yöwö rön, nöbö nuŋ bla ñɨgö yadmɨn, ñɨŋ Josep nugwo nölmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jisas högi aku Josep nugwo nölmɨn, nuŋ ñapñap uñ lei waiö i pön, nöbäpö högi mɨŋa magalɨg wobön, ");
INSERT INTO tmd_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","pön du rɨg möl yoŋyöbö i, nɨ hogw piöñɨŋö, rön, yöluim möl aku hogw pɨlön, rɨg aso dib i pɨraiup pikopik rɨp duön, hogw möla idɨxön duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mö mös mɨdmä, mö i Maria Magdala, mö i kwo Maria ör. Mö Maria hogwa hön nugugu mɨdɨm nugugɨrön, Josep akuyöbö alön hogw pɨlöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jisas wöröxɨm hogw pɨlim wop aku, God ap höjöpal ur nölɨb nöbö dib bla aipam, Perisi nöbö bla aipam, God höjöpalɨb wop aku laŋ, me rön, ap rɨ rag hö pɨdɨlumä. Makwam aiaŋ, God höjöpalɨb wop ñɨŋa makwam, gapman nöbö dib Pailot mɨdöŋ yöra dumä. ");
INSERT INTO tmd_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Duön yadmä, “Nöbö dib. Inakmönö hörɨb nöbö aku yadöŋa, ‘Nɨ wöröxön, wop mös mɨdön, wop paŋ aku öbinö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Makwam, nagö nöbö bli yadaŋ, wop mös paŋ nöbäpö hogwaj aku nugugu mɨdɨŋ. Almɨdköp, nöbö nuŋ bla hön, nöbäpö högi mɨŋ aku kib pön, nöbö mö piaku ñɨgö inakmönö hörön yajöña, ‘Nuŋ höbkal öbɨlö,’ cöña. Akuyöbö alɨŋ, Jisas höd inakmönö höröŋ aku ap ulmɨdö; ñɨŋ mai inakmönö hörön yajöñ mönö aku mɨ du dib röxönɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Aliö rɨmɨdmɨn, Pailot ñɨgö yadöŋa, “Makwam, ñɨŋ ami nöbö rogw i pön, nöbäpö hogw pɨlim yöra duön, rɨb ñɨŋa keir yöx nugw ri abön, nöbäpö hogwaja rɨga nɨg gö nɨgɨŋ, ami nöbö nugugu mɨdɨŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Pailot aliö rɨmɨn, Juda nöbö dib piaku duön, nöbäpö hogw möla idɨxim rɨg diba aku nɨg ri ab gɨrön, ami nöbö rogw aku yadɨm, ñɨŋ yöraku nugugu mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Löum yöbö ruö löu mil pörɨm nugugɨrön, mö hogwa Maria Magdala aipam Maria i yöŋö duön, Jisas hogw pɨlim hogwaja nuguba dumä. ");
INSERT INTO tmd_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mag aku mɨmön dib ödöriö pɨmɨn nugugɨrön, ejol i adöx yöd röul adö kau sebö hön, Jisas nugwo hogw pɨlön rɨg aso pɨ idɨxim aku, pɨn göur gägäp adö abön, rola römɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ejol aku, haŋaj mämäg yuö nuŋwa mil milöu gɨ mɨdöŋa. Wölɨj nuŋ aku, mɨ lei wä mɨda mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Makwam ami nöbö nugugu mɨdim bla, nugwo nugwön, ölölö rɨmɨn ipöxön, gɨl gɨl rön, wöröxɨbi röxg mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Makwam ejol aku mö hogwa yadöŋa, “Ipöxmɨjeñ! Nɨ nugula, ñɨŋ mö hogwa Jisas bɨ katlö watlö um sö pɨl pal nɨgim nöbö aku hölu yönmɨdöia. ");
INSERT INTO tmd_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nuŋ yörɨk mɨdöl. Höd yadöŋ mag akuyöbö, maduö höbkal öbɨlön dua. Makwam ñɨŋ hön, nugwo pön hö nɨgim yörɨk nugwön, ");
INSERT INTO tmd_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","rɨmgör duön, nöbö nuŋ akuyöbö ñɨgö yajöña, ‘Jisas höbkal öbɨlön Galili dumɨda. Ñɨŋ nöbö pia du gɨrön nugwo piaku nugwöñɨŋö,’ cöña. Mönö akwör ñɨgö yad nölɨba hölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ejol aliö rɨmɨn, mö hogwa nugwön ipöxim aku, jɨ mɨ wahax pɨ gɨrön, nöbäpö hogwaj aku rɨmgör röböxön, Jisas nöbö nuŋ pia yad nölɨba ipalɨp dumä. ");
INSERT INTO tmd_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ödöi mibɨl piaku dumɨdɨm nugugɨrön, Jisas ñɨŋ mö hogwa möigw palön yadöŋa, “Ñɨŋ mɨdöiŋ ä?” röŋa. Jisas aliö rɨmɨn, mö hogwa hö höxmax yuön, yödpɨlö nuŋwa ölɨsö pön, ib nuŋwa yadmɨn bɨl sö duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jisas ñɨŋ mö hogwa yadöŋa, “Ipöxmɨjeñ! Ñɨŋ duön haul hödpɨg nɨ akuyöbö ñɨgö yajöña, ‘Galili duön Jisas nugwo nugwöñɨŋö,’ cɨne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mö hogwa, ödöi mibɨl piaku dumɨdmɨn nugugɨrön, ami nöbö nugugu mɨdim piaku bli taun diba kul yuadö duön, God ap höjöpal ur nölɨb nöbö dib akuyöbö ñɨŋ agö mag bɨlɨm röŋ aku magalɨg yad nölmä. ");
INSERT INTO tmd_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Yad nölmɨdmɨn, God ap höjöpal ur nölɨb nöbö dib piaku duön, mönö pɨ nuöm nɨgɨb nöbö bla pɨsaŋ mönö yad ödör paŋyöbö i nɨgön, ami nöbö piaku ñɨgö rɨg diba nölön yadmä, ");
INSERT INTO tmd_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Ñɨŋ mönö gör yadön, ‘Pɨxmag yuö mibɨl kwo inɨmö hölim gɨ mɨdöl mag aku, nöbö nuŋ bla hön, nöbäpö högi mɨŋa kib pɨrag duöiŋö,’ cöña. ");
INSERT INTO tmd_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Aliö yadɨŋ, gapna Pailot mönö aku nugwön aku, an nugwo pɨsaŋ yadɨŋ, ñɨgö ömörö bli pɨ nölenɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Aliö rɨmɨn, ami nöbö piaku rɨg aku pön, duön Juda nöbö dib adaku rɨg yadim mag akwör rɨmä. Ñɨŋ inakmönö hörön, Jisas högi mɨŋ aku, nöbö nuŋ bla kib pön duöiŋö, rim mönö aku, Juda nöbö mö akuyöbö inakmönö akwör hörön weik yad gör mɨdöia. ");
INSERT INTO tmd_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jisas nöbö nuŋ akuyöbö agɨp aku Galili duön, Jisas höd yadöŋ pɨda dumä. ");
INSERT INTO tmd_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Duön, Jisas nugwo nugwön, ib nuŋwa yadmɨn bɨl sö duöŋa. Makwam nöbö nuŋ bli nugwön yualöbön yadmä, “Aku Jisas mönö nöbö hörɨm?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Makwam Jisas il yöra hön, ñɨgö yadöŋa, “Acö na yadmɨn, mögörɨb adöx yöd röul adö kau sö aipam, mögörɨb mɨgrö kɨ aipam, nɨ magalɨg nugwidɨx mɨdla. ");
INSERT INTO tmd_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Makwam, ñɨŋ mögörɨb adadö magalɨg duön, nöbö mö adadö mɨdöi bla magalɨg mönö wä na yad nölɨŋ, ñɨŋ nɨ nugw pön, nöbö mö na mɨdön, nɨ mai höŋ. Akuyöbö alön, Acö aku, Ha aku, Inöm Lei aku iba urön, ñɨgö röbö pal nöiöña. ");
INSERT INTO tmd_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ñɨŋ akuyöbö alön, nɨ ñɨgö cɨnö, rön, agö mönö bɨlɨm yad nöil aku, ñɨŋ algön nör mönö aku ñɨgö magalɨg yad nöl ri abɨŋ, ñɨŋ nugwön mönö aku magalɨg mai diöña. Makwam nɨ ñɨgö mɨ ödöriö yadmɨdla, nɨ ñɨgö pɨsaŋ mɨdön, mɨdɨp duön, mɨdmön, mögörɨb kɨ hölögɨpönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jisas Krais, God Ha nuŋwa mönö wä aku yadɨba rɨmɨdla. ");
INSERT INTO tmd_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","God maduar ör Ha nuŋwa Jisas Krais nugwo mönö rɨg yadöŋ akuyöbö, God mönö yadɨb nöbö Aisaia, mönö aku God Mönö kai kɨtön yadöŋa, “Mɨ! Mönö na pön dub nöbö aku, höd yad abmön duön, ödöi nagö aku röb nöl ri aböna. ");
INSERT INTO tmd_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nöbö aku, mögörɨb nöbö mö mɨga mɨdölöi, mögörɨb rɨg kap mibɨl yöraku du mɨdön, wö rön yajöna, ‘Nöbö Diba hömɨda! Ödöi höña pisö pibö rɨg mɨjön bla, pɨd kwol pɨlɨx rɨg mɨjön bla, pɨn wöd höimöl ri abne,’ cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","God mönö yadɨb nöbö aku höd aliö rɨg yadöŋ mag akwör, röbö pal nölɨb nöbö Jon duön, mögörɨb nöbö mö mɨga mɨdmɨdölöi, mögörɨb rɨg kap mibɨl yöra mɨdmɨn nugugɨrön, nöbö mö bla hömɨn, ñɨgö mönö yad nölön yadmɨda, “Ap kib mag gwogwo röi aku, pödpöd rɨmɨn aliö alölɨŋö, rön, röböxɨŋ nɨ ñɨgö röbö pal nölmön, God ap kib mag gwogwo röi akuyöbö nugwön röböxaŋ,” me rɨmɨda. ");
INSERT INTO tmd_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nuŋ aliö rɨmɨn nugugɨrön, nöbö mö mögörɨb Judia womiöx il me bla mɨdim akuyöbö aipam, Jerusalem nöbö mö mɨdim akuyöbö aipam, ñɨŋ magalɨg mönö nugwo aku nuguba dumä. Duön, ap kib mag gwogwo rɨmɨdöi akuyöbö, yad wöxnö nɨgɨm, Jon ñɨgö röbö Jodan yuö röbö pal nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Makwam Jon wölɨj nuŋ aku, hön kamel panö pön rim wölɨj i yömön, hön kau uña amanö höbiöda pɨ nɨgmɨda. Ap nɨmɨb nuŋ aku, baŋ pabladö aku aipam, böm röbö aku aipam nɨmmɨda. ");
INSERT INTO tmd_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nuŋ nöbö mö akuyöbö ñɨgö yadmɨda, “Nöbö nɨ mai hömɨd aku, nuŋ nɨ röxgɨb yöi; nuŋ nöbö dib ödöriö, nɨ nöbö ulmɨdö. Nɨ nugwo nugumön möigw höna. Nɨ du il yöra höxmax yuön yamsö uñ nuŋ aku nag yaub maga mɨdöl. ");
INSERT INTO tmd_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nɨ ñɨgö röbö akwör pal nölmɨdɨl aku, jɨ nuŋ hön ñɨgö Inöm Lei akwör pal nöiönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Makwam wop i, Jisas Nasaret taun, Galili Propins yuadö mɨdmɨd yöra röböxön, Jon mɨdöŋ yöra höm, Jon Jisas nugwo röbö Jodan yuö pal nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nugwo röbö pal nölmɨn, Jisas röbö kwol yör sö duön laxiö nugumɨn, adöx yöd röul adö kau sö waglöxmɨn, God Inöma nuŋ yöur döpwö röxgɨb, bɨbɨ rɨ pɨn Jisas göröŋa. ");
INSERT INTO tmd_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Akuyöbö alön bɨbɨ rɨ pɨnɨm nugugɨrön, mönö i adöx yöd röul adö kau sebö yadöŋa, “Nagö Ha madmag yöbö nɨ. Nagö nugumön, nɨ mɨ ödöriö wä rö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Makwam wop akwör, God Inöma nuŋ Jisas nugwo yad abmɨn, mögörɨb rɨg kap mibɨl piaku duön, ");
INSERT INTO tmd_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","wop akuyöbö padokwo padök paŋyöbö i höuöiliö hö pɨn du adokwebö mɨj bö (40) yöraku mɨdöŋa. Piaku mɨdmɨn nugugɨrön, Seten, “Jisas nugwo rɨmön, mönö na aku mai duön, mag gwogwo raŋ,” me rön, hön yadmɨda. Mögörɨb mɨdmɨd möl aku hör wöñö ap bla akwör mɨdmɨda. Makwam ejol bla hön, Jisas nugwo nugwidɨx mɨdmɨdöia. ");
INSERT INTO tmd_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Makwam mai gapman nöbö dib Herod Jon nugwo nag nɨgɨm nugwön Jisas nuŋ mögörɨb Galili duön, God mönö wä aku nöbö mö akuyöbö ñɨgö yad nöl gɨr yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“God nöbö mö pön nugwidɨx mɨdɨb wop öim pöx mɨdmɨdöi aku weik mödö ha! Ap kib mag gwogwo röi aku, pödpöd rɨmɨn aliö alölɨŋö, rön, röböxön, God mönö wä aku mi yadö, rön, nugw pɨne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisas Ban Yuö Galili pö yöra padɨx gɨrön nugumɨn, nöbö dölöm pɨb hödpɨg nöbö rama, dölöm pɨŋö, rön, uben i pɨ röbö yuö bö abön mɨdmä. Nöbö hödpɨg ram aku ib ñɨŋ hogwa aku, i Saimon i Edru. ");
INSERT INTO tmd_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jisas ñɨgö nöbö hogwa nugwön yadöŋa, “Höŋ, nɨ pɨsaŋ yönön, nɨ ñɨgö nöbö hogwa yad nöl ri abön rɨmön, nöbö mö pɨb nöbö hogwa mɨjöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Aliö rɨmɨn, mi yadö, rön, rɨb pia uben bla röböxön, Jisas pɨsaŋ dumä. ");
INSERT INTO tmd_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Makwam Jisas hör ul mag mɨŋi duön nugumɨn, Sebedi ha nuŋwa Jems Jon yöŋö röbö alebö möla mɨd gɨr, uben paxdöröŋ aku, lɨdɨx gɨr mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jisas nuŋ nöbö rama nugwön yadöŋa, “Ñɨŋ nöbö hogwa höne!” röŋa. Jisas aliö rɨmɨn, ñɨŋ hödpɨg hogwa nugwön, nuö mabö rɨ nölɨb nöbö bli pɨsaŋ ñɨgö röbö alebö rol yöraku röböxön, Jisas pɨsaŋ dumä. ");
INSERT INTO tmd_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Makwam ñɨŋ taun ulmɨdö Kapaneam duön, Juda God höjöpalɨb wopa, Jisas Juda mögum rɨb ram möl yuadö duön, God Mönö aku yad nölmɨn, ");
INSERT INTO tmd_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","nöbö mö bla nugwön, aiö waiö rön yadmä, “God lo mönö yad nölɨb nöbö piaku rɨg yadöi akuyöbö yadölöm; nuŋ nöbö dib ödöriö nugw ri abön rɨg yadöi aliar yadö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Makwam wop akwör, nöbö ragwo ha öim nɨgöŋ i, mögum rɨb ram möl aku hön bölölö rön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jisas nöbö Nasaret yöbö! Nagö anɨŋ pödpöd rɨba hölö? Anɨŋ ragwo ha bla pɨl pal nɨgɨba hölanö ä? Nɨ nagö nugula, nagö God Ha Lei nuŋ aku,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Aliö rɨmɨn, Jisas paiŋö ragwo ha nöbö aku öim nɨgöŋ aku nugwo mönö ölɨsö yadön yadöŋa, “Mönö pɨmɨjɨnö! Nöbö aku nugwo röböxön röu duö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jisas aliö rɨmɨn, ragwo ha aku nöbö aku nugwo pɨ yös röd abön, wö diba rön, röu duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Jisas aliö almɨn, nöbö mö mɨdim akuyöbö mɨ aiö rön, mönö yad nugwob nugwob rön yadmä, “Aku agapɨm? Nöbö kɨ mönö yoŋyöbö mönö adö i pön yad nölmɨda. Nuŋ nöbö ölöm. Ragwo ha mönö nuŋwa yöxön rɨg yad mag akwör röiŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nöbö mö piaku aliö yad gɨr, Jisas ragwo ha yad aböŋ mönö aku, mögörɨb Galili yuada magalɨg yad nölmɨn duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Makwam Jisas, Jems, Jon, Saimon, Edru, ñɨŋ nöbö adö Juda mögum rɨb ram aku röböxön, rɨŋö bö röu duön, Saimon hödnɨŋ Edru yöŋö rama dumä. ");
INSERT INTO tmd_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Rama uröpɨnön, Jisas nugwo yadmä, “Saimon nɨmemö mɨxɨña rɨn röxg yönmɨn, hölɨm gɨ mɨde,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Aliö rɨmɨn, Jisas du iŋpɨlö nuŋwa pön pabɨl nölmɨn nugugɨrön, mɨxɨñ nuŋwa rɨn röxg yönmɨdöŋ aku kömö nɨgmɨn, rɨb pia ñɨŋ ap mag röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Makwam naiö rödɨp duöŋ mag aku, nöbö mö ap röŋ bla aipam, nöbö mö ragwo ha öim nɨgöŋ bla aipam, Jisas raŋ kömö nɨgaŋ, me rön, Jisas mɨdöŋ yöra pön hömä. ");
INSERT INTO tmd_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Taun ulmɨdö Kapaneam nöbö mö akuyöbö magalɨg hön rama ubalɨj il rɨŋadö adö bö nugugu mɨdɨm nugwön, ");
INSERT INTO tmd_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","nöbö mö mɨga akwör ap hörɨrör röŋ akuyöbö, Jisas rɨmɨn, kömö nɨgöŋa. Ragwo ha öim nɨgöŋ akuyöbö mɨga akwör yad abɨm röu dumä. Makwam ragwo ha piaku Jisas nuŋ nöbö pödiöm nugw ri abim akuyöbö, Jisas nuŋ ñɨgö, “Mönö pɨmɨjeñɨŋö,” rön, yad abɨm röu dumä. ");
INSERT INTO tmd_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Löum yöbö, Jisas pɨxmag alɨg öbɨlön, hölɨmöŋ ram aku röböxön, taun aku aipam röböxön, möl i hör duön, Nuö höjöpal gɨr mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Makwam nöbö nuŋwa Saimon, nöbö nuŋ bli pɨsaŋ, Jisas mɨ kai, me rön, nugwo hölu nuguba dumä. ");
INSERT INTO tmd_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jisas nugwo hölu nugup du nugwön yadmä, “Nöbö mö magalɨg nagö mɨkai, me rön, hölumɨdöiŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Aliö rɨmɨdɨm, Jisas yadöŋa, “An ram yöj lɨglɨg agrö bli kwo aipam il me bɨlɨk dinɨm. Nɨ höl aku, nöbö mö mögörɨb möl piaku piaku ñɨgö mönö yad nöinö, rön, hölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jisas aliö yadön, mögörɨb Galili mibɨl piaku rɨp yön gɨrön, du Juda mögum rɨb ram möl yuadö akuyöbö duön, God Mönö yad nöl gɨrön, ragwo ha nöbö mö ñɨgö öim nɨgöŋ bla yad abɨm röu dumä. ");
INSERT INTO tmd_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Uj höpebö nɨgöŋ nöbö i, Jisas mɨdöŋ yöra hön, höxmax yuön yadöŋa, “Nagö uj na wödö wölaŋ, me cɨnö aku, wödö wöiönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Aliö rɨmɨn, Jisas nugwo ögwö yöxön imaga mɨlkap abön nöbö aku nugwo pɨ nugwön yadöŋa, “Yöwö, cɨna. Wödö wölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jisas nugwo pɨ nugum rɨb pia uj höpebö nɨgöŋ aku lɨl rɨmɨn kömö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Makwam Jisas nöbö aku nugwo mönö ölɨsö yadön yadöŋa, “Ödöi mibɨl piaku nöbö mö bli ñɨgö nugwön, Jisas nɨ rɨm wödö wölö, rön, yadmɨjɨnö. Ödöriö akwör duön, God ap höjöpal ur nölɨb nöbö aku nugwo mɨxɨñ naŋ aku yabuön yajɨnö, ‘Uj höpebö na aku wödö wölö,’ ranö. Aliö yadön, Mosɨs höd rɨg yadöŋ mag akuyöbö, ap bli pön du God ap höjöpal ur nölɨb nöbö aku nölö, nuŋ pal God höjöpal ur nölaŋ, nöbö mö piaku, nöbö aku weik wä rö, rön, nugwöñɨŋö,” röŋa. Jisas mönö akwör yadön nöbö aku yad abmɨn duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Jisas aliö röŋ aku, jɨ nöbö aku, nuŋ duön, mönö aku nöbö mö amnör yad nölmɨn duöŋa. Almɨn, Jisas taun piaku wöxnö yönɨb maga nɨgölöŋa nugwön, nuŋ duön nöbö mö mɨga mɨdölim mibɨl piakwör mɨdmɨn nugugɨrön, nöbö mö mögörɨb piaku piaku magalɨg nugwo nuguba hömɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","2","Wop mösör padɨxmɨn nugugɨrön Jisas höbkal taun ulmɨdö Kapaneam höm, Jisas hö mɨd ram nuŋ aku, me rɨm, nöbö mö mɨga akwör hön rɨm rɨm, ram möl yuadö mönö yad nölmɨdöŋ möl aku cɨcɨ rɨmɨn, ubalɨja il rɨŋadö yör bö algör ör mɨ cɨcɨ röŋa. Almɨn, Jisas nuŋ ñɨgö God Mönö maga yad nölmɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Jisas ñɨgö yad nölmɨdmɨn nugugɨrön, nöbö akuyöbö igwö mɨxɨl aku nöbö bli pɨsaŋ, nöbö iŋ wajmag lɨd pɨlöŋ i rɨp nɨgön, rag Jisas mɨdöŋ yöra pön hömä. ");
INSERT INTO tmd_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Hön nugumɨn, nöbö mö cɨcɨ rɨg mɨdim nugwön nöbö iŋ wajmag lɨd pɨlöŋ aku nugwo rag ram cölöbö sö wöluön, ram cölöbö sö mibɨl möl söi bö pu waglöxön möl rödön, rɨp wab hölɨm gɨ mɨdöŋ aku nag nɨgön abɨm, Jisas mɨdöŋ yör bö pɨn duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Makwam ñɨŋ Jisas raŋ kömö nɨgönɨŋö, rön, rɨbyöx nugw pim aku nugwön, Jisas yadöŋa, “Ha na. Ap kib mag gwogwo rɨlö piaku nugwön röböxmɨdlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Jisas aliö rɨmɨn, Juda lo mönö yad nölɨb nöbö bli römɨd gɨ mɨdim akuyöbö, rɨb ñɨŋ bla akwör yöx nugwön yadmä, ");
INSERT INTO tmd_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nöbö gɨ pödpöd rɨmɨn, God yad höimöuön, inakmönö hörön yadmɨd? Nöbö mö bla ap kib mag gwogwo rɨŋ, nöbö i pɨx ñɨŋ aku örɨx abɨb maga mɨdöl; God nuŋwör mag akuyöbö aiönɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Makwam aliö rɨbyöx nugwim rɨb maga aku Jisas nuŋ keir nugwön yadöŋa, “Ñɨŋ pödpöd rɨmɨn rɨb mag aliö akuyöbö yöx nugumɨdöi? ");
INSERT INTO tmd_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nöbö iŋ wajmag lɨd pɨl aku nugwo pödi yadmön, ñɨgö wä cön? Ap kib mag gwogwo rɨlö aku nugwön röböxmɨdla, rɨmön, ñɨgö wä cönɨŋönö, owa öbɨlön köp nagö aku röd pɨrag duö, rɨmön, ñɨgö wä cön? ");
INSERT INTO tmd_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nɨ rɨmön, ñɨŋ nugwöña, Nöbö Ha nuŋwa mögörɨb il kɨ höm aku, rɨb na keir yöx nugwön hölɨm. God yadmɨn höm aku mɨ, ap kib mag gwogwo röi aku nugwön röböxmɨdla, cɨn aku, röböxmɨdlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Aliö yadön, iŋ wajmag lɨd pɨlöŋ nöbö aku nugwo yadöŋa, “Nɨ nagö yadmɨdla, öbɨlön, köp naŋ aku röd pɨragön rama duö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jisas aliö rɨmɨn, nöbö mö nugugu mɨdɨm nugugɨrön, nöbö aku öbɨlön, köp nuŋ bla röd ragön duöŋa. Almɨn nugwön, nöbö mö piaku magalɨg mɨ aiö rön, God ib nuŋwa yadmɨn bɨl sö dumɨn nugugɨrön yadmä, “Höd ap aliö akuyöbö i rɨm, an nugumɨdölölɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisas iswob höuöil duön, Ban Yuö Galili pö yöra yönmɨdmɨn nugugɨrön, nöbö mö mɨga nugwön mɨdöŋ yöra hö mögum rɨmɨdɨm nugwön Jisas nuŋ ñɨgö God Mönö maga yad nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jisas mönö yad nöl pörön, ödöi mibɨl yöra du gɨrön nugumɨn, takis pɨb nöbö i, Alpias ha nuŋwa Lipai, mabö rɨmɨd rama ram möl yuadö römɨd gɨ mɨdöŋa. Jisas nugwo nugwön yadöŋa, “Haŋ, nɨ pɨsaŋ dinɨŋö,” rɨmɨn, öbɨlön Jisas pɨsaŋ dumä. ");
INSERT INTO tmd_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Makwam Jisas nöbö nuŋ bla pɨsaŋ du Lipai rama ap nɨmmɨdɨm nugugɨrön, takis pɨb nöbö bla aipam, nöbö ap kib mag gwogwo rim bla aipam, Jisas pɨsaŋ yönmɨdim blaku, du nɨgiö nɨgön ap nɨmmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Lo mönö yad nölɨb nöbö Perisi bli, Jisas nuŋ takis pɨb nöbö bla pɨsaŋ, nöbö ap kib mag gwogwo rɨmɨdöi bla pɨsaŋ mɨdön ap nɨmmɨdöŋ aku nugwön, nöbö nuŋ akuyöbö ñɨgö yadmä, “Jisas nuŋ pödpöd rɨmɨn nöbö takis pɨmɨdöi bla nɨgön, nöbö ap kib mag gwogwo röi bla nɨgön pɨsaŋ römɨd gɨ mɨdön ap nɨmmɨd?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Aliö rɨmɨdmɨn, Jisas mönö aku nugwön yadöŋa, “Nöbö mö kömö mɨdöi piaku, uj wobɨb nöbö nuguba duölöi; nöbö mö ap rɨ bla akwör uj wobɨb nöbö nuguba duöia. Makwam mag aliö akuyöbö, nöbö mö, mag wä rölɨŋö, rön rɨbyöx nugwöi piaku, ñɨgö pɨba höi; nöbö mö, ap kib mag gwogwo rölɨŋö, rön rɨbyöx nugwöi piakwör, ñɨgö pɨba hölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jon nöbö nuŋ bla aipam, Perisi ada nöbö ñɨŋ bla aipam, wop bli God höjöpal gör mɨjnɨŋö, rön, ap nɨmmɨdölöi. Wop i ñɨŋ aliö almɨdmä aku nugwön, nöbö mö bli hön Jisas nugwo yadmä, “Jon nöbö nuŋ bla aipam, Perisi ada nöbö ñɨŋ bla aipam, wop paŋ paŋ ap mödön nɨmölöi. Makwam nöbö nagö bla, pödpöd rɨmɨn alölöiŋö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Aliö rɨmɨdmɨn, Jisas mönö höd röxön yadöŋa, “Nöbö mö pɨba cön nöbö i, haul hödpɨg nuŋ bla pɨsaŋ mɨdön, wä raŋ nugugɨrön mɨjöñ makwam, ap maga röböxeñ. ");
INSERT INTO tmd_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Makwam mai, nöbö bli hön, nöbö ñɨŋ aku nugwo pön dumɨjöñ aku, lɨb pɨlaŋ, wop aku ap nɨmeñ. ");
INSERT INTO tmd_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Makwam wölɨj yoŋyöbö pɨd i pön, wölɨj lɨduön adö cön möla lɨdɨx pɨŋ, wölɨj yoŋyöbö aku ölɨsö mɨdaŋ, wölɨj lɨdiön aku paxdörön, wölɨj ñɨŋ aku mɨ uplöb waglöxaŋ diöna. ");
INSERT INTO tmd_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Röbö wain aku, algör ör. Röbö wain kömö pön, hön meme uñ hödyöbö möla hör nɨgölöi. Aku agapɨm: hör nɨgön mämugw nölmɨn, hön meme uña pɨnpɨn yadaŋ, waglöxön hör du pöcöna. Mag aliö akuyöbö, röbö wain kömö aku, hön meme uñ kömö möl akwör hör nɨgɨbɨm,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mai Juda God höjöpalɨb wopa ñɨŋ hö, Jisas nöbö nuŋ bla pɨsaŋ wit möriwö mibɨla padɨx gɨr, nöbö nuŋ bla wit mag bli pɨlɨl rɨ rag dumɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Akuyöbö almɨn, Perisi nöbö piaku nugwön, Jisas nugwo yadmä, “Weik God höjöpalɨb wop an mabö rölɨb aku, nöbö nagö bla aliö mabö rön, lo ana röd abmɨdöiŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Aliö rɨmɨn, Jisas yadöŋa, “Nöso Depid maduar ör kiö pɨlmɨn röŋ haiwo kai kɨtim aku, ñɨŋ nugwölöi ä? ");
INSERT INTO tmd_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Maduar ör nöbö nagö Abiada God ap höjöpal ur nölɨb nöbö dib ödöriö mɨdmɨd wop aku, Depid nöbö nuŋ bla pɨsaŋ ñɨgö kiö pɨlmɨn, God höjöpalɨb rama duön, bred nöbö mö hör bla nɨmmɨdölöi, God ap höjöpal ur nölɨb nöbö bla akwör nɨmöi aku pön, nöbö nuŋ bla ñɨgö nölɨm nɨmɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","“God nuŋ wop hör mɨdɨb mönö aku höd yadön, mai nöbö mö rɨ nɨgölöŋ; nöbö mö rɨ nɨgön, aŋöi abön mɨd ri abɨŋ, me rön, wop i hör mɨdɨŋ, me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Makwam, an nugwöla, Nöbö Ha nuŋwa God höjöpalɨb wop aku aipam Nöbö Diba mɨdö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Makwam wop i Jisas höbkal Juda mögum rɨb rama duön nugumɨn, nöbö imag lɨd pɨlöŋ i ram möl yuadö hö mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Perisi nöbö mɨdim bla bli, Jisas agö magɨm raŋ, nugwo pön du mönö diba yajnɨŋö, rön, nöbö aku God höjöpalɨb wop kɨ raŋ kömö nɨgönɨŋönö wöhö, rön, tar riö nugugu mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jisas nuŋ nöbö imag lɨd pɨlöŋ aku nugwo yadöŋa, “Öbɨlön yörɨk hö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jisas aliö rɨmɨn, nuŋ mɨdöŋ yöra höm, Jisas nöbö mö piaku ñɨgö yadöŋa, “God höjöpalɨb wop aku agö magɨm rɨbɨm? Rɨ ri abɨb mönö rɨ gwogwam rɨbɨm? Nöbö mö akuyöbö ñɨgö uliöxön rɨŋ kömö diöñɨŋönö, owa rɨb gwogwo yöx nugwön röböxɨŋ wöröxöñɨŋö?” röŋa. Aliö rɨmɨn, ñɨŋ nugwo mönö i paiŋö yadölim. ");
INSERT INTO tmd_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jisas mönö yöxöinɨŋö, rön, nugwim nöbö piaku, Jisas ñɨgö nugumɨn ölɨsö wölöŋa. Ñɨŋ nöbö imag lɨd pɨlö aku madmag nɨgölim aku nugwön, Jisas nuŋ ñɨgö mämäg il kap rogwa nugwön ñɨŋ yadyöxöŋa. Akuyöbö alön, nöbö imag lɨd pɨlöŋ aku nugwo yadöŋa, “Imag naŋa mɨlkap abö!” röŋa. Aliö rɨmɨn, imaga mɨlkap abmɨn nugugɨrön, wä röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Akuyöbö alöŋa nugwön, Perisi nöbö Juda mögum rɨb ram aku röböxön, Herod nöbö nuŋ bla mɨdim yöra duön, mönö yad nugwob nugwob rön, “Jisas nugwo pödpöd rön pɨl pal nɨgnɨŋö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Jisas nuŋ nöbö nuŋ bla pön, duön Ban Yuö Galili kwol yöra du mɨdmä. Jɨ nöbö mö Galili yöbö magöri maga rɨp nugwo mai hömä. Nuŋ ap agap apɨm rɨmɨd adaku yadmɨn piaku dumɨn nugugɨrön, Judia nöbö mö bli, Jerusalem nöbö mö bli, mögörɨb Idumia nöbö mö bli, röbö Jodan pö kwo nöbö mö bli, taun diba mös Taia, Saidon mögörɨb il yör akuyöbö nöbö mö bli, nöbö mö mɨga Jisas nugwo nuguba hömä. ");
INSERT INTO tmd_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Jisas nöbö mö mɨga akwör rɨmɨn, kömö nɨgöŋ aku mɨ, nugwo pɨ nugwɨŋ kömö nɨgönɨŋö, rön, nöbö mö magöri maga rɨp hön, nugwo wabnaŋnaŋ rɨp höm, nɨ wob yuö nɨgöñɨŋö, rön, nöbö nuŋ akuyöbö ñɨgö yadɨm, röbö alebö i pɨ nɨgmä. ");
INSERT INTO tmd_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Makwam nöbö mö ragwo ha öim nɨgöŋ piaku, Jisas nugwön, yödpɨlö nuŋwa ila mɨgrö bö pɨn bɨrön, mönö diba pön, “Nagö God Ha nuŋ!” me rɨmɨdöia. ");
INSERT INTO tmd_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jisas paiŋö ragwo ha bla mönö ölɨsö yadön yadöŋa, “Nɨ Nöbö pödiöm mɨdɨl aku wöxnö yadmɨjeñ wöhö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Makwam Jisas mögörɨb önöŋ i duön, nöbö nuŋ pɨba röŋ piaku yadɨm hömä. ");
INSERT INTO tmd_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nöbö akuyöbö möl sö yad nɨgön yadöŋa, “Ñɨŋ nɨ pɨsaŋ yönön, mönö na pön dub nöbö bla mɨdön, ñɨgö yad abmön, du gɨrön nöbö mö piaku ñɨgö God Mönö wä mag aku yad nöiöña. ");
INSERT INTO tmd_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nɨ ñɨgö yadmɨdɨl aku mɨ, ragwo ha piaku algör ör yad aböñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jisas nöbö nuŋ pöŋ adaku ib ñɨŋ akuyöbö, i Saimon, mai Jisas ib i kwo nölön Pita röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","I Jems, i Jems pɨgnɨŋ nuŋwa Jon, nuö ñɨŋa iba Sebedi. Jisas ñɨgö nöbö hogwa Boanerges röŋa. Ib aku il aku “Gunɨm Nöbö”. ");
INSERT INTO tmd_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Nöbö nuŋ i Edru; i Pilip; i Batolomiu; i Matiu; i Tomas; i Jems, Alpias ha nuŋwa; i Padias; i Saimon, nugwo Saimon Selot me rɨmɨdöia. ");
INSERT INTO tmd_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Makwam i Judas Iskariot. Nuŋ mai Jisas höuöu röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Makwam Jisas ram i dumɨn, yörbö nöbö mö mɨga akwör hö mögum rɨg mɨdmä nugwön, nöbö nuŋ bla pɨsaŋ nɨmɨb ap mag akuyöbö mɨdölöŋ. ");
INSERT INTO tmd_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Almɨn, nöbö mö bli Jisas u pɨlö, rɨmɨn nugwön, nuöm pɨgnɨŋ nöbö nuŋ ada yölɨŋ pön höba dumä. ");
INSERT INTO tmd_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Makwam lo mönö yad nölɨb nöbö Jerusalem yöbö höm akuyöbö yadmä, “Ragwo ha akuyöbö nuö ñɨŋa Bielsebul Jisas nugwo yuö wöl aku, ragwo ha piaku yad abmɨdö,” rɨmä. Mönö inakmönö aku hörmɨdɨm, ");
INSERT INTO tmd_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jisas nuŋ nugwön, nöbö mö akuyöbö ñɨgö yadɨm hömɨdmɨn, mönö adaku mönö höd röxön yadöŋa, “Seten pödpöd rön Seten nugwör yad abön? ");
INSERT INTO tmd_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kiŋ paŋyöbö i nugwidɨx mɨjön mögörɨb aku, nöbö mö bli öbɨlön ñɨŋ ñɨŋör nuö nuö pɨlmɨjöñ aku, mögörɨb aku asɨx hörɨrör nɨgön pɨn bɨcöna. ");
INSERT INTO tmd_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Makwam nuarö nuömarö piaku algör ör, ñɨŋ nöbö mö ñɨŋ keir nuö nuö pɨlmɨjöñ aku, il aku asɨx hörɨrör nɨgön pɨn bɨcöna. ");
INSERT INTO tmd_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Makwaim mag akuyöbö, Seten nuŋ keir ragwo ha nuŋ bla yad abmɨdaŋ mönö, asɨx hörɨrör nɨgön aŋadö pɨn bɨcöna. ");
INSERT INTO tmd_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Nöbö ölɨsö ödöriö i ram nuŋwa mɨdaŋ nugugɨrön, nöbö i hön, ap nuŋ bla pön duen; höd nöbö ölɨsö aku nugwo nag nɨg gö nɨgön, mai du ram nuŋwa mɨjön ap akuyöbö pɨrag diöna. ");
INSERT INTO tmd_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nɨ ñɨgö mi yadmɨdla, nöbö mö akuyöbö ap kib mag gwogwo agap apɨm rɨmɨjöñ aku, God nugwön röböxöna. God nugwo yad höimöuöñ aku, nuŋ nugwön röböxöna. ");
INSERT INTO tmd_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Jɨ Inöm Leia nugwo yad höimöuöñ aku, God nugwön röböxenɨm. Ap kib mag gwogwo cön aku öim mɨjönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jisas nugwo, “Ragwo ha akuyöbö nugwo öim nɨgö,” rim makwam, nuŋ aliö yadöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Makwam Jisas pɨgnɨŋ nuöm nöbö hön, rɨŋadö bö mɨdön, nöbö i nugwo, “Nagö du Jisas yadaŋ haŋ,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Makwam, nöbö mö ram möl yuadö Jisas nugwo wob yuö nɨgön römɨd gɨ mɨdim akuyöbö nugwo yadmä, “Nam nölöunaŋ pɨgnaŋ nöbö piaku rɨŋadö bö hö mɨdön, ‘Nagö hane,’ rɨmɨdöiŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Aliö rɨmɨdmɨn, Jisas yadöŋa, “Mam na, haul nöbö na yönɨmɨm?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Aliö rön, Jisas nöbö mö mɨdim bla nugw padɨx gɨr yadöŋa, “Ñɨgö mɨ mam na, haul nöbö na mɨdöia. ");
INSERT INTO tmd_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nöbö mö God rɨg yad mag akwör röi akuyöbö, haul na, mölöu na, mam na mɨdöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisas Ban Yuö Galili pö yöra duön, nöbö mö akuyöbö ñɨgö iswob mönö maga yad nöl mɨdmɨn nugugɨrön, nöbö mö mɨga hö mögum rɨmä. Almɨdmɨn, Jisas röbö alebö i rola römɨdön, du röbö yuö igöp yöraku mɨd gɨrön, nöbö mö röbö halaia öbɨl gɨ mɨdim akuyöbö ñɨgö mönö yad nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jisas mönö piaku mönö höd röxön ada hörɨrör mönö mɨga akwör yad nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Jisas mönö adö i mönö höd röxön yadöŋa, “Mönö yadɨba rɨmɨdɨl kɨ nugwi! Nöbö i möriwö rɨb nuŋ aku wit iña wölaŋ, me rön, pön du abaŋ duaŋ nugugɨrön, ");
INSERT INTO tmd_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","iñ bli ödöi uhöb rol yöra pɨnaŋ, yöur bla hön nɨmöña. ");
INSERT INTO tmd_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Iñ bli rɨg rol mögö ulul mɨjön yöra pɨnön rɨmgör wöiön aku ");
INSERT INTO tmd_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","jɨ jöjö abaŋ duen aku, naiö nɨgaŋ, wöröxöna. ");
INSERT INTO tmd_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Iñ bli nag kaigapa mɨjön mibɨl yöra pɨnön wöiön aku, jɨ nag kaigap bla höu wobön pal nɨmaŋ maga yaxen. ");
INSERT INTO tmd_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Jɨ iñ bli mögö wä rola pɨnön, wöl ri abön, maga yax ri aböna. Bli maga padokwo paŋyöbö i höuöiliö hö wölu mɨj sö (30) yaxöna, bli maga padokwo padök mös höuöiliö hö du adokwebö ragpɨd kwo (60) yaxöna, bli padokwo padök mös mös höuöiliö hö wölu amñaxɨb sö (100) yaxönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jisas mönö aku yad pör gɨrön yadöŋa, “Ñɨŋ nöbö mö rɨmɨj möla mɨjön akuyöbö, mönö yadmɨdɨl kɨ rɨmɨj pal nugw ri abne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jisas mönö yadmɨn nugugɨrön, nöbö mö nugugu mɨdmä akuyöbö yau hörɨrör dumɨn nugwön nöbö nuŋwa akuyöbö möl sö bla aipam, nöbö mö nuŋ bli kwo aipam, Jisas nugwo yadmä, “Mönö höd röxön yadlö il aku mɨkai?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Aliö rɨmɨn, Jisas yadöŋa, “God nöbö mö pön nugwidɨx mɨdɨb mönö aku, God rɨmɨn ñɨŋ nugwöi aku, jɨ nöbö mö akuyöbö ñɨgö höd akwör röxön yad nölmɨdla. ");
INSERT INTO tmd_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Akuyöbö almön, God mönö yadɨb nöbö i God Mönö kai kɨtön rɨg yadöŋ mag akwör cöna. Nuŋ yadöŋa, ‘Mämäga nugwöña jɨ ap bli nugweñ. Mönö yöxöña jɨ mönö ila rɨg yada aliö, me rön, nugweñ. Nugw ri aböyɨx aku, God nugwo yad nugumɨdöyɨx aku, ap kib mag gwogwo röi akuyöbö nugwön röböxöx,’ me rö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jisas aliö rön ñɨgö yadöŋa, “Mönö höd röxön yadmɨdɨl akuyöbö nugwölöi aku, mai mönö bli kwo höd röx yadmɨjɨn aku, pödpödiö nugwöñɨŋö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Wit iña nöbö pɨ abönɨŋö, rɨl aku, God Mönö maga ai, me rön, yadla. ");
INSERT INTO tmd_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Iña bli ödöi uhömɨdöi rol yöra pɨñönɨŋö, rɨl aku, nöbö mö akuyöbö God Mönö nugwöña, jɨ wop mɨd akwör Seten hön mönö aku pɨ gɨ du pɨrag diönɨŋö, rön, yadla. ");
INSERT INTO tmd_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Makwam iña bli rɨg rol mögö ulul mɨjön yöra pɨnön rɨmgör wöiöna aku, jɨ jöjö yuö bö duön ölɨsö pɨlölaŋ naiö nɨgaŋ wöröxönɨŋö, rɨl aku, nöbö mö akuyöbö God Mönö aku yoŋyöbö wop aku nugwɨŋ wä raŋ nugugɨrön, wahax pɨmɨjöña, jɨ hör ulul mag mɨŋi mɨdɨŋ nugugɨrön, ömörö bli hönɨŋönö nöbö bli ñɨgö rɨ gwogwam rɨŋ nugugɨrön, mönö mag aku rɨmgör röböxöñɨŋö, rön, yadla. ");
INSERT INTO tmd_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Iña bli nag kaigap mibɨl yöra pɨnön wöiönɨŋö, rɨl aku, nöbö mö God Mönö nugwöña aku, ");
INSERT INTO tmd_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","jɨ mörö mabö, ram köp hölɨb, hön ap akuyöbö rɨb mɨga yöxön, yu köme, ulnöu rɨg ap akuyöbö rɨb mɨga yöxön, ap piakwör rɨbyöx nugwöñ aku mɨ, God Mönö aku höu wobön pal nɨmaŋ, maga yaxenɨŋö, rön, yadla. ");
INSERT INTO tmd_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Wit iña mögö wä rol yöra pɨñönɨŋö, rɨl aku, nöbö mö God Mönö nugwön, nugw pɨ gö nɨgmɨjöña nugwön maga padokwo paŋyöbö i höuöiliö hö wölu mɨj sö (30) mönö padokwo padök mös höuöiliö hö du adokwebö ragpɨd kwo (60) mönö padokwo padök mös mös höuöiliö hö wölu amñaxɨb sö (100) akuyöbö yaxöna; rɨba aliö yöx nugwön yadɨl maku,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisas nuŋ iswob mönö i höd röxön yadöŋa, “Nöbö mö bla hötɨkö urön wi yöj mo möl böisö mönö äbäñ rol hölɨmmɨdöi akum mo bö umadeñɨm; bɨl yöra sö pɨ cɨx gɨŋ mila ab gɨ mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mag akuyöbö, agap bɨlɨm weik umad gɨ mɨd aku, mai wöxnö nɨgaŋ nugwöña. ");
INSERT INTO tmd_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ñɨŋ nöbö mö rɨmɨj möla mɨjön bla, mönö yadmɨdɨl kɨ rɨmɨj pal nugw ri abne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ñɨgö mönö i yadöŋa, “Mönö yöxmɨdöi mönö aku röx nugup du ila nugw ri aböña. Ñɨŋ nöbö mö akuyöbö ñɨgö mönö diba yadön, paiŋö pödpödiö nöinö rɨmɨjöñ aku, God nuŋ nugwön ñɨgö kwo algör mönö diba yadön, paiŋö kwo algör aliar nölɨŋ, me cöna. Makwam nuŋ ñɨgö paiŋö bli kwo rola ab nöine, cöna. ");
INSERT INTO tmd_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nöbö mö ap mɨd akuyöbö, bli kwo rol ab pöña; jɨ nöbö mö ap mɨdöl akuyöbö, ap ulul ñɨŋ mɨd bla aipam pɨrag diöña. ");
INSERT INTO tmd_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisas mönö i mönö höd röxön yadöŋa, “God nöbö mö pön nugwidɨx mɨdɨb aku, haiwo aliö kɨyöbö mɨda. Nöbö möriwö mɨnöbö i wit iña wölaŋ, me rön, rag du möriwö rɨb nuŋ piaku aböna. ");
INSERT INTO tmd_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Wit iña möriwö rɨb aku abön, hölɨm yönmɨdaŋ nugugɨrön, mogw bɨrön, wölɨba rɨmɨda. Pödpödiö wölmɨdö, rön, nugwen. ");
INSERT INTO tmd_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mögö nuŋ keir raŋ, mogwa röpɨnön, wölön, maga yaxön, göj yöna. ");
INSERT INTO tmd_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Makwam möriwö rɨb mɨnöbö aku göj waŋ nugwön, ödör rag du nɨgɨb wop aku hö, rön, yu ogomaj mea rag duön, ödör pön hönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jisas aliö rön yadöŋa, “God nöbö mö pön nugwidɨx mɨjön aku, haiwo pödiöm pön yadmön nugwöñ? ");
INSERT INTO tmd_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Mɨ, bɨ masted iña röxg yajɨna. Ap iñ bli diba yuöi akuyöbö ulmɨdö wöla, jɨ masted iñ mag ul cokulä yuŋ, wöl dib röxön, padö diba pɨlaŋ, yöur bla hön höxia görön mɨdöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisas nuŋ nöbö mö akuyöbö ñɨgö mönö höd röxɨb piaku mönö mɨga akwör yad nölmɨda; akuyöbö alön, mönö wä aku ñɨŋ yad nölmɨda. Ñɨŋ mönö nugw ri abmɨdöi mönö akwör ñɨgö yad nölmɨda; mönö nugw ri abmɨdölöi mönö aku yad nölmɨdöl. ");
INSERT INTO tmd_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jisas nuŋ ñɨgö mönö höd akwör röxön yad nölmɨda. Mai nöbö nuŋ bla pɨsaŋ ñɨŋ keir mɨd gɨrön, mönö ila magalɨg yad nöl ri abmɨda. ");
INSERT INTO tmd_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Wop akwör ruö höxi guröŋ mag aku, Jisas nöbö nuŋ bla ñɨgö yadöŋa, “Röbö bana pö kwo duŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jisas aliö rɨmɨn, nöbö nuŋ akuyöbö nöbö mö mɨga akwör hö mɨdim akuyöbö ñɨgö röböxön, röbö alebö Jisas mɨdöŋ möl aku wölön, dumä. Röbö alebö bli alɨg pɨsaŋ dumä. ");
INSERT INTO tmd_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mibɨl kwo dum nugugɨrön, rɨb pia hödal diba hön, röbö wödön alebö möla wölɨm, mɨñ pɨn dubä röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisas nuŋ röbö alebö möla rɨb adö sö röxiö, yöcmac ijib nɨgön hölɨmöŋa nugugɨrön, nöbö nuŋ bla nugwo du ruob gɨrön yadmä, “Mönö yad nölɨb nöbö, an magalɨg wöröxɨba rɨmɨdöl gɨ, naŋ nuguman an hör ap i röx ä?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Aliö rɨmɨdmɨn, Jisas öbɨlön, hödal diba hömɨdöŋ aku aipam, röbö wöd hömɨdöŋ aku aipam, tar mɨdö rɨmɨn, hödal hömɨdöŋ aku hölögɨpɨm, röbö wöd hömɨdöŋ aku aŋadö höx rödɨm du aŋöi nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Makwam Jisas nöbö nuŋ bla ñɨgö yadöŋa, “Ñɨŋ pödpöd rɨmɨn ipöxmɨdöi? Ñɨŋ nugw pɨb mag ñɨŋa ul mɨŋi mɨdɨm ipöxmɨdöiŋ ä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Aliö rɨmɨn, ñɨŋ aiö rön, ñɨŋ ñɨŋ keir nuö nuö yad nugwön yadmä, “Nöbö gɨ nöbö pödiöm? Pödpödiö yadmɨn, hödal diba hömɨd aku aipam, röbö wöd hömɨd aku aipam, mönö nuŋ aku yöxön, rɨg yad mag akwör röiŋö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jisas nöbö nuŋ bla pɨsaŋ röbö alebö pön, Ban Yuö Galili möxön, mögörɨb Gerasa nöbö mö mɨdim pö ir kwo uröpɨnön, ");
INSERT INTO tmd_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","röbö alebö aku röböxön, mämäliö pɨñɨrmɨn nugugɨrön, mag akwör, ragwo ha yuö wöl mɨdöŋ nöbö i, nöbäpö hogw möl piakuyöbö hön, Jisas mɨdöŋ aku höŋa. ");
INSERT INTO tmd_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Nöbö aku nöbäpö hogw pɨlim rɨg möl piaku hölɨmön yönmɨda. Nugwo öim sen pön, iŋ wajmag nuŋ bla nɨg gö nɨgmɨdöi aku, jɨ sen bla rɨmɨn, ödörmɨn, dumɨda. Nuŋ mɨ usus rɨmɨd makwam, nugwo rɨm rɨbyöx nugub maga mɨdölöŋ. ");
INSERT INTO tmd_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Mil, pɨxmag yuö, nöbäpö hogw pɨlmɨdöi rɨg möl piaku aipam, önöŋ ajmag piaku aipam, göul nöl gɨrön, rɨg pön, mɨxɨñ nuŋwa keir wölɨxdörmɨda. ");
INSERT INTO tmd_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Makwam wop aku, nuŋ Jisas nugwo irmär nugwön, ipalɨp duön, Jisas mɨdöŋ yöra höxmax yumɨn, ");
INSERT INTO tmd_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jisas ragwo ha nöbö aku yuö wöl mɨdöŋ aku nugwo yadöŋa, “Nagö ragwo ha, nöbö gɨ röböxön röu duö!” röŋa. Jisas aliö rɨmɨn, yadöŋa, “Jisas, God ölɨsö mag keiryöbö alɨg mɨda Ha nuŋwa. Nɨ pödpöd rɨba hölö? Mönö mi yadö, ‘God nugugu mɨd aku, nɨ nagö ölɨŋ höba pɨn nölöinö,’ rane!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Aliö rɨmɨn, Jisas nöbö aku nugwo yadöŋa, “Ib nagö mɨkai?” röŋa. Aliö rɨmɨn, yadöŋa, “Nɨ ragwo ha mɨga akwör yuö wöl aku, ib na ‘Magöri,’” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nuŋ Jisas nugwo, ragwo ha bla mögörɨb hör pad piaku yad abmɨjnaŋö, rön, yad nugu gör mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Wop akwör, hön mɨga ödöriö amñö nɨmmɨdim sɨnaŋ höñ piaku. ");
INSERT INTO tmd_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Makwam, ragwo ha bla Jisas nugwo yad gögö rön yadmä, “Anɨŋ yadaŋ, duön hön pisö yuö wöluŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Aliö rɨmɨn, Jisas yöwö rɨmɨn, ragwo ha bla nöbö aku nugwo röböxön, duön hön piaku yuö wölmɨn, magalɨg tu tausan akuyöbö bɨrɨg bör rɨg aj bö duön, rɨp du röbö palön, magalɨg röbö nɨmön wöröx pörmä. ");
INSERT INTO tmd_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Makwam nöbö hön urmɨdöi piaku, alöŋ aku nugwön, rɨmgör du taun aku aipam, mögörɨb piaku aipam, mönö aku yad nölmɨn nugugɨrön, nöbö mö akuyöbö du nuguŋö, rön, Jisas mɨdöŋ yöra hömä. ");
INSERT INTO tmd_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Hön nugumɨn, nöbö höd ragwo ha mɨga akwör öim nɨgöŋ aku, wölɨj yömön, mɨd ri abön, römɨd gɨ mɨdöŋa. Nugumɨn, ölölö rɨmɨn ipöxmä. ");
INSERT INTO tmd_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nöbö mö höd mɨdim piaku, nöbö mö mai höm akuyöbö ñɨgö, nöbö ragwo ha yuö wöl mɨdöŋ nöbö aku nugwo Jisas agapɨm rɨg röŋ akuyöbö yad nölmä. Makwam hön piaku rɨg röŋ aku aipam yad nölmä. ");
INSERT INTO tmd_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Makwam nöbö mö piaku, mönö yadim aku nugwön, Jisas nugwo yad gögö rön yadmä, “Mögörɨb an gɨ röböx duö!” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Aliö rɨmɨdmɨn, Jisas röbö alebö pön duba rɨmɨn, nöbö ragwo ha öim nɨgɨm Jisas rɨm wä röŋ nöbö aku nugwo yad gögö rön yadöŋa, “Nɨ pɨsaŋ dinɨŋönö wöhö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Aliö rɨmɨn, Jisas nöbö aku nugwo wöhö rön yadöŋa, “Ram nagö duön, nöbö mö nagö bla ñɨgö, Nöbö Diba nagö mɨ göj uliöxön, agap apɨm rɨg rɨ mönö aku magalɨg yad nölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jisas aliö rɨmɨn, nöbö aku mögörɨb Dekapolis mibɨl yöra, taun yuadö aku rɨp yön gɨrön, Jisas nugwo rɨg röŋ akuyöbö, nöbö mö piaku ñɨgö magalɨg yad nölmɨn, ñɨŋ magalɨg aiö waiö rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisas piöŋö röbö alebö pön, iswob höbkal du Ban Yuö Galili ir kwo pö yöra mɨdmɨn nugugɨrön, nöbö mö mɨga hön nuŋ mɨdöŋ yöra hö rɨbmä. ");
INSERT INTO tmd_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nöbö i ib nuŋwa Jairas. Nuŋ Juda mögum rɨb ram i nugwidɨx mɨdmɨda. Jairas Jisas nugwo nugwön, hö mɨdöŋ yöra höxmax yuön, ");
INSERT INTO tmd_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","nugwo yad gögö rön yadöŋa, “Halöu ulmɨdö madmag yöbö na aku wöröxɨba rɨmɨda. Nagö han nɨ pɨsaŋ du nugwo pɨ nugwaŋ, öbɨl kömö duaŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Aliö rɨmɨn, Jisas Jairas pɨsaŋ dum nugugɨrön, nöbö mö magöri maga rɨp duön, Jisas nugwo mibɨl mibɨl nɨgön pön dumɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Makwam mö i, nuŋ mö ödöi dumɨdɨm kɨm akuyöbö möl sö yönöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mö aku uj wobɨb nöbö bla ñɨgö, nɨ rɨŋ wä raŋ, me rön, rɨg nuŋ bla magalɨg mödö nölöŋ aku, jɨ nugwo rɨm wä rɨb maga rölöŋ, mɨ uplöb du dib röxöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Makwam nuŋ Jisas rɨg rɨmɨd mönö maga yadmɨn nugwöŋ aku, du wölɨj wab nugwo aku pɨ nugumön wä raŋ, me rön, nöbö mö mɨga mɨdim mibɨl aku höglöm ada hön, Jisas wölɨja pɨ nugumɨn, ");
INSERT INTO tmd_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","wop akwör haña pɨnmɨdöŋ aku gö nɨgmɨn, yuö nuŋ bö nugumɨn, nugwo röŋ mag aku wä röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Makwam Jisas keir rɨmgör nugumɨn, ölɨsö nuŋwa bli duöŋa nugwön, höuöiliö, nöbö mö mɨga mɨdim piaku ñɨgö yadöŋa, “Wölɨj na aku yönɨm pɨ nugw?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Jisas aliö rɨmɨn, nöbö nuŋ bla yadmä, “Nöbö mö mɨga akwör nagö wabnaŋnaŋ röi aku, pödpöd rɨmɨn nɨ nöbö kai pɨ nugwö, rön, yadmɨdlö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jɨ Jisas mönö ñɨŋ yadim aku nugwölöŋ, nɨ nöbö kai pɨ nugwö, rön, hölu nugu gɨrön mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Makwam mö aku, nugwo agap apɨm röŋ aku nugwön, ipöxiö gɨl gɨl rɨ gɨr hön, Jisas mɨdöŋ yödpɨlö il yöra höxmax yuön, nugwo wä röŋ mönö aku magalɨg wöxnö yad nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jisas paiŋö nugwo yadöŋa, “Halöu na. Jisas nɨ raŋ kömö nɨgaŋ, me rön, rɨg nugw pɨlö aliar, nagö rɨmön wä rɨ maku pal. Ap naŋ ra aku wä rɨ makwam, nagö duön mɨd ri abane,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisas mönö aku yadmɨn nugugɨrön, Jairas nuŋ ram nuŋwa nöbö nuŋ bli yad abɨm hön yadmä, “Halöu nagö aku mödö wöröxa; yad nölɨb nöbö kɨ yadaŋ, yödpɨlö ölɨŋa wöröxɨp henmöm, höuöil duaŋ,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Aliö rɨmä aku, jɨ Jisas mönö ñɨgö aku yöxölöŋ, Jairas nugwo yadöŋa, “Ipöxmɨjɨnö; rɨb ölɨsö yöx nugwanö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jisas aliö rön, nöbö mö akuyöbö pɨsaŋ duöinɨŋö, rön, ñɨgö piaku yad nɨgön, Pita, Jems, Jems pɨgnɨŋ Jon, ñɨŋ yam adakwör yölɨŋön duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ñɨŋ Jairas rama uröpɨnön Jisas nugumɨn, nöbö mö mönö ib mögö möul rön, mɨ göj im gɨr mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ram möl yuadö duön yadöŋa, “Pödpöd rɨmɨn mönö ua nɨgön immɨdöi? Halöu aku wöröxöl; hör inɨmö hölɨmmɨdö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Aliö rɨmɨn, nugwo yad imöum, ñɨgö yad rɨŋö bö abön, halöu nuö nuöm mönöbö rama pön, nöbö nuŋ pɨd aku pön, yölɨŋön halöu aku wöröx gɨ mɨdöŋ ram möl yuadö duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Duön, halöu aku iŋpɨlö nugwo pön, Arameik mönö nɨgön yadöŋa, “Talita kom!” röŋa. Aliö röŋ mönö il aku, “Halöu ulmɨdö! Nagö yadmɨdla, öbɨlö!” ");
INSERT INTO tmd_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jisas halöu aku nugwo aliö rɨmɨn, wop akwör öbɨlön yönmɨdmɨn nugugɨrön, nöbö mö akuyöbö aiö waiö rɨmä. Halöu aku kɨm nuŋwa akuyöbö möl sö yönöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nöbö mö mɨdim bla aiö rɨm nugugɨrön, Jisas mönö ölɨsö yadön yadöŋa, “Ail mag aku nöbö mö akuyöbö ñɨgö wöxnö yad nölmɨjeñɨŋö,” röŋa. Aliö yad gɨr ñɨgö yadöŋa, “Halöu aku nugwo ap maga bli nölɨŋ nɨmaŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisas nöbö nuŋ bla yölɨŋön mögörɨb aku röböxön, taun nuŋwa keir Nasaret duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","Du mɨdön, Juda God höjöpalɨb wop aku, mögum rɨb ram aku duön, nöbö mö mɨga akwör hö mɨdim akuyöbö ñɨgö mönö yad nölmɨn nugugɨrön, aiö rön yadmä, “Nöbö kɨ kapeda mögörɨb kɨyöbö nöbö, Maria ha nuŋwa i. Pɨgnɨŋ nöbö Jems, Josep, Judas, Saimon maku. Nölöunɨŋ nöbö nuŋ bla pɨsaŋ mɨdöl kɨ. Jɨ mönö wä aku pikai yöbö nugwön yad? Ap rölɨbä akuyöbö agö magɨm rön rɨ?” rɨmä. Aliö rön, nugwo rɨb gwogwo yöxön höglöm nölön pölim. ");
INSERT INTO tmd_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Makwam Jisas ñɨgö yadöŋa, “Nöbö God mönö yadɨb bla, mögörɨb möl bli rɨp yönɨŋ, nöbö dib an, me rön, pɨmɨjöñ aku, jɨ mögörɨb ñɨŋ keir piaku rɨp yönmɨdɨŋ, nöbö mö ñɨŋ keir bla mönö ñɨŋ aku nugweñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nugwo nugw pölim makwam, ap rölɨbä akuyöbö bli rön alɨb maga nɨgölöŋ; nöbö mö ap röŋ piaku mösör pɨ nugumɨn, kömö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nasaret nöbö mö nugwo nugw pölim aku nugwön Jisas aiö röŋa. Jisas nuŋ piöŋö ram yöj lɨglɨg agrö mögörɨb piaku rɨp yön gɨrön, nöbö mö akuyöbö ñɨgö God Mönö maga yad nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Wop i nöbö nuŋwa akuyöbö möl sö piaku wö rɨm hömɨdmɨn yadöŋa, “Nöbö mös keir, nöbö mös keir mögörɨb piaku hörɨrör duön, mönö wä na aku yad nöiöña. Nɨ ñɨgö yad abmɨdɨl akuyöbö, mönö yad nöl yön gɨrön, ragwo ha bla yad abnöb, yad aböñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Mönö i piöŋö yadöŋa, “Dinöb cöñ aku, ap mag nɨmɨb, yogw, rɨg pɨrag dumɨjeñ; sauö rɨb akwör pɨrag diöña. ");
INSERT INTO tmd_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Yam uñ röbön kwönö ap uñ mɨxɨl paŋyöbö iör röb diöña; ap uñ bli kwo alɨg pɨrag dueñɨm. ");
INSERT INTO tmd_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ram i duŋ ñɨgö yad pöña, rama akwör mɨdön, mabö rɨ pörön, taun aku röböx dinöb cöñ wop akwör diöña. ");
INSERT INTO tmd_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Makwam mögörɨb i uröpɨnɨŋ ñɨgö yad pön, mönö ñɨgö aku nugweñ, mögörɨb aku röböx dinöb, nugwɨŋ, me rön, yamsö hauya palɨŋ pɨnaŋ dinö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jisas aliö rɨmɨn, nöbö nuŋwa akuyöbö möl sö bla, ñɨŋ mögörɨb piaku piaku duön, nöbö mö akuyöbö ñɨgö mönö yad nöl gɨr yadmä, “Ap kib mag gwogwo röi aku, pödpöd rɨmɨn aliö alölɨŋö, rön, röböxnö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Aliö rön, ragwo ha nöbö mö yuö wöl mɨdöŋ piaku mɨga yadɨm röu dum, nöbö mö ap röŋ bla mɨga wel röbö nɨg nölmɨn, kömö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Makwam Jisas röŋ akuyöbö mönö aku, mögörɨb rɨgwoŋ rɨgwoŋ akuyöbö dumɨn, kiŋ Herod algör nugwöŋa. Nöbö mö piaku, mönö aku yad nugup duön, bli yadmä, “Röbö pal nölɨb nöbö Jon wöröxɨm hogw pɨlim aku, höuöil öbɨl hön ap rölɨbä akuyöbö rɨmɨdö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bli yadmä, “Nöbö aku nöbö nagö Ilaija,” me rɨmä. Jɨ nöbö bli yadmä, “God mönö yadɨb nöbö maduar ör mɨdmɨdöi akuyöbö nöbö i hön mɨdö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Jɨ kiŋ Herod nuŋ nugwön yadöŋa, “Aku röbö pal nölɨb nöbö Jon höd göliöda römaxdörɨm akwör öbɨl hön mag akuyöbö rɨmɨdö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Aku agapɨm: höd Herod, pɨgnɨŋ Pilip mönɨŋ Herodias röd pöŋa. Pɨmɨn, Jon “Ailö aku, mag waiö i röiö. Nobɨlnɨŋ nobɨlnɨŋ nuŋwa penɨŋö,” röŋa. Makwam Jon aliö rɨmɨn, Herodias Jon nugwo nugumɨn ölɨsö wölmɨn yadɨm, Herod nöbö nuŋ bla bli yad abmɨn duön Jon nugwo nag nɨgmä. Mö Herodias, nuŋ nɨ pödpöd rön Jon nugwo pɨl pal nɨgɨnö, rön, rɨb akwör yöx nugumɨda aku, ");
INSERT INTO tmd_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","jɨ Jon mag gwogwo i rɨmɨdölöm. Nuŋ mönö kai kai yadöŋ aku, Herod nugwön mönö wä paxdöriö akwör yadö, rön, wahax pön, Jon nuŋ nöbö wä lei mɨdö, me rön, ipöxön mönö, Herodias nugwo rɨ gwogwam cönɨŋö, rön, Jon nugwidɨx ri abmɨda. ");
INSERT INTO tmd_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mö Herodias, Jon nugwo pɨl pal nɨgɨnö, rön, nugugu mɨd mɨd aku wop i, Herod nuöma nugwo yöx pön höŋ hörögö röbön wop akwör, ap diba nɨmɨba, gapman nöbö dib bla nɨgön, ami nöbö dib bla nɨgön, mögörɨb Galili nöbö dib akuyöbö mönö wob abɨm, ap diba nɨmɨba hömä. ");
INSERT INTO tmd_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Hön ap nɨmmɨdmɨn nugugɨrön, Herodias halöu nuŋwa yuadö möl aku hön höx wödmɨn, Herod aipam, nöbö dib hön ap nɨmmɨdim bla aipam nugumɨn, ñɨgö wä rɨmɨn, kiŋ Herod halöu aku nugwo yadöŋa, “Ailö aku, ap agapɨm yad nugumɨjɨnö aku nagö nöinö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Makwam mönö ölɨsö mönö ma yadön yadöŋa, “Nɨ nagö mönö mɨ ödöriö yadmɨdla, naŋ agapɨm yad nugumɨjɨnö aku nagö nöina. Mögörɨb dib nugwidɨx mɨdɨl kɨ yad nugwaŋ, nagö rɨba yadmön nugwidɨx mɨjnaŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Aliö rɨmɨn, halöua nuŋ duön nuöm Herodias nugwo, ap kai yad nugunö, rön nugumɨn, nuöma paiŋö yadöŋa, “Röbö pal nölɨb nöbö Jon yöcmac maga yadanö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nuöma aliö rɨmɨn, rɨba halöu nuŋwa rɨmgör kiŋ Herod mɨdöŋ yöra duön yadöŋa, “Wopik wop mɨdö gör, röbö pal nölɨb nöbö Jon yöcmac mag nuŋwa pön kwosö möla nɨgön rag hö nölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Aliö rɨmɨn, kiŋ Herod Jon nugwo rɨbyöx nugumɨn, mɨ ödöriö lɨb pɨlöŋa. Makwam nuŋ nöbö dib bla nugugu mɨdɨm nugugɨrön, mönö ölɨsö mönö ma halöu aku nugwo yadöŋ aku rɨbyöx nugwön, ");
INSERT INTO tmd_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","mag akwör ami nöbö nuŋ i, “Du Jon yöcmac maga rag hane,” rön yad abmɨn, du Jon göliöda römaxdörön, ");
INSERT INTO tmd_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","yöcmac maga pɨ kwosö möl i nɨgön, rag hö halöu aku nugwo nölɨm, nuŋ piöŋö rag du nuöma nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Makwam Jon nöbö nuŋ bla, Jon nugwo göliöda römaxdörim mönö nugwön, ñɨŋ du nöbäpö rag duön, rɨg möla hogw pɨlmä. ");
INSERT INTO tmd_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jisas mönö wä pön dub nöbö bla, ñɨŋ piaku piaku mabö rɨp yön pörön, höuöil hön, nöbö mö akuyöbö ñɨgö mönö bɨl kai yad nölön, ap bɨl kai rim akuyöbö, magalɨg Jisas nugwo yad nölmä. ");
INSERT INTO tmd_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nöbö mö mɨga uhömɨdmä makwam, Jisas nöbö nuŋ bla pɨsaŋ ap nɨmɨb maga nɨgölɨm, nuŋ ñɨgö yadöŋa, “An, nöbö mö mɨdölöi mibɨl yör i duön, hör mɨdɨŋ, ñɨŋ mag mɨŋi aŋöi nɨgöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Aliö rön, nöbö nuŋ bla pɨsaŋ röbö alebö pön, mögörɨb nöbö mö mɨdmɨdölöi yöra dumä. ");
INSERT INTO tmd_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Makwam ñɨŋ röbö alebö pön dum nugugɨrön, nöbö mö mɨga akwör, Jisas nöbö nuŋ bla pɨsaŋ piaku dumɨdöiŋö, rön, taun piaku piaku rɨmgör ipalɨp duön, röbö pö pö ödöi mɨxɨl aku höd duön, Jisas nöbö nuŋ bla pɨsaŋ duba rɨmɨdim piaku, höd du mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jisas nöbö nuŋ bla pɨsaŋ röbö pö yöra uröpɨnön gö nɨgön, röbö alebö röböxön, nöbö mö mɨga mɨdim akuyöbö nugwön rɨb nuŋwa keir rɨbyöx nugwön nugwöŋa, ñɨŋ hön sipsip nöbö nugwidɨx mɨdɨb i mɨdöl mag aliö akuyöbö mɨdmä. Aku nugumɨn, nuŋ lɨb pɨlmɨn, ila nɨgön ñɨgö mönö bli uplöb yad nöl mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Naiö mödö rödɨp duöŋa nugwön nöbö nuŋ bla hön nugwo yadmä, “Naiö mödö rödɨpa. Ki mögörɨb ör yörɨk mɨdöla. ");
INSERT INTO tmd_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Makwam, nöbö mö kɨyöbö yad abaŋ, ñɨŋ du ram yöj lɨglɨg agrö mögörɨb hör il me bɨlɨk duön, ap mag ñɨŋ bli wob nɨmɨŋ,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Aliö rɨmɨn, Jisas yadöŋa, “Ñɨŋ keir ñɨgö ap mag bli nöine,” röŋa. Aliö rɨmɨn, yadmä, “Aliö yadlö aku, nöbö röun akuyöbö amñaxɨb sö mabö rön rɨg pöi akuyöbö pön ap mag wob rag hön, ñɨgö nölɨb mönö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Aliö rɨmɨn, Jisas yadöŋa, “Bred mag ñɨŋa pödiö mɨd? Du nugwi!” röŋa. Aliö rɨmɨn, du nugwön yadmä, “An bred mag akuyöbö mömɨd sö, dölöm mös alɨg mɨdö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Aliö rɨmɨn, Jisas yadöŋa, “Nöbö mö kɨyöbö yadɨŋ, asɨx pɨd nuöma hörɨrör nɨgön, ap panö rol kɨyöbö römɨd gɨ mɨdɨŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Jisas aliö rɨmɨn, nöbö nuŋ piaku nöbö mö akuyöbö ñɨgö yadmɨn, bli nöbö mö padokwo padök mös höuöiliö igwö sö (50) rogwa hörɨrör paŋör rɨb gɨ mɨdön, bli nöbö mö padokwo padök mös mös höuöiliö hö wölu amñaxɨb sö (100) rogwa hörɨrör paŋör rɨb gɨ mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Makwam Jisas nuŋ bred mag akuyöbö mömɨd sö aipam, dölöm hogwa aipam pön, adöx yöd röul adö kau sö laxiö nugwön, God nugwo, ri ablaŋe rön, bred aku pɨ gɨlɨxön, nöbö nuŋ bla ñɨgö nölmɨn, ñɨŋ piöŋö nöbö mö akuyöbö nuöm nɨg nölmä. Dölöm hogwa aku, algör ör nöbö nuŋ bla nölmɨn, nöbö mö akuyöbö ñɨgö nuöm nɨg nölmä. ");
INSERT INTO tmd_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nölmɨn, nɨmmɨdɨm nɨmmɨdɨm, ñɨgö wöta bɨröŋa. ");
INSERT INTO tmd_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Bred dölöm rɨb rɨba röböxmä akuyöbö, Jisas nöbö nuŋ bla yogw pön piöxmɨn piöxmɨn, yogw akuyöbö möl sö aja wölöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ap nɨmim wop aku, nöbö piakwör paip tausan duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Makwam mag akwör Jisas nöbö nuŋ bla ñɨgö yadmɨn, röbö alebö pön Betsaida taun pö kwo dumɨn nugugɨrön, Jisas yöraku mɨdön nöbö mö pia yad abmɨn dumä. ");
INSERT INTO tmd_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yad abön, önöŋ ajmag i pisö pɨd sö wöluön, God höjöpal gɨr mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","48","Pɨxmag gurɨba röŋ mag aku, Jisas nuŋwör mɨdön nugumɨn, nöbö nuŋ bla ñɨŋ röbö alebö pön, röbö yuö mibɨl yörkwo dumɨdmɨn nugugɨrön, hödala dumɨdim adaku pik röxiö höm, mɨŋi rɨ öliöxön röbö panö rola ipöx gɨr rɨp dumɨdmä. Ruö yöudöŋ löuöŋ mag aku, Jisas röbö panö rola nöbö nuŋ bla mɨdim yöra duön, ñɨgö röb höx rɨ nɨgön, duba rɨm nugugɨrön, ");
INSERT INTO tmd_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","nugwo röbö panö rola dumɨdöŋ aku nugwön, aku nöbäpö höjöl, me rön, ölölö rɨmɨn ipöxön aiö rön göul göul nölmä. Almɨn Jisas ñɨgö yadöŋa, “Rɨb diba yöxmɨjeñ! Nɨ nör hömɨdla! Ipöxmɨjeñɨŋö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Aliö rön, röbö alebö möla dumɨn, hödal hömɨdöŋ aku hölögɨpöŋa. Almɨn, Jisas nuŋ pödpödiö aliö alö, rön, rɨb mɨga yöxmä. ");
INSERT INTO tmd_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nuŋ bred pön nöbö mö mɨga nuöm nɨg nölöŋa nugwim aku, jɨ wop aku ñɨŋ Jisas nugw pɨ cɨcɨ nɨgölim. ");
INSERT INTO tmd_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Makwam röbö mibɨla dumɨd dumɨd mögörɨb Genesaret uröpɨnön, röbö alebö aku nag wabɨl nɨgmä. ");
INSERT INTO tmd_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Röbö alebö yöraku röböx dum nugugɨrön, nöbö mö piaku Jisas hö, rɨmä nugwön, ");
INSERT INTO tmd_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","rɨmgör mögörɨb piaku piaku hörɨrör duön, nöbö mö ap röŋ akuyöbö pön, Jisas du mɨdöŋ yöra pön hömɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Wop adaku, Jisas ram yöj lɨglɨg agrö piaku mönö taun piaku mönö mögörɨb hör piaku uröpɨnmɨn, nöbö mö ap röŋ akuyöbö ñɨgö pön hö sɨmaim mibɨl yöra nɨgön, Jisas nugwo yad gögö rön yadmä, “Nagö mɨdaŋ, nöbö mö ap rɨ bla, wölɨj nagö pɨ nugwɨŋ, ñɨgö kömö nɨgaŋ,” me rɨmä. Jisas yöwö röŋa nugwön nöbö mö nugwo pɨ nugwim akuyöbö ñɨgö magalɨg wä röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Perisi nöbö bli, lo mönö yad nölɨb nöbö bli, Jerusalem yöbö hön, Jisas mɨdöŋ yöra du mɨdön, ");
INSERT INTO tmd_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","nugumɨn Jisas nöbö nuŋ bli, nöhönɨŋ apɨnɨŋ nöbö hölul rɨ ri abön, imaga röbö äbäd ab gɨrön ap nɨmmɨdöi mag akuyöbö rölim. ");
INSERT INTO tmd_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Perisi nöbö piaku aipam, Juda nöbö mö piaku aipam magalɨg, nöhönɨŋ apɨnɨŋ nöbö rɨg yadmɨdöi akuyöbö nugwön, imaga röbö äbäd abö döŋö, ap pɨ nɨmöia. ");
INSERT INTO tmd_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Sɨmaim mibɨl yöra du mɨdön, höuöil rama hön, paŋ mag akwör röbö äbäd abö döŋö, ap pɨ nɨmöia. Makwam namaga, kwosö, wi yöja, köp hölɨmɨb ap bla algör röbö äbäd abö döŋö, ap pɨ nɨmöia. Ap akuyöbö magalɨg mag kɨtɨb wä röia. ");
INSERT INTO tmd_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Makwam, Jisas nöbö nuŋ bla hör ap nɨmim aku nugwön, Perisi nöbö piaku aipam, lo mönö yad nölɨb nöbö bla aipam Jisas nugwo yadmä, “Nöbö nagö piaku pödpöd rɨmɨn, nöso auso nöbö rɨg yadim mag akuyöbö, imag ñɨŋ aku röbö äbäd abölöi wöhö, hör ör ap nɨmmɨdöi?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Aliö rɨmɨdmɨn, Jisas yadöŋa, “Ñɨŋ inakmönö hörmɨdöi aku, Aisaia mönö mɨ ödöriö yadön, God Mönö aku kai kɨtön yadöŋa, ‘Nöbö mö kɨyöbö, God iba yadɨm bɨl sö dumɨda, röi aku, jɨ hör mönö akwör yadöia; nɨ madmag nɨgölöi. ");
INSERT INTO tmd_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","God lo mönö aku yad nölölɨŋö, röi aku, jɨ nöbö mö mönö ñɨŋ keir yadöi mönö piakwör yad nölöia. Makwam, nɨ höjöpalön ib na yadɨŋ bɨl sö duen. Hör mönö akwör yadmɨdöiŋö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mag akuyöbö, ñɨŋ God mönö yad nɨgɨm aku röböxön, nöbö mö mönö ñɨŋ keir yadöi aku pön, nuö nöhönɨŋ nöbö rɨg yadöi mag akwör nugw pön mai duöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jisas ñɨgö iswob yadön yadöŋa, “Ñɨŋ rɨb wä yöx nugwön, God mönö yad nɨgöŋ aku pɨ hör piaku abön, rɨb mag ñɨŋa keir akwör nugw pön mai dumɨdöia. ");
INSERT INTO tmd_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosɨs God Mönö rɨb mɨŋi kai kɨtön yadöŋa, ‘Nauö nam rɨg yajöñ akuyöbö nugw pön, ñɨŋ pɨ ösös rɨ ri aböña; jɨ halöu ha bli nuö nuöm ñɨŋ bla ölɨsö wölaŋ mönö diba yadmɨjöñ aku, ñɨŋ ñɨgö pɨl pal nɨgɨŋ wöröxɨŋ,’ me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Makwam ñɨŋ mönö adaku ödöriar yad nölölöi. Nöbö i, acö mam röböxnöb, cön aku, nuö nuöm yajöna, ‘Acö mam, nɨ ap wä bli ñɨŋ nöbö hogwa nöilöxa, jɨ rɨg ñɨŋ nöbö hogwa nölɨb rɨg aku, wopik nɨ God nugwo nöinö, rɨl makwam, ñɨŋ nöbö hogwa nölɨb rɨg i mɨdölö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Akuyöbö alɨŋ, ñɨŋ nugwön yajöña, ‘Ñɨŋ akuyöbö alöi aku, mönö mɨdölö,’ cöña. Aliö yadɨŋ, ñɨŋ God Mönö aku röböxön, ap wä bli nuö nuöm ñɨgö nöleñ. ");
INSERT INTO tmd_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Makwam, rɨb mag ñɨŋa keir akwör yöx nugwön, mai duön, nöbö yoŋyöbö bli aipam yad nölɨŋ, ñɨŋ piöŋö nöbö yoŋyöbö bli yad nölɨŋ, alɨp duŋ nugugɨrön, God Mönö hör ap i röxg pɨ hör ki bö aböia. Makwam nuö nuöm mönö yadɨl akwör yöi; ñɨŋ ap mɨga akwör aliö paŋ mag akwör rɨmɨdöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jisas aliö rön, nöbö mö magöri rɨg mɨdim akuyöbö ñɨgö yadmɨn, nuŋ mɨdöŋ il yöra hömɨdmɨn yadöŋa, “Mönö yadɨba rɨmɨdɨl gɨ ñɨŋ magalɨg nugwön, mönö ila röx nugw ri aböña. ");
INSERT INTO tmd_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ñɨŋ ap nɨmɨŋ yuö bö pɨn diön aku pɨx pɨlenɨm; ap höbwab yuö ñɨŋ bebö röpɨn rɨŋadö höna akwör raŋ, ñɨŋ pɨxa alɨg mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ñɨŋ nöbö mö rɨmɨj möla mɨjön bla, rɨmɨj pal nɨg nugw ri abne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jisas aliö rön, nöbö mö bla ñɨgö röböxön, ram möl yuadö dumɨn, nöbö nuŋ bla nugwo yad nugumä, “Mönö höd röxön yadlö aku, ila aku mɨkai?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Aliö rɨmɨn, Jisas yadöŋa, “Nöbö mö bla ñɨŋ nugwölöi mag akuyöbö, ñɨŋ kwo algör nugwölöi ä? Ap mödöi bla amnör nɨmɨŋ, höbwab bö pɨn duaŋ, God nugum pɨx pɨlöl. ");
INSERT INTO tmd_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Aku agapɨm: ap nɨmöi piaku, madmag yuö bö duen; höbwab yuö bö ör pɨn duaŋ, höb alɨg yax aböñɨŋö,” röŋa. Jisas yadöŋ mönö aku, ap bla magalɨg paŋ nɨmɨb akwör mɨda, mödɨb ap bli mɨdölö, röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Makwam Jisas aliö rön yadöŋa, “Rɨb gwogwo yuörɨb ñɨŋ bebö röpɨn rɨŋadö hön ap akwör raŋ, nöbö mö pɨxa alɨg mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nöbö mö bla yuörɨb ñɨgö bö rɨb gwogwo yöx nugu gɨrön, ñɨŋ mag gwogwo rön, ap kib pön, nöbäpö pɨlön, mö kib nöbö kib rön, ");
INSERT INTO tmd_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ap piaku ap ana alɨg mɨdölö, rön, nöbö mö bli rɨb gwogwo yöxön, inakmönö hörön, mönö gwogwo yadön, ap piaku ap na alɨg mɨdölö rɨŋ, ölɨsö wölaŋ, nöbö mö yad höimöuön, ib ñɨŋ keira mag wölön, amɨn rön, mag gwogwo rɨb rɨb akwör yöx nugwön, röia. ");
INSERT INTO tmd_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mag gwogwo röi piaku rɨb mag i hör piakuyöbö höl. Rɨb gwogwo maga yuörɨb ñɨŋ bebö wöl aku rɨmɨn, nöbö mö God mämäg il rol nuŋwa pɨxa alɨg mɨdöia. ");
INSERT INTO tmd_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jisas mögörɨb aku röböxön, du mögörɨb taun dib Taia womiöx yörakwam duöŋa. Duön, nöbö mö piaku nɨ weik nugwölɨŋ, me rön, ram möl yuadö möl i duön umad gɨ mɨdöŋa aku, jɨ umad gɨ mɨdɨb maga mɨdölöŋ. ");
INSERT INTO tmd_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mö i, halöu nuŋ mɨda ragwo ha öim nɨgöŋ makwam, Jisas hö, rɨmɨn, nuŋ duön Jisas yödpɨlö il yöra höxmax yuön, ");
INSERT INTO tmd_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Jisas nugwo yad gögö rön yadöŋa, “Halöu na ragwo ha yuö wöl aku, yad abaŋ röu duaŋ,” me röŋa. Mö aku nuŋ Juda mö yöi. Nuŋ yöx pön hem mögörɨb Pönisia, mögörɨb Siria nöbö nugwidɨx mɨdmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Makwam aliö rɨmɨn, Jisas nugwo yadöŋa, “Höd halöu ha ap nɨmɨŋ, wöt bɨcön aku waiö. Halöu ha nölɨb ap mag aku pön wöñö abnɨŋ aku wä renɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Aliö rɨmɨn, mö aku paiŋö yadöŋa, “Nöbö Dib! Aku wä yadlö makwam, jɨ halöu ha piaku ap nɨmɨŋ, rɨb rɨba akuyöbö äbäñ mo aku pɨnaŋ, wöñö bla aipam nɨmöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Aliö rɨmɨn, Jisas mönö aku nugwön yadöŋa, “Nagö aliö yadlö aku, halöu nagö ragwo ha yuö wölön mɨd aku mödö röu dua; naŋ duö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Jisas aliö rɨmɨn, mö aku höbkal duön nugumɨn, ragwo ha röböx röu dumɨn, halöu nuŋwa köp rol yöra tar hölɨm gɨ mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jisas mögörɨb taun dib Taia il yöra röböxön, du mögörɨb taun dib Saidon il piaku palön, mögörɨb Dekapolis duön Ban Yuö Galili duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Umɨn nugugɨrön, nöbö mö piaku nöbö rɨmɨj möl idɨxɨm mönö pɨ ri abmɨdöl nöbö i pön hön, Jisas nugwo yad gögö rön yadmä, “Nöbö kɨ nugwo pɨ nugwaŋ, wä raŋ,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Aliö rɨmɨdmɨn, Jisas nöbö aku nugwo yölɨŋön hör hör yöraku duön, imag nuŋ aku rɨmɨj möla abön, imag höpöl pɨlön, albeñ nuŋ aku pɨ nugwön, ");
INSERT INTO tmd_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","laxiö adöx sö nugwön, aŋöi nɨg gɨrön, “Epata!” röŋa. Mönö yöbö yadön, “Epata,” röŋ aku, mönö il aku “Rödö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jisas aliö rɨmɨn nugugɨrön, nöbö aku rɨmɨj möla rödmɨn, ajmöla womiöxɨm nugugɨrön, mönö ödöriar pöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jisas nuŋ piöŋö nöbö mö akuyöbö ñɨgö yadöŋa, “Mönö aku nöbö mö bli yad nölmɨjeñɨŋö,” röŋa. Mönö aku mönö ölɨsö yadöŋa, jɨ ñɨŋ du mɨ usus rön nöbö mö mɨga yad nölmä. ");
INSERT INTO tmd_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mönö aku yad nölmɨdmɨn nöbö mö nugwön aiö waiö rön yadmä, “Jisas ap piaku magalɨg rɨmɨdmɨn mɨ wä ra. Nuŋ nöbö mö rɨmɨj möl idɨxön rɨ piaku rɨmɨn, rɨmɨj möla rödmɨn, nöbö mö albeñ ömörö rɨ piaku rɨmɨn, mönö pɨ ri aböiŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Wop mibɨl yör akwör, nöbö mö mɨga hö mɨdɨm, ap maga mɨdölmɨn, Jisas nöbö nuŋ bla wö rɨm hömɨdmɨn yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nɨ nöbö mö kɨyöbö ñɨgö uliöxmɨdla. Wop mös paŋ nɨ pɨsaŋ mɨdön hör mɨdöia. ");
INSERT INTO tmd_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ñɨŋ kiö akwör yad abmön, bli pad piaku höi akuyöbö, ödöi mibɨl piaku duön, mämäga mömöinö palaŋ, pɨn bɨcöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Aliö rɨmɨn, nöbö nuŋ bla yadmä, “Mögörɨb ki mibɨl ör yörɨk, ap maga pikai yöbö pön nöinɨŋö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Aliö rɨmɨn, Jisas yadöŋa, “Bred mag ñɨŋa pödiö mɨd?” röŋa. Aliö rɨmɨn, yadmä, “Akuyöbö mɨj sö,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Aliö rɨmɨn, Jisas nöbö mö akuyöbö ñɨgö yadmɨn, römɨdɨm nugugɨrön, bred mag akuyöbö mɨj sö aku pön, God nugwo ri ablaŋe, rön, pɨ gɨlɨxön, nöbö nuŋ bla nölɨm, ñɨŋ piöŋö pön, nuöm nɨgön nöbö mö nölmä. ");
INSERT INTO tmd_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Dölöm ulul pɨ gɨ mɨdim aku algör pön, God nugwo ri ablaŋe rön, nöbö nuŋ bla nölɨm, nuöm nɨg nölmä. ");
INSERT INTO tmd_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nölmɨn, nɨmmɨdɨm nɨmmɨdɨm ñɨŋ wöta bɨrɨm, rɨb rɨba röböx röböxɨp rim piaku, Jisas nöbö nuŋ bla yogw akuyöbö mɨj sö piöxmɨn aja wölöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nöbö ap nɨmim adaku, po tausan akuyöbö. Jisas nuŋ nöbö mö adaku ñɨgö yad abön, ");
INSERT INTO tmd_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","nöbö nuŋ bla pɨsaŋ röbö alebö pön, mögörɨb Dalmanuta dumä. ");
INSERT INTO tmd_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Perisi nöbö bli Jisas nugwo inakmönö hörɨŋ pödiö yajönɨŋö, rön, hön nugwo pɨsaŋ mönö yad nugup duön yadmä, “God adöx yöd röul adö kau sö mɨd ölɨsö nuŋwa pön ap rölɨbä mag cɨmala raŋ, an nugwön, God nagö yad abmɨn höraŋö, rön, nugunɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Aliö rɨmɨn, Jisas aŋöi mag diba abön yadöŋa, “Nöbö mö weik mɨdöi wop kɨ, pödpöd rɨmɨn yadöi, ‘Ap rölɨbä mag cɨmal i raŋ nuguŋö,’ röi? Nɨ ñɨgö mɨ ödöriö yadmɨdla, ñɨgö ap rölɨbä akuyöbö i rɨmön, nugweñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Aliö yadön, ñɨgö röböxön, nöbö nuŋ bla pɨsaŋ röbö alebö pön, ban yuö ir kwo wölumä. ");
INSERT INTO tmd_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Makwam nöbö nuŋ bla uplöbön, bred mɨg yöi, mag paŋyöbö iör pɨ röbö alebö möla nɨgön, pɨrag dumä. ");
INSERT INTO tmd_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Mibɨl kwo du gɨrön, Jisas ñɨgö yadöŋa, “Perisi is ñɨŋ aku aipam, Herod is nuŋ aku aipam, nugw ri abne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Aliö rɨmɨn, nöbö nuŋ bla ñɨŋ keir yad nugwob nugwob rön yadmä, “Bred mag bla aipam ragölöl aku yadmɨdö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisas nuŋ keir ñɨŋ rɨg yadim aku nugwön yadöŋa, “Pödpöd rɨmɨn bred maga ragölölɨŋö, rön, yadmɨdöi? Ñɨŋ mönö nugwön il aku nugwölöi ä? ");
INSERT INTO tmd_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mämäga nɨgöŋ aku nugwölöi? Rɨmɨj möla nɨgöŋ aku yöxölöi? Owa nugwön uplöböi? ");
INSERT INTO tmd_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nöbö paip tausan mɨdim wop aku, bred mag akuyöbö mömɨd sö pön pɨ gɨlɨx nölmön, nɨmön rɨb rɨba röböxim bla, yogw akuyöbö pödiö piöxim?” röŋa. Aliö rɨmɨn, yadmä, “Yogw akuyöbö möl sö piöxmɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Aliö rɨmɨn, yadöŋa, “Makwam nöbö po tausan mɨdim wop aku, bred mag akuyöbö mɨj sö pɨ gɨlɨx nölmön, nɨmön rɨb rɨba röböxim bla, yogw akuyöbö pödiö piöxim?” röŋa. Aliö rɨmɨn, yadmä, “Yogw akuyöbö mɨj sö piöxmɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Aliö rɨmɨn, yadöŋa, “Ñɨŋ mönö yöxön, mönö ila nugwölöiŋ ä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Makwam ñɨŋ Betsaida tauna uröpɨnmɨn nugugɨrön, nöbö mö bli nöbö mämäg we wölöŋ i pön hön, Jisas nugwo yad gögö rön yadmä, “Nugwo pɨ nugwö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Aliö rɨmɨdmɨn, Jisas nöbö mämäg we aku nugwo iŋpɨlö pön, yölɨŋön ram yöj lɨglɨg agrö rɨb yöra duön, mämäg nugwo aku höpöl pɨlön, nugwo pɨ nugwön, yadöŋa, “Mämäg nagö ap bli nugumɨdlanö owa?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Aliö rɨmɨn, yadöŋa, “Yöwö. Nöbö mö bla nugumɨdla, jɨ bɨ höu röxgɨb bla yönmɨdöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Aliö rɨmɨn, Jisas iswob mämäg nuŋwa pɨ nugumɨn, rɨb pia wä rɨmɨn ap bla magalɨg nugw ri aböŋa. ");
INSERT INTO tmd_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Makwam Jisas nöbö aku nugwo yadöŋa, “Iswob höbkal ram yöj lɨglɨg agrö nöbö mö mɨdöi pö kwo wölumɨjɨnö; ram nagö paxdöriar duö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisas nöbö nuŋ bla pɨsaŋ ram yöj lɨglɨg agrö taun dib Sisaria Pilipai il yöra dumä. Ödöi mibɨl yöra du gɨrön ñɨgö yadöŋa, “Nöbö mö piaku, nɨ yönɨmɨm me rön nugwöiŋö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Aliö rɨmɨn, yadmä, “Nöbö mö bli nagö röbö pal nölɨb nöbö Jon aku, me röia; bli Ilaija, me röia; bli God mönö yadɨb nöbö keir i, me röiŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Aliö rɨmɨdmɨn, Jisas ñɨgö yadöŋa, “Ñɨŋ keir nɨ yönɨm, me rön, nugwöi?” röŋa. Aliö rɨmɨn, Pita yadöŋa, “Naŋör mɨ Mesaia maku,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Aliö rɨmɨn, Jisas yadöŋa, “Nöbö mö akuyöbö mönö aku wöxnö yad nölmɨjeñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jisas nuŋ ila nɨgön, nöbö nuŋ akuyöbö ñɨgö mönö yad nölön yadöŋa, “Nöbö Ha nuŋwa ölɨŋ höb diba ödöriö pöna. Mönö pɨ nuöm nɨgɨb nöbö dib bla aipam, God ap höjöpal ur nölɨb nöbö dib bla aipam, lo mönö yad nölɨb nöbö bla aipam, nugwo nugwɨŋ, ölɨsö wölaŋ, pɨl pal nɨg gɨŋ, nuŋ wöröxön, wop mös mɨdön, wop paŋ aku höbkal öbiönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jisas mönö aku wöxnö yadɨm, Pita nugum, wä rölɨm, Jisas nugwo pön du rɨb yöraku duön, nugwo yad gɨrön yadöŋa, “Mönö aliö akuyöbö yadmɨjɨnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jɨ Jisas höuöiliö, nöbö nuŋ bla ñɨgö nugwön, Pita nugwo yadöŋa, “Seten! Naŋ höglöm nɨ adö duö! God rɨbyöx nugw rɨb akuyöbö yadmɨdöiö; nöbö mö piaku rɨbyöx nugwöi rɨb akuyöbö yöx nugwön yadmɨdlanö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jisas aliö rön, nöbö nuŋ bla aipam, nöbö mö mɨga mɨdim akuyöbö aipam wö rɨm, il yöra hömɨdmɨn yadöŋa, “Nöbö mö yön yön nɨ pɨsaŋ mɨdɨba cöñ bla, ap agapɨm mögörɨb rol il kɨ rɨb diba yöx nugwöi aku röböxön, mɨxɨñ ñɨŋa keir rɨb diba yöx nugwöi aku röböxön, bɨ katlö watlö waba pɨ ragpɨd nɨg ragön nɨ mai höŋ. ");
INSERT INTO tmd_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nöbö mö, Jisas nugw pön mɨdɨŋ wä renɨŋö, rön, nugwöñ bla, mɨ aŋadö pɨn bɨcöña. Makwam nöbö mö, Jisas nugw pön, mönö wä nuŋwa nugw pön mɨdɨŋ, anɨŋ rɨ gwogwam cöñ aku mönö mɨdölö, rön, rɨŋ diön nöbö mö akuyöbö, God raŋ öim öim mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","“Makwam nöbö mö, ap waiö mögörɨb rol il kɨ mɨga akwör pɨnɨŋö, rön, rɨŋ duaŋ, mögörɨb il kɨ mɨd ap akuyöbö magalɨg pöña, jɨ öim mɨdɨb mag aku peñɨm. ");
INSERT INTO tmd_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ap waiö akuyöbö magalɨg rag du sɨm rön, öim mɨdɨb mag aku wobɨb maga mɨdöl. ");
INSERT INTO tmd_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Weik wop kɨ nöbö mö ñɨŋ nöbö mö kib mag yönön, ap kib mag gwogwo rɨ gör mɨdöi aku, nöbö mö kai nɨ aipam mönö na aipam möigw yöxöñ aku, mai Nöbö Ha nuŋwa Nuö mil mag wä keiryöbö pön, ejol lei bla pɨsaŋ hön wop aku, nuŋ ñɨgö algör ör möigw yöxön, ‘Nöbö mö akuyöbö ñɨgö nugumɨdöiö,’ cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jisas aliö rön, mönö i yadöŋa, “Nɨ ñɨgö mönö mi yadmɨdla, ñɨŋ nöbö mö mɨdöi kɨyöbö bli kömö mɨdɨŋ nugugɨrön, God nöbö mö pön nugwidɨx mɨdɨb wop aku, mil ölɨsö mag diba alɨp haŋ nugwöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Makwam mai wop akuyöbö iŋösu bö mɨdön, Jisas nuŋ Pita Jems Jon ñɨgö yam ada yölɨŋön, mögörɨb nöbö mö mɨdölim höñ i pisö wölu önöŋ ajmag pɨd sö wölumä. Wöluön, Jisas nugwo nugumɨn nugugɨrön, mɨxɨñ nuŋwa mɨ keiryöbö wöxnö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Wölɨj nuŋ aku lei gudogudö wä keiryöbö wöxnö nɨgɨm, mil milöu gɨ mɨdöŋa. Nöbö mö mögörɨb mɨgrö kɨ i wölɨj bli röbö pɨlön pɨl patön rɨm, lei gudogudö aliö akuyöbö röxgɨb maga mɨdöl. ");
INSERT INTO tmd_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Makwam nugumɨn, Ilaija Mosɨs yöŋö hön Jisas pɨsaŋ mönö pɨmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ñɨŋ nugwön, Pita Jisas nugwo yadöŋa, “Mönö yad nölɨb nöbö, an yörɨk mɨdɨm mɨ wä ra! Makwam, an ram bötö mea mös paŋ urön; nagö i, Mosɨs i, Ilaija i,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ñɨŋ ipöxmɨdim aku döŋö, Pita rɨbyöx nugw ri abölöŋ wöhö, amnör aliö yadöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Makwam mɨjöi wab i hön, ñɨgö pɨ yuö abmɨn nugugɨrön, mönö i mɨjöi yuö yör sö pik yadöŋa, “Aku Ha madmag yöbö nɨ ödöriö. Mönö yajöna akuyöbö nugune,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Aliö rɨmɨn nugugɨrön, ñɨŋ adadö nugumɨn, nöbö hogw aku mɨdölɨmem; Jisas nuŋwör mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Makwam ñɨŋ pɨd sö röböxön, hö pɨn gɨrön, Jisas yadöŋa, “Pɨd gɨ hömɨdmɨn ap rɨmɨda nugwöi aku, weik nöbö mö bli yad nölmɨjeñ. Mai Nöbö Ha nuŋwa wöröxön öbiön wop aku, wöxnö yad nöine,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Aliö rɨmɨn, nöbö nuŋ bla nöbö mö bli yad nölölim; ñɨŋ keir yad nugwob nugwob rön yadmä, “Wöröxön öbinö, ra aku, mönö il aku mɨkai?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Aliö rön, Jisas nugwo yad nugwön yadmä, “Lo mönö yad nölɨb nöbö bla pödpöd rɨmɨn yadöi, ‘Ilaija höd hönɨŋö,’ röi?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Aliö rɨmɨdmɨn, Jisas yadöŋa, “Mi yadöia. God Mönö maga kai kɨtön yadmä, ‘Nöbö Ilaija höd hön ap piaku rɨ pɨdɨlumɨjönɨŋö,’ rɨmä. Makwam God Mönö aku mönö i kai kɨtön yadmä, ‘Nöbö mö piaku Nöbö Ha nuŋwa nugwo peñ; ñɨŋ nugwo ölɨŋ höb diba pɨ nöiöñɨŋö,’ rim mönö aku, pödpöd rɨmɨn aliö yadöiŋö, rön, nugwöi? ");
INSERT INTO tmd_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ilaija mönö yadmä aku, mai hönɨŋö, rön, rɨb aku yöx nugumɨjeñ. Nuŋ mödö höm nugwön, rɨb ñɨŋa keir yöx nugwön nugwo amnör rɨ gwogwam rɨmä. Aku makwam, God Mönö aku kai kɨtön, nugwo rɨg cöñɨŋö, rim mag akwör röiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Makwam ñɨŋ up bö pɨn duön nugumɨn, lo mönö yad nölɨb nöbö bli, Jisas nöbö nuŋ akuyöbö mac sö pɨsaŋ nuö nuö yad mɨdɨm nugugɨrön, nöbö mö mɨga akwör hön, ñɨgö pɨ yuö abön nugugu mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Aliö nugugu mɨdɨm nugugɨrön, Jisas höröpɨnmɨn, nöbö mö hö mɨdim akuyöbö, aiö rön, du nugwo yad wahax pɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jisas nöbö nuŋ bla ñɨgö yad nugwön yadöŋa, “Pödpöd rɨmɨn nuö nuö yadmɨdöiŋö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Aliö rɨmɨn nugugɨrön, nöbö i nöbö mö mɨdim mibɨl yöra yadöŋa, “Mönö yad nölɨb nöbö. Ha na aku, ragwo asa yuö wölɨm, mönö pöl. ");
INSERT INTO tmd_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Wop bli nugwo uplöb rɨmɨn, pɨn bɨrön, ajmöla höpöl höbwa röpɨnmɨn, ajmaga öbɨx kɨt kɨt yuön, iŋ wajmag mɨxɨñ pɨ iñ rɨ nölɨp ra. Öim akuyöbö almɨn almɨn, nɨ pön höl aku, jɨ nöbö nagö akuyöbö ñɨgö yadmön, ragwo asa aku yad ab wöhö nugwön röböxöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Aliö rɨmɨdmɨn, Jisas ñɨgö yadöŋa, “Ñɨŋ nöbö mö weik mɨdöi kɨyöbö God nugw pɨ cɨcɨ nɨgölöi. Wop kai nugwo nugw pön, ap piaku ñɨŋ keir cöñ? Mönö öim yadmön nugwöi aku, jɨ nɨ pödpödiö mönö kɨtɨb wä yadmön nugwöñ? Ha aku pɨn mɨdɨl yörɨk pön höi!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Aliö rɨmɨn, pön Jisas mɨdöŋ il yöra pön höm, ragwo asa nugwo öim nɨgöŋ aku, Jisas nugwo nugwön, ha aku nugwo rɨmɨn, pɨn bɨrön, wöj wöj nölmɨn, höpöl wöl höpöl höbwa hör pɨnöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Almɨn, Jisas ha aku nuö yad nugwön yadöŋa, “Ap aku wop kai röŋ?” röŋa. Aliö rɨmɨn, yadöŋa, “Maduar haŋala mɨdöŋ wop akwör röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ragwo as aku, nugwo öim pɨl pal nɨgɨnö, rön, rɨn yönmɨd rɨn yuö bla aipam, röbö yuö bla aipam pal wöd abmɨda. Almɨd makwam, anɨŋ nuarö uliöxön, ap aku yad abɨb maga cön aku, yad abö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Aliö rɨmɨn, Jisas yadöŋa, “Nɨ pödpöd rɨmɨn, ‘Yad abɨb maga cön aku, yad abö,’ rön, yadmɨdlö? Rɨg yad nugun mag akuyöbö cönɨŋö, rön, rɨbyöx nugunö aku, rɨg yad nugunö mag akwör cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Jisas aliö rɨmɨn, ha nuö aku yadkap ör yadöŋa, “Nagö nugw pɨla; mag aku cɨnaŋö, rön, rɨb aku yöx nugul aku, jɨ rɨb mös yöxbä maga ra aku, nɨ rɨb wä nölan nugwön nɨ mɨ aŋadö nugw pɨnöm,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Makwam nöbö mö mɨga, nuarö hogwa Jisas pɨsaŋ mɨdim yöra, ipalɨp hömɨdmɨn nugwön Jisas ragwo as aku nugwo yadöŋa, “Nagö ragwo asa, nöbö mö rɨman rɨmɨj möla idɨxim mönö pɨmɨdölöi aku, nagö yadmɨdla, ha aku nugwo röböxön, aŋadö röu duö, mai höuöil hömɨjnaŋö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jisas aliö rɨmɨn, ragwo as aku aiö diba rön, röu dinöb rön, ha aku nugwo rɨmɨn, göur du pɨn bɨrön, gɨl gɨl rɨ, rɨ gö nɨgmɨn, nöbö mö mɨga yadmä, “Ha mödö wöröxö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Aliö yadɨm aku, jɨ Jisas iŋpɨlö nuŋ aku pön, nugwo pabɨl nölɨm, nuŋ kömö mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mai Jisas ram möl yuadö duön, nöbö nuŋ bla pɨsaŋ ñɨŋör mɨd gɨr, nugwo yadmä, “Pödpöd rɨmɨn an ragwo as aku yad ab wöhö nugwöl?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Aliö rɨmɨn, Jisas yadöŋa, “Ragwo as akuyöbö hör yad abeñ; God höjöpal mɨjöñ akwör röu diöña. Hör aku röu dueñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Jisas nöbö nuŋ bla yölɨŋön, mögörɨb aku röböxön, mögörɨb Galili mibɨl yöra du gɨrön, nöbö nɨ akuyöbö ñɨgö mönö yad nöl ri abne, rön, tar umad gɨ mɨdön, ñɨgö yad nölmɨda. Ñɨŋ yad nölön yadöŋa, “Nöbö Ha nuŋwa nugwo wöñö u rön nöbö bli ñɨgö nölaŋ, nugwo pɨl pal nɨg gɨŋ, wöröxön, wop mös mɨdön, wop paŋ aku höbkal öbiönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nuŋ aliö rɨmɨn nugugɨrön, mönö il aku mɨkai, me rön, nugwo yad nugwöyɨx aku, jɨ ipöxön yad nugwölim. ");
INSERT INTO tmd_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Makwam ödöi mibɨl yöra du gɨrön, Jisas nöbö nuŋ piaku, “Nör nöbö diba, nagö nöbö dib yöi,” me rɨ gɨrön, nuö nuö yadmɨn duöŋa. Du Kapaneam uröpɨnön, ram möl yuadö duön, Jisas ñɨgö yad nugwön yadöŋa, “Ödöi mibɨl yöraku hö gɨrön, mönö kai yadɨp höi?” röŋa. Aliö rɨmɨn, nöbö nuŋ bla mönö aku yad nugu gɨrön hem aku nugwön, möigw yöxön, paiŋö yad nölölim. ");
INSERT INTO tmd_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yad nölmɨdölɨm, Jisas du römɨdön, nöbö nuŋwa akuyöbö möl sö akuyöbö ñɨgö yadɨm hömɨdmɨn yadöŋa, “Nöbö mö diba mɨdɨba cöñ piaku, nöbö mö hör mabö rɨ nölöi akuyöbö mɨdön, nöbö mö bli ñɨgö magalɨg mabö rɨ nölɨŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Aliö rön, ha ulmɨdö i pön hön mɨdim mibɨl yöra nɨgön, wob gɨrön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Nöbö mö nɨ nugw pön, ha ulmɨdö aliö kɨyöbö röxgɨb paŋyöbö i pɨ ösös ri abmɨjöñ aku, ha aku nugwör wöhö, nɨ aipam pöña. Makwam nɨ pöñ aku, nör wöhö, Acö na yad abmɨn höm aku nugwo aipam pöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Makwam Jon Jisas nugwo yadöŋa, “Mönö yad nölɨb nöbö. Nöbö i ib nagö urön, ragwo ha yad abɨm röu dumɨn, an nugwön nugwo yadmɨŋa, ‘Nagö nöbö an pɨsaŋ nɨgiö nɨgön yönölöl aku, akuyöbö almɨjɨnö,’ rɨmɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Aliö rɨmɨn, Jisas paiŋö nugwo yadöŋa, “Nugwo pödpöd rɨmɨn wöhö rim? Nöbö mö nɨ rɨbyöx nugwön, ib na urön, ap rölɨbä akuyöbö bli rɨmɨjöñ aku, mai höuöilön nɨ mönö gwogwo yadeñ. ");
INSERT INTO tmd_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nöbö mö an höx mɨdölöi akuyöbö, ñɨŋ nöbö mö nugub an. ");
INSERT INTO tmd_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Makwam nugwi! Nöbö mö yönɨmɨm, ñɨgö Jisas nöbö nuŋ, me rön, röbö un nölɨŋ nɨmöñ aku, God ñɨgö pɨ ri abönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Makwam nöbö mö bli hön, halöu ha nɨ nugw pöi bla, ñɨgö ap kib mag gwogwo mag aku rɨ yabuŋ, ñɨŋ nɨ uplöbön mag gwogwo rɨmɨjöña. Nöbö mö akuyöbö alɨba rɨmɨjöñ aku, höd rɨg dib i göliöda aku nɨgiö nag nɨg gö nɨgön, pön du ban yuö diba aböyɨx aku waiö. Jɨ kömö mɨdön, aliö mag gwogwo rɨmɨjöñ aku, mɨ ödöriö ölɨŋ höb diba pöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Jisas aliö rön yadöŋa, “Imag i raŋ, ñɨŋ ap kib mag gwogwo rɨba rɨmɨdöi aku, iŋpɨlö adaku römaxdör abɨŋ, iŋpɨlö paŋ adöi ör mɨjöna. Akuyöbö alön, ap kib mag gwogwo akuyöbö reñ aku, kömö diöña. Makwam imag hogwa mösör mɨdaŋ, mag gwogwo rön, mögörɨb rɨn öim yönmɨd yöra diöña. ");
INSERT INTO tmd_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Mögörɨb aku, ‘ñɨgö meja öim nölaŋ mɨd gɨrön, rɨna yön gör mɨjöna.’ ");
INSERT INTO tmd_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Yampɨlö aku algör. Yampɨlö i raŋ, ñɨŋ ap kib mag gwogwo rɨba rɨmɨdöi aku, yampɨlö adaku römaxdör abɨŋ, yampɨlö paŋ adöi ör mɨjöna. Akuyöbö alön, ap kib mag gwogwo akuyöbö reñ aku, kömö diöña. Makwam yödpɨlö hogwa mösör mɨdaŋ, ñɨŋ mag gwogwo rɨŋ, ñɨgö mögörɨb rɨn hör yönmɨd möl bö abaŋ, ölɨŋ höb diba pöña. ");
INSERT INTO tmd_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Mögörɨb aku, ‘ñɨgö meja öim nölaŋ mɨd gɨrön, rɨna yön gör mɨjöna.’ ");
INSERT INTO tmd_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mämäg aku algör. Mämäg i raŋ, ñɨŋ ap kib mag gwogwo rɨba rɨmɨdöi aku, mämäg pɨlö adaku pɨn gul rɨ abɨŋ, mämäg paŋ adöi ör mɨjöna. Akuyöbö alön, ap kib mag gwogwo akuyöbö reñ aku, God mögörɨb nuŋ sö diöña. Makwam mämäg hogwa mösör mɨdaŋ, ñɨŋ mag gwogwo rɨŋ, ñɨgö mögörɨb rɨn hör yönmɨd möl bö abaŋ, ölɨŋ höb diba pöña. ");
INSERT INTO tmd_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mögörɨb aku, ‘ñɨgö meja öim nölaŋ mɨd gɨrön, rɨna yön gör mɨjöna.’ ");
INSERT INTO tmd_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Hömñaŋ uña bɨ urɨŋ yönön usö wä nɨgön mag akuyöbö, God nuŋ ñɨgö nöbö mö magalɨg mag aliö akuyöbö cöna. ");
INSERT INTO tmd_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Usö sol ap id wä ödöriö aku, jɨ usö id nuŋ aku pal mag duaŋ, pödpödiö rön rɨŋ, yöra usö id yöñön? Aku makwam, ñɨŋ nöbö mö usö id akuyöbö röxg mɨdön, nöbö mö bli madmag nɨgön, pɨsaŋ tar mɨjne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jisas Kapaneam röböxön, mögörɨb Judia mibɨl piaku duön, du röbö Jodan möxön, ir kwo duöŋa. Nöbö mö piaku nugwön, hö mögum rɨmɨdɨm nugwön nuŋ öim rɨg rɨmɨd akuyöbö ñɨgö mönö yad nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Perisi nöbö bli, Jisas pödi yajönɨŋö, rön, hön nugwo yad nugwön yadmä, “Lo mönö kaiyöbö mɨd? Nöbö piaku mö pön, yad abnöb, yad aböñɨŋönö owa?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Aliö rɨmɨdmɨn, Jisas yadöŋa, “Mosɨs God Mönö kai kɨtön, ñɨgö mönö kai yadöŋ?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Aliö rɨmɨn yadmä, “Mosɨs yadöŋa, ‘Mö yad abnöb, “Nagö yad abmɨdlö,” rön, köp mea i kai kɨtön nugwo nölön, yad abɨb,’ me rö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Aliö rɨmɨn, Jisas yadöŋa, “Ñɨgö mi yadmɨdöi aku, jɨ maduar God nuŋ nöbö aiöñɨŋö, rön, rɨbyöx nugwölöŋ. Mosɨs ñɨgö God mönö yad nölmɨn, ñɨŋ rɨmgör pölöi aku, nuŋ lo mönö aku kai kɨtöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Makwam God mögörɨb maduar ib hör i rɨ nɨgöŋ wop aku, nöbö rɨ nɨgön, mö rɨ nɨgön, röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Adaku mɨ, nöbö piaku nuö nuöm nöbö pɨsaŋ mɨdön, du mö pön, ñɨgö röböxön, ");
INSERT INTO tmd_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ñɨŋ mönöbö hogwa nɨgiö nɨgön hölɨmɨŋ nugugɨrön mɨxɨñ paŋyöbö i nɨgöna. Mai hörɨrör mɨdeñ wöhö, nɨgiö nɨgön paŋör mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","God yadmɨn, nöbö mö pön mɨxɨñ paŋyöbö nɨgön aku, nöbö bli du ñɨgö yadön pal kɨtu hörɨrör nɨgeñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Aliö rön, nöbö nuŋ bla pɨsaŋ höuöil ram möl yuadö duön, Jisas nugwo mönö adaku iswob yad nugumä. ");
INSERT INTO tmd_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jisas yadöŋa, “Nöbö i mö pön, yad abön, du mö yoŋyöbö pön aku, God mämäg il yöra, nuŋ mö kib pɨb nöböm. ");
INSERT INTO tmd_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mö aku, algör ör, nöbö pön, röböxön du nöbö yoŋyöbö pön aku, nuŋ nöbö kib pɨb mö,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nöbö mö bli, Jisas halöu ha an bla pɨ nugwaŋ, me rön, pön hömä, jɨ nöbö nuŋ akuyöbö ñɨgö yadyöxmä. ");
INSERT INTO tmd_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Almɨdɨm, Jisas nugum, ölɨsö wölɨm, yadöŋa, “Halöu ha ulul bla röböxɨŋ, nɨ pöl höŋ. God mögörɨb aku halöu ha ulul aliö akuyöbö röxg mɨdöia. ");
INSERT INTO tmd_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nɨ ñɨgö mi yadmɨdla, nöbö mö piaku, halöu ha ulul bla God mögörɨb adöx yöd röul adö kau sö mönö aku nugw pöi mag akuyöbö ñɨŋ kwo nugw peñ aku, God mögörɨb nuŋ sö dueñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Aliö rön, halöu ha ulul bla ñɨgö pɨ wob gɨrön, imag nuŋwa yöcmac ñɨŋa rol sö nɨgön yadöŋa, “God ñɨgö nugwidɨx mɨdaŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Makwam Jisas dumɨn nugugɨrön, nöbö i ipalɨp hön, Jisas mɨdöŋ il yöra höxmax yuön, yadöŋa, “Mönö yad nölɨb nöbö wä! Nɨ pödpöd rön öim mɨdɨb maga pɨn?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Aliö rɨmɨn, Jisas yadöŋa, “Nɨ pödpöd rɨmɨn, ‘Nöbö wä,’ me rɨlö? Nöbö mö i wä mɨdölöi; God paŋyöbö akwör wä mɨda. ");
INSERT INTO tmd_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Makwam nagö God lo mönö aku nugulö: ‘Nöbäpö pɨlmɨjeñ; mö kib nöbö kib rɨmɨjeñ; ap kib pɨmɨjeñ; mönö diba yadön inakmönö hörmɨjeñ; inakmönö hörön nöbö mö bli ap ñɨŋ bla röul ab pɨmɨjeñ; nauö nam yöŋö rɨg yajöñ mag algör rön mai cɨne,’” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Jisas aliö rɨmɨn, nöbö aku Jisas nugwo yadöŋa, “Mönö yad nölɨb nöbö. Nɨ ha ulmɨdö akwör mɨdön, lo mönö piaku magalɨg nugu gɨrön mɨdlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Aliö rɨmɨn, Jisas nugwo nugwön, madmag nɨgön, yadöŋa, “Nagö ap paŋyöbö iör röiö. Nagö duön, ap nagö pödpödiö mɨd akuyöbö sɨm rɨ, rɨg pön, nöbö mö ap mɨdöl akuyöbö ñɨgö nölö. Akuyöbö ainö aku, ap wä naŋ aku mɨjön God mögörɨb adöx yöd röul adö kau sö. Rɨg yadɨl akuyöbö rön, han, nɨ pɨsaŋ yönmɨdɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jisas aliö rɨmɨn, nöbö aku ap nuŋwa mɨga mɨdöŋ makwam, lɨb pɨlɨm, rɨb diba yöx nugu gɨrön duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jisas nöbö nuŋ akuyöbö ñɨgö nugw yön pörön yadöŋa, “Nöbö mö ap mɨga mɨjön akuyöbö mɨŋi rɨ öliöxön God nöbö mö nuŋwa mɨdɨŋ, ñɨgö pön ram nuŋ sö nugwidɨx mɨjönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Aliö rɨmɨn, nöbö nuŋ bla mönö aku nugwön, rɨb mɨga yöxmɨdɨm nugugɨrön, Jisas ñɨgö iswob yadöŋa, “Halöu ha nɨ kɨyöbö, mönö yadmɨdɨl kɨ nugwi. God mögörɨb sö mɨŋi rɨ öliöxön dub maga mɨda! ");
INSERT INTO tmd_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Hön kamel i kai mauöla nag aböi möla dinöb diöna, jɨ nöbö mö köme ulnöu rɨg ap piaku mɨga mɨd akuyöbö, God mögörɨb nuŋ sö mɨŋi rɨ öliöxön diöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jisas aliö rɨmɨn, nöbö nuŋ bla aiö waiö rön, paiŋö yad nugwob nugwob rön yadmä, “Aku makwaim, yönɨm öim mɨdɨb maga pön?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Aliö rɨmɨn, Jisas ñɨgö nugu gɨrön yadöŋa, “Nöbö mö ñɨŋ keir rɨb maga mɨdöl; God nuŋwör agap apɨm cɨnöb, paŋ rɨb akwör mɨdö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Makwam Pita Jisas nugwo yadöŋa, “Mɨ! An nagö pɨsaŋ yön gɨrön, ap an bla magalɨg röböxölɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Aliö rɨmɨn, Jisas yadöŋa, “Nɨ ñɨgö mi yadmɨdla, nöbö mö nɨ rɨbyöx nugwön, mönö wä na mabö aku rɨba, mögörɨb ñɨŋa röböxön, nɨmam nölöunɨŋ ñɨŋ bla röböxön, nuö nuöm ñɨŋ bla röböxön, halöu ha ñɨŋ bla röböxön, mabö rɨb ñɨŋ bla röböxön, mabö na rɨmɨjöñ aku, ");
INSERT INTO tmd_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","God ñɨgö pɨ ösös rɨ ri aböna. Ñɨgö nugwidɨx mɨdaŋ, mögörɨb rol il kɨ mɨjöñ wop aku, ram rɨb, nɨmam nölöunɨŋ, nuöm, halöu ha, mabö rɨba ñɨŋa mɨ mɨga mɨjöna. Makwam wop bli nöbö mö piaku bli, ñɨgö nöbö mö nɨ pɨsaŋ mɨdöi aku nugwön, ñɨgö rɨ gwogwam cöña. Mai God nuŋ ñɨgö pön mögörɨb nuŋ sö pön duaŋ, nuŋ pɨsaŋ öim mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Jɨ nöbö mö wopik höd dumɨdöi piaku, mai mɨga mɨ höglöm adö bö mɨjöña. Makwam nöbö mö wopik mɨ höglöm adö bö mɨdöi piaku, mai mɨga akwör höd dumɨjöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Makwam ñɨŋ Jerusalem du gɨrön, Jisas höd dumɨn, nöbö nuŋ bla mai duön, rɨb mɨg mɨga yöx nugu gɨrön dumɨdmɨn nugwön nöbö mö mai hömɨdim piaku nugwön ipöxmä. Jisas nöbö nuŋwa akuyöbö möl sö piaku ñɨgör yölɨŋön, rɨb piaku duön, ap agapɨm nugwo rɨba röŋ aku ñɨgö iswob yad nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jisas yadöŋa, “An Jerusalem duŋ nugugɨrön, nöbö i Nöbö Ha nuŋwa nugwo höuöu rɨ pön du, God ap höjöpal ur nölɨb nöbö dib bla aipam, lo mönö yad nölɨb nöbö bla aipam imag ñɨgö nɨgaŋ, nugwo mönö diba yadön, ‘Nöbö kɨ nugwo pɨl pal nɨgɨb,’ me rön, pɨ Juda nöbö yöi akuyöbö ñɨŋ nöiöña. ");
INSERT INTO tmd_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nölɨŋ, nugwo yad höimöuön, höpöl pɨlön, naga pɨ palön, pön du aŋadö pɨl pal nɨg gɨŋ wöröxöna. Makwam wop mös mɨdön, wop paŋ aku höbkal öbiönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebedi ha nuŋ hogwa, Jems Jon yöŋö hön Jisas nugwo yadmä, “Mönö yad nölɨb nöbö, an nöbö hogwa nagö mönö i yad nugwɨŋ, naŋ yöwö cɨnö aku ri abnaŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Aliö rɨmɨn, Jisas ñɨgö yadöŋa, “Ñɨŋ nɨ yad nuguba rɨmɨdöi aku, nɨ ñɨgö pödpöd cɨnö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Aliö rɨmɨn yadmä, “Mai nagö mil mag wä alɨg mɨdön, mögörɨb magalɨg kiŋ röxg nugwidɨx mɨjɨnö wop aku, anɨŋ nöbö hogwa, nöbö i pɨ imag mɨrɨx adö nɨgön, nöbö i pɨ imag cökö adö nɨgaŋ, römɨd gɨ mɨdɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Aliö rɨmɨn, Jisas yadöŋa, “Ñɨŋ hödpɨg nöbö hogwa, nugw ri abön yadmɨdölöi. Röbö acɨxa nɨ nɨmɨba rɨmɨdɨl aku, ñɨŋ nöbö hogwa algör nɨmöñɨŋöd? Nɨ röbö yaxɨn aku, ñɨŋ nöbö hogwa algör yaxöñɨŋöd?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Jisas aliö rɨmɨn, yadmä, “Yöwö, ainɨŋö,” rɨmä. Aliö rɨmɨn, Jisas yadöŋa, “Mi yadmɨdöia. Röbö acɨxa nɨ nɨmɨba rɨmɨdɨl aku, ñɨŋ nöbö hogwa algör nɨmöña; nɨ röbö yaxɨn aku, ñɨŋ nöbö hogwa algör yaxöña. ");
INSERT INTO tmd_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Jɨ nöbö kai imag mɨrɨx nɨ adö mɨjön, nöbö kai imag cökö nɨ adö mɨjön, aku nɨ yadöin; aku Acö ap nuŋ; nuŋ keir rɨbyöx nugw mag akwör cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Makwam Jisas nöbö nuŋ akuyöbö ragpɨd sö mönö aku nugumɨn, ñɨŋ ölɨsö wölmɨn, Jems Jon nöbö hogwa yadyöxmä. ");
INSERT INTO tmd_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Akuyöbö almɨn, Jisas ñɨgö magalɨg yadɨm hömɨdmɨn yadöŋa, “Ñɨŋ nugwöia, Juda nöbö mö yöi piaku, kiŋ ñɨŋa ususör rön nugwidɨx mɨdöia; nöbö dib ñɨŋa mönö kai kai yajöñ aku nugwön anau pön mai diöña. ");
INSERT INTO tmd_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Makwam ñɨŋ rɨg röi mag akuyöbö rɨmɨjeñ. Nöbö kai nöbö diba mɨjön aku, nöbö ulmɨdö röxg mɨdön, nöbö mö bli mabö rɨ nölɨb nöbö röxg mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nöbö kai nöbö dib ödöriö mɨjön aku, nöbö ulmɨdö mɨdöi röxg mɨdön, nöbö mö adö bli ñɨgö magalɨg nag mabö rɨ nölɨb nöbö i röxg mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nöbö Ha nuŋ aku, nöbö mö akuyöbö ñɨŋ mabö na rɨŋ, me rön, hölöŋ; mabö ñɨgö rɨ nölɨp dumɨdön, mai ap kib mag gwogwo röi rol aku höj rɨ wöröxmön, nöbö mö mabuö kömö duŋ, me rön, hö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jisas nöbö nuŋ bla pɨsaŋ taun dib Jeriko uröpɨnmä. Ñɨŋ Jeriko röböx duba, nöbö mö mɨga pɨsaŋ dumä. Nöbö Timeas ha nuŋwa Batimeas mämäg we wölöŋ aku, rɨg nöine, rön, sö rɨg rɨ, ödöi kwol yöraku römɨd gɨ mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Römɨd gɨ mɨdmɨn nugugɨrön, “Jisas nöbö Nasaret yöbö aku hömɨdö,” rɨmɨn nugwön, nuŋ wö rön yadöŋa, “Jisas, Depid Ha nuŋwa, nɨ ögwö yöxanö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Aliö rɨmɨn, nöbö mö akuyöbö nugwo yad gɨrön yadmä, “Mönö pɨmɨjɨnö! Dar mɨdö!” rɨmä. Aliö yadim aku, jɨ nuŋ tar mɨdölöŋ, aja halön wö diba rön yadöŋa, “Depid Ha nuŋwa, nɨ ögwö yöxanö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Aliö rɨmɨn, Jisas il yöraku aŋöi nɨgön yadöŋa, “Nugwo yad wö rɨŋ, yörɨk haŋ,” me röŋa. Aliö rɨmɨn, nöbö mö akuyöbö nöbö mämäg we aku nugwo yadmä, “Jisas nagö yad wö rɨmɨda. Öbɨlön rɨbyöx nugu gɨba hö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Aliö rɨmɨdmɨn, wölɨj mɨlkap nuŋ aku pɨ röd abön, rɨmgör ör öbɨlön, Jisas mɨdöŋ yöra duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Dumɨdɨm, Jisas nugwo yadöŋa, “Nɨ pödpöd raŋ, me rön, hömɨdlö?” röŋa. Aliö rɨmɨn, mämäga we wölöŋ nöbö aku yadöŋa, “Mönö yad nölɨb nöbö. Mämäg na iswob ix nugunö, rön, hömɨdlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Aliö rɨmɨn, Jisas yadöŋa, “Jisas nɨ raŋ wä raŋ, me rön, nugw pɨlö aku döŋö, nagö wä rɨ makwam naŋ duö,” röŋa. Aliö rɨmɨn nugugɨrön, wop akwör mämäga ix nugwön Jisas pɨsaŋ duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jisas nöbö nuŋ bla pɨsaŋ dumɨd dumɨd Jerusalem womiöx rɨg rɨ, Olip Pɨda, ram yöj lɨglɨg agrö Betpagi Betani me röi aku uröpɨnön, Jisas nöbö nuŋ mös yadön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Mögörɨb möl aku duön nugwöña, hön ha donki maua nöbö mö pön yönölöi i wabɨl nɨgɨŋ mɨjöna. Nugwön, yau pön höña. ");
INSERT INTO tmd_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nöbö mö bli ñɨgö pödpöd rɨba akuyöbö almɨdöiŋö, rɨmɨdɨŋ, yajöña, ‘Nöbö Diba mabö i rön, yörbö höbkal abaŋ, hönɨŋö,’ cɨne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Aliö rɨmɨn, duön nugumɨn, hön ha donki maua ödöi ramɨxrö ubalɨj il yöra wabɨl nɨgɨm mɨdöŋa. Yaumɨn nugugɨrön, ");
INSERT INTO tmd_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","nöbö mö il yöraku mɨdim bla yadmä, “Pödpöd rɨba hön ha donki mau aku yaumɨdöi?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Aliö rɨmɨn, Jisas rɨg yadöŋ akwör yadmɨn, yöwö rɨmɨn, ");
INSERT INTO tmd_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","hön ha donki mau aku pön Jisas mɨdöŋ yöra hön, wölɨj mɨxɨl dib ñɨŋa rödön hön donkia rol sö nɨgɨm, Jisas rola römɨdön duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nöbö mö piaku mɨga wölɨj mɨlkap ñɨŋ bla rödön ödöia yödmä; bli bɨ panö bla pɨ gɨ du rag hö yödmä. ");
INSERT INTO tmd_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Akuyöbö alön, nöbö mö nugwo höd duim bla aipam, nugwo mai hem bla aipam, wö diba rɨg rɨ yadmä, “God ib nuŋwa yadɨŋ bɨl sö duaŋ! Nöbö Diba nöbö nuŋwa abmɨn hömɨd kɨ; God nugwo nugwidɨx ri aböna. ");
INSERT INTO tmd_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nöso Depid kiŋ mɨdön, nöbö mö rɨg nugwidɨx mɨdmɨd mag akuyöbö, nuŋ an paŋ mag aliö akwör rön nugwidɨx mɨjöna! God ib nuŋwa yadɨŋ bɨl sö duaŋ!” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jisas akuyöbö alön, Jerusalem duön, God höjöpalɨb ram möla duön, ap akuyöbö nugup yönmɨdɨm, naiö rödɨpmɨn nugugɨrön, nöbö nuŋwa akuyöbö möl sö piaku pɨsaŋ ram yöj lɨglɨg agrö Betani dumä. ");
INSERT INTO tmd_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Löum yöbö, Betani röböx höbkal ödöi mibɨl yöra hö gɨr, Jisas nugwo höböinö pɨlöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Höböinö pɨlɨm, pad irmär nugumɨn bɨ kaucö i mɨdöŋa. Mag bli yax gɨ mɨd pak e rön, duön nugumɨn, maga yaxölöŋ; bɨ panö akwör mɨdöŋa. Aku agapɨm: maga ub wop aku wölöŋ. ");
INSERT INTO tmd_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Almɨn, Jisas bɨ aku yadöŋa, “Mai nöbö mö bli mag naŋ aku nɨmeñɨŋö,” röŋa. Nöbö nuŋ bla mönö yadöŋ aku nugumä. ");
INSERT INTO tmd_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jisas nöbö nuŋ bla yölɨŋön, Jerusalem duön, God höjöpalɨb rama ram möl yuadö duön nugumɨn, nöbö mö akuyöbö sɨmaim rɨ gɨrön, rɨg imcɨx gɨr mɨdmä. Akuyöbö almɨdmɨn, Jisas rɨg imcɨxmɨdim äbäñ wab bla pɨ göur abön, yöur rag hö nɨgɨm wob gɨr mɨdim bäpö wab bla pɨ göur abön, nöbö mö sɨm rɨ gɨrön, ap wob gɨrön, ram möl yuadö aku mɨdim bla, ñɨgö höju rɨŋö bö aböŋa. ");
INSERT INTO tmd_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Höju rɨŋö bö abön yadöŋa, “Ap bli rag hö God höjöpalɨb rama rɨg kul wob dɨdɨb rɨg mɨd yuadö kɨ hön dumɨjeñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Aliö rön yadöŋa, “God Mönö aku kai kɨtön yadmä, ‘God yada, “Ram na aku, nöbö mö mögörɨb piaku piaku magalɨg hön, nɨ höjöpal mɨjöñɨŋö,” rö,’ rɨmä. Makwam ñɨŋ akuyöbö almɨdmɨn, ap kib pɨb nöbö umad gɨ mɨdöi ram i röxgö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jisas aliö rɨmɨn, God ap höjöpal ur nölɨb nöbö dib bla aipam, lo mönö yad nölɨb nöbö bla aipam, mönö aku nugwön, nugwo pɨl pal nɨgnɨŋö, rɨmä. Makwam nöbö mö akuyöbö magalɨg mönö nugwo aku nugwön aiö rim aku mɨ, Jisas nugwo ipöxön, agö magɨm rön nugwo pɨl pal nɨgnɨŋö, rön, rɨb aku yöxön hölu nugw mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ruö wadɨxöŋ mag aku, Jisas nöbö nuŋ bla pɨsaŋ Jerusalem röböxön dumä. ");
INSERT INTO tmd_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Löum pɨxmag alɨg ödöi mibɨl yöra iswob du gɨrön nugumɨn, bɨ kaucö Jisas yadyöxöŋ bɨ aku il alɨg aŋadö wöröx gɨ mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Akuyöbö almɨn nugwön Pita yadöŋa, “Mönö yad nölɨb nöbö, nugwö! Bɨ kaucö idöm yadyöxmö bɨ römö kɨ wöröx gɨ mɨdö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Aliö rɨmɨn, Jisas yadöŋa, “God nugw pi. ");
INSERT INTO tmd_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nɨ ñɨgö mi yadmɨdla, God nugwo yad nugunɨŋ mag akwör cönɨŋö, rön, rɨb mös yöxeñ, rɨb mag paŋyöbö iör yöx nugwön, önöŋ ajmag kɨ, ‘Wöd du ban yuö mibɨl yörkwo bɨrö,’ cöñ aku, rɨg yad nugwöñ mag akwör cöna. ");
INSERT INTO tmd_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Aku agapɨm, God nugwo rɨg yad nugunɨŋ mag akwör cönɨŋö, rön, rɨb mag paŋyöbö iör yöx nugwön yad nugumɨjöñ aku, rɨg yad nugwöñ mag akwör cöna. ");
INSERT INTO tmd_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Makwam God höjöpainöb rön, nöbö mö bli ñɨgö rɨ gwogwam röi ap piaku nugwön röböxɨŋ, Nuö ñɨŋa adöx yöd röul adö kau sö mɨd aku, ap kib mag gwogwo ñɨŋ röi ap piaku algör ör nugwön röböxöna. ");
INSERT INTO tmd_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Makwam nöbö mö bli ñɨgö rɨ gwogwam röi ap piaku nugwön röböxeñ aku, Nuö ñɨŋa adöx yöd röul adö kau sö mɨd aku, ap kib mag gwogwo ñɨŋ röi ap piaku algör ör nugwön röböxenɨm. ");
INSERT INTO tmd_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Makwam Jisas nöbö nuŋ bla pɨsaŋ höuöil Jerusalem höröpɨnön, nuŋ God höjöpalɨb rama ram möl yuadö bla rɨp yönmɨdɨm nugugɨrön, God ap höjöpal ur nölɨb nöbö dib piaku aipam, lo mönö yad nölɨb nöbö piaku aipam, mönö pɨ nuöm nɨgɨb nöbö piaku aipam, Jisas mɨdöŋ yöra hön yadmä, ");
INSERT INTO tmd_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Nagö yönɨm mag akuyöbö rane, rɨm, nugwön alɨp yönmɨdlö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Aliö rɨmɨn, Jisas paiŋö yadöŋa, “Nɨ ñɨgö mönö i yad nugumön, nɨ yad nölmɨjöñ aku, nɨ paiŋö nɨ yönɨm yadmɨn rɨp yönmɨdɨl aku, ñɨgö yad nöina. ");
INSERT INTO tmd_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jon nöbö mö akuyöbö ñɨgö röbö pal nölöŋ aku, God yadɨm röbö pal nölöŋ mönö rɨb nuŋwa keir yöx nugwön röbö pal nölöŋ? Nɨ yad nölɨŋ nugunöm!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Jisas aliö rɨmɨn, ñɨŋ keir yad nugwob nugwob rön yadmä, “An yajnɨŋa, ‘God yadɨm, Jon nöbö mö akuyöbö ñɨgö röbö pal nölö,’ cɨnɨŋ aku, an yajöna, ‘Aku makwaim, pödpöd rɨmɨn Jon mönö nuŋ aku nugw pölöiŋönö?’ cöna. ");
INSERT INTO tmd_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Makwam an yajnɨŋa, ‘Jon rɨb nuŋwa keir yöx nugwön ñɨgö röbö pal nölö,’ cɨnɨŋ aku, an pödpöd cöñɨŋö?” rɨmä. Aku agapɨm: nöbö mö akuyöbö magalɨg, God yadɨm Jon mabö nuŋwa rɨmɨdö, rön nugumɨdöi makwam, Juda nöbö dib piaku ipöxön mönö hör i yadölim. ");
INSERT INTO tmd_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Rɨb aku yöxön yadmä, “An nugwölölɨŋö,” rɨmä. Aliö rɨmɨn, Jisas ñɨgö paiŋö yadöŋa, “Ñɨŋ nɨ yad nölölöi aku, nɨ yönɨm yadɨm rɨp yönmɨdɨl aku, ñɨgö algör yad nölöinö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jisas nuŋ ñɨgö mönö adö i höd röxön yadöŋa, “Nöbö i kul wobön, nag wain mabö rɨ yuön, wain maga pal caku rɨb, me rön, möl i rɨ nɨg ri aböna. Nöbö mö hön nag maga kib pöñam aku nugugu mɨdɨŋ, me rön, rama mɨ bɨl sö ur nɨgön, nöbö bli yajöna, ‘Ñɨŋ nag wain möriwö na aku nugwidɨx mɨdɨŋ, mai mag yaxön göj waŋ, nɨ bli, ñɨŋ bli pɨnö,’ rön, mögörɨb pad piaku diöna. ");
INSERT INTO tmd_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wain maga göj yön mag aku, nöbö nuŋ i yad abön yajöna, ‘Wain mag na bli nölɨŋ rag hane!’ cöna. ");
INSERT INTO tmd_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Yadaŋ, uröpɨnaŋ, nöbö mabö rɨmɨjöñ piaku, nugwo pɨ palmɨd palmɨd nɨgön, hör yad aböña. ");
INSERT INTO tmd_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Akuyöbö alɨŋ, nöbö wain möriwö mɨnöbö aku nöbö i piöŋö yad aböna. Duaŋ, nugwo yöcmac sö palön, rɨ gwogwam cöña. ");
INSERT INTO tmd_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Akuyöbö alɨŋ, nöbö wain möriwö mɨnöbö aku, nöbö i piöŋö yad abaŋ duaŋ, nugwo aŋadö pɨl pal nɨgöña. Nöbö bli mɨga akwör yad abaŋ, mag akuyöbö akwör rɨ gɨrön, bli mɨ göj paiöña, bli aŋadö pɨl pal nɨgöña. ");
INSERT INTO tmd_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Akuyöbö alɨŋ alɨŋ aku, nöbö wain möriwö mɨnöbö aku nöbö nuŋ i mɨdenɨm; ha madmag yöbö nuŋ paŋyöbö mɨjön aku, mönö nuŋ aku yöxöñɨŋö, rön, yad abaŋ diöna. ");
INSERT INTO tmd_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Makwam uröpɨnaŋ, nöbö mö wain mabö rɨmɨjöñ piaku nugwo nugwön yajöña, ‘Hö ha kɨ, nöbö wain möriwö mɨnöbö aku ha nuŋwa ha. Aku makwam, nugwo pɨl pal nɨgnɨm me, ap nuŋ pɨbä röxgɨb piaku an pɨnɨŋö,’ cöña. ");
INSERT INTO tmd_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Aliö rön, ha aku nugwo mɨ aŋadö pɨl pal nɨgön, pön du rɨŋadö piaku aböña. ");
INSERT INTO tmd_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Akuyöbö almɨdɨŋ, nöbö wain möriwö mɨnöbö aku hön, pödpöd cön? Nuŋ hön, nöbö mö wain mabö rɨmɨjöñ piaku ñɨgö pɨl pal nɨgön, nöbö mö bli piöŋö yöra yadaŋ, wain möriwö aku nugwidɨx mɨjöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Jisas aliö rön ñɨgö yadöŋa, “Ñɨŋ God Mönö kai kɨtön yadim um mɨŋi nugwölöiŋödö? God Mönö um aku kai kɨtön yadmä, ‘Nöbö ram urɨb bla rɨg mɨxɨl röböxim aku, rɨg akwör weik ram padö mibɨl yöbö bö aku pɨn nöl gɨ mɨda. ");
INSERT INTO tmd_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nöbö Dib akuyöbö alöŋ aku, an nugwön ri abö rɨmɨdölɨŋö,’ röiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jisas aliö rɨmɨn, God ap höjöpal ur nölɨb nöbö dib bla aipam, lo mönö yad nölɨb nöbö bla aipam, mönö pɨ nuöm nɨgɨb nöbö bla aipam, anɨŋör yadmɨdö, rön, nugwo pɨŋö, rön nugwim aku, jɨ ñɨŋ nöbö mö piaku ipöxiö nɨg duön röböxmä. ");
INSERT INTO tmd_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Makwam mai Juda nöbö dib piaku, Perisi nöbö bli pɨsaŋ, Herod nöbö nuŋ bli pɨsaŋ ñɨgö yadmä, “Ñɨŋ Jisas mɨd yöra duön, nugwo mönö bli yad nugwɨŋ, nuŋ agö mönö gwogwam yadmɨdaŋ, nugwo pön du nag nɨgnɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Aliö rɨmɨdmɨn, Jisas mɨdöŋ yöra duön yadmä, “Mönö yad nölɨb nöbö. An nugumɨn nagö nöbö mɨ ödöriö akwör yadlö. Nöbö mö dib bla aipam, nöbö mö hör bla aipam, ñɨŋ nugwön ipöxöiö. God rɨg yad akwör nugwön, nöbö mö ñɨgö paxdöriö yad nöilö. Aku makwam, anɨŋ yad nölö! An Juda nöbö mö lo bla pödiö mɨd? Gapman nöbö dib Sisa aku nugwo takisa nölɨb mönö nölölɨbɨm?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Aliö rɨmɨn, Jisas inakmönö hörön yadmɨdim aku nugwön yadöŋa, “Pödpöd rɨmɨn, mönö gwogwam yadaŋ, me rön, nɨ mönö inakmönö aku hörmɨdöi? Rɨg mag i pön höŋ, nɨ nugunöm,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Aliö rɨmɨn, rɨg mag i rag hö nölmɨn nugwön yadöŋa, “Rɨg höñ aku, nöbö kai haŋaj mämäg yuö mɨdɨm, yönɨm ib aku mɨd?” röŋa. Aliö rɨmɨn, yadmä, “Nöbö dib Sisa aku pal,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Aliö rɨmɨn, Jisas yadöŋa, “Sisa apa mɨjön aku Sisa nuŋwör nöiöña; God apa mɨjön aku God nuŋwör nöiöñɨŋö,” röŋa. Aliö rön, inakmönö hörim mönö höjɨl ñɨŋ aku röb mögö ñɨxöŋ aku nugwön, aiö rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadiusi nöbö mö akuyöbö, nöbö mö wöröxön öbɨleñɨŋö, rön, nugumɨdöi akuyöbö, bli Jisas mɨdöŋ yöra hön yadmä, ");
INSERT INTO tmd_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mönö yad nölɨb nöbö. God mönö yadɨb nöbö Mosɨs, mönö i an kai kɨtön yadöŋa, ‘Nöbö i mö pön, ha yöxen wöhö, hör wöröxön aku, pɨgnɨŋ nuŋ i piöŋö mö wösrö aku pön, nöböhöd wöröxöŋ aku halöu ha nuŋ aku, me rön, yöxönɨŋö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Aku makwam, nöbö ila alɨg akuyöbö mɨj sö mɨjöña. Nöbö höda mö pön, ha yöxen wöhö, hör wöröxöna. ");
INSERT INTO tmd_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Wöröxaŋ, pɨgnɨŋ nöbö agñɨŋ rɨbyöbö aku piöŋö mö aku nugwo pön, algör ha yöxen wöhö, hör wöröxöna. Akuyöbö alaŋ, pɨgnɨŋ nöbö igwö wölö aku piöŋö mö aku pön, algör ha yöxen wöhö, hör wöröxöna. ");
INSERT INTO tmd_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Akuyöbö alɨp dumɨd dumɨd, pɨgnɨŋ nöbö akuyöbö mɨj sö mö aku pön, ha yöxeñ wöhö, magalɨg mɨ hör ör wöröxöña. Mai mö aku kwo algör wöröxöna. ");
INSERT INTO tmd_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nöbö mö wöröxön öbiöñɨŋö, rɨlö aku, mö paŋyöbö i nöbö nuŋwa akuyöbö mɨj sö nɨgön aku, mai pɨgnɨŋ nöbö kai mö nuŋwa mɨjön?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Aliö rɨmɨdmɨn, Jisas yadöŋa, “Ñɨŋ God Mönö kai kɨtim aku aipam, God ölɨsö nuŋ aku aipam nugwölöi aku, rɨb wä yöx nugwölöi. ");
INSERT INTO tmd_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nöbö mö wöröxöi piaku öbiöñ wop aku, God ejol nuŋ bla rɨg mɨdöi mag akuyöbö rɨg mɨdön, nöbö piaku mö peñɨm; mö piaku nöbö peñɨm. ");
INSERT INTO tmd_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Makwam nöbö mö höbkal öbɨleñɨŋö, röi aku, Mosɨs rɨn ulmɨdö yön gör mɨdöŋ haiwo kai kɨtöŋ aku nugwölöi ä? God, bɨ yönmɨdöŋ mibɨl yöra mɨdön Mosɨs yadöŋa, ‘Ebraham, Aisak, Jekop, God ñɨŋ aku nɨ mɨdlö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ñɨŋ nugw ri abölön, nöbö mö wöröxöi piaku nugwön, aŋadö wöröxöiŋö, röi aku, jɨ God nugumɨn ñɨŋ kömö mɨdöia. Nöbö mö kömö mɨdöi piaku, nuŋ God ñɨgö mɨdö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Lo mönö yad nölɨb nöbö i, Jisas Sadiusi nöbö mö akuyöbö ñɨgö yad ri abön röŋ aku nugwön, hön nugwo yad nugwön yadöŋa, “Lo ada kai lo dib ödöriö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Aliö rɨmɨn, Jisas yadöŋa, “Lo dib ödöriö aku, God Mönö aku kai kɨtön yadmä, ‘Isrel nöbö mö nugwi! Nöbö Dib ana God, nuŋ paŋyöbö mɨd akwör Nöbö Diba mɨda. ");
INSERT INTO tmd_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Madmag naŋ aku magalɨg, rɨb naŋ aku magalɨg, ölɨsö naŋ aku magalɨg pön God Nöbö Dib naŋ aku nugwo madmag nɨgö,’ rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mönö dib ödöriö i, God Mönö aku kai kɨtön yadmä, ‘Naŋ naŋ keir madmag rɨg nɨglö mag akwör, nöbö mö hör akwebö ñɨgö algön nör madmag nɨgö,’ rɨmä. Lo mönö bla magalɨg, lo hogw aku lo dib ödöriö hogwa mɨdö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jisas aliö rɨmɨn, lo mönö yad nölɨb nöbö aku yadöŋa, “Mönö yad nölɨb nöbö. Nagö mɨ ödöriö yadlö, God paŋyöbö aku Nöbö Dib akwör mɨda; nuŋ röxgɨb nöbö bli mɨdölöi. ");
INSERT INTO tmd_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","An God ap pal höjöpal ur nöinɨŋönö ap pal höjöpal ur nölön aŋadö winɨŋ, aku ap dib yöi. Ap dib ödöriö aku, madmag an aku magalɨg, rɨb an aku magalɨg, ölɨsö an aku magalɨg pön God Nöbö Dib akwör nugwo madmag nɨgön; an an keir madmag rɨg nɨgöl mag akwör, nöbö mö hör akwebö ñɨgö algön nör madmag nɨgnɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Aliö rɨmɨn, Jisas nöbö aku, nuŋ rɨbyöx nugw ri abön yadö, rön, nugwo yadöŋa, “Nagö God nöbö nuŋ i mɨdɨbä röxlaŋö,” röŋa. Jisas paiŋö mönö mɨ ödöriö bla akwör yadmɨd aku nugwön, nöbö mö nugugu mɨdim akuyöbö ipöxön, mai mönö inakmönö hörmɨdöi akuyöbö bli kwo nugwo yad nugwölim. ");
INSERT INTO tmd_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisas nuŋ God höjöpalɨb rama mɨdön, nöbö mö akuyöbö ñɨgö mönö yad nöl gɨr mɨdön, nöbö mö akuyöbö ñɨgö yadöŋa, “Lo mönö yad nölɨb nöbö piaku pödpöd rɨmɨn yadöi, ‘Krais aku nuŋ Depid ha nuŋwör,’ me röi? ");
INSERT INTO tmd_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Inöm Leia, Depid nugwo rɨbyöx nölmɨn, Depid nuŋ keir kai kɨtön yadöŋa, ‘Nöbö Diba nuŋ Nöbö Dib na aku nugwo yadöŋa, “Nagö imag mɨrɨx na ada mɨdan, nɨ nöbö mö kwolmal nagö piaku ñɨgö pön yödpɨlö mo naŋ aku nɨgɨnö,” rö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Makwam, Depid nuŋ keir Krais nugwo ‘Nöbö Dib nɨ’ me röŋa. Makwam Krais Depid ha nuŋwa mɨdöx aku, nugwo ‘Nöbö Dib nɨ’ me rölöx,” me röŋa. Jisas mönö il aliö nugwön yad ri aböŋ aku, nöbö mö mɨga ödöriö mɨdim akuyöbö mönö nugwo aku mɨ wahax pön nugumä. ");
INSERT INTO tmd_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jisas nöbö mö akuyöbö ñɨgö mönö yad nöl gɨrön yadöŋa, “Ñɨgö lo mönö yad nölɨb nöbö bla ñɨgö nugw ri aböña. Ñɨŋ rɨg röi adaku, wölɨj mɨxɨl dib bla röbön, sɨmaim rɨmɨdöi akuyöbö duŋ, nöbö mö piaku, ñɨŋ hömɨdöiŋ e, rɨŋ, ib ana kɨ bɨl sö mɨdaŋ, me rön, rɨbyöx nugwöia. ");
INSERT INTO tmd_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Makwam Juda mögum rɨb ram aku duŋ, anɨŋ yör wä wä nöbö dib römɨdöi hogw rol aku römɨjɨnö, rɨŋ, me rön, rɨb aku yöx nugwöia. Nöbö mö ap diba nɨmöi mibɨl aku algör ör, nöbö mö mämäg il rol yöra römɨdɨŋ, an nugwön, an nöbö rɨb iba mɨdö, rɨŋ, me rön, rɨb aku yöx nugwöia. ");
INSERT INTO tmd_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Lo mönö yad nölɨb nöbö akuyöbö, mö wösrö rama ap ñɨŋ bla ap an aliö nɨgaŋ, me rön, hölu ab pöia. God höjöpalön cɨnɨŋ aku, nöbö mö nugwöñɨŋö, rön, hör mönö mɨxɨla inakmönö hörön adö bli hör yadöia. Akuyöbö alöi aku, mai God ñɨŋa mɨ ölɨŋ höb diba pɨ nöiönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisas God höjöpalɨb rama rɨg rag hö nölmɨdöi möl il yöra römɨd gɨ mɨdön nugumɨn, nöbö mö piaku rɨga rag hö abmɨdmä. Nöbö mö rɨb bla rɨg mɨga akwör rag hö abmä. ");
INSERT INTO tmd_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Jɨ lap wösrö rɨg mɨdölöŋ i, rɨg paskwolö mag ulul mös rag hö aböŋa. ");
INSERT INTO tmd_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Akuyöbö almɨn nugwön, Jisas nuŋ nöbö nuŋ piaku yadmɨn hömɨn yadöŋa, “Nɨ ñɨgö mɨ ödöriö yadmɨdla, nöbö mö akuyöbö ñɨŋ rɨg ulmɨdö nölöia, jɨ lap wösrö kɨ rɨg diba nöla. ");
INSERT INTO tmd_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Aku agapɨm: nöbö mö rɨg mɨga mɨd akuyöbö, rɨg ap ñɨŋa mɨga akwör mɨdmɨn nugugɨrön, rɨg um bli ör rag hö God nölöia; jɨ lap wösrö kɨ, rɨg nuŋwa mag mösör mɨdam magalɨg rag hö nöla. Nuŋ ap wob nɨmɨb rɨg i mɨdöl. Akuyöbö al aku, God nugum, nöbö mö bli ulmɨdö nölöi aku, jɨ lap wösrö kɨ rɨg diba nölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisas God höjöpalɨb ram aku röböxön rɨŋadö dumɨn nugugɨrön, nöbö nuŋ i nugwo yadöŋa, “Mönö yad nölɨb nöbö. Rɨg wä pön, ram wä urim kɨ nugwö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Aliö rɨmɨn, Jisas yadöŋa, “Naŋ rɨg ram dib aku nuguman, wä rɨmɨn yadmɨdlanö ä? Mai ram kɨ pal gɨlɨx ab gɨlɨx rɨ abɨŋ, rɨg i, rɨg i rola mɨdenɨm; aŋadö pal gɨlɨx aböñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jisas aliö rön, God höjöpalɨb ram aku röböxön, Olip Pɨda duöŋa. God höjöpalɨb ram aku önöŋ adokwo mɨda, Olip Pɨda önöŋ adök mɨda. Jisas Olip Pɨda römɨd gɨ mɨdmɨn nugugɨrön, Pita, Jon, Jems, Edru yam aku ñɨŋ hön nugwo yadmä, ");
INSERT INTO tmd_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Yadlö mag aku wop kaiyöbö cön? Makwam mag pödiöm akuyöbö alaŋ nugwön yajnɨŋ, ‘Mag adaku weik rɨba rɨmɨdö,’ cɨnɨŋ?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Aliö rɨmɨn, Jisas ñɨgö yadöŋa, “Nugw ri abön inakmönö hörɨŋ yöxmɨjeñ! ");
INSERT INTO tmd_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nöbö mö mɨga akwör hön, inakmönö hörön, ib na aku pön yajöña, ‘Nɨ Jisas ör hömɨdlö,’ cöña. Aliö rɨŋ, nöbö mö mɨga, mi yadmɨdöiŋö, rön, ñɨgö mai diöña. ");
INSERT INTO tmd_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","‘Mögörɨb kɨyöbö nuö nuö pɨlmɨdöia, mögörɨb piaku nuö nuö pɨlmɨdöiŋö,’ rɨmɨdɨŋ, rɨb mɨga yöx nugumɨjeñ. Ap adaku cön aku, jɨ wopik mögörɨb il kɨ ap piaku magalɨg yöm cönɨŋö, rön, rɨb aku yöx nugumɨjeñ. ");
INSERT INTO tmd_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nöbö mö möl bli öbɨlön, nöbö mö möl bli pɨsaŋ nuö nuö pɨlmɨjöña. Kiŋ möl bli öbɨlön, kiŋ möl bli pɨsaŋ nuö nuö pɨlmɨjöña. Mögörɨb adadö mɨga mɨmön paŋ, kiö diba wöröxmɨjöña. Aiön ap piaku, mö piaku ñɨgö höd ha nɨmɨmɨn, mai ha yöxöi mag akuyöbö cöna. ");
INSERT INTO tmd_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Makwam ñɨŋ nugw ri abön mɨjöña. Wop bli ñɨgö pön du Juda kansol nöbö piaku nölɨŋ, mönö diba yajöña. Wop bli, Juda mögum rɨb ram möl yuadö bla kaiö pön ñɨgö paiöña. Wop bli, Jisas nöbö nuŋ, me rön, ñɨgö pön du gapman nöbö dib bla aipam kiŋ bla aipam mɨjöñ yöra duön, mönö diba yajöña. Makwam aliö pön du mɨjöñ aku, mönö wä na aku gapman nöbö dib piaku aipam, kiŋ piaku aipam yad nöiöña. ");
INSERT INTO tmd_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Makwam höd mönö wä na aku, nöbö mö mögörɨb hör piaku piaku magalɨg yad nölɨŋ duaŋ nugwön mai yadmɨdɨl wop aku wöxnö nɨgöna. ");
INSERT INTO tmd_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Nɨ ada mɨjöñ aku nugwön, ñɨgö mönö diba yadɨba pön dumɨjöñ aku, mönö paiŋö pödi yajnɨŋö, rön, rɨb diba yöxmɨjeñ. Ñɨŋ yadɨba rɨŋ nugugɨrön, Inöm Leia ñɨgö rɨb wä nölaŋ, yajöña. Mönö aku ñɨŋ keir yadeñ; Inöm Leia nuŋ keir yajöna. ");
INSERT INTO tmd_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Wop aku, nöböhöda öbɨlön, nöböpɨga pɨl pal nɨgɨŋ, me rön, nugwo höuöu rɨ pön du mönö nugub nöbö piaku iŋsö nɨgɨŋ, nugwo pɨl pal nɨgöña. Nuö nöbö piaku öbɨlön, halöu ha ñɨŋ keir piaku ñɨgö pɨl pal nɨgɨŋ, me rön, ñɨgö höuöu rɨ pön du mönö nugub nöbö piaku iŋsö nɨgɨŋ, ñɨŋ pɨl pal nɨgöña. Halöu ha piaku öbɨlön, nuö nuöm nöbö ñɨgö nugwɨŋ, ölɨsö wölaŋ, ñɨŋ pɨl pal nɨgɨŋ, me rön, ñɨgö höuöu rɨ pön du mönö nugub nöbö piaku iŋsö nɨgɨŋ, ñɨgö pɨl pal nɨgöña. ");
INSERT INTO tmd_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nɨ adö mɨjöñ aku ñɨgö nugwɨŋ, mɨ ölɨsö wöiön aku, jɨ ñɨŋ nöbö mö kai kai, mɨ ususör rön nɨ röböxölön, cɨrɨp gö nɨgön mɨjöñ piaku, mai yadmɨdɨl wop aku wöxnö nɨgaŋ, God ñɨgö kömö pönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Makwam ap mödön hölul rɨb aku, nuŋ duölɨb yöra du öbɨl gɨ mɨdaŋ nugwöñ aku, ñɨŋ nöbö mö mögörɨb Judia mɨjöñ akuyöbö, yadkap bör önöŋ ajmag bla diöña. (Ñɨŋ nöbö mö mönö kɨ wopik ör mämäg nɨg nugumɨdöi akuyöbö, mönö il aku röx nugw ri aböña.) ");
INSERT INTO tmd_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nöbö mö ram cölöbö sö mɨjöñ akuyöbö, ap na bli pɨnö, rön, höbkal ram möl yuadö dueñɨm. ");
INSERT INTO tmd_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nöbö mö möriwö rɨb piaku yönmɨjöñ akuyöbö, wölɨj mɨxɨl na i pɨnö, rön, höbkal rama dueñɨm. ");
INSERT INTO tmd_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Makwam wop aku, mö ha wöta alɨg mɨjöñ piaku aipam, mö halöu ha kiaia kau nölmɨjöñ piaku aipam, amɨn bör yön öliöxöña. ");
INSERT INTO tmd_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Aiön ap aku, God höjöpalön, ruö ij rɨ wop aku alölaŋ, me cöña. ");
INSERT INTO tmd_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Aku agapɨm: God maduö ib hör i mögörɨb kɨ rɨ nɨgöŋ wop aku ila nɨgön, mɨdɨp hön weik mɨdöl wop kɨ, ap gwogwo akuyöbö i rölöŋ; mai piaku algör ör ap gwogwo akuyöbö i ren. ");
INSERT INTO tmd_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ap gwogwo aku öim röx aku, nöbö mö magalɨg wöröx pöröyɨxa. Jɨ Nöbö Diba nuŋ pön nöbö mö akuyöbö rɨbyöx nugwön, wöhö raŋ mönö, ap gwogwo aku hör mag ul mɨŋi cöna. ");
INSERT INTO tmd_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Wop aku nöbö mö bli ñɨgö yajöña, ‘Nugwi! Krais yörɨk mɨda! Krais yörkwo mɨda!’ cöñ aku, jɨ mi yadmɨdöiŋö, rön nugumɨjeñ. ");
INSERT INTO tmd_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nöbö mö bli, God nuŋ keir yad nɨgöŋ nöbö mö akuyöbö ñɨgö pɨnɨŋö, rön, inakmönö hörön yajöña, ‘Nɨ mɨ Krais; nɨ God mönö yadɨb nöbö i,’ me rön, ap rölɨbä akuyöbö bli rɨmɨjöña. Jɨ God nuŋ keir yad nɨgöŋ nöbö mö akuyöbö peñ, wöhö. ");
INSERT INTO tmd_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Makwam, nugw ri aböña. Ap kai kai mai cön aku, nɨ ñɨgö yadmön nugwöi makwam, nugw ri ab gɨr mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Makwam ömörö dib piaku rɨ pöraŋ nugugɨrön, naiö aku pɨxmag guraŋ, röun aku mil aben. ");
INSERT INTO tmd_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Gupö adöx yöd sebö gɨ du pɨnaŋ nugugɨrön, ap adöx yöd sö mɨd akuyöbö, i rɨ bɨröb yön bör yönmɨjöna. ");
INSERT INTO tmd_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Wop aku, Nöbö Ha nuŋwa ölɨsö maga pön, mil wä maga alɨp mɨjöi waba mibɨl yöra sö haŋ nugugɨrön, nöbö mö nugwo nugwöña. ");
INSERT INTO tmd_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Makwam ejol nuŋ bla yad abaŋ mögörɨb hör bɨl adadö piaku piaku magalɨg duön, nöbö mö nuŋ keir yad nɨgöŋ akuyöbö pön nugwo pöl höña. ");
INSERT INTO tmd_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Jisas yadöŋa, “Ñɨŋ bɨ röui bla nugwöñ aku, mönö yadmɨdɨl kɨ nugw ri abön rɨmɨjöña. Bɨ röui bla yösa nɨgön, gö nɨgmɨn nugugɨrön, weik naiö nɨgɨba rɨmɨdö, rön nugwöia. ");
INSERT INTO tmd_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mag akuyöbö, mai ap yadmɨdɨl akuyöbö raŋ nugugɨrön, ‘Weik womiöx mɨda, Jisas yadöŋ mag akuyöbö rɨba rɨmɨdö,’ rön nugwöña. ");
INSERT INTO tmd_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nɨ ñɨgö mi yadmɨdla, nöbö mö weik mɨdöi bla bli mɨdɨŋ nugugɨrön, ap piaku rɨ pöraŋ, mai döŋö wöröxöña. ");
INSERT INTO tmd_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Adöx sö aipam, mögörɨb mɨgrö kɨ aipam hölögɨpöna, jɨ mönö mag na hölögɨpen. ");
INSERT INTO tmd_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nɨ wop kaim mag kaim hön aku, nöbö mö bli nugwölöi, ejol bla nugwölöi, nɨ Ha aku algör ör nugwöi; Acö nuŋwör nugwa. ");
INSERT INTO tmd_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Makwam, nɨ wop kaiyöbö hön aku nugwölöi makwam, öim öim nugw ri abön rɨ gɨr mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Hön wop aku, haiwo aliö kɨyöbö mɨda. Nöbö dib i ram nuŋwa röböxön möl i duba rön, nöbö mabö rɨb nuŋ akuyöbö ñɨgö mabö adö hörɨrör yad nɨgön, ‘Mabö al aliö cɨne,’ rön, ubalɨj ila nugwidɨx mɨdɨb nöbö aku nugwo yajöna, ‘Nugw ri abön mɨdane,’ rön, diöna. ");
INSERT INTO tmd_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ñɨgö kwo algör, mag kaiyöbö nöbö ram mɨnöbö aku hön makwam nugwölöi aku, nugw ri abön mɨjöña. Höxi raŋ mag aku hönɨŋönö, pɨxmag yuö mibɨl kwo hönɨŋönö, kulakul wö cön mag aku hönɨŋönö, pɨxmag alɨg hönɨŋö, rön, nugwölöi. ");
INSERT INTO tmd_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ñɨŋ hölɨmɨŋ nugugɨrön, rɨmgör höb maga rɨ makwam, nugw ri abön mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Makwam ñɨgör yadmɨdöi; ñɨgö nöbö mö magalɨg yadmɨdla, nugw ri abön mɨjne!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Makwam Juda ada Pasopa wop dib aku aipam, Bred Is Alɨg Nɨmɨb wop dib aku aipam hör wop mösör mɨdmɨn nugugɨrön, God ap höjöpal ur nölɨb nöbö dib bla aipam, lo mönö yad nölɨb nöbö bla aipam, Jisas nugwo agö magɨm rön, tar pɨ cɨcɨ nɨgön, pön du pɨl pal nɨgnɨŋö, rön, al gɨrön rɨbyöx nugumä. ");
INSERT INTO tmd_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Makwam rɨb i yöx nugwön yadmä, “Pasopa wop kɨ alön rɨŋ, nöbö mö mɨg kɨyöbö öbɨlön, nuö nuö rön, an rɨ gwogwam cöñɨŋö,” rön, röböxmä. ");
INSERT INTO tmd_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisas ram yöj lɨglɨg agrö Betani duön, Saimon rama du römɨdön, ap nɨmmɨdmä. Nöbö Saimon aku, höd uj höpebö nɨgöŋ aku, Jisas rɨmɨn wä röŋa. Makwam ap nɨmmɨdmɨn nugugɨrön, mö i wel röbö hölɨŋ wä höb rɨg diba woböi aku, balol alɨg pön hön, mibɨl yöra pal gɨlɨxön Jisas yöcmac sö höröŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","5","Hörɨm, nöbö mɨdim adaku, bli nugumɨn, höbwab ñɨgö aku gwogwo rɨmɨn, ñɨŋ keir yadmä, “Wel aku sɨm rön, kɨm paŋyöbö i nöbö i mabö rön rɨg pön mag akuyöbö aku pön, nöbö mö ap mɨdöl akuyöbö ñɨgö nölɨbä aku, jɨ pödpöd rɨmɨn aliö hör hör rö?” rɨmä. Aliö rön mö aku nugwo yad höimöumä. ");
INSERT INTO tmd_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Aliö rɨmɨdmɨn, Jisas ñɨgö yadöŋa, “Pödpöd rɨmɨn aliö rɨmɨdöi? Nugwo röböxi! Nɨ al aku mag wä ra. ");
INSERT INTO tmd_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nöbö mö ap mɨdöl akuyöbö ñɨŋ pɨsaŋ öim mɨjöñ aku, wop bli ñɨgö ap nöinöb, nöiöña. Makwam nɨ pɨsaŋ öim mɨdöinɨŋ. ");
INSERT INTO tmd_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Mö kɨ, ap nuŋ rɨb akuyöbö mödö ra. Wöröxmön, wel röbö hölɨŋ wä höb aku nɨg nölön hogw piöñ mag akuyöbö, nɨ höd nɨg nölmɨda. ");
INSERT INTO tmd_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Makwam, nɨ ñɨgö mi yadmɨdla, mai mönö mag wä na mögörɨb piaku piaku magalɨg yad nölɨŋ duaŋ nugugɨrön, nuŋ rɨ mag aku alɨg yadɨŋ, ñɨŋ mö kɨ uplöbeñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Makwam Jisas nöbö nuŋwa i Judas Iskariot, Jisas nugwo höuöu cɨnö, rön, God ap höjöpal ur nölɨb nöbö dib bla mɨdim yöra duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","God ap höjöpal ur nölɨb nöbö dib piaku, Judas nuŋ ñɨŋ wöñö u röŋ aku nugwön, wä rɨmɨn, yadmä, “Nagö rɨg bli nölɨŋö,” rɨmä. Aliö rɨmɨn mönö, Judas, “Pödpöd rön yadmön, ñɨŋ hön Jisas nugwo pön diöñɨŋö,” rön, rɨb aku yöx nugw mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bred Is Alɨg Nɨmɨb wop dib aku höm, Pasopa hön sipsip asa pal höjöpal ur nɨmɨb wop aku, Jisas nöbö nuŋ bla nugwo yad nugwön yadmä, “Pasopa ap ana nɨmɨnɨŋ aku, möl kai pɨdɨlinɨŋö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Aliö rɨmɨdmɨn, Jisas nöbö nuŋ mös yad abön yadöŋa, “Ñɨŋ taun dib aku duön nugwöña, nöbö i röbö un rag hö dumɨjöna; nugwo möigw pölön pɨsaŋ diöña. ");
INSERT INTO tmd_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nöbö aku duön ram möl yuadö dumɨjöna, ñɨŋ nöbö hogwa ram aku nöbö mɨnöbö aku nugwo yad nugwön yajöña, ‘Mönö yad nölɨb nöbö yada, “Nöbö nɨ bla pɨsaŋ Pasopa ap nɨmɨnɨŋ ram möla mɨkai?” me cɨnö,’ cöña. ");
INSERT INTO tmd_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ñɨŋ yad nugwɨŋ, nuŋ ñɨŋ pön du ram bɨl yöbö sö, ap bla magalɨg mɨd ram möl diba yabuöna. Yabuaŋ, ap nɨmɨb piaku ram möl aku rɨ pɨdɨlumɨjɨnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jisas ñɨŋ nöbö hogwa aliö rön yad abmɨn, taun dib aku duön nugumɨn, Jisas rɨg yadöŋ mag akwör rɨg mɨdöŋa. Nugwön, Pasopa ap nɨmɨba rim aku rɨ pɨdɨlumä. ");
INSERT INTO tmd_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Höxi röŋ mag aku, Jisas nöbö nuŋwa akuyöbö möl sö pɨsaŋ uröpɨnön, ");
INSERT INTO tmd_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ap nɨm gɨrön yadöŋa, “Nɨ ñɨgö mi yadmɨdla, nöbö nɨ pɨsaŋ ap nɨgiö paŋör nɨmmɨdöl yörɨk ör, nöbö i nɨ pɨl pal nɨgɨŋ, me rön, nɨ höuöu cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jisas aliö rɨmɨn, nöbö nuŋ bla lɨb pɨlɨm, rɨb diba yöx nugu gɨrön, nugwo paŋ paŋ yad nugwön yadmä, “Nagö nɨ yadmɨdlanö ä?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Aliö rɨmɨn, Jisas yadöŋa, “Ñɨŋ nöbö na akuyöbö möl sö mɨdöi aku, nöbö nɨ i mag akuyöbö aiöna. Nöbö aku nɨ pɨsaŋ ap kwosö paŋyöbö i nɨgiö nɨmmɨdöl mɨk. ");
INSERT INTO tmd_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nɨ Nöbö Ha nuŋwa, God Mönö kai kɨtön rɨg yadim mag akwör wöröxɨn aku, jɨ nöbö nɨ pɨl pal nɨgɨŋ, me rön, höuöu cön aku, nugwo ögwö yöxmɨdla. Nuŋ ölɨŋ höb diba pön makwam, nugwo yöx pön hölöxisöŋö aku waiö,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ap nɨm gɨrön, Jisas bred aku pön, God nugwo ri ablaŋe, rön, pɨ gɨlɨxön, nöbö nuŋ akuyöbö ñɨgö nöl gɨr yadöŋa, “Pön nɨmi! Aku mɨxɨñ nɨ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Makwam röbö wain namag aku algör pön, God nugwo ri ablaŋe, rön, nöbö nuŋ akuyöbö ñɨgö nölmɨn, magalɨg nɨmmɨdɨm nugugɨrön, yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","“Röbö kɨ, hañ nɨ. Hañ na hör pɨñön aku mɨ, God mönö mi yad nɨgöŋ akuyöbö, nöbö mö mɨga akwör pɨ nuŋ pɨsaŋ nɨgiö nɨgönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Jisas aliö rön yadöŋa, “Nɨ ñɨgö mi yadmɨdla, weik wop mɨdö kɨ ila nɨgön röbö waina iswob nɨmöin. Hör ör mɨdmön mɨdmön, God nöbö mö pön adöx yöd röul adö kau sö nugwidɨx mɨjön wop akwör röbö waina iswob nɨmnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Aliö rön, nöbö nuŋ bla pɨsaŋ God höjöpalɨb wopal i yadön, Olip Pɨda dumä. ");
INSERT INTO tmd_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisas nöbö nuŋ bla ñɨgö yadöŋa, “God Mönö maga kai kɨtön yadmä, ‘God nuŋ yadöŋa, “Nɨ nöbö hön sipsip uröi aku nugwo pal nɨgmön, hön sipsip akuyöbö bör pɨñwañ rɨ diöñɨŋö,” rö,’ rɨmä. Makwam, mɨd mɨdiö ñɨŋ magalɨg nɨ röböxön bör diöña. ");
INSERT INTO tmd_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Makwam nɨ wöröxön, öbɨlön mögörɨb Galili dumön, ñɨŋ mai yöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Jisas aliö rɨmɨn, Pita yadöŋa, “Nöbö bli nagö röböxbä maga röia, jɨ nör nagö röböxöin, wöhö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Aliö rɨmɨn, Jisas yadöŋa, “Nɨ nagö mi yadmɨdla, weik wop mɨdö gör, pɨxmag yuö mibɨl kwo kulakula wop mös wö ren mag aku, ‘Nɨ Jisas nugwo nugumɨdöiö,’ rön, wab mös paŋ wai nöinaŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Jisas aliö rɨmɨn, Pita mönö ölɨsö yadön yadöŋa, “Nɨ nagö pɨsaŋ pɨl pal nɨgnöb, pɨl pal nɨgɨŋ, jɨ nɨ Jisas nugwo nugumɨdöiö, rön yadöinö,” röŋa. Jisas nöbö nuŋ bla magalɨg Pita rɨg yadöŋ akwör yadmä. ");
INSERT INTO tmd_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jisas nöbö nuŋ bla pɨsaŋ bɨ yuö Getsemani duön ñɨgö yadöŋa, “Ñɨŋ yörɨk römɨd mɨjöña; nɨ du höjöpalɨba dumɨdlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Aliö rön, Pita, Jems, Jon nöbö ada yölɨŋ pön duön, rɨb diba yöx nugu gɨrön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","“Madmag na aku ölɨŋ pɨlɨp pɨn dum, wöröxɨb maga ra. Ñɨŋ il yörɨk mɨdön nugugu mɨjne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Aliö rön, ñɨgö yöraku yad nɨgön, nuŋ hör ör ir kwo duön, mɨgrö bö pɨn palön, ölɨŋ höb diba pɨba rɨmɨdöŋ aku, Nuö nuŋwa wöhö cönɨŋönö wöhö renɨŋö, rön, höjöpal gɨr mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nuö höjöpalön yadöŋa, “Acö, naŋ ap bla magalɨg rɨb akwör mɨda. Ap nɨ rɨba rɨmɨd aku, nɨ ömörö diba mɨda. Naŋ yöwö raŋ, nɨ akuyöbö alölaŋ. Makwam ap nɨ agapɨm rɨba rɨmɨjöñ aku, rɨb nɨ yöx nugul mag akuyöbö rölaŋ; rɨb naŋ keir yöx nugulö mag akwör nɨ ranö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jisas aliö rön, höbkal nöbö nuŋ mös paŋ mɨdim yöra hön nugwöŋa, ñɨŋ aŋadö inɨmö hölɨm dumä. Makwam, nuŋ Pita nugwo yadöŋa, “Saimon, pöd rɨmɨn inɨmö hölɨmmɨdlö? Hör aua ul mɨŋi nugugu mɨdɨbä maga mɨdöl ä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Aliö rön, nöbö nuŋ akuyöbö ñɨgö yadöŋa, “An mag gwogwo rɨb maga rö, rön, nugw ri abön, God höjöpal gɨr mɨjöña. Rɨb mag ñɨŋ aku rɨb maga ra aku, jɨ mɨxɨñ ñɨŋa höx rɨ pɨnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Aliö rön, iswob höbkal duön, Nuö höd höjöpalön rɨg yadöŋ mag akwör iswob höjöpalön röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Makwam iswob höbkal hön nugumɨn, nöbö nuŋ bla aŋadö inɨmö göj nɨgɨm hölɨm dumä. Nugwön, ñɨgö yadöŋa, “Ñɨŋ inɨmö hölɨm mɨdöiŋ ä?” röŋa. Aliö rɨmɨn ñɨŋ anau pön, paiŋö yadɨb maga nɨgölöŋ. ");
INSERT INTO tmd_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Makwam Jisas yöudöŋdöŋ duön, höbkal hön iswob inɨmö hölɨm gɨ mɨdmä aku nugwön yadöŋa, “Ñɨŋ hör hölɨm gɨ mɨdöiŋ ä? Aku wä ra! Wopa mödö ha. Nugwi! Nöbö i hön, Nöbö Ha nuŋwa wöñö u rön, nöbö ap kib mag gwogwo röi piaku ñɨgö nölɨba rɨmɨda. ");
INSERT INTO tmd_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Öbɨlɨŋ dinɨm! Nugwi! Nöbö nɨ wöñö u ra hömɨd mɨk,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisas ñɨgö mönö aku yadmɨn nugugɨrön, mag akwör, nöbö nuŋwa akuyöbö möl sö i, Judas, nöbö mɨga akwör pön höröpɨnöŋa. Nöbö adaku, God ap höjöpal ur nölɨb nöbö dib bla aipam, lo mönö yad nölɨb nöbö bla aipam, mönö pɨ nuöm nɨgɨb nöbö bla aipam, yad abɨm hömä. Ñɨŋ yu mɨxɨl ölɨsö bli kaiö bli pön rag hömä. ");
INSERT INTO tmd_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas höd ñɨgö yad nɨgön yadöŋa, “Nɨ nöbö i nugwo du yad wahax pön, alguna bɨmɨl nɨmmɨjɨn aku, nöbö maku, me rön, nugwo pɨ cɨcɨ nɨgön, pön di,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas Jisas mɨdöŋ yöra uröpɨnön, “Mönö yad nölɨb nöbö,” me rön, nugwo pɨ alguna bɨmɨlɨm nugugɨrön, ");
INSERT INTO tmd_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","nöbö bli hön, Jisas nugwo pɨ cɨcɨ nɨgmä. ");
INSERT INTO tmd_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jisas pɨ cɨcɨ nɨgɨm nugugɨrön, Jisas nöbö nuŋ i öbɨlön, yu mɨxɨl ölɨsö nuŋ aku pɨ pugul pön, God ap höjöpal ur nölɨb nöbö dib ödöriö aku mabö rɨ nölmɨd nöbö aku, nugwo rɨmɨj adöi aŋadö römal cö gɨ aböŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Makwam Jisas nöbö nugwo pɨ cɨcɨ nɨgim akuyöbö ñɨgö yadöŋa, “Ñɨŋ yu mɨxɨl ölɨsö pön, kaiö pön, nɨ ap kib pɨb nöbö i me rön hömɨdöi ä? ");
INSERT INTO tmd_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nɨ öim öim God höjöpalɨb rama duön, ñɨŋ pɨsaŋ mɨdön, ñɨgö nöbö mö akuyöbö mönö yad nölmɨdɨl aku, jɨ nɨ pɨ cɨcɨ nɨgölim. Makwam wopik ñɨŋ God Mönö aku kai kɨtön rɨg yadmä akwör rɨmɨdöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Makwam mag akwör, Jisas nöbö nuŋ bla magalɨg nugwo röböxön bör du pörmä. ");
INSERT INTO tmd_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ha nöbö i, wölɨj mɨlkap iör yömön, Jisas nugwo pön dumɨdim aku mai dum, nugwo aipam pɨba rɨmɨn, ");
INSERT INTO tmd_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","bör dumɨdɨm, wölɨj wab nuŋwa röd pɨm, nuŋ magör bör duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jisas nugwo pön du, God ap höjöpal ur nölɨb nöbö dib ödöriö rama dumä. Pön dumɨdɨm, God ap höjöpal ur nölɨb nöbö dib bla nɨgön, mönö pɨ nuöm nɨgɨb nöbö bla nɨgön, lo mönö yad nölɨb nöbö bla nɨgön, hö ram aku mögum rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita piöŋö häp häp nugup duön, God ap höjöpal ur nölɨb nöbö dib ödöriö aku rama uröpɨnön, nöbö ram aku mabö rɨmɨdöi bla pɨsaŋ römɨdön, rɨn mau mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","God ap höjöpal ur nölɨb nöbö dib bla nɨgön, Juda Kansol dib nöbö bla nɨgön, Jisas rɨ yönmɨd akuyöbö mönö il i pön, nugwo pɨl pal nɨgnɨŋö, rön, hölu nugw yualöbmä. ");
INSERT INTO tmd_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nöbö mö mɨga pön höm, Jisas nugwo mönö inakmönö adö bli yadmä aku, jɨ mönö yadmä aku paŋ höjɨl i yadölim. Hörɨrör yadmɨn, mönö il bli nugwölim. ");
INSERT INTO tmd_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Makwam bli öbɨlön, inakmönö hörön, yadmä, ");
INSERT INTO tmd_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“An nugugu mɨdmɨn, nuŋ yadöŋa, ‘God höjöpalɨb rama, imag pön urim kɨ, nɨ hajal abön, wop mös paŋ iswob ur nɨgɨnö. Imag pön uröi akuyöbö röin; nɨ ram yoŋyöbö ur nɨgɨnö,’ rö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mönö yadmä aku algör ör paŋ höjɨl i yadölim; hörɨrör yadmä. ");
INSERT INTO tmd_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","God ap höjöpal ur nölɨb nöbö dib ödöriö aku öbɨlön, Jisas nugwo yadöŋa, “Nagö yadmɨdöi mönö aku, naŋ mönö paiŋö i yadöine ä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Aliö rɨmɨn, Jisas mönö i paiŋö yadölmɨn, iswob yad nugwön yadöŋa, “Nagö mɨ Mesaia aku, Nöbö Dib wä aku Ha nuŋ mönö ä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Aliö rɨmɨn, Jisas yadöŋa, “Yöwö mɨ. Aku nör. Nɨ, Nöbö Ha nuŋwa, Nöbö Dib ölɨsö ödöriö aku imag mɨrɨx pɨlö adö römɨd mɨd pörön, adöx yöd röul adö kau sebö mɨjöi wab i yuö sö pik hömɨdmön, nugwöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Jisas aliö rɨmɨn, God ap höjöpal ur nölɨb nöbö dib ödöriö aku, wölɨj nuŋ bla keir pɨ waglöx gɨrön yadöŋa, “Nuŋ God iba yad höimöu aku nugwöia! Makwam, nöbö mö bli yad nugwöinɨŋ. Nuŋ rɨ gwogwam rɨ maga wöxnö yad maku pal. Makwam, ñɨŋ agö rɨbɨm yöx nugumɨdöi?” röŋa. Aliö rɨmɨn, nöbö dib bla magalɨg öbɨlön yadmä, “Nöbö aliö ra aku, nugwo pɨl pal nɨgɨb,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Aliö rön, nöbö bli Jisas nugwo höpöl pɨlön, wölɨj wab i pɨ mämäg nugwo aku pöröb nölön, nugwo pal gɨrön yadmä, “Naŋ keir nugwön an yadaŋ nugunɨŋ, nagö yönɨmɨm palmɨd?” rɨmä. God höjöpalɨb rama ömdö nöbö bla, algör ör nugwo mɨ göj göj palmä. ");
INSERT INTO tmd_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita du römɨdöŋ yör akwör mɨdmɨn nugugɨrön, ha mö i, God ap höjöpal ur nölɨb nöbö dib ödöriö aku mabö rɨ nölmɨd i höröpɨnön, ");
INSERT INTO tmd_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pita bɨ yuö mɨdöŋ yöraku nugwön yadöŋa, “Nagö kwo algör Jisas nöbö Nasaret yöbö aku pɨsaŋ yönmɨdlaŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Aliö rɨmɨn, Pita yadöŋa, “Nagö agapɨm yadmɨdlö? Yadmɨdlö mönö aku nɨ nugumɨdöiö,” röŋa. Aliö rön, rɨŋö bö dumɨn nugugɨrön, kulakula wö röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ha mö akwör, Pita nugwo iswob nugwön, nöbö mö mɨdim akuyöbö ñɨgö yadöŋa, “Nöbö kɨ Jisas nöbö nuŋ i,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Aliö rɨmɨn, Pita iswob wöhö röŋa. Hör mag ul mɨŋi mɨdɨm, nöbö mö öbɨl gɨ mɨdim piaku, Pita nugwo iswob yadmä, “Nagö kwo algör mögörɨb Galili yöbö makwam, an nugumɨn nagö nöbö nuŋ akwör i mɨdlaŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Aliö rɨmɨn, Pita yadöŋa, “Nöbö Diba nugugu mɨda; makwam wai nölmön pɨl pal nɨgöna. Makwam mɨ ödöriö yadmɨdla! Nöbö aliö yadmɨdöi nöbö aku nɨ nugumɨdöiö, mɨ wöhö!” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Aliö rɨmɨn nugugɨrön, kulakula aku iswob wö röŋa. Wö rɨm, Jisas Pita höd yadöŋa, “Kulakula wö mös ren mag aku, ‘Nɨ Jisas nugumɨdöiö,’ rön, wab mös paŋ wai nöinaŋö,” röŋ mönö aku nugumɨn, lɨb pɨlɨm, mɨ göj imöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pɨxmag alɨg, God ap höjöpal ur nölɨb nöbö dib bla nɨgön, lo mönö yad nölɨb nöbö bla nɨgön, mönö pɨ nuöm nɨgɨb nöbö bla nɨgön, Juda Kansol dib nöbö bla magalɨg nɨgön, magalɨg mönö yad ödör nɨgön, Jisas nugwo nag nɨgön, pön gapman nöbö dib Pailot mɨdöŋ yöra dumä. ");
INSERT INTO tmd_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pön dum, Pailot Jisas nugwo yadöŋa, “Nagö Juda nöbö mö kiŋ ñɨŋ me?” röŋa. Aliö rɨmɨn, Jisas yadöŋa, “Mɨ mönö naŋ yadlö maku pal,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","God ap höjöpal ur nölɨb nöbö dib bla Jisas mönö diba yadön mönö hörɨrör mɨga akwör yadmä. ");
INSERT INTO tmd_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Almɨn, Pailot Jisas nugwo yadöŋa, “Nagö mönö mɨga yadmɨdöi aku, nagö paiŋö mönö bli yadöine ä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Aliö rɨmɨn, Jisas paiŋö mönö i yadölmɨn, Pailot rɨb mɨga yöx nugwöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Makwam Juda ada Pasopa wop dib aku höm, öim du Rom gapman nöbö dib Pailot nugwo yad nugumɨn, ñɨgö kɨlabɨs nöbö ñɨŋ yad nugumɨdöi nöbö akwör hör yad abmɨda. ");
INSERT INTO tmd_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Makwam wop aku, nöbö i, ib nuŋwa Barabas, nuŋ nöbö mö bli ödör pön du, Rom gapman pɨsaŋ nuö pɨlön, nöbäpö i pɨl pal nɨgɨm, ñɨgö nag nɨgɨm mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Makwam nöbö mö akuyöbö hö mögum rön, Pailot nugwo kɨlabɨs nöbö öim rɨg yad nugumɨdöi mag akuyöbö yad nugumɨn, ");
INSERT INTO tmd_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pailot ñɨgö yadöŋa, “Juda kiŋ dib ñɨŋ aku yau abɨn ä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Aku agapɨm: Pailot nuŋ keir nugwöŋa, God ap höjöpal ur nölɨb nöbö dib bla, Jisas nugwo rɨb gwogwo yöx nugwön, nugwo pön hö nölmä. ");
INSERT INTO tmd_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Makwam God ap höjöpal ur nölɨb nöbö dib bla, nöbö mö piaku ñɨgö yadmä, “Pailot nugwo yadɨŋ, Jisas wöhö, Barabas nugwo yau abaŋ,” me rɨmä. Aliö rɨmɨn, nöbö mö piaku Pailot yadmä, “Barabas ana yau abne,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Aliö rɨmɨdmɨn, Pailot yadöŋa, “Aliö yadöi aku, jɨ nöbö kɨ ñɨŋ Juda kiŋ an, me röi aku, nugwo pödi yajɨnö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Aliö rɨmɨn, ñɨŋ mönö bölölö rön yadmä, “Nugwo bɨ katlö watlö höñ sö pɨl pal nɨgö!” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Aliö rɨmɨdmɨn, Pailot yadöŋa, “Nuŋ agapɨm rɨ gwogwam raŋ, nugwo aliö ain?” röŋa. Aliö rɨmɨdmɨn, jɨ ñɨŋ bölölö diba rön yadmä, “Bɨ katlö watlö höñ sö pɨl pal nɨgö! Bɨ katlö watlö höñ sö pɨl pal nɨgö!” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pailot, mönö ölɨsö kapa yadim aku yöxön, nöbö mö akuyöbö ñɨgö wä raŋ, me rön, Barabas nugwo hör yad abön, nöbö nuŋ bli ñɨgö yadmɨn, Jisas nugwo nag nɨgön, mɨ göj göj palmä. Jisas pal pörɨm nugugɨrön, Pailot yadöŋa, “Nugwo pön du bɨ katlö watlö höñ sö pɨl pal nɨgɨŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ami nöbö piaku, Jisas nugwo pön gapna Pailot ram dib nuŋ aku ram möl yuadö duön, nöbö yam ñɨŋ bla magalɨg yad wö rɨmɨn hömɨdmɨn, ");
INSERT INTO tmd_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","wölɨj paskwolö mɨlkap i, gapman nöbö dib bla röböi akuyöbö Jisas nugwo yöm nölön, ap kaigap alɨg bli ödör pön hön, kiŋ röböi usaŋ mea akuyöbö i rön, nugwo yöcmac sö röb nölmä. ");
INSERT INTO tmd_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Röb nölön, Jisas nugwo ölɨsö wölolö rɨ gɨrön yadmä, “Nagö Juda kiŋ diba öim mɨdane!” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Aliö rön, kaiö pön, yöcmac nuŋwa palön, nuŋ höpöl pɨl nölmä. Mɨdöŋ il yöra höxmax yuön, ñɨŋ kiŋ nugwo rɨg röi mag akuyöbö, yöcmaca ubɨlmä. ");
INSERT INTO tmd_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nugwo aliö yad höimöuön, wölɨj paskwolö mɨlkapa nugwo yöm nölim aku pɨ röd abön, wölɨj nuŋwa keir aku yöm nölön, bɨ katlö watlö höñ sö pɨl pal nɨgɨba pön dumä. ");
INSERT INTO tmd_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ñɨŋ mibɨl yöra du gɨrön, Aleksada Rupas hödpɨg hogwa nuö ñɨŋa Saimon, Sairini taun yöbö nöbö aku, piaku rɨp yönön, hön Jerusalem duba dumɨdöŋ aku, nugwo möigw palön, ususör rön, yadmä, “Jisas bɨ katlö watlö wab aku pɨ ragpɨd nɨg rag duö!” rɨmɨn, pön ñɨgö pɨsaŋ duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Akuyöbö alɨp duön, Jisas nugwo pön du mögörɨb yöraku mönö yöbö iba urön Golgota me rɨmɨdöi yöra uröpɨnmä. Golgota mönö ila aku “Nöbäpö Yöcmac Yöj Lei.” ");
INSERT INTO tmd_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Uröpɨnmɨn, nugwo röbö wain i pön, marasɨn mö röia bli pɨ pɨn höbkal mal rön, Jisas nugwo nölmä jɨ nɨmölöŋ. ");
INSERT INTO tmd_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jisas nuŋ bɨ katlö watlö höñ sö pɨl pal nɨgön, wölɨj nugwo bla pön, nuöm nɨg hörɨrör pɨba, höbai sadu röxg wobön pɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Pipai naiö wölön yöra sö höŋ mag aku, Jisas nugwo bɨ katlö watlö höñ sö cɨpɨl pal nɨgmä. ");
INSERT INTO tmd_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Cɨpɨl pal nɨgön, pödpöd rɨmɨn pɨl pal nɨgim mönö aku, bɨ katlö watlö waba höñ rol sö kai kɨtmä: ");
INSERT INTO tmd_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Wop aku, ap kib pɨb nöbö mös hogwa algör bɨ katlö watlö um sö, i imag mɨrɨx adö bɨ höña, i imag cökö adö bɨ höña pɨl pal nɨgmä. ");
INSERT INTO tmd_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Alim mag aku, God Mönö aku kai kɨtön, rɨg cöñɨŋö rim mag akwör rɨmä. Mönö aku kai kɨtön yadmä, “Nugwo nugwɨŋ, mag gwogwo rɨb nöbö i röxg nɨgönɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nöbö mö bla uhö gɨrön, Jisas nugwo nugwön, yöcmac kwatkwat rön, nugwo yad höimöuön yadmä, “Nagö, ‘God höjöpalɨb ram aku hajalön, wop mös paŋ iswob rɨ nɨgɨnö,’ rɨmö aku, ");
INSERT INTO tmd_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","weik naŋ keir rön, il bö pɨnön kömö duanö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","God ap höjöpal ur nölɨb nöbö dib bla aipam, lo mönö yad nölɨb nöbö piaku aipam, Jisas nugwo algör ör yad höimöuön, ñɨŋ keir nuö nuö yadɨp duön yadmä, “Nöbö mö bli ñɨgö rɨmɨdmɨn kömö duöia, jɨ wopik nuŋ keir algör rön kömö dubä maga mɨdöl. ");
INSERT INTO tmd_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nuŋ öim yada, ‘Nɨ Mesaia mɨdla, Isrel nöbö mö Kiŋ ñɨŋa mɨdlö,’ rɨ aku, weik nuŋ yör sö cɨpɨl pal nɨgöi aku, nuŋ keir algör ör öbɨl yörɨk haŋ nugwön mi yadlaŋö, rön, nugwo nugw pɨnɨŋö,” rɨmä. Makwam Jisas pɨsaŋ pɨl pal nɨgim nöbö hogwa, Jisas nugwo algön nör yad höimöumä. ");
INSERT INTO tmd_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Naiö mibɨl yör kɨpisö höŋ mag aku, pɨxmag urön, mɨdɨp duön, naiö pibö pik röŋ mag aku iswob mil pöröŋa. ");
INSERT INTO tmd_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Mil abmɨn nugugɨrön, Jisas ajmöla aj halön, wö rön yadön yadöŋa, “Eloi, Eloi, lama sabaktani?” röŋa. Hibru mönö yadöŋ aku mönö il aku, “God nɨ. God nɨ. Nɨ pödpöd rɨmɨn röböxlö?” ");
INSERT INTO tmd_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Aliö rɨmɨn, nöbö mö il yöraku mɨdim bla nugwön yadmä, “Nugwi! Nuŋ Ilaija yad wö rɨmɨdö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nöbö i ap höx mei pön, röbö wain rɨg ulmɨdö woböi möl bö pɨlön, Jisas nugwo nölmön nɨmaŋ, me rön, aiwölö mɨxɨl i pɨ idu pɨlön, mɨdöŋ bɨl sö nöl gɨr, yadöŋa, “An nugugu mɨdɨŋ, Ilaija hön, nugwo pɨ öröu rag pɨn mɨgrö bö nɨgönɨŋönö wöhö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Aliö rön, nugugu mɨdɨm nugugɨrön, Jisas wö diba rön, aŋöi maga ödör pöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Wop akwör, wölɨj mɨxɨl dib God höjöpalɨb ram möl yuebö ubalɨja idɨxmä aku, mibɨl bö waglöxmɨn adöi hör adöi hör dum möl röd gɨ mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nöbö ami bla nugwidɨx mɨdmɨd nöbö diba, bɨ katlö watlö waba höña il yöra mɨdön, Jisas aliö rön wöröxöŋ aku nugwön yadöŋa, “Mɨ! Nöbö kɨ God Ha nuŋ!” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Mö mɨga akwör Jisas pɨsaŋ Jerusalem hem piaku, hön rɨb yöraku mɨdmä. Mibɨl aku, mö mös paŋ Jisas nugwo mai duön mabö bli rɨ nölmɨdöi mögörɨb Galili. Mö Maria ib nɨgiö hogwa mös mɨdmä; mö ib nɨgiö hogw aku, i Magdala taun yöbö, i Jems Josep hödpɨg hogwa nuöm ñɨŋ aku. Mö i ib nuŋwa Salomi. Mö ada bla magalɨg nugugu mɨdɨm nugugɨrön, Jisas wöröxöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Josep Arimatia taun yöbö nöbö aku, Juda Kansol dib nöbö rɨb i, God nöbö mö pön nugwidɨx mɨdɨb wop aku pöx mɨdmɨda. Nöbö aku, aiaŋ God höjöpalɨb wop aku, wopik ap pɨdɨlub wop, me rön, ap rɨ pɨdɨlumɨdöŋa. Jisas wöröxöŋ aku nugwön, ruö igöp höxi rɨmɨdö, rön, weik nöbäpö högia pɨ öröu rag du hogw pinö, rön, ipöxölöŋ; Pailot mɨdöŋ yöra duön, yad nugwöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Yad nugum, Pailot, Jisas mödö wöröxöŋ mönö aku nugwön, pɨlɨx rön, ami nöbö nugwidɨx mɨdmɨd nöbö dib aku nugwo wö rɨm, hömɨdmɨn, yad nugwöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Yad nugumɨn, yadöŋa, “Maduö wöröxö,” röŋa. Aliö rɨmɨn, Pailot Josep nugwo yadöŋa, “Yöwö. Nöbäpö rag du hogw pɨlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Aliö rɨmɨn, Josep wölɨj lei dib i wobön, rag du nöbäpö högia pɨ öröu pön pɨn il bö nɨgön, wölɨj aku pɨ magalɨg wobön, pön du rɨg möl yoŋyöbö akwör yölu nɨgim rɨg möla hogw pɨlöŋa. Hogw pɨlön, rɨg aso dib i pɨraiup pikopik rɨp duön, nöbäpö hogwaj möla idɨxön duöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magdala pɨsaŋ, Maria Josep nuöm aku pɨsaŋ, nugugu mɨdɨm nugugɨrön, nöbäpö hogw pɨlmä. ");
INSERT INTO tmd_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Juda God höjöpalɨb wop ñɨŋ aku i padɨxmɨn, Maria Magdala aku, Maria Jems nuöm aku, mö Salomi aku, nöbäpö högia wel röbö nɨg nöinɨŋö, rön, du wel röbö hölɨŋ wä höb bli wob rag hö nɨgɨm hölɨmöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Löum yöbö Sade wop aku, pɨxmag alɨg öbɨlön, naiö yöudöŋdöŋ wölɨm nugugɨrön, nöbäpö hogw pɨlim yöra dumɨdmä. ");
INSERT INTO tmd_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ödöi mibɨl yöra du gɨrön yadmä, “Nöbäpö hogw möla idɨxim rɨg dib aku, yönɨm pɨ göur abön?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Aliö rön, uröpɨnön nugumɨn, rɨg dib ödöriö nöbäpö hogw möla ŋöl idɨxim aku, mödö kɨrɨrɨ rɨ du rɨb gägäp ada mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nugwön, möl bö ipalɨp duön nugum, ha nöbö wölɨj lei mɨlkap yömöŋ i, imag mɨrɨx adö römɨd gɨ mɨdöŋa. Nugwo nugwön ipöxmä. ");
INSERT INTO tmd_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ipöxmɨdɨm, ñɨgö yadöŋa, “Ipöxmɨjeñ. Nɨ nugula, ñɨŋ Jisas nöbö Nasaret yöbö, bɨ katlö watlö höñ sö pɨl pal nɨgmä aku nugwo nuguba hömɨdöia. Makwam nugwi! Nuŋ yörɨk mɨdöl. Nuŋ maduö öbɨlön dua. Nugwo hogw pɨlön nɨgim yöra yör akwör mɨd mɨ göm hö nugwi. ");
INSERT INTO tmd_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Makwam yadkap duön, nöbö nuŋ bla Pita pɨsaŋ yajöña, ‘Jisas nuŋ höd duön Galili mɨjöna. Nuŋ keir ñɨgö höd yadöŋ mag akuyöbö, ñɨŋ du nuŋ nugwöñ ödöi piaku,’ me cɨne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Aliö rɨmɨn, mö bla ölölö rɨmɨn, iŋ wajmag bla gɨl gɨl rɨmɨn, nöbäpö hogw möla rɨŋadö röpɨnön röböx ipalɨp dumä. Ipöxön nöbö mö bli ñɨgö mönö aku yad nölölim. ");
INSERT INTO tmd_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jisas wöröxön, wop agñɨŋ yöbö aku öbɨlön, höd duön, Maria Magdala mɨdöŋ yöra wöxnö nɨgmɨn, nugwo nugwöŋa. Makwam mö aku nugwo höd ragwo ha akuyöbö mɨj sö aku yuö wöl mɨdöŋa nugwön Jisas ragwo ha yad aböŋa. ");
INSERT INTO tmd_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Nuŋ Jisas nugwo nugwön, du nöbö nuŋ bla immɨdim mibɨl yöra duön, Jisas kömö mɨda nugwo nugula, rɨmɨn, ñɨŋ mɨ aŋadö wöröxa, rön, mönö nugwo aku yöxölim. ");
INSERT INTO tmd_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mai piöŋö, Jisas nöbö nuŋ mös mögörɨb möl i rɨp yönmɨdmɨn, Jisas nuŋ nöbö hör i röxgön hön, ödöi mibɨl yöra wöxnö nɨgmɨn, nugwo nugwön, ");
INSERT INTO tmd_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","du nöbö nuŋwa bli ñɨgö yad nölmɨn aku, jɨ mi yadmɨdöiŋö, rön, mönö ñɨŋa yöxölim. ");
INSERT INTO tmd_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mai wop i, Jisas nöbö nuŋwa akuyöbö agɨp sö piaku ap nɨmmɨdim mibɨl yöra wöxnö nɨgön, ñɨgö yad gɨr yadöŋa, “Nɨ öbɨlmön, nöbö mö bli nɨ wöxnö nugwön, hön ñɨgö yad nölmɨn, pödpöd rɨmɨn inakmönö hörön yadöi, öbɨlölö, rön nugwöi?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Aliö rön ñɨgö yadöŋa, “Ñɨŋ mönö wä na aku pɨrag mögörɨb adadö magalɨg du gɨrön, nöbö mö akuyöbö magalɨg yad nöiöña. ");
INSERT INTO tmd_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nöbö mö bɨl kai mönö wä na nugw pön röbö paiöñ akuyöbö, kömö diöña. Makwam nöbö mö bɨl kai mönö wä na nugw peñ akuyöbö, God ñɨgö mönö diba yadaŋ ölɨŋ höb pɨmɨjöña. ");
INSERT INTO tmd_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","“Nöbö mö mönö na nugwön, ‘Mi yadö,’ rön, nugw pöñ akuyöbö, ap rölɨbä mag cɨmala cöña. Ragwo ha akuyöbö nöbö mö ñɨgö yuö wöiön akuyöbö, ib na urön, yad abɨŋ röu diöña. Mönö yöbö ñɨŋ aku röböxön, mönö yöbö adö hörɨrör yajöña. ");
INSERT INTO tmd_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kas kadkwol nöbö mö öbɨx akuyöbö pɨ nugwɨŋ, ap i raŋ wöröxeñ. Ap gwogwo nöbö mö nɨmön wöröxöi akuyöbö bli nɨmɨŋ, ap i raŋ wöröxeñ. Makwam nöbö mö ap cön akuyöbö, ñɨgö imaga calɨŋ, kömö nɨgönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nöbö Dib Jisas mönö mag aku ñɨgö yad pörmɨn nugugɨrön, God nugwo pön, mögörɨb nuŋwa adöx yöd röul adö kau sö pön duöŋa. Pön dumɨn, God imag mɨrɨx nuŋ ada römɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Makwam nöbö nuŋ akuyöbö duön, Krais mönö wä aku mögörɨb piaku piaku magalɨg yad nölɨŋ duaŋ nugugɨrön, Nöbö Diba, mönö wä na mɨ nɨgönɨŋö, rön, ñɨgö pɨsaŋ mɨdön ölɨsö nölɨm, ap rölɨbä mag cɨmal akuyöbö rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Jisas Krais mibɨl anɨŋ kɨ yöx pön höm, dib röxön rɨg röŋ röŋ mag akuyöbö, nöbö bli mämäg ñɨŋa keir nugwön, mönö mag wä aku yad nölɨp yönön, nɨ aipam, nöbö mö bli kwo ñɨgö aipam, yad nölmä. Yad nölmɨdmɨn nöbö mɨga mönö aku nugw ri abön kai kɨtmä. ");
INSERT INTO tmd_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Makwam nöbö dib Tiopilas, nɨ kwo algör ör mönö nɨ yad nölim aku, ila magalɨg hölu nugw ri abɨl makwam, nɨ algör ör mönö aku magalɨg rɨbyöx nugw ri abön, nagö kai kɨtɨba rɨmɨdla. ");
INSERT INTO tmd_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Akuyöbö almön mönö, mönö nagö yadim nugulö aku, mi yadöiŋö, rön nugunö. ");
INSERT INTO tmd_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Höd Kiŋ Herod Judia Propins nugwidɨx mɨdmɨd wop aku, nöbö nagö Sekaraia, God ap höjöpal ur nölɨb nöbö i mɨdmɨda. Nöbö yam nuŋwa pɨsaŋ mabö nɨgiö nɨgön rɨmɨdöi akuyöbö ñɨgö Abaija Yam me rɨmɨdmä. Sekaraia mönɨŋ nuŋwa Ilisabet. Ilisabet algör ör God ap höjöpal ur nölɨb nöbö Eron il aku yöxɨp u höuöilmel rön yöxmä. ");
INSERT INTO tmd_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ñɨŋör mönöbö hogwa God lo mönö adaku magalɨg mai rɨ gɨr mɨdɨm, God nugum, mönö i mɨdölöŋ. ");
INSERT INTO tmd_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Makwam Sekaraia mönɨŋ nuŋwa Ilisabet mö wasɨma makwam, ha i yöx pön hölöŋ wöhö, aŋadö nöbö nom lap nom röxgmä. ");
INSERT INTO tmd_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Wop i Sekaraia nöbö nuŋ pɨsaŋ mabö nɨgiö nɨgön rɨmɨdöi akuyöbö hön, God höjöpalɨb mabö aku rɨmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Makwam mabö ñɨŋa rɨ gɨr, God ap höjöpal ur nölɨb nöbö bla öim rɨg rɨmɨdöi mag akuyöbö, nöbö an kai God höjöpalɨb rama ram möl yuadö duön ap hölɨŋ wä höb aku wiönɨŋö, rön, rɨp ñɨña pugul pɨmä. Pɨmɨn, Sekaraia nuŋ rɨp ñɨña keir pugul pön, God höjöpalɨb rama ram möl yuadö duba röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nöbö mö mɨga akwör God höjöpalɨb rama rɨŋadö bö God höjöpal gɨr mɨdmä nugugɨrön, Sekaraia nuŋ ram möl bö duön ap hölɨŋ wä höb akuyöbö urmɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Jɨ Nöbö Diba ejol nuŋ i hön, ap hölɨŋ wä höba urmɨdöi rɨgpɨd aku imag mɨrɨx adö wöxnö mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekaraia ejol aku nugwön pɨlɨx röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Makwam ejol aku nugwo yadöŋa, “Nagö ipöxmɨjɨnö. God höjöpalön rɨlö aku nuŋ nugwa. Manaŋ Ilisabet ha nagö i yöx pön höna. Yöx pön haŋ, ib nuŋwa Jon me rö. ");
INSERT INTO tmd_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nuöma ha aku yöx pön hön aku, nagö mɨ ödöriö wahax pɨnö; nöbö mö mɨg mɨŋa algör ör wahax pöña. ");
INSERT INTO tmd_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nöbö Diba mämäg il rol nuŋ aku, Jon nöbö diba mɨjöna. Nuŋ röbö wain mönö röbö ölɨsö bli nɨmenɨm. Nuöma ha wöta mɨjön wop aku akwör, Inöm Leia nuŋ ha aku yuö kwo duön aja wölöna. ");
INSERT INTO tmd_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mai nuŋ Isrel nöbö mö God nugwo röböxöi akuyöbö mɨga mönö wä yad nölaŋ, God nugwo, Nöbö Dib an, me rön, nugw pöña. ");
INSERT INTO tmd_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Makwam ha naŋ aku nuŋ God mönö yadɨb nöbö Ilaija maduar ör God ölɨsö pön rɨg rɨmɨd mag akuyöbö cöna. Nuö nöbö ñɨgö pön, halöu ha ñɨŋ bla pön, ñɨgö pɨ nɨgiö paŋör nɨgöna. Nöbö mö God nugwo ölɨsö wölolö röi akuyöbö, ñɨgö mönö wä yad nölaŋ, nöbö mö kömö wä nuŋwa rɨbyöx nugwöi mag akuyöbö nugwön, ösös rɨ ri abön, Nöbö Diba hönɨŋö, rön, pöx mɨjöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ejol aku aliö rɨmɨn, Sekaraia yadöŋa, “An mönöbö hogwa nöbö nom lap nom röxgöla. Makwam, nɨ agö magɨm rön, nagö mi yadmɨdlaŋö, rön, nugun?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Aliö rɨmɨn, ejol aku Sekaraia nugwo yadöŋa, “Nɨ Gebriel. Nɨ God mämäg il rol yöra mɨdön, nɨ yad abmɨn hön mönö wä kɨ nagö yad nölɨba hömɨdla. ");
INSERT INTO tmd_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Naŋ mönö na yadmɨdɨl aku, mi yadmɨdö, rön nugwöiö aku, albeñ nagö aku ömörö raŋ, mönö pön mɨdöinam. Hör ör mɨdɨp du, ha aku yöx pön höñ wop akwör iswob mönö pɨnaŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Makwam Sekaraia God höjöpalɨb rama ram möl mibɨl yuebö kwo mɨxɨl magi mɨdöŋa nugwön, nöbö mö rɨŋadö bö mɨdim bla rɨb mɨga yöxmä. ");
INSERT INTO tmd_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mai nuŋ rɨŋadö röpɨnön, mönö bli yadɨbä maga nɨgölöŋ. Makwam, nɨ al aliö rö, rön, imag akwör yabuöŋa. Ñɨŋ nugwön yadmä, nuŋ ram möl yuö kwo du mɨdön, mag hör i nugwön hö, rön, nugumä. ");
INSERT INTO tmd_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Makwam Sekaraia God höjöpalɨb rama mabö rɨ mɨdmɨn, wop nuŋ aku pörɨm, nöbö bli hön yör nuŋ aku pɨm nugugɨrön, nuŋ höbkal ram nuŋwa duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Mai mɨdɨp duön, mönɨŋ nuŋwa Ilisabet ha wöta mɨdɨm yadöŋa, “Höd nɨ mö wasɨma mɨdmɨdɨl makwam, nɨ möigw yöxma, jɨ weik Nöbö Diba nɨ uliöxön nugwidɨx mɨdɨm, ha wöta mɨdɨl aku nɨ wä ra, möigw yöxöin, wöhö,” röŋa. Aliö rön, röun akuyöbö mömɨd sö tar ram möl yuadö akwör umad gɨ mɨdmɨda. ");
INSERT INTO tmd_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ilisabet röun akuyöbö iŋösu sö ha wöta mɨdmɨn nugugɨrön, God ejol Gebriel nugwo yad abmɨn duöŋ Nasaret taun, mögörɨb Galili yöraku. ");
INSERT INTO tmd_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nasaret yöraku ha mö i mɨdmɨda, ib nuŋwa Maria. Ha mö aku nöbö i pɨsaŋ yönölöŋ wöhö. Ha mö aku, nöbö nagö Josep pönɨŋö, rön yadmä. Nöbö Josep aku, nuŋ kiŋ Depid nöbö hödɨg aku i yöx pön hön nɨgmä. ");
INSERT INTO tmd_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","God ejol Gebriel yad abmɨn, ha mö Maria mɨdöŋ yöra uröpɨnön yadöŋa, “Ha mö, nagö mɨdlö ä? Nöbö Diba nagö pɨ ri aba. Naŋ pɨsaŋ mɨdö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Aliö rɨmɨn, Maria mönö aku nugwön, nɨ pöd rɨmɨn aliö yadmɨdö, rön, rɨb mɨga yöxöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nuŋ rɨb mɨga yöx nugumɨn nugugɨrön, ejola nugwo yadöŋa, “Maria, nagö ipöxmɨjɨnö. God nagö pɨ ri abön ra. ");
INSERT INTO tmd_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mai naŋ ha wöta mɨdön, ha i yöx pön hönö pal. Yöx pön hön, ib nuŋwa Jisas, me rö. ");
INSERT INTO tmd_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Makwam nuŋ nöbö dib ödöriö mɨjöna. Nöbö mö nugwo yadön yajöña, adöx sö mɨd Nöbö Dib ödöriö Ha nuŋwa maku, me cöña. God Nöbö Diba rɨmɨdaŋ nugwön nuŋ nöhönɨŋ maduebö Depid kiŋ diba mɨdmɨd aliar mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jekop yöxɨm yöxɨp höuöilmel rɨŋ mɨjöñ akuyöbö ñɨgö magalɨg öim öim kiŋ ñɨŋa mɨdön nugwidɨx mɨjönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ejol aliö rɨmɨn, Maria nugwo yadöŋa, “Nɨ nöbö i pɨsaŋ mɨdöi aku, pödpödiö ha aku yöx pön hön?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Aliö rɨmɨn, ejola nugwo yadöŋa, “Inöm Lei akwör hön, Nöbö Dib ödöriö adöx mɨ bɨl sö mɨd Nöbö ölɨsö mag nuŋ akwör pöröb nöiöna. Alaŋ, ha leia yöx pön hönö aku, nöbö mö nugwön yajöña, aku God Ha nuŋ, me cöña. ");
INSERT INTO tmd_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mɨ! Nobnaŋ Ilisabet mö lap röxga. Ñɨŋ nugwo mö wasɨm me rɨmɨdöi aku, jɨ weik nuŋ ha wöta mɨdmɨn, röun akuyöbö iŋösu sö mödö rödɨpöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","God ap rölɨbä akuyöbö i mɨdöl; ap bla magalɨg paŋ rɨb akwör mɨdö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ejola aliö rɨmɨn, Maria yadöŋa, “Nɨ God mabö rɨ nölɨb halöu. Rɨg yadmɨdlö mag akwör nɨ cönɨŋö,” röŋa. Aliö rɨmɨn nugugɨrön, ejola nugwo röböxön duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Makwam Maria rɨmgör dinö, rön, mögörɨb aku röböxön mögörɨb Judia önöŋ ajmag mɨxɨl aku dumɨd dumɨd, Sekaraia Ilisabet mönöbeŋö mɨdmɨdöi tauna duöŋa. Ram ñɨŋa uröpɨnön, nobnɨŋ Ilisabet nugwo yadöŋa, “Nagö mɨdlö ä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","“Nagö mɨdlö ä?” rɨmɨn, nobnɨŋ Ilisabet mönö aku nugum, ha wöta mɨdöŋ aku ha yöd nɨgöŋa. Wop mɨd akwör Inöm Leia nuŋ Ilisabet yuö kwo duön nuŋ aja wölöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","God Inöma aja wölmɨn, Ilisabet nuŋ ajmöla aj halön Maria nugwo yadöŋa, “God mö bli ñɨgö nugwidɨx mɨd aku, jɨ nagö pɨ ösös rɨ ri abön ra. Ha wöt naŋ mɨdlö abö ha aku aipam pɨ ösös rɨ ri abön ra. ");
INSERT INTO tmd_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nɨ mö wä yöi jɨ nagö Nöbö Dib na nuöm nuŋ aku nɨ nuguba hölö aku nɨ aiö rön God nugwo ri abö rɨmɨdla. ");
INSERT INTO tmd_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Naŋ hön nɨ, ‘Nagö mɨdlö ä?’ rɨmɨdman mönö, ha wöta mɨdɨl kɨ wahax pön yöd nɨga. ");
INSERT INTO tmd_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nagö, ‘Nɨ God yad mag akwör cönɨŋö,’ rön nugugu mɨdlö aku, nagö wahax mɨdanö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ilisabet aliö rɨmɨn, Maria God rɨbyöx nugu gɨrön, mɨ ödöriö wahax pɨ gɨrön yadöŋa, “Nɨ Nöbö Diba nugwo rɨbyöx nugwön, ib nuŋwa yadmön, mɨ bɨl sö diöna. ");
INSERT INTO tmd_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","48","Nɨ aŋadö wöröxɨb akuyöbö mɨdmön, God nɨ ögwö yöxön kömö pa aku, nugwo rɨbyöx nugwön mɨ ödöriö wahax pɨmɨdla. Nɨ hör halöu mabö nugwo rɨ nölɨb mö mɨdɨl aku jɨ nɨ uplöböl. Alön ra aku, weik yöxön, mai yöxön, yöxɨp du yöx nɨgöñ akuyöbö, nöbö mö magalɨg nɨ rɨbyöx nugwön yajöña, ‘God mö aku nugwidɨx mɨdɨm mɨd ri abö,’ cöña. ");
INSERT INTO tmd_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Nuŋ ölɨsö magalɨg mɨd aku, nuŋ mɨ ap dib i nɨ ra. Nɨ nugula nuŋ paŋyöbö akwör Nöbö Leia mɨda. ");
INSERT INTO tmd_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nöbö mö mönö nuŋwa nugwön, anau pön, mai diöñ akuyöbö, ñɨgö uliöxön pɨ ösös rɨ ri aböna. Ñɨŋ halöu ha yöxön, yöxɨp duön, yöx nɨgöñ akuyöbö, ñɨgö algör ör uliöxön pɨ ösös cöna. ");
INSERT INTO tmd_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nuŋ Nöbö ölö; nuŋ ap ölɨsö mɨga akwör ra. Nöbö mö, an keir nöbö mö diba mɨdölɨŋö, röi akuyöbö, God ñɨgö rɨbɨx aba. ");
INSERT INTO tmd_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Makwam, kiŋ nöbö dib mögörɨb diba nugwidɨx mɨdɨm ib diba mɨdmɨd bla, God rɨmɨn yau dum, nöbö mö ib mɨdmɨdöl akuyöbö, God ñɨgö pön pɨ bɨl bɨl raŋ, ñɨŋ iba mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nöbö mö kiö pɨl akuyöbö, God ñɨgö ap nuöm nɨgmɨn nɨmmɨdmɨn wöt bɨra. Jɨ nöbö mö ap mɨga mɨd akuyöbö, ñɨgö hör yad abmɨn duöia. ");
INSERT INTO tmd_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","God nuŋ nöso auso maduebö an akuyöbö ñɨgö yadöŋ mönö aku uplöböl, anɨŋ Isrel nöbö mö öim uliöxön nugwidɨx mɨd ri abön ra. ");
INSERT INTO tmd_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Nöso Ebraham aipam, nöso an bli aipam halöu ha ñɨŋ yöxmɨn yöxɨŋ diön akuyöbö, God ñɨgö nugwidɨx mɨjɨnö, rön, rɨg yadöŋ mag akwör an rö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria mönö aku yadön, nobnɨŋ Ilisabet pɨsaŋ röun mös paŋ mɨdön, mai höuöil ram nuŋwa duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mɨdɨp duön, Ilisabet ha yöx pön höŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","God nugwo uliöxön nugwidɨx mɨdmɨn, nuŋ lap röxgön ha yöx pön höŋ aku, nöbö mö haul wöunɨŋ nölöunɨŋ nobnɨŋ nöbö nuŋ akuyöbö nugwön, nuŋ pɨsaŋ mɨ ödöriö wahax pɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ha aku yöx pön hön, wop akuyöbö mɨj sö mɨdön, amñaxɨb sö wopa rɨl uñ nuŋwa ödörɨba hö rɨbmä. Hö rɨbön, ñɨŋ ha aku iba nölɨba rön yadmä, “Ha kɨ, nuö Sekaraia iba röd nölɨb,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Aliö rɨmɨn, nuöma yadöŋa, “Ehöu, ib nuŋwa Jon me cɨnɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Aliö rɨmɨn, nöbö mö nuŋ bla yadmä, “An akuyöbö alöinɨŋ. Nöso nöhönɨŋ wöunɨŋ nöbö akuyöbö ib i Jon mɨdölö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Aliö rön, nuö Sekaraia nugwo imag abön yad nugumä, “Ha ib kai nöinaŋö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Yad nugumɨn, nuö imag abön yadöŋa, “Nɨ köp kai kɨtɨb i pön höi,” röŋa. Yadɨm pön höm, rola kai kɨtön, “Ib nuŋwa Jon,” me röŋa. Ib aliö kɨtmɨn, ñɨŋ nugwön magalɨg aiö waiö rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Makwam wop akwör Sekaraia albeña ömörö röŋ aku womiöxmɨn nugugɨrön, höd mönö rɨg pɨmɨd akwör yad gɨr, God iba yadɨm bɨl sö duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nöbö mö il yöraku hölɨmön mɨdim akuyöbö, alöŋ aku nugwön ipöxön, mönö aku piöx rag du mögörɨb Judia yuadö me blaku magalɨg nöbö mö akuyöbö yad nölmä. ");
INSERT INTO tmd_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Yad nölmɨdmɨn, nöbö mö mönö aku nugwim akuyöbö, ñɨŋ magalɨg rɨb mɨga yöx nugwön yadmä, “God rɨmɨn, ha aku aliö yöx pön hö makwam, mai nöbö pödiöm mɨjönɨŋö?” rɨmä. God ölɨsö ha aku pɨsaŋ mɨdöŋ aku nugwim makwam, aliö yadmä. ");
INSERT INTO tmd_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Inöm Leia nuŋ ha kiaia nuö Sekaraia yuö kwo hön aja wölmɨn nugwön God ib nuŋwa pɨrag wöl gɨr yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“An Isrel nöbö mö, God Nöbö Dib ana ib nuŋwa pɨrag wöl yadɨŋ bɨl sö duaŋ. Nuŋ keir mögörɨb il kɨ hön, nöbö mö nuŋwa wobön höbkal pa. ");
INSERT INTO tmd_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","God Nöbö Diba nuŋ rɨmɨn, Depid yöxɨm yöxɨŋ yöxɨp höuöilmel rɨŋ, ha i yöx pön haŋ anɨŋ kömö pöna. ");
INSERT INTO tmd_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Maduar ör, mönö na nöbö mö akuyöbö yadɨba rɨmɨdlö, rön, God nuŋ nöbö bli mabö aku yad nɨgöŋa. God mönö yadɨb nöbö lei nuŋ akuyöbö ñɨŋ God mönö yadöŋ aku nugwön, nöbö mö akuyöbö ñɨgö yad nölmä. ");
INSERT INTO tmd_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nöbö pɨl nɨmɨb an bla hön, anɨŋ pɨl pal nɨgɨba rɨmɨdöia, jɨ nuŋ hön anɨŋ kömö pöna; nöbö anɨŋ ölɨsö wölɨm rɨb gwogwo yöx nugwöi akuyöbö anɨŋ rɨ gwogwam rɨba rɨmɨdöi aku, jɨ nuŋ anɨŋ nugwidɨx mɨdaŋ kömö dinɨŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","God maduar ör nöso maduebö ana ögwö yöxön, pɨ ri abmɨjɨnö, rön, mönö ölɨsö mɨ bli yad nɨgöŋa. God nuŋ mönö nöso an Ebraham nugwo yad nɨgöŋ aku uplöböl; mönö lei yadöŋ aku, rɨg yadöŋ mag akwör ra. ");
INSERT INTO tmd_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Nöbö Diba anɨŋ nugwidɨx mɨdaŋ, nöbö pɨl nɨmɨb akuyöbö anɨŋ rɨ gwogwam rɨb maga mɨden. Aku makwam, an nöbö pɨl nɨmɨb akuyöbö ipöxöinɨŋ, kömö mɨjnɨŋ makwaim, öim öim Nöbö Dib akwör rɨbyöx nugwön, ap kib mag gwogwo röböxön, Nöbö Diba nöbö mö lei nuŋwa mɨdön, mabö nugwo rɨ gɨr mɨjnɨŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Makwam ha na, nagö God Nöbö Diba mabö nuŋwa raŋ, nöbö mö akuyöbö ñɨŋ nugwön yajöña, ‘God Nöbö Diba ödöriö adöx mɨ bɨl sö mɨd aku, nöbö mönö nuŋwa yadɨba maku,’ me cöña. Aku agapɨm: naŋ höd duön, nöbö mö akuyöbö ñɨgö yad nöl ri abön raŋ, Nöbö Diba nugwo pöx mɨdɨŋ nugugɨrön, nuŋ höna. ");
INSERT INTO tmd_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nagö nöbö mö nuŋ akuyöbö ñɨgö mönö waiö nuŋ aku yad nöl ri abön raŋ, Nöbö Dib ñɨŋ aku hön, ap kib mag gwogwo röi pɨx aku örɨx abön ñɨgö paŋ, mönö waiö aku nugwöña. ");
INSERT INTO tmd_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","God Nöbö höimölɨb mɨda tar mɨdön, nuŋ nöbö mö lɨb pɨlɨm nugwön, mil wä nuŋwa naiö mila röxg adöx yöd röul adö kau sebö hön, anɨŋ mila ab nöiöna. ");
INSERT INTO tmd_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","An nöbö mö yön yön pɨxmag yuö piaku mɨdön wöröxɨba rɨmɨjnɨŋ akuyöbö, nuŋ raŋ mil mag aku madmag yuö an kwo mil ab nölaŋ nugwön, an höbwab höimöl gɨ mɨdɨb ödöi wä aku hölu nugwön, rol akwör yönmɨjnɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Makwam ha kiai Jon aku dib röxmɨn nugugɨrön, inöm nuŋwa alɨg alɨg gö nɨgöŋa. Nuŋ mögörɨb nöbö mö mɨdmɨdölöi, mögörɨb rɨg kap mibɨl piaku mɨd mɨd, aŋadö dib röxön höm, Isrel nöbö mö nugwo nugumä. ");
INSERT INTO tmd_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Makwam wop aku, gapman nöbö dib Sisa Ogastas nuŋ lo nɨgön yadöŋa, “Nöbö mö nɨ nugwidɨx mɨdɨl akuyöbö, ñɨŋ magalɨg ib ñɨŋa pɨŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Höd meme ila nɨgön nöbö mö iba pim wop aku, gapman nöbö dib Kwairinias Siria Propins nöbö mö nugwidɨx mɨdmɨda. ");
INSERT INTO tmd_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Makwam, nöbö mö mögörɨb dib pad piaku hörɨrör hö mɨdim akuyöbö, höuöil mögörɨb ñɨŋa keir iba pɨba dumä. ");
INSERT INTO tmd_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep nuŋ kiŋ Depid hödɨga yöxɨp duön yöxmä aku, nuŋ Depid taun nuŋwa Betlehem duba röŋa. Ha mö Maria nugwo yölɨŋön, Nasaret taun, mögörɨb Galili aku röböxön, dumɨd dumɨd mögörɨb Judia duön, kiŋ Depid nugwo yöxɨm mɨdmɨd taun nuŋwa Betlehem dumä. ");
INSERT INTO tmd_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Jɨ ha mö Maria, Josep pönɨŋö rim makwam, ha wöta alɨg mɨdmɨn nugugɨrön, Josep Maria nugwo yölɨŋön iba pɨba dumä. ");
INSERT INTO tmd_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ñɨŋ Betlehem dumɨdmɨn, Maria ha yöx pön höb wop aku womiöx röxgöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Makwam Betlehem uröpɨnön nugumɨn, rɨg wobön hölɨm mɨdöi ram aku aŋadö cɨcɨ röŋa. Akuyöbö almɨn, hön kau urmɨdöi ram i du mɨdön, Maria ha paŋyöbö ha höd aku yöx pön höŋa. Yöx pön hön ha kiaia ñapñap uñ wobön, pɨ hön sipsip ap absö höböt pɨñ aku röx rag hö nɨgɨm nɨmmɨdöi bɨyöj möla nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Maria Jisas nugwo yöx pön höŋ wop aku, hön sipsip urɨb nöbö akuyöbö bli pɨxmag yuö hön sipsip nugwidɨx mɨdim mögörɨb womiöx il yöraku. ");
INSERT INTO tmd_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nöbö Diba ejol nuŋ i yad abmɨn, Nöbö Dib mil wä mag nuŋwa hön ñɨgö abmɨn nugumɨn, ñɨŋ ölölö rɨmɨn ipöxmä. ");
INSERT INTO tmd_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ñɨŋ ipöxmɨdmɨn nugugɨrön, ejol aku ñɨgö yadöŋa, “Ñɨŋ ipöxmɨjeñ. Nɨ ñɨgö aipam nöbö mö akuyöbö aipam, magalɨg ñɨgö wahax pɨb mönö mag wä i pön höla. ");
INSERT INTO tmd_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Weik ör mö i ha wä mɨdöy yöx pön hö Depid taun nuŋ aku. Ha aku ñɨgö kömö pöna. Nuŋ Krais Nöbö Diba maku. ");
INSERT INTO tmd_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nugwo du hölu nugwön nugwöña, nuöma nugwo ñapñap uñ wobön, pɨ hön sipsip höböt pɨñ röx rag hö nɨgɨm nɨmmɨdöi bɨyöj möl aku nɨgaŋ mɨjöna. Ñɨŋ du nugwɨŋ, rɨg yadmɨdɨl mag akwör rɨg mɨdaŋ, mi yadö, cöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ejol aku aliö rɨmɨn nugugɨrön, rɨb pia ejol adöx yöd röul adö kau sö akuyöbö mɨ mɨg mɨŋa hö ejol hödyöbö aku pɨsaŋ mɨdön, God iba pɨrag wöl gɨrön yadmä, ");
INSERT INTO tmd_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“God ib nuŋwa mɨ bɨl sö mɨda; nuŋ nöbö mö yön yön uliöxön pɨ ösös cön akuyöbö, höbwab höimölɨba rɨb madmag paŋyöbö i nɨgɨb mag aku ñɨŋ pɨsaŋ mɨjönɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ejol bla höbkal adöx yöd röul adö kau sö dum nugugɨrön, nöbö hön sipsip urɨb bla mönö yad nugwob nugwob rön yadmä, “Nöbö Diba an mönö yad aku, wopik Betlehem du nugunɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Aliö rön rɨmgör duön nugumɨn, Josep Maria mönöbeŋö ha kiai yadmä aku, wölɨj wobön, hön sipsip höböt pɨñ ap bla rag hö nɨgɨm nɨmmɨdöi bɨyöj möl aku nɨg gɨm mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ñɨŋ ha kiai aku nugwön, duön, ejol ñɨgö agö mönö bɨlɨm yadim mönö aku, nöbö mö piaku piaku ñɨgö yad nölmä. ");
INSERT INTO tmd_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nöbö hön sipsip uröi bla nöbö mö piaku mönö aku yad nölmɨn, ñɨŋ nugwön magalɨg aiö waiö rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Makwam Maria nuŋ mag keiryöbö röŋ aku, ri abö rön, rɨb wä akwör yöx nugumɨda. ");
INSERT INTO tmd_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nöbö hön sipsip urɨb bla, God ejol nuŋ akuyöbö rɨg yadim akwör rɨmɨn mämäg ñɨŋa keir nugwim makwam, God ib nuŋwa urön pɨ bɨl sö ab gɨrön, hem pia höuöil dumä. ");
INSERT INTO tmd_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Maria ha kiai aku yöx pön hön wop akuyöbö mɨj sö mɨdön, löum amñaxɨb wop aku rɨl uñ nuŋwa ödörɨba rɨmä. Höd ejol aku nuöm Maria nugwo, ha yöx pön hön ib nuŋwa aliö nölö röŋ mag akwör, ib nuŋwa Jisas, me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","Makwam höd Mosɨs nuŋ lo mönö kai kɨtön, ha höd yöx pön höñ akuyöbö God nöinö, röŋa. Mag akuyöbö, Maria ha aku yöx pön hön, Juda nöbö mö rɨg rɨmɨdöi mag akuyöbö, God höjöpalɨb rama höl rön, ram nuŋwa keir piakwör mɨdmɨn, wä rɨmɨn nugugɨrön, Josep pɨsaŋ, Jisas nugwo pön du Nöbö Dib nölɨba, God höjöpalɨb ram Jerusalem pön dumä. ");
INSERT INTO tmd_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Makwam Nöbö Diba lo mönö i kwo yada, “Mö ha yöx pön höñ bla wä raŋ, yöur malɨg mönö yöur döpwö mös rag hön, God höjöpalɨb rama rɨŋadö du mɨdön, pal God höjöpal ur nölön aku, aŋadö wä rö, rön, God höjöpalɨb rama ram möl yuadö diöñɨŋö,” rɨmä. Rɨb aku aipam yöx nugwön mönö, yöur mös alɨg pɨrag dumä. ");
INSERT INTO tmd_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Makwam Jerusalem yöra nöbö wä ödöriö i mɨdmɨda, ib nuŋwa Simion. Nöbö aku nuŋ God Mönö aku nugwön, rɨg yad mag akwör rɨmɨdöŋa. Inöm Leia nuŋ Simion pɨsaŋ mɨdöŋa; nuŋ Krais aku Isrel nöbö mö kömö pönɨŋö, rön, pöx mɨdmɨda. ");
INSERT INTO tmd_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Inöm Leia nuŋ Simion nugwo höd yadöŋa, “Nöbö Diba nuŋ Krais nugwo yad abaŋ haŋ mönö, naŋ mämäga nugwön mai wöröxnaŋö,” röŋa nugwön nuŋ nugugu mɨdmɨda. ");
INSERT INTO tmd_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Makwam wop aku, Inöma nuŋ Simion nugwo rɨbyöx nölmɨn, God höjöpalɨb rama duön nugumɨn, Josep mönöbö hogwa Jisas nugwo pön duön, lo mönö rɨg yadöŋ mag akuyöbö cɨnɨŋö, rön, hö mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simion ñɨgö mönöbö nugwön, Jisas nugwo pɨ wobön, God ib nuŋwa pɨrag wöl gɨrön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Naŋ paŋyöbö akwör Nöbö Dib. Ha kiai mɨdö kɨ dib röxön, anɨŋ nöbö mö kömö pön aku, höd nɨ yadmö mag akuyöbö, wopik mämäg na keir mödö nugumɨdla. Makwam, wopik nɨ röböxan wä raŋ nugugɨrön wöröxnöm. ");
INSERT INTO tmd_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ha kiai mɨdö kɨ, nöbö mö mögörɨb adadö piaku piaku magalɨg pɨ nagö pɨsaŋ nɨgiö paŋör nɨgöna. ");
INSERT INTO tmd_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nuŋ mil wä röxg hön, Juda nöbö mö yöi akuyöbö ñɨgö mila ab nölaŋ, God nöbö pödiöm mɨd aku nugwöña. Nuŋ mil mag wä keiryöbö nagö pön hön, Isrel nöbö mö nagö akuyöbö ñɨgö mila ab nöiönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simion Jisas nugwo mönö aku yadmɨn aku nugwön, Josep mönöbö hogwa aiö waiö rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Makwam Simion nuŋ Josep, Maria, Jisas nuömarö nöbö ñɨgö, “God ñɨgö nugwidɨx mɨdaŋ,” me rön, Jisas nuöm Maria nugwo yadöŋa, “Ha kɨ mɨdaŋ nugugɨrön, mögörɨb Isrel yuadö mɨdöi nöbö mö mɨga pɨ asɨx hörɨrör nɨgön, ödöi gwogwo bör diöñ bla pɨn bɨcöña; ödöi waiö bör diöñ bla God adö diöña. God Isrel nöbö mö nugwɨŋ, me rön, ha kɨ agal aba aku, jɨ nöbö mö bli nugwo pölön yad höimöuöña. ");
INSERT INTO tmd_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Aliö alɨŋ, nöbö mö mɨga akwör agö rɨb bɨlɨm yöx nugumɨdöi aku, nöbö mö piaku wöxnö nugwöña. Makwam yu mɨxɨl ölɨsö mei madmag nagö kwo pɨ nɨg mɨjönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Makwam wop akwör, God mönö yadɨb mö i hö mɨdöŋa, ib nuŋwa Ana. Nuö iba Panuel. Panuel aku, Asa yöxmɨn yöxɨp u yöxɨp hön yöxmä. Nuŋ lap nom ödöriö. Höd ha mö nöbö pön, nöbönɨŋ pɨsaŋ mɨdmɨn kɨm akuyöbö mɨj sö yönöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Nöbönɨŋa wöröxöŋa jɨ Ana kɨm nuŋwa padokwo padök mös paŋ höuöiliö hö pɨn du adokwebö mac kwo (84) yönöŋa. Nuŋ God paŋyöbö akwör rɨbyöx nugwön wop bli ap mag nɨmölöŋ, nuŋ God höjöpalɨb rama du mɨdön, mil pɨxmag yuö God höjöpal gɨr mɨdmɨda. ");
INSERT INTO tmd_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Jɨ mö Ana aku, mag akwör Jisas pɨ gɨ mɨdim il yöra hön, God nugwo ri ablaŋe rön, nöbö mö ñɨŋ, Nöbö Diba hön Jerusalem nöbö mö nag mɨdim aku yauönɨŋö, rön, pöx mɨdmɨdöi nöbö mö akuyöbö ñɨgö yadön, ha kiai aku agap apɨm cön akuyöbö, mönö yad nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josep mönöbö hogwa Nöbö Diba lo mönö yadöŋ mag akuyöbö magalɨg rɨ pörön, ñɨŋ höbkal mögörɨb Galili duön, taun ñɨŋa Nasaret dumä. ");
INSERT INTO tmd_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Du mɨdɨm Jisas dib röxön, God nugwo nugwidɨx mɨd ri abmɨn nugugɨrön, rɨb wä ödöriö yöx nugwön mɨd ri aböŋa. ");
INSERT INTO tmd_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Pasopa wop dib aku womiöx höm, Jisas nuö nuöm kɨm aku kɨm aku, Pasopa wop dib aku wopik, me rön, du Jerusalem dumɨdöia. ");
INSERT INTO tmd_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Aliö alɨm, Jisas kɨm nuŋwa yöniö möl sö pɨnmɨn, Juda ada rɨg röi mag akuyöbö, nuö nuöm nugwo yölɨŋön Pasopa ap nɨmɨba Jerusalem du mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Wop dib aku hö padɨxmɨn nugugɨrön, rama dumɨdölɨŋö, rön, höbkal du ödöi mibɨl yöra duön nugumɨn, Jisas pɨsaŋ hömɨdölöŋ. Nuŋ Jerusalem ör mɨdöŋa jɨ ñɨŋ nugwölim. ");
INSERT INTO tmd_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nuŋ nöbö mö bli pɨsaŋ hömɨdö, rön, rɨbyöx nugumä. Jɨ ödöi mibɨl yöra hölɨmba rön, du haul hödpɨg nöbö nuŋ bli pɨsaŋ mɨdö, rön, nugwo hölu nugumä. ");
INSERT INTO tmd_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Hölu nugup du yualöbön, höbkal Jerusalem ha hölu nuguba dumä. ");
INSERT INTO tmd_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Duön wop mös höluön paŋ wopa nugumɨn, nuŋ duön God höjöpalɨb rama ram möl yuadö mɨdön, lo mönö yad nölɨb nöbö piaku pɨsaŋ römɨd gɨ mɨdön, mönö yadmɨdim aku nugwön, mönö bli yad nugumɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nöbö mö nugugu mɨdim akuyöbö, Jisas yadöŋ akuyöbö nugwön, ha aku rɨbyöx nugw ri abön mönö wä yadmɨd aku, me rön, aiö waiö rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Makwam nuö nuöm mönöbö Jisas nugwo nugwön ñɨŋ algör ör aiö rɨmä. Nuöma Jisas yadöŋa, “Naŋ nauö an pödpöd rɨmɨn mag akuyöbö ailö? Madmag ana ölɨŋ pɨlmɨn nugugɨrön nagö hölu nugw yönmɨdölɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nuöma aliö rɨmɨn, Jisas yadöŋa, “Ñɨŋ pödpöd rɨmɨn nɨ hölu yönmɨdöi? Acö rama du mɨdɨl aku ñɨŋ nugwölöiŋ ä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Jisas aliö röŋ aku, jɨ ñɨŋ mönö rɨg yadmɨd aku, me rön, röx nugwölim. ");
INSERT INTO tmd_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jisas nugwo yölɨŋön ram ñɨŋa Nasaret höuöil dumä. Jisas piakwör mɨdön, nuö nuöm rɨg yadmɨdöi ma akwör mai duön rɨmɨdöŋa. Makwam nuöm Maria Jisas agap bɨlɨm rɨmɨd aku rɨbyöx nugu gör mɨdmɨda. ");
INSERT INTO tmd_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisas nuö nuöm pɨsaŋ mɨdön, dib röxön rɨbyöx nugw ri abön rɨmɨn nugugɨrön, God aipam, nöbö mö aipam nugwo nugumɨn wä röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Rom gapman nöbö dib ödöriö Sisa Taibirias mögörɨb piaku piaku nugwidɨx mɨdmɨda kɨma akuyöbö yöniö pɨnöŋ mac adokwebö kwo (15). Makwam nuŋ pad piaku mɨdön, nöbö nugwidɨx mɨdɨb höglöm yöbö nuŋ bli yad nɨgmɨn, du mögörɨb bli nugwidɨx mɨdmɨdöia. Nöbö nuŋ Podias Pailot mögörɨb Judia nöbö mö akuyöbö nugwidɨx mɨdmɨda. Nöbö nuŋwa Herod mögörɨb Galili nöbö mö akuyöbö nugwidɨx mɨdmɨda. Herod pɨgnɨŋ nuŋwa Pilip mögörɨb Iduria nöbö mö akuyöbö aipam, mögörɨb Trakonaitis nöbö mö akuyöbö aipam nugwidɨx mɨdmɨda. Nöbö nuŋwa Laisenias mögörɨb Abilini nöbö mö akuyöbö nugwidɨx mɨdmɨda. ");
INSERT INTO tmd_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Makwam wop aku, nöbö nagö Anas Kaiapas yöŋö, God ap höjöpal ur nölɨb nöbö dib ödöriö hogwa Jerusalem mɨdmɨdöia. Makwam wop mibɨl yöraku, Sekaraia ha nuŋwa Jon, nöbö mö mɨga mɨdmɨdölöi, mögörɨb rɨg kap mibɨl piaku hölɨmön mɨdmɨda. Mibɨl piaku hölɨmön mɨdmɨn nugugɨrön, God nuŋ Jon nugwo rɨba nölmɨn, ");
INSERT INTO tmd_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","mögörɨb röbö Jodan yuö pö piaku yönmɨdmɨn nugwön nöbö mö akuyöbö höm, ñɨgö mönö yad nölmɨdöŋa, “Ap kib mag gwogwo röi aku, pödpöd rɨmɨn aliö alölɨŋö, rön, röböxön nɨ höŋ, nɨ ñɨgö röbö pal nölmön, God ap kib mag gwogwo röi bla nugwön röböxaŋ,” me rɨmɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jon ñɨgö mönö yad nölmɨdöŋ aku, God mönö yadɨb nöbö Aisaia maduar ör rɨg cönɨŋö, rön, kai kɨtöŋ mag akwör röŋa. Aisaia mönö aku kai kɨtön yadöŋa, “Nöbö i, mögörɨb nöbö mö mɨga mɨdölöi, mögörɨb rɨg kap mibɨl yöra du mɨdön, wö rön yajöna, ‘Nöbö Dib aku hömɨdö, rön, nugwo pöx mɨjöña! Makwam, ödöi höña pisö pibö rɨg mɨjön piaku, pɨd kwol pɨlɨx rɨg mɨjön piaku, pɨn wödön ri abön ösös rɨ gɨr mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Makwam, mögö up röx möl bla pɨn wöd ri abön, pɨd bla pɨn wöd ösös rɨ ri abön, ödöi um nɨgön cön yör bla, paxdöriö röbön, rɨg bla pa abön rɨ ri abmɨjöña. ");
INSERT INTO tmd_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Makwam akuyöbö aiöñ aku, nöbö mö bla magalɨg nugwöña, God nuŋ mag pödiöm rön ñɨgö kömö pönɨŋö,’ cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jon nuŋ Aisaia kai kɨtöŋ mönö akuyöbö yad nölɨm nugugɨrön, nöbö mö mɨga akwör nuŋ mɨdöŋ yöra hön yadmä, “Anɨŋ röbö pal nölö,” rɨmä. Jon ñɨgö yadyöxön yadöŋa, “Ñɨŋ kas halöu ha kɨyöbö! Agö rɨbɨm yöxön bör hömɨdöi? ‘Röbö palɨŋ, God nöbö mö bli ñɨgö yadyöxön cön wop aku, an yadyöxölaŋ,’ me rön, bör hömɨdöi ä? ");
INSERT INTO tmd_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ñɨŋ röbö yaxnöb cöñ aku, ap kib mag gwogwo röi aku, pödpöd rɨmɨn aliö alölɨŋö, rön, röböxön tar mɨd ri aböña. Akuyöbö alɨŋ mönö, nöbö mö nugwöña, ñɨŋ ap kib mag gwogwo rɨmɨdöi mag akuyöbö röböxöia. Jɨ ñɨŋ rɨb i yöx nugwöña, ‘An nöso maduebö Ebraham halöu ha nuŋwa mɨdölɨŋö,’ rön, rɨb aku yöx nugumɨjeñ. An Ebraham halöu ha nuŋ me röi aku hör ap! God rɨg bɨlɨk pön, Ebraham halöu ha nuŋ akuyöbö rɨ nɨgɨnö, rön, rɨ nɨgöna! ");
INSERT INTO tmd_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nugw ri abi! God bɨ aku ila alɨg römalɨba, yu aku bɨ ila mämäl gɨ mɨda. Bɨ i mag nɨmɨb wä bli yaxen aku, römaxdörön pɨ rɨn yön mɨd möl bö abönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jon mönö aliö akuyöbö yadmɨn, ñɨŋ nugwo paiŋö yad nugwön yadmä, “An pödpöd rɨŋ, me rön, aliö yadmɨdlaŋö?” rɨmä. Aliö rɨmɨn, Jon ñɨgö yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","“Nöbö mö ap uñ mös mɨjön aku, i nöbö mö ap uñ mɨden akuyöbö nölɨŋ. Nöbö mö ap mag mɨga mɨjön aku, nöbö mö ap mag mɨden akuyöbö ñɨgö bli nuöm nɨg nölɨŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Makwam takis pɨb nöbö bla, Jon anɨŋ röbö pal nölaŋ, me rön, hön nugwo yad nugwön yadmä, “Mönö yad nölɨb nöbö, an pödpöd cɨnɨŋ?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Aliö rɨmɨn, ñɨgö yadöŋa, “Takis aku pɨba rön, gapman rɨg yadöi akwör pöña. Hör um bli kwo pɨmɨjeñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Makwam ami nöbö bli Jon nugwo mönö paŋ aliar yad nugwön yadmä, “An pöd cɨnɨŋ?” rɨmä. Aliö rɨmɨn, ñɨgö yadöŋa, “Ñɨŋ inakmönö hör yadön nöbö mö bla rɨg ap ñɨŋ kib pɨmɨjeñ. Inakmönö hör yadön nöbö mö bla mönö diba yadmɨjeñ. Mabö pe pöñ aku i kwo pɨnɨŋö, rön, rɨb aku yöx nugumɨjeñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Makwam akuyöbö alön mɨdɨp duön nöbö mö akuyöbö rɨb adö i nugwön yadmä, “Nöbö kɨ Krais öim pöx mɨdmɨdöl akuyöbö röxgö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Aliö rɨmɨdmɨn, nuŋ mönö aku nugwön ñɨgö paiŋö yadöŋa, “Ehöu! Nɨ ñɨgö hör röbö akwör pal nölmɨdla, jɨ nɨ mai hön nöbö aku, nuŋ nɨ röxgɨb yöi; nuŋ nöbö dib ödöriö, nɨ nöbö ulmɨdö. Nɨ nugwo nugwön möigw yöxöna. Yam uñ nuŋ aku naga pɨ yaub maga nɨgölö,” röŋa. Nöbö aku nuŋ hön, ñɨgö Inöm Lei akwör pal nölön, rɨn pina pal nölön, cöna. ");
INSERT INTO tmd_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","“Nuŋ wit maga göj waŋ, ödör pön hö palpatöi mag akuyöbö cöna. Wit mag nɨmɨb bla keir nɨgön, wit yöj rɨb rɨb bla keir nɨgön, cöna. Akuyöbö alön, wit mag nɨmɨb bla rag pön du ram möl yuadö nuŋwa nɨgöna, jɨ rɨb rɨb akuyöbö rag du bɨ yuö öim yönmɨd möla wiönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon, nöbö mö akuyöbö ñɨgö God mönö wä aku bli alɨg yad nölmön nugw ri abɨŋ, me rön, ñɨgö mönö wä akuyöbö ulul i yadmɨdöl. ");
INSERT INTO tmd_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Makwam gapman nöbö dib Herod, ap kib mag gwogwo piaku rɨp duön, mai pɨgnɨŋ Pilip mönɨŋ nuŋwa Herodias nugwo pɨsaŋ yönmɨn, Jon nuŋ aku mag wä rölö, röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Jon mönö aku aliö rɨmɨn, Herod nugwön, mag gwogwo i kwo aipam rön, Jon nugwo pön du nag nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Makwam Herod Jon nugwo nag nɨgölöŋ wop aku, nuŋ nöbö mö piaku ñɨgö röbö pal nölmɨda. Jisas nugwo wobiö röbö pal nölöŋa. Jisas nugwo röbö pal nölmɨn, nuŋ Nuö God höjöpal mɨdmɨn nugugɨrön, adöx yöd röul adö kau sö uba rödmɨn, Inöm Leia yöur döpwö röxgön bɨbɨ rɨ Jisas höŋa. Aliö höm nugugɨrön, mönö i adöx yöd röul adö kau sebö yadöŋa, “Nagö Ha madmag yöbö nɨ ödöriö. Nagö nugumön, nɨ mɨ wä rö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Makwam Jisas kɨm nuŋ akuyöbö padokwo paŋyöbö i höuöiliö hö wölu mɨj sö (30) yönmɨn nugugɨrön, nuŋ ila nɨgön nöbö mö God Mönö maga yad nölöŋa. Nöbö mö piaku Jisas nuö nuŋwa Josep, me rön rɨbyöx nugumä. Josep nuö nuŋwa Heli. ");
INSERT INTO tmd_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli nuö nuŋwa Matat. Matat nuö nuŋwa Lipai. Lipai nuö nuŋwa Melkai. Melkai nuö nuŋwa Janai. Janai nuö nuŋwa Josep. ");
INSERT INTO tmd_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep nuö nuŋwa Matataias. Matataias nuö nuŋwa Emos. Emos nuö nuŋwa Neham. Neham nuö nuŋwa Esli. Esli nuö nuŋwa Nagai. ");
INSERT INTO tmd_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai nuö nuŋwa Meat. Meat nuö nuŋwa Matataias. Matataias nuö nuŋwa Semein. Semein nuö nuŋwa Josek. Josek nuö nuŋwa Joda. ");
INSERT INTO tmd_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda nuö nuŋwa Joanan. Joanan nuö nuŋwa Resa. Resa nuö nuŋwa Serababel. Serababel nuö nuŋwa Sialtiel. Sialtiel nuö nuŋwa Nerai. ");
INSERT INTO tmd_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerai nuö nuŋwa Melkai. Melkai nuö nuŋwa Adai. Adai nuö nuŋwa Kosam. Kosam nuö nuŋwa Elmadam. Elmadam nuö nuŋwa Er. ");
INSERT INTO tmd_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er nuö nuŋwa Josua. Josua nuö nuŋwa Eliesa. Eliesa nuö nuŋwa Jorim. Jorim nuö nuŋwa Matat. Matat nuö nuŋwa Lipai. ");
INSERT INTO tmd_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lipai nuö nuŋwa Simion. Simion nuö nuŋwa Juda. Juda nuö nuŋwa Josep. Josep nuö nuŋwa Jonam. Jonam nuö nuŋwa Eliakim. ");
INSERT INTO tmd_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim nuö nuŋwa Melea. Melea nuö nuŋwa Mena. Mena nuö nuŋwa Matata. Matata nuö nuŋwa Natam. Natam nuö nuŋwa Depid. ");
INSERT INTO tmd_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Depid nuö nuŋwa Jesi. Jesi nuö nuŋwa Obed. Obed nuö nuŋwa Boas. Boas nuö nuŋwa Salmon. Salmon nuö nuŋwa Nason. ");
INSERT INTO tmd_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason nuö nuŋwa Aminadap. Aminadap nuö nuŋwa Admin. Admin nuö nuŋwa Arni. Arni nuö nuŋwa Hesron. Hesron nuö nuŋwa Peres. Peres nuö nuŋwa Juda. ");
INSERT INTO tmd_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda nuö nuŋwa Jekop. Jekop nuö nuŋwa Aisak. Aisak nuö nuŋwa Ebraham. Ebraham nuö nuŋwa Tera. Tera nuö nuŋwa Nahor. Nahor nuö nuŋwa Seruk. ");
INSERT INTO tmd_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Seruk nuö nuŋwa Rehu. Rehu nuö nuŋwa Pelek. Pelek nuö nuŋwa Eber. Eber nuö nuŋwa Sela. ");
INSERT INTO tmd_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela nuö nuŋwa Kenam. Kenam nuö nuŋwa Apaksad. Apaksad nuö nuŋwa Sem. Sem nuö nuŋwa Noa. Noa nuö nuŋwa Lemek. ");
INSERT INTO tmd_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemek nuö nuŋwa Metusela. Metusela nuö nuŋwa Inok. Inok nuö nuŋwa Jaret. Jaret nuö nuŋwa Malelael. Malelael nuö nuŋwa Kenan. ");
INSERT INTO tmd_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan nuö nuŋwa Inos. Inos nuö nuŋwa Set. Set nuö nuŋwa Adam. Adam nuö nuŋwa God. ");
INSERT INTO tmd_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Inöm Leia nuŋ Jisas nugwo aja wölön, nugwo yölɨŋön röbö Jodan yuö piaku pön dum, Jisas mögörɨb nöbö mö mɨdmɨdölöi, mögörɨb rɨg kap mibɨl piaku mɨdöŋa. Kɨjaki nuŋ Jisas ap kib mag gwogwo mag bli cönɨŋönö wöhö rɨ nugu gɨrön rɨ rɨp du wöhö nugwön, wop akuyöbö padokwo padök paŋyöbö i höuöiliö hö pɨn du adokwebö mɨj bö (40) duöŋa. Jisas ap mag nɨmölöŋ wöhö, nuŋ kiö diba pɨlöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Jisas nuŋ kiö diba pɨlmɨn, kɨjaki yadöŋa, “Nagö ‘God Ha nuŋwa mɨdlö,’ rɨlö aku, rɨg pik yadaŋ bred nɨgaŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Aliö rɨmɨn, Jisas paiŋö yadöŋa, “God Mönö aku kai kɨtön yadmä, ‘Nöbö mö akuyöbö bred akwör nɨmön kömö mɨdeñɨŋö,’ röiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Jisas aliö rɨmɨn, kɨjaki Jisas nugwo pön önöŋ pɨd dib i wölu pɨd sö, mögörɨb wä wä kiŋ hörɨrör nugwidɨx mɨdöi bla magalɨg wop akwör Jisas nugwo yabuön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","“Mögörɨb wä wä pik nugwö! Nöbö mö hörɨrör nugwidɨx mɨdöia. Nɨ mögörɨb piaku magalɨg nugwidɨx mɨdɨl aku, nöbö i nugwo aŋö yajnöb yajɨna. Makwam, nagö nɨ höxmax yuön höjöpal mɨjɨnö aku, mögörɨb pi bɨlɨk magalɨg naŋ yadmön, naŋ nugwidɨx mɨjnaŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Aliö rɨmɨn, Jisas paiŋö yadöŋa, “God Mönö aku kai kɨtön yadmä, ‘God Nöbö Dib ñɨŋ aku rɨg yad mag akwör rön, ib nuŋ akwör yadɨŋ bɨl sö duaŋ,’ me röiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jisas aliö rɨmɨn, kɨjaki Jisas nugwo yölɨŋön Jerusalem duön, pön God höjöpalɨb rama mɨ bɨl sö ur nɨgim rola wöluön yadöŋa, “Nagö, ‘God Ha nuŋwa mɨdlö,’ rɨlö aku, mämäliö mɨgrö il bö pɨñɨrö. ");
INSERT INTO tmd_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","God Mönö aku kai kɨtön yadmä, ‘God ejol nuŋ bla yadaŋ, nagö nugwidɨx mɨjöña. Gupɨn pal wödɨba rɨmɨjɨnö aku, imag ñɨŋa nagö bɨl yöra pöña nugwön rɨg i yamsö nagö aku pɨnenɨŋö,’ röiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Kɨjaki aliö rɨmɨn, Jisas paiŋö yadöŋa, “God Mönö aku mönö bli kwo kai kɨtön yadmä, ‘God Nöbö Dib aku, nuŋ nöbö mi yadɨb mönö inakmönö hörɨb nöböm, me rön yadmɨjeñɨŋe,’ röiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kɨjaki Jisas nugwo inakmönö hörön yadɨp du wöhö nugwön, röböx dinö, rön, rɨb nuŋ akwör yöx nugwöŋa, “Wopik ör yöi möm jɨ mai wop bli hön mönö bli iswob inakmönö hörön yad nugunö,” rön, röböx duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Makwam God Inöma Jisas nugwo ölɨsö nölmɨn, Jisas nuŋ höbkal hön mögörɨb Galili mɨdmɨn nugugɨrön, nöbö mö akuyöbö, mönö nuŋ aku nugwön, mögörɨb Galili yuadö akuyöbö magalɨg pön dumä. ");
INSERT INTO tmd_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nuŋ Juda mögum rɨb ram bla duön, mönö yad nöl ri abmɨdmɨn, nöbö mö bla nuŋ nöbö wä mödöm, me rön, mɨ ödöriö wahax pɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Makwam Jisas nuŋ mögörɨb Galili yuadö piaku rɨp yön pörön, Nasaret du mɨdöŋa. Taun aku nuŋ höd mɨdön dib röxgöŋa. Juda God höjöpalɨb wop ñɨŋ aku höm, nuŋ öim rɨg rɨmɨd mag akwör, mögum rɨb ram aku duön, öbɨlön God Mönö maga nugw yadɨba rɨmɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nöbö God mönö yadɨb Aisaia kai kɨtöŋ köp aku nugwo rag hö nölmɨn, nuŋ pɨ begulön, yadɨba rɨmɨdöŋ mönö rɨb aku nugw yadön ñɨgö yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Nöbö Dib aku nɨ, mabö na rane, rön, Inöm nuŋwa agal abmɨn nɨ pɨsaŋ mɨda. Makwam, nöbö mö lɨblɨb rɨ mɨdö bla ñɨgö mönö wä aku yad nölmön, nugw ri aböña. Kɨlabɨs nöbö mö röxg mɨdöi bla ñɨgö naga yau abmön, kömö diöña. Nöbö mö mämäg we röxg mɨdöi bla ñɨgö rɨmön, mämäga ix nugwöña. Nöbö mö rɨ öliöx mɨdöi bla ñɨgö pɨ ösös rɨmön, mɨd ri aböña. ");
INSERT INTO tmd_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Makwam, Nöbö Diba nöbö mö pön wop wä aku weik hö, rön, nöbö mö bla ñɨgö yad nöinö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jisas mönö kɨtɨb aku nugw yad pörön, köp mɨdö aku pɨ wobön, nöbö köp nugwidɨx mɨdmɨd aku nugwo höbkal nölön römɨdɨm nugugɨrön, nöbö mö mögum rɨb ram möl yuadö mɨdim akuyöbö magalɨg mämäga rödön nugwo riö nugw nugumä. ");
INSERT INTO tmd_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Aliö nugw mɨdmɨn, Jisas ñɨgö yadöŋa, “God Mönö rɨb aku pɨ nugw yadmön ñɨgö nugwöi aku, wopik kwo paŋ mag akwör rö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Aliö rɨmɨn, mönö wä mɨda yadöŋ aku nugwön, nöbö mö nugwo wahax pön, aiö waiö rɨmä. Makwam rɨb i yöxön, “Nöbö kɨ Josep ha nuŋ akwör mönö?” rön, aiö waiö rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Aliö rɨmɨn, Jisas ñɨgö yadöŋa, “Makwam nɨ nugula, nɨ yajöña, ‘Nagö uj wobɨb nöbö, nagö keir raŋ ap naŋ keir rɨ aku kömö nɨgöna. Naŋ taun ulmɨdö Kapaneam du mɨdön, ap rölɨbä mag cɨmala aliö rɨman, ap keiryöbö wöxnö nɨgɨm nugwöl akuyöbö, weik mögörɨb naŋ keir yörɨk aipam raŋ nuguŋö,’ cöña. ");
INSERT INTO tmd_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Makwam ñɨgö mi yadmɨdla, God mönö yadɨb nöbö bla, mögörɨb hör piaku duön, mönö wä aku yadɨŋ, mi yadmɨdöiŋö, rön, nugw pöña. Makwam mögörɨb ñɨŋa keira hön yadmɨn, nöbö an bla keir yadmɨdöiŋö, rön, mönö ñɨŋa peñɨm. ");
INSERT INTO tmd_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Makwam nugwi! Nöbö God mönö yadɨb Ilaija mɨdöŋ wop aku, lap wösrö mɨga Isrel yöraku mɨdmɨdöia. Kɨm mös paŋ röun akuyöbö iŋösu sö aku, ruö pɨlölmɨn, ap maga mɨdölmɨn, mɨ kiö diba wöröxmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Isrel yöraku lap wösrö mɨga kiö wöröxmɨdmä aku, jɨ God Ilaija nugwo agal abmɨn, du taun ulmɨdö Sarepat mögörɨb taun dib Saidon il yöra duön, ap rölɨbä akuyöbö rɨmɨn, lap i ap mag nuŋwa mɨga akwör mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Makwam mag akuyöbö, mai God mönö yadɨb nöbö Ilaisa mɨdöŋ wop aku, Isrel nöbö mö ucrapö nɨgöŋ akuyöbö mɨga akwör yöraku mɨdmä aku, jɨ ñɨgö bli rɨmɨn kömö nɨgölöŋ; Ilaisa nöbö Neman mögörɨb pad dib Siria yöbö nöbö akwör rɨmɨn, kömö nɨgö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jisas aliö rɨmɨn, Juda nöbö mö mögum rɨb ram möl yuadö mɨdim bla nugumɨn, ölɨsö diba wölɨm, ");
INSERT INTO tmd_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","30","nugwo höjup du rɨgaja abɨŋ wöröxaŋ, me rön, höjup dumä, jɨ Jisas nuŋ höuöilön mibɨl ñɨŋ aku duön duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jisas taun ulmɨdö Kapaneam, mögörɨb Galili yuadö du mɨdön, Juda ada God höjöpalɨb wop aku nöbö mö ñɨgö mönö yad nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Jisas God Mönö mɨ ususör rön paxdöriar yadmɨn, ñɨŋ nugwön aiö waiö rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Makwam Juda mögum rɨb ram möl yuadö aku, nöbö ragwo as öim nɨgöŋ i mɨdöŋa. Nuŋ ajmöla aj halön wö diba rön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Jisas nöbö Nasaret yöbö! Nagö pödpöd rɨba hölö? Anɨŋ rɨ ajö nɨgɨba hölanö ä? Nɨ nagö nugula. God Nöbö Lei nuŋ akwör hölaŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Makwam Jisas ragwo as yuö wöl gɨ mɨdöŋ aku nugwo yadyöxön yadöŋa, “Mönö pɨmɨjɨnö! Nöbö aku röböxön röu duö!” röŋa. Jisas aliö rɨmɨn, ragwo as röu du gɨrön nöbö aku nugwo, nöbö mö mɨdim mibɨl yöra pal wöd abön duöŋa. Jɨ nugwo mɨ göj palölöŋ; kömö duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Almɨn, nöbö mö nugugu mɨdim bla ñɨŋa keir yad nugwob nugwob rön yadmä, “Nöbö ölö kɨ, mönö aku pikai yöbö pön hön yadmɨn, ragwo as bla röu duöiŋö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Makwam Jisas alöŋ mönö aku mögörɨb piaku magalɨg pön dumä. ");
INSERT INTO tmd_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Makwam Jisas Juda mögum rɨb rama röböxön Saimon rama duöŋa. Saimon nɨmemö nuŋ aku ap rɨmɨn, mɨxɨñ nuŋ bla magalɨg rɨn röxg yönmɨn, nöbö mö bla hön Jisas nugwo yadmä, “Hane, nagö Saimon nɨmemö nugwo raŋ öbɨl duaŋ,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Aliö rɨmɨn, nuŋ mö ap rɨmɨn wöröxmɨdöŋ aku il yöra hön, ap rɨmɨdöŋ aku yadyöxmɨn nugugɨrön, mag akwör nugwo röböx duöŋa. Nugwo kömö nɨgmɨn, öbɨlön, nöbö mö hö mɨdim akuyöbö ñɨgö ap mag röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nöbö mö yöraku mɨdim bla, mönö aku nugwön, naiö rödɨp duöŋ mag aku, nöbö mö ñɨŋ wöj pɨlɨm mɨdim bla magalɨg pön Jisas mɨdöŋ yöra pön hömä. Pön hömɨdmɨn, Jisas ñɨgö paŋ paŋ pɨ nugumɨn kömö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nöbö mö ragwo as bla yuö wöl mɨdöŋ bla yad abmɨn, röu du gɨrön wö diba rön yadmä, “Nagö God Ha nuŋ aku!” me rɨmä. Ñɨŋ Jisas nuŋ Krais aku nugwön aliö rɨmɨdmɨn nugwön, Jisas nuŋ ñɨgö yadyöxön yadöŋa, “Mönö pɨmɨjeñɨŋö,” rɨmɨn, rɨg yadöŋ akuyöbö nugumä. ");
INSERT INTO tmd_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Löum yöbö pɨxmag alɨg, Jisas mögörɨb aku röböxön, hör du mɨjɨnöm, rön, hör ki mögörɨb ör piaku duöŋa. Dumɨn nugwön nöbö mö bla mai duön, nugwo hölu nugwön yadmä, “Piaku dumɨjɨnö; an pɨsaŋ mɨdɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Aliö rɨmɨdmɨn, Jisas yadöŋa, “God nɨ yad abmɨn höm aku, duön nöbö mö hör möl bli ñɨgö aipam algör God nöbö mö pön nugwidɨx mɨdɨb mönö wä aku yad nöinö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Aliö rön, Jisas nuŋ Juda nöbö mö mögörɨb ñɨŋ bla magalɨg rɨp yön gɨrön, du Juda mögum rɨb ram bla duön, mönö wä aku ñɨŋ yad nölmɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jisas wop i du Ban Yuö Genesaret pö yöra mɨdön, God Mönö aku yad nölɨm nugugɨrön, nöbö mö mɨga mönö wä aku nugunɨŋö, rön, bli bli röb wödemɨl rɨp hömä. ");
INSERT INTO tmd_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Aliö alɨp hömɨn nugugɨrön, Jisas nugwöŋa, nöbö dölöm pɨb bla bɨyöj mös rag hö ban yuörɨb yöraku nɨgön, dölöm pɨb uben bla äbäd gɨr mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jisas nuŋ Saimon bɨyöj rol aku mämäliö rola pɨñɨrön yadöŋa, “Nɨ pɨraiu ususör raŋ, ban yuö mibɨl womiöx yörkwo dinö,” röŋa. Aliö rɨmɨn, Saimon bɨyöja aku pɨraiu ususör rɨmɨn, Jisas ban yuö mibɨl yörakwo duön, bɨyöj rol aku römɨd gɨ mɨdön, nöbö mö bla ñɨgö mönö yad nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mönö yad pörön, Jisas Saimon nugwo yadöŋa, “Bɨyöj kɨ röbö panö rol kwo i kwo du ban yuö mibɨl yörkwo duön, ubena abön dölöm pi,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Aliö rɨmɨn, Saimon paiŋö yadöŋa, “Nöbö Dib, weik pɨxmag yuö bö an dölöm hölu nugw yön mɨdɨm yön mɨdɨm, ruö alɨg löum mil pöra, jɨ an dölöm bli pölöl. Makwam nagö aliö rɨlö aku, uben aku amɨn ab nugunö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Aliö rön, ñɨŋ ubena pɨ abɨm nugugɨrön, dölöm mɨga uben möla aja wölɨm, ubena mɨñ ödörɨbä maga röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Akuyöbö almɨn nugwön, nɨmam nöbö bɨyöj rol i mɨdmä akuyöbö ñɨgö iŋ haxmɨn, ñɨŋ hön dölöm piaku pön, bɨyöj hogw aku nɨgɨm, mɨ aŋadö aja wölön, bɨyöj hogwa mösör mɨñ röbö yuadö pɨn dubä maga röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Akuyöbö almɨn nugwön, Saimon Pita nöbö nuŋ pɨsaŋ bɨyöj rol mɨdmä akuyöbö, dölöm mɨga pɨmä akuyöbö nugwön, rɨb mɨga akwör yöxmä. Sebedi ha nuŋwa Jems Jon yöŋö, bɨyöj i pön Saimon pɨsaŋ mabö nɨgiö nɨgön rɨmɨd nöbö hogwa, algör ör rɨb mɨga yöx nugumä. Makwam, Saimon du Jisas mɨdöŋ il yöra höxmax yuön yadöŋa, “Nöbö Dib, nɨ nöbö ap kib mag gwogwo rɨl aku, naŋ hör pikwo duö,” röŋa. Aliö rɨmɨn, Jisas yadöŋa, “Nagö ipöxmɨjɨnö. Weik wop mɨdö kɨ ila nɨgön, dölöm pɨb nöbö mɨdlö aku röböxön, nöbö mö yölɨŋ God adö pön höb nöbö mɨjnaŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Jisas aliö rɨmɨn, bɨyöj hogwa pön du röbö halai rola nɨgön, dölöm ap bla röböxön, Jisas pɨsaŋ dumä. ");
INSERT INTO tmd_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Makwam mai Jisas du taun i mɨdmɨn, nöbö uj höpebö mɨxɨñ piaku magalɨg nɨgöŋ nöbö i hön, Jisas mɨdöŋ il yöra höxmax yuön yöcmaca ubɨlön yadöŋa, “Naŋ nɨ raŋ kömö nɨgnöb, raŋ kömö nɨgönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Aliö rɨmɨn, Jisas yadöŋa, “Yöwö, nɨ rɨmön, nagö kömö nɨgönɨŋö,” röŋa. Aliö rön, Jisas imag nuŋwa mɨlkap nɨgön nöbö aku pɨ nugumɨn, wop akwör uj höpebö bla aŋadö lɨl rɨ pɨnöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Uj höpebö bla lɨl rɨ pɨnmɨn, Jisas nöbö aku nugwo yadöŋa, “Nɨ nagö pɨ nugumön kömö nɨg aku, nöbö mö akuyöbö yadmɨjɨnö. Makwam Mosɨs maduar ör kai kɨtön rɨg yadöŋ aliar, uj höpebö na aku kömö nɨgö, rön, du God ap höjöpal ur nölɨb nöbö bla ñɨgö yabuön, ap höjöpal nölɨb naŋ aku ñɨgö nölön yajɨnö, ‘Nɨ kömö nɨg aku, ap kɨ God höjöpal ur nöine,’ rö. Nagö almɨjɨnö aku, nöbö mö nugwön yajöña, ‘Nuŋ kömö nɨg aku döŋö almɨdö,’ cöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Makwam Jisas mönö nuŋ aku, mögörɨb piaku magalɨg rɨgwoŋ rɨgwoŋ dumɨn, nöbö mö mɨga akwör, nugwo nuguŋö, rön, nuö nuö röb wödemɨl rɨp hömɨdmä. Nöbö mö piaku, bli mönö wä nuŋ aku nuguba hömɨdmä; bli an raŋ wä raŋ, me rön, hömɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Makwam wop bli Jisas du hör möl i mɨdön, Nuö höjöpalmɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wop i Jisas nöbö mö akuyöbö ñɨgö mönö yad nöl mɨdöŋa. Perisi nöbö bli nɨgön, lo mönö yad nölɨb nöbö bli nɨgön, mögörɨb Galili mibɨl aku ram yöj lɨglɨg agrö akuyöbö magalɨg nɨgön, mögörɨb Judia mibɨl aku ram yöj lɨglɨg agrö akuyöbö magalɨg nɨgön, Jerusalem yöbö aipam hön, Jisas mönö yad nölmɨdöŋ yöra römɨd gɨ mɨdmä. Nöbö Diba ölɨsö maga Jisas pɨsaŋ mɨdöŋ makwam, Jisas nöbö mö ap röŋ akuyöbö ñɨgö rɨmɨn kömö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jɨ nöbö bli, nöbö iŋ wajmag lɨd pɨlöŋ i rɨp nɨg pön hön, Jisas nugwo raŋ kömö nɨgaŋ, me rön, rag Jisas mɨd rama ram möl yuadö pön duŋö, rön, rɨb aku yöx nugumä. ");
INSERT INTO tmd_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Makwam Jisas mɨdöŋ ram möla nugumɨn, nöbö mö ram möl aku aŋadö cɨcɨ röŋa. Almɨn, nöbäpö rɨp nɨg pön hömä aku, pön ram cölöbö sö wöluön, rama pɨ waglöx möl rödön, rɨpa adadö nag nɨgön, Jisas mɨdöŋ mibɨl yöra pibö abmä. ");
INSERT INTO tmd_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ñɨŋ rɨbyöx nugumä, Jisas raŋ kömö nɨgɨb maga rö, rön nugumɨdmɨn, Jisas rɨb ñɨŋ aku nugwön, nöbö iŋ wajmag lɨd pɨlöŋ aku nugwo yadöŋa, “Nöbö nugub nɨ, ap kib mag gwogwo rɨlö piaku nugwön röböxmɨdlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jisas aliö rɨmɨn, Perisi nöbö bla aipam, lo mönö yad nölɨb nöbö bla aipam, rɨb ñɨŋ bla akwör yöx nugwön yadmä, “Nöbö kɨ nöbö pödiöm? Nuŋ God yad höimöuön yadmɨda. God nuŋ paŋyöbö akwör ap kib mag gwogwo röi bla nugwön röböxɨb maga rö,” rön, rɨb ñɨŋ akwör yöx nugumä. ");
INSERT INTO tmd_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Makwam rɨbyöx nugumɨdmä aku Jisas nuŋ keir nugwön yadöŋa, “Ñɨŋ pödpöd rɨmɨn nɨ rɨb gwogwo yöxmɨdöi? ");
INSERT INTO tmd_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nöbö i nöbö i nugwo yajöna, ‘Ap kib mag gwogwo rɨlö bla nugwön röböxmɨdlö,’ cön aku, nuŋ mönö mi yadmɨdönö inakmönö hörmɨd aku ñɨŋ pödpödiö nugwöñ? Jɨ nöbö iŋ wajmag lɨd piön i mɨdaŋ, nöbö i nugwo yajöna, ‘Nagö wopik ör öbɨl duö,’ cön aku, nuŋ mönö mi yadmɨdönö inakmönö hörmɨd aku ñɨŋ pödpödiö nugwöñ? ");
INSERT INTO tmd_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nöbö Ha nuŋwa nöbö mö mögörɨb il kɨ ap kib mag gwogwo röi bla nugwön röböxɨb maga ra aku, ñɨŋ mönö aku mönö mɨm, me rön, nugw pɨne, rön, mönö aliö yadɨba rɨmɨdlö,” röŋa. Aliö rön, Jisas nöbö iŋ wajmag lɨd pɨlöŋ aku nugwo yadöŋa, “Nagö wopik ör öbɨlön, nagö rɨp nɨg pön höi rɨp wab aku pɨragön, höuöil ram nagö duö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Aliö rɨmɨn, nöbö mö bla nugugu mɨdɨm nugugɨrön, mag mɨd akwör öbɨlön, nugwo rɨp nɨg pön hem rɨp waba pön, God nugwo ri ablaŋe rɨ gɨrön, ram nuŋwa duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Almɨn, nöbö mö nugugu mɨdim akuyöbö magalɨg pɨlɨx rön, God iba pɨrag wöl gɨrön yadmä, “Weik ap keiryöbö i rɨmɨdmɨn nugwölɨŋö,” rön, aiö waiö rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Makwam mai Jisas duön nugumɨn, takis pɨb nöbö i takis nölɨb rama ram möl yuadö römɨd gɨ mɨdöŋa. Ib nuŋwa Lipai. Jisas nugwo nugwön yadöŋa, “Nagö han, nɨ pɨsaŋ duŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Aliö rɨmɨn, Lipai öbɨlön, rɨmɨdöŋ mabö aku röböxön, ap nuŋ bla magalɨg röböxön, Jisas pɨsaŋ duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Makwam Lipai wahax pön, Jisas nugwo ap mag diba ram nuŋ aku ur nɨgön, takis pɨb nöbö bli, nöbö mö hör mɨga akwör wö rɨm, hön Jisas pɨsaŋ römɨdön ap mag nɨmmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Makwam Jisas ñɨŋ pɨsaŋ ap mag nɨmmɨdöŋ aku nugwön, Perisi nöbö bli nɨgön, lo mönö yad nölɨb nöbö ñɨŋ bli nɨgön, hön Jisas nöbö nuŋ akuyöbö ñɨgö yadmä, “Ñɨŋ pödpöd rɨmɨn nöbö mö ap kib mag gwogwo röi bla nɨgön, takis pɨb nöbö bla nɨgön pɨsaŋ römɨdön ap nɨmmɨdöi?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Aliö rɨmɨn, Jisas mönö aku nugwön ñɨgö paiŋö yadön yadöŋa, “Nöbö mö kömö mɨdölö, röi bla, uj wobɨb nöbö yad wö rölöi; nöbö mö ap rɨ bla akwör, anɨŋ raŋ kömö nɨgaŋ, me rön, uj wobɨb nöbö yad wö röia. ");
INSERT INTO tmd_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mag aliö akuyöbö, nɨ nöbö mö, mɨd ri abmɨdölɨŋö, rön rɨbyöx nugwöi bla, ñɨgö yadɨba höi; nöbö mö, an ap kib mag gwogwo rön, mɨd ri abmɨdölölɨŋö, rön rɨbyöx nugwöi bla, ñɨgö yadɨba höla. Nɨ ñɨgö mönö wä yad nölmön, ñɨŋ mönö na aku nugw pön, ap kib mag gwogwo röi aku, pödpöd rɨmɨn aliö alölɨŋö, rön, röböxön, God rɨg yad mag akwör cöñɨŋö, me rön, mönö mag akwör yadɨba hölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Makwam ñɨŋ bli Jisas nugwo yadmä, “Jon nöbö nuŋ bla aipam, Perisi nöbö ñɨŋ bla aipam wop bli, God paŋyöbö akwör rɨbyöx nuguŋö, rön, ap mag nɨmölön kiö akwör mɨdön, God höjöpalöia. Jɨ nöbö nagö bla ap mag nɨm gör, röbö nɨm gör mɨdöiŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Aliö rɨmɨdmɨn, Jisas ñɨgö paiŋö yadöŋa, “Nöbö i mö pön, nöbö mö nuŋ bla pɨsaŋ ap diba nɨmöñ aku, nöbö bli öbɨlön, pödpöd rɨmɨn almɨdöiŋö, rön yadeñɨm. ");
INSERT INTO tmd_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Makwam mai nöbö bli hön nöbö aku pön duŋ, wop aku nöbö mö nuŋ bla lɨb pɨlaŋ, ap mag nɨmeñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jisas mönö höd röxön ñɨgö yadöŋa, “Wölɨj hödyöbö i ödörmɨjön aku, wölɨj yoŋyöbö i pɨxdörön rag hö lɨdɨxɨŋ, nɨg nugugu mɨden. Hörɨrör nɨgaŋ mösör mɨ gwogwo cöna. ");
INSERT INTO tmd_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Makwam röbö wain aku algör. Röbö wain kömö aku pön, hön meme uñ wödö möl bö hörölöi. Aku agapɨm: hörön mämugw nölɨŋ, wöl aja wölön, mɨ pɨn pɨn yadön waglöxaŋ röbö waina höraŋ, hön meme uñ aku aipam gwogwo cöna. ");
INSERT INTO tmd_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Rɨba aliö yöx nugwön aku, röbö wain kömö pön, hön meme uñ kömö möl akwör hör nɨgɨbɨm. ");
INSERT INTO tmd_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Makwam nöbö mö röbö wain hödyöbö mödö nɨmöi bla, mai röbö wain kömö yoŋyöbö aku nɨmɨŋ ñɨgö wä ren; ‘Röbö wain hödyöbö aku röbö waiö,’ me cöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mai Juda God höjöpalɨb wop i, Jisas nöbö nuŋ bla pɨsaŋ wit möriwö mibɨla du gɨrön, nöbö nuŋ bla wit mag piaku bli röx imag rol ñɨŋa nɨgön, uñ pal abön nɨm gɨr dumä. ");
INSERT INTO tmd_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Akuyöbö almɨdmɨn, Perisi nöbö bli nugwön yadmä, “Ñɨŋ pödpöd rɨmɨn God höjöpalɨb wop mabö rölɨb kɨ, wit mag uñ pal abön mabö rɨmɨdöi?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Aliö rɨmɨn, Jisas nöbö nuŋ bla rim aku mag gwogwo i rölim aku nugwön, Perisi nöbö bla ñɨgö yadöŋa, “Depid maduar ör nöbö nuŋ bla pɨsaŋ kiö pɨlmɨn, God höjöpalɨb ram aku uröpɨnön, bred God mämäg il rol yöraku nɨgön, nöbö hör nɨmmɨdölöi, God ap höjöpal ur nölɨb nöbö bla akwör nɨmmɨdöi bred aku, Depid yad nugum, nugwo nölmɨn, nöbö nuŋ bla pɨsaŋ nɨmɨmä. Ñɨŋ kiö pɨlmɨn rim haiwo aku God Mönö kai kɨtmä aku, ñɨŋ nugwölöi ä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jisas mönö i kwo yadön yadöŋa, “Nöbö Ha nuŋwa Nöbö Diba mɨdön, hör mɨdɨb wop aku, agap apɨm cɨnö cön aku, cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","7","Makwam Juda God höjöpalɨb wop maiyöbö i, Jisas Juda mögum rɨb rama duön, ñɨgö God Mönö maga yad nöl gɨr mɨdöŋa. Ram möl aku, imag mɨrɨx adö aŋadö po röŋ nöbö i hö mɨdöŋa. Perisi nöbö bla aipam, lo mönö yad nölɨb nöbö bla aipam, nöbö aku nugumä aku, Jisas nuŋ God höjöpalɨb wop kɨ nugwo raŋ kömö nɨgönɨŋönö mag i raŋ, nugwo yadyöxnɨŋö, rön, nugwo mɨ riö nugugu mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jɨ aliö rɨbyöx nugumä aku, Jisas nuŋ keir nugwön, nöbö imag po röŋ aku nugwo yadöŋa, “Nagö öbɨlön mibɨl yörɨk hö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Aliö rɨmɨn, öbɨl höm nugugɨrön, Jisas Perisi nöbö bla aipam, lo mönö yad nölɨb nöbö bla aipam ñɨgö yadöŋa, “Hör mɨdɨb wop kɨyöbö, nöbö mö bla ñɨgö pɨ ösös rɨ ri abnɨŋönö owa, hör mɨdɨb wop mɨdö kɨ, me rön, ñɨgö röböxnɨŋ? Ñɨgö rɨŋ öbɨl diöñɨŋönö ñɨgö röböxɨŋ wöröxöñɨŋö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jisas aliö rön, ñɨgö riö riö nugwön, nöbö imag po röŋ aku nugwo yadöŋa, “Imag nagö aku mɨlkap abö!” röŋa. Aliö rɨmɨn, imag nuŋwa mɨlkap abmɨn nugugɨrön, rɨb pia wä röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Jisas nöbö aku nugwo rɨmɨn wä röŋ aku nugwön, Perisi nöbö bla aipam, lo mönö yad nölɨb nöbö bla aipam, rɨb gwogwo ödöriö yöxön, Jisas nugwo pödpöd cɨnɨŋö, rön, yad nugwob nugwob rɨ gɨr mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Makwam wop mibɨl yöraku, Jisas Nuö nugwo höjöpainö, rön, önöŋ ajmag pɨd sö wöluön, Nuö nugwo höjöpal mɨdɨm mɨdɨm, ruö löuöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Löumɨn naiö aböŋ mag aku, nöbö nuŋ bla magalɨg yadɨm hömɨdmɨn, nöbö nuŋwa akuyöbö möl sö ñɨgö pɨ asɨx hör nɨgön, ñɨŋ nöbö mönö na pɨrag dub bla mɨjne, rön, yad nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","15","Nöbö nuŋ yad nɨgöŋ piaku ib ñɨŋ bla: i Saimon, mai Jisas ib nuŋ i nölön Pita röŋa; i Edru, Saimon hödnɨŋ nuŋ aku; i Jems; i Jon; i Pilip; i Batolomiu; i Matiu; i Tomas; i Jems, Alpias ha nuŋ aku; i Saimon ib nɨgiö Saimon Selot me rɨmɨdöi aku; ");
INSERT INTO tmd_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","i Judas, Jems ha nuŋ aku; i Judas Iskariot. Nöbö akwör nuŋ mai Jisas pɨl pal nɨgɨŋ, me rön, höuöu röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Makwam Jisas nöbö nuŋ piaku pɨsaŋ önöŋ ajmag pɨd sö röböxön, hön aku pibö rɨp pɨn du up waiö bö mɨdɨm nugugɨrön, nöbö mö magöri rɨp nugwo nuguŋö, rön, hö mögum rɨmä. Nöbö mö piaku, bli Jerusalem yöbö, bli mögörɨb Judia piakuyöbö, bli mögörɨb röbö wödoböŋ taun dib mös Taia Saidon yöbö, ");
INSERT INTO tmd_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jisas mönö nuŋwa nugwön, anɨŋ ap rɨ bla raŋ kömö nɨgaŋ, me rön, hömɨdmä. Nöbö mö ragwo as bla yuö wölɨm mɨd ri abölim bla, Jisas rɨmɨn kömö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jisas ölɨsö nuŋ maga hön, ñɨgö agap bɨlɨm röŋ akuyöbö rɨmɨn, magalɨg kömö nɨgmɨd aku nugwön, nöbö mö piaku magalɨg hön, an aipam Jisas nugwo pɨ nugunɨŋö, rön, nöbö mö mɨga nuö nuö röb wödemɨl rɨp nugwo mɨdɨba hömä. ");
INSERT INTO tmd_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisas nöbö nuŋ akuyöbö ñɨgö mämäga nugu gɨrön yadöŋa, “Ñɨŋ nöbö mö lɨblɨb rɨ mɨdö bla mɨdöi aku, God ñɨgö pɨ ösös rɨ ri abön nugwidɨx mɨjöna. Rɨb aku yöx nugwön wahaxbör wahax pɨmɨjöña. ");
INSERT INTO tmd_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ñɨŋ weik kiö diba pɨl bla, mai kiö pɨlen. Rɨb aku yöx nugwön wahaxbör wahax pɨmɨjöña. Ñɨŋ lɨblɨb rɨm, immɨdöi bla, mai wä raŋ nugugɨrön imöuöña. Rɨb aku yöx nugwön wahaxbör wahax pɨmɨjöña. ");
INSERT INTO tmd_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nöbö Ha nuŋwa nugwo cɨrɨpön mɨdɨŋ, nöbö mö bla ñɨgö rɨb gwogwo yöxön, höj nugwön, nöbö mö gwogwo pi bɨlɨk, nöbö kai pɨsaŋ mɨjöñɨŋö, rön, ñɨgö ib urön rɨb gwogwo yöxön, yad mönö nɨgön yad höimöumɨjöñ aku, ñɨŋ wahaxbör wahax pɨmɨjöña. ");
INSERT INTO tmd_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Aiöñ aku, nöhönɨŋ maduebö ñɨŋ bla, God mönö yadɨb nöbö bla ñɨgö rɨg rɨmɨdöi mag akwör ñɨgö rɨmɨjöña. Mag akwör rɨbyöx nugwön, God anɨŋ pɨ ösös rɨ ri abön mögörɨb nuŋ adöx yöd röul adö kau sö, me rön, waiö raŋ nugugɨrön, iŋ wajmag röd bɨl bɨl rɨ öbɨl gɨrön, wahaxbör wahax pɨ gɨr mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Makwam ñɨŋ nöbö mö rɨg ap mɨga mɨd akuyöbö nugw ri aböña. Ap ñɨŋ pɨbä aku, mögörɨb rol il kɨ mödö pöia. ");
INSERT INTO tmd_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Makwam ñɨŋ weik ap mag nɨmön rɨm rɨm wöt bɨr bla, mai kiö piön makwam nugw ri aböña. Makwam ñɨŋ wopik mönö pön imöuön mögö möul rɨ gɨr mɨdöi bla, mai lɨb pɨlaŋ imön möb nɨg gɨr mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Makwam ib ñɨŋa pɨrag wöl gör mɨjöñ aku, ñɨŋ nugw ri abön mɨjöña. Nöhönɨŋ maduebö ñɨŋ bla, nöbö God Mönö inakmönö hörön rɨg yadmɨdöi mag akuyöbö, ñɨgö kwo paŋ mag akwör rɨmɨdöia. ");
INSERT INTO tmd_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Makwam nöbö mö mönö na nugumɨdöi kɨyöbö. Pɨlgɨb imgɨb ñɨŋ akuyöbö ñɨgö madmag nɨgöña. Nöbö mö ñɨgö ölö wölmɨn rɨb ögwö yöx nugwöi akuyöbö ñɨgö pɨ ösös cöña. ");
INSERT INTO tmd_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nöbö mö ñɨgö yad höimöuöñ aku, God ñɨŋ nugwidɨx mɨdaŋ, me rön, nugwo höjöpal röb nöiöña. Nöbö mö ñɨgö rɨ gwogwam rɨmɨdɨŋ, ñɨgö God höjöpaiöña. ");
INSERT INTO tmd_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nöbö mö bli ñɨgö alguna adöi palɨŋ, pikwo rɨŋ, adöi aipam paiöña. Nöbö mö bli ij ap uñ ñɨŋ aku pɨmɨdɨŋ, ap uñ aku algör aipam pö, rön, amnör nöiöña. ");
INSERT INTO tmd_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nöbö mö bli ap mɨdölaŋ, sö rɨmɨdɨŋ, ñɨŋ ñɨgö nöiöña. Ap ñɨŋ i nugwön pɨmɨdɨŋ, ap ana höbkal nöine, rön, yadmɨjeñ. ");
INSERT INTO tmd_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Anɨŋ alɨŋ, me rön, rɨbyöx nugwöi mag akuyöbö, ñɨŋ keir nöbö mö bla akuyöbö ñɨgö paŋ mag akwör cöña. ");
INSERT INTO tmd_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nöbö mö ñɨgö madmag nɨgöi bla akwör paiŋö madmag nɨgöñ aku, God nuŋ nugwaŋ, pödpödiö wä cön? Nöbö mö ap kib mag gwogwo röi bla, nöbö mö ñɨŋ keir bla algön nör nuö nuö madmag nɨgöia. ");
INSERT INTO tmd_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Makwam nöbö mö ñɨgö pön ösös röi bla paiŋö algör ösös rɨ ri aböñ aku, God nuŋ nugwaŋ, pödpödiö wä cön? Aiöñ aku, nöbö mö ap kib mag gwogwo röi piaku rɨg röi mag akwör cöña. ");
INSERT INTO tmd_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ap nölɨŋ paiŋö nölɨŋ, me rön, rɨba akwör yöx nugwön ap nöiöñ aku, God nuŋ nugwaŋ, pödpödiö wä cön? Aiöñ aku, nöbö mö ap kib mag gwogwo röi piaku rɨg röi mag akwör cöña. ");
INSERT INTO tmd_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Makwam, pɨlgɨb imgɨb ñɨŋ bla madmag nɨgön, ñɨgö ösös rɨ ri abön, ap amnör nöiöña. Anɨŋ paiŋö nöiöñɨŋö, rön, rɨb aku yöx nugumɨjeñ. Aliö almɨjöñ aku, God ölɨsö magalɨg bɨl yöra sö mɨd Nöbö aku, halöu ha nuŋwa mɨjöña. Nuŋ rɨg rɨ mag akuyöbö almɨjöñ aku, mɨ ñɨgö uplöben; paiŋö ñɨgö ap wä nöiöna. God nuŋ nöbö mö ap kib mag gwogwo röi bla aipam, nöbö mö nugwo, ri ablaŋe rön, yadölöi bla aipam, ñɨgö algön nör ösös rɨ ri abmɨda. ");
INSERT INTO tmd_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nuö ñɨŋa nöbö mö ögwö yöxön pɨ ösös rɨ mag akuyöbö, ñɨŋ kwo algör nöbö mö uliöxön pɨ ösös rɨ ri aböña. ");
INSERT INTO tmd_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ñɨŋ nöbö mö bli, ‘Mag al aliö röi aku, ñɨŋ nöbö mö gwogwo mɨdöiŋö,’ reñ aku, God ñɨgö paiŋö algör ör, ‘Mag al aliö röi aku, ñɨŋ nöbö mö gwogwo mɨdöiŋö,’ ren. Ñɨŋ nöbö mö bli mönö diba yadön, ‘Ñɨŋ nöbö mö gwogwo paiŋö pöñɨŋö,’ reñ aku, God ñɨgö paiŋö algör ör mönö diba yadön, ‘Ñɨŋ nöbö mö gwogwo paiŋö pöñɨŋö,’ ren. Nöbö mö akuyöbö ñɨgö rɨ gwogwam rɨmɨjöñ aku nugwön röböxmɨjöñ aku, God ap gwogwo ñɨŋ röi aku, algör ör nugwön röböxöna. ");
INSERT INTO tmd_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ap ñɨŋ bla nöbö mö akuyöbö ñɨgö amnör nöiöñ aku, God ñɨgö paiŋö algör ör mɨ amnör nöiöna. Ñɨŋ skel pödiöm pön nöbö mö piaku ñɨgö ap nuöm nɨg nöiöñ aku, God skel akwör pɨ ñɨgö algör ör ap nuöm nɨg nöiönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Makwam Jisas mönö i höd röxön yadöŋa, “Nöbö mämäg we wölön i, nöbö mämäg we wölön i nugwo, ödöi al aliö mɨdö, rön, yabuen. Aku agapɨm: nuŋ alön raŋ, mösör ulöm möl bö pɨn bɨcöña. ");
INSERT INTO tmd_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nöbö mö skul pöi bla, du skul pöi mag aku, yad nölɨb nöbö ñɨŋ bla padɨx röul adöx sö mɨdölöi. Makwam mai skul aku yadön pɨ ri abön pöcöña aku, yad nölɨb nöbö ñɨŋ bla pɨsaŋ nɨg nugugu mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Makwam pödpöd rɨmɨn bäpö mämäg yuö ñɨgö keira pöröb gɨ mɨd aku nugw yadölöi wöhö, pɨgnɨŋ ñɨŋa ap bɨcep mämäg yuö nuŋwa mɨd akwör nugwön yadöi? ");
INSERT INTO tmd_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Bäpö diba mämäg yuö ñɨgö pöröb gɨ mɨd aku höd pa abɨŋ, mämäg yuö ñɨŋa wä raŋ nugwön, mai pɨgnɨŋ ñɨŋa ap bɨcep ulmɨdö mea mämäg yuö nuŋwa mɨd aku, pa abnɨŋö, rön yajne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Makwam bɨ wä mag gwogwo yaxen; jɨ bɨ wopa mag wä yaxen. ");
INSERT INTO tmd_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Makwam, bɨ akuyöbö mag yaxön aku nugwön, aku bɨ wä, aku bɨ wopa, me rön, nugwöña. Nag mogwöñö aku kiau maga tatal yaxen. Nag pɨlpɨlsɨnö aku kopen maga tatal yaxen. ");
INSERT INTO tmd_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nöbö mö wä bla, höbwab rɨb madmag yuö ñɨŋ kwo wä rɨg mɨd aku, mag wä röia. Nöbö mö gwogwo bla, höbwab rɨb madmag yuö ñɨŋ kwo gwogwo rɨg mɨd aku, mag gwogwo röia. Makwam nöbö mö pödiö bɨlɨm mɨdöi aku, mönö yajöñ aku algör audiöx nugwön, aku nöbö mö wä, aku nöbö mö gwogwo piaku, me rön, nugunɨŋa. ");
INSERT INTO tmd_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nɨ Nöbö Dib an, Nöbö Dib an, me röi aku, jɨ pödpöd rɨmɨn mönö yadɨl aku mai duölöi? ");
INSERT INTO tmd_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nöbö mö mönö na aku nugwön, rɨg yadɨl mag akwör röi bla, mönö yadɨba rɨmɨdɨl kɨyöbö mɨdöia. ");
INSERT INTO tmd_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nöbö mö mönö na aku nugwön, rɨg yadɨl mag akwör röi bla, nöbö ram urɨba cön aku, ulöm pön, padö rɨg rol yöra pɨl ri abön, rama rol sö ur nɨgön, mag akuyöbö alɨg mɨdöia. Alaŋ, röbö hadö hön, rama alɨg pal gɨlɨx ab gɨlɨx rɨ pɨrag dinö, rɨ wöhö nugwön, rama ur gö nɨgön aku ölɨsö akwör mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Makwam nöbö mö mönö na aku nugwön, yadɨl akuyöbö rölöi bla, nöbö ram urɨba cön aku, ulöm pön padö pɨlen; hör mögö rol yöraku ur nɨgön, mag akuyöbö alɨg mɨdöia. Alaŋ, röbö hadö hön, rama alɨg pal gɨlɨx ab gɨlɨx rɨ pɨrag dinö, rön, mag akwör rama alɨg aŋadö mag duaŋ, yöra mögedö akwör mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisas nöbö mö piaku ñɨgö mönö aku yad nöl pörön taun ulmɨdö Kapaneam duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","3","Makwam taun aku, ami nöbö mɨga akwör nugwidɨx mɨdmɨd nöbö dib i mɨdöŋa. Nöbö bli Jisas hö Kapaneam mɨdö, rɨmɨn, mönö aku nugwön, Rom ami nöbö dib i Juda mönö pɨ nuöm nɨgɨb nöbö bli yad abön yadöŋa, “Nag mabö rɨ nölɨb nöbö wä ödöriö nɨ i ap rɨm wöröxɨba rɨmɨda nugwön, ñɨŋ du Jisas nugwo yad nugwön yölɨŋ pön höŋ, nugwo raŋ kömö nɨgaŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Aliö rɨmɨn, ñɨŋ Jisas mɨdöŋ yöra duön, nugwo mɨ ususör rɨ yad gögö rön yadmä, “Ami nöbö nugwidɨx mɨdɨb nöbö dib i nöbö wä mɨdöm. Anɨŋ Juda nöbö mö bla madmag nɨgön öim nugwidɨx mɨd ri abön ra. Mögum rɨb ram anɨŋ i rɨ nɨgöŋa. Makwam, nagö duön nag mabö rɨ nölɨb nöbö nuŋ aku raŋ kömö nɨgaŋ,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ñɨŋ aliö rɨmɨn nugwön, Jisas ñɨgö pɨsaŋ dumɨd dumɨd ramɨxrö il yöra umɨn nugugɨrön, ami nöbö nugwidɨx mɨdɨb nöbö aku nöbö nugub nuŋwa bli yad abmɨn, du Jisas nugwo möigw palön yadmä, “Ami nöbö nugwidɨx mɨdɨb nöbö an aku algör yada, ‘Nöbö Dib, nɨ nöbö wä yöi, ram na aku yamsö ölɨŋ wöröxɨp hömɨjɨnö. ");
INSERT INTO tmd_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nɨ nöbö wä mɨdlöxisöŋö ulöxa, jɨ nɨ nugula, God nagö pɨsaŋ mɨd aku, “Kömö nɨgaŋ,” mönö akwör yadmɨdaŋ, nöbö na ap rɨ aku kömö nɨgöna. ");
INSERT INTO tmd_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nöbö dib ödöriö i nɨ nugwidɨx mɨda; nɨ keir piöŋö ami nöbö akuyöbö ñɨgö nugwidɨx mɨdön, “Dine!” rɨmön duöia; “Höne!” rɨmön höia; “Mabö aku cɨne!” rɨmön röiŋö,’ rö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Aliö rɨmɨn, Jisas, nöbö aku rɨb nuŋwa keir yöx nugwön aliö yada, rön, aiö rön, nöbö mö nugwo mai hömɨdim akuyöbö ñɨgö yadöŋa, “Ami nöbö Rom yöbö aku nɨ nugw pɨ gö nɨga. Nuŋ rɨ mag aku, Isrel nöbö i akuyöbö tatal rɨm, nɨ nugwöi, mɨ wöhö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Makwam ami nöbö nugwidɨx mɨdɨb nöbö aku, nöbö nuŋ bla höbkal duön nugumä, nöbö ap röŋ aku mödö kömö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Wop mibɨl akwör, Jisas pɨsaŋ nöbö nuŋ bla pɨsaŋ Nen taun dumä. Nöbö mö bla mɨg mɨŋa pɨsaŋ dumä. ");
INSERT INTO tmd_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Taun ubalɨja il yöra uröpɨnmɨn nugugɨrön, mö wösrö i ha paŋyöbö nuŋwa yöx pön höŋ aku wöröxɨm nugwön, nöbäpö rɨp nɨgön rag hömɨdmä. Nöbö mö mɨga akwör taun akuyöbö hön mö aku pɨsaŋ hömɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jisas mö wösrö aku nugwo nugumɨn, lɨb pɨlɨm yadöŋa, “Immɨjnaŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Aliö rön, nuŋ duön nöbäpö rɨp nɨg pön hömɨdim rɨp waba pɨ nugum nugugɨrön, nöbö rɨp nɨg rag hömɨdim akuyöbö gö nɨgmä. Jisas nuŋ ha nöbö wöröxöŋ aku nugwo yadöŋa, “Ha mɨg, nagö yadmɨdlöm, öbɨlö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Aliö rɨmɨn, ha öbɨl römɨdön mönö pɨmɨn nugugɨrön, Jisas nuöma nugwo, ha nagö aku, me rön, pön nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Makwam nöbö mö nugugu mɨdim bla magalɨg pɨlɨx rön, God iba mag wöl gɨr yadmä, “God mönö yadɨb nöbö dib ödöriö anɨŋ ha. God anɨŋ rɨ nölɨba hö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jisas röŋ aku nugwön, haiwo pɨm, mönö aku mögörɨb Judia yuadö aku duön, rɨba mögörɨb hör piaku piaku magalɨg duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon nöbö nuŋ bla, Jisas rɨg röŋ akuyöbö magalɨg nugwön, du Jon nugwo yad nölmɨn, nöbö nuŋ mös yadɨm hömɨdmɨn yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","“Ñɨŋ nöbö hogwa duön Nöbö Diba nugwo yad nugwön, ‘Nagö Mesaia öim pöx mɨdmɨdöl akwör hölanö owa nöbö hör i pöx mɨjnɨŋö?’ cɨne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Aliö rɨmɨn, nöbö hogwa Jisas mɨdöŋ yöra duön yadmä, “Röbö pal nölɨb nöbö Jon anɨŋ nöbö hogwa yada, ‘Ñɨŋ nöbö hogwa duön Nöbö Diba yad nugwön, “Naŋ Mesaia öim pöx mɨdmɨdöl akwör hölanö owa nöbö hör i pöx mɨjnɨŋö,” cɨne,’ rön, an nöbö hogwa yad abmɨn, nagö yad nuguba höl kɨ,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Makwam ñɨŋ nöbö hogwa aliö rön nugugu mɨdɨm nugugɨrön, Jisas nöbö mö mɨga ap adö hörɨrör röŋ bla rɨmɨn kömö nɨgöŋa; nöbö mö mɨga wöröx mɨdim bla rɨmɨn kömö nɨgöŋa; nöbö mö mɨga ragwo as yuö wöl mɨdöŋ bla rɨmɨn ragwo as bla röu dumɨn kömö nɨgöŋa; nöbö mö mɨga mämäg we wölöŋ bla rɨmɨn mämäga ix nugumä. ");
INSERT INTO tmd_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Akuyöbö alön, Jisas nöbö hogw aku ñɨgö yadöŋa, “Ñɨŋ nöbö hogwa höbkal duön Jon nugwo yajöña, ‘An du nugwöla, nöbö aku nöbö mö mämäga we wöl bla rɨmɨn mämäga ix nugwöia; nöbö mö yödpɨlö aŋadö gwogwo rɨ bla rɨmɨn yöda röb yönmɨdöia; nöbö mö mɨxɨñ uj höpebö nɨg bla rɨmɨn wödö wöla; nöbö mö rɨmɨj möl idɨx bla rɨmɨn mönö audiöx nugumɨdöia; nöbö mö wöröxöi bla rɨmɨn kömö mɨdöia; nöbö mö lɨblɨb rɨ mɨdö bla mönö wä aku yad nölmɨn nugumɨdöia. ");
INSERT INTO tmd_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nöbö mö nɨ rɨbyöx nugwön cɨrɨp gör mɨjöñ bla, mɨ wahax pɨ mɨjöñɨŋö,’ cɨne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jisas aliö rɨmɨn, nöbö Jon mönö pön hem hogwa höbkal dum nugugɨrön, Jisas nuŋ Jon haiwo pön, nöbö mö mɨdim akuyöbö ñɨgö yadöŋa, “Ñɨŋ höd mögörɨb rɨg kap mibɨl yöra duim wop aku, agapɨm nuguba duim? Ñɨŋ mugumö mɨxɨl paŋyöbö i hödala pön memexön rɨ pikwo pik rɨ i nuguba duim? ");
INSERT INTO tmd_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ñɨŋ agapɨm nuguba duim? Nöbö wölɨj wä ödöriö yöm i nuguba duim? Aku wöhö. Nöbö wölɨj wä ödöriö pön, ap wä wä pɨŋö, rön rɨbyöx nugwöi bla, nöbö diba ram bla akwör hölɨm mɨdöia. ");
INSERT INTO tmd_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Makwam ñɨŋ agapɨm nuguba duim? God mönö yadɨb nöbö i nugwo nuguba duim ä? Mɨ pal, God mönö yadɨb nöbö i nugwo nuguba dumä, jɨ Jon nuŋ mabö adö keiryöbö i rɨba höŋa. ");
INSERT INTO tmd_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nöbö Jon aku mɨ, maduar ör God Mönö aku kai kɨtön yadmä, ‘Mönö yadɨb nöbö na aku yad abmön, höd duön, nöbö mö piaku ñɨgö yad nöl ri abaŋ; mai naŋ keir yad abmön inaŋö,’ rön, kai kɨtmä. ");
INSERT INTO tmd_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ñɨgö yadmɨdla, nöbö mö höd mɨdmɨdöi bla aipam, nöbö mö weik mɨdöi bla aipam, magalɨg hör nöbö mö, Jon nuŋwör nöbö dib. Jɨ God nöbö mö hör piaku pön mögörɨb nuŋwa adöx yöd röul adö kau sö nugwidɨx mɨdɨb bla, ñɨŋ Jon röxg mɨdeñɨm; ñɨŋ nöbö mö diba mɨjöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nöbö mö piaku, takis pɨb nöbö bla aipam, höd Jon pöl hömɨn, ñɨgö magalɨg röbö pal nölöŋa. Almɨn, Jisas mönö yadöŋ aku nugwön yadmä, “God ödöi nuŋwa akwör ödöriar mɨdö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Makwam Perisi nöbö aipam, lo mönö yad nölɨb nöbö dib bla aipam, God ñɨgö agap apɨm cɨnö röŋ aku, ñɨŋ röböxön, Jon anɨŋ röbö pal nölaŋ, me rön, hölim. ");
INSERT INTO tmd_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","32","Makwam Jisas nöbö mö piaku ñɨgö mönö i yadön yadöŋa, “Nöbö mö weik wop kɨ mɨdöi bla nɨ nugula, ñɨŋ halöu ha ulul bla, nöbö mö mögum rɨb yöra römɨdön, halöu ha ulul bli ajmöla aj halön yadɨp duön yadöia, ‘An namö pɨrmɨn, ñɨŋ pödpöd rɨmɨn höx wödölöi? An wopal imbä mɨdö bla akuyöbö i yadɨm, ñɨŋ pödpöd rɨmɨn imölöi?’ alöi mag akuyöbö, ñɨŋ röia. ");
INSERT INTO tmd_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Aku agapɨm: röbö pal nölɨb nöbö Jon hön, ap mag nɨmölön, röbö wain nɨmölön rɨm, ñɨŋ nugwo yad höimöuön yadöia, ‘Nöbö aku ragwo as yöj nɨgɨm mɨd aku,’ me röia. ");
INSERT INTO tmd_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Makwam weik nɨ Nöbö Ha nuŋwa hön, ap nɨmön, röbö wain nɨmön rɨmön, nɨ yad höimöuön yadöia, ‘Ap mɨga nɨmön, röbö wain nɨmön rɨ makwam, nuŋ nöbö mö ap kib mag gwogwo röi nöbö bla, takis pɨb nöbö bla, nöbö ñɨŋ i mɨd aku,’ me röia. ");
INSERT INTO tmd_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Makwam nöbö mö God Mönö wä aku nugw pön, mai duön, mag wä rön, mɨd ri abmɨjöñ aku, nöbö mö piaku ñɨgö nugwön yajöña, God Mönö aku mönö mɨ ödöriö, me cöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Perisi nöbö i ib nuŋwa Saimon. Nuŋ Jisas nugwo yadöŋa, “Naŋ han ram na ap nɨmɨŋö,” röŋa. Aliö rɨmɨn, Jisas ram nuŋwa duön ap mag nɨmmɨdɨm nugugɨrön, ");
INSERT INTO tmd_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","taun aku mɨdön ap kib mag gwogwo rɨmɨd mö i, mönö i nugwön nugwöŋa, Jisas Perisi nöbö rama duön pɨsaŋ ap nɨmmɨdmä. Aku nugwön, röbö hölɨŋ wä höb rɨg balol pɨ unön nɨgim i pön hön, ");
INSERT INTO tmd_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jisas mɨdöŋ höglöm ada hön, yödpɨlö il yöra im gɨr mɨdöŋa. Aliö imön rɨm nugugɨrön, mäp röbö aku ödör Jisas yamsö rol bö pɨnmɨn, yöj panö nuŋ aku pɨ örɨx ab gɨr, yamsö nuŋwa mäp röbö nɨg nölön, röbö hölɨŋ wä höb aku yamsö nuŋwa rola nɨg nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Aliö almɨdmɨn, Perisi nöbö Saimon aku, rɨb nuŋ akwör yöx nugwön nugwo keir yadöŋa, “Nöbö kɨ God mönö yadɨb nöbö ödöriö mɨdöxisöŋö, mö kɨ nuŋ ap kib mag gwogwo rɨmɨd mö gwogwo i hön nugwo pɨ nugumɨd aku, me rön, röx nugwöx,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jisas nuŋ, Perisi nöbö rɨbyöx nugwöŋ aku nugwön, nugwo yadöŋa, “Saimon, mönö nɨ paŋyöbö i mɨda nagö yad nölɨba rɨmɨdlö,” röŋa. Jisas aliö rɨmɨn, Saimon yadöŋa, “Mönö yad nölɨb nöbö nɨ, mönö aku yadö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Aliö rɨmɨn, Jisas mönö höd röxön yadöŋa, “Nöbö i öbɨlön, nöbö mös ñɨgö nöbö i paip hadred (500) denariai nölön, i pipti denariai (50) nöiöna. ");
INSERT INTO tmd_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Makwam nöbö hogw aku rɨga paiŋö nölɨb maga nɨgölaŋ, rɨg nöiön nöbö aku ñɨgö nöbö hogwa yajöna, ‘Röböxi. Rɨg ñɨgö nöbö hogwa nöil aku, paiŋö nölɨŋö, rön, rɨb aku yöxmɨjeñɨŋö,’ cöna. Aliö raŋ, nöbö kai nöbö aku nugwo mɨ ödöriö madmag nɨgön, nöbö ap rɨb diba mɨjön aku mönö nöbö ap rɨb ulmɨdö mɨjön aku?” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Jisas aliö rɨmɨn, Saimon yadöŋa, “Rɨb na yöx nugul aku, nöbö ap rɨb diba mɨjön aku,” me röŋa. Aliö rɨmɨn, Jisas yadöŋa, “Mɨ ödöriö yadlaŋe,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Aliö rön, Jisas höbkal, mö aku nugwo nugwön, Saimon nugwo yadöŋa, “Mö kɨ nugwo nugwö. Nɨ ram möl yuadö nagö kɨ hömɨdmön, naŋ röbö i pön yamsö na örɨx abɨb bli nölöiö, jɨ mö kɨ, mäp röbö nuŋ aku ödör pɨnön yamsö na yös rɨmɨn, nuŋ yöcmac panö nuŋwa pön örɨx aba. ");
INSERT INTO tmd_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Naŋ nɨ alguna bɨmɨl nɨmöiö, jɨ mö kɨ, nɨ ram möl yuadö nagö hömɨdmön mag aku ila nɨgön, nuŋ yamsö na bɨmɨl nɨm gɨr mɨda. ");
INSERT INTO tmd_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Naŋ wel röbö yöcmac na nɨg nölöiö, jɨ mö kɨ, nuŋ yamsö na röbö hölɨŋ wä höb aku nɨg nöla. ");
INSERT INTO tmd_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Makwam, nagö yadmɨdla, mö kɨ ap kib mag gwogwo mɨga akwör rɨ aku nugwön röböxmɨdla. Makwam, nuŋ nɨ mɨ madmag nɨga. Makwam nöbö mö ap kib mag gwogwo ulul röi bla nugwön röböxmön, nɨ madmag ulul mɨŋi nɨgöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Makwam Jisas aliö rön mö aku nugwo yadöŋa, “Ap kib mag gwogwo rɨlö bla nugwön röböxlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jisas aliö rɨmɨn, nöbö nuŋ pɨsaŋ ap nɨmmɨdim bla, ñɨŋ keir yad nugwob nugwob rön yadmä, “Nöbö kɨ pödpöd rɨmɨn, ‘Ap kib mag gwogwo rɨlö bla nugwön röböxlö,’ rɨmɨdö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Aliö yadim aku, jɨ Jisas mö aku nugwo yadöŋa, “Rɨb naŋa keir akwör nugw pön, ap kib mag gwogwo rɨl aku Jisas nugwön röböxaŋ, me rön hölö aku, ap kib mag gwogwo rɨlö bla nugwön röböxmɨdla. Nagö duön, God imag iŋsö rol aku mɨdane,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Makwam mai wop mibɨl yöraku, Jisas nöbö nuŋ akuyöbö mɨgan kwo pɨsaŋ taun bla aipam, ram yöj lɨglɨg agrö bla aipam duön, God nöbö mö nuŋwa pön nugwidɨx mɨdɨb mönö wä aku, nöbö mö akuyöbö ñɨgö yad nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Mö bli ragwo as alɨg mɨdim bla Jisas rɨmɨn mö yöbö nɨgöŋa; bli ap röŋ bla rɨmɨn kömö nɨgöŋa. Mö adaku bli Jisas pɨsaŋ yönmɨdmä. Mö adaku ib ñɨŋ aku, i Maria Magdala me rɨmɨdmä. Ragwo as akuyöbö mɨj sö mö aku yuö kwo mɨdön röu dumä. ");
INSERT INTO tmd_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Mö i Joana. Nöbönɨŋ nuŋwa ib nuŋwa Kuja. Nuŋ kiŋ Herod rama ap bla nugwidɨx mɨdmɨdöŋa. Mö i Susana. Mö bli kwo mɨga pɨsaŋ yönmɨdmä. Mö adaku ñɨŋ magalɨg rɨg ñɨŋa keir pön, ap mag wob pön hön, Jisas nöbö nuŋ bla pɨsaŋ ap maga nɨgiö nɨgön nɨm yönmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nöbö mö yam rogw diba taun piaku piaku hörɨrör Jisas nuguba hömɨn nugugɨrön, nöbö mö höd hömä akuyöbö ñɨgö mönö i höd röxön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Nöbö i, wit maga wölaŋ, me rön, wit mag aku pön du möriwö rɨb bla aböna. Bli möriwö rɨba uhöb ödöi piaku pɨnaŋ, nöbö mö haŋadɨbat rɨ pikwo pik rɨŋ, yöur bla hö nugwön nɨmöña. ");
INSERT INTO tmd_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Makwam wit mag bli rɨg rol mögö ulul ulul mɨjön piaku pɨnön, mogw bɨrön aku, jɨ rɨg rola mögö aku röbö röbö alɨg mɨden makwam, aŋadö wöröxöna. ");
INSERT INTO tmd_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Makwam wit maga bli nag kaigap mibɨl bla pɨnaŋ, nag aku höu pön pöröbaŋ, wöl ri aben. ");
INSERT INTO tmd_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Jɨ wit mag bli mögö wä rola pɨnön, wöl ri abön, mag mɨga magöri maga cöna. Paŋ paŋ maga padokwo padök mös mös höuöiliö hö wölu amñaxɨb sö (100) yaxönɨŋö,” röŋa. Jisas ñɨgö aliö rön yadöŋa, “Ñɨŋ nöbö mö rɨmɨj möla mɨjön bla, mönö yadmɨdɨl kɨ rɨmɨj pal nugw ri abne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jisas mönö höd röxön haiwo aku urmɨn, nöbö nuŋ bla nugwo yad nugwön yadmä, “Mönö höd röxön yadlö aku, mönö il aku pödpöd rɨg mɨd?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Aliö rɨmɨn, Jisas ñɨgö yadöŋa, “God nöbö mö nuŋwa pön nugwidɨx mɨdɨb mönö umad gɨ mɨdmɨd aku, God ñɨgö rɨbyöx nölaŋ nugwöña, jɨ nöbö mö piaku nɨ ñɨgö mönö höd akwör röxön yadmön, ‘ñɨŋ nugwön nugweñɨm, mönö mag audiöx nugwön mönö ila nugw peñɨm.’ ");
INSERT INTO tmd_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Makwam mönö höd röxön wit mag bla yadɨl aku, God Mönö adaku yadla. ");
INSERT INTO tmd_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Wit mag bli pɨñön möriwö rɨba uhöb ödöi rol, me rɨl aku, nöbö mö akuyöbö God Mönö maga nugwöña aku, jɨ kɨjaki rɨb gwogwo yöxön, ñɨŋ God Mönö aku nugw pɨŋ, God ñɨgö kömö pön aku gwogwo cönɨŋö, rön, hön God Mönö rɨb mag ñɨgö kwo mɨd aku pɨ gɨ du paŋ, uplöböñɨŋö, rön yadla. ");
INSERT INTO tmd_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Wit mag bli pɨñön rɨg rol mögö ulul mɨjön yöraim, me rɨl aku, nöbö mö akuyöbö God Mönö maga nugwön, wahax pɨŋ, wä raŋ nugugɨrön, mönö aku nugw pɨmɨjöña aku, jɨ nugw pɨ cɨcɨ nɨgeñ aku, ömörö bli haŋ uplöbön röböxöñɨŋö, rön yadla. ");
INSERT INTO tmd_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Wit mag bli pɨñön nag kaigap mibɨl piaku, me rɨl aku, nöbö mö akuyöbö God Mönö aku nugwöña aku, jɨ mai ömörö aimönö rɨg ap dib bla aimönö wahaxbör wahax pön rɨb adakwör yöx nugwön, God Mönö nugw pɨ gö nɨgeñɨŋö, rön yadla. ");
INSERT INTO tmd_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Makwam wit mag bli mögörɨb wä rol yöra pɨnön, wöl ri abön, mag mɨga akwör yaxönɨŋö, rɨl aku, nöbö mö akuyöbö God Mönö aku nugwön, nugw pɨ gö nɨgön, rɨp dub adaku, ap mag wä yaxönɨŋö, rön yadlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jisas aliö rön yadöŋa, “Nöbö mö bla hötɨkö urön wi yöj mo möl böisö mönö äbäñ rol hölɨmmɨdöi akum mo bö umadeñɨm. Bɨl yöra sö cɨx nɨg gɨŋ mila abaŋ, nöbö mö akuyöbö ram möl yuadö hön mil aku nugwöña. ");
INSERT INTO tmd_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Mag aliö akuyöbö, ap agap apɨm umad gɨ mɨd akuyöbö, magalɨg wöxnö nɨgöna; ap agap apɨm pöröb gɨ mɨd bla, magalɨg pɨ mil ab yöraku nɨgöna. ");
INSERT INTO tmd_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Makwam, mönö yadmɨdɨl aku nugw ri aböña. Nöbö mö mönö nugwön, nugw pɨmɨjöñ akuyöbö, mönö wä bli kwo nugwöña; jɨ nöbö mö mönö nugwön nugw peñ akuyöbö, ulul mɨŋi nugwölɨŋö röi aku alɨg aŋadö hölögɨpöna. ");
INSERT INTO tmd_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Makwam wop akwör, Jisas nuöma pɨgnɨŋ nöbö pɨsaŋ Jisas nuguba hömä. Hön nugumɨn, ram möl yuadö aku Jisas nöbö mö cɨcɨ rɨg mɨdmä nugwön rɨŋö bö mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Almɨdmɨn, nöbö mö hö ram möl yuadö mɨdim bla nugwön, Jisas nugwo yadmä, “Nam pɨgnaŋ nöbö rɨgɨr nagö nuguba hö mɨdöi rɨŋö bö,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Aliö rɨmɨn, Jisas ñɨgö yadöŋa, “Nöbö mö bɨl kai God Mönö aku nugwön mai duöi blaku, mam na, haul nöbö na mɨdöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Makwam wop i, Jisas nöbö nuŋ akuyöbö ñɨgö yadön yadöŋa, “Ban Yuö Galili möxön ir kwo duŋö,” rön, bɨyöja pön dumä. ");
INSERT INTO tmd_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Jɨ mibɨl kwo dum nugugɨrön, Jisas nuŋ inɨmö hölɨmöŋa. Inɨmö hölɨmöŋ mag aku, hödal ruö ib diba röbö mibɨl aku rɨm rɨm, röbö wödön bɨyöj möl wölmɨn, nöbö piaku wöröxɨb maga akwör röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Almɨn, nöbö nuŋ bla hön, Jisas nugwo ruobɨm öbɨlmɨn yadmä, “Nöbö Dib! An magalɨg wöröxɨba rɨmɨdölɨŋö!” rɨmä. Aliö rɨmɨn, Jisas hödala hömɨdöŋ aku aipam, röbö wöd hömɨdöŋ aku aipam yadyöxmɨn, wop mɨd akwör hödala aku aŋöi nɨgmɨn, röbö wöd hömɨdöŋ aku aŋöi nɨgmɨn, höd rɨg mɨdöŋ aliar mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Makwam Jisas nöbö nuŋ bla ñɨgö yadöŋa, “Ñɨŋ pödpöd rɨmɨn nɨ nugw pölöi?” röŋa. Jisas aliö rɨmɨn, ñɨŋ ipöxön aiö waiö rön, ñɨŋ keir yad nugwob nugwob rön yadmä, “Nöbö kɨ nöbö pödiöm? Nuŋ yadmɨn, hödal aipam, röbö diba aipam mönö nuŋwa rɨg yad mag akwör röiŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Bɨyöja pön, duön Ban Yuö Galili dumɨd dumɨd, mögörɨb Gerasa nöbö mö mɨdmɨdöi pö kwo wölumä. ");
INSERT INTO tmd_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Makwam Jisas bɨyöj aku röböxön, bana rɨb kwo röd nɨgön rɨg jɨmi rola röbmɨn nugugɨrön, wop akwör, ragwo asa öim nɨgɨm mɨdöŋ nöbö i taun akuyöbö hön, Jisas nugwo möigw palöŋa. Nöbö aku nuŋ magör mɨdön, ram yöbö ram möl bla hölɨmmɨdölöŋ; nöbäpö hogw pɨlmɨdim rɨg möl bla akwör hölɨm yönmɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Nöbö nuŋ nugwidɨx mɨdmɨdim bla, nag sena pön iŋ wajmag nuŋ bla nɨg gö nɨgmɨdmä, jɨ ragwo as bla hön ususör rɨm, sen nɨgmɨdöi bla ödörmɨn, mögörɨb ör mibɨl piaku öim öim dumɨdöŋa. Makwam nöbö aku, Jisas nugwo nugwön aiö rön, hön yödpɨlö il yöra pɨn bɨröŋa. Jisas ragwo as yuö nugwo wöl gɨ mɨdim piaku ñɨgö yadöŋa, “Nöbö kɨ röböxön röu di!” röŋa. Jisas aliö rɨmɨn, ragwo as yuö nugwo wöl gɨ mɨdim piaku, ususör rön, mönö diba yadön yadmä, “Nagö Jisas, God Nöbö Dib adöx mɨ bɨl sö mɨd Nöbö aku Ha nuŋwa, nagö nɨ pödpöd rɨba rɨmɨdlö? Nɨ ölɨŋ höb diba pɨ nölmɨjnaŋö!” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Aliö rɨmɨn, Jisas yadöŋa, “Ib nagö urö!” röŋa. Jisas aliö rɨmɨn, nuŋ paiŋö yadöŋa, “Ib na Magöri,” me röŋa. Ragwo as mɨga yuö nugwo wöl gɨ mɨdim makwam aliö yadöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ragwo as bla Jisas nugwo yad gögö rön yadmä, “Anɨŋ bɨ yuö keir yönmɨd ulöm möl hokwö rödölöŋ aku yad abmɨjnaŋö!” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Aliö rön, hön mɨga akwör amñö nɨmmɨdim igöp höñ yöraku nugwön, Jisas nugwo yad gögö rön yadmä, “Naŋ anɨŋ yadaŋ, du hön mɨdöi pikwo yuö wöluŋö,” rɨmɨn, Jisas yöwö röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jisas yöwö rɨmɨn, ragwo as bla nöbö aku nugwo röböxön, du hön ada yuö wölmɨn, hön bla bɨrɨg höñ bö pɨn duön, rɨp du ban yuö bö palön, röbö nɨmön magalɨg wöröx pörmä. ");
INSERT INTO tmd_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Makwam nöbö hön urmɨdim bla, alöŋ aku nugwön, ipalɨp du nöbö mö taun mɨdim akuyöbö ñɨgö yad nölön, du nöbö mö mögörɨb taun il yöra mɨdim akuyöbö ñɨgö yad nölön, rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Yad nölmɨn, ap aku agapɨm rɨmɨn yadmɨdöiŋö, rön, hön nugumɨn, ragwo as yuö wöl gɨ mɨdmɨd nöbö aku, kömö nɨgmɨn, wölɨj yömön, Jisas yödpɨlö il yöra römɨd gɨ mɨdöŋa. Ñɨŋ aku nugwön ölölö rɨmɨn ipöxmä. ");
INSERT INTO tmd_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nöbö mö nugugu mɨdɨm nugugɨrön, Jisas ragwo as yad aböŋ, nöbö mö bla, nöbö mö mai hem akuyöbö ñɨgö, al aliö rö, rön, yad nölmä. ");
INSERT INTO tmd_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Makwam Gerasa nöbö mö magalɨg ölölö rɨm ipöxön, Jisas nugwo, naŋ höbkal duö, rɨmɨn, bɨyöja pön höuöil duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Jisas röböx duba rɨmɨdmɨn nugwön, nuŋ rɨmɨn ragwo as röu duim nöbö aku, nugwo yad gögö rön yadöŋa, “Nɨ nagö pɨsaŋ dinö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Aliö rɨmɨn, Jisas paiŋö nugwo yadöŋa, “Wöhö. God nagö ap wä rɨg rɨ aku, naŋ ram naŋa duön nöbö mö naŋ akuyöbö ñɨgö yad nölö,” röŋa. Makwam, nuŋ taun nuŋwa höbkal duön, nöbö mö bla magalɨg ñɨgö, Jisas nɨ al aliö rö, rön, yad nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Makwam nöbö mö Jisas hömɨdö, rön, pöx mɨdim bla, Jisas bɨyöja pön höröpɨnmɨn, wä hölaŋe, rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Makwam Juda mögum rɨb rama nugwidɨx mɨdmɨd nöbö dib i ib nuŋwa Jairas. Halöu mag paŋyöbö nuŋwa kɨma yöniö pɨnöŋ mɨgan sö nugwön wöröxɨba rɨmɨn, Jairas nuŋ hön, Jisas mɨdöŋ il yöra höxmax yuön yadöŋa, “Ram na dinɨm. Halöu mag paŋyöbö na wöröxɨba rɨmɨdö,” röŋa. Aliö rɨmɨn, Jisas nuguba dumɨn nugugɨrön, nöbö mö mɨga akwör hön, nugwo adöi adöi wabnaŋnaŋ rɨp dumä. ");
INSERT INTO tmd_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Jɨ mö i öim öim nuŋ mö ödöi dumɨda kɨma yöniö mɨgan sö pɨnöŋa. Mö aku, uj wobɨb nöbö bla nɨ rɨŋ, nɨ kömö nɨgaŋ, me rön, ñɨgö rɨg nölöŋa, jɨ nugwo rɨm wödö wölɨb maga rölöŋ. ");
INSERT INTO tmd_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nuŋ Jisas dumɨdöŋ höglöm ada hön, wölɨj dib mɨxɨla röb gɨ mɨdöŋ aku pɨ nugumɨn nugugɨrön, wop akwör nugwo wä röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Makwam Jisas ñɨgö yadöŋa, “Nɨ nöbö kai pɨ nugw?” röŋa. Jisas aliö rɨmɨn, nöbö mö bla yadmä, “An pɨ nugwölölɨŋö,” rɨmä. Jɨ Pita yadöŋa, “Nöbö Dib, nöbö mö kɨyöbö mɨga akwör hön, nagö wabnaŋnaŋ rɨmɨdöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Aliö rɨmɨn, Jisas yadöŋa, “Nöbö i nɨ pɨ nugwa. Ölɨsö nɨ aku dum nugwön yadmɨdlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Jisas pɨ nugwöŋ mö aku, nuŋ umadɨb maga nɨgölöŋ aku nugwön, gɨl gɨl rɨ gɨrön, Jisas mɨdöŋ il yöra hö höxmax yuöŋa. Nöbö mö nugugu mɨdim mibɨl aku, mö aku Jisas nugwo yadön, nuŋ ap rɨmɨn, Jisas pɨ nugumɨn, wop akwör wä röŋ aku magalɨg wöxnö yadöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Aliö rɨmɨdmɨn, Jisas nugwo yadöŋa, “Halöu na. Naŋ nɨ pɨ nugumön wä cönɨŋö, rön, nugw pɨlö aku, nɨ pɨ nuguman wä rɨ maku pal. Mönö mɨdöl. Naŋ duön, God imag iŋsö rola mɨdane,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisas aliö rɨmɨn nugugɨrön, Jairas mabö rɨ nölmɨd nöbö i hön, Jairas nugwo yadöŋa, “Halöu naŋ aku mɨ wöröxa; yad nölɨb nöbö nugwo yadaŋ yödpɨlö ölɨŋa wöröxɨp henmöm; höbkal duaŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Aliö rɨmɨn, Jisas mönö aku nugwön, Jairas nugwo yadöŋa, “Halöu na aku wöröxö, rön, rɨb diba yöx nugumɨjɨnö. Naŋ nugw pɨmɨjɨnö aku, nugwo kömö nɨgönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jisas aliö rön, Jairas rama uröpɨnön, nöbö mö bla ñɨgö magalɨg yad rɨŋö bö nɨgön, halöu nuö nuöm hogwa pön, Pita, Jon, Jems ada yölɨŋön, halöua nuguba ram möl yuadö dumä. ");
INSERT INTO tmd_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nöbö mö, halöu aku wöröxö, rön, immɨdim bla, Jisas ñɨgö yadöŋa, “Ñɨŋ immɨjeñ. Halöu aku wöröxöl; hör inɨmö hölɨm gɨ mɨdö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Jisas aliö rɨmɨn, nöbö mö akuyöbö, halöu aku aŋadö mɨ wöröxöŋa nugwön, nugwo yad imöumä. ");
INSERT INTO tmd_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jɨ Jisas halöu aku imaga pön yadöŋa, “Halöu na öbɨlö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Aliö rɨmɨn, inöm nuŋwa hö yöra rɨgɨba rɨm öbɨlöŋa. Öbɨlmɨn, Jisas yadöŋa, “Ap bli nölɨŋ nɨmaŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Halöu nuö nuöm hogwa ñɨŋ aiö waiö rɨmä. Jɨ Jisas ñɨgö mönöbö hogwa yadöŋa, “Ñɨŋ nöbö mö bli mönö aku yad nölmɨjeñ, wöhö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","2","Jisas nöbö nuŋwa akuyöbö möl sö ñɨgö yadmɨn hömɨdmɨn yadöŋa, “Nɨ ñɨgö nöbö nɨ, ölɨsö na keir nölön, agal abɨba rɨmɨdla. Makwam, ñɨŋ piaku piaku duön, ragwo as nöbö mö yuö wölön mɨdöi akuyöbö yadɨŋ, röu diöña; nöbö mö ap rɨ bla rɨŋ, kömö nɨgöna; nöbö mö wöj pɨlmɨdöi bla rɨŋ, wä cöna; God nöbö mö pön nugwidɨx mɨdɨb mönö wä aku yad nölɨŋ, nugwöña. ");
INSERT INTO tmd_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Makwam duba rön, sauö rɨb, yogw, ap nɨmɨb, rɨg, wölɨj, ap bla alɨg pɨrag dumɨjeñ; hör diöña. ");
INSERT INTO tmd_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Taun i duön ram i uröpɨnɨŋ, ñɨgö yad pɨmɨdɨŋ, ñɨgö pɨsaŋ hölɨmön mɨdön, taun aku röböx duŋö, cöñ aku, wop akwör röböx diöña. ");
INSERT INTO tmd_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Makwam mögörɨb möl i duŋ, ñɨgö yad pɨmɨdölɨŋ, taun aku röböx duŋö, cöñ aku, ñɨŋ nugu mɨdɨŋ yajöña, ‘Mönö wä pön höla pölöi aku, mögörɨb ñɨgö kɨ hömɨdmɨn, ap bɨcep cep yamsö anɨŋa cɨrɨp aku örɨx abön dumɨdölɨŋö,’ rön, örɨx abön diöña. Almɨdɨŋ, ñɨŋ mag gwogwo röi aku nugwöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jisas aliö rɨmɨn, ñɨŋ du ram yöj lɨglɨg agrö piaku piaku magalɨg yönön mönö wä aku yad nöl gɨrön, nöbö mö wöj pɨlɨm mɨdim bla rɨm kömö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Makwam nöbö mö akuyöbö, Jisas agap apɨm röŋ mönö aku yad nölɨp yönɨm nugugɨrön, gapman nöbö dib Herod nugwön, rɨb mɨga yöxöŋa. Nöbö mö bli yadmä, “Röbö pal nölɨb nöbö Jon göliöda römaxdörɨm wöröxöŋ nöbö aku höuöil öbɨlö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bli yadmä, “God mönö yadɨb nöbö hödyöbö Ilaija nuŋ hö,” rɨmä. Bli yadmä, “Maduö nöbö God mönö yadmɨdöi akuyöbö i höbkal kömö nɨgön hö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Aliö rɨmɨn, nöbö dib Herod yadöŋa, “Jon nugwo göliöda römaxdörmɨn mödö wöröxöŋ makwaim, nöbö aku nöbö kai hö mɨdmɨn nugwön yadmɨdöi aku nɨ keir du nugunö,” rön, rɨb aku yöx nugwöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Makwam Jisas nöbö nuŋwa akuyöbö möl sö höuöil hön, mögörɨb piaku yönön ap rɨg rim mönö aku Jisas nugwo yad nölmä. Yad nölmɨn, du möl i keir mɨjnɨŋö, rön, Jisas nuŋ ñɨgö yölɨŋön Betsaida tauna dumä. ");
INSERT INTO tmd_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Makwam ödöi mibɨl piaku dumɨdɨm nugugɨrön, nöbö mö bli yadmä, “Jisas nöbö nuŋ bla pɨsaŋ hö dumɨdöiŋö,” rɨmä. Aliö rɨmɨn, nöbö mö mɨga akwör nugwo nuguba mai dumä. Hömɨdmɨn, nuŋ wä höiŋö, rön, God nöbö mö pön nugwidɨx mɨdɨb mönö aku ñɨgö yad nöl gɨrön, nöbö mö ap röŋ bla rɨmɨn kömö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Makwam pɨgöm naiö röd pɨba rɨmɨdöŋ mag aku, nöbö nuŋwa akuyöbö möl sö hön, Jisas nugwo yadmä, “Mögörɨb bɨlɨk, nöbö mö mɨdölöi, mögörɨb ör mibɨl yörɨk mɨdöl aku, nöbö mö bɨlɨk ñɨgö yad abaŋ, nöbö mö mɨdöi ram piaku hörɨrör duön, ap nɨmɨb ñɨŋ bla keir hölu nugwön, hölɨmɨb yör bla hölu nugwɨŋ,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Aliö rɨmɨdmɨn, Jisas paiŋö yadöŋa, “Ñɨŋ keir nöbö mö piaku ap mag nöine,” röŋa. Jisas aliö rɨmɨn, ñɨŋ yadmä, “An ap mag mɨga mɨdöl. Hör bred mag akuyöbö mömɨd sö mɨdɨm, dölöm mös mɨda. Naŋ agö rɨbɨm yöx nugulö? Nöbö mö pik mɨga akwör mɨdöi aku, an du ap mag ñɨgö bli wob rag hönɨŋönö ä?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Wop aku, nöbö mö hön mögum rim piaku, mö halöu ha piaku wöhö, nöbö piakwör iŋ wödmɨdmɨn paip tausan (5000) duöŋa. Makwam Jisas nöbö nuŋ akuyöbö ñɨgö yadöŋa, “Nöbö mö mɨga akwör hö mɨdöi pik yadɨŋ, nöbö mö akuyöbö padokwo mös höuöiliö igwö sö (50) rogw hörɨrör römɨdɨŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jisas aliö rɨmɨn, nöbö nuŋ bla nuŋ rɨg yadöŋ mag akwör rɨm, nöbö mö bla magalɨg yöraku römɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nuŋ bred mag akuyöbö mömɨd sö pön, dölöm hogwa alɨg pön, laxiö pisö rɨ adöx yöd röul adö kau sö nugwön, God nugwo ri ablaŋe rön, ap nɨmɨb aku pɨ gɨlɨxön, nöbö nuŋ pia nölmɨn, ñɨŋ piöŋö pön nuöm nɨgön nöbö mö nölmä. ");
INSERT INTO tmd_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nölmɨn, ñɨŋ magalɨg nɨmɨp duön, nɨm pörɨb maga nɨgölmɨn, rɨb rɨb röbö röböxɨp rim bla, nöbö nuŋ bla pɨ yogw akuyöbö möl sö piöxmɨn aja wölöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Makwam wop i, Jisas nuŋwör keir du mɨdön God höjöpal pörön, nöbö nuŋ akuyöbö ñɨgö yad nugwön yadöŋa, “Nöbö mö ñɨŋ nɨ nöbö kai me rön rɨbyöx nugwöiŋö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Jisas aliö rɨmɨn, yadmä, “Nöbö mö bli naŋ röbö pal nölɨb nöbö Jon aku, me rön, rɨbyöx nugwöia; bli God mönö yadɨb nöbö hödyöbö Ilaija, me rön, rɨbyöx nugwöia; bli maduö nöbö God mönö yadmɨdöi akuyöbö i höbkal kömö nɨgön hö, rön, rɨbyöx nugwöiŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Aliö rɨmɨn, Jisas ñɨgö paiŋö yad nugwöŋa, “Makwam ñɨŋ keir nɨ nöbö kai me rön rɨbyöx nugwöi?” röŋa. Jisas aliö rɨmɨn, Pita paiŋö yadöŋa, “Nagö God Krais nuŋ aku,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Aliö rɨmɨn, Jisas ñɨgö yadöŋa, “Mönö aku nöbö mö bli yad nölmɨjeñ, mɨ wöhö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jisas aliö rön, mönö i yadön yadöŋa, “Nöbö Ha nuŋwa nugwo ölɨŋ höb diba ödöriö pɨ nöiöña. Nöbö mönö pɨ nuöm nɨgɨb bla, God ap höjöpal ur nölɨb nöbö dib bla, lo mönö yad nölɨb nöbö bla, nugwo nugwɨŋ ölɨsö wölaŋ pɨl pal nɨg gɨŋ wöröxön aku, jɨ wop mös mɨdön aiaŋ wop paŋ aku höbkal öbiönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Makwam Jisas nöbö nuŋ bla aipam, nöbö mö mɨdim bla aipam, ñɨgö magalɨg yadön yadöŋa, “Nöbö mö nɨ mai dinɨŋö, rön rɨbyöx nugumɨjöñ bla, ap mögörɨb rol il kɨ rɨb diba yöx nugwöi aku röböxön, mɨxɨñ ñɨŋa keir rɨb diba yöx nugwöi aku röböxön, wop paŋ paŋ bɨ katlö watlö waba pɨ ragpɨd nɨg rag nɨ mai höŋ. ");
INSERT INTO tmd_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nöbö mö kai, mɨxɨñ, kömö mɨdɨb mag ana keir rɨbyöx nugwön mɨd ri abnɨŋö, rön, rɨbyöx nugwöñ bla, aŋadö pɨn bɨcöña. Makwam nöbö mö kai, Jisas nugw pön, mɨxɨñ, kömö mɨdɨb mag ana agö magɨm cön aku mönö mɨdölö, rön, rɨbyöx nugwöñ bla, kömö mɨdɨb maga pöña. ");
INSERT INTO tmd_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nöbö mö ap mögörɨb rol il kɨ pɨnɨŋö, rön, rɨŋ diön bla, ap wä wä bla pön, mögörɨb rol il kɨ mɨd ri aböña, jɨ mai wöröxön mögörɨb mɨgrö kɨ röböxön, God pɨsaŋ öim öim mɨdɨbä maga mɨden. ");
INSERT INTO tmd_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nöbö mö yön nɨ möigw yöxön, nɨ Jisas nugwo nugumɨdöiö, rön, mönö na nugw pen aku, mai Acö an nuarö mil mag wä keiryöbö aku pön, ejol lei bla mil wä alɨg hön wop aku, nöbö aku nuŋ möigw yöxön, nugumɨdöiö, cɨna. ");
INSERT INTO tmd_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Makwam ñɨgö mi yadmɨdla, nöbö mö weik mɨdöi kɨyöbö bli wöröxeñ; kömö ör mɨdɨŋ, God nöbö mö pön nugwidɨx mɨdɨb wop aku nugwöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jisas aliö rön, wop akuyöbö amñaxɨb sö mɨdön, Jon, Jems, Pita ñɨgö yölɨŋön, God höjöpalɨba rön pɨd yöraku duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Duön, God höjöpal gɨr mɨdɨm, haŋaj mäp yuö nuŋwa keiryöbö wöxnö nɨgɨm, wölɨj nuŋwa lei gudogudö mɨda röxgön mil mag keiryöbö mɨdöŋa, nugumä. ");
INSERT INTO tmd_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Almɨn nugugɨrön, nöbö maduar ör wöröxɨm, Mosɨs Ilaija yöŋö, God mil wä keiryöbö mag aku alɨp hön, Jisas Jerusalem duön wöröxön mabö nuŋwa rɨ pörɨba rɨmɨdöŋ mönö aku yad mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Makwam Pita, Jems, Jon nöbö ada inɨmö pɨlɨm, mämäga ipax ipax röxiö rɨ gɨr mɨdmä, jɨ mɨdön ñɨŋ mämäga ix nugumɨn, Jisas mil wä nuŋ aku aipam, nöbö hogw aku Jisas pɨsaŋ öbɨl gɨ mɨdmä aku aipam, nugumä. ");
INSERT INTO tmd_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nöbö hogw aku duba rɨm nugugɨrön, Pita rɨbyöx nugw ri abön wöhö, Jisas nugwo yadöŋa, “Nöbö Dib, an yörɨk mɨdöl aku wä mɨdöla. Nagö anɨŋ yöwö ran, ram bötö hör mös paŋ, nagö i, Mosɨs nugwo i, Ilaija nugwo i cɨnɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Aliö rɨmɨn nugugɨrön, wop akwör, mɨjöi lei dib wab i hön ñɨgö magalɨg yuö abmɨn ipöxmä. ");
INSERT INTO tmd_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Makwam mönö i mɨjöi yuö yör sö pik yadön yadöŋa, “Nöbö kɨ Ha nɨ; nɨ nugwo yad nɨgma. Ñɨŋ mönö nuŋ yajön akuyöbö nugune,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mönö yad pörɨm, mag akwör nugumä, nöbö hogw aku mɨdölɨmem; Jisas nuŋwör mɨdöŋa. Makwam önöŋ ajmag pɨd sö mɨdön, ap rɨg röŋ aku nugwön, wop mibɨl yöraku nöbö mö bli yad nölölim. ");
INSERT INTO tmd_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Makwam löumɨn, önöŋ ajmag sö röböxön, ödöi aku pibö i pɨn dumɨn nugugɨrön, nöbö mö mɨga hö ñɨgö möigw palmä. ");
INSERT INTO tmd_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nöbö i nöbö mö mibɨl yöraku wö diba rön yadöŋa, “Mönö yad nölɨb nöbö. Ha paŋyöbö nɨ kɨ, nagö ögwö yöxane, rön, pön höla. ");
INSERT INTO tmd_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ragwo as öim nugwo yuö wöl mɨdön nugwo rɨm, aiö diba rön rɨp du palön, höpöl höbwa röpnɨm, wöröx gögöidö pɨlmɨda. Nugwo akuyöbö alön, öim öim rɨm rɨm, nuŋ ölɨŋ höb pɨmɨda. ");
INSERT INTO tmd_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nöbö nagö akuyöbö ñɨgö, ragwo as mɨd aku yad abɨŋ, me rɨl aku, jɨ ñɨŋ yad ab wöhö nugwön röböxöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Aliö rɨmɨn, Jisas yadöŋa, “Nöbö mö weik mögörɨb il kɨ mɨdöi aku, wop kai mönö nugw pöñ? Nɨ maduar ör ömörö ñɨŋa pɨp yönla; jɨ mai wop pödpödiö nɨ ömörö ñɨŋa pɨp din?” röŋa. Jisas aliö rön, nöbö aku nugwo yadöŋa, “Ha naŋ aku il yörɨk pön hö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Jisas aliö rɨmɨn, ha aku pɨrag höm nugugɨrön, ragwo asa ha aku nugwo mɨ usus rön, pal wöd abmɨn rɨp du pɨn bɨröŋa. Jisas nuŋ ragwo as aku nugwo yadyöxɨm, hör dumɨn nugugɨrön, ha aku kömö nɨgmɨn, Jisas ha pön du nuö nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nöbö mö hö gɨ mɨdim bla, God ölɨsö maga nugwön, aiöuñ rɨmä. Jisas ap agap apɨm röŋ aku rɨbyöx nugwön, ñɨŋ aiöuñ rön nugugu mɨdɨm nugugɨrön, Jisas nöbö nuŋ akuyöbö ñɨgö yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mönö yadɨba rɨmɨdɨl kɨ, ñɨŋ rɨmɨj pal nugw ri abön mɨjöña. Womiöx mɨda, Nöbö Ha nuŋwa nugwo höuöu rön, nöbö adö bli nöiöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Makwam mönö yadöŋ aku, ñɨŋ röx nugub maga mɨdölöŋ. Makwam ipöxön Jisas nugwo yad nugwölim. ");
INSERT INTO tmd_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jisas nöbö nuŋ adaku ñɨŋ keir yadɨp duön, nöbö i yadöŋa, “Nɨ nöbö diba mɨjɨnö,” röŋa. Jɨ nöbö i paiŋö yadöŋa, “Nagö yöi, nɨ nöbö diba mɨjɨnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jisas nöbö nuŋ bla rɨbyöx nugwim aku nuŋ keir nugwön, ha ulmɨdö i rag hö nuŋ mɨdöŋ höñ yöra nɨgön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“Nöbö mö kai nɨ rɨbyöx nugwön, ha ulmɨdö kɨyöbö röxg pön aku, nɨ aipam pöna. Jɨ nöbö mö kai nɨ pön aku, Nöbö nɨ yad abmɨn höma aku aipam pöna. Makwam nöbö kai mibɨl ñɨŋ yöra haŋal mɨdöy röxg mɨd, nöbö akwör nuŋ nöbö dib ödöriö,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jisas aliö rɨmɨn, Jon yadöŋa, “Nöbö Dib, an nugwöla, nöbö i ib nagö urön, ragwo as bla yad aböŋa. Makwam nöbö aku an pɨsaŋ yönölöl aku, ‘Naŋ al mɨjɨnö,’ rɨmɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Aliö rɨmɨn, Jisas yadöŋa, “Pödpöd rɨmɨn nugwo aliö wöhö rim? Nöbö mö ñɨgö nugwɨŋ ölɨsö wölen bla, nöbö nugub an, me rön nugune,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Makwam Nuö nuŋwa Jisas nugwo pön du mögörɨb nuŋwa adöx yöd röul adö kau sö pön dub wop aku womiöx höm nugwön, Jisas Jerusalem dinö, rön, rɨb ölɨsö yöx nugu gɨrön duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nuŋ nöbö nuŋ bli höd yad aböŋa. Ñɨŋ duön ap nugwo rɨ pɨdɨluba, mögörɨb Sameria mibɨl yöra ram yöj lɨglɨg agrö i dumä. ");
INSERT INTO tmd_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Makwam Sameria nöbö mö ram yöj lɨglɨg agrö aku hölɨmmɨdöi piaku, Jisas Jerusalem duba rɨmɨdöŋ mönö aku nugwön, nugwo yad wahax pölim. ");
INSERT INTO tmd_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Almɨdɨm, Jisas nöbö nuŋ mös Jems Jon yöŋö nugwön, Jisas nugwo yadmä, “Nöbö Dib, adöx yöd röul adö kau sebö rɨn pina yadɨŋ, pɨnön nöbö mö alöi akuyöbö ñɨgö yöñönɨŋönö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Aliö rɨmɨn, Jisas höuöiliö nöbö hogwa nugwön, mag akuyöbö alöinɨŋö, rön, ñɨgö nöbö hogwa yadyöxön röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nöbö mö piaku Jisas nugwo peñ aku nugwön, ram yöj lɨglɨg agrö aku röböxön, ram yöj lɨglɨg agrö hör i dumä. ");
INSERT INTO tmd_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Makwam ödöi mibɨl piaku dumɨdɨm nugugɨrön, nöbö i hön, Jisas nugwo yadöŋa, “Mögörɨb pikai pikai dinö piaku, nɨ pɨsaŋ yönmɨjnɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Aliö rɨmɨn, Jisas nugwo yadöŋa, “Nɨ pɨsaŋ öliöxɨp yönmɨjɨnö. Wöñö höpebö bla ram hölɨmɨb ñɨŋa mögö möl bla mɨda; yöur bla rin ñɨŋ aku keir mɨda; makwam Nöbö Ha nuŋwa, hölɨmɨb yör nuŋ i mɨdölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Makwam Jisas nöbö i nugwo yadöŋa, “Nagö nɨ pɨsaŋ yönmɨdɨŋö,” röŋa. Aliö rɨmɨn, nöbö aku paiŋö yadöŋa, “Nöbö Dib, nɨ yöwö ran, nɨ du acö na hogw pɨlön hönö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Aliö rɨmɨn, Jisas nugwo paiŋö yadöŋa, “Nöbö mö nɨ nugw pölöi bli wöröxmɨjöñ aku, nöbö mö nɨ nugw pölöi bli pön du hogw piöña. Nagö duön, God nöbö mö pön nugwidɨx mɨdɨb mönö aku yad nölaŋ duaŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Makwam nöbö i yadöŋa, “Nɨ nagö pɨsaŋ yönmɨjnɨŋ aku, jɨ nɨ yöwö raŋ, du acö mam, haul nöbö mölöu nöbö nɨ akuyöbö ñɨgö mönö yad nöl ri abön, iŋ palön, hönö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Aliö rɨmɨn, Jisas paiŋö yadöŋa, “Nöbö mö kai mabö rɨba ila nɨgön, rɨb mɨga yöxön, um yöra röböxön aku, God nöbö mö pön nugwidɨx mɨdɨb mönö wä aku yad nölɨb nöbö mabö aku rɨbä maga nɨgölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Mai Jisas nöbö nuŋwa padokwo padök mös paŋ höuöiliö hö igwö wölö (72) pön, ñɨgö nuöm nɨgön mös keir, mös keir, mögörɨb bla hörɨrör yad abɨba rön yadöŋa, “Ñɨŋ höd duön, mönö na aku yad nölɨŋ, nɨ mai inö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Makwam ñɨgö mönö i yadöŋa, “Möriwö ap maga u gɨ mɨd aku, jɨ nöbö mö ap maga pɨliöx rag höb akuyöbö mɨga mɨdölöi. Makwam, Nöbö Dib möriwö rɨb mɨnöbö aku nugwo yad nugwɨŋ, nöbö mö ap mag pɨliöx rag höb bli kwo yadaŋ du pɨliöx rag höŋ. ");
INSERT INTO tmd_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ñɨŋ di! Jɨ ñɨgö hön sipsip ha röxg wöñö höpebö mɨdöi mibɨl yöra yad abmɨdla. ");
INSERT INTO tmd_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ñɨŋ rɨg uñ, yogw, yam uñ bla alɨg pɨrag dumɨjeñ. Nöbö mö bli pɨsaŋ ödöi mibɨl yöra mönö mɨxɨla nɨgmɨjeñ. ");
INSERT INTO tmd_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Makwam ram i uröpɨnön, ram möl yuadö du gɨrön, ñɨgö mönö wä yad nölön yajöña, ‘God ñɨgö nugwidɨx mɨdaŋ,’ me ri. ");
INSERT INTO tmd_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aliö yadmɨdɨŋ, nöbö mö mönö höimöliö yadɨb i ram aku mɨjön aku, mönö höimöliö yajöñ aku yöxöna. Nöi mɨjön aku, mönö höimöliö yajöñ aku höuöil ñɨgö keir höna. ");
INSERT INTO tmd_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Makwam ram akwör mɨjöña, ap mag rag hö nöiöñ aku nɨm gɨrön mɨjöña. Nöbö mabö röi bla paiŋö höj rɨm pöia. Alöi mag akuyöbö, ñɨgö mönö wä aku yad nöiöñ aku, ñɨŋ paiŋö ñɨgö ap maga cöña. Makwam ñɨŋ ram ram yönmɨjeñ. ");
INSERT INTO tmd_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Taun i dumɨdɨŋ, ñɨgö yad wahax pön, ap mag nöiöñ aku, nɨmöña. ");
INSERT INTO tmd_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mögörɨb aku, nöbö mö ap cön bla ñɨgö rɨŋ, kömö nɨgöna. Nöbö mö bla magalɨg ñɨgö yad nöl ri abön yajöña, ‘God nöbö mö pön nugwidɨx mɨdɨb aku, yödpɨlö il ñɨŋ yöra hö,’ cöña. ");
INSERT INTO tmd_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Jɨ taun i dumɨdɨŋ, ñɨgö yad wahax pɨmɨdölɨŋ, ödöi mibɨl yöra du gɨrön yajöña, ");
INSERT INTO tmd_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Mögörɨb ñɨgö kɨ hömɨdmɨn aku, hauya bɨcep cep yödpɨlö ana cɨrɨp bla örɨx ñɨŋ keir rola abön dumɨdöla. Makwam nugw ri abi! God nöbö mö pön nugwidɨx mɨdɨb aku, yödpɨlö il ñɨŋ yöra hö,’ cöña. ");
INSERT INTO tmd_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nɨ ñɨgö yadmɨdla, mai mönö diba nugwöñ wop aku, taun dib Sodom nöbö mö ap kib mag gwogwo akwör rɨŋ rɨŋ yönu har nɨmɨm duöŋ aku, mönö diba nugwön ölɨŋ höb ulul mɨda pöña; makwam nöbö mö ñɨŋ du mönö yadɨŋ peñ bla, mönö diba nugwön ölɨŋ höb diba pöña. ");
INSERT INTO tmd_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Korasin nöbö mö bla aipam, Betsaida nöbö mö bla aipam, ap rölɨbä akuyöbö rɨmön, nugwön röböxöi aku, ölɨŋ höb diba pöña. Makwam taun dib mös Taia Saidon nöbö mö akuyöbö ñɨgö, ap rölɨbä akuyöbö bli rɨmön nugwöyɨx aku, ñɨŋ wölɨj ödör pɨn bli yömön römɨdön, rɨn hauya röd ab gɨr röd ab gɨr mɨd gɨrön, ap gwogwo rɨmɨdöi akuyöbö röböxöyɨxa. ");
INSERT INTO tmd_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mönö diba nugwöñ wop aku, Taia Saidon nöbö mö bla ölɨŋ höb ulul akuyöbö pöña; makwam ñɨŋ Korasin nöbö mö bla aipam, ñɨŋ Betsaida nöbö mö bla aipam ölɨŋ höb dib ödöriö pöña. ");
INSERT INTO tmd_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Makwam wop aku, ñɨŋ Kapaneam nöbö mö bla algör ör, adöx yöd röul adö kau sö dueñ; aŋadö ulöm möl dib bö diöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jisas nöbö nuŋ pia yadöŋa, “Nöbö mö mönö ñɨŋa pöñ akuyöbö, mönö ñɨgö akwör yöi, mönö nɨ aku algör pöña. Makwam ñɨgö peñ akuyöbö, ñɨgör yöi, na algör peñɨm. Makwam nɨ peñ akuyöbö, nör yöi, Nöbö nɨ yad abmɨn höm aku nugwo algör peñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Makwam mai nöbö nuŋwa padokwo padök mös paŋ höuöiliö hö igwö wölö (72) adaku, mögörɨb piaku yön pörön höuöil hön, wä rö rɨ gɨrön Jisas nugwo yadmä, “Nöbö Dib! Ragwo as nöbö mö yuö wölöi bla, ib nagö urön, ‘Jisas mɨd makwam di!’ rɨmɨn, rɨg yadöl akuyöbö nugwön duöiŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Aliö rɨmɨdmɨn, Jisas ñɨgö yadöŋa, “Nɨ nugugu mɨdmön nugugɨrön, ragwo as nuö ñɨŋa Seten, añɨgölö röxg pön adöx yöd röul adö kau sebö hö pɨna. ");
INSERT INTO tmd_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ñɨgö yad nɨgɨl makwam, kas möjögöñɨñ, möplogum, hakai, ap gwogwo bla aipam, Nöbö Kwolmal ölɨsö nuŋ aku aipam, ñɨgö rɨ gwogwam rɨbä maga nɨgöl. ");
INSERT INTO tmd_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Makwam ragwo as bla yadöl akuyöbö nugwön röu duöiŋö, rön, wahax pɨmɨjeñ; God nuŋ ib an adöx yöd röul adö kau sö kai kɨt nɨgö, rön, wahax pɨ mɨjɨnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mag aku, Inöm Leia Jisas nugwo aja wölmɨn nugugɨrön, nuŋ wahax pɨ gɨrön, Nuö nuŋwa yadöŋa, “Acö, nagö Nöbö Dib adöx yöd röul adö kau sö aipam, mögörɨb il kɨ aipam nugwidɨx mɨdlö aku, rɨb naŋa keir nuguman wä rɨ adakwör rɨlö. An nöbö mö dib, an keir rɨbyöx nugw ri abölɨŋö, rön nugwöi akuyöbö, naŋ ñɨŋ mönö wä il aku yabuöiö, jɨ halöu ha ulul bla, naŋ ñɨŋ rɨb wä nölman, mönö wä il aku nugwöi aku mɨ, nagö wä rɨlaŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jisas aliö rön yadöŋa, “Nöbö mö bli nɨ nöbö pödiöm mɨdɨl aku nugwölöi; Acö nuŋwör nɨ nugwa. Makwam Acö nuŋ nöbö pödiöm mɨd aku, nöbö mö bli nugwölöi; nɨ keir ör nugula. Nuŋ nɨ ölɨsö ap nuŋ bla magalɨg nöl aku, nöbö mö ñɨgö yabunö cɨn piakwör, ñɨgö Acö yabumön nugwo nugwöña. Nöbö mö bli kwo Acö nugwo nugweñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jisas aliö rön, höuöiliö, nöbö nuŋ piakwör ñɨgö yadön yadöŋa, “Ap kɨ nugumɨdöi aku, wahaxbör wahax pɨmɨjöña. God ñɨgör mɨ pɨ ri abön rɨm nugumɨdöia. ");
INSERT INTO tmd_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","God mönö yadɨb nöbö bla mɨga akwör nɨgön, kiŋ bla mɨga akwör nɨgön, ap mämäga nugumɨdöi kɨ nuguŋö, rön, pöx mɨdmɨdöi aku, jɨ ñɨŋ nugwölöi; mönö audiöx nugumɨdöi kɨ nuguŋö, rön, pöx mɨdmɨdöi aku, jɨ ñɨŋ nugwölöi. ");
INSERT INTO tmd_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wop i mibɨl yöra, lo mönö yad nölɨb nöbö i, Jisas nɨ agö mönö yajönɨŋö, rön, hön nugwo yad nugwön yadöŋa, “Mönö yad nölɨb nöbö, nɨ pödpöd rön, öim mɨdɨb mag aku pɨn?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Aliö rɨmɨn, Jisas nugwo yadöŋa, “Lo mönö aku kai kɨtön, pödi yadöiŋö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Jisas aliö rɨmɨn, lo mönö yad nölɨb nöbö aku yadöŋa, “Lo mönö aku nugula, Mosɨs kai kɨtön yadöŋa, ‘God Nöbö Dib nagö aku nugwo mɨ wahax pön, rɨb mag nagö aku nugwo nölön, ölɨsö nagö piaku magalɨg nugwo nölön, nugwo mɨ ödöriö madmag nɨgö. Naŋ naŋ keir madmag rɨg nɨglö mag akuyöbö, nöbö mö hör akwebö algör ör madmag nɨganö,’ rö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Aliö rɨmɨn, Jisas nöbö aku nugwo yadöŋa, “Nagö ödöriö yadlö; adakwör rön, öim mɨdɨb maga pɨnaŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Jisas aliö rɨmɨn, lo mönö yad nölɨb nöbö aku, ib na pɨn diönɨŋö, rön, Jisas nugwo iswob yad nugwön yadöŋa, “Lo mönö kɨtöŋ aku, nöbö mö madmag nɨgne, rön, kai kɨtöŋa. Makwam, nöbö mö bɨl kai ñɨgö madmag nɨgne, rön, kai kɨtöŋ?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Aliö rɨmɨn, Jisas lo mönö yad nölɨb nöbö aku nugwo mönö paiŋö yad gɨrön, haiwo i pön yadöŋa, “Nöbö i Jerusalem röböxön, taun dib Jeriko dinö, rön, ödöi mibɨl yöra dumɨdöŋa nugwön, nöbö ap kib pɨb bli hön, nugwo mɨ göj palön, wölɨj ap nuŋ bla mɨdau pön dumɨn nugugɨrön, nuŋ ödöi mibɨl yöra wöröxɨba rön rɨ mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","God ap höjöpal ur nölɨb nöbö i, ödöi aku duön, nöbö aku wöröxɨba rön rɨmɨdöŋ yöra nugwön, ödöi nɨgön pedöx pedöxɨp duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Makwam nöbö Lipai ada nöbö i, ödöi akwör duön, nöbö aku wöröxɨba rön rɨmɨdöŋ yöra nugwön, nuŋ algör pedöx pedöxɨp ödöi nɨgön duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Makwam Juda nöbö yöi, mögörɨb Sameria yöbö nöbö i, ödöi mɨxɨl paŋyöbö akwör duön, nöbö aku wöröxɨba rön rɨmɨdöŋ yöra nugwön, nugwo mɨ ödöriö ögwö yöxöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nugwo mɨ ödöriö ögwö yöxön, mɨdöŋ il yöra duön, uj nugwo bla wel röbö bli pɨlön, röbö wain bli pɨlön, woböŋa. Uj nuŋ bla wobön, pɨ donki rol nuŋ sö nɨgön, rɨg wobön hölɨmmɨdöi rama pön du nɨgön, nugwidɨx mɨd ri abön röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Löum yöbö dinöb rön, nöbö rama nugwidɨx mɨdmɨd aku nugwo silpa palö mös nölön yadöŋa, ‘Nagö nöbö kɨ nugwo nugwidɨx mɨdön ösös rɨ ri abö. Makwam rɨg pödiöm yajɨnö aku, höuöil hön nagö nöinö,’ rö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jisas haiwo aku pön, nuŋ lo mönö yad nölɨb nöbö aku nugwo yad nugwöŋa, “Nöbö ödöi mibɨl yöra pal nɨgim aku, nöbö mös paŋ padɨx gɨrön duim bla, nöbö kai nuŋ nuŋ keir madmag nɨgöŋ aliar, nöbö aku nugwo madmag nɨgöŋ?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Jisas aliö rɨmɨn, lo mönö yad nölɨb nöbö aku yadöŋa, “Nugwo ögwö yöxön ösös rɨ ri ab nölöŋ nöbö aku,” me röŋa. Aliö rɨmɨn, Jisas nugwo yadöŋa, “Mi yadlö makwam, mɨ nagö duön, mag akwör rane,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Makwam Jisas nöbö nuŋ bla pɨsaŋ mögörɨb i uröpɨnmɨn, mö mögörɨb aku mɨdöŋ i hön, ñɨgö yölɨŋ pön ram nuŋwa duöŋa. Mö aku ib nuŋwa Mata. ");
INSERT INTO tmd_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Pɨgnɨŋ nuŋ aku rama mɨdöŋa. Ib nuŋwa Maria. Maria nuŋ Jisas mɨdöŋ il yöra hö römɨdön, Jisas mönö yad mɨdöŋ aku nugu mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mata nuŋ añör ap mag urön, rɨb mɨga yöxön, hö Jisas nugwo yadöŋa, “Nöbö Dib, Maria nɨ röböxmɨn, nɨ keir ör ap mag an urmɨdɨl aku wä röl. Nugwo yadaŋ hön nɨ pɨsaŋ ap mag urɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Aliö rɨmɨn, Jisas yadöŋa, “Mata, Mata, naŋ ap mɨga akwör rɨb mɨga yöx nugulö aku wä röl. ");
INSERT INTO tmd_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Maria mönö wä na nugunö, rön, rɨba paŋ akwör yöx nugwön, hö mönö na nugumɨda. Nöbö mö i ap wä piaku ruöx pɨb maga mɨdölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wop i, Jisas mögörɨb hör adöi mɨdön, Nuö God höjöpal gɨr mɨdöŋa. Höjöpal pörɨm nugugɨrön, nöbö nuŋ i hön nugwo yadöŋa, “Nöbö Dib, God nugwo pödpödiö höjöpainɨŋ? Jon nöbö nuŋ akuyöbö ñɨgö yad nölmɨn nugwöi mag akuyöbö, nagö anɨŋ algör yad nölaŋ nuguŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Aliö rɨmɨn, Jisas ñɨgö yadöŋa, “God höjöpainöb, al aliö yajöña, ‘Acö, nöbö mö ib nagö yadɨŋ bɨl sö duaŋ. Nagö nöbö mö pön nugwidɨx mɨjɨnö wop aku rɨmgör haŋ. ");
INSERT INTO tmd_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ap mag anɨŋ wop paŋ paŋ öim öim nöilö akuyöbö nölö. ");
INSERT INTO tmd_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nöbö mö bli an rɨ gwogwam rɨmɨn, an ñɨgö paiŋö rɨ gwogwam rölöl mag akuyöbö, an ap kib mag gwogwo röl mag an aku nugwön röböxö. Anɨŋ nugwidɨx mɨdaŋ, rɨb i yöxön, rɨ gwogwam röinɨŋö,’ cɨne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Jisas mönö aku yadön, nöbö nuŋ akuyöbö ñɨgö mönö höd röxön yadöŋa, “Ñɨŋ nöbö i, pɨxmag yuö mibɨl dib bö, nöbö nugub nuŋwa rama duön yajöna, ‘Haul hödpɨg, nöbö nugub nɨ i pad piakuyöbö hön ram na hömɨdmɨn, nɨ nugwo ap mag nölmön nɨmɨba mɨdölmɨn, nagö yad nuguba hömɨdla. Nɨ bred mag mös paŋ nölö,’ cöna. Aliö rɨmɨdaŋ, nöbö nugub nuŋ aku mönö paiŋö yajöna, ");
INSERT INTO tmd_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","‘Pɨxmag yuö dib kɨ hön nɨ akuyöbö yadmɨjɨnö! Nɨ halöu ha nɨ bla pɨsaŋ uba wölön hölɨmmɨdöla. Makwam, nɨ pödpödiö öbɨlön, nagö ap yadmɨdlö piaku pɨ nöin?’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Makwam ñɨgö yadmɨdla, nöbö ram mɨnöbö aku, nöbö nugub nɨ, me rön, rɨmgör pɨ nölen; jɨ nugwo nölaŋ, me rön, pöx mɨd gɨr, yad gör mɨdaŋ mɨdaŋ, rɨg yajön akwör nöiöna. ");
INSERT INTO tmd_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Makwam, ñɨgö yadmɨdla, ap agapɨm mɨden aku, God nugwo yad nugwɨŋ, ñɨgö nöiöna. Ap agapɨm hölu nugwöñ aku, pöña. Anɨŋ uba rödö, rön, pal gigu rɨŋ, röjöna. ");
INSERT INTO tmd_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Aku agapɨm: nöbö mö God yad nugwöñ akuyöbö pöña. Nöbö mö ap hölu nugwöñ akuyöbö pöña. Nöbö mö anɨŋ uba rödaŋ, me rön, pal gigu rɨŋ, ñɨgö uba röjöna. ");
INSERT INTO tmd_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ñɨŋ halöu ha nuö bla, ha ñɨŋ i dölöm ap rɨmɨdaŋ, kas i nöiönɨŋönö? ");
INSERT INTO tmd_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Yöur mɨj ap rɨmɨdaŋ, hakai i nöiönɨŋönö? Aku kwo algör alöinö. ");
INSERT INTO tmd_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ñɨŋ nöbö mö wä yöi akuyöbö jɨ halöu ha ñɨŋ bla ap wä bla akwör nöiöña. Acö adöx yöd röul adö kau sö mɨd aku Nöbö wä ödöriö. Nuŋ ap gwogwo i nölen. Inöm Leia anɨŋ nölö, rɨmɨjöñ aku, Acö ñɨgö nöiönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Makwam nöbö i nugwo ragwo as öim nɨgɨm, mönö pɨmɨdöl wöhö, hör ör mɨdöŋa. Jisas ragwo as yad abmɨn, öim nɨg gɨ mɨdöŋ nöbö aku mönö pɨmɨn nugugɨrön, nöbö mö nugugu mɨdim bla aiö waiö rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Makwam nöbö mö piaku bli yadmä, “Nuŋ ragwo as nuö ñɨŋa Bielsebul ölɨsö pön, ragwo as bla yad abmɨdö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Makwam nöbö mö piaku bli, Jisas pödpöd cönɨŋö, rön, yadmä, “Ap nugwölɨbä i keir mɨjöi adöx bɨl yörsak raŋ nugwön mɨ, God nuŋwör yad abɨm hölaŋö, rön nugunɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Makwam inakmönö hörim rɨb ñɨŋ keir aku Jisas nuŋ keir nugwön yadöŋa, “Mögörɨb dib paŋyöbö i, pɨ asɨx hörɨrör nɨgön, nöbö mö ñɨŋör keir pɨsaŋ nuö nuö pɨlmɨjöñ aku, mögörɨb aku pɨn pal diöna. Nöbö mö il paŋyöbö i, algör ör pɨ asɨx hörɨrör nɨgön, nöbö mö ñɨŋör keir pɨsaŋ nuö nuö pɨlmɨjöñ aku, nöbö mö il paŋyöbö aku pɨn pal diöna. ");
INSERT INTO tmd_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Mag aliö akuyöbö, Seten il nuŋ aku pɨ asɨx hörɨrör nɨgmɨjön aku, pödiö mɨd ri abön? Jɨ ñɨŋ nɨ yadöia, ‘Bielsebul ölɨsö maga pön, ragwo asa yad abmɨn röu dumɨdöiŋö,’ röia. ");
INSERT INTO tmd_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Aliö yadöi aku, yam ñɨŋa keir bla ragwo as bla pödpödiö rön yad abɨm röu duöi? Yam ñɨŋa keir yajöña, nöbö mö aliö alɨb maga nɨgöl. ");
INSERT INTO tmd_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Makwam nɨ God ölɨsö nuŋwa pön, ragwo as piaku yad abmön röu duöi aku, ñɨŋ nugwöña, God nöbö mö pön nugwidɨx mɨdɨb wop aku anɨŋ mödö hö mɨk, me rön nugwöña. ");
INSERT INTO tmd_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Makwam nöbö ölɨsö i, ömdö cɨl wome ap nuŋwa nɨg ri abön, ram nuŋwa nugugu mɨjöna, nöbö mö bli ap nuŋ bla pɨb maga mɨden. ");
INSERT INTO tmd_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Makwam nöbö ölö ödöriö i keir hön, nugwo pɨsaŋ nuö nuö pɨp duön nugwo pal nɨgön, ömdö cɨl wome ap rama nɨg ri aböŋ aku alɨg pön, ap kib pön bla pön du nuöm nɨg nöiöna. ");
INSERT INTO tmd_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Nöbö mö nɨ pɨsaŋ mɨdölöi piaku, nɨ rɨl mabö na aku hajal aböia. Nöbö mö ñɨŋ nöbö mö bli nɨ pöl hömɨdeñ bla, nöbö mö nɨ pöl höba rɨmɨdöi bla ñɨgö rɨbɨxɨp du aböia. ");
INSERT INTO tmd_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ragwo as hö, nöbö mö öim nɨg mɨdaŋ, yad abɨŋ röu diön aku, du mögörɨb ör mibɨl piaku duön, yör i hölu nugwön mɨjɨnö, rön, du mibɨl piaku hölu nugw yön yualöbön, ‘Ram möl höd mɨdön höl aku höuöil dinö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Yadön, duön nugwaŋ, ram aku jöujöu lɨl rɨ ri abɨŋ, yöra wä mögedö akwör mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nuŋ nugwön höuöil duön, nuŋ röxgɨb yöi, ragwo as gwogwo ödöriö akuyöbö mɨj sö aku yölɨŋ höuöil hön, möl aku wölu mɨjöña. Alɨŋ, nöbö aku höd wä ul mɨŋi mɨdɨbi röxg mɨdmɨd mag akuyöbö yöi; wopik mɨdɨb nuŋwa mɨ ödöriö gwogwo cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisas mönö aku yadɨm, nöbö mö mɨga mɨdmä mibɨl yöra mö i öbɨlön, wö rɨ yadön yadöŋa, “Nam nagö yöx pön hö kau nölöŋ aku, mɨ ödöriö wahax pɨnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Aliö rɨmɨn, Jisas paiŋö yadöŋa, “Aliö yadlö aku, jɨ nöbö mö yön yön God Mönö aku nugwön rɨg yad mag akuyöbö cöñ bla, ñɨŋ mɨ ödöriö wahax pöñɨŋö,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Makwam nöbö mö mɨga ödöriö hö mögum rɨm nugugɨrön, Jisas ñɨgö yadöŋa, “Nöbö mö weik mɨdöi mibɨl yörɨk, ap kib mag gwogwo rɨ gɨr mɨdön yadöia, ‘Ap rölɨbä akuyöbö i adöx yöd röul adö kau sebö raŋ nuguŋö,’ röia. Makwam nɨ ñɨgö yadmɨdla, ap i keir rɨmön nugweñ. God mönö yadɨb nöbö Jona nuŋ rɨg röŋ mag akwör nɨ raŋ, nugwöña. ");
INSERT INTO tmd_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Taun dib Ninepa nöbö mö bla, God mönö yadɨb nöbö Jona hön rɨg röŋ akuyöbö nugwön God nugw pim mag aliö, nöbö mö wopik mɨdöi bla, nɨ Nöbö Ha nuŋwa rɨg rɨmɨjɨn akuyöbö nugwön nugwöña. ");
INSERT INTO tmd_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Makwam maduar ör kwin i mögörɨb pad mɨdöŋ piakuyöbö hön, Kiŋ Solomon mönö wä yadmɨd aku nugunö, rön, höŋa. Makwam ñɨŋ nöbö mö weik mɨdöi bla, nöbö dib Solomon röxgɨb yöi wöhö, nɨ Nöbö Dib ödöriö hön mibɨl ñɨgö yörɨk mɨdön, ñɨgö mönö wä ödöriö yad nölmön pölöi. Makwam, mönö diba yadɨb wop aku, kwin aku öbɨlön ñɨgö nöbö mö weik mɨdöi bla mönö diba yajöna. ");
INSERT INTO tmd_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Maduar ör Jona du Ninepa nöbö mö akuyöbö ñɨgö yadɨm, ap kib mag gwogwo rɨmɨdöi aku, pödpöd rɨmɨn aliö alölɨŋö, rön, röböxön, God nugw pɨmä. Jona nuŋ yadɨm nugw pim aku, jɨ weik nɨ Nöbö Dib ödöriö hön mibɨl ñɨgö yörɨk mɨdön, mönö wä ödöriö yad nölmön, ap kib mag gwogwo röi piaku röböxölöi. Makwam, mönö diba yadɨb wop aku, Jona nuŋ öbɨlön ñɨgö nöbö mö weik mɨdöi bla mönö diba yajöna. ");
INSERT INTO tmd_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Nöbö mö akuyöbö hötɨkö urön möl i mönö wi yöj mo möl böisö öim umad nɨgmɨdölöi; bɨl yöraku pisö cɨx nɨg gɨŋ mil abmɨn, nöbö mö akuyöbö ram möl yuadö hön wöxnö nugwöña. ");
INSERT INTO tmd_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Makwam mämäg aku hötɨkö mila röxg mɨda. Mämäga mɨd ri abön aku, mɨxɨña yuö kwo mil abɨm mɨd ri aba. Makwam mämäga mɨd ri aben aku, mɨxɨña yuö kwo pɨxmag röxg gur gɨ mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ñɨŋ nugw ri aböña, yuö ñɨŋ kwo mila mɨdönö pɨxmag gur gɨ mɨd? Ñɨŋ rɨbyöx nugwöia, yuö an kwo mil ab gɨ mɨdö, rön rɨbyöx nugwöi aku, jɨ pɨxmag gurɨbä maga ra aku, ñɨŋ keir nugw ri aböña. ");
INSERT INTO tmd_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mɨxɨñ ñɨŋa yuö kwo magalɨg mil abɨm mɨd gɨr, möl ulmɨdö mɨdöy pɨxmaga mɨden aku, hötɨkö mila abɨm ñɨgö mila ab nöiön mag akuyöbö cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Makwam Jisas mönö yad pörmɨn nugugɨrön, Perisi nöbö i nugwo yadöŋa, “Haŋ ram na duön ap nɨmɨŋö,” röŋa. Aliö rɨmɨn, Jisas ram nuŋwa duön, ram möl yuadö ap nɨmɨba römɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Römɨdön, ap nɨmmɨdɨm nugugɨrön, Perisi nöbö aku, rɨb nuŋ akwör yöx nugwön, nöbö kɨ pödpöd rɨmɨn an Juda ada öim rɨg röl mag akuyöbö, imag nuŋ aku röbö äbäd abön wöhö, hör ör ap pɨ nɨmɨba rɨmɨdö, rön, rɨb aku yöxöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Aliö rɨbyöx nugwöŋ aku Jisas nuŋ keir nugwön nugwo yadöŋa, “Ñɨŋ Perisi ada, kwosö namag bla rɨŋadö adö bla röbö äbäd ri abön röi mag aliö akuyöbö röi aku, jɨ yuö ñɨŋ bö ap kib mag gwogwo röi pɨx aku aja wöl gɨ mɨda. Ñɨŋ nöbö mö ap wä ñɨŋ bla pɨŋö, rön, mɨ mag gwogwo akwör rɨmɨdöia. ");
INSERT INTO tmd_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ñɨgö nöbö mö u bɨlɨm. God ñɨgö uñ wab akwör rɨ nɨgölöŋ; yuö bö aipam rɨ nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Makwam, ap kwosö namaga möl bö mɨd piaku, nöbö mö lɨblɨb rɨ mɨdö bla ñɨgö nöiöña. Akuyöbö almɨjöñ aku, ap ñɨŋa magalɨg lei röjöna. ");
INSERT INTO tmd_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Makwam ñɨŋ Perisi ada, nugw ri aböña: ñɨŋ mɨ ödöriö ömörö diba pöña. Pöm, dil, hör ap hölɨŋ wä höb möriwö rɨba wölmɨd piaku nugumɨn, ap diba röxg nɨgmɨn, iŋ wöd nugup dumɨdɨŋ, ragpɨd sö duaŋ, nuöm nɨgön God nugwo paŋyöbö i nöinɨŋö, rön, öim nugwöia. Ap ulul bla öim alön röi aku wä rɨ, makwam pödpöd rɨmɨn mönö il ödöriö aku nugwön mai duölöi? Nöbö mö akuyöbö ñɨgö ödöriö wä cön adaku rölöi; ñɨgö gwogwo cön adakwör röia. God nugwo madmag nɨgölöi. Akuyöbö alön mag gwogwo röia. ");
INSERT INTO tmd_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Makwam ñɨŋ Perisi ada, nugw ri aböña: ñɨŋ mɨ ödöriö ömörö diba pöña. Ñɨŋ Juda mögum rɨb ram akuyöbö duön, nöbö dib römɨdöi hogw rol akwör römɨdöia. Rɨb ñɨŋa yöx nugwöi aku, nöbö mö mɨga mɨdöi mibɨl piaku duŋ, ‘Mönö yad nölɨb nöbö hömɨdlaŋ e!’ rɨŋ, anɨŋ wä cönɨŋö, rön, nugwöia. ");
INSERT INTO tmd_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Makwam ñɨŋ Perisi ada, nugw ri aböña: ñɨŋ mɨ ödöriö ömörö diba pöña. Nöbö mö bli ñɨgö nugwön, nöbö wä ödöriö, me röi aku, jɨ nöbäpö hogw pɨlɨm lɨdu gwogwo rɨg mɨd möl bö nöbö mö nugwölɨb rol sö yönöi mag aliö akuyöbö mɨdöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jisas aliö rɨmɨn, lo mönö yad nölɨb nöbö i nugwo yadöŋa, “Mönö yad nölɨb nöbö, mönö ölɨsö waba yadlö aku, anɨŋ kwo algön nör yad höimöulaŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Aliö rɨmɨn, Jisas yadöŋa, “Makwam ñɨŋ lo mönö yad nölɨb nöbö piaku, nugw ri aböña: ñɨŋ mɨ ödöriö ömörö diba pöña. Mönö kɨtɨb wä yadöi aku, yogw ömörö dib piakuyöbö, nöbö mö akuyöbö ñɨgö rag nölöi aku, jɨ ñɨgö uliöxön yadön öröu pölöi. ");
INSERT INTO tmd_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Makwam ñɨŋ lo mönö yad nölɨb nöbö bla, nugw ri aböña: ñɨŋ mɨ ödöriö ömörö diba pöña. Nöhönɨŋ maduebö ñɨŋ bla maduar ör God mönö yadɨb nöbö akuyöbö ñɨgö pɨl pal nɨgmä. Jɨ ñɨŋ God mönö yadɨb nöbö piaku nöbäpö hogw pɨlɨba ñɨŋ rɨ nɨgöia. ");
INSERT INTO tmd_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Alöi aku, wä pal nɨgöiŋö, rön, röia. Nöhönɨŋ maduebö God mönö yadɨb nöbö bla pɨl pal nɨgmä; jɨ nöbäpö hogw möla ñɨŋ rɨ nɨgöia. ");
INSERT INTO tmd_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Makwam, God rɨb wä yöx nugw Nöbö aku yadöŋa, ‘Mönö na yadɨb nöbö bla, mönö wä na pɨrag dub nöbö bla, ñɨgö abna, jɨ ñɨgö höj nugwön, bli rɨ gwogwam rön, bli aŋadö pɨl pal nɨgöñɨŋö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Makwam maduar ör, God mögörɨb il kɨ rɨ nɨgɨba röŋ wop aku ila nɨgön, God mönö yadɨb nöbö akuyöbö ñɨgö öim pɨl pal nɨgɨm hö aku, ñɨŋ nöbö mö weik mɨdöi kɨyöbö, ap rɨb aku paiŋö pöña. ");
INSERT INTO tmd_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ömörö aku mɨ, nöbö Ebol nugwo höd ila nɨgön pɨl pal nɨgɨp duön, nɨgɨp hön, mai Sekaraia nugwo, ap höjöpal ur nölɨb ram möl yuadö kau adokwo, rɨg pön rim rɨgpɨd rol adök, mibɨl yöra pɨl pal nɨgmä. Ñɨgö mɨ ödöriö yadmɨdla, ömörö mönö aku magalɨg, ñɨŋ nöbö mö weik mɨdöi akuyöbö pöña. ");
INSERT INTO tmd_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Makwam ñɨŋ lo mönö yad nölɨb nöbö bla, nugw ri aböña: ñɨŋ mɨ ödöriö ömörö diba pöña. Mönö wä aku, rɨb wä yöx nugub ram möl ubalɨja kai wab aku ñɨŋ pön piaku umadöia. Piaku umadön röi aku, nöbö mö ram möla du nugunɨŋö, rön rɨbyöx nugwöi bla, ñɨgö öim ödöi rɨmö abag wölöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Jisas ñɨgö aliö rön rɨŋadö dumɨn nugugɨrön, lo mönö yad nölɨb nöbö bla aipam, Perisi nöbö bla aipam nugwo jɨ nugugu mɨd yadmä, “Mönö kai yadɨŋ, paiŋö yadaŋ nugwön, nugwo pön du mönö diba yajnɨŋö,” rön, Jisas nugwo inag inag inakmönö hörön mönö adö bli yadmɨn duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Makwam wop i, nöbö mö mɨga ödöriö hö mögum rön, nuö nuö cɨr nölɨp nöbö mö bli yödpɨlö röb wödemɨl rɨp höm nugugɨrön, Jisas nöbö nuŋ bla ñɨgö yadöŋa, “Perisi ada öim rɨ gwogwam röi mag aku rɨ umadön, mɨd ri abölɨŋö, rön rɨbyöx nugwöia. Ñɨŋ kwo algör rɨbä maga nɨg aku, ñɨŋ is ñɨŋ aku nugw ri aböña. ");
INSERT INTO tmd_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ñɨŋ ap rɨ umadön röi piaku, mai wöxnö nɨgaŋ nugwöña. Ñɨŋ mönö tar yad umadön röi piaku, algör ör wöxnö nɨgaŋ nugwöña. ");
INSERT INTO tmd_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Makwam ñɨŋ mönö pɨxmag yuö bö nɨgöi piaku, mil gɨ yadɨŋ nugwöña. Ñɨŋ mönö tar ram möl bö nɨgöi piaku, ram cölöbö sö aj halön wöxnö yadɨŋ, piöx rag mögörɨb adadö diöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nöbö mö nɨ kɨyöbö, ñɨgö yadmɨdla, God nugwo cɨrɨpön rɨŋ, anɨŋ pɨl pal nɨgöñɨŋö, rön, ipöxmɨjeñ. Aku hör mɨxɨñ akwör rɨ gwogwam rɨŋ, lɨdiöna. Mai ñɨŋ ap i ñɨgö rɨb maga nɨgen. ");
INSERT INTO tmd_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Makwam, nɨ ñɨgö yadmɨdla, ñɨŋ ipöxnöb, Nöbö ñɨgö mɨxɨña pɨl pal nɨgön, mai ñɨgö rɨn hör yönmɨd möl bö pɨ abɨbä nɨg Nöbö akwör ipöxöña. Ipöxɨb nöbö paŋyöbö makwör; nugwör ipöxöña. ");
INSERT INTO tmd_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ñɨŋ nugwöia, nöbö mö yöur ulmɨdö akuyöbö mömɨd sö sɨm rön, rɨg paskwolö ulul mösör pöia. God yöur ulmɨdö piaku nugwölɨbä i mɨdöl; magalɨg nugw pör akwör mɨda. ");
INSERT INTO tmd_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Makwam ñɨŋ nöbö mö bla ap yöbö; yöur bla rɨg mɨdöi akuyöbö ñɨŋ mɨdölöi. God yöcmac panö ñɨŋ aku magalɨg iŋ wöd makwam, ñɨŋ ipöxmɨjeñ, rɨbyöx gɨba alɨg mɨjɨnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ñɨgö mönö mi yadmɨdla, nöbö mö Jisas adö mɨdölɨŋö, rön, nöbö mö mɨdöi mibɨl yöra yad wöxnö nɨgmɨjöñ piaku, nɨ ñɨgö paiŋö aipam nöbö mö kɨyöbö nɨ adö mɨdöiŋö, rön, God ejol nuŋ bla mɨdöi mibɨl yöra wöxnö yad nöiöna. ");
INSERT INTO tmd_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Makwam nöbö mö Jisas adö mɨdölölɨŋö, rön, nöbö mö mɨdöi mibɨl yöra wöxnö yadmɨjöñ piaku, nɨ ñɨgö paiŋö aipam nöbö mö kɨyöbö nɨ adö mɨdölöiŋö, rön, God ejol nuŋ bla mɨdöi mibɨl yöra wöxnö yad nöiöna. ");
INSERT INTO tmd_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Nöbö Ha nuŋwa nugwo yad höimöumɨjöñ aku, God nuŋ nugwön röböxnöb röböxöna; makwam Inöm Leia nugwo yad höimöumɨjöñ aku, God nuŋ nugwön röböxen. ");
INSERT INTO tmd_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Makwam ñɨgö mönö diba yadɨba rön, pön Juda mögum rɨb ram aku mönö gapman nöbö dib mɨdöi mibɨl aku mönö kiŋ mɨdöi mibɨl aku, pön hömɨjöñ aku, paiŋö mönö kai yajnɨŋö, rön, rɨb mɨga yöx nugumɨjeñ. ");
INSERT INTO tmd_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Öbɨlön yadɨŋ nugugɨrön, wop akwör Inöm Leia nuŋ ñɨgö rɨba nölaŋ nugugɨrön, nugwön yajöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nöbö mö mɨga mɨdim mibɨl yöraku, nöbö i Jisas nugwo yadöŋa, “Mönö yad nölɨb nöbö, nagö nöböhöd nɨ aku nugwo yadaŋ, acö ap pɨ nɨgön wöröxöŋ akuyöbö, nuöm nɨg nɨ ada keir nölaŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Aliö rɨmɨn, Jisas nugwo paiŋö yadöŋa, “Nɨ yön yad, ‘Ap pɨ nuöm nɨg nölɨb nöbö mɨdane,’ ra nugwön ap ñɨgö bla pɨ nuöm nɨg nöinö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jisas aliö rön, nöbö mö mɨdim akuyöbö ñɨgö yadöŋa, “Nugw ri aböña. Ap mɨga akwör pɨnɨŋö, rön, rɨb aku yöx nugumɨjeñ. Ap mɨga pɨnɨŋö, rön, rɨb aku yöx nugumɨjöñ aku, mɨd ri abɨb maga mɨden,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Makwam Jisas mönö i ñɨgö mönö höd röxön yadöŋa, “Nöbö rɨg mɨga mɨjön i, möriwö nuŋ aku wit mag ap bla mɨga akwör mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Rɨb nuŋ akwör yöx nugwön duön, ‘Nɨmɨb ap mag na mɨga akwör mɨd aku, ram möl yuadö möl kai rag hö nɨgön, nɨmön mɨjne?’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Makwam rɨb i yöx nugwöna, ‘Ram ulul piaku hajal abön, ram dib dib bla akwör ur nɨgön, wit mag na aipam, ap na akuyöbö aipam magalɨg pön du ram möl aku nɨgna. ");
INSERT INTO tmd_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nɨ akuyöbö alön, nɨ keir yajɨna, “Nöbö mɨg. Nagö ap wä mɨga mɨd aku kɨm mɨga akwör mɨdaŋ pören. Makwam, mabö nagö aku röböxön, ap naŋ piakwör nɨm gɨr, röbö nɨm gɨr, wahaxbör wahax pɨ gɨr mɨdane,” cɨnö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Aliö yadön rɨbyöx nugwön aku, jɨ God nugwo yajöna, ‘Nagö nöbö u ödöriö! Weik pɨxmag yuö kwo wöröxnö. Ap nagö mɨga rɨ pɨdɨlu nɨgman mɨd piaku, yön ap akuyöbö nɨmmɨjön?’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Mag aliö akuyöbö, nöbö mö ap wä piaku mɨga pɨ mögum rɨmɨdöi aku, jɨ God mämäg il nuŋ yöra ñɨŋ nöbö mö lɨblɨb rɨ mɨdö bla mɨdöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jisas aliö rön, nöbö nuŋ akuyöbö ñɨgö yadöŋa, “Makwam, ‘Ap mag pikai yöbö pön nɨm mɨjnɨŋ, wölɨj pikai yöbö pön yöm mɨjnɨŋö,’ rön, rɨb mɨga yöx nugumɨjeñ. ");
INSERT INTO tmd_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ap mag nɨmɨb aku ap dib yöi. Kömö mɨdɨb mag aku ap yöbö. Wölɨj ap bla ap dib yöi. Mɨxɨñ aku ap yöbö. ");
INSERT INTO tmd_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Yöur mɨdöi piaku nugwi. Yöur piaku, nöbö mö rɨg röi mag akuyöbö, wit mabö rɨ yum, göj um ödör rag hölöi. Wit mag ödör rag hö mögum rɨb ram ñɨŋ i mɨdöl. God nuŋwör yöur bla ap mag nöla. Nuŋ ap ulul piaku rɨbyöx nugwön alön ra aku, ñɨŋ pödpöd rɨmɨn anɨŋ nöbö mö nugwidɨx mɨdenɨŋö, rön, rɨb mɨga yöx nugwöi? Yöur bla ap ulmɨdö; ñɨŋ ap ulmɨdö yöi. ");
INSERT INTO tmd_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Makwam ñɨŋ rɨb mɨga yöx nugumɨjöñ aku, wöröxɨba cöñ wop aku röböxön, mag mɨŋi kwo mɨjöñɨŋönö ä? ");
INSERT INTO tmd_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Aku ap ulmɨdö, jɨ ñɨŋ keir ap ulmɨdö aku rɨbä maga nɨgöl. Makwam, ñɨŋ pödpöd rɨmɨn hör ap adö bli rɨb mɨga yöx nugwöi? ");
INSERT INTO tmd_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ap ki piaku wölön, mag yaxön pɨpɨl abön aku, jɨ keir wölɨj rön ud wabɨl nölɨbä maga nɨgöl. God nuŋwör rön, ud wabɨl nöl ri ab gɨm mɨda. Makwam Kiŋ Solomon ud wabɨl ri abön rɨg rɨmɨd mag akuyöbö, ap pɨpɨl bla ud wabɨl ri abön rɨg rɨmɨd mag akuyöbö algör rɨmɨdölöm. ");
INSERT INTO tmd_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ap ki bla wöl piaku hör ap; öim mɨdenɨm. Weik yöbö mɨdön, laŋ lonkwo römaxdörön bɨ urɨŋ yöñöna. God nuŋ hör ap piaku rɨbyöx nugwön aliö rɨ aku, ñɨŋ pödpöd rɨmɨn anɨŋ wölɨj nölenɨŋö, rön, rɨb mɨga yöx nugwöi? Nugw pɨb mag ñɨŋ aku mɨxɨla mɨdöl. ");
INSERT INTO tmd_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","An ap mag, röbö, ap piaku pikai yöbö pön nɨmɨŋö, rön, rɨb ömörö aku yöx nugumɨjeñ. ");
INSERT INTO tmd_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nöbö mö God nugwölöi piaku, rɨb akuyöbö yöx nugwöia. Makwam Nuö ñɨŋ aku ñɨgö uplöböl; ap ñɨgö mɨdöl piaku nugwa. ");
INSERT INTO tmd_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Makwam jɨ, God nöbö mö pön nugwidɨx mɨdɨb wop aku, anɨŋ alɨg pönɨŋö, rön, rɨb paŋyöbö i yöx nugwön rɨŋ duaŋ mönö, ñɨgö nugwidɨx mɨdön, ap piaku ñɨgö nöiöna. ");
INSERT INTO tmd_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Hön sipsip pɨd ulmɨdö nɨ pik, Nuö ñɨŋ aku, ñɨgö pön nugwidɨx mɨjne, rön, nugw makwam, ñɨŋ ipöxmɨjeñ. ");
INSERT INTO tmd_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ap ñɨŋ mɨd piaku, sɨm rɨ rɨg pön, nöbö mö ap mɨdöl akuyöbö ñɨgö nöli. Almɨjöñ aku, rɨg uñ ñɨŋa lɨduön ren, öim öim mɨjöna; ap wä ñɨŋ bla adöx yöd röul adö kau sö mɨdön hölögɨpen; ap kib pɨb nöbö hön kib pen; hepnö ap piaku nɨmen. ");
INSERT INTO tmd_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Makwam ap wä ñɨŋ bla mögörɨb rol il kɨ pɨ mögum rɨmɨjöñ aku, höbwab rɨb madmag ñɨŋ aku algör ör mögörɨb rol il kɨ mɨjöna. Makwam ap wä ñɨŋ bla adöx yöd röul adö kau sö pɨ mögum rɨmɨjöñ aku, höbwab rɨb madmag ñɨŋ aku algör ör paŋ sar mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Makwam, wölɨj ñɨŋ aku met metyöbö pal wödön, amanö pɨx nɨg ri abön, hötɨkö ur nɨgön nugu gör mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mabö rɨ nölɨb nöbö bla yajöña, ‘Nöbö dib an aku, nöbö nugub nuŋwa mö pön pɨsaŋ ap diba nɨmmɨdɨŋ nugugɨrön, womiöx höbkal hönɨŋö,’ rön, nugugu ör mɨjöña. Nöbö dib ñɨŋ aku höbkal hön, ubalɨja pal gigu raŋ, yadkap röjöna. Makwam mag akuyöbö ñɨŋ kwo algör cöña. ");
INSERT INTO tmd_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Makwam nuŋ höbkal hön, ñɨŋ nugugu mɨjöñ aku nugwön, ñɨgö pɨ ösös rɨ ri aböna. Nöbö dib aku nuŋ keir, wölɨj nuŋ aku met metyöbö pal gɨlɨxön, amanö pɨx nɨg ri abön, ñɨgö yadaŋ, hö ap mag nɨg nɨmöi yöraku römɨd gwogwäbö rɨŋ, nuŋ keir ap nɨmɨb piaku pön hö ñɨgö nöiöna. ");
INSERT INTO tmd_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Makwam nöbö diba pɨxmag yuö mibɨl umɨjön mag aku mönö kulakula wö cön mag aku hön nugwaŋ, nöbö nuŋ bla inɨmö hölɨm gɨ mɨdeñ aku, ñɨgö pɨ ösös rɨ ri aböna. ");
INSERT INTO tmd_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Makwam, nugwi. Nöbö mö ram mɨnöbö bla, ap kib pɨb nöbö hön wop aku, me rön, nugugu mɨdöyɨx aku, ram ñɨgö pal waglöxön, ap ñɨŋ bla kib pölöx. ");
INSERT INTO tmd_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mag aliö akuyöbö, Nöbö Ha nuŋwa hönɨŋö, rön, pöx mɨjöña. Henɨŋö, rön, rɨbyöx nugumɨdöi wop akwör hönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jisas aliö rɨmɨn, Pita yadöŋa, “Nöbö Dib, mönö höd röxön yadmɨdlö aku, anɨŋör yadmɨdlanö owa nöbö mö magalɨg yadmɨdlö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Aliö rɨmɨn, Nöbö Diba paiŋö yadöŋa, “Nöbö kai rɨb wä mɨdaŋ, mabö rɨ nöl ri abön aku, nöbö dib nuŋwa ram nuŋ aku duba rön nugwo yajöna, ‘Nöbö mabö na röi bli ñɨgö nugwidɨx mɨdön, ap mag ñɨŋ bla nuöm nɨg nöl gɨr mɨdane,’ rön, diöna. ");
INSERT INTO tmd_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Makwam, mai höbkal hön, rɨg yajön mag akwör rɨmɨjön aku nugwön, nugwo mɨ ödöriö madmag nɨgön pɨ ösös rɨ ri aböna. ");
INSERT INTO tmd_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nɨ ñɨgö yadmɨdla, nöbö dib aku yadaŋ, nöbö nuŋ rɨ ri abön aku ap nuŋ bla magalɨg nugwidɨx mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Makwam mabö rɨ nölɨb nöbö nuŋ aku, nöbö dib na aku yadkap hölö, rön, mabö rɨ nölɨb nöbö mö ñɨgö bli mɨ göj palön, ap diba nɨmön, röbö wain mɨga nɨmön, u pɨlön, rɨ mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Makwam nöbö dib nuŋwa henɨŋö, cön, wop akwör hön, nugwo römax döbdö rɨ nɨgön, nöbö mö mönö nugwo nugwölöi mibɨl ñɨgö yöra yad aböna. ");
INSERT INTO tmd_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Mabö rɨ nölɨb nöbö i, nöbö dib nuŋwa mönö rɨg yajön aku nugw ri abön, jɨ mönö nugwo aku röd abön, rɨg yajön mag akuyöbö ren aku, nöbö diba yadaŋ, ñɨŋ nugwo uplöb paiöña. ");
INSERT INTO tmd_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Jɨ mabö rɨ nölɨb nöbö i, nöbö dib nuŋwa mönö rɨg yajön aku nugwölön, rɨg yajön mag akuyöbö ren aku, nöbö diba yadaŋ, ñɨŋ nugwo palön ölɨŋ höb ulul akuyöbö pɨ nöiöña. God ñɨgö nöbö mö ap mɨga nöiön piaku, nɨ paiŋö ap mɨga nölɨŋ, me cöna; ñɨgö nöbö mö ap mɨga ödöriö nöiön piaku, nɨ paiŋö ap mɨga ödöriö nölɨŋ, me cöna. ");
INSERT INTO tmd_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nɨ höl aku, mögörɨb rol il kɨ hötɨkö nɨg röbɨba höla. Mögörɨb piaku magalɨg mödö yönöx aku wä! ");
INSERT INTO tmd_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nɨ ölɨŋ höb pɨ nölɨba rɨmɨdöi aku, nɨ mɨ ömörö diba ra. Ömörö dib aku pɨp dumɨd, nɨ ölɨŋ höb pɨ nölɨŋ pöcön wop akwör womiöxöna. ");
INSERT INTO tmd_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ñɨŋ nɨ yajöña, nöbö mö pɨ nɨgiö nɨgɨba hö, cöñ aku, jɨ aku yöi. Nɨ höl aku, nöbö mö rɨb adö hörɨrör yöx nugwön asɨx hörɨrör nɨgöña. ");
INSERT INTO tmd_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Weik wop kɨ ila nɨgön, nuarö nuömarö akuyöbö mömɨd sö mɨjöñ aku, mös paŋ nɨ nugw pɨŋ, mös nɨ nugw peñ aku, asɨx hörɨrör nɨgöña. Makwam nöi mɨjön aku, mös nɨ nugw pɨŋ, mös paŋ nɨ nugw peñ aku, asɨx hörɨrör nɨgöña. ");
INSERT INTO tmd_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nöbö nuarö hogwa, ha aimönö nuö aim nɨ nugw peñ aku, asɨx hörɨr nɨgöña. Mö nuömarö hogwa, halöu aimönö nuöma aim nɨ nugw peñ aku, asɨx hörɨr nɨgöña. Nuöma ha nuŋwa mönɨŋ aku yöŋö, paŋ mag akwör cöña; nuöma aimönö ha nuŋwa mönɨŋ aim nɨ nugw peñ aku, asɨx hörɨr nɨgöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Makwam Jisas mönö i kwo ñɨgö yadöŋa, “Naiö rödɨp dumɨd ada mɨjöi wobön mɨñɨlmɨn nugwön, weik ruö pɨlɨba rɨmɨdö, rön, nugugu mɨdmɨn, rɨg yadöi mag akwör mödö ruö pɨla. ");
INSERT INTO tmd_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ij diba pikwo yöbö pik rɨ hö nugwön, wopik naiö diba nɨgɨba rɨmɨdö, rön, nugugu mɨdmɨn, rɨg yadöi mag akwör mödö naiö diba nɨga. ");
INSERT INTO tmd_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ñɨŋ inakmönö hörɨb nöbö! Ap mögörɨb il kɨ nugw ri abön, ap adöx sö nugw ri abön röi aku, jɨ pödpöd rɨmɨn wop dib öim pöx mɨdmɨdöi aku, weik mödö hö, rön nugwölöi?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ñɨŋ pödpöd rɨmɨn, ödöi aku ödöi waiö, ödöi aku ödöi gwogwo, me rön, nugwölöi? ");
INSERT INTO tmd_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Makwam nöbö i nagö mönö diba yadɨba pön dumɨdlö, rɨmɨdaŋ, mönö dib aku mönö kai yadɨba dumɨdölɨŋö, rön, ödöi mibɨl yöra du gɨrön, nugwo pɨsaŋ mönö nɨgön mönö aku pal wöröxöña. Nöi mɨjön aku, nagö pön du mönö diba nugub nöbö imag rol nuŋwa abaŋ, nuŋ piöŋö nagö pön du ömdö nöbö imag rola nɨgaŋ, nagö mɨ aŋadö pön du nag nɨgöña. ");
INSERT INTO tmd_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Makwam, nɨ nagö yadmɨdla, naŋ nag akwör mɨdön, ap rɨb nagö bla aŋadö rɨba wöd pörön, röu dinaŋe,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mag aku, nöbö mö bli hön, Jisas nugwo yadön yadmä, “Galili nöbö mö bli hön, God höjöpalɨb ram aku ap höjöpal ur nölɨŋ nugugɨrön, mag akwör gapman nöbö dib Pailot ñɨgö mɨ aŋadö pɨl pal nɨgö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Aliö rɨmɨdmɨn, Jisas ñɨgö yadöŋa, “Galili nöbö mö piakwör, ap kib mag gwogwo magöri maga rɨm aliö alöŋa, jɨ Galili nöbö mö bli ap kib mag gwogwo ulul ulul bli rɨm aliö alölö, rön, nugwöiŋ ä? ");
INSERT INTO tmd_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aku wöhö! Nɨ ñɨgö yadmɨdla, ap kib mag gwogwo röi aku, pödpöd rɨmɨn aliö alölɨŋö, rön, röböxeñ aku, nöbö mö piaku rɨg wöröxim mag akuyöbö, ñɨŋ kwo algör magalɨg paŋ aliar wöröxöña. ");
INSERT INTO tmd_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Makwam Siloam ban yuö il yöra, ram mɨxɨl dib i gɨlɨxön nöbö mö akuyöbö iŋösu adokwebö kwo (18) ñɨgö pal nɨgöŋ aku, ap kib mag gwogwo magöri maga rɨm aliö alöŋa, jɨ Jerusalem mɨdmɨdöi nöbö mö bli ap kib mag gwogwo ulul ulul bli rɨm aliö alölö, rön, nugwöiŋ ä? ");
INSERT INTO tmd_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aku wöhö! Nɨ ñɨgö yadmɨdla, ap kib mag gwogwo röi aku, pödpöd rɨmɨn aliö alölɨŋö, rön, röböxeñ aku, nöbö mö piaku rɨg wöröxim mag akuyöbö, ñɨŋ kwo algör magalɨg paŋ aliar wöröxöña. ");
INSERT INTO tmd_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Makwam Jisas mönö höd röxön ñɨgö yadöŋa, “Nöbö i kaucö maga yaxaŋ, me rön, iñ aku röd pön hön, nag wain möriwö nuŋ aku yuöna. Mai höbkal hön nugwaŋ mag yaxen. ");
INSERT INTO tmd_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nöbö mabö rɨb nuŋ aku nugwo yajöna, ‘Kɨm mös paŋ kɨm paŋ paŋ yönmɨn nugugɨrön, öim hön nugula kaucö yum aku maga yaxöl. Makwam, möriwö rɨb na mibɨl yöra mɨd aku wä röl. Römal abö!’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Yadmɨdaŋ, mabö rɨ nölɨb nöbö nuŋwa yajöna, ‘Nöbö dib, bɨ kaucö aku weik römal abɨb yöi. Nɨ kaucö il aku mɨnuö pal ri abön, ap panö panö bli mɨdau rag abmön, ");
INSERT INTO tmd_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","kɨm maiyöbö aku maga yaxön aku röböxön kwönö; mag yaxen aku römal abö,’ cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Makwam Juda God höjöpalɨb wop i, Jisas Juda mögum rɨb ram i duön, ñɨgö mönö yad nöl gɨr mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ram möl aku mö i hö mɨdöŋa. Mö aku nugwo ragwo as rɨmɨn, höglöm nuŋwa um pɨlɨx rɨm um hölɨl yönmɨdɨm kɨm nuŋ akuyöbö iŋösu adokwebö kwo (18) yönöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisas mö aku nugwo yadɨm hömɨdɨm yadöŋa, “Ap nagö rɨ aku kömö nɨgö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jisas aliö rön nugwo pɨ nugumɨn nugugɨrön, mag akwör höglöm yöda mɨrɨxmɨn, God iba yadmɨn adöx sö duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Makwam Jisas nuŋ God höjöpalɨb wopa mö aku rɨmɨn kömö nɨgöŋ aku nugwön, nöbö dib Juda mögum rɨb ram aku nugwidɨx mɨdmɨd aku, Jisas nugwo nugumɨn ölɨsö wölɨm, nöbö mö hö mɨdim akuyöbö ñɨgö yadöŋa, “Ñɨŋ nöbö mö ap rɨ akuyöbö, mabö rɨb wop iŋösu akwör höŋ kömö nɨgöna. Weik God höjöpalɨb wop kɨ akuyöbö almɨjeñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Aliö rɨmɨn, Nöbö Dib nugwo paiŋö yadöŋa, “Ñɨŋ inakmönö hörɨb nöbö! Hön kau, hön donki ñɨŋ bla wabɨl nɨgɨŋ mɨjön yöraku, God höjöpalɨb wop aku röbö ap raŋ, ñɨgö nag yauön pön duŋ röbö nɨmöñɨŋönö wöhö? ");
INSERT INTO tmd_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Makwam nöso maduebö an Ebraham yöxmɨn yöxɨp pön hö nɨgim halöu kɨ, Seten nugwo maduar ör wabɨl nɨgmɨn, kɨma yöniö iŋösu adokwebö kwo (18) pɨn aku, nugwo ögwö yöxölöi ä? Weik God höjöpalɨb wop kɨ nag nuŋwa yau abmɨdmön, mönö diba yadmɨdöi ä? ");
INSERT INTO tmd_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jisas aliö rɨmɨn, nöbö nugwo nugum ölɨsö wölöŋ piaku mɨ ödöriö möigw yöxmä. Makwam nöbö mö bli ñɨŋ Jisas ap rölɨbä akuyöbö rɨg rɨmɨd akuyöbö nugwön, mɨ ödöriö wahax pɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jisas mönö i kwo yadön yadöŋa, “God nöbö mö pön nugwidɨx mɨdɨb mönö aku ñɨgö yad nölɨba rɨmɨdɨl aku, pödpödiö yadmön, ñɨŋ nugw ri aböñ? ");
INSERT INTO tmd_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mɨ mönö adö yadɨba rɨmɨdɨl kɨyöbö aliö mɨda. Nöbö i bɨ masted mag aku rag du möriwö rɨb nuŋ aku yuaŋ, wöl dib röxön padö pɨlaŋ, yöur hön löx wä bla hörɨrör rin urön mɨjöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Mönö i piöŋö iswob yadöŋa, “God nöbö mö pön nugwidɨx mɨdɨb mönö aku, pödpödiö yadmön, ñɨŋ nugw ri aböñ? ");
INSERT INTO tmd_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Mag akuyöbö, mö i is pɨd ulul ulul i pön, wit mag hauya wi yöj möl dib bö abön alɨg pɨ höuöilmel raŋ mɨd gɨrön, mɨ wöl dib röxön, mag aliö akuyöbö cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Makwam Jisas Jerusalem dinöb rön, paxdöriar duölöŋ. Nuŋ taun akuyöbö aipam, nöbö mö ram yöj lɨglɨg agrö mɨdmä akuyöbö aipam, alebö alebö hölɨm gɨrön, mönö yad nölɨp duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nöbö mö mɨdim adaku, nöbö i Jisas nugwo yadöŋa, “Nöbö Dib, God hör nöbö mö mösör kömö pönɨŋönö wöhö?” röŋa. Aliö rɨmɨn, Jisas ñɨgö yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Makwam, ñɨŋ ususör rön, ubalɨj ulmɨdö aku diöña. Nöbö mö mɨga, ubalɨj möl ulmɨdö aku duŋö, rön, du rua röx öliöxöña. ");
INSERT INTO tmd_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Aku agapɨm: nöbö ram mɨnöbö aku uba wölaŋ, ñɨŋ rɨŋadö mɨdön, uba pal gigu rön yajöña, ‘Nöbö dib, uba rödö!’ rɨŋ, nuŋ paiŋö yajöna, ‘Ñɨŋ pikai yöbö nöbö mö bɨlɨm? Nɨ ñɨgö nugumɨdöiö!’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Aliö rɨmɨdaŋ, ñɨŋ paiŋö yajöña, ‘Nagö höd mögörɨb ana höman, nagö pɨsaŋ ap nɨmön röbö nɨmön rɨmɨdmɨŋa; naŋ anɨŋ mönö yad nölmɨdlaŋö,’ cöña. ");
INSERT INTO tmd_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Aliö rɨŋ, nuŋ paiŋö yajöna, ‘Nɨ ñɨŋ nugumɨdöi. Ñɨŋ pikai yöbö nöbö mö bɨlɨm. Ñɨŋ nöbö mö ap kib mag gwogwo rɨmɨdöi makwam, ñɨgö uba rödöinöm. Dine!’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Mai ñɨŋ nugwɨŋ, Ebraham, Aisak, Jekop, God mönö yadɨb nöbö bla, God mögörɨb öim mɨdɨb aku God pɨsaŋ mɨjöña, jɨ ñɨgö yad rɨŋö bö abaŋ, mɨ göj im gɨrön, ajmaga öbɨx gɨg yu gɨrön mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Makwam nöbö mö pad piakuyöbö, naiö wölmɨd adö sebö, naiö rödɨp dumɨd adö bebö, bɨl adöi yöbö, bɨl adöi yöbö, God mögörɨb öim mɨdɨb nuŋ aku hön, römɨdön nɨgiö nɨgön ap diba nɨmöña. ");
INSERT INTO tmd_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Makwam nöbö mö wopik mɨ höglöm adö bö mɨdöi piaku, mai bli höd du mɨjöña. Makwam nöbö mö wopik höd dumɨdöi piaku, mai bli mɨ ödöriö höglöm adö bö mɨjöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wop akwör, Perisi nöbö bli hön Jisas nugwo yadmä, “Gapman nöbö dib Herod nagö pɨl pal nɨgɨba rɨmɨda. Makwam, nagö mögörɨb kɨ röböxön, mögörɨb hör i duö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Aliö rɨmɨn, Jisas yadöŋa, “Ñɨŋ du wöñö höpebö aku nugwo yadɨŋ, nugugu mɨjöna. Weik aipam, laŋ aipam, nöbö mö ragwo as öim nɨg bla yadmön kömö nɨgaŋ, nöbö mö ap rɨ bla rɨmön kömö nɨgaŋ. Makwam lonkwo mabö na aku rɨ pöcɨna. ");
INSERT INTO tmd_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Makwam weik, laŋ, lonkwo nɨ ödöi dinö, rɨ rɨbyöx nugul aku, dina. God mönö yadɨb nöbö akuyöbö ñɨgö Jerusalem ör pɨl pal nɨgöña. ");
INSERT INTO tmd_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalem! Jerusalem! God nuŋ mönö yadɨb nöbö nuŋwa ñɨgö, me rön, yad aböŋ akuyöbö, pödpöd rɨmɨn öim rɨg röd pal nɨgmɨdöi? Kulakul asa pɨ upɨc mo nɨg mag akuyöbö, nɨ öim halöu ha nagö bla pɨ ösös rɨ ri abnö, rön, rɨbyöx nugul aku, jɨ nɨ ipɨtmɨn nugwön röböxöia. ");
INSERT INTO tmd_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Makwam nugwi. Ram ñɨŋ aku yöj akwör mɨda. Mɨdö ñɨŋ nɨ nugweñ; mai piaku, ‘Nöbö kɨ Nöbö Diba yad abmɨn hömɨd kɨ, God rɨmɨn ib nuŋwa adöx sö duaŋ,’ me cöñ wop akwör nɨ iswob nugwöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Juda God höjöpalɨb wop i, Jisas du Perisi nöbö dib i ram nuŋwa ap nɨmmɨdmɨn nugugɨrön, nöbö mö mɨdim bla, nuŋ agapɨm cönɨŋö, rön, tar riö nugugu mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Aku agapɨm: wop aku, mɨxɨñ magalɨg dɨxöŋ nöbö i mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jisas, Perisi nöbö bla aipam, lo mönö yad nölɨb nöbö bla aipam, ñɨgö yadöŋa, “God höjöpalɨb wop kɨ, ap rɨ nöbö mö akuyöbö rɨŋ kömö nɨgönɨŋönö wöhö? Lo mönö pödi yad?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Jisas aliö rɨmɨn, mönö i paiŋö yadölim. Makwam, Jisas mɨxɨñ magalɨg dɨxöŋ nöbö aku nugwo pɨ nugum kömö nɨgöŋa. Kömö nɨgmɨn, Jisas nöbö aku nugwo yad abmɨn duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jisas nöbö aku yad abön, nöbö mö akuyöbö ñɨgö yadöŋa, “Halöu ha ñɨŋ i mönö hön kau ñɨŋ i, God höjöpalɨb wop aku röbö unöi ulöm möl bö pɨñön aku, ñɨŋ yadkap du pɨ aböñɨŋönö wöhö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Aliö rɨmɨn, ñɨŋ paiŋö mönö i yadɨb maga nɨgölöŋ. ");
INSERT INTO tmd_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Makwam nöbö mö piaku ap mag nɨmɨba hön, römɨdɨb yör wä wä bla akwör nugwön römɨjnɨŋö, rön, römɨdmä aku, Jisas nugwön mönö i mönö höd röxön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nöbö i mö pɨba rön, ap diba nɨmɨba ñɨgö yad wö raŋ, duön römɨdɨb yör wä nugwön römɨdmɨjeñ. Aku agapɨm: nöbö mö dib bli höb maga ra. ");
INSERT INTO tmd_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Makwam, ñɨŋ römɨdɨb hogw rol wä aku nugwön römɨdmɨjöñ aku, ñɨgö yad wö cön nöbö aku hön yajöna, ‘Nagö hör piakwo duö, nöbö dib kɨ hogw rol aku römɨdaŋ,’ me raŋ, nagö möigw haŋ nugugɨrön, kɨrɨrɨ rɨ du rɨb piaku römɨjɨnö. ");
INSERT INTO tmd_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Makwam ñɨgö, ap nɨmɨŋö, rön, yad wö rɨmɨdɨŋ, du rɨb piaku römɨd mɨdɨŋ mönö, nöbö ñɨgö yad wö cön aku hön yajöna, ‘Nöbö mɨg. Nagö hön hogw rol wä kɨ römɨdö,’ raŋ, nöbö mö ap nɨmɨba hö mɨjöñ akuyöbö nagö nugwön, nöbö mɨg nöbö diba akwör mɨdö, cöña. ");
INSERT INTO tmd_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Mag aliö akuyöbö, nöbö mö an ib diba mɨdö, rön nugwöi piaku, God ib ñɨŋa raŋ pɨn pal diöna. Makwam nöbö mö an ib diba mɨdölö, rön nugwöi piaku, God ib ñɨŋa raŋ wöliönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jisas mönö adaku yadön, nöbö ap diba nɨmɨba nöbö mö wö röŋ aku nugwo yadöŋa, “Nagö ap diba nɨmɨba, nöbö nugub nagö bla, pɨgnaŋ nölöunaŋ yam nagö bla, nöbö mö mögörɨb nɨgiö nagö rɨg mɨga mɨd akuyöbö, ñɨgö yad wö rɨmɨjɨnö. Nöbö mö piaku, paiŋö nölɨŋö, rön, nagö paiŋö ap nɨmɨba yad wö rɨb maga ra. ");
INSERT INTO tmd_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nagö ap diba nɨmɨba, nöbö mö lɨblɨb rɨ mɨdö bla nɨgön, nöbö mö iŋ wajmag lɨd pɨl bla nɨgön, nöbö mö agal gwogwo rɨ bla nɨgön, nöbö mö mämäg we wöl bla nɨgön, ñɨgö yad wö rɨŋ, höŋ, pɨsaŋ ap nɨmöña. ");
INSERT INTO tmd_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nöbö mö lɨblɨb rɨ mɨdö bla, paiŋö nölɨb maga mɨden makwam, mai God nöbö mö kömö wä nuŋ bla raŋ öbiöñ wop aku, nuŋ keir nagö paiŋö nöiönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Makwam mönö aku nugwön, nöbö ñɨŋ pɨsaŋ ap nɨmmɨdim i Jisas nugwo yadöŋa, “God nöbö mö nuŋwa pön nugwidɨx mɨjön aku, nuŋ pɨsaŋ nɨgiö nɨgön ap diba nɨmöñ akuyöbö, mɨ wahax pöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Aliö rɨmɨn, Jisas yadöŋa, “Nöbö i ap diba nɨmɨba rön, nöbö mö mɨga yad wö cöna. ");
INSERT INTO tmd_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Makwam ap diba nɨmɨb wop aku hömɨdaŋ, mabö rɨ nölɨb nöbö nuŋ aku nugwo yajöna, ‘Weik du nöbö mö höd yad nɨgɨl akuyöbö ñɨgö du yad pön hö,’ cöna. Nöbö mabö rɨ nölɨb nuŋ aku piöŋö duön yajöna, ‘Ap magalɨg rag hö pɨdɨluöla; höŋ duŋe!’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Yadmɨdaŋ, nöbö mö piaku i yajöna, ‘Nɨ din aku, jɨ mögörɨb rɨb i wobɨl aku nuguba dumɨdlö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nöbö i yajöna, ‘Nɨ din aku, jɨ hön kau akuyöbö ragpɨd sö wobɨl aku, mabö rɨ ri aböñɨŋönö wöhö, du nugunö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nöbö i yajöna, ‘Nɨ din aku, jɨ mö na yöudöŋdöŋ ör pɨl makwam, ub maga nɨgölö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Aliö rɨmɨdɨŋ, nöbö aku höbkal duön, nöbö mö piaku ñɨŋ rɨg yajöñ mönö aku nöbö dib nuŋwa yad nöiöna. Yad nölmɨdaŋ, nöbö diba höbwab nuŋ aku gwogwo raŋ, nöbö nuŋ aku nugwo iswob yad abön yajöna, ‘Nagö yadkap du ödöi dib bla aipam, ödöi ulul bla aipam duön, nöbö mö lɨblɨb rɨ mɨdö bla nɨgön, nöbö mö iŋ wajmag lɨd pɨl bla nɨgön, nöbö mö mämäg we wöl bla nɨgön, nöbö mö yödpɨlö gwogwo rɨ bla nɨgön, ñɨgö yad pön hö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Aliö rɨmɨdaŋ, rɨg yajön mag akuyöbö rön, mai mabö rɨ nölɨb nöbö aku yajöna, ‘Nöbö dib, yadlö mag akuyöbö rɨla, jɨ möl bli yöj akwör mɨdö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Aliö rɨmɨdaŋ, nöbö dib aku mabö rɨ nölɨb nöbö nuŋwa nugwo yajöna, ‘Nagö ödöi dib bla aipam, ödöi ulmɨdö bla aipam duön, nöbö mö mɨ ususör rön yadaŋ, ñɨŋ höŋ, ram möl yuadö nɨ kɨ aŋadö cɨcɨ raŋ. ");
INSERT INTO tmd_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Makwam nöbö mö höd wö rɨmön hölöi bla, nöbö mö i ap na ulul mɨŋ bli nɨmen, mɨ wöhö,’ me cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jisas ödöia dumɨdöŋ aku, nöbö mö mɨga nugwo mai dumä. Nuŋ höuöiliö ñɨgö yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Nöbö mö bla nɨ adö duŋö, cöñ aku, jɨ rɨb dib ñɨŋa du mɨjön nuö nuöm, mönɨŋ, halöu ha, pɨgnɨŋ nölöunɨŋ nöbö mönö mɨxɨñ ñɨŋa keir aku, nɨ nugumön nöbö mö na mɨdɨbä maga nɨgöl. ");
INSERT INTO tmd_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nöbö mö bli yajöña, Jisas nöbö mö nuŋwa mɨjnɨŋ aku, jɨ an alɨŋ, nöbö mö bli anɨŋ rɨ gwogwam rɨb maga rö, rön, mɨxɨñ ñɨŋa keir rɨbyöx nugu gɨrön mɨjöñ aku, nɨ nugumön nöbö mö na mɨdɨbä maga nɨgöl. ");
INSERT INTO tmd_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Makwam nöbö ñɨŋ i, ram dib mɨxɨl i bɨl sö urɨba, höd rɨg pödpödiö pön cɨnö, rön, rɨbyöx nugw ri abön, cöna. ");
INSERT INTO tmd_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Makwam, cɨnö cɨnö, rön, ram padö höd pɨl ri abön aku, jɨ mai rɨga met waŋ, rama met waŋ, nöbö mö bla nugwo yad höimöuön yajöña, ");
INSERT INTO tmd_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Ake! Nöbö mɨg rama urɨbi rɨp duön, rama rɨbi röxgɨb röböxö,’ cöña. ");
INSERT INTO tmd_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Makwam mag aliö akuyöbö, kiŋ i, kiŋ i pɨsaŋ nuö nuö pɨlɨba, höd rɨbyöx nugw ri abön diöna. Makwam nuŋ rɨbyöx nugup duön, ami nöbö nɨ aku ten tausan ör mɨda; jɨ kiŋ aku ami nöbö nuŋ twedi tausan mɨda; nuö nuö pinɨŋ aku, nuŋ ami nöbö nɨ bla pɨl pörɨb maga rö, cöna. ");
INSERT INTO tmd_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Rɨb aku yöx nugwön, kiŋ i pad piaku mai hömɨdaŋ nugugɨrön, höd mönö wob abön yajöna, ‘An pödpöd cɨnɨŋ, mönö nugwön pɨ nɨgiö nɨgɨŋö?’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Makwam, nugw ri aböña. Ap ñɨŋ bla magalɨg röböxön, nɨ pɨsaŋ heñ aku, nöbö mö na mɨdɨbä maga nɨgöl. ");
INSERT INTO tmd_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Usö ap wä ödöriö aku, jɨ id nuŋwa pal mag diön aku, ñɨŋ pödpöd rɨŋ yöra id yöñön? ");
INSERT INTO tmd_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Usö aliö akuyöbö, pɨ möriwö rɨb aimönö kulakul höb rola abɨŋ ap wöl ri aben. Usö aliö akuyöbö mabö i mɨdöl; pɨ ki bö abɨb maga ra. Ñɨŋ nöbö mö rɨmɨj möla mɨjön akuyöbö, mönö yadmɨdɨl kɨ rɨmɨj pal nugw ri abnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Makwam takis pɨb nöbö bla aipam, nöbö mö ap kib mag gwogwo rɨmɨdim bla aipam, Jisas mönö yadmɨd aku nuguŋö, rön, hö nugugu mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Makwam Perisi nöbö bla aipam, lo mönö yad nölɨb nöbö bla aipam, Jisas nugwo yad höimöuön yadmä, “Nuŋ pödpöd rɨmɨn nöbö ap kib mag gwogwo röi piaku pön, pɨsaŋ ap mag nɨgiö nɨgön nɨmmɨd?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Aliö rɨmɨdmɨn, Jisas mönö i höd röxön ñɨgö yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nöbö ñɨŋ i, hön sipsip padokwo padök mös mös höuöiliö hö wölu amñaxɨb sö (100) urmɨjöna. Jɨ sipsip paŋyöbö i yöm rɨmɨjön aku, bli pön du mögörɨb ñɨb ñɨb mɨd piaku nɨgön, du hön sipsip nuŋ hölögɨpön aku hölu nugw yönmɨd yönmɨd, höna hölu nugw pöna. ");
INSERT INTO tmd_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Hön sipsip nuŋ aku hölu nugw pön, wä raŋ nugugɨrön, pɨ ragpɨd nuŋwa rol sö nɨgöna. ");
INSERT INTO tmd_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ragpɨd nɨg rag rama hön, nöbö mö nugub nuŋ bla, nöbö mö mögörɨb nɨgiö nuŋ bla, ñɨgö yad wö raŋ, hö röb mɨjöñ aku yajöna, ‘Hölögɨp hön sipsip na aku, hölu nugwön höbkal pɨl aku, ñɨgö nɨ pɨsaŋ wahax pɨnɨm,’ me cöna. ");
INSERT INTO tmd_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mag aliö akuyöbö mɨ, nöbö mö mɨga akuyöbö, an mɨd ri aböla, ap kib mag gwogwo i rölölɨŋö, rön rɨbyöx nugwöi akuyöbö, adöx yöd röul adö kau sö mɨdöi akuyöbö nugwön wahax peñ; jɨ nöbö mö paŋyöbö i, ap kib mag gwogwo rɨl aku, pödpöd rɨmɨn aliö ailö, rön, röböxmɨjön aku, adöx yöd röul adö kau sö mɨdöi akuyöbö nugwön mɨ wahax pöña. ");
INSERT INTO tmd_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Makwam, mö i rɨg silpa mag nuŋ akuyöbö ragpɨd sö mɨjöna. Makwam mag i, ram möl yuö piaku tar pɨñön aku, nuŋ pödpöd cön? Nuŋ hötɨkö ur bɨl yörsak nɨgön, jöujöu walön hölu nugup dumɨd dumɨd rɨg mag nuŋwa nugwön pöna. ");
INSERT INTO tmd_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Rɨg silpa mag nuŋ aku hölu nugw pön aku, wä raŋ nugugɨrön, nöbö mö nugub nuŋ bla, nöbö mö mögörɨb nɨgiö nuŋ bla, ñɨgö yad wö raŋ, hö röb mɨjöñ aku yajöna, ‘Pɨn rɨg mag paŋyöbö nɨ aku hölu nugwön höbkal pɨl aku, ñɨgö nɨ pɨsaŋ wahax pɨnɨm,’ me cöna. ");
INSERT INTO tmd_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mag aliö akuyöbö mɨ, nöbö mö paŋyöbö i, ap kib mag gwogwo rɨl aku, pödpöd rɨmɨn aliö ailö, rön, röböxmɨjön aku, adöx yöd röul adö kau sö yöraku God ejol nuŋ bla nugwön mɨ ödöriö wahax pöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisas mönö aku yadön yadöŋa, “Nöbö i ha nuŋ mös mɨjön aku. ");
INSERT INTO tmd_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ha pɨg aku hö nuö yajöna, ‘Acö, ap anɨŋ nöbö hogwa yadlö bla, pɨ nuöm nɨg nɨ bla keir nölö,’ raŋ, nuö ap ñɨŋ nöbö hogwa bla pɨ asɨx hörɨrör nöiöna. ");
INSERT INTO tmd_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nölaŋ, ha pɨg aku mag metyöbö mɨŋi mɨdön, nuö ap nugwo pɨ nuöm nɨg nölöŋ bla magalɨg sɨm rön, rɨg pön, pön du mögörɨb pad piaku diöna. Du piaku mɨdön, mö kib pɨsaŋ yönön mag gwogwo rɨ gɨrön, rɨg ap nuŋwa pɨrag diön bla, amnör nöbö mö bla nöl pöcöna. ");
INSERT INTO tmd_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Alaŋ, rɨg nuŋwa pöraŋ, mögörɨb aku mɨ kiö diba piöna. Makwam ap mag wob nɨmɨb rɨg i mɨdenɨm. ");
INSERT INTO tmd_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Alaŋ, nuŋ duön, nöbö mögörɨb akuyöbö mɨnöbö ñɨŋ i yad nugwaŋ, nugwo hön urɨb mabö aku yad nɨgöna. ");
INSERT INTO tmd_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Makwam nugwo kiö diba pɨla kiö wöröxön, hön urmɨdöi woprö uñ bla bli nɨmnö, cön aku, jɨ nöbö mö bli nugwo ap mag nöleñ. ");
INSERT INTO tmd_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Makwam rɨb mag nuŋwa yöx nugup dumɨd rɨb wä mag aku haŋ yajöna, ‘Acö na mabö rɨ nölmɨdöi nöbö bla, ap mag mɨga mɨda. Nɨ yörɨk mɨdla, nɨ kiö diba wöröxmɨdla. ");
INSERT INTO tmd_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Makwam, nɨ mögörɨb kɨ röböxön, acö mɨd yöra höbkal duön, nugwo yajɨna, “God mämäg il rol nuŋ aku rɨ gwogwam rön, mämäg il rol nagö aku rɨ gwogwam rön, rɨl aku, ");
INSERT INTO tmd_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","nagö nɨ ha nɨ me rön yadmɨjɨnö. Nɨ mabö rɨ nölɨb nöbö nagö i röxg yad nɨgö cɨnö,” cɨnö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Rɨb aku yöx nugwön, acö rama höbkal dinö, rön, yajöna. Du mɨdaŋ, nuö nuŋ nɨc pad piaku irmär nugwöna. Nuö nɨc nugwön, mɨ ödöriö ögwö yöxöna. Nuŋ rɨmgör ipalɨp du nɨc pɨ wobön, pɨ algun nɨmöna. ");
INSERT INTO tmd_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nuö akuyöbö alaŋ, nɨc yajöna, ‘Acö, God mämäg il rol nuŋ aku rɨ gwogwam rön, mämäg il rol nagö aku rɨ gwogwam rön, rɨl akuyöbö, nagö nɨ ha nɨ me rön yadmɨjɨnö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Aliö cön aku, jɨ nuö nuŋwa mabö rɨ nölɨb nöbö nuŋ akuyöbö ñɨgö yajöna, ‘Ñɨŋ yadkap ör du wölɨj mɨxɨl dib na aku rag hö nugwo yöm nölön, imag nuŋ aku riŋ nɨg nölön, yam uña röb nölön, ri. ");
INSERT INTO tmd_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Akuyöbö alön, du hön kau ha mau wä ödöriö aku pal pön du urɨŋ, pɨsaŋ wahax pön ap pɨjep diba nɨmnɨŋa. ");
INSERT INTO tmd_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ha na aku aŋadö wöröxɨb maga röŋ aku, jɨ weik nuŋ höbkal kömö mɨda. Höd nuŋ aŋadö yöm röŋ aku, jɨ weik ha na höbkal pɨlö,’ cöna. Nuö aliö rɨmɨn, ñɨŋ du hön kau ha pal pön hön, ap mag urɨŋ, pɨsaŋ wahax pöña. ");
INSERT INTO tmd_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Makwam ha nuŋ höd aku, mabö rɨb bla rɨ yön pörön röböx, höbkal ramɨxrö womiöx hö gɨ nugwaŋ, cöjɨŋ bɨyöj palön, höx wödön, mɨ wahax pɨ gɨr mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Akuyöbö almɨdɨŋ, ha höda nuö mabö rɨ nölɨb nöbö i nugwo yad nugwön yajöna, ‘Pödpöd rɨmɨdöi?’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Yad nugwaŋ, yajöna, ‘Nauö nagö pɨgnaŋ wöröxö rön mönö, jɨ weik höbkal höm, nauö hön kau ha maua mɨxɨñ wä aku pal urɨm nɨm gɨrön wahax pɨmɨdöiŋö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Aliö raŋ, nugwo ölɨsö diba wölaŋ, rama ram möl yuadö duen; rɨŋö yör bör mɨjöna. Nuö piöŋö rɨŋö bö duön, ‘Haŋ ram möl yuadö duŋö,’ rön, nugwo mönö höimöliö nɨgön yajöna. ");
INSERT INTO tmd_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nuö ha höd nuŋwa mönö nölön höimöliö yadmɨdaŋ, nuŋ paiŋö yajöna, ‘Nɨ mönö nagö yadlö akuyöbö öim öim mai duön, nag mabö rɨb nöbö nagö i röxg mɨdön, mabö nagö öim öim rɨmön rɨmön kɨm mɨga yöna. Makwam nɨ hön meme ha i nölaŋ, nöbö mö nugub nɨ bla pɨsaŋ pal ur nɨmön wahax pölöl. ");
INSERT INTO tmd_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Makwam ha nagö aku, ap nuöm nɨg nölmö bla rag duön, mö kib pɨsaŋ yönön mag gwogwo rɨ gɨrön, rɨg ap nuŋwa magalɨg amnör nöbö mö bla nöl pörön höm, naŋ nugwo uliöxön, hön kau ha maua mɨxɨñ wä ödöriö aku pailaŋö!’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Aliö rɨmɨdaŋ, nuö nɨc nöbö höda nugwo yajöna, ‘An nuarö öim mɨdöl makwam, ap nɨ bla magalɨg nagö pɨnö. ");
INSERT INTO tmd_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pɨgnaŋ nagö aku aŋadö wöröxɨb maga röŋ aku, jɨ weik nuŋ höbkal kömö mɨda. Nuŋ aŋadö yöm röŋ aku, jɨ weik nugwo hölu nugwön höbkal pɨla. Makwam, an mɨ ödöriö wahax pɨnɨm,’ cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisas nöbö nuŋ akuyöbö ñɨgö yadöŋa, “Nöbö dib ap mɨga mɨjön i, nöbö ap nuŋ piaku nugwidɨx mɨdɨb nöbö i yad nɨgaŋ, ap nuŋ bla nugwidɨx mɨjöna. Makwam nöbö dib aku, mönö i nugwöna, nöbö ap nuŋ nugwidɨx mɨjön aku, ap nuŋ bla amnör cöna. ");
INSERT INTO tmd_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nöbö diba mönö aku nugwön, nugwo wö raŋ hömɨdaŋ yajöna, ‘Ap nɨ bla nugwidɨx mɨd ri aböiö aku, nɨ yad nölmɨn nugula. Makwam, nagö duön, ap nɨ pödiöm mɨd akuyöbö magalɨg iŋ wöd nugw ri abön, nöbö mö piaku ñɨgö ap rɨb na pödiöm mɨd akuyöbö magalɨg iŋ wöd nugw ri abön, hö nɨ yad nölön, mabö na rɨmɨdlö aku mai röinaŋö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Aliö rɨmɨdaŋ, nöbö ap nuŋ bla nugwidɨx mɨjön nöbö aku, rɨb nuŋ akwör yöx nugwön yajöna, ‘Nöbö diba nɨ yad abɨba rɨmɨd aku, jɨ nɨ pödpöd cɨn? Nɨ nöbö gö mɨdöi aku, mögö pɨn wödɨb maga nɨgöl. Nöbö mö bli ap ñɨŋ aku sö rɨ wököi nɨmmɨjɨn aku, nɨ möigw yöxnö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Makwam mai rɨbyöx nugw ri abön yajöna, ‘Nɨ agapɨm cɨn aku wopik nugula. Adaku rɨmön, mai nöbö dib na nɨ yad abön wop aku, nöbö mö bli nɨ pɨŋ, ram ñɨŋa hölɨmön mɨjɨnö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Aliö rön, nöbö mö bli ñɨgö nöbö dib nuŋwa ap rɨb mɨjön akuyöbö wö cöna. Wö raŋ, nöbö höd hön aku nugwo yajöna, ‘Nagö nöbö dib na ap rɨb pödiöm mɨd?’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Aliö raŋ, yajöna, ‘Wel nɨmɨb ap yöja akuyöbö padokwo padök mös mös höuöiliö hö wölu amñaxɨb sö (100),’ me cöna. Aliö raŋ, yajöna, ‘Köp meg pɨ, rɨmgör römɨdön ap yöj akuyöbö padokwo padök mös höuöiliö igwö sö (50) kai kɨtö,’ cöna. Aliö raŋ, rɨg yajön mag akwör cöna. ");
INSERT INTO tmd_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Mai, nöbö i hömɨdaŋ, yajöna, ‘Nagö nöbö dib na ap rɨb pödiöm mɨd?’ cöna. Aliö raŋ, yajöna, ‘Wit yogw akuyöbö padokwo padök mös mös höuöiliö hö wölu amñaxɨb sö (100),’ me cöna. Aliö raŋ, yajöna, ‘Köp meg pɨ, rɨmgör römɨdön yogw akuyöbö padokwo padök mös paŋ höuöiliö hö wölu agɨp sö (80) kai kɨtö,’ cöna. Aliö raŋ, rɨg yajön mag akwör cöna. ");
INSERT INTO tmd_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Aliö akuyöbö almɨdaŋ, mai nöbö dib nuŋ aku nugwön yajöna, ‘Nöbö ap na nugwidɨx mɨdɨb nöbö aku, rɨbyöx nugw ri abön, pödpöd rön mɨd ri abnö, ra aku, nuŋ rɨ ri abön rö,’ cöna. Makwam nugwi. Nöbö mö mögörɨb rol il kɨ rɨbyöx nugwöi bla yadöia, ‘Weik agö magɨm rön mai römɨd gɨ mɨdɨb an aku mɨd ri abnɨŋ owa?’ rön, rɨb aku yöx nugu gɨrön rɨm dumɨda. Makwam mil mag wä nugwöi nöbö mö bla, mag aliö akuyöbö mag akwör rɨm duöx aku waiö. ");
INSERT INTO tmd_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Rɨg ap mögörɨb il kɨ mɨd bla, nöbö mö piaku bli nölɨŋ mönö, mai ap piaku aŋadö pöcön wop aku, God mögörɨb öim mɨdɨb nuŋ yör sö ñɨgö yad wahax pöna. ");
INSERT INTO tmd_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Rɨg ap ulul bli, nöbö mö i imag rola nɨg gɨŋ, nugwidɨx mɨd ri abön aku, ap dib bla nölɨŋ, paŋ mag akwör cöna. Makwam rɨg ap ulul bli, nöbö mö i imag rola nɨg gɨŋ, nugwidɨx mɨd ri aben aku, ap dib bla nölɨŋ, paŋ mag akwör cöna. ");
INSERT INTO tmd_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Makwam ñɨŋ rɨg ap mögörɨb rol il kɨ mɨd aku pön, inakmönö hörön, nugwidɨx mɨd ri abeñ aku, agö nöböm ñɨgö ap wä ödöriö bɨl sebö nöiön? ");
INSERT INTO tmd_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nöbö i rɨg ap nuŋwa pɨ imag rol ñɨgö nɨgön aku, ñɨŋ inakmönö hörön, nugwidɨx mɨd ri abeñ aku, agö nöböm rɨg ap ñɨgö keir nöiön? ");
INSERT INTO tmd_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nöbö paŋyöbö i, nöbö dib mös mabö rɨb maga nɨgöl. Nöbö rama mösör mabö cön aku, jɨ nuŋ nöbö dib i madmag nɨgön, nöbö dib i madmag nɨgen. Owa nöbö dib i madmag nɨgön, nöbö dib i madmag nɨgen. Aiön mag akuyöbö, ñɨŋ rɨg ap bla ap wä ödöriö, me rön, nugumɨjöñ aku, God mabö rɨmɨdöi adaku röböxbä maga rö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Perisi nöbö bla, rɨb dib ñɨŋa paŋ rɨg akwör rɨbyöx nugumɨdöi makwam, Jisas mönö yadöŋ aku nugwön imöuön yad höimöumä. ");
INSERT INTO tmd_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yad höimöumɨdmɨn, Jisas ñɨgö yadöŋa, “Ñɨŋ nöbö mö mämäg il rol aku, an nöbö mö wä mɨdöla, röi aku, jɨ God höbwab rɨb madmag yuö ñɨgö kwo nugwa. Ap nöbö mö nugumɨn wä rɨ bla, God nugumɨn ap gwogwo röxa. ");
INSERT INTO tmd_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Röbö pal nölɨb nöbö Jon hölöŋ wop aku, lo mönö kai kɨtim aku aipam, God mönö yadɨb nöbö mönö kai kɨtim aku aipam yadmɨn, nöbö mö nugwön, mag aku rɨm dumɨda. Makwam Jon höŋ wop aku ila nɨgön, God nöbö mö pön nugwidɨx mɨdɨb mönö wä aku yadmɨn, nöbö mö nugwön ñɨŋ magalɨg paŋ adakwör duŋö, rön, usus rön rɨm dumɨda. ");
INSERT INTO tmd_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Adöx sö mögörɨb mɨgrö kɨ pɨsaŋ hölögɨpɨbä maga ra, jɨ lo mönö aku rɨb ul mɨŋi hölögɨpen. ");
INSERT INTO tmd_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Makwam, nöbö i mö pön röböxön, du mö hör i pön aku, mö kib pöna. Makwam nöbö i öbɨlön, nöbö pön röböxön mö aku pön aku, nuŋ algör ör mö kib pöna. ");
INSERT INTO tmd_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Nöbö i rɨg ap nuŋwa mɨga mɨdmɨda. Nuŋ wölɨj wä wä akwör yömön, ap mag wä wä akwör nɨmmɨda. ");
INSERT INTO tmd_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Makwam ram nuŋwa ubalɨj il yöra, nöbö uj kap ap mɨdmɨdöl nöbö i pön hö nɨgɨm mɨdmɨda. Ib nuŋwa Lasaras. ");
INSERT INTO tmd_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Rɨb nuŋwa yöx nugwön, ‘Nöbö ap mɨga mɨd kɨ ap nɨmaŋ, ap rɨb rɨb bla äbäñ mo kɨyöbö pɨñön aku, nɨ nɨmɨmön kiö pɨlenɨŋö,’ rön, nugumɨdöŋa. Makwam wöñö bla hön, uj nuŋ bla pai nɨmmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Mai nöbö ij aku wöröxöŋa. Nuŋ wöröxɨm, ejol bla hön nugwo pön du mögörɨb adöx yöd röul adö kau sö duön, Ebraham nuŋ adö nɨgmɨn ap diba nɨmöŋa. Makwam ap kap nöbö rɨb aku aipam wöröxɨm hogw pɨlmä. ");
INSERT INTO tmd_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nöbö rɨb aku wöröxön, du rɨn hör yönmɨd möl bö du mɨdɨm, nugwo ölɨŋ gwogwo pɨlmɨn nugugɨrön mɨdmɨdöŋa. Makwam mɨdön laxiö pisö nugwöŋa, Ebraham Lasaras pɨsaŋ hör hör yör sö mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nugwön, wö rön yadön yadöŋa, ‘Acö Ebraham, nɨ ögwö yöxön, Lasaras nugwo yadaŋ, imag igwö nuŋwa röbö pɨlön, hö albeñ nɨ aku pɨ nugwaŋ, nɨ höx raŋ. Bɨ yuö kɨ nɨ yönmɨn, nɨ mɨ ölɨŋ höb diba pɨmɨdlö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Aliö rɨmɨn, Ebraham yadöŋa, ‘Ha na nugwö! Mögörɨb il bö mɨdmɨdlö wop aku, nagö ap wä wä nagö pɨmɨdlö, jɨ Lasaras ap gwogwo gwogwo akwör pɨmɨda. Makwam weik mögörɨb kɨ, nuŋ wä mɨdmɨn nugugɨrön, nagör ölɨŋ höb diba pɨlmɨda. ");
INSERT INTO tmd_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","God nuŋ möl diba ödöriö mibɨl kɨ rɨ nɨgöŋ makwam, an nöbö mö pö adök rala rön pö ub maga nɨgöl; jɨ ñɨŋ pö adaku rala rön adök höb maga nɨgölö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Aliö rɨmɨn, nöbö aku yadöŋa, ‘Aliö yadlö aku, Lasaras nugwo yadaŋ, nuŋ acö na rama duön, ");
INSERT INTO tmd_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","haul nöbö na akuyöbö mömɨd sö piaku ñɨgö mönö ölɨsö yadaŋ, mögörɨb ölɨŋ höb keiryöbö gwogwo öim pɨl yörɨk hölɨŋ,’ me röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Aliö rɨmɨn, Ebraham yadöŋa, ‘Mosɨs aipam, God mönö yadɨb nöbö bla aipam, mönö kai kɨtim aku nugwɨŋ,’ me röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Aliö rɨmɨn, yadöŋa, ‘Acö, akuyöbö aleñ; jɨ nöbö mö i wöröxön öbɨlön, du yadmɨdaŋ aku, mi yadö, rön, ap kib mag gwogwo röi aku, pödpöd rɨmɨn aliö alölɨŋö, rön, röböxöñɨŋö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Aliö rɨmɨn, Ebraham yadöŋa, ‘Ñɨŋ Mosɨs aipam, God mönö yadɨb nöbö bla aipam, mönö kai kɨtim mönö aku nugwölöi aku, nöbö i wöröxön öbiön aku, ñɨŋ algör ör nugweñɨŋö,’ rö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisas nöbö nuŋ akuyöbö ñɨgö yadöŋa, “Nöbö i mönö mö i mag gwogwo rol aku rön, nöbö mö bli rɨba nölaŋ, ñɨŋ aipam mag gwogwo akwör rön pɨn bɨcöña. Mag adaku höd rɨmɨdmä, weik rɨmɨdöia, mai algör ör rɨmɨjöña. Makwam nöbö mö ñɨŋ rɨb gwogwo nöiöñ bla, ñɨŋ mɨ ölɨŋ höb ödöriö pɨmɨjöña. ");
INSERT INTO tmd_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Makwam nöbö i mönö mö i, halöu ha bla ha paŋyöbö i aliö rɨba cön aku, nugwo rɨg diba wit palɨb rɨg i, göliöda alɨg nag nɨg gö nɨgön, pön du ban yuö diba aböyɨx aku waiö. Aku agapɨm: nuŋ kömö mɨdön, halöu ha paŋyöbö i raŋ pɨn bɨcön aku, mɨ ölɨŋ höb gwogwo pöna. ");
INSERT INTO tmd_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Makwam, ñɨŋ keir rɨbyöx nugw ri aböña. “Pɨgnaŋ nölöunaŋ nagö i ap kib mag gwogwo rɨmɨjön aku, nugwo yadyöxön yadɨŋ, pödpöd rɨmɨn akuyöbö rɨlö, rön, rɨbyöx nugumɨjön aku, rɨ gwogwam röŋ aku nugwön röböxöña. ");
INSERT INTO tmd_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ap ñɨgö akuyöbö bli rɨ gwogwam rön, mai hön, pödpöd rɨmɨn akuyöbö rɨlö, rön, yadmɨjön aku, ap gwogwo röŋ aku nugwön röböxöña. Makwam wop paŋyöbö i alön raŋ raŋ akuyöbö mɨj sö aku cön aku, algör ör nugwön röböxöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jisas aliö rɨmɨdmɨn, mönö nuŋwa pön dub nöbö bla yadmä, “Nagö anɨŋ raŋ, nugw pɨb mag ana dib röxaŋ,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Aliö rɨmɨn, Jisas ñɨgö yadöŋa, “Nugw pɨb mag dib yöi, nugw pɨb mag ñɨŋa bɨ masted mag ulmɨdö mɨda röxg mɨjön aku, ñɨŋ bɨ kɨ, ila alɨg mölöd du ban yuö mibɨl kwo wöl gɨ mɨdö, rön yadɨŋ, rɨg yajöñ mag akwör cöna. ");
INSERT INTO tmd_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ñɨŋ rɨb pödiö yöx nugwöi? Mabö rɨ nölɨb nöbö i mögörɨb pɨn wöd pörön mönö hön sipsip ur pörön, höbkal rama höm, nöbö nuö nuŋwa nugwo mönö pöd yajön? ‘Nagö kiö pɨl aku, nagö yörɨk römɨdön ap mag nɨmö,’ cönɨŋönö? ");
INSERT INTO tmd_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Wöhö. Aliö yaden. Nuŋ yajöna, ‘Wölɨja paŋ wölaŋ, amanö aku pɨx nɨgön, röbö ap nɨ bla rag hö nölaŋ nɨmɨmön, mai röbö ap nagö bla nɨmö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ñɨŋ rɨb pödiö yöx nugwöi? Mabö rɨ nölɨb nöbö aku, nöbö diba yajön mag akuyöbö rɨmɨjön aku, nöbö diba mönö wä bli nugwo yajönɨŋönö owa? Wöhö. Mabö rɨ nölɨb nöbö nuŋwa mɨd aku mɨ, rɨg yajön mag akwör cöna. ");
INSERT INTO tmd_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ñɨŋ kwo algör. God ñɨgö mabö yad nɨgön akuyöbö rɨ pörön yajöña, ‘An mabö rɨ nölɨb nöbö mö wä yöi. Ap adö i keir rölöl; mabö an rɨb akwör rölɨŋö,’ cöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisas Jerusalem dinö, rön, mögörɨb Sameria kɨ, mögörɨb Galili kwo, mibɨl yöra pikwo dumɨd dumɨd, ");
INSERT INTO tmd_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ram yöj lɨglɨg agrö i yönmɨdɨm nugugɨrön, ucrapö röŋ nöbö akuyöbö ragpɨd sö, nugwo möigw palön, hör hör yörkwo mɨdön, ");
INSERT INTO tmd_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","aj halön yadmä, “Jisas, Nöbö Dib, anɨŋ ögwö yöxö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Aliö rɨmɨdmɨn, Jisas ñɨgö yadöŋa, “Ñɨŋ duön, God ap höjöpal ur nölɨb nöbö bla ñɨgö uñ ñɨŋ bla yabunö,” röŋa. Aliö rɨmɨn, ñɨŋ duön, ödöi mibɨl yöra dumɨdmɨn nugugɨrön, ñɨgö kömö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Makwam ñɨgö aliö kömö nɨgmɨn, nöbö Sameria yöbö i, nugwo kömö nɨgöŋ aku nugwön, mönö diba yad gɨrön, God iba yadɨm bɨl sö dumɨn nugugɨrön, ");
INSERT INTO tmd_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","höbkal hön, Jisas mɨdöŋ yödpɨlö il yöra pɨn bɨrön, haŋaj adö pibö rɨ mögö bö cɨrön, Jisas nugwo ri ablaŋe röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nuŋ alön rɨmɨn, Jisas yadöŋa, “Nɨ rɨbyöx nugula, nöbö akuyöbö ragpɨd sö kömö nɨgödö, rɨl aku, jɨ nöbö akuyöbö mac sö bla mɨkai? ");
INSERT INTO tmd_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nöbö bli pödpöd rɨmɨn hölöi? Nöbö pad piakuyöbö, Juda nöbö yöi akwör hön God nugwo wä rɨ ä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jisas aliö rön nöbö aku nugwo yadöŋa, “Jisas nɨ raŋ kömö nɨgönɨŋö, rön nugw pɨlö aku, nagö kömö nɨga, duö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Makwam wop i Perisi nöbö bla Jisas nugwo yad nugwön, “God nöbö mö pön nugwidɨx mɨdɨb wop aku wop kai wöxnö nɨgön?” rɨmä. Aliö rɨmɨn, Jisas yadöŋa, “God nöbö mö pön nugwidɨx mɨjönɨŋö, röi aku, kiŋ bla bli, nöbö mö nugwidɨx mɨdɨm mɨdɨm, nugw ri abön rɨm rɨm, mai kiŋ ñɨŋa höm, nöbö mö nugwo mämäga nugwön, wopik hö, cöñ mag akuyöbö ren. ");
INSERT INTO tmd_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","‘Mɨd yörɨk,’ mönö ‘Mɨd yör kwom,’ rön yadeñɨm. Aku agapɨm: nuŋ tar hön, mibɨl ñɨgö yörɨk mödö mɨdö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jisas aliö rön, nöbö nuŋ bla ñɨgö yadöŋa, “Mai piaku, Nöbö Ha nuŋwa haŋ nugwo nuguŋö, rön, madmag ñɨgö wax nöl gör mɨjöna, jɨ nugwo nugweñ. ");
INSERT INTO tmd_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nöbö mö bli ñɨgö yajöña, ‘Mɨd yörɨk,’ mönö ‘Mɨd yör kwom,’ me cöñ aku, jɨ mönö aku mi yadöiŋö, rön, ipalɨp duŋ, ñɨŋ pɨsaŋ dumɨjeñ. ");
INSERT INTO tmd_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Aku agapɨm: Nöbö Ha nuŋwa hön wop aku, añɨgölö ñɨrɨm, mila alɨp dum nugwöi mag akuyöbö alɨp höna. ");
INSERT INTO tmd_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Makwam ñɨŋ nöbö mö weik mɨdöi kɨyöbö, Nöbö Ha nuŋwa nugwo ipɨtaŋ nugwön nugwo peñ; nugwo ömörö diba nöiöña. ");
INSERT INTO tmd_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nöbö Ha nuŋwa hön wop aku, maduar ör Noa mɨdöŋ wop aku rɨg röŋ mag akuyöbö cöna. ");
INSERT INTO tmd_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noa mɨdöŋ wop aku, nöbö mö bla ap mag nɨm gɨrön, röbö nɨm gɨrön, mö nuö nuö nöl pɨ gɨrön, rɨ mɨdɨm nugugɨrön, Noa nuarö nuömarö bɨyöj möla dum nugugɨrön, ruö ib diba rɨlö, rɨ yöxmɨn, bana wölön nöbö mö akuyöbö ñɨgö magalɨg pɨ yuö abmɨn wöröx pörmä. ");
INSERT INTO tmd_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Makwam nöbö Lot mɨdöŋ wop aku, Sodom nöbö mö bla algör ör ap nɨm gɨrön, röbö nɨm gɨrön, ap piaku sɨm rɨ gɨrön, ap möriwö rɨb piaku rɨ gɨrön, ram ur gɨrön, rɨ mɨdɨm nugugɨrön, ");
INSERT INTO tmd_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lot mögörɨb aku röböxön, mögörɨb hör möl i dum nugugɨrön, wop akwör, rɨn pin diba adöx kau sebö pɨnön, Sodom nöbö mö ñɨgö magalɨg yön bɨc um duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nöbö Ha nuŋwa hön wop aku, mag aliö akwör cöna. ");
INSERT INTO tmd_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Wop aku, nöbö mö ram cölöbö sö mɨjöñ aku, ap ñɨŋ bla ram möl bö mɨd aku pɨba ram möl bö dueñ. Nöbö mö möriwö rɨb bla yönmɨjöñ piaku, ap bli pɨba höbkal rama dueñ. ");
INSERT INTO tmd_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot mönɨŋ nugwo röŋ adakwör rɨbyöx nugwön, nugw ri aböña. ");
INSERT INTO tmd_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nöbö mö bɨl kai, nɨ keir nugw ri abön kömö mɨjɨnö, rön rɨbyöx nugwön aku, wöröxöna; jɨ nöbö mö bɨl kai, Krais mönö wä yad akuyöbö mabö nuŋwa rɨp dumɨdön wöröxnö, rön rɨbyöx nugwön aku, kömö mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ñɨgö yadmɨdla, wop aku pɨxmag yuö bö nöbö mös äbäñ döul paŋyöbö i hölɨm gɨ mɨjöñ aku, i pön, i röböxna. ");
INSERT INTO tmd_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Mö mös wit maga pal pat piöpi rɨmɨjöñ aku, i pön, i röböxna. ");
INSERT INTO tmd_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nöbö mös möriwö rɨb piaku mabö rɨ mɨjöñ aku, i pön, i röböxnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jisas aliö rɨmɨn, ñɨŋ yadmä, “Nöbö Dib, mönö yadmɨdlö aku, mögörɨb kai aliö cön?” rɨmä. Aliö rɨmɨn, Jisas yadöŋa, “Urap döuyö i wöröx gɨ mɨjön yöraku, yöur gwolgwäbö nugwön hö sɨsɨb nɨgmɨjöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisas, nöbö nɨ bla rɨb mɨga yöxölön, God höjöpal gör mɨdɨŋ, me rön, ñɨgö mönö i mönö höd röxön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Mögörɨb i, mönö pɨ nuöm nɨgɨb nöbö dib i mɨjöna. Makwam nöbö aku, nuŋ God rɨbyöx nugwen; nöbö mö bla ñɨgö uliöxen. ");
INSERT INTO tmd_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Makwam mö wösrö mögörɨb akuyöbö i, öim hö nugwo yajöna, ‘Nöbö kwolmal na mönö anɨŋ aku nugwö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Aliö cön aku, jɨ mönö pɨ nuöm nɨgɨb nöbö dib aku mönö nuŋ aku pen. Jɨ mö wösrö aku, nuŋ öim öim hö yad nugu gör mɨdaŋ mɨdaŋ, mai nöbö dib aku yajöna, ‘Nɨ God nugwo ipöxöi; ñɨgö nöbö mö piaku algör uliöxöi; ");
INSERT INTO tmd_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","jɨ mö wösrö kɨ nɨ öim öim hö yad nugu gör mɨdɨm mɨdɨm nɨ ipɨt makwam, nɨ du mönö dib aku yad nugunö,’ cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Nöbö Diba aliö rön yadöŋa, “Mönö pɨ nuöm nɨgɨb nöbö aku nöbö mö uliöxölöŋ, jɨ nuŋ mönö kai yadöŋ aku nugw ri aböña. ");
INSERT INTO tmd_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ñɨŋ rɨb kai yöx nugwöi? God nuŋ nöbö mö nuŋ keir yad nɨg bla, mil pɨxmag yuö nugwo höjöpalmɨjöñ aku, mönö ñɨgö nugwön uliöxön nugwenɨŋö, rön, nugwöi? Ñɨŋ mɨxɨl magi pöx mɨjöñɨŋö, rön nugwöiŋ ä? ");
INSERT INTO tmd_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nɨ ñɨgö yadmɨdla, nuŋ mönö yajöñ aku nugwön, ñɨgö ögwö yöxön, yadkap ör nöbö kwolmal ñɨŋa rɨ gwogwam cöñ akuyöbö ödöia idɨxöna. Makwam Nöbö Ha nuŋwa mögörɨb il kɨ höbkal hön wop aku, nöbö mö bli nugwo nugw pɨ gör mɨjöñɨŋönö wöhö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nöbö mö bli, an nöbö mö wä, nöbö mö bli nöbö mö gwogwo, me rön, nugwim akuyöbö, Jisas ñɨgö mönö i mönö höd röxön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Perisi nöbö i, takis pɨb nöbö i, God höjöpalɨba, God höjöpalɨb rama diöña. ");
INSERT INTO tmd_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Perisi nöbö aku, rɨb nuŋ akwör God höjöpalön yajöna, ‘Nagö ri ablaŋe rɨmɨdla. Nɨ nöbö bli rɨg röi akuyöbö, ap wä mɨga akwör pön, ap kib pön, mö kib mag yönön, röi. Nɨ takis pɨb nöbö kɨyöbö kɨ röxgɨb yöi. ");
INSERT INTO tmd_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Iŋpɨlö paŋ paŋ wop mös ap mag nɨmöi aipam. Öim ap nɨ akuyöbö ragpɨd sö pön, nagö paŋyöbö i nöilö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Makwam takis pɨb nöbö aku, nuŋ möigw yöxön, adöx yöd röul adö kau sö nugwen; hör hör yörakwo iröpa ubɨlön, ibön nuŋwa keir palön, rɨb mɨga yöx nugwön yajöna, ‘God, nɨ nöbö ap kib mag gwogwo rɨl aku, nɨ ögwö yöxö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ñɨgö yadmɨdla, takis pɨb nöbö aku aliö yadaŋ, God nugwo, ap kib mag gwogwo rɨlö aku nugwön röböxmɨdlö, cöna. Makwam God nuŋ Perisi nöbö aku nugwo aliö yaden. Aku agapɨm: nöbö mö ib ñɨŋa keir pɨrag wöiöñ bla, God raŋ ib ñɨŋa pɨn pal diöna. Jɨ nöbö mö ib ñɨŋa pɨrag wöleñ bla, God raŋ ib ñɨŋa mɨjönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nöbö mö bla, Jisas halöu ha ulul anɨŋ kɨyöbö pɨ nugwaŋ, me rön, pön hömä. Jisas ñɨgö pɨ nugum nugugɨrön, nöbö nuŋ bla almɨdim aku nugwön, nöbö mö piakuyöbö ñɨgö yadyöxön yadmä, “Ñɨŋ akuyöbö almɨjeñ,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jisas piöŋö halöu ha piaku wö rɨm hömɨdmɨn, nöbö nuŋ bla ñɨgö yadöŋa, “Pödpöd rɨmɨn ñɨgö aliö yadyöxmɨdöi? Halöu ha ulul piaku röböxɨŋ nɨ pöl höŋ. God nöbö mö pön adöx yöd röul adö kau sö nugwidɨx mɨdɨb aku, halöu ha ulmɨdö piaku röxg mɨjöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","God Mönö yad nölön, God nöbö mö pön nugwidɨx mɨdɨb mönö aku aliö mɨdö, rɨmɨjöñ aku, halöu ha ulul bla God Mönö aku nugwön, rɨmgör nugw pöña. Makwam, nɨ ñɨgö mi yadmɨdla, nöbö mö halöu ha ulul nɨ rɨg nugw pöi mag aliö akuyöbö nugw pɨmɨjöñ bla, God ñɨgö pön nugwidɨx mɨjöna. Jɨ nöbö mö halöu ha ulul nɨ nugw pöi mag aliö akuyöbö nugw peñ bla, God mögörɨb nuŋ yör sö dueñ. ");
INSERT INTO tmd_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Juda nöbö dib i Jisas mɨdöŋ yöra hön yadöŋa, “Mönö yad nölɨb nöbö wä na. Nɨ pödpöd rön, öim mɨdɨb mag aku pɨn?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Aliö rɨmɨn, Jisas yadöŋa, “Nɨ pödpöd rɨmɨn, ‘Nöbö wä,’ me rɨlö? Nöbö mö i wä mɨdöl; God paŋyöbö akwör Nöbö wä mɨda. ");
INSERT INTO tmd_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Makwam nagö God lo mönö aku nugulö: ‘Mö kib nöbö kib rɨmɨjeñ; nöbäpö pɨlmɨjeñ; ap kib pɨmɨjeñ; mönö diba yajöñ piaku du mönö inakmönö hörön yadmɨjeñ; nauö nam rɨg yajöñ mönö akwör yöxön mai dinö,’” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Jisas aliö rɨmɨn, nöbö aku yadöŋa, “Nɨ haŋal mɨd akwör ila nɨgön, lo mönö ada piaku magalɨg rɨp hö hö, weik wop kɨ paŋ mag akwör rɨ mɨdlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jisas mönö aku nugwön yadöŋa, “Ap paŋyöbö iör röiö. Ap nagö blaku magalɨg sɨm rön, rɨg pön, nöbö mö lɨblɨb rɨ mɨdö bla nölö. Naŋ almɨjɨnö aku mɨ, mɨd ri abɨb mag nagö aku mɨjön God mögörɨb adöx yöd röul adö kau sö. Rɨg yadɨl akuyöbö rön, han, nɨ pɨsaŋ yönmɨdɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Jisas mönö aku yadɨm, Juda nöbö dib aku rɨg ap nuŋ bla mɨga mɨdöŋ aku, audiöx nugwön rɨb diba yöx nugwöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Rɨb diba yöx nugumɨdöŋ aku, Jisas nugwo nugwön yadöŋa, “Nöbö mö ap mɨga mɨjön akuyöbö, mɨŋi rɨ öliöxön God nöbö mö nuŋwa mɨdɨŋ, ñɨgö pön ram nuŋwa nugwidɨx mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Hön kamel bla kai mauöl nag aböi möl aku dinöb, mɨŋi rɨ öliöxön diöñ aku, jɨ nöbö mö köme ulnöu ap bla mɨga mɨd akuyöbö, God mögörɨb nuŋ aku mɨŋi rɨ öliöxön diöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jisas aliö rɨmɨn, nöbö mö mɨdim bla yadmä, “Mönö yadmɨdlö aku, God nuŋ nöbö mö i kömö pɨb maga nɨgöl owa agapɨm?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Aliö rɨmɨn, Jisas yadöŋa, “Adö bli nöbö mö rɨb maga nɨgöl aku, jɨ God nuŋ cɨnöb paŋ rɨb akwör nɨgö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Jisas aliö rɨmɨn, Pita yadöŋa, “Mɨ! Ram ap an akuyöbö magalɨg röböxön, nagö pɨsaŋ paŋör alɨp yönmɨdɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Aliö rɨmɨn, Jisas ñɨgö yadöŋa, “Ñɨgö mi yadmɨdla, nöbö mö, God mönö wä nuŋ aku pɨrag yönɨŋö, rön, ram rɨb, mönɨŋ, nɨmam, nuö nuöm, halöu ha ñɨŋ bla röböxöñ aku, God ñɨgö uplöbenɨm. ");
INSERT INTO tmd_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Weik mɨdöl wop mibɨl yörɨk, God nuŋ ñɨgö nugwidɨx mɨd ri abön raŋ, ap ñɨŋ bla, nöbö mö ñɨŋ bla, magöri maga rɨg mɨjöna. Makwam wop maiyöbö aku, nuŋ pɨsaŋ öim öim mɨjöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisas nöbö nuŋwa akuyöbö möl sö ñɨgö pön rɨb piaku duön yadöŋa, “Nugwi. Weik Jerusalem dumɨdöla. Du röpɨñɨnɨŋ aku, Nöbö Ha nuŋwa nugwo, God mönö yadɨb nöbö bla maduar ör God Mönö aku kai kɨtön rɨg yadim mag akwör cöña. ");
INSERT INTO tmd_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nugwo pön, Juda nöbö yöi akuyöbö imag rol ñɨgö nɨgɨŋ, nugwo yad höimöuön, ñɨlöŋ nɨg gɨrön, höpöl pɨlön, naga pɨ palön, mɨ aŋadö pɨl pal nɨgöña. ");
INSERT INTO tmd_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Makwam wop mös mɨdön, wop paŋ aku höbkal öbiönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Makwam Jisas aliö rɨmɨdmɨn, nöbö nuŋ bla rɨbyöx nugub maga nɨgölmɨn, mönö rɨg yadmɨd aku, me rön, lɨbak nugwölim. ");
INSERT INTO tmd_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Makwam mai, Jisas du Jeriko uröpɨnmɨn nugugɨrön, nöbö mämäg we i mɨdöŋa. Nöbö aku nuŋ ödöi kwol yöraku römɨd gɨ mɨdön, rɨg ap nöinö, rön, sö rɨ mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nöbö mö mɨga akwör mönö pɨp hö padɨxmɨn nugugɨrön, nuŋ nöbö mö bli ñɨgö yad nugwön yadöŋa, “Pödpöd rɨmɨdöi?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Aliö rɨmɨn, yadmä, “Jisas nöbö Nasaret yöbö aku hön dumɨdö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Aliö rɨmɨn, nuŋ wö diba rön yadöŋa, “Jisas, Depid Ha nuŋwa, nɨ ögwö yöxö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Aliö rɨmɨn, nöbö mö hö dumɨdim bla nugwo yadyöxön yadmä, “Pödpöd rɨmɨn wölmɨdlö? Dar mɨdö!” rɨmä. Aliö yadim aku, jɨ nuŋ tar mɨdölöŋ. Wö mɨ diba rön yadöŋa, “Jisas, Depid Ha nuŋwa, nɨ ögwö yöxö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Aliö rɨmɨn, Jisas nugwön aŋöi nɨgön, nöbö mö akuyöbö ñɨgö yadöŋa, “Yölɨŋ il yörɨk hönö,” röŋa. Aliö rɨmɨn, pön hömɨn yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nagö pödpöd cɨnö?” röŋa. Jisas aliö rɨmɨn, yadöŋa, “Nöbö Dib, nɨ raŋ mämäg na aku iswob nugunöm,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Aliö rɨmɨn, Jisas nugwo yadöŋa, “Jisas nɨ raŋ, mämäg na ix nugunö, rön, rɨbyöx nugw pɨlö aku mɨ, mämäga ix nugwö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jisas aliö rɨmɨn, wop akwör mämäga ix nugwön, God iba yadmɨn bɨl sö dumɨn nugugɨrön, Jisas dumɨdöŋa yöraku mai duöŋa. Nöbö mö magalɨg Jisas röŋ aku nugwön, God iba yadmɨn bɨl sö duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisas Jeriko duön, mibɨl yöra u dumɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Makwam Jeriko yöraku, rɨg ap mɨga mɨdmɨd nöbö i, takis pɨb nöbö piaku ñɨgö magalɨg nugwidɨx mɨdmɨda. Ib nuŋwa Sakias. ");
INSERT INTO tmd_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jisas taun mibɨl yöraku padɨxmɨn nugugɨrön, nöbö mö mɨga akwör hö nuguba rɨmɨdmä. Sakias nuŋ nöbö metyöbö maga makwam, Jisas nöbö pödiöm mɨd aku nugunöm, rön, nugwöŋa, jɨ nugwölöŋ. ");
INSERT INTO tmd_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Almɨn, nuŋ höd ipalɨp du bɨ römö i wölu bɨl sö mɨdön, Jisas hömɨdöŋ möl sö nugugu mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jisas nuŋ bɨ wöl mɨdöŋa il yöraku hön, pisö laxiö nugwön, Sakias nugwo yadöŋa, “Sakias, nagö rɨmɨg il kɨ pɨnö! Weik nagö pɨsaŋ du ram nagö mɨjɨnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jisas aliö rɨmɨn, Sakias il bö pɨnön, wahax pɨ gɨrön, Jisas nugwo yölɨŋ pön ram nuŋwa duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nöbö mö bla alöŋ aku nugumɨn ölɨsö wölɨm yadmä, “Nöbö aku du nöbö ap kib mag gwogwo rɨ ram aku hölɨmba dumɨdö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Makwam Sakias öbɨlön, Jisas nugwo yadöŋa, “Nöbö Dib, nagö nugwö! Weik ap nɨ bla nuöm nɨg adöi nɨgön, adöi nöbö mö lɨblɨb rɨ mɨdö bla ñɨgö nöina. Makwam nɨ höd inakmönö hörön, nöbö mö bli ap ñɨŋa kib pɨbä rɨm aku paiŋö nöinö, rön, ap paŋyöbö i kib pɨm aku, paiŋö mös mös nöina; jɨ ap mös kib pɨm aku, paiŋö akuyöbö amñaxɨb sö nöina. Alön rɨp dumɨd dumɨd magalɨg rɨba wöd pörön röböxnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Aliö rɨmɨn, Jisas yadöŋa, “Nöbö kɨ Ebraham ha nuŋwa i. Wopik God nuŋ yam ram yörɨk hölɨmmɨdöi, ap kib mag gwogwo röi piaku nugwön röböxön kömö pa. ");
INSERT INTO tmd_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nöbö Ha nuŋwa höŋ aku, nöbö mö hölögɨp mɨdöi akuyöbö, ñɨgö hölu nugwön kömö pɨnö, rön, hö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Makwam nöbö mö piaku, Jisas mɨ, Nöbö Dib öim pöx mɨdmɨdöl aku, Jerusalem duaŋ, nugwo kiŋ yad nɨgɨŋ, an nugwidɨx mɨdaŋ, mɨd ri abönɨŋö, rön, rɨb aku yöx nugumä. Jisas, rɨb ñɨŋ aliö yöx nugumä aku, nuŋ keir nugwön, ñɨgö mönö i kwo höd röxön yadöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jisas mönö höd röxön yadöŋa, “Nöbö dib i, nɨ nugwidɨx mɨd nöbö dib na mɨd yöra dumön, nɨ kiŋ yad nɨgaŋ, höuöil hön, nöbö mö mögörɨb nɨ kɨyöbö ñɨgö kiŋa nugwidɨx mɨjɨnö, rön, mögörɨb pad dib piaku diöna. ");
INSERT INTO tmd_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Makwam höd nöbö mabö rɨb nuŋ akuyöbö ragpɨd sö ñɨgö wö raŋ hömɨjöña, nöbö dib nuŋwa rɨg mag gol paŋ paŋ hörɨrör nuöm nɨgön yajöna, ‘Rɨg mag gol nölmɨdɨl kɨ pön, sɨm rɨ höuöilmel rön, mɨga pɨ nɨgmɨdɨŋ; mai nɨ höuöil hönö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Aliö rön diöna aku, jɨ nöbö mö mögörɨb nuŋ nugwidɨx mɨdöŋ bla, nugwo ölɨsö wölaŋ nugugɨrön, nöbö bli yad abɨŋ, mai duön, nöbö dib ödöriö aku nugwo yajöña, ‘Nöbö kɨ nuŋ kiŋ ana mɨdenɨŋö,’ cöña. ");
INSERT INTO tmd_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Makwam nöbö dib ödöriö aku mönö ñɨŋ aku pen; nöbö dib aku nugwo kiŋ ñɨŋa yad nɨgöna. Alaŋ, kiŋ aku nuŋ höbkal hön, mabö rɨ nölɨb nöbö nuŋ piaku ñɨgö yad wö raŋ hömɨdɨŋ, yajöna, ‘Rɨg mag gol nöil piaku, ñɨŋ pɨ sɨm rɨ höuöilmel rön, paiŋö pödiö pöi?’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Yadaŋ, höd hön nöbö aku yajöna, ‘Nöbö dib, rɨg mag gol paŋyöbö nɨ nölmö aku, nɨ sɨm rɨ höuöilmel rön, paiŋö akuyöbö ragpɨd sö rɨg mag gol pɨlö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Aliö rɨmɨdaŋ, nöbö dib nuŋ aku yajöna, ‘Nagö rɨ ri ablö. Ap ulmɨdö aku nölmön mabö rɨ ri ablö aku, weik taun dib akuyöbö ragpɨd sö nagö yadmön nugwidɨx mɨjnaŋö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Makwam nöbö i hön yajöna, ‘Nöbö dib, rɨg mag gol paŋyöbö nɨ nölmö aku, nɨ sɨm rɨ höuöilmel rön, paiŋö akuyöbö mömɨd sö rɨg mag gol pɨlö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Aliö rɨmɨdaŋ, nöbö dib nuŋ aku yajöna, ‘Ailö aku, weik taun dib akuyöbö mömɨd sö yadmön nugwidɨx mɨjnaŋö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Makwam mabö rɨb nöbö nuŋwa i kwo hön yajöna, ‘Nöbö dib, nör nugula. Nagö nöbö ölöm. Nöbö mö bli ap ñɨŋ bla, nagö sɨm rɨ ri abön röiö; wobön um pɨn pɨlö. Ap mabö öliöxön rɨ yuöi piaku, nagö ususör rön nɨmlö. Makwam, nɨ nagö ipöxɨl aku, rɨg mag gol paŋyöbö nɨ nölmö aku, nɨ pön du köpö rin rogw rɨ nɨgmön mɨdöŋa. Rɨg mag gol paŋyöbö nagö aku weik pön höl mɨk,’ me cöna. ");
INSERT INTO tmd_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Aliö rɨmɨdaŋ, nöbö dib nuŋ aku yajöna, ‘Mönö nagö yadlö aku pɨ höuöilön, nagö pɨsaŋ mönö diba nɨgɨna. “Nagö nöbö ölöm, nöbö mö bli ap ñɨŋ bla, nagö sɨm rɨ ri abön röiö; wobön um pɨn pɨlö; ap mabö öliöxön rɨ yuöi piaku, nagö ususör rön nɨmlaŋö,” rɨlö ä? ");
INSERT INTO tmd_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Makwam, pödpöd rɨmɨn rɨg mag gol nɨ aku pön du rɨg rama nɨgman, höbkal hön hör um bli kwo alɨg pöi kömö?’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Aliö rön, nöbö il yöra mɨjöñ akuyöbö ñɨgö yajöna, ‘Rɨg mag gol nɨ aku höuöil pön, nöbö yöraku rɨg mag gol ragpɨd sö mɨd aku nugwo nöinö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Aliö rɨmɨdaŋ, yajöña, ‘Nöbö dib. Nuŋ rɨg mag gol ragpɨd sö mödö mɨdö!’ cöña. ");
INSERT INTO tmd_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Aliö rɨmɨdɨŋ, yajöna, ‘Ñɨgö yadmɨdla, öim nöbö mö ap ñɨŋ mɨga mɨjön bla, bli kwo rol ab pöña, jɨ nöbö mö ap ñɨŋ ulul ulul mɨjön bla, ap ulmɨdö mɨd aku aŋadö hölögɨpöna. ");
INSERT INTO tmd_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Makwam nöbö mö nɨ nugumɨn ölɨsö wölɨm, nöbö aku nuŋ kiŋ ana mɨdenɨŋö, rim akuyöbö, ñɨgö du pön hö, mämäg il rol nɨ yörɨk pɨl pal nɨgi,’ cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisas ñɨgö mönö aku yadön, nöbö nuŋ bla pɨsaŋ Jerusalem duŋö, rön, nuŋ höd duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Dumɨd dumɨd Olip Pɨd yöra, ram yöj lɨglɨg agrö Betpagi Betani ramɨxrö yöra womiöx uröpɨnön, nöbö nuŋ mös ñɨgö höd yad abön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Ram yöj agrö möl aku duön nugwöña, hön donki maua nöbö mö pɨ yönölöi i, nag wabɨl nɨg gɨŋ mɨjön aku yau pön höña. ");
INSERT INTO tmd_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Makwam nöbö mö bli hön, ‘Hön donki aku pödpöd rɨmɨn yau pön dumɨdöiŋö,’ rɨmɨdɨŋ, yajöña, ‘Nöbö Dib aku mabö mɨdmɨn anɨŋ yad abmɨn, pɨba hölɨŋö,’ cɨne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jisas aliö rɨmɨn, ñɨŋ duön nugumɨn, rɨg yadöŋ mag akwör rɨg mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Du naga yaumɨn nugugɨrön, nöbö hön donki mɨnöbö bla hön yadmä, “Hön donki mau aku pödpöd rɨmɨn naga yaumɨdöi?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Aliö rɨmɨn yadmä, “Nöbö Dib aku mabö mɨdmɨn anɨŋ yad abmɨn, hö naga yaumɨdölɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Aliö rön, hön donki mau aku naga yau pön Jisas mɨdöŋ yöra pön duön, wölɨj ñɨŋ wab bli pɨ rödön, pɨ hön donkia rol sö nɨgön, Jisas nugwo pɨ hön donkia rol sö nɨgmä. ");
INSERT INTO tmd_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jisas donkia rol sö römɨdön, ödöi aku dumɨn nugugɨrön, nöbö mö akuyöbö wölɨj ap ñɨŋa bli rag hö ödöi rol aku yödɨm nugugɨrön, Jisas römɨd gɨ mɨdöŋ hön donki aku wölɨj ap ñɨŋa bla rola röbɨp duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Dumɨd dumɨd Jerusalem igöp igöp rɨm nugugɨrön, Olip Pɨd ödöi rɨmö pibö rɨb yöraku, nöbö mö nuŋ bla mɨga, magalɨg nugwo mɨ ödöriö wahax pɨ gɨrön, ap agap apɨm röŋ akuyöbö rɨb aku yöx nugu gɨrön, wö diba rɨ gɨrön, God iba pɨrag wölön yadmä, ");
INSERT INTO tmd_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Nöbö Diba nuŋ Kiŋ anɨŋa yad abmɨn hö mɨk, God nugwo pɨ ri aböna! God mögörɨb adöx yöd röul adö kau sö yöraku, höbwab höimölɨb höimölɨb mag akwör mɨda. God nuŋ adöx mɨ bɨl sö mɨdön, nuŋ mil mag wä keiryöbö alɨg mɨdö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Aliö rɨmɨn nugugɨrön, Perisi nöbö bli mibɨl yöraku mɨdim akuyöbö, Jisas nugwo yadmä, “Mönö yad nölɨb nöbö. Nöbö mö nagö akuyöbö ñɨgö yadyöxaŋ, mönö aliö akuyöbö yadölɨŋ,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Aliö rɨmɨdmɨn, Jisas paiŋö yadöŋa, “Ñɨgö yadmɨdla, ñɨŋ mönö akuyöbö yadmɨjeñ aku, rɨg bla keir wö cöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jisas Jerusalem igöp igöp rɨ gɨrön, taun dib aku nugwön, mäp röbö pɨnmɨn nugugɨrön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Mögörɨb Jerusalem kɨ, ñɨgö mɨ ödöriö ögwö yöxmɨdla. Nɨ ñɨgö pɨ God pɨsaŋ nɨgiö nɨgön, höbwab höimölɨb maga ñɨgö nölɨba höma nugwöyɨx aku, wä röxa. Makwam weik ñɨŋ nugwölön, mämäg we röxg mɨdöia. ");
INSERT INTO tmd_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mai nöbö kwolmal ñɨŋa hön, taun dib ñɨŋ kɨ, lɨgɨna ab yuö nɨg mɨjöñ aku, ");
INSERT INTO tmd_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","hön rɨ gwogwam rɨŋ, möriwö kul, ram bla magalɨg, rɨg i rɨg i rol sö waxön mɨdenɨm; nöbö mö, halöu ha, rɨg kul yuadö mɨjöñ akuyöbö ram alɨg pal gɨlɨx ab gɨlɨx rɨ aböña. God ñɨgö pɨba hö wop kɨ nugwölöi makwam, mag akuyöbö aiönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jisas aliö rön, God höjöpalɨb rama duön, nöbö mö sɨm rɨmɨdim akuyöbö ñɨgö yad rɨŋö bö ab gɨrön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“God Mönö aku kai kɨtön yadmä, ‘Ram na aku, nɨ höjöpalɨb rama mɨjönɨŋö,’ rɨmä aku, jɨ ñɨŋ sɨm rön rɨm rɨm, nöbö mö ap kib pön, rag hö umadiö hölɨmmɨdöi ram i röxgö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Makwam Jisas nuŋ öim öim, wop paŋ paŋ du God höjöpalɨb rama ram möl yuadö nöbö mö bla ñɨgö mönö yad nölmɨdöŋa. God ap höjöpal ur nölɨb nöbö dib bla, lo mönö yad nölɨb nöbö bla, mönö pɨ nuöm nɨgɨb nöbö bla, nugwo pɨl pal nɨgnɨŋö, rön, rɨba paŋ akwör yöx nugumɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Aliö rɨbyöx nugumä aku, jɨ nöbö mö magalɨg, mönö wä nuŋwa nuguŋö, rön, nugwo wahax pɨm nugugɨrön, ñɨŋ Jisas nugwo pɨl pal nɨgɨb maga mɨdölöŋ. ");
INSERT INTO tmd_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Makwam wop mibɨl yöraku, Jisas nuŋ God höjöpalɨb rama ram möl yuadö duön, nuŋ nöbö mö pɨ God pɨsaŋ nɨgiö nɨgön mönö wä aku yad nöl mɨdöŋa nugwön, God ap höjöpal ur nölɨb nöbö dib bla aipam, lo mönö yad nölɨb nöbö bla aipam, mönö pɨ nuöm nɨgɨb nöbö bla aipam hömä. ");
INSERT INTO tmd_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Hön nugwo yadmä, “Yönɨm nagö yadɨm, naŋ hön mag aliö rɨp yönmɨdlö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Aliö rɨmɨn, Jisas yadöŋa, “Nɨ ñɨgö paiŋö yad nugub i yad nuguba rɨmɨdla. ");
INSERT INTO tmd_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jon nöbö mö bla ñɨgö röbö pal nölmɨd aku, God nuŋ yadɨm alöŋ mönö rɨb nuŋwa keir yöx nugwön alöŋ?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Jisas aliö rɨmɨn, ñɨŋ keir nuö nuö yad nugup duön yadmä, “‘God yadɨm, Jon nöbö mö bla ñɨgö röbö pal nölö,’ cɨnɨŋ aku, nuŋ yajöna, ‘Makwaim, mönö nuŋ aku pödpöd rɨmɨn pölöi?’ cöna. ");
INSERT INTO tmd_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Jɨ ‘Jon rɨb nuŋwa keir yöx nugwön, nöbö mö bla ñɨgö röbö pal nölö,’ rɨmɨjnɨŋ aku, nöbö mö kɨyöbö, God nuŋ Jon mönö yadɨb nöbö nuŋ aku yad nɨgmɨn hön rɨmɨdö, rön nugwöi aku, ñɨŋ ölɨsö rödön anɨŋ rɨg röd pal nɨgöñɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Makwam ñɨŋ rɨb aku yöxön, Jisas nugwo paiŋö yadmä, “Jon hön nöbö mö akuyöbö ñɨgö mönö yad nölön, röbö pal nölön röŋ aku, an nugwölöl, God yadɨm röŋ mönö rɨb nuŋwa keir röŋ aku an nugwölölɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Aliö rɨmɨn, Jisas ñɨgö yadöŋa, “Ñɨŋ nɨ paiŋö yad nölölöi aku, nɨ piöŋö yön yadɨm hön rɨmɨdɨl aku, ñɨgö algör ör yad nölöinö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jisas nöbö mö akuyöbö ñɨgö mönö höd röxön yadöŋa, “Nöbö i wain möriwö rɨb mɨŋi rɨ yuön, nöbö mö bli yad nɨgön, du mögörɨb pad piaku mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Makwam wain maga göj yön wop aku, nöbö nuŋ i yad abön yajöna, ‘Du nöbö mö wain mabö rɨ mɨdöi akuyöbö ñɨgö yadaŋ, wain mag nɨ bli nölɨŋ rag hane,’ cöna. Yadaŋ uröpɨnaŋ, nöbö mö wain mabö rɨ mɨjöñ akuyöbö nugwo palmɨd palmɨd nɨgön, hör yad abɨŋ höbkal höna. ");
INSERT INTO tmd_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Akuyöbö alɨŋ, nöbö wain möriwö mɨnöbö aku, nöbö i piöŋö yad abaŋ diöna. Dumɨdaŋ nugwo algör ör palmɨd palmɨd nɨgön, hör yad abɨŋ höbkal höna. ");
INSERT INTO tmd_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Akuyöbö alɨŋ, nöbö yoŋyöbö i yad abaŋ uröpɨnaŋ, nugwo mɨ göj palön, pön pɨxɨp du nöla rɨŋö bö aböña. ");
INSERT INTO tmd_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Akuyöbö alɨŋ, nöbö möriwö mɨnöbö aku yajöna, ‘Nɨ pödpöd cɨn? Ha madmag yöbö na agal abɨn aku, mönö nuŋwa yadmɨjön aku nugubä maga rö,’ rön, aböna. ");
INSERT INTO tmd_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Abaŋ uröpɨnaŋ, nöbö mö wain mabö rɨ mɨjöñ piaku yajöña, ‘Hö ha kɨ, nuö wain möriwö aku nuŋ aŋö pɨb maga ra. Nugwo mɨ aŋadö pɨl pal nɨgön, an aŋö pɨŋö,’ cöña. ");
INSERT INTO tmd_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Aliö rön, nugwo pön pɨxɨp du nöla rɨŋö bö duön, aŋadö pɨl pal nɨg gɨŋ wöröxöna. “Makwam akuyöbö almɨdɨŋ, nöbö möriwö mɨnöbö aku ñɨgö agamö cön? ");
INSERT INTO tmd_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nuŋ hön, nöbö mö piaku ñɨgö pɨl pal nɨgön, möriwö aku nöbö mö hör bli ñɨgö piöŋö yadaŋ nugwidɨx mɨjöñɨŋö,” röŋa. Jisas aliö rɨmɨn, nöbö mö nugugu mɨdim akuyöbö yadmä, “Yadlö mag akuyöbö rölaŋ!” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Aliö rɨmɨdmɨn, Jisas ñɨgö nugw pörön yadöŋa, “Aliö rɨmɨdlö aku, jɨ aku, God Mönö kai kɨtim rɨb mɨŋi lɨbak nugwön il aku nɨ yad nöli. Yadmɨdɨl rɨb mɨŋ aku aliö mɨda, ‘Nöbö ram urɨb bla, rɨg i wä rölaŋ, me rön, röböxɨm rɨg aku weik ram padö mibɨl yöbö pɨn nöl gɨ mɨdö,’ rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Nöbö mö kai kai hö pɨn rɨg rol aku pɨn bɨcöñ piaku, ñɨgö aŋadö palɨx döbdö rɨ nɨgöna. Jɨ rɨg aku mölöd pɨnön nöbö mö palölö cön piaku, ñɨŋ aŋadö pal caku rɨ nɨgönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jisas aliö rɨmɨn, anɨŋör yadmɨdö, rön, lo mönö yad nölɨb nöbö bla aipam, God ap höjöpal ur nölɨb nöbö dib bla aipam, wopik ör nugwo mönö diba yajnɨŋö, rön nugwim aku, jɨ nöbö mö mɨga akwör nugugu mɨdim akuyöbö nugwön, ipöxön röböxmä. ");
INSERT INTO tmd_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Makwam Jisas nugwo pödpöd rön pön du mönö diba yajnɨŋö, rön, du nöbö mö bli ñɨgö mönömɨm rɨ nölön yadmä, “Ñɨŋ inag nöbö mö wä röxgön, du inag inag mönö bli yadɨŋ, paiŋö pödi yajönam nugwön, nugwo pön gapman nöbö mönö diba pɨ nuöm nɨgɨb aku pön dinɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Aliö rɨmɨdmɨn, nöbö piaku ñɨŋ duön nugwo mönö bli inakmönö hörön yadmä, “Mönö yad nölɨb nöbö, an nugwöla naŋ paŋ adöi ör duöiö; ödöriar yadlö. God Mönö aku nöbö mö akuyöbö ñɨgö yad nöilö aku, algör ör ödöriar yadlö. ");
INSERT INTO tmd_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Makwam, an pödpöd cɨnɨŋ? Rom gapman nöbö dib Sisa nugwo takis nöinɨŋönö wöhö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ñɨŋ inakmönö hörön inag yadim mönö aku nugwön, Jisas ñɨgö yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Rɨg takis nölöi aku i nɨ pɨ yabuŋ nugunö,” röŋa. Jisas aliö rɨmɨn, pɨ yabum nugwön yadöŋa, “Rɨg höñ aku, yönɨm inöma mɨd? Kai kɨtim aku, yönɨm iba mɨd?” röŋa. Jisas aliö rɨmɨn, yadmä, “Sisa inöm nuŋ aku mɨdɨm, ib nuŋwa mɨdö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Aliö rɨmɨn, Jisas ñɨgö yadöŋa, “Makwam, Sisa ap nuŋwa mɨdaŋ, Sisa nugwo nöli. God ap nuŋwa mɨdaŋ, God nugwo nöli,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jisas nuŋ nöbö mö mɨdim mibɨl yöraku aliö yadmɨdmɨn, mönö nuŋwa röd abɨb maga nɨgölmɨn, rɨb mɨga yöxön mönö i yadölim. ");
INSERT INTO tmd_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadiusi bla, nöbö mö wöröxön öbɨleñɨŋö, rön, rɨb aku yöx nugumɨdöia. Makwam Sadiusi nöbö bli Jisas mɨdöŋ yöra hön, nugwo yad nugub i yad nugumä. ");
INSERT INTO tmd_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Yad nugwön yadmä, “Mönö yad nölɨb nöbö. Mosɨs mönö i anɨŋ kai kɨtön yadöŋa, ‘Nöbö i mö pön, halöu ha yöx pön hen wöhö, hör wöröxön aku, pɨgnɨŋ nuŋ i piöŋö mö aku pön, hödnɨŋ halöu ha nuŋ aku, me rön, yöx pön hönɨŋö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Makwam, nöbö ila alɨg akuyöbö mɨj sö aku mɨjöña. Nöbö höda mö pön, halöu ha yöx pön hen wöhö, hör wöröxöna. ");
INSERT INTO tmd_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Wöröxaŋ, pɨgnɨŋ nöbö agñɨŋ rɨbyöbö aku piöŋö mö aku pön, algör ör halöu ha yöx pön hen wöhö, hör wöröxöna. ");
INSERT INTO tmd_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Alaŋ, pɨgnɨŋ nöbö igwö wölö aku piöŋö mö aku pön, algör ör halöu ha yöx pön hen wöhö, hör wöröxöna. Aliö alɨp dumɨd dumɨd, pɨgnɨŋ nöbö akuyöbö mɨj sö magalɨg halöu ha yöx pön heñ wöhö, hör wöröxöña. ");
INSERT INTO tmd_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mai mö aku algör ör wöröxöna. ");
INSERT INTO tmd_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Makwam wöröxön öbiöñɨŋö, rɨlö aku, mö paŋyöbö aku nöbö nuŋ akuyöbö mɨj sö mɨjöñ aku, mai nöbö kai mö nuŋwa mɨjön?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Aliö rɨmɨn, Jisas yadöŋa, “Weik mɨdöl wop kɨ, mö bla nöbö pöia, nöbö bla mö pöia. ");
INSERT INTO tmd_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Makwam nöbö mö God rɨmɨn öbɨlön, ram nuŋwa adöx yöd röul adö kau sö diöñ akuyöbö, mö bla nöbö peñɨm, nöbö bla mö peñɨm. ");
INSERT INTO tmd_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Makwam ñɨŋ iswob wöröxeñ; ejol bla röxg öim öim kömö mɨjöña. Ñɨŋ öbiöñ aku mɨ, God halöu ha nuŋwa mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nöbö mö wöröxön öbɨlöi mönö aku, Mosɨs algör ör rɨn yönmɨdöŋ haiwo aku yadön kai kɨtöŋa. Mosɨs mönö aku kai kɨtön yadöŋa, ‘Nöbö Diba nuŋ Ebraham, Aisak, Jekop, nɨ God ñɨŋa mɨdlö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nöbö mö höd wöröxim bla, ‘Nɨ God ñɨŋa mɨdlö,’ röŋ aku nugwön nugwöla, nöbö mö höd wöröxim bla wopik kömö mɨdöia. God nugwa, nöbö mö nuŋwa magalɨg kömö mɨdöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jisas aliö rɨmɨn, lo mönö yad nölɨb nöbö bli yadmä, “Mönö yad nölɨb nöbö, mönö paxdöriö mɨd akwör yadlaŋe!” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Jisas mönö yad ri abön röŋ aku nugwön, ñɨŋ ipöxiö, mai nugwo mönö bli yad nugwölim. ");
INSERT INTO tmd_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Makwam Jisas ñɨgö yadöŋa, “Nöbö mö bla pödpöd rɨmɨn, Mesaia aku Depid ha nuŋ akwör mɨdö, röi? ");
INSERT INTO tmd_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Depid nuŋ keir God Mönö rɨb Sam i kai kɨtön yadöŋa, ‘Nöbö Diba nuŋ Nöbö Dib na yadöŋa, “Nagö imag mɨrɨx nɨ adö römɨd gɨ mɨdön; ");
INSERT INTO tmd_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mɨdɨp duön nɨ kwolmal nagö akuyöbö ñɨgö rɨmön, yamsö mo nagö aku mɨdɨŋ ñɨgö röbɨl pat gɨ mɨjnaŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Makwam Depid nuŋ Mesaia aku nugwo, ‘Nöbö Dib nɨ,’ me röŋ aku, pödpöd rɨmɨn, Mesaia aku Depid ha nuŋ akwör mɨdö, röi?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nöbö mö bla nugugu mɨdɨm nugugɨrön, Jisas nöbö nuŋ akuyöbö ñɨgö yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Lo mönö yad nölɨb nöbö bla rɨg röi mag akuyöbö, ñɨŋ keir rɨb maga röi aku, nugw ri aböña. Ñɨŋ röi adaku, an piaku piaku yönɨŋ ib an akwör urɨŋ, me rön, wölɨj mɨxɨl bla röbön, nöbö mö bla pɨsaŋ mögum rɨŋ, nöbö mö akuyöbö ñɨŋ nugwön, ‘Nöbö dib bla hömɨdöiŋ e!’ rɨmɨjöñ aku, wahax pöña; Juda mögum rɨb ram bla duön, nöbö dib römɨdöi hogw rola römɨdöia; ap diba nɨmöñ wop aku, du nöbö dib römɨdöi kau akwör römɨjöña. ");
INSERT INTO tmd_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Lo mönö yad nölɨb nöbö bla, mö wösrö ram ap ñɨŋ bla kib pön, God höjöpainɨŋ aku, nöbö mö nugwɨŋ, me rön, mönö mɨxɨla pɨxön inakmönö hörön adö bli yadöia. Aliö alöi aku, mai ölɨŋ höb dib keiryöbö ödöriö pöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisas nuŋ God höjöpalɨb rama ram möl yuadö du mɨdön nugwöŋa, nöbö mö rɨg kap bla rɨg bli rag hö bɨyöj möla abmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Makwam mö wösrö lɨblɨb rɨ mɨdöy rɨg paskwolö ulmɨdö mag mös rag hö aböŋa. ");
INSERT INTO tmd_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Abmɨn, Jisas yadöŋa, “Nɨ ñɨgö mi yadmɨdla, nöbö mö bli rɨg ulmɨdö aböia; jɨ mö wösrö lɨblɨb rɨ mɨdö kɨ rɨg nuŋwa diba aba. ");
INSERT INTO tmd_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nöbö mö bli rɨg mag ñɨŋa mɨga mɨdɨm nugugɨrön rɨg mag aböia; jɨ mö wösrö lɨblɨb rɨ mɨdö kɨ rɨg mag nuŋ mɨda magalɨg aba. Ap wob nɨmɨb i mɨdölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Makwam nöbö nuŋ bli yadmä, “God höjöpalɨb ram kɨ rɨg wä wä, ap wä wä rag hö God nugwo nölön ud wabɨl nölim aku, wä rɨg mɨdö,” rɨmä. Aliö rɨmɨdɨm, Jisas nuŋ ñɨgö yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Aliö röi aku, jɨ mai ap wä nugumɨdöi piaku mɨdenɨm. Magalɨg hajal abɨŋ, rɨg i rɨg i rol aku mɨdenɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jisas aliö rɨmɨn, nugwo yad nugwön yadmä, “Mönö yad nölɨb nöbö. Wop kai mag akuyöbö cön? Agapɨm raŋ nugwön, weik mag aku rɨba rɨmɨdö, cɨnɨŋ?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Aliö rɨmɨn, Jisas ñɨgö yadöŋa, “Nugw ri aböña! Nöbö mö mɨga hön inakmönö hörön, ib na urön yajöña, ‘Nör hömɨdla. Wop dib aku hö,’ cöña. Aliö yadmɨjöñ aku, mi yadmɨdöiŋö, rön, ñɨgö mai dumɨjeñ. ");
INSERT INTO tmd_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Makwam mögörɨb möl bli öbɨlön, mögörɨb möl bli pɨsaŋ nuö nuö pɨlmɨjöña. Mögörɨb möl bli ñɨŋ ñɨŋ keir nuö nuö pɨlmɨjöña. Almɨjöñ aku nugwön, wop dib yadöi aku wöxnö nɨgɨba rɨmɨdö, rön, ipöxmɨjeñ. Wop dib aku mai wöxnö nɨgönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jisas aliö rön ñɨgö yadöŋa, “Mögörɨb adö bli öbɨlön, mögörɨb adö bli pɨsaŋ nuö nuö pɨlmɨjöña. Kiŋ bli yam ñɨŋ bla öbɨlön, kiŋ bli yam bla pɨsaŋ nuö nuö pɨlmɨjöña. ");
INSERT INTO tmd_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mögörɨb akuyöbö magalɨg mɨmön dib ödöriö pön, kiö diba pɨlön, ñɨpñɨp wödodö diba hön cöna. Ap yoŋyöbö adöx yöd röul adö kau sebö raŋ, ap keiryöbö hör ipöxbä röxgɨb mag akuyöbö yör sö cöna. ");
INSERT INTO tmd_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ap piaku mai mag akuyöbö cöna, jɨ höd nɨ paŋör pɨsaŋ mɨdöi akuyöbö, ñɨgö rɨ gwogwam cöña. Ñɨgö mönö diba yadɨba, pön Juda mögum rɨb ram bla du nɨgön, mönö diba yadön, ñɨgö nag nɨgön, pön kiŋ gapman nöbö dib bla pön diöña. ");
INSERT INTO tmd_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ñɨgö almɨjöñ aku, mönö wä na aku ñɨgö wöxnö yad nölɨb maga cöna. ");
INSERT INTO tmd_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Makwam ñɨgö mönö diba yadmɨjöñ aku, mönö pödiöm aliö paiŋö yajnɨŋö, rön, höd hölu nugumɨjeñ. ");
INSERT INTO tmd_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nɨ keir ñɨgö rɨb wä nölön mönö maga nölmön, ñɨŋ mönö akwör yad nölɨŋ, ñɨŋ paiŋö yadön mönö aku röd abɨb maga mɨden. ");
INSERT INTO tmd_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Makwam nauö nam, haul mölöu nöbö, nöbö hödɨg nugup, nöbö nugub ñɨŋa keir bli ñɨgö mönömɨm rön, pɨ kwolmal imag rola nɨgɨŋ, ñɨgö bli aŋadö pɨl pal nɨgöña. ");
INSERT INTO tmd_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nɨ nugw pöi nöbö mö akuyöbö, nöbö mö bla ñɨŋ magalɨg ñɨgö rɨb gwogwo yöxöña. ");
INSERT INTO tmd_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Makwam yöcmac panö ñɨŋa paŋyöbö i hölögɨpen. ");
INSERT INTO tmd_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Makwam nɨ cɨrɨp gö nɨgön mɨjöñ aku, kömö mɨdɨb mag aku pön, öim öim mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Makwam ami nöbö bla hön, Jerusalem bɨnöm abön wob yuö nɨg mɨjöñ wop aku, weik igöp mɨda Jerusalem rɨ gwogwam cöñɨŋö, rön, nugwöña. ");
INSERT INTO tmd_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nöbö mö mögörɨb Judia mɨjöñ bla, bör önöŋ ajmag bla duŋ. Nöbö mö Jerusalem mɨjöñ bla, bör röpɨn rɨŋadö diöña. Nöbö mö rɨŋadö adö mɨjöñ bla, Jerusalem kul yuadö duölɨŋ. ");
INSERT INTO tmd_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Aku agapɨm: wop aku mɨ, ñɨŋ God nugwo röböxöi aku, God mönö yadɨb nöbö bla magalɨg God Mönö kai kɨtön rɨg yadim mag akwör cöna nugwön ñɨŋ paiŋö ölɨŋ höb diba pöña. ");
INSERT INTO tmd_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Makwam wop aku, mö ha wöta mɨjöñ akuyöbö aipam, mö ha kiaia kau nölmɨjöñ akuyöbö aipam, ñɨŋ ölɨŋ höb diba pöña. God Juda nöbö mö ñɨgö ölɨŋ höb diba pɨ nöinö, rön, nöbö mö mögörɨb kɨ mɨdöi akuyöbö ñɨgö mɨ rɨ gwogwam cöna. ");
INSERT INTO tmd_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mögörɨb pad piakuyöbö nöbö hön, ñɨgö nöbö mö bli yu öböŋ mɨxɨl ölɨsö pön römal nɨgöña, nöbö mö bli ñɨgö nag nɨgön pön du mögörɨb hör piaku piaku magalɨg pön diöña. Juda nöbö mö yöi akuyöbö hön, Jerusalem rɨ gwogwam rɨŋ rɨŋ, God wop nuŋ yadöŋ aku wöxnö nɨgaŋ, röböxöña. ");
INSERT INTO tmd_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Makwam mai, naiö röun gupö ap bla mag höra wöxnö nɨgön, röbö diba wöd hön bu gɨgɨ diba rɨmɨjöna. Makwam mögörɨb il kɨ nöbö mö mögörɨb adadö piaku piaku magalɨg rɨb mɨga yöxön, pödpöd rɨmɨdö, rön, rɨb mɨxɨla yöxön ipöxmɨjöña. ");
INSERT INTO tmd_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ap adöx sö mɨd bla, i rɨ bɨröb yön bör yönmɨdaŋ, mögörɨb kɨ pödpöd rɨba rön rɨmɨdö, rön, ipöxön, rɨb maga hölögɨpaŋ haŋ wöröxbä maga cöna. ");
INSERT INTO tmd_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Almɨjön wop aku, Nöbö Ha nuŋwa mɨjöi yuö yör sö haŋ nugugɨrön, nöbö mö ñɨŋ ölɨsö mag nuŋwa aipam, mil wä keiryöbö mag nuŋwa aipam, nugwöña. ");
INSERT INTO tmd_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ap yadmɨdɨl kɨyöbö rɨmɨjön aku, Nöbö Diba anɨŋ kömö pɨb wop aku womiöx mɨdö, rön, mämäga laxiö adöx sö nugu gör mɨjne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jisas aliö rön, ñɨgö mönö höd röxön yadöŋa, “Bɨ hogulaŋa aipam, bɨ bli aipam, ");
INSERT INTO tmd_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","yösa nɨgmɨn, weik naiö nɨgɨba rɨmɨdö, rön, nugwöia. ");
INSERT INTO tmd_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Makwam mag aliö akuyöbö, ap yadɨl bla raŋ, God nöbö mö pön nugwidɨx mɨdɨb wop aku womiöx mɨdö, rön, nugwöña. ");
INSERT INTO tmd_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Nɨ ñɨgö mi yadmɨdla, nöbö mö wopik mɨdöi kɨyöbö magalɨg wöröxeñ; bli kömö mɨdɨŋ nugugɨrön, ap yadmɨdɨl pik magalɨg cöna. ");
INSERT INTO tmd_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Adöx sö mögörɨb mɨgrö kɨ pɨsaŋ hölögɨpöna, jɨ mönö mag nɨ bla hölögɨpen. ");
INSERT INTO tmd_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Makwam nugw ri aböña. Ñɨŋ röbö wain röbö ölɨsö mɨga nɨmön u pɨlön, ap mögörɨb mɨgrö kɨ ör rɨbyöx nugw mɨjöñ wop akwör, yöur hön urap döuyö meñ cɨxɨm, rɨmgör pɨmɨd mag akuyöbö cöna. ");
INSERT INTO tmd_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Pik ör renɨm; nöbö mö mögörɨb il jöjö yuöŋa mɨdöi akuyöbö magalɨg cöna. ");
INSERT INTO tmd_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Makwam, ñɨŋ öim öim nugw ri abön, God höjöpal gör mɨdön yajöña, ‘Ap piaku anɨŋ pɨl pal nɨgölaŋ; nagö anɨŋ nugwidɨx mɨdaŋ kömö duön, du Nöbö Ha nuŋwa mämäg il rol nuŋwa mɨjnɨŋö,’ cɨne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Wop ulmɨdö mɨd aku, Jisas öim du God höjöpalɨb rama ram möl yuadö du mɨdön, nöbö mö bla ñɨgö mönö yad nölmɨdöŋa. Makwam pɨxmag gurɨm nugugɨrön, Jisas nuŋ du mögörɨb i Olip Pɨd me röi yöraku hölɨmmɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nöbö mö akuyöbö magalɨg, mönö nugwo aku nuguŋö, rön, pɨxmag alɨg öbɨlön, God höjöpalɨb rama dumɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Juda ada Bred Is Alɨg Nɨmölɨb wop dib ñɨŋ aku, Pasopa me röi wop dib ñɨŋ aku, igöp igöp röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","God ap höjöpal ur nölɨb nöbö dib bla aipam, lo mönö yad nölɨb nöbö bla aipam, Jisas nugwo pɨl pal nɨgnɨŋö, rim aku, jɨ ñɨŋ nöbö mö akuyöbö ipöxön, agö magɨm rön Jisas pɨl pal nɨgnɨŋö, rön, yad nugw mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Yad nugw mɨdɨm nugugɨrön, Seten nuŋ hön, Judas ib nuŋ i Iskariot rɨmɨdim nöbö aku yuö wölöŋa. Nöbö aku Jisas nöbö nuŋ mɨgan sö adö nöbö i. ");
INSERT INTO tmd_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yuö wölmɨn, nuŋ du God ap höjöpal ur nölɨb nöbö dib bla aipam, God höjöpalɨb rama nugwidɨx mɨdmɨdöi ömdö nöbö dib ñɨŋ bla aipam mɨdim yöra duön, Jisas nugwo agö magɨm rön höuöu rɨ pön du nölmön nugwo pɨl pal nɨgɨŋ, me rön, mönö aku ñɨgö pɨsaŋ yad nugwöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Aliö rɨmɨn, ñɨgö wä rɨmɨn nugugɨrön yadmä, “Nagö rɨg nölɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Aliö rɨmɨn, Judas nuŋ, wop kaiyöbö Jisas nöbö mö bla pɨsaŋ mɨden aku, nugwo höuöu rɨ pön du nöbö dib akuyöbö ñɨgö nöinö, rön, pöx nugu mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Makwam Bred Is Alɨg Nɨmölɨb wop aku höm, Pasopa hön sipsip ha pal höjöpalɨb wopa kɨ, me rön, ");
INSERT INTO tmd_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jisas nuŋ Pita Jon nöbö hogwa yad abön yadöŋa, “Ñɨŋ nöbö hogwa du Pasopa ap nɨmɨnɨŋ aku rɨ nɨg pɨdɨlu ri abne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Jisas aliö rɨmɨn, yadmä, “Pikai akuyöbö ainɨŋ owa?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Aliö rɨmɨn, Jisas yadöŋa, “Ñɨŋ nöbö hogwa taun dib aku duön nugwöña, nöbö i röbö un pön hömɨjöna. Nugwo möigw pölön, diön ram aku duön, ");
INSERT INTO tmd_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","nöbö ram mɨnöbö aku nugwo yajöña, ‘Mönö Yad Nölɨb Nöbö nagö yad nugwa, “Ram möl yuadö möl kai nöbö nɨ bla pɨsaŋ Pasopa ap nɨmɨnɨŋ owa?” rö,’ cöña. ");
INSERT INTO tmd_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Aliö rɨmɨdɨŋ, ñɨgö nöbö hogwa pön wölu ram möl dib bli yöbö äbäñ ap bla alɨg mɨjön ram möla yadaŋ, Pasopa ap nɨmɨnɨŋ piaku yuadö möl aku rɨ pɨdɨliöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jisas aliö rɨmɨn, duön nugumɨn, rɨg yadöŋ yadöŋ mag akwör rɨg mɨdöŋa. Makwam, Pasopa ap nɨmɨba rim piaku rɨ nɨg pɨdɨlu ri abmä. ");
INSERT INTO tmd_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Makwam ruö höxi guröŋ mag aku ap nɨmɨba rön, mönö wä pön dub nöbö nuŋ bla pɨsaŋ äbäñ rol aku römɨd gwogwäbö rön, ");
INSERT INTO tmd_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jisas ñɨgö yadöŋa, “Mɨdö ölɨŋ höb diba pɨna, jɨ rɨb ölɨsö na yöx nugul aku, höd ñɨŋ pɨsaŋ Pasopa ap nɨmɨba rɨmɨdöl kɨ nɨmnɨŋö, rön, rɨb aku yöx nugula. ");
INSERT INTO tmd_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Makwam nɨ ñɨgö yadmɨdla, Pasopa ap aku mai iswob nɨmöin; mai Pasopa hön sipsip ha öim pal nɨmöl il aku wöxnö nɨgaŋ nugwön God nöbö mö nuŋwa pön nugwidɨx mɨdɨb wop akwör ap diba nɨmnɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jisas aliö rön, röbö wain namaga pön, God nugwo ri ablaŋe, rön, nöbö nuŋ akuyöbö ñɨgö nöl gɨrön yadöŋa, “Röbö nölmɨdɨl kɨ ñɨŋ keir pɨ nuöm nɨgön nɨmi. ");
INSERT INTO tmd_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Makwam ñɨgö yadmɨdla, weik wop kɨ ila nɨgön, röbö waina iswob nɨmöin; God nöbö mö nuŋwa pön nugwidɨx mɨdɨb wop akwör röbö waina iswob nɨmnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jisas aliö rön, bred i pön, God nugwo ri ablaŋe, rön, pɨ gɨlɨxön ñɨgö nöl gɨrön yadöŋa, “Mɨxɨñ nɨ kɨ ñɨgö nölmɨdla. Mai ñɨŋ kwo paŋ mag akwör rön, nɨ rɨbyöx nugu gör mɨjɨnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ñɨŋ ap nɨm pörön, Jisas röbö wain namag aku pön, ñɨgö nöl gɨrön yadöŋa, “Hañ na pɨnaŋ wöröxmön mönö, God ñɨgö nöbö mö nɨ, me rön, pɨnö röŋ mönö adaku aŋadö du gö nɨgaŋ, me rön, nɨ ñɨgö röbö wain kɨ nölmɨdla. ");
INSERT INTO tmd_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Makwam nöbö nɨ wöñö u rɨ pön diön nöbö aku an pɨsaŋ römɨd gɨ mɨdöla. ");
INSERT INTO tmd_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nöbö Ha nuŋwa, God maduar ör yadöŋ ödöi adakwör mai duön wöröxön aku, jɨ nöbö nugwo wöñö u rɨ pön diön nöbö aku nugwo ögwö yöxmɨdlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jisas aliö rɨmɨn, nöbö nuŋ bla ñɨŋ keir ör, yön akuyöbö aiönɨŋö, rön, nuö nuö yad nugu gɨrön mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jisas nöbö nuŋ akuyöbö, ñɨŋ yöi, nör nöbö diba mɨdlö, rön, ñɨŋ keir ör nuö nuö yadmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Aliö rɨmɨdmɨn, Jisas ñɨgö yadöŋa, “Kiŋ piaku Juda nöbö mö yöi piaku usus rön nugwidɨx mɨd gɨrön yadöia, ‘Ñɨgö pɨ ösös rɨ ri abön rölɨŋö,’ röia. ");
INSERT INTO tmd_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Jɨ ñɨŋ mag akuyöbö almɨjeñ. Nöbö mö dib ñɨŋ piaku, hör nöbö mö röxg mɨdɨŋ; nöbö mö dib ödöriö piaku, mabö rɨ nölɨb nöbö mö röxg mɨdɨŋ. ");
INSERT INTO tmd_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mögörɨb il kɨ röi mag adaku, nöbö mö diba du römɨdɨm, mabö rɨ nölɨb nöbö mö bla ap mag ap ñɨŋ bla womiöxön röia. Jɨ nɨ mibɨl ñɨgö mabö rɨ nölɨb nöbö i röxg mɨdla. ");
INSERT INTO tmd_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Nɨ ömörö pɨmɨdɨl aku, ñɨŋ nugwön nɨ röböxölöi; nɨ nugwidɨx mɨdöia. ");
INSERT INTO tmd_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Aliö alöi aku, God nɨ yada, ‘Nagö Kiŋ mɨdön, nöbö mö piaku nugwidɨx mɨdane,’ rɨ aku, nɨ piöŋö algör ñɨgö yadmɨdla, ñɨŋ kiŋ röxg mɨdön nöbö mö piaku nugwidɨx mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Wop aku ñɨŋ mögörɨb na aku duön, nɨ pɨsaŋ römɨd gɨ mɨdön ap mag nɨmön röbö nɨmön rɨmɨjöña; ñɨŋ kiŋ römɨdöi hogw rol aku römɨd gɨ mɨdön, Isrel ila hörɨrör akuyöbö möl sö piaku mönö diba nugwöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jisas nuŋ Pita nugwo yadöŋa, “Saimon, Saimon, nugwö. God nuŋ Seten yöwö raŋ, ñɨgö nöbö, wit maga ab gɨr rɨm, maga keir pɨnɨm, uñ yöj bla keir pɨnɨm mag akuyöbö rön, ñɨŋ rɨ gwogwam cöñɨŋönö wöhö rɨ nugwönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Makwam nɨ God höjöpalön rɨl aku, nɨ aŋadö röböxöinö. Makwam ap kib mag gwogwo rɨmɨjɨnö aku, pödpöd rɨmɨn aliö ailö, rön, nɨ iswob höbkal hönö. Makwam akuyöbö alön, mai hön haul nöbö mölöu nöbö naŋ bli ñɨgö mönö yad nöl ri abaŋ, ñɨŋ usus rön nɨ mai rɨŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Jisas aliö rɨmɨn, Pita yadöŋa, “Nöbö Dib, nɨ nagö röböxöin. Mösör yönmɨjnɨŋa; nagö nag nɨgön, nɨ aipam nag nɨgöña; nagö pɨl pal nɨgön, nɨ aipam pɨl pal nɨgöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Aliö rɨmɨn, Jisas yadöŋa, “Pita, nɨ nagö yadmɨdla, weik pɨxmag yuö bö kulakula wö ren mag aku, Jisas nugwo nugumɨdöiö, rön, wop mös paŋ wai nöinaŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jisas aliö rön ñɨgö yadöŋa, “Höd ñɨgö yad abön yadma, ‘Rɨg uñ, yogw, yam uñ bla pön pɨrag dumɨjeñ; hör dine,’ rɨma. Yadmön duim wop aku, ap ñɨŋ bli mɨdöŋ mönö mɨdölöŋ?” röŋa. Jisas aliö rɨmɨn yadmä, “Ehöu, ap i an met wölöŋ; mɨdöŋ akwör,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Aliö rɨmɨn, Jisas yadöŋa, “Makwam weik ñɨŋ rɨg uñ yogw mɨjön aku, alɨg pɨrag diöña. Nöbö kai yu mɨxɨl ölɨsö mɨden aku, ij ap uñ nuŋ aku nöbö bli sɨm rön rɨg pön yu mɨxɨl ölɨsö i woböna. ");
INSERT INTO tmd_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Makwam nugwi! Höd God mönö yadɨb nöbö Aisaia God Mönö rɨb mɨŋi kai kɨtön yadöŋa, ‘ “Nuŋ nöbö ap kib mag gwogwo rɨb nöbö i,” me cöñɨŋö,’ röŋa. Yadöŋ aku nör yadöŋa. Mönö yadön kai kɨtöŋ aku weik rɨba rɨmɨdö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Jisas aliö rɨmɨn, ñɨŋ yadmä, “Nöbö Dib, yu mɨxɨl ölɨsö an mös mɨdö,” rɨmä. Aliö rɨmɨn, Jisas yadöŋa, “Aku nugwön aliö yadmɨjeñɨŋe,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jisas aliö yad gɨrön Jerusalem rɨŋadö duön, öim Nuö höjöpalmɨd Olip Pɨd yöra duöŋa; nöbö nuŋ bla mai dumä. ");
INSERT INTO tmd_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Mögörɨb aku uröpɨnön ñɨgö yadöŋa, “Rɨb gwogwo haŋ rɨ gwogwam rɨbä maga ra aku, God höjöpal gɨr mɨjɨnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jisas aliö rön, ñɨgö röböxön, nuŋ hör hör yöraku duön, höxmax yuön nuö God höjöpalön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Acö, rɨb nɨ yöx nugul aku röbö acɨx namaga nɨ nölɨba rɨmɨdlö aku nölmɨjɨnö. Jɨ nɨ rɨbyöx nugul adaku rɨmɨjɨnö; rɨb naŋ keir yöx nugulö adakwör rane,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Jisas aliö rɨmɨn, ejol i adöx yöd röul adö kau sebö hön nugwo ölɨsö nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jɨ Jisas nuŋ mɨ ömörö diba pön, Nuö nugwo mɨ ususör rön höjöpal gör mɨdmɨn nugugɨrön, bɨlö aku haña ödör mɨgrö bö pɨnöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nuŋ Nuö höjöpal mɨd pörön duön nugwöŋa, nöbö nuŋ bla ñɨŋ Jisas nugwo mɨ göj uliöxmɨn, ölɨsö mag i mɨdölöŋ, inɨmö hölɨmmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Almɨdmä aku nugwön, Jisas ñɨgö yadöŋa, “Pödpöd rɨmɨn inɨmö hölɨmmɨdöi? Seten nuŋ rɨba nölaŋ ñɨŋ rɨ gwogwam rɨb maga rɨ aku, öbɨlön, höjöpal gör mɨjne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisas mönö aku yadmɨdɨm nugugɨrön, nöbö nuŋ Judas nöbö rogw dib i yölɨŋ pön höröpɨnön, Jisas nugwo alguna bɨmɨl nɨmɨba rɨmɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Almɨdmɨn, Jisas nugwo yadöŋa, “Judas, ‘Nöbö mɨk mɨ göm pɨl pal nɨgɨŋ,’ me rön, nɨ Nöbö Ha nuŋwa pɨ alguna bɨmɨl nɨmɨba rɨmɨdlö ä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jisas aliö rɨmɨn nugugɨrön, nöbö nuŋ bla ap kai rɨba rɨmɨdim aku nugwön yadmä, “Nöbö Dib, an ñɨŋ yu mɨxɨl ölɨsö pɨ römainɨŋönö owa?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Aliö yad gɨrön, nöbö i yu mɨxɨl ölɨsö nuŋ aku pön, God ap höjöpal ur nölɨb nöbö dib ödöriö mabö rɨ nölɨb nöbö nuŋ aku, nugwo rɨmɨj mɨrɨx adö aŋadö römal cö gɨ aböŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Almɨn, Jisas nugwön yadöŋa, “Akuyöbö almɨjeñ!” röŋa. Aliö rön, rɨmɨj aku pɨ nugumɨn rɨgɨba röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Makwam God ap höjöpal ur nölɨb nöbö dib bla aipam, God höjöpalɨb rama nugwidɨx mɨdmɨdöi ömdö nöbö dib ñɨŋ bla aipam, mönö pɨ nuöm nɨgɨb nöbö bla aipam, du nugwo pɨba rɨmɨdim nöbö akuyöbö ñɨgö yadöŋa, “Ñɨŋ yu mɨxɨl ölɨsö pön, palɨb kaiö pön rag höi aku, nɨ paiŋö pɨlɨb nöbö i, me rön rɨbyöx nugwön, pɨ cɨcɨ nɨgɨba höiŋ ä? ");
INSERT INTO tmd_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nɨ ñɨŋ pɨsaŋ öim öim God höjöpalɨb ram aku mɨdmön nɨ pölim. Makwaim weik Seten, nöbö pɨxmag adö mɨd aku, wop nuŋ aku mɨ, aliö almɨdöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jisas aliö rɨmɨn nugugɨrön, nugwo pɨ cɨcɨ nɨgön, pön du God ap höjöpal ur nölɨb nöbö dib ödöriö aku rama pön dumä. Pita piöŋö mai mai nugup duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ram aku höröpɨnmɨn, ram möla yuö kwo bɨ urön römɨd gɨ mɨdmä. Pita mai hö gɨrön ñɨgö pɨsaŋ römɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pita pɨsaŋ römɨd gɨ mɨdɨm nugugɨrön, ram aku mabö rɨ nölmɨd halöu i nugwo nugup wölu nugup pɨn duön yadöŋa, “Nöbö kɨ aipam Jisas pɨsaŋ mɨdmɨdö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Aliö rɨmɨn, Pita yadöŋa, “Halöu mɨg, nöbö aku nɨ nugumɨdöiö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Pita aliö rön, hör ulmɨdö mag i mɨdmɨn nugugɨrön, nöbö i piöŋö hön, Pita nugwo nugwön yadöŋa, “Nagö algör ör Jisas nöbö nuŋwa i,” me röŋa. Aliö rɨmɨn, Pita yadöŋa, “Nöbö mɨg, nɨ yöi!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Makwam mai aua paŋyöbö mag mɨŋi mɨdmɨn, nöbö i piöŋö hön, mɨ usus rön yadöŋa, “Nöbö kɨ Jisas pɨsaŋ mɨdmɨd pal. Nuŋ aipam mögörɨb Galili yöbö,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Aliö rɨmɨn, Pita yadöŋa, “Nöbö mɨg, mönö yadmɨdlö aku nɨ nugwöi pal!” röŋa. Pita aliö rɨmɨn nugugɨrön, rɨb pia kulakula wö röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Almɨn, Jisas höuöiliö, Pita nugwo riö nugwöŋa. Almɨn, Pita nuŋ Jisas, “Weik pɨxmag yuö bö kulakula wö rölbör mɨjön mag aku, Jisas nugwo nugumɨdöiö, rön, wop mös paŋ wai nöinaŋö,” röŋ mönö aku rɨbyöx nugwöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Aliö nugumɨn, iröpa ub rɨm, malul rɨm höm, rɨŋadö duön imöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nöbö Jisas nugwo pɨ gɨ mɨdim bla nugwo yad höimöu gɨrön, pal gɨrön rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ñɨŋ ap uñ mei pɨ mämäg nugwo aku pölu rɨ nölön, nugwo palön yadmä, “Nagö nöbö keir nugulö aku, yönɨmɨm nagö palmɨd aku anɨŋ yad nölö!” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Makwam mönö gwogwo akuyöbö, bli mɨga uplöb nugwo yadmä. ");
INSERT INTO tmd_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pɨxmag alɨg, Juda mönö pɨ nuöm nɨgɨb nöbö bla nɨgön, God ap höjöpal ur nölɨb nöbö dib bla nɨgön, lo mönö yad nölɨb nöbö bla nɨgön, hö mögum rɨm, Jisas nugwo yölɨŋön Kansol diba mɨdim mibɨl yöraku pön hömä. ");
INSERT INTO tmd_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Kansol nöbö bla ñɨŋ Jisas nugwo yadmä, “Naŋ keir yajɨnö, naŋ Mesaia aku mönö wöhö,” rɨmä. Aliö rɨmɨn, Jisas ñɨgö yadöŋa, “Nɨ ñɨgö mönö aliö yajɨn aku, mi yadö, rön, nugw peñ. ");
INSERT INTO tmd_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Makwam yad nugub nɨ mɨd aku ñɨgö yad nugumɨjɨn aku, paiŋö yadeñɨm. ");
INSERT INTO tmd_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Makwam weik nɨgön mɨdɨp duön mai piaku, Nöbö Ha nuŋwa God Nöbö ölɨsö mag keiryöbö alɨg mɨd aku, imag mɨrɨx adö nuŋwa römɨd gɨ mɨjönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jisas aliö rɨmɨn, nöbö kansol bla magalɨg nugwo yadmä, “Makwam, naŋ keir God Ha nuŋ aku mönö?” rɨmä. Aliö rɨmɨn, Jisas yadöŋa, “Mɨ ñɨŋ keir yadmɨdöi maku pal,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Jisas aliö rɨmɨn, yadmä, “Pödpöd raŋ mönö diba uplöb nɨgɨp duön, nöbö bli yad nugwɨŋ, Jisas aliö ra aliö ra cöñ? Ajmöl nuŋwa keir yadmɨn nugwöl maku,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Aliö rön, magalɨg öbɨlön, Jisas nugwo pön gapman nöbö dib Pailot mɨdöŋ yöra dumä. ");
INSERT INTO tmd_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pön duön, nugwo mönö diba yadɨba, mönö hör piaku piaku mɨga pön hön yadmä, “An hölu nugwön nugwöla, nöbö kɨ nöbö mö an bla inakmönö hörön yadön yada, ‘Nöbö dib Sisa nugwo takis nölmɨjeñ, gapman ada mönö aku algör ör nugumɨjeñɨŋö,’ ra. Makwam mönö i yada, ‘Nɨ keir Mesaia pal, nɨ keir kiŋ aku,’ me rö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Aliö rɨmɨdmɨn, Pailot Jisas nugwo yad nugwön yadöŋa, “Naŋ Juda ada kiŋ ñɨŋ mä?” röŋa. Aliö rɨmɨn, Jisas yadöŋa, “Mɨ naŋ keir yadlö maku pal,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Jisas aliö rɨmɨn, Pailot nuŋ God ap höjöpal ur nölɨb nöbö dib bla aipam, nöbö mö hör hö mɨdim bla aipam yadöŋa, “Nɨ nugula, nöbö kɨ nugwo mönö diba yadɨb il i mɨdölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Aliö yadöŋ aku, jɨ ñɨŋ mönö ölɨsö yadön yadmä, “Gapman mönö nugwölɨŋ, me rön, mönö yad nölɨp yönön, mögörɨb an Judia nöbö mö bla magalɨg yad nöl yönmɨda. Mögörɨb Galili ila nɨgön, yad nöl yönmɨd yönmɨd weik Jerusalem yörɨk hö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Aliö rɨmɨdmɨn, Pailot ñɨgö yad nugwön yadöŋa, “Nöbö kɨ nöbö Galili yöbö mä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Aliö rɨmɨn, yöwö rɨmä. Makwam kiŋ Herod mögörɨb Galili nugwidɨx mɨdmɨd aku, wop mibɨl aku hön Jerusalem mɨdmɨda. Makwam, Jisas nuŋ Galili yöbö nöbö me rɨmä aku nugwön, Jisas nugwo Herod imag rola abmön mönö dib kɨ nugwaŋ, me rön, Pailot ñɨgö yadɨm, Jisas nugwo pön Herod mɨdöŋ yöra pön dumä. ");
INSERT INTO tmd_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod, Jisas ap agap apɨm rɨg rɨmɨd aku öim mönö akwör nugwön, wop kaiyöbö ap rölɨbä akuyöbö i raŋ nugunö, rön, rɨba paŋ akwör yöx nugu gör mɨdmɨd aku, wop aku Jisas nugwo yölɨŋ pön hömɨn, nuŋ mɨ ödöriö wahax pöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Makwam Herod nuŋ Jisas nugwo mönö mɨga akwör yad yöluöl rɨ nugwöŋa, jɨ Jisas mönö i paiŋö yadölöŋ. ");
INSERT INTO tmd_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Makwam God ap höjöpal ur nölɨb nöbö dib akuyöbö aipam, lo mönö yad nölɨb nöbö bla aipam, usus rön, nöbö mɨga akwör mönö akwo akwo yadmä. ");
INSERT INTO tmd_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herod aipam, ami nöbö nuŋ bla aipam, Jisas nugwo rɨ gwogwam rɨ gɨrön, ñɨlöŋ nɨg gɨrön, gapman nöbö dib röböi wölɨj wä i röb nölön, höbkal Pailot mɨdöŋa abmä. ");
INSERT INTO tmd_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Höd Herod Pailot yöŋö kwolmal mɨdmɨdöia, jɨ wop aku mönö nugwön pɨ nɨgiö nɨgmä. ");
INSERT INTO tmd_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Makwam Pailot, God ap höjöpal ur nölɨb nöbö dib bla aipam, mönö pɨ nuöm nɨgɨb nöbö dib bla aipam, nöbö mö hör bla aipam yadɨm hö mögum rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ñɨŋ hö mögum rɨmɨdɨm, Pailot nuŋ ñɨgö yadöŋa, “‘Nöbö kɨ mönö um röx yadön, nöbö mö akuyöbö ñɨgö al aliö yadö,’ röi aku, jɨ weik mämäg il rol ñɨgö kɨ mönö nugula aku, nuŋ mag gwogwo rɨb mönö il i nugwöi. ");
INSERT INTO tmd_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod algör ör mönö il i hölu nugwöl makwam, höbkal anɨŋ keir nöla. Nɨ nugula, mag gwogwo i röl; nugwo pɨl pal nɨgɨb maga mɨdöl. ");
INSERT INTO tmd_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Makwam, ami nöbö nɨ bla yadmön, nugwo hör palön, yad abɨŋ duaŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Makwam Juda ada wop dib ñɨŋa Pasopa aku höm, Pailot öim kɨm paŋ paŋ kɨlabɨs nöbö ñɨŋa paŋyöbö i hör yad abmɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Wop aku ñɨŋ magalɨg bölölö rön mönö ölɨsö yadön yadmä, “Nöbö aku pɨl pal nɨgö! Barabas anɨŋa yad abaŋ haŋ!” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Nöbö Barabas aku nuŋ taun dib aku nöbö mö bli pön, mögörɨb aku nugwidɨx mɨdmɨd nöbö diba pɨsaŋ nuö nuö rön, nöbäpö i aŋadö pɨl pal nɨgöŋ aku, nugwo mönö diba yadön nag nɨgmä. ");
INSERT INTO tmd_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Makwam Pailot Jisas hör yad abmön duaŋ me rɨ nugwön, ñɨgö iswob yadön aliö yadöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Aliö rɨmɨdmɨn, ñɨŋ iswob mɨ bölölö diba rön mönö ölɨsö yadön yadmä, “Nugwo bɨ katlö watlö um sö pɨl pal nɨgö! Nugwo bɨ katlö watlö um sö pɨl pal nɨgö!” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Aliö rɨmɨdmɨn, Pailot ñɨgö iswob yadön yadöŋa, “Nöbö kɨ ap kai rɨ gwogwam rɨ? Nɨ nugula, ap gwogwo i röl aku, nugwo pɨl pal nɨgɨb maga mɨdöl. Makwam, ami nöbö na yadmön, nugwo hör palön, yad abɨŋ duaŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pailot aliö rɨmɨn, ñɨŋ ususör rön, Jisas nugwo bɨ katlö watlö um sö pɨl pal nɨgɨŋ wöröxaŋ, me rön, ñɨŋ iswob mɨ bölölö diba rön mönö ölɨsö yadön, rɨm rɨm, ");
INSERT INTO tmd_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pailot mönö ñɨgö aku pön, ");
INSERT INTO tmd_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","nöbö i, nöbö mö bli pön mögörɨb nugwidɨx mɨdmɨd nöbö dib aku pɨsaŋ nuö nuö pön, nöbäpö i aŋadö pɨl pal nɨgöŋ nöbö aku nugwo yad abmɨn kömö duöŋa; jɨ ami nöbö nuŋ bla ñɨgö yadöŋa, “Ñɨŋ Jisas agapɨm cɨnöb cɨnɨŋö rön yadmɨdöi mag akwör cɨne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jisas nugwo pɨl pal nɨgɨba pön dumä. Mibɨl yöra u gɨrön, Sairini taun yöbö nöbö i Jerusalem hömɨdöŋa. Nöbö aku ib nuŋwa Saimon. Nugwo möigw palön, pɨ cɨcɨ nɨgön, bɨ katlö watlö waba pɨrag nölön yadmä, “Jisas dumɨd makwam mai duö,” rɨmɨn, pɨragön mai duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jisas nugwo pön dumɨn nugugɨrön, nöbö mö mɨg mɨŋa mai dumä. Nöbö mö dumɨdim mibɨl aku mö bli Jisas nugwo lɨb pɨlɨm nugwön im gɨrön dumɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Akuyöbö almɨn, Jisas höuöiliö nugwön ñɨgö yadöŋa, “Ñɨŋ Jerusalem mö, nɨ rɨba rɨmɨd mag kɨ nugwön immɨjeñ. Ñɨgö rɨ gwogwam rön, halöu ha ñɨŋ bla rɨ gwogwam rön rɨmɨjöñ aku imöña. ");
INSERT INTO tmd_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mai ömörö diba haŋ, yajöña, ‘Mö ha yöx pön hölöi piaku aipam, mö ha kau nölölöi piaku aipam, ñɨŋör wahax pɨŋ,’ me cöña. ");
INSERT INTO tmd_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Wop aku, mɨ aŋadö wöröxŋö, rön, yajöña ‘Önöŋ ajmag bla gɨlɨx hön, anɨŋ pal nɨgönɨŋönö mɨgɨñ pɨnön anɨŋ mögö nölön aku wä cönɨŋö,’ cöña. ");
INSERT INTO tmd_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nɨ bɨ kömö röxg mɨdla, jɨ nɨ akuyöbö alön rɨ gwogwam rɨmɨdöia. Makwam ñɨŋ bɨ wöröxɨb röxg mɨdöi aku, ñɨgö mɨ ödöriö mɨ rɨ gwogwam cöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Makwam nöbö gapman lo mönö röd abim nöbö hogwa aipam, bɨ katlö watlö um sö pɨl pal nɨgɨba pön dumä. ");
INSERT INTO tmd_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pön mögörɨb Nöbäpö Yöcmac Yöj Lei me röi yöra uröpɨnön, Jisas nugwo pön du bɨ katlö watlö um sö cɨpɨl palön, nöbö gapman lo röd abɨm nöbö hogwa pön du bɨ katlö watlö um sö adöi adöi cɨpɨl palmä. ");
INSERT INTO tmd_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Akuyöbö almɨn, Jisas yadöŋa, “Acö, nɨ rɨmɨdöi aku, pödpöd rɨmɨn almɨdölɨŋö, rön, nugw ri abön rɨmɨdölöi. Makwam, ñɨŋ rɨ gwogwam rɨmɨdöi mag ñɨŋ aku nugwön röböxö,” röŋa. Makwam ami nöbö bla, Jisas wölɨj nuŋwa pɨ röd nɨgɨm mɨdöŋ piaku, ñɨŋ keir höbai sadu rɨg woböi mag akuyöbö rön pɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nöbö mö mɨg mɨŋa nugugu mɨdɨm nugugɨrön, Juda nöbö dib bla Jisas nugwo päja yadön yadmä, “Nuŋ, ‘Nɨ Mesaia aku; God nɨ yad nɨgön agal abɨm hölö,’ rön, nöbö mö bli wöröxöia rɨmɨdmɨn öbɨlöia. Al mag akuyöbö, nuŋ keir algör ör aliö alön kömö duaŋ nuguŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ami nöbö bla algör ör, Jisas mɨdöŋ il yöra hön nugwo päja yadön, röbö wain acɨxa nölön yadmä, ");
INSERT INTO tmd_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Nagö, ‘Juda Kiŋ ñɨŋa mɨdlö,’ rɨlö aku, naŋ keir rön kömö duö!” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Makwam Jisas nugwo cɨpɨl pal nɨgim bɨ katlö watlö höñ yöraku pisö, bäpö mei yöj yöra mönö kai kɨtmä: ");
INSERT INTO tmd_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nöbö gapman lo mönö röd abɨm, bɨ katlö watlö um sö pɨl pal nɨgim hogwa, nöbö i Jisas nugwo yad höimöuön yadöŋa, “Nagö Mesaia mɨdlö aku, naŋ keir rön kömö duön, an nöbö hogwa algör ör raŋ, kömö duŋö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Aliö rɨmɨn, nöbö i piöŋö nugwo yadyöxön yadöŋa, “Nöbö kɨ ölɨŋ höb diba pön wöröxɨba rɨmɨda; an nöbö hogwa algör ör ölɨŋ höb diba pön wöröxɨba rɨmɨdöl aku, me rön, God ipöxöiö ä? ");
INSERT INTO tmd_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","An nöbö hogwa rɨ gwogwam röl aku ölɨŋ höb pɨmɨdöla, jɨ nöbö kɨ mag gwogwo i röl,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nuŋ aliö rön Jisas yadöŋa, “Nagö mögörɨb naŋa duön kiŋ mɨdön, nɨ rɨbyöx nugugu mɨdö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Aliö rɨmɨn, Jisas nuŋ paiŋö yadöŋa, “Nɨ nagö mɨ ödöriö yadmɨdla, weik wop kɨ ör nagö nɨ pɨsaŋ du mögörɨb wä aku mɨjnɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Mag aku, naiö mibɨl yörkisö mag aku pɨxmag gurön, mɨdɨp duön naiö yör bö pik röŋ mag aku iswob mil pöröŋa. ");
INSERT INTO tmd_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","46","Jisas wöröxɨba rön yadöŋa, “Acö, inöm na imag rol nagö nɨgmɨdlö,” röŋa. Jisas aliö rön wöröxöŋa. Jisas wöröxöŋ wop akwör, God höjöpalɨb rama ram möl yuebö kwo, ñapñap uña pɨ ubalɨja idɨx gim aku, mibɨla waglöxɨm, kɨrɨrɨ rɨ adöi adöi dumɨn, uba röd gɨ mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Makwam ami nöbö nugwidɨx mɨdɨb nöbö dib aku, rɨg rɨmɨdöŋ aku nugwön, God iba mag wöl gɨrön yadöŋa, “Mɨ ödöriö! Nöbö kɨ nöbö wä mɨdö!” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nöbö mö hö nugugu mɨdim bla, ap röŋ aku nugwön, malul rɨm höm pɨbɨl pal gɨrön, höuöilön ram ñɨŋa dumä. ");
INSERT INTO tmd_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Makwam Jisas nöbö mö nugub nuŋ bla aipam, Galili yöbö nugwo pɨsaŋ hem mö bla aipam, ñɨŋ keir hör hör yörkwo mɨdön, ap rɨg röŋ aku nugugu mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Makwam Juda Kansol diba nöbö i, ib nuŋwa Josep. Nuŋ nöbö wä, mönö pɨ nuöm nɨg rɨ ri abmɨdöŋa. Nuŋ Arimatia taun, mögörɨb Judia yuadö yöraku yöbö. Juda Kansol nöbö bli, Jisas nugwo pɨl pal nɨgnɨŋö, rön, rɨbyöx nugwim akuyöbö, Josep nuŋ rɨb aliö yöx nugwölöŋ. Nuŋ, God nöbö mö pön nugwidɨx mɨdɨb wop aku hönɨŋö, rön, pöx mɨdmɨda. ");
INSERT INTO tmd_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nuŋ Jisas wöröxöŋ, nöbäpö högia pön du hogw pɨlɨba rön, Pailot mɨdöŋ yöra duön, yad nugum yöwö röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Makwam, Josep nuŋ du nöbäpö högia pɨ öröu pɨrag pɨnön, ñapñap uñ lei gudogudö wä i pɨ wobön, pön du rɨg möl yöudöŋ yölu nɨgön nöbäpö hogw pɨlölim möla hogw pɨlöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Makwam Juda God höjöpalɨb wop aku igöp hö, rön, wop Praide pɨgö pɨgö mɨdöŋ mag aku nöbäpö hogw pɨlöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Makwam mö rogw, Jisas pɨsaŋ Galili yöbö hömä akuyöbö, Josep dumɨn nugugɨrön mai duön nöbäpö hogw möla uröpɨnön, nöbäpö högia rɨg hogw pɨlöŋ aku nugw ri abön, höuöil ram ñɨŋa dumä. ");
INSERT INTO tmd_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ram ñɨŋa duön, agunɨŋ röbö hölɨŋ wä höb bli nöbäpö högia nɨg nölɨba rön, rɨ nɨg ri abmä. Löum yöbö wop aku pön hömɨx aku, jɨ Sarere wop dib ñɨŋa hör mɨdɨb wop aku nugwön mönö, hör mɨd mɨd hölɨmɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Löum yöbö wop agñeb Sade aku, ruö yöudöŋdöŋ löuöŋ mag aku, mö rogw aku agunɨŋ röbö hölɨŋ wä höb aku pön, nöbäpö högia mɨxɨña ap nɨn kapa pugul nöinɨŋö, rön, pön du nöbäpö hogw pɨlim yöra dumä. ");
INSERT INTO tmd_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Duön nugumɨn, rɨg aso dib nöbäpö hogw möla idɨx gɨmä aku, kɨrɨrɨ rɨ du gägäp adö mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Makwam ñɨŋ möla duön nugumɨn, Nöbö Dib Jisas högia mɨdölöŋ. ");
INSERT INTO tmd_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Pöd rɨ, rön, audiöx nugumɨn, rɨb pia nöbö hogwa il yöra öbɨl gɨ mɨdmä. Nöbö hogwa wölɨj ñɨŋa lei mil mag keiryöbö alɨg mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Mö piaku ñɨŋ nugumɨn, ölölö rɨmɨn ipöxön, höxmax yuön ubɨlmɨn nugugɨrön, nöbö rama yadmä, “Pödpöd rɨmɨn nöbö kömö mɨd aku nugwo nöbäpö hogw pɨlöi mibɨl kɨyöbö hölu nugup yönmɨdöi? ");
INSERT INTO tmd_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nuŋ yörɨk mɨdöl; maduö öbɨla. Makwam ñɨgö pɨsaŋ Galili mɨdön mönö yadöŋ aku rɨbyöx nugwi. ");
INSERT INTO tmd_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Jisas nuŋ ñɨgö yadöŋa, ‘Nöbö Ha nuŋ aku nugwo, pɨ nöbö mö ap kib mag gwogwo röi imag rol ñɨŋa nɨg gɨŋ, nugwo bɨ katlö watlö um sö pɨl pal nɨg gɨŋ, wöröxön wop mös mɨdön, löuaŋ wop paŋ aku höbkal öbiönɨŋö,’ rö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Aliö rɨmɨn nugugɨrön, rɨb mag ñɨŋa rɨbyöx nölmɨn, Jisas höd Galili mɨdön mönö yadöŋ aku rɨbyöx nugup du nugumä. ");
INSERT INTO tmd_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Mö piaku ñɨŋ nöbäpö hogwaja aku röböxön, höbkal duön, ap rɨm nugwim aku, Jisas nöbö nuŋ akuyöbö agɨp sö piaku aipam, nöbö mö nuŋ bli aipam yad nölmä. ");
INSERT INTO tmd_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mö rogw mönö yad nölim aku, Maria Magdala aku, Joana aku, Jems nuöm Maria aku, mö bli pɨsaŋ. ");
INSERT INTO tmd_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ñɨŋ Jisas mönö wä pön dub nöbö nuŋwa mönö aku yad nölmɨn, audiöx nugwön, mi yadmɨdöiŋö, rön, nugwölim. Höbai wobɨbi röxg yadmɨdöiŋö, rön, rɨb aku yöx nugumä. ");
INSERT INTO tmd_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Makwam Pita mönö aku nugwön, ipalɨp duön, hogw pɨlim rɨg möl aku amnör mokwac möl wöd nugumɨn, nöbäpö wölɨj wob nɨgim ap uñ wab akwör mɨdöŋa. Aku nugwön, pödpöd rɨ, rön, rɨb mɨga yöx nugu gɨrön, nöbäpö hogwaj aku röböxön höuöil duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Wop akwör, nöbö mös ram yöj lɨglɨg agrö Emeas, hör Jerusalem il yörakwam duŋö, rön, ödöia du gɨrön, ");
INSERT INTO tmd_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ap agap apɨm rɨmɨdmɨn nugwim mönö aku tar yad nugu gɨrön dumɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Dumɨdmɨn nugugɨrön, Jisas höglöm adö hön, ñɨgö nöbö hogwa yölɨŋön duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Makwam nöbö hogw aku Jisas nugwo nugwöyɨx aku, jɨ God rɨmɨn rɨb ñɨŋa uplöbmɨn, ñɨŋ Jisas nugwo nugumɨn nuŋ nöbö keiryöbö wöxnö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nuŋ ñɨgö nöbö hogwa yad nugwön yadöŋa, “Mönö aku agö mönöm nɨgɨp dumɨdöi?” röŋa. Jisas aliö rɨmɨn, ñɨŋ lɨblɨb rɨbä röxg aŋöi nɨg öbɨl gɨ mɨdön, ");
INSERT INTO tmd_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","nöbö Kliopas yadöŋa, “Naŋ weik wop ulmɨdö mɨdö kɨ Jerusalem yörɨk du mɨdön ap agap apɨm rɨmɨd aku nugwöiö ä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Aliö rɨmɨn, Jisas yadöŋa, “Ap aku pödpöd rɨm yadmɨdöi?” röŋa. Aliö rɨmɨn, yadmä, “Jisas nöbö Nasaret yöbö röŋ aku mɨ. God mönö yadɨb nöbö aku, mönö yad nöl ri abön, ap rölɨbä piaku rɨmɨdöŋa. Aliö alöŋ aku, God nugwo pɨsaŋ mɨdɨm alöŋa. Nöbö mö alöŋ aku nugwön mɨ wahax pɨmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","21","Nuŋ alön rɨmɨd aku, rɨb ana yöx nugumɨŋa, ‘God nugwo abmɨn anɨŋ Isrel nöbö mö pön, nugwidɨx mɨd ri abönɨŋö,’ rön nugumɨŋ aku, jɨ God ap höjöpal ur nölɨb nöbö dib bla aipam, mönö pɨ nuöm nɨgɨb nöbö dib bla aipam, nugwo mönö yad gɨrön, pön du Rom gapman nöbö dib aku nugwo nölmɨn, nuŋ mönö diba yadön, nugwo ami nöbö nuŋ piaku ñɨgö nölmɨn, pön du bɨ katlö watlö um sö pɨl pal nɨgɨm wöröxöŋa. Makwam ap röŋ aku wop mösör hö duöŋ pal. ");
INSERT INTO tmd_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Weik pɨxmag alɨg mag aku, mö rogw an i, du nugwo hogw pɨlim ulöm möl kau aku nugwön, hö anɨŋ ap agap apɨm rɨ aku yad nölɨm nugwön pɨlɨx röla. ");
INSERT INTO tmd_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Mö piaku ñɨŋ yadöia, ‘Nöbäpö högi mɨŋ aku mɨdölöm, makwam ejol hogwa hön yadöia, “Nuŋ öbɨlön kömö mɨdö,” röiŋö,’ röia. ");
INSERT INTO tmd_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Aliö rɨmɨn, nöbö an bli nugwo hogw pɨlim ulöm möl kau aku duön nugumɨn, mö piaku rɨg yadöi mag akuyöbö akwör rɨg mɨda. Makwam Jisas nugwo nugwölöi,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Aliö rɨmɨdmɨn, Jisas yadöŋa, “Ñɨŋ nöbö hogwa rɨbyöx nugw ri abölöi. God mönö yadɨb nöbö akuyöbö mönö yadmä aku magalɨg, pödpöd rɨmɨn mönö mi yadöiŋö, rön, nugwölöi? ");
INSERT INTO tmd_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","God rɨg yadöŋ mag akuyöbö, Mesaia aku höd ölɨŋ höb dib ödöriö pöna, jɨ mai mil mag wä keiryöbö alɨg mɨjönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jisas aliö rön, Mosɨs aipam, God mönö yadɨb nöbö akuyöbö aipam magalɨg, Krais nugwo God Mönö kai kɨtim mɨd mönö aku magalɨg ñɨgö yad nöl ri abɨm duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Mögörɨb dumɨdim aku igöp yöra uröpɨnön, Jisas nöbö hogwa önɨb nɨgön duba röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Makwam ñɨŋ nöbö hogwa nugwo wöhö rön yadmä, “Pɨgö kɨ höla. Pɨxmag gurɨba rɨmɨda nugwön naŋ han an pɨsaŋ du hölɨmɨŋö,” rɨmä. Aliö rɨmɨn, Jisas nuŋ nöbö hogwa pɨsaŋ rama duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Rama du mɨdön, ap nɨmɨba nuŋ bred pön, God nugwo ri ablaŋe, rön, pɨ gɨlɨxön ñɨgö nöbö hogwa nölmɨn nugugɨrön, ");
INSERT INTO tmd_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","rɨb mag ñɨŋ nöbö hogwa aku rɨbyöx nölmɨn, aku Jisas ör, me rön, nugumɨn nugugɨrön, Jisas tar yöm röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Alöŋ aku nugwön yadmä, “Ödöi mibɨl yöra hö gɨrön, mönö bli yad nöl gɨrön, God Mönö kai kɨtim mönö il aku bli yad nölmɨdmɨn, madmag an aku rɨn röxg yönön pabɨl nölö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Aliö rön, wop akwör höbkal Jerusalem duön nugumɨn, Jisas nöbö nuŋ akuyöbö agɨp sö, nöbö mö nugub ñɨŋ bli aipam pɨsaŋ hö mögum rön mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Du gɨrön ñɨŋ nugumɨn, nöbö mö bla ñɨŋ keir Jisas rɨg röŋ mag akuyöbö mönö nɨgmɨdmä. “Mör! Jisas wöröxöŋ aku, jɨ höbkal öbɨlön, hö Saimon mɨd yöra wöxnö nɨgɨm nugwö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Mönö yadmɨdim aku nugwön, nöbö hogwa aku yadmä, “An nöbö hogwa ödöi mibɨl yöra dumɨdmɨn, Jisas anɨŋ möigw palmɨn, an nugwo pön ram ana du nɨgön, ap nɨmɨba rön, nuŋ bred pön, God nugwo ri ablaŋe rɨmɨdmɨn mönö, aku Jisas ör, me rön, nugwölɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Makwam mönö aku yadmɨdmɨn nugugɨrön, Jisas nuŋ keir mɨdim mibɨl yöra wöxnö nɨgön, mibɨl yöraku pisö öbɨl gɨ mɨdön yadöŋa, “God ñɨgö nugwidɨx mɨdaŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Jisas aliö rɨmɨn, ñɨŋ nöbäpö höjöl, me rön, ölölö rɨmɨn ipöxmä. ");
INSERT INTO tmd_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ipöxmɨdmɨn mönö, Jisas ñɨgö yadöŋa, “Pödpöd rɨmɨn ipöxmɨdöi? Mämäg ñɨŋa keir nugwöi aku, jɨ pödpöd rɨmɨn rɨb mös yöxmɨdöi? ");
INSERT INTO tmd_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Imag yamsö nɨ bla nugwi. Nör pal! Nɨ pɨ pöi rɨ nugwön nugwöña. Nöbäpö höjöla mɨxɨñ yöd alɨg mɨdöl. Makwam nɨ yuö aipam, yöd aipam alɨg mɨdɨl aku, mämäg ñɨŋa keir mödö nugwöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Jisas aliö rɨ gɨrön, imag yamsö nuŋ akuyöbö ñɨgö yabuöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Almɨn, ñɨŋ wahax pɨ gɨrön, rɨb mɨxɨla yöx gɨrön, aku Jisas ör mönö, rön, rɨb mös yöx nugumɨn nugugɨrön, Jisas ñɨgö yadöŋa, “Ñɨŋ nɨmɨb ap mag bli yörɨk mɨdönö owa?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Aliö rɨmɨn, nugwo dölöm ur nɨgim i nölmä. ");
INSERT INTO tmd_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ñɨŋ nugugu mɨdɨm nugugɨrön, Jisas nuŋ dölöm aku pɨ nɨmöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Makwam Jisas nuŋ ñɨgö yadöŋa, “Höd nɨ ñɨŋ pɨsaŋ mɨdön, weik nɨ rɨ mag akuyöbö aku cönɨŋö, rön, ñɨgö yad nölmɨdma. Mosɨs nɨ rɨbyöx nugwön kɨtöŋ mönö aku nɨgön, God mönö yadɨb nöbö nɨ rɨbyöx nugwön kɨtim mönö aku nɨgön, God Mönö rɨb Sam aku nɨ rɨbyöx nugwön kɨtöŋ mönö aku nɨgön, nɨ kai kɨtim mag akwör magalɨg paŋ mag akwör cönɨŋö, rön, ñɨgö yad nöl ri abön rɨmö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Jisas aliö rön, God Mönö kai kɨtim aku nugw ri abɨŋ, me rön, rɨb wä mɨda ñɨgö nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nuŋ al gɨrön, ñɨgö yadöŋa, “Höd piaku kai kɨtön yadmä, ‘Mesaia aku ölɨŋ höb diba pön wöröxaŋ, hogw pɨlɨŋ, wop mös mɨdön, wop paŋ aku höbkal öbiöna. ");
INSERT INTO tmd_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Makwam, mönö wä nuŋ aku mögörɨb Jerusalem ila nɨg yad nölön, yad nölɨp duön, nöbö mö mögörɨb adadö piaku piaku magalɨg yad nölɨŋ duaŋ nugugɨrön, nöbö mö ap kib mag gwogwo röi aku, pödpöd rɨmɨn aliö alölɨŋö, rön, röböxön, Krais nugw pön cɨrɨpɨŋ nugugɨrön, mag gwogwo pɨx ñɨŋ aku örɨx abönɨŋö,’ rɨmä. ");
INSERT INTO tmd_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nɨ röŋ aku mämäg ñɨŋa keir nugwöia. ");
INSERT INTO tmd_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Makwam Acö na mönö höd rɨg yad nɨgöŋ akwör, nɨ ñɨgö nöina. Ñɨŋ taun dib yörɨk ör mɨdön pöx mɨjöña. Adöx yöd röul adö kau sebö ölɨsö mag keiryöbö hö ñɨgö pɨsaŋ mɨdaŋ nugwön diöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jisas aliö rön, ñɨgö yölɨŋ pön, Jerusalem röböxön, ram yöj lɨglɨg agrö Betani il yöra duön, God ñɨgö nugwidɨx mɨdaŋ, me rön, imag nuŋwa pabɨlön God höjöpalöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Jisas almɨn nugugɨrön, God nugwo pön mögörɨb adöx yöd röul adö kau sö pön duöŋa. ");
INSERT INTO tmd_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Almɨn, ñɨgö wä rɨmɨn nugugɨrön, ib nuŋwa yadmɨn bɨl sö dumɨn nugugɨrön, höuöil Jerusalem dumä. ");
INSERT INTO tmd_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Duön, öim öim God höjöpalɨb rama ram möl yuadö duön, God iba yadmɨn bɨl sö dumɨda.");
INSERT INTO tmd_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mögörɨb mɨgrö kɨ maduar ör ib hör i rɨ nɨgölöŋ wop aku, Mönö aku mɨdöŋa. Mönö aku nuŋ God pɨsaŋ mɨdöŋa. Mönö aku nuŋ keir nuŋ God. ");
INSERT INTO tmd_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Mögörɨb mai rɨ nɨgöŋa; höd meme Mönö aku nuŋ God pɨsaŋ mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","God nuŋ rɨmɨn, Mönö aku nuŋ ap piaku magalɨg rɨ nɨgöŋa. Ap i hör nɨgölöŋ; nuŋ keir rɨ nɨgöŋ ap piakwör mɨda. ");
INSERT INTO tmd_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mönö aku nuŋ kömö mɨdɨb ila maku. Kömö mɨdɨb mag aku nöbö mö ñɨgö mila nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Mil aku duön nöbö mö pɨxmag yuö mɨdöi bla mäp ixmɨda nugwön pɨxmaga Mil aku pal wöröxbä maga mɨdöl. ");
INSERT INTO tmd_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Nöbö mö akuyöbö magalɨg Mil aku nugwo nugw pɨŋ, me rön, God nöbö i nugwo yad nɨgmɨn, nuŋ hön Mil aku mönö yad nölmɨda. Mönö yad nölmɨd nöbö aku ib nuŋwa Jon. ");
INSERT INTO tmd_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jon nuŋ Mil aku yöi. Nuŋ hör Nöbö kaim Mila mɨd mönö aku nöbö mö akuyöbö ñɨgö yad nölɨba höŋa. ");
INSERT INTO tmd_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mil mɨ ödöriö aku nuŋ mögörɨb il kɨ hön, nöbö mö akuyöbö magalɨg ñɨgö mila nölmɨda. ");
INSERT INTO tmd_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Mönö aku nuŋ mögörɨb mɨgrö kɨ hön mɨdmɨda. God nuŋ rɨmɨn, Mönö aku nuŋ keir mögörɨb il kɨ rɨ nɨgön, nöbö mö bla rɨ nɨgön röŋa. Nuŋ keir mögörɨb mɨgrö kɨ hö mɨdöŋ aku, jɨ nöbö mö nugwo mämäga nugwön, aku Nöbö Dib, me rön, nugwölim. ");
INSERT INTO tmd_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nuŋ mögörɨb nuŋwa keir höŋ aku, jɨ nöbö mö nuŋ keir bla nugwo pölim. ");
INSERT INTO tmd_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Makwam nöbö mö bɨl kai, mönö wä nuŋ aku nugw pön, nugwo Nöbö Dib an, me rön, nugw pöi nöbö mö piaku, nuŋ ñɨgö rɨmɨn magalɨg God halöu ha nuŋwa mɨdɨb maga ra. ");
INSERT INTO tmd_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","God halöu ha nuŋwa mɨjöñ aku, nöbö bla mö pön, halöu ha yöx pön höm rɨg mɨdöi mag akuyöbö rɨg mɨdeñ. God nuŋ keir raŋ halöu ha nuŋwa mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mönö aku, nuŋ hön nöbial mɨxɨña nɨgön, anɨŋ pɨsaŋ hölɨmön mɨdmɨda. Makwam, an mil mag wä nuŋwa mödö nugwöla. Nuŋ Acö Ha nuŋwa paŋyöbö ödöriö makwam, Acö nuŋ mil mag wä keiryöbö alɨg mɨd aku, Ha nuŋwa algör mil mag wä keiryöbö alɨg mɨda. Makwam nuŋ mɨxɨña nɨgön nöbial röxg hön, anɨŋ magalɨg uliöxön mɨ ödöriö madmag nɨgön, mönö ma aku magalɨg yad nöl ri abmɨda. ");
INSERT INTO tmd_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Mönö aku nuŋ höŋ aku, Jon nuŋ nugwön, wö rön, nöbö mö akuyöbö ñɨgö yadöŋa, “Weik hö Nöbö mɨdö kɨ, nɨ ñɨgö höd yadma, ‘Nöbö i nuŋ nɨ mai hömɨd aku, jɨ nɨ yöx pön hölim wop aku, nuŋ maduar ör ib hör i mɨdmɨda. Makwam, nuŋ nɨ röxgɨb yöi; nuŋ Nöbö Dib ödöriö,’ me rɨma aku, nöbö aku maku pal,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nuŋ anɨŋ nöbö mö magalɨg mɨ ödöriö ögwö yöxön, pɨ ösös rɨ ri abön, ap wä wä mɨga akwör nöla. ");
INSERT INTO tmd_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Höd meme wop aku lo mönö adaku, God Mosɨs nölmɨn, Mosɨs anɨŋ nölöŋ aku, jɨ God nöbö mö uliöxön pɨ ri abmɨd mönö ma aku, Jisas Krais höŋ makwam, weik wöxnö nugumɨdöla. ");
INSERT INTO tmd_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nöbö mö bli God nugwo nugwölöi. Ha nuŋ paŋyöbö mɨd akwör nuŋ keir nuŋ God. Nuŋ Nuö pɨsaŋ mɨdöia. Nuŋ Nuö nuŋwa yad wöxnö nɨgöŋa nugwön weik an Acö God mödö nugwöla. ");
INSERT INTO tmd_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Juda nöbö dib Jerusalem yöbö piaku, ñɨŋ God ap höjöpal ur nölɨb nöbö bli nɨgön, God höjöpalɨb rama mabö rɨ nölmɨdöi nöbö bli pɨsaŋ yad abön yadmä, “Ñɨŋ Jon mɨd yöra duön, ‘Nagö agö nöböm?’ me rön, yad nugune,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ñɨŋ Jon mɨdöŋ yöra uröpɨnön, nugwo yad nugwön yadmä, “Nagö agö nöböm?” rɨmä. Yad nugumɨdmɨn, nuŋ wai nölölöŋ. Nuŋ ñɨŋ wöxnö yadön yadöŋa, “Nɨ Krais yöi wöhö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Aliö rɨmɨn, ñɨŋ paiŋö yadmä, “Aliö rɨlö aku, nagö agö nöböm? Nagö Ilaija mönö ä?” rɨmä. Aliö rɨmɨn, Jon yadöŋa, “Nɨ Ilaija yöi,” me röŋa. Aliö rɨmɨn, ñɨŋ yadmä, “Nagö God mönö yadɨb nöbö öim pöx mɨdmɨdöl akwör mönö ä?” rɨmä. Aliö rɨmɨn, Jon wöhö röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Jon aliö rɨmɨn, nöbö piaku yadmä, “Makwam, nagö agö nöböm? Nagö agö nöböm yadan, an nugwön du nöbö dib anɨŋ yad aböi akuyöbö ñɨgö yad nölɨŋö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Aliö rɨmɨn, Jon nuŋ ñɨgö yadöŋa, “Nɨ weik rɨmɨdɨl mag kɨ, God mönö yadɨb nöbö Aisaia höd rɨg yadöŋ mag akwör rɨmɨdla. Nuŋ yadöŋa, ‘Mögörɨb nöbö mö mɨga mɨdölöi, mögörɨb rɨg kap mibɨl yöraku du mɨdön, nɨ wö diba rɨ gɨrön yadmɨdla, “Öim Nöbö Diba hömɨdö, rön, ödöi röb rɨ ri abmɨjɨnö,” rɨmɨdlö,’ röŋa. Nɨ Jon weik rɨmɨdɨl maku,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Makwam Jon nugwo yad nuguba hem nöbö piaku, Perisi nöbö bli pɨsaŋ hömä. ");
INSERT INTO tmd_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ñɨŋ Jon nugwo yad nugwön yadmä, “Nagö yadlö, nɨ Krais yöi, Ilaija yöi, God mönö yadɨb nöbö pöx mɨdmɨdöl aku yöi wöhö, rɨlö makwam, pödpöd rɨmɨn nöbö mö akuyöbö ñɨgö röbö pal nölmɨdlö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Aliö rɨmɨn, Jon yadöŋa, “Nɨ ñɨgö hör röbö akwör pal nölmɨdla. Makwam nöbö i mibɨl ñɨgö yörɨk mödö mɨda, nuŋ nöbö pödiöm mɨdö rön nugwölöi. ");
INSERT INTO tmd_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nöbö aku nuŋ nɨ mai höna jɨ nuŋ nɨ röxgɨb yöi; nuŋ nöbö dib ödöriö, nɨ nöbö ulmɨdö. Nɨ yam uñ nuŋ aku naga yaub maga mɨdöl,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jon nöbö mö akuyöbö ñɨgö röbö pal nölmɨd ram yöj lɨglɨg agrö Betani, röbö Jodan pö ir kwo, nugwön nöbö piaku hön nugwo mönö aku yad nugumä. ");
INSERT INTO tmd_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Löum yöbö Jisas höm nugugɨrön, Jon Jisas nugwön nöbö mö piaku ñɨgö yadöŋa, “Nugwi! God Sipsip Ha nuŋwa maku pal. Nuŋwör nöbö mö mögörɨb il kɨ adadö magalɨg ap kib mag gwogwo röi pɨx aku örɨx aböna. ");
INSERT INTO tmd_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nöbö aku mɨ nɨ yadma, ‘Nöbö i nuŋ nɨ mai hön aku, jɨ nɨ yöx pön hölim wop aku, nuŋ maduar ör ib hör i mɨdmɨda. Makwam, nuŋ nɨ röxgɨb yöi; nuŋ Nöbö Dib ödöriö,’ rɨma. ");
INSERT INTO tmd_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nöbö Dib aku nöbö kai me rön nɨ höd nugwölɨm. Jɨ Isrel nöbö mö, Nöbö Dib aku nöbö pödiöm mɨd aku nugwɨŋ, me rön, nɨ ñɨgö röbö pal nölɨba hölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Makwam Jon Jisas mönö adakwör yadön yadöŋa, “Nöbö kɨ nöbö kai, me rön, nɨ keir nugwöyöx; jɨ Nöbö nɨ yad abmɨn hön, nöbö mö ñɨgö röbö pal nölmɨdɨl aku yadöŋa, ‘Nagö nugwaŋ, Inöma nuŋ hön nöbö kai pɨsaŋ mɨjön, Nöbö akwör nuŋ nöbö mö piaku ñɨgö Inöm Leia pal nöiönɨŋö,’ röŋa. Yadöŋ mönö aku, weik Inöma adöx yöd röul adö kau sebö yöur döpwö röxg bɨbɨ rɨ pɨn nugwo görmɨn ");
INSERT INTO tmd_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","nugwön nɨ nugw ri abön ñɨgö mönö mi yadmɨdla, Nöbö kɨ nuŋ God Ha nuŋ akwör,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Löum yöbö Jon nöbö nuŋ hogwa pɨsaŋ, iswob hö röbö pal nölmɨd kau aku mɨdɨm nugugɨrön, ");
INSERT INTO tmd_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jisas hö padɨxmɨn, Jon nuŋ Jisas nugwön nöbö mö akuyöbö ñɨgö yadöŋa, “Nöbö kɨ God Sipsip Ha nuŋwa maku pal,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Jon aliö rɨmɨn, nöbö nuŋ hogwa, mönö aku nugwön, Jisas dumɨdöŋ möl aku mai dumä. ");
INSERT INTO tmd_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Makwam Jisas höuöiliö nöbö hogwa nugwön yadöŋa, “Pödpöd rɨmɨn hömɨdöi?” röŋa. Aliö rɨmɨn, yadmä, “Rabai! Nagö hölɨmlö pikai owa?” rɨmä. Hibru mönö yadön “Rabai” me rim mönö aku il aku “Mönö Yad Nölɨb Nöbö.” ");
INSERT INTO tmd_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Makwam ñɨŋ akuyöbö alön yad nugumɨn, Jisas yadöŋa, “Makwam, nɨ pɨsaŋ duön nugwöñɨŋö,” röŋa. Jisas aliö rɨmɨn, ñɨŋ wop akwör pɨgö mɨdöŋ mag aku duön nuŋ pɨsaŋ mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jon nöbö nuŋ hogw aku, nöbö i ib nuŋwa Edru, nöbö i Edru pɨgnɨŋ nuŋwa Saimon Pita. ");
INSERT INTO tmd_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Edru mag akwör du pɨgnɨŋ nuŋwa Saimon nugwo hölu nugwön yadöŋa, “Mesaia hönɨŋö rön öim pöx mɨdmɨdöl nöbö aku weik nugwölɨŋö,” röŋa. “Mesaia” röŋ mönö mag aku, Grik mönö yadön “Krais” me röia. ");
INSERT INTO tmd_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Edru aliö rön, pɨgnɨŋ Saimon nugwo yölɨŋön, Jisas mɨdöŋ yöra dumɨn, Jisas Saimon nugwo nugwön yadöŋa, “Jon ha nuŋwa Saimon. Nagö Sipas me cöñɨŋö,” röŋa. Arameik mönö yadön, iba Sipas me röŋ mönö mag aku, Grik mönö yadön Pita me röia. Sipas aipam Pita aipam ila paŋyöbö aku “rɨg.” ");
INSERT INTO tmd_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Löum yöbö, Jisas mögörɨb Galili duba, du Pilip nugwön yadöŋa, “Nɨ pɨsaŋ duŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip, Edru, Pita, mögörɨb ñɨŋa Betsaida yöbö. ");
INSERT INTO tmd_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Makwam Pilip du Nataniel nugwo nugwön yadöŋa, “An nöbö aku, Mosɨs aipam, God mönö yadɨb nöbö bli aipam kai kɨtön yadim nöbö aku nugwo weik nugwöla. Nuŋ mɨ Jisas, Josep ha nuŋwa. Mögörɨb nuŋwa Nasaret yöbö,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Pilip aliö rɨmɨn, Nataniel yadöŋa, “Nöbö wä i mögörɨb gwogwo akuyöbö henɨŋö,” röŋa. Aliö rɨmɨn, Pilip yadöŋa, “Aliö rɨlö aku, han du nuguŋö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Aliö rön, ñɨŋ nöbö hogwa duön igöp igöp rɨm nugugɨrön, Jisas Nataniel nugwön yadöŋa, “Nöbö aku nöbö Isrel ödöriö makwam, nuŋ inakmönö hörɨb nöbö yöi; nuŋ mönö mör wöxnö yajönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Jisas aliö rɨmɨn, Nataniel yadöŋa, “Nagö pödpödiö nɨ nugulö?” röŋa. Aliö rɨmɨn, Jisas yadöŋa, “Pilip nagö mai yölɨŋ pön höba wa; nɨ nagö höd nugula, nagö römɨd gɨ mɨdlö bɨ röui il yöraku,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Jisas aliö rɨmɨn, Nataniel yadöŋa, “Mönö yad nölɨb nöbö. Nagö nugula! Nagö God Ha nuŋwa, Isrel nöbö mö Kiŋ an,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Aliö rɨmɨn, Jisas yadöŋa, “Nagö hör röui il yöraku nugula rɨl makwam, nɨ nugw pɨlanö? Mai ap keiryöbö bli nugunaŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jisas aliö rön yadöŋa, “Nɨ ñɨgö mi yadmɨdla, adöx yöd röul adö kau sö waglöx möla rödaŋ, ejol bla hön, nɨ Nöbö Ha nuŋwa nugup pikwo pik rön, nugup uhömɨdɨŋ, nugwöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Wop mös mɨdön, nöbö i mö pɨba rön, nöbö mö wö rɨm, Kena taun, mögörɨb Galili mibɨl yöra duön ap nɨmɨmä. Wop aku, Jisas nɨgön, nöbö nuŋ bla nɨgön, ñɨgö algör yad wö rɨmɨn dumä. Makwam Jisas nuöma aipam duön ram aku mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Röbö wain aku nɨm pörmɨdmɨn, Jisas nuöma hön Jisas nugwo yadöŋa, “Waina nɨm pöröiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Aliö rɨmɨn, Jisas yadöŋa, “Nɨ al aliö re, rön, nɨ yadmɨjɨnö. Wop na aku wöxnö nɨgölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jisas aliö rɨmɨn, nuöm nuŋwa du mabö rɨ nölɨb nöbö akuyöbö ñɨgö yadöŋa, “Jisas mönö i yadmɨjön aku, rɨg yajön mag akuyöbö akwör cɨne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Makwam Juda nöbö mö rɨg pön röi wi yöj dib ödöriö akuyöbö iŋösu sö pɨ nɨgɨm mɨdöŋa. Wi yöj diba paŋ paŋ röbö lita akuyöbö padokwo padök mös mös höuöiliö hö wölu amñaxɨb sö (100) un rag hörɨbɨm. Makwam Juda nöbö mö ñɨŋ rɨg rɨmɨdöi mag akuyöbö, God mämäg il yöra nöbö mö lei wä mɨjnɨŋö, rön, wi yöj piaku röbö un rag hö hörön, iŋ wajmag äbäd abmɨdöia. ");
INSERT INTO tmd_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisas nuŋ mabö rɨ nölɨb nöbö akuyöbö ñɨgö yadöŋa, “Rɨg wi yöj kɨyöbö, röbö un pön hö pörɨŋ, aja wölaŋ,” me röŋa. Jisas aliö rɨmɨn, rɨg yadöŋ mag akuyöbö rɨmɨn yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","“Weik röbö un rag hö nɨgöi aku, un pön duön, ap nɨmmɨdöl yörɨk nugwidɨx mɨd nöbö aku nugwo nöine,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Jisas aliö rɨmɨn, röbö aku un pön du nöbö dib aku nugwo nölmɨn, nuŋ pön nɨm nugumɨn, röbö waina mɨdöŋa. Jɨ nuŋ röbö wain aku pikai yöbö me rön nugwölöŋ; mabö rɨ nölɨb nöbö bla ñɨŋör nugumä. Makwam nuŋ nugwölöŋ, nöbö mö pɨba röŋ aku nugwo wö rɨm hömɨdmɨn yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Öim ör, röbö wain wä aku höd rag hö nölɨŋ nɨm pöcöñ aku, mai röbö wain gwogwo aku nölmɨn nɨmöia. Makwam nagö röbö wain wä aku rag hö nɨgman mɨdam, weik ör rag hö nölmɨdlaŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jisas ap rölɨbä höd meme ila nɨgön röŋ aku, nuŋ Kena taun, mögörɨb Galili mibɨl yöra mɨdön röŋa. Ap rölɨbä aku rön, nuŋ nöbö pödiöm mɨdöŋ aku yabumɨn, nöbö nuŋ bla nugwön, nugwo nugw pɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Makwam Kena taun röböxön, Jisas nuŋ keir, nuöm, pɨgnɨŋ nöbö nuŋ bla pɨsaŋ taun ulmɨdö Kapaneam duön, hör wop mɨdöy piaku mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Juda ada Pasopa wop dib ñɨŋ aku womiöx höŋa nugwön Jisas Jerusalem duöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jisas Jerusalem duön, God höjöpalɨb rama ram möl yuadö nugumɨn, nöbö bli ñɨŋ hön kau, hön sipsip, yöur döpwö bla rag hö sɨm rön, nöbö bli äbäñ mɨdö bla nɨgön, bäpö rola römɨd gɨ mɨdön, rɨg imcɨxön rɨmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jisas nugwön, nag i pön wajɨxön, hön sipsip hön kau bla rɨbɨx rɨŋö bö abön, rɨg rag hö nuö nuö imcɨxmɨdim äbäñ wab bla rɨg bla alɨg pɨ göur aböŋa. ");
INSERT INTO tmd_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Akuyöbö alön, nöbö mö yöur döpwö rag hö sɨm rɨmɨdim akuyöbö ñɨgö yadöŋa, “Ap piaku pɨrag di. Acö na ram nuŋ aku rɨm sɨmaim ram i röxg nɨgölaŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jisas almɨdmɨn, nöbö nuŋ bla rɨb ñɨŋa duöŋ God Mönö kai kɨtim mönö adaku. Mönö aku kai kɨtön yadmä, “Höjöpalɨb ram nagö aku madmag ödöriö nɨgön wöröxnö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Makwam Juda nöbö dib bli hön, Jisas nugwo yad nugwön yadmä, “Nagö yön yadmɨn hön aliö almɨdlö? God nuŋwör yadmɨn hön rɨmɨdla rön kwönö, ap rölɨbä akuyöbö i raŋ nugwön, ‘Mi yadlaŋe,’ rön nugunɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Aliö rɨmɨdmɨn, Jisas ñɨgö paiŋö yadöŋa, “Ñɨŋ God höjöpalɨb ram kɨ hajal aböñ aku, wop mös paŋ iswob ur nɨgɨnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Jisas aliö rɨmɨn, yadmä, “God höjöpalɨb ram kɨ, kɨm padokwo padök mös höuöiliö hö pɨn du adokwebö agñɨŋ bö (46) rɨ pörim magwaim, jɨ naŋ iswob wop mös paŋör ur nɨgɨnö, rön, yadmɨdlö ä?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Makwam Jisas nuŋ höjöpalɨb rama mönö yadöŋ aku, mɨxɨñ nuŋwa keir akwör yadöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Makwam, mai Jisas nuŋ wöröxön öbɨlöŋ aku, nöbö nugwo pɨsaŋ yönmɨdöi piaku God Mönö aku aipam, Jisas nuŋ keir mönö yadöŋ aku aipam rɨbyöx nugwön, “Mi yadö,” rön nugw pɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jisas, Juda ada Pasopa wop dib ñɨŋ aku Jerusalem mɨdön, ap rölɨbä akuyöbö bli rɨmɨdöŋ aku nugwön, nöbö mö bla, “Nuŋwör Mesaia aku,” me rön, nugwo nugw pɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Nöbö mö pödiöm mɨdöi akuyöbö, Jisas nuŋ höd nöbö i yad nugwölöŋ. Nöbö mö pödiö mödöi aku nuŋ keir mödö nugwön, rɨg rɨmɨdöi mag aku nugw ri aba. Nöbö mö piaku rɨb ñɨŋa adö kai du aku nuŋ keir nugw ri ab aku mɨ, nuŋ nöbö mö piaku ñɨgö nöbö mö nugub nɨ, me rön, pölöŋ. ");
INSERT INTO tmd_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Juda Kansol dib aku nöbö i mɨdmɨda, ib nuŋwa Nikodimas. Nuŋ Perisi nöböm. ");
INSERT INTO tmd_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nuŋ pɨxmag yuö bö, Jisas nugwo nuguba, mɨdöŋ yöra hön yadöŋa, “Mönö yad nölɨb nöbö. An nugwöla, ap rölɨbä akuyöbö rɨlö piaku, naŋ keir röyax; God nuŋ keir nagö pɨsaŋ mɨd makwam, ap rölɨbä akuyöbö rɨlö. Makwam, an nugumɨn, God nuŋwör nagö abmɨn hön anɨŋ mönö yad nöilaŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Aliö rɨmɨdmɨn, Jisas yadöŋa, “Nɨ nagö mi yadmɨdla, nöbö mö kömö yoŋyöbö wöxnö nɨgöñ piakwör, God ñɨgö pön, ‘Nöbö mö nɨ’ me rön, nugwidɨx mɨjönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Jisas aliö rɨmɨn, Nikodimas aiö rön rɨb mɨga yöxön yadöŋa, “Nöbö mö yöx nɨgɨm dib röxgöi akuyöbö, höbkal nuöm wöta yuö kwo duŋ, iswob yöx pön höŋ, nöbö mö kömö yoŋyöbö nɨgɨŋ, me rön, yadmɨdlanö owa agapɨm?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Aliö rɨmɨn, Jisas yadöŋa, “Nagö mɨ ödöriö yadmɨdla, nöbö mö piaku, röbö aku aipam God Inöma aipam pön, hör kömö yoŋyöbö nɨgöñ nöbö mö akwör, God ñɨgö pön, ‘Nöbö mö nɨ’, me rön, nugwidɨx mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nöbö mö yöx pön höi paŋ aliar yöx pön höm rɨg mɨdöi aku, jɨ God Inöma nuŋ hön inöm mag ñɨŋa yuö kwo raŋ kömö mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Makwam, ñɨŋ nöbö mö magalɨg kömö yoŋyöbö wöxnö nɨgɨb mönö yadɨl aku, naŋ aiö rön rɨb mɨga yöx nugumɨjɨnö. ");
INSERT INTO tmd_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Hödal inina aku rɨb nuŋwa keir hön dumɨda. Inina pɨrmɨn nugwöi aku, jɨ hö adaku du adaku, me rön, röx nugwölöi. Makwam mag aliö akuyöbö, God Inöma hön nöbö mö yuö kwo mɨdaŋ, nöbö mö kömö yoŋyöbö mɨjöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Jisas aliö rɨmɨn, Nikodimas yadöŋa, “Nagö yadmɨdlö adaku, pödpöd cön?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Aliö rɨmɨn, Jisas yadöŋa, “Naŋ Isrel nöbö mö mönö yad nölɨb nöbö dib ñɨŋa i, jɨ naŋ nugwöiö ä? ");
INSERT INTO tmd_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nagö mɨ ödöriö yadmɨdla, an keir ap agapɨm nugw ri abön, ap agapɨm mämäg ana keir nugwön, nugwöl aku akwör ñɨgö yad nölmɨdöl aku, jɨ yadmɨdöl mönö aku ñɨŋ nugw pölöi. ");
INSERT INTO tmd_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nɨ ñɨgö mögörɨb il kɨ rɨg rɨ akuyöbö yadmön, nugw pölöi aku, pödpöd rön God mögörɨb adöx yöd röul adö kau sö rɨ akuyöbö yadmön, nugw pöñ? ");
INSERT INTO tmd_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Makwam nöbö mö i God mögörɨb adöx yöd röul adö kau sö yöraku yönön nugwölöŋ; nɨ keir Nöbö Ha nuŋwa akwör paŋ sar mɨdön höma. ");
INSERT INTO tmd_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Makwam maduar ör mögörɨb rɨg kap mibɨl yöra mɨdmɨn, kas gwogwo bla Isrel nöbö mö ñɨgö öbɨxɨm wöröxmɨn nugwön Mosɨs kas gwogwo piakuyöbö i pɨ bɨ höñ sö nɨgmɨn, nöbö mö bɨl kai ñɨŋ paŋ kas akwör nugwim piaku, ñɨgö kömö nɨgöŋa. Makwam mag aliö akuyöbö, Nöbö Ha nuŋwa nugwo bɨ höñ sö pɨl pal nɨgɨŋ, ");
INSERT INTO tmd_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","nöbö mö bɨl kai nugwo nugw pöñ piaku, kömö öim mɨdɨb maga pöña. ");
INSERT INTO tmd_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","God nöbö mö mögörɨb mɨgrö kɨ mɨdöi akuyöbö ñɨgö mɨ ödöriö madmag nɨgön, Ha paŋyöbö nuŋ mɨd aku ñɨgö me rön nölöŋa. Makwam, nöbö mö bɨl kai Ha nuŋwa nugw pöñ akuyöbö, ñɨgö kömö öim mɨdɨb mag aku nölaŋ, wöröxön hölögɨpeñɨm. ");
INSERT INTO tmd_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God Ha nuŋwa agal aböŋ aku, nöbö mö bla ñɨgö mönö diba yajönɨŋö, rön, agal abölöŋ; nöbö mö akuyöbö kömö paŋ, me rön, agal aböŋa. ");
INSERT INTO tmd_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Nöbö mö bɨl kai Ha nuŋwa nugw pöñ akuyöbö, God ñɨgö mönö diba yadön paiŋö ölɨŋ höb pɨ nölen. Jɨ nöbö mö nugwo nugw peñ akuyöbö, God Ha nuŋwa paŋyöbö ödöriö aku nugwo nugw peñ akwör, God nuŋ mönö diba yadaŋ, paiŋö ölɨŋ höb pöñɨŋö, röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","God nöbö mö akuyöbö ñɨgö mönö diba yadön paiŋö ölɨŋ höb pɨ nölön, il aku aliö mɨda: Mila mögörɨb mɨgrö kɨ hö aku, jɨ nöbö mö ñɨŋ, mila mɨd yöraku duŋö, rön, rɨb aku yöx nugwölöi. Ñɨŋ ap kib mag gwogwo rɨ gɨr mɨdöi aku, pɨxmag gur piakwör mɨjnɨŋö, rön, rɨb aku yöx nugwöia. ");
INSERT INTO tmd_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mil aku nugumɨn ölɨsö wölɨm, ‘Gwogwam röl aku, wöxnö nugweñɨŋö,’ rön, mila mɨd yöra heñɨm. ");
INSERT INTO tmd_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Makwam nöbö mö ödöriar rɨmɨdöi piaku, ‘God rɨg yad mag akwör rɨmɨdöl aku wöxnö nugwɨŋ,’ me rön, mila mɨd yöra höiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Mai Jisas nöbö nuŋ bla pɨsaŋ du mögörɨb Judia mibɨl piaku du mɨd gɨrön, nöbö mö akuyöbö ñɨgö röbö pal nölmɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ainon mögörɨb Salim il yöra mɨdöŋa. Makwam mögörɨb Ainon yöraku röbö mɨga mɨdöŋa. Makwam, wop mibɨl yöraku, Jon nuŋ Ainon yöraku mɨdön, nöbö mö mɨga hömɨdmɨn, nuŋ ñɨgö röbö pal nölmɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Wop aku ñɨŋ röbö pal nölɨb nöbö Jon nugwo nag nɨgmä. ");
INSERT INTO tmd_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Makwam Juda nöbö i hön, Juda mag ñɨŋ akuyöbö, röbö äbäd abön God mämäg ila mɨd ri abnɨŋö rɨmɨdöi mönö adaku yadön, Jon nöbö nuŋ bli pɨsaŋ nuö nuö yadmä. ");
INSERT INTO tmd_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nuö nuö yadön, Jon nöbö nuŋ bla hön nugwo yadmä, “Mönö yad nölɨb nöbö. Nöbö röbö Jodan pö ir kwo mɨdmɨn, nugwo Nöbö Dib me rɨmö aku, weik hö nöbö mö ñɨgö röbö pal nölmɨda nugwön nöbö mö magalɨg nugwo dumɨdöiŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Aliö rɨmɨdmɨn, Jon yadöŋa, “God rɨb nuŋwa keir yöx nugwön, anɨŋ mabö hörɨrör yad nɨga. ");
INSERT INTO tmd_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ñɨŋ keir nugwöia nɨ ñɨgö yadma, ‘Nɨ Krais yöi; God yadmɨn nɨ hör ödöi nuŋ aku röb mɨdlö,’ rɨma. ");
INSERT INTO tmd_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nöbö i mö pön wop aku, nuŋ mö nuŋwa pöna. Mö aku mö nuŋwa maku pal. Mö pön nöbö aku, nöbö nugub nuŋwa i hön nugwo rɨ nöiöna. Wop kai mö nuŋwa pɨba hönɨŋö, rön, nugwo pöx mɨjöna. Makwam nuŋ mö pɨba hön ‘Mödö hölö’ cön aku, nöbö nugub nuŋwa wahax pöna. Mag akuyöbö nɨ algör. Jisas nuŋ nöbö mö akuyöbö ñɨgö aliö almɨd aku, nɨ wä ra. Wopik nɨ mɨ ödöriö wahax pɨmɨdla. ");
INSERT INTO tmd_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ib nuŋwa wöluaŋ nugugɨrön, ib na pɨn diön aku wä. ");
INSERT INTO tmd_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Nöbö adöx yöd röul adö kau sebö hö aku, nuŋ nöbö mö bla magalɨg padɨx rol yöra sö mɨda. Nöbö mögörɨb il kɨyöbö nöbö aku, nuŋ mögörɨb il kɨyöbö makwam, mögörɨb il kɨ rɨbyöx nugwön mönö rɨg yadöi aliar yadmɨda. Jɨ nöbö adöx yöd röul adö kau sebö hö aku, nuŋ nöbö mö akuyöbö magalɨg padɨx rol yöra sö mɨda. ");
INSERT INTO tmd_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nuŋ adöx yöd röul adö kau sö mɨdön ap agapɨm mämäga nugwa aku, mönö kai audiöx nugwa aku, nöbö mö piaku ñɨgö yad nölmɨda, jɨ mönö nuŋ aku yöxmɨdölöi. ");
INSERT INTO tmd_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Jɨ nöbö mö mönö nuŋwa nugw pöi piaku, God mönö ma akwör yadö, rön, nugw pöia. ");
INSERT INTO tmd_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","God nuŋ Jisas aböŋ aku, Inöm nuŋ aku nugwo nölmɨn aja wölmɨn, God mönö mag nuŋ akwör yad nölmɨda. ");
INSERT INTO tmd_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nuö Ha nuŋwa nugwo madmag nɨgön, ‘Ap bla magalɨg nugwidɨx mɨdane,’ rön, pɨ imag döul nuŋwa nɨga. ");
INSERT INTO tmd_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nöbö mö bɨl kai Ha nuŋwa nugw pöi piaku, kömö öim mɨdɨb maga mödö pöia. Jɨ nöbö mö bɨl kai Ha nuŋwa nugw pölöi piaku, ñɨŋ kömö öim mɨdɨb maga peñɨm; God nöbö mö adaku ñɨgö mönö diba yadaŋ, ömörö pɨ gör mɨjöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Perisi nöbö bla mönö bli audiöx nugumä, nöbö mö mɨg mɨŋa Jisas pɨsaŋ mɨjnɨŋö, rön, nuŋ mɨdöŋ yöra höm, nuŋ ñɨgö nöbö mö mɨga röbö pal nölmɨdöŋa; jɨ nöbö mö mösör bli Jon mɨdöŋ yöra höm, nuŋ ñɨgö röbö pal nölmɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Jisas nuŋ keir nöbö mö akuyöbö ñɨgö röbö pal nölölöŋ; nöbö nuŋ piakwör ñɨgö röbö pal nölmä. ");
INSERT INTO tmd_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Perisi ada mönö akuyöbö yadmɨdmä nugwön, Jisas mögörɨb Judia röböxön, höbkal mögörɨb Galili duöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ödöi mibɨl yöra duön nuŋ mögörɨb Sameria uröpɨnöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Mögörɨb Sameria mibɨl yöra duön, Sikar tauna uröpɨnöŋa. Sikar il yöraku makwam, maduar ör Jekop ha nuŋwa Josep nugwo mögörɨb i yadöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jekop röbö ulöm pön yölu göŋ aku mɨdöŋ makwam, Jisas höm höm, naiö mibɨl yör kɨpisö mag aku ipɨtmɨn, du röbö ulöm möla il yöra römɨd gɨ mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Makwam nöbö nuŋ piaku ap mag wobɨba Sikar taun aku dumä. Jisas röbö ulöm möla il yöra römɨd gɨ mɨdöŋa nugwön mö Sameria yöbö i röbö unba höŋa. Hömɨdmɨn, Jisas nugwön yadöŋa, “Nɨ röbö un nölan nɨmnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Jisas aliö rɨmɨn, mö aku yadöŋa, “Ñɨŋ Juda nöbö mö, anɨŋ Sameria nöbö mö nugwön, hölul rɨ ri abön röi aku, pödpöd rɨmɨn, ‘Nɨ röbö un nölan nɨmnö,’ rön yadmɨdlö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Aliö rɨmɨn, Jisas paiŋö yadöŋa, “God ap wä nöbö mö nölɨba rɨmɨd aku nugwön, nɨ nagö, röbö un rag hö nölö, rɨmɨdla, nɨ nöbö pödiöm mɨdɨl kɨ nugulax aku, naŋ nɨ yadlax aku, nɨ nagö röbö kömö mag nɨg nölɨba nöilöxa. ");
INSERT INTO tmd_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Jisas aliö rɨmɨn, mö aku yadöŋa, “Nöbö dib. Röbö unɨb röbej nagö i mɨdöl; röbö ulöm möla algör ör mɨ yuö pibö mɨda. Makwam, röbö kömö mag nölɨb aku pikai yöbö pɨnö? ");
INSERT INTO tmd_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nöso maduebö ana Jekop röbö ulöm möl kɨ anɨŋ nölöŋa. Röbö pɨñ gör, nuŋ keir aipam, ha nuŋ pia aipam nɨmɨm, hön sipsip ap nuŋ piaku aipam nɨmön rɨmɨdöia. Makwam, nagö rɨb kai yöx nugulö? Nɨ nöbö dib, Jekop nöbö ulmɨdö, me rön, rɨbyöx nugulö ä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Aliö rɨmɨn, Jisas yadöŋa, “Nöbö mö röbö kɨ nɨmöñ akuyöbö, ñɨgö iswob röbö de piöna; ");
INSERT INTO tmd_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","jɨ nöbö mö röbö nɨ nölmön nɨmöñ akuyöbö, ñɨgö iswob röbö de pɨlen. Röbö nɨ nöin aku nɨmɨŋ, yuö ñɨŋ kwo röbö ilam möla röd gɨrön, ñɨgö kömö öim mɨdɨb mag aku nöiönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Jisas aliö rɨmɨn, mö aku paiŋö yadöŋa, “Nöbö dib. Nɨ röbö aku nölaŋ nɨmɨmön, mai nɨ röbö de pɨlölaŋ; nɨ hön röbö kɨ unöinö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Aliö rɨmɨn, Jisas yadöŋa, “Du nöbönaŋ nagö yad pön hö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Jisas aliö rɨmɨn, yadöŋa, “Nɨ nöbö kap mö yöi wöhö,” röŋa. Aliö rɨmɨn, Jisas yadöŋa, “Mönö aku mi yadmɨdlö. ");
INSERT INTO tmd_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nöbö akuyöbö mömɨd sö pɨmö aku, jɨ nöbö weik pɨsaŋ mɨdlö aku, nöbönaŋ nagö yöi. Makwam, mi yadmɨdlaŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Jisas aliö rɨmɨn, mö aku yadöŋa, “Nöbö dib. Nɨ nugula, nagö God mönö yadɨb nöböm. ");
INSERT INTO tmd_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nöso auso an maduar ör pɨd kɨ God höjöpalön rɨg rɨmɨdöi mag akwör, an kwo algör ör höjöpal mɨdöla aku, jɨ ñɨŋ Juda ada yadöia, ‘Jerusalem ör God höjöpalɨŋ,’ me röiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Aliö rɨmɨn, Jisas yadöŋa, “Nɨ mönö mi yadmɨdɨl kɨ nugwö. Mai pɨd kɨ aipam Jerusalem aipam Acö nugwo höjöpaleñɨm. ");
INSERT INTO tmd_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ñɨŋ Sameria nöbö mö höjöpalöi aku, nöbö pödiöm nugwo höjöpalöi aku nugwölöi; jɨ an Juda nöbö mö, Nöbö höjöpalmɨdöl Nöbö aku nugwöla. Aku agapɨm: God nuŋ pödpöd rön nöbö mö kömö pön aku, anɨŋ Juda nöbö mö yadöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Wopa womiöx hömɨda, makwam weik mödö hö mɨk, God Inöma nuŋ nöbö mö rɨba nölmɨn nugugɨrön, ñɨŋ Acö nugwo ödöriö akwör höjöpaiöña; almɨjöñ aku, nugwo mɨ wä cöna. ");
INSERT INTO tmd_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God nuŋ Inöma mɨd aku mɨ, nöbö mö God höjöpalön, inöm ñɨŋa yuö kwo mör höjöpalɨŋ. ");
INSERT INTO tmd_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jisas aliö rɨmɨdmɨn, mö aku paiŋö yadöŋa, “Nɨ nugula, mai Mesaia aku hön, anɨŋ ap magalɨg yad nöl ri abönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Aliö rɨmɨn, Jisas yadöŋa, “Nöbö aku mɨ nɨ mɨdla. Nagö pɨsaŋ mönö pɨmɨdöl mɨk,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jisas aliö rɨmɨn nugwön mag aku nöbö nuŋ piaku höröpɨnön nugumɨn, Jisas mö i pɨsaŋ mönö nɨgmɨdöŋa. Nugwön ñɨŋ pɨlɨx rɨmä, jɨ nöbö ñɨŋ i öbɨlön, mö aku nugwo “Nagö mönö kai mɨd?” rön yadölim. Jisas nugwo algör ör, “Pödpöd rɨmɨn mö aku pɨsaŋ mönö rɨb rɨb pɨmɨdlö?” rön yadölim. ");
INSERT INTO tmd_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Makwam mö aku, röbej aku röböxön, höbkal taun aku duön, nöbö mö mɨdim piaku ñɨgö yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Hön, ap piaku magalɨg rɨl akuyöbö yad nöl nöbö aku nugwi! Nuŋ Mesaia aku mönö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Aliö rɨmɨn, nöbö mö piaku taun aku röböxön, Jisas nugwo nuguŋö, rön, hömɨdmä. ");
INSERT INTO tmd_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Makwam Jisas nöbö nuŋ piaku Jisas nugwo yad gögö rön yadmä, “Mönö yad nölɨb nöbö. Ap nɨmö!” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Aliö rɨmɨn, nuŋ paiŋö yadöŋa, “Ap mag nɨmɨb na mɨd aku ñɨŋ nugwölöi,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Aliö rɨmɨn, nöbö nuŋ piaku ñɨŋ keir ör yad nugwob nugwob rön yadmä, “Nöbö mö bli nugwo ap mag rag hö nölöi ä?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Makwam Jisas ñɨgö yadöŋa, “Ñɨgö ap mag piaku rɨbyöx nugwöia; nɨ ap mag piaku rɨbyöx nugwöi. Acö mönö yadöŋ akwör rɨbyöx nugula aku, rɨb aku yöx nugwön, mabö yad aku rɨ pöcɨnö, rön, rɨbyöx nugula. Ap mag nɨmɨb na maku pal. ");
INSERT INTO tmd_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Makwam ñɨŋ mönö i yadöia, ‘Mɨlmej mös mös mɨdɨŋ, wit maga göj waŋ du ödör pön hönɨŋö,’ röi aku, jɨ weik aliö yadmɨjeñ. Mämäg ñɨŋa keir yöraku nugup padɨx gɨrön nugwi! Wit möriwö piaku mödö göj umɨn röx rag höb maga mɨda. ");
INSERT INTO tmd_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Makwam wopik ör, nöbö mö wit göja ödör pön hömɨdöi nöbö mö piaku, wahax pɨ gɨrön wit göj wä aku ödör pön du kömö öim mɨdɨb möl aku nɨgön, pe ñɨŋa pɨmɨdöi maku pal. Makwam, nöbö mö wit maga wölaŋ, me rön, pön du abmɨdöi piaku aipam, nöbö mö wit göj um ödör pön hömɨdöi piaku aipam nɨgiö nɨgön, wit göj aku kömö öim mɨdɨb möl aku mɨjön aku nugwön, mɨ wahax pöña. ");
INSERT INTO tmd_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","An mönö i yadöla, ‘Nöbö mö bli wit maga abɨŋ wöiöna, nöbö mö bli du ödör pön höñɨŋö,’ röl aku, mɨ ödöriö yadöla. ");
INSERT INTO tmd_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nɨ ñɨgö yad abmön, du wit ödör rag hömɨdöia. Wit möriwö aku ñɨŋ mabö kwockwoc palön rölöi; nöbö mö bli ölɨsö ñɨŋ akwör rɨm wöla. Ñɨŋ hör du ödör pön hön ap wä pɨmɨdöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mö Sameria yöbö aku du nöbö mö nuŋ akuyöbö ñɨgö yadöŋa, “Nöbö aku ap rɨg rɨl rɨl piaku magalɨg nɨ yad nölö,” röŋa nugwön, Sameria yöbö nöbö mö taun aku mɨdim piaku nöbö mö mɨga Jisas nugw pɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Makwam Sameria nöbö mö, Jisas mɨdöŋ yöra hön, Jisas yad gögö rön, an pɨsaŋ du mɨjnɨŋö, rɨmɨn, nuŋ wop mös ñɨŋ pɨsaŋ mɨdön, ");
INSERT INTO tmd_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","mönö yad nölmɨn, nöbö mö mɨga mönö aku nugwön nugwo nugw pɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ñɨŋ akuyöbö alön nugw pön, mö aku nugwo yadmä, “Weik mönö naŋ akwör yadman nugwön nugw pölöl; Jisas ajmöl nuŋwa keir yadmɨn nugwön nugwöla, nuŋwör nöbö mö mögörɨb il kɨ mɨdöi piaku piaku magalɨg ñɨgö kömö pɨba höŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jisas wop hogw aku mögörɨb aku mɨdön, löum mögörɨb Galili duöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Nuŋ höd mönö i yadön yadöŋa, “God mönö yadɨb nöbö bla, mögörɨb ñɨŋa keira mɨdön mönö yad nöiöñ aku, mönö ñɨgö aku nugw peñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pasopa wop aku Galili nöbö mö bli du Jerusalem mɨdmä. Ñɨŋ Jerusalem mɨdɨm nugugɨrön, Jisas ap rölɨbä piaku rɨmɨn nugwim makwam, Jisas wopik mögörɨb Galili uröpɨnmɨn, ñɨŋ ap rölɨbä akuyöbö Jerusalem röŋ aku rɨbyöx nugwön, nugwo wahax pɨ gɨrön yad pɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jisas du Galili mɨdön, höbkal Kena taun duöŋa. Kena taun aku mɨ, höd röbö yöbö aku rɨmɨn röbö wain röxgöŋa. Makwam taun ulmɨdö Kapaneam yöraku, nöbö dib i ha nuŋwa ap röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nöbö dib aku mönö i nugwöŋa, Jisas mögörɨb Judia röböxön, hö mögörɨb Galili mɨdöŋa. Makwam, Jisas mɨdöŋ yöra hön, nugwo yad gögö rön yadöŋa, “Ha nɨ aku ap rɨmɨn wöröxɨba rɨmɨda. Nagö yadkap du nugwo raŋ kömö nɨgaŋ!” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Aliö rɨmɨn, Jisas yadöŋa, “Ñɨŋ hör nɨ nugw peñɨm; ap rölɨbä akuyöbö bli rɨmön nugwön döŋö, nɨ nugw pöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Jisas aliö rɨmɨn, nöbö dib aku yadöŋa, “Nöbö Dib! Hö dinɨm! Nöi mɨjön aku, ha na wöröxönɨŋö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Aliö rɨmɨn, Jisas yadöŋa, “Duö! Ha naŋ aku kömö nɨgön mɨjönɨŋö,” röŋa. Jisas aliö rɨmɨn, nöbö aku, Jisas mi yadö, rön, duöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ödöi mibɨl yöra dumɨn nugugɨrön, mabö rɨ nölɨb nöbö nuŋ bli hö nugwo möigw palön yadmä, “Ha naŋ aku wöröxöl; mɨdö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Aliö rɨmɨdmɨn, ha na aku mag kaiyöbö kömö nɨg, rön, ñɨgö yad nugumɨn yadmä, “Idöm naiö pikwo röŋ mag aku, mɨxɨña rɨn abɨŋ aku kömö nɨgö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Aliö rɨmɨn, ha nuö nuŋ nugwöŋa, Jisas, “Ha naŋ aku kömö nɨgön mɨjönɨŋö,” röŋ mag akwör kömö nɨgöŋa. Makwam, nöbö mö nuŋ piaku pɨsaŋ magalɨg Jisas nugw pɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Makwam Jisas nuŋ höd Kena hön, ap rölɨbä agñɨŋ yöbö rön, röbö yöbö aku rɨmɨn röbö wain nɨgöŋa; mai piöŋö ap rölɨbä agñɨŋ rɨbyöbö aku rön, nöbö dib aku ha nuŋwa rɨmɨn kömö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Juda ada ap dib nɨmɨb wop aku wopik, me rön, Jisas Jerusalem duöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Taun dib Jerusalem, hön sipsip pön pikwo pik röi ödöi ubalɨj möla pedöx pedöxiö ban yuö dib i mɨda. Ban aku Arameik mönö nɨgön, Betesda, me röia. Ban rɨb rɨba ram bötö akuyöbö mömɨd sö mɨda. ");
INSERT INTO tmd_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Makwam nöbö mö ap röŋ akuyöbö mɨg mɨŋa hö ram bötö piaku hölɨmön mɨdmɨdöia. Nöbö mö adaku, bli mämäga we wölöŋa, bli yödpɨlö gwogwo rɨmɨn yönmɨdölöi, bli mɨxɨñ ñɨŋa mɨ aŋadö lɨd pɨlöŋa. Makwam ban yuö aku memexönɨŋönö, rön, hön hölɨmön mɨdmɨdöia. ");
INSERT INTO tmd_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Wop bli God ejol i hön ban yuö aku ruobmɨn, nöbö mö kai rɨmgör ban yuö höd pɨ dumɨd aku, nuŋ ap agap bɨlɨm rɨmɨd aku kömö nɨgmɨda. ");
INSERT INTO tmd_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Makwam nöbö i ap rɨmɨn, öim öim wöröx mɨdmɨn, kɨma yöniö padokwo padök paŋyöbö i höuöiliö hö pɨn du adokwebö mac kwo (38) pɨnöŋa, ban yuö pö yöra pön du nɨgɨm mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisas nöbö aku nugwön, mɨxɨl magi aliö mɨdmɨd aku nugwön, nugwo yadöŋa, “Naŋ kömö nɨgönɨŋö, rön, nugulö ä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Jisas aliö rɨmɨn, nöbö ap röŋ aku yadöŋa, “Nöbö dib. Ban yuö aku memexaŋ nugugɨrön, nɨ pɨ ban yuö bö pɨ nɨgɨb nöbö i mɨdöl. Nɨ ban yuö bö höd dinö, rɨl aku, jɨ nöbö mö bli ñɨŋ rɨmgör höd duöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Aliö rɨmɨn, Jisas paiŋö nugwo yadöŋa, “Öbɨlön, köp naŋ aku röd pön duö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jisas aliö rɨmɨn, mag akwör nugwo kömö nɨgmɨn nugugɨrön, öbɨlön köp nuŋ aku röd pön, pɨrag duöŋa. Makwam Jisas nöbö aku nugwo rɨmɨn kömö nɨgöŋ wop aku, Juda ada God höjöpalɨb wop ñɨŋa makwam, ");
INSERT INTO tmd_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Juda nöbö dib bla, nöbö kömö nɨgöŋ aku nugwo yadmä, “Wop kɨ God höjöpalɨb wop an. Makwam nagö köp pɨd nagö aku pɨrag yönmɨdlö aku, lo mönö an aku wöhö rö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Aliö rɨmɨn, yadöŋa, “Nöbö nɨ rɨmɨn kömö nɨg aku yada, ‘Öbɨlön, köp pɨd naŋ aku röd pön duö,’ rɨmɨn nugwön pön yönmɨdlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Aliö rɨmɨn, yadmä, “Nöbö nagö yadɨm, köp pɨda röd pön yönmɨdlö nöbö aku nöbö kai?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Makwam Jisas nuŋ nöbö mö mɨga mɨdim mibɨla tar duöŋ aku, kömö nɨgöŋ nöbö aku, “Nöbö nɨ rɨmɨn kömö nɨg nöbö mɨk,” me rön, yadɨbä maga nɨgölöŋ. ");
INSERT INTO tmd_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mai Jisas nuŋ nöbö aku God höjöpalɨb rama ram möl yuadö nugwön yadöŋa, “Mɨ! Nagö kömö nɨga. Makwam, ap kib mag gwogwo rɨmɨdlö aku röböxö. Nöi mɨjön aku, nagö mɨ ap diba rɨb maga rö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Makwam nöbö aku nuŋ höbkal duön, Juda nöbö dib akuyöbö ñɨgö yadöŋa, “Jisas nuŋwör nɨ rɨmɨn kömö nɨgö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jisas nuŋ God höjöpalɨb wop aku rɨmɨn nöbö mö kömö nɨgmɨd aku mɨ, Juda nöbö piaku ñɨŋ Jisas nugwo rɨb gwogwo yöx nugumä. ");
INSERT INTO tmd_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Makwam Jisas nuŋ ñɨgö yadöŋa, “Acö na öim mabö rɨ gör mɨd aku, nɨ algör paŋ mag akwör cɨnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jisas aliö rɨmɨn, Juda nöbö dib bla, höd nugwo pɨl pal nɨgɨŋö, rön, rɨbyöx nugumä aku, wopik mɨ ususör rɨ nugumä. Ñɨŋ yadmä, “Nuŋ God höjöpalɨb wop an aku röd abön, ‘Nɨ God Ha nuŋ,’ me ra. Makwam, God nuŋ rɨg mɨd mag akuyöbö, nɨ kwo paŋ mag akwör rɨg mɨdlö, rö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jisas piöŋö ñɨgö yadöŋa, “Ñɨgö mi yadmɨdla, Ha aku nuŋ hör ap i rɨb maga nɨgöl; Nuö cön ap piakwör nugwön cöna. Makwam, Nuö cön mag akuyöbö, Ha nuŋwa algör cöna. ");
INSERT INTO tmd_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nuö Ha nuŋwa nugwo madmag nɨgön, ap nuŋ rɨmɨd rɨmɨd piaku magalɨg yabumɨda. Ap bli kwo aipam yabuaŋ, Ha nuŋwa ap keiryöbö piaku raŋ nugwön ñɨŋ magalɨg aiö cöña. ");
INSERT INTO tmd_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Makwam Nuö nöbö mö wöröxöi piaku rɨmɨn öbɨlöi aku, Ha nuŋwa algör ör, nöbö mö bli, ñɨgö rɨmön öbɨlɨŋ, me cön aku, raŋ öbiöña. ");
INSERT INTO tmd_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nöbö mö agap apɨm röi, rɨb kai kai yöx nugwöi aku, Nuö nugwön ñɨgö mönö diba yaden; Ha nuŋwa nugwo yadaŋ, nuŋ ñɨgö magalɨg mönö diba yajöna. ");
INSERT INTO tmd_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Makwam, nöbö mö ñɨŋ Nuö ib nuŋwa yadɨŋ bɨl sö diön mag akuyöbö, Ha nuŋwa ib aku aipam algör ör yadɨŋ bɨl sö diöna. Makwam nöbö mö God Ha nuŋwa nugwön, ib nuŋwa yadɨŋ bɨl sö duen piaku, Nuö Ha nuŋwa yad aböŋ aku aipam algör ör iba yadɨŋ bɨl sö duen. ");
INSERT INTO tmd_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ñɨgö mi yadmɨdla, nöbö mö yön mönö nɨ aku nugwön, Nöbö nɨ yad abmɨn höm aku nugwo nugw pöi piaku, mönö diba yadön ölɨŋ höb pɨb adaku nugweñ; ñɨŋ kömö öim mɨdɨb mag aku mödö pöia. Makwam, ñɨŋ wöröxɨb ila aku röböxön, kömö öim mɨdɨb adaku mödö mɨdöia. ");
INSERT INTO tmd_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ñɨgö mɨ ödöriö yadmɨdla, wop mai öim pöx mɨdmɨdöi aku womiöx hömɨda – jɨ weik mödö hö mɨk – nöbö mö wöröxɨbi röxg mɨdöi piaku, God Ha nuŋwa mönö yadaŋ, mönö aku nugwön nugw pɨmɨjöñ piaku, kömö nɨgöña. ");
INSERT INTO tmd_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Acö ap bla magalɨg kömö mɨdɨb ila mɨd aku, nɨ Ha nuŋwa algör ör kömö mɨdɨb ila mɨdla. ");
INSERT INTO tmd_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Nɨ Nöbö Ha nuŋwa mɨdɨl makwam, Acö nɨ yadaŋ, nöbö mö akuyöbö ñɨgö mönö diba yadön döŋö mai nuöm nɨgna. ");
INSERT INTO tmd_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mönö yadmɨdɨl aku nugwön aiö rɨmɨjeñ: mai nɨ yadmön, nöbö mö wöröxɨm hogw pɨlöi piaku, ");
INSERT INTO tmd_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","magalɨg mönö na nugwön, öbɨlön, nöbö mö mag wä rɨ ri aböi piaku, du nɨ pɨsaŋ kömö mɨjöña; jɨ nöbö mö mag gwogwo röi piaku, öbɨlön mönö diba nugwön paiŋö ölɨŋ höb diba pɨmɨjöña. ");
INSERT INTO tmd_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Makwam nɨ ap agap apɨm rɨmɨjɨn piaku, keir nugwön röin; Acö na rɨg yajön mag akwör cɨna. Makwam, nöbö mö mönö diba yadön döŋö nuöm nɨgɨn aku, Acö rɨg yajön akwör nugwön, ödöriö akwör nuöm nɨgna. Aku agapɨm: nɨ wä cön adaku mönö diba yadöin. Nöbö nɨ yad abmɨn höm Nöbö aku nugwo wä cön adakwör rɨbyöx nugwön, mönö diba yadön döŋö mai nuöm nɨgna. ");
INSERT INTO tmd_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Nɨ keir, ‘God nɨ agal abmɨn hölö,’ rɨlɨx aku, mönö aku ödöriö mɨdölö röyɨxa. ");
INSERT INTO tmd_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Makwam Nöbö i kwo aipam nɨ nöbö pödiöm mɨdɨl aku yada. Nɨ nugula mönö yad aku mör yada. ");
INSERT INTO tmd_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ñɨŋ Juda ada nöbö ñɨŋ bli yad abɨŋ, ñɨŋ Jon nugwo duön, nɨ nöbö pödiöm mɨdlö, rön, yad nugwim aku, nuŋ paiŋö mönö ma akwör ñɨgö yadöŋ maku pal. ");
INSERT INTO tmd_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Jon mönö mögörɨb il kɨ nöbö i, nɨ nöbö pödiöm mɨdɨl aku yajön aku, nɨ ap dib yöi. Makwam ñɨŋ Jon mönö yadöŋ aku nugwön, mönö mɨ me rön nugw pön kömö diöñɨŋö, rön, Jon mönö nɨ aliö yadöŋ maku, me rön, yadmɨdla. ");
INSERT INTO tmd_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon mönö yadöŋ aku, nuŋ hötɨkö mila abmɨd mag akuyöbö mɨdmɨn, ñɨŋ mönö yadöŋ aku mil röxg nugwön, mag metyöbö ul mɨŋi wahax pɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Jon ñɨgö yad ri aböŋa, jɨ hör mönö akwör yadöŋa. Nɨ mögörɨb il kɨ hön, Acö nɨ rane, röŋ aku, ap keiryöbö rɨmɨdɨl makwam, ñɨŋ Acö nuŋwör nɨ yad ab aku, me rön, mɨ wöxnö nugwöyɨxa. ");
INSERT INTO tmd_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Acö nɨ yad aböŋ aku, nuŋ keir, nɨ nöbö pödiöm mɨdɨl aku, ñɨgö mönö mi yadmɨda. Makwam ñɨŋ ajmöl nuŋ aku audiöx nugwölöi. Nuŋ nöbö pödiöm mɨd aku, me rön, nugwölöi. ");
INSERT INTO tmd_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Acö nɨ yad aböŋ aku, jɨ ñɨŋ mönö na nugw pölöi makwam, God Mönö maga madmag ñɨgö yuö kwo mɨdöl. ");
INSERT INTO tmd_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","40","“Ñɨŋ, öim mɨdɨb maga pɨnɨŋö, rön, God Mönö aku mämäga nɨg nugw ri aböi aku, jɨ mönö aku, nɨ me rön kai kɨtim aku nugwön, öim mɨdɨb maga pɨnɨŋö, rön, nɨ hölöi. ");
INSERT INTO tmd_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Nöbö mö piaku ib na yadɨŋ bɨl sö duaŋ, me rön, yadmɨdöi. ");
INSERT INTO tmd_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Makwam ñɨŋ nöbö mö pödiö bɨlɨm mɨdöi aku mödö nugula. Ñɨŋ God nugwo madmag nɨgölöi aku nugwön yadmɨdla. ");
INSERT INTO tmd_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Acö nuŋ keir nɨ yad abmɨn höl aku, jɨ nɨ pölöi. Makwam nöbö hör i rɨb nuŋwa keir yöx nugwön hömɨdaŋ mönö, nugwo pöña. ");
INSERT INTO tmd_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nöbö mö piaku bli ib ñɨŋa yadɨŋ bɨl sö dumɨjön aku, ñɨgö wä cöna. God paŋyöbö akwör mɨd aku anɨŋ nugwaŋ wä raŋ, me rön, rɨb aku yöx nugwölöi. Makwam, ñɨŋ pödpöd rön nɨ nugw pöñ? ");
INSERT INTO tmd_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Acö mönö na pön, ñɨgö mönö diba yajönɨŋö, rön, rɨb aku yöx nugumɨjeñ, wöhö. Mosɨs anɨŋ rɨ nöiönɨŋö, röi aku, jɨ Acö nuŋ Mosɨs yadöŋ mönö aku pön ñɨgö mönö diba yajöna. ");
INSERT INTO tmd_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosɨs nuŋ God Mönö kai kɨtön mönö bli nɨ nöbö pödiöm mɨdɨl aku kai kɨtöŋa. Makwam, Mosɨs mönö kai kɨtöŋ mönö aku nugw pöyɨx aku, mönö nɨ yadmɨdɨl aku kwo algör pöyɨxa. ");
INSERT INTO tmd_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Makwam Mosɨs kai kɨtöŋ mönö pölöi aku, ñɨŋ pödpöd rön mönö nɨ yadmɨdɨl aku pöñ?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Makwam Jisas aliö mɨdön, mai röbö alebö pön, Ban Yuö Galili möxön, ir kwo duöŋa. Ban Yuö Galili akwör ib i Ban Yuö Taibirias me röia. ");
INSERT INTO tmd_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Makwam Jisas nuŋ nöbö mö ap röŋ piaku rɨmɨn kömö nɨgöŋ aku nugumɨdöi aku, nöbö mö mɨg mɨŋa nugwo mai dumä. ");
INSERT INTO tmd_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Makwam Jisas nöbö nuŋ bla pɨsaŋ du höñ aku pisö wöluön, pɨd sö römɨd gɨ mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Wop mibɨl piaku Juda ada Pasopa wop dib ñɨŋ aku womiöx igöp höŋa. ");
INSERT INTO tmd_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","6","Jisas nöbö nuŋ adö pɨsaŋ pɨd yöraku römɨd gɨ mɨdön, mämäga pisö riö nugumɨn, nöbö mö mɨga nugwo pöl hömɨdmä. Jisas nugwön, nuŋ agap apɨm cön aku keir nugwöŋ aku, jɨ nöbö nuŋ Pilip pöd yajönɨŋö, rön, nugwo yadöŋa, “An ap mag pikai yöbö pön, nöbö mö mɨg kɨyöbö ñɨgö nölɨŋ nɨmöñ?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Jisas aliö rɨmɨn, Pilip yadöŋa, “Rɨg silpa mag akuyöbö tu hadred (200) abön, bred wob pön hön, pɨ gɨlɨx ulul rön, nöbö mö pikyöbö nölmɨdɨŋ, magalɨg ap ulul nɨmɨbä maga cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Aliö rɨmɨn, nöbö nuŋwa Edru, Saimon Pita hödnɨŋ aku yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ha ulmɨdö i bred bali mag hauya pɨ uröi bred mag akuyöbö mömɨda, dölöm mös alɨg pɨ gɨ mɨd kɨ, nöbö mö mɨg aliö dib ap aku nöbö mö mɨg kɨyöbö ap mag dib yöi gö,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Aliö rɨmɨn, Jisas yadöŋa, “Nöbö mö piaku yadɨŋ, römɨdɨŋ,” me röŋa. Jisas aliö rɨmɨn, nöbö nuŋ piaku nöbö mö piaku yadmɨn, ap panö rol wä akuyöbö magalɨg rola römɨdmä. Nöbö piakwör, paip tausan (5000) akuyöbö duöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ñɨŋ akuyöbö alön römɨdmä nugwön, Jisas bred mag piaku pön, God nugwo ri ablaŋe rön, ñɨgö nuöm nɨg nölöŋa. Dölöm aku algör röŋa. Ñɨgö akuyöbö alön nuöm nɨgmɨn, nöbö mö piaku ñɨŋ magalɨg bred dölöm ap aliö pɨnɨŋö rön rɨbyöx nugwim mag akuyöbö akwör pɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Alön nɨmmɨdɨm nɨmmɨdɨm wöta bɨrmɨn rɨba röböxmä. Jisas nöbö nuŋ bla ñɨgö yadöŋa, “Nöbö mö ap nɨmön röböxöi bla, pɨmag pikwo pik rɨmɨjeñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Jisas aliö rɨmɨn, nöbö nuŋ piaku bred rɨb rɨb piaku hölu yogw piöxmɨn piöxmɨn, yogw akuyöbö möl sö bla aja wölöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nöbö mö akuyöbö Jisas ap rölɨbä akuyöbö röŋ aku nugwön yadmä, “An weik nugwöla, nöbö kɨ mɨ, God Mönö Yadɨb Nöbö mögörɨb il kɨ hönɨŋö rön öim yadmɨdöl nöbö aku mɨk pal,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nöbö mö bla, Jisas kiŋ ana mɨjönɨŋö, rön, nugwo usus rɨ pön dinɨŋö, rön, rɨbyöx nugwim aku, Jisas nuŋ keir nugwön, höuöil du pɨd piaku nuŋwör mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Makwam pɨgöŋ mag aku, Jisas nöbö nuŋ akuyöbö Ban Yuö Galili duön nugumɨn, ");
INSERT INTO tmd_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Jisas hölöŋa nugwön, pɨxmag gurɨm, ñɨŋör röbö alebö pön höuöil taun ulmɨdö Kapaneam duba dumä. ");
INSERT INTO tmd_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Dumɨdmɨn nugugɨrön, hödal diba höm, röbö wödöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Makwam ñɨŋ uplöb röbö alebö röbö panö yaxɨp mibɨl kwo kilomita akuyöbö mömɨd aku mönö iŋösu sö duön nugumɨn, Jisas röbö rola röbɨp hömɨdöŋa. Ñɨŋ nugumɨn madmaga duöŋa nugwön ipöxmä. ");
INSERT INTO tmd_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jɨ Jisas yadöŋa, “Ñɨŋ ipöxmɨjeñ. Nör hömɨdlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Jisas aliö rɨmɨn, ñɨŋ ipöxölim; nugwo pɨ röbö alebö möl aku nɨgɨm nugugɨrön, röbö alebö aku wop akwör rɨmgör mögörɨb duba rim möl aku uröpɨnön duöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Löum yöbö nöbö mö Ban Yuö Galili pö kwo hölɨmɨmä akuyöbö rɨbyöx nugwön nugumä, idöm pɨgöbiö röbö alebö paŋyöbö iör mɨdöŋa nugwön Jisas nöbö nuŋ piakwör röbö alebö aku dumä; Jisas nuŋ keir röbö alebö aku duölöŋ. ");
INSERT INTO tmd_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mɨdmɨn nugugɨrön, röbö alebö bli nöbö mö bli taun dib Taibirias yöbö hön, Nöbö Diba nuŋ God nugwo ri ablaŋe rön ap nölmɨn nɨmim kau aku röbö pö yöra gö nɨgmä. ");
INSERT INTO tmd_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Makwam nöbö mö mɨdim akuyöbö nugumɨn, Jisas aipam nöbö nuŋ bla aipam mɨdölim; aku Jisas nugwo hölu nuguŋö, rön, ñɨŋ röbö alebö piaku duön Kapaneam dumä. ");
INSERT INTO tmd_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ban Yuö Galili dumɨd dumɨd pö kwo uröpɨnön, Jisas nugwo nugwön yadmä, “Mönö yad nölɨb nöbö. Nagö mag kai kɨ hölö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Aliö rɨmɨn, Jisas yadöŋa, “Ñɨgö mönö mi yadmɨdla, bred nölmön nɨmɨm wöt bɨröŋ makwam, nɨ hölup yönmɨdöia; makwam ap rölɨbä akuyöbö rɨl piaku mönö il aku nugwön nɨ hölup yönmɨdölöi. ");
INSERT INTO tmd_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ap maga lɨduba rɨmɨd aku pɨnɨŋö, rön, mabö ususör rɨmɨjeñ; God nuŋ Nöbö Ha nuŋwa nugwogwo yadmɨn ha aku, ap mag öim mɨdɨb nuŋ nöiön aku pɨnɨŋö, rön, mabö ususör cɨne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Jisas aliö rɨmɨn, yadmä, “An mabö kai rɨŋ, God nugwo wä cön?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Aliö rɨmɨn, Jisas yadöŋa, “God nuŋ Nöbö abmɨn höŋ aku, Nöbö aku nugwo nugw pöñ aku, God nugwo wä cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Jisas aliö rɨmɨn, yadmä, “An ap rölɨbä akuyöbö i nugunɨŋ aku, yajnɨŋa, ‘God ör nagö yad abö,’ rön, nagö nugw pɨnɨŋa. Makwam, anɨŋ ap rölɨbä kaiyöbö cɨnö? ");
INSERT INTO tmd_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Maduar ör nöso auso nöbö mögörɨb rɨg kap mibɨl piaku mɨdön, ap mana aku nɨmmɨdöia. God Mönö kai kɨtön yadmä, ‘Nuŋ bred adöx yöd röul adö kau sebö bli ñɨgö nölmɨn nɨmmɨdöiŋö,’ röiŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Aliö yadim aku, jɨ Jisas ñɨgö paiŋö yadöŋa, “Ñɨgö mönö mɨ ödöriö yadmɨdla, Mosɨs maduar ör bred ñɨgö nölmɨn nɨmim bred aku, bred adöx yöd röul adö kau sebö yöi. Bred adöx yöd röul adö kau sebö bred ödöriö aku, Acö na ñɨgö nölmɨda. ");
INSERT INTO tmd_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","God bred nuŋ aku, God yad abmɨn, adöx yöd röul adö kau sebö mögörɨb il kɨ hön, nöbö mö bla ñɨgö kömö mɨdɨb maga nölmɨdö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Jisas aliö rɨmɨn, yadmä, “Nöbö Dib. Wopik bred aku anɨŋ öim öim nöl gör mɨdane,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Aliö rɨmɨn, Jisas yadöŋa, “Nör bred kömö mɨdɨb aku. Nöbö mö nɨ höñ akuyöbö, ñɨgö iswob kiö pɨlen. Nöbö mö nɨ nugw pɨmɨjöñ akuyöbö, ñɨgö iswob röbö sɨpösɨpö ren. ");
INSERT INTO tmd_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Makwam ñɨgö maduö yad nöil aku, nɨ mämäga nugwöi aku, jɨ nɨ nugw pölöi. ");
INSERT INTO tmd_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Acö na yad nöbö mö akuyöbö ñɨŋ magalɨg nɨ höña. Nöbö mö nɨ höñ akuyöbö, nɨ ñɨŋ yad aböin, mɨ wöhö. ");
INSERT INTO tmd_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Aku agapɨm: nɨ adöx yöd röul adö kau sebö höl aku, rɨb nɨ yöx nugul adakwör cɨnö, rön, höi; Acö nɨ agal aböŋ aku, nɨ rɨb nuŋwa rɨg yöx nugw akwör nugwön, rɨg yad mag akwör cɨnö, rön, höla. ");
INSERT INTO tmd_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Acö nöbö mö nɨ yad akuyöbö ñɨgö nugugu mɨdmön, i yöm renɨm; mönö diba yadɨb wop aku, nɨ rɨmön, ñɨŋ magalɨg öbiöña. Aiön aku, Acö nɨ yad aböŋ Nöbö aku, nugwo wä cöna. ");
INSERT INTO tmd_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Acö na nugwo wä cön aku, nöbö mö kai kai nɨ nugwön nugw pöñ akuyöbö, ñɨŋ magalɨg öim öim kömö mɨjöña. Makwam mönö diba yadɨb wop aku, nɨ keir rɨmön ñɨŋ magalɨg öbiöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Makwam Jisas, “Nɨ keir, bred adöx yöd röul adö kau sebö höl aku,” me röŋ aku mɨ, Juda nöbö mö akuyöbö hamal pɨxön mönö nɨgmä. ");
INSERT INTO tmd_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Juda nöbö mö akuyöbö hamal pɨxön yadmä, “Nöbö kɨ, nuö nuöm nuŋwa an keir nugwöla. Nuŋ Josep ha nuŋwa Jisas ör. Makwam, nuŋ pödpöd rɨmɨn yad, ‘Nɨ adöx yöd röul adö kau sebö hölö,’ rö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Aliö rɨmɨdmɨn, Jisas paiŋö yadöŋa, “Hamal pɨxmɨjeñ. ");
INSERT INTO tmd_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nöbö mö i nuŋ keir nɨ nugw pen. God nugwo rɨb wä nölaŋ mönö, nɨ haŋ, mönö diba yadɨb wop maiyöbö aku nɨ rɨmön nuŋ höbkal öbiöna. ");
INSERT INTO tmd_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nöbö God mönö yadɨb nöbö bla ñɨŋ God Mönö kai kɨtön yadmä, ‘God nuŋ nöbö mö piaku magalɨg ñɨgö yad nöiönɨŋö,’ rɨmä. Nöbö mö Acö ñɨgö mönö yad nölaŋ aku nugw pöñ piaku, ñɨŋ magalɨg nɨ höña. ");
INSERT INTO tmd_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nöbö mö bli ñɨŋ God nugwo mämäga nugwölöi; nɨ Nöbö nuŋ abmɨn höm akwör mämäga na Acö nugula. ");
INSERT INTO tmd_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Makwam nɨ ñɨgö mi yadmɨdla, nöbö mö nɨ nugw pöñ piaku, öim mɨdɨb mag aku mödö pön, öim öim mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Bred nɨmön kömö mɨjöñ aku, nɨ keir bred aku. ");
INSERT INTO tmd_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nöhönɨŋ maduebö nöbö maduar ör mögörɨb rɨg kap mibɨl piaku mɨdön, ap mana nɨmim aku, jɨ mɨdɨp duön wöröxmä. ");
INSERT INTO tmd_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Makwam bred Acö yad abmɨn adöx yöd röul adö kau sebö hö bred aku, nöbö mö nɨmön, kömö öim öim mɨdön wöröxeñ. ");
INSERT INTO tmd_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","“Nɨ keir bred kömö adöx yöd röul adö kau sebö höl aku. Nöbö mö kai kai bred kɨ nɨm yuö bö nɨgöñ aku, öim öim kömö mɨjöña. Bred yadmɨdɨl kɨ mɨxɨñ nɨ aku pal. Nöbö mö mögörɨb il kɨ öim öim kömö mɨdɨŋ, me rön, mɨxɨñ nɨ aku nöinö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jisas aliö rɨmɨdmɨn, Juda nöbö mö adaku ñɨŋ keir mönö nuö nuö yadön, bli yadmä, “Nöbö kɨ agö magɨm raŋ, anɨŋ mɨxɨñ nuŋ aku nölaŋ nɨmɨnɨŋ?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Aliö rɨmɨdmɨn, Jisas ñɨgö yadöŋa, “Nɨ ñɨgö mɨ ödöriö yadmɨdla, ñɨŋ Nöbö Ha nuŋwa mɨxɨñ nuŋwa, haña nuŋwa nɨmeñ aku, kömö mɨdɨb mag aku yuö ñɨŋ kwo mɨden. ");
INSERT INTO tmd_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nöbö mö kai mɨxɨñ na, hañ na nɨmön aku, nuŋ kömö öim mɨdɨb mag aku mödö pa nugwön mönö diba yadɨb wop aku nɨ rɨmön nuŋ höbkal öbiöna. ");
INSERT INTO tmd_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","“Aku agapɨm: mɨxɨñ na aku ap nɨmɨb yöbö; hañ na aku röbö nɨmɨb yöbö. ");
INSERT INTO tmd_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nöbö mö bɨl kai mɨxɨñ na hañ na nɨmöñ bla, yuö nɨ kwo mɨdɨŋ, nɨ yuö ñɨŋ kwo mɨjɨna. ");
INSERT INTO tmd_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Acö öim öim kömö mɨd Nöbö aku, nuŋ nɨ agal aböŋ aku, nɨ rɨmɨn kömö mɨdɨl makwam, nöbö mö nɨ pɨ yuö ñɨŋ kwo nɨgöñ akuyöbö, ñɨgö algör ör raŋ, kömö mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Mönö adaku maku, bred adöx yöd röul adö kau sebö hö, rɨla. Bred aku, nöso auso nöbö ap mana aku nɨmön mɨdɨp duön wöröxim akuyöbö yöi; nöbö mö bred nɨ yadɨl aku nɨm yuö bö nɨgöñ aku, kömö öim öim mɨjöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisas Juda mögum rɨb ram Kapaneam yöraku mɨdön, mönö aku yadɨm, ");
INSERT INTO tmd_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","nöbö mö nuŋ bla mɨg mɨŋa nugwön yadmä, “Jisas mönö yadmɨd aku mönö ölɨsö ödöriö. Mönö nuŋwa nugw pön rɨbä nɨgölö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ñɨŋ hamal gigu rön yadmɨdmä, Jisas nuŋ keir nugwön yadöŋa, “Mönö yadɨl aku nugwön rɨb mɨga yöxön röböxnɨŋö, rɨ rɨbyöx nugwöi ä? ");
INSERT INTO tmd_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Aku Nöbö Ha nuŋwa adöx yöd röul adö kau sö mɨdön höŋ aku, nuŋ kau aku höuöil dumɨjön aku, ñɨŋ rɨb pödiöm yöx nugwöñ? ");
INSERT INTO tmd_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","God Inöma kömö mɨdɨb mag aku nölaŋ, nöbö mö kömö nɨgöña; nöbö mö ölɨsö ñɨŋa keir kömö nɨgeñɨm, mɨ wöhö. Nɨ mönö ñɨgö yadɨl aku, mönö aku raŋ, God Inöma ñɨgö hön, kömö mɨdɨb mag aku ñɨgö nölaŋ nugwön ñɨŋ kömö nɨgöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Makwam Jisas nuŋ höd nöbö mö bɨl kai nugwo nugw pöñ, nöbö mö bɨl kai nugwo höuöu cöñ aku nugwöŋ makwam, nuŋ yadöŋa, “Ñɨŋ bli nɨ nugw pölöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Makwam mönö bli kwo yadön yadöŋa, “Paŋ adakwör ñɨgö yadla, nöbö mö i rɨb nuŋwa keir yöx nugwön nɨ nugw pen; Acö nagö rɨmɨdaŋ aku mɨ, nöbö mö i nɨ hön nɨ nugw pönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jisas mönö aku yad pörmɨn nugugɨrön, nöbö mö hön mönö nugwo nugumɨdöi akuyöbö, nöbö mö mɨga nugwo röböxön yau dumä. ");
INSERT INTO tmd_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Alön dum nugugɨrön, Jisas nöbö nuŋ möl sö piaku ñɨgö yad nugwön yadöŋa, “Ñɨŋ algör nɨ röböx diöñɨŋönö ä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Jisas aliö rɨmɨn, Saimon Pita yadöŋa, “Nöbö Dib. Yönɨm nugwo duŋ? Mönö nagö yadmɨdlö aku nugwön aku, öim öim kömö mɨjnɨŋ. ");
INSERT INTO tmd_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Anör nugw pöl aku, an nugwöla, God nuŋ Nöbö Leia anɨŋ ab aku, nagö Nöbö aku maku, me rön nugwölɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","71","Saimon Pita aliö rɨmɨn, Jisas paiŋö Saimon Iskariot ha nuŋwa Judas aku, mai nugwo mönömɨm cön aku nugwön, ñɨgö yadöŋa, “Nɨ ñɨgö nöbö akuyöbö möl sö pɨl aku, jɨ nöbö ñɨŋ paŋyöbö i kɨjaki nöbö nuŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Mai piöŋö Juda nöbö dib bla Jisas nugwo pɨl pal nɨgɨba rɨmɨdim aku nugwön Jisas mögörɨb Judia piaku yönmɨdöl; mögörɨb Galili piakwör yönmɨda. ");
INSERT INTO tmd_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Makwam Juda wop dib ñɨŋa, ram bötö ulmɨdö urön wop bli hölɨmmɨdöi wop aku igöp igöp höŋa nugwön, ");
INSERT INTO tmd_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jisas pɨgnɨŋ nöbö piaku Jisas mɨdöŋ yöra hön nugwo yadmä, “Nagö möl kɨ röböxön mögörɨb Judia duön, nöbö mö mönö nagö nugw pöi piaku ñɨgö ap rölɨbä rɨlö akuyöbö raŋ nugwöña. ");
INSERT INTO tmd_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nöbö ñɨŋ nöbö diba mɨdɨba rɨmɨjöñ akuyöbö, ap ñɨŋ bla umadeñɨm; wöxnö cöña. Makwam, nagö ap keiryöbö ödöriö rɨlö aku, nöbö mö mɨga mɨdöi mibɨl yöraku ap rölɨbä bli raŋ, nöbö mö magalɨg nugwöñɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Makwam Jisas pɨgnɨŋ nöbö nuŋ bla keir nugwo nugw pölim. ");
INSERT INTO tmd_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Aliö rɨmɨdmɨn, Jisas paiŋö ñɨgö yadöŋa, “Ñɨŋ wop kai dinöb cöñ aku diöña; jɨ nɨ dub wop aku höl makwam nɨ wopik duöin. ");
INSERT INTO tmd_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nöbö mö mögörɨb il kɨyöbö, ñɨgö nöbö rɨb gwogwo yöx nugub il i mɨdöl. Makwam nɨ nöbö mö mögörɨb il kɨyöbö ap kib mag gwogwo röi aku yad wöxnö nɨgmön, nɨ rɨb gwogwo yöx nugwöia. ");
INSERT INTO tmd_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Makwam, Ram Bötö wop diba womiöx hömɨd aku, ñɨŋ Jerusalem di; jɨ nɨ dub wop aku höl makwam nɨ pɨsaŋ duöinö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jisas aliö rön, nuŋ mögörɨb Galili mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Makwam Jisas pɨgnɨŋ nöbö bla Jerusalem dumä nugwön Jisas nuŋ tar mai duöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Juda nöbö dib bla, “Jisas mɨkai owa?” rön, nöbö mö mɨg mɨŋa hö mɨdim akuyöbö ñɨgö yad nugumä. ");
INSERT INTO tmd_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Makwam nöbö mö hör akuyöbö, Jisas mönö aku ñɨŋ keir yad nugwob nugwob rön, bli yadmä, “Nuŋ nöbö wä mɨdö,” me rɨmä; bli piöŋö yadmä, “Ehöu, nuŋ nöbö mö akuyöbö ñɨgö mönö inakmönö hör yad nöl yönmɨd nöbö,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Makwam nöbö mö hör bla, Juda nöbö dib piaku ipöxmä aku, ñɨŋ mönö bli wöxnö yadölim. ");
INSERT INTO tmd_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ram Bötö wop dib ñɨŋ aku wop bli padɨxöŋa. Hör wop mɨdö iör mɨdmɨn, Jisas höröpɨnön, God höjöpalɨb rama duön, nöbö mö akuyöbö ñɨgö mönö yad nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jisas mönö yad nöl mɨdmɨn nugugɨrön, Juda nöbö dib bla aiö rön yadmä, “Nöbö kɨ skul pölöŋ makwam, pödpödiö mönö piaku magalɨg nugwö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Aliö rɨmɨdmɨn, Jisas yadöŋa, “Mönö nɨ yad nölmɨdɨl aku, rɨb na keir yöx nugwön yad nölmɨdöi; Nöbö nɨ yad abmɨn höm akwör nɨ rɨba nölmɨn yad nölmɨdla. ");
INSERT INTO tmd_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nöbö mö yön, God rɨg yad mag akwör cɨnö, rön, rɨp diön aku, God nuŋ mönö nɨ nölmɨd aku yadmɨdɨl aimönö mönö nɨ keir yadmɨdɨl aku, nugwöna. ");
INSERT INTO tmd_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ñɨŋ nugwöia, nöbö mö yön mönö nuŋwa keir yajön aku, ib na wöluaŋ, me rön, hör mönö piaku piaku pön yajöna. Makwam nöbö mö yön nuŋ Nöbö nuŋwa yad aböŋ ib nuŋwa akwör wöluaŋ, me rön rɨbyöx nugwön aku, nöbö aku nöbö ödöriö mönö mɨ akwör yadmɨda; nuŋ mönö inakmönö bli hörmɨdöl. ");
INSERT INTO tmd_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosɨs, God rɨg yadöŋ yadöŋ akwör ñɨgö lo mönö yad nölöŋ aku, jɨ lo ada piaku ñɨŋ magalɨg mai duölöi. Jɨ nɨ mönö i mɨdöl wöhö, nɨ hör pɨl pal nɨgɨba rɨmɨdöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jisas aliö rɨmɨn, nöbö mö hö mɨdim akuyöbö yadmä, “Nagö yön pɨl pal nɨgɨba rɨmɨd? Nagö ragwo asa yuö wölmɨn yadmɨdlanö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Aliö rɨmɨn, Jisas yadöŋa, “Nɨ ap rölɨbä paŋyöbö i rɨmön, ñɨŋ magalɨg aiö waiö rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","23","Ñɨŋ Mosɨs God lo mönö rɨg yadöŋ mag akuyöbö, ha ñɨŋ bla yöx pön hön, wop akuyöbö mɨj sö mɨdön, löuaŋ amñaxɨb wop aku rɨl uñ ödöröia. Alöi mag aku, Mosɨs nuŋ wöhö, nöhönɨŋ maduebö nöbö höd ila nɨgön rɨg rɨmɨdöi mag akuyöbö mai duön alöia. Makwam uñ ödörɨb wop amñaxɨb aku, wop bli God höjöpalɨb wop akwör nɨgöna, makwam weik God höjöpalɨb wop aku, me rön, röböxölöi; amɨn uñ ödöröia. Alöi mag akuyöbö, nɨ God höjöpalɨb wop aku nöbö i nugwo rɨmön, mɨxɨñ magalɨg kömö nɨgöŋ aku, ñɨŋ pöd rɨmɨn nɨ nugumɨn ölɨsö wöl? ");
INSERT INTO tmd_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Makwam, mai mönö rolrol sö nugwön yadmɨjeñ; ödöriar mɨjön mag akwör nugw ri abön yajne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalem nöbö mö bli yadmä, “Juda nöbö dib bla nöbö pɨl pal nɨgɨba rɨmɨdöi nöbö aku mɨk mönö ä? ");
INSERT INTO tmd_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Makwam nugwi! Nuŋ nöbö mö mibɨl dib kɨ mönö yadmɨn nugugɨrön ñɨŋ nugwo mönö i yadmɨdölöi. Makwam, ñɨŋör keir nugwöia nuŋ Krais ödöriö mɨdɨb maga ra! ");
INSERT INTO tmd_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Jɨ Krais nuŋ höx aku, an nuŋ mögörɨb pikai yöbö hö aku nugwölölɨx; jɨ nöbö kɨ nuŋ mögörɨb pikai yöbö hö aku an magalɨg nugwöla. Makwam nuŋ Krais yöi,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","29","Makwam Jisas nuŋ God höjöpalɨb rama ram möl yuadö mönö yad nöl gör mɨdön, ajmöl aj halön yadöŋa, “Ñɨŋ rɨbyöx nugwöia, ñɨŋ nɨ nugw ri abön, pikai yöbö höm aku nugwöia. Aku yöi wöhö. Rɨb na keir yöx nugwön hölɨm. Nöbö nɨ yad abmɨn höm Nöbö aku nuŋ Nöbö ödöriö, Nöbö mönö mɨ akwör yadmɨd Nöbö. Nɨ nuŋ pɨsaŋ mɨdön, nɨ yad abmɨn höm aku, nugwo nugula; jɨ ñɨŋ nugwo nugwölöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jisas aliö rɨmɨn, nugwo pɨ cɨcɨ nɨgnɨŋö, rön, nugwim aku, jɨ wop nuŋwa hölöŋ, nöbö i nugwo pɨ cɨcɨ nɨgölöŋ. ");
INSERT INTO tmd_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Makwam nöbö mö piaku, nöbö mö mɨg mɨŋa Jisas ap rölɨbä akuyöbö röŋa nugwön yadmä, “Krais mai hönɨŋö röi aku, jɨ ap rölɨbä mɨga akwör rön, nöbö kɨ rɨg rɨmɨd mag akuyöbö rɨb maga nɨgenɨŋö,” rɨmä. Rɨb aku yöx nugwön ñɨŋ yadmä, “Jisas nuŋ Krais akwör,” me rön, nugwo nugw pɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Makwam nöbö mö akuyöbö ñɨŋ mönö aku algön nör yadmɨdmä nugwön, Perisi nöbö dib bla aipam, God ap höjöpal ur nölɨb nöbö dib bla aipam, Jisas nugwo du pɨ cɨcɨ nɨgön pön höŋ, me rön, God höjöpalɨb rama nugwidɨx mɨdmɨdöi ömdö nöbö bli yad abmä. ");
INSERT INTO tmd_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jisas nuŋ yadöŋa, “Nɨ mag ul mɨŋi ñɨgö pɨsaŋ mɨdön, Nöbö nɨ agal abmɨn höm aku mɨdɨba höbkal dina. ");
INSERT INTO tmd_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nɨ pikai duö, rön, hölumɨjöñ aku, jɨ nɨ nugweñ. Nɨ dina adaku, ñɨŋ mai ub maga nɨgenɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jisas aliö rɨmɨdmɨn, Juda nöbö dib bla ñɨŋ keir yadmä, “Nuŋ pikai duaŋ an nugwo nugwöinɨŋ? Nuŋ du Juda nöbö mö röd du Grik nöbö mö pɨsaŋ mɨdöi akuyöbö duön, nöbö mö piaku ñɨgö mönö yad nöl gɨr mɨjönɨŋönö pödpöd cön? ");
INSERT INTO tmd_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Makwam nuŋ pöd rɨmɨn yad, ‘Nɨ pikai duö, rön, hölumɨjöñ aku, jɨ nɨ nugweñ. Nɨ dina adaku, ñɨŋ mai ub maga nɨgenɨŋö,’ rö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Juda Ram Bötö wop dib ñɨŋ aku wop bli padɨxmɨn nugwön laŋ dub wop, me rön, mɨ wop dib aku Jisas öbɨlön, ajmöla aj halön yadöŋa, “Nöbö mö yönɨm iröpa wödö wöiön aku, nɨ hön röbö nɨmaŋ. ");
INSERT INTO tmd_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nöbö mö kai nɨ nugw pön aku, God Mönö rɨg yad akuyöbö, röbö kömö mɨdɨb aku yuö nugwebö ilam möla rödön umɨjönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Wop aku Jisas wöröxön öbɨlön Nuö mɨdɨba duölöŋ mag aku, Jisas nuŋ Inöma nöbö mö bla ñɨgö nölölöŋ. Makwam röbö ilam möla rödön hönɨŋö, rön, yadöŋ mönö aku ila alɨg mɨda: nöbö mö Jisas nugw pöñ akuyöbö, Jisas nuŋ ñɨgö Inöma nöiönɨŋö, rön, yadöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jisas aliö rɨmɨn, nöbö mö mɨga akwör mɨdmä akuyöbö, bli mönö yadöŋ aku nugwön yadmä, “Nöbö kɨ, nuŋ God Mönö yadɨb nöbö hönɨŋö, rön, pöx mɨdmɨdöl nöbö akwör,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bli yadmä, “Ehöu, nuŋ Krais aku!” me rɨmä. Aliö rɨmɨdmɨn, bli piöŋö yadmä, “Ehöu, Jisas nuŋ nöbö Galili yöbö; nöbö Krais aku nuŋ Galili yöbö hen! ");
INSERT INTO tmd_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","God Mönö aku rɨg yad akuyöbö, Krais aku, Depid yöxɨm yöxɨŋ yöxɨp höuöilmel rön, Krais aku Depid taun nuŋwa Betlehem yöraku yöx pön höñɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jisas mönö aku yadmɨdmɨn nugwön, nöbö mö mɨga mɨdim piaku lɨbak hörɨrör nɨgmä. ");
INSERT INTO tmd_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bli nugwo pɨ cɨcɨ nɨgön pön du mönö diba yadɨba pön duŋö, rɨmä aku, jɨ nöbö paŋyöbö i nugwo pölöŋ. ");
INSERT INTO tmd_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Makwam God höjöpalɨb rama nugwidɨx mɨdmɨdöi ömdö nöbö bla höuöil dumɨn nugugɨrön, God ap höjöpal ur nölɨb nöbö dib bla aipam, Perisi nöbö bla aipam ñɨgö yadyöxön yadmä, “Nöbö aku nugwo pödpöd rɨmɨn pön hölöiŋö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Aliö rɨmɨn, God höjöpalɨb rama ömdö nöbö piaku yadmä, “Nöbö mö piaku bli, nöbö aku mönö wä mɨda rɨg yadmɨd mag akuyöbö yadölöiŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Aliö rɨmɨdmɨn, Perisi nöbö bla paiŋö yadmä, “Inakmönö hör nöbö aku, nöbö mö bli ñɨŋ nuŋ mi yadö, rön nugwöi aku, ñɨgö kwo algör ör nugwöiŋönö ä? ");
INSERT INTO tmd_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","An nöbö dib ada nöbö i mönö Perisi nöbö i Jisas nugw pölöl. ");
INSERT INTO tmd_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nöbö mö kɨyöbö ñɨŋ lo mönö aku nugwölöi makwam, God ñɨgö rɨb gwogwo yöxön mɨ rɨ gwogwam cönɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Makwam nöbö ñɨŋ Nikodimas, nöbö aku nuŋ höd pɨxmag yuö bö duön, Jisas nugwo mönö bli yad nugwöŋ nöbö aku nuŋ ñɨgö yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“An Juda lo rol aku, nöbö i nugwo hör ölɨŋ höb pɨ nölön rɨ gwogwam röinɨŋö; mönö diba yadön mönö ila hölu nugwön döŋö, mai mag aliö akuyöbö cɨnɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Aliö rɨmɨn, yadmä, “Nagö kwo algör Galili yöbö ä? God Mönö aku mämäga nɨg nugup duön nugunö, God mönö yadɨb nöbö i Galili yöbö henɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Aliö rön, ñɨŋ röböxön yau ram ñɨŋ bla hörɨrör dumä. ");
INSERT INTO tmd_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jisas nuŋ Olip Pɨda duöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Löum yöbö ruö löu mil pörɨm hö nɨgöŋa nugwön, Jisas nuŋ iswob God höjöpalɨb rama höm, nöbö mö magöri maga rɨp hö nugwo wob yuö nɨgmɨdɨm nugwön nuŋ römɨd gɨ mɨdön, ñɨgö mönö maga yad nölmɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Jisas aliö mönö yad nölmɨdmɨn nugugɨrön, lo mönö yad nölɨb nöbö bla bli nɨgön, Perisi nöbö bli nɨgön, ñɨŋ mö i du nöbö i pɨsaŋ yönmɨdöŋ, mö aku nugwo pön hö nöbö mö mɨdim mämäg il rola öbɨl nölön, ");
INSERT INTO tmd_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jisas nugwo yadmä, “Mönö yad nölɨb nöbö. Mö kɨ nöbö kap mö jɨ nöbö hör i pɨsaŋ yönmɨdɨm nugwön pön höl mɨk. ");
INSERT INTO tmd_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosɨs lo anɨŋ nölöŋ aku yadöŋa, ‘Aiöñ mö piakuyöbö, rɨg röd pal nɨgɨŋ wöröxɨŋ,’ me röŋa. Makwam nagö pödi yajnaŋö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ñɨŋ inakmönö hörön yadim aku, an inag inag aliö yadɨŋ Jisas pödi yadaŋ, nugwo mönö diba yadɨŋö, rön, yadmä. Makwam Jisas nuŋ iröpa ubɨlön, haui rol bö imaga mönö mag bli kɨt gɨr mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Makwam ñɨŋ Jisas nugwo mönö akuyöbö yad nugumɨdɨm, nuŋ höglöma mɨrɨxön ñɨgö yadöŋa, “Nöbö ap kib mag gwogwo röl i mɨjön aku, rɨg röd mö kɨ höd palaŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Aliö rön iswob ubɨlön, mɨgrö bö mönö mag bli kɨt mɨdɨm nugugɨrön, ");
INSERT INTO tmd_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","nöbö Jisas nugwo mönö diba yajnɨŋö, rim piaku, Jisas mönö yadöŋ aku nugwön, nöbö dib dib röböx dumɨn nugwön nöbö piaku magalɨg paŋ paŋ röböxön hörɨrör du pörmä; Jisas nuŋwör mö aku pɨsaŋ mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jisas nuŋ höglöma mɨrɨxön mö aku nugwo yadöŋa, “Nöbö pia mɨkai? Nöbö nagö mönö diba yadɨbä i mɨdöl ä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Jisas aliö rɨmɨn, mö aku yadöŋa, “Nöbö Dib. Nöbö nɨ mönö diba yadɨbä i mɨdölö,” röŋa. Aliö rɨmɨn, Jisas yadöŋa, “Nɨ algör ör nagö mönö diba yadöin. Makwam ap kib mag gwogwo rɨmɨdlö aku mai rɨmɨjɨnö; wopik naŋ duö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisas mönö i nöbö mö akuyöbö ñɨgö iswob yadön yadöŋa, “Nöbö mö mögörɨb il kɨ mɨdöi akuyöbö, nɨ mil ñɨŋa mɨdla. Nöbö mö bɨl kai nɨ mai yönmɨjön aku, pɨxmag yuö yönmɨden; kömö öim mɨdɨb mil mag wä aku pön yönmɨjönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Jisas aliö rɨmɨn, Perisi nöbö bla nugwo yadmä, “Mönö naŋ keir yad nöilö aku, an nugumɨn mönö aku pɨba nɨgölö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Aliö rɨmɨn, Jisas yadöŋa, “Mönö aku nɨ keir yadmɨdɨl aku, jɨ mönö mi yadmɨdla. Aku agapɨm: nɨ höl piaku nugwön, din piaku aipam nugula. Makwam ñɨŋ, nɨ höl piaku nugwölöi; din piaku aipam nugwölöi. ");
INSERT INTO tmd_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ñɨŋ mönö pɨ lɨbak gɨrön, ‘Adaku mag wä röia; adaku mag gwogwo röiŋö,’ rɨmɨdöi aku, nöbö mö mögörɨb il kɨ rɨbyöx nugwön rɨg yadöi akwör rɨbyöx nugwön yadmɨdöia. Makwam nɨ nöbö i nugwo mönö diba yadmɨdöi. ");
INSERT INTO tmd_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Acö nɨ agal abmɨn höm aku, nuŋ nɨ pɨsaŋ mɨdöl aku, nɨ mönö pɨ nuöm nɨgnöb, mɨ ödöriö pɨ nuöm nɨgna. ");
INSERT INTO tmd_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Lo mönö ñɨŋ adaku yadöia, ‘Nöbö mö mös mönö höjɨl paŋyöbö akwör yajöñ aku mɨ, nöbö mö nugwön yajöña, aku mi yadöiŋö, cöñɨŋö,’ röia. ");
INSERT INTO tmd_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Lo ñɨŋa yad akuyöbö, nɨ nöbö pödiöm aliö mɨdɨl aku, nɨ keir mönö mödö yadmɨdla; jɨ Acö nɨ agal ab aku aipam, nɨ nöbö pödiöm mɨdɨl mönö aku mödö yada. Mönö an nuarö mönö paŋyöbö iör yadöl makwam, mi yadöiŋö, röyɨx,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Jisas aliö rɨmɨdmɨn, nugwo yadmä, “Nauö nagö mɨkai?” rɨmä. Aliö rɨmɨn, Jisas paiŋö yadöŋa, “Ñɨŋ nɨ nugwölöi aku, Acö na nugwo aipam nugwölöi. Nɨ nugwöyɨx aku, Acö na aipam nugwöyɨx,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jisas God höjöpalɨb rama yuadö, rɨg ñɨŋ bla God nölɨba rag hö aböi möl aku, mönö aku yad nöl mɨdöŋa, jɨ wop nuŋwa hölöŋ aku, nöbö i nugwo pɨ cɨcɨ nɨgölöŋ. ");
INSERT INTO tmd_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisas ñɨgö iswob yadöŋa, “Nɨ röböx dina. Nɨ hölu nugwöñ aku, jɨ ñɨŋ ap kib mag gwogwo rɨ rɨ gör mɨdön wöröxöñ aku mɨ, nɨ din piaku dueñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Jisas aliö rɨmɨn, Juda nöbö dib bla yadmä, “Nuŋ yada, ‘Nɨ din piaku dueñɨŋö,’ rɨ aku, pödpöd rɨmɨn aliö yad? Nuŋ keir pɨl pal nɨgɨba, rön, aliö yad ä?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Aliö yadmä aku, jɨ Jisas ñɨgö yadöŋa, “Ñɨŋ il bebö; nɨ bɨl sebö. Ñɨŋ mögörɨb il kɨyöbö; nɨ mögörɨb il kɨyöbö yöi. ");
INSERT INTO tmd_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Makwam adaku nugwön yadla, ‘Ñɨŋ ap kib mag gwogwo rɨ rɨ gör mɨdön wöröxöñɨŋö,’ rɨla. Makwam nɨ, Nɨ Rɨg Mɨdɨl Akwör Mɨdla, nugw peñ aku, ap kib mag gwogwo pɨxa alɨg mɨdöi aku mɨdön, wöröxöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Jisas aliö rɨmɨdmɨn, nugwo yad nugwön yadmä, “Nagö yönɨm?” rɨmä. Aliö rɨmɨn, Jisas yadöŋa, “Nɨ ñɨgö öim rɨg yad nölmɨdɨl aliö akwör mɨdla. ");
INSERT INTO tmd_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ñɨgö mönö diba yadön cɨn adaku, mönö mɨga akwör mɨda. Nöbö nɨ yad abmɨn höm aku, magalɨg nugw ri abön rɨ aku, nɨ rɨba nölmɨn nugugɨrön, nɨ paiŋö nöbö mö akuyöbö ñɨgö yad nölmɨdlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jisas nuŋ Nuö mönö yad nölöŋ aku nugwölim aku, ñɨgö yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","“Nöbö Ha nuŋwa nugwo pɨ pisö nɨgöñ wop aku, rɨg cön cön mag akuyöbö nugwön wop aku nugwöña Nɨ Rɨg Mɨdɨl Akwör Mɨdla. Ñɨŋ nugwöña nɨ ap i keir nugwön röi; Acö mönö nɨ rɨg yad akwör yad nölmɨdla. ");
INSERT INTO tmd_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nöbö nɨ abmɨn höm Nöbö aku, nɨ pɨsaŋ mɨda. Nugwo wä rɨ adakwör öim öim rɨl aku, nɨ röböxöl; nɨ pɨsaŋ ör mɨdö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jisas mönö aku yadmɨn nugugɨrön, nöbö mö mɨga ñɨŋ, Krais öim pöx mɨdöl nöbö mɨk, me rön, nugw pɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Makwam Jisas nuŋ Juda nöbö mö nugwo Krais, me rön, nugwim piaku ñɨgö yadöŋa, “Ñɨŋ mönö na mɨ aŋadö nugw pön, rɨg yadɨl mag akuyöbö akwör rɨmɨjöñ aku makwam, mɨ nöbö mö na mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Almɨjöñ aku, God nuŋ nöbö pödiöm mɨd aku nugwön, nag mabö röi mag aku röböxön, mɨd ri ab gɨ mɨjöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Jisas aliö rɨmɨdmɨn, yadmä, “Mönö yadlö aku mɨkai? An nöso Ebraham halöu ha nuŋwa mɨdöl aku, an nöbö mö bli ñɨgö nag mabö rölöl. Makwam, an pöd rɨmɨn, ‘Nag mabö röi mag aku röböxön, mɨd ri ab gɨ mɨjöñɨŋö,’ rɨlö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Aliö rɨmɨn, Jisas yadöŋa, “Nɨ ñɨgö mɨ ödöriö yadmɨdla, nöbö mö ap kib mag gwogwo röi akuyöbö, ap kib mag gwogwo rɨb mag akwör nag mabö rɨb nöbö mö akuyöbö mɨdöia. ");
INSERT INTO tmd_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nag mabö rɨb nöbö i, nuö nuŋwa rama öim mɨden; mai nöbö hör i rɨg abön nugwo wobön paŋ, nuö hödyöbö rama röböxön, ram hör duön nuö yoŋyöbö aku nugwo nag mabö cöna. Makwam ha i nuö rama öim öim mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","God Ha nuŋwa ñɨgö nöbö mö wobön, nag mɨdöi aku yau abmɨdaŋ, ñɨŋ nag mabö rɨmɨdöi adaku aŋadö röböxön mɨd ri aböña. ");
INSERT INTO tmd_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ñɨgö Ebraham yöxɨm yöxɨŋ yöxɨp höuöilmel rön höm mɨdöi aku nugula aku, jɨ mönö yadmɨdɨl aku yöxölön, nɨ pɨl pal nɨgɨba rɨmɨdöia. ");
INSERT INTO tmd_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nɨ Acö pɨsaŋ mɨdön nugula aku ñɨgö yad nölmɨdla; jɨ ñɨŋ, nuö ñɨŋ aku mönö rɨg yad mag akwör rɨmɨdöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Jisas aliö rɨmɨn, yadmä, “Acö an aku Ebraham,” me rɨmä. Aliö rɨmɨn, Jisas yadöŋa, “Ñɨŋ Ebraham halöu ha nuŋwa mɨdöyɨx aku, nuŋ rɨg rɨmɨd mag akwör röyɨxa. ");
INSERT INTO tmd_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nɨ God mönö yad akuyöbö nugwön, mönö mɨ ödöriö aku ñɨgö yad nöil aku mɨ, nɨ pɨl pal nɨgɨba rɨmɨdöia. Makwam ñɨŋ rɨba rɨmɨdöi mag akuyöbö, Ebraham nuŋ rölöŋ. ");
INSERT INTO tmd_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Makwam, nuö ñɨŋa rɨg rɨ mag akwör, ñɨŋ keir paŋ mag akwör rɨmɨdöiŋö,” röŋa. Jisas aliö rɨmɨn, yadmä, “An mö kib pön yöxölöi; God paŋyöbö akwör Acö an ödöriö,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Aliö rɨmɨdmɨn, Jisas paiŋö yadöŋa, “‘God paŋyöbö akwör Acö an ödöriö,’ me röi aku, jɨ God nuŋ Acö ñɨŋa mɨdöx aku, nɨ God yöbö hön, wopik yörɨk mɨdɨl aku nugwön, nɨ madmag nɨgöyɨxa. Nɨ piaku mɨdön, rɨb na keir yöx nugwön hölɨm; God pɨsaŋ mɨdön, nɨ nugwogwo yad abmɨn yörɨk höma. ");
INSERT INTO tmd_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Makwam, mönö nɨ aku pödpöd rɨmɨn nugw ri abölöi? Alöi aku, an nugw pöinɨŋö, rön, röia. ");
INSERT INTO tmd_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ñɨŋ nuö ñɨŋa kɨjaki halöu ha nuŋwa mɨdöi aku makwam, nugwo wä rɨ mag akwör rɨŋö, rön, rɨb aku yöx nugwöia. Nuŋ höd ila nɨgön, nöbö mö akuyöbö ñɨgö pɨl pal nɨgmɨd aku, mag nuŋ adaku aliö akwör mɨda. Rɨb wä bli, rɨb mɨ bli yöx nugwöl; nuŋ mönö mɨ bli yadöl. Mönö inakmönö hörmɨd aku, mönö yöbö nuŋ aku maku. Nuŋ öim öim mönö inakmönö hörmɨda; mönö inakmönö hörɨb il aku kɨjaki maku pal. ");
INSERT INTO tmd_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Makwam nɨ ñɨgö mönö ma akwör yadmɨdɨl aku, ñɨŋ nugwön pölöi. ");
INSERT INTO tmd_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nɨ rɨl aku nugwön, adaku ap kib mag gwogwo rɨlaŋö, rön, yadɨb maga nɨgöl. Makwam, nɨ mönö ma akwör yadɨl aku nugwön, ñɨŋ pödpöd rɨmɨn mönö na nugw pölöi? ");
INSERT INTO tmd_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nöbö mö God pɨsaŋ mɨdöi akuyöbö, mönö nuŋ aku pöia. Jɨ ñɨŋ nugwo pɨsaŋ mɨdölöi makwam, mönö nuŋ aku pölöiŋödö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Juda nöbö dib bla Jisas nugwo yadmä, “Nagö nöbö Sameria yöbö, nagö ragwo as öim nɨgö, röl aku, mi yadölɨŋödö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Aliö rɨmɨn, Jisas yadöŋa, “Nɨ ragwo asa mɨdöl. Nɨ Acö ib nuŋwa yadmön bɨl sö dumɨda, jɨ ñɨŋ ib na aku yadmɨn yöraku pibö pɨn dumɨda. ");
INSERT INTO tmd_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ib na keir yadmön bɨl sö duaŋ, me rön, rɨb aku yöx nugwöi; jɨ God nuŋ nöbö mö agap apɨm röi aku nugw ri ab Nöbö aku, nöbö mö ib na yadɨŋ bɨl sö duaŋ, me rön, rɨb aku yöx nugwa. ");
INSERT INTO tmd_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ñɨgö mi yadmɨdla, nöbö mö yönɨm mönö na aku nugwön, yadɨl mag akuyöbö cön aku, nuŋ wöröxen; nuŋ öim öim kömö mɨjönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jisas aliö rɨmɨn, ñɨŋ yadmä, “Naŋ mönö yadlö aku nugwön nugumɨn, nagö ragwo as öim nɨgɨm yadmɨdlö. Ebraham aipam, God mönö yadɨb nöbö bla aipam magalɨg wöröxmä, makwaim nagö pöd rɨmɨn yadlö, ‘Nöbö mö yönɨm mönö na aku nugwön, yadɨl mag akuyöbö cön aku, wöröxen; nuŋ öim öim kömö mɨjönɨŋö,’ rɨlö? ");
INSERT INTO tmd_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nöso ana Ebraham aipam, God mönö yadɨb nöbö bla aipam magalɨg wöröxim aku, nöbö piaku nöbö ulmɨdö, nɨ nöbö dib, me rön, rɨb aku yöx nugulö ä?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Aliö rɨmɨn, Jisas yadöŋa, “Ib na keir yadmön bɨl sö duöx aku, hör ap i röxgöxa. Makwam nöbö ib na yadmɨn möx dumɨd nöbö aku Acö na. Ñɨŋ nöbö paŋyöbö akwör nugwo God an, me röia. ");
INSERT INTO tmd_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","God an me röi aku, jɨ nugwo nugwölöi; makwam nɨ nugwo nugula. ‘Nugwo nugwöiö,’ rɨlöx aku, ñɨŋ mönö inakmönö höröi mag akuyöbö yadlöxa. Nɨ nugwo nugul makwam, nuŋ mönö rɨg yad mag akuyöbö akwör rɨla. ");
INSERT INTO tmd_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","God maduar ör nauö Ebraham nugwo yadön, nɨ Jisas weik hön mɨdɨl wop kɨ yadön, ‘Wop maiyöbö hönɨŋö,’ röŋa. Makwam nauö Ebraham God mönö yadöŋ aku nugwön, mönö aku God mi yadö, rön, wahax pön rɨb wä yöx nugu gör mɨdöŋa; wop maiyöbö weik höl aku rɨbyöx nugwön mɨ wahax pö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jisas aliö rɨmɨn, Juda nöbö bla yadmä, “Kɨm nagö padokwo padök mös höuöiliö igwö sö (50) mɨdöiö aku, jɨ Ebraham nugumö, rɨladö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Aliö rɨmɨn, Jisas ñɨgö yadöŋa, “Ñɨgö mɨ ödöriö yadmɨdla, Ebraham nugwo yöx pön hölöŋ wop aku, Nɨ Mɨdlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jisas aliö rɨmɨn, nugwo rɨg röd pal nɨgɨba rɨmɨdim aku, jɨ God höjöpalɨb rama ram möl yuadö mɨdöŋ aku, nöbö mö alebö tar röpɨn rɨŋadö duön duöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Makwam Jisas nöbö nuŋ bla pɨsaŋ du gɨrön nugumɨn, nöbö yöx pön hem wop akwör mämäga we wölöŋ i mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jisas nöbö nuŋ bla nöbö aku nugwön Jisas nugwo yadmä, “Mönö yad nölɨb nöbö. Nöbö kai ap kib mag gwogwo rɨ mɨdmɨn, nöbö kɨ yöx pön hem wop aku mämäg nuŋ aku we wölöŋ? Nuŋ keir mönö nuö nuöm rɨmɨn rö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Aliö rɨmɨn, Jisas yadöŋa, “Mämäg nuŋwa we wölöŋ aku, nuŋ keir mönö nuö nuöm ap kib mag gwogwo rɨ mɨdmɨn röl. Mämäg nuŋwa we wölöŋ aku, nöbö mö akuyöbö God nuŋ mɨ Nöbö ölö mɨdö, me rön, nugw ri abɨŋ, me rön, ra. ");
INSERT INTO tmd_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Weik naiö nɨgmɨd wop kɨ, Nöbö nɨ agal abmɨn höm aku, mabö nuŋ aku cɨnɨŋa. Pɨxmag gurɨba rɨmɨda nugwön an mabö rɨb maga nɨgen. ");
INSERT INTO tmd_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nɨ mögörɨb il kɨ mɨdɨl wop kɨ, nöbö mö mögörɨb il kɨ mɨdöi akuyöbö mil ñɨŋ aku nɨ mɨdlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jisas mönö aku yadön, mɨgrö bö höpöl pɨlön, rɨmɨn lug cɨx rɨmɨn, pön nöbö mämäg we wölöŋ aku nugwo mämäg nuŋ aku nɨgön, ");
INSERT INTO tmd_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","yadöŋa, “Siloam bana duön, mämäg nagö aku röbö nɨgö,” röŋa. Al gɨrön yad abmɨn, du röbö nɨgɨm, mämäga ixmɨn nugwön ram nuŋwa duöŋa. Siloam mönö il aku “Yad Abmɨn Duöŋa.” ");
INSERT INTO tmd_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Makwam nöbö mö rama yam nuŋ pɨsaŋ nɨgiö akuyöbö aipam, höd nuŋ ap sö rɨmɨda nugumɨdöi nöbö mö akuyöbö aipam yadmä, “Nöbö kɨ, nöbö yöraku römɨd mɨd gɨrön, ap sö rɨmɨd aku röxg nɨgö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Aliö rɨmɨn, bli yadmä, “Yöwö pal, nöbö akwör,” me rɨmä. Bli piöŋö yadmä, “Ehöu. Nöbö akwör nɨga aku, jɨ nöbö kɨ nöbö hör,” me rɨmä. Aliö rɨmɨdmɨn, nöbö aku nuŋ keir yadöŋa, “Nɨ keir nöbö aku,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Aliö rɨmɨn, nugwo yadmä, “Mämäg nagö aku pödpöd rɨman wä rö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Aliö rɨmɨn, yadöŋa, “Nöbö Jisas, röi aku, mɨgrö bö höpöl pɨlön, rɨmɨn lug cɨx rɨmɨn, pön mämäg na aku nɨgön yada, ‘Siloam bana duön, mämäg nagö aku röbö nɨgö,’ rɨmɨn, du mämäg na röbö nɨgön, rɨb pia mämäga ix nugulö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Aliö rɨmɨn, yadmä, “Nöbö aku weik pikai?” rɨmä. Aliö rɨmɨn, yadöŋa, “Nɨ nugwöiö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Makwam Jisas rɨmɨn mämäga ix nugwöŋ nöbö aku, Juda ada God höjöpalɨb wop ñɨŋ akuyöbö röŋ makwam, nöbö mö bli nöbö aku nugwo pön Perisi nöbö mɨdim yöra hömä. ");
INSERT INTO tmd_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Perisi nöbö, nöbö aku nugwo yadmä, “Naŋ agö magɨm rön mämäga ix nugulö?” rɨmä. Aliö rɨmɨn, yadöŋa, “Jisas mögö lug i pön, mämäg na aku nɨgɨm, nɨ du mämäg na röbö nɨgön wopik mämäg na ix nugulö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Aliö rɨmɨn, Perisi nöbö bli yadmä, “God höjöpalɨb wop aku akuyöbö al aku, nuŋ God höjöpalɨb wop aku lo adaku röd aba. Makwam an nugwöla, God nugwo yad abɨm hölö,” rɨmä. Aliö rɨmɨdmɨn, nöbö ñɨŋ bli paiŋö yadmä, “Nöbö ap kib mag gwogwo rɨb i mɨdöxisöŋö, nuŋ pödpödiö ap rölɨbä aku röxö?” rɨmä. Aliö yadön ñɨŋ keir ör asɨx hörɨrör nɨgmä. ");
INSERT INTO tmd_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Perisi nöbö bla, nöbö aku nugwo iswob yad nugwön yadmä, “‘Nöbö mämäg na rɨmɨn mämäg na ix nugulö,’ rɨlö aku, naŋ nöbö aku nöbö pödiöm, me rɨ rɨbyöx nugulö?” rɨmä. Aliö rɨmɨn, yadöŋa, “Nɨ nugula nuŋ God mönö yadɨb nöbö i,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Makwam Juda nöbö dib bla, nöbö mämäg we wölöŋa rɨmɨn wä röŋ mönö nuŋ aku yöxölim; nuö nuöm yöŋö höŋ, me rɨm, mönöbö hogwa hömɨn, ");
INSERT INTO tmd_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","yadmä, “Ha kɨ ha ñɨŋ?” me rɨmä. Aliö rɨmɨn, yadmä, “Yöwö, ha aku ha an,” me rɨmä. Aliö rɨmɨn, yadmä, “Ñɨŋ nugwo mämäg we alɨg yöx pön hömɨŋönö ä?” rɨmä. Aliö rɨmɨn, yadmä, “Yöwö, nugwo mämäg we alɨg yöx pön hömɨŋö,” rɨmä. Aliö rɨmɨn, yadmä, “Makwam, wopik pödpöd rön mämäga ix nugumɨd?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","23","Aliö rɨmɨn, ñɨŋ mönöbö rama mödö nugumɨn, Juda nöbö dib piaku höd mönö ölɨsö magi yadön yadmä, “Nöbö mö yön yön Jisas nuŋ Krais me rön wöxnö yajöñ akuyöbö, Juda mögum rɨb ram aku iswob heñɨm,” rɨmä. Mönö yadim aku mödö nugwön mönö, ipöxön, yadmä, “Ha aku, ha ana mɨd aku nugwöla; ha an aku mämäg we alɨg yöx pön hömɨŋ aku aipam nugwöla; makwaim weik pödpöd rɨmɨn mämäga ix nugumɨd aku nugwölöl; nöbö kai nuŋ almɨdmɨn mämäga ix nugumɨd aku aipam nugwölöl. Makwam nuŋ ha ulmɨdö yöi; nuŋ keir yad nugumɨjöñ aku, yajönɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Aliö rɨmɨdmɨn, nöbö dib bla nöbö aku nugwo iswob wö rɨmɨn hömɨdmɨn yadmä, “Nagö kömö nɨg aku, God mämäg il rol aku mönö ödöriar yadö. An nugwöla, nöbö yadmɨdöl aku, nöbö aku ap kib mag gwogwo rɨb nöbö i,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Aliö rɨmɨn, nöbö aku paiŋö yadöŋa, “Nuŋ nöbö ap kib mag gwogwo rɨb nöbö i mönö wöhö, nɨ nugwöi. Nɨ ap paŋyöbö iör nugula. Höd mämäg we wöl gɨ mɨdɨm aku, jɨ weik mämäga ix nugulö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Aliö rɨmɨn, yadmä, “Nuŋ nagö pödpöd rɨmɨdmɨn, mämäga ix nugulö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Aliö rɨmɨn, yadöŋa, “Nɨ ñɨgö maduö yad nöil aku, jɨ ñɨŋ mönö na aku pölöiŋöd. Pödpöd rɨmɨn mönö maduö yadɨl mönö aku iswob yadö, rön, yadmɨdöi? Ñɨŋ keir algör nöbö nuŋ i mɨjnɨŋö, rön, yad nugumɨdöi ä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Aliö rɨmɨdmɨn, nugwo rɨb gwogwo yöxön, nugwo mönö gwogwo yadön yadmä, “An Mosɨs nöbö nuŋ aku, jɨ nagö nöbö hör aku nöbö nuŋ im! ");
INSERT INTO tmd_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","God Mosɨs nugwo mönö yad nölmɨn yadmɨd aku nugwöla, jɨ nöbö kɨ pikai yöbö hö aku nugwölölɨŋö!” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Aliö rɨmɨn, yadöŋa, “Ake! Ha ruai! Nuŋ mämäg na aku rɨmɨn wä ra, jɨ nuŋ pikai yöbö nöböm ñɨŋ nugwölöi ä! ");
INSERT INTO tmd_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Makwam an nugwöla, ap kib mag gwogwo rɨ gɨrön, God höjöpalmɨjöñ aku, nuŋ mönö ñɨŋa pen; nöbö mö God nugw pön, mönö rɨg yad mag akwör rɨ gɨrön, nugwo höjöpalmɨjöñ aku, nuŋ mönö ñɨŋa nugwöna. ");
INSERT INTO tmd_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Mögörɨb rɨ nɨgöŋ wop aku ila nɨgön, mɨdɨp hö weik mɨdöl wop kɨ, nöbö mö mämäg we alɨg yöx pön hem i rɨmɨn wä rölöŋ. ");
INSERT INTO tmd_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nöbö aku God agal abmɨn hölöx aku, nuŋ ap i rɨbä maga nɨgölöx,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Aliö rɨmɨn, ñɨŋ paiŋö yadmä, “Nauö nam nagö yöx pön hem wop aku, nöbö ap kib mag gwogwo rɨb aku yöx pön hömä, jɨ nagö anɨŋ mönö yad nölɨba rɨmɨdlö ä? Aliö yadön, Juda mögum rɨb ram kɨ iswob höuöil höinaŋö,” rön, nugwo pɨ pɨraiup du rɨŋö bö abmä. ");
INSERT INTO tmd_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Makwam nöbö aku nugwo pɨ rɨŋö bö abim mönö aku nugwön, Jisas du nugwo hölu nugwön yadöŋa, “Nagö Nöbö Ha nuŋwa nugw pɨlanö wöhö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Jisas aliö rɨmɨn, yadöŋa, “Nöbö Ha nuŋwa nöbö kai? Nöbö aku maku, me ran, nɨ nugwo nugw pɨnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Aliö rɨmɨn, Jisas yadöŋa, “Nöbö aku maduö nugulö maku pal. Mɨ nagö pɨsaŋ mönö pɨmɨdöl mɨk,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Jisas aliö rɨmɨn, nöbö aku Jisas mɨdöŋ il yöra höxmax yuön yadöŋa, “Nöbö Dib! Nɨ nagö nugw pɨmɨdlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Aliö rɨmɨn, Jisas yadöŋa, “Nɨ mögörɨb il kɨ höl aku, nöbö mö mögörɨb il kɨ mɨdöi akuyöbö ñɨgö nuöm nɨgɨba höla. Nöbö mö mämäg we wöl piaku mila hön nugwöña; makwam nöbö mö an mödö nugw ri abölɨŋö, röi piaku, mila röböxön, pɨxmag yuö bö duön nugweñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jisas aliö rɨmɨn, Perisi nöbö il yöraku mɨdim bli, mönö aku nugwön yadmä, “Aliö rɨlö aku, an aipam mämäg we wölö, rön, yadmɨdlanö ä?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Aliö rɨmɨn, Jisas yadöŋa, “Ñɨŋ mämäg we mɨdöyɨx aku, ap kib mag gwogwo röi aku mönö diba yöxölöyɨx; makwam nugw ri abölɨŋö, röi aku, ñɨŋ pɨxa alɨg mɨdön mönö diba yöxöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisas mönö i höd röxön yadöŋa, “Nɨ ñɨgö mɨ ödöriö yadmɨdla, hön sipsip mɨdöi kul yuadö aku duba, ubalɨj mɨrɨx möla mɨdaŋ nugugɨrön, hör um möla luad diöñ akuyöbö, ñɨŋ ap kib pɨb nöbö mö pal. ");
INSERT INTO tmd_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nöbö sipsip urɨb aku, hör um möla luad duen; ubalɨj mɨrɨx möl akwör duön, kul yuadö möl diöna. ");
INSERT INTO tmd_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","“Makwam nöbö sipsip urɨb aku uröpɨnaŋ, nöbö ubalɨj ila nugwidɨx mɨjön aku nugwo nugw ri abön aku, uba röjöna. Makwam sipsip bla algör ör, nöbö aku ajmöl nugwo aku nugwöñ akuyöbö, sipsip nuŋ keir bla iba ur yad pön rɨŋö bö diöna. ");
INSERT INTO tmd_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Sipsip nuŋ bla yad pön rɨŋö bö duön, nuŋ höd duaŋ nugugɨrön, ñɨŋ ajmöl nuŋwa nugwöñ aku, nugwo mai diöña. ");
INSERT INTO tmd_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Makwam nöbö hör i yadaŋ, nugwo mai dueñ; ajmöl nuŋwa nugweñ aku, bör diöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisas nuŋ aliö mönö höd röxön yadöŋa, jɨ mönö rɨg yadmɨd adaku, me rön, röx nugwölim. ");
INSERT INTO tmd_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jisas mönö röx nugwölim aku, nuŋ iswob yadöŋa, “Nɨ ñɨgö mɨ ödöriö yadmɨdla, nɨ keir sipsip bla höb ram möl ubalɨja mɨdla. ");
INSERT INTO tmd_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Makwam, ‘An hön sipsip urɨb nöbö,’ me rön, höd hem nöbö bla, ñɨŋ magalɨg ap kib pɨb nöbö mɨdmɨdöia. Sipsip bla mönö ñɨŋ aku nugumɨdölöi. ");
INSERT INTO tmd_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Makwam nɨ keir sipsip bla höb ram möl ubalɨja mɨdla. Nöbö mö nɨ hön kul yuadö möla diöñ akuyöbö, kömö akwör mɨjöña. Ubalɨja pikwo pik rɨ gɨrön, ap panö panö nɨmöña. ");
INSERT INTO tmd_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ap kib pɨb nöbö bla höi aku, ap kib pɨba, nöbäpö pɨl pal nɨgɨba, mag gwogwo rɨba, rɨb akwör höia. Makwam nɨ höl aku, ñɨgö rɨmön, ñɨŋ kömö öim mɨdɨb mag aku pön, kömö mɨd ri abön rɨb mag akwör rön mɨdɨŋ duaŋ, me rön, höla. ");
INSERT INTO tmd_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Nɨ Sipsip Urɨb Nöbö Wä. Sipsip Urɨb Nöbö Wä aku, hön sipsip blai ñöx nɨgön wöröxöna. ");
INSERT INTO tmd_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nöbö i nuŋ rɨg pɨba inag hön sipsip nugwidɨx mɨjön aku, hön sipsip uröi nöbö ödöriö yöi wöhö; sipsip bla sipsip nuŋ yöi makwam, wöñö höpebö bla hömɨjöñ aku nugwön bör diöna. Makwam mɨ, wöñö höpebö piaku sipsip bla ñɨgö rɨböxɨp du hör piaku piaku aböña. ");
INSERT INTO tmd_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nöbö aku rɨg pɨba inag hön sipsip nugwidɨx mɨdön, sipsip bla ñɨgö rɨbyöx nugwen makwam, bör diöna. ");
INSERT INTO tmd_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Nɨ Sipsip Urɨb Nöbö Wä. Acö an nuarö nuö nuö nugw ri aböl aku, nɨ sipsip nɨ bla nugw ri abla; sipsip nɨ bla ñɨŋ nɨ nugw ri aböia. Makwam, nɨ ñɨgö ñöx nɨgön wöröxna. ");
INSERT INTO tmd_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Sipsip kul kɨ yuadö mɨdöi piakwör yöi, sipsip bli kwo aipam mɨdöia. Sipsip piaku algör ör pɨna. Ñɨŋ algör ör mönö nɨ aku nugwöña. Sipsip yuadö möl paŋyöbö iör mögum rɨ mɨdön, ñɨŋ urɨb nöbö paŋyöbö iör mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Nɨ ñɨgö ñöx nɨgön wöröxön öbin aku mɨ, Acö nɨ madmag nɨga. ");
INSERT INTO tmd_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nöbö mö bli rɨb ñɨŋa yöx nugwön nɨ rɨŋ wöröxöin; nɨ rɨb na keir yöx nugwön wöröxna. Nɨ keir wöröxnö, rön, wöröxna; nɨ keir öbinö, rön, öbina. Makwam, Acö na, nɨ nagö mag akuyöbö rane, rɨ mönö nuŋ aku pön, rɨg yad mag akwör cɨnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jisas mönö aku yadmɨn, Juda ada iswob lɨbak adöi keir adöi keir nɨgön, ");
INSERT INTO tmd_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","bli yadmä, “Nuŋ ragwo as öim nɨgɨm, mönö inakmönö hörmɨd aku, pödpöd rɨmɨn mönö nuŋ aku nugumɨdöi?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Aliö rɨmɨdmɨn, bli paiŋö yadmä, “Nuŋ ragwo as öim nɨgöx aku, aliö yad ri abön rölöx. Makwam ragwo as öim nɨgöx aku, pödpödiö nöbö mö mämäg we wöl akuyöbö rɨmɨn iswob nugwöyɨx?” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Makwam mai Juda nöbö mö, God höjöpalɨb ram lei wä mɨd aku wahax pɨb wop dib aku wopik, me rön, Jerusalem du mögum rɨmä. Wop dib aku ij rɨb wopa makwam, ");
INSERT INTO tmd_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jisas nuŋ God höjöpalɨb rama rɨŋadö “Solomon Ram Bötö” röi piaku yönmɨdmɨn nugugɨrön, ");
INSERT INTO tmd_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Juda nöbö mö bla Jisas mɨdöŋ yöra hön yadmä, “Anɨŋ yadaŋ öim pöx mɨdöinɨŋ; nagö Krais mɨjɨnö aku, wöxnö yadaŋ nuguŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Aliö rɨmɨn, Jisas yadöŋa, “Nɨ ñɨgö mödö yad nöl aku, jɨ mönö nɨ aku mönö mɨ me rön nugw pölim. Acö na ölɨsö nuŋwa pön ap rölɨbä mag cɨmal piaku rɨl aku nugwön, mönö na aku mönö mɨ, me rön, nugw pöyɨxa. ");
INSERT INTO tmd_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Makwam sipsip na mɨdölöi aku mɨ, mönö na aku mönö mɨ, me rön, nugw pölöi. ");
INSERT INTO tmd_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Sipsip nɨ bla yadmɨdɨl mönö na aku nugwöia. Nɨ ñɨgö nugula nugwön ñɨŋ nɨ mai höia. ");
INSERT INTO tmd_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nɨ mai höi bla, nɨ ñɨgö kömö öim mɨdɨb mag aku nöil makwam ñɨŋ wöröxeñ. Imag rol na mɨdöi aku, nöbö mö bli hön ñɨgö pön pɨxɨp dub maga nɨgöl. ");
INSERT INTO tmd_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Acö na ñɨgö pön nɨ nöl aku, nuŋ Nöbö ölɨsö keiryöbö mɨd pal. Imag rol nuŋwa mɨdöi aku, nöbö mö bli hön ñɨgö pön pɨxɨp dub maga nɨgöl. ");
INSERT INTO tmd_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Acö keir, nɨ keir, yöi; an nuarö paŋyöbö iör mɨdölɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jisas aliö rɨmɨdmɨn, Juda ada nugwo iswob rɨg röd palɨba rɨmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Almɨdmɨn, Jisas ñɨgö yadöŋa, “Acö nuŋ nɨ yadmɨn nugwön nɨ ñɨŋ ap wä hörɨrör mɨga akwör rɨma. Makwam ap wä rɨm piaku, mag kai rɨ gwogwam rɨmön nugwön, nɨ pɨl pal nɨgɨba rɨmɨdöiŋö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Jisas aliö rɨmɨn, yadmä, “Ap wä ada piaku nugwön, nagö pɨl pal nɨgɨba rɨmɨdölöl; nagö nöbö yöbö jɨ, nɨ God röxg mɨdlö, rön, God ib nuŋwa pɨmag pɨn dulö makwam, naŋ pɨl pal nɨgɨba rɨmɨdölɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Aliö rɨmɨn, Jisas yadöŋa, “Lo ñɨŋa keir rɨb mɨŋi kai kɨtön yadmä, ‘God nuŋ yadöŋa, “Ñɨŋ keir god röxg mɨdöiŋö,” rö,’ rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","God Mönö aku mönö umi inakmönö hörenɨm; öim öim mör mɨjöna. God nuŋ nöbö mö hör piaku mönö yadɨl kɨ nölön, ‘Ñɨŋ god röxg mɨdöiŋö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Nɨ mögörɨb il kɨ höl aku, Acö nɨ mabö nuŋwa yad nɨgön yad abmɨn höla. Makwam nɨ God Ha nuŋwa mɨdlö, rɨmön, mönö aku nugwön, ñɨŋ pödpöd rɨmɨn, God ib nuŋwa yad mag pɨn nɨgmɨdö, rön, nɨ pɨl pal nɨgɨba rɨmɨdöi? ");
INSERT INTO tmd_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nɨ God mabö nuŋwa rɨmɨjɨn aku, mönö na nugw pöña. Nöi mɨjön aku, wöhö. ");
INSERT INTO tmd_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Makwam mönö na nugw pöinɨŋö, cöñ aku, nɨ ap rölɨbä akuyöbö rɨl bla nugwön, nugw pöña. Ñɨŋ alön nugw pöñ aku, nɨ Acö pɨsaŋ mɨdla, Acö nɨ pɨsaŋ mɨd aku nugwöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jisas nugwo iswob pɨ cɨcɨ nɨgnɨŋö, rɨmä aku, jɨ nuŋ tar duön duöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jisas aliö tar duön, höbkal röbö Jodan möxön pö kwo duön, Jon höd mɨdön nöbö mö röbö pal nölmɨd mögörɨb rɨgwoŋ piaku du mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nöbö mö mɨga akwör mɨdöŋ aku hön yadmä, “Jon ap rölɨbä akuyöbö bli rɨmɨdöl, makwam nuŋ nöbö kɨ nugwo, me rön, mönö kai kai yadmɨd aku, magalɨg mönö mɨ akwör yadmɨdö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Aliö rön, nöbö mö möl aku mɨdim piaku mɨga akwör Jisas nugw pɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ram yöj agrö Betani yöbö nöbö i ap röŋa. Ib nuŋwa Lasaras. Nöbö aku, nölöunɨŋ nuŋwa mös mɨdmɨdöia; i Maria, i Mata. ");
INSERT INTO tmd_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria aku, Jisas nugwo yamsö pɨlö nuŋwa wel röbö hör nölön, yöj panö nuŋwa pɨ mɨxsa örɨx aböŋ mö aku. Haul nuŋwa Lasaras ap röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lasaras nölöunɨŋ hogwa Jisas nugwo mönö pɨn abön yadmä, “Nöbö Dib! Nöbö madmag yöbö nagö aku ap rö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Makwam Jisas mönö yad abim aku nugwön yadöŋa, “Nuŋ ap rɨ makwam jɨ nuŋ aŋadö wöröxen. God nuŋ keir nugwa aku, nuŋ ölɨsö mag nuŋwa keir raŋ, nöbö mö bla God ib nuŋwa aipam, God Ha ib nuŋwa aipam yadɨŋ bɨl sö diönɨŋö, rön, rö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisas nuŋ Mata, Maria, Lasaras nɨmamañö adaku ñɨgö madmag nɨgmɨda. ");
INSERT INTO tmd_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lasaras ap röŋ mönö aku nugwön, Jisas nuŋ Lasaras nuguba yadkap duölöŋ; mögörɨb mɨdöŋ yöra wop mös alɨg mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Wop mös pɨnmɨn, nöbö nuŋ akuyöbö ñɨgö yadöŋa, “Mögörɨb Judia höbkal duŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Aliö rɨmɨn, nöbö nuŋ bla yadmä, “Mönö yad nölɨb nöbö. Idöm yoŋwör kwo, Juda nöbö bla nagö rɨg röd palɨba rɨmɨdim aku, jɨ nagö iswob höbkal mögörɨb akwör duba rɨmɨdlö ä?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Aliö rɨmɨn, Jisas yadöŋa, “Ñɨŋ nugwöia, wop paŋyöbö i, aua akuyöbö möl sö mɨda. Nöbö mö mil alɨg yönmɨjöñ bla, mögörɨb mil aku mil ab gɨ mɨdaŋ, ap bli ñɨŋ pölöpösöx abaŋ pɨn bɨreñ. ");
INSERT INTO tmd_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Makwam nöbö mö pɨxmag yuö bö yönmɨjöñ bla, mil ñɨŋa mɨdölaŋ, ap bli ñɨŋ pölöpösöx abaŋ pɨn bɨcöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jisas aliö rön, mönö i kwo ñɨgö yadön yadöŋa, “Nöbö nugub ana Lasaras inɨmö hölɨmmɨda; jɨ nɨ duön nugwo yadmön öbɨl diönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Jisas aliö rɨmɨn, nöbö nuŋ bla paiŋö yadmä, “Nöbö Dib. Nuŋ hölɨmmɨdö, rɨlö aku, kömö nɨgönɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisas nuŋ Lasaras mödö wöröxöŋ aku nugwön, “Lasaras inɨmö hölɨmmɨdö,” röŋa. Makwam nöbö nuŋ bla Jisas mönö nuŋwa nugwön, Lasaras hör inɨmö hölɨmmɨdö, rɨ rɨbyöx nugumä. ");
INSERT INTO tmd_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nöbö nuŋ bla nugwölɨbör mɨdmä nugwön Jisas ñɨgö wöxnö yadön yadöŋa, “Lasaras mödö wöröxa. ");
INSERT INTO tmd_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Makwam nɨ Lasaras pɨsaŋ mɨdölmön wöröx aku, ñɨgö, me rön, wahax pɨla. Aliö al aku, ñɨŋ mönö na nugw pɨb maga nɨga. Makwam Lasaras mɨd yöra duŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Jisas aliö rɨmɨn, Tomas Didimas nuŋ Jisas nöbö adö bli ñɨgö yadöŋa, “An magalɨg mönö yad nölɨb nöbö ana pɨsaŋ mögörɨb Judia duŋ, nugwo pɨl pal nɨgön, anɨŋ aipam pɨl pal nɨgɨŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Makwam ñɨŋ ram yöj lɨglɨg agrö Betani uröpɨnmɨn, nöbö mö bla Jisas nugwo yadmä, “Lasaras wöröxɨm hogw pɨlɨm, wop mös mös padɨxö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Makwam ram yöj lɨglɨg agrö Betani aku, Jerusalem il yöra, kilomita akuyöbö mös paŋ mɨdmɨd aku, ");
INSERT INTO tmd_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Lasaras wöröxɨm, Juda nöbö mö mɨga hön, Mata Maria mö hödpɨg hogwa ögwö yöxön imön möb nɨgmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Makwam Jisas hömɨdö, rɨmɨn, Mata nugwön, pɨgnɨŋ Maria nugwo rama röböxön, Jisas nuguba duöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata nuŋ du Jisas nugwo nugwön yadöŋa, “Nöbö Dib. Nagö yörɨk mɨdlaxisöŋö, haul na Lasaras wöröxölöx. ");
INSERT INTO tmd_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Makwam nɨ nugula, weik God nugwo ap agapɨm yad nugumɨjɨnö aku, rɨg yajɨnö mag akwör cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Aliö rɨmɨn, Jisas yadöŋa, “Haul nagö höbkal öbiönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Aliö rɨmɨn, Mata yadöŋa, “Nɨ nugula mönö diba yadɨb wop aku öbiönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Aliö rɨmɨn, Jisas yadöŋa, “Nɨ keir rɨmön nöbö mö öbiöña; nɨ keir rɨmön nöbö mö kömö mɨjöña. Nöbö mö nɨ nugw pön wöröxöñ akuyöbö, kömö mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nöbö mö kömö mɨdön nɨ nugw pöñ akuyöbö, wöröxeñ; öim öim kömö mɨjöña. Mönö yadmɨdɨl kɨ nugw pɨlanö owa?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Jisas aliö rɨmɨdmɨn, Mata yadöŋa, “Nöbö Dib. Yöwä, nɨ nugula, naŋ mɨ Krais aku, God Ha nuŋwa mögörɨb kɨ hönɨŋö, röi akwör,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata mönö aku yadön, rama höbkal duön, pɨgnɨŋ nuŋwa Maria nugwo rɨmɨj möl piaku mönömɨm rön yadöŋa, “Mönö yad nölɨb nöbö mödö ha; nagö mɨkai me rön yad nugumɨdö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria mönö aku nugwön rɨmgör öbɨlön, Jisas nugwo nuguba duöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Makwam Jisas nuŋ ram yöj lɨglɨg agrö Betani hölöŋ; Mata nugwo nugwöŋ yör akwör mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Maria nuŋ aliö ipalɨp dumɨn, Juda nöbö mö nugwo pɨsaŋ ram möl yuadö mɨdim piaku rɨbyöx nugumä, nöbäpö hogwaj kwo imɨba dumɨdö, rön, dumɨn nugugɨrön mai dumä. ");
INSERT INTO tmd_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria du Jisas nugwön, mɨdöŋ yödpɨlö il yöra mödömödö pɨlön yadöŋa, “Nöbö Dib, nagö yörɨk mɨdlaxisöŋö, haul na wöröxölöx!” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Makwam Maria aipam, Juda nöbö mö nuŋ pɨsaŋ hem piaku aipam immɨdmä aku nugwön, Jisas höbwab rɨb madmag nuŋwa mɨ ödöriö ögwö diba röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Almɨn, Jisas yadöŋa, “Nugwo hogw pɨlöi pikai?” röŋa. Aliö rɨmɨn, yadmä, “Han du nuguŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jisas mäp röbö pɨnöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jisas mäp röbö pɨnmɨdöŋ aku nugwön, Juda nöbö mö piaku nugwön yadmä, “Nugwi! Nuŋ Lasaras nugwo mɨ ödöriö madmag nɨgö!” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Bli piöŋö yadmä, “Nuŋ nöbö mämäg we wölöŋ aku nugwo rɨmɨn mämäga ix nugwöŋ aku, pödpöd rɨmɨn ap nöbö kɨ nugwo röŋ aku rɨmɨn kömö nɨgölöŋ?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Makwam Jisas iswob höbwab rɨb madmag nuŋwa mɨ ödöriö ögwö diba rɨmɨn, Lasaras nugwo hogw pɨlim hogw möla uröpɨnöŋa. Nöbäpö hogw pɨlim aku, rɨg möl i hogw pɨlmä; makwam rɨg dib i pɨ mölaja idɨx gɨmɨn mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Makwam Jisas nuŋ nöbö bla yadöŋa, “Rɨg aku pɨ abnö,” röŋa. Jisas aliö rɨmɨn, nöbö Lasaras wöröxöŋ aku nölöunɨŋ nuŋwa Mata yadöŋa, “Nöbö Dib, nöbäpö aku wöröxɨm hogw pɨlɨm, wop mös mös padɨxa aku, mɨ hölɨŋ gwogwo hönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Aliö rɨmɨn, Jisas paiŋö yadöŋa, “Nagö agamö rɨl? Nagö yadla, ‘Nɨ nugw pɨ mɨjɨnö aku, God ölɨsö nuŋwa keir nugunaŋö,’ rɨlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Jisas aliö rɨmɨn, rɨg aku pɨ abɨm, Jisas pisö rɨ laxiö nugwön yadöŋa, “Acö, nɨ nagö yad nugumön nɨ nugulö aku, nagö wä rö rɨmɨdla. ");
INSERT INTO tmd_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nɨ nagö yad nugumön nɨ öim nugulö aku mödö nugula. Makwam mönö yadmɨdɨl kɨ, nöbö mö yörɨk öbɨl gɨ mɨdöi pik, nagör nɨ agal abman höm aku nugw pɨŋ, me rön, yadmɨdlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jisas aliö rön, ajmöla aj halön yadöŋa, “Lasaras, nagö rɨŋö yörɨk hö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Jisas aliö rɨmɨn, wölɨj iŋ wajmag nugwo wobön, haŋaj mämäg yuö wölɨj wobön, pön du hogw pɨlim wölɨj piaku, aliö mɨdmɨn nugugɨrön, nöbäpö högi mɨŋ aku öbɨl wölɨj waba alɨg röpɨn rɨŋadö höŋa. Höm, Jisas nöbö akuyöbö ñɨgö yadöŋa, “Nugwo wobim wölɨj piaku yau abɨŋ duaŋ,” me röŋa. Aliö rɨmɨn, rɨg yadöŋ mag akuyöbö rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Juda nöbö mö Maria nugwo nuguba hem piaku, Jisas Lasaras nugwo rɨm öbɨlöŋ aku nugwön, nöbö mö mɨg mɨŋa Jisas nuŋ Krais öim pöx mɨdmɨdöl Nöbö aku, me rön, nugwo nugw pɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Makwam bli höbkal Perisi nöbö mɨdim yöra duön, Jisas rɨg röŋ akuyöbö ñɨgö yad nölmä. ");
INSERT INTO tmd_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Yad nölmɨn, Perisi nöbö bla aipam, God ap höjöpal ur nölɨb nöbö dib bla aipam, ñɨŋ Juda Kansol mönö pɨ asɨx nɨgmɨdöi nöbö dib akuyöbö ñɨgö wö rɨmɨn, du mögum rɨmɨn, ñɨgö yadmä, “Nöbö aku ap rölɨbä mɨga akwör rɨmɨd aku, an pödpöd cɨnɨŋ? ");
INSERT INTO tmd_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","An nugwön röböxɨŋ, nuŋ paŋ mag akwör raŋ duaŋ, nöbö mö magalɨg nugwo nugw pön, kiŋ an, me rɨmɨjöñ aku, Rom nöbö dib piaku hön, God höjöpalɨb ram an aku rɨ gwogwam rön, anɨŋ Juda nöbö mö rɨ ajö nɨgön, cöñɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Makwam kɨm akwör, nöbö i nugwo yad nɨgɨm, nuŋ God ap höjöpal ur nölɨb nöbö dib ödöriö mɨdöŋa. Nöbö aku ib nuŋwa Kaiapas. Nuŋ mögum rɨmɨdim mibɨl aku mönö yadön yadöŋa, “Ñɨgö rɨb nɨgöl. ");
INSERT INTO tmd_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nɨ ñɨgö yadmɨdla, nöbö paŋyöbö i wöröxaŋ an magalɨg kömö dinɨŋ aku wä; an magalɨg wöröxnɨŋ aku gwogwo cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiapas nuŋ mönö yadöŋ aku, nuŋ keir yadölöŋ; nuŋ God ap höjöpal ur nölɨb nöbö dib ödöriö kɨm aku mɨdöŋ aku mɨ, nuŋ ap agap apɨm mai cön akuyöbö rɨbyöx nugwön, Jisas nuŋ Juda nöbö mö bla ñɨgö me rön wöröxönɨŋö, rön, mönö aku yadöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Makwam Juda ada ñɨgör yöi; nöbö mö God halöu ha nuŋ pɨba rɨmɨd piaku magalɨg pɨ nɨgiö nɨgön nɨgaŋ, il nuŋwa paŋyöbö iör mɨjöñɨŋö, rön, wöröxönɨŋö, rön, mönö aku yadöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Makwam, wop aku ila nɨgön, Juda nöbö dib piaku Jisas nugwo pödpöd rön pɨl pal nɨgnɨŋö, rön, öim mönö akwör yad nugup uhömɨdmä. ");
INSERT INTO tmd_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Juda nöbö dib bla Jisas nugwo pɨl pal nɨgɨba rɨmɨdim aku nugwön, Jisas nuŋ mögörɨb ñɨŋ Judia wöxnö yönmɨdöl; nuŋ nöbö nuŋ bla pɨsaŋ mögörɨb Judia yöra röd du Epraim tauna uröpɨnön, mögörɨb rɨg kap rɨb piaku du mɨdmɨdöia. ");
INSERT INTO tmd_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Makwam Juda ada Pasopa wop dib ñɨŋ aku womiöx igöp hömɨdöŋa nugwön, nöbö mö mɨga mögörɨb ñɨŋ keir bla röböxön, an God mämäg il rola nöbö mö lei wä mɨdön, Pasopa ap nɨmɨŋö, rön, mabö adö ñɨŋa maduar ör rɨg rɨmɨdöi mag akuyöbö rɨba Jerusalem dumä. ");
INSERT INTO tmd_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ñɨŋ Jerusalem du nɨgön Jisas hölu nugw mɨdmä. Ñɨŋ duön God höjöpalɨb rama ram möl yuadö du mɨdön, Jisas mɨkai, me rön, nuö nuö yad nugwön yadmä, “Ñɨŋ agö rɨbɨm yöx nugwöi? Nuŋ Pasopa wop kɨ hönɨŋönö wöhö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Makwam God ap höjöpal ur nölɨb nöbö dib bla aipam, Perisi nöbö bla aipam, mönö i yadmä, “Nöbö mö i Jisas nugumɨjön aku, nuŋ hö anɨŋ yadaŋ, an du Jisas nugwo pɨ cɨcɨ nɨgnɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pasopa ap nɨmɨba rɨmä aku wop akuyöbö iŋösu sö mɨdmɨn nugugɨrön, Jisas nuŋ Lasaras wöröxɨm nugwo rɨmɨn öbɨlöŋ nöbö aku rama duöŋa. Ram yöj agrö aku iba Betani. ");
INSERT INTO tmd_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Betani duön, ap nɨmnɨŋö, rön, Jisas Lasaras yöŋö, nöbö mö bli pɨsaŋ, römɨd gɨ mɨdmä nugwön, Mata ap mag bla nuöm nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Pɨgnɨŋ Maria, wel röbö hölɨŋ wä rɨg dib ödöriö woböi balol i pön hön, Jisas yamsö rol aku hör nölön, yöj panö nuŋwa pön Jisas yamsö örɨxöŋa. Almɨdmɨn, wel röbö hölɨŋ wä aku, hölɨŋa ram möl yuadö aku magalɨg duöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Akuyöbö almɨdmɨn, Judas Iskariot, Jisas nöbö nuŋ aku nugwo mai höuöu röŋ nöbö aku, hölɨŋ wä aku nugwön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Rɨg dib ödöriö woböi wel röbö kɨ aliö abön, rɨg pön, nöbö mö ap mɨdöl akuyöbö ñɨgö nölöx aku wä. Nöbö wel röbö aliö akuyöbö wobɨba rɨmɨd aku, nuŋ röun akuyöbö ragpɨd sö mabö rön rɨg pön duön wel röbö kɨ wobönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Nuŋ aliö yadöŋ aku, nöbö mö ap mɨdöl bla uliöxön yadölöŋ; nuŋ rɨg yogw aku rag yönön, bli tar kib pɨmɨd makwam aliö yadöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Makwam Jisas yadöŋa, “Nugwo yadyöxmɨjɨnö. Nɨ hogw piöñ wop aku nɨg nölɨba rag hö nɨg aku, wopik rag hö nɨg nöla. ");
INSERT INTO tmd_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nöbö mö rɨg mɨdöl piaku pɨsaŋ öim mɨjöña; makwam nɨ pɨsaŋ öim mɨdeñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jisas Betani hö mɨdö rim mönö aku nugwön, Juda nöbö mö mɨga nugwo nuguba dumä. Makwam Jisas nugwör nuguba duölim; Lasaras wöröxɨm Jisas rɨmɨn öbɨlöŋ nöbö aku nugwo aipam nuguba dumä. ");
INSERT INTO tmd_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Makwam Lasaras wöröxɨm Jisas nugwo rɨmɨn öbɨlöŋ aku, Juda nöbö mö mɨg mɨŋa mag ñɨŋ rɨg mɨdmɨdöi mag aku röböxön, Jisas nugw pɨmä. Akuyöbö almɨdmɨn, God ap höjöpal ur nölɨb nöbö dib piaku, Lasaras aipam pɨl pal nɨgnɨŋö, rön, rɨb aku yöx nugumä. ");
INSERT INTO tmd_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Löum yöbö, nöbö mö mɨga ödöriö Pasopa ap nɨmɨba hem akuyöbö, Jisas Jerusalem hömɨdö, rim mönö aku nugwön, ");
INSERT INTO tmd_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","nugwo du nugunɨŋö, rön, albad panö röx rag hö papal rɨ gɨrön, wö diba rɨ gɨrön yadmä, “Nöbö Diba ib nuŋwa yadɨŋ adöx sö duaŋ!” “Nöbö Diba nuŋ Nöbö nuŋwa kɨ agal abmɨn hö mɨk!” “Nuŋ Nöbö wä. Ib nuŋwa yadɨŋ adöx sö duaŋ!” “Nuŋ Isrel Kiŋa hömɨd mɨg pal! Ib nuŋwa yadɨŋ adöx sö duaŋ!” ");
INSERT INTO tmd_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jisas hön donki maua i pön, rol aku römɨdön dumɨdöŋa. Akuyöbö alöŋ aku, God Mönö aku kai kɨtön rɨg yadim mag akwör röŋa. God Mönö rɨb aku kai kɨtön yadmä, ");
INSERT INTO tmd_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Saion halöu, nagö ipöxmɨjɨnö. Kiŋ naŋ aku hön donki ha maua rola römɨdön hömɨdö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Alöŋ wop aku, Jisas nöbö nuŋ bla, God nuŋ aliö cönɨŋö röŋ mag akwör rɨmɨd aku, me rön, nugwölim; jɨ mai Jisas wöröxön öbɨlön, God mögörɨb adöx yöd röul adö kau sö wöluöŋ wop akwör, Jisas nöbö nuŋ bla rɨbyöx nugw ri abön nugumä, Jisas Jerusalem dumɨdöŋ wop aku ap agap bɨlɨm nugwo rim piaku, höd God mönö yadɨb nöbö bla God Mönö kai kɨtön yadim mag akwör rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jisas Lasaras wöröxɨm nugwo rɨmɨn öbɨlöŋ aku, nöbö mö nugugu mɨdim bla mönö aku pɨrag adadö dumä. ");
INSERT INTO tmd_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Makwam, nöbö mö mɨga akwör ap rölɨbä röŋ aku nugwön, Jerusalem röböxön, nugwo ödöi mibɨl yöra nuguba dumä. ");
INSERT INTO tmd_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ñɨŋ almɨdim aku, Perisi nöbö akuyöbö nugwön, ñɨŋ keir ör mönö yadön yadmä, “Nugwi! An ap i rɨb maga nɨgöl. Nöbö mö mögörɨb il kɨ magalɨg nöbö aku mai dumɨdöiŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Makwam Pasopa wop aku womiöx hömɨdö, rön, God höjöpalɨba Jerusalem duim wop aku, Grik nöbö mö bli pɨsaŋ dumä. ");
INSERT INTO tmd_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Grik nöbö mö piaku hön, Pilip mögörɨb Galili yöraku Betsaida taun yöbö nöbö aku nugwo yadmä, “Nöbö dib nugub, an Jisas nugunɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Aliö rɨmɨn, Pilip du Edru nugwo yad nölön, Edru pɨsaŋ mösör duön Jisas nugwo yad nölmä. ");
INSERT INTO tmd_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yad nölmɨn, Jisas yadöŋa, “Weik God raŋ, Nöbö Ha nuŋwa Nöbö mil mag wä keiryöbö alɨg mɨd aku nugwöñ wop aku mödö ha. ");
INSERT INTO tmd_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nɨ ñɨgö mɨ ödöriö yadmɨdla, wit mag i mɨgrö bö pɨnön wöröxen aku, hör wit mag paŋyöbö iör mɨjöna. Makwam wit mag aku mɨgrö bö pɨnön wöröxmɨjön aku, mai mogw bɨrön mag mɨga yaxöna. ");
INSERT INTO tmd_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nöbö mö kai, ‘Mögörɨb il kɨ kömö mɨdɨb mag na keir ör rɨbyöx nugwön mɨd ri abnö,’ rön raŋ diön aku, nuŋ wöröxön mɨ aŋadö wöröxöna; jɨ nöbö mö kai, ‘Mögörɨb il kɨ kömö mɨdɨb mag na keir rɨb mɨga yöx nugwöinöm, mɨd ri abnönö mɨd ri aböin aku ap dib yöi,’ me rön raŋ diön aku, kömö mɨdɨb mag nuŋ aku öim öim mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Makwam nöbö mö kai mabö na cɨnö cön aku, nuŋ nɨ mai höŋ; nɨ pikai mɨjɨn aku, mabö rɨ nölɨb nöbö na nɨ pɨsaŋ piaku mɨjöna. Nöbö mö kai mabö na rɨ nöiön, Acö na nöbö aku iba nuŋ aku pɨrag wöliöna. ");
INSERT INTO tmd_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Weik nɨ ömörö rɨmɨd aku pödi yajɨn? ‘Acö nɨ haŋad rɨb gɨ mɨdaŋ, nɨ ap kai rɨba rɨmɨd aku rölaŋ,’ me rön yajɨn owa? Nöi! Ömörö aku pɨba höma. ");
INSERT INTO tmd_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Makwam Acö, nagö raŋ nöbö mö akuyöbö nugwöña, nagö Nöbö mil wä keiryöbö alɨg mɨdlaŋö,” röŋa. Jisas aliö rɨmɨn nugugɨrön, mönö i adöx yöd röul adö kau sebö hön yadöŋa, “Nɨ rɨmön, nöbö mö akuyöbö mödö nugwöia nɨ Nöbö mil mag wä keiryöbö alɨg mɨdla. Makwam nɨ iswob rɨmön, nöbö mö akuyöbö iswob nugwöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Makwam nöbö mö mɨdim akuyöbö, God mönö yadöŋ aku nugwön, bli yadmä, “Gunɨm gigu rɨmɨdö,” rɨmä; bli piöŋö yadmä, “Ejol i Jisas nugwo mönö bli yadmɨdö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Aliö yadmä aku, jɨ Jisas ñɨgö yadöŋa, “Yad mönö aku nɨ me rön yadölöm; ñɨgö me rön yada. ");
INSERT INTO tmd_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Aku agapɨm: weik nöbö mö mögörɨb il kɨyöbö, ñɨŋ agö magɨm röi aku, God nuŋ keir nugwön, paiŋö nölön, ñɨŋ pɨ nuöm nɨg hörɨrör nɨgöna. Nöbö mö mögörɨb il kɨ nɨ nugw pölöi akuyöbö ñɨgö kiŋ röxg nugwidɨx mɨd Nöbö Gwogwo aku, God nuŋ nugwo rɨbɨx aböna. ");
INSERT INTO tmd_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nɨ pɨ bɨl yör sö nɨgöñ aku, nɨ nöbö mö mögörɨb hör piaku piaku magalɨg pɨxɨp pön hön nör pɨnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jisas mönö yadöŋ aku, nɨ agö magɨm rɨŋ wöröxnö, rön, yadöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Makwam nöbö mö mɨga akwör hö mɨdim piaku Jisas nugwo paiŋö yadmä, “Lo mönö an aku yad, ‘Krais aku öim öim kömö mɨjönɨŋö,’ ra aku, jɨ nagö pöd rɨmɨn yadmɨdlö, ‘Nöbö Ha nuŋwa nugwo pɨ bɨl yör sö nɨgöñɨŋö,’ rɨmɨdlö? Makwam Nöbö Ha nuŋ me rön yadmɨdɨl aku, yönɨm yadmɨdlaŋö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Aliö rɨmɨn, Jisas yadöŋa, “Mil mag aku ul mɨŋi alɨg ñɨgö pɨsaŋ mɨjöna. Makwam, mil maga ñɨgö pɨsaŋ mɨd wop kɨ, ödöia yön ri aböña; nöi mɨjön aku, pɨxmaga hön ñɨgö yuö aböna. Nöbö mö kai pɨxmag yuö yönmɨjön aku, pikai dinö rön nugwen. ");
INSERT INTO tmd_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mila ñɨgö pɨsaŋ mɨd wop kɨ, mil aku nugw pöña. Mil aku nugw pɨmɨjöñ aku, mil halöu ha nuŋwa wöxnö nɨgöñɨŋö,” röŋa. Jisas aliö rön, nöbö mö piaku röböxön hör piaku duön umadiö mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jisas nuŋ ap rölɨbä mɨga akwör nöbö mö akuyöbö mämäg il rol ñɨŋa rɨm nugumä jɨ nugwo nugw pölim. ");
INSERT INTO tmd_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nöbö mö Jisas nugw pölim aku, God mönö yadɨb nöbö Aisaia maduar ör God Mönö rɨb mɨŋi kai kɨtön rɨg yadöŋ mag akwör rɨmä. Nuŋ mönö aku kai kɨtön yadöŋa, “Nöbö Dib, mönö wä nagö ñɨŋ yad nölöl aku jɨ ñɨŋ mönö aku mönö wä, me rön, pölöi; nagö ölɨsö mag keiryöbö naŋ keir rön rɨmö aku nugwöi aku, jɨ nagö Nöbö Dib, me rön, nugw pölöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Makwam, ñɨŋ Jisas nugw pölim. Akuyöbö almä aku, Aisaia God Mönö rɨb mɨŋi kai kɨtön rɨg yadöŋ mag akwör rɨmä. Nuŋ mönö aku kai kɨtön yadöŋa, “God nuŋ nöbö mö akuyöbö ñɨgö rɨm, ñɨŋ mämäg we röxg mɨdöia; God nuŋ rɨm, ñɨŋ rɨb mag wä mɨdöl. God nuŋ ñɨgö röŋ aku, ñɨŋ mämäga nugw ri abön, rɨb maga yöx nugw ri abön, nɨ höyɨx aku, nɨ rɨmön ñɨgö kömö nɨgöx, me rön, rɨb aku yöx nugwön, nuŋ nugwogwo rɨm ñɨŋ mämäg we röxg mɨdöiŋö,” röŋa. Adakwör ñɨŋ Jisas nugw pɨb maga nɨgölöŋ. ");
INSERT INTO tmd_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia maduar ör mönö yadöŋ aku, nuŋ Jisas mil mag wä nuŋ aku nugwön aliö yadöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Makwam Juda nöbö dib bla ñɨŋ magalɨg Jisas nugwo röböxölim; nöbö dib mɨga nugwo nugw pɨmä. Jɨ Perisi nöbö anɨŋ yad abɨŋ an Juda mögum rɨb rama ram möl yuadö iswob dub maga nɨgenɨŋö, rön yadmä mönö aku nugwön, Jisas nugw pɨmä aku wöxnö yadölim. ");
INSERT INTO tmd_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Jisas nugw pɨmä aku wöxnö yadölim aku, nöbö mö akuyöbö ib ana yadɨŋ bɨl sö duaŋ, me rɨ rɨbyöx nugwön, aliö almä. Ap agapɨm rɨŋ God nugwaŋ, nugwo wä cönɨŋö, rön, rɨb aku yöx nugwölim. ");
INSERT INTO tmd_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Makwam Jisas ajmöla aj halön yadöŋa, “Nöbö mö kai nɨ nugw pön aku, nör wöhö, nöbö nɨ yad abmɨn höm Nöbö aku nugwo aipam nugw pöna. ");
INSERT INTO tmd_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nöbö mö kai nɨ mämäga nugwön aku, nör wöhö, nöbö nɨ yad abmɨn höm Nöbö aku nugwo aipam mämäga nugwöna. ");
INSERT INTO tmd_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nɨ mögörɨb il kɨ hön nöbö mö bla ñɨgö mila nölmɨdla. Makwam, nöbö mö nɨ nugw pöñ akuyöbö, pɨxmag yuö piaku mɨdeñɨm. ");
INSERT INTO tmd_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Nöbö mö mönö na nugwön rɨg yadmɨdɨl mag akuyöbö reñ aku, ñɨgö mönö diba yadöin. Aku agapɨm: nɨ nöbö mö mögörɨb il kɨ mɨdöi akuyöbö ñɨgö mönö diba yadɨba hölɨm; ñɨgö kömö pɨba höma. ");
INSERT INTO tmd_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Makwam nöbö mö nɨ pölön, mönö na peñ aku, mönö diba yadɨb wop aku, mönö nɨ yadɨl piakwör ñɨgö pɨsaŋ mönö diba yajöna. ");
INSERT INTO tmd_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Aku agapɨm: mönö nɨ yadɨl aku, nɨ hör rɨbyöx nugwön yadöi; Acö nɨ yad aböŋ aku, al aliö akuyöbö yadanö, rɨ akwör yadla. ");
INSERT INTO tmd_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nɨ nugula, mönö nuŋ aku nugw pöñ aku, ñɨgö öim mɨdɨb maga nöiöna. Makwam, mönö nɨ yadmɨdɨl aku, Acö mönö al aliö akuyöbö yadanö, rɨ akwör yadmɨdlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Wop dib Pasopa nɨmɨb wop aku aiaŋ, me rön, Jisas nugwöŋa, Nuö nugwo mögörɨb il kɨ yad nɨgöŋ wop aku padɨxöŋa nugwön nuŋ höbkal Nuö dub wop aku womiöx höŋa. Makwam, nöbö mö nuŋwa keir mögörɨb il kɨ madmag nɨgön mɨdön, mɨdɨp duön, nugwo pɨl pal nɨgɨm, nuŋ wöröxön höuöil Nuö nuŋwa mɨda duöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Kɨjaki nuŋ Saimon Iskariot ha nuŋwa Judas nugwo rɨba nölmɨn, Jisas nugwo pödpöd rön pön duön nöbö dib akuyöbö ñɨgö nöinö, rön, rɨb aku höd ör yöx nugw umad nɨgön, mai an Jisas nöbö nuŋ bla Jisas pɨsaŋ Pasopa ap nɨmɨba römɨdmɨŋa. ");
INSERT INTO tmd_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisas nuŋ nugwa, God nuŋ ap bla magalɨg pɨ imag rol nuŋwa nɨgöŋa. Jisas nugwa, nuŋ Nuö God pɨsaŋ mɨdön mögörɨb il kɨ hön, mɨdön, mai wöröxön, höbkal Nuö mɨda duba rɨmɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Makwam, Jisas öbɨlön, wölɨj mɨxɨl dib nuŋ aku pɨ rödön, raul i höbiöda pal wödön, ");
INSERT INTO tmd_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","röbö bli pɨ ap yöj möl i hörön, anɨŋ nöbö nuŋ bla yamsö an aku röbö pɨlön äbäd ab gɨrön, raul pal wödöŋ aku pɨ möxisa örɨx ab gɨr mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jisas aliö pön du pön du, Saimon Pita yödpɨlö nuŋwa röbö pɨlön äbäd abnö, rɨmɨn, Pita nugwo yadöŋa, “Nöbö Dib. Nagö keir yamsö na aku röbö äbäd abɨba rɨmɨdlanö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Aliö rɨmɨn, Jisas yadöŋa, “Weik rɨmɨdɨl mag kɨ naŋ wopik nugwöia, jɨ mɨdön mai nugunaŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Jisas aliö rɨmɨn, Pita yadöŋa, “Wopik mönö mai piaku, yödpɨlö na aku röbö äbäd aböinö, mɨ wöhö!” röŋa. Aliö rɨmɨn, Jisas paiŋö yadöŋa, “Yamsö nagö röbö äbäd aböin aku, nöbö na mɨdöinaŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Jisas aliö rɨmɨn, Saimon Pita yadöŋa, “Nöbö Dib! Aliö rɨlö aku, yamsö nɨ akwör röbö äbäd abmɨjɨnö; imag, yöcmac na aipam röbö äbäd abö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Aliö rɨmɨn, Jisas yadöŋa, “Nöbö mö kai röbö mödö pal, nöbö aku mɨxɨñ nuŋwa magalɨg leia mɨda. Mɨxɨña alɨg äbäd aben; yamsö wab akwör röbö äbäd ri aböna. Ñɨŋ leia mɨdöia, jɨ ñɨŋ nöbö paŋyöbö iör leia mɨdölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jisas aliö yadöŋ aku, nugwo höuöu rɨba rɨmɨdöŋ nöbö aku nugwo mödö nugwöŋ makwam, nuŋ yadöŋa, “Ñɨŋ nöbö paŋyöbö iör leia mɨdölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Makwam Jisas yamsö anɨŋa röbö äbäd ab pörön, wölɨj pɨ röd nɨgöŋ aku pɨ röbön, du kau nuŋwa römɨdön yadöŋa, “Ñɨgö yamsö röbö pɨlön äbäd abɨl mönö il aku nugwöiŋönö owa?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Jisas aliö rön yadöŋa, “Nɨ Mönö Yad Nölɨb Nöbö mönö Nöbö Dib, me röi aku, mi yadöia. Nɨ Mönö Yad Nölɨb Nöbö ñɨŋ aipam Nöbö Dib ñɨŋ aipam mɨdla. ");
INSERT INTO tmd_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Makwam, nɨ Mönö Yad Nölɨb Nöbö ñɨŋa, Nöbö Dib ñɨŋa yamsö ñɨgö röbö pɨlön äbäd abɨl aku, ñɨŋ algör ör nuö nuö yamsö röbö pɨlön äbäd aböña. ");
INSERT INTO tmd_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nɨ ñɨgö ail mag aku nugwön, ñɨŋ piöŋö du nöbö mö bli paŋ mag akwör cɨnö, rön, ñɨgö ödöi wä kɨ yabula. ");
INSERT INTO tmd_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ñɨgö mɨ ödöriö yadmɨdla, mabö rɨ nölɨb nöbö aku nöbö dib, nugwo nugwidɨx nöbö aku nöbö ulmɨdö mɨdöl; paŋ mag akwör algör mönö pön dub nöbö aku nöbö dib, nugwo agal aböŋ nöbö aku nöbö ulmɨdö mɨdöl. ");
INSERT INTO tmd_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mag wä yadmɨdmön nugwöi adakwör rɨŋ duaŋ, ñɨŋ wahax pöña. ");
INSERT INTO tmd_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“‘Ñɨŋ paŋyöbö iör leia mɨdölö,’ rɨl aku, ñɨgö magalɨg me rön yadöi. Makwam nɨ ñɨgö nöbö na pɨl piaku nugw ri abla. Nöbö i nɨ höuöu rɨba cön nöbö aku, God Mönö aku kai kɨtön rɨg yadim mag akwör cöna. Mönö aku kai kɨtön yadmä, ‘Nöbö nɨ pɨsaŋ ap nɨgiö nɨgön nɨmmɨdmɨŋ nöbö aku, kwolmal röxg nɨgön nɨ rɨ gwogwam rö,’ rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ñɨgö höd, al aliö cönɨŋö, rön yadmɨdɨl mag akuyöbö, mai paŋ mag akwör rɨmɨjön aku, ‘Nɨ Rɨg Mɨdɨl Akwör Mɨdlö’ rɨl mönö aku mönö mɨ, me rön, nugw pöñɨŋö, rön, yadmɨdla. ");
INSERT INTO tmd_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","“Nɨ ñɨgö mɨ ödöriö yadmɨdla, nöbö mö nɨ yad abɨn piaku, nöbö mö bɨl kai ñɨgö pöñ akuyöbö, ñɨgör peñ; nɨ aipam pöña. Makwam nöbö mö bɨl kai nɨ pöñ akuyöbö, nör peñ; Nöbö nɨ yad abmɨn höm Nöbö aku aipam pöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisas mönö aku yadmɨn, höbwab rɨb madmag nuŋwa pɨ ömörö rɨmɨn, yadöŋa, “Ñɨgö mɨ ödöriö yadmɨdla, ñɨŋ nöbö i nɨ mönömɨm cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jisas aliö rɨmɨn, an nöbö nuŋ bla, nöbö kai yadmɨdö, rön, rɨb mɨxɨla yöxön mämäga nuö nuö nugumɨŋa. ");
INSERT INTO tmd_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jɨ Jisas nöbö nuŋ madmag ödöriö nɨgmɨd nöbö aku, Jisas mɨdöŋ il yöra römɨd gɨ mɨdöŋ makwam, ");
INSERT INTO tmd_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saimon Pita nöbö aku nugwo mämäga ipax ipax gɨrön yadöŋa, “Yönɨm nugwo yadmɨd aku yad nugwö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Aliö rɨmɨn, nuŋ Jisas mɨdöŋ il yöra kɨrɨrɨ rɨp duön yadöŋa, “Nöbö Dib. Nöbö aku nöbö kai yadlö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Aliö rɨmɨn, Jisas yadöŋa, “Nɨ bred kɨ pɨ röbö bai bö pɨlön nugwo nöin nöbö aku maku,” me röŋa. Aliö rön, bred mag pɨ gɨ mɨd aku röbö acɨx bö pɨlön, pɨ Saimon Iskariot ha nuŋwa Judas nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas bred mag aku pɨ mag akwör Seten nuŋ Judas yuö nuŋ kwo wölöŋa. Jisas Judas nugwo yadöŋa, “Pödpöd rɨba rɨmɨdlö aku, rɨmɨg rö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Jɨ an Jisas nöbö nuŋ pia, pödpöd rɨmɨn Judas nugwo aliö rɨmɨdö, rön rɨbyöx nugwölmɨŋ. ");
INSERT INTO tmd_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas nuŋ rɨg yogw aku nugwidɨx mɨdmɨd aku, an Jisas nöbö nuŋ bli rɨbyöxmɨŋa, Jisas nuŋ Judas yadön, “Nagö duön Pasopa ap nɨmɨb bli wobanö,” rön, yad abmɨdö, rɨ rɨbyöx nugumɨŋa; an bli rɨbyöxmɨŋa, Jisas nuŋ Judas yadön, “Nagö duön nöbö mö rɨg mɨdöl akuyöbö ñɨgö rɨg bli nölanö,” rön, yad abmɨdö, rɨ rɨbyöx nugumɨŋa. ");
INSERT INTO tmd_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Makwam Judas bred mag aku pön öbɨlön rɨŋö bö röu duöŋa. Ruö mödö pɨxmag guröŋa. ");
INSERT INTO tmd_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas rɨŋö bö röu duöŋa nugwön Jisas yadöŋa, “Womiöx mɨda God nuŋ raŋ nöbö mö bla nugwöña, Nöbö Ha nuŋwa mil mag wä keiryöbö alɨg mɨda. Makwam Nöbö Ha nuŋwa mil mag wä keiryöbö alɨg mɨd aku nugwön, God mil wä nuŋwa aipam nugwöña. ");
INSERT INTO tmd_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Makwam nöbö mö ñɨŋ Nöbö Ha nuŋwa nugw pɨmɨjöñ aku, God mil mag wä keiryöbö alɨg mɨd aku nugwöña. Makwam, rɨb pia God raŋ nöbö mö bla Nöbö Ha nuŋwa mil mag wä keiryöbö alɨg mɨd aku wöxnö nugwöña. ");
INSERT INTO tmd_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Ha madmag yöbö nɨ bɨlɨk! Nɨ ñɨgö pɨsaŋ uplöb mɨdöinöm. Nɨ din aku, nɨ du pikai, me rön, nɨ hölu yualöböña. Makwam Juda nöbö dib bla ñɨgö rɨg yadɨl mag akuyöbö, wopik ñɨgö kwo algör yadmɨdla: nɨ din yöraku, ñɨŋ dubä maga nɨgöl. ");
INSERT INTO tmd_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Makwam weik ñɨgö lo yoŋyöbö i yad nölmɨdla: nuö nuö madmag nɨgöña. Nɨ ñɨgö rɨg madmag nɨgɨl mag akuyöbö, ñɨŋ kwo algör nuö nuö madmag nɨgi. ");
INSERT INTO tmd_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nuö nuö madmag nɨgmɨjöñ aku, nöbö mö bla magalɨg wöxnö nugwöña, ñɨŋ nöbö na mɨdöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Aliö rɨmɨdmɨn, Saimon Pita yadöŋa, “Nöbö Dib. Pikai duba rɨmɨdlö?” röŋa. Aliö rɨmɨn, Jisas yadöŋa, “Nɨ din piaku nagö weik mai ub maga nɨgöl; jɨ mai, nɨ mai dinaŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Jisas aliö rɨmɨn, Pita yadöŋa, “Pödpöd raŋ weik nagö mai duöin? Nagö nugwidɨx mɨjɨna; nɨ pɨl pal nɨgöñ aku, mönö mɨdölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Aliö rɨmɨn, Jisas paiŋö yadöŋa, “Pɨsaŋ wöröxnö rɨlö mönö aku mönö mi yadlanö owa? Nagö mɨ ödöriö yadmɨdla, kulakula mai wö cöna; höd nagö wop mös paŋ yajɨnö, ‘Nɨ Jisas nugwo nugumɨdöiö,’ cɨnaŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Makwam Jisas yadöŋa, “Ñɨŋ rɨb diba yöx nugwön ipöxmɨjeñ. Acö nugwo rɨg nugw pöi mag akuyöbö, nɨ kwo algör nugw pöña. ");
INSERT INTO tmd_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Acö na ram nuŋ aku ram möl mɨga akwör mɨda. Nɨ duön kau ñɨgö röb nɨg pɨdɨlina. Nöi mɨdöx aku, aliö yadöyöx. ");
INSERT INTO tmd_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nɨ du kau ñɨgö röb nɨg pɨdɨluön, hön ñɨgö yölɨŋ pön du, nɨ mɨjɨn yöra ñɨŋ pɨsaŋ paŋör mɨjnɨŋa. ");
INSERT INTO tmd_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nɨ duba rɨmɨdɨl ödöi aku ñɨŋ nugwöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Jisas aliö rɨmɨdmɨn, Tomas yadöŋa, “Nöbö Dib! Nagö pikai dinö aku an nugwölöl. Makwam, an pödpöd rön dub ödöia nugunɨŋ?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Aliö rɨmɨn, Jisas yadöŋa, “Nör ödöi; nör mönö mɨ; nör kömö mɨdɨb ila. Nöbö mö nɨ höñ akuyöbö akwör, Acö pöl höña. Nöbö mö nɨ heñ akuyöbö, Acö pöl heñɨm. ");
INSERT INTO tmd_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nɨ nugw ri aböyɨx aku, Acö na algör nugw ri aböyɨxa. Makwam wopik ñɨŋ Acö mödö nugwöia; mämäg mag ñɨŋa keir Acö mödö nugwöia. ");
INSERT INTO tmd_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Aliö rɨmɨdmɨn, Pilip yadöŋa, “Nöbö Dib! Nagö Acö an yabuan, nugwön, mai ap i nagö yad nugwöinɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Aliö rɨmɨn, Jisas yadöŋa, “Pilip. Nɨ ñɨgö pɨsaŋ mɨxɨl magi mɨdɨm aku, nɨ nugwölön aliö rɨmɨdlanö ä? Nöbö mö nɨ mämäga nugwöi bla, Acö aipam mödö mämäga nugwöia. Makwam, nagö pödpöd rɨmɨn yadmɨdlö, ‘Acö an yabuan nuguŋö,’ rɨmɨdlö? ");
INSERT INTO tmd_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nɨ Acö yuö nuŋ kwo mɨdla, Acö yuö nɨ kwo mɨd mönö aku nugw pöiö ä? Mönö ñɨgö yadmɨdɨl aku mönö nɨ keir yöi. Makwam Acö nuŋ yuö nɨ kwo mɨdön rɨm, an nuarö hogwa mabö nuŋwa akwör rɨmɨdöl aku maku. ");
INSERT INTO tmd_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Makwam, nɨ Acö yuö nuŋ kwo mɨdla, Acö yuö nɨ kwo mɨd mönö aku, mönö mɨ, me rön, nugw pöyɨxa. Jɨ mönö yadɨl aku nugw peñ aku, Acö raŋ an nuarö hogwa ap rölɨbä piaku rɨmɨdöl aku rɨbyöx nugwön, ‘Ha aku Acö yuö nuŋ kwo mɨda, Acö Ha nuŋwa yuö kwo mɨd aku makwam, almɨdöiŋö,’ rön, nugw pöña. ");
INSERT INTO tmd_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Nɨ ñɨgö mɨ ödöriö yadmɨdla, nöbö mö nɨ nugw pɨmɨjöñ bla, nɨ ap rölɨbä rɨl piaku, ñɨŋ aipam algör ör cöña. Makwam nɨ Acö mɨda din aku, ñɨŋ mag aliö akuyöbö reñ; ñɨŋ ap mag keiryöbö cöña. ");
INSERT INTO tmd_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Makwam ñɨŋ nöbö na mɨdöi aku, ib na aku urön, ap agap apɨm yad nugwöñ aku, Acö mil mag wä keiryöbö alɨg mɨd aku nugwɨŋ, me rön, yajöñ mag akuyöbö cɨna. ");
INSERT INTO tmd_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Aku mɨ, ap agap apɨm ib na urön yad nugwöñ aku, rɨg yajöñ mag akwör cɨnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ñɨŋ nɨ madmag nɨgmɨjöñ aku, ñɨgö yadɨl maga akwör cöña. ");
INSERT INTO tmd_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ñɨŋ akuyöbö almɨjöñ aku, nɨ piöŋö Acö nugwo yadmön, nuŋ ñɨgö Höñ Yöra Mɨdɨb Nöbö aku agal abaŋ hön, ñɨgö pɨsaŋ öim öim mɨdön, nɨ ñɨgö rɨ nölmɨdɨl mag akuyöbö, nuŋ ñɨgö algör ör rɨ nöiöna. ");
INSERT INTO tmd_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Höñ Yöra Mɨdɨb Nöbö aku nuŋ mönö mɨ akwör yad nölɨb Inöm aku mɨ. Nöbö mö mögörɨb il kɨ piaku Höñ Yöra Mɨdɨb Nöbö nugwo mämäga nugwölöi; nuŋ nöbö pödiöm mɨd aku nugwölöi. Makwam, nugwo nugw pɨb maga mɨdöl. Makwam weik Höñ Yöra Mɨdɨb Nöbö nuŋ ñɨŋ pɨsaŋ mɨda; mai yuörɨb ñɨŋ kwo mɨjöna. Ñɨŋ nugwo mödö nugwöia. ");
INSERT INTO tmd_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nɨ wöröxön, ñɨgö ha nuö mɨdöl nöbö mö akuyöbö aŋadö röböxöin; nɨ ñɨgö pöl höbkal höna. ");
INSERT INTO tmd_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Womiöx mɨda, nöbö mö mögörɨb il kɨ mɨdöi akuyöbö nɨ nugweñ, jɨ ñɨŋ nɨ nugwöña. Nɨ kömö mɨjɨn aku, ñɨŋ algör ör kömö mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Wop aku nɨ Acö na yuörɨb nuŋ kwo mɨdɨl mönö yadɨm il aku nugw ri aböña. Makwam ñɨŋ yuö nɨ kwo mɨdɨm, nɨ yuö ñɨŋ kwo mɨdɨl il aku algör ör nugw ri aböña. ");
INSERT INTO tmd_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nöbö mö mönö nɨ yadɨl aku nugw pön, rɨg yadɨl mag akuyöbö akwör röi piaku, nɨ madmag nɨgön, aliö alöia. Nöbö mö nɨ madmag nɨgöi piaku, Acö na ñɨgö kwo algör ör madmag nɨgöna; nɨ algör ör ñɨgö madmag nɨgön, nɨ nöbö pödiöm mɨdɨl aku ñɨgö yabumön, ñɨŋ nɨ nugw ri aböñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jisas aliö rɨmɨdmɨn, Judas (Judas nugwo höuöu röŋ aku yöi, Judas hör i) nuŋ Jisas nugwo yadöŋa, “Nöbö Dib. Pödpöd raŋ, nagö nöbö pödiöm mɨdlö aku anɨŋör yabunö, jɨ nöbö mö mögörɨb hör piaku piaku naŋ nugw pölöi piaku ñɨgö yabuöinanö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Aliö rɨmɨn, Jisas yadöŋa, “Nöbö mö kai nɨ madmag nɨgön aku, mönö yadɨl aku pön rɨg yadɨl mag akuyöbö akwör cöna. Acö na nugwo madmag nɨgön, an nuarö nugwo pöl hön, nugwo pɨsaŋ mɨjnɨŋa. ");
INSERT INTO tmd_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nöbö mö kai nɨ madmag nɨgen aku, mönö yadɨl aku pön rɨg yadɨl mag akuyöbö ren. Makwam nɨ yadmön nugumɨdöi mönö aku mönö nɨ keir yöi; Acö nɨ yad abmɨn höm aku, mönö mag nuŋ aku mɨ. ");
INSERT INTO tmd_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nɨ ñɨgö pɨsaŋ mɨdɨl wop kɨ mɨ, mönö kɨ yad nölɨla. ");
INSERT INTO tmd_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nɨ dina jɨ Acö nuŋ Höñ Yöra Mɨdɨb Nöbö aku, Inöm Lei aku, agal abaŋ hön mabö nɨ rɨg rɨl mag akwör cöna. Inöm Leia nuŋ ñɨgö pɨsaŋ mɨdön, mönö wä aku magalɨg yad nöl ri abön, ñɨgö rɨb wä nölaŋ, ñɨŋ nɨ mönö kai kai yadɨl piaku magalɨg rɨbyöx nugu gɨrön mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nɨ dina jɨ ñɨŋ tar mɨd ri ab gɨ mɨjöña. Mönö aku nöbö mö mögörɨb il kɨ piaku hör mönö yadöi akuyöbö yadmɨdöi. Nɨ keir hön rɨmön, nöbö mö tar mɨd ri abɨb maga ra. Makwam, nɨ ñɨgö yadmɨdla, tar mɨd ri ab gɨ mɨjöña. Makwam, höbwab rɨb madmag ömörö pön ipöxmɨjeñ. ");
INSERT INTO tmd_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Nɨ duön höuöil höna, rɨl mönö aku nugwön, ñɨŋ pöd rɨmɨn höbwab rɨb madmag ömörö pɨ gɨrön mɨdöi? Ñɨŋ nɨ madmag nɨgöyɨx aku, Jisas duön Nuö nuŋwa pɨsaŋ mɨdɨba rɨmɨdö, rön, wahax pɨ gɨr mɨdöyɨxa. Aku agapɨm: Acö nuŋ nɨ röxgɨb yöi; Acö nuŋ Nöbö dib. ");
INSERT INTO tmd_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Makwam, ñɨgö röböx duöi mag kɨ, ñɨgö höd yadmɨdɨl maku pal; mai dina aku, ñɨŋ rɨb bli hölu nugweñ; mönö yadmɨdɨl mönö aku nugw pöñɨŋö, rön, yadmɨdla. ");
INSERT INTO tmd_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nöbö mö mögörɨb il kɨ nɨ nugw pölöi piaku ñɨgö kiŋ röxg nugwidɨx mɨd Nöbö Gwogwo aku nuŋ hömɨd aku mɨ, nɨ ñɨgö pɨsaŋ mönö mɨxɨl diba yad mɨdɨb maga nɨgöl. Makwam Nöbö Gwogwo nɨ rɨ gwogwam cɨnö, rɨmɨd aku, ölɨsö nuŋwa mɨdöl. ");
INSERT INTO tmd_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Nɨ Acö na madmag nɨgɨl aku, nöbö mö akuyöbö nugwɨŋ, me rön, Acö nɨ yad mag akuyöbö akwör magalɨg rɨmɨdla. “Makwam wopik höŋ mödö duŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jisas mönö yadön yadöŋa, “Nɨ keir nag wain aku; Acö na möriwö rɨb mɨnöbö aku. ");
INSERT INTO tmd_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Löx pɨlö nɨ i mag yaxen aku, Acö nuŋ löx pɨlö aku römal aböna. Makwam löx pɨlö yaxön aku, mai mag mɨga akwör yaxönɨŋö, rön, nuŋ römaxdör ri aböna. ");
INSERT INTO tmd_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","“Nɨ ñɨgö mönö wä yad nölmön nugwöi aku, ñɨŋ mödö lei wä röxg mɨdöia. ");
INSERT INTO tmd_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ñɨŋ yuö nɨ kwo mɨdɨŋ; nɨ yuö ñɨŋ kwo mɨjɨna. Löx pɨlö bla, ila alɨg nɨgiö nɨgön mɨjön akwör, maga yaxöna; hör ör mɨdön maga yaxen. Mag akuyöbö akwör, ñɨŋ nɨ nɨgiö nɨgön mɨdeñ aku, mag bli yaxen. ");
INSERT INTO tmd_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Nɨ keir nag wain aku, ñɨŋ pɨñ löx bla. Nöbö mö bɨl kai nɨ pɨsaŋ nɨgiö nɨgön mɨjöñ bla, mag mɨga akwör yaxöña; jɨ ñɨŋ ñɨŋ keir mɨjöñ aku, ap i reñɨm. ");
INSERT INTO tmd_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Makwam, nöbö mö bɨl kaim yuö nɨ kwo mɨden aku, nag löx römaxdörɨŋ il bö pɨnön wöröxön mag akuyöbö rɨg mɨjöna; nag löx piaku pɨrag du urɨŋ yöñöna. ");
INSERT INTO tmd_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Makwam ñɨŋ yuö nɨ kwo mɨdön, mönö mag na yuö ñɨŋ kwo nugw pɨ gɨr mɨjöñ aku, ap agap apɨm yad nugwöñ aku, Acö rɨg yajöñ mag akwör cöna. ");
INSERT INTO tmd_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ñɨŋ ap maga magöri maga rɨ yaxön aku, nöbö mö na mɨ ödöriö mɨjöña. Makwam, nöbö mö bla ñɨŋ nugwön, Acö na Nöbö mil mag wä keiryöbö alɨg mɨd aku nugwöña. ");
INSERT INTO tmd_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Acö nɨ mɨ ödöriö madmag nɨg aku, nɨ kwo algör ör ñɨgö mɨ ödöriö madmag nɨgla. Makwam, ñɨŋ nɨ cɨrɨp gɨ mɨdɨŋ, nɨ ñɨgö madmag nɨg gɨr mɨjɨna. ");
INSERT INTO tmd_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nɨ Acö mönö nuŋ aku mai rɨmön, nɨ madmag nɨg gɨr mɨda. Makwam mag akuyöbö akwör, ñɨŋ mönö na aku mai rɨmɨjöñ aku, nɨ ñɨgö madmag nɨg gɨr mɨjɨna. ");
INSERT INTO tmd_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Mönö ñɨgö yadmɨdɨl kɨ, nɨ pödpöd rɨmɨn yadmɨdɨl? Nɨ mɨ ödöriö wahax pɨl mag akuyöbö, ñɨŋ kwo algör ör wahax mɨ ödöriö wahax pɨnö, rön, mönö kɨ yadmɨdla. ");
INSERT INTO tmd_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nɨ ñɨgö mönö ölɨsö i yadmɨdla: nɨ ñɨgö mɨ ödöriö madmag nɨgɨl mag akuyöbö, ñɨŋ kwo algör nuö nuö mɨ ödöriö madmag nɨgɨnö. ");
INSERT INTO tmd_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nöbö i nuŋ nöbö nugub nuŋ bla rɨbyöx nugwön, ñɨgö ñöx nɨgön wöröxön aku, nöbö aku nuŋ nöbö nugub nuŋwa mɨ ödöriö madmag nɨgön aku mɨ, mag akuyöbö cöna. ");
INSERT INTO tmd_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nɨ yajɨn mag akuyöbö cöñ aku, ñɨŋ nöbö nugub na mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Makwam wopik nɨ ñɨgö mabö rɨ nölɨb nöbö nɨ bla yadmɨdöi; ñɨgö nöbö nugub nɨ bla yadmɨdla. Mabö rɨ nölɨb nöbö bla, nugwidɨx mɨdɨb nöbö ñɨŋa, ap ñɨŋ piaku nugwölöi. Makwam nɨ Acö mönö kai kai nɨ yad nöl aku, ñɨgö wöxnö yad nöil aku, ñɨgö nöbö nugub na yadmɨdla. ");
INSERT INTO tmd_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ñɨŋ nɨ pɨnɨŋö rön pölim; nɨ ñɨgö pɨnö rön pɨma. Ñɨŋ duön, ap mag mɨga akwör, ap mag öim öim mɨjön aku yaxönɨŋö, rön, ñɨgö mabö aku yad nɨgla. Ñɨŋ akuyöbö almɨjöñ aku, ib na urön Acö nugwo yad nugwöñ aku, rɨg yad nugwöñ mag akwör cöna. ");
INSERT INTO tmd_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","“Nɨ ñɨgö mönö ölɨsö yadön yadmɨdla, nuö nuö madmag nɨgɨnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jisas nöbö nuŋ akuyöbö ñɨgö mönö bli kwo yadön yadöŋa, “Nöbö mö mögörɨb il kɨ ñɨgö rɨb gwogwo yöx nugwöñ aku, rɨb dib aku yöx nugumɨjeñ; Jisas nugwo höd ölɨsö wölɨm rɨg rɨm mag akuyöbö anɨŋ piöŋö rɨmɨdöiŋö, rön, rɨb aku yöx nugwöña. ");
INSERT INTO tmd_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ñɨŋ nöbö mö mögörɨb il kɨ nɨ nugw pölöi akuyöbö mɨdöyɨx aku, ñɨgö, nöbö mö an, me rön, pɨ madmag nɨgöyɨxa. Nɨ ñɨgö pölɨm wop aku, mögörɨb il kɨ rɨg rɨbyöx nugwöi akuyöbö rɨbyöx nugumɨdim aku, jɨ ñɨgö pɨnö rön pɨmön, nöbö mö na mɨdöia. Makwam mɨ, nöbö mö mögörɨb il kɨ ñɨgö rɨb gwogwo yöx nugwöia. ");
INSERT INTO tmd_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Makwam höd ñɨgö mönö yadɨm aku uplöbmɨjeñ: ‘Mabö rɨ nölɨb nöbö aku nöbö dib, nugwo nugwidɨx mɨd nöbö aku nöbö ulmɨdö mɨdöl.’ Makwam, nöbö mö bli nɨ rɨ gwogwam röi aku, ñɨgö kwo algör ör rɨ gwogwam cöña; nöbö mö bli mönö na nugw pön mai duöi aku, mönö ñɨŋ yad nöiöñ aku algör ör nugw pön mai diöña. ");
INSERT INTO tmd_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ñɨŋ Nöbö nɨ agal abmɨn höm Nöbö aku nugwo nugwölöi makwam, ñɨŋ nöbö na mɨdöi aku nugwön, ñɨgö rɨ gwogwam cöña. ");
INSERT INTO tmd_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Nɨ hön ñɨgö mönö wä yadöyöx aku, ap kib mag gwogwo rön mönö diba yöxölöyɨx. Makwam nɨ hön ñɨgö yad nöl ri abɨm aku, ödöi ñɨŋ dub i mɨdöl; ñɨŋ ap kib mag gwogwo röi aku mödö nugwöia, jɨ wopik ñɨŋ algör ör ap kib mag gwogwo nugwogwo rɨmɨdöia. ");
INSERT INTO tmd_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Makwam nɨ ölɨsö wölɨm nugwöi aku, nör yöi, Acö nugwo aipam rɨb gwogwo yöx nugwöia. ");
INSERT INTO tmd_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nɨ ñɨgö pɨsaŋ mɨdön, ap rölɨbä akuyöbö röyöx aku, ap kib mag gwogwo rön mönö diba yöxölöyɨx. Makwam nɨ hön ap rölɨbä akuyöbö rɨmön, nɨ rɨb gwogwo yöx nugwöi aku, Acö na aipam nugwo rɨb gwogwo yöx nugwöi makwam, mönö diba yöxöña. ");
INSERT INTO tmd_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","“Alöi aku, Depid nuŋ God Mönö aku Juda ada lo an me röi mönö bli kai kɨtön rɨg yadöŋ mag akwör röia. Nuŋ mönö aku kai kɨtön yadöŋa, ‘Mönö il i mɨdölöm wöhö, nɨ hör rɨb gwogwo yöx nugwöiŋö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Makwam nɨ du Acö nugwo yadmön, nuŋ Höñ Yöra Mɨdɨb Nöbö aku nugwo yad abaŋ, nuŋ hön ñɨgö nugwidɨx mɨjöna. Mönö mör yad nölmɨd Inöm aku, nɨ nöbö pödiöm mɨdɨl aku, ñɨgö rɨbyöx nölaŋ, nugwöña. ");
INSERT INTO tmd_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ñɨŋ nɨ pɨsaŋ öim yönmɨdim makwam, ñɨŋ kwo aipam du yönön nöbö mö akuyöbö ñɨgö nɨ nöbö pödiöm mɨdɨl mönö aku yad nölɨŋ duaŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jisas mönö yadön yadöŋa, “Nɨ ñɨgö yadɨl mönö kɨ, nugw ri aböñ aku, mai agapɨm raŋ, nɨ röböxön pɨn bɨceñɨŋö, rön yadla. ");
INSERT INTO tmd_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Makwam ñɨgö Juda mögum rɨb ram akuyöbö yad rɨŋö bö abön, ‘Höuöil hömɨjeñɨŋö,’ cöña. Makwam akwör yöi; mai ñɨgö pɨl pal nɨgɨba cöñ aku, akuyöbö alɨŋ God nugwo wä cönɨŋö, rɨ rɨbyöx nugwöña. ");
INSERT INTO tmd_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Almɨjöñ aku, Acö an nuarö nugwölöi aku, akuyöbö aiöña. ");
INSERT INTO tmd_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nɨ ñɨgö höd, al aliö cönɨŋö, rön yadɨl mönö aku, mai mag aliö akuyöbö rɨmɨjön aku, Jisas an aliö cönɨŋö, röŋ, mag akuyöbö rɨmɨdö, rön nugw ri aböñɨŋö, rön, ñɨgö mönö kɨ yadmɨdla. “Höd nɨ ñɨgö pɨsaŋ mɨdmɨdɨl makwam, ñɨgö mönö aku höd yadölɨm. ");
INSERT INTO tmd_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Weik Nöbö nɨ agal abmɨn höm Nöbö aku höbkal mɨdɨba dumɨdla, jɨ ñɨŋ nöbö i nɨ, ‘Pikai duba rɨmɨdlaŋö?’ rön, yad nugwöl. ");
INSERT INTO tmd_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mönö nɨ kɨ nugwön, madmag ñɨŋa ölɨŋ pɨlɨm, rɨb mɨga yöx nugumɨdöia. ");
INSERT INTO tmd_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Makwam ñɨgö mi yadmɨdla, nɨ din aku, ñɨgö wä cöna. Aku agapɨm: nɨ duöin aku, Höñ Yöra Mɨdɨb Nöbö aku nuŋ ñɨgö pöl hen; jɨ nɨ din aku, nɨ nugwo yad abmön, ñɨgö pöl höna. ");
INSERT INTO tmd_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nuŋ hön, nöbö mö mögörɨb il kɨ mɨdöi akuyöbö ñɨgö rɨb ölɨsö nölaŋ, ñɨŋ ap kib mag gwogwo rön pɨx alɨg mɨdöi il aku nugwön, ñɨŋ pödpöd rön God mämäg il nuŋ yöra kömö wä mɨjöñ il aku nugwön, God ñɨgö mönö diba yajön il aku nugwön, nugwöña. ");
INSERT INTO tmd_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nɨ nugw pölöi aku, Höñ Yöra Mɨdɨb Nöbö aku nuŋ, ñɨgö ap kib mag gwogwo rɨb il aku ödöriö akwör yad nölön, ‘Pɨx alɨg mɨdöiŋö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nɨ höbkal Acö nuŋ mɨdɨba dumön, ñɨŋ nɨ nugweñ makwam, Höñ Yöra Mɨdɨb Nöbö aku nuŋ, nöbö mö akuyöbö ñɨgö God mämäg il nuŋ yöra kömö wä mɨdɨb il aku ödöriar yad nölön, ‘Pɨx alɨg mɨdöiŋö,’ cöna. ");
INSERT INTO tmd_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Makwam nöbö mö mögörɨb il kɨ nɨ nugw pölöi akuyöbö ñɨgö kiŋ röxg nugwidɨx mɨd Nöbö Gwogwo aku, God nuŋ nugwo mönö diba mödö yadöŋ makwam, Höñ Yöra Mɨdɨb Nöbö aku nuŋ, Seten nöbö mö nuŋ bla algör ör mönö diba nugwöñɨŋö, cöna. ");
INSERT INTO tmd_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Mönö na mɨga akwör mɨda, jɨ mönö piaku weik ñɨŋ pɨb maga nɨgöl. ");
INSERT INTO tmd_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Makwam mönö ma yad nölmɨd Inöm aku hömɨjön aku, God nuŋ nöbö pödiöm mɨd mönö mɨ aku magalɨg ñɨgö yad nöl ri aböna. Mönö nuŋ adö bli keir pön yaden; mönö audiöx nugwön mönö akwör yad nöl gɨrön, mai cön mönö adaku ñɨgö yad nöiöna. ");
INSERT INTO tmd_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nuŋ mönö nɨ aku pön ñɨgö yad nöiöna. Nuŋ alaŋ, nöbö mö bla mil mag wä keiryöbö nɨ aku nugwöña. ");
INSERT INTO tmd_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Makwam Acö ap nuŋ agap apɨm mɨd akuyöbö, magalɨg ap na mɨda. Makwam mɨ yadla, ‘Inöma nuŋ mönö na aku pön, ñɨgö yad nöiönɨŋö,’ rɨla. ");
INSERT INTO tmd_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Hör mag ul mɨŋi mɨda nɨ nugweñ; jɨ mai hör mag ul mɨŋi mɨdön, nɨ iswob nugwöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jisas aliö rɨmɨdmɨn, nöbö nuŋ bla ñɨŋ keir ör yadmä, “Mönö yöraku yada, ‘Hör mag ul mɨŋi mɨda, nɨ nugweñ; jɨ mai hör mag ul mɨŋi mɨdön, nɨ iswob nugwöñɨŋö,’ rɨ mönö aku ila mɨkai? Makwam mönö i yada, ‘Nɨ Acö dinö,’ rɨ aku, agö mönöm yad?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Aliö rön, ñɨŋ nuö nuö yad nugw paiŋö yad nugwön yadmä, “‘Hör mag ul mɨŋi’ me rɨ aku, pödpöd rɨmɨn yad? Yad aku an ila nugwölölɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Aliö rön Jisas nugwo yad nuguba rɨmɨdɨm, nuŋ keir nugwön yadöŋa, “‘Hör mag ul mɨŋi mɨda, nɨ nugweñ; jɨ mai hör mag ul mɨŋi mɨdön, nɨ iswob nugwöñɨŋö,’ rɨl mönö aku nugwön nuö nuö yad nugumɨdöi ä? ");
INSERT INTO tmd_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nɨ ñɨgö mɨ ödöriö yadmɨdla, nöbö mö mögörɨb il kɨ nɨ nugw pölöi akuyöbö, ap ñɨŋ keir akuyöbö rɨbyöx nugwön wahax pɨmɨjöña; jɨ ñɨŋ ñɨŋör ögwö yöxön im gör mɨjöña. Im gör mɨjöña, jɨ mai ñɨŋ mɨ ödöriö wahax pɨmɨjöña. ");
INSERT INTO tmd_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mö i ha nɨmɨm nugugɨrön, ölɨŋ höb diba pa, jɨ mai ha yöx pön hö nɨgön, mag aku nuŋ ha kiai yöudöŋdöŋ mögörɨb yörɨk hö aku nugwön, ölɨŋ höb aku uplöbön, wahax pɨ gɨr mɨjöna. ");
INSERT INTO tmd_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ñɨŋ mag aliö akuyöbö, weik madmag ñɨŋa aipam ölɨŋ pɨl mɨda, jɨ mai nɨ iswob nugwön, mɨ ödöriö wahax pɨmɨjöña. Nöbö mö bli hön wahax pɨb ñɨŋ aku peñɨm. ");
INSERT INTO tmd_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Wop maiyöbö aku, ñɨŋ ap i nɨ yad nugweñ. Ñɨgö mɨ ödöriö yadmɨdla, ib na urön Acö nugwo yad nugwöñ aku, rɨg yad nugwöñ mag akwör cöna. ");
INSERT INTO tmd_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ñɨŋ höd ib na urön, Acö nugwo ap i yad nugwölöi. Makwam weik, ib na urön yad nugwɨŋ, rɨg yad nugwöñ mag akwör cöna, nugwön ñɨŋ mɨ ödöriö wahax pɨmɨjöña. ");
INSERT INTO tmd_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Acö mönö nuŋ adaku yadön, öim mönö höd röxön yadɨl aku, jɨ weik womiöx mɨda, mönö akuyöbö yadöin; wöxnö akwör yajɨna. ");
INSERT INTO tmd_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Wop aku haŋ, Acö nugwo yad nugwöñ aku, ib na urön yad nugwɨŋ nugwöna. Ib na urön Acö yad nugwöñ ap aku, nɨ keir ap aku Acö yad nugwöin; ñɨŋ keir ib na urön Acö yad nugwöñ aku, nugwöna. ");
INSERT INTO tmd_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Aku agapɨm: Acö nuŋwör nɨ agal abmɨn höm aku nugw pön, nɨ madmag nɨgöi aku mɨ, Acö nuŋ keir ñɨgö madmag nɨga. ");
INSERT INTO tmd_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Acö pɨsaŋ mɨdön röböxön mögörɨb il kɨ höma; weik mögörɨb il kɨ röböxön höuöil Acö mɨd yöra duön pɨsaŋ mɨjnɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Jisas aliö rɨmɨdmɨn, nöbö nuŋ bla yadmä, “Weik mönö höd röxön yadmɨdöiö; ödöriö mɨ wöxnö yadmɨdlö maku. ");
INSERT INTO tmd_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Wopik an nugwöla, naŋ mönö piaku magalɨg mödö nugulö. Nöbö mö bli mönö yad nugub ñɨŋa mɨjön aku, nagö yad nugwölöi wop akwör, naŋ keir mödö nugwön paiŋö yad nöinö. Ailö aku an nugwöla, nagö God pɨsaŋ mɨdön hömö maku,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Aliö rɨmɨdmɨn, Jisas yadöŋa, “Makwam, ‘An wopik nugw pölɨŋö,’ rɨ rɨbyöx nugwöiŋönö ä? ");
INSERT INTO tmd_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Womiöx hömɨda – jɨ weik mödö hö mɨk – nɨ röböxön ñɨŋ ram hörɨrör duŋ, nɨ keir öñör mɨjɨna. Jɨ nɨ keir öñör mɨdöin; Acö mɨd aku pɨsaŋ mɨjnɨŋa. ");
INSERT INTO tmd_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Makwam ñɨgö mönö yad nölɨl kɨ, ñɨŋ yuö nɨ kwo mɨdön, tar mɨd ri abnö, rön, yad nölɨla. Mögörɨb il kɨ mɨdöi akuyöbö ñɨgö ömörö pɨ nöiöña. Makwam wahax pön rɨb wä yöx nugu gör mɨjöña, ap agap apɨm mögörɨb il kɨ ñɨgö cön aku, nɨ ölɨsö aku magalɨg pɨ wöktaitö möl na aku mödö nɨglö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisas mönö aku yad pörön, laxiö adöx yöd röul adö kau sö nugwön yadöŋa, “Acö. Nɨ yadmö wop aku weik wöxnö nɨga. Makwam, naŋ ran, nöbö mö bla nugwöña, nɨ Ha naŋa mil mag wä keiryöbö alɨg mɨdla; makwam nɨ Ha naŋa rɨmön, ñɨŋ nugwöña, nagö Acö mil mag wä keiryöbö alɨg mɨdlö. ");
INSERT INTO tmd_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Aku agapɨm: nɨ keir yadmö akuyöbö, nöbö mö piaku piaku magalɨg nugwidɨx mɨdön, nöbö mö nɨ yad nɨglö akuyöbö ñɨgö pön, kömö öim mɨdɨb mag aku ñɨgö nöina. ");
INSERT INTO tmd_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nöbö mö ñɨŋ, nagö God mɨ paŋyöbö akwör mɨdlö aku nugwön, nɨ Jisas Krais yad ablö aku nugwöñ nöbö mö akuyöbö, öim öim kömö mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nɨ mögörɨb il kɨ yadmö mabö aku, rɨp duön rɨ pörɨl makwam, nöbö mö mögörɨb il kɨ mɨdöi piaku ñɨŋ nugwöia, naŋ Nöbö mil mag wä keiryöbö alɨg mɨdlö. ");
INSERT INTO tmd_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Makwam Acö. Weik naŋ rɨmɨdaŋ, höd mögörɨb rɨ nɨgölmɨŋ wop aku, an nuarö mil mag wä keiryöbö alɨg mɨdmɨdmɨŋ mag akuyöbö, wopik iswob paŋ mag aliö akwör alɨg mɨjnɨŋa. ");
INSERT INTO tmd_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nöbö mö mögörɨb il kɨ bla bli nɨ nölmö. Nöbö mö piaku, ñɨŋ nöbö mö nagö mɨdmɨdmä aku, jɨ nɨ nölmö. Nagö nöbö pödiöm mɨdlö aku ñɨgö yad nölma. Nɨ mönö wä naŋa ñɨgö yad nölmön, ñɨŋ nugw pön, rɨg yad mag akwör röia. ");
INSERT INTO tmd_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Wopik ñɨŋ mödö nugwöia, nɨ ap agapɨm rɨl piaku, nɨ keir röi. Ñɨŋ nugwöia, agapɨm nɨ nöil aku, mɨ naŋör nɨ nöilö. ");
INSERT INTO tmd_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mönö kai kai nɨ yadmö aku, ñɨgö yad nölmön nugw pöia. Makwam, nɨ höd nagö pɨsaŋ mɨdmɨdöla, nagö nɨ yad abman mögörɨb il kɨ höm mönö aku, nugw pöia. ");
INSERT INTO tmd_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Nɨ ñɨŋör höjöpalmɨdla. Nöbö mö mögörɨb il kɨ nagö nugumɨn ölɨsö wöl bla, nɨ ñɨŋ höjöpalmɨdöi. Nöbö mö nɨ nöilö piakwör, nöbö mö nagö mɨdöi aku, nɨ ñɨŋör höjöpalmɨdla. ");
INSERT INTO tmd_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nöbö mö nɨ bla keir, nöbö mö nagö bla keir yöi. Nöbö mö an nuarö paŋör mɨdöia mɨ. Ñɨŋ röi mag aku nugwön, nöbö mö piaku bli nugwöia, nɨ nöbö mil wä keiryöbö alɨg mɨdla. ");
INSERT INTO tmd_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Makwam wopik nɨ mɨdlö yöra in aku, ñɨŋ keir alɨg mɨjöña. Acö Lei! Ib nagö ölɨsö mag keiryöbö alɨg mɨd ib aku, nɨ kwo algör paŋ ib akwör nöilö. Ib ölɨsö keiryöbö mag nagö aku pön, ñɨgö haŋad röbön, an nuarö nɨgiö nɨgön mɨdöl aku, ñɨŋ mag akuyöbö algör ör nɨgiö nɨgön mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nɨ ñɨgö pɨsaŋ mɨdön, ib ölɨsö nagö nɨ nölmö aku pön, ñɨgö haŋad röbön nugwidɨx mɨd ri abön rɨla. Nöbö i yöm röl. God Mönö kai kɨtön, nöbö i aŋadö hö pɨn palön ölɨŋ höb diba pönɨŋö, rɨmä aku, nöbö akwör hölögɨpöŋa. Alöŋ aku, God Mönö höd rɨg kai kɨtim mag akwör röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Makwam nagö mɨdlö yöra uba rɨmɨdɨl aku, weik metyöbö mag i mögörɨb il kɨ rɨg mɨdla nugwön ñɨŋ nugugu mɨdɨm nugugɨrön, nagö mönö kɨ yadmɨdla. Makwam, nɨ mɨ ödöriö wahax pɨmɨdɨl mag akuyöbö, ñɨŋ kwo algör ör wahax pɨŋ. ");
INSERT INTO tmd_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mönö wä nagö aku ñɨgö yad nölmön nugw pöi aku, nöbö mö mögörɨb il kɨyöbö ñɨgö ölɨsö wölɨm nugwöia. Nöbö mö mögörɨb il kɨ rɨg rɨbyöx nugwöi mag akuyöbö, nɨ kwo algör aliö rɨbyöx nugwöi aku, ñɨŋ kwo algör, nöbö mö mögörɨb il kɨ rɨg rɨbyöx nugwöi mag akuyöbö, ñɨŋ kwo algör aliö rɨbyöx nugwölöi. Aku mɨ, nöbö mö mögörɨb il kɨ ñɨgö ölɨsö wölɨm rɨb gwogwo yöx nugwöia. ");
INSERT INTO tmd_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Makwam ñɨŋ mögörɨb il kɨyöbö pön nagö mɨdlö yöra pön duö, rön, yadmɨdöi; nagö ñɨŋ nugwidɨx mɨdaŋ mögörɨb il kɨ mɨdɨŋ, Nöbö Gwogwo ñɨŋ rɨ gwogwam rölaŋ, me rön, yadmɨdla. ");
INSERT INTO tmd_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nöbö mö mögörɨb il kɨ rɨg rɨbyöx nugwöi mag akuyöbö, nɨ kwo algör aliö rɨbyöx nugwöi aku, ñɨŋ kwo algör, nöbö mö mögörɨb il kɨ rɨg rɨbyöx nugwöi mag akuyöbö, ñɨŋ kwo algör aliö rɨbyöx nugwölöi. ");
INSERT INTO tmd_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mönö nagö aku, mönö ma aku, ñɨgö yad nölaŋ, ñɨŋ leia mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nagö nɨ nöbö mö mögörɨb il kɨ mɨdöi mibɨl kɨyöbö abmö aku, nɨ ñɨgö kwo algör ör nöbö mö mögörɨb il kɨ mɨdöi mibɨl piaku abla. ");
INSERT INTO tmd_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mabö bɨl kai nɨ nöilö aku, nɨ rɨ pöcɨna. Nɨ almɨdla aku, nöbö nɨ bla ñɨŋ nɨ nugwön, an kwo algör God mabö rɨ nölɨb nöbö nuŋwa akwör mɨdɨŋö, rön, mabö ñɨgö kai nöinö aku, ñɨŋ kwo paŋ algör ör rɨ pörɨŋ, me rön, rɨmɨdla. ");
INSERT INTO tmd_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Nɨ nagö höjöpalmɨdɨl kɨ, wopik yadɨl nöbö pik ñɨgör höjöpalmɨdöi; ñɨŋ mönö yad nölɨŋ, nöbö mö bla mönö ñɨŋa nugw pön, nɨ nugw pöñ nöbö mö akuyöbö aipam höjöpalmɨdla. ");
INSERT INTO tmd_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Acö, nagö yuö nɨ kwo mɨdman, nɨ yuö nagö kwo mɨdla. An nuarö nɨgiö nɨgön mɨdöl mag akuyöbö, ñɨŋ magalɨg algör paŋ mag akwör rön an nuarö pɨsaŋ nɨgiö nɨgön mɨdɨŋ. Aiöñ aku, nagör nɨ yad abman höm aku, nöbö mö mögörɨb il kɨ mɨdöi piaku nugw pɨŋ. ");
INSERT INTO tmd_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","An nuö nɨc nɨgiö nɨgön mɨdöl aku, ñɨŋ kwo algör nɨgiö nɨgön mɨdɨŋ, me rön, nagö mil mag wä keiryöbö nɨ nölmö aku, nɨ piöŋö ñɨŋ aipam algör nöila. ");
INSERT INTO tmd_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nagö yuö nɨ kwo mɨdman, nɨ yuö ñɨŋ kwo mɨdmön mönö, ñɨŋ nɨgiö nɨgön paŋör mɨjöña. Almɨdɨŋ mönö, nöbö mö mögörɨb il kɨyöbö nugwöña, nagör nɨ abman höma, nugwön nagö nɨ madmag nɨglö aku, ñɨgö algör ör madmag nɨglö. ");
INSERT INTO tmd_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Acö! Nɨ wä rö aku, nöbö mö nɨ nöilö piaku du nɨ mɨjɨn yöra pɨsaŋ mɨdön, mögörɨb rɨ nɨgölmɨŋ wop aku, naŋ nɨ madmag nɨgön mil mag wä keiryöbö nɨ nölmö aku nugwöña. ");
INSERT INTO tmd_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Acö! Nagö Nöbö kömö wä! Nöbö mö mögörɨb il kɨyöbö naŋ nugwölöi. Nör naŋ nugula. Nöbö mö nɨ kɨyöbö, naŋör nɨ abman höm aku nugwöia. ");
INSERT INTO tmd_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nagö nöbö pödiöm mɨdlö aku, nɨ ñɨgö yad nöila. Mai kwo algör, nagö nöbö pödiöm mɨdlö aku, nɨ ñɨgö yad nöl ri abna. Alön, nɨ keir yuö ñɨgö kwo mɨdmön, nagö nɨ madmag nɨglö aku nugw ri abön, ñɨŋ kwo algör nuö nuö madmag nɨgɨŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisas Nuö nugwo höjöpal pörön, nöbö nuŋ bla pɨsaŋ röbö ulmɨdö Kidron möxön, ir kwo duön, olip yuö dumä. ");
INSERT INTO tmd_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Olip yuö aku Jisas nöbö nuŋ bla pɨsaŋ öim du rɨb gɨ mɨdmɨdöi makwam, Jisas nugwo höuöu rɨba rɨmɨdöŋ nöbö Judas nuŋ möl aku nugw ri aböŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Perisi nöbö bla aipam, God ap höjöpal ur nölɨb nöbö dib bla aipam, Judas nugwo yadmɨn, nuŋ du ami nöbö bli yölɨŋön, God höjöpalɨb rama ömdö nöbö bli yölɨŋön, pön du Jisas mɨdöŋ yöra uröpɨnöŋa. Ñɨŋ nuö nuö pɨlɨb ap bli pön, hötɨkö bli ur pɨragön, hömɨdmä. ");
INSERT INTO tmd_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jisas nugwo ap agapɨm rɨba röŋ aku nugwöŋ makwam, hömɨdmä aku duön yadöŋa, “Yönɨm hölup yönmɨdöi?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Aliö rɨmɨn, yadmä, “Jisas, nöbö Nasaret yöbö aku,” me rɨmä. Aliö rɨmɨn, Jisas yadöŋa, “Nöbö aku mɨ nɨ mɨk,” me röŋa. Jɨ mag aku, nugwo höuöu röŋ nöbö Judas, nuŋ ñɨŋ pɨsaŋ yöraku mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Makwam Jisas, “Nöbö aku mɨ nɨ mɨk,” me rɨm, ñɨŋ höglöm adadö rɨp du pɨn bɨrmä. ");
INSERT INTO tmd_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jisas iswob ñɨgö yadöŋa, “Yönɨm hölup yönmɨdöi?” röŋa. Aliö rɨmɨn, yadmä, “Jisas, nöbö Nasaret yöbö aku,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Aliö rɨmɨn, Jisas yadöŋa, “Ñɨgö maduö yadla, ‘Nöbö aku mɨ nɨ mɨk.’ Nɨ hölu nugw yönöi aku, nöbö kɨyöbö ñɨgö röböxɨŋ duŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Röŋ aku, Jisas höd Nuö nugwo yadöŋ mag akwör röŋa. Nuŋ Nuö yadöŋa, “Acö. Nöbö nɨ nölmö piaku, paŋyöbö i yöm rölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Wop akwör, Saimon Pita yu mɨxɨl ölɨsö rag höŋ aku pugul pön, nöbö i nugwo rɨmɨj mɨrɨx adö aŋadö römal cö gɨ aböŋa. Nöbö aku ib nuŋwa Malkas. Nuŋ God ap höjöpal ur nölɨb nöbö dib ödöriö aku nugwo mabö rɨ nölɨb nöbö nuŋ aku mɨdmɨda. ");
INSERT INTO tmd_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pita almɨdmɨn, Jisas yadöŋa, “Yu mɨxɨl ölɨsö pɨlö aku yöra röbaŋ pɨn duaŋ! Nagö Acö röbö acɨx nɨ nöl aku nɨmöinö, rön nugulö ä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Jisas aliö rɨmɨn nugugɨrön, ami nöbö bla aipam, God höjöpalɨb rama ömdö nöbö bla aipam, Jisas nugwo pɨ cɨcɨ nɨgön, nag nɨg gö nɨgön, ");
INSERT INTO tmd_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ñɨŋ höd Jisas pön Anas mɨdöŋ yöra dumä. Anas nuŋ Kaiapas nɨcmöx nuŋwa. Kaiapas kɨm paŋyöbö aku, God ap höjöpal ur nölɨb nöbö dib ödöriö mabö aku yad nɨgɨm rɨmɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiapas nuŋ höd Juda mönö pɨ nuöm nɨgɨb nöbö bla ñɨgö yadöŋa, “Nöbö paŋyöbö i wöröxaŋ an magalɨg kömö dinɨŋ aku wä cönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Makwam Jisas nugwo alön, pön du Anas rama dumɨdmä nugwön, Saimon Pita, nɨ Jon, anɨŋ mai mai dumɨŋa. God ap höjöpal ur nölɨb nöbö dib ödöriö aku nɨ nugw ri aböŋ makwam, nɨ duön aŋadö ram nuŋwa kula yuadö bö duma; ");
INSERT INTO tmd_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","jɨ Pita nuŋ rɨŋadö hör yör bö mɨdöŋa. Nɨ höbkal hön, mö ubalɨj ila nugwidɨx mɨdöŋ aku nugwo yadön, Pita nugwo yölɨŋön kul yuadö bö dumɨŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Jɨ mö ubalɨj ila nugwidɨx mɨdöŋ aku, Pita nugwön yadöŋa, “Nagö algör ör Jisas nöbö nuŋ i ä?” röŋa. Aliö rɨmɨn, Pita yadöŋa, “Nɨ yöi,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Makwam Kaiapas nugwo mabö rɨ nölmɨdim nöbö bla aipam, God höjöpalɨb rama ömdö nöbö bla aipam, ñɨŋ ij rɨmɨn, rɨn urim rɨn yuö öbɨl gɨ mɨd mau mɨdmä. Pita nugwo algön nör ij rɨmɨn, hö mibɨl yöraku paŋör mɨdön, rɨn yuö mau mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Makwam Anas, God ap höjöpal ur nölɨb nöbö dib ödöriö höd mɨdöŋ aku, Jisas nugwo yad nugwöŋa, “Nöbö naŋ bla nöbö bɨl kai bɨl kai mɨdöi? Nagö mönö bɨl kai nöbö mö yad nöilö?” rɨ nugwöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Aliö rɨmɨn, Jisas paiŋö yadöŋa, “Nɨ mönö bli umadiö yad nölölɨm; nöbö ñɨŋ piaku nugugu mɨdɨm nugugɨrön, Juda mögum rɨb ram bla aipam, God höjöpalɨb ram aku aipam, öim wöxnö yad nöila. ");
INSERT INTO tmd_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Makwam, pödpöd rɨmɨn nɨ mönö yad nugumɨdlö? Nöbö mö mönö yadmön nugugu mɨdim bli pön hön yad nugwö. Mönö bɨl kai yadɨm aku ñɨŋ mɨ nugwöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jisas aliö rɨmɨn, God höjöpalɨb rama nugwidɨx mɨdöŋ ömdö nöbö i, nugwo alguna palön yadöŋa, “Pödpöd rɨmɨn God ap höjöpal ur nölɨb nöbö dib ödöriö aku nugwo mönö akuyöbö yadmɨdlö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Aliö rɨmɨn, Jisas yadöŋa, “Nɨ mönö inakmönö i yadlaŋö, cɨnö aku, mönö inakmönö hörɨl aku nöbö mö kɨyöbö ñɨgö wöxnö yad nölö. Makwam mönö mi yadɨl aku, nagö pödpöd rɨmɨn nɨ pailaŋö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jisas nugwo nag nɨg gö nɨgmä aku mɨdmɨn nugugɨrön, Anas yadmɨn ñɨŋ Jisas nugwo pön du, God ap höjöpal ur nölɨb nöbö dib ödöriö yoŋyöbö aku Kaiapas pön dumä. ");
INSERT INTO tmd_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Makwam Pita nuŋ aliö öbɨl gɨ mɨdön rɨn mau mɨdmɨn nugugɨrön, nöbö bli nugwo yadmä, “Naŋ aipam nöbö nuŋ i mɨdlö ä?” rɨmä. Aliö rɨmɨn, Pita iswob wai nölön yadöŋa, “Nɨ yöi,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Makwam nöbö yöraku Pita rɨmɨja römal cö göŋ aku, nöbö hödɨg rɨb nuŋ i God ap höjöpal ur nölɨb nöbö dib aku nugwo mabö rɨ mɨdöŋa. Nuŋ hön, Pita nugwo yadöŋa, “Nɨ nagö nugula, nagö nöbö aku pɨsaŋ olip yuö mɨdlö ä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Aliö rɨmɨn, Pita iswob wai nölön yadöŋa, “Nɨ yöi,” röŋa. Aliö rɨmɨn nugugɨrön, rɨb pia kulakula wö röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ruö löu mil pörɨm nugugɨrön, Juda ada ñɨŋ Jisas nugwo Kaiapas rama pön, Rom gapman nöbö dib Pailot ram diba pön dumä. Juda ada yadmä, “An Rom nöbö ram möl yuadö kɨ du cölmal cɨnɨŋ aku, anɨŋ pɨx alɨg mɨdön, Pasopa ap nɨmɨb maga mɨdenɨŋö,” rön, rɨŋadö bö mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Makwam, Pailot rɨŋö bö duön yadöŋa, “Nöbö kɨ nugwo agö mönöm mɨdɨm nugwön pön höi?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Aliö rɨmɨn, ñɨŋ yadmä, “Nuŋ ap gwogwo i rölöxisöŋö, nuŋ aliö pön hölölɨx,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Aliö rɨmɨn, Pailot yadöŋa, “Ñɨŋ pön du lo ñɨŋa keir rɨg yad akuyöbö nugwön, mönö diba yajne,” röŋa. Aliö rɨmɨn, Juda ada paiŋö yadmä, “An nöbö mö akuyöbö ñɨgö mönö diba yadön, pɨl pal nɨgɨŋ wöröxɨb lo adaku mɨdöl. Rom gapman ada anɨŋ wöhö röiŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Juda ada aliö rɨmä aku, Jisas nɨ agö magɨm rɨŋ wöröxnö, rön, rɨg yadöŋ mag akwör rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Makwam Juda ada aliö rɨmɨdmɨn, Pailot iswob höbkal ram möl yuadö duön, Jisas haŋ, me rɨm, hömɨn nugwo yadöŋa, “Nagö Juda ada kiŋ ñɨŋ aku mä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Aliö rɨmɨn, Jisas yadöŋa, “Mönö nɨ yad nugumɨdlö aku, ajmöl naŋ aku keir yadmɨdlanö owa nöbö mö bli ajmöl ñɨŋ aku pön yadmɨdlö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Aliö rɨmɨn, Pailot yadöŋa, “Nɨ Juda nöbö yöi. Juda ada nagö piakwör, God ap höjöpal ur nölɨb nöbö dib nagö bla akwör, nagö pön hön imag na nölöia. Naŋ agapɨm rɨman nagö aliö pön höiŋö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Aliö rɨmɨn, Jisas yadöŋa, “Nɨ nöbö mö pön nugwidɨx mɨjɨn aku, kiŋ mögörɨb il kɨ rɨg mɨdöi mag akuyöbö mɨdöinöm. Nɨ mögörɨb il kɨ kiŋ mɨdɨba rɨlöx aku, Juda nöbö mö bla nɨ nag nɨgnɨŋö, rim akuyöbö, nöbö mö nɨ bla öbɨlön ñɨŋ pɨsaŋ nuö nuö pɨlöyɨxa. Makwam nɨ nöbö mö pön nugwidɨx mɨjɨn mag aku keir mɨda; mögörɨb il kɨyöbö wöhö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Jisas aliö rɨmɨdmɨn, Pailot yadöŋa, “Aku, nagö kiŋ i mä?” röŋa. Aliö rɨmɨn, Jisas yadöŋa, “Mɨ nagö yadlö maku pal. Adakwör mɨ, nɨ mögörɨb il kɨ yöx pön höm, dib röxön, mönö ma aku yad nöila. Nöbö mö mönö ma ödöriö pɨnɨŋö, rɨ rɨbyöx nugwöi akuyöbö, mönö na aku pöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Jisas aliö rɨmɨn, Pailot yadöŋa, “Mönö adadö hörɨrör mɨga akwör mɨd aku, an pödpödiö mönö ma ödöriö maku, me rön, nugunɨŋö?” röŋa. Pailot mönö aku yadön, höuöil rɨŋö bö röu duön, Juda ada ñɨgö yadöŋa, “Nɨ nuŋ ap gwogwo i rɨ iöra nugwöi. ");
INSERT INTO tmd_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Makwam an Rom gapman, kɨm aku kɨm aku, Pasopa wop dib aku höm, kɨlabɨs nöbö ñɨŋ i hör yau aböla. Makwam, Juda ada kiŋ ñɨŋ aku, hör yau abmön diönɨŋönö ä?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Aliö rɨmɨn, ajmöla aj halön yadmä, “Nugwo yöi! An Barabas yau abne!” rɨmä. Barabas aku, nöbö mö bla mönö nöl pön duön gapman nöbö pɨsaŋ nuö pɨlmä. ");
INSERT INTO tmd_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Aliö rɨmɨdmɨn, Pailot ami nöbö nuŋ bla yadmɨn, Jisas nugwo naga pön pal höuöilmel rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Aliö palön, ap kaigap alɨg bli pön, kiŋ nɨgöi usaŋ akuyöbö mei rön, Jisas nugwo röb nölön, wölɨj paskwolö mi mɨlkap i röb nölön, ");
INSERT INTO tmd_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","nugwo iswob duön iswob duön yadmä, “Naŋ Juda ada kiŋ ñɨŋa, nagö öim öim mɨdane!” rɨmä. Aliö yad gɨrön, nugwo haŋaj mämäg yuö adö palmä. ");
INSERT INTO tmd_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Makwam Pailot iswob rɨŋö bö duön, Juda nöbö mö ñɨgö yadöŋa, “Nugwi! Nɨ Jisas nugwo pön rɨŋö kɨ hömön ñɨŋ nugwöña, nɨ nuŋ ap gwogwo rɨ il i hölu nugwöiö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Makwam Jisas nugwo usaŋ kaigap alɨg mɨd aku röb rɨ nölön, wölɨj paskwolö mi mɨlkap adö röb nölmä aku alɨg höm nugugɨrön, Pailot ñɨgö yadöŋa, “Nugwo nugune!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Aliö rɨmɨn, God ap höjöpal ur nölɨb nöbö dib bla aipam, God höjöpalɨb rama ömdö nöbö bla aipam, Jisas nugwo nugwön mönö bölölö rön yadmä, “Nugwo bɨ katlö watlö um sö pɨl pal nɨgi! Nugwo bɨ katlö watlö um sö pɨl pal nɨgi!” rɨmä. Aliö rɨmɨdmɨn, Pailot yadöŋa, “Ñɨŋ keir nugwo pön duön, bɨ katlö watlö um sö pɨl pal nɨgi. Nɨ ap gwogwo rɨ ila hölu nugwöiö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Aliö rɨmɨn, Juda ada yadmä, “Nuŋ, ‘Nɨ God Ha nuŋ,’ me ra aku, lo an i yada, ‘Wöröxaŋ,’ me rö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Aliö rɨmɨn, Pailot nugwön, mɨ göj ipöxön, ");
INSERT INTO tmd_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","höuöil ram möl yuadö duön, Jisas nugwo yad nugwön yadöŋa, “Nagö mögörɨb pikai yöbö?” röŋa. Aliö rɨmɨn, Jisas mönö i paiŋö yadölöŋ. ");
INSERT INTO tmd_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pailot yadöŋa, “Naŋ nɨ mönö i yadöinö ä? Naŋ nugulö, nɨ nagö nugwidɨx mɨdla. Makwam, nagö yau abnöb yau abna; nagö bɨ katlö watlö um sö pɨl pal nɨgɨŋ, me rɨmön, pɨl pal nɨgɨŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Aliö rɨmɨn, Jisas yadöŋa, “Naŋ nɨ nugwidɨx mɨdlö aku, naŋ keir yöi, God nagö yadmɨn nugwidɨx mɨdlö. Makwam, nɨ rɨ gwogwam rɨmɨdlö ömörö aku naŋör pöinam; nɨ pön nagö nöl nöbö aku mɨ ölɨŋ höb diba pönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Jisas aliö rɨmɨn, Pailot nugwo hör yad abnö, rön, rɨbyöx nugwöŋa, jɨ Juda ada nugwo bölölö rɨ yadön yadmä, “Nagö Jisas nugwo yau abmɨjɨnö aku, Rom nöbö dib Sisa nöbö nugub nuŋwa mɨdöinö. Nöbö, nɨ kiŋ mɨdlö, röi piaku, Sisa pɨsaŋ nuö nuö pinɨŋö, rön, mönö akuyöbö yadöiŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Aliö rɨmɨdmɨn, Pailot mönö aku nugwön, du Jisas nugwo yölɨŋ rɨŋö bö hön, nuŋ du mönö pɨ nuöm nɨgɨb nöbö hogw rol yör sö rim rol aku römɨdöŋa. Kau römɨdöŋ aku, “Rɨg Ödöi” me röia. Makwam Arameik mönö nɨgön, “Gabata” me röia. ");
INSERT INTO tmd_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Makwam wop aku, Juda nöbö mö Pasopa ap aŋalön pɨdɨlub wop ñɨŋ. Naiö mibɨl yör kɨpisö mag aku, Pailot ñɨgö yadöŋa, “Kiŋ ñɨŋ aku mɨk!” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Aliö rɨmɨn, ajmöl aj halön yadmä, “Nugwo pɨl pal nɨgö! Nugwo bɨ katlö watlö um sö pɨl pal nɨgö!” rɨmä. Aliö rɨmɨn, Pailot yadöŋa, “Kiŋ ñɨŋ kɨ bɨ katlö watlö um sö pɨl pal nɨgɨnö ä?” röŋa. Aliö rɨmɨn, God ap höjöpal ur nölɨb nöbö dib bla yadmä, “Kiŋ an i mɨdöl; Rom nöbö dib Sisa akwör mɨdö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Makwam aliö yadɨp dumɨdmɨn, Pailot mönö ñɨgö aku pön, ami nöbö bla ñɨgö yadöŋa, “Jisas nugwo pön du bɨ katlö watlö um sö pɨl pal nɨgɨŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jisas nugwo pɨl pal nɨgɨŋö rim bɨ katlö watlö wab aku, Jisas nuŋ keir nölmɨn, nuŋ pɨrag pɨd nɨg rag “Nöbäpö Yöcmac Yöj Lei” me röi pɨda duöŋa. Pɨd aku, Arameik mönö nɨgön “Golgota” me röia. ");
INSERT INTO tmd_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Jisas nugwo bɨ katlö watlö um sö cɨpɨl pal nɨgön, nöbö mös, i adöi, i adöi, pɨl pal nɨgmä. Jisas mibɨl yöra mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailot yadmɨn, nöbö nuŋ bla bäpö i pön kai kɨtön, Jisas nugwo pɨl pal nɨgim bɨ katlö watlö waba höñ sö yöcmac yöra pikwo audiö nɨgmä. Kai kɨtim mönö aku: ");
INSERT INTO tmd_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Mönö paŋyöbö adakwör, Arameik mönö kai kɨtön, Latin mönö kai kɨtön, Grik mönö kai kɨtön rɨmä aku, Jerusalem il yöraku mɨdöŋ aku, Juda nöbö mö mɨga akwör mämäga nɨg nugumä. ");
INSERT INTO tmd_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Makwam God ap höjöpal ur nölɨb nöbö dib bla du Pailot nugwo yadmä, “Mönö kai kɨtlö aku wä röl. ‘Juda ada kiŋ ñɨŋa’ mönö aku mɨdenɨm; hör yadö, ‘Nuŋ keir yada, “Nɨ Juda ada kiŋ ñɨŋa mɨdlö,” rö,’ mönö akwör kai kɨtö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Aliö rɨmɨdmɨn, Pailot paiŋö yadöŋa, “Nɨ mönö pödiö kai kɨtɨl aku, aliö akwör mɨjönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Makwam Jisas nugwo bɨ katlö watlö um sö pɨl pal nɨgön, ami nöbö mös mös Jisas wölɨj nuŋ bla nuöm hörɨrör nɨg pön, wölɨj mɨlkapa rön lɨdɨxölim aku, algör ör nuöm nɨg pɨba yadmä, ");
INSERT INTO tmd_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","“Pɨ waglöxöinɨŋ! Hör höbai sadu röxg wobön, nöbö kai pön aku nuŋ pönɨŋö,” rɨmä. Alim mag akuyöbö, God maduar ör nöbö mö bla ñɨgö rɨbyöx nölmɨn, God Mönö aku kai kɨtön, mai aiöñɨŋö, rɨmä aku makwam, mai paŋ mag akwör rɨmä. Mönö aku kai kɨtön yadmä, “Wölɨj na aku nuöm nɨg hörɨrör pön, wölɨj mɨlkap na aku, höbai sadu röxg wobön pöiŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Makwam wop aku, Jisas nuöm aku, nobnɨŋ aku, Klopas mönɨŋ Maria aku, Maria Magdala aku, ñɨŋ hön Jisas nugwo bɨ katlö watlö um sö pɨl pal nɨgim il yöra hör hör yörkwo mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nɨ Jon, Jisas nɨ madmag nɨgmɨd nöbö aku, algör ör il yöra mɨdɨm makwam, Jisas nɨ nugwön, nuöm Maria nugwo yadöŋa, “Mö mɨg, ha naŋa maku pal,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Aliö rön, nuŋ piöŋö nuöm Maria nugwön nɨ yadöŋa, “Nam naŋa maku pal,” röŋa. Aliö rɨmɨn nugugɨrön, wop aku, Jisas nuöm nugwo yölɨŋ pön ram na du nɨgön, pɨsaŋ mɨdmɨdöla. ");
INSERT INTO tmd_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jisas nugwöŋa, mabö nuŋ adaku magalɨg rɨ pöröŋ makwam, God Mönö yadöŋ aku mönö ma nɨgaŋ, me rön, yadöŋa, “Nɨ iröpa ub rö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Makwam röbö wain acɨx balol i rag hö yöraku nɨgɨm mɨdöŋ makwam, ami nöbö i, ap höx wab i pön, wain acɨx aku pɨlön, pɨ bɨ hisop löx rɨba idu pɨlön, rag hö Jisas ajmöl cuep uñ röula nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jisas röbö wain acɨx aku nɨmön yadöŋa, “Rɨba pörö,” rön, iröpa ubɨlön, inöm nuŋwa God nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Makwam Juda nöbö dib bla, iŋösu wop aku pɨgö pɨgö mɨdöŋ mag aku mödö hömɨdmɨn nugwön yadmä, “Löuaŋ God höjöpalɨb wop an aku, nöbäpö bla bɨ katlö watlö höñ sö mɨdölɨŋ,” me rön, du Pailot nugwo yadmä, “Nöbö bɨ katlö watlö höñ sö pɨl pal nɨgöi piaku, ami nöbö bla yödpɨlö ñɨŋ bla pal gɨlɨxɨŋ, rɨmgör wöröxɨŋ, pɨ il bö nɨgɨŋ,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Aliö rɨmɨn, Pailot ami nöbö piaku ñɨgö yadmɨn, du nöbö Jisas pɨsaŋ pɨl pal nɨgim hogwa, yödpɨlö ñɨŋ bla pal gɨlɨxmä. ");
INSERT INTO tmd_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jisas yödpɨlö nuŋ aku pal gɨlɨxŋö, rön du nugumɨn, nuŋ mödö wöröxöŋa. Alöŋ aku makwam, yödpɨlö nuŋ aku pal gɨlɨxölim. ");
INSERT INTO tmd_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Jɨ ami nöbö i, nugwopö i pön, Jisas nugwo señ palö pɨnmɨn nugugɨrön, rɨb pia haña röbö alɨg pɨnöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Makwam, ñɨŋ nöbö mö mönö kai kɨtmɨdɨl kɨ nugwöñ piaku aipam, Jisas nugw pɨne, rön, nɨ Jon, Jisas nugwo röŋ aku mämäg na keir nugul aku, ñɨgö mönö mɨ ödöriö kɨ yadön döŋö, kai kɨtmɨdla. ");
INSERT INTO tmd_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Makwam alöŋ aku, God maduar ör nöbö mö bla ñɨgö rɨbyöx nölmɨn, God Mönö aku kai kɨtön, mai akuyöbö aiöñɨŋö, rim makwam, mai mag aliö akuyöbö akwör rɨmä. God Mönö aku kai kɨtön yadmä, “Yöd nuŋwa i pal gɨlɨxeñɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Makwam mönö i yadmä, “Nöbö nugwo nugwo pɨlöi bla, nugwo nugwöñɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nöbö Arimatia taun yöbö i, Jisas mönö maga nugw pöŋ aku, jɨ Juda nöbö dib ñɨgö ipöxön, Jisas nugw pɨlö, rön, wöxnö yadmɨdöl. Nöbö aku ib nuŋwa Josep. Nuŋ Jisas nugwo pön du hogw pinö, rön, du Pailot nugwo yad nugumɨn, yöwö rɨm, pɨrag duöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimas nuŋ Josep pɨsaŋ dumä. Nikodimas nuŋ höd du Jisas nugwo pɨxmag yuö bö nugwöŋ nöbö aku. Nikodimas ap hölɨŋ wä höb mɨga akwör, kilo akuyöbö padokwo padök paŋyöbö i höuöiliö hö wölu möl sö (35) pön duöŋa. Ap hölɨŋ wä höb aku, bɨ mö bɨñugw aku aipam, bɨ alos bɨñugw aku aipam pön rɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Makwam ñɨŋ mös du nöbäpö högi aku pɨ lɨbɨx rɨ rag pɨnön, Juda nöbö mö rɨg rɨmɨdöi mag akuyöbö, bɨ bɨñugwa pɨrag duöŋ aku, nöbäpö högi akuyöbö nɨn kapa pugul nölön, linɨn pɨ wölɨj lei rim ulmɨdö mɨxɨl aku pön, wobmä. ");
INSERT INTO tmd_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jisas bɨ katlö watlö um sö pɨl pal nɨgim il yöra möriwö i mɨdöŋa. Möriwö aku mibɨl yöra rɨg möl yöudöŋdöŋ ör yöluön, nöbäpö hogw pɨlölim i mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Juda ada God höjöpalɨb wop ñɨŋ aku womiöx womiöx röŋ aku, yadkap hogw pɨlɨŋö, rön, rɨg möl hör il yöraku hogw pɨlmä. ");
INSERT INTO tmd_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sade wop aku, ruö löuba rɨmɨn nugugɨrön, Maria Magdala nöbäpö hogw pɨlim möla duön nugwöŋa, rɨg dib nöbäpö hogw möla idɨx gim aku, kɨrɨrɨ rɨ du gägäp adö mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nuŋ nugwön, höbkal ipalɨp hö Saimon Pita an mɨdmɨŋ yöraku hön yadöŋa, “Nöbö Dib aku nugwo tar pɨrag duöia; jɨ rag hö nɨgöi yöra nugwölölɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","4","Aliö rɨmɨn, Pita an yöŋö nuguba rɨmgör ipalɨp dumɨŋa. Nɨ höd duön, ");
INSERT INTO tmd_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","rɨŋadö bö ör mɨdön, rɨg möl sö amnɨmab nugumön wölɨj wab bla akwör mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","7","Makwam Saimon Pita nuŋ mai hön, rɨg möla yuadö duön nugwöŋa, Jisas nugwo ap uñ wobön alɨg nɨgim akuyöbö yauölöŋ; rɨg hogw pɨlim aliö akwör mɨdöŋa. Wölɨj yöcmac sö pal wöd wob gim aku, algör yauölöŋ; rɨg pal wöd wob gim akwör öröu hör yöra mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nɨ höd nöbäpö hogw pɨlim yöra uröpɨnma, jɨ wopik nɨ algör rɨg möla yuadö duön nugumön, wölɨj bla wobön rɨgim akwör mɨdöŋ makwam, aku mɨ Jisas öbɨlö, rön, nugw pɨma. ");
INSERT INTO tmd_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Makwam wop aku, God Mönö kai kɨtön, Jisas wöröxön öbɨlönɨŋö, rim mönö aku, an nugw ri abölmɨŋ. ");
INSERT INTO tmd_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Aliö nugwön höbkal rama dumɨŋa. ");
INSERT INTO tmd_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","12","Makwam Maria nöbäpö hogw pɨlim hogw möl aku rɨŋadö yöra öbɨl gɨ mɨdön im gɨr mɨdöŋa. Im gɨr mɨd gɨrön, höglöma wei hölön rɨg möl sö amnɨmab nugumɨn, ejol wölɨj lei röbim hogwa, Jisas nöbäpö högi höd mɨdöŋ kau aku römɨd gɨ mɨdön, i yöcmac adö sö, i yödpɨlö adö bö mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ejol hogw aku Maria nugwo yadmä, “Pödpöd rɨmɨn immɨdlaŋö?” rɨmä. Aliö rɨmɨn yadöŋa, “Nöbö Dib na aku nugwo pön du pikai nɨgöi aku nugwöiö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Aliö rön, höuöiliö nugumɨn, Jisas öbɨl gɨ mɨdöŋa. Jɨ nugwo nugumɨn, nöbö aku nöbö hör i röxg mɨdöŋa. Jisas nugwöŋ aku, jɨ aku Jisas ör, me rön, nugwölöŋ. ");
INSERT INTO tmd_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jisas piöŋö Maria nugwo yadöŋa, “Mö mɨg. Pödpöd rɨmɨn immɨdlö? Yönɨm hölu nugumɨdlö?” röŋa. Aliö rɨmɨn, Maria rɨbyöx nugwöŋa, möriwö mabö rɨb nöbö akwör nɨ yadmɨdö, rön, rɨbyöx nugwöŋa. Aliö rɨbyöx nugwön yadöŋa, “Nöbö dib nugub. Nöbäpö aku pɨrag dulö aku, pikai nɨglö aku nɨ yadan, pɨrag dinö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Aliö rɨmɨn, Jisas yadöŋa, “Maria!” röŋa. Aliö rɨmɨn, Maria, Arameik mönö nɨgön, “Rabonai!” röŋa. Mönö yadöŋ aku, “Mönö Yad Nölɨb Nöbö.” ");
INSERT INTO tmd_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Aliö rɨmɨn, Jisas yadöŋa, “Nɨ mögörɨb il kɨ röböxön, höbkal Acö mɨd yör sö duöi aku, nɨ pɨ gɨ mɨdölö. Makwam nagö duön, haul nöbö nɨ bla ñɨgö yadö, ‘Jisas yada, “Nɨ Acö nɨ, Acö ñɨŋa, God nɨ, God ñɨŋa mɨd yöra höbkal dumɨdlö,” rö,’ rane,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Jisas aliö rɨmɨn, Maria Magdala du Jisas nöbö nuŋ bla ñɨgö yadöŋa, “Nɨ Nöbö Diba nugwo nugwön hömɨdlö,” röŋa. Aliö rön, Jisas agö mönö bɨlɨm yadöŋ aku, Maria nuŋ Jisas nöbö nuŋ pia mönö aku yad nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Makwam Sade wop aku, naiö rödɨp duöŋa nugwön, nöbö nuŋ bla Juda nöbö dib akuyöbö ipöxön, ram möla duön ubalɨj aku wöl gö nɨgön, tar mɨdmä nugwön, Jisas hö mibɨl yöraku wöxnö nɨgön yadöŋa, “God ñɨgö nugwidɨx mɨdaŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Jisas aliö rön, imag wab nuŋwa ñɨgö yabuön, mɨxɨñ señ nuŋwa yabuöŋa. Nöbö nuŋ bla nugwön, aku Nöbö Dib akwör, me rön, mɨ ödöriö wahax pɨmä. ");
INSERT INTO tmd_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jisas piöŋö ñɨgö iswob yadöŋa, “God ñɨgö nugwidɨx mɨdaŋ. Acö nɨ yad abmɨn hön mabö nuŋwa rɨl mag akuyöbö, ñɨgö piöŋö aipam yad abmɨdlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Aliö rön, ñɨgö pɨr gɨrön yadöŋa, “Inöm Leia pi. ");
INSERT INTO tmd_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nöbö mö ap kib mag gwogwo röi mag bla nugwön röböxöñ aku, God nuŋ kwo algör ör ap kib mag gwogwo ñɨŋa nugwön röböxöna. Jɨ ap kib mag gwogwo röi mag bla nugwön röböxeñ aku, God nuŋ kwo algör ör ap kib mag gwogwo ñɨŋa nugwön röböxenɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Makwam Jisas hö wöxnö nɨgön ñɨgö mönö yadöŋ wop aku, nöbö nuŋwa Tomas, ib i Ha Wab me röi aku, ñɨgö pɨsaŋ mɨdölöŋ. ");
INSERT INTO tmd_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Makwam, mai Jisas nöbö nuŋ bli Tomas nugwo yadmä, “Nöbö Dib aku nugwölɨŋö,” rɨmä. Aliö rɨmɨn, nuŋ paiŋö yadöŋa, “Aliö yadmɨdöi aku, jɨ imag nuŋwa cɨpɨl palim aku aipam, señ nugwo pɨlim aku aipam, mämäg na keir nugwön imag na pɨ nugun aku makwam, mönö aku nugw pön, öbɨlö, rön nugw pɨna; nöi mɨjön aku, wöhö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Aliö rön, iŋpɨlö paŋyöbö i mɨdön, Jisas nöbö nuŋ bla Tomas pɨsaŋ iswob ram möla mɨdmä. Ubalɨj wöl gö nɨgmä aku, jɨ Jisas nuŋ hö mibɨl yöraku wöxnö nɨgön yadöŋa, “God ñɨgö nugwidɨx mɨdaŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Jisas aliö rön, Tomas nugwo yadöŋa, “Imag nagö aku, nɨ cɨpɨl palim yörɨk pɨ nugwö. Imag na nugwö. Señ nɨ nugwo pɨlim yörɨk aipam pɨ nugwö. Rɨb diba yöxölön, nɨ nugw panö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Aliö rɨmɨn, Tomas yadöŋa, “Nöbö Dib nɨ, God nɨ!” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Makwam Jisas nuŋ Tomas nugwo yadöŋa, “Nɨ wöxnö nɨgmön nugwön mönö, nɨ nugw pɨlö. Makwam nöbö mö nɨ wöxnö nɨgmön nugwölön, nɨ nugw pɨmɨjöñ piaku, mɨ ödöriö wahax pɨmɨdɨŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Makwam mönö kai kɨtmɨdɨl kɨ, an Jisas nöbö nuŋ bla nugugu mɨdmɨn nugugɨrön, Jisas ap rölɨbä hörɨrör mɨga akwör rɨmɨd piaku, magalɨg kai kɨtöi. ");
INSERT INTO tmd_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Makwam ñɨŋ, Jisas nuŋwör Krais aku, God Ha nuŋwa ödöriö akwör, me rön, nugwo nugw pɨŋ, ñɨgö paŋ, nugwo pɨsaŋ kömö mɨjöñɨŋö, rön, mönö kɨ kai kɨtla. ");
INSERT INTO tmd_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Makwam mai an Jisas nöbö nuŋ bla Ban Yuö Taibirias yöraku mɨdmɨn nugugɨrön, Jisas nuŋ wöxnö nɨgmɨn nugumɨŋa. Agapɨm rɨg röŋ aku yadɨba rɨmɨdla. ");
INSERT INTO tmd_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita aku, Tomas aku (ib i Ha Wab me rɨmɨdöi aku), Nataniel Kena taun, mögörɨb Galili yuadö yöbö nöbö aku, Sebedi ha Jems an hödpɨg nöbö hogwa aku, Jisas nöbö nuŋ mös aipam pɨsaŋ, nɨgiö nɨgön du Ban Yuö Taibirias yöra mɨdmɨŋa. ");
INSERT INTO tmd_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Pita anɨŋ yadöŋa, “Nɨ dölöm pɨba dumɨdlö,” röŋa. Aliö rɨmɨn, “An pɨsaŋ dinɨŋö,” rön, du nugwo pɨsaŋ röbö alebö pön, rɨp yönmɨdɨm yönmɨdɨm ruö löuöŋa jɨ dölöm bli pölmɨŋ. ");
INSERT INTO tmd_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Makwam naiö wölɨba rɨmɨn nugugɨrön, Jisas hö ban yuö pö halai rola öbɨl gɨ mɨdöŋa. Nugwo nugumɨŋa jɨ aku Jisas ör me rön nugwölmɨŋ. ");
INSERT INTO tmd_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Nuŋ an yadöŋa, “Ha ruai. Ñɨŋ dölöm pɨba rɨp yön wöhö nugwöiŋönö ä?” röŋa. Aliö rɨmɨn, an yöwö rɨmɨŋa. ");
INSERT INTO tmd_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Aliö rɨmɨn, Jisas nuŋ an yadöŋa, “Uben aku pɨ röbö alebö imag mɨrɨx pɨlö adö abön, dölöm bli pöñɨŋö!” röŋa. Aliö rɨmɨn, uben aku pɨ röbö yuö bö abön, dölöm mɨga akwör pön, pɨxmɨn höb maga rölöŋ. ");
INSERT INTO tmd_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Almɨdmɨn, nɨ Jon, Pita nugwo yadma, “Nöbö aku Nöbö Dib akwör,” me rɨma. Aliö rɨmön, Pita nugwön, wölɨj nuŋwa yöraku nɨgöŋ aku pɨ höbiöda pal wödön, mämäliö röbö yuö bö pɨñɨröŋa. ");
INSERT INTO tmd_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","An nöbö bli röbö alebö rola mɨdön, uben dölöm alɨg hö wölön mɨdöŋ aku, pɨxɨp hö, pad piaku yöi, mita akuyöbö padokwo padök mös mös höuöiliö hö wölu amñaxɨb sö (100) ör, röbö cakö yöra hömɨŋa. ");
INSERT INTO tmd_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Cakö yöraku hön nugumɨn, rɨn yuö bɨca pɨnöŋ bɨc rola dölöm bli yön mɨdöŋa. Bred bli algör mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Makwam Jisas anɨŋ yadöŋa, “Dölöm weik pöi akuyöbö bli pön höi,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Aliö rɨmɨn, Saimon Pita röbö alebö rola duön, nuŋ pɨsaŋ uben dölöm mɨga akwör (153) mɨdöŋ aku rɨg jɨmi döula pɨxɨp hömɨŋa. Uben aku ömörö röŋa jɨ ödörölöŋ. ");
INSERT INTO tmd_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jisas nuŋ anɨŋ yadöŋa, “Hön ap nɨmi,” röŋa. An möigw yöxön, nagö nöbö kai hön mɨdlö, rön, nugwo yad nugwölmɨŋ; aku Nöbö Dib akwör, me rön, nugwön röböxmɨŋa. ");
INSERT INTO tmd_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jisas nuŋ du bred aku pön, pɨ nuöm nɨg an nölön, dölöm aipam pɨ nuöm nɨg an nölɨm, nɨmɨmɨŋa. ");
INSERT INTO tmd_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Makwam Jisas wöröxön öbɨlön, anɨŋ nöbö nuŋ bla wop mös paŋ wöxnö nɨgmɨn nugwo nugumɨŋa. ");
INSERT INTO tmd_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Makwam an ap nɨm pörön, Jisas Saimon Pita nugwo yad nugwöŋa, “Saimon Jon ha nuŋwa. Nöbö kɨyöbö wöhö; nagö nɨ mör madmag nɨgmɨdlö ä?” röŋa. Aliö rɨmɨn, Pita yadöŋa, “Nöbö Dib. Nɨ nagö madmag nɨgmɨdɨl aku mɨ, nagö nugulö maku pal,” röŋa. Aliö rɨmɨn, Jisas yadöŋa, “Sipsip as nɨ bla, nugwidɨx mɨdane,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jisas aliö rön, iswob yad nugwöŋa, “Saimon Jon ha nuŋwa. Nagö nɨ mör madmag nɨgmɨdlö ä?” röŋa. Aliö rɨmɨn, Pita yadöŋa, “Nöbö Dib. Nɨ nagö madmag nɨgmɨdɨl aku mɨ, nagö nugulö maku pal,” röŋa. Aliö rɨmɨn, Jisas yadöŋa, “Sipsip nɨ bla nugwidɨx mɨdane,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jisas iswob nugwo yad nugwöŋa, “Saimon Jon ha nuŋwa. Nagö nɨ mör madmag nɨgmɨdlö ä?” röŋa. Jisas akuyöbö alön, mönö adö paŋyöbö akwör, “Nagö nɨ mör madmag nɨgmɨdlö ä?” rön yad nugwön iswob yad nugwön röŋ aku, Pita rɨb mɨga yöx nugu gɨrön yadöŋa, “Nöbö Dib. Nagö ap bla magalɨg nugulö. Makwam, nɨ nagö madmag nɨgmɨdɨl aku mɨ, nagö mödö nugulö maku pal,” röŋa. Aliö rɨmɨn, Jisas yadöŋa, “Makwam, sipsip nɨ bla nugwidɨx mɨdö. ");
INSERT INTO tmd_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nɨ nagö mɨ ödöriö yadmɨdla, nagö ha nöbö röxg mɨdmö wop aku, wölɨja rɨb naŋa keir rɨg yöx nugumö akwör pɨ yömön yönmɨdlö. Jɨ nagö mai nöbö nom röxgɨnö wop aku, nagö imag nagö pisö abmɨdaŋ nugugɨrön, nöbö hör hön nagö nag wabɨlön, duöinö cɨnö möl aku yölɨŋön pön diönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jisas mönö yadöŋ aku, nöbö mö bli ñɨŋ mai Pita pɨl pal nɨgöñ aku, nuŋ höd nugwön yadöŋ maku. Nöbö mö maiyöbö piaku, Pita nugwo ap agapɨm rɨmɨdɨŋ wöröxön aku nugwön, God nuŋ mil mag wä keiryöbö alɨg mɨd aku, nugwöña. Makwam Jisas Pita nugwo yadöŋa, “Nɨ mai hane,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Jisas mönö aku yadmɨn, Pita höuöiliö nugwöŋa, nɨ nöbö Jisas madmag nɨgmɨdɨl aku mɨdma. Nɨ nöbö aku pal, höd Jisas Pasopa ap nɨmmɨdöŋ il yöra römɨd gɨ mɨdön yad nuguma, “Nöbö Dib. Agö nöböm nagö höuöu cönɨŋö?” rɨma. ");
INSERT INTO tmd_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita nɨ nugwön Jisas nugwo yadöŋa, “Nöbö Dib. Nöbö kɨ nugwo pödpöd cön?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Aliö rɨmɨn, Jisas yadöŋa, “Aku rɨb nɨ. Nɨ yadmön nuŋ mɨdɨb ör mɨdaŋ nugugɨrön, höbkal hön aku, mönö naŋ yöi mɨ. Makwam naŋ nɨ mai hane,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jisas mönö yadöŋ aku, nöbö mö nugwo nugw pim bla yadmä, “Jisas nöbö nuŋ aku wöröxenɨŋö,” rɨmä. Jɨ Jisas nöbö nuŋ aku wöröxenɨŋö, rön, mönö aku yadölöŋ; nuŋ hör yadöŋa, “Nɨ yadmön nuŋ mɨdɨb ör mɨdaŋ nugugɨrön, höbkal hön aku, mönö naŋ yöi,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jisas nöbö nuŋwa yadöŋ aku nɨ Jon. Nɨ keir mönö kɨ kai kɨtön, magalɨg mönö ma mɨd aku nugwön kai kɨtɨl maku. Jisas nuŋ rɨg yadöŋ mönö akuyöbö nugwön mönö akwör kai kɨtla. Makwam an magalɨg nugumɨn mönö kai kɨt aku, mönö ma akwör kɨta. ");
INSERT INTO tmd_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jisas ap adö hörɨrör mɨga akwör röŋ aku, jɨ mönö aku hör bli ör mibɨl yörɨk kai kɨta. Nɨ nugula, nöbö bli mönö piaku magalɨg köp bö kai kɨt nɨgöyɨx aku, mögörɨb kɨ ulmɨdö röxmɨn, pön du nɨgɨb yöra mɨdölöx. ");
INSERT INTO tmd_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Nöböhöd Tiopilas. Nɨ nagö mönö höd kai kɨtma aku, Jisas nugwo yöx pön höm, dib röxön mabö ila nɨgön mɨdɨp duön, agap apɨm rön, mönö kai kai yad nölöŋ aku, nagö köp agñɨŋ aku kai kɨtma. ");
INSERT INTO tmd_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Mai, God nuŋ Jisas pön mögörɨb adöx yöd röul adö kau sö pön wöluöŋa. Jɨ nuŋ adöx yöd röul adö kau sö wöluba röŋ mag aku, nuŋ rɨmɨn Inöm Leia nuŋ mönö nuŋwa pön dub nöbö yad nɨgöŋ nöbö akuyöbö ñɨgö yad nöl ri aböŋa. Mönö aku magalɨg höd kai kɨtön nagö nölɨm maku. ");
INSERT INTO tmd_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jisas wöröxöŋa jɨ höbkal öbɨlön, wop akuyöbö padokwo padök paŋyöbö i höuöiliö hö pɨn du adokwebö mɨj bö (40) mibɨl yöra wop mɨga wöxnö nɨgön, mönö nuŋwa pön dub nöbö nuŋ bla pɨsaŋ mɨdön, God nöbö mö pön nugwidɨx mɨdɨb mönö aku ñɨgö yad nölmɨda. Almɨdmɨn, ñɨŋ mämäg ñɨŋa keir nugumɨn nuŋ kömö mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Makwam wöröxön öbɨlön, mögörɨb döul il kɨ mɨdmɨd wop mibɨl yöraku, wop i nöbö nuŋ piaku pɨsaŋ ap nɨm gɨrön yadöŋa, “Nɨ ñɨgö höd yadɨm mag akuyöbö, Acö na ap kai ñɨgö nöinö, röŋ aku, Jerusalem yörɨk ör mɨdön pöx mɨjöña. ");
INSERT INTO tmd_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon röbö pal nölɨb nöbö aku hör nöbö mö ñɨgö röbö akwör pal nölmɨda, jɨ wop mösör hö duaŋ, Inöm Leia nuŋ hön ñɨgö pal nöiönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Makwam wop i Jisas nuŋ nöbö nuŋ piaku mɨdim mibɨl yöra wöxnö nɨgmɨn, ñɨŋ nugwo yadmä, “Nöbö Dib, nagö weik kiŋ ana mɨdaŋ, an Isrel nöbö mö mögörɨb an kɨ iswob an keir nugwidɨx mɨdön, mögörɨb bli nugwidɨx mɨjnɨŋönö ä?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Aliö rɨmɨn, Jisas ñɨgö yadöŋa, “Wop kai cön aku, Acö rɨb nuŋwa keir yöx nugwön yad nɨgöŋa; ap ñɨŋ yöi. ");
INSERT INTO tmd_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Makwam Inöm Leia nuŋ ñɨgö haŋ, ñɨŋ ölɨsö mag aku pön, duön Jerusalem nöbö mö, Judia nöbö mö, Sameria nöbö mö, nöbö mö mögörɨb adadö piaku piaku magalɨg, nɨ agap apɨm rɨl mönö aku pön duön nöbö mö akuyöbö yad nöiöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jisas aliö rön, nöbö nuŋ bla nugugu mɨdɨm nugugɨrön, God nuŋ Jisas adöx sö pön wölumɨn nugugɨrön, mɨjöi wab i hön nugwo yuö aböŋa. ");
INSERT INTO tmd_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Makwam nuŋ wölumɨdöŋa, ñɨŋ laxiö adöx sö nugugu mɨdɨm nugugɨrön, wop akwör nöbö wölɨj lei yömɨm hogwa hö ñɨgö pɨsaŋ öbɨl gɨ mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nöbö hogw aku yadmä, “Nöbö Galili yöbö kɨyöbö, ñɨŋ pödpöd rɨmɨn laxiö adöx sö nugugu mɨdöi? Ñɨŋ nugugu mɨdɨŋ nugugɨrön, God nuŋ rɨmɨn, Jisas nugwo pön mögörɨb adöx yöd röul adö kau sö pön wölu mag akuyöbö, mai nuŋ keir höuöil aliar alɨp hönɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Olip Pɨd sö mɨdmä aku röböxön Jerusalem höuöil dumä. Ödöi mɨxɨl yöi, Olip Pɨda Jerusalem womiöx; Juda nöbö mö ñɨŋ God höjöpalɨb wop aku rɨg rɨp yönmɨdöi mag akuyöbö. ");
INSERT INTO tmd_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalem duön, ram hölɨmɨb ñɨŋa uröpɨnön, ram möl bɨl sebö möla dumä. Nöbö mɨdim akuyöbö: Pita, Jon, Jems, Edru, Pilip, Tomas, Batolomiu, Matiu, Alpias ha nuŋwa Jems, Saimon Selot, Jems ha nuŋwa Judas. ");
INSERT INTO tmd_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ñɨŋ öim öim mögum rön, God höjöpalmɨdmä. Jisas nuöm Maria, Jisas pɨgnɨŋ nöbö bla, mö bli pɨsaŋ öim almɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Makwam wop mibɨl yöraku, nöbö mö padokwo padök mömɨd so höuöiliö mömɨd sö (120) hö mögum rɨm nugugɨrön, Pita öbɨlön ñɨgö yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Haul nöbö mölöu nöbö nugwi. Inöm Leia nuŋ maduar ör Depid nugwo rɨbyöx nölmɨn, Judas Jisas nugwo höuöu cön aku höd nugwön kai kɨtmɨn, rɨg yadöŋ yadöŋ mag akuyöbö akwör röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jisas nöbö Judas aku pɨmɨn, an pɨsaŋ mɨdön, mabö nuŋ aku nɨgiö nɨgön rɨmɨdölɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judas nuŋ Jisas nugwo höuöu rön, rɨg pöŋ aku rag duön, mögörɨb i wobön, mɨdɨp duön, wop paŋyöbö i gupɨn pal wödmɨn, wöt nuŋwa bɨrmɨn, höbwaba magalɨg kul rɨ röpɨnmɨn wöröxöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Aliö wöröxɨm, Jerusalem nöbö mö magalɨg nugwön, mögörɨb wobön wöröxöŋ aku iba Akeldama me rɨmä. Akeldama yadɨm mönö il aku, “Haña pɨnöŋ Mögörɨb,” me rön yadmä. ");
INSERT INTO tmd_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita yadöŋa, “Depid maduar ör God Mönö rɨb Sam mönö um bli kai kɨtön yadöŋa, ‘Ram nuŋwa yöja akwör mɨdaŋ; Nöbö mö bli ram nuŋwa du mɨdölɨŋ,’ me röŋa. Depid mönö i piöŋö yadöŋa, ‘Mabö nuŋ aku nöbö i paŋ,’ me röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Aliö röŋ aku, nöbö an keir i nugwön pɨnɨŋa. An Nöbö Dib Jisas pɨsaŋ yön mɨdöl aku, nöbö an pɨsaŋ öim yönmɨd nöbö i nugwön pɨnɨŋa. ");
INSERT INTO tmd_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Nöbö an pɨsaŋ öim yönön, Jon nuŋ Jisas röbö pal nölöŋ aku nugwön, mɨdɨp duön, Jisas wöröxön öbɨlön adöx yöd röul adö kau sö dumɨn nugwöŋ nöbö i nugwön pɨnɨŋa. Nöbö akuyöbö pɨnɨŋ aku, Nöbö Dib Jisas wöröxön öbɨlöŋ mönö aku yad nöl ri abönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita aliö rɨmɨn, Mataias Josep yöŋö nöbö hogwa yad nɨgmä. Josep wop bli ib nuŋwa i Basabas, i Jastas, me rɨmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Nöbö hogw aku ñɨgö aliö yad nɨgön, God höjöpalön yadmä, “Nöbö Dib, Judas höd rɨ gwogwam rön wöröxön, nuŋ mɨdɨb yöra duöŋ makwam, yör nuŋwa yön pönɨŋö, rön, nöbö mös hogwa kɨ yad nɨgöla. Makwam, nagö nöbö mö magalɨg rɨbyöx nugwön, rɨg röi mag akuyöbö nugulö makwam, an nagö yad nugumɨdöla, naŋ keir nöbö maku, me raŋ, an nugwön pɨnɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Aliö rön, nöbö hogw aku rɨp ñɨña pugul pɨm, Mataias iba wölmɨn, Jisas mönö wä pön dub nöbö akuyöbö agɨp sö pɨsaŋ nɨgiö nɨgɨm, iswob nöbö akuyöbö möl sö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nöbö mö Jisas nugw pim bla, Pedikos wop dib aku weik, me rön, hö ram möl paŋyöbö i mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Aliö mɨdɨm nugugɨrön, rɨba gɨgɨ diba adöx yöd röul adö kau sebö rön, hödal röxg hön, ram möl yuadö römɨd mɨdim yöra höŋa. ");
INSERT INTO tmd_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Makwam wop akwör nugumɨn, rɨn pin röxgɨb ap aku hön, paxdörɨm paŋ paŋ nuöm nɨgön, nöbö mö yöcmac paŋ paŋ rol sö du mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Du mɨdmɨn nugugɨrön, Inöm Leia hön, inöm ñɨgö yuö kwo aja wölöŋa nugwön ñɨŋ mönö yöbö adö hörɨrör yadmä. ");
INSERT INTO tmd_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Makwam wop aku, Juda nöbö mö bla, ñɨŋ mögörɨb pia pia möl hörɨrör hön, Jerusalem mögum rɨmɨdmä. Nöbö mö piaku ñɨŋ God Mönö rɨg yadöŋ mag akwör nugwön rɨmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Gɨgɨ dib aku rɨmɨdöŋ nugwön, pödpöd rɨmɨdö, rön, nöbö mö mɨga akwör rɨmgör ram aku hön nugumɨn, mönö yöbö adö hörɨrör ödöriar yadmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ñɨŋ nugwön aiö waiö rön yadmä, “Nöbö mö bɨlɨk magalɨg Galili yöbö. ");
INSERT INTO tmd_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Makwaim pödiö mönö yöbö ana hörɨrör rɨg yadöl mag akuyöbö ödöriar yadmɨdöia nugumɨdöl? ");
INSERT INTO tmd_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","An bli Padia, bli Midia, bli Ilam, bli Mesopotemia, bli Judia, bli Kapadosia, bli Podas, bli Esia, ");
INSERT INTO tmd_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","bli Prijia, bli Pampilia, bli Ijip, bli mögörɨb Libia, Sairini taun kwol piaku, bli Rom yöbö höla. ");
INSERT INTO tmd_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(Nöbö mö Rom yöbö höi aku, bli Juda nöbö mö ödöriö, bli Juda nöbö mö yöi jɨ mai Juda nöbö mö rɨg röi mag akuyöbö röia.) Bli Krit, bli Arebia yöbö höla. Makwam an nugumɨdmɨn nugugɨrön, mönö yöbö ana hörɨrör rɨg yadöl aliar ödöriar yadön, God nuŋ mag keiryöbö rö, rön, ib nuŋwa yadɨm bɨl sö dumɨda, nugumɨdölɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Aliö rön, rɨb mɨga yöx nugu gɨrön, bli bli yad nugum bli bli yad nugwön yadmä, “Mag höra rɨmɨd aku pödpöd rɨba rɨmɨdö,” rön, rɨb mɨga yöx nugumä. ");
INSERT INTO tmd_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nöbö mö bli piöŋö ñɨŋ ñɨlöŋ nɨg yadmä, “Aku röbö wain mɨga nɨmön u pɨlön yadmɨdöiŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Makwam Pita nuŋ Jisas mönö wä pön dub nöbö akuyöbö agɨp sö pɨsaŋ öbɨlön, ajmöla aj halön, nöbö mö mɨga akwör mɨdmä akuyöbö ñɨgö yadöŋa, “Ñɨŋ Juda nöbö mö an aipam, ñɨŋ nöbö mö Jerusalem yörɨk hölɨm mɨdim bla aipam, yörɨk agö magɨm rɨmɨd aku nɨ ñɨgö mönö yadɨba rɨmɨdɨl kɨ nugw ri aböña. ");
INSERT INTO tmd_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ñɨŋ bli yadmɨdöia, ‘Nöbö pik röbö wain mɨga nɨmön u pɨlön yadmɨdöiŋö,’ röi aku, jɨ ñɨŋ röbö wain nɨmön u pɨlölöi. Weik naiö yöudöŋdöŋ ör wöl mag akwör pal. ");
INSERT INTO tmd_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Makwam mönö yöbö hörɨrör yadmɨdöia nugumɨdöi kɨ, God mönö yadɨb nöbö Joel maduar ör yadön kai kɨtöŋ mag akuyöbö akwör rɨmɨd maku pal. Nuŋ mönö aku kai kɨtön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘God yada, “Wop maiyöbö aku, ñɨgö nöbö mö akuyöbö magalɨg Inöm na abna. Halöu ha ñɨŋ bla God Mönö maga ñɨgö nöbö mö yad nöiöña. Ha nöbö ñɨŋ bla rɨba nugwöña. Nöbö dib ñɨŋ bla inɨmö nugwöña. ");
INSERT INTO tmd_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Wop aku, mabö na rɨ nölɨb nöbö mö nɨ bla, nöbö bla aipam mö bla aipam, ñɨgö Inöm na abmön, mönö wä na aku nöbö mö akuyöbö yad nöiöña. ");
INSERT INTO tmd_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nɨ adöx yöd röul adö kau sö ap keiryöbö rölɨbä akuyöbö bli rön, mögörɨb rol il kɨ ap nugub nugwölɨbä keiryöbö bli cɨna. Paskwolö pɨlön, rɨn yönön, rɨn haub autaut diba rön cöna. ");
INSERT INTO tmd_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Naiö mila aben; röuna paskwolö piöna. Almɨdaŋ, mai wop aku wop keiryöbö wöxnö nɨgöna. Nöbö Diba mil mag wä keiryöbö alɨg höna. ");
INSERT INTO tmd_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Makwam nöbö mö yön yön, Nöbö Diba nɨ kömö paŋ, me rön, yad nugwöñ bla, ñɨgö kömö pönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pita nuŋ Joel kai kɨtöŋ mönö aku yad pörön yadöŋa, “Ñɨŋ Isrel nöbö mö, mönö yadɨba rɨmɨdɨl kɨ nugw ri aböña. Jisas nöbö Nasaret yöbö aku nöbö hör yöi; God nuŋ keir nugwo yad abmɨn höŋa. Ha na aku agal abmön, ap rölɨbä akuyöbö mɨga akwör rön, ap nugub nugwölɨbä mɨga akwör rön cön mibɨl ñɨgö yöraku nugwön, nöbö aku God nuŋ keir yad abmɨn höŋ aku nugwɨŋ, me rön, nugwo yad abmɨn höŋa. Jisas nuŋ ap rölɨbä akuyöbö mibɨl ñɨŋa röŋ aku, ñɨŋ keir mödö nugwöia. ");
INSERT INTO tmd_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","God nuŋ ñɨŋ rɨg cöñ mag akuyöbö höd nugwön, Jisas nugwo pɨ imag rol ñɨgö aku nɨgmɨn, ñɨŋ nugwo pön du nöbö mö ap kib mag gwogwo röi akuyöbö nölɨm, nugwo bɨ katlö watlö höñ sö pɨl pal nɨgɨm wöröxöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nuŋ mɨ ödöriö ölɨŋ höb diba pön wöröxöŋ aku, jɨ aŋadö nöbäpö hogw möl yöra mɨdön, lɨdu pɨn pal dubä maga nɨgölöŋ. God rɨmɨn nuŋ höbkal öbɨlöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Depid nuŋ maduar ör Jisas nugwo mönö kai kɨtön yadöŋa, ‘Nɨ nugula, Nöbö Diba nɨ pɨsaŋ öim öim mɨda. Nuŋ imag mɨrɨx na adö mɨd aku mɨ, nɨ ipöxöin. ");
INSERT INTO tmd_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Almɨn, höbwab madmag na yauaba; nɨ wahax pön wä rö rɨmɨdla. Mɨxɨñ na wöröxöna jɨ nɨ wahax pön rɨb wä yöx nugu gɨrön ipöxöinöm. ");
INSERT INTO tmd_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Pöd raŋ? Nagö nɨ nöbäpö hogw möla röböxöinö. Nagö Nöbö Lei nagö röböxaŋ, mɨxɨñ nuŋwa lɨdu pɨn pal duenɨm. ");
INSERT INTO tmd_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nagö nɨ kömö mɨdɨb ödöi aku yabumö. Nɨ nagö pɨsaŋ mɨdön, mɨ ödöriö wahax pɨmɨjɨnö,’ rö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pita Depid yadöŋ mönö aku yad pörön yadöŋa, “Haul nöbö mölöu nöbö, nɨ ñɨgö mönö ödöriar yadmön, nugw ri aböña. Nöso maduebö Depid wöröxɨm hogw pɨlim ulöm möla mɨda; ulöm möl aku weik an kwo algör nugwöla. ");
INSERT INTO tmd_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Makwam Depid nuŋ God mönö yadɨb nöbö mɨdmɨd makwam nuŋ nugwöŋa, God maduar ör mönö yad nɨgön yadöŋa, ‘Nagö ha yöxön yöxɨp duön yöx nɨgöñ ha i nuŋ yör nagö pön, kiŋ mɨjönɨŋö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Depid ap mai rɨg cön aku nugwön, Mesaia aku nuŋ wöröxön öbiönɨŋö, rön, yadöŋa, ‘Nugwo nöbäpö hogw möla röböxölöŋ. Mɨxɨñ nuŋwa lɨdu pɨn pal duölöŋ,’ me röŋa. 32“Wopik God rɨmɨn, Jisas nuŋ öbɨlön kömö mɨda. Nuŋ kömö mɨd aku an magalɨg mämäg ana keir nugwöla. ");
INSERT INTO tmd_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","God Jisas nugwo pön du imag mɨrɨx nuŋwa adö nɨgöŋa. Nɨgön, nuŋ Inöm Leia nöinö, rön yadöŋ aku, Jisas nugwo nölmɨn, nuŋ piöŋö anɨŋ nölmɨn, hön gɨgɨ diba rɨmɨn, an mönö hörɨrör yadmɨdöl kɨ nugumɨdöia. ");
INSERT INTO tmd_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Makwam Depid mönö yadöŋ aku, nuŋ keir yadölöŋ. Depid nuŋ mögörɨb il kɨ mɨdön, adöx yöd röul adö kau sö duölöŋ. Makwam nuŋ yadöŋa, ‘Nöbö Diba nuŋ Nöbö Dib na aku nugwo yadöŋa, “Imag mɨrɨx na adö römɨd gɨ mɨjɨnö; ");
INSERT INTO tmd_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","nɨ rɨmön kwolmal nagö bla, wöktaitö möl nagö piaku mɨjöñɨŋö,” rö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Makwam, ñɨŋ Isrel nöbö mö magalɨg nugw ri aböña: Jisas nöbö bɨ katlö watlö höñ sö pɨl pal nɨgɨm wöröxöŋ Nöbö akwör, God rɨmɨn Nöbö Dib ödöriö mɨda. Nuŋwör Mesaia öim pöx mɨdmɨdöl aku maku,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pita mönö aku yadmɨn, nöbö mö mɨdim akuyöbö nugumɨn aiöuñ rɨm duöŋa. Almɨdmɨn, ñɨŋ Pita aipam, Jisas mönö wä pön dub nöbö bla aipam, yad nugwön yadmä, “Makwam, haul nöbö, an weik pödpöd rɨŋö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Aliö rɨmɨn, Pita yadöŋa, “Ñɨŋ paŋ paŋ magalɨg mɨdöi akuyöbö, ap kib mag gwogwo röi aku, pödpöd rɨmɨn aliö alölɨŋö, rön, röböxön, Jisas Krais nugw pön, röbö yaxöña. Almɨdɨŋ, God ap kib mag gwogwo röi aku nugwön röböxön, Inöm Leia ñɨgö nöiöna. ");
INSERT INTO tmd_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","God maduar ör yadöŋa, ‘Inöm na ñɨgö Isrel nöbö mö nölön, halöu ha ñɨŋa yöx pön höñ bla nölön, nöbö mö mögörɨb pad bla aipam nölön cɨnö,’ röŋa. Makwam, an nugwöla, God nöbö mö yön yön höŋ, me cön akuyöbö, ñɨgö magalɨg Inöm Leia nöiönɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita ñɨgö uliöxön, mönö mɨga akwör yadön yadöŋa, “Nöbö mö wopik mɨdöi bli amnör rɨ gwogwam röi mag akuyöbö röböxön mɨd ri aböña. Nöi mɨjön aku, ölɨŋ höb diba pöñɨŋe,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nöbö mö mɨga akwör Pita mönö yadöŋ aku nugwön, Jisas Krais nugw pön, röbö palmä. Wop mɨd akwör, nöbö mö tri tausan (3000) akuyöbö Jisas Krais nugw pön, Jisas nöbö mö nuŋwa adöi pɨsaŋ nɨgiö nɨgön mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Makwam, ñɨŋ öim öim hön, Jisas mönö wä pön dub nöbö bla pɨsaŋ paŋör mɨdön, God Mönö yad nölmɨdöi aku nugw ri abnɨŋö, rön, yadɨp wöhö gɨrön, bred pɨ gɨlɨxön paŋör nɨm gɨrön, God höjöpal gɨrön mɨdmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","God nuŋ Jisas mönö wä pön dub nöbö bla ñɨgö ölɨsö nölmɨn, ap rölɨbä akuyöbö mɨga akwör rön, ap nugub nugwölɨbä mɨga akwör rön rɨm, nöbö mö bla nugwön, aiö waiö rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nöbö mö Jisas nugw pim bla paŋör mɨdön, nöbö mö ap mɨdölöŋ bla, bli ap amnör nuöm nɨg nölmä. ");
INSERT INTO tmd_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Mögörɨb ap blaku kwo algör sɨm rön, rɨg pön, nöbö mö ap mɨdölöŋ bla nuöm nɨg nölmä. ");
INSERT INTO tmd_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ñɨŋ öim öim, wop paŋ paŋ, God höjöpalɨb rama du mögum rɨmɨdmä. Ram ñɨŋ piaku kwo algör du mögum rön, bred pɨ gɨlɨxön, nuö nuö madmag nɨg gɨrön, wahax pɨ gɨrön, ap paŋör nɨm gɨr mɨdmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Makwam nöbö mö mɨdim akuyöbö magalɨg, Jisas nugw pim nöbö mö ñɨgö nugumɨn, wä röŋa. Öim öim, wop paŋ paŋ, Nöbö Diba nuŋ nöbö mö bli aipam kömö pɨmɨn, ñɨŋ Jisas nugw pön, hö Jisas nöbö mö nuŋwa hödyöbö piaku pɨsaŋ nɨgiö nɨgön paŋör mɨdmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","3","Nuö nuöm yöx pön hem wop akwör yödpɨlö gwogwo röŋ nöbö i, nugwo wop paŋ paŋ öim öim pön hön, God höjöpalɨb rama ubalɨj il, Ubalɨj Kɨtɨb Wä, me röi aku, pedöx pedöxiö yöra nɨg gɨm römɨd gɨ mɨdmɨda. Mɨd gɨrön, nöbö mö God höjöpalɨb rama ram möl yuadö duba hö dumɨdöi piaku, ñɨŋ rɨg ap nɨ bli nöine, rön, sö rɨ gɨr mɨdmɨda. Makwam wop i, Pita Jon yöŋö naiö pikwo rɨm pɨgöŋ mag aku, God höjöpalɨb mag aku, God höjöpalɨba hö padɨxmɨn nugugɨrön, nöbö yödpɨlö gwogwo röŋ aku ñɨgö nöbö hogwa nugwön yadöŋa, “Nɨ rɨg bli nöi,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Aliö rɨmɨn, ñɨŋ nöbö hogwa nugwo tar riö nugugu mɨdön, Pita yadöŋa, “An nöbö hogwa nugwö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Yadöŋa, nɨ ap i nölɨba mɨdöiŋö, rön, nöbö hogwa nugugu mɨdmɨn nugugɨrön, ");
INSERT INTO tmd_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pita yadöŋa, “Rɨg silpa, rɨg gol aku nɨ mɨdöl, jɨ ap nɨ paŋyöbö i mɨd aku nagö nöina. Jisas Krais nöbö Nasaret yöbö aku, ib nuŋwa urön nagö yadmɨdla, ‘Öbɨl duö!’ ");
INSERT INTO tmd_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pita aliö rön, imag mɨrɨx nugwo adö pön, pɨ pabɨl nölmɨn nugugɨrön, mag akwör yödpɨlö aipam, yödpɨlö kwola aipam wä röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Wä rɨmɨn, rɨmgör öbɨl du gɨrön, höx höx wöd gɨrön, God nugwo ri ablaŋe rɨ gɨrön, ñɨŋ nöbö hogwa pɨsaŋ God höjöpalɨb rama ram möl yuadö duöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","God nugwo ri ablaŋe rön, röb gɨrön yönmɨdöŋ aku, nöbö mö mɨdim akuyöbö nugwön, ");
INSERT INTO tmd_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","nöbö yödpɨlö gwogwo öim hön, God höjöpalɨb rama ubalɨj il, Ubalɨj Kɨtɨb Wä, me röi aku, pedöx pedöxiö yöra römɨd gɨ mɨdön, rɨg ap bla sö rɨ mɨdmɨd nöbö aku, pödpöd rön yöda ödöriö röb gɨr hömɨdö, rön, rɨb mɨga yöx nugwön aiö waiö rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nöbö aku nuŋ God höjöpalɨb rama rɨŋadö bö, Solomon Ram Bötö, me röi möl aku mɨdön, Pita Jon yöŋö nöbö hogwa mibɨl nɨg gɨm mɨdɨm nugugɨrön, nöbö mö magalɨg aiö waiö rɨ gɨrön ipalɨp hömä. ");
INSERT INTO tmd_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nöbö mö hömɨdmɨn, Pita nuŋ nugwön yadöŋa, “Isrel nöbö mö kɨyöbö, ñɨŋ pödpöd rɨmɨn rɨb mɨga yöxön anɨŋ nöbö hogwa riö nugugu mɨdöi? ‘Ñɨŋ nöbö hogwa nöbö ölɨsö, nöbö wä mɨdön rɨmɨdmɨn, nöbö kɨ ödöia yön ri abmɨdö,’ rön, rɨb aku yöx nugumɨdöi ä? Aku wöhö. ");
INSERT INTO tmd_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ebraham, Aisak, Jekop, nöso maduebö an bla höjöpalmɨdim God akwör nuŋ keir rɨmɨn, mabö rɨ nölɨb nöbö nuŋwa Jisas öbɨlmɨn, nöbö mö bla nugwön, nuŋ mil mag wä keiryöbö alɨg mɨdö, rön, nugwöia. Ñɨŋ Jisas nugw pölim. Pailot nuŋ Jisas yau abnö röŋa, jɨ ñɨŋ keir yadön yadmä, nugwo pön du bɨ katlö watlö um sö pɨl pal nɨgɨŋ me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jisas nuŋ Nöbö Lei; nuŋ Nöbö Kömö Wä öim öim God rɨg yad mag akwör ra. Makwam ñɨŋ yadmä, Jisas nuŋ nöbö nugub an yöi; nöbäpö pɨlmɨd nöbö aku anɨŋ yau abö, rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Al gɨrön, Nöbö kömö mɨdɨb maga nöl aku nugwo pɨl pal nɨgmä. Makwam God rɨmɨn, nuŋ öbɨlöŋ aku, an mämäg ana keir nugwön yad nölmɨdöla. ");
INSERT INTO tmd_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nöbö yödpɨlö gwogwo öim nugumɨdöi nöbö kɨ, weik kömö nɨgmɨn nugwöia. Jisas ölɨsö nuŋwa rɨmɨn mönö, kömö nɨga. An Jisas nugw pön, ib nuŋwa yadmɨn, Jisas nuŋ rɨmɨn, aŋadö kömö nɨga. ");
INSERT INTO tmd_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Makwam nöböhöd möhöd nɨ pik. Ñɨŋ keir aipam, nöbö dib ñɨŋ bla aipam, ua alɨg mɨdön, Jisas nugwo mag akuyöbö almä. ");
INSERT INTO tmd_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Makwam God nuŋ mönö nuŋwa yadɨb nöbö bla ñɨgö maduar ör rɨbyöx nölmɨn yadmä, ‘Mai God Mesaia nuŋwa mɨ ölɨŋ höb diba pön wöröxönɨŋö,’ rɨmä aku, rɨg yadim mag akwör rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Makwam, ap kib mag gwogwo röi aku, pödpöd rɨmɨn aliö alölɨŋö, rön, röböxön, höbkal God nugwo höŋ, nuŋ ap kib mag gwogwo röi pɨx aku örɨx aböna. Aliö alɨŋ, Nöbö Diba nuŋ inöm ñɨgö yuö kwo ölɨsö nuŋwa nölön, ");
INSERT INTO tmd_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Krais ñɨgö maduar ör yad nɨgöŋ Krais aku yad aböna. Krais aku Jisas maku. ");
INSERT INTO tmd_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","God nuŋ maduar ör yadmɨn, mönö yadɨb nöbö lei nuŋ bla rɨg yadim mag akuyöbö, Jisas nuŋ mögörɨb adöx yöd röul adö kau sö rɨg mɨd akwör mɨdaŋ nugugɨrön, God ap magalɨg iswob rɨ nɨg ri abön wop aku höna. ");
INSERT INTO tmd_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mosɨs yadöŋa, ‘Mai Nöbö Dib God ñɨŋa, nuŋ mönö yadɨb nöbö nɨ röxgɨb, il ñɨŋa keir nöbö i yad aböna. Nuŋ hön, mönö yajön aku magalɨg nugw ri aböña. ");
INSERT INTO tmd_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nöbö mö mönö nuŋwa peñ akuyöbö, nöbö mö nuŋwa mɨdeñɨm; ñɨŋ aŋadö rɨŋadö bö duön wöröxöñɨŋö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“God mönö yadɨb nöbö Samuel aipam, God mönö yadɨb nöbö mai hem bla aipam magalɨg ap wopik wöxnö nɨgmɨda nugumɨdöl aku mödö höd yad nölmä. ");
INSERT INTO tmd_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","God maduar ör nöhönɨŋ maduebö ñɨŋa mönö yad nɨgöŋ aku, ñɨŋ keir ap ame pɨmɨdöi aku maku. God nöso Ebraham nugwo cɨnö, rön, mönö yad nɨgöŋa. Mönö yad nɨgön yadöŋa, ‘Halöu ha nagö yöxaŋ, ñɨŋ yöxɨp höuöilmel rön yöxöñ bla, nöbö i mɨdön aku nuŋ raŋ, nöbö mö akuyöbö magalɨg wahax pɨmɨjöñɨŋö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","God nuŋ Mabö Rɨ Nölɨb Nöbö nuŋwa Jisas mögörɨb il kɨ agal aböŋ aku, ñɨgö me rön, höd agal abmɨn höŋa. Isrel nöbö mö ap kib mag gwogwo röi aku, pödpöd rɨmɨn aliö alölɨŋö, rön, röböxön mɨd ri abɨŋ, me rön, ñɨgö Isrel nöbö mö kɨyöbö höd agal abmɨn hö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita Jon yöŋö nöbö mö ñɨgö mönö yad nölmɨdmɨn nugugɨrön, God ap höjöpal ur nölɨb nöbö bla aipam, God höjöpalɨb rama nugwidɨx mɨdmɨdöi nöbö bla yöj nöbö ñɨŋ aku aipam, Sadiusi nöbö bla aipam, hön mönö yadmɨdmä aku audiöx nugumä. ");
INSERT INTO tmd_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Jisas wöröxön öbɨlöŋ mag akuyöbö, nöbö mö Jisas nugw pöñ akuyöbö ñɨŋ kwo algör wöröxön öbiöñ mönö aku, pödpöd rɨmɨn yad nölmɨdöiŋö, rɨmɨn, ölɨsö wölöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Makwam, ñɨŋ Pita Jon yöŋö pɨ cɨcɨ nɨgön, wopik höxi guröŋ mag kɨ wöhö, laŋ mönö diba yajnɨŋö, rön, ñɨgö nöbö hogwa pön du nag nɨgmä. ");
INSERT INTO tmd_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Makwam Pita Jon nöbö hogwa mönö wä aku yad nölmɨdmɨn, nöbö mö nugwön, nöbö mö mɨga mönö wä aku nugw pɨmä. Makwam, nöbö mö Jisas nugw pim bla akuyöbö paip tausan (5000) duöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Makwam löumɨn, Juda nöbö dib mögörɨb aku nugwidɨx mɨdmɨdmä bla aipam, mönö pɨ nuöm nɨgɨb nöbö bla aipam, lo mönö yad nölɨb nöbö bla aipam, Jerusalem piaku hö mögum rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","God ap höjöpal ur nölɨb nöbö dib ödöriö Anas Kaiapas yöŋö, yam ñɨŋ ada Jon Aleksada yöŋö, nöbö yam ñɨŋ ada bli kwo aipam hön, mibɨl yöraku mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ñɨŋ mögum rön yadmɨn, Pita Jon yöŋö nöbö hogwa yölɨŋ pön hö mibɨl yöraku nɨgɨm, ñɨŋ nöbö hogwa yad nugwön yadmä, “Nöbö yödpɨlö gwogwo röŋ aku pödpöd rɨmɨdmɨn kömö nɨg? Ölɨsö pikai yöbö pön, ib kai urön, aliö röiŋö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Aliö rɨmɨn, Inöm Leia nuŋ du Pita yuö kwo aja wölmɨn nugugɨrön, nuŋ yadöŋa, “Ñɨŋ Juda nöbö dib aipam, mönö pɨ nuöm nɨgɨb nöbö aipam, mönö yadmɨdɨl kɨ nugwi. ");
INSERT INTO tmd_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Nöbö lɨblɨb rɨbä yödpɨlö gwogwo röŋ aku rɨmɨdmɨn kömö nɨgöŋ aku nugwön, ‘Ñɨŋ pödpöd rɨmɨdmɨn kömö nɨgö?’ rön, anɨŋ mönö diba yadmɨdöiŋ ä? ");
INSERT INTO tmd_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Makwam, ñɨŋ mönö yadɨba rɨmɨdɨl kɨ nugw ri aböña. Isrel nöbö mö bla magalɨg algör nugw ri abɨŋ. Jisas Krais nöbö Nasaret yöbö ib nuŋ akwör nugw pön, ib nuŋwa yadmɨn, nuŋ rɨmɨn, nöbö kɨ nugwo aŋadö kömö nɨgmɨn, yön ri abmɨda nugwöia. Ñɨŋ Jisas Krais nugwo bɨ katlö watlö höñ sö pɨl pal nɨgmä, jɨ God rɨmɨn höbkal öbɨlöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jisas nugwo rɨbyöx nugwön, God Mönö rɨb i kai kɨtön yadmä, ‘Ñɨŋ ram urɨb nöbö piaku, rɨg mɨxɨl i, aku rɨg gwogwo, me rön, röböx aku, wopik ram padö mibɨl yöbö bö pɨn nöl gɨ mɨdö,’ rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","God nuŋ Jisas ib nuŋ akwör anɨŋ yadöŋa nugwön Jisas nuŋwör anɨŋ kömö pɨb maga ra. Mögörɨb il kɨ nöbö hör i anɨŋ kömö pɨb maga mɨdöl, mɨ wöhö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pita Jon nöbö hogwa öbɨlön ipöxölim; amɨn ödöriö akwör yadmɨn, nöbö dib piaku nugwön aiö waiö rön yadmä, “Nöbö hogw kɨ ñɨŋ skul pölim aku, jɨ ñɨŋ Jisas pɨsaŋ mɨdön mag akuyöbö alöiŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nöbö yödpɨlö gwogwo röŋa rɨm kömö nɨgöŋ aku mibɨl ñɨŋ yöraku mɨdmɨn nugugɨrön, ñɨŋ nöbö hogwa mönö yadɨb maga mɨdölöŋ. ");
INSERT INTO tmd_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Makwam, ñɨŋ yadmä, “Kansol ram kɨ rɨŋadö bö du mɨjne,” rɨmä. Rɨŋö bö du mɨdɨm nugugɨrön, ñɨŋ keir yad nugwob nugwob rön yadmä, ");
INSERT INTO tmd_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Nöbö hogwa kɨ an pödpöd cɨnɨŋ? Ñɨŋ ap rölɨbä akuyöbö aku rɨm, Jerusalem nöbö mö magalɨg mödö nugwöia. Makwam, ñɨŋ nöbö hogwa ap rölɨbä akuyöbö i rölöiŋö rön yadɨba mɨdöl. ");
INSERT INTO tmd_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Jɨ ñɨŋ duön, mönö aku nöbö mö rɨgwoŋ bli yadɨŋ, ñɨŋ algör nugubä maga ra. Alɨg mɨd aku, an ñɨŋ nöbö hogwa mönö ölɨsö yadön yajnɨŋa, ‘Jisas ib nuŋwa mai nöbö mö bli yad nölmɨjeñ, mɨ wöhö,’ cɨnɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Aliö rön, nöbö hogwa yadɨm hömɨn yadmä, “Jisas ib aku mai urmɨjeñ; nöbö mö bli Jisas mönö aku yad nölmɨjeñ, mɨ wöhö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Aliö rɨmɨn, Pita Jon yöŋö ñɨŋ paiŋö yadmä, “An God mönö nuŋ aku röböxön, mönö ñɨŋ aku pɨŋ, God nugwo wä cönɨŋönö wöhö? Ñɨŋ keir nugwi. ");
INSERT INTO tmd_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Makwam Jisas agap bɨlɨm röŋ, agö mönö bɨlɨm yadöŋ aku, an nöbö mö akuyöbö ñɨgö yad nölön röböxɨb maga mɨdölö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Aliö rɨmɨdmɨn, Kansol nöbö dib piaku rɨb ñɨŋa keir yöx nugwön, ‘Nöbö kɨ kɨm padokwo padök paŋyöbö i höuöiliö hö pɨn du adokwebö mɨj bö (40) mɨdön, wopik kömö nɨg kɨ, nöbö mö bla nugwön magalɨg God nugwo ri ablaŋe rɨmɨdöia. An nöbö hogw kɨ ñɨgö ap i rɨmɨjnɨŋ aku, nöbö mö kɨyöbö ölɨsö röjöñɨŋö,’ rön, ñɨŋ nöbö hogwa hör mönö ölɨsö yadön, yad abɨm röu dumä. ");
INSERT INTO tmd_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pita Jon ñɨgö nöbö hogwa aliö yad rɨŋö bö abɨm, ñɨŋ du Jisas nöbö mö nuŋ akuyöbö ñɨgö nugwön, God ap höjöpal ur nölɨb nöbö dib bla aipam, mönö pɨ nuöm nɨgɨb nöbö bla aipam, agö mönöm yadim aku ñɨgö yad nölmä. ");
INSERT INTO tmd_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Yad nölmɨdmɨn, ñɨŋ nugwön magalɨg God höjöpalön yadmä, “Naŋ Nöbö Dib paŋyöbö mɨdlö. Naŋ adöx yöd röul adö kau sö rɨ nɨgön, mögörɨb il kɨ rɨ nɨgön, ban yuö diba rɨ nɨgön, ap agap apɨm mɨd piaku magalɨg rɨ nɨgön, rɨ nɨgmö. ");
INSERT INTO tmd_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Maduar ör naŋ rɨman, Inöm Leia nuŋ nöso ana Depid nugwo rɨbyöx nölmɨn, mönö nagö aku yadön yadöŋa, ‘Juda nöbö mö yöi piaku ñɨŋ pödpöd rɨmɨn ölɨsö rödöi? Nöbö mö piaku pödpöd rɨmɨn rɨbyöx nugw ri abön wöhö, mönö adö paŋyöbö i yad nɨgön höuöu rɨbi röxg yadöi? ");
INSERT INTO tmd_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kiŋ mögörɨb hörɨrör nugwidɨx mɨdöi piaku aipam, gapman nöbö dib mögörɨb hörɨrör nugwidɨx mɨdöi piaku aipam, mönö adö paŋyöbö i yad nɨgön yadöia, “God Nöbö Diba pɨsaŋ, Mesaia nuŋwa pɨsaŋ, an ñɨgö pɨsaŋ nuö nuö pinɨŋö,” röiŋö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Kiŋ Herod aipam, gapman nöbö dib Podias Pailot aipam, Juda nöbö mö yöi akuyöbö bli aipam, Isrel nöbö mö bɨlɨk yöbö bli aipam, Jerusalem yörɨk hön, Mabö Rɨ Nölɨb Nöbö lei naŋ aku Jisas, Mesaia yad nɨgmö akwör, mönö paŋyöbö i yad ödör nɨgmä. ");
INSERT INTO tmd_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Makwam nagö Nöbö ölɨsö höd rɨb naŋa keir yöx nugwön yadmö, Krais nugwo al aliö cöñɨŋö, rɨmö makwam, ñɨgö rɨb maga nɨgöŋa; hör aku ölɨsö ñɨŋa mɨdölöx. ");
INSERT INTO tmd_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nöbö Dib, weik anɨŋ mönö ölɨsö gwogwo ödöriö yadmɨdöi aku, nagö rɨbyöx nugwö. Naŋ anɨŋ mabö rɨ nölɨb nöbö mö naŋ bla nugwidɨx mɨdön, ölɨsö nagö anɨŋ nölaŋ, an ipöxöinɨŋ; mɨ ususör rön mönö nagö nöbö mö piaku ñɨgö wöxnö yad nöinɨŋa. ");
INSERT INTO tmd_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nöbö mö ap rɨ piaku, nagö raŋ, an Mabö Rɨ Nölɨb Nöbö lei nagö Jisas ib nuŋwa urɨŋ, ñɨgö kömö nɨgaŋ. Nagö raŋ, an Jisas ib nuŋwa yadɨŋ, ap rölɨbä akuyöbö bli, ap nugub nugwölɨbä akuyöbö bli rɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Makwam ñɨŋ God nugwo aliö höjöpalön rɨ gɨr mɨdɨm nugugɨrön, ram mɨdmä aku mɨmön röxg pɨmɨn, Inöm Leia nuŋ hö yuö ñɨŋ kwo aja wölmɨn ipöxölim; ñɨŋ mɨ ususör rön God Mönö aku yad nölmä. ");
INSERT INTO tmd_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Makwam nöbö mö Jisas nugw pim piaku, mönö paŋyöbö i yad ödör nɨgön, rɨb paŋyöbö yöxön, ap ñɨŋ ap agapɨm mɨdöŋ piaku, ap ñɨŋ nɨgiö paŋör ör mɨdmɨn, ap anör, me rön, nugwölim. ");
INSERT INTO tmd_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jisas mönö wä pön dub nöbö piaku, nöbö mö akuyöbö ñɨgö mönö ususör rɨ yadön yadmɨdmä, “Jisas nugwo pɨl pal nɨgɨm, wöröxön öbɨlmɨn, mämäga ana keir nugwo nugwölɨŋö,” rɨmä. Aliö rɨmɨdmɨn, God ñɨgö magalɨg mɨ ödöriö uliöxön pɨ ri abmɨda. ");
INSERT INTO tmd_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nöbö mö i ap i met wölöŋ. Nöbö mö mögörɨb mönö ram bli mɨdöŋ piaku, sɨm rɨ rɨg pön, ");
INSERT INTO tmd_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Jisas mönö wä pön dub nöbö bla ñɨgö nölmɨdmä. Ñɨŋ piöŋö pön, nöbö mö ap mɨdölöŋ akuyöbö ñɨgö nuöm nɨg nölmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Makwam nöbö Lipai ila yöxɨp duön yöxim nöbö i ib nuŋwa Josep. Mögörɨb nuŋwa Saipras yöbö. Nöbö aku nuŋ nöbö mö bli ñɨgö mönö höimöliö yadön yad nöl ri abmɨn, ñɨŋ nugwön wahax pön rɨb wä yöx nugu gör mɨdmɨdöi makwam, Jisas mönö wä pön dub nöbö bla ib nuŋwa Banabas me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Josep mögörɨb nuŋwa i yadmɨn, nöbö mö bli wobɨm nugugɨrön rɨg aku rag hö Jisas mönö wä pön dub nöbö akuyöbö ñɨgö nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Makwam mönöbö wab i mɨdmä. Nöbönɨŋa iba Ananaias, mönɨŋ nuŋwa iba Sapaira. Mönöbö hogwa ñɨŋ mögörɨb ñɨŋ i yadmɨn wobmä. ");
INSERT INTO tmd_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Wobmɨn, Ananaias nuŋ rɨg aku adöi ñɨŋ keir nuöm nɨg nɨgön, adöi pön du Jisas mönö wä pön dub nöbö bla ñɨgö nölöŋa. Mönɨŋa aipam nugwöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Makwam Ananaias rɨg aku aliö rag hö nölmɨn, Pita yadöŋa, “Ananaias, Seten nagö rɨba nölmɨn, naŋ inakmönö hörön yadlö, ‘Mögörɨb woböi rɨga magalɨg pön höl kɨ,’ rɨlö. Naŋ anɨŋ mönö inakmönö höirö aku, Inöm Leia nugwo kwo algör inakmönö höirö. Mögörɨb woböi aku rɨg adöi umadön hölö. ");
INSERT INTO tmd_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mögörɨb aku, mögörɨb nagö. Sɨm cɨnöb, sɨm rɨlax; röböxnöb, röböxlax. Makwam mögörɨb sɨm rɨman, rɨg wobmä aku, magalɨg pön hönöb, magalɨg pön hölax; bli ör pön hönöb, bli ör pön hölax; magalɨg ram nagö yöraku röböx hönöb, röböx hölax. Aku mönö mɨdölöx. Jɨ naŋ inakmönö höirö aku, anör inakmönö höröiö; God nugwo kwo algör ör inakmönö höirö. Naŋ pödpöd rɨmɨn mag akuyöbö ailö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pita aliö rɨmɨn, Ananaias nugwön mag akwör hö pɨn mɨgrö bö palön aŋadö wöröxöŋa. Almɨn nugugɨrön, nöbö mö bla alöŋ mag aku nugwön, ölölö rɨmɨn ipöxmä. ");
INSERT INTO tmd_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ha nöbö bla hön, nöbäpö högi mɨŋ aku ñapñap uñ wobön, pön du hogw pɨlmä. ");
INSERT INTO tmd_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","8","Makwam mönɨŋa nuŋ nöbönɨŋ nuŋwa wöröxɨm pön du hogw pɨlim aku nugwölöŋ. Nuŋ hör metyöbö mag i mɨdön hömɨn, Pita nugwo yadöŋa, “Mögörɨb ñɨŋ mönöbö aku sɨm rɨm, rɨg aliö akwör woböi ä?” röŋa. Aliö rɨmɨn, mönɨŋa yadöŋa, “Woböi rɨg aku rag hö maku pal,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Aliö rɨmɨn, Pita nugwo yadöŋa, “Ñɨŋ mönöbö rama pödpöd rɨmɨn mönö paŋyöbö i yad ödör nɨgön alöi? Nöbö Diba Inöm nuŋwa inakmönö höröi aku nugwenɨŋö, rön, akuyöbö alöi ä? Nugwö! Nöbönaŋ wöröxmɨn, pön du hogw pɨlöi nöbö bla mɨdöi ubalɨj il yörɨk. Nagö kwo algör pɨrag duba rɨmɨdöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Aliö rɨmɨn nugugɨrön, mag mɨd akwör, Pita yödpɨlö il yöra pɨn mɨgrö bö palön wöröxöŋa. Nöbönɨŋ nugwo pön du hogw pɨlim ha nöbö rogw aku hön, mönɨŋa algör ör mödö aŋadö wöröxöŋ aku nugwön, nugwo pön du nöbönɨŋ nugwo hogw pɨlim yöra pedöx pedöxiö hogw pɨlmä. ");
INSERT INTO tmd_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Krais nugw pim nöbö mö bla aipam, nöbö mö bla aipam, ap rɨg röŋ aku nugwön, magalɨg ölölö rɨmɨn ipöxmä. ");
INSERT INTO tmd_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jisas mönö wä pön dub nöbö akuyöbö möl sö ap rölɨbä akuyöbö mɨga akwör nöbö mö mɨdim mibɨl yöraku rɨmɨdmä. Makwam nöbö mö God Mönö nugwön Krais nugw pim bla, magalɨg hö mögum rɨmɨdmä God höjöpalɨb rama rɨŋadö bö “Solomon Ram Bötö” me röi möl aku. ");
INSERT INTO tmd_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nöbö mö piaku bli, Krais nugw pim nöbö mö akuyöbö ñɨgö nugumɨn wä röŋa, jɨ Krais nöbö mö nuŋ mɨdöi piaku, an pödpödiö du ñɨŋ pɨsaŋ mögum cɨnɨŋö, rön, ipöxmä. ");
INSERT INTO tmd_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Makwam öim öim nöbö mö yoŋyöbö mɨga akwör, Nöbö Diba nugw pön, nöbö mö hödyöbö piaku pɨsaŋ hö nɨgiö nɨgön paŋör mögum rɨmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Jerusalem nöbö mö, Jisas mönö wä pön dub nöbö bla rɨmä akuyöbö nugwön, nöbö mö wöj pɨlmɨdim bla pön hö ödöi diba pedöx pedöxiö nɨgön, köp malö malö yöd nɨgön yadmä, “Pita hö duaŋ, naiö inaua nuŋwa ñɨgö palaŋ, kömö nɨgaŋ,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nöbö mö hör mögörɨb Jerusalem il yöra mɨdim bla, akuyöbö algör nöbö mö ap röŋ bla aipam, nöbö mö ragwo as alɨg mɨdim bla aipam pön hömä. Pön hömɨdmɨn, ñɨgö rɨm, magalɨg kömö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Almɨdmɨn, God ap höjöpal ur nölɨb nöbö dib ödöriö aku aipam, nöbö nugub nuŋwa Sadiusi nöbö bla aipam, ñɨŋ ap rölɨbä akuyöbö aliö rɨŋ ib ana pɨn diönɨŋö, rön, Jisas mönö wä pön dub nöbö bla ñɨgö nugumɨn ölɨsö wölöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ñɨgö ölɨsö wölmɨn, Jisas mönö wä pön dub nöbö bla ñɨŋ pɨ cɨcɨ nɨgön, pön hön gapman adö ñɨgö nölmɨn, nag nɨgmä. ");
INSERT INTO tmd_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nag nɨgmä aku, jɨ wop akwör pɨxmag yuö bö, Nöbö Diba ejol i yad abmɨn, hön ubalɨja rödön, ñɨgö yölɨŋ pön rɨŋö bö dumä. ");
INSERT INTO tmd_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Rɨŋö bö pön duön ejola yadöŋa, “Ñɨŋ God höjöpalɨb rama du gɨrön, nöbö mö bla ñɨgö, God raŋ öim öim mɨjöñ mönö mag wä aku magalɨg yad nöl ri abne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Aliö rɨmɨn, ruö löumɨn nugugɨrön, ñɨŋ God höjöpalɨb rama duön, ejola yadöŋ mag akuyöbö, ñɨŋ ila nɨgön nöbö mö bla ñɨgö mönö mag wä aku yad nölmä. Aliö yad nölmɨn nugugɨrön, God ap höjöpal ur nölɨb nöbö dib ödöriö aku aipam, nöbö nugub nuŋ bla aipam hömɨn, mönö pɨ nuöm nɨgɨb nöbö bla ñɨgö magalɨg wö rɨmɨn, hö Kansol diba mögum rɨm, God höjöpalɨb rama nugwidɨx mɨdɨb nöbö bla yad abön yadmä, “Jisas mönö wä pön dub nöbö bla nag nɨgöl aku weik du yölɨŋ pön höne,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Aliö rɨmɨn, God höjöpalɨb rama nugwidɨx mɨdɨb nöbö bla kɨlabɨs ram aku duön nugumɨn, Jisas mönö wä pön dub nöbö bla mɨdölim. Ñɨŋ höuöil hön yadmä, ");
INSERT INTO tmd_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“An du nugumɨn, ubalɨja rɨg wöl göi akwör mɨdmɨn, nugwidɨx mɨdɨb nöbö bla algör ör ubalɨj il aku nugugu mɨdöi aku, jɨ an uba rödön, ram möl yuadö wölu nugumɨn, nöbö i mɨ mɨdölö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Aliö rɨmɨn, God höjöpalɨb rama nugwidɨx mɨdöi nöbö bla nöbö dib ñɨŋ aku aipam, God ap höjöpal ur nölɨb nöbö dib bla aipam, mönö aku nugwön, aliö al aku pödpöd cönɨŋö, rön, rɨb mɨga akwör yöx nugumä. ");
INSERT INTO tmd_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Aliö rɨb mɨga yöx nugw mɨdɨm nugugɨrön, nöbö i hön ñɨgö yadöŋa, “Nöbö nag nɨgim bla, ñɨŋ du God höjöpalɨb rama mɨd gɨrön, nöbö mö mönö yad nölmɨdöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Aliö rɨmɨn, God höjöpalɨb rama nugwidɨx mɨdɨb nöbö diba, nöbö nuŋ bli ñɨgö yölɨŋön, Jisas mönö wä pön dub nöbö rama pɨba dumä. Duön, Jerusalem nöbö mö kɨyöbö anɨŋ rɨg röd paiöñɨŋö, rön, ñɨgö yadyöxön rölim; tar yölɨŋ pön hömä. ");
INSERT INTO tmd_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Jisas mönö wä pön dub nöbö bla ñɨgö tar yölɨŋ pön Kansol hö mögum rɨ mɨdim mibɨl yöra pön höm, God ap höjöpal ur nölɨb nöbö dib ödöriö aku ñɨgö yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Ñɨgö, Jisas mönö mag aku yad nölmɨjeñɨŋe, rön, mönö ölɨsö yadön yadöla aku, jɨ yad wöhö nugwön röböxöla. Ñɨŋ du Jerusalem nöbö mö ñɨgö magalɨg Jisas mönö mag aku yad nöl gɨrön, anör yad höimöuön yadmɨdöia, ‘Ñɨŋör Jisas nugwo pɨl pal nɨgöiŋö,’ rɨmɨdöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Aliö rɨmɨdmɨn, Pita Jisas mönö wä pön dub nöbö bli pɨsaŋ yadmä, “Nöbö mö mönö yadöi aku pöinɨŋ; God mönö nuŋ akwör pɨnɨŋa! ");
INSERT INTO tmd_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jisas nugwo bɨ höñ sö pɨl pal nɨgɨm wöröxöŋ aku, jɨ nöso auso nöbö höjöpalmɨdim God akwör rɨmɨn, höbkal öbɨlöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Öbɨlmɨn, God nuŋ rɨmɨn, wölu mögörɨb adöx yöd röul adö kau sö yöraku duön, God imag mɨrɨx nuŋ adö mɨda. Makwam an nugumɨn, nuŋwör Kiŋ mɨdön, anɨŋ kömö pöna. Nuŋ anɨŋ Isrel nöbö mö uliöxön, ap kib mag gwogwo röl aku, pödpöd rɨmɨn aliö alölɨŋö, rön, röböxɨŋ, nuŋ nugwön ap gwogwo röl aku röböxön, anɨŋ kömö pöna. ");
INSERT INTO tmd_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","God rɨ aku, an mämäg ana keir nugwön, rɨmɨj möl ana keir audiöx nugwön, nöbö mö bla ñɨgö yad nölmɨdöla. Nöbö mö God mönö nuŋwa nugw pön rɨg yad mag akwör rɨmɨjöñ akuyöbö, God nuŋ Inöm Leia ñɨgö nölön, nuŋ ñɨgö kwo algör mönö wä aku yad nöl ri abön raŋ nugwöñɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Jisas mönö wä pön dub nöbö bla aliö rɨmɨdmɨn, mönö pɨ nuöm nɨgɨb nöbö hö mögum rɨ mɨdim yöraku ölɨsö rödön yadmä, “Ñɨŋ mɨ aŋadö pɨl pal nɨgnɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Aliö rɨmɨn mönö, mibɨl yöraku nöbö i mɨdöŋa, ib nuŋwa Gameliel. Nuŋ Perisi nöbö, lo mönö yad nölɨb nöbö ñɨŋa i. Juda nöbö mö magalɨg nugwo nugumɨn wä rɨmɨdöŋa. Nöbö aku öbɨlön yadöŋa, “Nöbö rogw kɨ ñɨgö yadɨŋ rɨŋö bö röu duŋ. Nɨ ñɨgö mönö i yad nöinö,” röŋa. Aliö rɨmɨn, nöbö adaku yad rɨŋö bö abmä. ");
INSERT INTO tmd_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nöbö adaku yad rɨŋö bö abɨm nugugɨrön, Gameliel nuŋ nöbö Kansol bla ñɨgö yadöŋa, “Isrel nöbö ruai, ñɨŋ nöbö pik ñɨgö agö magɨm rɨba rɨmɨdöi aku, rɨbyöx nugw ri aböña. ");
INSERT INTO tmd_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ñɨŋ nugwöia, höd Tudas, nɨ nöbö dib me rön yadmɨn, mönö nuŋwa yadmɨd aku nöbö mö mɨga akwör, po hadred akuyöbö, nugw pɨmä. Jɨ mai nöbö bli nugwo pɨl pal nɨg gɨm, nöbö mö mönö nugwo nugw pɨmɨdim bla yau hörɨrör dum pöröŋa. ");
INSERT INTO tmd_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Makwam mai, ib ana pim wop aku, algör Judas nöbö Galili yöbö aku yadöŋa, ‘An gapman bla pɨsaŋ nuö nuö rön, ñɨŋ rɨbɨx abnɨŋö,’ röŋa. Aliö rɨmɨn, nöbö mö mɨga akwör mönö nugwo pön, öbɨl gapman pɨsaŋ nuö nuö pɨlmä. Jɨ mɨdɨp duön, nöbö aku nugwo algör pɨl pal nɨg gɨm, nöbö mö mönö nugwo nugw pɨmɨdim bla yau hörɨrör dum pöröŋa. ");
INSERT INTO tmd_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Makwam mɨ, nɨ ñɨgö yadmɨdla, nöbö mönö diba yadmɨdöl kɨyöbö ñɨŋ rɨ gwogwam rɨmɨjeñ. Ñɨgö hör yad abɨŋ duŋ. Rɨb ñɨŋ keira yöx nugwön röi aku, du dib röxönɨŋönö wöhö rön nugwɨŋ pɨn diöna. ");
INSERT INTO tmd_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Jɨ God nuŋ yadmɨn röi aku, ñɨŋ nöbö Kansol ap i rɨbä maga nɨgen. Ñɨŋ rɨ gwogwam cöñ aku, nöbö piaku pɨsaŋ nuö nuö peñ; God pɨsaŋ nuö nuö pöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Gameliel aliö rɨmɨn, nöbö Kansol bla rɨg yadöŋ akuyöbö nugwön, Jisas mönö wä pön dub nöbö bla ñɨgö yadmɨn hömɨn, naga pɨ ñɨgö uplöb palcɨx bacɨx rɨ palön, “Jisas mönö mag aku mai yad nölmɨjeñ, mɨ wöhö,” rön, ñɨgö yad abɨm dumä. ");
INSERT INTO tmd_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Makwam Jisas mönö wä pön dub nöbö bla, anɨŋ pödpöd rɨmɨn aliö alöiŋö, rön, nugwölim. God anɨŋ Jisas nöbö nuŋwa ödöriö, me rön, rɨm, an mag akuyöbö alöiŋö, rön, Jisas nugwo ri ablaŋe rön, Kansol dib aku röböxön dumä. ");
INSERT INTO tmd_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Duön, öim öim God höjöpalɨb rama rɨŋö yöraku duön, ram ram piaku duön, Jisas nuŋ Krais, me rön, mönö wä aku yad nölmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mɨdɨp duön, nöbö mö Jisas nugw pim bla, mɨga magöri rɨ gɨ mɨdmä. Makwam Juda nöbö mö Grik mönö nugwim akuyöbö, Juda nöbö mö Juda mönö yöbö nugwim akuyöbö ñɨgö yadyöxön yadmä, “Lap wösrö ñɨŋ akuyöbö ñɨgö rɨg, ap mag, ap bla nuöm nɨg nöl ri aböia, jɨ lap wösrö an bla ñɨgö ap nuöm nɨg nöl ri abölöiŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Aliö rɨmɨdmɨn, Jisas mönö wä pön dub nöbö akuyöbö möl sö piaku nugwön, nöbö mö Jisas nugw pim bla magalɨg wö rɨmɨn hömɨn yadmä, “Haul nöbö mölöu nöbö. An God Mönö yad nölöl mönö aku röböxön, nöbö mö akuyöbö ñɨgö ap nuöm nɨg nöinɨŋ aku, wä renɨm. ");
INSERT INTO tmd_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Makwam, ñɨŋ nöbö akuyöbö mɨj sö hölu nugwön yadɨŋ, an ñɨŋ mabö aku yad nɨgɨŋ, mabö aku cöña. Makwam God Inöma ñɨgö aja wölön rɨb wä nöl nöbö piakwör nugwön yad nɨgöña. ");
INSERT INTO tmd_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","An piöŋö God höjöpal gɨrön, nöbö mö akuyöbö ñɨgö God Mönö aku yad nöl gɨrön mɨjnɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Mönö yadmɨdim aku nugumɨn, ñɨgö magalɨg wä rɨmɨn, nöbö akuyöbö mɨj sö yad nɨgmä. Nöbö piaku i Stipen. Stipen nuŋ God nugw pɨ gö nɨgön rɨmɨdöŋa. Inöm Leia nugwo aja wöl gɨ mɨdmɨda. I Pilip, i Prokoras, i Naikena, i Timon, i Pamenas, i Nikolas. Nikolas nuŋ taun dib Adiok yöbö. Nuŋ höd Juda nöbö yöi aku, jɨ mai Juda nöbö mö rɨbyöx nugwim akuyöbö nugw pöŋa. Makwam mai nuŋ Jisas nugw pöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Nöbö mɨj sö piaku yad nɨgön, ñɨgö pön Jisas mönö wä pön dub nöbö bla mɨdim yöra pön höm, ñɨŋ God höjöpalön, imaga yöcmac ñɨgö rol sö nɨgmä. ");
INSERT INTO tmd_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Makwam ñɨŋ God Mönö yad nölmɨn, dumɨn nugugɨrön, Jerusalem nöbö mö mɨga akwör Jisas nugw pɨmä. God ap höjöpal ur nölɨb nöbö bla mɨga akwör Jisas mönö wä aku nugwön nugw pɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","God nuŋ Stipen nugwo pɨ ri abön, ölɨsö nuŋwa nugwo nölmɨn, Stipen nuŋ ap rölɨbä piaku, ap nugub nugwölɨbä piaku, mɨga akwör nöbö mö mɨdim mibɨl yöra rɨmɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Makwam Juda nöbö mö mögörɨb hör hör piakuyöbö bli hön Juda mögum rɨb ram i hön, God höjöpalmɨdmä; Juda mögum rɨb ram aku, “Weik Nag Mɨdölöl Ram” me rɨmɨdmä. Juda nöbö piaku, bli Sairini taun yöbö, bli taun dib Aleksadria yöbö, bli Silisia Propins yöbö, bli Esia Propins yöbö. Ñɨŋ Stipen röŋ akuyöbö nugwön, ususör rön nugwo mönö nuö nuö yadmä aku, ");
INSERT INTO tmd_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","jɨ God Inöma nuŋ Stipen nugwo rɨb wä mɨda nölmɨn nugugɨrön, Juda nöbö bla nugwo mönö kai yadmä aku, rɨbyöx nugw ri abön paiŋö algör ör mönö wä mɨd akwör yadmɨn, nugwo paiŋö yadɨb maga nɨgölöŋ. ");
INSERT INTO tmd_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Jɨ ñɨŋ Stipen nugwo yad wöhö nugwön, du nöbö inakmönö hörɨb bli ñɨgö tar yad ri abmɨn, ñɨŋ hön yadmä, “An nugwöla, nöbö kɨ nuŋ Mosɨs mönö kai kɨtöŋ aku yad höimöuön, God nugwo yad höimöuön rö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ñɨŋ inakmönö aku hörmɨdmɨn, nöbö mö hör piaku nɨgön, mönö pɨ nuöm nɨgɨb nöbö bla nɨgön, lo mönö yad nölɨb nöbö bla nɨgön, höbwab ñɨgö aku gwogwo rɨmɨn, Stipen nugwo mönö diba yadɨba pön, Juda Kansol diba mɨdim piaku pön dumä. ");
INSERT INTO tmd_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Pön duön, nöbö inakmönö hörɨb bli alɨg pön höm, ñɨŋ yadmä, “An nugumɨn, nöbö kɨ öim öim God höjöpalɨb ram lei kɨ aipam yad mönö nɨgön, Mosɨs lo mönö kai kɨtöŋ aku aipam yad mönö nɨgön ra. ");
INSERT INTO tmd_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Makwam nuŋ mönö i yadmɨn nugwöl aku yada, ‘Jisas nöbö Nasaret yöbö aku, mai God höjöpalɨb ram kɨ hajal aböna. Jisas nuŋ raŋ, Mosɨs anɨŋ yad nölöŋ mönö adaku röböxön, mönö yoŋyöbö pön mai dinɨŋö,’ rö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Makwam Juda Kansol diba mɨdim nöbö bla, Stipen nugwo riö cɨx nugugu mɨdön nugumɨn, haŋaj mämäg yuö nuŋ adaku ejol haŋaj mämäg yuö röxg nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ñɨŋ mönö inakmönö aku hörɨm, God ap höjöpal ur nölɨb nöbö dib ödöriö aku Stipen nugwo yadöŋa, “Mönö nagö yadöi aku mi yadöiŋönö inakmönö höröi?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Aliö rɨmɨn, Stipen yadöŋa, “Acö nöböhöd nöbö, nugwi! Nöso maduebö ana Ebraham maduar ör taun dib Haran duölöŋ mag aku, mögörɨb Mesopotemia mɨdöŋ mag aku, God mil wä keiryöbö alɨg mɨd aku nugwo yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Mögörɨb nagö kɨ röböxön, nöbö mö nagö bla röböxön, mögörɨb hör i nɨ nagö yabun aku duö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Aliö rɨmɨn, Ebraham mögörɨb dib Kaldia mɨdmɨd yöraku röböxön, taun dib Haran du mɨdmɨda. Mai Ebraham nuö wöröxɨm, God nuŋ yadmɨn, Ebraham nuŋ hö mögörɨb ñɨŋ mɨdöi yörɨk mɨdmɨda. ");
INSERT INTO tmd_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Wop aku God nuŋ Ebraham nugwo mögörɨb möl i yadölöŋ. Hön hör ör mɨdmɨda. Wop aku Ebraham ha i yöxölöŋ; hör ör mɨdmɨda. Jɨ God nuŋ Ebraham nugwo yadöŋa, ‘Mai mögörɨb kɨ nagö pɨnö. Halöu ha nagö yöx pön haŋ yöx pön höŋ diön piaku, mögörɨb kɨ algör ör pön mɨjöñɨŋö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Makwam God mönö i yadön yadöŋa, ‘Halöu ha nagö yöx pön haŋ yöx pön höŋ diön piaku, du nöbö mö hör mögörɨb piaku mɨdɨŋ, ñɨgö magalɨg nag nɨgön, mɨ rɨ gwogwam rön, nag mabö röxg yad nɨg gɨŋ rɨmɨdɨŋ nugugɨrön, kɨm akuyöbö po hadred (400) yöñöna. ");
INSERT INTO tmd_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Makwam nöbö mö ñɨgö almɨjöñ akuyöbö, nɨ piöŋö paiŋö ñɨgö rɨ gwogwam cɨna. Nöbö mö naŋ bla, mögörɨb aku röböxön, hö nɨ höjöpalön rɨ gör mɨjöñ mögörɨb kɨ,’ me röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Makwam God nuŋ Ebraham nugwo mönö ölɨsö ma i yad nɨgön yadöŋa, ‘Halöu ha nagö yöx pön haŋ yöx pön höŋ diön piaku, ñɨgö nugwidɨx mɨjɨn makwam, ha kiai hañkapa rɨl uña ödörɨŋ,’ me röŋa. God aliö rɨmɨn, mai Ebraham ha nuŋwa Aisak nugwo yöx pön hön, wop akuyöbö mɨj sö mɨdön, wop amñaxɨb aku ha aku nugwo rɨl uña ödöröŋa. Aisak piöŋö Jekop nugwo yöx pön höŋa. Jekop nuŋ piöŋö ha akuyöbö möl sö yöx pön höŋ makwam, an Isrel nöbö mö ila hörɨrör mɨdöla. ");
INSERT INTO tmd_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Nöso maduebö an piaku, nöbö höd adö bla pɨgnɨŋ ñɨŋa Josep rɨb gwogwo yöx nugumɨn, ölɨsö wölmɨn, nugwo pön nöbö adö bli nölmɨn, nugwo wobön pön mögörɨb Ijip dumä. Pön dumɨn, mɨd ri abölöŋ, jɨ God nuŋ Josep röböxölöŋ. ");
INSERT INTO tmd_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ömörö diba Josep nugwo hömɨdöŋ aku, God nuŋ nugwön Josep nugwo nugwidɨx mɨd ri abmɨdöŋa. God nuŋ Josep nugwo rɨb wä nölön rɨmɨn, Ijip Kiŋ Pero, nöbö Josep kɨ nuŋ rɨbyöx nugw ri abön rö, rön, nugwo yad nɨgmɨn, mögörɨb Ijip aipam, ram ap nuŋ bla magalɨg aipam nugwidɨx mɨdmɨda. ");
INSERT INTO tmd_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Mai wop i kiö dib ödöriö aku, mögörɨb Ijip aipam, mögörɨb an Kenan kɨ aipam höm, nöso an mögörɨb Kenan kɨ mɨdim bla, ap maga hölu nugumɨn, ap mag nɨmɨb i mɨdölmɨn, rɨb diba yöxmä. ");
INSERT INTO tmd_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Makwam nuö ñɨŋ Jekop mönö i nugwöŋa, ap mag mɨga mögörɨb Ijip mɨdöŋa. Makwam nugwön ha nuŋ bla ñɨgö yadmɨn, ap mag wobɨba Ijip dumä. ");
INSERT INTO tmd_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Du wob pön hön, nɨm pörön, iswob wobɨba dumä. Dumɨn, pɨgnɨŋ Josep ñɨgö yadöŋa, ‘Nöböhöd nöbö, ñɨŋ nɨ yönɨmɨm me rön nugwöiŋönö? Nɨ haul ñɨŋa Josep ör,’ me röŋa. Aliö rɨmɨn, Ijip Kiŋ Pero mönö aku nugwön yadöŋa, ‘Aku Josep haul nöbö nuŋ bɨlɨm e!’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Josep piöŋö, acö na Jekop, nöbö mö nuŋ bla pɨsaŋ yadkap höŋ, me rön, mönö yad abmɨn, nuö Jekop nöbö mö padokwo padök mös paŋ höuöiliö hö wölu iŋösu sö (75) pön pɨsaŋ dumä. ");
INSERT INTO tmd_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Nuö Jekop aliö alön, mögörɨb Ijip du mɨdön, wöröxöŋa. Mɨdɨp duön, nöso nöbö piaku magalɨg wöröx pörmä. ");
INSERT INTO tmd_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Makwam mai ha ñɨŋ bla nuö yöd bla hölu rag duön, taun dib Sekem hogw pɨlmä. Nöbäpö hogwaj aku, nöso maduebö Ebraham, Hemor ha nuŋ bla ñɨgö rɨg i nölön woböŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Makwam God Ebraham nugwo höd rɨg cɨnö, rön, mönö rɨg yad nɨgöŋ akuyöbö rɨba rön röŋ makwam, nöbö mö an Isrel mögörɨb Ijip mɨdim akuyöbö, halöu ha yöxɨp duön yöxɨp höuöilmel rön, nöbö mö mɨga mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nöbö mö an Isrel mɨga akwör mɨdim wop aku, mögörɨb Ijip aku kiŋ yoŋyöbö wöxnö nɨgöŋa. Kiŋ yoŋyöbö aku nöso Josep nugwo nugwölöŋ makwam, ");
INSERT INTO tmd_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","nöbö mö an bla rɨ gwogwam ödöriö rön, mönö ölɨsö yadmɨn, halöu ha ñɨŋ bla yöx pön hön, rɨŋadö pi blaku abɨm, ñɨŋ keir mɨdön wöröxmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Aliö almä aku, jɨ wop mibɨl yöraku, mönöbö hogwi ha wä mɨdöy yöx pön hön, ib nuŋwa Mosɨs me rɨmä. Ha aku nugwo röun mös paŋ ram möl piaku umad gɨm mɨdmɨda. ");
INSERT INTO tmd_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Mai ha kiai aku nugwo pön du rɨŋadö bö nɨgɨm, Pero halöu nuŋ aku hön, nugwo nugwön, rag du ha nɨ, me rön, rɨg urmɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Nuŋ mag akuyöbö alön rɨg urɨm, Mosɨs nuŋ dib röxmɨn, Ijip nöbö mö ñɨŋ agap apɨm rɨmɨdim aku, nugwo yad nöl ri abmä. Nuŋ mönö ölɨsö yadön, mabö ususör rön rɨmɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Makwam Mosɨs kɨm nuŋ akuyöbö padokwo padök paŋyöbö i höuöiliö hö pɨn du adokwebö mɨj bö (40) yönmɨn, nɨ du nöbö mö nɨ Isrel pia nugwön hönö, röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Makwam du nugumɨn, Ijip nöbö hö Isrel nöbö i nugwo mɨ göj palmɨdöŋa. Mosɨs nugwön, Isrel nöbö aku nugwo kömö pön, Ijip nöbö aku nugwo aŋadö pɨl pal nɨgɨm wöröxöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Makwam Mosɨs rɨb nuŋwa yöx nugwöŋa, ‘Nöbö mö nɨ Isrel yajöña, “God Mosɨs nugwo rɨba nölmɨn, hön anɨŋ pɨ asɨx abmɨn, mɨd ri aböñɨŋö,” cöñɨŋö,’ rön rɨbyöx nugwöŋa, jɨ ñɨŋ rɨb aku yöx nugwölim. ");
INSERT INTO tmd_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Makwam löumɨn Mosɨs duön nugumɨn, Isrel nöbö mös nuö pɨlmɨdmä. Almɨdmɨn nugwön yadöŋa, ‘Nöbö mɨg, ñɨŋ hödpɨg hogwa mɨdöia; nuö pɨlmɨdöi aku röböxi!’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Aliö rɨmɨn, nöbö i nöbö i nugwo palmɨdöŋ aku, Mosɨs nugwo pɨgöur pikwo abön yadöŋa, ‘Nagö yönɨm yadmɨn, nöbö diba mɨdön, anɨŋ mönö pɨ nuöm nɨgɨb nöbö akuyöbö nugwidɨx mɨdlö? ");
INSERT INTO tmd_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Nagö idöm Ijip nöbö aku pɨl pal nɨgmö aku, weik nɨ piöŋö pɨl pal nɨgɨba rɨmɨdlanö ä?’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Aliö rɨmɨn, Mosɨs nöbö pɨl pal nɨgɨl aku nugwöiŋö, rön, bör du mögörɨb Midian duön, nöbö hör i röxg mɨdmɨda. Wop mibɨl yöraku, nuŋ mö pön, ha mös yöx pön höŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Al gɨrön hör ör mɨdmɨn kɨm padokwo padök paŋyöbö i höuöiliö hö pɨn du adokwebö mɨj bö (40) yönöŋa. Mai wop i Sainai pɨda il bö mögörɨb rɨg kap yöra mɨdön nugumɨn, ejol i hön, bɨ wab paŋyöbö i pina nɨgmɨdöŋ mibɨl yöra wöxnö nɨgmɨn nugwöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Almɨdmɨn Mosɨs nugwön, ap aku pödpöd rɨmɨdö, rön, du il yöra nugumɨn nugugɨrön, Nöbö Diba yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Nöhönɨŋ maduebö Ebraham, Aisak, Jekop, God ñɨŋa nɨ mɨdlö,’ röŋa. Aliö rɨmɨn, Mosɨs, aku Nöbö Diba akwör yadmɨdö, rön, ipöxön gɨl gɨl rön, ubɨlön mämäga nugwölöŋ. ");
INSERT INTO tmd_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Makwam Nöbö Diba Mosɨs nugwo yadöŋa, ‘Mögörɨb lei kɨ hö mɨdlö aku, yamsö uñ nagö wab aku pɨ rödö. ");
INSERT INTO tmd_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ijip nöbö mö bla, Isrel nöbö mö na mögörɨb Ijip mɨdöi akuyöbö ñɨgö mɨ rɨ gwogwam röi aku nɨ nugula. Ñɨŋ imön rɨmɨdöi aku audiöx nugwön, hön ñɨgö pɨ asɨx abɨba höla. Makwam, nagö höbkal Ijip duö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Isrel nöbö mö höd Mosɨs nugwo yadmä, ‘Nagö yön yadmɨn, nöbö diba mɨdön, anɨŋ mönö pɨ nuöm nɨgɨb nöbö akuyöbö nugwidɨx mɨdlö?’ rɨmä. Jɨ mai, God ejol nuŋwa yad abmɨn hön, rɨn yön pina nɨgmɨdöŋ mibɨl aku Mosɨs nugwo wöxnö nɨgmɨn, God nuŋ keir Mosɨs nugwo nöbö dib ñɨŋa mɨdön ñɨgö kömö paŋ, me rön, yad aböŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mosɨs Ijip duön, ap rölɨbä akuyöbö bli piaku rön, nöbö mö nuŋ Isrel bla ñɨgö pön ban yuö dib ‘Paskwolö’ me röi aku duön, ap rölɨbä akuyöbö bli piaku rön, mai Isrel nöbö mö yölɨŋ pön du mögörɨb rɨg kap mibɨl piaku duön, ap rölɨbä akuyöbö bli piaku rɨ gɨrön mɨdmɨda. Al gɨr mɨdɨm mɨdɨm, kɨm akuyöbö padokwo padök paŋyöbö i höuöiliö hö pɨn du adokwebö mɨj bö (40) yönöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Mosɨs nuŋwör nöbö mö Isrel ñɨgö yadöŋa, ‘God nuŋ, mönö nuŋwa yadɨb nöbö i, ha ñɨŋa keir nöbö nɨ röxgɨb i, yad abaŋ, ñɨgö hönɨŋö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mosɨs nuŋ mögörɨb rɨg kap mibɨl piaku mɨdöŋa; nuŋ nöso auso an bla pɨsaŋ mɨdöŋa; Sainai Pɨd piaku ejol i hön Mosɨs nugwo mönö yad nölöŋa. Mosɨs mönö aku pön an Isrel nöbö mö yad nöiönɨŋö, rön, God nuŋ mönö kömö aku Mosɨs nugwo nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Mosɨs mönö kömö aku yad nölöŋ aku, jɨ nöso an bla mönö aku pölim. Ñɨŋ Mosɨs nugwo yad mönö nɨgön, höuöil Ijip duŋö, rön, rɨb aku yöxmä. ");
INSERT INTO tmd_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ñɨŋ Mosɨs pɨgnɨŋ Eron nugwo yadmä, ‘Nöbö nagö Mosɨs anɨŋ Ijip yöbö pön hö aku, nugwo agapɨm rɨ aku an nugwölöl. Makwam, nagö anɨŋ ap god akuyöbö bli raŋ, nöbö an bli god rɨmɨjɨnö piaku pɨrag höd duŋ, an mai duŋö,’ rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Wop akwör, god inakmönö hön kau ha i röxg rɨ nɨgön, yöur ap bla pal rag hö höjöpal ur nölmä. Ñɨŋ imag ñɨŋa keir rɨmä ap aku nugwön, aku god an, me rön, wahax pɨ gɨrön ap diba ur nɨmɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Almɨdmɨn, God ñɨgö röböxön yadöŋa, ‘Alöi aku, naiö, röun, gupö ap bla amnör höjöpalön mɨdɨŋ,’ me röŋa. Wop aku ñɨŋ ap piakwör höjöpalmɨdim aku mɨ, God mönö yadɨb nöbö i God Mönö rɨb i kai kɨtön yadöŋa, ‘Isrel nöbö mö. Ñɨŋ höd kɨm padokwo padök paŋyöbö i höuöiliö hö pɨn du adokwebö mɨj bö (40) mögörɨb rɨg kap mibɨl piaku yönmɨdim wop aku, hön kau hön sipsip ap bla pal nɨ höjöpal ur nölmɨdölim. ");
INSERT INTO tmd_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ñɨŋ hör ap inakmönö mös ñɨŋ keir rɨ nɨgim aku nugwo ap pal höjöpal ur nöl gɨr mɨdmɨdmä. Ap aku, i Molok me rɨmɨdmä; i gupö röxg rɨ nɨgön, Repan me rɨmɨdmä. Ap god inakmönö hogw akwör, ap uñ rama ur rag yön gɨrön, höjöpal ur nöl gɨr mɨdmɨdmä. Rɨ mɨdmɨdöi aku, nɨ ñɨgö yad abmön, du nag mɨjöñ taun dib Babilon sɨnaŋ adokwöik,’ me röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Nöso nöbö an bla mögörɨb rɨg kap mibɨl piaku mɨdim wop aku ap uñ rama pɨrag yönmɨdmä. Ap uñ ram aku mɨdöŋ aku nugwön, God an pɨsaŋ mɨdö, rön nugumɨdmä. Ap uñ ram aku, God mönö rɨg yadöŋ mag akwör ur nɨg gɨm mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Mai nöso nöbö an bla ñɨŋ ap uñ ram aku Josua nöso nöbö an bla ñɨŋ nölmɨn pɨmä. Mai, ñɨŋ ap uñ ram aku pön hö mɨdmɨn nugugɨrön, God nuŋ nöbö mö mögörɨb yörɨk mɨdim bla höju aböŋa. Ap uñ ram aku mɨdön, mɨdɨp duön, mai Depid yöx pön hömä. ");
INSERT INTO tmd_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Nöso Depid, God nugumɨn wä röŋ nöbö aku, nuŋ God nugwo yad nugwön yadöŋa, ‘Nagö yöwö ran, nɨ ram nagö wä i rɨ nɨgmön, nagö God Jekop höd höjöpalön rɨg rɨmɨd akuyöbö, ram aku mɨjnaŋö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Aliö rɨmɨn, God nuŋ yöwö rölöŋ. Mai Solomon nuŋ God höjöpalɨb rama ur nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Makwam God mɨ bɨl möx sö mɨd Nöbö aku, nöbö mö imaga pön ur nɨgöñ ram bla mɨdenɨm. God mönö yadɨb nöbö i mönö aku yadön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“‘Nöbö Diba nuŋ yada, “Mögörɨb adöx yöd röul adö kau sö yöraku hogw rol kiŋ na aku rola römɨd gɨ mɨdön, mögörɨb il kɨ yödpɨlö na röb gɨ mɨdla. Nɨ agö ramɨm ur nɨgɨŋ, nɨ hölɨmmɨjɨn? Nɨ ram möl kai aŋöi nɨgɨn? ");
INSERT INTO tmd_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ap bla magalɨg imag na keir rɨ nɨgöiödö?” rö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“An keir nugw ri abölɨŋö, rön, ap kib mag gwogwo akwör rön, God Mönö yöxölöi. Nöhönɨŋ nöbö rɨg rɨmɨdöi mag akwör röia. Inöm Leia nuŋ ñɨgö rɨb wä nölɨm nugwöyɨxa, jɨ öim wöhö röia. ");
INSERT INTO tmd_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nöhönɨŋ nöbö bla, God mönö yadɨb nöbö bla ñɨgö magalɨg rɨ ajö nɨgmä. God mönö yadɨb nöbö maduebö piaku, ‘God Mabö Rɨ Nölɨb Nöbö Wä Ödöriö aku hönɨŋö,’ rɨmä. Jɨ nöhönɨŋ nöbö piaku ñɨŋ nöbö piaku algör ör pɨl pal nɨgmä. Makwam weik God Mabö Rɨ Nölɨb Nöbö Wä Ödöriö aku höm, ñɨŋ nugwo mönömɨm nugwön pɨl pal nɨgmä. ");
INSERT INTO tmd_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","God lo mönö nuŋ aku, ejol nuŋ akuyöbö ñɨgö yad abmɨn pön höm pɨmä, jɨ rɨg yad akuyöbö nugwön rölöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Stipen mönö aku yadmɨn nugugɨrön, ñɨgö ölɨsö diba ödöriö wölmɨn, ajmaga öbɨx gɨg yuön ölɨsö rödmä. ");
INSERT INTO tmd_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Makwam Inöm Leia nuŋ Stipen aja wöl gɨ mɨdmɨn nugugɨrön, nuŋ laxiö pisö nugwön adöx yöd röul adö kau sö yöraku nugwöŋa, God mil mag wä keiryöbö nuŋwa mɨdöŋa nugwön Jisas nuŋ God imag mɨrɨx adö öbɨl gɨ mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Stipen nugwön yadöŋa, “Nugwi! Nɨ nugumɨdla, adöx yöd röul adö kau sö yöraku uba röd gɨ mɨda. Nöbö Ha nuŋ aku God imag mɨrɨx adö öbɨl gɨ mɨdö!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Stipen aliö rɨmɨn, rɨmɨj möl ñɨŋ aku iŋsö pidɨxön, rɨb pia magalɨg öbɨlön, mönö bölölö rön mönö diba yadön, ipalɨp du nuŋ mɨdöŋ yöra dumä. ");
INSERT INTO tmd_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Nugwo pɨ cɨcɨ nɨgön, pön dumɨd pön dumɨd taun dib aku rɨŋadö bö pön dumä. Nöbö nugwo inakmönö hörim bla ölɨsö rödön, wölɨj mɨxɨl ñɨŋ bla pɨ rödön, ha nöbö Sol mɨdöŋ il yöra abɨm, nuŋ nugwidɨx mɨdmɨn nugugɨrön, ñɨŋ Stipen nugwo rɨg röd palmä. ");
INSERT INTO tmd_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nugwo aliö palɨm nugugɨrön, Stipen Nöbö Dib nugwo wö rɨ yadön yadöŋa, “Nöbö Dib Jisas, inöm na pö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Aliö rön, höxmax yuön, wö diba rɨ yadön yadöŋa, “Nöbö Dib! Nɨ pɨl pal nɨgmɨdöi kɨ, ap kib mag gwogwo rɨmɨdöi aku nugwön röböxö,” röŋa. Aliö rɨ gɨrön wöröxöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Stipen nugwo rɨg röd pal nɨgim wop aku, Sol il yöra mɨdön, päja yadön wobiö lero röŋa. Wop akwör, Jerusalem ada ila nɨgön, nöbö mö Jisas nugw pɨmɨdim bla ñɨgö mɨ ödöriö rɨ gwogwam rɨmɨdmä. Almɨdmɨn, nöbö mö Jisas nugw pɨmɨdim bla ñɨŋ magalɨg bör mögörɨb Judia piaku aipam, mögörɨb Sameria piaku aipam, malö malö dumä. Makwam Jisas mönö wä pön dub nöbö akuyöbö möl sö piaku ñɨŋör Jerusalem mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Makwam God Mönö rɨg yad mag akwör rɨmɨdöi nöbö bli, Stipen nugwo mɨ ögwö yöxön, mɨ göj imön, nöbäpö högia pön du hogw pɨlmä. ");
INSERT INTO tmd_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sol nuŋ piöŋö, nöbö mö Jisas nugw pɨmɨdöi bla rɨ gwogwam ödöriö cɨnö, rön, ram ram rɨ gɨrön, nöbö mö piaku ñɨgö amnör pön pɨxɨp du nag nɨgmɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nöbö mö Jisas nugw pɨmɨdim bla bör du mögörɨb hör piaku piaku mɨdmä. Makwam piaku du mɨdön, Jisas mönö wä aku pön du nöbö mö piaku ñɨgö yad nölmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","6","Nöbö nagö Pilip nuŋ kwo algör du taun dib i mögörɨb Sameria yuadö mɨdön, nöbö mö piaku ñɨgö, Mesaia höŋ mönö wä aku yad nölöŋa. Pilip mönö yadöŋ aku aipam, ap rölɨbä akuyöbö röŋ aku aipam nugwön, mönö nuŋ rɨg yadöŋ akuyöbö rɨmɨj pal nugw ri abmä. ");
INSERT INTO tmd_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Pilip nuŋ nöbö mö ragwo as alɨg mɨdim piaku mɨga akwör rɨmɨn, ap piaku aiö rön röu dumä. Nuŋ nöbö mö iŋ wajmag po rɨmɨn lɨd pɨlöŋ bla mɨga akwör aipam, nöbö mö yödpɨlö kakabail um nɨgöŋ bla mɨga akwör aipam, ñɨgö rɨmɨn kömö nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Almɨn nugugɨrön, nöbö mö taun aku hölɨmmɨdim akuyöbö magalɨg mɨ ödöriö wahax pɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Makwam taun dib aku nöbö i hölɨm mɨdmɨda, ib nuŋwa Saimon. Nuŋ kɨj rön, ap rölɨbä akuyöbö bli rɨmɨn, Sameria nöbö mö bla magalɨg rɨb mɨga ödöriö yöx nugumɨdmä. Nɨ mɨ nöbö diba mɨdlö, rɨmɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Saimon nuŋ akuyöbö almɨdmɨn, nöbö mö ib mɨdöŋ piaku aipam, nöbö mö ib mɨdölöŋ piaku aipam, Saimon mönö rɨg yadöŋ akuyöbö nugwön yadmä, “Nöbö kɨ nuŋ god ‘Ölɨsö Dib’ me röl akwör,” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ap rölɨbä akuyöbö piaku öim rɨmɨdöŋa nugwön nöbö mö bla rɨb mɨga yöxön, mönö rɨg yadmɨdöŋ akwör nugumɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Makwam mai Pilip hön, God nöbö mö pön ram nuŋwa adöx yöd röul adö kau sö yöra nugwidɨx mɨdɨb mönö wä aku aipam, Jisas Krais mönö wä nuŋwa aipam, yad nölmɨn, nöbö mö bla ñɨŋ mönö nuŋwa nugw pön, röbö palmä. ");
INSERT INTO tmd_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon nuŋ keir algör ör Jisas nugw pön röbö palöŋa. Pilip dumɨn, Saimon nugwo mai dumɨn nugugɨrön, Pilip ap rölɨbä rɨmɨdöŋ akuyöbö nugwön, Saimon nuŋ aiö waiö röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jisas mönö wä pön dub nöbö bla Jerusalem mɨdɨm nugugɨrön, ñɨgö mönö i yadmä, “Sameria nöbö mö God Mönö nugw pöiŋö,” rɨmä. Ñɨŋ mönö aku nugwön, Pita Jon ñɨgö nöbö hogwa yad abɨm, mögörɨb Sameria dumä. ");
INSERT INTO tmd_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","17","Duön nugumɨn, nöbö mö piaku Jisas nugw pɨm, Nöbö Dib Jisas iba yadön ñɨgö röbö pal nölmä, jɨ Inöm Leia nuŋ ñɨgö hölöŋ. Makwam, Pita Jon nöbö hogwa, Inöm Leia nuŋ ñɨgö haŋ, me rön, höjöpalön, imaga yöcmac ñɨgö rol sö nɨgɨm, Inöm Leia nuŋ ñɨgö paŋ paŋ höŋa. ");
INSERT INTO tmd_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nöbö hogwa imaga yöcmac ñɨgö rol sö nɨgɨm, God nuŋ Inöm Leia nöbö mö piaku ñɨgö nölöŋ aku, Saimon nugwön, nɨ kwo algör ör cɨnö, rön, ñɨgö nöbö hogwa rɨg yabuön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Rɨg kɨ pön, nɨ ölɨsö aku nölɨŋ, nɨ nöbö mö kai kai imag na yöcmac ñɨgö rol sö nɨgmön, ñɨŋ kwo algör ör Inöm Leia pöñɨŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Aliö rɨmɨn, Pita yadöŋa, “God ap wä nuŋwa hör nöl aku, pödpöd rɨmɨn rɨg wobɨba rɨmɨdlö? Rɨg aku nagö keir pɨsaŋ lɨdiöna! ");
INSERT INTO tmd_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Mabö an röl aku nagö pɨsaŋ röinö wöhö. Höbwab rɨb madmag nagö nugw pɨmɨdlö aku, God nugumɨn wä röl. ");
INSERT INTO tmd_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ap kib mag gwogwo cɨnö, rön, rɨbyöx nugulö adaku röböxön, God höjöpalmɨjɨn aku, rɨb gwogwo yöx nugulö aku nugwön röböxbä maga rö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nɨ nugula, ap wä ñɨŋ piaku ap nɨ aliö alɨg mɨdöx, me rön, rɨb gwogwo yöx nugwön, ap kib mag gwogwo rɨman dumɨda. Makwam, nagö ap kib mag gwogwo rɨb mag aku, nag mabö rɨb nöbö röxg mɨdlö. ");
INSERT INTO tmd_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Aliö rɨmɨn, Saimon yadöŋa, “Ñɨŋ nöbö hogwa Nöbö Diba nugwo höjöpalɨŋ, ap nɨ rɨb maga rö, rön yadmɨdöi aku rölaŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Makwam Pita Jon yöŋö, Jisas ñɨgö nöbö hogwa agap apɨm röŋ mönö aku aipam, Nöbö Dib mönö wä aku aipam, nöbö mö bla ñɨgö yad nöl pörön, höuöil Jerusalem duba, ödöi um piaku du gɨrön, mögörɨb Sameria mibɨl yöra ram yöj lɨglɨg agrö mɨga akwör nöbö mö piaku ñɨgö Jisas mönö wä aku yad nöl gɨrön dumä. ");
INSERT INTO tmd_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Makwam Nöbö Diba ejol i hön Pilip nugwo yadöŋa, “Jerusalem yöbö taun dib Gasa duöi ödöi mɨxɨl aku duö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Aliö rɨmɨn, Pilip ödöi yadöŋ mɨxɨl aku duön nugumɨn, nöbö dib i, hön hos pɨxɨp pön du yönmɨd ap waba rol sö römɨdön, ödöi mɨxɨl aku dumɨdöŋa. Nöbö aku nuŋ kwin Kadaki, mögörɨb dib Itiopia nugwidɨx mɨdöŋ mö aku nugwo mabö rɨ gɨrön, rɨg nuŋwa nugwidɨx mɨdmɨda. Nuŋ Jerusalem God höjöpalɨb ram aku duön höjöpal gɨrön mɨd pörön, ");
INSERT INTO tmd_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","höbkal mögörɨb Itiopia duön, God Mönö rɨb Aisaia kai kɨtöŋ aku pön, mämäg nɨg nugu gɨrön dumɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Makwam God Inöma Pilip nugwo yadöŋa, “Hos ap waba pɨxɨp pön dumɨd kwo du il höñ yöra duön, nöbö aku pɨsaŋ duö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","God Inöma rɨg yadöŋ mag akwör, Pilip ipalɨp il höñ yöra duön nugumɨn, nöbö Itiopia yöbö aku, God mönö yadɨb nöbö Aisaia God Mönö rɨba kai kɨtöŋ aku, mämäg nɨg nugu gɨrön dumɨdöŋa. Pilip nugwön yadöŋa, “Naŋ köp mämäg nɨg nugu gɨrön dumɨdlö aku, mönö il aku aliö rö, rön, nugumɨdlanö wöhö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Aliö rɨmɨn, nuŋ yadöŋa, “Nöbö mö bli nɨ yad nölɨŋ nugwön aku yajɨnö,” röŋa. Aliö rön Pilip nugwo yadöŋa, “Wöl rol yörɨk römɨdaŋ an pɨsaŋ duŋö,” röŋa. Aliö rɨmɨn, Pilip du rol yöra römɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Nöbö aku God Mönö rɨba Aisaia kai kɨtöŋ aku mämäg nɨg nugumɨdöŋa. Mönö aku aliö mɨda: “Nuŋ hön sipsip yölɨŋ pön du pɨl pal nɨgöi mag akuyöbö rɨg mɨdöŋa. Hön sipsip ha panö waxmɨn, aiö röl mag akuyöbö, nuŋ algör ör mönö i yadölöŋ. ");
INSERT INTO tmd_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ap gwogwo i rölöŋ aku, jɨ nugwo inakmönö hörön, rɨ gwogwam rɨmä. Nugwo aŋadö pɨl pal nɨgɨm wöröxöŋ makwam, mai agö nöböm röxg mɨdön, ‘Al aliö rɨmɨdö,’ cönɨŋö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Nöbö dib Itiopia yöbö aku mönö aku nugwön, Pilip nugwo yadöŋa, “Mönö yadmɨd kɨ, God mönö yadɨb nöbö aku nuŋ keir yadmɨdönö nöbö hör i yadmɨdö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Aliö rɨmɨn, Pilip God Mönö rɨba mämäg nɨg nugwöi akwör ila nɨgön yadɨp duön duön, Jisas mönö wä aku yad nöl ri aböŋa. ");
INSERT INTO tmd_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Makwam aliö mönö pɨp du gɨrön nugumɨn röbö i mɨdöŋa. Nöbö aku Pilip nugwo yadöŋa, “Röbö mɨd kɨ nɨ röbö pal nöinanö ö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Aliö rɨmɨn, Pilip yadöŋa, “Naŋ Krais nugwo höbwab rɨb madmag na mɨ ödöriö nugw pɨlö, rɨmɨjɨnö aku, nɨ nagö röbö pal nöinö,” röŋa. Aliö rɨmɨn, nöbö aku paiŋö yadöŋa, “Jisas Krais nuŋ God Ha nuŋwa mɨd aku, nɨ nugw pɨlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Aliö rɨmɨn, hön hos ap pɨxɨp pön du yönɨb rola römɨdön hömɨdim aku, hos aku alɨg ödöi yöraku nɨgön, röbö yuö duön, Pilip nöbö aku nugwo röbö pal nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Al gɨrön röbö pal nölön, rɨb yöraku hömɨn nugugɨrön, rɨb pia Nöbö Dib Inöm nuŋwa Pilip nugwo pön, hör möl i pön dumɨn nugugɨrön, nöbö dib aku nugwo nugwölöŋ. Nuŋ piöŋö mɨ ödöriö wahax pɨ gɨrön ödöi aku duöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Makwam Nöbö Dib Inöm nuŋwa Pilip nugwo pön du mögörɨb Asotas nɨgmɨn, nöbö mö mögörɨb piaku taun hörɨrör mɨdim akuyöbö ñɨgö magalɨg Jisas mönö wä aku yad nölɨp dumɨd dumɨd, taun dib Sisaria uröpɨnöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sol nuŋ Nöbö Dib mönö wä nugw pön mai dumɨdim nöbö mö akuyöbö ñɨgö pɨl pal nɨgɨnö, rön, öim mɨ ususör rɨmɨdöŋa. Wop i nuŋ du God ap höjöpal ur nölɨb nöbö dib ödöriö aku nugwo yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","“Nɨ köp bli kai kɨt nölaŋ, nɨ pön du Juda mögum rɨb ram hörɨrör mɨd taun dib Damaskas duön, ñɨgö nöina. Köp aku kai kɨtön yajɨnö, ‘Taun dib Damaskas yöraku, ñɨŋ nöbö mö Jisas nugw pöi bli Juda mögum rɨb ram bla mɨjöñ aku, Sol nugwo yadɨŋ, ñɨgö nag nɨgön, Jerusalem pön haŋ,’ me rön, kai kɨtö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sol köp aku pön, Damaskas igöp igöp rɨmɨn nugugɨrön, rɨb pia adöx yöd röul adö kau sebö mil maga nugwo aböŋa. ");
INSERT INTO tmd_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Sol hön hos rol sö bokwɨr pɨm pɨn mɨgrö bö bɨrmɨn nugugɨrön, mönö i nugwo yadöŋa, “Sol, Sol, nɨ pödpöd rɨmɨn öim rɨ gwogwam rɨmɨdlö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Aliö rɨmɨn, Sol yadöŋa, “Nöbö Dib, nagö yönɨmɨm?” röŋa. Aliö rɨmɨn, yadöŋa, “Nɨ Jisas, nɨ öim rɨ gwogwam rɨmɨdlö akwör yadmɨdla. ");
INSERT INTO tmd_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Makwam nagö öbɨlön, Damaskas duön, nöbö i hön nagö mönö yajön akuyöbö nugwön rane,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Makwam nöbö Sol pɨsaŋ hem bla mönö mag akwör nugwön, nöbö ma aku nugwölön, rɨb diba yöxön mönö bli yadölim. ");
INSERT INTO tmd_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Makwam Sol öbɨlön mämäga ix nugwöŋa, mämäg nuŋwa aŋadö we wölöŋa. Almɨn, nöbö nuŋ pɨsaŋ hem bla iŋpɨlö nuŋwa pön, iŋröb Damaskas dumä. ");
INSERT INTO tmd_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nugwo aliö mämäga we wölmɨn, röbö ap mag ap bla nɨmölön, wop mös paŋ hör ör mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Jisas nugw pöŋ nöbö i Damaskas mɨdöŋa, ib nuŋwa Ananaias. Nöbö aku nuŋ rɨba nugwöŋa, Nöbö Dib nugwo yadöŋa, “Ananaias!” röŋa. Nöbö Diba aliö rɨmɨn, Ananaias yadöŋa, “Nöbö Dib, nɨ mɨdlö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","12","Aliö rɨmɨn, Nöbö Diba yadöŋa, “Sol taun dib Tasas yöbö nöbö aku, God höjöpal gɨrön, rɨba nugwa, nöbö Ananaias me röi aku nugwo du pɨ nugumɨdmɨn, mämäg nuŋwa we wölöŋ aku ix nugwa. Nuŋ weik nɨ höjöpal gɨr mɨd Judas ram aku. Makwam, nagö ödöi ‘Ödöriö’ me röi aku duön, Judas ram aku uröpɨnön ñɨgö yadaŋ, ‘Sol nugwo nuguba hömɨdlö,’ rane,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nöbö Diba aliö rɨmɨn, Ananaias yadöŋa, “Nöbö Dib. Nɨ nugula nöbö mö mɨga yadöia, ‘Nöbö Sol aku Jerusalem nagö adö mɨdöi nöbö mö akuyöbö ñɨgö öim mɨ rɨ gwogwam rö,’ röia. ");
INSERT INTO tmd_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Nuŋ weik Damaskas kɨ hö aku, God ap höjöpal ur nölɨb nöbö dib bla köp bli nugwo nölmɨn, nöbö mö yön yön ib nagö yadmɨn bɨl sö diön akuyöbö, ñɨgö nag nɨgɨnö, rön, hö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ananaias aliö rɨmɨn, Nöbö Diba nugwo yadöŋa, “Duö! Nöbö aku mabö bli nɨ keir nugwo yad nɨgla. Nuŋ mönö wä na aku Isrel nöbö mö bla ñɨgö yad nölön, Isrel nöbö mö yöi bla ñɨgö yad nölön, kiŋ bla ñɨgö yad nölön, cöna. ");
INSERT INTO tmd_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Makwam nuŋ ölɨŋ höb diba pön, ömörö diba pɨ gɨrön, mabö na aku cöna. Aliö alaŋ mönö nɨ keir nugwo yad nöl ri abnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nöbö Diba aliö rɨmɨn, Ananaias dumɨdön, Sol mɨdöŋ ram aku uröpɨnön, ram möl yuadö duön, Sol nugwo yöcmac rol sö imaga nɨgön yadöŋa, “Nöböhöd Sol. Nöbö Dib Jisas nagö ödöi mibɨl yöra höman wöxnö nɨgɨm nugumö aku, nɨ yad abmɨn höl mɨk. Nagö mämäg naŋ iswob ix nugwaŋ, Inöm Leia nuŋ hö yuö nagö bö aja wölaŋ, me rön, nɨ yad abɨm höl gö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ananaias aliö rɨmɨn nugugɨrön, ap hogwai wab röxgɨb Sol mämäg nugwo pöröb mɨdöŋ aku, lɨl rɨ pɨnmɨn nugugɨrön, rɨb pia mämäga ix nugwöŋa. Mämäga nugwön, öbɨl duön, röbö palöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Sol ap nɨmön ölɨsö pöŋa. Makwam Sol nuŋ wop bli nöbö mö Jisas nugw pim piaku pɨsaŋ Damaskas mɨd gɨrön, ");
INSERT INTO tmd_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Juda mögum rɨb ram bla yönön, Jisas nuŋ God Ha nuŋwa mɨd mönö wä aku nöbö mö piaku ñɨgö yad nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nuŋ aliö yad nölmɨdmɨn nugugɨrön, ñɨŋ nugwön aiö waiö rön yadmä, “Nöbö kɨ mɨ, Jerusalem nöbö mö Jisas nugw pöi piaku ñɨgö rɨ gwogwam rɨmɨd nöbö aku! Weik nöbö mö bli kwo nag nɨg pön du, nöbö God höjöpal ur nölɨb nöbö dib bla ñɨgö nöinö, rön, hö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Makwam Sol Jisas mönö wä aku yad nölɨp duön, Jisas nuŋwör Mesaia aku mönö paxdöriö yadmɨn, Juda nöbö Damaskas hölɨmmɨdim bla mönö i paiŋö yadɨb maga mɨdölöŋ. ");
INSERT INTO tmd_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Makwam mai mɨdɨp duön, Juda ada hö mögum rön, mönö paŋyöbö i yad ödör nɨgön yadmä, “Sol nugwo pɨl pal nɨgnɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Makwam mönö yadim aku, nöbö i nugwön Sol yad nölöŋa. Taun dib aku, maduar ör rɨg kul wob gwogwäbö rim makwam, ubalɨj uhömɨdöi piaku, Sol nugwo pɨl pal nɨgɨŋö, rön, mil pɨxmag yuö bö lɨgɨn nɨgmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Almɨdmä nugwön Sol nöbö nuŋ bla pɨxmag yuö mibɨl kwo nugwo yogw möl dib i piöxön, nag wabɨlön, pön kul mokwac möla rɨŋö bö abön naga pɨxiö röböxiö rɨmɨn pɨn du mɨgrö bö pɨnön duöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol Jerusalem duön, nöbö mö Jisas adö mɨdim piaku pɨsaŋ mɨjɨnö, rɨmɨdöŋ aku, jɨ ñɨŋ nugwön, nöbö kɨ Jisas nöbö nuŋ i yöi, anɨŋ pɨl pal nɨgɨba hö, rön, ipöxmä. ");
INSERT INTO tmd_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Almɨdmɨn, Banabas nuŋ Sol nugwo pön Jisas mönö wä pön dub nöbö bla mɨdim yöra pön duön, ñɨgö yadöŋa, “Nöbö kɨ nugwo nugwön ipöxmɨjeñ. Wop i taun dib Damaskas du gɨrön, ödöi mibɨl yöra duön, Nöbö Diba nugwo nugumɨn, nugwo mönö bli yadöŋa. Mai du Damaskas nöbö mö ñɨgö ipöxölön, Jisas mönö wä aku amɨn ödöriö akwör yad nölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Banabas aliö rɨmɨn, Sol nugwo pɨm, ñɨgö pɨsaŋ Jerusalem mɨdön, taun dib aku yuadö yönön, Jisas mönö wä aku amɨn ödöriö akwör yad nölmɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Makwam Juda nöbö Grik mönö nugwim piaku nugwo pɨsaŋ mönö nuö nuö yadɨp duön, nugwo pɨl pal nɨgnɨŋö, rön, rɨb aku yöxmä. ");
INSERT INTO tmd_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Makwam nöbö Jisas nugw pim bli mönö aku nugwön, nugwo yölɨŋ pön du taun dib Sisaria duön abɨm, taun dib Tasas duöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Wop mibɨl yöraku, mögörɨb Judia, Galili, Sameria piaku, nöbö mö Jisas nugw pim bla mɨd ri abmɨdmä. Inöm Leia nuŋ ñɨgö nugwidɨx mɨd ri abön, ölɨsö nölmɨn nugugɨrön, ñɨŋ ususör rön, Nöbö Diba nugwo rɨbyöx nugu gɨrön mɨdön, nöbö mö bli aipam Jisas mönö wä aku yad nölmɨn, ñɨŋ kwo algör ör Jisas nugw pɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita mögörɨb hörɨrör akuyöbö rɨp yön gɨrön, nöbö mö Jisas nugw pim piaku ñɨgö nugw yönmɨdöŋa. Aliö nugw yönön, wop i, nöbö mö Jisas nugw pim piaku ñɨgö nugunö, rön, ram yöj lɨglɨg agrö Lida duöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Mögörɨb aku nöbö i mɨdöŋa, ib nuŋwa Inias. Makwam iŋ wajmag nuŋ bla lɨd pɨlmɨn, yör nuŋ mɨd akwör hölɨm gɨ mɨdɨm kɨm akuyöbö amñaxɨb sö yönöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita nöbö aku nugwo yadöŋa, “Inias. Ap nagö rɨ aku Jisas raŋ kömö nɨgöna. Öbɨlön, yör nagö aku yöd ri abö,” röŋa. Aliö rɨmɨn nugugɨrön, mag mɨd akwör Inias nugwo kömö nɨgmɨn öbɨlöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Inias öbɨlön alɨp yönmɨdöŋa nugugɨrön, ram yöj lɨglɨg agrö Lida nöbö mö piaku aipam, mögörɨb Seron nöbö mö piaku aipam nugwo nugwön, Nöbö Diba nugwo nugw pɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Makwam Pita ram yöj lɨglɨg agrö Lida aku mɨdmɨn nugugɨrön, mö Jisas nugw pöŋ i wöröxöŋa igöp taun dib Jopa yöraku. Mö aku ib nuŋwa Tabita. Makwam Grik mönö yadön nugwo Dokas me rɨmɨdöia. Nuŋ nöbö mö piaku ñɨgö nugwidɨx mɨd ri abön, nöbö mö lɨblɨb röŋ akuyöbö mabö rɨ nölmɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mö aku nugwo ap rɨmɨn mödö wöröxɨm, nugwo röbö pal nölön nöbäpö högia pön wölu ram möl bɨl yöbö sö nɨgmä. ");
INSERT INTO tmd_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jisas nöbö mö nuŋwa Jopa mɨdim piaku mönö i nugumɨn, Pita hö mɨdöŋa ram yöj lɨglɨg agrö Lida aku. Lida taun dib Jopa il yöra mɨdöŋa, nugwön ñɨŋ nöbö mös ñɨgö yad abɨm, Pita mɨdöŋ yöraku duön mönö ölɨsö yadön yadmä, “Nagö an pɨsaŋ yadkap han duŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Aliö rɨmɨn, Pita ñɨgö nöbö hogwa pɨsaŋ Jopa uröpɨnmɨn nugugɨrön, nugwo yölɨŋ pön Tabita wöröxɨm pön du nɨgim ram möl bɨl yöbö sö wölumä. Yölɨŋ pön wölumɨn nugugɨrön, mö wösrö hö mɨdim piaku, mö wöröxöŋ aku höd kömö mɨdmɨd aku, wölɨj mɨxɨl wölɨj bli ñɨgö hör nölmɨd piaku, Pita nugwo yabuön, im gɨr mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita nöbö mö hö mɨdim piaku ñɨgö yad rɨŋö bö abön, höxmax yuön, God höjöpal gɨrön, höuöiliö, nöbäpö högia nugu gɨrön yadöŋa, “Tabita, öbɨlö!” röŋa. Aliö rɨmɨn, Tabita mämäga ix Pita nugwo nugwön öbɨl römɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita imag wab nuŋwa pön, pɨ pabɨl nölön, mö wösrö piaku aipam, nöbö mö Jisas nugw pim piaku aipam, ñɨgö magalɨg wö rɨm hömɨdmɨn yadöŋa, “Tabita mɨk,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Makwam Pita almɨdmɨn, mönö aku Jopa nöbö mö magalɨg nugwön, nöbö mö mɨga akwör Nöbö Diba nugw pɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Makwam Pita nuŋ taun dib Jopa aku, nöbö hön kau uñ mabö rɨmɨd nöbö i pɨsaŋ wop bli uplöb mɨdmɨdöia. Nöbö aku ib nuŋwa Saimon. ");
INSERT INTO tmd_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Makwam ami nöbö piaku ñɨgö nugwidɨx mɨdmɨd nöbö dib i taun dib Sisaria mɨdmɨda. Ib nuŋwa Konilias. Ami nöbö nuŋ nugwidɨx mɨdmɨdöŋ piaku ñɨgö “Itali Ami Nöbö” me rɨmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Nöbö dib Konilias aku pɨsaŋ, nöbö mö ram nuŋ piaku pɨsaŋ, God nugw pɨmä. Juda nöbö mö ap ñɨŋ bli mɨdmɨdöl aku, Konilias nuŋ rɨg ap bla amnɨmab nölmɨdöŋa. Makwam nuŋ God nugwo öim höjöpalmɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Wop i naiö pikwo röŋ mag aku, Konilias nuŋ rɨba nugwöŋa, God ejol i hön yadöŋa, “Konilias!” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Aliö rɨmɨn, Konilias ipöxön nugwo riö nugugu mɨdön yadöŋa, “Nöbö Dib, nɨ agamö rɨmɨdlaŋö?” röŋa. Aliö rɨmɨn, ejol aku nugwo yadöŋa, “Nagö God höjöpalön, nöbö mö lɨblɨb rɨ piaku ñɨgö ap amnɨmab nölön rɨlö aku, God nuŋ wä rɨm nagö uplöböl. ");
INSERT INTO tmd_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nagö nöbö bli yadaŋ, ñɨŋ du taun dib Jopa duön, nöbö Saimon Pita me röi aku nugwo yadɨŋ haŋ. ");
INSERT INTO tmd_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nuŋ Saimon, nöbö hön kau uñ mabö rɨ aku pɨsaŋ mɨd ban yuö dib pö yöraku,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ejol mönö aku yadön dumɨn nugugɨrön, Konilias mabö nugwo rɨ nölmɨdim nöbö hogwa aipam, God nugw pöŋ ami nöbö i aipam yadmɨn hömɨn, ");
INSERT INTO tmd_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ñɨgö ejol aku mönö agap apɨm yadöŋ aku yad nöl ri abön yad abmɨn, Jopa duba dumä. ");
INSERT INTO tmd_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ñɨŋ dumɨd dumɨd ödöi mibɨl yöra hölɨmɨmä. Löumɨn dumɨd dumɨd, naiö mibɨl yörkisö mag aku, Jopa igöp igöp rɨmä. Mag aku Pita nuŋ God höjöpalɨba wölu mɨdöŋa ram cölöbö sö. ");
INSERT INTO tmd_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","God höjöpal gɨr mɨdmɨn nugugɨrön, nugwo kiö dib ödöriö pɨlöŋa. Makwam nöbö mö bla ap maga urmɨdɨm nugugɨrön, Pita nuŋ rɨba nugwöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Pita nuŋ rɨba nugwön nugumɨn, adöx yöd röul adö kau sö möla rödɨm, yogw dib i ñöxɨb mɨxɨl mös mös kwol adöi adöi wabɨl gɨ mɨdöŋ mibɨl yöraku pisö pɨn pɨn mɨgrö il bö pɨnöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Yogw möl bö, hön, urap, döuyö, kas, yöur ap hörɨrör piaku magalɨg mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Mönö i piöŋö nugwo yadöŋa, “Pita, naŋ öbɨlön ap nɨmɨb piabö pal nɨmö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Aliö rɨmɨn, Pita paiŋö yadöŋa, “Nöbö Dib. Mɨ wöhö! Pödpöd rɨmɨn nɨmanö, rön yadlö? An Juda nöbö mö ap mödön röl piaku ap bli mɨ nɨmmɨdöiö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Aliö rɨmɨn, mönö aku iswob yadöŋa, “Ap agap apɨm God ap nɨmɨb, me rɨ piaku, ap mödɨb me rön yadmɨjɨnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Alöŋ aku, wop mös paŋ röŋa. Mai ap yogw dib aku höuöil adöx yöd röul adö kau sö duöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Almɨn, Pita rɨba nugul aku pödpöd cönɨŋö, rön, rɨb mɨga yöx nugugu mɨdmɨn nugugɨrön, Konilias nöbö yad abmɨn nugwo yadɨba hem nöbö rogw aku ödöi il yöra höröpɨnmä. ");
INSERT INTO tmd_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Höröpɨn gɨrön yadmä, “Nöbö Saimon Pita yöraku mɨdönö ö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita rɨba nugwa aku rɨbyöx nugu gɨr mɨdmɨn nugugɨrön, God Inöma nugwo yadöŋa, “Nagö nugwö! Nöbö mös paŋ nagö hölu nugup hömɨdöia. ");
INSERT INTO tmd_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Makwam, naŋ öbɨlön yöraku pibö pɨn duö. Nɨ keir ñɨŋ yad abmön hömɨdöia. Makwam, haŋ pɨsaŋ duŋö, rɨmɨdɨŋ mönö, rɨb mɨga yöx nugumɨjɨnö, pɨsaŋ duö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","God Inöma aliö rɨmɨn, Pita yör bö pɨn duön nöbö piaku ñɨgö yadöŋa, “Hölup hömɨdöi nöbö aku nɨ mɨk pal. Nɨ mönö i yadɨba höiŋönö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Aliö rɨmɨn, yadmä, “Nöbö dib Konilias, ami nöbö piaku ñɨgö nugwidɨx mɨd nöbö dib aku anɨŋ yad abmɨn höla. Konilias nuŋ God nugw pön, God Mönö rɨg yad mag akuyöbö ra; Juda ada nugwo nugumɨn ñɨgö magalɨg wä ra. Makwam nuŋ rɨb nugwöŋa, God ejol i hön nugwo yadöŋa, ‘Nagö nöbö bli yad abaŋ, du Saimon Pita nugwo yölɨŋ pön höŋ, mönö yadmɨjön aku nugwanö,’ rö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Aliö rɨmɨdmɨn, Pita ñɨgö yadmɨn ram möl yuadö du hölɨmɨmä. Löumɨn Pita, Jisas nugw pim nöbö Jopa yöbö bli pön, Konilias yad aböŋ nöbö rogw aku pɨsaŋ dumɨd dumɨd ödöi mibɨl yöra hölɨmɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Löumɨn, Sisaria uröpɨnön, Konilias rama uröpɨnmä. Konilias nuŋ Pita hömɨdö, rön, nöbö mö nuŋ piaku aipam, haul hödpɨg nuŋ piaku aipam, ñɨgö wö rɨm hö mögum rön mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita nuŋ duön ram möl yuadö duba rɨmɨn nugugɨrön, Konilias nugwo möigw palön, nugwo nöbö dib, me rön, du yödpɨlö il nuŋwa yöra höxmax yuöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Konilias almɨn nugugɨrön, Pita nugwo pɨ pabɨl nölön yadöŋa, “Nagö öbɨlö! Nɨ kwo algör ör nöbö i mɨk,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pita aliö rɨmɨn, Konilias öbɨlmɨn nugugɨrön, mönö yad gɨrön, ram möl yuadö dumä. Duön Pita nugumɨn, nöbö mö mɨga akwör hö mögum rön mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pita ñɨgö yadöŋa, “Ñɨŋ keir nugwöia, an Juda nöbö mö hölul rɨ ri aböla. Juda nöbö mö yöi akuyöbö pɨsaŋ yönölöl; ram ñɨŋa duölöl. Makwam nɨ rɨb nugumön, God nɨ mönö i yadöŋa. Nuŋ mönö yadöŋ aku, nɨ nöbö mö bli hölul mɨdöiŋö, rön, ñɨgö hölul rɨbä maga mɨdöl. ");
INSERT INTO tmd_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Makwam nɨ rɨb aku yöx nugwön, Konilias mönö yad aböŋ aku nugwön röböxöi; rɨg yad aböŋ akwör nugwön höla. Makwam, nɨ pödpöd rön yadmɨn höl?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Pita aliö rɨmɨn, Konilias yadöŋa, “Nɨ idöm döŋö ör, weik naiö pikwo rɨ mag akuyöbö, ram möl yuadö bö God höjöpal gɨr mɨd nugumön, nöbö wölɨj lei ödöriö yömöŋ i hön, mɨdɨm il yöra öbɨl gɨ mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Nuŋ nɨ yadöŋa, ‘Konilias, nagö God höjöpalön, rɨg ap bla nöbö mö ap mɨdöl piaku ñɨgö amnɨmab nölön rɨlö aku, God nugwa. ");
INSERT INTO tmd_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Makwam, nöbö bli yad abmɨn, taun dib Jopa duön, Saimon ib nuŋwa i Pita röi nöbö aku, nugwo yölɨŋ pön höŋ. Nuŋ Saimon hön kau uñ mabö rɨ nöbö aku pɨsaŋ mɨdöi ban yuö diba pö yöraku,’ me röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ejol aku nɨ aliö rɨmɨn, nɨ rɨmgör nöbö nɨ bli yad abmön, u nagö yölɨŋ pön höi aku, nɨ wä ra. An nöbö mö yörɨk God pɨsaŋ mɨdöl aku, Nöbö Dib mönö ñɨgö yad nölö, rön, nagö yad abmɨn hölö aku, wopik anɨŋ yad nölan nuguŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Konilias aliö rɨmɨdmɨn, Pita yadöŋa, “Nɨ wopik nugula, God nuŋ, nöbö il yörɨk yöbö akwör nöbö waiö, nöbö pad piakuyöbö nöbö gwogwo, me rön, nugwöl. ");
INSERT INTO tmd_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Mögörɨb hörɨrör piakuyöbö, ila hörɨrör piakuyöbö, nöbö mö kai kai God nugwo nugwön anau pön, mönö nuŋwa nugwön rɨg yad akuyöbö rɨmɨjöñ piaku, ñɨgö magalɨg pöna. ");
INSERT INTO tmd_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Makwam God nuŋ anɨŋ Isrel nöbö mö mönö wä yad aböŋ aku mödö nugwöia. Nɨ keir pɨsaŋ nɨgiö nɨgön mɨdɨŋ, me rön, God nuŋ Jisas Krais nugwo yad aböŋa. Jisas Krais nuŋwör nöbö mö piaku magalɨg Nöbö Dib ñɨŋa mɨda. ");
INSERT INTO tmd_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ñɨŋ keir mödö nugwöia, röbö pal nölɨb nöbö Jon aku, röbö pal nöl gɨrön, mönö wä aku ila nɨgön, mögörɨb Galili yad nölöŋa. Aliö rɨmɨn, yadɨp duön, yadɨp duön, nöbö mö mögörɨb Isrel mɨdöi bla magalɨg nugumä. ");
INSERT INTO tmd_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Makwam ñɨŋ mödö nugwöia, Jisas Nasaret yöbö nöbö aku, God nuŋ nugwo pɨsaŋ mɨdön, Inöm Leia nugwo nölön, nugwidɨx mɨdmɨn nugugɨrön, ölɨsö nuŋ akwör pön, mögörɨb hörɨrör akuyöbö magalɨg yön gɨrön, nöbö mö piaku rɨ ri ab gɨrön, nöbö mö kɨjaki ñɨgö rɨmɨn öliöxön mɨdim piaku ñɨgö rɨmɨn, kömö nɨgmɨda. ");
INSERT INTO tmd_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Makwam Jisas Juda nöbö mö mögörɨb ñɨŋ akuyöbö rɨp yön gɨrön, Jerusalem rɨp yön gɨrön, rɨg röŋ röŋ akuyöbö an mämäg ana keir nugumɨŋ aku yadmɨdla. Makwam mai nugwo bɨ höñ sö pɨl pal nɨgɨm wöröxöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Wöröxöŋ aku, jɨ wop mös mɨdön, God rɨmɨn, wop paŋ aku höbkal öbɨlön, du wöxnö nɨgmɨn mämäga ana keir nugumɨŋa. ");
INSERT INTO tmd_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Nöbö mö magalɨg nugwo mämäga nugwölim. God anɨŋ nöbö mö yad nɨgöŋ bla akwör mämäga ana Jisas nugumɨŋa. Nuŋ wöröxön öbɨlmɨn nugugɨrön, pɨsaŋ mɨdön nɨgiö nɨgön ap nɨmön röbö nɨmɨmɨŋa. ");
INSERT INTO tmd_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jisas anɨŋ yadöŋa, ‘Mönö wä na aku nöbö mö piaku yad nölön yajöña, “God rɨg yadöŋ mag akuyöbö, mai Jisas nöbö mö kömö mɨjöñ bla aipam, nöbö mö wöröxöñ bla aipam, ñɨgö magalɨg mönö diba yajönɨŋö,” cɨne,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Makwam adaku, God mönö yadɨb nöbö bla magalɨg Jisas Krais nugwo yadön yadmä, ‘Nöbö mö bɨl kai Krais ib ölɨsö nuŋwa pɨmɨjöñ akuyöbö, ap kib mag gwogwo röi aku God nugwön röböxönɨŋö,’ röiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Makwam Pita aliö mönö yadmɨdmɨn nugugɨrön, Inöm Leia nuŋ nöbö mö nugugu mɨdim akuyöbö ñɨgö magalɨg höŋa. ");
INSERT INTO tmd_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Inöm Leia ñɨgö pöl höm, ñɨŋ aj il höra nɨgön mönö il nugwölɨbä nɨg gɨrön, God ib nuŋwa yadmɨn bɨl sö dumɨn, Juda nöbö mö Jisas nugw pɨmä Pita pɨsaŋ Jopa yöbö hem bla, God Juda nöbö mö yöi akuyöbö ñɨgö Inöm Leia nölöŋ aku, me rön, aiö waiö rɨmä. Almɨdmɨn Pita yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“God nuŋ Inöm Leia anɨŋ nölöŋ aku, weik nöbö mö kɨyöbö ñɨgö kwo algör nöla. Makwam, ñɨŋ röbö yaxnɨŋö, rɨŋ, nöbö mö bli ñɨgö wöhö rɨb maga mɨdölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Pita aliö rön nöbö nuŋ bli ñɨgö yadöŋa, “Nöbö mö kɨyöbö ñɨgö Jisas Krais iba urön röbö pal nöine,” röŋa. Röbö pal nölmɨn nugugɨrön, ñɨŋ yadmä, “Pita, nagö an pɨsaŋ wop ulul mag mɨŋi yörɨk mɨdane,” rɨmä. Aliö rɨmɨn, wop ul mag mɨŋi ñɨgö pɨsaŋ mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Makwam Jisas mönö wä pön dub nöbö bla aipam, mögörɨb Judia nöbö mö Jisas nugw pim bla aipam nugumɨn, Juda nöbö mö yöi akuyöbö bli God Mönö nugw pɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Makwam, mai Pita Jerusalem dumɨn, Juda nöbö yöi akuyöbö algör ör uñ ödöröñɨŋö, rɨmɨdöi nöbö piaku, Pita nugwo ölɨsö rödön yadmä, ");
INSERT INTO tmd_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Nagö pödpöd rɨmɨn nöbö uñ ödörölöi piaku ram ñɨŋa duön, ñɨŋ pɨsaŋ ap paŋör nɨgiö nɨgön nɨmɨmadö?” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Aliö rɨmɨdɨm, Pita taun dib Jopa mɨdön rɨb nugwöŋ haiwo aku ñɨgö yad nöl gɨrön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Nɨ taun dib Jopa mɨdön, God höjöpal gɨr mɨdön, rɨba nugumön, adöx yöd röul adö kau sebö, yogw dib i ñöxɨb mɨxɨla akuyöbö mös mös kwol adöi adöi wabɨl gɨ mɨdöŋa pɨn pɨn il nɨ mɨdɨm yöra pɨnöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Pɨnmɨn, nɨ yogw aku mɨdöŋ il yöra duön nugumön, hön, urap, döuyö, kas, yöur ap piaku magalɨg mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Makwam mönö i nɨ yadöŋa, ‘Pita, nagö öbɨlön ap piabö pal nɨmö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Aliö rɨmɨn, nɨ paiŋö yadma, ‘Nöbö Dib. Mɨ wöhö! Pödpöd rɨmɨn nɨmö rön yadlö? An Juda nöbö mö ap mödɨb piaku ap bli nɨmmɨdöiö,’ rɨma. ");
INSERT INTO tmd_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Aliö rɨmön, mönö aku iswob yadöŋa, ‘Ap agapɨm God ap nɨmɨb pi me rɨ piaku, ap mödɨb me rön yadmɨjɨnö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Alöŋ aku, wop mös paŋ röŋa. Makwam mai ap yogw dib aku höuöil adöx yöd röul adö kau sö duöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Makwam wop akwör, nöbö mös paŋ ram hölɨm gɨ mɨdɨm aku höröpɨnmä. Nöbö piaku nöbö dib Konilias, Sisaria yöbö yad abmɨn, nɨ yölɨŋ pön duba hömä. ");
INSERT INTO tmd_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","God Inöma nɨ yadöŋa, ‘Rɨb mɨga yöx nugumɨjɨnö; ñɨgö pɨsaŋ amɨn duö,’ röŋa. Aliö rɨmɨn, nɨ nöböhöd Jisas mönö nugw pöi nöbö akuyöbö iŋösu sö pön, ñɨgö pɨsaŋ Konilias rama dumɨŋa. ");
INSERT INTO tmd_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Uröpɨnmɨn, Konilias yadöŋa, ‘Ejol i hön nɨ yadöŋa, “Nöbö bli yadman, taun dib Jopa duön, nöbö i Saimon Pita me röi aku nugwo yölɨŋ pön höŋ. ");
INSERT INTO tmd_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Yölɨŋ pön höŋ, nuŋwör mönö bli yad nölaŋ, nöbö mö ram nagö pɨsaŋ mɨdöi akuyöbö, God ñɨgö magalɨg kömö paŋ, nöbö mö nuŋwa mɨjöñɨŋö,” rö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Konilias nɨ aliö rɨmɨn, nɨ ila nɨgön mönö yad nölmön nugugɨrön, Inöm Leia nuŋ anɨŋ höd höŋ akuyöbö, nöbö mö piaku ñɨgö algör ör höŋa. ");
INSERT INTO tmd_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Almɨn, Nöbö Diba anɨŋ höd yadöŋ mönö aku rɨbyöx nuguma. Nuŋ yadöŋa, ‘Jon ñɨgö röbö pal nölöŋ aku, jɨ womiöx mɨda, God nuŋ ñɨgö Inöm Leia pal nöiönɨŋö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Makwam an Nöbö Dib Jisas Krais nugw pɨnɨŋ wop aku, God ap wä ödöriö anɨŋ nölöŋ akuyöbö, ñɨgö algör ör nölöŋa. Makwam, nɨ pödpöd rɨmön God nugwo, ‘Al mɨjnaŋö,’ rɨlöxmö?” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pita aliö rɨmɨn, nöbö nugwo mönö ölɨsö yadim bla mönö yadöŋ aku nugwön, mönö ölɨsö bli kwo yadölim. God iba yadmɨn bɨl sö dumɨn nugugɨrön yadmä, “Anɨŋör yöi; Juda nöbö mö yöi akuyöbö algör ör, ap kib mag gwogwo röi aku, pödpöd rɨmɨn aliö alölɨŋö, rön, nugwo höjöpalmɨjöñ aku, nuŋ nugwön, ap kib mag gwogwo röi akuyöbö röböxön, kömö öim mɨdɨb mag aku ñɨgö nöiönɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Makwam Stipen nugwo rɨg röd pal nɨgim wop mibɨl yöraku, Juda nöbö Jerusalem mɨdim piaku, nöbö mö Jisas nugw pim akuyöbö ñɨgö mɨ ödöriö rɨ gwogwam rɨm, ñɨŋ bör malö malö dumä. Bli bör mögörɨb Pönisia dumä, bli bör röbö wödoböŋ mögörɨb Saipras dumä, bli ipöxön bör taun dib Adiok dumä. Duön, Jisas mönö wä aku Juda nöbö mö yöi akuyöbö ñɨgö yad nölölim; nöbö mö ñɨŋ keir Juda ada röd du hör piaku mɨdmɨdöi piakwör yad nölmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Makwam nöbö mö Jisas mönö wä aku nugw pim bla bli Saipras yöbö, bli Sairini taun yöbö, bör Adiok duön, Nöbö Dib Jisas mönö wä aku Juda nöbö mö yöi akuyöbö ñɨgö yad nölmɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nöbö Dib ölɨsö nuŋ aku ñɨgö pɨsaŋ mɨdöŋ makwam, nöbö mö akuyöbö ñɨgö Jisas mönö wä aku yad nölmɨn, nöbö mö mɨga akwör Nöbö Diba nugwo nugw pɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Makwam Jerusalem nöbö mö Jisas nugw pim akuyöbö, mönö aku nugwön, nöbö ñɨŋa Banabas nugwo yad abmɨn, Adiok duöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Banabas nuŋ Adiok uröpɨnön nugumɨn, God nuŋ nöbö mö piaku ögwö yöxön rɨmɨn, Jisas mönö wä aku nugw pɨmä. Makwam, nuŋ wahax pön, ñɨgö mönö bli kwo yad nöl gɨrön yadöŋa, “Nöbö Diba nugwo nugw pöi aku röböxmɨjeñ; nugwo paŋyöbö akwör höbwab rɨb madmag ñɨŋa yuö kwo nugw pɨ cɨcɨ nɨgön, nugwo cɨrɨp gör mɨjne,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas nuŋ nöbö wä mɨdöm. Inöm Leia nuŋ hö Banabas yuö kwo aja wölmɨdöŋa. Nuŋ Jisas mönö wä aku mɨ aŋadö nugw pöŋa. Nuŋ Jisas mönö wä aku nöbö mö akuyöbö yad nölmɨn, nöbö mö mɨga akwör Nöbö Diba nugwo nugw pɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Banabas nɨ du Sol nugwo pön hönö, rön, taun dib Tasas duöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Banabas Tasas uröpɨnön, Sol nugwo hölu nugwön, yölɨŋ höuöil Adiok duön, kɨm paŋyöbö aku nöbö mö Jisas nugw pim akuyöbö ñɨgö Jisas mönö wä aku yad nöl gɨr mɨdmä. Adiok nöbö mö Jisas Krais nugw pim piaku, ñɨgö höd ib urön “Krais Nöbö Mö” me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Wop mibɨl yöraku, God mönö yadɨb nöbö bli Jerusalem yöbö Adiok dumä. ");
INSERT INTO tmd_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Duön, God Inöma nuŋ nöbö ñɨŋ i Agabas nugwo rɨbyöx nölmɨn yadöŋa, “Kiö diba ödöriö mögörɨb magalɨg pɨlɨba rɨmɨdö,” röŋa. Aliö rɨmɨn, rɨg yadöŋ aliar kiö dib ödöriö aku, gapman nöbö dib Klodias nugwidɨx mɨdmɨd wop aku pɨlöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Aliö kiö diba pɨlöŋa nugwön Jisas nugw pim Adiok mɨdmɨdim nöbö mö akuyöbö yadmä, “Nöbö mö Jisas mönö wä aku nugw pöi bli mögörɨb Judia piaku mɨdɨm nugugɨrön, ñɨgö kiö diba wöröxmɨdöi aku, an paŋ paŋ ñɨgö rɨg bli mögum rön nöinɨŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Aliö rön, rɨg nɨg mögum rön, Banabas Sol yöŋö ñɨgö nölön yadmä, “Ñɨŋ nöbö hogwa rɨg kɨ pön duön, Krais nöbö mö nuŋwa nugwidɨx mɨdöi nöbö dib akuyöbö ñɨgö nöinö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Wop mibɨl yöraku, gapman nöbö dib Herod, nöbö mö Jisas nugw pim akuyöbö bli ñɨgö rɨ gwogwam rɨ gɨrön, pön du nag nɨgöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Herod nuŋ ami nöbö nuŋwa bli yadmɨn, Jon hödnɨŋ nuŋwa Jems nugwo yu mɨxɨl ölɨsö pön aŋadö pɨl pal nɨgɨm wöröxöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Herod yadmɨn aliö almɨn, Juda nöbö mö bla nugwön wahax pɨmä. Ñɨñɨ nɨgmä aku, Herod nugwön ami nöbö nuŋwa bli yadmɨn, Pita aipam nag nɨgɨba dumä. Alim aku, Juda nöbö mö Bred Is Alɨg Nɨmölɨb wop mibɨl yöraku rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Herod Pita nugwo aliö pön du nag nɨgön, ami nöbö akuyöbö padokwo adokwebö amñaxɨb bö (16) ñɨgö nuöm nɨg, igwö wölö igwö wölö nɨgön, yadöŋa, “Mil pɨxmag yuö bö nöbö mös mös nugwidɨx mɨd ri abmɨjne,” röŋa. Herod rɨb nuŋwa keir nugwön yadöŋa, “Pasopa wop aku hö dumɨjön aku, mai Pita nugwo pön du nöbö mö mɨjöñ mibɨl yöra duön mönö diba yajnɨŋö,” rön nugwöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pita nuŋ aliö nag mɨdmɨn nugugɨrön, nöbö mö Jisas nugw pim piaku Pita nugwo rɨbyöx nugwön, ususör rön God höjöpal gör mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Makwam gapman nöbö dib Herod Pita nugwo mönö diba yajɨnö, rön, nugwöŋ wop akwör pɨxmag yuö kwo, Pita nugwo sen mös wabɨlön, ami nöbö hogwa adöi adöi nugugu mɨdɨm nugugɨrön, Pita mibɨl bö hölɨmmɨdöŋa. Ami nöbö bli ubalɨja nugugu mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Makwam rɨb pia Nöbö Diba ejol nuŋ i öbɨl gɨ mɨdmɨn nugugɨrön, rɨn pin röxgɨb apa du kɨlabɨs rama ram möl yuadö mil aböŋa. Ejol aku du Pita nugwo höglöma pal nugwön yadöŋa, “Rɨmɨg öbɨlö!” röŋa. Aliö rɨmɨn, Pita öbɨlmɨn nugugɨrön, sen nugwo wabɨlim aku yauöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ejola Pita nugwo yadöŋa, “Amanö nagö pɨx nɨgön, yam uñ nagö röbö,” röŋa. Aliö rɨmɨn, Pita ejol rɨg yadöŋ mag akwör rɨmɨn, ejol aku yadöŋa, “Wölɨj mɨxɨl dib nagö aku yöman, nɨ pɨsaŋ duŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Aliö rɨmɨn, wölɨj mɨxɨl dib nuŋwa yömön, ram möl mɨdöŋ aku röböxön, ejol aku pɨsaŋ dumä. Ejol rɨg röŋ aku, Pita nuŋ yad nugwöŋa, wa, aku rɨb nugumɨdɨlönö, rön nugwöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Makwam ami nöbö ubalɨj mös mɨdim bla i höl rön, i aipam höl rön, ubalɨj ölɨsö ödöriö ain pön rim ubalɨj rɨŋebö bö aku keir rödmɨn nugugɨrön, röpɨn rɨŋadö dumä. Duön, ödöi mibɨl piaku du gɨrön Pita nugumɨn, ejol aku mɨdölöŋ. ");
INSERT INTO tmd_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Alöŋ aku nugwön Pita yadöŋa, “Wopik nugw ri abla. Aku Nöbö Dib akwör, ejol nuŋwa yad abmɨn, hö gapman nöbö dib Herod nɨ nag ölɨsö nɨg aku yau aba. Gapman nöbö dib Herod aipam, Juda nöbö mö bla aipam, ap gwogwo nɨ rɨba röi aku, weik nɨ rɨb maga mɨdölö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pita aliö rön, rɨbyöx nugw ri abön, nöbö nagö Jon Mak nuöm Maria rama duöŋa. Ram aku nöbö mö mɨga akwör hön, God höjöpal gɨr mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita hön, ubalɨja pal gigu rɨmɨn, halöu Roda, ram aku mabö rɨmɨd halöu aku uba rödɨba höŋa. ");
INSERT INTO tmd_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Halöu aku ubalɨja hön nugumɨn, Pita ajmöla akwör yadmɨdöŋa. Nuŋ aliö nugwön, wahax pön, uplöb uba rödölöŋ; du nöbö mö akuyöbö ñɨgö yadöŋa, “Pita hö mɨd rɨŋö bö,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Aliö rɨmɨn, ñɨŋ yadmä, “Nagö u pɨlön yadmɨdlanö,” rɨmä. Aliö rɨmɨdɨm, nuŋ ususör rön yadöŋa, “Inakmönö höröi; mɨ ödöriö yadmɨdla. Pita mɨd rɨŋö bö,” me röŋa. Aliö rɨmɨn yadmä, “Aku inöm nuŋwa hö mɨdö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Jɨ Pita nuŋ ubalɨja iswob pal gigu rɨm rɨm rɨm, du uba rödön nugumɨn, Pita ör mɨdöŋa nugwön aiö waiö rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Aiö rɨm nugugɨrön, Pita ñɨgö iŋ cɨcɨmu nölön yadöŋa, “Mönö pɨmɨjeñ!” röŋa. Aliö rön, kɨlabɨs rama mɨdmɨn nugugɨrön, God ejol i yad abmɨn hön, nugwo agap apɨm rɨg rön pön höŋ mönö aku ñɨgö yad nöl gɨrön yadöŋa, “Mönö kɨ Jems aipam, nöbö mö Jisas nugw pöi piaku aipam, ñɨgö yad nöine,” rön, hör möl i duöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Löum yöbö ruö löumɨn nugugɨrön, ami nöbö bla Pita mɨdölöŋ aku nugwön, pödpöd rɨ, rön, yadön yadɨp uhömɨdmä. Ipöxön, “Mɨkai,” me rön, hölumä aku jɨ nugwölim. ");
INSERT INTO tmd_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod ami nöbö piaku ñɨgö, Pita nugwo rɨmgör hölu nugwön pön höŋ, me rɨmɨn, hölu yualöbön nugumɨn, ñɨgö mönö diba yadön mönö yadmɨn, ami nöbö nuŋwa bli ami nöbö piaku aŋadö pɨl pal nɨgmä. Mai Herod mögörɨb Judia röböxön, du taun dib Sisaria mɨdmɨda. ");
INSERT INTO tmd_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herod du Sisaria mɨdön, taun dib mös Taia Saidon nöbö mö piaku ñɨgö nugumɨn ölɨsö wölöŋa. Makwam Taia Saidon nöbö mö hön, nöbö Herod ram nuŋwa nugwidɨx mɨdöŋ nöbö Blastas nugwo im nölön yadmä, “Anɨŋ kiö pɨlɨm, öim hö Herod mögörɨb nuŋ kɨ ap mag wob rag dumɨdöla aipam. Makwam, ölɨsö rödmɨjeñ; an tar nɨgiö nɨgön mɨjnɨŋö,” rɨmä. Aliö rɨmɨn, Blastas nuŋ paiŋö yadöŋa, “Aku mi yadmɨdöiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Makwam Herod mönö aku nugwön, wop i mönö yajɨnö, rön, yad nɨgöŋa. Mai yad nɨgöŋ wop aku höm, nuŋ kiŋ adö yömöi akuyöbö wölɨj wä wä ödöriö bla yömön, kiŋ hogw rol nuŋwa rol aku römɨdön, nöbö mö piaku ñɨgö mönö yad nölöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Herod mönö aku yad nölmɨn nugugɨrön yadmä, “Nöbö i aliö yadmɨdöl; god i röxg yadmɨdö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Makwam Herod mönö aku nugwön, “Nɨ mönö akuyöbö yadmɨjeñ; God ib nuŋ akwör yadɨŋ bɨl sö duaŋ,” me rölöŋ. Makwam, Nöbö Dib ejol nuŋwa i yad abmɨn, hön Herod nugwo rɨmɨn, wöj diba nɨgön, mej yaxmɨn aŋadö wöröxöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Makwam God Mönö aku yad nölmɨn dumɨn nugugɨrön, mögörɨb akuyöbö hörɨrör duöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabas Sol yöŋö Jerusalem mɨdön, agap rɨba höl aku mödö rölɨŋö, rön, Jon Mak nugwo yölɨŋön höuöil Adiok dumä. ");
INSERT INTO tmd_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Taun dib Adiok yöraku God mönö yadɨb nöbö bli, God mönö yad nölɨb nöbö bli mɨdmä. Nöbö piaku, i Banabas; i Simion. Nöbö Simion aku nugwo Nöbö Pɨx me rɨmɨdmä. Nöbö i Lusias, nuŋ Sairini taun yöbö. Nöbö i Maneyen, nuŋ Kiŋ Herod nöbö nugub nuŋ i. Nöbö i Sol. ");
INSERT INTO tmd_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Makwam wop i ñɨŋ ap nɨmölön, Nöbö Diba akwör höjöpal gɨr mɨdɨm nugugɨrön, Inöm Leia nuŋ ñɨgö yadöŋa, “Ñɨŋ Banabas Sol yöŋö yadɨŋ, nɨ mabö ñɨgö yad nɨgɨm aku rɨŋ duaŋ,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Inöm Leia aliö rɨmɨn, ñɨŋ ap mag nɨmölön, God höjöpalön, Banabas Sol yöŋö ñɨgö imaga yöcmac sö nɨgön, God ñɨgö nöbö hogwa nugwidɨx mɨdaŋ, me rön, ñɨgö yad abmä. ");
INSERT INTO tmd_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","5","Inöm Leia nuŋ ñɨgö nugwidɨx mɨdmɨn nugugɨrön, Jon Mak, mabö ana ulul bli rɨ nölaŋ, me rön, nugwo yölɨŋön Selusia taun röbö kwol bö duön, bɨyöja pön, röbö wödoböŋ mögörɨb Saipras dumä. Duön, taun dib Salamis duön, Banabas Sol yöŋö Juda mögum rɨb ram bla duön, nöbö mö bla ñɨgö God Mönö yad nölmä. ");
INSERT INTO tmd_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Makwam Banabas Sol yöŋö nöbö mö Saipras mɨdim piaku ñɨgö God Mönö yad nölɨp dumɨd dumɨd, taun dib Pepos uröpɨnön, Juda nöbö i kɨj cokwöi öimöb rɨb nöbö i möigw palmä. Nöbö aku ib nuŋwa Ba-Jisas. Nuŋ inakmönö hörön yadöŋa, “Nɨ God mönö yadɨb nöbö i,” me röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Taun dib Pepos aku, Saipras gapman nöbö dib ödöriö mɨdmɨda, ib nuŋwa Segias Polas. Nöbö aku nuŋ rɨbyöx nugw ri abmɨdöŋa. Nuŋ Banabas Sol yöŋö, God Mönö nɨ yad nölɨŋ nugunö, rön, ñɨgö yadmɨn hön nugwo God Mönö yad nölmä. Makwam kɨj cokwöi öimöb rɨb nöbö aku nuŋ nöbö dib aku nöbö nugub nuŋ i. ");
INSERT INTO tmd_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nöbö Ba-Jisas aku, Grik mönö yadön nugwo Elimas me rɨmɨdmä. Banabas Pol yöŋö ñɨŋ Segias Polas nugwo God Mönö wä aku yad nölmɨn, nuŋ rɨmɨj pal audiöx nugw ri aböŋa, jɨ kɨj öimöb rɨb nöbö aku nugwön, Banabas Pol mönö gwogwo yadön göj göj yadyöxön, Segias Polas Jisas mönö aku nugw pönɨŋö, rön, nugwo yadöŋa, “Nöbö hogw aku inakmönö hörmɨdöi aku nugumɨjɨnö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Sol ib nuŋwa i Pol me rɨmɨdmä. Inöm Leia nuŋ Pol nugwo yuö kwo aja wölön rɨb wä nölmɨn nugugɨrön, kɨj öimöb rɨb nöbö aku nugwo cɨx nugugu mɨdön yadöŋa, ");
INSERT INTO tmd_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Nagö kɨjaki ha yöx pön höŋa; mag gwogwo akwör rɨlö. Ap kai kai wä mɨd aku röböxön, nöbö mö akuyöbö ñɨgö inakmönö hörön rɨmɨdlö. Nagö öim öim Nöbö Diba mönö mɨ nuŋ aku pön inakmönö hörön aliö nɨgmɨdlö. Nagö wop kai rɨ gwogwam rɨmɨdlö mag aku röböxnanö? ");
INSERT INTO tmd_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Almɨdlö aku, God raŋ, wop mɨdöy mämäg nagö we wölaŋ naiö mila nugwöinaŋö,” röŋa. Pol mönö aku yadmɨn, rɨb pia Ba-Jisas nugumɨn, mɨjöi pɨ wab i mämäg nuŋwa pöröbmɨn aŋadö pɨxmag guröŋa. Almɨn, nöbö i nɨ imaga pön ödöi yabuaŋ, me rön, piö piö rɨ gɨr mɨdöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Banabas Pol yöŋö ñɨŋ Nöbö Diba mönö aku nugwo yad nölmɨdmɨn aku nugwön, Segias Polas nuŋ aiö röŋa. Makwam, Ba-Jisas rɨg röŋ mag aku nugwön, nuŋ Jisas nugw pöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Makwam Pol nöbö nuŋ bla pɨsaŋ bɨyöja pön, Pepos röböxön, Pega taun, mögörɨb Pampilia yöraku dumä. Du mɨdön, Jon Mak nuŋ ñɨŋ nöbö hogwa röböxön höbkal Jerusalem duöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ñɨŋ piöŋö Pega taun röböxön, taun dib Adiok mögörɨb dib Pisidia yuadö dumä. Du mɨdön, Juda God höjöpalɨb wop aku, Juda mögum rɨb rama duön, römɨd gɨ mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Juda mögum rama nugwidɨx mɨdmɨdöi nöbö bla öbɨlön, Mosɨs lo mönö kai kɨtöŋ rɨba bli aipam, God mönö yadɨb nöbö piaku kai kɨtim rɨb bli aipam, mämäg nɨg nugwön nöbö mö mɨdim akuyöbö ñɨgö yadmä. Ñɨŋ mönö yad pörön, nöbö i yad abɨm Banabas Pol yöŋö römɨd mɨdim yöra duön yadöŋa, “Ha ruai. Nöbö mö kɨyöbö nugw pɨb mönö bli mɨjön aku, an yad nölɨŋ nuguŋö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Aliö rɨmɨn, Pol öbɨlön mönö yadɨba imaga pabɨlön yadöŋa, “Ñɨŋ Juda nöbö mö bla aipam, Juda nöbö mö yöi God höjöpal gɨr mɨdöi bla aipam, mönö yadɨba rɨmɨdɨl kɨ rɨmɨj pal nugwi. ");
INSERT INTO tmd_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","God nuŋ maduar ör nöso auso nöbö an bla pöŋa. God aku nuŋ Isrel nöbö mö God an pal. Mai ñɨŋ mögörɨb Ijip du mɨdmä, God ñɨgö nugwidɨx mɨd ri abmɨn, yöx pön hem halöu ha akuyöbö mɨga mɨdmä. Nöbö dib Pero ñɨgö dueñɨŋö, röŋ aku, jɨ God ölɨsö nuŋ maga rön, ñɨgö yölɨŋ pön höm Ijip rɨŋadö hömä. ");
INSERT INTO tmd_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ñɨŋ kɨm padokwo padök paŋyöbö i höuöiliö hö pɨn du adokwebö mɨj bö (40) mögörɨb rɨg kap piaku mɨdön, God mönö rödön ap kib mag gwogwo ususör rɨmɨdmä, jɨ God ñɨgö nugwidɨx mɨd ri aböŋa. ");
INSERT INTO tmd_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Makwam höd mögörɨb Kenan nöbö mö rɨgwoŋ hörɨrör akuyöbö mɨj sö mɨdmɨdmä, jɨ God nöbö mö nuŋwa nugwidɨx mɨd ri abön ölɨsö mag nuŋwa nölmɨn, nöbö mö rɨgwoŋ hörɨrör akuyöbö mɨj sö höd mɨdmɨdim akuyöbö ñɨgö pɨsaŋ nuö nuö pön, bli rɨbɨx abön bli pɨl pal nɨgön, mögörɨb aku ñɨŋ aŋö pɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ñɨŋ Ijip mɨdɨm kɨm yönöŋa iŋ wödön, mögörɨb rɨg kap piaku mɨdɨm kɨm yönöŋa iŋ wödön, nöbö mö rɨbɨx abön mögörɨb ñɨŋ aŋö pɨm aku mɨdim kɨm yönöŋa aipam iŋ wödɨmdɨm, kɨm akuyöbö po hadred pipti (450) yönöŋa. “Makwam God ñɨgö pön du mögörɨb Kenan yöraku nɨgön, mönö pɨ nuöm nɨgɨb nöbö bli yad nɨgmɨn, ñɨgö nugwidɨx mɨdmɨdmä. Mai God mönö yadɨb nöbö Samuel mɨdöŋ wop aku, ");
INSERT INTO tmd_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","nöbö mö Isrel bla ñɨŋ Samuel nugwo yadmä, ‘Nagö kiŋ i yad nɨgaŋ, anɨŋ nöbö mö magalɨg nugwidɨx mɨdaŋ,’ me rɨmä. Aliö rɨmɨn, God nuŋ Kis ha nuŋwa Sol nugwo yad nɨgmɨn, kiŋ ñɨŋa mɨdmɨda. Nöbö aku Benjamin hödɨga yöxɨp duön yöxɨp duön yöx nɨgmä. Sol kiŋ ñɨŋa mɨdmɨn, kɨm padokwo padök paŋyöbö i höuöiliö hö pɨn du adokwebö mɨj bö (40) yönöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Makwam mai God nuŋ rɨmɨn Sol kiŋ mɨdölöŋ. God nuŋ Depid kiŋ ñɨŋa yad nɨgöŋa. God nuŋ Depid mönö yadön yadöŋa, ‘Höbwab rɨb madmag nɨ keir rɨbyöxɨl mag akwör, Jesi ha nuŋwa Depid höbwab rɨb madmag nuŋwa algör paŋ rɨb akwör yöxa; ap agap apɨm raŋ, me rön nugun aku, nuŋ paŋ mag akwör cönɨŋö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Makwam God nuŋ rɨmɨn, Depid halöu ha yöxɨm yöxɨp höuöilmel rön, Jisas nugwo yöx pön hömä. Makwam, God höd mönö ölɨsö yad nɨgöŋ akuyöbö, nuŋ Isrel nöbö mö ñɨgö Kömö Pɨb Nöbö i yad aböŋa. ");
INSERT INTO tmd_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Makwam Jisas ila nɨgön mabö rölöŋ mag aku, Jon nuŋ hön, Isrel nöbö mö ñɨgö yadöŋa, ‘Ap kib mag gwogwo röi aku, pödpöd rɨmɨn aliö alölɨŋö, rön, röböxɨŋ, ñɨgö röbö pal nöinö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jon mabö nuŋwa rɨ pörɨba rɨmɨdöŋ wop mibɨl aku, nöbö mö akuyöbö ñɨgö yadöŋa, ‘Ñɨŋ nɨ nöbö kai, me rön, rɨbyöx nugwöi? Nöbö Dib öim pöx mɨdmɨdöi nöbö aku, nɨ yöi. Nöbö aku mai höna. Yam uñ nuŋ aku pɨ naga yaub maga mɨdölö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Nöböhöd möhöd nɨ, ñɨŋ bli Ebraham halöu ha nuŋwa mɨdöia; ñɨŋ bli Juda nöbö mö yöi jɨ God höjöpalöia. Krais nöbö mö kömö pɨb mönö Jon yad nöl mɨdmɨd aku, God nuŋ anɨŋ, me rön, yadöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalem nöbö mö bla aipam, nöbö dib ñɨŋ bla aipam, Jisas nuŋ Krais aku hö, rön nugwölim. Jisas nugwo pɨl pal nɨgɨŋ wöröxaŋ, me rɨmä aku, God mönö yadɨb nöbö piaku mönö kai kɨtim mag akwör rɨmä. Makwam God höjöpainöb Juda mögum rɨb rama öim hömɨdöi aku, ñɨŋ mönö kai kɨtim mönö mag aku öim öim nugumɨdöia. ");
INSERT INTO tmd_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ñɨŋ Jisas ap gwogwo i rönö wöhö, rön, hölu wöhö nugwön, gapman nöbö dib Pailot nugwo yadmä, ‘Nagö yadaŋ nugwo pɨl pal nɨgɨŋ,’ me rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Makwam God Mönö rɨg yadöŋ mag akuyöbö, magalɨg Jisas nugwo rɨmä. Mai nöbö mö nuŋ bla hön, nöbäpö högia pɨ öröu pön du rɨg möl hogw pɨlmä. ");
INSERT INTO tmd_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Hogw pɨlim aku, jɨ God rɨmɨn höbkal öbɨlöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Nuŋ öbɨlön kömö mɨdmɨn nugugɨrön, nöbö mö nuŋ pɨsaŋ Galili yöbö Jerusalem hem piaku, nugwo wop mɨga akwör nugwim akuyöbö, wopik Isrel nöbö mö ñɨgö Jisas mönö wä aku yad nölmɨdöia. ");
INSERT INTO tmd_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Makwam an nöbö hogwa höl kɨ, ñɨgö Krais mönö wä aku yad nölɨba höla. God maduar ör nöso auso nöbö an bla ñɨgö mönö ölɨsö yad nɨgön cɨnö röŋ mönö akwör rɨbyöx nugugu mɨdön, ");
INSERT INTO tmd_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","God nuŋ Jisas nugwo pɨ pabɨl nölöŋa. Alöŋ aku nöso auso nöbö bla nugwölim aku, jɨ an halöu ha yöx nɨgɨb ñɨŋ bla wopik nugwöla. Depid nuŋ God Mönö Sam rɨb aku Wopal agñɨŋ rɨbyöbö kai kɨtön yadöŋa, ‘Nagö Ha na. Nɨ weik Nauö nagö mɨdlö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","God nuŋ rɨmɨn, Jisas öbɨlöŋ makwam, mai wöröxön mɨxɨñ nuŋwa lɨdu pɨn pal dubä maga nɨgöl. Mönö aku God Mönö rɨb mɨŋi aliö mɨda: ‘Nɨ Depid nugwo mönö lei, mönö ölɨsö, mönö ma yad nɨgɨm aku, ñɨgör nöinö,’ röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Makwam God Mönö rɨb mɨŋi aliö mɨda: “‘Naŋ Nöbö Leia nagö röböxaŋ, mɨxɨñ nuŋwa lɨdu pɨn pal duölaŋ,’ me röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Makwam Depid nuŋ God mabö nuŋwa yad nɨgöŋ aku, nöbö mö nuŋwa mɨdmɨdim wop aku rɨp duön wöröxöŋa. Makwam Depid nuŋ wöröxɨm, nuö nöhönɨŋ nöbö ñɨgö hogw pɨlmɨdim yöra pön du hogw pɨlɨm, mɨxɨñ nuŋwa lɨdu pɨn pal duöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Jɨ God nuŋ rɨmɨn öbɨlöŋ Nöbö aku, mɨxɨñ nuŋwa lɨdu pɨn pal duölöŋ. ");
INSERT INTO tmd_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Makwam, nöböhöd möhöd nugwi. Jisas nuŋ wöröxön öbɨlöŋ makwam, God ap kib mag gwogwo röi aku nugwön röböxön mönö wä aku ñɨgö yad nölmɨdöla. ");
INSERT INTO tmd_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","An Juda lo mönö adakwör nugwön rɨmɨjnɨŋ aku, God ap kib mag gwogwo röl aku nugw gör mɨjöna. Jɨ Jisas pɨl pal nɨgɨm wöröxöŋ makwam, an Jisas nugw pɨmɨjɨnɨŋ aku, God ap kib mag gwogwo röl aku nugwön, röböxön, anɨŋ nöbö mö kömö wä nɨ, me cöna. ");
INSERT INTO tmd_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Makwam God mönö yadɨb nöbö piaku maduar ör rɨg yadim mag akuyöbö anɨŋ alölaŋ, me rön, rɨb aku yöx nugw ri aböña. Ñɨŋ yadmä, ");
INSERT INTO tmd_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Ñɨŋ nöbö mö nɨ albeñ albeñ nölöi piaku nugwi! Ñɨŋ mɨdöi mag kɨ, ap keiryöbö i cɨna. Cɨn ap aku ñɨgö höd yadmɨjöñ aku, ñɨlöŋ nɨg yadmɨdöiŋö, rön, nugwöña. Makwam, ñɨŋ aiö waiö rön, aŋadö wöröx yöm rɨ pöcöñɨŋö!’ röiŋö,” röŋa. ");
INSERT INTO tmd_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pol Banabas yöŋö mönö aku yadön, Juda mögum rɨb ram aku rɨŋadö röu dum nugugɨrön, nöbö mö bla yadmä, “God höjöpalɨb wop maiyöbö aku höuöil hön, mönö aku an bli kwo aipam yad nöinö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Nöbö mö mögum rɨ mɨdim ram aku röböxön, hörɨrör dumɨn nugugɨrön, Juda nöbö mö ödöriö bli aipam, nöbö mö piakuyöbö Juda ada nugumɨdöi akuyöbö nugw pim nöbö mö bli aipam, Pol Banabas yöŋö mai dumä. Pol Banabas ödöi mibɨl yöra du gɨrön, nöbö mö akuyöbö ñɨgö yadmä, “‘God anɨŋ uliöxön pɨ ri abön rö,’ rön, rɨb aku yöx nugu gɨrön mɨjɨnö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Makwam Juda God höjöpalɨb wop maiyöbö aku, taun dib aku mɨdim nöbö mö akuyöbö magalɨg Nöbö Diba mönö nuguba hö mögum rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Makwam Juda nöbö dib bla, nöbö mö mɨga ödöriö hömɨdmä aku nugumɨn, ölɨsö wölɨm, Pol Banabas nöbö hogwa nugwön rɨb gwogwo yöxmä. Pol mönö bɨl kai nöbö mö piaku yadöŋ aku nugwo yad höimöuön, ib nuŋwa yadɨp pɨmag pɨn du nɨgmä. ");
INSERT INTO tmd_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Juda nöbö bla almɨdɨm, Pol Banabas yöŋö ipöxölim; paiŋö mönö ölɨsö yadön yadmä, “God Mönö wä aku ñɨgö Juda nöbö mö höd yadɨŋö, röl aku, jɨ ñɨŋ mönö wä aku pölön, an öim mɨdɨb mag aku nugw pɨb maga mɨdölö, röi aku makwam, wopik Juda nöbö mö yöi akuyöbö ñɨgö yad nöinɨŋa. ");
INSERT INTO tmd_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Aku agapɨm: Nöbö Diba anɨŋ yadön mönö aliö yadöŋa, ‘Nɨ yadmön, ñɨŋ Juda nöbö mö yöi akuyöbö ñɨgö mil ñɨŋa mɨdön, mögörɨb hörɨrör piaku duŋ, nöbö mö bla magalɨg mil maga nugwɨŋ nugugɨrön, nɨ ñɨgö kömö pɨnö,’ rö,” rɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Juda nöbö mö yöi piaku mönö aku nugwön, mɨ ödöriö wahax pön, Nöbö Diba mönö aku mɨ mönö waiö, me rɨmä. Makwam, nöbö mö God, öim öim mɨdɨŋ, me rön, yad nɨgöŋ nöbö mö piaku magalɨg mönö wä aku nugw pɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Makwam Nöbö Diba mönö mag aku, mögörɨb piaku magalɨg yad nölmɨn duöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Alöŋ aku, Juda nöbö mö bla nugumɨn ölɨsö wölɨm, du Adiok mö dib God nugw pim bli aipam, mögörɨb piaku nugwidɨx mɨdmɨdim nöbö dib bli aipam ñɨgö yadmɨn, ñɨŋ du nöbö mö mɨga akwör pön hön, Pol Banabas yöŋö ñɨgö rɨ gwogwam, rön, mögörɨb ñɨŋ piaku yad rɨŋö bö abmä. ");
INSERT INTO tmd_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Aliö yad rɨŋö bö abɨm, nöbö hogwa ñɨŋ Adiok röböx du gɨrön, mönö wä pön hö yad nölöla ñɨŋ pölöiŋö, rön, yamsö ñɨŋa bɨcep cep bla pɨlɨl rɨ abön taun dib Aikoniam dumä. ");
INSERT INTO tmd_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Makwam Inöm Leia nuŋ Jisas nugw pim nöbö mö piaku yuö kwo aja wölmɨn, ñɨŋ mɨ ödöriö wahax pɨ gɨr mɨdmä. ");
INSERT INTO tmd_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pol Banabas yöŋö du taun dib Aikoniam mɨdön, Juda mögum rɨb ram aku duön, mönö yad nöl ri abɨm nugugɨrön, Juda nöbö mö bla nɨgön, Juda nöbö mö yöi akuyöbö nɨgön, nöbö mö mɨga akwör Jisas nugw pɨmä. ");
INSERT INTO tmd_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Makwam Juda nöbö mö bli, Jisas mönö yadmɨdöi aku nugw pöinɨŋö, rön, duön Juda nöbö mö yöi akuyöbö ñɨgö mönö nugub nugwölɨbä inakmönö hörmɨdɨm nugwön, ñɨŋ Jisas nugw pim nöbö mö akuyöbö ñɨgö nugumɨn ölɨsö diba wölöŋa. ");
INSERT INTO tmd_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Jɨ Pol Banabas yöŋö mönö aku nugwön, mögörɨb aku röböx duölim. Ñɨŋ yöraku ör mɨdön, Nöbö Diba mönö aku ususör rön wöxnö akwör yad nölmɨdmä. Nöbö Dib nuŋ ñɨgö nöbö hogwa pɨsaŋ nugwidɨx mɨdmɨn nugugɨrön, ap rölɨbä akuyöbö bli, ap nugub nugwölɨbä akuyöbö bli rɨmɨdmɨn, nöbö mö bli nugwön yadmä, “Makwam, mönö yadmɨ