﻿USE sofia;
DROP TABLE IF EXISTS sofia.tlj_vpl;
CREATE TABLE tlj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tlj_vpl WRITE;
INSERT INTO tlj_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Mu ntandiko, Luhanga akahanga eghulu na nsi. ");
INSERT INTO tlj_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Nsi ekaba eli kwonkaha, etalimu kantu. Mweli̱ma ghukaba ghu̱swi̱ki̱i̱ye nanja kandi Mwoyo wa Luhanga aakalagha naabunga eegu̱u̱li̱ ya maasi. ");
INSERT INTO tlj_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Du̱mbi̱ Luhanga aaghila ati, “Kyeleeli̱ kibʼo” kandi kyeleeli̱ kyabʼo. ");
INSERT INTO tlj_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Luhanga aabona kyeleeli̱ eki kisemeeye, du̱mbi̱ aaghabani̱ja kyeleeli̱ na mweli̱ma. ");
INSERT INTO tlj_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Luhanga aaluka kyeleeli̱ “Ntangaali̱” kandi aaluka mweli̱ma “Mukilo.” Du̱mbi̱ haabʼo lwagholo na nkyambisi, kyaba kilo kyʼoku̱du̱bha. ");
INSERT INTO tlj_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Du̱mbi̱ Luhanga aaghila ati, “Haabʼo kintu haagati kibaghani̱je maasi aghali eegu̱u̱li̱ yakiyo na hansi yakiyo.” ");
INSERT INTO tlj_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Kandi niikuwo kyakabaaye. Luhanga aatʼo kintu kyabaghani̱ja maasi aghali hansi yakiyo na aghali eegu̱u̱li̱ yakiyo. ");
INSERT INTO tlj_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Luhanga aaluka kintu eki “Mwanya.” Haabʼo lwagholo na nkyambisi, kyaba kilo kyakabili. ");
INSERT INTO tlj_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Luhanga aaghila ati, “Maasi aghali hansi ya mwanya gheekumaani̱ye mu ki̱i̱kalo kimui kandi haabʼo etaka lyomi̱ye.” Kandi niikuwo kyakabaaye. ");
INSERT INTO tlj_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Luhanga aaluka etaka lyomi̱ye “Nsi,” aaluka maasi “Nanja.” Luhanga aabona eki kisemeeye. ");
INSERT INTO tlj_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Du̱mbi̱ Luhanga aaghila ati, “Etaka lituwʼo bi̱si̱ngo: bilimuwa ebikwanaghʼo bi̱ghu̱ma, hamui na biti ebikwanaghʼo bi̱ghu̱ma ebili na nsigho kusighikila haa mulingo ghwabiyo.” Kandi niikuwo kyakabaaye. ");
INSERT INTO tlj_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Etaka lyatuwʼo bi̱si̱ngo, na biti ebikwanamu bi̱ghu̱ma ebilimu nsigho, bu̱li̱ kimui mu kusighikila haa mulingo ghwakiyo. Luhanga aabona eki kisemeeye. ");
INSERT INTO tlj_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Haabʼo lwagholo na nkyambisi, kyaba kilo kyakasatu. ");
INSERT INTO tlj_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Luhanga aaghila ati, “Haabʼo byeleeli̱ mu mwanya kubaghani̱ja ntangaali̱ na mukilo kandi byoleke bilo, bwile, na myaka. ");
INSERT INTO tlj_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Oleke bibe mu mwanya kubhaki̱yagha hansi.” Kandi niikuwo kyakabaaye. ");
INSERT INTO tlj_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Luhanga aahanga byeleeli̱ bibili byamaani̱, kyeleeli̱ kimui kyamaani̱ kulema ntangaali̱, kyeleeli̱ kinji kikee kulema mukilo. Aahanga dhee nsooli̱ya. ");
INSERT INTO tlj_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Kandi Luhanga aasita mu mwanya ku̱bbeni̱ya hansi, ");
INSERT INTO tlj_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","kulema ntangaali̱ na mukilo kandi kubaghani̱ja kyeleeli̱ na mweli̱ma. Luhanga aabona eki kisemeeye. ");
INSERT INTO tlj_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Haabʼo lwagholo na nkyambisi, kyaba kilo kyakanaa. ");
INSERT INTO tlj_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Du̱mbi̱ Luhanga aaghila ati, “Oleke maasi ghaasulemu bihanguwa bwomi̱i̱li̱ kandi oleke noni̱ sihalale eghulu ya nsi mu mwanya.” ");
INSERT INTO tlj_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Du̱mbi̱ Luhanga aahanga bisolo biinamu̱li̱to byʼomu nanja na bihanguwa byona byomi̱i̱li̱ ebikuukalagha mu maasi, bu̱li̱ kimui kusighikila haa mulingo ghwakiyo, na bu̱li̱ noni̱ eghi eli na mapapa, kusighikila haa mulingo ghwayo. Luhanga aabona eki kisemeeye. ");
INSERT INTO tlj_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Luhanga aabiha mu̱gi̱sa, naaghila ati, “Mu̱byale kandi mukanile kimui, mu̱u̱su̱li̱ye nanja kandi oleke noni̱ sikanile kimui munsi.” ");
INSERT INTO tlj_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Haabʼo lwagholo na nkyambisi, kyaba kilo kyakataano. ");
INSERT INTO tlj_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Luhanga aaghila ati, “Oleke etaka li̱byale bihanguwa ebili na bwomi̱i̱li̱, kusighikila haa milingo yabiyo: bisolo bya mu maka, ebikwekuluulilagha haa etaka, bisolo bya mu kisaka, bu̱li̱ kimui kusighikila haa mulingo ghwakiyo.” Kandi niikuwo kyakabaaye. ");
INSERT INTO tlj_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Luhanga aakola bisolo bya mu kisaka kusighikila haa mulingo ghwabiyo, bisolo bya mu maka kusighikila haa mulingo ghwabiyo, na bihanguwa ebikwekuluulilagha haa etaka kusighikila haa mulingo ghwabiyo. Kandi niikuwo kyakabaaye. ");
INSERT INTO tlj_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Du̱mbi̱ Luhanga aaghila ati, “Oleke tuhange muntu mu kususa kwatu kandi oghu atu̱su̱si̱ye, niikuwo aleme nsu̱i̱ sya mu nanja, noni̱ sya mu mwanya, bisolo bya mu maka byona munsi yoona, na bihanguwa byona ebikwekuluulilagha haa etaka.” ");
INSERT INTO tlj_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Nahabweki Luhanga aahanga muntu amu̱su̱si̱ye kandi mu kisasani̱ kiye eenini, niimuwo aahangi̱ye musaasa na mukali̱. ");
INSERT INTO tlj_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Luhanga aabaha mu̱gi̱sa, aaghila ati, “Mu̱byale kandi mukanile kimui, mu̱u̱su̱li̱ye nsi kandi mughileme. Muleme nsu̱i̱ sya mu nanja, noni̱ sya mu mwanya, na bu̱li̱ kihanguwa kyona kyomi̱i̱li̱ ekikughendelagha hʼetaka.” ");
INSERT INTO tlj_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Du̱mbi̱ Luhanga aaghila ati, “Naakuhaaye bu̱li̱ kilimuwa kyona ekikwanaghamu nsigho munsi eni yoona, na bu̱li̱ kiti ekikwanaghamu bi̱ghu̱ma. Byona bilabaagha byokuliya byawe. ");
INSERT INTO tlj_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Kandi bisolo byona bya munsi, na noni̱ sya mu mwanya syona, na bihanguwa byona ebikwekuluulilagha hʼetaka ebili na lwoha lwa bwomi̱i̱li̱, naabihaaye bi̱si̱ngo bibisi kuba byokuliya byabiyo.” Kandi niikuwo kyakabaaye. ");
INSERT INTO tlj_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Luhanga aabona byona ebi aahangi̱ye, bisemeleeye kimui. Haabʼo lwagholo na nkyambisi, kyaba kilo kyamukaagha. ");
INSERT INTO tlj_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Nahabweki eghulu na nsi na bu̱li̱ kintu kyona byahuwa kuhanguwa. ");
INSERT INTO tlj_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Haa kilo kyamusanju̱, Luhanga akaba naamali̱ye mulimo oghu aakolagha, du̱mbi̱ haa kilo kyamusanju̱ aahuumula milimo yee yoona. ");
INSERT INTO tlj_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Du̱mbi̱ Luhanga aaha mu̱gi̱sa kilo kyamusanju̱ eki, aakifoola kilo kyeli̱ye, nanga niikiyo aahuumuliiyemu milimo yoona ya kuhanga eghi aakoli̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Eghi niiyo nsoboolola ya kuhanguwa kwa eghulu na nsi. Obu Mukama Luhanga aahangi̱ye eghulu na nsi, ");
INSERT INTO tlj_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","hakaba hatalimu bi̱si̱ngo kedha bilimuwa. Mukama Luhanga akaba atakatooneei̱ye mbu̱la hansi kandi akaba ataliyo muntu oghu akukola haa etaka eli, ");
INSERT INTO tlj_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","bhaatu maasi ghaalu̱ghagha mu etaka ghaamalakaka etaka lyona. ");
INSERT INTO tlj_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Mukama Luhanga aakola muntu mu etaka, aamuhuuha mu mihuli lwoha lwa bwomi̱i̱li̱, du̱mbi̱ muntu aaba mwomi̱i̱li̱. ");
INSERT INTO tlj_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Mukama Luhanga aatʼo musili bu̱lu̱gha ejooba, mu Edeni̱, eghi niiyo aataaye muntu oghu aahangi̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Mukama Luhanga aatwesi̱ya mu musili oghu biti bya milingo yoona, biti bisemeeye mu maaso ghaa muntu kandi ebili na bi̱ghu̱ma bisemeeye kuliya. Haagati ya musili oghu, hakaba halimu kiti kya bwomi̱i̱li̱ na kiti kya kumanya kilungi kandi kibhi. ");
INSERT INTO tlj_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Musili Edeni̱ oghu ghwalu̱ghaghamu maasi aghaaseesekagha mu musili oghu, gheebaghani̱jamu bi̱twi̱ke bbinaa bya maasi. ");
INSERT INTO tlj_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Li̱i̱na lya kyʼoku̱du̱bha baakighilaghamu Pi̱sooni̱, kikaba kikwamiiye mu kyalo kyona eki baaghilaghamu Havila, hambali feeja eli. ");
INSERT INTO tlj_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Feeja ya mu kyalo eki ekaba esemeleeye kimui, halimu dhee malaasi ghasasiiye kimui na ebaale lya muhendo baaghilaghamu bbedolaki̱. ");
INSERT INTO tlj_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Li̱i̱na lya ki̱twi̱ke kyakabili baakighilaghamu Gi̱hooni̱. Ki̱twi̱ke eki kikaba kikwamiiye mu kyalo kyona kya Ku̱u̱si̱. ");
INSERT INTO tlj_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Li̱i̱na lya ki̱twi̱ke kyakasatu baakighilaghamu Ti̱gu̱li̱i̱si̱. Ki̱twi̱ke eki kyasendagha nkighenda bu̱lu̱gha ejooba bwa Asi̱li̱ya. Ki̱twi̱ke kyakanaa baakighilaghamu Efulaati̱. ");
INSERT INTO tlj_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Mukama Luhanga aatwala muntu, aamuta mu musili ghwa Edeni̱ kukolaghamu na kughuloleelela. ");
INSERT INTO tlj_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Mukama Luhanga aalaghila muntu ati, “Oli na bughabe kuliya bi̱ghu̱ma byona bya bu̱li̱ kiti ekili mu musili muni, ");
INSERT INTO tlj_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","bhaatu okulaghiluwa kutaliya haa bi̱ghu̱ma bya kiti kya kumanya kilungi kandi kibhi, nanga kilo eki olikiliyʼo, majima kuwo oli̱ku̱wa.” ");
INSERT INTO tlj_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Mukama Luhanga aaghila ati, “Takili kilungi musaasa kuukala ali enkaha. Nkumukolela mu̱kooneli̱ oghu amusemeleeye.” ");
INSERT INTO tlj_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Bwile obu Mukama Luhanga akaba amali̱ye kuhanga ku̱lu̱gha mu etaka bisolo byona, na noni̱ sya mu mwanya. Aabileetela muntu kulola mali̱i̱na akubiluka, ti̱ li̱i̱na eli muntu aalu̱ki̱ye kihanguwa kyona, niiliyo li̱i̱na lyakiyo. ");
INSERT INTO tlj_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Muntu aaluka mali̱i̱na bisolo, noni̱ sya mu mwanya, na binyama byona bya mu kisaka. Bhaatu mu ebi byona, taabaayemu mu̱kooneli̱ oghu asemeleeye Adamu. ");
INSERT INTO tlj_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Nahabweki Mukama Luhanga aaghwesaghi̱li̱ya musaasa mpongo syamaani̱. Ti̱ obu aabaabaagha anaghwesaghiiye, aamuuyamu lubalu̱ lumui, aaghalila kihulu eki na nyama. ");
INSERT INTO tlj_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Mukama Luhanga aakola mukali̱ ku̱lu̱gha mu lubalu̱ olu aai̱ye mu musaasa, du̱mbi̱ aamuleetela musaasa. ");
INSERT INTO tlj_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Musaasa aaghila ati, “Lini niiliyo eku̱wa eli̱lu̱ghi̱ye mu maku̱wa ghanje kandi nyama eghi elu̱ghi̱ye mu nyama yanje, balamughilaghamu ‘mukali̱,’ nanga bakamuuya mu musaasa.” ");
INSERT INTO tlj_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Eki niikiyo kilalekagha musaasa alekaghe ese wee na ni̱na wee, eebohelʼo mukali̱ wee, ti̱ babe muntu omui. ");
INSERT INTO tlj_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Musaasa na mukali̱ wee bakaba bali muhina kandi tabakwatuwagha nsoni̱. ");
INSERT INTO tlj_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Bwile obu, njoka ekaba eli na magheji kusaali̱ya binyama byona bya mu kisaka ebi Mukama Luhanga aahangi̱ye. Kilo kimui yaasa hambali mukali̱ ali, yaamughila eti, “Majima Luhanga akaghila ati, ‘Mutaliliya ki̱ghu̱ma kyona kya kiti kya mu musili ghuni’?” ");
INSERT INTO tlj_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Mukali̱ aaghila njoka ati, “Tukugubha kuliya bi̱ghu̱ma bya biti bya mu musili ghuni, ");
INSERT INTO tlj_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","bhaatu Luhanga akaghila ati, ‘Mutaliliya haa ki̱ghu̱ma kya kiti ekili haagati ya musili ghuni kedha ku̱ki̱ku̱mʼo. Nimwakoli̱ye kuwo, mu̱ku̱ku̱wa.’ ” ");
INSERT INTO tlj_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Njoka yaaghila mukali̱ eti, “Majima tamu̱ku̱ku̱wa bbaa. ");
INSERT INTO tlj_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Luhanga akimani̱ye kwonini ati nimwanaliiye haa ki̱ghu̱ma eki, maaso ghaanu ghakuughulika kandi mukuba nga Luhanga, mukumanya kilungi kandi kibhi.” ");
INSERT INTO tlj_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Obu mukali̱ aaboone ngoku bi̱ghu̱ma bya mu kiti eki bi̱nu̱li̱ye kubiliya, bisemeeye mu maaso ghe kandi mbyetaaghisibuwa mu kuha magheji, aakobha bimui haa bi̱ghu̱ma ebi, aabiliya. Aaha bali̱i̱ wee bimui haa bi̱ghu̱ma ebi, naye aaliya. ");
INSERT INTO tlj_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Du̱mbi̱ baamanya ngoku bali muhina, nahabweki baaboheesani̱ya mababi ghaa bi̱si̱ngo baabyeswi̱ki̱la. ");
INSERT INTO tlj_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Lwagholo kilo eki, musaasa na mukali̱ wee baaghu̱wa elaka lya Mukama Luhanga naalubhantangila mu musili, du̱mbi̱ baamwebi̱si̱i̱li̱la mu biti bya mu musili oghu. ");
INSERT INTO tlj_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Bhaatu Mukama Luhanga aabilikila musaasa ati, “Oli haa?” ");
INSERT INTO tlj_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Musaasa aamukuukamu ati, “Naaghu̱u̱ye maki̱nde ghaawe mu musili, noobaha, nanga ndi muhina, du̱mbi̱ neebi̱sa.” ");
INSERT INTO tlj_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Luhanga aamukuukamu ati, “Ni ani̱ aakughambiiye ati oli muhina? Waliiye haa bi̱ghu̱ma bya kiti eki naakulaghiiye kutaliya?” ");
INSERT INTO tlj_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Musaasa aamukuukamu ati, “Mukali̱ oghu wampaaye kuukala naye hani, niiye ampaaye haa bi̱ghu̱ma bya kiti eki, nanje naabiliya.” ");
INSERT INTO tlj_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Niibuwo Mukama Luhanga aaghi̱li̱ye mukali̱ ati, “Mbiki waakoli̱ye ebi?” Mukali̱ aaghila ati, “Njoka niiyo yandimaagi̱ye kandi nanje naabiliya.” ");
INSERT INTO tlj_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Nahabweki Mukama Luhanga aaghila njoka ati, “Haabwa eki waakoli̱ye, waaki̱i̱nu̱u̱we kusaali̱ya bihanguwa byona na binyama bya mu kisaka byona! Olaghendeesi̱yagha mpanda kandi olaliyagha tu̱u̱tu̱ bilo byona bya bwomi̱i̱li̱ bwawe. ");
INSERT INTO tlj_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Kandi nkuta bu̱ghi̱ghu̱ haagati yaawe na mukali̱ kandi haagati ya baasukulu baawe na baasukulu be. Muusukulu wee alikuhuula mutuwe kandi naawe omukonde kali̱ghi̱so.” ");
INSERT INTO tlj_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Aaghila mukali̱ ati, “Nkukani̱li̱ya kimui busaali̱ji̱ bwawe mu ku̱byala, mu busaali̱ji̱ bwamaani̱ niimuwo olabyalilagha baana. Kweghomba kwawe kulaakalagha haa bali̱i̱ waawe kandi alakulemagha.” ");
INSERT INTO tlj_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Aaghila Adamu ati, “Nanga uwe waaghu̱u̱ye bya mukali̱ waawe kandi waaliya haa bi̱ghu̱ma bya kiti naakulaghiiye nti, ‘Otaliliyʼo,’ Etaka lyaki̱i̱nu̱u̱we haabwa eki waakoli̱ye eki, olakolagha na maani̱ mu busaali̱ji̱ niikuwo otunge byokuliya bilo byona bya bwomi̱i̱li̱ bwawe. ");
INSERT INTO tlj_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Etaka li̱ku̱ku̱tweseli̱ya bi̱si̱ngo na mahuwa kandi olaliyagha ebi okoli̱ye mu musili. ");
INSERT INTO tlj_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Olakolagha na maani̱, otu̱ngu̱tane niikuwo otunge byokuliya ku̱hi̱ki̱ya oku̱u̱ki̱ye mu etaka hambali waalu̱ghi̱ye, nanga okalu̱gha mu etaka kandi olikuuka mu etaka.” ");
INSERT INTO tlj_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adamu aaluka mukali̱ wee li̱i̱na Eeva, nanga niiye aaghendagha kufooka ni̱na boona abaakaaye. ");
INSERT INTO tlj_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Mukama Luhanga aakolela Adamu na mukali̱ wee byaku̱lu̱wala ku̱lu̱gha mu mpu kandi aabalu̱wi̱ka. ");
INSERT INTO tlj_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Mukama Luhanga aaghila ati, “Endindi muntu aafooki̱ye omui nga etu̱we, aamani̱ye kilungi kandi kibhi. Nahabweki takili kilungi eye kwi̱dha mukono kukobha ki̱ghu̱ma kya kiti kya bwomi̱i̱li̱ kukiliya kandi abe mwomi̱i̱li̱ bilo nʼebilo.” ");
INSERT INTO tlj_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Nahabweki Mukama Luhanga aabhinga musaasa mu musili ghwa Edeni̱ kughenda kukola haa etaka hambali aakoleeu̱we. ");
INSERT INTO tlj_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Haanu̱ma ya kumubhingamu, aata bu̱lu̱gha ejooba bwa musili ghwa Edeni̱ bakelu̱bbi̱ abaakalagha bakwete bihiyo bikwaka enu̱ma nʼomu maaso kulinda kihanda eki̱ghendi̱ye haa kiti kya bwomi̱i̱li̱. ");
INSERT INTO tlj_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamu aalangaala na mukali̱ wee Eeva, du̱mbi̱ aaku̱li̱ya etundu, aabyala Kai̱ni̱. Eeva aaghila ati, “Haabwa bu̱kooneli̱ bwa Mukama, naaleeti̱ye muntu munsi.” ");
INSERT INTO tlj_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Haanu̱ma, aatodha aabyala Abbeli̱. Abbeli̱ aaba mu̱li̱i̱si̱ya wa ntaama, Kai̱ni̱ aaba mu̱li̱mi̱. ");
INSERT INTO tlj_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Bwile bwahi̱ka Kai̱ni̱ aaleeta bimui haa bintu ebi ali aheli̱ye mu etaka kubihongela Mukama. ");
INSERT INTO tlj_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Bhaatu Abbeli̱ aaleeta mu̱li̱ghaaso ghwa ntaama siye eghi enoneeye kimui. Mukama aadheedhuwa haabwa kihonguwa kya Abbeli̱, ");
INSERT INTO tlj_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","bhaatu ataadheedhuwa na Kai̱ni̱ hamui na kihonguwa kiye. Du̱mbi̱ Kai̱ni̱ aasaaliluwa, haali̱i̱so yee eekunaku̱na. ");
INSERT INTO tlj_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Niibuwo Mukama aaghi̱li̱ye Kai̱ni̱ ati, “Osaaluuwe nangaaki? Eki̱leki̱ye haali̱i̱so akwekunaku̱ni̱ye nkiki? ");
INSERT INTO tlj_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Nuwaakoli̱ye eki̱hi̱ki̱ye, buuye tabaku̱ku̱si̱i̱ma? Bhaatu nuwaasaaghu̱u̱we kukola eki̱hi̱ki̱ye, kibhi kikuba kikuli haai-haai, nkibbala kukutwali̱li̱ja, bhaatu okulaghiluwa kukilema.” ");
INSERT INTO tlj_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Niibuwo Kai̱ni̱ aaghi̱li̱ye waani̱na wee Abbeli̱ ati, “Tughende mu musili.” Banali mu musili eghi, Kai̱ni̱ aaghwilikiilila waani̱na wee Abbeli̱, aamwita. ");
INSERT INTO tlj_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Mukama aaghila Kai̱ni̱ ati, “Wanjoko waawe Abbeli̱ ali haa?” Kai̱ni̱ aamukuukamu ati, “Tanimani̱ye bbaa. Buuye ni̱i̱si̱ye mu̱li̱ndi̱ wa mwana wamaaha?” ");
INSERT INTO tlj_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Mukama aamughila ati, “Waakoli̱ye kintu ki̱bhi̱i̱hi̱ye kitiyo nangaaki? Otegheeleli̱ye! Saghama ya wanjoko waawe niibuwo yandiliilila ku̱lu̱gha mu etaka niikuwo nkufubile. ");
INSERT INTO tlj_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Endindi naaku̱ki̱i̱ni̱ye kandi waabhi̱ngu̱u̱we haa etaka lini, eli waaseesi̱yʼo saghama ya wanjoko waawe oghu waati̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Noobu olakolagha haa etaka lini, talilakweleli̱yagha bilimuwa kandi okumala bwomi̱i̱li̱ bwawe bwona munsi noolalanga kitiyo-kitiyo.” ");
INSERT INTO tlj_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kai̱ni̱ aakuukamu Mukama ati, “Kifubilo kyanje kyahingulaane, tankukigubha. ");
INSERT INTO tlj_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Obwalo olimambhinga hani kandi na mu maaso ghaawe, nkutandika kulalanga kitiyo-kitiyo munsi, ti̱ weena oghu akaakumbona akunjita.” ");
INSERT INTO tlj_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Bhaatu Mukama aamughila ati, “Taaniikuwo kikuba bbaa, muntu weena oghu alikwita, akubona-bona ku̱ku̱saali̱ya milundi musanju̱.” Du̱mbi̱ Mukama aatʼo Kai̱ni̱ kaakulolelʼo, niikuwo muntu naanamusangaane, atamwita. ");
INSERT INTO tlj_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kai̱ni̱ aalu̱gha mu maaso ghaa Mukama, aaghenda aakala mu kyalo kya Noodi̱, bu̱lu̱gha ejooba bwa musili ghwa Edeni̱. ");
INSERT INTO tlj_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kai̱ni̱ aalangaala na mukali̱ wee, aaku̱li̱ya, aabyala mwana baamuluka li̱i̱na Enoka. Bwile obu Kai̱ni̱ aakwelagha kibugha, aakiluka li̱i̱na lya mutabani̱ wee Enoka. ");
INSERT INTO tlj_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoka aabyala Ilaadi̱, Ilaadi̱ aabyala Mekuyaali̱, Mekuyaali̱ aabyala Metu̱sayeeli̱, Metu̱sayeeli̱ aabyala Lameeki̱. ");
INSERT INTO tlj_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameeki̱ aaswela bakali̱ babili, omui li̱i̱na liye Aada, nʼonji li̱i̱na liye Jiila. ");
INSERT INTO tlj_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Aada aabyala Yabbaali̱, oghu akaba taata wa abaakalagha mu weema, bali bali̱i̱si̱ya baa bisolo. ");
INSERT INTO tlj_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Li̱i̱na lya waani̱na wee niiye akaba ali Yubbaali̱. Yubbaali̱ niiye akaba ali taata wa boona abaabaagha bateeli̱ baa maali̱kembe na ndele. ");
INSERT INTO tlj_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Jiila mukali̱ wee onji aabyala mwana wabusaasa, baamuluka li̱i̱na Tubbaali̱-kai̱ni̱. Tubbaali̱-kai̱ni̱ niiye aawiisagha bintu ku̱lu̱gha mu byoma. Mwani̱na Tubbaali̱-kai̱ni̱ baamughilaghamu Naama. ");
INSERT INTO tlj_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Kilo kimui Lameeki̱ aaghila bakali̱ be Aada na Jiila ati, “Mu̱tegheeleli̱ye enu̱we bakali̱ banje, mu̱u̱ghu̱we bighambo byanje. Naati̱ye musaasa haabwa kumputaali̱ya, mutabhana oghu amputaai̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Oghu akwita Kai̱ni̱ alaba naafubiluwa milundi musanju̱, oghu aliita Lameeki̱ alifubiluwa milundi nsanju̱ na musanju̱.” ");
INSERT INTO tlj_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamu aatodha aalangaala na mukali̱ wee, aabyala mwana wabusaasa kandi Eeva aamuluka li̱i̱na Seeji̱, elikumani̱i̱si̱ya ngu, “Luhanga aatodhi̱ye kumpa mwana onji mu ki̱i̱kalo kya Abbeli̱, oghu Kai̱ni̱ aati̱ye.” ");
INSERT INTO tlj_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seeji̱ naye aabyala mwana wabusaasa, baamuluka li̱i̱na Enosi̱. Bwile obu niibuwo bantu baatandikiiyemu kulami̱ya Mukama. ");
INSERT INTO tlj_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Eni niiyo nsoboolola ya baasukulu baa Adamu. Obu Luhanga aahangi̱ye muntu, akamuhanga mu kusasaana kuwe eenini. ");
INSERT INTO tlj_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Aahanga musaasa na mukali̱ kandi aabaha mu̱gi̱sa. Obu aabahangi̱ye aabaghilamu “muntu.” ");
INSERT INTO tlj_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Obu Adamu aahi̱ki̱i̱ye myaka 130, aabyala mwana amu̱su̱si̱ye kandi mu kususa kuwe kwonini, aamuluka li̱i̱na liye Seeji̱. ");
INSERT INTO tlj_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Haanu̱ma ya ku̱byala Seeji̱, Adamu aatodha aamala myaka 800 munsi kandi aabyala batabani̱ na bahala be banji. ");
INSERT INTO tlj_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adamu aamala munsi myaka 930, du̱mbi̱ aaku̱wa. ");
INSERT INTO tlj_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Obu Seeji̱ aahi̱ki̱i̱ye myaka 105, aabyala Enosi̱. ");
INSERT INTO tlj_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Haanu̱ma ya ku̱byala Enosi̱, Seeji̱ aatodha aamala munsi myaka 807 kandi aabyala batabani̱ na bahala be banji. ");
INSERT INTO tlj_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seeji̱ aamala munsi myaka 912, du̱mbi̱ aaku̱wa. ");
INSERT INTO tlj_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Obu Enosi̱ aahi̱ki̱i̱ye myaka 90, aabyala Kenaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Haanu̱ma ya ku̱byala Kenaani̱, Enosi̱ aatodha aamala myaka 815 kandi aabyala batabani̱ na bahala be banji. ");
INSERT INTO tlj_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enosi̱ aamala munsi myaka 905, du̱mbi̱ aaku̱wa. ");
INSERT INTO tlj_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Obu Kenaani̱ aahi̱ki̱i̱ye myaka 70, aabyala Mahalaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Haanu̱ma ya ku̱byala Mahalaleeli̱, Kenaani̱ aatodha aamala munsi myaka 840 kandi aabyala batabani̱ na bahala be banji. ");
INSERT INTO tlj_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenaani̱ aamala myaka 910 munsi, du̱mbi̱ aaku̱wa. ");
INSERT INTO tlj_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Obu Mahalaleeli̱ aahi̱ki̱i̱ye myaka 65, aabyala Yaledi̱. ");
INSERT INTO tlj_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Aamali̱ye ku̱byala Yaledi̱, Mahalaleeli̱ aatodha aamala myaka 830 kandi aabyala batabani̱ na bahala be banji. ");
INSERT INTO tlj_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalaleeli̱ aamala munsi myaka 895, du̱mbi̱ aaku̱wa. ");
INSERT INTO tlj_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Obu Yaledi̱ aahi̱ki̱i̱ye myaka 162, aabyala Enoka. ");
INSERT INTO tlj_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Haanu̱ma ya ku̱byala Enoka, Yaledi̱ aatodha aamala myaka 800 munsi kandi aabyala batabani̱ na bahala be banji. ");
INSERT INTO tlj_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yaledi̱ aamala munsi myaka 962, du̱mbi̱ aaku̱wa. ");
INSERT INTO tlj_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Obu Enoka aahi̱ki̱i̱ye myaka 65, aabyala Metu̱seela. ");
INSERT INTO tlj_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Obu aamali̱ye ku̱byala Metu̱seela, Enoka aaheeleli̱ya Luhanga kumala myaka 300 kandi aabyala batabani̱ na bahala be banji. ");
INSERT INTO tlj_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enoka aamala munsi myaka 365. ");
INSERT INTO tlj_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoka aaheeleli̱ya Luhanga, nahabweki taatodhi̱ye aboneka, nanga Luhanga akamutwala. ");
INSERT INTO tlj_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Obu Metu̱seela aahi̱ki̱i̱ye myaka 187, aabyala Lameeki̱. ");
INSERT INTO tlj_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Haanu̱ma ya ku̱byala Lameeki̱, Metu̱seela aatodha aamala munsi myaka 782 kandi aabyala batabani̱ na bahala be banji. ");
INSERT INTO tlj_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metu̱seela aamala munsi myaka 969, du̱mbi̱ aaku̱wa. ");
INSERT INTO tlj_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Obu Lameeki̱ aahi̱ki̱i̱ye myaka 182, aabyala mwana wabusaasa, ");
INSERT INTO tlj_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","aamuluka li̱i̱na Nuha, du̱mbi̱ aamughila ati, “Aku̱tu̱hu̱u̱mu̱li̱ya mu kukola kandi mu kusaaliluwa kwa kukola na mikono yaatu ekikuleetelejebuwa etaka eli Mukama aaki̱i̱ni̱ye.” ");
INSERT INTO tlj_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Haanu̱ma ya ku̱byala Nuha, Lameeki̱ aamala munsi myaka 595 kandi aabyala batabani̱ na bahala be banji. ");
INSERT INTO tlj_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lameeki̱ aamala munsi myaka 777, du̱mbi̱ aaku̱wa. ");
INSERT INTO tlj_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Obu Nuha aahi̱ki̱i̱ye myaka 500, aabyala Seemu, Haamu, na Yafeesi̱. ");
INSERT INTO tlj_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Obu bantu beeyongeeye kukana munsi kandi mbaabyala baana baabukali̱ bakani̱ye, ");
INSERT INTO tlj_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","baana baa Luhanga baabona bahala baa bantu aba basemeeye, baatandika kuswela oghu abadheedhi̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Du̱mbi̱ Mukama aaghila ati, “Mwoyo ghwanje oghukuhaagha bantu aba bwomi̱i̱li̱ taghukubaakalamu bilo byona bbaa. Ku̱lu̱gha endindi taaliyo oghu akuba mwomi̱i̱li̱ kusaali̱ya haa myaka 120.” ");
INSERT INTO tlj_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Obu batabani̱ baa Luhanga baasweye bahala baa bantu, baatandika kubabyalʼo baana abaafooki̱ye bantu baamaani̱ munsi omu. Bantu baamaani̱ aba baabaghilaghamu Banefi̱li̱, bakabʼo bwile obu kandi na haanu̱ma ya bwile obu, ti̱ bakaba bamanu̱u̱we munu. ");
INSERT INTO tlj_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Mukama aabona ngoku bubhi bwa bantu bwahingulaane munsi kandi ngoku bakuukalagha bwile bwona mbeeli̱li̱kanʼo bintu bi̱bhi̱i̱hi̱ye mu mitima yabo. ");
INSERT INTO tlj_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Mukama aasaaliluwa ekyaleki̱ye aakola muntu kumuta munsi kandi aasaaliluwa munu mu mutima ghuwe. ");
INSERT INTO tlj_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Nahabweki Mukama aaghila ati, “Nku̱hwelekeeleli̱ya munsi bantu boona aba naahangi̱ye, nku̱hwelekeeleli̱ya bantu boona, bisolo byona, bihanguwa byona ebikwekuluulilagha hansi, na noni̱ syomu mwanya, nanga nasaaluuwe ekyaleki̱ye naabihanga.” ");
INSERT INTO tlj_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Bhaatu Mukama aaghilila Nuha ngughuma. ");
INSERT INTO tlj_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Bini niibiyo ebikwetʼo Nuha. Nuha akaba ali musaasa ahi̱ki̱li̱i̱ye, akaba atali na kabhi koona mu bantu baa bwile obu kandi aaheeleli̱yagha Luhanga. ");
INSERT INTO tlj_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuha akaba ali na batabani̱ be basatu: Seemu, Haamu, na Yafeesi̱. ");
INSERT INTO tlj_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Bwile obu bantu bakaba babhiihiiye kimui mu maaso ghaa Luhanga kandi nsi ekaba eesuliiyemu kimui bubhi. ");
INSERT INTO tlj_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Luhanga aabona ngoku nsi yoona yaabhiihiiye kimui, nanga bantu baa munsi boona bakaba baasuliiye kimui bubhi mu milingo ekani̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Niibuwo Luhanga aaghi̱li̱ye Nuha ati, “Nkughenda kumalʼo bantu boona, nanga nsi yaabhiihiiye kimui haabwabo. Majima kuwo nkughenda kumalʼo nsi yoona na bantu abaghilimu. ");
INSERT INTO tlj_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Nahabweki weekolele bwati̱ bwa mbaau si̱gu̱mi̱ye, otemu bisiika kandi obusiighe kuluudu hanja na mukati ku̱bu̱gu̱mi̱ya. ");
INSERT INTO tlj_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ghuni niighuwo mulingo obhonganuuwe kubukolelamu: Kujamba kwabuwo kube fu̱u̱ti̱ 450, kugbaatikana kube fu̱u̱ti̱ 75 kandi kukangama kube fu̱u̱ti̱ 45. ");
INSERT INTO tlj_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Obutʼo lusui, oti̱ghʼo mwanya ghwa i̱nci̱ 18 haagati ya lusui olu hamui na bwati̱ obu. Ote mulyango mu maakpengbu̱ ghaabuwo, obufoole bwa kai̱na esatu kukangama. ");
INSERT INTO tlj_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ndimaghenda ku̱tu̱ngeeli̱ya maasi munsi yoona ku̱hwelekeeleli̱ya bu̱li̱ kantu akalimu. Nku̱hwelekeeleli̱ya bu̱li̱ kihanguwa kyomi̱i̱li̱ munsi. Bu̱li̱ kintu kyona ekili munsi kikuhwelekeelela. ");
INSERT INTO tlj_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Bhaatu ndimakola ndaghaano naawe nti okutaaha mu bwati̱ omu na mukali̱ waawe, baana baawe, hamui na bagholi baawe kandi nkubalinda kusemeeye. ");
INSERT INTO tlj_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Okutaaha mu bwati̱ obu na bihanguwa byona byomi̱i̱li̱ bibili bibili, kyabusaasa na kyabukali̱, niikuwo bibe byomi̱i̱li̱ hamui naawe. ");
INSERT INTO tlj_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Otemu bibili haa bu̱li̱ mulingo ghwa noni̱, bisolo, hamui na byona ebikwekuluulilagha hansi, niikuwo bibe byomi̱i̱li̱ hamui naawe. ");
INSERT INTO tlj_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Otemu bu̱li̱ mulingo ghwa byokuliya byona ebikuliibuwagha haaliibiyo enu̱we nabiyo mwaliyagha.” ");
INSERT INTO tlj_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuha aakola bu̱li̱ kintu kulungi kusighikila ngoku Luhanga aamulaghiiye. ");
INSERT INTO tlj_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Mukama aaghila Nuha ati, “Otaahe mu bwati̱, uwe na ka yaawe yoona, nanga nuuwe naaboone ohi̱ki̱li̱i̱ye mu mujo ghwa bantu ghuni. ");
INSERT INTO tlj_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Otwale bisolo musanju̱ byabusaasa na musanju̱ byabukali̱ haa bu̱li̱ mulingo ghwa bisolo byeli̱ye. Kandi otwale kisolo kimui kyabusaasa na kimui kyabukali̱ haa bu̱li̱ mulingo ghwa bisolo bitasemeeye. ");
INSERT INTO tlj_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Otemu noni̱ musanju̱ syabusaasa na musanju̱ syabukali̱ haa bu̱li̱ mulingo ghwa noni̱, niikuwo biikale binali byomi̱i̱li̱ munsi. ");
INSERT INTO tlj_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Bilo musanju̱ ku̱lu̱gha endindi, nkusindika mbu̱la munsi kumala bilo maku̱mi̱ anaa, mukilo na ntangaali̱ kandi nku̱hwelekeeleli̱ya bu̱li̱ kintu eki naahangi̱ye ekili hansi.” ");
INSERT INTO tlj_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nuha aakola byona ebi Mukama aamulaghiiye. ");
INSERT INTO tlj_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Bwile obu maasi agha ghaatungeeye munsi, Nuha akaba ali na myaka 600 ya bukulu. ");
INSERT INTO tlj_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nuha na mukali̱ wee, baana be, hamui na bagholi be boona baataaha mu bwati̱ obu kuuluka maasi agha. ");
INSERT INTO tlj_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Bu̱li̱ mulingo ghwa bisolo byeli̱ye na bi̱teeli̱ye, noni̱ kandi na bihanguwa ebikwekuluulilagha hansi, ");
INSERT INTO tlj_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","byabukali̱ na byabusaasa, byasa hambali Nuha ali kandi byataaha mu bwati̱ kusighikila ngoku Luhanga aalaghiiye Nuha. ");
INSERT INTO tlj_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Haanu̱ma ya bilo musanju̱, du̱mbi̱ maasi ghaatungeela munsi. ");
INSERT INTO tlj_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Mu mwaka ghwa 600 ghwa bwomi̱i̱li̱ bwa Nuha, byokweli̱ eku̱mi̱ na musanju̱, kweli̱ kwakabili, kilo eki mwanya ghwona ghwaghulika nga maadi̱li̱sa. ");
INSERT INTO tlj_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Mbu̱la yaatandika kutoona munsi kumala bilo 40 mukilo na ntangaali̱. ");
INSERT INTO tlj_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Kilo eki kyonini, Nuha na mukali̱ wee, batabani̱ be Seemu, Haamu na Yafeesi̱, na bagholi be baataaha mu bwati̱ omu. ");
INSERT INTO tlj_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Baataahamu na bu̱li̱ mulingo ghwa bisolo bya mu kisaka, na bya mu maka. Bu̱li̱ mulingo ghwa bisolo ebikwekuluulilagha hansi, bu̱li̱ mulingo ghwa noni̱, na byona ebili na mapapa. ");
INSERT INTO tlj_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Bu̱li̱ mulingo ghwa bihanguwa byomi̱i̱li̱ byasa hambali Nuha ali, byataaha mu bwati̱ omu. ");
INSERT INTO tlj_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Bisolo bya bu̱li̱ mulingo ebyataahaghamu, bikaba bili kyabusaasa na kyabukali̱, kusighikila ngoku Luhanga aalaghiiye Nuha. Du̱mbi̱ Mukama aabaghaalilamu. ");
INSERT INTO tlj_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Mbu̱la yaatoona kumala bilo 40, obu maasi gheeyongeeye kutungeela, ghaatandika kwi̱dha bwati̱ obu hansi. ");
INSERT INTO tlj_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Maasi gheeyongeleela kimui, ghaasula nsi yoona, bwati̱ obu bwatandika kughendela haagu̱u̱li̱ ya maasi agha. ");
INSERT INTO tlj_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Maasi ghaakanila kimui munsi, myena ekangamiiye kimui ya munsi yoona yaameluwa. ");
INSERT INTO tlj_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Maasi ghaakanila kimui ghaamela myena yoona kusaali̱ya fu̱u̱ti̱ 20. ");
INSERT INTO tlj_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Bu̱li̱ kintu kyona ekyabungilagha hansi kyahwelekeelela: noni̱, bisolo, binyama, bisolo byona ebikwekuluulilagha hansi, na bantu. ");
INSERT INTO tlj_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Bu̱li̱ kintu kyona haa etaka lyomi̱ye ekyabaagha kyomi̱i̱li̱ kyaku̱wa. ");
INSERT INTO tlj_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Bu̱li̱ kintu kyona hansi kyahwelekeelela: bantu kandi bisolo, bihanguwa byona ebyekuluulilagha haa etaka, hamui na noni̱ syomu mwanya, byona byahwelekeelela munsi. Nuha enkaha, na abaabaagha naye mu bwati̱, niibo baati̱ghaayʼo. ");
INSERT INTO tlj_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Maasi ghaatungeela munsi kumala bilo 150. ");
INSERT INTO tlj_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Luhanga aakala anaasu̱ki̱ye Nuha hamui na bisolo byona bya mu kisaka na bya mu maka ebi aabaabaagha nabiyo mu bwati̱. Nahabweki Luhanga aaleeta mwegha kuhunga munsi, du̱mbi̱ maasi agha ghaatandika kukeeha. ");
INSERT INTO tlj_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Luhanga aaghalila bihulu mu etaka hambali maasi ghaalu̱ghagha kwisa munsi. Aatodha aaghalila mwanya, mbu̱la yaaleka kutoona. ");
INSERT INTO tlj_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Maasi agha ghaamala bilo 150 nganakeeha bukee-buke. ");
INSERT INTO tlj_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Byokweli̱ eku̱mi̱ na musanju̱, kweli̱ kwamusanju̱ kwa mwaka oghu, niibuwo bwati̱ obu bwasu̱ndu̱ki̱ye bwaki̱dha haa mwena ya Alalaati̱. ");
INSERT INTO tlj_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Maasi agha ghaakala nganakeeha ku̱hi̱ki̱ya haa kibanja kweli̱ kweku̱mi̱ kwa mwaka oghu, du̱mbi̱ busonga bwa mwena nabuwo bwatandika kuboneka. ");
INSERT INTO tlj_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Haanu̱ma ya bilo 40, Nuha aaghula di̱li̱sa eli aabaabaagha ataaye haa bwati̱ haala, ");
INSERT INTO tlj_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","du̱mbi̱ aatwesi̱ya mu bwati̱ obu kinamungoogha, kyakala nki̱neeli̱ghi̱i̱li̱li̱ya eghulu ya maasi agha ku̱hi̱ki̱ya obu ghaahoneeye kimui hansi. ");
INSERT INTO tlj_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Aatodha aatumayo ki̱i̱bbi̱mbo kughenda kulola maasi ghalakaba ngoomi̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Bhaatu ki̱i̱bbi̱mbo eki obu kyatooye hanja, takyagu̱bhi̱ye kutunga hambali kikwemilila, nanga kyalo kyona kikaba kili maasi ghonkaha, du̱mbi̱ kyakuuka haa bwati̱ hambali Nuha ali. Nuha aakwata ki̱i̱bbi̱mbo eki, aaki̱ku̱u̱ki̱ya mu bwati̱. ");
INSERT INTO tlj_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nuha aalindʼo haabwa bilo musanju̱, du̱mbi̱ aatodha aatwesi̱ya ki̱i̱bbi̱mbo eki mu bwati̱. ");
INSERT INTO tlj_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Kyakuuka lwagholo, ki̱neni̱ye mu kanu̱wa kibabi kyakisika kibisi kya kiti oli̱va. Nuha aamanya ngoku maasi ghakwete kukeeha. ");
INSERT INTO tlj_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Aatodha aalindʼo bilo binji musanju̱, aatodha aatumayo ki̱i̱bbi̱mbo eki, dhelu obu kitaakuuka. ");
INSERT INTO tlj_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Obu Nuha aahi̱ki̱i̱ye myaka 601 ya bukulu, kibanja kya kweli̱ kwokubanja kwa mwaka ghuyaaka oghu, maasi ghoona ghakaba ngoomi̱ye haa etaka. Niibuwo Nuha aabbu̱u̱ku̱u̱ye ekyabaagha haa lusui lwa bwati̱ obu, aabona ngoku maasi ghaamali̱ye kwoma haa etaka. ");
INSERT INTO tlj_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Byokweli̱ abili na musanju̱, kweli̱ kwakabili kwa mwaka oghu, etaka lyona likaba limali̱ye kwomela kimui. ");
INSERT INTO tlj_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Du̱mbi̱ Luhanga aaghila Nuha ati, ");
INSERT INTO tlj_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Olu̱ghe mu bwati̱ omu na mukali̱ waawe, baana baawe, hamui na bagholi baawe. ");
INSERT INTO tlj_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Otwesi̱yemu bu̱li̱ kihanguwa kyona kyomi̱i̱li̱ ekilimu naawe: noni̱, bisolo, na bihanguwa byona ebikwekuluulilagha hansi, niikuwo bibyalukane munsi kandi bikanilemu kimui.” ");
INSERT INTO tlj_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Nahabweki Nuha aatuwamu na mukali̱ wee, baana be, hamui na bagholi be. ");
INSERT INTO tlj_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Bisolo na bihanguwa byona ebikwekuluulilagha hansi, hamui na noni̱, byona byatuwa mu bwati̱ omu bu̱li̱ ki̱bbu̱la kusighikila mu mulingo ghwakiyo. ");
INSERT INTO tlj_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Du̱mbi̱ Nuha aakwela kyakuhongelʼo Mukama, aatwala bimui haa bisolo na noni̱ byeli̱ye, aabihongelʼo nga bihonguwa byona byokeei̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Kusasa kwa bihonguwa byona byokeei̱ye ebi kwadheedha Mukama kandi aaghila ati, “Tanditodha kukiina etaka haabwa muntu, nankabha mutima ghuwe ghubhiihiiye kimui ku̱lu̱gha mu bwana. Tanditodha ku̱hwelekeeleli̱ya bihanguwa byomi̱i̱li̱ byona ngoku naakoli̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Ngoku nsi enaliyo, bwile bwa kuhela na kukesa, bwa kituumo na bwa mpeu, bwa musana na bwa mbu̱la, mukilo na ntangaali̱, tabilihuwʼo.” ");
INSERT INTO tlj_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Niibuwo Luhanga aahaaye Nuha na batabani̱ be mu̱gi̱sa, naaghila ati, “Mu̱byale, mukane kandi mu̱u̱su̱li̱ye nsi yoona. ");
INSERT INTO tlj_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Bisolo byona, noni̱ syona, bisolo byona ebikwekuluulilagha hansi kandi na nsu̱i̱ syona bikuboobaha. Naabahaaye bu̱li̱ kihanguwa kuba hansi ya bu̱toki̱ bwanu. ");
INSERT INTO tlj_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Bu̱li̱ kintu kyona kyomi̱i̱li̱ kandi ekikubungagha kikuba byokuliya byanu. Ngoku naabahaaye bilimuwa bya ki̱si̱ka kibisi kubiliya, endindi ndimabaha bu̱li̱ kintu kyona. ");
INSERT INTO tlj_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Bhaatu mutaliyagha nyama eghi enalimu saghama, nanga bwomi̱i̱li̱ bwa kisolo buli mu saghama yakiyo. ");
INSERT INTO tlj_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Kandi ndifubila muntu weena oghu aliita muunakiye. Ti̱ kinyama kya mu kisaka nkyati̱ye muntu, kikulaghiluwa nakiyo bakiite. Kandi muntu weena oghu akwita muunakiye naye bamwite. ");
INSERT INTO tlj_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Weena oghu akwita muntu muunakiye, naye aliitibuwa muntu onji, nanga muntu akahanguwa mu kususa kwa Luhanga. ");
INSERT INTO tlj_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Bhaatu enu̱we, mu̱byalukane kandi mukane, mukanile kimui munsi kandi mughikanemu.” ");
INSERT INTO tlj_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Niibuwo Luhanga aaghi̱li̱ye Nuha na batabani̱ be ati, ");
INSERT INTO tlj_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Ndimakola endindi ndaghaano naanu kandi na baasukulu baanu haanu̱ma yaanu, ");
INSERT INTO tlj_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","hamui na bihanguwa byona byomi̱i̱li̱: noni̱, bisolo bya mu maka, binyama byona byʼomu kisaka, bu̱li̱ kintu kyomi̱i̱li̱ ekyalu̱ghi̱ye mu bwati̱, ekili naanu munsi. ");
INSERT INTO tlj_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ndimakola ndaghaano naanu: Tanditodha ku̱hwelekeeleli̱ya bwomi̱i̱li̱ ni̱nkoleesi̱ya maasi kandi taalitodha kubʼo maasi ku̱hwelekeeleli̱ya nsi.” ");
INSERT INTO tlj_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Luhanga aaghila ati, “Kani niiko kaakulolelʼo kaa ndaghaano eghi ndimakola haagati yaanu kandi nanje na bu̱li̱ kihanguwa kyona ekili naanu, ndaghaano ya mijo yoona eghi ekubʼo. ");
INSERT INTO tlj_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Naataaye kiikilima kyanje mu bicu kandi niikiyo kakuba kaakulolelʼo kaa ndaghaano haagati yanje na bihanguwa byomi̱i̱li̱ munsi. ");
INSERT INTO tlj_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ndakaleetagha bicu eghulu kandi kiikilima nkyabonekamu, ");
INSERT INTO tlj_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ndaasukagha ndaghaano haagati yanje kandi naanu hamui na bihanguwa bya bu̱li̱ mulingo. Taalitodha kubʼo maasi kutungeela munsi ku̱hwelekeeleli̱ya bwomi̱i̱li̱. ");
INSERT INTO tlj_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Kiikilima kilakabonekagha mu bicu, ndakibonagha niisukaghe ndaghaano eni eghi etalihuwʼo haagati yanje Luhanga na bihanguwa byona ebili hansi.” ");
INSERT INTO tlj_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Niibuwo Luhanga aaghi̱li̱ye Nuha ati, “Kiikilima eki niikiyo kaakulolelʼo kaa ndaghaano naakoli̱ye haagati yanje na bihanguwa byona byomi̱i̱li̱ ebili hansi.” ");
INSERT INTO tlj_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Batabani̱ baa Nuha abaalu̱ghi̱ye mu bwati̱ niibo Seemu, Haamu na Yafeesi̱. (Haamu niiye akaba ese wa Kanaani̱.) ");
INSERT INTO tlj_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Aba niibo baabaagha batabani̱ basatu baa Nuha kandi bantu boona abali munsi ni baasukulu baabo. ");
INSERT INTO tlj_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuha akaba ali mu̱li̱mi̱, aahela musili ghwa mi̱jaabbi̱i̱bbu̱. ");
INSERT INTO tlj_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Kilo kimui aanuwa haa vi̱i̱ni̱ eghi ekalu̱ghamu, aatamiila du̱mbi̱ aalangaala mu weema yee ali muhina. ");
INSERT INTO tlj_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Obu Haamu, ese wa Kanaani̱, aataahi̱yemu naabona muhina ghwa ese wee, aatuwa, aaghenda aaghambila baghenji̱ be. ");
INSERT INTO tlj_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Bhaatu Seemu na Yafeesi̱ baata kyaku̱mu̱swi̱ka haa mabegha ghaabo, baataahamu ki̱neenu̱-nu̱ma, baaki̱swi̱ka esebo. Baakala banaloli̱ye luhande lunji niikuwo batabona muhina ghwa esebo. ");
INSERT INTO tlj_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Obu Nuha aasu̱su̱mu̱ki̱ye, naamanya eki mwana wee wʼobuto aakoli̱ye, ");
INSERT INTO tlj_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","aaghila ati, “Kanaani̱ akiinuwe! Akuba mu̱syana asembi̱yeyo wa baanakiye.” ");
INSERT INTO tlj_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Aatodha aaghila ati, “Asi̱i̱mu̱we Mukama, Luhanga wa Seemu! Kanaani̱ aabe mu̱syana wa Seemu. ");
INSERT INTO tlj_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Luhanga ahe Yafeesi̱ kyalo kikani̱ye, Yafeesi̱ aakalaghe mu weema sya Seemu kandi Kanaani̱ aabe mu̱syana wee.” ");
INSERT INTO tlj_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Haanu̱ma ya maasi kutungeela munsi, Nuha aatodha aamala myaka 350. ");
INSERT INTO tlj_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nuha aamala myaka yoona 950, du̱mbi̱ aaku̱wa. ");
INSERT INTO tlj_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Bani niibo baasukulu baa Nuha, aba batabani̱ be Seemu, Haamu, na Yafeesi̱ baabyaye haanu̱ma ya maasi kutungeela munsi. ");
INSERT INTO tlj_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Batabani̱ baa Yafeesi̱ niibo bani: Gomela, Magogi̱, Madaai, Yavaani̱, Tubbaali̱, Meseeki̱, na Tilaasi. ");
INSERT INTO tlj_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Na batabani̱ baa Gomela niibo bani: Asekenaji̱, Lifati̱, na Togolama. ");
INSERT INTO tlj_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Batabani̱ baa Yavaani̱ niibo bani: Eli̱sa, Talasi̱i̱si̱, Ki̱ti̱i̱mu̱, na Dodani̱mu̱. ");
INSERT INTO tlj_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Bani niibo baabaagha baataata baa bantu abaakalagha haa myalo hamui na bi̱i̱kalo bya mu maasi. Baabaghani̱jamu bu̱li̱ katu̱la mu mahanga ghaabo, kusighikila haa mi̱bu̱ghe yabo. ");
INSERT INTO tlj_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Batabani̱ baa Haamu niibo bani: Ku̱u̱si̱, Mi̱si̱li̱, Pu̱u̱ti̱, na Kanaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Batabani̱ baa Ku̱u̱si̱ niibo bani: Sebba, Havila, Sabbuta, Laama, na Sabbuteeka. Na baana baa Laama niibo bani: Sebba na Dedaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Ku̱u̱si̱ akaba ali dhee ese Ni̱mu̱loodi̱. Ni̱mu̱loodi̱ oghu akaba ali mulwani̱ wamaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Mukama aamubonagha ali mu̱hi̱i̱ghi̱ wamaani̱, niikiyo kyaleki̱ye baaghila bati, “Nga Ni̱mu̱loodi̱ mu̱hi̱i̱ghi̱ wamaani̱ wa Mukama munsi.” ");
INSERT INTO tlj_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Akadu̱bha kulema bi̱i̱kalo mu Bbabbeeli̱, Eleki̱, Akadi̱, na Kalene mu ehanga lya Bbabbu̱looni̱ya. ");
INSERT INTO tlj_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Ku̱lu̱gha mu kyalo eki aaghenda mu Asi̱li̱ya, aakwelayo Ni̱neeva, Lehobboti̱-I̱la, Kala, ");
INSERT INTO tlj_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","na Leseeni̱, eghi ekaba eli haagati ya Ni̱neeva na kibugha kiinamu̱li̱to Kala. ");
INSERT INTO tlj_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mi̱si̱li̱ akaba ali taata wa Balu̱di̱mu̱, Banami̱mu̱, Balehabbi̱mu̱, Banafu̱tu̱hi̱mu̱, ");
INSERT INTO tlj_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Bapasu̱lu̱si̱mu̱, Bakafu̱toli̱mu̱, na Bakasu̱lu̱hi̱mu̱. Kandi mu Bakasu̱lu̱hi̱mu̱ aba niimuwo aalu̱ghi̱ye Bafi̱li̱si̱ti̱. ");
INSERT INTO tlj_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaani̱ akaba ali ese wa Si̱dooni̱ mu̱li̱ghaaso ghuwe. Kanaani̱ akaba ali dhee taata wa Bahi̱ti̱, ");
INSERT INTO tlj_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Bayebu̱si̱, Bamooli̱, Bagi̱li̱gasi̱, ");
INSERT INTO tlj_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Bahi̱vi̱, Baaleki̱, Basi̱i̱ni̱, ");
INSERT INTO tlj_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Baalivaadi̱, Bajemaali̱, na Bahamaati. Haanu̱ma, Banakanaani̱ boona beehanjaaga. ");
INSERT INTO tlj_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Mitaano yabo yaatandikila Si̱dooni̱ kughendela kimui Gelaali̱, Gaja, Sodomu, Gomola, Adama, Jebbohi̱mu̱ ku̱hi̱ki̱ya Lasa. ");
INSERT INTO tlj_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Aba niibo baasukulu baa Haamu kusighikila haa bu̱tu̱la bwabo, mi̱bu̱ghe yabo, maka ghaabo, na mahanga ghaabo. ");
INSERT INTO tlj_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Seemu, mukulu wa Yafeesi̱, niiye akaba ali taata wa baasukulu baa Ebbeli̱ boona. ");
INSERT INTO tlj_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Batabani̱ baa Seemu niibo bani: Elaamu, Asu̱li̱, Apakisaadi̱, Lu̱di̱, na Alaamu. ");
INSERT INTO tlj_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Batabani̱ baa Alaamu niibo bani: U̱ji̱, Hu̱li̱, Geteeli̱, na Masi̱. ");
INSERT INTO tlj_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Apakisaadi̱ niiye akaba ali ese wa Seela, na Seela aabyala Ebbeli̱. ");
INSERT INTO tlj_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebbeli̱ aabyala baana babili: omui baamuluka li̱i̱na Peleegi̱ nanga bwile obu aabyaliluuwemu, bantu bakaba beebaghani̱i̱jemu munsi. Waakabili baamuluka li̱i̱na Yokitaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yokitaani̱ niiye akaba ali taata wa Alimodaadi̱, Seleefu, Hajali̱maave, Yeela, ");
INSERT INTO tlj_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadolaamu, Ujaali̱, Dikila, ");
INSERT INTO tlj_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obbali̱, Abbi̱meeli̱, Sebba, ");
INSERT INTO tlj_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofi̱li̱, Havila, na Yobbaabbu. Bani boona bakaba bali baana baa Yokitaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ki̱i̱kalo eki baakalaghamu kikaba kitandikiiye Meesa kughendela kimui Sefala mu kyalo kya bwena ekili bu̱lu̱gha ejooba. ");
INSERT INTO tlj_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Aba niibo batabani̱ baa Seemu kusighikila haa bu̱tu̱la bwabo, mi̱bu̱ghe yabo, nsi syabo, na mahanga ghaabo. ");
INSERT INTO tlj_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Aba niibo batabani̱ baa Nuha kusighikila mu ku̱byaluwa kwa baasukulu mu bantu baabo. Ku̱lu̱gha mu ebo, bantu baakanila kimui munsi haanu̱ma ya kutungeela kwa maasi munsi. ");
INSERT INTO tlj_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Haaku̱du̱bha munsi yoona hakaba halimu mu̱bu̱ghe ghumui ghwonkaha. ");
INSERT INTO tlj_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Obu bantu aba baaku̱lu̱ki̱ye kughenda bu̱lu̱gha ejooba, baaki̱dha mu kiigbete kyʼomu kyalo kya Bbabbu̱looni̱ya baaghoonamu. ");
INSERT INTO tlj_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Baaghambilangana bati, “Muleke tubumbe matafaali kandi tu̱ghooki̱ye kusemeeye.” Nanga bwile obu baakoleesi̱ya matafaali mu ki̱i̱kalo kya mabaale kandi baatabula kuluudu egu̱mi̱ye mu ki̱i̱kalo kya bulongo. ");
INSERT INTO tlj_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Kandi baaghambilangana bati, “Muleke twekwelele kibugha kandi tukwelemu ngbaali ekangamiiye kimui ku̱hi̱ka mu mwanya eghulu, niikuwo bantu batusinde kandi tuleke kuukala tuhanjikaane munsi.” ");
INSERT INTO tlj_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Bhaatu Mukama aasu̱ndu̱ka, aasa kulola munsi kandi aabona kibugha eki hamui na ngbaali eghi bantu aba bakwete kukwela. ");
INSERT INTO tlj_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Aaghila ati, “Bantu bani ngoku baku̱bu̱ghagha mu̱bu̱ghe ghumui, kyona eki balahanuulagha kukola, balakikolagha. ");
INSERT INTO tlj_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Nahabweki muleke tughende munsi tutambulani̱yemu mu̱bu̱ghe ghwabo oghu mu mi̱bu̱ghe ekani̱ye, niikuwo baleke kukengangana.” ");
INSERT INTO tlj_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","9","Du̱mbi̱ Mukama aasa aatambulani̱yamu mu̱bu̱ghe oghu aabahanjaaga munsi yoona, baaleka kukengangana kandi baaleka kukwela kibugha eki. Eki niikiyo kikulekagha kibugha eki bakighilaghilamu Bbabbeeli̱ nanga niiyo Mukama aatambulani̱i̱yemu mu̱bu̱ghe ghwa bantu munsi yoona. Ti̱ ku̱lu̱gha bwile obu, Mukama aabahanjaaga munsi yoona. ");
INSERT INTO tlj_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Bani niibo baasukulu baa Seemu. Haanu̱ma ya myaka ebili maasi ghaatungeeye kyalo kyona, obu Seemu aabaabaagha naahi̱ki̱i̱ye myaka 100 ya bukulu, aabyala Apakisaadi̱. ");
INSERT INTO tlj_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Seemu aamala myaka enji 500, mu myaka eghi aabyalilamu baana banji baabusaasa na baabukali̱. ");
INSERT INTO tlj_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Obu Apakisaadi̱ aahi̱ki̱i̱ye myaka 35 ya bukulu, aabyala Seela. ");
INSERT INTO tlj_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Apakisaadi̱ aamala myaka enji 403, mu myaka eghi aabyalilamu baana banji baabusaasa na baabukali̱. ");
INSERT INTO tlj_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Obu Seela aahi̱ki̱i̱ye myaka 30 ya bukulu, aabyala Ebbeli̱. ");
INSERT INTO tlj_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Seela aamala myaka enji 430, mu myaka eghi aabyalilamu baana banji baabusaasa na baabukali̱. ");
INSERT INTO tlj_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Obu Ebbeli̱ aahi̱ki̱i̱ye myaka 34 ya bukulu, aabyala Peleegi̱. ");
INSERT INTO tlj_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ebbeli̱ aamala myaka enji 430, mu myaka eghi aabyalilamu baana banji baabusaasa na baabukali̱. ");
INSERT INTO tlj_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Obu Peleegi̱ aahi̱ki̱i̱ye myaka 30 ya bukulu, aabyala Leeu. ");
INSERT INTO tlj_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Peleegi̱ aamala myaka enji 209, mu myaka eghi aabyalilamu baana banji baabusaasa na baabukali̱. ");
INSERT INTO tlj_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Obu Leeu aahi̱ki̱i̱ye myaka 32 ya bukulu, aabyala Selu̱gi̱. ");
INSERT INTO tlj_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Leeu aamala myaka enji 207, mu myaka eghi aabyalilamu baana banji baabusaasa na baabukali̱. ");
INSERT INTO tlj_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Obu Selu̱gi̱ aahi̱ki̱i̱ye myaka 30 ya bukulu, aabyala Naholi̱. ");
INSERT INTO tlj_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Selu̱gi̱ aamala myaka enji 200, mu myaka eghi aabyalilamu baana banji baabusaasa na baabukali̱. ");
INSERT INTO tlj_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Obu Naholi̱ aahi̱ki̱i̱ye myaka 29 ya bukulu, aabyala Teela. ");
INSERT INTO tlj_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Naholi̱ aamala myaka enji 119, mu myaka eghi aabyalilamu baana banji baabusaasa na baabukali̱. ");
INSERT INTO tlj_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Obu Teela aahi̱ki̱i̱ye myaka 70 ya bukulu, aabyala Ebbulaamu, Naholi̱, na Halaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Baasukulu baa Teela niibo bani: Teela aabyala Ebbulaamu, Naholi̱, na Halaani̱. Halaani̱ aabyala Looti̱. ");
INSERT INTO tlj_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Halaani̱ aadu̱bha ku̱kwi̱la ese wee Teela. Aakwi̱la mu kibugha kya Ula mu kyalo kya Bakaladi̱ya hambali baamu̱byaliiye. ");
INSERT INTO tlj_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ebbulaamu na Naholi̱ bombi baaswela. Mukali̱ wa Ebbulaamu baamughilaghamu Salaai̱ kandi mukali̱ wa Naholi̱ baamughilaghamu Milika. Milika na muto wee I̱si̱ka bakaba bali bahala baa Halaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Salaai̱ akaba atali na mwana, nanga akaba ali ngumba. ");
INSERT INTO tlj_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Teela aatu̱wamu ku̱lu̱gha mu kibugha kya Ula kughenda kuukala mu kyalo kya Bakaladi̱ya. Aatwala mutabani̱ wee Ebbulaamu, muusukulu wee Looti̱ mutabani̱ wa Halaani̱. Aatwala mugholi wee Salaai̱ mukaa mutabani̱ wee Ebbulaamu oghu. Boona baalu̱gha mu kibugha kya Ula mu kyalo kya Bakaladi̱ya, baatandika kughenda mu nsi ya Kanaani̱. Bhaatu obu baaki̱dhi̱ye mu tau̱ni̱ ya Halaani̱, baaghoonamu. ");
INSERT INTO tlj_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Mu tau̱ni̱ ya Halaani̱ eghi, niiyo Teela aakwi̱li̱i̱ye naahi̱ki̱i̱ye myaka 205 ya bukulu. ");
INSERT INTO tlj_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Mukama aaghila Ebbulaamu ati, “Olu̱ghe mu ehanga lya ewaanu, mu nganda syawe kandi na mu ka ya so waawe, oghende mu nsi eghi nkukwoleka. ");
INSERT INTO tlj_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Nkukuha baasukulu bakaniiye kimui, nkufoole ehanga lyamaani̱, nkukuha mu̱gi̱sa kandi ndeke bantu bakani̱ye bakumanye kandi haabwawe batunge mu̱gi̱sa. ");
INSERT INTO tlj_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Boona abakukukola kulungi nanje nkubaha mu̱gi̱sa. Bhaatu nkukiina boona abakukukola kubhi. Kandi haabwawe nkuha bantu boona baa munsi mu̱gi̱sa.” ");
INSERT INTO tlj_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Du̱mbi̱ Ebbulaamu aalu̱ghayo, ngoku Mukama aamughambiiye, na Looti̱ aaghenda hamui naye. Ebbulaamu obu aalu̱ghagha Halaani̱, akaba ali na myaka 75. ");
INSERT INTO tlj_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Aatwala mukali̱ wee Salaai̱, muuhuwa wee Looti̱, etungo lyabo, hamui na bantu boona aba baatungiiye Halaani̱, baaghenda Kanaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Obu baaki̱dhi̱ye e Kanaani̱, baakwamila mu ki̱i̱kalo eki, baaki̱dha Sekeemu hambali kiti ki̱i̱looku̱ kya Moole kyabaagha, baakalayo. Bwile obu Banakanaani̱ nabo dhee bakaba baakaaye mu kyalo eki. ");
INSERT INTO tlj_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Mukama aabonekela Ebbulaamu kandi aamughila ati, “Lini niiliyo ehanga eli nkuha baasukulu baawe.” Nahabweki Ebbulaamu aakwela hambali Mukama aamubonekeeye haala kyakuhongelʼo Mukama bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Haanu̱ma yʼebi, Ebbulahi̱mu̱ aahona mu kyalo kya eku̱wa kyʼomu kyalo kya bwena bu̱lu̱gha ejooba bwa kibugha kya Bbeeseeli̱ kandi aakwela weema siye mu kyalo eki. Bbeteeli̱ yaabaagha bughuwa ejooba bwakiyo kandi na kibugha kya Aai̱ kili bu̱lu̱gha ejooba bwakiyo. Mu kyalo eki aakwelamu dhee kyakuhongelʼo Mukama bihonguwa kandi aalami̱ya Mukama. ");
INSERT INTO tlj_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Du̱mbi̱ Ebbulaamu aamu̱ki̱ya kughenda Negeebbu. ");
INSERT INTO tlj_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Njala yamaani̱ yaaghuwa mu kyalo Kanaani̱ eki, nahabweki Ebbulaamu aaghenda eku̱wa mu ehanga lya Mi̱si̱li̱ kuukalayo haabwa bwile bukee. ");
INSERT INTO tlj_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Obu aabaabaagha ali haai ku̱ki̱dha mu ehanga lya Mi̱si̱li̱ eli, aaghila mukali̱ wee Salaai̱ ati, “Nkimani̱ye ngoku oli mukali̱ asemeeye kwonini. ");
INSERT INTO tlj_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Banami̱si̱li̱ mbanakuboone, bakughila bati oli mukali̱ wanje. Du̱mbi̱ bakunjita bhaatu uwe bakukuleka ookalʼo. ");
INSERT INTO tlj_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Mbanaku̱bu̱u̱i̱ye, oghile oti oli mwani̱naasi̱ye, ti̱ uwe okuleka batanjita kandi bankole kusemeeye.” ");
INSERT INTO tlj_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Obu Ebbulaamu aaki̱dhi̱ye Mi̱si̱li̱, bantu baayo baabona mukali̱ wee asemeeye kwonini. ");
INSERT INTO tlj_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Obu bamui mu bakulu baa mu bu̱lemi̱ bwa Falaaho baamuboone, baaghenda baamughambila ngoku mukali̱ oghu asemeeye kwonini. Du̱mbi̱ baatwala Salaai̱ mu kikaali kiye. ");
INSERT INTO tlj_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Haabwa Salaai̱ oghu, Falaaho aakola kulungi Ebbulaamu, aamuha ntaama, mbu̱li̱, nte, ndogooi̱ kandi na ngamila sikani̱ye. Aamuha dhee na basyana bakani̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Bhaatu Mukama aaleka Falaaho na ka yee yoona baalwala ndwala sya kabhi munu haabwa Salaai̱, mukali̱ wa Ebbulaamu. ");
INSERT INTO tlj_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Niibuwo Falaaho oghu aabilikiiye Ebbulaamu, aamu̱bu̱u̱li̱ya ati, “Wankoli̱ye otiyo nangaaki? Nkiki kyaleki̱ye otangambila ngoku Salaai̱ ali mukali̱ waawe? ");
INSERT INTO tlj_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nkiki kyaleki̱ye waaghila oti ni mwanjoko waawe kuleka niimuswela? Nahabweki mukali̱ waawe ngughu, omutwale kandi mughende.” ");
INSERT INTO tlj_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Du̱mbi̱ Falaaho aalaghila baasilikale be baahelekeeleli̱ya Ebbulaamu na mukali̱ wee Salaai̱, na ebi baabaagha nabiyo byona, ku̱hi̱ki̱ya baabatweseei̱ye mu ehanga lya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ebbulaamu na mukali̱ wee Salaai̱ baalu̱gha Mi̱si̱li̱ na byona ebi baabaagha nabiyo, baaghenda hamui na Looti̱ mu elungu lya Negeebbu. ");
INSERT INTO tlj_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ebbulaamu akaba atungiiye kimui, ali na bisolo bikaniiye kimui kandi na sente sikaniiye kimui. ");
INSERT INTO tlj_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Obu Ebbulaamu aalu̱ghi̱ye Negeebbu, aaghenda naanaghoona mu bi̱i̱kalo bya mbaghani̱ja ku̱hi̱ki̱ya obu aaki̱dhi̱ye Bbeeseeli̱. Aaghoona mu ki̱i̱kalo ekili haagati ya tau̱ni̱ ya Bbeteeli̱ na ya Aai̱ hambali aabaabaagha adu̱bhi̱ye kughoona, ");
INSERT INTO tlj_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","kandi hambali aadu̱bhi̱ye kukwela kyakuhongelʼo Mukama bihonguwa. Du̱mbi̱ aalami̱li̱yʼo Mukama. ");
INSERT INTO tlj_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Na Looti̱, oghu aaghendagha hamui na Ebbulaamu oghu, naye akaba ali na ntaama, mbu̱li̱, nte, hamui na maaweema. ");
INSERT INTO tlj_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Bhaatu ki̱i̱kalo eki takyagu̱bhi̱ye kubamala bombi, nanga bisolo byabo bikaba bikaniiye kimui kandi eki kitaabagu̱bhi̱i̱si̱ya kuukala hamui. ");
INSERT INTO tlj_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Bali̱i̱si̱ya baa bisolo bya Ebbulaamu baakala kutongana na bali̱i̱si̱ya baa bisolo bya Looti̱. Ti̱ bwile obu Banakanaani̱ na Bapeleeji̱ nabo bakaba baakaaye mu kyalo eki dhee. ");
INSERT INTO tlj_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Niibuwo Ebbulaamu aaghi̱li̱ye Looti̱ ati, “Tuleke kutongana kandi na bali̱i̱si̱ya baatu nabo baleke kutongana, nanga etu̱we boona tuli baani̱na emui. ");
INSERT INTO tlj_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Oleke tughabane kyalo kini etu̱we bombi, nuwaatwete luhande lwabumesu, si̱ye nkutwala lwabuliyo. Nuwaatwete lwabuliyo, si̱ye nkutwala lwabumesu.” ");
INSERT INTO tlj_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Looti̱ aalola aabona kyalo kyona kya kiigbete kya Yolodaani̱ kiisuuyemu maasi kandi kili nga musili ghwa Mukama Edeni̱ kandi ki̱su̱si̱ye kyalo kya Mi̱si̱li̱, ekili haai na tau̱ni̱ ya Joola. (Eki kikabʼo Mukama atakahwelekeleei̱ye bibugha kya Sodomu na Gomola.) ");
INSERT INTO tlj_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Baatambulanamu, Looti̱ aaghenda bu̱lu̱gha ejooba, aatwala kighona kya maasi Yolodaani̱ kyona. ");
INSERT INTO tlj_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ebbulaamu aakala mu kyalo kya Kanaani̱, Looti̱ eye aakala mu maatau̱ni̱ ghaa mu kiigbete kya Yolodaani̱ kandi aakwela weema siye haai na kibugha kya Sodomu. ");
INSERT INTO tlj_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ti̱ bantu baa Sodomu bakaba bali babhi munu, baakolagha bintu bibhiihiiye kimui mu maaso ghaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Haanu̱ma ya Looti̱ kughenda, Mukama aaghila Ebbulaamu ati, “Olole kyalo eki kyona ku̱lu̱gha hambali oli haala, olole eku̱wa na elughulu, bu̱lu̱gha ejooba na bughuwa ejooba bwakiyo. ");
INSERT INTO tlj_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Nkukuha kyalo eki kyona, uwe na baasukulu baawe bilo nʼebilo. ");
INSERT INTO tlj_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Nkukuha baasukulu bakaniiye kimui kandi nankabha muntu agubha kubala muhendo ghwa tu̱u̱tu̱ eghi eli hansi, ebo taakugubha kubabala bbaa. ");
INSERT INTO tlj_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Oghende, obungile mu kyalo eki kyona haa bu̱li̱ luhande lwakiyo, nanga nkughenda kukuha kiyo kyona.” ");
INSERT INTO tlj_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Nahabweki Ebbulaamu aaku̱lu̱ki̱ya weema siye, aaghenda aakala haai na tau̱ni̱ ya Hebbu̱looni̱ haai na biti bi̱i̱looku̱ bya musaasa li̱i̱na liye Mami̱le. Aakwelʼo kyakuhongelʼo Mukama bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Bwile obu, Amulafeeli̱ mukama wa Sinala, Ali̱yoki̱ mukama wa Elasaali̱, Kadolamooli̱ mukama wa Elaamu, na Tidaali̱ mukama wa Gohi̱mu̱, ");
INSERT INTO tlj_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","baaghenda kulwana na Bbeela mukama wa Sodomu, Bbelu̱sa wa Gomola, Sinaabbu wa Adama, Semebeeli̱ wa Jebbohi̱mu̱, hamui na mukama wa Bbeela. (Eghi baaghilaghamu Joola.) ");
INSERT INTO tlj_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Bakama aba boona beelungani̱ya hamui mu kighona kya Si̱di̱i̱mu̱, (haa maasi agha baaghilaghamu Nanja ya Kisula.) ");
INSERT INTO tlj_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Bakama aba bakaba bali hansi ya bu̱toki̱ bwa Mukama Kadolamooli̱ kumala myaka eku̱mi̱ nʼebili, bhaatu mu mwaka ghwa eku̱mi̱ nʼesatu boona baamujeemela. ");
INSERT INTO tlj_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Mu mwaka ghwa eku̱mi̱ nʼenaa, Kadolamooli̱ hamui na bakama banji abaabaagha bamu̱sembi̱ye baasa na baasilikale baabo baaghenda baalwana. Baasi̱ngu̱la Balefahi̱mu̱ mu Asi̱telosi̱ Kalanahi̱mu̱, na Baji̱ji̱mu̱ bʼomu Haamu, na Beemi̱mu̱ bʼomu Sava-ki̱li̱yasai̱mu̱, ");
INSERT INTO tlj_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","na Bahooli̱ bʼomu kyalo kya bwena kya Seyi̱li̱. Baahumila kimui bantu aba baabahi̱ki̱ya Elipalaani̱ haai na elungu. ");
INSERT INTO tlj_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Du̱mbi̱ baakuuka, baasi̱ngu̱la kandi baalema bantu bʼomu Nemi̱si̱paati̱ (eghi baaghilaghamu Kadesi̱), baalema kyalo kyona kya Bamaleeki̱ na Bamooli̱ abaabaagha baakaaye Hajajooni̱ Tamala. ");
INSERT INTO tlj_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Niibuwo bakama wa Sodomu, wa Gomola, wa Adama, wa Jebbohi̱mu̱ hamui na wa Bbeela (eghi baaghilaghamu Joola) baaghendi̱ye mu kighona kya Si̱di̱i̱mu̱. ");
INSERT INTO tlj_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Baaghenda kulwana na Mukama Kadolamooli̱ wa Elaamu, Tidaali̱ wa Gohi̱mu̱, na Amulafeeli̱ wa Sinala, na Ali̱yoki̱ wa Elasaali̱. Bakama bbanaa bani baalwana na bakama bataano. ");
INSERT INTO tlj_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Kighona kya Si̱di̱i̱mu̱ kikaba kilimu bi̱i̱na ebyabaaghamu biisi bya bisaabo. Obu baasilikale baa bakama wa Sodomu na Gomola baalukagha baabyegengakakamu, abaati̱ghaayʼo baalukila mu myena. ");
INSERT INTO tlj_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Abaasi̱ngu̱u̱ye baatwala bintu byona ebyabaagha mu bibugha kya Sodomu na Gomola, hamui na byokuliya byabo byona, baaghenda nabiyo. ");
INSERT INTO tlj_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Baatwala Looti̱, muuhuwa wa Ebbulaamu, na etungo liye lyona, nanga naye akaba aakaaye mu kibugha kya Sodomu. ");
INSERT INTO tlj_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Bhaatu muntu omui oghu akaaluka haa bulemo haala, aaghenda aaghambila Ebbulaamu Muhebbulaayo oghu akaba aakaaye haai na biti bi̱i̱looku̱ bya musaasa li̱i̱na liye Mami̱le wʼomu ntu̱la ya Bamooli̱. Mami̱le akaba ali mwana waani̱na Esi̱kooli̱ na Anele. Banaani̱na emui basatu aba bakaba balaghaane na Ebbulaamu kukoonelangana naabaayʼo bulemo bwona. ");
INSERT INTO tlj_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Obu Ebbulaamu aaghu̱u̱ye ngoku baatwete muuhuwa wee Looti̱, aabilikila basaasa be 318 abamani̱ye kulwana, baalabha bakama bbanaa aba, baaki̱dhi̱la kimui mu tau̱ni̱ baaghilaghamu Daani̱. ");
INSERT INTO tlj_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Obu bwile bwali̱ye, Ebbulaamu aatambulani̱yamu basaasa be aba mu bi̱bbu̱la-bi̱bbu̱la, baatandika kulwana na ngi̱ghu̱ syabo esi mbalu̱gha mu mpande syona sya tau̱ni̱ eghi kandi baasi̱ngu̱la ngi̱ghu̱ syabo esi. Baabahumila kimui, baabahi̱ki̱ya Hobba elughulu ya kibugha kya Damasiko. ");
INSERT INTO tlj_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ebbulaamu aayayo byona ebi baabaagha batwete. Aayayo dhee muuhuwa wee Looti̱, na etungo liye lyona, bakali̱, na bantu banji boona aba ngi̱ghu̱ syabo esi baabaagha batwete. ");
INSERT INTO tlj_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Obu Ebbulaamu aakuukagha ewe e ka haanu̱ma ya ku̱si̱ngu̱la ngi̱ghu̱ syabo baasilikale baa mukama Kadolamooli̱ na bakama banji abaabaagha naye, mukama wa Sodomu aaghenda kumusangaana mu kighona kya Sava (eki baaghilaghamu kighona kya mukama.) ");
INSERT INTO tlj_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Meli̱ki̱jedeki̱ mukama wa Saleemu kandi mu̱hongi̱ wa Luhanga wa Eghulu Munu, aaleetela Ebbulaamu mugaati̱ na vi̱i̱ni̱. ");
INSERT INTO tlj_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Aaha Ebbulaamu mu̱gi̱sa naaghila ati, “Luhanga wa Eghulu Munu, oghu akahanga eghulu na nsi, ahe Ebbulaamu oni mu̱gi̱sa. ");
INSERT INTO tlj_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Kandi bantu basinde Luhanga wa Eghulu Munu, oghu aaleki̱ye waagubha ku̱si̱ngu̱la ngi̱ghu̱ syawe syona.” Kandi Ebbulaamu aaha Meli̱ki̱jedeki̱ kimui kyʼeku̱mi̱ kya bintu byona ebi aahi̱ye haa bulemo. ");
INSERT INTO tlj_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Niibuwo mukama wa Sodomu aaghi̱li̱ye Ebbulaamu ati, “Ompe bantu aba waahi̱ye mu kibugha kya ewanje Sodomu, bhaatu bintu binji byona, obitwale.” ");
INSERT INTO tlj_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Bhaatu Ebbulaamu aamukuukamu ati, “Ndimalahila mu maaso ghaa Mukama Luhanga wa Eghulu Munu kandi oghu akahanga eghulu na nsi ");
INSERT INTO tlj_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","nti, tankutwala kantu koona nankabha kahu̱u̱ji̱ kedha kaghuwo ka nkai̱to syawe. Nanga ninaakoli̱ye kuwo okughila oti nuuwe waaleki̱ye naaba muguudha. ");
INSERT INTO tlj_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Tandi na kantu koona aka si̱ye nkutwala haabwanje bbaa. Ebi nku̱si̱i̱ma nti naatwete ni ebi basaasa banje baaliiye. Bhaatu baanakyanje aba Anele, Esi̱kooli̱, na Mami̱le aba twaghendi̱ye nabo kulwana, oleke batwale ebi baahi̱yeyo ku̱lu̱gha mu ngi̱ghu̱ syatu.” ");
INSERT INTO tlj_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Haanu̱ma yʼebi, Mukama aabonekela Ebbulaamu mu ndooti̱, aamughila ati, “Ebbulaamu otoobaha, ni̱i̱si̱ye ngabo yaawe kandi nkukuha mpeela ekani̱ye kwonini.” ");
INSERT INTO tlj_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ebbulaamu aaghila ati, “Ai̱ Mukama Luhanga, buuye mpeela okumpa ekunkoonela kantu koona? Bbaa, nanga tandi na mwana, ti̱ oghu aligwetuwa ebyanje ni Eli̱yeeja oghu alu̱ghi̱ye Damasiko. ");
INSERT INTO tlj_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Tawampaaye mwana, ti̱ oghu aligwetuwa ebyanje ni mu̱heeleli̱ya wanje Eli̱yeeja.” ");
INSERT INTO tlj_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Niibuwo Mukama aatodhi̱ye aamughila ati, “Mu̱heeleli̱ya waawe Eli̱yeeja oghu taaniiye akugwetuwa ebyawe bbaa. Mwana waawe eenini niiye akugwetuwa ebyawe.” ");
INSERT INTO tlj_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Mukama aatwesi̱ya Ebbulaamu enja, aamughila ati, “Olole eghulu kandi olengʼo kubala muhendo ghwa nsooli̱ya esi, niikuwo okuba na baasukulu bakaniiye kimui batiyo.” ");
INSERT INTO tlj_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ebbulaamu aahi̱ki̱li̱ja Mukama, ti̱ Luhanga aamubala kuba ahi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Niibuwo Mukama aatodhi̱ye aamughila ati, “Ni̱i̱si̱ye Mukama waawe oghu akakuuya mu kibugha kya Ula mu kyalo Kyabakaladi̱ya naakuha kyalo kini kuba kyawe.” ");
INSERT INTO tlj_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Bhaatu Ebbulaamu aaghila ati, “Mukama Luhanga, si̱ye buuye nkumanya nti̱ya ngoku nkutwala kyalo kini kyona?” ");
INSERT INTO tlj_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Mukama aamughila ati, “Oghende ondeetele nte eghi eli na myaka esatu, bhughuma ya mbu̱li̱ eghi eli na myaka esatu, na ntu̱u̱li̱ ya ntaama eghi eli na myaka esatu. Ondeetele ki̱i̱bbi̱mbo hamui na kaana kaa kaapi̱i̱so.” ");
INSERT INTO tlj_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ebbulaamu aaleetela bintu ebi byona, aata bisolo ebi kandi aabyati̱yamu bu̱li̱ kimui bihande bibili, aapanga hansi haa mpande ebili, bhaatu noni̱ siyo ataasyati̱yamu bihande bibili bbaa. ");
INSERT INTO tlj_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Bi̱noni̱ ebikuliyagha nyama byasu̱ndu̱kagha hansi kuliya nyama esi, Ebbulaamu aabibhingʼo. ");
INSERT INTO tlj_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Hambali musana ghwakotelagha haala, Ebbulaamu aaghwesaghiilila kimui, mweli̱ma ghwa kabhi ghwakwata hambali aabaabaagha, ti̱ oobahila kimui. ");
INSERT INTO tlj_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Mukama Luhanga aamughila ati, “Baasukulu baawe balitwaluwa mu ehanga litali lyabo, hambali bakuba baku̱lu̱ki̱. Baliba basyana baa bantu bʼomu ehanga eli kandi balitwalikani̱ya kubhi baasukulu baawe aba kumala myaka 400. ");
INSERT INTO tlj_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Bhaatu ndifubila bantu bʼomu ehanga abakufoola baasukulu baawe basyana kandi bali̱lu̱gha mu ehanga eli na buguudha bwamaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Uwe oliikalʼo okaakulile kimui, oku̱we onali mu bu̱si̱nge kandi bakujiike mu mulingo ghusemeeye. ");
INSERT INTO tlj_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Nahabweki mujo ghwa baasukulu baawe ghwakanaa niibo balikuuka mu kyalo kini, nanga bwile obu bubhi bwa Bamooli̱ buliba buhingulaane kandi bahi̱ki̱ye haa si̱ye kubafubila.” ");
INSERT INTO tlj_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Obu musana ghwakoti̱ye mweli̱ma ngwakwata, munagha ghukwete kucuukamu mwi̱ka na toci̱ yaaki̱ye byaboneka kandi byasaalila haagati ya bihande bya bisolo ebi. ");
INSERT INTO tlj_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Haa kilo eki Mukama aakola ndaghaano na Ebbulaamu naaghila ati, “Naalaghaana kuha baasukulu baawe kyalo kini kyona ku̱lu̱ghi̱i̱li̱la haa mutaano ghwa ehanga lya Mi̱si̱li̱ ku̱hi̱ki̱ya haa maasi ghaanamu̱li̱to Efulaati̱, ");
INSERT INTO tlj_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","kyalo kyona eki Banakeeni̱, Bakeneeji̱, Bakadu̱mooni̱, ");
INSERT INTO tlj_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Bahi̱ti̱, Bapeleeji̱, Balefahi̱mu̱, ");
INSERT INTO tlj_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Bamooli̱, Banakanaani̱, Bagi̱li̱gasi̱, hamui na Bayebu̱si̱ baakaayemu.” ");
INSERT INTO tlj_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Bwile obu, Salaai̱ mukali̱ wa Ebbulaamu akaba atamu̱byaliiye mwana nʼomui. Bhaatu akaba ali na mu̱syana wee alu̱ghi̱ye naye Mi̱si̱li̱, li̱i̱na liye Hagali̱. ");
INSERT INTO tlj_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Niibuwo Salaai̱ aaghi̱li̱ye ati, “Si̱ye Mukama taasi̱i̱mi̱ye ati nku̱byalile mwana. Oghende olangaale na mu̱syana wanje oghu, kedha eye angu̱byala mwana abe wanje.” Ebbulaamu aasi̱i̱ma kukola eki mukali̱ wee Salaai̱ aabu̱ghi̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Nahabweki Salaai̱ aaha Ebbulaamu Hagali̱ Munami̱si̱li̱ kuba nga mukali̱ wee. Eki kikabʼo haanu̱ma ya Ebbulaamu kumala myaka eku̱mi̱ mu ehanga lya Kanaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ebbulaamu aalangaala na Hagali̱ kandi Hagali̱ oghu aaku̱li̱ya. Obu aamani̱ye ngoku aku̱li̱i̱ye, aatandika kwepanka kandi kughaya mukama wee Salaai̱. ");
INSERT INTO tlj_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Niibuwo Salaai̱ aaghi̱li̱ye Ebbulaamu ati, “Hagali̱ kungaya atiyo ni musango ghwawe, nanga si̱ye neenini ni̱i̱si̱ye nkakuhaye, ti̱ ku̱lu̱gha aamani̱ye ngoku aku̱li̱i̱ye, aatandi̱ki̱ye kungaya. Ti̱ oleke Mukama aliiye aatu̱twi̱lamu si̱ye naawe oghu aakoli̱ye eki̱hi̱ki̱ye.” ");
INSERT INTO tlj_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ebbulaamu aamughila ati, “Oghu ni mu̱syana waawe kandi omuliyo bu̱toki̱, omukole ngoku obbali̱ye.” Du̱mbi̱ Salaai̱ aatandika kubona-boni̱ya mu̱syana wee Hagali̱ oghu, nahabweki Hagali̱ oghu aaluka kughenda. ");
INSERT INTO tlj_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Malai̱ka wa Mukama aasanga Hagali̱ haa nsulo eghi ekaba eli mu elungu haakpengbu̱ ya luguudhe olwaghendagha mu tau̱ni̱ ya Suula. ");
INSERT INTO tlj_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Malai̱ka aamughila ati, “Hagali̱, mu̱syana wa Salaai̱, oku̱lu̱gha haa kandi okughenda haa?” Hagali̱ aamukuukamu ati, “Niibuwo naaluka ku̱lu̱gha ewaa mukama wanje Salaai̱.” ");
INSERT INTO tlj_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Malai̱ka wa Mukama aamughila ati, “Okuuke ewaa mukama waawe kandi omudhootele.” ");
INSERT INTO tlj_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Malai̱ka wa Mukama aatodha aamughila ati, “Nkukuha baasukulu bakaniiye kimui kandi taaliyo muntu nʼomui oghu akugubha kubabala.” ");
INSERT INTO tlj_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Malai̱ka wa Mukama eeyongela kughila Hagali̱ ati, “Etundu eli oku̱li̱i̱ye eli oku̱byalamu mwana wabusaasa. Okumuluka li̱i̱na liye Sumai̱li̱ nanga Mukama aaghu̱u̱ye ngoku okwete kubona-bona. ");
INSERT INTO tlj_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","“Mwana oghu akuba nga nguwe kandi alahakani̱yagha bu̱li̱ muntu weena kandi bantu bakani̱ye balamuhakani̱yagha kandi akuukala hambali aselaane na baghenji̱ be.” ");
INSERT INTO tlj_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hagali̱ eebu̱u̱li̱ya ati, “Kitimbiikaane si̱ye ku̱hi̱ki̱li̱ja nti naaboone Mukama oghu akuukalagha amboone.” Nahabweki aaghilamu Mukama oghu akabu̱gha li̱i̱na ati, “Luhanga oghu akubonagha byona.” ");
INSERT INTO tlj_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Niikiyo kikulekagha bantu baghilamu nsulo eghi eli haagati ya Kadesi̱ na Bbeledi̱ bati, “Nsulo ya Luhanga Mwomi̱i̱li̱ Oghu Amboone.” ");
INSERT INTO tlj_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hagali̱ aabyala mwana wabusaasa, Ebbulaamu aamuluka li̱i̱na ati niiye Sumai̱li̱. ");
INSERT INTO tlj_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Bwile obu Ebbulaamu akaba ali na myaka 86 ya bukulu. ");
INSERT INTO tlj_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Obu Ebbulaamu aahi̱ki̱i̱ye myaka 99 ya bukulu, Mukama aamubonekela kandi aamughila ati, “Ni̱i̱syoni Luhanga wa Bu̱toki̱ Bwona. Ompu̱ti̱ye kandi okolaghe ebi̱hi̱ki̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Nku̱gu̱mi̱ya ndaghaano yanje kandi nkuhe baasukulu bakaniiye kimui.” ");
INSERT INTO tlj_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Du̱mbi̱ Ebbulaamu aateeli̱ya kandi eetu̱li̱ka haali̱i̱so yee haaku̱ma hansi. Luhanga aatodha aamughila ati, ");
INSERT INTO tlj_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Ni̱i̱si̱ye ndimakola ndaghaano naawe nti okuba na baasukulu bakaniiye kimui abakukughilamu taata wabo. ");
INSERT INTO tlj_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ti̱ ku̱lu̱gha obwalo, li̱i̱na lyawe lyaleki̱ye kuba Ebbulaamu, bhaatu balakughilaghamu Ebbulahi̱mu̱, nanga nkukufoola ese wa bantu bʼomu mahanga ghakani̱ye.” ");
INSERT INTO tlj_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","“Oku̱byala kandi obe na baasukulu bakaniiye kimui kandi bakufooka mahanga ghakani̱ye. Bamui mu baasukulu baawe aba bakuba bakama. ");
INSERT INTO tlj_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ndaghaano yanje hamui na baasukulu baawe ekuukalʼo bilo nʼebilo, nanga si̱ye ndi Luhanga waawe kandi Luhanga wabo. ");
INSERT INTO tlj_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Nkuha uwe na baasukulu baawe kyalo eki olimu endindi nga munamahanga, ku̱hi̱ki̱li̱ya kimui e Kanaani̱. Kyalo eki kyona kikuba kya baasukulu baawe bilo nʼebilo kandi nkuba Luhanga wabo.” ");
INSERT INTO tlj_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Niibuwo Luhanga aaghi̱li̱ye Ebbulahi̱mu̱ ati, “Uwe na baasukulu baawe kandi na mijo yoona eghi ekulabha baasukulu baawe aba mukulaghiluwa kukwata ndaghaano yanje. ");
INSERT INTO tlj_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Eni niiyo ndaghaano ndimakola naawe kandi na baasukulu baawe kandi eki mukulaghiluwa kukwata niikiyo kini: Bu̱li̱ mwana wabusaasa weena oghu mulakabyalagha bamusalaghe. ");
INSERT INTO tlj_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Naawe Ebbulahi̱mu̱ okulaghiluwa kukusala nga kaakulolelʼo kwoleka ngoku waasi̱i̱mi̱ye ndaghaano yanje hamui naawe. ");
INSERT INTO tlj_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Mu bu̱li̱ mijo yoona eghi ekubʼo haanu̱ma yaawe, bu̱li̱ mwana wabusaasa weena oghu alabyaluwagha kandi naahi̱ki̱ya bilo munaanaa alalaghiluwagha bamusale. Basalaghe baana boona baabusaasa ababyahuwe mu baasukulu baawe kedha aba baghu̱li̱ye na sente ku̱lu̱gha mu bantu abatali nganda syawe kwisa mu baasukulu baawe. ");
INSERT INTO tlj_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Boona aba baasukulu baawe babyaye kedha aba baghu̱li̱ye na sente, balalaghiluwagha kubasala. Niikuwo ndaghaano yanje eekale eli ya bilo nʼebilo mu mibili yaanu. ");
INSERT INTO tlj_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ti̱ mwana wabusaasa weena oghu batasali̱ye, balamubhingagha mu ntu̱la yaanu haabwa kubhenga ndaghaano yanje eghi.” ");
INSERT INTO tlj_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Luhanga aaghila Ebbulahi̱mu̱ ati, “Ku̱lu̱gha obwalo otatodha kughila mukali̱ waawe oti Salaai̱, li̱i̱na liye lyabaaye Saala. ");
INSERT INTO tlj_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nkumuha mu̱gi̱sa kandi aku̱ku̱byalila mwana wabusaasa. Nkuha Saala oghu mu̱gi̱sa kandi nimufoole ni̱na wa bantu bʼomu mahanga ghakani̱ye kandi mu lu̱byalo luwe aku̱lu̱ghamu na bantu banji abakuba bakama.” ");
INSERT INTO tlj_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ebbulahi̱mu̱ aateeli̱ya kandi eetu̱li̱ka haali̱i̱so yee haaku̱ma hansi, naaneebu̱u̱li̱ya mu mutima ghuwe ati, “Muntu oghu nkaakuuye nganje oghu ndi na myaka 100, nkugubha nti̱ya ku̱byala mwana? Kandi na mukali̱ wanje Saala ali na myaka 90 ya bukulu, ti̱ akugubha ati̱ya ku̱byala mwana?” ");
INSERT INTO tlj_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ebbulahi̱mu̱ aaghila Luhanga ati, “Haabwaki otaaleki̱ye Sumai̱li̱ aaliiye aaba mugwetuwa wa eki wandaghiisani̱i̱ye eki?” ");
INSERT INTO tlj_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Bhaatu Luhanga aamukuukamu ati, “Uwe na mukali̱ waawe Saala mu̱ku̱byala mwana wabusaasa kandi okumuluka li̱i̱na I̱saka. Nkweyongela kuukali̱yʼo ndaghaano yanje hamui naye kandi ekuba ya bilo nʼebilo kandi ekuba ya baasukulu be abakubʼo haanu̱ma yee. ");
INSERT INTO tlj_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ngoku waakansabi̱ye, na Sumai̱li̱ nkumuha mu̱gi̱sa, naye aku̱byala kandi aabe na baasukulu bakani̱ye. Kandi aku̱byala baana eku̱mi̱ na babili, ti̱ bu̱li̱ omui akulema ntu̱la emui haa ntu̱la eku̱mi̱ na ebili. Ntu̱la esi nkusifoola ehanga lyamaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Bhaatu nku̱gu̱mi̱ya ndaghaano yanje na I̱saka oghu Saala aku̱byala mu bwile nga buni bwonini mu mwaka ghukwisa.” ");
INSERT INTO tlj_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Obu Luhanga aamali̱ye ku̱bu̱gha na Ebbulahi̱mu̱, aalu̱ghʼo aaghenda. ");
INSERT INTO tlj_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Kilo eki kyonini, Ebbulahi̱mu̱ aatwala mutabani̱ wee Sumai̱li̱ kandi bu̱li̱ muntu weena wabusaasa oghu akaba ali mu ka yee, otaayemu na baana baabusaasa baa basyana be aabaabaagha aghu̱li̱ye na sente, boona baabasala ngoku Luhanga aamulaghiiye. ");
INSERT INTO tlj_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ebbulahi̱mu̱ naye eenini baamusala, bwile obu akaba ali na myaka 99 ya bukulu. ");
INSERT INTO tlj_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Kandi Ebbulahi̱mu̱ aasala Sumai̱li̱, Sumai̱li̱ bwile obu akaba ali na myaka 13 ya bukulu. ");
INSERT INTO tlj_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Kilo eki kyonini Ebbulahi̱mu̱ na mutabani̱ wee Sumai̱li̱ baabasala. ");
INSERT INTO tlj_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Kandi na bu̱li̱ muntu weena wabusaasa oghu akaba ali mu ka yee, oghu baabaagha babyaliiyemu kandi nʼaba baabaagha baghu̱li̱ye na sente ku̱lu̱gha mu bantu banji, boona baabasala kilo eki. ");
INSERT INTO tlj_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Kilo kimui Ebbulahi̱mu̱ akaba asitami̱ye haa mulyango ghwa weema yee, musana ghutweleeye kimui. Mukama aatodha aamubonekela, haai na biti bi̱i̱looku̱ bya musaasa li̱i̱na liye Mami̱le. ");
INSERT INTO tlj_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Obu Ebbulahi̱mu̱ aaloli̱ye, aabona basaasa basatu baamiliiye nga haala haai-haai naye. Obu Ebbulahi̱mu̱ aababoone, aaghenda bwangu-bwangu, aabeebinga. Obu aahi̱ki̱ye hambali bali, aahi̱ka aateeli̱ya aagomba, haali̱i̱so yee haaku̱ma hansi. ");
INSERT INTO tlj_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Aabaghila ati, “Bakama banje, munkwatiluwe ngughuma, mutansaala. ");
INSERT INTO tlj_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Muhumule mu ki̱i̱ku̱dhu̱ kya nti̱na ya kiti kiinamu̱li̱to kini, muleke hakili baheeleli̱ya banje baleete maasi babanaabi̱ye mu maghulu. ");
INSERT INTO tlj_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ngoku mwasi̱i̱mi̱ye kundolʼo, muleke mbahe kaakuliya niikuwo mugubhe kutunga maani̱ ghaa kweyongela mu lughendo lwanu.” Baamukuukamu bati, “Kale, okole ngoku waabu̱ghi̱ye.” ");
INSERT INTO tlj_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Du̱mbi̱ Ebbulahi̱mu̱ aataaha bwangu mu weema, aaghila mukali̱ wee Saala ati, “Opi̱i̱me bwangu biikopo bisatu bya ngano, obikande, oteekemu migaati̱.” ");
INSERT INTO tlj_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Aaghenda bwangu mu kigho kiye kya nte, aayamu nte eghi enoni̱ye, aaghiha mu̱koli̱ aaghitwala baaghisala bwangu-bwangu. ");
INSERT INTO tlj_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Obu byokuliya byahiiye, Ebbulahi̱mu̱ aaleetela basaasa bani magita ghaa nte, mata, hamui na nyama syokeei̱ye. Ebbulahi̱mu̱ aakala anabalindiliiye mu ki̱i̱ku̱dhu̱ mbanaliya. ");
INSERT INTO tlj_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Niibuwo basaasa aba baabu̱u̱i̱ye Ebbulahi̱mu̱ bati, “Mukali̱ waawe Saala ali haa?” Ebbulahi̱mu̱ aabakuukamu ati, “Ali mu weema omu.” ");
INSERT INTO tlj_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Mukama aaghila Ebbulahi̱mu̱ ati, “Mwaka oghukwisa nkutodha kukuuka hani bwile nga buni bwonini, ti̱ bwile obu mukali̱ waawe Saala akuba abyaye mwana wabusaasa.” Bwile obu Saala akaba aamiliiye haakpengbu̱ ya mulyango ghwa weema eghi mu numba enu̱ma syabo abategheleei̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ebbulahi̱mu̱ na Saala bombi bakaba bamali̱ye kukaakulila kimui kandi Saala naasaaye haa myaka ya ku̱byala. ");
INSERT INTO tlj_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Du̱mbi̱ Saala aatandika kusekela haa mutima ghuwe naaneeli̱li̱kana ati, “Si̱ye naamali̱ye kukaakula kandi na mukama wanje naye akaakuuye, ti̱ tukugubha tu̱ti̱ya kutodha kweghonja haa bulili?” ");
INSERT INTO tlj_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Mukama aabu̱u̱li̱ya Ebbulahi̱mu̱ ati, “Nkiki kikuleka Saala naaseka kandi naaghila ati eye akaakuuye taakugubha ku̱byala mwana? ");
INSERT INTO tlj_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Haliyo kyona ekikusaagha si̱ye Mukama? Nkukuuka hani mwaka ghukwisa bwile nga buni bwonini kandi mukali̱ waawe Saala akuba abyaye mwana wabusaasa.” ");
INSERT INTO tlj_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Saala oobaha, du̱mbi̱ aabu̱gha naaha bisubha ati, “Tanaaseki̱ye bbaa.” Bhaatu Mukama aamughila ati, “Oleke kwehakana, waaseki̱ye.” ");
INSERT INTO tlj_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Obu basaasa aba baanamu̱ki̱yagha kughenda, Ebbulahi̱mu̱ anabahelekeleei̱ye, baaloleei̱ye mu kibugha kya Sodomu. ");
INSERT INTO tlj_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Mukama aaghila ati, “Tambbali̱ye ku̱bi̱sa Ebbulahi̱mu̱ eki ndi haai kukola. ");
INSERT INTO tlj_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Majima baasukulu baa Ebbulahi̱mu̱ bakuba baamaani̱ kandi ehanga lyamaani̱ kandi mahanga ghoona ghaa munsi ghakutunga mu̱gi̱sa haabuwe. ");
INSERT INTO tlj_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Naakomi̱yemu Ebbulahi̱mu̱ oghu, niikuwo agubhe kwegheesi̱ya baana be na maka ghaabo haanu̱ma yee ku̱hu̱ti̱ya Mukama kandi kukolagha ebi̱hi̱ki̱ye kandi ebi mbbali̱ye bilo nʼebilo. Eki kikuleka ngubhe kuha Ebbulahi̱mu̱ baasukulu bakani̱ye ngoku naamulaghi̱i̱sani̱i̱ye.” ");
INSERT INTO tlj_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Niibuwo Mukama aaghi̱li̱ye ati, “Naaghu̱u̱ye ngoku bantu baa Sodomu na Gomola bakwete kukola bikoluwa bibhiihiiye kimui kandi bibhi byabo byahingulaane. ");
INSERT INTO tlj_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Nahabweki nkughendayo kwelolela neenini niikuwo nimanye ghalakaba ghali majima kedha bbaa.” ");
INSERT INTO tlj_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Basaasa babili ebo beegaali̱ya, baatandika kughenda baloleei̱ye Sodomu, bhaatu Mukama aati̱ghala na Ebbulahi̱mu̱. ");
INSERT INTO tlj_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ebbulahi̱mu̱ eebinga Mukama, aamughila ati, “Buuye obu oku̱hwelekeeleli̱ya bantu babhi abali mu kibugha eki, na bahi̱ki̱li̱i̱ye abalimu okubahwelekeeleli̱ya dhee? ");
INSERT INTO tlj_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ti̱ buuye mu kibugha eki naabaaye halimu bantu maku̱mi̱ ataano abahi̱ki̱li̱i̱ye, buuye oku̱hwelekeeleli̱ya bantu boona abali mu kibugha eki? ");
INSERT INTO tlj_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Majima Mukama wanje, otakola otiyo ku̱hwelekeeleli̱ya bantu bahi̱ki̱li̱i̱ye mahwelekeeleli̱ya bantu babhi aba. Nuuwe oku̱twi̱lagha bantu boona abali munsi musango mu bwengani̱ja.” ");
INSERT INTO tlj_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Mukama aamukuukamu ati, “Ninaasangi̱yemu bantu maku̱mi̱ ataano abahi̱ki̱li̱i̱ye, tanku̱hwelekeeleli̱ya abali mu kibugha eki bbaa.” ");
INSERT INTO tlj_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ebbulahi̱mu̱ aatodha aaghila ati, “Mukama wanje, onganile haabwa bighambo naabu̱ghi̱ye, nanga si̱ye tanibhonganuuwe ku̱bu̱gha bighambo bikani̱ye ngʼebi bbaa. ");
INSERT INTO tlj_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ti̱ nuwasangi̱ye mu kibugha kya Sodomu eki bantu maku̱mi̱ anaa na bataano bonkaha abahi̱ki̱li̱i̱ye, nabuwo dhee oku̱hwelekeeleli̱ya kibugha eki haabwa bataano kubulʼo ku̱hi̱ka maku̱mi̱ ataano?” Mukama aakuukamu ati, “Ninaasangi̱yemu bantu maku̱mi̱ anaa na bataano bahi̱ki̱li̱i̱ye, tanku̱hwelekeeleli̱ya kibugha eki bbaa.” ");
INSERT INTO tlj_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ebbulahi̱mu̱ aatodha aaghila Mukama ati, “Ti̱ buuye mbanabaaye maku̱mi̱ anaa bonkaha abahi̱ki̱li̱i̱ye?” Mukama aamukuukamu ati, “Haabwa bantu maku̱mi̱ anaa bahi̱ki̱li̱i̱ye aba, tanku̱ki̱hwelekeeleli̱ya.” ");
INSERT INTO tlj_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Niibuwo Ebbulahi̱mu̱ aaghi̱li̱ye ati, “Gutu Mukama wanje, otakwatuwa ki̱i̱ni̱gha haabwa ku̱ku̱bu̱u̱li̱ya nti, buuye nuwasangi̱yemu bantu maku̱mi̱ asatu abahi̱ki̱li̱i̱ye?” Mukama aamukuukamu ati, “Ninaanasangi̱yemu bantu maku̱mi̱ asatu bahi̱ki̱li̱i̱ye tanku̱hwelekeeleli̱ya kibugha eki bbaa.” ");
INSERT INTO tlj_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ebbulahi̱mu̱ aatodha aaghila ati, “Mukama wanje, onganile, tandi na bu̱toki̱ bwa kuukala ni̱nku̱bu̱u̱li̱ya, bhaatu buuye okukola oti̱ya nuwaanasangi̱yemu bantu maku̱mi̱ abili bonkaha abahi̱ki̱li̱i̱ye?” Mukama aamukuukamu ati, “Haabwa bantu maku̱mi̱ abili bahi̱ki̱li̱i̱ye aba, tanku̱ki̱hwelekeeleli̱ya.” ");
INSERT INTO tlj_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Niibuwo Ebbulahi̱mu̱ aaghi̱li̱ye ati, “Mukama wanje, otankwatiluwa ki̱i̱ni̱gha kutodha ku̱ku̱bu̱u̱li̱ya mulundi ghumui ghwonkaha. Ti̱ buuye nuwasangi̱yemu bantu eku̱mi̱ bonkaha abahi̱ki̱li̱i̱ye?” Mukama aamukuukamu ati, “Kutabbala kwitilamu bantu eku̱mi̱ abahi̱ki̱li̱i̱ye aba, tanku̱hwelekeeleli̱ya kibugha eki bbaa.” ");
INSERT INTO tlj_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Mukama obu aamali̱ye ku̱bu̱gha na Ebbulahi̱mu̱, aamu̱lu̱ghʼo, aaghenda. Ebbulahi̱mu̱ naye du̱mbi̱ aakuuka ewe e ka. ");
INSERT INTO tlj_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Baamalai̱ka babili aba, baaki̱dha mu kibugha kya Sodomu lwagholo. Baasanga Looti̱ asitami̱ye hʼelembo lya kibugha eki. Obu aababoone, aamuka aaghenda kubasangaana, aahi̱ka aateeli̱ya, aagomba, haali̱i̱so yee haaku̱ma hansi kubeebali̱ya. ");
INSERT INTO tlj_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Aabaghila ati, “Bakama banje, gutu hakili mwise ewanje, mutunge maasi ghaa kunaaba, niikuwo munkiya nkyambisi mweyongela kughenda mu lughendo lwanu.” Baamughila bati, “Bbaa, tukughenda kulaala hanja mu tau̱ni̱.” ");
INSERT INTO tlj_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Bhaatu Looti̱ aabaakaliilila ku̱hi̱ki̱ya obu baasi̱i̱mi̱ye baaghenda naye ewe e ka. Du̱mbi̱ Looti̱ aateeka migaati̱ etalimu ki̱tu̱mbi̱so, aateekani̱li̱ya basaasa aba kiihulo, baaliya. ");
INSERT INTO tlj_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Looti̱ na baghenu̱ be batakaghendi̱ye kulangaala, basaasa boona bʼomu kibugha kya Sodomu eki, batabhana na bantu bakulu, baasa beemilila hanja ya numba ya Looti̱. ");
INSERT INTO tlj_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Baatandika kubilikila nʼelaka lyamaani̱ bati, “Basaasa abaasi̱ye kulaala mwawe muni bali haa? Obatwesi̱ye hanja hani, tubabone niikuwo tulangaale nabo.” ");
INSERT INTO tlj_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Du̱mbi̱ Looti̱ aatuwa hanja, aaghala lwighi baghenu̱ be aba banali mu numba. ");
INSERT INTO tlj_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Aaghila basaasa bʼomu kibugha kya Sodomu aba ati, “Baghenji̱ banje mbeesengeleei̱ye, gutu mutakola kintu ki̱bhi̱i̱hi̱ye kitiyo! ");
INSERT INTO tlj_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ndi na bahala banje babili abatamani̱ye basaasa. Muleke aliibo naabaha mukole nabo byona ebi mukubbala. Bhaatu mutakola kintu kyona haa basaasa aba nanga ni baghenu̱ banje kandi ndi na kubalinda kulungi.” ");
INSERT INTO tlj_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Basaasa aba baamughila bati, “Otu̱lu̱ghʼo, oli munamahanga. Ti̱ nuuwe ani̱ kutulaghila eki tubhonganuuwe kukola! Ki̱i̱seeni̱ tukukukola kubhi kusaali̱ya ebo.” Du̱mbi̱ bantu aba baalu̱mbi̱la kimui Looti̱, mbanabbala bati bahende lwighi. ");
INSERT INTO tlj_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Bhaatu basaasa babili aba baabhakila Looti̱, baamukuba mu numba, du̱mbi̱ baaghala lwighi. ");
INSERT INTO tlj_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Du̱mbi̱ basaasa aba baaghala bantu abaabaagha haa mulyango ghwa numba ya Looti̱ oghu maaso, bantu aba baaleka kubona lwighi olu. ");
INSERT INTO tlj_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Niibuwo basaasa aba baaghi̱li̱ye Looti̱ bati, “Buuye nganda syawe syona oli nasiyo hani? Baa nkyame syawe, batabani̱ baawe, bahala baawe kedha lughanda lwawe oghu ali mu kibugha kini, obaayemu bwangu mu̱ki̱lu̱ghemu. ");
INSERT INTO tlj_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ni̱i̱tu̱we Mukama aatu̱mi̱ye kwisa ku̱hwelekeeleli̱ya kibugha kini, nanga aaboone bubhi bwa bantu bʼomu kibugha kini bwahingulaane kandi aatu̱tu̱mi̱ye ku̱ki̱hwelekeeleli̱ya.” ");
INSERT INTO tlj_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Du̱mbi̱ Looti̱ aaghenda aaghambila bankyame siye, abaali balu̱ghi̱ye bahala be mbabbala kubaswela. Aabaghila ati, “Mwanguwe bwangu, mu̱lu̱ghe mu kibugha kini, nanga Mukama alimaghenda ku̱ki̱hwelekeeleli̱ya!” Bhaatu baa nkyame siye aba ebo baamanya bati niibuwo aasandaala kwonkaha. ");
INSERT INTO tlj_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Obu bwile bwali buli haai kukiya, baamalai̱ka aba baaghila Looti̱ bati, “Uwe na mukali̱ waawe na bahala baawe babili aba oli nabo hani, mu̱lu̱ghe bwangu mu kibugha kini. Mutaalu̱ghi̱yemu, Mukama ngoku alimahwelekeeleli̱ya kibugha kini, naanu mu̱ku̱kwi̱lamu.” ");
INSERT INTO tlj_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Bhaatu Looti̱ eye aakala anaamiliiye hanja haala. Haabwa Mukama kumughilila kisa, aalaghila baamalai̱ka aba, baakwata Looti̱, bahala be babili, hamui na mukali̱ wee haa mukono baabatwesi̱ya mu kibugha eki. ");
INSERT INTO tlj_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Makabatwesi̱yamu bati, omui mu baamalai̱ka aba aabaghila ati, “Mu̱li̱gi̱ti̱le kimui niikuwo mutaku̱wa. Mutalola enu̱ma kandi muteemilila mu kiigbete eki! Mughendele kimui mu mwena, nanga naanu mu̱ku̱wa!” ");
INSERT INTO tlj_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Bhaatu Looti̱ aamughila ati, “Gutu! Bbaa, bakama banje, mutaghila muti ngende mu myena eghi. ");
INSERT INTO tlj_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ngoku mwakangiliiye ngughuma kandi kisa kyamaani̱ ku̱ki̱li̱ya bwomi̱i̱li̱ bwanje, mutaghila muti niilukile mu mwena, nkubona-bonela eghi kandi nkwi̱leyo. ");
INSERT INTO tlj_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Haliyo hani kaatau̱ni̱ kaanabwana haai-haai aka nanguulukilamu, hakili muleke haaliiko naaghenda kuukalamu niikuwo niikale ndi kulungi.” ");
INSERT INTO tlj_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Malai̱ka oghu aamukuukamu ati, “Eki kisemeeye. Oghende ookale mu kaatau̱ni̱ aka, ti̱ haabwawe tanku̱kahwelekeleeli̱ya bbaa. ");
INSERT INTO tlj_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Bhaatu oli̱gi̱te, oghende mu kaatau̱ni̱ aka bwangu, nanga tankukola kintu kyona otakaki̱dhi̱ye mu kaatau̱ni̱ aka bbaa.” Niikiyo kyaleki̱ye haanu̱ma kaatau̱ni̱ aka baakaghilamu Joola. Ekikumani̱i̱si̱ya kaanabwana, nanga Looti̱ akaghila ati nkaanabwana. ");
INSERT INTO tlj_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Nkyambisi hambali musana ghutwela haala Looti̱ akaba naaki̱dhi̱ye mu kaatau̱ni̱ aka. ");
INSERT INTO tlj_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Du̱mbi̱ Mukama aasindika mulilo ku̱lu̱gha mu eghulu ghwaghuwa mu kibugha kya Sodomu na kya Gomola nga mbu̱la ekutoonamu. ");
INSERT INTO tlj_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Aahwelekeeleli̱ya bibugha byʼomu kiigbete ebi byombi, bantu boona hamui na biti na bi̱si̱ngo ebyabaagha mu bibugha ebi byona byahiya. ");
INSERT INTO tlj_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Bhaatu mukaa Looti̱ aalola enu̱ma, du̱mbi̱ aafooka mpaghi ya kisula. ");
INSERT INTO tlj_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Nkyambisi ya kilo eki kyonini, Ebbulahi̱mu̱ aakeelela hambali aabaabaagha aamiliiye mu maaso ghaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Aalola eku̱wa mu kighona mu kibugha kya Sodomu na kya Gomola, aabona mwi̱ka ghwamaani̱ ngucuukila mu kyalo eki, nga mwi̱ka ghwa kikoome kyamaani̱ kya mulilo. ");
INSERT INTO tlj_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Obu Luhanga aahwelekeeleli̱yagha bibugha byʼomu kiigbete ebi, aakala anaasu̱ki̱ye eki aalaghi̱i̱sani̱i̱je Ebbulahi̱mu̱. Kyaleka aaya Looti̱ mu kabhi kaa kuhwelekeelela obu aahwelekeeleli̱yagha bibugha hambali Looti̱ aabaagha aakaaye. ");
INSERT INTO tlj_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Looti̱ na bahala be babili, boobaha kuukala mu kaatau̱ni̱ kaa Joola, baalu̱ghamu baaghenda kuukala mu mwena mu ki̱i̱na kyʼebaale. ");
INSERT INTO tlj_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Kilo kimui, muhala wa Looti̱ wʼobukulu aaghila muto wee ati, “Eseetu̱we aakaakuuye. Kandi mu kyalo kini kyona eki tulimu, taaliyo musaasa nʼomui oghu angutuswela, naawe omani̱ye munsi eni ngoku mukali̱ ali na kusweluwa. ");
INSERT INTO tlj_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Oleke tuhe eseetu̱we oghu vi̱i̱ni̱ aghinuwe atamiile, niikuwo alangaale naatu, atu̱byalʼo baana, ntu̱la yaatu etahuwʼo.” ");
INSERT INTO tlj_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Mukilo ya kilo eki baaleetela esebo vi̱i̱ni̱, aaghinuwa, aatamiila. Muhala wee wʼobukulu aataha, aalangaala naye. Looti̱ oghu aalangaala na muhala wee oghu. Haabwa kutamiila, esebo ataamanya ngoku aalangaaye na muhala wee oghu. ");
INSERT INTO tlj_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Kilo ekyalabhi̱yʼo muhala wee wa bukulu aaghila muto wee ati, “Eso naalangaaye na eseetu̱we. Oleke obwalo mukilo tutodhe tumuhe vi̱i̱ni̱ aghinuwe atamiile. Naawe oghende olangaale naye, niikuwo tu̱byale baana ku̱lu̱gha mwa eseetu̱we, ntu̱la yaatu etahuwʼo.” ");
INSERT INTO tlj_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Nahabweki mukilo eghi baaha dhee esebo vi̱i̱ni̱, aaghinuwa, aatamiila, muhala wee wʼobuto aataha, aalangaala naye. Haabwa kutamiila, esebo ataamanya ngoku aalangaaye na muhala wee oghu. ");
INSERT INTO tlj_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Bahala baa Looti̱ aba bombi baaku̱li̱ya. ");
INSERT INTO tlj_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Muhala wee wʼobukulu aabyala mwana wabusaasa, aamuluka li̱i̱na Mowaabu. Niiye taata wa ntu̱la eghi bilo bini bakughilaghamu Bamowaabu. ");
INSERT INTO tlj_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Muhala wee wʼobuto aabyala mwana wabusaasa, aamuluka li̱i̱na Bbenaami̱. Niiye taata wa ntu̱la eghi bakughilaghamu Bamooni̱. ");
INSERT INTO tlj_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Du̱mbi̱ Ebbulahi̱mu̱ aalu̱gha mu kyalo kya Mami̱le, aaghenda kuukala mu elungu lya Negeebbu mu kyalo eki baaghilaghamu Gelaali̱ ekili haagati ya Kadesi̱ na Suula. ");
INSERT INTO tlj_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Analiyeyo, Ebbulahi̱mu̱ aaghila bantu boona ati mukali̱ wee Saala ni mwani̱na wee. Du̱mbi̱ Abbi̱meleeki̱ mukama wa Gelaali̱ aatuma kumutwalila Saala mu kikaali kiye. ");
INSERT INTO tlj_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Bhaatu kilo eki kyonini, Luhanga aabonekela Abbi̱meleeki̱ mu ndooti̱, amughila ati, “Uwe obhonganuuwe ku̱ku̱wa, nanga mukali̱ oghu waatwete ni mukali̱ wa baanini.” ");
INSERT INTO tlj_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abbi̱meleeki̱ akaba atakakolangaane naye. Du̱mbi̱ aamukuukamu ati, “Mukama wanje, buuye okubbala ku̱mpwelekeeleli̱ya kuni ntali na musango? ");
INSERT INTO tlj_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ebbulahi̱mu̱ eenini, taaniiye akaghila ati Saala ni mwani̱na wee kandi Saala naye aaghila ati Ebbulahi̱mu̱ ni mwani̱na wee? Kini tanaaki̱koli̱ye nkighendeleeye kusaali̱ja muunakyanje bbaa. Si̱ye tandi na musango ghwona.” ");
INSERT INTO tlj_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Mu ndooti̱ eghi, Luhanga aamukuukamu ati, “Nkimani̱ye ngoku otali na musango. Eki niikiyo kyaleki̱ye ntaku̱si̱i̱mi̱lani̱ya kukola nsobi̱ mu maaso ghanje kandi ntaku̱si̱i̱mi̱lani̱ya kuba na mukali̱ oghu. ");
INSERT INTO tlj_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Nahabweki oku̱u̱ki̱li̱ye mukali̱ oghu bali̱i̱ wee, alakusabila nanga ni mulangi̱. Bhaatu otaamu̱ku̱u̱ki̱li̱ye ye, okimanye uwe nʼeka yaawe yoona mu̱ku̱twi̱ka.” ");
INSERT INTO tlj_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Nkyambisi ya kilo ekyalabhi̱yʼo, Abbi̱meleeki̱ aabilikila bakoli̱ be boona, aabasoboolola ebyamulehukaanʼo byona. Obu baaghu̱u̱ye, boobahila kimui. ");
INSERT INTO tlj_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Du̱mbi̱ Abbi̱meleeki̱ aabilikila Ebbulahi̱mu̱ mu numba, aamu̱bu̱u̱li̱ya ati, “Waatu̱koli̱ye otiyo nangaaki? Ni nsobi̱ ki eghi naaku̱koli̱ye kundeeteleja musango ghuunamu̱li̱to ghutiyo, si̱ye hamui na bukama bwanje bwona? Wankoli̱ye kintu eki muntu atabhonganuuwe kukola muunakiye.” ");
INSERT INTO tlj_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abbi̱meleeki̱ aatodha aabu̱u̱li̱ya Ebbulahi̱mu̱ ati, “Nkiki ekyaleki̱ye waakola kintu ngʼeki?” ");
INSERT INTO tlj_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ebbulahi̱mu̱ aamukuukamu ati, “Nkaba nimani̱ye nti bantu bʼeni taboobahi̱ye Luhanga kandi neeli̱li̱kana nti basobola kunjita haabwa mukali̱ wanje niikuwo bo bamuswele. ");
INSERT INTO tlj_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Majima kuwo, eye ni mwani̱naasi̱ye, nanga eseetu̱we nʼomui, kuuyʼo twataane bwani̱na, nankabha ali mukali̱ wanje. ");
INSERT INTO tlj_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Obu Luhanga anji̱hi̱ye ewaa tita, nantwala mu kyalo kinji ekitali kyʼewaatu, nkeesengeleli̱ya Saala nti, ‘Kini niikiyo kikoluwa kya ngughuma eki obhonganuuwe kukola, hoona hambali tulakahi̱kagha, oghilaghe bantu baayo oti, “Musaasa oghu ni mwani̱naasi̱ye.” ’ ” ");
INSERT INTO tlj_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Du̱mbi̱ Abbi̱meleeki̱ aaleeta ntaama, mbu̱li̱, nte, hamui na basyana baabukali̱ na baabusaasa, aabaha Ebbulahi̱mu̱, aatodha amu̱ku̱u̱ki̱li̱ya mukali̱ wee Saala. ");
INSERT INTO tlj_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abbi̱meleeki̱ aatodha aamughila ati, “Olole kyalo kyanje eki kyona, ookale hambali okabbali̱ye.” ");
INSERT INTO tlj_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Abbi̱meleeki̱ aaghila Saala ati, “Nkuha mu̱ghenji̱ waawe oghu bi̱twi̱ke lu̱ku̱mi̱ bya siliva mu maaso ghaa bantu bani boona kusasula nsobi̱ yoona eghi ndaba nku̱sobeleei̱ye.” ");
INSERT INTO tlj_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Du̱mbi̱ Ebbulahi̱mu̱ aasabila Abbi̱meleeki̱, Luhanga aaki̱li̱ya mukali̱ wee, hamui na basyana be baabukali̱, baatodha baatandika ku̱byala. ");
INSERT INTO tlj_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Nanga Mukama akaba naamali̱ye kufoola bakali̱ baa mu lu̱byalo lwa Abbi̱meleeki̱ kuba ngumba, haabwa Saala mukali̱ wa Ebbulahi̱mu̱. ");
INSERT INTO tlj_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Mukama aaghilila Saala ngughuma, aahi̱ki̱i̱li̱li̱ya ebi aamughambiiye ngoku aali asangu̱u̱we amulaghi̱i̱sani̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Saala aaku̱li̱ya etundu, aabyalila Ebbulahi̱mu̱ mu bukaakulu buwe mwana wabusaasa. Kini kikabʼo haa bwile bwonini obu Luhanga aasangu̱u̱we abalaghi̱i̱sani̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Du̱mbi̱ Ebbulahi̱mu̱ aaluka mwana wabo oghu li̱i̱na ati niiye I̱saka. ");
INSERT INTO tlj_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Obu mwana oghu aahi̱ki̱i̱ye bilo munaanaa, Ebbulahi̱mu̱ aamusala kusighikila ngoku Luhanga aalaghiiye. ");
INSERT INTO tlj_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Bwile obu, Ebbulahi̱mu̱ akaba ali na myaka 100. ");
INSERT INTO tlj_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Du̱mbi̱ Saala aaghila ati, “Luhanga aaleki̱ye naadheedhuwa. Kandi oghu alakaaghu̱wagha ngoku naabyaye, naye aladheedhuwagha hamui nanje, haabwa mukaakulu nganje ku̱byala.” ");
INSERT INTO tlj_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Aatodha aaghila ati, “Ni ani̱ angu̱gu̱bhi̱ye kughambila Ebbulahi̱mu̱ ati nanje Saala nangugubha kwonki̱ya mwana? Olole, naamu̱byaliiye mwana wabusaasa mu bukaakulu buwe.” ");
INSERT INTO tlj_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","I̱saka oghu aakulila kimui, du̱mbi̱ baamuuya haa mabeele. Haa kilo eki baamuuhiyʼo eki, Ebbulahi̱mu̱ aamukolela ki̱ghenu̱ kyamaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Kilo kimui, Saala aabona Sumai̱li̱, mutabani̱ wa Hagali̱ mu̱syana wabo Munami̱si̱li̱ oghu abyaliiye Ebbulahi̱mu̱, nendi̱ya I̱saka. ");
INSERT INTO tlj_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Niibuwo Saala aaghi̱li̱ye Ebbulahi̱mu̱ ati, “Obhinge mukali̱ mu̱syana waawe oghu hamui na mutabani̱ wee. Mutabani̱ wee oghu taaligwetuwa hamui na mutabani̱ wanje haa bintu byawe bbaa.” ");
INSERT INTO tlj_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Kintu eki kyatu̱ntu̱li̱ya Ebbulahi̱mu̱ munu, nanga Sumai̱li̱ naye akaba ali mwana wee. ");
INSERT INTO tlj_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Bhaatu Luhanga aaghila Ebbulahi̱mu̱ ati, “Oleke kutuntula haabwa Sumai̱li̱ na mu̱syana waawe. Kandi okole ngoku Saala aakughambiiye, nanga baana baa I̱saka bonkaha niibo nkubala kuba baasukulu baawe. ");
INSERT INTO tlj_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Na mutabani̱ wa mu̱syana waawe oghu, naye nkumuha baana bakani̱ye niikuwo naye afooke ehanga liinamu̱li̱to, nanga naye ni mwana waawe.” ");
INSERT INTO tlj_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Nkyambisi ya kilo ekyalabhi̱yʼo, Ebbulahi̱mu̱ aatwala byokuliya hamui na ki̱cu̱pa kilimu maasi, aabiha Hagali̱, aamu̱heeki̱ya biyo, du̱mbi̱ aamubhinga hamui na mwana wee. Hagali̱ aaghenda kitiyo-kitiyo mu elungu lya Bbeli̱seba. ");
INSERT INTO tlj_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Haanu̱ma ya bwile, maasi ghaahuwa mu ki̱cu̱pa omu. Obu maasi agha ghaahooye, aaghenda aabi̱sa mwana oghu mu kahu̱mbu̱. ");
INSERT INTO tlj_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Du̱mbi̱ aaghenda aasitama haakpengbu̱, haa mutima ghuwe naanaghila ati, “Tambbali̱ye kubona ngoku mwana wanje aku̱ku̱wa bbaa.” Anasitami̱ye haala, du̱mbi̱ aatandika kulila. ");
INSERT INTO tlj_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Luhanga aaghu̱wa mwana naalila, du̱mbi̱ malai̱ka aabilikiilila Hagali̱ ku̱lu̱gha mu eghulu, aamu̱bu̱u̱li̱ya ati, “Mbiki, Hagali̱? Oleke kwobaha! Luhanga aaghu̱u̱ye kulila kwa mwana waawe hambali waamulangaai̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ohimbe mwana waawe, omulele, nanga ndimufoola ehanga lyamaani̱.” ");
INSERT INTO tlj_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Du̱mbi̱ Luhanga aamwoleka kyahu̱dhu̱ kya maasi. Aaghenda aataha maasi, aaghaasu̱li̱ya mu ki̱cu̱pa eki aahekelaghamu, du̱mbi̱ aatandika ku̱nwesi̱yʼo mwana oghu. ");
INSERT INTO tlj_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Luhanga aalinda mwana oghu, aakula. Aakulila mu elungu, du̱mbi̱ aafooka wamaani̱ mu kuhiigha. ");
INSERT INTO tlj_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Anali mu elungu lya Palaani̱, ni̱na wee aamuswelela mukali̱ ku̱lu̱gha mu ntu̱la ya Banami̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Bwile obu, Abbi̱meleeki̱ hamui na Fi̱kooli̱ mukulu wa baasilikale be, baaghambila Ebbulahi̱mu̱ bati, “Luhanga akuukalagha naawe mu bu̱li̱ kintu kyona eki okukolagha. ");
INSERT INTO tlj_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Dhelu nkubbala olahile mu maaso ghaa Luhanga ngoku otalikola kintu kyona kya bisubha mu maaso ghanje, si̱ye neenini, batabani̱ banje kedha baasukulu banje. Kandi ongilile ngughuma hamui na bantu aba ookaayemu nga munamahanga, ngʼesi naakughiliiye.” ");
INSERT INTO tlj_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ebbulahi̱mu̱ aamukuukamu ati, “Majima nkulahila mu li̱i̱na lya Luhanga nti niikuwo kiliba kitiyo.” ");
INSERT INTO tlj_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Du̱mbi̱ Ebbulahi̱mu̱ aatandika kutongana na Abbi̱meleeki̱ haabwa kyahu̱dhu̱ eki baheeleli̱ya baa Abbi̱meleeki̱ baahi̱yʼo Ebbulahi̱mu̱. ");
INSERT INTO tlj_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abbi̱meleeki̱ aamukuukamu ati, “Si̱ye tanimani̱ye oghu aakoli̱ye kintu ngʼeki. Nanga taawangambiiye bwangu, kintu eki nanje naakimanya obwalo.” ");
INSERT INTO tlj_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Niibuwo Ebbulahi̱mu̱ aaleeti̱ye ntaama hamui na nte aasiha Abbi̱meleeki̱, du̱mbi̱ basaasa babili aba baakola ndaghaano. ");
INSERT INTO tlj_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ebbulahi̱mu̱ aata haakpengbu̱ byana bya ntaama musanju̱ byabukali̱, ");
INSERT INTO tlj_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","du̱mbi̱ Abbi̱meleeki̱ aabu̱u̱li̱ya Ebbulahi̱mu̱ ati, “Mughaso ghwa byana bya ntaama ebi waataaye haakpengbu̱ ebi mbiki?” ");
INSERT INTO tlj_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ebbulahi̱mu̱ aamukuukamu ati, “Nkukusaba osi̱i̱me byana bya ntaama musanju̱ ebi naakuhaaye ku̱lu̱gha mu mikono yanje kuba buukai̱so ngoku aani̱i̱si̱ye nkalima kyahu̱dhu̱ kini.” ");
INSERT INTO tlj_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Du̱mbi̱ ki̱i̱kalo eki baakiluka li̱i̱na lya Bbeli̱seba (elyamani̱i̱si̱yagha “kyahu̱dhu̱ kya kilahilo”). ");
INSERT INTO tlj_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Haanu̱ma ya kukola ndaghaano eghi e Bbeli̱seba, Abbi̱meleeki̱ na Fi̱kooli̱ baakuukayo mu kyalo kya Bafi̱li̱si̱ti̱. ");
INSERT INTO tlj_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Du̱mbi̱ Ebbulahi̱mu̱ aahela kiti kya bukalali̱ya e Bbeli̱seba, aalami̱li̱yʼo Mukama, Luhanga oghu ataakuhuwaghʼo. ");
INSERT INTO tlj_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ebbulahi̱mu̱ aakala mu kyalo kya Bafi̱li̱si̱ti̱ kumala bwile bukani̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Haanu̱ma yʼebi, Luhanga aalengeesi̱ya Ebbulahi̱mu̱ niikuwo alole ku̱hi̱ki̱li̱ja kuwe. Aamubilikila ati, “Ebbulahi̱mu̱!” Ebbulahi̱mu̱ aamukuukamu ati, “Ndi hani.” ");
INSERT INTO tlj_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Du̱mbi̱ Luhanga aamughila ati, “Otwale mwana waawe I̱saka oghu oli naye enkaha kandi oghu oku̱ndi̱ye kwonini otiyo, mughende naye mu kyalo kya Moli̱ya. Omuhonge nga kihonguwa kyona kyokeei̱ye haa mwena oghu nkukughambila.” ");
INSERT INTO tlj_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Nkyambisi ya kilo ekyongeyʼo, Ebbulahi̱mu̱ aamuka hamui na baheeleli̱ya be babili, ndogooi̱ yee, hamui na mwana wee I̱saka. Aaseena nkui sikani̱ye sya kwokeesi̱ya kihonguwa kiye, du̱mbi̱ aamu̱ki̱ya kughenda mu ki̱i̱kalo eki Luhanga aamughambiiye. ");
INSERT INTO tlj_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Haa kilo kyakasatu mbanaghenda, Ebbulahi̱mu̱ aakebuka elughulu, aabona ki̱i̱kalo eki baaghendaghamu eki kinaseli̱yeyo. ");
INSERT INTO tlj_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Du̱mbi̱ Ebbulahi̱mu̱ aaghila baheeleli̱ya be ati, “Mu̱ti̱ghale hani na ndogooi̱ eghi niikuwo si̱ye na mutabani̱ wanje tughende tu̱hi̱ke mu ki̱i̱kalo eki. Tughende tulami̱ye Luhanga, du̱mbi̱ tutodhe tukuuke.” ");
INSERT INTO tlj_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ebbulahi̱mu̱ aaheeki̱ya mutabani̱ wee I̱saka nkui, eye eenini aaheeka muhiyo na mulilo ghwa kwokeesi̱ya kihonguwa, du̱mbi̱ baadonga bombi. ");
INSERT INTO tlj_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Banadongi̱ye hamui, I̱saka aabu̱u̱li̱ya ese wee ati, “Tita!” Ebbulahi̱mu̱ aamukuukamu ati, “Wangi̱, mwana wanje?” I̱saka aatodha aaghila ati, “Tu̱heeki̱ye nkui na mulilo, bhaatu kyana kya ntaama eki tu̱kwoki̱ya mahonga, kili haa?” ");
INSERT INTO tlj_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ebbulahi̱mu̱ aamukuukamu ati, “Mwana wanje, Luhanga eenini akutuha kyana kya ntaama kya kuhonga.” Du̱mbi̱ beeyongela kughenda. ");
INSERT INTO tlj_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Obu baaki̱dhi̱ye hambali Luhanga aabaagha amughambiiye, Ebbulahi̱mu̱ aakwelʼo kyakuhongelʼo bihonguwa, aapangʼo nkui, du̱mbi̱ aaboha mutabani̱ wee I̱saka, aamulangaali̱ya haagu̱u̱li̱ ya nkui esi. ");
INSERT INTO tlj_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Du̱mbi̱ Ebbulahi̱mu̱ aakoma muhiyo ghuwe ati asale mutabani̱ wee oghu. ");
INSERT INTO tlj_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Naanabbala kumusala haa mumelo, malai̱ka wa Mukama ku̱lu̱gha mu eghulu aamubilikila naaghila ati, “Ebbulahi̱mu̱! Ebbulahi̱mu̱!” Ebbulahi̱mu̱ aakuukamu ati, “Ndi hani.” ");
INSERT INTO tlj_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Malai̱ka aamughila ati, “Otaata mwana waawe kandi otamukolʼo kabhi koona, nanga naamali̱ye kubona ngoku ohu̱ti̱i̱ye Luhanga. Tawaakukutiiye kumpa mwana waawe oghu oli naye enkaha bhembei̱.” ");
INSERT INTO tlj_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ebbulahi̱mu̱ aamu̱ki̱ya maaso ghe, du̱mbi̱ aabona ntu̱u̱li̱ ya ntaama, mahembe ghaayo ghakwatu̱u̱we mu bi̱si̱ngo. Du̱mbi̱ aaghenda aghisambuula, aaghihongela Mukama nga kihonguwa kyona kyokeei̱ye mu ki̱i̱kalo kya mwana wee. ");
INSERT INTO tlj_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Du̱mbi̱ Ebbulahi̱mu̱ aaluka ki̱i̱kalo eki li̱i̱na ati niikiyo “Mukama niiye akuhaagha.” Ku̱lu̱gha na bwile obu, baaghila bati, “Mukama alahaagha bantu be haa mwena ghuni.” ");
INSERT INTO tlj_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Malai̱ka wa Mukama aatodha aabilikiilila Ebbulahi̱mu̱ mulundi ghwa kabili. ");
INSERT INTO tlj_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Aamughila ati, “Mukama aaghi̱li̱ye ati, ‘Wantaayemu ki̱ti̱i̱ni̱sa kandi tawaakukutiiye mwana waawe kandi oghu oli naye enkaha. ");
INSERT INTO tlj_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Majima kuwo, nkukuha mu̱gi̱sa, lu̱byalo lwawe na baasukulu baawe bakukanila kimui nga nsooli̱ya sya mu mwanya na musene ghwa ki̱si̱yo kya nanja. Baasukulu baawe balitwala etungo lya ngi̱ghu̱ syabo. ");
INSERT INTO tlj_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Kandi mu baasukulu baawe niimuwo nkuheela mahanga ghaa munsi yoona mu̱gi̱sa, nanga waadhooteeye elaka lyanje.’ ” ");
INSERT INTO tlj_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Du̱mbi̱ Ebbulahi̱mu̱ aakuuka mu basyana be, baamu̱ki̱li̱ya hamui, baaghenda Bbeli̱seba hambali Ebbulahi̱mu̱ aakalagha. ");
INSERT INTO tlj_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Haanu̱ma yʼebi, Ebbulahi̱mu̱ aaghu̱wa ati naali siye Milika, muka waani̱na wee Naholi̱, akamu̱byalila baana baabusaasa. ");
INSERT INTO tlj_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Mwana wa mu̱li̱ghaaso niiye akaba ali U̱ji̱, waakabili Bbu̱ji̱, na Kamweli̱ (ese wa Alaamu), ");
INSERT INTO tlj_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Keseedi̱, Hajo, Pilidaasi, Jidilaafi̱, hamui na Bbesweli̱. ");
INSERT INTO tlj_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bbesweli̱ niiye akaba ali ese wa Lebbeeka. Milika niiye akabyalila Naholi̱ waani̱na Ebbulahi̱mu̱ baana munaanaa aba. ");
INSERT INTO tlj_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Naholi̱ akaba ali na mukali̱ onji li̱i̱na liye Leuma, naye akaba ali na baana. Mali̱i̱na ghaabo: Teebba, Gahama, Tahasi, hamui na Maaka. ");
INSERT INTO tlj_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saala aamala myaka 127 ya bukulu. ");
INSERT INTO tlj_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Akwi̱la mu kyalo kya Ki̱li̱yasa-alaba, endindi ekimanu̱u̱we nga Hebbu̱looni̱, ekili mu nsi ya Kanaani̱. Eghi niiyo Ebbulahi̱mu̱ eeghungiiye mukali̱ wee Saala oghu. ");
INSERT INTO tlj_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Du̱mbi̱ Ebbulahi̱mu̱ aalu̱gha haa mu̱ku̱ ghwa mukali̱ wee, aaghenda ku̱bu̱gha na bakulu baa mu ntu̱la ya Bahi̱ti̱ ati, ");
INSERT INTO tlj_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Si̱ye ndi mu̱ku̱lu̱ki̱ mu kyalo kyanu muni. Gutu mu̱ngu̱li̱ye etaka hambali ndajiika mukali̱ wanje mu mulingo ghusemeeye.” ");
INSERT INTO tlj_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Mukulu wa Bahi̱ti̱ aakuukamu Ebbulahi̱mu̱ bati, ");
INSERT INTO tlj_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Otegheeleli̱ye, mukama wanje, oli muntu bahu̱ti̱i̱ye mu kyalo muni. Weekomele weenini ki̱i̱kalo kisemeeye haliyo waajiika mukali̱ waawe. Taaliyo muntu nʼomui oghu akugubha kubhenga kukukoonela mu kijibu ngʼeki bbaa.” ");
INSERT INTO tlj_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Du̱mbi̱ Ebbulahi̱mu̱ aamuka, aagomba ku̱si̱i̱ma Bahi̱ti̱, bantu abaabaagha mu kyalo eki. ");
INSERT INTO tlj_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Aabaghila ati, “Ngoku mwasi̱i̱mi̱ye kunkoonela, mbeesengeleei̱ye gutu mu̱mbu̱ghi̱lane na Efu̱looni̱, mutabani̱ wa Johali̱, ");
INSERT INTO tlj_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","angu̱li̱ye ki̱i̱na kyʼebaale, elili mu musili ghuwe oghuli Macepela. Nkumusasuulila haa bbei̱ yoona ya musili oghu kandi hambali baakai̱so bali, niikuwo nanje ntunge ki̱i̱kalo eki ndajiikaghamu bantu banje.” ");
INSERT INTO tlj_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efu̱looni̱ eye, akaba asitami̱ye mu ki̱bbu̱la kya Bahi̱ti̱ abaabaagha haa mulyango ghwa kibugha eki, du̱mbi̱ aakuukamu Ebbulahi̱mu̱ banategheleei̱ye. Aamughila ati, ");
INSERT INTO tlj_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Bbaa mukama wanje, ontegheeleli̱ye. Nkukuha musili ghwona na ki̱i̱na kyʼebaale ekilimu mu maaso ghaa bantu banje boona. Kandi naakuheeleeye ghuwo busa, oghende ojiikaghemu bantu baawe.” ");
INSERT INTO tlj_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ebbulahi̱mu̱ aatodha aagomba hansi, eebali̱ya bataka baa mu kyalo eki, ");
INSERT INTO tlj_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","aakuukamu Efu̱looni̱ na bantu boona banategheleei̱ye ati, “Bbaa, nkusaba oleke ngule musili oghu bbei̱ eghi ghubhonganuuwe, niikuwo njiikaghemu bantu banje baku̱u̱ye.” ");
INSERT INTO tlj_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efu̱looni̱ aakuukamu Ebbulahi̱mu̱ ati, ");
INSERT INTO tlj_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Mukama wanje ontegheeleli̱ye. Musili oghu ghubhonganuuwe bi̱twi̱ke 400 bya siliva. Bhaatu ninaaku̱ghu̱li̱i̱ye ghuwo, takikwoleka bu̱u̱bhootu̱ bbaa. Uwe oghende mu maaso, ojiike mukali̱ waawe oghu aaku̱u̱ye.” ");
INSERT INTO tlj_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Du̱mbi̱ Ebbulahi̱mu̱ aasi̱i̱ma bbei̱ ya Efu̱looni̱ eghi aamulamuuye, baapi̱i̱ma bi̱twi̱ke 400 bya siliva, kusighikila haa ki̱pi̱i̱mo kya mu katale, bantu bakulu baa Bahi̱ti̱ baaba baakai̱so baa bughulaani̱ obu. ");
INSERT INTO tlj_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Du̱mbi̱ Ebbulahi̱mu̱ aaghula musili ghwa Efu̱looni̱, mu kyalo kya Macepela, haai-haai na Mami̱le. Aaghulilamu ki̱i̱na kilimu ebaale na biti byona ebyali bikilimu. ");
INSERT INTO tlj_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Musili oghu ghwafooka kuba ghuwe, nanga akaghughula mu maaso ghaa bakulu baa Bahi̱ti̱ haa mulyango ghwa tau̱ni̱ yabo. ");
INSERT INTO tlj_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Du̱mbi̱ Ebbulahi̱mu̱ aajiika mukali̱ wee Saala mu kyalo kya Kanaani̱, mu ki̱i̱na kyʼebaale mu Macepela, haai-haai na Mami̱le, eghi emanu̱u̱we nga Hebbu̱looni̱. ");
INSERT INTO tlj_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Du̱mbi̱ musili oghu na ki̱i̱na kyʼebaale ebyali bili bya Bahi̱ti̱ byaba eli̱mbe Ebbulahi̱mu̱, hambali alajiikagha bantu be. ");
INSERT INTO tlj_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ebbulahi̱mu̱ akaba amali̱ye kukaakulila kimui kandi Mukama amali̱ye kumuha mu̱gi̱sa mu bu̱li̱ kintu kyona. ");
INSERT INTO tlj_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Kilo kimui, Ebbulahi̱mu̱, aaghambila mu̱heeleli̱ya wee, mukulu wa baheeleli̱ya be, oghu akaba alemi̱ye bu̱li̱ kintu kyona eki baabaagha nakiyo ati, “Ote ngalo yaawe hansi ya kibelo kyanje. ");
INSERT INTO tlj_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Kandi nkubbala olahile mu maaso ghaa Mukama Luhanga wʼomu eghulu na munsi oti, tooliswelela mutabani̱ wanje mukali̱ ku̱lu̱gha mu bahala baa Banakanaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Bhaatu olighenda mu nsi yʼewaatu kandi mu nganda syanje, haaliiyo waahila mutabani̱ wanje I̱saka mukali̱.” ");
INSERT INTO tlj_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Mu̱heeleli̱ya oghu aabu̱u̱li̱ya Ebbulahi̱mu̱ ati, “Ti̱ ninaabooneyo mukali̱ oghu atabbali̱ye kwisa mu kyalo eki tulimu kini, buuye du̱mbi̱ ntwale mutabani̱ waawe I̱saka aghende aakale mu nganda syawe na hambali waalu̱ghi̱ye?” ");
INSERT INTO tlj_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ebbulahi̱mu̱ aamukuukamu ati, “Bbaa! Kandi weelinde, otalitwala eghi mutabani̱ wanje. ");
INSERT INTO tlj_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Nanga Mukama Luhanga wʼomu eghulu, oghu akanjiya ewaa tita kandi munsi yʼewaatu, akandaghi̱i̱sani̱ya kandi aalahila naaghila ati aliha nsi eni yoona baasukulu banje. Aatodha aaghila ati, alituma malai̱ka ewaawe, niikuwo oswelele mutabani̱ wanje mukali̱ ku̱lu̱gha mu nganda syanje. ");
INSERT INTO tlj_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Mukali̱ oghu obu alikabhenga kwisa naawe, oliba otahendi̱ye ndaghaano yaatu eni. Bhaatu hatalibʼo nsonga yoona eghi elileka otwale mutabani̱ wanje hambali naalu̱ghi̱ye.” ");
INSERT INTO tlj_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Du̱mbi̱ mu̱heeleli̱ya oghu aalahila anataaye ngalo yee hansi ya kibelo kya Ebbulahi̱mu̱, nʼelaghi̱i̱sani̱ya na ngoku akukola byona ebi Ebbulahi̱mu̱ aamulaghiiye. ");
INSERT INTO tlj_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Du̱mbi̱ mu̱heeleli̱ya oghu aaheeki̱ya ngamila eku̱mi̱ sya mukama wee Ebbulahi̱mu̱ bisembo bikaniiye kandi ebitembeeye kimui ebi mukama wee oghu aamuhaaye kuha mukali̱ wa mutabani̱ wee. Aamu̱ki̱ya kughenda mu kyalo li̱i̱na lyakiyo Alaamu Nahalahi̱mu̱ ekimanu̱u̱we nga kibugha Mesopotami̱ya, hambali Naholi̱ waani̱na Ebbulahi̱mu̱ aakalagha. ");
INSERT INTO tlj_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Aaki̱dhayo mbwabaaye lwagholo. Aalaghila ngamila kulangaala hansi haakpengbu̱ ya kyambu, hanja ya kibugha eki. Bwile obu niibuwo bakali̱ baaghi̱i̱laghamu maasi haa kyambu eki. ");
INSERT INTO tlj_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Mu̱heeleli̱ya oghu aatandika kusaba naaghila ati, “Mukama Luhanga wa mukama wanje Ebbulahi̱mu̱, gutu, onsi̱ngu̱li̱i̱si̱ye obwalo buni, onjoleke kukunda kwawe hali mukama wanje Ebbulahi̱mu̱. ");
INSERT INTO tlj_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Olole neemiliiye haakpengbu̱ ya kyambu hambali bahala baa bantu baa mu tau̱ni̱ eni baku̱ghi̱i̱lagha maasi. ");
INSERT INTO tlj_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ti̱ mwana wabukali̱ weena oghu ndakaghila nti ampe haa maasi ghe ninuwʼo, naasi̱i̱ma kandi naaseeselela ngamila syanje, oleke aliiye waaba okomeeye mu̱heeleli̱ya waawe I̱saka. Ti̱ eki nkyanabayʼo, nkughila nti waaghiliiye mukama wanje Ebbulahi̱mu̱ ngughuma syawe.” ");
INSERT INTO tlj_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Atakamali̱ye kusaba, Lebbeeka aasa aheeki̱ye munagha. Lebbeeka oghu akaba ali muhala wa Bbesweli̱, mutabani̱ wa Naholi̱ na mukali̱ wee Milika. Naholi̱ oghu akaba ali waani̱na Ebbulahi̱mu̱. ");
INSERT INTO tlj_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Mwana wabukali̱ oghu akaba asemeleeye kimui kandi atamani̱ye basaasa. Aaghenda aataha maasi, aasu̱li̱ya munagha ghuwe, du̱mbi̱ aakuuka. ");
INSERT INTO tlj_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Mu̱heeleli̱ya oni du̱mbi̱ anguwa bwangu-bwangu, aamwebinga, aamughila ati, “Gutu ompe haa maasi agha oheeki̱ye mu munagha ghwawe.” ");
INSERT INTO tlj_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Mwana wabukali̱ oghu aamukuukamu ati, “Mukama wanje maasi ngani, onuwʼo.” Du̱mbi̱ Lebbeeka aasu̱ndi̱ya munagha ghwa maasi, aamuha aanuwa. ");
INSERT INTO tlj_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Obu aamali̱ye kunuwa, aatodha aamughila ati, “Oleke ntahile na ngamila syawe maasi nasiyo sinuwe.” ");
INSERT INTO tlj_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Maasi obu ghaahooye mu munagha, mwana wabukali̱ oghu aali̱gi̱ta bwangu-bwangu haa kyambu, aataha maasi ghanji, aaghaseeselela ngamila esi, syanuwela kimui, syona syakuta. ");
INSERT INTO tlj_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Mu̱heeleli̱ya oghu aakala analoleleeye mwana wabukali̱ oghu, anaholeei̱ye, naaneeli̱li̱kana Mukama alakaba naamughiliiye ngughuma kusighikila haa kusaba kuwe. ");
INSERT INTO tlj_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Obu ngamila syamali̱ye kunuwa, du̱mbi̱ akwata mpete ya feeja ya ku̱lu̱wala mu muhuli na bikomo bibili bya feeja bya bbei̱ byaku̱lu̱wala haa mikono, aamuha biyo. ");
INSERT INTO tlj_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Aamu̱bu̱u̱li̱ya ati, “Uwe oli muhala waani̱? Gutu ongambile. Buuye so waawe angututungila kisiika kya kulaalamu obwalo?” ");
INSERT INTO tlj_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Mwana wabukali̱ oghu aamukuukamu ati, “Si̱ye ndi muhala wa Bbesweli̱, muusukulu wa Naholi̱ na Milika.” ");
INSERT INTO tlj_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Aatodha aamughila ati, “Tuli na bi̱si̱ngo hamui na biliyo bikani̱ye bya ngamila syawe kandi twaba na kisiika kya baghenu̱.” ");
INSERT INTO tlj_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Musaasa oni du̱mbi̱ aagomba hansi, aalami̱ya Mukama ");
INSERT INTO tlj_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","naanaghila ati, “Asi̱i̱mu̱we Mukama Luhanga wa mukama wanje Ebbulahi̱mu̱. Anjoleki̱ye bulungi na bwesighibuwa bwamaani̱ kandi ampi̱ki̱ya mu nganda siye syonini.” ");
INSERT INTO tlj_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Mwana wabukali̱ oni aali̱gi̱ta ewaabo e ka, du̱mbi̱ aaghambila bʼewaabo ebyalehukaane byona. ");
INSERT INTO tlj_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Lebbeeka akaba ali na mwani̱na wee li̱i̱na liye Labbaani̱. Labbaani̱ du̱mbi̱ aali̱gi̱ta kusangaana musaasa oni haa kyambu. ");
INSERT INTO tlj_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Kusighikila ngoku aali naamali̱ye kubona mpete yʼomu muhuli hamui na bikomo bya haa mikono ya mwani̱na wee kandi naaghu̱u̱ye bighambo Lebbeeka aali naabu̱ghi̱ye, aaghenda hambali musaasa oghu aabaagha. Aasanga anaamiliiye na ngamila siye haai na kyambu eki. ");
INSERT INTO tlj_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Du̱mbi̱ aamughila ati, “Wiise olaale ewaatu, uwe oghu okaheebuwa mu̱gi̱sa ku̱lu̱gha ewaa Mukama.” Aatodha aamu̱bu̱u̱li̱ya ati, “Eki̱leki̱ye oomiliiye hanja nkiki? Naamali̱ye kukughomolela ki̱i̱kalo kya ngamila syawe hamui naawe weenini.” ");
INSERT INTO tlj_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Du̱mbi̱ musaasa oni aaghenda e ka na Labbaani̱, Labbaani̱ aayʼo ngamila nku̱mba esi syali si̱heeki̱ye, aamwoleka hambali sikulaala kandi aasiha na byokuliya. Du̱mbi̱ baaleetela baheeleli̱ya baa Ebbulahi̱mu̱ aba maasi ghaa kunaaba mu maghulu, ");
INSERT INTO tlj_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","baabaleetela na byokuliya. Bhaatu mu̱heeleli̱ya oghu aaghila ati, “Tankuliya ntakabaghambiiye ebi nkubbala ku̱bu̱gha.” Du̱mbi̱ Labbaani̱ aaghila ati, “Otughambile.” ");
INSERT INTO tlj_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Du̱mbi̱ aaghila ati, “Si̱ye ndi mu̱heeleli̱ya wa Ebbulahi̱mu̱. ");
INSERT INTO tlj_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Mukama akaha mukama wanje Ebbulahi̱mu̱ mu̱gi̱sa kandi aatungila kimui. Aamuha ntaama, nte, siliva na feeja, baheeleli̱ya baabusaasa na baabukali̱, ngamila na ndogooi̱. ");
INSERT INTO tlj_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","“Ti̱ Saala mukali̱ wa mukama wanje Ebbulahi̱mu̱ aabyala mwana wabusaasa amali̱ye kukaakulila kimui kandi mwana oghu niiye aahaaye bu̱li̱ kintu kiye kyona. ");
INSERT INTO tlj_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Mukama wanje oghu akandahi̱li̱ya nangila ati ntaliswelela mutabani̱ wee mukali̱ ku̱lu̱gha mu ntu̱la ya Banakanaani̱, mu etaka hambali niikaaye. ");
INSERT INTO tlj_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","“Aatodha angila ati, ‘Oghende mu ka ya tita kandi mu katu̱la kaatu haaliiyo waaswelela mutabani̱ wanje mukali̱.’ ");
INSERT INTO tlj_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Du̱mbi̱ nanje naabu̱u̱li̱ya mukama wanje oghu nti, ‘Buuye manaabukali̱ oghu ataasi̱i̱mi̱ye kwisa nanje?’ ");
INSERT INTO tlj_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ankuukamu ati, ‘Mukama, oghu naakalagha mu maaso ghe, akukusindikila malai̱ka wee ku̱semeli̱ya lughendo lwawe, niikuwo ogubhe kutungila mutabani̱ wanje mukali̱ ku̱lu̱gha mu katu̱la kaatu kandi mu ka ya tita. ");
INSERT INTO tlj_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Du̱mbi̱ okaakughenda mu katu̱la kaatu, okuba otali na musango haa ebi waalahiiye. Noobu babhenga kukuha mukali̱ oghu, uwe okuba oosu̱li̱i̱si̱i̱ye ebi waalahiiye.’ ” ");
INSERT INTO tlj_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Mu̱heeleli̱ya oghu aatodha aaghila ati, “Obwalo obu naahi̱ki̱ye haa kyambu haala, naaghila nti, ‘Ai̱, Mukama Luhanga wa mukama wanje Ebbulahi̱mu̱, okaakuba obbali̱ye, gutu ompe mu̱gi̱sa mu lughendo luni olu naasi̱yemu. ");
INSERT INTO tlj_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Olole neemiliiye haakpengbu̱ ya kyambu kini, ti̱ kaakuba manaabukali̱ weena aasa kutaha maasi, du̱mbi̱ mbu̱gha naye nti ampe haa maasi ghe ninuwʼo, ");
INSERT INTO tlj_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","kaakuba angila ati, “Onuwʼo kandi nkutodha ntahile na ngamila syawe nasiyo sinuwe,” oleke aaliiye waaba okomeeye mutabani̱ wa mukama wanje.’ ");
INSERT INTO tlj_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Ntakamali̱ye kusaba haa mutima ghwanje, Lebbeeka aasa aheeki̱ye munagha ghuwe. Aaghenda haa kyambu kutaha maasi, du̱mbi̱ nanje naamughila nti ampe haa maasi haala ninuwʼo. ");
INSERT INTO tlj_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Du̱mbi̱ aaya munagha haa mabegha ghe aasu̱ndi̱ya, aaghila ati, ‘Onuwe kandi nkuha na ngamila syawe nasiyo sinuwe dhee.’ Du̱mbi̱ naanuwa kandi aaha na ngamila syanje. ");
INSERT INTO tlj_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Du̱mbi̱ naamu̱bu̱u̱li̱ya nti, ‘Oli muhala wa ani̱?’ Ankuukamu ati, ‘Ni muhala wa Bbesweli̱ kandi taata wanje niiye Naholi̱ na mamba niiye Milika.’ Du̱mbi̱ naamu̱lu̱wi̱ka mpete haa muhuli hamui na bikomo haa mikono. ");
INSERT INTO tlj_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Du̱mbi̱ naagomba hansi, naalami̱ya Mukama. Naasinda Mukama Luhanga wa mukama wanje Ebbulahi̱mu̱ oghu akandinda mu kihanda kandi aaleka naabonayo muusukulu wa mu̱ghenji̱ wee, oghu akasi̱i̱ma kusweluwa mutabani̱ wa mukama wanje oghu. ");
INSERT INTO tlj_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ti̱ mulakaba nimughilila mukama wanje ngughuma na bwesighibuwa, kedha mutaakumughilila siyo, mungambile, niikuwo ndole kintu kinji kya kukola.” ");
INSERT INTO tlj_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Du̱mbi̱ Labbaani̱ na Bbesweli̱ baakuukamu bati, “Etu̱we tatuli na kya kukola kyona, nanga eki ki̱lu̱ghi̱ye ewaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Olole, Lebbeeka ngughu, omutwale, aghende aabe mukali̱ wa mutabani̱ wa mukama waawe ngoku Mukama aakwoleki̱ye.” ");
INSERT INTO tlj_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Obu mu̱heeleli̱ya wa Ebbulahi̱mu̱ aaghu̱u̱ye baku̱u̱ki̱yemu batiyo, aagomba hansi, aalami̱ya Mukama. ");
INSERT INTO tlj_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Du̱mbi̱ mu̱heeleli̱ya oghu aaleeta bintu bya bbei̱ bi̱koleeu̱we mu siliva na feeja, hamui na byaku̱lu̱waala, aabiha Lebbeeka. Kandi aaha ni̱na wee hamui na mu̱ghenji̱ wee bintu bikani̱ye bya bbei̱. ");
INSERT INTO tlj_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Du̱mbi̱ mu̱heeleli̱ya oghu na bantu aba aabaagha ali nabo baaliya kandi baanuwa, du̱mbi̱ baalangaala ku̱hi̱ki̱ya bwile obu bwakeeye. Obu bwile bwakeeye, mu̱heeleli̱ya oghu aaghila ati, “Muleke nkuukeyo ewaa mukama wanje.” ");
INSERT INTO tlj_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Du̱mbi̱ mwani̱na Lebbeeka na ni̱na wee baamukuukamu bati, “Tu̱ku̱du̱bha kuukala na Lebbeeka kumala bilo eku̱mi̱, niikuwo mughende.” ");
INSERT INTO tlj_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Bhaatu musaasa oghu aabaghila ati, “Mutankeesekeleja. Mukama aamali̱ye kungilila ngughuma mu lughendo lwanje. Nahabweki muleke nkuukeyo ewaa mukama wanje.” ");
INSERT INTO tlj_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Du̱mbi̱ baaghila bati, “Oleke tu̱du̱bhe tubilikile Lebbeeka, tu̱mu̱bu̱u̱li̱ye eki akwete kweli̱li̱kana.” ");
INSERT INTO tlj_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Baabilikila Lebbeeka, baamu̱bu̱u̱li̱ya bati, “Buuye oku̱si̱i̱ma kughenda na musaasa oni?” Aabakuukamu ati, “Naasi̱i̱mi̱ye, nkughenda naye.” ");
INSERT INTO tlj_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Du̱mbi̱ baalagha Lebbeeka, baamuleka aaghenda na mu̱heeleli̱ya wa Ebbulahi̱mu̱ na bantu aba aali aasi̱ye nabo. Mukali̱ oghu akalela Lebbeeka ku̱lu̱gha mu bwana buwe, naye aaghenda amuhelekeeye. ");
INSERT INTO tlj_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Baamuha mu̱gi̱sa ghuwe obu baamulaghagha mbaghila bati, “Mwani̱naatu̱we, Mukama akuhe mu̱gi̱sa, obyale baana bakaniiye kimui. Baasukulu baawe, batwalaghe etungo lya ngi̱ghu̱ syabo.” ");
INSERT INTO tlj_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Du̱mbi̱ Lebbeeka na baheeleli̱ya be baabukali̱ baani̱na ngamila, baaghenda na musaasa oghu. Nahabweki mu̱heeleli̱ya oghu aaghenda na Lebbeeka. ");
INSERT INTO tlj_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Bwile obu maka ghaa I̱saka ghakaba ghali Negeebbu haanu̱ma ya ku̱lu̱gha Bbeeli-lahai̱-looyi̱. ");
INSERT INTO tlj_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Lwagholo lumui, I̱saka aalubhatangagha mu musili naateekeleja, aabona ngamila nsiisa. ");
INSERT INTO tlj_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Obu Lebbeeka aaloli̱ye elughulu naabona I̱saka, du̱mbi̱ aasu̱ndu̱ka bwangu-bwangu haa ngamila. ");
INSERT INTO tlj_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Aabu̱u̱li̱ya ati, “Oghu ni musaasa ki oghu akwete kulubhatangila mu musili kwisa kutusangaana?” Mu̱heeleli̱ya oghu aamukuukamu ati, “Ni mukama wanje.” Du̱mbi̱ eeswi̱ki̱li̱la haa li̱i̱so na kaaleeso ke nga mugholi. ");
INSERT INTO tlj_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Mu̱heeleli̱ya wa Ebbulahi̱mu̱ oghu aatandika kughambila I̱saka byona ebi aakoli̱yeyo. ");
INSERT INTO tlj_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","I̱saka aasi̱i̱ma kuswela Lebbeeka, aamutaahi̱ya mu weema ya ni̱na wee Saala. Du̱mbi̱ aaba mukali̱ wee kandi aamukundila kimui. Nankabha ni̱na wee Saala aaku̱u̱ye, Lebbeeka aafooka mu̱hu̱u̱mu̱li̱ya wa I̱saka haabwa ku̱ku̱wa kwa ni̱na wee. ");
INSERT INTO tlj_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ebbulahi̱mu̱ aatodha aaswela mukali̱ onji li̱i̱na liye Keetula. ");
INSERT INTO tlj_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Aabyala Jimulaani̱, Yokasaani̱, Medeeni̱, Mi̱di̱yaani̱, Isibbaaki, hamui na Suuwa. ");
INSERT INTO tlj_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokasaani̱ aabyala Sebba na Dedaani̱. Baasukulu baa Dedaani̱ ni Basu̱lu̱hi̱mu̱, Baletu̱si̱hi̱mu̱ na Balehu̱mi̱mu̱. ");
INSERT INTO tlj_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Na batabani̱ baa Mi̱di̱yaani̱ bakaba bali Efaha, Efeli̱, Enoka, Abbi̱da, hamui na Elidaaya. Aba boona bakaba bali baasukulu baa Ebbulahi̱mu̱, aba mu lu̱byalo lwa mukali̱ wee Keetula. ");
INSERT INTO tlj_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ebbulahi̱mu̱ aagweta I̱saka etunga liye lyona. ");
INSERT INTO tlj_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Bhaatu obu aabaagha atakaku̱u̱ye, aaha bisembo batabani̱ be aba aabyayʼo bakali̱ banji, du̱mbi̱ aababhinga ku̱lu̱gha haai-haai na mutabani̱ wee I̱saka, aabatwala mu kyalo kya bu̱lu̱gha ejooba. ");
INSERT INTO tlj_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ebbulahi̱mu̱ akamala myaka 175 munsi, ");
INSERT INTO tlj_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","du̱mbi̱ Ebbulahi̱mu̱ aaku̱wa amali̱ye kukaakulila kimui. Aajiikuwa nga baataata be. ");
INSERT INTO tlj_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Batabani̱ be aba, I̱saka na Sumai̱li̱, baamujiika mu ki̱i̱na kyʼebaale kili mu musili mu kyalo kya Macepela, haai-haai na Mami̱le, mu musili oghwali ghuli ghwa Efu̱looni̱ mutabani̱ wa Johali̱ Mu̱hi̱tahi̱ti̱. ");
INSERT INTO tlj_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Musili oghu baamu̱ji̱i̱ki̱yemu na mukali̱ wee Saala, Ebbulahi̱mu̱ oghu akaba aasangu̱u̱we aghu̱ghu̱li̱ye eenini mu Bahi̱ti̱. ");
INSERT INTO tlj_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Haanu̱ma ya ku̱ku̱wa kwa Ebbulahi̱mu̱, Luhanga aaha mutabani̱ wee I̱saka mu̱gi̱sa. I̱saka, oghu aaghenda aakala Bbeeli-lahai̱-looyi̱ mu elungu lya Negeebbu. ");
INSERT INTO tlj_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Eni niiyo nsoboolola ya lu̱byalo lwa Sumai̱li̱, mutabani̱ wa Ebbulahi̱mu̱, oghu aabyayʼo Hagali̱, mu̱syana wa Saala oghu akaba alu̱ghi̱ye Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ghani niigho mali̱i̱na ghaabo, hamui na ntu̱la syabo. Mu̱li̱ghaaso ghwa Sumai̱li̱ niiye akaba ali Nebbayosi̱, aalabhi̱yo Kedala, Adi̱bbeeli̱, Mibisaamu, ");
INSERT INTO tlj_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Miisima, Duuma, Masa, ");
INSERT INTO tlj_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadaadi̱, Teema, Yetu̱li̱, Nafi̱si̱, hamui na Kedeema. ");
INSERT INTO tlj_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Batabani̱ baa Sumai̱li̱ eku̱mi̱ na babili bani, niibo balemi̱ eku̱mi̱ na babili abaatandi̱ki̱i̱si̱i̱ye ntu̱la eku̱mi̱ nʼebili, esi baalu̱ki̱ye mali̱i̱na ghaabo kandi baghasolongeei̱ye bakwamililiiye bi̱i̱kalo hambali baabaagha baakaaye kedha baghooni̱ye ");
INSERT INTO tlj_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Sumai̱li̱ aamala munsi myaka 137 ya bukulu, du̱mbi̱ aaku̱wa, aajiikuwa hamui na baataata be. ");
INSERT INTO tlj_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Lu̱byalo lwa Sumai̱li̱ lukaakala munsi eghi eli haagati ya Havila na Suula, ebikusanguwagha bu̱lu̱gha ejooba bwa Mi̱si̱li̱, ololeleeye luhande lwa kyalo kya Asi̱li̱ya. Baakala bataghonjangaane na baghenji̱ baabo. ");
INSERT INTO tlj_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Bini niibiyo ebikwetʼo ka na lu̱byalo lwa I̱saka, mutabani̱ wa Ebbulahi̱mu̱. ");
INSERT INTO tlj_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","I̱saka obu aahi̱ki̱i̱ye myaka 40 ya bukulu, aaswela Lebbeeka muhala wa Bbesweli̱ Munaalaamu ku̱lu̱gha Padanalaamu kandi Lebbeeka oghu akaba ali mwani̱na Labbaani̱ Munaalaamu. ");
INSERT INTO tlj_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","I̱saka aasaba Mukama nanga mukali̱ wee akaba ali ngumba. Mukama aakuukamu kusaba kuwe, du̱mbi̱ mukali̱ wee oghu aaku̱li̱ya. ");
INSERT INTO tlj_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Balongo aabaagha aku̱li̱i̱ye, baakala ku̱ti̱ngi̱tana munda. Lebbeeka aatandika kwebu̱u̱li̱ya ati, “Haabwaki kintu nga kini nkimbʼo?” Du̱mbi̱ aaghenda kwebu̱u̱li̱yʼo Mukama. ");
INSERT INTO tlj_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Mukama aamukuukamu ati, “Mahanga abili ghali mu etundu lyawe kandi aku̱byala baana babili abalyetambulani̱yamu. Omui aliba wamaani̱ kusaali̱ya muunakiye kandi wʼobukulu ali̱heeleli̱ya wʼobuto.” ");
INSERT INTO tlj_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Obu bwile bwa ku̱byala bwahi̱ki̱ye, Lebbeeka aabyala balongo baabusaasa. ");
INSERT INTO tlj_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Mwana oghu akadu̱bha ku̱byaluwa, akaba ali munjilakaki̱ kandi byoha bimumalakaki̱ye mubili ghwona nga kinyama kya mu kisaka. Baamuluka li̱i̱na bati niiye Esau. ");
INSERT INTO tlj_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Haanu̱ma, waakabili naye aabyaluwa, mukono ghuwe ghukwete haa kati̱ngelo kaa Esau. Du̱mbi̱ baamuluka li̱i̱na bati niiye Yakobbo. I̱saka akaba amali̱ye ku̱hi̱ki̱ya myaka nkaagha ya bukulu obu Lebbeeka aabyaye balongo aba. ");
INSERT INTO tlj_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Batabhana aba baakula. Esau aaba wamaani̱ mu kuhiigha kandi aakilagha munu kuukala mu kisaka bwile buwe bunamu̱nji̱ naahiigha. Bhaatu Yakobbo eye akaba ali mwana mu̱holi̱ya kandi aakalagha e ka bwile bwona. ");
INSERT INTO tlj_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","I̱saka akaba aku̱ndi̱ye Esau nanga aabbalagha kuliya nyama sya mu kisaka esi aamuleetelagha. Lebbeeka eye akaba aku̱ndi̱ye Yakobbo. ");
INSERT INTO tlj_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Kilo kimui obu Yakobbo aateekagha mukubi, Esau aaki̱dha ku̱lu̱gha mu kisaka aluhiiye kimui. ");
INSERT INTO tlj_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Aaghila Yakobbo ati, “Njala enkwete kwonini, ompe haa muto ghwawe ghutukuuye haala.” (Eki niikiyo baamulukiiye li̱i̱na linji bati niiye Edomu, makulu ghaaliyo, “Kintu kiimutuku.”) ");
INSERT INTO tlj_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakobbo aamukuukamu ati, “Odu̱bhe ongu̱li̱ye mu̱gi̱sa ghwawe.” ");
INSERT INTO tlj_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau aamukuukamu ati, “Si̱ye njala elimanjita. Mu̱gi̱sa oghu ghuli na mughaso ki ninaanaku̱u̱ye?” ");
INSERT INTO tlj_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakobbo aamukuukamu ati, “Odu̱bhe olahile ngoku olimampa mu̱gi̱sa ghwawe ghwa mu̱li̱ghaaso oghu.” Du̱mbi̱ Esau aalahila ngoku alimamuha ghuwo. ");
INSERT INTO tlj_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Yakobbo aaha Esau migaati̱ na muto ghwa bikoole oghu. Esau aaliya, aakamali̱ye kuliya, aamuka du̱mbi̱ aaghenda. Niikuwo Esau aaghahi̱ye atiyo mu̱gi̱sa ghuwe ghwa kuba mu̱li̱ghaaso. ");
INSERT INTO tlj_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Niibuwo njala yamaani̱ yaaghuuye mu nsi eghi, ngoku yaadu̱bhi̱ye kughuwa mu bwile obu Ebbulahi̱mu̱ aabaaghʼo. Du̱mbi̱ I̱saka aaghenda mu kyalo kya Gelaali̱, hambali Abbi̱meleeki̱ mukama wa Bafi̱li̱si̱ti̱ aakalagha. ");
INSERT INTO tlj_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Bwile obu, Mukama aabonekela I̱saka, aamughila ati, “Otaghenda eku̱wa e Mi̱si̱li̱ kandi okole ngoku ndakughambila. ");
INSERT INTO tlj_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Odu̱bhe ookale munsi eni haabwa bwile bukee nga mu̱ku̱lu̱ki̱. Ndaakalagha naawe kandi nkukuha mu̱gi̱sa. Ndimagu̱mi̱ya ngoku nkukuha byalo bini byona na lu̱byalo lwawe lwona, ngoku naakoli̱ye ndaghaano na so waawe Ebbulahi̱mu̱. ");
INSERT INTO tlj_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ndikani̱ya baasukulu baawe nga nsooli̱ya syʼeghulu kandi mbahe byalo bini byona. Ti̱ mahanga ghoona ghalitunga mu̱gi̱sa kusaalila mu baasukulu baawe aba. ");
INSERT INTO tlj_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Nkukola eki nanga Ebbulahi̱mu̱ akasi̱i̱ma kukola ebi naamughambilagha kandi aadhootela bilaghilo byanje byona.” ");
INSERT INTO tlj_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Du̱mbi̱ I̱saka aakala Gelaali̱. ");
INSERT INTO tlj_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Obu basaasa baa mu kyalo eki baabu̱u̱i̱ye I̱saka haa bikwetʼo mukali̱ wee Lebbeeka, aabaghila ati ni mwani̱na wee. Oobaha kughila ati ni mukali̱ wee nanga bamwita, haabwa kusemela kwa mukali̱ wee oghu. ");
INSERT INTO tlj_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Haanu̱ma ya bwile bukani̱ye I̱saka aliyeyo, Abbi̱meleeki̱ mukama wa Bafi̱li̱si̱ti̱, aalolela hansi ali eghulu mu di̱li̱sa, aabona I̱saka naaseka na mukali̱ wee Lebbeeka. ");
INSERT INTO tlj_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Niibuwo Abbi̱meleeki̱ aabilikiiye I̱saka aamughila ati, “Haabwaki nuwaaghi̱li̱ye oti Lebbeeka ni mwanjoko waawe?” I̱saka aamukuukamu ati, “Nkabu̱gha ntiyo nanga neeli̱li̱kanagha nti, kedha nangufeeluwa bwomi̱i̱li̱ bwanje haabwa mukali̱ oni.” ");
INSERT INTO tlj_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Du̱mbi̱ Abbi̱meleeki̱ aaghila ati, “Ti̱ waatu̱koli̱ye otiyo nangaaki? Buuye nguli omui mu basaasa bani aakolangaane na mukali̱ oghu tawangubaaye otuleeteleeye musango?” ");
INSERT INTO tlj_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Abbi̱meleeki̱ du̱mbi̱ aatelʼo bantu be boona kilaghilo ati, “Muntu weena oghu akukola kubhi musaasa oni hamui na mukali̱ wee, akulaghila bamwite.” ");
INSERT INTO tlj_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Du̱mbi̱ I̱saka aahela ndimo yee kandi mu mwaka oghu ghwonini, yeela milundi nga ki̱ku̱mi̱, nanga Mukama akaba naamali̱ye kumuha mu̱gi̱sa. ");
INSERT INTO tlj_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Musaasa oghu aatungila kimui kandi etungo liye lyeyongeleela kimui. ");
INSERT INTO tlj_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Aatungila kimui bisolo nga ntaama, mbu̱li̱, nte, hamui na basyana, ekyaleeteli̱i̱je Bafi̱li̱si̱ti̱ kumughilila etima. ");
INSERT INTO tlj_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Bafi̱li̱si̱ti̱ aba haabwa etima baaseesa etaka mu byahu̱dhu̱ bya maasi hambali I̱saka aanwelagha, ebi basyana baa Ebbulahi̱mu̱ baabaagha bali̱mi̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Haakumaliilila, Abbi̱meleeki̱ aalaghila I̱saka ku̱lu̱gha mu kyalo eki. Aamughila ati, “Olu̱ghe muni, oghende hanji, nanga uwe waabaaye wamaani̱ kusaali̱ya etu̱we boona.” ");
INSERT INTO tlj_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Nahabweki I̱saka na bantu be baaku̱lu̱ka mu kyalo eki, baaghenda mu kighona kya Gelaali̱ hambali baakweye weema syabo, du̱mbi̱ baakalayo. ");
INSERT INTO tlj_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Aatodha aalima buhyaka byahu̱dhu̱ ebyabaagha babi̱li̱mi̱ye mu bwile obu Ebbulahi̱mu̱ aabaaghʼo, ebi Bafi̱li̱si̱ti̱ baabaagha baaghaaye obu Ebbulahi̱mu̱ aaku̱u̱ye. I̱saka aatodha aabiluka mali̱i̱na ghaabiyo ghanamukulu. ");
INSERT INTO tlj_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Basyana baa I̱saka baalima mu kighona eki kyahu̱dhu̱, baatungayo maasi ghasemeeye. ");
INSERT INTO tlj_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Bhaatu bali̱i̱si̱ya baa bisolo baalu̱gha Gelaali̱, baatandika kutongana na bali̱i̱si̱ya baa bisolo bya I̱saka mbaghila bati, “Maasi agha ni ghaatu.” Du̱mbi̱ I̱saka aaluka kyahu̱dhu̱ eki li̱i̱na ati Eseki̱, elikumani̱i̱si̱ya, “Mpaka.” ");
INSERT INTO tlj_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Basyana baa I̱saka baalima kyahu̱dhu̱ kinji, nakiyo baatodha baakitonganilana na bali̱i̱si̱ya aba. Du̱mbi̱ I̱saka aakiluka li̱i̱na ati niikiyo Si̱ti̱na, elikumani̱i̱si̱ya, “Bunanji̱ghu̱wa.” ");
INSERT INTO tlj_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","I̱saka aalu̱gha haala, du̱mbi̱ batodha baalima kyahu̱dhu̱ kinji. Dhelu eki takyabaayʼo ntongani̱ yoona bbaa. Du̱mbi̱ I̱saka aaluka kyahu̱dhu̱ eki li̱i̱na lya “Lehobboti̱,” aaghila ati, “Dhelu Mukama aatuhaaye ki̱i̱kalo kya kuukalamu kandi tukuguudhaalilamu.” ");
INSERT INTO tlj_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","I̱saka aalu̱ghayo, aaghenda Bbeli̱seba ");
INSERT INTO tlj_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","hambali Mukama aamubonekeeye mu kilo kyonini eki aaki̱dhi̱i̱yemu. Du̱mbi̱ aamughila ati, “Ndi Luhanga wa so waawe Ebbulahi̱mu̱. Otoobaha nanga nkuba naawe. Nkukuha mu̱gi̱sa kandi nkani̱ye muhendo ghwa baasukulu baawe haabwa mu̱heeleli̱ya wanje Ebbulahi̱mu̱.” ");
INSERT INTO tlj_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","I̱saka aakwelʼo kyakuhongelʼo bihonguwa kandi aalami̱ya Mukama. Aakwelʼo weema yee kandi baheeleli̱ya be baalimʼo kyahu̱dhu̱. ");
INSERT INTO tlj_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Kilo kimui, Mukama Abbi̱meleeki̱ aalu̱gha Gelaali̱, ali na mu̱hi̱ wee wa magheji li̱i̱na liye Ahusaati, hamui na Fi̱kooli̱ mukulu wa baasilikale be. ");
INSERT INTO tlj_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Du̱mbi̱ I̱saka aababu̱u̱li̱ya ati, “Buuye mbiki byabaleeti̱ye eni, kuni mukambhinga ewaanu nanga kunjoha?” ");
INSERT INTO tlj_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Baamukuukamu bati, “Tuboone bbeni̱-bbeni̱ tuti Mukama ali naawe. Nahabweki tukubbala kutunga nkolangana esemeeye naanu. Nahabweki muleke tukole ndaghaano. ");
INSERT INTO tlj_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Olahile oti tookutukola kubhi, ngoku naatu tutaaku̱koli̱ye kubhi. Bwile bwona tukakukola kusemeeye, na bwile obu twabalaghi̱ye ewaatu, tukabalagha mu bu̱si̱nge. Tooli̱ olole ngoku Mukama aakuhaaye mu̱gi̱sa.” ");
INSERT INTO tlj_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","I̱saka aabakolela ki̱ghenu̱, baaliya kandi baanuwa. ");
INSERT INTO tlj_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Nkyambisi ya kilo ekyalabhi̱yʼo, bu̱li̱ muntu aalahila kilahilo ngoku atalisobola kutalibani̱ya muunakiye. Du̱mbi̱ I̱saka aabasindika mu maka ghaabo, baaghenda, baamu̱ti̱gha na bu̱si̱nge. ");
INSERT INTO tlj_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Kilo eki kyonini, basyana baa I̱saka baasa baamughambila ngoku baali̱mi̱ye kyahu̱dhu̱ kandi ngoku baaboone maasi ghasemeeye. ");
INSERT INTO tlj_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Du̱mbi̱ I̱saka aaluka kyahu̱dhu̱ eki li̱i̱na ati niikiyo Si̱bba (makulu ghaaliyo, “kilahilo”). Ku̱lu̱gha bwile obu ku̱hi̱ki̱ya endindi, tau̱ni̱ eghi bakughighilaghamu Bbeli̱seba. ");
INSERT INTO tlj_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Obu Esau aamali̱ye ku̱hi̱ki̱ya myaka 40, aaswela Yu̱di̱ta muhala wa Bbeeli̱ hamui na Bbasemaati muhala wa Elooni̱ baa mu ntu̱la ya Bahi̱ti̱. ");
INSERT INTO tlj_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Bakali̱ baa Esau aba baaleeteleja bwomi̱i̱li̱ bwa I̱saka na Lebbeeka kuba bwa bujune. ");
INSERT INTO tlj_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Kilo kimui, I̱saka amali̱ye kukaakula na kuughala maaso, aabilikila Esau mutabani̱ wee wʼobukulu aamughila ati, “Mwana wanje.” Esau aamukuukamu ati, “Ndi hani tita.” ");
INSERT INTO tlj_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ese wee aamughila ati, “Si̱ye naamali̱ye kukaakula. Ti̱ tanimani̱ye kilo eki nku̱kwi̱lamu. ");
INSERT INTO tlj_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Nkubbala okwate buta bwawe na bimala, oghende onjitile kisolo kya mu kisaka. ");
INSERT INTO tlj_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Onteekele kusemeeye byokuliya ebi nku̱ndi̱ye, ti̱ obindeetele hani mbiliye, du̱mbi̱ nkukuha mu̱gi̱sa ntakaku̱u̱ye.” ");
INSERT INTO tlj_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Kwesi̱ Lebbeeka aaghu̱u̱ye ebi bali̱i̱ wee I̱saka aaghambilagha mutabani̱ wee Esau. Obu Esau aaghendi̱ye mu kisaka kuhiighila ese wee, ");
INSERT INTO tlj_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Lebbeeka aaghambila mutabani̱ wee Yakobbo ati, “Olole, naaghu̱u̱ye so waawe naaghila ati Esau ");
INSERT INTO tlj_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","aghende amwitile kisolo kya mu kisaka, niikuwo amuteekele byokuliya bisemeeye, du̱mbi̱ akumusabila mu̱gi̱sa mu maaso ghaa Mukama eye atakaku̱u̱ye.” ");
INSERT INTO tlj_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Du̱mbi̱ aamuha magheji, aamughila ati, “Mwana wanje nkubbala ontegheeleli̱ye kandi okole kyonini eki nkukughambila. ");
INSERT INTO tlj_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Oghende mu bu̱hi̱yo bwa mbu̱li̱, ooyeyo mbu̱li̱ ebili, osindeetele. Oleke si̱ye nteekele so waawe kiihulo kisemeeye ngoku akubbalagha. ");
INSERT INTO tlj_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Du̱mbi̱ omutwalile kiyo, Esau atakaasi̱ye, niikuwo uwe otwale mu̱gi̱sa oghu.” ");
INSERT INTO tlj_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yakobbo aakuukamu ni̱na wee ati, “Wamaaha Esau ali na byoha haa mubili ghuwe ghwona kandi si̱ye ndi na mubili ghu̱telelu̱ki̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ti̱ buuye tita naananku̱mi̱yʼo, taakughila ati ndimamu̱dhomi̱ya, neeleeteleje mukiino ghwa busa mu ki̱i̱kalo kya mu̱gi̱sa?” ");
INSERT INTO tlj_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ni̱na wee aamukuukamu ati, “Mwana wanje, oleke mukiino oghu ghube hali si̱ye. Kuuyʼo uwe okole eki naakughambiiye nti ondeetele mbu̱li̱.” ");
INSERT INTO tlj_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Du̱mbi̱ Yakobbo aatuwa hanja, aaleetela ni̱na wee mbu̱li̱. Lebbeeka aasitwala, aasibaagha, aateekela I̱saka kiihulo kinuliiye kimui ngoku aabbalagha. ");
INSERT INTO tlj_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Du̱mbi̱ Lebbeeka aakoma lughoye lusemeeye lwa mwana wee wa bukulu Esau, olu Lebbeeka aabaagha abi̱i̱ki̱ye mu numba, aaluha mwana wee wʼobuto Yakobbo aalu̱waala. ");
INSERT INTO tlj_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Aaswi̱ki̱la mikono hamui na bi̱twi̱ke bya bikiya bya Yakobbo ebyali bi̱telelu̱ki̱ye na luhu lwa mbu̱li̱. ");
INSERT INTO tlj_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Du̱mbi̱ aaha Yakobbo kiihulo kinuliiye kimui, aatʼo migaati̱ aateeki̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yakobbo aaghenda ewaa ese wee, aamubilikila ati, “Tita.” I̱saka aamukuukamu ati, “Mwana wanje, naani̱ akwete kumbilikila?” ");
INSERT INTO tlj_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakobbo aamukuukamu ati, “Ni̱i̱syoni Esau, mu̱li̱ghaaso ghwawe. Naakoli̱ye ngoku wandaghiiye. Oomuke ositame, oliye, niikuwo ompe mu̱gi̱sa ghwawe.” ");
INSERT INTO tlj_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","I̱saka aabu̱u̱li̱ya mutabani̱ wee ati, “Mwana wanje, waatu̱ngi̱ye oti̱ya kisolo eki bwangu?” Yakobbo aamukuukamu ati, “Mukama Luhanga waawe niiye aaleki̱ye naakitunga.” ");
INSERT INTO tlj_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Du̱mbi̱ I̱saka aaghila Yakobbo ati, “Weesu̱kane haai-haai nku̱ku̱mʼo, niikuwo nimanye majima olakaba oli Esau eenini.” ");
INSERT INTO tlj_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakobbo eesu̱kana haai-haai na ese wee, du̱mbi̱ I̱saka aamu̱ku̱mʼo. Aaghila ati, “Kusa mumelo ni ghwa Yakobbo, bhaatu mikono ni ya Esau.” ");
INSERT INTO tlj_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","I̱saka aasaaghuwa kumaniilila Yakobbo nanga mikono yee ekaba eli na byoha nga bya Esau. Du̱mbi̱ eeteekani̱ja kuha Yakobbo mu̱gi̱sa. ");
INSERT INTO tlj_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","I̱saka aatodha aabu̱u̱li̱ya ati, “Bhaatu majima kuwo niiwe mwana wanje Esau?” Yakobbo aamukuukamu ati, “Ni̱i̱syoni.” ");
INSERT INTO tlj_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Du̱mbi̱ I̱saka aaghila ati, “Mwana wanje, ondeetele byokuliya wanteekeeye. Oleke mbiliye, niikuwo nkuhe mu̱gi̱sa.” Yakobbo aaleetela ese wee byokuliya, aabiliya kandi aanuwa vi̱i̱ni̱ eghi aamuleeteeye. ");
INSERT INTO tlj_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Du̱mbi̱ I̱saka aaghila Yakobbo ati, “Mwana wanje, oneesu̱kane haai-haai nkughuwe mu ki̱ku̱bha.” ");
INSERT INTO tlj_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yakobbo aamwesu̱kana haai-haai, du̱mbi̱ aamughuwa mu ki̱ku̱bha. Obu I̱saka aaghu̱u̱ye kisu kya mu lughoye lwa Esau olu Yakobbo aali alu̱wete, aaha Yakobbo mu̱gi̱sa naaghila ati, “Haa! Kisu kya mutabani̱ wanje kili nga musili oghu Mukama ahaaye mu̱gi̱sa. ");
INSERT INTO tlj_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Luhanga akuhe mu̱gi̱sa ku̱lu̱gha mu eghulu kandi mbu̱la na ki̱me, bihaaghe lwejo etaka lyawe, niikuwo weeleli̱yaghe kimui bilimuwa byawe. ");
INSERT INTO tlj_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Mahanga ghakani̱ye ghaku̱heeleli̱yaghe, na bantu boona baku̱teeleli̱yaghe. Obe mukama wa baghenji̱ baawe kandi na baa njoko waawe baku̱teeleli̱yaghe. Boona abalakukiinagha, nabo balakiinuwagha. Abalakuhaagha mu̱gi̱sa, nabo balaghuheebuwagha.” ");
INSERT INTO tlj_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","I̱saka akaba amakamala ati kumuha mu̱gi̱sa, na Yakobbo amakamu̱lu̱ghʼo ati, du̱mbi̱ Esau naye aaki̱dha ku̱lu̱gha mu kuhiigha. ");
INSERT INTO tlj_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Naye dhee aateeka byokuliya bi̱nu̱li̱ye, aabileetela ese wee. Aamughila ati, “Tita, oomuke oliye, naakuteekeeye byokuliya na ngoku wandaghiiye, niikuwo ompe mu̱gi̱sa ghwawe.” ");
INSERT INTO tlj_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ese wee I̱saka aamu̱bu̱u̱li̱ya ati, “Uwe nuuwe ani̱?” Esau aamukuukamu ati, “Ni̱i̱syoni mutabani̱ waawe kandi mu̱li̱ghaaso ghwawe, Esau.” ");
INSERT INTO tlj_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Du̱mbi̱ I̱saka aasweka kandi aatandika kutukumila, du̱mbi̱ aabu̱u̱li̱ya ati, “Buuye ni ani̱ oghu aku̱lu̱gha kunjihuulila kiihulo kya nyama sya mu kisaka endindi otakaasi̱ye? Naamali̱ye kuliya kandi naamali̱ye kumuha mu̱gi̱sa, tandi nangoku ndasobola kumuuyʼo ghuwo.” ");
INSERT INTO tlj_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Obu Esau aaghu̱u̱ye ebi ese wee aabu̱ghi̱ye, aatandika kulilila kimui, naneesengeleli̱ya ese wee ati, “Tita, nanje dhee gutu, ompe mu̱gi̱sa.” ");
INSERT INTO tlj_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Bhaatu I̱saka aamukuukamu ati, “Wanjoko waawe aasi̱ye andimaaga kandi aatwala mu̱gi̱sa ghwawe.” ");
INSERT INTO tlj_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau aaghila ati, “Buuye taki̱hi̱ki̱ye kumughilamu Yakobbo? Oghu ghwaba mulundi ghwakabili nanjibha. Akatwala mu̱gi̱sa ghwanje ghwa kuba mu̱li̱ghaaso. Ti̱ olole aatodhi̱ye kutwala mu̱gi̱sa ghwanje. Buuye nanje tawambiikiiyeyo hakili mu̱gi̱sa ghumui bughila?” ");
INSERT INTO tlj_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Bhaatu I̱saka aamughila ati, “Naamali̱ye kufoola Yakobbo kuba mukama waawe kandi naamali̱ye ku̱bu̱gha nti baghenji̱ be boona bakuba basyana be kandi naamuha mu̱gi̱sa ghwa kweli̱yagha bilimuwa bikaniiye kimui na binji ebilalu̱ghaghamu vi̱i̱ni̱. Mwana wanje, taaliyo eki nkugubha kukukolela bbaa.” ");
INSERT INTO tlj_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau aaghila ese wee ati, “Tita, majima kuwo waabaagha na mu̱gi̱sa ghumui ghwonkaha? Gutu tita, nanje ompe mu̱gi̱sa.” Du̱mbi̱ Esau aalilila kimui. ");
INSERT INTO tlj_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ese wee I̱saka aamukuukamu ati, “Uwe olaakalagha hʼetaka elitaakweli̱yagha bilimuwa kandi mbu̱la teelatoonagha mu etaka lyawe bbaa. ");
INSERT INTO tlj_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Kihiyo kyawe niikiyo kilakulindagha kandi okuba mu̱syana wa mu̱ghenji̱ waawe. Bhaatu obu olyekamba kwelwanʼo, olitunga bughabe ku̱mu̱lu̱ghʼo.” ");
INSERT INTO tlj_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ku̱lu̱gha bwile obu, Esau oohela kimui Yakobbo haabwa mu̱gi̱sa oghu ese wee aamuhaaye. Du̱mbi̱ Esau aakwatuwa ki̱i̱ni̱gha, aatandika kuteekeleja ati, “Bwile bwa tita ku̱ku̱wa buli haai ku̱hi̱ka, du̱mbi̱ nanje ndiita mu̱ghenji̱ wanje Yakobbo.” ");
INSERT INTO tlj_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Obu baaghambiiye Lebbeeka ebi mutabani̱ wee wabukulu Esau akwete kweli̱li̱kana, du̱mbi̱ aatu̱mi̱i̱si̱ya mutabani̱ wee Yakobbo, aamughila ati, “Mu̱ghenji̱ waawe Esau niibuwo aabbala kukwita.” ");
INSERT INTO tlj_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ti̱ mwana wanje okole ngoku ndakakughambila: Oomu̱ki̱ye bwangu, oolukile ewaa mwani̱naasi̱ye Labbaani̱ mu kyalo kya Halaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ookaleyo ku̱hi̱ki̱ya wanjoko waawe ki̱i̱ni̱gha kimuhooyʼo. ");
INSERT INTO tlj_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ki̱i̱ni̱gha kikaakumuhuwʼo, naamala kuubululuwa eki waamu̱koli̱ye, ndikumani̱i̱si̱ya niikuwo okuuke, nanga tambbali̱ye kubafeeluwa enu̱we bombi haa mulundi ghumui. ");
INSERT INTO tlj_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Du̱mbi̱ Lebbeeka aaghila I̱saka ati, “Ni̱i̱ghu̱u̱ye neetamu̱u̱we kuukala na bahala baa Bahi̱ti̱ bani. Kandi mutabani̱ wanje Yakobbo kukaswela mu ntu̱la ya Bahi̱ti̱, hakili nku̱we.” ");
INSERT INTO tlj_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Du̱mbi̱ I̱saka aabilikila Yakobbo, aamuha mu̱gi̱sa kandi aamughila ati, “Otaliswela mukali̱ weena ku̱lu̱gha mu bahala baa Banakanaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Kuuyo oghende Padanalaamu ewaa taata waawe Bbesweli̱, aliiye waaswela mukali̱ ku̱lu̱gha mu bahala baa sookulu waawe Labbaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ti̱ Luhanga wa Bu̱toki̱ Bwona ahe buswele bwawe mu̱gi̱sa, niikuwo obyale baana bakani̱ye kandi baasule munsi yoona. ");
INSERT INTO tlj_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Akuhe mu̱gi̱sa hamui na baasukulu baawe nga oghu aahaaye Ebbulahi̱mu̱, niikuwo naawe otwale kyalo eki olimu nga munamahanga, eki Luhanga aahaaye Ebbulahi̱mu̱.” ");
INSERT INTO tlj_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","I̱saka aalagha Yakobbo, du̱mbi̱ Yakobbo aaghenda Padanalaamu ewaa Labbaani̱ mutabani̱ wa Bbesweli̱ Munaalaamu, waani̱na Lebbeeka, ni̱na Yakobbo na Esau. ");
INSERT INTO tlj_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau aamanya ngoku I̱saka aahaaye Yakobbo mu̱gi̱sa kandi aamutuma kughenda Padanalaamu kuswelayo mukali̱. Ti̱ obu aamali̱ye kumuha mu̱gi̱sa, aamughila ati, “Otaliswela mukali̱ ku̱lu̱gha mu bahala baa Banakanaani̱.” ");
INSERT INTO tlj_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Esau aatodha aamanya ngoku Yakobbo aadhooteeye babyaye be obu baamu̱tu̱mi̱ye kughenda Padanalaamu. ");
INSERT INTO tlj_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esau aakenga ngoku bahala baa Banakanaani̱ aba aadu̱bhi̱ye kuswela baali batadheedhi̱ye ese wee I̱saka. ");
INSERT INTO tlj_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Du̱mbi̱ Esau aaswela Mahalasi, muhala wa Sumai̱li̱ mutabani̱ wa Ebbulahi̱mu̱. Aamwongela haa bakali̱ be, Mahalasi akaba ali mwani̱na Nebbayosi̱. ");
INSERT INTO tlj_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Niibuwo Yakobbo aalu̱ghi̱ye Bbeli̱seba, aaghenda mu kyalo kya Halaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Obu aanaghendagha, haabwa bwile kwala, aasitama mu ki̱i̱kalo kimui, aakoma ebaale aalyegi̱ma na mutuwe ghuwe, aalangaala kandi aaghwesaghila. ");
INSERT INTO tlj_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Obu aali anaghwesaghiiye, aaloota basi̱mbi̱ye madaala hansi hambali aali alangaaye ghahi̱ki̱i̱ye kimui mu eghulu, baamalai̱ka baa Luhanga mbani̱i̱ni̱lʼo kandi mbanasu̱ndu̱ki̱lʼo. ");
INSERT INTO tlj_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Du̱mbi̱ Mukama amwemilila elughulu ngʼala. Aaghila ati, “Ni̱i̱syoni Mukama Luhanga wa so waawe Ebbulahi̱mu̱ hamui na I̱saka. Nkukuha hamui na baasukulu baawe kyalo eki olangaaye mu eki. ");
INSERT INTO tlj_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Baasukulu baawe aba balikanila kimui nga tu̱u̱tu̱, balikanila kimui mu bi̱twi̱ke byona bya munsi kandi bantu boona balitunga mu̱gi̱sa ku̱lu̱gha muliibo. ");
INSERT INTO tlj_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Si̱ye ndiikala naawe, ndakulindagha hoona hambali olaghendagha kandi nku̱ku̱u̱ki̱ye munsi eni. Tandikuleka ku̱hi̱ki̱ya obu ndimala kukukolela byona ebi nakulaghi̱i̱sani̱i̱ye.” ");
INSERT INTO tlj_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Obu Yakobbo aasu̱su̱mu̱ki̱ye, aaghila ati, “Majima kuwo Mukama ali mu ki̱i̱kalo kini, bhaatu si̱ye naabaagha ntakimani̱ye bbaa.” ");
INSERT INTO tlj_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Du̱mbi̱ oobahila kimui, aaghila ati, “Ki̱i̱kalo kini nkyamaani̱, niikiyo Numba ya Luhanga kandi niikiyo elembo lya kughenda mu eghulu.” ");
INSERT INTO tlj_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Nkyambisi ya kilo ekyalabhi̱yʼo, Yakobbo aakwata ebaale eli aabaagha eegi̱mi̱ye hansi ya mutuwe ghuwe, aalisimba nga mpaghi ya kuusukilaghʼo, du̱mbi̱ aaliseesʼo mafu̱ta. ");
INSERT INTO tlj_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ki̱i̱kalo eki Yakobbo aakighilamu ati niikiyo Bbeteeli̱ (kikumani̱i̱si̱ya numba ya Luhanga), bhaatu li̱i̱na lya kibugha eki lyaku̱du̱bha baakighilaghamu Lu̱u̱ji̱. ");
INSERT INTO tlj_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Niibuwo Yakobbo aalahiiye naaghila ati, “Luhanga naakaaye nanje hoona hambali ndakaghendagha kandi ampa byokuliya na ngoye, ");
INSERT INTO tlj_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ku̱hi̱ki̱ya obu ndikuuka kulungi mu maka ghaa tita, niibuwo Mukama akuba Luhanga wanje. ");
INSERT INTO tlj_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ti̱ ebaale lini eli naami̱li̱i̱ye nga mpaghi, lilifooka numba ya Luhanga. Kandi haa byona ebi olampaagha, ndakuhaaghʼo kimui kyʼeku̱mi̱.” ");
INSERT INTO tlj_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakobbo eeyongela kughenda, du̱mbi̱ aaki̱dha mu bantu baa bu̱lu̱gha ejooba. ");
INSERT INTO tlj_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Makakuba ati li̱i̱so, aabona kyahu̱dhu̱ kya Maasi hambali aasangi̱ye biigambi̱ bisatu bya bu̱hi̱yo bya ntaama. Mu kyahu̱dhu̱ eki niimuwo ntaama esi syanwelagha kandi hakaba haliyo ebaale liinamu̱li̱to haa mu̱nu̱wa ghwakiyo. ");
INSERT INTO tlj_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ntaama syona sya mu ki̱twi̱ke eki syakaasagha haa kyahu̱dhu̱ eki, bali̱i̱si̱ya baasiyo boona baati̱ngi̱tagha ebaale eli baliiyʼo. Ti̱ syakabaagha nsi̱lu̱ghʼo, baatodhagha bali̱hi̱li̱ngi̱ti̱yʼo. ");
INSERT INTO tlj_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakobbo aabu̱u̱li̱ya bali̱i̱si̱ya baa ntaama esi ati, “Enu̱we mu̱lu̱ghi̱ye haa, baghenji̱ banje?” Baamukuukamu bati, “Tu̱lu̱ghi̱li̱i̱ye mu kyalo kya Halaani̱.” ");
INSERT INTO tlj_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Aatodha aababu̱u̱li̱ya ati, “Mumani̱ye Labbaani̱ muusukulu wa Naholi̱?” Baamukuukamu bati, “Tumumani̱ye.” ");
INSERT INTO tlj_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Du̱mbi̱ Yakobbo aababu̱u̱li̱ya ati, “Buuye ali kulungi?” Baamukuukamu bati, “Ee, ali kulungi. Olole na muhala wee Lakeeli̱ ali hani, naye niibuwo aali̱i̱si̱ya ntaama.” ");
INSERT INTO tlj_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakobbo aabaghila ati, “Ngoku bwile bunaakaaye, haabwaki mutanwesi̱ya bisolo byanu. Muha ntaama esi maasi kandi mu̱si̱ku̱u̱ki̱ye haa bi̱si̱ngo?” ");
INSERT INTO tlj_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Baamukuukamu bati, “Tatukugubha kukola eki, ntaama syona sitakamali̱ye kugumbaana hamui na kuuyʼo kibaale ekili haa mu̱nu̱wa ghwa kyahu̱dhu̱ eki.” ");
INSERT INTO tlj_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Obu Yakobbo anabu̱ghagha nabo atiyo, du̱mbi̱ Lakeeli̱ aaki̱dha na ntaama sya ese wee, nanga Lakeeli̱ oghu naye akaba ali mu̱li̱i̱si̱ya wa ntaama esi. ");
INSERT INTO tlj_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Obu Yakobbo aaboone Lakeeli̱ adongeei̱ye ntaama sya ese wee Labbaani̱, aali̱gi̱ta bwangu aahi̱li̱ngi̱ti̱ya kibaale ekyabaagha haa mu̱nu̱wa ghwa kyahu̱dhu̱ eki, aatandika kuha ntaama esi maasi ghaa kunuwa. ");
INSERT INTO tlj_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Du̱mbi̱ Yakobbo aaghuwa Lakeeli̱ mu ki̱ku̱bha, aatandika kulila. ");
INSERT INTO tlj_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Aaghila Lakeeli̱ ati, “Si̱ye ndi lughanda lwa so waawe, nanga ndi mutabani̱ wa mwani̱na wee Lebbeeka.” Du̱mbi̱ Lakeeli̱ aali̱gi̱ta kughambila ese wee. ");
INSERT INTO tlj_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Obu Labbaani̱ aaghu̱u̱ye makulu agha ghakwetʼo Yakobbo mutabani̱ wa mwani̱na wee, anguhila kimui kughenda kumusangaana. Obu aamuboone, aamughuwa mu ki̱ku̱bha, aamutwala mu numba yee, du̱mbi̱ Yakobbo aatandika kumusoboolola bighambo ebi. ");
INSERT INTO tlj_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Labbaani̱ aamughila ati, “Uwe oli mwana wanje eenini kandi saghama yanje.” Haanu̱ma ya Yakobbo kumala mu maka ghaa Labbaani̱ kweli̱ kumui, ");
INSERT INTO tlj_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Labbaani̱ aaghila Yakobbo ati, “Uwe kuba mwana wanje takikuleka onkolele milimo ya busa bbaa, kuuyʼo ongambile musaala oghu ndakusasulagha.” ");
INSERT INTO tlj_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labbaani̱ akaba ali na bahala be babili. Wʼobukulu niiye akaba ali Leei̱ya na wʼobuto aniiye Lakeeli̱. ");
INSERT INTO tlj_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leei̱ya akaba asemeeye haali̱i̱so, bhaatu Lakeeli̱ akaba asemeeye mubili hamui na haali̱i̱so. ");
INSERT INTO tlj_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakobbo aabbalila kimui Lakeeli̱, du̱mbi̱ aaghila Labbaani̱ ati, “Oleke nkukolele kumala myaka musanju̱, niikuwo obu ndimala, ompe muhala waawe Lakeeli̱.” ");
INSERT INTO tlj_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labbaani̱ aaghila ati, “Eki kisemeeye uwe kumutwala kukaleka muntu onji naamutwala. Ti̱ ookale hani nanje.” ");
INSERT INTO tlj_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Du̱mbi̱ Yakobbo aatandika kumukolela kumala myaka musanju̱ eghi. Bhaatu kusighikila ngoku aabaagha abbali̱ye Lakeeli̱, myaka musanju̱ eghi ekamufookela nga bilo bikee. ");
INSERT INTO tlj_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Obu Yakobbo aamali̱ye myaka yee musanju̱, aaghila Labbaani̱ ati, “Naamali̱ye myaka eghi wantwi̱li̱i̱ye, ompe mukali̱ wanje tutandike buswele bwatu.” ");
INSERT INTO tlj_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Nahabweki Labbaani̱ aabilikila bantu baa mu kyalo eki, aabakolela ki̱ghenu̱. ");
INSERT INTO tlj_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Bhaatu bwile obu bwali̱ye, Labbaani̱ aaleeta muhala wee Leei̱ya mu mweli̱ma, aamuha Yakobbo. Du̱mbi̱ Yakobbo aalangaala naye. ");
INSERT INTO tlj_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Labbaani̱ aahaayo mu̱syana wee Ji̱li̱pa kughenda kuba mu̱syana wa muhala wee Leei̱ya.) ");
INSERT INTO tlj_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Obu bwile bwakeeye, niibuwo Yakobbo aamaniliiye mukali̱ wee aasanga ali Leei̱ya bamuhaaye. Du̱mbi̱ aaghenda ewaa Labbaani̱, aamughila ati, “Kini nkiki wankoli̱ye? Si̱ye nkakukolela haabwa Lakeeli̱, bhaatu olole uwe ngoku wandimaagi̱ye kughenda kumpa Leei̱ya oghu ntaakoleeleeye!” ");
INSERT INTO tlj_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labbaani̱ aamukuukamu ati, “Takibhonganuuwe mu asi̱li̱ yaatu ku̱du̱bha ku̱sweleesi̱ya mwana wʼobuto, wʼobukulu analiyo bbaa. ");
INSERT INTO tlj_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Odu̱bhe ookale nʼoghu ku̱hi̱ki̱ya bilo byanu musanju̱ bya bugholi bihooyʼo, niikuwo obu olakasi̱i̱ma kutodha kunkolela haabwa myaka enji musanju̱, niibuwo nkukuha na Lakeeli̱.” ");
INSERT INTO tlj_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakobbo aasi̱i̱ma, aamala na Leei̱ya bilo musanju̱ bya bugholi. Du̱mbi̱ Labbaani̱ aamuha Lakeeli̱ naye kuba mukali̱ wee. ");
INSERT INTO tlj_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labbaani̱ aahaayo mu̱syana wee Bbi̱i̱la kughenda kuba mu̱syana wa muhala wee Lakeeli̱. ");
INSERT INTO tlj_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakobbo aalangaala na Lakeeli̱ kandi aamubbalila kimui kusaali̱ya Leei̱ya. Du̱mbi̱ eeyongela kukolela Labbaani̱ myaka enji musanju̱ eghi baalaghaane. ");
INSERT INTO tlj_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Obu Mukama aaboone Yakobbo atabbali̱ye Leei̱ya, du̱mbi̱ aaha Leei̱ya lu̱byalo, Lakeeli̱ aakala anali ngumba. ");
INSERT INTO tlj_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leei̱ya aaku̱li̱ya, aabyala mwana wabusaasa. Aaghila ati “Mukama aaboone kubona-bona kwanje kandi bali̱i̱ wanje akunkunda.” Du̱mbi̱ aaluka mwana oghu li̱i̱na ati Leu̱bbeeni̱. ");
INSERT INTO tlj_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Aatodha aaku̱li̱ya kandi aabyala mwana wabusaasa dhee. Aaghila ati, “Mukama aaghu̱u̱ye ngoku batanku̱ndi̱ye, akampa mwana wabusaasa onji.” Naye aamuluka li̱i̱na ati Si̱mi̱yooni̱. ");
INSERT INTO tlj_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Aatodha aaku̱li̱ya, aabyala mwana onji kandi naye wabusaasa. Aaghila ati, “Dhelu bali̱i̱ wanje hamui nanje tukuba mu bumui, nanga naamu̱byaliiye baana baabusaasa basatu.” Aamuluka li̱i̱na ati niiye Leevi̱. ");
INSERT INTO tlj_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Aatodha aaku̱li̱ya kandi aabyala mwana onji wabusaasa. Du̱mbi̱ aaghila ati, “Dhelu mulundi ghuni nku̱si̱i̱ma Mukama.” Mwana oghu aamuluka li̱i̱na ati niiye Yu̱da. Du̱mbi̱ aaleka ku̱byala. ");
INSERT INTO tlj_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Obu Lakeeli̱ aaboone atabyaliiye Yakobbo mwana, aakwatiluwa mwana waani̱na wee Leei̱ya etima. Du̱mbi̱ aaghila Yakobbo ati, “Ombyalʼo baana, kitali eki, nku̱ku̱wa.” ");
INSERT INTO tlj_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakobbo aasaliluwa, aamughila ati, “Buuye ni̱i̱si̱ye Luhanga oghu aleki̱ye otabyala?” ");
INSERT INTO tlj_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Du̱mbi̱ Lakeeli̱ aamughila ati, “Oghende olangaale na mu̱syana wanje Bbi̱i̱la, omubyalʼo baana niikuwo nanje ntunge baana ku̱lu̱gha mu eye.” ");
INSERT INTO tlj_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Yakobbo aasi̱i̱ma, du̱mbi̱ aalangaala na Bbi̱i̱la mu̱syana wa mukali̱ wee Lakeeli̱. ");
INSERT INTO tlj_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bbi̱i̱la aaku̱li̱ya kandi aabyala mwana wabusaasa. ");
INSERT INTO tlj_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Du̱mbi̱ Lakeeli̱ aaghila ati, “Luhanga antwi̱li̱i̱yemu kulungi, majima kuwo aaghu̱u̱ye kusaba kwanje kandi ampa mwana wabusaasa.” Du̱mbi̱ aamuluka li̱i̱na ati niiye Daani̱. ");
INSERT INTO tlj_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bbi̱i̱la aatodha aaku̱li̱ya, aabyala mwana waakabili. ");
INSERT INTO tlj_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Du̱mbi̱ Lakeeli̱ aaghila ati, “Majima kuwo naalwane na maani̱ kandi naasi̱ngu̱la wamaaha.” Du̱mbi̱ mwana oghu aamuluka li̱i̱na Nafutaali. ");
INSERT INTO tlj_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Obu Leei̱ya naye aaboone aleki̱ye ku̱byala, aaleeta mu̱syana wee Ji̱li̱pa, aamuha Yakobbo ati amuswele. ");
INSERT INTO tlj_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Du̱mbi̱ Ji̱li̱pa naye aabyalila Yakobbo mwana wabusaasa. ");
INSERT INTO tlj_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leei̱ya aaghila ati, “Ghuni nga ghuli mu̱gi̱sa ghwamaani̱!” Du̱mbi̱ mwana oghu aamuluka li̱i̱na Gaadi̱. ");
INSERT INTO tlj_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ji̱li̱pa aabyala mwana waakabili kandi na wabusaasa. ");
INSERT INTO tlj_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leei̱ya aaghila ati, “Ndheedheeu̱we endindi kandi bakali̱ boona balabu̱ghagha ngoku ndheedheeu̱we.” Du̱mbi̱ mwana oghu aamuluka li̱i̱na Aseli̱. ");
INSERT INTO tlj_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Kilo kimui mu bwile bwa kukesa ngano, Leu̱bbeeni̱ aaghenda mu musili, aabonayo bi̱dodoi̱ma, aabiiyayo, aabileetela ni̱na wee Leei̱ya. Du̱mbi̱ Lakeeli̱ aaghila Leei̱ya ati, “Nkwesengeleei̱ye ompe haa bi̱dodoi̱ma bya mutabani̱ waawe.” ");
INSERT INTO tlj_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leei̱ya aamukuukamu ati, “Okanjiyʼo bali̱i̱ wanje, ti̱ ndatodha nkuhe na bi̱dodoi̱ma bya mutabani̱ wanje? Kwesi̱ otwale bali̱i̱ waawe akumali̱ye.” Lakeeli̱ aaghila ati, “Hakili ompʼo niikuwo nanje ndakuhaaye alangaale ewaawe kilo kimui bughila.” ");
INSERT INTO tlj_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Obu Yakobbo aalu̱ghi̱ye haa musili lwagholo, Leei̱ya aaghenda kumusangaana, aamughila ati, “Okulaghiluwa obwalo kulaala nanje, nanga naaku̱ghu̱li̱ye na bi̱dodoi̱ma bya mutabani̱ wanje.” Yakobbo aasi̱i̱ma du̱mbi̱ aalangaalayo. ");
INSERT INTO tlj_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Luhanga aaghu̱wa kusaba kwa Leei̱ya, du̱mbi̱ Leei̱ya aaku̱li̱ya, aabyala mwana waakataano kandi naye wabusaasa. ");
INSERT INTO tlj_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leei̱ya aaghila ati, “Kini ni kisembo kyanje Luhanga ampaaye haabwa mu̱syana wanje oghu naahaaye bali̱i̱ wanje.” Du̱mbi̱ mwana oghu aamuluka li̱i̱na I̱sakaali. ");
INSERT INTO tlj_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leei̱ya aatodha aaku̱li̱ya etundu lyamukaagha, aabyala mwana onji wabusaasa. ");
INSERT INTO tlj_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Leei̱ya aaghila ati, “Luhanga ampaaye kisembo kyanje kyamaani̱, dhelu bali̱i̱ wanje alampaagha ki̱ti̱i̱ni̱sa, nanga naamu̱byaliiye baana baabusaasa mukaagha.” Du̱mbi̱ mwana oghu aamuluka li̱i̱na Jabbu̱looni̱. ");
INSERT INTO tlj_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Haanu̱ma Leei̱ya aabyala mwana wabukali̱, aamuluka li̱i̱na Dina. ");
INSERT INTO tlj_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Niibuwo Luhanga aasu̱ki̱ye Lakeeli̱, du̱mbi̱ naye aamuha lu̱byalo. ");
INSERT INTO tlj_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Lakeeli̱ aaku̱li̱ya, aabyala mwana wabusaasa, du̱mbi̱ aaghila ati, “Luhanga anji̱hi̱yʼo nsoni̱.” ");
INSERT INTO tlj_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Mwana oghu aamuluka li̱i̱na Yojeefu̱, kandi aaghila ati, “Mukama anyongele mwana onji wabusaasa.” ");
INSERT INTO tlj_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Obu Lakeeli̱ aamali̱ye ku̱byala Yojeefu̱, du̱mbi̱ Yakobbo aaghila Labbaani̱ ati, “Oleke nkuuke ewaatu hambali naalu̱ghi̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Onsi̱i̱mi̱lani̱ye ngende na baana hamui na bakali̱ banje boona aba naatu̱ngi̱ye haabwa kukukolela. Ti̱ uwe omani̱ye milimo yoona eghi naakukoleeye.” ");
INSERT INTO tlj_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Labbaani̱ aamughila ati, “Nuwaabaaye ongiliiye ngughuma, gutu ookale hani. Naamali̱ye kwolekuwa ngoku Mukama ampaaye mu̱gi̱sa haabwawe.” ");
INSERT INTO tlj_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Aatodha aamughila ati, “Ongambile kyona eki okubbala, si̱ye ndakuhaagha kiyo.” ");
INSERT INTO tlj_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakobbo aamughila ati, “Olole milimo yamaani̱ eghi naakukoleeye eghi yoona, bisolo byawe byona byaku̱li̱ye kulungi haabwanje. ");
INSERT INTO tlj_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Nkakusanga na bisolo bikee, bhaatu olole ngoku byeyongeeye kandi Mukama aakuhaaye mu̱gi̱sa haabwanje. Ti̱ si̱ye ndekolela dhi̱ kintu kisemeeye ewanje?” ");
INSERT INTO tlj_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labbaani̱ aamu̱bu̱u̱li̱ya ati, “Buuye nkuhe ki?” Yakobbo aamukuukamu ati, “Tambbali̱ye na kantu bbaa. Bhaatu nuwaanakoli̱ye eki ndimakughambila kini, nkuukala niinali̱i̱si̱ya bisolo byawe. ");
INSERT INTO tlj_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Oleke ngende mu bisolo byawe byona niiyemu byana bya ntaama bijilaghu̱li̱ hamui na bya mbu̱li̱ biibhitanga, kedha bughondo byona haaliibiyo byaba musaala ghwanje. ");
INSERT INTO tlj_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Niikuwo bwesighibuwa bwanje okububona obu okwisa kulola mu ebi ndaba niiyemu. Ti̱ kasita osangamu mbu̱li̱ yoona eghi etali bhitanga kedha bughondo, na ntaama eghi etali njilaghu̱li̱, bu̱li̱ eghi nkuba ngi̱i̱bhi̱ye.” ");
INSERT INTO tlj_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labbaani̱ aaghila ati, “Naasi̱i̱mi̱ye, oleke kibe ngoku waabu̱ghi̱ye.” ");
INSERT INTO tlj_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Bhaatu kilo eki kyonini, Labbaani̱ aayamu ntu̱u̱li̱ sya mbu̱li̱ syona esi baalaghaane na Yakobbo, aasiha batabani̱ be kusiloleelela. ");
INSERT INTO tlj_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Du̱mbi̱ baabitwala lughendo lwa bilo bisatu ku̱lu̱gha hambali Yakobbo aabaagha. Bhaatu Yakobbo eeyongela na ku̱li̱i̱si̱ya bisolo bya Labbaani̱ ebyati̱ghaayʼo. ");
INSERT INTO tlj_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Bhaatu Yakobbo aaleeta buti bwa matolu̱, bunji butukuuye, hamui na bunji obwali budhootaagi̱ye, aatandika kubututuula mighongo yabuwo naanatʼo bugalagala bujelu. ");
INSERT INTO tlj_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Buti obu aabusimba mu maaso ghaa biidhebe ebi bisolo ebi byanwelaghamu ati nanga niiyo byamilani̱yagha byakabaagha bi̱i̱si̱ye kunuwa. ");
INSERT INTO tlj_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Bisolo ebi byakaamilani̱yagha mu maaso ghaa buti obu, byabyalagha byana bilimu siibhitanga na siibhughondo. ");
INSERT INTO tlj_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakobbo aaghabani̱ja ntaama na mbu̱li̱ siye. Bwile bwasiyo kwima, aasi̱loli̱yagha hambali siibhitanga na siibughondo sya Labbaani̱ sili, niikuwo sibyale siibughondo na siibhitanga. Mu mulingo oghu, Yakobbo aakani̱ya bisolo biye mu ki̱i̱kalo kya kukani̱ya bya mukama wee Labbaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Yakobbo aakabonagha bisolo ebisemeeye hambali bi̱kwi̱mi̱lani̱ya, du̱mbi̱ aaleetʼo buti buwe obu ati niikuwo bi̱byale byana biibhitanga niikuwo abitwale mu biye. ");
INSERT INTO tlj_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Bhaatu bisolo ebi byakabaagha bitasemeeye, taaleetaghʼo buti obu bbaa. Mbyabyala byana ebitasemeeye, ebi abiha Labbaani̱. Du̱mbi̱ Labbaani̱ aati̱ghali̱ya ebitasemeeye, Yakobbo aatwala ebisemeeye byonkaha. ");
INSERT INTO tlj_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Du̱mbi̱ Yakobbo aatungila kimui bisolo bikani̱ye, aatunga kwonini, aaba na baheeleli̱ya bakani̱ye baabukali̱ na baabusaasa, ngamila, hamui na ndogooi̱ sikaniiye kimui. ");
INSERT INTO tlj_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakobbo aaghu̱wa ngoku baana baa Labbaani̱ baabu̱ghagha bati, “Olole Yakobbo aatwete bintu bya eseetu̱we kandi buguudha obu ali na buwo bwona abu̱u̱hi̱ye mu bintu bya eseetu̱we.” ");
INSERT INTO tlj_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Kandi Yakobbo aakenga ngoku Labbaani̱ atakwete kumutwalikani̱ya ngoku aamutwalikani̱yagha haaku̱du̱bha. ");
INSERT INTO tlj_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Du̱mbi̱ Mukama aaghila Yakobbo ati, “Okuuke ewaa so waawe hamui na nganda syawe, si̱ye nkuukala naawe.” ");
INSERT INTO tlj_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Nahabweki Yakobbo aabilikila Lakeeli̱ na Leei̱ya kwisa hambali aali̱i̱si̱li̱yagha bisolo biye. ");
INSERT INTO tlj_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Aabaghila ati, “Naaboone eseenu̱we aatandi̱ki̱ye kuntwalikani̱ya kunji. Bhaatu Luhanga wa tita akuukalagha nanje. ");
INSERT INTO tlj_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Enu̱we bombi mumani̱ye ngoku naakolelagha eseenu̱we na maani̱ ghanje ghoona. ");
INSERT INTO tlj_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ti̱ mulole ngoku angobeleei̱ye mu kunsasula, aakeehi̱ya musaala ghwanje milundi eku̱mi̱. Bhaatu Luhanga taamu̱si̱mi̱lani̱i̱ye kunkolʼo kabhi koona bbaa. ");
INSERT INTO tlj_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Obu Labbaani̱ aaghilagha ati, ‘Bisolo ebi bilakabyalagha biibhitanga bilabaagha byawe,’ du̱mbi̱ niibiyo byakabyalagha. Kandi obu aaghilagha ati, ‘Bilakabyalagha bughondo bilabaagha byawe,’ niibiyo byakabyalagha.” ");
INSERT INTO tlj_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Nahabweki Luhanga aayʼo eseenu̱we bisolo biye byona, aabimpa. ");
INSERT INTO tlj_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Kilo kimui, mu bwile bwa bisolo kwema, nkaloota ntu̱u̱li̱ sya mbu̱li̱ esili na bigalagala, siibhitanga, hamui na siibughondo nsi̱i̱mi̱li̱ya mu bu̱hi̱yo. ");
INSERT INTO tlj_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Malai̱ka wa Luhanga ambilikila mu ndooti̱ ati, ‘Yakobbo.’ Nanje naamukuukamu nti, ‘Ndi hani.’ ");
INSERT INTO tlj_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","“Angila ati, ‘Olole elughulu ntu̱u̱li̱ sya mbu̱li̱ syona esiliyeyo nsi bhitanga, bughondo, na sya bigalagala sikwete kwi̱mi̱li̱ya mu bu̱hi̱yo. Naabbali̱ye kukwoleka siyo nanga naaboone ebi Labbaani̱ akwete kukukola. ");
INSERT INTO tlj_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ni̱i̱syoni Luhanga oghu akakubonekela e Bbeeseeli̱ hambali waasi̱mbi̱ye mpaghi ya ebaale eghi waasi̱i̱ghi̱yʼo mafu̱ta kandi waalahila kundami̱yagha. Endindi oomuke oghende ewaanu mu nganda syawe.’ ” ");
INSERT INTO tlj_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Du̱mbi̱ Lakeeli̱ na Leei̱ya baakuukamu Yakobbo bati, “Ti̱ buuye tuli na bugwetuwa bwona haa etungo lya eseetu̱we? ");
INSERT INTO tlj_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Buuye taatu̱koli̱ye nga banamahanga? Nanga akamala ku̱tu̱lu̱ghi̱i̱si̱ya kandi aaliya byona ebi aatu̱ngi̱ye ku̱lu̱gha mu etu̱we. ");
INSERT INTO tlj_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ti̱ bintu bini byona ebi Luhanga aakuhaaye ku̱lu̱gha ewaa eseetu̱we, mbyatu na baana baatu. Kwesi̱ okole eki Luhanga aakughambiiye.” ");
INSERT INTO tlj_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Du̱mbi̱ Yakobbo aani̱i̱ni̱ya bakali̱ be na baana be haa ngamila. ");
INSERT INTO tlj_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Du̱mbi̱ aaghenda ewaabo Kanaani̱ hamui na bintu biye byona ebi aabaagha atungiiye e Padanalaamu. ");
INSERT INTO tlj_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Obu Labbaani̱ aabaagha aghendi̱ye kughemba ntaama siye byoha, Lakeeli̱ aabha bisasani̱ bya bihongano bya ese wee. ");
INSERT INTO tlj_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Du̱mbi̱ Yakobbo aaghenda ki̱bi̱so, ataghambiiye Labbaani̱ Munaalaamu ngoku balimaghenda. ");
INSERT INTO tlj_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Aatwala bu̱li̱ kintu kyona eki aabaagha nakiyo. Aaghenda na bantu be boona baabhasuka maasi ghaanamu̱li̱to li̱i̱na lyagho Efulaati̱, mbaghenda mu kyalo kya bwena kya Gi̱li̱yaadi̱. ");
INSERT INTO tlj_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Haa kilo kyakasatu, niibuwo Labbaani̱ aamani̱ye ngoku Yakobbo hamui na bantu be boona baaghendi̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Du̱mbi̱ Labbaani̱ na bantu be baakwama Yakobbo kumala bilo musanju̱ ku̱hi̱ki̱ya obu baamusangi̱ye mu kyalo kya bwena kya Gi̱li̱yaadi̱. ");
INSERT INTO tlj_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Du̱mbi̱ Luhanga aabonekela Labbaani̱ Munaalaamu mu ndooti̱, aamughila ati, “Weelinde, otatodha ku̱bu̱ghʼo Yakobbo kintu kyona kibhi.” ");
INSERT INTO tlj_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Yakobbo akaba akweye weema yee mu kyalo kya bwena kya Gi̱li̱yaadi̱. Obu Labbaani̱ aamu̱ki̱dhi̱i̱yeyo, du̱mbi̱ naye aakwelʼo weema yee na bantu aba aabaagha nabo. ");
INSERT INTO tlj_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Du̱mbi̱ Labbaani̱ aaghila Yakobbo ati, “Mbiki waakoli̱ye ebi? Haabwaki nuwanji̱lu̱ki̱ye kuleeta eni baana banje otangambiiye ngʼoghu oti okabahu̱nga haa bulemo? ");
INSERT INTO tlj_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Haabwaki nuwaalu̱ki̱ye? Hakili nguli wangambiiye niikuwo nkulagha kulungi, nku̱helekeeleli̱ya na bilimbo, buuciki-ciki, hamui na du̱ngu̱. ");
INSERT INTO tlj_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Okaleka ntaaghu̱wa baasukulu banje na bahala banje mu ki̱ku̱bha kandi mbalagha kulungi. Majima kuwo eki ni kintu kya butaami̱ waakoli̱ye! ");
INSERT INTO tlj_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ndi na bu̱toki̱ bwa kukukola kubhi, bhaatu eso Luhanga aabu̱ghi̱ye nanje mu ndooti̱ ati ntagubha kukukolʼo kintu kyona ki̱bhi̱i̱hi̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Uwe waatu̱u̱yemu kughenda nanga waaboone obhonganuuwe kughenda ewaanu. Ti̱ haabwaki nuwaabhi̱ye bihongano byanje?” ");
INSERT INTO tlj_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakobbo aamukuukamu ati, “Nkaba noobahi̱ye nanga nkaba nkimani̱ye nti okunjiyʼo bahala baawe na ki̱ku̱bha.” ");
INSERT INTO tlj_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Yakobbo eye akaba atamani̱ye ngoku Lakeeli̱ aniiye ali na bihongano ebi. Du̱mbi̱ aaghila ati, “Kaakuba osanga muntu weena muli etu̱we oghu ali nabiyo, aatibuwe. Nahabweki oose olole mu bintu byatu bini byona, kaakuba osangamu kintu kyawe, okiiyemu.” ");
INSERT INTO tlj_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Du̱mbi̱ Labbaani̱ aataha mu weema ya Yakobbo, ya Leei̱ya, hamui na sya basyana be Ji̱li̱pa na Bbi̱i̱la, ataasangamu kantu. Haakumaliilila aataaha mu ya Lakeeli̱. ");
INSERT INTO tlj_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Lakeeli̱ eye akaba naamali̱ye ku̱bi̱sa bisasani̱ bya bihongano ebi mu kasau kaa ngamila yee kandi akaba abisitamiiye. Labbaani̱ aataha mu weema ya Lakeeli̱ omu, aatandika kubibbala, bhaatu taagu̱bhi̱ye kubibona bbaa. ");
INSERT INTO tlj_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Lakeeli̱ aaghila ese wee ati, “Tita, otasaaliluwa haabwanje kubhenga kwemilila. Ndi mu nsonga syatu sya kikali̱, niikiyo ki̱leki̱ye ntaamilila mu maaso ghaawe.” Labbaani̱ eeyongela kubbala haala bhaatu taaboone na kantu bbaa. ");
INSERT INTO tlj_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Du̱mbi̱ Yakobbo aasaaliluwa, aabu̱u̱li̱ya Labbaani̱ ati, “Naakoli̱ye musango ki? Kandi nkilaghilo ki naatu̱u̱ye ekikuleka nompiigha otiyo? ");
INSERT INTO tlj_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Buuye obu waalolakaki̱ye mu bintu byanje byona, oli na kintu kyawe kyona eki waasangi̱yemu? Ti̱ kilakaba kilimu, okileete mu maaso ghaa bantu baawe nanje hani, niikuwo batu̱twi̱lemu si̱ye naawe. ");
INSERT INTO tlj_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Endindi naakala naawe kumala myaka 20. Ti̱ ntaama yaawe kedha mbu̱li̱ nʼemui tayakwi̱si̱i̱ye kandi tanaaliiye na mpaha syawe sya ntaama. ");
INSERT INTO tlj_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Tanaakuleeteeye kisolo eki kinyama kihutaai̱ye, nkasi̱i̱ma naafweluwa. Niibuwo waaghila oti nkusasule ebi baabhi̱ye ntangaali̱ kedha mukilo. ");
INSERT INTO tlj_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","“Nkabona-bona ewaawe, ntangaali̱, musana ghwa mpuulagha, ti̱ mukilo, tanaaghwesaghilagha nanga mpeu. ");
INSERT INTO tlj_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Olole, nkabona-bona ntiyo kumala myaka maku̱mi̱ abili ninali mu maka ghaawe. Myaka eku̱mi̱ nʼenaa niikuwo ompe bahala baawe babili, na myaka enji mukaagha niikuwo ompe bisolo bini nga musaala ghwanje. Ti̱ waatodha waakeehi̱ya musaala ghwanje milundi eku̱mi̱. ");
INSERT INTO tlj_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Nguli Luhanga wa baatita, Ebbulahi̱mu̱ na I̱saka ataabaagha nanje, wangubaaye ombhi̱ngi̱ye ntali na kantu. Bhaatu Luhanga aabona bu̱koli̱ bwanje hamui na ngoku naaboona-boone ewaawe, du̱mbi̱ eso mukilo aakutanuka.” ");
INSERT INTO tlj_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labbaani̱ aakuukamu Yakobbo ati, “Bakali̱ aba oli nabo aba mbahala banje, baana aba baabyaye mbaasukulu banje, bisolo ebi oli nabiyo ebi mbyanje na bu̱li̱ kantu koona aka oboone nkanje. Buuye nkole ki obwalo haabwa bahala banje hamui na baana baabo aba? ");
INSERT INTO tlj_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Wiise tukole ndaghaano niikuwo etubeele nga buukai̱so haagati yaatu.” ");
INSERT INTO tlj_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Du̱mbi̱ Yakobbo aakwata ebaale aalisimba nga mpaghi ya kuusukilaghʼo. ");
INSERT INTO tlj_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Aaghila bantu be ati, “Mukumaani̱ye mabaale.” Nahabweki baakumaani̱ya ntuumo ya mabaale kandi baaliila haai-haai na ntuumo eghi. ");
INSERT INTO tlj_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labbaani̱ aaluka ntuumo eghi li̱i̱na lya Yagala Sahu̱du̱sa. Na Yakobbo aalighilamu Galeedi̱. ");
INSERT INTO tlj_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labbaani̱ aaghila ati, “Ntuumo ya mabaale eghi ni buukai̱so haagati yanje naawe.” Niikiyo kyaleki̱ye baakighilamu Galeedi̱. ");
INSERT INTO tlj_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Baatodha baakighilamu bati Mijipa elikumani̱i̱si̱ya “Ngbaali.” Labbaani̱ aaghila ati, “Mukama akuukala naalola haagati yaatu ntwaghendi̱ye bu̱li̱ muntu ewe. ");
INSERT INTO tlj_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Kaakuba okola kubhi bahala banje, kedha oswela bakali̱ banji, nankabha si̱ye ntamani̱ye, okimanye oti Luhanga niiye kai̱so kandi aku̱loli̱ye.” ");
INSERT INTO tlj_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Labbaani̱ aatodha aaghila ati, “Olole ntuumo ya mabaale eghi, hamui na mpaghi eni eghi naasi̱mbi̱ye haagati yanje naawe. ");
INSERT INTO tlj_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ntuumo ya mabaale eni hamui na mpaghi eni niibiyo buukai̱so bwatu kwoleka ngoku ntaakughisaala kwisa ewaawe kukukolʼo kabhi koona, kedha uwe kughisaala kwisa ewanje kunkolʼo kabhi koona. ");
INSERT INTO tlj_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Oleke Luhanga wa Ebbulahi̱mu̱, Naholi̱, hamui na esebo atu̱twi̱lemu si̱ye naawe.” Du̱mbi̱ Yakobbo aalahila Luhanga oghu ese wee I̱saka aalami̱yagha. ");
INSERT INTO tlj_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Du̱mbi̱ Yakobbo aasala kihonguwa, aakihongela mu kyalo kya bwena kandi aabilikila bantu be boona, baaghenda kuliya. Obu baamali̱ye kuliya, baalalayo. ");
INSERT INTO tlj_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Nkyambisi ya kilo ekyalabhi̱yʼo, Labbaani̱ aaghuwa baasukulu be na bahala be mu ki̱ku̱bha, aabaha mu̱gi̱sa, du̱mbi̱ aakuukayo ewe. ");
INSERT INTO tlj_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakobbo naye aaghenda, du̱mbi̱ aasangaana baamalai̱ka baa Luhanga. ");
INSERT INTO tlj_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Obu Yakobbo aaboone baamalai̱ka aba, aaghila ati, “Lini ni ehe lya Luhanga.” Du̱mbi̱ ki̱i̱kalo eki aakighilamu ati “Mahanahi̱mu̱.” ");
INSERT INTO tlj_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Du̱mbi̱ Yakobbo aadu̱bha aatuma batumuwa be ewaa mu̱ghenji̱ wee Esau e Seyi̱li̱, mu nsi ya Edomu. ");
INSERT INTO tlj_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Aabalaghila ati, “Mulakamu̱hi̱kʼo, mumughile muti, ‘Si̱ye mu̱heeleli̱ya wee Yakobbo naaghi̱li̱ye nti, “Nkaakala na Labbaani̱ kumala bwile bukani̱ye kandi ndimakuuka e ka. ");
INSERT INTO tlj_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Olole, ndi na nte, ndogooi̱, ntaama, mbu̱li̱, hamui na basyana. Bhaatu ndimakusaba nti ongilile ngughuma, mukama wanje.” ’ ” ");
INSERT INTO tlj_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Obu batumuwa aba baaku̱u̱ki̱ye ewaa Yakobbo, baamughila bati, “Tukaghenda ewaa mu̱ghenji̱ waawe Esau kandi niibuwo aasa na basaasa bi̱ku̱mi̱ bbinaa kukusangaana.” ");
INSERT INTO tlj_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yakobbo oobaha kandi eeyungila kimui, du̱mbi̱ aatambulani̱yamu kabili bantu hamui na bisolo ebi aabaagha ali nabiyo. ");
INSERT INTO tlj_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Eeli̱li̱kana ati, “Kaakuba Esau aasa ku̱lu̱mba ki̱bbu̱la kimui, kedha kinji kilali̱gi̱ta niikuwo ki̱ti̱ghalʼo.” ");
INSERT INTO tlj_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Du̱mbi̱ Yakobbo aasaba naaghila ati, “Ai̱ Luhanga wa taata Ebbulahi̱mu̱, Luhanga wa tita I̱saka, Ai̱ Mukama okangila oti, ‘Okuuke ewaanu, mu baghenji̱ baawe hambali waabyaliluuwe kandi nkukukola kusemeeye.’ ");
INSERT INTO tlj_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Endindi tansemeeye mu maaso ghaawe nankabha na bwesighibuwa obu waabaagha ompaaye tandi nabuwo bbaa. Olole, nkabhasuka Yolodaani̱ ntali na kantu koona kuuyʼo mwi̱gho ghwonkaha, bhaatu olole endindi ndi na bi̱bbu̱la bibili bya bantu hamui na bibili bya bisolo. ");
INSERT INTO tlj_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ti̱ Mukama, nkukusaba oose onkoonele, nanga noobahiiye kimui mu̱ghenji̱ wanje Esau kwisa ku̱mpwelekeeleli̱ya na bakali̱ banje hamui na baana banje boona. ");
INSERT INTO tlj_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Bhaatu oosuke ngoku wandaghiisani̱i̱ye kunkola kusemeeya. Waatodha waaghila oti okumpa baasukulu bakaniiye kimui nga musene ghwa ki̱si̱yo kya nanja, niikuwo muntu nʼomui atagubha kubabala.” ");
INSERT INTO tlj_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Yakobbo aamala kilo eki hambali aasabiiye, du̱mbi̱ aakoma mu bisolo biye ebisemeleeye kimui, aabibiikila mu̱ghenji̱ wee Esau nga kisembo kiye. ");
INSERT INTO tlj_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Mu bisolo biye ebi, aamukomelamu mbu̱li̱ 200 syabukali̱ na sinji 20 syabusaasa, ntaama 200 syabukali̱ na sinji 20 syabusaasa, ");
INSERT INTO tlj_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ngamila 30 syabukali̱ hamui na byana byasiyo, nte 40 syabukali̱ na syabusaasa 10, ndogooi̱ syabukali̱ 20 hamui na syabusaasa 10. ");
INSERT INTO tlj_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Bisolo ebi aabiha baheeleli̱ya be. Bu̱li̱ bisolo aabita mu bi̱bbu̱la kusighikila haa mulingo ghwabiyo kandi bu̱li̱ bisolo aabiha mu̱heeleli̱ya oghu akubiloleelela. Du̱mbi̱ aaghila baheeleli̱ya be aba ati, “Mumpikile na bisolo ebi, bhaatu mu̱ti̱ghʼo mwanya haagati ya bu̱li̱ ki̱bbu̱la.” ");
INSERT INTO tlj_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Yakobbo aalaghikiilila oghu akaba abahikiiye ati, “Kaakuba mu̱ghenji̱ wanje Esau akusangaana kandi aku̱bu̱u̱li̱ya ati, ‘Olu̱ghi̱ye ewaa ani̱? Kandi okughenda haa? Ti̱ ni ani̱ mukama wa bisolo ebikuhikiiye ebi?’ ");
INSERT INTO tlj_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Du̱mbi̱ omughile oti, ‘Ni bisembo bya mu̱heeleli̱ya waawe Yakobbo ampaaye ati mbitwalile mukama wee Esau kandi naye niibuwo aasa enu̱ma eghi.’ ” ");
INSERT INTO tlj_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Aatodha aalaghikiilila na waakabili, waakasatu, hamui na boona abaabaagha bakweme bisolo ebi ati, “Naanu nimwanasangaane Esau aliikuwo mwabu̱gha mutiyo dhee.” ");
INSERT INTO tlj_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Kandi mutaabululuwa kumughambila muti, “Mu̱syana waawe Yakobbo naye niibuwo aasa enu̱ma eghi.” Nanga akeeli̱li̱kana ati, “Nku̱dhooti̱ya Esau na bisembo ebi naadu̱bhi̱ye kumusindikila ninaanamuboone kedha kilaleetʼo bu̱si̱nge haagati yaatu.” ");
INSERT INTO tlj_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Du̱mbi̱ baadu̱bha kutwala bisembo ebi Yakobbo aabahaaye, bhaatu eye aati̱ghala enu̱ma syabo hambali baghooneeye, aatodha aalaalamu kilo eki. ");
INSERT INTO tlj_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Bwile obu bwali̱ye mukilo eki kyonini, Yakobbo aatwala bakali̱ be babili, basyana be babili, na baana be eku̱mi̱ nʼomui baabhasuka maasi li̱i̱na lyagho Yabboki̱. ");
INSERT INTO tlj_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Obu aamali̱ye kubabhasu̱ki̱ya maasi, du̱mbi̱ aatwalayo na bintu biye byona. ");
INSERT INTO tlj_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yakobbo aati̱ghala enkaha ebhi̱mba, du̱mbi̱ musaasa omui aatandika kumulwani̱i̱si̱ya ku̱hi̱ki̱ya bwile obu bwakeeye. ");
INSERT INTO tlj_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Obu musaasa oghu aaboone ati taakugubha kulema Yakobbo, aamusobani̱ya kiigembe. ");
INSERT INTO tlj_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Du̱mbi̱ musaasa oghu aaghila ati, “Ngoku bwile bwakeeye, oleke ngende.” Bhaatu Yakobbo aaghila ati, “Tanku̱ku̱si̱i̱mi̱lani̱ya kughenda otakampaaye mu̱gi̱sa.” ");
INSERT INTO tlj_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Musaasa oghu aamu̱bu̱u̱li̱ya ati, “Nuuwe ani̱?” Aamukuukamu ati, “Ni̱i̱syoni Yakobbo.” ");
INSERT INTO tlj_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Du̱mbi̱ musaasa oghu aaghila ati, “Tookutodha kuba Yakobbo bbaa, kuuyʼo balakughilaghamu I̱saaleeli̱, nanga waalwane na Luhanga hamui na bantu, bhaatu waasi̱ngu̱la.” ");
INSERT INTO tlj_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakobbo aaghila ati, “Nanje ongambile li̱i̱na lyawe.” Bhaatu musaasa oghu aaghila ati, “Haabwaki nombu̱u̱li̱ya li̱i̱na lyanje?” Du̱mbi̱ aamuheela mu̱gi̱sa haala hoonini. ");
INSERT INTO tlj_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Du̱mbi̱ Yakobbo aaghila ati, “Dhelu naaboone Luhanga haali̱i̱so, ti̱ naakala ninali mwomi̱i̱li̱!” Du̱mbi̱ ki̱i̱kalo eki aakighilamu “Peneeli̱.” ");
INSERT INTO tlj_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Obu musana ghwatooye, Yakobbo aalu̱gha mu ki̱i̱kalo kya Peneeli̱ eki. Aatandika ku̱sengu̱dha haabwa kiigembe eki baamusobani̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ku̱lu̱gha bwile obu, Banai̱saaleeli̱ tabakuliyagha nyama ya kiigembe, nanga niiyo baasobani̱i̱ye taata wabo Yakobbo eku̱wa lya mu kiigembe. ");
INSERT INTO tlj_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakobbo akaba makalu̱gha mu ki̱i̱kalo eki, aalola elughulu, aabona Esau naasa na basaasa be 400. Du̱mbi̱ aabaghani̱jamu baana be, aabaha Leei̱ya, Lakeeli̱, na banji aabaha basyana be babili, Ji̱li̱pa na Bbi̱i̱la. ");
INSERT INTO tlj_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Aahi̱ki̱li̱ya basyana be na baana baabo, aatʼo Leei̱ya na baana be, du̱mbi̱ Lakeeli̱ na Yojeefu̱ baamaliilila. ");
INSERT INTO tlj_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yakobbo eye eenini aaghenda kwebinga mu̱ghenji̱ wee Esau, obu aamu̱hi̱ki̱yʼo, aagomba hansi milundi musanju̱ naamulamu̱ki̱ya. ");
INSERT INTO tlj_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Bhaatu Esau aali̱gi̱ti̱la kimui kumwebinga, du̱mbi̱ aamughuwa mu ki̱ku̱bha. Kandi bombi baalila. ");
INSERT INTO tlj_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esau aalola elughulu, aabonayʼo baana na bakali̱. Aabu̱u̱li̱ya Yakobbo ati, “Mbaki baabaagha naawe aba?” Yakobbo aamukuukamu ati, “Aba mbaana aba Luhanga, haabwa ngughuma siye, aahaaye mu̱heeleli̱ya waawe Yakobbo.” ");
INSERT INTO tlj_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Du̱mbi̱ baheeleli̱ya baa Yakobbo aba na baana baabo beebinga Esau, baagomba hansi kumulamu̱ki̱ya. ");
INSERT INTO tlj_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Obu aba baamali̱ye, Leei̱ya na baana be nabo baasa, baagomba hansi kulamu̱ki̱ya Esau. Haakumaliilila niibuwo Lakeeli̱ na Yojeefu̱ nabo baasi̱ye dhee, nabo baagomba hansi kumulamu̱ki̱ya. ");
INSERT INTO tlj_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau aabu̱u̱li̱ya ati, “Bintu ebi naaboone oleeti̱ye byona mbyaki?” Yakobbo aamukuukamu ati, “Naakuleeteeye biyo niikuwo ongilile ngughuma, mukama wanje.” ");
INSERT INTO tlj_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Bhaatu Esau aaghila ati, “Si̱ye ndi na bintu bikani̱ye kaana kaa maaha. Webiikile ebi weenini.” ");
INSERT INTO tlj_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakobbo aaghila ati, “Bbaa, nkwesengeleei̱ye, olakaba ongiliiye ngughuma, osi̱i̱me bisembo ebi naakuleeteeye bini. Nanga obu naakuboone, ndi nga muntu naaboone Luhanga eenini haabwa kuntangilila kusemeeye kutiyo. ");
INSERT INTO tlj_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Mukama wanje osi̱i̱me kyona eki naakuleeteeye, nanga nanje Luhanga akangilila ngughuma, ampa kyona eki nkwetaaghisibuwa.” Haabwa kulola ngoku Yakobbo aamuukaliliiye, du̱mbi̱ Esau aasi̱i̱ma bintu ebi. ");
INSERT INTO tlj_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Du̱mbi̱ Esau aaghila ati, “Oleke si̱ye mbahikile, tughende.” ");
INSERT INTO tlj_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yakobbo aaghila ati, “Mukama wanje, omani̱ye ngoku baana bani banali bato, tabakugubha kulubhatanga bwangu-bwangu. Kandi ndi na kuloleelela ntaama na nte esili na byana bito. Ntwanabilubhatangi̱i̱ye bwangu-bwangu, bi̱ku̱kwi̱la kilo kimui. ");
INSERT INTO tlj_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Oleke mukama wanje eye ahikile niikuwo si̱ye ndubhatange bukee-buke, na bisolo byanje hamui na baana banje ku̱hi̱ki̱ya obu nanje ndaku̱ki̱dhʼo mu kyalo kya Seyi̱li̱.” ");
INSERT INTO tlj_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau aaghila ati, “Kwesi̱ oleke nku̱ti̱ghi̱le bamui haa bantu banje.” Yakobbo aamukuukamu ati, “Mukama wanje, eki takikwetaaghisibuwa. Kuuyʼo ongilile ngughuma.” ");
INSERT INTO tlj_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Kilo eki, Esau aatandika lughendo luwe lwa kukuuka mu Seyi̱li̱. ");
INSERT INTO tlj_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Mu ki̱i̱kalo kya Yakobbo kughenda Seyi̱la, aaghenda mu kyalo kya Su̱kooti̱, hambali eekweleeye numba yee na bujalaja bwa bisolo biye. Ki̱i̱kalo eki bakakighilamu Su̱kooti̱. ");
INSERT INTO tlj_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Haakumaliilila, obu Yakobbo aalu̱ghi̱ye Padanalaamu, hambali abaagha aalu̱ki̱ye, aaki̱dha kulungi mu tau̱ni̱ ya Sekeemu mu kyalo kya Kanaani̱, du̱mbi̱ aaghoona haai-haai na tau̱ni̱ eghi. ");
INSERT INTO tlj_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Aaghula kibanja eki aali aakaayemu ewaa batabani̱ baa Hamooli̱, ese wa Sekeemu, na bi̱twi̱ke ki̱ku̱mi̱ bya siliva. ");
INSERT INTO tlj_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Du̱mbi̱ aakwelʼo kyakuhongelʼo bihonguwa, aakiluka li̱i̱na Eli Elohe I̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Bwile obu Dina, muhala wa Leei̱ya oghu Yakobbo aamubyayʼo, aaghenda kubungila bakali̱ baa mu kyalo eki abaabaagha balimu. ");
INSERT INTO tlj_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Obu Sekeemu, mu̱lemi̱ wa mu ki̱twi̱ke eki, mutabani̱ wa Hamooli̱ wa mu ntu̱la ya Bahi̱vi̱, aaboone Dina, aamughwilikiilila, du̱mbi̱ aamuhamba. ");
INSERT INTO tlj_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Obu aamali̱ye kumuhamba, mutima ghuwe ghwabbalila kimui Dina muhala wa Yakobbo, du̱mbi̱ aabu̱gha naye na elaka lya ngonji̱ kandi lyaku̱mu̱tegheeleli̱ya. ");
INSERT INTO tlj_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Du̱mbi̱ Sekeemu aaghenda ewaa ese wee Hamooli̱, aamughila ati, “Tita, ondu̱ghi̱le manaabukali̱ oni.” ");
INSERT INTO tlj_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Obu Yakobbo aaghu̱u̱ye ngoku Sekeemu aabhi̱hi̱i̱ye muhala wee Dina, aaholeli̱ya kimui ku̱hi̱ki̱ya obu batabani̱ be baalu̱ghi̱ye hambali baali̱i̱si̱li̱yagha bisolo. ");
INSERT INTO tlj_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamooli̱ ese wa Sekeemu aaghenda ku̱bu̱gha na Yakobbo haa kintu eki. ");
INSERT INTO tlj_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Obu baana baa Yakobbo baalu̱ghi̱ye mu ku̱li̱i̱si̱ya bisolo, baaghu̱wa ngoku Sekeemu aahambi̱ye mwani̱nabo Dina, baakwatuwa ki̱i̱ni̱gha haabwa Sekeemu kuhamba mwani̱nabo kandi ekitangubhonganuuwe kubʼo mu baana baa I̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Bhaatu Hamooli̱ aaghila ati, “Mutabani̱ wanje Sekeemu eye mutima ghuwe ghwona ghuli haa muhala waanu. Ti̱ muleke amuswele. ");
INSERT INTO tlj_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Muleke tuswele nganda syanu, niikuwo naanu mulaswelagha e syatu. ");
INSERT INTO tlj_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Mwanguukala naatu, nanga kyalo kyatu kikani̱ye. Muli na bughabe bwa kuukala hambali mukabbali̱ye, mukolelemu bu̱su̱u̱bu̱ji̱ kandi mutungilemu bintu bikani̱ye.” ");
INSERT INTO tlj_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Du̱mbi̱ Sekeemu aaghila ese wa Dina hamui na baani̱na wee ati, “Mungilile ngughuma, muleke nswele muhala waanu oghu, ti̱ nanje nkubaha kyona eki mulakabbala. ");
INSERT INTO tlj_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Mu̱ntwi̱le ndu̱ghi̱ hamui na bisembo ebi mukubbala byona, si̱ye nkubaha biyo. Niikuwo naanu mumpe manaabukali̱ oghu abe mukali̱ wanje.” ");
INSERT INTO tlj_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Haabwa kulola ngoku baasangu̱u̱we babhi̱hi̱i̱ye mwani̱nabo Dina, batabani̱ baa Yakobbo aba baakuukamu mbadimaaga Sekeemu hamui na ese wee Hamooli̱. ");
INSERT INTO tlj_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Baaghila bati, “Tatukugubha kukola kintu ngʼeki, kuha mwani̱naatu̱we musaasa oghu batasali̱ye bbaa. Nanga eki kikuba kili kintu kya nsoni̱. ");
INSERT INTO tlj_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Tukubasi̱i̱mi̱lani̱ya kuswela mwani̱naatu̱we nimwanasi̱i̱mi̱ye kuba ngʼatu, musala basaasa boona abali ewaanu. ");
INSERT INTO tlj_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Du̱mbi̱ tukubaha bahala baatu, naatu tuswele bahala baanu. Tukuukala ewaanu, etu̱we boona tufooke muntu omui. ");
INSERT INTO tlj_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Bhaatu nimwanabhengi̱ye kubasala, tukubaayʼo mwani̱naatu̱we du̱mbi̱ tughende.” ");
INSERT INTO tlj_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Du̱mbi̱ Hamooli̱ na Sekeemu baasi̱i̱ma kyeli̱li̱kano kya kusaluwa eki baabaghambiiye. ");
INSERT INTO tlj_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Du̱mbi̱ Sekeemu, oghu baabaagha bahu̱ti̱li̱i̱ye kimui mu lu̱byalo lwa Hamooli̱, eye taagu̱bhi̱ye kubhenga byona ebi baabu̱ghi̱ye, nanga eye akaba adheedheeu̱we haabwa kuswela muhala wa Yakobbo. ");
INSERT INTO tlj_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Du̱mbi̱ Hamooli̱ na mutabani̱ wee Sekeemu baaghenda mu ki̱i̱tu̱u̱bbi̱ ekyabaagha haa mulyango ghwa tau̱ni̱ yʼewaabo kughambila bantu boona. ");
INSERT INTO tlj_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Baaghila bati, “Basaasa bani batubbali̱i̱ye bu̱u̱bhootu̱, oleke baakale mu kyalo kyatu, basuubule kandi batunge bintu nanga tuli na etaka likani̱ye eli bakugubha kuukalamu. Du̱mbi̱ tuswele bahala baabo, nabo baswele bahala baatu. ");
INSERT INTO tlj_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Bhaatu basaasa bani baku̱si̱i̱ma kuukala naatu kaakuba basaasa bʼewaatu boona baasi̱i̱ma kubasala ngoku nabo basalu̱u̱we. ");
INSERT INTO tlj_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Tooboone, ntwanasi̱i̱mi̱ye, bisolo byabo hamui na bintu byabo byona bikuba byatu? Kwesi̱ oleke tubasi̱i̱mi̱lani̱ye niikuwo baakale mu kyalo kyatu.” ");
INSERT INTO tlj_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Basaasa boona abaakalagha mu tau̱ni̱ eghi baasi̱i̱ma ebi Hamooli̱ na mutabani̱ wee Sekeemu baabu̱ghi̱ye. Kandi bu̱li̱ musaasa weena mu tau̱ni̱ eghi aasaluwa. ");
INSERT INTO tlj_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Haanu̱ma ya bilo bisatu basaasa aba batakaki̱li̱ye, Leevi̱ na Si̱mi̱yooni̱, batabani̱ baa Yakobbo, baani̱na Dina, baakwata bihiyo byabo, baaghenda kwegimba mu tau̱ni̱ eghi, bantu baayo batamani̱ye kandi baatayo basaasa boona abaabaagha bali mu tau̱ni̱ eghi. ");
INSERT INTO tlj_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Haanu̱ma ya kwita Hamooli̱ na mutabani̱ wee Sekeemu na kihiyo, du̱mbi̱ baatwala mwani̱nabo Dina. ");
INSERT INTO tlj_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Obu baamali̱ye kwita bantu aba, baahu̱nga bintu byabo mu kibugha eki byona haabwa ki̱i̱ni̱gha kya Sekeemu ku̱bhi̱i̱ya mwani̱nabo. ");
INSERT INTO tlj_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Baatwala bisolo byabo byona na matungo ghaabo, ndogooi̱ syabo, na bu̱li̱ kintu kyona eki baabaagha bali nakiyo mu kibugha na mu misili yabo. ");
INSERT INTO tlj_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Baatwala etungo lyabo lyona, bakali̱ baabo, baana baabo, hamui na byona ebyabaagha mu manumba ghaabo. ");
INSERT INTO tlj_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Du̱mbi̱ Yakobbo aaghila Leevi̱ na Si̱mi̱yooni̱ ati, “Enu̱we mwandeeteeye kasaale kandi mwaleki̱ye Banakanaani̱ na Bapeleeji̱ mu kyalo kini banjoha. Ti̱ mulole etu̱we tuli bakee, bantu aba mbanalungaane kundwani̱i̱si̱ya, si̱ye na ka yanje yoona tu̱ku̱twi̱ka.” ");
INSERT INTO tlj_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Leevi̱ na Si̱mi̱yooni̱ nabo baamukuukamu bati, “Majima kuwo Sekeemu naye angubaaye akoli̱ye atiyo mwani̱naatu̱we nga malaaya?” ");
INSERT INTO tlj_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Kilo kimui Luhanga aaghila Yakobbo ati, “Oghende Bbeteeli̱ aaniiyo waakala kandi okweleyo eki okuhongelʼo bihonguwa byanje, si̱ye Luhanga oghu akakubonekela obu waalukagha wanjoko waawe Esau.” ");
INSERT INTO tlj_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Niibuwo Yakobbo aaghi̱li̱ye bakali̱ be na baana be hamui na boona abaabaagha naye ati, “Mwehiyʼo baaluhanga banji aba muli nabo aba, munaabe mwele kandi mu̱lu̱waale bi̱lu̱walo binji. ");
INSERT INTO tlj_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Du̱mbi̱ mwise tughende tau̱ni̱ ya Bbeteeli̱ hambali nkukwelela Luhanga kyakuhongelʼo bihonguwa, oghu akankoonela obu naabaagha mu kubona-bona kandi oghu aakalagha nanje hoona hambali naakaghendagha.” ");
INSERT INTO tlj_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Niibuwo baahaaye Yakobbo bisasani̱ bya baaluhanga baabo ebi baabaagha nabiyo. Baamuha na manengeniya agha bali balu̱wete haa matui. Aaghajiika hansi mu ki̱i̱looku̱ mu kyalo kya Sekeemu. ");
INSERT INTO tlj_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Obu baamu̱ki̱ye kughenda, Luhanga aaleeteleja bantu bʼomu maatau̱ni̱ agha baasalilaghamu kwobahila kimui, niikuwo atabʼo muntu nʼomui oghu akubakwama kughenda kubakola kubhi. ");
INSERT INTO tlj_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Du̱mbi̱ Yakobbo hamui na bantu boona abaabaagha naye baaki̱dha mu tau̱ni̱ ya Lu̱u̱ji̱ eghi baadu̱bhagha kughilamu Bbeteeli̱ mu nsi ya Kanaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Du̱mbi̱ Yakobbo aakwela mu tau̱ni̱ ya Bbeteeli̱ kyakuhongelʼo Luhanga bihonguwa kandi aakiluka li̱i̱na Eli̱-bbeteeli̱ nanga niiyo Luhanga aamubonekeeye obu aalukagha waani̱na wee Esau. ");
INSERT INTO tlj_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Bwile obu Debbola, oghu akalela Lebbeeka, aaku̱wa, baamujiika eku̱wa ya tau̱ni̱ ya Bbeteeli̱ hansi ya kiti ki̱i̱looku̱. Kiti eki baakiluka li̱i̱na Aloni̱-bbaku̱si̱. ");
INSERT INTO tlj_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Obu Yakobbo aamali̱ye kukuuka mu kyalo kya Padanalaamu, Luhanga aatodha aamubonekela kandi aamuha mu̱gi̱sa. ");
INSERT INTO tlj_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Luhanga aamughila ati, “Li̱i̱na lyawe nuuwe Yakobbo, bhaatu bantu tabakutodha kukughilamu Yakobbo, kuuyʼo nuuwe okuba I̱saaleeli̱.” Du̱mbi̱ aamuluka li̱i̱na lya I̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Du̱mbi̱ Luhanga aamughila ati, “Ndi Luhanga wa Bu̱toki̱ Bwona, obyale baana bakaniiye kimui, baasukulu baawe balifooka mahanga ghakani̱ye kandi bamui mu bo balifooka bakama. ");
INSERT INTO tlj_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Nkukuha kyalo eki naahaaye Ebbulahi̱mu̱ na I̱saka kuba kyawe bilo nʼebilo kandi haanu̱ma yaawe, ndikiha baasukulu baawe.” ");
INSERT INTO tlj_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Du̱mbi̱ Luhanga aalu̱ghʼo Yakobbo, aaghenda. ");
INSERT INTO tlj_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakobbo aasimba mpaghi ya ebaale hambali aabu̱ghi̱i̱ye na Luhanga haala. Aaghiseesʼo kihonguwa kyakunuwa hamui na mafu̱ta kughifoola ya kulamiliyʼo Luhanga. ");
INSERT INTO tlj_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ki̱i̱kalo eki Yakobbo aakighilamu Bbeteeli̱. ");
INSERT INTO tlj_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Du̱mbi̱ baamu̱ki̱ya ku̱lu̱gha Bbeteeli̱. Obu baanaghendagha, hanati̱ghaayʼo lughendo lujambi̱ye ku̱hi̱ka mu kyalo kya Efulaati̱, Lakeeli̱ aakwatuwa ku̱byala. Aaghu̱wa busaali̱ji̱ bukani̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Obu aanalumuwagha, mukali̱ oghu aamu̱byali̱i̱si̱yagha aamughila ati, “Otoobaha, nanga oku̱byala mwana onji wabusaasa.” ");
INSERT INTO tlj_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Obu Lakeeli̱ aaboone naaghenda ku̱ku̱wa, mwana oghu aamuluka li̱i̱na ati niiye Bbenoni̱. Bhaatu ese wee aamuluka li̱i̱na ati niiye Bbenjami̱i̱ni̱. ");
INSERT INTO tlj_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Haanu̱ma obu Lakeeli̱ aaku̱u̱ye, baamujiika mu kihanda ekikughenda Efulaati̱ eghi baaghilaghamu dhee Bbeteleheemu. ");
INSERT INTO tlj_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Haagu̱u̱li̱ ya kituulo eki, Yakobbo aasimbʼo mpaghi. Ti̱ nʼendindi mpaghi eghi enaliyo kwoleka hambali kituulo kya Lakeeli̱ kili. ");
INSERT INTO tlj_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Yakobbo oghu baaghilaghamu I̱saaleeli̱ aatodha aamu̱ki̱ya lughendo luwe, du̱mbi̱ aakwela weema yee luhande lweli̱ lwa ki̱i̱kalo baaghilaghamu Migidaali-eda. ");
INSERT INTO tlj_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Obu Yakobbo aabaagha anaakaaye mu kyalo eki, Leu̱bbeeni̱, omui mu batabani̱ be eku̱mi̱ na babili, aaghenda aalaala na Bbi̱i̱la, mukali̱ wee onji. Yakobbo aakimanya. ");
INSERT INTO tlj_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Baana aba Yakobbo aabyayʼo Leei̱ya niibo bani: Leu̱bbeeni̱ wa mu̱li̱ghaaso, Si̱mi̱yooni̱, Leevi̱, Yu̱da I̱sakaali, hamui na Jabbu̱looni̱. ");
INSERT INTO tlj_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Baana aba Yakobbo aabyayʼo Lakeeli̱ niibo bani: Yojeefu̱ na Bbenjami̱i̱ni̱. ");
INSERT INTO tlj_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Baana aba Yakobbo aabyayʼo Bbi̱i̱la mu̱syana wa Lakeeli̱ niibo bani: Daani̱ na Nafutaali. ");
INSERT INTO tlj_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Baana aba Yakobbo aabyayʼo Ji̱li̱pa mu̱syana wa Leei̱ya niibo bani: Gaadi̱ na Aseli̱. Bani niibo baana baa Yakobbo aabyaye obu aabaagha anali Padanalaamu. ");
INSERT INTO tlj_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakobbo aaghenda ewaabo e ka mu kyalo kya Mami̱le kulola ese wee I̱saka. Kyalo eki endindi bakwete kughilamu Hebbu̱looni̱. Ebbulahi̱mu̱ na I̱saka nabo dhee bakaba mbaakaayʼo mu kyalo eki. ");
INSERT INTO tlj_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","I̱saka aamala myaka 180 ya bukulu. ");
INSERT INTO tlj_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Aaku̱wa akaakuliiye kimui. Batabani̱ be Yakobbo na Esau baamujiika. ");
INSERT INTO tlj_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Bani niibo baasukulu baa Esau oghu baaghilaghamu dhee Edomu. ");
INSERT INTO tlj_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau aaswela bakali̱ basatu ku̱lu̱gha mu bahala baa Banakanaani̱. Aaswela Aada muhala wa Elooni̱ wa mu ntu̱la ya Bahi̱ti̱. Aaswela dhee Aholi̱bbama muhala wa Aana kandi muusukulu wa Ji̱bbi̱yooni̱ wa mu ntu̱la ya Bahi̱vi̱. ");
INSERT INTO tlj_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Aaswela dhee Bbasemaati muhala wa Sumai̱li̱ kandi mwani̱na Nebbayosi̱. ");
INSERT INTO tlj_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Du̱mbi̱ aabyalʼo mukali̱ wee Aada mwana, baamuluka li̱i̱na Elifaaji. Bbasemaati naye aamu̱byalila mwana, baamuluka li̱i̱na Leu̱weli̱. ");
INSERT INTO tlj_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Mukali̱ wee Aholi̱bbama aamu̱byalila baana basatu: Yewusi, Yalaamu, na Koola. Aba niibo baana baa Esau aabyaye anali mu kyalo kya Kanaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau aatwala bakali̱ be, baana be, bantu baa ka yee boona, bisolo biye, hamui na bintu biye byona abe aabaagha nabiyo, mu kyalo kya Kanaani̱ aaku̱lu̱ki̱la mu kyalo kinji ati niikuwo haselanʼo na waani̱na wee Yakobbo. ");
INSERT INTO tlj_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Esau akaku̱u̱lu̱ka nanga bintu byabo hamui na bisolo ebi baabaagha bali nabiyo bikaba bikaniiye kimui, kyalo eki baabaaghamu takyagubhagha kumala bintu ebi haabwa kuba kikee. ");
INSERT INTO tlj_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Nahabweki Esau, oghu baaghilaghamu Edomu, aaghenda kuukala mu kyalo kya bwena kya Seyi̱li̱. ");
INSERT INTO tlj_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Bani niibo baasukulu baa Esau ese wa Banʼedomu, abaabaagha baakaaye mu kyalo kya bwena kya Seyi̱li̱. ");
INSERT INTO tlj_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Mali̱i̱na ghaa batabani̱ baa Esau niigho ghani: Elifaaji, oghu aabyayʼo Aada, na Leu̱weli̱, oghu aabyayʼo Bbasemaati. ");
INSERT INTO tlj_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Na batabani̱ baa Elifaaji niibo bani: Temaani, Omala, Jeefo, Gataamu, na Kenaji̱. ");
INSERT INTO tlj_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifaaji akaba ali na mukali̱ onji mbamughilamu Timuna, aamu̱byalʼo Amaleeki̱. Aba niibo baasukulu baa Esau haa lubalu̱ lwa mukali̱ wee Aada. ");
INSERT INTO tlj_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Na batabani̱ baa Leu̱weli̱ niibo bani: Nahasi, Jeela, Saama, na Miija, aba niibo baasukulu baa Esau haa lubalu̱ lwa mukali̱ wee Bbasemaati. ");
INSERT INTO tlj_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Baana aba Esau aabyayʼo mukali̱ wee Aholi̱bbama muhala wa Aana kandi muusukulu wa Ji̱bbi̱yooni̱ niibo bani: Yewusi, Yalaamu, na Koola. ");
INSERT INTO tlj_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Buni niibuwo bu̱tu̱la obwalu̱ghi̱ye mu baasukulu baa Esau. Haa lubalu̱ lwa mukali̱ wee Aada, haa batabani̱ baa mu̱li̱ghaaso ghuwe Elifaaji hakalu̱ghamu ntu̱la sini: ntu̱la ya Temaani, ntu̱la ya Omala, ntu̱la ya Jeefo, ntu̱la ya Kenaji̱, ");
INSERT INTO tlj_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ntu̱la ya Koola, ntu̱la ya Gataamu, na ntu̱la ya Amaleeki̱. Aba niibo baabaagha balemi̱ baasukulu baa ntu̱la ya Elifaaji wamu kyalo kya Edomu. Bakaba bali baasukulu baa Aada. ");
INSERT INTO tlj_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Na baana baa mutabani̱ wa Esau Leu̱weli̱, balemi̱ niibo bani: Nahasi, Jeela, Saama, na Miija. Bakaba bali balemi̱, bali baasukulu baa Leu̱weli̱ wa mu kyalo kya Edomu. Bakaba bali baasukulu baa Bbasemaati mukali̱ wa Esau. ");
INSERT INTO tlj_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Kandi na baana baa Aholi̱bbama, mukali̱ wa Esau kandi muhala wa Aana, abaalu̱ghi̱ye mu bu̱tu̱la niibo bani: Yewusi, Yalaamu, na Koola. ");
INSERT INTO tlj_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Aba niibo baabaagha batabani̱ baa Esau oghu baaghilaghamu Edomu kandi aba niibo baalu̱ghi̱yemu bu̱tu̱la. ");
INSERT INTO tlj_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Bani niibo batabani̱ baa Seyi̱li̱ wa mu ntu̱la ya Bahooli̱, abaakalagha mu kyalo kya Edomu: Lotaani̱, Sobbali, Ji̱bbi̱yooni̱, Aana, ");
INSERT INTO tlj_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Di̱sooni̱, Eeja, na Disaani̱. Aba niibo baabaagha batabani̱ baa Seyi̱li̱ wa mu ntu̱la ya Bahooli̱ mu kyalo kya Edomu kandi abaalu̱ghi̱yemu bu̱tu̱la. ");
INSERT INTO tlj_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Na baana baa Lotaani̱ niibo bani: Hooli̱ na Hemaani̱. Bhaatu Timuna eye akaba ali mwani̱na Lotaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Kandi batabani̱ baa Sobbali niibo bani: Alivani, Manahasi, Ebbali, Seefo, na Onamu. ");
INSERT INTO tlj_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Na batabani̱ baa Ji̱bbi̱yooni̱ niibo bani: Ai̱ha na Aana. Kandi Aana oni niiye oghu akajoola maasi ghatu̱u̱mi̱ye aghaalu̱ghagha eku̱li̱mu̱ mu elungu obu aali̱i̱si̱yagha ndogooi̱ sya ese wee Ji̱bbi̱yooni̱. ");
INSERT INTO tlj_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Kandi baana baa Aana niibo bani: Di̱sooni̱ na Aholi̱bbama muhala wa Aana. ");
INSERT INTO tlj_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Baana baa Di̱sooni̱ niibo bani: Hemudaani̱, Esubbaani̱, I̱si̱laani̱, na Kelaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Na baana baa Eeja niibo bani: Bbi̱li̱hani̱, Javaani̱, na Akani̱. ");
INSERT INTO tlj_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Baana baa Disaani̱ niibo bani: U̱ji̱ na Alaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Kandi abaalu̱ghi̱yemu bu̱tu̱la bunji mu ntu̱la ya Bahooli̱ obu baamali̱ye kwebaghani̱ja mu kyalo kya Seyi̱la niibo bani: Lotaani̱, Sobbali, Ji̱bbi̱yooni̱, Aana, ");
INSERT INTO tlj_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Di̱sooni̱, Eeja, na Disaani̱, aba niibo balemi̱ ntu̱la ya Bahooli̱, abalabhiililaane mu̱lemi̱ haa mu̱lemi̱ mu kyalo kya Seyi̱li̱. ");
INSERT INTO tlj_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Bani niibo bakama abaadu̱bhi̱ye kulema kyalo kya Edomu atakabaayʼo mukama weena ku̱lu̱gha mu bantu baa I̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bbeela mutabani̱ wa Bbeyola niiye akaba mukama wʼoku̱du̱bha mu kyalo kya Edomu, na tau̱ni̱ yee eghi aabaagha alemi̱ye baaghighilaghamu Dinahabba. ");
INSERT INTO tlj_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Obu Bbeela aaku̱u̱ye, Yobbaabbu mutabani̱ wa Jeela ku̱lu̱gha mu kyalo kya Bbojila aakuuka mu ki̱i̱kalo kiye. ");
INSERT INTO tlj_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Obu Yobbaabbu aaku̱u̱ye, Husaamu ku̱lu̱gha mu kyalo kya Batemaani̱ aakuuka mu ki̱i̱kalo kiye. ");
INSERT INTO tlj_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Obu Husaamu aaku̱u̱ye, Hadaadi̱ mutabani̱ wa Bbedaadi̱, oghu akasi̱ngu̱la Banami̱di̱yaani̱ mu kyalo kya Mowaabu, aakuuka mu ki̱i̱kalo kiye. Na tau̱ni̱ eghi aabaagha alemi̱ye baaghighilaghamu Avisi. ");
INSERT INTO tlj_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Obu Hadaadi̱ aaku̱u̱ye, Samula ku̱lu̱gha mu tau̱ni̱ ya Masileka aakuuka mu ki̱i̱kalo kiye. ");
INSERT INTO tlj_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Obu Samula aaku̱u̱ye, Sau̱li̱ ku̱lu̱gha mu kyalo kya Lehobboti̱ ekyabaagha haa maasi ghaanamu̱li̱to aakuuka mu ki̱i̱kalo kiye. ");
INSERT INTO tlj_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Obu Sau̱li̱ naye aaku̱u̱ye, Bbaali̱-hanaani̱ mutabani̱ wa Akibbola aakuuka mu ki̱i̱kalo kiye. ");
INSERT INTO tlj_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Obu Bbaali̱-hanaani̱ mutabani̱ wa Akibbola aaku̱u̱ye, Hadala aakuuka mu ki̱i̱kalo kiye, na kibugha eki aabaagha alemi̱ye baakighilaghamu Paau, na mukali̱ wee baamughilaghamu Mehetabbeeli̱, muhala wa Mati̱leedi̱ kandi Mati̱leedi̱ ali muhala wa Majehaabbu. ");
INSERT INTO tlj_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Kandi bani niibo baalu̱ghi̱yemu bu̱tu̱la mu baasukulu baa Esau kusighikila haa bu̱tu̱la hamui na byalo ebi baalu̱ghi̱yemu: Timuna, Aluva, Yeseesi̱, ");
INSERT INTO tlj_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Aholi̱bbama, Eela, Pi̱nooni̱, ");
INSERT INTO tlj_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaji̱, Temaani, Mi̱bbu̱jala, ");
INSERT INTO tlj_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magi̱dyeli̱, na Ilaamu. Aba niibo baalu̱ghi̱yemu bu̱tu̱la mu kyalo kya Edomu kusighikila mu njikala yabo kandi boona balu̱ghi̱ye mu baasukulu baa Esau. ");
INSERT INTO tlj_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakobbo aakala mu kyalo kya Kanaani̱ hambali ese wee aabaagha aakaaye. ");
INSERT INTO tlj_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Kandi eni niiyo nsoboolola ya Yakobbo na baana be. Obu Yojeefu̱ aahi̱ki̱i̱ye myaka 17 ya bukulu, aatandika kughenda ku̱li̱i̱si̱ya bu̱hi̱yo bwa bisolo bya ese wee, ali hamui na baghenji̱ be batabani̱ baa baka ese wee Bbi̱i̱la na Ji̱li̱pa. Bwile bunji Yojeefu̱ aaghambilagha ese wee bintu bi̱bhi̱i̱hi̱ye ebi baghenji̱ be aba baakolagha. ");
INSERT INTO tlj_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yakobbo akaba aku̱ndi̱ye kimui Yojeefu̱ kusaali̱ya baana be boona, nanga niiye mwana oghu aabyaye mu bukulu buwe. Aamukolela nkanji̱ esemeleeye kimui. ");
INSERT INTO tlj_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Obu baana baa ni̱na Yojeefu̱ baaboone ngoku esebo amu̱ku̱ndi̱ye kusaali̱ya ebo, du̱mbi̱ baamwohela kimui kandi tabaamu̱bu̱ghi̱lagha kighambo kyona kisemeeye. ");
INSERT INTO tlj_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Kilo kimui Yojeefu̱ aaloota kilooto. Obu aaghambiiye baghenji̱ be aba ebi aalooti̱ye, beeyongelela kimui kumwoha. ");
INSERT INTO tlj_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yojeefu̱ aaghila baghenji̱ be aba ati, “Mu̱tegheeleli̱ye kilooto eki naalooti̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Twabaagha tuli mu musili ntuboha bibha bya ngano, kusa kibha kyanje kyemilila, du̱mbi̱ bibha byanu byona byasa byeli̱ghi̱i̱li̱li̱ya kyanje kandi byatandika kugomba mbi̱ki̱hu̱ti̱ya.” ");
INSERT INTO tlj_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Baana baa ni̱na wee baamukuukamu bati, “Buuye uwe okubbala kuba mukama waatu? Kandi majima kuwo okubbala kutulema?” Du̱mbi̱ beeyongelela kimui kumwoha haabwa ndooti̱ yee eghi hamui na bighambo ebi aabu̱ghi̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Bwile bunji aaloota kilooto kinji, na ebi aalooti̱ye aabighambila baghenji̱ be ati, “Mu̱tegheeleli̱ye, naatodhi̱ye naaloota kilooto kinji. Dhelu buni musana, kweli̱, na nsooli̱ya eku̱mi̱ nʼemui nasiyo syagomba ewanje.” ");
INSERT INTO tlj_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Obu aaghambiiye ese wee dhee ebi aalooti̱ye, du̱mbi̱ ese wee aamutanuka, aamughila ati, “Eki nkilooto kya mulingo ki walooti̱ye? Buuye okumani̱i̱si̱ya oti si̱ye so waawe, njoko waawe, na baana baa njoko waawe ni̱i̱tu̱we tukwisa kukugombela?” ");
INSERT INTO tlj_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Baana baa ni̱na Yojeefu̱ baamughilila etima likani̱ye, bhaatu ese wee aakala naaneeli̱li̱kana haa ndooti̱ esi. ");
INSERT INTO tlj_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Kilo kimui obu baana baa ni̱na Yojeefu̱ baaghendi̱ye ku̱li̱i̱si̱ya bu̱hi̱yo bwa bisolo bya esebo haai na kyalo kya Sekeemu, ");
INSERT INTO tlj_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Yakobbo aabilikila Yojeefu̱ aamughila ati, “Omani̱ye ngoku baghenji̱ baawe baghendi̱ye ku̱li̱i̱si̱ya mu kyalo ekili haai na Sekeemu, nkubbala kukutuma hambali bali.” Yojeefu̱ aasi̱i̱ma kughendayo. ");
INSERT INTO tlj_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Yakobbo aamughila ati, “Oghende olole bu̱hi̱yo obu hamui na baghenji̱ baawe boona balakaba bali kulungi ti̱ wiise ongambile.” Du̱mbi̱ aamutuma ku̱lu̱gha mu kighona kya Hebbu̱looni̱ hambali baabaagha baakaaye, kughenda Sekeemu. Obu Yojeefu̱ aaki̱dhi̱yeyo, ");
INSERT INTO tlj_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","musaasa omui aamubona naalolakaka mu kisaka aamu̱bu̱u̱li̱ya ati, “Mbiki okubbala?” ");
INSERT INTO tlj_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Aamukuukamu ati, “Nkubbala baghenji̱ banje. Wangungambila hambali bakwete ku̱li̱i̱si̱li̱ya bu̱hi̱yo bwabo?” ");
INSERT INTO tlj_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Musaasa oghu aamukuukamu ati, “Hani bakalu̱ghʼo, bhaatu nkaaghu̱wa mbaghila bati bakaghenda mu kyalo kya Dosani.” Du̱mbi̱ Yojeefu̱ aabakwama, aabasanga mu kyalo kya Dosani eki. ");
INSERT INTO tlj_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Bhaatu obu baamuboone anaseli̱ye, baatandika kughila bati, “Oleke aase niikuwo tumwite.” ");
INSERT INTO tlj_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Baatodha baghambilangana bati, “Olole, munakuloota ngughu aasi̱ye, ");
INSERT INTO tlj_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","mwise tumwite, tumukube mu kimui haa bi̱i̱na bini niikuwo tulaghila tuti binyama niibiyo byamuliiye. Ti̱ tulole ekilalu̱gha mu bilooto biye ebi.” ");
INSERT INTO tlj_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Obu Leu̱bbeeni̱ aaghu̱u̱ye, aalengʼo kumukoonela naaghila ati, “Bhaawai̱ tutamwita.” ");
INSERT INTO tlj_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Leu̱bbeeni̱ aatodha aaghila ati, “Mutamumalʼo, kuuyʼo mumukube mu ki̱i̱na kini mu elungu muni, bhaatu mutamuhuula.” Leu̱bbeeni̱ aabu̱gha ebi kumukoonela ati batamwita kuuyʼo amu̱ku̱u̱ki̱ye ewaa ese wee. ");
INSERT INTO tlj_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Du̱mbi̱ obu Yojeefu̱ aabaki̱dhi̱yʼo, baamu̱tu̱u̱bbu̱lamu nkanji̱ yee eghi esemeleeye kimui eghi aabaagha alu̱wete, ");
INSERT INTO tlj_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","baamutwala, baamukuba mu ki̱i̱na. Bhaatu ki̱i̱na eki kikaba kitalimu kantu koona bbaa. ");
INSERT INTO tlj_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Obu baasitami̱ye kuliya byokuliya byabo, baabona ki̱bbu̱la kya bantu baa mu ntu̱la ya Banasumai̱li̱ mbalu̱gha mu kyalo kya Gi̱li̱yaadi̱. Bakaba bali na ngamila syabo si̱heeki̱ye bintu bisasi̱ye, mubaji̱, na miila mbabitwala eku̱wa ya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yu̱da aaghila baghenji̱ be ati, “Tukughobʼo ki ntwati̱ye mu̱ghenji̱ waatu kandi tu̱swi̱ki̱la saghama yee?” ");
INSERT INTO tlj_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Du̱mbi̱ baaghambilana bati, “Mwise tu̱mu̱ghu̱li̱ye Banasumai̱li̱ bani, bhaatu tutamuhuula, kyʼoku̱du̱bha ni lughanda lwatu eenini kandi waani̱naatu̱we.” Du̱mbi̱ baghenji̱ be aba boona baasi̱i̱ma. ");
INSERT INTO tlj_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Obu baghu̱li̱ baasi̱ye ku̱lu̱gha mu Mi̱di̱yaani̱, du̱mbi̱ baghenji̱ be baamubhula mu ki̱i̱na omu, baamu̱ghu̱li̱ya mu Banasumai̱li̱ bi̱twi̱ke maku̱mi̱ abili bya siliva, du̱mbi̱ Banasumai̱li̱ aba baamutwala Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Obu Leu̱bbeeni̱ aaku̱u̱ki̱ye haa ki̱i̱na haala naasanga Yojeefu̱ atalimu, eetemuulila ngoye haa mubili kwoleka ngoku aali asaliiwe. ");
INSERT INTO tlj_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Aakuuka mu baghenji̱ be ati, “Buuye mutabhana nga atalimu, ngende mmubbalile haa?” ");
INSERT INTO tlj_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Du̱mbi̱ baasala mbu̱li̱, baaleeta saghama yayo baaghiseesangilila haa nkanji̱ ya Yojeefu̱. ");
INSERT INTO tlj_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Baatwala nkanji̱ eghi ewaa esebo baamughila bati, “Twasangaane nkanji̱, oghilole kulungi niikuwo omanye elakaba eli ya mwana waawe Yojeefu̱.” ");
INSERT INTO tlj_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Aaghimaniilila, du̱mbi̱ aaghila ati, “Eni majima kuwo ni nkanji̱ ya mwana wanje! Kinyama kya mu kisaka kyamwi̱ti̱ye. Ee, mutabani̱ wanje Yojeefu̱ kisolo kyamutemanguuyemu buhande-hande!” ");
INSERT INTO tlj_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Du̱mbi̱ Yakobbo eetemangulila ngoye haa mubili, aalu̱wala ngoye sya bujune, eeghungila mutabani̱ wee oghu kumala bilo bikani̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Batabani̱ be na bahala be boona baasa ku̱mu̱hu̱u̱mu̱li̱ya, bhaatu eye aabhengela kimui kuleka. Du̱mbi̱ aaghila ati, “Bbaa, nkuukala nineeghu̱ngi̱ye ku̱hi̱ki̱ya nanje obu ndi̱ku̱wa niikuwo ngende hambali mwana wanje aaghendi̱ye.” Niibuwo eeyongeleeye kimui kweghunga na kulila haabwa mutabani̱ wee Yojeefu̱. ");
INSERT INTO tlj_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Bhaatu basu̱u̱bu̱ji̱ aba abaatwete Yojeefu̱, bakaghenda baamu̱ghu̱li̱ya ewaa Poti̱i̱fa omui mu bakulu mu bukama bwa Falaaho kandi oghu akaba ali mukulu wa abaalindagha Falaaho. ");
INSERT INTO tlj_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Bwile obu, Yu̱da aalu̱ghʼo baghenji̱ be, aaghenda kuukala na musaasa wa mu ntu̱la ya Adulaamu oghu baaghilaghamu Hiila. ");
INSERT INTO tlj_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Yu̱da aabonayo mukali̱, muhala wa Banakanaani̱ li̱i̱na liye Suha, aamuswela. ");
INSERT INTO tlj_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Mukali̱ oghu aaku̱li̱ya, aabyala mwana wabusaasa, Yu̱da aamuluka li̱i̱na Eli̱. ");
INSERT INTO tlj_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Mukali̱ oghu aatodha aaku̱li̱ya, aabyala mwana onji wabusaasa dhee, aamuluka li̱i̱na Onani. ");
INSERT INTO tlj_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Aatodha aabyala mwana onji wabusaasa, aamuluka li̱i̱na Seela. Bwile obu, Yu̱da na mukali̱ wee Suha baali baakaaye mu kyalo kya Kejibbu̱. ");
INSERT INTO tlj_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yu̱da aaswelela mutabani̱ wee Eli̱ mukali̱, li̱i̱na liye Tamaali̱. ");
INSERT INTO tlj_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Bhaatu Eli̱, mu̱li̱ghaaso ghwa Yu̱da, akaba ali mu̱si̱i̱si̱ mu maaso ghaa Mukama, du̱mbi̱ Mukama aamwita. ");
INSERT INTO tlj_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Du̱mbi̱ Yu̱da aaghila mutabani̱ wee Onani ati, “Oghende olangaale na mukaa wanjoko waawe, omuswele niikuwo obyalile wanjoko waawe baana.” ");
INSERT INTO tlj_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onani aakimanya ati nankabha abyalʼo mukali̱ oghu baana, tabakuba be bbaa. Akaghendagha kulangaala na mukali̱ oghu, aakala kuta nsigho yee hansi ati niikuwo atabyalila waani̱na wee baana. ");
INSERT INTO tlj_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Kandi eki aakoli̱ye eki kyasaalila Mukama, naye Mukama aamwita dhee. ");
INSERT INTO tlj_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Niibuwo Yu̱da aaghi̱li̱ye mugholi wee Tamaali̱ ati, “Oghende, ookale ewaanu nga mu̱kwi̱si̱ya ku̱hi̱ki̱ya obu mutabani̱ wanje Seela alakakula.” Aabu̱gha atiyo haabwa kwobaha ati kedha Seela angu̱ku̱wa ngoku baghenji̱ be baaku̱u̱ye. Du̱mbi̱ Tamaali̱ aaghenda aakala ewaabo. ");
INSERT INTO tlj_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Haanu̱ma ya bwile bukani̱ye, mukaa Yu̱da, muhala wa Suha, aaku̱wa. Obu Yu̱da aamali̱ye kunaaba mukali̱ wee oghu, aaghenda na bhootu̱ siye Hiila wa mu ntu̱la ya Adulaamu, mu kyalo kya Temina hambali basaasa abaaghembagha ntaama siye byoha baakalagha. ");
INSERT INTO tlj_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Obu Tamaali̱ aaghu̱u̱ye ngoku esebyala wee Yu̱da alimaghenda mu kyalo kya Temina kughemba ntaama siye byoha, ");
INSERT INTO tlj_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","eetu̱u̱bbu̱lamu ngoye sya bu̱kwi̱si̱ya esi aakalagha alu̱wete. Du̱mbi̱ aalu̱wala ngoye sinji, aatodha eeswi̱ki̱li̱la lunji, aasitama mu elembo lya tau̱ni̱ ya Enai̱mu̱ mu kihanda ekyaghendagha mu kyalo kya Temina. Akakola eki haanu̱ma ya kubona ati Seela oghu baamulaghi̱i̱sani̱i̱ye kumuswela aamali̱ye kukula, bhaatu tabakaghi̱li̱ye bati amuswele. ");
INSERT INTO tlj_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Obu Yu̱da aamuboone, aamanya ati ni malaaya haabwa kweswi̱ki̱la haali̱i̱so. ");
INSERT INTO tlj_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Haabwa kutamanya ngoku ali mugholi wee, aaghenda hambali aabaagha ali mu maakpengbu̱ ghaa luguudhe, aamughila ati, “Nkubbala kulangaala naawe.” Mugholi wee aamukuukamu ati, “Buuye nuuwalangaaye nanje, mbiki okumpa?” ");
INSERT INTO tlj_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yu̱da aamughila ati, “Nkukuha kyana kya mbu̱li̱ ku̱lu̱gha mu etungo lyanje.” Mugholi wee aamukuukamu ati, “Buuye ni musimbo ki oku̱nti̱ghi̱la ku̱hi̱ki̱ya oleeti̱ye mbu̱li̱ eghi?” ");
INSERT INTO tlj_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Aamukuukamu ati, “Buuye nku̱ti̱ghi̱le musimbo ki?” Tamaali̱ aamukuukamu ati, “Onti̱ghile mpete eghi eliyo li̱i̱na lyawe, na kaghuwo kaayo akali mu bikiya byawe, hamui na mwi̱gho okwete mu ngalo oghu.” Yu̱da aasi̱i̱ma kumuha biyo, du̱mbi̱ aalangaala naye, du̱mbi̱ mukali̱ oghu aaku̱li̱ya. ");
INSERT INTO tlj_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Obu mukali̱ oghu aalu̱ghi̱ye haala, eetu̱bbu̱la ngoye esi aabaagha alu̱wete, aatodha aalu̱wala ngoye sya bu̱kwi̱si̱ya. ");
INSERT INTO tlj_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Du̱mbi̱ Yu̱da aatuma bhootu̱ siye Hiila kutwalila mukali̱ oghu mbu̱li̱ eghi baalaghaane niikuwo aayeyo musimbo oghu aati̱ghi̱yeyo. Bhaatu Hiila obu aaki̱dhi̱yeyo, atasangayo mukali̱ oghu. ");
INSERT INTO tlj_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Du̱mbi̱ aabu̱u̱li̱ya bantu abaakalaghʼo ati, “Malaaya oghu akuukalagha haa elembo lya tau̱ni̱ ya Enai̱mu̱ ali haa?” Baamukuukamu bati, “Hani taaliyo malaaya nʼomui bbaa.” ");
INSERT INTO tlj_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Du̱mbi̱ Hiila aakuukayo, aaghila Yu̱da ati, “Tanaamusangi̱yʼo, kuuyʼo naasangi̱yʼo bantu abakuukalaghʼo, bangila bati taaliyo malaaya weena oghu aakuukalaghʼo bbaa.” ");
INSERT INTO tlj_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Du̱mbi̱ Yu̱da aaghila ati, “Oleke aakale na bintu ebi naamu̱ti̱ghi̱i̱ye, nanga bantu mbaakimani̱ye, batusekeelela. Olole naali nku̱tu̱mi̱ye kumusasula, bhaatu tawamusangi̱yʼo.” ");
INSERT INTO tlj_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Haanu̱ma ya meeli̱ asatu, muntu aaghambila Yu̱da ati, “Mugholi waawe Tamaali̱ aabaaye malaaya kandi aku̱li̱i̱ye.” Yu̱da aaghila ati, “Mumuleete, bamwoki̱ye aku̱we.” ");
INSERT INTO tlj_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Obu banamutwalagha, aatu̱mi̱i̱si̱ya makulu ewaa esebyala wee naaghila ati, “Mukama wa bintu bini ebi ndi nabiyo, niiye akampa etundu lini.” Aatodha aaghila ati, “Olole kandi omaaniilile mpete eghi na kaghuwo kaayo na mwi̱gho ni bintu bya ani̱?” ");
INSERT INTO tlj_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yu̱da aamaniilila bintu ebi, du̱mbi̱ aaghila ati, “Mukali̱ oghu aabu̱ghi̱ye majima kandi eki aakoli̱ye ki̱hi̱ki̱ye. Nanga nkeelaghi̱i̱sani̱ya kumuha mutabani̱ wanje Seela kumuswela, bhaatu ntaamuha mukali̱ oghu kumuswela.” Du̱mbi̱ Yu̱da taatodhi̱ye alangaala naye bbaa. ");
INSERT INTO tlj_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Obu bwile buwe bwa ku̱byala bwahi̱ki̱ye, aabyala balongo. ");
INSERT INTO tlj_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Obu aatandi̱ki̱ye kulumuwa, mwana omui aatwesi̱yayo mukono ghumui, du̱mbi̱ mukali̱ oghu aamu̱byali̱i̱si̱yagha aamuboha kahu̱u̱ji̱ kaamutuku haa mukono, naaghila ati, “Oni niiye aadu̱bhi̱ye ku̱byaluwa.” ");
INSERT INTO tlj_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Bhaatu obu mwana oni aatodhi̱ye ku̱ku̱u̱ki̱yayo mukono ghuwe, waani̱na wee aabyaluwa, du̱mbi̱ mukali̱ oghu ababyali̱i̱si̱yagha aaghila ati, “Olole ngoku mwetambu̱lani̱i̱yemu.” Du̱mbi̱ mwana oghu baamuluka li̱i̱na Peleeji̱. ");
INSERT INTO tlj_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Na waani̱na wee oghu baabohi̱ye kahu̱u̱ji̱ kaamutuku naye aabyaluwa, du̱mbi̱ baamuluka li̱i̱na bati niiye Jeela. ");
INSERT INTO tlj_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Niibuwo Banasumai̱li̱ aba baatwete Yojeefu̱ e Mi̱si̱li̱. Poti̱i̱fa, omui mu bakulu mu bukama bwa Falaaho kandi oghu akaba ali mukulu wa abaalindaghayo, aaghula Yojeefu̱ mu Banasumai̱li̱ aba. ");
INSERT INTO tlj_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Mukama aakala na Yojeefu̱ kandi aamuha mu̱gi̱sa mu bu̱li̱ kintu kyona eki aakolagha mu numba ya mukama wee Munami̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Obu mukama wee aaboone ngoku Mukama ali naye kandi akumuhaagha mu̱gi̱sa mu bu̱li̱ kintu kyona eki akukolagha, ");
INSERT INTO tlj_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","aamukundila kimui, du̱mbi̱ aamufoola mu̱heeleli̱ya wee oghu eesi̱ghi̱ye. Kandi amuha bu̱toki̱ kulema ka yee na bintu biye byona ebi aabaagha nabiyo. ");
INSERT INTO tlj_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ku̱lu̱gha bwile obu Yojeefu̱ aafookeeyemu mukulu wa bintu bya Poti̱i̱fa byona, na kulema ka yee, Mukama aaha Poti̱i̱fa mu̱gi̱sa mu bintu biye bya mu numba hamui na misili yee yoona haabwa Yojeefu̱. ");
INSERT INTO tlj_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Niibuwo Poti̱i̱fa aakwati̱i̱ye Yojeefu̱ bu̱li̱ kintu kyona eki aabaagha nakiyo, aaleka kufuwʼo bintu ebi kuuyʼo byokuliya ebi aaliyagha byonkaha. Yojeefu̱ akaba ali musaasa asemeleeye kimui. ");
INSERT INTO tlj_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Mukali̱ wa mukama wee aakala kumwekumbula. Kilo kimui, mukali̱ wa mukama wee oghu aamughila ati, “Oose olangaale nanje.” ");
INSERT INTO tlj_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Bhaatu Yojeefu̱ aabhenga, aaghila ati, “Si̱ye bbaa, nanga mukama wanje akanfoola mukulu wa bintu biye byona, ti̱ olole, taafu̱u̱yʼo bintu ebi byona, bhaatu akaneesigha, aaghila ati mbileme byona. ");
INSERT INTO tlj_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Taaliyo muntu onji wamaani̱ mu maka ghe nganje. Ti̱ olole, taaliyo kintu kyona eki mukama wanje aanu̱mi̱ye mu maka muni kuuyʼo uwe wenkaha, nanga oli mukali̱ wee. Buuye si̱ye nkugubha nti̱ya kukola kintu kibhi nga eki mu maaso ghaa Luhanga?” ");
INSERT INTO tlj_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Nankabha mukali̱ oghu naakalagha naanabu̱gha atiyo, bhaatu Yojeefu̱ aabhengela kimui kulangaala naye kedha kuukala hamui naye. ");
INSERT INTO tlj_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Kilo kimui, Yojeefu̱ aataaha mu numba kukolamu milimo yee, aasanga mu̱koli̱ nʼomui atalimu. ");
INSERT INTO tlj_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Du̱mbi̱ mukali̱ wa mukama wee oghu aabhula kooti̱ eghi Yojeefu̱ aabaagha alu̱wete naaghila ati, “Wiise olangaale nanje!” Bhaatu Yojeefu̱ aati̱gha kooti̱ eghi mu ngalo sya mukali̱ oghu, aatuwa mu numba naali̱gi̱ta. ");
INSERT INTO tlj_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Obu mukali̱ oghu aaboone Yojeefu̱ aamu̱ti̱ghi̱ye kooti̱ yee mu ngalo kandi aahu̱ndi̱ye mu numba, ");
INSERT INTO tlj_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","aabilikila bakoli̱ banji. Aabaghila ati, “Mulole kooti̱ eni, bakatuleetela Muhebbulaayo oni kwisa kutudhomadhomi̱ya! Aabaagha antaahiliiye mu kisiika ati alangaale nanje, bhaatu naatakangana. ");
INSERT INTO tlj_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Obu aaghu̱u̱ye nintakangana, niibuwo aali̱gi̱ti̱ye naati̱ghali̱ya kooti̱ yee eni.” ");
INSERT INTO tlj_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Mukali̱ oghu aakala anabi̱i̱ki̱ye kooti̱ eghi ku̱hi̱ki̱ya obu bali̱i̱ wee aaki̱dhi̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Du̱mbi̱ aatandika kumusoboolola ati, “Mu̱koli̱ waawe Muhebbulaayo oghu waaleeti̱ye hani aabaagha antaahiliiye mu kisiika ati alangaale nanje. ");
INSERT INTO tlj_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Bhaatu obu naakatangaane, du̱mbi̱ aali̱gi̱ta, aatuwa mu numba, aati̱ghamu kooti̱ yee eni.” ");
INSERT INTO tlj_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Poti̱i̱fa aasaaliluwa obu aaghu̱u̱ye makulu agha mukali̱ wee akwete kumughambila ngoku Yojeefu̱ aamu̱koli̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Du̱mbi̱ aakwata Yojeefu̱, aamutwala mu nkomo hambali baabohelagha banyankomo baa mukama Falaaho. Bhaatu Yojeefu̱ anali mu nkomo omu, ");
INSERT INTO tlj_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Mukama aakala anali naye, aamughilila ngughuma, aaleka mu̱li̱ndi̱ wa banyankomo oghu aamukundila kimui. ");
INSERT INTO tlj_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Du̱mbi̱ mu̱li̱ndi̱ wa banyankomo oghu aakoma Yojeefu̱ kuba mukulu wa banyankomo boona na kuloleelela bu̱li̱ kintu eki baakolaghayo. ");
INSERT INTO tlj_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Mu̱li̱ndi̱ wa banyankomo oghu aaleka kufuwʼo bintu byona ebi aahaaye Yojeefu̱ kulema, nanga Mukama akaba ali na Yojeefu̱ kandi aamuhaaye mu̱gi̱sa mu bu̱li̱ kintu kyona eki aakakolagha. ");
INSERT INTO tlj_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Haanu̱ma ya bwile bukani̱ye, mu̱koli̱ wa mukama wa Mi̱si̱li̱, oghu aamusembejagha kyakunuwa hamui nʼoghu aamuteekelagha migaati̱, baasaali̱ja mukama wabo oghu. ");
INSERT INTO tlj_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Falaaho, mukama wa Mi̱si̱li̱, aasaliluwa na bakoli̱ be babili aba, mu̱koli̱ wa mukama oghu aamusembejagha kyakunuwa hamui nʼoghu aamuteekelagha migaati̱. ");
INSERT INTO tlj_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Du̱mbi̱ aabakwata, aabata mu nkomo, mu numba ya mukulu wa abaalindagha Falaaho, hambali baabaagha baboheeye Yojeefu̱. ");
INSERT INTO tlj_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Mukulu wa bali̱ndi̱ oghu aakoma Yojeefu̱ kuba mu̱syana wa basaasa aba. Haanu̱ma ya kumala bwile bukee mu nkomo, ");
INSERT INTO tlj_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","mukilo emui oghu aasembejagha mukama kyakunuwa nʼoghu aamuteekelagha migaati̱, bu̱li̱ omui aaloota kilooto kya mbaghani̱ja. ");
INSERT INTO tlj_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Obu Yojeefu̱ aabahi̱ki̱yo nkyambisi ya kilo ekyalabhi̱yʼo, aabona boona beeyu̱ngi̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Du̱mbi̱ aababu̱u̱li̱ya ati, “Mbiki bi̱leki̱ye mweyu̱ngi̱ye mutiyo?” ");
INSERT INTO tlj_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Baamukuukamu bati, “Mukilo twalooti̱ye bilooto bya mbaghani̱ja kandi tatuli nʼoghu akutusoboolola makulu ghaabiyo.” Du̱mbi̱ Yojeefu̱ aabakuukamu ati, “Luhanga niiye akwolekagha muntu makulu ghaa kilooto kiye. Mungambile bilooto byanu.” ");
INSERT INTO tlj_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Du̱mbi̱ mu̱koli̱ oghu aasembejagha mukama kyakunuwa, aaghambila Yojeefu̱ kilooto kiye ati, “Naalooti̱ye kiti kya mujaabbi̱i̱bbu̱ kyemiliiye mu maaso ghanje, ");
INSERT INTO tlj_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","kandi mujaabbi̱i̱bbu̱ oghu ghwabaagha na bitai bisatu, ghwabaaye makakula ghwana bi̱ghu̱ma kandi du̱mbi̱ bi̱ghu̱ma ebi byela. ");
INSERT INTO tlj_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Na kiikopo kya mukama Falaaho kili mu ngalo syanje, du̱mbi̱ naakwata bi̱ghu̱ma bwa kiti eki, naabikamila mu kiikopo eki, naakikwati̱ya mukama Falaaho.” ");
INSERT INTO tlj_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yojeefu̱ aamukuukamu ati, “Kilooto kyawe eki kikumani̱i̱si̱ya kiti: bitai bisatu niibiyo bilo bisatu. ");
INSERT INTO tlj_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Mu bilo bisatu Falaaho akukulekela aku̱ku̱u̱ki̱ye haa mulimo ghwawe oghu waakolagha. ");
INSERT INTO tlj_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ti̱ olakaghenda nuwakuuka haa mulimo, ongilile ngughuma, onjisuke, ongambilile Falaaho ebinkwetʼo, niikuwo nanje ndu̱ghe mu nkomo muni. ");
INSERT INTO tlj_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Olole si̱ye bakankwata na mpaka ku̱lu̱gha mu kyalo kya Bahebbulaayo kandi nankabha bandeeti̱ye mu kyalo kya Mi̱si̱li̱, tandi na kintu kyona ki̱bhi̱i̱hi̱ye naakoli̱ye eki̱leki̱ye ndi mu nkomo.” ");
INSERT INTO tlj_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Obu mu̱teeki̱ wa migaati̱ aaboone Yojeefu̱ aasobolooye kulungi kilooto kya muunakiye, du̱mbi̱ naye aaghila ati, “Nanje dhee naalooti̱ye neetwi̱ki̱ye bighegha bisatu bya migaati̱. ");
INSERT INTO tlj_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Mu kighegha ekyabaagha kimaliliiye eghulu, haabaaghamu migaati̱ ya milingo ekani̱ye ya mukama Falaaho, noni̱ syakala kughiliila mu kighegha ninakyetwi̱ki̱ye haa mutuwe.” ");
INSERT INTO tlj_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yojeefu̱ aamukuukamu ati, “Kini niikiyo kilooto kyawe eki kikumani̱i̱si̱ya: bighegha bisatu niibiyo bilo bisatu. ");
INSERT INTO tlj_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Kandi mu bilo bisatu ebi, Falaaho akukuuya mu nkomo, akujombʼo mutuwe, aku̱dhodhooki̱ye haa kiti, du̱mbi̱ noni̱ sitandike kukuliila haa kiti haala.” ");
INSERT INTO tlj_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Haanu̱ma ya bilo bisatu, Falaaho aakolela bakoli̱ be boona bu̱ghenu̱ bwa kuusuka kilo kya ku̱byaluwa kuwe, du̱mbi̱ Falaaho aaya basaasa babili aba mu nkomo, aabami̱li̱li̱ya mu maaso ghaa baghenu̱. ");
INSERT INTO tlj_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Aaku̱u̱ki̱ya mu̱koli̱ wee oghu aamusembejagha kyakunuwa haa mulimo ghuwe. ");
INSERT INTO tlj_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Aadhodhooki̱ya mu̱teeki̱ wa migaati̱ ngoku Yojeefu̱ aasangu̱u̱we abu̱ghi̱ye obu aasoboololagha kilooto kya musaasa oghu. ");
INSERT INTO tlj_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Kandi mu̱koli̱ oghu aasembejagha mukama kyakunuwa, obu baakamu̱ku̱u̱ki̱i̱ye haa mulimo, taatodhi̱ye aasukila Yojeefu̱ bbaa. ");
INSERT INTO tlj_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Haanu̱ma ya myaka ebili, Falaaho aaloota aamiliiye haa ki̱si̱yo kya maasi Nailo. ");
INSERT INTO tlj_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Mu kilooto kiye eki, aabona nte musanju̱ si̱neeti̱ye kandi sisemeleeye kimui nsi̱lu̱gha mu maasi omu, du̱mbi̱ syatandika kuliya bikaaka ebyabaagha haa ki̱si̱yo kya maasi agha. ");
INSERT INTO tlj_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Aatodha aabona nte sinji musanju̱ syolobi̱ye kandi si̱su̱si̱ye kubhi, nasiyo syalu̱gha mu maasi omu, syasa syamilila haai-haai na si̱li̱ esyaliilagha haa ki̱si̱yo kya maasi agha. ");
INSERT INTO tlj_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Du̱mbi̱ nte esyabaagha syolobi̱ye kandi si̱su̱si̱ye kubhi syaliya esyabaagha si̱neeti̱ye kandi sisemeleeye kimui. Du̱mbi̱ Falaaho aasu̱su̱mu̱ka. ");
INSERT INTO tlj_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Obu aatodhi̱ye kughwesaghila, aatodha aaloota kilooto kyakabili. Mu kilooto eki, aabona mituwe musanju̱ ya mucele esemeleeye kimui yaani̱ye haa ki̱ti̱na kimui. ");
INSERT INTO tlj_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Haanu̱ma ya mituwe eghi, mituwe enji musanju̱ yaatodha yaatuwʼo, esoosokeeye haabwa mwegha oghwalu̱ghagha bu̱lu̱gha ejooba. ");
INSERT INTO tlj_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Du̱mbi̱ mituwe eghi ekaba esoosokeeye yaamela mituwe eghi ekaba esemeeye. Du̱mbi̱ Falaaho aasu̱su̱mu̱ka, aamanya ngoku aalootagha. ");
INSERT INTO tlj_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Nkyambisi, haabwa bituntulo bikani̱ye, aabilikila baku̱mu̱ be hamui na baakalimagheji boona baa munsi ya Mi̱si̱li̱. Aabaghambila bilooto biye ebi byona, bhaatu taabaayʼo muntu nʼomui oghu akagubha kumusoboolola makulu ghaabiyo. ");
INSERT INTO tlj_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Du̱mbi̱ mu̱koli̱ wee oghu aamusembejagha kyakunuwa aamughila ati, “Obwalo naasu̱ki̱ye ngoku naasobeei̱ye kutakughambila. ");
INSERT INTO tlj_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Kilo kimui Falaaho aasaaliluwa na bakoli̱ be, ankwata hamui na mukulu wa bateeki̱ be baa migaati̱, aatuta mu nkomo eghi ekaba eli mu numba ya mukulu wa bali̱ndi̱ be. ");
INSERT INTO tlj_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Kilo kimui mukilo, si̱ye hamui na mu̱teeki̱ wa migaati̱ ya mukama, tukaloota bilooto bya mbaghani̱ja. ");
INSERT INTO tlj_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ti̱ mu nkomo omu tukaba tulimu na Muhebbulaayo omui ali mu̱koli̱ wa mukulu wa bali̱ndi̱. Obu twamughambiiye bilooto byatu ebi, aatusoboolola makulu ghaabiyo. ");
INSERT INTO tlj_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Kandi bilooto byona byaba ngoku aakatusobolooye makulu ghaabiyo. Banku̱u̱ki̱ya haa mulimo ghwanje, mu̱teeki̱ wa migaati̱ baamu̱dhodhooki̱ya.” ");
INSERT INTO tlj_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Niibuwo Falaaho aatu̱mi̱i̱si̱i̱ye Yojeefu̱ bwangu-bwangu, baamuuya mu nkomo, aaghenda kandi baamughemba, aalu̱wala ngoye sinji, du̱mbi̱ baamutwala ewaa Falaaho. ");
INSERT INTO tlj_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Falaaho aaghila Yojeefu̱ ati, “Eso mukilo naalooti̱ye, bhaatu taaliyo muntu nʼomui oghu akugubha kunsoboolola makulu ghaa ebi naalooti̱ye. Ti̱ naaghu̱u̱ye mbaghila bati uwe muntu akaakukughambilagha kilooto kiye, okumusoboololagha makulu ghaakiyo.” ");
INSERT INTO tlj_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yojeefu̱ aakuukamu Falaaho ati, “Si̱ye tankugubha, kuuyʼo Luhanga niiye akugubha kukusoboolola makulu ghaa kilooto eki ngoku okubbala.” ");
INSERT INTO tlj_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Du̱mbi̱ Falaaho aaghila Yojeefu̱ ati, “Nkaloota neemiliiye haa ki̱si̱yo kya maasi Nailo, ");
INSERT INTO tlj_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","naabona nte musanju̱ si̱neeti̱ye kandi sisemeleeye kimui nsi̱lu̱gha mu maasi kandi syakala kuliya bikaaka ebyabaagha haa ki̱si̱yo haala. ");
INSERT INTO tlj_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Naatodha naabona nte sinji musanju̱ syolobeeye kimui kandi si̱dhedhu̱mi̱i̱ye kimui, nasiyo nsi̱lu̱gha mu maasi omu. Kandi nkaba ntakabonaghʼo nte si̱dhedhu̱mi̱ye sitiyo mu kyalo kya Mi̱si̱li̱ kini bbaa. ");
INSERT INTO tlj_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Du̱mbi̱ nte si̱bhi̱i̱hi̱ye kandi syolobi̱ye syaliya nte si̱neeti̱ye kandi sisemeleeye kimui esi naadu̱bhi̱ye kubona. ");
INSERT INTO tlj_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Bhaatu nankabha nsyasiliiye, tawangu̱gu̱bhi̱ye kumanya, nanga sikaakala si̱noolobi̱ye ngoku syakabaagha. Du̱mbi̱ naasu̱su̱mu̱ka. ");
INSERT INTO tlj_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Naatodha naaloota mituwe musanju̱ ya ngano, yoona yaani̱ye haa ki̱ti̱na kimui. ");
INSERT INTO tlj_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Du̱mbi̱ naabona enji musanju̱ esoosokeeye haabwa mwegha oghwalu̱ghagha bu̱lu̱gha ejooba. ");
INSERT INTO tlj_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Kandi eghi esoosokeeye yaamela mituwe musanju̱ eghi ekaba esemeeye. Obu naabighambiiye baku̱mu̱, taaliyo nʼomui oghu akagubha kunsoboolola makulu ghaabiyo.” ");
INSERT INTO tlj_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Du̱mbi̱ Yojeefu̱ aakuukamu ati, “Mukama wanje, bilooto ebi byona bisusaane. Luhanga aasu̱ku̱li̱i̱ye Falaaho ebi ali haai kukola. ");
INSERT INTO tlj_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Nte musanju̱ esisemeeye sikumani̱i̱si̱ya myaka musanju̱, na bikonko musanju̱ bya mucele ebisemeeye bikumani̱i̱si̱ya myaka musanju̱, majima kuwo bilooto byawe byona bisusaane. ");
INSERT INTO tlj_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Na nte musanju̱ esyolobi̱ye kandi esi̱dhedhu̱mi̱ye esyalabhiyʼo, hamui na bikonko musanju̱ bya mucele ebitukulikaane kandi bitali na mughaso, ni myaka musanju̱ ya njala. ");
INSERT INTO tlj_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Kili ngoku naakughambiiye nti, Luhanga aabbali̱ye kukwoleka eki ali haai kukola. ");
INSERT INTO tlj_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Myaka musanju̱ eghi ekwisa, ekuba ya bhi̱ka mu ehanga lyona lya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Bhaatu myaka enji musanju̱ eghi ekwongelʼo ekuba ya njala. Bantu baliibululuwa bhi̱ka eghi ekabʼo, njala elibona-boni̱ya bantu mu ehanga lyona. ");
INSERT INTO tlj_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Bantu baliibululuwa byokuliya ebi baabaagha nabiyo, nanga njala eliba yamaani̱ munu. ");
INSERT INTO tlj_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ti̱ ekyaleki̱ye waaloota kilooto eki mu milundi ebili nkwoleka ngoku Luhanga eenini aaki̱gu̱mi̱i̱ye kandi akughenda kukikola bwangu.” ");
INSERT INTO tlj_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Yojeefu̱ aatodha aaghila Falaaho ati, “Mukama wanje, obbale muntu weena oghu ali na magheji kandi oghu eetegheleei̱ye, omuhe bu̱toki̱ bwa kulema bantu boona mu ehanga lya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Otodhe okome bantu banji abalakumaani̱yagha kimui kya kataano kya byokuliya kandi babilinde kumala myaka musanju̱ ya bhi̱ka. ");
INSERT INTO tlj_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Bakumaani̱ye byokuliya bya myaka musanju̱ ya bhi̱ka eghi elimaasa, babibiike mu nguli mu maatau̱ni̱ ghoona mu bu̱toki̱ bwa Falaaho. ");
INSERT INTO tlj_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Byokuliya ebi babibiike, niikuwo biise biyambe mu myaka musanju̱ eghi njala ekwisa mu ehanga lya Mi̱si̱li̱. Eki kilikoonela Banami̱si̱li̱ kutatwi̱ka nanga njala.” ");
INSERT INTO tlj_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Du̱mbi̱ ntegheka eghi yaadheedha Falaaho na bakoli̱ be boona. ");
INSERT INTO tlj_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Du̱mbi̱ Falaaho aaghila baheeleli̱ya be ati, “Buuye tukugubha tu̱ti̱ya kubona musaasa nga oni oghu ali na mwoyo wa Luhanga?” ");
INSERT INTO tlj_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Du̱mbi̱ Falaaho aaghila Yojeefu̱ ati, “Ngoku Luhanga aakwoleki̱ye ebi byona, taaliyo muntu onji weena oghu ali na magheji kandi eetegheleei̱ye ngaawe bbaa. ");
INSERT INTO tlj_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Uwe nuuwe okulema kikaali kyanje kandi bantu banje boona balaku̱hu̱ti̱yagha. Ni̱i̱si̱ye nenkaha nkukusaali̱ya haabwa kusitama haa ntebe ya bukama.” ");
INSERT INTO tlj_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Niibuwo Falaaho aaghi̱li̱ye Yojeefu̱ ati, “Naakuhaaye bu̱toki̱ bwa kulema ehanga lyona lya Mi̱si̱li̱.” ");
INSERT INTO tlj_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Falaaho aaya mpete mu kyala eliyo li̱i̱na liye, aaghi̱lu̱wi̱ka Yojeefu̱ mu kyala. Aatodha aamu̱lu̱wi̱ka nkanji̱ esemeleeye kimui hamui na bukwanji bwa feeja mu bikiya. ");
INSERT INTO tlj_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Du̱mbi̱ baani̱i̱ni̱ya Yojeefu̱ mu kigaali̱ kya Falaaho kyakabili kwoleka ngoku amulabhiliiye mu bukama. Du̱mbi̱ bali̱ndi̱ baa Falaaho baahikila mbanaghila bati, “Mwehi̱ghe mu luguudhe!” Nahabweki Falaaho aaha Yojeefu̱ bu̱toki̱ bwa kulema bintu byona ebili mu ehanga lya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Falaaho aatodha aaghila ati, “Ni̱i̱si̱ye mukama, bhaatu ku̱lu̱gha obwalo, taaliyo muntu nʼomui oghu alakolagha kintu kyona mu Mi̱si̱li̱ otamu̱si̱i̱mi̱lani̱i̱ye.” ");
INSERT INTO tlj_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Du̱mbi̱ Falaaho aaluka Yojeefu̱ li̱i̱na ati niiye Jefenaati-paneya. Aatodha aamuha mukali̱ wa kuswela li̱i̱na liye Asenasi, muhala wa Potifeela. Potifeela oghu akaba ali mu̱hongi̱ mu tau̱ni̱ ya Oni, du̱mbi̱ Yojeefu̱ aasi̱i̱ma kandi aalema ehanga lyona lya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Bwile obu, Yojeefu̱ akaba ali na myaka maku̱mi̱ asatu ya bukulu. Obu Yojeefu̱ aalu̱ghi̱ye mu maaso ghaa mukama Falaaho, aatandika kubungila ehanga lya Mi̱si̱li̱ lyona. ");
INSERT INTO tlj_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Mu myaka musanju̱ ya bhi̱ka, byokuliya byela kandi byakanila kimui mu ehanga lya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yojeefu̱ aakumaani̱ya byokuliya ebyakeelagha mu myaka musanju̱ omu, byona abibiika mu maatau̱ni̱ ghaa mu Mi̱si̱li̱. Mu bu̱li̱ tau̱ni̱ aabiikilamu byokuliya ebyakeelagha haai-haai na tau̱ni̱ eghi. ");
INSERT INTO tlj_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yojeefu̱ aabiika byokuliya bikaniiye kimui nga musene ghwa ki̱si̱yo kya nanja. Haakumaliilila, aaleka kuhandiika muhendo ghwa byokuliya, nanga akaba naabi̱i̱ki̱ye byokuliya bikaniiye kimui. ");
INSERT INTO tlj_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Myaka ya njala etakabaayʼo, Yojeefu̱ aabyalʼo Asenasi, muhala wa Potifeela mu̱hongi̱ wa mu tau̱ni̱ ya Oni, baana babili baabusaasa. ");
INSERT INTO tlj_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Du̱mbi̱ Yojeefu̱ aaluka mwana wee wa mu̱li̱ghaaso li̱i̱na Manase, aaghila ati, “Li̱i̱na lini likumani̱i̱si̱ya Luhanga aaleki̱ye naabululuwa bujune byanje bwona hamui na bantu bʼewaatu boona.” ");
INSERT INTO tlj_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Mwana waakabili aamuluka li̱i̱na Efulahi̱mu̱, du̱mbi̱ aaghila ati, “Luhanga aaleki̱ye naabyala mu kyalo kini eki naabona-bonelaghamu.” ");
INSERT INTO tlj_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Myaka musanju̱ ya bhi̱ka mu Mi̱si̱li̱ yaahuwʼo. ");
INSERT INTO tlj_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Myaka musanju̱ ya njala yaatandika ku̱hi̱ki̱li̱li̱ya ebi Yojeefu̱ aabu̱ghi̱ye. Njala yaaghwila kimui munsi yoona ngoku Yojeefu̱ aasangu̱u̱we abu̱ghi̱ye, bhaatu mu Mi̱si̱li̱ honkaha, niiyo byokuliya byabaagha. ");
INSERT INTO tlj_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Obu Banami̱si̱li̱ boona baatandi̱ki̱ye ku̱u̱ghu̱wa njala eghi, boona baatandika kusaba Falaaho byokuliya. Du̱mbi̱ Falaaho aabaghila ati, “Mughende ewaa Yojeefu̱, ti̱ mukolaghe eki alakabaghambilagha.” ");
INSERT INTO tlj_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Obu njala yaahingulaane mu ehanga lya Mi̱si̱li̱ lyona, Yojeefu̱ aatandika ku̱ghu̱li̱ya Banami̱si̱li̱ byokuliya ebi. ");
INSERT INTO tlj_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Du̱mbi̱ mahanga ghoona ghaatandika kwisa kughula byokuliya ewaa Yojeefu̱, nanga njala ekaba niyamalakaki̱ye nsi yoona. ");
INSERT INTO tlj_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Obu Yakobbo aaghu̱u̱ye ngoku byokuliya bili mu ehanga lya Mi̱si̱li̱, aaghila batabani̱ be ati, “Kuukala hani mulolaane kwonkaha takuli na mughaso. ");
INSERT INTO tlj_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Naaghu̱u̱ye ngu byokuliya biisuuye mu ehanga lya Mi̱si̱li̱. Mughende mutughulileyo nanga njala etwita.” ");
INSERT INTO tlj_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Du̱mbi̱ baghenji̱ baa Yojeefu̱ eku̱mi̱ baaghenda kughula byokuliya mu ehanga lya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Bhaatu obu baaghendagha, Yakobbo aabhenga ati bataghenda na Bbenjami̱i̱ni̱ oghu akaba abyahuwe etundu limui na Yojeefu̱ eenini, nanga akaba oobaai̱ye kabhi koona kumubʼo mu kihanda. ");
INSERT INTO tlj_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Nahabweki baana baa Yakobbo nabo baaki̱dha e Mi̱si̱li̱ hamui na bantu abaaghendi̱ye kughula byokuliya mu ehanga lya Mi̱si̱li̱ haabwa njala eghi ekaba eghuuye mu nsi ya Kanaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Bwile obu Yojeefu̱ niiye akaba alemi̱ye ehanga lya Mi̱si̱li̱ eli lyona kandi niiye aaghu̱li̱yagha bantu boona byokuliya. Obu baghenji̱ be baaki̱dhi̱ye Mi̱si̱li̱, boona baagomba ku̱mu̱hu̱ti̱ya. ");
INSERT INTO tlj_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Obu Yojeefu̱ aababoone, aabamaniilila, bhaatu eefoola nga muntu atabamani̱ye, du̱mbi̱ aabu̱gha nabo asaakaaye ati, “Enu̱we mu̱lu̱ghi̱ye haa?” Baamukuukamu bati, “Tu̱lu̱ghi̱ye mu kyalo kya Kanaani̱ kandi twasi̱ye kughula byokuliya.” ");
INSERT INTO tlj_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Nankabha Yojeefu̱ naamaniliiye baghenji̱ be aba, bhaatu ebo tabaagu̱bhi̱ye kumumaniilila. ");
INSERT INTO tlj_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Du̱mbi̱ Yojeefu̱ aasuka bilooto ebi aalootagha bikwetʼo baghenji̱ be aba. Du̱mbi̱ aabaghila ati, “Enu̱we muli bantu babhi, mwasi̱ye kubega kyalo kyatu niikuwo mulole buceke bwakiyo.” ");
INSERT INTO tlj_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Baamukuukamu bati, “Bbaa mukama waatu, etu̱we basyana baawe twasi̱ye kughula byokuliya. ");
INSERT INTO tlj_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Etu̱we boona tuli baana baa muntu omui. Etu̱we baheeleli̱ya baawe tuli bantu baa majima, tatuli bambega bbaa.” ");
INSERT INTO tlj_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yojeefu̱ eeyongela kubaghila ati, “Bbaa enu̱we mwasi̱ye kubega kyalo kyatu niikuwo mumanye buceke bwakiyo.” ");
INSERT INTO tlj_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Baatodha baamukuukamu bati, “Etu̱we tukaba tubyahuwemu baana eku̱mi̱ na babili kandi etu̱we boona tuli baana baa musaasa omui wa mu kyalo kya Kanaani̱. Mwana wʼobuto aati̱ghaaye na eseetu̱we, bhaatu onji akaku̱wa.” ");
INSERT INTO tlj_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yojeefu̱ aabaghila ati, “Kili nangoku naasangu̱u̱we mbaghambiiye nti: Enu̱we muli bambega! ");
INSERT INTO tlj_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ndahiiye mu li̱i̱na lya mukama Falaaho, tamu̱ku̱lu̱gha mu kyalo kini mutakaleeti̱ye hani muto waanu oghu mukwete kughamba oghu niikuwo tumanye ngoku mutali bantu babhi. ");
INSERT INTO tlj_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Mutuwe omui mu enu̱we aghende aleete muto waanu, abati̱ghaayʼo baghende mu nkomo, niikuwo tulole bighambo byanu mukwete ku̱bu̱gha bilakaba bili byamajima. Mutaamu̱leeti̱ye, majima kuwo mu li̱i̱na lya mukama Falaaho mukuba muli bantu babhi kuwo.” ");
INSERT INTO tlj_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Du̱mbi̱ boona aabata mu nkomo kumala bilo bisatu. ");
INSERT INTO tlj_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Haa kilo kyakasatu, Yojeefu̱ aabaghila ati, “Si̱ye nku̱hu̱ti̱yagha Luhanga, ti̱ mukaakukola eki ndimabaghambila, du̱mbi̱ nkubalekela. ");
INSERT INTO tlj_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Mulakaba muli bantu baa majima, muleke omui mu enu̱we ati̱ghale mu nkomo muni niikuwo banji batwale byokuliya e ka nanga bantu baanu baku̱wa njala. ");
INSERT INTO tlj_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Bhaatu muukale mukimani̱ye muti mukuleeta muto waanu niikuwo tulole majima ghaanu.” Du̱mbi̱ baasi̱i̱ma. ");
INSERT INTO tlj_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Baaghambilangana bonkaha-na-bonkaha bati, “Majima kuwo ghu̱tu̱si̱ngi̱ye tukwete kubona-bona tuti haabwa mu̱ghenji̱ waatu. Tukabona ngoku aatwesengeleli̱yagha ati tumukoonele, bhaatu twabhenga, niikiyo ki̱leki̱ye ntubona-bona tutiyo.” ");
INSERT INTO tlj_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Leu̱bbeeni̱ aabaghila ati, “Tanaabaghambiiye nti mutakola kubhi mutabhana oghu? Bhaatu mwabhenga ku̱u̱ghu̱wa! Nahabweki tulimabona-bona haabuwe.” ");
INSERT INTO tlj_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Yojeefu̱ aakabaagha naabu̱gha nabo, aakoleesi̱yagha muntu onji kumuhindulila bighambo byabo, du̱mbi̱ baamanya bati eye tangugubha ku̱beetegheleeli̱ya. ");
INSERT INTO tlj_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Du̱mbi̱ Yojeefu̱ aabalu̱ghʼo, aatandika kulila. Bhaatu obu aamali̱ye kulila, aatodha aakuuka, aatandika ku̱bu̱gha nabo dhee. Du̱mbi̱ aalaghila kukwata Si̱mi̱yooni̱, baamuboha, baamutwala mu nkomo banaloli̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Obu baamali̱ye kumuboha, aalaghila ati babahe gu̱ni̱ya sya byokuliya ebi baasiiye, babaku̱u̱ki̱li̱ye na siliva eghi baasi̱ye nayo yoona kandi babahe na byokuliya byakuliila mu kihanda. ");
INSERT INTO tlj_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Baaboha byokuliya byabo haa ndogooi̱ syabo, du̱mbi̱ baaghenda. ");
INSERT INTO tlj_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Obu baahi̱ki̱ye hambali bakulaala, omui muliibo aasambuula gu̱ni̱ya yee kuuyamu byokuliya bya ndogooi̱ yee, aabona siliva eghi aali aghendi̱ye nayo enali mu gu̱ni̱ya omu. ");
INSERT INTO tlj_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Du̱mbi̱ aaghila baanakiye ati, “Mulole, siliva yanje baaghi̱ku̱u̱ki̱i̱ye, ngini enali mu gu̱ni̱ya!” Du̱mbi̱ mitima yabahulumuka, baatandika kutukumila baaghila bati, “Mbiki Luhanga aatu̱koli̱ye bini?” ");
INSERT INTO tlj_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Obu baaki̱dhi̱ye ewaa esebo Yakobbo mu kyalo kyabo kya Kanaani̱, baamughambila byona ebyababaayʼo. Baamughila bati, ");
INSERT INTO tlj_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Mu̱lemi̱ wa Mi̱si̱li̱ akatusaakalila kandi aatubona-boni̱ya ati tukaghenda kubega kyalo kiye. ");
INSERT INTO tlj_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Bhaatu twamughila tuti, ‘Tuli bantu baa majima, tatuli bambega. ");
INSERT INTO tlj_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Tukaba tuli eku̱mi̱ na babili kandi baana baa musaasa omui. Omui muli etu̱we aaku̱wa. Kuuyʼo mu̱li̱ba niiye aati̱ghaaye na eseetu̱we e Kanaani̱.’ ");
INSERT INTO tlj_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Du̱mbi̱ mu̱lemi̱ oghu aatughila ati, ‘Mulakaba muli bantu baa majima, mu̱ti̱ghe hani omui mu enu̱we niikuwo mutwale byokuliya byanu. ");
INSERT INTO tlj_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Kandi muleete muto waanu, niikuwo nimanye ngoku muli bantu baa majima. Nkubaku̱u̱ki̱li̱ya ye, niikuwo mutandike kusuubulila munsi muni.’ ” ");
INSERT INTO tlj_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Obu baatandi̱ki̱ye kusambuula gu̱ni̱ya syabo sya byokuliya, bu̱li̱ muntu aabona kasau ke ka siliva eghi aabaagha aghendi̱ye nayo. Du̱mbi̱ boona hamui na esebo boobahila kimui. ");
INSERT INTO tlj_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Esebo Yakobbo aabaghila ati, “Mukubbala nfweluwe baana banje boona? Yojeefu̱ akaku̱wa! Si̱mi̱yooni̱ naye ngughu aaku̱u̱ye! Hati mukubbala kutwala na Bbenjami̱i̱ni̱. Nahabweki si̱ye ni̱i̱si̱ye nkuba ninfweluwa!” ");
INSERT INTO tlj_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Du̱mbi̱ Leu̱bbeeni̱ aaghila ese wee ati, “Si̱ye oneesi̱ghe, ompe Bbenjami̱i̱ni̱ oghu niikuwo ntaamu̱ku̱u̱ki̱i̱ye, olaata baana banje babili.” ");
INSERT INTO tlj_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Baatu Yakobbo aaghila ati, “Mutabani̱ wanje taakughenda naanu bbaa, waani̱na wee akaku̱wa, ti̱ niiye ati̱ghaayʼo enkaha. Kabhi koona nkanamubaayʼo mu kihanda eghi, na bukulu bwanje buni, mukuleka nku̱we ntuntuuye.” ");
INSERT INTO tlj_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Njala ekaba enakaniiye kimui mu nsi ya Kanaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Obu baamali̱ye kuliya byokuliya ebi baali baghu̱li̱ye e Mi̱si̱li̱, esebo Yakobbo aabaghila ati, “Mutodhe mukuukeyo, mutughulile byokuliya binji.” ");
INSERT INTO tlj_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yu̱da aamughila ati, “Musaasa mu̱lemi̱ wa Mi̱si̱li̱ akalahiilila kimui ati tutatodha kukuuka ewe tutali na mu̱ghenji̱ waatu Bbenjami̱i̱ni̱. ");
INSERT INTO tlj_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kaakuba otutuma na mu̱ghenji̱ waatu oghu, tukughenda tukughulile byokuliya. ");
INSERT INTO tlj_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Bhaatu otaatu̱tu̱mi̱ye naye, tatukughendayo, nanga musaasa oli̱ akatughila ati tutatodha kukuukayo tutali na mu̱ghenji̱ waatu oghu.” ");
INSERT INTO tlj_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Yakobbo aababu̱u̱li̱ya ati, “Ekyaleki̱ye mwamughambila ngoku muli na mu̱ghenji̱ waanu onji mbiki kundeetela kabhi aka koona?” ");
INSERT INTO tlj_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Baamukuukamu bati, “Musaasa oli̱ aatu̱bu̱u̱i̱ye munu bintu bikwetʼo ka yaatu. Kandi aatu̱bu̱u̱li̱ya ati, ‘Eseenu̱we analiyo? Ti̱ muli na mu̱ghenji̱ waanu onji?’ Naatu twamukuukamu bi̱bu̱u̱li̱yo biye. Buuye etu̱we twangumani̱ye tu̱ti̱ya ngoku angughila ati, ‘Muleete mu̱ghenji̱ waanu hani’?” ");
INSERT INTO tlj_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Du̱mbi̱ Yu̱da aaghila ese wee Yakobbo ati, “Oleke si̱ye ngende na mu̱ghenji̱ waatu oghu niikuwo njala etatwita, etu̱we hamui na baana baatu. ");
INSERT INTO tlj_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Si̱ye neenini nkumulinda, ntaaku̱u̱ki̱ye naye hani kandi nimuleeta mu maaso ghaawe, ali̱i̱si̱ye wasoghosa. ");
INSERT INTO tlj_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Nguli tutaakeesekeeleuwe hani, twangubaaye tu̱ghendi̱ye kandi tukuuka milundi ebili.” ");
INSERT INTO tlj_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","I̱saaleeli̱ esebo aabaghila ati, “Kilakaba kili kitiyo, mukole muti: mute mu gu̱ni̱ya syanu bintu bisemeleeye kimui bya mu kyalo kyatu, niikuwo mubitwalile musaasa oghu nga bisembo. Mutwale mubaji̱ ghukee bakughilaghamu miila, bwoki bukee, bi̱lu̱ngi̱yo bya mukubi bikee, bubbani̱ bukee, binyobuwa bikee hamui na bi̱ghu̱ma bikee bya biti ebi tukuliyagha. ");
INSERT INTO tlj_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Mughende na siliva eghi ekani̱ye kusaali̱ya eghi mwadu̱bhi̱ye kughenda nayo milundi ebili, nanga muli na ku̱ku̱u̱ki̱yayo siliva eghi mwasangi̱ye mu gu̱ni̱ya syanu, nanga kedha ekaba nsobi̱. ");
INSERT INTO tlj_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Mutwale na mu̱ghenji̱ waanu oghu niikuwo mughende hamui ewaa musaasa oghu. ");
INSERT INTO tlj_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ti̱ Luhanga wa Bu̱toki̱ Bwona abaghilile ngughuma mu maaso ghaa musaasa oghu, niikuwo agubhe kuleka mu̱ghenji̱ waanu oli hamui na Bbenjami̱i̱ni̱ bakuuke hamui naanu. Niikuwo si̱ye ndakaba ndi wakufweluwa baana banje boona, oleke mbafeeluwe.” ");
INSERT INTO tlj_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Du̱mbi̱ basaasa aba baatwala bisembo, na siliva esaaye milundi ebili eghi baadu̱bhi̱ye kughenda nayo, hamui na Bbenjami̱i̱ni̱. Banguwa baaghenda Mi̱si̱li̱, beetwala mu maaso ghaa Yojeefu̱. ");
INSERT INTO tlj_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Obu Yojeefu̱ aaboone bali na Bbenjami̱i̱ni̱, aalaghila mukulu wa basyana be ati, “Otwale basaasa aba mu numba yanje, osale kisolo kandi oteeke byokuliya, bakuliya nanje saaha mukaagha sya ntangaali̱.” ");
INSERT INTO tlj_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Musaasa oghu aakola ngoku Yojeefu̱ aamulaghiiye, aatwala basaasa aba mu numba. ");
INSERT INTO tlj_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Bhaatu basaasa aba boobahila kimui obu baabatwete mu numba ya Yojeefu̱. Baatandika kweli̱li̱kana bati, “Baatu̱leeti̱ye hani haabwa siliva eghi twaku̱u̱ki̱yeyo nayo mulundi ghwa ku̱du̱bha. Musaasa oni akubbala kutwegimba, atukwatile mu numba, atusaali̱ye maani̱, niikuwo atwale ndogooi̱ syatu kandi atufoole basyana be.” ");
INSERT INTO tlj_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Du̱mbi̱ baaghenda ewaa mukulu wa basyana baa Yojeefu̱, baatandika ku̱bu̱gha naye banaamiliiye haa mulyango ghwa numba ya Yojeefu̱ mbaghila bati, ");
INSERT INTO tlj_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Mukama waatu, tukadu̱bha twasa hani kughula byokuliya. ");
INSERT INTO tlj_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Bhaatu obu twahi̱ki̱ye hambali twalaaliiye, ntwasambuula gu̱ni̱ya syatu, bu̱li̱ muntu aasangaanamu siliva eghi aali aasi̱ye kughulamu byokuliya, enalimu. Ti̱ twatodhi̱ye twasa nayo. ");
INSERT INTO tlj_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Kandi twasi̱ye na siliva enji kughula byokuliya dhee. Bhaatu tatumani̱ye oghu akata siliva eghi mu gu̱ni̱ya syatu bbaa.” ");
INSERT INTO tlj_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Musaasa oghu aabakuukamu ati, “Eki kileke kubatu̱ntu̱li̱ya. Luhanga waanu kandi Luhanga wa eseenu̱we aabahaaye etunga mu gu̱ni̱ya syanu, si̱ye nkatunga siliva yaanu.” Du̱mbi̱ aatwesi̱ya Si̱mi̱yooni̱, aamuleeta hambali bali. ");
INSERT INTO tlj_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Mukulu wa basyana oghu, aabataahi̱ya mu numba ya Yojeefu̱, aabaha maasi ghaa kunaaba mu maghulu kandi aaha na ndogooi̱ syabo byokuliya. ");
INSERT INTO tlj_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Obu baamali̱ye ku̱u̱ghu̱wa ngoku bakuliya hamui na Yojeefu̱, du̱mbi̱ baata haai bisembo bya kumuha naaki̱dhi̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Obu Yojeefu̱ aasi̱ye e ka, baamuha bisembo ebi baali bamutwaliiye kandi baagomba hansi mu maaso ghe. ");
INSERT INTO tlj_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Aabaghila ati, “Muli mu̱ti̱ya, na musaasa mukulu eseenu̱we ali ati̱ya? Buuye anabʼo?” ");
INSERT INTO tlj_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Baamukuukamu bati, “Mu̱syana waawe eseetu̱we anabʼo kandi aliyo kulungi.” Du̱mbi̱ baatodha baagomba hansi ku̱mu̱hu̱ti̱ya. ");
INSERT INTO tlj_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Obu aabaloli̱ye, naabona waani̱na wee Bbenjami̱i̱ni̱, du̱mbi̱ aababu̱u̱li̱ya ati, “Oni niiye muto waanu mwaghambagha?” Du̱mbi̱ aaghila ati, “Luhanga akughilile ngughuma mutabani̱ wanje.” ");
INSERT INTO tlj_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Du̱mbi̱ Yojeefu̱ aakwatuwa kisa haabwa kubona waani̱na wee Bbenjami̱i̱ni̱, aalu̱ghʼo bukee, aaghenda abbala hambali akulilila. Aataaha mu kisiika kiye, aalililayo. ");
INSERT INTO tlj_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Obu aamali̱ye kunaaba haali̱i̱so, aatuwayo, du̱mbi̱ aaghila mukulu wa baheeleli̱ya be ati, “Otuuhulile byokuliya.” ");
INSERT INTO tlj_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Baamuha biye enkaha, na baghenji̱ be byabo bonkaha, hamui na Banami̱si̱li̱ abaabaghʼo byabo bonkaha, nanga bwile obu Banami̱si̱li̱ tabaaliyagha hamui na Bahebbulaayo, nanga kyabaagha nga kihali̱yo. ");
INSERT INTO tlj_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Baghenji̱ be aba baasitama mu maaso ghe ku̱lu̱ghi̱i̱li̱la haa mukulu ku̱hi̱ki̱ya haa muto, baalolana haali̱i̱so, ti̱ baakala basweki̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Obu baatandi̱ki̱ye kubaha byokuliya ku̱lu̱gha haa meeja ya Yojeefu̱, ebya Bbenjami̱i̱ni̱ byakanila kimui kusaali̱ya bya baghenji̱ be milundi etaano. Du̱mbi̱ baaliya kandi baanuwa na Yojeefu̱, batali na kweyungilila kwona. ");
INSERT INTO tlj_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Du̱mbi̱, Yojeefu̱ aalaghila mukulu wa basyana baa mu numba yee ati, “Oosu̱li̱ya gu̱ni̱ya sya basaasa aba na byokuliya. Bu̱li̱ muntu omu̱pi̱i̱mi̱le ebi akugubha kuheeka noosighikila haa maani̱ ghe. Kandi ote siliva ya bu̱li̱ muntu mu gu̱ni̱ya yee. ");
INSERT INTO tlj_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Du̱mbi̱ ote kiikopo kyanje kya siliva mu gu̱ni̱ya ya muto wabo, hamui na siliva eghi ali aasi̱ye kughulamu byokuliya.” Mukulu wa basyana baa Yojeefu̱ oghu aakola ngoku Yojeefu̱ aakamulaghiiye. ");
INSERT INTO tlj_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Nkyambisi bwile mbukiya, basaasa aba baamu̱ki̱ya kughenda hamui na ndogooi̱ syabo. ");
INSERT INTO tlj_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Obu baali batakaseli̱ye ku̱lu̱gha mu tau̱ni̱, Yojeefu̱ aalaghila mukulu wa basyana be ati, “Okwame basaasa aba, okakubahi̱kʼo, obabu̱u̱li̱ye oti, ‘Haabwaki bilungi naabakoleeye nimunsasulamu bi̱bhi̱i̱hi̱ye?’ ");
INSERT INTO tlj_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Otodhe obabu̱u̱li̱ye oti, ‘Kini tikili kiikopo kya mukama wanje akunwelaghamu kandi eki aku̱koleesi̱yagha mu kulaghula? Mwakoli̱ye kintu kibhi munu.’ ” ");
INSERT INTO tlj_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Obu mu̱syana wa Yojeefu̱ oghu aahi̱ki̱yʼo baghenji̱ baa Yojeefu̱, aababu̱u̱li̱ya ngoku Yojeefu̱ aakamulaghikiliiye. ");
INSERT INTO tlj_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Du̱mbi̱ baghenji̱ baa Yojeefu̱ baamukuukamu bati, “Haabwaki mukama waatu naabu̱gha bintu ngʼebi? Etu̱we baheeleli̱ya baawe tatukugubha kukola kintu ngʼeki bbaa! ");
INSERT INTO tlj_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Waabona twaku̱u̱ki̱ya siliva eghi twasangi̱ye mu gu̱ni̱ya syatu ku̱lu̱gha mu nsi ya Kanaani̱. Ti̱ ekyanguleka twibha siliva na feeja mu numba ya mukama waawe nkiki? ");
INSERT INTO tlj_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Kaakuba omui mu basyana baawe asanguwa na kiikopo eki, aku̱ku̱wa kandi etu̱we boona tukuba basyana baawe.” ");
INSERT INTO tlj_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Musaasa oghu aakuukamu ati, “Eki ki̱hi̱ki̱ye! Oleke kibe ngoku mwabu̱ghi̱ye. Oghu nkusanga ali nakiyo, niiye akuba mu̱syana wanje. Abati̱ghaayʼo mukuba mutali na musango.” ");
INSERT INTO tlj_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Du̱mbi̱ bu̱li̱ omui aasu̱ndi̱ya gu̱ni̱ya yee hansi kandi aaghisambuula. ");
INSERT INTO tlj_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Du̱mbi̱ mukulu wa basyana baa Yojeefu̱ aatandika kulolakaka mu gu̱ni̱ya esi, kutandikila haa wʼobukulu ku̱hi̱ki̱ya haa wʼobuto. Kiikopo eki baakisanga mu gu̱ni̱ya ya Bbenjami̱i̱ni̱. ");
INSERT INTO tlj_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Obu baghenji̱ be baaboone ngoku baasangi̱ye kiikopo mu gu̱ni̱ya ya Bbenjami̱i̱ni̱, baatemangula ngoye syabo. Du̱mbi̱ boona baaheeki̱ya ndogooi̱ syabo, baatodha baakuuka mu tau̱ni̱. ");
INSERT INTO tlj_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Obu baaku̱u̱ki̱yeyo, baasanga Yojeefu̱ anali mu numba. Du̱mbi̱ Yu̱da na baghenji̱ be boona baaghenda baatandika kweghalaghala mu maghulu ghe. ");
INSERT INTO tlj_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yojeefu̱ aababu̱u̱li̱ya ati, “Mbiki mwakoli̱ye ebi? Tamumani̱ye ngoku musaasa ngʼanje nangumanya kintu kyona kusaalila mu kulaghula bhaatu batakingambiiye?” ");
INSERT INTO tlj_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yu̱da aamukuukamu ati, “Tulabu̱gha ki, mukama wanje? Kandi mbiki tulakukuukamu? Tulasobola tu̱ti̱ya kwoleka ngoku tutali na musango? Luhanga aabbali̱ye kukyoleka ngoku twasobeeye. Ti̱ etu̱we boona twamali̱ye kuba basyana baa mukama wanje hamui na mu̱ghenji̱ waatu oghu baasangi̱ye na kiikopo eki.” ");
INSERT INTO tlj_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yojeefu̱ aakuukamu ati, “Takikusoboka kukola kintu ngʼeki! Kuuyʼo musaasa oghu baasangi̱ye na kiikopo kyanje enkaha, niiye akuba mu̱syana wanje. Abaati̱ghaaye boona tamuli na musango, mukuukeyo ewaa eseenu̱we na bu̱si̱nge.” ");
INSERT INTO tlj_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Niibuwo Yu̱da aaghendi̱ye hambali Yojeefu̱ aabaagha, aamughila ati, “Gutu mukama wanje, oleke mu̱syana waawe abu̱ghe naawe kighambo kimui bughila. Nkukusaba otasaaliluwa munu, nanga nkimani̱ye oli na bu̱toki̱ bwengaane na bwa Falaaho eenini. ");
INSERT INTO tlj_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mukama wanje, okatu̱bu̱u̱li̱ya tulakaba tuli na eseetu̱we kedha mu̱ghenji̱ waatu onji. ");
INSERT INTO tlj_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Kandi twakukuukamu tuti, ‘Tuli na eseetu̱we, bhaatu akamala kukaakulila kimui, hamui na mu̱ghenji̱ waatu omui wʼobuto oghu eseetu̱we aabyaye amali̱ye kukaakula. Waani̱na wee eenini akaku̱wa. Ti̱ niiye ati̱ghaayʼo enkaha munda ya ni̱nabo. Kandi ese wee amukundiiye kimui.’ ");
INSERT INTO tlj_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Du̱mbi̱ waaghila etu̱we basyana baawe oti tukuleetele ye, omulole. ");
INSERT INTO tlj_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ti̱ mukama wanje, twakukuukamu tuti, ‘Mutabhana oghu taakugubha ku̱lu̱ghʼo ese wee bbaa. Naanamu̱lu̱ghi̱yʼo, ese wee aku̱ku̱wa.’ ");
INSERT INTO tlj_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ti̱ waaghila etu̱we baheeleli̱ya baawe oti tutaaleeti̱ye muto waatu oghu, tutalitodha ku̱ku̱hi̱kʼo. ");
INSERT INTO tlj_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Twakuukayo ewaa mu̱heeleli̱ya waawe eseetu̱we, twamughambila ebi waabu̱ghi̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Obu eseetu̱we aatu̱ghi̱li̱ye ati tutodhe twise tughule byokuliya binji, ");
INSERT INTO tlj_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","twamukuukamu tuti, ‘Tatukugubha kukuuka Mi̱si̱li̱ tutali na muto waatu oghu. Tatukugubha ku̱hi̱kʼo musaasa oghu tutali na muto waatu.’ ");
INSERT INTO tlj_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Du̱mbi̱ mu̱heeleli̱ya waawe tita aatughila ati, ‘Mumani̱ye ngoku mukali̱ wanje ambyaliiye baana babili baabusaasa. ");
INSERT INTO tlj_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Omui haaliibo andu̱ghʼo, du̱mbi̱ naaghila nti majima kuwo akatemanguluwamu bu̱twi̱ka-twi̱ke. Kandi ku̱hi̱ki̱ya nʼendindi tankamubonagha. Ku̱lu̱gha bwile obu, taakakuukagha. ");
INSERT INTO tlj_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Nahabweki naye nimwanamu̱nji̱hi̱yʼo kandi kantu kamukola, mukuleka si̱ye musaasa mukulu nku̱we ndi muntu wa bujune.’ ");
INSERT INTO tlj_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Nahabweki tatukugubha kukuuka ewaa mu̱heeleli̱ya waawe tita tutali na mwana oghu, bwomi̱i̱li̱ buwe busighikiiye haa mwana oghu. ");
INSERT INTO tlj_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Naaboone tutali na mwana oghu, tita aku̱ku̱wa. Kandi etu̱we baheeleli̱ya baawe tukujiika eseetu̱we ali muntu wa bujune bukani̱ye kuni ali musaasa mukulu. ");
INSERT INTO tlj_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ti̱ nkagu̱mi̱ya tita nti taaliyo kabhi koona akakubʼo mutabhana oghu. Kandi naaghila nti, ntaaku̱u̱ki̱yeyo naye, ali̱i̱si̱ye baasoghosa. ");
INSERT INTO tlj_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Nahabweki gutu mukama wanje, hakili oleke si̱ye mu̱syana waawe nti̱ghale hani kandi nibe mu̱syana waawe mu ki̱i̱kalo kya mutabhana oni, niikuwo oleke mutabhana na baghenji̱ be bakuukeyo. ");
INSERT INTO tlj_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Nkugubha nti̱ya kukuuka ewaa tita ntali na mutabhana oghu? Timbbali̱ye kubona tita ali mu bujune butiyo.” ");
INSERT INTO tlj_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yojeefu̱ ataagubha ku̱gu̱mi̱si̱li̱ja mu maaso ghaa basyana be ngoku eehi̱ghu̱u̱ye, aalaghila ati, “Bu̱li̱ muntu andu̱ghe mu maaso.” Aakola eki niikuwo agubhe kweyoleka baghenji̱ be muntu onji ataliyo. ");
INSERT INTO tlj_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Aalila na elaka liinamu̱li̱to, du̱mbi̱ Banami̱si̱li̱ aba baaghu̱wa, na bʼeka ya Falaaho baamanya. ");
INSERT INTO tlj_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yojeefu̱ aabaghila ati, “Ni̱i̱syoni Yojeefu̱! Buuye, tita anaakaaye?” Bhaatu baghenji̱ be tabaagu̱bhi̱ye kumukuukamu, nanga bakaba boobahiiye kimui kwemilila mu maaso ghaa Yojeefu̱. ");
INSERT INTO tlj_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Du̱mbi̱ aaghila baghenji̱ be ati, “Mu̱neesu̱kane haai.” Obu bamwesu̱kaane haai, aabaghila ati, “Ni̱i̱syoni mu̱ghenji̱ waanu Yojeefu̱, oghu mwaghu̱li̱i̱ye kandi baamutwala mu Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Nahabweki mutatuntula kandi muleke kwesoghosa haabwa ku̱ngu̱li̱ya. Luhanga eenini akabbala mbahikile ngende e Mi̱si̱li̱, niikuwo ngubhe kujuna bwomi̱i̱li̱ bwanu. ");
INSERT INTO tlj_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Njala eni yaamali̱ye myaka ebili mu kyalo kini kandi mu myaka enji etaano eghi ekutodhʼo, taakubʼo kweli̱ya kwona kedha kukesa. ");
INSERT INTO tlj_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Bhaatu Luhanga akantuma mbahikile ngende e Mi̱si̱li̱, njune bwomi̱i̱li̱ bwanu na kujunuwa kwamaani̱, niikuwo mu enu̱we habʼo abaku̱ti̱ghalʼo munsi. ");
INSERT INTO tlj_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Nahabweki taali̱i̱nu̱we mwantu̱mi̱ye eni, Luhanga eenini niiye akantumayo. Kandi anfoola kuba nga ese Falaaho kandi mu̱loleeleli̱ wa bintu byona ebili mu numba yee, aatodha anfoola mukama wa nsi ya Mi̱si̱li̱ yoona. ");
INSERT INTO tlj_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Nahabweki mukuukeyo bwangu ewaa tita, mumughambile muti, ‘Mutabani̱ waawe Yojeefu̱ aaghi̱li̱ye ati Luhanga akamufoola mukama wa Mi̱si̱li̱ yoona kandi oose eni bwangu. ");
INSERT INTO tlj_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Oliikala mu kyalo kya Goseeni̱, niikuwo ookalaghe haai nanje, uwe na baana baawe na baasukulu baawe boona, na mahi̱yo ghaawe ghoona, hamui na ebi oli nabiyo byona. ");
INSERT INTO tlj_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Nkukuloleelela, nanga njala enati̱ghaaye myaka enji etaano. Hatali eki, uwe na ka yaawe kandi na boona aba oli nabo mukuba banaku.’ ");
INSERT INTO tlj_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Enu̱we boonini muboone kandi na mwana wamaaha Bbenjami̱i̱ni̱ naye aboone ngu ni̱i̱si̱ye Yojeefu̱ neenini nkwete ku̱bu̱gha naanu. ");
INSERT INTO tlj_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Mughende mughambile tita ki̱ku̱ghi̱yo eki bampaaye hani mu Mi̱si̱li̱, na bu̱li̱ kimui kyona eki mwaboone, niikuwo muleete hani tita bwangu.” ");
INSERT INTO tlj_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Du̱mbi̱ Yojeefu̱ aaghuwa mu ki̱ku̱bha kya mwana waani̱na wee Bbenjami̱i̱ni̱, aatandika kulila. Bbenjami̱i̱ni̱ naye aamughuwa mu ki̱ku̱bha, aatandika kulila. ");
INSERT INTO tlj_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Du̱mbi̱ Yojeefu̱ aaghuwa baghenji̱ be boona mu ki̱ku̱bha naanalila. Du̱mbi̱ baghenji̱ be baatandika ku̱bu̱gha naye. ");
INSERT INTO tlj_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Obu makulu ghaahi̱ki̱ye mu kikaali kya Falaaho ngoku baghenji̱ baa Yojeefu̱ baasi̱ye, Falaaho na basyana be boona baadheedhuwa. ");
INSERT INTO tlj_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Du̱mbi̱ Falaaho aaghila Yojeefu̱ ati, “Oghambile baghenji̱ baawe oti, ‘Mukole muti: Mu̱heeki̱ye bisolo byanu kandi mukuuke munsi ya Kanaani̱, ");
INSERT INTO tlj_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","mukuuke hani na eseenu̱we na baana baanu boona. Nkubaha kyalo kisemeeye kusaali̱ya byalo byona ebili mu Mi̱si̱li̱ kandi mweghonje na bilungi byona ebilimu.’ ");
INSERT INTO tlj_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Nahabweki okulaghiluwa kughambila baghenji̱ baawe oti, ‘Mutwale bimui haa bigaali̱ bya Mi̱si̱li̱, niikuwo biheeke baana baanu hamui na bakali̱ baanu. Mukulaghiluwa kuleeta hani eseenu̱we. ");
INSERT INTO tlj_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Mutatuntula haabwa bintu byanu ebi mwabaagha nabiyo nanga nkubaha kyalo kisemeeye kusaali̱ya byalo byona ebili mu Mi̱si̱li̱.’ ” ");
INSERT INTO tlj_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Batabani̱ baa Yakobbo bani baakola ngoku baabaghambiiye. Yojeefu̱ aabaha bigaali̱ ngoku Falaaho aalaghiiye. Aatodha aabaha byokuliya binji byakuliila mu kihanda. ");
INSERT INTO tlj_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Du̱mbi̱ aaha bu̱li̱ muntu lughoye luhyaka, bhaatu aaha Bbenjami̱i̱ni̱ ngoye etaano hamui na bi̱twi̱ke bi̱ku̱mi̱ bisatu bya siliva. ");
INSERT INTO tlj_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Kandi bini niibiyo aatumiiye ese wee: Ndogooi̱ eku̱mi̱ baasi̱heeki̱ya bintu bisemeeye ebili munsi ya Mi̱si̱li̱, hamui na ndogooi̱ syabukali̱ eku̱mi̱ baasi̱heeki̱ya buluwe, hamui na migaati̱, hamui na bintu binji byaku̱koleesi̱ya mu kihanda. ");
INSERT INTO tlj_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Du̱mbi̱ Yojeefu̱ aalagha baghenji̱ be aba mbanaamu̱ki̱ya, aabaghila ati, “Mutatonganilana mu kihanda!” ");
INSERT INTO tlj_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Du̱mbi̱ baaghenda baatuwa munsi ya Mi̱si̱li̱, baaghenda ewaa esebo Yakobbo munsi ya Kanaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Baaghambila esebo bati, “Yojeefu̱ anaakaaye kandi ni mu̱lemi̱ wa Mi̱si̱li̱ yoona!” Yakobbo atasi̱i̱ma bwangu ngoku bakwete kumughambila. ");
INSERT INTO tlj_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Bhaatu obu baamughambiiye byona ebi Yojeefu̱ aabaghambiiye kandi obu aaboone bigaali̱ ebi Yojeefu̱ aali asi̱ndi̱ki̱ye kumuheeka, du̱mbi̱ aakuukamu maani̱. ");
INSERT INTO tlj_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Du̱mbi̱ Yakobbo aaghila ati, “Hati naaki̱si̱i̱mi̱ye! Mutabani̱ wanje Yojeefu̱ anaakaaye. Nkughenda kumulola ntakaku̱u̱ye.” ");
INSERT INTO tlj_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Yakobbo aadonga kughenda Mi̱si̱li̱ na etungo liye lyona. Obu aahi̱ki̱ye Bbeli̱seba, aahongela Luhanga wa ese wee I̱saka, bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Mukilo, Luhanga aabu̱gha na Yakobbo mu kwolekuwa, aamughila ati, “Yakobbo! Yakobbo!” Yakobbo aamukuukamu ati, “Ndi hani.” ");
INSERT INTO tlj_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Niibuwo Luhanga aaghi̱li̱ye ati, “Ni̱i̱syoni Luhanga, Luhanga wa so waawe. Otoobaha kughenda munsi ya Mi̱si̱li̱, nanga nkukufoolelayo ehanga lyamaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Nkughenda naawe eku̱wa munsi ya Mi̱si̱li̱ kandi majima kuwo, nditodha nku̱ku̱u̱ki̱yeyo. Kandi mutabani̱ waawe Yojeefu̱ niiye aliteekani̱ya mu̱ku̱ ghwawe.” ");
INSERT INTO tlj_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Du̱mbi̱ Yakobbo aamu̱ki̱ya ku̱lu̱gha Bbeli̱seba, batabani̱ be baamutwala e Mi̱si̱li̱. Baamuheeka hamui na baana baabo na bakali̱ baabo haa bigaali̱ ebi Falaaho aali asi̱ndi̱ki̱ye kumuheeka. ");
INSERT INTO tlj_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Baatwala bisolo byabo byona, na etungo eli baali batungiiye munsi ya Kanaani̱. Yakobbo na baasukulu be boona baaghenda mu nsi ya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Aaghenda mu nsi ya Mi̱si̱li̱ na batabani̱ be, baasukulu be baabusaasa, bahala be, na baasukulu be baabukali̱, hamui na lu̱byalo luwe lwona. ");
INSERT INTO tlj_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ghani niigho mali̱i̱na ghaa baana baa Yakobbo oghu baaghilaghamu I̱saaleeli̱ abaaghendi̱ye munsi ya Mi̱si̱li̱: Leu̱bbeeni̱, niiye akabali mu̱li̱ghaaso ghuwe. ");
INSERT INTO tlj_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Leu̱bbeeni̱ aabyala bani: Hanoki̱, Palu, Heji̱looni̱, na Kalami̱. ");
INSERT INTO tlj_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Si̱mi̱yooni̱ aabyala bani: Yemu̱weli̱, Yami̱i̱ni̱, Ohadi̱, Yaki̱i̱ni̱, Johali̱, hamui na Sau̱li̱, oghu aabyayʼo muhala wa Banakanaani̱. ");
INSERT INTO tlj_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Leevi̱ aabyala bani: Gelesooni̱, Kohasi̱, na Melaali̱. ");
INSERT INTO tlj_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yu̱da aabyala bani: Eli̱, Onani, Seela, Peleeji̱, hamui na Jeela. Bhaatu Eli̱ na Onani bakakwi̱la munsi ya Kanaani̱. Peleeji̱ naye aabyala bani: Heji̱looni̱ hamui na Hamuli̱. ");
INSERT INTO tlj_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","I̱sakaali naye aabyala bani: Toola, Puha, Yasuhubba, hamui na Simulooni̱. ");
INSERT INTO tlj_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Jabbu̱looni̱ aabyala bani: Seledi̱, Elooni̱, hamui na Yaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Bani niibo batabani̱ baa Yakobbo aba aabyayʼo Leei̱ya obu baali banaakaaye munsi ya Padanalaamu, hamui na muhala wee Dina. Batabani̱ be na bahala be bani boona bakaba bali bantu maku̱mi̱ asatu na basatu. ");
INSERT INTO tlj_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gaadi̱ naye aabyala bani: Ji̱fi̱yooni̱, Haagi̱, Su̱u̱ni̱, Eji̱bbooni̱, Eeli̱, Aloodi̱, hamui na Aleeli̱. ");
INSERT INTO tlj_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aseli̱ naye aabyala bani: Imuna, I̱si̱va, I̱si̱vi̱, hamui na Bbeli̱ya. Mwani̱nabo niiye akabali Seela. Bbeli̱ya naye aabyala bani: Hebbeli̱ na Meli̱keeli̱. ");
INSERT INTO tlj_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Bani boona bakaba bali baana baa Yakobbo aabyayʼo Ji̱li̱pa, oghu Labbaani̱ aali ahaaye muhala wee Leei̱ya. Boona bakaba bali baana eku̱mi̱ na mukaagha. ");
INSERT INTO tlj_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Batabani̱ baa Yakobbo aba aabyayʼo Lakeeli̱ niibo bani: Yojeefu̱ hamui na Bbenjami̱i̱ni̱. ");
INSERT INTO tlj_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yojeefu̱ naye aabyalila munsi ya Mi̱si̱li̱, Manase hamui na Efulahi̱mu̱. Ni̱nabo aliiye Asenasi, muhala wa Potifeela, mu̱hongi̱ wa mu kyalo kya Oni. ");
INSERT INTO tlj_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Bbenjami̱i̱ni̱ naye aabyala bani: Bbeela, Bbekeeli̱, Asu̱bbeeli̱, Geela, Namani̱, Ehi̱, Losi̱, Mu̱pi̱i̱mu̱, Hu̱pi̱i̱mu̱, hamui na Ali̱di̱. ");
INSERT INTO tlj_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Bani niibo baabaagha batabani̱ baa Yakobbo aba aabyayʼo Lakeeli̱. Boona bakaba bali bantu eku̱mi̱ na bbanaa. ");
INSERT INTO tlj_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Mutabani̱ wa Daani̱ niiye oni: Hu̱si̱i̱mu̱. ");
INSERT INTO tlj_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Batabani̱ baa Nafutaali niibo bani: Yahajeeli̱, Gu̱u̱ni̱, Yejeli̱, hamui na Si̱leemu. ");
INSERT INTO tlj_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Bani niibo batabani̱ baa Yakobbo aba aabyayʼo Bbi̱i̱la, oghu Labbaani̱ aali ahaaye muhala wee Lakeeli̱. Boona bakaba bali bantu musanju̱. ");
INSERT INTO tlj_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Muhendo ghwa baana baa Yakobbo aba aaghendi̱ye nabo Mi̱si̱li̱, otabaliiyemu bagholi be, bakaba bali bantu nkaagha na mukaagha. ");
INSERT INTO tlj_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Kwongelʼo Yojeefu̱ akaba ali batabani̱ be babili aba aabyaliiye mu ehanga lya Mi̱si̱li̱. Nahabweki muhendo ghwa bantu boona baa ka ya Yakobbo e Mi̱si̱li̱ ghwaba bantu nsanju̱. ");
INSERT INTO tlj_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Obu baabaagha bali haai-haai ku̱ki̱dha, Yakobbo aaghila Yu̱da ati abahikile niikuwo abu̱u̱li̱ye Yojeefu̱ kihanda kyonini eki̱ghendi̱ye mu Goseeni̱. Obu baaki̱dhi̱yeyo, ");
INSERT INTO tlj_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yojeefu̱ aani̱i̱na haa kigaali̱ kiye, aaghenda Goseeni̱ kusangaana ese wee Yakobbo. Akaba makamubona atiila, aaghuwa ese wee mu ki̱ku̱bha, du̱mbi̱ aatandika kulila kumala bwile bukani̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Du̱mbi̱ Yakobbo aaghila Yojeefu̱ ati, “Hati neeteekani̱i̱je ku̱ku̱wa, ngoku neenini neeboneeye nti onaakaaye.” ");
INSERT INTO tlj_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Du̱mbi̱ Yojeefu̱ aaghambila baghenji̱ be na bʼeka ya ese wee ati, “Nkughenda ewaa Falaaho nimughambile nti, ‘Baghenji̱ banje hamui na tita na bʼeka yee boona abaakalagha munsi ya Kanaani̱ baasi̱ye ewanje. ");
INSERT INTO tlj_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Kandi bantu aba ni bali̱i̱si̱ya kandi baasi̱ye na bu̱hi̱yo bwabo, na nte, na bintu byabo.’ ");
INSERT INTO tlj_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Falaaho naanababilikiye akababu̱u̱li̱ya ati, ‘Mukukolagha mulimo ki?’ ");
INSERT INTO tlj_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Mumukuukemu muti, ‘Etu̱we basyana baawe tuli bali̱i̱si̱ya baa bisolo ku̱lu̱gha mu butabhana bwatu ku̱hi̱ki̱ya endindi, ngoku baataata baatu baakolagha.’ Mukaakumukuukamu mutiyo, du̱mbi̱ akubasi̱i̱mi̱lani̱ya kuukala mu kyalo kya Goseeni̱, nanga Banami̱si̱li̱ bakughayagha bali̱i̱si̱ya.” ");
INSERT INTO tlj_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Du̱mbi̱ Yojeefu̱ aaghenda aaghambila Falaaho ati, “Tita na baghenji̱ banje, na bu̱hi̱yo bwabo, na bintu byabo byona, baasi̱ye ku̱lu̱gha kyalo kya Kanaani̱, endindi bali mu kyalo kya Goseeni̱.” ");
INSERT INTO tlj_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Yojeefu̱ aakomamu baghenji̱ be bataano, aabatwala mu maaso ghaa Falaaho. ");
INSERT INTO tlj_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Du̱mbi̱ Falaaho aabu̱u̱li̱ya baghenji̱ baa Yojeefu̱ aba ati, “Mukukolagha mulimo ki?” Baamukuukamu bati, “Etu̱we basyana baawe tuli bali̱i̱si̱ya baa ntaama, nga baataata baatu.” ");
INSERT INTO tlj_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Baatodha baamughila bati, “Twasi̱ye kuukala eni dhaani, nanga njala yamaani̱ eli munsi ya Kanaani̱ kandi bu̱hi̱yo bwa basyana baawe tabuli na bi̱si̱ngo. Nahabweki gutu, oleke etu̱we basyana baawe tuukale Goseeni̱.” ");
INSERT INTO tlj_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Du̱mbi̱ Falaaho aaghambila Yojeefu̱ ati, “Ngoku so waawe na baghenji̱ baawe baasi̱ye kuukala naawe, ");
INSERT INTO tlj_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","kandi nsi ya Mi̱si̱li̱ eli mu mikono yaawe, ookali̱ye so waawe na baghenji̱ baawe mu ki̱i̱kalo ekisaai̱ye bi̱i̱kalo byona kusemela. Oleke baakale Goseeni̱. Kandi okaakuba omani̱ye omui muliibo oghu ali na kisembo kya mbaghani̱ja mu ku̱li̱i̱si̱ya, omuhe bu̱toki̱ bwa kuloleelela bisolo byanje.” ");
INSERT INTO tlj_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Du̱mbi̱ Yojeefu̱ aaleeta ese wee Yakobbo mu numba hambali Falaaho aabaagha, aamwemi̱li̱li̱ya mu maaso ghe. Du̱mbi̱ Yakobbo aaha Falaaho mu̱gi̱sa. ");
INSERT INTO tlj_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Falaaho aabu̱u̱li̱ya Yakobbo ati, “Oli na myaka eti̱ya?” ");
INSERT INTO tlj_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakobbo aamukuukamu ati, “Naabunga-bu̱ngi̱ye munsi muni kumala myaka 130. Bhaatu bwomi̱i̱li̱ bwanje bwabaaye bukee hali bwa baataata banje kandi bwa kubona-bona.” ");
INSERT INTO tlj_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Du̱mbi̱ Yakobbo aatodha aaha Falaaho mu̱gi̱sa, aalu̱gha mu maaso ghe. ");
INSERT INTO tlj_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Nahabweki Yojeefu̱ aakali̱ya ese wee na baghenji̱ be mu nsi ya Mi̱si̱li̱, aabaha ki̱i̱kalo kisemeeye kusaali̱ya bi̱i̱kalo byona ebili munsi ya Mi̱si̱li̱, mu di̱si̱tu̱li̱ki̱ti̱ ya Lamesesi̱, kusighikila haa kulaghila kwa Falaaho. ");
INSERT INTO tlj_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yojeefu̱ aaha baghenji̱ be hamui na bantu boona baa muka ya ese wee byakuliya dhee, kusighikila haa muhendo ghwa baana baabo. ");
INSERT INTO tlj_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Bwile obu njala yeeyongelela kimui, byokuliya byabula. Bantu boona baa mu nsi ya Mi̱si̱li̱ na Kanaani̱ booloba. ");
INSERT INTO tlj_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yojeefu̱ aakumaani̱ya sente syona sya Banami̱si̱li̱ na Banakanaani̱ esi baaghulaghamu byokuliya, du̱mbi̱ aasitwala mu kikaali kya Falaaho. ");
INSERT INTO tlj_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Obu bantu baa Mi̱si̱li̱ na Kanaani̱ sente syabahooyʼo, Banami̱si̱li̱ na Banakanaani̱ boona baasa ewaa Yojeefu̱, baamughila bati, “Otuhe byokuliya. Haabwaki ntu̱ku̱wa onatuloleleeye? Sente syatu syona syahooye.” ");
INSERT INTO tlj_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Du̱mbi̱ Yojeefu̱ aabakuukamu ati, “Ngoku sente syabahooyʼo, muleete bisolo byanu aliibiyo mwahi̱ngi̱si̱yamu byokuliya.” ");
INSERT INTO tlj_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Niibuwo baaleeteeye Yojeefu̱ bisolo byabo nga nkai̱na, ntaama, mbu̱li̱, nte, hamui na ndogooi̱. Aabahi̱ngi̱si̱li̱yamu byokuliya ebyabamali̱i̱si̱ye mwaka oghu. ");
INSERT INTO tlj_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Mwaka oghu obu ghwahooye, baatodha baakuuka ewaa Yojeefu̱, baaghila bati, “Mukama waatu, tatukugubha ku̱ku̱bi̱sa baa. Sente syatu syahooye kandi bisolo byatu byona, na nte ni byawe. Tatuli na kantu twati̱ghaai̱ye kuhaayo bhaatu mibili yaatu na etaka lyatu. ");
INSERT INTO tlj_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Haabwaki ntuhwelekeelela mu maaso ghaawe kuleka ntu̱ti̱gha etaka lyatu litalimu muntu? Buuye oku̱si̱i̱ma njala ku̱tu̱hwelekeeleli̱ya mu maaso ghaawe? Otughule hamui na etaka lyatu lyona, otuhemu byokuliya. Etu̱we tulaba basyana baa Falaaho, atwale na etaka lyatu. Otuhe byokuliya niikuwo tutaku̱wa, tu̱ti̱gha nsi yaatu yonkaha.” ");
INSERT INTO tlj_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Niibuwo Yojeefu̱ aaghu̱li̱ye etaka lya Banami̱si̱li̱ haabwa njala. Etaka eli lyona lyaba lya Falaaho. ");
INSERT INTO tlj_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yojeefu̱ aafoola bantu boona baa mu nsi ya Mi̱si̱li̱ kuba basyana baa Falaaho. ");
INSERT INTO tlj_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Oohi̱yʼo etaka lya bahongi̱ lyonkaha, niiliyo ataaghu̱li̱ye, nanga niibo bonkaha abataafooki̱ye kuba basyana baa Falaaho, nanga ebo byokuliya byabo byalu̱ghagha ewaa Falaaho eenini. Nahabweki ebo tabaaghwiluuwe njala, kyaleka bataaghu̱li̱ya bibanja byabo. ");
INSERT INTO tlj_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yojeefu̱ aaghambila bantu ati, “Ngoku naamali̱ye kubaghula hamui na etaka lyanu lyona lyaba lya Falaaho, nsigho ngini mughihele. ");
INSERT INTO tlj_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Bhaatu bilimuwa ebi bikaakwela, muhe Falaaho kimui kyakataano kyabiyo. Ebi̱ku̱ti̱ghalʼo mubiikʼo nsigho, na binji mubiliye enu̱we hamui na baana baanu.” ");
INSERT INTO tlj_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Baamukuukamu bati, “Waatughiliiye ngughuma, waajuna bwomi̱i̱li̱ bwatu, tukuba basyana baa Falaaho.” ");
INSERT INTO tlj_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Niibuwo Yojeefu̱ aataayʼo kilaghilo ekikwetʼo etaka munsi yoona ya Mi̱si̱li̱ kandi kilaghilo eki kinaakukola ku̱hi̱ki̱ya nʼobwalo. Kimui kyakataano kya bilimuwa byona kikubaagha kya Falaaho. Etaka lya bahongi̱ lyonkaha niiliyo litaabaaye lya Falaaho. ");
INSERT INTO tlj_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Bwile obu baana baa I̱saaleeli̱ baakala munsi ya Mi̱si̱li̱ mu ki̱twi̱ke kya Goseeni̱. Baatunga bintu bikani̱ye, baabyalila kimui kandi beeyongela kukana. ");
INSERT INTO tlj_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakobbo aamala myaka eku̱mi̱ na musanju̱ munsi ya Mi̱si̱li̱, du̱mbi̱ aahi̱ki̱ya myaka 147. ");
INSERT INTO tlj_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Obu bwile bwa I̱saaleeli̱ bwa ku̱ku̱wa bwali buli haai ku̱hi̱ka, aabilikila mutabani̱ wee Yojeefu̱, aamughila ati, “Gutu, ote ngalo yaawe hansi ya kibelo kyanje, olahile oti oliikala onambbali̱ye kandi toolinjiika munsi ya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Bhaatu obu ndi̱ku̱wa, olimpeeka, onjiye mu nsi ya Mi̱si̱li̱, onjiike hambali baaji̱i̱ki̱ye baatita.” Yojeefu̱ aamukuukamu ati, “Ndikola ngoku waabu̱ghi̱ye.” ");
INSERT INTO tlj_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakobbo aatodha aamughila ati, “Olahile.” Du̱mbi̱ Yojeefu̱ aalahila mu maaso ghe. I̱saaleeli̱ aasi̱i̱ma aneegi̱mi̱ye mwi̱gho ghuwe. ");
INSERT INTO tlj_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Haanu̱ma ya bwile mbwasaayo, baaghambila Yojeefu̱ bati, “So waawe alwaye.” Niibuwo aaghendi̱yeyo na batabani̱ be babili, Manase na Efulahi̱mu̱. ");
INSERT INTO tlj_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Obu baaghambiiye Yakobbo bati, “Mutabani̱ waawe Yojeefu̱ aasi̱ye,” Yakobbo oghu baaghilaghamu I̱saaleeli̱ eekamba, eesitami̱ya haa bulili. ");
INSERT INTO tlj_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakobbo aaghambila Yojeefu̱ ati, “Luhanga wa Bu̱toki̱ Bwona aambonekeeye munsi ya Kanaani̱, e Lu̱u̱ji̱, du̱mbi̱ ampa mu̱gi̱sa. ");
INSERT INTO tlj_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Kandi angila ati, ‘Oku̱byala baana bakani̱ye kandi nkukani̱ya muhendo ghwa lu̱byalo lwawe. Nkukufoola ki̱bbu̱la kya bantu bakaniiye kimui kandi mpe baana baawe etaka lini kuba lyabo bilo nʼebilo. Baasukulu baawe balikanila kimui, baasu̱u̱li̱ye ehanga lyabo.’ ” ");
INSERT INTO tlj_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Yakobbo aatodha aaghila Yojeefu̱ ati, “Batabani̱ baawe babili aba waabyaliiye mu Mi̱si̱li̱ muni, si̱ye ntakaasi̱ye ewaawe, bakubaluwa nga banje. Efulahi̱mu̱ na Manase bakuba banje ngoku Leu̱bbeeni̱ na Si̱mi̱yooni̱ bali baana banje. ");
INSERT INTO tlj_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Bhaatu baana boona aba okutodha ku̱byala mu bwile bukwisa, bakuba baawe kandi baligwetuwa haa etungo lya baghenji̱ baabo, Manase hamui na Efulahi̱mu̱. ");
INSERT INTO tlj_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Kyamu̱gi̱sa ghubhi, obu naakuukagha ku̱lu̱gha Padanalaamu, Lakeeli̱ akakwi̱la munsi ya Kanaani̱ ntunaghenda, tutakaseli̱ye ku̱lu̱gha mu kyalo kya Efulaati̱. Naamujiika haakpengbu̱ ya luguudhe lwa Efulaati̱” (eghi bakughilaghamu Bbeteleheemu). ");
INSERT INTO tlj_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Obu I̱saaleeli̱ aaboone baana baa Yojeefu̱ aba, aababu̱u̱li̱ya ati, “Aba mbaki?” ");
INSERT INTO tlj_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yojeefu̱ aakuukamu ati, “Mbaana banje aba Luhanga ampaaye hani.” Du̱mbi̱ Yakobbo aaghila Yojeefu̱ ati, “Obandeetele hani, niikuwo mbahe mu̱gi̱sa.” ");
INSERT INTO tlj_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Bwile obu, maaso ghaa Yakobbo taghaabonagha kulungi haabwa bukulu. Yojeefu̱ aaleeta baana be aba haai-haai kandi ese wee Yakobbo aabaghuwa mu ki̱ku̱bha. ");
INSERT INTO tlj_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Du̱mbi̱ Yakobbo oghu baaghilaghamu I̱saaleeli̱ aaghila Yojeefu̱ ati, “Tanaali nkimani̱ye nti nditodha kukubona bbaa, bhaatu Luhanga aaleki̱ye naatodha naakubona kandi Luhanga aaleki̱ye naabona na baana baawe!” ");
INSERT INTO tlj_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yojeefu̱ aaya batabhana aba haa bibelo bya Yakobbo, du̱mbi̱ aagomba, haali̱i̱so yee haaku̱ma hansi. ");
INSERT INTO tlj_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yojeefu̱ aaleeta batabani̱ be aba ewaa Yakobbo, aata Efulahi̱mu̱ haa mukono ghwa ese wee ghwabumesu, Manase haa mukono ghuwe ghwabuliyo. ");
INSERT INTO tlj_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Bhaatu Yakobbo aahi̱dha mukono ghuwe ghwabuliyo aaku̱ma Efulahi̱mu̱ haa mutuwe nankabha eye naabaagha wʼobuto. Aahi̱dha mukono ghuwe ghwabumesu aaku̱ma Manase haa mutuwe nankabha naabaagha wʼobukulu. ");
INSERT INTO tlj_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Du̱mbi̱ Yakobbo aaha Yojeefu̱ mu̱gi̱sa. Amughila ati, “Luhanga oghu taata wanje Ebbulahi̱mu̱ na tita I̱saka baalami̱yagha, Luhanga oghu aku̱ndi̱i̱si̱yagha mu bwomi̱i̱li̱ bwanje bwona ku̱hi̱ki̱ya endindi, ");
INSERT INTO tlj_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","kandi Malai̱ka oghu akajuna bwomi̱i̱li̱ bwanje, ahe batabani̱ baawe bani mu̱gi̱sa. Kandi babahe li̱i̱na lyanje, na lya baataata Ebbulahi̱mu̱ na I̱saka. Kandi babyale bakanile kimui, bamalakake nsi yoona.” ");
INSERT INTO tlj_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Bhaatu Yojeefu̱ eye obu aaboone ese wee naata mukono ghuwe ghwabuliyo haa mutuwe ghwa Efulahi̱mu̱, aasaliluwa. Niibuwo aakwete mukono ghwa ese wee ghwabuliyo aabbala kughulabhʼo Manase. ");
INSERT INTO tlj_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yojeefu̱ aamughila ati, “Tita, oni niiye mwana wamu̱li̱ghaaso, aliiye waatʼo mukono ghwawe ghwabuliyo.” ");
INSERT INTO tlj_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Bhaatu Yakobbo aabhenga, aamukuukamu ati, “Mutabani̱ wanje, nimani̱ye eki nkwete kukola. Baasukulu baa Manase nabo bakuba ntu̱la yamaani̱. Bhaatu baasukulu baa Efulahi̱mu̱ bakuba ehanga lyamaani̱.” ");
INSERT INTO tlj_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Du̱mbi̱ Yakobbo aaha mu̱gi̱sa baana aba kilo eki kyonini naaghila ati, “Bantu boona baa mu lu̱byalo lwa I̱saaleeli̱, balakoleesi̱yagha li̱i̱na lyanu obu balabaagha nibaha mu̱gi̱sa. Kandi balaghilagha bati, Luhanga abahe mu̱gi̱sa ngʼoghu aahaaye Efulahi̱mu̱ na Manase.” Yakobbo akadu̱bha ku̱ku̱mi̱ya li̱i̱na lya Efulahi̱mu̱ kwoleka ngoku aliba wamaani̱ kusaali̱ya Manase. ");
INSERT INTO tlj_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Du̱mbi̱ Yakobbo aaghambila Yojeefu̱ ati, “Ndi haai ku̱ku̱wa. Bhaatu Luhanga alaakalagha naanu bwile bwona kandi alibaku̱u̱ki̱ya ewaatu Kanaani̱, munsi eghi aahaaye baataata baanu. ");
INSERT INTO tlj_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Haa bugwetuwa obu naabahaaye enu̱we boona, uwe Yojeefu̱ naakwongeeye ki̱twi̱ke kyʼetaka lya mwena eli naahi̱yʼo Bamooli̱ na kihiyo kandi buta.” ");
INSERT INTO tlj_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Du̱mbi̱ Yakobbo aabilikila batabani̱ be, aabaghambila ati, “Mwegumbaani̱ye hamui, niikuwo mbaghambile ebikughenda kubʼo mu bilo bya mu maaso. ");
INSERT INTO tlj_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Mwise mugumbaane hani, enu̱we baana banje, mu̱ntegheeleli̱ye si̱ye eseenu̱we. ");
INSERT INTO tlj_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Uwe Leu̱bbeeni̱, niiwe mu̱li̱ghaaso ghwanje, maani̱ ghanje, kaakulolelʼo kaa maani̱ ghanje, wa ki̱ti̱i̱ni̱sa kandi wamaani̱ mu baana banje boona. ");
INSERT INTO tlj_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Bhaatu waaghu̱lu̱ki̱ye mutaano ghwawe nga maasi ghaasuuye. Toolitodha kuba na ki̱ti̱i̱ni̱sa, nanga waahali̱i̱ye ku̱ni̱i̱na haa bulili bwa so waawe, waalaala na mukali̱ wee. ");
INSERT INTO tlj_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Si̱mi̱yooni̱ na Leevi̱ ni bamui, baku̱koleesi̱yagha bihiyo byabo kwita. ");
INSERT INTO tlj_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Tankuhanuula nabo, kedha kulungana nabo mu mpanuula syabo, nanga obu baakwatu̱u̱we ki̱i̱ni̱gha, baata bantu kandi baalamali̱ya nte batali na kighendeleluwa. ");
INSERT INTO tlj_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ki̱i̱ni̱gha kisaakaaye kitiyo kikiinuwe, nanga ni kibhi. Nkubalalangi̱ya mu baasukulu baa Yakobbo, na mu baasukulu baa I̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Yu̱da, baghenji̱ baawe balaku̱ku̱ghi̱jagha. Olasi̱ngu̱lagha bananji̱ghu̱wa baawe, na baghenji̱ baawe balateeli̱yagha mu maaso ghaawe. ");
INSERT INTO tlj_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yu̱da, oli nga ntale eeti̱ye kisolo. Ekaakuukutagha elangaala yeenanula, taaliyo oghu akugubha kughitalabani̱ja. ");
INSERT INTO tlj_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Mwi̱gho ghwa bukama taghu̱li̱lu̱gha mu ka ya Yu̱da, na baasukulu baawe balabaagha balemi̱ bilo nʼebilo. Bantu baa mu ntu̱la sinji balakuleetelagha bisembo kandi balakugombelagha kukutaamu ki̱ti̱i̱ni̱sa. ");
INSERT INTO tlj_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Olabohagha ndogooi̱ yee haa kiti kya mujaabbi̱i̱bbu̱, obohe kyana kya ndogooi̱ yaawe haa mujaabbi̱i̱bbu̱ ghusemeeye. Olanaabi̱yagha ngoye syawe na vi̱i̱ni̱ kandi nkanji̱ yaawe olaghinaabi̱yagha na nsandi, nsandi mutuku elu̱ghi̱ye mu bi̱ghu̱ma bya mi̱jaabbi̱i̱bbu̱. ");
INSERT INTO tlj_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Maaso ghaawe ghatukuuye kusaali̱ya vi̱i̱ni̱ kandi maano ghaawe ni ghajelu dhiyo kusaali̱ya mata. ");
INSERT INTO tlj_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Jabbu̱looni̱ eye alaakalagha haa ki̱si̱yo kya nanja kandi ewe niiyo maati̱ aghaku̱lu̱gha mu nanja, ghaleemililagha. Mitaano yee elyesu̱kana ku̱hi̱ki̱ya Si̱dooni̱. ");
INSERT INTO tlj_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“I̱sakaali ali nga ndogooi̱ yamaani̱, eghi elangaaye haagati ya nku̱mba syayo. ");
INSERT INTO tlj_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Alimanya ati hambali ahuumuliiye hasemeeye kandi abone kyalo kyabo ki̱mu̱dheedhi̱ye. Bhaatu aliheeka nku̱mba si̱lyoti̱ye haa mughongo, bamuhambi̱li̱je kukolela banji. ");
INSERT INTO tlj_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Daani̱ aliba mu̱lemi̱ wa bantu be. Alilema bantu nga ntu̱la sinji sya I̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Daani̱ oghu aliba nga njoka ya buseguwe, eghi ekwebi̱si̱li̱lagha nkai̱na, haakpengbu̱ ya kihanda eghikonde, niikuwo mu̱ni̱i̱ni wayo eegenge. ");
INSERT INTO tlj_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Mukama, ndindiliiye kujuna kwawe! ");
INSERT INTO tlj_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gaadi̱, bananji̱ghu̱wa balikwegimba, bhaatu naawe olilwana nabo kandi obasi̱ngu̱le. ");
INSERT INTO tlj_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Aseli̱ alaliyagha byokuliya bisemeeye, alahaagha byokuliya ebibhonganuuwe kuliibuwagha bakama. ");
INSERT INTO tlj_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Nafutaali akuba nga nsama ekwete kubunga-bunga kandi eghi eku̱byalagha byana bisemeeye. ");
INSERT INTO tlj_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yojeefu̱ ali nga kiti kya mujaabbi̱i̱bbu̱, kiti ekili haa kyambu. Kikwanaghamu bi̱ghu̱ma bikani̱ye, bitai byakiyo bi̱ku̱ni̱i̱nagha haa kisiika. ");
INSERT INTO tlj_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Bananji̱ghu̱wa be balimwegimba basaakaaye, bamubhasuulile bimala, bamu̱bu̱li̱ye bu̱si̱nge. ");
INSERT INTO tlj_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Bhaatu aakale anali wamaani̱, mikono yee yaakala enagu̱mi̱ye, nanga Luhanga wa Bu̱toki̱ Bwona wa Yakobbo, Mu̱li̱i̱si̱ya kandi Mu̱li̱ndi̱ wa I̱saaleeli̱, aliikala amukwatiliiye. ");
INSERT INTO tlj_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Nanga niiye Luhanga wa so waawe oghu alakukoonelagha. Nanga niiye Luhanga wa Bu̱toki̱ Bwona oghu alakuhaagha mu̱gi̱sa, mu̱gi̱sa ghwa mu eghulu, mu̱gi̱sa mu etaka lyawe, mu̱gi̱sa ghwa lu̱byalo lwawe na lwa bisolo byawe. ");
INSERT INTO tlj_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Mu̱gi̱sa ndimakusabila Luhanga kukuha ghukaniiye kimui, ghukani̱ye kusaali̱ya myena eghi eli hani bilo nʼebilo. Mu̱gi̱sa oghu ghukuukalʼo, uwe Yojeefu̱, nanga nuuwe mwebembeli̱ wa baghenji̱ baawe. ");
INSERT INTO tlj_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Bbenjami̱i̱ni̱ oli mwaga ghusaakaliiye kimui. Nkyambisi ghukuliyagha kisolo eki ghwati̱ye kandi lwagholo ghutwala bintu byakiyo.” ");
INSERT INTO tlj_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Bani boona ni ntu̱la eku̱mi̱ nʼebili sya I̱saaleeli̱. Kandi bini niibiyo esebo aabaghambiiye, aabaha mu̱gi̱sa kandi naaghambila bu̱li̱ muntu ebibhonganuuwe kumubʼo. ");
INSERT INTO tlj_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Du̱mbi̱ Yakobbo aabalaghila ati, “Ndi haai ku̱ku̱wa! Ninaaku̱u̱ye, munjiike hambali baaji̱i̱ki̱ye tita hamui na baataata, mu ki̱i̱na kyʼebaale, mu musili oghwali ghuli ghwa Efu̱looni̱ Mu̱hi̱tahi̱ti̱. ");
INSERT INTO tlj_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Ki̱i̱na eki kili e Macepela haai na Mami̱le munsi ya Kanaani̱. Ebbulahi̱mu̱ akakighula na Efu̱looni̱ Mu̱hi̱tahi̱ti̱ kuba ki̱i̱kalo kya kujiikamu. ");
INSERT INTO tlj_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Mu ki̱i̱na omu, niiho Ebbulahi̱mu̱ na mukali̱ wee Saala baaji̱i̱ki̱i̱we. I̱saka na mukali̱ wee Lebbeeka, nabo dhee niiho baaji̱i̱ki̱i̱we. Kandi niiho naaji̱i̱ki̱ye mukali̱ wanje Leei̱ya. ");
INSERT INTO tlj_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ki̱i̱na hamui na musili oghu, Ebbulahi̱mu̱ akabighula ku̱lu̱gha mu Bahi̱ti̱.” ");
INSERT INTO tlj_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Obu Yakobbo aamali̱ye kulaghikiilila batabani̱ be, aalangala haa bulili buwe, du̱mbi̱ aatwi̱kana. ");
INSERT INTO tlj_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yojeefu̱ aaghuwa ese wee Yakobbo mu ki̱ku̱bha naanalila. ");
INSERT INTO tlj_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Du̱mbi̱ aalaghila baheeleli̱ya be abaakolagha milimo ya kujiika ati basiighe mu̱ku̱ ghwa ese wee mubaji̱ niikuwo ghutagu̱nda. Nahabweki baaghusiigha. ");
INSERT INTO tlj_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Mulimo ghwa kusiigha mu̱ku̱ ghwa Yakobbo mubaji̱ ghukamala bilo maku̱mi̱ anaa. Kandi Banami̱si̱li̱ baamala bilo nsanju̱ banamweghungiiye. ");
INSERT INTO tlj_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Bilo bya kweghunga obu byahooye, Yojeefu̱ eebinga bakulu baa mu bukama bwa Falaaho, aabaghila ati, “Gutu munkoonele, mu̱mbu̱ghi̱lane na Falaaho. ");
INSERT INTO tlj_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Mumughile muti, ‘Tita akaleka naalahila kilahilo. Tita akaghila ati, “Ndi haai ku̱ku̱wa, onjiike mu ki̱i̱na eki neelimiiye neenini munsi ya Kanaani̱.” Nahabweki oleke ngende elughulu njiike tita, du̱mbi̱ nkukuuka.’ ” ");
INSERT INTO tlj_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Falaaho aaghila ati, “Oghende ojiike so waawe, ohi̱ki̱i̱li̱li̱ye ekyaleki̱ye aakulahi̱li̱ya.” ");
INSERT INTO tlj_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Du̱mbi̱ Yojeefu̱ aaghenda Kanaani̱ kujiika ese wee. Bengei̱ baa mu bukama bwa Falaaho boona hamui na bakoli̱ baa mu ki̱i̱tu̱u̱bbi̱ kya bilaghilo mu nsi ya Mi̱si̱li̱ baahelekeeleli̱ya Yojeefu̱. ");
INSERT INTO tlj_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Aaghenda na bantu baa ka yee boona, baghenji̱ be boona, hamui nʼabaakalagha mu ka ya ese wee boona. Baana baabo na bu̱hi̱yo bwabo, niibiyo byati̱ghaaye e Goseeni̱. ");
INSERT INTO tlj_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Bafu̱gi̱ baa bigaali̱ hamui na baa nkai̱na, nabo baaghenda naye. Bantu bakaniiye kimui baamu̱helekeeleli̱ya. ");
INSERT INTO tlj_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Obu baahi̱ki̱ye Atadi̱ hambali baasihilagha ngano, haai na Yolodaani̱, balilila kimui na maani̱ nʼelaka liinamu̱li̱to, Yojeefu̱ aamala bilo musanju̱ aneeghungiiye ese wee. ");
INSERT INTO tlj_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Obu Banakanaani̱ abaakalagha Atadi̱ hambali baasihilagha ngano baaboone ngoku Banami̱si̱li̱ beeghungiiye Yakobbo, baaghila bati, “Kweghunga kwa Banami̱si̱li̱ nkwamaani̱.” Eki niikiyo kyaleki̱ye ki̱i̱kalo eki, ekili haai na Yolodaani̱, baakighilamu “Abbeli̱-mi̱si̱lahi̱mu̱.” ");
INSERT INTO tlj_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Nahabweki batabani̱ baa Yakobbo baakola ngoku aabalaghiiye. ");
INSERT INTO tlj_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Baamuheeka, baamutwala mu nsi ya Kanaani̱, baamujiika mu ki̱i̱na kyʼebaale ekili mu musili ghwa Macepela, haai na Mami̱le, eki Ebbulahi̱mu̱ aaghu̱li̱ye ewaa Efu̱looni̱ Mu̱hi̱tahi̱ti̱, kili kya kujiikaghamu. ");
INSERT INTO tlj_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yojeefu̱ obu aamali̱ye kujiika ese wee, aakuuka munsi ya Mi̱si̱li̱ hamui na baghenji̱ be boona, na bantu boona aba aali aghendi̱ye nabo kujiika ese wee. ");
INSERT INTO tlj_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Obu baghenji̱ baa Yojeefu̱ baaboone esebo amali̱ye ku̱ku̱wa, baatandika kughila bati, “Ti̱ buuye Yojeefu̱ na naanakwatu̱u̱we ki̱i̱ni̱gha, aatu̱wamu kuhoola ngi̱ghu̱ haabwa nsobi̱ syona esi twamu̱sobeleei̱ye?” ");
INSERT INTO tlj_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Niibuwo baatu̱mi̱ye butumuwa ewaa Yojeefu̱, baaghila bati, “So waawe atakaku̱u̱ye akaghila ati, ");
INSERT INTO tlj_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Mughile Yojeefu̱ muti: “Nkukusaba oghanile baghenji̱ baawe bikoluwa bi̱bhi̱i̱hi̱ye na kibhi kyabo, nanga bakakukolʼo bintu bi̱bhi̱i̱hi̱ye.” Gutu oghanile bikoluwa bi̱bhi̱i̱hi̱ye bya basyana baa Luhanga wa so waawe.’ ” Obu Yojeefu̱ aaghu̱u̱ye makulu agha, aalila. ");
INSERT INTO tlj_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Baghenji̱ be du̱mbi̱ baasa baaghuwa mu maghulu ghe, baamughila bati, “Tuli basyana baawe.” ");
INSERT INTO tlj_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Yojeefu̱ aabaghila ati, “Muleke kwobaha. Tankugubha kusitama mu ntebe ya Luhanga. ");
INSERT INTO tlj_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Mukakighendelela kunkola kubhi, bhaatu Luhanga akakighendelela haabwa bulungi kumaliilila ebikwete kukoluwa endindi, kujuna bwomi̱i̱li̱ bwa bantu bakani̱ye. ");
INSERT INTO tlj_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Nahabweki mutoobaha, nkubaloleelela, enu̱we na baana baanu boona.” Niibuwo aabeebi̱ngi̱ye, aatandika ku̱bu̱gha nabo kusemeeye. ");
INSERT INTO tlj_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yojeefu̱ akaakala munsi ya Mi̱si̱li̱, na baghenji̱ be boona. Akamala munsi myaka 110, ");
INSERT INTO tlj_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","kandi Yojeefu̱ akabonʼo buusukulu bwa kasatu bwa baana baa Efulahi̱mu̱. Aalelʼo dhee baana baa Maki̱li̱, mutabani̱ wa Manase. ");
INSERT INTO tlj_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Du̱mbi̱ Yojeefu̱ aaghila baghenji̱ be ati, “Ndi haai ku̱ku̱wa. Bhaatu mu majima, Luhanga aliisa kubakoonela kandi alibaaya mu nsi eni, abatwale mu nsi eghi aalaghi̱i̱sani̱i̱ye Ebbulahi̱mu̱, I̱saka, na Yakobbo.” ");
INSERT INTO tlj_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yojeefu̱ aalahi̱li̱ya baana baa I̱saaleeli̱ ati, “Majima kuwo Luhanga alibakoonela kandi mukutwala maku̱wa ghanje ku̱lu̱gha hani.” ");
INSERT INTO tlj_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Niibuwo Yojeefu̱ aaku̱u̱ye amali̱ye ku̱hi̱ki̱ya myaka 110. Baasiigha mu̱ku̱ ghuwe, baaghuta mu sandu̱u̱ku̱ mu nsi ya Mi̱si̱li̱.");
INSERT INTO tlj_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Ghani niigho mali̱i̱na ghaa batabani̱ baa I̱saaleeli̱ (oghu ni Yakobbo), abaaghendi̱ye naye mu ehanga lya Mi̱si̱li̱, bu̱li̱ omui na ka yee: ");
INSERT INTO tlj_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Leu̱bbeeni̱, Si̱mi̱yooni̱, Leevi̱, Yu̱da, ");
INSERT INTO tlj_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","I̱sakaali, Jabbu̱looni̱, Bbenjami̱i̱ni̱, ");
INSERT INTO tlj_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Daani̱, Nafutaali, Gaadi̱ na Aseli̱. ");
INSERT INTO tlj_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Muhendo ghwa batabani̱ na baasukulu baa Yakobbo, boona bakaba bali bantu nsanju̱. Mutabani̱ wee Yojeefu̱ akaba asangu̱u̱we ali Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Haanu̱ma ya bwile kuhuwʼo, Yojeefu̱, baghenji̱ be boona na bantu bakulu boona baa mujo oghu, baaku̱wa. ");
INSERT INTO tlj_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Bhaatu baasukulu baa I̱saaleeli̱ baabyala baana kandi baakanila kimui, baaba baamaani̱ kandi baasula mu nsi ya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Bwile obu, mukama muhyaka oghu akaba atamani̱ye Yojeefu̱ aalema mu Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Aaghila bantu be ati, “Mulole, Banai̱saaleeli̱ baakaniiye kimui kandi bali na maani̱ ghasaaye ghaatu. ");
INSERT INTO tlj_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Muleke tutʼo ntegheka ya kubatanga kweyongela kukana, nanga naanabaayʼo bulemo, bakwelungani̱ya na ngi̱ghu̱ syatu batulwani̱i̱si̱ye kandi baaluke mu ehanga lyatu.” ");
INSERT INTO tlj_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Nahabweki Banami̱si̱li̱ baatandika ku̱koleesi̱ya Banai̱saaleeli̱ nga basyana baabo. Baabateelʼo abakubaloleelela haa milimo kubabona-boni̱ya mbabaha kukola milimo yamaani̱. Baakwelela Falaaho bibugha bibili bya kubiikilamu bintu, Pi̱toomu̱ na Lamu̱sesi̱. ");
INSERT INTO tlj_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Bhaatu ngoku baakeeyongelagha kubabona-boni̱ya, niikuwo Banai̱saaleeli̱ beeyongelagha kukana kandi kumalakaka nsi eghi yoona. Banami̱si̱li̱ baatandika kwobaha Banai̱saaleeli̱ aba. ");
INSERT INTO tlj_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Nahabweki baatandika kuhambi̱li̱ja Banai̱saaleeli̱ kukola na maani̱. ");
INSERT INTO tlj_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Baababona-boni̱ya mbabaha kukola milimo yamaani̱ ya kukpeeta bulongo kandi kubumbamu matafaali na kukola milimo yoona mu Mi̱si̱li̱. Tabaabaghililagha kisa. ");
INSERT INTO tlj_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Mukama wa Mi̱si̱li̱ aalaghila bakali̱ Bahebbulaayo babyali̱i̱si̱ya, Sifula na Puha ati, ");
INSERT INTO tlj_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Obu mulabaagha ni̱mu̱byali̱i̱si̱ya bakali̱ Bahebbulaayo, nimwaboone abyaye mwana wabusaasa, mwana oghu mumwitaghe, bhaatu naabyaye wabukali̱, mumulekaghe ali mwomi̱i̱li̱.” ");
INSERT INTO tlj_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Bhaatu bakali̱ babyali̱i̱si̱ya aba bakaba boobahi̱ye Luhanga kandi bataakola eki mukama wa Mi̱si̱li̱ aabalaghiiye. Baaleka baana baabusaasa bali boomi̱i̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Niibuwo mukama oghu aabilikiiye bakali̱ babyali̱i̱si̱ya aba, aababu̱u̱li̱ya ati, “Nkiki mukwete kukola kubhenga kwita baana baabusaasa?” ");
INSERT INTO tlj_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Bakali̱ aba baakuukamu Falaaho bati, “Bakali̱ Bahebbulaayo tabali nga bakali̱ Banami̱si̱li̱, bali na maani̱ kandi baku̱byalagha bwangu mubyali̱i̱si̱ya atakabaki̱dhi̱yʼo.” ");
INSERT INTO tlj_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Nahabweki Luhanga aaghilila kisa bakali̱ babyali̱i̱si̱ya aba kandi Banai̱saaleeli̱ beeyongela kukana kandi kuba baamaani̱. ");
INSERT INTO tlj_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Bakali̱ aba haabwa kwobaha Luhanga, aaleka baabyala baana kandi baatunga maka. ");
INSERT INTO tlj_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Niibuwo Falaaho aalaghiiye bantu be boona ati, “Mwana weena wabusaasa oghu mukali̱ Muhebbulaayo alabyalagha, mumukubaghe mu maasi ghaa Nailo, bhaatu baabukali̱ mubalekaghe bali boomi̱i̱li̱.” ");
INSERT INTO tlj_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Hakaba haliyo musaasa wʼomu ntu̱la ya Leevi̱, aaswela omui haa baasukulu baa Leevi̱. ");
INSERT INTO tlj_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Mukali̱ oghu aaku̱li̱ya kandi aabyala mwana wabusaasa. Obu aaboone mwana oghu asemeeye, aamu̱bi̱sa haabwa meeli̱ asatu. ");
INSERT INTO tlj_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Obu ataagu̱bhi̱ye kuukala anamu̱bi̱si̱ye, aamubbalila kighegha ki̱koleeu̱we mu nduko, aakisiigha kuluudu kandi aataamu mwana oghu, du̱mbi̱ aakita mu bikaaka haa ki̱si̱yo kya maasi ghaa Nailo. ");
INSERT INTO tlj_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Mu̱ghenji̱ wa mwana oghu wabukali̱ eemilila hambali haseli̱yʼo, kulola ekikubʼo mwana oghu. ");
INSERT INTO tlj_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Bwile obu, muhala wa mukama Falaaho aasa haa maasi haala kunaaba, baheeleli̱ya be mbanalubhatangila haa ki̱si̱yo kyaghʼo. Aabona kighegha kili mu bikaaka, du̱mbi̱ aatuma mu̱heeleli̱ya wee kukileeta. ");
INSERT INTO tlj_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Muhala wa mukama oghu aakiighula kandi aabonamu mwana wabusaasa naalila. Aamukwatiluwa kisa kandi aaghila ati, “Mulole oni ni omui mu baana baa Bahebbulaayo.” ");
INSERT INTO tlj_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Du̱mbi̱ mu̱ghenji̱ wa mwana oghu wabukali̱ aaghila muhala wa Falaaho ati, “Buuye ngende mbilikile omui mu bakali̱ Bahebbulaayo akwonkeli̱ye mwana oghu?” ");
INSERT INTO tlj_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Muhala wa Falaaho aamukuukamu ati, “Oghende.” Nahabweki mwana wabukali̱ oghu aaghenda kandi aaleeta ni̱na mwana oghu. ");
INSERT INTO tlj_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Muhala wa Falaaho aamughila ati, “Otwale mwana oni, omu̱nonkeli̱ye, nkukusasula.” Nahabweki mukali̱ oghu aatwala mwana oghu kandi aatandika ku̱mwonki̱ya. ");
INSERT INTO tlj_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Obu mwana oghu aaku̱li̱ye, mukali̱ oghu aamuleetela muhala wa Falaaho kandi aafooka mutabani̱ wee. Muhala wa Falaaho aamuluka li̱i̱na Musa. Aaghila ati, “Nanga nkamuuya mu maasi.” ");
INSERT INTO tlj_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Obu Musa aaku̱li̱ye, kilo kimui aaghenda kubungila Bahebbulaayo baanakiye kandi aabona ngoku bakwete kubakoleesi̱ya milimo yamaani̱. Aabona dhee Munami̱si̱li̱ naahuula Muhebbulaayo, omui mu bantu bʼehanga lya Musa. ");
INSERT INTO tlj_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Musa aalolakaka mpande syona. Obu aaboone ngu taaliyo muntu nʼomui, aata Munami̱si̱li̱ oghu kandi aabi̱sa mu̱ku̱ ghuwe mu musene. ");
INSERT INTO tlj_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Kilo ekyalabhi̱yʼo, aatodha aaghendayo kandi aabona Bahebbulaayo babili mbalwana. Aaghila oghu aasobeei̱ye ati, “Okwete kuhuula Muhebbulaayo muunakyawe nangaaki?” ");
INSERT INTO tlj_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Musaasa oghu aamukuukamu ati, “Ni ani̱ aakufooye mu̱lemi̱ kandi mu̱cu̱ waatu? Okubbala kunjita ngoku waati̱ye Munami̱si̱li̱?” Du̱mbi̱ Musa oobaha kandi eeli̱li̱kana ati, “Bantu baamani̱ye eki naakoli̱ye.” ");
INSERT INTO tlj_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Obu Falaaho aaghu̱u̱ye eki, aalengʼo kwita Musa. Bhaatu Musa aaluka ewaa Falaaho kandi aaghenda kuukala mu kyalo kya Mi̱di̱yaani̱. Obu aaki̱dhi̱ye mu kyalo eki, aaghenda kandi asitama haai na kyahu̱dhu̱. ");
INSERT INTO tlj_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Mu̱hongi̱ wʼomu kyalo kya Mi̱di̱yaani̱ eki akaba ali na bahala be musanju̱. Bwile obu baasa kutaha maasi haa kyahu̱dhu̱ eki ku̱u̱su̱li̱ya maati̱ kandi bisolo bya esebo kunwelamu. ");
INSERT INTO tlj_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Bamui mu bali̱i̱si̱ya baasa kandi baatandika kubhingʼo baana baabukali̱ aba, bhaatu Musa aamuka, aabalwanilila kandi aaha bisolo bya esebo maasi. ");
INSERT INTO tlj_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Obu baana baabukali̱ aba baaki̱dhi̱ye ewaa esebo Leu̱weli̱, aababu̱u̱li̱ya ati, “Obwalo mwaku̱u̱ki̱ye bwangu nangaaki?” ");
INSERT INTO tlj_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Baamukuukamu bati, “Musaasa Munami̱si̱li̱ niiye aatu̱ju̱ni̱ye bali̱i̱si̱ya. Aatutahiiye maasi mu kyahu̱dhu̱ kandi aaha bisolo byatu byanuwa.” ");
INSERT INTO tlj_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Aaghila bahala be aba ati, “Musaasa oghu ali haa? Mwamu̱ti̱ghi̱yeyo nangaaki? Mughende mubilikile aase aliye byokuliya.” ");
INSERT INTO tlj_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Nahabweki Musa aasi̱i̱ma kuukala na musaasa oghu kandi aaha Musa muhala wee Jipola kumuswela. ");
INSERT INTO tlj_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Jipola aabyala mwana wabusaasa kandi Musa aaghila bantu aba ati, “Naasi̱mi̱lani̱bu̱u̱we kuukala nga munamahanga mu nsi eni eghi etali yanje, nahabweki li̱i̱na liye niiye Geli̱soomu̱.” ");
INSERT INTO tlj_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Haanu̱ma ya myaka ekani̱ye kusaala, mukama wa Mi̱si̱li̱ aaku̱wa kandi Banai̱saaleeli̱ beeyongela kutaagha mbabbala bu̱kooneli̱. Luhanga aaghu̱wa kutaagha kwabo haabwa kubakoleesi̱ya nga basyana. ");
INSERT INTO tlj_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Aaghu̱wa kutaagha kwabo kandi aasuka ndaghaano eghi aakoli̱ye na Ebbulahi̱mu̱, I̱saka na Yakobbo. ");
INSERT INTO tlj_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Luhanga aabona ngoku Banai̱saaleeli̱ bakwete kubona-bona kandi aabbala kubakoonela. ");
INSERT INTO tlj_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Kilo kimui obu Musa aali̱i̱si̱yagha bisolo bya nkyame siye Yetelo, mu̱hongi̱ wa Mi̱di̱yaani̱. Musa aatwala bisolo bya nkyame siye oghu, haa luhande lwa bughuwa ejooba bwa elungu eli kandi aaki̱dha Holebbu, haa mwena ghwa Luhanga. ");
INSERT INTO tlj_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Malai̱ka wa Mukama aamubonekela ali mu mulilo oghwakagha hagaati ya kati. Musa aabona mulilo ngwaka mu kati aka bhaatu kataakuhiya. ");
INSERT INTO tlj_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Musa aaghila ati, “Oleke neebinge kati aka kandi ndole kintu kyakuswekani̱ya kini. Kati aka takakwete kuhiya nangaaki?” ");
INSERT INTO tlj_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Obu Mukama aaboone Musa naaneebinga kati aka kulola, Luhanga aabilikila Musa ku̱lu̱gha haagati ya kati aka, aamughila ati, “Musa! Musa!” Musa aaghila ati, “Ndi hani.” ");
INSERT INTO tlj_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Luhanga aamughila ati, “Oteebinga hani, ooyemu nkai̱to mu bighele byawe, nanga ki̱i̱kalo eki weemiliiyʼo ni etaka li̱hi̱ki̱li̱i̱ye.” ");
INSERT INTO tlj_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Aatodha aaghila Musa ati, “Ni̱i̱si̱ye Luhanga oghu so waawe aalami̱yagha, Luhanga wa Ebbulahi̱mu̱, Luhanga wa I̱saka kandi Luhanga wa Yakobbo.” Obu Musa aaghu̱u̱ye eki, eeswi̱ki̱la haali̱i̱so, nanga akoobaha kulola Luhanga. ");
INSERT INTO tlj_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Niibuwo Mukama aaghi̱li̱ye ati, “Naaboone ngoku bantu banje abali mu Mi̱si̱li̱ bakwete kubona-bona kandi naaghu̱u̱ye kutaagha kwabo haabwa bantu abakwete kubahambi̱li̱ja kukola milimo yamaani̱. Nimani̱ye ngoku bakwete kubatwalikani̱ya kubhi. ");
INSERT INTO tlj_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Nahabweki naasi̱ye hansi kujuna bantu aba, kubaaya mu nsi ya Mi̱si̱li̱, kubaleeta mu nsi eghi esemeeye kandi eghi ekwete kusendamu mata na bwoki, nsi ya Banakanaani̱, Bahi̱ti̱, Bamooli̱, Bapeleeji̱, Bahi̱vi̱ na Bayebu̱si̱. ");
INSERT INTO tlj_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Olole, kutaagha kwa Banai̱saaleeli̱ kwampi̱ki̱yʼo kandi naaboone ngoku Banami̱si̱li̱ bakwete kubabona-boni̱ya. ");
INSERT INTO tlj_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Nahabweki oghende ewaa Falaaho, ndimakutumayo kuhikila bantu banje Banai̱saaleeli̱ kubaaya mu nsi ya Mi̱si̱li̱.” ");
INSERT INTO tlj_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Musa aakuukamu Luhanga ati, “Ni̱i̱syoni ani̱, kughenda ewaa Falaaho kandi kuuya Banai̱saaleeli̱ mu nsi ya Mi̱si̱li̱?” ");
INSERT INTO tlj_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Luhanga aamukuukamu ati, “Nkuba naawe kandi kani niiko kaakulolelʼo kwoleka ngoku haali̱i̱si̱ye naaku̱tu̱mi̱ye. Okaakuuya bantu aba mu nsi ya Mi̱si̱li̱, mukundami̱li̱ya haa mwena ghuni.” ");
INSERT INTO tlj_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Bhaatu Musa aakuukamu Luhanga ati, “Kaakuba ngenda mu Banai̱saaleeli̱ kandi mbaghila nti, ‘Luhanga wa baataata baanu antu̱mi̱ye ewaanu,’ baku̱mbu̱u̱li̱ya bati, ‘Li̱i̱na liye niiye ani̱?’ Buuye mbakuukemu nti̱ya?” ");
INSERT INTO tlj_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Luhanga aaghila Musa ati, “Ndi ngoku Ndi. Oghile Banai̱saaleeli̱ aba oti, ‘Ndi antu̱mi̱ye ewaanu.’ ” ");
INSERT INTO tlj_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Luhanga aatodha aaghila Musa ati, “Oghile Banai̱saaleeli̱ oti, ‘Mukama Luhanga wa baataata baanu, Luhanga wa Ebbulahi̱mu̱, Luhanga wa I̱saka kandi Luhanga wa Yakobbo antu̱mi̱ye ewaanu.’ Lini niiliyo li̱i̱na lyanje bilo nʼebilo. Li̱i̱na eli bantu baa mijo yoona bali na kuukala baasu̱ki̱ye.” ");
INSERT INTO tlj_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Oghende, okumaani̱ye beebembeli̱ baa Banai̱saaleeli̱ kandi obaghile oti, ‘Mukama Luhanga wa baataata baanu, Luhanga wa Ebbulahi̱mu̱, I̱saka na Yakobbo, ambonekeeye kandi angila ati: Naaloli̱ye kwonini bantu banje abali Mi̱si̱li̱ kandi naaboone bintu bi̱bhi̱i̱hi̱ye ebi Banami̱si̱li̱ bakwete kubakolʼo. ");
INSERT INTO tlj_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Naalaghi̱i̱sani̱i̱ye kubaaya mu kubona-bona mu nsi ya Mi̱si̱li̱ kandi kubatwala mu nsi ya Banakanaani̱, Bahi̱ti̱, Bamooli̱, Bapeleeji̱, Bahi̱vi̱ na Bayebu̱si̱, nsi eghi ekwete kusendamu mata na bwoki.’ ” ");
INSERT INTO tlj_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Beebembeli̱ baa Banai̱saaleeli̱ baku̱u̱ghu̱wa ebi okubaghambila. Du̱mbi̱ oghende nabo ewaa mukama Falaaho kandi omughile oti, ‘Mukama Luhanga wa Bahebbulaayo, aasi̱ye aatweyoleka. Otu̱si̱i̱mi̱lani̱ye kughenda mu lughendo lwa bilo bisatu mu elungu kuhongela bihonguwa Mukama Luhanga waatu.’ ");
INSERT INTO tlj_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Bhaatu nimani̱ye ngoku mukama wa Mi̱si̱li̱ ataakubaleka kughenda ku̱hi̱ki̱ya mukono ghwa bu̱toki̱ ghumuhambi̱li̱i̱je. ");
INSERT INTO tlj_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Nahabweki nkunanula mukono ghwanje kandi nkuha Banami̱si̱li̱ kifubilo haabwa byakuswekani̱ya byona ebi nkubakolamu. Haanu̱ma yʼeki akubaleka mughende. ");
INSERT INTO tlj_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Nkuleka Banami̱si̱li̱ baghilile enu̱we kisa, niikuwo bantu banje malu̱ghayo, bataghenda batali na kantu. ");
INSERT INTO tlj_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Bu̱li̱ mukali̱ Munai̱saaleeli̱ akughenda ewaa mukali̱ muunakiye Munami̱si̱li̱ kedha ewaa mukali̱ weena Munami̱si̱li̱ oghu aakaaye mu numba yee. Asabe mukali̱ oghu siliva, feeja na ngoye, esi mu̱ku̱lu̱wi̱ka batabani̱ na bahala baanu. Niikuwo mukutwala mutiyo bintu bya mughaso bya Banami̱si̱li̱.” ");
INSERT INTO tlj_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Musa aakuukamu ati, “Buuye nkole ki kaakuba Banai̱saaleeli̱ batampi̱ki̱li̱ja kedha ku̱u̱ghu̱wa ebi nku̱bu̱gha kandi baghila bati ‘Mukama taakubonekeeye?’ ” ");
INSERT INTO tlj_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Mukama aamughila ati, “Mbiki okwete mu ngalo yaawe?” Musa aamughila ati, “Mwi̱gho.” ");
INSERT INTO tlj_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Mukama aamughila ati, “Oghukube hansi.” Obu Musa aaghu̱ku̱bi̱ye hansi, ghwafooka njoka kandi Musa aaghi̱li̱gi̱ta. ");
INSERT INTO tlj_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Bhaatu Mukama aaghila Musa ati, “Onanule mukono ghwawe, oghikwate haa mukila.” Musa aananula mukono ghuwe kandi aaghikwata haa mukila, yaatodha yaafooka mwi̱gho mu ngalo yee. ");
INSERT INTO tlj_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Mukama aamughila ati, “Okole eki niikuwo Banai̱saaleeli̱ bahi̱ki̱li̱je ngu Mukama Luhanga wa baataata baabo, Luhanga wa Ebbulahi̱mu̱, Luhanga wa I̱saka kandi Luhanga wa Yakobbo, aakubonekeeye.” ");
INSERT INTO tlj_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Mukama aatodha aamughila ati, “Ote mukono ghwawe mukati ya kooti̱ yaawe.” Musa aata mukono ghuwe mukati ya kooti̱ yee, obu aaghu̱u̱hi̱yemu ghukaba ghulwaye ntumbi kandi ghuli ghunjelu nga bilika. ");
INSERT INTO tlj_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Mukama aatodha aaghila Musa ati, “Otodhe ote mukono ghwawe mukati ya kooti̱ yaawe.” Musa aatodha aata mukono ghuwe mukati ya kooti̱ yee, obu aaghu̱u̱hi̱yemu, ghukaba ghu̱ki̱li̱ye nga mubili ghuwe ghunji ghwona. ");
INSERT INTO tlj_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Mukama aaghila ati, “Kaakuba babhenga ku̱ku̱hi̱ki̱li̱ja kedha ku̱si̱i̱ma kabonelo kʼoku̱du̱bha, bakugubha ku̱hi̱ki̱li̱ja kabonelo kaakabili. ");
INSERT INTO tlj_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Kaakuba babhenga ku̱hi̱ki̱li̱ja bubonelo bubili buni kedha ku̱ku̱tegheeleli̱ya, otahe maasi mu maasi ghaa Nailo kandi oghaseese haa etaka lyomi̱ye. Maasi agha waatahi̱ye mu Nailo agha ghakufooka saghama haa etaka lyomi̱ye eli.” ");
INSERT INTO tlj_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Bhaatu Musa aaghila Mukama ati, “Ai̱ Mukama wanje, tandi muntu oghu amani̱ye ku̱bu̱gha kusemeeye mu bwomi̱i̱li̱ bwanje, nankabha endindi obu nkwete ku̱bu̱gha naawe, niibuwo naabhubhuutila.” ");
INSERT INTO tlj_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Niibuwo Mukama aamu̱ghi̱li̱ye ati, “Ni ani̱ akakola kanu̱wa kaa muntu? Ni ani̱ akumufoolagha ntaama-taami̱ kedha matui kumuughala, kedha kubona, kedha maaso kumuughala? Taani̱i̱si̱ye, Mukama? ");
INSERT INTO tlj_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Oghende endindi Mi̱si̱li̱, nkukukoonela kandi nkukughambila ebi oku̱bu̱gha.” ");
INSERT INTO tlj_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Bhaatu Musa aaghila ati, “Ai̱, Mukama wanje, gutu otume muntu onji.” ");
INSERT INTO tlj_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Mukama aasaaliluwa na Musa kandi aamughila ati, “Ti̱ mu̱ghenji̱ waawe Alooni̱, Mu̱leevi̱? Nimani̱ye ngoku akugubha ku̱bu̱gha kusemeeye. Olole, niibuwo aasa kukusangaana kandi akaakukubona, akudheedhuwa haa mutima ghuwe. ");
INSERT INTO tlj_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Obu̱ghe naye kandi omughambile bighambo ebi aku̱bu̱gha. Nkukoonela enu̱we bombi kandi nku̱beegheesi̱ya ebi mukukola. ");
INSERT INTO tlj_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Niiye aku̱bu̱gha na bantu aba mu ki̱i̱kalo kyawe. Akuba mu̱bu̱ghi̱i̱li̱li̱ waawe kandi okuba ewe nga Luhanga kumughambila ebi aku̱bu̱gha. ");
INSERT INTO tlj_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Okwate mu ngalo yaawe mwi̱gho oghu, oku̱ghu̱koleesi̱ya kukola bwakulolelʼo.” ");
INSERT INTO tlj_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Musa aakuuka ewaa nkyame siye Yetelo, aamughila ati, “Gutu oleke nkuuke mu baghenji̱ banje abali Mi̱si̱li̱, kulola balakaba banaakaaye.” Nkyame siye Yetelo aamughila ati, “Oghende mpempa.” ");
INSERT INTO tlj_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Musa obu aabaagha anali Mi̱di̱yaani̱ Mukama akaba naamu̱ghi̱li̱ye ati, “Okuuke Mi̱si̱li̱, nanga basaasa abaabbalagha kukwita baaku̱u̱ye.” ");
INSERT INTO tlj_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Niibuwo Musa aakwate mukali̱ wee na batabani̱ be, aabata haa ndogooi̱ kandi aakuuka mu nsi ya Mi̱si̱li̱. Aaghenda akwete mwi̱gho ghwa Luhanga mu ngalo yee. ");
INSERT INTO tlj_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Mukama aaghila Musa ati, “Okaakukuuka mu Mi̱si̱li̱, olole ngu waakoli̱ye byakuswekani̱ya byona mu maaso ghaa Falaaho. Byakuswekani̱ya ebi naakuhaaye maani̱ kukola. Bhaatu nkwomakakani̱ya mutima ghuwe, niikuwo atasi̱i̱mi̱lani̱ya bantu aba kughenda.” ");
INSERT INTO tlj_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Oghambile Falaaho oti, “Mukama akwete kughila ati, ‘I̱saaleeli̱ niiye mutabani̱ wanje mu̱li̱ghaaso. ");
INSERT INTO tlj_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ndimakulaghila ku̱si̱i̱mi̱lani̱ya mutabani̱ wanje oghu kughenda, niikuwo agubhe ku̱mpeeleli̱ya. Kaakuba obhenga ku̱mu̱si̱i̱mi̱lani̱ya kughenda, nkwita mutabani̱ waawe mu̱li̱ghaaso.’ ” ");
INSERT INTO tlj_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Obu baanabaagha mu kihanda kukuuka Mi̱si̱li̱, baaki̱dha mu ki̱i̱kalo hambali eye na bantu baa ka yee baalaaye, Mukama aasa ku̱lu̱mba Musa kandi aabbala kumwita. ");
INSERT INTO tlj_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Niibuwo Jipola aakwete muhiyo ghwoghiiye ghwa ebaale, aasala mutabani̱ wee. Aakwata kisusu eki kandi aaki̱ku̱mi̱ya Musa haa bighele, aamughila ati, “Majima kuwo, waabaaye bali̱i̱ wanje wa saghama.” ");
INSERT INTO tlj_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Obu Jipola aaghi̱li̱ye ati, “Waabaaye bali̱i̱ wanje wa saghama,” aabu̱ghaghʼo kusaluwa kwa mutabani̱ wee. Haanu̱ma yʼeki, Mukama ataakolʼo Musa kabhi koona. ");
INSERT INTO tlj_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Mukama aaghila Alooni̱ ati, “Oghende mu elungu, kusangaana Musa.” Nahabweki Alooni̱ aaghenda kandi aasangaana Musa haa mwena ghwa Luhanga kandi aaghuwa Musa mu ki̱ku̱bha. ");
INSERT INTO tlj_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Musa aaghambila Alooni̱ bighambo byona ebi Mukama aamu̱tu̱mi̱ye ku̱bu̱gha, na bwakulolelʼo bwona obu aamulaghiiye kukola. ");
INSERT INTO tlj_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Niibuwo Musa na Alooni̱ baaghendi̱ye Mi̱si̱li̱, baakumaani̱ya beebembeli̱ boona baa Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Alooni̱ aabu̱gha bighambo byona ebi Mukama aabu̱ghi̱ye na Musa kandi Musa aakola byakuswekani̱ya ebi mu maaso ghaa bantu, ");
INSERT INTO tlj_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","kandi Banai̱saaleeli̱ baahi̱ki̱li̱ja. Obu baaghu̱u̱ye ngu Mukama aabungiiye Banai̱saaleeli̱ kandi aaboone kubona-bona kwabo, baateeli̱ya kandi baamulami̱ya. ");
INSERT INTO tlj_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Niibuwo Musa na Alooni̱ baaghendi̱ye ewaa Falaaho, baamughila bati, “Mukama Luhanga wa I̱saaleeli̱ akwete kughila ati, ‘Oleke bantu banje baghende, niikuwo bankolele ki̱ghenu̱ mu elungu.’ ” ");
INSERT INTO tlj_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Bhaatu Falaaho aaghila ati, “Oghu ni Mukama ki, oghu si̱ye mbhonganuuwe ku̱u̱ghu̱wa kandi ku̱si̱i̱mi̱lani̱ya Banai̱saaleeli̱ kughenda? Mukama oghu tanimumani̱ye kandi tanku̱si̱i̱mi̱lani̱ya Banai̱saaleeli̱ kughenda.” ");
INSERT INTO tlj_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Baamughila bati, “Luhanga wa Bahebbulaayo aatubonekeeye. Gutu otu̱si̱i̱mi̱lani̱ye kughenda mu lughendo lwa bilo bisatu mu elungu niikuwo tugubhe kuhongela kihonguwa Mukama Luhanga waatu. Kaakuba tutakola eki, akutwita na ndwala kedha kihiyo.” ");
INSERT INTO tlj_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Bhaatu mukama wa Mi̱si̱li̱ aabaghila ati, “Musa na Alooni̱ mukubbala kuuya bantu haa milimo yabo nangaaki? Enu̱we bantu boona mukuuke haa mulimo yaanu!” ");
INSERT INTO tlj_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Falaaho aatodha aaghila ati, “Mulole, bantu aba bakani̱ye mu nsi yaatu, bhaatu mukubbala muti baleke kukola milimo yabo.” ");
INSERT INTO tlj_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Kilo eki kyonini Falaaho aalaghila bakulu baa milimo na abaaloleelelagha bakoli̱ ati, ");
INSERT INTO tlj_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Bantu aba mutatodha kubaha bi̱si̱ngo kubumba matafaali ngoku mwakolagha, muleke baghende kandi babbale bi̱si̱ngo boonini. ");
INSERT INTO tlj_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Bhaatu muhendo ghwa matafaali oghu baadu̱bhagha kubumba, haaliighuwo baakala mbanabumba, mutaghu̱keehi̱yʼo, nanga bantu aba mbaghala. Eki niikiyo ki̱leki̱ye mbataagha bati, ‘Muleke tughende kandi tuhonge kihonguwa ewaa Luhanga waatu.’ ");
INSERT INTO tlj_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Muhe bantu aba milimo yamaani̱ niikuwo bakole na maani̱ kandi baleke ku̱tegheeleli̱ya bighambo bya bisubha.” ");
INSERT INTO tlj_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Du̱mbi̱ bakulu baa milimo na abaaloleelelagha bakoli̱ baaghenda kandi baaghambila bantu aba bati, “Falaaho aaghi̱li̱ye ati, ‘Tankutodha kubaha bu̱si̱ngo. ");
INSERT INTO tlj_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Mughende kandi mwebbalile bu̱si̱ngo hambali mukubusanga, bhaatu mulimo ghwanu taghukukeehʼo na kati̱i̱ bbaa.’ ” ");
INSERT INTO tlj_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Nahabweki Banai̱saaleeli̱ baaghenda mu nsi ya Mi̱si̱li̱ yoona kukumaani̱ya bu̱si̱ngo obu. ");
INSERT INTO tlj_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Bakulu baa milimo beekamba kughila bati, “Mubumbe muhendo ghwa matafaali nga oghu mwabumbagha obu baabahaagha bu̱si̱ngo.” ");
INSERT INTO tlj_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Bakulu abaaloleelelagha bakoli̱ baatandika kuhuula beebembeli̱ baa Banai̱saaleeli̱ aba Falaaho aabaagha ataayʼo kuloleelela baanakyabo haa milimo. Baabaghila bati, “Eso na obwalo tamwabu̱mbi̱ye muhendo ghwa matafaali nga oghu mwabumbagha nangaaki?” ");
INSERT INTO tlj_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Niibuwo bakulu baa Banai̱saaleeli̱ abaaloleelelagha baanakyabo haa milimo baasi̱ye kandi baataaghila Falaaho bati, “Okwete kutwalikani̱ya baheeleli̱ya baawe otiyo nangaaki? ");
INSERT INTO tlj_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Bakama baatu tabakwete kutuha bu̱si̱ngo. Bhaatu bakwete kutuhuula kandi kutughila bati, ‘Mubumbe matafaali!’ Bhaatu bantu baawe niibo bakwete kukola bintu bi̱bhi̱i̱hi̱ye, etu̱we bbaa.” ");
INSERT INTO tlj_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Bhaatu Falaaho aaghila ati, “Enu̱we Banai̱saaleeli̱ muli baghala kandi muli baghala kwonini! Eki niikiyo kikulekagha muukala nimughila muti, ‘Otuleke tughende kandi tuhonge kihonguwa ewaa Mukama.’ ");
INSERT INTO tlj_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Nahabweki mukuuke haa mulimo. Tabakubaha bu̱si̱ngo kandi muli na kubumba muhendo ghwa matafaali nga oghu mwabumbagha.” ");
INSERT INTO tlj_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Abaaloleelelagha Banai̱saaleeli̱ haa mulimo baamanya ngoku bali mu kijibu obu baabaghi̱li̱ye bati, “Tamuli na ku̱keehi̱ya haa muhendo ghwa matafaali agha bantu aba bali na kubumba bu̱li̱ kilo.” ");
INSERT INTO tlj_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Obu baalu̱ghagha ewaa Falaaho, baasangaana Musa na Alooni̱, babalindiliiye. ");
INSERT INTO tlj_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Baaghila Musa na Alooni̱ bati, “Mukama abalole kandi abatwi̱le musango, nanga mwaleki̱ye Falaaho na baheeleli̱ya be baatwoha kandi mwabataaye kihiyo mu ngalo yabo kutwita.” ");
INSERT INTO tlj_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Niibuwo Musa aaku̱u̱ki̱ye ewaa Mukama kandi aamughila ati, “Ai̱ Mukama, waaleeteeye bantu baawe kijibu nangaaki? Wantu̱mi̱ye mu bantu bani bwaki? ");
INSERT INTO tlj_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Ku̱lu̱gha bwile obu naaghendi̱ye ewaa Falaaho ku̱bu̱ghʼo li̱i̱na lyawe, niibuwo eeyongela kubona-boni̱ya bantu baawe kandi tookakoli̱ye kintu kyona kubajuna!” ");
INSERT INTO tlj_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Mukama aaghila Musa ati, “Endindi okubona eki nkukolʼo Falaaho. Mukono ghwanje ghwa bu̱toki̱ ghukuleka aleke bantu banje baghende kandi mukono ghwanje ghwamaani̱ ghukuleka ababhinge mu nsi yee.” ");
INSERT INTO tlj_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Luhanga aabu̱gha na Musa kandi aamughila ati, “Ni̱i̱si̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nkabonekela Ebbulahi̱mu̱, I̱saka na Yakobbo, nga Luhanga wa Bu̱toki̱ Bwona, bhaatu tanaabaghambiiye li̱i̱na lyanje Mukama. ");
INSERT INTO tlj_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Nkakola dhee nabo ndaghaano kubaha nsi ya Kanaani̱, nsi eghi baakalaghamu nga banamahanga. ");
INSERT INTO tlj_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Naaghu̱u̱ye dhee kutaagha kwa Banai̱saaleeli̱ aba Banami̱si̱li̱ baafooye basyana kandi naasu̱ki̱ye ndaghaano yanje. ");
INSERT INTO tlj_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Nahabweki oghambile Banai̱saaleeli̱ oti, ‘Ni̱i̱si̱ye Mukama, nkuuya enu̱we mu Banami̱si̱li̱ abakwete kubabona-boni̱ya kandi mbaaye mu bu̱syana. Nku̱u̱mu̱ki̱ya mukono ghwanje ghwamaani̱ kucungula enu̱we kandi nkukola byakuswekani̱ya bya kabhi kufubila Banami̱si̱li̱ aba. ");
INSERT INTO tlj_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Nkufoola enu̱we bantu banje kandi nkuba Luhanga waanu. Mukumanya ngoku ndi Mukama Luhanga waanu nkaakubaha bughabe ku̱lu̱gha mu bu̱syana mu Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Nkubaleeta mu nsi eghi naalahiiye kuha Ebbulahi̱mu̱, I̱saka na Yakobbo. Nkubaha nsi eghi kuba yaanu. Ni̱i̱si̱ye Mukama.’ ” ");
INSERT INTO tlj_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musa aaghambila bintu ebi Banai̱saaleeli̱, bhaatu baabhenga ku̱mu̱u̱ghu̱wa nanga bakaba batuntuuye haabwa milimo yamaani̱ eghi Banami̱si̱li̱ baabahambi̱li̱jagha kukola nga basyana. ");
INSERT INTO tlj_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Niibuwo Mukama aaghi̱li̱ye Musa ati, ");
INSERT INTO tlj_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Oghende kandi oghambile Falaaho mukama wa Mi̱si̱li̱ ku̱si̱i̱mi̱lani̱ya Banai̱saaleeli̱ ku̱lu̱gha mu nsi yee.” ");
INSERT INTO tlj_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Bhaatu Musa aaghila Mukama ati, “Olole, Banai̱saaleeli̱ baabhengi̱ye ku̱ntegheeleli̱ya. Buuye Falaaho akugubha ku̱ntegheeleli̱ya ati̱ya, nanga ndi muntu oghu akubhubhutilagha?” ");
INSERT INTO tlj_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Bhaatu Mukama aalaghila Musa na Alooni̱ ati, “Mughambile Banai̱saaleeli̱ na Falaaho mukama wa Mi̱si̱li̱ ngoku haali̱i̱si̱ye naalaghiiye enu̱we kuuya Banai̱saaleeli̱ mu nsi ya Mi̱si̱li̱.” ");
INSERT INTO tlj_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ghani niigho mali̱i̱na ghaa batabani̱ baa Leu̱bbeeni̱ mu̱li̱ghaaso ghwa I̱saaleeli̱: Hanoki̱, Palu, Heji̱looni̱ na Kalami̱. Esi syaba ntu̱la sya Leu̱bbeeni̱. ");
INSERT INTO tlj_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Ghani niigho mali̱i̱na ghaa batabani̱ baa Si̱mi̱yooni̱: Yemu̱weli̱, Yami̱ni̱, Ohadi̱, Yaki̱ni̱, Johali̱ na Sau̱li̱ oghu aabyayʼo mukali̱ wee Munakanaani̱. Esi syaba ntu̱la sya Si̱mi̱yooni̱. ");
INSERT INTO tlj_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Ghani niigho mali̱i̱na ghaa batabani̱ baa Leevi̱ kusighikila haa ku̱byaluwa kwabo: Geli̱sooni̱, Kohati̱ na Melaali̱. Leevi̱ aamala myaka ki̱ku̱mi̱ asatu na musanju̱. ");
INSERT INTO tlj_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Ghani niigho mali̱i̱na ghaa batabani̱ baa Geli̱sooni̱ kusighikila haa ntu̱la syabo: Li̱bbu̱ni̱ na Si̱meeyi̱. ");
INSERT INTO tlj_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Ghani niigho mali̱i̱na ghaa batabani̱ baa Kohati̱: Amulaamu, I̱jali̱, Hebbu̱looni̱ na U̱jeeli̱. Kohati̱ aamala myaka ki̱ku̱mi̱ asatu nʼesatu. ");
INSERT INTO tlj_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Ghani niigho mali̱i̱na ghaa batabani̱ baa Melaali̱: Mahi̱li̱ na Mu̱u̱si̱. Esi niisiyo ntu̱la sya Leevi̱ kusighikila haa mijo yabo. ");
INSERT INTO tlj_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amulaamu aaswela esenga wee Yakobbedi̱, aamu̱byalʼo Alooni̱ na Musa. Amulaamu aamala myaka ki̱ku̱mi̱ asatu na musanju̱. ");
INSERT INTO tlj_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ghani niigho mali̱i̱na ghaa batabani̱ baa I̱jali̱: Koola, Nefeegi̱ na Ji̱ki̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ghani niigho mali̱i̱na ghaa batabani̱ baa U̱jeeli̱: Misai̱li̱, Elijafaani̱ na Si̱ti̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Alooni̱ aaswela Eli̱seba muhala wa Aminadaabbu mwani̱na Naasoni̱, aamu̱byalʼo Nadaabbu, Abbi̱hu̱, Eli̱yeeja na I̱tamala. ");
INSERT INTO tlj_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Ghani niigho mali̱i̱na ghaa batabani̱ baa Koola: Asi̱la, Elikaana na Abyasaafu. Esi niisiyo ntu̱la sya Banakoola. ");
INSERT INTO tlj_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eli̱yeeja mutabani̱ wa Alooni̱, aaswela omui haa bahala baa Pu̱teeli̱, aamu̱byalʼo Fi̱nehaasi. Agha niigho mali̱i̱na ghaa bakulu baa ntu̱la sya Leevi̱, kusighikila haa ntu̱la syabo. ");
INSERT INTO tlj_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Alooni̱ na Musa niibo Mukama aaghi̱li̱ye ati, “Muuye ntu̱la sya I̱saaleeli̱ mu nsi ya Mi̱si̱li̱.” ");
INSERT INTO tlj_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Musa na Alooni̱ niibo baaghambiiye Falaaho mukama wa Mi̱si̱li̱ kubasi̱i̱mi̱lani̱ya kuuya Banai̱saaleeli̱ mu nsi ya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Obu Mukama aabu̱ghi̱ye na Musa mu nsi ya Mi̱si̱li̱, ");
INSERT INTO tlj_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Mukama aaghila Musa ati, “Ni̱i̱si̱ye Mukama. Oghambile Falaaho mukama wa Mi̱si̱li̱ byona ebi nkukughambila.” ");
INSERT INTO tlj_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Bhaatu Musa aaghila ati, “Mukama, omani̱ye ngoku nkubhubhutilagha, Falaaho akugubha ku̱ntegheeleli̱ya ati̱ya?” ");
INSERT INTO tlj_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Mukama aaghila Musa ati, “Olole, naakufooye nga Luhanga ewaa Falaaho kandi mu̱ghenji̱ waawe Alooni̱ akuba mulangi̱ waawe. ");
INSERT INTO tlj_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Oghambile mu̱ghenji̱ waawe Alooni̱ byona ebi nkukulaghila kandi akughambila Falaaho ku̱si̱i̱mi̱lani̱ya bantu baa I̱saaleeli̱ ku̱lu̱gha mu nsi yee. ");
INSERT INTO tlj_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Bhaatu nkwomakakani̱ya mutima ghwa Falaaho, nankabha nkola bubonelo kandi byakuswekani̱ya bikani̱ye mu nsi ya Mi̱si̱li̱, ");
INSERT INTO tlj_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Falaaho taakubategheeleli̱ya. Du̱mbi̱ nkufubila kwonini bantu baa Mi̱si̱li̱ kandi nkuuya ntu̱la sya bantu banje Banai̱saaleeli̱ mu nsi ya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Banami̱si̱li̱ bakumanya ngoku ndi Mukama, obu nkunanula mukono ghwanje haa ehanga lya Mi̱si̱li̱ kandi ninaayayo bantu baa I̱saaleeli̱.” ");
INSERT INTO tlj_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Musa na Alooni̱ baakola kwonini ngoku Mukama aabalaghiiye. ");
INSERT INTO tlj_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Bwile obu baabu̱ghi̱ye na Falaaho, Musa akaba ali na myaka kinaanaa ya bukulu kandi Alooni̱ ali na myaka kinaanaa nʼesatu. ");
INSERT INTO tlj_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Niibuwo Mukama aaghi̱li̱ye Musa na Alooni̱ ati, ");
INSERT INTO tlj_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Kaakuba Falaaho abaghila ati, ‘Mukole kyakuswekani̱ya.’ Oghile Alooni̱ oti, ‘Okube hansi mwi̱gho ghwawe mu maaso ghaa Falaaho, ghukufooka njoka.’ ” ");
INSERT INTO tlj_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Nahabweki Musa na Alooni̱ baaghenda ewaa Falaaho kandi baakola ngoku Mukama aabalaghiiye. Alooni̱ aakuba hansi mwi̱gho ghuwe mu maaso ghaa Falaaho na baheeleli̱ya be kandi ghwafooka njoka. ");
INSERT INTO tlj_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Niibuwo Falaaho aatu̱mi̱ye bantu kubilikila baakalimagheji na baku̱mu̱ baa Mi̱si̱li̱. Baasa kandi baakoleesi̱ya maaje ghaabo kukola eki Musa na Alooni̱ baakoli̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Bu̱li̱ omui mu bantu aba aakuba hansi mwi̱gho ghuwe kandi ghwafooka njoka. Bhaatu mwi̱gho ghwa Alooni̱ ghwammela mi̱i̱gho yabo. ");
INSERT INTO tlj_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Bhaatu mutima ghwa Falaaho ghwakala ghunomakakaane. Aabhenga ku̱tegheeleli̱ya Musa na Alooni̱ ngoku Mukama aabu̱ghi̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Niibuwo Mukama aaghi̱li̱ye Musa ati, “Mutima ghwa Falaaho ghunomakakaane kandi aabhengi̱ye ku̱si̱i̱mi̱lani̱ya bantu baa I̱saaleeli̱ kughenda. ");
INSERT INTO tlj_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Munkiya nkyambisi oghende ewaa Falaaho, obu akuba naatuwa kughenda haa maasi ghaa Nailo. Otwale mu ngalo yaawe mwi̱gho oghwafooki̱ye njoka kandi omulindilile haa ki̱si̱yo kya maasi agha. ");
INSERT INTO tlj_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Oghile Falaaho oti, ‘Mukama Luhanga wa Bahebbulaayo, antu̱mi̱ye ewaawe naaghila ati: Oleke bantu banje baghende, niikuwo bagubhe ku̱mpeeleli̱ya mu elungu. Bhaatu ku̱hi̱ki̱ya endindi onabhengi̱ye ku̱mu̱u̱ghu̱wa.’ ");
INSERT INTO tlj_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Mukama aakwete kughila ati, ‘Eki nkukola kikuleka omanye ngoku ndi Mukama.’ Si̱ye Musa, mwi̱gho oghu nkwete mu ngalo yanje, nkughuhuula haa maasi ghaa Nailo kandi maasi agha ghakufooka saghama. ");
INSERT INTO tlj_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Nsu̱i̱ esilimu si̱ku̱ku̱wa kandi maasi agha ghaku̱nu̱nka, Banami̱si̱li̱ tabakugubha kughanuwa.” ");
INSERT INTO tlj_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Mukama aaghila Musa ati, “Oghambile Alooni̱ oti, ‘Okwate mwi̱gho ghwawe, oghuhuule haa maasi ghaa Mi̱si̱li̱, haa mikula yabo ya maasi, haa byahu̱dhu̱ byabo kandi nsulo syabo, maasi agha ghoona ghakufooka saghama. Nsi ya Mi̱si̱li̱ yoona ekuusulamu saghama, nankabha mu bintu byona ebi bakutaaghamu maasi ebi̱koleeu̱we mu mbaau kedha mabaale.’ ” ");
INSERT INTO tlj_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musa na Alooni̱ baakola ngoku Mukama aabalaghiiye. Alooni̱ aamu̱ki̱ya mwi̱gho ghuwe mu maaso ghaa Falaaho na baheeleli̱ya be kandi aaghuhuula haa maasi ghaa Nailo, maasi agha ghoona ghaafooka saghama. ");
INSERT INTO tlj_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Nsu̱i̱ syʼomu maasi ghaa Nailo syaku̱wa kandi maasi agha ghoona ghaanu̱nka, Banami̱si̱li̱ baasaaghuwa kughanuwa. Saghama yaamalakaka mu nsi ya Mi̱si̱li̱ yoona. ");
INSERT INTO tlj_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Bhaatu banamaaje baa Banami̱si̱li̱ baakola eki dhee haabwa maaje ghaabo. Nahabweki mutima ghwa Falaaho ghwakala ghunomakakaane, aabhenga ku̱tegheeleli̱ya Musa na Alooni̱, ngoku Mukama aabu̱ghi̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Falaaho eegaali̱ya kandi aaghenda mu numba yee, ekyabaayʼo eki ataakifuwʼo haa mutima ghuwe. ");
INSERT INTO tlj_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Banami̱si̱li̱ boona baalima bi̱i̱na haai na maasi ghaa Nailo, kutunga maasi ghaa kunuwa, nanga tabangu̱gu̱bhi̱ye kunuwa maasi ghaa Nailo. ");
INSERT INTO tlj_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Bilo musanju̱ byahuwʼo haanu̱ma ya Mukama kuhuula maasi ghaa Nailo. ");
INSERT INTO tlj_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Niibuwo Mukama aaghi̱li̱ye Musa ati, “Oghende ewaa Falaaho kandi omughile oti Mukama akwete kughila ati, ‘Oleke bantu banje baghende, niikuwo bagubhe kundami̱ya. ");
INSERT INTO tlj_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Bhaatu kaakuba obhenga kubasi̱i̱mi̱lani̱ya kughenda, nkuha nsi yaawe yoona kifubilo kya bigbende. ");
INSERT INTO tlj_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Maasi ghaa Nailo ghakuusulamu bigbende ebi̱ku̱lu̱ghamu kandi biise mu numba yaawe na mu kisiika kyawe na haa bulili bwawe kandi mu manumba ghaa baheeleli̱ya baawe na bantu baawe, mu bi̱tu̱mi̱ko byanu na capu̱li̱ya syanu. ");
INSERT INTO tlj_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Bigbende ebi bi̱ku̱ku̱ni̱i̱nʼo kandi bi̱ni̱i̱nʼo bantu baawe na baheeleli̱ya baawe boona.’ ” ");
INSERT INTO tlj_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Mukama aaghila Musa ati, “Oghambile Alooni̱ oti, ‘Onanule mukono oghukwete mwi̱gho ghwawe kandi oghuhuule haa maasi, mikula ya maasi, byahu̱dhu̱ na nsulo, bigbende bi̱ku̱lu̱ghamu kandi biise mu nsi ya Mi̱si̱li̱.’ ” ");
INSERT INTO tlj_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Nahabweki Alooni̱ aamu̱ki̱ya mukono ghuwe kandi aahuula maasi ghaa Mi̱si̱li̱, bigbende byalu̱ghamu kandi byasula nsi ya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Bhaatu banamaaje nabo baakola eki dhee mbakoleesi̱ya maaje ghaabo kandi baaleeta bigbende mu nsi ya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Niibuwo Falaaho aabilikiiye Musa na Alooni̱, aabaghila ati, “Mwesengeleli̱ye Mukama kunjiyʼo bigbende ebi kandi kubiiyʼo bantu banje. Nku̱si̱i̱mi̱lani̱ya bantu baanu kughenda kandi kuhongela bihonguwa Mukama.” ");
INSERT INTO tlj_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Musa aaghila Falaaho ati, “Nkuleka okome bwile obu nkukusabila. Nkwesengeleli̱ya Luhanga haabwawe kandi haabwa baheeleli̱ya baawe na bantu baawe, kubaayʼo bigbende ebi kandi kubiiya mu manumba ghaanu kandi kubileka mu maasi ghaa Nailo ghonkaha.” ");
INSERT INTO tlj_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Falaaho aaghila ati, “Munkiya.” Musa aamughila ati, “Nkukola ngoku waabu̱ghi̱ye, niikuwo omanye ngu taaliyo luhanga onji oghu ali nga Mukama Luhanga waatu. ");
INSERT INTO tlj_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Bigbende ebi bi̱ku̱ku̱lu̱ghʼo kandi bi̱lu̱ghe mu manumba ghaawe, haa baheeleli̱ya baawe na bantu baawe, bi̱ku̱ti̱ghala mu maasi ghaa Nailo ghonkaha.” ");
INSERT INTO tlj_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Musa na Alooni̱ baalu̱gha ewaa Falaaho kandi Musa eesengeleli̱ya Mukama kuuyʼo kifubilo kya bigbende ebi aabaagha asindikiiye Falaaho. ");
INSERT INTO tlj_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Mukama aakola eki Musa aamusabi̱ye. Bigbende byona byaku̱wa ebyabaagha mu manumba ghaabo, hanjaakati syabo, na mu misili yabo. ");
INSERT INTO tlj_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Banai̱saaleeli̱ baabikumaani̱ya ntuumo kandi nsi eghi yoona yaanu̱nka. ");
INSERT INTO tlj_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Bhaatu obu Falaaho aaboone kijibu eki nkyahuwʼo, oomakakani̱ya mutima ghuwe kandi aabhenga ku̱tegheeleli̱ya Musa na Alooni̱, ngoku Mukama aabu̱ghi̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Niibuwo Mukama aaghi̱li̱ye Musa ati, “Oghile Alooni̱ oti, ‘Ohi̱dhe mwi̱gho ghwawe kandi oghuhuule hansi mu tu̱u̱tu̱, niikuwo efooke mibui mu nsi ya Mi̱si̱li̱ yoona.’ ” ");
INSERT INTO tlj_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Baakola kuwo. Alooni̱ aahi̱dha mukono ghuwe oghukwete mwi̱gho kandi aaghuhuula mu tu̱u̱tu̱ hansi. Tu̱u̱tu̱ yoona ya mu nsi ya Mi̱si̱li̱ yaafooka mibui kandi mibui eghi yaasu̱nda haa bantu boona na bisolo byona. ");
INSERT INTO tlj_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Banamaaje baa Mi̱si̱li̱ baalengʼo dhee mu maaje ghaabo kuleeta mibui, bhaatu baasaaghuwa. Nahabweki mibui yaasu̱ndʼo bantu na bisolo. ");
INSERT INTO tlj_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Niibuwo banamaaje aba baaghi̱li̱ye Falaaho bati, “Eki ni kyala kya Luhanga.” Bhaatu mutima ghwa Falaaho ghwakala ghunomakakaane kandi aabhenga ku̱tegheeleli̱ya Musa na Alooni̱, ngoku Mukama aabu̱ghi̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Mukama aaghila Musa ati, “Oomuke nkyambisi cu̱i̱ kandi oghende ewaa Falaaho, obu akuba naaghenda haa maasi, omughile oti Mukama akwete kughila ati, ‘Oleke bantu banje baghende, niikuwo bagubhe kundami̱ya. ");
INSERT INTO tlj_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Kaakuba otaleka bantu banje kughenda, nkukusindikila nsoola sikaniiye kimui na baheeleli̱ya baawe, na bantu baawe kandi mu manumba ghaanu. Manumba ghaa Banami̱si̱li̱ ghakuusulamu nsoola sikani̱ye kandi sikuusula hansi hoona. ");
INSERT INTO tlj_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘Bhaatu bwile obu nkulinda kyalo kya Goseeni̱, hambali bantu banje baakaaye. Taaliyo nsoola sikani̱ye esikubaayo, niikuwo mumanye ngoku siye Mukama, nkwete kukola mulimo ghwanje mu nsi eni hambali muukaaye. ");
INSERT INTO tlj_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Nkulinda bantu banje nsoola kutabahi̱kamu esikuluma bantu baawe kubalwali̱ya. Kyakuswekani̱ya kini kikubʼo munkiya.’ ” ");
INSERT INTO tlj_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Mukama aakola ngoku aabu̱ghi̱ye. Nsoola sikaniiye kimui syasula mu kikaali kya Falaaho na manumba ghaa baheeleli̱ya be. Nsoola syasula mu nsi ya Mi̱si̱li̱ yoona kandi syabhi̱i̱ya nsi eghi yoona. ");
INSERT INTO tlj_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Niibuwo Falaaho aabilikiiye Musa na Alooni̱, aabaghila ati, “Mughende kandi muhonge bihonguwa ewaa Luhanga waanu, bhaatu mubihongele mu nsi eni.” ");
INSERT INTO tlj_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Bhaatu Musa aaghila ati, “Taaki̱hi̱ki̱ye kukola eki, nanga bihonguwa tukuhongela Mukama Luhanga waatu, Banami̱si̱li̱ babyohi̱ye. Kaakuba Banami̱si̱li̱ batubona ntuhonga bihonguwa ebi boohi̱ye, buuye tabakutuhuula mabaale? ");
INSERT INTO tlj_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Tuli na kughenda lughendo lwa bilo bisatu mu elungu, niikuwo tuhongele bihonguwa Mukama Luhanga waatu, ngoku aatulaghiiye.” ");
INSERT INTO tlj_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Falaaho aaghila ati, “Nkuleka mughende mu elungu kandi muhongele bihonguwa Mukama Luhanga waanu, bhaatu mutaghenda hambali haseli̱ye. Nahabweki munsabile.” ");
INSERT INTO tlj_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Musa aaghila ati, “Ndimaghenda kandi nkwesengeleli̱ya Mukama nti munkiya nsoola sikaniiye kimui esi si̱lu̱ghʼo Falaaho kandi si̱lu̱ghʼo baheeleli̱ya be na bantu be. Bhaatu otatodha kutudimaaga kandi obhenga ku̱si̱i̱mi̱lani̱ya bantu aba kughenda kuhonga bihonguwa ewaa Mukama.” ");
INSERT INTO tlj_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Nahabweki Musa aalu̱gha ewaa Falaaho kandi aasaba ewaa Mukama ");
INSERT INTO tlj_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","kandi Mukama aakola ngoku Musa aamusabi̱ye. Nsoola esi aasiiyʼo Falaaho, baheeleli̱ya be na bantu be, taaliyo nʼemui eghi ekati̱ghalʼo. ");
INSERT INTO tlj_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Bhaatu bwile obu Falaaho aatodha oomakakani̱ya mutima ghuwe dhee kandi aabhenga kuleka bantu aba kughenda. ");
INSERT INTO tlj_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Niibuwo Mukama aaghi̱li̱ye Musa ati, “Oghende ewaa Falaaho kandi omughile oti, ‘Mukama Luhanga wa Bahebbulaayo akwete kughila ati, “Oleke bantu banje baghende, niikuwo bagubhe kundami̱ya.” ");
INSERT INTO tlj_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Kaakuba obhenga dhee kubaleka kughenda, ");
INSERT INTO tlj_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","mukono ghwa Mukama ghukusindika bulwaye bwa kabhi haa bisolo byawe byona ebili mu mali̱i̱si̱li̱yo ghaawe, nkai̱na, ndogooi̱, ngamila, nte, ntaama kandi mbu̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Bhaatu Mukama akutambulani̱yamu bisolo bya Banai̱saaleeli̱ na bisolo bya Banami̱si̱li̱, niikuwo atabʼo kisolo na kimui kya Banai̱saaleeli̱ eki̱ku̱ku̱wa.’ ” ");
INSERT INTO tlj_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Mukama aatʼo bwile, naaghila ati, “Munkiya Mukama akukola kintu eki mu nsi ya Mi̱si̱li̱.” ");
INSERT INTO tlj_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Kilo ekyalabhi̱yʼo Mukama aakola kintu eki. Bisolo byona bya Banami̱si̱li̱ byaku̱wa, bhaatu taaliyo kisolo na kimui kya Banai̱saaleeli̱ ekyaku̱u̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Obu Falaaho aabu̱u̱i̱ye bantu, baamughambila ngoku ataliyo kisolo na kimui kya Banai̱saaleeli̱ ekyaku̱u̱ye. Bhaatu mutima ghwa Falaaho ghwakala ghunomakakaane kandi aabhenga kuleka Banai̱saaleeli̱ kughenda. ");
INSERT INTO tlj_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Mukama aaghila Musa na Alooni̱ ati, “Mukwate ki̱bu̱ kyʼomu mahi̱gha mu ngalo syanu, Musa akihanje mu mwanya Falaaho analoli̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ki̱bu̱ eki kikufooka tu̱u̱tu̱ mu nsi ya Mi̱si̱li̱ yoona kandi ekuleka bantu baa mu nsi ya Mi̱si̱li̱ balwale bihute na bisolo byabo byona, ebi̱ku̱lu̱ghamu bibbodhe.” ");
INSERT INTO tlj_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Nahabweki Musa na Alooni̱ baakwata ki̱bu̱ kyʼomu mahi̱gha kandi beemilila mu maaso ghaa Falaaho. Musa aakihanja mu mwanya kandi kyaleeteleja Banami̱si̱li̱ na bisolo byabo kulwala bihute. ");
INSERT INTO tlj_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Banamaaje baa Banami̱si̱li̱ tabaagu̱bhi̱ye kuhakani̱ya Musa nanga nabo dhee bakaba balwaye bihute nga Banami̱si̱li̱ banji boona. ");
INSERT INTO tlj_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Bhaatu Mukama oomakakani̱ya mutima ghwa Falaaho kandi aabhenga ku̱tegheeleli̱ya Musa na Alooni̱, ngoku Mukama aaghambiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Mukama aaghila Musa ati, “Oomuke nkyambisi cu̱i̱ oghende ewaa Falaaho kandi omughile oti, ‘Mukama Luhanga wa Bahebbulaayo akwete kughila ati: Oleke bantu banje baghende niikuwo bagubhe kundami̱ya. ");
INSERT INTO tlj_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Mulundi ghuni nkughenda kusindika bifubilo byanje byona hali uwe, baheeleli̱ya baawe na bantu baawe, niikuwo ogubhe kumanya ngu taaliyo luhanga onji oghu engaane nanje munsi yoona. ");
INSERT INTO tlj_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Nanga endindi nguli naamu̱ki̱i̱ye mukono ghwanje kuha uwe na bantu baawe kifubilo kya ndwala, enu̱we boona mwanguhwelekeleeye munsi. ");
INSERT INTO tlj_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Bhaatu naaku̱leki̱ye oli mwomi̱i̱li̱ haabwa kighendeleluwa kini, kukwoleka maani̱ ghanje, niikuwo li̱i̱na lyanje lilangililuwe munsi yoona. ");
INSERT INTO tlj_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Bhaatu ku̱hi̱ki̱ya endindi onakwepankilʼo bantu banje kandi onabhengi̱ye kubaleka kughenda. ");
INSERT INTO tlj_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Nahabweki bwile nga buni munkiya, nku̱tooni̱ya mbu̱la yamaani̱ ya lubaale. Mbu̱la eghi etakatoonagha mu nsi ya Mi̱si̱li̱ ku̱lu̱gha kilo eki nsi eghi yaakabʼo ku̱hi̱ki̱ya endindi. ");
INSERT INTO tlj_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Endindi otume bantu kuleeta bisolo byawe, na bintu byawe byona ebi oli nabiyo, ebili mu musili, babitaahi̱ye mu bi̱i̱kalo hambali bikuukala kusemeeye. Nanga mbu̱la ya lubaale eghi ekuhuula bantu na bisolo byona ebili mu musili, bisolo ebi bataaleeti̱ye e ka byona bi̱ku̱ku̱wa.’ ” ");
INSERT INTO tlj_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Bamui mu bantu baa Falaaho aboobahi̱ye haabwa ku̱u̱ghu̱wa ebi Mukama aabu̱ghi̱ye, baataahi̱ya bwangu basyana baabo na bisolo byabo mu manumba ghaabo. ");
INSERT INTO tlj_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Bhaatu abaabhengi̱ye ku̱u̱ghu̱wa ebi Mukama aabu̱ghi̱ye, baaleka basyana baabo na bisolo byabo mu musili. ");
INSERT INTO tlj_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Mukama aaghila Musa ati, “Oomu̱ki̱ye mukono ghwawe mu mwanya, niikuwo mbu̱la ya lubaale etoone mu nsi ya Mi̱si̱li̱ yoona, ehuule bantu, bisolo na bilimuwa byona ebili mu misili mu nsi ya Mi̱si̱li̱.” ");
INSERT INTO tlj_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Nahabweki Musa aamu̱ki̱ya mwi̱gho ghuwe aaghu̱loli̱ya mu mwanya kandi Mukama aasindika nkubha na mbu̱la ya lubaale kandi nkubha yaabbyoka munsi. Mukama aatooni̱ya mbu̱la ya lubaale mu nsi ya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Mbu̱la yamaani̱ ya lubaale yaaghuwa eghi elimu nkubha, eghi ekwete kwetanuka, kubbyoka kandi etaakulekeelela. Mbu̱la eghi ekaba etakatoonagha mu nsi ya Mi̱si̱li̱ yoona ku̱lu̱gha nsi eghi ebʼo. ");
INSERT INTO tlj_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Mbu̱la ya lubaale eghi yaahuula bintu byona ebyabaagha mu misili mu nsi ya Mi̱si̱li̱, otaayemu bantu na bisolo. Yaabhi̱i̱ya bilimuwa byona mu misili kandi yaagenga hansi biti byona. ");
INSERT INTO tlj_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Mu kyalo kya Goseeni̱ kyonkaha, hambali Banai̱saaleeli̱ baabaagha baakaaye, niikiyo mbu̱la ya lubaale eghi etaatooni̱yemu. ");
INSERT INTO tlj_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Niibuwo Falaaho aatu̱mi̱ye muntu kubilikila Musa na Alooni̱ kwisa ewe. Obu baaki̱dhi̱ye aabaghila ati, “Endindi naasi̱i̱si̱ye kandi Mukama Luhanga ahi̱ki̱i̱ye kukola kintu kini, si̱ye na bantu banje twasobeei̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Mwesengeleli̱ye Mukama, akeesi̱ye mbu̱la eghi elimu nkubha kandi mbu̱la ya lubaale eghi, nanga yaatuhingulaane. Du̱mbi̱ nkubaleka mughende, tamukutodha kuukala mu nsi ya Mi̱si̱li̱.” ");
INSERT INTO tlj_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa aamughila ati, “Nkaaku̱lu̱gha mu kibugha kini, nku̱u̱mu̱ki̱ya mikono yanje ewaa Mukama. Nkubha eghi ekuleka kandi mbu̱la ya lubaale teekutodha kutoona, niikuwo ogubhe kumanya ngoku nsi eni eli ya Mukama. ");
INSERT INTO tlj_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Bhaatu nimani̱ye ngoku uwe na baheeleli̱ya baawe mutoobahi̱ye Mukama Luhanga.” ");
INSERT INTO tlj_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Mbu̱la ya lubaale eghi yaabhi̱i̱ya hansi bu̱goi̱go na bbaale, nanga bbaale ekaba etandi̱ki̱ye kwana kandi bu̱goi̱go bukaba buli haai kwela. ");
INSERT INTO tlj_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Bhaatu ngano tayaabhi̱hi̱ye nanga ekaba etakatooye.) ");
INSERT INTO tlj_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Musa aalu̱gha ewaa Falaaho, aatuwa mu kibugha eki, aamu̱ki̱ya mikono yee ewaa Mukama, nkubha yaaleka kandi mbu̱la ya lubaale yaakiya, tayaatodhi̱ye etoona mu nsi ya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Bhaatu obu Falaaho aaboone mbu̱la yamaani̱ eghi niyaaleka kutoona kandi lubaale na nkubha mbyaleka, aatodha asi̱i̱sa kandi eye na baheeleli̱ya be boomakakani̱ya mitima yabo. ");
INSERT INTO tlj_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Falaaho oomakakani̱ya mutima ghuwe, abhenga kuleka bantu baa I̱saaleeli̱ kughenda, ngoku Mukama aabu̱ghi̱ye naakoleesi̱ya Musa. ");
INSERT INTO tlj_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Mukama aaghila Musa ati, “Oghende ewaa Falaaho, nanga noomakakani̱i̱ye mutima ghuwe kandi mutima ghwa baheeleli̱ya be, niikuwo ngubhe kukola byakuswekani̱ya bini mu bantu aba. ");
INSERT INTO tlj_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Naakoli̱ye eki niikuwo mugubhe kughambila baana baanu na baasukulu baanu ngoku naafubiiye Banami̱si̱li̱ kandi byakuswekani̱ya ebi naakoli̱ye mu bantu aba, niikuwo mugubhe kumanya ngu Ni̱i̱si̱ye Mukama.” ");
INSERT INTO tlj_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Nahabweki Musa na Alooni̱ baaghenda ewaa Falaaho kandi baamughila bati, “Mukama Luhanga wa Bahebbulaayo akwete kughila ati, ‘Okubhenga kundhootela ku̱hi̱ki̱ya dhi̱? Oleke bantu banje baghende, niikuwo bagubhe kundami̱ya. ");
INSERT INTO tlj_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Nuwaabhengi̱ye kuleka bantu banje kughenda, munkiya nkuleeta njighe mu nsi yaawe. ");
INSERT INTO tlj_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Njighe esi si̱ku̱swi̱ki̱la nsi yaawe yoona niikuwo atabʼo muntu nʼomui oghu akugubha kubona etaka. Sikuliya ebi mbu̱la ya lubaale yaati̱ghi̱yʼo kandi siliye biti byanu byona ebitooye mu misili. ");
INSERT INTO tlj_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Njighe esi sikuusula mu manumba ghaawe, na manumba ghaa baheeleli̱ya baawe boona, na manumba ghaa Banami̱si̱li̱ boona, sikukanila kimui, esi baa eseenu̱we na baataata baanu batakabonagha, ku̱lu̱gha babyaluwa ku̱hi̱ki̱ya endindi.’ ” Du̱mbi̱ Musa aalu̱gha ewaa Falaaho kandi aaghenda. ");
INSERT INTO tlj_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Niibuwo baheeleli̱ya baa Falaaho baamu̱ghi̱li̱ye bati, “Musaasa oni aku̱hi̱ki̱ya haa kutuleetela bijibu? Oleke bantu baa I̱saaleeli̱ baghende niikuwo baheeleli̱ye Mukama Luhanga wabo. Tookakengi̱ye ngoku nsi ya Mi̱si̱li̱ yaabhi̱i̱hi̱ye?” ");
INSERT INTO tlj_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Niibuwo Falaaho aatu̱mi̱ye bantu kubilikila Musa na Alooni̱ kukuuka ewe. Obu baaki̱dhi̱ye aabaghila ati, “Mughende mu̱heeleli̱ye Mukama Luhanga waanu. Bhaatu mbaki bakughenda?” ");
INSERT INTO tlj_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa aamukuukamu ati, “Tukughenda na bantu baatu bato na bakulu. Tukutwala batabani̱ baatu na bahala baatu, ntaama, mbu̱li̱ na nte syatu, nanga tuli na kukolela Mukama ki̱ghenu̱.” ");
INSERT INTO tlj_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Bhaatu Falaaho aabaghila ati, “Kaakuba mbasi̱i̱mi̱lani̱ya kutwala bakali̱ baanu na baana baanu, Mukama akwetaaghisibuwa kuba ali naanu! Endindi naakimanya ngoku muli na kighendeleluwa ki̱bhi̱i̱hi̱ye mu byeli̱li̱kano byanu. ");
INSERT INTO tlj_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Bbaa, basaasa bonkaha haaliibo baaghenda ku̱heeleli̱ya Mukama, nanga eki niikiyo mukwete kusaba.” Du̱mbi̱ Falaaho aababhinga mu kikaali kiye. ");
INSERT INTO tlj_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Niibuwo Mukama aaghi̱li̱ye Musa ati, “Onanule mukono ghwawe mu nsi ya Mi̱si̱li̱, niikuwo njighe sikani̱ye siisemu kandi siliye bu̱li̱ kilimuwa ekili mu nsi eghi, eki mbu̱la ya lubaale yaati̱ghi̱yemu.” ");
INSERT INTO tlj_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Nahabweki Musa aamu̱ki̱ya mwi̱gho ghuwe aaghwoleka nsi ya Mi̱si̱li̱, Mukama aaleeta mwegha ghwa bu̱lu̱gha ejooba kandi ghwahunga mu nsi eghi ntangaali̱ yoona na mukilo. Obu bwahi̱ki̱ye nkyambisi, mwegha oghu ghukaba ni ghwaleeti̱yemu njighe. ");
INSERT INTO tlj_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Njighe syasa mu nsi ya Mi̱si̱li̱ kandi syakala mu ehanga eli lyona. Njighe sikaniiye kimui esi bantu baabaagha batakabonaghʼo kandi esitalitodha kubʼo. ");
INSERT INTO tlj_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Njighe esi syamalakaka etaka lyona lya mu nsi ya Mi̱si̱li̱ kandi etaka eli lyafooka linjilaghu̱li̱ nanga njighe esi kandi syaliya bi̱si̱ngo byona ebyabaagha mu nsi eghi na bi̱ghu̱ma bya biti byona ebi mbu̱la ya lubaale yaati̱ghi̱yʼo. Taaliyo kintu kyona kya ki̱si̱ka kibisi ekyati̱ghaaye, kedha kiti kedha kilimuwa kyʼomu musili, mu nsi ya Mi̱si̱li̱ yoona. ");
INSERT INTO tlj_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Niibuwo Falaaho aabilikiiye bwangu Musa na Alooni̱, aabaghila ati, “Naasi̱i̱si̱ye ewaa Mukama Luhanga waanu kandi naasi̱i̱si̱ye ewaanu. ");
INSERT INTO tlj_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Gutu, munganile kibhi kyanje mulundi ghuni ghwonkaha kandi mwesengeleli̱ye Mukama Luhanga waanu enkaha kunjiyʼo kifubilo kya lu̱ku̱ kini.” ");
INSERT INTO tlj_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Nahabweki Musa aalu̱gha ewaa Falaaho kandi eesengeleli̱ya Mukama. ");
INSERT INTO tlj_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Mukama aaleeta mwegha ghwamaani̱ ghwa bughuwa ejooba, ghwamu̱ki̱ya njighe esi kandi ghwasitwala mu Nanja Mutuku. Taaliyo lujighe na lumui olwati̱ghaaye mu nsi ya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Bhaatu Mukama oomakakani̱ya mutima ghwa Falaaho kandi aabhenga kuleka bantu baa I̱saaleeli̱ kughenda. ");
INSERT INTO tlj_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Niibuwo Mukama aaghi̱li̱ye Musa ati, “Onanule mukono ghwawe mu mwanya, mweli̱ma ghukwisa mu nsi ya Mi̱si̱li̱, mweli̱ma ghukwataane kwonini oghu muntu akugubha ku̱ku̱mʼo.” ");
INSERT INTO tlj_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Nahabweki Musa aamu̱ki̱ya mukono ghuwe mu mwanya, mweli̱ma ghwamaani̱ ghwakwata mu nsi ya Mi̱si̱li̱ yoona haabwa bilo bisatu. ");
INSERT INTO tlj_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Bwile obu bantu tabaagubhagha kubonangana kedha ku̱lu̱gha mu maka ghaabo haabwa bilo bisatu. Bhaatu kyeleeli̱ kyakala hambali Banai̱saaleeli̱ baabaagha baakaaye. ");
INSERT INTO tlj_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Falaaho aabilikila Musa kandi aamughila ati, “Mughende mu̱heeleli̱ye Mukama waanu kandi mutwale baana baanu bato bonkaha, bhaatu mu̱ti̱ghe hani ntaama, mbu̱li̱ na nte syanu.” ");
INSERT INTO tlj_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Bhaatu Musa aamughila ati, “Oli na ku̱tu̱si̱i̱mi̱lani̱ya kutwala bisolo bya kuhonga na bya bihonguwa byona byokeei̱ye, ebi tukuhongela Mukama Luhanga waatu. ");
INSERT INTO tlj_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Bisolo byatu tuli na kughenda nabiyo kandi taaliyo na kimui eki̱ku̱ti̱ghala, nanga bimui haa bisolo ebi tukubihaayo nga bihonguwa ewaa Mukama Luhanga waatu kandi tatumani̱ye ebi tukuhongela Mukama ku̱hi̱ki̱ya tu̱ki̱dhi̱ye mu ki̱i̱kalo eki.” ");
INSERT INTO tlj_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Bhaatu Mukama oomakakani̱ya mutima ghwa Falaaho kandi aabhenga ku̱si̱i̱mi̱lani̱ya bantu baa I̱saaleeli̱ kughenda. ");
INSERT INTO tlj_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Niibuwo Falaaho aaghi̱li̱ye Musa ati, “Ondu̱ghe mu maaso! Tambali̱ye kutodha kukubona! Kilo eki nkutodha kukubona, oku̱ku̱wa!” ");
INSERT INTO tlj_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa aamughila ati, “Waahi̱ki̱i̱ye! Tookutodha kumbona bbaa!” ");
INSERT INTO tlj_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Mukama aaghila Musa ati, “Hanaliyo kifubilo kimui eki nkuha Falaaho na nsi ya Mi̱si̱li̱, du̱mbi̱ akuleka mughende. Bwile obu akuleka enu̱we boona mughende, taaliyo nʼomui oghu aku̱ti̱ghala. ");
INSERT INTO tlj_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Oghambile Banai̱saaleeli̱, bu̱li̱ musaasa aghende ewaa muliilanuwa wee wabusaasa Munami̱si̱li̱ kandi bu̱li̱ mukali̱ aghende ewaa muliilanuwa wee wabukali̱ Munami̱si̱li̱ amusabe kumuha bintu bi̱koleeu̱we mu siliva kandi feeja.” ");
INSERT INTO tlj_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Mukama aaleka Banami̱si̱li̱ baaghilila kisa Banai̱saaleeli̱. Banyolo baa Falaaho na Banami̱si̱li̱ beeli̱li̱kanaghʼo Musa ngoku ali muntu wamaani̱ mu nsi ya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Musa aaghila Falaaho ati, “Mukama akwete kughila ati, ‘Obwalo saaha mukaagha sya mukilo nkusaalila mu nsi ya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Mwana wabusaasa mu̱li̱ghaaso mu bu̱li̱ ka ya Munami̱si̱li̱ aku̱ku̱wa ku̱lu̱gha haa mu̱li̱ghaaso wabusaasa wa mukama Falaaho, oghu akusitama haa ntebe ya bukama yee, ku̱hi̱ki̱ya haa mu̱li̱ghaaso ghwa mu̱syana wabukali̱ oghu akusiyagha haa lubengo, na mi̱li̱ghaaso yoona yabusaasa ya bisolo. ");
INSERT INTO tlj_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Hakubʼo kulila kwamaani̱ mu nsi ya Mi̱si̱li̱ yoona okutakabaaghʼo kandi okutalitodha kubʼo. ");
INSERT INTO tlj_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Bhaatu taaliyo mbuwa nʼemui eghi ekugbomela muntu weena mu Banai̱saaleeli̱ kedha bisolo byabo, niikuwo mumanye ngoku Mukama akutaaghʼo mbaghani̱ja haagati ya Banami̱si̱li̱ na Banai̱saaleeli̱.’ ");
INSERT INTO tlj_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Baheeleli̱ya baawe bani boona bakwisa kandi bateeli̱ye mu maaso ghanje, baghile bati, ‘Olu̱ghe hani, oghende na Banai̱saaleeli̱ baawe boona.’ Haanu̱ma yʼeki, nkughenda.” Musa aalu̱gha ewaa Falaaho asaaluuwe kwonini. ");
INSERT INTO tlj_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Niibuwo Mukama aaghi̱li̱ye Musa ati, “Falaaho taakubaaghu̱wa, niikuwo neeyongele kukola byakuswekani̱ya mu nsi ya Mi̱si̱li̱.” ");
INSERT INTO tlj_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa na Alooni̱ baakola byakuswekani̱ya bini byona mu maaso ghaa Falaaho, bhaatu Mukama oomakakani̱ya mutima ghwa Falaaho kandi aabhenga kuleka Banai̱saaleeli̱ ku̱lu̱gha mu nsi yee. ");
INSERT INTO tlj_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Mukama aaghila Musa na Alooni̱ mu nsi ya Mi̱si̱li̱ ati, ");
INSERT INTO tlj_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Kweli̱ kuni kubaaghe kwʼoku̱du̱bha kwa meeli̱ ghaanu, haaliikuwo mwatandikilaghʼo kubala mwaka ghwanu. ");
INSERT INTO tlj_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Mughambile ki̱bbu̱la kya Banai̱saaleeli̱ kyona muti haa kilo kyʼeku̱mi̱ kya kweli̱ kuni bu̱li̱ musaasa ali na kukoma kyana kya ntaama kya kwita nga kihonguwa haabwa ka yee, kyana kya ntaama kimui haabwa bu̱li̱ ka. ");
INSERT INTO tlj_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Bhaatu ka eghi niyaabaaye eli nkee kuliya kisolo eki kyona, bakitambulane na ka ya muliilanuwa wee. Batambulane kisolo eki kusighikila haa muhendo ghwa bantu abali mu bu̱li̱ ka kandi na nyama esi muntu akugubha kuliya kandi kumalʼo. ");
INSERT INTO tlj_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Bisolo ebi mukukomamu bili na kuba ebitali na kamogo, byabusaasa kandi ebili na mwaka ghumui. Mukugubha kubiiya mu ntaama kedha mbu̱li̱ syanu. ");
INSERT INTO tlj_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Bisolo ebi mubiloleelelaghe ku̱hi̱ki̱ya haa kilo kya eku̱mi̱ na bbinaa kya kweli̱ kuni, obu ki̱bbu̱la kyona kya Banai̱saaleeli̱ bakwekumaani̱ya kwita byana bya ntaama lwagholo. ");
INSERT INTO tlj_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Bantu aba bali na kutwala haa saghama ya bisolo ebi baghisiighe haa bi̱ji̱ngi̱li̱jo bya njighi na fuleemu syʼelughulu sya njighi sya manumba ghaabo hambali bakuliila bisolo ebi. ");
INSERT INTO tlj_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Mukilo eghi booki̱ye nyama esi haa mulilo, basiliye na migaati̱ etalimu ki̱tu̱mbi̱so kandi bulaala busaaliiye. ");
INSERT INTO tlj_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Mutaliya nyama esi sinali mbisi kedha kusiteeka, bhaatu syona mu̱syoki̱ye, otaayemu mutuwe, bilenge na byenda. ");
INSERT INTO tlj_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Mutati̱gha haa nyama esi ku̱hi̱ki̱ya nkyambisi, kaakuba si̱ti̱ghalʼo mu̱syoki̱ye sihuwʼo butakahi̱ki̱ye nkyambisi. ");
INSERT INTO tlj_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Muliye kiihulo eki bu̱li̱ muntu eebohi̱ye mu̱ci̱pi̱, alu̱wete nkai̱to mu bighele kandi akwete mwi̱gho mu ngalo yee. Mukiliye bwangu-bwangu nanga eki ni ki̱ghenu̱ kya Kusaaluwʼo kya Mukama. ");
INSERT INTO tlj_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Mukilo eghi nkusaalila mu nsi ya Mi̱si̱li̱ kandi nkwita bu̱li̱ mwana wabusaasa mu̱li̱ghaaso wa Banami̱si̱li̱ na mi̱li̱ghaaso yabusaasa ya bisolo byabo kandi nkufubila baaluhanga boona baa Banami̱si̱li̱. Ni̱i̱si̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Saghama eghi ekuba eli haa bi̱ji̱ngi̱li̱jo ebi ekuba kaakulolelʼo kwoleka manumba hambali muli. Nkaakubona saghama eghi, nkubasaala. Kifubilo kya lu̱ku̱ takikubahi̱kʼo obu nkuba ninfubila nsi ya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Kilo kini mukiisukaghe bu̱li̱ mwaka kandi mukolelaghe Mukama ki̱ghenu̱, kini mukikwate nga kilaghilo kya bilo nʼebilo mu mijo yaanu yoona. ");
INSERT INTO tlj_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Muliyaghe migaati̱ etalimu ki̱tu̱mbi̱so haabwa bilo musanju̱. Haa kilo kyʼoku̱du̱bha muuyaghe ki̱tu̱mbi̱so kyona mu manumba ghaanu, kaakuba muntu weena aliya mugaati̱ ghulimu ki̱tu̱mbi̱so, ku̱lu̱gha haa kilo kyʼoku̱du̱bha ku̱hi̱ka haa kilo kya musanju̱, muntu oghu abhinguwaghe mu Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Haa kilo kyʼoku̱du̱bha mubaaghe na kusanga-sangaana ku̱hi̱ki̱li̱i̱ye kandi na kilo kyamusanju̱ mubaaghe na kusanga-sangaana ku̱hi̱ki̱li̱i̱ye. Haa bilo bibili ebi mutakolagha mulimo. Mulimo ghwonkaha oghu muli na kukola ni kuteeka byokuliya. ");
INSERT INTO tlj_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Mukolaghe Ki̱ghenu̱ kya Migaati̱ Etalimu Ki̱tu̱mbi̱so, nanga haa kilo kini kyonini, niibuwo naahi̱ye ntu̱la syanu mu nsi ya Mi̱si̱li̱. Nahabweki mukolaghe ki̱ghenu̱ eki haa kilo kini, mu mijo yaanu yoona, nga kilaghilo kya bilo nʼebilo. ");
INSERT INTO tlj_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Muliyaghe migaati̱ etalimu ki̱tu̱mbi̱so kutandikila lwagholo lwa kilo kya eku̱mi̱ na bbinaa kya kweli̱ kwʼoku̱du̱bha oku, ku̱hi̱ki̱ya lwagholo lwa kilo kya maku̱mi̱ abili na kimui. ");
INSERT INTO tlj_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Mu bilo musanju̱ ebi mutaba na ki̱tu̱mbi̱so kyona mu manumba ghaanu. Kaakuba muntu weena aliya mugaati̱ ghulimu ki̱tu̱mbi̱so, muntu oghu abhinguwe mu ki̱bbu̱la kya Banai̱saaleeli̱, nankabha aba ali munamahanga kedha Munai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Mutaliliya kintu kyona ekilimu ki̱tu̱mbi̱so, hambali muukaaye, muliyaghe migaati̱ etalimu ki̱tu̱mbi̱so.” ");
INSERT INTO tlj_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Niibuwo Musa aabilikiiye beebembeli̱ boona baa I̱saaleeli̱, aabaghila ati, “Mughende kandi mwekomele byana bya ntaama kusighikila haa ntu̱la syanu kandi mubiite kukola ki̱ghenu̱ kya Kusaaluwʼo. ");
INSERT INTO tlj_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Mukwate kabha kaa hai̱sopu̱ mukalu̱bi̱ke mu saghama eghi ali mu bbaafu kandi mughisiighe haa fuleemu syʼelughulu sya njighi syanu na haa bi̱ji̱ngi̱li̱jo. Atabʼo muntu nʼomui mu enu̱we oghu akutuwa mu numba yee ku̱hi̱ki̱ya nkyambisi. ");
INSERT INTO tlj_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Mukama akusaalila mu nsi ya Mi̱si̱li̱ kandi akwita Banami̱si̱li̱. Bhaatu akaakubona saghama haa fuleemu syʼelughulu sya njighi syanu na haa bi̱ji̱ngi̱li̱jo, akusaala lwighi olu. Taaku̱si̱i̱mi̱lani̱ya malai̱ka wa lu̱ku̱ kutaaha mu manumba ghaanu kwita enu̱we. ");
INSERT INTO tlj_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Muusuke, ndaghikiililo sini nkilaghilo ngoku enu̱we na baasukulu baanu muli na kukola ki̱ghenu̱ eki bilo nʼebilo. ");
INSERT INTO tlj_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Mukaaku̱ki̱dha mu nsi eghi Mukama akubaha ngoku aalaghi̱i̱sani̱i̱ye, mukolaghe mukolo oghu. ");
INSERT INTO tlj_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Baana baanu mbaanabu̱u̱i̱ye enu̱we bati, ‘Mukolo ghuni ghukumani̱i̱si̱ya ki?’ ");
INSERT INTO tlj_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Mubakuukemu muti, ‘Tukwete kuhaayo kihonguwa kya Kusaaluwʼo kya Mukama, nanga akasaala manumba ghaa Banai̱saaleeli̱ mu Mi̱si̱li̱, obu aatagha baana baabusaasa mi̱li̱ghaaso baa Banami̱si̱li̱, bhaatu aasaala manumba ghaatu.’ ” Bantu aba baateeli̱ya hansi kandi baalami̱ya Mukama. ");
INSERT INTO tlj_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Banai̱saaleeli̱ baaghenda kandi baakola ebi Mukama aalaghiiye Musa na Alooni̱. ");
INSERT INTO tlj_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Saaha mukaagha sya mukilo Mukama aata baana baabusaasa boona mi̱li̱ghaaso ya Banami̱si̱li̱ ku̱lu̱gha haa mu̱li̱ghaaso wabusaasa wa mukama Falaaho, oghu akusitama haa ntebe ya bukama yee, ku̱hi̱ki̱ya haa mu̱li̱ghaaso ghwa muntu wa bu̱li̱ kilo oghu ali mu nkomo, na mi̱li̱ghaaso yoona yabusaasa ya bisolo. ");
INSERT INTO tlj_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Mukilo eghi Falaaho aamuka na baheeleli̱ya be boona na Banami̱si̱li̱ boona. Baaghu̱wa bantu mbalilila kimui mu Mi̱si̱li̱, nanga mu bu̱li̱ numba muntu akaba aku̱u̱yemu. ");
INSERT INTO tlj_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Mukilo eghi Falaaho aatuma kubilikila Musa na Alooni̱ kandi aabaghila ati, “Muumuke, enu̱we na Banai̱saaleeli̱ kandi mughende mu̱heeleli̱ye Mukama waanu ngoku mwabu̱ghi̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Mutwale ntaama, mbu̱li̱ na nte syanu ngoku mwabu̱ghi̱ye, mughende. Munsabile kutunga mu̱gi̱sa.” ");
INSERT INTO tlj_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Banami̱si̱li̱ baataamu maani̱ Banai̱saaleeli̱ ku̱lu̱gha bwangu mu nsi ya Mi̱si̱li̱, baabaghila bati, “Mutaaghendi̱ye etu̱we boona tu̱ku̱ku̱wa.” ");
INSERT INTO tlj_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Nahabweki Banai̱saaleeli̱ baakwata ki̱tu̱mbe kitalimu ki̱tu̱mbi̱so, baakita mu capu̱li̱ya, baaboha capu̱li̱ya esi mu ngoye syabo kandi baasiheeka haa mabegha ghaabo. ");
INSERT INTO tlj_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Banai̱saaleeli̱ aba baakola ngoku Musa aabaghambiiye, baasaba Banami̱si̱li̱ kubaha ngoye na bintu bi̱koleeu̱we mu siliva kandi feeja. ");
INSERT INTO tlj_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Mukama aaleka Banami̱si̱li̱ baaghilila kisa Banai̱saaleeli̱ kandi baabaha ebi baabasabi̱ye, niikuwo Banai̱saaleeli̱ baatwete batiyo buguudha bwa Banami̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Banai̱saaleeli̱ baatandika kulubhatanga na maghulu ku̱lu̱gha Lamu̱sesi̱ ku̱hi̱ka Su̱kooti̱. Bakaba bali nga basaasa mitwalo nkaagha, otabaliiyemu bakali̱ na baana. ");
INSERT INTO tlj_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Bantu banji bakani̱ye baa ntu̱la syambaghani̱ja baaghenda na Banai̱saaleeli̱ aba kandi baatwala bitunguwa byabo bikaniiye kimui bya ntaama, mbu̱li̱ na nte. ");
INSERT INTO tlj_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ki̱tu̱mbe eki Banai̱saaleeli̱ baahi̱ye mu Mi̱si̱li̱, baakiteekamu migaati̱ etalimu ki̱tu̱mbi̱so nanga bakababhinga bwangu-bwangu mu Mi̱si̱li̱ kandi bataatunga bwile bwa kutwala ki̱tu̱mbi̱so kandi kuteeka byokuliya. ");
INSERT INTO tlj_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Banai̱saaleeli̱ bakaba mbaakaaye mu Mi̱si̱li̱ haabwa myaka bi̱ku̱mi̱ bbinaa na maku̱mi̱ asatu. ");
INSERT INTO tlj_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Kilo kyonini eki myaka bi̱ku̱mi̱ bbinaa na maku̱mi̱ asatu yaahweleeyemu, ntu̱la syona sya bantu baa Mukama syalu̱gha mu nsi ya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Mukilo eghi Mukama aalinda bantu be kubaaya mu nsi ya Mi̱si̱li̱, nahabweki mukilo eghi Banai̱saaleeli̱ boona baghihaagheyo ewaa Mukama bu̱li̱ mwaka mu mijo yabo yoona. ");
INSERT INTO tlj_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Mukama aaghila Musa na Alooni̱ ati, “Bini niibiyo bilaghilo bya Ki̱ghenu̱ kya Kusaaluwʼo: Hatabʼo munamahanga nʼomui oghu akuliya haa kiihulo kya ki̱ghenu̱ eki. ");
INSERT INTO tlj_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Bhaatu mu̱syana weena oghu baghu̱li̱ye na sente akugubha kuliya haa ki̱ghenu̱ eki haanu̱ma ya kumusala. ");
INSERT INTO tlj_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Hatabʼo munamahanga kedha mu̱koli̱ bapangi̱i̱si̱i̱ye oghu akugubha kuliya haa ki̱ghenu̱ eki. ");
INSERT INTO tlj_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Bu̱li̱ ka eli na kuliila kiihulo kya Kusaaluwʼo mu numba hambali baakiteekeeye. Batatwesi̱ya haa byokuliya ebi hanja kandi batahenda eku̱wa lyakiyo na limui. ");
INSERT INTO tlj_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Ki̱bbu̱la kyona kya Banai̱saaleeli̱ kikolaghe ki̱ghenu̱ eki. ");
INSERT INTO tlj_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Kaakuba munamahanga weena oghu aakaaye naanu, abbala kukolela Mukama ki̱ghenu̱ kya Kusaaluwʼo, muli na ku̱du̱bha kusala basaasa boona abali mu ka yee. Du̱mbi̱ akolaghe ki̱ghenu̱ kya Kusaaluwʼo nga Banai̱saaleeli̱ banji boona. Bhaatu taaliyo musaasa weena oghu batasali̱ye oghu ali na kuliya haa kiihulo eki. ");
INSERT INTO tlj_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Kilaghilo kimui eki ni kya Banai̱saaleeli̱, na banamahanga abaakaaye naanu.” ");
INSERT INTO tlj_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Banai̱saaleeli̱ boona baakola ngoku Mukama aalaghiiye Musa na Alooni̱. ");
INSERT INTO tlj_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Kilo eki kyonini Mukama aaya ntu̱la sya Banai̱saaleeli̱ mu nsi ya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Muhaagheyo ewanje baana boona baabusaasa mi̱li̱ghaaso. Mi̱li̱ghaaso yoona ya baana baabusaasa baa Banai̱saaleeli̱ na mi̱li̱ghaaso yabusaasa ya bisolo byabo, ni byanje.” ");
INSERT INTO tlj_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Musa aaghila bantu baa I̱saaleeli̱ ati, “Muusukaghe kilo kini eki mwalu̱ghi̱ye Mi̱si̱li̱, mu nsi hambali mwabaagha basyana. Mukama akabaayayo na mukono ghuwe ghwamaani̱. Kilo eki mutaliyagha migaati̱ elimu ki̱tu̱mbi̱so. ");
INSERT INTO tlj_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Obwalo mu kweli̱ kuni kwa Abi̱bu̱, niibuwo mu̱ku̱lu̱gha Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Mukama akaakubaki̱dhi̱ya mu nsi ya Banakanaani̱, Bahi̱ti̱, Bamooli̱, Bahi̱vi̱ na Bayebu̱si̱, eghi aalahiiye ewaa baataata baanu ati akuha enu̱we, nsi eghi ekwete kusendamu mata na bwoki, mukolaghe ki̱ghenu̱ kini mu kweli̱ kuni. ");
INSERT INTO tlj_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Bilo musanju̱ muliyaghe migaati̱ etalimu ki̱tu̱mbi̱so kandi haa kilo kyamusanju̱ habaaghʼo ki̱ghenu̱ kya Mukama. ");
INSERT INTO tlj_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Muliyaghe migaati̱ etalimu ki̱tu̱mbi̱so haabwa bilo musanju̱, taaliyo mugaati̱ oghulimu ki̱tu̱mbi̱so oghuli na kuboneka mu enu̱we kandi taaliyo ki̱tu̱mbi̱so ekili na kuboneka mu enu̱we mu nsi yaanu yoona. ");
INSERT INTO tlj_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Haa kilo eki, oghambilaghe baana baawe oti, ‘Nkwete kukola ki̱ghenu̱ kini haabwa ebi Mukama ankoleeye obu naalu̱ghagha Mi̱si̱li̱.’ ");
INSERT INTO tlj_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ki̱ghenu̱ kini kilabaagha nga kabonelo haa mukono ghwawe kandi kaakulolelʼo haa bhu̱u̱su̱ yaawe, ku̱ku̱u̱su̱ki̱ya ku̱bu̱gha kandi kwegha kilaghilo kya Mukama, nanga Mukama akakuuya mu nsi ya Mi̱si̱li̱ na mukono ghuwe ghwamaani̱. ");
INSERT INTO tlj_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Okolaghe ki̱ghenu̱ mu bwile bwakiyo bwonini bu̱li̱ mwaka. ");
INSERT INTO tlj_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Mukama akaaku̱ku̱ki̱dhi̱ya mu nsi ya Banakanaani̱ kandi naakuha nsi eghi, ngoku aalaghi̱i̱sani̱i̱ye na kilahilo uwe na baataata baawe, ");
INSERT INTO tlj_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","oli na kuhaayo ewaa Mukama bu̱li̱ mwana wabusaasa mu̱li̱ghaaso. Mi̱li̱ghaaso yoona yabusaasa ya bisolo byawe elabaagha ya Mukama. ");
INSERT INTO tlj_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Ocungulaghe bu̱li̱ mu̱li̱ghaaso ghwabusaasa ghwa ndogooi̱ na kyana kya ntaama, bhaatu otaaghucunguuye, oghuhende bikiya. Oli na kucungula baana baawe baabusaasa mi̱li̱ghaaso. ");
INSERT INTO tlj_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Mu bwile obuliisa obu baana baawe bali̱ku̱bu̱u̱li̱ya bati, ‘Kini kikumani̱i̱si̱ya ki?’ Obaghile oti, ‘Mukama akatuuya Mi̱si̱li̱ na mukono ghuwe ghwamaani̱, aatuuya mu nsi hambali twabaagha basyana. ");
INSERT INTO tlj_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Obu Falaaho aabhengi̱ye kutuleka kughenda, Mukama aata baana boona baabusaasa mi̱li̱ghaaso mu nsi ya Mi̱si̱li̱, mi̱li̱ghaaso ya bantu na bisolo. Eki niikiyo ki̱leki̱ye nimpayo bu̱li̱ mu̱li̱ghaaso ghwa kisolo nga kihonguwa ewaa Mukama. Bhaatu haabwa bu̱li̱ mwana wanje wabusaasa mu̱li̱ghaaso, nkumucungula nimpayo kisolo nga kihonguwa.’ ");
INSERT INTO tlj_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ki̱ghenu̱ eki kilabaagha nga kabonelo haa mukono ghwawe kandi kaakulolelʼo haa bhu̱u̱su̱ yaawe ku̱ku̱u̱su̱ki̱ya ngoku Mukama aaku̱u̱hi̱ye mu nsi ya Mi̱si̱li̱ na mukono ghuwe ghwamaani̱.” ");
INSERT INTO tlj_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Obu Falaaho aasi̱i̱mi̱lani̱i̱ye bantu baa I̱saaleeli̱ kughenda, Luhanga taabahikiiye kukwamila mu kihanda kya mu nsi ya Bafi̱li̱si̱ti̱, nankabha nkyabaagha kya haai-haai. Nanga Luhanga akaghila ati, “Kaakuba bantu aba basangayo bulemo, bakugubha kuhindula byeli̱li̱kano byabo kandi bakuuke Mi̱si̱li̱.” ");
INSERT INTO tlj_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Bhaatu Luhanga aabahikila kukwama kihanda kyʼomu elungu eki̱ghendi̱ye haa Nanja Mutuku. Banai̱saaleeli̱ baalu̱gha mu nsi ya Mi̱si̱li̱ bali na byakulwani̱i̱si̱ya bulemo. ");
INSERT INTO tlj_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musa aatwala maku̱wa ghaa Yojeefu̱, nanga Yojeefu̱ akaba naaleki̱ye batabani̱ baa I̱saaleeli̱ mbalahiiye kukola eki. Aaghila ati, “Kilo kimui, Luhanga akwisa kandi abajune. Nahabweki muli na kuheeka maku̱wa ghanje obu mukuba ni̱mu̱lu̱gha mu ki̱i̱kalo kini.” ");
INSERT INTO tlj_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Banai̱saaleeli̱ baalu̱gha Su̱kooti̱ kandi baaghoona Etamu, haa mutaano ghwa elungu. ");
INSERT INTO tlj_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Ntangaali̱ Mukama aabahikilagha mu mpaghi ya kicu kubooleka kihanda kandi mukilo aabahikila mu mpaghi ya mulilo kubaha kyeleeli̱, niikuwo bagubhe kughenda mukilo na ntangaali̱. ");
INSERT INTO tlj_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Mpaghi ya kicu yaakalagha ehikiiye bantu aba ntangaali̱ kandi mpaghi ya mulilo ebahikiiye mukilo. ");
INSERT INTO tlj_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Oghambile Banai̱saaleeli̱ bakuuke enu̱ma kandi baghoone mu maaso ghaa tau̱ni̱ ya Pihahi̱looti̱, haagati ya tau̱ni̱ ya Mi̱gi̱doli̱ na Nanja Mutuku, haai na Bbaali̱-jefoni̱. ");
INSERT INTO tlj_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Falaaho akweli̱li̱kana ati, ‘Banai̱saaleeli̱ niibuwo baalalanga mu nsi kandi elungu libatangi̱ye kughenda.’ ");
INSERT INTO tlj_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Nkwomakakani̱ya mutima ghwa Falaaho kandi akuhuma enu̱we. Nku̱mu̱si̱ngu̱la na mahe ghe, niikuwo bantu bampe ki̱ti̱i̱ni̱sa. Haanu̱ma yʼeki Banami̱si̱li̱ bakumanya ngoku ndi Mukama.” Nahabweki Banai̱saaleeli̱ baakola eki Mukama aabalaghiiye. ");
INSERT INTO tlj_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Obu baaghambiiye Falaaho mukama wa Mi̱si̱li̱ ngoku Banai̱saaleeli̱ baalu̱ki̱ye, Falaaho na baheeleli̱ya be baahindula byeli̱li̱kano byabo haa Banai̱saaleeli̱ kandi baaghila bati, “Nkiki kini eki twakoli̱ye? Twaleki̱ye Banai̱saaleeli̱ baaghenda kandi bakuleka kuba basyana baatu!” ");
INSERT INTO tlj_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Du̱mbi̱ Falaaho aateekani̱ja kigaali̱ kiye kandi aaghenda na mahe ghe. ");
INSERT INTO tlj_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Aatwala bigaali̱ lukaagha bisemeeye kwonini na bigaali̱ binji byona bya Mi̱si̱li̱, bu̱li̱ kimui kili na mukulu wa mahe wakiyo. ");
INSERT INTO tlj_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Mukama oomakakani̱ya mutima ghwa Falaaho mukama wa Mi̱si̱li̱ kandi aahuma Banai̱saaleeli̱ abaaghendagha batoobahi̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Mahe ghaa Banami̱si̱li̱, nkai̱na syabo syona, bigaali̱ na abaabifugagha, baahuma Banai̱saaleeli̱ kandi baabasanga hambali baghooneeye haa ki̱si̱yo kya Nanja Mutuku haai na tau̱ni̱ ya Pihahi̱looti̱ mu maaso ghaa tau̱ni̱ ya Bbaali̱-jefoni̱. ");
INSERT INTO tlj_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Obu Banai̱saaleeli̱ baaboone Falaaho na mahe ghe mbabeebinga, boobahila kimui kandi baatandika kutaagha ewaa Mukama kubakoonela. ");
INSERT INTO tlj_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Baaghila Musa bati, “Waatu̱leeti̱ye mu elungu lini ku̱kwi̱lamu nangaaki? Buuye mu Mi̱si̱li̱ taabaaghayo bituulo ebikutumala? Waatu̱u̱hi̱ye mu Mi̱si̱li̱ bwaki? ");
INSERT INTO tlj_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Tatwakughambiiye tutakalu̱ghi̱ye Mi̱si̱li̱ tuti, ‘Otuleke tuukale tunali basyana baa Banami̱si̱li̱. Nkilungi etu̱we kuba basyana mu ki̱i̱kalo kya ku̱kwi̱la hani mu elungu!’ ” ");
INSERT INTO tlj_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musa aakuukamu ati, “Mutoobaha kandi mugume, obwalo mukubona eki Mukama akukola kujuna enu̱we kandi tamukutodha kubona Banami̱si̱li̱ aba bbaa. ");
INSERT INTO tlj_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Mukama akubalwanilila kandi enu̱we mukuukala mu̱loli̱ye kwonkaha.” ");
INSERT INTO tlj_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Mukama aaghila Musa ati, “Okwete ku̱neesengeleli̱ya kukukoonela nangaaki? Oghambile Banai̱saaleeli̱ beeyongele kughenda mu maaso. ");
INSERT INTO tlj_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Oomu̱ki̱ye mwi̱gho ghwawe kandi onanule mukono ghwawe haa nanja kughitambulani̱yamu, niikuwo Banai̱saaleeli̱ babhasuke nanja eghi mbalubhatangila hʼetaka lyomi̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Nkwomakakani̱ya mitima ya Banami̱si̱li̱ niikuwo baase babalabhi̱ye kandi bantu bakumpa ki̱ti̱i̱ni̱sa haabwa ku̱si̱ngu̱la Falaaho, bigaali̱ biye na mahe ghe ghoona aghani̱i̱ni̱ye haa nkai̱na. ");
INSERT INTO tlj_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Bantu bakumpa ki̱ti̱i̱ni̱sa kandi Banami̱si̱li̱ bakumanya ngoku ndi Mukama nkaakumala ku̱si̱ngu̱la Falaaho, bigaali̱ biye na mahe ghe aghani̱i̱ni̱ye haa nkai̱na.” ");
INSERT INTO tlj_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Malai̱ka wa Luhanga oghu aaghendagha ahikiiye mahe ghaa I̱saaleeli̱, aaghenda enu̱ma syabo kandi mpaghi ya kicu yaalu̱gha mu maaso ghaabo kandi yaaghenda enu̱ma syabo. ");
INSERT INTO tlj_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Mpaghi eghi yeemilila haagati ya mahe ghaa Banami̱si̱li̱ na Banai̱saaleeli̱. Mukilo eghi yoona kicu eki kyaleeta mweli̱ma haa luhande lwa Banami̱si̱li̱ kandi kyeleeli̱ haa luhande lwa Banai̱saaleeli̱, nahabweki taaliyo mahe agheebi̱ngi̱ye ghaanakyaghʼo mukilo eghi yoona. ");
INSERT INTO tlj_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Musa aananula mukono ghuwe haa nanja kandi Mukama aaleetʼo mwegha ghwamaani̱ ku̱lu̱gha bu̱lu̱gha ejooba. Mwegha oghu ghwahunga mukilo eghi yoona, ghwatambulani̱yamu kabili maasi agha kandi haabaamu kihanda kyʼetaka lyomi̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Banai̱saaleeli̱ baakwamila haagati ya nanja eghi mbalubhatangila hʼetaka lyomi̱ye, maasi ghaneemiliiye nga kisiika haa luhande lwabo lwa mukono ghwabuliyo na ghwa bumesu. ");
INSERT INTO tlj_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Banami̱si̱li̱ baabakwama haagati ya nanja eghi, bali na nkai̱na syona sya Falaaho, bigaali̱ biye, na mahe ghoona abaaghendagha bani̱i̱ni̱ye haa nkai̱na esi. ");
INSERT INTO tlj_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Nkyambisi cu̱i̱, Mukama aalola Banami̱si̱li̱ ku̱lu̱gha mu mpaghi ya mulilo na mpaghi ya kicu kandi aaleka boobaha. ");
INSERT INTO tlj_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Aaleka nkata sya bigaali̱ byabo syasaaba kandi baasaaghuwa kubifuga. Baaghila bati, “Oleke tuuluke Banai̱saaleeli̱ aba! Mukama niibuwo aalwana naatu Banami̱si̱li̱ haabwa bantu aba.” ");
INSERT INTO tlj_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Niibuwo Mukama aaghi̱li̱ye Musa ati, “Onanule mukono ghwawe haa nanja, niikuwo maasi ghamele Banami̱si̱li̱, bigaali̱ byabo na abani̱i̱ni̱ye haa nkai̱na.” ");
INSERT INTO tlj_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Nkyambisi cu̱i̱, Musa aananula mukono ghuwe haa nanja kandi maasi agha ghaatodha ghaakuuka ngoku ghaabaagha. Banami̱si̱li̱ baalengʼo kuuluka maasi agha, bhaatu Mukama aakuba Banami̱si̱li̱ aba haagati ya nanja eghi. ");
INSERT INTO tlj_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Maasi agha ghaakuuka ngoku ghaabaagha. Ghaamela mahe ghaa Falaaho ghoona abaabaagha balabhi̱ye Banai̱saaleeli̱ mu nanja eghi. Ghaaswi̱ki̱la bigaali̱ byabo byona, nkai̱na syabo na abaabaagha basi̱ni̱i̱ni̱yʼo. Taaliyo nʼomui oghu akati̱ghalʼo. ");
INSERT INTO tlj_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Bhaatu Banai̱saaleeli̱ baalubhatangila mu nanja eghi haa etaka lyomi̱ye kandi maasi ghaamilila nga kisiika haa luhande lwabo lwa mukono ghwabuliyo na ghwabumesu. ");
INSERT INTO tlj_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Kilo eki Mukama aajuna Banai̱saaleeli̱ ku̱lu̱gha mu mukono ghwa Banami̱si̱li̱ kandi Banai̱saaleeli̱ baabona mi̱ku̱ ya Banami̱si̱li̱ haa ki̱si̱yo kya nanja eghi. ");
INSERT INTO tlj_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Obu Banai̱saaleeli̱ baaboone bu̱toki̱ bwamaani̱ obu Mukama aakoleeseei̱ye ku̱si̱ngu̱la Banami̱si̱li̱, Banai̱saaleeli̱ aba baahu̱ti̱ya Mukama kandi baamu̱hi̱ki̱li̱ja. Baahi̱ki̱li̱ja dhee mu̱heeleli̱ya wee Musa. ");
INSERT INTO tlj_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Niibuwo Musa na Banai̱saaleeli̱ baalimbiiye Mukama kilimbo kini bati, “Nkulimbila Mukama, nanga aasi̱ngu̱u̱ye kwonini, aaku̱bi̱ye mu nanja nkai̱na nʼoghu aghi̱ni̱i̱ni̱yʼo. ");
INSERT INTO tlj_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Mukama niiye akumpaagha maani̱ kandi kilimbo kyanje. Niiye akunjunagha kandi niiye Luhanga wanje, nkumusinda. Niiye Luhanga wa tita kandi nku̱mu̱ku̱ghi̱ja. ");
INSERT INTO tlj_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Mukama ni mulwani̱ wamaani̱ kandi Mukama niiliyo li̱i̱na liye. ");
INSERT INTO tlj_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","“Bigaali̱ bya Falaaho na mahe ghe aabi̱ku̱bi̱ye mu nanja, bakulu be baa mahe baamaani̱ baadhikiiye mu Nanja Mutuku. ");
INSERT INTO tlj_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Nanja etobheeye yaabameli̱ye kandi baadhikila hansi yayo nga ebaale. ");
INSERT INTO tlj_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ai̱ Mukama, mukono ghwawe ghwabuliyo ghuli na bu̱toki̱ bwamaani̱, Ai̱ Mukama, mukono ghwawe ghwabuliyo ghwasabanguuye ngi̱ghu̱. ");
INSERT INTO tlj_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ku̱si̱ngu̱la kwawe kwamaani̱ kwaleki̱ye waaweelekeeleli̱ya ngi̱ghu̱ syawe kandi ki̱i̱ni̱gha kyawe kikubaagha nga mulilo kandi okwoki̱yagha ngi̱ghu̱ syawe nga bisunga. ");
INSERT INTO tlj_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Obu waahu̱u̱hi̱ye lwoha lwʼomu mihuli yaawe maasi ghaaba ntuumo, mighina yeemilila nga kisiika kandi nanja etobheeye yaakwatana. ");
INSERT INTO tlj_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“Ngi̱ghu̱ aaghila ati, ‘Nkubahuma kandi mbakwate. Nkutambulana etungo lyabo kandi nkutwala byona ebi nkubbala. Nkubhulayo kihiyo kyanje kandi mukono ghwanje ghukubahwelekeeleli̱ya.’ ");
INSERT INTO tlj_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Okahuuha lwoha lwawe kandi nanja yaabamela, baadhikila hansi nga kyoma mu maasi ghaamaani̱. ");
INSERT INTO tlj_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“Ai̱ Mukama ni ani̱ ali ngaawe mu baaluhanga? Ni ani̱ ali ngaawe mu ki̱ti̱i̱ni̱sa, bu̱hi̱ki̱li̱i̱le, oghu bantu boobahi̱ye kandi oghu akukolagha byakuswekani̱ya? ");
INSERT INTO tlj_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Okananula mukono ghwawe ghwabuliyo, nsi yaamela ngi̱ghu̱ syatu. ");
INSERT INTO tlj_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“Kukunda kwawe kwamaani̱ kukaleka waahikila bantu baawe aba waacunguuye kandi haabwa maani̱ ghaawe waabatwala mu kyalo kyawe ki̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Bantu bʼomu mahanga ghanji baku̱u̱ghu̱wa eki kandi bakutukumila. Bantu abaakaaye mu Fi̱li̱si̱ti̱ya bakwobahila kimui. ");
INSERT INTO tlj_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Beebembeli̱ bʼomu Edomu batuntuuye. Basaasa baamaani̱ baa Mowaabu niibuwo baatukumila kandi bantu boona abaakaaye Kanaani̱ mitima ebakangami̱ye munda. ");
INSERT INTO tlj_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ai̱ Mukama, bantu aba boona boobahi̱ye kandi niibuwo baatukumila, haabwa mukono ghwawe ghwamaani̱. Ai̱ Mukama, bantu aba baku̱holi̱ya nga ebaale ku̱hi̱ki̱ya bantu baawe aba waacunguuye basaaye. ");
INSERT INTO tlj_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ai̱ Mukama, okubatwala kandi obate haa mwena ghwawe, mu ki̱i̱kalo eki waakomi̱yemu kuukalamu. Ai̱ Mukama, ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye eki waakoli̱ye na mikono yaawe. ");
INSERT INTO tlj_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Mukama akulema bilo nʼebilo.” ");
INSERT INTO tlj_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Obu nkai̱na sya Falaaho, bigaali̱ biye na basaasa be abaaghendagha basi̱ni̱i̱ni̱yʼo baakoti̱ye mu nanja, Mukama aaku̱u̱ki̱ya maasi agha kandi ghaabamela. Bhaatu Banai̱saaleeli̱ bakaba mbaamali̱ye kubhasuka nanja eghi haagati mbalubhatangila haa etaka lyomi̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Niibuwo Mi̱li̱yamu mulangi̱ wabukali̱, mwani̱na Alooni̱, aakwete kaaciki-ciki mu ngalo yee. Bakali̱ banji boona baaghenda bamulabhi̱ye mbateela buuciki-ciki bwabo kandi mbabi̱na. ");
INSERT INTO tlj_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Mi̱li̱yamu aabalimbila naaghila ati, “Mulimbile Mukama, nanga aasi̱ngu̱u̱ye kwonini, aaku̱bi̱ye mu nanja nkai̱na nʼoghu aghi̱ni̱i̱ni̱yʼo.” ");
INSERT INTO tlj_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Niibuwo Musa aahikiiye Banai̱saaleeli̱ ku̱lu̱gha haa Nanja Mutuku, baaghenda mu elungu lya Suula. Baalubhatanga bilo bisatu mu elungu eli kandi bataabona maasi. ");
INSERT INTO tlj_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Obu baaki̱dhi̱ye e Maala, tabaagubha kunuwa maasi ghaayo, nanga ghakaba ghasaaliiye, nahabweki ki̱i̱kalo eki baakiluka li̱i̱na Maala. ");
INSERT INTO tlj_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Bantu aba baatongana na Musa bati, “Buuye tukunuwa biki?” ");
INSERT INTO tlj_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Musa ataaghila Mukama kandi Mukama aamwoleka ki̱twi̱ke kya lukui. Musa aakikuba mu maasi agha, du̱mbi̱ ghaaleka kusaalila. Mu ki̱i̱kalo eki Mukama aateelʼo Banai̱saaleeli̱ kilaghilo na ntu̱wamu naabbala kubalengesa. ");
INSERT INTO tlj_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Aabaghila ati, “Kaakuba weekamba ku̱hu̱ti̱ya si̱ye Mukama Luhanga waawe, okola ebi̱ndheedhi̱ye, okwata bilaghilo byanje na ntu̱wamu syanje, tankukuha kifubilo kya ndwala esi naaleki̱ye Banami̱si̱li̱ baalwala, nanga ni̱i̱si̱ye Mukama oghu aku̱ku̱ki̱li̱yagha.” ");
INSERT INTO tlj_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Banai̱saaleeli̱ baalu̱gha Maala kandi baaki̱dha Eli̱mu̱, hambali baasangi̱ye nsulo eku̱mi̱ nʼebili na bi̱ti̱na nsanju̱ bya mba, baaghoona mu ki̱i̱kalo eki haakpengbu̱ ya maasi. ");
INSERT INTO tlj_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Ki̱bbu̱la kyona kya Banai̱saaleeli̱ kyalu̱gha Eli̱mu̱ kandi kyaki̱dha mu elungu lya Si̱i̱ni̱, haagati ya Eli̱mu̱ na Si̱naai̱, haa kilo kyʼeku̱mi̱ na bitaano kya kweli̱ kwakabili haanu̱ma ya ku̱lu̱gha mu nsi ya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Obu baabaagha banali mu elungu eli, ki̱bbu̱la kya Banai̱saaleeli̱ kyona kyatongana na Musa na Alooni̱. ");
INSERT INTO tlj_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Banai̱saaleeli̱ aba baabaghila bati, “Twekumbulagha hakili nguli Mukama aatwitiiye mu nsi ya Mi̱si̱li̱, nanga eghi twasitamagha tuliya nyama sikani̱ye na byokuliya kandi tuukuta. Bhaatu mwaleeti̱ye mu elungu lini ki̱bbu̱la kini kyona ku̱twi̱ti̱ya njala.” ");
INSERT INTO tlj_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Mukama aaghila Musa ati, “Nkuleka byokuliya bya mbaghani̱ja bilaghalike hansi ku̱lu̱gha mu mwanya nga mbu̱la. Bantu aba bali na kutuwa kandi kukumaani̱ya ebikubamala kilo eki kyonkaha. Eki kikuleka nimanye bakaakuba mbahu̱ti̱ya kilaghilo kyanje kedha bbaa. ");
INSERT INTO tlj_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Kilo kyamukaagha bu̱li̱ wi̱i̱ki̱, obu balabaagha mbakumaani̱ya byokuliya, bakumaani̱yaghe milundi ebili nga bya bu̱li̱ kilo.” ");
INSERT INTO tlj_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Musa na Alooni̱ baaghambila Banai̱saaleeli̱ boona bati, “Obwalo lwagholo mukumanya ngoku Mukama aaniiye aabaahi̱ye mu nsi ya Mi̱si̱li̱ ");
INSERT INTO tlj_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","kandi nkyambisi mukubona ngoku Mukama ali na ki̱ti̱i̱ni̱sa, nanga aaghu̱u̱ye ngoku mukwete kutongana naye. Buuye ni̱i̱tu̱we baki enu̱we kutongana naatu?” ");
INSERT INTO tlj_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Musa aatodha aabaghila ati, “Lwagholo Mukama alabahaagha nyama sya kuliya kandi nkyambisi byokuliya ebi mukuliya kandi muukute, nanga aaghu̱u̱ye ngoku mukwete kutongana naye. Obu mukwete kutongana naatu, majima niibuwo mwatongana na Mukama.” ");
INSERT INTO tlj_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Niibuwo Musa aaghi̱li̱ye Alooni̱ ati, “Oghambile ki̱bbu̱la kyona kya Banai̱saaleeli̱ oti, ‘Mwise mu maaso ghaa Mukama, nanga aaghu̱u̱ye ngoku mukwete kutongana.’ ” ");
INSERT INTO tlj_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Alooni̱ naanabu̱gha na ki̱bbu̱la kya Banai̱saaleeli̱, baalola mu elungu kandi baabona ku̱bbeni̱ya kwa ki̱ti̱i̱ni̱sa kya Mukama mu kicu. ");
INSERT INTO tlj_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Naaghu̱u̱ye ngoku Banai̱saaleeli̱ bakwete kutongana. Obaghile oti, ‘Bu̱li̱ lwagholo balaliyaagha nyama kandi bu̱li̱ nkyambisi baliyaghe byokuliya kandi baakute. Du̱mbi̱ mukumanya ngu ndi Mukama Luhanga waanu.’ ” ");
INSERT INTO tlj_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Lwagholo olu nkwali syasa kandi syamalakaka hambali baghooneeye kandi nkyambisi ki̱me kyakwata hambali baghooneeye. ");
INSERT INTO tlj_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Obu ki̱me kyahooyʼo, baabona mu elungu eli bintu bijelu biinabwana bikwataane nga ki̱me hansi. ");
INSERT INTO tlj_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Obu Banai̱saaleeli̱ baabiboone baabu̱u̱lani̱ya bati, “Ebi mbiki?” Nanga bakaba batabimani̱ye. Musa aabaghila ati, “Ni byokuliya ebi Mukama aabahaaye kuliya. ");
INSERT INTO tlj_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Kini niikiyo eki Mukama aalaghiiye ati, ‘Bu̱li̱ omui mu enu̱we akumaani̱ye byokuliya ebi akugubha kuliya kandi kumalʼo. Bu̱li̱ muntu akumaani̱ye jaaga emui ya byokuliya haabwa bu̱li̱ muntu oghu ali mu ka yee.’ ” ");
INSERT INTO tlj_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Banai̱saaleeli̱ baakola ngoku baabaghambiiye. Bamui mu bantu aba baakumaani̱ya byokuliya bikani̱ye na banji baakumaani̱ya bikee. ");
INSERT INTO tlj_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Bhaatu obu baabi̱pi̱i̱mi̱ye haa ki̱pi̱i̱mo, abaakumaani̱i̱ye bikani̱ye tabaati̱ghaai̱ye kantu kandi abaakumaani̱i̱ye bikee tabaabu̱lu̱u̱we kantu. Bu̱li̱ muntu aakumaani̱ya byokuliya ebi akugubha kuliya kandi kumalʼo. ");
INSERT INTO tlj_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Musa aabaghila ati, “Hatabʼo muntu nʼomui oghu akubiika haa byokuliya ebi ku̱hi̱ki̱ya nkyambisi.” ");
INSERT INTO tlj_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Bhaatu bamui mu bantu aba baabhenga ku̱u̱ghu̱wa Musa, baabiika haa byokuliya ebi kandi nkyambisi baasanga biisuuyemu bi̱su̱ni̱ kandi bi̱nu̱nki̱ye. Musa aasaaliluwa na bantu aba. ");
INSERT INTO tlj_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Bu̱li̱ nkyambisi muntu aakumaani̱yagha byokuliya ebi akwetaaghisibuwa kandi musana ghwakasaakalagha, ebi̱ti̱ghaaye hansi binuunuuta. ");
INSERT INTO tlj_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Haa kilo kyamukaagha, bantu baakumaani̱yagha byokuliya bya milundi ebili, bu̱li̱ muntu aakumaani̱yagha jaaga ebili sya byokuliya ebikumala bilo bibili. Beebembeli̱ baa bantu baaghenda kandi baaghambila Musa. ");
INSERT INTO tlj_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Aabaghila ati, “Eki niikiyo Mukama aalaghiiye ati, ‘Munkiya ni kilo kya kuhuumula, kilo kya Sabhato ki̱hi̱ki̱li̱i̱ye kya Mukama. Nahabweki mukumaani̱ye byokuliya byona ebi mukubbala kwomeleli̱ya kedha kuteeka kuliya, ebi̱ku̱ti̱ghalʼo mubibiike kubiliya munkiya.’ ” ");
INSERT INTO tlj_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Bantu aba baabiika haa byokuliya ebi ku̱hi̱ki̱ya nkyambisi, ngoku Musa aabalaghiiye, tabyaghaghi̱ye kedha kubaamu bi̱su̱ni̱. ");
INSERT INTO tlj_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musa aaghila bantu aba ati, “Obwalo muliye byokuliya ebi nanga ni kilo kya Sabhato kya kulami̱ya Mukama. Obwalo tamukubona hansi byokuliya bbaa. ");
INSERT INTO tlj_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Bilo mukaagha bu̱li̱ wi̱i̱ki̱ mulakumaani̱yagha byokuliya, bhaatu haa kilo kyamusanju̱, kilo kya Sabhato, tabilabaaghʼo bbaa.” ");
INSERT INTO tlj_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Haa kilo kyamusanju̱, bamui mu bantu aba baaghenda kukumaani̱ya byokuliya, bhaatu bataasangayo kantu. ");
INSERT INTO tlj_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Mukama aaghila Musa ati, “Mu̱ku̱hi̱ki̱ya haa kubhenga kukwata bilaghilo byanje na ndaghikiililo syanje? ");
INSERT INTO tlj_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Mulole, si̱ye Mukama, ni̱i̱si̱ye naabahaaye kilo kya Sabhato, nanga haa kilo kyamukaagha nkubahaagha byokuliya bya bilo bibili, bu̱li̱ muntu aatalu̱ghagha mu ka yee haa kilo kyamusanju̱.” ");
INSERT INTO tlj_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Nahabweki bantu aba baahuumulaghe haa kilo kyamusanju̱. ");
INSERT INTO tlj_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Banai̱saaleeli̱ baaluka byokuliya ebi li̱i̱na maanu. Ekaba eli nga kasigho kati̱i̱ kanjelu kandi enuliliiye nga capati basi̱i̱ghi̱yʼo njoki. ");
INSERT INTO tlj_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa aaghila ati, “Mukama aalaghiiye ati, ‘Mubiike ki̱lo ebili sya maanu, mughibiikile baasukulu baanu, niikuwo babone byokuliya ebi naahaaye enu̱we kuliya mu elungu, obu naayagha enu̱we mu nsi ya Mi̱si̱li̱.’ ” ");
INSERT INTO tlj_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Musa aaghila Alooni̱ ati, “Okwate jaaga kandi otemu kilo ebili sya maanu, oghite mu maaso ghaa Mukama, ebiikuwe mu mijo yaanu yoona.” ");
INSERT INTO tlj_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Alooni̱ aata jaaga eghi mu maaso ghaa sandu̱u̱ku̱ ya ndaghaano, kuukalʼo, ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Banai̱saaleeli̱ baaliya maanu haabwa myaka maku̱mi̱ anaa, ku̱hi̱ki̱ya baki̱dhi̱ye haa mutaano ghwa nsi ya Kanaani̱ hambali baaghendagha kuukala. ");
INSERT INTO tlj_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Bwile obu Banai̱saaleeli̱ baakoleesi̱yagha jaaga ku̱pi̱i̱ma byokuliya byabo. Jaaga emui ekaba yengaane na ki̱lo ebili kandi jaaga eku̱mi̱ syasu̱li̱yagha dhebe emui.) ");
INSERT INTO tlj_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Ki̱bbu̱la kya Banai̱saaleeli̱ kyona kyalu̱gha mu elungu lya Si̱i̱ni̱, baghenda mbanalu̱gha mu ki̱i̱kalo kughenda mu kinji ngoku Mukama aabalaghiiye kandi baaghoona e Lefi̱di̱mu̱, bhaatu ki̱i̱kalo eki kikaba kitalimu maasi ghaa bantu kunuwa. ");
INSERT INTO tlj_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Bantu aba baatandika kutongana na Musa bati, “Otuhe maasi ghaa kunuwa.” Musa aabaghila ati, “Mukwete kutongana nanje nangaaki? Mukwete kulengesa Mukama bwaki?” ");
INSERT INTO tlj_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Bhaatu bantu aba eliyo lyabakwata kwonini kandi baatongana na Musa bati, “Waatu̱u̱hi̱ye mu nsi ya Mi̱si̱li̱, na baana baatu na bisolo byatu ku̱twi̱ti̱ya eliyo nangaaki?” ");
INSERT INTO tlj_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Musa aataaghila Mukama naaghila ati, “Bantu bani mbakolele ki? Bakubbala kumpuula mabaale.” ");
INSERT INTO tlj_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Mukama aaghila Musa ati, “Oghende mu maaso ghaa bantu aba oli na bamui mu beebembeli̱ baa Banai̱saaleeli̱. Oghende okwete mu ngalo yaawe mwi̱gho oghu waahuuye haa maasi ghaa Nailo. ");
INSERT INTO tlj_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Nkwemilila mu maaso ghaawe, haa kikuka kya mwena Holebbu. Ohuule kikuka eki, maasi ghaku̱lu̱ghamu ghaa bantu aba kunuwa.” Musa aahuula kikuka eki mu maaso ghaa beebembeli̱ baa Banai̱saaleeli̱ aba. ");
INSERT INTO tlj_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Musa aaluka ki̱i̱kalo eki li̱i̱na Masa kandi Meli̱ba, nanga Banai̱saaleeli̱ bakatongana na Musa kandi baalengesa Mukama mbaghila bati, “Mukama ali naatu kedha bbaa?” ");
INSERT INTO tlj_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Bameleeki̱ baasa kandi baalwana na Banai̱saaleeli̱ e Lefi̱di̱mu̱. ");
INSERT INTO tlj_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Musa aaghila Yosuwa ati, “Otukomelemu basaasa kandi mughende mulwane na Bameleeki̱ munkiya. Si̱ye nkwemilila haagu̱u̱li̱ ya keena nkwete mwi̱gho ghwa Luhanga mu ngalo yanje.” ");
INSERT INTO tlj_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yosuwa aakola ngoku Musa aamughambiiye kandi aalwana na Bameleeki̱. Musa, Alooni̱ na Hula baani̱i̱na haagu̱u̱li̱ ya keena. ");
INSERT INTO tlj_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Musa aakaamu̱ki̱yagha mukono ghuwe Banai̱saaleeli̱ baasi̱ngu̱lagha kandi naaghu̱su̱ndu̱ki̱ya, Bameleeki̱ baasi̱ngu̱lagha. ");
INSERT INTO tlj_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Bhaatu mikono ya Musa yaaluwakaka, nahabweki baamuleetela ebaale kandi aalisitamʼo. Alooni̱ na Hula, omui amwemilila haa luhande lumui na onji haa luhande lunji, baakala baamu̱ki̱i̱ye mikono yee ku̱hi̱ki̱ya musana ghu̱koti̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Nahabweki Yosuwa aahwelekeeleli̱ya mahe ghaa Bameleeki̱ na kihiyo. ");
INSERT INTO tlj_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Mukama aaghila Musa ati, “Ohandiike ebyabaayʼo bini mu kitabo, niikuwo bantu baakalaghe mbabiisuka kandi obisomele Yosuwa, nanga nku̱hwelekeeleli̱ya Bameleeki̱ boona munsi.” ");
INSERT INTO tlj_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Musa aakwela kyakuhongelʼo bihonguwa kandi aakiluka li̱i̱na ati, “Mukama niiye akumpaagha bu̱si̱ngu̱li̱.” ");
INSERT INTO tlj_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Musa aaghila ati, “Naalahila mu li̱i̱na lya Mukama! Mukama akweyongela kulwana na Bameleeki̱ bilo nʼebilo.” ");
INSERT INTO tlj_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Yetelo, mu̱hongi̱ wʼomu Mi̱di̱yaani̱, nkyame sya Musa, aaghu̱wa byona ebi Luhanga aakoleeye Musa na Banai̱saaleeli̱ kandi ngoku Mukama aahi̱ye Banai̱saaleeli̱ mu nsi ya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Bwile obu Yetelo, nkyame sya Musa, aatwala Jipola mukali̱ wa Musa, nanga Musa akaba amu̱ti̱ghi̱ye ewaa nkyame siye oghu, ");
INSERT INTO tlj_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","na batabani̱ be babili. Li̱i̱na lya omui baamughilaghamu Geli̱soomu̱, nanga Musa akaghila ati, “Naabaagha munamahanga mu nsi etali yaatu.” ");
INSERT INTO tlj_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Li̱i̱na lya onji baamughilaghamu Eli̱yeeja, nanga Musa akaghila ati, “Luhanga wa tita niiye akankoonela kandi anjuna kihiyo kya Falaaho.” ");
INSERT INTO tlj_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yetelo, nkyame siye, aasa na mukali̱ wa Musa na batabani̱ baa Musa babili, aamusanga mu elungu, hambali aabaagha aghooneeye haai na mwena ghwa Luhanga. ");
INSERT INTO tlj_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Yetelo aatuma muntu kughila Musa ati, “Si̱ye, nkyame syawe Yetelo, niibuwo naasa ewaawe, na mukali̱ waawe na batabani̱ baawe babili.” ");
INSERT INTO tlj_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Musa aatuwa kusangaana nkyame siye, aagomba kandi aaghuwa nkyame siye mu ki̱ku̱bha. Baalamukangani̱ya, du̱mbi̱ baataaha mu weema ya Musa. ");
INSERT INTO tlj_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musa aaghambila nkyame siye byona ebi Mukama aakoli̱yʼo Falaaho na Banami̱si̱li̱ haabwa Banai̱saaleeli̱. Aamughambila bijibu byona ebyababaayʼo mu kihanda kandi ngoku Mukama aabaju̱ni̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yetelo aadheedhuwa haabwa bintu bisemeeye byona ebi Mukama aakoleeye Banai̱saaleeli̱, kubajuna ku̱lu̱gha mu mukono ghwa Banami̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yetelo aaghila ati, “Mukama asi̱i̱mu̱we, oghu aabaju̱ni̱ye ku̱lu̱gha mu mukono ghwa Banami̱si̱li̱ na mukono ghwa Falaaho kandi oghu aacunguuye bantu be ku̱lu̱gha mu mukono ghwa Banami̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Endindi naamani̱ye ngoku Mukama asaai̱ye baaluhanga banji boona, nanga aaju̱ni̱ye bantu be ku̱lu̱gha mu banamyempanko baa Banami̱si̱li̱ abaababona-boni̱yagha.” ");
INSERT INTO tlj_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Yetelo nkyame sya Musa, aahongela Luhanga kihonguwa kyona kyokeei̱ye na bihonguwa binji. Alooni̱ na beebembeli̱ baa Banai̱saaleeli̱ baasa kuliya hamui na nkyame sya Musa mu maaso ghaa Luhanga. ");
INSERT INTO tlj_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Kilo ekyalabhi̱yʼo Musa aasitama ku̱twi̱la bantu misango kandi bantu baamilila bamweli̱ghi̱li̱i̱ye ku̱lu̱gha nkyambisi ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Obu nkyame sya Musa aaboone byona ebi Musa akwete kukolela bantu aba, aamughila ati, “Nkiki okwete kukolela bantu aba? Ositami̱ye wenkaha kandi bantu aba boona baamiliiye bakweli̱ghi̱li̱i̱ye ku̱lu̱gha nkyambisi ku̱hi̱ki̱ya lwagholo nangaaki?” ");
INSERT INTO tlj_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa aaghila nkyame siye ati, “Bantu aba bakwisagha ewanje kumanya ebi Luhanga akubbala ati bakole. ");
INSERT INTO tlj_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Bakaakubaagha bali na mpaka syabo, bakwisagha ewanje kubatwi̱lamu kandi kubaghambila ntu̱wamu na bilaghilo bya Luhanga.” ");
INSERT INTO tlj_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Nkyame sya Musa aamughila ati, “Eki okwete kukola takisemeeye. ");
INSERT INTO tlj_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Uwe na bantu abali naawe mukweluwakaki̱ya kandi mulimo oghu okwete kukola ghukuhingulaane, tookugubha kughukola wenkaha. ");
INSERT INTO tlj_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ontegheeleli̱ye endindi kandi ooghu̱we eki kukuhanuulila, Luhanga akuba naawe. Bantu aba balakabaagha bali na nsonga syabo, uwe osighambilaghe Luhanga. ");
INSERT INTO tlj_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Obeegheesi̱yaghe bilaghilo biye na ebi aalaghikiliiye. Oboolekaghe ngoku bali na kwetwalikani̱ya kandi ebi bali na kukola. ");
INSERT INTO tlj_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Okwetaaghisibuwa dhee mu bantu aba boona kukomamu basaasa abali na magheji, abahu̱ti̱i̱ye Luhanga, beesighibuwa kandi aboohi̱ye ngu̱ji̱. Bamui mu bantu aba babe beebembeli̱ baa bantu lu̱ku̱mi̱-lu̱ku̱mi̱, banji baa bantu ki̱ku̱mi̱-ki̱ku̱mi̱, banji baa bantu maku̱mi̱ ataano-ataano na banji baa bantu eku̱mi̱-eku̱mi̱. ");
INSERT INTO tlj_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Oleke basaasa aba batwi̱laghe bantu misango bwile bwona. Misango yamaani̱ haaliiyo baakuleetelagha, bhaatu misango nkee baghimalaghe bonkaha. Bantu aba bakuleka mulimo oghu ghukudhootele nanga bakuba mbakukoonela kughukola. ");
INSERT INTO tlj_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Nuwaakoli̱ye eki, ngoku Luhanga akulaghiiye, okugubha kukola mulimo oghu kandi bantu aba boona balakuukagha mu maka ghaabo na bu̱si̱nge.” ");
INSERT INTO tlj_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa aaghu̱wa nkyame siye kandi aakola byona ebi aamughambiiye. ");
INSERT INTO tlj_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Musa aakoma mu Banai̱saaleeli̱ basaasa abali na magheji, aabafoola beebembeli̱ baa bantu lu̱ku̱mi̱-lu̱ku̱mi̱, banji baa bantu ki̱ku̱mi̱-ki̱ku̱mi̱, banji baa bantu maku̱mi̱ ataano-ataano na banji baa bantu eku̱mi̱-eku̱mi̱. ");
INSERT INTO tlj_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Basaasa aba baatandika ku̱twi̱la bantu misango bwile bwona. Misango eghi ebasaaghi̱ye baaghileetelagha Musa, bhaatu misango nkee baaghi̱tu̱waghamu boonini. ");
INSERT INTO tlj_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Du̱mbi̱ Musa aalagha nkyame siye kandi nkyame siye oghu aakuuka ewe e ka. ");
INSERT INTO tlj_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Kilo kyʼoku̱du̱bha kya kweli̱ kwakasatu haanu̱ma ya Banai̱saaleeli̱ ku̱lu̱gha mu nsi ya Mi̱si̱li̱, baaki̱dha mu elungu lya Si̱naai̱. ");
INSERT INTO tlj_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Obu Banai̱saaleeli̱ baalu̱ghi̱ye Lefi̱di̱mu̱, baaghenda mu elungu lya Si̱naai̱ kandi baaghoona mu nti̱na ya mwena ghwa Si̱naai̱ oghu. ");
INSERT INTO tlj_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Musa aani̱i̱na haa mwena oghu ku̱bu̱gha na Luhanga. Mukama aabu̱gha na Musa ku̱lu̱gha mu mwena oghu ati, “Oghende kandi oghambile Banai̱saaleeli̱, baasukulu baa Yakobbo oti, ");
INSERT INTO tlj_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Mweboneeye enu̱we boonini ebi naakoli̱yʼo Banami̱si̱li̱ kandi ngoku naaheeki̱ye enu̱we ngoku kibebe kikuheekagha bwana bwakiyo mu mapapa kandi naabaleeta ewanje. ");
INSERT INTO tlj_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Nahabweki kaakuba mu̱mpu̱ti̱ya kandi mukwata ndaghaano yanje, mukuba bantu banje baa mbaghani̱ja mu bantu boona bʼomu nsi, nanga nsi yoona ni yanje. ");
INSERT INTO tlj_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Enu̱we mukuba bukama bwanje bwa bahongi̱ kandi ehanga li̱hi̱ki̱li̱i̱ye.’ Bighambo ebi haaliibiyo waaghenda kughambila Banai̱saaleeli̱.” ");
INSERT INTO tlj_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Nahabweki Musa aakota ku̱lu̱gha haa mwena, aabilikila beebembeli̱ baa Banai̱saaleeli̱ kandi aabaghambila bighambo byona ebi Mukama aamulaghiiye ku̱bu̱gha. ");
INSERT INTO tlj_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Bantu boona baakuukamu bati, “Tukukola byona ebi Mukama aabu̱ghi̱ye.” Du̱mbi̱ Musa aaghenda kandi aaghambila Mukama ebi bantu aba baabu̱ghi̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Mukama aaghila Musa ati, “Olole, nkwisa hambali oli mu kicu kikwataane, niikuwo bantu bagubhe ku̱u̱ghu̱wa ngoku nkwete ku̱bu̱gha naawe kandi baku̱hi̱ki̱li̱je bilo nʼebilo.” Du̱mbi̱ Musa aaghambila Mukama ebi bantu aba baabu̱ghi̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Mukama aaghila Musa ati, “Oghende hambali bantu aba bali, obaghambile beeyeli̱ye obwalo na munkiya kandi banaabi̱ye ngoye syabo, ");
INSERT INTO tlj_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","kweteekani̱li̱ja kilo kyakasatu. Haa kilo kyakasatu eki Mukama akwisa haa mwena Si̱naai̱ bantu boona banaloli̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ote mutaano kweli̱ghi̱i̱li̱li̱ya mwena oghu hambali bantu aba bakuhelela kwemilila kandi obaghile oti, ‘Mweghendeseleje kutani̱i̱na haa mwena oghu kedha ku̱ku̱ma haa nti̱na yaghuwo. Muntu weena oghu aku̱ku̱ma haa mwena oghu ali na kwitibuwa. ");
INSERT INTO tlj_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Muntu oghu ali na kuhuuluwa mabaale kedha kumulasa bimala kandi muntu nʼomui atamu̱ku̱mʼo. Kaakuba muntu aku̱ma haa mwena oghu, ali na kwitibuwa kandi kaakuba kisolo ki̱ku̱mʼo, kili na kwitibuwa.’ Nahabweki bantu bali na kulinda ku̱hi̱ki̱ya baaghu̱u̱ye elaka lya ki̱i̱di̱yo. Kaakuba baaghu̱wa elaka eli, du̱mbi̱ beebinge haai na mwena oghu.” ");
INSERT INTO tlj_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Niibuwo Musa aakoti̱ye ku̱lu̱gha haa mwena oghu, aaghenda hambali bantu aba bali, aabaghambila kweyeli̱ya kandi baanaabi̱ya ngoye syabo. ");
INSERT INTO tlj_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Musa aaghila bantu aba ati, “Mweteekani̱li̱je kilo kyakasatu kandi munalindiliiye kilo eki, atabʼo musaasa nʼomui oghu akulangaala na mukali̱.” ");
INSERT INTO tlj_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Kilo kyakasatu nkyambisi, nkubha yeetanuka kandi yaabbyoka, kicu kikwataane kyaboneka haa mwena kandi bantu baaghu̱wa elaka lyamaani̱ lya ki̱i̱di̱yo, bantu boona abaabaagha hambali baghooneeye baatandika kutukumila. ");
INSERT INTO tlj_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Musa aaya bantu aba hambali baghooneeye kughenda kusanga-sangaana na Luhanga, baaghenda kandi beemilila mu nti̱na ya mwena oghu. ");
INSERT INTO tlj_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Mwi̱ka ghwaswi̱ki̱la mwena ghwa Si̱naai̱, nanga Mukama akaasʼo ali mu mulilo. Mwi̱ka ghwatandika kucuuka haa mwena oghu nga ghwa mulilo ghwamaani̱. Mwena oghu ghwona ghwatandika kudhinga-dhingila kimui. ");
INSERT INTO tlj_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Elaka lya ki̱i̱di̱yo eki lyakeeyongelagha kuba lyamaani̱, Musa abu̱gha kandi Luhanga aamukuukamu nʼelaka nga lya nkubha. ");
INSERT INTO tlj_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Mukama aasu̱ndu̱ka haagu̱u̱li̱ ya mwena ghwa Si̱naai̱ kandi aabilikila Musa ku̱ni̱i̱na haagu̱u̱li̱ ya mwena oghu kandi Musa aani̱i̱nayo. ");
INSERT INTO tlj_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Mukama aaghila Musa ati, “Okote kandi oteelelele bantu aba kutaghuluka mutaano oghu kulengʼo kubona si̱ye Mukama, nanga bakani̱ye mu ebo baku̱ku̱wa. ");
INSERT INTO tlj_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Bahongi̱ bonkaha niibo bakugubha kwisa haai na Mukama, bhaatu badu̱bhe beeyeli̱ye, niikuwo ntabafubila.” ");
INSERT INTO tlj_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa aaghila Mukama ati, “Bantu aba tabakwisa haa mwena Si̱naai̱ ghuni bbaa, nanga okatuteelelela oti, ‘Mute mutaano kweli̱ghi̱i̱li̱li̱ya mwena oghu kandi mughufoole ghu̱hi̱ki̱li̱i̱ye.’ ” ");
INSERT INTO tlj_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Mukama aaghila Musa ati, “Okote kandi okuuke hani na Alooni̱. Bhaatu otasi̱i̱mi̱lani̱ya bahongi̱ na bantu aba kughuluka mutaano oghu kandi kwisa hambali Mukama ali, nanga abafubila.” ");
INSERT INTO tlj_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Musa aakota hambali bantu aba bali kandi aabaghambila ebi Mukama aabu̱ghi̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Luhanga aabu̱gha bighambo bini byona. ");
INSERT INTO tlj_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Aaghila ati, “Ni̱i̱si̱ye Mukama Luhanga waawe, oghu akakuuya mu nsi ya Mi̱si̱li̱ hambali waabaagha mu̱syana. ");
INSERT INTO tlj_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Otaliba na baaluhanga banji kuuyʼo si̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Otalyekolela kisasani̱ kya mulingo ghwona, eki̱su̱si̱ye kintu kyona ekili mu mwanya, hansi, kedha mu maasi. ");
INSERT INTO tlj_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Otali̱bi̱teeleli̱ya kedha kubilami̱ya, nanga si̱ye Mukama Luhanga waawe, ndi Luhanga wʼetima. Nkufubilagha baana haabwa bibhi bya beesebo ku̱hi̱ka haa buusukulu bwakasatu na bwakanaa bwa mujo ghwa bantu abanjoi̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Bhaatu nkwolekagha kukunda kwamaani̱ haa nku̱mi̱ na nku̱mi̱ sya baku̱ndi̱ye si̱ye kandi bahu̱ti̱ya bilaghilo byanje. ");
INSERT INTO tlj_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Otalilahila busa li̱i̱na lya Mukama Luhanga waawe, nanga Mukama akufubila weena oghu aku̱koleesi̱ya kubhi li̱i̱na liye. ");
INSERT INTO tlj_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Oosukaghe kilo kya Sabhato kandi okilinde kili ki̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Oli na bilo mukaagha bya kukola milimo yaawe yoona, ");
INSERT INTO tlj_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","bhaatu kilo kyamusanju̱ ni kilo kya Sabhato kya Mukama Luhanga waawe. Otalikola mulimo ghwona haa kilo eki, uwe kedha mutabani̱ waawe kedha muhala waawe, mu̱heeleli̱ya waawe wabusaasa kedha wabukali̱, bisolo byawe, kedha munamahanga oghu aakaaye naawe. ");
INSERT INTO tlj_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Mu bilo mukaagha Mukama akahanga eghulu na nsi, nanja na byona ebilimu, haa kilo kyamusanju̱ aahuumula. Niikiyo kyaleki̱ye Mukama aaha mu̱gi̱sa kilo kya Sabhato eki kandi aakifoola ki̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Ohu̱ti̱yaghe so waawe na njoko waawe, niikuwo omale bwile bukani̱ye mu nsi eghi Mukama Luhanga waawe akukuha. ");
INSERT INTO tlj_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Otaliita. ");
INSERT INTO tlj_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Otali̱syana. ");
INSERT INTO tlj_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Otaliibha. ");
INSERT INTO tlj_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Otalihabi̱i̱li̱li̱ya muliilanuwa waawe. ");
INSERT INTO tlj_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Otalyeghomba numba ya muliilanuwa waawe. Otalyeghomba mukali̱ wa muliilanuwa waawe, kedha mu̱heeleli̱ya wee wabukali̱ kedha wabusaasa, nte yee kedha ndogooi̱ yee, kedha kintu kyona kya muliilanuwa waawe.” ");
INSERT INTO tlj_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Obu bantu baaboone ngoku nkubha ekwete kwetanuka kandi kubbyoka, mbaaghu̱wa elaka lya ki̱i̱di̱yo kandi mbaabona ngoku mwi̱ka ghukwete kucuuka haa mwena, boobaha kandi baatandika kutukumila. Beemilila hambali haseli̱ye ");
INSERT INTO tlj_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","kandi baaghila Musa bati, “Uwe obu̱ghe naatu, tu̱ku̱tegheeleli̱ya. Bhaatu otaleka Luhanga naabu̱gha naatu, tu̱ku̱ku̱wa.” ");
INSERT INTO tlj_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa aaghila bantu aba ati, “Muleka kwobaha, nanga Luhanga aasi̱ye kubalengesa, niikuwo muukale mumwobahi̱ye kandi mutagubha ku̱si̱i̱sa.” ");
INSERT INTO tlj_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Bantu aba baakala beemiliiye hambali haseli̱ye, Musa naaneebinga kicu kikwataane hambali Luhanga aabaagha. ");
INSERT INTO tlj_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Mukama aaghila Musa ati, “Oghile Banai̱saaleeli̱ oti, ‘Mwaboone enu̱we boonini ngoku naabu̱ghi̱ye naanu ku̱lu̱gha mu eghulu. ");
INSERT INTO tlj_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Mutalyekolela bisasani̱ bya baaluhanga baakulami̱ya baa siliva kedha feeja mu ki̱i̱kalo kya kulami̱ya si̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘Munkwelele kyakuhongelʼo bihonguwa kya etaka kandi mukihongelaghʼo bihonguwa byona byokeei̱ye byanu na bihonguwa bya bu̱si̱nge bya ntaama na nte syanu. Mu ki̱i̱kalo kyona eki nkukomamu enu̱we kundami̱li̱yamu, ndabaasaghamu kandi mbahe mu̱gi̱sa. ");
INSERT INTO tlj_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Kaakuba obbala kunkwelela kyakuhongelʼo bihonguwa kya mabaale, otakoleesi̱ya kyoma kyona kwatakaki̱ya mabaale agha. Kaakuba okola eki, kyakuhongelʼo bihonguwa eki kikuba kitahi̱ki̱ye enu̱we ku̱ki̱koleesi̱ya kundami̱ya. ");
INSERT INTO tlj_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Mutani̱i̱nagha haa madaala ku̱hi̱ka haa kyakuhongelʼo bihonguwa kyanje, niikuwo muntu atabona muhina ghwanu.’ ” ");
INSERT INTO tlj_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Bini niibiyo bilaghilo oli na kuteelʼo Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Kaakuba oghula Muhebbulaayo kuba mu̱syana waawe, aku̱heeleli̱yaghe haabwa myaka mukaagha. Bhaatu mwaka ghwamusanju̱ omuleke aghende atakusasuuye kantu koona. ");
INSERT INTO tlj_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Kaakuba aasa enkaha, aghende enkaha. Kaakuba aasa asweye, aghende na mukali̱ wee. ");
INSERT INTO tlj_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Kaakuba mukama wee amuha mukali̱ kandi mu̱syana oghu amu̱byalʼo baana baabusaasa kedha baabukali̱, mukali̱ oghu na baana aba babe baa mukama wee, bhaatu musaasa oghu ali na kughenda enkaha. ");
INSERT INTO tlj_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Bhaatu kaakuba mu̱syana oghu abu̱gha bbeni̱-bbeni̱ ati, ‘Nku̱ndi̱ye mukama wanje, mukali̱ wanje na baana banje, tambali̱ye kuleka kuba mu̱syana wee,’ ");
INSERT INTO tlj_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","du̱mbi̱ mukama wee amutwale hambali bakulami̱li̱yagha Luhanga. Amwemi̱li̱li̱ye haai na lwighi kedha bi̱ji̱ngi̱li̱jo bya lwighi lwa numba eghi, amutobhole kutui na ngilaghilo kandi afooke mu̱syana wee bilo nʼebilo. ");
INSERT INTO tlj_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Kaakuba musaasa aghu̱li̱ya muhala wee nga mu̱syana, mwana wabukali̱ oghu taali na bughabe ku̱lu̱gha ewaa mukama wee nga mu̱syana wabusaasa. ");
INSERT INTO tlj_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Kaakuba mwana wabukali̱ oghu atakola ebi̱dheedhi̱ye mukama wee, oghu aabbalagha kumuswela, aleke ese wa mwana wabukali̱ oghu amucungule. Taali na bughabe ku̱mu̱ghu̱li̱ya banamahanga, nanga akuba amu̱koli̱ye kubhi. ");
INSERT INTO tlj_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Bhaatu kaakuba mukama wa mu̱syana oghu amuha mutabani̱ wee kumuswela, ali na kumutwalikani̱ya nga muhala wee. ");
INSERT INTO tlj_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Kaakuba musaasa oghu aswela mukali̱ onji, atakeehi̱ya haa byokuliya na ngoye ebi aahaagha mukali̱ wee wʼoku̱du̱bha kandi ataleka kulangaala naye. ");
INSERT INTO tlj_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Kaakuba musaasa oghu atamukolela bintu bisatu ebi, mu̱syana wabukali̱ oghu ali na bughabe kughenda kandi taakwetaaghisibuwa kusasula kantu. ");
INSERT INTO tlj_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Weena oghu akuhuula muntu kandi amwita, naye aatibuwe. ");
INSERT INTO tlj_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Kaakuba muntu oghu aata muunakiye atakighendeleeye, bhaatu buli butanduwa, nkukoma ki̱i̱kalo hambali muntu oghu alaalukilagha kujuna bwomi̱i̱li̱ buwe. ");
INSERT INTO tlj_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Bhaatu kaakuba muntu alu̱mba muunakiye kandi amwita akighendeleeye, nankabha aalukila haa kyakuhongelʼo bihonguwa kyanje, omuuyʼo kandi omwite. ");
INSERT INTO tlj_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Weena oghu akuhuula ese wee kedha ni̱na wee, naye ali na kwitibuwa. ");
INSERT INTO tlj_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Weena oghu akwibha muntu kughenda ku̱mu̱ghu̱li̱ya kedha kumufoola mu̱syana, oghu aakoli̱ye kintu eki ali na kwitibuwa. ");
INSERT INTO tlj_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Weena oghu akukiina ese wee kedha ni̱na wee ali na kwitibuwa. ");
INSERT INTO tlj_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Kaakuba bantu baba mbatongana, omui ahuula muunakiye ebaale kedha kikonde, oghu baahuuye ataku̱wa bhaatu aakala alangaaye haa bulili, ");
INSERT INTO tlj_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","oghu baahuuye naatandi̱ki̱ye kuumuka kandi kutuwa mu numba akwete nkoni̱, oghu aamuhuuye ataba na musango, bhaatu amusasule haabwa bwile obu aamali̱ye haa bulili kandi amuloleelele ku̱hi̱ki̱ya aki̱li̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Kaakuba muntu ahuula na mwi̱gho mu̱syana wee wabusaasa kedha wabukali̱ kandi mu̱syana oghu amu̱kwi̱la mu ngalo, muntu oghu ali na kufubiluwa. ");
INSERT INTO tlj_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Bhaatu kaakuba mu̱syana oghu amala kilo kimui kedha bibili du̱mbi̱ aku̱wa, mukama wee atafubiluwa, nanga aafeeleuwe oghu aaghu̱li̱ye na sente siye. ");
INSERT INTO tlj_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Kaakuba basaasa baba mbalwana, omui ahuula mukali̱ aku̱li̱i̱ye kandi etundu li̱lu̱ghamu, bhaatu mukali̱ oghu ataba kubhi, oghu aamuhuuye ali na kusasula fai̱ni̱ yoona eghi bali̱i̱ wa mukali̱ oghu aku̱mu̱twi̱la, bhaatu ngoku bacu̱ baatu̱u̱yemu. ");
INSERT INTO tlj_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Bhaatu mukali̱ oghu kaakuba ahutaala kubhi kandi aku̱wa, musaasa oghu naye aatibuwe, ");
INSERT INTO tlj_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","oghu akuuyamu muunakiye li̱i̱so, omuuyemu li̱i̱so, oghu akumukobha li̱i̱no, omukobhe li̱i̱no, oghu akumujombʼo mukono, omujombʼo mukono, oghu akumujombʼo kighele, omujombʼo kighele, ");
INSERT INTO tlj_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","oghu aku̱mwoki̱ya, omwoki̱ye, oghu akumuhutaali̱ya, omuhutaali̱ye, oghu akumuhuula kubhi, omuhuule kubhi. ");
INSERT INTO tlj_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Kaakuba muntu ahuula li̱i̱so mu̱syana wee wabusaasa kedha wabukali̱ kandi litobhoka, ali na kuha mu̱syana oghu bughabe kughenda, nanga eghi niiyo nsasu̱li̱ ya li̱i̱so eli. ");
INSERT INTO tlj_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Kaakuba muntu ahuula mu̱syana wee wabusaasa kedha wabukali̱ kandi amukobha li̱i̱no, ali na kuha mu̱syana oghu bughabe kughenda, nanga eghi niiyo nsasu̱li̱ ya li̱i̱no eli. ");
INSERT INTO tlj_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Kaakuba nte ehuumila na mahembe ghaayo musaasa kedha mukali̱ kandi emwita, nte eghi muli na kughihuula mabaale eku̱we kandi nyama syayʼo mutasiliya kandi mutafubilagha mukama wayo. ");
INSERT INTO tlj_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Bhaatu nte niyaabaaye neekuhuumilagha bantu, baaghambila mukama wayo, bhaatu abhenga kughiboha, kaakuba ehuumila musaasa kedha mukali̱ kandi emwita, nte eghi baghihuule mabaale eku̱we kandi mukama wayo aatibuwe. ");
INSERT INTO tlj_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Bhaatu kaakuba nganda sya muntu oghu nte eghi yaati̱ye basi̱i̱mi̱lani̱ya mukama wayo kusasula fai̱ni̱ kujuna bwomi̱i̱li̱ buwe, ali na kusasula syona esi baamughambiiye. ");
INSERT INTO tlj_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Kaakuba nte eghi ehuumila mutabani̱ kedha muhala wa muntu kandi emwita, mukama wayo afubiluwe ngoku kilaghilo kini kikulaghila. ");
INSERT INTO tlj_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Kaakuba nte ehuumila mu̱syana wabusaasa kedha wabukali̱ kandi emwita, mukama wa nte eghi ali na kusasula mukama wa mu̱syana oghu bi̱twi̱ke maku̱mi̱ asatu bya siliva kandi nte eghi baghihuule mabaale eku̱we. ");
INSERT INTO tlj_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Muntu naanaahi̱ye haa ki̱i̱na eki baswi̱ki̱yʼo kedha alima ki̱i̱na bhaatu ataki̱swi̱ki̱la, nte kedha ndogooi̱ yeegengamu, ");
INSERT INTO tlj_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","mukama wa ki̱i̱na eki ali na kusasula kisolo eki. Ali na kuha mukama wakiyo sente kandi mukama wa ki̱i̱na eki atwalaghe mu̱ku̱ ghwa kisolo ekyaku̱u̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Kaakuba nte ya muntu ehuumila nte ya muntu onji kandi eghiita, nte eghi bantu aba bombi baghi̱ghu̱li̱ye enaakaaye kandi sente esi̱ku̱lu̱ghamu bu̱li̱ omui atwale kimui kyakabili kyasiyʼo na eghi yaaku̱u̱ye bu̱li̱ omui atwale kimui kyakabili kya nyama esi. ");
INSERT INTO tlj_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Bhaatu nte eghi mbaabaaye baghimani̱ye ngoku ekuhuumilagha kandi mukama wayo abhenga kughiboha, nte eghi yaaku̱u̱ye asasulemu nte enji eghi enaakaaye kandi atwale eghi yaaku̱u̱ye.” ");
INSERT INTO tlj_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Kaakuba muntu aabha nte kedha ntaama, aghiita kedha aghi̱ghu̱li̱ya, nte eghi asasulemu nte etaano kandi ntaama eghi asasulemu ntaama enaa. ");
INSERT INTO tlj_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Kaakuba baakwata musuma naahenda numba mukilo kandi bamuhuula akwi̱lʼo, muntu oghu aamwi̱ti̱ye taali na musango ghwa bu̱ji̱ndi̱, ");
INSERT INTO tlj_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","bhaatu bwile mbwabaaye bukeeye, oghu aamwi̱ti̱ye ali na musango ghwa bu̱ji̱ndi̱. Musuma oghu ali na kusasula bintu ebi aabhi̱ye. Kaakuba aba atali nʼeki akusasula bamu̱ghu̱li̱ye nga mu̱syana kusasula haabwa busuma buwe. ");
INSERT INTO tlj_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Kaakuba bamusanga na kisolo eki aabhi̱ye kinaakaaye, nankabha eba eli nte, ndogooi̱ kedha ntaama, akisasulemu milundi ebili. ");
INSERT INTO tlj_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Kaakuba muntu aba naali̱i̱si̱li̱ya bisolo biye mu musili ghuwe kedha mu bilimuwa biye kandi aleka bisolo ebi bighenda mu musili ghwa muntu onji biliya bilimuwa biye, ali na kuuya mu musili ghuwe bilimuwa bisemeeye kwonini abisasule muntu oghu. ");
INSERT INTO tlj_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Kaakuba muntu atu̱mi̱ka mulilo mu kisaka kiye, ghutuwamu kandi ghwoki̱ya ngano eghi balu̱ndi̱ye kedha eghi eneemiliiye, oghu aaghu̱tu̱mi̱ki̱ye ali na kusasulamu bilimuwa ebyabhi̱i̱hi̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Kaakuba muntu aha muliilanuwa wee sente kedha bintu kumubiikila biyo kulungi kandi babiibha mu numba ya muliilanuwa wee oghu, mbaakwete musuma oghu, ali na kubisasulamu milundi ebili. ");
INSERT INTO tlj_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Bhaatu musuma oghu bataamukwete, oghu aabaagha abi̱i̱ki̱ye bintu ebi bamutwalaghe mu ki̱i̱kalo hambali bakulami̱li̱yagha Luhanga kandi alahilaghe ngoku ataabhi̱ye bintu bya muliilanuwa wee. ");
INSERT INTO tlj_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Kaakuba bantu babili baba mbatongana haabwa bintu nga nte, ndogooi̱, ntaama, ngoye kedha kintu kyona ekyabu̱li̱ye kandi bu̱li̱ omui aghila ati, “Kintu eki nkyanje.” Bantu aba bombi babatwale hambali bantu bakulami̱li̱yagha Luhanga. Mu̱cu̱ atu̱wemu musango oghu kandi oghu ghu̱ku̱si̱nga, asasule muunakiye milundi ebili. ");
INSERT INTO tlj_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Kaakuba muntu aha muliilanuwa wee ndogooi̱, nte, ntaama kedha kisolo kinji kyona kumubiikila kiyo, bhaatu ki̱ku̱wa kedha kihutaala kedha muntu akitwala batamuboone, ");
INSERT INTO tlj_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","bombi bali na kughenda hambali bantu bakulami̱li̱yagha kandi oghu aabaagha aki̱bi̱i̱ki̱ye alahile aamu̱ki̱i̱ye mikono mu maaso ghaa Mukama ngoku ataaki̱i̱bhi̱ye. Mukama wa kisolo eki ali na ku̱si̱i̱ma eki muunakiye aalahiiye kandi atakisasulamu. ");
INSERT INTO tlj_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Bhaatu kaakuba bamwibhʼo kisolo eki, asasule mukama wakiyo. ");
INSERT INTO tlj_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Kaakuba kinyama kya mu kisaka kiita kisolo eki, muntu oghu aleete ebyati̱ghaayʼo nga buukai̱so kandi atasasulamu kisolo eki kinyama kyati̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Kaakuba muntu omba kisolo kya muliilanuwa wee kandi kihutaala kedha ki̱mu̱kwi̱lʼo haanu̱ma ya kukiiya ewaa mukama wakiyo, ali na kukisasulamu. ");
INSERT INTO tlj_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Kaakuba kihutaala kedha ki̱ku̱wa mukama wakiyo haliyo, oghu akyombi̱ye taali na kukisasulamu. Mbaabaaye bakipangi̱si̱i̱ye kukola mulimo, asasule muhendo oghu baabaagha balaghaane. ");
INSERT INTO tlj_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Kaakuba musaasa asoona-soona mwana wabukali̱ oghu atamani̱ye basaasa kandi oghu batalu̱ghi̱ye alangaala naye, ali na ku̱mu̱lu̱gha kandi amuswele. ");
INSERT INTO tlj_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Kaakuba ese wa mwana wabukali̱ oghu abhenga kumuha musaasa oghu kumuswela, musaasa oghu ali na kusasula ndu̱ghi̱ yoona eghi bakusasulilagha haabwa mwana wabukali̱ atamani̱ye basaasa. ");
INSERT INTO tlj_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Mukali̱ weena oghu alafookagha mu̱ku̱mu̱ omwitaghe. ");
INSERT INTO tlj_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Muntu weena oghu alalangaalagha na kisolo omwitaghe. ");
INSERT INTO tlj_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Muntu weena oghu alahongelagha luhanga onji, mu ki̱i̱kalo kya Mukama omwitaghe. ");
INSERT INTO tlj_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Mutalikola kubhi munamahanga kedha kumubona-boni̱ya, nanga naanu mukaba muli banamahanga mu nsi ya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Mutalibona-boni̱ya mu̱kwi̱si̱ya kedha nku̱u̱bbi̱. ");
INSERT INTO tlj_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Kaakuba mubakola kubhi kandi bandiliilila kubakoonela, majima nku̱u̱ghu̱wa kulila kwabo. ");
INSERT INTO tlj_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Nkusaaliluwa naanu kandi nkubaata na kihiyo. Bakali̱ baanu bakufooka bakwi̱si̱ya kandi baana baanu bakuba nku̱u̱bbi̱. ");
INSERT INTO tlj_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Kaakuba oha ebanja lya sente omui mu bantu banje banaku, otaghila oti akuteelʼo maghobo nga bantu abakuhaagha mabanja ghaa sente kubateelʼo maghobo. ");
INSERT INTO tlj_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Kaakuba otwala kooti̱ ya muliilanuwa waawe nga musimbo haabwa ebanja waamuhaaye, omu̱ku̱u̱ki̱li̱ye yo musana ghutakakoti̱ye, ");
INSERT INTO tlj_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","nanga kikugubha kuba kyakweswi̱ka kyonkaha eki ali nakiyo. Buuye akugubha ati̱ya kughwesaghila ateeswi̱ki̱ye? Muntu oghu kaakuba andiliilila kumukoonela, nku̱mu̱u̱ghu̱wa, nanga ndi wa kisa. ");
INSERT INTO tlj_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Otali̱bu̱ghʼo kubhi Luhanga kedha kukiina mu̱lemi̱ waanu. ");
INSERT INTO tlj_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Otakeesekeleluwagha kumpongela haa bilimuwa byawe ebi weeleei̱ye kedha vi̱i̱ni̱ eghi elu̱ghi̱ye mu bi̱ghu̱ma byawe. “Ompaaghe baana baawe baabusaasa mi̱li̱ghaaso. ");
INSERT INTO tlj_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ompaaghe dhee mu̱li̱ghaaso ghwa nte na ntaama syawe. Bhaatu kisolo eki kiikalaghe na ni̱naakiyo haabwa bilo musanju̱, haa kilo kyamunaanaa okimpaaghe. ");
INSERT INTO tlj_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Muli na kuba bantu banje bahi̱ki̱li̱i̱ye. Nahabweki mutaliliya kisolo kyona eki kinyama kya mu kisaka ki̱i̱ti̱ye. Mukikubilaghe mbuwa.” ");
INSERT INTO tlj_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Otaliha makulu ghaa bisubha kedha kukoonela muntu mubhi nooha buukai̱so obutali bwamajima. ");
INSERT INTO tlj_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Obu̱ghaghe majima mu kooti̱, nankabha bantu banji boona baba abatali beesighibuwa kandi abatabbali̱ye bwengani̱ja. ");
INSERT INTO tlj_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Otaghilila kisa munaku mamu̱twi̱la musango nanga eye kuba munaku. ");
INSERT INTO tlj_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Kaakuba osanga nte kedha ndogooi̱ ya ngi̱ghu̱ yaawe neeghenda kubula, omutwalileyo. ");
INSERT INTO tlj_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Kaakuba obona ndogooi̱ ya muntu oghu akwohi̱ye yeegengi̱ye hansi na bintu ebi eheeki̱ye, otaghi̱ti̱ghʼo, bhaatu omukoonele ku̱ghi̱i̱mu̱ki̱ya. ");
INSERT INTO tlj_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Mu kooti̱ otabhenga ku̱twi̱la munaku musango mu bwengani̱ja. ");
INSERT INTO tlj_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Otalinyegheelela muntu musango ghwa bisubha kandi otali̱twi̱la musango ghwa ku̱ku̱wa muntu oghu atali nʼeki asobeei̱ye kandi ahi̱ki̱li̱i̱ye, nanga weena oghu akukola kintu ki̱bhi̱i̱hi̱ye eki nkumufubila. ");
INSERT INTO tlj_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Otali̱si̱i̱ma ngu̱ji̱ nanga ngu̱ji̱ ekuughalagha maaso muntu wa magheji, oghu ali na bwengani̱ja kandi eleka atwi̱la kubhi muntu musango. ");
INSERT INTO tlj_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Otalikola kubhi munamahanga. Mumani̱ye eki kuba munamahanga kikumani̱i̱si̱ya, nanga naanu mukaba muli banamahanga mu nsi ya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Mu myaka mukaagha ohelaghe bilimuwa mu misili yʼomu nsi yaawe kandi okesaghe ebyeli̱yemu. ");
INSERT INTO tlj_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Bhaatu mu mwaka ghwamusanju̱ mutakolagha mu misili yaanu. Bilimuwa mbyatooyemu mubilekele banaku kubiliya. Bilimuwa binji mbyati̱ghaayemu mubilekele binyama byʼomu kisaka kubiliya. Mulekaghe dhee misili yaanu ya mi̱jaabbi̱i̱bbu̱ na biti oli̱va. ");
INSERT INTO tlj_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Oli na bilo mukaagha bya kukola milimo yaawe, bhaatu kilo kya musanju̱ ohuumulaghe. Nte yaawe na ndogooi̱ yaawe nabiyo dhee bihuumulaghe. Mutabani̱ wa mu̱syana waawe wabukali̱ na munamahanga abaakaaye naawe nabo bahuumulaghe. ");
INSERT INTO tlj_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Mweghendeseleje kukwata byona ebi naabaghambiiye. Mutalilami̱ya baaluhanga banji kedha ku̱ku̱mi̱ya mali̱i̱na ghaabo na kanu̱wa kaanu. ");
INSERT INTO tlj_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Okolaghe bi̱ghenu̱ bisatu bu̱li̱ mwaka ku̱mpu̱ti̱ya. ");
INSERT INTO tlj_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Okolaghe Ki̱ghenu̱ kya Migaati̱ Etalimu Ki̱tu̱mbi̱so ngoku naakulaghiiye. Oliyaghe migaati̱ etalimu ki̱tu̱mbi̱so haabwa bilo musanju̱ mu bwile bwakiyo bwonini mu kweli̱ kwa Abi̱bu̱, nanga mu kweli̱ oku niibuwo waalu̱ghi̱ye Mi̱si̱li̱. “Hatalibʼo muntu nʼomui oghu akwisa ewanje atali na kantu. ");
INSERT INTO tlj_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Okolaghe Ki̱ghenu̱ kya Kukesa kya mughanulo ghwa ebi waakoli̱ye kandi weeleei̱ye mu misili yaawe. “Okolaghe dhee Ki̱ghenu̱ kya Kumaliilila Kukesa mu bwile olabaagha noomala kukesa, haanu̱ma ya kukumaani̱ya bilimuwa byawe ku̱lu̱gha mu misili yaawe. ");
INSERT INTO tlj_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Bu̱li̱ mwaka basaasa boona baasaghe milundi esatu mu maaso ghaa Mukama Luhanga. ");
INSERT INTO tlj_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Otampongelagha saghama ya kihonguwa kyanje na migaati̱ elimu ki̱tu̱mbi̱so, kedha kubiika bisabu̱ bya ki̱ghenu̱ kyanje ku̱hi̱ki̱ya nkyambisi. ");
INSERT INTO tlj_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Oleetaghe mughanulo ghwa bilimuwa byawe mu numba ya Mukama Luhanga waawe. “Kyana kya mbu̱li̱ otali̱ki̱teeki̱ya mati̱i̱ti̱ ghaa ni̱naakiyo. ");
INSERT INTO tlj_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Olole, nkukutumila malai̱ka oghu akukuhikila mu kihanda kandi kukutwala mu ki̱i̱kalo eki naakuteekani̱li̱i̱je. ");
INSERT INTO tlj_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Omu̱tegheeleli̱ye bhyani, ohu̱ti̱ye elaka liye kandi otamujeemela nanga taakukughanila bikoluwa byawe bi̱bhi̱i̱hi̱ye, nanga ni̱i̱si̱ye naamu̱tu̱mi̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Kaakuba weeghendeseleja ku̱hu̱ti̱ya elaka liye kandi okola byona ebi nku̱bu̱gha, nkuba ngi̱ghu̱ ya ngi̱ghu̱ syawe kandi nkulwana na abakulwana naawe. ");
INSERT INTO tlj_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Malai̱ka wanje akaakukuhikila kandi naaku̱ki̱dhi̱ya mu nsi ya Bamooli̱, Bahi̱ti̱, Bapeleeji̱, Banakanaani̱, Bahi̱vi̱ na Bayebu̱si̱, nku̱hwelekeeleli̱ya bantu aba. ");
INSERT INTO tlj_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Otali̱teeleli̱ya baaluhanga baabo kedha kubaheeleli̱ya kedha kukola ebi bantu aba bakukolagha, bhaatu obahwelekeeleli̱ye kandi ohende mpaghi sya baaluhanga baabo. ");
INSERT INTO tlj_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Olami̱ye Mukama Luhanga waawe, akukuha mu̱gi̱sa otunge byokuliya na maasi kandi akukulinda kutalwala. ");
INSERT INTO tlj_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Mu nsi yaawe taakubaamu mukali̱ oghu etundu li̱ku̱lu̱ghamu kedha ngumba, nkuleka ookalemu bwile bukani̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Nkuleka bantu bʼomu mahanga agha bakwobahe otakaki̱dhi̱yeyo, nkuta butaaghu̱wana mu bantu aba kandi nkuleka ngi̱ghu̱ syawe syona sikuuluke. ");
INSERT INTO tlj_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Nkutuma minkebe kukuhikila kandi kubhinga Bahi̱vi̱, Banakanaani̱ na Bahi̱ti̱ noonaghenda. ");
INSERT INTO tlj_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Tankuleka obhingemu bantu aba mu mwaka ghumui, nanga nsi eti̱ghala eli elungu elitalimu kantu kandi binyama byʼomu kisaka bikanamu kusaali̱ya uwe. ");
INSERT INTO tlj_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Nkuleka obhingemu bantu aba bukee bukee, ku̱hi̱ki̱ya okani̱ye kandi otwete nsi eghi. ");
INSERT INTO tlj_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Nkuta mitaano yaawe ku̱lu̱gha haa Nanja Mutuku ku̱hi̱ka haa nanja ya Bafi̱li̱si̱ti̱ kandi ku̱lu̱gha mu elungu ku̱hi̱ka haa maasi Efulaati̱. Nkuta mu mukono ghwawe bantu abaakaaye mu nsi eghi kandi okubabhingamu. ");
INSERT INTO tlj_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Otalikola ndaghaano na bantu aba kedha na baaluhanga baabo. ");
INSERT INTO tlj_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Bantu aba bataakala mu nsi yaawe nanga bakuleka osi̱i̱se ewanje. Kaakuba olami̱ya baaluhanga baabo, majima kikukufookela ki̱ki̱ya.” ");
INSERT INTO tlj_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Mukama aaghila Musa ati, “Oni̱i̱ne haa mwena hambali ndi, uwe na Alooni̱, Nadaabbu, Abbi̱hu̱ na bengei̱ nsanju̱ baa I̱saaleeli̱, mundami̱ye munali hambali haseli̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Musa nuuwe wenkaha okwebinga Mukama, bhaatu banji baakale hambali haseli̱ye kandi bantu baa I̱saaleeli̱ bataasa haa mwena.” ");
INSERT INTO tlj_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Musa aaghenda kandi aaghambila bantu bighambo byona ebi Mukama aabu̱ghi̱ye nʼebi aalaghiiye. Bantu aba boona baakuukamu bati, “Byona ebi Mukama aabu̱ghi̱ye tukubikola.” ");
INSERT INTO tlj_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Musa aahandiika bighambo byona ebi Mukama aabu̱ghi̱ye. Aamuka nkyambisi cu̱i̱ kandi aakwela kyakuhongelʼo bihonguwa mu nti̱na ya mwena oghu. Aasimbʼo mpaghi sya mabaale eku̱mi̱ nʼebili kusighikila haa ntu̱la eku̱mi̱ nʼebili sya I̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Aatuma bamui mu batabhana baa Banai̱saaleeli̱ kuhonga bihonguwa byona byokeei̱ye kandi kuhonga ntu̱u̱li̱ ya nte nga bihonguwa bya bu̱si̱nge ewaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musa aata kimui kyakabili kya saghama ya bisolo ebi mu bibindi kandi kimui kyakabili kyayʼo aakimisanga haa kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Aakwata kitabo kya ndaghaano kandi aakisoma bantu boona banategheleei̱ye. Bantu aba baaghila bati, “Tu̱ku̱hu̱ti̱ya Mukama kandi tukukola byona ebi aalaghiiye.” ");
INSERT INTO tlj_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Musa aakwata saghama eghi eli mu maabbaafu kandi aaghimisangila bantu aba. Aaghila ati, “Eni niiyo saghama eghi eku̱gu̱mi̱ya ndaghaano eghi Mukama aakoli̱ye naanu kusighikila haa bighambo bini byona.” ");
INSERT INTO tlj_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Niibuwo Musa, Alooni̱, Nadaabbu, Abbi̱hu̱ na bengei̱ nsanju̱ baa Banai̱saaleeli̱ baaghendi̱ye haa mwena ");
INSERT INTO tlj_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","kandi baabona Luhanga wa I̱saaleeli̱. Hansi ya bighele biye hakaba hasu̱si̱ye nga mabaale ghaa muhendo baali̱ye agha bakughilaghamu su̱fi̱lo kandi hasu̱si̱ye nga mwanya ghubbeneeye kimui. ");
INSERT INTO tlj_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Bengei̱ baa Banai̱saaleeli̱ Mukama taabakoli̱ye kubhi na mukono ghuwe, bakamubona, baaliya kandi baanuwa. ");
INSERT INTO tlj_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Mukama aaghila Musa ati, “Oni̱i̱ne haa mwena hambali ndi kandi ookalʼo. Nkukuha bihande bya mabaale ebi naahandi̱i̱ki̱yʼo bilaghilo na ndaghikiililo ebi okwegheesi̱ya bantu baa I̱saaleeli̱.” ");
INSERT INTO tlj_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Musa aaghenda na Yosuwa oghu aamukoonelagha haa mulimo kandi Musa aani̱i̱na haa mwena ghwa Luhanga. ");
INSERT INTO tlj_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Aaghila bengei̱ aba ati, “Mutulinde hani ku̱hi̱ki̱ya tu̱ku̱u̱ki̱ye, nkubati̱ghi̱la Alooni̱ na Hula, muntu weena oghu ali na butaaghu̱wana na muunakiye, aghendaghe hambali bali.” ");
INSERT INTO tlj_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Niibuwo Musa aani̱i̱ni̱ye haa mwena Si̱naai̱ kandi kicu kyaswi̱ki̱la mwena oghu. ");
INSERT INTO tlj_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Kyeleeli̱ kyamaani̱ kya ki̱ti̱i̱ni̱sa kya Mukama kyaboneka haa mwena Si̱naai̱ kandi kicu kyaswi̱ki̱la mwena oghu haabwa bilo mukaagha. Haa kilo kyamusanju̱ Mukama ali haagati ya kicu eki aabilikila Musa. ");
INSERT INTO tlj_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Banai̱saaleeli̱ baabona kyeleeli̱ kyeli̱ye dhiyo kya ki̱ti̱i̱ni̱sa kya Mukama haagu̱u̱li̱ ya mwena oghu ki̱su̱si̱ye nga mulilo oghu̱ku̱hwelekeeleli̱yagha. ");
INSERT INTO tlj_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Musa aani̱i̱na haa mwena oghu kandi ataaha mu kicu, aamalayo bilo maku̱mi̱ anaa mukilo na ntangaali̱. ");
INSERT INTO tlj_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Oghambile Banai̱saaleeli̱ kundeetela bisembo. Kaakuba muntu aba ali na mutima ghwa kuhaayo kisembo kiye, akuleetele kiyo. ");
INSERT INTO tlj_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Bantu aba bakuleetele bisembo bini: feeja, siliva, bbu̱looji̱, ");
INSERT INTO tlj_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","mahu̱u̱ji̱ ghaa langi̱ ya bbu̱lu̱lu̱, papo, mutuku, lughoye lusemeeye, byoha bya mbu̱li̱, ");
INSERT INTO tlj_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","mpu siimutuku sya ntu̱u̱li̱ sya ntaama, mpu sya mbu̱li̱, mbaau sya ki̱i̱lu̱mbo, ");
INSERT INTO tlj_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","mafu̱ta ghaa kuta mu taala, bintu bisasi̱ye bya kuta mu mafu̱ta ghaa kusiigha, bintu bisasi̱ye bya kuta mu bubbani̱ busasi̱ye, ");
INSERT INTO tlj_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","mabaale onika, na mabaale ghanji ghaa muhendo, ghaa kuta haa efodi̱ na kyaku̱lu̱waala haa ki̱ku̱bha. ");
INSERT INTO tlj_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Banai̱saaleeli̱ bankwelele ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye, niikuwo niikale nabo. ");
INSERT INTO tlj_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Muli na kukwela weema ehi̱ki̱li̱i̱ye kandi kutaamu bintu byamu kusighikila haa ndaghikiililo eghi nkukwoleka. ");
INSERT INTO tlj_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Banai̱saaleeli̱ bankwelele sandu̱u̱ku̱ ya ndaghaano ku̱lu̱gha mu mbaau sya ki̱i̱lu̱mbo, kujamba kwayʼo fu̱u̱ti̱ esatu na i̱nci̱ mwenda, kugbaatikana fu̱u̱ti̱ ebili na i̱nci̱ esatu kandi kukangama fu̱u̱ti̱ ebili na i̱nci̱ esatu. ");
INSERT INTO tlj_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Oghi̱swi̱ki̱le na feeja esemeeye mukati na haagu̱u̱li̱ kandi oghyeli̱ghi̱i̱li̱li̱ye yoona na mugoma ghwa feeja. ");
INSERT INTO tlj_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Oghikolele mpete enaa sya feeja kandi osite haa maghulu anaa ghaa sandu̱u̱ku̱ eghi. Ote mpete ebili haa luhande lumui kandi mpete ebili haa luhande lunji. ");
INSERT INTO tlj_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Okole mpaghi sya ki̱i̱lu̱mbo kandi osi̱swi̱ki̱le na feeja. ");
INSERT INTO tlj_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Mpaghi esi osikwami̱ye mu mpete esili haa mpande syombi sya sandu̱u̱ku̱ eghi, kughiheekelaghʼo. ");
INSERT INTO tlj_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Mpaghi esi siikalaghe mu mpete sya sandu̱u̱ku̱ eghi, otalisiiyamu. ");
INSERT INTO tlj_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ote mu sandu̱u̱ku̱ eghi bihande bya mabaale ebi nkukuha, hambali bilaghilo bihandi̱i̱ku̱u̱we. ");
INSERT INTO tlj_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Okole kyakughaniililʼo bantu bibhi mu feeja esemeeye. Kujamba kwakiyo fu̱u̱ti̱ esatu na i̱nci̱ mwenda kandi kugbaatikana fu̱u̱ti̱ ebili na i̱nci̱ esatu. ");
INSERT INTO tlj_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Owiise na nondo bakelu̱bbi̱ babili baa feeja kandi obate haa mpande syombi sya kyakughaniililʼo bantu bibhi. ");
INSERT INTO tlj_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Kelu̱bbi̱ omui omute haa luhande lumui kandi onji omute haa luhande lunji. Feeja yoonini eghi oku̱koleesi̱ya kukola kyakughaniililʼo bantu bibhi, oghi̱koleesi̱ye dhee kukola bakelu̱bbi̱ aba. ");
INSERT INTO tlj_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Bakelu̱bbi̱ aba baale mapapa ghaabo eghulu ya kyakughaniililʼo bantu bibhi ku̱ki̱swi̱ki̱la. Baakale balolaane kandi baloli̱ye haa kyakughaniililʼo bantu bibhi. ");
INSERT INTO tlj_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Kyakughaniililʼo bantu bibhi eki, okite haagu̱u̱li̱ ya sandu̱u̱ku̱ ya ndaghaano kandi mukati yayo otemu bihande bibili bya mabaale ebihandi̱i̱ki̱yʼo bilaghilo ebi nkukuha. ");
INSERT INTO tlj_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Haagu̱u̱li̱ ya kyakughaniililʼo bantu bibhi eki, niiyo ndasanga-sangaanagha naawe kandi mbu̱ghe naawe ku̱lu̱gha haagati ya bakelu̱bbi̱ babili abali haagu̱u̱li̱ ya sandu̱u̱ku̱ ya ndaghaano. Haala niiyo ndasanga-sangaanagha naawe kandi nkuhe bilaghilo bya Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Okole meeja mu mbaau sya ki̱i̱lu̱mbo, kujamba kwayʼo fu̱u̱ti̱ esatu, kugbaatikana kwayʼo fu̱u̱ti̱ emui na i̱nci̱ mukaagha, kukangama kwayʼo fu̱u̱ti̱ ebili na i̱nci̱ esatu. ");
INSERT INTO tlj_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Oghi̱swi̱ki̱le na feeja esemeeye kandi oghitʼo mugoma ghwa feeja. ");
INSERT INTO tlj_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Oghyeli̱ghi̱i̱li̱li̱ye mu maakpengbu̱ na fuleemu ya i̱nci̱ esatu kandi otʼo mugoma ghwa feeja. ");
INSERT INTO tlj_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Oghikolele mpete enaa sya feeja kandi osite haa nsondo syayʼo enaa, haa maghulu ghaayʼo anaa. ");
INSERT INTO tlj_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Mpete esi osite haai na mugoma ghwa meeja eghi kandi sikwataghe mpaghi sya kuheekelaghʼo meeja eghi. ");
INSERT INTO tlj_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Okole mpaghi sya ki̱i̱lu̱mbo kandi osi̱swi̱ki̱le na feeja, haaliisiyo mwaheekelaghʼo meeja eghi. ");
INSERT INTO tlj_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Oghikolele sahaani̱ na bibindi bya kuheekelamu bubbani̱, bbaaku̱li̱ na jaaga bya kutaamu bihonguwa byakunuwa. Ebi byona bikoluwe mu feeja esemeeye. ");
INSERT INTO tlj_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Bwile bwona mutaaghe mugaati̱ oghu bampongeeye haa meeja haala mu maaso ghanje. ");
INSERT INTO tlj_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Okole kyakutʼo taala mu feeja esemeeye. Kyakutʼo taala eki kyona, otaayemu bimole byakiyo byaku̱ki̱semeli̱ya, obiwiise na nondo mu feeja esemeeye eghi yoonini. ");
INSERT INTO tlj_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Kyakutʼo taala eki kibe na matai mukaagha aghalu̱ghi̱ye haa ki̱ti̱na kya haagati, matai asatu haa luhande lumui na ghanji asatu haa luhande lunji. ");
INSERT INTO tlj_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Bu̱li̱ etai haa matai mukaagha ghaa kyakutʼo taala eki, libʼo bimole bisatu ebi̱su̱si̱ye bimole bya kiti alu̱mondi̱. ");
INSERT INTO tlj_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Haa ki̱ti̱na kya haagati ya kyakutʼo taala eki habʼo bimole bbinaa ebi̱su̱si̱ye bimole bya kiti alu̱mondi̱. ");
INSERT INTO tlj_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Hansi ya bu̱li̱ matai abili aghalu̱ghi̱ye haa ki̱ti̱na kya kyakutʼo taala eki, otʼo kimole eki̱su̱si̱ye kimole kya kiti alu̱mondi̱. ");
INSERT INTO tlj_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Kyakutʼo taala eki, otaayemu matai ghaakiyo na bimole byakiyo byaku̱ki̱semeli̱ya, obiwiise na nondo mu feeja esemeeye eghi yoonini. ");
INSERT INTO tlj_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Okole taala musanju̱ sya kuta haagu̱u̱li̱ ya matai mukaagha na ya kuta haagu̱u̱li̱ ya ki̱ti̱na kya haagati ya kyakutʼo taala eki. Otʼo taala esi niikuwo siikale sibhaki̱i̱ye mu maaso ghaakiyo. ");
INSERT INTO tlj_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Makaasi ghaa taala esi na biisaniya byasiyo bikoluwe mu feeja esemeeye. ");
INSERT INTO tlj_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Kyakutʼo taala eki na bintu byakiyo byona obikole mu ki̱lo maku̱mi̱ asatu nʼetaano sya feeja esemeeye. ");
INSERT INTO tlj_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Olole ngu bu̱li̱ kintu waaki̱koli̱ye kusighikila haa ndaghikiililo eghi naakwoleki̱ye haa mwena ghuni.” ");
INSERT INTO tlj_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Okwele weema ehi̱ki̱li̱i̱ye na kateni̱ eku̱mi̱ sya lughoye lusemeeye kandi mu langi̱ ya bbu̱lu̱lu̱, papo na mutuku. Mu̱soni̱ mulungi asonele haa kateni̱ esi bisasani̱ bya bakelu̱bbi̱. ");
INSERT INTO tlj_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Kateni̱ esi syona syengana-ngane, kujamba kwasiyo mi̱ta eku̱mi̱ nʼebili kandi kugbaatikana mi̱ta ebili. ");
INSERT INTO tlj_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Kateni̱ etaano osikwatani̱ye hamui, na sinji etaano osikwatani̱ye hamui. ");
INSERT INTO tlj_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Haa mukughilo ghwa kateni̱ yʼokumaliilila, haa kateni̱ etaano esikwatani̱i̱ye hamui, otʼo mpete sya lughoye lwa langi̱ ya bbu̱lu̱lu̱ kandi okole otiyo dhee mukughilo ghwa kateni̱ yʼokumaliilila ya sinji etaano esikwatani̱i̱ye hamui. ");
INSERT INTO tlj_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Ote mpete sya lughoye maku̱mi̱ ataano haa mukughilo ghwa kateni̱ yʼokumaliilila haa kateni̱ etaano esikwatani̱i̱ye hamui, na mpete sya lughoye sinji maku̱mi̱ ataano haa kateni̱ yʼokumaliilila haa kateni̱ sinji etaano esikwatani̱i̱ye hamui kandi silolane. ");
INSERT INTO tlj_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Okole bigwasi maku̱mi̱ ataano bya feeja kandi obi̱koleesi̱ye kukwatani̱ya hamui kateni̱ esi, niikuwo ebe weema ehi̱ki̱li̱i̱ye emui. ");
INSERT INTO tlj_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Okole dhee kateni̱ eku̱mi̱ nʼemui mu byoha bya mbu̱li̱ sya ku̱swi̱ki̱la weema ehi̱ki̱li̱i̱ye eghi. ");
INSERT INTO tlj_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Kujamba kwa bu̱li̱ kateni̱ kube mi̱ta eku̱mi̱ nʼesatu kandi kugbaatikana kube mi̱ta ebili. Kateni̱ eku̱mi̱ nʼemui esi syona syengana-ngane. ");
INSERT INTO tlj_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Kateni̱ etaano osikwatani̱ye syonkaha, na sinji mukaagha osikwatani̱ye syonkaha. Kateni̱ ya mukaagha oghi̱ku̱nemu kabili kandi oghite haa mulyango ghwa weema. ");
INSERT INTO tlj_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Ote mpete sya lughoye maku̱mi̱ ataano haa mukughilo ghwa kateni̱ yʼokumaliilila haa kateni̱ etaano esikwatani̱i̱ye hamui na mpete sya lughoye maku̱mi̱ ataano haa mukughilo ghwa kateni̱ yʼokumaliilila haa kateni̱ mukaagha esikwatani̱i̱ye hamui. ");
INSERT INTO tlj_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Okole bigwasi maku̱mi̱ ataano bya bbu̱looji̱ kandi obite mu mpete sya lughoye kukwatani̱ya weema eghi, niikuwo ebe weema emui. ");
INSERT INTO tlj_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ki̱twi̱ke kya kateni̱ esikuba si̱ti̱ghaayʼo, kimui kya kabili kyasiyo, oki̱dhodhooki̱ye enu̱ma ya weema ehi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ki̱twi̱ke kya mi̱ta eki̱ti̱ghaayʼo ki̱swi̱ki̱le mu maakpengbu̱ ghaa weema ehi̱ki̱li̱i̱ye eghi. ");
INSERT INTO tlj_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Okole bintu binji bibili bya ku̱swi̱ki̱la weema eghi, kimui ku̱lu̱gha mu mpu siimutuku sya ntu̱u̱li̱ sya ntaama na kinji ku̱lu̱gha mu mpu sya mbu̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Okole fuleemu sya ki̱i̱lu̱mbo sya kwemi̱li̱li̱yʼo weema ehi̱ki̱li̱i̱ye eghi. ");
INSERT INTO tlj_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Kujamba kwa bu̱li̱ fuleemu kube fu̱u̱ti̱ eku̱mi̱ nʼetaano kandi kugbaatikana kube fu̱u̱ti̱ ebili na i̱nci̱ esatu. ");
INSERT INTO tlj_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Bu̱li̱ fuleemu oghikolele nkondo ebili sya kuta hansi yayo, kusikwatani̱ya. Fuleemu syona sya weema ehi̱ki̱li̱i̱ye eghi haaliikuwo waasikola otiyo. ");
INSERT INTO tlj_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Okole fuleemu maku̱mi̱ abili sya kuta haa luhande lwa eku̱wa lwa weema ehi̱ki̱li̱i̱ye eghi. ");
INSERT INTO tlj_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Okole ncuba sya siliva maku̱mi̱ anaa sya kutaamu fuleemu maku̱mi̱ abili esi kandi ote ncuba ebili hansi ya bu̱li̱ fuleemu kukwata nkondo syayʼo ebili. ");
INSERT INTO tlj_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Okole fuleemu maku̱mi̱ abili sya kuta haa luhande lwʼelughulu lwa weema ehi̱ki̱li̱i̱ye eghi. ");
INSERT INTO tlj_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Okole ncuba sya siliva maku̱mi̱ anaa, ncuba ebili sya kuta hansi ya bu̱li̱ fuleemu. ");
INSERT INTO tlj_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Okole fuleemu mukaagha sya kuta enu̱ma ya weema ehi̱ki̱li̱i̱ye eghi haa luhande lwa bughuwa ejooba. ");
INSERT INTO tlj_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Okole fuleemu ebili sya kuta haa nsondo ku̱gu̱mi̱ya weema ehi̱ki̱li̱i̱ye eghi. ");
INSERT INTO tlj_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Fuleemu sya mu nsondo esi osikwatani̱ye ku̱lu̱gha hansi ku̱hi̱ka elughulu kandi osi̱bohi̱ye mpete emui. Haaliikuwo waakola otiyo fuleemu syombi syʼomu nsondo ebili. ");
INSERT INTO tlj_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Okole fuleemu munaanaa na ncuba sya kusitaamu eku̱mi̱ na mukaagha sya siliva kandi ncuba ebili hansi ya bu̱li̱ fuleemu. ");
INSERT INTO tlj_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Okole mikiiko etaano mu ki̱i̱lu̱mbo, ya kukwatani̱ya fuleemu sya luhande lwʼelughulu lwa weema ehi̱ki̱li̱i̱ye eghi. ");
INSERT INTO tlj_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Okole mikiiko etaano ya kukwatani̱ya fuleemu sya luhande lwʼeku̱wa kandi mikiiko etaano ya kukwatani̱ya fuleemu sya luhande lwa bughuwa ejooba bwa weema ehi̱ki̱li̱i̱ye eghi. ");
INSERT INTO tlj_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Mukiiko ghwa fuleemu ghwa kuta haagati ya fuleemu esi ghu̱lu̱ghe haa luhande lumui ku̱hi̱ka haa luhande lunji. ");
INSERT INTO tlj_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Fuleemu esi osi̱swi̱ki̱le na feeja kandi okole mpete syasiyo sya feeja sya kukwata mikiiko kandi mikiiko eghi oghi̱swi̱ki̱le na feeja. ");
INSERT INTO tlj_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Olole ngu waakweye weema ehi̱ki̱li̱i̱ye kusighikila haa ndaghikiililo eghi naakwoleki̱ye haa mwena ghuni. ");
INSERT INTO tlj_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Okole kateni̱ mu langi̱ ya bbu̱lu̱lu̱, papo, mutuku na lughoye lusemeeye kandi osonelʼo kulungi bisasani̱ bya bakelu̱bbi̱. ");
INSERT INTO tlj_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Oghi̱dhodhooki̱ye na ndobhaani̱ sya feeja haa mpaghi enaa sya ki̱i̱lu̱mbo esi̱swi̱ki̱ye na feeja kandi esili mu ncuba enaa sya siliva sya kutaamu mpaghi esi. ");
INSERT INTO tlj_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Kateni̱ eghi oghi̱dhodhooki̱ye na bigwasi haagati ya weema eghi kandi ote sandu̱u̱ku̱ ya ndaghaano enu̱ma syayo. Kateni̱ eghi ekutambulani̱yamu Ki̱i̱kalo Ki̱hi̱ki̱li̱i̱ye na Ki̱i̱kalo Ki̱hi̱ki̱li̱i̱ye kusaali̱ya byona. ");
INSERT INTO tlj_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Ote kyakughaniililʼo bantu bibhi haagu̱u̱li̱ ya sandu̱u̱ku̱ ya ndaghaano mu Ki̱i̱kalo Ki̱hi̱ki̱li̱i̱ye kusaali̱ya byona. ");
INSERT INTO tlj_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Ote meeja enja ya kateni̱ eghi haa luhande lwʼelughulu lwa weema ehi̱ki̱li̱i̱ye eghi kandi kyakutʼo taala haa luhande lwʼeku̱wa. ");
INSERT INTO tlj_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Haa mulyango ghwa weema eghi, otʼo kateni̱ ya langi̱ ya bbu̱lu̱lu̱, papo, mutuku na lughoye lusemeeye kandi eghi mu̱soni̱ mulungi akoli̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Kateni̱ eghi oghikolele mpaghi etaano sya ki̱i̱lu̱mbo kandi osi̱swi̱ki̱le na feeja. Ndobhaani̱ esi oku̱dhodhooki̱yʼo kateni̱ eghi sibe sya feeja kandi mpaghi esi osite mu ncuba etaano sya bbu̱looji̱.” ");
INSERT INTO tlj_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Okole kyakuhongelʼo bihonguwa mu ki̱i̱lu̱mbo. Kyona kyengana-ngane, kujamba kwakiyo fu̱u̱ti̱ musanju̱ nʼeki̱twi̱ke, kugbaatikana fu̱u̱ti̱ musanju̱ nʼeki̱twi̱ke kandi kukangama fu̱u̱ti̱ enaa nʼeki̱twi̱ke. ");
INSERT INTO tlj_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Okikolele mahembe kandi haa bu̱li̱ nsondo syakiyo enaa otʼo ehembe limui. Mahembe agha oghakole mu ki̱twi̱ke kya kiti eki kyonini kandi oki̱swi̱ki̱le na bbu̱looji̱. ");
INSERT INTO tlj_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Okole byaku̱koleesi̱ya haa kyakuhongelʼo bihonguwa eki: capu̱li̱ya sya kutaamu ki̱bu̱, bi̱ti̱i̱yo, bibindi, huuma na capu̱li̱ya sya ku̱tu̱mi̱kamu mulilo, bintu ebi byona obikole mu bbu̱looji̱. ");
INSERT INTO tlj_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Okole kati̱mba kaa bbu̱looji̱ kandi haa bu̱li̱ nsondo syako enaa otʼo mpete emui. ");
INSERT INTO tlj_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Kati̱mba aka okakoti̱ye mukati hansi ya mugoma ghwa kyakuhongelʼo bihonguwa kandi kahi̱ke haagati yakiyo. ");
INSERT INTO tlj_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Okole mpaghi sya ki̱i̱lu̱mbo sya kuheekelaghʼo kyakuhongelʼo bihonguwa eki kandi osi̱swi̱ki̱le na bbu̱looji̱. ");
INSERT INTO tlj_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Mpaghi esi osikwami̱ye mu mpete esili haa mpande ebili sya kyakuhongelʼo bihonguwa eki, niikuwo bakiheekelaghʼo. ");
INSERT INTO tlj_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Kyakuhongelʼo bihonguwa eki, okikole mu mbaau kandi mukati yakiyo habemu mwanya. Okikole ngoku naakwoleki̱ye haa mwena. ");
INSERT INTO tlj_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Okole jighati̱ ya weema ehi̱ki̱li̱i̱ye. Haa luhande lwa eku̱wa lwa weema eghi otʼo kateni̱ sya lughoye lusemeeye, kujamba kwasiyo mi̱ta maku̱mi̱ anaa nʼenaa. ");
INSERT INTO tlj_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Mpaghi maku̱mi̱ abili sya kateni̱ esi na ncuba sya kusitaamu maku̱mi̱ abili byona bibe bya bbu̱looji̱, bhaatu ndobhaani̱ sya mpaghi esi na mpete syasiyo bibe bya siliva. ");
INSERT INTO tlj_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Haa luhande lwa elughulu, otʼo kateni̱ kujamba kwasiyo mi̱ta maku̱mi̱ anaa nʼenaa. Mpaghi maku̱mi̱ abili sya kutʼo kateni̱ esi na ncuba maku̱mi̱ abili sya kutaamu mpaghi esi bibe bya bbu̱looji̱, bhaatu ndobhaani̱ sya mpaghi esi na mpete syasiyo bibe bya siliva. ");
INSERT INTO tlj_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Haa luhande lwa bughuwa ejooba, otʼo kateni̱ kujamba kwasiyo mi̱ta maku̱mi̱ abili nʼebili kandi osite haa mpaghi eku̱mi̱ esili mu ncuba eku̱mi̱. ");
INSERT INTO tlj_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Haa luhande lwa bu̱lu̱gha ejooba, kujamba kwa jighati̱ kube mi̱ta maku̱mi̱ abili nʼebili. ");
INSERT INTO tlj_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Kateni̱ sya kuta haa luhande lumui lwa mulyango, kujamba kwasiyo kube mi̱ta mukaagha nʼeki̱twi̱ke kandi osite haa mpaghi esatu esili mu ncuba esatu. ");
INSERT INTO tlj_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Haa luhande lunji lwa geeti̱ eghi, otʼo kateni̱ kujamba kwasiyo mi̱ta mukaagha nʼeki̱twi̱ke kandi osite haa mpaghi esatu esili mu ncuba esatu. ");
INSERT INTO tlj_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Haa geeti̱ otʼo kateni̱ kujamba kwayʼo mi̱ta mwenda, mu langi̱ ya bbu̱lu̱lu̱, papo na mutuku, eghi mu̱soni̱ mulungi akoli̱ye mu lughoye lusemeeye kandi oghite haa mpaghi enaa esili mu ncuba enaa. ");
INSERT INTO tlj_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Mpaghi syona esyeli̱ghi̱li̱i̱ye jighati̱ eghi osikwatani̱ye na mpete sya siliva, ndobhaani̱ sya kuta haa mpaghi sya jighati̱ esi sibe sya siliva kandi ncuba sya bbu̱looji̱ sya kutaamu mpaghi esi. ");
INSERT INTO tlj_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Jighati̱ yayo kujamba kwayʼo kube fu̱u̱ti̱ ki̱ku̱mi̱ na maku̱mi̱ ataano, kugbaatikana kwayʼo fu̱u̱ti̱ nsanju̱ nʼetaano kandi kateni̱ sya kukola lugho kujamba kwasiyo kube mi̱ta ebili na kimui kyakanaa, esi̱koleeu̱we mu lughoye lusemeeye. Ncuba sya kutaamu mpaghi esi sibe sya bbu̱looji̱. ");
INSERT INTO tlj_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Bintu byona byaku̱koleesi̱ya mu weema ehi̱ki̱li̱i̱ye, nkondo syayʼo syona, na nkondo sya jighati̱, bibe bya bbu̱looji̱. ");
INSERT INTO tlj_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Olaghile Banai̱saaleeli̱ kukuleetela mafu̱ta ghasemeeye ghaa biti oli̱va ghaa kuta mu taala, niikuwo taala eghi eekalaghe yaaki̱ye bwile bwona. ");
INSERT INTO tlj_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Mu weema ya kusanga-sangaanamu, enja ya kateni̱ eghi eli mu maaso ghaa sandu̱u̱ku̱ ya ndaghaano, Alooni̱ na batabani̱ be, baakalaghe babhaki̱i̱ye taala bwile bwona mu maaso ghaa Mukama ku̱lu̱gha lwagholo ku̱hi̱ka nkyambisi. Kini nkilaghilo eki Banai̱saaleeli̱ bali na kukwata mu mijo yabo yoona bilo nʼebilo.” ");
INSERT INTO tlj_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Mukama aalaghila Musa ati, “Obilikile mwana wa njoko waawe Alooni̱ na batabani̱ be Nadaabbu, Abbi̱hu̱, Eli̱yeeja na I̱tamala kwisa hambali oli. Bantu aba niibo naakomi̱yemu̱ mu Banai̱saaleeli̱ boona ku̱mpeeleli̱ya nga bahongi̱. ");
INSERT INTO tlj_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Okolele mwana wa njoko waawe Alooni̱ bi̱lu̱waalo bi̱hi̱ki̱li̱i̱ye bya bu̱hongi̱, ebikuleka bantu mbamu̱hu̱ti̱ya kandi ebi̱ku̱mu̱semeli̱ya. ");
INSERT INTO tlj_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Oghambile basaasa abamani̱ye kubikola kwonini kandi aba naahaaye magheji, bakolele Alooni̱ bi̱lu̱waalo bya ku̱mu̱lu̱wi̱ka mamufoola mu̱hongi̱ wanje. ");
INSERT INTO tlj_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Bini niibiyo bi̱lu̱waalo bali na kukola: kyaku̱lu̱waala haa ki̱ku̱bha, efodi̱, nkanji̱, kyaku̱lu̱waala mukati, kyaku̱lu̱waala mu mutuwe na muheeko. Bakolele Alooni̱ na batabani̱ be bi̱lu̱waalo bi̱hi̱ki̱li̱i̱ye ebi balalu̱waalagha mbampeeleli̱ya nga bahongi̱. ");
INSERT INTO tlj_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Basaasa abamani̱ye kubikola, bakoleesi̱ye feeja na mahu̱u̱ji̱ mu langi̱ ya bbu̱lu̱lu̱, papo, mutuku na lughoye lusemeeye. ");
INSERT INTO tlj_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Basaasa aba bakole efodi̱ mu feeja na mu lughoye lusemeeye kandi mu̱soni̱ mulungi atemu mahu̱u̱ji̱ ghaa langi̱ ya bbu̱lu̱lu̱, papo na mutuku. ");
INSERT INTO tlj_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Haa nsondo ebili sya efodi̱ eghi, ote haa mpande syombi buheeko bwa kukwatani̱ya haa mabegha ki̱twi̱ke kya mu maaso na kyʼenu̱ma, niikuwo ekwatane hamui. ");
INSERT INTO tlj_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Basaasa aba bakole muheeko mu lughoye lusemeeye olu baakoli̱yemu efodi̱ kandi batemu mahu̱u̱ji̱ ghaa feeja, ghaa langi̱ ya bbu̱lu̱lu̱, papo na mutuku. ");
INSERT INTO tlj_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Okwate mabaale abili onika kandi oghahandiikʼo mali̱i̱na ghaa batabani̱ eku̱mi̱ na babili baa I̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Haa ebaale limui ohandiikʼo mali̱i̱na mukaagha na haa ebaale linji ohandiikʼo mali̱i̱na mukaagha ngoku balabhangaane mu ku̱byaluwa kwabo. ");
INSERT INTO tlj_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Mubhaaki̱ wa mabaale ngoku akuteelaghʼo bisasani̱ kusemeeye, haaliikuwo naawe waata kusemeeye haa mabaale agha mali̱i̱na ghaa batabani̱ baa I̱saaleeli̱. Mabaale agha oghate mu buufuleemu buunabwana bwa feeja. ");
INSERT INTO tlj_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Mabaale abili agha oghabohe haagu̱u̱li̱ ya efodi̱ na buheeko bubili haa mabegha ghombi kughikwatani̱ya hamui kandi ghakuba kaakuusukilʼo batabani̱ baa I̱saaleeli̱. Alooni̱ aghendaghe aheeki̱ye mali̱i̱na agha mu maaso ghaa Mukama, niikuwo Mukama abaasukaghe. ");
INSERT INTO tlj_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Okole buufuleemu buunabwana bubili bwa feeja, ");
INSERT INTO tlj_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","na bujeghele bubili mu feeja esemeeye, obutali̱ye nga bughuwo kandi obutaahi̱ye mu buufuleemu buunabwana bwa feeja obu. ");
INSERT INTO tlj_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Okole kyaku̱lu̱waala haa ki̱ku̱bha eki mukulu wa bahongi̱ boona alalu̱waalagha naaghambila bantu eki Luhanga akubbala bakole. Okikole mu lughoye lwonini olu waakoli̱yemu efodi̱ kandi otemu mahu̱u̱ji̱ ghaa feeja, langi̱ ya bbu̱lu̱lu̱, papo, mutuku na lughoye lusemeeye. ");
INSERT INTO tlj_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Oki̱ku̱nemu̱ kabili kandi kyengaane mpande syona, i̱nci̱ mwenda kujamba kandi i̱nci̱ mwenda kugbaatikana. ");
INSERT INTO tlj_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Okitʼo lai̱ni̱ enaa sya mabaale ghaa muhendo. Lai̱ni̱ yʼoku̱du̱bha otʼo ghaamutuku salu̱di̱yo, ghaa ki̱si̱ka kibisi topaji̱ na ghaamutuku kabu̱nku̱lo. ");
INSERT INTO tlj_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Lai̱ni̱ yaakabili otʼo ghaa ki̱si̱ka kibisi i̱mi̱lali̱do, ghaa bbu̱lu̱lu̱ su̱fi̱lo na ghaa njelu dayamondi̱. ");
INSERT INTO tlj_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Lai̱ni̱ yaakasatu otʼo ghaa mutuku takwi̱je, ghaa njelu agate na ghaa papo ameti̱si̱to. ");
INSERT INTO tlj_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Lai̱ni̱ yaakanaa otʼo ghaa kinjaali̱ bbelu̱lo, ghaa mutuku onika na ghaa ki̱si̱ka kibisi yesipa. Mabaale agha oghate mu buufuleemu buunabwana bwa feeja. ");
INSERT INTO tlj_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Hakubʼo mabaale eku̱mi̱ nʼabili kandi haa bu̱li̱ ebaale ohandiikʼo li̱i̱na lya omui haa batabani̱ eku̱mi̱ na babili baa Yakobbo kwoleka ntu̱la eku̱mi̱ nʼebili sya I̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Kyaku̱lu̱waala haa ki̱ku̱bha eki okikolele bujeghele bubili bwa feeja busemeeye obutali̱ye nga bughuwo. ");
INSERT INTO tlj_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Kyaku̱lu̱waala haa ki̱ku̱bha eki okikolele mpete ebili sya feeja kandi osite haa nsondo syakiyo ebili syʼelughulu. ");
INSERT INTO tlj_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Obohe bujeghele bubili bwa feeja mu mpete ebili esili haa mpande ebili sya kyaku̱lu̱waala haa ki̱ku̱bha. ");
INSERT INTO tlj_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Okwatani̱ye kumaliilila kunji kwa bujeghele bubili haa buufuleemu buunabwana bwa feeja kandi obubohe mu maaso ghaa efodi̱ eghi. ");
INSERT INTO tlj_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Okole mpete ebili sya feeja kandi osite haa nsondo ebili syʼeku̱wa ya kyaku̱lu̱waala haa ki̱ku̱bha, mukati haai na efodi̱. ");
INSERT INTO tlj_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Okole mpete sinji ebili sya feeja kandi osite haakumaliilila kwa bughuwo bubili bwa haa mabegha ghaa efodi̱, hambali ki̱twi̱ke kyayʼo kyʼeku̱wa kilabhaane na muheeko oghu̱soni̱ye kulungi. ");
INSERT INTO tlj_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Mpete syakiyo osibohele haa mpete sya kyaku̱lu̱waala haa ki̱ku̱bha na bughuwo bwa langi̱ ya bbu̱lu̱lu̱, niikuwo kilangaale haa muheeko ghwa efodi̱ eghi ekoleeu̱we kulungi, niikuwo kitatelebuka haa efodi̱ eghi. ");
INSERT INTO tlj_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Obu Alooni̱ alabaagha naataaha mu Ki̱i̱kalo Ki̱hi̱ki̱li̱i̱ye, alu̱waalaghe kyaku̱lu̱waala haa ki̱ku̱bha eki, ekihandi̱i̱ku̱u̱wʼo mali̱i̱na ghaa ntu̱la sya I̱saaleeli̱, niikuwo si̱ye Mukama niisukaghe bantu banje aba. ");
INSERT INTO tlj_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ote U̱li̱i̱mu̱ na Tu̱mi̱i̱mu̱ mu kyaku̱lu̱waala haa ki̱ku̱bha, niikuwo Alooni̱ abiheekaghe haa ki̱ku̱bha obu alabaagha naasa mu maaso ghaa Mukama. Bwile obu abiheekaghe haa ki̱ku̱bha kumanya ebi si̱ye Mukama nkubbala bantu baa I̱saaleeli̱ bakole. ");
INSERT INTO tlj_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Okole nkanji̱ ya langi̱ ya bbu̱lu̱lu̱ ya ku̱lu̱waala mukati ya efodi̱. ");
INSERT INTO tlj_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Nkanji̱ eghi ebe na kihulu haagati ekiliyo mukughilo kya kukwami̱yamu mutuwe niikuwo etatemuka. ");
INSERT INTO tlj_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Okole mikomamahanga mu langi̱ ya bbu̱lu̱lu̱, papo na mutuku kandi oghite haa mukughilo ghwa eku̱wa ghwa nkanji̱ eghi. Ote bida bya feeja haagati ya mikomamahanga eghi. ");
INSERT INTO tlj_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Kida kya feeja okilabhani̱ye na mukomamahanga, kida kya feeja okilabhani̱ye na mukomamahanga, kweli̱ghi̱i̱li̱li̱ya mukughilo ghwa eku̱wa ghwa nkanji̱ eghi. ");
INSERT INTO tlj_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Alooni̱ abi̱lu̱waalaghe naaghenda ku̱heeleli̱ya kandi baaghu̱waghe elaka lya bida ebi obu alabaagha naataaha mu Ki̱i̱kalo Ki̱hi̱ki̱li̱i̱ye mu maaso ghaa Mukama kandi naatuwayo, niikuwo ataku̱wa. ");
INSERT INTO tlj_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Okole kaapa mu feeja esemeeye kandi okahandiikʼo oti, ‘Ahi̱ki̱li̱i̱ye ewaa Mukama.’ ");
INSERT INTO tlj_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Kaapa aka okabohe na kaghuwo kaa langi̱ ya bbu̱lu̱lu̱ mu maaso ghaa kyaku̱lu̱waala mu mutuwe. ");
INSERT INTO tlj_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Alooni̱ akalu̱waalaghe haa bhu̱u̱su̱, niikuwo si̱ye Mukama nsi̱i̱maghe bihonguwa bi̱hi̱ki̱li̱i̱ye ebi Banai̱saaleeli̱ bakuba baleeti̱ye ewanje, nankabha bantu aba basobi̱ya obu bakuba mbahonga bihonguwa ebi. ");
INSERT INTO tlj_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Okolele Alooni̱ kyaku̱lu̱waala mukati mu lughoye lusemeeye. Omukolele kyaku̱lu̱waala mu mutuwe mu lughoye lusemeeye kandi omukolele muheeko oghuliyo mudali̱jo, oghu mu̱soni̱ mulungi akoli̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Batabani̱ baa Alooni̱ nabo dhee obakolele kyaku̱lu̱waala mukati, kyaku̱lu̱waala mu mutuwe na miheeko, ebikuleka bantu mbabahu̱ti̱ya kandi ebikubasemeli̱ya. ");
INSERT INTO tlj_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Olu̱wi̱ke mwana wa njoko waawe Alooni̱ na batabani̱ be bi̱lu̱waalo byabo bya bu̱hongi̱, obasiighʼo mafu̱ta kandi obeeli̱ye, niikuwo bampeeleli̱ye nga bahongi̱. ");
INSERT INTO tlj_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Obakolele mpale sya mukati sya langi̱ njelu, sitandikile mu mi̱ghelu̱ ku̱hi̱ka mu bibelo, niikuwo atabʼo muntu oghu akubona mihina yabo. ");
INSERT INTO tlj_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Alooni̱ na batabani̱ be balu̱waalaghe bi̱lu̱waalo ebi mbataaha mu weema ya kusanga-sangaanamu. Babi̱lu̱waalaghe dhee mbaghenda haa kyakuhongelʼo bihonguwa kukola mulimo mu Ki̱i̱kalo Ki̱hi̱ki̱li̱i̱ye. Kaakuba bakola eki, tabakuba na musango kandi tankubaha kifubilo kya lu̱ku̱. “Alooni̱ na baasukulu be bali na kukwata kilaghilo kini bilo nʼebilo.” ");
INSERT INTO tlj_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Kini niikiyo oli na kukolʼo Alooni̱ na batabani̱ be ku̱beeli̱ya, niikuwo bagubhe ku̱mpeeleli̱ya nga bahongi̱. Okwate ntu̱u̱li̱ ya nte emui na ntu̱u̱li̱ sya ntaama ebili esitali na kamogo. ");
INSERT INTO tlj_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Okande ki̱tu̱mbe kya ngano eghi esemeeye kandi kitalimu ki̱tu̱mbi̱so. Ki̱tu̱mbe eki oteekemu migaati̱ ya milundi esatu, emui haa migaati̱ eghi oghi̱teeki̱ye mafu̱ta ghaa biti oli̱va, enji otaghi̱teeki̱ya mafu̱ta kandi enji oghiteekemu bugaati̱ buunabwana bu̱si̱i̱ghi̱yʼo mafu̱ta. ");
INSERT INTO tlj_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Migaati̱ eghi yoona oghite mu kighegha kandi wiise nayo obu okuba noosa kuhonga ntu̱u̱li̱ ya nte na ntu̱u̱li̱ sya ntaama ebili esi. ");
INSERT INTO tlj_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Oleete Alooni̱ na batabani̱ be haa mulyango ghwa weema ya kusanga-sangaanamu kandi obanaabi̱ye na maasi. ");
INSERT INTO tlj_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Okwate bi̱lu̱waalo bya bu̱hongi̱ kandi olu̱wi̱ke Alooni̱ kyaku̱lu̱waala mukati, nkanji̱ na efodi̱. Omu̱lu̱wi̱ke efodi̱ kandi kyaku̱lu̱waala haa ki̱ku̱bha. Efodi̱ eghi oghibohe na muheeko oghu̱koleeu̱we kulungi. ");
INSERT INTO tlj_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Omu̱lu̱wi̱ke kyaku̱lu̱waala mu mutuwe kandi obohe kaapa kahi̱ki̱li̱i̱ye haa kyaku̱lu̱waala mu mutuwe eki. ");
INSERT INTO tlj_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Okwate mafu̱ta ghaa kusiigha kandi oghaseese Alooni̱ mu mutuwe ku̱mweli̱ya. ");
INSERT INTO tlj_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Du̱mbi̱ oleete batabani̱ be kandi obalu̱wi̱ke byaku̱lu̱waala mukati. ");
INSERT INTO tlj_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Obalu̱wi̱ke miheeko na byaku̱lu̱waala mu mutuwe. Weeli̱ye otiyo Alooni̱ na batabani̱ be nanga ebo na baasukulu baabo ku̱mpeeleli̱ya nga bahongi̱ ni kilaghilo kya bilo nʼebilo. ");
INSERT INTO tlj_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Oleete ntu̱u̱li̱ ya nte eghi mu maaso ghaa weema ya kusanga-sangaanamu. Alooni̱ na batabani̱ be bate mikono yabo haa mutuwe ghwa ntu̱u̱li̱ ya nte eghi. ");
INSERT INTO tlj_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ntu̱u̱li̱ ya nte eghi mughiitile mu maaso ghaa Mukama haa mulyango ghwa weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Otwale haa saghama ya ntu̱u̱li̱ ya nte eghi kandi oghisiighe na kyala kyawe haa mahembe ghaa kyakuhongelʼo bihonguwa. Saghama eghi eku̱ti̱ghalʼo oghiseese haa ki̱twi̱ke kya hansi ya kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Okwate bisabu̱ ebi̱swi̱ki̱ye byenda, ki̱twi̱ke kisemeeye kya bu̱ne, mpi̱gho syombi na bisabu̱ byasiyo, obyokeli̱ye haa kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Bhaatu ntu̱u̱li̱ ya nte eghi, luhu, nyama syayʼo na mabhi̱ ghaayʼo, abyokeli̱ye haa mulilo enja ya hambali baghooneeye. Eki kibe kihonguwa kya kughanila bahongi̱ bibhi byabo. ");
INSERT INTO tlj_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Otwale emui haa ntu̱u̱li̱ sya ntaama kandi oghambile Alooni̱ na batabani̱ be kuta mikono yabo haa mutuwe ghwa ntu̱u̱li̱ ya ntaama eghi. ");
INSERT INTO tlj_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Osale ntu̱u̱li̱ ya ntaama eghi kandi omisange saghama yayo haa mpande syona sya kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Ntu̱u̱li̱ ya ntaama eghi oghiiyemu myana, onaabi̱ye byenda byayʼo, bilenge byayʼo na mutuwe ghwayʼo na myana eghi. ");
INSERT INTO tlj_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Ntu̱u̱li̱ ya ntaama eghi yoona oghyokeli̱ye haa kyakuhongelʼo bihonguwa, nga kihonguwa kyona kyokeei̱ye, kihonguwa bookeei̱ye haa mulilo, eki kusasa kwakiyo ku̱dheedhi̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Okwate ntu̱u̱li̱ ya ntaama enji, Alooni̱ na batabani̱ be bate mikono yabo haa mutuwe ghwa ntu̱u̱li̱ ya ntaama eghi. ");
INSERT INTO tlj_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Ntu̱u̱li̱ ya ntaama eghi oghisale kandi ooye haa saghama yayo, oghisiighe haa nsonga ya kutui kwabuliyo kwa Alooni̱ na haa nsonga sya matui ghaabuliyo ghaa batabani̱ be, na haa byala byabo byabusaasa bya mikono yabuliyo, na haa bighele byabo byabusaasa bya maghulu ghaabo ghaabuliyo. Saghama eghi eku̱ti̱ghalʼo oghimisange haa mpande syona sya kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Ooye haa saghama eghi eli haa kyakuhongelʼo bihonguwa, oghitabule mu mafu̱ta ghaa kusiigha kandi oghamisangile Alooni̱ na batabani̱ be. Oghamisangile haa bi̱lu̱waalo byabo, du̱mbi̱ bakufooka bahi̱ki̱li̱i̱ye kandi bi̱lu̱waalo byabo bikufooka bi̱hi̱ki̱li̱i̱ye dhee. ");
INSERT INTO tlj_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Haa ntu̱u̱li̱ ya ntaama eghi, ooyʼo bisabu̱ bya haa mukila, bisabu̱ byona ebi̱swi̱ki̱ye byenda, ki̱twi̱ke kisemeeye kya bu̱ne, mpi̱gho syombi na bisabu̱ byasiyo na kibelo kyabuliyo. (Ni ntaama ya mukolo ghwa ku̱lu̱wi̱ka bahongi̱.) ");
INSERT INTO tlj_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Ooye mu kighegha ekili mu maaso ghaa Mukama, mugaati̱ ghumui oghutalimu ki̱tu̱mbi̱so. Ooyemu dhee mugaati̱ ghumui oghu̱teeki̱ye na mafu̱ta kandi ooyemu dhee na capati esi̱i̱ghi̱yʼo mafu̱ta. ");
INSERT INTO tlj_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Ebi byona obikwati̱ye mu ngalo Alooni̱ na batabani̱ be kandi babi̱i̱mu̱ki̱ye nga kihonguwa baamu̱ki̱i̱ye ewaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Du̱mbi̱ obiiye mu ngalo syabo kandi obyokeli̱ye haa kyakuhongelʼo bihonguwa haagu̱u̱li̱ ya kihonguwa kyona kyokeei̱ye, niikuwo kibe kihonguwa kyokeei̱ye kyona mu maaso ghaa Mukama, eki kusasa kwakiyo ku̱mu̱dheedhi̱ye. Ni kihonguwa bookeei̱ye haa mulilo kya Mukama. ");
INSERT INTO tlj_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Okwate mbanda ya ntu̱u̱li̱ ya ntaama ya mukolo ghwa ku̱lu̱wi̱ka Alooni̱ bu̱hongi̱ kandi oghi̱i̱mu̱ki̱ye nga kihonguwa baamu̱ki̱i̱ye mu maaso ghaa Mukama kandi mbanda eghi oghitwale. ");
INSERT INTO tlj_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Haa mukolo ghwa ku̱lu̱wi̱ka mu̱hongi̱, mbanda na kibelo kya ntu̱u̱li̱ ya ntaama ebi baakoleeseei̱ye, babi̱i̱mu̱ki̱yaghe kubihaayo ewanje nga kisembo kya mbaghani̱ja kandi ghubaaghe mughabo ghwa Alooni̱ na batabani̱ be. ");
INSERT INTO tlj_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Banai̱saaleeli̱ balakahaaghayo bihonguwa bya bu̱si̱nge ewaa Mukama, kagungu na kibelo bya kisolo eki bibaaghe mughabo ghwa bahongi̱ kandi eki nkilaghilo naataayʼo ekitaakuhinduka. ");
INSERT INTO tlj_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Alooni̱ naaku̱u̱ye, bi̱lu̱waalo biye bi̱hi̱ki̱li̱i̱ye bya bu̱hongi̱ babibiikile batabani̱ be kandi babi̱lu̱waale mabalu̱wi̱ka kuba bahongi̱. ");
INSERT INTO tlj_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Mutabani̱ wee oghu akukuuka mu ki̱i̱kalo kiye nga mu̱hongi̱, obu alaghendagha mu weema ya kusanga-sangaanamu kukola mulimo mu Ki̱i̱kalo Ki̱hi̱ki̱li̱i̱ye, abi̱lu̱waalaghe haabwa bilo musanju̱. ");
INSERT INTO tlj_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Okwate nyama sya ntu̱u̱li̱ ya ntaama eghi baakoleeseei̱ye ku̱lu̱wi̱ka Alooni̱ na batabani̱ be kuba bahongi̱ kandi nyama esi ositeekele mu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye kya mbaghani̱ja kya hanjaakati eghi. ");
INSERT INTO tlj_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Alooni̱ na batabani̱ be baliye nyama sya ntu̱u̱li̱ ya ntaama esi na migaati̱ eghi eli mu kighegha. Babiliile haa mulyango ghwa weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Baliye byokuliya ebyahongeeu̱we ebi haabwa mukolo ghwa kughaniluwa bibhi byabo mabalu̱wi̱ka kandi mabeeli̱ya kuba bahongi̱, oghu atali mu̱hongi̱ ataliya haa byokuliya ebi, nanga bi̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Kaakuba nyama sya ntu̱u̱li̱ ya nte kedha migaati̱ ebyakoleesebeeu̱we haa mukolo ghwa ku̱lu̱wi̱ka bahongi̱ oghu bilaalʼo ku̱hi̱ki̱ya nkyambisi, obyoki̱ye na mulilo, byokuliya ebi bitaliibuwa, nanga bi̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Mukolo ghwa ku̱lu̱wi̱ka Alooni̱ na batabani̱ be kuba bahongi̱ oghukole ngoku naakulaghiiye kandi ghumale bilo musanju̱. ");
INSERT INTO tlj_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Mu bilo musanju̱ ebi ohongaghe bu̱li̱ kilo ntu̱u̱li̱ ya nte nga kihonguwa kya mukolo ghwa kughaniluwa bibhi bya bantu aba kandi osiighaghe mafu̱ta haa kyakuhongelʼo bihonguwa ku̱kyeli̱ya. ");
INSERT INTO tlj_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Okole eki bu̱li̱ kilo haabwa bilo musanju̱, du̱mbi̱ kyakuhongelʼo bihonguwa eki kikuba kyeli̱ye kwonini kandi muntu kedha kintu kyona eki̱ku̱ku̱mʼo kikufooka ki̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Bini niibiyo oli na kuhongela haa kyakuhongelʼo bihonguwa eki bu̱li̱ kilo: byana bya ntaama bibili bya mwaka ghumui. ");
INSERT INTO tlj_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Kyana kya ntaama kimui okihongaghe nkyambisi na kinji okihongaghe lwagholo. ");
INSERT INTO tlj_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Nkyambisi kyana kya ntaama kyʼoku̱du̱bha okihongaghe na ki̱lo emui ya nsyano esemeeye, eghi etabuuyemu li̱ta emui ya mafu̱ta ghaa biti oli̱va. Ohongaghe dhee li̱ta emui ya vi̱i̱ni̱, kuba kihonguwa kyakunuwa. ");
INSERT INTO tlj_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ohongaghe kyana kya ntaama kinji lwagholo kandi okihongaghe na kihonguwa kya bilimuwa, mafu̱ta ghaa biti oli̱va na vi̱i̱ni̱ ebyengaane na bya nkyambisi. Eki kibe kihonguwa bookeei̱ye haa mulilo, eki kusasa kwakiyo ku̱dheedhi̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Mu mijo yaanu yoona muhongaghe kihonguwa kyona kyokeei̱ye eki ewaa Mukama haa mulyango ghwa weema ya kusanga-sangaanamu, hambali ndasanga-sangaanagha naanu ku̱bu̱gha naanu. ");
INSERT INTO tlj_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Mu ki̱i̱kalo eki niiyo ndasanga-sangaanagha na bantu baa I̱saaleeli̱ kandi ki̱ti̱i̱ni̱sa kyanje kilafoolagha ki̱i̱kalo eki kuba ki̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Weema ya kusanga-sangaanamu na kyakuhongelʼo bihonguwa ndabyeli̱yagha. Alooni̱ na batabani̱ be ndabeeli̱yagha dhee, niikuwo bampeeleli̱yaghe nga bahongi̱. ");
INSERT INTO tlj_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Nkuukala hamui na Banai̱saaleeli̱ kandi nkuba Luhanga wabo. ");
INSERT INTO tlj_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Bakumanya ngoku ndi Mukama Luhanga wabo, oghu akabaaya mu nsi ya Mi̱si̱li̱ niikuwo ngubhe kuukala nabo. Ni̱i̱si̱ye Mukama Luhanga wabo.” ");
INSERT INTO tlj_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Okole kyakuhongelʼo bihonguwa kyaku̱tu̱mi̱kʼo bubbani̱ mu ki̱i̱lu̱mbo kandi kyona kyengana-ngana. ");
INSERT INTO tlj_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Kujamba kwakiyo fu̱u̱ti̱ emui nʼeki̱twi̱ke, kugbaatikana kwakiyo fu̱u̱ti̱ emui nʼeki̱twi̱ke kandi kukangama kwakiyo fu̱u̱ti̱ esatu. Mahembe ghaakiyo anaa ghalu̱ghe mu ki̱twi̱ke eki kyonini. ");
INSERT INTO tlj_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Oki̱swi̱ki̱le na feeja esemeeye haagu̱u̱li̱ yakiyo, haa mpande syakiyo syona na haa mahembe ghaakiyo kandi okyeli̱ghi̱i̱li̱li̱ye na mugoma ghwa feeja. ");
INSERT INTO tlj_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Okikolele mpete ebili sya feeja kandi osite hansi ya mugoma ghwa feeja haa mpande ebili mu maakpengbu̱ hambali bakuta mpaghi esi balakiheekelaghʼo. ");
INSERT INTO tlj_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Mpaghi esi osikole mu ki̱i̱lu̱mbo kandi osi̱swi̱ki̱le na feeja. ");
INSERT INTO tlj_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ote kyaku̱tu̱mi̱kʼo bubbani̱ enja ya kateni̱ eghi eli mu maaso ghaa sandu̱u̱ku̱ ya ndaghaano na kyakughaniililʼo bantu bibhi eki̱swi̱ki̱ye haagu̱u̱li̱ yayo, hambali ndasanga-sangaanagha naawe. ");
INSERT INTO tlj_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Bu̱li̱ nkyambisi obu Alooni̱ alaasagha kuteekani̱ja taala, atu̱mi̱kaghʼo bubbani̱ busasi̱ye kulungi. ");
INSERT INTO tlj_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Alooni̱ ali na ku̱tu̱mi̱ka dhee bubbani̱ bu̱li̱ lwagholo obu alabaagha naabhaki̱ya taala, bubbani̱ obu buukalaghe bwaki̱ye mu maaso ghaa Mukama mu mijo yaanu yoona. ");
INSERT INTO tlj_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Haa kyaku̱tu̱mi̱kʼo bubbani̱ eki, otali̱tu̱mi̱kʼo bubbani̱ obutasi̱i̱mi̱lani̱bu̱u̱we kedha kuhongelʼo kihonguwa kyona kyokeei̱ye, kedha kihonguwa kya bilimuwa kandi otaliseesʼo kihonguwa kyakunuwa. ");
INSERT INTO tlj_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Alooni̱ akolaghe mukolo ghwa kweli̱ya kyaku̱tu̱mi̱kʼo bubbani̱ eki mulundi ghumui mu mwaka. Asiighaghe haa mahembe ghaakiyo saghama ya kisolo eki baahongi̱ye haabwa mukolo ghwa kughaniluwa bibhi byabo mulundi ghumui bu̱li̱ mwaka mu mijo yaanu yoona, nanga kyaku̱tu̱mi̱kʼo bubbani̱ eki ki̱hi̱ki̱li̱i̱ye kwonini ewaa Mukama.” ");
INSERT INTO tlj_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Obu okuba noobala bantu baa I̱saaleeli̱, bu̱li̱ muntu aheyo ewaa Mukama sente sya kucungula bwomi̱i̱li̱ buwe, niikuwo kifubilo kya ndwala kitabahi̱kʼo obu okuba noobabala. ");
INSERT INTO tlj_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Bu̱li̱ muntu oghu balakabalagha, ali na kuhaayo kimui kyakabili kya mukwenge ghwa siliva kusighikila haa ki̱pi̱i̱mo kya siliva mu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye, bu̱li̱ muntu ali na kuhaayo sente esi nga kihonguwa ewaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Muntu weena oghu bakubala mu kubaluwa oku, oghu ali na myaka maku̱mi̱ abili ya bukulu na kusaalʼo, ali na kuhaayo kihonguwa kya Mukama eki. ");
INSERT INTO tlj_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Baguudha batahayo sisaayʼo kandi banaku batahayo esili hansi ya kimui kyakabili kya mukwenge oghu, obu mulabaagha nimuhayo kihonguwa ewaa Mukama. Sente esi ni muhendo oghu bu̱li̱ muntu ali na kusasula haabwa kughaniluwa kwa bwomi̱i̱li̱ buwe. ");
INSERT INTO tlj_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Oli na kukumaani̱ya sente esi ku̱lu̱gha mu Banai̱saaleeli̱ kandi osi̱koleesi̱ye milimo yʼomu weema ya kusanga-sangaanamu. Sente esi silalekagha Mukama aasukaghe ngoku Banai̱saaleeli̱ baasasuuye haabwa kughaniluwa kwa bwomi̱i̱li̱ bwabo.” ");
INSERT INTO tlj_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Okole bbaafu ya bbu̱looji̱ ya kunaabilamu na kyakughitʼo kya bbu̱looji̱. Oghite haagati ya weema ya kusanga-sangaanamu na kyakuhongelʼo bihonguwa kandi ote maasi mu bbaafu eghi. ");
INSERT INTO tlj_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Alooni̱ na batabani̱ be bali na kunaaba maasi agha mu ngalo syabo na mu bighele. ");
INSERT INTO tlj_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Obu balabaagha mbaghenda mu weema ya kusanga-sangaanamu, kedha mbeebinga haa kyakuhongelʼo bihonguwa kukola mulimo kedha kuhongela Mukama bihonguwa bookeei̱ye haa mulilo, badu̱bhaghe banaabe maasi agha, niikuwo bataku̱wa. ");
INSERT INTO tlj_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Bali na kunaaba mu ngalo syabo na mu bighele byabo, niikuwo bataku̱wa. Kini kili na kuba kilaghilo kya bilo nʼebilo ewaa Alooni̱ na baasukulu be mu mijo yabo yoona.” ");
INSERT INTO tlj_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Okole mafu̱ta ku̱lu̱gha mu bintu bisasi̱ye bini: ki̱lo mukaagha sya mafu̱ta ghaa miila, ki̱lo esatu sya nsyano esasi̱ye kinamooni̱, ki̱lo esatu ku̱lu̱gha mu bikaka bisasi̱ye, ");
INSERT INTO tlj_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","na ki̱lo mukaagha sya nsyano esasi̱ye bakughilaghamu kaasiya kandi li̱ta enaa sya mafu̱ta ghaa biti oli̱va, kusighikila haa bi̱pi̱i̱mi̱si̱yo byʼomu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Bintu ebi obbale muntu oghu amani̱ye kubitabula kusemeeye, abikolemu bigita bisasi̱ye bya maasi kandi bibe mafu̱ta ghaa kusiigha ghahi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Mafu̱ta agha oghasiighe haa weema ya kusanga-sangaanamu, sandu̱u̱ku̱ ya ndaghaano, ");
INSERT INTO tlj_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","haa meeja na bintu byayʼo byona, haa kyakutʼo taala na bi̱twi̱ke byakiyo na kyaku̱tu̱mi̱kʼo bubbani̱. ");
INSERT INTO tlj_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Oghasiighe haa kyakuhongelʼo bihonguwa byona byokeei̱ye na bintu byakiyo byona kandi haa bbaafu na kyakughitʼo. ");
INSERT INTO tlj_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Bintu ebi byona obyeli̱ye niikuwo bibe bi̱hi̱ki̱li̱i̱ye kwonini. Kintu kyona ekilabi̱ku̱maghʼo kilafookagha ki̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Alooni̱ na batabani̱ be obasiighe mafu̱ta agha kandi obeeli̱ye, niikuwo bagubhe ku̱mpeeleli̱ya nga bahongi̱. ");
INSERT INTO tlj_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Oghile bantu baa I̱saaleeli̱ oti, ‘Mafu̱ta ghaa kusiigha ghani ghalabaagha mafu̱ta ghanje ghahi̱ki̱li̱i̱ye mu mijo yaanu yoona. ");
INSERT INTO tlj_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Mutalighasiighʼo muntu wa bu̱li̱ kilo kandi otalikola mafu̱ta ghanji aghasu̱si̱ye nga mafu̱ta agha ku̱lu̱gha mu bintu ngʼebi waakoleeseei̱ye. Mafu̱ta ghani ghahi̱ki̱li̱i̱ye kandi ghali na kuba ghahi̱ki̱li̱i̱ye kwonini ewaanu. ");
INSERT INTO tlj_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Muntu weena oghu alakolagha mafu̱ta aghasu̱si̱ye ghani kedha aghasiigha muntu oghu atali mu̱hongi̱, bamubhingaghe mu bantu banje.’ ” ");
INSERT INTO tlj_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Mukama aaghila Musa ati, “Okwate bi̱lu̱ngi̱yo bisasi̱ye kulungi sitakite, onu̱ka, galibanu̱mu̱, obitabulani̱ye na bubbani̱ busemeeye kandi byona byengaane. ");
INSERT INTO tlj_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Oghile muntu oghu amani̱ye kubitabula abikolemu bubbani̱ busasi̱ye kandi otemu kisula niikuwo buukale busemeeye kandi bu̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Bimui haa bintu ebi obisiyemu nsyano esemeeye kandi oghite mu maaso ghaa sandu̱u̱ku̱ ya ndaghaano mu weema ya kusanga-sangaanamu, hambali ndasanga-sangaanagha naawe. Bubbani̱ obu bube bu̱hi̱ki̱li̱i̱ye kwonini ewaanu. ");
INSERT INTO tlj_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Muntu atali̱koleesi̱ya bintu ebi kwekolela bubbani̱ busasi̱ye obu. Bwile bwona mu̱bweli̱li̱kanaghʼo nga bubbani̱ bu̱hi̱ki̱li̱i̱ye bwa Mukama. ");
INSERT INTO tlj_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Weena oghu akwekolela bigita bisasi̱ye kwonini nga ebi, abhinguwe mu bantu banje.” ");
INSERT INTO tlj_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Naakomi̱ye Bbejaleeli̱ mutabani̱ wa U̱li̱, muusukulu wa Hula, wʼomu ntu̱la ya Yu̱da. ");
INSERT INTO tlj_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Naaleki̱ye mwoyo wanje aamwisʼo kwonini, naamuhaaye magheji, kwetegheeleli̱ya kandi naamufoola oghu amani̱ye kukola bintu bya ngalo. ");
INSERT INTO tlj_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Akugubha kukola bintu bisemeeye ku̱lu̱gha mu feeja, siliva na bbu̱looji̱. ");
INSERT INTO tlj_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Akugubha kubhaaka mabaale kandi kughata mu buufuleemu bwa feeja, kulanda mbaau kandi kukola bu̱li̱ mulimo ghwona ghwa ngalo. ");
INSERT INTO tlj_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Naakomi̱ye dhee Oholi̱yaabbu, mutabani̱ wa Ahisamaki̱, wʼomu ntu̱la ya Daani̱, kukola hamui na Bbejaleeli̱. Naahaaye magheji bantu boona abakwete kukola milimo ya ngalo, niikuwo bagubhe kukola byona ebi naakulaghiiye. ");
INSERT INTO tlj_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Bakukola weema ya kusanga-sangaanamu, sandu̱u̱ku̱ ya ndaghaano, kyakughaniililʼo bantu bibhi, na bintu byona byʼomu weema eghi. ");
INSERT INTO tlj_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Bakukola dhee meeja na byaku̱koleesi̱yʼo, kyakutʼo taala kisemeeye na bintu byakiyo byona, kyaku̱tu̱mi̱kʼo bubbani̱, ");
INSERT INTO tlj_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","kyakuhongelʼo bihonguwa byona byokeei̱ye na bintu byakiyo byona, bbaafu na kyakughitʼo, ");
INSERT INTO tlj_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","bi̱lu̱waalo bi̱hi̱ki̱li̱i̱ye bya bu̱hongi̱ bya Alooni̱ na batabani̱ be ku̱lu̱waala mbakola mulimo ghwa bu̱hongi̱, ");
INSERT INTO tlj_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","mafu̱ta ghaa kusiigha na bubbani̱ busasi̱ye bwa ku̱tu̱mi̱ka mu Ki̱i̱kalo Ki̱hi̱ki̱li̱i̱ye. Bintu ebi byona babikole ngoku naakulaghiiye.” ");
INSERT INTO tlj_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Oghambile bantu baa I̱saaleeli̱ oti, ‘Mu̱hu̱ti̱yaghe kilo kyanje kya Sabhato, nanga kilo eki ni kaakulolelʼo haagati yanje naanu mu mijo yaanu yoona, niikuwo mugubhe kumanya ngoku ndi Mukama oghu akubafoolagha bahi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ ‘Muli na ku̱hu̱ti̱ya kilo kya Sabhato nanga ni kilo ki̱hi̱ki̱li̱i̱ye ewaanu. Muntu weena oghu akukola bintu bi̱bhi̱i̱hi̱ye haa kilo eki nʼoghu akukola mulimo ghwona haa kilo eki, aatibuwaghe. ");
INSERT INTO tlj_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Muli na bilo mukaagha bya kukola milimo yaanu yoona, bhaatu kilo kyamusanju̱ ni kilo kya Sabhato kya kuhuumula kandi ni kilo ki̱hi̱ki̱li̱i̱ye ewaa Mukama. Muntu weena oghu alakolagha mulimo haa kilo kya Sabhato eki, aatibuwaghe. ");
INSERT INTO tlj_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Nahabweki bantu baa I̱saaleeli̱ bali na ku̱hu̱ti̱ya kilo kya Sabhato, mu mijo yabo yoona, nga ndaghaano ya bilo nʼebilo. ");
INSERT INTO tlj_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Kilo eki nkaakulolelʼo kaa bilo nʼebilo haagati yanje na Banai̱saaleeli̱, nanga mu bilo mukaagha Mukama akahanga eghulu na nsi kandi haa kilo kyamusanju̱ ataakola kantu kandi aahuumula.’ ” ");
INSERT INTO tlj_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Obu Mukama aamali̱ye ku̱bu̱gha na Musa haa mwena Si̱naai̱, aaha Musa bihande bibili bya mabaale, ebi Luhanga eenini ahandi̱i̱ki̱yʼo bilaghilo. ");
INSERT INTO tlj_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Obu bantu baa I̱saaleeli̱ baaboone Musa ataku̱u̱ki̱ye bwangu ku̱lu̱gha haa mwena, beekumaani̱ya kandi baaghenda hambali Alooni̱ ali, baamughila bati, “Otukolele bisasani̱ bya baaluhanga aaniibiyo byaghendagha bituhikiiye, nanga Musa oghu akatuuya mu nsi ya Mi̱si̱li̱ tatumani̱ye hambali ali.” ");
INSERT INTO tlj_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Alooni̱ aabaghila ati, “Muuye mu matui mpete sya feeja esi bakali̱ baanu, batabani̱ baanu na bahala baanu balu̱weete, musindeetele.” ");
INSERT INTO tlj_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Nahabweki bantu aba boona baayamu mpete sya feeja esi baabaagha balu̱weete mu matui ghaabo kandi baasileetela Alooni̱. ");
INSERT INTO tlj_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Alooni̱ aakwata mpete esi, aasita haa mulilo syanuunuuta kandi asikolamu kisasani̱ kya kyana kya nte. Bantu aba baaghila bati, “Etu̱we Banai̱saaleeli̱, oni niiye luhanga waatu, oghu akatuuya mu nsi ya Mi̱si̱li̱!” ");
INSERT INTO tlj_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Obu Alooni̱ aaboone kisasani̱ kya kyana kya nte eki, aakwela kyakuhongelʼo bihonguwa mu maaso ghaakiyo kandi aalangilila bantu aba ati, “Munkiya tukukolela Mukama ki̱ghenu̱.” ");
INSERT INTO tlj_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Kilo ekyalabhi̱yʼo bantu aba baamuka nkyambisi cu̱i̱, baahonga bihonguwa byona byokeei̱ye na bihonguwa bya bu̱si̱nge. Bantu aba baakamali̱ye kuliya kandi kunuwa, du̱mbi̱ baatandika ku̱bi̱na. ");
INSERT INTO tlj_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Mukama aaghila Musa ati, “Okote bwangu, nanga bantu baawe waahi̱ye mu nsi ya Mi̱si̱li̱ beebhi̱hi̱i̱ye kwonini. ");
INSERT INTO tlj_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Baalu̱ghi̱ye bwangu haa ebi naabalaghiiye. Beekoleeye kisasani̱ kya kyana kya nte, baakilami̱i̱ye kandi baakihongela bihonguwa. Bakwete kughila bati, ‘Uwe I̱saaleeli̱, oni niiye luhanga waatu, oghu akatuuya mu nsi ya Mi̱si̱li̱!’ ” ");
INSERT INTO tlj_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Mukama aaghila Musa ati, “Olole, naaboone bantu aba, ni ntaaghu̱wa kwonini. ");
INSERT INTO tlj_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Nahabweki ondeke, nkwoleka bantu aba ngoku nsaaluuwe kwonini kandi nkubahwelekeeleli̱ya. Du̱mbi̱ nkukufoola ehanga lyamaani̱.” ");
INSERT INTO tlj_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Musa eesengeleli̱ya Mukama Luhanga wee ati, “Ai̱ Mukama, nkiki ki̱leki̱ye osaaluuwe otiyo na bantu baawe aba waahi̱ye mu nsi ya Mi̱si̱li̱ na bu̱toki̱ bwawe kandi mukono ghwawe ghwamaani̱? ");
INSERT INTO tlj_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Banami̱si̱li̱ bakughila bati, ‘Luhanga aahi̱ye Banai̱saaleeli̱ mu Mi̱si̱li̱ niikuwo agubhe kubaatila mu myena kandi kubamala munsi.’ Gutu oleke kusaaliluwa otiyo kandi otafubila bantu baawe aba. ");
INSERT INTO tlj_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Oosuke baheeleli̱ya baawe Ebbulahi̱mu̱, I̱saka na Yakobbo. Oosuke eki waalahiiye ewaabo ngoku okukani̱ya baasukulu baabo nga nsooli̱ya syʼomu mwanya. Okalaghi̱i̱sani̱ya ngoku baasukulu baabo bakutwala nsi eghi nga bugwetuwa bwabo bilo nʼebilo.” ");
INSERT INTO tlj_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Mukama aahindula byeli̱li̱kano biye, ataahwelekeeleli̱ya bantu be aba ngoku aabaagha abu̱ghi̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Musa aakota ku̱lu̱gha haa mwena oghu, akwete mu ngalo bihande bibili bya mabaale ebihandi̱i̱ki̱yʼo ndaghaano. Bihande bya mabaale ebi bikaba bihandi̱i̱ki̱ye haa mpande syombi. ");
INSERT INTO tlj_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Bihande bya mabaale ebi Luhanga eenini niiye akabibhaaka kandi aahandiikʼo bilaghilo na mukono ghuwe. ");
INSERT INTO tlj_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Obu Yosuwa aaghu̱u̱ye ngoku bantu bakwete ku̱bu̱gha nʼelaka lyamaani̱, aaghila Musa ati, “Ni̱i̱ghu̱u̱ye elaka lya bulemo hambali bantu baghooneeye.” ");
INSERT INTO tlj_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Bhaatu Musa aamughila ati, “Eli talili elaka lya bu̱si̱ngu̱li̱ kedha elaka lya ku̱si̱ngu̱wa, bhaatu ni̱i̱ghu̱u̱ye elaka lya bantu abakwete kulimba.” ");
INSERT INTO tlj_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Obu Musa eebi̱ngi̱ye hambali bantu aba baghooneeye kandi naabona kyana kya nte eki na bantu abakwete ku̱bi̱na, aasaaliluwa kwonini. Musa aakuba hansi bihande bya mabaale ebi mu nti̱na ya mwena oghu kandi aabyatakaki̱ya. ");
INSERT INTO tlj_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Aakwata kyana kya nte eki baakoli̱ye, aakyoki̱ya mu mulilo kandi aakisiya kyafooka tu̱u̱tu̱. Aaseesa tu̱u̱tu̱ eghi mu maasi kandi aalaghila Banai̱saaleeli̱ aba kughanuwa. ");
INSERT INTO tlj_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Musa aaghila Alooni̱ ati, “Bantu aba baaku̱koli̱ye ki kubaleetʼo kibhi kyamaani̱ kitiyo?” ");
INSERT INTO tlj_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Alooni̱ aaghila Musa ati, “Wai̱tu̱, otasaaliluwa munu otiyo. Omani̱ye ngoku bantu aba bakukolagha bwangu bintu bi̱bhi̱i̱hi̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Bantu aba niibo bangi̱li̱ye bati, ‘Otukolele bisasani̱ bya baaluhanga aaniibiyo byaghendagha bituhikiiye, nanga Musa oghu akatuuya mu nsi ya Mi̱si̱li̱ tatumani̱ye hambali ali.’ ");
INSERT INTO tlj_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Nahabweki naabaghila nti, ‘Muntu weena oghu alu̱wete mu matui mpete ya feeja aaghiiyemu kandi aghindeetele.’ Baasiiyamu kandi baasindeetela, du̱mbi̱ naasikuba mu mulilo, syalu̱ghamu kyana kya nte kini.” ");
INSERT INTO tlj_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Obu Musa aamani̱ye ngoku Alooni̱ aaleteli̱i̱je bantu aba kufooka ntaaghu̱wa, abataakugubha kwelinda kandi kuleka ngi̱ghu̱ syabo nsibasekeelela, ");
INSERT INTO tlj_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","du̱mbi̱ Musa eemilila haa geeti̱ ya hambali bantu aba baghooneeye kandi aabu̱gha nʼelaka lyamaani̱ ati, “Muntu weena oghu ali haa luhande lwa Mukama aase hambali ndi.” Bantu boona bʼomu ntu̱la ya Leevi̱ baasa hambali ali. ");
INSERT INTO tlj_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Musa aaghila bantu bʼomu ntu̱la ya Leevi̱ aba ati, “Mukama Luhanga wa I̱saaleeli̱ akwete kughila ati, ‘Bu̱li̱ muntu akwate kihiyo kiye, mughende hoona hambali bantu aba baghooneeye, mu̱lu̱ghaghe haa geeti̱ emui mughendaghe haa geeti̱ enji. Bu̱li̱ muntu aate mwana waa ni̱na wee, bhootu̱ siye kandi muliilanuwa wee.’ ” ");
INSERT INTO tlj_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Bantu bʼomu ntu̱la ya Leevi̱ aba baakola ngoku Musa aabalaghiiye. Kilo eki baata bantu nku̱mi̱ esatu. ");
INSERT INTO tlj_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Musa aabaghila ati, “Obwalo mwehaayeyo ku̱heeleli̱ya Mukama, nanga bu̱li̱ omui mu enu̱we aatu̱u̱yemu kwita mutabani̱ wee kedha mwana waa ni̱na wee, nahabweki obwalo aabahaaye mu̱gi̱sa.” ");
INSERT INTO tlj_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Kilo ekyalabhi̱yʼo Musa aaghila bantu baa I̱saaleeli̱ ati, “Mwakoli̱ye kibhi kyamaani̱. Bhaatu nkukuuka ewaa Mukama kulola nkaakuba ndi nʼeki nkugubha kukola eye kubaghanila kibhi kyanu.” ");
INSERT INTO tlj_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Nahabweki Musa aakuuka ewaa Mukama aamughila ati, “Bantu aba baakoli̱ye kibhi kyamaani̱. Beekoleeye baaluhanga baa feeja. ");
INSERT INTO tlj_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Gutu, nkwesengeleei̱ye obaghanile kibhi kyabo eki, bhaatu nuwaabhengi̱ye, onjiye mu kitabo eki ohandi̱i̱ki̱yemu mali̱i̱na ghaa bantu baawe.” ");
INSERT INTO tlj_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Mukama aaghila Musa ati, “Muntu weena oghu aasi̱i̱si̱ye ewanje, niiye nkuuya mu kitabo kyanje. ");
INSERT INTO tlj_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Bhaatu oghende ohikile bantu aba kandi obatwale mu ki̱i̱kalo eki naakughambiiye. Malai̱ka wanje akughenda akuhikiiye. Bhaatu bwile bu̱ku̱hi̱ka obu nkufubila bantu aba haabwa kibhi kyabo.” ");
INSERT INTO tlj_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Mukama aaha bantu aba kifubilo kya ndwala, nanga ebo kulami̱ya kisasani̱ kya kyana kya nte eki Alooni̱ aakoli̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Mukama aaghila Musa ati, “Olu̱ghe hani, na bantu waahi̱ye Mi̱si̱li̱, oghende mu nsi eghi naalahiiye kuha Ebbulahi̱mu̱, I̱saka na Yakobbo na baasukulu baabo. ");
INSERT INTO tlj_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Nkutuma malai̱ka kukuhikila kandi nkuleka obhinge mu nsi eghi Banakanaani̱, Bamooli̱, Bahi̱ti̱, Bapeleeji̱, Bahi̱vi̱ na Bayebu̱si̱. ");
INSERT INTO tlj_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Oghende mu nsi eghi ekwete kusendamu mata na bwoki, bhaatu tankughenda naanu, nangubahwelekeeleli̱ya mu kihanda, nanga muli bantu ntaaghu̱wa.” ");
INSERT INTO tlj_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Obu bantu aba baaghu̱u̱ye bighambo bisaakaaye ebi, beeghunga kandi baaleka ku̱lu̱waala bukwanji bwabo kwoleka ngoku basaaluuwe kwonini. ");
INSERT INTO tlj_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Nanga Mukama akaba naaghi̱li̱ye Musa ati, “Oghile bantu baa I̱saaleeli̱ oti, ‘Muli bantu ntaaghu̱wa, ninaaghendi̱ye naanu bwile bukee bwonkaha, nkubahwelekeeleli̱ya. Nahabweki mwehiyemu bintu bisemeeye ebi mu̱lu̱weete, niikuwo ndole eki nkubakolela.’ ” ");
INSERT INTO tlj_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Obu Banai̱saaleeli̱ baalu̱ghi̱ye haa mwena Holebbu, tabaatodhi̱ye balu̱wala bintu bisemeeye ebi. ");
INSERT INTO tlj_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Nahabweki Banai̱saaleeli̱ baakaghoonagha mu ki̱i̱kalo, Musa aatwalagha weema kandi aghikwela enja ya hambali baghooneeye, hambali haseli̱yʼo kandi aaghila ati, “Eni ni weema ya kusanga-sangaanamu na Mukama.” Muntu weena aakabaagha ali nʼeki akubbala kwebu̱u̱li̱yʼo Mukama, aaghendagha mu weema eghi. ");
INSERT INTO tlj_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Bwile bwona, Musa aakabaagha naalu̱gha hambali bantu aba baghooneeye kughenda mu weema eghi, bantu boona baamuka kandi bu̱li̱ muntu aamilila haa mulyango ghwa weema yee, baakala bamu̱loli̱ye ku̱hi̱ki̱ya ataahi̱ye mu weema eghi. ");
INSERT INTO tlj_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Musa aakataahagha mu weema eghi, mpaghi ya kicu esu̱ndu̱ka yeemilila haa mulyango ghwa weema eghi kandi Mukama aatandika ku̱bu̱gha na Musa. ");
INSERT INTO tlj_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Bantu aba boona baakabonagha mpaghi ya kicu yeemiliiye haa mulyango ghwa weema eghi, boona baamuka kandi bu̱li̱ muntu atandika kulami̱li̱ya haa mulyango ghwa weema yee. ");
INSERT INTO tlj_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Mukama aabu̱ghagha na Musa ngoku muntu aku̱bu̱ghagha na bhootu̱ siye. Musa aakakuukagha hambali bantu baghooneeye, mutabhana Yosuwa oghu aamukoonelagha haa mulimo, mutabani̱ wa Nu̱u̱ni̱, ati̱ghala haa weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa aaghila Mukama ati, “Olole, nuuwe okangila oti, ‘Otwale bantu aba,’ bhaatu tawangambiiye oghu okutuma kughenda nanje. Okangila oti, ‘Omani̱ye si̱ye kandi nkukolagha ebi̱ku̱dheedhi̱ye.’ ");
INSERT INTO tlj_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Nahabweki nkaakuba ninkukolagha ebi̱ku̱dheedhi̱ye, onjoleke bikoluwa byawe, niikuwo nkumanye kandi neeyongele kukola ebi̱ku̱dheedhi̱ye. Oosuke ngoku waakomi̱ye bantu bani kuba ehanga lyawe.” ");
INSERT INTO tlj_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Mukama aaghila ati, “Nkughenda naawe kandi nkukuha kuhuumula.” ");
INSERT INTO tlj_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musa aaghila Mukama ati, “Okaakuba otaakughenda naatu, otatu̱si̱i̱mi̱lani̱ya ku̱lu̱gha hani. ");
INSERT INTO tlj_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Buuye otaaghendi̱ye naatu, bantu bakumanya bati̱ya ngoku si̱ye na bantu baawe tukukolagha ebi̱ku̱dheedhi̱ye? Nkintu ki kinji ekikwoleka ngu si̱ye na bantu baawe tuli baa mbaghani̱ja na bantu banji boona bʼomu nsi?” ");
INSERT INTO tlj_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Mukama aaghila Musa ati, “Kintu eki waabu̱ghi̱ye kyonini niikiyo nkukola, nanga okukolagha ebi̱ndheedhi̱ye kandi nkumani̱ye kwonini.” ");
INSERT INTO tlj_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Musa aaghila ati, “Gutu onjoleke ki̱ti̱i̱ni̱sa kyawe.” ");
INSERT INTO tlj_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Mukama aaghila ati, “Nkusaalila mu maaso ghaawe obone bulungi bwanje bwona kandi nkukughambila li̱i̱na lyanje. Ni̱i̱si̱ye Mukama. Nkughilila ngughuma oghu mbbali̱ye kughilila ngughuma kandi nkughilila kisa oghu mbbali̱ye kughilila kisa. ");
INSERT INTO tlj_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Bhaatu tookumbona haali̱i̱so, nanga muntu namboone taakuukala ali mwomi̱i̱li̱.” ");
INSERT INTO tlj_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Mukama aatodha aaghila ati, “Haai nanje haliyo kikuka, oghende weemilile haa kikuka eki. ");
INSERT INTO tlj_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Obu nkuba ninsaala mu ki̱ti̱i̱ni̱sa kyanje, nkukuta hambali kikuka kyati̱ki̱ye kandi nku̱ku̱swi̱ki̱la na mukono ghwanje, ku̱hi̱ki̱ya nimali̱ye kusaala. ");
INSERT INTO tlj_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Du̱mbi̱ nkuuyʼo mukono ghwanje obone mughongo ghwanje, bhaatu tookumbona haali̱i̱so.” ");
INSERT INTO tlj_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Mukama aaghila Musa ati, “Obhaake bihande bibili bya mabaale ebi̱su̱si̱ye ngʼebi waadu̱bhi̱ye kubhaaka. Nkuhandiikʼo bighambo ngʼebi naadu̱bhi̱ye kuhandiika haa bihande bibili bya mabaale byʼoku̱du̱bha ebi waatakaki̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Munkiya nkyambisi weeteekani̱je kandi oni̱i̱ne haa mwena Si̱naai̱ kandi kwisa kunsanga-sangaana haa haagu̱u̱li̱ ya mwena oghu. ");
INSERT INTO tlj_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Muntu nʼomui ataasa naawe kandi muntu nʼomui ataboneka haa mwena oghu. Otasi̱i̱mi̱lani̱ya ntaama, mbu̱li̱ kedha nte kuliila haai na mwena oghu.” ");
INSERT INTO tlj_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Nahabweki Musa aabhaaka bihande bibili bya mabaale nga byʼoku̱du̱bha. Aamuka nkyambisi cu̱i̱ kandi aani̱i̱na haa mwena Si̱naai̱, ngoku Mukama aamulaghiiye. Aaghenda akwete mu ngalo bihande bibili bya mabaale ebi. ");
INSERT INTO tlj_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Mukama aasu̱ndi̱ki̱la mu kicu kandi eemilila haai na Musa, aamughambila ngoku li̱i̱na liye aniiye Mukama. ");
INSERT INTO tlj_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Mukama aasaalila mu maaso ghaa Musa naalangilila ati, “Ni̱i̱si̱ye Mukama, Mukama Luhanga oghu ali na kisa kandi ngughuma. Tankusaaliluwagha bwangu, ndi na kukunda kwamaani̱ kandi bwesighibuwa. ");
INSERT INTO tlj_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Nkughililagha kukunda kwamaani̱ nku̱mi̱ na nku̱mi̱ sya bantu kandi nkughanilagha bantu bintu bi̱bhi̱i̱hi̱ye ebi bakukolagha, nsobi̱ syabo na kibhi. Bhaatu nkufubilagha baana haabwa bintu bi̱bhi̱i̱hi̱ye ebi beesebo bakukolagha ku̱hi̱ki̱ya haa mujo ghwakasatu na ghwakanaa ghwa baasukulu baabo.” ");
INSERT INTO tlj_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Du̱mbi̱ Musa aalangaala bwangu hansi makpu̱ngbu̱ kandi aatandika kulami̱ya. ");
INSERT INTO tlj_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Aaghila ati, “Ai̱ Mukama nkaakuba ninkukolagha ebi̱ku̱dheedhi̱ye, gutu oghende naatu, nankabha bantu aba bali ntaaghu̱wa, otughanile bikoluwa byatu bi̱bhi̱i̱hi̱ye na kibhi kyatu kandi otu̱si̱i̱mi̱lani̱ye kuba bugwetuwa bwawe.” ");
INSERT INTO tlj_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Mukama aaghila ati, “Ndimakola ndaghaano na Banai̱saaleeli̱. Nkukola byakuswekani̱ya byamaani̱ banaloli̱ye ebitakakoluwagha mu bantu baa munsi yoona. Bantu boona bakubona byakuswekani̱ya ebi si̱ye Mukama nkukola nanga nkughenda kukola kintu haabwanu ekikuleka bantu boona boobahe. ");
INSERT INTO tlj_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Okwate ebi nkukulaghila obwalo kandi nkubhinga onaloli̱ye Bamooli̱, Banakanaani̱, Bahi̱ti̱, Bapeleeji̱, Bahi̱vi̱ na Bayebu̱si̱. ");
INSERT INTO tlj_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Weeghendeseleje kandi otakola ndaghaano ya bu̱si̱nge na bantu abaakaaye mu nsi hambali okughenda, nanga ekufookela ki̱ki̱ya. ");
INSERT INTO tlj_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Mugenge hansi byakuhongelʼo bihonguwa byabo, muhenange mpaghi sya baaluhanga baabo kandi mujombakake mpaghi sya luhanga wabukali̱ Asela. ");
INSERT INTO tlj_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Otalilami̱ya luhanga onji, nanga Mukama oghu li̱i̱na liye aniiye Etima, ni Luhanga wʼetima. ");
INSERT INTO tlj_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Otakola ndaghaano ya bu̱si̱nge na bantu abaakaaye mu nsi eghi, nanga mbaabaaye mbeefoola baamalaaya mu kulami̱ya baaluhanga baabo kandi mbabahongela bihonguwa, bakukubilikila kuliya haa byokuliya ebi bahongeeye baaluhanga baabo. ");
INSERT INTO tlj_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Batabani̱ baawe banguswela bahala baa bantu aba kandi bakali̱ baabo aba mbabaaye mbeefoola baamalaaya mu kulami̱ya baaluhanga baabo, bakugubha kusoona-soona batabani̱ baawe kufooka baamalaaya mu kulami̱ya baaluhanga baabo aba. ");
INSERT INTO tlj_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Otalyekolela baaluhanga ku̱lu̱gha mu byoma. ");
INSERT INTO tlj_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Okolaghe Ki̱ghenu̱ kya Migaati̱ Etalimu Ki̱tu̱mbi̱so. Haa bwile obu oliyaghe migaati̱ etalimu ki̱tu̱mbi̱so haabwa bilo musanju̱ ngoku naakulaghiiye. Okolaghe ki̱ghenu̱ eki haa bwile bwakiyo bwonini mu kweli̱ kwa Abi̱bu̱, nanga mu kweli̱ oku niibuwo waalu̱ghi̱ye Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Bu̱li̱ mwana waanu wabusaasa mu̱li̱ghaaso alabaagha wanje, na mi̱li̱ghaaso yoona yabusaasa ya nte, ntaama na mbu̱li̱ syanu. ");
INSERT INTO tlj_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Mu̱li̱ghaaso ghwabusaasa ghwa kyana kya ndogooi̱ mukisasuulilaghe nimuhonga kyana kya ntaama. Bhaatu kaakuba mutakola eki, mukihende bikiya. Muli na kusasula haabwa baana baanu baabusaasa mi̱li̱ghaaso. “Hatabʼo muntu nʼomui oghu akwisa mu maaso ghanje atali na kantu. ");
INSERT INTO tlj_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Oli na bilo mukaagha bya kukola milimo yaawe, bhaatu haa kilo kyamusanju̱ oli na kuhuumula. Kilo eki mu bwile bwa kukola na bwa kukesa oli na kuhuumula. ");
INSERT INTO tlj_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Mukolaghe Ki̱ghenu̱ kya Kukesa, nimuleeta mughanulo ghwa ngano mwakesi̱ye kandi mukolaghe Ki̱ghenu̱ kya kulaala mu Bujalaja haa kumaliilila kwa kukesa bu̱li̱ mwaka. ");
INSERT INTO tlj_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Baana baawe baabusaasa boona baasaghe milundi esatu bu̱li̱ mwaka mu maaso ghaa Mukama Luhanga wa I̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Nkuleka obhinge bantu bʼomu mahanga agha kandi nkugbaatikani̱ya mitaano yaawe. Taaliyo muntu nʼomui oghu akwekumbula nsi yaawe, obu olabaagha oghendi̱ye mu maaso ghaa Mukama Luhanga waawe milundi esatu mu mwaka. ");
INSERT INTO tlj_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Otampongelagha saghama ya kihonguwa kyanje na migaati̱ elimu ki̱tu̱mbi̱so, kedha kubiika haa byokuliya bya Ki̱ghenu̱ kya Kusaaluwʼo ku̱hi̱ki̱ya nkyambisi. ");
INSERT INTO tlj_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Oleetaghe mughanulo ghwa bilimuwa byawe mu numba ya Mukama Luhanga waawe. “Kyana kya mbu̱li̱ otali̱ki̱teeki̱ya mati̱i̱ti̱ ghaa ni̱naakiyo.” ");
INSERT INTO tlj_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Mukama aaghila Musa ati, “Ohandiike bighambo ebi naakughambiiye, nanga niibiyo ndaghaano eghi naakoli̱ye naawe na Banai̱saaleeli̱.” ");
INSERT INTO tlj_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mu ki̱i̱kalo eki, Musa aakala na Mukama haa mwena bilo maku̱mi̱ anaa mukilo na ntangaali̱. Ataakuliya byokuliya kedha kunuwa maasi kandi aahandiika haa bihande bibili bya mabaale bighambo bya ndaghaano eghi, bilaghilo eku̱mi̱. ");
INSERT INTO tlj_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Musa aatandika kukota ku̱lu̱gha haa mwena Si̱naai̱, akwete mu ngalo bihande bibili bya mabaale ebihandi̱i̱ki̱yʼo ndaghaano, ataamanya ngoku haali̱i̱so yee akwete kubbebbeniya, haabwa bwile aamali̱ye naabu̱gha na Luhanga. ");
INSERT INTO tlj_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Obu Alooni̱ na Banai̱saaleeli̱ boona baaboone Musa kandi mbaabona haali̱i̱so yee naabbebbeniya, du̱mbi̱ boobaha kumwebinga. ");
INSERT INTO tlj_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Bhaatu Musa aababilikila, du̱mbi̱ Alooni̱ na beebembeli̱ boona baa Banai̱saaleeli̱ baaghenda hambali ali kandi aatandika ku̱bu̱gha nabo. ");
INSERT INTO tlj_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Niibuwo Banai̱saaleeli̱ boona baasi̱ye hambali Musa ali kandi aabalaghila byona ebi Mukama aamughambiiye haa mwena Si̱naai̱. ");
INSERT INTO tlj_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Obu Musa aamali̱ye ku̱bu̱gha na bantu aba, aaswi̱ki̱la haali̱i̱so yee na kitambaala. ");
INSERT INTO tlj_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Musa aakaghendagha mu weema ya kusanga-sangaanamu ku̱bu̱gha na Mukama, aayagha kitambaala eki haali̱i̱so yee ku̱hi̱ki̱ya aalu̱ghi̱yeyo. Du̱mbi̱ aaghambila Banai̱saaleeli̱ ebi Mukama aamulaghiiye. ");
INSERT INTO tlj_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Banai̱saaleeli̱ baakabonagha Musa naabbebbeniya haali̱i̱so, du̱mbi̱ eeswi̱ki̱la kitambaala haali̱i̱so, ku̱hi̱ki̱ya atodhi̱ye kukuuka mu weema eghi ku̱bu̱gha na Mukama. ");
INSERT INTO tlj_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa aakumaani̱ya ki̱bbu̱la kyona kya Banai̱saaleeli̱, aabaghila ati, “Bini niibiyo bintu ebi Mukama aabalaghiiye kukola. ");
INSERT INTO tlj_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Muli na bilo mukaagha bya kukola milimo yaanu, bhaatu kilo kyamusanju̱ kilabaagha kilo kya Sabhato kya kuhuumula kandi ki̱hi̱ki̱li̱i̱ye ewaa Mukama. Muntu weena oghu alakolagha mulimo haa kilo eki aatibuwaghe. ");
INSERT INTO tlj_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Mutali̱tu̱mi̱ka mulilo mu maka ghaanu haa kilo kya Sabhato.” ");
INSERT INTO tlj_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musa aaghila ki̱bbu̱la kyona kya Banai̱saaleeli̱ ati, “Kini niikiyo kintu eki Mukama aabalaghiiye kukola. ");
INSERT INTO tlj_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Muheyo kisembo ewaa Mukama. Muntu weena oghu ali na mutima ghwa bwenge, aleete kisembo kya Mukama: feeja, siliva, bbu̱looji̱, ");
INSERT INTO tlj_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","mahu̱u̱ji̱ ghaa langi̱ ya bbu̱lu̱lu̱, papo, mutuku, lughoye lusemeeye, byoha bya mbu̱li̱, ");
INSERT INTO tlj_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","mpu siimutuku sya ntu̱u̱li̱ sya ntaama, mpu sya mbu̱li̱, mbaau sya ki̱i̱lu̱mbo, ");
INSERT INTO tlj_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","mafu̱ta ghaa kuta mu taala, bintu bisasi̱ye bya kuta mu mafu̱ta ghaa kusiigha, bubbani̱ busasi̱ye, ");
INSERT INTO tlj_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","mabaale onika na mabaale ghanji ghaa muhendo, ghaa kuta haa efodi̱ na kyaku̱lu̱waala haa ki̱ku̱bha. ");
INSERT INTO tlj_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Muntu weena oghu amani̱ye kukola bintu bya ngalo, aase tukole bintu byona ebi Mukama aalaghiiye: ");
INSERT INTO tlj_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","weema ehi̱ki̱li̱i̱ye na byaku̱ghi̱swi̱ki̱la, bigwasi byayʼo, fuleemu syayʼo, mikiiko yayo, mpaghi syayʼo, ncuba sya kutaamu mpaghi, ");
INSERT INTO tlj_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","sandu̱u̱ku̱ ya ndaghaano, mpaghi syayʼo, kyakughaniililʼo bantu bibhi, kateni̱ ya kuta mu maaso ghaa sandu̱u̱ku̱ eghi, ");
INSERT INTO tlj_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","meeja na mpaghi syayʼo, na byaku̱koleesi̱yʼo byona, mugaati̱ ghwa kuhongela Luhanga, ");
INSERT INTO tlj_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","kyakutʼo taala na byaku̱koleesi̱yʼo byona, taala syakiyo na mafu̱ta ghaakuta mu taala esi, ");
INSERT INTO tlj_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","kyaku̱tu̱mi̱kʼo bubbani̱ na mpaghi syakiyo, mafu̱ta ghaa kusiigha, bubbani̱ busasi̱ye, kateni̱ ya kuta haa mulyango ghwa weema ehi̱ki̱li̱i̱ye, ");
INSERT INTO tlj_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","kyakuhongelʼo bihonguwa byona byokeei̱ye, kati̱mba kaakiyo kaa bbu̱looji̱, mpaghi syakiyʼo, byaku̱koleesi̱yʼo byona, bbaafu ya bbu̱looji̱ na kyakughitʼo, ");
INSERT INTO tlj_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","kateni̱ sya kukola lugho lwa jighati̱, mpaghi sya jighati̱ eghi, ncuba sya kutaamu mpaghi esi, kateni̱ ya kuta haa geeti̱ ya jighati̱, ");
INSERT INTO tlj_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","nkondo sya weema ehi̱ki̱li̱i̱ye, nkondo sya jighati̱ na mighuwo yasiyo, ");
INSERT INTO tlj_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","bi̱lu̱waalo bi̱koleeu̱we kulungi bya bahongi̱ ku̱lu̱waalagha mbakola mulimo mu Ki̱i̱kalo Ki̱hi̱ki̱li̱i̱ye, bi̱lu̱waalo bi̱hi̱ki̱li̱i̱ye bya mu̱hongi̱ Alooni̱ na bi̱lu̱waalo bya batabani̱ be balalu̱waalagha mbaheeleli̱ya nga bahongi̱.” ");
INSERT INTO tlj_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Du̱mbi̱ ki̱bbu̱la kyona kya Banai̱saaleeli̱ kyalu̱gha hambali Musa ali kandi kyaghenda. ");
INSERT INTO tlj_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Bu̱li̱ muntu aaghenda kandi aakola ngoku mutima ghuwe ghwamughambiiye. Baaleetela Mukama bisembo bya kukola mulimo ghwa kukwela weema ya kusanga-sangaanamu, milimo yayo yoona na bi̱lu̱waalo bi̱hi̱ki̱li̱i̱ye bya bu̱hongi̱. ");
INSERT INTO tlj_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Bakali̱ na basaasa beehaayo kandi baaleeta bintu bisemeeye bya feeja, bigwasi, mpete syʼomu matui, mpete syʼomu byala na bikwanji byʼomu bikiya, baabihaayo ewaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Muntu weena oghu akaba ali na lughoye lwa langi̱ ya bbu̱lu̱lu̱, papo, mutuku kedha lughoye lusemeeye, byoha bya mbu̱li̱, mpu siimutuku sya ntu̱u̱li̱ sya ntaama na mpu sya mbu̱li̱, byona baabileeta. ");
INSERT INTO tlj_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Muntu weena oghu aagubhagha kuleeta kisembo kya siliva kedha bbu̱looji̱ aakihaayo nga kisembo ewaa Mukama. Muntu oghu akaba ali na mbaau sisemeeye sya ki̱i̱lu̱mbo sya kukola mulimo aasileeta. ");
INSERT INTO tlj_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Bakali̱ boona abaabaagha bamani̱ye kukola kulungi milimo ya ngalo, baaluka bintu ebi baagu̱bhi̱ye kandi baabileeta, bintu bya langi̱ ya bbu̱lu̱lu̱, papo, mutuku na lughoye lusemeeye. ");
INSERT INTO tlj_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Bakali̱ boona abaabaagha bamani̱ye kukola ngoye mu byoha bya mbu̱li̱, baasikola badheedheeu̱we. ");
INSERT INTO tlj_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Beebembeli̱ baa Banai̱saaleeli̱, baaleeta mabaale onika na mabaale ghaa muhendo, ghaa kuta haa efodi̱ na kyaku̱lu̱waala haa ki̱ku̱bha. ");
INSERT INTO tlj_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Baaleeta bintu bisasi̱ye na mafu̱ta ghaa kuta mu taala, mafu̱ta ghaa kusiigha na bubbani̱ busasi̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Banai̱saaleeli̱ boona, bakali̱ na basaasa, abaabaagha na mutima ghwa kuhaayo kintu kyona haabwa mulimo oghu Mukama aalaghiiye Musa kukola, baabileeta kandi baabihaayo ewaa Mukama nga kisembo badheedheeu̱we. ");
INSERT INTO tlj_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Musa aaghila Banai̱saaleeli̱ ati, “Mukama aakomi̱ye Bbejaleeli̱ mutabani̱ wa U̱li̱, muusukulu wa Hula, wʼomu ntu̱la ya Yu̱da. ");
INSERT INTO tlj_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Luhanga aaleki̱ye Mwoyo wee aamwisʼo kwonini, aamuha magheji, kwetegheeleli̱ya kandi aamufoola oghu amani̱ye kukola bintu bya ngalo. ");
INSERT INTO tlj_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Akugubha kukola bintu bisemeeye ku̱lu̱gha mu feeja, siliva na bbu̱looji̱. ");
INSERT INTO tlj_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Akugubha kubhaaka mabaale kandi kughata mu buufuleemu bwa feeja, kulanda mbaau kandi kukola bu̱li̱ mulimo ghwona ghwa ngalo. ");
INSERT INTO tlj_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Mukama aahaaye Bbejaleeli̱ na Oholi̱yaabbu mutabani̱ wa Ahisamaki̱ wʼomu ntu̱la ya Daani̱, magheji ghaa kwegheesi̱ya bantu banji. ");
INSERT INTO tlj_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Aabahaaye magheji ghaa kukola bintu bya ngalo, kuteela bisasani̱, kusona kulungi ngoye kandi kutaamu langi̱ ya bbu̱lu̱lu̱, papo, mutuku kandi kukola lughoye lusemeeye. Bakugubha kukola bintu bikani̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Nahabweki Bbejaleeli̱, Oholi̱yaabbu na bu̱li̱ musaasa oghu Mukama aahaaye magheji kandi kwetegheeleli̱ya kwa kumanya ngoku bakukola mulimo ghwa kukwela ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye, baasa kukola mulimo ngoku Mukama aalaghiiye.” ");
INSERT INTO tlj_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Niibuwo Musa aabilikiiye Bbejaleeli̱ na Oholi̱yaabbu na bu̱li̱ musaasa oghu Mukama aahaaye magheji kandi oghu aabbali̱ye kwisa kukola mulimo oghu. ");
INSERT INTO tlj_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Musa aaha bantu aba bisembo byona ebi Banai̱saaleeli̱ baahaayeyo haabwa kukola mulimo ghwa kukwela ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. Bu̱li̱ kilo nkyambisi Banai̱saaleeli̱ beeyongela kuleetela Musa bisembo byabo badheedheeu̱we. ");
INSERT INTO tlj_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Nahabweki bantu boona abaabaagha na magheji ghaa kukwela ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye baalu̱gha haa milimo eghi baakolagha. ");
INSERT INTO tlj_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Baaghila Musa bati, “Bantu niibuwo baaleeta bintu bikani̱ye kusaali̱ya ebi tukwetaaghisibuwa haabwa mulimo oghu Mukama aatulaghiiye kukola.” ");
INSERT INTO tlj_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Musa aalaghila bantu aba kughambila bantu boona hambali baghooneeye bati, “Hatabʼo musaasa weena kedha mukali̱ oghu akutodha kuhaayo kisembo kya kukola mulimo ghwa kukwela ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye.” Nahabweki baatanga bantu kutodha kuhaayo bisembo ebi. ");
INSERT INTO tlj_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Ebi bantu aba baabaagha mbaahaayeyo bikaba bisaaye haa ebyetaaghisibuwagha kukola mulimo oghu. ");
INSERT INTO tlj_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Abaabaagha bamani̱ye kukola mulimo oghu, baakwela weema ehi̱ki̱li̱i̱ye na kateni̱ eku̱mi̱ sya lughoye lusemeeye kandi mu langi̱ ya bbu̱lu̱lu̱, papo na mutuku. Mu̱soni̱ mulungi aasonela haa kateni̱ esi bisasani̱ bya bakelu̱bbi̱. ");
INSERT INTO tlj_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Kateni̱ esi syona syengana-ngana, kujamba kwasiyo mi̱ta eku̱mi̱ nʼebili kandi kugbaatikana mi̱ta ebili. ");
INSERT INTO tlj_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Bakoli̱ aba baakwatani̱ya kateni̱ etaano hamui, na sinji kateni̱ etaano baasikwatani̱ya hamui. ");
INSERT INTO tlj_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Baakola mpete sya lughoye maku̱mi̱ ataano mu langi̱ ya bbu̱lu̱lu̱ kandi baasita haa mukughilo ghwa kateni̱ yʼokumaliilila haa kateni̱ etaano esikwatani̱i̱ye hamui. ");
INSERT INTO tlj_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Baata mpete sya lughoye maku̱mi̱ ataano haa mukughilo ghwa kateni̱ yʼokumaliilila haa kateni̱ etaano esikwatani̱i̱ye hamui, na mpete sya lughoye sinji maku̱mi̱ ataano haa kateni̱ yʼokumaliilila haa kateni̱ sinji etaano esikwatani̱i̱ye hamui kandi syalolana. ");
INSERT INTO tlj_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Baakola bigwasi maku̱mi̱ ataano bya feeja kandi baabi̱koleesi̱ya kukwatani̱ya hamui kateni̱ esi kandi yaaba weema ehi̱ki̱li̱i̱ye emui. ");
INSERT INTO tlj_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Baakola dhee kateni̱ eku̱mi̱ nʼemui mu byoha bya mbu̱li̱ sya ku̱swi̱ki̱la weema ehi̱ki̱li̱i̱ye eghi. ");
INSERT INTO tlj_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Kujamba kwa bu̱li̱ kateni̱ kwaba mi̱ta eku̱mi̱ nʼesatu kandi kugbaatikana kwaba mi̱ta ebili. Kateni̱ eku̱mi̱ nʼemui esi syona syengana-ngaana. ");
INSERT INTO tlj_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Kateni̱ etaano baasikwatani̱ya syonkaha, na sinji mukaagha baasikwatani̱ya syonkaha. ");
INSERT INTO tlj_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Baata mpete sya lughoye maku̱mi̱ ataano haa mukughilo ghwa kateni̱ yʼokumaliilila haa kateni̱ etaano esikwatani̱i̱ye hamui na mpete sya lughoye maku̱mi̱ ataano haa mukughilo ghwa kateni̱ yʼokumaliilila haa kateni̱ mukaagha esikwatani̱i̱ye hamui. ");
INSERT INTO tlj_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Baakola bigwasi maku̱mi̱ ataano bya bbu̱looji̱ kandi baabita mu mpete sya lughoye kukwatani̱ya weema eghi, niikuwo ebe weema emui. ");
INSERT INTO tlj_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Baakola bintu binji bibili bya ku̱swi̱ki̱la weema eghi, kimui ku̱lu̱gha mu mpu siimutuku sya ntu̱u̱li̱ sya ntaama na kinji ku̱lu̱gha mu mpu sya mbu̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Baakola fuleemu sya ki̱i̱lu̱mbo sya kwemi̱li̱li̱yʼo weema ehi̱ki̱li̱i̱ye eghi. ");
INSERT INTO tlj_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Kujamba kwa bu̱li̱ fuleemu kwaba fu̱u̱ti̱ eku̱mi̱ nʼetaano kandi kugbaatikana kwaba fu̱u̱ti̱ ebili na i̱nci̱ esatu. ");
INSERT INTO tlj_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Bu̱li̱ fuleemu baaghikolela nkondo ebili sya kuta hansi yayo, kusikwatani̱ya. Fuleemu syona sya weema ehi̱ki̱li̱i̱ye eghi niikuwo baasi̱koli̱ye batiyo. ");
INSERT INTO tlj_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Baakola fuleemu maku̱mi̱ abili sya kuta haa luhande lwa eku̱wa lwa weema ehi̱ki̱li̱i̱ye eghi. ");
INSERT INTO tlj_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Baakola ncuba maku̱mi̱ anaa sya siliva sya kutaamu fuleemu maku̱mi̱ abili esi kandi baata ncuba ebili hansi ya bu̱li̱ fuleemu kukwata nkondo syayʼo ebili. ");
INSERT INTO tlj_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Baakola fuleemu maku̱mi̱ abili sya kuta haa luhande lwʼelughulu lwa weema ehi̱ki̱li̱i̱ye eghi. ");
INSERT INTO tlj_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Baakola ncuba maku̱mi̱ anaa sya siliva, ncuba ebili sya kuta hansi ya bu̱li̱ fuleemu. ");
INSERT INTO tlj_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Baakola fuleemu mukaagha sya kuta enu̱ma ya weema ehi̱ki̱li̱i̱ye eghi haa luhande lwa bughuwa ejooba. ");
INSERT INTO tlj_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Baakola fuleemu ebili sya kuta haa nsondo ku̱gu̱mi̱ya weema ehi̱ki̱li̱i̱ye eghi. ");
INSERT INTO tlj_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Fuleemu ebili esi baasikwatani̱ya ku̱lu̱gha hansi ku̱hi̱ka elughulu kandi baasikwatani̱ya na mpete emui. Baakola batiyo fuleemu syombi syʼomu nsondo ebili. ");
INSERT INTO tlj_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Baakola fuleemu munaanaa na ncuba sya siliva eku̱mi̱ na mukaagha sya kutaamu fuleemu esi kandi ncuba ebili hansi ya bu̱li̱ fuleemu. ");
INSERT INTO tlj_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Baakola mikiiko etaano mu ki̱i̱lu̱mbo, ya kukwatani̱ya fuleemu sya luhande lwʼelughulu lwa weema ehi̱ki̱li̱i̱ye eghi. ");
INSERT INTO tlj_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Baakola mikiiko etaano ya kukwatani̱ya fuleemu sya luhande lwʼeku̱wa lwa weema ehi̱ki̱li̱i̱ye kandi mikiiko etaano ya kukwatani̱ya fuleemu sya luhande lwa bughuwa ejooba bwa weema ehi̱ki̱li̱i̱ye eghi. ");
INSERT INTO tlj_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Mukiiko ghwa fuleemu ghwa kuta haagati ya fuleemu esi ghwalu̱gha haa luhande lumui ku̱hi̱ka haa luhande lunji. ");
INSERT INTO tlj_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Fuleemu esi baasi̱swi̱ki̱la na feeja kandi baakola mpete syasiyo sya feeja sya kukwata mikiiko kandi mikiiko eghi baaghi̱swi̱ki̱la na feeja. ");
INSERT INTO tlj_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Baakola kateni̱ mu langi̱ ya bbu̱lu̱lu̱, papo, mutuku, na lughoye lusemeeye kandi baasonelʼo kulungi bisasani̱ bya bakelu̱bbi̱. ");
INSERT INTO tlj_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Baaghikolela mpaghi enaa sya ki̱i̱lu̱mbo kandi baasi̱swi̱ki̱la na feeja. Ndobhaani̱ sya mpaghi esi baasikola mu feeja kandi baakola ncuba enaa sya siliva sya kutaamu mpaghi esi. ");
INSERT INTO tlj_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Haa mulyango ghwa weema eghi, baatʼo kateni̱ ya langi̱ ya bbu̱lu̱lu̱, papo, mutuku, na lughoye lusemeeye kandi eghi mu̱soni̱ mulungi akoli̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Kateni̱ eghi baaghikolela mpaghi etaano sya ki̱i̱lu̱mbo kandi baasi̱swi̱ki̱la na feeja. Ndobhaani̱ sya ku̱dhodhooki̱yʼo kateni̱ syaba sya feeja kandi mpaghi esi baasita mu ncuba etaano sya bbu̱looji̱. ");
INSERT INTO tlj_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bbejaleeli̱ aakola sandu̱u̱ku̱ ya ndaghaano mu mbaau sya ki̱i̱lu̱mbo. Kujamba kwayʼo fu̱u̱ti̱ esatu na i̱nci̱ mwenda, kugbaatikana kwayʼo fu̱u̱ti̱ ebili na i̱nci̱ esatu kandi kukangama kwayʼo fu̱u̱ti̱ ebili na i̱nci̱ esatu. ");
INSERT INTO tlj_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Aaghi̱swi̱ki̱la na feeja esemeeye mukati na haagu̱u̱li̱ kandi aaghyeli̱ghi̱i̱li̱li̱ya yoona na mugoma ghwa feeja. ");
INSERT INTO tlj_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Aaghikolela mpete enaa sya feeja kandi aasita haa maghulu anaa ghaa sandu̱u̱ku̱ eghi, mpete ebili aasita haa luhande lumui kandi mpete ebili aasita haa luhande lunji. ");
INSERT INTO tlj_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Aakola mpaghi enaa mu mbaau sya ki̱i̱lu̱mbo kandi aasi̱swi̱ki̱la na feeja. ");
INSERT INTO tlj_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Mpaghi esi aasikwami̱ya mu mpete esili haa mpande syombi sya sandu̱u̱ku̱ eghi kughiheekelaghʼo. ");
INSERT INTO tlj_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Aakola kyakughaniililʼo bantu bibhi mu feeja esemeeye. Kujamba kwakiyo fu̱u̱ti̱ esatu na i̱nci̱ mwenda kandi kugbaatikana fu̱u̱ti̱ ebili na i̱nci̱ esatu. ");
INSERT INTO tlj_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Aawiisa na nondo bakelu̱bbi̱ babili baa feeja kandi aabata haa mpande syombi sya kyakughaniililʼo bantu bibhi. ");
INSERT INTO tlj_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Kelu̱bbi̱ omui aamuta haa luhande lumui kandi onji aamuta haa luhande lunji. Feeja yoonini eghi aakoleeseei̱ye kukola kyakughaniililʼo bantu bibhi, haaliiyo aaghi̱koleesi̱ya dhee kukola bakelu̱bbi̱ aba. ");
INSERT INTO tlj_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Bakelu̱bbi̱ aba baala mapapa ghaabo eghulu ya kyakughaniililʼo bantu bibhi ku̱ki̱swi̱ki̱la. Baakala balolaane kandi baloli̱ye haa kyakughaniililʼo bantu bibhi. ");
INSERT INTO tlj_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Bbejaleeli̱ aakola meeja mu mbaau sya ki̱i̱lu̱mbo, kujamba kwayʼo fu̱u̱ti̱ esatu, kugbaatikana kwayʼo fu̱u̱ti̱ emui na i̱nci̱ mukaagha, kukangama kwayʼo fu̱u̱ti̱ ebili na i̱nci̱ esatu. ");
INSERT INTO tlj_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Aaghi̱swi̱ki̱la na feeja esemeeye kandi aaghitʼo mugoma ghwa feeja. ");
INSERT INTO tlj_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Aaghyeli̱ghi̱i̱li̱li̱ya mu maakpengbu̱ na fuleemu ya i̱nci̱ esatu kandi aatʼo mugoma ghwa feeja. ");
INSERT INTO tlj_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Aaghikolela mpete enaa sya feeja kandi aasita haa nsondo syayʼo enaa, haa maghulu ghaayʼo anaa. ");
INSERT INTO tlj_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Mpete esi aasita haai na mugoma ghwa meeja eghi kandi kukwatagha mpaghi sya kuheekelaghʼo meeja eghi. ");
INSERT INTO tlj_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Aakola mpaghi sya ki̱i̱lu̱mbo sya kuheekelaghʼo meeja eghi kandi aasi̱swi̱ki̱la na feeja. ");
INSERT INTO tlj_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Aakola mu feeja esemeeye bintu byaku̱koleesi̱ya haa meeja eghi: sahaani̱, bibindi bya kuheekelamu bubbani̱, bbaaku̱li̱ na jaaga bya kutaamu bihonguwa byakunuwa. ");
INSERT INTO tlj_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Aakola kyakutʼo taala mu feeja esemeeye. Aawiisa na nondo kyakutʼo taala eki kyona, otaayemu bimole byakiyo byaku̱ki̱semeli̱ya mu feeja eghi yoonini. ");
INSERT INTO tlj_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Kyakutʼo taala eki kyaba na matai mukaagha aghalu̱ghi̱ye haa ki̱ti̱na kya haagati, matai asatu haa luhande lumui na ghanji asatu haa luhande lunji. ");
INSERT INTO tlj_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Bu̱li̱ etai haa matai mukaagha ghaa kyakutʼo taala eki, aabʼo bimole bisatu ebi̱su̱si̱ye bimole bya kiti alu̱mondi̱. ");
INSERT INTO tlj_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Haa ki̱ti̱na kya haagati ya kyakutʼo taala eki, aabʼo bimole bbinaa ebi̱su̱si̱ye bimole bya kiti alu̱mondi̱. ");
INSERT INTO tlj_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Hansi ya bu̱li̱ matai abili aghalu̱ghi̱ye haa ki̱ti̱na kya kyakutʼo taala eki, aatʼo kimole eki̱su̱si̱ye kimole kya kiti alu̱mondi̱. ");
INSERT INTO tlj_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Aawiisa na nondo kyakutʼo taala eki, otaayemu matai ghaakiyo na bimole byakiyo byaku̱ki̱semeli̱ya, mu feeja esemeeye eghi yoonini. ");
INSERT INTO tlj_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Aakola taala musanju̱ sya feeja, makaasi ghaasiyo na buusaniya mu feeja esemeeye. ");
INSERT INTO tlj_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Kyakutʼo taala eki na bintu byakiyo byona aabikola mu ki̱lo maku̱mi̱ asatu nʼetaano sya feeja esemeeye. ");
INSERT INTO tlj_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Aakola kyakuhongelʼo bihonguwa kyaku̱tu̱mi̱kʼo bubbani̱ mu ki̱i̱lu̱mbo kandi kyona kyengana-ngana. Kujamba kwakiyo fu̱u̱ti̱ emui nʼeki̱twi̱ke, kugbaatikana fu̱u̱ti̱ emui nʼeki̱twi̱ke kandi kukangama fu̱u̱ti̱ esatu. Mahembe ghaakiyo anaa ghaalu̱gha mu ki̱twi̱ke eki kyonini. ");
INSERT INTO tlj_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Aaki̱swi̱ki̱la na feeja esemeeye haagu̱u̱li̱ yakiyo, haa mpande syakiyo syona na haa mahembe ghaakiyo kandi aakyeli̱ghi̱i̱li̱li̱ya na mugoma ghwa feeja. ");
INSERT INTO tlj_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Aakikolela mpete ebili sya feeja kandi aasita hansi ya mugoma ghwa feeja haa mpande ebili mu maakpengbu̱ hambali bakuta mpaghi esi balakiheekelaghʼo. ");
INSERT INTO tlj_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Mpaghi esi aasikola mu ki̱i̱lu̱mbo kandi aasi̱swi̱ki̱la na feeja. ");
INSERT INTO tlj_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Aakola dhee mafu̱ta ghaa kusiigha ghahi̱ki̱li̱i̱ye na bubbani̱ busasi̱ye bwa ku̱tu̱mi̱ka. Bintu ebi aabikola kusemeeye nga muntu oghu abimani̱ye kwonini akukolagha. ");
INSERT INTO tlj_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Aakola kyakuhongelʼo bihonguwa kya kuhongelʼo kihonguwa kyona kyokeei̱ye mu ki̱i̱lu̱mbo. Kyona kyengana-ngana, kujamba kwakiyo fu̱u̱ti̱ musanju̱ nʼeki̱twi̱ke, kugbaatikana fu̱u̱ti̱ musanju̱ nʼeki̱twi̱ke kandi kukangama fu̱u̱ti̱ enaa nʼeki̱twi̱ke. ");
INSERT INTO tlj_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Aakikolela mahembe kandi haa bu̱li̱ nsondo syakiyo enaa aatʼo ehembe limui. Mahembe agha aaghakola mu ki̱twi̱ke kya kiti eki kyonini kandi aaki̱swi̱ki̱la na bbu̱looji̱. ");
INSERT INTO tlj_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Aakola byaku̱koleesi̱ya haa kyakuhongelʼo bihonguwa eki: capu̱li̱ya sya kutaamu ki̱bu̱, bi̱ti̱i̱yo, bibindi, huuma na capu̱li̱ya sya ku̱tu̱mi̱kamu mulilo, bintu ebi byona aabikola mu bbu̱looji̱. ");
INSERT INTO tlj_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Aakola kati̱mba kaa bbu̱looji̱, aakakoti̱ya mukati hansi ya mugoma ghwa kyakuhongelʼo bihonguwa kandi kahi̱ke haagati yakiyo. ");
INSERT INTO tlj_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Aakola mpete enaa sya bbu̱looji̱ kandi aata emui haa bu̱li̱ nsondo emui ya kyakuhongelʼo bihonguwa eki, haa nsondo syakiyo enaa sya kutaamu mpaghi sya kukiheekelʼo. ");
INSERT INTO tlj_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Aakola mpaghi sya ki̱i̱lu̱mbo sya kuheekelaghʼo kyakuhongelʼo bihonguwa eki kandi aasi̱swi̱ki̱la na bbu̱looji̱. ");
INSERT INTO tlj_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Mpaghi esi aasikwami̱ya mu mpete esili haa mpande ebili sya kyakuhongelʼo bihonguwa eki niikuwo bakiheekelaghʼo. Kyakuhongelʼo bihonguwa eki, aakikola mu mbaau kandi mukati yakiyo haabaamu mwanya. ");
INSERT INTO tlj_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Aakola bbaafu ya bbu̱looji̱ na kyakughitʼo kya bbu̱looji̱. Aabikola mu ndebelwamu sya bakali̱ abaaheeleli̱yagha haa mulyango ghwa weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Aakola jighati̱ ya weema ehi̱ki̱li̱i̱ye. Haa luhande lwa eku̱wa lwa weema eghi aatʼo kateni̱ sya lughoye lusemeeye, kujamba kwasiyo mi̱ta maku̱mi̱ anaa nʼenaa. ");
INSERT INTO tlj_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Mpaghi maku̱mi̱ abili sya kateni̱ esi na ncuba sya kusitaamu maku̱mi̱ abili byona byaba bya bbu̱looji̱, bhaatu ndobhaani̱ sya mpaghi esi na mpete syasiyo byaba bya siliva. ");
INSERT INTO tlj_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Haa luhande lwa elughulu, aatʼo kateni̱ kujamba kwasiyo mi̱ta maku̱mi̱ anaa nʼenaa, mpaghi maku̱mi̱ abili sya kutʼo kateni̱ esi na ncuba maku̱mi̱ abili sya kutaamu mpaghi esi byaba bya bbu̱looji̱, bhaatu ndobhaani̱ sya mpaghi esi na mpete syasiyo byaba bya siliva. ");
INSERT INTO tlj_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Haa luhande lwa bughuwa ejooba, aatʼo kateni̱ kujamba kwasiyo mi̱ta maku̱mi̱ abili nʼebili kandi aasita haa mpaghi eku̱mi̱ esili mu ncuba eku̱mi̱. Bhaatu mpete na ndobhaani̱ sya mpaghi esi byaba bya siliva. ");
INSERT INTO tlj_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Haa luhande lwa bu̱lu̱gha ejooba, kujamba kwa jighati̱ kwaba mi̱ta maku̱mi̱ abili nʼebili. ");
INSERT INTO tlj_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Kateni̱ sya kuta haa luhande lumui lwa mulyango, kujamba kwasiyo kwaba mi̱ta mukaagha nʼeki̱twi̱ke kandi aasita haa mpaghi esatu esili mu ncuba esatu. ");
INSERT INTO tlj_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Haa luhande lunji lwa geeti̱ ya jighati̱ eghi, aatʼo kateni̱ kujamba kwasiyo mi̱ta mukaagha nʼeki̱twi̱ke kandi aasita haa mpaghi esatu esili mu ncuba esatu. ");
INSERT INTO tlj_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Kateni̱ syona esi aataaye mu jighati̱ eghi sikaba si̱koleeu̱we kusemeeye mu lughoye lusemeeye. ");
INSERT INTO tlj_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Ncuba sya kutaamu mpaghi esi sikaba sili sya bbu̱looji̱, bhaatu ndobhaani̱ na mpete sya mpaghi esi syaba sya siliva kandi mpaghi sya jighati̱ esi syona baasi̱swi̱ki̱la na siliva haagu̱u̱li̱ yasiyo. ");
INSERT INTO tlj_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Haa geeti̱ aatʼo kateni̱ kujamba kwayʼo mi̱ta mwenda kandi kukangama mi̱ta ebili na kimui kyakanaa. Aaghikola mu langi̱ ya bbu̱lu̱lu̱, papo na mutuku kandi eghi mu̱soni̱ mulungi akoli̱ye mu lughoye lusemeeye. Kateni̱ eghi ekaba yengaane na kateni̱ sinji esi̱koli̱ye lugho lwa jighati̱. ");
INSERT INTO tlj_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Kateni̱ eghi baaghi̱dhodhooki̱ya haa mpaghi enaa, bu̱li̱ mpaghi baaghita mu ncuba yayo ya bbu̱looji̱. Ndobhaani̱ sya mpaghi esi na mpete syasiyo bikaba bili bya siliva kandi haagu̱u̱li̱ ya mpaghi esi baswi̱ki̱yʼo siliva. ");
INSERT INTO tlj_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Nkondo syona esi baakoleeseei̱ye haa weema ehi̱ki̱li̱i̱ye na nkondo sya jighati̱ eghi syaba sya bbu̱looji̱. ");
INSERT INTO tlj_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Ghuni niighuwo muhendo ghwa bintu ebi baakoleeseei̱ye kukwela weema ehi̱ki̱li̱i̱ye, ki̱i̱kalo kya kutaamu Bilaghilo Eku̱mi̱. Musa niiye akalaghila Baleevi̱ kubibala kandi oghu akaba mukulu wabo haa mulimo oghu ni I̱tamala mutabani̱ wa mu̱hongi̱ Alooni̱. ");
INSERT INTO tlj_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bbejaleeli̱ mutabani̱ wa Hu̱li̱ kandi muusukulu wa Hula, wʼomu ntu̱la ya Yu̱da, aakola byona ebi Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Mulimo oghu aaghukola na Oholi̱yaabbu mutabani̱ wa Ahisamaki̱, wʼomu ntu̱la ya Daani̱, oghu akaba amani̱ye kukola kulungi milimo ya ngalo, kuteela bisasani̱, mu̱soni̱ mulungi wa ngoye sya langi̱ ya bbu̱lu̱lu̱, papo, mutuku na haa lughoye lusemeeye. ");
INSERT INTO tlj_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Bakoli̱ aba baakoleesi̱ya ki̱lo lu̱ku̱mi̱ sya feeja kukola mulimo ghwona ghwa kukwela ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye, kusighikila haa ki̱pi̱i̱mo kyʼomu weena eghi. Banai̱saaleeli̱ baahaayo feeja eghi nga kihonguwa ewaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Siliva eghi ekalu̱gha mu ki̱bbu̱la kya Banai̱saaleeli̱ aba baabali̱ye, yaahi̱ki̱ya ki̱lo nga nku̱mi̱ esatu bbinaa na asatu. ");
INSERT INTO tlj_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Baabala basaasa boona abaabaagha na myaka maku̱mi̱ abili ya bukulu na kweyongelayo kandi bu̱li̱ muntu oghu baabalagha, aasasulagha kimui kyakabili kya mukwenge ghwa siliva, muhendo ghwa basaasa aba baabali̱ye, ghwaba mitwalo nkaagha, nku̱mi̱ esatu bitaano nʼataano. ");
INSERT INTO tlj_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Baakoleesi̱yagha ki̱lo nku̱mi̱ esatu na bbinaa sya siliva kukola ncuba ki̱ku̱mi̱. Bu̱li̱ ncuba yaaba ki̱lo maku̱mi̱ asatu nʼenaa sya kutaamu mpaghi ki̱ku̱mi̱ sya weema ehi̱ki̱li̱i̱ye kandi kutʼo kateni̱. ");
INSERT INTO tlj_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ki̱lo maku̱mi̱ asatu sya siliva eghi ekati̱ghalʼo, baaghikolamu ndobhaani̱ na mpete bya ku̱dhodhooki̱yʼo kateni̱ haa mpaghi kandi baaghi̱koleesi̱ya ku̱swi̱ki̱la haagu̱u̱li̱ ya mpaghi esi. ");
INSERT INTO tlj_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Bbu̱looji̱ eghi Banai̱saaleeli̱ baahaayeyo na bihonguwa binji bya mbaghani̱ja byahi̱ka ki̱lo nku̱mi̱ ebili bbinaa abili nʼetaano. ");
INSERT INTO tlj_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Baakoleesi̱ya bbu̱looji̱ eghi kukolamu ncuba sya kutaamu mpaghi sya mulyango ghwa weema ya kusanga-sangaanamu, kyakuhongelʼo bihonguwa kya bbu̱looji̱ na byaku̱koleesi̱yʼo byona. ");
INSERT INTO tlj_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Baakoleesi̱ya bbu̱looji̱ eghi kukola ncuba sya kutaamu mpaghi sya jighati̱ eghi yeeli̱ghi̱li̱i̱ye weema ehi̱ki̱li̱i̱ye eghi, na ncuba sya kutaamu mpaghi sya geeti̱ ya jighati̱ na nkondo syona sya weema ehi̱ki̱li̱i̱ye na jighati̱ yayo. ");
INSERT INTO tlj_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Bbejaleeli̱ na baanakiye baakola bi̱lu̱waalo bisemeleeye kimui mu ngoye sya langi̱ ya bbu̱lu̱lu̱, papo na mutuku bya bahongi̱ ku̱lu̱waalagha mbakola mulimo mu Ki̱i̱kalo Ki̱hi̱ki̱li̱i̱ye. Baakola bi̱lu̱waalo bi̱hi̱ki̱li̱i̱ye bya Alooni̱, ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Baakoleesi̱ya feeja, mahu̱u̱ji̱ ghaa langi̱ ya bbu̱lu̱lu̱, papo, mutuku na lughoye lusemeeye, kukola efodi̱. ");
INSERT INTO tlj_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Baakoleesi̱ya nondo kuwiisa feeja kandi baaghiiyamu buntu bu̱ti̱-bu̱ti̱i̱, du̱mbi̱ baabujombakaka baayamu mahu̱u̱ji̱ kandi bantu abali na bukugu baaghasoni̱ya lughoye lusemeeye lwa langi̱ ya bbu̱lu̱lu̱, papo, mutuku na lughoye lusemeeye. ");
INSERT INTO tlj_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Efodi̱ eghi baata haa mpande syombi buheeko bwa kukwatani̱ya haa mabegha ki̱twi̱ke kya mu maaso na kyʼenu̱ma, niikuwo ekwatane hamui. ");
INSERT INTO tlj_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Basaasa aba baakola muheeko mu lughoye lusemeeye olu baakoli̱yemu efodi̱ kandi baatamu mahu̱u̱ji̱ ghaa feeja ghaa langi̱ ya bbu̱lu̱lu̱, papo, mutuku na lughoye lusemeeye ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Baabhaaka mabaale abili onika, baaghata mu buufuleemu buunabwana bwa feeja kandi muntu aahandiikʼo mali̱i̱na ghaa batabani̱ eku̱mi̱ na babili baa I̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Mabaale abili agha baaghaboha haa mabegha haagu̱u̱li̱ ya efodi̱ kuba kaakuusukilʼo batabani̱ baa I̱saaleeli̱, ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Baasona kyaku̱lu̱waala haa ki̱ku̱bha mu lughoye lwonini olu baakoli̱yemu efodi̱. Baakitaamu mahu̱u̱ji̱ ghaa feeja, langi̱ ya bbu̱lu̱lu̱, papo, mutuku na lughoye lusemeeye. ");
INSERT INTO tlj_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Kyaku̱lu̱wala haa ki̱ku̱bha eki, baaki̱ku̱namu kabili kandi kyengaana mpande syona, i̱nci̱ mwenda kujamba kandi i̱nci̱ mwenda kugbaatikana. ");
INSERT INTO tlj_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Baatʼo lai̱ni̱ enaa sya mabaale ghaa muhendo. Lai̱ni̱ yʼoku̱du̱bha baatʼo ghaamutuku salu̱di̱yo, ghaa ki̱si̱ka kibisi topaji̱ na ghaamutuku kabu̱nku̱lo. ");
INSERT INTO tlj_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Lai̱ni̱ yaakabili baatʼo ghaa ki̱si̱ka kibisi i̱mi̱lali̱do, ghaa bbu̱lu̱lu̱ su̱fi̱lo na ghaa njelu dayamondi̱. ");
INSERT INTO tlj_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Lai̱ni̱ yaakasatu baatʼo ghaa mutuku takwi̱je, ghaa njelu agate na ghaa papo ameti̱si̱to. ");
INSERT INTO tlj_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Lai̱ni̱ yaakanaa baatʼo ghaa kinjaali̱ bbelu̱lo, ghaa mutuku onika na ghaa ki̱si̱ka kibisi yesipa kandi baaghata mu buufuleemu buunabwana bwa feeja. ");
INSERT INTO tlj_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Haabʼo mabaale eku̱mi̱ nʼabili kandi haa bu̱li̱ ebaale baahandiikʼo li̱i̱na lya omui haa batabani̱ eku̱mi̱ na babili baa Yakobbo kwoleka ntu̱la eku̱mi̱ nʼebili sya I̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Kyaku̱lu̱waala haa ki̱ku̱bha eki baakikolela bujeghele bubili bwa feeja busemeeye kandi obutali̱ye nga bughuwo. ");
INSERT INTO tlj_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Baakola buufuleemu buunabwana bubili bwa feeja bwa kutaamu mabaale agha. Kyaku̱lu̱waala haa ki̱ku̱bha eki baakikolela mpete ebili sya feeja kandi baasita haa nsondo syakiyo ebili syʼelughulu. ");
INSERT INTO tlj_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Baaboha bujeghele bubili bwa feeja mu mpete ebili esili haa mpande ebili sya kyaku̱lu̱waala haa ki̱ku̱bha. ");
INSERT INTO tlj_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Baakwatani̱ya kumaliilila kunji kwa bujeghele bubili haa buufuleemu buunabwana bwa feeja kandi baabuboha mu maaso ghaa efodi̱ eghi. ");
INSERT INTO tlj_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Baakola mpete ebili sya feeja kandi baasita haa nsondo ebili syʼeku̱wa ya kyaku̱lu̱waala haa ki̱ku̱bha, mukati haai na efodi̱. ");
INSERT INTO tlj_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Baakola dhee mpete sinji ebili sya feeja kandi baasita haakumaliilila kwa bughuwo bubili bwa haa mabegha ghaa efodi̱, hambali ki̱twi̱ke kyayʼo kyʼeku̱wa kilabhaane na muheeko oghu̱soni̱ye kulungi. ");
INSERT INTO tlj_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Mpete syakiyo baasibohela haa mpete sya kyaku̱lu̱waala haa ki̱ku̱bha na bughuwo bwa langi̱ ya bbu̱lu̱lu̱, niikuwo kilangaale haa muheeko ghwa efodi̱ eghi ekoleeu̱we kulungi, niikuwo kitatelebuka haa efodi̱ eghi, ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Baakola nkanji̱ ya langi̱ ya bbu̱lu̱lu̱ ya ku̱lu̱waala mukati ya efodi̱. ");
INSERT INTO tlj_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Nkanji̱ eghi yaaba na kihulu haagati ekiliyo mukughilo kya kukwami̱yamu mutuwe niikuwo etatemuka. ");
INSERT INTO tlj_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Baata haa mukughilo ghwa nkanji̱ eghi mikomamahanga mu langi̱ ya bbu̱lu̱lu̱, papo, mutuku na lughoye lusemeeye. ");
INSERT INTO tlj_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Baakola bida bya feeja esemeeye kandi baabyeli̱ghi̱i̱li̱li̱ya haa mukughilo ghwa nkanji̱ eghi mbalabhani̱ya kida na mukomamahanga. ");
INSERT INTO tlj_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Baalabhani̱yagha kida na mukomamahanga, kida na mukomamahanga, kweli̱ghi̱i̱li̱li̱ya mukughilo ghwa eku̱wa ghwa nkanji̱ eghi. Alooni̱ aghi̱lu̱waalaghe naakola mulimo ghuwe nga mu̱hongi̱, ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Baakolela Alooni̱ na batabani̱ be kyaku̱lu̱waala mukati, mu lughoye lusemeeye. ");
INSERT INTO tlj_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Baabakolela kyaku̱lu̱waala mu mutuwe, sipeewa na mpale sya mukati, mu lughoye lusemeeye. ");
INSERT INTO tlj_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Mu̱soni̱ mulungi aasona muheeko mu lughoye lusemeeye kandi aasonelʼo mahu̱u̱ji̱ ghaa langi̱ ya bbu̱lu̱lu̱, papo na mutuku, ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Baakola kaapa mu feeja esemeeye kandi baakahandiikʼo bati, “Ahi̱ki̱li̱i̱ye ewaa Mukama.” ");
INSERT INTO tlj_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Kaapa aka aakaboha na kaghuwo kaa langi̱ ya bbu̱lu̱lu̱ mu maaso ghaa kyaku̱lu̱waala mu mutuwe, ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Nahabweki mulimo ghwona ghwa kukwela weema ehi̱ki̱li̱i̱ye, weema ya kusanga-sangaanamu, ghwahuwa. Banai̱saaleeli̱ baakola bintu byona ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Baaleeta ewaa Musa weema ehi̱ki̱li̱i̱ye na bintu byayʼo byona: bigwasi byayʼo, fuleemu syayʼo, mikiiko yayo, mpaghi syayʼo, ncuba sya kutaamu mpaghi, ");
INSERT INTO tlj_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","kyaku̱swi̱ki̱la weema eghi eki̱koleeu̱we mu mpu siimutuku sya ntu̱u̱li̱ sya ntaama, mpu sya mbu̱li̱, kateni̱ ya kuta mu maaso ghaa sandu̱u̱ku̱, ");
INSERT INTO tlj_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","sandu̱u̱ku̱ ya ndaghaano, mpaghi syayʼo, kyakughaniililʼo bantu bibhi, ");
INSERT INTO tlj_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","meeja na byaku̱koleesi̱yʼo byona, mugaati̱ ghwa kuhongela Luhanga, ");
INSERT INTO tlj_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","kyakutʼo taala kya feeja esemeeye na taala syakiyo, byaku̱koleesi̱yʼo byona na mafu̱ta ghaakuta mu taala esi, ");
INSERT INTO tlj_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","kyakuhongelʼo bihonguwa kya feeja, mafu̱ta ghaa kusiigha, bubbani̱ busasi̱ye, kateni̱ ya kuta haa mulyango ghwa weema ehi̱ki̱li̱i̱ye, ");
INSERT INTO tlj_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","kyakuhongelʼo kya bbu̱looji̱, kati̱mba kaakiyo kaa bbu̱looji̱, mpaghi syakiyʼo, byaku̱koleesi̱yʼo byona, bbaafu ya bbu̱looji̱ na kyakughitʼo, ");
INSERT INTO tlj_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","kateni̱ sya kukola lugho lwa jighati̱, mpaghi sya jighati̱ eghi, ncuba sya kutaamu mpaghi esi, kateni̱ ya kuta haa geeti̱ ya jighati̱, mighuwo na nkondo sya jighati̱ ya weema eghi na byaku̱koleesi̱ya byona mu weema ehi̱ki̱li̱i̱ye, weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Baaleeta bi̱lu̱waalo bi̱koleeu̱we kulungi bya bahongi̱ ku̱lu̱waalagha mbakola mulimo mu Ki̱i̱kalo Ki̱hi̱ki̱li̱i̱ye, bi̱lu̱waalo bi̱hi̱ki̱li̱i̱ye bya mu̱hongi̱ Alooni̱ na bi̱lu̱waalo bya batabani̱ be balalu̱waalagha mbaheeleli̱ya nga bahongi̱. ");
INSERT INTO tlj_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Banai̱saaleeli̱ baakola mulimo ghwona ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musa aalola bhyani bintu ebi byona kandi aabona ngoku baakoli̱ye mulimo oghu kwonini ngoku Mukama aalaghiiye. Nahabweki Musa aaha bantu aba mu̱gi̱sa. ");
INSERT INTO tlj_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Okwele weema ehi̱ki̱li̱i̱ye, weema ya kusanga-sangaanamu, haa kilo kyʼoku̱du̱bha kya kweli̱ kwokubanja. ");
INSERT INTO tlj_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ote mu weema eghi sandu̱u̱ku̱ ya ndaghaano kandi odhodhooki̱ye kateni̱ mu maaso ghaayo. ");
INSERT INTO tlj_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Otaahi̱yemu meeja kandi otʼo bintu byayʼo. Du̱mbi̱ otaahi̱yemu kyakutʼo taala kandi otʼo taala syakiyo. ");
INSERT INTO tlj_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ote kyaku̱tu̱mi̱kʼo bubbani̱ kya feeja mu maaso ghaa sandu̱u̱ku̱ ya ndaghaano kandi ote kateni̱ haa mulyango ghwa weema ehi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Ote kyakuhongelʼo bihonguwa byona byokeei̱ye mu maaso ghaa mulyango ghwa weema ehi̱ki̱li̱i̱ye, weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ote bbaafu haagati ya weema ya kusanga-sangaanamu na kyakuhongelʼo bihonguwa kandi otemu maasi. ");
INSERT INTO tlj_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Okole jighati̱ kweli̱ghi̱i̱li̱li̱ya weema eghi kandi ote kateni̱ haa geeti̱ ya lugho lwa jighati̱ eghi. ");
INSERT INTO tlj_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Okwate mafu̱ta ghaa kusiigha kandi oghasiighe haa weema ehi̱ki̱li̱i̱ye na bu̱li̱ kintu ekilimu, oghyeli̱ye na bintu byayʼo byona kandi ekuba ehi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Osiighe mafu̱ta haa kyakuhongelʼo bihonguwa byona byokeei̱ye na byaku̱koleesi̱yʼo byona, weeli̱ye kyakuhongelʼo bihonguwa eki kandi kikufooka ki̱hi̱ki̱li̱i̱ye kwonini. ");
INSERT INTO tlj_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Osiighe mafu̱ta haa bbaafu na haa kyakughitʼo kandi obyeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Oleete Alooni̱ na batabani̱ be haa mulyango ghwa weema ya kusanga-sangaanamu kandi obanaabi̱ye na maasi. ");
INSERT INTO tlj_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Olu̱wi̱ke Alooni̱ bi̱lu̱waalo bi̱hi̱ki̱li̱i̱ye bya bu̱hongi̱, omusiighe mafu̱ta kandi omweli̱ye, niikuwo agubhe ku̱mpeeleli̱ya nga mu̱hongi̱. ");
INSERT INTO tlj_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Oleete batabani̱ baa Alooni̱ kandi obalu̱wi̱ke byaku̱lu̱waala mukati byabo. ");
INSERT INTO tlj_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Obasiighe mafu̱ta ngoku waaghasi̱i̱ghi̱ye esebo, niikuwo bagubhe ku̱mpeeleli̱ya nga bahongi̱. Kusiigha mafu̱ta Alooni̱ na batabani̱ be, kukubafoola na baasukulu baabo kuba bahongi̱ mu mijo yabo yoona eghi ekwisa.” ");
INSERT INTO tlj_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Musa aakola bu̱li̱ kintu ngoku Mukama aamulaghiiye. ");
INSERT INTO tlj_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Nahabweki aakwela weema ehi̱ki̱li̱i̱ye haa kilo kyʼoku̱du̱bha kya kweli̱ kwokubanja kwa mwaka ghwakabili haanu̱ma ya ku̱lu̱gha Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musa aakola ncuba, aataamu fuleemu, aakwatani̱ya mikiiko kandi aakwela weema ehi̱ki̱li̱i̱ye, du̱mbi̱ aasimba mpaghi sya kutʼo kateni̱. ");
INSERT INTO tlj_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Aabi̱swi̱ki̱la na weema kandi aata haa weema ehi̱ki̱li̱i̱ye eghi kya ku̱ghi̱swi̱ki̱la, ngoku Mukama aamulaghiiye. ");
INSERT INTO tlj_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Aakwata bihande bibili bya mabaale bya ndaghaano, aabita mu sandu̱u̱ku̱ ya ndaghaano, aata mpaghi mu mpete syayʼo kandi aatʼo kyakughaniililʼo bantu bibhi kyaku̱swi̱ki̱la haagu̱u̱li̱. ");
INSERT INTO tlj_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Aataahi̱ya mu weema ehi̱ki̱li̱i̱ye sandu̱u̱ku̱ ya ndaghaano kandi aata kateni̱ haagati ya weema eghi ku̱bi̱sa sandu̱u̱ku̱ ya ndaghaano, ngoku Mukama aamulaghiiye. ");
INSERT INTO tlj_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Musa aata meeja mu weema ya kusanga-sangaanamu haa luhande lwʼelughulu lwa weema ehi̱ki̱li̱i̱ye eghi, mu maaso ghaa kateni̱ eghi. ");
INSERT INTO tlj_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Aata mugaati̱ haa meeja eghi mu maaso ghaa Mukama, ngoku Mukama aamulaghiiye. ");
INSERT INTO tlj_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Aata kyakutʼo taala haa luhande lwʼeku̱wa lwa weema ya kusanga-sangaanamu kandi kyalolana na meeja ya kuhongelʼo mugaati̱ mu weema ehi̱ki̱li̱i̱ye eghi. ");
INSERT INTO tlj_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Aatʼo taala mu maaso ghaa Mukama, ngoku Mukama aamulaghiiye. ");
INSERT INTO tlj_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Musa aata kyakuhongelʼo bihonguwa kya feeja mu weema ya kusanga-sangaanamu eghi, mu maaso ghaa kateni̱ eghi. ");
INSERT INTO tlj_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Aatu̱mi̱ka haa kyakuhongelʼo bihonguwa eki bubbani̱ busasi̱ye ngoku Mukama aamulaghiiye. ");
INSERT INTO tlj_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Du̱mbi̱ aata kateni̱ enji haa mulyango ghwa weema ehi̱ki̱li̱i̱ye eghi. ");
INSERT INTO tlj_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Musa aata kyakuhongelʼo bihonguwa byona byokeei̱ye haai na mulyango ghwa weema ehi̱ki̱li̱i̱ye, weema ya kusanga-sangaanamu kandi aahongelʼo bihonguwa byona byokeei̱ye na bihonguwa bya bilimuwa, ngoku Mukama aamulaghiiye. ");
INSERT INTO tlj_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Aata bbaafu haagati ya weema ya kusanga-sangaanamu na kyakuhongelʼo bihonguwa kandi aataamu maasi ghaa kunaaba. ");
INSERT INTO tlj_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Maasi agha niigho Musa, Alooni̱ na batabani̱ baa Alooni̱ baanaabagha mu ngalo na mu maghulu. ");
INSERT INTO tlj_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Baanaabagha mbaghenda mu weema ya kusanga-sangaanamu kedha mbeebinga kyakuhongelʼo bihonguwa, ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Du̱mbi̱ Musa aakwela jighati̱ kweli̱ghi̱i̱li̱li̱ya weema ehi̱ki̱li̱i̱ye na kyakuhongelʼo bihonguwa kandi aata kateni̱ haa geeti̱ ya jighati̱ eghi. Nahabweki Musa aamala mulimo oghu. ");
INSERT INTO tlj_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Du̱mbi̱ kicu kyaswi̱ki̱la weema ya kusanga-sangaanamu kandi ki̱ti̱i̱ni̱sa kya Mukama kyasula mu weema ehi̱ki̱li̱i̱ye eghi. ");
INSERT INTO tlj_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Musa ataagubha kutaaha mu weema ya kusanga-sangaanamu nanga kicu kikaba ki̱ghi̱swi̱ki̱ye kandi ki̱ti̱i̱ni̱sa kya Mukama kiisuuye mu weema ehi̱ki̱li̱i̱ye eghi. ");
INSERT INTO tlj_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Mu lughendo lwona lwa Banai̱saaleeli̱, kicu eki kyakaamukagha haa weema ehi̱ki̱li̱i̱ye eghi, du̱mbi̱ Banai̱saaleeli̱ baatandika ku̱lu̱gha mu ki̱i̱kalo eki kandi baghenda mu ki̱i̱kalo kinji. ");
INSERT INTO tlj_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Bhaatu kicu eki kyakabaagha kitalu̱ghi̱ye haa weema ehi̱ki̱li̱i̱ye eghi, baghoona mu ki̱i̱kalo eki ku̱hi̱ki̱ya ki̱todhi̱ye ku̱lu̱ghʼo. ");
INSERT INTO tlj_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Nahabweki kicu kya Mukama kyakalagha haa weema ehi̱ki̱li̱i̱ye ntangaali̱ kandi mulilo ghwakagha mu kicu eki mukilo, mu maaso ghaa Banai̱saaleeli̱ boona mu ngendo syabo syona.");
INSERT INTO tlj_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Mukama aabilikila Musa kandi aabu̱gha naye ku̱lu̱gha mu weema ya kusanga-sangaanamu, aamughila ati, ");
INSERT INTO tlj_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Obu̱ghe na Banai̱saaleeli̱ kandi obaghile oti, ‘Kaakuba muntu weena mu enu̱we abbala kutwala kihonguwa ewaa Mukama, akiiyaghe mu nte, ntaama kedha mbu̱li̱ siye. ");
INSERT INTO tlj_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘Kaakuba kihonguwa kyona kyokeei̱ye kiba eki̱lu̱ghi̱ye mu nte siye, atwale yabusaasa kandi eghi etali na kamogo. Ali na kughileeta haa mulyango ghwa weema ya kusanga-sangaanamu niikuwo Mukama aghi̱si̱i̱me. ");
INSERT INTO tlj_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Muntu oghu ali na kuta mukono ghuwe haa mutuwe ghwa kihonguwa kyona kyokeei̱ye eki kandi Mukama aku̱ki̱si̱i̱ma haabwa mukolo ghwa muntu oghu kughaniluwa bibhi biye. ");
INSERT INTO tlj_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Ntu̱u̱li̱ ya nte eghi aghisalile mu maaso ghaa Mukama kandi bahongi̱ batabani̱ baa Alooni̱, batwale saghama yayo baghimisange haa mpande syona sya kyakuhongelʼo bihonguwa ekili haai na mulyango ghwa weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Kihonguwa kyona kyokeei̱ye eki akibaaghe kandi ajombakake nyama syakiyo mu myana. ");
INSERT INTO tlj_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Batabani̱ baa mu̱hongi̱ Alooni̱, bali na ku̱tu̱mi̱ka mulilo haa kyakuhongelʼo bihonguwa kandi bapangʼo nkui. ");
INSERT INTO tlj_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Du̱mbi̱ bahongi̱ batabani̱ baa Alooni̱, bapange haa mulilo oghu nyama esi baajombakaki̱ye mu myana, mutuwe na bisabu̱, haa mulilo ghwa kyakuhongelʼo bihonguwa eki. ");
INSERT INTO tlj_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Muntu oghu ali na kunaabi̱ya na maasi byenda na bilenge, du̱mbi̱ mu̱hongi̱ ooki̱ye kisolo eki kyona haa kyakuhongelʼo bihonguwa. Eki kibe kihonguwa kyona kyokeei̱ye, kihonguwa bookeei̱ye haa mulilo, eki kusasa kwakiyo ku̱dheedhi̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘Kaakuba kihonguwa eki kiba kihonguwa kyona kyokeei̱ye ku̱lu̱gha mu ntaama kedha mbu̱li̱, ahonge yabusaasa kandi eghi etali na kamogo. ");
INSERT INTO tlj_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Kisolo eki akisalile haa luhande lwa elughulu ya kyakuhongelʼo bihonguwa mu maaso ghaa Mukama. Du̱mbi̱ bahongi̱ batabani̱ baa Alooni̱ bamisange saghama yakiyo haa mpande syona sya kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Kisolo eki akiiyemu myana, mutuwe na bisabu̱ kandi mu̱hongi̱ oghu abipange kusemeeye haa nkui esili haa mulilo haa kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Muntu oghu ali na kunaabi̱ya na maasi byenda na bilenge kandi mu̱hongi̱ aleete nyama sya kisolo eki syona kandi asyoki̱ye haa kyakuhongelʼo bihonguwa. Eki kibe kihonguwa kyona kyokeei̱ye, eki bookeei̱ye haa mulilo, eki kusasa kwakiyo ku̱dheedhi̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘Kaakuba muntu ahongela Mukama kihonguwa kyona kyokeei̱ye kya noni̱, ali na kuleeta kihonguwa kya ki̱i̱bbi̱mbo kedha kaapi̱i̱so. ");
INSERT INTO tlj_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Mu̱hongi̱ atwale noni̱ eghi haa kyakuhongelʼo bihonguwa, aki̱tu̱wʼo mutuwe kandi aghwokeli̱ye haa kyakuhongelʼo bihonguwa. Saghama ya noni̱ eghi aghitoonakaki̱ye haa mpande sya kyakuhongelʼo bihonguwa eki. ");
INSERT INTO tlj_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Mu̱hongi̱ aaye mu noni̱ eghi kisaki̱li̱yo kyayʼo na ebili mukati yakiyo kandi abikube haa luhande lwa bu̱lu̱gha ejooba bwa kyakuhongelʼo bihonguwa mu ki̱i̱kalo hambali bakukubagha ki̱bu̱. ");
INSERT INTO tlj_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Mu̱hongi̱ akwate mapapa ghaa noni̱ eghi kandi aghyati̱ye, bhaatu ataghi̱tu̱wamu kabili, du̱mbi̱ aghyokeli̱ye haa mulilo ghwa kyakuhongelʼo bihonguwa. Eki kibe kihonguwa kyona kyokeei̱ye, eki bookeei̱ye haa mulilo, eki kusasa kwakiyo ku̱dheedhi̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘Kaakuba muntu aleeta kihonguwa kya bilimuwa ewaa Mukama, kihonguwa kiye kibe kya nsyano esemeeye. Akiseesʼo mafu̱ta ghaa biti oli̱va, akitʼo bubbani̱ ");
INSERT INTO tlj_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","kandi akitwalile bahongi̱ batabani̱ baa Alooni̱. Mu̱hongi̱ aaye haa nsyano esemeeye eghi ngalo emui, akwate mafu̱ta na bubbani̱ kandi abyokeli̱ye haa kyakuhongelʼo bihonguwa, nga kyakuusukilʼo ngoku baaki̱hongi̱ye ewaa Mukama. Eki kibe kihonguwa bookeei̱ye haa mulilo, eki kusasa kwakiyo ku̱dheedhi̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ebi̱ku̱ti̱ghala haa kihonguwa kya bilimuwa eki, bibe bya Alooni̱ na batabani̱ be kandi kibe kihonguwa bookeei̱ye haa mulilo, nanga ni ki̱twi̱ke kya kihonguwa ki̱hi̱ki̱li̱i̱ye kwonini eki bahongeeye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘Kaakuba muntu aleeta kihonguwa kya bilimuwa kya migaati̱ ateekeeye haa ki̱tu̱mi̱ko, migaati̱ eghi eli na kuba ya nsyano esemeeye, eghi etalimu ki̱tu̱mbi̱so kandi eghi etabuuyemu mafu̱ta ghaa biti oli̱va, kedha capati esitalimu ki̱tu̱mbi̱so kandi esi̱si̱i̱ghi̱yʼo mafu̱ta agha. ");
INSERT INTO tlj_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","“ ‘Kaakuba ateekela kihonguwa kya bilimuwa kya migaati̱ mu capu̱li̱ya eghi yeeyali̱ye, ekulaghiluwa kuba ya nsyano esemeeye, eghi etabuuyemu mafu̱ta ghaa biti oli̱va kandi eghi etalimu ki̱tu̱mbi̱so. ");
INSERT INTO tlj_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Migaati̱ eghi aghibheghange kandi aseesʼo mafu̱ta ghaa biti oli̱va, eki kibe kihonguwa kiye kya bilimuwa. ");
INSERT INTO tlj_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Kaakuba kihonguwa kya bilimuwa kiye kya migaati̱ akiteekela mu capu̱li̱ya, akoleesi̱ye nsyano esemeeye kandi migaati̱ eghi aghi̱teeki̱ye mafu̱ta ghaa biti oli̱va. ");
INSERT INTO tlj_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Aleete kihonguwa kiye kya bilimuwa eki ewaa Mukama. Akihe mu̱hongi̱ kukitwala haa kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Mu̱hongi̱ aaye bikee haa bihonguwa bya bilimuwa ebi nga kaakuusukilʼo kandi abyokeli̱ye haa kyakuhongelʼo bihonguwa, eki kibe kihonguwa bookeei̱ye haa mulilo, eki kusasa kwakiyo ku̱dheedhi̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ebi̱ku̱ti̱ghala haa kihonguwa kya bilimuwa eki, bibe bya Alooni̱ na batabani̱ be kandi kibe kihonguwa bookeei̱ye haa mulilo, nanga ni ki̱twi̱ke kya kihonguwa ki̱hi̱ki̱li̱i̱ye kwonini, eki bahongeeye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘Kihonguwa kyona kya bilimuwa eki mukuleeta kuhaayo ewaa Mukama kitabamu ki̱tu̱mbi̱so nanga tamuli na kwoki̱ya ki̱tu̱mbi̱so kedha bwoki mu kihonguwa bookeei̱ye haa mulilo kya Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Mukugubha kuta ki̱tu̱mbi̱so kedha bwoki mu kihonguwa kya mughanulo eki mukuleetela Mukama, bhaatu batabihongela haa kyakuhongelʼo bihonguwa, kuba kihonguwa eki kusasa kwakiyo ku̱dheedhi̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Mutaaghe kisula mu bu̱li̱ kihonguwa kyanu kya bilimuwa. Kisula kyoleki̱ye ndaghaano eghi Luhanga aakoli̱ye na Banai̱saaleeli̱. Nahabweki mutaliibululuwa kuta kisula mu bihonguwa byanu byona. ");
INSERT INTO tlj_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘Kaakuba muleeta kihonguwa kya mughanulo ghwa bilimuwa ewaa Mukama, muhaagheyo ebikalangi̱ye haa mulilo kandi ebisekuuye. ");
INSERT INTO tlj_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Kihonguwa kyanu eki mukitaaghʼo mafu̱ta ghaa biti oli̱va na bubbani̱, nanga ni kihonguwa kya bilimuwa. ");
INSERT INTO tlj_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Mu̱hongi̱ aayaghe haa nsyano, haa mafu̱ta ghaa biti oli̱va na bubbani̱ bwona, nga kyakuusukilʼo kandi abyoki̱ye haa mulilo nga kihonguwa bookeei̱ye haa mulilo kya Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘Kaakuba muntu ahayo kihonguwa kya bu̱si̱nge ewaa Mukama, aheyo kisolo kyabusaasa kedha kyabukali̱ ekitali na kamogo. ");
INSERT INTO tlj_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Muntu oghu ate mukono ghuwe haa mutuwe ghwa kihonguwa kiye eki kandi akisalile haa mulyango ghwa weema ya kusanga-sangaanamu. Bahongi̱ batabani̱ baa Alooni̱ bamisange saghama ya kisolo eki haa mpande syona sya kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Ku̱lu̱gha haa kihonguwa kya bu̱si̱nge, mu̱hongi̱ ali na kuleeta bisabu̱ byona ebi̱swi̱ki̱ye byenda kandi abihonge ewaa Mukama, nga kihonguwa bookeei̱ye haa mulilo. ");
INSERT INTO tlj_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","Ooki̱ye dhee mpi̱gho syombi na bisabu̱ byasiyo ebilabhaane na mughongo, na ki̱twi̱ke kisemeeye kya bu̱ne. ");
INSERT INTO tlj_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Du̱mbi̱ bahongi̱ batabani̱ baa Alooni̱ babyokeli̱ye haa kyakuhongelʼo bihonguwa, haagu̱u̱li̱ ya kihonguwa kyona kyokeei̱ye ekili haa nkui esikwete kwakʼo mulilo. Eki kibe kihonguwa bookeei̱ye haa mulilo, eki kusasa kwakiyo ku̱dheedhi̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘Kaakuba muntu ahonga ntaama kedha mbu̱li̱ ku̱lu̱gha mu bisolo biye nga kihonguwa kya bu̱si̱nge ewaa Mukama, ali na kuleeta yabusaasa kedha yabukali̱ eghi etali na kamogo. ");
INSERT INTO tlj_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Kaakuba aleeta kyana kya ntaama nga kihonguwa kiye, ali na kukileeta mu maaso ghaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Muntu oghu ate mukono ghuwe haa mutuwe ghwakiyo kandi akisalile mu maaso ghaa weema ya kusanga-sangaanamu. Bahongi̱ batabani̱ baa Alooni̱ bamisange saghama ya kisolo eki haa mpande syona sya kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Mu̱hongi̱ ali na kuhonga bisabu̱ nga kihonguwa kya bu̱si̱nge ewaa Mukama eki bookeei̱ye haa mulilo. Ahonge bisabu̱, bisabu̱ byona bya haa mukila ku̱hi̱ka haa eku̱wa lya haa mughongo, bisabu̱ bya haa mughongo, bisabu̱ ebi̱swi̱ki̱ye byenda, ");
INSERT INTO tlj_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","mpi̱gho syombi na bisabu̱ byasiyo, bisabu̱ bya haa mughongo na ki̱twi̱ke kisemeeye kya bu̱ne. ");
INSERT INTO tlj_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Ebi byona mu̱hongi̱ ali na ku̱byoki̱ya haa kyakuhongelʼo bihonguwa nga kihonguwa bookeei̱ye haa mulilo mu maaso ghaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘Kaakuba muntu ahayo mbu̱li̱ nga kihonguwa, ali na kughileeta mu maaso ghaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Muntu oghu ate mukono ghuwe haa mutuwe ghwa mbu̱li̱ eghi kandi aghisalile mu maaso ghaa weema ya kusanga-sangaanamu. Bahongi̱ batabani̱ baa Alooni̱ bamisange saghama yayo haa mpande syona sya kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Mu̱hongi̱ ali na kuhaayo bimui haa bi̱twi̱ke bya kihonguwa eki nga kihonguwa bookeei̱ye haa mulilo ewaa Mukama. Ali na kwoki̱ya bisabu̱ byona ebi̱swi̱ki̱ye byenda, ");
INSERT INTO tlj_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","mpi̱gho syombi na bisabu̱ byasiyo, bisabu̱ bya haa mughongo na ki̱twi̱ke kisemeeye kya bu̱ne. ");
INSERT INTO tlj_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Ebi byona mu̱hongi̱ abyokeli̱ye haa kyakuhongelʼo bihonguwa nga kihonguwa bookeei̱ye haa mulilo, eki kusasa kwakiyo ku̱dheedhi̱ye Mukama. Bisabu̱ byona ni bya Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Taaliyo Munai̱saaleeli̱ nʼomui oghu ali na kuliya kisabu̱ kedha saghama. Eki nkilaghilo bali na kukwata mu mijo yabo yoona bilo nʼebilo kandi hoona hambali balaakalagha.’ ” ");
INSERT INTO tlj_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Oghile Banai̱saaleeli̱ oti, ‘Kini niikiyo kili na kukoluwa kaakuba muntu asi̱i̱sa atakighendeleeye kandi akola kintu kyona eki bilaghilo bya Mukama bitangi̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘Kaakuba mu̱hongi̱ basi̱i̱ghi̱ye mafu̱ta asi̱i̱sa kandi aleeteleja Banai̱saaleeli̱ kuuhibuwʼo musango, ali na kuhaayo ewaa Mukama ntu̱u̱li̱ ya nte haabwa kibhi eki aakoli̱ye kandi eghi etali na kamogo. ");
INSERT INTO tlj_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Ali na kuleeta ntu̱u̱li̱ ya nte eghi haa mulyango ghwa weema ya kusanga-sangaanamu mu maaso ghaa Mukama. Ali na kuta mukono ghuwe haa mutuwe ghwayʼo kandi aghisalile mu maaso ghaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Du̱mbi̱ mu̱hongi̱ oghu basi̱i̱ghi̱ye mafu̱ta aaye haa saghama ya ntu̱u̱li̱ ya nte eghi kandi atwale saghama eghi mu weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Mu̱hongi̱ akoti̱ye kyala kiye mu saghama eghi kandi aghimisange milundi musanju̱ mu maaso ghaa Mukama, mu maaso ghaa kateni̱ eghi etambulani̱i̱yemu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye na Ki̱i̱kalo Ki̱hi̱ki̱li̱i̱ye kusaali̱ya byona. ");
INSERT INTO tlj_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Mu̱hongi̱ oghu asiighe saghama haa mahembe ghaa kyakuhongelʼo bihonguwa kya ku̱tu̱mi̱kʼo bubbani̱ mu maaso ghaa Mukama, mu weema ya kusanga-sangaanamu. Saghama ya ntu̱u̱li̱ ya nte eghi eku̱ti̱ghalʼo, aghiseese haa ki̱twi̱ke kya hansi ya kyakuhongelʼo bihonguwa byona byokeei̱ye, ekili haai na mulyango ghwa weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Aaye mu ntu̱u̱li̱ ya nte eghi bisabu̱ byona ebi̱swi̱ki̱ye byenda kubihonga nga kihonguwa kya kughanila bibhi. ");
INSERT INTO tlj_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","Aayemu mpi̱gho syombi na bisabu̱ byasiyo, bisabu̱ bya haa mughongo na ki̱twi̱ke kisemeeye kya bu̱ne. ");
INSERT INTO tlj_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Mu̱hongi̱ atwale bisabu̱ ebi aahi̱ye mu ntu̱u̱li̱ ya nte eghi kandi abihonge ngoku aakoli̱ye bisabu̱ bya kihonguwa kya bu̱si̱nge. Du̱mbi̱ mu̱hongi̱ oghu ali na ku̱byoki̱ya haa kyakuhongelʼo bihonguwa byona byokeei̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Bhaatu luhu lwa ntu̱u̱li̱ ya nte eghi, nyama, mutuwe, bilenge, byenda, mabhi̱ ghaayʼo, ");
INSERT INTO tlj_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ntu̱u̱li̱ ya nte eghi yoona aghiiye hambali baghooneeye. Aghitwale enja mu ki̱i̱kalo kyeli̱ye ewaanu hambali bakukubagha ki̱bu̱. Aghyoki̱ye haa nkui esikwete kwakʼo mulilo haa ntuumo ya ki̱bu̱ eki. ");
INSERT INTO tlj_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘Kaakuba ki̱bbu̱la kyona kya Banai̱saaleeli̱ basi̱i̱sa batakighendeleeye kandi batu̱wa kimui haa ebi Mukama aalaghiiye, nankabha ki̱bbu̱la kya Banai̱saaleeli̱ batamanya eki baakoli̱ye, musango ghubasi̱ngi̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Kaakuba bamanya kibhi eki baakoli̱ye, ki̱bbu̱la kya Banai̱saaleeli̱ bali na kuleeta ntu̱u̱li̱ ya nte nga kihonguwa haabwa kibhi eki kandi baghileete mu maaso ghaa weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Beebembeli̱ baa ki̱bbu̱la kya Banai̱saaleeli̱ bate mikono yabo haa mutuwe ghwa ntu̱u̱li̱ ya nte eghi mu maaso ghaa Mukama. Du̱mbi̱ ntu̱u̱li̱ ya nte eghi baghisalile mu maaso ghaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Mu̱hongi̱ oghu basi̱i̱ghi̱ye mafu̱ta aaye haa saghama ya ntu̱u̱li̱ ya nte eghi kandi aghitwale mu weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Mu̱hongi̱ akoti̱ye kyala kiye mu saghama eghi kandi aghimisange milundi musanju̱ mu maaso ghaa Mukama, mu maaso ghaa kateni̱ yʼomu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Ali na kuuya haa saghama eghi kandi aghisiighe haa mahembe ghaa kyakuhongelʼo bihonguwa kya ku̱tu̱mi̱kʼo bubbani̱ mu maaso ghaa Mukama, mu weema ya kusanga-sangaanamu. Saghama eghi eku̱ti̱ghalʼo, aghiseese haa ki̱twi̱ke kya hansi ya kyakuhongelʼo bihonguwa hambali bakuhongelagha kihonguwa kyona kyokeei̱ye, ekili haai na mulyango ghwa weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Ali na kuuya mu ntu̱u̱li̱ ya nte eghi bisabu̱ byona kandi abyokeli̱ye haa kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Mu̱hongi̱ akole ntu̱u̱li̱ ya nte eghi ngoku aakoli̱ye ntu̱u̱li̱ ya nte eghi baahaayeyo nga kihonguwa haabwa kibhi. Akole atiyo dhee kihonguwa haabwa mukolo ghwa kughaniluwa kibhi eki Banai̱saaleeli̱ baakoli̱ye kandi Mukama akubaghanila. ");
INSERT INTO tlj_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Ntu̱u̱li̱ ya nte eghi aghitwale enja ya hambali baghooneeye kandi aghyoki̱ye ngoku ookeei̱ye ntu̱u̱li̱ ya nte yʼoku̱du̱bha. Eki kibe kihonguwa haabwa kibhi eki ki̱bbu̱la kya Banai̱saaleeli̱ baakoli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘Kaakuba mwebembeli̱ asi̱i̱sa atakighendeleeye kandi aakola kimui haa bilaghilo ebi Mukama Luhanga wee bitangi̱ye kutakola, musango ghu̱mu̱si̱ngi̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Haanu̱ma ya kumughambila kibhi eki aakoli̱ye, ali na kuhaayo kihonguwa kya mbu̱li̱ yabusaasa eghi etali na kamogo. ");
INSERT INTO tlj_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Ali na kuta mukono ghuwe haa mutuwe ghwa mbu̱li̱ eghi kandi aghisalile mu maaso ghaa Mukama, mu ki̱i̱kalo hambali bakusalilagha bu̱li̱ kihonguwa kyona kyokeei̱ye. Eki kibe kihonguwa haabwa kibhi. ");
INSERT INTO tlj_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Du̱mbi̱ mu̱hongi̱ aaye haa saghama ya kihonguwa baahaayeyo haabwa kibhi, akoti̱yemu kyala kiye, aghisiighe haa mahembe ghaa kyakuhongelʼo bihonguwa hambali bakuhongelagha kihonguwa kyona kyokeei̱ye kandi eghi eku̱ti̱ghalʼo aghiseese haa ki̱twi̱ke kya hansi ya kyakuhongelʼo bihonguwa eki. ");
INSERT INTO tlj_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Mu̱hongi̱ oghu ooki̱ye bisabu̱ byayʼo byona haa kyakuhongelʼo bihonguwa, ngoku aakoli̱ye bisabu̱ bya kihonguwa kya bu̱si̱nge kandi akole mukolo ghwa muntu oghu kughaniluwa kibhi kiye kandi akughaniluwa. ");
INSERT INTO tlj_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘Kaakuba muntu weena mu Banai̱saaleeli̱ asi̱i̱sa atakighendeleeye kandi aakola kimui haa bintu ebi Mukama aalaghiiye kutakola, musango ghu̱mu̱si̱ngi̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Haanu̱ma ya kughambila muntu oghu kibhi eki akoli̱ye, ali na kuhaayo mbu̱li̱ yabukali̱ eghi etali na kamogo nga kihonguwa haabwa kibhi eki aakoli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Muntu oghu ali na kuta mukono ghuwe haa mutuwe ghwa kihonguwa aahaayeyo haabwa kibhi eki aakoli̱ye kandi kisolo eki akisalile mu ki̱i̱kalo hambali bakusalilagha bu̱li̱ kihonguwa kyona kyokeei̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Du̱mbi̱ mu̱hongi̱ atwale haa saghama eghi, akoti̱yemu kyala kiye, aghisiighe haa mahembe ghaa kyakuhongelʼo bihonguwa hambali bakuhongelagha kihonguwa kyona kyokeei̱ye kandi eghi eku̱ti̱ghalʼo aghiseese haa ki̱twi̱ke kya hansi ya kyakuhongelʼo bihonguwa eki. ");
INSERT INTO tlj_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Mbu̱li̱ eghi mu̱hongi̱ ali na kuuyamu bisabu̱ byayʼo byona, ngoku aakoli̱ye bisabu̱ bya kihonguwa kya bu̱si̱nge. Bisabu̱ ebi byona abyoki̱ye haa kyakuhongelʼo bihonguwa, kibe eki kusasa kwakiyo ku̱dheedhi̱ye Mukama. Du̱mbi̱ mu̱hongi̱ akole mukolo ghwa muntu oghu kughaniluwa bibhi biye kandi Mukama akumughanila. ");
INSERT INTO tlj_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘Kaakuba muntu oghu aleeta kyana kya ntaama nga kihonguwa kiye haabwa kibhi eki akoli̱ye, ali na kuleeta kyabukali̱ ekitali na kamogo. ");
INSERT INTO tlj_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Ali na kuta mukono ghuwe haa mutuwe ghwa kisolo eki kandi akisale nga kihonguwa haabwa kibhi mu ki̱i̱kalo hambali bakusalilagha bu̱li̱ kihonguwa kyona kyokeei̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Mu̱hongi̱ akoti̱ye kyala kiye mu saghama ya kihonguwa haabwa kibhi kandi aghisiighe haa mahembe ghaa kyakuhongelʼo bihonguwa hambali bakuhongelagha bu̱li̱ kihonguwa kyona kyokeei̱ye kandi eghi eku̱ti̱ghalʼo aghiseese haa ki̱twi̱ke kya hansi ya kyakuhongelʼo bihonguwa eki. ");
INSERT INTO tlj_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Mu̱hongi̱ ali na kuuya mu mbu̱li̱ eghi bisabu̱ byayʼo byona, ngoku aakoli̱ye kyana kya ntaama kya kihonguwa kya bu̱si̱nge. Bisabu̱ ebi byona abyokeli̱ye haa kyakuhongelʼo bihonguwa, haagu̱u̱li̱ ya kihonguwa bookeei̱ye haa mulilo kya Mukama. Mu̱hongi̱ akole mukolo ghwa muntu oghu kughaniluwa kibhi eki aakoli̱ye kandi Mukama akumughanila. ");
INSERT INTO tlj_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘Kaakuba muntu asi̱i̱sa haabwa kubhenga kuha buukai̱so mu bantu haa kintu eki aaboone kedha aaghu̱u̱ye, ali na kufubiluwa. ");
INSERT INTO tlj_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘Kaakuba muntu aku̱mʼo kintu kyona eki̱teeli̱ye ewaanu, nga mu̱ku̱ ghwa kinyama kya mu kisaka eki̱teeli̱ye, kedha mu̱ku̱ ghwa kisolo eki̱teeli̱ye, kedha mu̱ku̱ ghwa kisolo ekikwekuluulilagha hansi eki̱teeli̱ye, akufooka ateeli̱ye nankabha abi̱sa bantu banji ngoku aaki̱ku̱mi̱yʼo, akufooka ateeli̱ye kandi musango ghu̱mu̱si̱ngi̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“ ‘Kaakuba muntu aku̱mʼo kintu kyona eki̱teeli̱ye eki̱lu̱ghi̱ye haa muntu onji, kikufoola oghu aaki̱ku̱mi̱yʼo kuba oghu ateeli̱ye. Muntu oghu naamani̱ye eki aakoli̱ye, musango ghu̱mu̱si̱ngi̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“ ‘Kaakuba muntu alahila bwangu-bwangu kukola kintu kisemeeye kedha ki̱bhi̱i̱hi̱ye kedha alahila kukola kintu nga bantu banji boona, nankabha aba atakighendeleeye, muntu oghu naamani̱ye eki aakoli̱ye, musango ghu̱mu̱si̱ngi̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“ ‘Kaakuba muntu amanya ngoku musango ghu̱mu̱si̱ngi̱ye, ali na kwatula kibhi eki aakoli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Muntu oghu ali na kuleeta ewaa Mukama kyana kya ntaama kyabukali̱ kedha mbu̱li̱ yabukali̱ ku̱lu̱gha mu bisolo biye nga kihonguwa haabwa kibhi eki aakoli̱ye kandi mu̱hongi̱ ali na kukola mukolo ghwa muntu oghu kughaniluwa kibhi kiye eki. ");
INSERT INTO tlj_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘Kaakuba muntu oghu aba ataakugubha kuhaayo kyana kya ntaama, ali na kuleeta ewaa Mukama bi̱i̱bbi̱mbo bibili kedha bwana bwa bu̱u̱pi̱i̱so bubili haabwa kibhi kiye. Emui haa noni̱ esi kuba kihonguwa haabwa kibhi kandi enji kuba kihonguwa kyona kyokeei̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Bihonguwa ebi abileete ewaa mu̱hongi̱ kandi mu̱hongi̱ adu̱bhe ahonge kihonguwa haabwa kibhi kya muntu oghu. Mu̱hongi̱ oghu atale kihonguwa eki bikiya bhaatu ataki̱tu̱wʼo mutuwe. ");
INSERT INTO tlj_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Aaye haa saghama ya kihonguwa haabwa kibhi kandi aghimisange haa luhande lumui lwa kyakuhongelʼo bihonguwa, eghi eku̱ti̱ghalʼo aghiseese haa ki̱twi̱ke kya hansi ya kyakuhongelʼo bihonguwa. Eki kibe kihonguwa haabwa kibhi. ");
INSERT INTO tlj_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Du̱mbi̱ mu̱hongi̱ ahonge noni̱ yaakabili kuba kihonguwa kyona kyokeei̱ye kusighikila haa bilaghilo. Akole mukolo ghwa muntu oghu kughaniluwa kibhi eki aakoli̱ye kandi Mukama akumughanila. ");
INSERT INTO tlj_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘Kaakuba muntu oghu aba ataakugubha kuhaayo bi̱i̱bbi̱mbo bibili kedha bwana bwa bu̱u̱pi̱i̱so bubili, ali na kuleeta ki̱lo emui ya nsyano esemeeye. Eki ni kihonguwa haabwa kibhi kiye. Mu nsyano eghi atatamu mafu̱ta ghaa biti oli̱va kedha bubbani̱, nanga ni kihonguwa haabwa kibhi. ");
INSERT INTO tlj_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Muntu oghu ali na kuleeta nsyano eghi ewaa mu̱hongi̱ kandi mu̱hongi̱ aayʼo ngalo emui nga kyakuusukilʼo kandi aghyokeli̱ye haa kyakuhongelʼo bihonguwa haagu̱u̱li̱ ya kihonguwa bookeei̱ye haa mulilo kya Mukama. Eki kibe kihonguwa haabwa kibhi. ");
INSERT INTO tlj_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Mu̱hongi̱ akolaghe atiyo mukolo ghwa muntu kughaniluwa bibhi ebi aakoli̱ye kandi muntu oghu akughaniluwa. Ebilati̱ghalagha haa kihonguwa eki bibaaghe bya mu̱hongi̱ ngoku ebi̱ku̱ti̱ghalagha haa kihonguwa kya bilimuwa bikubaagha byabo.’ ” ");
INSERT INTO tlj_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Kaakuba muntu asi̱i̱sa haabwa kubhenga kuhaayo ewaa Mukama bintu bi̱hi̱ki̱li̱i̱ye, akuba naasi̱i̱sa nankabha akikola atakighendeleeye. Ali na kuhaayo kihonguwa kya nsasu̱li̱ ewaa Mukama ntu̱u̱li̱ ya ntaama kedha mbu̱li̱ eghi etali na kamogo kandi eghi ehi̱ki̱ye kwonini kusighikila haa ki̱pi̱i̱mo kya siliva mu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. Ni kihonguwa kya kuuhibuwʼo musango. ");
INSERT INTO tlj_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Ali na kusasula haabwa kintu ki̱hi̱ki̱li̱i̱ye eki aasaaghu̱u̱we kuhaayo ewaa Mukama kandi ongelʼo kimui kyakataano kya muhendo oghu. Mu̱hongi̱ akole mukolo ghwa muntu oghu kughaniluwa bibhi biye kandi ahonge ntu̱u̱li̱ ya ntaama eghi nga kihonguwa kya kuuhibuwʼo musango kandi muntu oghu akughaniluwa. ");
INSERT INTO tlj_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Kaakuba muntu asi̱i̱sa kandi aakola kimui haa ebi Mukama alaghiiye, nankabha aba atakimani̱ye, musango ghu̱mu̱si̱ngi̱ye kandi ali na kufubiluwa. ");
INSERT INTO tlj_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Muntu oghu ali na kuleeta ewaa mu̱hongi̱ ntu̱u̱li̱ ya ntaama nga kihonguwa kya kuuhibuwʼo musango ku̱lu̱gha mu bisolo biye, eghi etali na kamogo kedha asasule muhendo oghu̱hi̱ki̱ye kisolo eki. Mu̱hongi̱ akole mukolo ghwa muntu oghu kughaniluwa kibhi eki aakoli̱ye atakighendeleeye kandi muntu oghu akughaniluwa. ");
INSERT INTO tlj_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ntaama eghi ni kihonguwa kya kuuhibuwʼo musango, nanga muntu oghu musango ghu̱mu̱si̱ngi̱ye haabwa kukola kintu ki̱bhi̱i̱hi̱ye mu maaso ghaa Mukama.” ");
INSERT INTO tlj_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Kaakuba muntu asi̱i̱sa kandi ataba mwesighibuwa ewaa Mukama haabwa kudimaaga muliilanuwa wee haa kintu eki aamuhaaye kedha aamu̱ti̱ghi̱i̱ye kuloleelela kedha amwibhʼo kintu kiye kedha amubona-boni̱ya, ");
INSERT INTO tlj_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","kedha akoma kintu kya muunakiye ekyabu̱li̱ye kandi akyehighaana ati taali nakiyo kedha alahila ati taakiboone, ");
INSERT INTO tlj_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","kaakuba muntu asi̱i̱sa haabwa kukola kimui haa bintu ebi kandi amanya ngoku musango ghu̱mu̱si̱ngi̱ye, ali na ku̱ku̱u̱ki̱ya kintu eki muliilanuwa wee aamuhaaye, kedha eki aamu̱ti̱ghi̱i̱ye, kedha eki aabhi̱ye, kedha kintu ekyabu̱li̱ye eki aakomi̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Kaakuba muntu asi̱i̱sa mu ghumui haa milingo eghi, ali na kusasulamu kintu eki aatwete mu mulingo ghutahi̱ki̱ye kandi ongelʼo muhendo ghwengaane na kimui kyakataano ghwa kintu eki maki̱ku̱u̱ki̱li̱ya mukama wakiyo kandi kilo eki kyonini aheyo kihonguwa kiye kya kuuhibuwʼo musango. ");
INSERT INTO tlj_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Muntu oghu ali na kuleeta ewaa mu̱hongi̱ ntu̱u̱li̱ ya ntaama eghi etali na kamogo, aghiiye mu bisolo biye kandi eghi ehi̱ki̱ye muhendo ghwa kihonguwa kya kuuhibuwʼo musango, aghiheyo nga kihonguwa ewaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Mu̱hongi̱ akole mukolo ghwa muntu oghu kughaniluwa kibhi eki mu maaso ghaa Mukama kandi akughaniluwa ebi aakoli̱ye ebyaleki̱ye musango ghwamu̱si̱nga.” ");
INSERT INTO tlj_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Olaghile Alooni̱ na batabani̱ be oti, ‘Bini niibiyo bilaghilo haa kihonguwa kyona kyokeei̱ye. Kihonguwa kyona kyokeei̱ye kili na kuukala haa mulilo ghwa kyakuhongelʼo bihonguwa mukilo yoona ku̱hi̱ki̱ya nkyambisi kandi mulilo ghuli na kuukala ngunaaka haa kyakuhongelʼo bihonguwa eki. ");
INSERT INTO tlj_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Mu̱hongi̱ ali na ku̱lu̱waala biigandulo biye binjelu na mpale njelu ya mukati eghi elabhaane na mubili, du̱mbi̱ aaye haa mulilo ki̱bu̱ kya kihonguwa kyona kyokeei̱ye kandi akite haakpengbu̱ ya kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Du̱mbi̱ aayemu bi̱lu̱waalo biye bya bu̱hongi̱, alu̱waale ngoye sinji kandi aheeke ki̱bu̱ akitwale enja ya hambali baghooneeye mu ki̱i̱kalo kyeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Mulilo ghwa kyakuhongelʼo bihonguwa ghuli na kuukala ngunaaka kandi ghutali̱ma. Mu̱hongi̱ ali na kwongelʼo nkui bu̱li̱ nkyambisi, apange kihonguwa kyona kyokeei̱ye eki haa mulilo oghu kandi ookeli̱yʼo bisabu̱ bya bihonguwa bya bu̱si̱nge. ");
INSERT INTO tlj_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Mulilo ghuli na kuukala ngunaaka bwile bwona haa kyakuhongelʼo bihonguwa kandi ghutaaku̱li̱ma. ");
INSERT INTO tlj_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘Bini niibiyo bilaghilo haa kihonguwa kya bilimuwa. Batabani̱ baa Alooni̱ bakileetaghe ewaa Mukama, mu maaso ghaa kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Mu̱hongi̱ akwate ngalo emui ya nsyano esemeeye ya kihonguwa kya bilimuwa, mafu̱ta na bubbani̱ bwona kandi abyokeli̱ye haa kyakuhongelʼo bihonguwa, kuba kyakuusukilʼo kya kihonguwa eki kusasa kwakiyo ku̱dheedhi̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Alooni̱ na batabani̱ be bali na kuliya ebyati̱ghaayʼo bhaatu babiliye bitalimu ki̱tu̱mbi̱so mu jighati̱ ya ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye hanja ya weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Migaati̱ eghi bataghiteeka elimu ki̱tu̱mbi̱so. Naaghihaaye Alooni̱ na batabani̱ be kuba mughabo ku̱lu̱gha haa kihonguwa kyanje bookeei̱ye haa mulilo. Kihonguwa eki ki̱hi̱ki̱li̱i̱ye kwonini nga kihonguwa haabwa kibhi kandi nga kihonguwa kya kuuhibuwʼo musango. ");
INSERT INTO tlj_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Muusukulu weena wabusaasa wa Alooni̱ akugubha kuliya haa bihonguwa bookeei̱ye haa mulilo. Ni mughabo ghwabo ghwa bu̱li̱ kilo ghwa bihonguwa bookeei̱ye haa mulilo bya Mukama mu mijo yabo yoona eghi ekwisa. Muntu weena oghu alaku̱magha haa bihonguwa ebi alafookagha ahi̱ki̱li̱i̱ye.’ ” ");
INSERT INTO tlj_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Mukama aatodha aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Kini niikiyo kihonguwa eki Alooni̱ na batabani̱ be bali na kuleeta ewaa Mukama haa kilo eki bakumusiigha mafu̱ta kuba mu̱hongi̱. Baleete ki̱lo emui ya nsyano esemeeye nga kihonguwa kya bilimuwa, kimui kyakabili kyayʼo bakihonge nkyambisi kandi kimui kyakabili kyayʼo bakihonge lwagholo. ");
INSERT INTO tlj_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Bali na kutabula mafu̱ta mu nsyano eghi kandi bali na kughiteekela mu capu̱li̱ya eghi yeeyali̱ye. Du̱mbi̱ migaati̱ eghi baghibheghange bi̱twi̱ka-twi̱ke kandi ebe kihonguwa kya bilimuwa eki kusasa kwakiyo ku̱dheedhi̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Muusukulu wa Alooni̱ oghu alakuukagha mu ki̱i̱kalo kiye nga mu̱hongi̱ basi̱i̱ghi̱ye mafu̱ta aaniiye aahongelagha Mukama kihonguwa eki kandi akyoki̱yaghe kyona. Eki nkilaghilo kya bilo nʼebilo. ");
INSERT INTO tlj_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Kihonguwa kyona kya bilimuwa eki mu̱hongi̱ aahaayeyo, bali na ku̱kyoki̱ya kyona kandi atabʼo muntu nʼomui oghu akukiliya.” ");
INSERT INTO tlj_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Oghambile Alooni̱ na batabani̱ be oti, ‘Bini niibiyo bilaghilo haa kihonguwa haabwa kibhi. Kihonguwa haabwa kibhi, bali na kukisalila mu maaso ghaa Mukama mu ki̱i̱kalo hambali bakusalilagha bu̱li̱ kihonguwa kyona kyokeei̱ye, eki ni kihonguwa ki̱hi̱ki̱li̱i̱ye kwonini. ");
INSERT INTO tlj_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Mu̱hongi̱ oghu akuhonga kisolo eki haabwa kibhi ali na kukiliya, bhaatu akiliile mu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye, mu jighati̱ ya weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Muntu weena kedha kintu kyona eki̱ku̱ku̱ma haa nyama sya kisolo eki, kikufooka ki̱hi̱ki̱li̱i̱ye kandi saghama ya kisolo eki niyaatooni̱ye haa kiigandulo kya muntu, ali na kukinaabi̱li̱ya mu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Nyama sya kisolo eki mbaasiteekeeye mu munagha ghwa ebumba du̱mbi̱ baghwatakaki̱ye, bhaatu mbaasiteekeeye mu capu̱li̱ya ya bbu̱looji̱, baghi̱ti̱le kwonini kandi baghinaabi̱ye na maasi. ");
INSERT INTO tlj_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Mwana weena wabusaasa mu ka ya mu̱hongi̱ akugubha kuliya haa kihonguwa eki. Ni kihonguwa ki̱hi̱ki̱li̱i̱ye kwonini. ");
INSERT INTO tlj_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Kaakuba saghama ya kisolo kya kihonguwa haabwa kibhi baghitwala mu weema ya kusanga-sangaanamu, mu Ki̱i̱kalo Ki̱hi̱ki̱li̱i̱ye haabwa kukola mukolo ghwa kughaniluwa kibhi, nyama syakiyo batasiliya kandi mu̱hongi̱ asyoki̱ye na mulilo. ");
INSERT INTO tlj_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘Kini niikiyo kilaghilo haa kihonguwa kya kuuhibuwʼo musango. Kihonguwa eki ki̱hi̱ki̱li̱i̱ye kwonini. ");
INSERT INTO tlj_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Kihonguwa kya kuuhibuwʼo musango bali na kukisalila mu ki̱i̱kalo hambali bakusalilagha kihonguwa kyona kyokeei̱ye kandi saghama yakiyo baghimisange haa mpande syona sya kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Bisabu̱ byakiyo byona babihonge, bisabu̱ bya haa mukila, bisabu̱ ebi̱swi̱ki̱ye byenda, ");
INSERT INTO tlj_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","mpi̱gho syombi na bisabu̱ byasiyo ebilabhaane na mughongo na ki̱twi̱ke kisemeeye kya bu̱ne. ");
INSERT INTO tlj_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Mu̱hongi̱ abyokeli̱ye haa kyakuhongelʼo bihonguwa nga kihonguwa bookeei̱ye haa mulilo kya Mukama. Ni kihonguwa kya kuuhibuwʼo musango. ");
INSERT INTO tlj_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Bu̱li̱ musaasa oghu ali mu ka ya mu̱hongi̱ akugubha kuliya haa kihonguwa eki, bhaatu bali na kukiliila mu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. Ni kihonguwa ki̱hi̱ki̱li̱i̱ye kwonini. ");
INSERT INTO tlj_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“ ‘Kihonguwa haabwa kibhi na kihonguwa kya kuuhibuwʼo musango, byombi kilaghilo kyabiyo ni kimui. Nyama sya bihonguwa bibili ebi ni sya mu̱hongi̱ oghu aakoli̱ye mukolo ghwa muntu oghu kughaniluwa kibhi. ");
INSERT INTO tlj_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Mu̱hongi̱ oghu akuhonga kihonguwa kyona kyokeei̱ye eki muntu aahaayeyo, atwalaghe luhu lwa kihonguwa eki. ");
INSERT INTO tlj_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Kihonguwa kyona kya bilimuwa eki bateekeeye haa ki̱tu̱mi̱ko kedha mu luusaniya lweyali̱ye kedha mu capu̱li̱ya ni kya mu̱hongi̱ oghu aaki̱hongi̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Bihonguwa byona bya bilimuwa, ebitabuuyemu mafu̱ta kedha ebyomi̱ye, ni bya batabani̱ baa Alooni̱ kughabana kandi babyengaane. ");
INSERT INTO tlj_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘Bini niibiyo bilaghilo haa kihonguwa kya bu̱si̱nge eki muntu akugubha kuleeta ewaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Kaakuba muntu ahayo kihonguwa eki haabwa ku̱si̱i̱ma Luhanga, kihonguwa eki akiheyo na migaati̱ etalimu ki̱tu̱mbi̱so kandi eghi etabuuyemu mafu̱ta, capati esitalimu ki̱tu̱mbi̱so kandi esi̱si̱i̱ghi̱yʼo mafu̱ta, na keeki̱ esi̱teeki̱ye mu nsyano esemeeye eghi etabuuyemu mafu̱ta. ");
INSERT INTO tlj_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Obu muntu oghu alabaagha naaleeta kihonguwa kiye kya bu̱si̱nge haabwa ku̱si̱i̱ma, ali na kuleeta kihonguwa eki na migaati̱ eghi elimu ki̱tu̱mbi̱so. ");
INSERT INTO tlj_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Haa bu̱li̱ mulingo ghwa migaati̱ aayʼo ghumui kandi aghiheyo nga kisembo kya mbaghani̱ja ewaa Mukama. Migaati̱ eghi ekuba ya mu̱hongi̱ oghu akumisanga saghama ya kihonguwa kya bu̱si̱nge haa kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Nyama sya kihonguwa kya bu̱si̱nge kya ku̱si̱i̱ma, bali na kusiliya haa kilo kyonini eki baasihongeeyemu, atabʼo nyama eghi eku̱ti̱ghalʼo ku̱hi̱ki̱ya nkyambisi. ");
INSERT INTO tlj_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ ‘Kaakuba muntu ahayo kihonguwa ku̱u̱su̱li̱i̱si̱ya eki aalahiiye kedha haabwa kubbala kuwe, nyama sya kihonguwa eki basiliye haa kilo kyonini eki baasihongeeyemu, bhaatu nyama esi̱ku̱ti̱ghalʼo basiliye haa kilo ekikulabhʼo. ");
INSERT INTO tlj_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Nyama sya kihonguwa eki esi̱ku̱ti̱ghalʼo ku̱hi̱ki̱ya haa kilo kyakasatu, bali na ku̱syoki̱ya haa mulilo. ");
INSERT INTO tlj_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Kaakuba nyama ya kihonguwa kya bu̱si̱nge eliibuwa haa kilo kyakasatu, Mukama taaku̱si̱i̱ma kihonguwa eki nʼoghu aakihaayeyo, nanga takyeli̱ye. Muntu weena oghu akuliya haa nyama esi akufubiluwa. ");
INSERT INTO tlj_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Nyama yoona eghi eku̱ku̱mʼo kintu kyona eki̱teeli̱ye bataghiliyagha kandi baghyoki̱yaghe haa mulilo. Nyama esi̱ku̱ti̱ghalʼo sikugubha kuliibuwa, bhaatu bantu abeeli̱ye bonkaha aaliibo baasiliya. ");
INSERT INTO tlj_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","“ ‘Bhaatu kaakuba muntu oghu ateeli̱ye aliya haa nyama sya kihonguwa kya bu̱si̱nge kya Mukama, muntu oghu ali na kubhinguwa mu ki̱bbu̱la kya Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Kaakuba muntu aku̱ma haa kintu kyona eki̱teeli̱ye, kedha haa muntu oghu ateeli̱ye kedha haa kisolo eki̱teeli̱ye kedha haa kintu kyona eki̱teeli̱ye ekyohebeeu̱we kandi aliya haa nyama sya kihonguwa kya bu̱si̱nge kya Mukama, muntu oghu ali na kubhinguwa mu ki̱bbu̱la kya Banai̱saaleeli̱.’ ” ");
INSERT INTO tlj_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Oghile Banai̱saaleeli̱ oti, ‘Mutaliliya bisabu̱ bya nte, ntaama kedha mbu̱li̱. ");
INSERT INTO tlj_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Bisabu̱ bya kisolo kyekwi̱li̱i̱ye kedha eki kinyama kya mu kisaka kyati̱ye mukugubha ku̱bi̱koleesi̱ya mulimo ghunji, bhaatu mutabiliya. ");
INSERT INTO tlj_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Muntu weena oghu akuliya kisabu̱ kya kisolo kya kihonguwa bookeei̱ye haa mulilo kya Mukama, ali na kubhinguwa mu ki̱bbu̱la kya Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Mu ki̱i̱kalo kyona hambali mulabaagha muukaaye, mutaliliya saghama ya noni̱ kedha ya kisolo. ");
INSERT INTO tlj_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Kaakuba muntu weena aliya saghama, ali na kubhinguwa mu ki̱bbu̱la kya Banai̱saaleeli̱.’ ” ");
INSERT INTO tlj_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Oghile Banai̱saaleeli̱ oti, “Kaakuba muntu weena abbala kuhaayo ewaa Mukama kihonguwa kya bu̱si̱nge, ali na kuleeta ki̱twi̱ke kyakiyo nga kihonguwa ewaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Muntu oghu ali na kwisa akwete mu ngalo siye kihonguwa kya kwoki̱ya haa mulilo kya Mukama. Ali na kuleeta bisabu̱ na mbanda kandi aamu̱ki̱ye mbanda eghi nga kihonguwa baamu̱ki̱i̱ye mu maaso ghaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Mu̱hongi̱ ali na kwoki̱ya bisabu̱ ebi haa kyakuhongelʼo bihonguwa, bhaatu mbanda ya kisolo eki ni ya Alooni̱ na batabani̱ be. ");
INSERT INTO tlj_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Muli na kuha mu̱hongi̱ kibelo kyabuliyo nga mughabo ghuwe oghu̱lu̱ghi̱ye haa kihonguwa kya bu̱si̱nge. ");
INSERT INTO tlj_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Mutabani̱ wa Alooni̱ oghu akuhonga saghama kandi bisabu̱ bya kihonguwa kya bu̱si̱nge, ali na kutwala kibelo kyabuliyo nga mughabo ghuwe. ");
INSERT INTO tlj_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Mbanda na kibelo kyabuliyo ebi baamu̱ki̱i̱ye kubimpongela, ku̱lu̱gha haa bihonguwa byabo bya bu̱si̱nge, naabi̱i̱hi̱yʼo Banai̱saaleeli̱ kandi naabiha mu̱hongi̱ Alooni̱ na batabani̱ be, kuba mughabo ghwabo ghwa bilo nʼebilo oghu balaayaghʼo Banai̱saaleeli̱.” ");
INSERT INTO tlj_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Mukama akaha Alooni̱ na batabani̱ be ki̱twi̱ke kya bihonguwa bookeei̱ye haa mulilo kuba mughabo ghwabo bakutwala. Aabaha mughabo oghu ku̱lu̱gha haa kilo eki baafooki̱ye bahongi̱ baa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Kilo eki baabasi̱i̱ghi̱ye mafu̱ta kuba bahongi̱, Mukama aalaghila Banai̱saaleeli̱ kuhaagha bahongi̱ mughabo oghu mu mijo ya Banai̱saaleeli̱ yoona eghi ekwisa. ");
INSERT INTO tlj_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Ebi niibiyo bilaghilo haa kihonguwa kyona kyokeei̱ye, kihonguwa kya bilimuwa, kihonguwa haabwa kibhi, kihonguwa kya kuuhibuwʼo musango, kihonguwa kya mukolo ghwa ku̱lu̱wi̱ka bahongi̱ na kihonguwa kya bu̱si̱nge. ");
INSERT INTO tlj_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Bilaghilo ebi Mukama akabiha Musa haa mwena Si̱naai̱ haa kilo eki aalaghiiye Banai̱saaleeli̱ kuleeta bihonguwa byabo ewaa Mukama, mu elungu lya Si̱naai̱. ");
INSERT INTO tlj_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Otwale Alooni̱ na batabani̱ be haa mulyango ghwa weema ya kusanga-sangaanamu kandi oleete bi̱lu̱waalo bya bu̱hongi̱, mafu̱ta ghaa kusiigha, ntu̱u̱li̱ ya nte ya kihonguwa haabwa kibhi, ntu̱u̱li̱ sya ntaama ebili na kighegha kya migaati̱ etalimu ki̱tu̱mbi̱so. ");
INSERT INTO tlj_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Okumaani̱ye ki̱bbu̱la kya Banai̱saaleeli̱ kyona haa mulyango ghwa weema ya kusanga-sangaanamu.” ");
INSERT INTO tlj_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Musa aakola ngoku Mukama aamulaghiiye kandi aakumaani̱ya ki̱bbu̱la kya Banai̱saaleeli̱ kyona haa mulyango ghwa weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Musa aaghila ki̱bbu̱la kya bantu eki ati, “Kini niikiyo Mukama andaghiiye kukola.” ");
INSERT INTO tlj_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Du̱mbi̱ Musa aaleeta mu maaso Alooni̱ na batabani̱ be kandi aabanaabi̱ya na maasi. ");
INSERT INTO tlj_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Aalu̱wi̱ka Alooni̱ kyaku̱lu̱waala mukati, aamuboha muheeko, aamu̱lu̱wi̱ka nkanji̱ na efodi̱. Aaboha dhee efodi̱ eghi na muheeko ghu̱koleeu̱we kulungi kukwata efodi̱ eghi. ");
INSERT INTO tlj_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Aamu̱lu̱wi̱ka kyaku̱lu̱waala haa ki̱ku̱bha kandi aata mukati yakiyo U̱li̱i̱mu̱ na Tu̱mi̱i̱mu̱. ");
INSERT INTO tlj_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Aalu̱wi̱ka Alooni̱ kyaku̱lu̱waala mu mutuwe, aata kaapa kaa feeja kahi̱ki̱li̱i̱ye, mu maaso ghaa kyaku̱lu̱waala mu mutuwe eki, ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Du̱mbi̱ Musa aakwata mafu̱ta ghaa kusiigha, aaghasiigha haa weema ehi̱ki̱li̱i̱ye na bintu byamu byona kandi aabyeli̱ya. ");
INSERT INTO tlj_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Aamisanga ghamui haa mafu̱ta ghaa kusiigha haa kyakuhongelʼo bihonguwa milundi musanju̱, aaghasiigha haa kyakuhongelʼo bihonguwa eki na byaku̱koleesi̱yʼo byona kandi aaghasiigha haa bbaafu na kyakughitʼo, ku̱byeli̱ya. ");
INSERT INTO tlj_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Aaseesa Alooni̱ haa mutuwe ghamui haa mafu̱ta ghaa kusiigha ku̱mweli̱ya. ");
INSERT INTO tlj_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Du̱mbi̱ Musa aaleeta mu maaso batabani̱ baa Alooni̱, aabalu̱wi̱ka byaku̱lu̱waala mukati, aababoha miheeko kandi aabalu̱wi̱ka byaku̱lu̱waala mu mutuwe ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Musa aaleeta ntu̱u̱li̱ ya nte ya kihonguwa haabwa kibhi kandi Alooni̱ na batabani̱ be baata mikono yabo haa mutuwe ghwayo. ");
INSERT INTO tlj_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Musa aasala ntu̱u̱li̱ ya nte eghi kandi aatwala haa saghama yayo kandi aaghisiigha na kyala kiye haa mahembe ghaa kyakuhongelʼo bihonguwa. Saghama eghi yaati̱ghaayʼo aaghiseesa haa ki̱twi̱ke kya hansi ya kyakuhongelʼo bihonguwa. Mukolo oghu ghwafoola kyakuhongelʼo bihonguwa eki kuba kyeli̱ye kandi ki̱hi̱ki̱ye kuhongelʼo bihonguwa haabwa kibhi. ");
INSERT INTO tlj_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Du̱mbi̱ Musa aatwala bisabu̱ byona ebi̱swi̱ki̱ye byenda, ki̱twi̱ke kisemeeye kya bu̱ne, mpi̱gho syombi na bisabu̱ byasiyo, aabyokeli̱ya haa kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Bhaatu ntu̱u̱li̱ ya nte eghi, luhu, nyama syayʼo na mabhi̱ ghaayʼo, aabyokeli̱ya haa mulilo enja ya hambali baghooneeye, ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Du̱mbi̱ aaleeta ntu̱u̱li̱ ya ntaama ya kihonguwa kyona kyokeei̱ye kandi Alooni̱ na batabani̱ be baata mikono yabo haa mutuwe ghwa ntu̱u̱li̱ ya ntaama eghi. ");
INSERT INTO tlj_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Musa aasala ntu̱u̱li̱ ya ntaama eghi kandi aamisanga saghama yayo haa mpande syona sya kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Ntu̱u̱li̱ ya ntaama eghi aaghiiyamu myana kandi ooki̱ya mutuwe, myana eghi na bisabu̱. ");
INSERT INTO tlj_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Aanabi̱ya na maasi byenda na bilenge kandi ooki̱ya ntu̱u̱li̱ ya ntaama eghi yoona haa kyakuhongelʼo bihonguwa nga kihonguwa kyona kyokeei̱ye, ekisasi̱ye, kihonguwa bookeei̱ye haa mulilo kya Mukama, ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Du̱mbi̱ Musa aaleeta ntu̱u̱li̱ ya ntaama enji ya mukolo ghwa ku̱lu̱wi̱ka bahongi̱ kandi Alooni̱ na batabani̱ be baata mikono yabo haa mutuwe ghwa ntu̱u̱li̱ ya ntaama eghi. ");
INSERT INTO tlj_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Musa aasala ntu̱u̱li̱ ya ntaama eghi kandi aaya haa saghama yayo, aaghisiigha haa nsonga ya kutui kwabuliyo kwa Alooni̱, haa kyala kyabusaasa kya mukono ghwabuliyo ghwa Alooni̱ na haa kighele kyabusaasa kya kughulu kuwe kwabuliyo. ");
INSERT INTO tlj_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Musa aaleeta dhee batabani̱ baa Alooni̱ kandi aabasiigha saghama ya ntu̱u̱li̱ ya ntaama eghi haa nsonga sya matui ghaabo ghaabuliyo na haa byala byabo byabusaasa bya mukono ghwabuliyo na haa bighele byabo byabusaasa bya maghulu ghaabo ghaabuliyo. Saghama eghi yaati̱ghaayʼo aaghimisanga haa mpande syona sya kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Musa aatwala bisabu̱, bisabu̱ bya haa mukila, bisabu̱ byona ebi̱swi̱ki̱ye byenda, ki̱twi̱ke kisemeeye kya bu̱ne, mpi̱gho syombi na bisabu̱ byasiyo na kibelo kyabuliyo. ");
INSERT INTO tlj_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Aaya mu kighegha ekili mu maaso ghaa Mukama, mugaati̱ ghumui oghutalimu ki̱tu̱mbi̱so. Aayamu dhee mugaati̱ ghumui oghu̱teeki̱ye na mafu̱ta, na capati esi̱i̱ghi̱yʼo mafu̱ta, aabita haagu̱u̱li̱ ya bisabu̱ ebi na kibelo kyabuliyo. ");
INSERT INTO tlj_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Ebi byona aabikwati̱ya mu ngalo Alooni̱ na batabani̱ be kandi baabi̱i̱mu̱ki̱ya nga kihonguwa baamu̱ki̱i̱ye ewaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Du̱mbi̱ Musa aabiiya mu ngalo syabo kandi aabyokeli̱ya haa kyakuhongelʼo bihonguwa haagu̱u̱li̱ ya kihonguwa kyona kyokeei̱ye kya mukolo ghwa ku̱lu̱wi̱ka bahongi̱. Eki kyaba kihonguwa bookeei̱ye haa mulilo, eki kusasa kwakiyo ku̱dheedhi̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Musa aakwata mbanda ya ntu̱u̱li̱ ya ntaama aaghi̱i̱mu̱ki̱ya, kuba kihonguwa baamu̱ki̱i̱ye mu maaso ghaa Mukama, oghu ghwaba mughabo ghwa Musa oghu̱lu̱ghi̱ye haa ntaama ya mukolo ghwa ku̱lu̱wi̱ka bahongi̱ ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Du̱mbi̱ Musa aaya haa mafu̱ta ghaa kusiigha na saghama eghi ekaba eli haa kyakuhongelʼo bihonguwa, aabimisangila Alooni̱ na biigandulo biye. Aabimisangila dhee batabani̱ baa Alooni̱ na biigandulo byabo. Nahabweki eeli̱ya Alooni̱ na biigandulo biye kandi batabani̱ baa Alooni̱ na biigandulo byabo. ");
INSERT INTO tlj_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Musa aaghila Alooni̱ na batabani̱ be ati, “Nyama esi musiteekele haa mulyango ghwa weema ya kusanga-sangaanamu kandi musiliilʼo na migaati̱ ya mukolo ghwa ku̱lu̱wi̱ka bahongi̱ eghi eli mu kighegha, ngoku Mukama aalaghiiye naaghila ati, ‘Alooni̱ na batabani̱ be baliye byokuliya ebi.’ ");
INSERT INTO tlj_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Nyama na migaati̱ ebi̱ku̱ti̱ghalʼo mu̱byoki̱ye na mulilo. ");
INSERT INTO tlj_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Mutatuwa haa mulyango ghwa weema ya kusanga-sangaanamu haabwa bilo musanju̱, ku̱hi̱ki̱ya bilo bya mukolo ghwa ku̱lu̱wi̱ka bahongi̱ bihooyʼo, nanga mukolo oghu ghuli na kumala bilo musanju̱. ");
INSERT INTO tlj_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ekyakoleeu̱we obwalo Mukama niiye aakilaghiiye kukoluwa niikuwo habʼo mukolo ghwa kughaniluwa bibhi byanu. ");
INSERT INTO tlj_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Muli na kuukala haa mulyango ghwa weema ya kusanga-sangaanamu mukilo na ntangaali̱ haabwa bilo musanju̱ kandi mukole ebi Mukama akubbala, niikuwo mutaku̱wa, nanga eki niikiyo Mukama aalaghiiye.” ");
INSERT INTO tlj_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Nahabweki Alooni̱ na batabani̱ be baakola byona ebi Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Haa kilo kyamunaanaa, haanu̱ma ya mukolo ghwa ku̱lu̱wi̱ka bahongi̱, Musa aakumaani̱li̱ya hamui Alooni̱ na batabani̱ be na beebembeli̱ baa Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Aaghila Alooni̱ ati, “Oleete ntu̱u̱li̱ ya nte nga kihonguwa haabwa kibhi kyawe kandi ntu̱u̱li̱ ya ntaama nga kihonguwa kyona kyokeei̱ye, byombi ebitali na kamogo kandi obihonge mu maaso ghaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Du̱mbi̱ oghile Banai̱saaleeli̱ oti, ‘Mutwale ntu̱u̱li̱ ya mbu̱li̱ nga kihonguwa haabwa kibhi, kyana kya nte kya mwaka ghumui na kyana kya ntaama kya mwaka ghumui, byombi ebitali na kamogo, kuba kihonguwa kyona kyokeei̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Mutwale nte na ntu̱u̱li̱ ya ntaama nga kihonguwa kya bu̱si̱nge kandi mubihonge mu maaso ghaa Mukama, na kihonguwa kya bilimuwa ekitabuuyemu mafu̱ta, nanga obwalo Mukama akubonekela enu̱we.’ ” ");
INSERT INTO tlj_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Banai̱saaleeli̱ baatwala bintu ebi Musa aabalaghiiye mu maaso ghaa weema ya kusanga-sangaanamu, ki̱bbu̱la kyona kya Banai̱saaleeli̱ beebinga weema eghi kandi beemilila mu maaso ghaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Du̱mbi̱ Musa aabaghila ati, “Kini niikiyo Mukama aalaghiiye enu̱we kukola niikuwo mubone ki̱ti̱i̱ni̱sa kya Mukama.” ");
INSERT INTO tlj_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Musa aaghila Alooni̱ ati, “Weebinge kyakuhongelʼo bihonguwa kandi ohonge kihonguwa kyawe haabwa kibhi na kihonguwa kyona kyokeei̱ye kyawe kandi ohonge kihonguwa kya mukolo ghwa kughaniluwa kibhi kyawe na kya bantu aba. Ohonge dhee kihonguwa kya mukolo ghwa kughaniluwa bibhi bya bantu aba, ngoku Mukama aalaghiiye.” ");
INSERT INTO tlj_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Nahabweki Alooni̱ eebinga kyakuhongelʼo bihonguwa kandi aasala ntu̱u̱li̱ ya nte nga kihonguwa kya kughaniluwa kibhi kiye. ");
INSERT INTO tlj_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Batabani̱ baa Alooni̱ baamuleetela saghama ya kyana kya nte eki kandi aakoti̱ya kyala kiye mu saghama eghi, aaghisiigha haa mahembe ghaa kyakuhongelʼo bihonguwa. Saghama eghi eti̱ghaayʼo aaghiseesa haa ki̱twi̱ke kya hansi ya kyakuhongelʼo bihonguwa eki. ");
INSERT INTO tlj_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Ookeli̱ya haa kyakuhongelʼo bihonguwa bisabu̱, mpi̱gho syombi na ki̱twi̱ke kisemeeye kya bu̱ne bya kihonguwa haabwa kibhi, ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Nyama na luhu aabyokeli̱ya haa mulilo enja ya hambali baghooneeye. ");
INSERT INTO tlj_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Du̱mbi̱ Alooni̱ aasala kisolo kya kihonguwa kyona kyokeei̱ye. Batabani̱ be baamuleetela saghama yakiyo kandi aaghimisanga haa mpande syona sya kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Baamuleetela mutuwe na myana enji ya kihonguwa kyona kyokeei̱ye eki kandi aabyokeli̱ya haa kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Aanaabi̱ya byenda na bilenge kandi aabyokeli̱ya haagu̱u̱li̱ ya kihonguwa kyona kyokeei̱ye, haa kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Du̱mbi̱ Alooni̱ aaleeta kihonguwa kya Banai̱saaleeli̱. Aakwata mbu̱li̱ ya kihonguwa haabwa kibhi kya bantu aba, aaghisala kandi aaghihonga nga kihonguwa haabwa kibhi ngoku aakoli̱ye yʼoku̱du̱bha. ");
INSERT INTO tlj_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Aaleeta kisolo kya kihonguwa kyona kyokeei̱ye kandi aakihonga mu mulingo ghwonini ngoku Musa aamughambiiye. ");
INSERT INTO tlj_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Aaleeta dhee kihonguwa kya bilimuwa, aayʼo ngalo emui ya nsyano kandi aghyokeli̱ye haa kyakuhongelʼo bihonguwa kwongela haa kihonguwa kyona kyokeei̱ye kya bu̱li̱ nkyambisi. ");
INSERT INTO tlj_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Alooni̱ aasala nte na ntu̱u̱li̱ ya ntaama nga kihonguwa kya bu̱si̱nge haabwa bantu aba. Batabani̱ baa Alooni̱ baamuleetela saghama ya bisolo ebi kandi aaghimisanga haa mpande syona sya kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Bhaatu bisabu̱ bya nte eghi na ntu̱u̱li̱ ya ntaama eghi, bisabu̱ bya haa mukila, bisabu̱ ebi̱swi̱ki̱ye byenda, mpi̱gho na ki̱twi̱ke kisemeeye kya bu̱ne, ");
INSERT INTO tlj_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","aabilabha haa mbanda sya bisolo ebi kandi bisabu̱ ebi aabyokeli̱ya haa kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Alooni̱ aamu̱ki̱ya mbanda na kibelo kyabuliyo mu maaso ghaa Mukama, nga kihonguwa baamu̱ki̱i̱ye, ngoku Musa aamulaghiiye. ");
INSERT INTO tlj_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Du̱mbi̱ Alooni̱ aamu̱ki̱ya mikono yee kandi aaha Banai̱saaleeli̱ aba mu̱gi̱sa. Obu aamali̱ye kuhonga kihonguwa haabwa kibhi, kihonguwa kyona kyokeei̱ye na kihonguwa kya bu̱si̱nge, aasu̱ndu̱ka. ");
INSERT INTO tlj_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Musa na Alooni̱ baaghenda mu weema ya kusanga-sangaanamu. Obu baatooyemu, baaha Banai̱saaleeli̱ aba mu̱gi̱sa, ki̱ti̱i̱ni̱sa kya Mukama kyabonekela bantu aba boona. ");
INSERT INTO tlj_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Mulilo ghwalu̱gha ewaa Mukama kandi ghwoki̱ya kihonguwa kyona kyokeei̱ye na bisabu̱ ebyabaagha haa kyakuhongelʼo bihonguwa. Obu bantu aba baaboone eki, baaguga nʼelaka lyamaani̱ haabwa kudheedhuwa kandi baalangaala haali̱i̱so yabo aaku̱ma hansi. ");
INSERT INTO tlj_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nadaabbu na Abbi̱hu̱, batabani̱ baa Alooni̱, bu̱li̱ omui aakwata kibindi kiye aatu̱mi̱kamu mulilo kandi aataamu bubbani̱, baahonga mulilo mu maaso ghaa Mukama, atabalaghiiye. ");
INSERT INTO tlj_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Du̱mbi̱ mulilo ghwalu̱gha ewaa Mukama, ghwabooki̱ya kandi baakwi̱la mu maaso ghaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Musa aaghila Alooni̱ ati, “Kini niikiyo Mukama aabu̱ghi̱ye obu aaghi̱li̱ye ati, “ ‘Boona abaku̱mpeeleli̱yagha, bali na ku̱hu̱ti̱ya bu̱hi̱ki̱li̱i̱le bwanje kandi nkwoleka bantu ki̱ti̱i̱ni̱sa kyanje. Bantu boona bali na ku̱mpu̱ti̱ya.’ ” Bhaatu Alooni̱ aakala aholeei̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Musa aabilikila Misai̱li̱ na Elijafaani̱, batabani̱ baa U̱jeeli̱ mu̱ghenji̱ wa ese Alooni̱ kandi aabaghila ati, “Mwise hani, muheeke mi̱ku̱ ya baghenji̱ baanu, mughiiye mu maaso ghaa ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye kandi mu̱ghi̱twesi̱ye enja ya hambali Banai̱saaleeli̱ baghooneeye.” ");
INSERT INTO tlj_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Du̱mbi̱ baasa kandi baaheeka mi̱ku̱ eghi enali mu bi̱lu̱waalo bya bu̱hongi̱. Baaghi̱twesi̱ya enja ya hambali Banai̱saaleeli̱ baghooneeye, ngoku Musa aabalaghiiye. ");
INSERT INTO tlj_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Musa aaghila Alooni̱ na batabani̱ be babili Eli̱yeeja na I̱tamala ati, “Mutaleka kucanula esoke lyanu kandi mutatemula ngoye syanu haabwa kweghunga, nanga naanu dhee mu̱ku̱ku̱wa kandi Mukama akusaaliluwa na ki̱bbu̱la kya Banai̱saaleeli̱ kyona. Bhaatu Banai̱saaleeli̱ baanakyanu boona, bakugubha kweghunga haabwa Nadaabbu na Abbi̱hu̱ aba Mukama aati̱ye na mulilo. ");
INSERT INTO tlj_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Mutalu̱gha haa mulyango ghwa weema ya kusanga-sangaanamu, nimwatooye mu̱ku̱ku̱wa, nanga mafu̱ta ghaa kusiigha ghaa Mukama baabasiighye ghanabaliyo.” Nahabweki Alooni̱ na batabani̱ be baakola ngoku Musa aabu̱ghi̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Mukama aaghila Alooni̱ ati, ");
INSERT INTO tlj_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Uwe na batabani̱ baawe, mutaghendagha mu weema ya kusanga-sangaanamu munooye vi̱i̱ni̱ kedha maaluwa. Kaakuba mukola eki mu̱ku̱ku̱wa. Eki nkilaghilo kya bilo nʼebilo mu mijo yaanu yoona eghi ekwisa. ");
INSERT INTO tlj_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Muli na kumanya mbaghani̱ja haa bintu bi̱hi̱ki̱li̱i̱ye na bya bu̱li̱ kilo kandi mbaghani̱ja haa bintu byeli̱ye na ebi̱teeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Muli na kwegheesi̱ya Banai̱saaleeli̱ bilaghilo byona ebi Mukama aahaaye Musa kubaghambila.” ");
INSERT INTO tlj_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Musa aaghila Alooni̱ na batabani̱ be babili abaati̱ghaayʼo Eli̱yeeja na I̱tamala ati, “Kihonguwa kya bilimuwa eki ki̱hi̱ki̱li̱i̱ye. Mukwate ebyati̱ghaaye haa kihonguwa kya bilimuwa kya kihonguwa bookeei̱ye haa mulilo kya Mukama, mukiliye kitalimu ki̱tu̱mbi̱so haakpengbu̱ ya kyakuhongelʼo bihonguwa, nanga ni kihonguwa ki̱hi̱ki̱li̱i̱ye kwonini. ");
INSERT INTO tlj_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Muliile migaati̱ eghi mu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye, nanga ni mughabo ghwawe na baasukulu baawe ku̱lu̱gha haa bihonguwa ebi bookeei̱ye haa mulilo bya Mukama kandi eki niikiyo Mukama andaghiiye. ");
INSERT INTO tlj_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Bhaatu enu̱we, batabani̱ baanu na bahala baanu mukugubha kuliya mbanda na kibelo ebi baamu̱ki̱i̱ye ewaa Mukama. Bhaatu mubiliile mu ki̱i̱kalo kyeli̱ye, nanga ni mughabo oghu Mukama aahaaye enu̱we na baasukulu baanu ku̱lu̱gha haa bihonguwa bya bu̱si̱nge bya Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Kibelo eki baaleeti̱ye na mbanda eghi baamu̱ki̱i̱ye bali na kubileete na bisabu̱ bya bihonguwa bookeei̱ye haa mulilo, ku̱bi̱i̱mu̱ki̱ya mu maaso ghaa Mukama nga kihonguwa baamu̱ki̱i̱ye. Bintu ebi ghulabaagha mughabo ghwawe na baasukulu baawe bilo nʼebilo, ngoku Mukama aalaghiiye.” ");
INSERT INTO tlj_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Obu Musa aabu̱u̱li̱li̱li̱i̱ye bhyani ebikwetʼo mbu̱li̱ ya kihonguwa haabwa kibhi kandi naamanya ngoku baaghyokeei̱ye, asaaliluwa haabwa eki Eli̱yeeja na I̱tamala batabani̱ baa Alooni̱ baakoli̱ye kandi aabaghila ati, ");
INSERT INTO tlj_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Nkiki kyaleki̱ye mbu̱li̱ ya kihonguwa haabwa kibhi mutaaghiliila mu ki̱i̱kalo kyʼomu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye? Mbu̱li̱ eghi ni kihonguwa ki̱hi̱ki̱li̱i̱ye kwonini kandi Mukama aaghihaaye enu̱we haabwa mukolo ghwa kughaniluwa bibhi bya Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Saghama ya mbu̱li̱ eghi ngoku mutaaghi̱leeti̱ye mu Ki̱i̱kalo Ki̱hi̱ki̱li̱i̱ye, mbu̱li̱ eghi mwangughiliiliiye haai na ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye, ngoku naabalaghiiye.” ");
INSERT INTO tlj_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Bhaatu Alooni̱ aaghila Musa ati, “Obwalo bantu baaleeti̱ye kihonguwa kyabo haabwa kibhi na kihonguwa kyona kyokeei̱ye mu maaso ghaa Mukama. Bhaatu bintu bi̱bhi̱i̱hi̱ye byambaayʼo. Buuye Mukama angu̱dheedheeu̱we nguli obwalo naaliiye kihonguwa haabwa kibhi?” ");
INSERT INTO tlj_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Obu Musa aaghu̱u̱ye eki, aateekaana. ");
INSERT INTO tlj_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Mukama aaghila Musa na Alooni̱ ati, ");
INSERT INTO tlj_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Mughile Banai̱saaleeli̱ muti, ‘Bini niibiyo bisolo ebili munsi ebi mukugubha kuliya. ");
INSERT INTO tlj_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Mukugubha kuliya bisolo ebili na bikaato ebighabaane kandi ebikuliyaagha ebi byeku̱u̱mi̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“ ‘Bhaatu mu bisolo ebili na bikaato ebighabaane kandi ebikuliyaagha ebi byeku̱u̱mi̱ye mutaliliya ngamila, nankabha neekuliyaagha ebi yeeku̱u̱mi̱ye, teeli na bikaato bighabaane, nahabweki tayeeli̱ye ewaanu. ");
INSERT INTO tlj_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Nsi̱mba, nankabha neekuliyaagha ebi yeeku̱u̱mi̱ye, teeli na bikaato bighabaane, nahabweki tayeeli̱ye ewaanu. ");
INSERT INTO tlj_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Kaawakame, nankabha nkakuliyaagha ebi keeku̱u̱mi̱ye, takali na bikaato bighabaane, nahabweki takeeli̱ye ewaanu. ");
INSERT INTO tlj_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Mpunu, nankabha eli na bikaato ebighabaane, teekuliyaagha ebi yeeku̱u̱mi̱ye, nahabweki tayeeli̱ye ewaanu. ");
INSERT INTO tlj_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Mutaliliya nyama sya bisolo ebi kedha ku̱ku̱ma haa mi̱ku̱ yabiyo, nahabweki tayeeli̱ye ewaanu. ");
INSERT INTO tlj_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘Mu nsu̱i̱ syona esili mu maasi, mukugubha kuliya esili na biisaabbiya kandi bi̱ku̱ku̱. ");
INSERT INTO tlj_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Bhaatu kihanguwa kyona ekili mu maasi ekitali na biisaabbiya kandi bi̱ku̱ku̱, mutalikiliya. Bihanguwa byona byomi̱i̱li̱ ebili mu maasi, ebitali na biisaabbiya kandi bi̱ku̱ku̱, mubyohe. ");
INSERT INTO tlj_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Bihanguwa ebi mubyohe nahabweki mutaliliya nyama syabiyo kandi ku̱ku̱ma haa mi̱ku̱ yabiyo. ");
INSERT INTO tlj_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Kihanguwa kyona ekikuukalagha mu maasi ekitali na biisaabbiya kandi bi̱ku̱ku̱, mukyohe. ");
INSERT INTO tlj_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘Mutaliliya noni̱ sini kandi musyohe: kibebe, bi̱noni̱ bya milingo yoona ebikuliyaagha mi̱ku̱, ");
INSERT INTO tlj_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ki̱i̱ku̱kwebe kiimutuku, ki̱i̱ku̱kwebe kinjilaghu̱li̱ kya mulingo ghwona, ");
INSERT INTO tlj_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","kinamungoogha kya bu̱li̱ mulingo, ");
INSERT INTO tlj_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","maaya, noni̱ esikubungagha mukilo, noni̱ syʼomu maasi na kahungu kaa bu̱li̱ mulingo. ");
INSERT INTO tlj_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","Ki̱hu̱u̱ghu̱lu̱ kiinabwana, bi̱noni̱ bya nanja ebi bakughilaghamu nsekeeli̱, nseku̱me, ");
INSERT INTO tlj_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ki̱hu̱u̱ghu̱lu̱ kinjelu, ki̱hu̱u̱ghu̱lu̱ kyʼomu elungu, esamba, ");
INSERT INTO tlj_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","biikalooli̱ bya bu̱li̱ mulingo, kaabhu̱coi̱ kaa bu̱li̱ mulingo, kiisigaila kandi kiikombe. ");
INSERT INTO tlj_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘Bihuka byona ebili na mapapa kandi ebi̱ku̱ghendi̱yagha maghulu anaa, mubyohe. ");
INSERT INTO tlj_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Bhaatu mukugubha kuliya bihuka byona ebili na mapapa kandi maghulu ghajukaane ghaa kuhalala hansi. ");
INSERT INTO tlj_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Mukugubha kuliya bu̱li̱ mulingo ghwa njighe, ki̱i̱meku̱lu̱ kya bu̱li̱ mulingo, kijelele kandi lu̱si̱ni̱ni̱. ");
INSERT INTO tlj_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Bhaatu bihuka binji ebili na mapapa kandi maghulu anaa, mutabiliyagha kandi mubyohe. ");
INSERT INTO tlj_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘Kuliya bisolo ebi̱teeli̱ye kukubafoola abateeli̱ye kandi muntu weena oghu alaku̱magha haa mi̱ku̱ yabiyo alafookagha oghu ateeli̱ye ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Muntu weena oghu akuheeka ghumui haa mi̱ku̱ ya bisolo ebi, ali na kunaabi̱ya ngoye siye kandi akufooka ateeli̱ye ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“ ‘Kisolo kyona ekitali na bikaato bighabaane kwonini kandi ebitaakuliyaagha ebi byeku̱u̱mi̱ye tabyeli̱ye ewaanu, muntu weena oghu aku̱ku̱ma haa mi̱ku̱ yabiyo akufooka ateeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Mu bisolo byona ebikulubhatangagha na maghulu anaa, bisolo ebi̱ku̱kpeeti̱yagha hansi bighele tabyeli̱ye ewaanu, muntu weena oghu aku̱ku̱ma haa mi̱ku̱ yabiyo akufooka oghu ateeli̱ye ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Muntu weena oghu akuheeka mi̱ku̱ ya bisolo ebi ali na kunaabi̱ya ngoye siye kandi akufooka ateeli̱ye ku̱hi̱ki̱ya lwagholo, nanga tabyeli̱ye ewaanu. ");
INSERT INTO tlj_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘Mu bisolo byona ebikwekuluulilagha hansi, bini tabyeli̱ye ewaanu: munyelele, mbeba, bi̱i̱gbeeku̱ bya milingo yoona, ");
INSERT INTO tlj_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","kiisitumbu kya bu̱li̱ mulingo, ki̱i̱ku̱lu̱ku̱tende, kankonda-bali̱i̱si̱ya na kandi̱byala-dhi̱-nku̱we. ");
INSERT INTO tlj_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Bisolo ebikwekuluulilagha hansi ebi byona, tabyeli̱ye ewaanu. Muntu weena oghu aku̱ku̱ma haa mi̱ku̱ yabiyo akufooka ateeli̱ye ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Kaakuba kimui haa bisolo ebi ki̱ku̱wa kandi kyegenga haa kintu eki̱koleeu̱we mu mbaau, lughoye, luhu, kedha gu̱ni̱ya, kintu eki kilafookagha ki̱teeli̱ye kandi mukitaaghe mu maasi ku̱hi̱ki̱ya lwagholo, du̱mbi̱ kilafookagha ekyeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Kaakuba kimui haa bisolo ebi̱teeli̱ye kyegenga mu munagha ghwa ebumba, munagha oghu bali na kughwatakaki̱ya, nanga bu̱li̱ kintu ekilimu kikuba ki̱fooki̱ye eki̱teeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Kaakuba muntu aseesa maasi aghalu̱ghi̱ye mu munagha oghu haa byokuliya ebi muntu akugubha kuliya bikufooka ebi̱teeli̱ye kandi maasi ghoona ghaa kunuwa aghalimu ghakufooka aghateeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Kaakuba mu̱ku̱ ghwa kisolo eki̱teeli̱ye ghwegenga haa kintu kyona kikufooka eki̱teeli̱ye nankabha kiba kili ki̱tu̱mi̱ko kedha munagha ghwa kuteekelamu babyatakaki̱ye, nanga bintu ebi tabyeli̱ye ewaanu. ");
INSERT INTO tlj_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Kaakuba mu̱ku̱ ghwa kisolo eki̱teeli̱ye ghwegenga mu maasi ghaa nsulo kedha kyahu̱dhu̱, maasi agha ghakuukala gheeli̱ye. Bhaatu muntu weena oghu aku̱ku̱ma haa mu̱ku̱ ghwa kimui haa bisolo ebi̱teeli̱ye ebi, akufooka oghu ateeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Kaakuba mu̱ku̱ ghwa kisolo eki̱teeli̱ye ghwegenga haa nsigho ya kuhela, ekuukala eneeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Bhaatu mbaabaaye bataaye maasi haa nsigho kandi mu̱ku̱ ghwa kisolo eki ghwegengela nsigho eghi, ekufooka eteeli̱ye ewaanu. ");
INSERT INTO tlj_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘Kaakuba kisolo eki mukugubha kuliya ki̱ku̱wa, muntu weena oghu aku̱ku̱ma haa mu̱ku̱ ghwakiyo, akufooka oghu ateeli̱ye ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Muntu weena oghu akuliya nyama sya mu̱ku̱ ghwa kisolo eki, ali na kunaabi̱ya ngoye siye kandi akufooka oghu ateeli̱ye ku̱hi̱ki̱ya lwagholo. Muntu weena oghu akuheeka mu̱ku̱ oghu, ali na kunaabi̱ya ngoye siye kandi akufooka oghu ateeli̱ye ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘Kisolo kyona ekikwekuluulilagha hansi mukyohe kandi mutakiliyagha. ");
INSERT INTO tlj_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Kisolo kyona ekikwekuluulilagha hansi, otaayemu ebi̱ku̱ghendi̱yagha mbanda, na ebikulubhantangilagha haa maghulu anaa, kedha haa bughulu bukani̱ye, mubyohe kandi mutabiliyagha. ");
INSERT INTO tlj_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Hatabʼo muntu weena oghu akwebhi̱i̱ya ku̱ku̱ma haa bisolo ebikwekuluulilagha hansi ebi kandi kwefoola oghu ateeli̱ye haabwa kuliya kimui haa bisolo ebi. ");
INSERT INTO tlj_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Ni̱i̱si̱ye Mukama Luhanga waanu, mweyeli̱ye kandi mube bahi̱ki̱li̱i̱ye, nanga ndi ahi̱ki̱li̱i̱ye. Muntu weena ateefoola oghu ateeli̱ye haabwa kuliya kisolo kyona ekikukwekuluulilagha hansi. ");
INSERT INTO tlj_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ni̱i̱si̱ye Mukama oghu akabaaya mu nsi ya Mi̱si̱li̱ kuba Luhanga waanu. Nahabweki mube bahi̱ki̱li̱i̱ye, nanga ndi ahi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘Ebi niibiyo bilaghilo ebikwetʼo bisolo, noni̱, bisolo byona byomi̱i̱li̱ ebikuukalagha mu maasi na bisolo ebikwekuluulilagha hansi. ");
INSERT INTO tlj_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Muli na kumanya mbaghani̱ja ya bisolo ebi̱teeli̱ye na ebyeli̱ye kandi mbaghani̱ja ya bisolo ebili na kuliibuwa nʼebitali na kuliibuwa.’ ” ");
INSERT INTO tlj_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Oghile Banai̱saaleeli̱ oti, ‘Kaakuba mukali̱ aaku̱li̱ya kandi abyala mwana wabusaasa alafookagha oghu ateeli̱ye haabwa bilo musanju̱, ngoku akubaagha ateeli̱ye obu akubaagha alwaye bulwaye bwa bakali̱. ");
INSERT INTO tlj_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Mwana wabusaasa oghu bali na kumusala haa kilo kyamunaanaa. ");
INSERT INTO tlj_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Mukali̱ oghu ali na kumala bilo maku̱mi̱ asatu na bisatu naaneeyeli̱ya. Akulaghiluwa kutaku̱mʼo kantu koona kahi̱ki̱li̱i̱ye kedha kughenda mu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye ku̱hi̱ki̱ya bilo biye bya kweyeli̱ya bihooyʼo. ");
INSERT INTO tlj_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Kaakuba mukali̱ abyala mwana wabukali̱, mukali̱ oghu akufooka ateeli̱ye haabwa wi̱i̱ki̱ ebili, ngoku akubaagha ateeli̱ye alwaye bulwaye bwa bakali̱. Ali na kweyeli̱ya kumala bilo nkaagha na mukaagha haabwa saghama eghi yaamu̱lu̱ghi̱yemu obu aabyalagha. ");
INSERT INTO tlj_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘Bilo bya mukali̱ oghu bya kweyeli̱ya haabwa ku̱byala mwana wabusaasa kedha wabukali̱ ni byahooye, ali na kuleeta ewaa mu̱hongi̱ haa mulyango ghwa weema ya kusanga-sangaanamu kyana kya ntaama ekili na mwaka ghumui nga kihonguwa kyona kyokeei̱ye, kaana kaa kaapi̱i̱so kedha ki̱i̱bbi̱mbo nga kihonguwa haabwa kibhi. ");
INSERT INTO tlj_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Mu̱hongi̱ oghu abihongele mu maaso ghaa Mukama haabwa kukola mukolo ghwa kughaniluwa bibhi bya mukali̱ oghu, du̱mbi̱ akuba eeli̱ye haabwa saghama eghi yaamu̱lu̱ghi̱yemu. “ ‘Ebi niibiyo bilaghilo haa mukali̱ oghu aku̱byala mwana wabusaasa kedha wabukali̱. ");
INSERT INTO tlj_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Kaakuba mukali̱ oghu aba ataakugubha kuhaayo kyana kya ntaama, aleete bi̱i̱bbi̱mbo bibili kedha bwana bwa bu̱u̱pi̱i̱so bubili, kamui kaa kihonguwa kyona kyokeei̱ye na kanji kaa kihonguwa haabwa kibhi. Mu̱hongi̱ akole mukolo ghwa mukali̱ oghu kughaniluwa bibhi kandi akufooka oghu eeli̱ye.’ ” ");
INSERT INTO tlj_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Mukama aaghila Musa na Alooni̱ ati, ");
INSERT INTO tlj_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Kaakuba muntu weena aba na kibbodhe, kedha kihute, kedha nkolu̱ njelu haa mubili ghuwe, ebikugubha ku̱lu̱ghamu bulwaye bwa ntumbi bamuleetaghe ewaa mu̱hongi̱ Alooni̱ kedha ewaa omui haa bahongi̱ batabani̱ be. ");
INSERT INTO tlj_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Mu̱hongi̱ alole bhyani kibbodhe ekili haa mubili ghwa muntu oghu. Kaakuba kooha akali mu kibbodhe eki kafooka kanjelu kandi kibbodhe eki kitaaha mu mubili ghuwe, obu ni bulwaye bwa ntumbi. Mu̱hongi̱ naaboone eki, du̱mbi̱ alangilile muntu oghu kuba ateeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Bhaatu kaakuba nkolu̱ haa mubili ghuwe eba eli njelu bhaatu etataahi̱ye bhyani mu mubili kandi kooha akalimu katafooki̱ye kanjelu, mu̱hongi̱ atwale muntu oghu alwaye oghu hambali akuukala ali enkaha haabwa bilo musanju̱. ");
INSERT INTO tlj_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Haa kilo kyamusanju̱ mu̱hongi̱ atodhe amulole bhyani, kaakuba abona kibbodhe eki kitahi̱ndu̱ki̱ye kandi kitamalakaki̱ye haa mubili, atodhe amute mu ki̱i̱kalo hambali akuukala ali enkaha haabwa bilo musanju̱ binji. ");
INSERT INTO tlj_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Haa kilo kyamusanju̱ mu̱hongi̱ atodhe amulole bhyani, kaakuba asanga kibbodhe eki ki̱ki̱li̱ye kandi kitatani̱ye haa mubili, mu̱hongi̱ amulangilile nga muntu oghu eeli̱ye kandi obu bukuba buli bilwaye bwa haa mubili kwonkaha. Muntu oghu ali na kunaabi̱ya ngoye siye kandi akuba eeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Kaakuba kibbodhe kyeyongela kutana haa mubili ghwa muntu oghu haanu̱ma ya kweyoleka ewaa mu̱hongi̱ kandi kumulangilila ngoku aaki̱li̱ye, ali na kutodha kwisa ewaa mu̱hongi̱. ");
INSERT INTO tlj_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Mu̱hongi̱ ali na kutodha kumulola bhyani, kaakuba abona kibbodhe eki kitani̱ye haa mubili, ali na kulangilila ngoku muntu oghu ateeli̱ye, obu ni bulwaye bwa ntumbi. ");
INSERT INTO tlj_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Kaakuba muntu weena aba na bulwaye bwa ntumbi, bali na kumuleeta ewaa mu̱hongi̱. ");
INSERT INTO tlj_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Mu̱hongi̱ ali na kumulola bhyani, kaakuba aba alwaye kihute kinjelu haa mubili ghuwe, kooha akalimu kafooka kanjelu kandi kihute eki kibamu mahu̱nu̱, ");
INSERT INTO tlj_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","obu ni bulwaye bwa ntumbi obutaakukilagha kandi mu̱hongi̱ alangilile ngoku muntu oghu ateeli̱ye. Mu̱hongi̱ taali na kuta muntu oghu mu ki̱i̱kalo hambali akuukala enkaha, nanga bantu bakuba bamani̱ye ngoku ateeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Kaakuba bulwaye bwa ntumbi obu bumalakaka mubili ghwa muntu oghu ghwona, kutandikila haa mutuwe ku̱hi̱ka mu maghulu, ngoku mu̱hongi̱ aamuboone, ");
INSERT INTO tlj_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","mu̱hongi̱ oghu ali na kulola muntu oghu bhyani kandi naaboone bulwaye bwa ntumbi obu bumalakaki̱ye mubili ghwona ghwa muntu oghu, amulangilile nga muntu eeli̱ye. Nanga mubili ghuwe ghwona ghweli̱ye, nahabweki akuba afooki̱ye oghu eeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Bhaatu kaakuba muntu oghu alwala kihute ekilimu mahu̱nu̱, akuba ateeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Kaakuba mu̱hongi̱ abona kihute ekilimu mahu̱nu̱ eki, ali na kulangilila muntu oghu kuba ateeli̱ye. Kihute ekilimu mahu̱nu̱ eki, kikumufoola ateeli̱ye, nanga ni bulwaye bwa ntumbi. ");
INSERT INTO tlj_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Kihute eki kaakuba kifookamu kibbodhe kya langi̱ njelu, muntu oghu akilwaye ali na kughenda ewaa mu̱hongi̱. ");
INSERT INTO tlj_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Mu̱hongi̱ ali na kumulola bhyani, kaakuba abona kibbodhe eki ki̱fooki̱ye kinjelu, ali na kulangilila muntu oghu akilwaye kuba eeli̱ye, nanga akuba eeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Kaakuba muntu alwala kihute haa mubili ghuwe kandi kikila, ");
INSERT INTO tlj_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","mu ki̱i̱kalo hambali kihute eki kyabaagha, kaakuba kibbodhe kifooka kinjelu kedha eba nkolu̱ mutuku, ali na kughenda ewaa mu̱hongi̱. ");
INSERT INTO tlj_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Mu̱hongi̱ ali na kumulola bhyani, kaakuba abona nkolu̱ etaahi̱ye mu mubili kandi kooha akalimu kafooki̱ye kanjelu, mu̱hongi̱ alangilile muntu oghu kuba ateeli̱ye kandi obu ni bulwaye bwa ntumbi obwalu̱ghi̱li̱i̱ye haa kihute. ");
INSERT INTO tlj_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Kaakuba mu̱hongi̱ amulola bhyani, aasanga mu ki̱i̱kalo eki hatalimu kooha kanjelu bhaatu kali kanjilaghu̱li̱ kandi katataahi̱ye mu mubili, du̱mbi̱ mu̱hongi̱ amute mu ki̱i̱kalo hambali akuukala enkaha haabwa bilo musanju̱. ");
INSERT INTO tlj_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Kaakuba kibbodhe eki kighenda nkineeyongela kutana haa mubili ghwa muntu oghu, mu̱hongi̱ alangilile ngoku muntu oghu ateeli̱ye, nanga bukuba buli bulwaye bwa ntumbi. ");
INSERT INTO tlj_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Bhaatu kaakuba kibbodhe eki kiikala ngoku kyabaagha kandi kiteeyongela kutana, eghi ni nkolu̱ ya kihute eki kandi mu̱hongi̱ amulangilile nga muntu eeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Kaakuba muntu ahiya na mulilo haa mubili kandi nkolu̱ hambali aahiiye efooka njelu kedha mutuku, ");
INSERT INTO tlj_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","mu̱hongi̱ ali na kulola bhyani hambali muntu oghu aahiiye. Kaakuba kooha akali haa nkolu̱ eghi kafooka kanjelu kandi kataaha mu mubili, obu ni bulwaye bwa ntumbi obwalu̱ghi̱li̱i̱ye hambali muntu oghu aahiiye. Mu̱hongi̱ alangilile ngoku muntu oghu ateeli̱ye, nanga obu bukuba buli bulwaye bwa ntumbi. ");
INSERT INTO tlj_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Bhaatu kaakuba mu̱hongi̱ alola bhyani kibbodhe eki kandi asanga kitalimu kooha kanjelu, ki̱ki̱li̱ye kandi kitataahi̱ye mu mubili, mu̱hongi̱ ali na kumuta mu ki̱i̱kalo hambali akuukala ali enkaha haabwa bilo musanju̱. ");
INSERT INTO tlj_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Haa kilo kyamusanju̱ mu̱hongi̱ ali na kumulola bhyani, kaakuba abona kibbodhe eki nkineeyongela kutana haa mubili, mu̱hongi̱ alangilile muntu oghu kuba ateeli̱ye, nanga obu ni bulwaye bwa ntumbi. ");
INSERT INTO tlj_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Bhaatu nkolu̱ niyaakaaye enali ngoku yaabaagha, etatana bhaatu ekila, oku ni ku̱bhi̱mbha haa mubili oku̱lu̱ghi̱ye hambali muntu oghu aahiiye kandi mu̱hongi̱ alangilile muntu oghu kuba eeli̱ye, nanga ekuba eli nkolu̱ eghi yaalu̱ghi̱ye hambali muntu oghu aahiiye. ");
INSERT INTO tlj_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Kaakuba musaasa kedha mukali̱ alwala kibbodhe mu mutuwe kedha haa kalelu̱, ");
INSERT INTO tlj_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","mu̱hongi̱ akilole bhyani, kaakuba abona kitaahi̱ye mu mubili kandi kooha akalimu kali kaa kinjaali̱ kandi katali na maani̱, alangilile muntu oghu kuba ateeli̱ye, obu ni bulwaye bwa ntumbi alwaye mu mutuwe kedha haa kalelu̱. ");
INSERT INTO tlj_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Bhaatu kaakuba mu̱hongi̱ alola bhyani kibbodhe eki asanga kitataahi̱ye mu mubili kandi kitalimu kooha kanjilaghu̱li̱, mu̱hongi̱ ate muntu oghu mu ki̱i̱kalo hambali akuukala enkaha haabwa bilo musanju̱. ");
INSERT INTO tlj_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Haa kilo kyamusanju̱ mu̱hongi̱ atodhe alole kibbodhe eki, kaakuba kiba kitatani̱ye, kitalimu kooha kaa kinjaali̱ kandi katataahi̱ye mu mubili, ");
INSERT INTO tlj_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","muntu oghu bamughembe esoke kuuyʼo haa ki̱twi̱ke eki alwaye batamughembʼo kandi mu̱hongi̱ atodhe amute mu ki̱i̱kalo hambali akuukala ali enkaha haabwa bilo binji musanju̱. ");
INSERT INTO tlj_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Haa kilo kyamusanju̱ mu̱hongi̱ alole bhyani kibbodhe eki, kaakuba kiba kitatani̱ye kandi kitataahi̱ye mu mubili, mu̱hongi̱ amulangilile nga muntu oghu eeli̱ye. Muntu oghu ali na kunaabi̱ya ngoye siye kandi akuba eeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Bhaatu kaakuba kibbodhe eki kitana haa mubili haanu̱ma ya kumulangilila ngoku eeli̱ye, ");
INSERT INTO tlj_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","mu̱hongi̱ ali na kumulola bhyani, kaakuba kibbodhe eki kiba kyeyongeeye kutana haa mubili, mu̱hongi̱ taakwetaaghisibuwa kulolamu kooha kaa kinjaali̱, muntu oghu akuba afooki̱ye ateeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Bhaatu kaakuba alola ngoku kibbodhe eki kili kandi abonamu kooha kanjilaghu̱li̱ kibbodhe eki kikuba ki̱ki̱li̱ye kandi muntu oghu akuba eeli̱ye, mu̱hongi̱ alangilile ngoku muntu oghu eeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Kaakuba musaasa kedha mukali̱ buntu bunjelu bu̱mu̱bhi̱mbakaka haa mubili, ");
INSERT INTO tlj_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","mu̱hongi̱ ali na kumulola bhyani. Kaakuba abona buntu bunjelu obu mbuhwelela, obu ni bulwaye kwonkaha bwa haa mubili, muntu oghu eeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Kaakuba musaasa esoke limuhuwa mu mutuwe kandi aba na luhala, muntu oghu eeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Kaakuba musaasa esoke lya haa bhu̱u̱su̱ li̱mu̱twi̱kʼo kandi aba na luhala, muntu oghu eeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Bhaatu kaakuba musaasa oghu alwala kibbodhe kiimutuku kedha kinjelu haa luhala lwʼenu̱ma kedha lwa haa bhu̱u̱su̱, obu bukuba buli bulwaye bwa ntumbi obulimatandikila haa luhala luwe kedha haa bhu̱u̱su̱. ");
INSERT INTO tlj_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Mu̱hongi̱ ali na kumulola bhyani, kaakuba kibbodhe ekili haa luhala luwe lwʼenu̱ma kedha lwa haa bhu̱u̱su̱ kiba kili kiimutuku kedha kinjelu nga bulwaye bwa ntumbi haa mubili, ");
INSERT INTO tlj_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","musaasa oghu akuba alwaye kandi akuba ateeli̱ye. Mu̱hongi̱ alangilile muntu oghu ngoku ateeli̱ye haabwa kibbodhe ekili haa mutuwe ghuwe. ");
INSERT INTO tlj_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Musaasa oghu alwaye bulwaye bwa ntumbi ali na ku̱lu̱waala ngoye sitemangu̱ki̱ye, aleke kwecanula esoke mu mutuwe, eeswi̱ki̱le mi̱nu̱wa kandi abilikile nʼelaka lyamaani̱ ati, ‘Ndi oghu ateeli̱ye! Ndi oghu ateeli̱ye!’ ");
INSERT INTO tlj_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Bwile bwona obu musaasa oghu akumala anali na bulwaye bwa ntumbi obu akuba ateeli̱ye kandi ali na kuukala ali enkaha, enja ya hambali Banai̱saaleeli̱ baghooneeye. ");
INSERT INTO tlj_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Kaakuba lughoye lwona lubamu bulwaye bwa ntumbi, lube lwa byoha kedha lunjelu, ");
INSERT INTO tlj_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","kedha lughoye lwona lunjelu lu̱soni̱ye kedha lwa byoha kedha kintu kyona eki̱koleeu̱we mu luhu, ");
INSERT INTO tlj_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","kaakuba langi̱ ya ki̱si̱ka kibisi kedha mutuku eboneka haa lughoye lu̱soni̱ye olu kedha olu̱koleeu̱we mu mpu obu ni bulwaye bwa ntumbi kandi bali na kwoleka lughoye olu mu̱hongi̱. ");
INSERT INTO tlj_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Mu̱hongi̱ alole bhyani lughoye olu lukaakuba lulimu bulwaye bwa ntumbi kandi alute hambali lukuukala lwonkaha haabwa bilo musanju̱. ");
INSERT INTO tlj_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Haa kilo kyamusanju̱ mu̱hongi̱ oghu atodhe alole bhyani lughoye olu, kaakuba bulwaye bwa ntumbi obu buba bumalakaki̱ye lughoye olu, lube lu̱soni̱ye kedha lu̱koleeu̱we mu mulingo ghwona mu mpu, obu ni bulwaye bwa ntumbi obu̱ku̱bhi̱i̱ya lughoye olu kandi lukaba lu̱teeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Mu̱hongi̱ ali na kwoki̱ya haa mulilo lughoye olu, nankabha luba lu̱soni̱ye, kedha lwa byoha kedha lunjelu kedha lughoye lwa mulingo ghwona lu̱koleeu̱we mu mpu, nanga obu ni bulwaye bwa ntumbi. Lughoye olu ali na ku̱lwoki̱ya. ");
INSERT INTO tlj_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Bhaatu kaakuba mu̱hongi̱ alola kandi asanga bulwaye bwa ntumbi butamalakaki̱ye lughoye lu̱soni̱ye olu, lube lwa byoha kedha lwa mulingo ghwona lu̱koleeu̱we mu mpu, ");
INSERT INTO tlj_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","mu̱hongi̱ oghu alaghile kunaabi̱ya lughoye olu kandi atodhe alubiike hambali lukuukala lwonkaha haabwa bilo musanju̱ binji. ");
INSERT INTO tlj_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Du̱mbi̱ mu̱hongi̱ ali na kutodha kulola bhyani lughoye olu, kaakuba abona hambali bulwaye obu bwabaagha atahi̱ndu̱ki̱ye langi̱ haanu̱ma ya kulunaabi̱ya, nankabha lutamalakaki̱ye lughoye olu lwona, talweli̱ye. Mu̱hongi̱ ali na ku̱lwoki̱ya lwona mu mulilo, nankabha bulwaye bwa ntumbi buba buli haa luhande lumui kedha luhande lunji. ");
INSERT INTO tlj_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","“Kaakuba mu̱hongi̱ alulola bhyani kandi abona bulwaye bwa ntumbi bu̱ki̱li̱ye, haanu̱ma ya kunaabi̱ya lughoye olu, ali na kutemulʼo ki̱twi̱ke hambali bwabaagha. ");
INSERT INTO tlj_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Bhaatu bulwaye bwa ntumbi mbwatodhi̱ye bumalakaka haa lughoye lu̱soni̱ye, kedha lu̱koleeu̱we mu mulingo ghwona mu mpu, balwoki̱ye haa mulilo. ");
INSERT INTO tlj_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Kaakuba banaabi̱ya lughoye lu̱soni̱ye olu kedha lu̱koleeu̱we mu mulingo ghwona mu mpu kandi hambali bulwaye bwa ntumbi obu bwabaagha buhuwʼo, batodhe balunaabi̱ye kandi lukuba lweli̱ye.” ");
INSERT INTO tlj_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Ebi niibiyo bilaghilo haa byaku̱lu̱waala ebilimu bulwaye bwa ntumbi, kedha lughoye lu̱soni̱ye lwa byoha kedha lunjelu lwa mulingo ghwona kedha lu̱koleeu̱we mu mulingo ghwona mu mpu kulughilamu lweli̱ye kedha lu̱teeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Bini niibiyo bilaghilo haa muntu oghu aabaagha alwaye bulwaye bwa ntumbi, haa kilo eki bakulangilila ngoku aaki̱li̱ye. Muntu oghu bali na kumutwala ewaa mu̱hongi̱. ");
INSERT INTO tlj_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Mu̱hongi̱ ali na kughenda enja ya hambali Banai̱saaleeli̱ baghooneeye kandi aghende alole bhyani muntu oghu. Kaakuba abona muntu oghu aki̱li̱ye kwonini bulwaye bwa ntumbi obu, ");
INSERT INTO tlj_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","mu̱hongi̱ oghu alaghile baleete noni̱ ebili esyeli̱ye kandi esinaakaaye, kati kaa ki̱i̱looku̱, lughoye luumutuku na kabha kaa hai̱sopu̱. ");
INSERT INTO tlj_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Du̱mbi̱ mu̱hongi̱ alaghile basalile emui haa noni̱ esi haa mu̱nu̱wa ghwa munagha ghwa ebumba ghwa maasi aghalu̱ghi̱ye haa nsulo. ");
INSERT INTO tlj_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Mu̱hongi̱ atwale noni̱ eghi yaati̱ghaayʼo enaakaaye, kati kaa ki̱i̱looku̱, lughoye luumutuku na kabha kaa hai̱sopu̱, abi̱koti̱ye mu saghama ya noni̱ eghi baasaliiye haa mu̱nu̱wa ghwa munagha ghwa ebumba ghwa maasi aghalu̱ghi̱ye haa nsulo. ");
INSERT INTO tlj_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Mu̱hongi̱ amisangile muntu oghu aaki̱li̱ye bulwaye bwa ntumbi saghama eghi milundi musanju̱ kandi alangilile ngoku eeli̱ye, du̱mbi̱ alekele noni̱ eghi enaakaaye, ehalale kandi eghende mu kisaka. ");
INSERT INTO tlj_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Muntu oghu akughenda kwelebuwa ali na kunaabi̱ya ngoye siye, bamughembe esoke lyona kandi anaabe na maasi, du̱mbi̱ akuba eeli̱ye. Haanu̱ma yʼeki akuuke hambali Banai̱saaleeli̱ baghooneeye, bhaatu aakale enja ya weema yee haabwa bilo musanju̱. ");
INSERT INTO tlj_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Haa kilo kyamusanju̱ bamughembe esoke lyona mu mutuwe, bamughembe bi̱lelu̱, bi̱koleli̱yo na byoha binji bya mubili ghuwe. Ali na kunaabi̱ya ngoye siye kandi anaabe na maasi, du̱mbi̱ akuba eeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Haa kilo kyamunaanaa ali na kuleeta byana bya ntaama bibili byabusaasa na kyana kya ntaama kimui kyabukali̱ ekili na mwaka ghumui, byona ebitali na kamogo. Ali na kuleeta ki̱lo esatu sya nsyano esemeeye kuba kihonguwa kya bilimuwa, nsyano eghi etabuuyemu mafu̱ta ghaa biti oli̱va na mafu̱ta ghanji aghengaane na kimui kyakasatu kya li̱ta. ");
INSERT INTO tlj_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Mu̱hongi̱ oghu akukola mukolo ghwa kweli̱ya muntu oghu ali na kumuleeta na bihonguwa biye mu maaso ghaa Mukama haa mulyango ghwa weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“Du̱mbi̱ mu̱hongi̱ akwate kimui haa byana bya ntaama byabusaasa, hamui na kimui kyakasatu kya li̱ta ya mafu̱ta ghaa biti oli̱va, abiheyo nga kihonguwa kya kuuhibuwʼo musango kandi abi̱i̱mu̱ki̱ye kuba kihonguwa eki baamu̱ki̱i̱ye ewaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Mu̱hongi̱ ali na kusalila kyana kya ntaama eki mu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye hambali bakusalilagha kihonguwa haabwa kibhi na kihonguwa kyona kyokeei̱ye. Ali na kukola eki nanga kihonguwa kya kuuhibuwʼo musango na kihonguwa haabwa kibhi, ni bya mu̱hongi̱. Ni kihonguwa ki̱hi̱ki̱li̱i̱ye kwonini. ");
INSERT INTO tlj_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Mu̱hongi̱ akwete haa saghama ya kihonguwa kya kuuhibuwʼo musango, aghisiighe haa nsonga ya kutui kwabuliyo kwa muntu oghu akwelebuwa, haa kyala kyabusaasa kya mukono ghwabuliyo, na kighele kyabusaasa kya kughulu kwabuliyo. ");
INSERT INTO tlj_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Du̱mbi̱ mu̱hongi̱ akwate haa mafu̱ta ghaa biti oli̱va aghaati̱ghaayʼo kandi aghaseese mu ngalo yee yabumesu. ");
INSERT INTO tlj_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Mu̱hongi̱ akoti̱ye kyala kiye kyabuliyo mu mafu̱ta agha kandi aghamisange milundi musanju̱ mu maaso ghaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Mu̱hongi̱ akwate mafu̱ta aghaati̱ghaayʼo kandi aghasiighe haa nsonga ya kutui kwabuliyo kwa muntu oghu akwelebuwa, haa kyala kyabusaasa kya mukono ghwabuliyo, na kighele kyabusaasa kya kughulu kwabuliyo, haagu̱u̱li̱ ya saghama ya kihonguwa kya kuuhibuwʼo musango. ");
INSERT INTO tlj_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Mafu̱ta aghaku̱ti̱ghala mu ngalo sya mu̱hongi̱ oghu, aghasiighe haa mutuwe ghwa muntu oghu akwelebuwa kandi akole mukolo ghwa kughaniluwa bibhi mu maaso ghaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Du̱mbi̱ mu̱hongi̱ ahonge kihonguwa haabwa kibhi kandi akole mukolo ghwa kughaniluwa bibhi bya muntu oghu aabaagha ateeli̱ye kumufoola oghu eeli̱ye. Haanu̱ma yʼeki, mu̱hongi̱ asale kihonguwa kyona kyokeei̱ye eki. ");
INSERT INTO tlj_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Mu̱hongi̱ oghu ahonge kihonguwa kyona kyokeei̱ye na kihonguwa kya bilimuwa haa kyakuhongelʼo bihonguwa. Du̱mbi̱ mu̱hongi̱ oghu akole mukolo ghwa muntu oghu kughaniluwa bibhi kandi muntu oghu akuba eeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Kaakuba muntu oghu aba ataakugubha kuhaayo bintu ebi, aleete kyana kya ntaama kyabusaasa kuba kihonguwa kya kuuhibuwʼo musango. Kihonguwa kya ku̱u̱mu̱ki̱ya ewaa Mukama haabwa kukola mukolo ghwa kughaniluwa bibhi kandi muntu oghu akufooka oghu eeli̱ye. Aleete dhee ki̱lo emui ya nsyano esemeeye eghi etabuuyemu mafu̱ta, na kimui kyakasatu kya li̱ta ya mafu̱ta ghaa biti oli̱va, kuba kihonguwa kya bilimuwa. ");
INSERT INTO tlj_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Muntu oghu ali na kuleeta bi̱i̱bbi̱mbo bibili kedha bwana bwa bu̱u̱pi̱i̱so bubili, ebi akugubha kutunga, kimui kuba kihonguwa haabwa kibhi kandi kinji kuba kihonguwa kyona kyokeei̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“Haa kilo kyamunaanaa kya mukolo oghukwoleka ngoku muntu oghu eeli̱ye, ali na kuleeta bihonguwa ebi ewaa mu̱hongi̱ haa mulyango ghwa weema ya kusanga-sangaanamu, mu maaso ghaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Mu̱hongi̱ ali na kukwata kyana kya ntaama kya kihonguwa kya kuuhibuwʼo musango na kibindi ekilimu mafu̱ta kandi abi̱i̱mu̱ki̱ye, niikuwo bibe kihonguwa eki̱mu̱u̱ki̱i̱ye ewaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Mu̱hongi̱ ali na kusala kyana kya ntaama kya kihonguwa kya kuuhibuwʼo musango kandi aaye haa saghama yakiyo, aghisiighe haa nsonga ya kutui kwabuliyo kwa muntu oghu akwelebuwa, haa kyala kyabusaasa kya mukono ghwabuliyo, na kighele kyabusaasa kya kughulu kwabuliyo. ");
INSERT INTO tlj_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Mu̱hongi̱ akwate ghamui haa mafu̱ta aghali mu kibindi kandi aghaseese mu ngalo yee yabumesu. ");
INSERT INTO tlj_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Mafu̱ta aghali mu mukono ghuwe ghwabuliyo aghamisange na kyala kiye kyabuliyo milundi musanju̱ mu maaso ghaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Ghamui haa mafu̱ta agha, mu̱hongi̱ aghasiighe haa nsonga ya kutui kwabuliyo kwa muntu oghu akwelebuwa, haa kyala kyabusaasa kya mukono ghwabuliyo, na kighele kyabusaasa kya kughulu kwabuliyo. Aghisiighe mu bi̱i̱kalo byonini hambali aasi̱i̱ghi̱ye saghama ya kihonguwa kya kuuhibuwʼo musango. ");
INSERT INTO tlj_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Mafu̱ta aghakuba ghati̱ghaaye mu ngalo sya mu̱hongi̱ aghasiighe haa mutuwe ghwa muntu oghu akwelebuwa kandi akole mukolo ghwa muntu oghu kughaniluwa bibhi mu maaso ghaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Du̱mbi̱ mu̱hongi̱ ahonge bi̱i̱bbi̱mbo kedha bwana bwa bu̱u̱pi̱i̱so, ebi muntu oghu akugubha kutunga. ");
INSERT INTO tlj_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Kimui haa bintu ebi mu̱hongi̱ akihonge haabwa kibhi kandi kinji nga kihonguwa kyona kyokeei̱ye. Abihonge na kihonguwa kya bilimuwa, du̱mbi̱ mu̱hongi̱ oghu akole mukolo ghwa kughaniluwa bibhi mu maaso ghaa Mukama haabwa muntu oghu eeli̱ye.” ");
INSERT INTO tlj_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Ebi niibiyo bilaghilo haa muntu oghu aabaagha alwaye bulwaye bwa ntumbi kandi oghu ataakugubha kuhaayo bihonguwa bya bu̱li̱ kilo nga bantu banji haabwa kukola mukolo ghwa kwelebuwa. ");
INSERT INTO tlj_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Mukama aaghila Musa na Alooni̱ ati, ");
INSERT INTO tlj_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Mukaaku̱ki̱dha mu nsi ya Kanaani̱ eghi nkubaha kuba yaanu, kaakuba ndeeta bulwaye bwa ntumbi mu numba mu nsi eghi, ");
INSERT INTO tlj_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","mukama wa numba eghi ali na kughenda ewaa mu̱hongi̱ kandi amughambile ati, ‘Naaboone kintu eki̱su̱si̱ye nga bulwaye bwa ntumbi mu numba yanje.’ ");
INSERT INTO tlj_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Mu̱hongi̱ ali na kulaghila kuuya bintu mu numba eghi atakataahi̱yemu kulola bhyani bulwaye bwa ntumbi obu, niikuwo hatabamu kintu kyona eki mu̱hongi̱ akughila ati takyeli̱ye. Haanu̱ma ya kubiiyamu, mu̱hongi̱ ataahemu kandi alole bhyani numba eghi. ");
INSERT INTO tlj_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Mu̱hongi̱ ali na kulola bhyani bulwaye bwa ntumbi obu haa bisiika bya numba eghi. Kaakuba abonʼo langi̱ ya ki̱si̱ka kibisi kedha mutuku kandi etaahi̱ye mu bisiika, ");
INSERT INTO tlj_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","du̱mbi̱ mu̱hongi̱ atuwe mu numba eghi kandi aaghale haa mulyango ghwayʼo haabwa bilo musanju̱. ");
INSERT INTO tlj_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Haa kilo kyamusanju̱ mu̱hongi̱ atodhe akuuke mu numba eghi kandi alole bhyani bulwaye bwa ntumbi obu. Kaakuba asanga bulwaye bwa ntumbi obu bumalakaki̱ye haa bisiika, ");
INSERT INTO tlj_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","du̱mbi̱ mu̱hongi̱ alaghile bantu baaye mabaale aghaliyo bulwaye obu kandi baghakube enja ya tau̱ni̱ eghi mu ki̱i̱kalo ki̱teeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Bisiika bya mukati ya numba eghi babi̱ti̱le bhyani kandi bu̱lofu̱ bwona obu̱ku̱lu̱ghʼo babukube enja ya tau̱ni̱ eghi mu ki̱i̱kalo eki̱teeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Mukama wa numba eghi aleetemu mabaale ghanji kukuuka mu ki̱i̱kalo kya mabaale agha baahi̱yemu kandi bisiika ebi batodhe babisiighile kusemeeye. ");
INSERT INTO tlj_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Kaakuba bulwaye bwa ntumbi butodha buboneka mu numba eghi haanu̱ma ya ku̱ku̱u̱ki̱yamu mabaale ghanji, ku̱ghi̱ti̱la bhyani kandi kutodha kughisiighila, ");
INSERT INTO tlj_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","mu̱hongi̱ atodhe akuuke kandi alole bhyani numba eghi. Kaakuba asanga bulwaye bwa ntumbi obu bumalakaki̱ye numba eghi yoona, ni bulwaye bwa ntumbi obu̱ku̱bhi̱i̱ya numba eghi kandi numba eghi tayeeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Numba eghi bali na kughigenga hansi, mabaale ghaayʼo, mbaau, etaka na musene, babiiye mu tau̱ni̱ eghi kandi babikube enja mu ki̱i̱kalo eki̱teeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Muntu weena oghu akutaaha mu numba eghi mu bwile obu ekuba eeghaaye alafookagha ateeli̱ye ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Muntu weena oghu akulaala kedha kuliila mu numba eghi ali na kunaabi̱ya ngoye siye. ");
INSERT INTO tlj_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Kaakuba mu̱hongi̱ akuuka kulola bhyani numba eghi kandi asanga bulwaye bwa ntumbi obu butamalakaki̱ye numba eghi haanu̱ma ya kughisiighila, alangilile numba eghi ngoku yeeli̱ye, nanga bulwaye bwa ntumbi obu bwaki̱li̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Mu̱hongi̱ kweli̱ya numba eghi ali na kukwata noni̱ ebili, kati kaa ki̱i̱looku̱, lughoye luumutuku na kabha kaa hai̱sopu̱. ");
INSERT INTO tlj_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Ali na kusalila emui haa noni̱ esi haa mu̱nu̱wa ghwa munagha ghwa ebumba oghulimu maasi ghaa nsulo. ");
INSERT INTO tlj_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Akwate kati kaa ki̱i̱looku̱, kabha kaa hai̱sopu̱, lughoye luumutuku na noni̱ eghi anaakaaye kandi abi̱koti̱ye mu saghama ya noni̱ eghi baasali̱ye kandi mu maasi ghaa nsulo. Du̱mbi̱ amisangile numba eghi milundi musanju̱. ");
INSERT INTO tlj_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Mu̱hongi̱ ali na ku̱koleesi̱ya saghama ya noni̱, maasi, noni̱ eghi enaakaaye, kati kaa ki̱i̱looku̱, kabha kaa hai̱sopu̱, lughoye luumutuku, haa mukolo ghwa kweli̱ya numba eghi. ");
INSERT INTO tlj_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Du̱mbi̱ ali na kulekela noni̱ eghi enaakaaye enja ya tau̱ni̱ eghi kandi eghende mu kisaka. Mu̱hongi̱ amaliilile atiyo mukolo ghwa kweli̱ya numba eghi kandi ekuba yeeli̱ye.” ");
INSERT INTO tlj_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Ebi niibiyo bilaghilo haa bulwaye bwa ntumbi, kweyagha-yagha, ");
INSERT INTO tlj_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","bulwaye bwa ntumbi mu ngoye kedha mu numba, ");
INSERT INTO tlj_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","bulwaye bwa bihute, bibbodhe kedha nkolu̱ njelu, ");
INSERT INTO tlj_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","kumanya kintu kilakaba kyeli̱ye kedha ki̱teeli̱ye. Ebi niibiyo bilaghilo haa bulwaye bwa ntumbi. ");
INSERT INTO tlj_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Mukama aaghila Musa na Alooni̱ ati, ");
INSERT INTO tlj_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Mughambile Banai̱saaleeli̱ muti, ‘Kaakuba musaasa weena atuwa mahu̱nu̱ mu busaasa buwe, akuba ateeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Mahu̱nu̱ agha nankabha gheyongela ku̱lu̱gha mu mubili ghuwe kedha ghaleka, ghakumufoola oghu ateeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ ‘Bulili bwona obu musaasa oghu mahu̱nu̱ ghakwete ku̱lu̱gha mu busaasa akulangaalʼo bukufooka bu̱teeli̱ye kandi kintu kyona eki akusitamila kikufooka eki̱teeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Muntu weena oghu aku̱ku̱ma haa bulili bwa musaasa oghu, ali na kunaabi̱ya ngoye esi aaku̱mi̱ye haa bulili obu alu̱wete, anaabe maasi mubili ghwona kandi akufooka oghu ateeli̱ye ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Muntu weena oghu akusitama haa kintu eki musaasa oghu mahu̱nu̱ ghakwete ku̱lu̱gha mu busaasa aasitamiiye, ali na kunaabi̱ya ngoye esi aasitami̱yʼo alu̱wete, anaabe maasi mubili ghwona kandi akufooka oghu ateeli̱ye ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ ‘Muntu weena oghu aku̱ku̱mʼo musaasa oghu mahu̱nu̱ ghakwete ku̱lu̱gha mu busaasa, ali na kunaabi̱ya ngoye esi aamu̱ku̱mi̱yʼo alu̱wete, anaabe maasi mubili ghwona kandi akufooka oghu ateeli̱ye ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ ‘Kaakuba musaasa oghu mahu̱nu̱ ghakwete ku̱lu̱gha mu busaasa atwi̱la muntu onji matanta, muntu oghu aatwi̱li̱i̱ye matanta ali na kunaabi̱ya ngoye esi alu̱wete, anaabe maasi mubili ghwona kandi akufooka oghu ateeli̱ye ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“ ‘Kintu kyona eki musaasa oghu akusitamʼo ani̱i̱ni̱ye haa kisolo, kikufooka eki̱teeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Muntu weena oghu aku̱ku̱mʼo kintu kyona eki musaasa oghu aasitamiiye, muntu oghu akufooka oghu ateeli̱ye ku̱hi̱ki̱ya lwagholo. Muntu weena oghu akuheeka kintu kyona eki musaasa oghu aasitamiiye, muntu oghu ali na kunaabi̱ya ngoye esi alu̱wete, anaabe maasi mubili ghwona kandi akufooka oghu ateeli̱ye ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“ ‘Kaakuba musaasa oghu mahu̱nu̱ ghakwete ku̱lu̱gha mu busaasa, aku̱mʼo muntu weena atadhu̱bhi̱ye kunaaba mu ngalo, muntu oghu aaku̱mi̱yʼo ali na kunaabi̱ya ngoye esi alu̱wete, anaabe maasi mubili ghwona kandi akufooka oghu ateeli̱ye ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ ‘Munagha ghwa ebumba oghu musaasa oghu aku̱ku̱mʼo baghwatakaki̱ye kandi kintu kyona eki̱koleeu̱we mu mbaau bakinaabi̱ye na maasi. ");
INSERT INTO tlj_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘Kaakuba musaasa oghu mahu̱nu̱ ghaleka ku̱lu̱gha mu busaasa buwe, ali na kubala bilo musanju̱ kuba aki̱li̱ye, anaabi̱ye ngoye siye kandi anaabe mubili ghwona mu maasi aghakwete kusenda, du̱mbi̱ akufooka oghu eeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Haa kilo kyamunaanaa ali na kutwala bi̱i̱bbi̱mbo bibili kedha bwana bwa bu̱u̱pi̱i̱so bubili mu maaso ghaa Mukama haa mulyango ghwa weema ya kusanga-sangaanamu kandi abihe mu̱hongi̱. ");
INSERT INTO tlj_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Mu̱hongi̱ abihonge byombi, kimui kuba kihonguwa haabwa kibhi kandi kinji kuba kihonguwa kyona kyokeei̱ye. Akole mukolo ghwa kughaniluwa bibhi mu maaso ghaa Mukama niikuwo muntu oghu akile ndwala ya kutuwa mahu̱nu̱. ");
INSERT INTO tlj_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘Kaakuba musaasa eelootelela, ali na kunaaba maasi mubili ghwona kandi akufooka oghu ateeli̱ye ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Lughoye lwona kedha kintu kyona eki̱koleeu̱we mu luhu hambali maasi aghalu̱ghi̱ye mu busaasa obu ghaatooni̱ye, bali na kukinaabi̱ya na maasi kandi kikufooka eki̱teeli̱ye ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Kaakuba musaasa alangaala na mukali̱ kandi musaasa oghu atwesi̱ya maasi, bombi bali na kunaaba maasi kandi bakufooka abateeli̱ye ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘Kaakuba mukali̱ aba alwaye bulwaye bwa bakali̱, akufooka ateeli̱ye haabwa bilo musanju̱ kandi muntu weena oghu aku̱mu̱ku̱mʼo, muntu oghu akufooka ateeli̱ye ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“ ‘Kintu kyona eki mukali̱ oghu akulangalila kedha akusitamila bwile obu kikufooka eki̱teeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Muntu weena oghu aku̱ku̱ma haa bulili bwa mukali̱ oghu, muntu oghu ali na kunaabi̱ya ngoye esi alu̱wete, anaabe maasi mubili ghwona kandi akufooka oghu ateeli̱ye ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Muntu weena oghu aku̱ku̱ma haa kintu kyona eki mukali̱ oghu aasitamiiye, muntu oghu ali na kunaabi̱ya ngoye esi alu̱wete, anaabe maasi mubili ghwona kandi akufooka oghu ateeli̱ye ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Kaakuba muntu weena aku̱ma haa bulili kedha kintu kyona eki mukali̱ oghu aasitamiiye, muntu oghu akufooka oghu ateeli̱ye ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“ ‘Kaakuba musaasa weena alangaala na mukali̱ oghu mu bwile obu mukali̱ oghu alwaye bulwaye bwa bakali̱, musaasa oghu akufooka oghu ateeli̱ye haabwa bilo musanju̱ kandi bulili bwona obu akulangaalʼo bukufooka bu̱teeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘Kaakuba mukali̱ alwala bulwaye bwa bakali̱ haabwa bilo bikani̱ye kusaali̱ya bwile obu bakali̱ bakumalagha bu̱li̱ kweli̱, kedha eeyongela kulwala kusaali̱ya haa bilo biye, akufooka oghu ateeli̱ye bwile bwona obu akumala analwaye, ngoku akuba ali mu bilo biye byonini. ");
INSERT INTO tlj_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Bulili bwona obu mukali̱ oghu akulangaalʼo kedha kintu kyona eki akusitamila bwile obu, kikufooka ki̱teeli̱ye, ngoku bintu ebi bikubaagha bwile obu alwaye bulwaye bwa bakali̱. ");
INSERT INTO tlj_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Muntu weena oghu aku̱ku̱mʼo bintu ebi mukali̱ oghu aasitamiiye, muntu oghu akufooka oghu ateeli̱ye. Muntu oghu ali na kunaabi̱ya ngoye esi alu̱wete, anaabe maasi mubili ghwona kandi akufooka oghu ateeli̱ye ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ ‘Kaakuba mukali̱ akila bulwaye bwa bakali̱ obu, ali na kubala bilo musanju̱, du̱mbi̱ akuba eeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Haa kilo kyamunaanaa ali na kutwala bi̱i̱bbi̱mbo bibili kedha bwana bwa bu̱u̱pi̱i̱so bubili ewaa mu̱hongi̱ haa mulyango ghwa weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Mu̱hongi̱ ali na kuhonga kimui haa bintu ebi nga kihonguwa haabwa kibhi kandi kinji nga kihonguwa kyona kyokeei̱ye. Akole mukolo ghwa kughaniluwa bibhi mu maaso ghaa Mukama haabwa bwile obu mukali̱ oghu aamali̱ye na bulwaye bwa bakali̱. ");
INSERT INTO tlj_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘Muli na kulinda mutiyo Banai̱saaleeli̱ kutakola bintu ebikubafoola abateeli̱ye, niikuwo bataku̱wa haabwa ku̱bhi̱i̱ya weema ehi̱ki̱li̱i̱ye yanje eghi nkuukalaghamu, eghi eli haagati yabo.’ ” ");
INSERT INTO tlj_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Ebi niibiyo bilaghilo haa musaasa oghu akutuwa mahu̱nu̱ mu busaasa buwe kedha maasi ghanji ku̱lu̱gha mu mubili ghuwe kumufoola ateeli̱ye, ");
INSERT INTO tlj_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","na mukali̱ oghu alwaye bulwaye bwa bakali̱, musaasa kedha mukali̱ oghu akwete kutuwa mahu̱nu̱ mu mubili ghuwe, na musaasa oghu akulangaala na mukali̱ oghu ateeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Mukama aabu̱gha na Musa haanu̱ma ya ku̱ku̱wa kwa batabani̱ babili baa Alooni̱, abaaku̱u̱ye haabwa kughenda mu maaso ghaa Mukama kandi kuhonga kihonguwa ekitasi̱i̱mi̱lani̱bu̱u̱we. ");
INSERT INTO tlj_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Mukama aaghila Musa ati, “Oghambile mu̱ghenji̱ waawe Alooni̱ kutataaha bwile bwona obu abbali̱ye mu Ki̱i̱kalo Ki̱hi̱ki̱li̱i̱ye kusaali̱ya byona enu̱ma ya kateni̱ eghi eli mu maaso ghaa kyakughaniililʼo bantu bibhi ekili haagu̱u̱li̱ ya sandu̱u̱ku̱ ya ndaghaano. Kaakuba ataaha mu ki̱i̱kalo eki aku̱ku̱wa, nanga nkwisa haa kyakughaniililʼo bantu bibhi ndi mu kicu. ");
INSERT INTO tlj_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Bhaatu Alooni̱ ali na kutaaha mu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye, haanu̱ma ya kuleeta ntu̱u̱li̱ ya nte nga kihonguwa haabwa kibhi kandi ntu̱u̱li̱ ya ntaama nga kihonguwa kyona kyokeei̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Ali na ku̱du̱bha kunaaba maasi mubili ghwona kandi alu̱waale bi̱lu̱waalo bi̱hi̱ki̱li̱i̱ye bya bu̱hongi̱ bini: nkanji̱ njelu, mpale ya mukati njelu eghi elabhaane na mubili, muheeko kandi kyaku̱lu̱waala mu mutuwe. ");
INSERT INTO tlj_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Alooni̱ ali na kuuya mu ki̱bbu̱la kya Banai̱saaleeli̱ ntu̱u̱li̱ ebili sya mbu̱li̱ nga kihonguwa haabwa kibhi na ntu̱u̱li̱ ya ntaama nga kihonguwa kyona kyokeei̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Alooni̱ ali na kuhonga ntu̱u̱li̱ ya nte nga kihonguwa haabwa kibhi kiye kandi akole mukolo ghwa kughaniluwa bibhi biye na bya bantu baa ka yee. ");
INSERT INTO tlj_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Du̱mbi̱ atwale mbu̱li̱ ebili esi kandi asite mu maaso ghaa Mukama haa mulyango ghwa weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Alooni̱ akome buluulu haabwa mbu̱li̱ ebili esi, kumanya eghi ekuba ya Mukama kandi eghi akulekela eghende. ");
INSERT INTO tlj_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Alooni̱ atwale mbu̱li̱ eghi kaluulu kakukwata kuba ya Mukama kandi aghihonge nga kihonguwa haabwa kibhi. ");
INSERT INTO tlj_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Bhaatu mbu̱li̱ eghi kaluulu kakukwata kuba eghi bakulekela kughenda, aghitwale mu maaso ghaa Mukama ku̱ghi̱koleesi̱ya haabwa kukola mukolo ghwa kughaniluwa bibhi bya Banai̱saaleeli̱, du̱mbi̱ aghilekele enaakaaye kandi eghende mu elungu. ");
INSERT INTO tlj_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Alooni̱ aheyo ntu̱u̱li̱ ya nte eghi nga kihonguwa kya kibhi kiye kandi akole mukolo ghwa kughaniluwa bibhi biye hamui na baa ka yee. Asale ntu̱u̱li̱ ya nte eghi nga kihonguwa haabwa kibhi kiye. ");
INSERT INTO tlj_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Akwate kibindi kiisuuye makala ghakwete kwakʼo mulilo ku̱lu̱gha haa kyakuhongelʼo bihonguwa mu maaso ghaa Mukama na ngalo ebili sya bubbani̱ busasi̱ye kandi aabitwale enu̱ma sya kateni̱. ");
INSERT INTO tlj_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Ate bubbani̱ haa mulilo oghuli mu maaso ghaa Mukama, niikuwo mwi̱ka ghwa bubbani̱ obu ghu̱swi̱ki̱le ntebe ya kyakughaniililʼo bantu bibhi ekili haagu̱u̱li̱ ya sandu̱u̱ku̱ ya ndaghaano, niikuwo Alooni̱ ataku̱wa. ");
INSERT INTO tlj_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Aaye haa saghama ya ntu̱u̱li̱ ya nte eghi, akoti̱yemu kyala kiye kandi aghimisange na kyala kiye haa kyakughaniililʼo bantu bibhi kandi aghimisange na kyala kiye milundi musanju̱ mu maaso ghaakiyo. ");
INSERT INTO tlj_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Alooni̱ asale mbu̱li̱ nga kihonguwa haabwa kibhi kya Banai̱saaleeli̱ kandi atwale saghama yayo enu̱ma ya kateni̱, aghikole ngoku aakoli̱ye saghama ya ntu̱u̱li̱ ya nte. Aghimisangile haa kyakughaniililʼo bantu bibhi kandi na mu maaso ghaakiyo. ");
INSERT INTO tlj_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Alooni̱ akolaghe atiyo mukolo ghwa kweli̱ya ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye kusaali̱ya byona haabwa butahi̱ki̱li̱i̱ye bwa Banai̱saaleeli̱, bu̱jeemi̱ bwabo kandi bibhi byabo byona. Akolaghe atiyo dhee haabwa weema ya kusanga-sangaanamu, nanga Banai̱saaleeli̱ bakukolagha bintu bi̱bhi̱i̱hi̱ye hambali baghooneeye kandi weema ya kusanga-sangaanamu, ekuukalagha haagati yabo. ");
INSERT INTO tlj_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Taaliyo muntu nʼomui oghu ali na kuba mu weema ya kusanga-sangaanamu bwile obu Alooni̱ akuba naataaha mu Ki̱i̱kalo Ki̱hi̱ki̱li̱i̱ye kusaali̱ya byona. Atabʼo muntu nʼomu oghu ali na kutaahamu ku̱hi̱ki̱ya Alooni̱ atooyemu naamali̱ye kukola mukolo ghwa kughaniluwa bibhi biye, bya bantu baa ka yee na bya ki̱bbu̱la kyona kya Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Du̱mbi̱ alu̱ghe hambali ali kandi aghende haa kyakuhongelʼo bihonguwa mu maaso ghaa Mukama kukola mukolo ghwa kughaniluwa bibhi. Akwate haa saghama ya ntu̱u̱li̱ ya nte na ya mbu̱li̱ kandi aghisiighe haa mahembe ghoona ghaa kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Alooni̱ aaye haa saghama eghi kandi aghimisange na kyala kiye haa kyakuhongelʼo bihonguwa milundi musanju̱ ku̱kyeli̱ya kandi kukiiyʼo bibhi bya Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Alooni̱ akaakumala kukola mukolo ghwa kweli̱ya Ki̱i̱kalo Ki̱hi̱ki̱li̱i̱ye kusaali̱ya byona, weema ya kusanga-sangaanamu na kyakuhongelʼo bihonguwa, ali na kuleeta mu maaso mbu̱li̱ eghi enaakaaye. ");
INSERT INTO tlj_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Alooni̱ ali na kuta mikono yee yombi haa mutuwe ghwa mbu̱li̱ eghi enaakaaye kandi aatule bintu bi̱bhi̱i̱hi̱ye byona, bu̱jeemi̱ na bibhi bya Banai̱saaleeli̱ kandi abite haa mutuwe ghwa mbu̱li̱ eghi. Ali na kuha mbu̱li̱ eghi muntu oghu aakomeeu̱we kukola mulimo ghwa kughitwala mu elungu. ");
INSERT INTO tlj_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Mbu̱li̱ eghi ekuheeka bibhi byona bya Banai̱saaleeli̱ kubitwala mu elungu hambali muntu atali kandi musaasa oghu alekele mbu̱li̱ eghi mu elungu. ");
INSERT INTO tlj_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Du̱mbi̱ Alooni̱ akuuke mu weema ya kusanga-sangaanamu, aayemu biigandulo binjelu ebi aabaagha aalu̱wete atakataahi̱ye mu Ki̱i̱kalo Ki̱hi̱ki̱li̱i̱ye kusaali̱ya byona kandi abi̱ti̱ghemu. ");
INSERT INTO tlj_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Anaabe maasi mubili ghwona aghali mu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye kandi alu̱waale ngoye na bi̱lu̱waalo biye bya bu̱li̱ kilo. Du̱mbi̱ atuwe mu weema eghi kandi ahonge kihonguwa kyona kyokeei̱ye haabuwe eenini na kihonguwa kyona kyokeei̱ye haabwa Banai̱saaleeli̱ kandi akole mukolo ghwa kughaniluwa bibhi biye na bya Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Ooki̱ye dhee bisabu̱ bya kihonguwa haabwa kibhi haa kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“Musaasa oghu aatwete mbu̱li̱ mu elungu kughilekeelela ki̱li̱mu̱ Ajajeeli̱ ali na kunaabi̱ya ngoye siye kandi anaabe maasi mubili ghwona, du̱mbi̱ akuuke hambali Banai̱saaleeli̱ baghooneeye. ");
INSERT INTO tlj_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Ntu̱u̱li̱ ya nte na mbu̱li̱ ebi baahaayeyo nga kihonguwa haabwa kibhi, ebi Alooni̱ aatwete saghama yabiyo mu Ki̱i̱kalo Ki̱hi̱ki̱li̱i̱ye kusaali̱ya byona haabwa kukola mukolo ghwa kughaniluwa bibhi bya Banai̱saaleeli̱, baghiiyeyo kandi baghi̱twesi̱ye enja ya hambali baghooneeye. Mpu, nyama na mabhi̱ ghaa bisolo ebi, babyoki̱ye na mulilo. ");
INSERT INTO tlj_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Musaasa oghu akwoki̱ya bintu ebi ali na kunaabi̱ya ngoye siye kandi anaabe maasi mubili ghwona, haanu̱ma yʼeki akugubha kukuuka hambali Banai̱saaleeli̱ baghooneeye. ");
INSERT INTO tlj_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Eki kili na kuba kilaghilo kyanu kya bilo nʼebilo. Haa kilo kyʼeku̱mi̱ kya kweli̱ kwamusanju̱ bu̱li̱ mwaka, Banai̱saaleeli̱ bamalaghe kilo kyona bataliiye byokuliya kandi muntu atakolagha mulimo ghwona, abe Munai̱saaleeli̱ kedha munamahanga oghu akaaye naanu. ");
INSERT INTO tlj_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Haa kilo eki Alooni̱ akolaghe mukolo ghwa kughaniluwa bibhi kandi kweli̱ya enu̱we. Mukama akubaghanila bibhi byanu kandi mukufooka abeeli̱ye mu maaso ghe. ");
INSERT INTO tlj_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Eki kibaaghe kilo kyanu kya Sabhato kya kuhuumula, hatabʼo muntu oghu akuliya byokuliya kilo eki kedha kukola mulimo ghwona. Eki nkilaghilo kya bilo nʼebilo. ");
INSERT INTO tlj_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Mu̱hongi̱ oghu basi̱i̱ghi̱ye mafu̱ta kandi balu̱wi̱ki̱ye kukuuka mu ki̱i̱kalo kya ese wee nga mukulu wa bahongi̱, aaniiye aakolagha mukolo ghwa kughaniluwa bibhi. Alu̱waalaghe biigandulo binjelu bi̱hi̱ki̱li̱i̱ye ");
INSERT INTO tlj_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","kandi akolaghe mukolo ghwa kughaniluwa bibhi ghwa Ki̱i̱kalo Ki̱hi̱ki̱li̱i̱ye kusaali̱ya byona, weema ya kusanga-sangaanamu, kyakuhongelʼo bihonguwa, bahongi̱ na ki̱bbu̱la kyona kya Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Eki kili na kuba kilaghilo kyanu kya bilo nʼebilo. Mukolo ghwa kughaniluwa bibhi byona bya Banai̱saaleeli̱ ghuli na kukoluwa mulundi ghumui bu̱li̱ mwaka.” Musa aakola ngoku Mukama aamulaghiiye. ");
INSERT INTO tlj_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Oghambile Alooni̱, batabani̱ be na ki̱bbu̱la kyona kya Banai̱saaleeli̱ oti, ‘Kini niikiyo Mukama aalaghiiye. ");
INSERT INTO tlj_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Kaakuba Munai̱saaleeli̱ weena ahonga nte, ntaama kedha mbu̱li̱ hambali baghooneeye kedha hantu hanji hoona, ");
INSERT INTO tlj_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","mu ki̱i̱kalo kya kughileeta haa mulyango ghwa weema ya kusanga-sangaanamu, kughihaayo nga kihonguwa ewaa Mukama, mu maaso ghaa weema ehi̱ki̱li̱i̱ye ya Mukama. Muntu oghu ali na musango ghwa bu̱ji̱ndi̱, nanga aaseesi̱ye saghama ya kisolo eki kandi ali na kubhinguwa mu Banai̱saaleeli̱ baanakiye. ");
INSERT INTO tlj_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Eki nkilaghilo kya kutanga Banai̱saaleeli̱ kuhongelagha bihonguwa hanja ya hambali baghooneeye, bhaatu babitwalaghe ewaa mu̱hongi̱ haa mulyango ghwa weema ya kusanga-sangaanamu, kubihaayo nga bihonguwa bya bu̱si̱nge ewaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Mu̱hongi̱ ali na kumisanga saghama ya kisolo eki haa kyakuhongelʼo bihonguwa kya Mukama haa mulyango ghwa weema ya kusanga-sangaanamu kandi ooki̱ye bisabu̱ byakiyo nga kihonguwa, eki kusasa kwakiyo ku̱dheedhi̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Banai̱saaleeli̱ batatodha kwefoola baamalaaya kuhonga bihonguwa ewaa bisasani̱ bya baaluhanga ebi̱su̱si̱ye mbu̱li̱ ebi bakwete kulami̱ya. Eki nkilaghilo kya bilo nʼebilo eki bali na kukwata mu mijo yabo yoona.’ ");
INSERT INTO tlj_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Oghile Banai̱saaleeli̱ oti, ‘Munai̱saaleeli̱ weena kedha munamahanga oghu aakaaye nabo, oghu akuhaayo kihonguwa kyona kyokeei̱ye kedha kihonguwa kinji ");
INSERT INTO tlj_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","kandi abhenga kukileeta haa mulyango ghwa weema ya kusanga-sangaanamu kukihongela Mukama, muntu oghu ali na kubhinguwa mu ki̱bbu̱la kya Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ ‘Kaakuba muntu weena mu Banai̱saaleeli̱ kedha munamahanga oghu akaaye nabo aliya saghama, nkufubila kwonini muntu oghu kandi nkumubhinga mu Banai̱saaleeli̱ baanakiye. ");
INSERT INTO tlj_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Bwomi̱i̱li̱ bwa kihanguwa buli mu saghama yakiyo. Saghama eghi naaghihaaye enu̱we kughihongagha haa kyakuhongelʼo bihonguwa haabwa kukola mukolo ghwa kughaniluwa bibhi byanu. ");
INSERT INTO tlj_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Nahabweki naatangi̱ye Banai̱saaleeli̱ nti, “Atabʼo muntu nʼomu mu Banai̱saaleeli̱ aba oghu ali na kuliya saghama, kedha munamahanga oghu aakaaye nabo oghu ali na kuliya saghama.” ");
INSERT INTO tlj_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ ‘Kaakuba Munai̱saaleeli̱ weena kedha munamahanga oghu akaaye hamui nabo ahiigha kandi aata kinyama kya mu kisaka kedha noni̱ ebikugubha kuliibuwa, ali na kuseesa saghama hansi kandi aghi̱swi̱ki̱le nʼetaka. ");
INSERT INTO tlj_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Bwomi̱i̱li̱ bwa bu̱li̱ kihanguwa kyona buli mu saghama yakiyo. Eki niikiyo kyaleki̱ye naalaghila Banai̱saaleeli̱ nti, “Mutaliliyagha saghama ya kihanguwa kyona, nanga bwomi̱i̱li̱ bwa bu̱li̱ kihanguwa buli mu saghama yakiyo kandi muntu weena oghu akuliya saghama ali na kubhinguwa mu Banai̱saaleeli̱.” ");
INSERT INTO tlj_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘Munai̱saaleeli̱ weena kedha munamahanga oghu akaaye hamui nabo, oghu akuliya kisolo kyekwi̱li̱i̱ye kedha eki kinyama kya mu kisaka kyati̱ye, ali na kunaabi̱ya ngoye siye kandi anaabe maasi mubili ghwona. Muntu oghu akufooka oghu ateeli̱ye ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Kaakuba atanaabi̱ya ngoye siye kandi anaaba maasi mubili ghwona, ali na kufubiluwa haabwa kibhi eki.’ ” ");
INSERT INTO tlj_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Oghile Banai̱saaleeli̱ oti, ‘Ni̱i̱si̱ye Mukama Luhanga waanu. ");
INSERT INTO tlj_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Mutalikola bintu ngʼebi Banami̱si̱li̱ bakukolagha hambali mwabaagha muukaaye kandi mutakola bintu ngʼebi Banakanaani̱ bakukolagha hambali ndimabatwala. Mutakwamilila bikoluwa bya bantu aba. ");
INSERT INTO tlj_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Muli na kukwata bilaghilo byanje kandi kweghendeseleja kukola ebi nkubalaghila. Ni̱i̱si̱ye Mukama Luhanga waanu. ");
INSERT INTO tlj_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Muli na kukwata ebi nkubalaghila na bilaghilo byanje kandi muntu weena oghu akukola ebi bilaghilo bilaghiiye akuba mwomi̱i̱li̱ haabwabiyo. Ni̱i̱si̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘Atalibʼo muntu nʼomui oghu akulangaala na mukali̱ oghu ali lughanda luwe. Ni̱i̱si̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘Otalilangaala na njoko waawe kuhemula so waawe. Mukali̱ oghu ni njoko waawe, nahabweki otalilangaala naye. ");
INSERT INTO tlj_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ ‘Otalilangaala nʼomui haa bakali̱ baa so waawe, eki kikuhemula so waawe. ");
INSERT INTO tlj_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘Otalilangaala na mwanjoko waawe, nankabha muhala wa so waawe kedha muhala wa njoko waawe, nankabha bamubyaliiye ewaanu kedha hantu hanji. ");
INSERT INTO tlj_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘Otalilangaala na muhala wa mutabani̱ waawe kedha muhala wa muhala waawe, eki kikukuhemula. ");
INSERT INTO tlj_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘Otalilangaala na muhala wa mukali̱ wa so waawe, oghu so waawe amu̱byayʼo, nanga ni mwanjoko waawe. ");
INSERT INTO tlj_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘Otalilangaala na esenga waawe, nanga ni mwani̱na so waawe. ");
INSERT INTO tlj_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘Otalilangaala na mu̱ghenji̱ wa njoko waawe wabukali̱, nanga ni lughanda lwa njoko waawe eenini. ");
INSERT INTO tlj_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘Otalihemula mu̱ghenji̱ wa so waawe kulangaala na mukali̱ wee, nanga naye ali nga esenga waawe. ");
INSERT INTO tlj_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘Otalilangaala na mugholi waawe, nanga ni mukali̱ wa mutabani̱ waawe, nahabweki otalilangaala naye. ");
INSERT INTO tlj_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘Otalilangaala na mukali̱ wa mwana wa njoko waawe, eki kikuhemula mwana wa njoko waawe oghu. ");
INSERT INTO tlj_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘Otalilangaala na mukali̱ kandi bwile bunji olangaala na muhala wee. Otalilangaala nankabha na muhala wa mutabani̱ wee kedha muhala wa muhala wee. Bakali̱ aba ni nganda sya mukali̱ oghu syonini kandi eki ni kintu ki̱bhi̱i̱hi̱ye kukola. ");
INSERT INTO tlj_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘Otaliswela mu̱ghenji̱ wa mukali̱ waawe kuba mukali̱ waawe waakabili kandi otalilangaala naye mukali̱ waawe anaakaaye. ");
INSERT INTO tlj_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘Otalilangaala na mukali̱ analwaye bulwaye bwa bakali̱, nanga bwile obu akubaagha ateeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘Otalilangaala na mukali̱ wa muliilanuwa waawe, nanga eki kikukufoola oghu ateeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘Otalihonga omui haa baana baawe ewaa Moleki̱, nanga eki kikuhemula li̱i̱na lya Luhanga waawe. Ni̱i̱si̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘Otalilangaala na musaasa muunakyawe, ngoku okulangaalagha na mukali̱. Eki Luhanga akyohi̱ye kwonini. ");
INSERT INTO tlj_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘Otalyebhi̱i̱ya kulangaala na kisolo kandi mukali̱ atalighenda hambali kisolo kili kulangaala nakiyo, eki ni kikoluwa ki̱bhi̱i̱hi̱ye kwonini. ");
INSERT INTO tlj_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘Mutalyebhi̱i̱ya kukola kimui haa bikoluwa ebi, nanga bantu aba nkubhinga munaloli̱ye mu mahanga hambali mukwete kughenda, bakeebhi̱i̱ya haabwa kukola bintu ebi. ");
INSERT INTO tlj_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Bikoluwa byabo bikabhi̱i̱ya nsi yabo, nahabweki nkufubila bantu aba haabwa bibhi byabo kandi nsi eghi ekabhenga bantu abaabaagha baakaayemu. ");
INSERT INTO tlj_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Bhaatu enu̱we muli na kukwata ebi nkubalaghila na bilaghilo byanje. Munai̱saaleeli̱ nʼomui kedha munamahanga oghu aakaaye naanu, atalikola na kimui haa bintu ebi noohi̱ye ebi. ");
INSERT INTO tlj_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Bintu bi̱bhi̱i̱hi̱ye ebi niibiyo bantu abaabaagha baakaaye mu nsi eghi baakolagha, enu̱we mutakaki̱dhi̱yemu kandi byabhi̱i̱ya nsi eghi. ");
INSERT INTO tlj_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Kaakuba naanu mu̱bhi̱i̱ya nsi eghi, ekubabhenga ngoku yaabhengi̱ye abaabaagha baakaayemu mutakaki̱dhi̱yemu. ");
INSERT INTO tlj_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘Bantu boona abakukola kimui haa bintu ebi noohi̱ye ebi, bantu aba bali na kubhinguwa mu bantu baabo. ");
INSERT INTO tlj_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Muli na kukwata ebi nkubalaghikiilila kandi mutakola na kimui haa bikoluwa ebi noohi̱ye ebi bantu baakolagha mutakaasi̱ye kandi mu̱teebhi̱i̱ya kukola bintu ebi. Ni̱i̱si̱ye Mukama Luhanga waanu.’ ” ");
INSERT INTO tlj_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Obu̱ghe na ki̱bbu̱la kyona kya Banai̱saaleeli̱ kandi obaghile oti, ‘Mube bahi̱ki̱li̱i̱ye nanga si̱ye, Mukama Luhanga waanu, ndi ahi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘Bu̱li̱ omui mu enu̱we ali na ku̱hu̱ti̱ya ni̱na wee na ese wee kandi muli na ku̱hu̱ti̱ya bilo bya Sabhato byanje. Ni̱i̱si̱ye Mukama Luhanga waanu. ");
INSERT INTO tlj_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘Mutalilami̱ya bisasani̱ kedha kwekolela baaluhanga baa byoma. Ni̱i̱si̱ye Mukama Luhanga waanu. ");
INSERT INTO tlj_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘Obu mulabaagha nimuhayo kihonguwa kya bu̱si̱nge ewaa Mukama, mukihongaghe mu mulingo ghu̱hi̱ki̱ye niikuwo nsi̱i̱maghe kihonguwa eki haabwanu. ");
INSERT INTO tlj_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Kihonguwa eki mukiliyaghe haa kilo eki mwakihongeeyemu kyonini na kilo ekilabhi̱yʼo. Kintu kyona eki̱ku̱ti̱ghala haa kihonguwa eki ku̱hi̱ki̱ya kilo kyakasatu, bali na ku̱kyoki̱ya na mulilo. ");
INSERT INTO tlj_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Kaakuba kihonguwa eki kiliibuwa haa kilo kyakasatu, kikuba eki̱teeli̱ye kandi tanku̱ki̱si̱i̱ma. ");
INSERT INTO tlj_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Muntu weena oghu akuliya haa kihonguwa eki haa kilo kyakasatu, ali na kufubiluwa haabwa ku̱bhi̱i̱ya kihonguwa ki̱hi̱ki̱li̱i̱ye kya Mukama kandi ali na kubhinguwa mu Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘Obu olabaagha nookesa bilimuwa ebi weeleei̱ye mu nsi yaawe, otahi̱kagha haakumaliilila kwa musili kedha kubimalamu. ");
INSERT INTO tlj_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Obu olabaagha nookobha bi̱ghu̱ma byawe bya mi̱jaabbi̱i̱bbu̱, otatodhagha kukuukililamu kedha kukoma-koma ebyalaghali̱ki̱ye, obilekelaghe banaku na banamahanga. Ni̱i̱si̱ye Mukama Luhanga waanu. ");
INSERT INTO tlj_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘Mutaliibha. “ ‘Mutalihabi̱i̱li̱li̱ya baanakyanu. “ ‘Mutaliha bisubha. ");
INSERT INTO tlj_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘Mutalilahila busa li̱i̱na lyanje kedha kuleka mbaghaya li̱i̱na lya Luhanga waanu. Ni̱i̱si̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘Otalibona-boni̱ya muliilanuwa waawe kedha kwibha bintu biye. “ ‘Otalilaala otasasuuye muntu oghu waahaaye mulimo kughukola. ");
INSERT INTO tlj_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘Otalikiina muntu oghu matui ghaaghaaye kedha kuta kintu mu maaso ghaa muntu oghu maaso ghaaghaaye niikuwo akikobhoke, bhaatu ohu̱ti̱ye Luhanga waawe. Ni̱i̱si̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘Otali̱tu̱wa musango etali mu bwengani̱ja mu kooti̱. Otaghilila muntu kisa nanga eye kuba munaku kedha muguudha, bhaatu mu̱twi̱laghe bantu misango mu bwengani̱ja. ");
INSERT INTO tlj_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘Otalighenda nookoka bantu banji. “ ‘Otalikola kintu kyona ekikuta bwomi̱i̱li̱ bwa muliilanuwa waawe mu kabhi. Ni̱i̱si̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘Otalyoha mu̱ghenji̱ waawe haa mutima ghwawe. Otanukaghe muliilanuwa waawe bbeni̱-bbeni̱ niikuwo otaba mu eki aasobeei̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘Otalihoola ngi̱ghu̱ kedha kusaaliluwa na omui mu bantu aba ookaaye nabo, bhaatu okundaghe muunakyawe ngoku weeku̱ndi̱ye weenini. Ni̱i̱si̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘Okwate ebi nkukulaghila. “ ‘Otali̱i̱mi̱i̱si̱ya bisolo bya mbaghani̱ja. “ ‘Otalihela mu musili ghwawe nsigho sya milingo ebili. “ ‘Otali̱lu̱waala lughoye olu̱koleeu̱we mu ngoye sya milingo ebili. ");
INSERT INTO tlj_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘Kaakuba musaasa alangaala na mukali̱ mu̱syana oghu musaasa onji alu̱ghi̱ye bhaatu batakamucunguuye kedha atakafooki̱ye wa bughabe, bantu aba bali na kufubiluwa bhaatu batabaata, nanga mukali̱ oghu aabaagha anali mu̱syana. ");
INSERT INTO tlj_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Bhaatu musaasa oghu ali na kuleeta ntu̱u̱li̱ ya ntaama haa mulyango ghwa weema ya kusanga-sangaanamu nga kihonguwa kya kuuhibuwʼo musango ewaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Mu̱hongi̱ ahonge ntu̱u̱li̱ ya ntaama eghi nga kihonguwa kya kuuhibuwʼo musango kandi akole mukolo ghwa kughaniluwa bibhi bya muntu oghu mu maaso ghaa Mukama kandi bibhi biye bikughaniluwa. ");
INSERT INTO tlj_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘Mukaaku̱ki̱dha mu nsi ya Kanaani̱, muhele biti bya milingo yoona bya bi̱ghu̱ma ebi bakuliyagha, bhaatu bi̱ghu̱ma ebi mutabiliya haabwa myaka esatu, bwile obu bikuba bitangu̱u̱we enu̱we kubiliya. ");
INSERT INTO tlj_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Mu mwaka ghwakanaa bi̱ghu̱ma ebi byona bikuba bi̱hi̱ki̱li̱i̱ye kandi bikuba bihonguwa bya ku̱si̱i̱ma ewaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Bhaatu mu mwaka ghwakataano, mukugubha kuliya bi̱ghu̱ma ebi, niikuwo biti ebi byeyongele kwana bi̱ghu̱ma bikani̱ye. Ni̱i̱si̱ye Mukama Luhanga waanu. ");
INSERT INTO tlj_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘Mutaliliya nyama eghi enalimu saghama. “ ‘Mu enu̱we atalibaamu mu̱ku̱mu̱ kedha oghu akubanduwa mi̱li̱mu̱. ");
INSERT INTO tlj_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘Mutalyeghemba esoke lyʼomu maakpengbu̱ ghaa mituwe yaanu kedha kweghemba bi̱lelu̱. ");
INSERT INTO tlj_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘Mutalyetalanga haa mibili yaanu haabwa kweghungila bantu baku̱u̱ye kedha kuteela bisasani̱ haa mibili yaanu. Ni̱i̱si̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘Mutalihemula bahala baanu kubasi̱i̱mi̱lani̱ya kufooka baamalaaya, nanga nsi eghi ekufooka ya baamalaaya kandi eesulemu bikoluwa bi̱bhi̱i̱hi̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘Mu̱hu̱ti̱yaghe kilo kyanje kya Sabhato na ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye kyanje. Ni̱i̱si̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘Mutaghendagha kulaghu̱li̱ya mu baku̱mu̱ kedha bantu abakubanduwagha mi̱li̱mu̱, nanga baku̱bhi̱i̱ya enu̱we. Ni̱i̱si̱ye Mukama Luhanga waanu. ");
INSERT INTO tlj_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘Mwemililaghe mu maaso ghaa bantu bakulu, muhaaghe ki̱ti̱i̱ni̱sa abaku̱li̱ye mu myaka kandi mu̱hu̱ti̱yaghe Luhanga waanu. Ni̱i̱si̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘Kaakuba munamahanga aakala naanu mu nsi yaanu, mutamubona-boni̱ya. ");
INSERT INTO tlj_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Munamahanga oghu aakaaye naanu muli na kumutwalikani̱ya nga Munai̱saaleeli̱ muunakyanu. Mumukunde ngoku mweku̱ndi̱ye, nanga naanu mukaba muli banamahanga mu nsi ya Mi̱si̱li̱. Ni̱i̱si̱ye Mukama Luhanga waanu. ");
INSERT INTO tlj_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘Mutakoleesi̱yagha ki̱pi̱i̱mo ekitahi̱ki̱ye obu mukuba ni̱mu̱pi̱i̱ma kujamba, ku̱lyota kedha kwengaana kwa kintu. ");
INSERT INTO tlj_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Mu̱koleesi̱yaghe minjaani̱ eghi ehi̱ki̱ye, mabaale ghahi̱ki̱ye, dhebe esi̱hi̱ki̱ye kandi biigalaponi̱ ebi̱hi̱ki̱ye. Ni̱i̱si̱ye Mukama Luhanga waanu, oghu akabaaya mu nsi ya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘Mukwate ebi nkubalaghila byona na bilaghilo byanje byona kandi mukole ebi bilaghiiye. Ni̱i̱si̱ye Mukama.’ ” ");
INSERT INTO tlj_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Oghile Banai̱saaleeli̱ oti, ‘Kaakuba Munai̱saaleeli̱ weena kedha munamahanga oghu aakaaye hamui nabo, ahonga omui haa baana be ewaa Moleki̱, muntu oghu ali na kwitibuwa. Ki̱bbu̱la kyona kya Banai̱saaleeli̱ kimuhuule mabaale aku̱we. ");
INSERT INTO tlj_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Muntu oghu nkumufubila kandi nimubhinge mu Banai̱saaleeli̱, nanga aahongi̱ye omui haa baana be ewaa Moleki̱. Aabhi̱i̱hi̱i̱ye ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye kyanje kandi aahemula li̱i̱na lyanje li̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Kaakuba muntu ohongela Moleki̱ omui haa baana be, bantu bʼomu kyalo eki aakaayemu batafuwʼo eki aakoli̱ye kandi babhenga kumwita, ");
INSERT INTO tlj_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","nkufubila muntu oghu na ka yee yoona kandi nkumubhinga mu Banai̱saaleeli̱ na boona abaabaagha naye obu beefolagha nga baamalaaya kulami̱ya Moleki̱. ");
INSERT INTO tlj_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘Kaakuba muntu aaghenda kulaghu̱li̱ya mu baku̱mu̱ kedha mu bantu abaku̱bu̱ghagha na mi̱li̱mu̱ kandi eefoola nga malaaya, nkumufubila kandi nkumubhinga mu Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘Enu̱we mweyeli̱ye kandi mube bahi̱ki̱li̱i̱ye, nanga ni̱i̱si̱ye Mukama Luhanga waanu. ");
INSERT INTO tlj_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Mukwate ebi nkubalaghila kandi mubikwamile. Ni̱i̱si̱ye Mukama, oghu akubafoolagha bahi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘Kaakuba muntu akiina ese wee kedha ni̱na wee, ali na kwitibuwa kandi musango ghu̱mu̱si̱ngi̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘Kaakuba musaasa asyana na mukali̱ wa baanini, mukali̱ wa muliilanuwa wee, bombi musaasa na mukali̱ bali na kwitibuwa. ");
INSERT INTO tlj_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘Kaakuba musaasa alangaala na mukali̱ wa ese wee, akuba ahemuuye ese wee, bombi musaasa na mukali̱ bali na kwitibuwa kandi musango ghubasi̱ngi̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘Kaakuba musaasa alangaala na mugholi wee, bombi bali na kwitibuwa. Bakuba baakoli̱ye kintu ki̱bhi̱i̱hi̱ye kwonini kandi musango ghubasi̱ngi̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘Kaakuba musaasa alangaala na musaasa muunakiye ngoku basaasa bakulangaalagha na bakali̱, bombi bakuba bakoli̱ye kintu ki̱bhi̱i̱hi̱ye kwonini kandi bali na kwitibuwa, nanga musango ghubasi̱ngi̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘Kaakuba musaasa aswela mukali̱ na ni̱na wee, eki ni kintu ki̱bhi̱i̱hi̱ye kwonini. Musaasa oghu na bakali̱ aba bombi bali na ku̱booki̱ya mu mulilo, niikuwo kintu ki̱bhi̱i̱hi̱ye nga eki kitatodha kukoluwa mu enu̱we. ");
INSERT INTO tlj_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘Kaakuba musaasa alangaala na kisolo, ali na kwitibuwa kandi muli na kwita kisolo eki. ");
INSERT INTO tlj_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘Kaakuba mukali̱ aghenda hambali kisolo kili kandi alangaala nakiyo, mwite mukali̱ oghu kandi kisolo eki. Mukali̱ oghu musango ghu̱mu̱si̱ngi̱ye na kisolo eki. ");
INSERT INTO tlj_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘Kaakuba musaasa aswela mwani̱na wee, nankabha muhala wa ese wee kedha wa ni̱na wee kandi balangaala hamui, eki ni kintu kya kuhemula. Bantu aba bali na kubhinguwa mu Banai̱saaleeli̱. Musaasa oghu akuba ahemuuye mwani̱na wee kandi musango ghu̱mu̱si̱ngi̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘Kaakuba musaasa alangaala na mukali̱ mu bwile obu mukali̱ oghu alwaye bulwaye bwa bakali̱, bantu aba bombi bali na kubhinguwa mu ki̱bbu̱la kya Banai̱saaleeli̱, nanga baatu̱u̱ye kilaghilo ekikwetʼo kuukala eeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘Otalilangaala na mu̱ghenji̱ wa njoko waawe kedha mwani̱na so waawe, nanga okuba olangaaye na lughanda lwawe eenini kandi enu̱we bombi muli na kufubiluwa haabwa kibhi kyanu eki. ");
INSERT INTO tlj_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘Kaakuba musaasa alangaala na mukali̱ wa mu̱ghenji̱ wa ese wee, akuba ahemuuye mu̱ghenji̱ wa ese wee oghu. Bombi musaasa na mukali̱ bali na kufubiluwa haabwa kibhi kyabo kandi tabaku̱byala mwana. ");
INSERT INTO tlj_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘Kaakuba musaasa alangaala na mukali̱ wa mu̱ghenji̱ wee, eki ni kikoluwa ki̱bhi̱i̱hi̱ye kandi akuba ahemuuye mu̱ghenji̱ wee kandi tabaku̱byala mwana. ");
INSERT INTO tlj_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘Mukwate byona ebi nkubalaghila na bilaghilo byanje kandi mubikwamilile, niikuwo nsi eghi ndimabatwalamu kuukalamu etababhenga. ");
INSERT INTO tlj_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Mutaba na bikoluwa nga bya bantu aba nkubhinga munaloli̱ye mu nsi eghi, nanga bintu bi̱bhi̱i̱hi̱ye ebi byona niibiyo bakukolagha kandi eki niikiyo kyaleki̱ye naabooha. ");
INSERT INTO tlj_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Bhaatu nkaghila enu̱we nti, “Mukutwala nsi ya bantu aba kandi nkughiha enu̱we nga bugwetuwa, nsi eghi ekwete kusendamu mata na bwoki.” Ni̱i̱si̱ye Mukama Luhanga waanu, oghu akabakomamu mu bantu bʼomu mahanga ghanji. ");
INSERT INTO tlj_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘Nahabweki muli na kumanya mbaghani̱ja ya bisolo ebyeli̱ye na ebi̱teeli̱ye kandi mbaghani̱ja ya noni̱ esyeli̱ye na esi̱teeli̱ye. Mu̱teebhi̱i̱ya kuliya kisolo kedha noni̱ kedha kintu kyona ekikwekuluulilagha hansi, ebi naaghi̱li̱ye nti tabyeli̱ye ewaanu. ");
INSERT INTO tlj_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Muli na kuba bahi̱ki̱li̱i̱ye ewanje nanga si̱ye Mukama ndi ahi̱ki̱li̱i̱ye kandi nkakoma enu̱we mu bantu bʼomu mahanga ghanji kuba bantu banje. ");
INSERT INTO tlj_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘Musaasa weena kedha mukali̱ weena mu enu̱we oghu aku̱bu̱gha na mi̱li̱mu̱ kedha akuba mu̱ku̱mu̱, ali na kwitibuwa. Muli na kubahuula mabaale baku̱we kandi musango ghubasi̱ngi̱ye.’ ” ");
INSERT INTO tlj_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Mukama aaghila Musa ati, “Oghile bahongi̱ batabani̱ baa Alooni̱ oti, ‘Atalibʼo mu̱hongi̱ nʼomui oghu akwebhi̱i̱ya haabwa ku̱ku̱mʼo mu̱ku̱ ghwa lughanda luwe oghu aaku̱u̱ye, ");
INSERT INTO tlj_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","kuuyʼo ali lughanda luwe eenini, nga ni̱na wee kedha ese wee, mutabani̱ wee kedha muhala wee, mwana waa ni̱na wee, ");
INSERT INTO tlj_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","kedha mwani̱na wee oghu atakasweuwe oghu aakaaye naye, haabwa kutaba na eba wee. ");
INSERT INTO tlj_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Mu̱hongi̱ ateebhi̱i̱ya ku̱ku̱mʼo mu̱ku̱ ghwa muntu oghu aaku̱u̱ye e bukuwe buwe kandi afooka oghu ateeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘Bahongi̱ tabali na kweghemba esoke haa mutuwe, kedha bi̱lelu̱ kedha kwetalanga haa mubili haabwa kweghunga. ");
INSERT INTO tlj_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Bali na kuba bahi̱ki̱li̱i̱ye ewaa Luhanga wabo kandi batahemula li̱i̱na lya Luhanga wabo, nanga bakuhongagha bihonguwa bookeei̱ye haa mulilo bya Mukama, byokuliya bya Luhanga wabo, nahabweki bali na kuba bahi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Bahongi̱ bataliswela bakali̱ abeebhi̱hi̱i̱ye haabwa kuba baamalaaya kedha aba beebabo babhi̱ngi̱ye, nanga bahongi̱ bahi̱ki̱li̱i̱ye ewaa Luhanga wabo. ");
INSERT INTO tlj_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Muli na kutwalikani̱ya bahongi̱ nga bantu bahi̱ki̱li̱i̱ye, nanga niibo bakuhongelagha Luhanga waanu byokuliya. Bahongi̱ bahi̱ki̱li̱i̱ye ewaanu, nanga si̱ye Mukama oghu akubafoolagha bahi̱ki̱li̱i̱ye ndi ahi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Kaakuba muhala wa mu̱hongi̱ eebhi̱i̱ya kufooka malaaya, akuba ahemuuye ese wee kandi mwana wabukali̱ oghu bali na ku̱mwoki̱ya mu mulilo. ");
INSERT INTO tlj_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘Mukulu wa bahongi̱ oghu basi̱i̱ghi̱ye haa mutuwe mafu̱ta ghaa kusiigha kumufoola ahi̱ki̱li̱i̱ye kandi oghu aku̱lu̱waalagha bi̱lu̱waalo bya bu̱hongi̱, ataakala ateecanuuye esoke liye kandi atalitemula biigandulo biye kwoleka ngoku eeghu̱ngi̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Atalyebhi̱i̱ya kutaaha hambali mu̱ku̱ ghwa muntu ghuli. Ateefoola oghu ateeli̱ye kutaahayo, nankabha oghu aaku̱u̱ye aba ali ese wee kedha ni̱na wee. ");
INSERT INTO tlj_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Atali̱bhi̱i̱ya ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye kya Luhanga wee ku̱lu̱ghamu kandi kughenda hambali muntu aaku̱u̱ye, nanga mafu̱ta ghaa kusiigha ghaa Luhanga wee agha baamu̱si̱i̱ghi̱ye ghakamufoola oghu ahi̱ki̱li̱i̱ye. Ni̱i̱si̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Mukulu wa bahongi̱ ali na kuswela mukali̱ oghu atamani̱ye basaasa. ");
INSERT INTO tlj_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Ataliswela mukali̱ mu̱kwi̱si̱ya kedha mukali̱ oghu eba wee abhi̱ngi̱ye kedha mukali̱ oghu eebhi̱i̱hi̱i̱ye haabwa kuba malaaya, bhaatu aswele oghu atamani̱ye basaasa ku̱lu̱gha mu bantu be Banai̱saaleeli̱, ");
INSERT INTO tlj_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","niikuwo baana be batahemuka mu bantu baa ntu̱la yee. Ni̱i̱si̱ye Mukama oghu akufoolagha mu̱hongi̱ kuba ahi̱ki̱li̱i̱ye.’ ” ");
INSERT INTO tlj_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Oghile Alooni̱ oti, ‘Mu mijo yaanu yoona eghi ekwisa, hatalibʼo nʼomui mu baasukulu baawe oghu ali na kamogo, oghu ali na kwebinga kandi kuhongela Luhanga wee kihonguwa kya byokuliya. ");
INSERT INTO tlj_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Taaliyo musaasa nʼomui mu baasukulu baawe oghu ali na kamogo, oghu ali na kwebinga kandi ku̱mpeeleli̱ya nga mu̱hongi̱. Taaliyo oghu ali na ku̱mpeeleli̱ya kaakuba aba maaso ghamuughaaye, ali mulema, alamaaye haali̱i̱so, oghu ali na kughulu ku̱di̱i̱di̱ye kusaali̱ya kunji, ");
INSERT INTO tlj_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","oghu alamaaye kughulu kedha mukono, ");
INSERT INTO tlj_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","oghu ali na egu̱mbe, oghu akpakpi̱ye, oghu ali na ki̱dheli̱ mu li̱i̱so, oghu ali na bibbodhe kedha kweyagha-yagha kedha oghu kyʼensoni̱ kiye ki̱kpeetu̱ki̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Taaliyo musaasa nʼomui mu baasukulu baa mu̱hongi̱ Alooni̱, oghu ali na kamogo oghu ali na kwebinga kandi kuhonga bihonguwa bookeei̱ye haa mulilo bya Mukama, ngoku ali na kamogo, taali na kwebinga kyakuhongelʼo bihonguwa kandi kuhonga byokuliya ewaa Luhanga wee. ");
INSERT INTO tlj_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Mu̱hongi̱ oghu akugubha kuliya haa byokuliya bi̱hi̱ki̱li̱i̱ye kwonini bya Luhanga wee. Akugubha dhee kuliya haa byokuliya binji bi̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Mu̱hongi̱ oghu haabwa kuba na kamogo, ateebinga kateni̱ ya kutaaha mu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye kedha kwebinga haai na kyakuhongelʼo bihonguwa. Eki ki̱ku̱bhi̱i̱ya bintu byanje bi̱hi̱ki̱li̱i̱ye ebili mu ki̱i̱kalo eki. Ni̱i̱si̱ye Mukama oghu nkufoolagha bintu ebi kuba bi̱hi̱ki̱li̱i̱ye.’ ” ");
INSERT INTO tlj_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Musa aaghambila Alooni̱, batabani̱ baa Alooni̱ na Banai̱saaleeli̱ boona bilaghilo ebi. ");
INSERT INTO tlj_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Oghambile Alooni̱ na batabani̱ be ku̱hu̱ti̱ya bihonguwa bi̱hi̱ki̱li̱i̱ye ebi Banai̱saaleeli̱ bakuhaayo ewanje, niikuwo batahemula li̱i̱na lyanje li̱hi̱ki̱li̱i̱ye. Ni̱i̱si̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Obaghile oti, ‘Mu mijo yaanu yoona eghi ekwisa, kaakuba omui mu baasukulu baanu oghu ateeli̱ye eebinga bihonguwa bi̱hi̱ki̱li̱i̱ye ebi Banai̱saaleeli̱ bakuhaayo ewaa Mukama, muntu oghu ali na kubhinguwa mu maaso ghanje. Ni̱i̱si̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ ‘Kaakuba omui mu baasukulu baa Alooni̱ aba alwaye bulwaye bwa ntumbi kedha mahu̱nu̱ ngamutuwa mu busaasa, taali na kuliya haa bihonguwa bi̱hi̱ki̱li̱i̱ye ku̱hi̱ki̱ya aki̱li̱ye. Mu̱hongi̱ weena akufooka oghu ateeli̱ye kaakuba aku̱mʼo kintu kyona eki̱teeli̱ye kedha mu̱ku̱ kedha eelootelela. ");
INSERT INTO tlj_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Muntu weena akufooka oghu ateeli̱ye kaakuba aku̱mʼo kisolo kyona ekikwekuluulilagha hansi kedha muntu weena oghu akugubha kuleka naafooka ateeli̱ye kedha muntu wa mulingo ghwona oghu akumufoola oghu ateeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Muntu weena oghu aku̱ku̱mʼo kimui haa bintu ebi akufooka oghu ateeli̱ye ku̱hi̱ki̱ya lwagholo. Taali na kuliya haa bihonguwa bi̱hi̱ki̱li̱i̱ye ku̱hi̱ki̱ya anaabi̱ye maasi mubili ghwona. ");
INSERT INTO tlj_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Musana ghukaakukota, akuba eeli̱ye kandi akugubha kuliya haa bihonguwa bi̱hi̱ki̱li̱i̱ye, nanga ni byokuliya biye. ");
INSERT INTO tlj_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Muntu oghu taali na kuliya kintu kyona aasangi̱ye kyekwi̱li̱i̱ye kedha eki binyama bya mu kisaka byati̱ye kandi kileka afooka oghu ateeli̱ye. Ni̱i̱si̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘Bahongi̱ bali na kukwata ebi naabalaghiiye, niikuwo musango ghutabasi̱nga kandi baku̱wa haabwa kubighaya. Ni̱i̱si̱ye Mukama oghu akubafoolagha bahi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘Taaliyo munamahanga nʼomui oghu atali wa mu ka ya mu̱hongi̱ oghu akugubha kuliya haa bihonguwa bi̱hi̱ki̱li̱i̱ye ebi, nankabha mu̱ghenu̱ wa mu̱hongi̱ oghu kedha mu̱koli̱ wee, ataliya haa bihonguwa bi̱hi̱ki̱li̱i̱ye ebi. ");
INSERT INTO tlj_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Kaakuba mu̱hongi̱ aghula mu̱syana na sente, kedha mu̱syana bamubyaliiye mu ka ya mu̱hongi̱ oghu, muntu oghu akugubha kuliya haa byokuliya ebi. ");
INSERT INTO tlj_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Kaakuba muhala wa mu̱hongi̱ asweluwa musaasa oghu atali mu̱hongi̱, mukali̱ oghu ataliya haa bihonguwa bi̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Kaakuba muhala wa mu̱hongi̱ aba ali mu̱kwi̱si̱ya kedha eba wee amu̱bhi̱ngi̱ye, bhaatu atali na baana kandi aasa kuukala mu ka ya ese wee, ngoku aakalaghayo anali mwana, akugubha kuliya haa byokuliya bya ese wee. Bhaatu muntu oghu atali wʼomu ka ya mu̱hongi̱ ataliya haa byokuliya ebi. ");
INSERT INTO tlj_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘Kaakuba muntu weena asobi̱ya kandi aliya haa kihonguwa ki̱hi̱ki̱li̱i̱ye, ali na kusasula mu̱hongi̱ haabwa kihonguwa eki kandi ongelʼo kimui kyakataano kya muhendo ghwa byokuliya ebi. ");
INSERT INTO tlj_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Mu̱hongi̱ taali na ku̱bhi̱i̱ya bintu bi̱hi̱ki̱li̱i̱ye ebi Banai̱saaleeli̱ bakuhaayo ewaa Mukama ");
INSERT INTO tlj_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","haabwa ku̱si̱i̱mi̱lani̱ya bantu abatali mu ntu̱la ya bahongi̱ kuliya haa bihonguwa bi̱hi̱ki̱li̱i̱ye ebi, kileeteleja bantu aba kuuhibuwʼo musango kandi kusasula. Ni̱i̱si̱ye Mukama oghu akufoolagha bihonguwa ebi kuba bi̱hi̱ki̱li̱i̱ye.’ ” ");
INSERT INTO tlj_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Oghile Alooni̱, batabani̱ be na Banai̱saaleeli̱ boona oti, ‘Kaakuba Munai̱saaleeli̱ kedha munamahanga oghu aakaaye na Banai̱saaleeli̱, aleeta kisembo kuba kihonguwa kyona kyokeei̱ye kya Mukama, ku̱u̱su̱li̱i̱si̱ya eki aalahiiye kedha haabwa kubbala kuwe, ");
INSERT INTO tlj_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ali na kuleeta kisolo ekitali na kamogo ku̱lu̱gha mu nte, ntaama kedha mbu̱li̱ siye, niikuwo nki̱si̱i̱me. ");
INSERT INTO tlj_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Muntu ataleeta kisolo ekili na kamogo, nanga Mukama taaku̱ki̱si̱i̱ma. ");
INSERT INTO tlj_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Kaakuba muntu ahayo kihonguwa kya bu̱si̱nge ewaa Mukama ku̱lu̱gha mu nte, ntaama kedha mbu̱li̱ siye, ku̱u̱su̱li̱i̱si̱ya eki aalahiiye kedha haabwa kubbala kuwe, kikulaghiluwa kuba kisemeeye kandi ekitali na kamogo, niikuwo nki̱si̱i̱me. ");
INSERT INTO tlj_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Mutalihongela Mukama kisolo eki maaso ghaaghaaye, ekihutaaye, ekilamaaye, ekikweyagha-yagha kedha ekilwaye bibbodhe. Mutalihonga kimui haa bisolo ebi haa kyakuhongelʼo bihonguwa nga kihonguwa bookeei̱ye haa mulilo. ");
INSERT INTO tlj_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Muntu akugubha kuhaayo ntu̱u̱li̱ ya nte kedha ntaama eghi eli na kughulu ku̱di̱i̱di̱ye kedha kujambi̱ye kusaali̱ya ghanji nga kihonguwa haabwa kubbala kuwe, bhaatu Mukama taaku̱si̱i̱ma kisolo eki haabwa muntu ku̱u̱su̱li̱i̱si̱ya eki aalahiiye. ");
INSERT INTO tlj_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Kisolo kyona eki ki̱twi̱ke kyakiyo kya nsoni̱ kyati̱ki̱ye, ki̱kpeetu̱ki̱ye, kihutaaye kedha ki̱jombi̱yʼo, mutalikihongela Mukama kandi mutalikola kintu eki mu nsi yaanu. ");
INSERT INTO tlj_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Bisolo ngʼebi mutalibiiya mu banamahanga abaakaaye mu nsi yaanu kubihaayo nga bihonguwa bya byokuliya ewaa Luhanga. Taaku̱si̱i̱ma bisolo ebi haabwanu, nanga bili na kamogo kandi bilamaaye.’ ” ");
INSERT INTO tlj_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Kaakuba kyana kya nte, kyana kya ntaama kedha kyana kya mbu̱li̱ ki̱byaluwa, kili na kuukala na ni̱naakiyo haabwa bilo musanju̱. Kilo kyamunaanaa bakugubha kukihaayo ewaa Mukama nga kihonguwa bookeei̱ye haa mulilo. ");
INSERT INTO tlj_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Mutalisala nte na kyana kyayʼo, ntaama na kyana kyayo kandi mbu̱li̱ na kyana kyayo haa kilo kimui kubihonga. ");
INSERT INTO tlj_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Kaakuba muhayo kihonguwa kya ku̱si̱i̱ma ewaa Mukama, mukihongaghe mu mulingo ghu̱hi̱ki̱ye, niikuwo aki̱si̱i̱me haabwanu. ");
INSERT INTO tlj_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Muli na kuliya nyama sya kisolo eki haa kilo eki kyonini, mutati̱ghʼo nyama nʼemui ku̱hi̱ki̱ya nkyambisi. Ni̱i̱si̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Nahabweki mukwate bilaghilo byanje kandi mukolaghe ebi bilaghiiye. Ni̱i̱si̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Mutalihemula li̱i̱na lyanje li̱hi̱ki̱li̱i̱ye, niikuwo Banai̱saaleeli̱ bamanye ngoku ndi ahi̱ki̱li̱i̱ye. Ni̱i̱si̱ye Mukama oghu akufoolagha enu̱we kuba bahi̱ki̱li̱i̱ye ");
INSERT INTO tlj_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","kandi oghu akabaaya mu nsi ya Mi̱si̱li̱ kuba Luhanga waanu. Ni̱i̱si̱ye Mukama.” ");
INSERT INTO tlj_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Oghambile Banai̱saaleeli̱ oti, ‘Bini niibiyo bi̱ghenu̱ ebi Mukama aataayʼo, ebi muli na kulangilila Banai̱saaleeli̱ kubaagha na kwekumaani̱ya ku̱hi̱ki̱li̱i̱ye kulami̱ya. ");
INSERT INTO tlj_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘Muli na bilo mukaagha bya kukola milimo yaanu, bhaatu kilo kyamusanju̱ ni kilo kya Sabhato kya kuhuumula, kilo kya kuba na kusanga-sangaana ku̱hi̱ki̱li̱i̱ye. Mutalikola mulimo ghwona, hoona hambali muukaaye. Kilo eki ni kilo kya Sabhato kya Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘Bini niibiyo bi̱ghenu̱ ebi Mukama aataayʼo haabwanu, ebi muli na kukola haa bwile bwabiyo bwonini. Haa bilo ebi mubaaghe na kwekumaani̱ya ku̱hi̱ki̱li̱i̱ye kulami̱ya. ");
INSERT INTO tlj_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","“ ‘Ki̱ghenu̱ kya Kusaaluwʼo kya Mukama kilatandikagha lwagholo lwa kilo kya eku̱mi̱ na bbinaa kya kweli̱ kwʼoku̱du̱bha. ");
INSERT INTO tlj_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Haa kilo kya eku̱mi̱ na bitaano kya kweli̱ oku, niibuwo Ki̱ghenu̱ kya Mukama kya migaati̱ etalimu ki̱tu̱mbi̱so kilatandikagha kandi muli na kuliya migaati̱ etalimu ki̱tu̱mbi̱so haabwa bilo musanju̱. ");
INSERT INTO tlj_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Haa kilo kyʼoku̱du̱bha mubaaghe na kusanga-sangaana ku̱hi̱ki̱li̱i̱ye kandi mutakolagha mulimo. ");
INSERT INTO tlj_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Muhongelaghe Mukama bihonguwa bookeei̱ye haa mulilo haabwa bilo musanju̱ kandi haa kilo kyamusanju̱ kya ki̱ghenu̱ eki mubaaghe na kusanga-sangaana ku̱hi̱ki̱li̱i̱ye kandi mutakolagha mulimo.’ ” ");
INSERT INTO tlj_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Oghile Banai̱saaleeli̱ oti, ‘Mukaaku̱ki̱dha mu nsi eghi ndimaghenda kubaha kandi nimwakesa ebi mweleei̱ye, muleete ewaa mu̱hongi̱ mughanulo ghwa kabha kaa bilimuwa ebi mwadu̱bhi̱ye kukesa. ");
INSERT INTO tlj_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Mu̱hongi̱ oghu aamu̱ki̱ye kabha aka mu maaso ghaa Mukama, niikuwo Mukama asi̱i̱me kihonguwa eki haabwanu kandi mu̱hongi̱ ali na ku̱u̱mu̱ki̱ya kabha aka haa kilo ekilabhi̱yʼo Sabhato niyaahooyʼo. ");
INSERT INTO tlj_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Haa kilo eki mu̱hongi̱ aku̱u̱mu̱ki̱ya kabha aka, muli na kuhonga kihonguwa kyona kyokeei̱ye kya Mukama kya kyana kya ntaama kya mwaka ghumui kandi ekitali na kamogo. ");
INSERT INTO tlj_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Kyana kya ntaama eki mukihonge na kihonguwa kya bilimuwa kya ki̱lo ebili sya nsyano eghi esemeeye, eghi etabuuyemu mafu̱ta, kuba kihonguwa bookeei̱ye haa mulilo, eki kusasa kwakiyo ku̱dheedhi̱ye Mukama. Muhonge dhee li̱ta emui ya vi̱i̱ni̱ kuba kihonguwa kyakunuwa. ");
INSERT INTO tlj_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Haa kilo eki, mutaliliya migaati̱, bilimuwa bi̱teeki̱ye kedha bibisi, ku̱hi̱ki̱ya mu̱leeti̱ye kihonguwa kya Luhanga waanu. Eki nkilaghilo eki muli na kukwata bilo nʼebilo kandi hoona hambali mulabaagha muukaaye mu mijo yaanu yoona mu bwile obuliisa. ");
INSERT INTO tlj_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘Muli na kubala wi̱i̱ki̱ musanju̱ ku̱lu̱gha haa kilo ekilabhi̱ye kilo kya Sabhato, kilo eki mwaleeti̱ye kabha kaa kihonguwa kya ku̱u̱mu̱ki̱ya. ");
INSERT INTO tlj_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Muli na kubala dhee bilo maku̱mi̱ ataano ku̱hi̱ka haa kilo ekilabhi̱ye Sabhato ya musanju̱, du̱mbi̱ muhaagheyo ewaa Mukama kihonguwa kihyaka kya bilimuwa. ");
INSERT INTO tlj_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Bu̱li̱ ka eli na kuleeta migaati̱ ebili eghi elimu ki̱tu̱mbi̱so ya ku̱u̱mu̱ki̱ya ewaa Mukama, eghi bateeki̱ye mu ki̱lo ebili sya nsyano esemeeye, kuba kihonguwa kya mughanulo ewaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Migaati̱ eghi mughihongaghe na byana bya ntaama musanju̱ bya mwaka ghumui kandi ebitali na kamogo, ntu̱u̱li̱ ya nte emui na ntu̱u̱li̱ sya ntaama ebili. Eki kibe kihonguwa kyona kyokeei̱ye kya Mukama. Mukihongaghe na bihonguwa bya bilimuwa na byakunuwa, kuba kihonguwa bookeei̱ye haa mulilo eki kusasa kwakiyo ku̱dheedhi̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Muli na kuhonga ntu̱u̱li̱ emui ya mbu̱li̱ kuba kihonguwa haabwa kibhi kandi byana bya ntaama bibili bya mwaka ghumui, kuba kihonguwa kya bu̱si̱nge. ");
INSERT INTO tlj_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Mu̱hongi̱ ali na ku̱u̱mu̱ki̱ya byana bya ntaama bibili mu maaso ghaa Mukama nga kihonguwa baamu̱ki̱i̱ye, na mugaati̱ ghwa mughanulo. Bintu ebi ni kihonguwa ki̱hi̱ki̱li̱i̱ye ewaa Mukama haabwa mu̱hongi̱ oghu. ");
INSERT INTO tlj_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Kilo eki mubaaghe na kusanga-sangaana ku̱hi̱ki̱li̱i̱ye kandi mutakolagha mulimo. Eki nkilaghilo eki muli na kukwata bilo nʼebilo mu mijo yaanu yoona, hambali mulabaagha muukaaye. ");
INSERT INTO tlj_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘Obu mulabaagha nimukesa bilimuwa byanu mu nsi yaanu, mutahi̱kagha haa bu̱li̱ kumaliilila kwa musili, kedha kubimalamu byona, ebyati̱ghaayemu mubilekelaghe banaku na banamahanga. Ni̱i̱si̱ye Mukama Luhanga waanu.’ ” ");
INSERT INTO tlj_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Oghile Banai̱saaleeli̱ oti, ‘Kilo kyʼoku̱du̱bha kya kweli̱ kwamusanju̱ kili na kuba kilo kyanu kya kuhuumula. Mulakaaghu̱wagha elaka lya bi̱i̱di̱yo haa kilo eki, mubaaghe na kusanga-sangaana ku̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Mutakolagha mulimo ghwona haa kilo eki, bhaatu muhongaghe ewaa Mukama kihonguwa bookeei̱ye haa mulilo.’ ” ");
INSERT INTO tlj_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Kilo kyʼeku̱mi̱ kya kweli̱ kwamusanju̱ kilabaagha kilo kya mukolo ghwa bantu kughaniluwa bibhi. Haa kilo eki mutaliyagha kantu koona, bhaatu mubaaghe na kusanga-sangaana ku̱hi̱ki̱li̱i̱ye kandi muhaagheyo kihonguwa bookeei̱ye haa mulilo kya Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Mutakolagha mulimo ghwona haa kilo eki, nanga ni kilo kya mukolo ghwa kughaniluwa bibhi byanu mu maaso ghaa Mukama Luhanga waanu. ");
INSERT INTO tlj_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Muntu weena mu enu̱we oghu akubhenga kwesala ataliiye haa kilo eki, ali na kubhinguwa mu Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Muntu weena oghu akukola mulimo haa kilo eki, nku̱mu̱hwelekeeleli̱ya mu Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Mutalikola mulimo ghwona haa kilo eki kandi eki nkilaghilo kyanu eki muli na kukwata bilo nʼebilo mu mijo yaanu yoona, hambali mulabaagha muukaaye. ");
INSERT INTO tlj_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Kilo eki kilabaagha Sabhato yaanu kuhuumula kandi muli na kwesala mutaliiye. Sabhato yaanu etandikaghe lwagholo lwa kilo kya mwenda kya kweli̱ oku ku̱hi̱ki̱ya lwagholo lwa kilo kyʼeku̱mi̱.” ");
INSERT INTO tlj_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Oghile Banai̱saaleeli̱ oti, “Kilo kya eku̱mi̱ na bitaano kya kweli̱ kwamusanju̱, niibuwo Ki̱ghenu̱ kya Mukama kya Kulaala mu Bujalaja kilatandikagha kandi kilamalagha bilo musanju̱. ");
INSERT INTO tlj_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Haa kilo kyʼoku̱du̱bha kya ki̱ghenu̱ eki, mubaaghe na kusanga-sangaana ku̱hi̱ki̱li̱i̱ye kandi mutakolagha mulimo ghwona. ");
INSERT INTO tlj_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Bilo musanju̱ ebi mubimalaghe nimunahongela Mukama bihonguwa bookeei̱ye haa mulilo, haa kilo kyamunaanaa mubaaghe na kusanga-sangaana ku̱hi̱ki̱li̱i̱ye kandi kuhongela Mukama kihonguwa bookeei̱ye haa mulilo. Kilo eki kibaaghe kya kulami̱ya kumaliilila ki̱ghenu̱ eki kandi mutakolagha mulimo ghwona. ");
INSERT INTO tlj_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“Ebi niibiyo bi̱ghenu̱ ebi Mukama aataayʼo ebi muli na kulangilila bantu, bwile obu balabaagha na kwekumaani̱ya ku̱hi̱ki̱li̱i̱ye kulami̱ya kandi kuleeta bihonguwa bookeei̱ye haa mulilo bya Mukama, bihonguwa byona byokeei̱ye, bihonguwa bya bilimuwa, bihonguwa binji na bihonguwa byakunuwa kandi bu̱li̱ kimui mbakihonga haa kilo kyakiyo. ");
INSERT INTO tlj_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Mukolaghe bi̱ghenu̱ ebi kwongela haa Sabhato sya Mukama kandi haa bisembo byanu, bihonguwa mulahiiye kuhaayo na bihonguwa mukuhaayo haabwa kubbala kwanu ewaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“Nahabweki haa kilo kya eku̱mi̱ na bitaano kya kweli̱ kwamusanju̱, haanu̱ma ya kukumaani̱ya ebi mweleei̱ye mu nsi yaanu, mukolaghe ki̱ghenu̱ kya Mukama eki haabwa bilo musanju̱. Kilo kyʼoku̱du̱bha kya ki̱ghenu̱ eki ni kilo kya kuhuumula kandi na kilo kyamunaanaa ni kilo dhee kya kuhuumula. ");
INSERT INTO tlj_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Haa kilo kyʼoku̱du̱bha kya ki̱ghenu̱ eki mukwataghe bi̱ghu̱ma bya biti bisemeeye, bi̱kongu̱bho bya mba na matai ghaa biti bya mababi ghakani̱ye ebitooye haakpengbu̱ ya maasi kandi mudheedhuwaghe mu maaso ghaa Mukama Luhanga waanu haabwa bilo musanju̱. ");
INSERT INTO tlj_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Mukolaghe ki̱ghenu̱ kya Mukama eki haabwa bilo musanju̱ bu̱li̱ mwaka. Kini nkilaghilo kyanu kukwata bilo nʼebilo mu mijo yaanu yoona. Muli na kukola ki̱ghenu̱ eki bu̱li̱ kweli̱ kwamusanju̱. ");
INSERT INTO tlj_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Mulaalaghe mu bujalaja haabwa bilo musanju̱. Banai̱saaleeli̱ boona bali na kulaala mu bujalaja, ");
INSERT INTO tlj_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","niikuwo baasukulu baanu bamanye ngoku si̱ye Mukama naalekagha Banai̱saaleeli̱ baalaala mu bujalaja, obu naabaayagha mu nsi ya Mi̱si̱li̱. Ni̱i̱si̱ye Mukama Luhanga waanu.” ");
INSERT INTO tlj_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Nahabweki Musa aalangilila Banai̱saaleeli̱ bi̱ghenu̱ bya Mukama ebi. ");
INSERT INTO tlj_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Olaghile Banai̱saaleeli̱ kukuleetela mafu̱ta ghasemeeye ghaa biti oli̱va ghaa kuta mu taala niikuwo taala eghi eekalaghe yaaki̱ye bwile bwona. ");
INSERT INTO tlj_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Bu̱li̱ lwagholo, Alooni̱ aghendaghe mu weema ya kusanga-sangaanamu, abhaki̱yaghe taala kandi siikalaghe syaki̱ye ku̱hi̱ki̱ya nkyambisi, mu maaso ghaa Mukama, enja ya kateni̱ eghi eli mu maaso ghaa sandu̱u̱ku̱ ya ndaghaano. Eki nkilaghilo eki muli na kukwata bilo nʼebilo mu mijo yaanu yoona eghi ekwisa. ");
INSERT INTO tlj_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Alooni̱ ali na kuloleelela taala esili haa kyakutʼo taala kya feeja esemeeye kandi siikalaghe syaki̱ye bwile bwona mu maaso ghaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Okwate ki̱lo eku̱mi̱ nʼebili sya nsyano esemeeye kandi oteekemu migaati̱ eku̱mi̱ nʼebili. ");
INSERT INTO tlj_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Migaati̱ eghi oghipange mu lai̱ni̱ ebili, ote mukaagha mu bu̱li̱ lai̱ni̱, haa meeja ya feeja esemeeye mu maaso ghaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Ote bubbani̱ busemeeye kandi busasi̱ye haa bu̱li̱ lai̱ni̱, hamui na migaati̱ kuba kyakuusukilʼo kya kihonguwa bookeei̱ye haa mulilo kya Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Bu̱li̱ kilo kya Sabhato, Alooni̱ apangaghe kusemeeye migaati̱ eghi haa meeja mu maaso ghaa Mukama, haabwa Banai̱saaleeli̱ kuusuka ndaghaano ya bilo nʼebilo. ");
INSERT INTO tlj_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Migaati̱ eghi ebaaghe ya Alooni̱ na batabani̱ be kandi baghiliilaghe mu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye, nanga nkilaghilo migaati̱ eghi kuba mughabo ghwabo ghu̱hi̱ki̱li̱i̱ye kwonini, haa bihonguwa bookeei̱ye haa mulilo bya Mukama.” ");
INSERT INTO tlj_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Hakaba haliyo mutabani̱ wa mukali̱ Munai̱saaleeli̱ oghu musaasa Munami̱si̱li̱ aamubyayʼo, kilo kimui mutabhana oghu aatuwa mu weema yee hambali Banai̱saaleeli̱ baghooneeye, aaghenda kandi aatandika kulwana na Munai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Mutabani̱ wa mukali̱ Munai̱saaleeli̱, ambula li̱i̱na lya Mukama, du̱mbi̱ baamukwata kandi baamuleeta ewaa Musa. (Li̱i̱na lya ni̱na mutabhana oghu baamughilaghamu Selomi̱ti̱, muhala wa Di̱bbi̱li̱ wʼomu ntu̱la ya Daani̱.) ");
INSERT INTO tlj_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Banai̱saaleeli̱ baata mutabhana oghu mu nkomo ku̱hi̱ki̱ya bamani̱ye eki Mukama akubbala ati bakole. ");
INSERT INTO tlj_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Niibuwo Mukama aaghi̱li̱ye Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Mu̱twesi̱ye enja ya hambali mughooneeye mutabhana oghu ambuuye Mukama. Bantu boona abaaghu̱u̱ye naabu̱gha kintu ki̱bhi̱i̱hi̱ye eki bate mikono yabo haa mutuwe ghuwe kandi ki̱bbu̱la kyona kya Banai̱saaleeli̱ kimuhuule mabaale aku̱we. ");
INSERT INTO tlj_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Oghile Banai̱saaleeli̱ oti, ‘Kaakuba muntu weena akiina Luhanga wee, bamufubile haabwa kibhi eki. ");
INSERT INTO tlj_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Muntu weena oghu akwambula li̱i̱na lya Mukama ali na kwitibuwa. Ki̱bbu̱la kyona kya Banai̱saaleeli̱ kimuhuule mabaale aku̱we, nankabha aba ali munamahanga kedha ali Munai̱saaleeli̱, kaakuba ambula li̱i̱na lya Mukama, ali na kwitibuwa. ");
INSERT INTO tlj_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘Kaakuba muntu aata muunakiye, ali na kwitibuwa. ");
INSERT INTO tlj_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Kaakuba muntu aata kisolo kya muunakiye, asasulemu kisolo kisemeeye ekinaakaaye, bwomi̱i̱li̱ busasuluwe bwomi̱i̱li̱. ");
INSERT INTO tlj_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“ ‘Kaakuba muntu ahutaali̱ya muliilanuwa wee, ngoku aamu̱hu̱taai̱ye haaliikuwo naye baamuhutaali̱ya. ");
INSERT INTO tlj_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Kaakuba amuhenda eku̱wa omuhende eku̱wa, oghu akumuuyamu li̱i̱so, omuuyemu li̱i̱so, oghu akumukobha li̱i̱no, omukobhe li̱i̱no. Muntu ngoku aahu̱taai̱ye muunakiye haaliikuwo naye baamuhutaali̱ya. ");
INSERT INTO tlj_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Kaakuba muntu aata kisolo kya muunakiye, asasulemu kinji kisemeeye ekinaakaaye, bhaatu muntu weena oghu akwita muunakiye, ali na kwitibuwa. ");
INSERT INTO tlj_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Eki nkilaghilo kimui haa munamahanga na Munai̱saaleeli̱. Ni̱i̱si̱ye Mukama Luhanga waanu.’ ” ");
INSERT INTO tlj_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Obu Musa aamali̱ye kughambila Banai̱saaleeli̱ bintu ebi, du̱mbi̱ baatwesi̱ya enja ya hambali baghooneeye mutabhana oghu ambuuye Mukama kandi baamuhuula mabaale aaku̱wa. Banai̱saaleeli̱ baakola ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Mukama aaghila Musa haa mwena Si̱naai̱ ati, ");
INSERT INTO tlj_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Oghile Banai̱saaleeli̱ oti, ‘Mukaaku̱ki̱dha mu nsi eghi ndimaghenda kubaha, bu̱li̱ mwaka ghwamusanju̱ mutakolagha nsi eghi ku̱hu̱ti̱ya Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Mu myaka mukaagha ohelaghe bilimuwa byawe mu misili yaanu, osaliililaghe misili yaawe ya mi̱jaabbi̱i̱bbu̱ kandi okesaghe bilimuwa byawe. ");
INSERT INTO tlj_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Bhaatu mwaka ghwamusanju̱ ghubaaghe Sabhato ya Mukama kandi etaka lyona lihuumulaghe mwaka oghu. Otahelagha mu misili yaawe kedha kusaliilila misili yaawe ya mi̱jaabbi̱i̱bbu̱. ");
INSERT INTO tlj_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Otakesagha bilimuwa ebikwetwela mu nsi eghi kedha kukobha bi̱ghu̱ma bya mi̱jaabbi̱i̱bbu̱ eghi etasaliliiye. Nsi eghi eli na kuhuumula mwaka oghu ghwona. ");
INSERT INTO tlj_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Bhaatu bilimuwa ebikwetwela mu nsi mu mwaka ghwa Sabhato ghwa kuhuumula oghu, bikugubha kuba byokuliya byanu kandi bya baheeleli̱ya baanu baabusaasa na baabukali̱, bakoli̱ baanu, banamahanga abaakaaye naanu, ");
INSERT INTO tlj_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","bisolo byawe na binyama bya mu kisaka mu nsi yaanu eghi. Okugubha kuliya bilimuwa byona ebikutuwa mu nsi eghi. ");
INSERT INTO tlj_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘Obalaghe Sabhato ya myaka musanju̱, ekikumaani̱i̱si̱ya myaka musanju̱ milundi musanju̱, eghi niiyo yoona myaka maku̱mi̱ anaa na mwenda. ");
INSERT INTO tlj_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Haa kilo kyʼeku̱mi̱ kya kweli̱ kwamusanju̱ kwa mwaka ghwa maku̱mi̱ anaa na mwenda, kilo kya mukolo ghwa bantu kughaniluwa bibhi, muteelaghe bi̱i̱di̱yo mu nsi yaanu yoona. ");
INSERT INTO tlj_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Mutwalaghe mwaka ghwa maku̱mi̱ ataano kuba ghu̱hi̱ki̱li̱i̱ye kandi mulangililaghe bantu boona mu nsi yaanu ngoku ghuli mwaka ghwa bughabe. Mwaka oghu ghubaaghe ghwa bughabe hambali bu̱li̱ muntu ali na kukuuka mu kibanja kiye kandi mu ntu̱la yee. ");
INSERT INTO tlj_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Mwaka ghwa maku̱mi̱ ataano ghubaaghe mwaka ghwanu ghwa bughabe. Mutahelagha bilimuwa kedha kukesa ebyetweleeyemu byonini kedha kukobha bi̱ghu̱ma bya mi̱jaabbi̱i̱bbu̱ eghi mutasaliliiye. ");
INSERT INTO tlj_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Nanga ni mwaka ghwa bughabe kandi ghu̱hi̱ki̱li̱i̱ye ewaanu. Nahabweki muliyaghe ebyetweleeye mu misili. ");
INSERT INTO tlj_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘Mu mwaka ghwa bughabe oghu bu̱li̱ muntu ali na kukuuka mu kibanja kiye. ");
INSERT INTO tlj_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ ‘Kaakuba oghu̱li̱ya kedha oghula kibanja na Munai̱saaleeli̱ muunakyawe, bu̱li̱ muntu abe wa majima haa muunakiye. ");
INSERT INTO tlj_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Kaakuba oghula musili ewaa Munai̱saaleeli̱ muunakyawe, muhendo okusasula ghuli na kusighikila haa myaka eghi yaasaaye ku̱lu̱gha haa mwaka ghwa bughabe oghu. Oghu aku̱ghu̱li̱ya ali na kutʼo muhendo naasighikila haa myaka eghi enati̱ghaaye ku̱hi̱ka haa mwaka ghunji ghwa bughabe oghu. ");
INSERT INTO tlj_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Myaka eghi niyaabaaye ekani̱ye, ali na kukani̱ya muhendo, bhaatu niyaabaaye eli nkee, ali na ku̱keehi̱ya muhendo, nanga ebi akwete ku̱ku̱ghu̱li̱ya ni bilimuwa ebi okuhelamu. ");
INSERT INTO tlj_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Bu̱li̱ muntu abe wa majima haa muunakiye kandi mu̱hu̱ti̱ye Luhanga. Ni̱i̱si̱ye Mukama Luhanga waanu. ");
INSERT INTO tlj_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘Mu̱hu̱ti̱ye ebi nkubalaghila kandi mweghendeseleje kukwata bilaghilo byanje, niikuwo muukale kusemeeye mu nsi eghi. ");
INSERT INTO tlj_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Nsi eghi ekweli̱ya byokuliya bikani̱ye, mukuliya muukute kandi muukale mu nsi eghi kusemeeye. ");
INSERT INTO tlj_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Mukugubha ku̱bu̱u̱li̱ya muti, “Mbiki tukuliya mu mwaka ghwamusanju̱ obu tukuba tutaakuhela kandi tutaakukesa bilimuwa byatu?” ");
INSERT INTO tlj_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Mu mwaka ghwa mukaagha nkubaha mu̱gi̱sa, nsi yaanu ekweli̱ya byokuliya ebikubamala haabwa myaka esatu. ");
INSERT INTO tlj_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Obu mukuba nimuhela bilimuwa mu mwaka ghwa munaanaa, mukuliya byokuliya ebi mwaheli̱ye mu myaka ya enu̱ma kandi mukweyongela kuliya byokuliya ebi ku̱hi̱ki̱ya haa kukesa kwa mwaka ghwa mwenda. ");
INSERT INTO tlj_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘Muntu ataghu̱li̱ya muunakiye kibanja kukitwalila kimui, nanga nsi eghi ni yanje, enu̱we mukughiikalamu nga banamahanga kandi bapangi̱i̱si̱ya banje. ");
INSERT INTO tlj_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Kaakuba muntu aghula kibanja ewaa muunakiye, oghu aamu̱ghu̱li̱i̱ye kiyo niiye ali na kukicungula. ");
INSERT INTO tlj_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Kaakuba Munai̱saaleeli̱ muunakyawe aba munaku kandi aghu̱li̱ya haa kibanja kiye, lughanda luwe eenini aaniiye aacungula kibanja eki. ");
INSERT INTO tlj_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Kaakuba muntu oghu aba atali na lughanda luwe eenini oghu akughula kibanja eki, bhaatu atunga sente sikumala sya kugubha kukicungula, ");
INSERT INTO tlj_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","ali na kubala myaka eghi yaasaaye ku̱lu̱gha aaki̱ghu̱li̱i̱ye, niikuwo asasule oghu akakighula myaka eghi enati̱ghaaye mu maaso kandi akyeku̱u̱ki̱li̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Kaakuba atagubha ku̱kyeku̱u̱ki̱li̱ya, aleke kiikale kili kya oghu aaki̱ghu̱li̱i̱ye, ku̱hi̱ki̱ya haa mwaka ghwa bughabe. Mu mwaka ghwa bughabe oghu, kibanja eki baki̱ku̱u̱ki̱li̱ye mukama wakiyo oghu akaki̱ghu̱li̱ya. ");
INSERT INTO tlj_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘Kaakuba muntu aghu̱li̱ya numba eghi eli mu kibugha eki bigho byeli̱ghi̱li̱i̱ye, ali na bughabe kutodha kughighula mwaka ghumui ghutakahooyʼo haanu̱ma ya ku̱ghi̱ghu̱li̱ya. Mu mwaka oghu ghwona akugubha kutodha kughicungula. ");
INSERT INTO tlj_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Kaakuba atagubha kucungula numba eghi mu mwaka ghumui, numba eghi eli mu kibugha eki bigho byeli̱ghi̱li̱i̱ye, elabaagha ya oghu aaghi̱ghu̱li̱ye na baasukulu be bilo nʼebilo. Mu mwaka ghwa bughabe batamu̱ku̱u̱ki̱li̱ya numba eghi. ");
INSERT INTO tlj_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Bhaatu manumba ngaabaaye ghali mu kyalo kandi ghatali na bigho bi̱gheeli̱ghi̱li̱i̱ye, bakama baa manumba agha bakugubha kughacungula kandi ku̱gheeku̱u̱ki̱li̱ya mu mwaka ghwa bughabe. ");
INSERT INTO tlj_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘Kaakuba Baleevi̱ baba bali na manumba mu maatau̱ni̱ agha bigho byeli̱ghi̱li̱i̱ye, bali na bughabe bwa kughacungula bwile bwona. ");
INSERT INTO tlj_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Bhaatu kaakuba Mu̱leevi̱ aghu̱li̱ya numba mu maatau̱ni̱ agha kandi atagubha kughicungula, eli na kumukuukila mu mwaka ghwa bughabe, nanga manumba agha Baleevi̱ bali nagho mu maatau̱ni̱ agha ni manumba ghaabo bwile bwona mu Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Bhaatu byalo bya ku̱li̱i̱si̱li̱yamu ebili haai na maatau̱ni̱ ghaa Baleevi̱, tabali na ku̱bi̱ghu̱li̱ya, nanga ni byabo bilo nʼebilo. ");
INSERT INTO tlj_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘Kaakuba omui mu Banai̱saaleeli̱ baanakyawe aba munaku kandi atakugubha kwekoonela, omukoonele ngoku wangukola munamahanga kedha mu̱ghenu̱ wa bwile bukee, niikuwo aakale naawe. ");
INSERT INTO tlj_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Otamuuyʼo maghobo ghaa mulingo ghwona, bhaatu uwe ohu̱ti̱ye Luhanga waawe, niikuwo Munai̱saaleeli̱ muunakyawe oghu aakale naawe. ");
INSERT INTO tlj_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Otamweholi̱ya sente oti akuteelʼo maghobo kedha ku̱mu̱ghu̱li̱ya byokuliya niikuwo otungʼo maghobo. ");
INSERT INTO tlj_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ni̱i̱si̱ye Mukama Luhanga waanu, oghu akabaaya mu nsi ya Mi̱si̱li̱ kubaha nsi ya Kanaani̱ kandi kuba Luhanga waanu. ");
INSERT INTO tlj_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘Kaakuba Muhebbulaayo muunakyawe aba munaku kandi atu̱wamu kweghu̱li̱ya ewaawe, otamu̱koleesi̱ya nga mu̱syana. ");
INSERT INTO tlj_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Omutwalikani̱ye nga muntu opangi̱i̱si̱i̱ye kukukolela kedha nga mu̱ghenu̱ oghu aakaaye naawe kandi ali na kukukolela ku̱hi̱ki̱ya haa mwaka ghwa bughabe. ");
INSERT INTO tlj_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Bwile obu oli na kumuleka aghende na baana be mu ka yee kandi mu ntu̱la yee. ");
INSERT INTO tlj_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Banai̱saaleeli̱ ni baheeleli̱ya banje aba naahi̱ye mu nsi ya Mi̱si̱li̱ kandi tabali na kubaghu̱li̱ya nga basyana. ");
INSERT INTO tlj_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Otabatwalikani̱yagha kubhi, bhaatu ohu̱ti̱yaghe Luhanga waawe. ");
INSERT INTO tlj_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Basyana baanu baabusaasa na baabukali̱ bali na ku̱lu̱gha mu mahanga agheeli̱ghi̱li̱i̱ye enu̱we, mukugubha kughula basyana ku̱lu̱gha mu bantu aba. ");
INSERT INTO tlj_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Mukugubha kughula banamahanga abaakaaye naanu kedha bamui mu baana baabo aba babyaliiye mu nsi yaanu kuba basyana baanu. ");
INSERT INTO tlj_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Mukugubha kuha bantu aba batabani̱ baanu kuba bantu baabo kedha kubafoola basyana baabo bilo nʼebilo, bhaatu Banai̱saaleeli̱ baanakyanu, mutalilengʼo kubatwalikani̱ya kubhi. ");
INSERT INTO tlj_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘Kaakuba munamahanga kedha mu̱ghenu̱ wa bwile bukee oghu aakaaye naanu afooka muguudha kandi omui mu Banai̱saaleeli̱ baanakyanu aba munaku kandi eeghu̱li̱ya ewaa munamahanga oghu aakaaye naanu kedha aba omui mu bantu baa ntu̱la ya muntu oghu, ");
INSERT INTO tlj_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","haanu̱ma ya muntu oghu kweghu̱li̱ya, omui haa baghenji̱ be boonini ali na bughabe bwa kumucungula. ");
INSERT INTO tlj_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Muto wa ese wee kedha mu̱ghenji̱ wee kedha omui haa bantu baa ntu̱la yee boonini akugubha kumucungula, kedha naabaaye muguudha akugubha kwecungula eenini. ");
INSERT INTO tlj_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Eye na oghu alimaghula bali na kubala bwile ku̱lu̱gha eeghu̱li̱i̱ye ku̱hi̱ka haa mwaka ghwa bughabe. Muhendo ghwa kumucungula ghuli na kusighikila haa muhendo bakusasulagha mu̱koli̱ haabwa myaka eghi. ");
INSERT INTO tlj_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Kaakuba aba anali na myaka ekani̱ye ku̱hi̱ka haa mwaka ghwa bughabe, niikuwo eecungule, ali na kusasula ghusaaye haa muhendo ghwa sente esi baamu̱ghu̱li̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Kaakuba aba ati̱ghaaye myaka nkee ku̱hi̱ka haa mwaka ghwa bughabe, abaliilile na mukama wee, naasighikila haa myaka eghi anati̱ghaai̱ye kukola ku̱hi̱ka haa mwaka ghwa ki̱ghenu̱ eki kandi asasulaghe sente sya myaka eghi eti̱ghaaye kwecungula. ");
INSERT INTO tlj_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Munamahanga ali na kumutwalikani̱ya nga mu̱koli̱ apangi̱si̱i̱ye bu̱li̱ mwaka. Mutasi̱i̱mi̱lani̱ya munamahanga oghu kukola kubhi Munai̱saaleeli̱ muunakyanu. ");
INSERT INTO tlj_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Nankabha asaaghuwa kwecungula mu milingo eghi yoona, mu mwaka ghwa kukola ki̱ghenu̱ eki, mukama wee ali na kumuha bughabe kughenda na baana be. ");
INSERT INTO tlj_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Banai̱saaleeli̱ ni bantu banje kandi baheeleli̱ya banje aba naahi̱ye mu nsi ya Mi̱si̱li̱. Ni̱i̱si̱ye Mukama Luhanga waanu.’ ” ");
INSERT INTO tlj_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Mukama aaghila ati, “Mutalyekolela bisasani̱ bya baaluhanga kedha kusimba mpaghi sya mabaale kedha bisasani̱ bya mabaale mu nsi yaanu, mutali̱teeleli̱ya bintu ebi kubilami̱ya. Ni̱i̱si̱ye Mukama Luhanga waanu. ");
INSERT INTO tlj_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“Mu̱hu̱ti̱yaghe kilo kyanje kya Sabhato na ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye kyanje. Ni̱i̱si̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Kaakuba mukwamilila bilaghilo byanje kandi mweghendeseleja kukwata ebi nkubalaghila, ");
INSERT INTO tlj_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","nkuleka mbu̱la etoone mu nsi yaanu mu bwile bwayʼo, nsi eghi ekweli̱ya bilimuwa kandi biti bikwanʼo bi̱ghu̱ma. ");
INSERT INTO tlj_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Mukukesa bilimuwa bikani̱ye ku̱hi̱ki̱ya haa bwile bwa kukobha mi̱jaabbi̱i̱bbu̱ kandi kukobha mi̱jaabbi̱i̱bbu̱ kukweyongela ku̱hi̱ki̱ya haa kuhela nsigho. Mukuliya byokuliya byona ebi mukubbala kandi muukale kusemeeye mu nsi yaanu. ");
INSERT INTO tlj_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“Nkubaha bu̱si̱nge mu nsi eghi, mukulangaala kandi mughwesaghile hataliyo muntu oghu akuboobahi̱i̱li̱li̱ya. Nkuuya mu nsi yaanu binyama bya kabhi bya mu kisaka ebikwitagha kandi taakubaamu bulemo bwona. ");
INSERT INTO tlj_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Mukubhinga ngi̱ghu̱ syanu kandi mubaate na kihiyo. ");
INSERT INTO tlj_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Bantu bataano mu enu̱we balabhingagha ki̱ku̱mi̱ kandi ki̱ku̱mi̱ balabhingagha bantu mutwalo ghumui baa ngi̱ghu̱ syanu kandi mukubaata boona na kihiyo. ");
INSERT INTO tlj_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Nkughilila enu̱we kisa, nkuleka mu̱byale baana bakani̱ye kandi mukane, nkulinda ndaghaano eghi naakoli̱ye naanu. ");
INSERT INTO tlj_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Mukuba nimunaliya bilimuwa ebi mwabi̱i̱ki̱ye mu mwaka ghuhooye kandi mulabiiyagha mu sitoowa syanu niikuwo mutunge mwanya ghwa kutaamu ebi mwakesi̱ye buhyaka. ");
INSERT INTO tlj_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Nkuukala naanu kandi tankubalu̱ghʼo. ");
INSERT INTO tlj_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ndaghendagha naanu, nkuba Luhanga waanu kandi mukuba bantu banje. ");
INSERT INTO tlj_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ni̱i̱si̱ye Mukama Luhanga waanu oghu akabaaya mu nsi ya Mi̱si̱li̱, niikuwo mutatodha kuba basyana baa Banami̱si̱li̱. Nkabaaya mu kubona-bona mwabaaghamu kandi naaleka mwalubhatanga mu̱gu̱mi̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“Kaakuba mubhenga ku̱nji̱ghu̱wa kandi kukwata bilaghilo byanje byona, nkubafubila. ");
INSERT INTO tlj_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","Kaakuba mubhenga ebi nkubalaghila, mughaya ntu̱wamu syanje, musaaghuwa kukwata ebi nkubalaghila byona kandi mu̱tu̱wa ndaghaano yanje, ");
INSERT INTO tlj_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","nkubakolʼo bini: nkubaleetʼo bintu bya kabhi, ndwala esitaakukila, mu̱swi̱ja oghukubaaghala maaso kandi mukwoloba kwonini. Mukuhela nsigho bhaatu ngi̱ghu̱ syanu niisiyo sikuliya bilimuwa byanu. ");
INSERT INTO tlj_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Nkufubila enu̱we kandi ngi̱ghu̱ syanu sikubasi̱ngu̱la, aboohi̱ye enu̱we niibo bakubalema kandi mulali̱gi̱tagha muntu nʼomui atakwete kubahuma. ");
INSERT INTO tlj_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Kaakuba mubhenga ku̱nji̱ghu̱wa haanu̱ma ya kubakolʼo ebi byona, nkubafubila milundi musanju̱ kusaali̱ya haala haabwa bibhi byanu. ");
INSERT INTO tlj_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Nkubamalamu kwepanka kwanu kwa butaaghu̱wa, mbu̱la teekutodha kutoona ku̱lu̱gha mu mwanya, nsi yaanu ekwoma kandi yoomiile nga kyoma. ");
INSERT INTO tlj_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Maani̱ ghaanu ghaa kukola ghaku̱kwi̱la busa, nanga nsi yaanu teekweli̱ya bilimuwa kandi biti tabikwanʼo bi̱ghu̱ma. ");
INSERT INTO tlj_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Kaakuba mweyongela kukola ebi ntabbali̱ye kandi kubhenga ku̱nji̱ghu̱wa, nkweyongela kubafubila milundi musanju̱ kusaali̱ya haala haabwa bibhi byanu. ");
INSERT INTO tlj_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Nkubatumila binyama bya mu kisaka, bikwita baana baanu, bi̱ku̱hwelekeeleli̱ya bisolo byanu, mu̱ku̱ti̱ghala bakee kandi nguudhe syanu si̱ku̱ku̱wa. ");
INSERT INTO tlj_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Bhaatu haanu̱ma ya bifubilo ebi byona, kaakuba muukala munabhengi̱ye ku̱nji̱ghu̱wa kandi mweyongela kukola ebi ntabbali̱ye, ");
INSERT INTO tlj_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","nanje nkukola ebi mutabbali̱ye kandi nkubafubila milundi musanju̱ kusaali̱yʼo haabwa bibhi byanu. ");
INSERT INTO tlj_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Nkubaleetamu bulemo nkuhoola ngi̱ghu̱ haabwa ku̱tu̱wa ndaghaano yanje. Kaakuba mughenda kwekumaani̱li̱ya mu bibugha byanu, nkubasindikila bifubilo bya ndwala kandi nkubahaayʼo mu mikono ya ngi̱ghu̱ syanu. ");
INSERT INTO tlj_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Nku̱keei̱ya byokuliya byanu, bakali̱ eku̱mi̱ balateekelagha mu capu̱li̱ya emui, balaleetagha byokuliya haanu̱ma ya ku̱pi̱i̱ma ebi muntu akuliya, mulaliyagha byokuliya bhaatu tamulaakutagha. ");
INSERT INTO tlj_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Kaakuba mubona ebi byona, bhaatu mubhenga ku̱nji̱ghu̱wa kandi mweyongela kukola ebi ntabbali̱ye, ");
INSERT INTO tlj_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","nanje nkukola ebi mutabbali̱ye, nkusaaliluwa kwonini naanu kandi nkubafubila milundi musanju̱ haabwa bibhi byanu. ");
INSERT INTO tlj_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Njala ekuleka muliye batabani̱ baanu na bahala baanu. ");
INSERT INTO tlj_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Nku̱hwelekeeli̱ya bi̱i̱kalo bya haagu̱u̱li̱ ya bwena hambali mukulami̱li̱yagha baaluhanga baanu. Nkujombakaka byakuhongelʼo bihonguwa byanu hambali mu̱ku̱tu̱mi̱kagha bubbani̱. Mi̱ku̱ yaanu nkughituuma haagu̱u̱li̱ ya bisasani̱ bya baaluhanga baanu kandi nkwoha enu̱we. ");
INSERT INTO tlj_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Nku̱hwelekeeleli̱ya bibugha byanu, nkugenga hansi bi̱i̱kalo hambali mukulami̱li̱yagha baaluhanga baanu kandi tanku̱si̱i̱ma bihonguwa byanu bisasi̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Nku̱hwelekeeleli̱ya kwonini nsi yaanu kandi ngi̱ghu̱ syanu abaakaayemu bakusweka. ");
INSERT INTO tlj_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Nkubaleetamu bulemo, ngi̱ghu̱ syanu sikubaata na kihiyo kandi nkulalangi̱ya enu̱we mu mahanga ghanji. Nku̱hwelekeeleli̱ya bibugha byanu kandi nsi yaanu ekifooka elungu. ");
INSERT INTO tlj_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Haanu̱ma yʼeki kubʼo, enu̱we munali mu mahanga ghaa ngi̱ghu̱ syanu, nsi yaanu ekutunga bilo bya Sabhato bya kuhuumula ngoku mwangughilekagha ehuumula haa bu̱li̱ mwaka ghwamusanju̱. ");
INSERT INTO tlj_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Bwile obu nsi ekumala etalimu muntu, ekutunga kuhuumula kwamaani̱ oku yaabaagha etakatu̱ngi̱ye mu bilo bya Sabhato enu̱we munaakaayemu. ");
INSERT INTO tlj_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ ‘Bamui mu enu̱we abakuba bati̱ghaayʼo kandi balalangiiye mu mahanga ghaa ngi̱ghu̱ syabo bakwobahila kimui, elaka lya kibabi mpwegha eku̱hu̱ngi̱ya lilalekagha bali̱gi̱te. Mulali̱gi̱tagha nga bantu bakwete kuuluka kihiyo kandi muleegengagha muntu ataakubahuma. ");
INSERT INTO tlj_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Muntu alakobhokagha muunakiye nga bantu bakwete kuuluka kihiyo, nankabha hataliyo oghu akwete kubahuma. Nahabweki tamukugubha kulwana na ngi̱ghu̱ syanu. ");
INSERT INTO tlj_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Mu̱ku̱kwi̱la mu mahanga ghanji kandi bantu bʼomu nsi sya ngi̱ghu̱ syanu baku̱hwelekeeleli̱ya enu̱we. ");
INSERT INTO tlj_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Bakee mu enu̱we abakuba bati̱ghaayʼo mu nsi ya ngi̱ghu̱ syanu, bakuhwelekeelela haabwa bibhi byanu na bibhi bya baataata baanu. ");
INSERT INTO tlj_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ ‘Kaakuba bantu aba baatula bibhi byabo na ebi baataata baabo baakoli̱ye haabwa kubhenga ku̱nji̱ghu̱wa kandi kukola ebi ntabbali̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Bintu ebi niibiyo byaleki̱ye naasaaliluwa na Banai̱saaleeli̱ kandi naabalalangi̱ya mu nsi sya ngi̱ghu̱ syabo. Bhaatu kaakuba Banai̱saaleeli̱ baba badhooti̱, baleka kuba na mitima yoomakakaane kandi basi̱i̱ma kufubiluwa haabwa bibhi byabo, ");
INSERT INTO tlj_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","nkuusuka ndaghaano yanje eghi naakoli̱ye na Yakobbo kandi ndaghaano yanje eghi naakoli̱ye na I̱saka kandi ndaghaano yanje eghi naakoli̱ye na Ebbulahi̱mu̱ kandi nkuusuka nsi eghi. ");
INSERT INTO tlj_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Banai̱saaleeli̱ baku̱lu̱gha mu nsi eghi, eti̱ghale etalimu muntu kandi etunge bilo bya Sabhato bya kuhuumula. Bantu aba bakusasula haabwa bibhi byabo haabwa kubhenga bilaghilo byanje kandi kughaya ebi naalaghiiye. ");
INSERT INTO tlj_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Bhaatu eki kikaakubʼo, obu bakuba babatwete kandi banali mu nsi sya ngi̱ghu̱ syabo, tankubhenga Banai̱saaleeli̱ aba kedha kubooha kedha kubahwelekeeleli̱ya. Tankuleka ndaghaano eghi naakoli̱ye na bantu aba. Ni̱i̱si̱ye Mukama Luhanga wabo. ");
INSERT INTO tlj_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Haabwa Banai̱saaleeli̱ aba, nkuusuka ndaghaano eghi naakoli̱ye na baataata baabo aba naahi̱ye mu nsi ya Mi̱si̱li̱, bantu bʼomu mahanga ghanji banaloli̱ye kandi kuba Luhanga wa Banai̱saaleeli̱ aba. Ni̱i̱si̱ye Mukama.’ ” ");
INSERT INTO tlj_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ebi niibiyo bilaghilo, ntu̱wamu na ndaghikiililo ebi Mukama aahaaye Musa haa mwena Si̱naai̱ haabwa Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Oghile Banai̱saaleeli̱ oti, ‘Kaakuba muntu alahila kuhaayo muntu onji ewaa Mukama, muntu oghu ali na kuba na bughabe haanu̱ma ya kusasula muhendo ghwa sente. ");
INSERT INTO tlj_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Musaasa oghu ali na myaka maku̱mi̱ abili ku̱hi̱ki̱ya haa myaka nkaagha ya bukulu, bamusasuulilaghe bi̱twi̱ke maku̱mi̱ ataano bya siliva, kusighikila haa ki̱pi̱i̱mo kya mu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye ");
INSERT INTO tlj_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","kandi muntu oghu naabaaye ali mukali̱, bamusasuulilaghe bi̱twi̱ke maku̱mi̱ asatu bya siliva. ");
INSERT INTO tlj_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Kaakuba aba ali mwana wabusaasa oghu ali na myaka etaano ku̱hi̱ki̱ya haa myaka maku̱mi̱ abili ya bukulu, bamusasuulilaghe bi̱twi̱ke maku̱mi̱ abili bya siliva kandi wabukali̱ bi̱twi̱ke eku̱mi̱ bya siliva. ");
INSERT INTO tlj_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Kaakuba mwana wabusaasa aba ali haagati ya kweli̱ kumui na myaka etaano ya bukulu, bamusasuulilaghe bi̱twi̱ke bitaano bya siliva kandi wabukali̱ bi̱twi̱ke bisatu bya siliva. ");
INSERT INTO tlj_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Kaakuba musaasa oghu aba ali na myaka nkaagha ya bukulu na kusaalʼo, bamusasuulilaghe bi̱twi̱ke eku̱mi̱ na bitaano bya siliva kandi naabaaye ali wabukali̱ bamusasuulilaghe bi̱twi̱ke eku̱mi̱ bya siliva. ");
INSERT INTO tlj_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Kaakuba muntu oghu aalahiiye aba ali munaku kandi ataakugubha kusasula muhendo oghu baataayʼo, aghende ewaa mu̱hongi̱ kandi mu̱hongi̱ amughambile muhendo, naasighikila ngoku muntu oghu akugubha kusasula. ");
INSERT INTO tlj_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘Kaakuba muntu aalahila kuhaayo kisolo nga kihonguwa ewaa Mukama, kisolo eki kikufooka ki̱hi̱ki̱li̱i̱ye ewaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Kisolo kisemeeye atakihingamu kisolo ki̱bhi̱i̱hi̱ye kandi kisolo ki̱bhi̱i̱hi̱ye atakihingamu kisolo kisemeeye. Kaakuba kisolo eki akihingamu kisolo kinji, byombi bikufooka bi̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Kaakuba kisolo eki muntu aalahiiye kuhaayo kiba eki̱teeli̱ye ewaanu kandi eki bataakugubha kuhongela Mukama, muntu oghu akitwale ewaa mu̱hongi̱. ");
INSERT INTO tlj_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Mu̱hongi̱ atu̱wemu muhendo ghwa kisolo eki, naasighikila haa kusemela kedha kutasemela kwakiyo kandi muhendo oghu aku̱tu̱wamu aaniighuwo baakighula. ");
INSERT INTO tlj_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Kaakuba mukama wa kisolo eki abbala kukicungula, ali na kwongela kimui kyakataano haa muhendo ghwakiyo. ");
INSERT INTO tlj_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘Kaakuba muntu ahayo numba yee nga kintu ki̱hi̱ki̱li̱i̱ye ewaa Mukama, mu̱hongi̱ atu̱wemu muhendo ghwa numba eghi naasighikila haa kusemela kedha kutasemela kwayo kandi muhendo oghu aku̱tu̱wamu aaniighuwo baaghighula. ");
INSERT INTO tlj_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Kaakuba musaasa oghu aahaayeyo numba eghi abbala kughicungula, ali na kwongela kimui kyakataano haa muhendo oghu kandi numba eghi etodhe ebe yee. ");
INSERT INTO tlj_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘Kaakuba muntu ahayo ewaa Mukama ki̱twi̱ke kya kibanja baa ka yee bamuhaaye, mu̱hongi̱ atu̱wemu muhendo ghwakiyo naasighikila haa kukana kwa nsigho eghi bakuhelamu, nsigho ya bbaale niyaabaaye eli ki̱lo maku̱mi̱ abili baghighulaghe bi̱twi̱ke eku̱mi̱ bya siliva. ");
INSERT INTO tlj_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Kaakuba muntu ahayo musili ghuwe mu mwaka ghwa bughabe, muhendo oghu mu̱hongi̱ aatu̱u̱yemu aaniighuwo baaghughula. ");
INSERT INTO tlj_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Kaakuba ahayo musili ghuwe haanu̱ma ya mwaka ghwa ki̱ghenu̱ eki, mu̱hongi̱ abaliilile muhendo ghwa musili oghu naasighikila haa myaka eghi enati̱ghaaye ku̱hi̱ka haa mwaka ghunji ghwa bughabe kandi akeehi̱ye haa muhendo ghwa musili oghu. ");
INSERT INTO tlj_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Kaakuba musaasa oghu aahaayeyo musili oghu abbala kughucungula, ali na kwongelʼo kimui kyakataano kya muhendo oghu kandi musili oghu ghutodhe ghube ghuwe. ");
INSERT INTO tlj_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Bhaatu kaakuba atabbala kucungula musili oghu, kedha aba aghu̱ghu̱li̱i̱ye muntu onji, taakugubha kutodha kughucungula. ");
INSERT INTO tlj_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Kaakuba musili oghu baghucungula mu mwaka ghwa bughabe, ghukufooka musili ghu̱hi̱ki̱li̱i̱ye nga musili bahaayeyo ewaa Mukama kandi ghukuba ghwa bahongi̱. ");
INSERT INTO tlj_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘Kaakuba muntu ahayo ewaa Mukama musili oghu aghu̱li̱ye, oghutali ki̱twi̱ke kya kibanja eki bantu baa ka yee bamuhaaye, ");
INSERT INTO tlj_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","mu̱hongi̱ ali na ku̱tu̱wamu muhendo ghwa musili oghu ku̱hi̱ka haa mwaka ghwa bughabe kandi muntu oghu aaghu̱ghu̱li̱ye aghusasule kilo eki kyonini nga kintu ki̱hi̱ki̱li̱i̱ye ewaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Mu mwaka ghwa bughabe oghu, musili oghu ghuli na kukuukila oghu akaghu̱ghu̱li̱ya, oghu akadu̱bha kuba mukama waghuwo. ");
INSERT INTO tlj_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Muhendo ghwa bu̱li̱ musili, mu̱hongi̱ aaniiye aaghu̱tu̱waagha naasighikila haa ki̱pi̱i̱mo kyomu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘Hatabʼo muntu nʼomui oghu akuhaayo mu̱li̱ghaaso ghwa kisolo, nanga mi̱li̱ghaaso yoona ni ya Mukama. Mi̱li̱ghaaso yoona ya nte, ntaama kedha mbu̱li̱, ni ya Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Mu̱li̱ghaaso ghwa kisolo eki̱teeli̱ye, mukama waghuwo ali na kughucungula haa muhendo oghu mu̱hongi̱ aataayʼo kandi ongelʼo kimui kyakataano kya muhendo oghu. Kaakuba ataghucungula baghu̱ghu̱li̱ye haa muhendo oghu mu̱hongi̱ aatu̱u̱yemu. ");
INSERT INTO tlj_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘Bhaatu taaliyo kintu na kimui eki musaasa aahaayeyo ewaa Mukama, eki bali na ku̱ghu̱li̱ya kedha kucungula, nankabha ali muntu, kisolo kedha musili, nanga kintu kyona eki bahaayeyo ewaa Mukama ki̱hi̱ki̱li̱i̱ye kwonini. ");
INSERT INTO tlj_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Muntu oghu baahaayeyo kuhwelekeelela, taali na kucunguluwa, bhaatu ali na kwitibuwa. ");
INSERT INTO tlj_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘Kimui kyʼeku̱mi̱ kya bu̱li̱ kintu eki̱lu̱ghi̱ye mu nsi eghi, kibe kya bilimuwa byʼomu musili kedha kya bi̱ghu̱ma bya biti, byona ni bya Mukama kandi bi̱hi̱ki̱li̱i̱ye ewaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Kaakuba muntu abbala kucungula bimui haa kimui kyʼeku̱mi̱ eki, ali na kwongelʼo kimui kyakataano kya muhendo ghwa kintu eki. ");
INSERT INTO tlj_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Kimui kyʼeku̱mi̱ kya nte, ntaama kedha mbu̱li̱, kisolo eki mu̱li̱i̱si̱ya wakiyo akutaaghʼo mwi̱gho ghuwe makibala, kikuba kisolo ki̱hi̱ki̱li̱i̱ye ewaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Muntu taali na kukoma mu bisolo ebi ekisemeeye nʼekitasemeeye, kedha ku̱hi̱ngamu kisolo kinji. Kaakuba ahingamu kinji, byombi bi̱hi̱ki̱li̱i̱ye kandi tabili na kucunguluwa.’ ” ");
INSERT INTO tlj_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Ebi niibiyo bilaghilo ebi Mukama aahaaye Musa haa mwena Si̱naai̱ haabwa Banai̱saaleeli̱.");
INSERT INTO tlj_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Mukama aabu̱gha na Musa mu weema ya kusanga-sangaanamu mu elungu lya Si̱naai̱ haa kilo kyʼoku̱du̱bha kya kweli̱ kwakabili kwa mwaka ghwakabili, haanu̱ma ya Banai̱saaleeli̱ ku̱lu̱gha mu nsi ya Mi̱si̱li̱. ");
INSERT INTO tlj_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Aaghila Musa ati, “Obale muhendo ghwona ghwa ki̱bbu̱la kya Banai̱saaleeli̱ kusighikila haa ntu̱la syabo na maka ghaabo. Ohandiike bu̱li̱ li̱i̱na lya musaasa omui haa omui. ");
INSERT INTO tlj_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Uwe na Alooni̱ muli na kubala basaasa boona Banai̱saaleeli̱ abali na myaka maku̱mi̱ abili na kusaalʼo, abakugubha ku̱heeleli̱ya mu mahe. ");
INSERT INTO tlj_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Musaasa omui ku̱lu̱gha mu bu̱li̱ ntu̱la kandi mukulu wa ntu̱la eghi akukoonela enu̱we. ");
INSERT INTO tlj_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Ghani niigho mali̱i̱na ghaa basaasa ku̱lu̱gha mu bu̱li̱ ntu̱la abali na kukoonela enu̱we: Elijuula mutabani̱ wa Sedula ku̱lu̱gha mu ntu̱la ya Leu̱bbeeni̱. ");
INSERT INTO tlj_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Selu̱myeli̱ mutabani̱ wa Yulisadaai̱ ku̱lu̱gha mu ntu̱la ya Si̱mi̱yooni̱. ");
INSERT INTO tlj_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Naasoni̱ mutabani̱ wa Aminadaabbu ku̱lu̱gha mu ntu̱la ya Yu̱da. ");
INSERT INTO tlj_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Netaneeli̱ mutabani̱ wa Juhala ku̱lu̱gha mu ntu̱la ya I̱sakaali. ");
INSERT INTO tlj_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Eli̱yaabbu mutabani̱ wa Heloni̱ ku̱lu̱gha mu ntu̱la ya Jabbu̱looni̱. ");
INSERT INTO tlj_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Eli̱sama mutabani̱ wa Ami̱hu̱di̱ omui haa batabani̱ baa Yojeefu̱ ku̱lu̱gha mu ntu̱la ya Efulahi̱mu̱. Onji akaba ali Gamalyeli̱ mutabani̱ wa Pedajula ku̱lu̱gha mu ntu̱la ya Manase. ");
INSERT INTO tlj_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Abbidaani̱ mutabani̱ wa Gi̱di̱yooni̱ ku̱lu̱gha mu ntu̱la ya Bbenjami̱i̱ni̱. ");
INSERT INTO tlj_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Ahi̱yejeeli̱ mutabani̱ wa Amisadaai̱ ku̱lu̱gha mu ntu̱la ya Daani̱. ");
INSERT INTO tlj_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Pagi̱yeeli̱ mutabani̱ wa Okulaani̱ ku̱lu̱gha mu ntu̱la ya Aseli̱. ");
INSERT INTO tlj_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Eli̱yasaafu mutabani̱ wa Deu̱weli̱ ku̱lu̱gha mu ntu̱la ya Gaadi̱. ");
INSERT INTO tlj_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Ahi̱la mutabani̱ wa Enani̱ ku̱lu̱gha mu ntu̱la ya Nafutaali.” ");
INSERT INTO tlj_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Aba niibo basaasa aba baakomi̱ye mu ki̱bbu̱la kya Banai̱saaleeli̱, beebembeli̱ baa ntu̱la sya baataata baabo. Baaba bakulu baa ntu̱la sya Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Musa na Alooni̱ baabilikila hamui basaasa eku̱mi̱ na babili aba baahaayeyo mali̱i̱na ghaabo ");
INSERT INTO tlj_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","kandi baakumaani̱ya hamui ki̱bbu̱la kyona kya Banai̱saaleeli̱ haa kilo kyʼoku̱du̱bha kya kweli̱ kwakabili. Baahandiika muhendo ghwa basaasa boona abaabaagha bali na myaka maku̱mi̱ abili na kusaalʼo, kusighikila haa ntu̱la syabo na maka ghaabo, ");
INSERT INTO tlj_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","ngoku Mukama aalaghiiye Musa. Musa aabala bantu aba mu elungu lya Si̱naai̱. ");
INSERT INTO tlj_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Muhendo ghwa basaasa ku̱lu̱gha mu ntu̱la ya Leu̱bbeeni̱, mu̱li̱ghaaso ghwa I̱saaleeli̱, abaabaagha na myaka maku̱mi̱ abili na kusaalʼo kandi abakugubha ku̱heeleli̱ya mu mahe, baahandiika mali̱i̱na ghaabo omui haa omui, kusighikila haa ntu̱la syabo na maka ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Muhendo ghwa basaasa ku̱lu̱gha mu ntu̱la ya Leu̱bbeeni̱ ghwaba mitwalo enaa kakaagha na bi̱ku̱mi̱ bitaano. ");
INSERT INTO tlj_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Muhendo ghwa basaasa ku̱lu̱gha mu ntu̱la ya Si̱mi̱yooni̱, abaabaagha na myaka maku̱mi̱ abili na kusaalʼo kandi abakugubha ku̱heeleli̱ya mu mahe, baahandiika mali̱i̱na ghaabo omui haa omui, kusighikila haa ntu̱la syabo na maka ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Muhendo ghwa basaasa ku̱lu̱gha mu ntu̱la ya Si̱mi̱yooni̱ ghwaba mitwalo etaano kenda na bi̱ku̱mi̱ bisatu. ");
INSERT INTO tlj_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Muhendo ghwa basaasa ku̱lu̱gha mu ntu̱la ya Gaadi̱, abaabaagha na myaka maku̱mi̱ abili na kusaalʼo kandi abakugubha ku̱heeleli̱ya mu mahe, baahandiika mali̱i̱na ghaabo omui haa omui, kusighikila haa ntu̱la syabo na maka ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Muhendo ghwa basaasa ku̱lu̱gha mu ntu̱la ya Gaadi̱ ghwaba mitwalo enaa nku̱mi̱ etaano lukaagha na maku̱mi̱ ataano. ");
INSERT INTO tlj_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Muhendo ghwa basaasa ku̱lu̱gha mu ntu̱la ya Yu̱da, abaabaagha na myaka maku̱mi̱ abili na kusaalʼo kandi abakugubha ku̱heeleli̱ya mu mahe, baahandiika mali̱i̱na ghaabo omui haa omui, kusighikila haa ntu̱la syabo na maka ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Muhendo ghwa basaasa ku̱lu̱gha mu ntu̱la ya Yu̱da ghwaba mitwalo musanju̱ nku̱mi̱ enaa na lukaagha. ");
INSERT INTO tlj_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Muhendo ghwa basaasa ku̱lu̱gha mu ntu̱la ya I̱sakaali, abaabaagha bali na myaka maku̱mi̱ abili na kusaalʼo kandi abakugubha ku̱heeleli̱ya mu mahe, baahandiika mali̱i̱na ghaabo omui haa omui, kusighikila haa ntu̱la syabo na maka ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Muhendo ghwa basaasa ku̱lu̱gha mu ntu̱la ya I̱sakaali ghwaba mitwalo etaano nku̱mi̱ enaa na bi̱ku̱mi̱ bbinaa. ");
INSERT INTO tlj_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Muhendo ghwa basaasa ku̱lu̱gha mu ntu̱la ya Jabbu̱looni̱, abaabaagha na myaka maku̱mi̱ abili na kusaalʼo kandi abakugubha ku̱heeleli̱ya mu mahe, baahandiika mali̱i̱na ghaabo omui haa omui, kusighikila haa ntu̱la syabo na maka ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Muhendo ghwa basaasa ku̱lu̱gha mu ntu̱la ya Jabbu̱looni̱ ghwaba mitwalo etaano kasanju̱ na bi̱ku̱mi̱ bbinaa. ");
INSERT INTO tlj_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Muhendo ghwa basaasa ku̱lu̱gha mu ntu̱la ya Yojeefu̱ kandi baasukulu baa Efulahi̱mu̱, abaabaagha na myaka maku̱mi̱ abili na kusaalʼo kandi abakugubha ku̱heeleli̱ya mu mahe, baahandiika mali̱i̱na ghaabo omui haa omui, kusighikila haa ntu̱la syabo na maka ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Muhendo ghwa basaasa ku̱lu̱gha mu ntu̱la ya Efulahi̱mu̱ ghwaba mitwalo enaa na bi̱ku̱mi̱ bitaano. ");
INSERT INTO tlj_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Muhendo ghwa basaasa ku̱lu̱gha mu ntu̱la ya Manase, abaabaagha na myaka maku̱mi̱ abili na kusaalʼo kandi abakugubha ku̱heeleli̱ya mu mahe, baahandiika mali̱i̱na ghaabo omui haa omui, kusighikila haa ntu̱la syabo na maka ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Muhendo ghwa basaasa ku̱lu̱gha mu ntu̱la ya Manase ghwaba mitwalo esatu nku̱mi̱ ebili na bi̱ku̱mi̱ bibili. ");
INSERT INTO tlj_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Muhendo ghwa basaasa ku̱lu̱gha mu ntu̱la ya Bbenjami̱i̱ni̱, abaabaagha na myaka maku̱mi̱ abili na kusaalʼo kandi abakugubha ku̱heeleli̱ya mu mahe, baahandiika mali̱i̱na ghaabo, kusighikila haa ntu̱la syabo na maka ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Muhendo ghwa basaasa ku̱lu̱gha mu ntu̱la ya Bbenjami̱i̱ni̱ ghwaba mitwalo esatu nku̱mi̱ etaano na bi̱ku̱mi̱ bbinaa. ");
INSERT INTO tlj_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Muhendo ghwa basaasa ku̱lu̱gha mu ntu̱la ya Daani̱, abaabaagha na myaka maku̱mi̱ abili na kusaalʼo kandi abakugubha ku̱heeleli̱ya mu mahe, baahandiika mali̱i̱na ghaabo, kusighikila haa ntu̱la syabo na maka ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Muhendo ghwa basaasa ku̱lu̱gha mu ntu̱la ya Daani̱ ghwaba mitwalo mukaagha nku̱mi̱ ebili na lusanju̱. ");
INSERT INTO tlj_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Muhendo ghwa basaasa ku̱lu̱gha mu ntu̱la ya Aseli̱, abaabaagha na myaka maku̱mi̱ abili na kusaalʼo kandi abakugubha ku̱heeleli̱ya mu mahe, baahandiika mali̱i̱na ghaabo, kusighikila haa ntu̱la syabo na maka ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Muhendo ghwa basaasa ku̱lu̱gha mu ntu̱la ya Aseli̱ ghwaba mitwalo enaa lu̱ku̱mi̱ nʼebitaano. ");
INSERT INTO tlj_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Muhendo ghwa basaasa ku̱lu̱gha mu ntu̱la ya Nafutaali, abaabaagha na myaka maku̱mi̱ abili na kusaalʼo kandi abakugubha ku̱heeleli̱ya mu mahe, baahandiika mali̱i̱na ghaabo, kusighikila haa ntu̱la syabo na maka ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Muhendo ghwa basaasa ku̱lu̱gha mu ntu̱la ya Nafutaali, ghwaba mitwalo etaano nku̱mi̱ esatu na bi̱ku̱mi̱ bbinaa. ");
INSERT INTO tlj_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Abaabali̱ye bantu aba ni Musa, Alooni̱ na beebembeli̱ eku̱mi̱ na babili baa Banai̱saaleeli̱, bu̱li̱ omui mu beebembeli̱ aba ali mukulu wa ntu̱la yee. ");
INSERT INTO tlj_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Banai̱saaleeli̱ boona baabusaasa abaabaagha na myaka maku̱mi̱ abili ya bukulu na kusaalʼo kandi abakugubha ku̱heeleli̱ya mu mahe ghaa Banai̱saaleeli̱, baababala kusighikila haa ntu̱la syabo. ");
INSERT INTO tlj_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Muhendo ghwona ghwa basaasa aba ghwaba mitwalo nkaagha nku̱mi̱ esatu bitaano na maku̱mi̱ ataano. ");
INSERT INTO tlj_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Bhaatu basaasa bʼomu ntu̱la ya Leevi̱ tabaababaliiye mu muhendo ghwa Banai̱saaleeli̱ oghu. ");
INSERT INTO tlj_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Mukama akaba naaghi̱li̱ye Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Otabala basaasa bʼomu ntu̱la ya Leevi̱ kedha kubala muhendo ghwabo mu muhendo ghwa Banai̱saaleeli̱ baanakyabo. ");
INSERT INTO tlj_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Bhaatu Baleevi̱ obahe mulimo ghwa ku̱heeleli̱ya haa weema ehi̱ki̱li̱i̱ye eghi elimu sandu̱u̱ku̱ ya ndaghaano, bintu byayo byona na byaku̱koleesi̱yamu byona. Baleevi̱ aba bali na kuheeka weema ehi̱ki̱li̱i̱ye hambali baakaghendi̱ye hoona kandi baaghoonaghe baghyeli̱ghi̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Obu Banai̱saaleeli̱ balabaagha mbalu̱gha hambali baghooneeye, Baleevi̱ bonkaha haaniibo baasakaalulagha weema eghi kandi baghikwelaghe mu ki̱i̱kalo kihyaka hambali mukughenda kughoona. Muntu onji weena oghu akwebinga weema ehi̱ki̱li̱i̱ye eghi ali na kwitibuwa. ");
INSERT INTO tlj_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Banai̱saaleeli̱ banji boona bali na kukwela weema syabo kusighikila haa ntu̱la syabo. Bu̱li̱ musaasa ali na kughoona na bantu bʼomu ntu̱la yee kandi bu̱li̱ ntu̱la eli na kusimba bhendela yayo. ");
INSERT INTO tlj_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Baleevi̱ bali na kukwela weema syabo kweli̱ghi̱i̱li̱li̱ya weema ehi̱ki̱li̱i̱ye, niikuwo Mukama atasaaliluwagha na ki̱bbu̱la kya Banai̱saaleeli̱. Baleevi̱ bali na kuba na mulimo ghwa kuloleelela weema ehi̱ki̱li̱i̱ye.” ");
INSERT INTO tlj_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Banai̱saaleeli̱ baakola byona ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Mukama aaghila Musa na Alooni̱ ati, ");
INSERT INTO tlj_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Banai̱saaleeli̱ bali na kughoona beeli̱ghi̱li̱i̱ye weema ya kusanga-sangaanamu, bhaatu bateebinga haai na weema eghi. Bu̱li̱ musaasa aakale mu ntu̱la yee kandi bu̱li̱ ntu̱la ebe na bhendela yayo.” ");
INSERT INTO tlj_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Bantu baa ntu̱la ya Yu̱da baaghoonaghe haa luhande lwa bu̱lu̱gha ejooba kusighikila haa bhendela sya ntu̱la syabo. Mukulu wa ntu̱la eghi ni Naasoni̱ mutabani̱ wa Aminadaabbu. ");
INSERT INTO tlj_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Mu ntu̱la yee baabalamu basaasa mitwalo musanju̱ nku̱mi̱ enaa na lukaagha. ");
INSERT INTO tlj_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Bantu baa ntu̱la ya I̱sakaali baghoonaghe balabhaane na baa ntu̱la ya Yu̱da. Mukulu wa ntu̱la ya I̱sakaali ni Netaneeli̱ mutabani̱ wa Juhala. ");
INSERT INTO tlj_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Mu ntu̱la yee baabalamu basaasa mitwalo etaano nku̱mi̱ enaa na bi̱ku̱mi̱ bbinaa. ");
INSERT INTO tlj_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Bantu baa ntu̱la ya Jabbu̱looni̱ baghoonaghe balabhaane na baa ntu̱la ya Yu̱da. Mukulu wa ntu̱la ya Jabbu̱looni̱ ni Eli̱yaabbu mutabani̱ wa Heloni̱. ");
INSERT INTO tlj_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Mu ntu̱la yee baabalamu basaasa mitwalo etaano kasanju̱ na bi̱ku̱mi̱ bbinaa. ");
INSERT INTO tlj_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Muhendo ghwa basaasa boona bʼomu bi̱bbu̱la bisatu bya luhande lwa ntu̱la ya Yu̱da, ghwaba mitwalo eku̱mi̱ na munaanaa kakaagha na bi̱ku̱mi̱ bbinaa. Bantu aba baghendaghe bali ki̱bbu̱la kyʼoku̱du̱bha. ");
INSERT INTO tlj_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Bantu baa ntu̱la ya Leu̱bbeeni̱ baghoonaghe haa luhande lwa eku̱wa hansi ya bhendela yabo, kusighikila haa ntu̱la syabo. Mukulu wa ntu̱la ya Leu̱bbeeni̱ ni Elijuula mutabani̱ wa Sedula. ");
INSERT INTO tlj_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Mu ntu̱la yee baabalamu basaasa mitwalo enaa kakaagha na bi̱ku̱mi̱ bitaano. ");
INSERT INTO tlj_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Bantu baa ntu̱la ya Si̱mi̱yooni̱ baghoonaghe balabhaane na baa ntu̱la ya Leu̱bbeeni̱. Mukulu wa ntu̱la ya Si̱mi̱yooni̱ ni Selu̱myeli̱ mutabani̱ wa Yulisadaai̱. ");
INSERT INTO tlj_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Mu ntu̱la yee baabalamu basaasa mitwalo etaano kenda na bi̱ku̱mi̱ bisatu. ");
INSERT INTO tlj_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Bantu baa ntu̱la ya Gaadi̱ baghoonaghe balabhaane na baa ntu̱la ya Leu̱bbeeni̱. Mukulu wa ntu̱la ya Gaadi̱ ni Eli̱yasaafu mutabani̱ wa Leu̱weli̱. ");
INSERT INTO tlj_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Mu ntu̱la yee baabalamu basaasa mitwalo enaa nku̱mi̱ etaano lukaagha na maku̱mi̱ ataano. ");
INSERT INTO tlj_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Muhendo ghwa basaasa boona bʼomu bi̱bbu̱la bisatu bya luhande lwa ntu̱la ya Leu̱bbeeni̱ kusighikila haa ntu̱la syabo, ghwaba mitwalo eku̱mi̱ nʼetaano lu̱ku̱mi̱ bbinaa na maku̱mi̱ ataano. Bantu aba baghendaghe bali ki̱bbu̱la kyakabili. ");
INSERT INTO tlj_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Du̱mbi̱ Baleevi̱ balabhaghʼo kandi baghendaghe baheeki̱ye weema ya kusanga-sangaanamu, bali haagati ya bi̱bbu̱la bibili ebihikiiye na bi̱bbu̱la bibili ebi̱ti̱ghaaye enu̱ma. Bantu baa bu̱li̱ ntu̱la baghendaghe balabhi̱ye oghu aheeki̱ye bhendela yabo. ");
INSERT INTO tlj_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Bantu baa ntu̱la ya Efulahi̱mu̱ baghoonaghe haa luhande lwa bughuwa ejooba kusighikila haa bhendela sya ntu̱la syabo. Mukulu wa ntu̱la ya Efulahi̱mu̱ ni Eli̱sama mutabani̱ wa Ami̱hu̱di̱. ");
INSERT INTO tlj_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Mu ntu̱la yee baabalamu basaasa mitwalo enaa na bi̱ku̱mi̱ bitaano. ");
INSERT INTO tlj_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Bantu baa ntu̱la ya Manase baghoonaghe balabhaane na baa ntu̱la ya Efulahi̱mu̱. Mukulu wa ntu̱la ya Manase ni Gamalyeli̱ mutabani̱ wa Pedajula. ");
INSERT INTO tlj_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Mu ntu̱la yee baabalamu basaasa mitwalo esatu nku̱mi̱ ebili na bi̱ku̱mi̱ bibili. ");
INSERT INTO tlj_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Bantu baa ntu̱la ya Bbenjami̱i̱ni̱ baghoonaghe balabhaane na baa ntu̱la ya Efulahi̱mu̱. Mukulu wa ntu̱la ya Bbenjami̱i̱ni̱ ni Abbidaani̱ mutabani̱ wa Gi̱di̱yooni̱. ");
INSERT INTO tlj_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Mu ntu̱la yee baabalamu basaasa mitwalo esatu nku̱mi̱ etaano na bi̱ku̱mi̱ bbinaa. ");
INSERT INTO tlj_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Muhendo ghwa basaasa boona bʼomu bi̱bbu̱la bisatu bya luhande lwa ntu̱la ya Efulahi̱mu̱, ghwaba mitwalo eku̱mi̱ kanaanaa na ki̱ku̱mi̱. Bantu aba baaghendagha bali ki̱bbu̱la kyakasatu. ");
INSERT INTO tlj_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Bantu baa ntu̱la ya Daani̱ baghoonaghe haa luhande lwa elughulu, kusighikila haa bhendela sya ntu̱la syabo. Mukulu wa ntu̱la ya Daani̱ ni Ahi̱yejeeli̱ mutabani̱ wa Amisadaai̱. ");
INSERT INTO tlj_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Mu ntu̱la yee baabalamu basaasa mitwalo mukaagha nku̱mi̱ ebili na lusanju̱. ");
INSERT INTO tlj_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Bantu baa ntu̱la ya Aseli̱ baghoonaghe balabhaane na baa ntu̱la ya Daani̱. Mukulu wa ntu̱la ya Aseli̱ ni Pagi̱yeeli̱ mutabani̱ wa Okulaani̱. ");
INSERT INTO tlj_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Mu ntu̱la yee baabalamu basaasa mitwalo enaa lu̱ku̱mi̱ na bi̱ku̱mi̱ bitaano. ");
INSERT INTO tlj_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Bantu baa ntu̱la ya Nafutaali baghoonaghe balabhaane na baa ntu̱la ya Daani̱. Mukulu wa ntu̱la ya Nafutaali ni Ahi̱la mutabani̱ waa Enani̱. ");
INSERT INTO tlj_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Mu ntu̱la yee baabalamu basaasa mitwalo etaano nku̱mi̱ esatu na bi̱ku̱mi̱ bbinaa. ");
INSERT INTO tlj_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Muhendo ghwa basaasa boona bʼomu ntu̱la ya Daani̱ kusighikila haa ntu̱la syabo, ghwaba mitwalo eku̱mi̱ nʼetaano kasanju̱ na lukaagha. Bantu aba baghendaghe bati̱ghaaye enu̱ma kandi baamu̱ki̱i̱ye bhendela sya ntu̱la syabo. ");
INSERT INTO tlj_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Musa na abaamukoonelagha baababala basaasa boona baa Banai̱saaleeli̱ abaagubhagha kulwana. Baababala mu bi̱bbu̱la kusighikila haa ntu̱la syabo kandi muhendo ghwabo ghwaba mitwalo nkaagha nku̱mi̱ esatu bitaano na maku̱mi̱ ataano. ");
INSERT INTO tlj_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Bhaatu Baleevi̱ tabaababaliiye mu muhendo ghwa Banai̱saaleeli̱ baanakyabo, ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Banai̱saaleeli̱ baakola byona ngoku Mukama aalaghiiye Musa. Baaghoona kusighikila haa bhendela sya ntu̱la syabo kandi bu̱li̱ muntu aaghendagha na bantu baa ka yee. ");
INSERT INTO tlj_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Bani niibo baasukulu baa Musa na Alooni̱, bwile obu Mukama aabu̱ghi̱ye na Musa haa mwena Si̱naai̱. ");
INSERT INTO tlj_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Ghani niigho mali̱i̱na ghaa batabani̱ baa Alooni̱: Nadaabbu niiye akaba ali mu̱li̱ghaaso ghuwe, aalabhʼo Abbi̱hu̱, Eli̱yeeja na I̱tamala. ");
INSERT INTO tlj_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Agha niigho mali̱i̱na ghaa batabani̱ baa Alooni̱, aba baasi̱i̱ghi̱ye mafu̱ta kandi baabalu̱wi̱ka ku̱heeleli̱ya nga bahongi̱. ");
INSERT INTO tlj_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Bhaatu Nadaabbu na Abbi̱hu̱ baakwi̱la mu maaso ghaa Mukama mu elungu lya Si̱naai̱, haabwa ku̱tu̱mi̱ka mu maaso ghe mulilo atabalaghiiye. Nadaabbu na Abbi̱hu̱ bakaba batali na baana. Nahabweki Eli̱yeeja na I̱tamala baakala mbaheeleli̱ya nga bahongi̱ esebo Alooni̱ anaakaaye. ");
INSERT INTO tlj_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Oleete ntu̱la ya Leevi̱ mu maaso ghaa mu̱hongi̱ Alooni̱, niikuwo bamukoonelaghe. ");
INSERT INTO tlj_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Bali na ku̱heeleli̱ya Alooni̱ na ki̱bbu̱la kyona kya Banai̱saaleeli̱ haa weema ya kusanga-sangaanamu kandi kukola milimo haa weema ehi̱ki̱li̱i̱ye eghi. ");
INSERT INTO tlj_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Bali na kuloleelela bintu byʼomu weema ya kusanga-sangaanamu kandi kukola mulimo mu weema eghi haabwa Banai̱saaleeli̱ boona. ");
INSERT INTO tlj_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Baleevi̱ aba obahe Alooni̱ na batabani̱ be, naamuhaaye kwonini bantu aba ku̱lu̱gha mu Banai̱saaleeli̱ banji. ");
INSERT INTO tlj_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Okome Alooni̱ na batabani̱ be ku̱heeleli̱ya nga bahongi̱. Muntu onji weena oghu akwebinga ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye ali na kwitibuwa.” ");
INSERT INTO tlj_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Mukama aatodha aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Olole, mu Banai̱saaleeli̱ boona naatwete Baleevi̱ mu ki̱i̱kalo kya kutwala bu̱li̱ mwana wabusaasa mu̱li̱ghaaso ghwa Banai̱saaleeli̱ aba. Baleevi̱ ni bantu banje, ");
INSERT INTO tlj_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","nanga mi̱li̱ghaaso yoona yabusaasa ni yanje. Obu naati̱ye mi̱li̱ghaaso yoona ya Banami̱si̱li̱, nkakomamu baana baabusaasa mi̱li̱ghaaso ya Banai̱saaleeli̱ kuba banje. Mi̱li̱ghaaso yoona yabusaasa ya bisolo na bantu ni byanje. Ni̱i̱si̱ye Mukama.” ");
INSERT INTO tlj_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Mukama aaghila Musa mu elungu lya Si̱naai̱ ati, ");
INSERT INTO tlj_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Obale Baleevi̱ boona kusighikila haa ntu̱la syabo na maka ghaabo. Obale bu̱li̱ mwana wabusaasa oghu ali na kweli̱ kumui na kusaalʼo.” ");
INSERT INTO tlj_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Nahabweki Musa aabala Baleevi̱ aba, ngoku Mukama aamulaghiiye. ");
INSERT INTO tlj_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Ghani niigho mali̱i̱na ghaa batabani̱ baa Leevi̱: Geli̱sooni̱, Kohati̱ na Melaali̱. ");
INSERT INTO tlj_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Ghani niigho mali̱i̱na ghaa batabani̱ baa Geli̱sooni̱ kusighikila haa ntu̱la syabo: Li̱bbi̱ni̱ na Si̱meeyi̱. ");
INSERT INTO tlj_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Ghani niigho mali̱i̱na ghaa batabani̱ baa Kohati̱ kusighikila haa ntu̱la syabo: Amulaamu, I̱jali̱, Hebbu̱looni̱ na U̱jeeli̱. ");
INSERT INTO tlj_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Ghani niigho mali̱i̱na ghaa batabani̱ baa Melaali̱ kusighikila haa ntu̱la syabo: Mahi̱li̱ na Mu̱si̱. Esi niisiyo ntu̱la sya Baleevi̱ kusighikila haa baataata baabo. ");
INSERT INTO tlj_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Ntu̱la sya Bageli̱sooni̱ syalu̱gha mu batabani̱ be babili, Li̱bbi̱ni̱ na Si̱meeyi̱. ");
INSERT INTO tlj_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Muhendo ghwa baana baabusaasa aba baabali̱ye mu ntu̱la ya Li̱bbi̱ni̱ na Si̱meeyi̱ abaabaagha na kweli̱ kumui na kusaalʼo ghwaba kasanju̱ na bi̱ku̱mi̱ bitaano. ");
INSERT INTO tlj_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Ntu̱la ya Bageli̱sooni̱ eghoonaghe luhande lwa bughuwa ejooba enu̱ma sya weema ehi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Mukulu wa ntu̱la ya Bageli̱sooni̱ akaba ali Eli̱yasaafu mutabani̱ wa Lai̱li̱. ");
INSERT INTO tlj_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Mulimo oghu bantu bʼomu ntu̱la ya Bageli̱sooni̱ baakolagha haa weema ya kusanga-sangaanamu, ghukaba ghuli ghwa kuloleelela weema ehi̱ki̱li̱i̱ye, byaku̱swi̱ki̱la haagu̱u̱li̱ yayo, kateni̱ ya kuta haa mulyango ghwa weema ehi̱ki̱li̱i̱ye, ");
INSERT INTO tlj_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","kateni̱ sya kuta haa lugho lwa jighati̱, kateni̱ sya kuta haa geeti̱ ya lugho olweli̱ghi̱li̱i̱ye weema ehi̱ki̱li̱i̱ye, kyakuhongelʼo bihonguwa, mighuwo na milimo yoona eghi ekwetʼo ku̱koleesi̱ya bintu ebi byona. ");
INSERT INTO tlj_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Mu baasukulu baa Kohati̱ haalu̱ghamu ntu̱la ya Amulaamu, ya I̱jali̱, ya Hebbu̱looni̱ na U̱jeeli̱. Esi niisiyo ntu̱la enaa sya baasukulu baa Kohati̱. ");
INSERT INTO tlj_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Muhendo ghwa baana baabusaasa abali na kweli̱ kumui na kusaalʼo ghwaba kanaanaa na lukaagha. Mulimo ghwa ntu̱la sya Bakohati̱ ghukaba ghuli kuloleelela bintu byʼomu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Ntu̱la esi syaghoonagha haa luhande lwa eku̱wa lwa weema ehi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Mukulu wa ntu̱la sya Bakohati̱ akaba ali Elijafaani̱ mutabani̱ wa U̱jeeli̱. ");
INSERT INTO tlj_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Mulimo ghwa ntu̱la enaa esi ghukaba ghuli kuloleelela sandu̱u̱ku̱ ya ndaghaano, meeja, kyakutʼo taala, byakuhongelʼo bihonguwa, bintu bya bahongi̱ ku̱koleesi̱ya mu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye, kateni̱ na milimo yoona eghi ekwetʼo ku̱koleesi̱ya bintu ebi. ");
INSERT INTO tlj_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Eli̱yeeja mutabani̱ wa mu̱hongi̱ Alooni̱ niiye akaba ali mwebembeli̱ wa ntu̱la ya Leevi̱. Niiye akaba aloleleeye abaabaagha na bujanaani̱ji̱buwa bwa kulinda Ki̱i̱kalo Ki̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Ntu̱la ebili sya Melaali̱ ni ya Mahi̱li̱ na ya Mu̱si̱. ");
INSERT INTO tlj_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Muhendo ghwa baana baabusaasa abali na kweli̱ kumui na kusaalʼo aba baabali̱ye ghwaba kakaagha na bi̱ku̱mi̱ bibili. ");
INSERT INTO tlj_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Mukulu wa ntu̱la ya Melaali̱ akaba ali Ju̱lyeli̱ mutabani̱ wa Abbiyai̱li̱. Bantu baa ntu̱la ya Melaali̱ bali na kughoona haa luhande lwa elughulu lwa weema ehi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Bantu baa ntu̱la ya Melaali̱ baabaha mulimo ghwa kuloleelela fuleemu sya weema ehi̱ki̱li̱i̱ye, mikiiko yayo, mpaghi, ncuba sya kutaamu mpaghi esi, byaku̱koleesi̱yamu byona na milimo yoona eghi ekwetʼo ku̱koleesi̱ya bintu ebi. ");
INSERT INTO tlj_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Baaloleelagha dhee mpaghi sya kweli̱ghi̱i̱li̱li̱ya mu jighati̱, ncuba sya kutaamu mpaghi esi, nkondo sya mpaghi sya lugho lwa jighati̱ na mighuwo yasiyo. ");
INSERT INTO tlj_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Musa, Alooni̱ na batabani̱ baa Alooni̱, baaghoonagha bu̱lu̱gha ejooba bwa weema ehi̱ki̱li̱i̱ye mu maaso ghaa weema ya kusanga-sangaanamu. Bakaba bali na mulimo ghwa kuloleelela ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye haabwa Banai̱saaleeli̱. Muntu onji weena oghu eebingagha ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye aatibuwagha. ");
INSERT INTO tlj_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Muhendo ghwona ghwa Baleevi̱ oghu Musa na Alooni̱ baabali̱ye, kusighikila haa ntu̱la syabo ngoku Mukama aabalaghiiye, otaayemu baana boona baabusaasa abali na kweli̱ kumui na kusaalʼo, ghwaba mitwalo ebili na nku̱mi̱ ebili. ");
INSERT INTO tlj_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Mukama aaghila Musa ati, “Obale mi̱li̱ghaaso yoona yabusaasa ya Banai̱saaleeli̱ kandi ohandiike bu̱li̱ li̱i̱na lya mwana wabusaasa oghu ali na kweli̱ kumui na kusaalʼo. ");
INSERT INTO tlj_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Mu ki̱i̱kalo kya mi̱li̱ghaaso yoona ya Banai̱saaleeli̱, onkomelemu Baleevi̱ kandi mu ki̱i̱kalo kya mi̱li̱ghaaso yoona ya bisolo bya Banai̱saaleeli̱ onkomelemu bya Baleevi̱. Ni̱i̱si̱ye Mukama.” ");
INSERT INTO tlj_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Nahabweki Musa aabala mi̱li̱ghaaso yoona ya Banai̱saaleeli̱, ngoku Mukama aamulaghiiye. ");
INSERT INTO tlj_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Muhendo ghwa baana baabusaasa mi̱li̱ghaaso abali na kweli̱ kumui na kusaalʼo, aba aahandi̱i̱ki̱ye mali̱i̱na ghaabo, ghwaba mitwalo ebili nku̱mi̱ ebili bi̱ku̱mi̱ bibili nsanju̱ na basatu. ");
INSERT INTO tlj_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Mukama aaghila dhee Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Baleevi̱ bakuba banje kandi bakukuuka mu ki̱i̱kalo kya baana baabusaasa mi̱li̱ghaaso ya Banai̱saaleeli̱. Bisolo bya Baleevi̱ aba bikukuuka mu ki̱i̱kalo kya mi̱li̱ghaaso yabusaasa ya bisolo bya Banai̱saaleeli̱. Ni̱i̱si̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Kucungula baana baabusaasa mi̱li̱ghaaso bi̱ku̱mi̱ bibili nsanju̱ na basatu baa Banai̱saaleeli̱, abasaaye haa muhendo ghwa Baleevi̱, ");
INSERT INTO tlj_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","bu̱li̱ omui bamusasuulile bi̱twi̱ke bitaano bya siliva, kusighikila haa ki̱pi̱i̱mo kyʼomu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Sente esi bantu bakusasula haabwa kucungula mi̱li̱ghaaso ya Banai̱saaleeli̱ abasaaye haa muhendo ghwa Baleevi̱, basihe Alooni̱ na batabani̱ be.” ");
INSERT INTO tlj_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Nahabweki Musa aakumaani̱ya siliva eghi bantu baasasuuye haabwa kucungula baana baabusaasa mi̱li̱ghaaso baa Banai̱saaleeli̱, abasaaye haa muhendo ghwa Baleevi̱. ");
INSERT INTO tlj_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Siliva eghi baakumaani̱i̱ye haabwa baana baabusaasa mi̱li̱ghaaso baa Banai̱saaleeli̱ abasaaye haa muhendo ghwa Baleevi̱ yaaba lu̱ku̱mi̱ na bi̱ku̱mi̱ bisatu nkaagha nʼetaano, kusighikila haa ki̱pi̱i̱mo kyʼomu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Siliva baahaayeyo haabwa kucungula baana baabusaasa aba, Musa aaghiha Alooni̱ na batabani̱ be, ngoku Mukama aamulaghiiye. ");
INSERT INTO tlj_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Mukama aaghila Musa na Alooni̱ ati, ");
INSERT INTO tlj_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Mubale basaasa bʼomu ntu̱la sya Bakohati̱ mu ntu̱la ya Baleevi̱ kusighikila haa ntu̱la syabo. ");
INSERT INTO tlj_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Mubale basaasa boona abali na myaka maku̱mi̱ asatu ku̱hi̱ka haa myaka maku̱mi̱ ataano ya bukulu, abakugubha kukola mulimo ghwa ku̱heeleli̱ya mu weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Mulimo oghu baasukulu baa Kohati̱ balakolagha mu weema ya kusanga-sangaanamu, ni kuloleelela bintu bi̱hi̱ki̱li̱i̱ye kwonini. ");
INSERT INTO tlj_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Obu mulabaagha ni̱mu̱lu̱gha hambali mughooneeye, Alooni̱ na batabani̱ be bataahaghe mu weema ya kusanga-sangaanamu, basu̱ndu̱ki̱yaghe kateni̱ eghi eli mu maaso ghaa sandu̱u̱ku̱ ya ndaghaano kandi baghi̱swi̱ki̱laghe haa sandu̱u̱ku̱ eghi. ");
INSERT INTO tlj_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Du̱mbi̱ bali na kuta haa sandu̱u̱ku̱ eghi lughoye olu̱koleeu̱we mu mpu sya mbu̱li̱, baswi̱ki̱lʼo na lughoye lwa langi̱ ya bbu̱lu̱lu̱ kandi bate mpaghi sya kughiheekelʼo mu mpete syayo. ");
INSERT INTO tlj_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Haagu̱u̱li̱ ya meeja ya kutʼo mugaati̱ ghwa kuhonga, baalʼo lughoye lwa langi̱ ya bbu̱lu̱lu̱ kandi batʼo capu̱li̱ya, bbaaku̱li̱, bibindi na jaaga sya kutaamu kihonguwa kyakunuwa. Bhaatu mugaati̱ ghuli na kuukalʼo bwile bwona. ");
INSERT INTO tlj_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Bintu ebi babi̱swi̱ki̱le na lughoye lwa langi̱ mutuku kandi baswi̱ki̱lʼo na lughoye olu̱koleeu̱we mu mpu sya mbu̱li̱ kandi bate mu meeja eghi mpaghi sya kughiheekelʼo. ");
INSERT INTO tlj_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Bakwate lughoye lwa langi̱ ya bbu̱lu̱lu̱ kandi balu̱swi̱ki̱le haa kyakutʼo taala, taala syakiyo, makaasi, biisaniya, bibindi na bintu byona bya kutaamu mafu̱ta ghaa biti oli̱va. ");
INSERT INTO tlj_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Bali na ku̱swi̱ki̱la kyakutʼo taala, na byaku̱koleesi̱yʼo byona na lughoye olu̱koleeu̱we mu mpu sya mbu̱li̱ kandi babite haa fuleemu sya kubiheekelʼo. ");
INSERT INTO tlj_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Kyakuhongelʼo bihonguwa kya feeja baki̱swi̱ki̱le na lughoye lwa langi̱ ya bbu̱lu̱lu̱, baswi̱ki̱lʼo lughoye olu̱koleeu̱we mu mpu sya mbu̱li̱ kandi batemu mpaghi sya kukiheekelʼo. ");
INSERT INTO tlj_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Bakwete bintu byona ebi baku̱koleesi̱yagha mu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye, babibohe mu lughoye lwa langi̱ ya bbu̱lu̱lu̱, baswi̱ki̱lʼo na lughoye olu̱koleeu̱we mu mpu sya mbu̱li̱ kandi babite haa fuleemu sya kubiheekelʼo. ");
INSERT INTO tlj_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Baaye ki̱bu̱ haa kyakuhongelʼo bihonguwa kya bbu̱looji̱ kandi baalʼo lughoye lwa langi̱ ya papo. ");
INSERT INTO tlj_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Batʼo bintu byakiyo byona ebi baku̱koleesi̱yaghʼo bini: capu̱li̱ya sya ku̱tu̱mi̱kamu mulilo, huuma sya kukwati̱ya nyama, bi̱ti̱i̱yo, biisaniya na bibindi. Baswi̱ki̱le bintu ebi na lughoye olu̱koleeu̱we mu mpu sya mbu̱li̱ kandi batemu mpaghi sya kuheekelʼo kyakuhongelʼo bihonguwa eki. ");
INSERT INTO tlj_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Obu Alooni̱ na batabani̱ be balamalagha ku̱swi̱ki̱la bintu bi̱hi̱ki̱li̱i̱ye ebi, na byona ebi baku̱koleesi̱yagha mu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye kandi Banai̱saaleeli̱ bamali̱ye kweteekani̱ja ku̱lu̱gha hambali baghooneeye, basaasa bʼomu ntu̱la ya Bakohati̱ baasaghe kuheeka bintu ebi. Bhaatu bataku̱ma haa bintu bi̱hi̱ki̱li̱i̱ye ebi. Kaakuba bakola eki baku̱ku̱wa. Ebi niibiyo bintu byʼomu weema ya kusanga-sangaanamu ebi Bakohati̱ bali na kuheeka. ");
INSERT INTO tlj_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Eli̱yeeja mutabani̱ wa mu̱hongi̱ Alooni̱, aaniiye aaloleelelagha mafu̱ta ghaa taala, bubbani̱ busasi̱ye, kihonguwa kya bu̱li̱ ki̱lo kya bilimuwa na mafu̱ta ghaa kusiigha. Eli̱yeeja aaniiye aaloleelelagha weema ehi̱ki̱li̱i̱ye, na bu̱li̱ kintu ekilimu, otaayemu bintu byamu bi̱hi̱ki̱li̱i̱ye byona.” ");
INSERT INTO tlj_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Mukama aaghila Musa na Alooni̱ ati, ");
INSERT INTO tlj_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Mutaleka ntu̱la sya baasukulu baa Kohati̱ nsihwelekeelela mu Baleevi̱. ");
INSERT INTO tlj_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Kini haaliikiyo mwabakolelagha niikuwo baakale bali boomi̱i̱li̱ kandi bataku̱wa kaakuba beebinga bintu bi̱hi̱ki̱li̱i̱ye. Alooni̱ na batabani̱ be bali na kutaaha mu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye kandi bahaaghe bu̱li̱ musaasa wʼomu ntu̱la ya Bakohati̱ mulimo oghu akukola kandi eki akuheeka. ");
INSERT INTO tlj_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Bhaatu Bakohati̱ aba batataahagha mu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye kubona ngoku Baleevi̱ bakwete ku̱swi̱ki̱la bintu bi̱hi̱ki̱li̱i̱ye. Kaakuba bakola eki baku̱ku̱wa.” ");
INSERT INTO tlj_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Obale basaasa bʼomu ntu̱la ya Bageli̱sooni̱ kusighikila haa maka ghaabo na ntu̱la syabo. ");
INSERT INTO tlj_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Ohandiike mali̱i̱na ghaa basaasa boona abali na myaka maku̱mi̱ asatu ku̱hi̱ka haa maku̱mi̱ ataano ya bukulu, abakugubha kukola mulimo ghwa ku̱heeleli̱ya mu weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Ghuni niighuwo mulimo oghu bantu bʼomu ntu̱la ya Bageli̱sooni̱ balakolagha kandi nʼebi balaheekagha: ");
INSERT INTO tlj_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Balaheekagha kateni̱ syʼomu weema ehi̱ki̱li̱i̱ye, weema ya kusanga-sangaanamu, byaku̱ghi̱swi̱ki̱la kandi bya ku̱swi̱ki̱la haagu̱u̱li̱ bya mpu sya mbu̱li̱, kateni̱ sya kuta haa mulyango ghwa weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Baheekaghe dhee kateni̱ syʼomu jighati̱ sya kweli̱ghi̱i̱li̱li̱ya weema ehi̱ki̱li̱i̱ye na kyakuhongelʼo bihonguwa, kateni̱ ya kuta haa geeti̱ ya jighati̱, mighuwo na bintu byona ebi baku̱koleesi̱yagha milimo mu weema eghi. Bageli̱sooni̱ bakolaghe byona ebikwetaaghisibuwa kuloleelela bintu ebi. ");
INSERT INTO tlj_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Alooni̱ na batabani̱ be haaliibo baaghambilagha basaasa bʼomu ntu̱la ya Bageli̱sooni̱ mulimo oghu bali na kukola. Baghambilaghe bantu aba ebi bali na kuheeka kandi milimo enji eghi bali na kukola. ");
INSERT INTO tlj_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Oghu niighuwo mulimo oghu basaasa bʼomu ntu̱la ya Bageli̱sooni̱ balakolagha mu weema ya kusanga-sangaanamu. I̱tamala mutabani̱ wa mu̱hongi̱ Alooni̱ abaaghe mukulu wabo haa mulimo oghu.” ");
INSERT INTO tlj_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Mukama aatodha aaghila Musa ati, “Obale basaasa bʼomu ntu̱la ya Melaali̱ kusighikila haa maka ghaabo na ntu̱la syabo. ");
INSERT INTO tlj_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Ohandiike mali̱i̱na ghaa basaasa boona abali na myaka maku̱mi̱ asatu ku̱hi̱ka haa maku̱mi̱ ataano ya bukulu, abakugubha kukola mulimo ghwa ku̱heeleli̱ya mu weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Ghuni niighuwo mulimo oghu basaasa bʼomu ntu̱la ya Melaali̱ balakolagha mu weema ya kusanga-sangaanamu. Baheekaghe fuleemu sya weema ehi̱ki̱li̱i̱ye, mikiiko yayo, mpaghi syayo, ncuba sya kutaamu mpaghi, ");
INSERT INTO tlj_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","mpaghi sya jighati̱ ya kweli̱ghi̱i̱li̱li̱ya weema eghi, ncuba sya kutaamu mpaghi esi, nkondo sya kukwata mpaghi sya weema eghi, mighuwo na byaku̱ghi̱koleesi̱ya byona. Ohandiike mali̱i̱na ghaa bintu ebi bu̱li̱ musaasa ali na kuheeka. ");
INSERT INTO tlj_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Oghu niighuwo mulimo oghu basaasa bʼomu ntu̱la ya Melaali̱ bali na kukola mu weema ya kusanga-sangaanamu. I̱tamala mutabani̱ wa mu̱hongi̱ Alooni̱ abaaghe mukulu wabo haa mulimo oghu.” ");
INSERT INTO tlj_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Musa, Alooni̱ na beebembeli̱ baa ki̱bbu̱la kya Banai̱saaleeli̱ baabala basaasa bʼomu ntu̱la ya Bakohati̱ kusighikila haa ntu̱la syabo na maka ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Baabala basaasa boona abali na myaka maku̱mi̱ asatu ku̱hi̱ka haa maku̱mi̱ ataano ya bukulu, abakugubha kukola mulimo ghwa ku̱heeleli̱ya mu weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Muhendo ghwa basaasa aba baabali̱ye kusighikila haa ntu̱la syabo ghwaba nku̱mi̱ ebili lusanju̱ na maku̱mi̱ ataano. ");
INSERT INTO tlj_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Oghu niighuwo muhendo ghwa basaasa boona bʼomu ntu̱la ya Bakohati̱ abaaheeleli̱yagha mu weema ya kusanga-sangaanamu. Musa na Alooni̱ baabala basaasa aba, ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Baabala basaasa bʼomu ntu̱la ya Bageli̱sooni̱ kusighikila haa ntu̱la syabo na maka ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Baabala basaasa boona abali na myaka maku̱mi̱ asatu ku̱hi̱ka haa maku̱mi̱ ataano ya bukulu, oghu akugubha kukola mulimo ghwa ku̱heeleli̱ya mu weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Muhendo ghwa basaasa aba baabali̱ye kusighikila haa ntu̱la syabo na maka ghaabo, ghwaba nku̱mi̱ ebili lukaagha na maku̱mi̱ asatu. ");
INSERT INTO tlj_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Oghu niighuwo muhendo ghwa basaasa bʼomu ntu̱la ya Bageli̱sooni̱ abaaheeleli̱yagha mu weema ya kusanga-sangaanamu. Musa na Alooni̱ baabala bantu aba ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Baabala basaasa bʼomu ntu̱la ya Melaali̱ kusighikila haa ntu̱la syabo na maka ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Baabala basaasa boona abali na myaka maku̱mi̱ asatu ku̱hi̱ka haa maku̱mi̱ ataano ya bukulu, abakugubha kukola mulimo ghwa ku̱heeleli̱ya mu weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Muhendo ghwa basaasa aba baabali̱ye kusighikila haa ntu̱la syabo, ghwaba nku̱mi̱ esatu na bi̱ku̱mi̱ bibili. ");
INSERT INTO tlj_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Oghu niighuwo muhendo ghwa basaasa bʼomu ntu̱la sya Melaali̱. Musa na Alooni̱ baabala basaasa aba ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Nahabweki Musa, Alooni̱ na beebembeli̱ baa Banai̱saaleeli̱ baabala basaasa bʼomu ntu̱la ya Leevi̱ kusighikila haa ntu̱la syabo na maka ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Basaasa boona abaabaagha na myaka maku̱mi̱ asatu ku̱hi̱ka haa maku̱mi̱ ataano ya bukulu, abaasi̱ye kukola mulimo ghwa ku̱heeleli̱ya kandi kuheeka weema ya kusanga-sangaanamu, ");
INSERT INTO tlj_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ghwaba kanaanaa bi̱ku̱mi̱ bitaano na kinaanaa. ");
INSERT INTO tlj_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Bu̱li̱ musaasa baamuha mulimo oghu akukola kandi nʼeki akuheeka, ngoku Mukama aalaghiiye Musa. Baabala basaasa aba ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Olaghile Banai̱saaleeli̱ ku̱twesi̱yagha enja ya hambali baghooneeye muntu weena oghu alwaye ntumbi kedha oghu mahu̱nu̱ ghakwete kutuwa mu mubili, kedha oghu aafooki̱ye ateeli̱ye haabwa ku̱ku̱mʼo mu̱ku̱ ghwa muntu. ");
INSERT INTO tlj_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Batwesi̱yaghe hanja ya hambali baghooneeye musaasa kedha mukali̱ oghu ali na ndwala eghi, niikuwo batabhi̱i̱ya hambali baghooneeye haala, nanga niiyo nkuukala na Banai̱saaleeli̱ aba.” ");
INSERT INTO tlj_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Banai̱saaleeli̱ baakola eki. Baatwesi̱ya bantu aba hanja ya hambali Banai̱saaleeli̱ baghooneeye. Baakola eki Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Oghile Banai̱saaleeli̱ oti, ‘Kaakuba musaasa kedha mukali̱ akola kimui haa bibhi ebi bantu bakukolagha kandi abhi̱i̱ya bwesighibwa buwe na Mukama, muntu oghu musango ghu̱mu̱si̱ngi̱ye ");
INSERT INTO tlj_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","kandi ali na kwatula kibhi eki aakoli̱ye. Ali na kusasula muhendo ghuusuuye haabwa eki aasobeei̱ye. Muntu oghu ali na kwongelʼo kimui kyakataano kandi byona abihe oghu aasobeleei̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Bhaatu kaakuba oghu baakoli̱ye kubhi aku̱wa kandi atabʼo lughanda luwe lwonini oghu akutwala nsasu̱li̱ eghi, ebaaghe ya Mukama kandi baghihaaghe mu̱hongi̱, hamui na ntu̱u̱li̱ ya ntaama eghi muntu oghu aahaayeyo nga kihonguwa haabwa mukolo ghwa kughaniluwa bibhi biye. ");
INSERT INTO tlj_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Bihonguwa byona bi̱hi̱ki̱li̱i̱ye ebi Banai̱saaleeli̱ balaleetagha ewaa mu̱hongi̱, bibaaghe bya mu̱hongi̱ oghu. ");
INSERT INTO tlj_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Bihonguwa byona bi̱hi̱ki̱li̱i̱ye ebi balaleetagha ewaa mu̱hongi̱ bibaaghe bya mu̱hongi̱ oghu kandi bu̱li̱ mu̱hongi̱ ali na kubiika bihonguwa bi̱hi̱ki̱li̱i̱ye ebi baamuhaaye.’ ” ");
INSERT INTO tlj_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Oghile Banai̱saaleeli̱ oti, ‘Kaakuba mukali̱ oghu asweuwe afooka oghu atali mwesighibuwa, ");
INSERT INTO tlj_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","haabwa kulangaala na musaasa onji kandi aki̱bi̱sa eba wee kedha muntu onji, mukali̱ oghu eebhi̱i̱hi̱i̱ye nankabha kai̱so atabʼo kandi bataamukwatiiye mu kikoluwa eki. ");
INSERT INTO tlj_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Kaakuba eba wee atandika kweli̱li̱kanʼo kubhi mukali̱ wee oghu ati aakoli̱ye kibhi kedha amuteekelejʼo kubhi kandi mukali̱ oghu atakoli̱ye kintu eki, ");
INSERT INTO tlj_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","musaasa oghu atwale mukali̱ wee oghu ewaa mu̱hongi̱. Atwale dhee ki̱lo emui ya nsyano ya bbaale nga kihonguwa haabwa mukali̱ wee oghu. Kihonguwa eki mu̱hongi̱ atatamu mafu̱ta kedha bubbani̱ nanga ni kihonguwa eki musaasa oghu akwete kweli̱li̱kanʼo kubhi mukali̱ wee aaleeti̱ye, kubbala kumanya mukali̱ oghu akaakuba naakoli̱ye kintu eki. ");
INSERT INTO tlj_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘Mu̱hongi̱ ali na kuleeta mukali̱ oghu kandi amwemi̱li̱li̱ye mu maaso ghaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Du̱mbi̱ mu̱hongi̱ ali na kuta maasi ghahi̱ki̱li̱i̱ye mu jaaga ya ebumba kandi ali na kuuya haa tu̱u̱tu̱ eghi eli hansi mu weema ehi̱ki̱li̱i̱ye, aghite mu maasi agha. ");
INSERT INTO tlj_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Haanu̱ma ya mu̱hongi̱ kwemi̱li̱li̱ya mukali̱ oghu mu maaso ghaa Mukama, alaghile kumusambuula esoke kandi amukwati̱ye mu ngalo kihonguwa kya bilimuwa kya musaasa oghu akwete kweli̱li̱kanʼo kubhi mukali̱ wee aaleeti̱ye. Mu̱hongi̱ oghu aakale anakwete jaaga eghi elimu maasi ghasaaliiye ghaa mukiino.’ ” ");
INSERT INTO tlj_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Du̱mbi̱ mu̱hongi̱ alahi̱li̱ye mukali̱ oghu kandi amughile ati, “Musaasa onji akaakuba ataalangaaye naawe kandi otaasobeei̱ye kwefoola oghu ateeli̱ye onasweuwe bali̱i̱ waawe, maasi ghasaaliiye ghaa mukiino ghani ghatakukolʼo kabhi koona. ");
INSERT INTO tlj_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Bhaatu okaakuba nuwaasobeei̱ye kulangaala na musaasa onji onasweuwe bali̱i̱ waawe kandi weebhi̱i̱ya kulangaala na musaasa onji oghu atali bali̱i̱ waawe” ");
INSERT INTO tlj_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","du̱mbi̱ mu̱hongi̱ ali na kughambila mukali̱ oghu kulahila ngoku mukiino ghuni ghukumubʼo. Ali na kumughila ati, “Mukama akuleka okiinuwe mu bantu baa ewaanu, bakughaye, tooku̱byala mwana kandi aku̱bhi̱mba etundu. ");
INSERT INTO tlj_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Maasi ghaa mukiino ghani, ghakaakukota munda yaawe, ghaku̱ku̱bhi̱mbi̱ya etundu kandi tooku̱byala mwana.” Mukali̱ oghu akuukemu mu̱hongi̱ ati, “Aami̱i̱na, haaliikuwo kyaba.” ");
INSERT INTO tlj_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“Mu̱hongi̱ ahandiike bighambo bya mukiino ebi mu kitabo kandi abinaabi̱yemu bighende mu maasi ghasaaliiye agha. ");
INSERT INTO tlj_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Maasi ghasaaliiye ghaa mukiino agha mu̱hongi̱ ali na kughaha mukali̱ oghu aghanuwe, ghakaakumukota munda, etundu likutandika kumusaalila. ");
INSERT INTO tlj_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Mu̱hongi̱ aaye kihonguwa kya bilimuwa kya musaasa oghu akwete kweli̱li̱kanʼo kubhi mukali̱ wee, mu ngalo sya mukali̱ oghu, aki̱i̱mu̱ki̱ye mu maaso ghaa Mukama kandi akitwale haa kyakuhongelʼo bihonguwa. ");
INSERT INTO tlj_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Du̱mbi̱ mu̱hongi̱ aaye ngalo emui ya nsyano haa kihonguwa kya bilimuwa eki nga kihonguwa kyakuusukilʼo kandi aghyokeli̱ye haa kyakuhongelʼo bihonguwa. Haanu̱ma yʼeki, ahe mukali̱ oghu maasi agha kandi aghanuwe. ");
INSERT INTO tlj_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Mukali̱ oghu akaakuba eebhi̱i̱hi̱i̱ye kandi atali mwesighibuwa ewaa eba wee, akaakunuwa maasi ghasaaliiye ghaa mukiino agha, aku̱bhi̱mba etundu, taaku̱byala baana kandi akukiinuwa mu bantu baa ewaabo. ");
INSERT INTO tlj_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Bhaatu kaakuba mukali̱ oghu aba ataakoli̱ye kintu eki kandi ali oghu eeli̱ye, kabhi takakumubʼo kandi akugubha ku̱byala baana. ");
INSERT INTO tlj_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“Eki niikiyo kilaghilo haa mukali̱ oghu asweuwe oghu aku̱sobi̱ya kandi kwebhi̱i̱ya kulangaala na musaasa onji anasweuwe eba wee, ");
INSERT INTO tlj_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","kedha musaasa eeli̱li̱kana kubhi ati mukali̱ wee aalangaaye na musaasa onji. Mu̱hongi̱ aleke mukali̱ oghu eemilile mu maaso ghaa Mukama kandi mu̱hongi̱ ali na kukola mukolo oghu ngoku bilaghilo bilaghiiye. ");
INSERT INTO tlj_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Musaasa oghu taali na musango, bhaatu mukali̱ wee oghu kaakuba musango ghuba ghu̱mu̱si̱ngi̱ye, ali na kufubiluwa haabwa kibhi eki.” ");
INSERT INTO tlj_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Oghile Banai̱saaleeli̱ oti, ‘Kaakuba musaasa kedha mukali̱ abbala kukola kilahilo kya mbaghani̱ja kya kwehaayo ewaa Mukama, ");
INSERT INTO tlj_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","atalinuwa vi̱i̱ni̱ kedha kyakunuwa kinji kyona ekikutami̱i̱li̱yagha. Atalinuwa kyakunuwa kisaaliiye kya mi̱jaabbi̱i̱bbu̱ kandi kuliya bi̱ghu̱ma bibisi kedha byomi̱ye bya mi̱jaabbi̱i̱bbu̱. ");
INSERT INTO tlj_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Bwile obu akumala aneehaayeyo ewaa Mukama, ataliliya kintu kyona eki̱lu̱ghi̱ye mu mi̱jaabbi̱i̱bbu̱ nankabha nsigho yayo kedha biiyamba byayo. ");
INSERT INTO tlj_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘Bwile bwona obu akumala analahiiye kwehaayo ewaa Mukama, batalimughemba esoke na kaawembo. Ali na kuukala ali oghu ahi̱ki̱li̱i̱ye bwile bwona obu akumala aneehaayeyo ewaa Mukama, aleke esoke liye likule kandi lijambe. ");
INSERT INTO tlj_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Bwile bwona obu muntu oghu akumala aneehaayeyo ewaa Mukama, atalyebinga mu̱ku̱. ");
INSERT INTO tlj_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Nankabha aba ali ese wee, ni̱na wee, mu̱ghenji̱ wee kedha mwani̱na wee, ataku̱mʼo mu̱ku̱ ghwa muntu oghu kwebhi̱i̱ya, nanga esoke lijambi̱ye mu mutuwe ghuwe nkaakulolelʼo ngoku eehaayeyo ewaa Luhanga. ");
INSERT INTO tlj_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Bwile bwona obu ali na kumala aneehaayeyo, ahi̱ki̱li̱i̱ye ewaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ ‘Kaakuba muntu akwi̱la bwangu-bwangu haai na muntu oghu kandi afoola esoke liye kuba eli̱teeli̱ye ewaa Mukama, haa kilo kyamusanju̱ kya kweyeli̱ya bamughembe esoke, niikuwo atodhe afooke oghu eeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Haa kilo kyamunaanaa muntu oghu ali na kuleeta bi̱i̱bbi̱mbo bibili kedha bwana bwa bu̱u̱pi̱i̱so bubili ewaa mu̱hongi̱ haa mulyango ghwa weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Mu̱hongi̱ ali na kuhonga emui haa noni̱ esi nga kihonguwa haabwa kibhi kandi enji nga kihonguwa kyona kyokeei̱ye, niikuwo muntu oghu Mukama amughanile, nanga aasi̱i̱si̱ye kuba haai na mu̱ku̱. Kilo eki kyonini esoke liye likutodha kuba li̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Ali na kulahila buhyaka ngoku aatodhi̱ye kutandika kwehaayo ewaa Mukama kandi ali na kuleeta kyana kya ntaama kya mwaka ghumui nga kihonguwa kya kuuhibuwʼo musango. Bhaatu atabala bilo aadhu̱bhi̱ye kumala ateeli̱ye ewaa Mukama nanga bwile obu akuba eebhi̱i̱hi̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ ‘Kini ni kilaghilo kya muntu oghu eehaayeyo ewaa Mukama haanu̱ma ya bwile buwe kuhuwʼo. Muntu oghu bamuleetaghe haa mulyango ghwa weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Haa mulyango haala, ali na kuhaayo bihonguwa biye ewaa Mukama. Kyana kya ntaama kya mwaka ghumui kandi ekitali na kamogo, kuba kihonguwa kyona kyokeei̱ye, ntaama yabukali̱ ya mwaka ghumui eghi etali na kamogo, kuba kihonguwa haabwa kibhi kandi ntu̱u̱li̱ ya ntaama eghi etali na kamogo, kuba kihonguwa kya bu̱si̱nge. ");
INSERT INTO tlj_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Ali na kuleeta dhee kighegha kya migaati̱ etalimu ki̱tu̱mbi̱so, keeki̱ esi̱teeki̱ye na mafu̱ta kandi nsyano esemeeye na capati esi̱si̱i̱ghi̱yʼo mafu̱ta. Ali na kuleeta kihonguwa kya bilimuwa na bihonguwa byakunuwa. ");
INSERT INTO tlj_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ ‘Mu̱hongi̱ ali na kubitwala mu maaso ghaa Mukama kandi ahonge kihonguwa haabwa kibhi na kihonguwa kyona kyokeei̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Mu̱hongi̱ oghu ali na kuhonga ewaa Mukama kighegha kya migaati̱ etalimu ki̱tu̱mbi̱so, ntu̱u̱li̱ ya ntaama nga kihonguwa kya bu̱si̱nge, kihonguwa kya bilimuwa na kihonguwa kyakunuwa. ");
INSERT INTO tlj_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“ ‘Oghu eehaayeyo ewaa Mukama, bali na kumughemba esoke lyona mu mutuwe, haa mulyango ghwa weema ya kusanga-sangaanamu. Ali na kukwata esoke eli kandi alite mu mulilo hambali mu̱hongi̱ ahongeeye kihonguwa kya bu̱si̱nge. ");
INSERT INTO tlj_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ ‘Haanu̱ma ya kughemba esoke lya oghu eehaayeyo ewaa Mukama, mu̱hongi̱ ali na kuuya mu kighegha nyama ya ebhango eghi eteeki̱ye ya ntu̱u̱li̱ ya ntaama, mugaati̱ ghutalimu ki̱tu̱mbi̱so na capati eghi etalimu ki̱tu̱mbi̱so kandi abikwati̱ye muntu oghu mu ngalo. ");
INSERT INTO tlj_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Mu̱hongi̱ aamu̱ki̱ye bintu ebi ewaa Mukama, nga kihonguwa eki baamu̱ki̱i̱ye, mbanda na kibelo, byona bikufooka bi̱hi̱ki̱li̱i̱ye kandi ni bya mu̱hongi̱. Haanu̱ma yʼeki oghu aabaagha eehaayeyo akugubha kunuwa vi̱i̱ni̱. ");
INSERT INTO tlj_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ ‘Kini niikiyo kilaghilo kya oghu eehaayeyo ewaa Mukama kandi oghu aalahiiye kuhaayo kihonguwa kiye haabwa kwehaayo kuwe. Akugubha kuleeta dhee bihonguwa binji, bhaatu ali na ku̱u̱su̱li̱i̱si̱ya eki aalahiiye kuhaayo kusighikila haa kilaghilo kya muntu oghu eehaayeyo.’ ” ");
INSERT INTO tlj_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Oghambile Alooni̱ na batabani̱ be bighambo bini ebi balabu̱ghagha mbaha Banai̱saaleeli̱ mu̱gi̱sa. Baghilaghe bati, ");
INSERT INTO tlj_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘Mukama akuhe mu̱gi̱sa kandi akulinde. ");
INSERT INTO tlj_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Mukama akulole na maaso ghe adheedheeu̱we kandi akughilile ngughuma. ");
INSERT INTO tlj_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Mukama akulole kandi akuhe mpempa.’ ” ");
INSERT INTO tlj_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Kaakuba Alooni̱ na batabani̱ be baha mu̱gi̱sa Banai̱saaleeli̱ mu li̱i̱na lyanje, nkuha Banai̱saaleeli̱ aba mu̱gi̱sa.” ");
INSERT INTO tlj_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Obu Musa aamali̱ye kukwela weema ehi̱ki̱li̱i̱ye, naaghisiigha mafu̱ta ghaa ku̱ghyeli̱ya kandi kweli̱ya bintu byayo byona, aasiigha dhee mafu̱ta kyakuhongelʼo bihonguwa ku̱kyeli̱ya na byaku̱koleesi̱yʼo byona. ");
INSERT INTO tlj_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Du̱mbi̱ beebembeli̱ eku̱mi̱ na babili baa ntu̱la eku̱mi̱ nʼebili baa ntu̱la sya I̱saaleeli̱, baaleeta bihonguwa byabo haa weema ehi̱ki̱li̱i̱ye eghi. Basaasa aba ni beebembeli̱ abaakooneeye Musa na Alooni̱ kubala Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Bini niibiyo bihonguwa ebi baaleeti̱ye mu maaso ghaa Mukama, nte eku̱mi̱ nʼebili kandi bu̱li̱ mwebembeli̱ aaleeta nte emui, bigaali̱ mukaagha kandi bu̱li̱ beebembeli̱ babili baaleeta kigaali̱ kimui. Baabihaayo mu maaso ghaa weema ehi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Osi̱i̱me bihonguwa byabo ebi, niikuwo bantu babi̱koleesi̱ye mulimo haa weema ya kusanga-sangaanamu. Obihe Baleevi̱ babi̱koleesi̱ye kusighikila haa mulimo oghu muntu akwete kukola.” ");
INSERT INTO tlj_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Nahabweki Musa aakwata bigaali̱ ebi na nte esi kandi aabiha Baleevi̱. ");
INSERT INTO tlj_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Aaha ntu̱la ya Bageli̱sooni̱ bigaali̱ bibili na nte enaa, kusighikila haa mulimo ghwabo. ");
INSERT INTO tlj_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Aaha ntu̱la ya Melaali̱ bigaali̱ bbinaa na nte munaanaa, kusighikila haa mulimo ghwabo. Bantu aba boona oghu aabaloleelelagha haa mulimo ni I̱tamala mutabani̱ wa mu̱hongi̱ Alooni̱. ");
INSERT INTO tlj_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Bhaatu Musa taahaaye Bakohati̱ haa bintu ebi, nanga mulimo ghwabo ghukaba ghuli kuheeka bintu bi̱hi̱ki̱li̱i̱ye haa mabegha ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Obu Musa aasi̱i̱ghi̱ye mafu̱ta haa kyakuhongelʼo bihonguwa, beebembeli̱ baa Banai̱saaleeli̱ baaleeta bihonguwa byabo haabwa kukihaayo kandi baabita mu maaso ghaa kyakuhongelʼo bihonguwa eki. ");
INSERT INTO tlj_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Mukama aaghila Musa ati, “Bu̱li̱ kilo, mwebembeli̱ omui ahaagheyo kihonguwa kiye haabwa kuhaayo kyakuhongelʼo bihonguwa.” ");
INSERT INTO tlj_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Haa kilo kyʼoku̱du̱bha Naasoni̱ mutabani̱ wa Aminadaabbu, mwebembeli̱ wa ntu̱la ya Yu̱da aaleeta kihonguwa kiye. ");
INSERT INTO tlj_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Bini niibiyo aaleeti̱ye: sahaani̱ emui ya siliva ku̱lyota kwayo ki̱lo emui nʼeki̱twi̱ke, bbaaku̱li̱ emui ya siliva ku̱lyota kwayo gulaamu lunaanaa, kusighikila haa ki̱pi̱i̱mo kyʼomu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. Bu̱li̱ emui ekaba elimu nsyano esemeeye, eghi etabuuyemu mafu̱ta ghaa biti oli̱va, kuba kihonguwa kya bilimuwa. ");
INSERT INTO tlj_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Aaleeta kaasaniya kamui kaanabwana kaa feeja ku̱lyota kwakʼo gulaamu ki̱ku̱mi̱ nʼeku̱mi̱, akaasuuyʼo bubbani̱, ");
INSERT INTO tlj_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ntu̱u̱li̱ ya nte emui, ntu̱u̱li̱ ya ntaama emui na kyana kya ntaama kimui kyabusaasa kya mwaka ghumui, nga kihonguwa kyona kyokeei̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Aaleeta ntu̱u̱li̱ emui ya mbu̱li̱ nga kihonguwa haabwa kibhi, ");
INSERT INTO tlj_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","nte ebili, ntu̱u̱li̱ sya ntaama etaano, ntu̱u̱li̱ sya mbu̱li̱ etaano na byana bya ntaama bitaano byabusaasa bya mwaka ghumui, nga kihonguwa kya bu̱si̱nge. Eki niikiyo kihonguwa eki Naasoni̱ mutabani̱ wa Aminadaabbu aaleeti̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Haa kilo kyakabili Netaneeli̱ mutabani̱ wa Juhala, mwebembeli̱ wa ntu̱la ya I̱sakaali, aaleeta kihonguwa kiye. ");
INSERT INTO tlj_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Bini niibiyo aaleeti̱ye: sahaani̱ emui ya siliva ku̱lyota kwayo ki̱lo emui nʼeki̱twi̱ke, bbaaku̱li̱ emui ya siliva ku̱lyota kwayo gulaamu lunaanaa, kusighikila haa ki̱pi̱i̱mo kyʼomu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. Bu̱li̱ emui ekaba elimu nsyano esemeeye, eghi etabuuyemu mafu̱ta ghaa biti oli̱va, kuba kihonguwa kya bilimuwa. ");
INSERT INTO tlj_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Aaleeta kaasaniya kamui kaanabwana kaa feeja ku̱lyota kwakʼo gulaamu ki̱ku̱mi̱ nʼeku̱mi̱, akaasuuyʼo bubbani̱, ");
INSERT INTO tlj_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","ntu̱u̱li̱ ya nte emui, ntu̱u̱li̱ ya ntaama emui na kyana kya ntaama kimui kyabusaasa kya mwaka ghumui, nga kihonguwa kyona kyokeei̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","Aaleeta ntu̱u̱li̱ emui ya mbu̱li̱ nga kihonguwa haabwa kibhi, ");
INSERT INTO tlj_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","nte ebili, ntu̱u̱li̱ sya ntaama etaano, ntu̱u̱li̱ sya mbu̱li̱ etaano na byana bya ntaama bitaano byabusaasa bya mwaka ghumui, nga kihonguwa kya bu̱si̱nge. Eki niikiyo kihonguwa eki Netaneeli̱ mutabani̱ wa Juhala aaleeti̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Haa kilo kyakasatu, Eli̱yaabbu mutabani̱ wa Heloni̱, mwebembeli̱ wa ntu̱la ya Jabbu̱looni̱, aaleeta kihonguwa kiye. ");
INSERT INTO tlj_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Bini niibiyo aaleeti̱ye: sahaani̱ emui ya siliva ku̱lyota kwayo ki̱lo emui nʼeki̱twi̱ke, bbaaku̱li̱ emui ya siliva ku̱lyota kwayo gulaamu lunaanaa, kusighikila haa ki̱pi̱i̱mo kyʼomu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. Bu̱li̱ emui ekaba elimu nsyano esemeeye, eghi etabuuyemu mafu̱ta ghaa biti oli̱va, kuba kihonguwa kya bilimuwa. ");
INSERT INTO tlj_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Aaleeta kaasaniya kamui kaanabwana kaa feeja ku̱lyota kwakʼo gulaamu ki̱ku̱mi̱ nʼeku̱mi̱, akaasuuyʼo bubbani̱, ");
INSERT INTO tlj_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ntu̱u̱li̱ ya nte emui, ntu̱u̱li̱ ya ntaama emui na kyana kya ntaama kimui kyabusaasa kya mwaka ghumui, nga kihonguwa kyona kyokeei̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","Aaleeta ntu̱u̱li̱ emui ya mbu̱li̱ nga kihonguwa haabwa kibhi, ");
INSERT INTO tlj_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","nte ebili, ntu̱u̱li̱ sya ntaama etaano, ntu̱u̱li̱ sya mbu̱li̱ etaano na byana bya ntaama bitaano byabusaasa bya mwaka ghumui, nga kihonguwa kya bu̱si̱nge. Eki niikiyo kihonguwa eki Eli̱yaabbu mutabani̱ wa Heloni̱ aaleeti̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Haa kilo kyakanaa, Elijuula mutabani̱ wa Sedula, mwebembeli̱ wa ntu̱la ya Leu̱bbeeni̱, aaleeta kihonguwa kiye. ");
INSERT INTO tlj_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Bini niibiyo aaleeti̱ye: sahaani̱ emui ya siliva ku̱lyota kwayo ki̱lo emui nʼeki̱twi̱ke, bbaaku̱li̱ emui ya siliva ku̱lyota kwayo gulaamu lunaanaa, kusighikila haa ki̱pi̱i̱mo kyʼomu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. Bu̱li̱ emui ekaba elimu nsyano esemeeye, eghi etabuuyemu mafu̱ta ghaa biti oli̱va, kuba kihonguwa kya bilimuwa. ");
INSERT INTO tlj_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Aaleeta kaasaniya kamui kaanabwana kaa feeja ku̱lyota kwakʼo gulaamu ki̱ku̱mi̱ nʼeku̱mi̱, akaasuuyʼo bubbani̱, ");
INSERT INTO tlj_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","ntu̱u̱li̱ ya nte emui, ntu̱u̱li̱ ya ntaama emui na kyana kya ntaama kimui kyabusaasa kya mwaka ghumui, nga kihonguwa kyona kyokeei̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","Aaleeta ntu̱u̱li̱ emui ya mbu̱li̱ nga kihonguwa haabwa kibhi, ");
INSERT INTO tlj_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","nte ebili, ntu̱u̱li̱ sya ntaama etaano, ntu̱u̱li̱ sya mbu̱li̱ etaano na byana bya ntaama bitaano byabusaasa bya mwaka ghumui, nga kihonguwa kya bu̱si̱nge. Eki niikiyo kihonguwa eki Elijuula mutabani̱ wa Sedula aaleeti̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Haa kilo kyakataano Selu̱myeli̱ mutabani̱ wa Yulisadaai̱, mwebembeli̱ wa ntu̱la ya Si̱mi̱yooni̱, aaleeta kihonguwa kiye. ");
INSERT INTO tlj_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Bini niibiyo aaleeti̱ye: sahaani̱ emui ya siliva ku̱lyota kwayo ki̱lo emui nʼeki̱twi̱ke, bbaaku̱li̱ emui ya siliva ku̱lyota kwayo gulaamu lunaanaa, kusighikila haa ki̱pi̱i̱mo kyʼomu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. Bu̱li̱ emui ekaba elimu nsyano esemeeye, eghi etabuuyemu mafu̱ta ghaa biti oli̱va, kuba kihonguwa kya bilimuwa. ");
INSERT INTO tlj_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Aaleeta kaasaniya kamui kaanabwana kaa feeja ku̱lyota kwakʼo gulaamu ki̱ku̱mi̱ nʼeku̱mi̱, akaasuuyʼo bubbani̱, ");
INSERT INTO tlj_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ntu̱u̱li̱ ya nte emui, ntu̱u̱li̱ ya ntaama emui na kyana kya ntaama kimui kyabusaasa kya mwaka ghumui, nga kihonguwa kyona kyokeei̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","Aaleeta ntu̱u̱li̱ emui ya mbu̱li̱ nga kihonguwa haabwa kibhi, ");
INSERT INTO tlj_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","nte ebili, ntu̱u̱li̱ sya ntaama etaano, ntu̱u̱li̱ sya mbu̱li̱ etaano na byana bya ntaama bitaano byabusaasa bya mwaka ghumui, nga kihonguwa kya bu̱si̱nge. Eki niikiyo kihonguwa eki Selu̱myeli̱ mutabani̱ wa Yulisadaai̱ aaleeti̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Haa kilo kyamukaagha, Eli̱yasaafu mutabani̱ wa Deu̱weli̱, mwebembeli̱ wa ntu̱la ya Gaadi̱, aaleeta kihonguwa kiye. ");
INSERT INTO tlj_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Bini niibiyo aaleeti̱ye: sahaani̱ emui ya siliva ku̱lyota kwayo ki̱lo emui nʼeki̱twi̱ke, bbaaku̱li̱ emui ya siliva ku̱lyota kwayo gulaamu lunaanaa, kusighikila haa ki̱pi̱i̱mo kyʼomu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. Bu̱li̱ emui ekaba elimu nsyano esemeeye, eghi etabuuyemu mafu̱ta ghaa biti oli̱va, kuba kihonguwa kya bilimuwa. ");
INSERT INTO tlj_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Aaleeta kaasaniya kamui kaanabwana kaa feeja ku̱lyota kwakʼo gulaamu ki̱ku̱mi̱ nʼeku̱mi̱, akaasuuyʼo bubbani̱, ");
INSERT INTO tlj_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ntu̱u̱li̱ ya nte emui, ntu̱u̱li̱ ya ntaama emui na kyana kya ntaama kimui kyabusaasa kya mwaka ghumui, nga kihonguwa kyona kyokeei̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","Aaleeta ntu̱u̱li̱ emui ya mbu̱li̱ nga kihonguwa haabwa kibhi, ");
INSERT INTO tlj_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","nte ebili, ntu̱u̱li̱ sya ntaama etaano, ntu̱u̱li̱ sya mbu̱li̱ etaano na byana bya ntaama bitaano byabusaasa bya mwaka ghumui, nga kihonguwa kya bu̱si̱nge. Eki niikiyo kihonguwa eki Eli̱yasaafu mutabani̱ wa Deu̱weli̱ aaleeti̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Haa kilo kyamusanju̱, Eli̱sama mutabani̱ wa Ami̱hu̱di̱, mwebembeli̱ wa ntu̱la ya Efulahi̱mu̱, aaleeta kihonguwa kiye. ");
INSERT INTO tlj_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Bini niibiyo aaleeti̱ye: sahaani̱ emui ya siliva ku̱lyota kwayo ki̱lo emui nʼeki̱twi̱ke, bbaaku̱li̱ emui ya siliva ku̱lyota kwayo gulaamu lunaanaa, kusighikila haa ki̱pi̱i̱mo kyʼomu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. Bu̱li̱ emui ekaba elimu nsyano esemeeye, eghi etabuuyemu mafu̱ta ghaa biti oli̱va, kuba kihonguwa kya bilimuwa. ");
INSERT INTO tlj_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Aaleeta kaasaniya kamui kaanabwana kaa feeja ku̱lyota kwakʼo gulaamu ki̱ku̱mi̱ nʼeku̱mi̱, akaasuuyʼo bubbani̱, ");
INSERT INTO tlj_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ntu̱u̱li̱ ya nte emui, ntu̱u̱li̱ ya ntaama emui na kyana kya ntaama kimui kyabusaasa kya mwaka ghumui, nga kihonguwa kyona kyokeei̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","Aaleeta ntu̱u̱li̱ emui ya mbu̱li̱ nga kihonguwa haabwa kibhi, ");
INSERT INTO tlj_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","nte ebili, ntu̱u̱li̱ sya ntaama etaano, ntu̱u̱li̱ sya mbu̱li̱ etaano na byana bya ntaama bitaano byabusaasa bya mwaka ghumui, nga kihonguwa kya bu̱si̱nge. Eki niikiyo kihonguwa eki Eli̱sama mutabani̱ wa Ami̱hu̱di̱ aaleeti̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Haa kilo kyamunaanaa, Gamalyeli̱ mutabani̱ wa Pedajula, mwebembeli̱ wa ntu̱la ya Manase, aaleeta kihonguwa kiye. ");
INSERT INTO tlj_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Bini niibiyo aaleeti̱ye: sahaani̱ emui ya siliva ku̱lyota kwayo ki̱lo emui nʼeki̱twi̱ke, bbaaku̱li̱ emui ya siliva ku̱lyota kwayo gulaamu lunaanaa, kusighikila haa ki̱pi̱i̱mo kyʼomu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. Bu̱li̱ emui ekaba elimu nsyano esemeeye, eghi etabuuyemu mafu̱ta ghaa biti oli̱va, kuba kihonguwa kya bilimuwa. ");
INSERT INTO tlj_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Aaleeta kaasaniya kamui kaanabwana kaa feeja ku̱lyota kwakʼo gulaamu ki̱ku̱mi̱ nʼeku̱mi̱, akaasuuyʼo bubbani̱, ");
INSERT INTO tlj_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ntu̱u̱li̱ ya nte emui, ntu̱u̱li̱ ya ntaama emui na kyana kya ntaama kimui kyabusaasa kya mwaka ghumui, nga kihonguwa kyona kyokeei̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","Aaleeta ntu̱u̱li̱ emui ya mbu̱li̱ nga kihonguwa haabwa kibhi, ");
INSERT INTO tlj_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","nte ebili, ntu̱u̱li̱ sya ntaama etaano, ntu̱u̱li̱ sya mbu̱li̱ etaano na byana bya ntaama bitaano byabusaasa bya mwaka ghumui, nga kihonguwa kya bu̱si̱nge. Eki niikiyo kihonguwa eki Gamalyeli̱ mutabani̱ wa Pedajula aaleeti̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Haa kilo kyamwenda Abbidaani̱ mutabani̱ wa Gi̱di̱yooni̱, mwebembeli̱ wa ntu̱la ya Bbenjami̱i̱ni̱, aaleeta kihonguwa kiye. ");
INSERT INTO tlj_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Bini niibiyo aaleeti̱ye: sahaani̱ emui ya siliva ku̱lyota kwayo ki̱lo emui nʼeki̱twi̱ke, bbaaku̱li̱ emui ya siliva ku̱lyota kwayo gulaamu lunaanaa, kusighikila haa ki̱pi̱i̱mo kyʼomu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. Bu̱li̱ emui ekaba elimu nsyano esemeeye, eghi etabuuyemu mafu̱ta ghaa biti oli̱va, kuba kihonguwa kya bilimuwa. ");
INSERT INTO tlj_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Aaleeta kaasaniya kamui kaanabwana kaa feeja ku̱lyota kwakʼo gulaamu ki̱ku̱mi̱ nʼeku̱mi̱, akaasuuyʼo bubbani̱, ");
INSERT INTO tlj_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ntu̱u̱li̱ ya nte emui, ntu̱u̱li̱ ya ntaama emui na kyana kya ntaama kimui kyabusaasa kya mwaka ghumui, nga kihonguwa kyona kyokeei̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","Aaleeta ntu̱u̱li̱ emui ya mbu̱li̱ nga kihonguwa haabwa kibhi, ");
INSERT INTO tlj_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","nte ebili, ntu̱u̱li̱ sya ntaama etaano, ntu̱u̱li̱ sya mbu̱li̱ etaano na byana bya ntaama bitaano byabusaasa bya mwaka ghumui, nga kihonguwa kya bu̱si̱nge. Eki niikiyo kihonguwa eki Abbidaani̱ mutabani̱ wa Gi̱di̱yooni̱ aaleeti̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Haa kilo kya eku̱mi̱ Ahi̱yejeeli̱ mutabani̱ wa Amisadaai̱, mwebembeli̱ wa ntu̱la ya Daani̱, aaleeta kihonguwa kiye. ");
INSERT INTO tlj_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Bini niibiyo aaleeti̱ye: sahaani̱ emui ya siliva ku̱lyota kwayo ki̱lo emui nʼeki̱twi̱ke, bbaaku̱li̱ emui ya siliva ku̱lyota kwayo gulaamu lunaanaa, kusighikila haa ki̱pi̱i̱mo kyʼomu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. Bu̱li̱ emui ekaba elimu nsyano esemeeye, eghi etabuuyemu mafu̱ta ghaa biti oli̱va, kuba kihonguwa kya bilimuwa. ");
INSERT INTO tlj_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Aaleeta kaasaniya kamui kaanabwana kaa feeja ku̱lyota kwakʼo gulaamu ki̱ku̱mi̱ nʼeku̱mi̱, akaasuuyʼo bubbani̱, ");
INSERT INTO tlj_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ntu̱u̱li̱ ya nte emui, ntu̱u̱li̱ ya ntaama emui na kyana kya ntaama kimui kyabusaasa kya mwaka ghumui, nga kihonguwa kyona kyokeei̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","Aaleeta ntu̱u̱li̱ emui ya mbu̱li̱ nga kihonguwa haabwa kibhi, ");
INSERT INTO tlj_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","nte ebili, ntu̱u̱li̱ sya ntaama etaano, ntu̱u̱li̱ sya mbu̱li̱ etaano na byana bya ntaama bitaano byabusaasa bya mwaka ghumui, nga kihonguwa kya bu̱si̱nge. Eki niikiyo kihonguwa eki Ahi̱yejeeli̱ mutabani̱ wa Amisadaai̱ aaleeti̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Haa kilo kyʼeku̱mi̱ na kimui, Pagi̱yeeli̱ mutabani̱ wa Okulaani̱, mwebembeli̱ wa ntu̱la ya Aseli̱, aaleeta kihonguwa kiye. ");
INSERT INTO tlj_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Bini niibiyo aaleeti̱ye: sahaani̱ emui ya siliva ku̱lyota kwayo ki̱lo emui nʼeki̱twi̱ke, bbaaku̱li̱ emui ya siliva ku̱lyota kwayo gulaamu lunaanaa, kusighikila haa ki̱pi̱i̱mo kyʼomu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. Bu̱li̱ emui ekaba elimu nsyano esemeeye, eghi etabuuyemu mafu̱ta ghaa biti oli̱va, kuba kihonguwa kya bilimuwa. ");
INSERT INTO tlj_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Aaleeta kaasaniya kamui kaanabwana kaa feeja ku̱lyota kwakʼo gulaamu ki̱ku̱mi̱ nʼeku̱mi̱, akaasuuyʼo bubbani̱, ");
INSERT INTO tlj_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ntu̱u̱li̱ ya nte emui, ntu̱u̱li̱ ya ntaama emui na kyana kya ntaama kimui kyabusaasa kya mwaka ghumui, nga kihonguwa kyona kyokeei̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","Aaleeta ntu̱u̱li̱ emui ya mbu̱li̱ nga kihonguwa haabwa kibhi, ");
INSERT INTO tlj_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","nte ebili, ntu̱u̱li̱ sya ntaama etaano, ntu̱u̱li̱ sya mbu̱li̱ etaano na byana bya ntaama bitaano byabusaasa bya mwaka ghumui, nga kihonguwa kya bu̱si̱nge. Eki niikiyo kihonguwa eki Pagi̱yeeli̱ mutabani̱ wa Okulaani̱ aaleeti̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Haa kilo kyʼeku̱mi̱ na bibili Ahi̱la mutabani̱ wa Enani̱, mwebembeli̱ wa ntu̱la ya Nafutaali, aaleeta kihonguwa kiye. ");
INSERT INTO tlj_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Bini niibiyo aaleeti̱ye: sahaani̱ emui ya siliva ku̱lyota kwayo ki̱lo emui nʼeki̱twi̱ke, bbaaku̱li̱ emui ya siliva ku̱lyota kwayo gulaamu lunaanaa, kusighikila haa ki̱pi̱i̱mo kyʼomu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. Bu̱li̱ emui ekaba elimu nsyano esemeeye, eghi etabuuyemu mafu̱ta ghaa biti oli̱va, kuba kihonguwa kya bilimuwa. ");
INSERT INTO tlj_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Aaleeta kaasaniya kamui kaanabwana kaa feeja ku̱lyota kwakʼo gulaamu ki̱ku̱mi̱ nʼeku̱mi̱, akaasuuyʼo bubbani̱, ");
INSERT INTO tlj_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ntu̱u̱li̱ ya nte emui, ntu̱u̱li̱ ya ntaama emui na kyana kya ntaama kimui kyabusaasa kya mwaka ghumui, nga kihonguwa kyona kyokeei̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","Aaleeta ntu̱u̱li̱ emui ya mbu̱li̱ nga kihonguwa haabwa kibhi, ");
INSERT INTO tlj_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","nte ebili, ntu̱u̱li̱ sya ntaama etaano, ntu̱u̱li̱ sya mbu̱li̱ etaano na byana bya ntaama bitaano byabusaasa bya mwaka ghumui, nga kihonguwa kya bu̱si̱nge. Eki niikiyo kihonguwa eki Ahi̱la mutabani̱ wa Enani̱ aaleeti̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Bini niibiyo bihonguwa ebi beebembeli̱ baa Banai̱saaleeli̱ baahaayeyo obu Musa aasi̱i̱ghi̱ye mafu̱ta haa kyakuhongelʼo bihonguwa haabwa kukihaayo: sahaani̱ eku̱mi̱ nʼebili sya siliva, bbaaku̱li̱ eku̱mi̱ nʼebili sya siliva na buusaniya buunabwana eku̱mi̱ na bubili bwa feeja. ");
INSERT INTO tlj_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Bu̱li̱ sahaani̱ ku̱lyota kwayʼo kukaba kuli ki̱lo emui nʼeki̱twi̱ke kandi bu̱li̱ bbaaku̱li̱ ku̱lyota kwayʼo kukaba kuli gulaamu lunaanaa. Bintu byona bya siliva ku̱lyota kwabiyo kwaba ki̱lo maku̱mi̱ abili na musanju̱ na gulaamu lukaagha, kusighikila haa ki̱pi̱i̱mo kyʼomu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Buusaniya buunabwana eku̱mi̱ na bubili bwa feeja eghi eesuuyemu bubbani̱, bu̱li̱ kamui ku̱lyota kwakʼo kwaba gulaamu eku̱mi̱ nʼemui kandi buusaniya obu bwona bwaba ki̱lo emui na kimui kyakasatu, kusighikila haa ki̱pi̱i̱mo kyʼomu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Muhendo ghwa bisolo bya kihonguwa kyona kyokeei̱ye ghwaba ntu̱u̱li̱ sya nte eku̱mi̱ nʼebili, ntu̱u̱li̱ sya ntaama eku̱mi̱ nʼebili, byana bya ntaama byabusaasa eku̱mi̱ na bibili bya mwaka ghumui na bihonguwa byabiyo bya bilimuwa. Ntu̱u̱li̱ sya mbu̱li̱ syaba eku̱mi̱ nʼebili sya kihonguwa haabwa kibhi. ");
INSERT INTO tlj_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Muhendo ghwa bisolo bya kihonguwa kya bu̱si̱nge ghwaba ntu̱u̱li̱ sya nte maku̱mi̱ abili nʼenaa, ntu̱u̱li̱ sya ntaama nkaagha, mbu̱li̱ nkaagha syabusaasa na byana bya ntaama nkaagha bya mwaka ghumui. Ebi niibiyo byabaaye bihonguwa haabwa kuhaayo kyakuhongelʼo bihonguwa haanu̱ma ya Musa kukisiigha mafu̱ta. ");
INSERT INTO tlj_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Obu Musa aataahi̱ye mu weema ya kusanga-sangaanamu ku̱bu̱gha na Mukama, aaghu̱wa elaka lya Mukama ndi̱bu̱gha naye ku̱lu̱gha haagati ya baa kelu̱bbi̱ babili abali eghulu ya kyakughaniililʼo bantu bibhi ekili haagu̱u̱li̱ ya sandu̱u̱ku̱ ya ndaghaano. Niikuwo Mukama aabu̱ghi̱ye atiyo na Musa. ");
INSERT INTO tlj_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Oghile Alooni̱ oti, ‘Okaakubhaki̱ya taala musanju̱, osite haa kyakutʼo taala niikuwo siikale sibhaki̱i̱ye mu maaso ghaakiyo.’ ” ");
INSERT INTO tlj_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Alooni̱ aakola ngoku Musa aamughambiiye. Taala esi aasitʼo si̱loli̱ye mu maaso ghaa kyakutʼo taala, ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Baawiisa na nondo kyakutʼo taala kyona kya feeja, ku̱lu̱gha haa ncuba yakiyo ku̱hi̱ka haa bimole byaku̱ki̱semeli̱ya. Baakikola mu mulingo ghwonini oghu Mukama ooleki̱ye Musa. ");
INSERT INTO tlj_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Mu Banai̱saaleeli̱ boona okomemu Baleevi̱ kandi okole mukolo ghwa ku̱beeli̱ya. ");
INSERT INTO tlj_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Mukolo ghwa ku̱beeli̱ya oghukole mu mulingo ghuni: obamisangile maasi aghakweli̱yagha, babaghembe mubili ghwona na kaawembo, banaabi̱ye ngoye syabo. Du̱mbi̱ bakuba beeli̱ye ewaanu. ");
INSERT INTO tlj_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Batwale ntu̱u̱li̱ ya nte na kihonguwa kya bilimuwa kya nsyano esemeeye, eghi etabuuyemu mafu̱ta kandi ntu̱u̱li̱ ya nte yaakabili kuba kihonguwa haabwa kibhi. ");
INSERT INTO tlj_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Otwale Baleevi̱ aba mu maaso ghaa weema ya kusanga-sangaanamu kandi okumaani̱ye ki̱bbu̱la kyona kya Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Oleete Baleevi̱ aba mu maaso ghaa Mukama kandi Banai̱saaleeli̱ bate mikono yabo haa mituwe ya Baleevi̱ aba. ");
INSERT INTO tlj_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Alooni̱ ali na kuhaayo Baleevi̱ mu maaso ghaa Mukama nga kihonguwa baamu̱ki̱i̱ye kya Banai̱saaleeli̱ aba, niikuwo bakole mulimo ghwa ku̱heeleli̱ya Mukama. ");
INSERT INTO tlj_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Du̱mbi̱ Baleevi̱ bate mikono yabo haa mituwe ya ntu̱u̱li̱ sya nte esi kandi mu̱hongi̱ ali na kuhonga ewaa Mukama ntu̱u̱li̱ ya nte emui nga kihonguwa haabwa kibhi kandi yaakabili nga kihonguwa kyona kyokeei̱ye, kya kukola mukolo ghwa kughaniluwa bibhi bya Baleevi̱. ");
INSERT INTO tlj_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Olaghile Baleevi̱ ku̱heeleli̱yagha Alooni̱ na batabani̱ be kandi obaheyo nga kihonguwa baamu̱ki̱i̱ye ewaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Mukolo oghu ghukwoleka ngoku Baleevi̱ bali baa mbaghani̱ja mu Banai̱saaleeli̱ banji kandi bakuba bantu banje. ");
INSERT INTO tlj_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Okaakumala kukola mukolo ghwa kweli̱ya Baleevi̱ kandi kubahaayo nga kihonguwa baamu̱ki̱i̱ye ewaa Mukama, du̱mbi̱ bali na kwisa kandi kukola mulimo ghwabo haa weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Baleevi̱ aba ni bantu banje baa mbaghani̱ja mu Banai̱saaleeli̱ banji boona kandi bakuba banje mu ki̱i̱kalo kya baana baabusaasa mi̱li̱ghaaso ya Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Mu̱li̱ghaaso ghwona ghwabusaasa mu I̱saaleeli̱ ni ghwanje. Mi̱li̱ghaaso yoona yabusaasa ya bisolo ni yanje. Kilo eki naati̱ye baana baabusaasa mi̱li̱ghaaso mu ehanga lya Mi̱si̱li̱, nkafoola mi̱li̱ghaaso ya Banai̱saaleeli̱ kuba banje. ");
INSERT INTO tlj_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Nahabweki naatwete Baleevi̱ kuba banje mu ki̱i̱kalo kya baana baabusaasa boona mi̱li̱ghaaso baa Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Mu Banai̱saaleeli̱ boona, naafooye Baleevi̱ kuba kisembo kya Alooni̱ na batabani̱ be. Baleevi̱ aba balakolagha mulimo haabwa Banai̱saaleeli̱ haa weema ya kusanga-sangaanamu. Balakolagha mukolo ghwa Banai̱saaleeli̱ kughaniluwa bibhi niikuwo Banai̱saaleeli̱ aba kaakuba beebinga weema ehi̱ki̱li̱i̱ye, batatunga kifubilo kya ndwala kubaata.” ");
INSERT INTO tlj_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Musa, Alooni̱ na ki̱bbu̱la kyona kya Banai̱saaleeli̱ baahaayo Baleevi̱ ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Baleevi̱ beeyeli̱ya kandi baanaabi̱ya ngoye syabo. Du̱mbi̱ Alooni̱ aabahaayo nga kihonguwa baamu̱ki̱i̱ye mu maaso ghaa Mukama kandi aakola mukolo ghwa Baleevi̱ aba kughaniluwa bibhi niikuwo bafooke abeeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Haanu̱ma yʼeki, Baleevi̱ baaghenda kukola mulimo ghwabo haa weema ya kusanga-sangaanamu, Alooni̱ na batabani̱ be niibo baabaloleelelagha haa mulimo oghu. Banai̱saaleeli̱ baakola byona ebikwetʼo Baleevi̱ ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Kini kikwetʼo Baleevi̱: Basaasa abali na myaka maku̱mi̱ abili nʼetaano na kusaalʼo bali na kwisa kandi kukola mulimo ghwa ku̱heeleli̱ya haa weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Bhaatu basaasa abali na myaka maku̱mi̱ ataano ya bukulu bali na kuhuumula kandi baleke kukola mulimo ghwa ku̱heeleli̱ya oghu. ");
INSERT INTO tlj_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Bakugubha kukoonela baanakyabo kukola milimo yabo haa weema ya kusanga-sangaanamu, bhaatu ebo batakola mulimo oghu. Haaliikuwo waahaagha Baleevi̱ milimo ya kukola.” ");
INSERT INTO tlj_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Mukama aabu̱gha na Musa mu elungu lya Si̱naai̱ mu kweli̱ kwʼoku̱du̱bha kwa mwaka ghwakabili haanu̱ma ya Banai̱saaleeli̱ ku̱lu̱gha mu nsi ya Mi̱si̱li̱. Aaghila ati, ");
INSERT INTO tlj_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Oghambile Banai̱saaleeli̱ kukolagha Ki̱ghenu̱ kya Kusaaluwʼo haa bwile bwakiyo bwonini. ");
INSERT INTO tlj_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Mukole ki̱ghenu̱ eki haa bwile bwakiyo bwonini, lwagholo lwa kilo kyʼeku̱mi̱ na bbinaa kya kweli̱ kuni. Mulole ngu mwakwamiliiye bilaghilo byona na ndaghikiililo bya ki̱ghenu̱ eki.” ");
INSERT INTO tlj_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Nahabweki Musa aaghambila Banai̱saaleeli̱ kukolagha ki̱ghenu̱ kya Kusaaluwʼo. ");
INSERT INTO tlj_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Baatandika kukola Ki̱ghenu̱ kya Kusaaluwʼo eki mu elungu lya Si̱naai̱ lwagholo lwa kilo kyʼeku̱mi̱ na bbinaa kya kweli̱ kwʼoku̱du̱bha. Banai̱saaleeli̱ baakola bu̱li̱ kintu ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Bhaatu bamui mu Banai̱saaleeli̱ aba tabaakoli̱ye ki̱ghenu̱ kya Kusaaluwʼo eki haa kilo eki nanga bakaba bateeli̱ye haabwa ku̱ku̱mʼo mu̱ku̱ ghwa muntu. Nahabweki baasa ewaa Musa na Alooni̱ kilo eki kyonini ");
INSERT INTO tlj_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","kandi baaghila Musa bati, “Twafooki̱ye abateeli̱ye nanga twaku̱mi̱yʼo mu̱ku̱ ghwa muntu. Buuye nkiki kyaleki̱ye mwatutanga kuhaayo kihonguwa ewaa Mukama na Banai̱saaleeli̱ baanakyatu haa bwile bwakiyo bwonini?” ");
INSERT INTO tlj_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Musa aabakuukamu ati, “Mulinde ku̱hi̱ki̱ya ni̱i̱ghu̱u̱ye eki Mukama akulaghila ekikwetʼo enu̱we.” ");
INSERT INTO tlj_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Oghile Banai̱saaleeli̱ oti, ‘Kaakuba muntu weena mu enu̱we kedha mu baasukulu baanu, afooka oghu ateeli̱ye haabwa ku̱ku̱mʼo mu̱ku̱ ghwa muntu kedha aba ali mu lughendo lu̱seli̱ye, akugubha kukola ki̱ghenu̱ kya Mukama kya Kusaaluwʼo. ");
INSERT INTO tlj_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Bantu aba bali na kukola ki̱ghenu̱ eki lwagholo lwa kilo kyʼeku̱mi̱ na bbinaa kya kweli̱ kwakabili. Bali na kuliya kyana kya ntaama na migaati̱ etalimu ki̱tu̱mbi̱so kandi bulaala busaaliiye. ");
INSERT INTO tlj_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Tabali na ku̱ti̱gha haa nyama sya kyana kya ntaama eki ku̱hi̱ki̱ya nkyambisi kandi obu bakuba mbakiliya batahenda eku̱wa lyakiyo na limui. Obu bakuba mbakola Ki̱ghenu̱ kya Kusaaluwʼo eki, bali na kukwamilila bilaghilo byakiyo byona. ");
INSERT INTO tlj_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Bhaatu kaakuba muntu aba eeli̱ye kandi atali mu lughendo asaaghuwa kukola ki̱ghenu̱ kya Kusaaluwʼo, muntu oghu ali na kubhinguwa mu Banai̱saaleeli̱ baanakiye, nanga taahaayeyo kihonguwa kya Mukama haa bwile bwakiyo bwonini. Muntu oghu ali na kufubiluwa haabwa kibhi kiye. ");
INSERT INTO tlj_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ ‘Kaakuba munamahanga oghu aakaaye naanu abbala kukola ki̱ghenu̱ kya Kusaaluwʼo kya Mukama, ali na kukikola naakwamilila bilaghilo na ndaghikiililo syakiyo syona. Bilaghilo ebi bili na kuba bya munamahanga na Munai̱saaleeli̱.’ ” ");
INSERT INTO tlj_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Haa kilo eki baamali̱ye kukwela weema ehi̱ki̱li̱i̱ye, weema ya sandu̱u̱ku̱ ya ndaghaano, kicu kyaghi̱swi̱kila. Kyakala eghulu ya weema ehi̱ki̱li̱i̱ye eghi ku̱lu̱gha lwagholo ku̱hi̱ki̱ya nkyambisi kandi kikaba ki̱su̱si̱ye nga mulilo. ");
INSERT INTO tlj_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Weema ehi̱ki̱li̱i̱ye eghi niikuwo yaakalagha etiyo, kicu kyaghi̱swi̱ki̱lagha bu̱li̱ kilo kandi mukilo kyasusagha nga mulilo. ");
INSERT INTO tlj_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Kicu eki kyakaamukagha haa weema eghi, du̱mbi̱ Banai̱saaleeli̱ batandika ku̱lu̱gha mu ki̱i̱kalo eki kandi baghenda mu ki̱i̱kalo kinji. Kicu eki kyakalekagha kughenda, du̱mbi̱ Banai̱saaleeli̱ baghoona mu ki̱i̱kalo eki. ");
INSERT INTO tlj_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Mukama niiye aalaghilagha Banai̱saaleeli̱ hambali bakughenda kandi abalaghila hambali bakughoona. Kicu eki kyakabaagha kitalu̱ghi̱ye haa weema ehi̱ki̱li̱i̱ye eghi, baghoona mu ki̱i̱kalo eki. ");
INSERT INTO tlj_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Kicu eki kyakaakalagha haa weema ehi̱ki̱li̱i̱ye eghi haabwa bwile bukani̱ye, Banai̱saaleeli̱ bahu̱ti̱ya kilaghilo kya Mukama kandi batalu̱gha mu ki̱i̱kalo eki. ");
INSERT INTO tlj_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Bwile bunji kicu eki kyakalagha haa weema ehi̱ki̱li̱i̱ye eghi haabwa bilo bikee, du̱mbi̱ baghoona mu ki̱i̱kalo eki ngoku Mukama aabalaghiiye. Bhaatu naabalaghila, batandika ku̱lu̱gha mu ki̱i̱kalo eki. ");
INSERT INTO tlj_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Bwile bunji kicu eki kyakalagha haa weema eghi ku̱lu̱gha lwagholo ku̱hi̱ki̱ya nkyambisi. Kicu eki kyakaamukaghʼo nkyambisi, du̱mbi̱ batandika kughenda. Bhaatu bwile bunji kyakalaghʼo mukilo na ntangaali̱ kandi kyakaamukaghʼo, du̱mbi̱ batodha batandika kughenda. ");
INSERT INTO tlj_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Kicu eki kyakaakalagha haa weema ehi̱ki̱li̱i̱ye bilo bibili, kedha kweli̱ kedha mwaka, Banai̱saaleeli̱ baakalagha hambali baghooneeye kandi tabaalu̱ghagha mu ki̱i̱kalo eki. Bhaatu kyakaamukaghʼo, batandika kughenda. ");
INSERT INTO tlj_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Mukama aakabalaghilagha baghoona kandi naabalaghila ku̱lu̱ghʼo du̱mbi̱ batandika kughenda. Baakolagha byona ebi Mukama aalaghilagha Musa. ");
INSERT INTO tlj_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Owiise na nondo bi̱i̱di̱yo bibili bya siliva, obi̱koleesi̱yaghe kubilikila ki̱bbu̱la kya Banai̱saaleeli̱ kwekumaani̱li̱ya hamui kandi kughambila bantu aba ku̱lu̱gha hambali baghooneeye. ");
INSERT INTO tlj_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Balakateelagha bi̱i̱di̱yo byombi ebi, ki̱bbu̱la kya Banai̱saaleeli̱ kyona kyekumaani̱li̱yaghe hambali oli, haa mulyango ghwa weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Kaakuba bateela ki̱i̱di̱yo kimui kyonkaha, beebembeli̱ baa ntu̱la sya Banai̱saaleeli̱ bonkaha haaliibo beekumaani̱li̱yagha hambali oli. ");
INSERT INTO tlj_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Olakateelagha ki̱i̱di̱yo nʼelaka lyamaani̱, bantu bʼomu ntu̱la esi̱ghooni̱ye haa luhande lwa bu̱lu̱gha ejooba batandikaghe kughenda. ");
INSERT INTO tlj_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Olakateelagha ki̱i̱di̱yo eki mulundi ghwakabili, bantu bʼomu ntu̱la esi̱ghooni̱ye haa luhande lwa eku̱wa batandikaghe kughenda. Oli na kuteela ki̱i̱di̱yo mu elaka likee-likee kughambila bantu kughenda. ");
INSERT INTO tlj_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Bhaatu olakabaagha noobbala kubilikila ki̱bbu̱la kya Banai̱saaleeli̱ kyona kugumbaana hamui, oteelaghe ki̱i̱di̱yo mu elaka lya mbaghani̱ja. ");
INSERT INTO tlj_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“Bahongi̱ batabani̱ baa Alooni̱ haaliibo baateelagha bi̱i̱di̱yo ebi. Kini kili na kuba kilaghilo kyanu kukwata bilo nʼebilo mu mijo yaanu yoona eghi ekwisa. ");
INSERT INTO tlj_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Mulakaghendagha kulwana na ngi̱ghu̱ syanu esikwete kubabona-boni̱ya mu nsi yaanu, muteelaghe bi̱i̱di̱yo ebi nʼelaka lyamaani̱. Du̱mbi̱ Mukama Luhanga waanu alaasukagha kukoonela enu̱we kandi kubajuna ngi̱ghu̱ syanu esi. ");
INSERT INTO tlj_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Muli na kuteela bi̱i̱di̱yo ebi haa bwile bwanu bwa kudheedhuwa, bwile bwa kukola bi̱ghenu̱ byanu na kilo kyʼoku̱du̱bha kya meeli̱ ghaanu. Muteelaghe bi̱i̱di̱yo ebi obu mulabaagha nimuhayo bihonguwa byona byokeei̱ye byanu na bihonguwa bya bu̱si̱nge. Luhanga waanu akubaaghu̱wa kandi abaasuke. Ni̱i̱si̱ye Mukama Luhanga waanu.” ");
INSERT INTO tlj_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Haa kilo kya maku̱mi̱ abili kya kweli̱ kwakabili kwa mwaka ghwakabili, kicu eki kyamuka haa weema ehi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Du̱mbi̱ Banai̱saaleeli̱ baatandika ku̱lu̱gha mu elungu lya Si̱naai̱, baakala mbanalu̱gha mu ki̱i̱kalo kimui kandi mbanaghoona mu ki̱i̱kalo kinji ku̱hi̱ki̱ya obu kicu eki kyemiliiye mu elungu lya Palaani̱. ");
INSERT INTO tlj_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Olu niiluwo lwabaaye lughendo lwabo lwʼoku̱du̱bha ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Bantu baa ntu̱la ya Yu̱da niibo baadu̱bhi̱ye kughenda baamu̱ki̱i̱ye bhendela yabo, kusighikila haa ntu̱la syabo. Naasoni̱ mutabani̱ wa Aminadaabbu niiye akaba ali mukulu wa mahe ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Bantu baa ntu̱la ya I̱sakaali baaba baakabili. Netaneeli̱ mutabani̱ wa Juhala niiye akaba ali mukulu wa mahe ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Bantu baa ntu̱la ya Jabbu̱looni̱ baalabhʼo, Eli̱yaabbu mutabani̱ wa Heloni̱ niiye akaba ali mukulu wa mahe ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Du̱mbi̱ Baleevi̱ baasakaalula weema ehi̱ki̱li̱i̱ye kandi basaasa bʼomu ntu̱la ya Bageli̱sooni̱ na bʼomu ntu̱la ya Melaali̱ baaghiheeka kandi baalabhʼo kughenda. ");
INSERT INTO tlj_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Bantu baa ntu̱la ya Leu̱bbeeni̱ baalabhʼo, baamu̱ki̱i̱ye bhendela yabo. Elijuula mutabani̱ wa Sedula niiye akaba ali mukulu wa mahe ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Bantu baa ntu̱la ya Si̱mi̱yooni̱ baalabhʼo. Selu̱myeli̱ mutabani̱ wa Yulisadaai̱ niiye akaba ali mukulu wa mahe ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Bantu baa ntu̱la ya Gaadi̱ baalabhʼo. Eli̱yasaafu mutabani̱ wa Deu̱weli̱ niiye akaba ali mukulu wa mahe ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Du̱mbi̱ bantu baa ntu̱la ya Bakohati̱ baalabhʼo, baheeki̱ye bintu bi̱hi̱ki̱li̱i̱ye. Weema ehi̱ki̱li̱i̱ye ekaba eli na kukweluwa mu ki̱i̱kalo kihyaka ebo batakaki̱dhi̱yeyo. ");
INSERT INTO tlj_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Bantu baa ntu̱la ya Efulahi̱mu̱ baalabhʼo, baamu̱ki̱i̱ye bhendela yabo. Eli̱sama mutabani̱ wa Ami̱hu̱di̱ niiye akaba ali mukulu wa mahe ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Bantu baa ntu̱la ya Manase baalabhʼo. Gamalyeli̱ mutabani̱ wa Pedajula niiye akaba ali mukulu wa mahe ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Bantu baa ntu̱la ya Bbenjami̱i̱ni̱ baalabhʼo. Abbidaani̱ mutabani̱ wa Gi̱di̱yooni̱ niiye akaba ali mukulu wa mahe ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Haakumaliilila, bantu baa ntu̱la ya Daani̱ baalabhʼo, baamu̱ki̱i̱ye bhendela yabo. Mahe ghaa bantu baa ntu̱la eghi niibo baalindagha enu̱ma sya Banai̱saaleeli̱ baanakyabo. Ahi̱yejeeli̱ mutabani̱ wa Amisadaai̱ niiye akaba ali mukulu wa mahe ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Bantu baa ntu̱la ya Aseli̱ baalabhʼo. Pagi̱yeeli̱ mutabani̱ wa Okulaani̱ niiye akaba ali mukulu wa mahe ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Bantu baa ntu̱la ya Nafutaali baalabhʼo. Ahi̱la mutabani̱ wa Enani̱ niiye akaba ali mukulu wa mahe ghaabo. ");
INSERT INTO tlj_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Mahe ghaa Banai̱saaleeli̱ niikuwo ghaaghendagha ghalabhaane ku̱lu̱gha mu ki̱i̱kalo kimui kughenda mu ki̱i̱kalo kinji, kusighikila haa ntu̱la syabo. ");
INSERT INTO tlj_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Musa aaghila Hobbaabbu mutabani̱ wa nkyame siye Leu̱weli̱ Munami̱di̱yaani̱ ati, “Tuli haai kughenda mu ki̱i̱kalo eki Mukama aaghi̱li̱ye ati, ‘Nkubaha ki̱i̱kalo eki.’ Wiise oghende naatu, tukukukola kusemeeye, nanga Mukama aalaghi̱i̱sani̱i̱ye kukolela etu̱we Banai̱saaleeli̱ bintu bilungi.” ");
INSERT INTO tlj_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Bhaatu Hobbaabbu aamughila ati, “Bbaa, tankughenda. Nkukuuka mu ehanga lya ewaatu kandi mu nganda syanje.” ");
INSERT INTO tlj_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Bhaatu Musa aamughila ati, “Gutu otatu̱lu̱ghʼo. Omani̱ye bi̱i̱kalo mu elungu hambali tukugubha kughoona. Otutwale mu bi̱i̱kalo ebi. ");
INSERT INTO tlj_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Kaakuba oghenda naatu, tukukuha haa bintu bilungi byona ebi Mukama akutuha.” ");
INSERT INTO tlj_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Nahabweki Banai̱saaleeli̱ baalu̱gha haa mwena ghwa Mukama kandi baalubhatanga lughendo lwa bilo bisatu. Sandu̱u̱ku̱ ya ndaghaano ya Mukama yaaghenda ebahikiiye bilo bisatu ebi kubatungila ki̱i̱kalo hambali bakuhuumulila. ");
INSERT INTO tlj_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Kicu kya Mukama kyasagha eghulu yabo ntangaali̱, baakabaagha mbalu̱gha hambali baghooneeye. ");
INSERT INTO tlj_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Bwile bwona abaheeki̱ye sandu̱u̱ku̱ ya ndaghaano baakatandikagha kughenda, Musa aghila ati, “Ai̱ Mukama oomuke! Ngi̱ghu̱ syawe sihanjikane kandi abakwohi̱ye bakuuluke.” ");
INSERT INTO tlj_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Bwile bwona abaheeki̱ye sandu̱u̱ku̱ eghi baakeemililagha, Musa aaghila ati, “Ai̱ Mukama, okuuke mu nku̱mi̱ na nku̱mi̱ sya Banai̱saaleeli̱.” ");
INSERT INTO tlj_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Banai̱saaleeli̱ baatandika kutongana Mukama anategheleei̱ye haabwa bijibu ebi baatu̱ngi̱ye. Obu Mukama aaghu̱u̱ye eki, aasaaliluwa kwonini. Du̱mbi̱ mulilo ghwa Mukama ghwaka kandi ghwoki̱ya bimui haa bi̱i̱kalo bya kumaliilila kwa hambali baghooneeye. ");
INSERT INTO tlj_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Obu bantu aba baataaghi̱ye ewaa Musa, aasaba ewaa Mukama kandi mulilo oghu ghwali̱ma. ");
INSERT INTO tlj_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Nahabweki ki̱i̱kalo eki baakighilamu Tabbela, nanga mulilo ku̱lu̱gha ewaa Mukama ghukaaka mu bantu aba. ");
INSERT INTO tlj_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Bamui mu banamahanga abaaghendagha na Banai̱saaleeli̱ bakaba babbali̱ye munu kuliya nyama kandi Banai̱saaleeli̱ nabo dhee baatandika kutaagha mbaghila bati, “Tukwekumbula kuliya nyama! ");
INSERT INTO tlj_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Twasu̱ki̱ye nsu̱i̱ esi twaliyagha mu nsi ya Mi̱si̱li̱ esi tutaghu̱li̱ye. Twaliyagha dhee cucumba, meloni̱, bu̱tu̱ngu̱lu̱ buunabwana, matu̱ngu̱lu̱ na bu̱tu̱ngu̱lu̱su̱mu̱. ");
INSERT INTO tlj_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Bhaatu endindi maani̱ ghaatuhooye, muntu taakyabona byokuliya binji, kuuyʼo maanu eni yonkaha!” ");
INSERT INTO tlj_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Maanu ekaba esu̱si̱ye nga kasigho kati̱i̱ kanjelu. ");
INSERT INTO tlj_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Banai̱saaleeli̱ baaghendagha kandi bakumaani̱ya maanu, baghisiya haa lubengo kedha baghisekula mu musekulo. Baaghiteekelagha mu minagha kandi bakolamu keeki̱ kandi syanulagha nga migaati̱ bateekeei̱ye mafu̱ta ghaa biti oli̱va. ");
INSERT INTO tlj_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Ki̱me kyakakwatagha hambali baghooneeye mukilo, du̱mbi̱ maanu elaghalika hansi. ");
INSERT INTO tlj_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Musa aaghu̱wa ngoku bantu aba bakwete kutongana, bu̱li̱ omui ali haa mulyango ghwa weema yee. Mukama aasaaliluwa kwonini na bantu aba kandi Musa aatamuwa. ");
INSERT INTO tlj_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Musa aabu̱u̱li̱ya Mukama ati, “Si̱ye mu̱heeleli̱ya waawe wandeeteeye kijibu kini nangaaki? Nkiki naaku̱koli̱ye ekyakutami̱ye kumpa mulimo ghutimbiikaane ghwa kuba mwebembeli̱ wa bantu bani? ");
INSERT INTO tlj_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Bantu aba taali̱i̱si̱ye esebo. Buuye ni̱i̱si̱ye nkababyala? Nkiki ki̱leki̱ye nongila oti, ‘Obaheeke haa ki̱ku̱bha kyawe ngoku mukali̱ akuheekagha mwana oghu akwonki̱ya kandi mbaki̱dhi̱ye mu nsi eghi waalahiiye kuha baataata baabo?’ ");
INSERT INTO tlj_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Buuye nkuuya haa nyama sya kuha bantu aba boona? Bakuukalagha mbataagha nanje bati, ‘Otuhe nyama sya kuliya!’ ");
INSERT INTO tlj_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Si̱ye nenkaha tankugubha kuba mwebembeli̱ wa bantu aba. Mulimo oghu ghuntimbikilaane kwonini. ");
INSERT INTO tlj_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Okaakuba haaliikuwo okuntwalikani̱ya otiyo, nkwesengeleei̱ye gutu ongilile kisa kandi onjite bwangu, niikuwo ndeke kubona-bona ntiyo kuloleelela bantu aba.” ");
INSERT INTO tlj_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Mukama aaghila Musa ati, “Okumaani̱ye beebembeli̱ nsanju̱ aba omani̱ye nga beebembeli̱ baa Banai̱saaleeli̱. Oleete bantu aba haa weema ya kusanga-sangaanamu kandi beemililʼo naawe. ");
INSERT INTO tlj_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Nku̱su̱ndu̱ka haa weema eghi kandi mbu̱ghe naawe. Du̱mbi̱ nkuuya haa maani̱ ghaa Mwoyo wanje agha oli nagho kandi nkuha haa maani̱ agha bantu aba. Bakukukoonela haa mulimo ghwa kuloleelela bantu aba, niikuwo oleke kughukola wenkaha. ");
INSERT INTO tlj_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Oghambile Banai̱saaleeli̱ oti, ‘Mweyeli̱ye kweteekani̱li̱ja kilo kya munkiya, nanga mukuliya nyama. Mukama aaghu̱u̱ye ngoku mukwete kutaagha muti, “Tukwekumbula kuliya nyama! Twabaagha kusemeeye mu nsi ya Mi̱si̱li̱!” Nahabweki Mukama akubaha nyama sya kuliya. ");
INSERT INTO tlj_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Tamukuliya nyama esi haabwa kilo kimui, kedha bibili, kedha bitaano, kedha eku̱mi̱ kedha maku̱mi̱ abili. ");
INSERT INTO tlj_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Bhaatu mukuliya nyama esi haabwa kweli̱ kwona, ku̱hi̱ki̱ya sibatami̱ye, nanga mwabhengi̱ye Mukama, oghu aakaaye mu enu̱we kandi mwataagha muti nguli mutaalu̱ghi̱ye mu nsi ya Mi̱si̱li̱.’ ” ");
INSERT INTO tlj_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Musa aaghila Mukama ati, “Ndi hani na basaasa mitwalo nkaagha. Bhaatu niibuwo waaghila oti, ‘Nkubaha nyama sya kuliya haabwa kweli̱ kwona!’ ");
INSERT INTO tlj_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Buuye nankabha basala bisolo bikaniiye kimui, bantu aba bakugubha kutunga nyama esikubamala? Nankabha bakumaani̱ya nsu̱i̱ syona esili mu nanja, buuye sikugubha kumala bantu aba?” ");
INSERT INTO tlj_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Mukama aakuukamu Musa ati, “Buuye mukono ghwa Mukama ghu̱di̱i̱di̱ye? Nahabweki nkaakuba ninaabu̱ghi̱ye majima kedha bisubha okubona!” ");
INSERT INTO tlj_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Nahabweki Musa aatuwa kandi aaghambila bantu ebi Mukama aabu̱ghi̱ye. Aakumaani̱ya bengei̱ nsanju̱ baa Banai̱saaleeli̱, beemilila kandi beeli̱ghi̱i̱li̱li̱ya weema ehi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Du̱mbi̱ Mukama aasu̱ndu̱ka ali mu kicu kandi aabu̱gha na Musa. Aamuuyʼo ghamui haa maani̱ ghaa Mwoyo agha aabaagha amuhaaye kandi aaghaha bengei̱ nsanju̱ aba. Mwoyo akaba makabaasʼo, baalangilila ebikubʼo, bhaatu tabaatodhi̱ye beeyongela kukikola. ");
INSERT INTO tlj_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Basaasa babili Elidaadi̱ na Medaadi̱, bakaba batali mu bengei̱ aba, bakaba bati̱ghaaye hambali Banai̱saaleeli̱ baghooneeye. Bakaba bahandi̱i̱ku̱u̱we mu muhendo ghwa bengei̱ nsanju̱ aba, bhaatu ebo bataaghenda haa weema ehi̱ki̱li̱i̱ye. Bhaatu nabo dhee baatunga haa maani̱ ghaa Mwoyo oghu kandi baatandika kulanga hambali bantu baghooneeye. ");
INSERT INTO tlj_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Mutabhana aali̱gi̱ta kandi aaghambila Musa ati, “Elidaadi̱ na Medaadi̱ niibuwo baalangilila hambali bantu baghooneeye.” ");
INSERT INTO tlj_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Yosuwa mutabani̱ wa Nu̱u̱ni̱, oghu ku̱lu̱gha mu buujongo buwe aakoonelagha Musa haa mulimo, aaghila ati, “Mukama wanje Musa, obatange.” ");
INSERT INTO tlj_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Bhaatu Musa aamughila ati, “Okwatu̱u̱we etima haabwanje? Nkwekumbula bantu baa Mukama boona baba balangi̱ kandi Mukama abaha Mwoyo wee!” ");
INSERT INTO tlj_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Du̱mbi̱ Musa na bengei̱ baa Banai̱saaleeli̱ aba boona baakuuka hambali bantu baghooneeye. ");
INSERT INTO tlj_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Mukama aatuma mwegha kandi ghwahu̱ngi̱ya nkwali ku̱lu̱gha haa nanja. Syasu̱nda hansi hoona kweli̱ghi̱i̱li̱li̱ya hambali Banai̱saaleeli̱ baghooneeye. Nkwali esi syakanila kimui ku̱hi̱ka haai lughendo lwa muntu lwa kilo kimui haa mpande syona hambali baghooneeye. ");
INSERT INTO tlj_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Bantu aba boona baamuka kilo eki mukilo na ntangaali̱ na kilo ekyalabhi̱yʼo kandi baakumaani̱ya nkwali esi kandi oghu aakumaani̱yagha sikee aasu̱li̱ya haai bighegha eku̱mi̱. Bu̱li̱ muntu aanikila nkwali siye hansi kweli̱ghi̱i̱li̱li̱ya hambali baghooneeye ku̱syomeleli̱ya. ");
INSERT INTO tlj_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Obu baatandikagha kuliya nyama esi kandi sinali mu kanu̱wa kaabo, Mukama aasaaliluwa kwonini na bantu aba kandi aabaha kifubilo kya ndwala yamaani̱ kandi yaata bakani̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Nahabweki ki̱i̱kalo eki baakighilamu Ki̱bbu̱loti̱-hatava, nanga bakajiikamu bantu bakani̱ye abeekumbuuye kuliya nyama. ");
INSERT INTO tlj_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Obu Banai̱saaleeli̱ baalu̱ghi̱ye Ki̱bbu̱loti̱-hatava, baaghenda Hajelooti̱ kandi baaghoonayo. ");
INSERT INTO tlj_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Musa aaswela mukali̱ Munaku̱u̱si̱ kandi Mi̱li̱yamu na Alooni̱ baatandika ku̱bu̱ghʼo kubhi Musa haabwa kuswela mukali̱ oghu. ");
INSERT INTO tlj_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Baaghila bati, “Buuye Mukama aku̱bu̱ghagha naakwamila mwa Musa enkaha? Taaku̱bu̱ghagha dhee naakwamila mu etu̱we?” Mukama aaghu̱wa ebi bakwete ku̱bu̱gha. ");
INSERT INTO tlj_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Musa akaba ali musaasa mu̱dhooti̱ kandi akaba ali mu̱dhooti̱ kusaali̱ya bantu boona abali munsi. ");
INSERT INTO tlj_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Du̱mbi̱ Mukama aaghila Musa, Alooni̱ na Mi̱li̱yamu ati, “Enu̱we basatu mwise haa weema ya kusanga-sangaanamu.” Nahabweki bantu basatu aba baaghenda haa weema eghi. ");
INSERT INTO tlj_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Mukama aasu̱ndu̱ka ali mu mpaghi ya kicu, aamilila haa mulyango ghwa weema eghi kandi aabilikila Alooni̱ na Mi̱li̱yamu. Obu bombi baamwebi̱ngi̱ye, ");
INSERT INTO tlj_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","aabaghila ati, “Mu̱tegheeleli̱ye ebi ndimabu̱gha, “Kaakuba mulangi̱ aba mu enu̱we, si̱ye Mukama nkumweyoleka mu kubonekeluwa kandi mbu̱ghe naye mu ndooti̱. ");
INSERT INTO tlj_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Bhaatu tanku̱bu̱ghagha ntiyo na mu̱heeleli̱ya wanje Musa. Niiye muntu oghu neesi̱ghi̱ye mu bantu boona kwebembela bantu banje. ");
INSERT INTO tlj_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Nku̱bu̱ghagha naye tubonangaane haali̱i̱so na haali̱i̱so. Tubonangaane bbeni̱-bbeni̱ etali mu nsi̱mo kandi akubonagha ngoku si̱ye Mukama nsu̱si̱ye. Nkiki kyaleki̱ye mutoobaha ku̱bu̱ghʼo kubhi mu̱heeleli̱ya wanje Musa?” ");
INSERT INTO tlj_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Mukama aasaaliluwa kwonini na Alooni̱ na Mi̱li̱yamu kandi aabalu̱ghʼo. ");
INSERT INTO tlj_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Obu kicu kyalu̱ghi̱ye haa weema eghi, du̱mbi̱ Mi̱li̱yamu aalwala ntumbi, mubili ghuwe ghwafooka ghunjelu nga bilika. Obu Alooni̱ eegaai̱ye kulola Mi̱li̱yamu, aabona Mi̱li̱yamu alwaye ntumbi. ");
INSERT INTO tlj_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Alooni̱ aaghila Musa ati, “Gutu, mukama wanje, otatufubila haabwa kibhi kini eki twakoli̱ye nanga budhoma bwatu. ");
INSERT INTO tlj_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Otaleka Mi̱li̱yamu kuba nga mwana oghu abyauwe aku̱u̱ye kandi oghu kimui kyakabili kya mubili ghuwe ki̱gu̱ndi̱ye.” ");
INSERT INTO tlj_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Musa aasaba neesengeleli̱ya Mukama ati, “Ai̱ Luhanga, gutu oki̱li̱ye Mi̱li̱yamu!” ");
INSERT INTO tlj_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Mukama aakuukamu Musa ati, “Ese wa Mi̱li̱yamu nguli aaniiye aamu̱tu̱u̱ye matanta haali̱i̱so, buuye Mi̱li̱yamu tangu̱hemu̱ki̱ye haabwa bilo musanju̱? Muleke aakale enja ya hambali Banai̱saaleeli̱ baghooneeye haabwa bilo musanju̱, haanu̱ma ya bilo ebi akugubha kukuuka hambali baghooneeye.” ");
INSERT INTO tlj_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Nahabweki Mi̱li̱yamu aakala enja ya hambali baghooneeye haabwa bilo musanju̱ kandi Banai̱saaleeli̱ tabaalu̱ghi̱ye mu ki̱i̱kalo eki ku̱hi̱ki̱ya obu baamu̱ku̱u̱ki̱i̱ye hambali baghooneeye. ");
INSERT INTO tlj_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Haanu̱ma yʼeki, Banai̱saaleeli̱ baalu̱gha Hajelooti̱ kandi baghoona mu elungu lya Palaani̱. ");
INSERT INTO tlj_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Otume bamui mu basaasa kughenda kandi kubega nsi ya Kanaani̱, eghi ndimaha Banai̱saaleeli̱. Mu bu̱li̱ ntu̱la haa ntu̱la eku̱mi̱ nʼebili sya Banai̱saaleeli̱, okomemu musaasa omui mwebembeli̱ wa ntu̱la eghi.” ");
INSERT INTO tlj_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Nahabweki Musa aakola ngoku Mukama aamulaghiiye kandi aabatuma ku̱lu̱gha mu elungu lya Palaani̱. Basaasa aba boona bakaba bali beebembeli̱ baa Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Ghani niigho mali̱i̱na ghaabo: Samuha mutabani̱ wa Jakula, ku̱lu̱gha mu ntu̱la ya Leu̱bbeeni̱. ");
INSERT INTO tlj_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Safati mutabani̱ wa Hooli̱, ku̱lu̱gha mu ntu̱la ya Si̱mi̱yooni̱. ");
INSERT INTO tlj_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Kelebbu mutabani̱ wa Yefune, ku̱lu̱gha mu ntu̱la ya Yu̱da. ");
INSERT INTO tlj_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Igali̱ mutabani̱ wa Yojeefu̱, ku̱lu̱gha mu ntu̱la ya I̱sakaali. ");
INSERT INTO tlj_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Hoseya mutabani̱ wa Nu̱u̱ni̱, ku̱lu̱gha mu ntu̱la ya Efulahi̱mu̱. ");
INSERT INTO tlj_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Pali̱ti̱ mutabani̱ wa Lafu, ku̱lu̱gha mu ntu̱la ya Bbenjami̱i̱ni̱. ");
INSERT INTO tlj_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Gadyeli̱ mutabani̱ wa Sodi̱, ku̱lu̱gha mu ntu̱la ya Jabbu̱looni̱. ");
INSERT INTO tlj_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Gaadi̱ mutabani̱ wa Su̱si̱, ku̱lu̱gha mu ntu̱la Manase, eghi baaghilaghamu ya Yojeefu̱. ");
INSERT INTO tlj_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Amyeli̱ mutabani̱ wa Gemaali̱, ku̱lu̱gha mu ntu̱la ya Daani̱. ");
INSERT INTO tlj_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Setu̱lu̱ mutabani̱ wa Mikai̱li̱, ku̱lu̱gha mu ntu̱la ya Aseli̱. ");
INSERT INTO tlj_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Nahabbi̱ mutabani̱ wa Vofi̱si̱, ku̱lu̱gha mu ntu̱la ya Nafutaali. ");
INSERT INTO tlj_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gaweli̱ mutabani̱ wa Maaki̱, ku̱lu̱gha mu ntu̱la ya Gaadi̱. ");
INSERT INTO tlj_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Agha niigho mali̱i̱na ghaa basaasa aba Musa aatu̱mi̱ye kughenda kandi kubega nsi ya Kanaani̱. Hoseya mutabani̱ wa Nu̱u̱ni̱ Musa aamughilamu Yosuwa. ");
INSERT INTO tlj_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Musa aabatuma kughenda kandi kubega nsi ya Kanaani̱. Aabaghila ati, “Mukaaku̱ki̱dha mu nsi ya Kanaani̱, mukwamile mu elungu lya Negeebbu, du̱mbi̱ mukome elughulu mu kyalo kya bwena. ");
INSERT INTO tlj_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Mulole nsi eghi ngoku esu̱si̱ye kandi bantu abaakaayemu bakaakuba bali na maani̱ kedha bali baceke, bakaakuba bali bakee kedha bakani̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Bantu aba baakaaye mu nsi ya mulingo ki? Esemeeye kedha ebhi̱i̱hi̱ye? Baakaaye mu maatau̱ni̱ ghaa mulingo ki? Taghali na bigho kedha ghali na bigho bikangami̱ye? ");
INSERT INTO tlj_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Etaka lyayo li̱su̱si̱ye li̱ti̱ya? Lili na ki̱li̱i̱si̱ya kedha bbaa? Nsi eghi elimu biti kedha bbaa? Mukole eki mukugubha kulola ngu mwaleeti̱ye bimui haa bi̱ghu̱ma bya mughanulo bya mu nsi eghi.” Bwile obu niibuwo mi̱jaabbi̱i̱bbu̱ yaatandikagha kwela. ");
INSERT INTO tlj_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Nahabweki basaasa aba baaghenda kandi baabega nsi ya Kanaani̱ yoona ku̱lu̱gha mu elungu lya Ji̱i̱ni̱ eku̱wa ku̱hi̱ka elughulu mu tau̱ni̱ ya Lehobbu̱ haai na kibugha kya Lebbo-hamati̱. ");
INSERT INTO tlj_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Baakoma kandi baakwamila mu elungu lya Negeebbu, baaki̱dha mu kibugha kya Hebbu̱looni̱, hambali ntu̱la ya Bahi̱maani̱, ya Basesaai̱, na ya Batalumaai̱ baasukulu baa Anaki̱ baabaagha baakaaye. (Kibugha kya Hebbu̱looni̱ bakakikwela haabwa myaka musanju̱ batakakweye kibugha kya Jowani̱ mu nsi ya Mi̱si̱li̱.) ");
INSERT INTO tlj_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Obu baaki̱dhi̱ye mu kighona kya Esi̱kooli̱, baajomba etai elyani̱yʼo mi̱jaabbi̱i̱bbu̱. Etai eli likaba li̱neeti̱ye kandi basaasa babili baaliheekela haa mpaghi. Baaleeta dhee bimui haa bi̱ghu̱ma bya mikomamahanga na bya biti mi̱ti̱i̱ni̱. ");
INSERT INTO tlj_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Ki̱i̱kalo eki baakighilamu kighona kya Esi̱kooli̱, nanga Banai̱saaleeli̱ bakajombayo etai elyani̱yʼo mi̱jaabbi̱i̱bbu̱ ekani̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Obu basaasa aba baamali̱ye bilo maku̱mi̱ anaa mbanabega nsi ya Kanaani̱, du̱mbi̱ baalu̱ghayo. ");
INSERT INTO tlj_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Basaasa aba baakuuka ewaa Musa, Alooni̱ na ki̱bbu̱la kyona kya Banai̱saaleeli̱ mu tau̱ni̱ ya Kadesi̱ mu elungu lya Palaani̱. Baaghambila Musa, Alooni̱ na ki̱bbu̱la kyona kya Banai̱saaleeli̱ ebi baaboone kandi baabooleka bi̱ghu̱ma ebi baahi̱ye mu nsi ya Kanaani̱. ");
INSERT INTO tlj_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Baaghila Musa bati, “Twaghendi̱ye mu nsi eghi waatu̱tu̱mi̱yemu, ekwete kusendamu mata na bwoki. Bini niibiyo bimui haa bi̱ghu̱ma bya mu nsi eghi. ");
INSERT INTO tlj_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Bhaatu bantu abaakaaye mu nsi eghi bali na maani̱, bibugha byamu bili na bigho bi̱gu̱mi̱ye kandi bikangami̱ye. Twabooneyo dhee baasukulu baa Anaki̱. ");
INSERT INTO tlj_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Bameleeki̱ baakaaye mu kyalo kya Negeebbu. Bahi̱ti̱, Bayebu̱si̱ na Bamooli̱ baakaaye mu kyalo kya bwena. Banakanaani̱ baakaaye haai na nanja Medi̱teleni̱yani̱ kandi haai na maasi Yolodaani̱.” ");
INSERT INTO tlj_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Du̱mbi̱ Kelebbu aaholeesi̱ya bantu aba mu maaso ghaa Musa kandi aaghila ati, “Tuli na kughenda kandi kutwala nsi eghi, nanga tukugubha kughikwata.” ");
INSERT INTO tlj_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Bhaatu basaasa abaaghendi̱ye na Kelebbu oghu baaghila bati, “Tatukugubha ku̱lu̱mba bantu aba, nanga batusaaye maani̱.” ");
INSERT INTO tlj_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Baatandika kulalangi̱ya makulu ghabhi̱i̱hi̱ye mu Banai̱saaleeli̱ aghakwetʼo nsi ya Kanaani̱ eghi baabegi̱ye, mbaghila bati, “Nsi eghi twabegi̱ye eneeteeye kimui kandi tatukugubha kughikwata. Bantu aba twabooneyo boona bakangami̱ye kwonini. ");
INSERT INTO tlj_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Twabooneyo bantu baamaani̱ baasukulu baa Anaki̱ ku̱lu̱gha mu Banefi̱li̱. Obu twelengeesani̱i̱ye na Banefi̱li̱ aba, twaboone na maaso ghaatu tuli nga bu̱si̱ni̱ni̱ ewaa bantu aba kandi nabo niikuwo baatuboone batiyo dhee.” ");
INSERT INTO tlj_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Mukilo yoona ya kilo eki bantu boona bʼomu ki̱bbu̱la kya Banai̱saaleeli̱ baatandika kulila nʼelaka lyamaani̱. ");
INSERT INTO tlj_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Banai̱saaleeli̱ boona baatandika kutongana na Musa na Alooni̱. Ki̱bbu̱la kyona kya Banai̱saaleeli̱ baaghila Musa na Alooni̱ bati, “Kyangubaaye kilungi etu̱we ku̱kwi̱la mu nsi ya Mi̱si̱li̱ kedha mu elungu lini! ");
INSERT INTO tlj_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Mukama niibuwo aatutwala mu nsi hambali ngi̱ghu̱ syatu sikutwita na kihiyo nangaaki? Baku̱hu̱nga bakali̱ baatu na baana baatu kandi babatwale. Buuye takili kilungi etu̱we kukuuka mu nsi ya Mi̱si̱li̱?” ");
INSERT INTO tlj_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Baaghambilana bati, “Oleke twekomele mwebembeli̱ kandi tukuuke mu nsi ya Mi̱si̱li̱.” ");
INSERT INTO tlj_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Du̱mbi̱ Musa na Alooni̱ beegenga hansi makpu̱ngbu̱ mu maaso ghaa ki̱bbu̱la kyona kya Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Yosuwa mutabani̱ wa Nu̱u̱ni̱ na Kelebbu mutabani̱ wa Yefune, abaabaagha mu basaasa abaaghendi̱ye kubega nsi ya Kanaani̱, baatemula ngoye syabo. ");
INSERT INTO tlj_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Baaghila ki̱bbu̱la kyona kya Banai̱saaleeli̱ bati, “Nsi eghi twabungiiyemu kubega ni nsi eghi esemeeye kwonini. ");
INSERT INTO tlj_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Kaakuba Mukama adheedhuwa naatu, akututwala mu nsi eghi ekwete kusendamu mata na bwoki kandi akutuha nsi eghi. ");
INSERT INTO tlj_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Nahabweki mutajeemela Mukama kandi muleke kwobaha bantu abaakaaye mu nsi eghi, nanga tukubasi̱ngu̱la. Tibakyali na mu̱li̱ndi̱, bhaatu Mukama ali naatu. Muleke kwobaha bantu aba.” ");
INSERT INTO tlj_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Bhaatu ki̱bbu̱la kya Banai̱saaleeli̱ eki kyona kyatandika kuhanuula kuhuula mabaale Yosuwa na Kelebbu. Du̱mbi̱ Banai̱saaleeli̱ aba boona baabona ki̱ti̱i̱ni̱sa kya Mukama nkyaboneka haa weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Mukama aaghila Musa ati, “Bantu aba baku̱hi̱ki̱ya haa kungaya? Baku̱hi̱ki̱ya haa kubhenga ku̱mpi̱ki̱li̱ja, nankabha ninaakoli̱ye byakuswekani̱ya bikani̱ye mu bantu aba? ");
INSERT INTO tlj_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Nkubaata na ndwala ya kabhi kandi nkubahwelekeeleli̱ya. Bhaatu nkukufoola ehanga liinamu̱li̱to kandi lyamaani̱ kusaali̱ya bantu aba.” ");
INSERT INTO tlj_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Musa aaghila Mukama ati, “Gutu otahwelekeeleli̱ya bantu aba! Kaakuba okikola Banami̱si̱li̱ baku̱u̱ghu̱wa. Okaaya bantu aba mu Banami̱si̱li̱ na bu̱toki̱ bwawe bwamaani̱. ");
INSERT INTO tlj_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Banami̱si̱li̱ bakughambila Banakanaani̱ abaakaaye mu nsi eghi kintu eki. Banakanaani̱ aba bamani̱ye ngoku uwe Ai̱ Mukama, okuukalagha mu bantu baawe aba. Ai̱ Mukama bamani̱ye ngoku bantu baawe bakukubonagha haali̱i̱so na haali̱i̱so kandi ngoku mpaghi ya kicu yaawe ekuukalagha eghulu yabo. Bamani̱ye ngoku ntangaali̱ okughendagha ohikiiye bantu baawe mu mpaghi ya kicu kandi mukilo mu mpaghi ya mulilo. ");
INSERT INTO tlj_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Kaakuba bantu aba obaata haa mulundi ghumui, bantu bʼomu mahanga abaaghu̱u̱ye makulu ngoku oli na maani̱, bakughila bati, ");
INSERT INTO tlj_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Mukama taagu̱bhi̱ye kutwala bantu aba mu nsi eghi aalahiiye kubaha, niikiyo kyaleki̱ye aabaatila mu elungu.’ ");
INSERT INTO tlj_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Gutu Mukama, wooleke ngoku oli na maani̱ ghakani̱ye ngoku waabu̱ghi̱ye. Okaghila oti, ");
INSERT INTO tlj_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Si̱ye Mukama tankusaaliluwagha bwangu, ndi na kukunda kwamaani̱ kandi nkughanilagha bantu bintu bi̱bhi̱i̱hi̱ye ebi bakukolagha kandi nsobi̱ syabo. Bhaatu nkufubilagha baana haabwa bintu bi̱bhi̱i̱hi̱ye ebi beesebo bakukolagha ku̱hi̱ki̱ya haa mujo ghwakasatu na ghwakanaa ghwa baasukulu baabo.’ ");
INSERT INTO tlj_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Kusighikila haa kukunda kwamaani̱ kwawe, oghanile bantu aba kibhi kyabo, ngoku okubaghanilagha ku̱lu̱gha bwile baalu̱ghi̱ye mu nsi ya Mi̱si̱li̱ ku̱hi̱ki̱ya endindi.” ");
INSERT INTO tlj_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Mukama aamughila ati, “Naaghaniiye bantu aba, ngoku waasabi̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Bhaatu majima ngoku ndi mwomi̱i̱li̱ kandi ki̱ti̱i̱ni̱sa kyanje Mukama kimalakaki̱ye nsi yoona, ");
INSERT INTO tlj_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","taaliyo nʼomui mu bantu abaaboone ngoku ndi na ki̱ti̱i̱ni̱sa na byakuswekani̱ya ebi naakoli̱ye mu nsi ya Mi̱si̱li̱ na mu elungu, bhaatu baaghaya si̱ye kandi bandengesa milundi ekani̱ye, ");
INSERT INTO tlj_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","taaliyo nʼomui mu bantu aba oghu aku̱ki̱dha mu nsi eghi naalahiiye kuha baataata baabo. Taaliyo nʼomu mu bantu ababhengi̱ye si̱ye aba oghu akubona nsi eghi. ");
INSERT INTO tlj_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Bhaatu haabwa mu̱heeleli̱ya wanje Kelebbu kuba na mwoyo ghulungi kandi mutima ghusemeeye, nkuleka aki̱dhe mu nsi ya Kanaani̱ eghi aaghendi̱ye kubega. Nsi eghi nkughiha baasukulu be kughitwala nga bugwetuwa bwabo. ");
INSERT INTO tlj_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Nahabweki ngoku Bameleeki̱ na Banakanaani̱ baakaaye mu bighona mu nsi eghi, mukuuke kandi mukwamile mu kihanda kyʼomu elungu ku̱ki̱dha haa Nanja Mutuku.” ");
INSERT INTO tlj_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Mukama aaghila Musa na Alooni̱ ati, ");
INSERT INTO tlj_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Ki̱bbu̱la kya bantu babhi eki ki̱ku̱hi̱ki̱ya haa kutongana nanje? Naaghu̱u̱ye ngoku Banai̱saaleeli̱ aba bakwete kutongana. ");
INSERT INTO tlj_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Nahabweki obaghile oti, ‘Si̱ye, Mukama, ngoku ndi mwomi̱i̱li̱, nkubakolʼo bintu byonini ebi naaghu̱u̱ye ni̱mu̱bu̱gha. ");
INSERT INTO tlj_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Enu̱we boona mu̱ku̱ku̱wa kandi mi̱ku̱ yaanu ekwandakaalala mu elungu lini. Musaasa weena oghu ali na myaka maku̱mi̱ abili ya bukulu na kusaalʼo, oghu Musa aabali̱ye kandi oghu aatongaane nanje aku̱ku̱wa. ");
INSERT INTO tlj_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Taaliyo nʼomui mu bantu aba oghu aku̱ki̱dha mu nsi eghi naalahiiye kuha enu̱we kuukalamu, kuuyʼo Kelebbu mutabani̱ wa Yefune na Yosuwa mutabani̱ wa Nu̱u̱ni̱. ");
INSERT INTO tlj_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Baana baanu bato aba mwaghi̱li̱ye muti ngi̱ghu̱ syanu si̱ku̱hu̱nga, niibo nkuleka baki̱dhe mu nsi eghi kandi badheedhuwe kuukala mu nsi eghi enu̱we mwabhengi̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Bhaatu enu̱we bantu bakulu, mi̱ku̱ yaanu ekwandakaalala mu elungu lini. ");
INSERT INTO tlj_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Baana baanu bakuba bali̱i̱si̱ya baa ntaama mu elungu lini haabwa myaka maku̱mi̱ anaa, bakubona-bona haabwa buteesighibuwa bwanu, ku̱hi̱ki̱ya enu̱we boona mu̱kwi̱li̱i̱ye mu elungu lini. ");
INSERT INTO tlj_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Basaasa baanu ngoku baamali̱ye bilo maku̱mi̱ anaa mbanabega nsi ya Kanaani̱, niikuwo mukumala myaka maku̱mi̱ anaa nimunafubiluwa haabwa bibhi byanu, mwaka ghumui haabwa kilo kimui kandi mukumanya ngoku nsaaluuwe.’ ");
INSERT INTO tlj_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Si̱ye, Mukama, ni̱i̱si̱ye naabu̱ghi̱ye. Nahabweki nkukolʼo bintu ebi ki̱bbu̱la kya bantu babhi eki, abeelungani̱i̱ye kubhenga si̱ye. Baku̱kwi̱la mu elungu lini kandi bahwelekeelele.” ");
INSERT INTO tlj_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Basaasa aba Musa aatu̱mi̱ye kubega nsi ya Kanaani̱ baakuuka. Baaha makulu ghabhi̱i̱hi̱ye aghaaleki̱ye ki̱bbu̱la kyona kya Banai̱saaleeli̱ baatongana na Mukama. ");
INSERT INTO tlj_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Bwile obu bwonini basaasa abaaleeti̱ye makulu ghabhi̱i̱hi̱ye aghakwetʼo nsi ya Kanaani̱ baatunga kifubilo kya ndwala eghi Mukama aabatumiiye kandi baaku̱wa. ");
INSERT INTO tlj_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Bhaatu mu basaasa eku̱mi̱ na babili aba Musa aatu̱mi̱ye kubega nsi ya Kanaani̱, abaakaaye banali boomi̱i̱li̱ ni Yosuwa mutabani̱ wa Nu̱u̱ni̱ na Kelebbu mutabani̱ wa Yefune. ");
INSERT INTO tlj_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Obu Musa aaghambiiye Banai̱saaleeli̱ boona ebi Mukama aabu̱ghi̱ye, bantu aba beeghunga kwonini. ");
INSERT INTO tlj_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Nkyambisi cu̱i̱ Banai̱saaleeli̱ baamuka kandi baani̱i̱na mu kyalo kya bwena. Baaghila bati, “Twasi̱i̱si̱ye, bhaatu tweteekani̱i̱je kughenda mu ki̱i̱kalo eki Mukama aalaghi̱i̱sani̱i̱ye kutuha.” ");
INSERT INTO tlj_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Bhaatu Musa aabaghila ati, “Mukwete kughaya eki Mukama aalaghiiye nangaaki? Eki mukwete kubbala takikubʼo! ");
INSERT INTO tlj_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Mutaghenda mu kyalo kya bwena eki, nanga Mukama taali naanu kandi ngi̱ghu̱ syanu sikubasi̱ngu̱la. ");
INSERT INTO tlj_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Bameleeki̱ na Banakanaani̱ bakulwana naanu mu ki̱i̱kalo eki, nanga mwalu̱ghi̱yʼo Mukama, akuba atali hamui naanu kandi ngi̱ghu̱ syanu sikubaata na kihiyo.” ");
INSERT INTO tlj_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Bhaatu bantu aba baabhenga ku̱u̱ghu̱wa Musa. Nahabweki Musa aati̱ghala hambali baabaagha baghooneeye na sandu̱u̱ku̱ ya ndaghaano ya Mukama. Bhaatu bantu aba baani̱i̱na mu kyalo kya bwena eki. ");
INSERT INTO tlj_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Du̱mbi̱ Bameleeki̱ na Banakanaani̱ abaakalagha mu kyalo kya bwena, baasa kandi baalu̱mba Banai̱saaleeli̱. Baasi̱ngu̱la Banai̱saaleeli̱ kandi baabahuma ku̱hi̱ka mu tau̱ni̱ ya Holu̱ma. ");
INSERT INTO tlj_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Oghile Banai̱saaleeli̱ oti, ‘Mukaaku̱ki̱dha mu nsi eghi ndimabaha kandi nimwakalamu, ");
INSERT INTO tlj_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","muhaagheyo ewaa Mukama bihonguwa byona byokeei̱ye ku̱lu̱gha mu nte, ntaama kedha mbu̱li̱ syanu, ebi kusasa kwabiyo ku̱dheedhi̱ye Mukama. Bihonguwa ebi bikugubha kuba bihonguwa bookeei̱ye haa mulilo, bihonguwa bya ku̱u̱su̱li̱i̱si̱ya kilahilo, kedha bihonguwa ebi muntu akuhaayo haabwa kubbala kuwe, kedha bihonguwa bya ki̱ghenu̱. ");
INSERT INTO tlj_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Muntu oghu alaleetagha kihonguwa kiye ewaa Mukama, aleetaghe dhee kihonguwa kya bilimuwa ki̱lo emui ya nsyano esemeeye, eghi etabuuyemu li̱ta emui ya mafu̱ta ghaa biti oli̱va. ");
INSERT INTO tlj_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Bu̱li̱ kyana kya ntaama kedha mbu̱li̱ eki muntu alahaaghayo nga kihonguwa kyona kyokeei̱ye, ali na kuleeta dhee li̱ta emui ya vi̱i̱ni̱ kuba kihonguwa kyakunuwa. ");
INSERT INTO tlj_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘Obu muntu alabaagha naahayo kihonguwa kya ntu̱u̱li̱ ya ntaama, ataaghʼo kihonguwa kya bilimuwa ki̱lo ebili sya nsyano esemeeye, eghi etabuuyemu li̱ta emui nʼeki̱twi̱ke ya mafu̱ta ghaa biti oli̱va. ");
INSERT INTO tlj_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Muntu oghu aheyo dhee kihonguwa kyakunuwa li̱ta emui nʼeki̱twi̱ke ya vi̱i̱ni̱ kuba kihonguwa eki kusasa kwakiyo ku̱dheedhi̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘Kaakuba muntu aabbala kuhaayo ntu̱u̱li̱ ya nte nga kihonguwa kyona kyokeei̱ye, kedha kihonguwa kya kilahilo, kedha kihonguwa kya bu̱si̱nge ewaa Mukama, ");
INSERT INTO tlj_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","aleete dhee ntu̱u̱li̱ ya nte na kihonguwa kya bilimuwa ki̱lo esatu sya nsyano esemeeye, eghi etabuuyemu li̱ta ebili sya mafu̱ta ghaa biti oli̱va. ");
INSERT INTO tlj_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Muntu oghu aleetaghe dhee kihonguwa kyakunuwa li̱ta ebili sya vi̱i̱ni̱, kuba kihonguwa bookeei̱ye haa mulilo, eki kusasa kwakiyo ku̱dheedhi̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Oli na kukola otiyo haabwa bu̱li̱ ntu̱u̱li̱ ya nte, ntu̱u̱li̱ ya ntaama, kyana kya ntaama kedha mbu̱li̱. ");
INSERT INTO tlj_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Haaliikuwo waakolagha bu̱li̱ kimui haa bintu ebi mabihonga noosighikila haa muhendo ghwabiyo. ");
INSERT INTO tlj_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘Banai̱saaleeli̱ boona bakolaghe batiyo obu balabaagha mbahayo kihonguwa bookeei̱ye haa mulilo, eki kusasa kwakiyo ku̱dheedhi̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Mu mijo yaanu yoona eghi ekwisa, kaakuba munamahanga kedha muntu oghu aakaaye naanu, abbala kuhaayo kihonguwa bookeei̱ye haa mulilo, eki kusasa kwakiyo ku̱dheedhi̱ye Mukama, ali na kukola ngoku enu̱we mukukolagha. ");
INSERT INTO tlj_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Mu ki̱bbu̱la kyanu bilaghilo bya kuhonga ni bimui ewaanu na banamahanga abaakaaye naanu. Bilaghilo ebi ni bya bilo nʼebilo mu mijo yaanu yoona, nanga enu̱we na banamahanga aba, muli na ku̱hu̱ti̱ya bilaghilo bya Mukama. ");
INSERT INTO tlj_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Bilaghilo na ndaghikiililo ebi̱lemi̱ye enu̱we, niibiyo bi̱lemi̱ye dhee banamahanga abaakaaye naanu.’ ” ");
INSERT INTO tlj_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Oghile Banai̱saaleeli̱ oti, ‘Mukaaku̱ki̱dha mu nsi eghi ndimabatwalamu ");
INSERT INTO tlj_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","kandi nimwaliya bimui haa byokuliya bya mu nsi eghi, muhaagheyo kihonguwa kya mbaghani̱ja ewaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Muli na kuhonga migaati̱ ku̱lu̱gha mu mughanulo ghwa nsyano yaanu. Muli na kukola eki obu mukuba nimuhayo kihonguwa kya mbaghani̱ja kya nsyano eghi mwadu̱bhi̱ye kusiya haa lubengo. ");
INSERT INTO tlj_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Muli na kuhaayo ewaa Mukama haa mughanulo ghwa nsyano esemeeye, nga kihonguwa mu mijo yaanu yoona eghi ekwisa. ");
INSERT INTO tlj_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘Kaakuba mutakighendeleeye musaaghuwa kukwata kimui haa bilaghilo ebi Mukama aahaaye Musa, ");
INSERT INTO tlj_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","kimui haa bilaghilo byona ebi Mukama aahaaye Musa kughambila enu̱we, ku̱lu̱gha haa kilo eki Mukama aabahaaye bilaghilo ebi na kweyongela mu mijo yaanu eghi ekwisa, ");
INSERT INTO tlj_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","kaakuba mukikola mutakighendeleeye kandi ki̱bbu̱la kya Banai̱saaleeli̱ kitamani̱ye, ki̱bbu̱la eki kyona kili na kuhaayo kihonguwa kya ntu̱u̱li̱ ya nte nga kihonguwa kyona kyokeei̱ye, eki kusasa kwakiyo ku̱dheedhi̱ye Mukama. Ki̱bbu̱la eki kili na kuhaayo dhee kihonguwa kya bilimuwa na kihonguwa kyakunuwa, kusighikila haa kilaghilo kandi kili na kuhaayo dhee ntu̱u̱li̱ ya mbu̱li̱ nga kihonguwa haabwa kibhi. ");
INSERT INTO tlj_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Mu̱hongi̱ ali na kukola mukolo ghwa kughaniluwa kwa ki̱bbu̱la kya Banai̱saaleeli̱ eki kandi bakughaniluwa, nanga baaki̱koli̱ye batakighendeleeye kandi baahaayeyo ewaa Mukama kihonguwa bookeei̱ye haa mulilo na kihonguwa haabwa kibhi. ");
INSERT INTO tlj_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Ki̱bbu̱la kya Banai̱saaleeli̱ kyona na banamahanga abaakaaye nabo bakughaniluwa, nanga bantu aba boona baabaaye mu kintu eki baasobeei̱ye batakighendeleeye. ");
INSERT INTO tlj_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘Bhaatu kaakuba muntu omui asi̱i̱sa atakighendeleeye, ali na kuleeta mbu̱li̱ yabukali̱ ya mwaka ghumui nga kihonguwa haabwa kibhi. ");
INSERT INTO tlj_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Mu̱hongi̱ ali na kuhonga mbu̱li̱ eghi mu maaso ghaa Mukama haabwa kughaniluwa kwa muntu oghu aakoli̱ye kibhi atakighendeleeye, haanu̱ma ya mukolo ghwa kughaniluwa oghu, muntu oghu akughaniluwa. ");
INSERT INTO tlj_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Eki nkilaghilo kimui ekikwetʼo muntu weena oghu aku̱si̱i̱sa atakighendeleeye, nankabha aba ali Munai̱saaleeli̱ kedha munamahanga oghu aakaaye naanu. ");
INSERT INTO tlj_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘Bhaatu muntu weena oghu aku̱si̱i̱sa akighendeleeye, abe Munai̱saaleeli̱ kedha munamahanga, akuba ambuuye Mukama kandi muntu oghu ali kubhinguwa mu Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Muntu oghu akuba aghai̱ye eki Mukama aabu̱ghi̱ye kandi atu̱u̱ye bilaghilo biye, ali na kubhinguwa mu Banai̱saaleeli̱ nanga musango ghu̱mu̱si̱ngi̱ye.’ ” ");
INSERT INTO tlj_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Obu Banai̱saaleeli̱ baabaagha mu elungu, bantu baasanga musaasa naaseena nkui haa kilo kya Sabhato. ");
INSERT INTO tlj_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Bantu abaamuboone naaseena nkui, baamuleeta ewaa Musa na Alooni̱ na ki̱bbu̱la kyona kya Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Baamuta mu nkomo, nanga bakaba batamani̱ye eki bakumukola. ");
INSERT INTO tlj_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Niibuwo Mukama aaghi̱li̱ye Musa ati, “Musaasa oghu ali na ku̱ku̱wa. Ki̱bbu̱la kyona kya Banai̱saaleeli̱ bali na ku̱mu̱twesi̱ya hanja ya hambali baghooneeye kandi bamuhuule mabaale.” ");
INSERT INTO tlj_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Nahabweki ki̱bbu̱la kyona kya Banai̱saaleeli̱ baatwesi̱ya musaasa oghu hanja ya hambali baghooneeye kandi baamuhuula mabaale aaku̱wa, ngoku Mukama aalaghiiye Musa. ");
INSERT INTO tlj_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Oghile Banai̱saaleeli̱ oti, ‘Mu mijo yaanu yoona, muli na kuta mighuwo ya mahu̱u̱ji̱ ejambi̱ye haa nsondo sya bi̱lu̱waalo byanu kandi haa bu̱li̱ mughuwo mutaaghʼo mahu̱u̱ji̱ ghaa langi̱ ya bbu̱lu̱lu̱. ");
INSERT INTO tlj_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Mighuwo ya mahu̱u̱ji̱ ejambi̱ye eghi ebe kaakulolelʼo kubaasu̱ki̱ya ku̱hu̱ti̱ya bilaghilo bya Mukama byona, niikuwo muteefoola nga baamalaaya kukola ebi mitima yaanu ekweghomba. ");
INSERT INTO tlj_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Mighuwo eghi ekubakoonela kuusuka ngoku muli na kukwata bilaghilo byanje byona kandi kuba bahi̱ki̱li̱i̱ye ewaa Luhanga waanu. ");
INSERT INTO tlj_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ni̱i̱si̱ye Mukama Luhanga waanu, oghu akabaaya mu nsi ya Mi̱si̱li̱ kuba Luhanga waanu. Ni̱i̱si̱ye Mukama Luhanga waanu.’ ” ");
INSERT INTO tlj_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Koola mutabani̱ wa I̱jali̱ kandi muusukulu wa Kohati̱ wʼomu ntu̱la ya Leevi̱, hamui na Dataani̱ na Abbilaamu batabani̱ baa Eli̱yaabbu na Oni̱ mutabani̱ wa Peleti̱ bʼomu ntu̱la ya Leu̱bbeeni̱, baajeemela Musa. ");
INSERT INTO tlj_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Baasoona-soona beebembeli̱ banji bi̱ku̱mi̱ bibili na maku̱mi̱ ataano aba bantu bahu̱ti̱i̱ye mu ki̱bbu̱la kya Banai̱saaleeli̱ kulungana nabo kuhakani̱ya Musa. ");
INSERT INTO tlj_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Bantu aba baaghenda nga ki̱bbu̱la kuhakani̱ya Musa na Alooni̱ kandi baabaghila bati, “Mwahingulani̱i̱ye kwebhi̱mba-bhi̱mbi̱ya! Ki̱bbu̱la kyona kya Banai̱saaleeli̱ ni bantu baa Mukama kandi Mukama ali hamui nabo. Buuye mukwete kwefoola muti muli na bu̱toki̱ kusaali̱ya bantu boona bʼomu ki̱bbu̱la kya Mukama nangaaki?” ");
INSERT INTO tlj_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Obu Musa aaghu̱u̱ye eki, eegenga hansi makpu̱ngbu̱. ");
INSERT INTO tlj_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Du̱mbi̱ aaghila Koola na baanakiye boona ati, “Munkiya nkyambisi Mukama akutwoleka muntu wee oghu aakomi̱yemu kandi oghu ahi̱ki̱li̱i̱ye. Musaasa oghu akukomamu niiye akumwebinga. ");
INSERT INTO tlj_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Uwe Koola na ki̱bbu̱la kyawe muli na kukola kini, mukwate bibindi bya ku̱tu̱mi̱kamu bubbani̱, ");
INSERT INTO tlj_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","munkiya mutemu mulilo kandi bubbani̱ mu maaso ghaa Mukama. Musaasa oghu Mukama akukomamu niiye akuba ahi̱ki̱li̱i̱ye. Enu̱we Baleevi̱ mwahingulani̱i̱ye kwebhi̱mba-bhi̱mbi̱ya!” ");
INSERT INTO tlj_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Musa aatodha aaghila Koola ati, “Endindi mu̱tegheeleli̱ye enu̱we Baleevi̱! ");
INSERT INTO tlj_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Buuye takibamali̱ye Luhanga wa I̱saaleeli̱ kukomamu enu̱we mu ki̱bbu̱la kya Banai̱saaleeli̱ banji kandi kuleeta enu̱we haai naye kukola mulimo haa weema ehi̱ki̱li̱i̱ye ya Mukama kandi kwemilila mu maaso ghaa ki̱bbu̱la kya Banai̱saaleeli̱ kubaheeleli̱ya? ");
INSERT INTO tlj_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Mukama niiye akaleeta uwe Koola na Baleevi̱ baanakyawe haai naye, bhaatu endindi niibuwo mwabbala dhee kuba bahongi̱. ");
INSERT INTO tlj_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Uwe na baanakyawe mwekumaani̱i̱ye hamui kuhakani̱ya Mukama. Buuye Alooni̱ niiye ani̱ enu̱we kutongana naye?” ");
INSERT INTO tlj_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Du̱mbi̱ Musa aatuma bantu kubilikila Dataani̱ na Abbilaamu batabani̱ baa Eli̱yaabbu. Bhaatu baaghila bati, “Bbaa, tatukwisa. ");
INSERT INTO tlj_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Buuye kutuuya mu nsi ya Mi̱si̱li̱ eghi ekwete kusendamu mata na bwoki, kwisa kandi kutwitila mu elungu lini takimali̱ye? Buuye endindi niibuwo waabbala dhee kuba mukama waatu? ");
INSERT INTO tlj_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Tookatu̱ki̱dhi̱i̱ye mu nsi eghi ekwete kusendamu mata na bwoki kandi tookatuhaaye bisaka bya kukolamu na misili ya mi̱jaabbi̱i̱bbu̱. Buuye okugubha kudimaaga bantu bani boona? Tatukwisa bbaa!” ");
INSERT INTO tlj_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Du̱mbi̱ Musa aasaaliluwa kwonini kandi aaghila Mukama ati, “Otasi̱i̱ma kihonguwa kya basaasa aba. Tankaayaghʼo bantu aba kintu kyona nankabha ndogooi̱ nʼemui kandi tankakoli̱ye kubhi muntu nʼomui mu basaasa aba.” ");
INSERT INTO tlj_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Musa aaghila Koola ati, “Munkiya uwe na ki̱bbu̱la kyawe mwise mu maaso ghaa Mukama kandi Alooni̱ akubʼo dhee. ");
INSERT INTO tlj_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Bu̱li̱ musaasa ali na kukwata kibindi kiye, atemu bubbani̱ kandi akileete mu maaso ghaa Mukama, bibindi bi̱ku̱mi̱ bibili na maku̱mi̱ ataano. Uwe na Alooni̱ bu̱li̱ omui ali na kuleeta dhee kibindi kiye.” ");
INSERT INTO tlj_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Nahabweki bu̱li̱ omui mu basaasa bʼomu ki̱bbu̱la kya Koola aakwata kibindi kiye, aataamu mulilo na bubbani̱ kandi beemilila hamui na Musa na Alooni̱ haa mulyango ghwa weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Du̱mbi̱ Koola aakumaani̱ya ki̱bbu̱la kya basaasa be boona haa mulyango ghwa weema ya kusanga-sangaanamu kandi beemilila balolaane na Musa na Alooni̱. Ki̱ti̱i̱ni̱sa kya Mukama kyabonekela ki̱bbu̱la kya Banai̱saaleeli̱ kyona. ");
INSERT INTO tlj_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Mukama aaghila Musa na Alooni̱ ati, ");
INSERT INTO tlj_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Mu̱lu̱ghe mu ki̱bbu̱la kya bantu eki, nkubbala ku̱hwelekeeleli̱ya bantu aba haa mulundi ghumui.” ");
INSERT INTO tlj_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Bhaatu Musa na Alooni̱ baagenga hansi makpu̱ngbu̱ kandi baaghila bati, “Ai̱ Luhanga, Luhanga oghu okuhaagha bantu boona bwomi̱i̱li̱. Kaakuba muntu omui asi̱i̱sa, buuye okusaaliluwa na ki̱bbu̱la kya Banai̱saaleeli̱ kyona?” ");
INSERT INTO tlj_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Du̱mbi̱ Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Oghambile ki̱bbu̱la kya Banai̱saaleeli̱ oti, ‘Mu̱lu̱ghe haai na weema ya Koola, ya Dataani̱ na ya Abbilaamu.’ ” ");
INSERT INTO tlj_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Du̱mbi̱ Musa aamuka kandi aaghenda ewaa Dataani̱ na ewaa Abbilaamu. Beebembeli̱ baa Banai̱saaleeli̱ baaghenda bamulabhi̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Musa aaghambila ki̱bbu̱la kya Banai̱saaleeli̱ ati, “Mu̱lu̱ghe haai na weema sya basaasa babhi aba. Mutaku̱ma haa kintu kyabo na kimui. Kaakuba mukola eki, Luhanga akubahwelekeeleli̱ya hamui na bantu aba haabwa bibhi byabo byona.” ");
INSERT INTO tlj_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Nahabweki Banai̱saaleeli̱ baalu̱gha haai na weema ya Koola, ya Dataani̱ na ya Abbilaamu. Dataani̱ na Abbilaamu bakaba bali enja kandi baamiliiye haa milyango ya weema syabo na bakali̱ baabo, baana baabo bakulu na bato. ");
INSERT INTO tlj_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Musa aaghila ati, “Endindi mukumanya ngoku Mukama antu̱mi̱ye kukola bintu bini byona kandi etali haabwa kubbala kwanje. ");
INSERT INTO tlj_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Kaakuba basaasa aba baku̱wa lu̱ku̱ lwa bu̱li̱ kilo ngoku bantu boona baku̱ku̱waagha, kikumani̱i̱si̱ya Mukama tantu̱mi̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Bhaatu kaakuba Mukama akola kwonini kintu ekitakabaaghʼo, aleka nsi yeesama kandi emela bantu aba na bintu byabo byona kandi bakota eku̱li̱mu̱ mu kituulo banaakaaye, du̱mbi̱ mukumanya ngoku bantu aba baaghai̱ye Mukama.” ");
INSERT INTO tlj_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Musa akaba makamala ku̱bu̱gha ebi byona, nsi hambali bantu aba baabaagha baamiliiye yaatikamu kabili, ");
INSERT INTO tlj_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","yeesama kandi yaammela bantu aba banaakaaye na bintu byabo byona. Yaammela dhee basaasa boona abaahagilagha Koola na bintu byabo byona. ");
INSERT INTO tlj_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Bantu aba baakota eku̱li̱mu̱ banaakaaye na bintu byabo byona. Nsi eghi yaabaswi̱ki̱la kandi baahwelekeelela mu ki̱bbu̱la kya Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Obu Banai̱saaleeli̱ baaghu̱u̱ye ngoku bantu aba bakwete kutakangana, baali̱gi̱ta mbagugangana bati, “Naatu nsi ekutumela dhee!” ");
INSERT INTO tlj_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Du̱mbi̱ mulilo ghwalu̱gha ewaa Mukama kandi ghwoki̱ya basaasa bi̱ku̱mi̱ bibili na maku̱mi̱ ataano abaahongagha bubbani̱. ");
INSERT INTO tlj_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Oghambile Eli̱yeeja mutabani̱ wa mu̱hongi̱ Alooni̱, kuuya bibindi ebilimu bubbani̱ mu mulilo oghu oghwokeei̱ye bintu ebi kandi ahanjaage ki̱bu̱ eki, nanga bibindi ebi bi̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Bibindi bya basaasa abaasi̱i̱si̱ye kandi kyaleka baahwelekeelela, bantu babiwiisemu na nondo sahaani̱ sya ku̱swi̱ki̱la haa kyakuhongelʼo bihonguwa, nanga bantu baabihongeeye Mukama kandi bi̱hi̱ki̱li̱i̱ye. Sahaani̱ esi silabaagha kaakulolelʼo kaa kuteelelela Banai̱saaleeli̱.” ");
INSERT INTO tlj_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Nahabweki mu̱hongi̱ Eli̱yeeja aakumaani̱ya bibindi bya bbu̱looji̱ ebi basaasa aba baaleeti̱ye kandi ebi mulilo ghwokeei̱ye kandi baawiisamu na nondo sahaani̱ sya ku̱swi̱ki̱la haa kyakuhongelʼo bihonguwa, ");
INSERT INTO tlj_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","ngoku Mukama aalaghiiye Musa. Eki kikabʼo ku̱u̱su̱ki̱ya Banai̱saaleeli̱ ngu taaliyo muntu onji weena kuuyʼo muusukulu wa Alooni̱ oghu ali na ku̱tu̱mi̱ka bubbani̱, mu maaso ghaa Mukama. Muntu oghu naaki̱koli̱ye akuba nga Koola na ki̱bbu̱la kiye. ");
INSERT INTO tlj_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Kilo ekyalabhi̱yʼo ki̱bbu̱la kya Banai̱saaleeli̱ kyona kyatandika kutongana na Musa na Alooni̱. Baaghila bati, “Mwati̱ye bantu baa Mukama.” ");
INSERT INTO tlj_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Bantu bʼomu ki̱bbu̱la kya Banai̱saaleeli̱ beekumaani̱ya kuhakani̱ya Musa na Alooni̱. Bhaatu obu Banai̱saaleeli̱ aba baaloli̱ye haa weema ya kusanga-sangaanamu, du̱mbi̱ kicu kyaghi̱swi̱ki̱la kandi ki̱ti̱i̱ni̱sa kya Mukama kyabonekʼo. ");
INSERT INTO tlj_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Du̱mbi̱ Musa na Alooni̱ baaghenda mu maaso ghaa weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Mu̱lu̱ghe mu ki̱bbu̱la kya bantu eki, nkubbala ku̱hwelekeeleli̱ya bantu aba haa mulundi ghumui.” Du̱mbi̱ Musa na Alooni̱ beegenga hansi makpu̱ngbu̱. ");
INSERT INTO tlj_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Musa aaghila Alooni̱ ati, “Okwate kibindi kyawe kandi otemu bubbani̱ na mulilo ghwa kyakuhongelʼo bihonguwa. Obitwale bwangu mu ki̱bbu̱la kya bantu aba haabwa mukolo ghwa kughaniluwa bibhi byabo, niikuwo Mukama abaghanile. Mukama asaaluuwe kwonini na bantu aba kandi aatandi̱ki̱ye kubaha kifubilo kya ndwala ya kabhi.” ");
INSERT INTO tlj_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Alooni̱ aakola ngoku Musa aamughambiiye aakwata kibindi kandi aali̱gi̱ta haagati ya ki̱bbu̱la kya bantu aba. Ndwala yamaani̱ eghi ekaba niyaati̱ye bakani̱ye mu bantu aba. Bhaatu Alooni̱ aahonga bubbani̱ obu kandi aakola mukolo ghwa kughaniluwa bibhi bya bantu aba. ");
INSERT INTO tlj_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Alooni̱ aamilila haagati ya bantu abaakaaye na abaaku̱u̱ye, du̱mbi̱ ndwala ya kabhi eghi yaaleka kwita bantu aba. ");
INSERT INTO tlj_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Bhaatu ndwala eghi ekaba niyaati̱ye bantu mutwalo ghumui nku̱mi̱ enaa na lusanju̱, kwongela haa basaasa abaaku̱u̱ye haabwa bu̱jeemi̱ bwa Koola. ");
INSERT INTO tlj_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Du̱mbi̱ Alooni̱ aakuuka ewaa Musa haa mulyango ghwa weema ya kusanga-sangaanamu, nanga ndwala eghi ekaba niyaaleki̱ye kwita bantu aba. ");
INSERT INTO tlj_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Oghambile Banai̱saaleeli̱ kukuha mi̱i̱gho eku̱mi̱ nʼebili, bu̱li̱ mwebembeli̱ wa ntu̱la akuhe mwi̱gho ghumui kusighikila haa ntu̱la syabo kandi haa mwi̱gho ghwa bu̱li̱ mwebembeli̱ ohandiikʼo li̱i̱na liye. ");
INSERT INTO tlj_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Haa mwi̱gho ghwa ntu̱la ya Leevi̱ ohandiikʼo li̱i̱na lya Alooni̱, nanga bu̱li̱ mwebembeli̱ wa ntu̱la ali na kuleeta mwi̱gho ghumui. ");
INSERT INTO tlj_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Mi̱i̱gho eghi oghite mu weema ya kusanga-sangaanamu mu maaso ghaa sandu̱u̱ku̱ ya ndaghaano, hambali nkusanga-sangaanagha naawe. ");
INSERT INTO tlj_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Bimole bikutuwa haa mwi̱gho ghwa musaasa oghu nkukomamu, nku̱holeesi̱ya Banai̱saaleeli̱ aba kandi bakuleka kuukala mbatongana naanu.” ");
INSERT INTO tlj_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Nahabweki Musa aaghambila Banai̱saaleeli̱ kandi beebembeli̱ baabo baamuha mi̱i̱gho eku̱mi̱ nʼebili. Mwi̱gho ghumui haabwa bu̱li̱ mwebembeli̱ wa bu̱li̱ ntu̱la kandi na mwi̱gho ghwa Alooni̱ ghukuba ghulimu dhee. ");
INSERT INTO tlj_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Musa aata mi̱i̱gho eghi mu maaso ghaa sandu̱u̱ku̱ ya ndaghaano ya Mukama mu weema ya sandu̱u̱ku̱ ya ndaghaano. ");
INSERT INTO tlj_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Kilo ekyalabhi̱yʼo, obu Musa aataahi̱ye mu weema ya sandu̱u̱ku̱ ya ndaghaano, aabona mwi̱gho ghwa Alooni̱ ghwa ntu̱la ya Leevi̱, ghutooyʼo bimole na bi̱ghu̱ma byeli̱ye bya kiti alu̱mondi̱. ");
INSERT INTO tlj_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Du̱mbi̱ Musa aatwesi̱ya mi̱i̱gho eghi yoona mu weema ya kusanga-sangaanamu mu maaso ghaa Mukama kandi aaghyoleka Banai̱saaleeli̱ boona. Baalola mi̱i̱gho eghi kandi bu̱li̱ mwebembeli̱ aatwala mwi̱gho ghuwe. ");
INSERT INTO tlj_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Mukama aaghila Musa ati, “Oku̱u̱ki̱ye mwi̱gho ghwa Alooni̱ mu weema ya kusanga-sangaanamu mu maaso ghaa sandu̱u̱ku̱ ya ndaghaano. Mwi̱gho oghu ghuukalʼo kandi ghube kaakulolelʼo kaa kuteelelela Banai̱saaleeli̱ bajeemi̱ aba ngu kaakuba beeyongela kutongana nanje, baku̱ku̱wa.” ");
INSERT INTO tlj_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Musa aakola ngoku Mukama aamulaghiiye. ");
INSERT INTO tlj_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Banai̱saaleeli̱ baaghila Musa bati, “Olole, tu̱ku̱ku̱wa! Tukuhwelekeelela kandi tukuhuwʼo! ");
INSERT INTO tlj_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Muntu weena oghu akwebinga weema ehi̱ki̱li̱i̱ye ya Mukama aku̱ku̱wa. Buuye etu̱we boona tu̱ku̱ku̱wa?” ");
INSERT INTO tlj_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Mukama aaghila Alooni̱ ati, “Uwe, batabani̱ baawe na ka ya so waawe mulabaagha na musango haabwa kintu ki̱bhi̱i̱hi̱ye ekilakoluwagha haa weema ehi̱ki̱li̱i̱ye kandi uwe na batabani̱ baawe mulabaagha na musango haabwa kintu ki̱bhi̱i̱hi̱ye eki mu̱hongi̱ alakolagha. ");
INSERT INTO tlj_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Oleete Baleevi̱ baanakyawe ku̱lu̱gha mu ntu̱la yaanu, niikuwo baase kandi bakukoonele kukola milimo obu uwe na batabani̱ baawe mulabaagha nimukola mulimo haa weema ya sandu̱u̱ku̱ ya ndaghaano. ");
INSERT INTO tlj_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Bhaatu obu bakuba mbakola mulimo oghu, tabali na kwebinga haai na bintu bi̱hi̱ki̱li̱i̱ye ebili mu weema ya kusanga-sangaanamu kedha kwebinga haai na kyakuhongelʼo bihonguwa. Kaakuba bakola eki baku̱ku̱wa kandi uwe na batabani̱ baawe mu̱ku̱ku̱wa dhee. ");
INSERT INTO tlj_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Baleevi̱ bali na kukola naawe mulimo ghwa kuloleelela weema ya kusanga-sangaanamu kandi kukola milimo yoona haa weema eghi. Bhaatu oghu atali Mu̱leevi̱, taali na kwebinga hambali muli. ");
INSERT INTO tlj_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Uwe na batabani̱ baawe muli na kuloleelela ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye na kyakuhongelʼo bihonguwa, niikuwo ntatodha kusaaliluwa na Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Ni̱i̱si̱ye neenini oghu naakomi̱ye Baleevi̱ baanakyawe mu Banai̱saaleeli̱ banji kandi naabaha enu̱we bahongi̱ nga kisembo kyanu. Baleevi̱ aba naabahaayeyo ewaa Mukama kukolagha milimo haa weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Bhaatu uwe na batabani̱ baawe mukugubha ku̱heeleli̱ya nga bahongi̱ haa kyakuhongelʼo bihonguwa na mukati ya kateni̱. Mulimo ghwanu ghwa kuba bahongi̱ ni kisembo eki̱lu̱ghi̱ye ewanje. Muntu onji weena oghu akulengʼo kwebinga weema ehi̱ki̱li̱i̱ye eghi ali na kwitibuwa.” ");
INSERT INTO tlj_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Mukama aaghila Alooni̱ ati, “Si̱ye neenini naakuhaaye mulimo ghwa kuloleelela bihonguwa bi̱hi̱ki̱li̱i̱ye ebi Banai̱saaleeli̱ bakundeetela. Naahaaye uwe na batabani̱ baawe bihonguwa bi̱hi̱ki̱li̱i̱ye ebi nga mughabo ghwanu ghwa bilo byona. ");
INSERT INTO tlj_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Naakuhaaye ki̱twi̱ke kya bihonguwa ebi batookeei̱ye haa mulilo. Ki̱twi̱ke kya bihonguwa bi̱hi̱ki̱li̱i̱ye bini: bihonguwa bya bilimuwa kedha bihonguwa haabwa kibhi kedha bihonguwa haabwa kuuhibuwʼo musango, ki̱twi̱ke kya bihonguwa ebi ni kyawe na batabani̱ baawe. ");
INSERT INTO tlj_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Bihonguwa ebi obiliilaghe mu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. Bu̱li̱ musaasa oghu ali mu ka yaawe akugubha kubiliya. Bihonguwa ebi bi̱hi̱ki̱li̱i̱ye ewaawe. ");
INSERT INTO tlj_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Bini ni byawe dhee: bihonguwa byona bya ku̱u̱mu̱ki̱ya ebi Banai̱saaleeli̱ bakuhaayo ni byawe dhee. Naahaaye bihonguwa ebi uwe, batabani̱ baawe na bahala baawe nga mughabo ghwa bilo byona. Muntu weena mu ka yaawe oghu eeli̱ye ewaanu akugubha kubiliya. ");
INSERT INTO tlj_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Naakuhaaye dhee mafu̱ta ghasemeeye ghaa biti oli̱va, vi̱i̱ni̱ mpyaka na bilimuwa bisemeeye ebi Banai̱saaleeli̱ bakuhaayo ewaa Mukama nga mughanulo ghwabo. ");
INSERT INTO tlj_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Mighanulo yoona ya bilimuwa mu kyalo eki eghi Banai̱saaleeli̱ balaleetelagha si̱ye Mukama elabaagha yaawe. Muntu weena mu ka yaawe oghu eeli̱ye ewaanu akugubha kubiliya. ");
INSERT INTO tlj_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Kintu kyona eki Banai̱saaleeli̱ balahaaghayo ewaa Mukama kilabaagha kyawe. ");
INSERT INTO tlj_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Mu̱li̱ghaaso ghwona ghwabusaasa ghube ghwa muntu kedha ghwa kisolo oghu bahongeeye Mukama, ghulabaagha ghwawe. Bhaatu mu̱li̱ghaaso ghwabusaasa ghwa muntu oli na kughucungula kandi na mu̱li̱ghaaso ghwa kisolo eki̱teeli̱ye oli na kughucungula. ");
INSERT INTO tlj_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Baana baabusaasa mi̱li̱ghaaso mbabaaye bali na kweli̱ kumui, obacungulaghe na bi̱twi̱ke bitaano bya siliva, kusighikila haa ki̱pi̱i̱mo kyomu ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Bhaatu tooli na kucungula mu̱li̱ghaaso ghwa nte, ntaama kedha mbu̱li̱, nanga bisolo ebi bi̱hi̱ki̱li̱i̱ye. Saghama ya bisolo ebi oghimisangaghe haa kyakuhongelʼo bihonguwa kandi bisabu obihongaghe nga kihonguwa bookeei̱ye haa mulilo, eki kusasa kwakiyo ku̱dheedhi̱ye Mukama. ");
INSERT INTO tlj_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Nyama sya bisolo ebi sili na kuba syawe, ngoku mbanda na kibelo kyabuliyo ebi baamu̱ki̱i̱ye nga kihonguwa ewaa Mukama bili byawe. ");
INSERT INTO tlj_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Bihonguwa byona bi̱hi̱ki̱li̱i̱ye ebi Banai̱saaleeli̱ bakuhaayo ewaa Mukama, naakuhaaye biyo na batabani̱ baawe na bahala baawe, kuba mughabo ghwawe bwile bwona. Eghi ni ndaghaano ya bilo nʼebilo eghi naakoli̱ye naawe na baasukulu baawe kandi eghi etalihuwʼo.” ");
INSERT INTO tlj_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Mukama aaghila Alooni̱ ati, “Tookutunga bugwetuwa mu nsi eghi, kedha kutunga mughabo nga Banai̱saaleeli̱ banji. Ni̱i̱si̱ye mughabo ghwawe kandi bugwetuwa bwawe mu Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Naahaaye Baleevi̱ bu̱li̱ kimui kyʼeku̱mi̱ nga bugwetuwa bwabo eki Banai̱saaleeli̱ balahaaghayo ewanje haabwa mulimo bakukola ghwa ku̱heeleli̱ya mu weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Kutandikila endindi Banai̱saaleeli̱ batatodha kughenda haai na weema ya kusanga-sangaanamu. Kaakuba bakola eki baku̱si̱ngu̱wa musango kandi baku̱we. ");
INSERT INTO tlj_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Baleevi̱ bonkaha niibo bali na kukola mulimo haa weema ya kusanga-sangaanamu. Kaakuba basobi̱ya kintu kyona haa weema eghi, baku̱si̱ngu̱wa musango. Eki ni kilaghilo kya bilo nʼebilo mu mijo yaanu yoona eghi ekwisa. Baleevi̱ tabakutunga bugwetuwa bwa nsi nga Banai̱saaleeli̱ banji. ");
INSERT INTO tlj_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Bhaatu bugwetuwa obu naahaaye Baleevi̱ ni kimui kyʼeku̱mi̱ eki Banai̱saaleeli̱ bakuhaayo nga kihonguwa ewaa Mukama. Eki niikiyo kyaleki̱ye naabu̱ghʼo Baleevi̱ nti, ‘Tabakutunga bugwetuwa mu Banai̱saaleeli̱.’ ” ");
INSERT INTO tlj_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Oghile Baleevi̱ oti, ‘Mulakatungagha kimui kyʼeku̱mi̱ eki naahaaye enu̱we nga bugwetuwa bwanu ku̱lu̱gha mu Banai̱saaleeli̱, muli na kuhaayo kimui kyʼeku̱mi̱ kyakiyo nga kihonguwa ewaa Mukama. ");
INSERT INTO tlj_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Banai̱saaleeli̱ balakabaagha mbaha si̱ye ki̱twi̱ke kya bilimuwa na vi̱i̱ni̱, naanu muli na kuta haakpengbu̱ ki̱twi̱ke kya ebi mwatu̱ngi̱ye kya kumpa. ");
INSERT INTO tlj_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Muli na kuhaayo mutiyo kihonguwa ewaa Mukama ku̱lu̱gha mu bu̱li̱ kimui kyʼeku̱mi̱ eki mulatungagha ku̱lu̱gha mu Banai̱saaleeli̱. Haa kimui kyʼeku̱mi̱ eki muuyaghʼo kihonguwa kya Mukama kya kuha mu̱hongi̱ Alooni̱. ");
INSERT INTO tlj_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Haa bisembo byona ebi mulatungagha, muuyaghʼo ki̱twi̱ke ekisemeeye kwonini kuba kihonguwa kya mbaghani̱ja kya Mukama kandi mukihongaghe ki̱hi̱ki̱li̱i̱ye kwonini.’ ");
INSERT INTO tlj_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Oghile Baleevi̱ oti, ‘Haanu̱ma yaanu kumpa ki̱twi̱ke kisemeeye, mukugubha kuliya ebyati̱ghaayʼo, ngoku Banai̱saaleeli̱ bakuliyagha ki̱twi̱ke kya bihonguwa byabo bya bilimuwa na vi̱i̱ni̱ haanu̱ma yabo kubimpongela. ");
INSERT INTO tlj_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Uwe na bantu bʼomu ka yaawe mukugubha kuliila hantu hoona ebi̱ti̱ghaaye haa kihonguwa eki, nanga ni nsasu̱li̱ haabwa milimo oghu mukwete kukola haa weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Kaakuba muhayo ki̱twi̱ke ekisemeeye kwonini kya kihonguwa eki tamu̱ku̱si̱ngu̱wa musango haabwa kukola eki, du̱mbi̱ tamu̱ku̱bhi̱i̱ya bihonguwa bi̱hi̱ki̱li̱i̱ye bya Banai̱saaleeli̱ kandi tamu̱ku̱ku̱wa.’ ” ");
INSERT INTO tlj_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Mukama aaghila Musa na Alooni̱ ati, ");
INSERT INTO tlj_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Kini nkilaghilo eki Mukama aataayo ati, ‘Oghambile Banai̱saaleeli̱ kukuleetela nte mutuku, eghi etalamaaye, eghi etali na kamogo kandi eghi batakakoleeseei̱ye mulimo ghwona. ");
INSERT INTO tlj_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Nte eghi baghihe mu̱hongi̱ Eli̱yeeja, du̱mbi̱ baghi̱twesi̱ye hanja ya hambali Banai̱saaleeli̱ baghooneeye kandi baghisalile mu maaso ghe. ");
INSERT INTO tlj_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Du̱mbi̱ mu̱hongi̱ Eli̱yeeja akoti̱ye kyala kiye mu saghama ya nte eghi kandi aghimisange milundi musanju̱ mu maaso ghaa weema ya kusanga-sangaanamu. ");
INSERT INTO tlj_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Nte eghi yoona, otaayemu luhu, nyama, saghama na mabhi̱ ghaayʼo byona babyoki̱ye mu̱hongi̱ Eli̱yeeja analoli̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Mu̱hongi̱ Eli̱yeeja akwate kati kaa ki̱i̱looku̱, kabha kaa hai̱sopu̱ na hu̱u̱ji̱ mutuku kandi abikube mu mulilo ghwa nyama sya nte esikwete kuhiya. ");
INSERT INTO tlj_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Haanu̱ma yʼeki, mu̱hongi̱ oghu ali na kunaabi̱ya ngoye alu̱weete kandi anaabe maasi mubili ghwona. Du̱mbi̱ akuuke hambali Banai̱saaleeli̱ baghooneeye, bhaatu akufooka oghu ateeli̱ye ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Musaasa oghu ookeei̱ye nte eghi naye dhee ali na kunaabi̱ya ngoye esi alu̱weete kandi anaabe maasi mubili ghwona, bhaatu naye dhee akufooka oghu ateeli̱ye ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“ ‘Musaasa oghu eeli̱ye akumaani̱ye ki̱bu̱ kya nte eghi kandi akite mu ki̱i̱kalo kyeli̱ye hanja ya hambali Banai̱saaleeli̱ baghooneeye. Ki̱bbu̱la kya Banai̱saaleeli̱ kibiike ki̱bu̱ eki kukitaagha mu maasi ghaa mukolo ghwa kweli̱ya bantu, kubaayʼo kibhi. ");
INSERT INTO tlj_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Musaasa oghu akukumaani̱ya ki̱bu̱ kya nyama sya nte eghi ali na kunaabi̱ya dhee ngoye esi alu̱weete kandi naye dhee akufooka oghu ateeli̱ye ku̱hi̱ki̱ya lwagholo. Kini ni kilaghilo kya bilo byona kya Banai̱saaleeli̱ na banamahanga abaakaaye nabo. ");
INSERT INTO tlj_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“ ‘Muntu weena oghu alaku̱magha haa mu̱ku̱ ghwa muntu, alafookagha oghu ateeli̱ye haabwa bilo musanju̱. ");
INSERT INTO tlj_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Muntu oghu ali na kweyeli̱ya haa kilo kyakasatu na kilo kyamusanju̱ haabwa kunaaba maasi aghakweli̱yagha agha, du̱mbi̱ akufooka oghu eeli̱ye. Bhaatu kaakuba ateeyeli̱ya haa kilo kyakasatu na kilo kyamusanju̱, akuukala anali oghu ateeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Muntu weena oghu aku̱ku̱mʼo mu̱ku̱ ghwa muntu kandi asaaghuwa kweyeli̱ya, aku̱bhi̱i̱ya weema ehi̱ki̱li̱i̱ye ya Mukama. Muntu oghu ali na kubhinguwa mu Banai̱saaleeli̱, nanga tabamumisangiiye maasi aghakweli̱yagha, nahabweki ni muntu oghu ateeli̱ye kandi akuukala ali oghu ateeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“ ‘Kini ni kilaghilo ekikwetʼo muntu oghu akwi̱li̱i̱ye mu weema yee. Muntu weena oghu akutaaha mu weema eghi kandi muntu weena oghu akuba ali mu weema eghi, akufooka oghu ateeli̱ye haabwa bilo musanju̱ ");
INSERT INTO tlj_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","kandi bu̱li̱ kintu kyona ekili mu weema eghi ekitaswi̱ki̱ye haa mu̱nu̱wa kikufooka eki̱teeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“ ‘Kaakuba muntu weena aba ali mu musili kandi aku̱mʼo mu̱ku̱ ghwa muntu oghu baati̱ye na kihiyo kedha oghu aku̱u̱ye lu̱ku̱ lwa bu̱li̱ kilo, kedha aku̱ma haa eku̱wa lya muntu oghu kedha haa kituulo kiye, alafookagha oghu ateeli̱ye haabwa bilo musanju̱. ");
INSERT INTO tlj_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“ ‘Kweli̱ya muntu oghu, bate ki̱bu̱ kya nte eghi bookeei̱ye nga kihonguwa haabwa kibhi kuuyʼo bantu kibhi kandi bakite mu jaaga, du̱mbi̱ baseesemu maasi. ");
INSERT INTO tlj_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Du̱mbi̱ musaasa oghu eeli̱ye akwate kabha kaa hai̱sopu̱, akakoti̱ye mu maasi agha kandi aghamisange haa weema, haa byaku̱koleesi̱yamu byona na bantu abaabaagha mu weema eghi. Ali na kughamisangila dhee haa muntu weena oghu aaku̱mi̱ye haa eku̱wa lya muntu kedha kituulo kedha haa mu̱ku̱ ghwa muntu oghu baati̱ye kedha muntu oghu aaku̱u̱ye lu̱ku̱ lwa bu̱li̱ kilo. ");
INSERT INTO tlj_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Musaasa oghu eeli̱ye ali na kumisangila maasi agha muntu oghu ateeli̱ye oghu haa kilo kyakasatu na kilo kyamusanju̱. Muntu oghu eeli̱ye atodhe akole mukolo ghwa kweli̱ya muntu oghu haa kilo kyamusanju̱. Muntu oghu bakwete kukolʼo mukolo ghwa ku̱mweli̱ya ali na kunaabi̱ya ngoye esi alu̱weete, anaabe maasi mubili ghwona kandi lwagholo olu akufooka oghu eeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Bhaatu kaakuba muntu oghu ateeli̱ye asaaghuwa kukola mukolo ghwa kweyeli̱ya, ali na kubhinguwa mu ki̱bbu̱la kya Banai̱saaleeli̱, nanga aabhi̱hi̱i̱ye ki̱i̱kalo ki̱hi̱ki̱li̱i̱ye kya Mukama. Nanga bakuba batamumisangiiye maasi aghakweli̱yagha kandi ni muntu oghu ateeli̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Kini nkilaghilo kya Banai̱saaleeli̱ kya bilo nʼebilo. “ ‘Muntu oghu akumisangila muunakiye maasi aghakweli̱yagha, akulaghiluwa dhee kunaabi̱ya ngoye esi alu̱weete kandi muntu weena oghu aku̱ku̱mʼo maasi aghakweli̱yagha akufooka oghu ateeli̱ye ku̱hi̱ki̱ya lwagholo. ");
INSERT INTO tlj_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Kintu kyona eki muntu oghu ateeli̱ye aku̱ku̱mʼo kikufooka eki̱teeli̱ye kandi muntu weena oghu aku̱ku̱mʼo kintu eki akufooka oghu ateeli̱ye ku̱hi̱ki̱ya lwagholo.’ ” ");
INSERT INTO tlj_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Mu kweli̱ kwʼoku̱du̱bha ki̱bbu̱la kyona kya Banai̱saaleeli̱ baaki̱dha mu elungu lya Ji̱i̱ni̱ kandi baaghoona mu tau̱ni̱ ya Kadesi̱. Mi̱li̱yamu aakwi̱la mu ki̱i̱kalo eki kandi baamujiikayo. ");
INSERT INTO tlj_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Maasi ghakaba ghatali mu ki̱i̱kalo eki ghaa ki̱bbu̱la eki kunuwa, du̱mbi̱ bantu aba beekumaani̱ya kuhakani̱ya Musa na Alooni̱. ");
INSERT INTO tlj_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Baatongana na Musa bati, “Nguli twaku̱u̱ye bwile obu baghenji̱ baatu baakwi̱li̱i̱ye mu maaso ghaa Mukama! ");
INSERT INTO tlj_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Nkiki kyaleki̱ye waaleeta ki̱bbu̱la kya bantu baa Mukama mu elungu lini, etu̱we na bisolo byatu ku̱kwi̱lamu? ");
INSERT INTO tlj_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Waatu̱u̱hi̱ye mu nsi ya Mi̱si̱li̱, kutuleeta mu ki̱i̱kalo ki̱bhi̱i̱hi̱ye nangaaki? Ki̱i̱kalo kini takilimu bilimuwa, biti mi̱ti̱i̱ni̱, mi̱jaabbi̱i̱bbu̱ kedha mikomamahanga kandi maasi ghaa kunuwa taghalimu!” ");
INSERT INTO tlj_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Musa na Alooni̱ baalu̱gha mu ki̱bbu̱la kya bantu eki kandi baaghenda haa mulyango ghwa weema ya kusanga-sangaanamu, beegenga hansi makpu̱ngbu̱ kandi ki̱ti̱i̱ni̱sa kya Mukama kyababonekela. ");
INSERT INTO tlj_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Mukama aaghila Musa ati, ");
INSERT INTO tlj_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Okwate mwi̱gho ghwawe kandi uwe na mu̱ghenji̱ waawe Alooni̱ mukumaani̱ye ki̱bbu̱la kya bantu eki. Olaghile kikuka bantu aba banaloli̱ye kandi maasi ghaku̱lu̱ghamu. Okuuya maasi mu kikuka ghaa ki̱bbu̱la kya bantu aba na bisolo byabo kunuwa.” ");
INSERT INTO tlj_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Nahabweki Musa aakwata mwi̱gho oghwabaagha mu maaso ghaa Mukama ngoku Mukama aamulaghiiye. ");
INSERT INTO tlj_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Musa na Alooni̱ baakumaani̱ya ki̱bbu̱la kya bantu aba mu maaso ghaa kikuka. Musa aabaghila ati, “Mu̱u̱ghu̱we, enu̱we bantu bajeemi̱! Buuye tubaahile maasi mu kikuka kini?” ");
INSERT INTO tlj_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Du̱mbi̱ Musa aamu̱ki̱ya mukono ghuwe kandi aahuula mwi̱gho oghu haa kikuka eki milundi ebili. Maasi ghakani̱ye ghaalu̱ghamu kandi ki̱bbu̱la kya bantu aba baatandika kunuwa maasi agha na bisolo byabo byanuwa dhee. ");
INSERT INTO tlj_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Bhaatu Mukama aaghila Musa na Alooni̱ ati, “Mwabhengi̱ye kuneesigha kwonini kandi ku̱mpu̱ti̱ya ngoku ndi ahi̱ki̱li̱i̱ye mu maaso ghaa Banai̱saaleeli̱ aba, tamu̱ku̱ki̱dhi̱ya ki̱bbu̱la kya bantu aba mu nsi eghi nkuha bantu aba.” ");
INSERT INTO tlj_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Agha niigho maasi agha baatu̱ngi̱ye mu ki̱i̱kalo baghilaghamu Meli̱ba, hambali Banai̱saaleeli̱ baatongaane na Mukama kandi aabooleka ngoku ahi̱ki̱li̱i̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Musa aatuma batumuwa ku̱lu̱gha mu tau̱ni̱ ya Kadesi̱ kughenda ewaa mukama wa Edomu kandi kumughila bati, “Mu̱ghenji̱ waawe I̱saaleeli̱ akwete kughila ati, ‘Omani̱ye bijibu byona ebyatubaayʼo. ");
INSERT INTO tlj_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Baataata baatu baakahona mu nsi ya Mi̱si̱li̱ kandi twakalayo myaka ekani̱ye. Banami̱si̱li̱ baabona-boni̱ya etu̱we na baataata baatu. ");
INSERT INTO tlj_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Bhaatu twataaghila Mukama kutukoonela. Aaghu̱wa kutaagha kwatu kandi aatuma malai̱ka wee kutuuya mu nsi ya Mi̱si̱li̱. “ ‘Endindi tuli mu tau̱ni̱ ya Kadesi̱, eghi eli haa mutaano ghwa kyalo kyawe. ");
INSERT INTO tlj_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Gutu otu̱si̱i̱mi̱lani̱ye kusaalila mu kyalo kyawe. Tatukusaalila mu misili kedha misili ya mi̱jaabbi̱i̱bbu̱, kedha kunuwa maasi ghaa byahu̱dhu̱ byanu. Tukukwamila mu luguudhe lwonkaha kandi tatukwegaali̱ya haa mukono ghwabuliyo kedha ghwabumesu, ku̱hi̱ki̱ya tumali̱ye kusaalila mu kyalo kyawe.’ ” ");
INSERT INTO tlj_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Bhaatu mukama wa Edomu aaghila ati, “Bbaa, tamukusaalila mu kyalo kyatu, kaakuba mulengʼo kukwamilamu, tukwisa kulwana naanu tukwete bihiyo.” ");
INSERT INTO tlj_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Banai̱saaleeli̱ baamughila bati, “Tukusaalilila mu luguudhe lwonkaha kandi kaakuba tunuwa maasi ghaanu kedha bisolo byatu bighanuwa, tukughasasula. Eki tukwete kubbala ni kusaalila mu kyalo kyanu ntulubhatanga, taaliyo kintu kinji tukukola.” ");
INSERT INTO tlj_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Bhaatu mukama oghu aabaghila ati, “Tamukusaalilamu bbaa!” Du̱mbi̱ aasindika mahe ghe ghaamaani̱ ghaa Edomu kughenda kandi kulwana na Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Obu bantu baa Edomu baabhengi̱ye ku̱si̱i̱mi̱lani̱ya Banai̱saaleeli̱ kusaalila mu kyalo kyabo, du̱mbi̱ Banai̱saaleeli̱ aba baakuuka kandi baakwama kihanda kinji. ");
INSERT INTO tlj_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Ki̱bbu̱la kyona kya Banai̱saaleeli̱ baalu̱gha mu tau̱ni̱ ya Kadesi̱ kandi baaki̱dha haa mwena Hooli̱. ");
INSERT INTO tlj_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Obu Banai̱saaleeli̱ baabaagha haa mwena Hooli̱ haai na kyalo kya Edomu, Mukama aaghila Musa na Alooni̱ ati, ");
INSERT INTO tlj_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Alooni̱ aku̱ku̱wa kandi akukwama baataata be. Taaku̱ki̱dha mu nsi eghi nkuha Banai̱saaleeli̱, nanga enu̱we bombi obu mwabaagha haa maasi ghaa Meli̱ba mukabhenga ku̱u̱ghu̱wa eki naabalaghiiye. ");
INSERT INTO tlj_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Musa, otwale Alooni̱ na mutabani̱ wee Eli̱yeeja kandi mu̱ni̱i̱ne haa mwena Hooli̱. ");
INSERT INTO tlj_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Ooyemu Alooni̱ bi̱lu̱waalo biye kandi obi̱lu̱wi̱ke mutabani̱ wee Eli̱yeeja, nanga Alooni̱ aku̱kwi̱la haa mwena ghuni kandi akukwama baataata be.” ");
INSERT INTO tlj_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Musa aakola ngoku Mukama aamulaghiiye. Baani̱i̱na haa mwena Hooli̱ ki̱bbu̱la kyona kya Banai̱saaleeli̱ banabaloli̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Musa aayamu Alooni̱ bi̱lu̱waalo biye kandi aabi̱lu̱wi̱ka Eli̱yeeja mutabani̱ wa Alooni̱ kandi Alooni̱ aakwi̱la haagu̱u̱li̱ ya mwena oghu. Du̱mbi̱ Musa na Eli̱yeeja baakota ku̱lu̱gha haa mwena oghu. ");
INSERT INTO tlj_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Obu ki̱bbu̱la kyona kya Banai̱saaleeli̱ baamani̱ye ngoku Alooni̱ aaku̱u̱ye, baamweghungila haabwa bilo maku̱mi̱ asatu. ");
INSERT INTO tlj_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Obu Munakanaani̱, mukama wa Aladi̱ oghu akaba aakaaye Negeebbu, aaghu̱u̱ye ngu Banai̱saaleeli̱ niibuwo baasa mu luguudhe olukweme mu mu̱bhi̱li̱ ghwa Atali̱i̱mu̱, aaghenda kubalu̱mba kandi aakwata bamui mu Banai̱saaleeli̱ aba. ");
INSERT INTO tlj_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Du̱mbi̱ Banai̱saaleeli̱ baalahila ewaa Mukama bati, “Kaakuba otu̱si̱i̱mi̱lani̱ya ku̱si̱ngu̱la bantu aba, tu̱ku̱hwelekeeleli̱ya kwonini bibugha byabo.” ");
INSERT INTO tlj_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Mukama aaghu̱wa eki Banai̱saaleeli̱ baamusabi̱ye kandi aaleka baasi̱ngu̱la Banakanaani̱ aba. Baabahwelekeeleli̱ya kwonini na bibugha byabo kandi baaluka ki̱i̱kalo eki li̱i̱na Holu̱ma. ");
INSERT INTO tlj_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Banai̱saaleeli̱ baalu̱gha haa mwena Hooli̱, baakwama kihanda kya Nanja Mutuku kandi baaghenda mbaneeli̱ghi̱i̱li̱li̱ya ehanga lya Edomu. Bhaatu bantu aba baasaaghuwa ku̱gu̱mi̱si̱li̱ja mu lughendo olu. ");
INSERT INTO tlj_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Baatandika kutongana na Luhanga kandi na Musa bati, “Nkiki kyaleki̱ye mwatuuya mu nsi ya Mi̱si̱li̱ ku̱kwi̱la mu elungu? Byokuliya tabilimu! Maasi taghalimu! Byokuliya bitasemeeye maanu byatutami̱ye.” ");
INSERT INTO tlj_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Du̱mbi̱ Mukama aabasindikila njoka sya buseguwe, syabaluma kandi bakani̱ye mu Banai̱saaleeli̱ aba baaku̱wa. ");
INSERT INTO tlj_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Banai̱saaleeli̱ aba baasa hambali Musa ali kandi baamughila bati, “Twasi̱i̱si̱ye kutongana na Mukama kandi kuhakangana naawe. Gutu osabe Mukama kutuuyʼo njoka esi.” Nahabweki Musa aasabila bantu aba. ");
INSERT INTO tlj_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Mukama aaghila Musa ati, “Okole kisasani̱ kya njoka ya bbu̱looji̱ kandi oghi̱dhodhooki̱ye haa mpaghi. Muntu weena oghu njoka ekuluma kandi alola haa njoka eghi akukila.” ");
INSERT INTO tlj_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Nahabweki Musa aakola kisasani̱ kya njoka ya bbu̱looji̱ kandi aaghi̱dhodhooki̱ya haa mpaghi. Njoka yaakalumagha muntu weena kandi naalola haa njoka eghi, akila. ");
INSERT INTO tlj_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Banai̱saaleeli̱ beeyongela kughenda kandi baaghoona mu ki̱i̱kalo baaghilaghamu Obboti̱. ");
INSERT INTO tlj_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Du̱mbi̱ baalu̱gha Obboti̱ baaghenda kandi baaghoona I̱ye-abbali̱mu̱, mu elungu elilolaane na Mowaabu bu̱lu̱gha ejooba. ");
INSERT INTO tlj_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Baalu̱gha mu elungu eli, baaghenda kandi baaghoona mu kighona kya Jeledi̱. ");
INSERT INTO tlj_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Du̱mbi̱ baalu̱gha mu ki̱i̱kalo eki baaghenda kandi baaghoona luhande lweli̱ lwa maasi Alu̱nooni̱, mu elungu eli̱hi̱ki̱ye mu kyalo kya Bamooli̱. Maasi Alu̱nooni̱ ghakaba ghali haa mutaano ghwa Mowaabu, haagati ya Mowaabu na Bamooli̱. ");
INSERT INTO tlj_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Eki niikiyo kyaleki̱ye Kitabo kya Malemo ghaa Mukama kyaghila kiti, “Kibugha kya Wahebbu mu kyalo kya Sufa, na bighona bya maasi Alu̱nooni̱, ");
INSERT INTO tlj_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ku̱hi̱ka mu bighona ebi̱hi̱ki̱ye mu kibugha kya Ala, haa mutaano ghwa ehanga lya Mowaabu.” ");
INSERT INTO tlj_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Obu baalu̱ghi̱ye haala, baaghenda kandi baaki̱dha Bbeela, haa kyahu̱dhu̱ hambali Mukama aaghi̱li̱ye Musa ati, “Okumaani̱ye hamui Banai̱saaleeli̱ kandi nkubaha maasi.” ");
INSERT INTO tlj_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Du̱mbi̱ Banai̱saaleeli̱ baalimba kilimbo kini bati, “Uwe kyahu̱dhu̱, otuhe maasi! Bhaawai̱, mukilimbile kilimbo. ");
INSERT INTO tlj_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Kyahu̱dhu̱ eki balemi̱ baali̱mi̱ye na mi̱i̱gho ya bukama kandi bantu aba bahu̱ti̱i̱ye baaki̱tobheeli̱ya na mi̱i̱gho yabo.” Obu Banai̱saaleeli̱ baalu̱ghi̱ye mu elungu eli baaghenda kandi baaghoona Matana. ");
INSERT INTO tlj_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Du̱mbi̱ baalu̱gha Matana kandi baaki̱dha Nahalyeli̱. Baalu̱gha Nahalyeli̱ kandi baaki̱dha Bbamoti̱. ");
INSERT INTO tlj_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Baalu̱gha Bbamoti̱ kandi baaki̱dha mu kighona kya Mowaabu mu nti̱na ya mwena ghwa Pisiga hambali muntu eemililagha kandi alola hansi mu elungu. ");
INSERT INTO tlj_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Banai̱saaleeli̱ baatuma batumuwa ewaa Si̱hooni̱ mukama wa Bamooli̱ kumughila bati, ");
INSERT INTO tlj_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Otu̱si̱i̱mi̱lani̱ye tusaalile mu kyalo kyawe. Tatukwekita mu misili yaanu ya mi̱jaabbi̱i̱bbu̱ kedha kunuwa maasi ghaa byahu̱dhu̱ byanu. Tukukwama mu luguudhe lwonkaha ku̱hi̱ki̱ya tu̱lu̱ghi̱ye mu kyalo kyawe.” ");
INSERT INTO tlj_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Bhaatu Si̱hooni̱ aabhenga ku̱si̱i̱mi̱lani̱ya Banai̱saaleeli̱ kusaalila mu kyalo kiye. Aakumaani̱ya mahe ghe kandi aaghenda mu ki̱i̱kalo baaghilaghamu Jahaaji̱ mu elungu, aatandika kulwana na Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Bhaatu Banai̱saaleeli̱ baamu̱si̱ngu̱la haa bulemo kandi baatwala kyalo kiye ku̱lu̱gha haa maasi Alu̱nooni̱ ku̱hi̱ka haa maasi Yabboki̱. Baakuukila haa mutaano ghwa Bamooni̱, nanga mahe ghaamaani̱ ghaa Bamooni̱ ghakaba ghali̱ndi̱ye mutaano oghu. ");
INSERT INTO tlj_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Banai̱saaleeli̱ baakwata bibugha byona bya Bamooli̱ otaayemu kibugha kya Hesi̱bbooni̱, na maatau̱ni̱ ghoona agheeli̱ghi̱li̱i̱ye kibugha eki kandi baakalamu. ");
INSERT INTO tlj_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hesi̱bbooni̱ niikiyo kyabaagha kibugha kya Si̱hooni̱ mukama wa Bamooli̱, oghu akalwana na mukama wa Mowaabu kandi aamuuyʼo kyalo kiye kyona ku̱hi̱ka haa maasi Alu̱nooni̱. ");
INSERT INTO tlj_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Eki niikiyo kyaleki̱ye bali̱mbi̱ baaghila bati, “Mwise tukwele kibugha kya Hesi̱bbooni̱, tukwele buhyaka kibugha kya Si̱hooni̱ kandi kigume. ");
INSERT INTO tlj_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Mulilo ghukaaka mu kibugha kya Hesi̱bbooni̱ kandi ghwamuka mu kibugha kya Si̱hooni̱. Ghwahwelekeeleli̱ya kibugha kya Ala mu ehanga lya Mowaabu kandi bwena obuli haai na maasi Alu̱nooni̱. ");
INSERT INTO tlj_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Ngamulikibona enu̱we bantu baa Mowaabu! Enu̱we bantu abakulami̱yagha luhanga Kemosi̱ mukuhwelekeelela! Batabani̱ baanu bakulalanga kandi bahala baanu bakubakwata, babatwale ewaa Si̱hooni̱ mukama wa Bamooli̱. ");
INSERT INTO tlj_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Bhaatu twabasi̱ngu̱u̱ye kandi twahwelekeleei̱ye kibugha kya Hesi̱bbooni̱ ku̱hi̱ka Di̱bbooni̱. Twabahwelekeleei̱ye ku̱hi̱ka mu kibugha kya Noofa, ku̱hi̱ka mu tau̱ni̱ ya Medeba.” ");
INSERT INTO tlj_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Nahabweki Banai̱saaleeli̱ baaghoona mu kyalo kya Bamooli̱. ");
INSERT INTO tlj_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Musa aatuma basaasa kubega kibugha kya Yajeeli̱. Banai̱saaleeli̱ baakikwata na maatau̱ni̱ agheeli̱ghi̱li̱i̱ye kibugha eki kandi baabhingamu Bamooli̱ abaabaagha baakaayemu. ");
INSERT INTO tlj_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Du̱mbi̱ Banai̱saaleeli̱ baakuuka kandi baakwama kihanda eki̱ghendi̱ye Bbasaani. Ogi̱ mukama wa Bbasaani na baasilikale be baasa kulwana na Banai̱saaleeli̱ mu tau̱ni̱ ya Edeleeyi̱. ");
INSERT INTO tlj_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Bhaatu Mukama aaghila Musa ati, “Otamwobaha, nanga naamali̱ye kukuha ye na baasilikale be boona kandi okutwala nsi yee yoona. Omukole ngoku waakoli̱ye Si̱hooni̱ mukama wa Bamooli̱, oghu akaba alemi̱ye mu Hesi̱bbooni̱.” ");
INSERT INTO tlj_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Nahabweki Banai̱saaleeli̱ baata mukama Ogi̱, batabani̱ be, mahe ghe ghoona na bantu be boona. Taaliyo muntu nʼomui oghu akati̱ghalʼo ali mwomi̱i̱li̱ kandi baatwala kyalo kiye kyona. ");
INSERT INTO tlj_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Niibuwo Banai̱saaleeli̱ baaghendi̱ye mu kiigbete kya Mowaabu kandi baaghoona haai na maasi Yolodaani̱, kibugha kya Yeli̱ko kili luhande lweli̱ lwa maasi agha. ");
INSERT INTO tlj_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Bbalaki̱ mukama wa Mowaabu, mutabani̱ wa Jipola, aaghu̱wa byona ebi Banai̱saaleeli̱ baakoli̱yʼo Bamooli̱. ");
INSERT INTO tlj_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Banamowaabu boobaha kwonini Banai̱saaleeli̱, nanga Banai̱saaleeli̱ bakaba bakani̱ye kwonini. ");
INSERT INTO tlj_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Banamowaabu baaghila beebembeli̱ baa Banami̱di̱yaani̱ bati, “Bantu bakaniiye kimui aba baku̱hwelekeeleli̱ya bintu byona ebyeli̱ghi̱li̱i̱ye etu̱we. Bakuba nga nte eghi ekuliyaagha bi̱si̱ngo byona byʼomu kisaka.” Nahabweki Bbalaki̱ oghu akaba ali mukama wa Mowaabu bwile obu kandi mutabani̱ wa Jipola, ");
INSERT INTO tlj_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","aatuma batumuwa kuleeta Bbalaamu, mutabani̱ wa Bbeyola. Bbalaamu akaba aakaaye mu tau̱ni̱ ya Petola haai na maasi ghaa Efulaati̱. Bbalaki̱ aatuma bantu kughila Bbalaamu bati, “Olole, ki̱bbu̱la kya bantu bakaniiye kimui kyalu̱ghi̱ye mu nsi ya Mi̱si̱li̱. Bantu aba bamalakaki̱ye nsi yoona kandi baghooni̱ye haai na ehanga lyanje. ");
INSERT INTO tlj_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Bantu aba bali na maani̱ kusaali̱ya si̱ye, nahabweki nkubbala wiise kandi obakiine. Kaakuba obakiina, nkugubha kubasi̱ngu̱la kandi kubabhinga mu ehanga lyanje. Nanga nimani̱ye ngu oghu okuhaagha mu̱gi̱sa akutungagha mu̱gi̱sa kandi oghu okukiinagha akutungagha mukiino.” ");
INSERT INTO tlj_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Beebembeli̱ baa Mowaabu na baa Mi̱di̱yaani̱ baaghenda kandi baatwala sente sya kusasula Bbalaamu haabwa mukiino oghu. Obu baaki̱dhi̱ye ewaa Bbalaamu, baamughambila ebi mukama Bbalaki̱ aabu̱ghi̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Bbalaamu aabaghila ati, “Mulaale hani mukilo eni, munkiya nkubaghambila eki Mukama akuba abu̱ghi̱ye.” Nahabweki beebembeli̱ bʼomu ehanga lya Mowaabu baalaala ewaa Bbalaamu. ");
INSERT INTO tlj_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Mukilo eghi Luhanga aasa kandi aabu̱u̱li̱ya Bbalaamu ati, “Basaasa abali ewaawe aba mbaki?” ");
INSERT INTO tlj_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Bbalaamu aaghila Luhanga ati, “Bbalaki̱ mukama wa Mowaabu, mutabani̱ wa Jipola, niiye aabatu̱mi̱ye ewanje naaghila ati, ");
INSERT INTO tlj_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Olole, bantu bakaniiye kimui baalu̱ghi̱ye mu nsi ya Mi̱si̱li̱ kandi baamalakaki̱ye kyalo kyona. Nahabweki wiise kandi obankiinile. Kaakuba okola eki nkugubha kulwana nabo kandi kubabhinga mu ehanga lyanje.’ ” ");
INSERT INTO tlj_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Bhaatu Luhanga aaghila Bbalaamu ati, “Otaghenda na basaasa aba kandi otakiina bantu abaalu̱ghi̱ye mu nsi ya Mi̱si̱li̱ aba, nanga ni̱i̱si̱ye naabahaaye mu̱gi̱sa.” ");
INSERT INTO tlj_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Nkyambisi ya kilo ekyalabhi̱yʼo, Bbalaamu aamuka kandi aaghila bakama aba Bbalaki̱ aatu̱mi̱ye ati, “Mukuuke mu ehanga lyanu, nanga Mukama aabhengi̱ye ku̱nsi̱i̱mi̱lani̱ya kughenda naanu.” ");
INSERT INTO tlj_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Nahabweki beebembeli̱ bʼomu ehanga lya Mowaabu aba baakuuka ewaa Bbalaki̱ kandi baamughila bati, “Bbalaamu aabhengi̱ye kwisa naatu.” ");
INSERT INTO tlj_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Du̱mbi̱ Bbalaki̱ aatuma bakama banji bakani̱ye kandi aba bantu bahu̱ti̱i̱ye kusaali̱ya bʼoku̱du̱bha. ");
INSERT INTO tlj_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Obu baaki̱dhi̱ye ewaa Bbalaamu baamughila bati, “Bbalaki̱ mutabani̱ wa Jipola niibuwo aaghila ati, ‘Gutu atabʼo kintu kyona ekikukutanga kwisa ewanje. ");
INSERT INTO tlj_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Nkukuha nsasu̱li̱ esemeeye kwonini kandi nkukola kyona eki oku̱bu̱gha. Gutu wiise kandi onkiinile bantu aba.’ ” ");
INSERT INTO tlj_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Bhaatu Bbalaamu aakuukamu basaasa aba ati, “Nankabha Bbalaki̱ ampa kikaali kiye ekiisuuyemu siliva na feeja, tanku̱keei̱ya kedha kwongela haa eki Mukama Luhanga wanje andaghiiye. ");
INSERT INTO tlj_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Nahabweki mulaale hani mukilo eni ngoku bʼoku̱du̱bha baakoli̱ye, nkubbala kumanya Mukama akaakuba ali na kintu eki akungambila.” ");
INSERT INTO tlj_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Mukilo eghi Luhanga aasa ewaa Bbalaamu kandi aamughila ati, “Basaasa aba ngoku baakwisiiye, oghende nabo, bhaatu okole eki nkukulaghila kyonkaha.” ");
INSERT INTO tlj_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Bbalaamu aamuka nkyambisi, aani̱i̱na haa ndogooi̱ yee kandi aaghenda na beebembeli̱ bʼomu ehanga lya Mowaabu. ");
INSERT INTO tlj_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Bhaatu Luhanga aasaaliluwa kwonini haabwa Bbalaamu kughenda kandi malai̱ka wa Mukama eemilila mu luguudhe kumutanga. Bbalaamu akaba ani̱i̱ni̱ye haa ndogooi̱ yee kandi baheeleli̱ye be babili bali hamui naye. ");
INSERT INTO tlj_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Obu ndogooi̱ eghi yaaboone malai̱ka wa Mukama eemiliiye mu luguudhe kandi akwete kihiyo mu ngalo, yaalu̱gha mu luguudhe kandi yaaghenda mu kisaka. Bbalaamu aatandika kughihuula kandi ku̱ghi̱ku̱u̱ki̱ya mu luguudhe. ");
INSERT INTO tlj_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Du̱mbi̱ malai̱ka wa Mukama aaghenda kandi eemilila mu kahanda kabhokaane akali haagati ya misili ebili ya mi̱jaabbi̱i̱bbu̱ eghi eli na bigho mpande syombi. ");
INSERT INTO tlj_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Obu ndogooi̱ eghi yaaboone malai̱ka wa Mukama, yeeki̱i̱ti̱ya haa kisiika eki kandi yaami̱ghi̱i̱li̱lʼo kughulu kwa Bbalaamu. Nahabweki Bbalaamu aatodha aaghihuula. ");
INSERT INTO tlj_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Du̱mbi̱ malai̱ka wa Mukama aaghenda kandi eemilila mu ki̱i̱kalo kibhokaane hambali hatali mwanya ghwa kwegaali̱ya haa luhande lwabuliyo kedha lwabumesu. ");
INSERT INTO tlj_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Obu ndogooi̱ eghi yaaboone malai̱ka wa Mukama, yaalangaala hansi, Bbalaamu anaghi̱ni̱i̱ni̱yʼo. Bbalaamu aasaaliluwa kandi aatandika kuhuula ndogooi̱ eghi na mwi̱gho ghuwe. ");
INSERT INTO tlj_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Du̱mbi̱ Mukama aaghula kanu̱wa kaa ndogooi̱ eghi, yaabu̱gha kandi yaaghila Bbalaamu eti, “Naaku̱koli̱ye ki uwe kumpuula milundi esatu eghi?” ");
INSERT INTO tlj_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Bbalaamu aakuukamu ndogooi̱ eghi ati, “Wanfooye nga mudhoma, nguli naabaagha na kihiyo nangu̱kwi̱ti̱ye endindi.” ");
INSERT INTO tlj_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Bhaatu ndogooi̱ eghi yaamukuukamu eti, “Buuye taani̱i̱si̱ye ndogooi̱ yaawe eghi oku̱ni̱i̱nagha bu̱li̱ kilo? Naalaku̱koli̱ye kintu nga kini?” Bbalaamu aaghila ati, “Bbaa.” ");
INSERT INTO tlj_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Mukama aaleka Bbalaamu aabona ngoku malai̱ka wa Mukama eemiliiye mu luguudhe kandi akwete kihiyo. Du̱mbi̱ Bbalaamu aateeli̱ya kandi haali̱i̱so yee aaku̱ma hansi. ");
INSERT INTO tlj_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Malai̱ka wa Mukama aamu̱bu̱u̱li̱ya ati, “Waahuuye ndogooi̱ yaawe milundi esatu nangaaki? Naasi̱ye hani kukutanga nanga tambali̱ye oghende Mowaabu. ");
INSERT INTO tlj_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Ndogooi̱ eghi yamboone kandi yeegaali̱ya kunjiluka milundi esatu. Ndogooi̱ eghi nguli etanji̱lu̱ki̱ye, endindi nangubaaye nkwi̱ti̱ye kandi eyo ngileka.” ");
INSERT INTO tlj_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Bbalaamu aaghila malai̱ka wa Mukama ati, “Naasi̱i̱si̱ye. Tanaamani̱ye ngoku aanuuwe waabaagha weemiliiye mu luguudhe kuntanga kughenda. Okaakuba otabbali̱ye oti ngende Mowaabu, nkukuuka.” ");
INSERT INTO tlj_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Malai̱ka wa Mukama aaghila Bbalaamu ati, “Oghende na basaasa aba, bhaatu obu̱ghe ebi nkukughambila byonkaha.” Nahabweki Bbalaamu aaghenda na bakama aba Bbalaki̱ aatu̱mi̱ye. ");
INSERT INTO tlj_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Obu Bbalaki̱ aaghu̱u̱ye ngu Bbalaamu niibuwo aasa, aaghenda kumusangaana mu kibugha kya Mowaabu haai na maasi Alu̱nooni̱ haa mutaano ghwa ehanga eli. ");
INSERT INTO tlj_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Bbalaki̱ aaghila Bbalaamu ati, “Tanaatu̱mi̱ye bantu nti wiise bwangu-bwangu? Tawaasi̱ye ewanje bwile obu nangaaki? Weeli̱li̱kanagha oti tankugubha kukusasula kusemeeye?” ");
INSERT INTO tlj_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Bbalaamu aaghila Bbalaki̱ ati, “Olole, endindi naasi̱ye, buuye okweli̱li̱kana oti nku̱bu̱gha kintu kyona eki mbali̱ye? Eki Luhanga akungambila niikiyo nku̱bu̱gha kyonkaha.” ");
INSERT INTO tlj_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Du̱mbi̱ Bbalaamu aaghenda na Bbalaki̱ mu kibugha kya Ki̱li̱yaati̱-hajoti̱. ");
INSERT INTO tlj_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Bbalaki̱ aahonga nte na ntaama kandi aaha simui haa nyama esi Bbalaamu na bakama aabaagha naye. ");
INSERT INTO tlj_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Nkyambisi ya kilo ekyalabhi̱yʼo Bbalaki̱ aani̱i̱na na Bbalaamu mu ki̱i̱kalo kikangami̱ye eki baaghilaghamu Bbamoti̱-bbaali̱ kandi Bbalaamu aabona bimui haa bi̱bbu̱la biinamu̱li̱to bya Banai̱saaleeli̱. ");
INSERT INTO tlj_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Bbalaamu aaghila Bbalaki̱ ati, “Onkwelele hani byakuhongelʼo bihonguwa musanju̱ kandi ondeetele ntu̱u̱li̱ sya nte musanju̱ na ntu̱u̱li̱ sya ntaama musanju̱.” ");
INSERT INTO tlj_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Bbalaki̱ aakola n