﻿USE sofia;
DROP TABLE IF EXISTS sofia.tlf_vpl;
CREATE TABLE tlf_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tlf_vpl WRITE;
INSERT INTO tlf_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesus Krais imi olal imi win uyo kalbu ko. Yesus beyo King Devit imi man ilop, minte Devit iyo Abraham imi man ilop no ko. ");
INSERT INTO tlf_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham beyo Aisak imi aalap, Aisak beyo Jekop imi aalap, Jekop beyo Juda so ilami isak atuk so ninggil imi aalap, ");
INSERT INTO tlf_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda beyo afaang man Peres sino Sera so imi aalap, minte Tama uta afaang man alop imi ogen no kale, Peres beyo Hesron imi aalap, Hesron beyo Ram imi aalap, ");
INSERT INTO tlf_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram beyo Aminadap imi aalap Aminadap beyo Nason imi aalap, Nason beyo Salmon imi aalap, ");
INSERT INTO tlf_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon beyo Boas imi aalap, minte Rahap uta Boas ilami ogen no kale, Boas beyo Obet imi aalap, minte Rut uta Obet ilami ogen no kale, Obet beyo Jesi imi aalap, ");
INSERT INTO tlf_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","minte Jesi beyo King Devit imi aalap no ko. Minte Devit beyo Solomon imi aalap, minte Baseba uta Solomon imi ogen no kale, kamaki uyo Baseba boyo tinum migik Uria imi kalel kuta, siit-kulu e, Devit ita tagaa kula ilami kalel kebesu kale, ");
INSERT INTO tlf_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon beyo Rehoboam imi aalap, Rehoboam beyo Abiya imi aalap, Abiya beyo Asa imi aalap, ");
INSERT INTO tlf_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa beyo Jehosafat imi aalap, Jehosafat beyo Joram imi aalap, Joram beyo Usia imi aalap, ");
INSERT INTO tlf_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia beyo Jotam imi aalap, Jotam beyo Ahas imi aalap, Ahas beyo Hesekia imi aalap, ");
INSERT INTO tlf_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia beyo Manase imi aalap, Manase beyo Amos imi aalap, Amos beyo Josaya imi aalap, ");
INSERT INTO tlf_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","minte Josaya beyo Jekonia so ilami isak atuk so ninggil imi aalap no ko. Kale Jekonia iso ilami isak atuk so ninggil iyo bom-bilip e, Israel tinum imi waasi Babilon kasel tinum iyo tal, Israel kasel iyo yemum o age tal dinan-bom kubaganip ita ita ke-bom-nilip e, yaafuu sok de imo imtamo unanbu no Babilon kasel ilimi abiip maak maak unemin kup kemsip ko. ");
INSERT INTO tlf_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kale Babilon kasel iyo Israel kasel iyo de imo kulep no ilimi abiip tolip e, Jekonia beyo Sealtiel dola e, minte Sealtiel beyo Serubabel imi aalap, ");
INSERT INTO tlf_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel beyo Abiut imi aalap, Abiut beyo Eliakim imi aalap, Eliakim beyo Aso imi aalap, ");
INSERT INTO tlf_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aso beyo Sadok imi aalap, Sadok beyo Akim imi aalap, Akim beyo Eliut imi aalap, ");
INSERT INTO tlf_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut beyo Eleasa imi aalap, Eleasa beyo Matan imi aalap, Matan beyo asegim Jekop imi aalap, ");
INSERT INTO tlf_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","minte Jekop beyo Josep imi aalap no kale, Josep imi kalel Maria uta Yesus dosu kale, Yesus beyo God imi ulaa dula kamok kesa tinum Krais o agan-nuubip ita ko. ");
INSERT INTO tlf_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kale Abraham imi ilaap daaba uyo ilop tiilam kwep talanbu tal Devit imi diim kwek diliit kesu uyo ki, ilop dagamin ulumi kup te tam mit kal fagasu ko. Kale ulutap kale, Devit imi ilaap daaba uyo ilop tiilam kwep top Babilon kasel imi tisip kwek diliit kesu uyo ki, ilop dagamin ulumi kup te tam mit kal fagasu kale, Babilon kasel iyo tebe Israel kasel imi waasi kebesipta kale, tal sok de imo imtamo unanbu no Babilon kasel ilimi abiip maak maak kugol fagagan-bii kupkalipta, bii-silip ko. Ulutap kale mungkup, abiip Babilon un-silip uyo ki, man ilop tiilam kwep talanbu tal God imi ulaa dula kamok kesa tinum Krais imi do-suu kwek diliit kesu uyo ki, ilop dagamin ulumi kup te tam mit kal fagaa no kesu ko. ");
INSERT INTO tlf_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kale kamaki Yesus Krais imi do-suu uyo kulbu kale, ogen Maria boyo Josep imi win baabelip bo kuta, atin ku-bom uso sinamin-tem bisop bom-silipta, God imi Sinik Tambal iyo tal Maria umi iibak tem iinata, utamuta, kumun so keli kalaa agelu kale, ");
INSERT INTO tlf_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","umi imak Josep o age win baabebip beyo tinum tambal kale, weng boyo kupkem daali alugum iyo tinangkulip Maria uyo fitom tebepmomu kale, sining age som-nilita, maagalo unang boyo kupkalan o age-nalata, ");
INSERT INTO tlf_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","bomi aget uyo fugun-salata minte, Bisel imi ensel maak tal ilam duluun weng uyo bogobe-nala e, “Devit imi man ilop Josep kabaa. Kapmi kalel o age win baapkebip Maria boyo kumun so kebu kuta, man mat tem kwek alba beyo God imi Sinik Tambal yagal tal bomi iibak tem iinata, kumun so kebu kale, kabo finanin ba kale, kalel uyo kulal o ageta kale, ");
INSERT INTO tlf_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","biilan-temu uyo, man dolan-temu beta tebe-nalata, alugum ilami tinum unang imi fengmin uyo takan kebelata, waalanan-temip kale, kabo bemi win uyo bogobe-nalap, ‘Dong dogobela waalanamin tinum o,’ age-nalapta, Yesus o agelal o,” age-nalata, ensel iyo bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kale sugayok uyo Bisel iyo tebe ilami profet Aisaya imi weng maak bogobelata, ita God imi suuk kon tem dola ko-se kale, ko tol mitam ti-suu kale, ");
INSERT INTO tlf_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","siin uyo bogobe-nala e, “Ibo botamin. Son-temu uyo, unang maak tinum so sinamin-tem som-nuluta, kumun so ke man tinum maak dolan-temu kale, man dolan-temu bemi win uyo Emanuel o agelan-temip o,” age-nalata, bogobe-se kale, win bomi magam uyo, “God iyo nuso alba o,” agesu ko. ");
INSERT INTO tlf_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kale Josep iyo agaal un-bom-sala Bisel imi ensel ilam duluun weng bogobela uta tinangku-nalata, fen-nalata, kalel uyo kula kuta, ");
INSERT INTO tlf_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","kalel so maak agam sina-bom utamamin-tem alba diim kugol man beyo doluta, Josep iyo man bemi win uyo bogobe-nala e, “Yesus o,” age-se ko. ");
INSERT INTO tlf_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Kale Herot imi Provins Yuudiya umi kamok king ke-bom bii-se kota, Maria uyo Yesus iyo Provins Yuudiya umi abiip Betleam kugol dolu bom-bala e, biningok umi kuguup utamsip tinum maak iyo ataan mitam telemin abiip ilota tal Jerusalam tal-nilip e, bogo-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Kamaa man maak dolu Juda kasel ipmi kamok king keba iyo dogap kal alba a? Nuyo ataan mitam telemin kugol bom-bulupta, biningok uyo tebe bemi dolu alba uyo kafalebelu utam-nulupta, tal fet dobe imi deng uyo tebemum o age-nulupta, tulup o,” agelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kale King Herot iyo kamok king migik imi sang boyo tinangku-nalata, beta tebe, nimi abiin uyo kulan-tema tap o age-nalata, aget yamyam uyo taga-bala e minte, alugum Jerusalam umi unang tinum igil aget yamyam uyo taga-bom no kemip kale, ");
INSERT INTO tlf_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herot iyo tebe-nala e, tinum amem ko age pris imi kamogimal so Juda kasel imi ulo utamsip tinum so iyo alugum afeta-nala e, dagala, “Ipmi God imi ulaa dula kamok kelan-tema tinum imi fen tebesip beyo dogap kal dolan-temu o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","bogobe-nilip e, “Provins Yuudiya komi abiip katip maak Betleam kugol dolan-temu kale, sugayok uyo God imi profet ko age weng kem baga-emin tinum maak isiik tebe bemi sang uyo dola ko bogobe-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betleam kasel ibaa. Ibo kafin Yuudiya kugol albip kale, son-temu uyo, ipmi tinum maak ita mitam kamok ke-nalata, nimi unang tinum Israel kasel bilip iyo alugum tiin molan-tema kale, kelata, Betleam kasel ipta win tibin ke-nilipta, Yuudiya kasel migik iyo kubaganip imkalan-temip o,’ age-nalata, dola ko-se o,” agelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kale Herot iyo tinangku-nalata, utamsip tinum tilip bilip iyo bantap weng uyo kobela tal tamip e, daga-nala e, “Kamaki uyo dogap kota biningok boyo mitam molu ibo utam-nilipta, man maak dolu kalaa age-nilipta, abo dulu tal-bilipta bii, kayop intap kal ke-nilipta, tilip o?” agela yan kebelip e, ");
INSERT INTO tlf_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","bogobe-nala e, “Ibo Betleam uyo no-nilipta, man beyo tele fen tiine-bom atamip umdii, weng kwep tal bogopnelipta, nagal no-nilita, bemi deng uyo tebe-bom-nilita, fet dobelan o,” age bisop bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kale king imi weng uyo tinangku-nilip e, kupkaa unip kale, siin ataan mitam telemin ilo kugol bom-bilip biningok mitam molu utam-silip usiik bon tem abe-buluta, ita umik tem abe-bilip bii, biningok uyo unanbu no man am alba umi dubom diim kutam kal moluta, ");
INSERT INTO tlf_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","no biningok uyo utam-nilipta, deng kup tebemip kale, ");
INSERT INTO tlf_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","tam am tam abomu, man so ogen Maria so afaat iyo albip kalaa age itam-nilip e, kamok kamok imi weng umka-emin uyo kanumin kale, imi katuun duung uyo fegela daak suk mo kalaak fen-nilip e, man bemi deng uyo tebe-bom fet duga-e-bom-nilip e, ilimi men tem mufekmufek tambal tambal abu kulep tilip uyo man bemi kobela kobela kemip kale, tuum gol so e minte at dan kwe fuulip tang tambal kuunin sino ok tang tambal kuunin so uyo kulu man imi kobelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kale God iyo tinum bilip iyo ilam duluun weng uyo bogobe-nala e, “Ibo no Herot iyo atam-nimip o,” agelata bole, kupkaa ilep migik ilep ilimi abiip unip ko. ");
INSERT INTO tlf_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kale daaginip e bole, Bisel God imi ensel maak tal-nala e, Josep imi ilam duluun weng uyo bogobe-nala e, “Kabaa. Herot iyo tebe, man beyo fen-bom atam-nilita, angkolan o age-nalata, fen tiineman-tema kale, kabo yuut fen-nalap man afaat bilip iyo kulep bilii daage no Isip kugol bom-balapta bii, asok maak so bogopkelan o,” agelata bole, ");
INSERT INTO tlf_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josep iyo mililep kota yuut fen tam man afaat iyo kulep-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","unanbu no kafin Isip kugol bom-bala bii, Herot iyo kaana kalaa age-nalata, kota asok kulep tala ko. Kale sugayok uyo God iyo bogo-nala e, “Nimi man tinum iyo kafin Isip kugol bom-balata, nagal olabelita, asok tala o,” age-nalata, God iyo ilami profet maak imi bogobelata, ita unang tinum iyo bogobe-nala e minte, suuk kon tem uyo dola ko no ke-se kale, Yesus so ogen Maria so Josep so ulimal imi kafin Isip kupkaa ti-silip bomi sang uta dola kosata, ko tol mitam ti-suu ko. ");
INSERT INTO tlf_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kale Josep ulimal iyo no Isip kugol bom-bilipta, Herot iyo utamata e, utamsip tinum bilip iyo bisop bogopne-nilipta, asok weng uyo kwep tal bogopnelin-tem ke daaginbip kalaa age-nalata, olsak kup deebelu kale, Herot iyo ilami siin utamsip tinum bilip imi daga bogobe-nala, “Dogap kota man maak dolu o age biningok uyo mitam mo kafalebelu utam-silip o?” agela bogobebip umi aget uta fugunolata e, kota man beyo kayop kanupmin dakan kela boyo mitam fitola kalaa age-nalata, ilami tinum iyo imdala no abiip Betleam so umi abiip mep so sino uyo tiine-bom-nilip e, alugum man tinum unaak imolip atol alop kelip so atol alop kelin-tem albip so iyo an tiinemip ko. ");
INSERT INTO tlf_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Abiip Rama uyo Betleam umi mep so kugol albu kale, sugayok uyo God iyo ilami profet Jeremaya iyo weng maak bogobelata, ita abiip bomi sang uyo bogo-nala e, “Rama kasel kutam iyo bubul fuyap tebebeluta, fomtuup ame-bilipta, tinangkulip kale, unang Resel umi man ilop ko age Israel kasel bilip iyo ilimi man kalan uyo ame-bilipta, ipkumal iyo, dong dogobelup mitam asok deng tebe-bilipta o agan-bilip kuta, numi man iyo binim kebip kalaa age-nilipta, yuut uun kon ku fuu kwep tam tolan-temaalup o age-nilipta, man imi tibi uta uga-nilipta, aman-bilip o,” agesa kale, Herot imi tinum no man an tiinemsip bomi sang uta bogosata, ko tol mitam ti-suu ko. ");
INSERT INTO tlf_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kale Josep ulimal iyo kafin Isip kugol bom-bilipta, Herot iyo bii-nala e, kaanata bole, Bisel imi ensel maak iyo tal-nala e, Josep iyo ilam duluun weng bogobe-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Kabaa. Tinum tebe, man unaak angkoli kaanak o agan-bii-se beyo kaanba kale, kabo kupkaa man afaat iyo kulep-nalap daage no kafin Israel unaal o,” agelata bole, ");
INSERT INTO tlf_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Josep iyo fen tam abe man afaat iyo kulep-nalata, no anang Israel uyo una kuta, ");
INSERT INTO tlf_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","“Herot imi man Akelaus isiik aalap imi baan diim uyo ku-nalata, Provins Yuudiya kasel imi kamok king ke-bom-nalata, alba o,” agelip tinangku-nalata, finano-nalata, Provins Yuudiya unon o agan-be uyo kupkala kuta, God iyo maak so ilam duluun weng uyo Josep iyo bogobelata, ");
INSERT INTO tlf_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ulimal iyo daage no Provins Galili uyo no-nilipta, abiip maak Nasaret kugol bii-silip ko. Kale sugayok uyo weng kem baga-emin tinum bilip iyo God imi ulaa dula kamok kesa tinum imi sang uyo bogobe-nilip e, “Biilan-temu uyo, bemi win uyo Nasaret kayaak o agelan-temip o,” agesip kale, ko tol mitam ti-suu ko. ");
INSERT INTO tlf_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Yesus so ogen aalap sino ulimal iyo kugol nuubipta, bii man iyo te tam fito ko tinum kiim kelata, kota tam ok sam uga-emin tinum Jon Baptis iyo tal Provins Yuudiya umi tinum binim iibaan kugol bom-balata, unang tinum iyo tele-bala tele-bala ke-bilipta, God imi weng uyo baga-e-bom-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","bogobela, “God imi tebe unang tinum imdep tam ilami daam tem daa tiin molan-tema uyo mep tulu kale, (ibo, God iyo numi fengam-nuubup uyo im-kuguman-tema kalaa age-nilipta,) ipmi fengmin uyo kupkaa aget uyo fupkela kolipta o,” age baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Sugayok uyo profet Aisaya iyo Jon imi sang uyo God imi suuk kon tem kal dola ko bogola, “Tinum maak iibaan kugol ol-bom bogo-nala e, ‘Ilep tambal umaak telelamipta, Kamogim iyo yuut talak o,’ age olan-be o,” age Aisaya iyo dola kobesa (kale, bomi magam uyo, “Ipmi aget uyo fupkela telelam-silipta, Yesus iyo talak o,” age-nuluta, bogosu) ko. ");
INSERT INTO tlf_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon iyo (siin God imi profet ko age weng kem baga-emin tinum Elaija imi kuguup kanu-bii-se uta ku-nalata,) ilim tambal migimin binim kale, imi ilim mafak uyo kong ko age kamel umi kon uta butu faabelip uta migi-nala e minte, kao umi kaal uta ugaa ku ol tiil ko age let telela ko magal fildela ilim uyo nagat molu e minte, iman tambal uyo fala-nalata, kubuluum so at tem umi tin ok so uta un-bom no ke-bii-se ko. ");
INSERT INTO tlf_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kale unang tinum kwiin tagang abiip miton Jerusalam kasel so minte Provins Yuudiya umi alugum abiip maak maak kasel so Ok Jodan umi magaang tem kasel so iyo, Jon imi weng uyo tinangkamum o age-nilipta, tal afeta-bii ko ");
INSERT INTO tlf_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Jon imi weng uyo tinangka-bom-nilip e, imi aget uyo fupkela ko-nilip e minte, God sino unang tinum so imi tiin diim uyo ilimi fengmin uyo kupkem daga-bom no ke-bilipta, Jon iyo tebe kulep te daak Jodan umi kumun tem to ok sam uga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Juda kasel imi kamogimal Falosi so Sadusi sino kwiin tagang iyo, Jon ita nuyo ok sam uga-emak o age-nilipta, imi finang uyo tal tal ke-bilip kuta, Jon iyo utamata e, imi aget uyo fupkela kolin-tem ke tilip kalaa age-nalata, bogobela, “Ibaa. God iyo tebe ipmi kuguup mafak umi kalan uta ifak daalan-tema kale, ibo aget fuguno-nilip e, no tamup Jon imi ok sam ugobelan-tema uta, God tebe numi kaal fuyap kopman-tema uyo uk kugan imolan-temu ko ageta talan-bom-nilip e minte, ibo inap imi baam atul finano bilii unan-nuubip ulutap ke-nilipta, nimi finang talan-bom no ke-bilip kuta, boyo ibo uk kugan imolan-temaalu binim kuba. ");
INSERT INTO tlf_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kuguup tambal uta ke-bilipta, boyo utamita e, ipmi aget uyo fupkela ko-nilipta, ipmi kuguup mafak uyo kupkabip kalaa age utaman o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kale ibo nimi weng kaa bogobelan-temi koyo tinangku-silipta. Ibo, ‘Nuta Abraham imi man ilop o,’ age deng taban-bilip kuta, kanube God iyo, Abraham imi man ilop kemin boyo miton o agan-be nimnam, God beyo tii kale, daak tuum boyo kulu-nala telela imola mitam tinum ke-nilipta, igil mungkup Abraham imi man ilop kwiin tagang kelan agin kuta, God imi tiin diim uyo Abraham imi man ilop kemin boyo fen katip kalaa agesa ko. Kale ibo bogo-nilip, ‘Abraham beyo numi afalik kale, God iyo, bemi tolop o age-nalata, nuyo telela imola tambaliim nan-temup o,’ agan-kalin ba kale, ipkil God imi ilak uyo duga-bilipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kale God iyo, at uyo doman o age-nalata, at miit tem kal kaabak uyo waafuu fiko kola kale, at alugum dogap uta at dum tambal abulin binim kesu uyo ano duula-nalata, at kwegala ken tebelan-temu ko. Ulutap kale, ibo kuguup tambal uyo waafulin binim kelan-temip uyo, God tebe imkan kelan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ipmi, tinum tolon-tema o age fen-bilip iyo naga ba kale, nisiik tilita, yagal aaltam nimi umik tem tolon-tema kale, beyo kamok miton kale, ita ita ke niyo kubagani nimkasa kalaa age-nilita, fitom tebepnebu kale, niyo fen tinum kale, niyo bagang-kale yang bemi miit tem uyo yang-nilita, imi yaan ilom uyo kulep-nilita, unomi binim ko. Kale ibo aget fupkela kolip uyo, niyo ok uta kulu-nilita, ipmi ok sam uyo uga-e-bii kuta, tinum tolon-tema bemi ok sam uga-eman-tema boyo fen ok ba kale, ilami Sinik Tambal ita tebe ipmi iibak tem aget mafak fugunin uyo at kwegabela ken tebeluta, ibo atin tambalanan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tam tinum imi sagam ku rais ko age wiit uyo bo-bii kulep tal tolip uyo, telela-bii umi kaal uyo kugan ke-nilip e, wiit dam uta kup kulep tam am to-nilip e minte, kaal uta abulalip ken tebe-bom no kemin ko. Kale mungkup ulutap kale, tam tinum tolon-tema beyo, unang tinum iyo ilo ko-nilita o age-nalata, ilami ilak dosip iyo afeta ko kulep no ilami abiip to-nala e minte, unang tinum imi ilak dolin binim ita at tenogamin binim, kenamin kup bomu umi tem kugol abulala ken tebelan-temip o,” age baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jon iyo kanum tiine-bala e, Yesus iyo, Provins Galili uyo kupkaa no Jodan bal no tamita, Jon ita ok sam ugopnelak o age-nalata, no tama e, ");
INSERT INTO tlf_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jon iyo fegelebelita, ok sam uyo kupkalak o age-nala e, bogopma, “Kabo God imi ulaa kamdula kamok kesap tinum kale minte, nita fen tinum kale, niyo ok sam uyo ugop-kaman-temaali binim kale, kapta tebeta niyo ok sam ugop-naman-temap kuba. Kale intaben o age-nalapta, bogopne-nalap, ‘Ok sam ugopnelal o,’ agan-balap o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesus iyo yan kebe bogopma, “Nugum kabaa. Kabo niyo ok sam ugop-naman-temap boyo, God imi weng kwep daasa uyo mitam tol kelan-temu kalaa age-nilita, bomi finang uta tili kale, kabo ok sam uyo ugopnelapta o,” agela e, Jon iyo tolong do-nala e, “O,” age ok sam ugopma ko. ");
INSERT INTO tlf_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jon iyo tebe Yesus iyo ok sam ugobela binimanu e, maak fagaa Yesus iyo ok tem uyo kupkaa mitam tama e, abiil tigiin uyo tem kalo kolu e, kiit fenata e, God imi Sinik iyo uun abim ulutap ke-nalata, malaak nimi diim uyo abela kalaa agela e, ");
INSERT INTO tlf_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","alop iyo tolong dolipta e, abiil tigiin kwiit ilota God imi weng kwaala tulu kwek uyo bogo-nala e, “Beyo nimi Man bubul kale, niyo bemi deng kup taban-bii o,” age bogopma e, tinangkulip ko. ");
INSERT INTO tlf_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jon iyo ok sam ugobela binimanu e, aaltam kota God imi Sinik iyo tebe, Yesus iyo duptamo no iibaan kugol daalita, Saatan tebe Yesus iyo dup-kugumak o age dep una ko. ");
INSERT INTO tlf_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesus iyo, iman uyo unelaali o age kupkaa bom-bala bii, am ulumi kup 40 kela koyo, Yesus iyo iman tep bom-balata minte, ");
INSERT INTO tlf_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Saatan iyo tal imi diim abe-nala e, bogopma, “Kabo fen tuluun God imi Man umdii, daak tuum boyo kulu fupkela kolapta, bret kelu unelap katamita, kabo fen God imi Man kalaa agelan o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesus iyo imi weng boyo yan kepma, “Umbae. God imi suuk kon tem kwek uyo bogo-nulu e, ‘Iman bomi unelan-temap boyo dam uta kup ifemin kale minte, boyo tebe kapmi aget fugunin uyo dong dogop-kaman-temaalu kale minte, kabo God imi weng uyo alugum tolong do waafulan-temap uta tebe kapmi aget fugunin uyo dong dogop-kaman-temu o,’ agesu (kale, bo kanube-nilita, iman unelan-temaali) o,” age bogopma ko. ");
INSERT INTO tlf_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kale minte Saatan iyo Yesus iyo dep unanbu no Jerusalam no abe-nala e, dep unanbu tam ulotu am miton umi am duu diim daa-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","bogopma, “Kabo fen tuluun God imi Man umdii, boyo mufekmufek umaak tebe kangkolan-temaalu kale, kaal binim isal kalota fon unanbu daak kafin diim abelal a. God imi suuk kon tem kwek uyo bogo-nulu e, ‘God ilami ensel iyo bogopma tal kabo tiin molipta, kangkolan-temaalu o,’ agelu e minte, maak uyo bogolu, ‘Ensel igil kaafuu kafolan-temip kale, tuum daang umaak tebe kapmi yaan uyo malaa kwaap-kaman-temaalu binim o,’ age no kesu kale, kabo kumen daak kafin diim abelapta, unang tinum kulaak albip iyo utamipta e, kabo fen God imi Man kalaa agomip o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesus isiik bogobe-nala e, “Umbae. God imi suuk kon tem kwek uyo bogo-nulu e, ‘Bisel beyo kapmi God kale, beyo dup-kugu-bom bogobe-nalap, “God kabo nimi weng bogopkeli boyo tinangku kanube-nalapta, kek kek iyo kafalebelapta, utamipta e, God kabo nimi ilak uta duga-bom dong dagane-balap kalaa kagelin o,” agan-kalin ba o,’ agesu o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kale Saatan iyo Yesus iyo duptamo unanbu tam amdu dubom diim daa-nala e, alugum kafin kaa kutufosu komi tinum miit maak maak so minte, unang tinum bilip imi mufekmufek telelam unsip so uyo kafalepma utama e, ");
INSERT INTO tlf_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","bogopma, “Kabo nalami tibit diim kal katuun duung fegela daak ton-nalap bogopne-nalap, ‘Kabo nimi kamogim o,’ agelap umdii, nagal alugum kafin kaso tinum miit so mufekmufek so koyo kop-kamita, kapkal tiin molan-temap o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesus iyo bogopma, “Saatan kabo nimka-nalap daaginaal a. God imi suuk kon tem kwek uyo bogo-nulu e, ‘God ita kup kapmi Bisel kale, beta kup katuun duung fegela daak ton aman duga-e-bom-nalap e minte, imi weng uta kup tinangka-bom no kemal o,’ agesu kale, niyo katuun duung fegela kabo aman dopkelan-temaali kuba,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Saatan iyo tolong do-nala e, kota dup-kugumin uyo kupkaa daagina e, ensel iyo tal Yesus iyo dong dogobe tiin mo-bom-nilip e, iman ifemip ko. ");
INSERT INTO tlf_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kale Yesus iyo sep iibaan kugol alba uyo kupkaa no Provins Yuudiya kal bom-balata, Herot imi un tubulin bilip iyo Jon iyo aafuu dep no daalip kalabus am kal bom-bala e, Yesus iyo Jon imi sang uyo tolong do-nala e, Provins Yuudiya uyo kupkaa Provins Galili una ko. ");
INSERT INTO tlf_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kuta no ilami abiip Nasaret uyo nama binim kupkaa daage no abiip Kapeneam kal na ko. Abiip Kapeneam uyo Galili Ok Muk mep so kal albu kale, abiip boyo Sebulun so Naptali so imi man ilop imi kafin kugol albu ko. ");
INSERT INTO tlf_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kale sugayok uyo Aisaya iyo Yesus imi no Kapeneam kugol nan-tema bomi sang uyo God imi suuk kon tem uyo dola kosa kale, weng boyo ko tol mitam tuluta, Yesus iyo no kugol bii-se ko. Kale uyo Aisaya iyo bogo-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulun so Naptali sino alop imi man ilop imi kafin uyo yak Jodan milii kulota kwep unsu ki kwep yang yol ok kan tem kugol diliit kesu kale, imi kafin bomi win uyo Galili o age-silip kuta, kamano koyo unang tinum asit kek kek kwiin tagang ita tal kutam kal albip ko. ");
INSERT INTO tlf_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kale kamano koyo kafin bomi kasel iyo mililep ko age fengmin umi baan diim kal albip kale, kaan maagalo ke imi win uyo binimanan agin kuta, siit ilugolan-temu uyo, ilagenamin kwiin kiim uyo tulu utam-nilipta, bilip iyo ilagenin diim kal nan-temip o,” age Aisaya iyo Yesus imi sang uyo dola ko-se ko. ");
INSERT INTO tlf_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kota Yesus iyo God imi weng uyo kufo-nala e, unang tinum iyo baga-bom-nala e, bogopma, “God imi tebe unang tinum imi imdep mitam ilami daam tem daa tiin molan-tema uyo mep tulu kale, (ibo, God iyo numi fengam-nuubup uyo im-kuguman-tema kalaa age-nilipta,) ipmi fengamin uyo kupkaa ipmi aget uyo fupkela ko-nilipta o,” age baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kale am maak daanu e, Yesus iyo Ok Muk Galili umi kan tem ku-tele abe-bomta, kek fenata e, aniing abu kulep no tolip saanin tinum alop maak ogok ke-bom-nilip e, aniing abumin umi men uyo kwaalip daak ok tem iinu aniing fen-bilip kalaa age-nala e, itama kale, tam maak imi win alop uyo Saimon o agan-bom-nilip e minte, Fita o agan-bom no kem-nuubip yagal e minte ilami niing Andru yagal no alop kulip ita itama ko. ");
INSERT INTO tlf_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Kale Yesus iyo bogopma, “Nugumal ibaa. Ipmi ogok ke-bilip boyo kupkaa tilipta, nisino ninggil abe-bomta ogok migik umaak kobe imdalita, aniing abum-nuubip kulutap kem tiine-bomta unang tinum iyo afeta imdep meng God imi miit tem daagamin o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","alop iyo tolong do-nilip e, maak fagaa aniing abumin men uyo bisat kupka-nilip e, Yesus imi daang begebe unip ko. ");
INSERT INTO tlf_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kale Yesus iyo alop iyo imdep mep ko daage yang abomu, minte Sebedi imi man tinum alop Jems so ilami niing Jon so alop iyo albip kalaa age itama kale, alop igil mungkup aniing abumin tinum kale, aalap Sebedi sino ulimal ilimi bot tem kal ton-bom-nilip e, ulimal ilimi aniing abumin men dalata taban unbu uyo bigina-bilip kalaa age itam-nala e, Yesus iyo bogopma, “Nugumal ibaa. Ipmi ogok ke-bilip uyo kupkaa tilipta, niso ninggil abe-bomta nimi ogok usiik maak kobelita, ogok kemin o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","tolong do-nilip e, maak fagaa aalap iyo bot tem kutam kal dupka-nilip e, alop no Yesus imi daang begebe daaginip ko. ");
INSERT INTO tlf_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesus iyo Provins Galili umi abiip maak maak uyo yakyak kem tiinema uyo, no abe tam ulotu am uyo tam God imi weng tambal uyo unang tinum iyo kafale-bom-nala e minte, bogobe-nala, “Kanube ibo ilipmi fengmin umi aget iluum uyo ku fengmin uyo kupkalip umdii, God iyo ipmi fengmin uyo kupkabe-nalata, imdep tam ilami daam tem daa-nalata, tiin molan-tema o,” agan-bom-nala e minte, unang tinum mafak ilin ugulumi migik migik umkan unsip iyo telela imka-bom no kem tiinema ko. ");
INSERT INTO tlf_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kale unang tinum iyo Yesus imi kanu-be bomi sang uyo en-bilip senganu e, unang tinum simanim Provins Siria kasel igil mungkup tolong do-nilip e, imi abiip maak maak uyo kupkaa imi ipkumal mafak ilin umobip iyo imtamo Yesus imi finang telemip kale, unang tinum bilip imi mafak ilin umobip boyo ki, tam kaal mimin min, iibak tem atul tebemin min, sinik mafak tebe ifak daasu min, malap miin daam kesip min, yaan sagaal disanebesu min ita kulep tele-bilipta, Yesus iyo alugum telela imka-bala tambalanamip ko. ");
INSERT INTO tlf_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kale kanu-balata, unang tinum kwiin tagang iyo Yesus imi finang uyo Provins Galili ilota tele-bala, Provins Dekapolis ilota tele-bala, abiip miton Jerusalam ilota tele-bala, Provins Yuudiya umi abiip maak ilota tele-bala, Ok Jodan umi yak milii umi abiip maak maak ilota tele-bala no ke-bii afeta kolipta, Yesus isino unip ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesus iyo itamata e, unang tinum kwiin tagang iyo tal afetalip kalaa age-nala e, tam amdu tigiin uyo tam-nala e, daak tona e minte, ilami okumop man kwiin tagang iyo tal imi mep so kugol ton no kelip e, ");
INSERT INTO tlf_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yesus iyo weng uyo kupka-e-bom-nala e, kafalema ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Kale tam kamaki uyo Yesus iyo bogobe-nala e, “Unang tinum iip maak maak iyo utamipta e, nuyo bagang-kale God imi kuguup tambal uyo waafulan-temaalup kalaa agelip kuta, God iyo tebe imdep mitam ilami daam tem daalan o angba kale, yagal imi titil uta kobelata, bilip iyo God imi kuguup tambal uyo waafu-bom-nilipta, tambaliim kup ton-bom-nilip e, deng tebe-bom no keman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Kale minte unang tinum migik iip maak maak iyo utamipta e, ipkumal iyo fengamip kalaa age-nilipta, imi aget tem uyo mafaganebeluta, amemip kuta, God yagal dong dogobelata, asok aget bilili agan-bom-nilip e minte, deng tebe-bom no keman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Kale unang tinum iip maak maak iyo, nuta kanupmin o agan-bom ilimi tok uyo bagamin binim dukmenip umdii, bilip iyo God imi tiin diim uyo win so kalaa age-nala e, ilami weng kwep daabe-nala, ‘Boyo ipmi kobelan-temi o,’ agesa uyo yagal kobelata, deng tebeman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Kale unang tinum iip maak maak iyo, kuguup tambal uta kup ke-bulupta, God iyo deng tebemak o agan-kalip umdii, God yagal dong daga-e-balata, tol kup unang tinum ke-bom-nilipta, deng tebeman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Kale unang tinum iip maak maak iyo inal o agan-bom-nilipta, ipkumal iyo kuguup tambal uyo kupka-emip umdii, God isiik inal o agan-bom-nalata, kuguup tambal uyo kupka-e-balata, deng tebeman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Kale unang tinum iip maak maak iyo aget alop fugunin binim, imi aget fugunin uyo maagup e minte tol kup no umdii, bilip iyo no God sino suun abiip kal nan-temip kale, bomi deng uta tebeman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Kale unang tinum iyo dogap ita wengaal digin-bom dinan-bom kemip uyo, ipkumal iip maak maak ita tebe iibak tem kulagal mo-nilip e, fegele-bilip kupkaa aaltam weng uyo telela ko kwek iina tala keman-temip bota, God iyo bogo-nala e, ‘Ipkumal fegelemin tinum bilip ita nimi man o,’ agelata, deng tebeman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Kale unang tinum iip maak maak iyo kuguup tambal tebesu uta kup waafusip kale, bomi kalan uta tinum mafak mafak iyo tebe itafinon-bom-nilip e minte, ifak daga-bom no kem-nuubip kuta, kuguup tambal waafulin bilip iyo God iyo tebe imdep mitam ilami daam tem daalan o angba kale, tambaliim kup ton-bom-nilip e, deng tebe-bom no keman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ibaa. Ibo nimi okumop man kale, unang tinum dogap ita niyo nitafinonip umdii, bilip ita tebe ibo weng mafak uyo kupka-e-bom-nilip e, kuguup mafak mafak uyo kupka-e-bom-nilip e, bisop weng uyo kupka-e-bom ipmi win uyo kufak daga-e-bom no kem-nuubip kuta, ibo deng tebeman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kale sugayok uyo God imi profet ko age weng kem baga-emin tinum iyo ipmi ogok kanu-bilip kulutap ke-bom-nilipta, God imi ogok uyo ke-bii-silip kuta, tinum kuguup mafak waafulin iyo tebe-nilipta, kanupmin kuguup mafak uyo profet iyo kupka-emsip kuta, iyo maak fifik fafak nin binim, titil fagagamsip (kale, ibo bomi aget uyo fugun-bom-nilipta, fifik fafak nin ba kale, titil fagaa bom-bilipta o ageta) ko. Kale son-temu uyo, God yagal ibo imtamo no abiil tigiin daa-nala e, kuguup tambal kup kupka-eman-tema kale, deng afalik kup tebe-bom-nilipta o,” age Yesus iyo ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yesus iyo do weng alop maak bogobe-nala e, “Kanube yol uyo abaal tebelin binim kelu umdii, dogobeta telela kolupta, yol bomi abaal uyo tabon-temu a? Boyo atin binim ko. Kale unang uyo, iman tet abu fuulan o agelu uyo, utamuta, yol koyo mafaganbu kalaa agelu uyo, boyo ku tubulan-temaalu binim kale, kwaalu tam abiip abeluta, unang tinum iyo umi diim ilep ku-tele une-bom tele-bom keman-temip ko. Kale God imi unang tinum ibo yol abaal tebebu ulutap ke kuguup tambal uta kup ipkumal iyo kafale-bilipta, iyo iman yol tubulu abalim tebebu ulutap ke mitam tambaliim kelan-temip ko. Kale minte ibo kuguup tambal uyo waafulan-temaalip uyo, ibo God imi ogok kemin tinum keman-temaalip kale, ibo yol mafak kelu kwaalu unebu kulutap kelan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ulutap kale, God imi unang tinum ibo yogon dong ulutap ke kuguup tambal uyo ke-bilipta, ipkumal kek kek iyo ibo itaman-temip kale, mungkup ibo abiip amdu tigiin albu ulutap kale, unang tinum simanim albip iyo tebe ibo itaman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tinum dok ita ilaam uyo kefo ko kwep daak baket tem kulagal kubalan-temaala binim kale, kefo kwep tam ulumi baan diim daalata, am uyo ilagenuta, unang tinum am kutam albip iyo mufekmufek uyo tambaliim utaman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ibo yogon dong umi yang uulmong tem kuso ilagenabu ulutap ke kuguup tambal uta kup ipkumal kek kek imi tiin diim uyo kafale-bilipta, utam-nilipta, imi aget fugunin uyo bam daabeluta, ipmi Aalap abiil tigiin kayaak God imi win uyo kufumin o,” age Yesus iyo do weng alop boyo ilami okumop man imi bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Kale Yesus iyo weng uyo maak so bogopma, “Ibo aget fuguno-nilip, ‘Beyo tal God imi ulo Moses imi dola kosa so e minte God imi profet ko age weng kem baga-emin tinum imi weng dola kosip so uyo kupkan kem ti-se o,’ nagan-kalin ba ko. Niyo boyo kupkan kelan o age tisaali kale, niyo tal-nilita, bilip imi weng boyo waafu-nilita, unang tinum iyo kafale-bili tele waafulin o age-nilita, ti-sii ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nimi weng baga-eman-temi koyo tele tinangku bom-silipta o ageta kale, tam kafin diim so abiil tigiin so komi nan-temu uyo, God imi ulo Moses imi dola kosa umi atuk atuk uyo alugum ugol mungkup nan-temu kale, alugum ibo ki boyo suun kup waafuu bom-bilipta o ageta ko. Son-temu nala God imi bogo-nala, ‘Bo kanubelan-temi o,’ age-se bomi kanubela alugum binimanan-temu kota, God imi ulo ugol mungkup binimanan-temu ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Boyo dam kale, tinum dogap ita God imi weng atuk umi sang uyo bogo-nala, ‘God imi weng boyo win binim o,’ age-nala e minte, ipkumal iyo kanupmin kuguup boyo kafale-bom no ke-bala igil mungkup kwaasulamip umdii, bemi tam God imi daam tem nan-tema uyo, God imi tiin diim uyo win binim nan-tema kale minte, tinum dogap ita God imi weng uyo alugum tinangka-bom-nala e minte, ipkumal iyo kanupmin kuguup boyo kafale-bom no ke-bala igil mungkup waafulip umdii, beta no God imi abiip nan-tema uyo, God imi tiin diim uyo tambaliim kup daga daga diim kugol bom-balata, God iyo bemi win uyo kufu-eman-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nimi weng koyo tinangku-silipta. Ulo utamsip tinum so Falosi iso iyo God imi weng uyo dagaa kusip kale, bilip iyo tinum imi tiin diim uyo win so kuta, bilip iyo God imi ulo bota kup waafu-nimip binim kupka-nilipta, kuguup tambal waafuu som, kuguup mafak waafuu no kem-nuubip kale, God iyo bilip imi deng afek umaak tabanbaala ko. Kale ibo, God imi abiip unum o agelip uyo, ipmi God imi bogobe, ‘Kanumin o,’ agan-be bomi fomtuup waafulan-temip bota tebe bilip imi God imi ulo waafusip uyo kubaganu ipmi God imi weng waafulan-temip uta uta kelu imkalu God iyo imdep mitam ilami daam tem daalak o,” age Yesus iyo weng kem uyo ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Kota Yesus iyo asok bogobe-nala e, “Sugayok Moses imi tebe olal imi bogobesa umi sang uyo baga-e-bilipta, ibo tinangkan tebesip kale, kwek uyo bogo-nulu e, ‘ “Kabo kapkum be angkolap kaanamin ba o,” agesu kale, tinum dok ita ipkum angkola iyo dep te yang weng telelmin tinum imi diim daalapta, yagal umi saanin uyo kobe-nama o,’ agan tebesip kale minte, ");
INSERT INTO tlf_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","nita weng migik maak bogobelan-temi kale, tinangku-silipta. Tinum dok ita ipkum iyo bubul atul kobela umdii, boyo ipkum iyo tebe dep no kamok imi diim daala weng bagaman-tema kale, ibo bo kanumin ba ko. Kale minte tinum dok ita ipkum iyo weng mafak umaak kobela umdii, ilami kuguup mafak bota tebe dep te yang kot afalik diim daaluta, weng telelmin tinum beyo tebe yega dobe-nama kale, ibo bo kanumin ba ko. Kale minte aa mungkup tinum dok ita ipkum iyo bogobe-nala, ‘Kwiin. Kabo fuut tibin tinum o,’ agela umdii, God tebe beyo daala no at mafak suun kenamin abiip unoma kale, ibo bo kanumin ba ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kale kabo mufekmufek umaak kwep te tam God imi ulotu am miton unom-nili, ‘Suguul o,’ agan-kalin uyo God imi kobelan o agelap umdii, aget uyo tele fugunolapta. Kapmi kapkum beyo dogonupmin kuguup mafak umaak kobebi kalaa agelap umdii, ");
INSERT INTO tlf_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","asok kapmi mufekmufek God imi kobelan o agan-balap boyo kwep daa-nalap yuut no kapkum iyo dep meng daalap, alop weng uyo telela ko aget maagup kelup kalaa age-nalapta, uta asok tal-nalapta, kapmi, ‘Suguul o,’ agan-kalin mufekmufek uyo God imi kobelal o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Kale kanube kapkum iyo tebe bogopke-nala, ‘Kuguup mafak kepnelap kale, kamtamo no weng telelmin tinum imi diim daalan o,’ agela umdii, alop ibo yang weng telelmin tinum imi diim abelin-tem somta, kabo yuut kapkum imi diim unap alop ibo weng uyo telela ko aget maagup ke-nilipta, kupkalin o ageta ko. Kale minte kabo kamaki kugol boyo telela kolin-tem kelap umdii, kapkum beyo kamdep yang kamdala yak weng telelmin tinum imi diim abelapta, ita yega dopke kamdala yak un tubulin imi sagaal diim abelapta, ita tebe sok de kamdalip tam kalabus am unon-temap ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kale kugol bom-balap bii, kapmi fengmin uyo alugum molap atin binimanuta, talaa kamdalip mitam e tolon-temap ko. Kale tuluun weng uta bogopkeli kale, kabo nimi weng boyo tele tinangku-nalapta o,” age Yesus iyo ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Kota Yesus iyo asok weng migik maak bogobela ko. “Sugayok Moses imi weng bogosa umi sang uyo baga-e-bilip ibo tinangkan tebesip kale, kwek umi bogo-nulu, ‘Unang digin tinum digin kabo sa dagamin ba o,’ agesu kale minte, ");
INSERT INTO tlf_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","nita weng migik maak bogobelan-temi kale, tinangku-silipta. Tinum dok ita ipkum imi kalel uyo utam-nala, boyo nalami kalel kup keluk o agela umdii, bemi aget ko fugun-be boyo tinum ipkum imi kalel uyo dupkeng daga-bom sa dagamin umi kuguup uyo kulbu kuba. ");
INSERT INTO tlf_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kale kapmi tiin milii ipkuk uyo tebe kuguup mafak uyo kafalepkelu keman o angbi kalaa agelap umdii, kalapmi tiin milii ipkuk bo dagaa kwaalap unu tiin milii tumon ke-nalap kuguup mafak uyo kupkaa bii kaan-nalap tam God imi abiip kal suun kup nan-temap bota atin tambaliim kuta minte, kabo, tiin milii uyo dagaa kupkan kelaali o age kuguup mafak kup ke-bii kaanap kalaa age-nilip God imi ensel iyo tebe kamdalip no at suun kup kenamin abiip unon-temap boyo tambaliim ba ko. (Kale kabo kapkum imi kalel uyo kek fen tele utamamin ba ko.) ");
INSERT INTO tlf_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ulutap kale, kapmi sagaal ipkuk uyo kamtamo yang daalu kuguup mafak uyo keman o angbi kalaa agelap umdii, kalapmi sagaal bo ugaa kwaalap unu sagaal milii tumon ke-nalap kuguup mafak uyo kupkaa bii kaan-nalap tam God imi abiip kal suun kup nan-temap bota atin tambaliim kuta minte, kabo, sagaal milii uyo ugaa kupkan kelaali o age kuguup mafak kup ke-bii kaanap kalaa age-nilip God imi ensel iyo tebe kamdalip no at suun kup kenamin abiip unon-temap boyo tambaliim ba o,” age Yesus iyo ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Kale Yesus iyo asok bogo-nala e, “Sugayok uyo Moses iyo bogo-nala e, ‘Tinum dok ita imi kalel uyo kupkali o agela umdii, boyo bong fagamin ba kale, imak kabo suuk kon maak dola ko kalel umi kobelapta, kwep-nuluta, unon-temu o,’ agesa kale minte, ");
INSERT INTO tlf_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","nita weng migik maak bogobelan-temi kale, tinangku-silipta. Kanube tinum dok ita imi kalel uyo sa dagamin binim, tambaliim kup albu kuta minte, yagal tebe, kupkali o age kupkala boyo, yang tinum migik iyo dulu umdii, God imi tiin diim uyo imi kalel kusino tinum migik dulu kuso bilip imi kanubelip boyo sa daga-bom-nilipta, unang umi kamaki imak iyo dupkeng daga-bom dufak dagan-bilip kalaa agelan-tema ko. Kuta aaltam imak so unang kuso imi san uta kup ba kale, kamaki imak imi san no kale, ita tebe-nalata, agam iyo imdala yak sa dagamin bomi diim uyo abelip kale, ukmal asuno kano fengmin bomi yuum uyo kulip o,” age Yesus iyo ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Kale Yesus iyo weng migik maak bogobe-nala e, “Sugayok Moses imi tebe olal imi bogobesa umi sang uyo baga-e-bilipta, ibo tinangkan tebesip kale, kwek uyo bogo-nulu e, ‘Kabo kapkum imi diim kal weng kwep daabe-nalap, “Kanubelan-temi o,” age-nalap God imi win kamkaam uyo kufo-nalap kapmi weng boyo kuntuk mobelap umdii, weng boyo ilo kupkamin ba o,’ agesu kale minte, ");
INSERT INTO tlf_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","nita weng migik maak bogobelan-temi kale, tinangku-silipta. Kabo weng kwep daalan o agelap umdii, kabo God imi win kamkaam min, mufekmufek umi win kamkaam uyo kufo-nalap kapmi weng boyo kuntuk saanemin ba ko. Kale tam abiil tigiin boyo God imi abiip e minte, ");
INSERT INTO tlf_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","kafin diim koyo God yagal telela ko-nala e, tiin mo no kesa e minte, aa mungkup Jerusalam boyo king afalik God imi abiip kafin diim komi albu uyo kulbu no kale, kabo alugum mufekmufek komi win kamkaam uyo kufo-nalap kapmi weng boyo kuntuk saanemin ba ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kale aa mungkup bagang-kale-nalapta, kalapmi dubom kon maagup iyo maak fupkela dolap iim kela e minte, namaal ke no ke-nama binim kale, God maagup ita kup boyo kanupmoma kale, kabo kapmi dubom umi win kamkaam uyo kufo-nalap kapmi weng boyo kuntuk saanemin ba kwa. ");
INSERT INTO tlf_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kale kabo, dok umi win umaak bogo-nili nimi weng kwep daalan-temi boyo titil fagalu kupkalan o agelap umdii, boyo Tinum Mafagim Saatan ita bogopkelata, bisop weng boyo bagaman-temap ko. Kale dam weng uta kup baga-bom-nalap, ‘Boyo kanubelan-temi o,’ agelap uyo, kanu-bom-nalap e minte, ‘Boyo kupkalan-temi o,’ agelap uyo atin kup-kaga-bom no ke-bom-nalapta o,” age Yesus iyo ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Kale Yesus iyo weng maak bogobe-nala e, “Sugayok Moses imi weng bogosa umi sang uyo baga-e-bilip ibo tinangkan tebesip kale, kwek uyo bogo-nulu e, ‘Tinum iyo kapmi tiin uyo dagaa kwaapkela umdii, kapkal kapmi tiin umi yan uyo tii-nalap imi tiin uyo dagaa kwaabe-namap o,’ age-nulu e minte, ‘Kangko kapmi sit uyo malaa kwaapkela umdii, kapkal kapmi sit umi yan uyo tii-nalap imi sit uyo malaa kwaabe-namap o,’ age no kesu kale minte, ");
INSERT INTO tlf_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","nita weng migik maak bogobelan-temi kale, tinangku-silipta. Kanube tinum iyo kuguup mafak kopkela uyo, kapkal imi kuguup mafak kopkela boyo kapsiik tebe yan kemin ba e minte, beyo, kuguup mafak kopkelan o agela umdii, kabo ‘Waago o,’ agan-kalin ba no ko. Kale boyo ki, kanube tinum iyo kapmi agak kun ipkuk uyo kul baang ku binola umdii, kabo fupkela agak kun milii uyo kobelap bino no ke-nama ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kale kanube kapkum imi mufekmufek kopkela yuum kubap uyo yan kebelin binim bom-salap kapkum iyo tebe, kamdep no weng telelmin tinum imi diim daalita, kapmi siyot uyo yagal, dagaa ku kopnelak o agela kalaa agelap umdii, kapmi siyot uyo kobe-nalap e minte, kalapmi diil katinmin ko age saket uyo kobe no kemin ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kale kanube un tubulin iyo, maak kabo asit kup kamtamolita, nimi mufekmufek uyo kulupne no iip to talapta o agelan-tema uyo, boyo olsak tebemin ba kale, kapta, tambaliim o age no abe imi bogopke, ‘Kugol o,’ ageba uyo kupkan ke unanbu no simanim tobe tolon-temap ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kale mungkup kanube tinum iyo kapmi mufekmufek dagala uyo, kupka-emin ko. Kale kanube tinum iyo, kapmi mufekmufek uyo maak kopnelapta, kwep unan siit-nilita, asok kupke tolon o agela uyo, kabo, ‘Waago o,’ agan-kalin ba o,” age Yesus iyo ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Kale Yesus iyo asok bogobe-nala e, “Siin umi weng uyo baga-e-bilip ibo tinangkan tebesip kale, Moses imi weng uta bogo-nulu e, ‘Ibo ilipmi duup imi aget uta kupka-emin o,’ agelu e minte, amalabal imi weng uta bogo-nulu e, ‘Ibo waasi ita bon dii-emin o,’ age no kesu kale minte, ");
INSERT INTO tlf_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","nita weng migik maak bogobelan-temi kale, tinangku-silipta. Ibo waasi imi aget uta kupka-e-bom-nilip e minte, dok ita ibo kuguup mafak uyo kupka-e-be kalaa agelip umdii, ibo beten ke-bilipta, God yagal dong daga-emak o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kale ipmi Aalap God abiil tigiin alba imi ataan uyo kefo kwaala malaak tinum tambal so tinum mafak so alop maagup imi diim uyo abelu e minte, wep uyo kwaala malaak tol tinum so fengmin tinum so alop maagup imi diim uyo abe no kem-nuubu kale, kanube ibo tebe ipmi duup imi aget kobelin tap ke ipmi waasi imi aget uyo kobelip umdii, Aalap God yagal tebe ibo telela imola ilami man kelan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kale kanube ibo asit kek kek iyo imkaa ipmi aget uyo unang tinum imi aget ipmi kobebip ita kup imi kobelip umdii, God iyo tebe boyo utam-nalata, bogobe-nala e, ‘Ibo tinum tambal o,’ age-nalata, mufekmufek tambal uyo delepman-tema bele ki? Umbae. Tinum iyo alugum mungkup ilimi duubal imi aget uyo kupka-e-bilip e minte, takis mani kwaamin tinum mafak igil mungkup bisop baga-bom ipkum imi aget uyo kobina tala kem-nuubip no kuba. ");
INSERT INTO tlf_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kale kanube ibo ilipmi duup ita kup fet duga-emip umdii, boyo dogobeta tinum migik iyo kubaganipta, ipta ipta kepman-temip a? Umbae. God imi ilak dolin binim igil mungkup ilimi duup ita kup fet duga-em-nuubip kale, ipkil mungkup imi kuguup ko kanum-nuubip bota ipkil kuta kanum-nuubip kuba. ");
INSERT INTO tlf_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kale ibo ilipmi duup iyo telele-bom-nilip e minte, ilipmi waasi iyo telele-bom no ke-bom-nilipta, kanube ilipmi Aalap abiil tigiin kayaak imi kuguup tambal uta kup suun kanu-boma ulutap ke-bom-nilipta o,” age Yesus iyo weng kem boyo ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Kale Yesus iyo tam weng maak uyo bogobe-nala e, “Ibo, kanu-bulupta, unang tinum iyo nuyo itam-nilipta, numi tok uyo bagamin o age-nilip ipmi kuguup tambal tambal uyo imi tiin diim uyo kanumin ba kale, utama-bom-nilipta o ageta kale, ibo kanuman-temip uyo, ipmi Aalap abiil tigiin kayaak iyo tebe ipmi tok uyo baga-bom-nalata, mufekmufek tambal uyo maak ibo kobelan-temaala ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Kale minte umi bogosu uyo ki, ibo, tinum iyo mufekmufek iibanip kalaa age-nilip dong dogobelum o age-nilip ipmi mufekmufek uyo kulu-nilip kupka-eman-temip uyo, ibo, kanu-bulupta, kek kek ita numi tok uyo bagamin o agan-nuubip ilitap uyo kemin ba ko. Kale kuguup alop waafulin bilip iyo, kek kek ita itamin o agan-bom-nilipta, tinum iyo daalip isiik no-nala fongket ko age bigul uyo bo-balata, alugum unang tinum imi tiin diim kugol mufekmufek duumatanbip iyo mufekmufek uyo kupka-em-nuubip kale, ulotu am aa-e min abiip mat kugol kanum-nuubip kale, dam bogobelan-temi kale, unang tinum tebe imi tok bagan-nuubip boyo bilip imi tisol uyo kulbu kale, bota kup kulan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Kale ipmi tinum mufekmufek iibanip imi kupka-eman-temip uyo, ibo kek kek imi tiin uyo kubabe-nilip mufekmufek uyo bantap misiim kupka-eman-temip bota, ipmi Aalap God iyo utam-nalata, yagal mufekmufek tambal uyo ibo kobelan-tema o,” age Yesus iyo ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Kale Yesus iyo asok bogopma, “Ipmi God imi aman duga-eman-temip uyo, ibo, kanu-bulupta, kek kek ita numi tok uyo bagamin o agan-nuubip ulutap uyo kemin ba ko. Kale weng alop bagamin tinum bilip iyo, kanu-bulupta, unang tinum iyo itamipta o age-nilipta, suun kup ulotu am aa-e min, abiip mat kugol mo-nilipta, God imi aman duga-emin kup ke-bomip kale, dam bogobelan-temi kale, unang tinum tebe imi tok bagan-nuubip boyo imi tisol uyo kulbu kale, bota kup kulan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kale minte ipmi, God imi aman duga-emum o agon-temip uyo, tam ilipmi am kutam iinom faal uyo ilo-nilipta, ipmi Aalap God abiil tigiin alba iyo bantap aman duga-emin o ageta kale, ipmi Aalap iyo ipmi bantap aman duga-e-bilip boyo utam-nalata, mufekmufek sang dagagan-bilip boyo kobelan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Kale ipmi God imi aman duga-eman-temip uyo, ibo God imi ilak dolin binim bilip imi amon amon ke-bom weng yamyam bagan-nuubip ulutap uyo ke-bom aman duga-emin ba ko. Bilip imi aget fugunin uyo, weng yamyam uyo baga-bulupta, usong iyo numi weng uyo tinangkulan-tema ko age-nilipta, kanum-nuubip ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kale ipmi Aalap God iyo ipmi mufekmufek iibanip umi olabelin-tem uyo utamsa kale, God imi ilak dolin binim bilip imi kuguup kanum-nuubip ulutap uyo kanumin ba ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kale ibo, God imi aman duga-emum o agelan-temip uyo, kanu-bom-nilipta, bogobe-nilip e, ‘Numi Aatum abiil tigiin kayaak kabaa. Kapmi win boyo afaligen kale, alugum unang tinum nuyo dong daga-e-balapta, “Beyo tambal kup tebesa o,” kagan-bom-nulupta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kabo alugum nuyo imdep tam kapmi daam tem daa tiin molapta, bom-nulupta o ageta ko. Kabo dong daga-e-balapta, alugum nuyo abiil tigiin kasel imi kapmi aget fugun-balap uta kup telelam-nuubip ulutap ke-bom-nulupta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kamano kota numi kamano komi iman unan-kalin boyo kopmap unan-bulup o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kabo numi fengmin boyo kupkabe numi nugumal imi tebe numi fenge-bilip kup-kaga-ebup ulutap kebelal o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mufekmufek mafak tal numi diim abe im-kugulan o agan-bo uyo, kabo fomtuup dong daga-e-balapta, nuyo fengmin ba ko. Saatan iyo nuyo ifak daalan o agelan-tema uyo, dong dogobelapta, imkalak o,’ age-nilipta, ibo God iyo aman duga-e-bilipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kale kanube ibo unang tinum imi fenge-bilip uyo, kup-kaga-emip umdii, ipmi Aalap abiil tigiin kayaak yagal mungkup ipmi fengmin uyo kupkabelan-tema kuta, ");
INSERT INTO tlf_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","fen ibo bilip imi fenge-bilip uyo kup-kaga-emin-tem kemip umdii, ipmi Aalap God yagal mungkup ipmi fengmin uyo kupkabelan-temaala o,” age Yesus iyo ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Kale Yesus iyo weng maak bogobe-nala e, “Ibo, God imi beten kemum o age-nilip iman uyo falamip umdii, ibo, bisop bagamin tinum imi aget fugunin, nuyo unang tinum imi bisop baga-e-bom tinum imi aget iluum ku-nala iluuk fenba ulutap kelupta, kek kek ita itam-nilipta, numi beten kemin umi tok uyo baga-emin o age-nilip iluuk fen-nuubip ulutap uyo kemin ba ko. Bilip imi aget fugunin uyo, kek kek iyo nuyo itamipta e, beten ke-bom iman uyo fala-nilipta, iluuk fenbip kalaa agelin o age-nilipta, ok uyo kulu imi tibit kun diim uyo diing dagamin binim ke-bom-nilipta, iman uyo falam-nuubip kale, niyo dam bogobelan-temi kale, kek kek iyo tebe unang tinum iman fala-bom iluuk fenbip imi tok baga-em-nuubip boyo bilip imi tisol uyo kulbu kale, bota kup kulan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Kale minte ipkil iman uyo falamip umdii, ipmi iman falaman-temip boyo unang tinum igi ba kale minte, numi Aalap God tiinkan beta kup numi iman fala-bulup boyo utamak o age-nilipta, inal tiin uyo fenamin ba kale, ipmi tibit kun uyo diing daga-bom ipmi dubom kon uyo denga-bom no ke-bom-nilipta o ageta kale, ipmi Aalap God isiik ipmi bantap iman fala-bilip boyo utam-nalata, mufekmufek tambal uyo kobelan-tema o,” age Yesus iyo ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Kale Yesus iyo asok bogobe-nala e, “Kafin diim komi mufekmufek kulep tal am ku tolan-temip uyo, tinom so inalol so uyo tebe kufak daalan-temu e minte, yuguut unin tinum iyo tebe tal fakan ke tam dugulan-temip no kale, ibo kafin diim komi mufekmufek tambal tambal uyo kulep tal kwego kwego kemin ba kale, ");
INSERT INTO tlf_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ibo God imi kuguup tambal tambal uta kup ninal daa waafulip umdii, God yagal tebe ipmi mufekmufek tambal uyo abiil tigiin kal afeta kobelata, bom-buluta, no tamipta, kobelan-tema kale, abiil tigiin umi mufekmufek uyo tinom so inalol so uyo tebe kufak daalan-temaalu e minte, yuguut unin tinum iyo tebe tal fakan ke tam dugulan-temaalip no kale, ");
INSERT INTO tlf_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ipmi mufekmufek uyo kafin diim kagal albu umdii, ibo kafin diim umi aget kup fugunan-temip kale minte, ipmi mufekmufek uyo abiil tigiin kugol albu umdii, ibo mungkup abiil tigiin umi aget kup fugunan-temip o,” age Yesus iyo ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Kale Yesus iyo do weng maak bogobe-nala e, “Ipmi tiin boyo dam umi yogon ulutap kale, kanube ipmi tiin uyo tambaliim albu umdii, bota ibo mufekmufek mafak uyo kupkek kupkek ke-bom-nilipta, mufekmufek uyo tambal telelam tiineman-temip kale minte, ");
INSERT INTO tlf_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","kanube ipmi tiin uyo atin mafaganebelu umdii, ibo mufekmufek uyo utamta, tambal kalaa, mafak kalaa agan-bomta tambaliim telelam tiineman-temaalip kale, mungkup God ilami aget fugunin tambal uyo ipmi kobelan-tema uyo, boyo tebe yogon ulutap ke kafale-buluta, utamipta e, kanube tiinemup boyo tambaliim tiinemup kalaa agan-kalon-temip kale, kanube mufekmufek tebe kanupmin yogon boyo tenolu umdii, ipmi aget fugunin sino tiinemin tonamin so uyo mafaganepman-temu o,” agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Kota Yesus iyo weng kem maak bogobe-nala e, “Tinum maagup iyo bagang-kale-nalata, kamok alop imi ogok uyo ke-eman-temaala kale, kanube tinum beyo kanuma umdii, beyo maak iyo atafinono umik ugobe-nalata, maak imi aget uta kobelan-tema aa-e min, maak imi ilak uta tele do-nalata, maak ita duban baan kebe no kelan-tema min ko. Kale mungkup ibo bagang-kale God imi aget so mani kwaamin umi aget so uyo alop kano imi aget uyo ugel kalalan-temaalip o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Kale Yesus iyo asok weng kem uyo bogobe-nala e, “Weng maak uyo bogobelan o ageta kale tinangku-silipta. Ibo bagang-kale God imi aget so mani kwaamin umi aget so uyo alop kano imi aget uyo ugel kalalan-temaalup kalaa age-nilipta, ipmi kaa tibip umi aget afek uyo fugun-bom bogo-nilip, ‘Iman so ok so bo dok ku-tele maak tuluta, unan tubup o?’ agan-bom-nilip aget yamyam taga-bom-nilip e minte, ilipmi kaal umi aget uyo fugun-bom-nilip, ‘Ilim boyo dok ku-tele maak tuluta, migilan-temup o?’ agan-bom-nilip aget yamyam taga-bom no kemin ba ko. God ita mufekmufek afaligen ko age ipmi mam so dam so uyo kobelata, koyo albip kale, mungkup, mufekmufek katip ko age unan-kalin so ilim migimin so ugol mungkup fen God iyo tebe kobelan-tema no kale, bomi aget uyo yamyam tagamin ba ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ibo uun imi isal ku-tele tiinan-nuubip bilip iyo itamin. Bilip iyo iman ilang digin-kalin binim. Iman wemin binim. Iman afeta-bii kulep no am tomin binim. Kuta ipmi Aalap abiil tigiin kayaak yagal tebe iman uyo kuga-e-balata, unan-nuubip ko. Kuta God imi aget aa bubul aa kwiin kiim uyo unang tinum ipmi kobe-nalata, uun ita imdep te magaang tem daa-nalata minte, ipta iman uyo kupka-e-balata, iman uyo tii unan-nuubip kuba. ");
INSERT INTO tlf_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ibo aget yamyam taga-bom ilipmi kaal ilak dugamin bota tebe dong dogobeluta, ibo tii ipmi nin uyo kayop aa-e min, atol aa uyo maak so tifilip top so keluta, kafin diim kagal bii, ilugolan-temip aga? Umbae. God iyo bogo-nala, ‘Kota kaanin o,’ agon-tema kota, kaanan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Kale ibo, intaben o age-nilipta, ilim umi aget uta yamyam tagan-bilip a? Ibo tiginal umi ilala boyo utamin. Boyo tinum nulutap keluta, ulumi ilim uyo telela-bom biginamin binim kale, boyo bisop iip kugol tebe-bom-nuluta, umi ket tambal boyo abum-nuubu ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Sugayok tinum win tibin Solomon bemi bii-se uyo, beyo mufekmufek soyaap kale, ilim tambal tambal uta kup tii-bii-se kuta, imi ilim sagaal tulum telele-bilip tii-bii-se bomi dong uyo kubaganuta, ilala ket umi dong tambal uta uta kesu ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kale ilala boyo tiginal kal bomu kale, bomi ket tambal uyo abu siit ilugo datanu e, tinum tebe baam uyo kwek tililip ilala kuso ken tebe-bom no kem-nuubu kuta, ilala boyo God yagal tebe telela ko tiin mo-balata, tambaliim ket uyo abum-nuubu ko. Kale ninggil ibo aget alop uyo taga-bomta, ‘God beyo nuyo ilim kaal uyo kobelan-tema bele ki, kobelan-temaala o?’ agan-nuubip kale, ibo tele utamin. God imi tiin diim uyo ibo ilala ket uyo kubaganu ipta ipta kesip kale, mungkup ulutap God yagal tebe ibo tele tiin molan-tema kuba. ");
INSERT INTO tlf_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kanuman-tema kale, ibo aget yamyam uyo taga-bom-nilip, ‘Iman aa-e min, ok aa-e min, ilim min uyo dok ku-tele tuluta, un-bom-nulup e minte, migi-bom no keman-temup o? agan-kalin ba ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","God imi ilak dolin binim bilip iyo alugum mufekmufek kanupmin boyo fen-bom-nilipta, kwan-nuubip kale, ipmi Aalap abiil tigiin kayaak iyo ipso iso itamata e, bilip iyo alugum mufekmufek boyo dilin-bilip kalaa agan-boma ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kuta mufekmufek miton ipmi dilinan-temip uyo kulbu kale, ibo, God imi daam tem iinom ilami aligaap ke-nulupta, ilami tol kuguup uta kup waafulum o age dilin-bom-nilipta, God imi aget uta ugel kalalin o ageta kale, ibo kanumip bole, God yagal dong daga-e-bom-nala e minte, ipmi mufekmufek dilin-bilip migik ko age iman min ilim uyo kuga-e-bom no keman-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ulutap kale, kanube kamano koyo ibo amsap umi mufekmufek bong fagamin umi aget uyo aget maak maak ke-bom fugunin ba kale, kupkaa siinta, bomi aget uyo fugun-bilipta o ageta kale, kamano komi mufekmufek bong fagamin mitam tulu bomi aget uyo kaa fugun-bilip kale, tii bota kup o,” age Yesus iyo weng kem boyo ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Kale Yesus iyo asok bogo-nala e, “Kabo, God imi abiin uyo ku-nilita, imi ogok ke-be boyo nisiik kuta ogok keman o agan-kalin ba ko. Kabo kapkumal iyo imkege-bom bogobe-nalap, ‘Ibo kuguup mafak ke-bilip o,’ agan-kalin ba kale, kupkalap umdii, God yagal kamkege-bom bogopke-nala, ‘Kabo kuguup mafak ke-balap o,’ agon-temaala ko. ");
INSERT INTO tlf_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Minte kabo kapkumal iyo imkegemap umdii, mungkup God yagal tebe kanube kamkegelan-tema e minte, kapmi kapkumal iyo dogonupmin kuguup kafale-bomap umdii, God yagal kanupmin kuguup boyo mungkup kabo kafalep-kaman-tema kale, kapkumal iyo weng mafak uyo kupka-emin ba ko. ");
INSERT INTO tlf_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kapmi kapkumal imi kuguup mafak kangkang iyo ifip olol te tiin tem iina ilatap kale minte, kapmi kuguup mafak kwiin kiim kanu-balap bota minte at daang tiin ulaa kupkelu ulutap kuta, kapmi kapkum iyo bogobe-nalap e, ‘Tiin ifip olol o,’ agan-nuubap kale minte, aget fuguno-nalap e, ‘At daang tiin ulaa kupnelu boyo kuun kale, binimanepnelan-temu o,’ agan-nuubap ko. Kale kabo kapmi kapkumal imi kuguup mafak kangkang boyo utamsap kuta, kalapmi kuguup mafak kwiin kiim kanum-nuubap uyo kabo utamsaalap aga? ");
INSERT INTO tlf_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Intaben o age-nalapta, kapkum iyo bogobe-nalap e, ‘Nugum kabaa. Niyo dong dogopke-nili tiin ifip olol beyo dupkan kep-kaman o,’ agan-balap a? Umbae. At daang tebe kapmi tiin uyo ulaa kupkelu tiin tugul ke-salap bole, dogobe-nalapta, dong dogobelan-temap a? ");
INSERT INTO tlf_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kale kabo kuguup mafak kwiin kiim boyo kem-nuubap kale, kapmi kanupmin weng boyo bisop bagan-balap kale, kabo kapkum iyo dong dogopman-temaalap ko. Kale kamaki uyo kapmi aget uyo fupkela ko-nalap boyo fengmin kalaa age bo kupkaa mitam bagang-kale-nalapta, kalapmi duup iyo dong daga-eman-temap ko. ");
INSERT INTO tlf_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Kale kota weng migik maak bogopkelan o ageta ko. Kabo unang tinum dok ita, God imi weng boyo tinangkulaalup o agan-bilip umdii, kabo bilip iyo God imi weng uyo maak sino kupka-emin ba ko. Kale kabo utamal. Man iyo maak tebe kayaam umaak sal faga-ema umdii, kayaam beyo fupkela tebe man beyo angkolan-tema ko. Kale ulutap kale, tinum dok ita God imi weng uyo unang tinum daal tebebebu iyo kupka-emin kup kema umdii, bilip iyo bubul atul tebepmu e, tebe dufak daalan-temip kale, aa mungkup ulutap kale, kanube kabo kayuum ket uyo kwaalap daak kafin diim abelu uyo, kong tebe tal yaan biil tifin kelu kupkalan-temip kale, ulutap mungkup unang tinum dok ita, God imi weng uyo tinangkulaalup o agan-bilip bilip iyo suun kup kupka-eman-temap uyo, bilip iyo tebe God imi win uyo kufak daabelan-temip o,” age Yesus iyo ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Aa tam Yesus iyo weng migik maak bogo-nala e, “Kabo dogonupmin mufekmufek umaak duumatanap umdii, suun kup God iyo dagaga-balapta, kopkelan-tema kale mungkup, mufekmufek umaak utaman o age-nalap fenap uyo, God ita dong dogopkelata, utaman-temap, aa mungkup kabo tinum imi no ipkum imi am faal suun kup dok dok ke-bala ipkum imi tebe am faal bita-e-ba ulutap ke suun kup God iyo dagagamin kup keman-temap uyo, God yagal tebe kabo dong dogopkelan-tema kale, suun kup God iyo dagagamin kup ke-balapta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kale tinum dok ita mufekmufek sang umaak God imi dagala umdii, God iyo suun kup yan kebe yakyak keman-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Aalabal ibaa. Kanube kapmi man iyo maak daga-nala, ‘Iman bo kopnelap unelan o,’ agela uyo, kupkaa tuum uta kopman-temap aga? Umbae. Iman uta kopman-temap ko. ");
INSERT INTO tlf_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ulutap kale, mungkup daga-nala, ‘Aniing bo kopnelap unelan o,’ agela uyo, kupkaa inap mafak uta kopman-temap aga? Umbae. Aniing uta kopman-temap ko. ");
INSERT INTO tlf_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kale kabo utamal. Kabo fengmin tinum kuta, kapmi man iyo mufekmufek tambal uyo kupka-e-bomap kale minte, Kaalap abiil tigiin kayaak God iyo fen tambaliim kup tebesa kale, ilami man ibo tebe dagalip uyo, beyo mufekmufek mafak umaak ibo kobelan-temaala kale, fen ki beyo mufekmufek tambal uta kup kupka-e-boma ko. ");
INSERT INTO tlf_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Kale aa mungkup kapmi aget fugunin uyo, ‘Nimi nugumal ita kuguup tambal kupkane-bilipta, tambaliim nan o,’ agan-balap umdii, kamaki uyo kapsiik kanupmin kuguup tambal uyo kupka-e-balapta o ageta kale, weng boyo sugayok Moses so weng kem baga-emsip tinum so imi weng God imi suuk kon tem umi dola kupkamsip umi magam uyo kulbu kale, bota kanu-balapta o,” age Yesus iyo ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Tam Yesus iyo weng maak bogobe-nala e, “At suun kenamin abiip umi ilep mituum tem uyo afaligen e minte, ilep unsu uyo bong fagamin binim no kalaa age-nilipta, unang tinum kwiin tagang iyo, ‘Boyo ilep tambal ko,’ age-nilipta, dagaa kulep ku-tele unan-nuubip kuta, bilip iyo God iyo dupkaa no simanim unom-nilip e, maagalo kelan-temip ko. Kale minte God imi abiip ilep mituum tem uta katipnok e minte, ilep unsu uyo bong fagamin no kalaa age-nilipta, unang tinum kwiin tagang iyo, ‘Ilep boyo bong fagamin o,’ age-nilipta, kup-kagan-nuubip kale, unang tinum iip maak maak ita kup ku-tele unan-nuubip kale, God imi suun nin abiip uyo bilip ita kup nan-temip kale, kanupmin abiip ilep bota kup uneman-temip boyo tambaliim o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yesus iyo weng maak bogo-nala e, “Tinum iip maak maak iyo tal baga-bom-nilip, ‘Nuyo God imi profet ko age weng kem baga-emin tinum o,’ agan-nuubip kuta minte, bilip iyo atin fen bisop bagan-nuubip ko. Kuta minte kanube sep kayaam dungkiil iyo tebe kong sipsip imi kaal uyo ku kwaak kalila umdii, kabo beyo sipsip atul binim ita ko agelan-temap kuta, fen ki sep kayaam atul tebesa ita kale, beyo tebe kangkolan-tema kale, bisop bagamin tinum kulip iyo kulitap kale, tebe kafak daalan-temip kale, utama-bom-nalapta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kale nuyo yangta, tiyuup umi diim uyo yet dum abubu kalaa age dagaa kulan-temup a? Yangta, misiil sok umi diim uyo kugalap uyo abubu kalaa ageta dagaa kulan-temup a? Umbae. Nuyo at umaak tebelu utamamup te tam dum uyo abuluta, utamupta, boyo te tam dum tambal abulu kalaa dum mafak abula kalaa angbup ulutap kale, bisop bagamin tinum kulip imi kuguup uyo tele utamaman-temap uyo, ilimi kuguup mafak bota tebe kafalepke-nuluta, bilip imi aget fugunin boyo mafak o kageluta, utaman-temap ko. ");
INSERT INTO tlf_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Agesu kale di, kabo at dum abumin umi kuguup uyo utamal. At dum tambal abumin uyo ulumi dum tambal uta kup abulan-temu e minte, at dum mafak abumin umdii, ugol mungkup ulumi dum mafak uta kup abulan-temu no ko. ");
INSERT INTO tlf_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kale minte at dum tambal abumin uyo aaltam kota asok at dum mafak uyo abulan-temaalu e minte, at dum mafak abumin uyo aaltam kota asok at dum tambal uyo abulan-temaalu no kale, ");
INSERT INTO tlf_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","at umaak dum tambal abulin binim kelan-temu uyo, at kayaak beyo tebe at boyo ungkwaa fegela kwegala ken tebe binimanan-temu ulutap kale, son-temu uyo, bisop weng bagamin tinum bilip iyo God yagal tebe imdala abiip mafak unon-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kale kabo weng kem bagamin tinum iyo ilimi kuguup mafak uta utam-nalapta, bilip iyo bisop weng bagamin tinum umdii kulbip kalaa agelan-temap o,” age Yesus iyo ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Kota Yesus iyo titil weng maak bogobela ko. “Unang tinum kwiin tagang iyo bogopne-nilip, ‘Kabo numi Kamogim kale, kapmi ogok waafupkelan-temup o,’ agan-nuubip kuta, bisop ilimi weng baga-bom-nilip e minte, nimi Aatum abiil tigiin kayaak imi weng uyo tinangkamin binim kem-nuubip kale, bilip iyo imdep tam God ilami abiip uyo daalan-temaala binim kale, tinum dogap ita God imi weng uyo waafusip umdii, bilip ita kup imdep tam God ilami abiip uyo daalan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kale am afungen umi mitam daanu unang tinum itama-bom afetaman-temi uyo, unang tinum kwiin tagang iyo tal nimi tiin diim kal bogopne-nilip e, ‘Kamogim kabaa. Nuyo kapmi win tolop diim God imi weng uyo kupka-emsup kuba. Kapmi win tolop diim sinik mafak iyo fot tebelup une-bilip e minte, kuguup migik migik uyo kafale-bom no kemsup kuba. Kale mungkup kapkal utamsap kale, nuyo kapmi unang tinum kuba,’ agan-kalon-temip kuta, ");
INSERT INTO tlf_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","niyo bogobe-nili e, ‘Ibo God imi weng uyo waafu-nimip binim kuguup mafak uta waafusip kale, ibo nimi unang tinum ba e minte, ibo niyo itamsaali no kale, nimkaa daaginin o,’ agelan-temi o,” age Yesus iyo ilami okumop man imi bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yesus iyo asok do weng maak bogobe-nala e, “Tinum dok ita nimi weng kaa bagan-bii koyo tinangka-bom-nala e minte, nimi kuguup tambal uyo waafuu no kela umdii, beyo kanupmin weng kaa bogobelan-temi komi kuguup waafulin tinum ilatap iyo kulba ko. Kale am tambal dinan-kalin tinum maak beyo no am kun uyo ugan-bii kulep tal to kupka-nala e, kafin uyo faga-bala unanbu daak kafin tem iinu kupka-nala e, am kun uyo kulula unanbu daak unu kupkaa am uyo de kola ulimal te am iinom sina-bilip e, ");
INSERT INTO tlf_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","kota wep sino atii sino ke-buluta, ok fagan mitop abuta, am uyo dalata kwep unon agin kuta, am uyo tambaliim kup de-se kale, fomtuup kafin uyo waafuu mosu ko. ");
INSERT INTO tlf_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ale minte tinum dok ita nimi weng kaa bagan-bii koyo tolong uta kup duga-bom-nala e, nimi kuguup tambal uyo waafunamin binim kema umdii, kanupmin weng kaa bogobelan-temi komi kuguup waafulin tinum ilatap iyo kulba ko. Daal tibin tinum maak beyo kaang age am tambal dinan-kalin binim kale, am kun uyo kafin fogo-nalata ba kale, bisop kulep daak ku to de kolata, ");
INSERT INTO tlf_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","kota wep sino atii sino ke-buluta, ok fagan mitop abuta, am uyo balaa kwaalu yang kafin diim abelu e, ok tebe balata kulep daage un-suu o,” age Yesus iyo do weng boyo bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kale kota Yesus imi weng uyo baga-e-bii alugum binimanu kupkala e, kota unang tinum kwiin tagang weng tinangkan-bilip iyo tiin tam iinu aget fugun-bom ");
INSERT INTO tlf_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ipkumal iyo bogobina tala ke-bom-nilip e, bogolip ko. “Bemi weng kafalemin kuguup uyo atin fen ugulumi migik kale, God imi aget fugunin uta dagaa ku uta-bom-nalata, nuyo fomtuup kafale-be kuta minte, numi ulo utamsip tinum kalip ita kanube nuyo fomtuup kafalebe-nimip binim o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Kale kota Yesus iyo amdu tigiin uyo kupkaa malaak abe abe-balata, tam unang tinum kwiin tagang iyo yak Yesus imi daang begebelip maagup unip ko. ");
INSERT INTO tlf_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tam tinum kaal mafak kesa maak ipkumal tebe fot tebelip yang sep kugol nuuba iyo Yesus imi finang tal-nala e, kamok king imi weng umka-emin umi kuguup uta ku-nala e, tal katuun duung fegela daak ton-nala e, bogola ko. “Kamogim kabaa. Kabo tii kale, dong dogopnelan o agelap umdii, nimi kaal mafak koyo telela kopne-namap o,” agela e bole, ");
INSERT INTO tlf_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesus imi sagaal uyo kwep yak tinum bemi kaal diim uyo daa bogobe-nala e, “Aa. Niyo dong dogopkelan o ageta kale, kaa telela kamoli tambalanap o,” agela e, kota tinum bemi kaal mafak uyo maak fagaa binimanepmu tinum kasagim kela e, ");
INSERT INTO tlf_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","kota Yesus iyo bogobe-nala e, “Kabo koyo no tinum imi diim uyo ki nimi kanupkeli bomi sang uyo baga-emin ba kale, kupkaa unap ki no pris ko age tinum amem imi diim kal kapmi kaal uyo kafalebelapta, utam-nalata, bogopke, ‘Aafen boyo binimanepkelu o,’ agelata bole, kabo Moses imi sugayok weng kwep daasa uta ku waafu-nalapta, mufekmufek maak God iyo kobe-nalap, ‘Suguul o,’ agelapta, unang tinum iyo katamipta e, aafen ko tambalanap kalaa age-nilipta, asok kamdep meng daalin o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kale bole Yesus iyo no abiip Kapeneam kutam iinata, Rom kasel imi waasi dinan-kalin tinum imi kamok kugol nin iyo atam-nalata, bogobe-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Nugum kabaa. Niyo dong dogopne a. Nimi ogok kemin tinum iyo magal fagaa kubelu yaan kuso niil mo-nalata, kaal fuyap kup utam-nalata, am abiin kal alba o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","bole tam Yesus isiik bogobe-nala e, “Niyo kapsino no-nilita, telela dolan-temi o,” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","waasi dinan-kalin tinum imi kamok iyo bogobe-nala e, “Umbae. Niyo fengmin tinum kale, kamogim kabo kamtamo no nimi am uyo unon-temaali kale, nagal nalami dubom imi weng tinangkamin tinum e minte, niyo waasi dinan-kalin tinum ilimi kup wan handret (100) imi kamok tiin molin no kale, niyo tinum maak bogobe-nili, ‘Unaal o,’ agelan-temi uyo, unon-tema e minte, tinum maak bogobe-nili, ‘Talaal o,’ agelan-temi uyo, tolon-tema e minte, nalami ogok kemin tinum iyo bogobe-nili, ‘Kanupmin ogok bota kemal o,’ agelan-temi uyo, ogok boyo keman-tema no kale ulutap, kabo titil so kale, weng uta kup bogolapta, nimi ogok kemin tinum yang nimi am alba beyo tambalanak o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kale Yesus iyo weng boyo tinangku-nala e, kumang mo fupkela katop fen unang tinum ilami miit tem albip iyo bogobe-nala e, “Niyo weng uyo dam bogobelan-temi kale, tinangku-silipta. Israel kasel ko age Juda kasel imi aget fugun-bom-nilip, ‘Nuyo God imi man iyo kalbup o,’ agan-nuubip kuta, niyo iyo maak atamita, beyo nitamata, Yesus iyo tii alugum kuguup uyo kanubelan-tema kalaa agan-be kalaa age atamsaali kale minte, Rom kayaak keta atin ki nitamata, Yesus beyo tii weng uta kup bogolata, nimi ogok kemin tinum mafak bom yang am alba beyo tambalanan-tema kalaa age-nalata, tal bogopnela kale, bemi nimi ilak dugamin uyo kwiin kiim keluta minte, alugum Juda kasel imi nimi ilak dugamin uyo kubaganu ko. ");
INSERT INTO tlf_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Niyo weng maak bogobelan-temi kale, tinangku-silipta. Alugum kafin kaa kutufosu komi unang tinum kaal kaal kwiin tagang iyo tala tala ke-nilipta, (Juda kasel iip maak maak kup sino kwego dego ke-nilipta,) no God imi abiip kugol God ilami man aligaap ke-nilipta, yang numi afaligal Abraham sino imi man Aisak sino imi man ilop Jekop sino ton-nilipta, iman unan-bom deng tebeman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kale minte Juda kasel kwiin tagang, ‘Nuyo God imi man iyo kalbup o,’ agan-nuubip bilip iyo no God imi abiip unon agin kuta, iyo no God imi abiip uyo unon-temaalip kale, uk kugan ko-nilipta, utamipta e, God iyo tebe nuyo umik ugobe-nala e, imdala mitam sep katam kal albup kalaa age-nilipta, ‘Kwiin bo so kubo,’ agon-temip kale, bilip iyo kaal fuyap uyo utam ilimi kaal kalan uyo ameman-temip o,” age-nala e minte, ");
INSERT INTO tlf_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","fupkela waasi dinan-kalin tinum imi kamok imi bogobe-nala e, “Kabo utamapta e, aafen beyo telela dolan-tema kalaa nagebap kalaa age-nilita, telela doli kale, no-nalapta, am kal atamal o,” agela ko. Kamaa weng uta baga-em-sala e, kota waasi dinan-kalin tinum imi kamok imi ogok kemin tinum iyo tambalana ko. ");
INSERT INTO tlf_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kale bole Yesus iyo daage no Fita imi am no abomu, Fita imi alol uyo kaal mimin tebebelu mafak umo-bom bet diim kal albu kalaa age-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","imi sagaal uyo kwep yak bomi sagaal diim melebelata, umi kaal mimin uyo binimanepmu e, fen mitam Yesus ninggil imi iman uyo telela kobelu ko. ");
INSERT INTO tlf_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kale ataan uyo, tem iinon o agan-sulu e, (God imi ifin am uyo binimanu kalaa age-nilipta,) abiip kasel iyo unang tinum kwiin tagang sinik mafak tebe ifak daasu iyo kulep Yesus imi finang tal tamip e, Yesus iyo tebe sinik mafak iyo weng kobe fot tebela yak iine-bilip e minte, unang tinum mafak ilin iyo alugum telela imola bam daga-bom no kema ko. ");
INSERT INTO tlf_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Siin sugayok uyo Yesus iyo tilin-tem bom-balata, profet Aisaya iyo Yesus imi sang uyo God imi suuk kon tem uyo dola ko bogo-nala e, “Nuyo mafak umo betanupta, ita tebe-nalata, telela imola o,” age dola ko-se kale, Yesus iyo boyo kanubelata, tam Aisaya imi weng boyo tol mitam ti-suu ko. ");
INSERT INTO tlf_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kale Yesus iyo itamata e, unang tinum kwiin tagang iyo falala namolip kalaa age imi okumop man iyo bogobe-nala e, “Unip ninggil nuyo tam bot tem ton-nulupta, daage yak ok muk umi milii kutam iinum o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","unum o agan-silipta, tam ulo utamsa tinum maak iyo tal Yesus imi bogobe-nala e, “God imi weng kafalemin kabaa. Kabo dogap dogap tiinemap uyo, niyo kapsino tiineman-temi o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesus iyo imi weng uyo yan kebe-nala e, bogola, “Sep kayaam ko age dungkiil iyo dungfil tem kal sina-bala e minte, uun yagal ilami um tem kal sina-bala no kem-nuubip kale minte, Mo Tibil imi Man nita fen nalami am sinamin am binim kale, kapkal aget uyo tele fugunolal a. Kabo niso kanube tiineman o agan-balap bele ki?” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kale tam tinum maak Yesus imi umik tem talan-be iyo bogobela, “Kamogim kabaa. Kamaki uyo nimkalap no-nilita, nimi aatum iyo tiin mo-sili kaana kalaa age-nilita bole, dep no duba-nilita, kota talta kapso tiinemum o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesus iyo imi weng uyo yan kebe-nala e, “Waago. Kabo unemin ba kale, kupkaa meng nimi okumop man ke-nalapta o ageta ko. Tinum dok ita, nimi daang begepnelaalup o agan-bilip bilip ita felepmuta, ipkumal kaanip iyo kulep no kubamin (kale minte, kapta no unang tinum iyo God imi weng uyo baga-e-balapta, iyo God imi ilak do-nilipta, mitam God imi man keta suun nin unang tinum kelin) o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kale Yesus so ilami okumop man so ninggil iyo tam bot tem ton-nilip e, daaginip ko. ");
INSERT INTO tlf_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kale ninggil iyo abe-bom-nilip e, ok muk afaligen kale, unanbu yak ok mat iip kuunip e, dulul kiim maak tebe maak fagaa mitam abuta, ok uyo fogo kulalu, te tam bot tem uyo dongenan o agan-bo kuta, Yesus iyo amin bom-balata, ");
INSERT INTO tlf_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","imi okumop man iyo no dufo-nilip e, bogobe-nilip e, “Kamogim kabaa. Nuyo mep so anolu kaanum o angbup kale, fen dong dogobelapta, waalanum o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesus isiik tebe bogobe-nala e, “Ibo utamipta e, kamogim beyo nusino alba koyo, nuyo abiin tambal tonbup kalaa age-nimip ba kale minte, ibo, intaben o age-nilipta, ok umi atul uyo finan-bilip o?” age-nala e, kota fen-nala e, dulul sino ok sino uyo bogobe-nala e, “Dulul sino ok sino kubo sining agelal o,” agela e, kota dulul sino ok sino uyo sining age binimanu ko. ");
INSERT INTO tlf_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ninggil alugum iyo utamipta e, dulul sino ok sino uyo imi weng uta kup tolong do sining agelu kalaa age-nilip e, kota kumang mo bogobina tala ke-bom-nilip e, tam bogolip, “Keyo dogonupmin tinum ita tebe-nalata, weng uta kup bagam-salata, dulul sino ok sino uyo imi weng uta kup tolong do binimanu o?” agelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kale Yesus sino e minte ilami okumop man sino iyo bot tem ilep unanbu yak ok muk umi milii Gadara kasel imi anang kutam iinip ko. Kale ninggil iyo yak tamip e, tam tinum alop maak begel ilet tem ko age tuum tem kal nuubip kale, tal Yesus imi diim abu molip ko. Kale siin kota sinik mafak tebe tinum alop bilip iyo ifak daasip kale, alop bilip iyo atul kup taban-bilipta, unang tinum iyo imi atul uyo finan-bom-nilipta, begel ilet tem bomi mep sino ilep uyo unan-nuubaalip ko. ");
INSERT INTO tlf_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Kale tinum alop bilip iyo Yesus iyo atam-nilip e, fomtuup atul faga-bom bogobe-nilip e, “God imi Man kabaa. Kabo, nuyo intaben nubelan o age-nalapta, talap a? God imi yegemin am uyo daan mitam tilin-tem bom-bulu talap koyo, nuyo kaal fuyap afek kobelan o ageta talap aga? Boyo kanu-emin ba o,” agelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kale minte ninggil ilimi mobip umi keng ilo boyo kong kwiin tagang maak buk fagan-bom albip kale, ");
INSERT INTO tlf_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","kota tam sinik mafak tinum alop bilip imi iibak tem albip iyo Yesus imi fomtuup daga-nilip e, “Nuyo fot tebelan o agelap umdii, fot tebelapta, tinum kalip iyo imka-nulupta, yak kong bilip imi tilin tem iinum o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesus iyo bogobela, “Kalo. Imkaa unin o,” agela e, kota sinik mafak iyo tinum alop iyo imka-nilip e, yak kong imi tilin tem unip e, kota kong iyo alugum ilum ilum ke-nilip e, yuut ilok dup-kalaak mo unanbu daak Galili kumun tem kulaak iinom-nilip e, ok tebe mimilepmu kaanip ko. ");
INSERT INTO tlf_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kale tam kong tiin molin tinum igil utamipta e, kong iyo kanube kaanip kalaa age-nilip e, yuut bilii no abiip miton no-nilip e, alugum unang tinum iyo kong sang uyo bogobe-nilip e minte, tinum alop siin sinik mafak tebe ifak daasip imi sang uyo bogobe no kelip e, ");
INSERT INTO tlf_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","kota unang tinum iyo weng uyo tinangku-nilip e, alugum iyo abiip uyo kupkaa daage Yesus imi finang no atamum o age no atam-nilip e, weng uyo fomtuup kobe-nilip e, “Gadara kasel numi anang koyo kupka-nalap daaginaal o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesus ninggil iyo asok te tam bot tem ton-nilip e, mek ok muk umi milii kugol albip uyo kupkaa asok yak milii abe ilimi abiip unip ko. ");
INSERT INTO tlf_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kale mek tamip e, tinum ninggil maak ipkum magal fagaa kubesu iyo daalip ilet tem iina duptamo Yesus imi finang tal tamip e, Yesus iyo itamata e, tinum ninggil iyo utamipta e, Yesus iyo tii nugum keyo telela dolan-tema kalaa nage-nilipta, dep tilip kalaa age-nala e, tinum magal fagaa kubesu beyo bogobe-nala e, “Nugum kabaa. Niyo kapmi fengmin uyo alugum kupkan kepkeli binimanu kale, deng tebemal o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kale kota ulo utamsip tinum iip maak maak iyo tinangku-nilip e, ipkumal iyo bogobina tala kemip ko. “Tam kafin diim tinum keyo bisop bogo, ‘God imi ogok kemi o,’ agan-bom-nalata, God imi win uyo kufak daga-e-be o,” agelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesus iyo bilip imi kanupmin aget fugun-bilip uyo utamebe-nala e, bogobela ko. “Intaben o ageta ibo kanupmin aget mafak boyo fugun-bilip a? ");
INSERT INTO tlf_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Niyo intaben mufekmufek uta maak kanubelita, ibo yuut nitamipta, beyo dam bagan-be kalaa nagelan-temip a? Niyo tinum kemi bogobe-nili, ‘Kapmi fengmin uyo kupkan kepkeli o,’ agon-temi uyo, ibo bogopne-nilip, ‘Nuyo boyo nulumi tiin fala utamin-tem kelup kale, kabo bisop bagan-balap o,’ agelan-temip kale minte, niyo tinum kemi bogobe-nili, ‘Fen mo unaal o,’ ageli fenan-tema uta, ibo utamipta, boyo dam bagan-be kale, beyo tii fengmin uyo kupkan kepmoma kalaa nagon-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kale ipkil utamin. Niyo Mo Tibil imi Man kale, nimi titil kiim uyo kafalebelita, ibo utamipta e, beyo bisop baganbaala kale, kafin diim alba koyo, beyo tii unang tinum imi fengmin uyo kupkan kepman-tema kalaa nagelan-temip o,” agan tolom-nala e minte, tinum magal fagaa kubesu bemi bogobe-nala e, “Kabaa. Fen-nalap kapmi kamtamo tilip umi ilet uyo kuptamo-nalap kalapmi am iinaal o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","kota tinum iyo fen-nala e, tambe ilami am iina ko. ");
INSERT INTO tlf_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kale kanubela boyo unang tinum iyo utam-nilip e, atin kumang mo finano God imi tok uyo bogobina tala ke-bom-nilip e, “God yagal tebe-nalata, tinum beyo titil kobelata, tebe-nalata, kanupmin kuguup migik boyo kanubela o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kale Yesus iyo am uyo kupkaa daage tam tam no takis mani kwaamin am ko age ofis uyo no abomu, takis mani kwaamin tinum Matyu niyo tonbi kalaa age mitam bogopne-nala e, “Nugum kabaa. Kapmi ogok ke-balap boyo kupkaa talapta, nisino ninggil abe-bomta nimi ogok usiik maak kopkelita, ogok kemal o,” agela e, niyo fen-nili e, Yesus imi daang begebe uni ko. ");
INSERT INTO tlf_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kale Yesus ninggil isino niso ninggil nuyo ofis uyo kupkaa no nimi am kal iman unan-bulup e, tam takis mani kwaamin tinum kwiin tagang sino minte kuguup mafak waafulin unang tinum migik sino iyo tala tala ke-nilip e, tam Yesus sino imi okumop man sino tonip iman unan-kulup ko. ");
INSERT INTO tlf_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kale Falosi milii iyo utamipta e, Yesus iyo tam kanupmin tinum isino iman unan-bilip kalaa age-nilip e, Yesus imi okumop man imi daga-nilip e, “Ipmi kafalemin tinum beyo, intaben o ageta tal tamata, takis mani kwaamin tinum sino kuguup mafak waafulin tinum migik sino ninggil ton-bomta iman uyo dagaap unan-bilip a? Bemi ko kanu-be boyo mafak o,” agan-kalip e, ");
INSERT INTO tlf_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesus iyo tinangku-nala e, bilip imi weng boyo yan kebe do weng maak bogobe-nala e, “Tam tinum tambal albip iyo dokta imi finang uyo unon-temaalip kale minte, fen tinum mafak albip ita kup dokta imi finang uyo unon-temip kale, ");
INSERT INTO tlf_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ulutap mungkup, niyo tal unang tinum bogo-nilip, ‘Nuyo fengmin binim kale, tol kup unang tinum o,’ agan-bilip bilip ita dong daga-e-bilita, imi aget uyo fupkela ko God imi ilak uyo dolin o ageta tisaali kale, niyo tal unang tinum bogo-nilip, ‘Nuyo fengmin unang tinum o,’ agan-bilip bilip ita dong daga-e-bilita, imi aget uyo fupkela ko God imi ilak uyo dolin o age-nilita, ti-sii ko. Kale weng ko baga-e-bii boyo ipkil God imi suuk kon tem weng uyo fen-bom tiki-bom-nilipta, weng bomi magam uyo tele utamin o ageta ko. Weng atuk uyo bogo-nala e, ‘God niyo fomtuup bogo-nili, “Ibo ulo uyo tinangku dimduum uyo ano fuu kupkanemin o,” aganbaali kale, niyo bogo-nili, “Ibo unang tinum imi i-filin-bom kuguup tambal kupka-emin o,” agan-bii o,’ agesa o,” age Yesus iyo bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kale tam ok sam uga-emin tinum Jon Baptis imi okumop man iyo tal Yesus atam-nilip e, dagalip ko. “Nusino Falosi sino numi kuguup uyo, iip maak maak umi beten kemum o agelan-temup uyo, nuyo unan-kalin uyo fala-bom-nulupta, beten kem-nuubup kuta minte, kapmi okumop man bilip ita unan-kalin uyo falamin binim, beten uyo kem-nuubip bota, intaben o age-nilipta, bilip iyo unan-kalin uyo falam-nuubaalip o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesus iyo bilip imi weng uyo yan kebe-nala e, ilami kaanan-tema umi sang uyo felep yak tinum unang kulan-tema imi diim to bogobe-nala e, “Tam tinum iyo unang kulan-tema uyo, tinum ilo iyo tebe iman fuu-bom unan-bom deng tebeman-temip ko. Kanuman-temip kota, tinum migik iyo felepmuta, bogobe-nala e, ‘Ibo deng tebe-bom unan-kalin ba kale, aget iluum uyo tebe-bom unan-kalin uyo falamin o,’ agelan-tema bele ki? Umbae. Tinum ilo iyo utamipta, nugum iyo nuso alba kalaa age deng tebe-bom-nilipta, iman uyo unan-kalon-temip ko. Kuta biilan-temu kutop uyo, waasi iyo tebe tal-nilip e, bilip imi ipkum iyo aafuu dep unip kalaa age-nilipta, ipkumal iyo aget iluum tebebeluta, unan-kalin uyo falalan-temip o,” age Yesus iyo do weng uyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kale Yesus iyo (Juda kasel iyo itamata e, ilimi siin kuguup uta fomtuup waafusipta, nimi kamaa kuguup uyo waafulaalup o agan-bilip kalaa age-nalata,) asok do weng alop maak bogobe-nala e, “Unang uyo felepmuta, kamaa ilim fangaa kwep tal diing daa kolin-tem albu uyo maak ugaa ku kwep yak siin ilim fengela tebebu umi diim daa bigilan-temu a? Umbae. Kanupman-temu bole, diing daa kolan-temu uyo, kamaa ilim uta alula kolan-temu kale, ilim kup-diilu fonganu asok migilan-temu uyo, nagat moluta, siin ilim uta yuut balata tebe bigi koluta, tem kiim kelan-temu ko. ");
INSERT INTO tlf_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Aa mungkup ulutap kale, tinum iyo meme kaal siin dalaa kwep daala fonganbu umi tem ku-tele kamaa umi wain ok ko age sok dum ok uyo ilu kola dongenu kalaa age-nala e, sok ku tem uyo de ko-nala e, kwep tal am daala umdii, siit-nuluta, ok uyo fitin unom-nuluta, meme kaal totanin boyo yuut nagat mo bigin-nuluta, ok uyo singkam daa daaginon-temu e minte, kaal uyo mafagan-nuluta, fengela tebelan-temu no kale, tinum iyo kamaa umi wain ok uyo ilu kolan o agela umdii, meme kaal uyo kamaa dalaa kwep daala totanin binim albu uta kup ku-nalata, wain ok uyo ilu kwep tal daalan-tema bota meme kaal so wain ok so alop kano tambaliim nan-temu o,” age Yesus iyo do weng alop boyo baga-ema ko. (Kale do weng alop boyo bogo-nulu, “Niyo, kamaa kuguup kwep tal ipmi siin kuguup uyo anung tifipman o ageta tisaali kale, niyo kamaa kuguup uyo kwep tilita, uta tele waafulin o ageta kwep ti-sii o,” age-suu ko.) ");
INSERT INTO tlf_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Kale Yesus iyo kanube baga-em-sala e, tam Juda kasel imi kamok maak Yesus imi finang tal katuun duung fegela daak ton-nala e, bogobela, “Nimi man unang uyo kamano kota kaanuta, kupkaa tili kale, talapta, alop no-nulup kapmi sagaal uyo togobelapta, fenuk o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesus sino imi okumop man sino iyo fen mitam abe-nilip e, kamok isino unip ko. ");
INSERT INTO tlf_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Minte tam unang maak albu boyo suun kup ulumi am tem unemin kup nuubuta, atol tuluun kal kelu kale, boyo tal Yesus imi umik tem kugol talan-bom-nulu e, aget fugunolu ko. “Niyo yak Yesus imi umik tem ilim kaal bota kup maagalo yak waafulita, telela namola tambalanan o,” age aget fuguno-nulu e, umi sagaal uyo maagalo kwep yak Yesus imi ilim mibiyaang uta kup melebelu e, ");
INSERT INTO tlf_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesus yagal utamata e, maak melepnela kalaa age-nala e, fupkela katop fen utam-nala e, bogobela, “Nugum kubaa. Niyo utamita, kubo, beyo fen telela namolan-tema kalaa nagan-balap kalaa age-nilita, telela kamoli tambalanap kale, deng tebemal o,” agan-sala e, maak fagaa tambalanu ko. ");
INSERT INTO tlf_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kale tam Yesus iyo daage tal kamok imi am tal abomu, tinum kubamin umi fongket bomin tinum iyo bom fongket uyo bo-bilip e minte, unang tinum kwiin tagang iyo alugum atul faga-bom fomtuup ame-bilip no ke-bilip kalaa age-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","bogobe-nala e, “Ibaa. Tam man unang boyo amiit kaanbaalu kale, boyo aminbu ulutap kebu kale, ibo amemin ba kale, kupkaa tam iinin o,” agela e, unang tinum iyo, beyo bisop bagan-be ko age-nilip e, aban dii-emip ko. ");
INSERT INTO tlf_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kale kota Yesus iyo unang tinum iyo fot tebela tam iinip e, Yesus iyo tam man unang ulumi sinamin abiin tam-nala e, umi sagaal uyo waafubela e, kota man unang uyo fenu ko. ");
INSERT INTO tlf_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kale unang tinum iyo no abiip maak maak unom-nilip e, Yesus imi kanubeba umi sang uyo baga-bilip e, senganu ko. ");
INSERT INTO tlf_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kale kota Yesus iyo am bo kupka-nala e, abe-balata, tam tinum tiin tugul alop maak Yesus imi finang umik tem tal ola-nilip e, “Kamogim kabaa. Kabo kalapmi afalik King Devit ilatap kale, nuyo i-filin daa kapmi titil uyo ku-nalap dong dogobelal o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kale Yesus iyo tam am iina e, tinum tiin tugul alop iyo Yesus umik tem tam am tamip e, Yesus iyo daga-nala e, “Ibo utamipta e, iyo titil uyo tii numi tiin uyo telela dong dogobelan-tema kalaa nagan-bilip aga o?” agela e, Yesus imi weng uyo yan kebe-nilip e, “Aa. Kabo titil sino kale, tii dong dogobelan-temap kalaa agan-bulup kuba,” agelipta, ");
INSERT INTO tlf_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yesus iyo imi sagaal uyo kwep yak tinum alop imi tiin uyo melebe-nala e, bogobela ko. “Ibo utamipta e, iyo tii titil uyo ku dong dogopman-tema kalaa nagebip kale, kota dong dogobeli o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","tinum alop imi tiin uyo tambalanepmu e, kota mufekmufek uyo utamamip ko. Kale Yesus iyo fomtuup bogobe-nala e, “Telela imoli komi sang uyo tinum kek kek iyo baga-emin ba o,” agela kuta, ");
INSERT INTO tlf_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","tinum alop bilip iyo Yesus imi weng boyo tinangku-nimip binim kupkaa no abe abiip maak maak uyo tiine-bom-nilip e, imi tiin telelebeba bomi sang uyo bagan tiine-bilip senganu ko. ");
INSERT INTO tlf_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kale tinum alop iyo Yesus iyo dupkaa unip e minte, asok tinum maak Yesus imi finang dep tilip ko. Kale tinum beyo siin kota sinik mafak tebe dufak daalata, weng kabam kesa ko. ");
INSERT INTO tlf_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kale tam Yesus iyo tebe sinik mafak iyo fot tebela daaginata, tinum iyo kota weng bagama ko. Kale unang tinum iyo tolong do-nilip e, kumang mo una tala ke-bom bogo-nilip e, “Kanupmin kuguup boyo ugulumi migik kale, Israel kasel nuyo kanupmin kuguup boyo siin uyo maak utaman-nuubaalup o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kuta minte Falosi ita bogo-nilip e, “Umbae. Sinik mafak imi kamok Saatan ita titil uyo kopmata, beyo sinik mafak mafak iyo fot tebela yak iinan-bilip o,” agelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Kale Yesus iyo abiip maak maak umi yakyak kem tiinan-nuuba uyo, no abe tam ulotu am uyo tam unang tinum iyo kafale-bom-nala e minte, God imi weng tambal uyo bogobe-nala e, “Ibo aget fupkela ko fengmin uyo kupkalan-temip uyo, God iyo ipmi fengmin uyo kupkabe-nalata, imdep tam ilami daam tem daa-nalata, tiin molan-tema o,” agan-bom-nala e minte, unang tinum mafak ilin migik migik kwan unsip iyo telela imka-bom no kem tiinan-nuuba ko. ");
INSERT INTO tlf_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kale Yesus iyo itamata e, unang tinum kwiin tagang kalip iyo sipsip imi tiin molin tinum iyo imkala ilisinon bom-nilip ilep uyo kupkaa ilum ilum kem tiinebip ilitap ke-bom God imi tol ilep uyo utamin-tem ke-nilipta, waanta tebe nuyo dong dogobelan-tema o age aget yamyam tagan-nuubip kalaa age-nala e, fomtuup i-filin-bom-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ilami okumop man iyo do weng maak bogobe-nala e, “Unang tinum kwiin tagang iyo, God imi weng tinangkamum o agan-bilip kale, bilip iyo rais ko age wiit damanu ulutap kuta, tinum wiit dagamin tinum iyo iip maak maak ita kup kale, (wiit dagamin tinum bilip iyo tinum tebe God imi weng kwep no unang tinum imi kupka-emin ita kale,) ");
INSERT INTO tlf_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ibo God imi beten ke-e-bilipta, yagal ogok kemin tinum kwiin tagang ulu-nalata, imdala tal ipmi diim abelipta, ipsino maagup no unang tinum iyo God imi weng uyo baga-emin o,” age do weng boyo bogola ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesus iyo ilami okumop man tuluun kal iyo olapma tilip e, ilami titil uyo kobe bogobe-nala e, “Ibo nimi win tolop diim uta sinik mafak uyo fot tebe-bom-nilip e minte, alugum unang tinum mafak ilin migik migik kugan unsip iyo telela imka-bom no kem tiine-bilipta o,” age-nala e, bogopma ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kale ilami kalaan tinum tuluun kal ulusa imi win uyo kulbu kale, tam maak iyo Saimon so ilami niing Andru so kale, Yesus iyo Saimon imi bogobe-nala e, “Kapmi win migik uyo Fita o,” agela ko. Minte maak iyo Sebedi imi man Jems so ilami niing Jon so alop igil, ");
INSERT INTO tlf_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip yagal, Batolomyu yagal, Tomas yagal, minte Matyu nagal no kale, niyo takis mani kwaamin tinum (kale, suuk kon koyo dola-bii) ko. Minte Alfius man asegim Jems yagal, Tadius yagal, ");
INSERT INTO tlf_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Rom kasel itafinonin tinum Saimon yagal, minte Yesus imi dupkem daalan-tema tinum Keriot kayaak Judas yagal no bilip ita kup ulula ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Yesus iyo, nalami okumop man kulip iyo imdali no nimi ogok uta kenem unin o age-nalata, weng kem uyo kobe-nala e, “Israel kasel bilip iyo God imi kuguup uyo kupka-nilipta, bilip iyo sipsip ilum ilum ke-bom maagalo kesip ilitap kale, ibo no abe Samaria kasel imi abiip uyo yakyak kemin ba e minte, tinum migik imi abiip uyo yakyak kemin ba no kale, ibo no Israel kasel imi abiip uta kup tiine-bom-bilipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kale ibo no abiip kasel imi diim unon-temip uyo, bogobe-nilip e, ‘God imi unang tinum imdep tam ilami daam tem daagamin uyo tal mep tulu o,’ age-nilip e minte, ");
INSERT INTO tlf_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","mafak ilin umosip iyo telela imka-bom-nilip e minte, kaanip iyo asok ifolip fena-bilip e minte, kaal mafak kesip iyo telela imka-bom-nilip e minte, sinik mafak iyo fot tebelip unang tinum iyo imkaa yak iine-bilip no kemin o ageta kale, siin uyo God iyo ibo misiim telela imola mitam imi ilak uyo dobip kale, ipkil mungkup ipkumal iyo misiim telela imka-bilipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Kale mani maak abu kulep unemin ba e minte, ");
INSERT INTO tlf_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","iman men min, ilim alop min, yaan ilom min, kafung uyo kulep tiinemin ba kale, mufekmufek dulep unon-temip uyo, ilipmi ilim migibip beta kup kanube tiinemin ko. Ibo kuguup tambal uta kup waafuu unang tinum iyo kupka-e-bom dong daga-eman-temip uyo, igil mungkup kuguup tambal uyo ibo kupka-eman-temip kale, ibo mufekmufek uyo maak duumatanan-temaalip binim ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ibo no abe abiip maak unon-temip uyo, ibo fen-bomta tinum iyo maak atamipta, beyo bogobe-nala, ‘Suguul ke tilip o,’ agela kalaa agelip umdii, bemi am kal isino bom-nilipta, unang tinum iyo dong daga-em-siit-nilip e, abiip boyo kupkaa aa kanumin kup yakyak kem tiineman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Kale ibo no am iinip uyo, ibo kutam albip bilip iyo weng umobe-nilip e, ‘Nugumal tambaliim kup albip aga o?’ age bogobelin o ageta kale, ");
INSERT INTO tlf_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","unang tinum bilip iyo bogobe-nilip, ‘Suguul ke tilip o,’ age imtamo tam ilimi am daalip umdii, son-temu nala ibo, imkaa unum o agon-temip uyo, bogobe-nilip e, ‘Bisel yagal ibo alugum tiin molata, tambaliim bom-bilipta o,’ age-nilipta, imkaa unon-temip kale minte, ‘Suguul ke tilip o,’ age imtamo tam ilimi am daalin-tem kelip uyo, ibo weng uyo tambal kup umobe unemin ba kale, imkaa unemin ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Minte am kutam albip min, abiip kasel min iyo imdep tam daa tiin mo-bom ipmi weng uyo tinangka-bom kemin binim kemip uyo, ibo asok yang abiip mat kal mo-nilip e, Juda kasel nulumi kuguup uta ku-nilipta, ifip te yak ipmi yaan diim tububu boyo tolo kululip yak abiip kasel imi ilo unuta bole, abiip unang tinum iyo utamipta e, son-temu uyo, bilip iyo maak so tal nuyo dong dogobelan-temaalip kalaa agelipta, imkaa unemin o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nimi weng kaa bogopman-temi koyo tele tinangku-silipta. Sugayok uyo abiip Sodom kasel so abiip Gomora kasel so iyo kuguup mafak uta kem-kalipta, God iyo tebe ifak daalata, kaansip ko. Kale am afungen tem mitam tolon-temu uyo, God yagal unang tinum iyo yege-bom, Sodom kasel so Gomora kasel so iyo kaal fuyap uyo kupka-eman-tema kuta, kamano koyo God imi weng uyo kem diim albu kale, ibo no abiip kutam iinon-temip kutam iyo dogap ita God imi weng uyo kwaasulemip umdii, God imi tebe bilip imi kaal fuyap kupka-eman-tema uta uta ke-nuluta, Sodom kasel so Gomora kasel so nimi weng tambal tolong dolin-tem ke-bii-silip imi kaal fuyap kupka-eman-tema uyo kubaganu kupkabelan-temu o,” age Yesus iyo weng kem uyo ilami kalaan tinum imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Kale Yesus iyo kuguup mafak tal ilami okumop man imi diim abelan-temu umi sang uyo bogobe-nala e, “Ibo nimi weng koyo tinangku-silipta. Ipmi imdali no abiip maak maak kem unon-temip uyo, kayaam mafak ko age dungkiil tebe sipsip ifak dagam-nuubip ulutap ke abiip tinum tebe ibo ifak dagaman-temip kuta, ibo sipsip ilitap dukmen-bomta o ageta ko. Inap imi ilep tiinemin uyo, aget fuguno-nilip e, tinum tebe itam ano-nimip o age-nilipta, agol kup telen tiinan-nuubip ulutap kale, ibo ipmi tiinemip tonamip uyo, aget tambal uta kup fugun-bom kuguup tambal kup waafu-bom-nilipta o ageta kale, ibo dinan-kalin ba kale, unang tinum iyo kuguup tambal tambal uta kup kupka-e-bom uun abim sining age tonabip ilitap ke bilili age-bom no ke-bom-nilipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ibo nimi ogok waafuu kwep tabon-temip uyo, bomi kalan uta nimi waasi iyo tebe ibo yaafuu de imtamo Juda kasel imi kamogimal anggebip imi diim daalipta, iyo tebe im-kugu-bom yege-bilip e minte, ibo ulotu am unon-temip uyo, waasi iyo tebe saal daga-bom no keman-temip kale, utama-bom-nilipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Minte ibo nimi ogok waafulan-temip bomi kalan uta nimi waasi iyo tebe ibo imtamo no Rom kasel imi kamogimal imi diim daalip e, ita im-kugu-bom yegeman-temip uyo, kota ibo utamipta e, God imi weng umi ilep uyo kulbu kalaa age-nilipta, ibo Juda kasel imi kamogimal so asit kek kek imi kamogimal so imi diim kal nimi sang umdii baga-eman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kale bilip iyo tebe ibo imtamo no kamogimal imi tibit diim daalan-temip uyo, ibo aget yamyam uyo fugun-bom, ‘Kwiin. Kota weng kwep mek numi tem tilibelan-temip bota, intaben o agelan-temup a? Dogonupmin weng uta kuta yan kepman-temup a?’ agan-kalin ba kale, bilili age bom-bilipta, kota God yagal weng tambal bagamin uyo kafalepmata, bagaman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ibo ilipmi aget fugunin uta weng uyo ku baga-eman-temaalip kale, ilipmi Aalap God imi Sinik ipsino suun nan-tema yagal ilami weng uta kafalebelata, baga-eman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Tinum iyo nitafinon-bom-nilip e, ilimi nagalal nimi ilak dolin iyo imkem daa imdalip yak kamogimal imi sagaal diim abelip ita tebe inolip kaana-bilip aalabal igil tebe man iyo imdalip yak waasi imi sagaal diim abelip inolip kaana-bilip e minte, man iyo ilimi amalabal imi waasi kebe-nilip e, imdalip yak kamogimal imi sagaal diim abelip e, inolip kaana-bom no keman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kale alugum God imi ilak dolin binim tinum iyo nitafinon-nuubip kale minte, bilip iyo tebe nimi ilak duga-bom ogok kemin tinum ipkil mungkup olsak kupka-e-bom itafinonan-temip kuta, nimi ilak dolin unang tinum iyo dogap ita kaal fuyap uyo utama-bom-nilip yang iinemin binim, suun kup nimi ilak uyo duga-bilip bii, kaana umdii, bilip iyo God yagal tebe duptamo tam ilami abiip daalata, suun kup nan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ibo no abiip maak kugol bomta utamipta, yan-togon-bom ifak daga-bom kemip kalaa agelip umdii, ibo abiip boyo kupka-nilip e, yuut no abiip maak unemin ko. Niyo tuluun weng bogopman-temi kale, tinangku-silipta. Ibo Israel umi abiip afalik afalik uyo nimi weng uyo kuptamo baga-em tiine-bilip binimanin-tem bom-suluta, Mo Tibil imi Man niyo no o-nilita, asok tolon-temi ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Skul man ita ita ke-nala ilami tiksa ko age kafalemin tinum iyo dupdaak tamalan-temaala e minte, mungkup ogok kemin tinum iyo tebe-nalata, ilami kamok iyo dupkan ke iit iinon-temaala no kale, ");
INSERT INTO tlf_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","kanube skul man iyo yagal te tam ilami kafalemin tinum ilatap kela boyo tambaliim e minte, kanube ogok kemin tinum iyo yagal te tam ilami kamok ilatap kela boyo tambaliim no ko. Kale waasi bilip iyo bisop bogopne-nilip e, ‘Beyo sinik mafak imi kamogim Belsebul ko age Saatan ita o,’ nagebip kale, mungkup ulutap bilip iyo tebe nimi okumop man ipkil bisop baga-e-bom-nilip e minte, ipmi win uyo kufak daga-e-bom no keman-temip o,” age Yesus iyo ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yesus iyo asok bogobe-nala e, “Agelu kale, ibo unang tinum nimi ilak dolin binim bilip imi atul uyo finanin ba ko. Kale kamano koyo ibo nimi kuguup tambal uyo kanu-bom-nilip e minte, nimi weng tambal uyo baga-e-bom no ke-bilip kuta, nimi ilak dolin binim bilip iyo utamipta e, boyo kuguup tambal e minte, weng tambal no kalaa age utamanbaalip binim kale minte, son-temu kota, unang tinum kwiin tagang iyo utamipta, boyo kuguup tambal kalaa age som, weng tambal kalaa age no ke tele utaman-temip kale, ibo finan-bom nimi ogok uyo kup-kagamin ba kale, umi diim kal feba-bomta tebe-bilipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kamano nimi kamaa weng ko baga-e-bii koyo, ipta kup tinangku kwaak abu-bilip kuta, son-temu uyo, ibo tam abe-nilipta, weng koyo kuptamo no abiip maak maak uyo fomtuup baga-em tiine-bilipta, alugum tinangkamin o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Tinum iip maak maak iyo bogobe-nilip e, ‘Ibo Yesus imi weng boyo baga-em top iip kwegal dugang age kupkalin-tem kelip umdii, inolan-temup o,’ agelan-temip kuta, iyo tebe ipmi dam uta kup ungkwalip kaanan-temu kuta minte, ipmi suun nin sinik uyo ungkwalip kaan maagalo kelan-temaalu binim ko. Kale bilip imi atul uyo finanin ba kale, God maagup imi atul uta kup finanin kuba. Beta kup titil so kale, tii ipmi dam uyo ungkwabela kaanu ipmi sinik uyo ungkwaa kwaapma at suun kenamin abiip unomu kale, God maagup imi atul uta kup finanin ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kale uun kangkang bilip iyo win binim kale, tinum iyo mani ken tibin beta duta uun kangkang alop iyo molan-temip kuta, uun katipnok maagup bemi dumen malaak kafin diim abon-tema uyo, God iyo ataman-tema kale, God iyo, ‘Daak abelan-temaalap o,’ agela umdii, uun katipnok beyo malaak abon-temaala ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ulutap kale, God beyo ipmi aget uyo suun kup fugun-boma kale, beyo alugum ipmi dubom kon uyo tikilata e, intap kal kalaa age utam som, minte alugum mufekmufek mek ipmi diim aban-nuubu uyo utam no kesa kale, ibo tambaliim tiin mo-bom dong daga-em-nuuba ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kale God bemi tiin diim uyo uun kangkang iyo kubaganipta, tinum ipta ipta ke-silip kale, God iyo ipmi aget uyo fugun-bom-nala e, tambaliim kup tiin mo no ke-boma kale, ibo kafin diim tinum bilip imi tebe, ibo anolum o agan-bilip imi atul uyo finanin ba o,” age baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yesus iyo ilami okumop man imi bogobe-nala e, “Ibaa. Dogap kapta no unang tinum imi tiin diim uyo bogo-nalap, ‘Niyo Yesus imi okumop man o,’ agelap umdii, God imi yege-bom kaal fuyap kupka-eman-tema umi am daanan-temu kota, nagal mungkup nimi Aatum abiil tigiin kayaak imi tiin diim uyo bogo-nili e, ‘Beyo nimi okumop man o,’ kage no kelan-temi ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kale minte aa mungkup dogap kapta bogo-nalap, ‘Niyo Yesus imi okumop man ba o,’ agelap umdii, nagal mungkup nimi Aatum abiil tigiin kayaak imi tiin diim uyo bogo-nili e, ‘Beyo nimi okumop man ba o,’ kage kapmi win uyo kubapke no kelan-temi o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Asok Yesus iyo bogobe-nala e, “Ipmi aget fugun-bilip uyo, niyo talta unang tinum imi weng kupka-e-bilita, mitam aget maagup kelin o ageta ti-se o, agan-bilip a? Umbae. Niyo talta, unang tinum iyo ilo kolan o ageta ti-sii kuba. Nimi weng uyo sagam daang tebe mufekmufek bigi kolu milii alop kemin ulutap kale, unang tinum iyo nimi weng tolong dolan-temip uyo, iip maak maak ita tolong duga-bala e minte, iip maak maak ita tolong dugamin binim ke-bom umik uga-e-bala no keman-temip kale, bigi ko miit alop ke-nilipta, waasi kebina tala keman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kale nimi weng kafale-bii bomi kalan uta man tinum iyo mitam aalabal iyo waasi ke-e-bilip man unang igil mitam ogenal iyo waasi ke-e-bilip e minte, miin kalelal igil mungkup mitam imegal iyo waasi ke-e-bilip no keman-temip kale, ");
INSERT INTO tlf_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","bomi iibak tem uyo ki, tinum imi waasi iyo kaal kaal igi ba kale, fen ilami duup-afin ita mitam waasi ke-eman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Tinum iyo dogap ita ilami aalap so ogen so imi aget kup ugel kala-nala nimi aget uyo katip kopnela umdii, beyo fen bagang-kale te tam nimi okumop man iyo ke-nama binim e minte, aa mungkup tinum iyo dogap ita ilami man tinum min, man unang min imi aget kup ugel kala-nala nimi aget uyo katip kopnela umdii, beyo fen bagang-kale te tam nimi okumop man iyo ke no kelan-temaala ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Aa minte, dogap kapta, nimi tinum kelan o agelap kuta, nimi kaal fuyap at diim kal kulan-temi ulutap ke, ‘Ku-nimi bole, ku-nimi o,’ agelin-tem ke-bom-nalap e minte, nimi daang begepne nimi bogopke-nili, ‘Bota kanumal o,’ agan-bii uyo waafulin-tem ke-bom no kemap umdii, kabo dogobeta nimi tinum kelan-temaalap binim ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kabo kalapmi kaal ilak kup duga-bom kalapmi aget fugunin uta kup kanum tiineman o agan-kala umdii, kabo nisino suun kup nan-temaalap binim kale, kabo maagalo kelan-temap kale minte, kapmi aget fugun-bom kanu-balap uyo kupkaa meng, ‘Kanu-bili waasi iyo tebe nangkolum o age-nimip bole, nangko-nimip o,’ age-nalap meng nimi ilak kup duga-bom nimi kuguup uta fomtuup waafuu kwep tabap umdii, kabo suun kup nan-temap o,” age Yesus iyo ilami okumop man iyo bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Asok Yesus iyo ilami okumop man bilip imi bogobe-nala e, “Tinum dok ita nimi okumop man kabo no tamap, ‘Suguul ke talap o,’ age-nala kapmi weng uyo tinangkama umdii, beyo nimi weng tinangkamin tinum iyo kulba e minte, tinum dok ita God nimdala ti-sii nimi weng uyo tinangkama umdii, beyo God imi weng tinangkamin tinum iyo kulba no ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tinum iyo dok ita utamata, kabo God imi weng kem baga-emin tinum kalaa age-nala, ‘Suguul ke talap o,’ age kapmi weng uyo tinangkama umdii, God iyo utamata e, tinum beta tebe dong dogopkela kalaa age-nalata, yagal tebe kapmi ogok kem-nuubap uyo yan kepke som, minte kapkum bemi dong dagake-be boyo mungkup yan kebe no kelan-tema ko. Ulutap kale, tinum iyo dok ita utamata, nugum beyo tol kup tinum kalaa age-nala, ‘Suguul ke talap o,’ age kuguup tambal kupka-ema umdii, God iyo atamata e, kuguup tambal kupka-ema kalaa age-nalata, yagal tol kup tinum iyo yan kebe som, minte ipkum bemi kuguup tambal kupka-e-be boyo mungkup yan kebe no kelan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nimi tuluun weng bogopman-temi koyo ibo tele tinangku-silipta. Tam tinum dogap ita tinum migik iyo maak atamata, win binim beyo Yesus imi okumop man kalaa age (bogo-nala e, ‘Yak tinum beyo win binim kale, niyo beyo dong dogopman-temaali binim o,’ agelan-temaala binim,) bogo-nala e, ‘Yak tinum beyo Yesus imi okumop man kale, niyo dong dogopman-temi o,’ age-nala diil ok uyo ilupma unela umdii, God yagal tinum bemi kuguup kanu-be boyo utam bogobe-nala e, ‘Kapkum diil ok ilubelap bomi kuguup boyo katip kuta, boyo tambaliim kanubelap kale, niyo deng taban-bii o,’ age-nala e, yagal kuguup tambal boyo yan kebelan-tema o,” age Yesus iyo weng kem boyo ilami okumop man imi baga-em siit binimanu kupka-nalata, imdala ilami ogok uyo ke-em unip ko. ");
INSERT INTO tlf_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesus iyo ilami okumop man tuluun kal iyo weng kem boyo baga-em siit-kala binimanu e, abiip boyo kupka-nala e, daage no abiip migik maak mep so albu kutam umi unang tinum iyo God imi weng uyo baga-e-bom kafalema ko. ");
INSERT INTO tlf_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ok sam uga-emin tinum Jon Baptis iyo kalabus am kal bom-bala e, ilami okumop man iyo no God imi ulaa dula kamok kesa tinum Krais iyo ata-bom-bilipta, kanumin kanumin ogok uyo ke-be kalaa age-nilipta, tal Jon iyo bogobelip e, Jon iyo aget alop fugun-bom-nala e, “Yesus beyo God imi ulaa dula kamok kesa tinum ita kulba bele o?” age-nala e, kota ilami okumop man iip maak maak iyo ulu kulula no Yesus iyo daga-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Kabaa. Siin uyo Jon iyo bogobe-nala e, ‘God iyo tinum maak ulaa du, “Beyo kamok o,” age daala tolon-tema o,’ age Jon iyo kam age-se kale, iyo kapta bele, minte nuyo fen-sulupta, tinum migik iyo maak tolon-tema a? Kapkal bogobelapta, utamum o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","5","Yesus isiik bogobe-nala e, “Niyo ogok ke-bilita, tiin bigibesu imi tiin uyo baabelu tiin daga-bala, ibiit iyo tambalan mo mo tiine-bala, kaal mafek kesip iyo asok tambalana-bala, tolong kom iyo tambalanepmu asok tolong duga-bala, tinum kaanip iyo asok fena-bala, minte tinum usap manal iyo God imi weng tambal uyo baga-e-bili tinangka-bala no kemip ibo utamip kale, ibo no-nilip Jon imi diim uyo ipmi kanupmin ko utamip so tolong dolip so bomi sang uyo bogobelipta, iyo tinangku bam daata, niyo waanta kalaa agelak o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kale tinum iyo dok ita nimi kanupmin kuguup kaa kanu-bii komi aget uyo fomtuup fugun-bom bogo-nala, ‘Yesus beta God iyo ulaa daala ti-se o,’ age-nala imi aget uyo alop tagamin binim kema umdii, beta tambaliim kup nan-tema ko. (Kale ibo no-nilip Jon iyo alugum bomi sang uyo bogobelipta, nimi deng uta kup tebe-bom bom-balata) o,” age Yesus iyo Jon imi okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kale Jon imi kalaan tinum iyo Yesus iyo dupkaa daage no Yesus imi weng bogopma unip uyo Jon iyo baga-emip ko. Kale daaginip e, Yesus iyo unang tinum kwiin tagang albip iyo Jon imi sang uyo bogobe-nala e, “Siin ipmi Jon imi finang iibaan un-silip uyo, intaben umaak utamum o ageta un-silip a? Ibo nota, dulul fuun-bom-nulu magal miit kwaalu yak o mek o ke-bo kale, utamum o ageta un-silip a? Umbae. ");
INSERT INTO tlf_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Aa minte ibo, intaben umaak utamum o ageta un-silip a? Ibo aget fugunota, tinum maak ilim tambal uta kup migiba kale, nota atamum o ageta un-silip a? Umbae. Jon iyo ilim tambal migimin tinum kulatap ba kuba. Tinum ilim tambal migimin ita kamok king imi am tambal tem kal bom-nilipta, tambal kup bomip kale minte, Jon beyo iibaan kugol suun kup boma kuba. ");
INSERT INTO tlf_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Aa minte ibo, intaben umaak utamum o ageta un-silip a? Ibo no, God imi profet ko age weng kem baga-emin tinum iyo maak atamum o ageta un-silip a? Aa. Jon beyo God imi profet kale, beyo alugum profet migik iyo kubaganipta, ita ita ke imkan kesa kuba. ");
INSERT INTO tlf_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kale boyo ki, God imi suuk kon tem weng uyo Jon imi sang uta sugayok uyo bogo-nulu e, ‘God iyo ilami Man imi bogobe-nala e, “Nagal kafin diim tinum beyo ulaa dulita, nimi kalaan tinum kelata, besiik daali no unang tinum iyo bogobe-nala, ‘Kamogim iyo tolon-tema kale, ibo ipmi aget tem uyo telelmipta o,’ agan abe-salata minte, kapta aaltam umik tem unon-temap o,” age God ilami Man imi bogobesa o,’ age God imi suuk kon tem weng uyo kam agesu ko. ");
INSERT INTO tlf_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kale weng kaa bogobelan-temi koyo tuluun weng kale, tinangku-silipta. (Siin uyo God imi profet bilip iyo God imi weng uyo kwep tal bogobela bogobela kem tebesip kuta,) alugum kafin diim tinum kaa mitam taban tebesip bilip imi tinum iyo maak tebe-nalata, Jon imi nimi sang kwep tal baga-em-nak-be kalutap umaak ke-bomta kwep tal baga-em tebesaala binim kuta, unang tinum mitam God imi daam tem tolon-temip bilip iyo ki, mafak man kan man kwiin tagang iyo mitam God imi mufekmufek so kuguup so uyo tele utam-nilipta, Jon imi tebe God imi kuguup utamsa uyo kupkan kebe-nilipta, ita ita kelan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Siin uyo Jon ita God imi weng uyo unang tinum iyo baga-emsa kale, kulota kwep tal kaa diipmu uyo, unang tinum kwiin tagang imi aget fugunin uyo ki, God imi daam tem boyo dital fagaa tam unum o age-nilipta, ilek ilek kem tebesip ko. ");
INSERT INTO tlf_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Sugayok uyo Moses isino God imi profet ko age weng kem baga-emin tinum migik isino iyo bogo-nilip e, ‘Am maak daanan-temu uyo, God yagal unang tinum iyo imdep meng ilami daam tem daa tiin molan-tema o,’ agan tam tam tebesipta, kale, kamano kogal mungkup Jon iyo uluta kam age-se kale, ");
INSERT INTO tlf_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","weng maak sugayok bogosip uyo, ‘Elaija iyo asok tolon-tema o,’ agesip kuta, Elaija imi sang bagamsip boyo felep yak Jon imi diim tota bagamsip kale, Jon iyo ko talata, imi weng uyo tol mitam ti-suu ko. ");
INSERT INTO tlf_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Alugum ibo tolong so kale, tii tolong do-nimip kale, ibo sining age tele tinangku-silipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Kale unang tinum kamano kaa albip ibo dogonupmin unang tinum albip a? Ibo tinum bisel ke fito-silip kuta, ibo man kangkang ilitap albip kuba. Man kangkang iyo abiip mat kal ton-bom-nilip e, milii bagaa kulu ipkumal iyo olabe-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nuyo atol dagamin tap kemum o ageta aseng kwaa-bom-nulup e minte, ot bo-bom no ke-bulup kuta, ipta nusino atol uyo dagamin binim ke-bilip ko. Minte nuyo tinum kaana dubamin ulutap kemum o ageta aman-bulup kuta, ipta nusino amemin binim ke-bilip ko. Dogonupmin umi kuguup migik migik kanumin uyo kup-kugulupta, ibo, “Kanumaalup o,” age kulaa yakyak ke-bilip o,’ agan-nuubip ko. ");
INSERT INTO tlf_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ulutap kale, (ibo man kangkang fagaang tibin ilitap uyo ke-bom-nilipta, Jon imi weng uyo, tinangkulaalup o agan-bom-nilip e minte, nimi weng uyo, tinangkulaalup o agan-bom no ke-bom-nilipta, ibo bisop umi kalan uta alop nuyo weng mafak uyo kupka-e-bom itafim-nuubip kale,) Jon imi aget fugunin uyo, God yagal bogopne-nala, ‘Kanupmin unan-kalin boyo kabo unan-kalin ba o,’ nage-se kalaa age-nala, fala-bilita, God iyo nimi deng uyo tebemak o age-nalata, unan-kalin maak maak so sok dum ok so uyo suun kup falamin kup kemsa kuta, tal kanu-balata, ibo atam-nilipta, bogo-nilip e, ‘Aa. Tinum beyo sinik mafak tebe dufak daalata, unan-kalin boyo suun kup falam-nuuba o,’ agan-nuubip ko. ");
INSERT INTO tlf_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Kale minte Mo Tibil imi Man niyo tal-nilita, iman so sok dum ok so umaak amem kalaa age-nilita, kupkasaali kale, alugum ipmi iman unan-nuubip boyo unan tebesi kuta, ibo bogo-nilip e, ‘Ibaa. Abuyap be tele atamin. (Juda kasel numi kuguup uyo unan-kalin uyo fala fala ke-bom God imi beten uta kup ke-emin kuta, Yesus beyo maak kanumin binim kale,) beyo takis mani kwaamin tinum so kuguup mafak waafulin tinum migik maak so imi duup o,’ agan-nuubip ko. Tinum dok ita God imi kuguup tambal uta kup kema umdii, bota tebe kafalebeluta, kek kek iyo atamipta e, beyo tebe God iyo tele atamsa atamta, nuyo felepmuta, te yak imi kuguup tambal uyo waafulan-temup kalaa agelan-temip o,” age Yesus iyo kam age baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesus iyo mirakel ko age kuguup ugulumi migik migik kwiin tagang uyo abiip iip maak maak iyo kafalema kuta, unang tinum kugol albip iyo imi aget fugunin uyo fupkela ko-nilipta, fengamin uyo kup-kagamin binim kale, Yesus iyo yege-bom bogobe-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Korasin kasel so Betsaida kasel so ibaa. Ibo usap manal kuba. Niyo mirakel ko age kuguup ugulumi migik migik uyo ipmi abiip alop kutam kal kanumsi kuta, ibo aget aa bubul aa umaak fupkela kota fengmin boyo kupkasaalip binim ko. Kale niyo no kanupmin kuguup ugulumi migik migik boyo God imi ilak dolin binim imi abiip Taya sino Saidon sino kutam kal kanumsi nimnam, abiip kasel bilip iyo utam-nilipta, ilimi fengmin umi aget uta iluum tebepmuta, ilimi aget iluum umi kuguup uta ku-nilipta, kutap uyo kulu ilimi kaal diim uyo tuko-nilip e minte, ilim mafak uyo migi no ke-nilipta, ton-bom ame-bom-nilipta, ilimi fengmin uyo kupka-silip kuta, niyo no kafalebelita, utamsaalip ko. ");
INSERT INTO tlf_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kale nimi weng bogobelan-temi koyo kwep aget tem daa fugun-bom-nilipta o ageta kale, afungen tem tolon-temu uyo, God iyo Taya kasel so Saidon kasel sino iyo yege-bom kaal fuyap uyo kupka-eman-tema kuta, ipmi fengmin uyo kupkalin-tem kelip kalaa age-nalata, God imi tebe ipmi kaal fuyap kupka-eman-tema uta kwiin kiim kupka-eman-tema kuba. ");
INSERT INTO tlf_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Minte Kapeneam kasel ibaa. Ibo bogo-nilip e, ‘Alugum nuyo no God imi abiip kal nan-temup o,’ agan-bilip kuta, umbae. Ibo nimi weng uyo tinangkamin binim kale, kululi daak abiip mafak unon-temip ko. Kale kanube niyo kanupmin kuguup ugulumi migik migik kanum tebesi boyo sugayok umi abiip mafak Sodom kutam ita kafalemsi nimnam, Sodom kasel God imi atamamin binim bilip iyo aget uyo fupkela ko fengmin uyo kupkalipta, God tebe imi fengmin uyo kupkabela abiip boyo tambaliim kup bom kwep tal kaa diibelu kuta, bilip imi aget uyo fupkela kolin-tem kalaa age-nalata, ifak daala binimansip ko. ");
INSERT INTO tlf_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nimi weng maak bogobelan-temi koyo kwep aget tem daa fugun-bom-nilipta o ageta kale, afungen tem tolon-temu uyo, God iyo Sodom kasel imi yege-bom kaal fuyap uyo kupka-eman-tema kuta, Kapeneam kasel ipmi fengmin uta kupkalin-tem kelip kalaa age-nalata, God imi tebe ipmi kaal fuyap kupka-eman-tema uta kwiin kiim kupka-eman-tema o,” age Yesus iyo abiip asuno kalip imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Yesus iyo abiip kasel iyo baga-em siit binimanu kupka-nala e, ilami Aalap God iyo bogobe-nala e, “Nimi Aatum kabaa. Kabo Kamok kale, kafin diim kasino abiil tigiin kusino uyo tiin mosap kale, (kapmi kuguup uyo tebe unang tinum imi kuguup uyo kubaganu kupkaa uta uta kesu kale, ‘Suguul o,’ agan-bii kale,) unang tinum iip maak maak iyo aget fuguno-nilip e, ‘God ita kafale-balata, nuyo utamsaalup kale, nulumi aget fugunin uta kafale-buluta, nugol God imi mufekmufek uyo utamsup o,’ agan-nuubip kalaa age-nalapta, kabo kapmi aget fugunin tambal uyo kubalapta, bilip iyo maak utamanbaalip kale minte, unang tinum iip maak maak iyo bogo-nilip e, ‘God kabo kafale-balapta, utamum o,’ agan-nuubip kalaa age-nalapta, bilip ita kafale-balap utaman-bilip kale, (bilip iyo nimi weng uyo tinangkamin kup kemum o agan-nuubip) kale, boyo, Aatum kabo, ‘Suguul o,’ kagan-bii ko. ");
INSERT INTO tlf_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Kapkal, kanupmin kuguup boyo kanumin o age-nalapta, kapmi aget fugunin tambal uyo utamsaalup kalaa agan-bilip tinum imi kupka-e-bom kafale-balapta, utaman-bilip o,” age Yesus iyo God imi bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kale beten ke-e-be uyo binimanu e, umi atuk kem uyo Yesus iyo unang tinum tagang tem kugol bom-nala e, bogola, “Nimi Aatum iyo mufekmufek uyo alugum kwaap-nama mek nimi sagaal diim abe-suu kale, niyo ilami man aligaap kuta, unang tinum iyo maak nitamta, beyo God ilami Man aligaap kalaa agesaalip kale, nimi Aatum ita kup nitamsa kale, ulutap kale, unang tinum iyo maak nimi Aatum iyo atamta, dogonupmin tinum kalaa agesaalip kale, ilami Man nita kup atamsi kale, unang tinum nagal ulu-nili nimi Aatum imi sang uyo kafalemi umdii, bilip ita Aatum iyo atam no kelan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ibaa. Juda kasel imi kamogimal ilimi weng kangkang kwiin tagang uyo kwep yak God imi ulo diim kwek daa anung tifi-em tebesip kale, tinum dok ita weng kangkang boyo bong faga-bom waafulup kalaa age-nilip aget iluum tebepmu umdii, ibo nimi finang tilipta, dong dogobe ipmi aget fugunin uyo telela kobelita, bilili age-bom-nilipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Niyo nalami ulo uyo ipmi kopmi waafulan-temip uyo, nalami kuguup uta kafale-bilita, ipkil dagaa ku waafu-nilipta, bilili agon-temip ko. Niyo dukmen bilili agin tinum kale, ipkil mungkup nalatap ke-nilipta, dukmen-nilip e, bilili age-bom-nilipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nimi ulo boyo bong fagamin ba kale, kaal fong so kale, meng nimi miit tem kagal bom-nilip nimi ulo boyo waafuu kwep tebe-bilipta o,” age Yesus iyo ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tam God imi ifin am ko age ulotu am maak daanu e, Yesus so ilami okumop man isino iyo rais ko age wiit ilang umi iibak tem miton kutop-tele ninggil dagaa dep unip ko. Kale ilami okumop man iyo abe-bom-nilip e, iman tep tebepmu e, wiit san uyo ugu kulu-nilip e, unan tam tam abe-bilip e, ");
INSERT INTO tlf_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Falosi iip maak maak iyo itam-nilip e, Yesus imi bogopmip, “Kabaa. Kabo tinangku-salapta. Numi ulo uyo bogo-nulu e, ‘Ibo God imi ifin am uyo iman fagan-bii kulep telemin ba o,’ agesu kuta, kapmi okumop man iyo intaben o age-nilipta, wiit boyo uga-bomta iibala-bom unan-bilip a? Bilip iyo numi ulo uyo kufak dagan-bilip o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","minte Yesus isiik bogobe-nala e, “Ibo God imi suuk kon tem weng tikim-nuubip boyo dagaa kusaalip aga? Sugamiyok uyo Devit isino ilami waasi dinan-kalin tinum isino ninggil iman tep tebepmu bom-nilip uyo, Devit iyo intaben nusa a? ");
INSERT INTO tlf_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ulotu umi ulo uyo bogo-nulu e, ‘Unang tinum ibo pris ko age tinum amem imi bret fuu kulep no God imi kobelum o ageta God imi am kutam tom-nuubip boyo unan-kalin ba ko. Boyo amem kale, tinum amem ita kup unan-kalin o,’ agesu kuta, Devit iyo God imi am kutam uyo no-nala e, tinum amem iyo iman amem umi sang dagala tinum amem iyo du-filin daa iman amem uyo kopma e, Devit iyo atuk fagaa ku une-nala e, atuk uyo ku ilami waasi dinan-kalin tinum imi kopma unesip ko. Kale ninggil bilip iyo ulo uyo ilo kosip kuta, ibo bogo-nilip, ‘Boyo kuguup mafak kanubesip o,’ agan-nuubaalip kuba. Kale intaben o age-nilipta, nimi okumop man iyo iman tep tebepmu kanu-bilipta, ibo bogobe-nilip, ‘Boyo kuguup mafak kanu-bilip o,’ agan-bilip a? ");
INSERT INTO tlf_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ulutap kale, God imi suuk kon tem weng uyo bogo-nulu e, ‘Ibo God imi ifin am uyo ogok kemin ba o,’ age-som, minte pris ko age tinum amem imi bogobe-nulu e, ‘God imi ifin am uyo ogok migik migik uyo kemin ba kale, ilipmi tinum amem ke-bom umi ogok kemin uta kup kanu-bilipta o,’ age no kesu kale, God imi ifin am umi daanu tinum amem imi tebe ulotu am ogok kem-nuubip boyo, bilip iyo ifin am o age ogok kup-kagamin umi ulo uyo ilo kupkan-nuubip kuta, ibo bogo-nilip, ‘Boyo kuguup mafak kanu-bilip o,’ agan-nuubaalip ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kale ibo, ‘Boyo tambaliim o,’ agan-nuubip kuta, nimi weng kaa bogobelan-temi koyo tinangku-silipta. God imi tinum nimdala ti-sii nita ulotu am miton boyo kubaganu kupka-nilita, nita nita kesi kale, nimi okumop man imi tebe ifin am umi ulo boyo ilo ko-nilip nimi ogok keman-temip bogal mungkup tambaliim no ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","God iyo ilami suuk kon tem weng uyo bogo-nala e, ‘Nimi tiin diim uyo ipmi tolop kulep tal ano God imi kobe, numi fengmin uyo molum o age kupkanemin boyo katip so kale minte, ipkumal imi kuguup tambal kupka-emin uta nimi tiin diim uyo kwiin kiim kale, ibo kanu-eman-temip uyo, niyo ipmi deng afalik uyo tebeman-temi o,’ agesa kale, ibo God imi weng bomi magam uyo atin ki tele dagaa ku-silip nimnam, tinum kuguup mafak waafulin binim tambaliim albip bilip iyo ibo tebe yegem-nuubaalip kuta ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Mo Tibil imi Man niyo God ilami ifin am umi tiin molin tinum iyo kalbi kale, niyo tii unang tinum imi bogobe-nili, ‘God imi ifin am diim kagal ibo bo kanumin o,’ age-nimi o,” age Yesus iyo Falosi imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesus ninggil iyo wiit ilang boyo kupka-nilip e, no Juda kasel imi ulotu am tam unip ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kale tinum maak sagaal milii fuulanebesa iyo ulotu am kutam kal bom-bala e, minte Falosi igil mungkup kutam kal bom no ke-bom-nilip e, Yesus iyo titul mobe dup-kugulupta, kuguup mafak umaak kanupma kalaa age-nulupta, duptamo weng telelmin tinum imi finang dep no daa dupkem daalum o age-nilipta, Yesus iyo bogobe-nilip e, “Tinum iyo maak God imi ifin am daanu umi diim kota tinum mafak ilin maak telela dola umdii, bemi kanubela boyo God imi ulo umi ilo kupkamin kuguup uyo kulbu bele ki? Kapmi aget fugun-balap ule a? Di kapkal bogobelapta o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesus iyo yan kebe-nala e, “Ibo dogap kapta kapmi sipsip tiin molap alba iyo maak God imi ifin am daan-bom-sulu kota, iyo kumen daak kafin tem una kalaa agelap uyo, kulagal dupkalap son-tema bele ki, asok dep mitam daalan-temap a? Boyo dep mitam daalan-temap kuba. ");
INSERT INTO tlf_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Kuta God imi tiin diim uyo sipsip bilip iyo tolop kale, iyo bilip imi aget uyo katip kup kem-nuuba kale minte, unang tinum bilip iyo win so kale, bilip imi aget uyo suun kup fugun-nuuba kale, God imi aget fugunin uyo, ‘Ipmi ipkumal suun kup kuguup tambal kupka-ebip ulutap ke nimi ifin am daanu uyo, ipkumal iyo kuguup tambal kupka-eman-temip boyo tambaliim o,’ agan-nuuba o,” age Yesus iyo imi bogobe kupka-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","fupkela tinum sagaal milii fuulanebesa imi bogobela, “Kapmi sagaal uyo tifilal o,” agela e, tinum iyo imi sagaal uyo tifi kola e, kota imi sagaal uyo tambalanebe-nulu e, sagaal milii tambal ulutap kebelu ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kale Falosi iyo kota olsak deebelu e, kulili mo fen mo-nilip e, ulotu am uyo kupkaa daage no am migik kal tala tala ke afeta-nilip e, ilep umaak fen-bom utamta, Yesus iyo angkolup kaanak o age-nilip e, Falosi iyo ninggil weng uyo tegenip ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Falosi iyo weng tegen-bomta, Yesus iyo angkolum o age ilep fen-bilip e, Yesus isiik isiik ke utamata e, kanune-bilip kalaa age-nala e, abiip boyo kupkaa daagina ko. Kale unang tinum kwiin tagang iyo umik begebe no tamip e, imi unang tinum mafak ilin umkan unsip iyo alugum telela imka-bom-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","titil weng uyo bogobe-nala e, “Nimi tebe-nili ipmi mafak ilin telele-bii bomi sang uyo ibo no-nilip ipkumal imi diim uyo bagamin ba o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Sugayok uyo God imi weng kem baga-emin tinum Aisaya iyo God imi suuk kon tem uyo ko Yesus imi kanubela bomi sang uta dola kosa kale, ko tol mitam ti-suu ko. Kale Aisaya iyo bogo-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“God iyo bogo-nala, ‘Ibaa. Beyo nimi ulaa duli kamok kesa tinum aligaap e minte, nalami ogok kemin tinum miton no kale, beyo nimi bubul kale, bemi deng uta kup taban-bii ko. Kale niyo nalami Sinik iyo daali no imi diim abe-bom-nalata, dong daga-e-balata, weng telela kupka-emin tinum ke-nalata, daak kafin ko kutufosu bomi unang tinum alugum imi bogobe-nala, “Kanupmin kuguup tambal uta kup ke-bom-nilipta o,” agan-kalon-tema kuta. ");
INSERT INTO tlf_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","beyo wengaal digin-bom min, alaang weng baga-bom min, abiip mat kal mo fomtuup olan-bom no keman-temaala ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kale beyo unang tinum titil fagalin binim buluut buluut ke-bilip iyo bet bubul sino kuguup tambal so uyo kupka-eman-tema ko. Kale beyo ilami ogok uyo fomtuup waafu-bom-bala bii, kuguup mafak uyo kufak daala binimanuta, kuguup tambal uta uta kelan-temu ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kale daak alugum kafin ko kutufosu bomi tinum miit maak maak umi unang tinum iip maak maak iyo ilami ilak uta kup duga-bom beyo fen-bilipta, no tolon-tema o,’ age God iyo kam agesa o,” age Aisaya iyo kam age dola kosa ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Sinik mafak tebe tinum maak dufak daala e, iyo tiin dagamin binim e minte, weng bagamin binim no kesata, tinum beyo Yesus imi finang duptamo tal daalipta, ita telela dola e, mitam tiin baa-nala e minte, weng bogo no kela e, ");
INSERT INTO tlf_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","unang tinum iyo alugum utam kumang mo-nilip e, ipkumal iyo bogobina tala ke-bom-nilip e, bogolip, “Ipmi aget fugunin uyo, tinum beyo God imi ulaa daala ti-se tinum Devit imi man ilop ita kalaa agan-bilip bele ki? Minte ipmi aget fugun-bilip ule o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Falosi iyo tolong do yan kebelip, “Umbae. Boyo God imi titil ugo ba kale, sinik mafak imi kamok Belsebul ko age Saatan ilami titil uta yagal Yesus bemi kopmata, sinik mafak mafak iyo fot tebelata, yak iinan-bilip o,” agan-kalip e minte, ");
INSERT INTO tlf_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesus iyo Falosi imi aget ko fugun-bilip boyo utamebe-nala e, bogobela, “Ibaa. Do weng kaa bogobelan-temi koyo tele tinangku-silipta. Abiip maagup uyo bigi ko miit alop kelu alop igil dinan-kalip umdii, kulip imi titil fagaa tambaliim bomip uyo, kota imi titil umdii binimanan-temu ko. Kale ulutap, unang tinum am maagup albip iyo suun wengaal digin-bom dinan-kalin kup kemip umdii, maagup nan-temaalip binim kale, igil bigi ko una tala kelan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kale ulutap Saatan iyo ilami sinik mafak sino ulimal igil waasi kebina tala ke bigi ko miit alop ke dinan-kalip nimnam, ulimal kulip iyo titil fagata tambaliim albaalip e minte, bilip imi titil uyo binimanepman o angbu kuta ko. Kale ibo bogopne-nilip, ‘Belsebul iyo Yesus imi diim kal bom-nalata, dong daga-e-balata, unang tinum sinik mafak tebe imdugan unsu bilip iyo fot taban-be o,’ agan-bilip kuta, Saatan iyo tebe ilami sinik mafak iyo fot tebela yak iinomip binim kuba. ");
INSERT INTO tlf_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Niyo sinik mafak iyo fot taban-nuubi kale, ulutap ipmi okumop man igil mungkup sinik mafak iyo fot taban-nuubip kale, ibo bogo-nilip, ‘Saatan ita Yesus beyo dong dogobelata, sinik mafak iyo fot taban-be o,’ nagan-bilip kuta, Falosi ibo bogo-nilip, ‘God yagal numi okumop man iyo dong dogobelata, sinik mafak iyo fot taban-bilip o,’ agan-bilip a? Intaben o age-nilipta, weng alop boyo ugulumi bogo bogo ke-bilip a? Ipmi kanu-bilip boyo tebe ipmi okumop man iyo kafalepmuta, utamipta e, nimi sang bagane-bilip boyo bisop bagan-bilip kalaa agan-bilip kuba. Saatan ita tebe titil uyo kopnesaala binim kale, God yagal titil kopnelata, sinik mafak iyo fot taban-bii kale, ibo amon amon ke-bom-nilipta, weng boyo bagan-bilip ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","God ilami Sinik Tambal ita dong dogopnelata, niyo sinik mafak iyo fot tebeli yak iinan-nuubip kale, siin God imi tebe ipmi bogobe-nala, ‘Nimi tinum ulaa duli kamok kesa iyo daali no tal ipmi diim abe dong daga-e-balata, ibo mitam nimi daam tem e tolon-temip o,’ agela fen tebesip iyo nita kale, ibo nimi kuguup ko kanu-bii boyo utamipta e, fen kalaa agelin o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Kale nimi do weng koyo tinangku-silipta. Tinum dogap ita tam tinum titil tebesa imi am unom imi mufekmufek uyo dugubelan o agela umdii, yuguut unin beyo tebe kamaki kugol tinum titil tebesa beyo sok de do-nalata, kaal binim tam-nalata, imi mufekmufek uyo dugubelan-tema o,” age Yesus iyo kam agela (kale, do weng bomi magam uyo ki, Yesus imi titil uyo Saatan imi titul uyo kubaganu dupkasa kale, unang tinum Saatan imi sagaal ban tem albip iyo Yesus iyo tebe imi sagaal uyo dagaa kupkan kebe-nalata, imdep meng ilami miit tem daagan-nuuba kale, bomi sang bota felep yak ku to-nalata, do weng boyo bogola) ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Kale Yesus iyo asok bogo-nala e, “Unang tinum dogap ita nimi ogok kenemin binim min, ipkumal dong daga-e-bilip meng nimi daam tem e telemin binim umdii, bilip iyo nimi waasi ilitap ke unang tinum uget taga-bilip nimkaa yang iinebip ulutap ke-bomta kanum-nuubip ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kale ibo tele utama-bom-nilipta a. Tinum dogap ita kuguup mafak ke-bom weng mafak baga-bom ke-boma nala imi aget uyo fupkela ko imi kuguup mafak ke-be uyo kupkala umdii, God iyo tebe bemi kuguup mafak ke-boma boyo tagaa kupkan kebelan-tema kale minte, tinum dogap ita God imi Sinik Tambal imi sang bogobe-nala, ‘Belsebul ko age sinik mafak imi kamok ita tebe Yesus iyo dong daga-e-be o,’ agon-tema uta, God imi Sinik Tambal imi win uyo kufak daabela kalaa age-nalata, God iyo tebe bemi fengmin boyo tagaa kupkan kebelan-temaala binim ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kale tinum dogap ita Mo Tibil imi Man nimi win uyo kufak daapneli kalaa age-nala asok imi aget uyo fupkela ko nimi kopnelan-tema uta, God yagal tebe imi kanubela boyo tagaa kupkan kepman-tema kale minte, tinum dogap ita God imi Sinik Tambal imi win uyo kufak daabelan-tema uta, kamano kalota kwep kutop iinu uyo, God iyo tebe bemi kanubela boyo atin tagaa kupkan kebelan-temaala binim o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yesus iyo asok Falosi iyo bogobe-nala e, “Ibo at dum abumin umi kuguup uyo utamin. At dum tambal abumin uyo ulumi dum tambal uta kup abulan-temu e minte, at dum mafak abumin ugol mungkup ulumi dum mafak uta kup abulan-temu no kale, nuyo utamupta e, kanupmin at dum abulu kalaa agelup umdii, utamupta, bota at tambal e minte, bota at mafak kalaa agelan-temup ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","35","Ulutap kale, nuyo tinum itamupta, dogonupmin dogonupmin kuguup uta kanum-nuubip kalaa agelup bole, nuyo utamupta, imi aget fugunin uyo kanupmin utamta, boyo kanum-nuubip kalaa agelan-temup kale, tinum tambal iyo aget fugunin tambal so kale, iyo kuguup tambal kup ke-bom-nilip e, weng tambal kup baga-bom no kem-nuubip kale minte, tinum mafak ita aget fugunin mafak kup ke-bom-nilip e, weng mafak kup baga-bom-nilip e, kuguup mafak kup ke-bom no kem-nuubip ko. Kale Falosi ibo aget mafak fugun-nuubip kale, ibo bagang-kale nimi ogok sang uyo tambaliim maak bogolan-temaalip binim kale, ibo inap mafak tebe sit daang tuup unang tinum imi ifak dagan-nuuba ulutap ke ilipmi weng uta baga-bom-nilipta, unang tinum iyo ifak dagan-nuubip ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Tolong umo-silipta, weng koyo bogobelan o ageta ko. Afungen tem umi tulu God imi tebe unang tinum alugum maagup tele itamaman-tema uyo, yagal unang tinum maagup maagup imi aget fugunin tambal binim ke weng yamyam bagamin kup kem-nuubip umi sang uta alugum dagalata, iyo God imi tiin diim kal God imi weng uyo yan ke-e-bom dupkop daapman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kale God iyo ipmi weng tolong dolan-tema uyo, iip maak maak ipmi bogobe-nala e, ‘Ibo kuguup tambal kemsip o,’ age-nalata, imtamo no ilami abiip daa-nala e minte, iip maak maak ipta bogobe-nala e, ‘Ibo kuguup mafak kemsip o,’ age-nalata, imdala abiip mafak un no kelan-temip o,” age Yesus iyo Falosi imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kota ulo utamsip tinum iip maak maak so Falosi iip maak maak so iyo Yesus imi bogobe-nilip e, “Kafalemin tinum kabaa. Nuyo ki, kapta mirakel ko age kuguup ugulumi migik umaak kafalebelapta, utamupta e, kabo ki tuluun God ita kamdala ti-salap kalaa agelum o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesus isiik imi weng uyo yan kebela, “Ibo God imi weng uyo tinangkanbaalip kale, ibo aget mafak fugun-bilip kale, ibo bogopne-nilip, ‘Kabo mirakel ko age kuguup ugulumi migik umaak kafalebelapta, nuyo utamupta e, fen God yagal kamdala ti-salap kalaa agelum o,’ agan-bilip kuta, kanupmin kuguup boyo maak kafalebelan-temaali kale ki, niyo sugamiyok God imi profet Jona imi kuguup kanubesa ulutap uta kup kafalebelan-temi ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona iyo top aniing kwiin kiim umi mat tem kal bii, am alop ke-nalata, am asuno diim kota mitam e tisa kale, ulutap kale, Mo Tibil imi Man niyo kafin umi bubul tem kulagal bii, am alop ke-nilita, am asuno diim kota fen mitam e tolon-temi ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Afungen am daanu God tebe unang tinum alugum imdep no weng telelmin baan diim daa-nala yegeman-tema uyo, Ninive kasel iyo fen mo-nilipta, ipmi sang uta bogo-nilip e, ‘Nuyo Jona imi weng tambal uyo tolong do-nulupta, aget fupkela ko-nulupta, numi fengmin uyo kupkasup kuta, Jona imi weng tambal uyo kubaganuta, Yesus imi weng tambal uta uta kesu kale, unang tinum kulip iyo Yesus imi weng uyo tolong do-silip kuta, kulip iyo bogo-nilip, “Nuyo aget fupkela ko-nulup numi fengmin uyo kupkalan-temaalup o,” agesip o,’ age Ninive kasel iyo ipmi sang uyo God imi bogobelan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ulutap kale, sugamiyok uyo Seba kasel imi tiin molin unang ko age kwiin uyo, Solomon imi weng tambal uta tinangkulan o age-nuluta, umi abiip uyo kupkaa talanbu tal Israel kasel numi bagan koyo ti-suu kale, son-temu nala afungen am daanu God tebe unang tinum alugum imdep no weng telelmin baan diim daa-nala yegeman-tema uyo, unang bota fen mo-nuluta, ipmi sang uyo bogo-nulu e, ‘Solomon imi weng tambal uyo kubaganuta, Yesus imi weng tambal uta uta kesu kuta, unang tinum kulip iyo tolong dosaalip binim o,’ age God imi bogobelan-temu o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yesus iyo asok bogobe-nala e, “Sinik mafak iyo tinum maak imi diim kal nuubata, dupkaa daage no ok binim bagan umi diim maak kugol yang o meng o ke-bomta, baan diim umaak utam-nilita, nan o age-nala e, fen te te kemata e, baan diim umaak utamin-tem keli kalaa age-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","bogola, ‘Nimi am binim kale, asok no nalami tinum dupkaa ti-sii imi diim kal nan-temi o,’ age-nala e, asok unanbu no abomu, imi tinum imi iibak tem uyo am umi ifip tolo alugum mufekmufek kan ke kupkaa daaginip bisop albu ulutap kebu kalaa age-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","no sinik mafak ban kal maak iyo itamata e, bilip imi kuguup mafak uyo nimi kuguup uyo nimkan ke ita ita kesip kalaa age-nala e, asok kulep tal tinum imi diim tola e, alugum maagup bom-nilip e, kamaki umi sinik mafak ilasinon nuuba beyo kubagana e minte, aaltam umi sinik ban kal bilip ita ita kelipta, kamano komi tinum bemi aget mafak fugunin uyo atin mafagan uta uta ke-nuluta, kamaki umi aget fugunin mafak kanum-nuuba uta kubaganu kupkalu ko. Kale ulutap kale, kamano koyo Juda kasel ipmi kuguup mafak ke-bilip uyo fong so kuta, son-temu nala ipmi kuguup mafak keman-temip uyo kwiin kiim keman-temip o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Age Yesus iyo unang tinum iyo baga-emata, Yesus ilami ogen so minte ilami nagalal ninggil sino iyo tal abiip kutam kal mo-nilip e, unang tinum albip iyo bogobe-nilip e, “Nuyo Yesus so weng maak bogolum o ageta tulup o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","tinum maak kutam alba iyo Yesus iyo bogobela, “Nugum kabaa. Kapmi kogen so nagalal ninggil so uptil iyo tal, kapsino weng maak bogolum o ageta talta abiip kal mobip o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesus iyo, unang tinum bilip iyo kafalebelita, mitam nimi unang tinum kelin o age-nalata, bogobe-nala, “Iyo waanta nimi aben so nimi nagalal so o?” age-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ilami okumop man iyo kul dil fagaa kobe kafalebe unang tinum iyo bogobe-nala e, “Kalip iyo itamin. Kalip iyo nalami aben so minte nalami nagalal so ilitap ko. ");
INSERT INTO tlf_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kale unang tinum iyo dogap ita nimi Aatum abiil tigiin kayaak imi bogo-nala, ‘Bota kanumin o,’ agan-be uta kup waafulip umdii, bilip ita nimi nengal, niingal minte aben no ilitap o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Am ko daan bom-sulu kota, Yesus iyo am kutam uyo kupka-nala e, daage top Galili Ok Muk daang diim kugol ton-bom-nala e, (unang tinum iyo kafalema ko.) ");
INSERT INTO tlf_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kale itamata e, unang tinum yamyam iyo tala tala ke fufala namak molip kalaa age-nala e, tam bot maak ok daang kun diim albu bomi tem kal tona e, unang tinum ita ok magaang diim kal mo no kelip (kale, imi weng uyo baga-e-bala alugum tinangkamip) ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Weng kwiin tagang uyo felep yak ku to dek ku to ke-bom do weng baga-e-bom kafale-bom-nala e, tam bogola ko. “Tam tinum maak iyo rais ko age wiit umi san uyo kulep no ilanggiip kugol segelam una ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kale san uyo segelam tiine-bala e, san iip maak maak uyo daak ilanggiip umi ilep kem diim kubelu e, uun tebe tal unelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Minte tam ilanggiip bomi kafin atuk maak uyo tuum tagang ke-nulu e minte, tol uta katip no kale, san iip maak maak uyo daak kanupmin kafin bomi diim abelu kale, tuum tip diim uyo tol katip so kale, maak fagaa bigin mitam tebelu kuta, ");
INSERT INTO tlf_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","timtim uyo fomtuup daak bigilin-tem kale, ataan mimin tebe wiit san boyo fuulu ken tebe-nulu e, datan kaanu ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Minte san iip maak maak uyo daak ifuul mafak umi iibak tem abelu e, ifuul mafak uta uta kelu e, wiit uyo ditutan mafaganu ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Minte san iip maak maak uyo daak kafin tambal diim abe tambaliim tebe-nulu e, abu-bii ko-nulu e, talkun kun maagup diim kwegal iip maak maak uta 30 abulu e minte, iip maak maak uta 60 abulu e minte, iip maak maak uta 100 abulu no kelu ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ibo tolong kom ba kale, tolong tambal kale, weng ko bogobeli boyo tele tolong do-nilipta, dagaa kulin o,” age baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yesus iyo weng baga-e-bala bii, binimanu e, ilami okumop man iyo tal Yesus imi bogobe-nilip e, “Kamogim kabaa. Intaben o age-nalapta, unang tinum imi weng baga-emap uyo, felep yak ku to dek ku to ke-bomta suun do weng uta kup baga-em-nuubap o?” age dagalip e, ");
INSERT INTO tlf_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","minte Yesus isiik bogopma, “Siin uyo God iyo unang tinum ilami daam tem mitam tilip tiin molan-tema umi sang uyo alugum baga-emsaala kale, atuk uta kup kale, kamano koyo God yagal ipmi aget tem uyo bam daabela ipkil utamipta e, Yesus imi do weng ko baga-e-be bomi magam uyo tam God imi daam tem unup tiin molan-tema umi sang uta kalaa age utabip kuta minte, tinum migik migik ita utaman-nuubaalip binim ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tinum iyo dogap ita nimi weng uyo tolong do dagaa kula umdii, beyo God tebe dong daga-e-bala dagaa ku yakyak kem unom-nalata, te tam atin utaman-tema kale minte, tinum iyo dogap ita nimi weng uyo, tele tolong do dagaa kulaali o agela umdii, bemi kamaki kutop umi katip utam-se ita kup siit-nala e, ilumano kupkalan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kale kanupmin unang tinum bilip iyo nimi ogok telela-bii boyo ilimi tiin fala utaman-nuubip kuta, iyo utamipta, boyo fen kalaa agan-nuubaalip binim e minte, ilimi tolong alop uyo nimi weng boyo tolong dugan-nuubip kuta, iyo utamipta, weng bomi magam uyo kulbu kalaa agan-nuubaalip binim no kalaa age-nilita, nagal do weng boyo kanupmin unang tinum bilip imi baga-emin kup kem-nuubi ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","15","Sugamiyok uyo profet Aisaya iyo God imi suuk kon tem kwegal kanupmin unang tinum bilip imi sang uyo dola ko bogo-nala e, ‘God iyo bogo-nala e, “Unang tinum ipmi aget fugunin uyo ibo tele aget fugunin binim kale, ibo, tolong dolaalup o age ipmi tolong uyo kati-nilip e minte, tiin baa utamaalup o age ipmi tiin uyo kami no kesip ko. Kale kanu-bilip bota, ibo, weng uyo maak tolong dolup kalaa age-nilipta, tinangku dagaa kugamin binim e minte, dogap uta maak utamup kalaa age tele utamamin binim no ko. Kuta minte ipmi aget fugunin uyo fupkela kolan-temip uyo, ibo mufekmufek utaman-bilip umi magam uyo utaman-temip e minte, weng tinangkan-bilip umi magam uyo tele utam no kelan-temip kale, ipmi aget fugunin uyo tambalanebeluta, ibo nimi finang tilipta, telela imolan-temi o,” age God iyo kam ageba o,’ age Aisaya iyo dola kosa kale, ko imi weng uyo mitam tulu ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Kale nimi okumop man ibo kanupmin unang tinum ilitap ba kale, suguul ke God iyo ibo aget fugunin tambal kobe-se kale, ibo mufekmufek utaman-bilip uyo tele utam som minte, weng tinangkan-bilip uyo tele tinangku no ke-bilip ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kale tuluun weng bogobelan-temi kale, sugayok uyo God imi profet ko age weng kem baga-emin tinum so God imi unang tinum milii sino kwiin tagang iyo nimi ogok ko kanu-bili ipmi utaman-bilip koyo utamum o age-nilipta, komi sang uyo bagamsip kuta, utamipta e, ko mitam tulu kalaa agesaalip binim e minte, nimi weng ko ipmi baga-e-bii koyo aa mungkup igil, tolong dolum o agansip kuta, bilip iyo tolong dugamsaalip binim no o,” age Yesus iyo ilami okumop man imi bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Kale kota Yesus iyo ilami okumop man iyo bogobe-nala e, “Tinangku-bom-silipta, niyo do weng felep yak wiit san fagagamin tinum imi diim to bogobeli bomi magam uta bam daa imolan-temi ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tam unang tinum iip maak maak iyo tinum imi wiit san segela kulula daak ilep kem diim abebu ulutap kale, iyo mitam God imi daam tem telemin umi sang uyo tinangkan-nuubip kuta minte, iyo maak tele utamin-tem kem-nuubip kale, Tinum Mafagim Saatan iyo uun ilatap ke tal-nala e, God imi weng aget tem kulaak albu uyo dagaa kupkan kebelata, unang tinum iyo weng boyo ilumanebelan-temu ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Minte unang tinum iip maak maak iyo tinum imi wiit san segela kulula daak kafin tuum tagang tem tem umi diim abebu ulutap kale, bilip iyo God imi weng uyo tolong do-nilip e, weng boyo yuut, ‘Aafen o,’ age deng tebemip kuta, ");
INSERT INTO tlf_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","weng boyo fomtuup kwep yak ilimi aget tem daalin-tem kelip kale, siitap ilugo-nilip e, mufekmufek mafak uyo tal bilip imi diim abelu min, tinum migik iyo tebe God imi weng umi kalan uyo bilip iyo bon dii-emip min uyo yuut kupkaa yang iinon-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Minte unang tinum iip maak maak iyo tinum imi wiit san segela kulula daak ifuul mafak umi iibak tem abebu ulutap kale, bilip iyo God imi weng uyo tolong dolan-temip kuta, kafin diim komi mufekmufek duumatanan-temip umi aget afek fugunin min, mani kwaa-bom deng tebemin uta kale, kanupmin aget fugunin uta afaligen ke-nuluta, God imi weng umi aget uta kubaganu kupkalan-temu kale, wiit umi dam binim, ol kup kelu ulutap ke-nilipta, God imi weng uyo fomtuup dital fagaa waafulan-temaalip ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Kale minte unang tinum iip maak maak ita tinum imi wiit san segela kulula daak kafin tambal diim abebu ulutap kale, iyo God imi weng uyo tolong do-nilip e minte, tele utam no kelan-temip uyo, God imi weng uyo suun kup waafuu kanuman-temip ko. Kale tam iip maak maak iyo wiit kwek umi 30 abubu ulutap kela e minte, iip maak maak iyo 60 abubu ulutap kela e, iip maak maak iyo 100 abubu ulutap ke no kelan-temip o,” age Yesus iyo do weng bomi magam uyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesus iyo unang tinum imi kuguup mafak waafunamin umi do weng maak felep yak ku to unang tinum iyo bogobe-nala e, “God imi unang tinum imdep meng ilami daam tem daa-nala tiin molan-tema uyo ulutap kale, tam ilanggiip kayaak isiik tebe rais ko age wiit umi san tambal uyo kulep no ilami ogok ke-emin tinum imi kobela fagagan-bii kupkaa unon bateng, ");
INSERT INTO tlf_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","mililep kota unang tinum iyo alugum agaal un-bom-bilip e, imi waasi iyo tebelata, bantap al mafak umi san uyo kulep tal wiit san fagagan-bii kupkaa unip umi tekek tem tem kugol fagagan-bii kupkaa daagina e, ");
INSERT INTO tlf_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","wiit san uyo tebe-nulu e, te tam abuman o agan-buluta minte, ogok kemin tinum iyo utamipta e, wiit abuman o agan-bo umi iibak tem tem kulaak uyo al mafak uyo taban unbu kalaa age-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","no imi kamok wiit ilang kayaak iyo bogobe-nilip e, ‘Kamogim kabaa. Kabo wiit san tambal uta kup kobelap kulep no faga-sulup kuta minte, al mafak boyo dogonubeta wiit san umi iibak tem kulaak uyo tebebu a?’ agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","bogobela ko. ‘Numi waasi iyo maak tal-nalata, al mafak san boyo kulep tal fagaa unba kuba,’ agela e, kamogim imi ogok kemin tinum iyo bogolip ko. ‘Kanubinba bole, nuyo no-nulup al mafak boyo dito-numup bele o?’ age dagalip e, ");
INSERT INTO tlf_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","bogobela ko. ‘No-nilip al mafak bomi digin-kalon-temip uyo, wiit kusino dola kugan keman-temip kale, al mafak uyo digin-kalin ba kale, ");
INSERT INTO tlf_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","kupkalip bom-buluta bii, wiit kusino al mafak kusino tebe-nulu te tam abu damanuta, wiit ugamin umi am daanan-temu uyo, ibo bogobe-nili e, “Kamaki uyo al mafak usiik foga-bii de kulep to yak yak ke-nilipta, at kwegalip ken tebeluta, aaltam wiit uyo ugan-bii kulep tal nimi am kutam tomin o,” agelan-temi o,’ age wiit ilang kayaak iyo tebe imi ogok kemin tinum iyo bogobe-se o,” age Yesus iyo unang tinum imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Yesus iyo do weng maak asok bogobe-nala e, “Unang tinum God imi daam tem albip bilip iyo mastat umi san ilitap kale, mastat san beyo atin fen ilap katipnok kuta minte, tinum maak tebe dep yang dola bemi tebe te tam kwiin kiim kelan-tema uyo, at ulutap ke kolu e, uun iyo te tam umi tung diim kutam kal imi um uyo dinan-kalon-temip o,” age Yesus iyo bogola ko. (Kale do weng bomi magam uyo bogo-nulu e, “Mastat umi san kulatap mungkup God imi unang tinum iyo kamano koyo iip maak maak kup kebip kuta minte, son-temu uyo, te tam te tam kem kwep unanbu top kwiin tagang kelan-temip o,” agesu ko.) ");
INSERT INTO tlf_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesus iyo asok do weng maak bogobe-nala e, “Unang tinum God imi daam tem albip iyo yiis ko age bret fitimin mufekmufek ulutap kale, unang maak tebe yiis katipnok maak tagaa daalu yak flawa afaligen tem iinu fiksigi-bulu bii, maagup kelu kalaa age kupkalu siitap ilugolu e, flawa uyo fito ugulumi migik kelan-temu ulutap o,” age Yesus iyo kam agela ko. (Kale do weng bomi magam uyo bogo-nulu e, “God imi ilak dolin unang tinum iyo unang tinum migik imi iibak tem kal albip umdii, ipkumal God imi ilak dolin binim bilip iyo igilimi migik ke-nilip e, igil mungkup God imi ilak uyo do-nilip e, kwiin tagang kelan-temip o,” agesu ko.) ");
INSERT INTO tlf_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesus imi tebe God imi weng unang tinum kwiin tagang imi kafalemsa uyo, do weng uta kup baga-e-bom-nalata, do weng umaak kup-kagamin binim kemsa ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kale beyo kanube baga-e-balata, God imi profet imi weng sugayok God imi suuk kon tem dola kosa uyo mitam tebe-suu ko. Kale profet imi weng uyo bogo-nala e, “Sugayok God imi kafin so abiil so telela kosa kwek ilota kwep tam tam talanbu tal kaa diibelu koyo, tinum dok ita God imi kuguup uyo maak utamsaala kale, kamano koyo God imi kuguup bomi sang uyo felep yak do weng umi diim to baga-e-bom-nili bam daa imka-bili tinangkaman-temip o,” age God imi weng kem baga-emin tinum ita Yesus imi sang boyo kam age-nalata, sugamiyok kutop kal bogosa ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesus iyo unang tinum kwiin tagang iyo ok muk umi daang diim kugol imka-nala e, no abe tam am iina e, imi okumop man iyo tal-nilip e, dagalip ko. “Kapmi felep yak wiit ilang umi al mafak umi diim to do weng ko baga-e-balap bomi magam uyo bogobelapta, tinangkulum o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","minte Yesus isiik bogobe-nala e, “Mo Tibil imi Man niyo tinum wiit san tambal kobela fagagamsip kulatap e minte, ");
INSERT INTO tlf_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","kafin kaa kutufosu komi unang tinum iyo nimi ilanggiip ulutap no kale, minte unang tinum mitam God imi daam tem e tilin bilip ita wiit san tambal ilitap e, minte Tinum Mafagim Saatan imi unang tinum ita minte al mafak ilitap no ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Minte Saatan beyo tinum waasi al mafak san fagagamsa ilatap no kale, afungen tem tolon-temu uyo wiit damanu ugan-bii kulep tal am tomin umi am daanabu ulutap e minte, ensel ko age God imi ok tubulin tinum bilip ita minte wiit ugan-bii kulep tal am tomin tinum ilitap no ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kale ogok kemin tinum tebe al mafak umi dola de fagaa fagaa ke kulep no at kwegalip ken tebebu ulutap kale, afungen tem tolon-temu uyo, ");
INSERT INTO tlf_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mo Tibil imi Man nagal tebe nimi ensel iyo imdali malaak-nilip e, tinum mafak tebe ipkumal imi aget fugunin kufak daabelip yang fengmin tinum sino e minte unang tinum kuguup mafak waafulin isino bilip iyo ensel iyo tebe itam-nilip e, God imi unang tinum imi iibak tem albip iyo imka-nilip e, unang tinum mafak igilimi imdep no ");
INSERT INTO tlf_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","kululip yak at mafak suun kup kenamin umi tem unom kaal fuyap tebe-e-bulu e, ‘Kwiin ko so intaben o ageta ka-tele talbup o,’ agan-bom-nilip e, fomtuup ameman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kale minte God imi unang tinum ita minte tam ilimi Aalap God imi abiip kal bom-nilipta, te tam God ilatap ke fengmin binim tol kup ke-nilipta, ataan tagalin tap kelan-temip ko. Kale ibo nimi weng tinangkulip boyo ilumano kupka-nimip kale, fomtuup waafulin o,” age Yesus iyo ilami okumop man iyo kanupmin weng kem boyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesus iyo asok do weng migik maak bogobe-nala e, “Sugamiyok uyo tinum maak tuumon kwiin tagang uyo kulu tet tem kal abu-nala e, kulep no ilanggiip kal kafin fagan-bii kubala nuubuta, kaanata, tuumon tet boyo ugol kafin tem kulagal maagalo nuubuta minte, am maak daanu e, tinum migik maak maagalo no kafin fagan tolom-nalata, tuumon tet boyo utama ko. Kafin boyo imi kafin ba kuta, tuumon bomi deng uyo kwiin kiim kup tebe-bom-nalata, imi aget uyo fuguno-nala e, ‘Tambaliim ke tuumon boyo nalami kulan-temi o,’ age-nala e, asok kafin uyo kulep te yak to tuumon tet uyo kati-nala e, no ilami mufekmufek am kutam albu uyo alugum kulep no tola molip umi mani uyo kulu-nala e, kulep no kafin boyo mo-nalata, ipkum kaansa imi tuumon kwiin tagang kubasa umdii kota ilami aligaap kebe-suu o,” age Yesus iyo bogobela ko. (Kale do weng bomi magam uyo bogo-nulu e, “Unang tinum dogap ita tam God imi daam tem unemin bomi aget uyo fomtuup ugaa kwaa-nalata, tambaliim ke tam unon-temi o agela umdii, beyo bomi deng uta kup tebe-bom bemi mufekmufek aget kupka-e-be boyo alugum kupka-nalata, mitam God imi daam tem e tolon-tema o,” age do weng boyo bogosu ko.) ");
INSERT INTO tlf_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","Kale Yesus iyo felep yak ku tomin weng maak uyo mungkup ulutap bogobe-nala e, bogola ko. “Tam siin kota tinum maak tisol amiit uyo saan-bii kulep tal fagagan-bii kolata, tal saan-bii-silip kale minte, yagal bonang uyo fen tiine-bom utamata, tambaliim uta kup albu kalaa age-nalata, saan-bii-se kale, tam am maak daanu e, fen tiine-bomta e, tinum maak atin ki bonang tambal maak waafuba kalaa age, bota molan o agela kuta minte, utamata, bomi tuumon saanin uyo kwiin kiim kalaa age kupkata ilami tuumon albu umi kulu bonang bomi molan agin uyo duumatanu kalaa age kupka-nala e, daage no ilami mufekmufek am kutam albu uyo alugum kulep no tola alugum molipta, umi tuumon uta kulu kulep tal-nalata, atin bonang tambal boyo mo-se o,” age Yesus iyo bogobela ko. (Kale do weng bomi magam uyo bogo-nulu e, “Kanube unang tinum dok ita atin mitam God imi daam tem uyo tam unon o age aget kup ugaa kwaala umdii, kamaki uyo imi mufekmufek aget kup suun fugun-boma boyo kupka-nalata, mitam God imi daam tem uyo mitam tolon-tema o,” age do weng koyo bogosu ko.) ");
INSERT INTO tlf_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesus iyo unang tinum God imi abiip unon-temip umi sang uta felep yak ku to bogobe-nala e, “Tinum iip maak maak iyo aniing abumin umi men kwiin kiim uyo kwaalip unanbu daak ok tem unom-nulu e, aniing kwiin tagang migik migik uyo afeta kolu e, ");
INSERT INTO tlf_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","tinum iyo utamipta e, aniing abumin men uyo dongen kolu kalaa age-nilip e, kupkaa men uyo biinga kuptamo talanbu mek ok kan tem daa-nilip e, daak ok diniing diim kal ton-bom-nilip e, aniing uyo kulep mitam to to ke-bom tambal tambal uta kulu tet tem abu-bom-nilip e minte, mafak mafak uta asok kululip daak ok kumun tem une-bulu no kemip ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ulutap kale, am afungen tem uyo God imi ensel iyo tal-nilip e, unang tinum iyo bigi ko-nilip e, mafak mafak ita kasaak kasaak imi iibak tem kutam kal ulan-bii ko kulep igilimi afeta-bom-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","imdalip yak at mafak suun kup kenamin umi tem unom-nilipta, kaal fuyap afek uyo tebe-e-buluta, ‘Kwiin ko so intaben o ageta ka-tele talbup o,’ agan-bom-nilip e, fomtuup ameman-temip o,” age Yesus iyo do weng uyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesus iyo do weng uyo bogopma binimanu e, dagala, “Ibo nimi do weng umi magam uyo tele dagaa kulip aga o?” agela e, yan kebe-nilip e, “Aa. Dagaa kulup o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yesus iyo bogopma, “Ibo dagaa kulip umdii, ulo utamsip tinum mitam nimi okumop man ke-nilip God imi daam tem e talbip ibo tambaliim kup tonip ko. Ulo utamsip tinum ibo tinum siin umi mufekmufek tambal sino minte kamaa umi mufekmufek tambal so kwego dego ke afeta-bii kulep tomin tinum ilatap kale, unang tinum iyo tal bogobe-nilip, ‘Nuyo dong dogobelal o,’ agelan-temip uyo, beyo mufekmufek uyo tambaliim kup dong dogobelan-tema ko. Ulutap kale, siin uyo ibo God imi sugayok umi weng uyo tele dagaa kusip kale, kamano koyo ibo God imi kamaa weng umi ku baga-em tebesi uyo dagaa ku no kelip kale, ibo weng alop koyo kwep tulu tulu ke kwego kwego kelan-temip uyo, ibo God imi weng uyo unang tinum iyo tambaliim baga-eman-temip o,” age Yesus iyo ulo utamsip tinum iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesus iyo do weng iip maak maak boyo baga-e-bii binimanu kupka-nala e, abiip kutam uyo kupkaa ");
INSERT INTO tlf_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","asok tal ilami abiip miton Nasaret e tala kale, tal bom-nala e, no ulotu am kal unang tinum iyo God imi weng uyo kafale-bala e, unang tinum iyo tolong do-nilip e, kumang mo daga una tala ke-bom-nilip e, bogolip, “Weng ko kafale-be bota dogap-tele atin dagaa ku kupka-se a? Waanta kafale-balata, kanupmin mirakel ko age kuguup ugulumi migik boyo kanu-be a? ");
INSERT INTO tlf_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Beyo abiip katam umi at kom bagaa ku mufekmufek telelmin tinum imi man beta kale, imi ogen uyo Maria e minte, imi nagalal ninggil iyo Jems, Josep, Saimon, Judas no e minte, ");
INSERT INTO tlf_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","imi nengal ita abiip kagal albip no kale, beyo win tibin tinum ba kale, beyo bisop abiip tinum kale, ");
INSERT INTO tlf_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","bemi weng uyo tinangkulaalup o,” age-nilipta, umik ugobelip utam-nala e, Yesus iyo bogopma, “God imi profet ko age weng kem baga-emin tinum iyo no abiip maak maak unon-tema uta, abiip kasel iyo bogo-nilip e, ‘Keyo win tibin tinum o,’ age imi weng uyo tele tinangkulan-temip kuta minte, no ilami abiip miton unon-tema uta, ilami abiip kasel min, ilami duup-afin iyo imi weng umaak tinangkulan-temaalip binim o,” agela kale, ");
INSERT INTO tlf_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","abiip kasel iyo aget fuguno-nilip e, “Beyo God imi titil uyo waafusaala o,” nagan-bilip kalaa age-nalata, Yesus iyo mirakel ko age kuguup ugulumi migik kwiin tagang uyo ilami abiip uyo kanumaala ko. ");
INSERT INTO tlf_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kale kota Yesus imi sang uyo en daalu e, kota Provins Galili kasel imi tiin molin tinum Herot iyo tinangku-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ilami ogok kemin tinum imi bogobela ko. “Umbae. Beyo ok sam uga-emin tinum Jon Baptis kaan-se ita kale, ko God iyo tebe dufola asok fen tigi mo-nalata, kanupmin mirakel ko age kuguup ugulumi migik migik boyo kanu-be o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Kale Herot imi weng boyo ki, siin kutop uyo Herot ilami imdalim Filip iyo kaanin-tem bom-salata, Herot beyo tebe Filip imi kalel Herodias uyo tagaa kubeba kalaa age-nalata, bota Jon iyo suun kup baga-e-bom-nala e, “Kapkal utamsap kale, unang bomi ku-nalap kusino nuubap boyo, God imi bogo-nala, ‘Kuguup boyo kanumin ba o,’ agesa uyo ko ilo kobap o,” age yakyak ke-balata, Herodias uyo Jon iyo olsak kobe-nuluta, Herot iyo uget taga-buluta, ilami un tubulin tinum iyo bogopmata, no-nilipta, Jon iyo sok de dep no kalabus am daa-silip ko. ");
INSERT INTO tlf_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kale Herot iyo, Jon iyo angkolan o agela kuta, iyo utamata e, unang tinum iyo utamipta e, Jon beyo God imi profet ko age weng kem baga-emin tinum kalaa agebip kalaa age-nalata, utamata e, angkolan-temi uyo, bilip isiik tebe nagan-kalon-temip kalaa age finano-nalata, angkasaala kale, dupkalata, dep no kalabus am uta daa-silip ko. ");
INSERT INTO tlf_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tam am maak daanu e, Herot imi ogen dosu umi aget fugunin am uyo daanu e, Herot iyo unang tinum kwiin tagang iyo olabela tal Herot imi am kutam kal iman unan-bom deng tebe-bilipta, kota Herodias umi man unang uyo tal bilip imi tiin diim kugol atol tambal uyo daga-buluta, Herot iyo umi atol dagan-bo uyo utam-nala e, deng tebe-bom-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","bogobela, “Boyo tambaliim kale, niyo mufekmufek tambal maak kop-kaman o agan-bii kale, kupkal bogopne-nalap, ‘Intaben umi mufekmufek uta maak kopnelal o,’ agelap kalaa age-nilita, kop-kaman-temi o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","kota man unang uyo no ogen uyo bogobe-nulu e, “Aben aa. Niyo nota aben-diim beyo intaben mufekmufek uta, ‘Kopnelal o,’ agelan-temi o?” agelu e, ogen uyo bogobelu, “No-nalap Herot iyo bogobe-nalap e, ‘Nimi aget fugunin uyo, kapmi waasi dinan-kalin tinum iyo daalap no-nalata, ok sam uga-emin tinum Jon bemi dubom uyo ugaa ku felet diim iinu ifo kwep tal kopnelak o agan-bii o,’ age bogobelapta o,” age ogen uyo bogobelu ko. ");
INSERT INTO tlf_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","No Herot iyo bogobelu tinangku-nala e, utamata e, boyo kuguup mafak kalaa age-nala e, iyo aget iluum tebebelu, “Waago o,” agelan agin kuta minte, aget fugunolata, unang tinum kwiin tagang albip kalip iyo nimi weng kwep daali boyo tinangkulip kalaa age-nalata, kalip imi tiin diim uyo boyo kupkalan-temaali kalaa age-nalata, kota, “O,” age kupka-nala e, ilami waasi dinan-kalin tinum maak daala no ");
INSERT INTO tlf_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","kalabus am uyo no-nala e, Jon imi dubom uyo ugaa ku-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","felet diim iinu ifo kwep tal man unang umi kobelata, uta ku-nuluta, kwep no ogen umi kopmu ko. ");
INSERT INTO tlf_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kale kanubelata, Jon ilami okumop man iyo Jon imi sang uyo tinangku-nilip e, tal Jon imi at kulu uyo dep no duba-nilipta minte, aaltam kota no Yesus iyo Jon imi sang uyo bogobelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Kale kota Yesus iyo Jon Baptis imi sang uyo tinangku-nala e, aget iluum tebebelu e, ilami okumop man ita kup fola kulep te tam bot tem tola ninggil ton-nilip e, abiip boyo kupka-nilip e, Galili Ok Muk daang kun diim ilep tam tam yak milii abe no tinum binim iibaan bagan maak unum o age-nilipta, unip ko. Unang tinum iyo tinangkulipta e, “Yesus iyo bot tem ilep yak milii iinon o age-nalata, unan-be o,” agelip kalaa age-nilip e, ilimi abiip uyo kupka-nilip e, igil kafin diim ilep Yesus imi finang unip ko. ");
INSERT INTO tlf_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kale Yesus ninggil iyo yak ok muk milii uyo yak-nilip e, Yesus iyo bot tem uyo kupkaa daak kafin diim daakta e, unang tinum kwiin tagang iyo tala tala ke-bilip kalaa age-nala e, fomtuup i-filin daa-nala e, bilip imi unang tinum mafak ilin daam iyo telela imkama ko. ");
INSERT INTO tlf_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tam kanu-bala am kwiinu e, imi okumop man iyo tal Yesus imi bogobe-nilip e, “Kamogim kabaa. Koyo am kwiinbu e minte, iibaan bagan no kale, koyo iman binim kale, unang tinum iyo imdalap no abiip kal iman umaak mo une-nilipta, siin o,” age bogobelip e, ");
INSERT INTO tlf_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesus iyo bogobela, “Niyo imdali unon-temaalip kale, kagal bom-bilipta, ipta tebe-nilipta, iman uyo ifelip une-nilipta, siin o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ninggil iyo bogobelip, “Nuyo iman uyo tii ba kale, bret kangkang ogal maak e minte aniing alop maak no kalip ita kup albip o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesus isiik bogobe-nala e, “Kulep nimi finang tilin o,” agela e, kulep tilip ko. ");
INSERT INTO tlf_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kota Yesus iyo unang tinum iyo bogobela daak ifuul kon diim kugol tonip e, bret ogal sino aniing alop sino uyo dulu-nala e, abiil tigiin kiit fen God iyo, “Misam o,” age-nala e, bret sino aniing sino uyo fegela do-nala e, ilami okumop man imi dobelata, ita tebe-nilipta, unang tinum iyo taga-em tiinan-bii kupkalip e, ");
INSERT INTO tlf_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","alugum iyo kulu unan-bii tii kelip ko. Kale kota okumop man iyo iman atuk umi tukup tukup ke-bilip uyo afeta-bii ko basket tuluun kal abulip dongenu ko. ");
INSERT INTO tlf_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kale tinum ilimi kup faiv tausen (5,000) e minte ilimi kalelal so man so iyo kwego dego ke-nilipta, iman boyo unelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kale Yesus ilami okumop man iyo bogobe-nala e, “Nugumal ibaa. Ipsiik tam bot tem ton-nilip koyo kupkaa yak Galili Ok Muk umi milii uyo unipta minte, nita unang tinum kalip iyo imdali unipta o,” agela ninggil unip e, ");
INSERT INTO tlf_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","yagal bom-nala e, unang tinum iyo imdala daagina tala kelip e, yagal ilasinon, God imi beten ke-eman o age-nalata, daage tam amdu tigiin kal beten ke-bom bom-bala bii, kwiinu ko. ");
INSERT INTO tlf_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tam am kwiinu e, bot uyo unanbu yak ok mat iip unu e, kota dulul maak mitam fomtuup fuun-bulu e, ok uyo kwiin figiliit figilaak ke-bom-nulu e, bot uyo kwaalu unbu talbu ke-buluta, bii ");
INSERT INTO tlf_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","bem unu e, kota Yesus iyo okumop man imi finang uyo ok daang kun diim ilep mo mo kem tal-bala e, ");
INSERT INTO tlf_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ilami okumop man iyo Yesus iyo atamipta e, bot binim ok daang kun diim ilep talan-be kalaa age atam kumang mo finano fomtuup ol-bom-nilip e, “Beyo begel o,” agan-kalip kalaa age-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesus iyo maak fagaa bogobe-nala e, “Nugumal ibaa. Niyo nagal kale, ibo finanin ba kale, kupkaa deng tebemin o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","kota Fita iyo bogobela, “Kamogim kabaa. Kabo kapkal umdii, niyo bogopnelapta, ok daang kun diim ilep kapmi finang no tolon o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesus isiik bogobe-nala e, “Talaal o,” agela e, Fita iyo bot tem uyo kupka-nala e, daak ok daang kun diim ilep Yesus imi finang unan-be kuta, ");
INSERT INTO tlf_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","dulul sino ok sino uta utam-nala e, bomi atul uta finano-nala e, kota uukmat mo ok tem iinon o angbi kalaa age-nalata, Yesus iyo olabe-nala e, “Kamogim kabaa. Dong dogopnelapta, waalanan o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","kota Yesus iyo tebe-nala e, maak fagaa imi sagaal uyo kwep yak Fita iyo aafu-nala e, bogobela, “Kabo, intaben o age-nalapta, kapmi aget fugunin uyo, ‘Yesus beyo bagang-kale dong dogop-naman-tema bele, dogop-naman-temaala o?’ age-nalapta, finan-balap a? Kanupmin aget boyo fugunin ba kale, kabo utamapta e, beyo tii kalaa nagan-kalin o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Agela e, alop tam bot tem tonip e, kota dulul uyo binimanu ko. ");
INSERT INTO tlf_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kale okumop man bot tem tonbip iyo utam-nilip e, Yesus imi deng uyo tebe-bom-nilip e, bogolip, “Fen dam kale, kabo God imi Man aligaap o,” agelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kale kota ok muk mat iip uyo kupkaa yak abiip Genesaret umi mep so ok kan tem ko yak abelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kale abiip kasel iyo atamipta e, beyo Yesus ita kalaa age-nilip e, weng kwaalip yak abiip maak maak kelu e, iyo unang tinum mafak umkan unsip iyo Yesus imi finang kulep tal-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Yesus imi fomtuup daga-nilip e, “Kamogim kabaa. Kabo imkalapta, igil kapmi ilim magaang uta kup melepmipta, telela imolap tambalanan-temip o,” agelip e, Yesus iyo, “O,” agelata, unang tinum waantap ita yak Yesus imi ilim magaang melepmip iyo tambalanamip ko. ");
INSERT INTO tlf_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kale kota Falosi sino ulo utamsip tinum sino iyo Jerusalam kutam ilota tal Yesus imi daga-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kabaa. Sugayok uyo numi olal iyo bogo-nilip, ‘Iman unelan o agelap uyo, sagaal uyo tele suuba-nalapta o,’ agesip kale, amalabal iyo suun kup ilimi man iyo kafalemin kup kem-nuubip kale, nuyo kanupmin kuguup uyo waafulup albu kuta, kapmi okumop man iyo, intaben o ageta numi olal imi kuguup uyo kwaasule-bom-nilipta, imi sagaal uyo tele suubamin binim ke-bomta iman uyo unan-nuubip o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesus isiik bogobe-nala e, “Minte ipde a? Intaben o age-nilipta, ilipmi olal imi weng kem kwep daabesip uta kup tinangka-bom-nilipta minte, God imi weng kem uta kwaasulem-nuubip a? ");
INSERT INTO tlf_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","God iyo bogo-nala, ‘Kapmi kaalap sino kogen sino iyo tele tiin mo-nalap e minte, imi weng uyo tinangka-bom dong daga-e-bom no ke-bom-nalapta o,’ age-nala e minte, ‘Waantap ita imi aalap so ogen sino bilip iyo weng mafak baga-ema umdii, angkolip kaanamin o,’ age no kesa ko. ");
INSERT INTO tlf_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kuta ipkil ilipmi weng migik maak bogo-nilip e, ‘Kanube tinum iyo, mani albu uyo God imi kobelan o age-nalata, aalap sino ogen sino iyo bogobe-nala, “Nimi mani waafubi uyo God imi kobelan-temi o agebi kale, uyo asok ulaa ku-nilita, agam ibo tele tiin mo dong daga-eman-temaali o,” agela umdii, ");
INSERT INTO tlf_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","bemi aalap sino ogen sino tiin molan-temaala boyo felepman-temu o,’ agan-nuubip ko. Kale boyo fen ilipmi weng kem bota kup kam agan-bom-nilipta, God imi weng kem uyo kwaasulem-nuubip kuba. ");
INSERT INTO tlf_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ibo bisop weng alop bagamin tinum kale, sugayok uyo God imi profet Aisaya iyo ipmi kuguup sang uyo God imi suuk kon tem uyo dola ko bogo-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘God iyo bogo-nala, “Kanupmin unang tinum kalip iyo bisop nimi tok uta bagan-nuubip kale minte, nimi aget uyo kopne meng nimi miit tem uyo talaalup o age-nilipta, yang simanim kal nuubip kale, ");
INSERT INTO tlf_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","bilip iyo ilimi weng kem uyo unang tinum iyo kafale-bom bogobe-nilip e, ‘Koyo God imi weng kem kwep daasa kale, waafu-bom-nilipta o,’ agan-nuubip kuta, niyo imi bisop bogo tok bagamup ko agan-nuubip boyo tinangkulan-temaali o,” age God iyo kam agesa o,’ age Aisaya iyo dola kosa o,” age Yesus iyo bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kale Yesus iyo unang tinum iyo olabela tal tamip bogobe-nala e, “Niyo sagaal umi ninak tonamin umi sang uta bogobelan-temaali kale, mufekmufek umi tebe ipmi iibak tem fen atin kufak daga-emin umi sang uta bogobelan-temi kale, tinangku-nilip e, tele utamin o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","God imi tiin diim uyo tinum iyo tebe-nala sagaal ninak tonin tuup min, mufekmufek, ‘Amem o,’ agesip min uyo unela daak imi mat tem unon-temu uyo, boyo tebe tele dufak daalan-temaalu kuta minte, tinum tebe-nala aget mafak fugun-bom weng mafak baga-eman-tema uyo, bota tebe-nuluta, dufak daalan-temu o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Aaltam kota Yesus imi okumop man iyo tal bogobe-nilip e, “Kamogim kabaa. Kapmi weng ko bogobelap boyo Falosi iyo tinangku-nilipta, aget figiit mo olsak tebepmu kale, kabo bo utabap bele ki?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","kota Yesus iyo do weng katip maak bogobela ko. “Unang tinum iyo mufekmufek nimi Aatum abiil tigiin kayaak imi ilanggiip albu ulutap kale minte, mufekmufek san iip maak maak boyo yagal ula tebelu e minte, al bota ugol tebelu no kesu kale, iyo tebe-nalata, al uyo foga kulula unon-temu kale, kamogal bilip iyo al kulutap kesip kale, ");
INSERT INTO tlf_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","bilip imi weng uyo tinangkamin ba ko. Kale mungkup kamogal bilip iyo tiin tugul ilitap kale, tam tinum tiin tugul iyo maak tebe ipkum tiin tugul maak imi ilep uyo kafalepma umdii, boyo alop maagup faala kulep kafin tem unon-temip (ko. Ulutap kale, Falosi iyo ilep no God imi abiip unemin uyo utamsaalip kale, bilip iyo dogobeta unang tinum kek kek iyo God imi ilep boyo kafalepman-temaalip) o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kale Fita iyo Yesus imi bogobela ko. “Kamogim kabaa. Mufekmufek, ‘Amem o,’ agelip unan-kalin umi do weng bomi magam uyo bogobelal o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesus isiik bogobe-nala e, “Kamogal bilip iyo bam daalin-tem kale, ipkil mungkup bam daalin-tem aga? ");
INSERT INTO tlf_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ibo nimi weng umi magam boyo tele utamin-tem kelip umdii, nimi weng kaa bogolan-temi koyo tele tinangku-bom-silipta o ageta ko. Tam tinum iyo mufekmufek unelan-tema uyo, daak mat tem kugol siit ilugoluta, no imaan fogolan-tema kota, daak iinom binimanan-temu kale, bota tebe bemi aget tem uyo kufak daabelan-temaalu kale minte, ");
INSERT INTO tlf_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","tam tinum iyo aget mafak suun kup fugunan-tema uyo, kota weng mafak bagaman-tema kale, ilami aget mafak fugunan-tema bota tebe tinum beyo dufak daalan-temu ko. ");
INSERT INTO tlf_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Minte tam tinum iyo kuguup mafak uyo kanubelin-tem som, aget mafak usiik fuguno-nalata, aaltam yangta kuguup mafak uyo kanupman-tema ko. Kale kuguup mafak kanupman o agelan-tema uyo, kota ipkum angkola kaanamin min, sa dagamin min, sa daga-bom ipkum dupkeng dagamin min, yuguut unan-kalin min, ipkum imi fenga kolin-tem bom-bala no bisop bogo kiyap imi baga-emin min, ipkum imi umik tem weng baga-emin min uyo keman-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kale kanupmin aget mafak bota tebe-nuluta, tinum iyo fen dufak dagan-nuubu kale, God iyo kanupmin tinum bemi deng uyo taban-nuubaala kale minte, tinum maak iyo olal imi kuguup uyo waafu-nala kamaki uyo sagaal suuba-nala iman unelan-temaala uyo, bota tebe God imi tiin diim uyo maak dufak daalan-temaalu o,” age-nalata, Yesus imi okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kale Yesus ninggil iyo Juda kasel imi kafin uyo kupkaa daage asit kek kek imi kafin unip kale, asit kek kek bilip imi abiip miton alop umi win uyo Taya e minte Saidon no ko. ");
INSERT INTO tlf_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kale unang tinum kugol nin bilip iyo Juda kasel ba kale, bilip iyo Kenan kasel ita kale, bomi unang maak tal Yesus imi ole-bom bogobe-nulu e, “Kamogim kabaa. Kabo King Devit imi man ilop kale, ni-filin daa-nalapta, kapmi titil boyo ku-nalap dong dogopne o ageta ko. Nimi man unang uyo sinik mafak tebe kufak daaluta, atin ki ogen utaman-nuubu kale, sinik mafak boyo fot tebelap yak iinuta, man boyo tambalanuk o,” agelu kuta minte, ");
INSERT INTO tlf_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yesus iyo unang bomi weng umaak yan kepmin-tem kela e, ilami okumop man iyo tal Yesus iyo fomtuup bogobe-nilip e, “Kamogim kabaa. Unang boyo numi umik tem talan-bom-nulu fomtuup olan-bo kale, boyo fot tebe kwaalap unuk o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","kota Yesus iyo bilip imi weng uyo yan kebela, “God iyo asit kek kek unang tinum mungkup unang kaa kanum talan-bo kalutap imi dong daga-emal o age-nalata, nimdala tisaali kale, God iyo utamata, Israel kasel bilip iyo sipsip imi ilum ilum ke-bom maagalo kesip ilitap kalaa age-nalata, ‘Bilip ita dong daga-emal o ageta nimdala ti-sii o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","unang uyo tinangku-nulu e, beten kemin ulumi kuguup uta ku katuun duung fegela daak ton-nulu e, bogolu, “Kamogim kabaa. Dong dogopne o,” agelu ko. ");
INSERT INTO tlf_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kale (Juda kasel iyo asit kek kek unang tinum imi win uyo bogobe-nilip e, “Kayaam o,” agan-bom-nilip e minte, ilimi unang tinum ita minte, “Man o,” agan-bom no kem-nuubip kale, Yesus imi aget fugunin uyo, unang bomi aget fugunin uyo, kup-kugulita, Yesus beyo tii kanube-nama o agan-bo bele, beyo kanubelan-temaala o agan-bo kalaa age utaman o age-nalata,) do weng maak bogobe-nala e, “Man kangkang imi iman uyo dugu kulep no kayaam imi kobelan-temip boyo felepman-temaalu (kale, mungkup ulutap kupmi dong dogopkelan-temi boyo felepnelan-temaalu) o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","unang usiik bemi weng uyo yan kebe-nulu e, bogobelu, “Kamogim kabaa. Boyo dam bogolap kuta, man imi iman unan-bilip buul segela daak tebol umi afak tem abelan-temu uyo, felepmuta, kayaam tebol afak tem albip iyo tebe unelan-temip kale, ulutap mungkup kabo dong dogopnelan-temap boyo felep-kaman-temu o,” agelu e, ");
INSERT INTO tlf_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesus isiik bogobe-nala e, “Kubaa. Tambaliim kale, kubo nitamapta e, beyo tii dong dogopnelan-tema kalaa nagelap kale, kupmi bogopne-nalap, ‘Dong dogopne o,’ agan-balap uyo, dong dogop-kaman-temi o,” age weng uta kup bagam-salata, maak fagaa umi man unang uyo tambalanu ko. ");
INSERT INTO tlf_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kale Yesus ninggil iyo Taya so Saidon so kasel imi kafin boyo kupka-nilip e, asok daage unanbu no Galili Ok Muk umi kan tem ilep ku-tele daage tam tam tam amdu tigiin maak kugol ton-bom-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","tam tinum kwiin tagang iyo ipkumal ibitansip sino sagaal ugum sino tiin tugul sino weng kabam sino minte mafak ilik migik umkan unsip sino iyo kulep tal Yesus imi miit tem to-bilipta, Yesus iyo alugum telela imkama ko. ");
INSERT INTO tlf_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kale unang tinum iyo utamipta e, tinum ibiit iyo mo tiine-bala, sagaal ugum iyo tambalana-bala, tiin tugul imi tiin uyo tambalanebelu mufekmufek uyo utama-bala e minte, weng kabam iyo weng baga-bala no ke-bilip kalaa age unang tinum iyo utam kumang mo-nilipta, Israel kasel numi God imi win uyo kufu-emum o age-nilipta, deng tebemip ko. ");
INSERT INTO tlf_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kale Yesus iyo utamata e, unang tinum kwiin tagang iyo albip kalaa age-nala e, ilami okumop man iyo olabela no tamip bogobe-nala e, “Unang tinum kalip imi nisino bii am asuno kelip koyo, imi iman uyo binimanepmu bisop albip kalaa ageta niyo i-filin-bii kuta, niyo iman tep imdali abiip unon-temip uyo, abe-bom-nilip e, iman tep iip kal du molan-temip kale, bisop uyo imdali unon-temaalip o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","minte okumop man isiik Yesus iyo daga-nilip e, “Unang tinum kalip iyo kwiin tagang kale, iibaan bagan koyo dogap-tele iman uyo kulu-nulupta, alugum ifelup une tii kelan-temip o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","minte Yesus isiik ninggil imi daga-nala e, “Ibo bret uyo intap kal kulep talbip o?” agela e, Yesus imi weng uyo yan kepmip ko. “Nuyo bret ban kal e minte aniing kangkang iip maak maak no ita kup o,” agelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kale kota Yesus iyo unang tinum iyo bogobela daak kafin diim tonip e, ");
INSERT INTO tlf_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","bret ban kal sino aniing sino uyo kulu-nala e, God imi, “Misam o,” age-nala e, bret so aniing sino uyo fegela ko-nala e, kulu imi okumop man imi kobelata, ita tebe-nilip e, kulu unang tinum togobelip ");
INSERT INTO tlf_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","unan-bii-nilip e, tii kelip ko. Kale okumop man iyo tebe-nilip e, iman tukup tukup ke-bilip uyo afeta-bii basket ban kal abulip dongenu ko. ");
INSERT INTO tlf_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kale tinum ilimi kup foa tausen (4,000) e minte ilimi kalelal so man sino iyo kwego dego ke-nilipta, iman boyo unelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kale Yesus iyo unang tinum iyo imdala abiip iinip e, Yesus ninggil iyo amdu tigiin uyo kupkaa malaak abe te tam bot tem ton-nilip e, unanbu no abiip Magadan umi kafin mep so ku unip ko. ");
INSERT INTO tlf_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Tam Falosi sino Sadusi sino iyo, utamupta, fen God yagal Yesus beyo daala ti-se kalaa agelum o age-nilipta, tal Yesus iyo dup-kugu-bom daga-nilip e, “Kabaa. Nuyo mirakel ko age kuguup ugulumi migik umaak kafalebelapta, nuyo utamupta, God yagal kamdala ti-salap kalaa agelum o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesus isiik imi weng uyo yan kebe-nala e, bogola, “Tam atanim uyo tem iinu utamipta, am isak talalu kalaa agelan-temip uyo, ibo bogo-nilip e, ‘Atanim tem iinu am isak talalu kale, amsap uyo am tambal bon-temu o,’ agan-bom-nilip e minte, ");
INSERT INTO tlf_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","kutim uyo utamipta, abiil uyo miliil molu kalaa agelan-temip uyo, ibo bogo-nilip e, ‘Am isak talalu kuta, am uyo miliil molu kale, wep uyo kota tolon-temu o,’ agan-bom no kem-nuubip ko. Kale abiil umi utaman-temip uyo, utamipta e, am uyo kanupman-temu kalaa agan-nuubip kuta, ibo nimi kuguup ko kanu-bii boyo maak tele utamta, God yagal tebe dong daga-e-balata, kanu-be kalaa naganbaalip ko. ");
INSERT INTO tlf_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ibo God imi weng uyo tinangkanbaalip kale, ibo aget mafak fugun-bilip kale, ibo bogopne-nilip e, ‘Mirakel ko age kuguup ugulumi migik umaak kafalebelapta, nuyo utamupta, fen God yagal kamdala ti-salap kalaa agelum o,’ agan-bilip kuta, kanupmin kuguup boyo maak kanupman-temaali kale ki, maagup maak uta kup kafalepman-temi boyo Jona imi kanube-nala top aniing kwiin kiim umi mat tem kugol bii, am alop ke-nala am asuno diim komi mitam e tisa ulutap uta maak kafalepman-temi o,” age Yesus iyo kam age-nala e, imkaa daagina ko. ");
INSERT INTO tlf_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kale Yesus sino ilami okumop man sino iyo bot tem ilep daage yak ok muk milii yak-nilip e, Yesus imi okumop man iyo aget fugunolipta e, numi bret uyo ilumano kutu tulup kalaa age kumang molip ko. ");
INSERT INTO tlf_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Kale Yesus iyo do weng maak bogobe-nala e, “Nugumal ibaa. Ibo Falosi sino Sadusi sino imi yiis ko age tukolip bret fitimin umi mufekmufek uyo tele utama-bom kupkek kupkek kem tiine-bom-nilipta o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kale okumop man iyo Yesus imi weng bomi magam uyo utamin-tem ke-nilip e, bole ninggil igil en-bom-nilip e, bogolip, “Nuyo bret umaak kulep tilin-tem kelup kalaa age-nalata, yiis umi sang boyo bagan-be bele o?” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kale Yesus iyo ilami okumop man imi weng bagan-bilip boyo utam-nala e, bogobela, “Ibo intaben o age-nilipta, ‘Bret umaak kulep tilin-tem o,’ age-nilipta, aget uyo suun kup fugun-bilip a? Ibo utamta, beyo tii nuyo tiin molan-temaala aga o nage-nilipta, aget yamyam uyo fugun-bilip a? ");
INSERT INTO tlf_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","10","Di ipkil utamin. Siin uyo ibo nita-bom-bilipta, bret ogal maak kulu tinum ilimi kup faiv tausen (5,000) kalip imi fegela ko ifeli un-bom-nilip tukup tukup kemsip umi iman atuk atuk uyo basket intap kal abu-silip a? Asok aaltam uyo ibo nita-bilip, bret ban kal uyo kulu tinum ilimi kup foa tausen (4,000) kalip imi fegela ko ifeli un-bom-nilip tukup tukup kemsip umi iman atuk atuk uyo basket intap kal abu-silip a? Kanubeli utam-silip boyo, intaben o age-nilipta, nimi titil boyo tele utamin-tem ke-silipta, aget yamyam fugun-bilip a? ");
INSERT INTO tlf_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ibo utamipta e, beyo aafen yiis ko age bret fitimin umi mufekmufek umi sang baganbaala kale minte, Falosi sino Sadusi sino imi weng mafak mafak ko age yiis uta tebe ipmi ifak dagamin umi sang uta bagan-be kalaa nagelin o agan-bii o,” age Yesus iyo kam agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kam agelata, Yesus imi okumop man iyo utamipta e, Yesus iyo bogobe-nala, “Bret fitimin umi mufekmufek uyo kupkek kupkek ke-bom-nilipta o,” aganbaala binim kale, imi bagan-be uyo, “Falosi sino Sadusi sino imi kuguup mafak kafalem-nuubip boyo kupkek kupkek ke-bomta o,” age-nalata, bomi sang uta bagan-be kalaa agelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kale kota Yesus sino ilami okumop man sino iyo daage no abiip maak Sisaria Filipai umi mep so unom-nilip e, Yesus iyo ilami okumop man imi daga-nala e, “Unang tinum iyo Mo Tibil imi Man nimi sang uyo bogo-nilipta, ‘Beyo waanta o?’ nagan-bilip o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","minte okumop man isiik Yesus imi weng yan kebe-nilip e, bogobelip, “Unang tinum iip maak maak iyo bogo-nilip e, ‘Beyo ok sam uga-emin tinum Jon Baptis ita o,’ kagan-bala, minte iip maak maak iyo bogo-nilip e, ‘Beyo God imi profet ko age weng kem baga-emin tinum sugayok bii-se Elaija ita o,’ kagan-bala, minte iip maak maak iyo bogo-nilip e, ‘Beyo God imi profet sugayok bii-se maak Jeremaya ita o,’ kagan-bala, minte iip maak maak ita bogo-nilip e, ‘Beyo God imi profet sugayok bii-se migik maak o,’ kagan-bala no kem-nak-bilip o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesus iyo bogola, “Minte ipde a? Ibo, ‘Beyo waanta o?’ nagan-bilip o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","tam Saimon Fita ita Yesus imi weng uyo yan kebe-nala e, “Kabo God imi ulaa kamdula kamok kesap tinum Krais e minte, suun kup nin tinum God ilami Man aligaap no o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","kota Yesus iyo Fita imi bogobe-nala e, “Asegim Jon imi man Saimon kabo dam bogolap kale, kafin diim komi tinum iyo maak dam weng koyo bogopkebaala kale minte, suguul ke nimi Aatum abiil tigiin kayaak yagal tol bogopkelata, utam-nalapta, boyo bogolap ko. ");
INSERT INTO tlf_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kale kota weng maak bogopkelan o ageta kale, niyo tebe telela kamoli kabo tuum dalan ulutap titil kup tebelap kamkalan-temi kale, kota kapmi win migik maak uyo Fita o ageli kale, Fita o ageli bomi magam uyo tuum dalan o kageli kale, nimi ogok keman-temap uyo, asok nalami titil uta ku-nilita, unang tinum kwiin tagang iyo kulep meng nalami miit tem tolita, tebe nimi unang tinum ke-nilipta, igil tuum dalan ulutap titil kup tebelip imkalan-temi kale, alugum sinik mafak iyo tebe-nilipta, imdaak tamalip kaan maagalo kelan-temaalip kale, suun kup nan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nimi titil kopkelan-temi uyo, kabo tii unang tinum iyo weng baga-e-balapta, mitam God imi daam tem uyo mitam tolon-temip ko. Kale kabo utamapta, kuguup uyo mafak kalaa age-nalap God imi unang tinum iyo bogobe-nalap, ‘Boyo kanumin ba o,’ agelan-temap uyo, God abiil tigiin kayaak yagal mungkup bogobe-nala e, ‘Boyo kanumin ba o,’ agelan-tema ko. Ulutap kale, kabo utamapta e, kuguup uyo tambal kalaa age-nalap God imi unang tinum iyo bogobe-nalap, ‘Boyo kanumin o,’ agelan-temap uyo, God abiil tigiin kayaak yagal mungkup bogobe-nala e, ‘Boyo kanumin o,’ agelan-tema o,” age Yesus iyo Fita imi bogobe-nala e minte, ");
INSERT INTO tlf_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","alugum ilami okumop man iyo bogobe-nala e, “Ibaa. Ibo tinum migik iyo bogobe-nilip, ‘Yesus beta God imi ulaa dula kamok kesa tinum Krais o,’ agan-kalin ba o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kale am ko daan bom-sulu kota ki, Yesus iyo tebe weng uyo kufo ilami okumop man imi kem bogobe-nala e, “Son-temu uyo, niyo no abiip miton Jerusalam kutam iinita, Juda kasel imi kamogal sino tinum amem ko age pris imi kamogimal sino minte ulo utamsip tinum sino ita tebe-nilipta, niyo kuguup mafak mafak kupkane-bom-nilipta, nimdalip yak waasi imi sagaal diim abelita, nangkolip kaani namalip bii, am alop kelita, am asuno diim kota God iyo nifola asok fenan-temi o,” age yakyak kema ko. ");
INSERT INTO tlf_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kale kota Fita iyo ilasinon dep yang kweng kal yege-bom bogobe-nala e, “Kamogim kabaa. Kabo kanupmin aget boyo fugun-bom bagamin ba ko. God iyo boyo kupkala mek kapmi diim uyo abelan-temaalu o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesus iyo fupkela katam fen Fita iyo tele atama-bom an-togon-bom-nala e, “Kabo God imi aget fugun-be ulutap uta fugunbaalap binim kale minte, kafin diim komi tinum imi aget fugun-bilip ulutap uta fugun-balap kale, kabo tuum ilep kal bom-bulu tinum yang bomi diim yaan kwek mo bimbeng daa kumen daak aban-nuubip umi tuum ulutap ke-bom kabo nimi ilep uyo ugaa kwaapnelan o age-nalapta, kam agelap kale, kabo nimi waasi Saatan imi kuguup ulutap uta kupkane-balap kale, kupkalal o,” age-nala e minte, ");
INSERT INTO tlf_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","fupkela kek fen alugum okumop man iyo bogobe-nala e, “Tinum dogap kapta, niso no nimi ogok uta keneman o agelap umdii, yak kalapmi aget fugunin uta kup kanumin boyo kupka-nalapta, nimi ilak uta fom duga-bom-nalap e, nimi at diim kaal fuyap kulan-temi kulutap ke, ‘Kaan-nimi bole, kanube kaan-nimi o,’ agan-bom-nalapta, kanupmin kuguup uta ku-nalapta, te tamta nimi ogok uyo waafuu kwep tebe-balapta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kale tinum iyo dogap ita ilami kaal ilak kup suun duga-bom, ilami aget fugunin uta kup kanum tiineman o agan-kala umdii, beta kaan-nalata, maagalo kelan-tema kale minte, tinum iyo dogap ita, ‘Meng kanu-bili waasi iyo tebe nangko-nimip kuta, nangko-nimip o,’ age-nala meng nimi ilak kup duga-bom nimi kuguup uta fomtuup waafuu kwep taba umdii, beta suun kup nan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Minte tinum iyo maak kafin kaa kutufosu komi mufekmufek uta alugum kwaa-bom-nala minte, suun kup nin umi ilep umaak temin binim ke-bom no kema umdii, ilami mufekmufek kwiin tagang ko kwan-be bota tebe dong dogopman-temu bele ki? Umbae. Boyo dong dogopman-temaalu kuba. Iyo mufekmufek tambal kup tebesu umaak God imi kopmata, God iyo bogobe-nala, ‘Kabo suun kup nan-temap o,’ agelan-tema bele ki? Umbae. Suun kup nin boyo tisol umi ku mo kugamin umi mufekmufek ba kuba. ");
INSERT INTO tlf_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Son-temu uyo, Mo Tibil imi Man niyo nalami Aatum imi titil uyo ku kamok kesa ilatap keli ensel tambal iso tolon-temup uyo, tal-nilita, alugum unang tinum maagup maagup imi intap intap kuguup kanum unsip uyo yan kebelan-temi ko. ");
INSERT INTO tlf_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kale tuluun weng kaa bogobelan-temi koyo tele tolong do-silipta. Iip maak maak ibo kaanin-tem somta, utamipta e, Mo Tibil imi Man iyo titil ku-nalata, kamok king ke-nalata, tal ilami unang tinum tiin mola kalaa agelan-temip o,” age Yesus iyo ilami okumop man iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kale am bugup kal koyo te top iinu e, kota Yesus iyo tebe-nala e, Fita sino Jems sino Jems ilami niing Jon so asuno ita kup imtamo yak abe tam amdu tigiin timitim maak tam unip ko. ");
INSERT INTO tlf_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kale ninggil tam-nilip e, tinum asuno bilip iyo Yesus iyo atamipta e, mitam yagalami migik ke-nala e, imi tibit kun uyo ataan kefo tiin bulusii so kebu ulutap kelu e minte, imi ilim uyo iip namaal ulutap ke no kelu kalaa age-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","utamipta, tinum alop maak sugayok bii-silip Moses sino Elaija sino iyo asok abiil tigiin uyo kupkaa malaak tamip Yesus so weng bagan-bilip kalaa age itamip ko. ");
INSERT INTO tlf_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kale Fita iyo itam-nala e, weng uyo amon amon ke-bom Yesus imi bogobe-nala e, “Kamogim kabaa. Suguul ke kapsino tal kagal albup kale, kabo, am mafak asuno maak delal o agan-balap aga? Agan-balap kalaa ageta maak boyo kapmi, maak boyo Moses imi, minte maak bota Elaija imi no ke deebelita o,” agan-kala e bole, ");
INSERT INTO tlf_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","iip dong kup tebesu maak malaak abuta, ninggil iyo de imalu e, iip tem kutam-tele weng maak bogo-nala e, “Ibaa. Beyo nimi Man bubul kale, niyo imi deng kup taban-bii kale, bemi weng uta kup tinangka-bom-nilipta o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kale okumop man iyo weng boyo tolong do fomtuup finano-nilip e, katuun duung fegela-nilip e, tibit kun uyo kulep daak kafin melepmip e, ");
INSERT INTO tlf_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesus iyo tal melebe-nala e, bogobela, “Ibo finanin ba kale, fenin o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","fen mitamta kek fenipta e, Yesus ita kup alba kalaa age atamip ko. ");
INSERT INTO tlf_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kale kota Yesus ninggil iyo amdu tigiin uyo kupkaa tal-bom-nilip e, Yesus iyo ilami okumop man ninggil asuno iyo weng uyo fomtuup bogobe-nala e, “Nugumal ibaa. Tinangku-silipta. Ibo no tinum kek kek imi diim uyo ko kanubelu utamip bomi sang uyo bagamin ba kale, kupkaa bom-bilip bii, Mo Tibil imi Man niyo kaani nimdep no namalip bii, God tebe nifola asok fen tigi moli kalaa age-nilipta, kota unang tinum kek kek iyo baga-eman-temip bota felepman-temu o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","tam okumop man iyo weng migik maak Yesus imi daga-nilip e, “Ulo utamsip tinum iyo intaben o age-nilipta, bogo-nilip kano, ‘God imi profet ko age weng kem baga-emin tinum Elaija sugayok bii kaansa isiik talata minte, God imi ulaa dula kamok kesa tinum ita aaltam tolon-tema o,’ agan-nuubip o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesus isiik imi weng uyo yan kebe-nala e, “Boyo dam bagan-nuubip kale, Elaija isiik bon tem tal-nalata, kanupmin ogok kota keman-tema ko. Tal unang tinum iyo dong dogobelata, imi aget tem uyo telelam-silipta, God imi ulaa dula kamok kesa tinum iyo aaltam tolon-tema kale minte, ");
INSERT INTO tlf_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","tam weng maak uyo bogopman-temi ko. Elaija iyo ti-se kuta, tinum iyo utamipta e, beta kalaa agesaalip kale, ilimi aget uta kup fuguno-nilipta, angkolip kaan-se ko. Ulutap kale, unang tinum iyo tebe-nilipta, Mo Tibil imi Man nagal mungkup kuguup mafak uyo kopnelan-temip o,” age bogobe no kela e, ");
INSERT INTO tlf_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","kota okumop man iyo utamipta e, Yesus iyo fen Elaija imi sang uta baganbaala kale minte, ok sam uga-emin tinum Jon Baptis imi sang uta bagan-be kalaa agelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kale Yesus sino Fita sino Jems so Jon sino ninggil iyo malaak amdu tigiin afak tem malaak abomu e, unang tinum kwiin tagang iyo afeta-nilip e, Yesus imi fen-bilip kalaa age tal tamip e, tinum maak Yesus imi finang tal katuun duung fegela daak ton-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","bogola ko. “Kamogim kabaa. Nimi man iyo du-filin daa-nalap dong dogobe a. Beyo malap miin daam kesa kale, bagaa daala kumen at tiil iine-bom-nala e minte, ok tem iine-bom no ke ke ke-bom-nalata, kaal fuyap kup utaman-nuuba kalaa age-nilita, ");
INSERT INTO tlf_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","kapmi okumop man ita telela dolin o age-nilita, dep tal daalita, iyo dogobeta bagang-kale telela do-nimip binim kebip o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesus iyo ilami okumop man sino unang tinum albip iso imi bogobe-nala e, “Kwiin ee. Ipmi aget fugunin uyo fen atin tol ba kale, niyo ipsino bii, kayop kwiin tagang te yang iinu kuta, ibo nitamipta e, beyo God imi titil uta ku-nalata, unang tinum mafak ilin umkan unsip iyo telela imkan-nuuba kalaa naganbaalip ko. Niyo ipsino bii, am intap kal kelita, ibo nitamipta, beyo tii God imi titil boyo nugol mungkup kobe-nama kalaa nagelan-temip a? Niyo ipmi aget mafak fugun-bilip boyo daal tebepnebu kale, man tinum iyo dep tilin o,” agela e bole, ");
INSERT INTO tlf_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","man tinum iyo dep tal daalip e, Yesus iyo fomtuup sinik mafak imi bogobela e, kota man iyo dupkaa yak iinem-sala e, kota man iyo maak fagaa tambalana ko. ");
INSERT INTO tlf_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kale aaltam kota okumop man ninggil iyo utamipta, unang tinum iyo alugum daaginip kalaa age-nilipta, tal Yesus iyo bogobe-nilip e, “Dogobeta nuyo bagang-kale sinik mafak beyo fot tebelup yak iinin-tem keba o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesus iyo bogobela, “Ibo fen nitamipta, beyo tii God imi titil uyo nuyo kobe-nama kalaa naganbaalip utamta, ibo ko bagang-kale-nilipta, fot tebelip yak iinin-tem keba kale, nimi weng kaa bogobelan-temi koyo tele tinangku-silipta. Tinum iyo tebe mastat umi san katip dolan-tema uyo, tebe-nulu e, mitam kwiin kiim kelan-temu kale, ulutap mungkup, kabo mufekmufek katip umi aget umaak fuguno-nalap, God iyo tii dong dogopnela kanubelan-temi kalaa agelan-temap uyo, iyo dong dogopkelata, kapmi aget fugunin tambal uyo senganan-temu kale, bii mufekmufek kiim mitam tolon-temu uyo, God imi dagalapta, ita dong dogopkelata, kanubelan-temap ko. Minte kabo God imi win kufo amdu umaak bogobe-nalap, ‘Amdu kubo kulupmi baan diim mosap boyo kupkaa unanbu no anang migik kugol molal o,’ agelan-temap uyo, kanubelan-temu ko. Intap intap kuguup uyo God imi, ‘O,’ agelan-tema uyo, kabo bagang-kale kanubelan-temap ko. ");
INSERT INTO tlf_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kale sinik mafak imi fot tebelan o agelan-temap uyo, kamaki uyo iman fala-bom God imi beten ke-eman-temap uta, sinik mafak iyo yak iinon-temip kale minte, bomi kanumin binim keman-temap uyo, sinik mafak iyo yak iinon-temaalip o,” age baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kale Yesus imi okumop man ninggil iyo alugum no Provins Galili kutam kal afetalip e, Yesus iyo bogobe-nala e, “Ibaa. Mep so kota tinum maak tebe-nilip Mo Tibil imi Man niyo nimdalip yak waasi imi sagaal diim abelita, ");
INSERT INTO tlf_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nangkalip kaanita, nimdep no namalip bii, am alop ke-nilita, am asuno diim kota asok fen tigi molan-temi o,” agelata, imi okumop man iyo tinangku-nilipta, atin aget iluum tebemip ko. ");
INSERT INTO tlf_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kale Yesus sino ilami okumop man sino ninggil iyo no abiip Kapeneam tamip e, tam ulotu am miton umi takis mani kwaamin tinum iyo tal Fita imi dagalip ko. “Kapmi kafalemin tinum iyo ulotu am miton telelamin umi takis mani uyo saan-nuuba bele ki?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Fita iyo tele aget fugunolin-tem ke-nala e, imi weng uyo yan kebe-nala e, “Aa. Beyo saan-nuuba o,” age kupkaa siit-nala e, daage tam am unom bomi sang umaak bogolin-tem ke-bom-salata, Yesus iyo tebe Fita iyo daga-nala e, bogola ko. “Saimon kabaa. Waantap ita takis mani uyo kafin diim komi kamok king imi kobe saan-nuubip a? Fen ilami man ita saan-nuubip bele ki, kek kek ita kup saan-nuubip a? Kapmi aget fugunin ule o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Fita iyo yan kebe-nala e, “Kek kek ita saan-nuubip o,” agela e, Yesus iyo bogobela, “Dam bogolap kale, ulotu am miton uyo nalami Aatum imi am kale, ulo uyo nimi bogopne-nulu kano, ‘Man kabo takis mani uyo saanal o,’ agesaalu kuta, ");
INSERT INTO tlf_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","tinum bilip iyo utamipta e, beyo God imi Man kalaa nagesaalip kale, niyo takis mani bomi molin-tem kelan-temi uyo, iyo, ‘Beyo kuguup mafak ke-be o,’ nagelan-temip tap kale, kabo no ok muk kugol aniing dii-bom-nalapta, kamaki umi ungkwalan-temap uyo ku-nalapta, umi bon tem kutop uyo utamapta e, tuumon kiim uyo albu kalaa agelan-temap kale, boyo tii kale, kwep no kapsino e minte nisino alop numi takis mani uyo tinum bilip imi kobe molal o,” age bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kale Yesus sino Fita sino alop iyo weng bagam-silipta, okumop man iyo tal Yesus imi bogobe-nilip e, “Kamogim kabaa. Biilu tam God imi abiip nan-temup uyo, waantap ita ita ita ke ipkumal nuyo kubaganup ita kamok kelan-tema o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesus iyo man katip maak olapma tal tama dep ninggil imi iibak tem daa-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ilami okumop man iyo bogobela, “Ibo man katip keyo atamin. Weng uyo dam bogobelan-temi kale, ipmi kanupmin aget mafak fugunin uyo kupkaa fupkela ko-nilip man kangkang kalip imi aget fugunin tambal ulutap kelin-tem kelip umdii, God iyo ibo imkala imi abiip uyo unon-temaalip ko. ");
INSERT INTO tlf_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kale man iyo deng tebe-bom ilimi win uyo kufumin binim kale, bilip iyo aget tambal fugun-bomip kale, ulutap mungkup tinum dogap ita ilami ilak do ilami win kufumin binim, aget tambal fuguna umdii, beta ipkumal iyo kubaganip imkaa God imi abiip tambal uyo kamok kelan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kale tinum dogap ita man kalatap iyo maak atamata, Yesus imi tiin diim uyo man kanupmin keyo win so kalaa age-nala dong dogobela umdii, boyo nimi dong daganemin kuguup uyo kulbu o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Kale Yesus iyo asok bogobe-nala e, “Kek kek iyo utamipta, tinum beyo tebe God imi ilak dolin unang tinum iyo ifak daalan o angba kalaa agelan-temip uyo, kanube bilip iyo tebe tuum afalik umaak ku sok de ko-nilip kwep yak tinum bemi fuk kun diim kwegal de kobe daalip daak yol ok kumun tem iina umdii, tinum beyo kaal fuyap uyo katip so kulata, ok tebe mimilepmu kaanan-tema kale minte, kanube kek kek iyo tinum beyo kanubelin-tem ke dupkalip tebe unang tinum God imi ilak dugamin katip katip ke-bilip iyo ifak daala kupkaa yang kuguup mafak uyo kemip umdii, God isiik tebe atin ki bemi ifak daala bomi yan uyo kobelata, tinum beyo kaal fuyap kwiin kiim uyo kugan kwep taban-bon-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kale kafin diim unang tinum kwiin tagang iyo kafin diim komi mufekmufek umi aget uta kup fugun-bom-nilipta, yang kuguup mafak uyo kem-nuubip kale, God iyo bomi kalan uyo yege-bom-nalata, imi kuguup mafak boyo yan ke-eman-tema kalaa age-nilita, fomtuup i-filin-bii kuba. Kuguup mafak uyo suun kup fen mitam tebe unang tinum imi aget fugunin uyo kufak daapmuta, iyo yang kube fengam-nuubip kuta, tinum dogap ita kuguup mafak kanu-bom-nala ipkumal imi kafalebela min, uget togo bogobela igil mungkup yang kuguup mafak uyo kanumip umdii, God yagal tebe tinum beyo yege-bom bemi ipkumal biinga kulep yang iinemin boyo fomtuup yan ke-eman-tema kale, ibo boyo tele utama-bom-nilipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Kale kabo kanube utamapta, nalami yaan aa sagaal aa uyo nimtamo yang daalu kuguup mafak uyo keman o angbi kalaa agelap umdii, kalapmi yaan aa sagaal aa bo ugaa kwaalap unu milii tumon ke-nalap kuguup mafak uyo kupkaa bii kaan-nalap tam God imi abiip kal suun kup nan-temap bota atin tambaliim kuta minte, kabo, yaan aa sagaal aa uyo ugaa kupkan kelaali o age kuguup mafak kup ke-bii kaanap kalaa age-nilip God imi ensel iyo tebe kamdalip no at suun kup kenamin abiip unon-temap boyo tambaliim ba ko. ");
INSERT INTO tlf_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ulutap kale, mungkup utamapta, nalami tiin uyo tebe kuguup mafak uyo kafalepnelu keman o angbi kalaa agelap umdii, kalapmi tiin milii bo dagaa kwaalap unu tiin milii tumon ke-nalap kuguup mafak uyo kupkaa bii kaan-nalap tam God imi abiip kal suun kup nan-temap bota atin tambaliim kuta minte, kabo tiin milii uyo dagaa kupkan kelaali o age kuguup mafak kup ke-bii kaanap kalaa age-nilip God imi ensel iyo tebe kamdalip no at suun kup kenamin abiip unon-temap boyo tambaliim ba o,” age Yesus iyo kam age-se (kale, bemi weng ko bogo-se kwek umi magam uyo bogo-nulu e, “Kanube kabo utamapta, intap intap mufekmufek uyo tebe biinga nimtamo yang kuguup mafak tem tililan o angbu kalaa agelap umdii, kanupmin mufekmufek boyo umik ugobe kupka-nalap e minte, kuguup mafak uyo kupkaa no ke tambaliim bom-balapta o,” age-suu) ko. ");
INSERT INTO tlf_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Kale Yesus iyo bogobe-nala e, “Nugumal ibaa. Nimi weng kaa bogobelan-temi koyo tinangku-silipta. Ipmi aget uyo fuguno-nilip, ‘Unang tinum God imi ilak dugamin katip katip ke-bilip iyo win binim o,’ agelan-temip kuta, di ipkil utamin. Bilip imi tiin molin tinum ko age ensel iyo nimi Aatum God imi miit tem kugol bom-nilip e, bilip imi sang uyo suun kup God iyo baga-em-nuubip kale, ipmi aget uyo fuguno, ‘Bilip iyo win binim o,’ agan-kalin ba kale, ibo tele utama-bom-nilipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Mo Tibil imi Man niyo tal unang tinum yang Saatan imi miit tem iinom maagalo kesip ita kulep meng God imi miit tem tolan o age-nilita, ti-sii ko. ");
INSERT INTO tlf_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Nimi do weng kaa bogopman-temi koyo tinangku-silipta. Tam tinum iyo maak sipsip ilimi kup wan handret (100) kalip iyo tiin mo-boma nala tam maagup uyo maak maagalo kelan-temu uyo, iyo intaben nulan-tema a? Sipsip tiin molin iyo sipsip ilimi kup nainti nain (99) kalip iyo imkala ifuul kon unan tiine-bilipta, no maagalo kebu umi fen tiineman-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kale fen tiine-bom utaman-tema uyo, sipsip tiin molin beyo fomtuup deng tebeman-tema kale, imi sipsip maagup bomi deng uyo ipkumal 99 maagalo kelin-tem albip bilip imi deng ulutap ba kale ki, atin fomtuup deng tebeman-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ulutap kale, nimi Aatum abiil tigiin kayaak iyo unang tinum ilami ilak dugamin katip katip ke-bilip bilip imi aget uyo fomtuup kobe-nalata, maak maagalo kemin ba o agan-nuuba o,” age Yesus ilami okumop man iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Kale Yesus iyo asok bogobe-nala e, “God imi unang tinum ibaa. Kanube God imi ilak dolin iyo maak tebe-nala kuguup mafak uyo kabo kopkela umdii, kabo kek kek iyo baga-emin ba kale, ilasinon alba kalaa age-nalapta, no atam-nalap e, bemi kuguup mafak ko kanupkeba bomi sang uyo bogobelapta, iyo kapmi weng uyo tinangku-nala ilami kuguup mafak kanu-be boyo kupkala umdii, bota asok alop ibo kubak diina tala ke-nilipta, deng tebeman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kale minte kapmi weng uyo tinangkulin-tem kela umdii, kalapmi duup iyo maagup min, alop min iyo maak kulep tal tolapta, alop bilip ita tebe-nilipta, alop ipmi weng bogobina tala keman-temip uyo tinangkulan-temip bota, ‘Tambaliim o,’ age God imi suuk kon tem uyo boyo kam agesu kale, alop imi weng tinangkulan-temip bota, son-temu uyo, tinum fenga koba beyo maak so weng bisop uyo bagaman-temaala ko. ");
INSERT INTO tlf_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kuta tinum fenga koba beyo ninggil asuno ipmi weng uyo tinangkulin-tem kela umdii, no God imi ilak dolin unang tinum iyo afeta-nilipta, alugum bomi sang uyo bogobelip weng uyo telela kolipta, tinum fenga koba beyo alugum ipmi weng uyo tinangkulin-tem kela umdii, ipmi iibak tem uyo fot tebe daalip tam iinon-tema uta tambaliim kale, ibo asit kek kek tinum so takis mani kwaamin tinum mafak so imi itafinon-bom yang tamip iso tiinemin binim kem-nuubip ulutap ke-nilipta, tinum fenga koba beyo fot tebelip yang iinemin o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Kale Yesus iyo asok bogola ko. “Kota niyo alugum God imi ilak dolin unang tinum kafin diim albip ipmi bogobelan o ageta kale, tinangku-silipta. Alugum ibo utamipta, intap intap kuguup uyo mafak kalaa age, nuyo kanuman-temaalup o agelan-temip uyo, God abiil tigiin kayaak yagal mungkup bogobe-nala e, ‘Boyo kanumin ba o,’ agelan-tema ko. Ulutap kale, alugum ibo utamipta, intap intap kuguup uyo tambaliim kale, alugum nuyo kanuman-temup bota tambal kalaa agelan-temip uyo, God abiil tigiin kayaak yagal mungkup bogobe-nala e, ‘Boyo kanumin o,’ age no kelan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Kale niyo asok weng migik maak bogopman-temi ko. Kale God imi ilak dolin tinum alop tap asuno tap ibo maak aget maagup ke-nilip nimi Aatum abiil tigiin alba imi beten ke-e-bom dagagaman-temip uyo, iyo tinangku-nalata, ipmi beten ke-bilip uyo yan kebe-nalata, kanubelan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kale boyo ki, God imi ilak dolin tinum alop tap asuno tap ibo tebe, Yesus imi ogok uyo maak kemum o age-nilip afetaman-temip uyo, niyo tal ipso bom-nilita, nimi aget fuguno, ‘Bota kanumin o,’ agan-bii uyo ibo utam-nilip e minte, ipkil boyo kanu-bom no ke-bilipta, God yagal tebe-nalata, dong daga-eman-tema o,” age baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kale Fita iyo tal Yesus iyo daga-nala e, “Kamogim kabaa. Kanube nimi nugum iyo kuguup mafak kupkanema uyo, imi kuguup mafak kupkane-be boyo kupkabe yakyak bii ilep intap kal fagalal o nagan-balap a? Kupkabe yakyak bii ilep ban kal fagalan-temi bota tii bele o?” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesus isiik imi weng uyo yan kebe-nala e, “Umbae. Ban kal boyo tii ba kale, kabo kapkum bemi kuguup mafak kupkake-be boyo tikimin ba kale, kanube kapmi kapkum iyo kuguup mafak kwiin tagang uyo kekemin kup ke-be kuta, kabo suun kup boyo kup-kaga-eman-temap boyo tambaliim ko. ");
INSERT INTO tlf_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kale God imi unang tinum tiin momin umi kuguup uyo kamok king maak imi kuguup ulutap kale, kamok beyo aget fuguno-nala e, ‘Nalami ogok kemin tinum tebe nimi yuum kepnelip dola-sii uyo tikili utam-nilipta, umi yan uyo kopnelin o,’ age-nalata, ");
INSERT INTO tlf_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ilami dong daga-emin tinum maak bogobe-nala e, ‘Kabo no tinum yuum kepne-silip iyo imtamo talaal o,’ agela e, no maagup dep tal tal kema ko. Kale tinum maak dep tala bemi yuum uyo kwiin kiim kale, ");
INSERT INTO tlf_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","beyo mani bisel umaak waafulin-tem kale, beyo dogobeta bagang-kale mo-nama binim kalaa age-nala e, imi kamok iyo un tubulin bogobe-nala e, ‘Ibo nimi ogok kemin tinum kaso imi kalel sino man sino imi alugum mufekmufek sino uyo kulep no mufekmufek saanin baan diim tolip molipta, bomi tisol uyo kulep tal tolip nita kululita minte, ulimal bilip ita tinum migik imi kulep no tolata, imi bisop ogok kemin unang tinum kelan-temip bota nimi yuum uyo ko molan-temip o,’ agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Kale imi ogok kemin tinum beyo tinangku-nala e, katuun duung fegela daak ilami kamok bemi miit tem kugol ton-nala e, fomtuup bogola ko. ‘Kamogim kabaa. Atam-salapta, molan-temi kale, ni-filin daa nimkalapta bole, kapmi yuum boyo alugum molan o,’ agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kale imi kamok iyo utamata e, kam agela kalaa age-nala e bole, du-filin daa imi yuum uyo kupkabe dupka-nala e bole, misiim dupkala daagina ko. ");
INSERT INTO tlf_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Kale ogok kemin tinum beyo kamok iyo dupkaa tam abiip tam abomu, ilami ipkum ogok kemin tinum maak siin umi yuum katip maak kebe-se beyo tal mep kugol alba kalaa age-nala e, ilami ipkum beyo del duung kwegal aafuu bogobe-nala e, ‘Kamano kota kapsiik nimi yuum uyo yuut kopnelal o,’ agela e, ");
INSERT INTO tlf_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","imi ipkum iyo katuun duung fegela daak ton fomtuup bogobe-nala e, ‘Atam-salapta, molan-temi kale, ni-filin daa nimkalapta bole, kapmi yuum katip boyo molan o,’ agan-be kuta, ");
INSERT INTO tlf_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ipkum imi weng boyo tinangkulin-tem ke-nala e, no un tubulin bogobelata bole, un tubulin iyo tal dep no kalabus am daa-nilipta, bogobe-nilip e, ‘Kabo katam kal bom-balap bii, kapkum imi yuum bomi mobelan-temap kota, talaa kamdalup tam iinon-temap o,’ agelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kale ipkumal iyo atamipta e, nugum beyo dep no kalabus am daalip kalaa age olsak depmuta, no ilimi kamok iyo alugum bomi sang uyo bogobelipta bole, ");
INSERT INTO tlf_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","kamok iyo tinangku-nala e, un tubulin iyo bogobe-nala e, ‘No nimi ogok kemin tinum mafak iyo dep talaal o,’ agela e, no dep tal daala e, kamok iyo tebe bogobe-nala e, ‘Kabo kuguup mafak kemin tinum kale, kapmi dagabap bota, niyo ka-filin daa-nilita, kapmi yuum kiim uyo kupkapkebi kale minte, ");
INSERT INTO tlf_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","kabo nimi tebe ka-filin daabi ulutap ke-nalap kapsiik tebe kapkum beyo du-filin daalan-temap boyo tambaliim kuta, kabo boyo kupkaa beyo du-filin daalin-tem kebap kale, bota nagal mungkup kabo ka-filin daalan-temaali o,’ age-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","atin olsak tebebelu e bole, un tubulin iyo bogobelata, iyo tebe tinum mafak beyo de dep no kalabus am daa bogobe-nilip e, ‘Kabo katam kal bom-balap bii, king imi yuum afek bomi alugum mobelan-temap kota, talaa kamdalup tam iinon-temap o,’ age bogobe-silip o,” age Yesus iyo do weng boyo bogobe-nala e minte, ");
INSERT INTO tlf_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","asok maak so bogo-nala e, “Ibaa. Do weng bomi aget uyo fuguno-nilipta, utamin. Kapkumal iyo tebe kuguup mafak kapmi kupkake-bilip uyo, kanu-bilip o ageta kapsiik kuguup mafak uyo kupka-emin ba kale, kupkabe-nalapta, bomi aget uyo maak sino fugunin ba kale, kanube kabo kapkumal imi yuum uyo kupkabelin-tem kelan-temap uyo, nimi Aatum abiil tigiin kayaak yagal kapmi yuum uyo kupkapkelan-temaala kale, kaal fuyap uta kopkelan-tema o,” age Yesus iyo Fita imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kale Yesus imi weng uyo baga-e-bii alugum binimanu kupka-nala e, Provins Galili uyo kupkaa Ok Jodan uyo ilo do yak milii abe-nala e, daage no Provins Yuudiya atuk kutam iina e, ");
INSERT INTO tlf_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","kota unang tinum kwiin tagang iyo dagaa dep Yesus imi umik tem daage no Yesus imi alba kutam iinipta, Yesus iyo unang tinum mafak ilin maak kugol albip iyo telela imkama ko. ");
INSERT INTO tlf_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Kale Falosi iip maak maak iyo, nota Yesus iyo bisop bogo dup-kugu-bulupta, weng mafak umaak bogola kalaa age-nulupta, dep no weng telelmin diim daalum o age-nilipta, tal daga-nilip e, “Kabaa. Moses imi ulo numi kobesa uyo tinum unang ku kup-kagamin umi sang uyo, intaben o agesu a? Uyo bogo-nulu, ‘Tinum iyo ilami kalel uyo kupkalan o agela uyo, yak alugum intap intap numu kalaa age fot tebelan-tema boyo tambaliim o,’ agesu bele o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesus iyo imi weng boyo yan kebe-nala e, bogobela, “Ibo God imi suuk kon tem uyo bomi sang uyo tiki-bii utamsip kuta, intaben o age-nilipta, niyo dagagan-bilip a? Atuk uyo bogo-nulu, ‘Kamaki God imi alugum mufekmufek uyo telela kosa uyo, unang sino tinum sino iyo telela imola agam maagup kesip kale, ");
INSERT INTO tlf_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","God iyo bogo-nala e, “Agam maagup kesip bota, tinum iyo tebe unang uyo kulan-tema uyo, tinum iyo ilami ogen so e aalap so iyo imka-nala e, yak imi kalel umi diim kal du-mola e bole, agam iyo maagup kelan-temip o,” agesa o,’ agesu kale, ");
INSERT INTO tlf_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","asok maak so alop kelan-temaalip kale, maagup kelan-temip ko. Kale God imi unang tinum kwep tala tala kela agam maagup kebip uyo, tinum iyo maak tebe-nalata, agam imi dula kula kebip uyo ilo kobela yang iina meng iina kemin ba o,” age Yesus iyo kam agela e, ");
INSERT INTO tlf_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","kota Falosi iyo Yesus imi daga-nilip e, “Kapmi kam agelap boyo dam umdii, Moses iyo, intaben o age-nalata, God imi suuk kon tem uyo weng migik uyo dola ko bogo-nala e, ‘Tinum kabo, kalel uyo kupkali o agelap umdii, boyo bong fagamin ba kale, imak kabo suuk kon umaak dola ko kalel umi kobelapta, ku-nuluta, kamkaa unon-temu o,’ agesa o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesus iyo bilip imi weng uyo yan kebe bogobe-nala e, “God tebe tinum dula unang kula kemin umi ulo kwep daasa uyo ipmi olal sino ipsino ibo tinangkulaalup o agan-bilip kalaa age-nalata, Moses iyo, ‘O,’ agelata, ibo tebe ilipmi kalelal iyo im-kagan-nuubip kuta, kamaki God imi unang tinum telela imosa uyo, God yagal tinum sino unang sino iyo, ‘Kanupmin kuguup mafak boyo kanumin o,’ age-nalata, kobesaala ko. ");
INSERT INTO tlf_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kale nimi weng maak kaa bogobelan-temi koyo tele tinangku-silipta. Kanube tinum iyo maak ilami kalel uyo sa dagamin binim, tambaliim kup albu kuta, yagal tebe, kupkali o age-nala kupkaa unang migik uta kula umdii, God imi tiin diim uyo bemi kanubela boyo fen sa daga-bom-nalata, ilami kalel yom uyo kupkeng daga-bom kufak dagan-be kalaa agelan-tema o,” age Yesus iyo Falosi imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kale imi okumop man iyo weng boyo tinangku-nilip e, Yesus imi bogobe-nilip e, “Tinum iyo utamata, unang ku kup-kagamin boyo bong fagamin kalaa agela umdii, tambaliim kale, beyo unang dalamin uyo kupka-nalata, kapket nan-tema bota tambaliim o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","kota Yesus isiik imi weng uyo yan kebe bogobe-nala e, “Tinum kwiin tagang iyo bagang-kale fen kapket nan-temaalip binim kale, iyo unang dulaman-temip kale minte, God iyo tinum iip maak maak ita kup titil uyo kobelata, bagang-kale kapket nan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kale tinum unang dulamin binim ke bisop kapket kup nin bomi magam uyo kwiin tagang kale, tinum iip maak maak kamaki umi ogenal imolip imi kaal mafaganebesu iyo bagang-kale unang uyo dululan-temaalip e minte, tinum iip maak maak waasi tebe imi kaal kufak daabesip iyo bagang-kale unang uyo dululan-temaalip e minte, tinum iip maak maak igil kaal tambal kuta minte, God yagal titil kobelata, kapket bom-nilipta, God imi weng uyo tambaliim kup kwep no ipkumal iyo baga-emum o age-nilipta, unang dululan-temaalip no ko. Kale tinum iyo maak, God imi ilak uta fomtuup dolan o age-nala bagang-kale kapket kup na umdii, God iyo tinum bemi deng uyo tebeman-tema o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tam ogenal iip maak maak iyo, Yesus tebe numi man kangkang sagaal togobe-nala God imi dagala dong dogobelata, tambaliim kup fitolin o age-nilipta, ilimi man iyo kulep Yesus imi finang tilip kuta, Yesus imi okumop man iyo, ogenal iyo fot tebelup daaginin o age yan togon-kalip e, ");
INSERT INTO tlf_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesus iyo bogobela, “Ibo fot tebemin ba kale, imkalipta, imi man iyo kulep nimi finang tilin o ageta ko. Kale unang tinum mitam God imi daam tem e talan-bilip iyo man kangkang ilitap kale, man kangkang bilip iyo fot tebemin ba kale, imkalip nimi finang tilin o,” age-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","man kangkang iyo sagaal togobe God iyo daga-nala e, “Aatum kabo man kangkang kalip iyo dong dogobelal o,” age kupka-nala e, imkaa daagina ko. ");
INSERT INTO tlf_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tam am maak daanu e, kamaa tinum maak tal Yesus imi daga bogobe-nala e, “God imi weng kafalemin kabaa. Niyo mitam suun nin tinum kelan o agan-bii kale, bota dogonupmin kuguup tambal uta waafu-nilita, mitam suun nin tinum kelal o nagan-balap o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesus iyo imi weng uyo yan kebe-nala e, “Kabo, intaben o age-nalapta, tal kuguup tambal umi sang uyo niyo dagagan-balap a? God maagup ita kup kuguup tambal uyo kemin kale, God imi ulo uyo Moses ita tebe God imi suuk kon tem dola kwep daasa kale, God imi ulo boyo waafu-bom-nalapta, mitam suun nin tinum kelan-temap o,” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","tinum besiik daga bogobe-nala e, “God imi dogonupmin weng kem uta waafulin kup kemal o nagan-balap o?” agela e, aa Yesus isiik bogobela ko. “Ulo uyo bogo-nulu kano, ‘Kabo unang tinum inolap kaanamin ba e minte, kapmi kalel uyo kupkaa unang migik so sa dagamin ba, kabo yuguut unan-kalin ba, kapkum iyo fenga kolin-tem uyo, kabo bisop bogo kiyap iyo baga-emin ba, ");
INSERT INTO tlf_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","kabo kapmi kogen kaalap imi weng uyo kwaasulemin ba kale, imi weng uyo tinangka-bom kuguup tambal uta kup kupka-emal o,’ age-nulu e minte, ‘Kalapmi kaal umi ilak do tambaliim tiin mobap ulutap ke kapkumal kek kek imi ilak uyo do telelemal o,’ age no kesu uta o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","kamaa tinum beyo Yesus imi bogobela ko. “Niyo God imi ulo boyo alugum suun kup waafulin kup bomi kuta, niyo utamita, kuguup tambal umaak duumatan-bii tap kalaa agebi kale minte, dogonupmin kuguup uta maak so waafulal o nagan-balap o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesus isiik bogobe-nala e, “Kuguup tambal uyo atin alugum waafulan o agan-balap kalaa age-nilita, kuguup waafulin-tem albap umi sang uyo kaa bogopkelan-temi kale, kabo tinangku-salapta. Kabo no-nalap kapmi mufekmufek uyo kapkumal imi kobelapta, ita molip umi mani kululan-temap uyo iip kulin man imi kobelap umdii, bota no God imi abiip kal suun kup tambaliim nan-temap ko. Kale kapmi mufekmufek uyo alugum kobe-nalapta, nisino abe-bomta, God imi ogok uyo kemum o,” agela kale, ");
INSERT INTO tlf_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","kamaa tinum beyo mufekmufek soyaap kale, Yesus imi weng bogobela boyo tolong do-nalata, imi aget uyo fuguno-nala e, “Atin suun nin tinum kelan o agan-bii kuta, nimi mufekmufek boyo fen iip kulin man iyo kopman-temaali o,” age-nalata, aget iluum kup tebebelu e, Yesus iyo dupkaa daagina ko. ");
INSERT INTO tlf_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kale Yesus iyo tinum bemi aget uyo fugun-bom-nala e, ilami okumop man imi bogobela ko. “Niyo dam bogopman-temi kale, unang tinum mufekmufek so kasel bilip iyo bong faga-bomta imi mufekmufek aget ugel kalagamin uyo kupka-nilipta, meng God imi miit tem tolon-temip kale, iip maak maak ita kup God imi aget uyo kobe-nilipta, mitam God imi daam tem uyo mitam tolon-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Niyo weng boyo maak so tifilan-temi kale, kong kiim ko age kamel boyo, tam men sok sil imi magat kun tem ilep tam iinon o agelu uyo, bong fagan-bii-nuluta, tam iinon-temu kale, ulutap kale, tinum mufekmufek soyaap yagal mungkup atin bong kup fagan-bii-nalata, mitam God imi daam tem uyo mitam tolon-tema o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kale tam okumop man iyo tinangku-nilip e, fomtuup kumang mo kupkaa daga-nilip e, “Kapmi kam age bogo-nalap, ‘Mufekmufek soyaap beyo bong faga-bomta mitam God imi daam tem uyo mitam tolon-tema o,’ agelap boyo dam umdii, iip kulin man nuyo dogonube-nulupta, tam God imi daam tem uyo tam unon-temup a? Boyo fen bagang-kale tam unomup binim o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesus iyo ilimi tiin tem kek fen itam-nala e, bogola ko. “God ita tii alugum mufekmufek uyo kanube-nama kuta, tinum ilasinon uyo, bagang-kale-nalata, mitam God imi daam tem uyo mitam tolon-temaala kale, God yagal tebe dong dogopman-tema uta, mitam God imi daam tem uyo mitam tolon-tema o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Fita isiik bogobe-nala e, “Kamogim kabaa. Tolong do-salapta. Ninggil nuyo numi abiip sino numi mufekmufek sino uyo alugum kupka-nulupta, kapmi ogok uta kem kapsino tiinan-bulup kale, kanu-bulup boyo, son-temu uyo, God imi abiip uyo no tamupta, kabo dogonupmin kuguup tambal uta nuyo kopman-temap o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesus iyo ilami okumop man imi bogobe-nala e, “Niyo dam bogopman-temi kale, son-temu nala afungen tem tulu God tebe-nala asok abiil so kafin so umi migik telela kolan-tema kota, Mo Tibil imi Man nita mitam Kamok miton ke-nilita, alugum iyo tiin molan-temi kale, kota nimi okumop man tuluun kal ibo nimi titil uyo kobelita, nimi win tolop diim Israel imi man ilop imi miit tuluun kal kalip iyo ipkil tebe miit maagup ku tiin mola tiin mola kelan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kale tinum iyo dok ita nimi ilak uyo do-nilipta, imi am min, figal min, nagalal min, ibinangal min, aalap min, ogen min, man min, iman ilang min uyo kupka-nilip tal nimi ogok uta waafulip umdii, am afungen daanan-temu kota, God iyo kuguup tambal kup kobe-nala e, kanupmin mufekmufek umi kupkaa tisip uyo ulumi kup tii 100 kobe no kelata, suun kup nan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kale unang tinum kwiin tagang kamano komi win so albip iyo biilan-temu uyo, bilip isiik win binim ke kubaganip e minte, unang tinum kwiin tagang kamano komi win binim ke kubagansip isiik biilan-temu uyo, win so ke no kelan-temip o,” age Yesus iyo kam agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kale Yesus iyo do weng maak bogobe-nala e, “God imi tebe unang tinum tiin mo-bom mufekmufek taga-em-nuuba umi kuguup uyo sok dum ilang kayaak maak tebe ogok kemin tinum imi kuguup kobe-se ulutap kale, bemi sok dum ilang uyo kwiin kiim kuta minte, imi ogok kemin tinum ita iip maak maak ita kup kale, kutim ataan, kenan o agan-suluta, sok dum ilang kayaak iyo daage no, yol am kugol tinum iyo maak ululita, no nimi ogok kene-bom-nilip mani kwaamin o age-nalata, ");
INSERT INTO tlf_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","daage no tinum iip maak maak iyo itam-nala e, bogobela, ‘Ibo ogok ke-biilan age-silip kwiina kota, ogok ke-bii am maagup kemin umi tisol uta kup tii kobe yakyak keman-temi o,’ age-nala e, imdala no imi sok dum ilang kugol ogok kemip ko. ");
INSERT INTO tlf_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Kale am uyo taabanu e, sok dum ilang kayaak iyo asok tinum fen daage no yol am no abomu, tinum iip maak maak iyo bisop tonbip kalaa age-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","bogobela, ‘Ibaa. Ibo no nimi sok dum ilang kugol ogok ke-bilip bii, kwiinuta, ogok ulumi tii tisol uyo kobelan o,’ agela e, ");
INSERT INTO tlf_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","tinangku-nilip e, daage no ogok kemip ko. “Kale no ogok ke-bilip bii, atanim uyo tal dubim e tulu e, sok dum ilang kayaak iyo tinum iip maak maak iyo kulula ogok kem unip e, siit-nala e, minte atanim te kek e abe-bulu e, tinum iip maak maak iyo asok kulula ogok kem un no kelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Kale bii am kwiinu ogok uyo binimanan o agan-sulu e, beyo daage no yol am no abomu, tinum iip maak maak iyo asok kugol albip kalaa age-nala e, bogobela, ‘Ibaa. Ibo intaben o ageta am daanbu koyo, bisop albip o?’ agela e, ");
INSERT INTO tlf_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","isiik bogobe-nilip e, ‘Nuyo tinum iyo maak tebeta ogok umaak kopmin-tem kale, bisop am kal albup o,’ agelip e, bogobela ko. ‘Ogok umaak kobelin-tem umdii, ibo no nimi sok dum ilang uta ogok kemin o,’ agela e, daage no ogok kemip ko. ");
INSERT INTO tlf_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Kale atanim tem iinon o agan-sulu e, sok dum ilang kayaak iyo tebe ogok kemin tinum imi tiin molin iyo bogobe-nala e, ‘Ogok kemin tinum iyo alugum olabelap tala tala kelipta, imi tisol uyo kuga-emal o ageta kale, kamaki uyo kabo mep maak aaltam tal ogok kem-silip kwiinu bilip isiik kobe-nalap e minte, bilip imi umik tem uyo ipkumal iip maak taabanu tal ogok ke-bilip iyo kobe no ke-nalapta minte, kamaki kutim tal ogok ke-bilip bilip ita afung afung kobe no kelal o,’ agela e, ");
INSERT INTO tlf_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","bole tam tiin molin iyo ogok kemin tinum olabela tal tamip e, beyo tisol uyo yagalami kobe kobe kemsaala kale, kamaki uyo ogok ke-bii am maagup kemin umi tisol uyo tinum aaltam tal ogok ke-bilip bilip isiik kobe-nala e, tam tinum taap tilip iyo asok mungkup ogok ke-bii am maagup kemin umi tisol uta kobe no kela e, ");
INSERT INTO tlf_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","aaltam uyo tinum kamaki kutim tal ogok kem albip iyo tal, tisol kwaamum o age tal-nilip e, aget fuguno-nilip e, ‘Nuyo kutim kota ogok kem kwep talanbu tal am kwiina kaa diibelup kale, nuyo tisol bisel kululan-temup o,’ agelip kuta, alugum maagup maagup iyo tinum aaltam tilip imi tisol kululip ulutap ogok ke-bii am maagup kemin umi tisol uta kup kulu-nilipta, ");
INSERT INTO tlf_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","utamipta e, numi tisol koyo nugumal mep kwiina tal ogok kem-silip kwiinu imi tisol kululip ulutap kululup kalaa age-nilip e, kamok iyo olsak kupka-e-bom bubun-bom ");
INSERT INTO tlf_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","bogobe-nilip e, ‘Kamogim kabaa. Ogok kemin tinum kalip iyo ogok uyo binimanan o agan-suluta, tal-nilip ogok katip kup kelip kale minte, nuta kutim kota tal ataan afek diim koyo ogok kem talanbu tal am kwiina kaa diibelup kuta, intaben o age-nalapta, numi tisol uyo bilip imi tisol kobelap kulutap mungkup nugol kobelap a? Kale boyo felepmin-tem o,’ agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","sok dum ilang kayaak isiik tebe bilip imi tinum maagup imi weng uyo yan kebe-nala e, bogobela ko. ‘Nugum kabaa. Sining age tinangku-salapta. Niyo bogopke-nili, “Ogok ke-bii am maagup kemin umi tisol uta kop-kaman-temi o,” agelita, kabo, “Ogok ke-bili bii, am maagup kelan-temi o,” nagebap kale, niyo kabo kuguup mafak kopkelaali kale, nulumi weng bogobup uta kup waafu-nilita, boyo kobeli ko. ");
INSERT INTO tlf_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","15","Kale nalami aget fugunin uta, tinum aaltam tilip kalip iyo kuguup tambal umaak kopman o age-nilita, kapmi tisol kopkeli kulutap mungkup igil kanube kobeli ko. Alugum ibo ogok ke-bii am maagup kemin umi tisol uta kululip kale, boyo felepmu kale, niyo nalami aget fugunin uta nalami tuumon uyo kulu-nili tinum iip maak maak imi mufekmufek duumatanbip ita misiim dong daga-e-bii kuta, kabo, intaben o age-nalapta, titin-bom-nalap e minte, olsak tebe-bom no ke-balap a? Kale kapmi tisol uyo kulep-nalap e, daaginaal o,’ age sok dum ilang kayaak iyo ogok kemin tinum imi baga-emsa ko. ");
INSERT INTO tlf_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Kale do weng bomi magam uyo, unang tinum dogap ita utamipta, kuguup mafak ke-bulup kalaa age-nilip kamaa kagal imi aget uyo fupkela ko nimi ilak uyo dolip umdii, God imi tiin diim uyo bilip iyo win so kelan-temip kale minte, unang tinum dogap ita siin uyo imi aget uyo fupkela ko nimi ilak uyo do-nilip nimi ogok uta kem tebesip kuta, bilip iyo, ‘Nuyo tambaliim o,’ agan-kalip umdii, God imi tiin diim uyo bilip iyo kubagan-nilip e, win binim kelan-temip (kuta, God iyo bilip iyo alugum maagup tisol tambal kobelan-tema) o,” age Yesus iyo kam age bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kale Yesus sino ilami okumop man sino ninggil iyo daage, abiip miton Jerusalam unum o age abe-bom-nilip e, ilami okumop man tuluun kal iyo unang tinum imi iibak tem kulagal ulu kulep yang kweng tola ninggil ilisinon abe-bom-nilip e, bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ibaa. Jerusalam kamet iinum o age talan-bulup kale, no kugol bom-bulupta, tinum maak tebe-nala e, Mo Tibil imi Man niyo nimdep no tinum amem ko age pris imi kamogimal so ulo utamsip tinum so imi diim daabelata bole, igil weng tegen-bom-nilipta, ‘Tinum beyo angkolip kaanak o,’ nage bogo kupka-nilipta, ");
INSERT INTO tlf_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","nimdalip yak Rom kasel imi sagaal diim abelita, ita tebe-nilipta, titul weng bagane-bom-nilip e minte, sok ifet ku saal daga-bom no ke-bii-nilipta, nimdep no at diim kal nim-diilip kaanita, nimdep no namalip bii, am alop kelita, am asuno diim kota God yagal tebe nifolata, asok fen tigi molan-temi o,” age Yesus iyo ilami okumop man ita kup baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kale Sebedi imi kalel uyo umi man tinum alop Jems sino Jon sino iyo kulep Yesus imi finang tal-nulu e, katuun duung fegela daak ton-nulu e, bogobelu ko. “Kamogim kabaa. Niyo, nimi man kalip iyo mufekmufek tambal umaak kanubelal o agan-bii o,” agelu e, ");
INSERT INTO tlf_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesus iyo dagala, “Kubo, intaben uta niyo kanupnelak o nagan-balap o?” agela e, ogen usiik Yesus imi weng uyo yan kebe bogo-nulu e, “Suuk nala kapmi mitam kamok king ke-nalap unang tinum alugum imi tiin molan-temap uyo, kabo nimi man tinum alop kalip iyo ululapta, maak iyo te kapmi ipkuk ilo keng kal tona e, minte maak ita te afaan ilo keng kal tona no ke-bom kabo dong dagake-bilipta, ninggil ibo unang tinum iyo tiin molin o,” agelu e, ");
INSERT INTO tlf_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesus iyo fupkela kek fen tiin alop iyo itam-nala e, ilami kaal fuyap kulan-tema umi sang uyo imi bogobe-nala e, “Nugumal ibaa. Ipmi dagagan-bilip bomi magam uyo ibo tele utamin-tem kale, kuguup mafak maak kek kek ita tebe nimi kop-naman-temip uyo ipkil tii boyo ku no kelan-temip aga o?” agela e, bogobe-nilip e, “Aa. Nuyo tii boyo kanupman-temup o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesus iyo bogobela, “Dam kale, ibo nimi kuguup mafak ko nimi kop-naman-temip ulutap kelan-temip kuta, boyo nimi ogok keluta, tinum ulu-nilita, kamok imi baan diim nimi mep sino albu uyo imdep daalan-temaali kale, boyo nimi Aatum God imi ogok kale, yagal tinum iyo ulusa kale, imdep daalata, ita tebe dong dagane-bilipta, unang tinum iyo tiin molan-temup o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kale Yesus imi okumop man nagaal kal iyo tinangku-nilip e, okumop man alop bilip iyo olsak kopmip e, ");
INSERT INTO tlf_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesus iyo olabela okumop man iyo alugum tilip e, bogobela ko. “Ibaa. Ipkil utamipta e, kafin diim kagal God imi ilak dolin binim unang tinum imi kamogimal iyo unang tinum iyo alaang weng uyo kupka-e-bom-nilip e minte, ilimi aget fugunin weng uta kup kuguup mafak uyo kupka-e-bom no kem-nuubip kalaa agesip kuta minte, ");
INSERT INTO tlf_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","nimi ilak dolin ibo bilip imi kuguup ko kanum-nuubip boyo ipsiik dagaa ku kanumin ba kale, tinum iyo, ipmi kamok kelan o agela umdii, beyo ilami win uyo kufumin ba kale, bilili age-bom ipkumal imi bon tem kiit fenan-tema bota tambaliim kale minte, ");
INSERT INTO tlf_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ipmi tinum iyo dok ita, nita mitam nugumal imi kamok kelita o agela umdii, beyo alugum ipmi dong daga-emin tinum kelan-tema bota tambaliim ko. ");
INSERT INTO tlf_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kale Mo Tibil imi Man niyo kafin diim koyo bisop tal ton-bom-bilita, tinum ita nimi ogok uyo kenemin o ageta tisaali kale, niyo tal-nilita, fomtuup ogok ke-bom unang tinum iyo dong daga-eman o ageta ti-sii boyo ki, niyo tal-nilita, waasi iyo imkali tebe nangkolip kaanan-temi bota unang tinum kwiin tagang imi ilim uyo bobelita, bilip iyo God imi man ke suun nin o ageta ti-sii kale, ibo nimi unang tinum dong daga-e-bii ulutap ke-bom-nilipta o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Kale Yesus sino ilami okumop man sino iyo abiip Jeriko uyo kupkaa abe-bilip e, unang tinum kwiin tagang iyo yak ninggil imi daang begebe no kelip dagaa dep unip ko. ");
INSERT INTO tlf_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kale abe-bilip e, tinum tiin mafak alop maak ilep mibiyaang tem kugol tonbip iyo tolong dolipta e, unang tinum iyo bogo-nilip e, “Yesus iyo tiinan-be o,” agan-bilip kalaa age olabe-nilip e, “Kamogim kabaa. Kabo kalapmi afalik King Devit ilatap kale, nuyo i-filin daa kapmi titil uyo ku-nalap dong dogobelal o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","unang tinum iyo tebe alop iyo yagan-bom bogobe-nilip e, “Ibo sining agelin o,” agan-bilip kuta, tinum tiin mafak alop bilip iyo asok fomtuup ol-bom-nilip e, “King Devit imi man ilop Kamogim kabaa. Kabo nuyo i-filin daa dong dogobelal o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesus iyo sining age kugol mo-nala e, olabela, “Ibo, niyo intaben nubelak o ageta olne-bilip o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","alop isiik imi weng boyo yan kebe bogobe-nilip e, “Kamogim kabaa. Nuyo dong dogobelap alop numi tiin koyo tambalanepmuta, mufekmufek uyo utamamum o ageta olan-bulup o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesus iyo alop iyo i-filin daa-nala e, yak imi tiin uyo melebela e, maak fagaa alop imi tiin uyo tambalanepmu e bole, Yesus imi ilak uyo dolip e, isino unip ko. ");
INSERT INTO tlf_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesus sino ilami okumop man sino iyo tal abiip miton Jerusalam mep so tal Oliv Tigiin umi abiip maak Betfage tolom-nilip e, Yesus iyo, ilami okumop man alop maak isiik imdali unipta o age-nalata, ");
INSERT INTO tlf_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","weng kem usiik bogobe-nala e, “Ibo yak abe ko tam abiip utaman-bulup boyo tamta, kong ko age dongki ogen so umi man kagum so afaat im-diilip albip kalaa age yuut utaman-temip ko. Kale dongki afaat imi sok uyo tiila ko-nilipta, kulep nimi finang tilipta o ageta kale, ");
INSERT INTO tlf_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","minte kanum abe-silipta, tinum iyo maak itamata, kanum talan-bilip kalaa age-nala ibo dagala umdii, ipsiik bogobe-nilip, ‘Numi Kamogim yagal, “Kulep tilin o,” agelata, tulup kale, nuyo kuun kulep no tolupta, Kamogim iyo asok yuut imdalata, kulep tolon-temup o,’ age bogobe-nilipta, kulep tilin o,” age bogobe-nala e, imdala unip ko. ");
INSERT INTO tlf_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","5","Kale sugayok kutop uyo God imi profet maak God imi suuk kon tem uyo dola ko bogo-nala e, “Ibo no abiip miton Sayon ko age Jerusalam kutam iinom-nilipta, abiip kasel iyo bogobe-nilip, ‘Utamin a. Ipmi kamok king iyo ipmi finang talan-be kale, iyo win soyaap imi telemin ulutap ke-nalata, talanbaala kale, iyo dukmen-bom-nalata, dongki man kagum imi daang kun diim kugol ton-nalata, talan-be o,’ agelin o,” agesa kale, kota imi weng bogosa uyo, dam kelan o agan talan-bo ko. ");
INSERT INTO tlf_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kale Yesus imi okumop man alop iyo Yesus imi weng kem uyo tinangku-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","daage no dongki afaat imi sok uyo tiila kobe-nilip e, kulep no Yesus imi kobe-nilip e, tam ilimi saket uyo dulu kulep te tam dongki man kagum imi daang kun diim kal tufobelip e, Yesus iyo te tam dongki imi daang kun diim kal tona e, ");
INSERT INTO tlf_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","kota tam tinum unang kwiin tagang imi aget fugunin uyo, king imi tal-bala deng tebemin kuguup uyo kanumin kale, Yesus imi ka-tele talan-be boyo, nuyo ilep koyo atin tambaliim kup telelepmupta, tiinak o age-nilipta, ilimi ilim iip maak maak uyo dulu kulep daak ilep kal ifu-bala e minte, iip maak maak ita minte yang abe at tung uyo kon so fagan-bii kulep te daak Yesus imi ilep tiinon-tema uyo ifu-e-bala no kem yakyak ke-bilipta, dongki beyo ilim so at bubuul so umi tip diim kutop-tele tiina ko. ");
INSERT INTO tlf_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kale unang tinum kwiin tagang iyo ugaa kulu bon tem abe-bala e minte, Yesus ita iibak kugol abe-bala e, unang tinum kwiin tagang iyo umik tem abe-bala no ke-bom-nilipta, deng tebe-bom fomtuup ol-bom-nilip e, “Nuyo King Devit imi man ilop kemi win uyo dugola kufu-emum o,” age-nilip e, “Yesus keyo Bisel God imi win tolop diim o ageta talan-be kale, God tebe kuguup tambal uta kup kupka-e-balata o,” age-nilip e, “God imi win afaligen boyo dugola kufu-e-bom deng tebemum o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kanum abe-bilipta, Yesus iyo no Jerusalam kutam iina e, abiip kasel iyo alugum atam-nilip e, alugum maagup ki fomtuup kumang mo-nilip e minte, deng tebe-bom no ke-bom-nilip e, igil tebe dagana tala ke-bom-nilip e, bogolip, “Beyo waantap ita o?” agan-kalip e, ");
INSERT INTO tlf_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","unang tinum Yesus sino talan-bilip iyo ipkumal imi weng boyo yan kebe-nilip e, “Beyo God imi profet ko age weng kem baga-emin tinum Yesus kale, beyo Provins Galili umi abiip Nasaret bomi tinum o,” agelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kale Yesus iyo daage no ulotu am miton no abomu e, tinum iyo tebe-nilip e, mufekmufek God imi kuga-emin uyo kulep te tam tolip ulotu am kutam kal saan-bilip kalaa age-nala e, yagal tebe alugum tinum mufekmufek kulep te tam to-bilip so tinum migik tal saan-bilip so iyo alugum fot tebela sigino tam iinip e, tuumon kobina tala kemin tinum imi tebol uyo dagaa kup-kiit mobe-nala e, uun abim God imi kuga-emin umi kulep tal tolip saanin tinum imi siya uyo duko kulupma yang abe no kebelu kupka-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","bogobela, “Sugayok God imi weng suuk kon tem dola kosip maak bogo-nala e, ‘Nimi am katam uyo, “Beten kemin umi am o,” agan-kalon-temip o,’ agesa kale, ibo God imi weng boyo utamsip kuta, kwaasulebe-nilip God imi am uyo kufak daga-e-bilip kale, am katam uyo ipmi bisnis ke-bom ipkumal imi mani yuguut unan-kalin umi am kelu kupkasip o,” age bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kale Yesus iyo ulotu am miton kutam kal bom-bala e, unang tinum tiin mafak sino ibiit sino iyo Yesus finang no tamip e, telela imkama ko. ");
INSERT INTO tlf_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Kale tinum amem ko age pris imi kamogimal sino ulo utamsip tinum sino iyo Yesus imi kuguup migik kanu-be boyo utam-nilip e minte, tolong dolipta, man kangkang iyo ulotu am miton kagal olan-bom bogo-nilip e, “Keyo King Devit imi man ilop kale, imi win uta kufu-emum o,” agan-bilip kalaa age-nilip e, tinum amem imi kamogimal sino ulo utamsip tinum sino iyo Yesus imi olsak kupka-e-bom-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","bogolip, “Kabaa. Kabo bilip imi kanupmin weng mafak bagan-bilip boyo tolong dolap aga o?” agelip e, Yesus iyo bogobe-nala e, “Bilip imi weng boyo tinangkuli kale, bilip iyo kuguup mafak kebaalip kale, bilip iyo God imi suuk kon tem weng bogosu uta ke-bilip kale, uyo bogo-nulu, ‘God kabo man kangkang sino man unaak sino iyo kafalebelapta, kapmi deng tebe-bom-nilip e, kapmi win uyo kufuke-bom no kem-nuubip o,’ agesu kale, ibo God imi weng boyo ilumanosip aga o?” age bogobe-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","kamogimal iyo ulotu am miton kutam kal imka-nala e, mitam abiip abe-nala e, daage no abiip Betani kutam kal seta ko. ");
INSERT INTO tlf_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kale Yesus sino ilami okumop man sino iyo Betani kal silipta, kutim mililep kota Betani uyo kupkaa no Jerusalam unum o age abe-bom-nilip e, kota Yesus iyo iman tep tebebelu e, ");
INSERT INTO tlf_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","utamata e, yet miit maak ilep magaang tem kugol mobu kalaa age-nala e, daage yang, yet dum boyo maak dugu une-nilita o age-nala e, yang abomu, yet miit boyo maak abubaalu binim, bisop kon kup kalaa age-nala e, bogola, “At koyo dum umaak abuman-temaalu o,” agan-sala e, kota at yet miit boyo maak fagaa datanu ko. ");
INSERT INTO tlf_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kale okumop man iyo utam-nilip e, kumang mo dagalip ko. “Bae. Yet miit koyo dogonubeta yuut datanu o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesus iyo imi weng uyo yan kebe-nala e, “Nimi weng koyo ilumanamin ba kale, kwep aget tem daalin o ageta kale, God imi aget fugunolap uyo, aget alop fugunin ba kale, tele aget fugunota e, God imi, ‘Bota kanubelal o,’ agan-be uyo, beyo tii dong dogopnela kanupman-temi kalaa agelan-temap uyo, kapkal tii nimi at kanubeli kulutap uyo kanubelan-temap kale ulutap, kabo bogo-nalap, ‘God kabo yak amdu boyo balaa kwaalap daak yol ok kumun tem iinuk o,’ agelan-temap uyo, kapmi dagalap boyo God iyo tebe kanubelan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kale kabo aget fugunota e, God beyo tii dong dogopnela imi kuguup uyo kanupman-temi kalaa agelan-temap uyo, kabo beten ke dagalan-temap kota, iyo fen tii kanup-kaman-tema o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Kale Yesus iyo daage no Jerusalam kutam abe-nala e, daage tam ulotu am miton kal tam bom-nala e, God imi weng uyo unang tinum iyo kafale-bala e, tinum amem ko age pris imi kamogimal sino Juda kasel imi kamogimal sino iyo tal Yesus iyo daga-nilip e, “Kabaa. Kabo waami win tolop diim kanupmin kuguup boyo kanum-nuubap a? Kabo waantap ita kamdala tal-nalapta, kanupmin kuguup boyo kanu-maansap o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesus iyo bilip imi weng uyo yan kebe-nala e, “Kalo. Nisiik weng maak ipmi dagalan-temi kale, ibo nimi weng uyo yan kepnelip umdii, nagal mungkup ipmi weng uyo yan kepman-temi ko. ");
INSERT INTO tlf_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ok sam uga-emin tinum Jon Baptis iyo waami win tolop diim unang tinum iyo ok sam uga-emsa a? God imi win tolop diim bele, kafin diim komi tinum imi win tolop diim kanumsa a? (Nimi weng ko dagali boyo yan kepnelipta) o,” agela e, tam kamogimal iyo wengaal digin-bom bogobina tala ke-bom-nilip e, bogolip, “Nuyo, intaben o agelan-temup a? Nuyo bogo-nulup, ‘God imi win tolop diim kanumsa o,’ agelan-temup bole, beyo tebe nuyo bogobe-nala e, ‘Ibo utamipta, God imi win tolop diim kanumsa kalaa agelip umdii, intaben o ageta ibo Jon beyo fen God imi weng uta tuluun baga-e-be kalaa agansaalip o?’ agelan-tema kale minte, ");
INSERT INTO tlf_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","nuyo bogo-nulupta, ‘Kafin diim komi tinum imi win tolop diim kanumsa o,’ agelan-temup uta, unang tinum kwiin tagang kalip iyo aget fugunolipta e, boyo dam, Jon iyo God imi profet ko age weng kem baga-emin tinum kalaa age-nilip nuyo olsak kobe-nilip e, ino-nimip o ageta nuyo finan-bulup o,” age-nilip e minte, ");
INSERT INTO tlf_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Yesus imi weng uyo bisop bogobe yan kebelup ko age-nilip e, “Waantap ita tebe Jon iyo bogopmata, Jon beyo tebe unang tinum iyo ok sam uga-emsa kalaa age utabaalup o,” agelip e, Yesus isiik bogobe-nala e, “Nagal mungkup ulutap kale, niyo ibo bogobe-nili, ‘Waami win tolop diim uta kanupmin kuguup boyo niyo kanum-nuubi o,’ age bogopman-temaali o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kale Yesus iyo kamogimal imi bogobe-nala e, “Nimi do weng kaa bogolan-temi koyo tele tolong do-nilipta, aaltam kota dogonupmin aget fugunin uta kulup kalaa age-nilipta, ipkil bogopnelin o ageta ko. Kale tam tinum maak beyo man tinum alop kale, am maak daanu e, tam man diil imi bogobe-nala e, ‘Nimi man tinum kabaa. Kamano koyo kabo no sok dum ilang uta digin-kalal o,’ agela e, ");
INSERT INTO tlf_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","man isiik aalap imi bogobe-nala e, ‘Niyo kulali o,’ age bii-nalata, minte aaltam kota imi aget uyo fupkela ko-nala e, daage no sok dum ilang uyo digin-kala ko. ");
INSERT INTO tlf_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kale aalap iyo no man tinum afungim iyo atam-nala e, asok mungkup fik imi bogobela ulutap mungkup bogobela e, man isiik aalap imi weng uyo yan kebe bogobe-nala e, ‘Nita no digin-kalon-temi o,’ agela kuta, iyo unin-tem ke kupka-se ko. ");
INSERT INTO tlf_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Kale kota niyo weng maak dagalan-temi kale, tinangku-silipta. Man alop bilip iyo niing ita bele, fik ita ilimi aalap weng uyo tinangku-se o?” agela e, tam kamogimal isiik bogobe-nilip e, “Fik ita aalap imi weng uyo tinangku-se o,” agelip e, Yesus iyo bogobela ko. “Nimi weng kaa bogopman-temi koyo tele tinangku-silipta. Unang tinum mafak iyo fik imi kanube-se kulutap kelan-temip boyo ki, takis mani kwaamin tinum mafak sino minte sa dagamin unang sino iyo ilimi aget uyo fupkela ko-nilipta, ita ita kelipta, kamogimal ipta kubaganipta, yuut mitam God imi daam tem e tolon-temip kale minte, ipde a? Ibo mitam God imi daam tem e tolon-temip bele ki? ");
INSERT INTO tlf_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kale siin uyo ok sam uga-emin tinum Jon Baptis iyo tal ibo kafale-bom bogobe-nala, ‘Ibo mitam God imi daam tem e telemin umi ilep uyo kanube-nilipta o,’ agansa kuta, ibo imi weng uyo tinangkamsaalip kale minte, takis mani kwaamin tinum mafak sino minte sa dagamin unang sino ita Jon imi weng uyo tinangku-nilipta, imi aget uyo fupkela ko-nilipta, ilimi kuguup mafak ke-bilip uyo kupka-nilip e, God imi ilak uta dolip kalaa age-nilipta, ibo itam-silip kuta minte, ibo Jon imi weng uyo tinangku ipmi aget uyo fupkela kota kulitap kelin-tem ke-nilipta, ipmi kuguup mafak ke-bilip uyo kupka-nilipta, God imi ilak uta dolin-tem o,” age Yesus iyo kamogimal iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesus iyo asok kamogimal imi bogobe-nala e, “Niyo weng migik maak bogopman-temi kale, ibo tele tolong do-silipta. Tam tinum maak sok dum ilang maak telela ko-nala e, daam fogo kupkaa sok dum umi san uyo u-nala e, sok dum umi ok tugutmin umi baan diim uyo telela ko-nala e, sok dum ilang bigimin tinum imi am uyo isal am deebe no ke-nala e, minte tinum sok dum ilang tiin molan-temip iyo ulu bogobe-nala e, ‘Tam sok dum umi abulan-temu uyo, dagan-bii ko kupkaa tugut-bom ok uyo ilan-bii kobelip ipkumal ita molipta, ibo tisol uyo kulu-nilipta, duula ko ipkil atuk uyo kulu-nilip e minte, nagal atuk uyo kulupnelip no telemuk o,’ age-nala e, imkaa no abiip maak simanim kal na ko. ");
INSERT INTO tlf_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kale sok dum umi abumin am uyo daanu e, (tiin molin tinum iyo sok dum uyo dagan-bii ko kupkaa tugut-bom ok uyo ilan-bii kopmip ipkumal iyo molip e,) kota sok dum ilang kayaak iyo ilami ogok kemin tinum iyo imdala tal sok dum ilang tiin molin tinum imi bogobe-nilip e, ‘Numi kamogim imi sok dum ok umi tisol atuk uyo kobelipta, numi kamogim imi kulubinum o,’ agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","bole sok dum ilang tiin molin tinum iyo tinangku-nilip e, yak kamogim imi ogok kemin tinum iyo yaafu-nilip e, maak ita bisop fom saal daga-bom-nilip e minte, maak iyo angkolip kaana e, maak yagal tuum tuup angkolip kaan no kelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kale kanubelip kalaa age-nala e, kamogim iyo ogok kemin tinum iyo kwiin tagang imdala sok dum ilang tiin molin tinum imi finang no tamip e, tiin molin tinum iyo tebe asok kamaki ogok kemin tinum imi tal tamip kanube inobip ulutap mungkup inolip kaan no kelip kalaa age-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","kamogim iyo tinangku-nala e, aget fugunola ko. ‘Niyo nalami man keyo daali una umdii, imi weng uyo kwaasulepman-temaalip o,’ age-nala e, afungen uta ilami man iyo daala no sok dum ilang tiin molin tinum imi finang una ko. ");
INSERT INTO tlf_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kuta no tama tiin molin tinum iyo atam-nilip e, kota ninggil bogobe-nilip e, ‘Tinum tala beyo kamogim ilami man kale, biilu aalap imi kaanan-tema uyo, man beyo tebe aalap imi sok dum ilang koyo bugulan-tema kale, kamaa kagal angkolup kaanata, sok dum ilang koyo nulumi aligaap keluk o,’ age-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","kota yak aafu-nilip e, dilili dep daam tem uyo kupkaa tam sep kutam daa-nilip e, angkolip kaana o,” age Yesus iyo do weng boyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Kale Yesus iyo asok bogobe-nala e, “Ibaa. Sok dum ilang kayaak imi asok tolon-tema uyo, iyo sok dum ilang tiin molin tinum bilip iyo intaben nubelan-tema a? Ibo ipmi aget fugunin uyo, intaben o agan-bilip o?” age-nala e, Yesus iyo dagala e, ");
INSERT INTO tlf_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","kamogimal iyo Yesus imi weng uyo yan kebe-nilip e, “Kamogim beyo tebe tinum mafak bilip iyo inola kaal fuyap utama-bom kaanipta bole, tiin molin tinum migik ulu kolata, ita tebe-nilipta, imi sok dum ilang uyo tiin mo-bilipta bii, suun kup sok dum uyo abulu kalaa age-nilip e, sok dum ok uyo ilan-bii kobelip ipkumal iyo molipta bole, sok dum ilang kayaak iyo imi tisol atuk uyo suun kup tambaliim kupka-eman-temip o,” age kamogimal iyo kam agan-bilip ko. ");
INSERT INTO tlf_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kale Yesus iyo bogobe-nala e, “Tiin molin tinum tebe-nilip sok dum ilang kayaak imi man angkolip kaanba bilip iyo siin sugayok kutop umi ogok kemin tinum migik imi kanu-bii-silip ilitap kale, God imi suuk kon tem uyo imi sang uyo bogo-nulu e, ‘Ogok kemin tinum iyo am uyo dinan-bomta kek fenipta e, am kun maak boyo mafak kalaa age-nilip e, falang daa kwaalip yak magaang tem kwek iinu kuta, kamok iyo am kun uyo utam-nala e, “Boyo tambaliim kale, am duu umi dol keluk o,” age-nala e, am kun boyo asok kwep mek molata, boyo felepmu molu ko. Kale kamogim kanubela beyo God yagal kale, nuyo utamupta e, imi kanubela boyo fen tambaliim kalaa age-sulup o,’ agesu kale, ibo boyo tiki-bom utamsip kuta, ibo, intaben o age-nilipta, bomi magam uyo tele utamsaalip a? ");
INSERT INTO tlf_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ibo nimi weng kaa bogolan-temi koyo tele tolong do-silipta. Siin uyo God iyo Juda kasel ipmi win uyo, ‘Nimi unang tinum o,’ age-nalata, imdep mitam nalami daam tem daalan o agan-bii-se kuta, kamano koyo God iyo utamata, ibo umik ugopnelip kalaa age-nalata, God isiik ibo umik ugobe-nalata, yak unang tinum asit kek kek ita ulu-nalata, bogobe-nala e, ‘Ibo dital fagaa nimi weng uyo tinangku waafulip umdii, nisiik ibo imdep mitam nalami daam tem daalan-temi o,’ agan-be ko. ");
INSERT INTO tlf_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Aa mungkup tuum afalik maak albu kale, tinum dok ita kumen malaak tuum diim kubela umdii, beyo mafaganan-tema e minte, tuum boyo dagaa kutiga malaak tinum bemi diim abelan-temu uyo, atin dupdaak tamalu telela tebelan-tema o,” age Yesus iyo ilami sang uta felep yak am kun so tuum afalik so umi diim to-nalata, bagama ko. ");
INSERT INTO tlf_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kale tinum amem ko age pris imi kamogimal isino Falosi sino iyo Yesus imi do weng alop boyo tolong do-nilip e, utamipta e, beyo numi sang baga-e-be kalaa age-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","sok de dolum o agelip kuta, utamipta, unang tinum kwiin tagang iyo aget fugun-bom-nilip e, Yesus beyo God imi profet ko age weng kem baga-emin tinum o ageta deng taban-bilip kalaa age-nilipta, kamogimal iyo unang tinum imi atul uta finano-nilipta, sok de dolin-tem dupkalip ko. ");
INSERT INTO tlf_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesus iyo asok unang tinum imi do weng maak bogobe-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Son-temu nala God tebe ilami unang tinum tiin molan-tema kota, iyo kamok king kemi sang bogolan o agan-bii kemi kanumsa ulutap kanuman-tema ko. Kale tam kamogim imi man iyo, unang kulan o agela e, imi aalap iyo, iman tigi-e-bilita, man iyo unang kulak o age-nala e, ilami ogok kemin tinum imi bogobe-nala e, ‘Unang tinum iyo olabeli kale, ibo iman uyo fuu-bii-nilipta, unang tinum iyo bogobelip tala tala kelipta, nusino iman uyo unan-kulum o,’ agela e, tinangkulip ko. ");
INSERT INTO tlf_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kale iman uyo telelalip e, kamogim iyo ilami ogok kemin tinum imi bogobela e, iyo daage no unang tinum siin olabeba bilip iyo bogobe-nilip e, ‘Kota tilipta, iman unan-kulum o,’ agelip kuta, unang tinum bilip iyo kupkalip ko. ");
INSERT INTO tlf_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kale kamogim iyo asok ilami ogok kemin tinum iyo migik imdala weng kwep no unang tinum bilip iyo bogo-nilip e, ‘Nugumal ibaa. Numi kamogim imi weng kaa bogobelan-temup koyo tinangku-silipta. Beyo bogo-nala, “Nimi ogok kemin tinum iyo tebe-nilip kao kwiin kiim sino kao man kagum sino duula-bii ko-nilipta, fuu-bii kulep tal to-nilip e minte, alugum mufekmufek uyo telela ko no kelip kale, kota tilipta, nusino iman boyo unan-bom-nulupta, nimi man unang kula umi deng uyo tebemum o,” agela weng kwep tulup o,’ agelip kuta, ");
INSERT INTO tlf_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","unang tinum bilip iyo aa mungkup kamogim imi weng uyo kwaasulebe-nilip e, yagalami ogok uta kem une-bala tele-bala kemip kale, tinum olabeba bilip iyo, maak iyo no ilami iman ilang uta digin-bala e minte, maak ita no ilami stuwa kutam kal ogok ke-bala no ke-bilip e, ");
INSERT INTO tlf_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ipkumal milii ita minte kamogim imi ogok kemin tinum iyo yaafu-nilip e, saal dagan-bii inolip kaanip ko. ");
INSERT INTO tlf_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kale kamogim iyo tinangku-nala e, iyo olsak afalik kup tebebelu e, ilami waasi dinan-kalin tinum iyo imdala no tinum tebe-nilip ilami ogok kemin tinum inobip bilip iyo waasi dinin isiik tebe inolip kaanip e minte, imi abiip uyo kwegalip ken tebebe no kelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kale ilami ogok kemin tinum milii iyo olabela tal tamip bogobe-nala e, ‘Nimi iman uyo telelabip kuta, unang tinum bogobebi iyo kuguup mafak ku-nilipta, tilin-tem kelip kale, bilip iyo nimi iman uyo unelan-temaalip kale, ");
INSERT INTO tlf_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ibo no abiip maak maak kugol unang tinum kwiin tagang iyo itam-nilip alugum kulep tilipta, iman uyo unan-bomta, deng tebemum o,’ age-nala e, imdala unip ko. ");
INSERT INTO tlf_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kale ogok kemin tinum iyo no abe abiip maak maak uyo tiine-bom-nilip e, unang tinum itamip iyo tambal sino mafak sino alugum afeta kulep tal kamogim imi am to to ke-bilip bii, am uyo alugum dongenu ko. ");
INSERT INTO tlf_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Kale kota kamogim iyo tal unang tinum kulep mitam tolip tonbip bilip iyo itaman te yang abomu e, tinum maak iman tigi-bom deng tebemin umi ilim tambal kobelip uyo migilin-tem ke-nalata, ilami ilim mafak uta kup migi tal tonba kalaa age-nalata, ");
INSERT INTO tlf_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","kamok iyo tebe bogobe-nala e, ‘Nugum kabaa. Nimi man tinum iyo unang kulata, imi deng uyo taban-bulup kale, kabo intaben o ageta nimi ilim tambal kopkelip uyo migilin-tem ke-nalapta, mitam talap o?’ agela e, tam tinum beyo fitom tebepmu weng umaak bogolin-tem kela e, ");
INSERT INTO tlf_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","bole kamogim iyo ilami ogok kemin tinum iyo bogobe-nala e, ‘Ibaa. Tinum kemi yaan sino sagaal sino uyo sok deebe-nilip sililii duptamo tam abiip mililep tem kutam kal daalipta, “Kwiin ko so intaben o ageta ka-tele talbi o,” agan-bom ilami kaal kalan uyo amemak o,’ age kamok iyo bogobelata, kanube-silip ko. ");
INSERT INTO tlf_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Ulutap kale, God iyo unang tinum kwiin tagang iyo bogobe-nala e, ‘Ibo nimi finang mitam nimi daam tem e tilipta o,’ agela kuta, unang tinum kwiin tagang iyo imi weng uyo kwaasule-bilipta, unang tinum iip maak maak ita kup mitam God imi daam tem e talan-nuubip o,” age Yesus iyo do weng bomi magam uyo bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kale Falosi iyo Yesus imi weng boyo tolong do-nilip e, Yesus beyo sok de dolum o age-nilip e, daage yang kweng kal weng de ko-nilip e, Yesus beyo bisop bogo weng umaak dagalupta, weng mafak umaak bogola kalaa age-nulupta, aafuu dep no weng telelmin baan diim daalin o age-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","bole tam ilimi okumop man sino minte King Herot imi ipkumal sino iyo imdalip no Yesus iyo daga-nilip e, “Kafalemin tinum kabaa. Nuyo katamsup kale, kabo win soyaap tinum sino win binim tinum sino iyo kuguup tambal uyo maagup kupka-e-bom-nalap e minte, kabo tinum iyo maak imi atul uyo finan-nuubaalap kale, kabo suun kup dam weng uta kup baga-e-bom-nalap e, God imi weng so imi kuguup, ‘Kanumin o,’ agan-be so uyo ku-nalapta, fen tuluun weng uta kup unang tinum iyo kafale-bom no kem-nuubap kale, ");
INSERT INTO tlf_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","mufekmufek maak umi sang uyo dagalum o ageta kale, (Rom kasel imi ulo uyo bogo-nulu, ‘Ibo ipmi takis mani uyo numi King Sisa ilami gavman imi kupka-emin o,’ agelu e minte, Juda kasel numi ulo uta bogo-nulu, ‘Ibo ipmi mani uyo God imi kupka-emin o,’ age no kesu kale,) numi mani uyo Sisa imi kupka-emum bele, God imi kup kupka-emum a? Kapmi aget fugun-balap uyo bogobelapta, utamum o,” agelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kuta Yesus iyo imi aget mafak fugun-bilip boyo utamepmata e, kanubelupta, weng mafak umaak bogola kalaa agelum o agan-bilip kalaa age-nalata, bogobe-nala e, “Bisop bagamin ibo intaben o age-nilipta, beyo bisop bogobelupta, weng mafak umaak bogolak o nagan-bilip a? ");
INSERT INTO tlf_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takis mani kuga-emin umaak kwep tilipta, utamum o,” agela e, no tuumon uyo kwep tal daabelip e, ");
INSERT INTO tlf_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","utam-nala e, dagala, “Yak tuumon diim sinik so win so kwep yak daasip koyo waami sinik so win so uta albu o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","tam Yesus imi weng uyo yan kebe-nilip e, “Boyo Sisa imi sinik so win so o,” agelip e, Yesus isiik bogobe-nala e, “Kanubelu kale, tuumon kanupmin koyo Rom kasel King Sisa ilami tuumon kale, ibo Rom kasel imi gavman ilami kupka-e-bom-nilip e minte, God imi mufekmufek ugol mungkup God imi kupka-e-bom no kemin o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","iyo tinangku-nilip e, kumang mo fitom tebebelu e, Yesus iyo dupka-nilip e, daaginip ko. ");
INSERT INTO tlf_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kale Juda kasel imi kamogimal iip maak maak iyo Sadusi o agan-nuubip kale, bilip iyo baga-bom-nilip e, “Unang tinum kaanan unsip iyo asok fen tigi molan-temaalip o,” agan-nuubip kale, am ko daan bom-sulu kota, Sadusi iip maak maak iyo, (no Yesus iyo bong faga-bom yan kemin weng umaak dagalupta, unang tinum iyo utamipta, umi magam uyo tele dupkop daalin-tem kela kalaa age-nilipta, aban faga-emin o age-nilipta,) tal ");
INSERT INTO tlf_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Yesus imi bogobe-nilip e, “Kafalemin tinum kabaa. Nuyo weng maak dagalum o ageta kale, sugamiyok uyo Moses iyo God imi ulo uyo numi kobesa kale, umi atuk uyo bogo-nulu, ‘Kanube tinum iyo man umaak fogolin-tem som-nala kalel uyo kupkaa kaana umdii, imi niing yagal tebe imi fik imi kaluun uyo kula agam imi man fagaman-temip uyo, iyo bogobe-nala, “Ibo nimi baap imi man o,” age-nalata, siin fik kaan-se imi mufekmufek uyo man bilip imi kuga-emin o,’ agesu kale, ");
INSERT INTO tlf_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","uyo tinangku-salapta. Siin uyo tinum maak nusino bii-se kale, beyo man tinum ninggil ilimi kup ban kal kale, ninggil maagup te tam fito-nilip e, tam fik diil isiik unang ku-siit man umaak fogolin-tem ke kaana e minte, ilami aafuu dep tilin ita tebe-nala e, fik imi kaluun boyo kula kuta, ");
INSERT INTO tlf_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","yagal asok man umaak fogolin-tem ke kaana e, niing iip maak yagal mungkup kanube no kela e, mungkup imi nagalal ninggil kutop igil mungkup figal imi kaluun boyo ku-nilip e, alugum maagup maagup iyo man umaak fogolin-tem ke-nilip e, kaana kaana kelip e minte, ");
INSERT INTO tlf_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","unang uta minte aaltam kota kaan no ke-suu ko. ");
INSERT INTO tlf_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kale tinum ban kal bilip iyo unang maagup bota kup maak isiik ku-siit kupkaa kaana kaana kem top ninggil ban kal kano biniman-silip kale, son-temu nala tinum ninggil ko kaan-silip bilip imi asok fen tigi molan-temip uyo, unang boyo waami kalel kelan-temu a? Kapmi aget fugun-balap uyo bogobelapta, utamum o,” agelip e minte, ");
INSERT INTO tlf_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesus isiik imi weng uyo yan kebe-nala e, “Ibo God imi suuk kon tem weng uyo tele dagaa kulin-tem ke-nilip e minte, tele utamipta, God beyo atin titil kup tebesa kalaa agelin-tem ke no kesip atamta, ipmi aget uyo mafak fugun-bilip kale, ");
INSERT INTO tlf_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","tinangku-silipta. Son-temu nala unang tinum kaansip imi asok fen tigi mo tam God imi abiip suun kup nan-temip uyo, unang dula-bala tinum dula-bala keman-temaalip kale, bilip iyo mitam migik ke-nilipta, abiil tigiin umi ensel ilitap kelan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Kale minte ipmi weng bogo-nilip, ‘Unang tinum kaansip iyo kaan atin binimansip kale, God iyo tebe maak ifola fen tigi molan-temaalip o,’ agan-nuubip bomi sang uyo bogobelan o ageta kale, tinum kaansip imi asok fenan-temip umi sang uyo God yagal bogola ilami suuk kon tem uyo dola kosipta, ibo tikim-nuubip kuta, boyo tele utamsaalip ko. Iyo bogo-nala, ");
INSERT INTO tlf_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Niyo Abraham so ilami man Aisak so ilami man ilop Jekop so ulimal imi God iyo o kalbi o,’ age sugamiyok tinum kaansip imi sang bogosa kuta, God iyo tinum kaan-nilip binimansip imi tiin mosaala kale minte, tinum kaan-nilip no God imi diim suun nuubip sino tinum kafan albip sino ita tiin mosa (kale mungkup, God imi weng ko Moses imi bogobesa bomi magam uyo dok uta ba kale, Abraham ulimal bilip iyo sugayok uyo kaansip kuta, fen God imi tiin diim uyo atin albip kalaa age-nalata, ulimal iyo tiin mo-bom-nalata, bogo-nala e, ‘Niyo ulimal imi God iyo kalbi o,’ agesa) o,” age Yesus iyo imi weng uyo yan kebela ko. ");
INSERT INTO tlf_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kale unang tinum kwiin tagang iyo Yesus imi weng kafale-bom baga-e-be uyo tinangku-nilip e, kumang mo aget afalik fugunip ko. ");
INSERT INTO tlf_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kale Sadusi iyo Yesus imi kam agela uyo tinangku-nilip e, imi weng uyo yan kepman-temaalup kalaa age weng bagamin binim sining age tonip kalaa age-nilip e, Falosi igil mungkup tala tala ke weng ang uyo de ko kupkaa tal-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ninggil ilimi ulo utamin tinum maak, niyo bisop bogo bisop weng umaak Yesus iyo daga-nilita, utamita, Yesus iyo weng mafak umaak bogola kalaa agelan o age-nalata, ");
INSERT INTO tlf_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Yesus iyo daga-nala e, “Kafalemin tinum kabaa. Ulo God imi suuk kon tem kwek albu uyo, dogonupmin ulo uta kwiin kiim o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesus iyo imi weng uyo yan kebe-nala e, “‘Kabo ki atuk atuk kemin ba kale, kapmi aget aa bubul aa uyo alugum Bisel kapmi God imi kobe-nalap e, minte kapmi aget fugunin uyo alugum kobe no ke atin imi ilak uyo fomtuup duga-bom-nalapta o,’ agesu uyo bota ko. ");
INSERT INTO tlf_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Boyo God imi ulo kwiin kiim kale, uta uta ke ulo migik uyo kubaganu kupkasu ko. ");
INSERT INTO tlf_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kale God imi ulo maak uyo kulutap kale, uyo bogo-nulu, ‘Kabo kalapmi kaal umi ilak do tambaliim tiin mobap ulutap ke kapkumal kek kek imi ilak uyo do telelemal o,’ agesu kale, ");
INSERT INTO tlf_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ulo alop boyo kwiin kiim kale, alop boyo alugum God imi ulo migik Moses imi dola kosa sino God imi weng kem kobela ilami profet imi dola kosip so umi magam uyo kulbu o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Kale Yesus iyo utamata, Falosi kwiin tagang iyo tal bom albip kalaa age-nala e, dagala ko. ");
INSERT INTO tlf_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ibo, ‘God imi ulaa dula kamok kesa tinum beyo waanta o?’ agan-bilip a? Beyo waami man ilop tiilam unsu kutop umi tinum o?” agela e, isiik bogobe-nilip e, “Beyo King Devit imi man ilop o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","44","tam Yesus iyo bogobe-nala e, “Sugamiyok uyo God imi ulaa dula kamok kesa tinum iyo daala tal kafin diim koyo tilin-tem bom-salata, God imi Sinik iyo aget fugunin uyo King Devit imi kobelata, yagal bogo-nala, ‘Bisel God iyo tebe nimi Kamogim iyo bogobe-nala, “Kabaa. Te yang nalami ipkuk ilo kamogim imi baan diim kagal ton-balapta bii, atin ki nita nita ke-nili kapmi waasi iyo kubaganip imkali kalaa age-nalapta, kapta iyo tiin molan-temap o,” age God iyo bogobesa o,’ age Devit iyo bogosa ko. Kale Devit iyo intaben o age-nalata, ‘Beyo nimi Kamogim o,’ agesa a? ");
INSERT INTO tlf_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ibaa. God imi ulaa dula kamok kesa tinum beyo dok imi man a? Kanube Devit imi aget uyo fugunolata, son-temu uyo, beyo nalami man ilop kutop ita maak mitam tebelan-tema kalaa age-nala bomi aget uta kup fuguno-nala bogosa nimnam, boyo bogo-nala, ‘Beyo nimi Kamogim o,’ agesaala binim kuta, Devit iyo intaben umi aget uta fuguno no ke-nalata, bogo-nala, ‘Beyo nimi Kamogim o,’ agesa o?” age Yesus iyo Falosi imi dagala ko. ");
INSERT INTO tlf_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kale tinum iyo maak bagang-kaleta, Yesus imi kam agela boyo yan kepman-temaalup kalaa age-nilip e, weng umaak bogolin-tem ke-nilip e, am ko daan-bom-sulu kwek uyo, alugum kamogimal iyo Yesus imi weng atul finano-nilip e, maak so daga-nimip binim ke kwep unip ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kale Yesus iyo ilami okumop man sino unang tinum kwiin tagang sino iyo bogobe-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“God iyo ulo utamsip tinum sino Falosi sino ita ulaa imdulata, God imi ulo Moses dola kosa uta kafalem-nuubip kale, ");
INSERT INTO tlf_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","bilip imi tebe ipmi kafale-bom-nilip e minte, weng baga-e-bom no kem-nuubip boyo tambaliim kup tinangka-bom waafu-bom-nilipta o ageta ko. Kuta bilip iyo God imi ulo ipmi kafalem-nuubip boyo igil tinangka-bom kanum-nuubaalip kale, kwaasulem-nuubip kale, ibo imi kuguup kanu-bilip kulutap uyo waafunamin ba ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kale unang uyo mufekmufek iluum digi talan-bulu umi ipkum bisop talan-bo uta tebe mufekmufek uyo maak sino kulep iit tip tobe yakyak keman-temu boyo kuguup mafak kale, ulutap mungkup, kamogimal bilip iyo tebe unang tinum imi bogobe-nilip, ‘Ibo numi weng kem tagang baga-em-nuubup boyo tele tinangka-bom-nilipta o,’ agan-bilipta, waafulum o agan-nuubip kuta, bong fagan-bii umtal daasip kuta, kamogimal iyo tebe i-filin daa-nilipta, dong daga-em-nuubaalip kale, bogal mungkup kuguup mafak no ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kale bilip iyo, numi kuguup uyo alugum kanu-bulupta, unang tinum iyo itam-nilipta, numi win uyo kufu-emin o age-nilipta, kanum-nuubip kale, imi kanum-nuubip umi kuguup uyo ki, God imi suuk kon tem weng uyo bogo-nulu, ‘Ibo God imi weng atuk uyo suuk kon diim dola ko-nilipta, ang de ko kwep yak ilipmi tibit kun diim sino ilipmi butu kun diim sino kugol delip bom-buluta, tiine-bom-nilipta o,’ agesu kuta, kamogimal bilip iyo dola-nilipta, ang afalik kup dinan-bii kulep yak ilimi kaal diim uyo dinan-bii tiinan-bomip kale, ulutap mungkup, ilimi ilim magaang diim uyo ket kon kwiin tagang uyo kulep yak tom-nuubip ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kale kamogimal imi daage no tinum kamok sino iman unan-kulum o agelip uyo, iyo daage no abiin tambal kamok imi mep sino kugol tonamum o agan-bom-nilip e, daage no ulotu am unip ugol mungkup, no kamogimal imi abiin kal tonupta, unang tinum ita itama-bom-nilipta, numi win uyo kufu-emin o age-nilipta, kanu-bom no kem-nuubip ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kale minte iyo daage no iman saanin baan diim unipta, unang tinum iyo tebe-nilip kamogimal imi kanu-emin kuguup uta ku-nilipta, fet duga-e-bom imi ipkumal iyo baga-e-bom-nilip e, ‘Bilip iyo God imi ulo kafalemin tinum ita o,’ agelin o age-nilipta, kanu-bom no kem-nuubip ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Kale nimi okumop man ibo kamogimal bilip imi kuguup kanu-bilip kulutap uyo waafunamin ba ko. Kale nimi okumop man ipmi kafalemin tinum iyo kwiin tagang ba kale, maagup nita kup kale, ibo maak ita win tibin e minte, maak ita win binim no ba kale, ninggil alugum maagup ilatap ilatap ke-bom albip kale, ibo kamok ko age ilimi win kufum yakyak kemin kulitap mungkup ipkil kanu-bilip unang tinum iyo itam-nilip ibo, ‘Kafalemin tinum o,’ agan-bom ipmi win uyo kufu-emin ba ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ulutap kale, ipmi god iyo kwiin tagang ba kale, ipmi Aalap abiil tigiin kayaak God maagup ita kup kale, kafin diim koyo ipkil tinum maak beyo kamok o age-nilip, ‘Beyo numi Aatum o,’ agan-bom imi win uyo kufu-emin ba ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ulutap kale, God imi ulaa nimdula kamok kesi tinum nita kup ipmi Kamogim kale, kabo kamok ko age ilimi win kufum yakyak kemin kulitap mungkup kapkal ke-balap kapkumal iyo tebe bogopke-nilip, ‘Kamogim o,’ agan-bom kapmi win uyo kufukemin ba ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Boyo atin kanumin ba kale, ipmi iibak tem kutam uyo waantap ita kamok umdii, beyo ipmi bisop misiim dong daga-emin tinum iyo kulba ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tinum dogap ita ilimi win uyo kufu-bom-nilip e, ‘Nuyo kwiin kiim o,’ agan-kalip umdii, biilan-temu uyo, God iyo bogobe-nala, ‘Nimi tiin diim uyo kanupmin tinum ibo kubaganip win binim o,’ agelan-tema kale minte, tinum dogap ita ilimi win uyo kufumin binim ipkumal bisop dong daga-emip umdii, biilan-temu uyo, God iyo kanupmin tinum bilip imi win uyo kufu-e-bom bogobe-nala, ‘Nimi tiin diim uyo ibo kwiin kiim o,’ agelan-tema o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Kale Yesus iyo asok ulo utamsip tinum sino Falosi sino imi bogobe-nala e, “Ulo utamsip tinum sino Falosi sino ibaa. Tinangkulin. Ibo bisop bagamin kuguup uta waafulin tinum kale, unang tinum iyo, mitam God imi daam tem tulum o agelip uyo, ibo bogobe-nilip kano, ‘Kamaki uyo numi weng kem kwiin tagang kosiik waafu-nilipta o,’ agan-nuubip kale, ibo kanu-bilipta, iyo bong faga-bom-nilipta, iip maak maak ita kup mitam God imi daam tem uyo e talan-nuubip ko. Ibo ipkil tam God imi daam tem uyo unin-tem ke-bom-nilipta kale, ipkil tebe unang tinum, tam God imi daam tem unum o agan-bilip imi ilep uyo ugaa kwaaga-em-nuubip kale, son-temu uyo, bomi kalan uta God iyo tebe ibo kaal fuyap uyo kupka-eman-tema kale, tele utama-bom-nilipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Kale ulo utamsip tinum sino Falosi sino ibo bisop bagamin kuguup uta waafulin tinum kale, ibo unang kaluun iyo filto-em tolom-nilip e, imi sinamin am uyo bugubelip kupkaa am binim, mufekmufek binim ke-bom no kem-nuubip ko. Kale kanupmin kuguup mafak mafak boyo kanu-bilip kuta, ibo unang tinum imi tiin diim uta God imi aman duga-emin uyo timitim kemup ko age bisop baga-bom no kem-nuubip kale, son-temu uyo, bomi kalan uta God iyo tebe ibo kaal fuyap kwiin kiim uyo kupka-eman-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kale ulo utamsip tinum sino Falosi sino ibo bisop bagamin kuguup uta waafulin tinum kale, ibo bogo-nilip, ‘Unang tinum asit kek kek iyo aget fupkela ko-nilip Juda kasel numi kuguup uta waafulin o,’ age-nilipta, ibo ki kafin diim ilep e minte bot tem ilep no unanbu no abiip migik migik kugol weng boyo baga-em tiinan-nuubip kale, tinum iyo maak ipmi weng uta tinangku imi aget uyo fupkela ko ipmi okumop man kela umdii, ibo kafale-bilipta, begal mungkup kuguup mafak uyo kanu-bala bii, ipmi kuguup mafak boyo kubaganuta, imi kuguup mafak uta uta kelan-temu ko. Kale son-temu uyo, bomi kalan uta ipsino isino ibo alugum no abiip mafak unipta, God iyo kaal fuyap uyo kupka-eman-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kale ibo tiin tugul ilitap kale, ibo bagang-kale ilep no God imi daam tem unemin uyo unang tinum iyo kafalem-nuubaalip ko. Kamogimal ibo bogo-nilip, ‘Kabo kapkum imi diim kal weng kwep daabe-nalap, “Kanubelan-temi o,” agelan-temap uyo, God imi ulotu am miton umi win kamkaam uyo kufo-nalap kapmi weng boyo kuntuk mobelap umdii, kapmi weng kwep daalap bomi ilo kolan-temap uyo weng binim kuta minte, kapmi kapkum imi diim kal weng kwep daabelan-temap uyo, gol kulu dis telela ko kwep God imi ulotu am daasip umi win kamkaam uyo kufo-nalap kapmi weng boyo kuntuk mobelap umdii, kapmi weng kwep daalap bomi ilo kolan-temap boyo mafak kale, kapkal boyo waafulan-temap o,’ agan-bom kafalem-nuubip kale, son-temu uyo, ipmi kanupmin kuguup mafak ko kafalem-nuubip bomi kalan uta God iyo kaal fuyap uyo kupka-eman-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kuta ibo kanupmin magam binim weng boyo intaben o ageta bagan-bilip a? Ulotu am miton boyo God imi am e minte, win so no kale, am boyo uta uta ke-nuluta, dis min, mufekmufek am kutam albu boyo kubaganu kupkasu ko. Ibo tiin tugul ke ilum ilum bii tonsip utamta, weng kanupmin boyo bagan-nuubip kuba. ");
INSERT INTO tlf_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ulutap kale ibo bogo-nilip, ‘Kabo kapkum imi diim kal weng kwep daabe-nalap, “Kanubelan-temi o,” agelan-temap uyo, tuum kulu tul fagasip umi diim mufekmufek fuu-bii God imi kupka-emin umi win kamkaam uyo kufo-nalap kapmi weng boyo kuntuk mobelap umdii, kapmi weng kwep daalap bomi ilo kolan-temap uyo weng binim kuta minte, kapmi kapkum imi diim kal weng kwep daabelan-temap uyo, mufekmufek tul diim kenan-bo umi win kamkaam uyo kufo-nalap kapmi weng boyo kuntuk mobelap umdii, kapmi weng kwep daalap bomi ilo kolan-temap boyo mafak kale, kapkal boyo waafulan-temap o,’ agan-bom kafalem-nuubip kale, son-temu uyo, ipmi kanupmin kuguup mafak ko kafalem-nuubip bomi kalan uta God iyo kaal fuyap uyo kupka-eman-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kuta ibo kanupmin magam binim weng boyo intaben o ageta bagan-bilip a? Tul boyo mufekmufek God imi kupka-emin umi baan diim e minte, win so no kale, tul boyo uta uta ke-nuluta, mufekmufek tul diim albu boyo kubaganu kupkasu ko. Ibo tiin tugul kesip utamta, weng kanupmin boyo bagan-nuubip kuba. ");
INSERT INTO tlf_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kale ulotu am miton umi tul sino mufekmufek tul diim albu sino boyo alop kano God imi kale, tinum iyo maak tebe tul umi win kamkaam uyo kufola umdii, boyo mufekmufek tul diim albu bomi win kamkaam usino kufolan-tema uyo kulbu kale, ");
INSERT INTO tlf_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ulutap mungkup, ulotu am miton boyo God imi am kale, tinum iyo maak ulotu am miton umi win kamkaam uyo kufola umdii, boyo God kutam alba imi win kamkaam usino kufolan-tema uyo kulbu kale mungkup, ");
INSERT INTO tlf_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","God beyo abiil tigiin kayaak kale, tinum iyo maak abiil tigiin umi win kamkaam uyo kufola umdii, boyo God imi abiin tonba umi win kamkaam usino God ilami win kamkaam usino kufolan-tema uyo kulbu ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kale ulo utamsip tinum sino Falosi sino ibo bisop bagamin kuguup uta waafulin tinum kale, ibo unan-kalin kangkang min, dugol min, kumak min iyo ilo do dep ku daa yakyak kelip baan nagaal kal keluta, baan maagup ita kup God imi dupka-em-nuubip kale, ibo God imi ulo waafuu ise mufekmufek win binim bomi aget uta ugel kala ko kanum-nuubip kuta, ulo umi mufekmufek win so umi aget uta ilumano kup-kagan-nuubip kale, boyo ki ibo ipkumal iyo alugum maagup kuguup tambal uta kup kupka-e-bom e minte, ipkumal iyo i-filin daa bet bubul kupka-e-bom e minte, ipkumal iyo dam weng baga-e-bom no kemin kale, ibo bomi aget uyo ilumano kup-kagan-nuubip kale, God iyo ipmi deng uyo tabanbaala binim kale, son-temu uyo, bomi kalan uta God iyo kaal fuyap uyo kupka-eman-tema ko. Ipmi mufekmufek baan fagagan-bii nagaal kal kelu baan maak God imi kupka-em-nuubip bota tambaliim kuta minte, kuguup tambal win so boyo kanu-bom no ke-bomta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kale ibo tiin tugul ilitap kale, tinum tiin tugul beyo ipkum iyo ilep uyo kafaleman-temaala kale, ulutap kamogimal ibo unang tinum iyo kuguup tambal umaak kafalem-nuubaalip ko. Ibo weng kem kangkang uta waafu-nilipta minte, ulo win so uyo waafunamin binim kale, ibo tinum kemi sang bogobelan-temi kalatap kale, tam tinum iyo, ok unelan o age-nalata, katop fenata, imi ok tet tem kutop uyo ol beleng maak kaanba kalaa age-nala e, ok boyo sing daa kwaala daak iinu kupka-nalata minte, sinogim maak ok tet tem kulagal mungkup kaanba uyo utamin-tem ke-nalata, ok kufak daabu uyo maagalo une-se ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kale ulo utamsip tinum sino Falosi sino ibo bisop bagamin kuguup uta waafulin tinum kale, ibo dis so kap so uyo mitam kaal diim uta diing dagan-nuubip kuta minte, iibak tem kulaak uyo diing dagan-nuubaalip kale, kulaak uyo ninak so kup-kagan-nuubip kale, ulutap mungkup ibo, mufekmufek bo nulumi kup keluk o age-nilipta, ipkumal imi mufekmufek uta yuguut daga-e-bom-nilip e minte, asit kup dagaga-bilip ipkumal imi mufekmufek uyo kupka-e-bom no kem-nuubip kale, ipmi iibak tem kutam uyo ninak tebe kufak daasu kale, son-temu uyo, bomi kalan uta God iyo kaal fuyap uyo kupka-eman-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kale Falosi ibo tinum tiin tugul ilitap kale, ibo tet tem kulaak usiik suubalan-temip uta, mitam kaal diim ugol mungkup ninak binim tambalan no kelan-temu kale, ulutap mungkup, ipmi aget mafak fugunin uyo kupka-nilip aget fupkela kolan-temip uta, ipmi kuguup ugol mungkup tambal ke no kelan-temu ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kale ulo utamsip tinum sino Falosi sino ibo bisop bagamin kuguup uta waafulin tinum kale, ibo begel ilet tem ulutap kale, tip katam uta atin tambaliim telela kosip ulutap kuta minte, iibak tem kulaak uyo tinum imi dam so kun so sing daga-bom-nulu tang mafak kuun-bo kulaak uyo unang tinum iyo tele utabaalip kale, ");
INSERT INTO tlf_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ulutap mungkup, unang tinum iyo ipmi kaal diim boyo utamipta e, ibo tol kup tinum kalaa agan-nuubip kuta, ipmi iibak tem kwek uyo ilipmi bisop bagamin sino minte kuguup mafak migik sino uta tebe-nuluta, ifak daasu kale, son-temu uyo, bomi kalan uta God iyo kaal fuyap kupka-eman-tema o,” age Yesus iyo ulo utamsip tinum sino Falosi sino iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Kale Yesus iyo kamogimal imi asok bogobe-nala e, “Ulo utamsip tinum sino Falosi sino ibo bisop bagamin kuguup uta waafulin tinum kale, ipmi olal iyo God imi profet ko age weng kem baga-emin tinum sino tol kup tinum migik sino iyo an-bii kulep no iman-bii-silip kale, ipkil, imi duu diim uyo tambalanuk o age-nilipta, tuum uyo kulep ilaga-e-bom-nilip e minte, at ket san uyo u-e-bom no ke-bom-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","bogo-nilip e, ‘Nuyo sugayok uyo numi olal sino nusino maagup som-nulupta umaak nimnam, numi olal imi tebe God imi profet ko age weng kem baga-emin tinum inolip kaan-silip kulutap nugol mungkup kanubesaalup o,’ agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ipmi kam agan-bilip boyo ki, ibo bogo-nilip, ‘Nuyo God imi profet ko age weng kem baga-emin tinum ino-silip imi man ilop o,’ agan-bilip kale, ibo aafen ilitap ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kamaki uyo ipmi olal iyo kanupmin kuguup mafak bota waafu-bom-nilipta, God imi nimdula kamok kesi tinum niyo nangkolip kaanan-temi kale, son-temu uyo, bomi kalan uta God iyo kaal fuyap kupka-eman-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Inap tebe tinum an-bom ifak dagan-nuubip ilitap kale, ipsino e minte ilipmi olal sino ibo tinum iyo ifak dagan-nuubip kale, son-temu uyo, bomi kalan uta God tebe imdala no abiip mafak suun kup at kenamin kugol ken tebeman-temip ko. Ibo aget fugunota, ‘Waalanan-temup o,’ agan-kalin ba kale, fen ibo no at kenamin abiip boyo unon-temip kuba. ");
INSERT INTO tlf_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Nimi weng kaa bogolan-temi koyo tolong do-silipta. Tam nimi profet ko age weng kem baga-emin tinum sino weng magam dagaa kusip tinum sino e minte kafalemin tinum sino iyo imdali no tolon-temip kuta, nimi utabi uyo, ibo tebe iip maak maak iyo inolip kaanip e minte, iip maak maak iyo ino kulep yak at diim kal dii-nilip e minte, iip maak maak iyo kulep no ulotu am kal saal daga-bom-nilip e minte, iip maak maak ita dubak kobe kulep yak abiip maak maak kem tiine-bom no keman-temip kalaa agan-bii kale, ");
INSERT INTO tlf_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","kanuman-temip bota God iyo tebe kaal fuyap uyo kopman-tema ko. Sugayok kamaki kutop ilota kwep talanbu tal kaa diibelu koyo, ipmi olal ita tebe-nilipta, tol tinum iyo yan tebesip ko. Kamaki uyo Kein isiik tebe ilami niing tambal Abel iyo angkola kaanata bole, kulota God imi ogok kemin tinum iyo an tebesipta kwep talanbu tal ipmi olal ita Berekia imi man Sekaraya iyo no God imi am amem kek e minte mufekmufek fuulip ken tebemin baan diim kek no umi iibak tem kugol molata, angkolip kaan no kesa kale, God yagal ipmi olal imi fengmin kuso minte ilipmi fengmin kusino bomi kalan uta kwego dego ke-nalata, God iyo kaal fuyap uyo ibo kobelan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kale niyo dam weng uyo asok bogobelan-temi kale, God yagal alugum ipmi olal imi fengmin bomi yan uyo tinum kamano albip ipmi kobelan-tema o,” age Yesus iyo ulo utamsip tinum sino Falosi sino imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Minte Yesus iyo Jerusalam kasel imi aget fuguno-nala e, aget iluum tebepmuta, unang tinum iyo bogobe-nala e, “Jerusalam kasel ibaa. Ibo God imi profet ko age weng kem baga-emin tinum iyo ye-bilip kaana-bilip e minte, ibo God ilami kalaan tinum imdala tal tal kem tebesip iyo tuum tuup ye-bilip kaana-bilip no kem-nuubip kuta, kanube uun ogen umi man uu kulep ulumi bal kun tem to uksum-nuubu ulutap kale, am kwiin tagang daanan mitam iinan-nuubu koyo, niyo alugum maagup ibo imdep meng daa nalami sagaal uyo ku daam fogobe imam daalan o agan-kalin kup tebesi kuta, nimkalip boyo kanum-nuubaali binim kuba. ");
INSERT INTO tlf_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ibaa. Ipkil umik ugopnelip kale, God isiik ibo umik ugobe-nalata, waasi iyo imkala tal-nilipta, ipmi abiip kuso ulotu am miton so uyo kufak daalipta, unang tinum iyo alugum ilimi abiip boyo kupkaa bilii daagina tala kelan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kale niyo tuluun weng uyo bogobelan-temi kale, ibo maak so nitamin-tem bom-bilip bii, ipkil bogo-nilip, ‘Numi Kamogim keyo God kapmi win tolop diim tala kale, kabo kuguup tambal uta kup kupka-e-balapta o,’ agan-kalon-temip o,” age Yesus iyo bogola ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kale Yesus iyo ulotu am miton uyo kupka-nala e, daaginon o agan-kala e, kota ilami okumop man iyo tal bogobe-nilip e, “Kamogim kabaa. Yak am tambal ko utamal o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesus isiik bogobe-nala e, “Kamano kota kek fen tuum kulep yak tip tip ke am tambal desip boyo utaman-bilip kuta, nimi weng kaa bogobelan-temi koyo tele tinangku-silipta. Biilan-temu uyo, waasi iyo tal am boyo alugum dalata ko bomi tuum tambal uyo segela kululip daak abe-bulu bii, biniman ugulumi kup nu nu kelan-temu o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kale Yesus sino ilami okumop man so ilisinon daage tam Oliv Tigiin kal Yesus iyo tona e, okumop man iyo meng daga-nilip e, “Kamogim kabaa. Dogap kota waasi iyo tal-nilipta, ulotu am miton boyo dalata kolan-temip a? Minte dogonupmin umi kuguup usiik mitam tuluta, utamupta e, koyo kapmi asok talap kafin binimanan-temu uyo mep tulu kalaa agon-temup o?” agelip e minte, ");
INSERT INTO tlf_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesus isiik ninggil imi weng boyo yan kebe-nala e, “Tele utama-bom-nilipta. Bisop weng bagamin tinum bilip imi weng uyo tinangkamin ba ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tinum kwiin tagang iyo tal nimi win uta dugola kufu-bom bogo-nilip e, ‘Niyo God imi ulaa nimdula kamok kesi tinum o,’ agina agina ke-bilip e, unang tinum kwiin tagang iyo imi weng boyo, ‘Fen o,’ age tinangku yang iinon-temip kale, ibo imi weng bagan talan-bilip uyo tinangkamin ba ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kale ibo tolong dolipta, tinum miit maak iyo fiko kulep no daala tinum miit maak so waasi dinan-bala e minte, am waasi uyo ugaa kulu dinan-bala no ke-bilip uyo mitam senganu kalaa agon-temip uyo, ibo boyo, ‘Afungen tem mitam tulu o,’ age-nilip bomi atul uyo finanin ba ko. Kanupmin kuguup bosiik mitam tolon-temu kuta, boyo kanum ti-suluta, kutam-tele am afungen uyo yuut mitam tolon-temaalu ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kafin maak umi tinum iyo kafin migik tinum sino dinan-bilip e minte, kamok maak imi tinum igil kamok migik imi tinum isino dinan-bilip e minte, kafin kaa kutufosu koyo iman tebok mitam tele-bulu e minte, bim afalik mitam tele-bulu no keman-temu kuta, ");
INSERT INTO tlf_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","kaal fuyabok ko kugaman-temip bota kup kulan-temaalip kale, boyo tiinuta, aaltam uyo kaal fuyap kwiin tagang uyo maak so mitam tal tal ke-bom binimanuta, kota afungen tem uyo tolon-temu ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kale ibo nimi ilak uyo duga-bom nimi ogok ke-bilip kale, bomi kalan uta abiip maak maak tinum kwiin tagang iyo tebe ibo olsak kupka-e-bom itafinon-bom-nilipta, yaafu-nilip e, sok de imdep no kamogimal imi diim daabelipta, kamogimal ilimi kayaam bogobelipta, ita inolip kaanaman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kale kanum tolon-temu kota, nimi ilak dolin kwiin tagang iyo nimi ilak dugamin uyo kupkaa umik ugopne-nilip e, iyo ilimi duup-afin nimi ilak suun kup dugan-bilip imi waasi kebe itafinon-bom-nilip e, imdalip no waasi imi sagaal diim abeman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kale biilan-temu uyo, bisop bagamin tinum kwiin tagang iyo tal bogo-nilip e, ‘Nuyo God imi profet ko age weng kem baga-emin tinum o,’ agelip e, unang tinum kwiin tagang iyo imi bisop bagamin weng boyo tinangku-nilip e, kupkaa yang iineman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kale kanupmin kuguup bomi kanuman-temip kota, unang tinum kwiin tagang imi kuguup mafak uyo kwiin kiim keluta, imi ipkumal aget kupka-emin uta katip katip kem top binimanan-temu ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kuta nimi ilak dolin unang tinum dogap ita kaal fuyap uyo utama-bom-nilip kupkaa yang iinemin binim, suun kup nimi ilak uyo fomtuup duga-bilip bii, kaanip umdii, bilip iyo God yagal tebe imtamo tam ilami abiip daalata, suun kup nan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kale nimi unang tinum ibo no abe kafin kaa kutufosu komi abiip maak maak uyo tiine-bom-nilip alugum unang tinum iyo bogobe-nilip, ‘Yesus iyo kaan-nala ipmi ilim bobe-se kale, ipmi aget uyo fupkela ko-nilipta, Yesus imi ilak uyo dolipta, God yagal tebe imtamo no ilami abiip tambal daalan-tema o,’ age baga-em tiinemin o ageta kale, bomi kanubelip binimanan-temu kota, afungen tem umdii tolon-temu o,” age Yesus iyo ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Unang tinum nimi suuk kon dola-bii umi tiki-bilip ibaa. Yesus imi weng bogo-se umi dola kolan-temi koyo tele utamin o ageta ko. Kale Yesus iyo asok ilami okumop man iyo bogobe-nala e, “Sugamiyok uyo God imi profet ko age weng kem baga-emin tinum Daniel iyo God imi suuk kon tem uyo dola ko bogo-nala kano, ‘Biilan-temu uyo, Jerusalam kutam kal waasi ita tebe-nilipta, mufekmufek fen mafak maak kwep tam God imi ulotu am miton kutam daalipta, uta mitam-nuluta, atin God imi am uyo kufak daalu mafaganan-temu o,’ agesa kale, ibo utamipta, mufekmufek mafak boyo kwep tam God imi am amem daalip molu kalaa agon-temip uyo, ");
INSERT INTO tlf_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ibo Provins Yuudiya kagal albip umdii, ipmi abiip uyo kupkaa bilii daage no amdu tem tem kal waanamin ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Minte ibo am abal diim kal albip umdii, asok tam am mufekmufek umaak kulep-nulupta o age tam unemin ba kale, boyo kupkaa yuut bilii no waanamin ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Minte ibo ilipmi ilanggiip kal albip umdii, asok abiip uyo no ilim umaak kulep-nulupta o age asok daage abiip unemin ba kale, ilanggiip uyo kupkaa yuut bilii no waana-bom no kemin ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Minte bomi mitam tolon-temu uyo, unang kumun so so e minte unang manok so bilip iyo bilii unemin umi ilep uyo bong faga-bom-nilip e minte, kaal fuyap kiim uyo kwaa-bom no keman-temip kale, niyo bilip iyo i-filin-bii ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kale am mafak daanu min, God imi ifin am daanu min uyo kanupmin mufekmufek mafak boyo mitam tulu umdii, ibo bagang-kaleta yuut bilii unomip binim kale, ibo God iyo bogobe-nilip, ‘Am mafaganu uyo, kabo mufekmufek mafak boyo kupkalap mitam telemin ba o,’ agan-bom aman duga-e-bilipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kale sugamiyok God imi kamaki kafin telela kosa kulota kwep tal kaa diibelu koyo, kuguup mafak kwiin kiim kanupmin bomi ko mitam tolon-temu kulutap uyo maak mitam tisaalu kale, son-temu nala mitam iinon-temu uyo, maak so aaltam uyo kanupmin kuguup mafak kwiin kiim boyo asok maak so mitam tolon-temaalu ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kuta God iyo ilami unang tinum ulula ilami ilak dolan-temip imi i-filin daa-nalata, bogo-nala kano, ‘Kaal fuyap umi am daan tolon-temu boyo yuut te top iinu binimanuk o,’ age bogosa kale, kanupmin weng boyo bogosaala binim nimnam, son-temu uyo, unang tinum iyo alugum kaan binimanan-temip kuta, weng boyo bogosa ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Am ko daanan-temu kota, kanube tinum iyo maak ibo bogobe-nala, ‘God imi ulaa dula kamok kesa tinum Krais iyo mep kalba kale, atamin o,’ agela min, ‘Yang kulba beyo atamin o,’ agan-be min uyo, ibo, ‘Fen o,’ agan-kalin ba ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kale nimi weng kaa bogoli koyo dok uta ba kale, bisop bagamin tinum iyo tebe-nilip e, God imi ulula ilami ilak doiin unang tinum ibo bisop bogobe-nulupta, ipmi aget fugunin uyo kufak daabelupta, yang iinin o age-nilipta, ipmi finang uyo teleman-temip kale, maak iyo tal bogobe-nala e, ‘Niyo God imi ulaa nimdula kamok kesi tinum Krais o,’ agela e, minte maak iyo tal bogobe-nala e, ‘Niyo God imi profet ko age weng kem baga-emin tinum o,’ agela no keman-temip kale, iyo mirakel ko age kuguup ugulumi migik migik uyo kafaleman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kale nimi aget fugunin uyo, kanupmin kuguup bomi mitam tolon-temu uyo ki, ibo kanupmin bisop bagamin tinum bilip imi weng uyo tinangku-nimip o age-nilita, mitam tilin-tem bom-suluta, kamaa kagal bomi sang uyo bogobeli kale, nimi weng koyo tele tinangku utama-bom-nilipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ulutap kale, kanube tinum iyo maak ibo bogobe-nilip, ‘God imi ulaa dula kamok kesa tinum Krais iyo unanbu no iibaan kugol alba kale, nota atamum o,’ agelip umdii, ibo unemin ba ko. Aa mungkup ulutap kale, maak bogobe-nilip, ‘God imi ulaa dula kamok kesa tinum Krais iyo yak am kutam kal ipkumal so alba o,’ agelip umdii, ibo weng boyo tinangka-bom no kemin ba ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kale Mo Tibil imi Man nimi asok tolon-temi uyo, bamalaang famalaak mo alugum abiil so kafin so ilagenabu ulutap ke-nilita, asok tilita, alugum kafin diim unang tinum iyo nitaman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Kale ibo utamipta e, uun dimduum kaanin unan-kalin iyo kwiin tagang tam abiil tigiin kugol sigin-bilip kalaa agelip umdii, boyo ipkil utamipta e, bilip iyo dimduum umaak kaanebelu uta-bomta sigin-bilip kalaa agelan-temip kale, ulutap mufekmufek sang nimi bogobeli bomi mitam tulu umdii, kota ibo utamipta e, nimi tolon-temi uyo digibanu kalaa agelan-temip o,” age Yesus iyo ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Kale Yesus iyo tam ilami okumop man imi bogobe-nala e, “Kanupmin kuguup mafak mafak boyo mitam iinu binimanuta, kota tam ataan uyo miliil molu e minte, kayop umi dong ugol mungkup binimanu e minte, biningok ugol mungkup abiil tigiin uyo kupkaa duk finano malaak abe-bulu e minte, iit abiil kun diim umi mufekmufek titil tebesip igil mungkup ilimi ilep uyo kupkaa sigin-bii ilep migik ilep tiine-bala tiine-bala ke-bom no keman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kale kafin diim komi tinum miit maak maak nimi ilak dolin binim iyo abiil tigiin kiit fen mufekmufek maak utamipta e, Mo Tibil imi Man iyo iip tem tem ku-tele talanbu tal-bom-nilita, titil kiim uyo ku imi dong uyo tiin bulusii kup sigin-bii talan-be kalaa age-nilipta, fomtuup finan-bom-nilip e, ameman-temip kale, ");
INSERT INTO tlf_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","iyo fongket weng kiim ko age bigul weng kiim uyo tinangkulan-temip ko. Kale niyo nalami ensel iyo imdali unanbu no kafin kaa kutufosu komi magaang tem kugol God imi unang tinum ulula ilami ilak dolin iyo afeta ko-nilipta, nimi finang kulep tolon-temip o,” age Yesus iyo ilami okumop man bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Kale Yesus iyo asok do weng maak bogobe-nala e, “At umi aget uyo fugunolin. Ibo yet bomi kuguup uyo utamipta, umi kon uyo bam daa kalunganu umdii, boyo umi dum abumin uyo mep so tulu kalaa agelan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ulutap kale, utamipta, nimi kuguup kanum tolon-temu umi sang baga-em tebesi uyo mitam tulu kalaa agelan-temip kota, ibo utamipta, boyo nimi tolon-temi umi am uta mep so tulu kalaa agelan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","“Kale nimi weng bogobelan-temi koyo tinangku-silipta. Unang tinum iip maak maak kamano tiin kafan albip iyo kaanin-tem bom-silipta, nimi weng bogobe-nili, ‘Son-temu uyo, mufekmufek mafak mafak uyo mitam Juda kasel imi diim abelan-temu o,’ agebi uyo mitam tolon-temu ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Am maak daanan-temu kota, abiil so kafin so uyo binimanan-temu kuta minte, nimi weng uyo biiluta, binimanan-temaalu binim kale, suun kup bom tuluun kup nan-temu o,” age Yesus iyo do weng boyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Kale Yesus iyo bogobe-nala e, “‘Beyo dok kota tolon-temi o?’ nagan-bilip aga? Kafin diim komi tinum iyo utamsaalip e minte, abiil tigiin kasel ensel iyo utamsaalip e minte, God imi Man nagal mungkup utamsaali no kale, boyo nimi Aatum God maagup ita kup utamsa ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Mo Tibil imi Man niyo asok tilin-tem bom-bili uyo, unang tinum imi kuguup kanuman-temip uyo sugayok Noa imi sip ko age bot afalik dinan-bala unang tinum kuguup kanumsip ulutap ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Sugayok Noa imi bom-bala ok umi fogo tilin-tem bom-sulu uyo, unang tinum iyo (God imi ilak uyo dolin binim ke-bom-nilip e,) iman unan-bom-nilip e, ok unan-bom no ke-bom-nilip e, tinum iyo unang dula-bilip e, unang iyo tinum dula-bom no ke-bilipta bii, Noa iyo imi sip kiim uyo dinan-bii, binimanu kupka-nala e, Noa ulimal iyo tam sip tem unip ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Unang tinum bilip iyo utamipta, ok uyo fogo tolon-temu kalaa agelin-tem ke-bilip e bole, ok uyo fogo tal-nulu e, unang tinum iyo alugum mimilepmu kaansip ko. Ulutap kale, unang tinum iyo God imi ilak uyo dolin-tem bom-bilipta bii, Mo Tibil imi Man niyo tolon-temi ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nimi tolon-temi kota, tinum alop iyo maak iman ilang digin-bilip e, ensel iyo tal maak ulaa dep unom-nilip e, maak ita dupkaa unon-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ulutap kale, nimi tolon-temi kota, unang alop umaak iman telela-bilip e, ensel iyo tal maak ulaa kwep unom-nilip e, maak uta kupkaa unon-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kale ibo utamta, ipmi Kamogim niyo dok kota tolon-tema kalaa nagebaalip kale, ibo suun kup telel-bom bigi-bom-nilipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nimi do weng katip kaa bogobelan-temi koyo tele tolong do aget fugun-bom-silipta o ageta ko. Kale tinum am kayaak iyo utamata, mililep uyo dok kota tinum yuguut unin iyo tolon-tema kalaa ageba nimnam, beyo kafan bom bigilata, tinum yuguut unin beyo dogobeta talta am boyo dalata ko-nalata, tam imi mufekmufek uyo dugu kulube mitam iinbaala ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kale ulutap ibo utamipta e, Mo Tibil imi Man niyo dok kota tolon-tema kalaa nagebaalip kale, maagalo tem kale, suun kup bigi-bom telel-bom-nilipta o,” age Yesus ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Kale Yesus iyo ilami okumop man imi do weng maak bogobe-nala e, “Niyo tinum ogok fomtuup kanu-bom aget tambal fugun-bom no kemin tinum imi sang uyo bogobelan o ageta ko. Kanupmin ogok kemin tinum ilami kamogim iyo ulaa du bogobe-nala e, ‘Kabo nimi ogok kemin tinum bilip iyo tambaliim kup itama-bom tiin molapta, ogok tambal kup ke-bilipta, nimi mufekmufek uyo tambaliim kup bom-buluta, iman taga-emin ulumi am daanan-temu kota, iman uyo ogok kemin tinum imi taga-emal o,’ age bogobe-nalata, dupkaa unon-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kale ogok kemin tinum beyo kamogim imi weng uta tinangku-nala imi ogok uyo waafulin kup ke-bom ogok kema umdii, kamogim iyo asok tal abomu, tambaliim kup ogok ke-be kalaa age-nalata, deng tebeman-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kale kamogim iyo bogobe-nala e, ‘Utamita, niyo kugol bomta, katamin-tem bom-bilita, ogok tambal uyo kem-nuubap kalaa ageli kale, ogok afaligen uyo kapmi kopkelita, kapta nimi mufekmufek uyo alugum tiin molan-temap o,’ agelan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kuta kanube ogok mafak kemin tinum iyo aget fuguno-nala e, ‘Nimi kamogim iyo mufekmufek migik maak tebe daak tamalu kale, yuut tolon-temaala binim o,’ age-nala, ");
INSERT INTO tlf_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ipkumal ogok kemin tinum iyo ye-bom-nala, ok mafak unan-bii ilum ilum kemin tinum sino ton-bom iman unan-bom ok mafak unan-bom-nala, ");
INSERT INTO tlf_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","kamogim iyo dok kota tolon-tema kalaa age fenin binim ke-bom no kema umdii, bom-balata, am maak daanu e, kamogim iyo talta utamata e, kuguup mafak kem tebesa kalaa age-nala e, imi kuguup mafak umdii yan ke-e-bom ");
INSERT INTO tlf_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","fomtuup saal daga-bom kaal fuyap kupka-eman-tema uyo kuguup alop waafuna-bom weng kwaasulmin tinum imi kaal fuyap kupka-emin ulutap mungkup kupka-e-balata, ogok mafak kemin tinum iyo bogo-nala e, ‘Kwiin ko so kubo?’ agan-bom-nala e, fomtuup ameman-tema o,” age Yesus ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Kale Yesus iyo asok do weng maak bogobe-nala e, “Son-temu nala nimi tili God tebe alugum unang tinum tiin molan-tema bomi sang uyo felep yak ku to bogobelan o ageta ko. Tinum maak, unang kulan o agelata, unang umi ogen so aalap so iyo, ‘O,’ agelip suu nala e, kota kula dula kemin umi am uyo mitam daanu e, unang bomi dong daga-emin unang kapket nagaal kal maak ilimi ilaam uyo kulep-nilip e, ipkum umi aalap imi am uyo kupka-nilip e, tam abal diim kugol ton-bom tinum tal unang kulan-tema bemi fenip ko. ");
INSERT INTO tlf_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Kale unang ogal kalip ita aget tambal fugunin kale, bilip imi mufekmufek uyo telelalip e minte, unang ogal maak kalip ita aget tambal umaak fugunin binim kale, bilip imi mufekmufek uyo telelalin-tem ke-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ilimi ilaam uyo kefo kulep unip kuta, ilaam umi ok uyo maak ilu kulep ilin-tem kelip e minte, ");
INSERT INTO tlf_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ipkumal aget tambal fugunin ita ilimi ilaam uyo ilu ko kefo kulep som-nilip e minte, umi ok uyo aa migik ilu kulep no kelip e, mangkal unip ko. ");
INSERT INTO tlf_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kale unang mangkal bilip iyo ton-bom bigi-biita e, tilin-tem kela kalaa age-nilip e, tiin ak tebebelu e, agaal unip ko. ");
INSERT INTO tlf_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Kale mangkal agaal bom-bilipta bii, am tiip tiip faa-bulu e, kota tinum maak ola-nala e, bogola ko. ‘Tinum, unang kulan o agan-be iyo kota tala kale, kamano kota yuut tal duptamo am iinin o,’ age olan-kala e, ");
INSERT INTO tlf_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","unang nagaal kal iyo tinangku-nilip e, fen mitam ilaam uyo telela ko-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","unang tele aget fugunin binim iyo utamipta e, numi ilaam kenamin ok uyo mep so binimanan o agan-bo kalaa age-nilip e, ipkumal unang aget tambal fugunin imi bogobe-nilip e, ‘Numi ilaam uyo ok binim kelu kale, tenolan-temu kale, ipmi ilaam ok umaak sing daabelipta, numi ilaam uyo delalup kena-buluta, mangkal unum o,’ agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","aget tambal fugunin unang iyo tebe aget tambal fugunin binim unang imi weng uyo yan kebe bogobelip ko. ‘Umbae. Numi ilaam umi ok uyo katip kale, ipmi atuk sing daabe no kelan-temup bole, alugum numi ilaam uyo yuut tenolan-temu kale, ipkil no stuwa kal ilaam umi ok umaak mo-nilipta, dela kulep tilin o,’ agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","unang aget tambal fugunin binim iyo daage no stuwa kal ilaam umi ok uyo fen unip e, kota tinum, unang kulan o agan-be iyo tal mep so tala kalaa age-nilipta, unang mangkal ogal telelabip iyo no tinum iyo abu daa-nilip e, duptamo tam am daalip e, kota alugum iyo iman unan-bilip e, ogok kemin tinum iyo tebe faal uyo ilolip ko. ");
INSERT INTO tlf_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Kale siit ilugolip e, unang ogal maak iyo tal ola-nilip e, ‘Numi duup kabaa. Ogok kemin tinum bilip iyo bogobelap faal bitolipta, nuyo tam tulupta o,’ agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","tinum kamaa unang digin kela beyo unang mangkal bilip imi weng uyo yan kebe-nala e, ‘Umbae. Ibo nimi duubal ba kale, niyo ogok kemin tinum iyo bogobeli faal uyo bitobelan-temaalip o,’ age-nalata, unang aget tambal fugunin binim imi baga-emsa o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kale asok Yesus iyo ilami okumop man imi bogobe-nala e, “Do weng bomi magam uyo tele aget fugunolin. Ibo utamta, niyo dok kota tolon-tema kalaa nagebaalip kale, ibo suun kup telel-bom bigi-bom-bilipta o,” age Yesus iyo bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Kale Yesus iyo do weng migik maak baga-ema ko. “Son-temu nala am ko daan bom-sulu tolon-temi kota, God imi tebe tinum maak yegemsa ulutap ke unang tinum iyo yegeman-tema ko. Kale tinum beyo, unanbu no abiip simanim maak kugol bii ilugo-nilita, asok tolon-temi kalaa age-nala e, ilami ogok kemin tinum iyo olabela tal tamip e, ilami mani min, mufekmufek uyo alugum kwaapma yak bilip imi sagaal diim abelu ko. ");
INSERT INTO tlf_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kale iyo utamata e, iip maak maak bilip iyo aget tambal kup fugunin e minte, iip maak maak bilip ita aget tambal fugunin tap so kalaa age-nala e, mani bisel uyo kwaapma yak aget tambal kup fugunin bilip imi sagaal diim abelu e minte, mani katip uta kwaapma yak ipkumal imi sagaal diim abe no kelu e, maak beyo K5,000 kobe-nala e minte, maak beta K2,000 kobe-nala e, maak beta k1,000 kobe no ke-nala e, ‘Boyo kulu-nilip bisnis ke-bom mani kwaane-bilipta o,’ age kupka-nala e, daagina ko. ");
INSERT INTO tlf_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kale kamogim iyo daagina e, kota tam ogok kemin tinum K5,000 kulula iyo waafuu bisnis ke-balata bii, mani uyo kwiin kiim ke K10,000 kelu e, ");
INSERT INTO tlf_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","mungkup ogok kemin tinum maak imi K2,000 kulula yagal mungkup mani uyo kulu bisnis ke-balata bii, mani uyo kwiin kiim ke K4,000 ke no kelu kuta minte, ");
INSERT INTO tlf_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ogok kemin tinum maak K1,000 kulula iyo waafu-nala e, bisnis kemin binim ke-nala e, kulep yang kafin fogo-nala e, ilami kamogim imi tuumon uyo kubabela ko. ");
INSERT INTO tlf_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Kale biilu e, kota ogok kemin tinum imi kamogim iyo asok tal abiip tal-nala e, imi mani uyo dogonubeta waafuu bisnis kem-nuubip kalaa agelan o age-nalata, ilami ogok kemin tinum asuno iyo olabela tal-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","tam kamaki uyo ogok kemin tinum K5,000 kulu-se isiik tal-nala e, asok K5,000 sino minte K5,000 migik kuluba sino uyo kobe bogobe-nala e, ‘Kamogim kabo ko utamal a. Niyo kapmi K5,000 kopnin-salap uyo kulu bisnis ke-bom-nilita, K5,000 migik koyo kulu no kelita, kusino kusino K10,000 kebu o,’ age kobela e, ");
INSERT INTO tlf_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","utam-nala e, kota kamogim isiik bogobe-nala e, ‘Suguul ke kabo ogok kopkin-sii boyo kupkasaalap kale, kabo fomtuup dital fagaa tambaliim kup kem tebesap kale, mufekmufek katip ita ko tambaliim kup tiin mosap kalaa age-nilita, niyo kota mufekmufek kwiin kiim uyo kwaapkeli yak kapmi sagaal diim abeluta, waafu-nalapta, tiin molan-temap ko. Kale mitam talapta, ninggil maagup deng tebemum o,’ agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Minte ogok kemin tinum K2,000 kulu-se iyo tal kamogim imi bogobe-nala e, ‘Kamogim kabaa. Ko utamal a, Niyo kapmi K2,000 kopnin-salap uyo kulu bisnis ke-bom-nilita, K2,000 migik koyo kulu no kelita, usino usino K4,000 kebu o,’ age kobela ");
INSERT INTO tlf_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","kamogim iyo utam bogobe-nala e, ‘Suguul ke kabo ogok kopkin-sii boyo kupkasaalap kale, kabo fomtuup dital fagaa tambaliim kup kem tebesap kale, mufekmufek katip ita ko tambaliim kup tiin mosap kalaa age-nilita, niyo kota mufekmufek kwiin kiim uyo kwaapkeli yak kapmi sagaal diim abeluta, waafu-nalapta, tiin molan-temap ko. Kale mitam talapta, ninggil maagup deng tebemum o,’ age no kela ko. ");
INSERT INTO tlf_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Minte aaltam kota ogok kemin tinum K1,000 kulu-se iyo tal bogobe-nala e, ‘Kamogim kabaa. Katamsi kale, kabo alaang bubul dolin tinum kale, kabo tinum migik ulu kululap no kapmi ilanggiip ogok uyo kanukem-nuubip kuta, iman min, unan-kalin fagam-nuubip uyo kapkal tebe kwan-nuubap e minte, kabo tinum migik iyo kululap no kapmi mufekmufek uyo ipkumal kopmip saan-nuubip kuta, kapta mani uyo kwan-nuubap no kale, ");
INSERT INTO tlf_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","niyo kapmi atul finano-nili e minte, bisnis kemin kuguup umaak utamin-tem ke no ke-nilita, niyo kapmi tuumon boyo kulep no-nilita, kafin fogo-nilita, kubapkelita, tambaliim kup nuubu kale, kalapmi tuumon kotam o,’ age kobela e, ");
INSERT INTO tlf_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","tam kamogim iyo ilami ogok kemin tinum iyo bogobe-nala e, ‘Kabo ogok kemin tinum mafak e minte, daal tebemin tinum no kuba. Kabo bogopne-nalap, “Kabo tinum migik ulu kululap no kapmi ilanggiip ogok uyo kanukem-nuubip kuta, iman min, unan-kalin fagam-nuubip uyo kapkal tebe kwan-nuubap e minte, kabo tinum migik iyo kululap no kapmi mufekmufek uyo ipkumal kopmip saan-nuubip kuta, kapta tuumon uyo kwaa-bom no kem-nuubap o,” nagelap ko. ");
INSERT INTO tlf_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kale kabo kanupmin aget uyo fugunoli kalaa agelap uyo, intaben o age-nalapta, nimi mani boyo kulep no beng tem tolapta, nimi mani uyo sengansaalu a? Kanube-salap nimnam, niyo asok talta mani bisel kululi kuta, boyo kupkalapta, niyo tal-nilita, nimi mani atuk uyo kululin-tem ke-nilita, asok nalami K1,000 dopkin-sii ita kup dululi o,’ age-nala e minte, ");
INSERT INTO tlf_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ilami dong daga-emin tinum albip bilip imi bogobe-nala e, ‘Ibaa. Yak imi sagaal diim mani waafuba boyo kulu-nilip tinum K10,000 kuluba so bemi kobe no kelin a. ");
INSERT INTO tlf_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nimi kam ageli bomi magam uyo ki, tinum waantap ita ogok tambal ke-bom-nala e, imi kamok imi weng uyo tinangka-bom no keman-tema uyo, bemi kamok iyo tebe ogok uyo maak so kobelata, ogok kwiin kiim uyo ke-bom-nala e minte, mani kwiin tagang uyo kwaa-bom no keman-tema kale minte, tinum waantap ita ogok uyo mafak ke-bom-nala e, imi kamok imi weng uyo kwaasule-bom no keman-tema uyo, bemi kamogim iyo tebe-nala e, fot tebelata, ogok umi tisol uyo maak so kwaaman-temaala ko. ");
INSERT INTO tlf_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kota ogok kemin tinum ogok kemin binim keyo daalip tam abiip mililep tem kutam iinom-nalata, bogo-nala, “Kwiin ko so intaben o ageta ka-tele talbi o?” agan-bom-nala e, fomtuup ameman-tema o,’ age kamogim iyo ogok kemin tinum tiin molin imi bogobe-se o,” age Yesus iyo bogola ko. ");
INSERT INTO tlf_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Kale Yesus iyo bogobe-nala e, “Biilan-temu kota, Mo Tibil imi Man niyo tebe God imi ensel iyo alugum kulep tal tolita, bilip iyo nimi tok uyo baga-bilipta, nagal kamok king ke-nilita, nimi titil afalik uyo ku-nilita, alugum unang tinum iyo tiin molan-temi kale, ");
INSERT INTO tlf_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ensel ita tebe-nilipta, kafin diim komi tinum miit maak maak iyo alugum afeta-bii kulep tal nimi diim tolipta, nagal tebe ilo kolita, miit alop kelan-temip ko. Kale niyo sipsip tiin molin tinum imi tebe-nala fen sipsip ugulumi fagaga-bom, minte meme ugulumi fagaga-bom no keba ulutap ke-bom-nilita, ");
INSERT INTO tlf_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","niyo unang tinum tambal ita kulep te yang nalami sagaal ipkuk ilo keng kal faga-nili e minte, unang tinum mafak ita kulep te yang sagaal afaan ilo keng kal fagaa no kelan-temi ko. ");
INSERT INTO tlf_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Kanubeli ila kolipta, Kamogim king niyo unang tinum nimi ipkuk ilo keng albip imi bogobe-nili e, ‘Kamaki nimi Aatum God kafin telela kosa kota, God iyo, abiip tambal uyo unang tinum tol kup tebesip imi o age-nalata, telela kobesa kale, God iyo ipmi deng kup taban-be kale, ibo mitamta tambaliim suun kup bom-bilipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kale nimi Aatum imi tebe ipmi deng taban-be bomi magam uyo dok uta ba kale, siin uyo niyo iman tep bom-bili uyo, ipta iman kopnelip une-sii e minte, niyo ok tep tebepne bom-bulu uyo, ipta ok ilu kopnelip une-sii e minte, niyo fital kale, tilita, ipta bogopne-nilip, “Suguul ke talap o,” nage nimdep tam am daa-silip e minte, ");
INSERT INTO tlf_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","niyo ilim binim uyo, ipta ilim kopnelipta, migi-sii e minte, niyo mafak bom-bili uyo, ipta dong dogopne-silip e minte, niyo sok de namolip bom-bili uyo, ipta tal dong daganemin weng tambal uyo bagane-bilipta, nimi bubul uyo tambalanepne no ke-suu kalaa age-nalata, bota God iyo ipmi deng uyo taban-be o,’ ageli e, ");
INSERT INTO tlf_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","tol kup unang tinum iyo nimi weng uyo yan kepne-nilip e, bogolip ko. ‘Kamogim kabaa. Nuyo utamupta, kuguup tambal boyo maak kabo kupkake-bulup kalaa agansaalup kuba. Nuyo dok kota katamupta, kabo iman tep tebepkebu kalaa age-nulupta, iman uyo kopkelup une-salap a? Minte nuyo dok kota katamupta, ok tep tebepkebu kalaa age-nulupta, ok uyo ilu kopkelup une-salap a? ");
INSERT INTO tlf_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Minte kabo dok kota fital o age talapta, bogopke-nulup, “Suguul ke talap o,” age kamdep mitam am daa-sulup a? Minte nuyo dok kota katamupta, kabo ilim binim kalaa age-nulupta, ilim uyo kopkelupta, migi-salap a? ");
INSERT INTO tlf_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Minte nuyo dok kota katamupta, mafak albap kalaa kage-nulupta, dong dogopke-sulup a? Minte nuyo dok kota katamupta, sok de kamolip albap kalaa ageta tal dong dagakemin weng tambal uyo bagake-bulupta, kapmi bubul uyo tambalanepke no ke-suu o?’ agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kamogim nisiik tebe imi weng boyo yan kebe bogobe-nili e, ‘Niyo dam weng uyo ibo bogobelan o ageta kale, tinangku-silipta. Ipmi kafin diim bii-silip uyo, ibo kanupmin kuguup tambal boyo unang tinum win binim mitam nimi ilak dolin bilip imi kupka-emsip kuta, ipmi tebe ko imi kupka-emsip boyo nimi kupkanemsip uyo kulbu o,’ agelan-temi ko. ");
INSERT INTO tlf_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Kota fupkela afaan ilo keng fen-nili e, unang tinum mafak imi bogobe-nili e, ‘Sugamiyok kota God iyo abiip maak suun at kenamin kusino telela ko-nala e, bogo-nala kano, “Saatan isino ensel mafak ilami ogok kemin tinum kesip sino iyo imdali no at suun kenamin abiip kugol suun kup nan-temip o,” agesa kale, boyo ilipmi kuguup mafak bota God iyo ibo umik ugobesa kale, ibo nimka-nilipta, no abiip suun at kenamin kuunin a. ");
INSERT INTO tlf_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kale God imi tebe ipmi umik ugobesa bomi magam uyo dok uta ba kale, niyo iman tep bom-bili uyo, ibo iman umaak kopnelip unesaali e minte, niyo ok tep bom-bili uyo, ibo ok umaak ilu kopnelip unesaali e minte, ");
INSERT INTO tlf_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","niyo fital tilin kesi uyo, ibo bogopne-nilip, “Suguul ke talap o,” nage nimdep tam am daasaalip e minte, niyo ilim binim bom-bili uyo, ibo ilim umaak kopnelip migisaali e minte, niyo mafak bom-bili uyo, ibo dong dogopnesaalip e minte, niyo sok de namolip bom-bili uyo, ibo tal weng tambal uyo bagane-bilipta, nimi bubul uyo tambalanepne no kesaalu no kalaa age-nalata, bota God iyo ibo umik ugobesa o,’ ageli e, ");
INSERT INTO tlf_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","unang tinum mafak iyo nimi weng boyo yan kepne bogopne-nilip e, ‘Kamogim kabaa. Nuyo kabo bisat kamkasaalup kuba. Dok kota katamupta, kabo iman tep tebepkebu min, ok tep tebepkebu min, fital ke talap min, ilim binim min, mafak albap min, sok de kamolip albap min kalaa age-nulupta, nuyo dong dogopkelin-tem ke kamka-sulup o?’ agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Kamogim nisiik imi weng boyo yan kebe-nili e, ‘Niyo dam weng uyo ibo bogobelan o ageta kale, tinangku-silipta. Ibo tebe unang tinum win binim mitam nimi ilak dolin iyo umik ugobe-nilipta, dong daga-emin binim kemsip kuta, ipmi tebe imi kanu-emsip boyo nimi umik ugopne dong daganemin binim kemsip uyo kulbu o,’ agelan-temi ko. ");
INSERT INTO tlf_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Kale bomi kalan uta unang tinum dogap ita ipkumal dong daga-emin binim umdii, bilip iyo imdali no abiip mafak kugol kaal fuyap afaligen uyo suun kup utamaman-temip kale minte, tol kup unang tinum ita kulep no God imi abiip tolita, tambaliim kup suun kup nan-temup o,” age Yesus ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kale Yesus ilami okumop man ninggil imi ko kafale-be boyo alugum binimanu e, kota bogobe-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nugumal ibaa. Am alop maak binimanan-temu kota, Juda kasel numi iman ko age Pasova uyo tigiman-temup kalaa age utabip kale, kota Mo Tibil imi Man niyo Juda kasel imi kamogimal tebe nimdalip yak waasi imi sagaal diim abelita, nimdep yak at diim daa nangkolip kaanan-temi o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kale kota tinum amem ko age pris imi kamogimal sino Juda kasel imi kamok kamok sino iyo no tinum amem imi kamok miton ko age hetpris Kayafas imi am afek kutam kal angge ko-nilipta, ");
INSERT INTO tlf_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","weng en-bom-nilip e, kanube-nulupta, Yesus iyo maagalo bantap aafuta angkolup kaanak o age-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","bogolip, “Nugol unang tinum imi tala tala ke iman tigi-bom unan-kalon-temip umi tem kwegal angkolan-temup uyo, unang tinum kwiin tagang iyo, buuk o age-nilip e, tebe nuyo yan-togon-bom ye-bom keman-temip kale, dupkalup siit iman uyo alugum unelip binimanu daagina tala kelip kalaa age-nulupta, kota angkolum o,” age weng uyo de kolip ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesus ninggil iyo Oliv Tigiin uyo kupka-nilip e, no abiip Betani kutam iinip ko. Siin uyo Yesus iyo tebe Betani kutam tinum maak kaal mafak kesa Saimon iyo telela do-se kale, beta tal Yesus ninggil imi bogobe-nala e, “Tilipta, nimi am kal ton-bomta iman unelum o,” agelata, no imi am kal ton-bom ");
INSERT INTO tlf_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","iman un-silip e, unang maak tebe tang tambal kuunin ok uyo kwep tal Yesus imi dubom diim kal sing daabelu kale, ok boyo tuum alabasta tet tem kalo kolin kulaak umi tem abu kosip kale, unang boyo mani kiim ku mo kwep tal daabu kale, ");
INSERT INTO tlf_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yesus imi okumop man iyo utamipta e, unang boyo kanu-bo kalaa age-nilipta, olsak tebebeluta, tam unang uyo daga-nilip e, “Intaben nulan o age-nalapta, tang tambal kuunin ok boyo tugup daalap binimanu a? ");
INSERT INTO tlf_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tang tambal kuunin ok boyo kwep no kapkumal iyo kobelap iyo molipta, mani kiim uyo kulu-nalapta, mufekmufek binim unang tinum imi kobelan agin kuta, kupka-nalapta, tugup daalap binimanu o,” agelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kale Yesus iyo utamata e, kanupmin weng boyo unang bomi kupka-e-bilip kalaa age-nala e, imi okumop man iyo bogobe-nala e, “Intaben o ageta weng mafak bo unang boyo kupka-e-bilip aget afek fugun-bo a? Boyo kuguup tambal uta nimi kanupnelu kale, kupkalin a. ");
INSERT INTO tlf_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Unang tinum mufekmufek binim iyo ipsino suun kup bomip kale, ibo tii dong daga-em-nimip kuta, niyo suun kup kagal ipsino nan-temaali kale, ");
INSERT INTO tlf_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","unang boyo utamuta, Yesus iyo mep so angkolip kaana dep no tuum tem kal dubalan-temip kalaa age-nuluta, Juda kasel numi at kulu telela dep no dubamin kuguup uta ku-nuluta, tang tambal kuunin ok uyo nimi dubom diim kal sing daapnelu ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Kale koyo dam weng kup bogobelan-temi kale, son-temu nala unang tinum imi tebe kafin kaa kutufosu komi tiine-bom nimi weng tambal kupka-em tiineman-temip uyo, unang bomi kuguup tambal ko kopnelu bomi sang uyo baga-em tiine-bom-nilipta, bomi win uyo suun kufu-eman-temip o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kale Yesus imi okumop man tuluun kal kale, maak iyo abiip Keriot kayaak Judas ita kale, beyo no tinum amem ko age pris imi kamogimal iyo itam-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","dagala, “Ibaa. Kanube niyo tebe Yesus iyo daali yak ipmi sagaal diim abela umdii, mani uyo intap kal kopnelan-temip o?” agela e, imi weng bogola uyo tinangku deng kup tebe-bom-nilip e, tuumon kiim ulumi kup 30 kota kobelip e, ");
INSERT INTO tlf_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Judas iyo tuumon uyo kulu-nala e, dogobeta dupkem daalan o age-nalata, ilep uyo fena ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kale bret fitimin binim umi unan-kalin am kakat diim ko age ifin am uyo daanu e, Yesus imi okumop man iyo tal Yesus iyo daga-nilip e, “Kabo nuyo, no dogap kal iman ko age Pasova uyo telela kolin o agan-balap o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesus isiik bogobe-nala e, “Siin uyo Jerusalam kayaak tinum maak ipmi kafalebe-sii kale, ibo kamano koyo no Jerusalam kal tinum be atamip uyo, bogobe-nilip, ‘Kabaa. Numi kafalemin tinum imi weng kobela kwep tulup uyo bogo-nala e, “Nimi nugum kabaa. Nimi kaanan-temi uyo mep so tulu kale, nimi okumop man sino ninggil nuta tal kapmi am kal iman ko age Pasova boyo unan-bom deng tebe-bomta o,” age Yesus iyo bogop-kama o,’ agelin o,” age Yesus iyo weng kem uyo bogobe-nalata, okumop man iyo imdala ");
INSERT INTO tlf_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","no-nilip e, imi weng kup tinangku-nilipta, iman uyo kan kelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kale ataan uyo te yak tem iinu e, Yesus sino imi okumop man tuluun kal sino iyo tal am ugaa kubip kutam kal ton-bom ");
INSERT INTO tlf_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","iman uyo unan-bom-nilip e, Yesus iyo ilami okumop man imi bogobe-nala e, “Niyo dam weng bogobelan-temi kale, ninggil ipmi tinum maak ita tebe-nalata, nimkem daala nangkolan-temip o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","kota okumop man iyo Yesus imi weng bogola boyo tinangku aget yamyam fugun-bom du-filin-bom-nilip e, maak isiik Yesus imi dagala dagala ke-bom-nilip e, “Kamogim kabaa. Nita bele ki, naga ba o?” agan-bom aget yamyam fugunip e, ");
INSERT INTO tlf_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesus isiik bogobe-nala e, “Tinum maak nisino sagaal kwep yak dis tem kulagal dufala ko unela beta tebe nimkem daalata, nangkolan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Sugayok uyo God imi suuk kon tem uyo nimi kanube kaanan-temi bomi sang uyo bogosu kale, kamano kogal mungkup bomi sang uyo mitam tuluta, Mo Tibil imi Man niyo nangkolip kaanan-temi kuta, tinum nimi nimkem daalan-tema beyo atin kaal fuyap kup misamanan-tema kale, intaben o ageta ogen uyo beyo do-suu ee?” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","imi dupkem daalan o agan-be tinum Judas beyo Yesus imi bogobe-nala e, “Numi kafalemin kabaa. Kabo nimi sang bagane-balap bele ki, tinum migik imi sang baga-e-balap o?” agela e, Yesus isiik imi weng uyo yan kebe-nala e, “Dam bogolap kale, kapkal o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kale Yesus ninggil iyo iman unan-bilip e, Yesus iyo bret maagup maak ku-nala e, God iyo, “Misam o,” age kupkaa fegela ko imi okumop man iyo ife-bom-nala e, bogola, “Koyo nimi dam kale, ku-nilipta, unelin o,” agela e, ku-nilip e, unelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Unelip e, tam sok dum ok maak ilu ko-nala e, God iyo, “Misam o,” age-nala e, imi okumop man iyo ife-bom-nala e, bogobela, “Ibaa. Ninggil alugum ibo koyo ku-nilipta, unelin a. ");
INSERT INTO tlf_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Koyo nimi isak kale, nimi nangkolan-temip uyo, nimi isak uyo singkam daa-nulu God imi kamaa weng umi de koluta, ibo isak boyo utamta, boyo aafentap God iyo tebe unang tinum kwiin tagang numi fengmin uyo kupkan kebe-se kalaa agelan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kale niyo weng migik maak bogopman-temi kale, asok niyo sok dum ok boyo maak so unelan-temaali kale, kupkaa bom-bili bii, no nimi Aatum God imi abiip kugol ipsino bomta, alugum maagup nuyo sok dum umi kamaa ok uta unan-kalon-temup o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kale ninggil unelip binimanu e, alugum iyo God imi suuk kon tem aseng maak kulu kupka-nilip e, abiip uyo kupkaa yak abe Oliv Tigiin unip ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kale Yesus ninggil iyo ilep abe-bom-nilip e, Yesus iyo bogobela, “Kamano mililep uyo alugum ibo nimka-nilipta, bilii daaginon-temip kale, God imi suuk kon tem weng sugayok dola kosip uyo bomi sang uyo bogo-nulu e, ‘God nita waasi iyo imkalita, tebe sipsip tiin molin tinum iyo angkolipta, sipsip iyo alugum bilii daagine-bala tele-bala keman-temip o,’ agesu kale mungkup, ipta ko kanubelan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nita kanube kaani namalip siit-nilita, asok fen-nilita, no Provins Galili unon-temi kale, kota ibo nota kugol nitamin o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Kale Fita iyo boyo tinangku-nala e, Yesus iyo fomtuup bogobe-nala e, “Kamogim kabaa. Kapmi okumop man ninggil nuyo, alugum nugumal bilip ita kamkaa bilii unon-temip kale minte, niyo fen kamkaa bilii unon-temaali o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","minte Yesus isiik Fita iyo bogobe-nala e, “Nugum kabaa. Nimi weng kaa bogopkelan-temi komi aget uyo fugun-bom bom-salapta. Kamano mililep kota uun kakaluk aalap iyo olalin-tem bom-salata, kabo nimi sang uyo bogopne-nalap e, ‘Beyo nimi duup ba o,’ nage yakyak bii, ilep asuno fagalan-temap o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Fita iyo bogola, “Umbae. Boyo kanubelan-temaali kuba. Minte tam kapsino niso inolum o agelip uyo ki, niyo bogo-nilita, ‘Beyo nimi duup ba o,’ kagelan-temaali o,” agela e minte, alugum Yesus imi okumop man iyo Fita imi weng ko bogola uta asok ku-nilip e, Yesus iyo bogobelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kale tam Yesus sino ilami okumop man sino ninggil iyo mep ko daage yak anang maak bomi win uyo Getsemani o agan-nuubip kutam no-nilip e, Yesus iyo bogobe-nala e, “Niyo yang kagal God iyo aman duga-emi kale, ninggil ibo kagal ton-bom-silipta o,” age-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","imkaa Yesus iyo Fita sino Sebedi imi man tinum alop Jems sino Jon sino ninggil asuno ita kup imdep yang una ko. Kale Yesus imi aget tem uyo atin mafaganebelu e, aget afek kup fugun-bom ");
INSERT INTO tlf_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ninggil imi bogobe-nala e, “Niyo utamita, kota nangkolip kaanan-temi kalaa ageta nimi aget tem uyo atin iluum afek kup tebepnelu kale, niyo yang kugol God imi beten ke-emi kale, ipkil kagal fen-bom-nilip e, telela bigi siin o,” age-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","imkaa yagal yang so ke-nala e, katuun duung fegela daak ton suk mo kalaak fen-nala e, God imi beten ke-e-bom-nala e, bogola ko. “Aatum kabaa. Kuguup mafak uyo meng, nafak daalan o angbu kale, kabo, fegelebeli dupkaluk o nagelap uyo, titil fagata kanupne-namap kuta, nimi aget fugunin uyo, kabo nimi aget fugun-bom, ‘Bota kanupnelal o,’ agan-bii boga ba kale, kalapmi aget fugun-bom, bota kanubelan-temi kalaa agan-balap uta kup kanumin o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kale Yesus iyo beten kem siit-nala e, kupkaa meng abomu, tinum ninggil asuno iyo agaal unbip kalaa age-nala e, meng ifo imkaa Fita imi bogobe-nala e, “Ninggil ibo agaal unbip aga? Ibo titil fagaa kafan bom dong dagane-bom bigi siit ilugo-nimip binim kale, yuut agaal unbip aga? ");
INSERT INTO tlf_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Saatan iyo, ibo uget taga-bilita, yang fenga kolip kalaa agelan o age-nalata, ibo im-kugu-be kale, ipmi aget fugunin uyo, kuguup tambal uta kup kemum o agan-bilip kuta, ipmi titil uyo katip kale, yang kuguup mafak uyo keman-temip kale, ibo asok agaal unemin ba kale, kupkaa kafan bom God iyo dagaga-bilipta, dong daga-e-balata o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kale kam age imka-nala e, Yesus iyo asok daage yang olang yang-nala e, asok God imi beten uyo ke-e-bom-nala e, “Aatum kabaa. Boyo kalapmi san kale, kabo, waasi iyo imkali tebe kaal fuyap boyo kobelin o nagelap bole, niyo, ‘Waago o,’ agelan-temaali kale, niyo kapmi weng bogolap uyo, ‘O,’ agelan-temi o,” age beten kem siit kupkaa ");
INSERT INTO tlf_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","asok meng abomu, imi okumop man iyo tiin ak tebebelu asok agaal unip kalaa age-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","asok imkaa yang-nala e, kanube beten kem siit tala ulutap mungkup God iyo asok kanupmin beten ke-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kale kem siit-nala e, asok tal ilami okumop man iyo ifo-nala e, bogobela, “Ibo asok agaal un-bomta fingkan-bilip aga? Fenta utamin a. Kota tinum maagup maak ita tebe Mo Tibil imi Man niyo nimkem daa nimdala yak tinum mafak ninggil imi sagaal diim abelita, ita tebe-nilipta, kaal fuyap kupkaneman-temip kale, uyo kaa mitam tulu kale, ");
INSERT INTO tlf_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","tilipta, unum a. Tinum nimi nimkem daala nangkolan-temip iyo no, atam-nilita o ageta talan-be kale, no abu daalupta o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","48","Kale Yesus iyo weng bagam-sala e, Yesus ilami okumop man iyo tuluun kal kale, tuluun keta tala kale, beyo Judas ita ko. Kamaki uyo tinum amem ko age pris imi kamogimal sino Juda kasel imi kamogimal sino ita tebe-nilip e, tinum kwiin tagang iyo imdalip benat ko age un kong sino ulin sino uyo kulep-bilip e, Yesus dupkem daalan-tema tinum Judas sino tal-bom-nilip e, Judas iyo bogobe-nala e, “Ibaa. Ata-bom-silipta, no tinum beyo fet dobe duptal migili umdii, beta kale, aafuu de dolin o,” agela e, at kom fiko talan-bilip e, ");
INSERT INTO tlf_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas isiik Yesus iyo dek diibe yuut tal weng umobe-nala e, “Nimi kafalemin kabo albap aga o?” age-nala e, fet dobe duptal migim-kala e, ");
INSERT INTO tlf_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesus iyo bogobe-nala e, “Nugum kabo intaben nulan o age talap uyo yuut kelapta o,” agan-kala e, kota tinum iyo tal Yesus iyo sagaal togobe fomtuup aafulip e, ");
INSERT INTO tlf_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yesus imi okumop man maak iyo ilami benat ko age un kong uyo kupdeta, tinum amem imi kamok miton ko age hetpris imi ogok ke-emin tinum maak iyo angko imi tuluun kaal milii uyo tagaa kwaapma daak abelu e, ");
INSERT INTO tlf_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesus iyo ilami okumop man ko kanubela beyo bogobe-nala e, “Tinum dok ita tebe benat ko age un kong uyo kulu tinum migik inolip kaanip umdii, kaanip imi duup isiik benat uyo kulu asok inolipta, kaanan-temip kale, dinan-kalin ba ko. Kapmi benat boyo asok ililap daak ulumi um tem unuk o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kale niyo, nalami Aatum God iyo dagali yagal maak fagaa ilami ensel kwiin tagang iyo bogopma tal niyo dong dogopnelip waalanan o ageli uyo, niyo kanupmomi kale, kabo boyo utabaalap aga? ");
INSERT INTO tlf_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kuta niyo Aatum iyo dagali boyo kanubelan-temaala ko. Sugamiyok uyo God yagal ilami suuk kon tem weng uyo kwep daa bogo-nala e, ‘Nimi Man iyo waasi iyo tebe angkolip kaanak o,’ age yagal ki bogosa kale, niyo nalami Aatum God iyo bogo-nili, ‘Aatum kabo dong dogopnelapta, waalanan o,’ agelan-temi uyo, kwek uyo imi weng kwep daasa boyo kwaasulepman-temi e minte, imi weng kwep daasa boyo mitam tol kelan-temaalu binim no kale, niyo boyo dagalan-temaali o,” age Yesus iyo okumop man imi bogopma ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kota Yesus iyo tinum tal aafuu de duptamo unum o age tilip imi bogobe-nala e, “Niyo no ulotu am miton kugol ton-bom unang tinum iyo suun kup kafalem-nak-bii kale, ibo tii tal kugol naafuta de namo-nimip kale minte, intaben o age-nilipta, ibo kupkasipta, kamano kota ibo tinum ipkumal aa-bom mufekmufek daga-emin tinum imi aafuu de dupkabip kulutap ke-nilipta, benat so ulin so uyo kulep talta, de namolum o ageta tilip a? ");
INSERT INTO tlf_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kale ipmi kuguup kanubelip boyo tambal kanubelaalip kuta, ipmi kanubelip boyo, God imi profet ko age weng kem baga-emin tinum bilip imi weng God imi suuk kon tem dola kosip uyo ko mitam felep unu o,” age Yesus iyo tinum ko tal aafuu de dolip bilip imi baga-ema ko. Kale kota Yesus ilami okumop man iyo tolong do-nilip e, Yesus iyo dupkaa yuut bilii daagina tala kelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kale Kayafas iyo tinum amem imi kamok miton ko age hetpris kale, ulo utamsip tinum sino minte Juda kasel imi kamogimal so iyo tal bemi am kal afeta-bilip kale, tinum Yesus aafuu de dolip bilip iyo tebe dep no Kayafas imi diim ku daalip ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Kale Fita iyo Yesus imi umik tem simanim so kugol tam tam yak abe tam hetpris imi am umi daam tem tam una kuta, am iinoma binim kale, abiip kagal bomta, utamita, kamogimal iyo Yesus iyo dogonubelip kalaa agelan o age-nalata, mitam daam tem kugol un tubulin sino ninggil tonip ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kale tinum amem ko age pris imi kamogimal isino alugum kamok kamok migik so iyo, Yesus iyo angkolum o age-nilipta, tebe, tinum dogap ita Yesus iyo atama-bilip kuguup mafak umaak kanuma atabip kalaa age-nulupta, bilip ita kululupta, weng telelmin umi diim uyo bogolipta o age-nilipta, imi fen-bilip kuta, ");
INSERT INTO tlf_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","maak atam-nimip binim kelip ko. Kale boyo ki, tinum kwiin tagang iyo kamogimal imi finang uyo tal Yesus imi sang uyo bisop baga-emip kuta, kamogimal iyo maak utamta, boyo mufekmufek afaligen fenga koba kale, bomi kalan uta angkolan-temup kalaa agelin-tem kemip e, kota tinum alop maak tal ");
INSERT INTO tlf_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","bogo-nilip e, “Ibaa. Tinum beyo bogo-nala e, ‘Niyo tii kale, God imi ulotu am miton uyo dalata kulep toli bii, am alop keluta, am asuno diim kota asok delan-temi o,’ agela nulumi tolong alop uyo tolong dobup o,” age bogopmip ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kale kota tinum amem imi kamok miton ko age hetpris Kayafas iyo fen mo Yesus iyo daga-nala e, “Tinum alop bilip imi weng bagake-bilip boyo, intaben o age-nalapta, yan kepmin-tem albap a? Bilip iyo intaben o kagan-bilip o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yesus iyo atin sining agela e, hetpris iyo asok maak so bogobe-nala e, “Niyo weng maak dagalan o ageta kale, kabo bisop uyo baganemin ba kale, suun kup nin tinum God imi win kamkaam uyo kufo tol kup yan kepnelapta, utaman o ageta kale, kabo God imi Man ulaa kamdula kamok kesap tinum aga o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","kota Yesus isiik yan kebe-nala e, “Dam bogolap kale, alugum ibo tolong do-silipta, nimi weng uyo bogolan. Son-temu kutop uyo ibo nitamipta, Mo Tibil imi Man niyo abiil tigiin kal bom titil kup tebesa tinum God imi sagaal ipkuk diim ko age kamok imi baan diim kal tonbi kalaa agelip suukta minte, aaltam uyo utamipta, abiil tigiin umi iip namaal umi tip diim kugol ton-nalata, tala kalaa age no ke nitaman-temip o,” age Yesus iyo kamok kamok imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kale tinum amem imi kamok miton ko age hetpris iyo weng boyo tolong do-nala e, Juda kasel imi aget iluum tebemin umi kuguup uyo kanumin kale, ilami ilim migiba uyo fengela ko kupkaa tinum alugum tonbip iyo bogobe-nala e, “Ibaa. Bemi weng mafak bogola boyo God imi win uyo kufak daabela ibo tinangkulip kale, yagal ilami sang bogola kale, nuyo tinum maak fen-bom atamupta, beta Yesus imi sang uyo maak so bogolan-temaala binim ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kale ipmi aget fugunin uyo, tinum keyo dogonubelum o agan-bilip o?” agela e, isiik bogobe-nilip e, “Beyo atin kuguup mafak uta ku-nalata, kanubela kale, beyo dupkalap angkolip kaanak o,” age-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","mok tuko kulupmip yak Yesus imi tibit kun diim abe-bulu e minte, kul mim ku saal daga-bom no ke-bilip e, minte iip maak maak iyo minte kul baang tuup saal daga-bom ");
INSERT INTO tlf_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","titul weng fiil weng baga-e-bom-nilip e, “Kabo bogo-nalap, ‘Niyo God imi ulaa nimdula kamok kesi tinum kale, niyo alugum mufekmufek uyo utamsi o,’ agan-nuubap kale, kabo nitamta, beyo dok ita tebe nan-be kalaa agelap umdii, bogobelapta, tinangkulum o,” age titul weng baga-emip ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kanu-bilip e, Fita iyo tam abiip daam tem kugol ton-bom-sala e, tinum amem imi kamok miton ko age hetpris imi ogok kemin unang maak uyo tal Fita imi bogobe-nulu e, “Kapkal mungkup Provins Galili kayaak Yesus so tiinan-nak-balap o,” agelu e, ");
INSERT INTO tlf_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","tinum kwiin tagang imi tibit diim kugol Fita iyo bogobe-nala e, “Umbae. Niyo kupmi weng bagan-balap kwek uyo tele bam daalin-tem o,” age-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","imkaa yang abiip daam umi amitung diim umi mep so kugol mo-bom-sala e minte, ogok kemin unang migik maak tal Fita iyo atam-nulu e, tinum migik maak kugol mobip imi bogobe-nulu e, “Ibaa. Tinum keyo Nasaret tinum Yesus so tiinan-nak-be o,” agelu e, ");
INSERT INTO tlf_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Fita iyo atin fulma-nala e, fomtuup weng uyo bogobela, “Umbae. Aafen ki niyo tinum beyo tele atamsaali binim o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kale siit ilugo-nilip e, tinum kugol mobip iyo tal Fita iyo asok bogobe-nilip e, “Nuyo tolong dolupta e, kabo Provins Galili kasel imi weng uyo bagan-balap kalaa agelup kale, mungkup kabo Provins Galili kayaak kale, kapkal mungkup Yesus imi tinum maak kalaa agan-bulup o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Fita iyo fomtuup weng uyo bogobe-nala e, “E-e. Niyo beyo atin atamsaali binim kale, niyo weng bisop umaak bogobeli umdii, God iyo tebe niyo kaal fuyap kop-naman-tema o,” agan-sala e, kota uun kakaluk aalap umdii olala e, ");
INSERT INTO tlf_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kota Fita umdii tolong do-nala e, asok aget fugunolata e, siin Yesus imi bogopne-nala, “Uun kakaluk aalap iyo olalin-tem bom-salata, kabo nimi sang uyo bogopne-nalap e, ‘Beyo nimi duup ba o,’ nage yakyak bii, ilep asuno fagalan-temap o,” ageba uyo fen ko kanubeli kalaa age-nala e, tinum ko ninggil mobip iyo imkaa tam abiip daam tem kutam iinom-nala e, fomtuup amema ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kale am daanu e, kutim kota alugum tinum amem ko age pris imi kamogimal sino minte Juda kasel imi kamogimal so iyo weng uyo telela ko-nilip e, Yesus iyo dupkalup angkolip kaanak o age-nilip e, ilimi un tubulin tinum iyo bogobelip e, ");
INSERT INTO tlf_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ita Yesus iyo sok de do-nilip e, dep no daalip yak Rom kasel imi kiyap Pailat imi sagaal diim abela ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kale Yesus imi dupkem daa-se tinum Judas iyo dulul weng maak tinangkulata e, Yesus iyo angkolum o angbip kalaa age-nala e, imi aget tem uyo mafaganepmu e, aget afalik fugun-bom-nala e, imi aget fugunin uyo fupkela ko-nala e, tuumon tinum amem ko age pris imi kamogimal so Juda kasel imi kamogimal so imi kobebip uyo kulep no asok ilimi kobelan o age-nalata, ");
INSERT INTO tlf_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","no bogobe-nala e, “Tinum beyo kuguup mafak umaak kebelin-tem kuta, nagal daali yak imi waasi ipmi sagaal diim abe-maansa kale, kamano kota angkolip kaanan-tema kale, boyo niyo kuguup mafak kebebi o,” agela e, kamogimal isiik imi weng uyo yan kebe bogobe-nilip e, “Kapmi kanube-maansap uyo numi san ba kale, kalapmi san o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas iyo bilip imi weng boyo tinangku-nala e, tuumon uyo segela kulula daak ulotu am miton umi abiin abelu e, imkaa yuut tam abiip abe-nala e, no sok angkolu kaana ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kale tinum amem ko age pris imi kamogimal iyo utamipta e, tuumon uyo segela kulula daak abiin abelu kalaa age-nilip e, daak tuumon uyo afeta-bii ko-nilip e, ninggil bogolip, “Nuyo tuumon koyo kulu-nulupta, tinum angkolip kaanan-tema imi kun mobup kale, boyo mani mafak ko. Sugayok uyo Moses imi ulo uyo bogo-nulu e, ‘Ibo tinum aamin umi kun ko age mani uyo kulu God iyo kobe kulep ulotu am miton uyo tomin ba o,’ agesu kale, mani koyo kulu intap nulan-temup o?” age ");
INSERT INTO tlf_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","8","weng tegen-bom, “Kafin maak molum o,” age-nilip e, tuumon uyo kulep no kafin kayaak iyo kobe imi kafin uyo molip ko. Kale kafin kayaak iyo tol uta fagaa ku ok tet telela kupkamin kup nuuba kale, kamaki uyo kafin bomi win uyo bogo-nilip e, “Ok Tet Telelamin imi Kafin o,” agan-nuubip kale minte, aaltam kota pris ko age tinum amem iyo mo-nilip e, tinum asit kek kek kaanip iyo kulep no kugol imamsip kale, kota kafin boyo begel ilet tem kelu e, bomi win uyo, “Kaanan Unsip imi Kafin o,” agan-nuubip ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Sugayok uyo God imi profet Jeremaya iyo bomi sang uyo bogo-nala e, “Siin uyo Israel kasel iip maak maak iyo weng telela ko bogo-nilip e, ‘Nuyo tuumon kiim ulumi kup 30 uta kuluta tinum bemi kun uyo molan-temup o,’ age-nilipta, molip suuta minte, aaltam kota tuumon kobe mo-silip boyo asok ulaa ku-nilipta, ok tet telelamin tinum imi kafin umi kun uyo mobip kale, siin kanubelin-tem bom-silip uyo, Bisel God iyo bogopne-nala, ‘Kabo bogobelapta, bilip iyo kanubelin o,’ agelata, bilip iyo nisiik bogobelita, kanubebip o,” age Jeremaya iyo bogosa kale, Jeremaya imi bogo-nala, “Siin uyo mobip o,” agesa bomi magam uyo, “Son-temu nala molan-temip o,” agesu kale, kamano koyo tol mitam tulu ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Kale Juda kasel imi kamogimal iyo Yesus iyo duptamo tal Rom kasel imi kiyap Pailat imi diim daalip e, Pailat iyo Yesus imi daga-nala e, “Kabo Juda kasel imi kamok king iyo kulbap bele ki?” agela e, Yesus iyo Pailat imi weng uyo yan kebe-nala e, “Kapmi weng bogolap boyo dam bogolap o,” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","tinum amem ko age pris imi kamogimal so, minte Juda kasel imi kamogimal sino iyo utam-nilip e, bisop bogo, “Tinum beyo tuluun kanubeta fenga koba o,” agan-bilip uyo, maak yan kepmoma binim kale, itabala-nala kupkaa sining age mola ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kale Pailat iyo Yesus imi bogopma, “Kabo kapmi win kufak dagake-bilip boyo tolong dolap a? Kabo intaben o ageta yan ke-emin binim kupkata sining agebap o?” agela kale, ");
INSERT INTO tlf_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pailat iyo utamata, Yesus iyo kamogimal imi weng maak yan kepmoma binim kupkala kalaa age-nala e, kumang mo aget afek fuguna ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kale Juda kasel bilip imi kuguup uyo kanumin kale, utamipta, atol mitam tulu uyo, Juda kasel imi ifin am ko age Pasova unan-kalin umi am uyo daanu kalaa age-nilip e, tala tala kelip e, Rom kasel imi kiyap iyo bogobe-nala e, “Tinum sok desup iyo ipkil bogo-nilip, ‘Kanuminak beta talaa daalin o,’ agelip kalaa age-nilita, bogobeli beta kup talaa daalin o,” agela e, igil, “Beta o,” agelan age-silip kanube ilami waasi dinan-kalin iyo kulula no talaa daa win tolobelip daage un un kem-nuubip ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kale siin kota tinum maak bemi win uyo Barabas kale, beyo kuguup mafak mafak uta ke-bala win ditubesipta, dep tal sok de dolip kalabus am kutam kal be kale, ");
INSERT INTO tlf_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Pailat iyo utamata e, Yesus iyo kuguup mafak umaak kanupmata, kamogimal iyo daalip mek nimi diim uyo abelin-tem kalaa age-nala e minte, unang tinum iyo Yesus imi weng uyo baga-bala tolong do-nilip e, imi win uyo kufu-e-bom deng tebe-bilipta minte, kamogimal bilip ita titine-bom-nilipta, daalip mek nimi diim abela kalaa agela ko. Kale unang tinum kwiin tagang iyo tal afetalip e, Pailat imi aget fugunin uyo, unang tinum imi aget fugun-bilip bota Yesus ita ulaa dulip nagal waasi dinin iyo bogopmi talaa daalip daaginon-tema tap kalaa age-nalata, unang tinum iyo bogobe-nala e, “Beta Barabas ita talaa daalip daaginak e? Minte God imi ulaa dula kamok kesa tinum Krais o agan-nuubip Yesus ita talaa daalip daaginak e? Dogap ita talaa daalum o agan-bilip o?” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Kale Pailat iyo weng telelmin umi am kutam kal ton-bom-balata, Yesus imi sang uyo baga-bilip tolong dugamata, kalel uyo suuk kon dola kwaapmu no tamuta, utamata, bogobe-nulu e, “Kamano mililep uyo niyo ilam duluun Yesus iyo atam-nilita, finanin kup ke-bii kale, tolong do-salapta a. Beyo kuguup mafak umaak kebaala kale, beyo tinum tambal kale, kabo beyo kuguup mafak umaak kobe-namap o,” age dola kwaapmu no tamu utama ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kale tinum amem ko age pris imi kamogimal iso e minte Juda kasel imi kamogimal so iyo Pailat imi weng dagala uyo tinangku-nilip e, tinum alugum albip iyo uget taga-bom-nilip e, “Ibo Pailat iyo dagalipta, ilami waasi dinin iyo bogobela ita tebe-nilip Barabas iyo sok talaa daalip daaginata minte, Yesus ita angkolip kaanak o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","kiyap Pailat iyo asok maak so daga-nala e, “Ipmi aget fugunin uyo, tinum alop bilip iyo dogap ita sok talaa daalipta, daaginak o agan-bulup kalaa agelipta, talaa daalup unak o?” agela e, asok imi weng uyo yan kebe-nilip e, “Barabas ita talaa daalip unak o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pailat iyo dagala, “Kam agelip bole, God imi ulaa dula kamok kesa tinum Krais o agan-nuubip Yesus iyo dogonubelal o nagan-bilip o?” agela e, alugum maagup fomtuup ol-bom-nilip e, “Dep yak at diim daa dubiit mo angkolin o,” agan-bom olabelip e, ");
INSERT INTO tlf_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pailat iyo bogobela, “Intaben o ageta ibo boyo kam agan-bilip a? Dogonupmin umi fengmin uta fenga koba kalaa ageta bomi kalan o age-nulupta, angkolan-temup o?” agela kuta, alugum tolong do-nilip e, kota fomtuup ol-bom-nilip e, “Dep yak at diim daa dubiit mo angkolin o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kota Pailat iyo utamata e, nimi weng baga-e-bii uyo tolong duganbaalip kalaa age-nala e minte, niyo bilip imi weng uyo tolong dolin-tem keman-temi bole, dinan-kalon-temip kalaa age-nala e, ilami ogok kemin tinum maak bogobe-nala e, “Ok umaak ilu kupne talaal o,” age bogopma e, no ilu kube kala e, Pailat iyo alugum imi tiin diim kugol ilami sagaal uyo diing daga-bom-nala e, bogobela, “Nimi sagaal komi diing daali bomi magam uyo ki, bogo-nilita, ‘Tinum keyo angkolin o,’ aganbaali kale, bemi kaanan-tema uyo, nimi san ba kale, ilipmi san o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","alugum maagup albip iyo yan kebe-nilip e, “Aa. Nuyo utamupta e, imi kaanan-tema uyo nulumi san kalaa agelup kale, boyo kuguup mafak kelup umdii, God yagal nusino e numi man ilop sino nuyo kaal fuyap kopmoma o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kale kota Pailat iyo ilami waasi dinin bilip imi bogobela e, Barabas iyo sok talaa daa dupkalip daagina e, Yesus ita ifet ku saal dagan-bii angko dupkalip e, kota waasi dinin bilip imi bogobe-nala e, “Ibo dep yak at diim kal dubiit mo angkolin o,” agela kale, boyo Juda kasel imi aget fugun-bom-nilip, “Pailat kabo bota kanubelal o,” agan-bilip uyo Pailat iyo tebe ko kanubela ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kale kiyap Pailat imi waasi dinan-kalin tinum bilip iyo tebe Yesus iyo duptamo tam kiyap imi am afalik umi atuk kutam kal ilimi sinan-nuubip kutam daa-nilip e, waasi dinin iyo alugum tala tala ke fufala do-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","bisop bogo kamok king imi ilim tiimin ulutap kebe tiibelum o age-nilipta, ilami ilim uyo dulu kupkan kebe-nilip e, ilimi ilim isagulut maak uta ku kwaak kalibe-nilip e minte, ");
INSERT INTO tlf_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","sok ningiling so uta ugaa ku-nilip e, king imi dufalum ulutap kebe ilu ko kwep tam imi dubom diim uyo kwaak kalibe-nilip e, at kun du-nilip e, bisop bogo boyo king imi ulin kasaak ulutap ko age ilami sagaal ipkuk diim daabe-nilip e, kamok king imi kuguup uta kobe-nilip e, katuun duung fegela daak ton-nilip e, titul weng baga-e-bom-nilip e, “Juda kasel imi kamok king kabo albap aga o?” age-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","mok tuko kulupmip yak imi diim abe-bulu e, at kun iyo du imi dubom uyo do-emip ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kale titul weng baga-e-bilip uyo binimanu e, kota bilip iyo ilim isagulut kwaak kalibelip uyo dalaa kupkan kebe-nilip e, asok ilami ilim uta migibe-nilip e, dep tam abiip abe-nulupta, dep no at diim kal dubiit mo angkolum o age-nilipta, dep tam abe unip ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kale waasi dinan-kalin tinum iyo Jerusalam uyo kupka-nilip e, Yesus iyo duptamo abe-bom-nilip e, utamipta e, Saimon Provins Sairini kayaak beyo ilep kal talan-be kalaa age-nilip e, asit kup ninuk tebebe-nilip e, Yesus imi dubiit mo angkolan-temip umi at uyo kobelip Saimon isiik kuptamola e, isino daage ");
INSERT INTO tlf_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","tam tam no Golgota Tigiin ko age Dabaal Kun Tigiin o agan-nuubip uyo no-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","sok dum ok so minte marasin so uyo kwego dego ke fiksigi ko-nilip e, Yesus iyo kopmup unelata, imi atul uyo katip so kebeluk o age kobelip kuta, Yesus iyo katip kup kup-kugu-nala e, “Waago o,” age kupkala ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kota Yesus iyo at diim dup-dii-nilip e, aaltam kota tuum kangkang uyo kulu kwaalup iit o malaak o ke-bomta, waanta ita ita kela kalaa age, beta Yesus imi ilim uyo kula kula kelum o age-nilipta, Yesus imi ilim umdii dulube-nilip e, togolip binimanu ");
INSERT INTO tlf_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ton-bom-nilip e, Yesus iyo bigi-bom atamam-silip e, ");
INSERT INTO tlf_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pailat imi ogok kemin tinum maak tebe at kom maak ku-nala e, dok umi kalan uta Yesus iyo angkolip kalaa age-nala e, umi sang uyo bomi diim kwegal dola ko-nala e, “Tinum keyo Juda kasel imi kamok king Yesus o,” agela e, at kom uyo dola kwep iit Yesus imi dubom uyo kupkan kebe iit at umi tip diim kal kup-diilip ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Kale waasi dinin iyo tebe Yesus dep yak at diim kal dup-diilip uyo, asok tinum ipkum aa-bom imi mufekmufek daga-emin tinum alop maak igil mungkup kulep tal at diim kal im-dii no ke-nilip e, maak ita dep te Yesus imi ipkuk ilo keng kal dup-dii som, minte maak ita dep te afaan ilo keng kal dup-dii no kelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kale tinum mep so ko tiinan-bilip iyo Yesus iyo aban dii-e-bom titul weng baga-e-bom-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Kabaa. Kalapmi bon tem bogo-nalap, ‘Niyo ulotu am miton uyo dalata kulep toli bii, am alop keluta, am asuno diim kota asok delan-temi o,’ age kalapmi tok uyo bogobap kale, kabo ki God imi Man aligaap umdii, kalapmi kaal ilak uyo do-nalapta, at diim kam-diilip uyo talaa kupkaa malaak kafin diim talaal o,” age titul weng baga-e-bilip e minte, ");
INSERT INTO tlf_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","tinum amem ko age pris imi kamogimal so ulo utamsip tinum so Juda kasel imi kamogimal so igil mungkup titul weng baga-e-bom-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Beyo unang tinum migik imi kaal ilak uta do dong daga-e-bala waalanan-nuubip kuta minte, intaben o ageta ilami kaal ilak bota do waalan-nama binim a? Beta ki dam Israel kasel numi kamok king nimnam, yagal tii at diim uyo talaa kupkaa malaak kafin diim abelata, nugol atamupta e, beta tuluun God imi Man kalaa agelup kuta ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kale yagal bogo-nala e, ‘Niyo God imi Man o,’ agan-nuuba kale, imi aget fugunin uyo, ‘God yagal niyo dong dogopnelata, waalanan-temi o,’ agan-be kale, ata-bom-sulupta, waalana kole, dam bagan-be kalaa agelum o ageta kale, God iyo tuluun dong dogopma waalanan-tema uta, utamupta e, beyo tuluun God imi Man kalaa agon-temup o,” age titul weng baga-emip ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kale ulutap mungkup, tinum aa-bom imi mufekmufek yuguut unin tinum Yesus isino ninggil maagup at diim kal im-diibip igil mungkup weng mafak uyo baga-e-bom no kemip ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kale ataan tal dubim e tulu e, mililebok afalik uyo mitam abuta, alugum kafin kaa kutufosu uyo mililan-bom-bulu bii, ataan uyo fupkela te kek iinu e, ");
INSERT INTO tlf_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","mililanbu uyo asok binimanan ti-sulu e, kota Yesus iyo Hibru ilimi weng uyo ku fomtuup ola-nala e, “Eli, eli, lama sabaktani o?” agela kale bomi magam uyo bogo-nala, “Nimi God kabaa. Nimi God kabaa. Intaben o age-nalapta, kabo bisat nimkabap o?” agan-bom-nalata, Hibru ilimi weng uta ku bagamata minte, ");
INSERT INTO tlf_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","tinum kugol mobip imi tinum iip maak maak iyo tolong do-nilip e, bogolip, “Beyo sugamiyok God imi profet ko age weng kem baga-emin tinum bii-se Elaija imi ole-be o,” age-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","tinum maak ita yuut yang mufekmufek tiyuup kon ulutap uyo ku sok dum ok amil tebesu uyo kup-kubu-nala e, at daang diim iinu e, “Unelal o,” age ilu kwep iit kupka-ema e, ");
INSERT INTO tlf_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","tinum milii iyo bogolip, “Kala. Nuyo kiit fen ata-bom-sulupta, Elaija iyo talta dong dogobela waalana kalaa age atamum o,” age bom-silip e, ");
INSERT INTO tlf_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesus iyo, kota o age-nalata, asok Aalap iyo fomtuup olabe-nala e, kota kaana ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kale ulotu am miton kutam kal ilim afalik maak kup-diilip God imi abiin amem uyo uksu-bomu kale, Yesus iyo kaana e, kota ilim boyo dong katam-tele bigi kwep tiinu ki te daak kafin diim daa kupkaa milii so milii so alop kano kulep tolu e, God imi abiin amem kutam uyo kemanu ko. Kale bim afalik uyo kafin kuso kupku saan-bom bumban keng keng ke-bom-nulu e, tuum afaligen uyo iip kalagal begel-bulu e minte, ");
INSERT INTO tlf_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","God imi unang tinum kaanip kulep no tuum tem kuban unsip umi tuum faal ugol mungkup bito no kelu e, unang tinum kaansip bilip iyo fen tigi mo-bom-silip e, ");
INSERT INTO tlf_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yesus yagal mungkup fen tigi mola e, igil mungkup tuum tem ilota tam abe no abiip Jerusalam unip e, unang tinum kwiin tagang iyo itamamip ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kale waasi dinin sino minte imi tiin molin tinum so Yesus imi bigibip iyo utamipta e, Yesus iyo kaana e minte, bim uyo tulu e, kuguup migik migik uyo tulu no kalaa age-nilip e, alugum iyo finanin afaligen uyo ku-nilip e, bogolip, “Tinum keyo fen tuluun God imi Man o,” agelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","56","Kale siin uyo Yesus iyo Provins Galili uyo kupkaa una e, unang kwiin tagang igil mungkup kupkaa isino no, imi iman fuu-e-bom telel-bulupta o age-nilipta, isino dagaa kulep Jerusalam e ti-silip kale, unang iip maak maak iyo abiip Makdala kayaak unang Maria ugol, minte Jems sino Josep sino alop imi ogen Maria ugol, minte asegim Jems so Jon so alop imi ogen ugol no mangkal ita kup kale, unang kwiin tagang bilip iyo no abe yang simanim so kugol mo-bom, ata-bom-sulupta, waasi iyo tebe Yesus iyo intaben nubelip kalaa agelum o age-nilipta, mangkal no atamamip ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kale tam tinum maak asegim Josep beyo Provins Yuudiya umi abiip Arimatea kayaak kale, beyo win soyaap e minte, Yesus ilami ilak dolin tinum no kale, am kwiinu kalaa age-nalata, daage no kiyap imi am uyo tam-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Rom kasel imi kiyap Pailat iyo atam daga-nala e, “Dagalita, kabo, ‘O,’ agelap kalaa age-nilita, Yesus imi at kulu uyo kopnelal o,” age dagala e, Pailat yagal, “O,” age-nala e, ilami waasi dinan-kalin tinum iyo olabela tal tamip bogopmata, no Yesus imi at kulu uyo talaa daalip malaak abela e, daapmip yak Josep imi sagaal diim abela ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","60","Kale kamaki siin kota Josep ilami ogok kemin tinum iyo bogobelata, ita tebe, Josep imi suuk nala kaana dubalan-temup umi o age tuum tem maak kalobelip suu kale, Josep iyo tebe Yesus imi at kulu uyo duptamo no-nala e, kamaa ilim namaal uyo ku fufala do dep tam ilami tuum tem kalobebip kutam kal duba-nala e, tuum afaligen ko age faal uyo bubulun kuptamo yang amitem uyo ilobe-nala e, kupkaa daagina e, ");
INSERT INTO tlf_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Makdala kayaak unang Maria so minte asegen Maria so alop iyo ton-bom tiin kwep yak daa-bomta e, tuum uyo kanubeta ilola kalaa age utamamip ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Yesus iyo kaana duba-bii silipta, tam ifin am daanu e, tinum amem ko age pris imi kamogimal so Falosi so iyo no Pailat iyo atam-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","bogopmip, “Kamogim kabaa. Bisop bagamin tinum Yesus bemi kaanin-tem som-nala uyo, bogo-nala e, ‘Nangkolip kaan-nilita, siit am alop ke-nilita, am asuno diim kota asok fenan-temi o,’ ageba kale, imi weng ko bogoba bomi aget uyo afaligen fugun-bulup kale, ");
INSERT INTO tlf_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","numi aget fugunin uyo, ilami okumop man iyo no tuum tem kal imi at kulu uyo yuguut dagaa kwep no tuum tem migik kal daa-nilip unang tinum iyo bogobe-nilip e, ‘Atin kaanba kuta, God yagal asok dufola fen tigi moba o,’ agelan-temip tap kale, son-temu nala ilami okumop man bilip imi bisop bogobe-nilip, ‘Yesus iyo fen tigi moba o,’ agan-kalon-temip uyo mitam senganu e, uta uta ke siin Yesus ilami bisop bogobe-nala, ‘Niyo God imi ulaa nimdula kamok kesi tinum iyo kalbi o,’ agan tiinemsa uyo kubaganu kupkalan-temip kalaa age-nulupta, aget afalik fugun-bulup ko. Kale imi okumop man iyo no at kulu uyo kwep unon-temip kale, kapmi waasi dinan-kalin tinum iyo imdalap no kamano so amsap so uyo tuum tem uyo bigi-bom-nilipta o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailat iyo ilami waasi dinan-kalin tinum iyo kulula yak kamogimal imi sagaal diim abelip e, bogopma, “Ibo waasi dinin kalip iyo kulep no to-nilipta, ibo tuum umi faal uyo fomtuup nagat age ilobelipta, waasi dinin iyo bigilin o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kale tinum amem imi kamogimal iyo Pailat iyo dupka-nilip e, at dan maak kulep no-nilip e, tuum faal umi magaang tem tem uyo fuko kupka-nilip e, “Boyo nagat molu o,” age-nilip e, waasi dinan-kalin tinum iyo imdep tuum tem umi amitem ku to bogobe-nilip e, “Kugol bigilin o,” age imka-nilip e, daaginip ko. ");
INSERT INTO tlf_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kale God imi ifin am uyo binimanu silipta, tam Sande kutim kota ataan mitam tolon o agan-sulu e, Makdala kayaak unang Maria so e minte Jems so Josep so alop imi ogen Maria sino alop iyo daage no tuum tem Yesus dubabip uyo utamum o age-nilip e, unip ko. ");
INSERT INTO tlf_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kale alop no tuum tem mep so tamip e, bim kiim maak tebe-nulu e, kafin uyo kupku saan-sulu e, tam God imi ensel maak abiil tigiin ilo malaak-nala e, tuum tem umi faal ko age tuum kom kwep yak daa ilobip uyo fomtuup bubulun kupkan ke-nala e, tam umi tip diim kugol ton-bom-salata, ");
INSERT INTO tlf_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","minte unang alop iyo nota atamipta e, imi tibit kun uyo fomtuup mufekmufek namaal ulutap tiin bulusii so kalaa age-nilip e minte, imi ilim ugol mungkup iip namaal ulutap kalaa age no kelip e minte, ");
INSERT INTO tlf_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","waasi dinin amitem bigibip tinum iyo atamipta e, ensel iyo kanubela kalaa age-nilip e, fomtuup finan-bom-nilip e, bumban keng keng kem tolom-nilip e, tiin buul ino kululu daak kafin diim abe-nilip e, tinum kaanbip ilitap kelip ko. ");
INSERT INTO tlf_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kale ensel iyo unang alop imi bogobe-nala e, “Ibaa. Ibo nimi atul uyo finanin ba kale, niyo utamita e, ibo Yesus dep yak at diim kal dup-diilip kaanba ita fen talan-bilip kalaa agebi kuta, ");
INSERT INTO tlf_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","beyo kagal albaala kale, beyo tigi mo tuum tem katam uyo kupkaa tam iina kale, iyo siin ipmi bogobe-nala, ‘Asok fen tigi molan-temi o,’ age-se uyo ibo ilumanbip aga? Ipkil tal-nilipta, imi dep tal dubabip imi olang uyo utamipta e, iyo tuluun fen tuum tem uyo kupkaa tam iina kalaa agelin a. ");
INSERT INTO tlf_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ibo ko utamip kale, kamano kota yuut no-nilip imi okumop man iyo bogobe-nilip, ‘Boyo dam kale, Yesus iyo tuluun kaanba kuta minte, asok tuluun fen tigi mo tuum tem uyo kupkaa tam iina kale, beyo isiik tolobe unata, ibo no Provins Galili kugol atamin o,’ age bogobelin o ageta kale, tii bogobeli o,” age ensel iyo bogobela e, ");
INSERT INTO tlf_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","unang alop iyo tinangku finan-bom-nilip e minte, deng tebe-bom no kem tolom-nilip e, tuum tem boyo kupkaa yuut daage no Jerusalam no-nilip e, okumop man iyo mufekmufek tambal bomi sang uyo baga-em unip ko. ");
INSERT INTO tlf_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kale unang alop iyo yuut abe-bilipta, Yesus iyo ilep kal unang alop iyo abu daa-nala e, bogobela, “Alop ibo silip aga o?” agela e, alop iyo king imi weng umka-emin umi kuguup uta ku-nilipta, tal katuun duung fegela daak ton-nilip e, imi yaan uyo waafubelip utam-nala e, ");
INSERT INTO tlf_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesus iyo bogobela, “Ibo finanin ba kale, ibo yuut no nimi nugumal iyo bogobe-nilip, ‘Ninggil ibo no Provins Galili kugol Yesus iyo atamin o,’ age bogobelin o,” age Yesus iyo unang alop imi bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kale unang alop iyo tuum tem uyo kupkaa daage abe-bilip e, mungkup waasi dinan-kalin tinum tuum tem umi bigibip iip maak maak igil tuum tem uyo kupka-nilip e, yuut daage no Jerusalam kugol tinum amem ko age pris imi kamogimal iyo mufekmufek kanum mitam tulu utamip umi sang uyo alugum bogobelip ");
INSERT INTO tlf_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","iyo tinangku-nilip e, weng kwaalip no Juda kasel imi kamogimal imi diim abelu tala tala kelipta, weng uyo telela-nilip e, mani kwiin tagang uyo waasi dinan-kalin tinum imi kobe-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","bogobelip, “Ibo weng kwep no unang tinum iyo bogobe-nilip e, ‘Mililep kota alugum nuyo amin bom-bulupta, Yesus imi okumop man iyo tal-nilipta, Yesus imi at kulu uyo yuguut dagaa kwep tam iinbip o,’ agan tiine-bilipta o ageta kale, ");
INSERT INTO tlf_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","kanube Rom kasel imi kiyap Pailat iyo tinangku-nala ipmi olsak kobela umdii, nuyo tebe Pailat iyo weng tambal tambal uyo fomtuup kupka-emupta, utamata e, aafen boyo ipmi fengmin ba kalaa age-nalata, kuguup mafak umaak kobelin-tem ke imkalan-tema kale, aget afek fugunin ba o,” age kamogimal iyo waasi dinan-kalin tinum imi bogopmip ko. ");
INSERT INTO tlf_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kota waasi dinan-kalin tinum iyo mani uyo kulu-nilip e, tinum amem ko age pris imi kamogimal imi weng bogobelip uyo kwep no mungkup kanube baga-e-bilip e, Juda kasel unang tinum iyo tolong do-nilip e, weng ko bogolip boyo tegen yakyak kwep talanbu tal kaa diibelu kale, “Weng boyo fen dam ko,” agan tebesip ko. ");
INSERT INTO tlf_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Siin uyo tam Yesus iyo ilami okumop man iyo bogobe-nala e, “No Provins Galili umi amdu tigiin kanupmin kugol nitamin o,” agela e, kota ilami okumop man kum kal iyo daage ");
INSERT INTO tlf_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","tam amdu tigiin boyo tam abomu e, Yesus iyo alba kalaa agelip kuta, okumop man iip maak maak iyo aget fuguno-nilip e, “Keyo Yesus kaan-nala fen tigi mo-se ita bele o?” agan-bilip kuta, asok king imi weng umka-emin umi kuguup uta ku-nilip e, katuun duung fegela daak tonip e, ");
INSERT INTO tlf_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesus iyo tal imi mep so tolom-nala e, bogobela, “Nugumal ibaa. God iyo ulaa nimdu-nala ilami titil uyo alugum kopnelata, kafin diim sino abiil tigiin sino umi mufekmufek uyo alugum tiin molan o angbi kale, ");
INSERT INTO tlf_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","niyo, ibo nimi ogok kemin tinum kelin o age-nilita, ulaa imduli kale, ibo no kafin kaa kutufosu bomi tinum migik migik iyo alugum nimi weng uyo kwep no baga-em tiine-bilipta, mitam-nilip nimi daang uyo begepne nimi ilak uyo fomtuup dugamip kalaa age-nilipta, ibo tebe Aatum God sino ilami Man nisino ilami Sinik Tambal sino ulimal maagup numi win tolop diim ok sam uyo uga-e-bom-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","nimi weng kupka-em tebesi uyo alugum tele kafale-bilipta bole, tinangku-nilipta, fomtuup waafulin o ageta ko. Kale ibo nimi weng bogobelan-temi koyo tele tolong do-silipta. Niyo bisat imkalan-temaali kale, niyo ipsino suun kup bom-bilita bii, afungen tem tulu kafin kaa kutufosu komi binimanan-temu kwek diliit kelan-temi o,” age Yesus iyo ilami okumop man imi baga-emsa ko. ");
INSERT INTO tlf_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Koyo ki God imi Man Tinum Yesus Krais imi weng tambal so kuguup tambal so kanum tiinan-bii-se umi sang uta bogobelan-temi kale, tinangku-silipta. ");
INSERT INTO tlf_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kale profet Aisaya imi sugamiyok God imi suuk kon tem dola kosa uyo kam age-nala e, “God iyo ilami Man imi bogobe-nala e, ‘Nagal kafin diim tinum beyo ulaa dulita, nimi kalaan tinum kelata, besiik daali no unang tinum iyo bogobe-nala, “Kamogim iyo tolon-tema kale, ibo ipmi aget tem uyo telelmipta o,” agan tam tam daage no ");
INSERT INTO tlf_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","tinum binim iiban kugol ol-bom bogo-nala e, “Ilep tambal umaak telelamipta, Kamogim iyo yuut talak o,” age felep yak aget telelamin umi diim to bagan abe-salata minte, kapta aaltam umik tem unon-temap o,’ age God iyo ilami Man imi bogobesa o,” age Aisaya iyo dola kola nuubuta, ko tol mitam ti-suu kale, bomi sang tinangku-bom-silipta. ");
INSERT INTO tlf_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Boyo ok sam uga-emin tinum Jon Baptis imi sang uta kale, beyo no iibaan bagan kugol bom unang tinum iyo baga-e-bom-nala e, “Fupkela ipmi fengmin uyo kupka-nilip meng ok sam ugolipta, God iyo ipmi fengmin uyo kupkan kebela binimanuk o,” agan-bala e, ");
INSERT INTO tlf_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","alugum Provins Yuudiya umi abiip maak maak kasel so e minte alugum abiip miton Jerusalam kasel so iyo, no Jon imi weng uyo tinangkamum o age-nilipta, tal afeta-bii ko Jon imi weng uyo tinangka-bom-nilip e, imi aget uyo fupkela ko-nilip e minte, God sino unang tinum so imi tiin diim uyo ilimi fengmin uyo kupkem daga-bom no ke-bilipta, Jon iyo tebe kulep te daak Jodan umi kumun tem to ok sam uyo uga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Kale Jon iyo (siin God imi profet ko age weng kem baga-emin tinum maak Elaija imi kuguup kanu-bii-se uta ku-nalata,) ilim tambal migimin binim kale, imi ilim mafak uyo kong ko age kamel umi kon uta butu faabelip uta migi-nala e minte, kao umi kaal uta ugaa ku ol tiil ko age let telela ko magal fildela ilim uyo nagat molu e minte, iman tambal uyo fala-nalata, kubuluum so at tem umi tin ok so uta un-bom no ke-bii-se ko. ");
INSERT INTO tlf_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kale Jon iyo unang tinum iyo bogobe-nala e, “Ipmi tinum tolon-tema o age fen-bilip iyo naga ba kale, nisiik tilita, yagal aaltam nimi umik tem tolon-tema kale, beyo kamok miton kale, ita ita ke niyo kubagani nimkasa kalaa age-nilita, fitom tebepnebu kale, niyo fen tinum kale, niyo bagang-kale yang bemi miit tem uyo suk mo-nilita, imi yaan ilom sok uyo tiila kopmomi binim ko. ");
INSERT INTO tlf_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kale niyo ok uta kulu-nilita, ipmi ok sam uyo uga-e-bii kuta, tinum tolon-tema bemi ok sam uga-eman-tema boyo fen ok ba kale, ilami Sinik Tambal ita tebe ipmi iibak tem aget mafak fugunin uyo telela kobela ibo atin tambalanan-temip o,” age Jon iyo baga-emsa ko. ");
INSERT INTO tlf_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kale Jon iyo kanum-sala e, kota Yesus iyo Provins Galili umi abiip Nasaret ilota tal tamata, Jodan umi kumun tem kal Jon ita Yesus iyo ok sam ugobela e bole, ");
INSERT INTO tlf_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ok tem uyo kupkaa mitamta yuut kiit fenata e, abiil tigiin uyo tem kalo kolu e, God imi Sinik iyo uun abim ulutap ke-nalata, malaak Yesus imi diim uyo abela kalaa agela e bole, ");
INSERT INTO tlf_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","abiil tigiin kwiit ilota God imi weng kwaala tulu kwek uyo bogo-nala e, “Kabo nimi Man bubul kale, niyo kapmi deng kup taban-bii o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kale kam agan-kala e, God imi Sinik iyo maak fagalin tap tal abata, Yesus iyo asit kup daala unan-bii iibaan bagan maak kubela kale, ");
INSERT INTO tlf_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","no sep kugol bom-bala bii, am ulumi kup 40 kelata, Saatan tebe Yesus iyo dup-kugulita, Yesus beyo kuguup mafak umaak kanubela kalaa agon o age-nalata, dup-kugum yakyak kema ko. Kale Yesus iyo sep tolop atul kup tebesip so bom-bala e, ensel iyo tal-nilip e, Yesus iyo dong dogobe tiin mo-bom-nilip e, iman ifemip ko. ");
INSERT INTO tlf_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kale tam ok sam uga-emin tinum Jon iyo (tebe King Herot imi kuguup mafak sang uyo baga-e-balata, Herot iyo tebe un tubulin kulula tal Jon iyo) sok de do dep daalip bom-bala e, Yesus iyo tal Provins Galili tal-nala e, God imi weng tambal umi sang uyo unang tinum iyo bogobe-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“God imi tebe unang tinum imdep tam ilami daam tem daa tiin molan-tema uyo mep tulu kale, ibo utamipta, God iyo numi fengam-nuubup uyo im-kuguman-tema kalaa age-nilipta, ipmi fengmin uyo kupkaa aget fupkela ko-nilipta, God imi weng tambal uyo aafen kalaa age imi ilak uta dolipta o,” age baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kale am maak daanu e, Yesus iyo Galili Ok Muk umi kan tem ku-tele abe-bom-nala e, Saimon so ilami niing Andru so alop ita itama kale, alop bilip iyo aniing abu kulep no tolip saanin tinum kale, bilip iyo aniing abumin men uyo kwaalip daak ok tem abelu aniing fen-bilip kalaa age ");
INSERT INTO tlf_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesus iyo no alop bilip imi bogobe-nala e, “Nugumal ibaa. Ipmi ogok ke-bilip boyo kupkaa tilipta, nisino ninggil abe-bomta ogok migik maak kobe imdalita, aniing abum-nuubip kulutap kem tiine-bomta unang tinum iyo afeta imdep meng God imi miit tem daagamin o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","alop iyo tolong do-nilip e, ilimi aniing abumin men uyo yuut bisat kupka-nilip e, Yesus imi daang begebe unip ko. ");
INSERT INTO tlf_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kale Yesus iyo alop iyo imdep mep ko daage yang abomu, minte tinum alop maak ilimi bot tem katam kal ilimi aniing abumin men dalata taban unbu uyo bigina-bilip kalaa age itama kale, bilip iyo Sebedi imi man Jems so e minte ilami niing Jon so ita kale, ");
INSERT INTO tlf_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","alop iyo bogobe-nala e, “Nugumal ibaa. Ipmi ogok ke-bilip uyo kupkaa tilipta, niso ninggil abe-bomta nimi ogok usiik maak kobelita, ogok kemin o,” agela e bole, alop iyo tolong do-nilip e, aalap Sebedi so Sebedi imi ogok ke-emin tinum so ita bot tem kutam kal imka-nilip e, alop no Yesus imi daang begebe daaginip ko. ");
INSERT INTO tlf_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kale Yesus ninggil iyo no abiip maak Kapeneam kal bilip nala e, tam God imi ifin am kota Yesus iyo no Juda kasel imi ulotu am tam-nala e, unang tinum imi kafale-balata, ");
INSERT INTO tlf_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","kumang muuna tala ke-nilip e, bogolip, “Bemi weng kafalemin kuguup uyo atin fen ugulumi migik kale, God imi aget fugunin uta dagaa ku uta-bom-nalata, nuyo fomtuup kafale-be kuta minte, numi ulo utamsip tinum kalip ita kanube nuyo fomtuup kafalebe-nimip binim o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kale ulotu am kutam uyo tinum maak sinik mafak tebe dufak daasa iyo kutam kal alba kale, kota sinik mafak ko tinum bemi diim alba iyo ol-bom-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","bogola, “Nasaret kayaak Yesus kabo, nuyo intap nubelan o age-nalapta talap a? Kabo, tal nuyo ifak daali win binim kelin o age-nalapta, talap aga? Niyo katamita e, kabo God imi tinum ulaa kamdu-nala kamdala ti-salap kapta kalaa agebi o,” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesus isiik tebe sinik mafak beyo an-togon-bom bogobe-nala e, “Kabo sining age-nalap tinum beyo dupkaa yak iinaal o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","kota sinik mafak beyo tebe-nala e, tinum beyo ilibe daala unba talba ke-bom fomtuup olan-kala e, kota dupkaa yak iina ko. ");
INSERT INTO tlf_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kale unang tinum iyo alugum kumang mo-nilip e, ipkumal migik iyo daga una tala ke-bom bogo-nilip e, “Koyo intaben umaak mitam tulu a? Beyo kuguup ugulumi migik maak kwep tal nuyo kafale-be kale, beyo fen tinum kuta, bemi titil uyo tii kale, sinik mafak bilip iyo fomtuup bogobe-nala e, ‘Yak iinin o,’ agelata, imi weng uta tinangkan-bilip kuba,” agelip ko. ");
INSERT INTO tlf_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kale Yesus imi win uyo yuut yak Provins Galili umi alugum abiip maak maak uyo yakyak ke senganu ko. ");
INSERT INTO tlf_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kale kota Yesus so Jems so Jon so okumop man migik migik so ninggil iyo tam ulotu am uyo kupka-nilip e bole, daage no abe tam Saimon so Andru so alop imi am uyo tam abomu e, ");
INSERT INTO tlf_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimon imi alol uyo kaal mimin tebepmu mafak umo-bom bet diim kal albu kalaa age-nilip e, kota Yesus iyo yuut bogobelip e, ");
INSERT INTO tlf_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesus iyo tal unang bomi sagaal uyo waafuu kufola fen molu e, kota umi kaal mimin uyo binimanepmu e, asok uta tebe-nulu e, bilip imi iman uyo telela kobelu ko. ");
INSERT INTO tlf_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kale bom-bilip ataan uyo, tem iinon o agan-sulu e, (God imi ifin am uyo binimanu kalaa age-nilipta,) abiip kasel iyo unang tinum mafak ilin so unang tinum sinik mafak tebe ifak dagan unsu so iyo alugum fakamo Yesus imi finang telemip kale, ");
INSERT INTO tlf_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","abiip kasel unang tinum kwiin tagang iyo tebe Yesus imi alba kutam umi amitung uyo bugulip ko. ");
INSERT INTO tlf_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kale Yesus iyo tebe-nala e, unang tinum kwiin tagang iyo, kanumin kanumin mafak ilin umobip iyo telela imka-bom-nala e minte, sinik mafak iyo fot tebela yak iine-bom no kemip kale, Yesus iyo utamata e, sinik mafak iyo nitamipta, beyo God imi ulaa dula kamok kesa tinum ita kalaa nagebip kalaa age-nalata, bogobe-nala e, “Ibo nimi sang uyo bagamin ba o,” age-nala e, sinik mafak iyo fegelebela ko. ");
INSERT INTO tlf_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kale tam am daan daan ti-sulu e, kota Yesus iyo fen tam abe no tinum binim iibaan kugol God iyo aman duga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kale Saimon so ilami ipkumal so ninggil iyo fenta utamipta, Yesus iyo imkaa una kalaa age-nilip e, igil Yesus imi umik tem daage no ");
INSERT INTO tlf_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","abomu, alba kalaa age-nilip e, bogobelip, “Kabaa. Unang tinum kwiin tagang iyo, dong daga-emal o age-nilipta, talta kapmi fen-bilip o,” agelip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesus isiik bogobe-nala e, “Niyo alugum abiip maak maak kalip imi weng kupka-eman o age-nilita, talbi kale, unang tinum ko tal nimi fen-bilip bilip iyo weng uyo kupka-e-maansi kale, imka-nulupta, yak abiip migik migik isiik weng uyo kupka-e-bilita, ninggil unum o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kale alugum Provins Galili uyo yakyak ke-bom-nala e, ilimi ulotu am kutam kal weng uyo baga-e-bom-nala e, sinik mafak unang tinum imi diim albip iyo fot tebe-bom no kem tiinema ko. ");
INSERT INTO tlf_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kale tam tinum kaal mafak kesa maak ipkumal tebe fot tebelip yang sep kugol nuuba iyo Yesus imi finang tal-nala e, kamok king imi weng umka-emin umi kuguup uta ku-nala e, tal katuun duung fegela daak ton Yesus iyo fomtuup daga-nala e, “Kabo tii kale, dong dogopnelan o agelap umdii, nimi kaal mafak koyo telela kopne-namap o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kale Yesus iyo tinum beyo fomtuup du-filin daa imi sagaal uyo kwep yak tinum bemi kaal diim uyo daa bogobe-nala e, “Aa. Niyo dong dogopkelan o ageta kale, kaa telela kamoli tambalanap o,” agela e bole, ");
INSERT INTO tlf_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","tinum bemi kaal mafak uyo maak fagaa binimanepmu tinum kasagim kela e, ");
INSERT INTO tlf_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","kota Yesus iyo weng uyo fomtuup bogobe-nala e, “Kabo koyo no tinum imi diim uyo ki nimi kanupkeli bomi sang uyo baga-emin ba kale, kupkaa unap ki no pris ko age tinum amem imi diim kal kapmi kaal uyo kafalebelapta, katamata, kabo ko atin tambalanap kalaa agelata, kabo Moses imi sugayok weng kwep daasa uta ku waafu-nalapta, mufekmufek maak God iyo kobe-nalap, ‘Suguul o,’ agelapta, unang tinum iyo katamipta e, aafen ko tambalanap kalaa age-nilipta, asok kamdep meng daalin o,” age bogobe-nala e, daala una ko. ");
INSERT INTO tlf_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kuta tinum beyo abe-bom-nala e, Yesus imi tebe kaal mafak telela doba umi sang uyo kupkem daga-bom-nala e, weng kwaala unu tulu ke-balata, Yesus iyo utamata e, unang tinum kwiin tagang iyo telemip kalaa age-nalata, tam abiip maak maak kem unoma binim kupkaa tam tinum binim iibaan kugol bom-bala e, alugum abiip maak maak umi unang tinum iyo Yesus imi finang uyo keng-tele tele-bala keng-tele tele-bala kemip ko. ");
INSERT INTO tlf_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kale Yesus iyo kugol bom sinan-nak-be nala e, asok kupkaa daage no abiip Kapeneam no-nala e, am kal bom-balata, abiip kasel iyo tolong dolipta e, Yesus iyo tal am kal alba o agan-bilip kalaa age-nilip e bole, ");
INSERT INTO tlf_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","unang tinum kwiin tagang talta am uyo dongen binim kelip e, tinum maagup iyo maak dogobeta amitem ilep uyo mitam toloma binim kelu e, Yesus iyo God imi weng uyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Kale tinum kalbinim maak iyo ipkum tinum maak magal fagaa kubesu iyo daalip ilet tem iina duptamo, Yesus imi finang unum o age ade dep tilip kuta, ");
INSERT INTO tlf_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","utamipta, Bei. Unang tinum tebeta abiin uyo alugum bugubip kota, dogobeta nuyo dep no Yesus imi miit tem mep so uyo unon-temaalup kalaa age-nilipta, yak abe dep tam am kon al tam-nilip e, am kon uyo fagagan ke-nilip e, tinum iyo ilami ilet diim kal agaal unba kale, ilet kusino agol kup sok dup-dii daalip unanbu daak Yesus imi miit tem abela e, ");
INSERT INTO tlf_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesus yagal itamata e, tinum ninggil iyo utamipta, Yesus iyo tii nugum beyo telela dolan-tema kalaa agan-bilip kalaa age-nala e, tinum magal fagaa kubesu imi bogobe-nala e, “Nugum kabaa. Niyo kapmi fengmin uyo alugum kupkan kepkeli binimanu o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Kale ulo utamsip tinum iip maak maak iyo kutam kal tonbip kale, ilimi aget uta kup fugun-bom-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Intaben o ageta tinum beyo weng boyo baga-bom God imi win uyo kufak daga-e-be a? Kafin diim tinum iyo maak tebe-nalata, unang tinum imi fengmin uyo kupkan kebe-nama binim kale, God maagup ita kup tii unang tinum imi fengmin uyo kupkan kebela biniman-numu o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kale Yesus iyo ilami aget fugunin uta utamata e, bilip iyo kanupmin aget boyo fugun-bilip kalaa age-nalata, bogobe-nala e, “Intaben o ageta ibo kanupmin aget boyo fugun-bilip a? ");
INSERT INTO tlf_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Niyo intaben mufekmufek uta maak kanubelita, ibo yuut nitamipta, beyo dam bagan-be kalaa nagelan-temip a? Niyo tinum kemi bogobe-nili, ‘Kapmi fengmin uyo kupkan kepkeli o,’ agon-temi uyo, ibo bogopne-nilip, ‘Nuyo boyo nulumi tiin fala utamin-tem kelup kale, kabo bisop bagan-balap o,’ agelan-temip kale minte, niyo tinum magal fagaa kubesu kemi bogobe-nili, ‘Fen-nalap kapmi ilet dalaa ko-nilip kamtamo tilip uyo kwep unaal o,’ ageli fenan-tema uta, ibo utamipta, boyo dam bagan-be kale, beyo tii fengmin uyo kupkan kepmoma kalaa nagon-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kale ipkil utamin. Niyo Mo Tibil imi Man kale, nimi titil kiim uyo kafalebelita, ibo utamipta e, beyo bisop baganbaala kale, kafin diim alba koyo, beyo tii unang tinum imi fengmin uyo kupkan kepman-tema kalaa nagelan-temip o,” agan tolom-nala e minte, ");
INSERT INTO tlf_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","tinum magal fagaa kubesu bemi bogobe-nala e, “Kabaa. Fen-nalap kapmi kamtamo tilip umi ilet uyo kuptamo-nalap kalapmi am iinaal o,” agela e bole, ");
INSERT INTO tlf_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","alugum albip bilip imi tiin diim kugol tinum beyo yuut fen mitam abe-nala e, ilami ilet uyo kuptamo tam iina utam kumang mo-nilip e, God imi tok baga-bom deng kup tebe-bom bogo-nilip e, “Nuyo kanupmin kuguup boyo sugamiyok uyo maak utamsaalup o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Kale Yesus iyo asok tam abiip abe-nala e, no ok muk bomi kan tem ko no tama e, asok unang tinum kwiin tagang iyo tal imi diim tal tamip e, kafalem-siit imka-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","yak abe abe-bom-nala e, tam Alfius imi man Livai ita atama kale, beyo takis mani kwaamin tinum kale, ilami ofis kutam kal tonba kalaa age Yesus iyo bogobe-nala e, “Nugum kabaa. Kapmi ogok ke-balap boyo kupkaa talapta, niso ninggil abe-bomta nimi ogok usiik maak kopkelita, ogok kemal o,” agela e bole, tam fen-nala e, Yesus imi daang begebe una ko. ");
INSERT INTO tlf_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kale Yesus ninggil iso Livai so iyo ofis uyo kupkaa no Livai imi am kal iman unan-kalip ko. Kale takis mani kwaamin tinum kwiin tagang sino e minte kuguup mafak waafulin unang tinum migik sino iyo suun kup Yesus imi daang begebelip tiinan-bomip kale, kota kwiin tagang iyo tam Yesus sino imi okumop man sino ton-bom iman unan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kale tam ulo utamsip tinum iip maak maak bilip iyo Falosi kale, bilip iyo Yesus iyo atamipta e, Yesus iyo tam takis mani kwaamin tinum so e minte kuguup mafak waafulin unang tinum migik so iman unan-bilip kalaa age-nilip e, kota Yesus ilami okumop man imi bogobe-nilip e, “Yesus bemi tebe takis mani kwaamin tinum so kuguup mafak waafulin unang tinum migik so iman unan-be boyo mafak o,” agelip ");
INSERT INTO tlf_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesus iyo weng boyo tinangku-nala e, kota Falosi iyo do weng maak bogobela, “Tam tinum tambal albip iyo dokta imi finang uyo unon-temaalip kale minte, fen tinum mafak albip ita kup dokta imi finang uyo unon-temip kale, ulutap mungkup, unang tinum bogo-nilip, ‘Nuyo fengmin binim kale, tol kup unang tinum o,’ agan-bilip ita niyo tal dong daga-e-bilita, imi aget uyo fupkela ko God imi ilak uyo dolin o ageta tisaali kale, unang tinum bogo-nilip, ‘Nuyo fengmin unang tinum o,’ agan-bilip bilip ita niyo tal dong daga-e-bilita, imi aget uyo fupkela ko God imi ilak uyo dolin o ageta ti-sii o,” agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Kale am maak daanu e, ok sam uga-emin tinum Jon Baptis imi okumop man sino Falosi so iyo unan-kalin uyo fala-bom beten ke-bilip e, unang tinum maak tal Yesus imi daga-nilip e, “Jon Baptis imi okumop man sino Falosi imi okumop man so imi kuguup uyo, iip maak umi beten kemum o agelan-temip uyo, bilip iyo unan-kalin uyo fala-bom-nilipta, fomtuup beten kem-nuubip kuta minte, kapmi okumop man bilip ita unan-kalin uyo falamin binim, beten uyo kem-nuubip bota, intaben o age-nilipta, bilip iyo unan-kalin uyo falam-nuubaalip o?” agelip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesus iyo bilip imi weng uyo yan kebe-nala e, ilami kaanan-tema umi sang uyo felep yak tinum unang kulan-tema imi diim to bogobe-nala e, “Tam tinum iyo unang kulan-tema uyo, tinum ilo iyo tebe iman fuu-bom unan-bom deng tebeman-temip ko. Kanuman-temip kota, tinum migik iyo felepmuta, bogobe-nala e, ‘Ibo deng tebe-bom unan-kalin ba kale, aget iluum uyo tebe-bom unan-kalin uyo falamin o,’ agelan-tema bele ki? Umbae. Tinum ilo iyo utamipta, nugum iyo nuso alba kalaa age deng tebe-bom-nilipta, iman uyo unan-kalon-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kuta biilan-temu kutop uyo, waasi iyo tebe tal-nilip e, bilip imi ipkum iyo aafuu dep unip kalaa age-nilipta, ipkumal iyo aget iluum tebebeluta, unan-kalin uyo falalan-temip o,” age Yesus iyo do weng uyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Kale Yesus iyo (Juda kasel iyo itamata e, ilimi siin kuguup uta fomtuup waafusipta, nimi kamaa kuguup uyo waafulaalup o agan-bilip kalaa age-nalata,) asok do weng alop maak bogobe-nala e, “Unang uyo felepmuta, kamaa ilim fangaa kwep tal diing daa kolin-tem albu uyo maak ugaa ku kwep yak siin ilim fengela tebebu umi diim daa bigilan-temu a? Umbae. Kanupman-temu bole, diing daa kolan-temu uyo, kamaa ilim uta alula kolan-temu kale, ilim kup-diilu fonganu asok migilan-temu uyo, nagat moluta, siin ilim uta yuut balata tebe bigi koluta, tem kiim kelan-temu ko. ");
INSERT INTO tlf_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Aa mungkup ulutap kale, tinum iyo meme kaal siin dalaa kwep daala fonganbu umi tem ku-tele kamaa umi wain ok ko age sok dum ok uyo ilu kola dongenu kalaa age-nala e, sok ku tem uyo de ko-nala e, kwep tal am daala umdii, siit-nuluta, ok uyo fitin unom-nuluta, meme kaal totanin boyo yuut nagat mo bigin-nuluta, ok uyo singkam daa daaginon-temu e minte, kaal uyo mafagan-nuluta, fengela tebelan-temu no kale, tinum iyo, kamaa umi wain ok uyo ilu kolan o agela umdii, meme kaal uyo kamaa dalaa kwep daala totanin binim albu uta kup ku-nalata, wain ok uyo ilu kwep tal daalan-tema bota tambaliim nan-temu o,” age Yesus iyo do weng alop boyo baga-ema ko. (Kale do weng alop boyo bogo-nulu, “Niyo, kamaa kuguup kwep tal ipmi siin kuguup uyo anung tifipman o ageta tisaali kale, niyo kamaa kuguup uyo kwep tilita, uta tele waafulin o ageta kwep ti-sii o,” age-suu ko.) ");
INSERT INTO tlf_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tam God imi ifin am ko age ulotu am maak daanu e, Yesus so ilami okumop man isino iyo rais ko age wiit ilang umi iibak tem miton kutop-tele ninggil dagaa dep unip ko. Kale ilami okumop man iyo abe-bom-nilip e, iman tep tebepmu e, wiit san uyo ugu kulu-nilip e, unan tam tam abe-bilip e, ");
INSERT INTO tlf_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Falosi iip maak maak iyo Yesus imi bogobelip, “Kabaa. Kabo tinangku-salapta. Numi ulo uyo bogo-nulu e, ‘Ibo God imi ifin am uyo iman fagan-bii kulep telemin ba o,’ agesu kuta, intaben o age-nilipta, kapmi okumop man iyo wiit boyo uga-bomta unan-bilip a? Bilip iyo numi ulo uyo kufak dagan-bilip o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","minte Yesus isiik bogobe-nala e, “Ibo God imi suuk kon tem weng tikim-nuubip boyo dagaa kusaalip aga? Sugamiyok uyo Devit isino ilami waasi dinan-kalin tinum isino ninggil imi iman binimanepmu iman tep tebepmu bom-nilip uyo, Devit iyo intaben nusa a? ");
INSERT INTO tlf_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ulotu umi ulo uyo bogo-nulu e, ‘Tinum unang ibo pris ko age tinum amem imi bret fuu kulep no God imi kobelum o ageta God imi am kutam tom-nuubip boyo unan-kalin ba ko. Boyo amem kale, tinum amem ita kup unan-kalin o,’ agesu kuta, Abayata imi mitam tinum amem imi kamok miton ko age hetpris ke bom-bala kota, Devit iyo God imi am kutam uyo no-nala e, tinum amem iyo iman amem umi sang dagala tinum amem iyo du-filin daa iman amem uyo kopma e, Devit iyo atuk fagaa ku une-nala e, atuk uyo ku ilami waasi dinan-kalin tinum iyo kopma unesip ko. Kale ninggil bilip iyo ulo uyo ilo kosip kuta, ibo bogo-nilip, ‘Boyo kuguup mafak kanubesip o,’ agan-nuubaalip kuba. Kale intaben o age-nilipta, nimi okumop man iyo iman tep tebepmu kanu-bilipta, ibo bogobe-nilip, ‘Boyo kuguup mafak kanu-bilip o,’ agan-bilip a? ");
INSERT INTO tlf_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","“Sugamiyok God imi unang tinum telela imosa uyo ki, ilami ifin am umi aget uta kup fugun-bom-nalata, telela imosaala kale, God imi aget fugunin uyo, ifin am boyo tebe unang tinum imi dong daga-emuk o age-nalata, ilami ifin am boyo telela kobesa kale, ");
INSERT INTO tlf_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Mo Tibil imi Man niyo alugum mufekmufek umi tiin molin tinum e minte, God ilami ifin am umi tiin molin tinum no iyo kalbi kale, niyo tii unang tinum imi bogobe-nili, ‘God imi ifin am diim kagal ibo bo kanumin o,’ age-nimi o,” age Yesus iyo Falosi imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kale Yesus iyo asok no Juda kasel imi ulotu am maak tam una kale, tinum maak sagaal milii fuulanebesa iyo kugol alba kale, ");
INSERT INTO tlf_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Falosi kutam albip iyo aget fugun-bom-nilip e, “Yesus iyo tele atama-bomta, numi ulo uyo ilo ko-nala God imi ifin am daanbu diim kagal tinum beyo telela dola kalaa agelup umdii, dep no weng telelmin diim daa dupkem daalum o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kale Yesus iyo tinum sagaal milii fuulanebesa bemi bogobe-nala e, “Kabo fen tal miton kagal molal o,” agelata, tal mola e, ");
INSERT INTO tlf_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Yesus iyo Falosi bilip imi daga-nala e, “Numi ulo uyo bogo-nulu, ‘Kabo God imi ifin am daanu uyo unang tinum iyo dong daga-emal o,’ agesu bele, ‘Ifak dagamal o,’ agesu a? Bogo-nulu, ‘Kabo unang tinum mafak ilin iyo telela imolap waalanamin o,’ agesu bele, ‘Imkalap kaanamin o,’ agesu o?” agan-be kuta, weng sining agelip ko. ");
INSERT INTO tlf_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kale Yesus iyo kugol mo-bom alugum iyo tele itaman tiine-bomta e, bilip iyo God imi weng uyo tinangkulaalup o agan-bilip kalaa age-nala e, imi aget tem uyo mafaganepmu e minte, olsak kup deebe no keluta, Yesus iyo tinum sagaal milii fuulanebesa bemi bogobe-nala e, “Kapmi sagaal uyo tifi kolal o,” agela e, tinum imi sagaal uyo tifi kola e, tambalanepmu ko. ");
INSERT INTO tlf_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kale Falosi iyo yuut tam abe no tamip King Herot imi tinum iso ninggil weng tegen-bom-nilip e, “Yesus beyo dogobeta angkolup kaanak o,” age tegenip ko. ");
INSERT INTO tlf_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Kuta Yesus so ilami okumop man so ninggil iyo imkaa tam abe top Galili Ok Muk unip e bole, Provins Galili unang tinum kwiin tagang iyo Yesus imi daang begebe unip e minte, Provins Yuudiya kasel so, ");
INSERT INTO tlf_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalam kasel so, Provins Idumea kasel so, yak Ok Jodan milii kasel so, abiip Taya so abiip Saidon so umi mep so so ko nin unang tinum kwiin tagang iyo Yesus imi alugum kuguup kanu-be umi sang uta tinangku-nilip e, dagaa kulep imi finang tilip ko. ");
INSERT INTO tlf_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Kale tal tamip e, unang tinum kwiin tagang iyo telela imka-bala e, unang tinum mafak ilin iyo, sagaal kulep yak melebelupta, nuyo telela imolak o age-nilipta, tala tala ke bugulip e, Yesus iyo itamata e, unang tinum ibolip kalip ita tebe nimdek kabilalan-temip kalaa age-nala e, ilami okumop man imi bogobe-nala e, “Ibo bot umaak kupne tal mep so ku daalipta o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kale sinik mafak bilip iyo Yesus imi atamip uyo, bilip iyo kamok imi weng umka-emin umi kuguup uta ku-nilipta, ilimi katuun duung uyo fegela daak Yesus imi miit tem kube suk mo kalaak fen ol-bom-nilip e, “Kabo God imi Man o,” agelip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yesus iyo fomtuup bogobe-nala e, “Ibo, ‘Beyo God imi Man o,’ age-nilip nimkem dagamin ba o,” age-nala e, sinik mafak bilip iyo fot tebela yak iinemip ko. ");
INSERT INTO tlf_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","14","Kale Yesus iyo yak abe tam amdu tigiin maak tam una kale, beyo tinum tuluun kal maak, ita o age ulu-nalata, bilip ita olabela tilip e, bogobe-nala e, “Ibo nimi kalaan tinum kelip kale, niso nip kale, ipta kululi God imi weng tambal uyo unang tinum iyo baga-e-bom-nilip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","titil kobeli uta ku sinik mafak tebe unang tinum ifak dagan unsip iyo fot tebe-bom no kemin o,” age-nala e, ulula ko. ");
INSERT INTO tlf_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kale tinum tuluun kal bilip imi win uyo kalbu kale, tam Saimon imi win migik uyo Yesus ita, “Fita o,” ageba yagal, ");
INSERT INTO tlf_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","minte Sebedi imi man Jems so ilami niing Jon so alop bilip imi win migik uyo Yesus ita bogobe-nala, “Boaneges ko age tumuun fagabu ulutap o,” agela alop igil ");
INSERT INTO tlf_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","minte Andru yagal, Filip yagal, Batolomyu yagal, Matyu yagal, Tomas yagal, minte asegim Jems beyo Alfius imi man kale, yagal, Tadius yagal, asegim Saimon Rom kasel itafinonin tinum yagal, ");
INSERT INTO tlf_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","minte Yesus imi dupkem daala angkolan-temip tinum Keriot kayaak Judas yagal no ninggil kalip ita ulula ko. ");
INSERT INTO tlf_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kale Yesus ninggil iyo tam am iinip e, unang tinum kwiin tagang iyo asok tal ibolipta, ninggil iyo dogobeta iman uyo une-nimip binim kelip ko. ");
INSERT INTO tlf_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kale Yesus ilami duup-afin iyo boyo tinangku bogo-nilip e, “Beyo ilum ilum bii tonsa kale, kota no Yesus iyo ulaa dep tulum o,” age-nilipta, tilip ko. ");
INSERT INTO tlf_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kale ulo utamsip tinum abiip miton Jerusalam ilota tal albip iyo bogo-nilip e, “Sinik mafak imi kamogim Belsebul ko age Saatan iyo Yesus imi diim kal bom-nalata, dong daga-e-balata, beyo unang tinum sinik mafak imdugan unsu ita fot tebela yak iinan-bilip o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kale Yesus iyo unang tinum tal ibolip bilip iyo olapma tal ilami mep so tilip e, weng felep yak ku to dek ku to ke-bom bogobe-nala e, “Saatan iyo dogobeta sinik mafak migik ilami ogok ke-emin iyo fot tebela yak iinoma binim ko. ");
INSERT INTO tlf_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Abiip maagup uyo bigi ko miit alop kelu alop igil dinan-kalip umdii, kulip imi titil fagaa tambaliim bomip uyo kota imi titil umdii binimanan-temu e minte, ");
INSERT INTO tlf_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ulutap mungkup, unang tinum am maagup albip iyo suun wengaal digin-bom dinan-kalin kup kemip umdii, maagup tambaliim nan-temaalip binim kale, igil bigi ko una tala ke no kelan-temip kale, ");
INSERT INTO tlf_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ulutap Saatan so ilami sinik mafak so ulimal igil waasi kebina tala ke bigi ko miit alop ke dinan-kalip nimnam, ulimal kulip iyo titil fagata tambaliim albaalip e minte, bilip imi titil uyo, binimanepman o angbu no kuta ko. ");
INSERT INTO tlf_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Tinum dogap ita tam tinum titil tebesa imi am unom imi mufekmufek uyo dugubelan o agela umdii, yuguut unin beyo tebe kamaki kugol tinum titil tebesa beyo sok de do-nalata, kaal binim tam-nalata, imi mufekmufek uyo dugubelan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Kale niyo weng koyo tuluun baga-e-bii kale, tinangku-silipta. Tinum dogap ita kuguup mafak ke-bom weng mafak baga-bom ke-boma nala imi aget uyo fupkela ko imi kuguup mafak ke-be uyo kupkala umdii, God iyo tebe bemi kuguup mafak ke-boma boyo tagaa kupkan kebelan-tema kale minte, ");
INSERT INTO tlf_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","tinum dogap ita God imi Sinik Tambal imi sang bogobe-nala, ‘Belsebul ko age sinik mafak imi kamok ita tebe Yesus iyo dong daga-e-be o,’ agelan-tema uta, God imi Sinik Tambal imi win uyo kufak daabela kalaa age-nalata, God iyo tebe bemi fengmin boyo tagaa kupkan kebelan-temaala kale, fengmin bomi yuum uyo kupkabelata, bemi diim kal suun kup nan-temu o,” age Yesus iyo ulo utamsip tinum imi baga-ema kale, ");
INSERT INTO tlf_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","boyo dok umi magam uta ba kale, bilip iyo bogo-nilip, “Beyo sinik mafak iyo bemi diim kal alba o,” agelip bomi sang uta Yesus isiik yan kebe baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kale Yesus imi ogen so nagalal ninggil so iyo tal-nilip e, abiip kutam kal mo-nilip e, weng kwaalip am kutam iinu e, “Numi finang talaal o,” agan-kalip e, ");
INSERT INTO tlf_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","unang tinum kwiin tagang iyo tonan tiinan-bii Yesus iyo fufala dubak mobip kale, bogobe-nilip e, “Nugum kabaa. Kapmi kogen so nagalal so uptil iyo talta, kapsino weng maak bogolum o ageta talta abiip katam kal mobip o,” agelip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesus isiik unang tinum bilip imi daga-nala e, “Iyo waanta nimi aben so nimi nagalal so o?” age-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","tonbip iyo itaman tiine-bom bogo-nala e, “Kalip ita nalami aben so nagalal so ilitap kale, ");
INSERT INTO tlf_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","unang tinum iyo dogap ita God imi bogo-nala, ‘Bota kanumin o,’ agan-be uta kup waafulip umdii, bilip ita nimi nengal, niingal minte aben no ilitap o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Kale Yesus iyo daage top Galili Ok Muk daang diim kugol asok dubak kobe unang tinum iyo kafale-bomta utamata e, unang tinum kwiin tagang iyo tala tala ke fufala namak molip kalaa age-nala e, tam bot maak ok daang kun diim kugol albu bomi tem kutam kal tona e, unang tinum kwiin tagang ita minte mek ok daang diim kal mo no kelip e, ");
INSERT INTO tlf_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","weng kwiin tagang uyo felep yak ku to dek ku to ke-bom kafale-bom-nala e, do weng maak bogobe-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ibo tinangku-silipta. Tam tinum maak iyo rais ko age wiit umi san uyo kulep no ilanggiip kugol segelaman o age-nalata, una kale, ");
INSERT INTO tlf_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","san uyo kulep no segelam tiine-bala e, san iip maak uyo daak ilanggiip umi ilep kem diim kubelu e, uun tebe tal unelip ko. ");
INSERT INTO tlf_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Minte tam ilanggiip bomi kafin atuk maak uyo tuum tagang ke-nulu e minte, tol uta katip no kale, san iip maak uyo daak kanupmin kafin bomi diim abelu kale, tuum tip diim uyo tol katip so kale, maak fagaa bigin mitam tebelu kuta, ");
INSERT INTO tlf_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","timtim uyo fomtuup daak bigilin-tem kale, ataan mimin tebe wiit san boyo fuulu ken tebe-nulu e, datan kaanu ko. ");
INSERT INTO tlf_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Minte san iip maak uyo daak ifuul mafak umi iibak tem abelu e, ifuul mafak uta uta kelu e, wiit uyo ditutan mafagan-nulu e, dogobeta tambaliim abu-numu binim kelu ko. ");
INSERT INTO tlf_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Minte san iip maak uyo daak kafin tambal diim abe-nulu e, tambaliim bigin tebe te tam sengan-nulu e, abu-bii ko-nulu e, talkun kun maagup diim kwegal iip maak uyo 30 abulu e minte, iip maak uyo 60 abulu e minte, iip maak uta 100 abulu no kelu ko. ");
INSERT INTO tlf_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kale ibo tolong kom ba kale, tolong tambal kale, weng ko bogobeli boyo tele tolong do-nilipta, dagaa kulin o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kale bii Yesus ilasinon kela uyo, ilami okumop man tuluun kal so e minte tinum iip maak maak Yesus iso maagup albip so iyo tebe-nilip e, do weng iip maak maak umi sang uyo dagalip e, ");
INSERT INTO tlf_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesus isiik bogobela, “Siin uyo God iyo unang tinum ilami daam tem mitam tilip tiin molan-tema umi sang uyo alugum baga-emsaala kale, atuk uta kup kale, kamano koyo God yagal ipmi aget tem uyo bam daabela ipkil utamipta e, Yesus imi do weng ko baga-e-be bomi magam uyo tam God imi daam tem unup tiin molan-tema umi sang uta kalaa age utabip kuta minte, unang tinum God imi ilak dolin binim kesip iyo niyo tebe do weng uta kup baga-em-nuubi ko. ");
INSERT INTO tlf_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kuta unang tinum God imi ilak dolin binim kesip iyo ki nimi ogok telela-bii boyo ilimi tiin fala utaman-nuubip kuta, imi aget tem uyo maak bam daabesaalu binim e minte, ilimi tolong alop uyo nimi weng boyo tolong dugan-nuubip kuta, iyo utamipta, weng bomi magam uyo kulbu kalaa age-nilipta, bilip iyo aget fupkela kolip God iyo imi fengmin uyo kupkabela biniman-numu binim ke no kelip kalaa age-nilita, nagal do weng boyo kanupmin unang tinum bilip imi baga-emin kup kem-nuubi o,” agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kale Yesus iyo asok bogobe-nala e, “Ibo nimi felep yak wiit san umi diim to do weng ko bogobeli bomi magam uyo utamin-tem aga? Kale utamin-tem kelip bole, ibo dogobeta alugum do weng migik umi magam uyo utaman-temip a? Kale tinangku-silipta. ");
INSERT INTO tlf_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Wiit san fagagamin tinum beyo God imi weng baga-emin tinum ita kale, ");
INSERT INTO tlf_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","tam unang tinum iip maak maak iyo tinum imi wiit san segela kulula daak ilep kem diim abebu ulutap kale, iyo mitam God imi daam tem telemin umi sang uyo tinangkulan-temip kuta minte, iyo maak tele utamin-tem kem-nuubip kale, Saatan iyo uun ilatap ke yuut tal-nala e, God imi weng aget tem kalaak albu uyo dagaa kupkan kebelata, unang tinum iyo weng boyo ilumanebelan-temu ko. ");
INSERT INTO tlf_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Minte unang tinum iip maak maak iyo tinum imi wiit san segela kulula daak kafin tuum tagang tem umi diim abebu ulutap kale, bilip iyo God imi weng uyo tolong do-nilip e, weng boyo yuut, ‘Aafen o,’ age deng tebeman-temip kuta, ");
INSERT INTO tlf_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","weng boyo fomtuup kwep yak ilimi aget tem daalin-tem ke siitap ilugo-nilip e, mufekmufek mafak uyo tal bilip imi diim abelu min, tinum migik iyo tebe God imi weng umi kalan uta bilip iyo bon dii-emip min uyo yuut kupkaa yang iinon-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Minte unang tinum iip maak maak iyo tinum imi wiit san segela kulula daak ifuul mafak umi iibak tem abebu ulutap kale, bilip iyo God imi weng uyo tolong dolan-temip kuta, ");
INSERT INTO tlf_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kafin diim komi mufekmufek duumatanan-temip umi aget afek fugunin min, mani kwaa-bom deng tebemin min, yak abe mufekmufek boyo nalami alugum kululan o age aget kup ugel kalagamin uta afaligen ke-nuluta, God imi weng umi aget uyo kubaganu kupkalan-temu kale, wiit umi dam binim, ol kup kelu ulutap ke-nilipta, God imi weng uyo fomtuup dital fagaa waafulan-temaalip ko. ");
INSERT INTO tlf_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Minte unang tinum iip maak maak ita tinum imi wiit san segela kulula daak kafin tambal diim abebu ulutap kale, iyo God imi weng uyo tolong do-nilip e, ‘Aafen o,’ age suun kup waafuu kanuman-temip uyo, tam iip maak iyo wiit kwek umi 30 abubu ulutap kela e minte, iip maak iyo 60 abubu ulutap kela e minte, iip maak iyo 100 abubu ulutap ke no kelan-temip o,” age Yesus iyo do weng bomi magam uyo dupkop daga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kale Yesus iyo bogobe-nala e, “Nuyo ilaam uyo kefo kwep daak baket tem kulagal kubalan-temaalup binim e minte, kefo kwep daak bet afak tem daalan-temaalup no (kale, kefo kwep tam ulumi baan diim daalupta, am uyo ilagenuta, unang tinum am kutam albip iyo mufekmufek uyo tambaliim utaman-temip) ko. ");
INSERT INTO tlf_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kale biilu am afungen daanan-temu kota, nimi mufekmufek sang so weng magam so bantap kuba-bom-nili felep yak ku to do weng uta kup baga-em tebesi uyo God yagal kwep mitam kupkem daalata, alugum unang tinum iyo utaman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ibo ki tolong kom ba kale, tolong tambal kale, weng ko bogobeli boyo tele tolong do-nilipta, dagaa kulin o,” age baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kale Yesus iyo aa weng maak uyo bogobe-nala e, “Weng kaa ipmi bogobelan-temi koyo tele tinangku-silipta. Kapmi kapkumal iyo dogonupmin kuguup kafale-bomap umdii, God yagal kanupmin kuguup boyo mungkup kabo kafalepke-som-nala e minte, aa atuk uyo maak so tifipke no kelaman-tema kale, kapkumal iyo kuguup mafak uyo kupka-emin ba ko. ");
INSERT INTO tlf_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kale minte tinum dogap ita nimi weng uyo tolong do dagaa kula umdii, beyo God tebe dong daga-e-bala dagaa ku yakyak kem unon-tema kale minte, tinum dogap ita nimi weng uyo, tele tolong do dagaa kulaali o agela umdii, bemi kamaki kutop umi katip maak atam-se ita kup siit-nala e, ilumano kupkalan-tema o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kale Yesus iyo asok bogobe-nala e, “Unang tinum God imi daam tem mitam tilip tiin molan-tema uyo tinum mufekmufek san fagala tebebu ulutap kale, ");
INSERT INTO tlf_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","fagaa kupkaa no bom mililep uta agaal un sina-bom-nala e minte, taap uta ogok kem tiine-bom no ke-balata, mufekmufek san boyo ugol bigin mitamta senganan-nuubu kuta, beyo utamata, mufekmufek san boyo dogobeta mitam biginu kalaa agan-nuubaala binim (kale, ulutap mungkup ibo utamipta, unang tinum iyo dogobeta mitam migik ke-nilipta, God imi daam tem uyo unon-temip kalaa agan-kalin binim no) ko. ");
INSERT INTO tlf_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kale mufekmufek san uyo kafin tem kulagal fagalip bii, mitam bigin-nuluta, abum-nuubu kale, kamaki uyo kon usiik togo-nulu e bole, tet sing dii-nulu e, kota damanan-temu ko. ");
INSERT INTO tlf_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kale utamata, damanu boyo, ulumi dagamin am uyo ko mitam tulu kalaa agelan-tema uyo, yuut no dagan-bii kulep tolon-tema o,” age Yesus iyo kam agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kale Yesus iyo asok bogo-nala e, “Niyo unang tinum mitam God imi daam tem tilip tiin molan-tema umi sang uyo felep yak dok umi diim to-nilita, bomi magam uyo dupkop daabeli ibo utaman-temip a? ");
INSERT INTO tlf_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Uyo? Unang tinum God imi daam tem albip bilip iyo mastat umi san ilitap kale, kafin kaa kutufosu komi mufekmufek umi san iip maak maak uyo katip kuta, mastat san fagalan-temap beta atin fen ilap katipnok kuta minte, ");
INSERT INTO tlf_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","tinum maak tebe dep yang dola bemi tebe te tam kwiin kiim kelan-tema uyo, umi tung uyo kwiin kiim ke-nulu e, te tam at ulutap ke kolu e, uun iyo tebe te tam umi tung diim tabanim tem kutam kal imi um uyo dinan-kalon-temip o,” age Yesus iyo bogola ko. (Kale do weng bomi magam uyo bogo-nulu e, “Mastat umi san kulatap mungkup God imi unang tinum iyo kamano koyo iip maak maak kup kebip kuta minte, son-temu uyo, te tam te tam kem kwep unanbu top kwiin tagang kelan-temip o,” agesu ko.) ");
INSERT INTO tlf_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Kale Yesus iyo utamata, dogonupmin dogonupmin umi do weng uta unang tinum iyo tii utaman-temip kalaa age-nalata, bota kup kwiin tagang uyo baga-e-bom God ilami kuguup umi sang uyo felep yak ku to-nalata, baga-em-nuuba kale, ");
INSERT INTO tlf_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","do weng uyo kupkaa tol weng uta ku-nalata, unang tinum bilip iyo baga-em-nuubaala kale, ilami okumop man so na uta kup alugum do weng umi magam uyo tol dupkop daga-em-nuuba ko. ");
INSERT INTO tlf_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kale am ko daan-bom-sulu kota, ataan uyo te daak tem iinu e, ilami okumop man iyo bogobe-nala e, “Tilip ninggil koyo kupkaa bot tem ilep yak ok muk afalik umi milii katam iinum o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ninggil iyo unang tinum kwiin tagang kugol albip bilip iyo imka-nilip e, ilami bot tem tonba uyo tam-nilip e, duptamo bot tem kutam-tele unip e minte, unang tinum iip maak maak iyo bot migik tem ilep iso unip ko. ");
INSERT INTO tlf_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kale abe-bilip e, tam dulul afalik maak mitam abuta, ok uyo ifo kulalu mitam bot tem e tele-bom-nulu e bole, bot uyo ok tebeta mitam dongenan o angbu kuta, ");
INSERT INTO tlf_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesus iyo bot umi kagam tem katop kal bom dubom kwep met dubom am diim daa agaal unba kale, ilami okumop man iyo tebe dufo bogobe-nilip e, “Numi kafalemin kabaa. Mep so anolu kaanum o angbup koyo, kabo numi aget uyo fugunin binim bele ki?” agan-kalip e, ");
INSERT INTO tlf_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","kota Yesus iyo fen tiin baa-nala e, dulul uyo un-togon-bom bogobela binimanu e minte, ok umi bogobe-nala e, “Kota bilili age-nalap sining agelal o,” agela atin sining age biniman no kelu e, ");
INSERT INTO tlf_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","kota ilami okumop man imi bogobe-nala e, “Ibo intaben o ageta ok atul uyo finan-bilip a? Ibo nitamipta, Kamogim bemi nuso alba boyo kaal binim kalaa nagan-bilip aga o?” agan-kala e bole, ");
INSERT INTO tlf_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","kota ninggil iyo kwiin kumang mo bogobina tala ke-bom-nilip e, “Keyo dogonupmin tinum ita tebe-nalata, weng uta kup bagam-salata, dulul sino ok sino koyo imi weng uta kup tolong do-nuluta, binimanu o?” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kale Yesus so ilami okumop man sino iyo bot tem ilep unanbu yak ok muk afaligen umi milii Gerasa kasel imi kafin yak-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesus iyo bot tem uyo kupkaa daak kafin diim tama e, tinum maak sinik mafak tebe dufak daasa iyo tal Yesus imi diim kal abu mola kale, tinum beyo begel ilet tem ilota mitam abeta tala ko. ");
INSERT INTO tlf_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Kale beyo suun kup begel ilet tem kal boma kale, tinum iyo dok ita maak bagang-kale-nalata, aafu-nama binim e minte, sok min sen ko age ain sok uyo ku-nalata, de do-nama binim no kale, ");
INSERT INTO tlf_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ipkumal iyo, “Dupka-sulup yem-nama o,” age-nilipta, suun kup imi yaan so sagaal so uyo sen kulu dinan-bii kobelipta, ugel ugel kulula une-buluta, tinum dok ita maak bagang-kale titil faga-nalata, tinum beyo aafu-nama binim ko. ");
INSERT INTO tlf_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kale suun kup mililep so taap so uyo beyo amdu tigiin so begel ilet tem so uyo tiine-bom atul faga-bom-nala e minte, ilami kaal uyo tuum falal tuup duul-bom no kem-nuubata ko. ");
INSERT INTO tlf_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kale tinum beyo tal mep so tilin-tem simanim ilota Yesus iyo atam-nala e, kamok imi weng umka-emin umi kuguup uyo kanumin kale, yuut no Yesus ilami miit tem kugol daak katuun duung fegela suk mo kalaak fena e, ");
INSERT INTO tlf_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yesus iyo sinik mafak bemi bogobe-nala e, “Sinik mafak kabo tinum beyo dupkaa yak iinaal o,” agela e, tinum beyo fomtuup ol-bom-nala e, “Yesus kabo Atin Win Tibin God imi Man aligaap kale, kabo talta, intaben nupnelan o age-nalapta, talap a? Niyo God imi tibit diim kal weng uyo bagake-bii kale, kabo niyo kaal fuyap afek uyo kupkanemin ba kale, nimkalal o,” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesus isiik tinum beyo daga-nala e, “Kapmi win uyo Intapnak o,” agela e, tinum beyo utamata, sinik mafak kwiin tagang iyo nimi iibak tem albip kalaa age-nalata, bogo-nala e, “Nimi win uyo Yamyam o,” age-nala e minte, ");
INSERT INTO tlf_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","fomtuup Yesus imi bogobe-nala e, “Kabo sinik kalip iyo fot tebelap yak bagan migik unemin ba o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kale yak ilok maak kugol kong kwiin tagang maak buk faga-bom albip kale, ");
INSERT INTO tlf_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","sinik mafak bilip iyo Yesus imi fomtuup daga-nilip e, “Kabo nuyo fot tebelapta, tinum keyo dupka-nulupta, yak kong bilip imi tilin tem iinum o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesus iyo, “O,” agela e, kota sinik mafak umdii tinum beyo dupkaa mitam abe-nilip e, yak kong bilip imi tilin tem iinip e bole, kong igil ilum ilum ke-bii ko-nilip e, ilok dup-kalaak mo unanbu daak Galili kumun tem kulaak iinom-nilip e, kong ilimi kup 2,000 kalip iyo ok tebe mimilepmu alugum kaanip ko. ");
INSERT INTO tlf_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kale tam kong tiin molin tinum igil sigin-bii bilii daage weng kwep no abiip miton tono, abiip kangkang tono bomi sang uyo baga-em tiinan-bilip e, unang tinum iyo, no-nulupta, kanubelu boyo utamum o age-nilipta, daage tal ");
INSERT INTO tlf_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yesus imi diim tal abomu, tinum siin sinik mafak kwiin tagang tebe dufak daalip nuuba imi aget fugunin uyo tambalanepmu ilim migi ton-bom alba kalaa age-nilip e, Yesus imi atul uyo finanip ko. ");
INSERT INTO tlf_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kale unang tinum Yesus imi kuguup kanubela utamip ita ipkumal iyo tinum sinik mafak tebe dufak daalip nuuba nala Yesus tebe telela dola imi sang uyo baga-e-bom-nilip e minte, kong kanubelip imi sang uyo baga-e-bom no kemip e, ");
INSERT INTO tlf_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","kota abiip kasel iyo Yesus iyo fomtuup bogobe-nilip e, “Gerasa kasel numi anang koyo kupkaa daaginaal o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kale agelip e bole, Yesus iyo tam bot tem ton-nala e, daaginum o agela e, tinum siin sinik mafak tebe dufak daalip nuuba beyo Yesus imi fomtuup daga-nala e, “Nimkalapta, niyo kapso unum o,” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesus isiik bogobe-nala e, “E-e. Kabo kalapmi abiip uyo asok no-nalapta, Bisel imi tebe ka-filin daa-nala mufekmufek kwiin kiim kanupkela umi sang uyo kapkumal unang tinum iyo baga-em kwep unaal o,” agela e bole, ");
INSERT INTO tlf_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","tinum beyo tam abe-nala e, no Distrik Dekapolis kugol Yesus imi tebe telela dola tambalanba umi sang uyo baga-em tiine-bala e, alugum unang tinum iyo kumang muuna tala kelip ko. ");
INSERT INTO tlf_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kale Yesus ninggil iyo bot tem ilep asok yak ok muk milii tamip e, unang tinum kwiin tagang iyo tala tala kelip e, ok magaang tem kugol bom-nala e, kafalem-salata, ");
INSERT INTO tlf_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","kota Juda kasel imi ulotu tiin molin tinum maak tala kale, bemi win uyo Jairus kale, tal Yesus iyo atam-nala e, kamok imi weng umka-emin umi kuguup uyo kanumin kale, katuun duung fegela daak Yesus imi miit tem kube suk mo kalaak fen ");
INSERT INTO tlf_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","fomtuup daga-nala e, “Nimi man unang amaat uyo, mep so kaanan o agan-suluta, kupkaa tili kale, talapta, alop no-nulupta, kapmi sagaal uyo togobe telela kolapta, asok mitam bam daa tambalanuk o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesus ninggil iyo iso unip ko. Kale Yesus ninggil iyo abe-bilipta, unang tinum kwiin tagang ita tebe Yesus iyo fufala dep iibak kalaak daa unan-bilip kale, ");
INSERT INTO tlf_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","bilip imi iibak tem kwek uyo unang maak albu boyo suun kup ulumi am tem unemin kup nuubuta, atol tuluun kal koyo dakan kelu kwek uyo ki, ");
INSERT INTO tlf_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","dokta ita telela namo-nimip o age-nuluta, suun kup dokta kwiin tagang imi finang uyo no tamu, telelemup ko age kaal fuyap uyo kupka-emin kup ke-bilipta, umi tisol uyo kupka-e-bom saan-buluta bii, umi mani uyo binimanebe-suu kuta, umi mafak ilin uyo maak daak so kepmomu binim kale, atin mafak kup nuubuta, ");
INSERT INTO tlf_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","kota Yesus imi sang uyo tinangku-nulu e, tal unang tinum imi iibak tem ilep tal-nulu e, Yesus imi umik tem ko mo-nulu e, umi aget fugunin uyo, niyo yak Yesus imi umik tem ilim kaal bota kup maagalo yak waafulita, telela namola tambalanan-temi kalaa age-nulu e, umi sagaal uyo maagalo kwep yak Yesus imi ilim magaang uta kup melebelu e, ");
INSERT INTO tlf_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","kota maak fagaa umi mafak ilin uyo binimanepmu e, kota utamuta e, nalami am tem unemin kup kem-nuubi uyo binimanepnelu kalaa agelu e minte, ");
INSERT INTO tlf_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesus yagal utamata e, nimi titil atuk uyo maak yak iinu kalaa age-nala e, yuut fupkela katam fen unang tinum ilami umik tem albip imi bogobe-nala e, “Iyo waanta nimi ilim koyo melebela o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ilami okumop man iyo bogobe-nilip e, “Kapkal utamal. Unang tinum kwiin tagang iyo mo-nilip e, kamdep iibak tem daa de namolip kalaa age utabap kale, intaben o ageta bogo-nalap, ‘Waantap ita melepnela o,’ agan-balap o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesus iyo tiin daga-bomta e, waantap ita boyo kanupnela kalaa agon o age-nalata, tiin dagama e, ");
INSERT INTO tlf_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","unang ugol utamuta, telela namola kalaa age-nulu e, finano bamban kup keng keng bii ko-nulu e, kota kamok imi weng umka-emin kuguup uyo kanumin kale, tal Yesus imi miit tem kugol daak katuun duung fegela suk mo kalaak fen-nulu e, ulumi mafak ilin sang so ulumi kanubelu sang so uyo fen kem baga-emu e minte, ");
INSERT INTO tlf_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesus isiik weng uyo agol kup bogobe-nala e, “Nugum kubaa. Niyo utamita, kubo, beyo fen telela namolan-tema kalaa nagan-balap kalaa age-nilita, telela kamoli kupmi mafak ilin boyo atin binimanepkelu tambalanap kale, mafak ilin boyo maak so umolan-temaalap kale, kupmi aget tem uyo bilili age-nalapta, no tambaliim kup bom-balapta o,” agela e, dupkaa unu ko. ");
INSERT INTO tlf_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kale unang boyo daaginin-tem bom-bulu Yesus iyo weng kupka-em-sala e, kota ulotu tiin molin Jairus imi am ogok kemin tinum maak tal Jairus imi bogobe-nilip e, “Kapmi man unang uyo kaanu kale, kabo God imi weng kafalemin tinum beyo bisop uyo dep te no telemin ba o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesus iyo weng boyo tinangku-nala e, ulotu tiin molin imi bogobela, “Kabo finanin ba kale, nitamapta, beyo tii nimi man uyo telela kolan-tema kalaa nagelapta o,” age-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","kota unang tinum imi bogobe-nala e, “Nimi uni koyo alugum ibo te no telemin ba o,” age-nala e, tam Fita so Jems so Jems ilami niing Jon so ita kup imkala e, iso ninggil unip ko. ");
INSERT INTO tlf_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kale Yesus iyo daage no ulotu tiin molin imi am no abomu, Jairus imi duup-afin iyo ilum ilum ke-bom atul faga-bom-nilip e, fomtuup aman-bilip kalaa age-nala e bole, ");
INSERT INTO tlf_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","tam am tam-nala e, bogobela, “Ibaa. Intaben o ageta atul faga-bom-nilip e minte, ame-bom no ke-bilip a? Tam man unang boyo amiit kaanbaalu kale, boyo aminbu ulutap kebu kale, ibo amemin ba o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","unang tinum iyo, beyo bisop bagan-be ko age-nilip e, aban dii-emip e, Yesus iyo tebe unang tinum iyo alugum fot tebela tam abiip iinip e, Yesus iyo man ulumi aalap so ogen so ilami okumop man asuno so ita kup kulep tam abiin maak man unang albu uyo tam-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","man unang umi sagaal uyo waafu-nala e, ulumi weng bagamin uta ku bogobe-nala e, “Talita kumi o,” agela bomi magam uyo, “Man unang amaat kubo fenal o,” agela e bole, ");
INSERT INTO tlf_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","kota ninopmuta, fen mitambe tiinemu kale, man boyo atol ulumi kup tuluun kal dakan kelu kale, kota ogen aalap iyo kumang molip e, ");
INSERT INTO tlf_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesus iyo weng uyo fomtuup bogobe-nala e, “Ipmi man umi kufoli fenu bomi sang uyo unang tinum migik imi diim uyo bagamin ba o,” age-nala e minte, “Unan-kalin umaak man boyo kobelip uneluk o,” agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Kale Yesus so ilami okumop man so ninggil iyo abiip boyo kupka-nilip e, Yesus ilami abiip miton Nasaret e tilip ko. ");
INSERT INTO tlf_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kale iyo tal bom-sala God imi ifin am uyo mitam daanu e, tam ulotu am kutam kal God imi weng uyo kufo unang tinum iyo baga-e-bom kafale-bala e, kwiin tagang iyo tinangku kumang mo-nilip e, bogolip ko. “Fen tinum bemi weng tambal ko kafale-be bota dogap-tele ku-se a? Dogonubeta beyo aget fugunin tambal boyo atin dagaa ku-se a? Waanta kafale-balata, kanupmin mirakel ko age kuguup ugulumi migik boyo kanu-be a? ");
INSERT INTO tlf_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kale siin uyo tinum beyo abiip katam umi at kom bagaa ku mufekmufek telelmin tinum ke-bom-nalata, bii-se kale, beyo Maria umi man e minte, beyo Jems so Josis so Judas so Saimon so ninggil imi fik no kale minte, bemi nengal ita abiip kagal albip (kale, beyo win tibin tinum ba kale, beyo bisop abiip tinum kale, bemi weng uyo tinangkulaalup) o,” age-nilipta, umik ugobelip utam-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesus yagal bogobe-nala e, “God imi profet ko age weng kem baga-emin tinum iyo no abiip maak maak unon-tema uta, abiip kasel iyo bogo-nilip e, ‘Keyo win tibin tinum o,’ age imi weng uyo tele tinangkulan-temip kuta minte, no ilami abiip miton unon-tema uta, ilami abiip kasel min, ilami duup-afin min, ilami isak atuk iyo imi weng umaak tinangkulan-temaalip binim o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","abiip kasel iyo aget fuguno-nilip e, “Beyo God imi titil uyo waafusaala o,” nagan-bilip kalaa age kumang mo-nalata, Yesus iyo kuguup ugulumi migik umaak ilami abiip kugol kanumaala kuta ki, unang tinum mafak ilin iip maak maak ita kup sagaal kwep yak daa telela imola tambalanip ko. Mat 10:5-15, Luk 9:1-6 Kale Yesus iyo Nasaret uyo kupkaa bomi mep so umi abiip maak maak uyo kafalem yakyak kem tiinema ko. ");
INSERT INTO tlf_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kale Yesus iyo okumop man tuluun kal iyo imdali alop ke una una kelin o age-nalata, olabela tal mep so tilip e, tam ilami titil uyo kobe-nala e, bogobela, “Ibo nimi win tolop diim uta sinik mafak mafak uyo fot tebelip yak iinan unin o,” age-nala e minte, ");
INSERT INTO tlf_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","“Ipmi yak abiip maak maak kem tiineman-temip uyo, (abiip unang tinum iyo tebe ibo dong daga-eman-temip kale,) ibo iman min, men afek min, tuumon uyo kulep unemin ba kale, kafung ita kup dulepta tiineman-temip kale minte, ");
INSERT INTO tlf_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","yaan ilom bole fen kulep top tili unon-temip kuta, siyot uyo alop ba kale, maagup uta kup kwaak kalila kwaak kalila ke no ke-nilipta, unon-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kale ibo no abiip maak no unip uyo, am maagup uta kup kutam kal bom abiip unang tinum iyo kafalem-siit-nilip e, aa kupkaa yak abiip maak maak kem tiinemin ko. ");
INSERT INTO tlf_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kale minte kanube abiip maak kutam iyo bogobe-nilip, ‘Alop ibo tele tiin molaalup o, ipmi weng uyo tinangkulaalup o,’ agelip umdii, ibo yang abiip mat kugol mo-nilip e, Juda kasel nulumi kuguup uta ku-nilipta, ifip te yak ipmi yaan diim tububu boyo tolo kululip yak abiip kasel imi ilo unuta bole, abiip unang tinum iyo utamipta e, son-temu uyo, bilip iyo maak so tal dong dogobelan-temaalip kalaa agelipta, imkaa unemin o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","okumop man ninggil iyo daage no unang tinum iyo baga-e-bom-nilip e, “Ibo aget fupkela ko-nilip ilipmi kuguup mafak kanu-bilip boyo kupkalipta o,” agan-bom-nilip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ninggil iyo sinik mafak kwiin tagang iyo fot tebelip yak iine-bilip e minte, kaal diim iligamin umi marasin uyo kulu unang tinum mafak ilin imi dubom diim uyo iligebe-nilip e, beten ke telela imolip mitam tambalana-bom no kemip ko. ");
INSERT INTO tlf_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kale bole Yesus imi win uyo mitam senganu e, King Herot yagal tinangku no kela kale, iip maak iyo bogo-nilip e, “Yesus beyo ok sam uga-emin tinum Jon Baptis kaan-se ita kale, ko God iyo tebe dufola asok fen tigi mo-nalata, kanupmin titil boyo ku bom-nalata, mirakel ko age kuguup ugulumi migik migik boyo kanu-be o,” agelip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","iip maak iyo bogo-nilip e, “Umbae. Beyo sugamiyok God imi profet ko age weng kem baga-emin tinum Elaija bii-se ita ko mitam-nalata, kanu-be o,” agelip e, iip maak ita bogo-nilip e, “Umbae. Beyo Elaija ba kale minte, God imi weng kem baga-emin tinum migik kale, sugayok umi weng kem baga-e-bii-silip ilitap o,” agelip no kem una tala ke-bilipta, ");
INSERT INTO tlf_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herot iyo tinangku-nala e, bogola, “Siin uyo nimi waasi dinan-kalin tinum iyo daali no-nalata, Jon imi dubom uyo ugaa kupkan kebe-se kuta, beta asok God iyo tebe dufolata, fen tigi moba o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Kale Herot imi kanube-se boyo ki, siin kutop uyo Herot ilami imdalim Filip iyo kaanin-tem bom-salata, Herot beyo tebe Filip imi kalel Herodias uyo tagaa kubeba kalaa age-nalata, bota Jon iyo suun kup baga-e-bom-nala e, “Kapkal utamsap kale, kamdalim kalel bomi tagaa kube-nalap kusino nuubap boyo, God imi bogo-nala, ‘Kuguup boyo kanumin ba o,’ agesa uyo ko ilo kobap o,” age yakyak ke-balata, Herodias uyo Jon iyo olsak kobe-nuluta, Herot iyo uget taga-buluta, ilami un tubulin iyo bogopmata, no-nilipta, Jon iyo sok de dep no kalabus am daa-silip ko. ");
INSERT INTO tlf_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Kale Herodias uyo olsak depmu e, Jon beyo dogonupmita, kaanak o agan-kalin kup kemu kuta, Herot iyo Jon iyo atamata e, tinum tambal fengmin binim kalaa age-nalata, Jon imi atul uyo finan-bom-nalata, tambaliim kup tiin mo-bom-balata kale, Herodias uyo dogobeta bagang-kale-nuluta, angko-numu binim ko. Kale Herot iyo Jon imi weng tambal uyo tinangka-bom-nala e, aget yamyam fuguni kalaa age-nalata, kupkalan agin kuta, suun kup Jon imi weng uta kup tinangkaman o agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kale Herodias uyo Jon beyo dogobeta angkoli kaanak o agan tebesu nala e, kota Herot imi ogen dosu umi aget fugunin am uyo daanu e, Herot iyo ilami dong daga-emin tinum so, ilami waasi dinan-kalin tinum imi tiin molin so, Provins Galili kasel imi kamok kamok so iyo olabela tal Herot imi am kutam kal iman un-bom deng tebe-bilipta, ");
INSERT INTO tlf_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodias umi man unang uyo mitam am mitam-nulu e, atol tambal uyo daga-buluta, tam Herot so tinum iso iman unan-bilip sino iyo utam-nilip e, man unang bomi deng uyo tebe-bom-nilip e, tam king iyo man unang amaat bomi bogobe-nala e, “Boyo tambaliim kale, niyo mufekmufek tambal umaak kop-kaman o agan-bii kale, kupkal bogopne-nalap, ‘Intaben umi mufekmufek uta maak kopnelal o,’ agelap kalaa age-nilita, bota kop-kaman-temi kale, ");
INSERT INTO tlf_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","nimi weng koyo atin aafen bogopkeli kale, intaben intaben mufekmufek katip min, bisel min, minte mufekmufek tisol afek ku saanin min kuta, kanube kubo bomi sang dagalap uyo, atin ki maagalo kopkelan-temi o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","kota man unang boyo yuut tam-nulu e, ogen uyo dagalu, “Aben aa. Niyo tamta aben-diim beyo intaben mufekmufek uta, ‘Kopnelal o,’ agelan-temi o?” agelu e, ogen uyo bogolu, “Tam-nalap Herot iyo bogobe-nalap e, ‘Nimi aget fugunin uyo, kapmi waasi dinan-kalin tinum iyo maak daalap no-nalata, ok sam uga-emin tinum Jon Baptis bemi dubom uyo ugaa kwep tal kopnelal o agan-bii o,’ age bogobelapta o,” age ogen uyo bogobelu e bole, ");
INSERT INTO tlf_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","man uyo yuut mitam am mitam-nulu e, king imi bogobe-nulu e, “Nimi aget fugunin uyo, kamaa kagal kapmi waasi dinan-kalin tinum iyo maak daalap no-nalata, ok sam uga-emin tinum Jon Baptis bemi dubom uyo ugaa ku felet diim iinu ifo kwep tal kopnelak o agan-bii o,” agelu e, ");
INSERT INTO tlf_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","kota king iyo tinangku-nala e, utamata e, boyo kuguup mafak kalaa age-nala e, imi aget tem uyo atin mafaganepmu, “Waago o,” agelan agin kuta minte, aget fugunolata, unang tinum kwiin tagang albip kalip iyo nimi weng kwep daali boyo tinangkulip kalaa age-nalata, kalip imi tiin diim uyo boyo kupkalan-temaali kalaa age-nala e, kota, “O,” age-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","king iyo ilami waasi dinan-kalin tinum iyo maak bogobe-nala e, “No Jon imi dubom uyo ugaa kwep talaal o,” agela e, no-nala e, kalabus am katam kal Jon imi dubom uyo ugaa ku-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","felet diim iinu ifo kwep tal-nala e, man unang amaat umi kobelata, uta ku-nuluta, kwep tam ogen umi kobelu ko. ");
INSERT INTO tlf_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kale Jon imi okumop man iyo bomi sang uyo tinangku-nilip e, tal Jon imi at kulu uyo dep no duba-nilipta minte, aaltam kota no Yesus iyo Jon imi sang uyo bogobelip ko. ");
INSERT INTO tlf_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Kale Yesus ilami kalaan tinum imdala alop ke una una ke-silip iyo kota asok tala tala ke Yesus iyo bogobe-nilip e, “Kamogim kabaa. Alugum weng kobelap un-sulup uyo mungkup kanube telel-bom-nulup e minte, alugum kapmi weng tambal uyo kafale-bom no kem unsupta, tulup o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kale unang tinum kwiin tagang iyo tal o unbip tal o unbip ke-bilipta biita, Yesus so ilami kalaan tinum so ninggil iyo, koyo dogobeta iman uyo une-numup binim kelup kalaa age-nala e, Yesus iyo bogobela, “Kaya. Unip ninggil nulusinon no tinum binim iibaan bagan kugol ibo kun katip umaak fungolin tap kelipta o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","kota ninggil ilisinon tam bot tem ton-nilip e, abiip boyo kupka-nilip e, ok muk daang kun diim ilep tam tam no tinum binim iibaan bagan maak unum o age-nilipta, unip ko. ");
INSERT INTO tlf_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kale ok muk magaang tem umi abiip maak maak kasel kwiin tagang iyo itamipta e, Yesus ninggil iyo yak ko bot tem ilep tiinan-bilip kalaa age itam-nilip e, isiik yuut dagaa dep kafin diim ilep no tinum binim iibaan bagan uyo no bom-silipta bole, ");
INSERT INTO tlf_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesus ninggil iyo yak kan tem yakta Yesus iyo itamata e, unang tinum kwiin tagang kalip iyo sipsip imi tiin molin tinum iyo imkala ilisinon bom-nilip ilep uyo kupkaa ilum ilum kem tiinebip ilitap ke-bom God imi tol ilep uyo utamin-tem ke-nilipta, waanta tebe nuyo dong dogobelan-tema o age aget yamyam tagan-nuubip kalaa age-nalata, i-filin daa bii-nala e, kota weng kwiin tagang uyo kufo baga-e-bom kafalema ko. ");
INSERT INTO tlf_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kale kafale-bala ataan uyo tem iinon o agan-sulu e, Yesus imi okumop man iyo tal bogobe-nilip e, “Kafin koyo tinum binim e minte, am kwiin no kelu kale, ");
INSERT INTO tlf_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","unang tinum kalip iyo kululap no abe yak abiip maak maak kugol unan-kalin umaak mo une-nilipta, siin o,” agan-kalip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesus isiik bogobe-nala e, “Bilip iyo kululi unon-temaalip kale, ninggil ipkil unan-kalin umaak ifelip une-nilipta, siin o,” agela e minte, ninggil isiik bogobe-nilip e, “Nuyo mani ulumi kup tu handret (200) umaak kulep nota bret uyo mo kulep tal kopmupta, une-nilipta, siin o agan-balap bele ki?” agelip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","isiik bogobe-nala e, “Ibo bret uyo intap kal albu umdii no utamin o,” agela no utam-nilip e, tal bogolip, “Bret kangkang ita ogal e minte, aniing ita alop maak no albip o,” agelip utam-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","kota unang tinum imi bogobe-nala e, “Alugum daak ifuul kon tambal diim kugol atuk ugaa ku bol ugo tona tona kelipta o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","alugum daak ton-nilip e, maak kweng 100 ke tona-bala e minte, maak kweng 50 ke tona-bala no ke-bii kolip e, ");
INSERT INTO tlf_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","kota Yesus iyo bret ogal iyo dulu som-nala e minte, aniing alop iyo dulu no ke-nala e, abiil tigiin kiit fen Aalap God iyo, “Misam o,” age-nala e, bret iyo fegela do dobela ilami okumop man iyo dulu unang tinum iyo alugum taga-em tiine-bilip e minte, aniing alop iyo togobela taga-em tiine-bom no ke-bii kupkalip e, ");
INSERT INTO tlf_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","alugum iyo kulu unan-bii tii kelip e, ");
INSERT INTO tlf_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","kota okumop man iyo alugum bret so aniing so umi tukup tukup ke-bilip uyo afetam tiinan-bii ko-nilip e, basket ulumi kup te tam tuluun kal maak abu-bii kolip kale, ");
INSERT INTO tlf_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","tinum ilimi kup faiv tausen (5,000) e minte ilimi kalelal so man so iyo kwego dego ke-nilipta, bret boyo unan-bii kupkalip ko. ");
INSERT INTO tlf_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kale kota Yesus ilami okumop man iyo bogobe-nala e, “Nugumal ibaa. Ipsiik tam bot tem uyo tam ton ok muk daang kun diim ilep yak milii abe-nilip e, abiip Betsaida unipta minte, nita unang tinum kalip iyo imdali unipta o,” agela ninggil daaginip e, ");
INSERT INTO tlf_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","kota yagal tam unang tinum iyo bogobela daaginip e, yagal yak abe amdu tigiin maak tam-nala e, God iyo aman duga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kale beten ke-bala am mililanu e, bot uyo unanbu yak ok mat iip unu e, yagal ilasinon mek kafin diim kagal bomta, ");
INSERT INTO tlf_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","tiin kwep unanbu yak daalata, dulul tebe ninggil bot kuso bimbinga imdalu unbu talbu ke-bulu e, bong kup faga bom at kom kulu ok uyo imelam unan-bilip kalaa agan-sala e, kota bem unu e, ninggil imi finang tolon o age-nala e, ok daang kun diim ilep ku-tele mo mo kem tal abe imkan ke te abe-balata bole, ");
INSERT INTO tlf_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","ninggil iyo alugum atamipta e, bot binim, ok daang kun diim ilep talan-be kalaa age atam kumang mo-nilip e, beyo begel ko age atin finan-bom atul fagamip e, Yesus iyo yuut weng kwep kwek daa bogobe-nala e, “Nugumal ibaa. Niyo nagal kale, ibo finanin ba kale, kupkaa deng tebemin o,” age-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","daage ilimi finang tam bot tem uyo tam tama e, dulul uyo binimanu ko. Kale ninggil imi aget fugunin uyo dogobeta yuut bam daata Yesus beyo dogonupmin titil uta ku-bomta kanu-be kalaa agan-nuubaalip binim kale, tam kamaki uyo ninggil iyo utamipta, Yesus iyo bret katip uyo unang tinum kwiin tagang iyo togobela unan-bii tii kelip kalaa agebip kuta, Yesus beyo dogonupmin tinum kalaa age bam daalin-tem ke-nilip e minte, aaltam kogal mungkup ninggil iyo utamipta, Yesus beyo ok daang kun diim ilep talan-be kalaa agelip kuta, beyo dogonupmin tinum kalaa agelin-tem ke no ke-nilipta, atin kumang molip ko. ");
INSERT INTO tlf_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kale kota ok muk mat iip uyo kupkaa yak abiip Genesaret umi mep so ok kan tem ko yak abe-nilip e, bot uyo kwep yak ok kan tem daa sok kup-dii ");
INSERT INTO tlf_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","kupkaa tam tamip e, abiip kasel iyo yuut utamipta e, beyo Yesus ita kalaa age-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","yuut yang abe abiip mep so so boyo tiine-bom-nilip e, unang tinum mafak ilin iyo ilet diim iinu ade degek fegep talta e, Yesus iyo abiip uyo dogap kugol alba kalaa age-nilip e, kulep tal Yesus imi finang telemip ko. ");
INSERT INTO tlf_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kale Yesus imi tiinan-be uyo, abiip bisel tono, abiip katip tono, ilanggiip am tono kem tiine-balata, unang tinum iyo ipkumal mafak ilin iyo kulep mitam abiip mat ku to-bii kupkaa Yesus imi fomtuup daga-nilip e, “Kamogim kabaa. Kabo imkalapta, igil kapmi ilim umi magaang uta kup melebelipta, telela imolap tambalanan-temip o,” agelip e, Yesus iyo, “O,” agelata, unang tinum waantap ita yak Yesus imi ilim magaang melepmip iyo tambalanamip ko. ");
INSERT INTO tlf_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Kale Falosi so Jerusalam umi ulo utamsip tinum iip maak maak so iyo tal Yesus ilami diim kal tala tala ke-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yesus imi okumop man iip maak maak iyo itamipta e, amalabal imi sagaal fomtuup diing dagamin umi kuguup uta kupka-nilip e, ilimi sagaal uyo bisop mep diing daalup ko age kupkaa iman unan-bilip kalaa age-nilip e, umik tem weng baga-emip ko. ");
INSERT INTO tlf_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Kale umik tem weng baga-e-bilip bomi magam uyo ki, Falosi so e minte alugum Juda kasel migik so iyo ilimi olal imi kuguup uta waafusip kale, (bilip imi aget fugunin uyo, olal imi kuguup boyo ilo kolup umdii, bota tebe nuyo ifak daalan-temu o age-nilipta,) kamaki uyo sagaal diing daalin-tem kelip uyo, iman uyo unan-nuubaalip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","tam no mufekmufek saanin baan diim no o tilip uyo, ok sam ugolin-tem kelip uyo, iman uyo unan-nuubaalip no ko. Kale sugamiyok olal imi kuguup migik migik kwiin tagang uta ku-nilipta, kap min, sospen min, dis min, bet min uyo diing daga-bom-nilip e minte, kuguup migik migik uyo kanu-bom no kemin kup kem-nuubip ko. ");
INSERT INTO tlf_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kale Falosi so ulo utamsip tinum so iyo Yesus imi daga-nilip e, “Kabaa. Sugamiyok uyo numi olal iyo bogo-nilip e, ‘Iman unelan o agelap uyo, sagaal uyo kanube tele diing daa-nalapta o,’ agesip kale, amalabal iyo suun kup ilimi man iyo kafalemin kup kem-nuubip kale, nuyo kanupmin kuguup uyo waafulup albu kuta, kapmi okumop man iyo, intaben o ageta numi olal imi kuguup boyo kwaasule-bom-nilipta, imi sagaal uyo tele diing daalin-tem ke-nilipta, iman uyo unan-bilip o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesus isiik bogobe-nala e, “Ibo bisop weng alop bagamin tinum kale, sugamiyok uyo God imi profet Aisaya iyo ipmi kuguup sang uyo God imi suuk kon tem uyo dola ko bogo-nala e, ‘God iyo bogo-nala, “Kanupmin unang tinum kalip iyo bisop nimi tok uta bagan-nuubip kale minte, nimi aget uyo kopne meng nimi miit tem uyo talaalup o age-nilipta, yang simanim kal nuubip kale, ");
INSERT INTO tlf_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","bilip iyo ilimi weng kem uyo unang tinum iyo kafale-bom bogobe-nilip e, ‘Koyo God imi weng kwep daasa kale, waafu-bom-nilipta o,’ agan-nuubip kuta, niyo imi bisop bogo tok bagamup ko agan-nuubip boyo tinangkulan-temaali o,” age God iyo kam agesa o,’ age Aisaya iyo dola kosa ko. ");
INSERT INTO tlf_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kale ibo God imi weng kwep daasa uyo kupka-nilipta, sugamiyok tinum fegep tam iinsip imi kuguup uta waafusip aga? ");
INSERT INTO tlf_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ipmi fomtuup olal imi weng kwep daabesip uta waafulum o age-nilip God imi weng kwep daasa uyo umik uga-em-nuubip boyo tambaliim ba kale, boyo mafak kale, bomi sang uyo bogobelan o ageta kale, tinangku-silipta. ");
INSERT INTO tlf_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Sugamiyok uyo Moses iyo God imi ulo uyo unang tinum imi kobe-nala e, ‘Man kabo kapmi kogen so kaalap so iyo tele tiin mo-nalap e minte, imi weng uyo tinangka-bom dong daga-e-bom no ke-bom-nalapta o,’ age-nala e minte, ‘Waantap ita imi ogen so aalap so iyo weng mafak baga-ema umdii, angkolip kaanamin o,’ age no kesa ko. ");
INSERT INTO tlf_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kuta ipkil ilipmi weng migik maak bogo-nilip e, ‘Kanube tinum iyo, mani albu uyo God imi kobelan o age-nala ogen sino aalap sino iyo bogobe-nala, “Nimi mani waafubi koyo God imi kobelan-temi o agebi kale, bomi win uyo, ‘Koban o,’ agan-nuubip kale, uyo asok ulaa ku-nilita, agam ibo tele tiin mo dong daga-eman-temaali o,” agela umdii, ");
INSERT INTO tlf_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","bemi ogen so aalap so imi dong dogobelin-tem kela boyo felepman-temu o,’ agan-nuubip kale, ");
INSERT INTO tlf_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","boyo ibo ilipmi olal imi kuguup uta ku-nilipta, unang tinum iyo kafalem-nuubip utamta, bota ibo God imi weng uyo kwaasulem-nuubip kale, kanupmin kuguup kwiin tagang bota ibo kanum-nuubip o,” age-nala e, Yesus iyo kam agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kale asok Yesus iyo unang tinum iyo olabela tal tamip bogobe-nala e, “Niyo weng maak bogobelan o ageta kale, tele tinangku-nilipta, utamin. ");
INSERT INTO tlf_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","God imi tiin diim uyo tinum iyo tebe-nala sagaal ninak tonin tuup min, mufekmufek, ‘Amem o,’ agesip min uyo unela daak imi mat tem unon-temu uyo, boyo tebe tele dufak daalan-temaalu kuta minte, tinum tebe-nala aget mafak fugun-bom kuguup mafak kanuman-tema uyo, bota tebe-nuluta, dufak daalan-temu ko. ");
INSERT INTO tlf_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kale ibo tolong kom ba kale, tolong tambal so kale, weng bogobeli boyo tele tolong do-nilipta, dagaa kulin o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kale Yesus iyo unang tinum iyo imkaa tam am iina tam-nilip e, kota ilami okumop man iyo daga-nilip e, “Weng do bomi magam uyo dupkop daabelapta, utamum o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","minte Yesus isiik bogobe-nala e, “Unang tinum bilip iyo bam daalin-tem kale, ipkil mungkup bam daalin-tem aga? Ibo utamsaalip bole, tinangku-silipta, bogobelan o ageta ko. Tam tinum iyo mufekmufek mitam sep ko albu umi unelan-tema uyo, daak abe-nuluta, te yak imi aget tem uyo yak unon-temaalu kale, tol kup daak mat tem kal siit-kuluta, no imaan fogolan-tema kota, daak iinom binimanan-temu kale, bota tebe bemi aget tem uyo kufak daabelan-temaalu o,” agela kale, Yesus imi weng kam agela bomi iibak tem kwek uyo ki, “Alugum mufekmufek unan-kalin uyo amem binim o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kale minte Yesus iyo bogo-nala e, “Kuguup mafak tinum imi aget tem albu umi mitam sep e tulu kanuman-tema bota tebe tinum iyo dufak daalan-tema kale, ");
INSERT INTO tlf_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","tam tinum iyo kuguup mafak uyo kanubelin-tem som, aget mafak usiik fuguno-nalata, aaltam yangta kuguup mafak uyo kanupman-tema kale, kuguup mafak kanubelan o agelan-tema uyo, kota sa dagamin min, yuguut unan-kalin min, ipkum angkola kaanamin min, sa daga-bom ipkum dupkeng dagamin min, ");
INSERT INTO tlf_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ipkum imi mufekmufek tinginemin min, kuguup mafak mafak kanumin min, bisop bagamin min, fitom binim ke-bom fengmin min, titinin min, weng mafak kupka-emin min, kutaang tebe-bom, ‘Nita kup o,’ agan-kalin min, ilum ilum ke-bom fuut tebemin min uta kanuman-tema kale, ");
INSERT INTO tlf_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","alugum kuguup mafak bomi miit uyo tinum imi aget tem kwek uta kale, kugol bii-nuluta, mitam sep abelu fenga kolata, bota tebe tinum iyo fen dufak daalan-temu o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kale Yesus ninggil iyo Juda kasel imi kafin uyo kupkaa daage asit kek kek imi kafin unip kale, asit kek kek bilip imi abiip miton alop umi win uyo Taya e minte Saidon no kale, Yesus imi aget fugunin uyo, tinum iyo maak nitamin-tem kela bantap no kun fungolan o age-nalata, no am maak kutam kal siit ilugola kuta, dogobeta waan-nama binim kale, ");
INSERT INTO tlf_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","kota unang maak weng tolong doluta, “Yesus iyo tala o,” agelip kalaa agelu kale, unang boyo man unang katip so kale, man boyo sinik mafak tebe kufak daasa kale, unang boyo Juda kayaak unang ba kale, Fonisia kayaak unang kuta, saak Yesus imi finang tal-nulu e, kamok imi weng umka-emin kuguup uyo kanumin kale, boyo tal Yesus imi miit tem kugol daak katuun duung fegela suk mo kalaak fen fomtuup bogobe-nulu e, “Nimi man unang uyo sinik mafak tebe kufak daasa kale, beyo fot tebepmap yak iinata, man boyo tambalanuk o,” agelu ko. ");
INSERT INTO tlf_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kale (Juda kasel iyo asit kek kek unang tinum imi win uyo bogobe-nilip e, “Kayaam o,” agan-bom-nilip e minte, ilimi unang tinum ita minte, “Fen tinum imi man o,” agan-bom no kem-nuubip kale, Yesus imi aget fugunin uyo, unang bomi aget fugunin uyo kup-kugulita, Yesus beyo tii kanube-nama o agan-bo bele, beyo kanubelan-temaala o agan-bo kalaa age utaman o age-nalata,) do weng maak bogobe-nala e, “Man kangkang imi iman uyo dugu kulep no kayaam imi kobelan-temip boyo felepman-temaalu kale, kamaki uyo man kangkang isiik ifemin (kale, kupmi dong dogopkelan-temi boyo felepnelan-temaalu) o,” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","unang bosiik bogobe-nulu e, “Kamogim kapmi weng boyo dam bagan-balap kuta, man imi iman unan-bilip buul segela daak tebol umi afak tem abelan-temu uyo, kayaam tebol afak tem kulaak albip iyo tebe unan-nuubip kale, ulutap mungkup kabo dong dogopnelan-temap boyo felep-kaman-temu o,” agelu e, ");
INSERT INTO tlf_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesus isiik bogobe-nala e, “Weng boyo tambaliim bogolap kale, kota sinik mafak iyo fot tebeli kupmi man uyo kupkaa yak iina kale, nugum kubo kupkaa kulupmi am iinaal o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","daage tam ulumi am tamta e, sinik mafak iyo man uyo kupkaa yak iina e, kota abiin tambal agaal unbu kalaa age-nulu e, tam utamu ko. ");
INSERT INTO tlf_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kale kota Yesus iyo asok abiip Taya uyo kupka-nala e, daage no abiip Saidon tono, daage yang Distrik Dekapolis umi iip ku-tele ilo ko daage tal Galili Ok Muk tal tama e, ");
INSERT INTO tlf_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","tam tinum maak tolong komanebelu e minte, weng uyo mafaganebe no kebesu iyo ilami duup iyo tebe duptamo tal-nilip e, Yesus imi bogobelip, “Tinum keyo kapta sagaal togobe telela dolal o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesus iyo unang tinum iyo imkaa duptamo yang asit tem kweng kal alop ilisinon bom-nilip e, tam Yesus iyo sagaal diil iyo kulep yak tinum bemi tolong tem alop uyo ilipma top un un kelu e minte, duban tagaa kwaala daak sagaal duung diim abelu e, kwep tam tinum bemi fong diim daabe no ke-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","God iyo aman duga-e-bom abiil tigiin kiit fen-siit-nala e, du-filin daa nat age bogobe-nala e, “Efata o,” agela bomi magam uyo, “Tolong tem kubo tambalanepmal o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","tinum bemi tolong tem so e minte bon tem so uyo tambalanebelu weng uyo tambaliim baga-bom-nala e minte, ipkumal imi weng uyo tinangka-bom no kema ko. ");
INSERT INTO tlf_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kale Yesus iyo unang tinum iip maak maak bom-silip kanubela utamip bilip imi bogobe-nala e, “Ibo yang ipkumal iyo nimi ko kanubeli utamip bomi sang uyo baga-emin ba o,” age fomtuup weng kobela kuta, yang abe ipkumal iyo suun kup baga-em yakyak tiinemip ko. ");
INSERT INTO tlf_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kale unang tinum bilip iyo atin kumang muuna tala ke-bom bogo-nilip e, “Keta mufekmufek ko kanu-be uyo alugum tambaliim ke-bom-nala e, tolong kom iyo telela imola weng tinangka-bom-nilip e minte, weng kabam iyo telela imola weng tambal baga-bom no kem-nuubip o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kale kanumsa kota, unang tinum kwiin tagang iyo, asok Yesus imi weng uyo tinangkamum o age-nilipta, tala tala kelip e, imi iman uyo binim kebelu kalaa age-nalata, Yesus ilami okumop man iyo olabela tal tamip bogobe-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Unang tinum kalip imi nisino bii am asuno kelip koyo, imi iman uyo binimanepmu bisop albip kalaa ageta niyo i-filin-bii kuta, ");
INSERT INTO tlf_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","iip maak kalip iyo simanim ilo talbip kale, kanube iman tep imdali ilimi abiip iinon-temip bole, abe-bom-nilip e, iman tep iip kal du molan-temip o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","minte okumop man isiik Yesus imi bogobe-nilip e, “Tinum binim iip koyo bret uyo dogap-tele kulu-nulupta, ifelup une tii kelan-temaalip o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","minte isiik ninggil imi daga-nala e, “Ipmi bret uyo intap kal albu o?” agela e, bogo-nilip e, “Ban kal o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","kota Yesus iyo unang tinum iyo bogobela daak kafin diim tonip e, bret ban kal uyo kulu God iyo, “Misam o,” age-nala e, bret uyo fegela ko-nala e, ilami okumop man imi kobela ita kulep unang tinum iyo taga-em tiine-bilip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ninggil iyo aniing kangkang iip maak maak iyo albip kale mungkup, Yesus iyo kulu God iyo, “Misam o,” age ilami okumop man iyo bogobe-nala e, “Aniing kaso taga-e-bom no kemin o,” agela e, taga-em tiinemip ko. ");
INSERT INTO tlf_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kale unang tinum iyo kulu unan-bii tii kelip e bole, okumop man iyo tebe iman un-bom-nilip tukup tukup ke-bilip uyo afeta-bii ko-nilip e, basket ulumi kup ban kal koyo abulip dongenu ko. ");
INSERT INTO tlf_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kale unang tinum bret so aniing so unelip bilip iyo foa tausen (4,000) umaak kalip ita unelip binimanu e bole, Yesus iyo tebe imdala daaginip e, ");
INSERT INTO tlf_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","kota ilami okumop man sino ninggil te tam bot tem ton-nilip e, yak Distrik Dalmanuta umi milii kutam iinip ko. ");
INSERT INTO tlf_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kale Falosi iip maak maak iyo tal Yesus so wengaal digin-bom dup-kugu-bom bogobe-nilip e, “Kabaa. Kabo mirakel ko age kuguup ugulumi migik umaak kafalebelapta, nuyo utamupta e, kabo God yagal kamdala ti-salap kalaa agelum o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","imi aget tem uyo iluum tebepmu bogobe-nala e, “Ibo bogopne-nilip, ‘Mirakel ko age kuguup ugulumi migik umaak kanubelapta, utamum o,’ age dagagamin ba ko. Kale niyo ibo weng uyo dam bogobelan o ageta kale, kanupmin aget fugun-bilip tinum ibo niyo mirakel ko age kuguup ugulumi migik fen-bilip bomaak kanubeli utaman-temaalip o,” age-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","kota Yesus iyo asok unang tinum iyo kugol imkala e, ilami okumop man iso ninggil tam bot tem ton-nilip e, daage yak ok muk milii kutam iinip ko. ");
INSERT INTO tlf_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kale Yesus imi okumop man ninggil iyo bret uyo ilumano kutu-nilip e, bret maagup uta kup bot tem ilep kwep tilip kale, ");
INSERT INTO tlf_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesus iyo weng kem uyo felep yak ku to do weng maak bogobe-nala e, “Nugumal ibaa. Ibo Falosi so Herot so imi yiis ko age tukolip bret fitimin umi mufekmufek uyo tele utama-bom kupkek kupkek kem tiine-bom-nilipta o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ninggil iyo Yesus imi do weng bogola bomi magam uyo utamin-tem ke-nilip e bole, ninggil igil tegen-bom-nilip e, bogolip, “Nuyo bret binim kalaa age-nalata, yiis bomi sang uyo bagan-be bele o?” agan-kalip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesus iyo boyo utam-nala e, ninggil bogobe-nala e, “Intaben o age-nilipta, ibo bogo-nilip, ‘Nuyo bret binim utamta, kam agan-be o,’ agan-bilip a? Ipmi aget tem uyo ilum ilum bii kopmuta, ibo utamipta e, yiis umi sang ugo ba kale, mufekmufek migik umi sang uta bagan-be kalaa ageta utam dagaa kulin-tem albip aga? ");
INSERT INTO tlf_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Ibo tiin so e minte tolong so kuta, utama-bom e minte, tolong do no ke bam daalin-tem aga? Siin uyo bret ogal fegela kobeli ipkil kulu tinum ilimi kup faiv tausen (5,000) kalip imi ifelip un-bom tukup tukup kemsip uyo, ibo basket uyo intap kal abu-silip a? Ibo ilumanobip aga o?” agela e, isiik bogobe-nilip e, “Tuluun kal abu-sulup o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","asok maak so ninggil imi daga-nala e, “Asok aaltam komi bret ban kal fegela kobeli ipkil kulu unang tinum ilimi kup foa tausen (4,000) kalip imi ifelip un-bom tukup tukup kemsip uyo, ibo basket uyo intap kal abu-silip o?” agela e, bogobe-nilip e, “Ban kal abu-sulup o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yesus isiik bogobe-nala e, “Ibo kanubeli utam-silip boyo, intaben o age-nilipta, nimi titil boyo tele utamin-tem ke-silipta, aget yamyam uyo fugun-bilip o?” agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kale Yesus ninggil iyo daage no abiip Betsaida ko no tamip e, abiip kasel iyo tinum maak tiin bigibesu iyo dep tal Yesus imi bogobe-nilip e, “Tinum keyo kapmi sagaal umaak togobelapta, imi tiin uyo tambalanepmuk o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesus iyo tinum tiin bigibesu iyo abiip uyo kupkaa sagaal kegal aafuu duptamo yang tiginal kweng iinom-nala e, tiin tem uyo mok togobe sagaal togobe-som-nala e, daga-nala e, “Kabo kek fen mufekmufek umaak utamap bele ki?” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","tiin baa-nala e, bogola ko. “Niyo mufekmufek umaak tele utamanbaali kale, tinum iip maak maak iyo itaman-bii kuta, bilip iyo at ko agan-bilita, tiine-bilipta, kota tinum umdii ko tiinan-bilip kalaa agan-bii o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","asok Yesus ilami sagaal alop kano kulep yak tiin diim uyo togobela e, kota tiin daga-bom-nala e, fomtuup utamata e, nimi tiin uyo asok tambalanepnelu kalaa age-nala e bole, alugum mufekmufek uyo tambaliim kup utama kalaa age-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesus iyo tebe tinum beyo daala ilami am iinak o agan-som-nala e, bogola ko. “Kabo yang abiip uyo, ‘Niyo tambalani o,’ age alugum iyo kafalebelap katamamin ba o,” agela e, am iina ko. ");
INSERT INTO tlf_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Kale Yesus so e minte ilami okumop man so iyo daage no Sisaria Filipai umi mep so umi abiip maak maak uyo yakyak kem abe-bom-nala e, ilami okumop man imi daga-nala e, “Unang tinum bilip iyo, ‘Beyo waanta o’ nagan-bilip o?” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","isiik bogobe-nilip e, “‘Beyo ok sam uga-emin tinum Jon Baptis o,’ kagan-bala, minte iip maak iyo bogo-nilip e, ‘Beyo God imi profet ko age weng kem baga-emin tinum sugayok bii-se Elaija ita o,’ kagan-bala, minte iip maak ita bogo-nilip e, ‘Beyo God imi profet migik maak sugayok bii-se ita o,’ kagan-bala no kem-nak-bilip o,” agelip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ninggil imi daga-nala e, “Minte ipde a? Ibo bogo-nilip, ‘Beyo waanta o,’ nagan-bilip o?” agela e, tam Fita ita Yesus imi weng uyo yan kebe-nala e, “Kabo God imi ulaa kamdula kamok kesap tinum kapta (kale, God yagal kamdala ti-salap) o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ninggil imi fomtuup bogobe-nala e, “Ibo tinum maagup iyo maak bogobe-nilip, ‘Yesus beyo God imi ulaa dula kamok kesa tinum iyo kulba o,’ age nimkem dagamin ba o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kale kota weng uyo kufo kafale-bom bogo-nala e, “Son-temu uyo, Mo Tibil imi Man niyo kuguup mafak mafak kupkane-bilip bii, umtal daalita bole, Juda kasel imi kamogimal so tinum amem ko age pris imi kamogimal so ulo utamsip tinum so ita umik ugopne nitafinon-bom-nilipta, nimdalip yak waasi imi sagaal diim abelita, ita nangkolip kaani namalip bii, am alop ke-nilita, am asuno diim kota asok fenan-temi o,” age ");
INSERT INTO tlf_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesus iyo kem bogola e, kota Fita iyo Yesus ilasinon dep yang kweng kal ilami kaanan-tema umi sang bogobela umi kalan uta yege-bom baga-emata, ");
INSERT INTO tlf_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","yagal fupkela katam fen ilami okumop man iyo itama-bom-nala e, tam Fita iyo an-togon-bom-nala e, bogola ko. “Kabo God imi aget fugun-be ulutap uta fugunbaalap binim kale minte, kafin diim komi tinum imi aget fugun-bilip ulutap uta fugun-balap kale, kabo nimi waasi Saatan imi kuguup ulutap uta kupkane-balap kale, kupkalal o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kale kota ilami okumop man so unang tinum ibolip so iyo olapma tal tamip e, bogobe-nala e, “Tinum dogap kapta niso no nimi ogok uta keneman o agelap umdii, yak kalapmi aget fugunin uta kup kanumin boyo kupka-nalapta, nimi ilak uta fom duga-bom-nalap e, nimi at diim kaal fuyap kulan-temi kulutap ke, ‘Kaan-nimi bole, kanube kaan-nimi o,’ agan-bom-nalapta, kanupmin kuguup uta ku-nalapta, te tamta nimi ogok uyo waafuu kwep tebe-balapta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kale tinum iyo dogap ita ilami kaal ilak kup suun duga-bom, ilami aget fugunin uta kup kanum tiineman o agan-kala umdii, beta kaan-nalata, maagalo kelan-tema kale minte, tinum iyo dogap ita, ‘Meng kanu-bili waasi iyo tebe nangko-nimip kuta, nangko-nimip o,’ age-nala meng nimi ilak kup duga-bom nimi weng tambal uta fomtuup waafuu kwep taba umdii, beta suun kup nan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Minte tinum iyo maak kafin kaa kutufosu komi mufekmufek uta alugum kwaa-bom-nala e minte, suun kup nin umi ilep umaak temin binim ke-bom no kema umdii, ilami mufekmufek kwiin tagang ko kwan-be bota tebe dong dogopman-temu bele ki? Umbae. Boyo tebe dong dogopman-temaalu kuba. ");
INSERT INTO tlf_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Iyo mufekmufek tambal kup tebesu umaak God imi kopmata, God iyo bogobe-nala, ‘Kabo suun kup nan-temap o,’ agelan-tema bele ki? Umbae. Suun kup nin boyo tisol umi ku mo kugamin umi mufekmufek ba kuba. ");
INSERT INTO tlf_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Unang tinum kwiin tagang iyo kuguup mafak uta waafuna-bom-nilipta, God iyo umik ugobe dupkaa yang iinan-nuubip kale, dogap ita kulip imi diim uyo nimi win uyo kufunemin binim e minte, kulip imi atul finano nimi weng uyo baga-emin binim ke no kema umdii, son-temu nala Mo Tibil imi Man niyo nalami Aatum imi titil uyo ku kamok kesa ilatap keli ensel tambal iso ninggil tolon-temup uyo, nisiik tinum bemi win uyo kufobelan-temaali kale, ‘Beyo nimi duup ba o,’ agelan-temi kale, ");
INSERT INTO tlf_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","weng koyo tuluun bogobelan-temi kale, tinangku-silipta. Iip maak maak ibo kaanin-tem som-nilipta, utamipta e, God iyo ilami titil uta ku-nalata, unang tinum kwiin tagang iyo imdep tam ilami daam tem daa tiin mola mitam senganu kalaa age utaman-temip o”, age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kale am bugup kal koyo te top iinu e, kota Yesus iyo tebe-nala e, Fita so Jems so Jon so ita kup fola kulep yak abe tam amdu tigiin timitim maak tam kugol ninggil ilisinon bom-nilip e bole, tinum asuno bilip iyo Yesus iyo atamipta e, mitam yagalami migik kela e, ");
INSERT INTO tlf_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","imi ilim uyo atin namalan tiin bulusii so ke no kelu kalaa age atamip kale, kafin diim unang kalip iyo dogobeta ilim umaak kanube diing daalipta, boyo kanube namalan tiin bulusii so ke-numu binim ko. ");
INSERT INTO tlf_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kale ninggil iyo utamipta, tinum alop maak sugamiyok bii-silip Elaija so Moses so iyo asok abiil tigiin uyo kupkaa malaak tamip Yesus so ninggil weng bagan-bilip kalaa age-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Fita ninggil iyo finan-siita umtal daa-nilip e, Fita ita aget fuguno-nala e, “Kota intaben weng umaak bogolan-temi o,” agan tolom-nala e, kota Yesus imi bogobe-nala e, “Numi kafalemin kabaa. Suguul ke kapsino tal kagal albup kale, ninggil nuyo am mafak asuno umaak, maak bo kapmi, maak bo Moses imi, minte maak bota Elaija imi no ke deebelupta, o,” agan-kala e bole, ");
INSERT INTO tlf_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","iip namaal maak malaak abuta, Yesus ninggil iyo de imalu e, iip tem kutam-tele weng maak bogo-nala e, “Ibaa. Beyo nimi man bubul kale, ibo bemi weng uyo tinangka-bom-nilipta o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","kumang mo maak fagaa kek fenipta e, tinum migik iyo maagalo kelip e, Yesus ita kup alba kalaa age atamip ko. ");
INSERT INTO tlf_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kale kota Yesus ninggil iyo amdu tigiin uyo kupkaa tal-bom-nilip e, Yesus iyo ilami okumop man ninggil asuno iyo weng uyo fomtuup bogobe-nala e, “Nugumal ibaa. Tinangku-silipta. Ibo no unang tinum kek kek imi diim uyo ko kanubelu utamip bomi sang uyo bagamin ba kale, kupkaa bom-bilip bii, Mo Tibil imi Man niyo kaani nimdep no namalip son nala asok fen tigi moli kalaa age-nilipta, kota unang tinum kek kek iyo baga-eman-temip bota felepman-temu o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ninggil iyo kanubelu utamip bomi sang uyo bogo-nimip binim fulma-bom-nilip e ki, Yesus imi weng, “Kaani namalip son nala asok fen tigi molan-temi o,” agela bomi magam uta fen-bomta utamum o age-nilipta, fenip ko. ");
INSERT INTO tlf_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kale ninggil asuno iyo weng migik maak Yesus imi daga-nilip e, “Ulo utamsip kasel iyo intaben o ageta bogo-nilip kano, ‘God imi profet ko age weng kem baga-emin tinum Elaija sugayok bii kaansa isiik talata minte, God imi ulaa dula kamok kesa tinum ita aaltam tolon-tema o,’ agan-nuubip o?” agelip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Yesus isiik bogobe-nala e, “Bilip imi weng ko bogo-nilip, ‘God imi ulaa dula kamok kesa tinum iyo tilin-tem bom-salata, Elaija isiik tal, unang tinum iyo dong dogobelita, imi aget tem uyo telelam-silipta o age-nalata, tolon-tema o,’ agan-nuubip boyo dam bagan-nuubip kale, ibo tinangku-silipta, bomi magam uyo tele bogobelan. Elaija iyo ti-se kuta, tinum ilimi aget uta kup fuguno-nilipta, beyo angkolip kaan-se kale, sugamiyok God imi suuk kon tem dola kosip uyo ko tol mitam ti-suu ko. Kuta God imi ulaa nimdula kamok kesi tinum nimi sang uyo, sugamiyok uyo weng maak uyo dola ko-nilip e, ‘Mo Tibil imi Man iyo kuguup mafak mafak uyo kobelip kaal fuyap ogen abin so uyo utama duban baan ke-eman-temip o,’ nage-nilipta, dola kosip kale, intaben o ageta ibo bomi aget kuso uyo fugunbaalip o?” age Yesus iyo Jon Baptis imi sang uta baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kale Yesus ninggil iyo daage malaak okumop man milii imkaa unbip imi diim malaakta e, unang tinum kwiin tagang iyo ninggil imi diim kutam kal tala tala ke-bii kolip e, ulo utamsip tinum iip maak maak ita okumop man milii isino wengaal digin-bilip kalaa age malaak tamip e bole, ");
INSERT INTO tlf_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","unang tinum bilip iyo atamipta e, Ei. Yesus iyo kaa tala kalaa age kumang mo-nilip e, yuut no weng umka-emip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","isiik ilami okumop man iyo daga-nala e, “Ibo intaben kalan iso wengaal digin-bilip o?” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","18","unang tinum bilip imi tinum maak isiik bogobe-nala e, “God imi weng kafalemin kabaa. Nimi man tinum iyo sinik mafak maak tebe del kola dosa kale, asok dogap kota sinik mafak beyo tal nimi man bemi de dola uyo, aafuu daala daak abe-nala e, mok uyo fildek-bom-nala e minte, sit kun uyo dolot dolot ke-bom-nala e minte, imi dam uyo alugum biing mo no kem-nuuba kalaa age-nilita, dep tal olita, kabo binim kalaa age-nilita, kapmi okumop man ita bogobe-nilita, ‘Ibo sinik mafak beyo fot tebelip yak iinak o,’ agan-bii kuta, fen bagang-kale fot tebelip yak iinoma binim kelip o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Kale Yesus isiik ilami okumop man sino unang tinum albip iso imi bogobe-nala e, “Kwiin ee. Ipmi aget fugunin uyo fen atin tol ba kale, niyo ipso bii, kayop kwiin tagang te yang iinu kuta, ibo nitamipta e, beyo God imi titil uta ku-nalata, sinik mafak iyo fot tebela yak iinan-nuubip kalaa naganbaalip ko. Niyo ipso bii, am intap kal kelita, ibo nitamipta, beyo tii God imi titil boyo nugol mungkup kobe-nama kalaa nagelan-temip a? Niyo ipmi aget mafak fugun-bilip boyo daal tebepnebu kale, man tinum iyo dep tilin o,” agela e bole, ");
INSERT INTO tlf_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","dep tal tamip e, sinik mafak iyo Yesus iyo atam-nala e bole, maak fagaa man iyo daala unba talba biita kumen daak kafin diim abe kugiit kugulaak ke-bom-nala e, mok kup fildegama ko. ");
INSERT INTO tlf_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Kale Yesus iyo man bemi aalap iyo daga-nala e, “Man keyo kanu-bii, kayop uyo intap kal undula o?” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","isiik bogobe-nala e, “Sugamiyok man katip kegal kanum tebesa kale, suun kup sinik mafak beyo tebe man beyo dufak daalan o agan-bom-nalata, ang kulala te at tiil iine-bom-nala e minte, ok tem iine-bom no kem-nuuba kale, kanube kabo tii dong dogobe-namap umdii, nuyo i-filin daa-nalap dong dogobe o,” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesus isiik bogobe-nala e, “Kwiin ee. Kapmi bogopne-nalap, ‘Kabo tii dong dogobe-namap aga o?’ nagelap uyo? Tinum waantap ita aget fugunolata e, God iyo tii koyo kanube-nama kalaa agan-kala umdii, yak mufekmufek alugum dagala boyo God iyo tii kanube-nama o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","kota man bemi aalap iyo ol-bom-nala e, “Niyo, God iyo koyo kanubelan-tema kalaa agan-bii kuta, katip uta kup fugun-bii kale, dong dogopnelapta, senganuk o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesus iyo utamata e, unang tinum iyo tinum bemi olan-be boyo tinangku-nilip e, yuut tala tala ke-bilip kalaa age-nala e, kota sinik mafak beyo an-togon-bom-nala e, bogola ko. “Sinik mafak kabo tebe-nalap man keyo del kola do-nalap e minte, kul baang tolong fo do no kesap kale, niyo alaang weng umaak kopkelan o ageta kale, tinangku-salapta. Man keyo dupkaa yak iinaal o ageta kale, asok maak so te yak imi tilin tem uyo unemin ba o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","kota sinik mafak iyo ol-bom-nala e, man iyo fomtuup daala unba talba kem tolom-nala e, dupkaa mitam iina e, man iyo kaanba ilatap kela e, unang tinum kwiin tagang iyo bogo-nilip e, “Daak man beyo kaana o,” agan-kalip e, ");
INSERT INTO tlf_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yesus iyo daak sagaal kegal aafuu dufola fen mola ko. ");
INSERT INTO tlf_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kale siit-nilip e, Yesus so ilami okumop man so ilisinon tam am tam-nilip e, Yesus iyo daga-nilip e, “Dogobeta nuyo bagang-kale sinik mafak beyo fot tebelup yak iinin-tem kela o?” agelip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesus isiik bogobe-nala e, “Yak mufekmufek migik uyo kanube-nilip God imi aman dobelin-tem kelip uyo, kanupmin sinik beyo dogobeta fot tebelip yak iinon-temaala o,” agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Kale Yesus ninggil iyo kafin boyo kupka-nilip e, daage unanbu yang Provins Galili umi iip ku-tele yang abe-nilip e, Yesus iyo, unang tinum iyo tinangku-nilip nitamum o age tala tala kemin binim ninggil nulusinon bom-nulupta, nalami okumop man iyo kafaleman o age-nalata, bantap tiine-bom-nala e, ilami okumop man iyo kafale-bom bogobe-nala e, “Ibaa. Mep sino kelu kale, tinum maak tebe-nilip Mo Tibil imi Man niyo nimdalip yak waasi imi sagaal diim abelita, ita tebe nangkolip kaanita, nimdep no namalip bii, am alop ke-nilita, am asuno diim kota asok fen tigi molan-temi o,” age kafale-bom baga-ema kuta, ");
INSERT INTO tlf_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ninggil iyo imi weng baga-e-be bomi magam uyo tele utamin-tem kelip kuta, finan-bom-nilipta, bomi magam uyo maak daga-nimip binim kelip ko. ");
INSERT INTO tlf_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kale Yesus ninggil iyo dagaa dep daage top Kapeneam no abe-nilip e, tam am kal ton-bom-nilip e, ninggil imi daga-nala e, “Ibo ilep tilip uyo, intaben sang uta bogola bogola kem tilip utami o?” agan-be kuta, ");
INSERT INTO tlf_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","igil utamipta, numi ilep tulup uyo, “Ninggil nugol waantap ita nulumi kamok kelan-tema o?” agela agela ke-bom wengaal digin tulup kalaa age-nilipta, ninggil iyo fitom tebepmuta, weng sining agelip ko. ");
INSERT INTO tlf_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kale Yesus iyo daak ton-nala e, kota okumop man tuluun kal iyo bogobela tal tamip bogobe-nala e, “Kanube tinum iyo, nita God imi tiin diim uyo kamok kelan o agela umdii, beyo ilami aget fugunin uyo kupka-nalata, alugum unang tinum imi dong daga-emin tinum ke-nala e minte, imi bon tem kiit fenin tinum ke no ke-nalata o,” age-nala e bole, ");
INSERT INTO tlf_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","man katip maak ugaa du-nala e, dep tal ninggil imi iibak tem kulagal dep daa dep mek duptal migi-nala e, ninggil imi bogobe-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Tinum dok ita man kalatap iyo maak atamata, Yesus imi tiin diim uyo man kanupmin keyo win so kalaa age-nala dong dogobela umdii, boyo nimi dong daganemin kuguup uyo kulbu ko. Minte God yagal nimdala ti-sii kale, waantap ita nimi dong dogopnela umdii, boyo nimi dong daganemin kuguup uta kup ba kale, boyo fen God imi dong daga-emin kuguup uyo kulbu no o,” age Yesus iyo kam agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Kale Jon ita Yesus imi bogobe-nala e, “Numi kafalemin kabaa. Ninggil nuyo tinum maak atamupta, beyo kapmi win uta kufo-nalata, sinik mafak iyo fot tebela yak iinan-bilip kalaa age atamupta, beyo kapmi okumop man kelin-tem bom-nalata, boyo kanu-be kalaa age-nulupta, bogobe-nulup e, ‘Kapmi bisop Yesus imi win kufu-e-bom kanu-balap boyo kupkalal o,’ age fegelebebup o,” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesus isiik bogobe-nala e, “Kanube tinum iyo maak nimi win uta kufo-nala kuguup atin tambal umaak telela kola umdii, beyo siit-nala dogobeta weng mafak uyo kopnelan-temaala kale, ibo imi kanu-be boyo fegelemin ba ko. ");
INSERT INTO tlf_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kale waantap ita nuyo waasi kebelin-tem kela umdii, beyo numi duup kale, ibo beyo fegelemin ba ko. ");
INSERT INTO tlf_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Minte tinum dok ita itamata, ibo Krais imi tinum kalaa age-nala dong dogobelan o age ok uyo ilupma unelip umdii, God yagal tinum bemi kuguup ko kanubela boyo utam bogobe-nala, ‘Kapkum ok ilubelap bomi kuguup boyo katip kuta, boyo tambaliim kanubelap kale, niyo deng taban-bii o,’ age-nala e, yagal kuguup tambal boyo fen yan kebelan-tema o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Kale Yesus iyo asok bogobe-nala e, “Kek kek iyo utamipta, tinum beyo tebe, God imi ilak dolin unang tinum iyo ifak daalan o angba kalaa agelan-temip uyo, kanube bilip iyo tebe tuum afalik maak ku sok de ko-nilip kwep yak tinum bemi fuk kun diim kwegal de kobe daalip daak yol ok kumun tem iina umdii, tinum beyo kaal fuyap uyo katip so ku-nalata, kaanan-tema kale minte, kanube kek kek iyo tebe tinum beyo kanubelin-tem ke dupkalip tebe unang tinum God imi ilak dugamin katip katip ke-bilip iyo ifak daala kupkaa yang kuguup mafak uyo kemip umdii, God isiik tebe atin ki bemi ifak daala bomi yan uyo kobelata, tinum beyo kaal fuyap kwiin kiim uyo kugan kwep tabon-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Minte kanube utamapta, nalami sagaal uyo tebe nimtamo yang daalu kuguup mafak uyo keman o angbi kalaa agelap umdii, kalapmi sagaal milii boyo ugaa kwaalap unu sagaal milii tumon ke-nalap kuguup mafak uyo kupkaa bii kaan-nalap tam God imi abiip kal suun nan-temap bota atin tambaliim kale minte, kabo, sagaal milii uyo ugaa kupkan kelaali o age kuguup mafak kup ke-bii kaanap kalaa age-nilip God imi ensel iyo tebe kamdalip no at suun kenamin abiip unon-temap boyo tambaliim ba kale, ");
INSERT INTO tlf_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","abiip boyo at uyo tenkamin binim e minte, kaal diim ilop uyo binimamin binim no umi abiip uta ko. ");
INSERT INTO tlf_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Aa minte kanube utamapta, nalami yaan uyo tebe nimtamo yang daalu kuguup mafak uyo keman o angbi kalaa agelap umdii, kalapmi yaan milii boyo ugaa kwaalap unu yaan milii tumon ke-nalap kuguup mafak uyo kupkaa bii kaan-nalap tam God imi abiip kal suun nan-temap bota atin tambaliim kale minte, kabo, yaan milii uyo ugaa kupkan kelaali o age kuguup mafak kup ke-bii kaanap kalaa age-nilip God imi ensel iyo tebe kamdalip no at kenamin abiip unon-temap boyo tambaliim ba kale, ");
INSERT INTO tlf_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","abiip boyo at uyo tenkamin binim e minte, kaal diim ilop uyo binimamin binim no umi abiip uta ko. ");
INSERT INTO tlf_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ulutap kale, mungkup utamapta, nalami tiin uyo tebe kuguup mafak uyo kafalne-bulu keman o angbi kalaa agelap umdii, kalapmi tiin milii boyo dagaa kwaalap unu tiin milii tumon ke-nalap kuguup mafak uyo kupkaa bii kaan-nalap tam God imi abiip kal nan-temap bota atin tambaliim kale minte, kabo, tiin milii uyo dagaa kupkan kelaali o age kuguup mafak kup ke-bii kaanap kalaa age-nilip God imi ensel iyo tebe kamdalip no abiip mafak unon-temap boyo tambaliim ba kale, ");
INSERT INTO tlf_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","abiip boyo at uyo tenkamin binim e minte, kaal diim ilop uyo binimamin binim no umi abiip uta ko. ");
INSERT INTO tlf_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Kale ibo nimi weng ko kupka-e-bii boyo tinangkulipta, titil weng kalaa age ibo finan-bilip kuta, fen weng boyo tuluun kale, alugum waantap ita nimi ilak uyo dolip umdii, God imi aget fugunin uyo, kanu-e-bilita, tambaliim nalami weng uta kup tinangka-bom-nilipta, te tam titil fagalin o age-nalata, ogen aalap imi man ilum ilum ke-bilip saal daga-bom min, ke-bom kafalebip ulutap kem-nuuba ko. ");
INSERT INTO tlf_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Kale yol boyo tambaliim kale, tubulap uyo, iman uyo abalim tebelan-temu kuta, kanube yol uyo abaal tebelin binim kelu uyo, kabo dogobeta telela kolapta, bomi abaal uyo tabon-temu a? Boyo atin binim ko. Kale ibo yol ulutap kale, kanube ibo wengaal digin-bom, ‘Ninggil nugol waantap ita nulumi kamok kelan-tema o?’ agela agela ke-bom wengaal digin-kalip umdii, bota tebe ipmi ipkumal dong daga-emin kuguup tambal boyo kwaalu daak abe binimanan-temu kale, boyo kanube wengaal digin-kalin ba kale, ilipmi ipkumal iyo bet bubul kup kupka-e-bom-nilipta o,” age-nala e, Yesus ita ilami okumop man iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kale Yesus iyo kafin boyo kupka-nala e, Ok Jodan uyo ilo do yak milii abe-nala e, daage no Provins Yuudiya umi atuk ko no tama e, kota unang tinum kwiin tagang iyo asok Yesus imi finang tala tala kelip e, ilami kanube unang tinum suun kafale-boma ulutap mungkup kafale-bala nip ko. ");
INSERT INTO tlf_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kale Falosi iip maak maak iyo nota, Yesus iyo bisop bogo dup-kugu-bulupta, weng mafak umaak bogola kalaa age-nulupta, dep no weng telelmin baan diim daalum o age-nilipta, tal daga-nilip e, “Kabaa. Moses imi ulo numi kobesa uyo, intaben o agesu a? Uyo bogo-nulu, ‘Tinum iyo ilami kalel uyo, kupkalan o agela uyo, fot tebelan-tema boyo tambaliim o,’ agesu bele o?” agelip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesus isiik bogobe-nala e, “Moses iyo dok umi ulo uta ipmi kobesa o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","aa minte isiik bogolip ko. “Moses iyo tinum iyo dupkalata, yagal kalel kup-kagamin umi suuk kon uyo dola kota imi kalel uyo kobe-nala e, kota fot tebemin o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesus iyo bogobe-nala e, “God tebe tinum dula unang kula kemin umi ulo kwep daasa uyo ipmi olal so ipso ibo, tinangkulaalup o agan-bilip kalaa age-nalata, Moses iyo kanube ipmi ulo boyo dola kobesa kuta, ");
INSERT INTO tlf_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","kamaki God imi mufekmufek alugum telela kosa uyo, tinum so unang so telela imola agam maagup kesip kale, ");
INSERT INTO tlf_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","God imi suuk kon tem uyo bomi sang uyo bogo-nulu e, ‘Agam maagup kesip bota, tinum iyo tebe unang uyo kulan-tema uyo, tinum iyo ilami ogen so aalap so iyo imka-nala e, yak kalel umi diim kal du mola e bole, ");
INSERT INTO tlf_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","agam iyo maagup kelan-temip o,’ agesu kale, asok maak so alop kelan-temaalip kale, agam bilip iyo maagup kelan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kale God imi unang tinum kwep tala tala kela agam maagup kebip uyo, unang tinum iyo maak tebe-nalata, agam imi dula kula kebip uyo ilo kobela yang iina meng iina kemin ba o,” age Yesus iyo kam agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kale Yesus ninggil iyo asok tam am tam-nilip e, ilami okumop man iyo tebe weng bomi sang uyo dagalip e, ");
INSERT INTO tlf_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesus isiik bogobe-nala e, “Kanube tinum iyo maak ilami kalel uyo kupka-nala yang unang migik kula umdii, God imi tiin diim uyo bemi kanubela boyo sa daga-bom-nalata, ilami fen kalel yom uyo kupkeng daga-bom kufak dagan-be kalaa agelan-tema e minte, ");
INSERT INTO tlf_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","unang ugol mungkup ulumi imak iyo dupka-nulu yang tinum migik ita dulu umdii, God imi tiin diim uyo bomi kanubelu boyo sa daga-bom-nuluta, ulumi fen imak yom iyo dupkeng daga-bom dufak dagan-bo kalaa age no kelan-tema o,” age Yesus ilami okumop man iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kale ogenal iip maak maak iyo, Yesus iyo tebe sagaal kwep yak numi man imi dubom diim daabe dong dogobelata, tambaliim kup fitolin o age-nilipta, kulep tilip kuta, Yesus imi okumop man iyo, ogenal iyo fot tebelup daaginin o age yan-togon-kalip e, ");
INSERT INTO tlf_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesus iyo itamata, kanu-e-bilip kalaa age-nala e, imi aget tem uyo olsak kup depmu e, okumop man imi bogobe-nala e, “Unang tinum utamipta, God beyo nuyo dong dogobelan-tema kalaa age-nilip mitam God imi daam tem telebip iyo man kangkang ilitap kale, ibo man bilip iyo fot tebemin ba kale, imkalip nimi finang tilin o ageta kale, ");
INSERT INTO tlf_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","nimi weng ko bogobeli bomi magam uyo dam bogobelan-temi kale, tinangku-silipta. Man iyo kangkang albip uta, aalabal iyo, mufekmufek umaak kobelum o agelan-temip uyo, man bilip iyo maagalo yak aalabal imi sagaal diim mufekmufek uyo kulan-temip kale, ulutap mungkup, unang tinum waantap ita, God imi daam tem uyo tam unum o agelip uyo, dupkalipta, God yagal dong dogobelata, God imi daam tem uyo mitam tolon-temip kale minte, unang tinum waantap ita, ilimi aget fugun-bom kuguup mafak kanumum o agelip uyo, ilimi san kale, mitam God imi daam tem uyo mitam tolon-temaalip o,” age-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","kota yak man kangkang iyo imdep mek imtal migi-nala e, sagaal taga-e-bom bogobe-nala e, “God iyo kabo kuguup tambal kupkakemak o,” age yakyak kema ko. ");
INSERT INTO tlf_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kale Yesus ninggil iyo daage mep ko yang ilep tamip e, tinum maak yuut tal Yesus imi miit tem ko tal-nala e, kamok kamok imi weng umka-emin uyo kanumin kale, katuun duung fegela daak ton-nala e, daga-nala e, “God imi weng kafalemin kabaa. Kabo tinum tambal kale, niyo weng maak kale, dagalita, kabo bogopnelapta, niyo tol utaman. Niyo mitam suun nin tinum kelan o agan-bii kale, bota dogobe-nilita, mitam suun nin tinum kelan-temi o?” age dagala e minte, ");
INSERT INTO tlf_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesus isiik bogobe-nala e, “Kabo intaben o ageta bogopne-nalap, ‘Kabo tinum tambal o,’ nagelap a? Tinum tambal iyo maak albaala kale ki, God maagup ita kup tinum tambal kale, kapmi weng ko bogopnelap boyo, beyo waanta kalaa nage-nalapta, bogopnelap a? ");
INSERT INTO tlf_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kale kapkal utamsap kale, ulo uyo bogo-nulu kano, ‘Kabo kapkum iyo angkolap kaanamin ba e minte, kapmi kalel uyo kupkaa yang unang migik so sa dagamin ba, kabo yuguut uyo unan-kalin ba, kapkum iyo fenga kolin-tem uyo, kabo bisop bogo kiyap iyo baga-emin ba, kabo bisop bogo kapkum imi mufekmufek uyo kwaa-emin ba, minte kabo kogen so kaalap so iyo tele tiin mo-nalap e minte, imi weng uta kup tinangka-bom no kemin o,’ age ulo uyo kam agesu o,” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","tinum besiik bogobe-nala e, “God imi weng kafalemin kabaa. Niyo man katip kegal ki, ulo kanupmin boyo alugum waafuu kwep tebesi o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus iyo atam tinum bemi aget uyo atin kobe-nala e, bogobela, “Bole kanum-nuubap kuta, kabo kuguup maagup maak bota kup kanum-nuubaalap kale, kabo no-nalap kapmi mufekmufek uyo kapkumal imi kobelapta, ita molip umi mani uyo kulu iip kulin man imi kobelan-temap uta, no God imi abiip kal suun kup tambaliim nan-temap ko. Kale kanube-nalapta, kabo talapta, nisino tiine-bomta, God imi ogok uyo kemum o,” agela kale, ");
INSERT INTO tlf_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","tinum beyo mufekmufek soyaap kale, Yesus imi weng bogobela boyo tolong do-nalata, imi aget uyo fuguno-nala e, “Atin suun nin tinum kelan o agan-bii kuta, nimi mufekmufek boyo fen iip kulin man iyo kopman-temaali o,” age-nalata, aget iluum kup tebebelu e, Yesus iyo dupka daagina ko. ");
INSERT INTO tlf_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kale Yesus iyo fupkela kek fen ilami okumop man imi bogobe-nala e, “Kwiin mufekmufek soyaap unang tinum iyo bong kup fagan-biita mitam God imi daam tem uyo mitam tolon-temip o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","okumop man iyo Yesus imi weng boyo tinangku-nilip e, kumang molip kalaa age-nalata, Yesus iyo weng uyo asok bogobe-nala e, “Nugumal ibaa. Unang tinum iyo bong kup faga-bomta, mitam God imi daam tem uyo mitam tolon-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Minte kong kiim ko age kamel boyo, tam men sok sil imi magat kun tem ilep tam iinon o agelu uyo, bong fagan-bii-nuluta, tam iinon-temu kale, ulutap kale, tinum mufekmufek soyaap yagal mungkup atin bong kup fagan-bii-nalata, mitam God imi daam tem uyo mitam tolon-tema o,” agela e bole, ");
INSERT INTO tlf_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ninggil iyo atin kumang mo Yesus imi bogobe-nilip e, “Kanube tinum mufekmufek soyaap iyo bong faga-bom-nala, tam God imi daam tem uyo tam una umdii, minte win binim unang tinum nuyo dogobe-nulupta, tam God imi daam tem uyo tam unon-temup a? Boyo fen bagang-kale tam unomup binim o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesus iyo ilimi tiin tem kek fen dagak diibe-nala e, bogola ko. “God ita tii alugum mufekmufek uyo kanube-nama kuta, tinum ilasinon uyo, bagang-kale-nalata, mitam God imi daam tem uyo mitam tolon-temaala kale, God yagal tebe dong dogopman-tema uta, mitam God imi daam tem uyo mitam tolon-tema o,” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Fita isiik bogobe-nala e, “Kamogim kabaa. Tinangku-salapta. Ninggil nuyo numi abiip sino numi mufekmufek sino uyo alugum kupka-nulupta, kapmi ogok uta kem kapsino tiinan-bulup kole a?” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesus iyo bogobe-nala e, “Weng koyo dam bogobelan-temi kale, tinum dok ita nimi ilak uyo do-nilip nimi weng tambal boyo kwep no unang tinum iyo baga-eman o age-nilip imi am min, figal min, nagalal min, ibinangal min, ogen min, aalap min, man min, iman ilang min uyo kupka-nilip tal nimi ogok uta waafulip umdii, ");
INSERT INTO tlf_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kamano kafin diim kaa albip kota, nimi ogok ke-bilip umi kalan uta tinum migik iyo tebe yan-togon-bom min, aa-bom min keman-temip kuta, ibo am migik min, figal min, nagalal min, ibinangal min, ogenal min, man min, iman ilang min ulumi kup wan handret (100) kota kululan-temip kale, son-temu nala tam abiil tigiin nan-temip uyo, kugol suun kup nan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kale unang tinum kwiin tagang kamano komi win so albip iyo biilan-temu uyo, bilip isiik win binim ke kubaganip e minte, unang tinum kwiin tagang kamano komi win binim ke kubagansip isiik biilan-temu uyo, win so ke no kelan-temip o,” age Yesus iyo kam agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kale Yesus so ilami okumop man sino ninggil iyo daage, abiip miton Jerusalam unum o age abe-bom-nilip e, Yesus isiik bon tem abe-bala e, ilami okumop man ita umik tem abe-bom-nilip e, bogolip, “Kwiin bo no tamup nuyo anolan-temip kwei,” age-nilip e, aget kup fugun abe-bilip e minte, tinum migik ninggil imi umik tem tebebip iyo finanip ko. Kale Yesus ilami tinum tuluun kal ita kup ulu kulep yang kweng kal ilami suuk nala tinum tebe-nilip kanu-eman-temip umi sang uta asok bogobe-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Ibaa. Jerusalam kamet iinum o age talan-bulup kale, no kugol bom-bulupta, tinum maak tebe-nala e, Mo Tibil imi Man niyo nimdep no tinum amem ko age pris imi kamogimal so ulo utamsip tinum so imi diim daabelata bole, igil weng tegen-bom-nilipta, ‘Tinum beyo angkolip kaanak o,’ nage bogo kupka-nilipta, nimdalip yak Rom kasel imi sagaal diim abelita, ");
INSERT INTO tlf_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ita tebe-nilipta, titul weng bagane-bom-nilip e, mok uyo nimi kaal diim uyo tagaa kone-bom-nilip e, sok ifet ku saal daga-bom ke-bii-nilip e, nangkolip kaani namalip bii, am alop ke-nilita, am asuno diim kota asok fen tigi molan-temi o,” age Yesus iyo kam agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kale Sebedi imi man alop Jems so Jon so iyo tal Yesus iyo bogobe-nilip e, “Numi kafalemin kabaa. Alop numi aget fugunin uyo, mufekmufek sang kaa bogopkelan-temup koyo kanubelal o agan-bulup o,” agelip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","isiik alop imi bogobe-nala e, “Alop ibo niyo, intaben uta nubelak o nagan-bilip o?” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","alop isiik bogobe-nilip e, “Suuk nala kabo mitam kamok king kelan-temap uyo, alop nuta imkalapta, maak iyo te kalapmi ipkuk ilo keng kal tona e, minte maak ita te afaan ilo keng kal tona no ke-bom kabo dong dagake-bulupta, ninggil nuta unang tinum iyo tiin molum o,” agelip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesus isiik ilami kaal fuyap kulan-tema umi sang uyo alop imi bogobe-nala e, “Alop ipmi dagagan-bilip bomi magam uyo ibo tele utamin-tem kale, kuguup mafak maak kek kek ita tebe nimi kopnelan-temip uyo ipkil tii boyo ku no kelan-temip aga? Minte nimi kaal fuyap ogen umtal daa kaanan-temi uyo ipkil tii boyo ku umtal daa kaan no kelan-temip aga o?” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","alop isiik bogobe-nilip e, “Aa. Alop nuyo tii boyo kanubelan-temup o,” agelip e, Yesus iyo bogobe-nala e, “Dam kale, ibo nimi kuguup mafak ko kopnelip umtal daa kaanan-temi ulutap kelan-temip kuta, ");
INSERT INTO tlf_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","boyo nimi ogok keluta, tinum ulu-nilita, kamok imi baan diim nimi mep so albu uyo imdep daalan-temaali kale, boyo God imi ogok kale, yagal tinum iyo ulusa kale, imdep daalata, ita tebe dong dagane-bilipta, unang tinum iyo tiin molan-temup o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kale Yesus imi okumop man nagaal kal iyo Jems so Jon so alop imi weng ko bogolip bomi sang tinangku-nilip e, ninggil iyo tebe alop iyo olsak kopmip e, ");
INSERT INTO tlf_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesus iyo ninggil iyo olapma alugum tal tamip e, bogobe-nala e, “Ibaa. Ipkil utamsip kale, kafin diim komi God imi ilak dolin binim unang tinum imi kamogimal iyo unang tinum iyo alaang weng uyo kupka-e-bom-nilip e minte, ilimi aget fugunin weng uta kup kuguup mafak uyo kupka-e-bom no kem-nuubip kuta minte, ");
INSERT INTO tlf_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","nimi ilak dolin ibo bilip imi kuguup ko kanum-nuubip boyo ipsiik dagaa ku kanumin ba kale, ipmi tinum iyo dok ita, nita nugumal imi tiin diim uyo te tam win tibin kelan o agela umdii, beyo ilami win uyo kufumin ba kale, bilili age-bom ipkumal imi bon tem kiit fenaman-tema bota tambaliim kale minte, ");
INSERT INTO tlf_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ipmi tinum iyo dok ita, nita mitam nugumal imi kamok kelita o agelan-tema uyo, beyo alugum ipmi dong daga-emin tinum kelan-tema bota tambaliim ko. ");
INSERT INTO tlf_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kale Mo Tibil imi Man niyo kafin diim koyo bisop tal ton-bom-bilita, tinum ita nimi ogok uyo kenemin o ageta tisaali kale, niyo tal-nilita, fomtuup ogok ke-bom unang tinum iyo dong daga-eman o ageta ti-sii kale, niyo tal-nilita, waasi iyo imkali tebe nangkolip kaanan-temi bota unang tinum kwiin tagang imi ilim uyo bobelita, bilip iyo God imi man ke suun nin o ageta ti-sii kale, ibo nimi unang tinum dong daga-e-bii ulutap ke-bom-nilipta o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kale Yesus ninggil iyo dagaa dep no abiip Jeriko no abe-nilip e, Yesus so e minte ilami okumop man so unang tinum kwiin tagang so iyo, Jeriko uyo kupkaa unum o agan-kalip e bole, Timeus imi man Batimeus beyo tiin bigibesu kale, mufekmufek uyo nenin kup boma kale, ilep daang diim kugol tonba kale, ");
INSERT INTO tlf_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","tinangkulata, “Abiip Nasaret kayaak Yesus ita talan-be o,” agelip kalaa age-nala e, kota ol-bom-nala e, “Kamogim Yesus kabaa. Kabo kapmi afalik King Devit ilatap kale, ni-filin daa kapmi titil uyo ku-nalap dong dogopne o,” agan-bala e, ");
INSERT INTO tlf_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","tinum kwiin tagang iyo, “Sining agelal o,” agan-bom an-togon-bilip kuta, fomtuup ol-bom-nala e, “King Devit imi man ilop kamogim kabaa. Kabo ni-filin daa dong dogopnelal o,” agan-bom-nala e, olmin kup kema ko. ");
INSERT INTO tlf_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kale Yesus iyo ilep unan-be uyo kupkaa kugol mo-nala e, kek kek imi bogobela ko. “Bogobelip talak o,” agela e, tinum tiin bigibesu iyo olabe-nilip e, “Olke-be kale, bilili age-nalap fen talaal o,” agelip e bole, ");
INSERT INTO tlf_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ilim afaligen maak ku tibilaba uyo daala kwep ku daa yuut kup fen-nala e, Yesus imi finang no tama e, ");
INSERT INTO tlf_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","kota Yesus iyo bogobe-nala e, “Kabo, niyo intaben nupnelak o ageta olne-balap o?” agela e minte, tinum tiin bigibesu isiik bogobe-nala e, “God imi weng kafalemin kabaa. Nimi tiin koyo telela kopnelap tambalanepneluta, mufekmufek uyo utamaman o ageta olan-bii o,” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesus isiik bogobe-nala e, “Niyo utamita, kabo, beyo fen telela namo-nama kalaa nagelap kalaa age-nilita, kamano kaa telela kamoli asok tambalanap kale, unaal o,” agela e bole, kota maak fagaa imi tiin uyo tambalanebelu e, Yesus imi umik tem yak ku tona e, ninggil ilep ku-tele unip ko. ");
INSERT INTO tlf_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kale Yesus ninggil iyo dagaa dep tal abiip miton Jerusalam umi mep so tal Oliv Tigiin umi abiip alop maak Betfage so Betani so umi mep so kugol tal-nilip e, Yesus iyo, ilami okumop man alop maak isiik imdali unipta o agan-som-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","tam alop bogobe-nala e, “Alop ibo yak abe ko tam abiip utaman-bulup boyo tamta, kong ko age dongki kagum maak dup-diilip alba kalaa agelan-temip kale, beyo siin uyo tinum iyo maak bemi daang kun diim uyo tona dep tiinemin-tem alba kale, ibo sok talaa daa dep tolon-temip kale minte, ");
INSERT INTO tlf_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","kanum abe-silipta, tinum iyo maak alop ipmi daga-nala, ‘Intaben o age-nilipta, boyo kanu-bilip o?’ agela umdii, ipkil bogobe-nilip, ‘Numi Kamogim yagal, “Dep tilin o” agelata, tulup kale, nuyo kuun dep no daalupta, Kamogim iyo asok yuut imdalata, dep tolon-temup o,’ age bogobe-nilipta, dep tilin o,” agela e bole, ");
INSERT INTO tlf_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","alop iyo daage no abomu, kong ko age dongki kagum iyo ilep magaang tem amitung diim kugol dup-diilip alba kalaa age-nilip e, no talaa daagamip e, ");
INSERT INTO tlf_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","kota tinum kugol mobip iyo alop imi daga-nilip e, “Alop ibo intaben o age-nilipta, dongki kagum beyo talaa daagan-bilip o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","alop igil Yesus ilami weng bogobela tilip uta mungkup bogobelip e, kota alop imkalip e bole, ");
INSERT INTO tlf_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","alop iyo dongki kagum iyo dep tal Yesus imi diim daabe-nilip e, ilimi ilim uyo dulu kulep te tam dongki imi daang kun diim uyo ifobelip e, te tam tona e, ");
INSERT INTO tlf_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","kota tam tinum unang kwiin tagang imi aget fugunin uyo, king imi tal-bala deng tebemin kuguup uyo kanumin kale, Yesus imi ka-tele talan-be boyo, nuyo ilep koyo atin tambaliim kup telelepmupta, tiinak o age-nilipta, ilimi ilim iip maak maak uyo dulu kulep daak ilep kal ifu-bala e minte, iip maak maak ita minte yang abe at tung uyo kon so fagan-bii kulep te daak Yesus imi ilep tiinon-tema uyo ifu-e-bala no kem yakyak ke-bilipta, dongki beyo ilim so at bubuul so umi tip diim kutop-tele tiina ko. ");
INSERT INTO tlf_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kale unang tinum kwiin tagang iyo ugaa kulu bon tem abe-bala e minte, Yesus ita iibak kugol abe-bala e, unang tinum kwiin tagang iyo umik tem abe-bala no ke-bom-nilipta, deng tebe-bom fomtuup ol-bom-nilip e, “God imi win uyo dugola kufu-emum o,” age-nilip e, “Yesus keyo Bisel God imi win tolop diim o ageta talan-be kale, God tebe kuguup tambal uta kup kupka-e-balata o,” age-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Keyo numi afalik King Devit imi unang tinum tiin mosa ulutap kelan-tema kale, God tebe kuguup tambal uta kup kupka-e-balata o,” age-nilip e, “God imi win afaligen boyo dugola kufu-e-bom deng tebemum o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kota Yesus ninggil iyo daage no Jerusalam abe-nilip e, Yesus iyo tam ulotu am miton uyo tam alugum mufekmufek uyo utamam-sala ataan, tem iinon o agan-sulu e, kupkaa ilami okumop man tuluun kal so ninggil maagup asok daage abiip Betani unip ko. ");
INSERT INTO tlf_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kale Yesus ninggil iyo no silip nala e, abiip Betani boyo kupkaa abe-bom-nilip e, Yesus iyo iman tep tebebelu e, ");
INSERT INTO tlf_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","tiin kwep yang daalata, yet miit maak yang simaan so kugol mo-nulu e, figil bam dagan-bii kobu kalaa age-nala e, daage yang, yet bomaak dugu une-nilita o age-nala e, yang abomu, yet umi abumin am uyo tilin-tem bom-suluta, yet miit boyo kon kup bam daabu kalaa age-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","at bomi bogobe-nala e, “At kubo dum umaak abulapta, tinum iyo maak kupmi dum uyo maak so dagaa ku unelan-temaalip o,” agan-kala e, ilami okumop man iyo tinangkulip ko. ");
INSERT INTO tlf_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kale Yesus ninggil iyo dagaa dep tal Jerusalam tal-nilip e, Yesus iyo daage tam ulotu am miton tam-nala e, tinum mufekmufek kulep te tam to-bilip so e minte tinum migik tal, mo God imi kobelum o age saan-bilip so iyo fot tebela sigino tam iine-bilip e, tuumon kobina tala kemin tinum imi tebol uyo dagaa kup-kiit mobe-nala e, uun abim God imi kuga-emin umi kulep tal tolip saanin tinum imi siya uyo duko kulupma yang abe no kebelu kupkaa ");
INSERT INTO tlf_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","bogobe-nala e, “Ibo mufekmufek uyo kuptamo God imi ulotu am miton komi daam tem amitung diim ilep uyo mitam abe te yang milii umi amitem uyo yang abe tam iinemin ba o,” age-nala e, fegelebela ko. ");
INSERT INTO tlf_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kale Yesus iyo unang tinum ulotu am miton kutam albip imi kafale-bom-nala e, “Sugayok God imi weng suuk kon tem dola kosip maak bogo-nala e, ‘Nimi am katam uyo, “Alugum tinum miit maak maak imi beten kemin umi am o,” agan-kalon-temip o,’ agesa kale, ibo God imi weng boyo utamsip kuta, kwaasulebe-nilip God imi am uyo kufak daga-e-bilip kale, am katam uyo ipmi bisnis ke-bom ipkumal imi mani yuguut unan-kalin umi am kelu kupkasip o,” age bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kale tinum amem ko age pris imi kamogimal so ulo utamsip tinum so iyo Yesus imi weng ko bogola bomi sang tinangku-nilip e, (utamipta e, alugum unang tinum iyo bemi weng baga-e-bom kafale-be uyo tinangku kumang mo deng taban-bilip kalaa age-nilip e, Yesus iyo titine-bom-nilip e,) “Kanubelu koyo, dogobeta angkolup kaanak o?” agan una tala kemip ko. ");
INSERT INTO tlf_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kale bii kwiinu e, kota Yesus ninggil iyo Jerusalam uyo kupkaa unip ko. ");
INSERT INTO tlf_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Silip nala e, kutim kota Yesus ninggil iyo asok daage talta e, at yet umdii kon so timtim so uyo alugum datanbu kalaa age-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Fita ita bomi aget fuguno-nala e, bogobela, “Numi kafalemin kabaa. At yet miit un-togon-bii kupkaa un-maansap uyo yak ko datanbu botamal o,” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesus isiik ninggil imi bogobe-nala e, “Ibo utamta, God iyo dagalupta, beyo tii tinangku kanube-nama kalaa agan-bom dagaga-bom bom-bilipta o ageta kale, ");
INSERT INTO tlf_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","niyo weng uyo dam bogobelan-temi kale, kanube tinum dok ita God imi bogobe-nala, ‘God kabo yak amdu boyo balaa kwaalap daak yol ok kumun tem iinuk o,’ age-nala imi aget tem uyo aget alop fugunin binim ke-nala utamta, nimi ko dagali boyo fen felep unon-temu kalaa agela umdii, bemi dagala boyo God iyo tebe kanubelan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kale asok bomi sang uyo maak so bogobelan o ageta kale, kabo intaben intaben kuguup umi aget fugunota e, niyo God iyo dagalita, beyo tii boyo kanupne-nama kalaa age-nalap God iyo aman dobelap umdii, kapmi ko dagalap boyo mungkup kanupkelan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Kale kanube kabo mitam mo-nalap God imi aman duga-em tolom-nalap minte, kapkum tebe kapmi fenga kopkeba umi aget uyo fugunolap umdii, bemi fenga kopkeba boyo kupkabelap binimanuk o ageta kale, kanubelap umdii, kapmi Kaalap abiil tigiin kayaak iyo kapmi fengmin sang daga-nalap, ‘Kupkapnelal o,’ agelan-temap boyo mungkup kupkapkela binimanan-temu kuta, ");
INSERT INTO tlf_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","fen kabo bemi fenga kopkeba uyo kupkabelin-tem kelap umdii, kapmi Kaalap abiil tigiin kayaak yagal mungkup kapmi fengmin uyo kupkapkelan-temaala o,” age Yesus iyo Fita imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Kale Yesus ninggil iyo asok dagaa dep tal Jerusalam tal-nilip e, Yesus iyo tam ulotu am miton umi daam tem kutam kal tiinema e, tam tinum amem ko age pris imi kamogimal so e minte ulo utamsip tinum so Juda kasel imi kamogimal so iyo tal ");
INSERT INTO tlf_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","bogobe-nilip e, “Kabaa. Kabo waami win tolop diim kanupmin kuguup boyo kanum-nuubap a? Kabo waantap ita kamdala tal-nalapta, kanupmin kuguup boyo kanu-maansap o?” agelip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesus isiik bogobe-nala e, “Kalo. Nisiik weng maak ipmi dagalan-temi kale, ibo nimi weng boyo yan kepnelip umdii, nagal mungkup ipmi weng uyo yan kepman-temi ko. ");
INSERT INTO tlf_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ok sam uga-emin tinum Jon Baptis iyo waami win tolop diim unang tinum iyo ok sam uga-emsa a? God imi win tolop diim bele, kafin diim komi tinum imi win tolop diim kanumsa a? Nimi weng ko dagali boyo yan kepnelipta o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","tam kamogimal iyo wengaal digin-bom bogobina tala ke-bom-nilip e, bogolip, “Nuyo, intaben o agelan-temup a? Nuyo bogo-nulup, ‘God imi win tolop diim kanumsa o,’ agelan-temup bole, beyo tebe nuyo bogobe-nala e, ‘Ibo utamipta, God imi win tolop diim kanumsa kalaa agelip umdii, intaben o ageta ibo, Jon beyo fen God imi weng uta baga-e-be kalaa agansaalip o?’ agelan-tema kale minte, ");
INSERT INTO tlf_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","nuyo bogo-nulupta, ‘Kafin diim komi tinum imi win tolop diim kanumsa o,’ agelum bele ki? Umbae. Boyo kam agelan-temaalup o,” agelip ko. Kale “Kam agelan-temaalup o,” agelip bomi magam uyo dok uta ba kale, kamogimal iyo, unang tinum kwiin tagang iyo itamipta, Jon beyo fen tuluun God imi profet ko age weng kem baga-emin tinum kalaa agan-bilip kalaa age-nilipta, “Nuyo bogo-nulup, ‘Beyo God imi profet ba o,’ agelup umdii, unang tinum iyo nuyo olsak kobe-nilip ino-nimip o,” ageta finano-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yesus imi weng uyo bisop bogobe yan kebelup ko age-nilip e, “Waantap ita tebe Jon iyo bogopmata, Jon beyo tebe unang tinum iyo ok sam uga-emsa kalaa age utabaalup o,” agelip e, Yesus isiik bogobe-nala e, “Nagal mungkup ulutap kale, niyo ibo bogobe-nili, ‘Waami win tolop diim uta kanupmin kuguup boyo niyo kanum-nuubi o,’ age bogopman-temaali o,” age Yesus iyo kamogimal imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kale kota Yesus iyo kubak kobe do weng iip maak maak uyo baga-e-bom-nala e, “Tam tinum maak sok dum ilang maak telela ko-nala e, daam fogo kupkaa sok dum umi san uyo u-nala e, sok dum umi ok tugutmin umi baan diim uyo telela ko-nala e, sok dum ilang bigimin tinum imi am uyo isal am deebe no ke-nala e, minte tinum sok dum ilang bomi tiin molan-temip iyo ulu bogobe-nala e, ‘Tam sok dum umi abulan-temu uyo, dagan-bii ko kupkaa tugut-bom ok uyo ilan-bii kobelip ipkumal ita molipta, ibo tisol uyo kulu-nilipta, duula ko ipkil atuk uyo kulu-nilip e minte, nagal atuk uyo kulupnelip no telemuk o,’ age-nala e, imkaa no abiip maak simanim kal na ko. ");
INSERT INTO tlf_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kale sok dum umi abumin am uyo daanu e, (tiin molin tinum iyo sok dum uyo dagan-bii ko kupkaa tugut-bom ok uyo ilan-bii kopmip ipkumal iyo molip e,) kota sok dum ilang kayaak iyo ilami ogok kemin tinum iyo daala tal sok dum ilang tiin molin imi bogobe-nala e, ‘Nimi kamogim imi sok dum ok umi tisol atuk uyo kopnelipta, nimi kamogim imi kulubinon o,’ agan-be kuta, ");
INSERT INTO tlf_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","bilip iyo tebelipta, saal dagan-bii angko-nilip e, bisop daalip ilami kamok imi finang una ko. ");
INSERT INTO tlf_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kale tal tama e, asok kamogim iyo ogok kemin tinum migik maak iyo weng kobe-nala e, daala no sok dum ilang tiin molin tinum imi diim abe-nala e, imi kamogim imi weng kobela kwep una uyo bogobela kuta, ita tebe dubom te kobe-nilip e, kuguup mafak mafak uyo kupka-e-bii dupka-nilip e, daalip una ko. ");
INSERT INTO tlf_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kale aa mungkup maak daala no tama e, ita angkolip kaana ko. Kale kanum somta, tinum kwiin tagang iyo kulula no tamip e, iip maak saal daga-bom-nilip e minte, iip maak ita anolip kaana-bilip no kelip ko. ");
INSERT INTO tlf_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kale kota kamogim ilami man yaan maak kalaa age-nala mogop aafu-boma ita kup kela kale, kamogim iyo aget fuguno-nala e, ‘Niyo nalami man bubul keta daali una umdii, imi weng uyo kwaasulepman-temaalip o,’ age-nalata, ilami man beta afungim daala no sok dum ilang tiin molin tinum imi finang una ko. ");
INSERT INTO tlf_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kuta no tama tiin molin tinum iyo atam-nilip e, iyo buguna tala ke-bom-nilip e, ‘Tinum tala beyo kamogim ilami man kale, biilu aalap imi kaanan-tema uyo, man beyo tebe aalap imi sok dum ilang koyo bugulan-tema kale, kamaa kagal angkolup kaanata, sok dum ilang koyo nulumi aligaap keluk o,’ age-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","kota tam aafu-nilip e, angkolip kaana e, daam tem uyo kupkaa sililii duptamo tam sep kutam kal daalip o,” age Yesus iyo do weng boyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Kale Yesus iyo weng bomi atuk uyo maak so bogobe-nala e, “Ibaa. Kanubelip kalaa age-nalata, sok dum ilang kayaak iyo dogobelan-tema a? Beyo tal-nala e, tiin molin tinum kulip iyo anola atin kaan binimanip e, asok tinum migik ulu-nala e, sok dum ilang uyo kwaapma yak imi sagaal diim abelu e, igil mitam tiin molan-temip o,” age-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Yesus iyo bogobe-nala e, “Tiin molin tinum tebe-nilip sok dum ilang kayaak imi man angkolip kaanba bilip iyo sugayok kutop umi ogok kemin tinum migik imi kanu-bii-silip ilitap kale, God imi suuk kon tem uyo imi sang uyo bogo-nulu e, ‘Ogok kemin tinum iyo am uyo dinan-bomta kek fenipta e, am kun maak boyo mafak kalaa age-nilip e, falang daa kwaalip yak magaang tem kwek iinu kuta, kamok iyo am kun uyo utam-nala e, “Boyo tambaliim kale, am duu umi dol keluk o,” age-nala e, am kun boyo asok kwep mek molata, boyo felepmu molu ko. Kale kamogim kanubela beyo God yagal kale, nuyo utamupta e, imi kanubela boyo fen tambaliim kalaa age-sulup o,’ agesu kale, ibo boyo tiki-bom utamsip kuta, ibo, intaben o age-nilipta, bomi magam uyo tele utamsaalip o?” age Yesus iyo kamogimal imi bogobela e, ");
INSERT INTO tlf_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","kota igil utamipta e, Yesus iyo ilimi sang uta felep yak ku to do weng boyo baga-e-be kalaa age-nilip e, kota, aafuu de dolum o agelip kuta, unang tinum Yesus ilami weng tinangkan-bilip imi atul uta finano-nilipta, sok de dolin-tem dupka-nilip e, unip ko. ");
INSERT INTO tlf_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kale kamogimal bilip iyo tebe Falosi iip maak maak so Herot imi tinum iip maak maak so iyo kululup no Yesus imi finang uyo no-nilipta, bisop bogo weng umaak dagalipta, weng mafak umaak bogola kalaa age-nilipta, tal bogopmipta, no aafuu dep no weng telemin baan diim daalum o age-nilipta, imdalip unip ko. ");
INSERT INTO tlf_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kale Falosi ninggil iyo tal Yesus imi bogobe-nilip e, “Kafalemin tinum kabaa. Nuyo katamsup kale, kabo win soyaap tinum sino win binim tinum sino iyo kuguup tambal uyo maagup kupka-e-bom-nalap e minte, kabo tinum iyo maak imi atul uyo finan-nuubaalap no kale, kabo suun kup dam weng uta kup baga-e-bom-nalap e, God imi weng, ‘Bota kanumin o,’ agan-be uyo ku-nalapta, fen tuluun weng uta kup unang tinum iyo kafale-bom no kem-nuubap kale, mufekmufek maak umi sang uyo dagalum o ageta kale, (Rom kasel imi ulo uyo bogo-nulu, ‘Ibo ipmi takis mani uyo numi King Sisa ilami gavman imi kupka-emin o,’ agelu e minte, Juda kasel numi ulo uta bogo-nulu, ‘Ibo ipmi mani uyo God imi kupka-emin o,’ age no kesu kale,) numi mani uyo Sisa imi kupka-em-nuubup bota tambal bele, mafak a? ");
INSERT INTO tlf_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Sisa imi kupka-emum bele, kupkaa God imi kup kupka-emum a? Kapmi aget fugun-balap uyo bogobelapta, utamum o,” agelip e, Yesus iyo imi aget mafak fugun-bilip boyo utamepmata e, kanubelupta, weng mafak umaak bogola kalaa agelum o agan-bilip kalaa age-nala e, bogobela, “Intaben o ageta ibo bisop bogota nim-kugu-bilip a? Tuumon maagup umaak dep tilipta, ataman o,” agela e bole, ");
INSERT INTO tlf_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","maak dep no daabelip e, bilip imi daga-nala e, “Yak tuumon diim sinik so win so kwep yak daasip koyo waami sinik so win so uta albu o?” agela e, “Boyo Sisa imi sinik so win so o,” agelip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesus isiik bogobe-nala e, “Tuumon kanupmin koyo Rom kasel imi King Sisa ilami tuumon kale, ibo Rom kasel imi gavman ilami kupka-e-bom-nilip e minte, God imi mufekmufek ugol mungkup God imi kupka-e-bom no kemin o,” agela e, iyo tinangku-nilip e, Yesus imi weng boyo migik maak bogola kalaa age kumang molip ko. ");
INSERT INTO tlf_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Juda kasel imi kamogimal iip maak maak bilip imi win uyo, Sadusi o agan-nuubip kale, bilip iyo bogo-nilip e, “Unang tinum kaansip iyo asok fen tigi molan-temaalip o,” agan-nuubip kale, Sadusi iip maak maak iyo, (no Yesus iyo bong faga-bom yan kemin weng umaak dagalupta, unang tinum iyo utamipta, umi magam uyo tele dupkop daalin-tem kela kalaa age-nilipta, aban faga-emin o age-nilipta,) tal bogobe-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Kafalemin tinum kabaa. Sugamiyok uyo Moses iyo God imi ulo uyo dola ko-nalata, numi kobesa kale, umi atuk kwek uyo bogo-nulu e, ‘Kanube fik iyo man umaak fogolin-tem som-nala kalel uyo kupkaa kaana umdii, imi niing yagal tebe fik imi kaluun uyo kula agam imi man fagaman-temip uyo, beyo bogobe-nala, “Ibo nimi baap imi man o,” age-nalata, siin fik kaan-se imi mufekmufek uyo man bilip imi kuga-emin o,’ agesu kale, ");
INSERT INTO tlf_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","uyo tinangku-salapta. Siin uyo tinum maak man tinum ninggil ilimi kup ban kal kale, ninggil maagup te tam fito-nilip e, tam fik diil isiik unang maak ku-siit man umaak fogolin-tem ke kaana e minte, ");
INSERT INTO tlf_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ilami aafuu dep tilin ita tebe-nala e, fik imi kaluun boyo kula kuta, yagal asok man umaak fogolin-tem ke kaana e, niing iip maak yagal mungkup kanube no kela e, ");
INSERT INTO tlf_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","mungkup imi nagalal ninggil kutop igil mungkup figal imi kaluun boyo ku-nilip e, alugum maagup maagup iyo man umaak fogolin-tem ke-nilip e, kaana kaana kelip e minte, unang uta minte umik tem kaan no ke-suu ko. ");
INSERT INTO tlf_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kale tinum ban kal kalip iyo unang maagup bota kup maak isiik ku-siit kupkaa kaana kaana kem top ninggil ban kal kano biniman-silip kale, son-temu nala tinum ninggil ko kaan-silip bilip imi asok fen tigi molan-temip uyo, unang boyo waami kalel kelan-temu a? Kapmi aget fugun-balap uyo bogobelapta, utamum o,” agelip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesus isiik bogobe-nala e, “Ibo God imi suuk kon tem weng uyo tele dagaa kulin-tem ke-nilip e minte, tele utamipta, God beyo atin titil tebesa kalaa agelin-tem ke no kesip utamta, ipmi aget uyo mafak fugun-bilip kale, ");
INSERT INTO tlf_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","tinangku-silipta. Son-temu nala unang tinum kaansip imi asok fen tigi molan-temip uyo, unang dula-bom tinum dula-bom keman-temaalip kale, bilip iyo mitam migik ke-nilipta, abiil tigiin umi ensel ilitap kelan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Kale minte ipmi weng bogo-nilip, ‘Unang tinum kaansip iyo kaan atin binimansip kale, God iyo tebe maak ifola fen tigi molan-temaalip o,’ agan-nuubip bomi sang uyo bogobelan o ageta kale, Moses imi suuk kon tem weng uyo bogo-nulu e, ‘Moses beyo at katip molin maak ken tebe-bulu utamamata, God iyo tebe Moses imi olabe bogobe-nala e, “Niyo Abraham so ilami man Aisak so ilami man ilop Jekop so ulimal imi God iyo kalbi o,” age-se o,’ agesu kale, ibo suuk kon tem weng boyo tikim-nuubip kuta, tele utamsaalip kale, ");
INSERT INTO tlf_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ibaa. God iyo tinum kaan atin binimansip imi tiin mosaala kale, tinum kaan-nilip no God imi diim suun nuubip sino tinum kafan albip sino ita tiin mosa (kale mungkup, God imi weng ko Moses imi bogobesa bomi magam uyo dok uta ba kale, Abraham ulimal bilip iyo sugayok uyo kaansip kuta, fen God imi tiin diim uyo atin albip kalaa age-nalata, ulimal iyo tiin mo-bom-nalata, bogo-nala e, ‘Niyo ulimal imi God iyo kalbi o’, agesa) kale, ipmi bogo-nilip, ‘Unang tinum kaansip iyo atin kaan binimansip kale, asok fen tigi molan-temaalip o,’ agan-nuubip boyo tol ba o,” age Yesus iyo Sadusi imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Kale ulo utamsa tinum maak tal tolong do-balata, weng tegen-bilip e minte, utamata, Yesus iyo bilip imi weng uyo yan kebe weng tambal uta kup baga-e-be kalaa age-nala e, yagal Yesus imi daga-nala e, “God imi weng kobesa uyo dogonupmin uta miton o?” agela e minte, Yesus isiik bogobe-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","“God imi weng kem miton uyo ki Moses iyo bogo-nala e, ‘Israel unang tinum ibo tinangku-silipta. Bisel beyo numi God kale, maagup beta kup numi kamok kale, ");
INSERT INTO tlf_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","kabo ki atuk atuk kemin ba kale, kapmi aget aa bubul aa tiin aa titil aa uyo alugum kwaalap yak Bisel kapmi God imi diim abelu atin ilami ilak kup duga-bom-nalapta o,’ agesa bota miton ko. ");
INSERT INTO tlf_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Aa minte weng kem maak uyo bogo-nala e, ‘Kabo kalapmi kaal umi ilak do tambaliim tiin mobap ulutap ke kapkumal kek kek imi ilak uyo do telelemal o,’ agesa kale, weng kem migik umaak tebe-nuluta, weng alop boyo kubaganu kupkalan-temaalu o,” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ulo utamsa tinum isiik Yesus imi bogobe-nala e, “Kafalemin tinum kabaa. Boyo aafen ko. God ilatap iyo binim kale, maagup beta kup numi kamok kale, kabo fen tol weng uta ko bagan-balap ko. ");
INSERT INTO tlf_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kale kanube tinum iyo atuk atuk kemin binim ke-bom imi aget aa bubul aa tiin aa titil aa uyo alugum kwaala yak Bisel God imi diim abelu atin Bisel imi ilak kup duga-bom-nala e minte, ilami kaal umi ilak do tambaliim tiin moba ulutap ke ipkumal kek kek imi ilak uyo do telelema umdii, tinum bemi kanu-be bota atin uta uta ke-nulu e, tolop min iman min kwe fuulip ken tebelu God imi kuga-emin uyo kubaganu kupkalan-temu o,” agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kale Yesus iyo utamata, tinum beyo aget fugunin tambal umi weng uta bagan-be kalaa age bogobe-nala e, “Kabo mep so mitam God imi daam tem e talap God yagal, kabo tiin molan o angba o,” agela e, kota alugum kamogimal iyo finano-nilip e, maak so daga-nimip binim ke kwep unip ko. ");
INSERT INTO tlf_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kale Yesus iyo ulotu am miton kal bom-nalata, unang tinum iyo weng baga-e-bom kafalem tolom-nala e, tam weng maak uyo bogobe-nala e, “Intaben o ageta ulo utamsip tinum bilip iyo bogo-nilip, ‘God imi ulaa dula kamok kesa tinum beyo King Devit imi man ilop tiilam unsu kutop umi tinum o,’ agan-nuubip a? ");
INSERT INTO tlf_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kale sugayok uyo God imi Sinik Tambal iyo aget fugunin uyo King Devit imi kobelata, yagal bogo-nala e, ‘Bisel God iyo tebe nimi Kamogim iyo bogobe-nala, “Kabaa. Te yang nalami ipkuk ilo kamogim imi baan diim kagal ton-balapta bii, atin ki nita nita ke-nili kapmi waasi iyo kubaganip imkali kalaa age-nalapta, kapta iyo tiin molan-temap o,” age God iyo bogobesa o,’ age Devit iyo bogosa ko. ");
INSERT INTO tlf_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Kale God imi ulaa dula kamok kesa tinum beyo dok imi man a? Kanube Devit imi aget uyo fugunolata, son-temu uyo, beyo nalami man ilop kutop ita maak mitam tebelan-tema kalaa age-nala bomi aget uta kup fuguno-nala bogosa nimnam, boyo bogo-nala, ‘Beyo nimi Kamogim o,’ agesaala binim kuta, Devit iyo intaben umi aget uta fuguno no ke-nalata, bogo-nala, ‘Beyo nimi Kamogim o,’ agesa o?” age Yesus iyo bogobela ko. Mt 23:1-36, Luk 20:45-47 Kale unang tinum kwiin tagang tal ibolip bilip iyo deng kup tebe-bom-nilip e, Yesus imi weng uyo tinangkamip kale, ");
INSERT INTO tlf_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesus iyo kafalem tolom-nala e, tam weng maak uyo bogo-nala e, “Ibo ulo utamsip tinum bilip iyo tele utama-bom-nilipta. Bilip imi aget fugunin uyo, ilim timitim kup migi-bii tam abe tiine-bulupta, unang tinum iyo numi itamin o age-nilipta, kanum tiine-bom-nilip e, iyo no iman saanin baan diim unon-temip uyo, unang tinum iyo tal numi weng umka-emin o age unang tinum imi tiin diim ku-tele tiine-bom-nilip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ulotu am so iman tigi-bom fuu-bom unan-kalin baan diim so uyo no, tonamin miton diim uta kup tonum o agan-bom no kem-nuubip kuta, ");
INSERT INTO tlf_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ulo utamsip tinum bilip iyo unang kaluun iyo filto-em tolom-nilip e, imi sinamin am uyo bugubelip kupkaa am binim, mufekmufek binim ke-bom no kem-nuubip ko. Kale kanupmin kuguup mafak mafak boyo kanu-bilip kuta, iyo unang tinum imi tiin diim uta God imi aman duga-emin uyo timitim kemup ko age bisop kugol baga-bom no kem-nuubip kale, ibo bilip iyo itama-bom-nilipta a. Boyo kuguup mafak kem-nuubip kale, son-temu nala God imi tebe kaal fuyap bilip imi kupka-eman-tema uyo, kwiin kiim kupka-eman-tema o,” age Yesus iyo unang tinum imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kale Yesus iyo ulotu am miton kutam kal yang God imi mani kulep tal abumin umi tet mep so kugol ton-bom-nala e, unang tinum imi kuguup uyo uta-bom-balata, mani uyo kulep tal tet tem abumip kale, mufekmufek soyaap kwiin tagang iyo mani afalik uyo kulep tal to-bilipta, ");
INSERT INTO tlf_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","unang kaluun mufekmufek binim maak tal tuumon ken tibin alop maak dulep tal tet tem abulu utama ko. ");
INSERT INTO tlf_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Kale Yesus iyo ilami okumop man iyo olabela tal tamip e, bogobe-nala e, “Ibo unang kaluun boyo utamip a? Unang tinum migik bilip iyo mufekmufek kwiin tagang so kale, ilimi tuumon atuk katip ita kup dulep tal God imi kuga-e-bilip kale minte, unang kaluun bota mufekmufek binim minte, umi tuumon katip iman saan-bom unan-kalin ita kale, ko alugum ditang age dulep tal God imi dobelu kale, niyo dam weng bogobelan-temi kale, ibo tinangku-silipta. God imi tiin diim uyo unang kaluun mufekmufek binim bomi kuguup uyo uta uta keluta minte, unang tinum migik imi kuguup uta kubaganu o,” age Yesus iyo ilami okumop man bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kale Yesus iyo ulotu am miton uyo kupkaa mitam abiip tama e, imi okumop man maak bogobe-nala e, “Numi kafalemin kabaa. Ulotu am koyo atin am tambal kale, bilip iyo tuum tambal tambal uta kup dugu kulep yak tip tip ke-bii-nilip tuum am tambal kup desip koyo utamal o,” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesus isiik bogobe-nala e, “Am afalik ko utaman-balap komi sang uyo bogopkelan o ageta kale, tinangku-salapta. Biilan-temu uyo, waasi iyo tal am koyo alugum dalata ko komi tuum tambal uyo segela kululip daak abe-bulu bii, biniman ugulumi kup nu nu kelan-temu o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kale Yesus iyo tam Oliv Tigiin kal ton-bom-nala e, tiin kwep yak milii ulotu am miton uyo utamama e, tam Fita so Jems so Jon so Andru so ita kup ninggil albip kale, meng daga-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Kamogim kabaa. Dogap kota waasi iyo tal-nilipta, ulotu am miton boyo dalata kolan-temip a? Minte dogonupmin umi kuguup usiik maak mitam tuluta, utamupta, kuguup mafak mafak boyo mep so tulu kalaa agelan-temup o?” agelip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","kota Yesus isiik ninggil imi bogobe-nala e, “Tinum migik iyo tebe ninggil ibo bisop baga-e-bilip ibo yang iinon-temip kale, ninggil ibo bilip imi weng uyo tinangkamin ba ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tinum kwiin tagang iyo tal nimi win uta dugola kufu-bom bogo-nilip e, ‘Niyo God imi ulaa nimdula kamok kesi tinum o,’ agina agina ke-bilip e, unang tinum kwiin tagang iyo imi weng boyo, ‘Fen o,’ age tinangku yang iinon-temip kale, ibo imi weng bagan talan-bilip uyo tinangkamin ba ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Kale ibo tolong dolipta, tinum miit maak iyo fiko kulep no daala tinum miit maak so waasi dinan-bala e minte, am waasi uyo ugaa kulu dinan-bala no ke-bilip uyo mitam senganu kalaa agelan-temip uyo, ibo boyo, ‘Afungen tem mitam tulu o,’ age-nilip bomi atul uyo finanin ba ko. Kanupmin kuguup bosiik mitam tolon-temu kuta, boyo kanum ti-suluta, kutam-tele am afungen uyo yuut mitam tolon-temaalu ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kafin maak umi tinum iyo kafin migik umi tinum sino dinan-bilip e minte, kamok maak imi tinum igil kamok migik imi tinum isino dinan-bilip e minte, kafin kaa kutufosu koyo bim afalik mitam tele-bulu e minte, iman tebok mitam tele-bulu no keman-temu kale, kaal fuyabok ko kugaman-temip bota kup kulan-temaalip kale, boyo tiinuta, aaltam uyo kaal fuyap kwiin tagang uyo maak so mitam tal tal ke-bom binimanuta, kota am afungen uyo tolon-temu ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Kale ipmi kuguup uyo tele tiin mo-bom-nilipta o ageta kale, ibo nimi ogok waafuu kwep tabon-temip uyo, bomi kalan uta nimi waasi iyo tebe yaafuu de imtamo no Juda kasel imi kamogimal anggebip imi diim daalipta, iyo tebe im-kugu-bom yege-bilip e minte, ibo ulotu am unon-temip uyo, waasi iyo tebe saal daga-bom-nilip e minte, mungkup, ibo nimi ogok waafulan-temip bomi kalan uta nimi waasi iyo tebe ibo imtamo no Rom kasel imi kiyabal so kamogimal so imi diim daalip e, ita im-kugu-bom yegeman-temip uyo, kota ibo utamipta e, God imi weng umi ilep uyo kulbu kalaa age-nilipta, bilip imi diim kal nimi sang umdii baga-eman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kale afungen tem uyo tilin-tem bom-suluta, nimi ilak dolin bilip iyo God imi weng tambal uyo kwep no alugum tinum miit maak maak imi diim uyo baga-em tiineman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Kale bilip iyo tebe ibo imtamo no weng telelmin baan diim daalan-temip uyo, ibo aget yamyam uyo fugun-bom, ‘Kwiin. Kota weng kwep mek numi tem tililan-temip bota, intaben o agelan-temup o?’ agan-kalin ba kale, bilili age bom-bilipta, kota ipkil weng bagaman-temaalip kale, ipmi weng bagaman-temip boyo, God imi Sinik Tambal yagal ilipmi aget tem uyo kafale-bom baga-e-balata, weng tambal uyo bagaman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Minte tinum iyo nitafinon-bom ilimi nagalal nimi ilak dolin iyo imkem daa imdalip yak kamogimal imi sagaal diim abelip ita tebe inolip kaana-bala e minte, aalabal igil tebe man iyo imdalip yak waasi imi sagaal diim abelip inolip kaana-bala e minte, man iyo ilimi amalabal imi waasi kebe imdalip yak kamogimal imi sagaal diim abelip inolip kaana-bom no keman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kale unang tinum kwiin tagang iyo itamipta e, ibo nimi ilak uyo duga-bom nimi ogok ke-bilip kalaa age-nilip e, tebe ibo olsak kupka-e-bom itafinonan-temip kuta, nimi ilak dolin unang tinum iyo dogap ita kaal fuyap uyo utama-bom-nilip kupkaa yang iinemin binim, suun kup nimi ilak uyo fomtuup duga-bilip bii, kaanip umdii, bilip iyo God yagal tebe imtamo tam ilami abiip daalata, suun kup nan-temip o,” age Yesus iyo ilami okumop man kalbinim imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Unang tinum nimi suuk kon dola-bii umi tiki-bilip ibaa. Yesus imi weng bogo-se umi dola kolan-temi koyo tele utamin o ageta ko. Kale Yesus iyo asok ilami okumop man imi bogobe-nala e, “Son-temu uyo, ibo utamipta, Jerusalam kutam kal waasi ita tebe mufekmufek fen mafak maak kwep tam ulumi baan diim uyo kupkaa God imi ulotu am miton kutam daalipta, uta mitam-nuluta, atin God imi am uyo kufak daalu mafaganu kalaa agelan-temip uyo, kota ibo Provins Yuudiya kagal albip umdii, ipmi abiip uyo kupkaa bilii daage no amdu tem tem kal waanamin ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Minte ibo abal diim kal albip umdii, asok tam am mufekmufek umaak kulep-nulupta o age tam unemin ba kale, boyo kupkaa yuut bilii no waanamin ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Minte ibo ilipmi ilanggiip kal albip umdii, asok abiip uyo no ilim umaak kulep-nulupta o age daage abiip unemin ba kale, ilanggiip uyo kupkaa yuut bilii no waana-bom no kemin ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Minte bomi mitam tolon-temu uyo, unang kumun so so e minte unang manok so bilip iyo bilii unemin umi ilep uyo bong faga-bom-nilip e minte, kaal fuyap kiim uyo kwaa-bom no keman-temip kale, niyo bilip iyo i-filin-bii ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kale kutim uyo am mafak daan bom-bulu kanupmin mufekmufek mafak boyo mitam tulu umdii, ibo bagang-kaleta yuut bilii unomip binim kale, ibo God iyo bogobe-nilip, ‘Am mafaganu uyo, kabo mufekmufek mafak boyo kupkalap mitam telemin ba o,’ agan-bom aman duga-e-bilipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kale sugamiyok God imi kamaki kafin telela kosa kulota kwep tal kaa diibelu koyo, kuguup mafak kwiin kiim kanupmin bomi ko mitam tolon-temu kulutap uyo maak mitam tisaalu kale, son-temu nala mitam iinon-temu uyo, maak so aaltam uyo kanupmin kuguup mafak kwiin kiim boyo asok maak so mitam tolon-temaalu ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kale Bisel ilami unang tinum ulula ilami ilak dolan-temip imi i-filin daa-nalata, bogo-nala kano, ‘Kaal fuyap umi am daan tolon-temu boyo yuut te top iinu binimanuk o,’ age bogosa kale, kanupmin weng boyo bogosaala binim nimnam, son-temu uyo, unang tinum iyo alugum kaan binimanan-temip kuta, weng boyo bogosa ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Am ko daanan-temu kota, kanube tinum iyo maak ibo bogobe-nala, ‘God imi ulaa dula kamok kesa tinum Krais iyo mep kalba kale, atamin o,’ agela min, ‘Yang kulba beyo atamin o,’ agan-be min uyo, ibo, ‘Fen o,’ agan-kalin ba ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kale nimi weng kaa bogoli koyo dok uta ba kale, bisop bagamin tinum iyo tebe-nilip e, God imi tinum ulula ilami ilak dolin ibo bisop bogobe-nulupta, ipmi aget fugunin uyo kufak daabelupta, yang iinin o age-nilipta, ipmi finang uyo teleman-temip kale, maak iyo tal bogobe-nala e, ‘Niyo God imi ulaa nimdula kamok kesi tinum Krais o,’ agela e, minte maak iyo tal bogobe-nala e, ‘Niyo God imi profet ko age weng kem baga-emin tinum o,’ agela no keman-temip kale, iyo mirakel ko age kuguup ugulumi migik migik uyo kafaleman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kale nisiik mufekmufek mafak mafak ko mitam tolon-temu umi sang uyo alugum kamaki kugol bogobeli kale, ibo tele utama-bom-nilipta o,” age Yesus ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Kale Yesus iyo asok ilami okumop man imi bogobe-nala e, “Kanupmin kuguup mafak mafak boyo mitam iinu binimanuta, aaltam kota tam ataan uyo miliil molu e minte, kayop umi dong ugol mungkup binimanu e minte, ");
INSERT INTO tlf_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","biningok ugol mungkup abiil tigiin uyo kupkaa duk finano malaak abe-bulu e minte, iit abiil kun diim umi mufekmufek titil tebesip igil mungkup ilimi ilep uyo kupkaa sigin-bii ilep migik ilep tiine-bala tiine-bala ke-bom no keman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kale boyo binimanu e, kota Mo Tibil imi Man niyo iip tem tem ku-tele talanbu talan-bilita, alugum unang tinum iyo kiit fen nitamipta, titil kiim uyo ku imi dong uyo tiin bulusii kup sigin-bii talan-be kalaa age nitaman-temip kale, ");
INSERT INTO tlf_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","kota nalami ensel iyo imdali unanbu no kafin kaa kutufosu komi magaang tem kugol God imi unang tinum ulula ilami ilak dolin iyo afeta ko-nilipta, nimi finang kulep tolon-temip o,” agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Kale Yesus iyo ilami okumop man imi do weng maak bogobe-nala e, “Mufekmufek kanum mitam tolon-temu umi sang maak felep yak at yet abumin umi diim to bogobelan-temi kale, tinangku-nilipta, tele utamin o ageta kale, ibo yet bomi kuguup uyo utamipta, umi kon bam daa kalunganu umdii, boyo umi dum abumin uyo mep so tulu kalaa agelan-temip kale, ");
INSERT INTO tlf_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ulutap mungkup utamipta, nimi kuguup kanum tolon-temu umi sang baga-em tebesi uyo mitam tulu kalaa agelip umdii, kota ibo utamipta e, boyo nimi tolon-temi umi am uta mep so tulu kalaa agelan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kale nimi tuluun weng kaa bogobelan-temi koyo tinangku-silipta. Unang tinum iip maak maak kamano tiin kafan albip iyo alugum kaanin-tem bom-silipta, nimi weng bogobe-nili, ‘Son-temu uyo, mufekmufek mafak mafak uyo mitam Juda kasel imi diim abelan-temu o,’ agebi boyo fen mitam tolon-temu ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Am maak daanan-temu kota, abiil so kafin so uyo binimanan-temu kuta minte, nimi weng uyo biiluta, maak binimanan-temaalu binim kale, suun bom tuluun kup nan-temu o,” age Yesus iyo ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Kale Yesus iyo ilami okumop man imi bogobe-nala e, “‘Beyo dok kota tolon-tema o,’ nagan-bilip aga? Kafin diim komi tinum iyo utamsaalip e minte, abiil tigiin kasel ensel iyo utamsaalip e minte, God imi Man nagal mungkup utamsaali no kale, boyo nimi Aatum God maagup ita kup utamsa ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ibo utamta, niyo dok kota tolon-tema kalaa nagebaalip kale, ibo suun kup telel-bom bigi-bilipta a. ");
INSERT INTO tlf_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kale nimi no o asok tolon-temi boyo tinum maak imi no abiip simanim unba ulutap kale, tinum beyo, unanbu no abiip simanim maak kugol bii ilugo-nilita, asok tolon-temi kalaa age-nala e, ilami ogok kemin tinum iyo olabela tal tamip e, ilami mani min, mufekmufek uyo alugum kwaapma yak bilip imi sagaal diim abelu yagalami ogok uyo kobe kobe ke-nala e, amitung tiin molin tinum imi bogobe-nala e, ‘Kabo ki tambaliim kup telel-bom bigi-bom bom-balapta, tolon o,’ aginba kale, ");
INSERT INTO tlf_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","ipta utamta, dok kota am kayaak beyo tolon-tema kalaa agebaalip kale, ataan tem iinuta, toloma e? Bii mililanuta, toloma e? Uun weng tebeluta, toloma e? Kutim mililep toloma e? tap kale, kanube beyo maagalo yuut talta e, agaal unbip kalaa agelan-tema boyo mafak kale, mungkup ibo utamta, dok kota niyo tolon-temi kalaa nagebaalip kale, ipkil telel-bom bigi-bom bom-bilipta, tolon o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kale weng ko nimi okumop man ipmi bogobeli boyo alugum unang tinum imi bogobelan o ageta kale, alugum ibo tele-bom bigi-bom-bilipta o,” age Yesus iyo okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kale amsap bii kaalta Pasova umi tolop so bret fitimin binim so uyo unan-kalon-temup kalaa age-nilip e, kota tinum amem ko age pris imi kamogimal so ulo utamsip tinum so bilip iyo, Yesus iyo maagalo bantap fakala-em tolom-nulupta, de dota maagalo angkolup kaanak o age-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","bogolip, “Nuyo unang tinum tala tala ke iman tigi-bom unan-kalon-temip umi tem kwegal angkolan-temup uyo, unang tinum kwiin tagang iyo, buuk o age-nilip e, tebe nuyo yan-togon-bom ye-bom keman-temip kale, dupkalup siit iman uyo alugum unelip binimanu daagina tala kelip kalaa age-nulupta, kota angkolum o,” age weng uyo de kolip ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kale Yesus ninggil iyo Oliv Tigiin uyo kupkaa no abiip Betani kal bom-nilip e, no tinum kaal mafak kesa yagal telela dola tambalan-se Saimon bemi am kal iman unan-bom bom-salata minte, tam unang maak uyo tang tambal kuunin ok tet maak kwep tulu kale, tet boyo tuum alabasta uta kalo telela kosip kale, tang tambal kuunin ok, “Naat o,” agan-nuubip uyo kulagal albu kale, boyo tisol kwiin kiim saanin kale, unang boyo tet umi fuk kun uyo fagaa kupkan ke-nulu e, tang tambal kuunin ok uyo Yesus imi dubom diim kal sing daabelu ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kale tinum iip maak maak albip imi aget tem uyo olsak kup deebelu e, ninggil igil weng uyo bogobina tala ke-bom-nilip e, “Kwiin. Unang boyo tang tambal kuunin ok boyo tugup daalu binimanu kwei. ");
INSERT INTO tlf_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Boyo tang tambal kuunin ok boyo kwep no ipkumal iyo kobelu iyo molipta, mani ulumi kup 300 koyo kupkan ke iit seng so uyo kulu-nuluta, mufekmufek binim unang tinum imi misiim kobelan agin kuta, kupka-nuluta, bisop tugup daalu binimanu o,” age-nilip e bole, unang boyo un-togonip ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kuta Yesus iyo tinum kulip iyo bogobe-nala e, “Unang boyo kupkalin a. Boyo kuguup tambal uta nimi kanupnelu kale, un-togonin ba ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Unang tinum mufekmufek binim iyo ipsino suun kup bomip kale, ibo dong dogobelum o agelip bole, kanube ipkil tii kuguup tambal uyo kobe-nimip kuta, niyo suun kup kagal ipso nan-temaali ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Unang boyo utamuta, intaben uta tii kanube-nimi kalaa agelu uyo, ko kanubelu kale, boyo utamuta, Yesus iyo mep so angkolip kaana dep no tuum tem kal dubalan-temip kalaa age-nuluta, Juda kasel numi at kulu imi telela dep no dubamin kuguup uta ku-nuluta, niyo kaanin-tem bom-silita, tang tambal kuunin ok uyo nimi dubom diim boyo sing daapnelu ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kale koyo dam weng kup bogobelan-temi kale, son-temu nala unang tinum imi tebe kafin kaa kutufosu komi tiine-bom nimi weng tambal kupka-em tiineman-temip uyo, unang bomi kuguup tambal ko kopnelu bomi sang uyo baga-em tiine-bom-nilipta, bomi win uyo suun kufu-eman-temip o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kale Yesus imi okumop man iyo tuluun kal kale, maak iyo abiip Keriot kayaak Judas ita kale, beta, no tinum amem imi kamogimal imi diim kal Yesus iyo dupkem daalan o ageta no tinum amem imi kamogimal iyo bogobela ");
INSERT INTO tlf_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","tinangku-nilip e, imi aget tem uyo tambalanepmu e, mani uyo tiki-nilip e, weng kwep daa-nala e, “Suuk nala kanubelap kalaa age-nulupta, kota kopkelan-temup o,” agelipta, ita tebe-nala e, dogobeta dupkem daalan o age-nalata, ita tebe ilep uyo fena ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kale bret fitimin binim umi unan-kalin am kakat diim uyo Juda kasel bilip iyo sipsip man iyo an-bii ko Pasova uyo unan-nuubip kale, kota okumop man iyo Yesus imi daga-nilip e, “Kabo nuyo, no dogap kal iman ko age Pasova uyo telela kolin o agan-balap o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesus iyo ilami okumop man alop maak imdali unin o agan-be imi bogobe-nala e, “Tam abiip afalik Jerusalam umi tam unon-temip uyo, ogok kemin tinum maak tal ipmi diim abu daalan-tema kale, atamipta, beyo unang imi kuguup uyo ku-nalata, oget afalik ko age tol umi ku telela kosip uyo ok ilu ko kwep tam dubom diim daa kwep talan-be kalaa age-nilipta, imi umik begebe dep no daalip ");
INSERT INTO tlf_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","am kutam iinon-tema uyo, alop ipkil bemi kamok am kayaak imi bogobe-nilip e, ‘Numi kafalemin tinum iyo weng maak kopkela kwep tulup kale, iyo bogopke-nala, “Kapmi am komi atuk umaak kuun kale, ugaa kopmapta, nimi okumop man isino niso nuyo kutam kal numi Pasova uyo unelum o,” agelata, tulup o,’ age bogobelipta, ");
INSERT INTO tlf_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","am kayaak yagal abiin afaligen maak am dong tem kutam kal kafalebelan-tema kale, kutam umi mufekmufek uyo telela ko binim kebu kalaa agelan-temip kale, alop ibo kutam kal numi unan-kalin uyo telelamipta o,” age-nala e, imdala unip ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kale okumop man alop bilip iyo no abiip afalik Jerusalam no abomu, Yesus imi bogopma tulup uyo alugum mungkup tol kanubelu kalaa age-nilip e, Pasova umi unan-kalin uyo kugol telela-bom fuumip ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kale ataan uyo te yak tem iinu e, Yesus ilami okumop man tuluun kal so tal ");
INSERT INTO tlf_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","am ugaa kubip kutam kal ton-bom iman uyo un-bom-nilip e, Yesus iyo ilami okumop man imi bogobe-nala e, “Niyo dam weng bogobelan-temi kale, ninggil ipmi tinum maak niso unan-bulup beta tebe-nalata, nimkem daala nangkolan-temip o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","kota okumop man imi aget tem uyo mafaganepmuta, aget yamyam uyo fugun-bom du-filin-bom-nilip e, maak isiik Yesus imi dagala dagala ke-bom-nilip e, “Bota nita bele ki, naga ba o?” agan-kalip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesus isiik bogobe-nala e, “Ibo tuluun kal kale, ipmi tinum maak nisino sagaal kwep yak dis tem kulagal dufala ku unan-be beta tebe nimkem daalata, nangkolan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Sugamiyok uyo God imi suuk kon tem uyo nimi kanube kaanan-temi bomi sang uyo bogosu kale, kamano koyo mungkup bomi sang uyo mitam tolon o angbu kale, Mo Tibil imi Man niyo nangkolip kaanan-temi kuta, tinum nimi nimkem daalan-tema beyo atin kaal fuyap kup misamanan-tema kale, intaben o ageta ogen uyo beyo do-suu ee?” agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kale Yesus ninggil iyo iman uyo un-bom-nilip e, Yesus iyo bret maagup maak ku-nala e, God iyo, “Misam o,” age kupkaa fegela ko ilami okumop man iyo ife-bom-nala e, bogola, “Koyo nimi dam kale, ku-nilipta, unelin o,” agela e, ku-nilip e, unelip ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kale tam sok dum ok maak ilu ko-nala e, God iyo, “Misam o,” age-nala e, ilami okumop man iyo ifela e, alugum bilip iyo unelip e, ");
INSERT INTO tlf_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","bilip imi bogobe-nala e, “Koyo nimi isak kale, nimi nangkolan-temip uyo, nimi isak singkam daa-nulu God imi kamaa weng umi de ko-nulu unang tinum kwiin tagang imi dong dogobelan-temu uta ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kale niyo weng uyo aafentap bogopman-temi kale, asok niyo sok dum ok boyo maak so unelan-temaali kale, kupkaa bom-bili bii, no God imi abiip kugol sok dum ok umi kamaa ok uta unan-kalon-temi o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kale ninggil iman uyo unelip binimanu e, kota alugum iyo God imi suuk kon tem aseng maak kulu kupka-nilip e, abiip uyo kupkaa yak abe Oliv Tigiin unip ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kale Yesus ninggil iyo ilep abe-bom-nilip e, Yesus iyo bogobela, “Siit-nilipta, alugum ibo nimka-nilipta, bilii daaginon-temip kale, God imi suuk kon tem weng sugayok dola kosip uyo bomi sang uyo bogo-nulu e, ‘God nita waasi iyo imkalita, tebe sipsip tiin molin tinum iyo angkolipta, sipsip iyo alugum bilii daagine-bala tele-bala kelan-temip o,’ agesu kale, mungkup ipta ko kanubelan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nita kanube kaani namalip siit-nilita, asok fen-nilita, no Provins Galili unon-temi kale, kota ibo nota kugol nitamin o,” agan-kala e minte, ");
INSERT INTO tlf_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Fita ita boyo tinangku Yesus iyo bogobe-nala e, “Kamogim kabaa. Kapmi okumop man ninggil nuyo, alugum nugumal bilip ita kamkaa bilii unon-temip kale minte, niyo fen kamkaa bilii unon-temaali o,” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesus isiik Fita imi bogobe-nala e, “Nugum kabaa. Niyo tuluun weng bogopkelan-temi kale, tinangku-salapta. Kamano mililep kota uun kakaluk aalap iyo olan-bii ilep alop fagalin-tem bom-salata, kabo nimi sang uyo bogopne-nalap e, ‘Beyo nimi duup ba o,’ nage yakyak bii, ilep asuno fagalan-temap o,” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Fita isiik weng uyo fomtuup bogobe-nala e, “Umbae. Boyo kanubelan-temaali kuba. Minte tam kapsino niso inolum o agelip uyo ki, niyo bogo-nilita, ‘Beyo nimi duup ba o,’ kagelan-temaali o,” agela e minte, alugum Yesus imi okumop man iyo Fita imi weng ko bogola uta asok ku-nilip e, Yesus iyo bogobelip ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kale tam Yesus ninggil iyo mep ko daage yak anang maak bomi win uyo, Getsemani o agan-nuubip kutam iinip kale, ninggil no-nilip e, Yesus iyo ilami okumop man imi bogobe-nala e, “Niyo yang kagal God iyo aman duga-emi kale, ninggil ibo kagal ton-bom-silipta o,” age-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","imkaa Yesus iyo Fita so Jems so Jon so ninggil asuno ita kup imdep yang una ko. Kale Yesus imi aget tem uyo atin mafaganebelu e, aget afek kup fugun-bom ");
INSERT INTO tlf_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ninggil imi bogobe-nala e, “Niyo utamita, kota nangkolip kaanan-temi kalaa ageta nimi aget tem uyo atin iluum afek kup tebepnelu kale, niyo yang kugol God imi beten ke-emi kale, ipkil kagal fen-bom-nilip e, telela bigi siin o,” age-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","imkaa yagal yang so ke-nala e, katuun duung fegela daak ton suk mo kalaak fen-nala e, God iyo aman duga-e-bom-nala e, “Aatum kabaa. Kabo, ‘O,’ agelap umdii, kamano komi mufekmufek mafak ko mitam nimi diim abelan-temu boyo falang daa kwaap-namap yak iinuk o ageta kale, ");
INSERT INTO tlf_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Aatum kapta tii alugum kuguup boyo kanube-namap kale, kabo kuguup mafak meng, nafak daalan o angbu boyo fegelebelapta, nimkaluk o agan-bii kuta, nimi aget fugun-bom, ‘Aatum kabo bota fegelebelapta, nimkaluk o,’ agan-bii boyo ku kanumin ba kale, kalapmi aget fugunin uta kup ku kanubelan-temap boyo tambaliim o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kale Yesus iyo beten kem siit-nala e, kupkaa meng abomu, tinum ninggil asuno iyo agaal unbip kalaa age-nala e, meng ifo imkaa Fita imi bogobe-nala e, “Saimon kabo agaal unbap aga? Kabo titil fagaa kafan bom bigi siit ilugo-namap binim kale, yuut agaal unbap aga? ");
INSERT INTO tlf_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Saatan iyo, ibo uget taga-bilita, yang fenga kolip kalaa agelan o age-nalata, ibo im-kugu-be kale, ipmi aget fugunin uyo, kuguup tambal uta kup kemum o agan-bilip kuta, ipmi titil uyo katip kale, yang kuguup mafak uyo keman-temip kale, ibo asok agaal unemin ba kale, kupkaa kafan bom God iyo dagaga-bilipta, dong daga-e-balata o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kale kam age imka-nala e, Yesus iyo asok daage yang olang yang-nala e, ilami beten ke-bii kupkaa tala uluta asok beten kem siit kupka-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","asok meng abomu, imi okumop man iyo tiin ak tebebelu asok agaal unip kalaa age meng itama e, fitom tebebelu weng amonolip ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kale Yesus iyo asok imkaa yang-nala e, beten kem siit-nala e, ilep asuno komi diim kota asok tal ilami okumop man iyo ifo-nala e, bogobela, “Ibo asok agaal un-bomta fingkan-bilip aga? Ipmi agaal unemin uyo ko binimanu kale, fenta utamin. Kota tinum maagup maak ita tebe Mo Tibil imi Man niyo nimkem daa nimdala yak tinum mafak ninggil imi sagaal diim abelita, ita tebe-nilipta, kaal fuyap kupkaneman-temip kale, uyo kaa mitam tulu kale, ");
INSERT INTO tlf_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","tilipta, unum a. Tinum nimi nimkem daala nangkolan-temip iyo no, atam-nilita o ageta talan-be kale, no abu daalupta o,” age Yesus ilami okumop man imi bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","44","Kale Yesus iyo weng uyo baga-em-sala e, Yesus ilami okumop man iyo tuluun kal kale, tuluun keta tala kale, beyo Judas ita ko. Kamaki uyo tinum amem ko age pris imi kamogimal so ulo utamsip tinum so Juda kasel imi kamogimal so ita tebe-nilip e, tinum kwiin tagang iyo imdalip benat ko age un kong sino ulin so uyo kulep-bilip e, Yesus imi dupkem daalan-tema tinum Judas sino tal-bom-nilip e, Judas iyo bogobe-nala e, “Ibaa. Ata-bom-silipta, no tinum beyo fet dobe duptal migili umdii, beta kale, no aafu-nilipta, tele tiin mo dep unin o,” agela e, at kom fiko talan-bilip e, ");
INSERT INTO tlf_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas isiik Yesus iyo dek diibe yuut tal weng umobe-nala e, “Nimi kafalemin kabo albap aga o?” age-nala e, fet dobe duptal migim-kala e, ");
INSERT INTO tlf_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","kota sagaal togobe-nilip e, aafulip ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kale tinum Yesus so albip imi tinum maak tebe-nala e, benat ko age un kong kupdeta tinum amem miton ko age hetpris imi ogok kemin tinum maak iyo angko imi tuluun kaal milii uyo tagaa kwaapma daak abelu ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","49","Kale Yesus iyo tinum tal aafulip imi bogobe-nala e, “Niyo no ulotu am miton kugol ton-bom unang tinum iyo suun kup kafalem-nak-bii kale, ibo tii tal kugol naafuta de namo-nimip kale minte, intaben o age-nilipta, ibo kupkasipta, kamano kota ibo tinum ipkumal aa-bom mufekmufek daga-emin tinum imi aafuu de dupkabip ulutap ke-nilipta, benat so ulin so uyo kulep talta, de namolum o ageta tilip a? Boyo God imi suuk kon tem sugamiyok nimi sang dola kosip uyo ko mitam felep unu kale, tii o,” agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kale kota Yesus ilami okumop man iyo Yesus iyo dupka-nilip e, alugum bilii daaginip ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kale man tinum kasagim maak ita yak Yesus duptamo unip imi daang begebe una kale, beyo ilim namaal maak uta kup migi una kale, waasi iyo tebe de dolum o ageta aafulip e, ");
INSERT INTO tlf_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ilami ilim uyo dalaa kwep ku daa-nala e, ilim bisop bilii daagina ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kale alugum tinum amem ko age pris imi kamogimal so Juda kasel imi kamogimal so ulo utamsip tinum so iyo tal tinum amem imi kamok miton ko age hetpris imi am kal afeta-bilip kale, tinum Yesus aafuu de dolip bilip iyo tebe duptamo no hetpris imi diim ku daalip ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Kale Fita iyo Yesus imi umik tem simanim so kugol tam tam yak abe tam hetpris imi am umi daam tem tam una kuta, tam am iinoma binim kale, mitam daam tem kugol bom-nala e, un tubulin sino ton at tufuma ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kale tinum amem imi kamogimal so alugum kamok kamok migik so iyo, Yesus iyo angkolum o age-nilipta, tinum dogap ita Yesus iyo ata-bom-bilip kuguup mafak umaak kanuma atabip kalaa age-nulupta, bilip ita kululupta, weng telelmin umi diim uyo bogolipta o age-nilipta, imi fen-bilip kuta, maak atam-nimip binim kelip ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kale boyo ki, tinum kwiin tagang iyo Yesus imi sang uyo bisop baga-e-bom kanubeba kanubeba o agan-bilip kuta, kamogimal iyo utamipta, imi weng uyo yagalami baga-bala baga-bala ke-bilip kalaa agelip ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kale minte tinum iip maak maak iyo mitam mo-bom-nilip e, weng uyo bisop baga-e-bom-nilip e, bogolip, ");
INSERT INTO tlf_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nugol tinangku-bom-bulupta, beyo bogo-nala e, ‘Son-temu uyo, nagal ulotu am miton tinum igil de kosip koyo dalata koli bii, am alop keluta, am asuno diim kota migik de kolan-temi kuta, tinum imi dinan-nuubip kulutap de kolan-temaali o,’ age-se o,” agan-bilip kuta minte, ");
INSERT INTO tlf_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","weng ko bagan-bilip bogal mungkup yagalami baga-bala baga-bala ke-bom no ke-bilip kalaa agelip ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kale tinum amem imi kamok miton ko age hetpris iyo fen mitam iibak tem kulagal mo Yesus imi daga-nala e, “Tinum bilip imi weng bagake-bilip boyo, intaben o age-nalapta, yan kepmin-tem albap a? Bilip iyo intaben o kagan-bilip o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yesus iyo atin sining agela e, hetpris iyo asok maak so daga-nala e, “Alugum unang tinum iyo God imi win uta kufu-em-nuubip kale, kabo God imi Man ulaa kamdula kamok kesap aga o?” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","kota Yesus isiik bogobe-nala e, “Kam agan-balap iyo nita kale, son-temu uyo, ibo nitamipta, Mo Tibil imi Man niyo abiil tigiin kal bom God titil tebesa imi sagaal ipkuk ilo keng kal tonbi kalaa agelip suukta minte, aaltam kota utamipta e, abiil tigiin umi iip namaal umi diim ku-tele tala kalaa age no ke nitaman-temip o,” age Yesus iyo kamok kamok imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kale tinum amem imi kamok miton ko age hetpris iyo weng boyo tinangku-nala e, Juda kasel imi aget iluum tebemin umi kuguup uyo kanumin kale, ilami ilim migiba uyo fengela ko kupkaa tinum alugum tonbip iyo bogobe-nala e, “Ibaa. Nuyo tinum maak fen-bom atamupta, beta Yesus imi sang uyo maak so bogolan-temaala binim ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Bemi weng mafak bogola boyo God imi win uyo kufak daabela ibo tinangkulip kale, ipmi aget fugunin uyo, tinum keyo dogonubelum o agan-bilip o?” agela e, alugum iyo bogo-nilip e, “Beyo atin kuguup mafak uta ku-nalata, kanubela kale, daalup yak Rom kasel imi diim abelata, angkolip kaanak o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kale tinum iip maak maak albip iyo kota duban tagaa ko-e-bom-nilip e, ilim ku Yesus imi tiin so tibit so uyo katibe-nilip e, kul mim kulu saal daga-bom-nilip e, titul weng fiil weng uyo baga-e-bom-nilip e, “Kabo bogo-nalap, ‘God ita nimdala ti-sii kale, niyo alugum mufekmufek uyo utamsi o,’ agan-nuubap kale, kabo nitamta, beyo dok ita tebe nan-be kalaa agelap umdii, nimi win uyo bogopnelapta, utaman o,” agan-bom saal dagan-bii yak iina yak iina ke-bii dupkalip e, kota un tubulin iyo tebe Yesus iyo saal dagamip ko. ");
INSERT INTO tlf_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kale Fita iyo daak abiip daam tem kugol bom-sala e, tinum amem imi kamok miton ko age hetpris imi ogok kemin unang maak uyo talta, ");
INSERT INTO tlf_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Fita iyo at tufun-be kalaa age tal tele atam-nulu e, bogobe-nulu e, “Kapkal mungkup Nasaret kayaak Yesus so tiinan-nak-balap o,” agelu e, ");
INSERT INTO tlf_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Fita iyo bogobe-nala e, “Umbae. Niyo kupmi weng bagan-balap kwek uyo tele bam daalin-tem o,” age-nala e bole, kupkaa yang am daam tem umi amitung diim umi mep so kugol mo-bom-sala e minte, ");
INSERT INTO tlf_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ogok kemin unang boyo Fita iyo atam-nulu e, asok tinum maak kugol mobip bilip imi bogobe-nulu e, “Ibaa. Tinum keyo Yesus imi tinum maak umdii kalba o,” agan-kulu e minte, ");
INSERT INTO tlf_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Fita iyo asok atin fulma kupkala siit tap ilugo-nilip e, tinum kugol mobip iyo tebe asok Fita imi bogobe-nilip e, “Utamupta, kabo Provins Galili kayaak kalaa age-nulupta, fen kabo Yesus imi tinum maak iyo kalbap kalaa agan-bulup o,” agan-kalip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Fita isiik weng uyo fomtuup bogobe-nala e, “E-e. Ipmi tinum bemi sang ko bagan-bilip beyo atin atamsaali binim kale, niyo weng bisop umaak bogobeli umdii, God iyo tebe niyo kaal fuyap kop-naman-tema o,” agan-sala e, ");
INSERT INTO tlf_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","kota uun kakaluk aalap iyo mungkup aaltam uyo olala e, kota Fita umdii tolong do-nala e, asok aget fugunolata e, siin Yesus imi bogopne-nala, “Uun kakaluk aalap iyo olan-bii ilep alop fagalin-tem bom-salata, kabo nimi sang uyo bogopne-nalap, ‘Beyo nimi duup ba o,’ nage yakyak bii, ilep asuno fagalan-temap o,” ageba uyo fen ko kanubeli kalaa age-nala e, bomi aget uyo fuguno-nala e, kota fomtuup amema ko. ");
INSERT INTO tlf_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kale am daanu e, kutim kota tinum amem ko age pris imi kamogimal so Juda kasel imi kamogimal so ulo utamsip tinum imi kamogimal so kamok kamok migik so iyo weng uyo telela ko-nilip e, kota ilimi un tubulin iyo bogobelip e, ita Yesus iyo sok de do dep no daalip yak Rom kasel imi kiyap Pailat imi sagaal diim abela ko. ");
INSERT INTO tlf_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Kale Yesus iyo Pailat imi tibit diim kal mola e, Pailat iyo daga-nala e, “Kabo Juda kasel imi kamok king iyo kulbap bele ki?” agela e minte, Yesus isiik bogobe-nala e, “Niyo maak bogolin-tem kale, kapkal bogolap o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kale tinum amem imi kamogimal iyo mufekmufek kwiin tagang umi sang uyo bisop bogo-nilip e, “Tinum beyo tuluun kanubeta fenga koba o, fenga koba o,” agan-bilip e, ");
INSERT INTO tlf_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pailat iyo asok maak so Yesus imi daga-nala e, “Kabo mufekmufek sang yamyam uyo kwep yak kapmi win tem tilike-bilip boyo tolong dolap a? Kabo intaben o ageta bilip imi weng boyo yan kebelin-tem kupka-nalapta, sining agebap o?” agan-be kuta, ");
INSERT INTO tlf_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yesus iyo Pailat imi weng maak yan kepmoma binim kupkala kalaa age-nala e, Pailat iyo kumang mo aget yamyam fuguna ko. ");
INSERT INTO tlf_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kale Juda kasel bilip imi kuguup uyo kanumin kale, utamipta, atol mitam tulu koyo, Juda kasel imi ifin am ko age Pasova unan-kalin umi am uyo daanu kalaa age-nilip e, tala tala kelip e, Rom kasel imi kiyap iyo bogobe-nala e, “Tinum sok desup iyo ipkil bogo-nilip, ‘Kanuminak beta talaa daalin o,’ agelip kalaa age-nilita, bogobeli beta kup talaa daalin o,” agela e, igil, “Beta o,” agelan age-silip kanube ilami waasi dinan-kalin iyo kulula no talaa daa win tolobelip daage un un kem-nuubip kale, ");
INSERT INTO tlf_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kale siin kota tinum milii maak tebe gavman iso waasi dinan-bom-nilip e, tinum iyo aa-bilip kaana-bilip e, kota gavman iyo tebe tinum kulip iyo sok dinan-bii kolip kalabus am kutam kal bilip kale, kutam bilip imi tinum maak bemi win uyo Barabas ko. ");
INSERT INTO tlf_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kale tinum tal ibolip iyo meng-nilip e, Pailat imi bogobe-nilip e, “Siin Pasova iman un-bulup kuguup kanu-em-nuubap ulutap kebelal o,” agelip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Pailat iyo utamata e, Yesus iyo kuguup mafak umaak kanupmata, tinum amem ko age pris imi kamogimal iyo daalip mek nimi diim uyo abelin-tem kalaa age-nala e minte, unang tinum iyo Yesus imi weng uyo baga-e-bala tinangku-nilip e, imi win uyo kufu-e-bom deng taban-bilip kalaa age-nilipta, kamogimal bilip ita titine-bomta daalip mek nimi diim abela kalaa age-nala e, Pailat isiik unang tinum iyo daga-nala e, “Ipmi aget fugunin uyo, niyo nimi waasi dinan-kalin tinum iyo bogobelita, Juda kasel ipmi kamok king beta talaa daabelin o agan-bilip aga o?” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","tinum amem ko age pris imi kamogimal iyo tebe tinum tal ibolip iyo wit mobelipta, igil Pailat imi weng boyo yan kebe-nilip e, “Kapmi kayaam iyo bogobelapta, Barabas ita kup talaa daalin o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","asok Pailat iyo bogobe-nala e, “Kam agelip bole, Juda kasel ipmi, ‘Kamok king o,’ agan-nuubip keyo dogonubelal o nagan-bilip o?” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","isiik ol-bom-nilip e, “Dep yak at diim daa dubiit mo angkolin o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailat iyo bogobe-nala e, “Intaben o ageta ibo boyo kam agan-bilip a? Dogonupmin umi fengmin uta fenga koba kalaa ageta bomi kalan o age-nulupta, angkolan-temup o?” agan-be kuta, tolong do-nilip e, fomtuup ol-bom-nilip e, “Dep yak at diim daa dubiit mo angkolin o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kale Pailat iyo, kanubelita, tinum tal ibolip imi aget uyo tambalanepmuk o age-nala e, bilip imi weng uyo tinangku-nala e, ilami waasi dinan-kalin tinum iyo bogobelata, no Barabas ita talaa daa dupkalip daagina e bole, waasi dinan-kalin iyo bogobela ita sok ifet uyo ku Yesus iyo saal dagan-bii angko dupkalip e, kota waasi dinan-kalin tinum bilip imi bogobe-nala e, “Ibo dep yak at diim kal dubiit mo angkolin o,” age-nala e, daapma yak waasi dinan-kalin bilip imi diim abela ko. ");
INSERT INTO tlf_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kale waasi dinan-kalin tinum bilip iyo tebe Yesus iyo duptamo tam kiyap imi am afalik umi atuk kutam uyo ilimi sinamin am kale, dep tam kutam daa-nilip e, waasi dinan-kalin tinum iyo alugum tala tala ke-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","bisop bogo kamok king imi ilim tiimin ulutap kebe tiibelum o age-nilipta, ilami ilim uyo dulu kupkan kebe-nilip e, ilimi ilim isagulut maak uta ku kwaak kalibe-nilip e minte, sok ningiling so uta ugaa ku-nilip e, king imi dufalum ulutap kebe ilu ko kwep tam imi dubom diim uyo kwaak kalibe-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","titul weng baga-e-bom-nilip e, “Juda kasel imi kamok king kabo albap aga o?” age-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","at kun iyo du imi dubom uyo do-e-bom-nilip e minte, tebe duban tagaa ko-e-bom-nilip e, king imi weng umka-emin umi kuguup kanumin kale, katuun duung fegela daak ilami miit tem kugol ton-nilip e, weng tambal uyo baga-emip kuta, boyo bisop titul weng baga-e-bom kanu-emip ko. ");
INSERT INTO tlf_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kale titul weng baga-e-bilip uyo binimanu e, kota bilip iyo ilim isagulut kwaak kalibelip uyo dalaa kupkan kebe-nilip e, asok ilami ilim uta migibe-nilip e, dep tam abiip abe-nulupta, dep no, at diim kal dubiit mo angkolum o age-nilipta, dep tam abe unip ko. ");
INSERT INTO tlf_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kale waasi dinan-kalin tinum iyo Jerusalam uyo kupka-nilip e, Yesus iyo duptamo abe-bom-nilip e, utamipta e, Aleksanda so Rufus so alop imi aalap Saimon Sairini kayaak iyo sep ilota talan-be kalaa age-nilip e, asit kup ninuk tebebe-nilip e, Yesus imi dubiit mo angkolan-temip umi at uyo kobelip Saimon isiik kuptamola e, isino daage ");
INSERT INTO tlf_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","tam tam no Golgota Tigiin ko age Dabaal Kun Tigiin o agan-nuubip uyo unip ko. ");
INSERT INTO tlf_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kale waasi dinan-kalin tinum bilip iyo sok dum ok so minte marasin so uyo kwego dego ke fiksigi ko-nilip e, Yesus imi kopmup unelata, imi dep yak at diim daa sil bigibelan-temup umi kaal fuyap uyo katip so kebeluk o age kobelip kuta, Yesus iyo “Waago o,” age kulala ko. ");
INSERT INTO tlf_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kale kota Yesus iyo at diim uyo dubiit mo dup-dii bom-nilip e, aaltam kota tuum kangkang uyo kulu kululup iit o malaak o ke-bomta, waanta ita ita kela kalaa age, beta Yesus imi ilim uyo kula kula kelum o age-nilipta, Yesus imi ilim umdii dulube-nilip e, togolip ko. ");
INSERT INTO tlf_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kale Yesus imi at diim dubiit molip uyo, ataan tal dubim e tilin-tem bom-suluta, dep yak at diim daa dubiit molip ko. ");
INSERT INTO tlf_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kale Pailat imi ogok kemin tinum maak tebe at kom maak ku-nala e, dok umi kalan uta Yesus iyo angkolip kalaa age-nala e, umi sang uyo bomi diim kwegal dola ko-nala e, “Tinum keyo Juda kasel imi kamok king o,” agela e, at kom uyo dola kwep iit Yesus imi dup-diilip umi at diim kal kup-diilip ko. ");
INSERT INTO tlf_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kale waasi dinan-kalin tinum iyo tebe Yesus iyo dep yak at diim kal dup-diilip uyo, asok tinum ipkum aa-bom imi mufekmufek daga-emin tinum alop maak igil mungkup kulep tal at diim kal im-dii no ke-nilip e, maak ita dep te Yesus imi ipkuk ilo keng kal dup-dii som, minte maak ita dep te afaan ilo keng kal dup-dii no kelip kale, ");
INSERT INTO tlf_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","kanubelip boyo, sugayok uyo God imi suuk kon tem weng uyo bogo-nulu e, “Bilip iyo kuguup mafak uyo un tubulin imi tebe fuut tibin imi kupka-em-nuubip ulutap ke tinum begal mungkup kobelip o,” agesu kale, ko tol mitam tulu ko. ");
INSERT INTO tlf_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Kale tinum mep so ko tiinan-bilip bilip iyo tebe Yesus iyo aban dii-e-bom titul weng baga-e-bom-nilip e, “Kabaa. Kalapmi bon tem bogo-nalap, ‘Niyo ulotu am miton uyo dalata kulep toli bii, am alop keluta, am asuno diim kota asok de kolan-temi o,’ age kalapmi tok uyo bogobap kale, ");
INSERT INTO tlf_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","kabo ki kalapmi kaal ilak uyo do-nalapta, at diim kam-diilip uyo talaa kupkaa malaak kafin diim talaal o,” age titul weng baga-e-bilip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","tinum amem ko age pris imi kamogimal so ulo utamsip tinum so igil mungkup Yesus iyo titul weng baga-e-bom ninggil bogobina tala ke-bom-nilip e, bogolip, “Beyo unang tinum migik imi kaal ilak uta do dong daga-e-bala waalanan-nuubip kuta minte, intaben o ageta ilami kaal ilak bota do waalan-nama binim a? ");
INSERT INTO tlf_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kanube beyo fen God imi ulaa dula kamok ke-nala e minte, Israel kasel numi kamok king ke no kesa umdii, yagal at diim uyo talaa kupkaa malaak kafin diim abelata, nugol atamupta e, beta tuluun God imi Man kalaa agelum o,” age titul weng baga-e-bilip e minte, tinum alop Yesus isino ninggil maagup at diim kal im-diibip igil mungkup weng mafak baga-e-bom no kemip ko. ");
INSERT INTO tlf_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kale ataan tal dubim e tulu e, mililebok afalik uyo mitam abuta, alugum kafin kaa kutufosu uyo mililan-bom-bulu bii, ataan uyo fupkela te kek iinu e, kota mililanbu uyo asok binimanu ko. ");
INSERT INTO tlf_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kale ataan uyo te kek iinu e, kota Yesus iyo Hibru ilimi weng uyo ku fomtuup ola-nala e, “Eloi, eloi, lama sabaktani o?” agela kale, bomi magam uyo bogo-nala, “Nimi God kabaa. Nimi God kabaa. Intaben o age-nalapta, kabo bisat nimkabap o?” agan-kala e minte, ");
INSERT INTO tlf_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","tinum kugol mobip imi tinum iip maak maak iyo tolong do-nilip e, bogolip ko. “Beyo sugamiyok God imi profet ko age weng kem baga-emin tinum bii-se Elaija imi ole-be o,” age-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","tinum maak ita yuut yang mufekmufek tiyuup kon ulutap uyo ku sok dum ok amil tebesu uyo kup-kubu-nala e, at daang diim iinu e, “Unelal o,” age ilu kwep iit kobe-nala e, ipkumal imi bogobe-nala e, “Nuyo kiit fen ata-bom-sulupta, Elaija iyo talta talaa dep malaak daala kalaa age atamum o,” agela e bole, ");
INSERT INTO tlf_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesus iyo asok Aalap iyo fomtuup olabe-nala e, kota mam timi age binimana ko. ");
INSERT INTO tlf_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kale ulotu am miton kutam kal ilim afalik maak kup-diilip God imi abiin amem uyo uksu-bomu kale, Yesus iyo kaana e, kota ilim boyo dong katam-tele bigi kwep tiinu ki te daak kafin diim daa kupkaa milii so milii so alop kano kulep tolu e, God imi abiin amem kutam uyo kemanu ko. ");
INSERT INTO tlf_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kale waasi dinan-kalin tinum imi tiin molin iyo Yesus imi tibit diim mep so kugol moba kale, atamata e, Yesus iyo kanube kaana kalaa age-nala e, bogola, “Tinum keyo fen God imi Man o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kale unang kwiin tagang igil mungkup Golgota Tigiin kugol albip kale, no abe yang simanim so kugol mo-bom, ata-bom-sulupta, waasi iyo tebe Yesus iyo intaben nubelip kalaa agelum o age-nilipta, mangkal no atamamip kale, unang mobip bilip iyo Makdala kayaak unang Maria ugol, asegim Jems so Josep so imi ogen Maria ugol, Salomi ugol, minte ipkumal igil no mangkal ita kugol mobip kale, ");
INSERT INTO tlf_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","siin uyo Yesus imi Provins Galili umi bom tiine-bala uyo, unang asuno bilip iyo Yesus sino tiine-bom imi iman uyo fuu-e-bom e minte, tiin mo no kem-nuubip kale, iso e minte imi ipkumal kwiin tagang iso mangkal maagup Yesus iso dagaa dep tal Jerusalam e tal-nilip e, mangkal mo-bom Yesus iyo atamamip ko. ");
INSERT INTO tlf_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Kale tam tinum maak asegim Josep beyo abiip Arimatea tinum kale, “Beyo kamok tambal kup tebesa o,” agan-nuubip kale, unang tinum imdep tam God ilami daam tem daa tiin molak o age fen-bilip uyo, begal mungkup fen-be kale, kota beyo utamata e, amsap God imi ifin am daan-bon-temu umi mufekmufek uta telela-bilip am kwiinu kalaa age-nalata, finano-nama binim kale, no Pailat iyo daga-nala e, “Dagalita, kabo, ‘O,’ agelap kalaa age-nilita, Yesus imi at kulu uyo talaa dep no dubalan o,” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat iyo kumang mo aget fugun-bii-nala e, “Beta fen yuut kaana bele ki?” age-nala e, waasi dinan-kalin tinum imi tiin molin iyo olapma tal tama e, Pailat iyo daga-nala e, “Yesus iyo fen yuut kaana bele ki?” agela e, ");
INSERT INTO tlf_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","“Aa bole, sugayok kaanba o,” agela e, waasi dinan-kalin tinum imi tiin molin imi weng uta tinangku-nala e bole, Josep iyo bogobe-nala e, “Tambaliim kale, no-nalapta, talaa dep no dubalal o,” agela e, una ko. ");
INSERT INTO tlf_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","47","Kale Makdala kayaak unang Maria so e minte asegim Josep ogen Maria so alop iyo, tele ata-bom-bulupta, dep no dogap kal dubalip kalaa agelum o age-nilipta, tele ita-bom-bilip e, kota Josep iyo no ilim namaal maak mola e, ipkum maak so alop no-nilip e, Yesus iyo talaa daa dupka-nilip e, ilim uyo ku fufala dep no begel ilet tem ko age tinum igil tuum tem kalo ko-silip kutam kal duba-nilip e, tuum tem umi faal uyo tuum afalik naman-bii telela ko-silip uta kale, bubulun kuptamo yang amitem uyo ilobe kupkaa daaginip e, kota unang alop iyo alugum utamip ko. ");
INSERT INTO tlf_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kale God imi ifin am uyo binimanu e, mililep kota tam Makdala kayaak unang Maria so asegim Jems imi ogen Maria so Salomi so mangkal iyo tang tambal kuunin ok uyo saan-bii kulep no, Yesus imi kaal diim uyo iligebe-nulupta o age-nilip e, mangkal saan-bii kolip ko. ");
INSERT INTO tlf_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kale silip nala e, Sande kutim kota ataan uyo kamaa mitam tulu e, mangkal iyo, Yesus imi tuum tem dubabip iyo no telela dolupta o age tal-bom-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","mangkal bogolip ko. “Tuum bubulun kuptamo yak tuum tem umi faal ilobe-silip boyo kwiin kiim kale, waantap ita tebe dagaa kwaa bubulun kwaapma yak iinuta, tam unon-temup o?” agan tal-bomta keng fenipta, amitem umi tuum ko age faal uyo bubulun yang iinu faal kem albu kalaa age-nilip e, ");
INSERT INTO tlf_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","mangkal iyo yang abe tam tuum tem uyo tam abomu, tuum tem kutam kal man tinum kasagim maak ilim namaal timitim maak kwaak kali-nala e, te ipkuk ilo keng kal tonba kalaa age atam kumang molip e, ");
INSERT INTO tlf_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","mangkal imi bogobe-nala e, “Mangkal ibaa. Ibo kumang saanin ba kale, ibo Nasaret kayaak Yesus dep yak at diim kal dubiit mo angkolip kaanba imi fen talan-bilip kuta, beyo kagal albaala kale, beyo fen tigi mo tuum tem katam uyo kupkaa tam iina ko. Kale Yesus iyo dep tal katam kal duba-silip kuta, abiin uta kup kaa kupkaa tam iina koyo utam-nilipta, ");
INSERT INTO tlf_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","mangkal ipta no-nilip Fita so Yesus imi okumop man milii so iyo bogobe-nilip, ‘Yesus iyo siin ipmi bogobe-nala, “Nisiik tolobe unita, no Provins Galili kal nitaman-temip o,” age-se kale, mungkup ko isiik tolobe unon-tema kale, nota atamin o,’ age bogobelin o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kale mangkal iyo atin kumang mo bumban keng keng ke-bii finano-nilip e, tuum tem uyo kupkaa tam abiip kutam iinom-nilip e, bilii no-nilip e, tinum iyo maak bogopmomip binim kelip ko. ");
INSERT INTO tlf_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kale Yesus iyo Sande kutim mililep kota fen tigi mo mitam abe-nala e, kamaki uyo no Makdala kayaak unang Maria umi diim usiik abu daala atamu kale, siin kota sinik mafak ban kal maak tebe unang bomi diim kal nuubip iyo Yesus yagal fot tebela yak iin-silip kale, ");
INSERT INTO tlf_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","unang boyo Yesus iyo atam-nulu e, dupkaa no siin tinum ninggil Yesus so bii-silip imi finang nota e, ninggil aget iluum tebepmu bom-nilip e, aman-bilip kalaa age ");
INSERT INTO tlf_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","no bogobe-nulu e, “Yesus iyo fen tigi mo bom-balata, atam tili o,” agelu kuta, unang bomi weng boyo tinangku-nimip binim kelip ko. ");
INSERT INTO tlf_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kale aaltam kota aa mungkup tinum alop maak abiip afalik Jerusalam uyo kupkaa, nulumi abiip unum o age abe-bilip e, Yesus iyo mitam tinum migik ilatap ke no tama e, alop iyo atam-nilip e bole, ");
INSERT INTO tlf_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","asok ilimi abiip uyo kupkaa no Jerusalam no-nilip e, Yesus atam tilip bomi sang uyo ipkumal imi bogopmip kuta, mungkup ipkumal iyo tinangku-nimip binim ke no kelip ko. ");
INSERT INTO tlf_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kale aa mungkup Yesus imi okumop man kum kal iyo bii-nilip e, kota ton-bom iman unan-bilip e, Yesus iyo daage tam am tama atamip e, kota yagal itamata, ninggil ilimi aget tem uyo utamta, Yesus beyo fen tigi molan-tema kalaa aganbaalip binim e minte, unang tinum tal bogobe-nilip, “Iyo fen tigi mola atam tulup o,” agan-bilip boyo fen kalaa agomip binim ke, kupkaa tinangkulaalup o agan-bom no ke-bilip kalaa age-nalata, bomi kalan uta ninggil iyo yan-togon-bii imka-nala e, ");
INSERT INTO tlf_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","kota Yesus iyo ninggil imi bogobe-nala e, “Ibo nimi weng tambal uyo kwep no abe alugum kafin kaa kutufosu komi abiip maak maak umi unang tinum iyo baga-em tiine-bilipta, ");
INSERT INTO tlf_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","kanube unang tinum dok ita te tam nimi ilak uyo do ok sam ugolip umdii, God iyo tebe bilip iyo dong dogobela ilimi fengmin kuguup uyo kupka-nilipta, waalanan-temip kale minte, kanube dok ita nimi ilak uyo dolin-tem kelip umdii, God iyo tebe unang tinum bilip iyo fomtuup yega dobe-nalata, kaal fuyap uyo kobelan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kale nimi ilak dolin bilip iyo God iyo tebe dong daga-e-balata, mirakel ko age kuguup ugulumi migik migik uyo kanuman-temip kale, kanuman-temip boyo ki, nimi win uta kufo-nilipta, sinik mafak iyo fot tebelip yak iine-bilip e minte, weng migik utamsaalip binim uyo baga-bom-nilip e minte, ");
INSERT INTO tlf_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","kanube inap mafak atul tebesa iyo du aafulip min, ok une kaanamin uyo unelip min uyo, boyo tebe ifak daalu kaanamin binim ke-bom-nilip e minte, bilip iyo tebe sagaal kwep yak unang tinum mafak ilin imi dubom diim daabelip unang tinum mafak ilin iyo tambalana-bom no keman-temip o,” age Yesus iyo ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kale Kamogim Yesus iyo weng uyo baga-e-bii binimanu kupkala e, kota God iyo tebe duptamo iit abiil tigiin daala e, te God imi sagaal ipkuk ilo kamok imi baan diim keng kal tona ko. ");
INSERT INTO tlf_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kale kota imi okumop man bilip iyo no abe yak alugum abiip maak maak uyo baga-em tiine-bilip e, Kamogim Yesus imi Sinik Tambal ita tebe dong daga-e-bala e, ilami siin weng bogobe-se uyo mungkup kanu-bilip e, unang tinum iyo ninggil imi mirakel ko kanu-bilip boyo utamipta e, bilip imi weng boyo fen kalaa agan-bii-silip ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nugum kamok Tiofilus kabo nuubap aga? Luk nita suuk kon koyo dola kop-kaman o ageta ko. Kabo utamsap kale, siin uyo tinum kwiin tagang iyo God iyo tebe-nala mufekmufek kwiin tagang numi iibak tem kutam umi kanumsa umi sang uyo tinangka-bom-nilip e, dagagan tiine-bom afeta-bomta dola kola dola kola kemsip ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Tinum ilimi tiin fala Yesus atam-silip iyo ata-bom-bilipta, Yesus iyo kamaki kutop ilota kanum kwep talanbu tal kaa diibela kalaa age-nilipta, igil Yesus imi weng uyo nuyo baga-e-bilip tinangkan tebesup kale, tinum suuk kon dola-silip bilip iyo tinum ilimi tiin fala Yesus atam-silip imi bon tem weng uta tinangku-nilipta, dola kola dola kola kemsip ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kale nagal kamaki kutop kal suuk kon dola-silip umi tem uyo tiki-bom utama-bom-nili e minte, unang tinum imi bon tem weng uyo kuga-bom no ke-bom-nilita, weng atuk atuk koyo kwego dego ke tambaliim afeta ko-sii kale, Tiofilus kapmi dola kopkelita, ");
INSERT INTO tlf_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","utamapta, weng kafalepke-silip bomi magam uyo bam daa-nalapta, fomtuup utamal o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herot beyo Provins Yuudiya umi kamok king ke-bom-balata, pris ko age tinum amem maak alba bemi win uyo Sekaraya kale, beyo tinum amem Abiya imi man ilop kale minte, imi kalel umi win uyo Elisabet kale, boyo tinum amem Aron imi man ilop no ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kale God imi tiin diim uyo agam bilip imi kuguup uyo tambaliim kup waafuu kwep som-nilip e minte, Bisel God imi weng kwep daasa uyo alugum tambaliim kup waafuu kwep no kesipta kale, ");
INSERT INTO tlf_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elisabet uyo fuun kale, agam iyo man binim nuubipta, tam unang uyo afeganu e minte, tinum usomana no kelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kale Sekaraya bemi tinum miit imi ogok kemin am uyo daanu e, kota bilip iyo no Jerusalam no ulotu am miton kal ogok ke-bilip e, Sekaraya yagal mungkup tam God imi am amem kutam kal pris ko age tinum amem imi ogok uyo kema ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kale tinum amem imi ulaa dugamin umi kuguup uta ku-nilipta, Sekaraya iyo ulaa dulipta, tam God imi am amem tam-nalata, at maak umi dan so kon so uyo fugu-nalata, kwegala kena-bom-nuluta, umi at tum sino tang tambal sino uyo felep tam tamuta, God iyo utam-nalata, deng tebem-nama o age kwegala kenamu ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","At uyo kwega-bom bom-bala e, unang tinum kwiin tagang iyo imi kuguup uyo ku-nilipta, tam ulotu am miton umi abiip mep so kugol mo-bomta beten kemip ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Beten ke-bilip e, God imi ensel iyo tal at dan so at kon so umi kwegagamin umi baan diim umi daang diim ipkuk ilo kugol mola e, ");
INSERT INTO tlf_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekaraya iyo atam-nala e, kwiin kumang mo finana e, ");
INSERT INTO tlf_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ensel iyo Sekaraya imi bogobe-nala e, “Sekaraya kabaa. Kabo finanin ba kale, kapmi beten ke-balap uyo God iyo tolong doba kale, kapmi kalel Elisabet uyo man tinum maak dolan-temu kale, imi win uyo, ‘Jon o,’ agelal a. ");
INSERT INTO tlf_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Dolan-temu uyo, agam ibo aget tem bubul tem tambalanebelu e, deng tebeman-temip e minte, unang tinum kwiin tagang igil deng tebeman-temip no ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Bisel imi tiin diim uyo beyo win tibin ke-nala e, God imi ogok afalik uyo waafuu no kelan-tema kale, iyo sok dum ok so ok mafak sino uyo unan-kalon-temaala ko. Dolan-temu kota, God imi Sinik Tambal iyo tal imi diim kal suun nan-tema kale, ");
INSERT INTO tlf_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Jon ita tebe-nalata, Israel kasel iyo baga-e-balata, kwiin tagang iyo imi aget fugunin uyo fupkela ko-nilipta, Bisel God imi ilak uyo dolan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kale God imi Sinik Tambal iyo tebe-nalata, Jon iyo dong daga-e-balata, imi kuguup sino titil sino uyo God imi profet ko age weng kem baga-emin tinum Elaija imi kuguup sino titil sino ulutap ke isiik Kamogim imi bon tem tinum tal-nalata, aalabal imi kuguup mafak mafak ilimi man imi kupka-emin uyo kupkan kebelata, aalabal imi bubul uyo man imi kobelipta, ulimal iyo abiin tambal tonan-temip kale, God imi weng kwaasulemin tinum iyo dong daga-e-balata, imi aget fugunin mafak so kuguup mafak so uyo kupka-nilip e, aget fugunin tambal sino kuguup tambal sino uta kup waafulip e minte, iyo tebe-nala e, unang tinum iyo Kamogim imi sang uyo baga-e-bom-nala e, bilip imi aget fugunin uyo dong daga-e-bala igil ilimi aget fugunin uyo fupkela ko telela kolip kalaa age-nalata, Kamogim iyo tolon-tema o,” age ensel iyo bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Minte Sekaraya isiik ensel imi bogobela, “Niyo dogobe-nilita, weng boyo utamta, aafen kalaa agon-temi a? Niyo tinum usoman ni e minte, nimi kalel ugol afegan nu no ke-sulup bole o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ensel iyo imi weng uyo mobela, “Niyo God imi ogok kemin tinum miton Gebriel nita kale, God yagal nimdala tal-nilita, God imi weng tambal boyo bogopkelan o age tili kale, ");
INSERT INTO tlf_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","tolong do-salapta. Kabo kamano koyo nimi weng uyo tolong dolin-tem kelap kalaa age-nalata, God iyo tebe kapmi del tem uyo namdapkela kale, weng bagamin binim bom nap kale, bii nimi weng bogopkeli boyo mitam tol felep unu kapmi kalel uyo man dolan-temu kota, kapmi del uyo bam daapkeluta, asok weng uyo bagaman-temap o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kale ensel iyo baga-e-bala bom-bala e, unang tinum iyo Sekaraya imi fen-bom-nilip e, aget fugunolip, “Sekaraya keta intaben umaak mitam tebeluta, intap nu-bomta am amem kutam uyo alba o?” age aget yamyam kup fugunip ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kale kota Sekaraya iyo mitam abiip e tala e, unang tinum iyo utamipta e, weng kabam ke mitam abiip tala kalaa age-nilip e, atamipta e, beyo God imi am amem kutam uyo mufekmufek migik maak utama tap kalaa agelip ko. Kale Sekaraya iyo utamata e, nimi bon tem uyo namdapnelu kalaa age sagaal uta ku-nala unang tinum iyo kafale-bom-nala e, kanubeta o, kanubeta o agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kale Sekaraya iyo ulotu am miton umi ogok kemin uyo binimanu kupkala e, kota agam iyo Jerusalam uyo kupkaa ilimi abiip unip ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kale no siit ilugo-nulu e, kota imi kalel Elisabet uyo afek diim kugol, kumun so keli kalaa age-nulu e, tam am kutam kal bom-bulu bii, kayop ogal koyo binimanu ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Kale kota Elisabet uyo bogolu, “Bisel God iyo ni-filin daa-nalata, nimi fuunan-bom tebesi umi fitom uyo kupkan kepneba kale, kamaa kota unang tinum imi tiin diim uyo fitom binim o,” agelu ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kale Elisabet uyo kumun so ke-bii kayop bugup kal kelu kota, God ilami ensel Gebriel beyo daala no Provins Galili umi abiip maak Nasaret uyo una kale, ");
INSERT INTO tlf_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","unang kapket migilin maak uyo albu kale, boyo King Devit imi man ilop kale, Josep imi win baabelip bo kale, unang bomi win uyo Maria kale, ");
INSERT INTO tlf_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ensel iyo tal bogobe-nala e, “Num nuubap aga? Bisel iyo mufekmufek afalik maak kop-kaman o age-nalata, ulaa kamdu-nalata, kupmi diim kal alba o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria uyo weng boyo tinangku-nuluta, aget afegen uyo fugun-bii-nuluta, “Kanupmin weng bota intaben sang umaak o?” agan-suluta, ");
INSERT INTO tlf_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ensel iyo bogobe-nala e, “Maria kubo finanin ba kale, God iyo kupmi deng uyo tebe-bom-nalata, ulaa kamduba kale, ");
INSERT INTO tlf_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","kubo kumun so ke-nalapta, man maak dolan-temap kale, bemi win uyo Yesus o agelal o ageta kale, ");
INSERT INTO tlf_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","biiluta, beyo kamok kelata, bemi win uyo Atin Win Tibin God imi Man o agan-kalon-temip kale, sugayok uyo man bemi afalik Devit iyo kamok king ke-bii-se kale, kulutap kale, Bisel God iyo tebe-nalata, man besiik ulaa dulata, kamok kelan-tema kale, ");
INSERT INTO tlf_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","beyo tebe-nalata, Jekop imi man ilop ko age Juda kasel kutop ibo suun kup tiin molan-tema kale, bemi tiin molan-tema boyo binimanan-temaalu o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria usiik ensel imi bogobe-nulu e, “Niyo kapket migilin albi koyo, dogobe-nilita, man iyo dolan-temi o?” agelu e, ");
INSERT INTO tlf_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ensel isiik bogobe-nala e, “God imi Sinik Tambal iyo tal kupmi iibak tem iina e minte, Fen Bisel God iyo fomtuup kuntuk mopke no kelan-tema kale, man dolan-temap beyo, ‘Fen tambal e minte, God imi Man no o,’ agan-kalon-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kale kupmi kugulop Elisabet boyo afegansu kuta, mungkup kumun so kebu kale, man tinum maak dolan-temu kale, siin uyo, ‘Boyo fuunansu o,’ agan-nuubip kuta, kumun so ke-bom bii kayop bugup kal kelu kale, ");
INSERT INTO tlf_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","God iyo tii kale, yak alugum mufekmufek boyo kanube-nama o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria usiik bogobe-nulu e, “Niyo Bisel imi bon tem kiit fenin unang kale, mufekmufek sang ko bagane-balap boyo felebelu kale, kopne-nama o,” agelu e bole, ensel iyo kupkaa daagina ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Maria uyo yuut mufekmufek uyo telela kulep-nulu e, daage tam Provins Yuudiya umi amdu tem abiip maak kutam iinu ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kale no abe daage tam Sekaraya imi am tam-nulu e, Elisabet uyo weng umobelu e, ");
INSERT INTO tlf_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabet uyo tinangkulu e, kota man unaak umi mat tem alba iyo fomtuup ogen kuso kupku mola e, kota God imi Sinik Tambal ita God imi weng uyo Elisabet umi kobelata, ");
INSERT INTO tlf_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","fomtuup Maria umi bogobelu ko. “Bisel imi dong dagakemin kopkeba uyo unang alugum imi dong daga-em-nuuba kulutap ba kale, kupmi dong dogopkeba boyo afaligen e minte, yak man kupmi mat tem alba beyo Bisel imi dong daga-emin uyo bemi kobe no keba ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kwiin ee. Niyo win binim kale ki, kupta Kamogim imi ogen kelan-temap kale, intaben o ageta nimi finang uyo talap a? ");
INSERT INTO tlf_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kupmi weng umopnelap tinangkuli kota, nimi man mat tem kek alba iyo tinangku-nalata, deng tebe-bom fomtuup ogen niso nimku molata, atami kale, ");
INSERT INTO tlf_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","tambal kale, Maria kubo, aafen Bisel imi weng kwep daaba uyo dam kalaa agelap kale, kota Bisel imi weng kwep daaba uyo kopkela utaman-temap o,” age Elisabet uyo tebe ");
INSERT INTO tlf_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria uyo aseng kwaa-bom bogo-nulu e, “Nimi aget tem uyo deng afek tebepnelu kale, Bisel imi tok uyo bagaman o ageta kale, ");
INSERT INTO tlf_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","God beyo nimi ilim bomin tinum kale, nimi bubul tem deng kup tebepnelu uyo ");
INSERT INTO tlf_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","dok uta ba kale, niyo win binim kuta, God yagal nimi aget uyo fugun daa-nalata, ulaa nimdu-se kale, kaa tam tam tubup koyo alugum unang tinum sino man sino iyo utamipta e, God iyo mufekmufek tambal maak kopneba kalaa age-nilipta, God imi tok uyo baga-bom imi win uyo kufu-eman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","God ita titil miit kayaak kale, imi titil uta ku-nalata, dong daganemin kwiin kiim uyo kopneba kale, utamita e, God beyo atin tambaliim, titil afek uyo bemi diim kal albu kalaa age-nilita, imi tok uyo bagaman o agan-bii ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Dok ita God imi deng tebe-bom imi weng uyo waafulip umdii, God iyo bilip iyo i-filinin kup ke-bom-nala e minte, imi man ilop tiilam tibip kutop iyo i-filinin uyo kanupmin kup keman-tema ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kale minte tam God imi titil kiim uta ku-nalata, unang tinum God imi weng tinangkamin binim, weng kwaasulemin iyo fot tebelata, yuut bilii daagin-silip ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","God iyo tebe-nala e, kafin diim komi tinum win sino iyo imdaak tama-nala e minte, kafin diim komi win binim tinum ita imdep tam isal katop daa no kem tebesa ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kale God iyo tebe-nala e, tinum mufekmufek duumatanin bilip imi men tem uyo mufekmufek uta kup dongenu kupkabe-nala e minte, tinum win tibin ke mufekmufek so kasel bilip imi men tem uta bisop imkaa no kem tebesa ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Kale sugamiyok uyo God iyo numi olal iyo bogobe-nala e, ‘Niyo dong daga-eman-temi o,’ age-nala e minte, asok Abraham isino minte imi man ilop sino iyo bogobe-nala e, ‘Niyo alugum ibo suun kup kutop kutop unu uyo dong daga-eman-temi o,’ age-nalata, imi weng kwep daasa uyo ilumanosaala kale, aget fuguno-nalata, imi bon tem kiit fenin unang tinum Israel kasel nuyo i-filin daa-nalata, suun kup dong daga-em tebesa o,” age-nuluta, Maria uyo aseng uyo kwaamu ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria uyo Elisabet so afaat bii kayop asuno koyo binimanuta, kupkaa ulumi abiip unu ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Siit ilugo-nulu e, kota Elisabet uyo man fugula e, kota man tinum iyo dolu e, ");
INSERT INTO tlf_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Elisabet ulumi abiip kasel so duup-afin so iyo tolong dolipta, Bisel iyo atin ku-filin daa-nala e, man tinum dopma kalaa age-nilip e, usino deng afaligen uyo tebemip ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kale man unaak iyo dolu bii, am ifaan diim kota aalabal iyo dagaa kulep tal man unaak imi kaal uyo ugaa dupkan kebe-nulupta o age-nilip e, ninggil iyo tal-nilip e, “Nulumi kuguup uyo ku-nulupta, ilami aalap win Sekaraya uta bogobelum o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ogen uyo, “Waago o,” age-nulu e, “Imi win uyo, ‘Jon o,’ age bogopmum o,” agelu ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Minte aalabal iyo bogolip, “Kuta agam ipmi ilo iyo kanupmin win boyo binim o,” age-nilip e, ");
INSERT INTO tlf_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","utamipta e, aalap iyo weng baga-emin binim kalaa age-nilip e, ilimi sagaal tuup kafale-bom-nilip e, Sekaraya iyo dagalip, “Kapmi man unaak bemi win uyo intapnak o agelan-temup o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sekaraya isiik sagaal ku kafalebe-nala e, bogola ko. “Dolmin umi mufekmufek umaak kopnelipta, dolalan o,” agela kopmip e, “Man bemi win uyo Jon o,” age dola kola e, aalabal iyo kumang mo aget fugunip ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kota Sekaraya imi bon tem uyo maak fagalin tap baabelu e, imi fong uyo bam daabe no kelu e, kota tam God imi win uyo kufu-e-bom deng afalik kup tebe-bom no kema ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kale ilami abiip kasel sino duup-afin sino iyo finan-bom kemip e, weng en yak abiip maak maak kelu e, Provins Yuudiya umi amdu tem kasel iyo alugum ");
INSERT INTO tlf_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","tinangku-nilip e, utamipta, man iyo fitin tal-bala e, God imi om kun uyo isino albu kalaa age-nilipta, aget afaligen uyo fugun-bom-nilip e, bogolip, “Son-temu nala man bemi mitam fitolan-tema uyo, dogonupmin tinum iyo maak mitam tebelan-tema tap o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","God imi Sinik Tambal iyo tebe Jon imi aalap Sekaraya iyo tele tiin molata, Sekaraya yagal tebe God imi weng kem uyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Kalo. Nuyo Israel kasel nulumi Bisel God imi tok uyo bagamum a. Kale yagal tal ilami unang tinum nuyo dong dogobe-nala e minte, sok uyo talaa imdaa no kelata, nuyo kaal binim keta nuubup ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","God yagal ilami bon tem kiit fenin tinum Devit imi man ilop maak ita ulaa du-nalata, ‘Beta daali unon-tema o,’ age-se kale, beyo ilami titil kiim uta kup ku-nalata, talaa imdala nuyo kaal binim kelan-temup ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Sugamiyok uyo God iyo tebe tinum maak maak iyo ulaa imdulata, ilami profet ko age weng kem baga-emin tinum kelipta, ilami weng uyo kwep daabelata, unang tinum imi bogobe-nilip e, ");
INSERT INTO tlf_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","‘God iyo numi kaltem kebe-nala, “Ipmi waasi sino tinum ipmi bon dii-emip so iyo tebe, ibo ifak dagamum o agan-kalon-temip kuta, nagal kanupmin tinum bilip imi sagaal diim albip ibo imkan ke imdep meng daali nalami kup kelan-temip o,” age God iyo kaltem kebesa o,’ age God imi profet iyo tebe unang tinum iyo baga-emsip ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Kale God iyo numi olal iyo bogobe-nala e, ‘Ipmi i-filin daa-nilita, nalami weng ipmi kwep daabeli bomi aget uta fugun-bom-nilita, waafulan-temi o,’ agesa kale, ");
INSERT INTO tlf_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ulutap kale, God iyo numi afalik Abraham so e minte ilami man ilop nuso nuyo fomtuup weng kwep daa bogobe-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","‘Niyo, ibo nimi ilak uyo duga-bom finanin binim kemin o age-nilita, nagal ipmi waasi imi sagaal diim albip ibo imkan ke imdep meng nalami miit tem uyo daalan-temi kale, ");
INSERT INTO tlf_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","kafin diim kaa bom suun nip uyo, ibo tol kup bom-nilip e, nimi tiin diim kal kuguup tambal uta kup waafuu kwep tebe-bilipta o age-nilita, ulaa imdep meng daalan-temi o,’ age God iyo Abraham so ilami man ilop nuso numi baga-emsa o,” age Sekaraya iyo bogo-nala e minte, ");
INSERT INTO tlf_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","man unaak Jon imi bogopma, “Man unaak kabaa. Biilu uyo Atin Win Tibin God iyo bogopke-nala, ‘Kabo nimi profet ko age weng kem baga-emin tinum o,’ agelan-tema kale, kapta kapsiik Kamogim ilami bon tem abe-bom ilami ilep uyo telela kobelapta, tolon-tema kale, ");
INSERT INTO tlf_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","kapkal imi unang tinum iyo afeta ko bogobe-nalap e, ‘God yagal ipmi yuum boyo kupkabe-nalata, telela imolan-tema o,’ agan-bom-nalapta, baga-eman-temap ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","God imi aget aa bubul aa uyo alugum numi kobe-nala e minte, i-filin daa no ke-nalata, utamata e, numi aget fugunin uyo mililanebelu e minte, nuyo kaanamin umi atul uta finan-bom no kem-nuubup kalaa age-nalata, yagal tinum maak iit abiil tigiin kal isino nin iyo ulaa du-nalata, daala tolon-tema kale, imi tolon-tema uyo kutim ataan dubom mitop segela unu tulu ke-nulu kefobu ulutap kale, numi aget fugunin uyo bam daa imo-nala e, mililanbu uyo kefobe-nala e, yagal bilili age-bom dukmenin kuguup uta kup kafalebela kanuman-temup o,” age-nalata, Sekaraya iyo weng kem baga-e-bom-nalata, aseng uyo kwaama ko. ");
INSERT INTO tlf_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kale biilu man unaak beyo fitin tal-bom-nala e minte, ilami dam so sinik so uyo titilanebelu e, iibaan kugol bom-bala bii, ilami ogok kemin umi am uyo daanu kalaa age-nalata, kota tal kem diim tal-nalata, Israel kasel iyo kafalema ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kale Jon imi do-suu kota, King Ogastus iyo tebe ulo maak kobe ilami kiyabal iyo bogobe-nala e, “Ibo no-nilip alugum nimi unang tinum tiin mo-sii imi win uyo dolebelin o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kale boyo kamaki win dolebe-silip uta kale, Kwirinius iyo Provins Siria bomi kiyap ke-bom-balata, win uyo dolebe-silip ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kale alugum unang tinum iyo no, bogopmup numi win uyo dolepmak o age-nilipta, kupkaa ilimi abiip miton unip ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kale Josep iyo King Devit imi man ilop kale, Provins Galili umi abiip maak Nasaret kugol nuuba uyo kupkaa daage no ilami abiip miton ko age imi afalik Devit imi abiip una kale, abiip boyo Betleam o agan-nuubip kale, Provins Yuudiya kugol albu ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Kale Josep iso ilami kalel Maria uso agam iyo no, bogopmup numi win uyo dolepmak o age-nilipta, unip kale, Maria uyo kumun so kale, ");
INSERT INTO tlf_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","agam iyo no kugol bom-nilip e, Maria uyo kota man iyo fugula kalaa agelu kuta, ");
INSERT INTO tlf_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","utamipta, fital imi tal somip nala unemin am uyo unang tinum tebe alugum bugulip kalaa age-nilipta, agam iyo kong kao imi am kutam kal bom-nilipta, Maria umi man diil iyo do-nulu e, ilim ku falala do dep daak kong kao imi iman unan-kalin ilaat tem kulaak daalu ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kale mililep kota sipsip tiin molin tinum maak abiip bomi mep so tiginal kugol bom-nilipta, ilimi sipsip iyo tiin mo-bom-silipta, ");
INSERT INTO tlf_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Bisel God imi ensel maak tal-balata, Bisel imi yogon afaligen maak uyo imi diim uyo kefo ilagenu utam-nilipta, bamban keng keng bom finan-bilipta, ");
INSERT INTO tlf_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ensel iyo bogobe-nala e, “Ibaa. Finanin ba kale, niyo God imi weng tambal uta kwep talan-bii kuba. Kale boyo kanubeluta, alugum unang tinum iyo deng kup tebeman-temip kale, ");
INSERT INTO tlf_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","am daanbu kota, mep yang King Devit imi abiip kugol unang maak uyo man dolu kale, man beyo ipmi telela imkamin tinum e minte God imi ulaa dula kamok kesa tinum e minte Kamogim no ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kale kamano kota ibo no beyo fen-bom atamipta, ogen uyo man beyo ilim ku falala do dep daak kong kao imi iman unan-kalin ilaat tem kulaak daalu alba kalaa agelip umdii, ibo, beta kalaa agon-temip o,” age-nalata, ");
INSERT INTO tlf_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ensel iyo kam agan-kalata, maak fagalin tap abiil tigiin kasel ensel kwiin tagang iyo tal tamipta, iso ninggil iyo bom-nilipta, God imi tok uyo bogo-nilip e, ");
INSERT INTO tlf_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Boyo unang tinum iyo iit abiil tigiin kayaak God imi tok uyo bagaman-temip kale, God iyo tebe tinum maak kafin diim kagal albip imi bet bubul kobelata, bilip imi aget tem uyo bilili agebeluta, nan-temip o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kale ensel iyo imkaa tam abiil tigiin unip e, sipsip tiin molin tinum iyo bogobina tala kem-siit-nilip e, “Kalo. Unipta, ninggil yangta Betleam uyo mufekmufek migik maak mitam tulu Bisel tebe numi kafalepma boyo nota utamum o,” age-nilipta, ");
INSERT INTO tlf_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","yuut daage no fen te yang abomu, ogen Maria so Josep so iyo bom-bilipta, kong kao imi iman unan-kalin ilaat tem kulagal man iyo agaal unba kalaa agelip kale, ");
INSERT INTO tlf_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","atam-nilip e, ninggil iyo ensel tebe tal man bemi sang bogobina uyo unang tinum iyo baga-em tiine-bilipta, ");
INSERT INTO tlf_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","alugum tinangkamip bilip iyo sipsip tiin molin tinum tebe bogobelip bomi aget yamyam uyo tagamip kuta, ");
INSERT INTO tlf_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria uyo bilip imi weng boyo alugum tinangku kwep yak dubom tem daa-nuluta, aget yamyam kup fugun-bom nu ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kale sipsip tiin molin tinum bilip iyo asok kupkaa abe-bom-nilipta, God imi tok uyo baga-bom-nilip e, alugum ilimi tolong dolip so atamip so bomi aget uyo fugunolipta e, ensel imi weng bogobebip boyo tol mitam tulu kalaa age-nilipta, God imi mufekmufek migik maak kafalepma utamip umi deng kup tebemip ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Am ban kal koyo binimanu e, man unaak imi kaal ugaa dupkan ke-emin umi am uyo daanu e, kota man bemi win uyo Yesus o age amalap iyo bogobelip kale, win boyo siin ogen umi kumun so kelin-tem bom-sulu ensel imi bogobe-se uta ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Amalap iyo atamipta e, kayop maagup uyo kelu ogen umi ifin am binimanu man delep mitam kaamin am ko age Moses imi ulo kwep daasa uyo daanu kalaa age-nilipta, man iyo duptamo no Jerusalam kal Bisel imi dopmum o age dep unip ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kale Bisel imi weng kwep daala Moses tebe suuk kon tem dola kosa uyo bogo-nulu e, “Alugum man tinum diil iyo yak Bisel imi dupka-emin o,” age-nulu e minte, ");
INSERT INTO tlf_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","“Am delep mitam kaamin am daanuta, uun abim alop min, abim bulbul kamaa uun alop yaafuu kulep tal Bisel imi kupka-emin o,” age no kesu kale, kanum unip ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kale kota abiip Jerusalam kayaak maak imi win uyo Simeon kale, beyo tinum tambal e minte, God imi ilak kup duga-bom God imi kuguup waafu-bom kemin tinum kale, beyo bomta, God iyo Israel kasel imi iluum uyo kupkan kepma kalaa agelan o age fen-nuuba kale, God imi Sinik Tambal iyo isino bom-nala ");
INSERT INTO tlf_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","bogobe-nala e, “Dam kale, kabo kaanin-tem bom-salapta, Bisel imi weng kwep daa-nala, ‘Nimi ulaa duli kamok kesa tinum iyo daapmi no tolon-tema o,’ agesa iyo talata, atam-nalapta, kaanan-temap o,” age-se ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kale Simeon iyo God imi Sinik tebe duptamo ulotu am miton daala bom-balata, Yesus imi amalap iyo man iyo duptamo tam ulotu am miton kal ulo kwep daasa uyo waafu-nulupta, man iyo Bisel imi dobelum o age dep tam daalip e, ");
INSERT INTO tlf_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon ita man iyo du-migi-nala e, God iyo, “Suguul o,” age-nala e, bogola ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Kota Bisel kapmi weng kwep daasap uyo kagal mitam tebelu utami kale, kapmi bon tem kiit fenin man niyo deng tebeli kale, nimkalap kaanan o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Numi ilim bolan-tema tinum keyo kemana nalami tiin tuluun atami kale, ");
INSERT INTO tlf_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","keta alugum unang tinum iyo atamin o ageta ulaa du daalap talba kale, ");
INSERT INTO tlf_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","keyo yogon dong ilatap kale, Israel kasel imi aget fugunin uta kup ba kale, unang tinum asit kek kek imi aget tem uyo kefobe bam daa imolata, kapmi tuluun weng uyo dagaa kulan-temip e minte, iyo kalapmi unang tinum Israel kasel iyo imdep meng kapmi miit tem tola nan-temip o,” age Simeon iyo kam agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeon iyo Yesus imi sang uyo God imi baga-e-balata, aalap ogen iyo kumang mo aget yamyam fugunip ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Kota Simeon iyo God imi daga-nala e, “Ulimal iyo tambaliim kup dong daga-emal o,” age-nala e minte, Yesus imi ogen Maria bogopma, “Kubaa. Tolong dolal a. God iyo man keyo ulaa du daalata, tal abeba kuta, Israel unang tinum kwiin tagang iyo imi weng uyo tolong dugamin binim ke-bom God imi ilep uyo kupkaa yang iine-bom ilimi yuum tem diinaman-temip minte, Israel unang tinum migik kwiin tagang ita imi weng uyo tolong duga-bom tinangka-bilipta, yagal telela imo-nalata, imtamo ilami abiip unon-tema ko. Kale God yagal daala tal-nala unang tinum iyo kafalebela, dogonupmin kuguup uyo God imi tiin diim uyo tambaliim kalaa agelan-temip kuta, unang tinum kwiin tagang iyo baga-bom-nilip e, ‘Umbae. Kanupmin kuguup kafale-be boyo tambal ba o,’ agelan-temip kale, ");
INSERT INTO tlf_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","boyo kek kek iyo utamipta e, kulip iyo aget mafak fugun-bilip kalaa agelan-temip ko. Kale son-temu nala kupmi man imi kuguup kanu-eman-temip uyo sagam daang kangkalu atul tebebu ulutap ke kupmi bubul tem uyo iluum tebepkelan-temu o,” age Simeon iyo Maria umi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","God imi profet ko age weng kem baga-emin unang Ana uyo kulbu kale, Ana umi aalap Fanuel iyo Asa imi miit kayaak tinum kale, Ana uyo unang amaat bom tinum digin ke-bii, atol ulumi kup ban kal binimanu e, ");
INSERT INTO tlf_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","imak iyo kaana e, ulusinon kaluun nuubuta, atol ulumi kup 84 uyo binimanu e, kota afeganu ko. Kale Ana uyo suun tal ulotu am miton tele-bom-nulu e, taap so mililep so uyo kugol bom-nulu e, God imi ilak uyo fom duga-bom beten ke-bom ke-bomu ko. Kale am iip maak maak uyo iman uyo unan-kalin ba kupkaa no ulotu am miton no-nulu e, beten uta kup kemin kup ke-bomu ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kale Simeon iyo Yesus imi sang uyo ogen aalap imi baga-e-balata, Ana ugol tal ulotu am tal abomu, man iyo alba kalaa age-nulu e, atamuta e, beta kalaa age-nulu e, God iyo, “Misam o,” agan-kulu ko. Kale Jerusalam kasel iip maak maak iyo God imi fen-bomta, yagal tal-nalata, numi waasi imi sok uyo tiila imola nugol kup kelum o age-nilip e, God imi fen-bomip kale, Ana uyo alugum bogobelu, “Ibaa. Man keyo ipmi fen tebesip ita kuba,” agelu ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kale Josep sino kalel Maria sino ulimal iyo Bisel imi weng kwep daasa ko age kayop maagup kelu ogen umi ifin am binimanu man delep mitam am tem telemin umi kuguup uyo alugum waafulip binimanu e, ulimal iyo Jerusalam uyo kupkaa, asok nulumi abiip unum o age-nilipta, Provins Galili umi abiip Nasaret unip ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kale man iyo fito-nala e, alaang tebe-nala e, atin aget fugunin tambal uyo ku no kela e, God iyo tiin mo-bom bet bubul kobela ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Atol maagup maagup kwek uyo Yesus imi ogen so aalap so ulimal iyo, God imi ifin am ko age Pasova iman unan-kalin am uyo, daanan o angbu kalaa age-nilipta, no Jerusalam kugol une tal tal kem-nuubipta, ");
INSERT INTO tlf_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesus imi atol uyo te tam tuluun kal kelu e, Pasova bomi am uyo daanu e, kota asok imi Pasova kuguup uyo waafulum o ageta Jerusalam unip ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kota Pasova umi am uyo binimanu e, asok unum o agelip ko. Kuta minte man tinum Yesus iyo Jerusalam kal bom-balata, amalap iyo unip kuta, Yesus iyo Jerusalam kal alba kalaa agebaalip kale, ");
INSERT INTO tlf_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","iyo bo ki, ipkumal so talan-be ko age abe-bilip bii, am kwiin kolu e, kota imi duup diim sino igalak diim sino uyo ugagan tiinan-biita, ");
INSERT INTO tlf_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","man tinum Yesus iyo atamin-tem kelup kalaa age-nilipta, asok fen Jerusalam unip ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kale fen-bii am alop ke-nilip e, am asuno diim kota fen no abomu, Bei. Man Yesus iyo te ulotu am miton kal bom God imi ulo kafalemin tinum imi iibak tem kal ton-bom-nala e, imi weng uyo tinangka-bom-nala e, dagaga-bom no ke-balata, ");
INSERT INTO tlf_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","alugum tinum Yesus imi weng tinangkan-bilip iyo utamipta, imi aget fugunin sino kafalemin imi weng yan ke-e-be sino uyo migik kalaa age-nilip e, kumang saan-bilip kalaa ageta ogen aalap iyo fen no atamip ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kale ogen aalap igil atam kumang mo-nilip e, ogen uyo bogobelu ko. “Nimi man kabo, dogonubelan o age-nalapta, kogen kaalap nuyo imkaa talta kagal albap a? Kogen kaalap nuyo fen-biita, katamin-tem kelup kalaa age aget iluum tebebeluta, fen tebebup o,” agelu ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesus iyo ogen agam imi weng uyo mobela ko. “Intaben o ageta niyo fen tiinan albip a? Ibo nitamipta, iyo ilami Aalap God imi ulotu am miton kutam kal alba kalaa nagebaalip aga o?” agela kuta, ");
INSERT INTO tlf_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ogen aalap iyo imi weng boyo bam daalin-tem kelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kale Yesus iyo asok ogen aalap isino daage abiip Nasaret unip ko. No bom-nala e, ogen aalap imi weng kup tinangku bilili age-bala e, ogen ugol intap intap tal imi diim aban-bo uyo aget fugun-bom-nulu e, ulumi aget tem kal kubaget daga-bom kemu ko. ");
INSERT INTO tlf_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Kale Yesus iyo fito-nala e, imi aget fugunin uyo bam daa tambalanepmu e, kota unang tinum so e minte God so iyo imi deng uyo tebemip ko. ");
INSERT INTO tlf_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Taiberius iyo Rom kasel imi king ke-bii atol te tam mit kaa fogo te yak tiin milii fogo (15) kela e, Pontius Pailat yagal Provins Yuudiya umi tiin molin kela e, Herot yagal Provins Galili umi tiin molin kela e, Herot imi fik Filip yagal Provins Ituria sino Provins Trakonitis sino umi tiin molin kela e, Lisanias yagal Provins Abilene umi tiin molin kela e minte, ");
INSERT INTO tlf_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","alol Anas sino ilami muuliim Kayafas sino umdim iyo Juda kasel imi tinum amem ko age pris imi kamogimal miton kelip no kale, kota Sekaraya imi man Jon iyo tinum binim iibaan kugol bom-balata, God iyo Jon ulaa du bogobe-nala e, “Nimi weng uyo kwep no unang tinum imi baga-emal o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jon iyo daage no alugum abiip maak maak ok Jodan baang kutam iyo God imi weng uyo baga-e-bom-nala e, “Fupkela ipmi fengmin uyo kupka-nilip meng ok sam ugolipta, God iyo ipmi fengmin uyo kupkan kebela binimanuk o,” agan-bom baga-ema kale, ");
INSERT INTO tlf_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ulutap mungkup God imi profet Aisaya iyo sugayok suuk kon tem dola ko bogo-nala e, “Tinum maak iibaan kugol ol-bom bogo-nala e, ‘Ilep tambal umaak telelamipta, Kamogim iyo yuut talak o ageta kale, ");
INSERT INTO tlf_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","alugum iluung degep daak unan un-suu uyo kafin kulu-nilip itolip mitam tulu e minte, alugum muk kun sino amdu so uyo belela-nilip ifi-nilip e minte, ilep dagal dagal uyo telelalip tolanu e minte, ilep mafak tuum tem ilep uyo telelalip tambalan no keluta, ");
INSERT INTO tlf_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","God imi tinum ulaa dula iyo talata, alugum unang tinum iyo atamipta, numi ilim bolan-tema tinum iyo kulba kalaa agelan-temip o,’ age-nala e, tinum beyo felep yak aget telelamin umi diim to fomtuup weng boyo baga-e-be o,” age Aisaya iyo bogosa ko. ");
INSERT INTO tlf_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Unang tinum kwiin tagang iyo, tal tamupta, Jon ita ok sam ugobelak o age-nilipta, imi finang uyo tala tala ke-bilip kuta, Jon iyo utamata e, imi aget uyo fupkela kolin-tem ke tilip kalaa age-nalata, bogobela, “Ibaa. God iyo tebe ipmi kuguup mafak umi kalan uta ifak daalan-tema kale, ibo aget fuguno-nilip e, no tamup Jon imi ok sam ugobelan-tema uta, God tebe numi kaal fuyap kopman-tema uyo uk kugan imolan-temu ko ageta talan-bom-nilip e minte, ibo inap imi baam atul finano bilii unan-nuubip ulutap ke-nilipta, nimi finang talan-bom no ke-bilip kuta, boyo ibo uk kugan imolan-temaalu binim kuba. ");
INSERT INTO tlf_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kuguup tambal uta ke-bilipta, boyo utamita e, ipmi aget uyo fupkela ko-nilipta, ipmi kuguup mafak uyo kupkabip kalaa age utaman o ageta ko. Kale ibo nimi weng kaa bogobelan-temi koyo tinangku-silipta. Ibo, ‘Nuta Abraham imi man ilop o,’ age deng taban-bilip kuta, kanube God iyo, Abraham imi man ilop kemin boyo miton o agan-be nimnam, God beyo tii kale, daak tuum boyo kulu-nala telela imola mitam tinum ke-nilipta, igil mungkup Abraham imi man ilop kwiin tagang kelan agin kuta, God imi tiin diim uyo Abraham imi man ilop kemin boyo fen katip kalaa agesa ko. Kale ibo bogo-nilip, ‘Abraham beyo numi afalik kale, God iyo bemi tolop o age-nalata, nuyo telela imola tambaliim nan-temup o,’ agan-kalin ba kale, ipkil God imi ilak uyo duga-bilipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kale God iyo, at uyo doman o age-nalata, at miit tem kal kaabak uyo waafuu fiko kola kale, at alugum dogap uta at dum tambal abulin binim kesu uyo ano duula-nalata, at kwegala ken tebelan-temu ko. Ulutap kale, ibo kuguup tambal uyo waafulin binim kelan-temip uyo, God tebe imkan kelan-tema o,” age Jon iyo unang tinum imi baga-ema e, ");
INSERT INTO tlf_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","iyo daga-nilip e, “Kuta nuyo, ‘Intaben nu-bilipta o,’ agan-balap o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jon iyo bogola, “Dogap kapta siyot alop sino umdii, maak uyo ku tinum maak bisop alba bemi kobelal a. Minte dogap kapta iman sino umdii, taga-e-bomta o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kale tam takis mani kwaamin tinum bilip iyo, tal tamup Jon ita ok sam ugobelak o age-nilip e, tal Jon iyo dagalip ko. “God imi weng kafalemin kabaa. Nuyo, ‘Intaben nu-bilipta o,’ agan-balap o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","iyo bogobe-nala e, “Ibo mani kwiin tagang uyo kwaamin ba kale, gavman imi weng kwep daa-nilip, ‘Kanupmin kal o,’ agebip bota kup kulugamin o,” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","tam waasi dinan-kalin tinum bilip igil asok Jon daga-nilip e, “Minte nule a? Nuyo, ‘Intaben nu-bilipta o,’ agan-balap o?” agelip e, Jon iyo bogobela, “Ibo unang tinum iyo finanin weng uyo bogobe-nilip e, ‘Kangkolan-temup min, kamdep no weng telelmin tinum imi diim daa bisop weng bogobelupta, de kamolan-temip o,’ agelipta, ipmi atul uyo finan-bom-nilipta, bilip imi mani uyo ibo kupka-em-nuubip ko. Kale kanumin boyo kupka-nilipta, ilipmi ogok kemin umi tisol uta kup kulu-nilipta, maak sino kwaamin ba o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tam unang tinum iyo Jon imi kuguup kanubela uyo utam-nilip e, bubul kup milip age-nilip e, Jon bemi aget yamyam fugun-bom-nilip e, “Beyo God imi tinum, ‘Ulaa duli kamok kesata, daali tolon-tema o,’ agesa ita tap o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tam Jon iyo alugum imi bogobe-nala e, “Ipmi, tinum tolon-tema o age fen-bilip iyo naga ba kale, beyo kamok miton kale, ita ita ke niyo kubagani nimkasa kalaa age-nilita, fitom tebepnebu kale, niyo fen tinum kale, niyo bagang-kale yang bemi miit tem uyo yang-nilita, imi yaan ilom sok uyo tiila kopmomi binim ko. Kale niyo ok uta ku-nilita, ibo ok sam uga-e-bii kuta, tinum tolon-tema bemi ok sam uga-eman-tema boyo fen ok ba kale, ilami Sinik Tambal ita daala tebe-nalata, ipmi iibak tem aget mafak fugunin uyo at kwegabela ken tebeluta, ibo atin tambalanan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tam tinum imi sagam ku rais ko age wiit uyo bo-bii kulep tal to-nilip e, telela-bii, umi kaal uyo kugan ke-nilip e, wiit dam uta kup kulep tam am to-nilip e minte, kaal uta abulalip ken tebe-bom no kemin ko. Kale mungkup ulutap kale, tam tinum tolon-tema beyo unang tinum iyo ilo ko-nilita o age-nalata, ilami ilak dosip iyo afeta ko kulep no ilami abiip to-nala e minte, unang tinum imi ilak dolin binim ita at tenogamin binim, kenamin kup bomu umi tem kugol abulala ken tebeman-temip o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Tam Jon iyo kanube baga-e-be kota, God imi weng tambal uyo baga-e-bom-nala e, unang tinum imi bubul uyo kufu-e-balata, imi bubul aa aget aa uyo fupkelalin o ageta baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Herot beyo Provins Galili kutam imi kamok king kale, ilami imdalim iyo kaanin-tem bom-salata, tebe-nala e, imdalim kalel Herodias uyo tagaa kube-nala e minte, kuguup mafak mafak kwiin tagang uyo ke-bom no kem-nuubata, tam Jon iyo Herot imi kuguup mafak uyo kanuma kalaa age-nalata, an-togon daa yege-balata, tam Herot iyo olsak tebebelu e, ");
INSERT INTO tlf_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","asok kuguup mafak maak ke-nala e, imi un tubulin iyo bogobelata, talta Jon iyo sok de do dep no kalabus am daalip bii-se ko. ");
INSERT INTO tlf_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jon iyo sok de dolin-tem bom-silipta, unang tinum kwiin tagang iyo alugum tal Jon imi diim tamip e, Jon ita ok sam uga-e-bom bom-balata, Yesus iyo aaltam tal atam-nala e, Jon imi bogobe-nala e, “Ok sam ugopne o,” agelata, Jon iyo tebe Yesus ok sam ugobelata, Yesus iyo beten kem-salata, abiil tigiin uyo tem kalo kolu e, ");
INSERT INTO tlf_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","God imi Sinik Tambal iyo uun abim umi dam ulutap ke-nalata, Yesus imi diim abela e, abiil tigiin kwiit ilota God imi weng kwaala tulu kwek uyo bogo-nala e, “Kabo nimi Man bubul kale, niyo kapmi deng kup taban-bii o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesus iyo bii atol ulumi kup 30 umaak ke-nalata, kota imi ogok kufo-nala e, ogok kemsa ko. Alugum unang tinum iyo, “Yesus iyo Josep ilami man ko,” agan-nuubip kuta, God ilami Man kale, Josep iyo Heli imi man e minte, ");
INSERT INTO tlf_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli iyo Matat imi man, Matat iyo Livai imi man, Livai iyo Melki imi man, Melki iyo Janai imi man, Janai iyo asegim Josep imi man, ");
INSERT INTO tlf_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep iyo Matatias imi man, Matatias iyo Amos imi man, Amos iyo Naham imi man, Naham iyo Esli imi man, Esli iyo Nagai imi man, ");
INSERT INTO tlf_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai iyo Mat imi man, Mat iyo asegim Matatias imi man, Matatias iyo Semen imi man, Semen iyo Josek imi man, Josek iyo Joda imi man, ");
INSERT INTO tlf_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda iyo Joanan imi man, Joanan iyo Resa imi man, Resa iyo Serubabel imi man, Serubabel iyo Sealtiel imi man, Sealtiel iyo Neri imi man, ");
INSERT INTO tlf_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri iyo asegim Melki imi man, Melki iyo Adi imi man, Adi iyo Kosam imi man, Kosam iyo Elmadam imi man, Elmadam iyo El imi man, ");
INSERT INTO tlf_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","El iyo Josua imi man, Josua iyo Eliesa imi man, Eliesa iyo Jorim imi man, Jorim iyo asegim Matat imi man, Matat iyo asegim Livai imi man, ");
INSERT INTO tlf_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai iyo asegim Simeon imi man, Simeon iyo asegim Juda imi man, Juda iyo asegim Josep imi man, Josep iyo Jonam imi man, Jonam iyo Eliakim imi man, ");
INSERT INTO tlf_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim iyo Melea imi man, Melea iyo Mena imi man, Mena iyo Matata imi man, Matata iyo Natan imi man, Natan iyo Devit imi man, ");
INSERT INTO tlf_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit iyo Jesi imi man, Jesi iyo Obet imi man, Obet iyo Boas imi man, Boas iyo Salmon imi man, Salmon iyo Nason imi man, ");
INSERT INTO tlf_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason iyo Aminadap imi man, Aminadap iyo Atmin imi man, Atmin iyo Ani imi man, Ani iyo Hesron imi man, Hesron iyo Peres imi man, Peres iyo Juda imi man, ");
INSERT INTO tlf_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda iyo Jekop imi man, Jekop iyo Aisak imi man, Aisak iyo Abraham imi man, Abraham iyo Tera imi man, Tera iyo Naho imi man, ");
INSERT INTO tlf_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naho iyo Seruk imi man, Seruk iyo Reu imi man, Reu iyo Pelek imi man, Pelek iyo Ebe imi man, Ebe iyo Sela imi man, ");
INSERT INTO tlf_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela iyo Kainan imi man, Kainan iyo Apaksat imi man, Apaksat iyo Siem imi man, Siem iyo Noa imi man, Noa iyo Lamek imi man, ");
INSERT INTO tlf_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek iyo Metusela imi man, Metusela iyo Enok imi man, Enok iyo Jaret imi man, Jaret iyo Mahalalel imi man, Mahalalel iyo asegim Kainan imi man, ");
INSERT INTO tlf_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainan iyo Enos imi man, Enos iyo Set imi man, Set iyo Adam imi man e minte, Adam ita God imi man no ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","God imi Sinik Tambal iyo Yesus isino nin kup boma soma kale, Yesus iyo Jodan Biil kupkaa daage abe-bala e, Sinik tebe dep tinum binim iibaan una ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yesus iyo iibaan kugol bom-bala e, Saatan iyo, Yesus dup-kugulita, kuguup mafak umaak kanubela kalaa agon o age-nala e, dup-kugum yakyak kema ko. Saatan tebe Yesus kanu-e-bala e, Yesus iyo iman umaak une-nama binim ke-bom-bala bii, am ulumi kup 40 kela koyo, iman tep tebepmu kale, ");
INSERT INTO tlf_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Saatan iyo Yesus imi bogobe-nala e, “Kabo fen tuluun God imi Man umdii, daak tuum boyo kulu fupkela kolap bret kelu unelap katamita, kabo fen God imi Man kalaa agelan o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","tam Yesus isiik bogopma, “Umbae. God imi suuk kon tem weng uyo bogo-nulu e, ‘Iman bomi unelan-temap boyo dam uta kup ifemin kale minte, boyo tebe kapmi aget fugunin uyo dong dogop-kaman-temaalu o,’ agesu (kale, bo kanube-nilita, iman unelan-temaali) o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Minte Saatan tebe Yesus iyo dep unanbu tam daa-nala e, kota yuut kafin kaa kutufosu komi tinum miit maak maak iyo alugum kafalebe-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","bogopma, “God iyo bogopne-nala, ‘Alugum kafin kaa kutufosu so alugum tinum miit maak maak bilip iso iyo kapmi o,’ agesa kale, nita tiin mobi kale, nagal tinum iyo maak keta kalaa ageli umdii, ulaa du kopmita, ‘Kabo tiin molal o,’ agelan-temi ko. Kale niyo tii tinum miit iyo alugum imdali yak kalapmi sagaal diim abelipta, kapkal tebe bilip iyo tiin mo-namap ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kale kabo nalami tibit diim kal katuun duung fegela daak ton-nalap bogopne-nalap, ‘Kabo nimi kamogim o,’ agelap umdii, tinum miit iyo alugum kop-kami bilip iyo kalapmi kelan-temip o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesus isiik bogopma, “Umbae. God imi suuk kon tem weng uyo bogo-nulu e, ‘God ita kup kapmi Bisel kale, kabo beta kup katuun duung fegela daak ton aman duga-e-bom-nalap e minte, imi weng uta kup tinangka-bom no kemal o,’ agesu o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Minte Saatan iyo Yesus iyo duptamo unanbu no Jerusalam no abe-nala e, dep unanbu tam ulotu am miton umi am duu diim daa-nala e, bogopma, “Kabo fen tuluun God imi Man umdii, mufekmufek umaak tebe kangkolan-temaalu kale, kaal binim isal kalota fon unanbu daak kafin diim abelal a. ");
INSERT INTO tlf_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","God imi suuk kon tem weng uyo bogo-nulu e, ‘God iyo ilami ensel iyo bogopma tal kabo tiin molipta, kangkolan-temaalu o,’ agelu e minte, ");
INSERT INTO tlf_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","maak uyo bogolu, ‘Ensel igil kaafuu kafolan-temip kale, tuum daang umaak tebe kapmi yaan uyo malaa kwaap-kaman-temaalu binim o,’ age no kesu kale, kabo kumen daak kafin diim abelapta, unang tinum kulaak albip iyo utamipta e, kabo God imi Man kalaa agomip o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","minte Yesus isiik bogopma, “Umbae. God imi suuk kon kem weng uyo bogo-nulu e, ‘Bisel beyo kapmi God kale, beyo dup-kugu-bom bogobe-nalap, “God kabo nimi weng bogopkeli boyo tinangku kanube kafalebelapta, kek kek iyo utamipta e, God kabo nimi ilak uta duga-bom dong dagane-balap kalaa kagelin o,” agan-kalin ba o,’ agesu o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kale Saatan iyo Yesus imi dup-kugumin uyo dup-kugu-bala bii, alugum binimanuta, Yesus iyo titil fagala kalaa age-nalata, dupkaa ilep migik fena ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesus iyo asok ilami Provins miton Galili una e minte, God imi Sinik iyo iso bom-nalata, dong daga-e-balata, Yesus iyo titil fagaa ogok ke-balata, kek kek iyo Yesus imi tok baga-em kwep yak Provins umi abiip maak maak uyo baga-emip senganu ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kale Yesus iyo God imi weng uyo kwep yak Provins Galili umi ulotu am tem maak maak uyo kafale-bala e, alugum imi weng uyo tinangka-bom-nilip e, imi win kufu-emip ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesus imi abiip miton uyo Nasaret kale, kugol ilami amalap so bom-nala e, fito-se kale, daage ilami abiip una ko. Kale God imi ifin am daanu e, ilami suun kuguup uyo waafuu ulotu am una ko. Kota ulotu tiin molin tinum iyo Yesus ulaa dula e, fen mo-nala e, no unang tinum imi tibit diim kal mo-bom God imi suuk kon tem weng uyo tikiman o agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","God imi suuk kon atuk uyo God imi profet ko age weng kem baga-emin tinum Aisaya ita dola kosa kale, boyo ulotu tiin molin iyo kwaapma yak Yesus sagaal diim abelu e, suuk kon uyo bam daa ko ulumi atuk uyo utam-nala e, tikima ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“God imi suuk kon tem weng uyo bogo-nulu e, ‘Bisel God iyo ulaa nimdula kano, imi ogok boyo kuptamo tebebe-bilita o ageta, nimdala ti-sii kale, ilami Sinik iyo daala tal nimi diim abe-nalata, dong dagane-bala ogok ke-bii ko. Kale God imi bogopne-nala, “Kanupmin ogok kota kanumal o,” age-se uyo kalbu kale, nagal God imi weng tambal boyo usap man bilip imi baga-eman o ageta ko. Nagal unang tinum sok de imosip bilip iyo bogobe-nili kano, “Sok tala-em daalip yuum binim daaginin o,” agelan o ageta ko. Nagal unang tinum tiin biginam unsip bilip iyo bogopmi, “Tiin baamin o,” agelan o ageta ko. Nagal tinum waasi dinan-bom ita ita kesip bilip iyo imkan to-nili e minte, tinum kubagansip ita tala-em daali iluum binim kelin o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nagal unang tinum iyo bogobe-nili e, “Kota Bisel God imi am uyo tulu kale, ilami unang tinum iyo telela imkaman-tema o,” agelan o,’ age God imi suuk kon tem weng kek uyo kam agesu o,” age Yesus iyo tiki-bom baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Kale Yesus iyo suuk kon uyo tikila binimanu e, suuk kon uyo asok falala ko ulotu tiin molin imi kobela kale, ton-bom unang tinum imi kafaleman o age-nalata, ilimi tibit diim kal tona kale, alugum unang tinum ulotu am kutam albip iyo kek fen Yesus iyo tiin dot atama-bom-nilip e, imi weng baga-eman-tema uyo tolong dugamum o agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kota alugum imi bogopma ko. “Kamano koyo God imi weng uyo tiki-e-bili tolong dolip kale, weng koyo God iyo nalami sang uyo bogobelata, God imi weng kem baga-emin tinum Aisaya iyo dola kosa kale, uta kagal mitam tebelu o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tolong dolipta, weng tambal uyo mitam talan-bo kalaa age-nilip e, iyo kumang mo-nilip e, imi win uyo kufu-e-bom bogo-nilip e, “Ibaa. Beyo waami man ba kale, beyo Josep man kuta, beyo kanupmin weng tambal boyo dogap ku-tele kuta bagan-be o?” agan-kalip e, ");
INSERT INTO tlf_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesus iyo bogopma, “Ibo tolong dolipta, ‘Yesus iyo unang tinum mafak umkan unsip iyo top abiip Kapeneam kutam kal telela imoba o,’ nagelip kalaa agebip kale, kamaa kota ibo sugayok amalabal imi do weng bogo-nilip, ‘Dokta kabaa. Yak kalapmi mafak ilin boyo telela ko o,’ age bagamsip boyo asok bogopne-nilip e minte, ‘Kapmi top Kapeneam ogok tambal kanubebap boyo asok kalapmi abiip miton kagal kanubelal o,’ agelan-temip kalaa agebi ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Kuta niyo tuluun weng uyo bogobelan-temi kale, God imi profet ko age weng kem baga-emin tinum iyo (no abiip maak maak unon-tema uta, abiip kasel iyo bogo-nilip e, ‘Keyo win tibin tinum o,’ age imi weng uyo tele tinangkulan-temip kuta minte,) no ilami abiip miton unon-tema uta, ilami abiip kasel iyo imi weng uyo tinangkulan-temaalip binim ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tuluun weng uyo maak so bogopman-temi kale, tolong umo-silipta. Sugayok God imi weng kem baga-emin tinum Elaija imi bii-se umi diim kota wep minan-kalin binim bii, atol asuno e minte kayop bugup kal no uyo binimanuta, alugum abiip maak maak kutam iyo iman tebok mitam tebelu kale, unang kaluun kwiin tagang iyo kafin Israel umi abiip kutam kal nip kuta, ");
INSERT INTO tlf_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","God iyo Elaija iyo daala talta maak dong daga-e-biisaala kale, daala te kafin migik no abiip miton Saidon umi abiip tung Sarefat kutam umi unang kaluun maagup uta kup dong dogobe-se ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Aa mungkup aaltam uyo God imi weng kem baga-emin tinum maak Elisa imi bii-se umi diim kota tinum kaal mafak kesip kwiin tagang iyo kafin Israel umi abiip kutam kal nip kuta, Elisa iyo tinum iyo maak dong dogobesaala kale, kafin migik Siria kayaak tinum Naman ita kup dong dogobe-se o,” age Yesus iyo bogola ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Alugum tinum ulotu am albip iyo Yesus imi weng uyo tolong do-nilip e, utamipta e, Yesus iyo kanube numi sang uta baga-e-be kalaa age-nilip e, iyo olsak kup tebepmu e, an-togon daa-nilip e, ");
INSERT INTO tlf_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","fen mo yak aafuu dilili dep tam abiip abe-nilip e, abiip kupkaa dilili dep unip ko. Ilimi abiip uyo amdu umi tafaap tem kal nin kale, dilili dep tam amdu dubom diim abe-nilip e, daalup kot iinak o agan-kalip kuta, ");
INSERT INTO tlf_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","God ita tebe tinum imi tiin uyo uksupma Yesus iyo dupkalip e, ilimi iibak tem ku-tele daagina ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesus iyo abiip Nasaret kupka-nala e, daak Provins Galili umi abiip Kapeneam kutam iina e, God imi ifin am daanu e, Yesus iyo tam Juda kasel imi ulotu am tam-nalata, God imi weng uyo unang tinum iyo baga-e-bom kafalemata, ");
INSERT INTO tlf_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","utamipta e, Yesus imi weng kafalemin kuguup uyo atin fen ugulumi migik kalaa age-nilip e minte, God imi aget fugunin uta dagaa ku uta-bom-nalata, nuyo fomtuup kafale-be kalaa age-nilipta, kumang muuna tala kelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kale ulotu am kutam uyo tinum maak alba beyo sinik mafak tebe aafusuta kale, fomtuup ol-bom-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yeee. Nasaret kayaak Yesus kabo, nuyo intap nubelan o age-nalapta, talap a? Kabo tal, nuyo ifak daali win binim kelin o age-nalapta, talap aga? Niyo katamita e, kabo God imi tinum ulaa kamdu-nala kamdala ti-salap kapta kalaa agebi o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","minte Yesus isiik sinik mafak beyo an-togon-bom bogobe-nala e, “Kabo sining age-nalap tinum beyo dupkaa yak iinaal o,” agela e, kota sinik mafak beyo tebe-nala e, tinum beyo bagaa daalu daak tinum tonbip imi iibak tem kulaak abela e, dufak daa-numu binim, dupkaa yak iina e, ");
INSERT INTO tlf_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","unang tinum iyo alugum kumang mo-nilip e, ipkumal migik iyo daga una tala ke-bom bogo-nilip e, “Ko dogonupmin weng bogola a? Bemi titil uta tii kale, sinik mafak bilip iyo fomtuup bogobe-nala e, ‘Yak iinin o,’ agelata, yak iinan-bilip kuba,” agelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kale Yesus imi kanubela umi sang uyo unang tinum ita tebe tegen kuptamo yang Provins Galili bomi abiip maak maak unip ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesus iyo fen mo-nala e, ulotu am uyo kupkaa Saimon imi am una kale, Saimon imi alol uyo kaal mimin afek tebebelu kalaa age-nilipta, Fita ulimal iyo Yesus imi dagalip, “Dong dogobelapta o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesus iyo no umi mep so mo-nala e, kaal mimin uyo ugelata, binimanebelu e, maak fagalin tap mitam fen-nulu e, bilip imi iman uyo telela kobelu ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kale ataan uyo, tem iinon o agan-sulu e, (God imi ifin am uyo binimanu kalaa age-nilipta,) abiip kasel iyo duup kanumin kanumin mafak ilin umkan unsip iyo alugum kulep Yesus imi finang tilip e, Yesus iyo sagaal kwep yak alugum unang tinum mafak ilin imi diim daa-nalata, telela imolata, bam dagamip ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kale sinik mafak tebe unang tinum kwiin tagang iyo de imosipta, Yesus iyo sinik mafak iyo bong dubak daala mitam e tolom-nilip e, bogolip ko. “Kabo God imi Man kapta o,” age olan delep unip e, Yesus iyo itamata, sinik mafak igil nitamipta, beyo God imi ulaa dula kamok kesa tinum ita kalaa nagelip kalaa age-nalata, yage-nala e, fomtuup weng bogobela, “Ibo maak so weng boyo bagamin ba o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Silipta, kutim mililep kota Yesus iyo abiip Kapeneam uyo kupka-nala e, (God imi beten keman o age) no tinum binim iibaan una e, unang tinum iyo fen no atam-nilip e, fegelepmupta, bemi imkaa unon-tema boyo kupkalak o agelipta, ");
INSERT INTO tlf_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Yesus iyo bogobe-nala e, “Aatum God iyo bogopne-nala, ‘Kabo nimi weng kuptamo no alugum abiip maak maak kutam iyo baga-e-balapta, meng nimi daam tem e telemin o,’ age-nalata, nimdala ti-sii kale, imi weng tambal uyo kwep abiip maak maak unon-temi o,” age-nalata, ");
INSERT INTO tlf_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","imkaa no alugum abiip maak maak umi ulotu am kugol God imi weng uyo baga-em tiinema ko. ");
INSERT INTO tlf_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Am maak daanu e, Yesus iyo Genesaret Ok Muk ko age Galili Ok Muk umi kan tem kugol mo-bom-balata, unang tinum iyo, God imi weng tinangkamum o age-nilipta, ilek ilek tal falala dek molip ko. ");
INSERT INTO tlf_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kale Yesus iyo utamata e, aniing abumin tinum iyo bot alop tisii kulep ok kan tem to-nilip e, kupkaa yang no aniing abumin men diing dagan-bilip kalaa agela kale, ");
INSERT INTO tlf_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","bot alop kale, maak boyo Saimon imi bot kale, Yesus iyo tam Saimon imi bot tem unom ton-nala e, bogobe-nala e, “Bot ilibe kwaalap yak ok muk daang kun diim unuk o,” agela e, Saimon iyo ilibe kwaala yak so kela e, unang tinum iyo God imi weng uyo kafalema ko. ");
INSERT INTO tlf_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yesus iyo weng uyo binimanu kupka-nala e, Saimon iyo bogobe-nala e, “Kapsino kapkumal sino ibo bot koyo ilibe kwaalip yak ok muk iibak tem unuta, ipmi aniing abumin men boyo kululip daak ok tem unuta, aniing umaak abulin o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","tam Saimon iyo bogola ko. “Kamogim kabaa. Mililep uyo aniing abumum o age taban tisup kuta, aniing umaak inobaalup kale, kupka-numup kuta, kapkal bogolap bole, numi aniing abumin men uyo kululup daak ok tem unon-temu o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","kota ninggil imi aniing abumin men uyo kululip daak ok tem unu siit-nilip e, kota kulep mitam to-numup ko agelipta e, iluum kup tebelu kalaa agelip kale, aniing kwiin tagang ke-nuluta, umi iluum uta tebeta aniing abumin men uyo, dalata kulep unon o ageluta, ");
INSERT INTO tlf_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ipkumal bot maak tem albip iyo, “Tal dong dogopmipta o,” age-nilipta, kul som togopmipta, tal dong dogobelip ninggil alugum iyo aniing abumin men uyo kulep mitam daata aniing uyo bot tem abu-bilipta, bot alop uyo dongenuta, umi iluum tebe-nuluta, bot uyo, ibulup age daak ok kumun tem unon o ageluta, ");
INSERT INTO tlf_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","tam Saimon Fita iyo utamata e, bo kanupmu kalaa age-nalata, katuun duung fegela daak Yesus imi miit tem ton-nala e, bogo-nala e, “Kamogim kabaa. Niyo fengmin tinum kale, nimi aget uyo fugunin ba kale, nimkalal o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","10","Kale Saimon ninggil iyo tam bot maak tem ton-bom-bilip e minte, Saimon imi ipkumal maak iyo yak bot maak tem ton-bom no kelip kale, ipkumal maak iyo Sebedi man alop Jems so Jon so kale, alugum iyo aniing baan kiim uyo utam-nilip e, kumang molip e, tam Yesus iyo Saimon imi bogobe-nala e, “Finanin ba. Siin am kaa daan tebesu uyo, aniing abum-nuubap kale minte, am kaa daanu koyo, tinum ita afeta imdep meng God imi miit tem toman-temap o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kale ninggil iyo bot alop uyo tisii kulep yak ok kan tem kal kutu-nilip e, imi kafin diim umi mufekmufek aget fugunin uyo kupka-nilipta, Yesus imi weng tinangku-nilipta, Yesus imi daang begebe unip ko. ");
INSERT INTO tlf_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tam am maak daanu e, Yesus iyo abiip maak kutam kal bom-nalata, utamata, tinum kaal mafak kesa maak alba kalaa agela e, tinum beyo tal Yesus iyo atam-nala e, kamok king imi weng umka-emin umi kuguup uta ku-nala e, tal katuun duung fegela daak imi miit tem ton-nala e, Yesus iyo fomtuup daga-nala e, “Kamogim kabaa. Kabo tii kale, dong dogopnelan o agelap umdii, nimi kaal mafak koyo telela kopne-namap o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesus iyo sagaal uyo kwep yak tinum bemi kaal diim uyo daa bogobe-nala e, “Aa. Niyo dong dogopkelan o ageta kale, kaa telela kamoli tambalanap o,” agela e bole, tinum bemi kaal mafak uyo maak fagaa binimanepmu tinum kasagim kela e, ");
INSERT INTO tlf_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","kota Yesus iyo weng kobe-nala e, “Kabo koyo no tinum imi diim uyo ki nimi kanupkeli bomi sang uyo baga-emin ba kale, kupkaa unap ki no pris ko age tinum amem imi diim kal kapmi kaal uyo kafalebelapta, iyo katamta, ‘Dam kapmi kaal uyo tambalanu o,’ kagelata bole, kabo Moses imi sugayok weng kwep daasa uta ku waafu-nalapta, mufekmufek maak God iyo kobe-nalap, ‘Suguul o,’ agelapta, unang tinum iyo katamipta e, aafen ko tambalanap kalaa age-nilipta, asok kamdep meng daalin o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kuta unang tinum iyo Yesus imi kanubeba umi sang uyo tolong do-nilip e, en kwep yakyak ke-bilipta, unang tinum kwiin tagang iyo tolong do-nilipta, nuyo no Yesus imi weng uyo tinangkulum o agan-bom e minte, numi unang tinum mafak ilik umkan unsip iyo imdep no daalup beta telela imolak o agan-bom no keta talan-nuubip kuta, ");
INSERT INTO tlf_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","biliip maak uyo Yesus iyo imkaa no iibaan uyo no ilami Aalap God imi beten kem-nuuba ko. ");
INSERT INTO tlf_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kale Falosi sino ulo utamsip tinum isino iyo no, Yesus imi weng uyo tinangkulum o age-nilipta, Provins Galili so Provins Yuudiya so kutam umi abiip maak maak sino e minte abiip miton Jerusalam sino uyo kupkaa tal Yesus imi finang tele-bala tele-bala ke-bilipta, am maak daanu e, Yesus iyo am kutam kal unang tinum iyo God imi weng kafale-bala e, Falosi sino e minte ulo utamsip tinum sino iip maak maak igil tam ton tinangka-bilip e, God imi titil uyo Yesus imi diim kal bom-buluta, unang tinum mafak umosip iyo telela imka-balata, ");
INSERT INTO tlf_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","tinum ninggil maak ipkum magal fagaa kubesu iyo daalip ilet tem iina ade duptamo tal abiip abe, dep tam am Yesus imi miit tem daalupta, telela dolak o agelip kuta, ");
INSERT INTO tlf_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","utamipta e, Bei. Am uyo bugubip kalaa age-nilipta, fen te te nipta, ilep binim kalaa age-nilip e, yak abe dep tam am konal daa am kon dagaa kupkan ke kupka-nilip e, tinum beyo ilet tem kulagal bom-balata, sok diim agol kup tulup tulup daalip unanbu daak unang tinum albip imi iibak tem no Yesus imi miit tem kulaak abela ko. ");
INSERT INTO tlf_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kale Yesus iyo itamata e, tinum ninggil iyo utamipta e, Yesus iyo tii tinum keyo telela do-nama kalaa nagelip kalaa age-nala e, tinum magal fagaa kubesu iyo bogobe-nala e, “Nugum kabaa. Niyo kapmi fengmin uyo alugum kupkan kepkeli binimanu o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Kale ulo utamsip tinum so Falosi sino iyo aget fugun-bom-nilip e, “Kafin diim tinum iyo dogonubeta unang tinum imi fengmin uyo kupkan kepman-temaala kale, God maagup ita kup kale, tinum beyo dogonupmin tinumta, beyo tebe-nalata, God imi win uyo kufak daga-e-bom-nalata, kam agan-be o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesus isiik bilip imi aget fugun-bilip uyo utamebe-nala e, bogopma ko. “Intaben o ageta ibo kanupmin aget boyo fugun-bilip a? ");
INSERT INTO tlf_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Niyo intaben mufekmufek uta maak kanubelita, ibo yuut nitamipta, beyo dam bagan-be kalaa nagelan-temip a? Niyo tinum kemi bogobe-nili, ‘Kapmi fengmin uyo kupkan kepkeli o,’ agon-temi uyo, ibo bogopne-nilip, ‘Nuyo boyo nulumi tiin fala utamin-tem kelup kale, kabo bisop bagan-balap o,’ agelan-temip kale minte, niyo tinum kemi bogobe-nili, ‘Fen mo unaal o,’ ageli fenan-tema uta, utamipta, boyo dam bagan-be kale, beyo tii fengmin uyo kupkan kepmoma kalaa nagon-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kale ipkil utamin. Niyo Mo Tibil imi Man kale, nimi titil kiim uyo kafalebelita, ibo utamipta e, beyo bisop baganbaala kale, kafin diim alba koyo, beyo tii unang tinum imi fengmin uyo kupkan kepman-tema kalaa nagelan-temip o,” agan tolom-nala e minte, tinum magal fagaa kubesu bemi bogobe-nala e, “Kabaa. Kabo fen-nalap kapmi kamtamo tilip umi ilet uyo kuptamo-nalap kalapmi am iinaal o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","alugum albip bilip imi tiin diim kugol tinum beyo yuut fen mo daak ilami agaal unba ilet uyo kuptamo tam abiip abe ilami am unom-nala e, God imi tok uyo baga-bom deng tebema kale, ");
INSERT INTO tlf_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","kota alugum unang tinum iyo kumang mo finano bogolip ko. “Sugayok uyo kanupmin kuguup umaak utaman-nuubaalup kale, kamano kota kanupmin kuguup boyo Yesus iyo kafalepma utamup o,” age-nilip e, God imi win uyo kufu-emip ko. ");
INSERT INTO tlf_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kale kota Yesus iyo am uyo kupkaa daage no takis mani kwaamin tinum imi am ko age ofis no, takis mani kwaamin tinum Livai tonba kalaa age-nala e, bogobela ko. “Nugum kabaa. Kapmi ogok ke-balap boyo kupkaa talapta, niso ninggil abe-bomta nimi ogok usiik maak kopkelita, ogok kemal o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Livai iyo fen mo-nala e, mufekmufek uyo alugum kutu-nala e minte, Yesus imi daang begebe una ko. ");
INSERT INTO tlf_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Biilu e, Livai iyo, Yesus imi deng tebe-bom iman tigi-bom unan-kulum o age-nalata, ilami ogok kemin tinum imi bogobelata, no iman fuu-bom-nilip e, telel-bom no kelip e, duup-afin so e minte takis mani kwaamin tinum so kwiin tagang iyo Livai imi am no tilip e, ton-bom iman unan-bom-nilip e, deng tebemip ko. ");
INSERT INTO tlf_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kale Falosi so ulo utamsip tinum Falosi kesip so iyo tal-nilip e, Yesus imi okumop man iyo itafi-bom bogobe-nilip e, “Ibo intaben o age-nilipta, tal tamipta, takis mani kwaamin tinum sino kuguup mafak waafulin tinum migik sino iman unan-bilip a? Ipmi ko kanu-bilip boyo mafak o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesus isiik do weng maak bogobe-nala e, “Tam tinum tambal albip iyo dokta imi finang uyo unon-temaalip kale minte, fen tinum mafak albip ita kup dokta imi finang uyo unon-temip kale, ");
INSERT INTO tlf_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ulutap mungkup, niyo tal unang tinum bogo-nilip, ‘Nuyo fengmin binim kale, tol kup unang tinum o,’ agan-bilip ita dong daga-e-bilita, imi aget uyo fupkela ko God imi ilak uyo dolin o ageta tisaali kale, niyo tal unang tinum bogo-nilip, ‘Nuyo fengmin unang tinum o,’ agan-bilip bilip ita kup dong daga-e-bilita, imi aget uyo fupkela ko God imi ilak uyo dolin o ageta ti-sii o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tinum iip maak maak iyo Yesus iyo bogopmip, “Kabaa. Ok sam uga-emin tinum Jon Baptis imi okumop man iyo, beten kemum o agan-kalip uyo, unan-kalin uyo fala-bom beten ke-bilip e minte, mungkup Falosi imi okumop man igil mungkup kanupmin kuguup boyo ke-bilip no kem-nuubip kuta, kapmi okumop man iyo kanupmin kuguup boyo waafubaalip binim kale, iman unan-kulum min agelip uyo, unan-kalin kup kem-nuubip ko. Intaben o ageta boyo kem-nuubip o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesus iyo ilami kaanan-tema umi sang uyo felep yak unang tinum kulan-tema imi diim to bogobe-nala e, “Tam tinum iyo unang kulan-tema uyo, tinum ilo iyo tebe iman fuu-bom unan-bom deng tebeman-temip kale, kanuman-temip kota, tinum migik iyo felepmuta, bogobe-nala e, ‘Ibo deng tebe-bom iman unan-kalin ba kale, aget iluum uyo tebe-bom unan-kalin uyo falamin o,’ agelan-tema bele ki? Umbae. Tinum ilo iyo utamipta, nugum iyo nuso alba kalaa age deng tebe-bom-nilipta, iman uyo unan-kalon-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kuta biilan-temu kutop uyo, waasi iyo tebe tal-nilip e, bilip imi ipkum iyo aafuu dep unip kalaa age-nilipta, ipkumal iyo aget iluum tebebeluta, unan-kalin uyo falaman-temip o,” age Yesus iyo do weng uyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesus iyo Juda kasel iyo (itamata e, ilimi siin kuguup uta fomtuup waafusipta, nimi kamaa kuguup uyo waafulaalup o agan-bilip kalaa age-nalata,) do weng alop maak ko bogobe-nala e, “Unang uyo felepmuta, ulumi sket kamaa uyo atuk uyo maak fangaa kwep yak sket dusabansu umi diim daa bigi kolan-temu aga? Umbae. Ulumi sket kamaa uyo fangaa kulan-temu bole, mafaganepman-temu kale minte, sket kasaak bomi atuk fangaa kwep yak sket dusap umi diim daa bigi kobu boyo sket dusabansu uyo tiilan-temaalu ko. ");
INSERT INTO tlf_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Aa mungkup ulutap kale, tinum iyo meme kaal siin dalaa kwep daala fonganbu umi tem ku-tele kamaa umi wain ok ko age sok dum ok uyo ilu kola dongenu kalaa age-nala e, sok ku tem uyo de ko-nala e, kwep tal am daala umdii, siit-nuluta, ok uyo fitin unom-nuluta, meme kaal totanin boyo yuut nagat mo bigin-nuluta, ok uyo singkam daa daaginon-temu e minte, kaal uyo mafagan-nuluta, fengela tebelan-temu no kale, ");
INSERT INTO tlf_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","tinum iyo, kamaa umi wain ok uyo ilu kolan o agela umdii, meme kaal uyo kamaa dalaa kwep daala totanin binim albu uta kup ku-nalata, wain ok uyo ilu kwep tal daalan-tema bota tambaliim nan-temu ko. ");
INSERT INTO tlf_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“Tinum iyo dogap ita siin umi wain ok unela uyo, minte wain ok migik uyo unelan-temaala kale, boyo dok uta bogo-nala e, ‘Siin umi wain ok uneli umi abaal uyo tambaliim kale minte, kamaa umi wain ok uta abaal binim o,’ agelan-tema o,” age Yesus iyo do weng uyo baga-ema ko. (Kale do weng alop boyo bogo-nulu, “Niyo, kamaa kuguup kwep tal ipmi siin kuguup uyo anung tifipman o ageta tisaali kale, niyo kamaa kuguup uyo kwep tilita, uta tele waafulin o ageta kwep ti-sii o,” age-suu ko.) ");
INSERT INTO tlf_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tam God imi ifin am ko age ulotu am maak daanu e, Yesus so ilami okumop man isino rais ko age wiit ilang umi iibak tem miton kutop-tele ninggil dagaa dep unip ko. Kale ilami okumop man iyo abe-bom-nilip e, iman tep tebepmu e, wiit san uyo ugu kululip ilimi kul ban tem unu iibala-bom unan tam tam unip kale, ");
INSERT INTO tlf_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Falosi iip maak maak iyo itam-nilip e, bogopmip, “Ibaa. Numi ulo uyo bogo-nulu e, ‘Ibo God imi ifin am uyo iman fagan-bii kulep telemin ba o,’ agesu kuta, ibo intaben o age-nilipta, wiit boyo uga-bomta iibala-bom unan-bilip a? Ibo numi ulo uyo kufak dagan tebebip o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","minte Yesus isiik bogobe-nala e, “Ibo God imi suuk kon tem weng tikim-nuubip boyo dagaa kusaalip aga? Sugamiyok uyo Devit isino ilami waasi dinan-kalin tinum isino ninggil iman tep tebepmu bom-nilip uyo, Devit iyo kanupmin kuguup bota kanubesa ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ulotu umi ulo uyo bogo-nulu e, ‘Unang tinum ibo pris ko age tinum amem imi bret fuu kulep no God imi kobelum o age-nilip God imi am kutam tom-nuubip boyo unan-kalin ba ko. Boyo amem kale, tinum amem ita kup unan-kalin o,’ agesu kuta, Devit iyo God imi am kutam uyo no-nala e, tinum amem iyo iman amem umi sang dagala tinum amem iyo du-filin daa iman amem uyo kopma e, Devit iyo atuk fagaa ku une-nala e, atuk uyo ku ilami waasi dinan-kalin tinum iyo kopma unesip ko. Kale ninggil bilip iyo ulo uyo ilo kosip kuta, ibo bogo-nilip, ‘Boyo kuguup mafak kanubesip o,’ agan-nuubaalip kuba. Kale intaben o age-nilipta, nimi okumop man iyo iman tep tebepmu kanu-bilipta, ibo bogobe-nilip, ‘Boyo kuguup mafak kanu-bilip o,’ agan-bilip a? ");
INSERT INTO tlf_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Mo Tibil imi Man niyo God imi ifin am umi tiin molin tinum iyo kalbi kale niyo tii unang tinum imi bogobe-nili, ‘God imi ifin am diim kagal ibo boyo kanumin o,’ age-nimi o,” age Yesus iyo Falosi imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Asok God imi ifin am maak daanu e, Yesus iyo tam Juda kasel imi ulotu am kutam kal God imi weng uyo unang tinum iyo kafale-bomta, tinum maak atamata, imi sagaal ipkuk uyo fuulanebesu kalaa agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ulo utamsip tinum so Falosi sino kutam albip iyo aget fugun-bom-nilip e, “Yesus iyo tele atama-bomta, numi ulo uyo ilo ko-nala God imi ifin am daanbu diim kagal tinum beyo telela dola kalaa agelup umdii, dep no weng telelmin diim daa dupkem daalum o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kuta minte Yesus iyo imi aget fugun-bilip uyo utam-nalata, tinum sagaal milii fuulanebesa iyo bogobela ko. “Kabo fen-nalap tal miton kal molal o,” agela e, tinum iyo fen-nala e, tal miton kal mola e, ");
INSERT INTO tlf_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesus iyo unang tinum imi bogobe-nala e, “Ibo numi ulo umi sang maak dagalan-temi uyo kulbu ko. Kale ulo uyo bogo-nulu e, ‘Kabo God imi ifin am daanu uyo unang tinum iyo dong daga-emal o,’ agesu bele, ‘Ifak dagamal o,’ agesu a? Bogo-nulu, ‘Kabo unang tinum iyo telela imolap waalanamin o,’ agesu bele, ‘Imkalap kaanamin o,’ agesu o?” age-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesus iyo fupkela tinum iyo alugum tele itaman tiinan-bii-nala e, tinum sagaal milii fuulanebesa iyo bogobe-nala e, “Kapmi sagaal uyo tifi kolal o,” agela e, tinum iyo kanubela e, kota imi sagaal uyo tambalanepmu ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kuta ulo utamsip tinum so Falosi sino iyo alugum olsak afek tebepmu e, “Yesus be dogonupman-temup o?” age weng tegenip ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kale kota Yesus iyo daage beten kem tam amdu tigiin kal God imi aman duga-e-bom seta, ");
INSERT INTO tlf_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","am daanu e, kota ilami okumop man iyo olabela tilip e, tinum tuluun kal maak ita kup ulu-nala e, “Ibo nimi kalaan tinum kelip o,” age bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Kale kalaan tinum kelip o age-se iyo kulbip kale, tam Saimon imi win migik uyo Yesus ita, “Fita o,” ageba yagal, minte ilami niing Andru yagal, Jems yagal, Jon yagal, Filip yagal, Batolomyu yagal, ");
INSERT INTO tlf_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu yagal, Tomas yagal, minte asegim Jems beyo Alfius man kale, yagal, minte asegim Saimon imi win bogobe-nilip, “Rom kasel itafinonin tinum o,” agan-nuubip kale, yagal, ");
INSERT INTO tlf_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","asegim Jems imi man Judas yagal, minte Yesus imi dupkem daalan-tema tinum Keriot kayaak Judas yagal no ninggil kalip ita ulula ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesus iyo amdu tigiin ilota tinum tuluun kal sino ninggil dagaa kulep daak bagan biil unip e, imi okumop man kwiin tagang iyo tala tala kelip e, (Yesus iyo tam mo-nala e, weng baga-ema) ko. Kale unang tinum kwiin tagang angge kobip bilip iyo Provins Yuudiya umi abiip maak maak kasel sino abiip miton Jerusalam kasel so e minte yol ok diim abiip alop Taya sino Saidon sino umi kasel no kale, ");
INSERT INTO tlf_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","bilip imi aget fugunin uyo, no Yesus imi weng uyo tinangka-bulup e minte, numi mafak ilin uyo telela imka-bom no kemak o ageta tele-bala tele-bala kebip ko. Minte sinik mafak imdulin sino tal tamip telela imola tambaliim kelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kale unang tinum iyo utamipta e, nugumal iyo melebelipta, Yesus imi titil uyo yak imi diim abe telela imka-bulu tambalanamip kalaa ageta alugum iyo dogonubeta Yesus iyo melebelum o agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesus iyo fupkela ilami okumop man itama-bom-nala e, bogopma, “God imi mufekmufek duumatanamin unang tinum ibaa. God iyo tebe ibo imdep mitam ilami daam tem daalan o angba kale, yagal tiin molata, ibo tele tambaliim kup ton-bom-nilip e, deng tebe-bom no keman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Iman tep nin unang tinum ibaa. Ibo kamano koyo iman tep nip kuta, God yagal iman uyo kupka-e-bala unan-bii, tii unelup kalaa age-nilip e, deng tebeman-temip ko. “Aget iluum tebemin unang tinum ibaa. Ibo kamano koyo aman-bilip kuta, God yagal tambaliim kup teleleman-tema kale, aban dii-bom deng tebe-bom keman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","“Mo Tibil imi Man nimi okumop man ibaa. Ibo nimi okumop man kale, nimi waasi iyo ipmi itafinon-bom-nilip, imkege-bom-nilip, tele baga-e-bom-nilip, ipmi win mafak baga-e-bom no kem-nuubip kuta, kanupmin kuguup mafak bo kanu-eman-temip kota, ibo aget fugunolipta, God iyo mufekmufek tambal uta kup abiil tigiin kal bom telele-be kalaa age-nilip e, deng afek kup tebe-bom kaal fong kup tagat age-bom atol daga-bom no kemin o ageta ko. Kale kanupmin kuguup mafak waafulin tinum bilip imi olal iyo kanupmin kuguup ulutap uta God imi profet ko age weng kem baga-emin tinum iyo kanu-e-bilipta, titil fagagamsip (kale, ibo bomi aget fuguno-nilip e, fifik fafak nin ba kale, titil fagaa timtim bigi-nilipta o ageta) ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Mufekmufek kasel ibaa. Ibo mufekmufek tambal uyo kululip ipmi aget tem uyo tambalanebebu kuta, ipmi kanupmin deng tebebip boyo uta kup utabip kale, deng tebemin migik uyo maak kulan-temaalip binim kale, aget mafak uta kup ku-nilipta, ogen abin so uyo utaman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Minte unang tinum iman unan-biita, tii kelup o age deng taban-bilip ibaa. Son-temu nala am maak daanan-temu uyo, ibo iman tep ogen abin so uyo utaman-temip ko. “Unang tinum aban dii-bom deng aa ifup aa taban-bilip ibaa. Son-temu nala am maak daanan-temu uyo, ibo aget iluum tebe-bom ame-bom ke-bom-nilipta, ogen abin so uyo utaman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Ibaa. Ibo unang tinum iyo bisop weng uyo baga-e-bilipta, fen ko age-nilipta, ipmi tok uyo bagan-bilip a? Kanuman-temip uta, God yagal ipmi yuum kobe-nalata, kaal fuyap kupka-e-balata, ogen abin so uyo utaman-temip ko. Ulutap kale, sugayok uyo tinum maak maak iyo tebe ilimi weng uta bogo, ‘God imi weng o,’ age bisop baga-e-bilipta, ipmi olal iyo imi tok uyo bagamsip o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yesus iyo asok bogopma, “Ibo nimi weng bogobeli uyo tolong dolip kale, kamano nimi weng baga-eman-temi koyo tele tolong do-silipta. Ipmi waasi bilip iyo i-filin-bom-nilip e minte, unang tinum dok ita ipmi itafinonin bilip iyo kuguup tambal uta kup kupka-e-bom no ke-bom-nilipta a. ");
INSERT INTO tlf_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Minte ibo God imi dagalipta, ita ipmi timon dine-emin tinum iyo telele-bom-nala e minte, dogap ita titul weng ipmi baga-e-bilip imi aget fugunin uyo telele-bom no kemak o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Tinum dogap ita kapmi agak kun milii uyo kul baang ku bino kangkola umdii, kabo fupkela agak kun milii uyo kobelap kangko no kelak o ageta ko. Ulutap kale, tinum dogap ita kapmi diil uksumin ilim ko age saket uyo dagaa kula umdii, kupkabe-nalap e, kapmi siyot uyo kobe no kelal o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tinum dogap ita tal kapmi mufekmufek sang uyo dagala umdii, kupka-emin ko. Minte dogap ita kapmi mufekmufek kwep un-se kalaa agelap umdii, bogobe-nalap, ‘Asok kopnelal o,’ agan-kalin ba ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kapmi aget fugunin uyo, ‘Nugumal ita tambaliim kup telelne-bilipta, tambaliim nan o,’ agan-balap umdii, kamaki uyo kapsiik telele-bom kanupmin kuguup tambal uyo kupka-e-balapta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kanube kabo asit kek kek iyo imkaa kapmi aget uyo unang tinum imi aget kapmi kopkebip ita kup imi kobelap umdii, God iyo kapmi tok uyo bogolan-tema bele ki? Boyo? God imi ilak dolin binim imi aget uyo ilimi duubal imi kupka-em-nuubip kale, bilip imi kuguup uyo kubaganuta minte, kapmi kuguup boyo uta uta kelan-temaalu kale, bota God iyo kapmi tok uyo bogolan-temaala ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Minte kanube kabo asit kek kek iyo imkaa kapmi unang tinum imi kuguup tambal kopkebip ita kup tambal kobelap umdii God iyo utamata e, God nimi ilak dolin binim unang tinum igil mungkup kanum-nuubip kalaa agelan-tema uyo, kapmi tok uyo bogolan-temaala ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Minte kanube kabo mufekmufek umaak ku kapkumal imi kobe-nalap e, aget fugunolap, ‘Suukta, isiik ki yan kep-naman-temip o,’ agelap umdii, God iyo kapmi tok uyo bogolan-tema bele ki? Boyo? God imi ilak dolin binim igil mungkup mufekmufek umaak ku ipkumal imi kobe-nilip e, aget fugunolip, ‘Suukta, isiik ki yan kep-naman-temip o,’ agan-nuubip kale, bilip imi kuguup uyo kubaganuta minte, kapmi kuguup boyo uta uta kelan-temaalu kale, bota God iyo kapmi tok uyo bogolan-temaala ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kale God iyo unang tinum God imi ilak dolin binim isino e minte unang tinum kuguup mafak waafulin isino bilip iyo ki i-filin daa-nalata, bet bubul kupka-em-nuuba kale, God imi ilak dolin binim imi kuguup kubaganu kapmi kuguup uta uta kemin uyo kanubeta kale, waasi iyo i-filin daa-nalap e, kuguup tambal ke-e-bom-nalap e, mufekmufek kapkumal kobe bogo-nalap, ‘Nugumal ipsiik kululip suukta minte, ipsiik yan kep-namin o,’ agan-kalin binim ke no kemal o ageta ko. Kanupmin kup keman-temap uyo, God yagal yan kepke kuguup tambal kopkela e, kabo Atin Win Tibin God imi man ke nan-temap ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kapmi Kaalap God iyo ka-filin-bom bet bubul kupkake-bom no kem-nuuba kale, ulutap kale, asok kapkal kapkumal iyo i-filin-bom bet bubul kupka-e-bom no kemal o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yesus iyo asok bogopma, “Kabo, God imi abiin uyo ku-nilita, imi ogok ke-be boyo nisiik kuta ogok keman o agan-kalin ba ko. Kabo kapkumal iyo imkege-bom bogobe-nalap, ‘Ibo kuguup mafak ke-bilip o,’ agan-kalin ba kale, kupkalap umdii, God yagal kamkege-bom bogopke-nala, ‘Kabo kuguup mafak ke-balap o,’ agon-temaala ko. Aa mungkup utamapta, kapkumal iyo fenga kolip kalaa agelan-temap uyo, bogo-nalap, ‘God yagal yan kebe kaal fuyap kobelak o,’ agan-kalin ba kale, kupkalap umdii, God yagal yan kepke kaal fuyap kop-kaman-temaala ko. Kale minte kapkum imi yuum uyo kupkabelap binimanuk o ageta kale, kanubelap umdii, God yagal kapmi yuum uyo kupkapkela atin kup binimanan-temu ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kabo kapmi mufekmufek uyo kapkumal iyo misiim kupka-eman-temap uyo, God yagal mufekmufek uyo misiim kupkakeman-tema no ko. God imi mufekmufek tambal kupkakemin uyo men abumin ulutap kale, yagal fomtuup abu-nala e, ilip ilip bala daak nagat molu e, maak so kulep yak abu-balata, dongen ko segela tebelu kalaa age-nalata, kupkakeman-tema ko. Kale God imi mufekmufek kupkakeman-tema uyo, God yagal kapkumal imi mufekmufek kupka-em-nuubap umi tiyuuk ulutap kupkakeman-tema (ko. Kale God iyo, kuguup tambal kop-kaman o agan-be kale, aa mungkup kapkal kuguup tambal uyo kapkumal kupka-e-balapta) o,” age Yesus iyo bogobe-nala e minte, ");
INSERT INTO tlf_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","do weng maak bogobela, “Tinum tiin tugul iyo maak tebe ipkum maak tiin tugul iyo ilep kafalem unoma bele ki? Umbae. Kanuman-tema bole, alop maagup faala daak kafin tem unon-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kale man kangkang bilip iyo skul kafalmin mufekmufek uyo tele utabaalip binim kale, ilimi tiksa ko age kafalemin tinum ita tele utamsa kale, ita kafale-balata, man kangkang iyo utaman-bilip kale, biilu uyo, man kangkang igil utamipta e, tii dagaa kulup kalaa age-nilipta, igil ilimi kafalemin tinum ilitap kelan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Kapmi kapkumal imi kuguup mafak kangkang iyo ifip olol te tiin tem iina ilatap kale minte, kapmi kuguup mafak kwiin kiim kanu-balap bota minte at daang tiin ulaa kupkelu ulutap kuta, kapmi kapkum iyo bogobe-nalap e, ‘Tiin ifip olol o,’ agan-nuubap kale minte, aget fuguno-nalap e, ‘At daang tiin ulaa kupnelu boyo kuun kale, binimanepnelan-temu o,’ agan-nuubap ko. Kabo kapmi kapkumal imi kuguup mafak kangkang bota utamsap kuta, kalapmi kuguup mafak kwiin kiim kanum-nuubap uyo kabo utamsaalap aga? ");
INSERT INTO tlf_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Intaben o age-nalapta, kapkum iyo bogobe-nalap e, ‘Nugum kabaa. Niyo dong dogopke-nili tiin ifip olol beyo dupkan kep-kaman o,’ agan-balap kuta minte, at daang tebe kapmi tiin uyo ulaa kupkelu tiin tugul ke-salap bole, dogobe-nalapta, dong dogobelan-temap a? Kale kabo kuguup mafak kwiin kiim boyo kem-nuubap kale, kapmi kanupmin weng boyo bisop bagan-balap kale, kabo kapkum iyo dong dogopman-temaalap ko. Kale kamaki uyo kapmi aget uyo fupkela ko-nalap, boyo fengmin kalaa age bo kupkaa mitam tii ke-nalapta, kalapmi duup iyo dong daga-eman-temap o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Kale Yesus iyo do weng migik maak bogobe-nala e, “Ibo at dum abumin umi kuguup uyo utamin. At dum tambal abumin uyo aaltam kota asok at dum mafak uyo abulan-temaalu e minte, at dum mafak abumin uyo aaltam kota asok at dum tambal uyo abulan-temaalu no kale, ");
INSERT INTO tlf_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","nuyo at maak tebelu utamamup te tam dum uyo abuluta, utamupta, boyo te tam dum tambal abulu kalaa, dum mafak abulu kalaa agan-nuubup kale, nuyo yangta, tiyuup umi diim uyo yet dum abubu kalaa age dagaa kulan-temaalup e minte, yangta, misiil sok umi diim uyo kugalap uyo abubu kalaa ageta dagaa kulan-temaalup binim no ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ulutap kale, nuyo tinum itamupta, dogonupmin dogonupmin kuguup uta kanum-nuubip kalaa agelup bole, nuyo utamupta, imi aget fugunin uyo kanupmin atamta, boyo kanum-nuubip kalaa agelan-temup kale, tinum tambal iyo aget fugunin tambal so kale, iyo kuguup tambal kup ke-bom-nilip e, weng tambal kup baga-bom no kem-nuubip kale minte, tinum mafak ita aget fugunin mafak kup ke-bom-nilip e, weng mafak kup baga-bom-nilip e, kuguup mafak kup ke-bom no kem-nuubip o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yesus iyo bogopma, “Ibo nimi win uyo suun kup bogopne-nilip, ‘Kamogim o,’ nagan-kalin kup bomip kuta, ibo intaben o age-nilipta, nimi weng uyo tinangkamin binim a? ");
INSERT INTO tlf_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Tinum nimi finang tal nimi weng tinangka-bom minte nimi kuguup waafu-bom no kem-nuuba beyo, niyo bemi sang uyo ibo bogobeli utamipta, dogonupmin tinum ita kalaa agelan-temip kale, ");
INSERT INTO tlf_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","kanube tinum beyo am tambal dinan-kalin tinum ilatap kale, no am kun uyo ugan-bii kulep tal to kupka-nala e, kafin uyo faga-bala unanbu daak kafin tem iinu kupka-nala e, am kun kulula unanbu daak unu kupka-nala e, am uyo de kola ulimal am iinom sina-bilip e, ok fagan mitop abuta, am uyo dalata kwep unon agin kelu kuta, am uyo tambaliim kup de-se kale, am uyo fomtuup kafin uyo waafuu mosu ko. ");
INSERT INTO tlf_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ale minte tinum maak nimi weng tolong uta kup dugamin kuta, nimi kuguup waafunamin binim tinum beta kafin diim am dinan-kalin tinum ilatap kale, kaang age am tambal dinan-kalin binim beyo am kun uyo kafin fogo-nalata ba kale, bisop kulep daak ku to de kolata ok fagan mitop-nulu e, am uyo maak fagaa balaa kwaalu yang kafin diim abelu e, ok tebe balata kulep daage un-suu o,” age Yesus iyo do weng uyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesus iyo alugum weng uyo unang tinum bogobela binimanu kupka-nala e, kota daage no abiip Kapeneam una ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kale Rom umi waasi dinan-kalin imi kamok kugol nin ilami ogok kemin tinum maagup maak imi aget afalik kobesa kale, iyo mafak ilin afek ku-nala e, kaanan o agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kale waasi dinin imi kamok iyo tolong dolata, unang tinum iyo Yesus imi sang bagan-bilip kalaa age tinangku-nala e, Juda kasel imi kamogimal iyo bogobe-nala e, “Ibo no-nilip Yesus iyo atam bogobelip, ‘Tal-nalap waasi dinan-kalin imi kamogim imi ogok kemin tinum beyo telela dolal o,’ agelin o,” age-nalata, imdala no-nilip e, ");
INSERT INTO tlf_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Yesus imi diim abe-nilip e, fomtuup Yesus iyo bogobe-nilip e, “Waasi dinan-kalin tinum imi kamok beyo Juda kasel numi aget kupka-e-bom ilami mani uta kulu numi ulotu am boyo molata, deebe-silip kale, beyo tinum tambal kale, kabo tal beyo dong dogobelal o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesus iyo tinum isino unip ko. Yesus iyo tal am mep so tal-bala e, waasi dinin imi kamok imi duup iyo imdala no Yesus bogobe-nilip e, “Kamogim kabaa. Waasi dinan-kalin tinum imi kamok iyo bogo-nala e, ‘Niyo fengmin tinum kale, Kamogim kabo kamtamo no nimi am uyo unon-temaali kalaa age-nilita, ");
INSERT INTO tlf_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","tinum tambal kelita, kapmi finang uyo no talaali kale, kabo kugol mo-nalapta, weng uta kup bogolapta, nimi ogok kemin tinum am kagal alba keyo asok tambalanak o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nagal niyo waasi dinan-kalin tinum imi dubom imi iip tinum kale, imi weng kup tinangkan-bomi minte, niyo waasi dinan-kalin tinum ilimi kup wan handret (100) imi kamogim no kale, nimi weng uyo tinangkan-bomip kale, niyo tinum maak bogobe-nili, “Kabo unaal a,” agelan-temi uyo, iyo unon-tema e minte, tinum maak bogobe-nili, “Kabo talaal a,” agelan-temi uyo, iyo tolon-tema e minte, nimi ogok kemin tinum iyo bogobe-nili, “Kabo ogok boyo kemal o,” age bogobelan-temi uyo, ogok boyo keman-tema no (kale, ulutap kale, utamita e, kabo titil so kale, kabo weng uta kup bogolapta, nimi ogok kemin tinum keyo tambalanan-tema kalaa agan-bii) o,’ agela tulup o,” age Yesus imi bogobelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kale waasi dinin imi kamok imi weng kwaala tulu uyo Yesus ita tolong do-nala e, kota iyo kumang mo-nala e, fupkela unang tinum kwiin tagang umik tem talan-bilip iyo bogobe-nala e, “Niyo weng maak bogobelan o ageta kale, tinangku-silipta. Israel kasel ko age Juda kasel imi aget fugun-bom-nilip, ‘Nuyo God imi man iyo kalbup o,’ agan-nuubip kuta, niyo iyo maak atamita, beyo nitamata, Yesus iyo tii kanubelan-tema kalaa agan-be kalaa age atamsaali kale minte, Rom kayaak keta atin ki nitamata, Yesus beyo tii weng uta kup bogolata, nimi ogok kemin tinum mafak bom am katam alba keyo tambalanan-tema kalaa age-nalata, weng kwaala tulu kale, bemi nimi ilak dugamin uyo kwiin kiim keluta minte, alugum Juda kasel imi nimi ilak dugamin uyo kubaganu o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kale waasi dinan-kalin tinum imi kamok imdala tilip tinum iyo asok no kamok imi am tal-nilip e, kamok imi ogok kemin tinum iyo tambalana kalaa agelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Siit-nala e, Yesus iyo abiip Nain kutam iinon o age-nala e, ilami okumop man isino minte unang tinum kwiin tagang so maagup dagaa dep unip ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kale Yesus ninggil iyo unanbu no abiip umi daam tem umi faal mep so no abomu, Nain kasel igil, tinum maak kaanba iyo dubalum o age ade dep talan-bilip kalaa agelip ko. Kale tinum kaanba imi ogen uyo unang kaluun kale, umi man tinum iyo yaan maak kale, ogen ugol man ilet tem ade dep talan-bilip imi umik tem kugol talan-bulu e, umi umik tem uyo unang tinum kwiin tagang igil talan-bilip ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kale Kamogim Yesus iyo unang boyo utam-nala e, fomtuup ku-filin daa-nala e, bogobela ko. “Ogen kubaa. Amemin ba o,” age-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","yang ilet umi mep so no-nala e, agol kup sagaal kwep yak tinum kaanba imi ilet diim melebela e, tinum ade duptamo talan-bilip iyo kugol molip e, Yesus iyo tinum kaanba beyo bogopma, “Man tinum maat kabaa. Kabo fenal o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","kota tinum kaanba iyo fen mitam ton-nala e, weng bagama ko. Kale Yesus iyo ogen bogobe-nala e, “Ogen kubaa. Kupmi man fena ketam o,” age-nala e, ogen umi dobela ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kale alugum unang tinum iyo Yesus imi kanubela uyo utam-nilip e, alugum finanin kiim uyo ke-bom-nilip e, God imi win uyo kufu-e-bom-nilip e minte, iip maak maak ita bogolip, “God imi profet ko age weng kem baga-emin tinum iyo tal numi iibak tem kal mola atamup o,” agelip e minte, iip maak maak ita bogolip, “God ita tal, ilami unang tinum nuyo ulaa imdula waalanin o age-nalata, yagal tala o,” agan-kalip no ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Unang tinum iyo alugum Yesus kanupma umi sang uta kup baga-bilip e, weng yakyak kem no Provins Yuudiya umi abiip maak maak so e minte unanbu yang kek kek imi abiip maak maak sino weng yakyak unu tinangkamip ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ok sam uga-emin tinum Jon Baptis iyo sok de do dep kalabus am daalip bom-bala e, Jon imi okumop man iyo tal-nilip e, Yesus kanu-be umi sang uta Jon iyo baga-emip ko. Kale Jon iyo ilami okumop man alop maak ulaa imdu ");
INSERT INTO tlf_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","20","imdala no Yesus bogobelip, “Ok sam uga-emin tinum Jon Baptis iyo weng maak kobe-nalata, nuyo imdala tulup kale, beyo bogo-nala, ‘Kabo ki fen dam God tebe ulaa kamdu kamdala ti-salap tinum bele, nuyo tinum migik iyo maak fen-sulupta, tolon-tema o?’ age Jon ita kam age dagala o,” agelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kale alop talbip kota, Yesus iyo kaal mimin kwan-bilip unang tinum iyo telele-bom-nala e, mafak ilin mafak kwan unsip unang tinum iyo telele-bom-nala e, sinik mafak kwan unsip iyo kupkan ke-e-bom-nala e, tiin mafak kem unsip iyo tiin telele-bom no ke-bala e, ");
INSERT INTO tlf_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jon imi okumop man alop iyo utamamip e, Yesus iyo bogobela, “Niyo ogok ke-bilita, tiin bigibesu imi tiin uyo baabelu tiin daga-bala, ibiit iyo tambalan mo mo tiine-bala, kaal mafak kesip iyo asok tambalana-bala, tolong kom iyo bam daa asok tolong duga-bala, tinum kaanip iyo asok fena-bala, minte tinum usap manal iyo God imi weng tambal uyo baga-e-bili tinangka-bala no kemip ibo utamip kale, alop ibo no-nilip Jon imi diim uyo ipmi kanupmin ko utamip so tolong dolip so bomi sang uyo bogobelipta, iyo tinangku bam daata, niyo waanta kalaa agelak o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kale tinum iyo dok ita nimi kanupmin kuguup kaa kanu-bii umi aget uyo fomtuup fugun-bom bogo-nala, ‘Yesus beta God iyo ulaa daala ti-se o,’ age-nala imi aget uyo alop tagamin binim kema umdii, beta tambaliim kup nan-tema ko. (Kale alop ibo no-nilip Jon iyo alugum bomi sang uyo bogobelipta, nimi deng uta kup tebe-bom bom-balata) o,” age Yesus iyo alop imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kale Jon imi kalaan tinum iyo daaginip e, Yesus iyo unang tinum kwiin tagang albip iyo Jon imi sang baga-ema ko. “Siin uyo ibo no iibaan kugol Jon imi finang un-silip uyo, intaben umaak utamum o ageta un-silip a? Ibo nota, dulul uyo tebe fuun-bulu magal kon fiit daga-bulu utamum o ageta un-silip a? Umbae. ");
INSERT INTO tlf_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Aa minte ibo, intaben umaak utamum o ageta un-silip a? Ibo aget fugunota, tinum maak ilim tambal uta kup migi-balata, ataman un-silip aga? Umbae. Jon iyo ilim tambal migimin tinum kulatap ba kwa. Tinum ilim tambal migimin ita kamok king imi am tambal tem kal bom-nilipta, tambal kup bomip kale minte, Jon beyo iibaan kugol suun kup boma kuba. ");
INSERT INTO tlf_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Aa minte ibo, intaben umaak utamum o ageta un-silip a? Ibo no God imi profet ko age weng kem baga-emin tinum iyo maak atamum o ageta un-silip aga? Aa. Jon beyo God imi profet kale, beyo alugum profet migik iyo kubaganipta, ita ita ke imkan kesa kuba. ");
INSERT INTO tlf_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kale boyo dok uta ba kale, God imi suuk kon tem weng uyo Jon imi sang uta sugayok bogo-nulu e, ‘God iyo ilami Man imi bogobe-nala e, “Nagal kafin diim tinum beyo ulaa dulita, nimi kalaan tinum kelata, besiik daali no unang tinum iyo bogobe-nala, ‘Kamogim iyo tolon-tema kale, ibo ipmi aget tem uyo telelmipta o,’ agan abe-salata minte, kapta aaltam umik tem unon-temap o,” age God iyo ilami Man imi bogobesa o,’ age God imi suuk kon tem weng uyo kam agesu ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kale niyo weng bogopman o ageta kale, tinangku-silipta. Tinum kafin diim kaa mitam tebesip iyo, tinum iyo maak tebe Jon imi nimi sang kwep tal baga-em-nak-be kalutap umaak ke-bomta kwep tal baga-em tebesaala binim kuta, unang tinum God imi daam tem mitam tolon-temip iyo ki, mafak man kan man kwiin tagang iyo mitam God imi mufekmufek so kuguup so uyo tele utam-nilipta, Jon imi tebe God imi kuguup utamsa uyo kubaganu ita ita kelan-temip o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Siin uyo unang tinum iyo alugum Jon imi weng uyo tolong do-silip kale, unang tinum win binim kelin sino takis mani kwaamin tinum sino imi aget fugunin uyo tambaliim kale, bogolip, “Aa. God imi weng uyo dam o,” age-nilip e, dagaa kulep tal Jon imi diim abelip e, ok sam uga-emsa kuta minte, ");
INSERT INTO tlf_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Falosi isino ulo utamsip kasel isino iyo aget fugunin tambal binim kale, iyo God imi weng uyo kupkege-bom-nilipta, God imi dong daga-emin uyo uk kugan ko-nilipta, Jon imi miit tem tal tamip Jon tebe ok sam ugobesaala ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesus iyo asok bogobe-nala e, “Kamano kaa albip ibo dogonupmin unang tinum albip a? Ibo tinum bisel ke fito-silip kuta, ibo man kangkang ilitap kuba. ");
INSERT INTO tlf_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Man kangkang iyo abiip mat kal ton-bom-nilip e, milii bagaa kulu ipkumal iyo olabe-nilip e, bogolip, ‘Nuyo, atol dagamin tap kemum o ageta aseng kwaa-bom-nulup e, ot bo-bom no ke-bulup kuta, ipta nusino atol dagamin binim ke-bilip ko. Minte nuyo, tinum kaana dubamin tap kemum o ageta aman-kulup kuta, ipta nusino amemin binim ke-bilip ko. Dogonupmin umi kuguup migik migik kanumin uyo kup-kugulupta, ibo, “Waago o,” age kulaa yakyak ke-bilip o,’ agan-nuubip ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ulutap kale, (ibo Jon iyo, ‘Waago o,’ age som-nilip e minte, niyo, ‘Waago o,’ nage no kem-nuubip kale,) Jon imi aget fugunin uyo, God yagal bogopne-nala e, ‘Kanupmin unan-kalin boyo kabo unan-kalin ba o,’ nage-se kalaa age-nala fala-bilita, God iyo nimi deng uyo tebemak o age-nalata, unan-kalin maak maak so sok dum ok so uyo suun kup falamin kup kemsa kuta, tal kanu-balata, ibo atam-nilipta, bogo-nilip e, ‘Tinum beyo sinik mafak tebe dufak daaluta, unan-kalin boyo suun kup falam-nuuba o,’ agan-nuubip ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kale minte Mo Tibil imi Man niyo tal-nili e, iman so sok dum ok so umaak amem kalaa age-nilita, kupkasaali kale, alugum ipmi iman unan-nuubip boyo unan tebesi kuta, ibo bogo-nilip e, ‘Ibaa. Abuyap be atamin. (Juda kasel numi kuguup uyo unan-kalin uyo fala fala ke-bom God imi beten uta kup ke-emin kuta, Yesus beyo maak kanumin binim kale,) beyo takis mani kwaamin tinum so kuguup mafak waafulin tinum migik so imi duup o,’ agan-nuubip ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tinum dok ita God imi kuguup tambal uta kup kema umdii, bota tebe kafalebeluta, kek kek iyo atamipta e, beyo tebe God iyo tele utamsa tinum atamta, nuyo felepmuta, te yak imi kuguup tambal uyo waafulan-temup kalaa agelan-temip o,” age Yesus iyo kam age baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Falosi maak Yesus imi bogobe-nala e, “Kabo talapta, nimi am kal nisino alop iman unelum o,” agelata, no Falosi imi am kal ton-bom iman un-silip e, ");
INSERT INTO tlf_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","sa dagamin unang maak abiip kugol albu kale, tolong doluta, “Yesus iyo Falosi am kal iman unan-be o,” agelip kalaa age-nulu e, tam tuum kalosip tet tem tang tambal kuunin ok uyo ilu kuptamo-nulu e, tulu ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tal Yesus imi miit tem mep so kugol katuun duung fegela daak ton-nulu e, agol kup amemu e, umi tiin ak singkam daa te daak Yesus yaan diim abelu e, uyo ulumi dubom kon timitim uta kulu Yesus yaan diim tiin ak daak abelu uyo tolobe-nulu e, king win kufu-emin kuguup uta ku Yesus imi yaan uyo fiil buube-bom-nulu e, “Suguul o. Nimi Kamogim o,” agan-bom-nulu e, kota tang tambal kuunin ok umdii sing daa kwaapmu daak Yesus imi yaan diim abemu ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Falosi imi Yesus bogobe-nala, “Talapta, iman unelum o,” ageba iyo unang umi kanupmin kuguup boyo utam-nalata, yagal aget fuguna ko. “Kanupmin unang boyo sa dagamin unang kale, tinum keyo aafen God imi weng kem baga-emin tinum iyo maak nimnam, yagal utamata, dogonupmin unang uta melepne-bo kalaa agan-be kuta, utabaala o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesus iyo Falosi imi aget fugun-be uyo utam-nala e, bogopma, “Saimon kabaa. Niyo weng maak bogop-kaman-temi o,” agela e, Saimon isiik bogopina, “Aa. God imi weng kafalemin kabo bogopnelal o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesus isiik do weng maak bogopma, “Tinum alop maak tebe no mani yuum kupka-emin tinum iyo dagalip kobela kale, tinum maak imi yuum uyo K100 e minte, tinum maak imi yuum uta K10 uta kup no kale, ");
INSERT INTO tlf_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","tinum alop iyo yuum boyo mo-nimip binim kelip kuta, asok tinum beyo alop imi yuum uyo kupkapma ko. Tinum alop kuta, maagup ita mani tiin molin tinum bemi aget kup kopma kale, waanta o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon isiik bogopma, “Nimi aget fugun-bii uyo, tinum bemi yuum afek molin-tem kela mani tiin molin tinum tebe kupkabela tinum beta mani tiin molin tinum bemi aget kup kopma kalaa agan-bii o,” agela e minte, Yesus iyo imi bogopma, “Kota kapmi aget fugunin uyo tol kepkelu o,” age-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","fupkela kek fen unang uyo kul dil fagaa kobe-nala e, Saimon imi bogopma, “Kabo unang koyo kagal utamap aga? Niyo mitam kapmi am e tili kuta, kabo numi kuguup uyo waafuu kapmi ogok kemin tinum iyo daalap talta ok umaak kuta nimi yaan uyo diing daap-namin-tem kale minte, unang kota ulumi tiin ak uta kuluta nimi yaan koyo diing daapne-nulu e minte, ulumi dubom kon timitim uta kulu nimi yaan diim tiin ak uyo tolopne no kelu ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tal am katam e tili uyo, kabo fital tinum tala iyo fet duga-bom fiil buubemin kuguup umaak kopnelap utamin-tem kale minte, unang bota nimi yaan uyo fil buupnem kwep tal kaa diibelu ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kabo numi kuguup uyo waafuu oliv dum umi tugul ok uyo ku nimi dubom uyo tolop-namin-tem kale minte, unang kota tang tambal kuunin ok uyo ku nimi yaan uyo tolopnelu ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kanubelu kale, tinangku-salapta, bogopkelan o ageta ko. Unang koyo utamuta e, niyo kuguup mafak uyo kanum-nuubi kalaa age-nulu e, Yesus beyo nimi yuum afek uyo takan kepneba kalaa age-nuluta, boyo nimi aget afek kopne-nuluta, kanupmin boyo kanupnelu ko. Kuta kanube tinum iyo maak aget fugunolata, yuum katip ke-bii ko agela umdii, kupkabelan-temi kuta, kanupmin tinum beyo nimi aget katip dopnelan-tema o,” age Yesus iyo Saimon ilami sang uyo bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kale kota Yesus iyo unang umi bogopma, “Niyo dam weng bogop-kaman-temi kale, kupmi fengmin boyo kupkapkeli o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","kek kek tonan unbip iyo bogobina tala ke-bom-nilip e, bogolip, “Beyo dogonupmin tinum ita, ‘Fengmin uyo kupkapmi o,’ agan-be tinum o?” agan-bilip e minte, ");
INSERT INTO tlf_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesus iyo unang umi bogobela, “Kubo nimi ilak dolap kale, God iyo telela kamola kale, tambaliim kup no bom-balapta o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Bii ilugo-nala e, Yesus iyo no abiip afek afek sino abiip kangkang so ku-tele tiine-bom-nala e, kutam iyo God imi weng tambal uyo baga-e-bom-nala e, “Ibo aget fupkela ko fengmin uyo kupkalan-temip uyo, God iyo ipmi fengmin uyo kupkabe-nalata, imdep tam ilami daam tem daa-nalata, tiin molan-tema o,” agan-kala ko. Kale ilami okumop man tuluun kal so ");
INSERT INTO tlf_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","unang iip maak maak sino mangkal iyo Yesus isino yak abiip maak maak unip ko. Kale unang bilip iyo, siin uyo iip maak maak iyo mafak ilin yaafusu kale minte, iip maak maak ita sinik mafak kugan unsip no kale, Yesus iyo tebe telela imo-se, kale mangkal iyo ilimi mani uta kulep no-nilip e, iman saan-bii ko fuu-bom-nilip e, Yesus so minte ilami okumop man isino kobelip e, ninggil iyo unan tebesip ko. Kale unang maak uyo abiip Makdala kayaak unang Maria kale, Yesus iyo sinik mafak ilimi kup ban kal boyo kupkan kebe-se ko. Minte maak umi win uyo Joana kale, umi imak Kusa iyo King Herot am afalik umi un tubulin imi tiin molin tinum ko. Minte maak umi win uyo Susana kale, unang kwiin tagang maak ita Yesus imi daang begebe tiinemip ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Unang tinum kwiin tagang imi abiip uyo kupkaa Yesus imi finang tala tala ke-bilip e, Yesus iyo utamata e, unang tinum kwiin tagang kelip kalaa age-nala e, kota do weng uyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Tinum maak iyo rais ko age wiit umi san uyo kulep no ilanggiip kugol segelam una ko. Kale san uyo segelam tiine-bala e, san iip maak maak uyo daak ilanggiip umi ilep kem diim kubelu e, uun tebe unelip e minte, tinum iyo tiine-bom te tamaga-bilip mafaganu no kelu ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Minte san iip maak maak uyo daak tuum tip diim abe bigin tebelu kuta, tuum diim uyo ok binim kale, tebe-nulu e, asok datanu ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Minte san iip maak maak uyo daak ifuul mafak umi iibak tem abelu e, ifuul san so wiit san so maagup tebe-nulu e, ifuul mafak uta uta kelu e, ditutan mafaganu ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Minte san iip maak maak uyo daak kafin tambal diim abe tambaliim tebe-nulu e, abu-bii ko-nulu e, talkun kun maagup diim kwegal 100 abulu abulu kem unu o,” age-nala e minte, bogola, “Ibo tolong kom ba kale, tolong tambal kale, weng ko bogobeli boyo tele tolong do-nilipta, dagaa kulin o,” age baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yesus imi okumop man iyo imi weng uyo tolong do-nilip e, dagalip, “Kamogim kabaa. Nuyo kapmi weng boyo tele bam daalin-tem kale, kabo bomi magam uyo bogobe bam daa imolal a,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesus iyo bogopma, “Siin uyo God iyo unang tinum ilami daam tem mitam tilip tiin molan-tema umi sang uyo alugum baga-emsaala kale, atuk uta kup kale, kamano koyo God yagal ipmi aget tem uyo bam daabela ipkil utamipta e, Yesus imi do weng ko baga-e-be bomi magam uyo tam God imi daam tem unup tiin molan-tema umi sang uta kalaa age utabip kuta minte, tinum migik migik ita nimi ogok telela-bii boyo ilimi tiin fala utaman-nuubip kuta, iyo utamipta, boyo fen kalaa agan-nuubaalip binim e minte, ilimi tolong alop uyo nimi weng boyo tolong dugan-nuubip kuta, iyo utamipta, weng bomi magam uyo kulbu kalaa agan-nuubaalip binim no kalaa age-nilita, nagal do weng boyo kanupmin tinum bilip imi baga-em-nuubi o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Kale Yesus iyo bogobe-nala e, “Do weng bogobeli bomi magam uyo kulbu kale, tam wiit san boyo God imi weng ulutap kale, ");
INSERT INTO tlf_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","san iip maak maak uyo segela daak ilep abelu uun tebe unelip kale, mungkup ulutap tinum iip maak maak iyo God imi weng uyo tolong dolip e, Saatan iyo uun imi kuguup ulutap ke tal-nala e, God imi weng aget tem kwek albu uyo dagaa kupkan kebela kale, bilip iyo weng uyo ilumanebelu kale, dogobeta God imi ilak uyo dolipta, telela imolan-temaala ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Minte san iip maak maak uyo segela daak tuum tip diim abe bigin tebe asok datanu kale, mungkup ulutap tinum iip maak maak iyo God imi weng tolong do-nilip e, ‘Aafen o,’ age deng tebeman-temip kuta, san kolap bigin tebelan-temu kuta, timtim binim ulutap kale, God imi weng uyo waafulan-temip kuta, fomtuup kwep yak iibak tem daalan-temaalip ko. Kale God imi ilak uyo waafu-bom-silip Saatan tal im-kuguman-tema uyo, kupkaa yang iinon-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Minte san iip maak maak uyo segela daak ifuul mafak umi iibak tem iinom tebe ditutan mafaganu kale, mungkup ulutap tinum iip maak maak iyo God imi weng uyo tolong dolan-temip kuta, kafin diim komi mufekmufek duumatanan-temip umi aget afek fugunin min, mani kwaamin min, kanumin kanumin kuguup kanu-bom deng tebemin uta kale, kanupmin aget fugunin uta afaligen ke-nuluta, God imi weng aget uyo kubaganu kupkalan-temu kale, wiit umi dam binim, ol kup kelu ulutap ke-nilipta, God imi weng uyo fomtuup dital fagaa waafulan-temaalip ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Kale minte san iip maak maak uyo segela daak kafin tambal diim abe tambaliim tebe abulu kale, mungkup ulutap tinum iip maak maak iyo God imi weng tolong do-nilip e, ilumanolan-temaalip kale, fomtuup aget tem kwaak abu-nilip e, God imi weng uyo suun kup waafuu kanuman-temip ko. Kale kanumin boyo wiit kwek umi 100 abubu ulutap o,” age Yesus iyo do weng bomi magam uyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Asok Yesus iyo tebe do weng migik maak bogobe-nala e, “Tinum dok ita ilaam uyo kefo ko kwep daak baket tem kulagal kubalan-temaala binim e minte, kefo kwep daak bet afak tem daalan-temaala no kale, kefo kwep tam ulumi baan diim daalata, am uyo ilagenuta, unang tinum iyo mitamta mufekmufek uyo tambaliim utaman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Biilu am afungen daanan-temu kota, nimi mufekmufek sang so weng magam so bantap kuba-bom-nili felep yak ku to do weng uta kup baga-em tebesi uyo God yagal kwep mitam kupkem daalata, alugum unang tinum iyo utaman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Kale kanupmin weng ko bogopmi boyo, ibo God imi weng alugum boyo tele tolong duga-bom-nilipta o ageta ko. Tinum iyo dok ita nimi weng uyo tolong do dagaa kula umdii, beyo God tebe dong daga-e-bala dagaa ku yakyak kem unon-tema kale minte, tinum iyo dok ita nimi weng uyo tele tolong dolin-tem kela kuta, ‘Utamsi o,’ agela umdii, bemi kamaki kutop umi katip ko atam-se boyo yuut ilumanepman-temu o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kota Yesus imi ogen sino nagalal ninggil sino uptil iyo, Yesus imi finang tulum o age talta e, unang tinum kwiin tagang tebe Yesus iyo fufala dolip kalaa age-nilip e, kwiin bota dogap-tele yangta, Yesus imi miit tem uyo unum o agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kale tinum maak kutam albip iyo Yesus imi bogobe-nilip e, “Nugum kabaa. Kapmi kogen sino nagalal ninggil sino uptil iyo tal, katamum o ageta talta abiip kal mobip o,” agelip kuta, ");
INSERT INTO tlf_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","isiik bilip imi weng uyo yan kebe-nala e, bogola, “Unang tinum iyo God imi weng tinangku waafulip umdii, bilip ita nimi aben e minte nagalal ninggil no ilitap o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Am maak daanu e, Yesus so imi okumop man so ninggil iyo tam bot tem unip e, Yesus iyo bogobe-nala e, “Tilip ninggil koyo kupkaa bot tem ilep yak ok muk afalik umi milii katam iinum o,” agela e, ninggil iyo bot tem ilep unip ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kale ninggil iyo abe-bom-nilip e, Yesus iyo agaal una e, ninggil iyo unanbu yak ok mat iip kuunip e, kota dulul kiim maak amdu tigiin kutam ilo malaak ok muk daang kun diim malaak abuta, ok uyo ifo kulalu bot tem iinu e, bot uyo iluman-nulu e, daak ok tem iinom ninggil iyo inolan agin kelu e, ");
INSERT INTO tlf_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","kota Yesus iyo dufo-nilip e, bogobelip, “Numi kamok kabaa. Nuyo mep so anolu kaanum o angbup kale, yuut fenal o,” agelip e, Yesus iyo fen-nala e, dulul sino ok fagan-bo so uyo weng bogobe-nala e, “Sining agelal o,” agela e, biliit age binimanu ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kota Yesus iyo imi okumop man imi bogobe-nala e, “Ibo nitamta, Kamogim bemi nuso alba boyo kaal binim kalaa nagebaalip aga? Intaben o ageta dulul sino ok sino bomi atul uyo finan-bilip o?” agela e, kota ninggil iyo Yesus imi atul finano-nilip e, kumang muuna tala ke-bom-nilip e, bogolip ko. “Keyo dogonupmin tinum ita tebe-nalata, weng uta kup bagam-salata, dulul so ok sino uyo imi weng uta kup tinangku-nuluta, binimanu o?” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kota Yesus ninggil iyo Provins Galili uyo kupkaa bot tem ilep unanbu yak ok muk umi milii Gerasa kasel imi anang yak unip e, ");
INSERT INTO tlf_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","kota Yesus iyo bot tem uyo kupkaa daak ok kan tem mola e, tinum abiip kutam kayaak maak sinik mafak tebe dufak daasip iyo tal Yesus imi diim kal abu mola ko. Kale sugamiyok kutop uyo tinum beyo ilim tiimin binim minte, beyo tal am sinamin binim kale, iyo no begel ilet tem ko age tuum tem kugol sinan-nuubata ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Siin uyo sinik mafak tebe-nala e, tinum beyo dufak daga-balata, ipkumal iyo, “Dupka-sulup yem-nama o,” age-nilipta, ain sok ko age sen kulu tinum bemi sagaal alop so yaan alop so uyo sok deebe-nilip e, dep daa bigilup ko agelipta, sagaal sok so yaan sok so boyo ugela kulula unu e, sinik mafak tebe tinum beyo fot tebe daala unanbu no tinum binim iibaan bagan abela kale, suun kup kem-nuubata. Tinum beyo Yesus iyo atam-nala e, tal Yesus imi miit tem kal ol ban isin kumen daak kafin diim abe fomtuup olem-sala e, Yesus iyo sinik mafak imi bogobe-nala e, “Kabo tinum beyo dupkaa yak iinaal o,” agela e, sinik mafak beyo fomtuup ol-bom-nala e, bogola, “Yesus kabo Atin Win Tibin God imi Man aligaap kale, kabo talta, intaben nupnelan o age-nalapta, talap a? Kabo ni-filin daa-nalapta, niyo kaal fuyap afek uyo kupkanemin ba kale, nimkalal o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Kota Yesus iyo tinum beyo dagala ko. “Kapmi win uyo Intapnak o,” agela e, tinum beyo utamata, sinik mafak tagang iyo nimi iibak tem kegal albip kalaa age-nalata, bogo-nala e, “Nimi win uyo Yamyam o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Sinik mafak bilip iyo Yesus imi fomtuup ole-bom bogobe-nilip e, “Kabo nuyo fot tebelap unanbu daak kafin tem abiip mafak kulaak uyo unemin ba o,” agelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kale yak ilok maak kugol kong kwiin tagang maak buk faga-bom albip kale, sinik mafak bilip iyo Yesus imi fomtuup daga-nilip e, “Kabo nuyo imkalap yak kong bilip imi tilin tem iinum o,” agelip e, Yesus iyo, “O,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","sinik mafak iyo tinum beyo dupkaa mitam abe-nilip e, yak kong bilip imi tilin tem tam iinip e bole, kong igil ilum ilum ke-nilip e, ilok dup-kalaak mo unanbu daak Galili kumun tem kulaak iinom-nilip e, ok tebe mimilepmu kaanip ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kale tam kong tiin molin tinum iyo utamipta e, kong iyo kanube kaanip kalaa age-nilip e, yuut bilii no abiip miton tono, abiip kangkang tono baga-em tiine-bilip e, ");
INSERT INTO tlf_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","unang tinum iyo, no kanubelu boyo utamum o age-nilipta, tal abomu e, tinum sinik mafak tebe dupkaa yak iinip beyo kota ilim migi-nala e, imi aget fugunin uyo tambalanebelu e, Yesus imi miit tem kal tonba kalaa age-nilip e, kota iyo finanip ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kale unang tinum Yesus imi kuguup kanupma utamip ita ipkumal iyo baga-e-bom-nilipta, “Tinum beyo sinik mafak tebe dufak daasipta, Yesus ita kanube telela dolata, tambalana o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gerasa kasel unang tinum iyo finano-nilipta, Yesus iyo bogobe-nilip e, “Kabo nuyo imkaa unaal o,” agelipta, Yesus iyo imi weng kup tinangku-nalata, tam bot tem ton-nala e, daaginum o agela e, ");
INSERT INTO tlf_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","tinum sinik mafak dupkaa yak iinip iyo tal Yesus imi fomtuup daga-nala e, “Nimkalapta, niyo kapsino unum o,” agela e, minte Yesus isiik bogobe-nala e, “E-e. Kabo no asok kalapmi abiip no-nalapta, God imi mufekmufek kwiin kiim kanupkela uyo kupkem daga-bom-nalap kapkumal unang tinum iyo baga-em kwep unaal o,” age-nala e, tinum beyo daala no imi abiip kasel alugum imi bogobe-nala e, “Yesus iyo mufekmufek kwiin kiim maak telela namoba o,” agan tiinema ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Unang tinum iyo Yesus imi bigi-bom-bilipta, Yesus iyo asok Galili Ok Muk umi milii talata bole, unang tinum iyo deng tebe-bomta fet duga-emsip ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Tam abiip kugol nin tinum maak bemi win uyo Jairus kale, beyo abiip bomi ulotu tiin molin tinum maak kale, beyo tal Yesus mep sino kal katuun duung fegela daak ton-nala e, fomtuup Yesus iyo dagala ko. “Niyo man unang maagup yaan maak kale, umi atol uyo tuluun kal kale, mafak umo-nuluta, kota kaanan o agan-suluta, kupkaa tili kale, talapta, alop no nalami am kal albu kale, dong dogobelal o,” agela e, Yesus sino Jairus sino alop unip ko. Yesus iyo abe-balata, unang tinum kwiin tagang iyo Yesus iyo falala dep iibak kalaak daa unan-bilip kale, ");
INSERT INTO tlf_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","bilip imi iibak tem kwek uyo unang maak albu boyo suun kup ulumi am tem unemin kup nuubuta, tam daage no dokta kwiin tagang iyo saan-bulu dong daga-em-nuubip kuta, tinum maak tebe-nalata, umi mafak ilin boyo telela ko-nama binim kale, atol tuluun kal kesuta bole, ");
INSERT INTO tlf_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","unang tinum kwiin tagang iyo imdep kega kega ke-nulu e, tal Yesus imi mep so umik tem ko mo-nulu e, aget fugunoluta, iyo telela namola tambalanan-temi kalaa age-nulu e, umi sagaal uyo maagalo kwep yak Yesus imi ilim magaang uyo melebelu e bole, umi mafak ilin uyo yuut binimanepmu ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesus iyo bogo-nala e, “Waantap ita melepnela o?” agela e, alugum iyo bogo-nilip e, “Naga ba o,” agela agela kelip e, Fita iyo bogobe-nala e, “Kamogim kabaa. Unang tinum kwiin tagang iyo mo-nilip e, kamdep iibak tem daa de kamobip koyo, intaben o ageta boyo bogolap o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yesus iyo bogola, “Alugum bilip igi ba kale, niyo utamita, nimi titil atuk uyo nimkaa yak iinu kalaa ageli kale, niyo utamita, maagup maak tebe, ‘Kanubelita, dong dogopnelak o,’ age-nalata naafula nimi titil uyo dong dogobelu kalaa ageli o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Unang boyo utamuta e, bantap kelaalu kale, Yesus iyo kem nitama kalaa age-nuluta, bamban keng keng ke-bom meng Yesus imi miit tem kal katuun duung fegela daak ton-nulu e, tam unang tinum imi tiin diim uyo bogolu ko. “Niyo suun kup nalami am tem unemin kup nuubi kalaa ageta nimi sagaal uyo ku-nilita, melepkelita, kapmi titil uta yuut telela namolu tambalani o,” agelu e, ");
INSERT INTO tlf_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesus iyo bogobe-nala e, “Unang kubaa. Kubo aget fugunolapta, beyo fen telela namolan-tema kalaa nagelap kalaa age-nilita, telela kamoli tambalanap kale, kupmi aget tem uyo bilili age-nalapta, no tambaliim kup bom-balapta o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesus iyo unang boyo weng kupka-e-bom bom-salata, tam ulotu tiin molin Jairus imi am ogok kemin tinum maak tal Jairus imi bogobela ko. “Kapmi man unang uyo kaanu kale, kabo God imi weng kafalemin tinum beyo bisop uyo dep te no telemin ba o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesus iyo tinangku-nala e, Jairus imi bogobela ko. “Kabo finanin ba kale, nitamapta, beyo tii nimi man uyo telela kolan-tema kalaa nagelapta, kapmi man uyo asok fenepkeluk o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesus iyo no Jairus imi am mep so no-nala e, unang tinum iso tilip iyo bogobe-nala e, “Ibo nisino tam am uyo tam unemin ba o,” age-nala e, tam Fita so Jon so Jems so man ulumi ogen aalap isino ita kup Yesus iyo kulep tam am uyo tam una e, ");
INSERT INTO tlf_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","unang tinum iyo abiip kal bom ame-bilipta, Yesus iyo tam abiip kal bogobe-nala e, “Ibaa. Man boyo amiit kaanbaalu kale, boyo aminbu ulutap kebu kale, ibo amemin ba o,” agela kale, ");
INSERT INTO tlf_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","alugum iyo utamipta e, man unang uyo kaanbu kalaa age-nilip e, beyo bisop bagan-be o age aban dii-e-bilipta, ");
INSERT INTO tlf_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yesus iyo imkaa tam-nala e, man unang umi sagaal uyo waafube-nala e, umi sinik uyo olabe bogola ko. “Man unang kubaa. Fenal o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","tam man unang umi sinik uyo asok tal tiibaluta bole, man unang uyo yuut fenu e, Yesus iyo tam man unang umi amalap iyo bogobe-nala e, “Unan-kalin maak man boyo kobelip uneluk o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","man unang um amalap iyo kumang mo deng taban-bilip kuta, Yesus iyo fomtuup bogobela ko. “Migim ibo no unang maagup tinum maagup iyo maak baga-emin ba o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesus iyo okumop man tuluun kal iyo olabela alugum tal mep so tilip e, tam ilami titil uyo kobe-nala e, bogobela, “Nimi win tolop diim uta alugum sinik mafak uyo fot tebe-bom-nilip e minte, unang tinum mafak ilin migik migik umkan unsip uyo kupkan ke-e-bom no kem unin o,” age-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","imi okumop man iyo maak so bogobela ko. “Ibo no unang tinum iyo bogobe-nilip e, ‘Ibo God imi ilak uyo fomtuup do-nilipta, mitam God imi daam tem tilin o,’ agan-bom-nilip e minte, unang tinum mafak ilin iyo telela imka-bom no kem tam tam tiine-bilipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Unon-temip uyo, mufekmufek uyo maak kulep unemin ba ko. Tam kafung min, iman men min, bret min, mani min umaak kulep unemin ba kale, bisop unin a. Minte ilim maagup tiibip bota kup unin o ageta ko. Tam ibo unang tinum iyo dong dogobelip minte, isiik, dong dogobelum o agelip uyo, isiik ibo mufekmufek uyo kopman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tam ibo unanbu no abiip maak no unip uyo, am maagup uta kup kutam kal bom unang tinum iyo dong daga-e-bii-nilip e, abiip boyo kupkaa unin o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kuta abiip kasel iyo imdep tam daa tiin momin binim kelip uyo, ibo asok yang abiip mat kal mo-nilip e, Juda kasel nulumi kuguup uta ku-nilipta, ifip te yak ipmi yaan diim tububu boyo tolo kululip yak abiip kasel imi ilo unuta bole, abiip unang tinum iyo utamipta e, son-temu uyo, bilip iyo maak so tal nuyo dong dogobelan-temaalip kalaa agelipta, imkaa unemin o,” ageta Yesus iyo bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ageta Yesus imi okumop man tuluun kal iyo imdala no abiip maak maak uyo God imi weng tambal uyo baga-e-bom-nilip e minte, unang tinum mafak ilin umkan unsip iyo telela imka-bom no ke-bii-silip ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Kale unang tinum iyo Yesus imi sang uyo bogo una tala ke-bom-nilip e, iip maak maak iyo bogo-nilip, “Beyo ok sam uga-emin tinum Jon Baptis kaan-se ita kale, ko God iyo tebe dufola asok fen tigi mo-nalata, kanupmin kuguup boyo kanu-be o,” agelip e minte, iip maak maak iyo bogo-nilip, “Beyo tinum sugayok bii-se Elaija iyo kota mitam talba o,” agelip e minte, unang tinum iip maak maak iyo bogo-nilip kano, “Beyo sugayok profet ko age God imi weng kem baga-emin tinum maak kaansa ita asok fenba o,” agelip no kemip ko. Kale Herot beyo Provins Galili kutam umi kamok king kale, unang tinum iyo Yesus imi sang boyo baga-bilipta, Herot imi duup ita tolong do-nilipta, tal bogobelipta, Herot yagal aget afalik uyo fugun-bii-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","bogola ko. “Siin uyo nimi ogok kemin tinum iyo imdali no-nilipta, Jon imi dubom uyo ugaa kupkan kebe-silip kuta, beyo waantap imi sang tolong doli o?” agela ko. Kale Yesus beyo ataman o agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kale Yesus imi kalaan tinum iyo asok tal-nilip e, Yesus iyo bogobe-nilip e, “Kamogim kabaa. Alugum mufekmufek uyo telela tulup o,” agelip ko. Tam Yesus ilami kalaan tinum iyo kulep-nala e, ipkumal unang tinum iyo imka-nala e, unanbu no abiip Betsaida unip kale, ");
INSERT INTO tlf_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","unang tinum iyo tolong dolipta e, “Yesus iyo abiip Betsaida una o,” agelip kalaa age-nilip e bole, unang tinum iyo at kom daage no tamip e, Yesus iyo weng umka-e-bom deng tebe-bom-nala e, bogobe-nala e, “Ibo God imi ilak uyo fomtuup do-nilipta bole, mitam God imi daam tem e tilin o,” age-nala e minte, unang tinum mafak ilin iyo telela imka-bom no kema ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ke-bala am kwiinu e, Yesus imi okumop man tuluun kal iyo tal Yesus iyo bogobe-nilip e, “Kamogim kabaa. Anang kaa albup koyo unang tinum binim diim kagal albup kale, kabo unang tinum kalip iyo imdalap abiip maak maak no-nilip iman umaak fen-bom un-bom-nilipta, kugol siin o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","14","Yesus isiik bogobela, “Ipkil iman uyo ifelip une-nilipta, siin o,” agela ko. Kale tinum ilimi kup faiv tausen (5,000) e minte imi kalelal so man so iyo kugol albip kalaa age-nilipta, Yesus imi okumop man iyo Yesus bogobelip ko. “Nuyo iman kwiin tagang binim kale, bret kangkang ogal maak e minte aniing alop maak no ita kup albip kale, bilip iyo tii ba kale, kabo di imdalap no kek kek dagalup iman uyo maak so kobelip mo kulep tal-nulupta, alugum unang tinum kalip iyo ifelup uneta siin bele ki?” agelip ko. Tam Yesus iyo ilami okumop man iyo bogobela, “Ibo unang tinum bilip iyo bogobe-nilip kano, ‘Ibo afeta-bii ko 50 50 ke-nilipta, tonin o,’ agelipta o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yesus imi okumop man iyo unang tinum bogobe-nilip e, “Kanubeta tonin o,” agelipta, alugum iyo tonip ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesus iyo bret kangkang ogal iyo dulu som, minte aniing alop iyo dulu no ke-nala e, abiil tigiin kiit fen-nala e, God iyo, “Misam o,” age-nala e, kota bret fegela do-nala e minte, aniing iyo duula do no ke-nala e bole, ilami okumop man imi dobelata, ita unang tinum imi delebelipta, unan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Alugum iyo unan-biita, tii kelup kalaa agelip e, kota Yesus imi okumop man iyo iman tukup tukup ke-bilip uyo afetam tiinan-bii ko-nilip e, basket ulumi kup tuluun kal koyo abulip dongenu ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kale am maak daanu e, Yesus iyo ilasinon bom beten ke-balata, imi okumop man iyo tilip kale, Yesus iyo daga-nala e, “Unang tinum iyo, ‘Beyo waanta o?’ nagan-bilip o?” age imi okumop man dagala e, ");
INSERT INTO tlf_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","okumop man iyo bogobe-nilip e, “Tam unang tinum iip maak maak bilip iyo bogo-nilip kano, ‘Beyo ok sam uga-emin tinum Jon Baptis ita o,’ kagan-bilip e minte, iip maak maak iyo bogo-nilip, ‘Beyo tinum sugayok bii-se Elaija ita o,’ kagan-bilip e minte, iip maak maak iyo bogo-nilip kano, ‘Beyo sugamiyok God imi profet ko age weng kem baga-emin tinum maak kaansa ita asok fen tigi moba o,’ kagan-bilip no o,” agelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kale Yesus iyo bogola, “Minte ipde a? Ibo, ‘Beyo waanta o?’ nagan-bilip o?” agela e, Fita iyo Yesus imi weng uyo yan kebe-nala e, “Kabo God imi ulaa kamdula kamok kesap tinum Krais ita kulbap e minte, God imi, ‘Daali no tolon-tema o,’ age Israel kasel numi bogobela fen tebesup tinum ita kulbap no o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Fita iyo kam agela e, Yesus iyo titil weng uyo imi okumop man iyo bogopma, “Nimi weng ko bogopmi boyo kwep no en tiine-bom, ‘Yesus beyo God imi ulaa dula kamok kesa tinum o,’ age baga-emin ba ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Son-temu uyo, Mo Tibil imi Man niyo kuguup mafak mafak uyo kupkaneman-temip kale, Juda kasel imi kamogimal so tinum amem ko age pris imi kamogimal so ulo utamsip tinum so ita umik ugopne nitafinon-bom-nilipta, nimdalip yak waasi imi sagaal diim abelita, ita nangkolip kaani namalip bii, am alop kelita, am asuno diim kota God iyo nifola asok fen tigi molan-temi o,” age-nala e minte, ");
INSERT INTO tlf_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","asok unang tinum alugum bogobela, “Tinum dogap kapta, niso no nimi ogok uta keneman o agelap umdii, yak kalapmi aget fugunin uta kup kanumin boyo kupka-nalapta, am tiinu kayop tiinu kem tubu uyo, nimi ilak uta fom duga-bom-nalap e, nimi at diim kaal fuyap kulan-temi kulutap ke, ‘Kaan-nimi bole, kanube kaan-nimi o,’ agan-bom-nalapta, kanupmin kuguup uta ku-nalapta, te tam nimi ogok uyo waafuu kwep tebe-balapta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tinum dogap ita ilami kaal ilak uta kup suun duga-bom, ilami aget fugunin uta kup kanum tiineman o agan-kala umdii, beta kaan-nalata, maagalo kelan-tema kale minte, tinum dogap ita, ‘Meng kanu-bili waasi iyo tebe nangko-nimip kuta, nangko-nimip o,’ age-nala meng nimi ilak kup duga-bom nimi kuguup uta fomtuup waafuu kwep taba umdii, beta suun kup nan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Minte tinum iyo maak kafin kaa kutufosu komi mufekmufek uta alugum kwaa-bom-nala e minte, suun kup nin umi ilep umaak temin binim ke-bom no kema umdii, ilami mufekmufek kwiin tagang ko kwan-be bota tebe dong dogopman-temu bele ki? Umbae. Boyo tebe dong dogopman-temaalu kuba. ");
INSERT INTO tlf_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tinum maak nimi win uyo kufunemin binim e minte, kek kek imi atul finano nimi weng uyo baga-emin binim ke no kema umdii, son-temu nala Mo Tibil imi Man niyo nalami Aatum ilatap kun tibin kamogim ke-nili ensel tambal iso tolon-temi uyo, nisiik tinum bemi win uyo kufobelan-temaali kale, ‘Beyo nimi duup ba o,’ agelan-temi ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kuta tuluun weng uyo tele tolong dolin. Iip maak maak ibo kaanin-tem somta utamipta e, God iyo unang tinum kwiin tagang iyo imdep tam ilami daam tem daa tiin mola mitam senganu kalaa age utaman-temip o,” age Yesus iyo unang tinum iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesus iyo weng boyo baga-e-bii kupka-nala e, bom-bala bii, am ifaan kal umaak binimanu e, kota Yesus iyo, God imi beten keman o age-nala e, Fita sino Jon sino Jems sino ninggil iyo imtamo unanbu no amdu tigiin maak tam unip ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kale Yesus iyo beten ke-balata minte, tinum asuno bilip iyo atamipta e, imi tibit kun uyo migik kelu e minte, imi ilim uyo namalan-nuluta, tiin bulusii so kelu kalaa agelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Kota maak fagalin tap tinum alop maak God imi ilagenamin kuso alula kwep tal Yesus imi miit tem kugol mo-bom Yesus sino weng bagamip ko. Kale kota Yesus imi okumop man iyo utamipta e, alop iyo sugayok tinum kaansip Moses so Elaija so alop ita kalaa agelip ko. Kale Elaija so Moses so alop iyo Yesus imi kanum tam tam kwep no Jerusalam kugol kaan-nala God imi, “Bo kanumal o,” age-se boyo binimanu kupkalan-tema umi sang uta baga-emip ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Fita sino imi ipkumal sino ninggil iyo tiin ak tebebelu atin agaal unip kuta, kupkaa fen-nilipta, utamipta e, Yesus iyo at dong kiim uta kup ilagenuta, mola e minte, tinum alop iyo molip no kelip kalaa agelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kale Fita iyo utamata e, Moses so Elaija sino iyo, mep so Yesus iyo dupkaa unum o angbip kalaa age-nala e, kanubelip bomi magam uyo tele utamin-tem amon amon ke-bom-nala e, Yesus imi bogobela ko. “Kamogim kabaa. Suguul ke kapsino tal kagal albup kale, ninggil nuyo am mafak asuno umaak delupta, maak bo kapmi, maak bo Moses imi, minte maak bota Elaija imi no o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kale Fita iyo weng bo bagam-sala e, tam iip namaal maak malaak de imalu e, kota Yesus imi okumop man asuno iyo finanip ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kale kota weng maak iip tem kutam-tele tulu bo bogo-nala e, “Beyo nalami Man (yaan maak) ulaa du-sii ita kale, ibo bemi weng uyo tinangka-bom-nilipta o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kale kota weng ko bagan-be uyo binim keluta, tam iip uyo tebe tinum alop iyo kulep unuta, Fita ninggil iyo utamipta, Yesus ita kup alba kalaa agelip ko. Kale Yesus imi kafin diim bii-se uyo, Yesus imi okumop man iyo ilimi amdu tigiin ko mufekmufek kanum tulu utabip bomi sang uyo unang tinum iyo maak bogobesaalip ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kale Yesus isino minte ilami okumop man asuno iso iyo amdu tigiin kal silipta, tam kutim kota amdu tigiin uyo kupka-nilip e bole, daage malaak abomu e, unang tinum kwiin tagang iyo Yesus imi ilep fen talan-bilip kalaa agelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","39","Kale tinum maak unang tinum kwiin tagang tem kwek-tele ol-bom-nala e, bogola, “God imi weng kafalemin kabaa. Nimi man tinum keyo yaan maak kale, sinik mafak maak tebe-nuluta, fomtuup aafuluta bole, yuut olala e, dufak daalu bamban keng keng ke-bom-nala e minte, mok mok faa dega-balata, sinik mafak uyo tebe dufak daga-buluta, kaan ko bii fen fen nuuba ko. Kale sinik mafak boyo yuut dupkaa yak iinan-nuubaalu kale, kabo atam-nalap kano, fomtuup dong dogobe a. ");
INSERT INTO tlf_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Niyo kapmi okumop man bilip iyo fomtuup bogobe-nili kano, ‘Ibo nimi man kemi sinik mafak uyo fot tebelip yak iinuta, dong dogobelin o,’ agelita, kapmi okumop man iyo bagang-kale fot tebe dong dogopmin-tem ke-maansip o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesus iyo ilami okumop man sino unang tinum albip sino imi bogobe-nala e, “Kwiin ee. Ipmi aget fugunin uyo fen atin tol ba kale, niyo ipso bii, kayop kwiin tagang te yang iinu kuta, ibo nitamipta e, beyo God imi titil uta ku-nalata, sinik mafak iyo fot tebela yak iinan-nuubip kalaa naganbaalip ko. Niyo ipso bii, am intap kal kelita, ibo nitamipta, beyo tii God imi titil boyo nugol mungkup kobe-nama kalaa nagelan-temip a? Niyo ipmi aget mafak fugun-bilip boyo daal tebepnebu o,” age-nala e, fupkela man tinum imi aalap iyo bogobe-nala e, “Kapmi man iyo dep talaal o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Man tinum beyo ilami aalap sino ulim tal Yesus mep so tal-bilipta bole, sinik mafak uyo tebe-nulu e, man tinum iyo fomtuup bagaa daalu daak kafin diim abela e, fomtuup dupku saan-bii dupkalu ko. Yesus iyo sinik mafak uyo un-togon-bom-nala e, bogola ko. “Sinik mafak kubo yak iinaal o,” agela man iyo dupkaa yak iinuta bole, Yesus iyo tebe man tinum iyo telela do-nala e, asok ilami aalap dobela ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kale unang tinum iyo utamipta e, God imi titil atin afaligen uyo Yesus imi kobelata, boyo kanubela kalaa age-nilipta, atin kumang mo una tala kelip ko. Mat 17:22-23, Mak 9:30-32 Unang tinum iyo Yesus imi titil ko kanubela bomi aget uyo kwiin tagang fugun-bilipta, Yesus iyo ilami okumop man imi bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ibaa. Nimi weng koyo tele tolong do-nilip ilumanamin ba ko. Mep sino kota tinum maak tebe-nilip Mo Tibil imi Man niyo nimdalip yak waasi imi sagaal diim abelan-temi o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kuta imi okumop man iyo imi weng baga-e-be bomi magam uyo tele utamin-tem kelip kale, bomi uyo ki God iyo weng bomi magam uyo kubalata, tele utamin-tem kelip kuta, finan-bom-nilipta, bomi magam uyo maak daga-nimip binim kelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yesus imi okumop man ninggil iyo wengaal digin-bom bogobina tala ke-bom-nilip e, bogolip ko. “Waantap ita numi iibak tem katam iyo mitam numi kamok kelan-tema o?” agelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesus iyo utamata e, kanupmin aget uyo fugun-bilip kalaa age-nala e, tam man katip maak ugaa du-nala e, dep miit tem daa-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","kota Yesus ilami okumop man iyo bogobela ko. “Tinum dok ita man kalatap iyo maak atamata, Yesus imi tiin diim uyo man kanupmin keyo win so kalaa age-nala dong dogobela umdii, boyo nimi dong daganemin kuguup uyo kulbu ko. Minte God yagal nimdala ti-sii kale, waantap ita nimi dong dogopnela umdii, boyo God imi dong daga-emin kuguup uyo kulbu ko. Kale dok ita aget fugunolata, niyo afak tem iinsi tinum kalaa agela umdii, beta God imi tiin diim uyo kwiin kiim kelan-tema o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Kale Jon iyo Yesus imi bogobe-nala e, “Kamogim kabaa. Ninggil nuyo tinum maak atamupta, beyo kapmi okumop man kelin-tem bom-nalata, sinik mafak uyo kapmi win tolop diim fot tebela yak iinan-bilip kalaa age-nulupta, bogobe-nulup e, ‘Kapmi bisop Yesus imi win kufobe-nalap kanu-balap boyo kupkalal o,’ age fegelebebup o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","minte Yesus isiik bogobe-nala e, “Waantap ita ipmi waasi kebelin-tem kela umdii, beyo ipmi duup ilatap kale, ibo imi kanu-be boyo fegelemin ba o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","God imi Yesus dep tam abiil tigiin unon-tema uyo mep so tuluta, Yesus iyo aget kufo-nala e, kota Jerusalam unon o age-nalata, imi okumop man ita imdep una ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kale abe-bom-nilip e, Yesus iyo imi okumop man atuk iyo imdala isiik bon tem daage no Provins Samaria umi abiip maak kutam kal bogo-nilip e, “Yesus iyo talan-be kale, am sinamin am uyo telela kupka-em-sulupta, talak o,” agelip kuta, ");
INSERT INTO tlf_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Samaria kasel bilip iyo Juda kasel imi waasi kebesip kale, abiip unang tinum iyo utamipta e, Yesus iyo, tal sonta, Juda kasel imi abiip miton Jerusalam iinon o age-nalata kalaa age-nilipta bole, “Telemin ba o,” age weng kwaalip no ilibeluta, Yesus iyo kupkala ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yesus imi okumop man Jon sino Jems sino iyo tinangku-nilip e, Yesus imi bogobelip, “Kamogim kabaa. Nuyo God iyo dagalupta, at togol maak kwaala malaak-nuluta, abiip kasel kulip iyo fuulu ken tebelin o agan-bulup kale, kapmi aget fugunin uyo bogobelap utamupta o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesus iyo fupkela-nala e, alop imi yan-togon-bom bogobe-nala e, “Kuguup mafak boyo kanumin ba o,’ agela e bole, ");
INSERT INTO tlf_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","kupkaa no abiip migik kutam iinip ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kale Jerusalam unum o age abe-bilipta, tinum maak Yesus imi bogobe-nala e, “Dogap dogap tiinemap uyo, niyo kapsino kup tiineman-temi o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesus isiik bogobela, “Sep kayaam ko age dungkiil iyo dungfil tem kal sina-bala e minte, uun yagal ilami um tem kal sina-bala no kem-nuubip kale minte, Mo Tibil imi Man nita fen nalami am sinamin am binim kale, kapkal aget uyo tele fugunolal a. Kabo nisino kanube tiineman o agan-balap aga o?” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesus iyo tinum maak imi bogobe-nala e, “Kabo nimi finang tal-nalapta, nimi okumop man kelal o,” agela e, tam tinum iyo bogola, “Kamogim kabaa. Kamaki uyo nimkalap asok no abiip kal nimi aatum iyo tiin mo-bom-sili kaana dep no duba-nilita, kota talta kapso tiinemum o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesus iyo tinum bemi weng uyo yan kebe-nala e, “Waago. Kabo unemin ba kale, kupkaa meng nimi okumop man ke-nalapta o ageta ko. Tinum dok ita, nimi daang begepnelaalup o agan-bilip ita felepmuta, ipkumal kaanip iyo imdep no imamin kale minte, kabo no unang tinum bogobe-nalapta, ‘God imi ilak do-nilipta, mitam God imi daam tem mitam-nilipta, suun nin unang tinum kelin o,’ age baga-em tiinemal o,” age tinum bemi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Tam tinum maak Yesus imi bogobe-nala e, “Nugum kabaa. Niyo kapmi okumop man kelan o agan-bii kuta, kamaki uyo nimkalap no abiip no-nilita, nimi amalap imi aget fugunin uyo dagalita, ‘O,’ agelip kalaa age-nilita bole, talta kapmi okumop man kelan o,” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","tam Yesus isiik bogobela ko. “Tam tinum iyo iman ilang kela uyo, tele tiin molin-tem kelan-tema uyo, imi man iyo tele ifeman-temaala ko. Kale ulutap kale, tinum iyo, nimi ilak doli o age-nala atuk atuk kema umdii, beyo God imi weng uyo unang tinum iyo tele kupka-eman-temaala o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kale boyo binimanu e, Kamogim Yesus imi aget fugunin uyo, siit-nilita, aaltam kota abiip maak maak unon o age-nalata, kamaki uyo tinum ilimi kup 72 kalip iyo ulaa imdu alop ke imdala isiik bon tem abiip maak una una kelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kale unin-tem bom-silip e, Yesus iyo do weng maak bogopma, “Unang tinum kwiin tagang iyo, God imi weng tinangkamum o agan-bilip kale, bilip iyo rais ko age wiit damanu ulutap kuta, tinum wiit dagamin tinum iyo iip maak maak ita kup kale, (wiit dagamin tinum bilip iyo tinum tebe God imi weng kwep no unang tinum imi kupka-emin ita kale,) ibo God imi beten ke-e-bilipta, yagal ogok kemin tinum kwiin tagang ulu-nalata, imdala tal ipmi diim abelipta, ipsino maagup no unang tinum iyo God imi weng uyo baga-emin o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Kale ibo unon-temip uyo, tinum tebe dungkiil imi kong man an-nuubip ulutap ke ifak dagaman-temip kale, ibo bo tele utama-bom-nilipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kale ipmi unon-temip uyo, tuumon kulep unemin ba. Iman men uyo abu kuptamo unemin ba. Minte yaan ilom migik uyo maak so kulep unemin ba. Minte abe-bomta, unang tinum ilep kugol itamip uyo, weng kangkang uyo baga-e-bom ilep kugol suun nin ba kale, yuut no abiip uta no nimi talan-bii umi sang uyo baga-em una una kem unin a. ");
INSERT INTO tlf_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kale suun kup am iinemip uyo, kamaki kota am kasel iyo weng umobe bogobe-nilip e, ‘God yagal am kasel ibo tiin mo-bom-balata, ipmi aget aa bubul aa uyo bilili mo-bom-nilipta o,’ agelipta o ageta kale, ");
INSERT INTO tlf_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","am kutam alba iyo bilili agelin tinum kale, bogobe-nala e, ‘Ibo suguul ke tilip o,’ agela umdii, son-temu nala ibo, imkaa unum o agelan-temip uyo, bogobe-nilip e, ‘Bisel yagal ibo alugum tiin molata, tambaliim bom-bilipta o,’ age imkaa unipta, God yagal kuguup tambal kobelan-tema kuta minte, beyo bilili agelin binim kale, tiin aa aget aa uta kup ku tilip kalaa age-nala e, weng umopmin-tem kela umdii, ipkil dupkaa bisop unin o ageta kale, God iyo kuguup tambal uyo beyo kobelan-temaala binim ko. ");
INSERT INTO tlf_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kale ibo abiip kutam kal bom-nilip unang tinum kafale-bom nip uyo, ibo no am maak maak uyo sinamin ba kale, kamaki no am maagup umi diim abebip kutam kal bom-nilip e, iman min, ok min, yak intaben kopmip uyo unan-bom no kemin a. Kale iman kupka-e-bilip unan-kalon-temip boyo ki, ipmi ogok ke-e-bilip umi yan ke-emin iman uta kupka-e-bilip unan-kalon-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Abiip unum o age-nilip no tamip tal, ‘Suguul ke tilip o,’ age-nilip imtamo no unan-kalin uyo kobelip umdii, unan-kalin ko. ");
INSERT INTO tlf_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Kale ibo abiip kutam iyo bogobe-nilip e, ‘God iyo ipmi bogobe-nala, “Ibo mitam nimi daam tem e tilipta o,” agan-be o,’ agan-bom-nilip e minte, kutam imi unang tinum mafak umkan unsip iyo telele-bom no kemin a. ");
INSERT INTO tlf_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kale minte no abiip maak uyo no tamipta, abiip kasel kutam iyo tiin aa aget aa uta kup itam weng umopmin binim kelip umdii, ibo asok yang abiip mat kal mo-nilip e, ilipmi kuguup uta ku-nilipta, ifip te yak ipmi yaan diim tububu boyo tolo kululip yak abiip kasel imi ilo unu kupkaa ibo bogobe-nilip e, ");
INSERT INTO tlf_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ibaa. Tolong do-silipta. Ibo, “Suguul ke tilip o,” agelaalip kale, ipmi abiip umi ifip tolo kululup no tulu boyo kugol bom-buluta o ageta kale, nuyo imkaa unup kale, kamaki uyo weng katip maak bogobelum o ageta kale, tele tinangku-silipta. Nuyo God imi weng uyo ipmi finang kwep tulup kuta, ibo tinangkulin-tem kelip bole, ilipmi san o,’ age abiip kasel imi bogobe-nilipta, imkaa daaginin o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Niyo abiip kasel kulip imi sang uta bogopman-temi kale, sugayok uyo abiip Sodom kasel iyo kuguup mafak uta kem-kalipta, God iyo tebe ifak daalata, kaansip ko. Kale am afungen tem mitam tolon-temu uyo, God yagal Sodom kasel iyo kaal fuyap uyo kupka-eman-tema kuta, kamano koyo God imi weng uyo kem diim albu kale, ibo no abiip kutam iinon-temip kutam iyo dogap ita God imi weng uyo kwaasulemip umdii, God imi tebe bilip imi kaal fuyap kupka-eman-tema uta uta ke-nuluta, Sodom kasel nimi weng tambal tolong dolin-tem ke-bii-silip imi kaal fuyap kupka-eman-tema uyo kubaganu kupkabelan-temu o,” age-nala e, Yesus iyo tinum ilimi kup 72 bilip imi weng kem kupka-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesus iyo abiip alop umi unang tinum iyo weng kem uyo kupka-e-bom bogobe-nala e, “Korasin kasel so Betsaida kasel so ibaa. Ibo usap manal kuba. Niyo mirakel ko age kuguup ugulumi migik migik uyo ipmi abiip alop kutam kal kanumsi kuta, ibo aget aa bubul aa umaak fupkela kota fengmin boyo kupkasaalip binim ko. Kale niyo kanupmin kuguup ugulumi migik migik boyo God imi ilak dolin binim imi abiip Taya sino Saidon sino kutam kal kanumsi nimnam, abiip kasel bilip iyo utam-nilipta, ilimi fengmin aget uta iluum tebepmuta, ilimi aget iluum umi kuguup uta ku-nilipta, kutap uyo kulu ilimi kaal diim uyo tuko-nilip e minte, ilim mafak uyo migi no ke-nilipta, ton-bom aman-bii-nilipta, ilimi fengmin uyo kupka-silip kuta, niyo no kafalebelita, utamsaalip ko. ");
INSERT INTO tlf_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kale afungen tem tolon-temu uyo, God iyo Taya kasel so Saidon kasel sino iyo yege-bom kaal fuyap uyo kupka-eman-tema kuta, ipmi fengmin uyo kupkalin-tem kelip kalaa age-nalata, God imi tebe ipmi kaal fuyap kupka-eman-tema uta kwiin kiim kupka-eman-tema kuba. ");
INSERT INTO tlf_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Minte Kapeneam kasel ibaa. Ibo bogo-nilip e, ‘Alugum nuyo no God imi abiip kal nan-temup o,’ agan-bilip kuta, umbae. Ibo nimi weng uyo tinangkamin binim kale, kululi daak abiip mafak unon-temip o,” age Yesus iyo abiip asuno kalip imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesus iyo ilami okumop man bilip imi bogobe-nala e, “Tinum dok ita nimi okumop man kapmi weng uyo tinangkama umdii, beyo nimi weng tinangkamin tinum iyo kulba kale minte, dok ita, kapmi weng uyo tinangkulaali o agan-kala umdii, mungkup beyo nimi weng tinangkamin binim iyo kulba kale minte, dok ita, God nimdala ti-sii nimi weng uyo tinangkulaali o agan-kala umdii, beyo God imi weng tinangkamin binim iyo kulba no o,” age ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Okumop man ilimi kup 72 imi ogok uyo binimanepmu e, Yesus imi finang tal-nilip e, deng afek kup tebe-bom-nilip e, Yesus imi bogopmip, “Kamogim kabaa. Sinik mafak iyo kapmi win tolop diim baga-e-bulup e, iyo numi weng uyo tolong do-nilip e, tinum imkaa daaginemsip o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesus isiik yan kepma, “Kanu-bilipta, nagal utamita e, Saatan iyo bamalaang falaak molin ulutap ke maak fagalin tap abiil tigiin ilo kutiga talanbu malaak kafin diim abela kalaa age-sii ko. ");
INSERT INTO tlf_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Tolong dolin a. Niyo nimi titil iyo ipmi dobe-sii kale, ibo ilep abe-bom-nilipta, inap so atoguum sino imi diim yaan tamalan-temip kuta, boyo inolan-temaalu binim kale, ipmi titil boyo nimi waasi ko age Tinum Mafagim imi titil uyo kubaganepmuta, ipmi titil uta uta kelan-temu kale, mufekmufek mafak umaak tebe-nuluta, ifak daalan-temaalu ko. ");
INSERT INTO tlf_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kale sinik mafak iyo ipmi weng uyo tinangku waafulip kalaa age-nilipta, ibo deng taban-bilip kuta, kanupmin boyo katipnok kale, mufekmufek kwiin kiim uyo kulbu kale, ibo tal God imi daam tem tilipta, God yagal ipmi win uyo ilami suuk kon tem kal dola kobe-se kale, bomi deng uta tebemin o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kale kota God imi Sinik Tambal Yesus imi aget tem nin iyo tebe Yesus iyo dong dogobelata, Yesus iyo atin deng kwiin kiim kup tebe-bom-nala e, ilami Aalap God imi bogopma, “Nimi Aatum kabaa. Kabo Kamok kale, kafin diim kasino abiil tigiin kusino uyo tiin mosap kale, (kapmi kuguup uyo tebe unang tinum imi kuguup uyo kubaganu kupkaa uta uta kesu kale, ‘Suguul o,’ agan-bii kale,) unang tinum iip maak maak iyo aget fuguno-nilip e, ‘God ita kafale-balata, nuyo utamsaalup kale, nulumi aget fugunin uta kafale-buluta, nugol God imi mufekmufek uyo utamsup o,’ agan-nuubip kalaa age-nalapta, kabo kapmi aget fugunin tambal uyo kubalapta, bilip iyo maak utamanbaalip kale, minte, unang tinum iip maak maak iyo bogo-nilip e, ‘God kabo kafale-balapta, utamum o,’ agan-nuubip kalaa age-nalapta, bilip ita kafale-balap utaman-bilip kale, (bilip iyo nimi weng uyo tinangkamin kup kemum o agan-nuubip kale,) boyo, Aatum kabo, ‘Suguul o,’ kagan-bii ko. Kapkal, kanupmin kuguup boyo kanumin o age-nalapta, kapmi aget fugunin tambal uyo utamsaalup kalaa agan-bilip tinum imi kupka-e-bom kafale-balapta, utaman-bilip o,” age Yesus iyo God imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Beten ke-be uyo binimanu kupka-nala e, Yesus iyo unang tinum tagang tem kugol bogola, “Nimi Aatum iyo mufekmufek uyo alugum kwaap-nama mek nimi sagaal diim abe-suu kale, niyo ilami man aligaap kuta, unang tinum iyo maak nitamta, beyo God imi Man aligaap kalaa agesaalip kale, nimi Aatum ita kup nitamsa kale, ulutap mungkup unang tinum iyo maak nimi Aatum iyo atamta, dogonupmin tinum kalaa agesaalip kale, ilami Man nita kup atamsi kale, unang tinum nagal ulaa imdu-nili nimi Aatum imi sang uyo kafalemi umdii, bilip ita Aatum iyo atam no kelan-temip o,” age baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kota asok fupkela ilami okumop man ilimi kup bogobe-nala e, “Sugamiyok God imi profet ko age weng kem baga-emin tinum imi weng baga-emsip uyo kamano kota ipmi tiin diim umdii ko mitam tebelu utaman-nak-bilip kale, ipta tambaliim ke God yagal tebe mufekmufek boyo kafale-be ko. ");
INSERT INTO tlf_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kale weng maak bogobelan-temi kale, sugayok uyo God imi weng kem baga-emin tinum isino minte kamok king isino kwiin tagang iyo, nimi ogok kaa kanu-bili ipmi utaman-bilip koyo utamum o agansip kuta, utamipta, ko mitam tulu kalaa agesaalip binim e minte, nimi weng kaa ipmi baga-e-bii koyo aa mungkup igil, tolong dugamum o agansip kuta, iyo maak tolong dugamsaalip binim no o,” age-nala e, Yesus iyo okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ulo utamsa tinum maak mo-nala e, Yesus iyo dup-kugulita, weng mafak umaak bogola kalaa agelan o age-nalata, bogola ko. “Kafalemin kabaa. Niyo dogonube-nilita, suun kup nan-temi o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesus iyo bogobela, “God imi weng sugayok dola kosip uyo ibo tikim-nuubip kale, uyo, intaben o agesu o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ulo utamsa tinum iyo bogola, “God imi weng uyo bogo-nulu e, ‘Kabo ki atuk atuk kemin ba kale, kapmi aget aa bubul aa tiin aa titil aa uyo alugum kwaalap yak Bisel kapmi God imi diim abelu atin imi ilak kup duga-bom-nalapta o,’ age-nulu e minte, ‘Kabo kalapmi kaal umi ilak do tambaliim tiin mobap ulutap ke kapkumal kek kek imi ilak uyo do telelemal o,’ age no kesu o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesus iyo bogobela, “Kabo dam bogolap ko. Kale bota kanumap umdii, bota suun kup nan-temap kale, kanu-bom bom-balapta o,” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ulo utamsa tinum iyo, kam agelita, kek kek unang tinum iyo, beyo tinum tambal o nagelin o age-nala e, Yesus imi bogobela ko. “‘Kapkum imi ilak dugamin o,’ agesu bota waami ilak dugamin uta o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesus iyo tinum bemi weng uyo yan kebe-nala e, kek kek imi ilak dugamin sang uyo felep yak ku to do weng maak bogola ko. “Am maak daanu e, Juda tinum maak, Jerusalam ilota dup-kalaak mo abiip Jeriko unon o age abe-balata, tinum ilep bigi ano mufekmufek daga-emin tinum iyo tebe aafuu ang kulep ilep ku daa-nilip e, imi ilim so men so ting so uyo alugum dugu kulube unom-nilip e, ilep kugol dupkaa unip kaanba ilatap ke-bom-balata, ");
INSERT INTO tlf_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","pris ko age tinum amem maak ilep ku-tele dup-kalaak mo abe-bomta tinum beyo atama kuta, dupkaa yang ilep kan tem kweng abe una e, ");
INSERT INTO tlf_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","aa mungkup Livai tinum ko age ulotu am dong daga-emin tinum maak tal abomu, tinum iyo kanube alba kalaa age dupkaa yang ilep kan tem kweng abe daagina no kelipta minte, ");
INSERT INTO tlf_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Juda kasel imi waasi Samaria tinum maak ilep ku-tele talanbu tal abomu, keyo fen Juda tinum maak ang kulep ku daa unip kaan koba tap ke alba kalaa age-nala e, fomtuup du-filin daa-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","yang mep so duptal migi-nala e, marasin ko age abang abumin ok uyo kulu angko unbip umi abang uyo deelebe-nala e, abang dinan-kalin uyo kulu deebe no ke-nala e, tinum iyo dugola dufo dep te tam ilami kong ko age dongki umi daang kun diim daa-nala e, duptamo no fital imi tal kutam kal somip nala unemin am maak daa tele tiin mo ");
INSERT INTO tlf_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","se nala e, tam tuumon tem kalolin alop maak kulu am kayaak imi kobe-nala e, bogola, ‘Tinum angkobip keyo tambaliim kup tiin mo-bom-balap tambalanata, aaltam kota tal-nilita, kapmi mufekmufek tukuba-balap tambaliim kelan-tema boyo yan kepkelan o,’ age dupkaa daagin-se o,” age Yesus iyo ulo utamsa tinum iyo bogobe-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Kapmi aget fugun-balap uyo, tinum asuno bilip iyo dok ita tinum angkobip bemi ilak uyo do-se o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ulo utamsa tinum iyo bogola ko. “Tinum du-filin daa-nala dong dogobe-se beta o,” agela e, minte Yesus isiik bogobe-nala e, “Kapkal no-nalap kapmi waasi imi ilak uta duga-bom kanupmin kuguup bota kup waafu-bom-balapta o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesus so minte imi okumop man sino ninggil iyo asok dagaa kulep no abiip maak tamip e, unang maak bomi win uyo Mata uta, “Suguul ke tilip o,” age imdep no am daalu e, ");
INSERT INTO tlf_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mata umi neng Maria uyo tal Yesus imi miit tem kal ton-bom imi weng uyo tinangka-bom bom-buluta minte, ");
INSERT INTO tlf_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mata uta bong faga-bom iman uyo telela-bom-nulu e, aget afek uyo fugun-bii-nulu e, tal Yesus iyo bogobelu, “Kamogim kabaa. Nimi neng boyo namkalu nalasinon bong faga-bom iman fuu-bii koyo nitabaalap aga? Bogobelap tal dong dogopneluk o,” agelu e, ");
INSERT INTO tlf_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kamogim iyo bogobela, “Mata kubo mufekmufek kwiin tagang umi aget uta fugun-bom-nalapta, bubul iluum tebepke-buluta, aget afek fugun-balap kuta minte, ");
INSERT INTO tlf_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","kubo kuguup maaksinon maak umi aget uta kup ilumano kupkaa boyo duumatanapta, Maria uta utamuta e, kuguup ilumano kupkabap boyo nimi weng tinangkamin uta kalaa age-nuluta, bota nimi weng uyo tinangku kubaget dagan-bo kale, dok ita tebe God imi weng kubaget dagan-bo boyo kupkan kepman-temaala binim o,” age Yesus iyo bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Am maak daanu e, Yesus iyo iibaan kugol bom-nala e, God imi beten ke-e-be kale, ilami okumop man iyo isino albip kale, imi beten ke-be uyo binimanu e, okumop man maak tebe Yesus imi dagala, “Kamogim kabaa. Beten kemin umi kuguup uyo dogobeta nugol beten keman-temup a? Siin uyo ok sam uga-emin tinum Jon Baptis imi okumop man kafalebe baga-e-bom-nala, ‘God imi beten ke-emin kuguup tambal uyo kulbu o,’ age baga-emsa ulutap ke kapkal God imi beten ke-emin kuguup uyo nugol kafalebelal o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesus iyo alugum bogopma, “God imi beten ke-emip uyo, bogobe-nilip e, Numi Aatum God kabaa. Kapmi win boyo afaligen kale, alugum unang tinum nuyo dong daga-e-balapta, “Beyo tambal kup tebesa o,” kagan-bom-nulupta o ageta ko. Kabo alugum nuyo imdep tam kapmi daam tem daa tiin molapta, bom-nulupta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Suun kup am daanamu uyo, nuyo am daanu bomi iman unan-kalin boyo kopmap unan yakyak kemum o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kabo numi fengmin boyo kupkabe numi nugumal imi tebe numi fenge-bilip kup-kaga-ebup ulutap kebelal o ageta ko. Mufekmufek mafak tal, numi diim abe im-kugulan o agan-bo uyo, kabo fomtuup dong daga-e-balapta, nuyo fengmin ba o,’ age beten kemin umi kuguup koyo waafu-bom-bilipta o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Kale Yesus iyo asok beten kemin umi sang uyo felep yak ku to do weng migik maak uyo bogobe-nala e, “Am tiip tiip fan-bulu e, tinum maak daage no ilami duup am no-nala e, ilami duup iyo daga-nala e, ‘Nugum kabaa. Kamano mililep koyo nimi duup maak tal, nimi am kal sonta, unon o age tala kuta, niyo iman binim kalaa age-nilita, tili kale, fen-nalap dong dogopne-nalap bret asuno umaak kopnelapta, kulep no topmi une sokta, daaginata, suukta, nisiik yan kep-kaman o,’ agela e, ");
INSERT INTO tlf_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","tinum am kutam kal alba iyo bogola, ‘Faal katam uyo ilo ulimal nuyo agaal unbup kale, niyo fen nimi man iyo imdaak tamalan-temi kale, fen-nilita, iman umaak kop-kaman-temaali binim kale, kabo sining age-nalap nimkaa daaginaal o,’ age-se kuta, ");
INSERT INTO tlf_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","niyo bomi sang uyo bogobelan o ageta kale, tinangku-silipta. Am kayaak iyo atamata e, tinum abiip mo-bom bagan-be beyo nimi duup kalaa age-nalata, bota fen-nalata, iman uyo kobelan-temaala kale, atamata e, tinum abiip mo-bom olan-be beyo finanin binim, nifumin kup ke-be kalaa age-nalata, kota yagal fen mitam ipkum imi weng uyo alugum yan kebe iman uyo kobelata, kulep unon-tema ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ageli kale, nimi weng bogobe-nili, ‘Ibo bota kanumin o,’ agelan-temi bota kanumin ko. Ibo dogonupmin mufekmufek uyo duumatanbup kalaa agelip umdii, suun kup God iyo dagaga-bilipta, yagal kupka-emak o ageta kale mungkup, mufekmufek umaak utaman o age-nalap fenap uyo God yagal dong dogopmata, utamin o ageta kale, aa mungkup, faal dok dok kemin ulutap ke suun God iyo dagaga-bilipta, dong daga-e-balata o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kanube tinum iyo mufekmufek sang uyo God iyo dagalip umdii, yagal tinum dagagan-bilip bilip iyo alugum kopman-tema e minte, tinum iyo mufekmufek fen-bilip umdii, mungkup God yagal dong dogopma fen-bom utaman-temip e minte, tinum faal dok dok keman-temip uyo, God yagal mungkup faal bitobe imdep meng ilami miit tem daalan-tema no kuba. ");
INSERT INTO tlf_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Aalabal ibaa. Nimi weng koyo tolong dolin. Kanube kapmi man iyo daga-nala, ‘Aatum kabo aniing maak kopnelapta, unelan o,’ age dagala uyo, inap mafak uta kobelan-temap aga? Umbae. Aniing uta kobelan-temap ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Asok ulutap kale, bogo-nala, ‘Uun magap umaak kopnelapta, unelan o,’ agelan-tema uyo, atoguum ita dobelan-temap aga? Umbae. Uun magap uta kobelan-temap kuba. ");
INSERT INTO tlf_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ibo fengmin tinum kuta, ibo mufekmufek tambal uyo ipmi man kuga-em-nuubip kale minte, ipmi Aalap abiil tigiin kayaak God yagal atin ki tinum tambal kale, yagal atin mufekmufek tambal uyo ilami man ipmi kuga-em-nuuba kale, ilami kuga-emin kuguup uta uta kesu kale, ibo dagalan-temip uyo, yagal imi Sinik Tambal iyo dep malaak dong dogopman-tema o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Tinum maak sinik mafak tebe du dufak daala weng kabam kesata, Yesus tebe sinik mafak iyo fot tebela yak iinata, kota tinum iyo tambalan ko asok fen weng bagama ko. Kale unang tinum iyo atam-nilip e, kumang molip kuta, ");
INSERT INTO tlf_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","iip maak maak iyo bogo-nilip e, “Yesus imi diim kal sinik mafak imi kamogim Belsebul ko age Saatan iyo bom-nalata, dong daga-e-balata, beyo unang tinum sinik mafak imdugan unsu ita fot tebebela yak iinan-bilip o,” agelipta minte, ");
INSERT INTO tlf_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","iip maak maak imi aget fugunin uyo, Yesus iyo dagalupta, kuguup migik umaak kanu-balata, atamupta e, kuguup mafak umaak ke-be kalaa agelum o age-nilipta, bogobelip, “Kabo mirakel ko age kuguup ugulumi migik umaak numi kafalebelapta, nuyo utamupta e, God ita dong dogopkelata, kanupmin kuguup uyo kanu-balap kalaa agelum o,” age bogobelip kuta, ");
INSERT INTO tlf_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesus iyo kulip imi aget fugun-bilip boyo utam-nala e, bogobela, “Ibaa. Do weng kaa bogobelan-temi koyo tele tinangku-silipta. Abiip maagup uyo bigi ko miit alop kelu alop igil dinan-kalip umdii, bilip imi titil fagaa tambaliim nuubip uyo kota binimanan-temu ko. Ulutap kale, mungkup unang tinum am maagup albip iyo wengaal kup digin-bom suun kup dinan-kalip umdii, maagup nan-temaalip binim kale, igil bigi ko una tala kelan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kale ulutap Saatan so ilami sinik mafak sino ulimal igil waasi kebina tala ke bigi ko miit alop ke dinan-kalip nimnam, ulimal kulip iyo titil fagata tambaliim albaalip e minte, bilip imi titil uyo binimanepman o angbu no kuta ko. Kale ibo bogopne-nilip, ‘Belsebul iyo Yesus imi diim kal bom-nalata, dong daga-e-balata, unang tinum sinik mafak imdugan unsu bilip iyo fot tebela yak iinan-bilip o,’ agan-bilip (kuta, ipmi weng bagane-bilip bomi magam uyo bogo-nulu e, ‘Saatan iyo tebe ilami sinik mafak sino dinan-bilip o,’ agan-bo kuta, Saatan iyo kanum-nama binim kale, ibo amon amon ke-bom-nilipta, weng boyo bagan-bilip) kuba. ");
INSERT INTO tlf_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Niyo sinik mafak iyo fot tebeli yak iinan-nuubip kale, ulutap ipmi okumop man igil mungkup sinik mafak iyo fot tebelip yak iinan-nuubip kale, ibo bogopne-nilip, ‘Saatan ita Yesus beyo dong dogobelata, sinik mafak iyo fot tebela yak iinan-bilip o,’ nagan-bilip kuta, ipmi okumop man bilip iyo utamipta e, tinum iyo maak Saatan imi titil uyo ku-nalata, sinik mafak iyo fot tebela yak iinoma binim kalaa age utamsip kale, bota utamipta e, ibo nimi sang bagane-bilip boyo bisop weng bagane-bilip kalaa agan-bilip kuba. ");
INSERT INTO tlf_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","God yagal niyo titil kopnelata, sinik mafak iyo fot tebeli yak iinan-nuubip kale, God yagal niyo titil kopnelata, niyo sinik mafak iyo fot tebeli yak iinan-nuubip kale, siin God imi tebe ipmi bogobe-nala, ‘Nimi tinum ulaa duli kamok kesa iyo daali tal ipmi diim abe dong daga-e-balata, ibo mitam nimi daam tem e tolon-temip o,’ agela fen tebesip iyo nita kale, ibo nimi kuguup ko kanu-bii boyo utamipta e, fen kalaa agelin o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kale Yesus iyo ilami titil kiim uta uta ke Saatan imi titil kubaganu kupkasu umi sang uyo felep yak ku to do weng maak bogobe-nala e, “Tam tinum titil tebesa maak ilami mufekmufek uyo kan ke kulep tam ilami am to-nalata, dinan-kalin mufekmufek uyo fiko ko bigi-bom ilami am uyo tiin mo-balata, ilami mufekmufek uyo tambaliim nuubuta minte, ");
INSERT INTO tlf_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","tinum maak atin titil kup tebesa iyo tal tamata, isino dinan-bii ita ita ke-nalata, ipkum am kayaak imi waasi dinan-kalin mufekmufek fiko ko-nala, ‘Kaal non-temaalu o,’ agan-be so e minte ipkum imi mufekmufek kan ke kulep tam am toba so uyo alugum dugu kulep no ilami waasi dinan-kalin tinum imi togopman-tema bole, tinum am kayaak bemi titil uyo ko biniman-temu ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Kale unang tinum iyo dogap ita nimi ogok kenemin binim min, ipkumal dong daga-e-bilip meng nimi daam tem e telemin binim min umdii, bilip iyo nimi waasi ilitap ke unang tinum uget taga-bilip nimkaa yang iinebip ulutap ke-bomta kanum-nuubip o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesus iyo do weng migik maak baga-ema ko. “Sinik mafak iyo tinum maak imi diim kal nuubata, dupkaa daage no ok binim bagan umi diim maak kugol yang o meng o ke-bomta baan diim umaak utam-nilita, nan o age-nala e, fen te te kemata e, baan diim umaak utamin-tem keli kalaa age-nala e, bogola, ‘Nimi am binim kale, asok no nalami tinum dupkaa ti-sii imi diim kal nan-temi o,’ age-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","asok unanbu no abomu, imi tinum imi iibak tem uyo am umi ifip tolo alugum mufekmufek kan kelip albu ulutap kebu kalaa age-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","no sinik mafak ban kal maak iyo itamata e, bilip imi kuguup mafak uyo nimi kuguup uyo nimkan ke ita ita kesip kalaa age-nala e, asok kulep tal tinum imi diim tola e, alugum maagup bom-nilip e, kamaki umi sinik mafak ilasinon nuuba beyo kubagana e minte, aaltam umi sinik ban kal bilip ita ita kelipta, kamano komi tinum bemi aget mafak fugunin uyo atin mafagan uta uta ke-nuluta, kamaki umi aget fugunin mafak kanum-nuuba uta kubaganu kupkalu o,” age Yesus iyo do weng baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kale Yesus iyo weng boyo unang tinum kwiin tagang tem kugol bogopma e, unang maak usiik Yesus imi fomtuup bogobelu, “Kabaa. Tambaliim kale, kapmi kogen uyo kamo-nuluta, muuk uyo kupkake-bom tiin mo-bom-buluta, fito te tam tinum ke-salap kale, God iyo tebe kogen uyo kuguup tambal kupka-e-balata, deng tebe-buluta o,” agelu e, ");
INSERT INTO tlf_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesus iyo bogopma, “Dam bogolap kuta, unang tinum iyo dogap ita God imi weng uyo tinangka-bom God imi kuguup tambal uyo waafuu kwep tebe-bom no kemip umdii, kulip ita God iyo tebe kuguup tambal uyo maak so kupka-emin kup keman-tema o,” age-nala e, Yesus iyo unang bomi weng uyo yan kebe bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Unang tinum kwiin tagang iyo, no Yesus iyo atama-bulupta, mirakel ko age kuguup ugulumi migik umaak kanubela utamum o age tal fufala dolip e, bogopma, “Ibo aget fugunin mafak uyo fugun-bilip kale, ibo bogopne-nilip e, ‘Mirakel ko age kuguup ugulumi migik umaak kafalebelapta, utamupta, fen God yagal kamdala ti-salap kalaa agelum o,’ age-nilip e, fomtuup dagagamin kup ke-bilip kuta, niyo kanupmin kuguup boyo maak kanupmita, bomi deng uyo tebeman-temaalip kale ki, maagup maak uta kup kafalepman-temi boyo Jona imi top aniing kwiin kiim umi mat tem kugol bii, am alop ke-nala am asuno diim komi mitam e tisa ulutap uta maak kafalebelan-temi ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Sugamiyok uyo God imi profet ko age weng kem baga-emin tinum Jona iyo ilami abiip uyo kupkaa unanbu no tinum miit maak imi abiip miton Ninive kutam iinom-nala e, Ninive kasel iyo bogopma, ‘Ibo kuguup mafak kanum-nuubip boyo kupkalin o,’ age bogobe yakyak kemsa ulutap kale, Mo Tibil imi Man niyo tal kamano komi unang tinum albip ita bogobe-nili, ‘Ibo kuguup mafak kanum-nuubip boyo kupkalin o,’ age baga-eman o ageta ti-sii ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Sugamiyok uyo Seba kasel imi tiin molin unang ko age kwiin uyo, Solomon imi weng tambal uta tinangkulan o age-nuluta, umi abiip uyo kupkaa talanbu tal Israel kasel numi bagan koyo ti-suu kale, son-temu nala am afungen am daanan-temu uyo, God tebe unang tinum alugum imdep no weng telelamin baan diim daa-nala yegeman-tema uyo, unang bota fen mo-nuluta, ipmi sang uyo bogo-nulu e, ‘Solomon imi weng tambal uyo kubaganuta, Yesus imi weng tambal uta uta kesu kuta, unang tinum kulip iyo tolong dosaalip binim o,’ age God imi bogobelan-temu ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ulutap kale, am afungen am daanan-temu uyo, God tebe unang tinum alugum imdep no weng telelamin baan diim daa-nala yegeman-tema uyo, Ninive kasel iyo fen mo-nilipta, ipmi sang uta bogo-nilip e, ‘Nuyo Jona imi weng tambal uyo tolong do-nulupta, aget fupkela ko-nulupta, numi fengmin uyo kupkasup kuta, Jona imi weng tambal uyo kubaganuta, Yesus imi weng tambal uta uta kesu kale, unang tinum kulip iyo Yesus imi weng uyo tolong do-silip kuta, kulip iyo bogo-nilip, “Nuyo aget fupkela ko-nulup numi fengmin uyo kupkalan-temaalup o,” agesip o,’ age Ninive kasel iyo ipmi sang uyo God imi bogobelan-temip o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesus iyo do weng maak bogobe-nala e, “Tinum dok ita ilaam uyo kefo-nalata, kwep daak am kabut tem min, baket tem kulagal daalan-temaala binim kale, kefo kwep tam ulumi baan diim daalata, am uyo ilagenuta, unang tinum am e tolon-temip uyo, mufekmufek uyo tambaliim utaman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ipmi tiin boyo amitem ulutap kale, amitem boyo bitolip umdii, ilagenamin uyo am e tolon-temu ko. Ulutap kale, ipmi tiin uyo baalip umdii, ilagenamin uyo tal ipmi aget tem uyo e tulu utam-nilip e, kuguup tambal kup kanuman-temip ko. Kale minte ipmi tiin uyo mafaganebelu umdii, ibo mililep tem kal bom-nilip e, mufekmufek umaak tele utama-bomta, kuguup tambal umaak kanuman-temaalip binim ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kale ibo tele utama-bom-nilipta. Ibo tiin mafak ilitap, amon amon ke-bom ipmi aget fugunin uyo mililep tem ulutap ke nin ba kale, tiin tambal bom mufekmufek utamamin ulutap ke-bom tambaliim kup bom-nilipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ibo God imi ilagenamin uyo kupkalip te daak ipmi aget tem uyo kefolan-temu uyo, ipmi aget fugunin mililanebesu uyo alugum ilagenu kupkabeluta, ibo ilagenin diim kal atin nan-temip o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesus iyo weng baga-em-siit kupkala e, Falosi maak iyo Yesus imi bogobela, “Kabaa. Talapta, nisino alop no nimi am kal iman unelum o,” agela e, Yesus iyo isino alop no Falosi imi am kutam kal tonip ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kale Falosi iyo Yesus iyo atamata e, Yesus iyo Juda kasel numi kuguup uyo ku sagaal uyo diing daa-nama binim ke kupka-nala e, iman unela kalaa age-nalata, kumang mola ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kale Kamogim Yesus iyo imi kumang mola uyo utam-nala e, bogopma, “Ulotu umi ulo waafunamin uyo ki, Falosi ibo dis so kap so uyo mitam kaal diim uta kup diing dagan-nuubip kuta minte, iibak tem kulaak uyo diing dagan-nuubaalip kale, kulaak uyo ninak so kup-kagan-nuubip kale, ulutap mungkup ibo, mufekmufek bo nulumi kup keluk o age-nilipta, ipkumal imi mufekmufek uta yuguut daga-e-bom-nilip e minte, asit kup dagaga-bilip ipkumal imi mufekmufek uyo kupka-e-bom no kem-nuubip kale, ipmi iibak tem kutam uyo ninak tebe kufak daasu ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ipmi aget fugunin uyo amon amon ke-bilip kale, tele utamin. God imi mufekmufek telela kosa uyo, iyo iibak tem uta kup telela kosa bele ki? Umbae. Iyo iibak tem sino minte kaal diim so uyo maagup telela kosa kuba. ");
INSERT INTO tlf_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ibo aget fugunin uyo fupkela ko-nilip unang tinum mufekmufek duumatanip kalaa agelip iyo i-filin-bom-nilip e, ipmi unan-kalin dis tem albu min, kap tem kulaak ok so albu min uyo taga-eman-temip uyo, ibo God imi tiin diim uyo atin tambalanan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Falosi ibaa. Ibo tinangkulin. Ibo unan-kalin kangkang min, kumak min, dugol min iyo ilo dep ku daa yakyak kelip baan nagaal kal keluta, baan maagup keta kup God imi dupka-em-nuubip kale, ulutap kale, ibo kuguup kangkang umi aget uta bubul ugel kala-nilip e minte, kuguup kwiin kiim umi aget uta ilumano no kem-nuubip kale, boyo ki, ibo God imi aget aa bubul aa uyo ugel kalagamin binim e minte, ilipmi ipkumal iyo alugum maagup kuguup tambal uta kup kupka-emin binim no kale, God iyo ipmi deng uyo tabanbaala binim kale, son-temu uyo, bomi kalan uta God iyo kaal fuyap uyo kupka-eman-tema ko. Ibo kuguup afaligen umi aget ugel kala kanuman-temip uta, God iyo deng afaligen keman-tema kale, kuguup kangkang ita kup kemin ba kale, kuguup afaligen ke-bom no kemin o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Falosi ibaa. Ibo no ulotu am unon-temip uyo, ‘Nuyo tinum kamok kale, no abiin tambal uta ugaa ku tonupta, unang tinum iyo alugum nuyo itamamin o,’ age tonan-nuubip kale, ulutap kabo no iman saanin baan diim unon-temap uyo, kapmi aget fugunin uyo, ‘Niyo kem diim kugol mo-bilita, unang tinum iyo alugum tal bogopne-nilip e, “Kamogim kabo albap aga? Kafalemin tinum kabo salap aga?” agan-kalin o,’ age-nalapta, kanum-nuubap kuta, son-temu uyo, God iyo tebe bomi kalan uta kabo kaal fuyap uyo kopkelan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Kek kek imi kataman-bilip uyo, kaal diim kota, ‘Kabo tinum tambal o,’ kagan-bilip kuta, kapmi iibak tem kwek umi aget mafak bubul mafak fugun-balap uyo tinum kaana dep no dubalip kafin tem kulagal sang daga-bala unang tinum iyo utamin-tem ke-bom-nilip e, umi tip diim ku-tele tiinan-bilip ulutap kale, son-temu uyo, God iyo tebe bomi kalan uta kabo kaal fuyap uyo kopkelan-tema o,” age Yesus iyo Falosi imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kale ulo utamsa tinum maak iyo mitam Yesus bogopma, “Kafalemin kabaa. Kabo kanupmin weng bogolap boyo, nuyo mungkup itafi-balap kalaa agan-bulup o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesus iyo bogopma, “Dam bogolap kale, ulo utamsip tinum ibo unang tinum iyo bogobe-nilip, ‘God imi weng kem kwep daasa uta kup waafulin o,’ agan-nuubaalip kale, ipkil tebe weng kem migik migik uyo kwep tam God imi weng kwep daasa umi tip diim ku to-bom-nilipta, unang tinum bogopmip, ‘Waafulin o,’ agan-nuubip ko. Kale unang tinum iyo utamipta e, ulo kwiin tagang uyo bong faga-bom waafunamup kalaa age-nilipta, aget iluum tebe-em-nuubu kuta, ibo i-filin-bom dong daga-e-bilipta, ulo uyo waafunamin binim kem-nuubip kale, son-temu uyo, God iyo tebe bomi kalan uta ulo utamsip tinum ipkil mungkup kaal fuyap uyo kobelan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","“Ipmi olal iyo God imi profet ko age weng kem baga-emin tinum iyo an-bii kulep no iman-bii-silip kale, ibo bisop bilip imi aget uta fugunup ko age-nilipta, imi duu diim uyo tambalanuk o age-nilipta, tuum uyo kulep ilaga-e-bom-nilip e minte, at ket san uyo u-e-bom no kem-nuubip kuta, ipmi aget tem uyo, ‘Tambaliim ke olal iyo tebe bilip iyo ano-silip o,’ agan-nuubip ko. Kale ilipmi olal ilitap e minte, iliptap no kale, bilip iyo tebe ano kuba-silip kale minte, ipta imi duu diim uyo tiin mosip kale, son-temu uyo, God iyo tebe bomi kalan uta ibo kaal fuyap uyo kobelan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kale God iyo yak abe alugum mufekmufek bo utamsa tinum kale, iyo ipmi kuguup sang uyo bogo-nala e, ‘Niyo nalami profet ko age weng kem bagamin tinum so minte kalaan tinum so iyo imdali no unang tinum imi diim abelan-temip kuta, tinum bilip iyo tebe iip maak maak iyo ano kuba-bom-nilip e minte, iip maak maak ita kaal fuyap uta kup kupka-e-bom no keman-temip o,’ age God iyo bogosa ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Sugayok God imi kafin so abiil so telela kosa kulota ipmi olal ita tebe God imi profet ko age weng kem baga-emin tinum iyo an talanbu tal kaa diibelip kale, tinum kamano komi albip ipkil mungkup nimi kalaan tinum iyo ano kuba-bom no keman-temip kale, bomi kalan uta God yagal tebe ipmi olal imi yuum so minte ilipmi yuum kusino kwego dego ke-nalata, yuum bomi yan uta God iyo kaal fuyap uyo ibo kobelan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kale kamaki uyo Kein isiik tebe ilami niing Abel iyo angkola kaanata bole, kulota God imi ogok kemin tinum iyo kek kek iyo tebe an kwep tebesipta, kwep talanbu tal pris ko age tinum amem maak asegim Sekaraya umdii God imi am amem kek e minte mufekmufek fuulip ken tebemin baan diim kek no iibak kugol angkolipta, kaan no ke-se ko. Kale asok bogobelan o ageta kale, tinangku-silipta. Ipmi olal iyo kanube fengam tebesip kale, bomi yuum uyo tal imi man ilop ipmi diim abeluta, God iyo tebe ibo kaal fuyap uyo kobelan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ulo utamsip tinum ibaa. Ibo utamipta e, God imi suuk kon tem weng uyo God imi aget fugunin weng uta kafale-bulu utaman-bulup kalaa agan-nuubip kuta, ipkil, God imi aget fugunin kuguup uyo kanumaalup o agan-bom-nilip e minte, ipkumal iyo, God imi aget fugunin kuguup uyo kanumum o agelipta, ipta imtal imtal ke-bom no kem-nuubip kale, son-temu uyo, God iyo tebe bomi kalan uta ibo kaal fuyap uyo kobelan-tema kale, utama-bom-nilipta o,” age Yesus iyo ulo utamsip tinum imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Yesus iyo am kutam uyo kupkaa abiip iina e, alugum maagup yak kuto no ke tam abe abe-bom-nilip e, ulo utamsip tinum so Falosi so iyo Yesus imi olsak kobe-nilip e, Yesus imi bon tem uyo dagak diibe-bom dagaga-bulupta, weng mafak umaak bogola kalaa age-nulupta, bota dep no weng telelmin baan diim daalum o age-nilipta, atafimin weng sino bisop bagamin weng sino dagagamin weng kwiin tagang sino uyo dital fagaa Yesus imi baga-emip ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Unang tinum kwiin tagang iyo tala tala ke afeta-nilip e, Yesus imi weng uta tinangkulum o age-nilipta, ilek ilek ke-bom ipkumal iyo yaan tuup imdaak tamaga-bom ke-bilip e, kota Yesus iyo ilami okumop man imi agol kup bogopma, “Ibo Falosi imi yiis ko age tukolip bret fitimin umi mufekmufek uyo utama-bom kupkek kupkek kem tiine-bom-nilipta o ageta kale, Falosi imi kuguup alop waafulin umi sang uta kam agan-bii ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Falosi imi kuguup mafak bantap kanumin so minte bisop bagamin kuguup so uyo yiis ko age bret fitimin mufekmufek ulutap kale, son-temu uyo, God yagal imi kuguup mafak uyo kupkem daabela unang tinum iyo alugum utaman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ulutap kale, mililep kota kapkum iyo kuguup mafak umi sang bantap bogo, ‘Kanubelan-temup o,’ age bogobelap umdii, son-temu nala am daanin diim kota unang tinum iyo alugum alop ipmi bantap weng bogobip boyo tinangku en-bom tegen-bom keman-temip e minte, intap intap mafak umi sang agol kup kalapmi am kutam kal bogolap umdii, unang tinum iyo alugum abiip mat kal kapmi bogobap bomi sang uyo olan-bom no keman-temip o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yesus iyo maak so bogobe-nala e, “Nugumal ibaa. Nimi weng maak bogobelan-temi kale, tinangku-silipta. Tinum iip maak maak iyo bogobe-nilip e, ‘Ibo Yesus imi weng boyo baga-em top iip kwegal dugang age kupkalin-tem kelip umdii, inolan-temup o,’ agelan-temip kuta, iyo tebe ipmi dam uta kup ungkwalip kaanan-temu kuta, son-temu uyo, ipmi suun nin sinik uyo ungkwalip kaan maagalo kelan-temaalu binim ko. Kale bilip imi atul uyo finanin ba kale, God maagup imi atul uta kup finanin kuba. ");
INSERT INTO tlf_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kale minte God iyo om kun so kale, beyo tebe kangkola umdii, beyo tii kamdala yak suun at kenamin abiip unomap kale, bemi atul uta finanin ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Kuta ipkil tinangku utamin. Tinum iyo tuumon ken tibin alop ita dulu-nilipta, uun kangkang ogal iyo molan-temip kuta, God iyo uun katip maagup imi aget umaak kupkalan-temaala binim kale, ");
INSERT INTO tlf_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","God imi tiin diim uyo uun kangkang iyo kubaganipta, ipta ipta kesip kale, God iyo ipmi aget uyo maak ilumanolan-temaala binim kale, beyo ipmi dubom kon uyo tikilata e, intap kal kalaa age utam som, minte alugum mufekmufek mek ipmi diim aban-nuubu uyo utam no kesa kale, ibo tambaliim tiin mo-bom dong daga-em-nuuba kale, kafin diim tinum bilip imi atul uyo finanin ba o,” age baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yesus imi okumop man imi bogobe-nala e, “Ibaa. Weng maak bogopman-temi kale, waantap kapta no unang tinum imi tiin diim uyo bogo-nalap, ‘Niyo Mo Tibil imi Man imi okumop man keli o,’ agelap umdii, God imi yege-bom kaal fuyap kupka-eman-tema umi am daanan-temu kota, niyo God imi ensel imi tiin diim uyo bogopke-nili e, ‘Beyo nimi okumop man o,’ kagelan-temi kale minte, ");
INSERT INTO tlf_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","waantap kapta bogo-nalap, ‘Niyo Mo Tibil imi Man imi okumop man kelaali o,’ agelap umdii, God imi ensel imi tiin diim uyo bogopke-nili e, ‘Beyo nimi okumop man ba o,’ kagelan-temi ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Niyo Mo Tibil imi Man kuta, unang tinum waantap ita niyo weng mafak uyo baganem-siit-nala asok aget fupkela kola umdii, God yagal tebe bemi yuum uyo kupkan kebelan-tema kale minte, unang tinum dogap ita God imi Sinik Tambal imi weng mafak baga-ema umdii, God iyo bemi yuum uyo kupkan kebelan-temaala binim ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","12","“Kale tinum iyo itamipta e, ibo nimi okumop man kalaa age-nilip e, imtamo no ulotu am daalipta, Juda kasel imi kamogimal iyo tebe yegeman-temip e minte, imtamo no kiyap imi diim daalipta, ita yegeman-temip no kale, kanu-eman-temip uyo, ibo aget yamyam uyo fugun-bom, ‘Kwiin. Kota weng kwep mek numi tem tilibelan-temip bota, intaben o agelan-temup a? Dogonupmin weng uta kuta yan ke-eman-temup o?’ agan-kalin ba kale, bilili age-bom-bilipta, kota God imi Sinik Tambal ita tebe ibo kuguup tambal uyo kafale-balata, weng tambal uta kup baga-eman-temip o,” age Yesus ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Unang tinum kwiin tagang iyo Yesus iso mo-bom-bilipta, tam tinum maak unang tinum kwiin tagang tem kulaak ilota bogola ko. “God imi weng kafalemin kabaa. Kabo nimi baap beyo bogobelapta bole, numi aatum kaanba imi kafin so minte mufekmufek sino uyo togo-nalata, nagal atuk kopnelata o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesus iyo tinum bemi bogobela ko. “Nugum kabaa. God iyo nimdala tal-nilita, ipmi kafin sino mufekmufek sino umi weng uta telela-bom taga-emak o age-nalata, nimdala tisaali kale, niyo ogok migik kemin tinum o,” age-nala e minte, ");
INSERT INTO tlf_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","fupkela kek fen unang tinum imi bogobela ko. “Ibo nimi weng kaa bagan-bii koyo tele tinangku-silipta. Tinum mufekmufek soyaap iyo ilami mufekmufek uta dong dogopmuta, tambaliim kup koyo nan-temaala e minte, kutop uyo nan-temaala no ko. Kale ibo ipkumal imi kafin sino mufekmufek sino umi mok uyo unan-kalin ba o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tam Yesus iyo do weng maak bogobe-nala e, “Tinum mufekmufek soyaap maak bemi ilanggiip uyo rais ko age wiit tagang uyo tebelu kalaa age-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","tinum beyo ton-bom aget fuguna ko. ‘Nimi wiit kulep tam tomin am uyo kwiin tagang ba e minte, kwiin kiim ba no kale, wiit bomi baan diim uyo duumatanuta, kota dogonubelan-temi a? ");
INSERT INTO tlf_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Uyo? Nimi wiit am uyo dalata ko-nilita bole, am kwiin kiim kiim kup de-nilita, nimi wiit sino mufekmufek sino uyo kulep tam tolan-temi ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Son-temu nala am bomi binimanu kupkalan-temi uyo, aget fugun-bom-nili e, ‘Misam ke nimi mufekmufek kwiin tagang uyo tii keli kale, kota bii atol yamyam ke-nilita, kun fingka-bom-nili e minte, unan-kalin kwiin tagang unan-bom-nili e, ok mafak kwiin tagang unan-bom no ke-bom-nilita, deng tebeman o,’ agelan-temi kalaa age kanupmin aget uyo fuguna ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kuta God iyo bogobe-nala e, ‘Ilum ilum bii tonsap tinum kabaa. Kamano mililep kota kaan-nalapta, kapmi mufekmufek telela-bii kwep dagan tebesap uyo kupkalan-temap kale, boyo waantap ita kululan-tema o?’ age-nalata, God iyo tinum bemi baga-emsa ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Kale ibo utamin. Kanube tinum kulatap ke ilipmi aget kup fugun-bom-nilip mufekmufek afetaman-temip uyo, ibo God imi tiin diim uyo fen win binim o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kota Yesus iyo ilami okumop man iyo bogobe-nala e, “Ibo kamano nimi weng bogobeli uyo tolong dolip a? Kam ageli umi atuk uyo aa bogopman-temi ko. Ibo ipmi kaa tibip umi aget afek uyo fugun-bom bogo-nilip, ‘Iman bo dok ku-tele maak tuluta, unan tubup o?’ agan-bom-nilip aget yamyam taga-bom-nilip e minte, ilipmi kaal aget uyo fugun-bom bogo-nilip, ‘Ilim boyo dok ku-tele maak tuluta, migilan-temup o?’ agan-bom-nilip aget yamyam taga-bom no kemin ba ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","God ita mufekmufek afaligen ko age ipmi mam so dam so uyo kobelata, koyo albip kale, mungkup, mufekmufek katip ko age unan-kalin so ilim migimin so ugol mungkup fen God iyo tebe kobelan-tema no kale, bomi aget uyo yamyam tagamin ba ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ibo uun bilip iyo itamin. Bilip iyo iman ilang digin-kalin binim. Iman wemin binim. Iman afeta-bii kulep no am tomin binim. Kuta God yagal iman uyo kuga-e-balata, unan-nuubip ko. Kuta God imi aget aa bubul aa kwiin kiim uyo unang tinum ipmi kobe-nalata, uun ita imdep te magaang tem daa-nalata minte, ipta iman uyo kupka-e-balata, iman uyo tii unan-nuubip kuba. ");
INSERT INTO tlf_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ibo aget yamyam taga-bom ilipmi kaal ilak dugamin bota tebe dong dogobeluta, ibo tii ipmi nin uyo kayop aa-e min, atol aa uyo maak so tifilip top so keluta, kafin diim kagal bii, ilugolan-temip aga? Umbae. God iyo bogo-nala, ‘Kota kaanal o,’ agon-tema uta, kaanan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kale kayop tifimin min, atol tifimin min uyo ibo bagang-kale kanube-nimip binim kuta, intaben o age-nilipta, mufekmufek kwiin kiim umi aget uta yamyam tagan-bilip a? ");
INSERT INTO tlf_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Ibo tiginal umi ilala boyo utamin. Boyo tinum nulutap keluta, ulumi ilim uyo telela-bom biginamin binim kale, boyo bisop iip kugol tebemin kale, God yagal tebe tiin mo-balata, boyo tebe-bom-nuluta, umi ket tambal uyo abum-nuubu ko. Sugamiyok tinum win tibin Solomon bemi bii-se uyo, beyo mufekmufek soyaap kale, ilim tambal tambal uta kup tii-bii-se kuta, imi ilim unang tinum ilimi sagaal tuup telele-bom bigine-bilip tii-bii-se bomi dong uyo kubaganuta, God imi ilala ket telela kosa umi dong tambal uta uta kesu ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kale ilala boyo tiginal kal bomu kale, bomi ket tambal uyo abulu siit ilugo datanu e, tinum tebe baam uyo kwek kalalip ilala kuso ken tebe-bom no kem-nuubu kuta, ilala boyo God yagal tebe telela ko tiin mo-balata, tambaliim ket uyo abum-nuubu ko. Kale ninggil ibo aget alop uyo taga-bomta, ‘God beyo nuyo ilim kaal uyo kobelan-tema bele ki, kobelan-temaala o?’ agan-nuubip kale, ibo tele utamin. God imi aget aa bubul aa kwiin kiim uyo ipmi kobe-nalata, ilala ket uyo kulep te magaang tem keng to-nalata minte, yagal ipmi ilim kaal boyo kupka-eman-tema ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kale ibo kanupmin aget bota fugun-bom-nilipta, unan-kalin aget uta kup ugaa kwaa-nilip aget yamyam tagamin ba ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Alugum kafin diim komi unang tinum God imi ilak dolin binim bilip iyo suun kup ilim so unan-kalin so umi aget kup ugaa kwaa aget yamyam tagan-nuubip kale minte, ipmi Aalap God yagal utamata e, ibo suun kup unan-kalin umi ilep uyo fen-bilip kalaa agan-boma ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kuta mufekmufek miton ipmi dilinan-temip uyo kulbu kale, ibo, God imi daam tem iinom ilami aligaap ke-nulupta, ilami tol kuguup uta kup waafulum o age dilin-bom-nilipta, God imi aget uta ugel kalalin o ageta kale, ibo kanumip bole, God yagal dong daga-e-bom-nala e minte, ipmi mufekmufek dilin-bilip migik ko age iman min, ilim uyo kuga-e-bom no keman-tema o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Asok Yesus iyo ilami okumop man imi bogobe-nala e, “Ninggil ibaa. God iyo aget fuguno-nala, ‘Ibo imtamo tal nalami abiip kaa daalita, nin o,’ agan-be kale, ibo kafin diim komi mufekmufek aget uyo yamyam taga-bom finanin ba ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kanube ibo mufekmufek kwiin tagang kalaa agelip umdii, mufekmufek boyo kulep tolip molip tuumon kululan-temip uyo, kulu unang tinum iyo itamipta, bilip ita duumatanbip kalaa age-nilip bilip imi togobelip asok bota dong daga-emuk o ageta ko. Kafin diim koyo men so ilim so boyo dusabanan-temu e minte, tuumon uyo yuut binimanan-temu e minte, tinom tebe mufekmufek uyo balatalan-temip e minte, tinum tebe mufekmufek yuguut dagaman-temip no kale, mufekmufek uyo binimanan-temu ko. Kale mufekmufek uyo kagal kwep mek kwego kwego ke-bom afetmin ba kale, God imi ogok uta tambaliim kup ke-bilipta biita, God yagal yan kebe imdep no ilami suun abiip daalata, tambaliim kup nin o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kanube tinum iyo maak kafin diim komi mufekmufek umi aget kup ugaa kwaala umdii, beyo kanupmin mufekmufek boyo kwep mek kwego kwego ke-bom afetman-tema kale minte, kanube tinum maak ita ilami mufekmufek umi aget fugunin uyo kupkaa God imi aget uta kup ugaa kwaagama umdii, tinum beyo God imi ilak uyo duga-bom imi kuguup uyo waafu-bom no kemin kup keman-tema o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Yesus iyo bogobe-nala e, “Ibo tinangkulin. Ibo kan ke-nilip nimi fen-bom bom-silipta siita, tolon o ageta ko. Niyo felep yak ogok kemin tinum maak imi diim to do weng maak bogobelan-temi kale, ipmi kuguup uyo ogok kemin tinum kulip imi kuguup ulutap kemin o ageta ko. Kale am maak daanu e, kulip imi kamogim iyo utamata, nimi duup iyo kamaa unang kula agam imi duup-afin iyo tala tala ke iman tigi-bom unan-bilip kalaa age-nala e, no tamita, isino deng tebemum o age una ko. Kale ilami ogok kemin tinum bilip iyo ilimi kamogim iyo dok kota asok tolon-tema kalaa agebaalip kale, maagalo mufekmufek uyo kan ke bigi-bom bom-silipta, mililanu kalaa age-nilip e, ilaam kefo kafan ton-bom ilimi kamogim iyo fen-bilipta, bii tal faal uyo dok dok keba kalaa age-nilipta, yuut fen no faal bitobelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kale ilami ogok kemin tinum iyo kafan ton-bom-bilip tal itam-nala e, ‘Suguul o,’ age-nala e, bilip imi deng uyo tebe-bom kuguup tambal uyo kafalebe-nala e, kamogim beyo ilami iman fuu-emin tinum imi kuguup uta ku-nalata, bogobe-nala e, ‘Daak tonipta, nagal iman uyo tafobelita, unelin o,’ age bogopma ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kale ogok kemin tinum bilip iyo utamta, am tiip tiip faa-buluta, toloma e? Bem abe-buluta, toloma e? agebaalip kuta, maagalo suun fenin kup ke-bilipta, iyo tal-nalata, bilip imi deng uyo tebe-bom-nalata, kuguup tambal uyo kafalema ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Weng maak bogobelan-temi kale, ibo tolong do-silipta. Kale tinum am kayaak iyo utamata, mililep uyo dok kota tinum yuguut unin iyo tolon-tema kalaa ageba nimnam, beyo kafan bom bigilata, tinum yuguut unin beyo dogobeta talta am boyo dalata ko-nalata, tam imi mufekmufek uyo dugu kulube mitam iinbaala ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kale ulutap ibo utamipta e, Mo Tibil imi Man niyo dok kota tolon-tema kalaa nagebaalip kale, maagalo tem kale, ibo suun kup bigi-bom telel-bom-nilipta o,” age-nalata, Yesus ilami okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Yesus iyo do weng uyo bogobela binimanu e, Fita iyo Yesus imi bogobela, “Kamogim kabaa. Do weng bogolap bota nuta kup bogopmap bele ki, alugum unang tinum so numi bogopmap o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kamogim isiik yan kebe bogola, “Agelap kale, ibo tinangku-silipta, niyo tinum ogok fomtuup ke-bom aget tambal fugun-bom no kemin tinum imi sang uyo bogobelan o ageta kale, kamok maak iyo, no abiip simanim kugol siit ilugo tolon-temi kalaa age-nala e, ilami kanupmin ogok kemin tinum maak ulaa du bogobe-nala e, ‘Kabo nimi ogok kemin tinum bilip iyo tambaliim kup itama-bom tiin mo-balapta, ogok tambal kup ke-bilipta, nimi mufekmufek uyo tambaliim kup bom-buluta, iman taga-emin ulumi am daanan-temu kota, kabo iman uyo ogok kemin tinum imi taga-emal o,’ age bogobe-nalata, dupkaa unon-tema ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kale ogok kemin tinum beyo kamogim imi weng uta tinangku-nala imi ogok uyo waafulin kup ke-bom ogok kema umdii, kamogim iyo asok tal abomu, tambaliim kup ogok ke-be kalaa age-nalata, deng tebeman-tema ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Kale kamogim iyo bogobe-nala e, ‘Utamita, niyo kugol bomta, katamin-tem bom-bilita, ogok tambal uyo kem-nuubap kalaa ageli kale, ogok afaligen uyo kapmi kopkelita, kapta nimi mufekmufek uyo alugum tiin molan-temap o,’ agelan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kuta kanube ogok kemin tinum beyo aget fuguno-nala, ‘Nimi kamogim iyo mufekmufek migik maak tebe daak tamalu kale, yuut tolon-temaala binim o,’ age-nala, ipkumal ogok kemin tinum so ogok kemin unang sino iyo ye-bom-nala, iman uyo tigi-bom unan-bom-nala, ok mafak uyo unan-bom ilum ilum ke-bii-nala, ");
INSERT INTO tlf_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","kamogim iyo dogap kota tolon-tema kalaa age fenin binim ke-bom no kema umdii, bom-balata, am maak daanu e, kamogim iyo talta utamata e, kuguup mafak kem tebesa kalaa age-nala e, imi kuguup mafak umdii yan ke-e-bom kaal fuyap kupka-eman-tema uyo kwaasulemin tinum imi kaal fuyap kupka-emin ulutap ke kupka-eman-tema ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Kale ogok kemin tinum iyo dok ita utamata, kamogim iyo kanupmin ogok bota kanumal o agela kalaa agan-be kuta minte, beyo ogok bomi aget uyo fugun-bomta kufo ogok kem-nama ba kale, imi weng uyo kwaasulema umdii, imi kamogim iyo tebe kaal fuyap afaligen uyo kobelan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kale minte ogok kemin tinum iyo dok ita utamata, kamogim iyo, kanupmin ogok kanumal o agela kalaa agelin-tem ke maagalo mafak kanuma umdii, imi kamogim iyo tebe agol kup kaal fuyap katip uyo kobelan-tema ko. God iyo aget fugunin tambal uyo tinum maak imi kobela dagaa kusa umdii, God yagal, ‘Kabo tambaliim kup ogok kemal o,’ agelan-tema kale minte, tinum maak ita God iyo suun kup aget fugunin tambal uyo kupka-emin kup na umdii, God iyo, ‘Kabo atin ki ogok tambaliim uta suun ogok kemin kup kemal o,’ agelan-tema o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesus ilami okumop man bogobe-nala e, “Niyo kafin diim e ti-sii koyo, unang tinum imi fengmin umi kaal fuyap kugamin umi sang uta baga-eman o age-nilita, ti-sii kale, kaal fuyap bomi atul uyo at togol tem diinamin ulutap kale, God imi kaal fuyap bomi kupka-eman-tema umi am boyo mep so tulu kale, nimi fomtuup aget fugunin uyo, yuut mitam tuluk o age-nilita, fen-bii ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Minte niyo kaal fuyap ogen uyo umtal daa kaanan-temi kale, bomi mitam tilin-tem bom-bulu uyo, nisiik utamita, bomi am uyo daanan-temu kalaa age-nilita, umi aget afalik uta tebe de namoluta, aget iluum tebepnelu bom-bilita bii, nimi kanupmin kaal fuyap uyo binimanan-temu ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kale ipmi aget fugun-bilip uyo, ‘Beyo tal-nalata, unang tinum imi weng uyo bogobeli alugum aget maagup kelin o age-nalata, ti-se o,’ nagan-bilip a? Umbae. Niyo talta, unang tinum iyo ilo kolan o ageta ti-sii kuba. Nimi weng tolong dolan-temip uyo, iip maak maak iyo tele tolong dolan-temip kuta minte, iip maak maak ita, tolong dolaalup o age umik ugobelan-temip kale, bigi ko miit alop ke-nilipta, waasi kebina tala keman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kale am maagup kutam uyo unang tinum ogal nip umdii, bigi ko alop igil kelip e minte, asuno igil ke no ke-nilip e, nimi weng kalan uta alop iyo tebe asuno iso wengaal digin-bilip e minte, ");
INSERT INTO tlf_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","aalabal tebe man tinum iso waasi kiina tala ke-bilip e, ogenal so man unang isino igil waasi kiina tala ke-bilip e, imegal tebe miin kalelal sino waasi kiina tala ke-bilip no keman-temip o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Asok Yesus iyo unang tinum imi bogobela, “Ibo utamipta, iip uyo iimanu kalaa agelan-temip uyo, ibo bogo-nilip, ‘Wep tolon-temu o,’ agelipta, fen talan-nuubu e minte, ");
INSERT INTO tlf_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ibo utamipta, ataan daak unemin ilep dulul tulu kalaa agelan-temip uyo, ‘Am kan tolon-temu o,’ agelipta, talan-nuubu ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Utamsip tinum ibo kafin diim so abiil tigiin so boyo utam-nilip e, ‘Am uyo kanupman-temu o,’ agan-nuubip kuta, ibo amon amon nin tinum imi kuguup uyo ku-nilipta, nimi weng baga-bili tinangkan-bilip umi magam uyo, ‘Utabaalup o,’ agan-bilip o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Yesus iyo weng migik maak uyo bogobela, “Ibo, intaben nulum o age-nilipta, ipkil aget fuguno-nilipta, bota kanuman-temup boyo felepman-temu kalaa agan-nuubaalip a? ");
INSERT INTO tlf_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Uyo kanumin kale, kanube kapkum iyo tebe bogopke-nala, ‘Kuguup mafak kepnelap kale, kamtamo no weng telelmin tinum imi diim daalan o,’ agela umdii, alop ibo yang weng telelmin tinum imi diim abelin-tem somta, kabo kapkum imi diim unap alop ibo weng uyo telela ko-nilip e, kapmi yuum uyo molap kaanuk o ageta ko. Kale minte kabo kamaki kugol boyo telela kolin-tem kelap umdii, kapkum beyo kamdep yang kamdala yak weng telelmin tinum imi diim abelapta, ita yega dopke kamdala yak un tubulin imi sagaal diim abelapta, ita tebe sok de kamdalip tam kalabus am unon-temap ko. ");
INSERT INTO tlf_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kale kugol bom-balap bii, kapmi fengmin uyo alugum molap atin binimanuta, talaa kamdalip mitam e tolon-temap ko. Kale kabo nimi weng boyo tele tinangku-nalapta o,” age Yesus iyo unang tinum imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kanupmin am daanbu kugol, unang tinum albip iyo tal Yesus imi diim kal bogopmip, “Unang tinum iip maak maak Provins Galili kasel iyo, God imi, ‘Misam o,’ agelum o age-nilipta, tolop uyo kulep tal tolipta, pris ko age tinum amem ita tolop uyo ino fuu-bilipta, kiyap Pailat imi waasi dinan-kalin tinum imdala tal Galili kasel bilip iyo inolip e, imi isak sino minte tolop imi isak sino kwego dego ke singkam daa-suu o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesus iyo bogopma, “Ibaa. Ipmi aget fugun-bilip uyo, ‘Galili kasel iyo, milii kulip imi fengmin uyo kwiin kiim kalaa age-nilipta, inolip kaanipta minte, milii imi fengmin uta katip kalaa age-nilipta, imkalipta, waalan-silip o,’ agan-bilip bele ki? ");
INSERT INTO tlf_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Umbae. Nimi weng bogobelan-temi ko tinangku-silipta. Ibo ipmi fengamin uyo kupkaa aget fupkela kolan-temaalip uyo, alugum ibo Galili kasel kulitap ke kaanan-temip kuba. ");
INSERT INTO tlf_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ulutap kale, siin uyo tinum ilimi kup 18 iyo abiip afalik Jerusalam umi tung tem Siloam kutam kal mo-bom-silipta bole, am timitim maak balaa kumen malaak abuta, inolu kaan-silip kale, ipmi aget fugun-bilip uyo, ‘Jerusalam kasel iyo, milii kulip imi fengmin uyo kwiin kiim utamta, boyo inolu kaanipta minte, milii imi fengmin uta katip atamta, inolin-tem keluta, waalan-silip o,’ agan-bilip bele ki? ");
INSERT INTO tlf_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Umbae. Ibo nimi weng koyo tinangku-silipta. Ipmi fengmin uyo kupkaa aget fupkela kolan-temaalip uyo, alugum ibo tinum kulitap ke kaanan-temip kuba,” age baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kale Yesus iyo do weng maak bogo-nala e, “At yet maak tinum imi sok dum ilang kulagal mosuta bole, tinum sok dum ilang kayaak beyo no at yet boyo utamta, yet umaak abubu kalaa agelan o age-nalata, tal abomu, at dum umaak abulin-tem kalaa agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kale ilami ilanggiip ogok kemin tinum imi bogobe-nala e, ‘At dum abumin umi am uyo daanuta, tal utam utam ke-bii atol asuno keli kuta, at yet koyo maak abumin binim kelu kale, at boyo ungkwalal a. Tam at bota tebe-nulu e, kafin umi tugul uyo alugum unan-bulu binimanan-temu bo mafak kale, at bo ungkwalal o,’ agela e, ");
INSERT INTO tlf_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ilanggiip ogok kemin tinum iyo ilanggiip kayaak imi weng uyo yan kepma, ‘Kamogim kabaa. At boyo kupkalup atol maagup umaak dakan keluta bole, at bomi magam tem uyo kafin fiksigi-nilita, at bomi iman unan-kalin uyo telelebelita, ");
INSERT INTO tlf_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","at dum umaak abulu minte, abulin-tem kelu kalaa ageta bogopnelapta, kota ungkwalan o,’ age-se o,” age baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tam God imi ifin am maak daanu e, Yesus iyo no ulotu am kal unang tinum iyo God imi weng uyo kafalema ko. ");
INSERT INTO tlf_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kale unang maak albu boyo sinik mafak tebe mafak ilin kobe kupkala nuubuta bii, atol ulumi kup 18 e minte atuk no dakan ke-nulu e, unang boyo daang sukmon kesu kale, uyo tele mo-numu binim ko. ");
INSERT INTO tlf_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kale Yesus iyo unang boyo utam-nalata bole, olabela tal tamu e, bogobela ko. “Unang kubaa. Niyo kupmi mafak ilin uyo kupkan kep-kami o,” age-nala e minte, ");
INSERT INTO tlf_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","imi sagaal uyo kwep yak unang bomi dubom diim daala e, maak fagaa tol kup mo-nulu e, God imi deng uyo tebe-bom-nulu e, imi win kufu-emu ko. ");
INSERT INTO tlf_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kale ulotu am umi kamok iyo utamata e, Yesus iyo God imi ifin am daanbu diim kagal unang uyo telela kola molu kalaa age-nala e, tinum bemi olsak uyo Yesus iyo kobe-nala e, unang tinum bogobela ko. “Am bugup kal boyo ogok kemin kale minte, God imi ifin am daanbu koyo ogok kemin am daanbaalu ko. Ibo tal Yesus imi finang tal tamipta, telela imolak o agelip umdii, ogok kemin am daanuta, tal tamipta telela imkamak o ageta kale minte, God imi ifin am daanu uyo, tal tamip telela imkamin ba o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tam Yesus iyo weng yan kebe-nala e, bogola ko. “Kuguup alop waafulin tinum ibaa. God imi ifin am daanbu diim uyo alugum ibo ipmi kao sino dongki sino iyo no ilimi am kal sok tiil to kulep no to ok uyo kobelip unan-nuubip bole a? ");
INSERT INTO tlf_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Unang koyo Abraham imi man ilop nulutap kale, unang koyo Saatan tebe kufak daalata, daang sukmon ke-bom bii atol ulumi kup 18 ko dakan kesu ko. Kale God imi ifin am kota felepneluta, Saatan imi sok de kosa uyo nita tebeta talaa kwaa-nili e minte, telela ko no keli o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesus iyo kam agelata bole, kota imi waasi iyo fitom afalik kup tebe-nilip e, weng maak bogolin-tem kelip kale minte, unang tinum iyo Yesus imi kuguup tambal telela-bii kupkaba uyo utam-nilipta, imi deng afalik kup tebemip ko. ");
INSERT INTO tlf_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesus iyo asok bogobe-nala e, “Unang tinum mitam God imi daam tem tilip tiin moba bilip iyo dogap ilitap a? Nagal bogobe-nilita, bilip iyo kanupmin unang tinum o agelan-temi ko. ");
INSERT INTO tlf_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Unang tinum God imi daam tem albip iyo mastat umi san ilitap kale, (mastat san beyo atin fen ilap katipnok kuta minte,) tinum maak tebe dep yang dola bemi tebe te tam kwiin kiim kelan-tema uyo, at ulutap ke kolu e, uun iyo te tam umi tung diim kutam kal imi um uyo dinan-kalon-temip o,” age Yesus iyo bogola ko. (Kale do weng bomi magam uyo bogo-nulu e, “Mastat umi san kulutap mungkup God imi unang tinum iyo kamano koyo iip maak maak kup kebip kuta minte, son-temu uyo, te tam te tam kem kwep unanbu top kwiin tagang kelan-temip o,” agesu ko.) ");
INSERT INTO tlf_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesus iyo asok weng migik bogobe-nala e, “Unang tinum mitam God imi daam tem tilip tiin moba bilip iyo dogap ilitap a? ");
INSERT INTO tlf_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nagal bogobe-nilita, bilip iyo kanupmin unang tinum o agelan-temi ko. Kale unang tinum God imi daam tem albip iyo yiis ko age bret fitimin mufekmufek ulutap kale, unang maak tebe yiis katipnok maak tagaa daalu yak flawa afaligen tem iinu fiksigi-bulu bii, maagup kelu kalaa age kupkalu siitap ilugolu e, flawa uyo fito ugulumi migik kelan-temu ulutap o,” age Yesus iyo kam agela ko. (Kale do weng bomi magam uyo bogo-nulu e, “God imi ilak dolin unang tinum iyo unang tinum migik imi iibak tem kal albip umdii, ipkumal God imi ilak dolin binim bilip iyo igilimi migik ke-nilip e, igil mungkup God imi ilak uyo do-nilip e, kwiin tagang kelan-temip o,” agesu ko.) ");
INSERT INTO tlf_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesus sino ilami okumop man sino iyo, Jerusalam unum o age tam tam yak abiip maak maak kem abe-bom-nilip e, abiip maak kugol bom Yesus iyo God imi weng uyo abiip kasel baga-e-bala siit-nilip e, kupkaa yakyak kemip ko. ");
INSERT INTO tlf_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kale tinum maak Yesus iyo daga-nala e, “Nugum kabaa. God imi yegeman-tema uyo, tinum iip maak maak ita kup ulaa imdulata, tam God imi abiip unon-temip bele ki?” agela e, Yesus iyo alugum bogobe-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“God imi abiip unemin umi amitem uyo katipnok kale, unang tinum kwiin tagang iyo, tam iinum o agan-bilip kuta, iyo bagang-kale tam iinon-temaalip binim kale, ibo dital fagaa God imi weng uyo tambaliim kup waafu-som-nilipta, God imi abiip uyo tam unin o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Am maak daanan-temu uyo, abiip tiin molin kayaak beyo fen mo no amitem faal ilolan-tema kale, tinum yang kugol albip ibo no abiip kal mo dok dok ke-bom ol-bom-nilip e, ‘Kamogim kabaa. Faal bitobelap tam tulum o,’ age olabelan-temip kuta, abiip tiin molin iyo yan kebe bogobe-nala e, ‘Umbae. Ibo maak tibit kupkem daalip itamsaali e minte, ibo dogap kal nuubipta, tilip o?’ age dagalan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kale ipkil bogobe-nilip, ‘Kabo tal numi abiip uyo utama-bom nusino iman unan-bom ok unan-bom minte God imi weng tambal uyo baga-e-bom no ke-bom itamsap bole o?’ agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","asok bogobe-nala e, ‘Niyo itamta, fengmin unang tinum ibo nimi unang tinum kalaa agesaali kale, nimkaa daaginin o,’ agon-tema ko. ");
INSERT INTO tlf_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ibo itamipta, numi olal Abraham so Aisak so minte Jekop so minte alugum God imi profet ko age weng kem baga-emin tinum sino iyo God imi abiip kal albip kale minte, God iyo tebe nuyo umik ugobe-nala e, imdala mitam sep kutam kal albup kalaa age-nilipta, ‘Kwiin. Bo so kubo,’ agon-temip kale, ibo kaal fuyap tebebe bom-bulu ilipmi kaal kalan uyo ameman-temip kale, ");
INSERT INTO tlf_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","kafin kaa kutufosu komi unang tinum kaal kaal iyo tala tala ke-nilipta, Juda kasel iip maak maak kup sino kwego dego ke-nilipta, no God imi abiip kugol God imi man aligaap ke-nilipta, ton-bom iman unan-bom deng tebeman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Unang tinum iip maak maak kamano komi win binim ke kubagansip iyo am afungen tem kota isiik win so kelip e minte, unang tinum iip maak maak kamano komi win so albip isiik am afungen tem kota win binim ke kubagan no kelan-temip o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kota Falosi iip maak maak iyo tal Yesus imi bogobe-nilip e, “Kabaa. Provins Galili umi tiin molin tinum Herot iyo bogo-nala, ‘Nalami waasi dinan-kalin tinum iyo imdali no Yesus iyo angkolip kaanak o,’ kagan-be kale, baan yuut Galili koyo kupka-nalap daaginaal o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesus iyo yan kebe-nala e, “Herot beyo kuguup mafak utamsa tinum kale, ibo asok no bogobe-nilip e, ‘Yesus imi weng bogopkeba koyo tele tolong dolal o ageta ko. Bogopke-nala, “Niyo kapmi atul uyo finano bilii unon-temaali binim kale, kamano so amsap so uyo unang tinum sinik mafak kwan unsip iyo fot tebe-bom e minte unang tinum mafak ilin umosip iyo telele-bom no kem unom amsap bii kaal o min agan abe-bom-nilita, nimi ogok uyo biniman kupkalan-temi o,” ageba o,’ age ibo no Herot iyo bogobelin o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kuta God imi weng kem baga-emin tinum iyo suun abiip miton Jerusalam kutam kal kup yem-nuubip kale, felepmuta, Jerusalam kal God imi weng kem baga-emin tinum niyo nangko-nimip kale, niyo Herot imi anang tiin moba koyo kupkaa no Jerusalam tamita, nangkolan-temip kale, kamano sino amsap so kaal sino kwek uyo tam tam Jerusalam unon-temi o,” age baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Minte Yesus iyo Jerusalam kasel imi aget fugun-bom-nala e, aget iluum tebepmuta, unang tinum iyo bogobe-nala e, “Jerusalam kasel ibaa. Ibo God imi profet ko age weng kem baga-emin tinum iyo ye-bilip kaana-bilip e minte, ibo God ilami kalaan tinum imdala talan tebesip iyo tuum tuup ye-bilip kaana-bilip no kem-nuubip kuta, kanube uun ogen umi man uu kulep ulumi bal kun tem to uksum-nuubu ulutap kale, am kwiin tagang daanan mitam iinan-nuubu boyo, niyo alugum maagup ibo imdep meng daa nalami sagaal uyo ku daam fogobe imam daalan o agan-kalin kup tebesi kuta, nimkalip boyo kanum-nuubaali binim kuba. ");
INSERT INTO tlf_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ibaa. Ipkil umik ugopnelip kale, God isiik ibo umik ugobe-nalata, waasi iyo imkala tal-nilipta, ipmi abiip so ulotu am miton so uyo kufak daabelan-temip ko. Kale niyo tuluun weng uyo bogobelan-temi kale, ibo maak so nitamin-tem bom-bilip bii, ipkil bogo-nilip, ‘Numi Kamogim keyo God kapmi win tolop diim tala kale, kabo kuguup tambal uta kup kupka-e-balapta o,’ agan-kalon-temip o,” age Yesus iyo bogola ko. ");
INSERT INTO tlf_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Kale tam God imi ifin am ko age ulotu am maak daanu e, Yesus iyo no Falosi kamogim maak imi am kal iman unan-bala e, alugum tinum kutam albip iyo, Yesus imi kuguup umaak utamum o agan-bilipta, ");
INSERT INTO tlf_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","tinum yaan so sagaal so fitobesu iyo tal Yesus imi miit tem tama ");
INSERT INTO tlf_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesus iyo atam-nala e, ulo utamsip tinum sino Falosi sino imi aget fugun-bilip uyo utam no ke-nala e, dagala ko. “Ibaa. Numi ulo uyo bogobe-nuluta, ‘Intap numin o,’ agesu a? Ulo uyo bogobe-nulu, ‘God imi ifin am daanbu uyo, ibo tinum mafak umobip iyo telela imkamin o,’ agesu bele ki, agesaalu o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","iyo weng umaak bogobelin-tem kelip ko. Kale Yesus iyo tinum mafak umosa iyo aafuu telela do-nala e, daala ilami am iina ko. ");
INSERT INTO tlf_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kale Yesus iyo kamogimal imi bogobe-nala e, “Ibaa. God imi ifin am daanbu uyo, tinum ibo kapmi man min, kao min umaak kumen ok kumun tem una umdii, kabo maak fagalin tap kapmi man min, kong min beyo dep mitam daalan-temap bele ki, dupkalan-temap o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Falosi iyo bagang-kaleta imi weng uyo yan kepmomip binim kelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kale Yesus iyo utamata e, tinum iyo afeta-bom, iman bo unan-kulum o age tal abe mitam am tele-bom-nilip e, kanu-bulupta, unang tinum iyo itamin o age-nilipta, abiin miton umi fen tal tonamip kalaa age-nala e, kota tinum kutam albip imi do weng maak bogobe-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Tinum iyo dok ita, unang kulan o age kapmi olapke-nala, ‘Talapta, iman tigi-bom unan-bom deng tebemum o,’ agela no abe tam am unap umdii, kabo tam abiin miton uyo tonamin ba ko. Kale kabo win binim kale minte, tinum win so maak tolon-tema uyo, tinum, unang kulan o agan-be beyo imi olabe-nala e, ‘Kabo tal abiin miton kagal tonal o,’ age-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","dep tal bogopke-nala e, ‘Kabaa. Daak abiin miton boyo kabo kupkaa tinum win so kemi kobe o,’ agelan-tema kota, kabo unanbu yang daang tem kugol ton-nalapta, fitom tebep-kaman-temu ko. ");
INSERT INTO tlf_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kale minte tinum iyo maak olapke-nala, ‘Talapta, iman tigi-bom unan-kulum o,’ agela unap umdii, no abe unanbu yang magaang tem kugol tonamin ko. Kanupman-temap kota, tinum olapkeba beyo tal bogopke-nala e, ‘Nugum kabaa. Tal abiin miton kagal tonal o,’ agelan-tema kota, alugum kutam albip iyo utamipta e, kabo win so kelap kalaa age-nilip e, kapmi win uyo kufukeman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ulutap kale, tinum iyo dok ita ilimi win uyo kufumip umdii, biilan-temu uyo, God iyo bogobe-nala, ‘Nimi tiin diim uyo kanupmin tinum ibo kubaganip win binim o,’ agelan-tema kale minte, tinum iyo dok ita ilimi win uyo kufumin binim kemip umdii, biilan-temu uyo, God iyo kanupmin tinum bilip imi win uyo kufu-e-bom bogobe-nala, ‘Nimi tiin diim uyo ibo kwiin kiim o,’ agelan-tema o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kale Yesus iyo kam age-nala e, fupkela tinum olapma tal tama iman unan-bilip bemi bogobe-nala e, “Kabo iman tigimap umdii, kapmi aget fugunin uyo, ‘Nugumal bilip iyo olabeli tal nimi iman uyo une-nilipta, isiik nimi iman bo yan kepnelin o,’ age-nalapta, kapmi duup-afin sino kapmi abiip kasel mufekmufek so kasel so ita olemin ba kale, kanubelap umdii, tinum kulip ita kup kapmi iman umi yan uyo kepkelan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Boyo kanumin ba kale, kabo iman tigimap umdii, kabo ki bulup man so tinum ibiit sino tinum yaan ugum sino tinum tiin mafak sino bilip ita olapmap tal iman unan-kalin o ageta kale, ");
INSERT INTO tlf_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","unelan-temip kuta, kanupmin bilip iyo kapmi iman boyo yan kepke-nimip binim kale, son-temu nala tol tinum kaansip bilip imi fen tigi molan-temip kota, God iyo kapmi kuguup tambal kafin diim komi kanumsap uyo yan kepkelata, kota deng kup tebeman-temap o,” age Yesus iyo bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kale tinum Yesus so iman unan-bilip ilimi iibak tem kulagal tinum maak iyo Yesus imi weng uyo tinangku-nala e, bogopma, “Kamogim kabaa. Biilan-temu kutop uyo tinum iyo God imi abiip no tama God imi iman tigi-bala unelan-tema uyo, tinum beyo deng kup tebeman-tema o,” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesus isiik do weng maak bogobela, “Tam tinum maak, iman tigiman o age-nala e, unang tinum kwiin tagang iyo bogobe-nala e, ‘Am kanupmin diim kota tilin o,’ agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kale agela bo nala e, utamata, kota iman unan-kalin am uyo daanu kalaa age-nalata, ilami ogok kemin tinum maak asok daala no tinum siin bogobeba iyo no bogobe-nala e, ‘Ibaa. Kota unan-kalin uyo kan kelu kale, tilin o,’ agela kuta, ");
INSERT INTO tlf_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","tinum alugum imi aget fugunin uyo, iman boyo falalum o age-nilipta, bisop baga-e-bom-nilip e, tinum maak iyo bogobela, ‘Niyo iman ilang maak mobi kale, no utam-nilita o ageta kale, niyo no tolon-temaali umaak tap kale, bogobelal o,’ agela e, ");
INSERT INTO tlf_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","tinum maak iyo bogobela, ‘Nimi ting kulupne telemin o age-nilita, kao nagaal kal maak mobi kale, no im-kugu-nilita o ageta kale, niyo no tolon-temaali umaak tap kale, bogobelal o,’ agela e, ");
INSERT INTO tlf_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","tinum maak iyo bogobela, ‘Niyo unang maak kamaa kubi kale, no tolon-temaali o,’ agela no kemip ko. ");
INSERT INTO tlf_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Kale tinum bilip iyo kam agelip kalaa age-nala e, asok ogok kemin tinum beyo tal ilami kamogim iyo tinum bilip imi weng uyo bogobela e, kamogim iyo tinum bilip imi olsak uyo kobe-nala e, ilami ogok kemin tinum beyo bogobela, ‘Kabo yuut no abiip umi ilep kiim sino minte ilep kangkang sino ku-tele tiine-bom-nalapta, bulup man sino tinum ibiit sino tinum yaan ugum sino tinum tiin mafak sino iyo afeta-bii kulep tal tolap iman koyo unan-kalin o,’ agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kale kamogim imi ogok kemin tinum beyo kanube-nalata, yuut tal ilami kamogim iyo bogobela ko. ‘Kamogim kabaa. Niyo kapmi weng uyo tinangku-nilita, kanubeli kuta, am katam uyo abiin atuk uyo bisop albu o,’ agela e, ");
INSERT INTO tlf_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","tam kamogim iyo ilami ogok kemin tinum beyo bogobela ko. ‘Unang tinum ita tebe-nilipta, nimi am katam uyo mitam tilipta, dongenuk o agan-bii kale, kabo no ilanggiip ilep ku-tele no ilanggiip maak maak kugol unang tinum iyo afetam tiinan-bii asit kup biinga kulep tal nimi am tolap iman unan-kalin o,’ age-nala e minte, ");
INSERT INTO tlf_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","fupkela unang tinum ilami am kutam albip imi bogobe-nala e, ‘Niyo mangkal ninggil ibo weng maak bogobelan o ageta kale, siin unang tinum imi bogobe-nili, “Tilipta, nimi am kagal nisino iman unan-kulum o,” ageli kupka-silip ita nimi iman koyo unelan-temaalip binim kale minte, unang tinum tal nimi am talbip ipta nimi iman uyo unelan-temip o,’ agela o,” age Yesus iyo unang tinum son-temu nala no God imi abiip iman unan-kalon-temip imi sang uta felep yak ku to do weng uyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Am maak daanu e, unang tinum kwiin tagang iyo Yesus sino ilep abe-bom-nilip e, Yesus iyo fupkela kek fen-nala e, unang tinum iyo bogopma, ");
INSERT INTO tlf_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Kabo, meng nimi ogok uyo waafulan o agelap umdii, tele aget fuguno-nalapta o ageta ko. Kale kabo nimi ilak dugamin uta kwiin kiim keluta minte, kapmi kogen kaalap imi ilak dugamin min, kalel umi ilak dugamin min, man isak atuk imi ilak dugamin min, kalapmi kaal ilak dugamin min boyo kubaganuta, nimi ilak dugamin bota kwiin kiim keluk o ageta ko. Kale kabo kulip iyo imkaa meng nimi miit tem e tolom nimi ogok uta kemap umdii, kabo nimi okumop man kelan-temap ko. ");
INSERT INTO tlf_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kale dogap kapta, nimi tinum kelan o agelap kuta, nimi kaal fuyap at diim kal kulan-temi ulutap ke, ‘Ku-nimi bole, ku-nimi o,’ agelin-tem ke-bom-nalap e minte, nimi daang begepne nimi bogo-nili, ‘Bota kanumal o,’ agan-bii uyo waafulin-tem ke-bom no kemap umdii, kabo dogobeta nimi tinum kelan-temaalap binim ko. (Kuta minte kabo boyo alugum kanumap umdii, bota kabo nimi tinum kelan-temap ko.) ");
INSERT INTO tlf_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Kabo, nimi ogok uyo waafulan o agelap umdii, kamaki uyo bong fagamin kwek umi aget uyo tele fuguno-nalapta, meng nimi ogok uyo waafuu o ageta kale, do weng bogolan-temi koyo tebe ipmi aget fugunin uyo bam daa imolan-temu kale, ibo tele tolong do-silipta. Tinum ibo dok ita maak, am kwiin kiim maak de kolan o agela umdii, kamaki uyo ton-bom tuumon uyo tiki utamata e, am bomi kun uyo tii kalaa minte, tii ba kalaa agelan-tema kale minte, ");
INSERT INTO tlf_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","boyo kanupmin-tem kela umdii, am kun uta kup moli tuumon uyo binimanu kalaa age kupkalan-tema uyo, alugum unang tinum iyo utam-nilip e, aban dii-e-bom titul weng baga-e-bom no ke-bom-nilip e, ");
INSERT INTO tlf_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Tinum beyo atamin. Beyo, am kwiin kiim uyo dinan-kalon-temi o age dinan-nak-be kuta, tuumon uyo binimanebebu kale, am uyo de ko binimanu kupkalan-temaala o,’ agan-kalon-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ulutap kale, kamogim iyo maak tolong dolata e, tinum iyo bogo-nilip, ‘Waasi ilimi kamok so minte ilami tinum ilimi kup twenti tausen (20,000) isino iyo tal, numi kamogim so dinan-kulum o age talan-bilip o,’ agelip kalaa agela umdii, yagal ilami aget fugunin uyo tambaliim telela kolin-tem ke-nala e, tinum ilimi kup ten tausen (10,000) ita kup dulep no tama isino dinan-kalon-temip bele ki? Umbae. Kamaki uyo yagal ton-bom aget fugun-bomta e, ilami tinum iso minte yagal no iyo tii waasi imi kamogim isino imi dinan-kalin tinum sino dinan-kalon-temup uyo, nuta nuta kelan-temup kalaa age-nalata, telela kolan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Minte iyo utamata, nuyo tii ba kalaa agelan-tema uyo, utamata e, waasi iyo simanim kugol talan-bilip kalaa agon-tema uyo, ilami kalaan weng kwep unemin tinum ita imdala no waasi imi kamok iyo bogobe-nilip e, ‘Kabaa. Numi kamogim iyo imdala tal bogopke-nulup, “Dinan-kalon-temaalup kale, weng uta kup telela-nulupta, kupkalum o,” agelata, tulup o,’ agelan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Ulutap kale, kabo, meng nimi ogok waafulan o agelap uyo, kamaki uyo tele aget fuguno-nalapta. Kapmi mufekmufek so kapkumal sino iyo alugum imkaa meng-nalap nimi miit tem e tilin-tem kelap umdii, kabo nimi okumop man kelan-temaalap o,” age bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yesus iyo do weng maak bogo-nala e, tam bogola, “Yol boyo mufekmufek tambal abalim tebesu kuta, kanube yol uyo abaal tebelin binim kelu umdii, dogobeta telela kolupta, yol bomi abaal uyo tabon-temu a? Boyo atin binim ko. ");
INSERT INTO tlf_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kale yol abaal binim kesu boyo kwaalip daak kafin tambal diim abelan-temu uyo, yol boyo tebe kafin tambal uyo kufak daalu ason san uyo tebelan-temaalu kale, kwaalip yang iinon-temu o,” age-nala e minte, bogola, “Ipkil tolong sino kale, nimi weng ko bagan-bii koyo tele tolong dolin o,” age baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kale tinum takis mani kwaamin so e minte tinum kuguup mafak waafulip kalaa age ipkumal tebe itafinonosip so iyo tal Yesus imi weng uyo tinangkamip ko. ");
INSERT INTO tlf_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Kale Falosi so e minte ulo utamsip tinum so iyo tebe Yesus iyo titul weng baga-e-bom-nilip e, “Tinum beyo tinum kuguup mafak waafusip bilip imi duup ke-bom-nalata, isino iman unan-nuuba o,” agan-bilip kalaa age-nalata, ");
INSERT INTO tlf_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","do weng maak bogobe-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Kanube ilipmi tinum iyo maak sipsip ilimi kup wan handret (100) kalip ita tiin mola bomip nala minte, tam maagup umaak maagalo kelu umdii, sipsip kayaak iyo nainti nain (99) kalip iyo tiginal kugol bisat imka-nala e, no ipkum maagalo kebu uyo fen-biita utaman-tema ko. ");
INSERT INTO tlf_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","“Kale utam-nala e, kwep tam ilami nagaal kun diim kal kwiinga-nala e, deng taban tala ko. ");
INSERT INTO tlf_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kale daage tal ilami am tal-nala e, ilami duup-afin iyo olabela tal katam katam kelip e bole, bogobe-nala e, ‘Nimi sipsip maak maagalo keluta, fen-biita utami kale, ipso niso deng tebemum o,’ agan-kalon-tema ko. ");
INSERT INTO tlf_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ulutap kale, niyo ibo bogobelan o ageta kale, kanube fengmin tinum iyo maak imi fengmin uyo kupka-nala aget fupkela ko God imi ilak dola umdii, abiil tigiin kasel ensel iyo atin bemi deng afaligen uyo tebeman-temip ko. Ale minte tinum ilimi kup nainti nain (99) kalip iyo bogo-nilip e, ‘Nuyo fengmin binim tambaliim kup albup koyo, dogonubeta aget fupkela kolum o?’ agelip umdii, ensel iyo kulip imi deng uyo tebeman-temaalip o,” agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Kale Yesus iyo asok do weng maak bogo-nala e, “Kale tam unang maak tuumon nagaal kal keta aafulu boma kale, kanube maagup iyo maak maagalo kebela umdii, yogon uyo ela kufo-nuluta, abiin ifip uyo talan-biita asok ataman-temu ko. ");
INSERT INTO tlf_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kale atam-nulu e, duup-afin iyo olabelu tal katam katam kelip e bole, bogobe-nulu e, ‘Nimi tuumon maak maagalo kelata, fen-biita atami kale, ipso niso deng tebemum o,’ agan-kulu ko. ");
INSERT INTO tlf_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kale niyo ibo bogobelan o ageta kale, mungkup kanube fengmin tinum iyo maak imi fengmin uyo kupka-nala aget fupkela ko God imi ilak dola umdii, God imi ensel iyo atin bemi deng afaligen uyo tebeman-temip o,” agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kale Yesus iyo asok do weng maak bogo-nala e, “Tinum maak bii-se kale, bemi man iyo tinum alop kale, ");
INSERT INTO tlf_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","niing ita aalap iyo bogobe-nala e, ‘Aatum kabaa. Biilu kaanap kapmi mufekmufek dalaman-temip umi milii nimi kopnelan-temip uyo kamaa kagal kopne o,’ agela e bole, tam ilami mufekmufek uyo alugum alop imi togobela ko. ");
INSERT INTO tlf_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kale bole tam niing iyo bii ilugo-nama binim ke tam ilami mufekmufek uyo afeta-bii kulep-nala e, daage abiip simanim maak una kale, no abiip kugol bom kuguup mafak mafak uta waafu-bom-nala e, imi mufekmufek uyo alugum maagalo segela kulula unu tulu kelu ko. ");
INSERT INTO tlf_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kale bole imi mufekmufek uyo alugum segela kulula unu tulu ke binimanu e bole, kafin boyo iman tebok afek maak kulep mitam daalu e bole, mufekmufek uyo dilino-nala e, umtal daala ko. ");
INSERT INTO tlf_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kale kota utamata, kanubelu kalaa age-nala e, daage no tama e, abiip bomi tinum maak isino alop bom-nilip e bole, tinum beyo tebe-nala e, daala no imi bagan kal kong iman ife-emin ogok uta waafula ko. ");
INSERT INTO tlf_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kale minte tinum iyo dok ita iman uyo kopmoma binim kale bole, kong iyo at maak umi dum uta unan-bilip e, yagal mungkup, bota maak unelan o agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Kale imi aget fugunin uyo bam daabelu bogo-nala e, ‘Alugum nimi aatum imi ogok ke-emin tinum iyo iman kwiin tagang uyo unan-bii tukup tukup kem-nuubip kuta, niyo kagal albi koyo ki, iman tep ko ageta ogen abin so uyo umtal daa kaanan o angbi kale, ");
INSERT INTO tlf_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","kupkaa nalami aatum finang no bogobe-nili e, “Aatum kabaa. Niyo Abiil Tigiin Kayaak imi tiin diim uyo feng-bom-nili e minte, kapmi tiin diim uyo feng-bom no ke-bii tili kale, ");
INSERT INTO tlf_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","koyo maak so bogo-nalap, ‘Nalami man o,’ agon-temap uyo felepnelan-temaalu kale, nimkalapta, kapmi ogok kekemin tinum kelan o,” agon-temi o,’ agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kale kota ilami aalap imi aget uyo fuguno-nala e, ‘Nalami aatum siinon o,’ age-nala e, daagina ko. “Kale simanim kugol aalap finang tal-balata, aalap iyo atam-nala e, aalap imi aget tem uyo fomtuup du-filin daa yuut no duptal migi fiil buuba do kema e minte, ");
INSERT INTO tlf_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","man iyo bogobe-nala e, ‘Aatum kabaa. Niyo Abiil Tigiin Kayaak imi tiin diim so kapmi tiin diim so uyo fenga-bii tili kale, koyo maak so bogo-nalap, “Nalami man o,” nagon-temap uyo felepnelan-temaalu o,’ agan-kala e, ");
INSERT INTO tlf_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","aalap iyo ilami ogok ke-emin tinum imi bogobe-nala e, ‘Yuut no-nilip fen ilim tambal umaak kwep tal migibe-nilip e, ring umaak kwep tal sagaal duung tem uyo ilipmip te top unu e minte, yaan ilom umaak kulep tal tiibe no ke-nilip e minte, ");
INSERT INTO tlf_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","no-nilip kao man tambal dam so uta ungkwaa kwep tilipta, un-bom-nulupta, deng tebe-bom no kemum o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kale bomi magam uyo dok uta ba kale, nimi man keyo maagalo kesa aa-e min, kaansa aa-e ulutap kesa kuta, kamano kota asok tigi mo talata, atamup atamta, deng tebemum o,’ agela e bole, deng tebemip ko. ");
INSERT INTO tlf_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Kuta fik iyo iman ilang digin unan-bii-nala e, daage tal am mep so tolomta, ot weng so atol weng so uta tinangku-nala e bole, ");
INSERT INTO tlf_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ogok kemin tinum maak olabe-nala e, bogola, ‘Bilip iyo intaben deng taban-bilip o?’ agela e minte, ");
INSERT INTO tlf_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","isiik bogobe-nala e, ‘Kapmi niing iyo tambaliim kup tal tama aalap iyo asok dula kalaa age-nilipta, kao man tambal dam so uta ungkwaa kwe fuu unan-bom-nilipta, kanu-bilip o,’ agela e, ");
INSERT INTO tlf_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","fik iyo olsak kup tebepmu e, ‘Tam am iinomi ba o,’ agela e, aalap iyo mitam abiip mitam-nala e, man iyo weng fiitama e, ");
INSERT INTO tlf_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","man isiik aalap imi bogobe-nala e, ‘Aatum kabaa. Atol kwiin tagang dakan kem tebesi komi kapmi ogok waafupkesi uyo, kapmi weng umaak kwaasulepkesaali kuta, kabo meme man tambal umaak ungkwapnelapta, nimi duup isino deng umaak tebesaalup kuta, ");
INSERT INTO tlf_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","kapmi man beyo kapmi mufekmufek uyo kulep no sa daga-bom alugum segela kulula unu tulu kepke talata, bota kabo kao man tambal dam so uyo ungkwabelap aga o?’ agan-kala e minte, ");
INSERT INTO tlf_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","aalap isiik bogobe-nala e, ‘Man kabaa. Suun kup ulim maagup nuubup kale, nimi mufekmufek boyo alugum kalapmi ko. ");
INSERT INTO tlf_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kale minte niing beyo maagalo kesa aa-e min, kaansa aa-e ulutap kesa kuta, kamano kota asok tigi mo talata, atamup kale, atin felepmu deng kup tebemum o,’ agansa o,” age-nalata, Yesus ita kam agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesus iyo do weng migik maak ilami okumop man imi bogobe-nala e, “Mufekmufek soyaap tebe, ogok kemin tinum maak ulaa dulita, mufekmufek so minte ogok kemin tinum sino imi tiin molak o age ulaa dula ko. Kuta tinum migik iyo tal mufekmufek soyaap bogopmip, ‘Kapmi mufekmufek tiin molin tinum iyo kapmi mufekmufek uyo tambaliim kup tiin mobaala kale, ilami duup-afin tele-bilip misiim kulu kupka-e-be o,’ age bogopmip e, ");
INSERT INTO tlf_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","kota ilami mufekmufek tiin molin tinum iyo olapma tala e, bogopma, ‘Kuguup mafak maak ke-balap unang tinum en-bilip tolong doli koyo intap nu-balapta a? Kanu-balap kalaa age-nilita, kamano koyo kabo kamkan keli kale, nimi mufekmufek uyo maak so tiin molan-temaalap ko. Kale daaginin-tem som-nalapta, kamaa kagal suuk kon umaak ku nimi mufekmufek umi win uyo dola-bii ko-nalap kupne talapta, nagal tikilita, dogonupmin kota tambaliim albu kalaa minte, dogonupmin kota duumatanbu kalaa agelan o,’ agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Kota mufekmufek tiin molin tinum iyo aget fuguna, ‘Nimi kamogim iyo nimkan kelan o agela bota, imi mufekmufek uyo maak so tiin mopman-temaali kale, bota dogobelan-temi a? Niyo kun so ke-nilita, kafin fagamin umi ogok umaak kelan-temaali e minte, niyo fitom kale, nugumal imi iman sang uyo nenan-temaali binim ko. ");
INSERT INTO tlf_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aa. Kota niyo aget fugunin tambal maak utami ko. Niyo nugumal iyo yuum kobeli suukta, nimi ogok uyo binimanu kupkaa bisop nan-temi uyo, nugumal isiik deng tebe-bom-nilipta, nimtamo no imi am uyo daa-nilipta, tiin molan-temip o,’ agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Kale kamogim imi mufekmufek tiin mobelin tinum beyo alugum tinum tebe kamogim imi yuum kubip iyo olabe-nala e, ‘Ibo kamogim imi yuum kebebip uyo maagup isiik tal mo una una kemin o,’ agela e, bon tem tinum isiik tal tama e, bogopma, ‘Kabo intap kal kota kamogim imi yuum kubebap o?’ agela e, ");
INSERT INTO tlf_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","isiik yan kebe bogopma, ‘Niyo oliv at dum ok tet ulumi kup wan handret (100) bota yan kepman-temi o,’ agela e, mufekmufek tiin molin tinum iyo bogopma, ‘Yuum alugum uyo yan kemin ba kale, yuut ton-bom kalapmi suuk kon kamogim kopke-se uta ku bomi dolmin uyo fupkela ko-nalap tet ulumi kup 50 umi sang uta kup dola ko-nalap kalapmi win uyo dola ko no ke-nalapta, tet ulumi kup 50 uta kup molal o,’ age bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Yuum uyo atuk kup mo daagina e, tinum iip isiik tal tama e, tiin molin tinum iyo bogopma, ‘Minte kapde a? Kabo intap kal kota kamogim iyo yuum kubebap o?’ agela e, bogopma, ‘Niyo rais ko age wiit bek ulumi kup wan handret (100) bota yan kepman-temi o,’ agela e, mufekmufek tiin molin tinum iyo bogopma, ‘Yuum uyo alugum yan kemin ba kale, yuut ton-bom kalapmi suuk kon kamogim kopke-se uta ku bomi dolmin uyo fupkela ko-nalap bek ulumi kup 80 uta kup dola ko-nalap kalapmi win uyo dola ko no ke-nalapta, bek ulumi kup 80 uta kup molal o,’ agela e, yuum uyo atuk uta kup mola ko. ");
INSERT INTO tlf_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Mufekmufek tiin molin tinum mafak iyo ilami kamogim imi mufekmufek uyo tukubebela kuta, aaltam uyo ilami kamogim iyo utamata, mufekmufek tiin molin tinum iyo ilami tonamin umi aget uta kup fugun-bom kanupmin kuguup boyo kanubeba kalaa age-nala e, ilami mufekmufek tiin molin tinum mafak imi tok uyo bagama ko. Kale kamogim imi tinum mafak bemi tok bagamin uyo dok uta ba kale, kafin diim komi unang tinum imi ogok kemin uyo aget fugunin tambal uta ku-nilipta, dital fagaa ogok ke-bom-nilip unang tinum God imi ilagenin diim albip iyo kubaganip imkasip ko. ");
INSERT INTO tlf_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Weng maak bogobelan-temi kale, tinangku-silipta. Ibo kafin diim komi nip uyo, mufekmufek min, tuumon kwaamip uyo, kulu unang tinum iyo tambaliim kup dong daga-e-bom-nilip e minte, olapmip tal ipmi am e tilip tiin mo yakyak ke-bilipta, bilip iyo ilipmi duubal aligaap kelin o ageta ko. Kale biilu ibo kaan kafin diim komi mufekmufek min, tuumon uyo kupkaa God imi suun abiip unon-temip kota, God yagal bogobe-nala, ‘Ibo nimi duubal aligaap o,’ agelan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kale kamogim iyo imi ogok uyo kwaala yak imi ogok kemin tinum imi sagaal diim abelu beyo tambaliim kup ogok kema umdii, ilami kamogim iyo utamata, tambaliim kup kanu-be kalaa age deng tebeman-tema uta, ogok afegen uta kup kopma ogok keman-tema ko. Kale minte ilami kamok iyo, ogok katip dopmi mafak kanu-be kalaa agon-tema uyo, ogok afaligen uyo kopmi e, kanuman-tema kalaa agelan-tema kale, kopma ogok keman-temaala ko. ");
INSERT INTO tlf_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ulutap kale, ipmi mufekmufek kafin diim komi albu uyo kulu-nilip tambaliim kup tiin molin-tem kelip umdii, God imi ogok afaligen uyo kwaala yak ipmi sagaal diim abelan-temu aga? Umbae. ");
INSERT INTO tlf_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ibo tinum migik imi mufekmufek uyo tele tiin molan-temaalip uyo, God imi mufekmufek uyo kwaala yak ilipmi sagaal diim abelu ilipmi kelan-temu aga? Umbae. ");
INSERT INTO tlf_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Tinum dok ita, kamogimal alop iyo maak, maak imi ogok uyo waafube som, maak imi ogok uyo waafube no kemin tinum kelan o agela umdii, beyo bagang-kale-nalata, kamogimal alop kano bilip imi ogok uyo kelan-temaala ko. Kale tinum beyo tebe, God imi ogok keman o age-nala e minte, ogok ke-bom mani kwaaman o age no kema umdii, God iyo umik ugobe-nala e, mani kwaamin umi aget uta fomtuup kupka-eman-tema ko. Kale minte tinum dok ita God imi aget kup kobe-nala e, God imi ogok uyo fomtuup waafula umdii, mani kwaamin umi aget umaak fugunolan-temaala ko. Kale mungkup ibo bagang-kale God sino mani kwaamin so alop kano bomi aget uta ugaa kwaagaman-temaalip o,” age baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Kale Falosi iyo mani umi aget uta kup ugaa kwaasip kale, Yesus imi kanupmin weng bagan-be uyo tolong do-nilip e, titul weng baga-e-bilip e, ");
INSERT INTO tlf_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesus iyo bogopma, “Ibo unang tinum imi tiin diim uyo kuguup tambal uta kup ki waafu-bom-bilipta, unang tinum iyo ipmi tok uyo baga-em-nuubip kuta, God yagal utamata, ipmi aget tem bubul tem uyo tambal kalaa, mafak kalaa agan-nuuba ko. Kale unang tinum iyo ipmi kanupmin kuguup bomi tok uyo bagan-nuubip kuta, God imi tiin diim uyo ipmi kuguup ko kanum-nuubip boyo kuguup mafak waafusip kuba. ");
INSERT INTO tlf_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Sugamiyok uyo Moses iyo God imi ulo kwep daasa uyo dola kola e minte, God imi profet ko age weng kem baga-emin tinum igil God imi weng dola ko no kelip e, God iyo unang tinum imi bogobe-nala e, ‘Nimi weng boyo alugum fomtuup kubaget daa-nilip waafulin o,’ agela igil waafu-bom-nilip e, man iyo ilop daaga-bilip tam tam tebesuta, ok sam uga-emin tinum Jon Baptis iyo ti-se ko. Kuta kamano kota Jon so nimi okumop man isino minte nagal no ninggil nuyo unang tinum iyo baga-e-bom-nulup e, ‘Ibo ipmi aget uyo fupkela kolipta, God yagal ipmi ilim uyo bo-nalata, imdep meng ilami daam tem daalak o,’ age ninggil nuyo baga-e-bulupta, unang tinum kwiin tagang iyo fomtuup, meng God imi daam tem e tulum o age-nilipta, ilek ilek mitam talan-bilip ko. ");
INSERT INTO tlf_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kale God tebe unang tinum imi ilim bobelan-tema am uyo, daanan o angbu kuta, God imi ulo boyo binimanin-tem albu kale, afungen tem tolon-temu uyo, kafin so abiil so uyo binimanan-temu kuta, fen God imi ulo bota binimanan-temaalu binim kale, alugum suun nan-temu o,” age baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Asok Yesus iyo bogopma, “Kanube tinum iyo maak ilami kalel uyo kupka-nala unang migik uta kula umdii, God imi tiin diim uyo bemi kanubela boyo sa daga-bom-nalata, fen ilami kalel yom uyo kupkeng daga-bom kufak dagan-be kalaa agelan-tema ko. Ulutap kale, kanube tinum iyo maak ipkum imi kalel fot tebe kupka-se uyo kula umdii, God imi tiin diim uyo bemi kanubela boyo sa daga-bom-nalata, fen unang bomi kamaki imak iyo dupkeng daga-bom dufak dagan-be kalaa agelan-tema o,” age Yesus iyo kam agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesus iyo do weng maak bogo-nala e, “Siin uyo tinum mufekmufek soyaap maak iyo tambaliim kup ton-bom-nala e minte, ogok kemin binim ke-bom-nala e, suun kup ilim tambal migik migik uta kup migi-bom-nala e, iman tambal uta kup unan-kalin kup ke-bom no kem-nuuba ko. ");
INSERT INTO tlf_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Kale minte tinum bulup man maak imi win uyo Lasarus kale, beyo mafak ilin daam kale, ipkumal iyo duptamo tal mufekmufek soyaap imi amitem daalip daak abe agaal unba tap ke-bii, yakyak ke-bom-nala e, suun kup iyo fen-bomta e, mufekmufek soyaap tinum imi iman unan-bom atuk kutula kululip unan-bo uyo albu kalaa agan-bom-nalata, iman tep boma ko. Kale mungkup imi kaal diim uyo abang kiil uta kup bugusu kale, kayaam tagang iyo tal fong kulu imi kaal diim abang uyo fomtuup ata-e-bomip ko. ");
INSERT INTO tlf_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Kale bulup man beyo kaana e, ensel iyo tal bulup man imi sinik iyo duptamo no abiil tigiin daalip Abraham isino nip ko. Kale minte mufekmufek soyaap tinum yagal kaana dubalip e, ");
INSERT INTO tlf_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","iyo no at kenamin abiip kugol bom-nalata, kaal fuyap afaligen uyo utama-bom-nalata, katam fenata e, Abraham iyo simanim kal alba kalaa age-nala e, Lasarus iyo Abraham isino alba kalaa age no kela ko. ");
INSERT INTO tlf_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kale tinum siin mufekmufek soyaap ke-bom bii-se iyo olala ko. ‘Nimi afalik Abraham kabaa. Niyo at dong tem diin-bom-nili nimi kaal fuyap afaligen tebepnebu kale, ni-filin daa-nalap Lasarus beyo daalap malaak-nala ok katip ilu kwep tal nimi fong ken taban-bo koyo deelepnela disanuk o,’ agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Kale Abraham iyo bogobe-nala e, ‘Nimi man kabaa. Kabo aget fugunolal. Siin kapmi tiin kafan bom-nalap uyo, mufekmufek tambal kup kuga-balap e minte, Lasarus ita mufekmufek mafak uta kup kuga-bala no kem-nuubip kale, kota Lasarus iyo abiip tambal kagal ton-bom deng taban-be kale minte, kapta kaal fuyap afalik waafubap kuba. ");
INSERT INTO tlf_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kale kuguup migik maak uyo kulbu botam. God iyo tebe ok ilep kwiin kiim maak uyo bigi kosa kale, ipkil yak milii kugol nip e minte, nugol mek milii kagal nup no kelin kale, tinum mek milii kaa albip kalip iyo, yak milii unum o agelan-temip kuta, dogonubeta bagang-kale yak milii unomip binim kale, mungkup tinum yak milii ko albip kulip igil mungkup, mek milii tulum o agelan-temip kuta, dogonubeta bagang-kale mek milii tolomip binim no o,’ agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Kanubeta, tinum siin mufekmufek soyaap ke-bom bii-se iyo bogola, ‘Nimi afalik kabaa. Kanube niyo weng maak dagalan o ageta kale, nimi nagalal ogal kalip iyo nimi aatum imi am kal albip kale, igil mungkup tal kaal fuyap kiim utamamin abiip koyo tolon-temip kale, dagalita, Lasarus beyo daalap no-nalata, bogobe-nala kano, “Ipmi tiing imi kuguup mafak mafak kem-nuuba kulutap uyo kemin ba o,” agelak o,’ agela e, ");
INSERT INTO tlf_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham iyo bogola, ‘Moses sino minte God imi profet ko age weng kem baga-emin tinum sino iyo weng kem bagamin boyo God imi suuk kon tem dola kosip kale, kapmi nagalal iyo tii tinangku-nimip o,’ agela e, ");
INSERT INTO tlf_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","tinum siin mufekmufek soyaap ke-bom bii-se iyo bogola, ‘Umbae. Afalik Abraham kabo tinangku-salapta. Nimi nagalal bilip iyo God imi suuk kon tem weng uyo tinangku-nimip binim kuta, tinum kaansa ita begel ilet tem ilo tigi mo no God imi suuk kon tem weng bogopman-tema uta, bilip iyo aget fupkela ko kuguup mafak uyo kupkalan-temip o,’ agela e minte, ");
INSERT INTO tlf_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham isiik bogopma, ‘Kanube kapmi nagalal iyo Moses sino God imi weng kem baga-emin tinum sino imi weng uyo tinangkamin binim kem tebesip umdii, tinum kaansa iyo maak begel ilet tem ilota tigi mo no bogobelan-tema uyo, kanupmin tinum bemi weng uyo tinangkulan-temaalip binim o,’ agela o,” age Yesus iyo do weng uyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesus iyo ilami okumop man imi bogobe-nala e, “Kuguup mafak uyo suun kup fen mitam tebe unang tinum imi aget fugunin uyo kufak daapmuta, iyo yang kube fengam-nuubip kuta, tinum dogap ita kuguup mafak kanu-bom-nala ipkumal imi kafalebela min, uget togo bogobela igil mungkup yang kuguup mafak uyo kanumip umdii, God yagal tebe tinum beyo yege-bom bemi ipkumal biinga kulep yang iinemin boyo fomtuup yan ke-eman-tema kale, ibo boyo tele utama-bom-nilipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kale kek kek iyo utamipta, tinum beyo, ise kanubelan o angba kalaa agelan-temip uyo, kanube bilip iyo tebe tuum afalik umaak ku sok de ko-nilip kwep yak tinum bemi fuk kun diim kwegal de kobe daalip daak yol ok kumun tem iina umdii, tinum beyo kaal fuyap uyo katip so ku-nalata, kaanan-tema kale minte, kanube kek kek iyo tinum beyo kanubelin-tem ke dupkalip tebe unang tinum God imi ilak dugamin katip katip ke-bilip iyo ifak daala kupkaa yang kuguup mafak uyo kemip umdii, God isiik tebe atin ki bemi ifak daala bomi yan uyo kobelata, tinum beyo kaal fuyap kwiin kiim uyo kugan kwep taban-bon-tema ko. ");
INSERT INTO tlf_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kale boyo ilipmi kuguup uyo tele utama-bom-nilipta a. “Kapmi kapkum iyo kapmi mufekmufek uyo fenga kopkela uyo, kabo bogobe-nalap, ‘Maak so kanumin ba o,’ agelap kota, imi aget uyo fupkela kola umdii, kabo bemi fenga kopkeba boyo kupkabelal o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kale kanube am maagup daanbu kwegal, kapmi mufekmufek uyo fenga kopke yakyak ke-bom-nala asok suun tal bogopke-nala, ‘Nimi kuguup ko kanuke-bii boyo mafak kalaa ageli kale, kupkali o,’ age yakyak kema umdii, kapkal imi kuguup mafak kanuke-be boyo kupkabe yakyak kemin o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yesus imi kalaan tinum iyo Yesus iyo bogobe-nilip e, “Kamogim kabaa. Kabo dong dogopmapta, numi God imi ilak dugamin uyo senganepmuk o,” age bogopmip e, ");
INSERT INTO tlf_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Kamogim iyo bogobe-nala, “Kanube ipmi God imi ilak dugamin uyo mastat umi san ilatap katipnok kuta, God imi dagalip umdii, yagal dong dogopmata, ipkil tii kuguup afaligen kanuman-temip kale, ibo, God iyo aafen kalaa age-nilip imi ilak uyo fomtuup dolip umdii, ibo at umaak bogobe-nilip, ‘At kubo timtim kuso foga kuptamo daak yol ok kumun tem kal molal o,’ agelan-temip uyo, God iyo ipmi weng uta kup tinangku-nala e, at uyo bogobela timtim kuso foga kwep daak yol ok kumun tem kal molan-temu o,” age Yesus iyo do weng baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesus iyo bogobe-nala e, “Taabalasep imi ogok kemin tinum iyo no ilanggiip umi ogok bong fagan-bii tala min, kong uyo tiin mo-bom-bala bii, kwiinu tala uyo, taabalasep iyo bogobe-nalata, ‘Yuut no kapmi iman usiik fuu une-nalapta o,’ agon-tema a? ");
INSERT INTO tlf_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Umbae. Bo bogolan-temaala kale, iyo bogopma, ‘Kamaki uyo nimi iman usiik telela ko ifelap unelita, aaltam kota no-nalapta, kapmi iman uyo telela ko unelal o,’ agon-tema ko. ");
INSERT INTO tlf_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kale ogok kemin tinum beyo ilami tiin molin tinum imi weng uyo tinangku imi ogok uta kup ke-e-bii tala kuta, boyo bemi tiin molin iyo, ‘Suguul o,’ age atin kuguup tambal uyo kobelan-temaala kale, ilami ogok ke-be umi tisol uta kup kobelan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ulutap kale, ibo God imi ogok kemin tinum kale, God yagal bogobe-nala, ‘Ibo kanupmin ogok kopmi bota kup kanumin o,’ agela kanu-bilip bii, binimanu umdii, ilipmi win uyo kufu-bom bogo-nilip, ‘Numi ogok tambaliim kup kanum-nuubup boyo tele utamin o,’ agan-kalin ba kale, bogo-nilip, ‘Nuyo fen tinum kale, numi suun ogok kemin uta kup kanum-nuubup o,’ agan-kalin o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesus sino imi okumop man sino ninggil iyo, Jerusalam kutam iinum o age-nilip e, no ilep maak no-nilip e, Provins Samaria uyo ugaa kwep keng daa som, minte Provins Galili uyo kwep keng daa no ke-nilip e, iibak ku-tele ");
INSERT INTO tlf_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ninggil iyo daage no abiip katip maak kutam iinip e, tam tinum nagaal kal kaal mafak kesip maak iyo tal, Yesus imi atamum o age tal-nilip e, kaal mafak kesip ilimi kuguup uta ku-nilip e, simanim kweng kal mo-som-nilip e, ");
INSERT INTO tlf_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ola-nilip e, “Kamogim Yesus kabaa. Nuyo i-filin daa-nalap numi kaal mafak koyo dong dogobelal o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesus iyo imi kaal mafak uyo utam-nala e, bogobela, “Ibo no-nilip pris ko age tinum amem imi diim kal ipmi kaal uyo kafalebelipta, iyo utam-nilipta, (bogobe, ‘Ipmi kaal uyo tambalanu o,’ agelipta bole, unang tinum iyo tinangku-nilip e, deng tebemin) o,” agela ko. Kale tinum bilip iyo Yesus imi weng uta kup tolong do-nilip e, daage ilep kugol abe-bilipta, kota imi kaal uyo tambalanebelu ko. ");
INSERT INTO tlf_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tam tinum maak beyo ipkumal imi iibak tem kulagal unan-be kale, utamata e, nimi kaal uyo tambalanepnelu kalaa age-nala e, asok fupkela talan-bom-nala e, fomtuup God imi win uyo kufu-e-bom ");
INSERT INTO tlf_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","daak Yesus imi tibit diim kugol katuun duung fegela-nala e, Yesus iyo, “Misam o,” agela ko. Kale tinum beyo Samaria tinum ko age Juda kasel imi waasi ko. ");
INSERT INTO tlf_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kale Yesus iyo imi okumop man iso alugum bogobela, “Tinum maagup keta tala kuta, niyo tinum nagaal kal kulip ita telela imoli kale minte, tinum tugal kulip ile a? ");
INSERT INTO tlf_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tinum tugal kulip iyo intaben o ageta talta God imi win uyo kufu-emin binim kelipta minte, Juda kasel nulumi waasi maagup keta kup talta God imi win uyo kufu-e-bom, ‘Misam o,’ agela o?” age-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Samaria kayaak bemi bogobela ko. “Kabo nimi weng uta tinangku utamapta e, boyo fen kanupman-tema kalaa agelap kalaa age-nilita bole, bota kapmi aget tem kwek uso telela kopkeli kale, fen mitam abe tambaliim kup no bom-balapta o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Falosi iip maak maak iyo tal Yesus imi daga-nilip e, “Dok kota God imi tinum ulaa dula kamok kesa iyo daala tal-nalata, Rom kasel tebe numi tiin mosip boyo talaa imdala mitam tamupta, yagal tebe tiin molan-tema o?” agelip e, isiik bogobela, “God imi tinum ulaa dula kamok kesa imi tal tiin molan-tema boyo kem tiin fala utamamin umi mufekmufek ba e minte, ");
INSERT INTO tlf_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","beyo tal abiip maagup kutam kal bom-nalata, ibo tiin molan-temaala no kale, bemi tiin molan-tema boyo ugulumi migik ko. Ibaa. Beyo tal-nalata, ilipmi aget tem kwegal bom-nalata, ibo tiin molan-tema o,” age-nala e, Falosi iyo bogobe-nala e minte, ");
INSERT INTO tlf_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","tam fupkela ilami okumop man iyo bogobela, “Son-temu uyo, tonamin mafak maak mitam tolon-temu kale, ibo fomtuup utamipta e, dok kota Mo Tibil imi Man niyo asok tolon-tema kalaa agelum o agon-temip kuta, ibo maagalo bisop fenan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Kale unang tinum iip maak maak iyo bogo-nilip e, ‘Yak tinum alba beta God imi daala ti-se tinum o,’ agelip e minte, unang tinum iip maak maak ita bogo-nilip e, ‘Umbae. Bega ba kale, keta God imi daala ti-se tinum iyo kalba kuba,’ agelip no ke-bom bisop weng bagaman-temip kale, ibo weng boyo tolong do-nilip, no itamum o agan-kalin ba ko. ");
INSERT INTO tlf_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Mo Tibil imi Man nimi asok tolon-temi uyo, kanube tolon-temaali kale, bamalaang famalaak mo alugum kafin so abiil so ilagenbu ulutap ke-nilita, kem diim tolon-temi kale, alugum unang tinum iyo tele nitaman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kuta no abiil tigiin o tilin-tem bom-silita, kamano unang tinum kaa albip kalip iyo umik ugopne kuguup mafak uyo kupkane-bilipta, kaal fuyap afalik uyo kugan-siit-nilita unon-temi ko. ");
INSERT INTO tlf_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Mo Tibil imi Man nimi unon-temi uyo, asok tilin-tem kugol bom-silita, unang tinum iyo sugamiyok Noa imi sip ko age bot afalik dinan-bala unang tinum imi kuguup kanumsip ulutap ke-nilipta, kanuman-temip kale, ");
INSERT INTO tlf_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noa imi sip dinan-bala uyo, unang tinum iyo alugum (God imi ilak uyo fom duga-bom-nilipta ba kale, kafin diim komi mufekmufek umi ilak uta fom dugan unsip kale, intaben o agomip binim ke-bom-nilipta,) bisop iman unan-bom-nilip e, ok unan-bom no ke-bom-nilip e, tinum iyo unang dula-bilip e, unang iyo tinum dulan-bom no ke-bilipta bii, sip uyo binimanuta, Noa ulimal iyo tam sip tem unip e, maak fagalin tap ok uyo fagan tal abuta, unang tinum iyo imdaak tama mimilepmuta, alugum kaansip kale, ulutap nagal mungkup maagalo bimiliip tem maak fagalin tap tolon-temi ko. ");
INSERT INTO tlf_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Ulutap kale, nimi unon-temi uyo, asok tilin-tem kugol bom-silita, unang tinum iyo sugamiyok Abraham imi niing man Lot imi bom-bala unang tinum imi kuguup kanumsip ulutap ke-nilipta, kanuman-temip kale, Lot imi bom-bala uyo, abiip Sodom kasel unang tinum iyo alugum God imi ilak uyo fom duga-bom-nilipta ba kale, kafin diim komi mufekmufek umi ilak uta fom dugan unsip kale, intaben o agomip binim ke-bom-nilipta, bisop iman unan-bom, mufekmufek saan-bom, iman ilang digin-bom, am dinan-bom no ke-bilip bii, ");
INSERT INTO tlf_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lot ulimal iyo abiip Sodom uyo kupkaa daaginip e, kota maak fagalin tap at kenan-bo so tuum mimin manganbu so uyo wep malaak abelin ke-nuluta, unang tinum iyo alugum anolu kaansip ko. ");
INSERT INTO tlf_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mo Tibil imi Man nimi asok tili alugum nitaman-temip uyo, mungkup unang tinum iyo God imi ilak uyo fom duga-bom-nilipta ba kale, kafin diim komi mufekmufek umi ilak uta fom dugam-silipta, niyo maak fagalin tap tolon-temi ko. ");
INSERT INTO tlf_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Kale bomi am mitam daanan-temu uyo, tinum ilami abal diim kal tonba iyo asok tam ilami mufekmufek am kutam albu uyo kulep mitam iinemin ba kale, ilami mufekmufek alugum boyo faan kutu daaginak o ageta ko. Ulutap kale, tinum ilami ilanggiip kal bom digin-be iyo asok unanbu no ilami mufekmufek am kutam albu uyo kulep mitam iinemin ba kale, ilami mufekmufek alugum boyo faan kutu daaginak o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kale sugayok uyo Lot imi kalel uyo abiip kutam umi mufekmufek kupkaa tulu umi aget uta atin mafaganepmu fupkela umik tem uyo katop fenuta, at mimin tebe ungkwalu kaansu kale, bomi aget uyo fugun-bom-nilipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tinum dogap ita ilami kaal ilak kup suun duga-bom na umdii, kaan-nalata, maagalo kelan-tema kale minte, tinum dogap ita ilami kaal sigim kemin umi ilak uyo do-nama binim kupkaa nimi ilak uta do nimi ogok uta waafuu kwep taba umdii, beta suun nan-tema ko. ");
INSERT INTO tlf_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Niyo weng maak bogopman-temi kale, niyo mililep tili umdii, abiin maagup kulagal tinum alop iyo maak agaal bom-bilip e, ensel iyo tal maak ulaa dep unom-nilip e, maak ita kup dupkaa unon-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ulutap mungkup niyo daanin tili umdii, unang alop maak iman telela-bilip e, ensel iyo tal maak uyo ulaa kwep unom-nilip e, maak uta kup kupkaa unon-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ulutap kale, nimi tolon-temi uyo, tinum alop iyo maak iman ilang digin-bilip e, ensel iyo tal maak ulaa dep unom-nilip e, maak ita kup dupkaa unon-temip o,” age Yesus iyo ilami okumop man baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Kam agela e, ilami okumop man iyo dagalip, “Kamogim kabaa. Boyo dogap kal kanuman-temu o?” agelip e, Yesus isiik bogobe-nala e, “Kabo utamapta e, uun dimduum kaanin unan-kalin iyo kwiin tagang abiil tigiin kutam kal sigin-bilip kalaa agelap umdii, boyo kapkal utamapta e, bilip iyo dimduum umaak kaanebelu uta-bomta sigin-bilip kalaa agelan-temap kale, ulutap ibo utamipta e, mufekmufek sang nimi bogobeli uyo mitam tulu kalaa agelan-temip uyo, kota utamipta e, nimi tolon-temi uyo digibanu kalaa agelan-temip o,” agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesus iyo ilami okumop man iyo bogobelita, daal tebe-bom God imi beten kemin uyo kupkaa no kemin ba kale, beten uyo suun kup ke-bilipta, God iyo imi beten weng uyo yan kepmoma o age-nalata, tam do weng maak baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Abiip maak kutam uyo weng telelmin tinum maak alba kale, beyo God imi atul uyo finanin binim ke-bom imi weng uyo kwaasule-bom no ke-bom-nala e minte, ipkumal imi kaal ilak uyo dugamin binim ke-bom no kem-nuuba ko. ");
INSERT INTO tlf_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kale abiip kutam uyo unang kaluun maak albu kale, boyo suun kup tal weng telelmin tinum iyo daga-nulu e, ‘Nimi waasi iyo, nafak daalan o agan-be kale, kabo dong dogopne-nalap tinum beyo yega dobelapta, nimkalak o,’ age yakyak kemu ko. ");
INSERT INTO tlf_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kale tam kamaki uyo weng telelmin tinum iyo dong dogopmin binim kupkala kuta, siit ilugo-nala e, kota aget fuguno-nala e, ‘Niyo God imi atul uyo finanin binim ke-bom-nili e minte, unang kaluun bomi kaal ilak uyo dugamin binim ke-bom no ke-bii kuta, ");
INSERT INTO tlf_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","unang kaluun suun tal dagagamin kup kem-nuubu boyo niyo daal tebepnesu kale, nagal boyo telela kopmita, nimkalu nan o,’ age aget fuguna o,” age Yesus iyo do weng uyo bagama ko. ");
INSERT INTO tlf_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kota Yesus iyo do weng umi magam uyo bogobela ko. “Ibo weng telelmin tinum mafak bemi weng uyo tolong dolip kale, ");
INSERT INTO tlf_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","8","beyo tinum mafak kuta, unang kaluun umi weng uyo tolong dola kale minte, God beyo atin tambaliim kale, ita ilami unang tinum imi weng uyo tambaliim kup tolong dugan-boma ko. Kale niyo bogopman-temi kale, tinangku-silipta. Unang tinum iyo mililep so daanin so beten ke-bom bomip somip uyo, God iyo im-kagamin binim kale, yuut tambaliim kup dong duga-e-boma ko. Kale minte Mo Tibil imi Man nimi no abiil tigiin o-nili asok kupkaa kafin diim e tolon-temi uyo, niyo utamita, God imi unang tinum kwiin tagang iyo God imi ilak dugan-bom-nilip e, mililep so daanin sino beten ke-bom bomip somip kalaa agelan-temi bele ki? Umbae. Iip maak maak iyo yang iinon-temip kuba. Kale ninggil ibo nimi biilu asok tolon-temi umi aget uyo fugun-bom-nilipta, God imi ilak uyo fomtuup duga-bom aman duga-e-bilipta o,” age baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tinum iip maak maak iyo ilimi aget fuguno-nilip e, “Nuta tol tinum kale minte, tinum kek kek bilip ita tol tinum ba o,” agan-bilip kalaa age-nala e, Yesus tebe do weng maak bilip imi bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Tam tinum alop maak bilip iyo, God imi beten ke-emum o age-nilip e, no ulotu am miton unip ko. Tam maak beyo Falosi e minte, maak beta takis mani kwaamin tinum no ko. ");
INSERT INTO tlf_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Tam Falosi beyo ilami aget kup fugun-bom-nala e, beten kema ko. ‘God kabaa. Niyo nugumal kek kek fengmin tinum ilitap ba kalaa age-nilita, “Misam o,” agan-bii ko. Bilip iyo ipkumal imi mufekmufek uyo bisop kwaa-e-bom-nilip e minte, bisop baga-bom-nilip e minte, sa daga-bom no kem-nuubip kale minte, nita boyo maak kanum-nuubaali ko. Kale niyo yak takis mani kwaamin tinum kulatap keluta, fengam-nuubaali kale, niyo, “Misam o,” agan-bii ko. ");
INSERT INTO tlf_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nimi kuguup tambal kanum-nuubi umi sang uyo tinangku-salapta. Suun kup Sarere ko age wiik dakan kem-nuubup umi iibak tem kwek uyo niyo kapmi aget uyo fomtuup fugun-bom-nilita, unan-kalin binim ke-bii am alop ke yakyak ke-bom-nili e minte, nimi mani kwan-nuubi uyo baan nagaal kal faga-nili e, baan maak bota kulep tal ulotu am miton katam kal kapmi kugake-bom kem-nuubi o,’ agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Kale minte tinum takis mani kwaamin beyo unanbu top umik tem kutop kal mo-bom ilami kuguup mafak kem-nuuba umi fitom uta tebebelu abiil tigiin uyo kiit fen-nama binim kupkaa kalaak fen-nala e, bogola ko. ‘God kabaa. Niyo fengmin tinum kale, niyo ni-filin daa-nalap dong dogopnelal o,’ agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Kale niyo ibo weng maak bogobelan-temi ko. God iyo tebe-nala e, takis mani kwaamin tinum imi fengmin uyo takan kebe, ‘Tol tinum kelap o,’ agelata, ilami am iinata minte, Falosi ita God iyo dupkalata, yagal bisop ilami am iina ko. Kale tam tinum ilami win kufolan-tema uyo, God iyo bogobe-nala, ‘Nimi tiin diim uyo kanupmin tinum kabo kubaganap win binim o,’ agelan-tema kale minte, tinum dogap ita ipkumal imi afak tem iinom ilami win uyo kufumin binim kema umdii, God iyo kanupmin tinum bemi win uyo kufu-e-bom bogobe-nala, ‘Nimi tiin diim uyo kabo kwiin kiim o,’ agelan-tema o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tam unang tinum mafak ilin ita kup kulep tal Yesus imi finang talanbaalip kale, man kangkang sino kulep Yesus imi finang talan-bilip kale, ogenal imi aget fugunin uyo, Yesus tebe sagaal kwep yak man kangkang imi dubom diim daabe dong dogobelata, tambaliim kup fitolin o age-nilipta, man kangkang iyo kulep tilip kuta, Yesus imi okumop man iyo utam-nilip e, ogenal iyo fot tebelup daaginin o age yan-togon-kalip e, ");
INSERT INTO tlf_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yesus iyo ogenal iyo bogobe-nala e, “Man kangkang iyo kulep nimi finang tilipta o,” age-nala e minte, imi okumop man imi bogobe-nala e, “Unang tinum utamipta, God beyo nuyo dong dogobelan-tema kalaa age-nilip mitam God imi daam tem telebip iyo man kangkang ilitap kale, ibo man kangkang bilip iyo fot tebemin ba kale, imkalip nimi finang tilin o ageta kale, ");
INSERT INTO tlf_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","niyo tol kup weng uyo bogobelan-temi kale, tele tinangku-silipta. Man bilip iyo kangkang albip uta, aalabal iyo, mufekmufek umaak kobelum o agelan-temip kota, man bilip iyo maagalo yak aalabal imi sagaal diim mufekmufek uyo kulan-temip kale, ulutap unang tinum waantap ita, God imi daam tem uyo tam unum o agelip uyo, dupkalipta, God yagal dong dogobelata, God imi daam tem uyo mitam tolon-temip kale minte, unang tinum waantap ita, ilimi aget fugun-bom kuguup mafak kanumum o agelip uyo, ilimi san kale, mitam God imi daam tem mitam tolon-temaalip o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tam Juda kasel imi kamok maak Yesus imi daga-nala e, “God imi weng kafalemin kabaa. Kabo tinum tambal kale, nimi dagagamin maak kopkelan-temi boyo yan kepnelapta, utaman. Niyo mitam suun nin tinum kelan o agan-bii kale, bota dogobe-nilita, mitam suun nin tinum kelan-temi o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesus iyo bogobela, “Kabo intaben o ageta bogopne-nalap, ‘Kabo tinum tambal o,’ nagelap a? Tinum tambal iyo maak albaala kale ki, God maagup ita kup tinum tambal kale, kapmi weng ko bogopnelap boyo, beyo waanta kalaa nage-nalapta, bogopnelap a? ");
INSERT INTO tlf_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kabo God imi ulo kwep daasa uyo utamsap kale, bogo-nulu e, ‘Kapmi kalel uyo kupkaa yang kapkum imi kalel uyo takamo tiinemin ba e minte, kabo unang tinum iyo inolap kaanamin ba, kabo yuguut unan-kalin ba, kapkum iyo fenga kolin-tem uyo, kabo bisop bogo kiyap iyo baga-emin ba, kabo kapmi kogen kaalap imi weng uyo tinangku waafuna-bom, minte kuguup tambal kup kupka-e-bom no kemin o,’ agesu o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","kota tinum kamok beyo bogola, “Niyo sugayok man katip kutop ilota kwep tal tinum kiim ke kaa diibeli uyo, God imi ulo boyo waafuu kwep tebesi o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesus iyo tinum kamok bemi weng uyo tinangku-nala e, bogobela ko. “Bole kanum-nuubup kuta, kabo kuguup maagup maak bota kup kanum-nuubaalap kale, kabo no-nalap kapmi mufekmufek uyo kapkumal imi kobelapta, ita molipta, mani uyo kulu-nalapta, iip kulin man imi kobelan-temap uta, no God imi abiip kal suun kup tambaliim nan-temap ko. Kale kabo nisino tiine-bomta, God imi ogok uyo kemum o,” agela e minte, ");
INSERT INTO tlf_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","tinum kamok beyo mufekmufek soyaap kale, Yesus imi weng bogola boyo tolong do-nalata, imi aget uyo fuguno-nala e, “Atin suun nin tinum kelan o agan-bii kuta, nimi mufekmufek boyo fen iip kulin man iyo kopman-temaali o,” age-nalata, aget iluum kup tebepmu ko. ");
INSERT INTO tlf_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Kale Yesus iyo utamata e, tinum mufekmufek soyaap beyo aget iluum tebema kalaa age-nala e, ilami okumop man imi bogobela ko. “Kwiin. Mufekmufek soyaap unang tinum iyo bong faga-bom-nilipta, (imi mufekmufek baan fagagan unsip uyo kupkalan-temip kale, iip maak maak ita kup God imi aget kobe-nilipta,) mitam God imi daam tem uyo mitam tolon-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kale utamsup kale, kong kiim ko age kamel boyo, tam men sok sil imi magat kun tem ilep tam iinon o agelu uyo, bong fagan-bii-nuluta, tam iinon-temu kale, ulutap kale, tinum mufekmufek soyaap yagal mungkup atin bong kup fagan-bii-nalata, mitam God imi daam tem uyo mitam tolon-tema o,” agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Kale unang tinum Yesus imi weng bogola uyo tinangku-nilip e, Yesus imi daga-nilip e, “Kanube tinum mufekmufek soyaap iyo bong faga-bom-nala tam God imi daam tem uyo una umdii, win binim unang tinum nule dogobe-nulupta, tam God imi daam tem uyo unon-temup a? Boyo fen bagang-kale tam unomup binim o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesus iyo bogobela, “God ita tii alugum mufekmufek uyo kanube-nama kuta, tinum ilasinon uyo, bagang-kale-nalata, mitam God imi daam tem uyo mitam tolon-temaala kale, God yagal dong dogopman-tema uta, mitam God imi daam tem uyo mitam tolon-tema o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Fita isiik bogobe-nala e, “Kamogim kabaa. Tolong do-salapta. Ninggil nuyo numi abiip sino numi mufekmufek sino uyo kupka-nulupta, kapmi ogok uta kem kapsino tiinan-bulup kole o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","kota Yesus iyo ilami okumop man ninggil imi bogobe-nala e, “Bole dam kuta minte, nimi bogopman-temi koyo dam no ko. Waantap ita aget fuguno-nilip, ‘Nuyo God imi weng uyo kwep yang unang tinum iyo baga-e-bulupta, tam God imi daam tem uyo tam unin o,’ age-nilip e minte, imi am sino, kalel sino, man sino, fik sino, ibinang sino, ogen aalap sino iyo abiip kugol imka-nilipta, tal God imi ogok uta waafulip umdii, ");
INSERT INTO tlf_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kamano kafin diim kaa albip kota, kanupmin mufekmufek umi kupkaa tisip uyo kwiin tagang kota kululan-temip kale, aaltam kaanan-temip uyo, no tamip God so suun kup nan-temip o,” agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesus iyo ilami okumop man iyo afeta ko kulep yang-nala e, bogobela ko. “Ibaa. Siin uyo Mo Tibil imi Man nimi sang uyo God imi profet ko age weng kem baga-emin tinum imi bogobelata, ita God imi suuk kon tem kal dola-silip kale, kamano kota nuyo, Jerusalam kamet iinum o age talan-bulup kale, no kugol bom-bulupta, weng boyo alugum mitam tebe abulan-temu ko. ");
INSERT INTO tlf_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kale no Jerusalam tamupta, Juda kasel imi kamogimal ita tebe-nilipta, nimdalip yak Rom kasel imi sagaal diim abelita, ita tebe-nilipta, titul weng bagane-bom-nilip e, weng mafak uyo bagane-bom-nilip e, mok uyo nimi kaal diim uyo tagaa kone-bom-nilip e, ");
INSERT INTO tlf_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","sok ifet ku saal daga-bom ke-bii-nilip e, nangkolip kaani namalip bii, am alop ke-nilita, am asuno diim kota asok fen tigi molan-temi o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kuta imi okumop man iyo Yesus imi weng bagan-be bomi magam uyo tele utamin-tem kelip ko. Kale Yesus ilami okumop man iyo imi weng bagan-be bomi aget uyo tele fugunolin-tem ke-nilipta, weng bomi magam uyo dagaa kulin-tem kelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kale Yesus sino ilami okumop man sino iyo no abiip Jeriko mep so so abe-silip e, tinum tiin mafak maak beyo ilep magaang tem kal ton-bom-nala e, unang tinum tiinan-bilip imi mani sang dagaga-bom-nala e, nen-bom bomta, ");
INSERT INTO tlf_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","tolong dolata e, unang tinum kwiin tagang iyo tiinan-bilip kalaa age-nala e, dagala ko. “Boyo intaben nu-bilip o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","unang tinum iyo bogobelip ko. “Abiip Nasaret kayaak Yesus ita talan-be o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","tinum tiin mafak beyo Yesus imi olabe-nala e, “Kamogim Yesus kabaa. Kabo kalapmi afalik King Devit ilatap kale, niyo ni-filin daa kapmi titil uyo ku-nalap dong dogopne o,” agan-kala e, ");
INSERT INTO tlf_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","tam unang tinum Yesus imi bon tem unan-bilip iyo agan-bom bogobe-nilip e, “Sining agelal o,” agan-bilip kuta, tinum tiin mafak beyo Yesus imi fomtuup ole-bom-nala e, “King Devit man ilop Kamogim kabaa. Kabo ni-filin daa dong dogopnelal o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesus iyo ilep unan-be uyo kupkaa kugol mo-nala e, kek kek imi bogobela ko. “Ibaa. Tinum tiin mafak beyo nimi finang dep tilin o,” agela e, tinum tiin mafak iyo dep tal Yesus imi miit tem daalip e, Yesus iyo tinum tiin mafak imi bogobe-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Kabo, niyo intaben nupnelak o ageta olne-balap o?” agela e, tinum tiin mafak iyo bogola, “Kamogim kabaa. Nimi tiin koyo telela kopnelap tambalanepneluta, mufekmufek uyo utamaman o ageta olan-bii o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","kota Yesus iyo bogobela, “Niyo utamita, kabo, beyo fen telela namolan-tema kalaa nagelap kalaa age-nilita, kamano kaa telela kamoli asok tambalanap kale, fen-nalap tiin baa mufekmufek uyo tele utamal o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kota maak fagaa tinum tiin mafak imi tiin uyo tambalanebelu e bole, Yesus isino tiine-bom-nala e, God iyo, “Misam o,” agan-kala ko. Kale unang tinum iyo alugum utamipta e, Yesus tebe tinum tiin mafak iyo telela dola kalaa age-nilip e, God imi win uyo kufu-e-bom deng tebemip ko. ");
INSERT INTO tlf_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesus sino ilami okumop man sino iyo, no abiip Jeriko uyo ugaa kupkan ke unum o age-nilipta, tam Jeriko tam tamipta bole, ");
INSERT INTO tlf_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","tam tinum maak alba kale, bemi win uyo Sakius kale, beyo takis mani kwaamin tinum imi kamogim e minte, mufekmufek soyaap no kale, beyo Jeriko kutam kal nin kale, ");
INSERT INTO tlf_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Sakius iyo, Yesus beyo atamta, waantap ita kalaa agelan o agan-be kuta, unang tinum kwiin tagang ita te top bon tem katop kal molip kale, Sakius beyo tinum duumaat kale, Yesus iyo atamin-tem kela ko. ");
INSERT INTO tlf_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kota Sakius iyo utamata e, Yesus iyo ka-tele tolon-tema kalaa age-nala e, Yesus beyo ataman o age no ke-nala e, isiik unang tinum kwiin tagang tem ku-tele yuut no abe tam at yet al maak kutam kal tona ko. ");
INSERT INTO tlf_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kale kota Yesus iyo tal Sakius imi at yet al tonba umi afak tem kugol mo-nala e, kiit fen Sakius iyo atam bogobe-nala e, “Sakius kabaa. Kamano koyo niyo kapmi am kal nan-temi kale, kabo yuut at al boyo kupka-nalap malaak kafin diim talapta o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","kota Sakius iyo at al uyo kupka-nala e, yuut malaak kafin diim malaak-nala e, Yesus iyo weng umobe deng afalik kup tebema ko. ");
INSERT INTO tlf_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Kale unang tinum iyo alugum utamipta e, Yesus iyo fengmin tinum imi am iinon-tema kalaa age-nilipta, Yesus iyo umik tem weng baga-e-bom-nilip e, “Beyo no fengmin tinum imi am kal son-tema o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kale kota Sakius iyo Yesus sino imi okumop man sino iyo imtamo tam ilami am imdep tam daala ton-siit-nilip e, tam kota Sakius iyo fen mo-nala e, Yesus imi bogobela, “Nugum kabaa. Tolong do-salapta. Niyo nimi mufekmufek uyo baan alop faga-nilita, tam maak uta bulup man imi togobelan-temi ko. Minte tam maak uyo unang tinum imi bisop baga-e-bom-nili imi mani daga-em-nuubi uyo, asok kuga-eman-temi uyo, tuumon maagup dagaa dube-sii kalaa ageli umdii, tuumon kalbinim umaak kwegobe no ke kobe yakyak keman-temi o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesus isiik bogobe-nala e, “Kabo Abraham imi man ilop kuta, kabo siin uyo God imi ilep uyo kupkaa yang atin maagalo kesap kuta, kamano kota God iyo tebe kapsino minte kapmi man sino kalel sino ipmi ilim uyo bobela waalanip ko. ");
INSERT INTO tlf_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mo Tibil imi Man niyo tal, unang tinum God imi umik ugobe maagalo kesip ita dong dogobe imi ilim uta bobeli waalanin o age-nilita, fen ti-sii o,” age Sakius imi bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Kale Yesus iyo tal Jerusalam mep so tala kalaa age unang tinum iyo aget fuguno-nilip e, “Kamano kota God iyo tebe Rom kasel iyo tagaa imkan ke-nalata, nuyo tiin molan-tema umaak o,” agelip ko. Kale unang tinum iyo Yesus imi weng tinangka-bilip e, tam Yesus iyo, kafalebelita, utamipta, numi aget fugunin boyo bisop bagan-bulup kalaa agelin o age-nalata, felep yak ku to do weng maak bogola ko. ");
INSERT INTO tlf_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Tam kamok maak aget fuguno-nala e, ‘Olapnebip kale, niyo unanbu no anang simanim maak kutam iinita bole, anang kasel ita tebe-nilipta, ulaa nimdu-nilipta, “Numi tiin molin ko age king kelal o,” agelipta, asok tolon-temi o,’ agan-kala ko. ");
INSERT INTO tlf_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Tinum beyo, unon o agan-som-nala e, kota imi ogok kemin tinum nagaal kal iyo olabela tilip e maagup maagup iyo mani wan tausen (1,000) uyo kobe yakyak ke-nala e, bogobe-nala e, ‘Nimi no simanim kal nan-temi uyo, ibo mani kobeli boyo kulu bisnis ke-bom mani uyo maak so kwaa-bilipta, bii asok nimi tolon-temi kota, mani uyo asok kopnelin o,’ agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Kale tinum beyo age kupkaa daagina e, tam ilami abiip tinum atafinon-nuubip iyo kalaan tinum imdalip imi umik tem no-nilip e, simaan unang tinum imi bogobe-nilip e, ‘Nuyo, tinum beyo numi king kelan-temaala o agan-bulup o,’ agelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Kale kam agelip kuta, tinum beyo ulaa dulip mitam king ke-siit-nalata, asok daage tal ilami abiip tal-nala e, maak fagaa ilami ogok kemin tinum maak bogobe-nala e, ‘Yuut no tinum nagaal kal imi siin mani kobin-sii iyo olabelap tilipta, dagata nimi mani uyo maak sino intap kal kota kulubip kalaa agelan o ageta kale, no imtamo talaal o,’ agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Kale tinum maak isiik tal king imi bogobe-nala e, ‘Kamogim kabaa. Kapmi mani kopnin-salap uyo kulu bisnis ke-bom senganu kupkapke-nilita, mani ten tausen (10,000) maak kulupke no kebi o,’ agela e, ");
INSERT INTO tlf_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","king iyo bogobe-nala e, ‘Suguul ke kabo ogok kopkin-sii boyo kupkasaalap kale, kabo fomtuup dital fagaa tambaliim kup kem tebesap kale, mufekmufek katip ita ko tambaliim kup tiin mosap kalaa age-nilita, niyo kota abiip nagaal kal kota kopkelita tiin molan-temap o,’ agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Minte tam tinum maak iyo tal-nala e, bogobela, ‘Kamogim kabaa. Kapmi mani kopnin-salap uyo kulu bisnis ke-bom senganu kupkapke-nilita, mani faiv tausen (5,000) maak kulupke no kebi o,’ agela e, ");
INSERT INTO tlf_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","king iyo bogobela, ‘Tambaliim kale, kabo abiip ogal kota kopkelita, tiin molan-temap o,’ agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","“Tam tinum migik maak iyo tal-nala e, bogobe-nala e, ‘Kamogim kabaa. Katamita, kabo alaang bubul kolin tinum kalaa agesi kale, kapmi ogok kemin tinum iyo bong faga-bom bisnis ke-bom-nilipta, umi profit mani uyo kwaake-bilipta, kabo miing diim kup tal ton-nalapta, kwaa-bom-nalap e minte, kapmi ogok kemin tinum imi ilanggiip umi mufekmufek ulip mitam damanu uyo kabo miing diim kup tal ton-nalapta, kwaa-bom no kem-nuubap kale, niyo kapmi atul uta finan-bom-nili e minte, bisnis umi kuguup umaak utamin-tem no keli kalaa age-nilita, kapmi mani uyo tambaliim kup kupkapkeli nuubu kale, kotam o,’ agela e, ");
INSERT INTO tlf_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","king iyo ilami ogok kemin tinum bemi bogobela, ‘Kabo ogok kemin tinum mafak kale, kalapmi weng bogopnelap bomi kalan uta sok de kamolan-temi ko. Kabo bogopne-nalap kano, “Kabo alaang bubul kolin tinum kale, kapmi ogok kemin tinum imi ogok ke-bom mani kululip uyo kabo miing diim kup tal ton-nalapta, kwaa-bom-nalap e minte, kapmi ogok kemin tinum imi ilanggiip umi mufekmufek ulip mitam damanu uyo miing diim kup tal ton-nalapta, kwaa-bom no kem-nuubap o,” agelap kale, ");
INSERT INTO tlf_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","intaben o age-nalapta, nimi mani boyo kulep no beng tem tolapta, nimi mani uyo sengansaalu a? Kanube-salap nimnam, niyo asok talta mani bisel kululi kuta, boyo kupkalapta, niyo tal-nilita, nimi mani atuk uyo kululin-tem ke-nilita, asok nalami mani dopkin-sii ita kup dululi o,’ age-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","tam ilami dong daga-emin tinum albip bilip imi bogobe-nala e, ‘Ibaa. Yak imi sagaal diim mani waafuba boyo kulu-nilip tinum mani ten tausen (10,000) kuluba bemi kobe no kelin o,’ agela e, ");
INSERT INTO tlf_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","tam bogolip ko. ‘Kamogim kabaa. Tinum beyo mani ten tausen (10,000) kuluba kale, bo kam agan-kalin ba o,’ agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","king iyo imi weng yan kebe-nala e, ‘Weng maak bogobelan-temi kale, tinangku-silipta. Tinum waantap ita ogok tambal ke-bom-nala e, imi kamok imi weng tinangka-bom no kema umdii, bemi kamok iyo tebe ogok uyo maak so kobelata, ogok kwiin kiim uyo ke-bom-nala e minte, mani kwiin tagang uyo kwaa-bom no keman-tema kale minte, tinum waantap ita ogok uyo mafak ke-bom-nala e, imi kamok imi weng uyo kwaasule-bom no kema umdii, bemi kamok iyo tebe fot tebelata, ogok umi tisol uyo maak so kwaaman-temaala o,’ agan tolom-nalata minte, ");
INSERT INTO tlf_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","maak uyo bogo-nala kano, ‘Ibo no siin tinum bogo-nilip kano, “Nuyo tinum beyo numi king kelan-temaala o agan-bulup o,” nage-silip iyo kulep tal nalami tiin diim kagal inolip kaanin o,’ agesa o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tam Yesus imi weng uyo binimanu e, Yesus ita bon tem kela e minte, imi okumop man ita umik tem ke no ke-nilip e, dagaa kulep Jerusalam unip ko. ");
INSERT INTO tlf_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kale abiip alop maak Betfage so Betani so boyo unanbu tam Oliv Tigiin kutam kal albu kale, Yesus ninggil iyo tam mep so tam-nilip e, Yesus iyo, ilami okumop man alop maak isiik imdali unipta o agan-som-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","tam alop bogobe-nala e, “Alop ibo yak abe abiip utaman-bulup boyo tamta, kong ko age dongki man kagum maak dup-diilip alba kalaa agelan-temip kale, beyo siin uyo tinum iyo maak bemi daang kun diim uyo tona dep tiinemin-tem alba kale, ibo sok talaa daa-nilipta, nimi finang dep tilin o ageta kale, ");
INSERT INTO tlf_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","kanum abe-silipta, tinum iyo maak alop ipmi daga-nala, ‘Intaben o age-nilipta, bemi sok uyo talaa daagan-bilip o?’ agela umdii, ipkil bogobe-nilip kano, ‘Numi kamogim iyo, “Dep tilin o,” agelata, tulup o,’ age bogobe-nilipta, dep tilin o,” age-nalata, imdala unip ko. ");
INSERT INTO tlf_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kota alop iyo tal abiip tal abomu e, Yesus imi bogobela ulutap mungkup dongki man kagum iyo dup-diilip alba kalaa age-nilip e, ");
INSERT INTO tlf_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","alop iyo sok uyo talaa daagamip e, dongki imi tiin molin tinum iyo tal daga-nilip e, “Ibaa. Boyo intaben nulum o age-nilipta, dongki imi sok boyo talaa daagan-bilip o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","alop iyo yan kebe bogobe-nilip e, “Numi Kamogim iyo bogobe-nalata, ‘Alop no dep tilin o,’ agelata, alop nuyo tulup o,” age bogobelip e, dongki kasel iyo, “O,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","alop iyo dongki man kagum iyo dep tal Yesus imi diim daalip e, ilami okumop man iyo ilimi ilim uyo dulu kulep te tam dongki imi daang kun diim uyo ifobe-nilip e, Yesus iyo dong dogopmip e, te tam dongki daang kun diim ton-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","abe-balata, tinum unang imi aget fugunin uyo, king imi tal-bala deng tebemin kuguup uyo kanumin kale, Yesus imi ka-tele talan-be boyo, nuyo ilep koyo atin tambaliim kup telelepmupta, tiinak o age-nilipta, ilimi ilim iip maak maak uyo dulu kulep daak ilep kugol ifum yakyak ke-bilipta, dongki beyo Yesus iyo duptamo ilim tip diim kutop-tele tiina ko. ");
INSERT INTO tlf_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yesus iyo Oliv Tigiin uyo kupkaa daak Jerusalam mep so so abe-sala e, Yesus imi ilak dolin unang tinum kwiin tagang iyo tal Yesus iyo fufala dolip e, iso iso abe-bom-nilip e, unang tinum iyo kuguup migik migik Yesus imi kanu-bala utaman-bomip umi aget uta fugun-bom-nilipta, alugum bilip iyo God imi tok uyo baga-bom fomtuup ol-bom-nilip e, deng kup tebemip ko. ");
INSERT INTO tlf_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Bogo-nilip e, “Numi kamok king keyo God kapmi win tolop diim o ageta talan-be kale, kabo kuguup tambal uta kup kupka-e-balapta o ageta kale, keyo nuyo dong dogobela waalan-nulupta, tam abiil tigiin kutam kal abiin tambal tonan-temup kale, nuyo kapmi win afaligen boyo kufukemum o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kale Falosi iip maak maak iyo unang tinum tagang tem kulagal albip kale, Yesus imi bogobe-nilip e, “Kafalemin kabaa. Unang tinum kapmi daang begepkebip kalip iyo bogobelap sining agelin o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesus iyo yan kebe bogola, “Niyo fegelebelan-temaali kwa. Kale niyo ibo weng maak bogobelan o ageta kale, tinangku-silipta. Unang tinum kalip iyo sining agelip umdii, daak tuum bilip ita tinum ilitap ke-nilipta, nimi win uyo kufuneman-temip o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesus iyo tal abiip miton Jerusalam mep so tal abiip boyo utam-nala e, kota abiip kasel imi i-filin-bom-nala e, aman-bom ");
INSERT INTO tlf_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","44","bogola, “Ibo, nuyo tambaliim kup bilili age-bom-nulupta o agan-bilip kuta, am kaa daan-suu koyo, ipmi aget fugunin uyo mafagan-suu kale, ibo kanupmin kuguup umaak utabaalip binim e minte, bilili agan-kalin kuguup uyo utabaalip binim no ko. Ibo utamipta, kamano koyo God iyo, nuyo telela imolan o agan-be kalaa age utamip nimnam, ibo telela imola kuta, ibo tiin tugul tap ke-nilip ipmi aget uyo fupkelalin-tem kelip boyo, ibo uk kugan kolip kale, bota son-temu nala am maak daanan-temu uyo, ipmi waasi iyo tal-nilip e, ipmi abiip koyo fufala kolip e, ibo mitam ok finang, iman finang, intaben umi finang umaak mitam tolon-temaalip binim kelu e, waasi iyo tulum aga-bii kulep tam abiip daam dong diim to-nilip e, iyo fon tam daam al fogo tam-nilipta, alugum ibo aa-bom-nilip e minte, mufekmufek sino abiip sino uyo kufak daga-e-bom no ke-bom-nilip e minte, ipmi tuum am desip so tuum daam fogosip so uyo degela kululip malaak kafin diim abe-nuluta, tuum uyo segela yang kube meng kube ke-bom no keman-temu o,” age Jerusalam kasel imi aget fugun-bom-nalata, amema ko. ");
INSERT INTO tlf_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesus iyo ilami okumop man iyo kulep no Jerusalam abe-nala e, tam ulotu am miton kutam uyo tamta itamata e, tinum iyo tebe-nilip e, mufekmufek God imi kuga-emin uyo kulep te tam tolip ulotu am miton kutam kal saan-bilip kalaa age-nala e, Yesus iyo tebe tinum mufekmufek kulep te tam to-bilip bilip iyo fot tebela tam iine-bilip e, ");
INSERT INTO tlf_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","kong saan-bilip umi tisol kwan-bilip iyo weng maak bogopma, “Sugayok God imi suuk kon tem uyo bogo-nala e, ‘Nimi am katam uyo beten kemin umi am nan-temu o,’ agesa kale, ibo God imi weng boyo utamsip kuta, kwaasulebe-nilipta, God imi am katam uyo kufak daga-e-bilip kale, am katam uyo ipmi bisnis ke-bom ipkumal imi mani yuguut unan-kalin umi am kelu kupkasip o,” age Yesus iyo bogopma ko. ");
INSERT INTO tlf_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kale Yesus iyo God imi weng uyo ulotu am miton kal unang tinum iyo suun kup kafale-bii yakyak ke-balata minte, tam tinum amem ko age pris imi kamogimal so ulo utamsip so Jerusalam kutam umi kamogimal so iyo, “Kanubelu koyo, dogobeta Yesus iyo angkolup kaanak o?” age-nilipta, ilep fenip kuta, ");
INSERT INTO tlf_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","alugum unang tinum iyo, Yesus imi weng uta tinangkamum o age-nilipta, suun kup fufala dek mo yakyak ke-bom tinangkamin kup ke-bilipta kale, kamogimal iyo dogap-tele yangta aafu-nimip binim kemip ko. ");
INSERT INTO tlf_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Tam am maak daanu e, Yesus iyo ulotu am miton kal unang tinum iyo kafale-bom God imi weng tambal uyo baga-e-bom no ke-bala e, tinum amem ko age pris imi kamogimal so ulo utamsip tinum so Juda kasel imi imi kamogimal so iyo tal ");
INSERT INTO tlf_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","bogobe-nilip e, “Kabaa. Kabo waami win tolop diim kanupmin kuguup boyo kanum-nuubap a? Kabo waantap ita kamdala tal-nalapta, kanupmin kuguup boyo kanu-maansap o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesus iyo bilip imi weng uyo yan kebe bogobe-nala e, “Kalo. Nisiik weng maak ipmi dagalan-temi kale, uyo ipsiik nimi weng boyo yan kepnelipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jon Baptis iyo waami win tolop diim unang tinum iyo ok sam uga-emsa a? God imi win tolop diim bele, kafin diim komi tinum imi win tolop diim kanumsa a? Yan kepnelipta o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","tam kamogimal iyo en-bom bogobina tala ke-bom-nilip e, bogolip, “Nuyo intaben o agelan-temup a? Nuyo bogo-nulup, ‘God imi win tolop diim kanumsa o,’ agelan-temup bole, beyo tebe nuyo bogobe-nala e, ‘Ibo utamipta, God imi win tolop diim kanumsa kalaa agelip umdii, intaben o ageta ibo, Jon beyo fen God imi weng uta baga-e-be kalaa agansaalip o?’ agelan-tema kale minte, ");
INSERT INTO tlf_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","unang tinum kwiin tagang kalip iyo aget fugunolipta e, Jon iyo God imi profet ko age weng kem baga-emin tinum kalaa agan-bilip kale, nuyo bogo-nulup, ‘Kafin diim komi tinum imi win tolop diim kanumsa o,’ agelan-temup uta, kalip iyo olsak deebeluta, tuum kulu nuyo inolan-temip o,” age-nilip e minte, ");
INSERT INTO tlf_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yesus imi weng uyo bisop bogobe yan kebelup ko age-nilip e, “Waantap ita tebe Jon iyo bogopmata, Jon beyo tebe unang tinum iyo ok sam uga-emsa kalaa age utabaalup o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesus isiik bogobela, “Nagal mungkup ulutap kale, niyo ibo bogobe-nili, ‘Waami win tolop diim uta kanupmin kuguup boyo niyo kanum-nuubi o,’ age bogopman-temaali o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kota Yesus iyo siin God ilami profet ko age weng kem baga-emin tinum imdala telemsip umi sang felep yak ku to do weng migik maak bogo-nala e, unang tinum iyo baga-ema ko. “Tam tinum maak sok dum ilang maak digin-bii ke kupka-nala e, sok dum ilang boyo kwaapma yak tinum migik iip maak maak imi sagaal diim abelu e, bogopma, ‘Ibo nimi sok dum ilang koyo tiin mopne-nilipta bii, dam abulu kalaa agelan-temip uyo, dagan-bii ko kupkaa tugut-bom ok uyo ilan-bii kobelip ipkumal ita molipta, ibo tisol uyo kulu-nilipta, duula ko ipkil atuk uyo kulu-nilip e minte, nagal atuk uyo kulupnelip no telemuk o,’ age-nala e, imkaa no abiip maak simanim kugol amiit tona ko. ");
INSERT INTO tlf_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","“Kale sok dum abumin am uyo daanu e, (tiin molin tinum iyo sok dum uyo dagan-bii ko kupkaa tugut-bom ok uyo ilan-bii kopmip ipkumal iyo molip e,) kota sok dum ilang kayaak iyo ilami ogok kemin tinum iyo daala tal sok dum ilang tiin molin imi bogobe-nala e, ‘Nimi kamogim imi sok dum ok umi tisol atuk uyo kopnelipta, nimi kamogim imi kulubinon o,’ agan-be kuta, bilip iyo tebelipta, saal dagan-bii angko-nilip e, bisop daalip ilami kamok imi finang una ko. ");
INSERT INTO tlf_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kale tal tama e, asok kamogim iyo ogok kemin tinum migik maak iyo weng kobe-nala e, daala no sok dum ilang tiin molin tinum imi diim abe-nala e, imi kamogim imi weng uyo bogopma kuta, ita tebe saal dagan-bii angko-nilip e, kuguup mafak mafak uyo kupka-e-bii dupka-nilip e, bisop daalip una ko. ");
INSERT INTO tlf_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Aa minte kamogim iyo asok ilep asuno diim kota ogok kemin tinum migik maak iyo daala no sok dum ilang tiin molin tinum imi diim abela e, angkolip e, ita fomana isak tebelu aafuu daalip tam daam tem kube una ko. ");
INSERT INTO tlf_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Kale sok dum ilang kayaak iyo aget fugunola, ‘Kwiin. Kota intaben nulan-temi a? Aa, niyo aget fugunin uyo maak utami kwa. Kale nalami bubul tem man ita daali una umdii, imi weng uyo kwaasulepman-temaalip o,’ age-nalata, ilami man beta afungim daala no sok dum ilang tiin molin tinum imi finang una ko. ");
INSERT INTO tlf_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kuta no tama tiin molin tinum iyo atam-nilip e, ilimi kup bogobina tala ke-bom-nilip e, ‘Tinum tala beyo kamogim ilami man kale, biilu aalap imi kaanan-tema uyo, man beyo tebe aalap imi sok dum ilang koyo bugulan-tema kale, kamaa kagal angkolup kaanata, sok dum ilang koyo nulumi aligaap keluk o,’ age-nilip e, ");
INSERT INTO tlf_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","kota yak aafu-nilip e, dilili duptamo daam tem uyo kupkaa tam sep kutam daa-nilip e, angkolip kaana o,” age baga-ema ko. Kale Yesus iyo weng bomi atuk uyo maak so bogobe-nala e, “Ibaa. Kanubelip kalaa age-nalata, sok dum ilang kayaak beyo tebe sok dum ilang tiin molin tinum bilip iyo intaben nupman-tema a? ");
INSERT INTO tlf_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Beyo tal-nala e, tiin molin tinum kulip iyo inola kaan binimanip e, asok tinum migik ulu-nala e, sok dum ilang uyo kwaapma yak bilip imi sagaal diim abelu e, igil mitam tiin molan-temip o,” age Yesus iyo do weng boyo bagama ko. Unang tinum iyo do weng boyo tolong do-nilip e, (iyo utamipta e, sok dum ilang kayaak iyo ki God imi sang uta baga-e-be kalaa age-nilip e minte, sok dum ilang tiin molin tinum iyo ki Juda kasel nulumi kamogimal imi sang uta baga-e-bom no ke-be kalaa age-nilipta,) bogolip, “Umbae. God iyo numi kamogimal iyo kanube inolan-temaala binim kuba,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesus iyo kek fen tele dagak diibe bogobe-nala e, “Kam agelip kale, dok umi magam uta God imi suuk kon tem weng koyo bogo-nulu ‘Ogok kemin tinum iyo am uyo dinan-bomta kek fenipta e, am kun maak boyo mafak kalaa age-nilip e, falang daa kwaalip yak magaang tem kwek iinu kuta, kamok iyo am kun uyo utam-nala e, “Boyo tambaliim kale, am duu umi dol keluk o,” age-nala e, am kun boyo asok kwep mek molata, boyo felepmu molu o,’ agesu a? ");
INSERT INTO tlf_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Aa mungkup tuum afalik maak albu kale, tinum dok ita kumen malaak tuum diim kubela umdii, beyo mafaganan-tema e minte, tuum boyo dagaa kutiga malaak tinum bemi kaal diim abelan-temu uyo, atin dupdaak tamalu telela tebelan-tema o,” age Yesus iyo ilami sang uta felep yak am kun so tuum afalik so umi diim to-nalata, bagama ko. ");
INSERT INTO tlf_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ulo utamsip tinum isino e minte tinum amem ko age pris imi kamogimal so iyo utamipta e, Yesus iyo ilimi sang uta felep yak ku to do weng kup baga-e-be kalaa age-nilip e, kota yuut dubak kobe-bom aafuu sok de dolum o agelip kuta, unang tinum Yesus ilami weng tinangkan-bilip imi atul uta finano-nilipta, sok de dolin-tem dupkalip ko. ");
INSERT INTO tlf_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kale ulo utamsip tinum sino tinum amem ko age pris imi kamogimal so iyo bogo-nilip e, “Nuyo ata-bom-sulupta, Yesus imi kuguup mafak umaak kanubela kalaa agelan-temup kota, aafuu daalup yak Rom imi gavman dubom imi diim abelata, yagal yega dobe dupka-nalata, ilami waasi dinan-kalin tinum ita bogopmata, Yesus iyo angkolin o,” age-nilipta, Yesus iyo tele ataman-bilip ko. Kale iyo tinum migik maak tuumon kobe mo bogobe-nilip e, “Ibo no Yesus iyo atam-nilip e, bisop bogo, nuyo tinum tambal o age filto-e-bom tele atama-bomta, Yesus iyo weng mafak aa-e min umaak bogola kalaa ageta tal bogopmipta o,” age imdalip unip ko. ");
INSERT INTO tlf_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kale no Yesus imi bogobe-nilip e, “Kafalemin tinum kabaa. Nuyo kataman-nuubup kale, kapmi weng baga-e-bom kafale-bom ke-balap uyo tol kup e minte, kabo, yak win tibin bilip ita nimi dong daganemin o ageta imi tok uta kup bagan-nuubaalap kale, kabo alugum unang tinum win tibin tap win binim tap iyo alugum maagup God imi weng so kuguup so uyo tambaliim kup kupka-em-nuubap kalaa agan-bulup kale, ");
INSERT INTO tlf_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","mufekmufek maak umi sang uyo dagalum o ageta kale, (Rom kasel imi ulo uyo bogo-nulu, ‘Ibo ipmi takis mani uyo numi King Sisa ilami gavman imi kupka-emin o,’ agelu e minte, Juda kasel numi ulo uta bogo-nulu, ‘Ibo ipmi mani uyo God imi kupka-emin o,’ age no kesu kale,) numi mani uyo Sisa imi kupka-emum bele, God imi kup kupka-emum o?” agelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kuta Yesus iyo imi aget tem uyo utamepmata e, bilip iyo, tala-emupta, iyo, uk kugan ko yak weng mafak umaak bogobela kalaa agelum o age-nilipta, bogopnelip kalaa age-nalata, isiik bogobe-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Kaya. Tuumon umaak kafalepnelipta o,” agela e, tuumon maak ku kafalebelip e, bogopma, “Yak tuumon diim sinik so win so kwep yak daasip boyo waami sinik so win so albu o?” agela e, igil bogopmip, “Boyo Sisa imi sinik so win so o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yesus iyo bogopma, “Kanubelu kale, tuumon kanupmin boyo Rom kasel imi King Sisa ilami tuumon kale, ibo Rom kasel imi gavman ilami kupka-e-bom-nilip e minte, God imi mufekmufek ugol mungkup God imi kupka-e-bom no kemin o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kale bilip iyo Yesus tebe imi weng yan kebela boyo tinangku kumang mo-nilip e, iyo utamipta, unang tinum kalip imi tiin diim uyo nuyo tala-eman-temup kuta, nuta nuta ke-numup binim kalaa age-nilipta, weng uyo kupkaa sining agelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Juda kasel imi kamogimal iip maak maak bilip iyo Sadusi o agan-nuubip kale, bilip iyo bogo-nilip e, “Unang tinum kaansip iyo asok fen tigi molan-temaalip o,” agan-nuubip kale, Sadusi iip maak maak iyo, (no Yesus iyo bong faga-bom yan kemin weng umaak dagalupta, unang tinum iyo utamipta, umi magam uyo tele dupkop daalin-tem kela kalaa age-nilipta, aban faga-emin o age-nilipta,) tal bogobe-nilip e, ");
INSERT INTO tlf_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Kafalemin tinum kabaa. Sugayok uyo Moses iyo God imi ulo uyo dola ko-nalata, numi kobesa kale, atuk uyo bogo-nulu, ‘Kanube fik iyo man umaak fogolin-tem som-nala kalel uyo kupkaa kaana umdii, imi niing yagal tebe fik imi kaluun uyo kula agam imi man fagaman-temip uyo, beyo bogobe-nala e, “Ibo nimi baap imi man o,” age-nalata, siin fik kaan-se imi mufekmufek uyo man bilip imi kuga-emin o,’ agesu kale, ");
INSERT INTO tlf_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","uyo tinangku-salapta. Siin uyo tinum maak man tinum ninggil ilimi kup ban kal kale, ninggil maagup te tam fito-nilip e, tam fik diil isiik unang maak ku-siit man umaak fogolin-tem ke kaana e minte, ");
INSERT INTO tlf_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ilami aafuu dep tilin ita tebe-nala e, fik imi kaluun boyo kula kuta, yagal asok man umaak fogolin-tem ke kaana e, ");
INSERT INTO tlf_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","niing iip maak yagal mungkup kanube no kela e, mungkup imi nagalal ninggil kutop igil mungkup figal imi kaluun boyo ku-nilip e, alugum maagup maagup iyo man umaak fogolin-tem ke-nilip e, kaana kaana kelip e minte, ");
INSERT INTO tlf_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","unang uta minte umik tem kaan no ke-suu ko. ");
INSERT INTO tlf_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kale tinum ban kal bilip iyo unang maagup bota kup maak isiik ku-siit kupkaa kaana kaana kem top ninggil ban kal kano biniman-silip kale, son-temu nala tinum ninggil ko kaan-silip bilip imi asok fen tigi molan-temip uyo, unang boyo waami kalel kelan-temu a? Kapmi aget fugun-balap uyo bogobelapta, utamum o,” agelip e minte, ");
INSERT INTO tlf_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesus isiik bogopma, “Kamano kafin diim kaa albip kota, tinum tebe unang dula-bilip e, unang tebe tinum dula-bilip no kem-nuubip kuta minte, ");
INSERT INTO tlf_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","am afungen daanan-temu uyo, God iyo unang tinum iip maak maak ita kup bogobe-nala e, ‘Kaansip ibo felepmuta, asok fen tam nimi abiip uyo suun nan-temip o,’ agelan-tema kale, bilip imi fen no kutam kal nan-temip uyo, unang dula-bom tinum dula-bom keman-temaalip kale, ");
INSERT INTO tlf_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","bilip iyo asok maak so kaanan-temaalip kale, bilip iyo fen God imi man aligaap ke-nilipta, ensel ilitap ke suun nan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Kale minte ipmi weng (bogo-nilip, ‘Unang tinum kaansip iyo kaan atin binimansip kale, God iyo tebe maak ifola fen tigi molan-temaalip o,’ agan-nuubip) bomi sang uyo bogobelan o ageta kale, nimi weng uta kup ba kale, Moses imi weng so uyo kafalebeluta, utamupta, unang tinum kaansip iyo asok fen tigi molan-temip kalaa agelan-temup ko. Kale Moses beyo at katip molin maak ken tebe binimanin-tem kesa imi sang uta bagan tolom-nala e, bogola, ‘God beyo Abraham so ilami man Aisak so ilami man ilop Jekop so ulimal imi God o,’ age sugamiyok tinum kaansip imi sang bogosa kuta, ");
INSERT INTO tlf_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","God iyo tinum kaan atin binimansip imi tiin mosaala kale, tinum kaan-nilip no God imi diim suun nuubip sino tinum kafan albip sino ita tiin mosa (kale mungkup, God imi weng ko Moses imi bogobesa bomi magam uyo dok uta ba kale, Abraham ulimal bilip iyo sugayok uyo kaansip kuta, fen God imi tiin diim uyo atin albip kalaa age-nalata, ulimal iyo tiin mo-bom-nalata, bogo-nala e, ‘Niyo ulimal imi God iyo kalbi o,’ agesa) o,” age Yesus iyo Sadusi imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kale ulo utamsip tinum iyo Yesus imi weng ko Sadusi bogopma uta tinangku-nilip e, iip maak maak ita bogobelip, “Kafalemin tinum kabaa. Kabo Sadusi imi weng uyo tambaliim kup yan kebelap o,” agelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kale kota alugum kamogimal iyo utamipta e, Yesus keyo tele dagaa kusa tinum kalaa age-nilip e, imi atul uta finano maak so daga-nimip binim ke kwep unip ko. ");
INSERT INTO tlf_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Kuta Yesus ita kamogimal iyo daga-nala e, “Ulo utamsip tinum bilip iyo bogo-nilip, ‘God imi ulaa dula kamok kesa tinum beyo King Devit imi man ilop tiilam unsu kutop umi tinum o,’ agan-nuubip kale, intaben o age-nilipta, boyo bagan-nuubip a? ");
INSERT INTO tlf_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","God imi suuk kon tem umi ulotu aseng kwek uyo Devit yagal bogo-nala, ‘Bisel God iyo tebe nimi Kamogim imi bogobe-nala, “Kabaa. Te yang nalami ipkuk ilo kamogim imi baan diim kagal ton-balapta bii, ");
INSERT INTO tlf_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","atin ki nita nita ke-nili kapmi waasi iyo kubaganip imkali kalaa age-nalapta, kapta iyo tiin molan-temap o,” age God iyo bogobesa o,’ age Devit iyo bogosa ko. ");
INSERT INTO tlf_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Kale God imi ulaa dula kamok kesa tinum beyo dok imi man a? Kanube Devit imi aget fugunolata, son-temu uyo, beyo nalami man ilop kutop ita maak mitam tebelan-tema kalaa age-nala bomi aget uta kup fuguno-nala bogosa nimnam, boyo bogo-nala, ‘Beyo nimi Kamogim o,’ agesaala binim kuta, Devit iyo intaben umi aget uta fuguno no ke-nalata, bogo-nala, ‘Beyo nimi Kamogim o,’ agesa o?” age Yesus iyo kamogimal imi dagagama ko. ");
INSERT INTO tlf_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Unang tinum iyo alugum kugol bom Yesus imi weng uyo tolong duga-bilip e, fupkela ilami okumop man imi bogobe-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ibaa. Ibo ulo utamsip tinum bilip iyo tele itama-bom-nilipta. Bilip imi aget fugunin uyo, ilim timitim kup migi-bii tam abe tiine-bulupta, unang tinum iyo, numi itamamin o age-nilipta, kanum tiine-bom-nilip e minte, iyo no iman saanin baan diim unon-temip uyo, unang tinum iyo tal numi weng umka-emin o ageta unang tinum imi tiin diim ku-tele tiine-bom-nilip e minte, iyo no ulotu am aa-e min, iman tigi-bom unan-kalin am aa-e min ko unon-temip uyo, abiin tambal ugaa ku tonupta, unang tinum iyo itamamin o agan-bom-nilipta, tona-bom no kem-nuubip ko. ");
INSERT INTO tlf_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Kale ulo utamsip tinum bilip iyo unang kaluun iyo filto-em tolom-nilip e, imi sinamin am uyo bugubelip kupkaa am binim, mufekmufek binim ke-bom no kem-nuubip ko. Kale kanupmin kuguup mafak mafak boyo kanu-bilip kuta, iyo unang tinum imi tiin diim uta God imi aman duga-emin uyo timitim kemup ko age bisop kugol baga-bom no ke-em-nuubip kale, ibo bilip iyo itama-bom-nilipta o ageta ko. Boyo kuguup mafak kem-nuubip kale, son-temu nala God imi tebe kaal fuyap bilip imi kupka-eman-tema uyo, kwiin kiim kupka-eman-tema o,” age Yesus iyo ulo utamsip tinum imi sang uta okumop man imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesus iyo ulotu am miton kutam kal ton-bom-nala e, unang tinum, tuumon God imi kopmum o age-nilip kulep tal tet kiim tem abu-bilip uyo dagak diibe-bomta e, mufekmufek so kasel isiik tuumon uyo kulep tal tet tem abula abula ke-bilip kalaa agan-bomta, ");
INSERT INTO tlf_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","kek fenata e, unang kaluun mufekmufek binim maak tal tuumon ken tibin alop maak dulep tal tet tem abulu kalaa age-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","okumop man imi bogopma, “Ibo unang kaluun boyo utamip a? Unang tinum migik bilip iyo mufekmufek kwiin tagang so kale, ilimi tuumon atuk katip ita kup dulep tal God imi kuga-e-bilip kale minte, unang kaluun bota mufekmufek binim minte, umi tuumon katip iman saan-bom unan-kalin ita kale, ko alugum ditang age dulep tal God imi dobelu kale, niyo dam weng bogobelan-temi kale, ibo tinangku-silipta. God imi tiin diim uyo unang kaluun mufekmufek binim bomi kuguup uyo uta uta keluta minte, unang tinum migik imi kuguup uta kubaganu o,” age Yesus iyo bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kale Yesus imi okumop man iip maak maak iyo ulotu am miton umi sang bogo-nilip e, “Bilip iyo tuum tambal kobe som, minte ket kon ko age am umi diimin mufekmufek tambal kobe no ke-nilip e, bota kulu God imi am uyo telela kolip kasagansu o,” agan-kalip e, ");
INSERT INTO tlf_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Yesus iyo bogobe-nala e, “Am uyo mep so tulu e, waasi iyo tal mufekmufek tambal kamano komi utaman-bilip boyo alugum kufak daa-nilip e, am uyo alugum kano dalata ko-nilip e, tuum tambal tip tip ke daam fogosip uyo segela kululip daak abe-bulu bii, biniman ugulumi kup nu nu kelan-temu o,” age Yesus iyo bogopma ko. ");
INSERT INTO tlf_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Kale Yesus imi okumop man iyo dagalip, “Numi kafalemin kabaa. Dogap kota waasi iyo tal-nilipta, ulotu am miton boyo dalata kolan-temip a? Minte dogonupmin umi kuguup usiik mitam tuluta, utamupta e, kuguup mafak uyo ko mitam tolon o angbu kalaa agon-temup o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesus iyo ilami asok tolon-tema umi sang uta bogobe-nala e, “Tele utama-bom-nilipta. Bisop weng baga-emin tinum bilip imi weng uyo tinangkamin ba ko. Tinum kwiin tagang iyo tal nimi win uta dugola kufu-bom-nilip e, tinum iip maak maak iyo tal buguna buguna ke-bom-nilip e, ‘Niyo God imi ulaa nimdula kamok kesi tinum o,’ agela agela ke-bilip e minte, tinum iip maak maak ita bogobe-nilip e, ‘Am afungen tem uyo tulu kale, God imi ulaa dula kamok kesa tinum iyo tolon o angba o,’ agan-bom no keman-temip kuta, ibo bilip imi weng boyo, ‘Fen o,’ age tinangkamin ba ko. ");
INSERT INTO tlf_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kale ibo tolong dolipta, tinum miit maak iyo fiko kulep no daala miit maak so waasi dinan-bala e minte, am waasi uyo ugaa kulu dinan-bala no ke-bilip uyo mitam senganu kalaa agelan-temip uyo, ibo boyo, ‘Afungen tem mitam tulu o,’ age-nilip bomi atul uyo finanin ba ko. Kamaki uyo kanupmin kuguup bosiik mitam tolon-temu kuta, boyo kanum ti-suluta, kutam-tele am afungen uyo yuut mitam tolon-temaalu ko. ");
INSERT INTO tlf_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","“Kafin maak umi tinum iyo tebe kafin migik tinum sino dinan-bilip e minte, kamok maak imi tinum igil kamok migik imi tinum isino dinan-bilip no e minte, ");
INSERT INTO tlf_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","kafin kaa kutufosu koyo bim afalik mitam tele-bulu e minte, iman tebok sino mafak ilinok am so uyo daanan tele-bulu no ke-bulu e minte, mufekmufek ugulumi migik utamamin binim uyo abiil tigiin ilota malaak tuluta, unang tinum iyo kanupmin kuguup bomi alugum utaman-temip uyo atin finan-bilip no keman-temip o,” age Yesus iyo bogobe-nala e minte, ");
INSERT INTO tlf_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","tam maak uyo waasi imi tal ulotu am miton dalata kolan-temip umi sang uyo bogobe-nala e, “Kanupmin kuguup bo mitam tolon-temu kuta, boyo mitam tilin-tem bom-suluta, kek kek iyo tebe, ibo Yesus imi okumop man kalaa age-nilipta, yaafuu kuguup mafak uyo kupka-e-bom imdalip no Juda kasel kamogimal imi sagaal diim abelipta, ita ulotu am kal yege-bom imdalip tam kalabus am unon-temip min, kulep no Rom kasel imi kiyabal so kamogimal king so bilip imi diim daalip e, ita im-kugu-bom yegeman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kale bomi kanuman-temu kwek uyo, ibo utamipta, God imi weng umi ilep uyo kulbu kalaa age-nilipta, unang tinum iyo nimi sang umdii baga-eman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ibo, mep so imdep no weng telelmin tinum imi diim daalum o agan-bilip kota, ibo aget yamyam fugun-bom, ‘Ko so kube. Weng kwep mek numi tem tililan-temip uyo, dogonupmin weng uta yan kepman-temup o?’ agan-kalin ba kale, bilili age-bomta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Bomi am daanan-temu uyo, ipkil weng bagaman-temaalip kale, ipmi weng bagaman-temip boyo, nagal aget fugunin tambal kobe-nili e, weng tambal bagaman-temip uyo kafalepmita, waasi imi weng uyo kubaganuta, ipmi weng bagaman-temip uta uta keluta, imi weng uyo ilubelan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Minte ilipmi amalabal min, figal min, nagalal min, duup-afin min God imi ilak dolin binim bilip ita ibo imkem daa imdalip no kamogimal bilip imi sagaal diim abelipta, kamogimal ilimi waasi dinan-kalin tinum bogobelip iip maak maak ibo inolip kaanan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kale ibo nimi ilak uyo duga-bom nimi ogok ke-bilip kalaa age-nilipta, unang tinum kwiin tagang iyo tebe ibo olsak kupka-e-bom itafinonan-temip kuta, ");
INSERT INTO tlf_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","nimi ilak uyo fomtuup duga-bilip bii, kaanip umdii, God yagal ibo tambaliim kup tiin mom-nuuba kale, kaan maagalo kelan-temaalip binim kale, ibo imtamo tam ilami abiip daalata, suun kup nan-temip o,” age Yesus iyo weng kem uyo bag-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yesus iyo weng maak uyo bogobe-nala e, “Son-temu uyo, ibo utamipta e, waasi dinan-kalin tinum iyo tal abiip miton Jerusalam uyo falala kolip kalaa agelan-temip uyo, kota utamipta, abiip uyo kufak daalip yuut binimanan-temu kalaa agon-temip kale, ");
INSERT INTO tlf_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","kota waasi bilip iyo imkaa bilii unin o ageta kale, ibo Provins Yuudiya kagal albip umdii, ipmi abiip uyo kupkaa bilii daage no amdu tem tem kal waanamin o ageta kale minte, ibo abiip miton Jerusalam kal albip umdii, yuut kupkaa bilii daage no waanamin ko. Minte ibo ilipmi ilanggiip kal albip umdii, asok abiip unemin ba kale, yuut kupkaa yang waanamin ko. ");
INSERT INTO tlf_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Sugayok uyo God imi suuk kon tem weng uyo dola ko-nilip e, God imi Jerusalam kasel imi yuum yan kebe kaal fuyap kupka-eman-tema umi sang uyo bogosip kale, waasi imi tolon-temip kota, weng ko bogosip boyo mitam tol kelan-temu ko. ");
INSERT INTO tlf_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Bomi mitam tolon-temu kota, God iyo olsak kobe-nalata, Yuudiya kasel iyo kaal fuyap uyo kobe-nala e minte, kuguup mafak mafak uyo bilip imi kobe no kelan-tema ko. Minte unang kumun so so e minte unang manok so bilip iyo bilii unon-temip umi ilep uyo bong faga-bom-nilip e minte, kaal fuyap kiim kwaa-bom no keman-temip kale, niyo bilip iyo i-filin-bii ko. ");
INSERT INTO tlf_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Tinum waasi iyo tebe Yuudiya kasel iip maak maak iyo benat ko age un kong umi tuup inolip kaanip e minte, iip maak maak ita yaafuu sok de imo-nilip e, imdep unanbu no anang migik to yakyak ke-nilip e, waasi igil ilimi anang uyo kupkaa tal abiip Jerusalam uyo tiin mo-bom-nilip e, kufak daga-bilip biita, God imi imdala ilimi anang unon-temip umi am uyo tulu kalaa age-nalata, asok imdala daaginon-temip o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Asok Yesus iyo weng migik maak bogobe-nala e, “Afungen tem mitam tolon-temu uyo, atanim so kayop so biningok so iyo igilimi migik kelan-temip kale, kafin diim koyo yol ok umi daang kun uyo aliin aliin ke-bii kwiin kiim ke-nulu e, ku sek mo yak ok kan tem abe biileng afek unan-bii yakyak keman-temu ko.Kale alugum tinum miit maak maak iyo bomi utaman-temip uyo, finanin kiim uyo ke-bom-nilip e, aget iluum tebepman-temu ko. ");
INSERT INTO tlf_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Abiil tigiin umi mufekmufek iyo ilimi ilep uyo kupkaa sigin-bii ilep migik ilep tiine-bala tiine-bala keman-temip kale, unang tinum iyo itamipta, kanu-bilip kalaa age-nilip e, abiin uyo tele tonan-temaalip e minte, finanin afalik uyo ke-bom-nilip e, bogolip, ‘Kwiin ee. Kafin diim koyo dogonupmin kuguup mafak uyo tal, numi diim abelan o agan-bo o?’ agelan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kale bilip imi ilep migik ilep te yang iinon-temip kota, Mo Tibil imi Man niyo iip tem ku-tele talanbu talan-bilita, alugum unang tinum iyo kiit fen nitamipta, titil kiim uyo ku imi dong uyo tiin bulusii kup sigin-bii talan-be kalaa age nitaman-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kale ibo utamipta, kanupmin kuguup uyo tulu kalaa age-nilipta, kota utamipta, niyo yuut ipmi ilim bo-eman-temi kalaa age-nilipta, ipmi aget iluum taban-bilip uyo kugol diliit ke-nilipta, ipmi aget uyo titil fagaa mo kiit fen-nilip e, nimi ilep uyo tiin daga-bom fenipta, tolon o,” age Yesus iyo deng tebemin weng uyo kupka-e-bom baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","Yesus iyo do weng maak bogobela, “Ibo yet so at migik so umi kuguup uyo utamipta, umi kon bam daa kalunganu umdii, boyo umi dum abumin uyo mep so tulu kalaa agelan-temip kale, ");
INSERT INTO tlf_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ulutap mungkup utamipta, nimi kuguup kanum tolon-temu umi sang baga-em tebesi uyo mitam tulu kalaa agelan-temip uyo, kota ibo utamipta e, God imi nimdala tal unang tinum alugum tiin molan-temi umi am uyo mep so tulu kalaa agelan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Nimi weng bogobelan-temi koyo tinangku-silipta.Unang tinum iip maak maak kamano tiin kafan albip iyo kaanin-tem bom-silipta, nimi weng bogobe-nili, ‘Son-temu uyo, mufekmufek mafak mafak uyo mitam Juda kasel imi diim abelan-temu o,’ agebi uyo mitam tolon-temu ko. ");
INSERT INTO tlf_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Am maak daanan-temu kota, abiil so kafin so uyo binimanan-temu kuta minte, nimi weng uyo biiluta, maak binimanan-temaalu binim kale, suun kup bomta tuluun nan-temu o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Kota Yesus iyo bogopma, “Nimi duubal ibo utama-bom-nilipta a. Unang tinum kwiin tagang iyo iman yam fagalu o age iman suun kup unan-bom-nilip e, ok mafak uyo unan-bom ilum ilum ke-bom-nilip e minte, kafin diim komi mufekmufek umi aget iluum uyo tebe-e-bom no keman-temu kale, ibo kanupmin mufekmufek bomi aget uyo ugaa kwaagamin ba ko. Kale God imi afungen am uyo abil fola fiko kolin kebu ulutap kale, alugum unang tinum kafin kaa kutufosu albip iyo ilum ilum kem-silip e, maak fagaa dagaa kopmu e, ogen utaman-temip kale, ibo tele utama-bom-nilipta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ibo suun kup nimi tolon-temi uyo utama-bom fen-bilipta a. Minte fen-bom-nilip e, suun kup God iyo beten ke-bom dagaga-bilipta, God yagal titil uyo kupka-e-balata, kuguup mafak tal ipmi diim abelan-temu uyo, ipmi aget fugunin uyo kufak daapman-temaalu kale, suun titil faga-bom-bilipta bii, afungen tem tolon-temu kota, finanin binim, Mo Tibil imi Man nimi diim kal molan-temip o,” age Yesus iyo weng kem baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesus imi Jerusalam kal bom-nala uyo, am daanin diim uta ulotu am miton kutam kal mo-bom God imi weng uyo unang tinum imi kafale-bom-nala e minte, mililep uta daak abe tam Oliv Tigiin kal bom beten ke-bom no ke-balata minte, ");
INSERT INTO tlf_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","unang tinum kwiin tagang iyo no tamup, ulotu am miton kal Yesus imi weng uyo baga-e-bala tinangkamum o age-nilipta, kutim uyo suun kup tal tal kem-nuubip ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Bret fitimin binim fuu unan-kalin am umi win uyo, “Pasova o,” agan-nuubip kale, am boyo mep so tulu e, ");
INSERT INTO tlf_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","tinum amem ko age pris imi kamogimal isino ulo utamsip tinum so iyo tegen-bom, kanubeta Yesus iyo angkolup kaanak o agan-bilip kuta, unang tinum kwiin tagang iyo Jerusalam katam uyo tala tala ke-bilip kalaa age-nilipta, “Buuk o age-nilip e, tebe nuyo yan-togon-bom ye-bom kem-nimip o,” age finano kupka-nilipta, bantap umi ilep uta fen-bilip ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kale abiip Keriot kayaak Judas iyo okumop man tuluun kal ninggil imi ogok maagup kemin tinum kale, Saatan iyo tal Judas imi diim abe-nala e, imi aget fugunin uyo kufak daabelata, ");
INSERT INTO tlf_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","utamata e, kamogimal iyo kanubelum o agan-bilip kalaa age-nala e, no tama e, tinum amem ko age pris imi kamogimal isino ulotu am miton umi un tubulin kamogimal isino imi bogobe-nala e, “Niyo Yesus daali yak ipmi sagaal diim abelan-tema umi ilep uta fen-bii o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","tolong do-nilip e, deng kup tebe-bom bogobe-nilip e, “Tisol umi weng umaak telela ko kulep kutop kelup suukta, kop-kamum o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas iyo imi weng uyo tolong do, “O,” age-nala e, suukta, utamita, unang tinum kwiin tagang iyo tiin kubalip kalaa age-nilita, kota Yesus iyo bantap daali yak kamogimal imi sagaal diim abelak o age ilep fena ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kale bret fitimin binim unan-kalin umi am ko age ifin am uyo daanu e, Juda kasel imi kuguup uyo ku-nilip e, Pasova umi sipsip man uyo ano fuu-bom unan-nuubip kale, ");
INSERT INTO tlf_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","kota asok bomi am uyo daanu e, Yesus iyo Fita so Jon so imi bogobe-nala e, “Alop ibo no-nilip Pasova unan-kalin umi mufekmufek uyo telela kupkamipta, no tulupta, unan-kulum o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","iyo bogopmip, “Nota am uyo dogap kal bomta, mufekmufek uyo telelaman-temup o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","bogopma, “Niyo bomi weng uyo bogopman-temi kale, tinangku-silipta. Alop ibo no Jerusalam kutam iinipta, ogok kemin tinum maak tal abu daalan-tema kale, atamipta, beyo unang umi kuguup uyo ku-nalata, oget afalik tol umi ku telela kosip uyo ok ilu ko kwep tam dubom diim daa kwep talan-be kalaa age-nilipta, imi umik bagalip no am iinon-tema uyo, ipso iso tam am tam-nilip e, ");
INSERT INTO tlf_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","am kayaak iyo kutam kal alba kale, bogobe-nilip kano, ‘Numi kafalemin tinum iyo weng maak kopkela kupke tulup kale, iyo bogopke-nala, “Kapmi am komi atuk koyo kuun kale, kopmapta, nimi okumop man isino e minte nisino nuyo kagal numi Pasova uyo unelum o,” agelata, tulup o,’ age bogobelipta a. ");
INSERT INTO tlf_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Minte am kayaak iyo ipmi weng uyo tolong do-nala e, imtamo tam am dong tem daa am atuk afaligen uyo kafalebelata, utamipta e, iman fuumin umi mufekmufek alugum uyo kutam kal albu kalaa age-nilip e, kutam kal unan-kalin uyo telelamipta o,” age-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","imdala no abomu, Yesus imi bogopma tulup uyo alugum mungkup tol kanubelu kalaa age-nilip e, Pasova umi unan-kalin uyo kugol telela-bom fuumip ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Atanim uyo tem iinu e, Yesus iyo ilami kalaan tinum so tal Jerusalam am ugaa kubip kal ton-bom iman unan-bom-nilip e, ");
INSERT INTO tlf_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","kota ilami okumop man iyo bogopma, “Nimi aget kiim fugun-nak-bii uyo, kaal fuyap uyo ku kaanin-tem som-nilita, niyo ipsino iman ko age Pasova koyo une som-nilita o agan-nak-bii kale, ");
INSERT INTO tlf_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","nimi weng bogobelan-temi koyo tinangku-silipta. Kamano koyo niyo ipsino Pasova uyo afung afung unan-bii kale, kafin diim kagal maak so unelan-temaali kale, kupkaa bom-bili bii, son-temu nala nimi Aatum God imi alugum tiin molan-tema uyo, Pasova umi magam uyo tol kup kemanan-temu kota, asok Pasova uyo unelan-temi o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kale Yesus iyo sok dum ok uyo ilu ko-nala e, God iyo, “Misam o,” age-nala e, ilami okumop man kobe bogobela, “Sok dum ok koyo ku-nilip e, maak kapsiik une-nalap e, kapkum iyo kopmap unela unela kelin o,” agela unelip e, ");
INSERT INTO tlf_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","bogobe-nala e, “Ibo tinangku-silipta. Kamano koyo niyo sok dum ok boyo maak so unelan-temaali kale, kupkaa bom-bili bii, God imi alugum unang tinum tiin molan-tema uyo mitam tulu kalaa age-nilita, kota asok unelan-temi o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Minte bret maagup maak ku-nala e, God iyo, “Misam o,” age kupkaa fegela ko ilami okumop man iyo ife-bom-nala e, bogopma, “Bret koyo nimi dam kale, ipmi ilim uta bobelan o age-nilita, nimi dam uyo kobelan-temi kale, mungkup bret kobelan-temi koyo ku unelin a. Kale son-temu uyo, asok bret mungkup unan-kalon-temip uyo, asok nimi dam bomi aget uta fugun-bomta unan-kalin o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ulutap kale, Pasova umi iman uyo unelip binimanu e, Yesus iyo sok dum ok maak ilu kola uyo kobe-nala e, bogopma, “Sok dum ok koyo nimi isak kale, nimi nangkalip kaani nimi isak malaak abelan-temu uyo, ibo utamipta e, ipmi ilim uta bobelan o ageta nimi isak uyo kupkali singkam daalu kalaa age-nilip e minte, God imi weng kwep daasa uyo fen abulu kalaa agon-temip o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Weng boyo kam age kupka-nala e, weng migik maak bogobela, “Nugumal ibo tinangku-silipta. Tinum maak nimkem daa nimdala yak waasi imi sagaal diim abon-temi iyo nisino kagal ton-bom iman unan-be kalba kale, ");
INSERT INTO tlf_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","sugamiyok uyo God imi aget fugunin uyo, ‘Nimi Man daali unon-tema iyo kanube kaanan-tema o,’ agesa kuta, tinum maak dogap ita Mo Tibil imi Man nimkem daalan-tema beta ki atin kaal fuyap kup misamanan-tema o,” age Yesus iyo bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yesus imi okumop man iyo tolong do-nilip e, ninggil iyo bubul iluum tebepmu e, dagana tala ke-bom-nilip e, bogolip, “Ninggil numi iibak tem katam iyo dok ita dupkem daalan-tema o?” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yesus imi okumop man iyo wengaal digin una tala ke-bom bogo-nilip e, “Numi tinum iyo dogap ita dubom kelan-tema o?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesus iyo bogobela, “Ibaa. Kafin diim komi God imi ilak dolin binim unang tinum imi kamogimal iyo unang tinum iyo alaang weng uyo kupka-e-bom-nilip e minte, ilimi aget fugunin uyo, unang tinum ita numi tok bagamin o age-nilipta, bisop bogo-nilip e, ‘Nuyo unang tinum ipmi dong daga-emin tinum o,’ agan-nuubip kuta minte, ");
INSERT INTO tlf_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","nimi ilak dolin ibo imi kuguup ko kanum-nuubip boyo ipsiik dagaa ku kanumin ba kale, dogap kapta te tam kapkumal imi dubom kelap umdii, kabo, ‘Nita kup o,’ age-nalapta, kapkumal iyo alaang weng kupka-emin ba kale, imi niing ilatap ke-nalapta, kapkumal iyo ati-e-bomta tambaliim kup tiin molan-temap uta felep-kaman-temu e minte, kabo te tam kapkumal imi kamok kelap uyo, bisop tonamin ba no kale, kapkumal imi bon tem kiit fenin tinum ke-nalapta, dong daga-e-bom-nalapta o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kale taabalasebal sino ilimi ogok kemin tinum so imi kuguup uyo ibo utamsip kale, ton-bom ole-bala iman kulep tal to-e-bala unan-be beta taabala bele minte, iman ifo kulube tal to-be beta taabala a? Iyo? Ton-bom iman unan-be beta taabala kuba. Kuta niyo ipsino bom-nili uyo, kanupmin kuguup boyo maak kanum-nuubaali kale, niyo ogok kemin tinum ke-nilita, dong daga-em-nuubi ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Kuguup mafak mitam nimi diim aban-nuubu uyo, ibo nimkasaalip binim kale, ibo suun kup nimi diim uyo febam tebesip kale, ");
INSERT INTO tlf_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","bota nimi Aatum God imi kanupnesa ulutap ke-nilita, nagal ibo mungkup kanubelan-temi ko. God iyo ulaa nimdu imi titil uyo kopnesa kale, imi win tolop diim unang tinum iyo tiin molan-temi kale, ulutap mungkup, son-temu uyo, ibo no nimi abiip kugol nisino ton-bom iman unan-bilipta, ulaa imdu nimi titil uyo kobelita, nimi win tolop diim Israel imi man ilop imi miit tuluun kal kalip iyo ipkil tebe miit maagup ku tiin mola tiin mola keman-temip o,” age Yesus iyo ilami okumop man iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Kota Yesus iyo tebe Fita iyo bogobe-nala e, “Nugum Saimon kabaa. Tinangku-salapta. Saatan iyo alugum ibo im-kugulata, Yesus imi tinum kalaa, nalami tinum kalaa agon o age-nalata, God iyo dagalata, ‘O,’ agela kale, tinum maak rais ko age wiit uyo kwaala iit o daak o ke-bulu e, kaal uyo tegep yak iinom dam uta kup kutulu daak ilaat diim abelu ulutap kale, Saatan iyo imdala iit o malaak o ke-bom kaal fuyap uyo kupka-eman-tema ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kuta niyo Aatum God imi beten ke-e-bom-nili e, bogobeli, ‘Aatum kabaa. Saimon iyo bogopne-nala, “Niyo atamsaali o,” nagelan-tema kale, kanupman-tema uyo, dong dogobelapta, imi kuguup mafak boyo tebe-nulu bemi nimi ilak dugamin boyo kufak daga-emin ba o,’ agan-bomta beten kem-nak-bii kale, suukta, kabo maak so aget fupkela ko-nalap kapmi aget fugunin uyo bam daapkelan-temu kota, kabo kapmi kapkumal iyo dong daga-e-balapta, imi aget fugunin uyo bam daabeluta, titil fagalan-temip o,” age-nalata, Yesus iyo Fita imi baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Kale Fita isiik bogobela, “Kamogim kabaa. Niyo kapsino imtamo no kalabus am daa-nimip kuta, kapmi diim kal feba-nimi minte, kapsino ino-nimip kuta, nagal kapmi diim kal feba-nimi kwa,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesus iyo Fita imi bogopma, “Fita kabe. Niyo tuluun weng bogopkelan-temi kale, tinangku-salapta. Kutim mililep kota uun kakaluk aalap iyo olalin-tem bom-salata, kabo nimi sang uyo bogopne-nalap e, ‘Beyo atamsaali o,’ nage yakyak bii, ilep asuno fagalan-temap o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kota Yesus iyo ilami okumop man dagala, “Siin uyo bogobe-nili e, ‘Ibo tuumon so iman men so minte yaan ilom so uyo kulep-nilipta, nimi ogok uyo kem tiinemin ba o,’ age imdali tiinan-bilip uyo, ibo mufekmufek umaak duumatanbip bele ki?” agela e, bogobelip, “E-e, mufekmufek umaak duumatanin-tem o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesus iyo bogopma, “Kamano komi tonbup uyo ugulumi migik kale, tuumon min, iman men min uyo albu umdii, kulep-nilip e minte, benat ko age un kong uyo binim umdii, ilipmi saket uyo delep no tolip tinum migik iyo tebe molipta, umi tuumon uta kulu-nilipta, benat uyo mo kulep bom-nilipta, tiinemin o ageta ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ibo nimi weng koyo tinangku-silipta. God imi suuk kon tem weng uyo bogo-nulu e, ‘Bilip iyo kuguup mafak uyo un tubulin imi tebe fuut tibin imi kupka-em-nuubip ulutap ke tinum begal mungkup kobelip o,’ agesu boyo nimi sang uta bogosu kale, alugum God imi suuk kon tem nimi sang bogosu uyo mep tol mitam tolon o angbu kale, kanupmin kuguup mafak boyo mep kupkaneman-temip o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ilami okumop man iyo tolong do-nilip e, bogopmip, “Kamogim kabo kotamal a. Benat alop kalbu o,” agelip e, Yesus iyo utamata e, okumop man iyo kuguup mafak mek nimi kaal diim mep tolon-temu uyo tele utamin-tem ke amon amon weng bagamip kalaa age-nala e, bogobela, “Tii bogolip kale, binimanu o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesus iyo no Oliv Tigiin kal suun God iyo aman duga-em-nuuba kale, bomi mililep kota ilami kuguup kanum-nuuba bota ku-nala e, ilami okumop man iyo fola kulep abiip Jerusalam uyo kupkaa Oliv Tigiin una ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kale ninggil tam-nilip e, bogopma, “Kuguup mafak uyo, im-kugulan o age yuut tal ipmi diim abelan-temu kale, ibo God iyo aman duga-e-bom-nilipta, dagaga-bilip dong daga-e-balata, fengmin boyo tal ibo uk kugan imoluk o,” age-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ilami okumop man iyo kugol tonip imkaa mep ko yang unom katuun duung fegela daak ton God iyo aman duga-e-bom ");
INSERT INTO tlf_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","bogobela, “Aatum kabaa. Kuguup mafak uyo meng, nafak daalan o angbu kale, kabo, fegelebeli dupkaluk o nagelap uyo, fegelebelapta, nimkaluk o agan-bii kuta, fen nimi aget fugunin uyo, kabo nimi aget fugun-bom, ‘Bota kanupnelal o,’ agan-bii boga ba kale, kalapmi aget fugun-bom, bota kanubelan-temi kalaa agan-balap uta kup kanumin o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kale kam agela e, ensel iyo malaak abe Yesus iyo dong daga-emin weng uyo kupka-e-bala e, ");
INSERT INTO tlf_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesus iyo aget iluum ku-bom asok God iyo aman duga-e-balata, ifak afaligen uyo fuu dolu kuta, ifak boyo isak ulutap ugaa kumen malaak kafin diim abe yakyak kemu ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Beten kem abe-bala binimanu e, fen mo daage no abomu, ilami okumop man iyo aget iluum tebebe daal tebepmu agaal unbip kalaa age-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","bogopma, “Ibaa. Ibo agaal unbip aga? Saatan iyo, ibo uget taga-bilita, yang fenga kolip kalaa agelan o age-nalata, ibo im-kugu-be kale, fen-bom God iyo dagaga-bilipta, dong daga-e-balata o,” age Yesus iyo bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesus iyo weng baga-em-sala e, tinum kwiin tagang iyo tilip kale, Yesus ilami okumop man iyo tuluun kal kale, tuluun Judas ita Yesus imi baan diim alba uyo ilep kafal kelata, tal-nilipta, Judas iyo tal, Yesus iyo duptal migilan o age tal mep so talata, ");
INSERT INTO tlf_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yesus iyo bogopma, “Nugum Judas kabaa. Kabo talta, Mo Tibil imi Man niyo duptal migim tolom-nilita, dupkem daa daali yak waasi imi sagaal diim abelak o age-nalapta, talta nimtal migilan-temap aga o?” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yesus imi okumop man iso albip iyo itamipta e, tinum iyo, Yesus iyo aafulum o agan talbip kalaa age-nilip e, Yesus iyo bogopmip, “Kamogim kabaa. Nugol numi benat ko age un kong umaak kuluta ino-numup bele ki?” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","tinum amem imi kamok miton ko age hetpris imi ogok ke-emin tinum maak iyo iso tala kale, okumop man maak tebe ilami benat uyo kupdeta tinum beyo angko imi tuluun kaal ipkuk uyo tagaa kwaabela daak abelu e, ");
INSERT INTO tlf_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yesus iyo utam-nala e, okumop man iyo yege-bom bogopma, “Bo kanumin ba o,” age-nala e, yak tinum bemi tuluun kaal uyo waafu-nala e, asok kwep yak kwek kabilepma tambalanepmu ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","53","Kale tinum amem ko age pris imi kamogimal so ulotu am miton umi un tubulin kamogimal so minte tinum kamok kamok so alugum bilip iyo tal, Yesus aafulum o age-nilip e, tal kugol molip e, Yesus iyo bogopma, “Niyo no ulotu am miton kugol ton-bom unang tinum iyo suun kup kafalem-nak-bii kale, ibo tii tal kugol naafuta de namo-nimip kale minte, intaben o age-nilipta, ibo kupkasipta, kamano kota ibo tinum ipkumal aa-bom mufekmufek daga-emin tinum imi aafuu de dupkabip ulutap ke-nilipta, benat so ulin so uyo kulep talta, de namolum o ageta tilip a? Kuta kamano kota God iyo Mililepnok ko age Saatan iyo dupkala ilami aget fugunin uyo ku ipmi kobe dong dogobelata, kanupmum o ageta, numi ilep uyo albu kalaa age-nilipta, fiko tal naafulum o agan-bilip o,” age Yesus iyo kamogimal imi bogobela ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Yesus iyo bagan-siit kupkala e, un tubulin iyo aafuu duptamo tinum amem imi kamok miton ko age hetpris imi am iinip e, Fita iyo kota imi umik tem simanim so kugol tam tam yak abe ");
INSERT INTO tlf_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","tam hetpris imi am daam tem tam abomu e, un tubulin tebe abiip mat kal at kwegalip kena-bulu e, tinum iip maak maak iyo ton-bom at uyo fufala kwek mobip kalaa age-nala e, yagal no tama e, isino tonip ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kale ogok kemin unang maak uyo atamuta e, tal at ilagenin diim kal tonba kalaa age kek fen tele atam-nulu e, tinum tonan unbip imi bogopmu, “Ibaa. Tinum tal tonba begal mungkup Yesus so tiinan-nak-be o,” agelu e, ");
INSERT INTO tlf_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Fita iyo fulma-nala e, bogobela, “Kubaa. Niyo beyo atamsaali o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kale siit-kulu e, tinum maak Fita iyo atam-nala e, bogopma, “Kapkal mungkup tinum bemi tinum maak o,” agela e, Fita iyo yan kebe bogopma, “Kabaa. Naga ba kuba,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kale ton-siit ilugola e, tinum migik maak isiik mitam bogo-nala e, “Niyo tinum bemi weng bagan-be uyo tolong dolita e, Provins Galili kayaak kalaa ageli kale, begal mungkup Provins Galili kayaak Yesus so tiinan-nak-be o,” age yakyak kema e, ");
INSERT INTO tlf_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Fita iyo bogopma, “Tinum kabaa. Niyo kapmi weng bagan-balap kwek uyo tele bam daalin-tem o,” agan-kala e, kota maak fagalin tap uun kakaluk aalap iyo olala ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kota Kamogim Yesus iyo fupkela kek fen Fita iyo tele atama e, Fita iyo asok aget fugunota, siin Yesus imi bogopne-nala, “Kutim mililep kota uun kakaluk aalap iyo olalin-tem bom-salata, kabo nimi sang uyo bogopne-nalap, ‘Beyo atamsaali o,’ nage yakyak bii, ilep asuno fagalan-temap o,” ageba uyo fen ko kanubeli kalaa age-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","bilii imkaa daam tem uyo kupkaa tam sep kutam kal fomtuup amema ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Un tubulin Yesus imi tiin mobip bilip iyo Yesus iyo titul weng fiil weng baga-e-bom saal dagamip kale, ");
INSERT INTO tlf_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","kanupmin kuguup uta kanu-bom-nilip e, ilim ku Yesus imi tiin so tibit so uyo katibe-nilip e, asok saal daga-bom titul weng baga-e-bom-nilip e, “Kabo imkalap unang tinum iyo bogopke-nilip, ‘Kabo God imi profet ko age weng kem baga-emin tinum o,’ agan-nuubip kuta, kabo tele utamsap tinum iyo kulbap aga? Tinum maak tebe kangkola kale, bogobe-nalap, ‘Beyo waanta o,’ agelapta, utamum o,” age sal faga-e-bom titul weng baga-e-bom-nilip e minte, ");
INSERT INTO tlf_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","mungkup weng mafak ugulumi migik migik uyo baga-e-bom no kemip ko. ");
INSERT INTO tlf_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Am daanu e, Juda kasel imi kamok kamok so tinum amem ko age pris imi kamogimal so e minte ulo utamsip tinum so bilip iyo, weng bagamum o age tala tala ke tal ilimi weng telelmin am katam kal tonip e, un tubulin iyo Yesus iyo dep no bilip imi diim daalip e, ");
INSERT INTO tlf_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","kamogimal iyo Yesus imi bogopmip, “Kabaa. Bogobelal a. Kabo God imi ulaa kamdula kamok kesap tinum bele ki?” agelip e, Yesus iyo yan kepma, “Niyo bogobe-nili, ‘Niyo God imi ulaa nimdula kamok kesi tinum Krais o,’ agelan-temi uyo, ibo, boyo dam bagan-be kalaa nagon-temaalip binim kale, ");
INSERT INTO tlf_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ulutap niyo weng maak dagalan-temi uyo, yan kepnelan-temaalip kuta, ");
INSERT INTO tlf_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","niyo weng kota kup bogopman-temi kale, kamano kaa kutop kutop kem unon-temu uyo, Mo Tibil imi Man niyo abiil tigiin kal bom kamogim imi baan diim uyo ku-nilita, titil kup tebesa tinum God imi sagaal ipkuk ilo keng kal tonan-temi o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","alugum bogobelip, “Kam agelap boyo, ‘Niyo God imi Man o,’ ageta bogolap bele ki?” agelip e, Yesus iyo yan kepma, “Niyo maak bogobelin-tem kale, ipkil boyo bogopnelip kale, boyo dam o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ilimi weng uyo buguna tala ke-bom bogolip, “Nuyo ilami weng bagan-be uyo nulumi tolong alop diim tinangkulupta, beyo fen fengmin tinum kalaa agelup kale, nuyo tinum maak atamupta, beta Yesus imi sang uyo maak so bogolan-temaala binim o,” age ilimi weng kup bagamip ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kale kamogimal bilip iyo alugum fen mo-nilip e, Yesus iyo dep unanbu no Rom kasel imi kiyap Pailat imi diim daa-nilip e, ");
INSERT INTO tlf_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","bisop baga-bom weng mafak mafak uyo baga-e-bom bogo-nilip e, “Nuyo tinum keyo tolong umo-bulupta, bisop weng uyo Juda kasel numi unang tinum iyo uget taga-bom bogobe-nala, ‘Ibo takis mani uyo kulu Rom kasel imi kamok King Sisa Juda kasel ipmi tiin molin iyo kupka-emin ba kale, nita God imi ulaa nimdula kamok kesi tinum kale, niyo ipmi king o,’ agela kalaa age-nulupta, dep kapmi finang tulup o,” agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pailat iyo tolong do-nala e, Yesus iyo dagala, “Kabo Juda kasel imi kamok king iyo kulbap bele ki?” agela e minte, Yesus isiik bogobe-nala e, “Niyo maak bogolin-tem kale, kapkal bogolap o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kale kota Pailat iyo tinum amem ko age pris imi kamogimal so minte tinum migik kwiin tagang isino albip iyo bogobe-nala e, “Niyo tinum keyo atamita e, kuguup mafak umaak kelata, dep talaalip binim kalaa ageli (kale, niyo nimi waasi dinan-kalin tinum iyo bogobeli kaal fuyap umaak kopman-temaalip binim) o,” agela kuta, ");
INSERT INTO tlf_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","(bilip imi aget fugun-bilip uyo, Pailat iyo uget togolupta, kuguup mafak umaak Yesus iyo kobelak o age-nilip e,) maak so fomtuup weng bogobelip, “Beyo Provins Yuudiya abiip maak maak umi tinum iyo alugum wit saane-balata, Rom kasel so dinan-kulum o agan-bilip ko. Kamaki kanupmin kuguup uyo Provins Galili usiik kanum-nuuba kale minte, kamano kota tal numi Provins Yuudiya kagal kanu-be o,” age uget togolip ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Kale Pailat iyo weng boyo tolong do-nala e, dagala, “Tinum keyo Provins Galili kayaak aga o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“Aa. Tinum beyo Galili kayaak o,” agelip ko. Kale siin uyo Rom umi King Sisa iyo tebe Herot iyo ulaa du bogobe-nala e, “Nalami win tolop diim uta kabo Provins Galili umi unang tinum iyo tiin molan-temap o,” agela tiin mosa kale, Pailat iyo utamata e, kamaa kota Herot iyo Provins Galili uyo kupkaa kuun tal Jerusalam kagal alba kalaa age-nala e minte, Yesus imi ko dep tal yega dobelum o age dep tilip boyo nimi ogok ba kale, Herot ilami ogok kalaa age no ke-nala e, ilami waasi dinan-kalin tinum iyo olabela tal Yesus iyo dep no Herot imi diim daalip ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Siin uyo Herot iyo, Yesus imi sang uyo baga-bilip tolong duga-bom-nalata, Yesus iyo ataman o agan tebesa kale, imi aget fugunin uyo ki, mirakel ko age kuguup ugulumi migik umaak ke-balata, ataman o agan tebesa kale, Yesus iyo aafuu dep no ilami diim daalip atam-nala e, imi aget tem uyo deng kup tebema ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kale Herot iyo weng kwiin tagang uyo Yesus imi dagagama kuta, Yesus iyo yan kepmoma binim kela ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tinum amem ko age pris imi kamogimal so ulo utamsip tinum sino igil mungkup tal Herot imi diim e talbip kale, kota yang mep so unom-nilip e, Yesus imi sang uyo bisop bogo, “Tinum beyo tuluun kanubeta fenga koba o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Yesus iyo weng binim ke-bala e, Herot isino e minte ilami Provins Galili imi waasi dinan-kalin tinum isino tebe Yesus imi titul weng baga-e-bom kuguup mafak uyo kupka-e-bom-nilip e minte, king imi ilim tambal migim-nuuba ulutap migibe-nilip e minte, titul saane-bom king imi win kufu-emin ulutap ke-e-bii-nilip e, kota ilami waasi dinan-kalin tinum iyo bogobela e, Yesus iyo asok duptamo Pailat imi finang unip ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Siin uyo Herot so Pailat so alop iyo waasi kebina tala kesipta, kamano kota alop iyo duup kiina tala kelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailat iyo tinum amem ko age pris imi kamogimal so Juda kasel imi kamogimal so minte tinum migik sino olabela tala tala kelip e, ");
INSERT INTO tlf_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","bogobela, “Ibo tinum keyo dep tal nimi diim daa bogopne-nilip, ‘Tinum keyo Juda kasel iyo alugum wit saane-balata, Rom kasel so dinan-kulum o agan-bilip o,’ agelip kuta, bomi sang uyo ilipmi tiin diim kal beyo dagagan-bii kuta, atamita, beyo kanupmin kuguup mafak umaak kebaala kalaa ageli ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Kota Herot isiik Yesus imi dagaga-bomta atamata e, beyo maak fenga kobaala kalaa age-nala e, imdalata, asok dep nimi finang tilip ko. Niyo utamita e, ipmi aget fugun-bilip uyo, waasi dinan-kalin tinum imi bogobelita, Yesus iyo angkolip kaanak o agan-bilip kalaa ageli kuta, Yesus iyo fenga kolin-tem kale, niyo bogobeli angkolip kaanan-temaala binim kale, ");
INSERT INTO tlf_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","niyo waasi dinan-kalin tinum iyo bogopmi sok ifet uta ku saal dagan-siit dupka-nilipta, talaa daalip daaginak o agon-temi o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kale Pasova iman tigi-bom unan-kalin am uyo atol maagup dakan ke une yakyak kem-nuubip kale, unan-kalip uyo, Pailat iyo Jerusalam umi kiyap imi kuguup uyo waafu-nala e, kanubelita, Juda kasel iyo nimi deng uyo tebemin o age-nalata, waasi dinan-kalin tinum iyo bogopma, “Juda kasel sok dinan-bii kosip iyo, ibo maagup beta kup talaa daalip daaginak o,” age yakyak kem-nuuba (kale, kota Pailat imi aget fugun-be uyo, “Waasi dinan-kalin tinum iyo bogopmi, Yesus ita sok talaa daalip daaginak o,” agan-be) kuta, ");
INSERT INTO tlf_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Juda kasel iyo alugum fomtuup ol-bom bogobe-nilip e, “Bogopmap tinum beyo angkolip kaanata minte, Barabas ita sok talaa daalip daaginak o,” age baga-emip ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Kale siin uyo tinum Barabas beyo ki, Rom kasel sino dinan-bulupta, Juda kasel numi bagan koyo kupkaa daage ilimi abiip iinin o age-nalata, tinum iip maak maak iyo titil weng uyo ku uget taga-balata, bilip iyo Barabas sino afeta-nilipta, Rom kasel tal abiip miton Jerusalam kutam nuubip isino dinan-bom Barabas ninggil ita tebe tinum iip maak maak iyo inolip kaanip e, Rom kasel ita ita ke-nilip e, Barabas iyo aafuu sok de dep no kalabus am daalip be ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailat iyo, waasi dinan-kalin tinum imi bogobeli Yesus iyo sok talaa daalip daaginak o age-nala e, asok maak so tinum kwiin tagang imi bogopma kuta, ");
INSERT INTO tlf_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","iyo tolong dolin binim ke-nilip e, asok fomtuup ol-bom bogo-nilip e, “Tinum be dep yak at diim daa angkolin o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kale ilep alop fagaa kupka-nala e minte, tam maak kemi diim kota Pailat iyo bogobe-nala e, “Intaben o ageta ibo boyo kam agan-bilip a? Dogonupmin umi fengmin uta fenga koba kalaa age bomi kalan o age-nulupta, angkolan-temup a? Niyo atamita e, kuguup mafak umaak kebaala kalaa ageli kale, niyo bogopmi angkolip kaanan-temaala kale, bogopmi sok ifet uta ku saal dagan-siit dupka-nilipta, daalip daaginak o agelan-temi o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kale Juda kasel iyo, Pailat imi weng uyo tinangkulaalup o age-nilip e, imi aget fugunin uyo, “Pailat iyo numi weng bota tinangku waafulak o,” age-nilipta, fomtuup suun olan-bom-nilip e, “Umbae. Bo kanumin ba kale, bogopmap dep yak at diim daa dubiit mo angkolin o,” agan-bom fomtuup ol-bom-nilip e, kota Pailat imi aget fugunin uyo segela kwaapmip unu e, ");
INSERT INTO tlf_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pailat iyo Juda kasel kamogimal imi, “Bo kanubelal o,” agan-bilip umdii kanube-nalata, ");
INSERT INTO tlf_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ilami waasi dinan-kalin tinum iyo bogobe-nala e, “Ibo no kalabus am tinum dinan-bom inola kaanip dep tal sok de dobip Barabas iyo talaa daa dupkalip daaginata, Yesus ita dep no at diim daa angkolin o,” agela kale, boyo Juda kasel imi aget fugun-bom-nilip, “Pailat kabo bota kanubelal o,” agan-bilip uyo Pailat iyo tebe ko kanubela ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Rom umi waasi dinan-kalin tinum iyo Jerusalam uyo kupka-nilip e, Yesus iyo duptamo abe-bilip e, Provins Sairini kayaak tinum Saimon beyo tal ilep kal abu mola kale, Saimon beyo, sep ilo Jerusalam e tolon o age talan-be kuta, waasi dinan-kalin tinum iyo aafuu fupkela do Yesus imi at uyo ku nagaal tobe bogobe-nilip e, “At boyo ku nagaal to-nalap e, Yesus imi umik tem talap bom o” agelip e, ku nagaal to una ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kale unang tinum kwiin tagang iyo Yesus imi umik tem abe-bom-nilip e, unang iip maak maak ita aget iluum tebebelu e, Yesus imi kalan uyo fomtuup amemip e, ");
INSERT INTO tlf_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesus iyo tolong do fupkela bogobe-nala e, “Jerusalam kasel unang ibaa. Nimi kalan uyo amemin ba kale, ilipmi kaal kalan so ilipmi man kalan so uta amemin o ageta kale, ");
INSERT INTO tlf_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ibo tinangku-silipta. Son-temu nala waasi tebe tal ipmi kaal fuyap kupka-eman-temip uyo, ogenal iyo ilimi man kaal fuyap kugan-bilip umi kalan uta ame-bom bogo-nilip e, ‘Unang fuun so unang man kolin-tem albu so minte unang man muuk kobelin-tem albu so ita kup tambaliim ke aget iluum umaak kulin-tem kelip o,’ agelan-temip kale, ");
INSERT INTO tlf_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","bomi am uyo daan mitam tulu e, unang tinum iyo amdu tigiin umi bogo-nilip e, ‘Tambaliim kale, kubo foga malaak nuyo imdaak tamalap kulel babik tem unom-nulupta, yuut kaanum o,’ agelan-temip ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kale at asit umi kwegalan-temap uyo, mimin katip kelan-temu kale minte, at dat umi kwegalan-temap uta, yuut fakam daa ken-nulu e, mimin kiim kelan-temu kale, mungkup niyo at asit ulutap ke kuguup mafak umaak kanubelin-tem kesi kuta, bilip iyo kaal fuyap uyo kopnelan-temip kale minte, Jerusalam kasel ipta at dat ulutap ke kuguup mafak kwiin tagang kanum-nuubip kale, waasi iyo tebe kaal fuyap kwiin kiim uyo kobelan-temip o,” age Yesus iyo baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kale waasi dinan-kalin tinum iyo fuut tibin tinum alop maak imtamo talta, tol tinum Yesus iyo dego no keta imdep yak at diim daa inolum o age-nilipta, imdep tilip ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kale amdu katip maak alba kutam iyo Dabaal Kun Tigiin o agan-nuubip kale, no Dabaal Kun Tigiin kutam kal tam-nilip e, waasi dinan-kalin tinum iyo Yesus iyo kota dep tam at diim daa dubiit mo dup-dii-nilip e minte, tinum fuut tibin alop igil mungkup kulep tal at diim daa im-kiit mo im-dii no ke-nilip e, maak ita dep te Yesus imi afaan ilo keng daa som, minte maak ita dep te ipkuk ilo keng daa no kelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kota Yesus iyo Aalap God iyo aman duga-e-bom-nala e, “Aatum kabaa. Kalip iyo tele bam daalin-tem ke-bom maagalo kanune-bilip kale, bomi kalan uta kaal fuyap uyo kupka-emin ba kale, imi yuum boyo kupkabelal o,” agela ko. Kale waasi dinan-kalin tinum iyo, Yesus imi ilim uyo kulep ko faga-bomta, tuum kangkang uyo kulu kwaalup iit o malaak o ke-bomta, waanta ita ita kela kalaa age, beta kula kula kelum o age-nilipta, Yesus imi ilim umdii togolip ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kale unang tinum iyo mo-bom Yesus atama-bilip e, Juda kasel imi kamogimal ita titul weng baga-e-bom-nilip e, “Beyo unang tinum migik imi kaal ilak uta do dong daga-e-bala waalanan-nuubip kale minte, beyo fen God imi ulaa dula kamok kesa tinum Krais umdii, yagal ilami kaal ilak uyo do-nalata, at diim uyo talaa kupkaa malaak e tal waalanata, atamum o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Waasi dinan-kalin tinum iyo kamogimal imi weng uyo tolong do-nilip e, isiik Yesus imi titul weng bogobe-nilip e, tal Yesus imi mep so e tolom sok dum ok amil tebesu uyo ku diibelup unelak o age kobe-nilip e, ");
INSERT INTO tlf_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","asok bogobelip, “Kabo tuluun Juda kasel imi king umdii, kapkal kalapmi kaal ilak uyo do-nalap waalanal o,” agan-kalip ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kale Pailat imi ogok kemin tinum iyo at kom maak ku bomi diim kwegal dola ko-nala e, “Tinum keyo Juda kasel imi kamok king o,” age at kom uyo dola kwep iit Yesus imi tip diim kwegal kup-diilip ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Fuut tibin tinum alop Yesus imi mep so im-diilip iyo maagup maak Yesus imi olabe titul weng bogopma, “Kabo tuluun weng bogo-nalap, ‘Niyo ki dam God imi ulaa nimdula kamok kesi tinum o,’ agelap umdii, kapkal kalapmi kaal ilak uyo do som, minte numi kaal ilak uyo do no ke God iyo dagalapta, yagal tebe dong dogobelata, ninggil asuno kano waalanum o,” agan-kala e minte, ");
INSERT INTO tlf_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","maak ita tebe ipkum bemi alaang weng kup bogobe-nala e, “Yesus iyo, angkolip kaanan o angba kale, ulutap kapkal mungkup, kangkolip kaanan o angbap kale, intaben o age-nalapta, kam agan-balap a? Kabo God imi atul uyo finanin binim ke-balap aga? ");
INSERT INTO tlf_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Alop nuyo kuguup mafak waafusup kale, felepmuta, kaal fuyap uyo ku kaanum o angbup kale minte, tinum keyo kuguup mafak umaak kem-nuubaala binim o,” age maak imi bogobe-nala e minte, ");
INSERT INTO tlf_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","fupkela Yesus imi bogopma, “Yesus kabaa. Kabo tinum dong dogobelap waalanamin umi magam kayaak kale, kabo kamok king ke-nalap unang tinum tiin molan-temap uyo, nimi aget uyo fugun-bom-nalapta, dong dogopnelal o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesus isiik bogobe-nala e, “Niyo weng uyo tuluun bogopkelan-temi kale, tinangku-salapta. Kamano koyo Baladiis ko age abiil tigiin kal kapsino nisino alop nan-temup o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kale ataan tal dubim e tulu e, mililebok uyo mitam abuta, alugum kafin kaa kutufosu uyo mililan-bom-bulu bii, ataan uyo fupkela te kek iinom atanim sinik uyo tal asuno diim iinu e, kota asok daanu ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Kale mililan-bom-bulu e, ulotu am miton kutam kal ilim afalik maak kup-diilip God imi abiin amem uksu-bomu uyo dong katam-tele bigi kwep tiinu ki te daak kafin diim daa kupkaa milii so milii so alop kano kulep tolu e, God imi abiin amem kutam uyo kemanu ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Kota Yesus iyo Aalap God imi fomtuup ole-bom-nala e, “Aatum kabaa. Nimi sinik boyo kwaap-kami yak Aatum kalapmi diim abelu o,” angba kup e, kota mam timi age binimana ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kale waasi dinan-kalin tinum imi tiin molin iyo utamata e, Yesus iyo kanube kaana kalaa age-nala e, God imi win uyo kufu-e-bom-nala e bole, bogola, “Yak tinum tambal beyo win binim tebesata, ko kaana o,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kale Jerusalam kasel unang tinum kwiin tagang imi aget fugunin uyo, nota Yesus angkolan-temip uyo utamum o age-nilipta, tala tala ke-bii afeta kobip kale, alugum kuguup migik migik ko mitam tulu tulu kelu boyo utam-nilipta, kota imi aget tem uyo mafaganebelu aman-bii kupka-nilip e, daage no ilimi am una tala kelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Kale Yesus ilami duup-afin so unang iip maak maak Provins Galili kupkaa Yesus isino no, dong daga-e-bulupta o age Yesus iso maagup talbip so iyo alugum yang simanim so kweng kal mo-bom atama-bom-sulupta, waasi iyo tebe Yesus iyo intaben nubelip kalaa agelum o age-nilipta, atamamip ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Kale tinum maak bemi win uyo Josep o agan-nuubip kale, beyo Provins Yuudiya umi abiip Arimatea kayaak kale, beyo tinum tambal tol kup tebesa kale, beyo unang tinum imdep tam God ilami daam tem daa tiin molan-tema umi am daan tolon-temu umi fen-nuuba ko. Kale beyo Juda kasel imi kamok kamok imi tinum kuta, alugum kamok kamok bilip iyo weng bagan-bii bogolip, “Yesus iyo daalup yak Rom kasel imi diim abelata, angkolip kaanak o,” age-nilip e, weng telelalipta minte, Josep beta, “Waago o,” ageba ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Kota Josep iyo no Pailat iyo daga-nala e, “Dagalita, kabo, ‘O,’ agelap kalaa age-nilita, nita Yesus imi at kulu uyo talaa dep no dubalan o ageta tili o,” agela e, Pailat iyo, “O,” agela ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kale siin uyo Josep ninggil igil, tinum kaanip imamin umi o age-nilipta, tuum tem maak kalo kolip suu kuta, tinum iyo maak kaana dep no dubalin-tem kale, Josep so ipkum maak so alop iyo Yesus imi at kulu uyo talaa dep malaak daa-nilip e, ilim namaal tambal maak ku fufala do dep no tuum tem kalo telelasip kutam kal dubalip ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Alop imi ko kanube dubalip bomi magam uyo ki, Fraide kwiinu kota kale, alop iyo bomta utamipta e, amsap God imi ifin am daan bon-temu boyo tinum kaana imi at kulu uyo kubamin binim kalaa age-nilipta, yuut at kulu uyo dep no dubalip ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kale unang Provins Galili kupkaa Yesus isino talbip ita yak Josep imi daang begebe abe-bomta utamipta e, begel ilet tem uyo kugol albu kalaa age-nilip e minte, Josep ninggil imi at kulu fufala dolip uyo, Juda kasel numi tinum dubamin kuguup uyo ku-nilipta, mufekmufek tang tambal kuunin umaak ku iligebelin-tem ke yuut dubalip kalaa age unang bilip iyo utamip ko. ");
INSERT INTO tlf_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kale unang bilip imi aget fugunin uyo, tang tambal kuunin ok so kon so uyo kulep tal Yesus imi kaal diim uyo iligebelum o age-nilipta, asok daage no abiip miton kal mo telela kolip kuta, Moses imi ulo usiik waafu-bom-sulup God imi ifin am uyo binimanuta o age bom nip ko. ");
INSERT INTO tlf_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kale God imi ifin am uyo binimanu silip nala e, Sande kutim mililep kota unang mangkal iyo daage no, tuum tem unum o age-nilip e, tang tambal kuunin ok telela kobip uyo kulep daage no abomu, ");
INSERT INTO tlf_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","amitem umi tuum kom ko age faal telela kwek mo-silip uyo bubulun yang iinu e, amitem uyo bitobu kalaa age-nilip e, ");
INSERT INTO tlf_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","mangkal iyo tam tuum tem tam unip kuta, Yesus imi at kulu uyo utamin-tem ke-nilip e, ");
INSERT INTO tlf_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","bomi aget afalik uyo fugun-bomta utamipta, tinum alop maak ilim namaal kup tebesu kulu migibip iyo tal imi mep so kugol mobip kalaa age unang iyo itam-nilip e, ");
INSERT INTO tlf_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","finano dubom bagaa kalaak kugu kalaak fenip e, tinum alop iyo bogobe-nilip e, “Ibo intaben o ageta tinum tiin kafan alba iyo begel ilet tem koyo fen talan-bilip a? ");
INSERT INTO tlf_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yesus iyo kagal albaala kale, iyo fen tigi mo tuum tem katam uyo kupkaa tam iina kale, ibo tele aget fugunolin. Siin uyo mangkal ninggil ibo iso Provins Galili bom-nilip bogobe-se uyo ki, ibo bogobe-nala, ");
INSERT INTO tlf_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Kota Mo Tibil imi Man niyo tinum iyo tebe nimdalip yak fengmin tinum imi sagaal diim abelita, nimdep no at diim kal nim-kiit mo nangkolip kaanan-temi kuta, am alop ke-nilita, am asuno diim kota asok fenan-temi o,’ age-se o,” age tinum alop iyo kam agelip e, ");
INSERT INTO tlf_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","kota unang mangkal iyo aget fuguno utamipta e, Yesus imi weng kam age-se uyo kulbu kalaa agelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kale kota mangkal iyo tuum tem uyo kupkaa tam abe no Jerusalam no-nilip e, okumop man kum kal sino imi ipkumal sino imi diim kal alugum mufekmufek utam unip umi sang sino minte weng tinangku unip umi sang so uyo baga-emip kale, ");
INSERT INTO tlf_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","unang bilip iyo ki, abiip Makdala unang Maria ugol, Joana ugol, Jems ogen Maria ugol, minte unang milii maak iso mangkal unbip iso mangkal iyo weng boyo kwep no kalaan tinum kum kal iyo bogobelip kuta, ");
INSERT INTO tlf_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","kalaan tinum ninggil iyo bogo-nilip e, “Umbae. Unang bilip iyo bisop bagan-bilip o,” age-nilip e, imi weng uyo fen kalaa agelaalip ko. ");
INSERT INTO tlf_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kale minte Fita ita fen-nala e, yuut no tuum tem amitem ko suk mo katam fen utamata, ilim uta kup albu kalaa age, “Yei,” age kumang mo-nala e, asok daage no am no-nalata, kanube bulu utam tala bomi aget uyo fomtuup fuguna ko. ");
INSERT INTO tlf_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kale am ko daan-bom-sulu kwek umi kwiina kota Yesus imi ilak dolin tinum alop maak iyo Jerusalam uyo kupkaa daage no, abiip Emeus unum o age-nilipta, unip kale, ilep ko Jerusalam kupkaa Emeus unsu bomi timitim uyo kilomita ulumi kup kum kal kale, ");
INSERT INTO tlf_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","alop iyo abe-bom-nilip e, alugum mufekmufek ko kanum mitam tebebu umi sang uyo ");
INSERT INTO tlf_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","buguna tala kem abe-bilipta, Yesus yagal no abu daalata, iso ninggil maagup unip kale, ");
INSERT INTO tlf_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","alop iyo atamta, beyo Yesus kalaa agebaalip kale, ");
INSERT INTO tlf_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesus iyo daga-nala e, “Alop ibo intaben sang uta bagan talan-bilip o?” agela e, alop iyo bubul iluum tebepmu e, filmen daa amemin tibit baa-nilip e, molip ko. ");
INSERT INTO tlf_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kale tinum maak bemi win uyo Kliopas kale, beta tebe Yesus imi weng uyo yan kebe-nala e, “Abiip maak maak imi unang tinum kwiin tagang iyo tal Jerusalam kutam kal bilip kale minte, atin tinum iyo maagup kapta kup wiik kaa tiinbu komi diim umi mufekmufek mitam tulu tulu kem-nak-bo uyo utabaalap aga o?” age Yesus imi weng uyo yan kepma e, ");
INSERT INTO tlf_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesus isiik alop imi dagala, “Kapmi, ‘Mufekmufek ko mitam talbu o,’ agan-balap boyo intaben uta o?” agela e, alop isiik bogobe-nilip e, “Mufekmufek ko mitam talbu uyo ki, mufekmufek mitam Nasaret kayaak Yesus imi diim abebu umi sang uta bagan talan-bulup kale, beyo God imi profet ko age weng kem baga-emin tinum kale, God sino alugum unang tinum sino iyo atamipta e, beyo titil fagaa ogok tambal ke-bom weng tambal baga-e-bom no kemin tinum kalaa agan-nuubip kale, ");
INSERT INTO tlf_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","numi tinum amem ko age pris imi kamogimal so unang tinum imi kamogimal so iyo tebe daalip yak Rom kasel imi kiyap imi sagaal diim abelata, kiyap ita weng uyo de ko-nalata, ‘Angkolip kaanak o,’ agelata, dep no at diim dubiit mo angkolip kaanba kuta, ");
INSERT INTO tlf_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","siin uyo numi aget uyo, ‘Beta tebe Israel unang tinum numi waasi iyo imdaak tama te tam ita ita kelata, abiin tambal tonan-temup o,’ agesup kale minte, maak uyo, komi mufekmufek mitam talbu boyo am alop kelu kale, ");
INSERT INTO tlf_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","kamano am asuno komi kutim kota nuyo kumang mobup kale, boyo ki, kutim mililep kota numi unang milii iyo no tuum tem Yesus duba-silip uyo tamta ");
INSERT INTO tlf_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ugalipta e, Yesus imi at kulu uyo binim kalaa age-nilipta, asok kupkaa tal-nilipta, ‘Nuyo ensel maak itamupta, iyo bogo-nilip, “Iyo kafan so alba o,” agelip o,’ agelip kalaa age-nulupta, ");
INSERT INTO tlf_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","numi tinum milii isiik nota tuum tem uyo ugalipta e, unang imi weng bogolip uyo fen kalaa agelip kuta, Yesus iyo atamin-tem o,” age-nilip e, alop ita Yesus imi baga-emip ko. ");
INSERT INTO tlf_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kale Yesus isiik alop imi bogobe-nala e, “Alop ibo ilum ilum ke-bilip aga? Sugayok uyo God imi profet ko age weng kem baga-emin tinum bilip iyo God imi ulaa dula kamok kesa tinum Krais imi sang uyo unang tinum iyo baga-emsip kuta, alop ibo utamipta, bilip iyo fen dam bogosip kalaa agesaalipta, kam agan talan-bilip aga? ");
INSERT INTO tlf_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Sugayok uyo God iyo bogo-nala e, ‘Nimi ulaa duli kamok kesa tinum iyo kaal fuyap ku kaan-nalata, fen mitam abiil tigiin koyo tal-nalata, kamok ke-nala e minte, yagalami migik ke no kelan-tema o,’ agesa kuta, ibo God imi weng boyo dagaa kusaalip aga o?” age Yesus iyo alop imi baga-ema kale, ");
INSERT INTO tlf_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","kam age-nalata, sugayok Moses imi weng so God imi profet ko age weng kem baga-emin tinum bilip imi weng sino minte weng maak God imi suuk kon tem albu so umi tem kwek umi Yesus ilami sang bogosu umi magam uyo dupkop daabela ko. ");
INSERT INTO tlf_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kale kota ninggil iyo no, alop imi abiip katam iinum o age unbip umi mep so unip kale, alop iyo utamipta e, Yesus iyo tam tam unon o angba kalaa age-nilipta, ");
INSERT INTO tlf_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","“Waago. Ataan uyo tem iinu e minte, mililan no kelu kale, kupkaa talapta, nuso ninggil suumta o,” agelip e, kupkala e, ninggil am iinip ko. ");
INSERT INTO tlf_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kale ninggil iyo tam ton-nilip e, iman unelum o age-nilip e, Yesus iyo daak bret maak kwep daalip uyo ku God iyo, “Suguul o,” age-nala e, ilo ko tinum alop imi kobela e, ");
INSERT INTO tlf_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","alop iyo utamipta e, keyo Yesus yagal kalaa agelip e, kota bubat age daagina ko. ");
INSERT INTO tlf_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kale kota alop iyo weng bogola bogola ke-bom-nilip e, “A-e. Alop nuyo ilep talan-bulupta, iyo God imi suuk kon tem weng umi magam uyo tele dupkop daabelata, kota numi bubul uyo dagaa kwaabela deng taban tulup o,” age-nilip e, ");
INSERT INTO tlf_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","alop iyo maak fagalin tap fen-nilip e, asok yuut daage no Jerusalam no abomu, okumop man kum kal isino minte duup-afin iip maak maak sino afetabip kalaa age no tamip e, ");
INSERT INTO tlf_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","iyo bogo-nilip e, “Aafen kwa. Kamogim iyo fen tigi moba kale, Saimon iyo ataba o,” agelip e minte, ");
INSERT INTO tlf_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","alop igil Yesus no ilep abu mola abe-bom weng bagan unip umi sang so bret ilo kobela atamipta, beyo Yesus yagal kalaa agelip umi sang so uyo bogobe no kelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kale ninggil iyo weng bo baga-bom bom-silipta, Yesus iyo tal bilip imi iibak tem kal mo bogobe-nala e, “Ninggil ibo aget bilili age-bom-nilipta o,” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ninggil imi aget fugunin uyo, beyo begel ko age-nilipta, kumang mo atin ki finan-bii kolip e, ");
INSERT INTO tlf_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yesus iyo bogobe-nala e, “Ibo intaben o ageta kumang molip a? Intaben o age-nilipta, ‘Beyo fen Yesus bele, begel o?’ nagan-bilip a? ");
INSERT INTO tlf_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ninggil ibo nimi sagaal so yaan so koyo utamin. Niyo nagal kale, sagaal kwep yak daata naafuta nitamin. Begel iyo dam so kun so nitamip nalatap ba o,” age-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","imi sagaal so yaan so uyo kulu kafalebela e, ");
INSERT INTO tlf_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ninggil iyo atin ugaa kwaa deng kup taban-bilip kuta minte, imi aget fugunin maak uyo, “Bota fen bele, bisop deng umaak tebe-numup bele o?” agan-bilip kalaa age-nalata, Yesus iyo bogobela, “Ibo koyo iman umaak albu aga o?” agela e, ");
INSERT INTO tlf_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","aniing anung maak kwe fuubip uyo kopmip e, ");
INSERT INTO tlf_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ku unan-bala e, atamamip ko. ");
INSERT INTO tlf_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kale Yesus iyo bogobe-nala e, “Siin uyo niyo ipso somta, niyo ibo bogobe-nili e, ‘Sugayok Moses imi weng ko age ulo sino God imi profet ko age weng kem baga-emin tinum imi weng sino God imi suuk kon tem aseng sino nimi sang uta bogosu kale, siin nimi sang dola-silip uyo alugum kanube mitam tolon-temu o,’ age-nilita, kaanin-tem som-nilita, bogobe-sii o,” age-nalata, ");
INSERT INTO tlf_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","tinum ninggil imi aget tem uyo bam daapmata, utamipta e, God imi weng dola-silip umi magam uyo kulbu kalaa agelip ko. ");
INSERT INTO tlf_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kale Yesus iyo bogobe-nala e, “God imi suuk kon tem weng kwek uyo bogo-nulu e, ‘God imi ulaa dula kamok kesa tinum iyo kaal fuyap ku kaana dubalip bii, am alop ke-nalata, am asuno diim kota asok begel ilet tem ilo fen tigi molan-tema kale, ");
INSERT INTO tlf_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","imi tinum bilip iyo God imi ulaa dula kamok kesa tinum imi win tolop diim God imi weng boyo kwep bagan abe-bilipta, alugum tinum miit maak maak iyo tinangku-nilip e, imi aget aa bubul aa uyo fupkela ko God imi kobelipta, God tebe imi fengmin uyo kupkabelan-tema kale, kamaki uyo Jerusalam kal kufo-nilipta, baga-em unon-temip o,’ agesu kale, ");
INSERT INTO tlf_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ninggil ipkil ilipmi tolong alop uyo do som, minte ilipmi tiin alop uyo utam no kebip kale, bomi sang uta en bom tegen-bom ke-bom-nilipta, baga-em tiinemin o ageta kale, ");
INSERT INTO tlf_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","tinangkulin. Siin Aatum imi bogo-nala, ‘Nimi Sinik iyo ipmi dobelan-temi o,’ age-se iyo kota nagal ipmi daapmi no tolon-tema kuta, ninggil ibo abiip miton katam kal nin kup bom-silipta, abiil tigiin kayaak God imi Sinik iyo no ipmi diim uyo abe-nalata, imi titil uyo ibo kobelata o,” age baga-ema ko. ");
INSERT INTO tlf_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kale Yesus iyo tebe ninggil iyo fola kulep unanbu no abiip Betani no-nala e, kugol imi sagaal uyo kufo God imi aman duga-e-bom-nala e, “Aatum kabo kalip iyo dong dogobelap tambaliim kup bom-bilipta o,” agan tolom-nala e, ");
INSERT INTO tlf_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","kota imkala e, God iyo tebe Yesus iyo dufo dep tam abiil tigiin una ko. ");
INSERT INTO tlf_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kale ninggil iyo Yesus imi tok uyo bagan-siit-nilip e, kupkaa asok no 