﻿USE sofia;
DROP TABLE IF EXISTS sofia.tkuNT_vpl;
CREATE TABLE tkuNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tkuNT_vpl WRITE;
INSERT INTO tkuNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Huā'mā' lista ū'tza' ī'xū'nāpap Jesucristo ē xla' ī'xū'nātā'nat David ē nā Abraham. ");
INSERT INTO tkuNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ixtāta' Isaac ixuanī't ē ū'tza' ixtāta' Jacob ē ū'tza' ixtāta'ca'n Judá ē ixtā'timīn. ");
INSERT INTO tkuNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá ixtāta'ca'n Fares ē Zara ixuanī't ē ixtzī'ca'n ixuanican Tamar. Fares ixtāta' Esrom ixuanī't ē ū'tza' ixtāta' Aram. ");
INSERT INTO tkuNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ixtāta' Aminadab ixuanī't ē ū'tza' ixtāta' Naasón tī ixtāta' Salmón. ");
INSERT INTO tkuNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón ixtāta' Booz ixuanī't ē ixtzī' Booz ū'tza' Rahab. Booz ixtāta' Obed ixuanī't ē ixtzī' Obed ixuanican Rut. Obed ixtāta' Isaí ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí ixtāta' rey David ixuanī't. Rey David ē puscāt tī pūla ixpuscāt Urías ixuanī't, xlaca'n ixtāta'ca'n Salomón ixtahuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón ixtāta' Roboam ixuanī't ē ū'tza' ixtāta' Abías tī ixtāta' Asa. ");
INSERT INTO tkuNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ixtāta' Josafat ixuanī't ē Josafat ixtāta' Joram ē ū'tza' ixtāta' Uzías. ");
INSERT INTO tkuNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías ixtāta' Jotam ixuanī't ē ū'tza' ixtāta' Acaz ē ū'tza' ixtāta' Ezequías. ");
INSERT INTO tkuNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías ixtāta' Manasés ixuanī't ē ū'tza' ixtāta' Amón tī ixtāta' Josías. ");
INSERT INTO tkuNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías ixtāta'ca'n Jeconías ē ixtā'timīn ixuanī't ē a'cxni' ixcāchī'canī't ē cālē'nca israelitas nac ti'ya't jā huanican Babilonia. ");
INSERT INTO tkuNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","A'cxni' cālē'ncanī'ttza' a'cxni' Jeconías ixka'lhī ixka'hua'cha Salatiel ē ū'tza' ixtāta' Zorobabel ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel ixtāta' Abiud ixuanī't ē ū'tza' ixtāta' Eliaquim tī ixtāta' Azor. ");
INSERT INTO tkuNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor ixtāta' Sadoc ixuanī't ē ū'tza' ixtāta' Aquim tī ixtāta' Eliud. ");
INSERT INTO tkuNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud ixtāta' Eleazar ixuanī't ē ū'tza' ixtāta' Matán tī ixtāta' Jacob. ");
INSERT INTO tkuNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob ixtāta' ixuanī't José tī ixkōlu' María. Tzamā' María, xla' ixtzī' Jesús ixuanī't, ū'tza' tī huanican Cristo. ");
INSERT INTO tkuNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Chuntza' ixlīkelhacāujtā'ti' ī'xū'nātā'natna' Abraham a'cxni' tahuī'lh David. Ixlīkelhacāujtā'ti' ī'xū'nātā'natna' David a'cxni' ixcālē'ncanī't israelitas nac ti'ya't jā huanican Babilonia. Ixlīkelhacāujtā'ti' ī'xū'nātā'natna' huampala a'cxni' lacatuncuhuī'lh Cristo. ");
INSERT INTO tkuNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","A'cxni' tahuī'lh Jesucristo, chuntza' a'kspulalh. Ixtzī' ixuanican María ē xla' ixtā'lacāxlanī'ttza' natā'tamakaxtoka José. A'cxni' jāna'j ixā'tatā'tahui'la a'cxni' María ixlīka'lhīni'ntza' ixlītli'hui'qui Espíritu Santo. ");
INSERT INTO tkuNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","A'cxni' José ca'tzīlh María ixka'lhīni'ntza', xla' ixmakxtekcu'tun. Tzeya chi'xcu' ixuanī't ē ū'tza' jā ixlīmālacapū'cu'tun na ixlacatīnca'n tachi'xcuhuī't ē jā ixmāmāxanī'cu'tun. Xmān tzē'k ixmakxtekcu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","A'cxni' José ixlacapāstacmā'lh huā'mā' a'cxni' lakahuāna'lh ē tasu'yuni'lh chā'tin ángel tī macamilh Māpa'ksīni' Dios ē xla' huanilh: ―José, hui'x tī ī'xū'nātā'nat David, jā catilīmā'xa'na' natā'tamakaxtoka María. Ū'tza' līka'lhīni'lh Espíritu Santo. ");
INSERT INTO tkuNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Naka'lhī ī'ska'ta' ka'hua'cha ē nahui'lī'ni'ya' ixtacuhuīni' Jesús. Xla' nacāmakapūtaxtū ixtachi'xcuhuī't ē ū'tza' nalīmāpācuhuīcan Jesús ―huanilh ángel. ");
INSERT INTO tkuNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Pō'ktu huā'mā' tū a'kspulalh namākentaxtū chī huanli ixa'kchihuīna' Māpa'ksīni' Dios. Chuntza' tzo'kli: ");
INSERT INTO tkuNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Tzu'ma'jāt naka'lhīni'n ē naka'lhī ixka'hua'cha ē namāpācuhuīcan Emanuel. (Huā'mā' tacuhuīni' huanicu'tun: Dios quincātā'hui'lan.) ");
INSERT INTO tkuNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","A'cxni' lakahuanli José, tlahualh ixlīpō'ktu tū māpa'ksīlh ixángel Māpa'ksīni' ē tā'tamakaxtokli María. ");
INSERT INTO tkuNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Jā xa'malh hasta a'cxni' xla' tahuī'lh ī'ska'ta' ixlīmaksāsti'. Hui'līni'lh ixtacuhuīni' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","A'cxni' Herodes rey ixuanī't nac ti'ya't jā huanican Judea a'cxni' Jesús lacatuncuhuī'lh a'ntza'. Lacatuncuhuī'lh nac cā'lacchicni' jā huanican Belén. Tachā'lh magos nac cā'lacchicni' jā huanican Jerusalén ē xlaca'n makat tamincha' na ixtankēn ");
INSERT INTO tkuNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ē takelhasqui'nīlh: ―¿Jāchu huī'lh ixpuxcu'ca'n israelitas tī tahuī'lhtza'? Quina'n iclaktzī'nī'tauj a'ktin sta'cu na ixtankēn. Ū'tza' quincāmāsu'yuni'n palh tahuī'lhtza'. Ū'tza' iclīmiujtza' huā'tzā' na'iclaktaquilhpūtayāuj. ");
INSERT INTO tkuNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","A'cxni' kexmatli huā'mā' tachihuīn, rey Herodes ixlī'a'ktuyumā'lh ē nā chuntza' ixlīpō'ktuca'n xalanī'n nac Jerusalén nā ixtalī'a'ktuyumā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Rey cāmāta'satīnīni'lh ē cāmākēstokli ixlīpō'ktuca'n xanapuxcu'nu' pālejni' israelitas ē tī ixtamāsu'yu līmāpa'ksīn. Cākelhasqui'nīca jāchu natahui'la Cristo ");
INSERT INTO tkuNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ē takelhtīni'lh: ―Natahui'la nac Belén xala' nac estado Judea. Chuntza' tzo'kli a'kchihuīna': ");
INSERT INTO tkuNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Belén xala' nac ti'ya't jā huanican Judá, masqui xamacsti'na'j na ixpu'nanca'n municipios nac huā'tzā' ti'ya't, ā'chulā' ixlacasqui'nca. Nalacatuncuhuī'yācha' a'ntza' chā'tin māpa'ksīni'. Xla' nacāmaktaka'lha quintachi'xcuhuī't tī cāhuanican israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herodes lakatzē'k cāmāta'satīnīni'lh magos ē cākelhasqui'nīlh jā'cxni' tasu'yulh sta'cu ē tūyā quilhtamacuj ē tūyā mālhcuyu'. ");
INSERT INTO tkuNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Cāmacā'lh nac Belén ē cāhuanilh: ―Capinchipitit ē naputzayā'tit palh ixlīcāna' lacatuncuhuī'lh ska'ta'. A'cxni' namacla'yā'tit, naquilāmāca'tzīnīyāuj. Nā quit tzē na'ica'n na'iclaktaquilhpūta ―chuntza' cāhuanilh. ");
INSERT INTO tkuNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","A'cxni' cātā'chihuīna'nkō'lh, magos ta'a'lh. Sta'cu tū ixtalaktzī'nī't ixtankēn, ū'tza' cāpūlani'lh ē cāmāsu'yuni'lh tej hasta tāyalh tālhmā'n jā ixuī'lh ska'ta'. ");
INSERT INTO tkuNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","A'cxni' magos talaktzī'lh chī tāyalh sta'cu, tapāxuhualh xlaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","A'cxni' tatanūlh nac chic, talaktzī'lh ska'ta' ē María tī ixtzī'. Tatatzokostani'lh ē talaktaquilhpūtalh ē tamakapāxuīlh ska'ta'. Tamakxcutli tū ixtalē'ni' ē tamaxquī'lh oro ē siyentzu ē perfume tū huanican mirra. ");
INSERT INTO tkuNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ā'līstān tataspi'tli lacatin nac tej. Ixtalakahuāna'nī't ē chuntza' cālīmāca'tzīnīca jā catatētaxtulh a'ntza' na ixchic Herodes. ");
INSERT INTO tkuNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","A'cxni' ixta'a'nī'ttza' magos, José lakahuāna'lh ē tasu'yuni'lh chā'tin ángel tī macamilh Māpa'ksīni' Dios. Ángel huanilh: ―Catāqui'. Cacālī'pi ska'ta' ē ixtzī' ē catzā'la'tit nac país jā huanican Egipto. A'ntza' natachokoyā'tit hasta a'cxni' na'icmāca'tzīnīyān. Herodes naputza ska'ta' ē namaknīcu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","José tāquī'lh a'cxni' tzi'sajcus ixuanī't ē a'lh. Cālē'lh ska'ta' ē ixtzī'. Ta'a'lh nac ti'ya't jā huanican Egipto. ");
INSERT INTO tkuNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","A'ntza' tatachokolh hasta a'cxni' nīlh Herodes. Chuntza' a'kspulalh namākentaxtū tū Māpa'ksīni' Dios ixuanī't ixa'kchihuīna'. Chuntza' huanli: “Ixuī'lh nac Egipto quiSka'ta' ē a'ntza' icta'sani'lh.” ");
INSERT INTO tkuNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","A'cxni' Herodes ca'tzīlh ixta'a'kskāhuī'nī't magos, xla' sītzī'lh. Māpa'ksīni'lh cacāmaknīca lacstīn tī ka'hua'cha. Cāmāmaknīnīni'nkō'lh ixlīpō'ktuca'n lacstīn tī xaka'hua'cha xalanī'n nac Belén ē ixlacatzuna'j cā'lacchicni'. Cāmāmaknīnīni'lh ixlīpō'ktuca'n tī jāna'j ixtaka'lhī a'ktu' cā'ta. Chuntza' māpa'ksīlh ixpālacata ixtlahuanī'ttza' hua'chi a'ktu' cā'ta a'cxni' ixlacatuncuhuī'nī't ska'ta' chī tahuanli magos. ");
INSERT INTO tkuNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Chuntza' mākentaxtūlh tū tzo'kli a'kchihuīna' tī ixuanican Jeremías. Chuntza' tzo'kli: ");
INSERT INTO tkuNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Kexmatcan chī calhuancan nac cā'lacchicni' jā huanican Ramá ē ta'sacan. Raquel ū'tza' tī cālakcalhuamā'lh ixlacstīn. Jāla ixmāko'xamixīcan ixpālacata ixtanīnī'ttza'. Chuntza' tzo'kli. ");
INSERT INTO tkuNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","A'cxni' ixnīnī'ttza' Herodes, José lakahuāna'mpālh a'ntza' jā ixuī'lh nac Egipto. Tasu'yuni'lh chā'tin ángel tī macamilh Māpa'ksīni' Dios ē huanilh: ");
INSERT INTO tkuNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Catāqui' ē calī'pi ska'ta' ē ixtzī'. Cataspi'ttit nac ti'ya't jā huanican Israel. Tanīlhtza' xlaca'n tī ixtamaknīcu'tun ska'ta' ―huanli ángel. ");
INSERT INTO tkuNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","José tāquī'lh ē a'lh ē lē'lh ska'ta' ē ixtzī' hasta nac Israel. ");
INSERT INTO tkuNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Arquelao ixlakxoko ixtāta' Herodes ixuanī't ē ixmāpa'ksīni'mā'lh jā huanican Judea. A'cxni' José ca'tzīlh huā'mā', ixjicua'n ē jā ixa'ncu'tun a'ntza'. Lakahuāna'mpālh ē ū'tza' talī'a'lh nac ti'ya't jā huanican Galilea. ");
INSERT INTO tkuNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","A'cxni' tachā'lh a'ntza' nac Galilea, ta'a'lh nac cā'lacchicni' jā huanican Nazaret ē a'ntza' tatahuī'lh. Chuntza' a'kspulalh namākentaxtū tū tahuanli a'kchihuīna'nī'n. Tahuanli: “Jesús namāpācuhuīcan nazareno.” ");
INSERT INTO tkuNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Huā'mā' quilhtamacuj milh nac cā'tzaya'nca ti'ya't nac Judea Juan tī ixmā'kpaxīni'n. Ixa'kchihuīna'mā'lh ");
INSERT INTO tkuNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ē ixcāhuani tachi'xcuhuī't: ―Calakpalī'tit mintalacapāstacni'ca'n ē camakxtektit tū jā tze ixpālacata talacatzuna'jīmā'lh a'cxni' Dios namāpa'ksīni'nkō'. ");
INSERT INTO tkuNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","A'kchihuīna' Isaías tzo'kli chī tachi'xcuhuī't natalakpalī ixtalacapāstacni'ca'n ē nata'a'ka'ī'. Tzo'kli ixpālacata huā'mā' Juan jā huan chuntza': A'ntza' jā cā'tzaya'nca ti'ya't, nakexmatcan catīhuālh tī palha' nachihuīna'n ē nahuan: “Cacāxtlahua'tit tej ixpālacata mimā'lh Māpa'ksīni'. Camālakstu'nctit tej.” ");
INSERT INTO tkuNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ixlu'xu' huā'mā' Juan līcāxtlahualh ixchi'xit camello ē ixlīchī'can ko'xka' ixuanī't. Xla' ixua' xtu'qui' ē xaxcān ta'xcāt xala' nac cā'qui'huī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tachi'xcuhuī't xalanī'n nac cā'lacchicni' Jerusalén tamilh takexmata. Nā lhūhua' tachi'xcuhuī't xalanī'n calhāxcuhuālh nac estado Judea ē xalanī'n lacatzuna'j xaka'tla' nac xcān Jordán nā tamilh takexmata. ");
INSERT INTO tkuNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","A'cxni' takelhtasu'yuni'lh Dios ixcuentaca'n, Juan cāmā'kpaxīlh chā'tunu' nac ka'tla' xcān Jordán. ");
INSERT INTO tkuNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Lhūhua' fariseos ē ixpālejni' israelitas tamilh ta'a'kpaxa. A'cxni' Juan cālaktzī'lh, cālacaquilhnīlh ē cāhuanilh: ―¡Hui'xina'n tlahua'pā'na'ntit a'ktu' milacanca'n! ¿Tīchu cāhuanin natzā'la'ni'yā'tit ixtasītzi' Dios tū mimā'lh? ");
INSERT INTO tkuNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Catlahua'tit tū tze ē ū'tza' nalītasu'yu ixlīcāna' lakpalīnī'ta'ntittza' mintalacapāstacni'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Jā catihuantit mē'cstuca'n: “Quina'n ī'xū'nātā'natna' Abraham. Ū'tza' iclīpāhuanāuj ē jā icjicua'ni'yāuj ixtasītzi' Dios.” Jā chuntza' ixua'ntit. Quit iccāhuaniyān Dios tzē nacālakpalī huā'mā' chihuixni' ē natala ī'xū'nātā'natna' Abraham. ");
INSERT INTO tkuNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Hua'chi xacacanī'ttza' ā'chaj ē natzucucan natancā'can qui'hui'. Catūhuālh qui'hui' tū jā māstā' ixtahua'ca't xatze, ū'tza' natancā'can ē nalhcuyucan. Tachi'xcuhuī't tī jā tatasu'yu palh ta'a'ka'ī', xlaca'n hua'chi qui'hui' tū jā tahua'ca'. ");
INSERT INTO tkuNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ixlīcāna' quit iccālīmā'kpaxīyān xcān. Ū'tza' nalītasu'yu chī līlīpuhuanā'tit tū jā tze tū tlahuanī'ta'ntit. Tī namin ā'līstān, xla' makapitzīn hui'xina'n nacātalīmā'kpaxīyān Espíritu Santo ē ā'makapitzīn huampala nacātalīmā'kpaxīyān macscut. Xla' ā'chulā' xaka'tla' ē jā quit. Quit jāla icmālakchā'nī chī xla'. Quit jā minī'ni' nūn na'icxcutni' ixlīkechī'can ixcaclhi'. ");
INSERT INTO tkuNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Xla' hua'chi chā'tin chi'xcu' tī chi'panī'ttza' ixlīmālakosūn ē nalacsu'nu trigo tū tlahuacan harina. Xalīcha'nat trigo namānū jā māquī'can ē xapa'lhma' nalhcuyu nac macscut tū jāla catimāmixīlh ―cāhuanilh. ");
INSERT INTO tkuNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ā'līstān Jesús taxtulh nac estado Galilea ē lakchā'lh Juan jā ixmā'kpaxīni'mā'lh na ixquilhtūn ka'tla' xcān jā huanican Jordán. Jesús milh a'kpaxa. ");
INSERT INTO tkuNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ē Juan jā ixmā'kpaxīcu'tun Jesús ē huanilh: ―Hui'x minī'ni' naquimā'kpaxī'ya' ē jā ixlacasqui'nca quit na'icmā'kpaxīyān. ");
INSERT INTO tkuNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesús kelhtīlh: ―Chuhua'j calalh chuntza' chī icsqui'ni'yān. Chuntza' quincāminī'ni'yān ē ū'tza' nalītlahuakō'yāuj tū Dios māpa'ksīlh. Juan kexmatni'lh ē tlahualh tū huanilh. ");
INSERT INTO tkuNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesús, a'cxni' mā'kpaxīca, tacutli nac xcān. Xamaktin talaquī'lh nac a'kapūn ē Jesús laktzī'lh Espíritu Santo. Ixtasu'yu hua'chi tantzasnān. Yujchi na ixlaclhtza' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kexmatca a'ktin tachihuīn nac a'kapūn ē huanli: ―Ū'tza' huā'mā' quiSka'ta' tī laktza' icpāxquī' ē xla' quimakapāxuī. ");
INSERT INTO tkuNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Palaj tunca Espíritu Santo lē'lh Jesús nac cā'tzaya'nca ti'ya't. Skāhuī'ni' tī huanican Satanás ixlīlaktzī'ncu'tun palh tzē na'a'kskāhuī' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","A'ntza' tu'pu'xam quilhtamacuj Jesús jā huā'yalh pō'ktu quilhtamacuj ē pō'ktu tzī'sa ē ixtzi'ncsa. ");
INSERT INTO tkuNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Skāhuī'ni' laktalacatzuna'jīlh Jesús ē huanilh: ―Palh hui'x ī'Ska'ta' Dios, cacāmāpa'ksi' tzamā' chihuixni' pāntzīn catahuanli. ");
INSERT INTO tkuNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesús kelhtīlh: ―Tatzo'kni' na ixtachihuīn Dios: “Jā xmān pāntzīn catilīlatamā'lh chā'tin chi'xcu' nac cā'quilhtamacuj. Nā ixlacasqui'nca cuenta natlahuacan ixtachihuīn Dios.” ");
INSERT INTO tkuNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Palaj tunca skāhuī'ni' lē'lh Jesús nac Jerusalén jā nā māpācuhuīcan cā'lacchicni' xatasicua'lanātlahua. Māhua'ca'lh na ixa'kspūn xaka'tla' templo ");
INSERT INTO tkuNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ē huanica: ―Palh hui'x ī'Ska'ta' Dios, cayujti nac ti'ya't. Tatzo'kni' na ixtachihuīn Dios: Dios nacāmāpa'ksī ixángeles natamaktaka'lhān. Natamā'kaquī'yān ē chuntza' nūn kentin mintujan catitakāhui' nac chihuix. ");
INSERT INTO tkuNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús kelhtīlh: ―Nā chuntza' tatzo'kni' na ixtachihuīn Dios: “Jā tilīlaktzī'na' miMāpa'ksīni' Dios.” ");
INSERT INTO tkuNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Skāhuī'ni' lē'mpālh a'ktin nac sipej tālhmā'n. A'ntza' māsu'yuni'kō'lh ixlīka'tla' cā'quilhtamacuj ē chī tzēhuanī't ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Skāhuī'ni' huanilh: ―Pō'ktu huā'mā' na'icmaxquī'yān xmān naquintatzokostani'ya' ē naquilaktaquilhpūtaya' ―huanica Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesús kelhtīni'lh: ―¡Caquintapānu'ni', Skāhuī'ni'! Tatzo'kni' na ixtachihuīn Dios: “Natatzokostani'ya' ē nalaktaquilhpūtaya' miMāpa'ksīni' Dios ē natlahua'ya' xmān tū xla' lacasqui'n.” ");
INSERT INTO tkuNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Palaj tunca skāhuī'ni' a'kxtekui'līlh. Ē makapitzīn ángeles tamilh ē tamaktaka'lhli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jesús a'cxni' māca'tzīnīca chī ixchī'canī't Juan, palaj tunca a'lh nac estado Galilea ");
INSERT INTO tkuNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ē jā tachokolh nac Nazaret. A'lh tahui'la nac cā'lacchicni' Capernaum ixlacatzuna'j na ixquilhtūn xcān. Nā huā'mā' ti'ya't ixmāpācuhuīcan ixti'ya'tca'n Zabulón ē Neftalí. ");
INSERT INTO tkuNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Huā'mā' tū a'kspulalh mākentaxtūlh tū tzo'kli a'kchihuīna' Isaías na ixtachihuīn Dios. Chuntza' tzo'kli: ");
INSERT INTO tkuNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ti'ya't jā māpācuhuīcan Zabulón ē jā māpācuhuīcan Neftalí, a'ntza' tētaxtu tej tū mā'lh hasta nac mar. Nā a'ntza' ixtuntacut nac xcān Jordán nac estado Galilea ē ū'tza' jā tahui'lāna'lh tī jā israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Tachi'xcuhuī't hua'chi ixtahui'lāna'lh jā cā'pucsua' ē chuhua'j talaktzī'lh a'ktin xaka'tla' taxkaket. Xlaca'n hua'chi ixtanīmā'nalh ē cā'skē'k ixtahui'lāna'lh. Chuhua'j talaktzī'lh chī xkaka. Chuntza' tzo'kli Isaías. ");
INSERT INTO tkuNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Palaj tunca Jesús tzuculh a'kchihuīna'ntā'kchoko ē huanli: ―Calīlīpuhuantit tū jā tze tlahuanī'ta'ntit ē calakpalī'tit mintalacapāstacni'ca'n. Talacatzuna'jīmā'lhtza' a'cxni' Dios namāpa'ksīni'nkō'. ");
INSERT INTO tkuNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","A'cxni' Jesús ixlatlā'huan na ixquilhtūn xaka'tla' xcān tū huanican lago Galilea, cālaktzī'lh chā'tu' chi'xcuhuī'n tī lītā'timīn ixtahuanī't. Chā'tin Simón ixuanican ē ixlī'a'ktu' ixtacuhuīni' Pedro. Ā'chā'tin Andrés ixuanican. Xlaca'n chi'pāna'nī'n squī'ti' ixtahuanī't ē ixtamojōmā'nalh nac xcān ixpūtayanca'n tū pūchi'pacan squī'ti'. ");
INSERT INTO tkuNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Palaj tunca Jesús cāhuanilh: ―Caquilātā'a'uj ē na'iccāmāsu'yuni'yān chī nacālīmā'a'ka'ī'nī'yā'tit tachi'xcuhuī't ixtachihuīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Palaj tunca tamakxtekli ixpūtayanca'n ē tatā'a'lh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","A'cxni' a'lh ā'lacatin, cālaktzī'lh ā'chā'tu' huampala lītā'timīn. Xlaca'n ixcamana' Zebedeo ixtahuanī't ē ixtacuhuīni' chā'tin Jacobo ē ā'chā'tin Juan. Ixtatā'hui'lāna'lh ixtāta'ca'n nac barco ē ixtalacachī'mā'nalh tū pūchi'pacan squī'ti'. Jesús cāmāta'satīnīni'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Xamaktin xlaca'n tatacutli nac barco ē ta'a'kxtekui'līlh ixtāta'ca'n ē ta'a'lh tastālani'lh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús ixtlā'huamā'lh calhāxcuhuālh nac estado Galilea ē ixcāmāsu'yuni'mā'lh tachi'xcuhuī't na ixtemploca'n israelitas nac a'katunu' cā'lacchicni'. Ixcāmāsu'yuni'mā'lh chī nala jā Dios māpa'ksīni'nkō' ē ixcāmātzeyīmā'lh ixlīpō'ktuca'n kempālhūhua' ta'jatat tū ixcāpasanī't tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Calhāxcuhuālh nac ti'ya't jā huanican Siria cāmāca'tzīnīca ixpālacata Jesús. Cālīmini'ca ixlīpō'ktuca'n ta'jatatlanī'n. Cālīmini'ca tī ixtapātīmā'nalh catūxcuhuālh ta'jatat ē catūxcuhuālh taca'tzanajuāt. Cālīmini'ca tī ixtaka'lhī jā tzeya ū'nī'n ē tī ixpaxnīni'n ē tī ixtalū'ntū'nunī't. Jesús cāmātzeyīkō'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Līlhūhua' xalanī'n nac estado Galilea tastālani'lh ē nā xalanī'n nac Decápolis ē Jerusalén. Nā tastālani'lh xalanī'n nac estado Judea ē xalanī'n nac ti'ya't ixtuntacut nac xcān Jordán. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","A'cxni' Jesús cālaktzī'lh tamilh lhūhua' tachi'xcuhuī't, xla' tā'cxtulh na ixlacapūn sipej ē a'ntza' tahuī'lh. Ī'scujnu'nī'n palaj tunca talītamacsti'li'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jesús tzuculh cāmāsu'yuni'. Chuntza' Jesús cāhuanilh: ");
INSERT INTO tkuNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Masqui pūhua'nā'tit xmān tzē nalīmakapāxuī'yā'tit Dios palh xla' nacāmaktāyayān, ka'lhī'yā'tit tū nalīpāxuhua'yā'tit. Dios cālakalhu'manān masqui jā tze hui'xina'n. Nalīpāxuhua'yā'tit ixpālacata Dios cāmāpa'ksīmā'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Masqui līlīpuhuanā'tit mincuentaca'n ē tū jā tze nac cā'quilhtamacuj, ka'lhī'yā'tit tū nalīpāxuhua'yā'tit. Dios nacāmāko'xamāka'tlī'yān. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Ka'lhī'yā'tit tū nalīpāxuhua'yā'tit hui'xina'n tī jā ka'tla' līmakca'tzīyā'tit. Ixlīpō'ktu ti'ya't milaca'n nahuan. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Ka'lhī'yā'tit tū nalīpāxuhua'yā'tit hui'xina'n tī lactze huancu'tunā'tit na ixlacatīn Dios ē chuntza' makca'tzīyā'tit hua'chi tī tzi'ncsa putza ixtahua'. Dios nacāmaktāyayān ē chuntza' lactze nalītaxtuyā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Ka'lhī'yā'tit tū nalīpāxuhua'yā'tit hui'xina'n tī cālakalhu'manā'tit ā'makapitzīn. Nā Dios nacālakalhu'manān. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Ka'lhī'yā'tit tū nalīpāxuhua'yā'tit hui'xina'n tī xmān a'ktin mintalacapāstacni'ca'n ē ū'tza' chī tzē nalīmakapāxuī'yā'tit Dios. Nalīpāxuhua'yā'tit ixpālacata nac a'kapūn nalaktzī'nā'tit Dios calacan. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Ka'lhī'yā'tit tū nalīpāxuhua'yā'tit hui'xina'n tī cāmāko'xamixī'yā'tit tachi'xcuhuī't tī talāsītzī'ni'. Nalīpāxuhua'yā'tit ixpālacata nacātamāpācuhuī'yān ixlacstīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Ka'lhī'yā'tit tū nalīpāxuhua'yā'tit hui'xina'n masqui pātīni'mpā'na'ntit xmān ixpālacata tlahua'pā'na'ntit ixtalacasqui'nīn Dios. Dios cāmāpa'ksīmā'n ē ū'tza' nalīpāxuhua'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Ka'lhī'yā'tit tū nalīpāxuhua'yā'tit hui'xina'n a'cxni' tachi'xcuhuī't cātalakapalayān ē cātamātakāhuī'yān ē cātalīmālacsu'yuyān kempālhūhua' tū jā ixlīcāna'. Capāxuhua'tit a'cxni' cātatlahuani'yān chuntza' xmān ixpālacata quilāstālani'uj. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Capāxuhua'tit. Nac a'kapūn māquī'canī't tū milaca'n nahuan ē ū'tza' tū lhūhua' ixtapalh. Nā lacxtim cāmakapātīnīnca ixa'kchihuīna'nī'n Dios xalanī'n makāstza'. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jesús cāhuanipālh: ―Hui'xina'n hui'lā'na'ntit nac cā'quilhtamacuj nacāmāsu'yuni'yā'tit tachi'xcuhuī't chī tze natalīhuan. Ū'tza' hua'chi matzat tū lītlahuacan quinī't ē ū'tza' tze nalīhuan ē jā napu'csan. Palh matzat jātza' sko'kō'xni'n, ¿chī tzē nalīmāsko'kō'nuncan? Jātza' tze catihuanli. Xmān namaka'ncan ē nalacchi'ntacan. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Nā hui'xina'n hui'lā'na'ntit nac cā'quilhtamacuj nacāmāsu'yuni'yā'tit tachi'xcuhuī't chī natalīlatā'kchoko. Hui'xina'n hua'chi pūcās tū māxkakēni' ixlīpō'ktu nac cā'quilhtamacuj. A'ktin cā'lacchicni' tālhmā'n nac sipej jā catimātzē'kca. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ē nūn catimāpasīca pūcās ē palaj tunca nalīmā'kchahuacan catūhuālh. Ā'chulā' tze māhua'ca'can tālhmā'n ē chuntza' tzē nacāmāxkakē ixlīpō'ktuca'n tī tatanūmā'nalh nac chic. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Chuntza' hui'xina'n tzej nalatā'kchokoyā'tit na ixlacatīnca'n tachi'xcuhuī't ē chuntza' xlaca'n natamakapāxuī quinTāta'ca'n nac a'kapūn ixpālacata xatze tū tlahua'pā'na'ntit. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jesús cāhuanipālh: ―Jā capuhua'ntit icminī't na'icmālaksputū līmāpa'ksīn tū maxquī'ca Moisés ē tū tatzo'kli a'kchihuīna'nī'n. Jā ū'tza' iclīminī't. Quit icminī't namākentaxtū. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ixlīcāna' tū iccāhuaniyān. Līhuan tahui'lāna'lhcus a'kapūn ē ti'ya't, jā catixapaca nūn macsti'na'j tzamā' līmāpa'ksīn. Jā tū catixapaca a'cxni' jāna'j namākentaxtūkō'can ixlīpō'ktu tū nala. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Chuntza' palh catīhuālh namākēnū macsti'na'j tū māpa'ksī līmāpa'ksīn ixpālacata lacpuhuan jā ixlacasqui'nca ē palh chuntza' nacāmāsu'yuni' ā'makapitzīn, xla' xastancu nalītaxtu jā Dios māpa'ksīni'nkō'. Palh catīhuālh nakexmatni' līmāpa'ksīn ē nā nacāmāsu'yuni' ā'makapitzīn chī xlaca'n natakexmatni', xla' ixlacasqui'nca jā Dios māpa'ksīni'nkō'. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Chuntza' iccāhuaniyān ixlacasqui'nca natlahua'yā'tit tū ixlīcāna' ixtalacasqui'nīn Dios. Palh jā tasu'yu ā'chulā' xatze hui'xina'n ē jā xamākelhtahua'kē'ni'nī'n līmāpa'ksīn ē fariseos, hui'xina'n jā catitanū'tit jā Dios māpa'ksīni'nkō'. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jesús cāhuanipālh: ―Hui'xina'n kexpa'tnī'ta'ntittza' chī cāhuanica xalanī'n makāstza': “Jā catimaknī'ni'. Palh catīhuālh namaknīni'n naputzāna'nīcan ē xla' naxokonuni' Dios.” ");
INSERT INTO tkuNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Quit iccāhuaniyān palh catīhuālh xmān nasītzī'ni' ā'chā'tin, naputzāna'nīcan ē xla' naxokonuni' Dios. Catīhuālh tī nalakapala ā'chā'tin nā xla' naxokonuni' Dios. Catīhuālh tī cachīhuālh nahuani ā'chā'tin: “Lhkenti hui'x”, xla' tzē nalhcuyucan nac pūpātīn. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Chuntza' a'cxni' lī'pimpā't tū nalakahui'līya' Dios ē palh nalacapāstaca chī tlahuani'nī'ta' tū jā tze ā'chā'tin, ");
INSERT INTO tkuNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","namakxteka'chi nac pūmacamāstā'n tū ixlakahui'līya' Dios. Pūla napina' namāko'xami'xī'ya' ā'chā'tin ē ā'līstān nataspi'ta nalakahui'līya' tū ixlī'pimpā't. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Palh catīhuālh mālacapū'yān ē lē'ncu'tunān nac pūchihuīn, calacapāstacti chī palaj nalītalācāxla'ya' līhuan pimpā'na'ntit nac tej. Palh jā chuntza' natlahua'ya', a'cxni' minchā'tu'ca'n nachipinā'tittza', nalē'nān na ixlacatīn juez. Ū'tza' nalīmacamaxquī'yān policía ē xlaca'n natachī'yān ē natamānūyān nac pūlāchī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Icuaniyān jā nataxtuyāchi hasta a'cxni' naxokokō'ya' ixlīpō'ktu tū laclīpina'. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jesús cāhuanipālh: ―Hui'xina'n kexpa'tnī'ta'ntittza' chī ixuancan xapūla: “Jā catika'lhi' mintā'lāpāxquī'n.” ");
INSERT INTO tkuNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Quit iccāhuaniyān catīxcuhuālh tī nalaktzī'n chā'tin puscāt ē napuhuan natā'lhtatacu'tun, ū'tza' lacxtim hua'chi ixtā'lhtatanī'ttza' ixpālacata chuntza' lacapāstaca. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Palh milakastapun na milacapekcāna'j nalaktzī'n catīhuālh ē ū'tza' nalīmātlahuīyān tū jā tze, namāxtuya' ē namaka'na'. Jā tze palh napina' nac pūpātīn ixpālacata milakastapun. Ā'chulā' tze ī'sputni'n milakastapun ē namakapūtaxtūca'na'. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Palh mimacapekcāna'j natlahua tū jā tze, cacā'yuju' ē cama'ka'. Jā tze palh napina' nac pūpātīn ixpālacata mimacan. Ā'chulā' tze ī'sputni'n mimacan ē namakapūtaxtūca'na'. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jesús cāhuanipālh: ―Nā pūla ixuancan: “Catīhuālh tī namakxteka ixpuscāt ixlacasqui'nca naxapacan nac registro.” ");
INSERT INTO tkuNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Quit iccāhuaniyān palh puscāt jā ka'lhī ixtā'lāpāxquī'n a'cxni' naxapacan nac registro, ū'tza' jā tze quīlītaxtulh. Puscāt a'cxni' natamakaxtokpala, ū'tza' nahuanican ka'lhī ixtā'lāpāxquī'n. Chi'xcu' tī natā'tamakaxtoka tzamā' puscāt, nā xla' tzaj ixtā'lāpāxquī'n nahuan. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jesús cāhuanipālh: ―Nā kexpa'tnī'ta'ntittza' chī ixcāhuanican xamakāstza': “A'cxni' ixlīcāna' hua'na' natlahua'ya' catūhuālh, Dios laktzī'mā'n ē ixlacasqui'nca namākentaxtūya'.” ");
INSERT INTO tkuNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Quit iccāhuaniyān jā catihua'ntit: “Por Dios”, ixpālacata catūhuālh. Makapitzīn tahuan: “Por los cielos”, a'cxni' tacāxtlahua catūhuālh. Chuntza' jā tze. A'kapūn, a'ntza' jā Dios huī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ā'makapitzīn tahuan: “Por la tierra.” Chuntza' jā tze. Ti'ya't hua'chi jā Dios cāmājaxī ixtujan. Ā'makapitzīn huampala tahuan: “Por Jerusalén.” Chuntza' jā tze. Jerusalén, ū'tza' ixcā'lacchicni' Dios tī ā'chulā' xaka'tla'. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ā'makapitzīn huampala tahuan: “Por mi cabeza.” Chuntza' jā tze. Xmān Dios ca'tzī jā'cxni' napu'n ixa'ksasatca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ixlīcāna' calalh a'cxni' nahua'nā'tit “tze” o “jā tze.” Chuntza' jā ixlacasqui'nca ā'catūhuālh nahuampalayā'tit. Tzamā' ā'makapitzīn tachihuīn nacāquilhtaxtuyān ixpālacata skāhuī'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jesús cāhuanipālh: ―Hui'xina'n kexpa'tnī'ta'ntittza' chī pūla ixuancan: “Palh namātakāhuī'ya' ixlakastapun ā'chā'tin, nā hui'x nalīxoko'nu'na' milakastapun. Nalīxoko'nu'na' mintatzan ixtatzan ā'chā'tin tū māyujū'ni'nī'ta'.” ");
INSERT INTO tkuNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Quit iccāhuaniyān: Jā catimālakxokonī'tit tī cātlahuani'nī'ta'n tū jā tze. Palh catīhuālh nalacala'sān na milacapīn, natamakxteka' nalacala'sān ā'lacapī kentin. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Palh catīhuālh ixmālacapū'n ē namaktīcu'tunān milu'xu', nā natamakxteka' nalē'n minchamarra. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Palh catīhuālh ī'sāmācu'quī'ni' ixtacu'ca' a'ktin kilómetro, nacu'ca'pala'ya' ā'chuntza' ā'a'ktin kilómetro. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","A'cxni' catīhuālh nasqui'ni'yān catūhuālh, namaxquī'ya' ē jā xmān catitalakspi'tni' catīhuālh tī maksācua'cu'tunān. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jesús cāhuanipālh: ―Nā kexpa'tnī'ta'ntittza' chī pūla ixuancan: “Nacāpāxquī'ya' minamigos ē jā ixlacasqui'nca nacāpāxquī'ya' mintā'lāquiclhlaktzi'.” ");
INSERT INTO tkuNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Quit iccāhuaniyān: Cacāpāxquī'tit mintā'lāquiclhlaktzi'ca'n ē casqui'ni'tit Dios cacāsicua'lanātlahualh xlaca'n tī cātaquiclhlaktzī'nān. Cacāmaktāya'tit xlaca'n tī jā cātalaktzī'ncu'tunān ē catā'chihuīna'tit Dios ixpālacataca'n xlaca'n tī cātalakapalayān ē cātamakapātīnīnān. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Chuntza' lītasu'yu hui'xina'n ixlacstīn quinTāta'ca'n xala' nac a'kapūn. Dios hui'līnī't chi'chini' ē lacxtim talaktzī'n chi'chini' ixlīpō'ktuca'n tachi'xcuhuī't, masqui tī tze ē tī jā tze. Dios macamin xcān ixpālacata ixlīpō'ktuca'n tachi'xcuhuī't tī takexmata ē masqui tī jā takexmatcu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Palh xmān nacāpāxquī'yā'tit xlaca'n tī cātapāxquī'yān, ¿tīchu cuenta natlahua huā'mā'? Chuntza' tatlahua catīxcuhuālh ā'makapitzīn tī jā tze hua'chi mātā'jīni'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Palh xmān mintā'macchicca'n cātā'chihuīna'nā'tit, ¿ē tze tū tlahua'nī'ta'ntit? Xlaca'n tī jā tastālani' ixtej Dios nā chuntza' tatlahua. ");
INSERT INTO tkuNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ixlacasqui'nca hui'xina'n lactze nahuanā'tit lacxtim chī quinTāta'ca'n xala' nac a'kapūn. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesús cāhuanipālh: ―Palh natlahua'yā'tit tū tze o namaktāya'yā'tit ā'chā'tin ē ū'tza' nalīmākentaxtūyā'tit ixtalacasqui'nīn Dios, tzē'k natlahua'yā'tit. Jā catitlahua'tit cā'lhūhua'lacatīn ixpālacata lacasqui'nā'tit nacātalaktzī'nān. Palh cā'lhūhua'lacatīn natlahua'yā'tit, quinTāta'ca'n xala' nac a'kapūn jā tū caticāmaxquī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Chuntza' a'cxni' nacāmaktāya'yā'tit tī tamaclacasqui'n, jā caticāhua'ni'tit ā'makapitzīn tū tlahua'pā'na'ntit. Xlaca'n tī tatlahua a'ktu' ixlacanca'n tatlahua tū tze nac cā'tejen ē na ixtemploca'n israelitas. Chuntza' tatlahua ixpālacata tachi'xcuhuī't nacāmāka'tlī'. Ixlīcāna' tū iccāhuaniyān. A'cxni' cālaktzī'ncan, ū'tza' hua'chi ixtatlajca'n tū natamaktīni'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Hui'xina'n, a'cxni' nacāmaktāya'yā'tit tī tamaclacasqui'n, jā catimakxtektit jā tī chā'tin naca'tzī chī cāmaktāya'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ā'chulā' tze tzē'k nacāmaktāya'yā'tit. QuinTāta'ca'n nalaktzī'n tū tzē'k tlahua'yā'tit ē xla' nacāmaxquī'yān mintatlajca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jesús cāhuanipālh: ―Makatunu' na'orarlīni'yā'tit Dios, jā catitlahua'tit chī tatlahua xlaca'n tī tatlahua a'ktu' ixlacanca'n. Xlaca'n tatāya na ixtemploca'n israelitas ē nac cā'tejen jā nacālaktzī'ncan a'cxni' ta'orarlīmā'nalh. Ixlīcāna' tū iccāhuaniyān. A'cxni' cālaktzī'ncan, ū'tza' hua'chi ixtatlajca'n tū natamaktīni'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","A'cxni' hui'xina'n na'orarlīyā'tit, catanū'tit na minchicca'n ē camālacchahua'tit ē mina'cstuca'n na'orarlīyā'tit ē natā'chihuīna'nā'tit quinTāta'ca'n a'ntza' jā jā tī nalaktzī'nān. QuinTāta'ca'n xala' nac a'kapūn nalaktzī'n tū tzē'k natlahua'yā'tit ē xla' nacāmaxquī'yān mintatlajca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Calacapāstactit a'cxni' natlahua'yā'tit minoracionca'n, ē jā maklhūhua' cahua'mpala'tit. Chuntza' tatlahua tzamā' tī jā talakapasa Dios. Tapuhuan Dios nacākexmata ixpālacata lhūhua' tachihuīn. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Jā catila'tit chī xlaca'n. QuinTāta'ca'n nac a'kapūn ca'tzītza' tū hui'xina'n maclacasqui'nā'tit a'cxni' jāna'j squi'ni'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Chuntza' natā'chihuīna'nā'tit Dios: QuinTāta'ca'n tī hui'lachi nac a'kapūn, calakachi'xcuhuī'ca'. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Camilh a'cxni' natzucuya' nacāmāpa'ksī'kō'ya'. Catlahuaca mintalacasqui'nīn huā'tzā' nac cā'ti'ya'tna' chuntza' chī nac a'kapūn. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Caquilāmaxquī'uj chuhua'j quilīhua'tca'n tū icmaclacasqui'nāuj. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Caquilāmātza'nkēna'ni'uj tū iccāmaklaclē'nān chuntza' chī iccāmātza'nkēna'ni'yāuj ū'tunu'n tī quincātamaklaclē'nān. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Jā camakxtekti tū naquincā'a'kspulayān naquincāmātlahuīyān tū jā tze. Xmān hui'x xaMāpa'ksīni' ē mila' ixlīpō'ktu lītli'hui'qui ē ixlīpō'ktuca'n natamakapāxuīyān pō'ktu quilhtamacuj. Amén. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Palh hui'xina'n nacāmātza'nkēna'ni'yā'tit ā'makapitzīn tī cātatlahuani'yān tū jā tze, nā quinTāta'ca'n xala' nac a'kapūn nā nacāmātza'nkēna'ni'yān tū tlahuanī'ta'ntit tū jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Palh hui'xina'n jā nacāmātza'nkēna'ni'yā'tit ā'makapitzīn, jā caticāmātza'nkēna'ni'n mincuentaca'n quinTāta'ca'n xala' nac a'kapūn. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jesús cāhuanipālh: ―A'cxni' jā catihuā'ya'ntit pō'ktu quilhtamacuj ixpālacata orarlīni'cu'tunā'tit Dios, jā catila'tit chī xlaca'n tī tatlahua a'ktu' ixlacanca'n. Xlaca'n ta'a'cpūtahua'ca' lhca'ca'n ē jā talakacha'ka'n. Nacālaktzī'ncan ē ū'tza' nalīca'tzīcan jā tahuā'yan. Ixlīcāna' tū iccāhuaniyān. Xlaca'n taka'lhītza' ixtatlajca'n a'cxni' tasu'yu jā tahuā'yalh. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Hui'xina'n jā catitlahua'tit chuntza'. A'cxni' jā huā'ya'nā'tit pō'ktu quilhtamacuj ē na'orarlīyā'tit, calakacha'ka'ntit ē tzej calacxqui'ttit miya'jca'n ");
INSERT INTO tkuNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ē chuntza' jā catica'tzīca palh jā huā'ya'nā'tit. Xmān quinTāta'ca'n xala' nac a'kapūn naca'tzī tū tzē'k tlahua'yā'tit ē xla' nacāmaxquī'yān mintatlajca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jesús cāhuanipālh: ―Jā catilacasqui'ntit lhūhua' tumīn ē catūhuālh xala' nac huā'mā' cā'quilhtamacuj. Tzī'ya' ē xumpepe tzē natamālaksputū tū xala' nac cā'quilhtamacuj. Tzē naka'lhancan mintumīnca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ā'chulā' tze calacasqui'ntit tū milaca'n nahuan nac a'kapūn. A'ntza' tzī'ya' ē xumpepe jāla catitamālaksputūlh ē jāla catitatanūlh ka'lhāna'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Pō'ktu quilhtamacuj lacapāstaclacapinā'tit jā huī'lh tū ā'chulā' cālīmacuani'yān. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Jesús cāhuanipālh: ―Milakastapunca'n hua'chi a'ktin tū māxkakē mimacni'ca'n. Palh jā tampi'lhīni'nā'tit ē palh laktzī'nā'tit tū tamaclacasqui'n ā'makapitzīn, ū'tza' hua'chi tze milakastapunca'n ē hua'chi pō'ktu taxkaket na mimacni'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Palh xmān laktzī'nā'tit tū maclacasqui'nā'tit hui'xina'n mina'cstuca'n, lactampi'lhīn lītaxtuyā'tit. Ū'tza' hua'chi jā tze milakastapunca'n ē hua'chi pō'ktu cā'pucsua' na mimacni'ca'n. Palh jā tze ixmāxkakēni' mimacni'ca'n, ā'chulā' cā'pucsua' nahuan. A'ntza' jā cā'pucsua' jā tasu'yucan jā pe'a'ncan. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Jesús cāhuanipālh: ―Chā'tin chi'xcu' jāla chu lacxtim catitā'scujli chā'tu' ixpatrón. Napāxquī' chā'tin ē jā catilaktzī'ncu'tunlī ā'chā'tin. Nakexmatni' chā'tin ē nalakmaka'n ā'chā'tin. Nā chuntza' hui'xina'n jāla nalīpāhua'nā'tit Dios palh nalīpāhua'nā'tit mintumīnca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jesús cāhuanipālh: ―Ū'tza' iccālīhuaniyān chuhua'j. Jā tilī'a'ktuyunā'tit tū nahua'yā'tit ē chī nalīlatahui'layā'tit. Jā tilī'a'ktuyunā'tit tū nalīlhakā'nanā'tit. Dios cāmaxquī'yān milīhua'tca'n ē mimacni'ca'n tū tzē nalīscujā'tit, ē ā'chulā' nacāmaxquī'yān tū namaclacasqui'nā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Cuenta cacātlahua'tit spūnī'n tū takosnū'n. Xlaca'n jā tacha'nāna'n, nūn tamakalanāna'n ē jā taka'lhī ixpūcuxi'ca'n. QuinTāta'ca'n xala' nac a'kapūn cāmāhuī'. Hui'xina'n ā'chulā' mintapalhca'n ē jā spūnī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Tīchu na milacpu'na'i'tātca'n tzē natahui'la ā'chulā' makās xmān ixpālacata nalī'a'ktuyunā'tit? ");
INSERT INTO tkuNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Tū ixpālacata cālī'a'ktuyunā'tit milu'xu'ca'n tū nalhakā'yā'tit? Camaksca'ttit xa'nat chī natalīstaca nac cā'tacuxtu. Jā tascuja ē jā tatza'pa' ixlu'xu'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tzēhuanī't tastaca masqui jā tū tatlahua. Iccāhuaniyān rey Salomón jāla cāmālakchā'nī ixlītzēhuanī't xa'nat ē xla' rico ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","A'nan pa'lhma' nac cā'tacuxtu tū tzēhuanī't. Lakalī tū'xama'n nacā'ī'can ē nacālhcuyucan. Dios cāmaktaka'lha ē cāmakastaca pa'lhma' tū palaj nascāca ē ā'chulā' tzej nacāmaktaka'lhān hui'xina'n. ¿Tū ixpālacata jā a'ka'ī'yā'tit huā'mā'? ");
INSERT INTO tkuNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Chuntza' jā tilī'a'ktuyunā'tit ē jā catihuantit: “¿Tūchu nahua'yāuj? ¿Tūchu nalīko'tnunāuj? ¿Chī na'iclīlhakā'nanāuj?” ");
INSERT INTO tkuNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tachi'xcuhuī't xalanī'n nac cā'quilhtamacuj pō'ktu quilhtamacuj chuntza' tahuan ē pō'ktu quilhtamacuj chuntza' tapuhuan. Hui'xina'n ka'lhī'yā'tit chā'tin minTāta'ca'n nac a'kapūn ē xla' tzej ca'tzī tū maclacasqui'nā'tit lakalīyān. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Xatze caputzatit pūla chī nacālīmāpa'ksīkō'yān Dios ē nā caputzatit chī nalīmakapāxuhuī'yā'tit Dios. Xla' nacāmaxquī'yān ixlīpō'ktu tū maclacasqui'nā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Jā catitamakchuyī'tit chuhua'j tū nacā'a'kspulayān lakalī. Chuntza' jāla tzej scuja'tit huā'mā' quilhtamacuj. Ixlīlakalī nalī'a'ktuyunātit. ");
INSERT INTO tkuNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesús cāhuanipālh: ―Jā caticāputzāna'ni'yā'tit ā'makapitzīn ē Dios jā nacāputzāna'ni'yān. ");
INSERT INTO tkuNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Chuntza' chī hui'xina'n cāputzāna'ni'yā'tit ā'makapitzīn, chu lacxtim Dios nacāputzāna'ni'yān. Palh hui'xina'n nalāmātza'nkēna'ni'yā'tit, nā Dios nacāmātza'nkēna'ni'yān. ");
INSERT INTO tkuNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Chī tzē nalaktzī'na' macsti'na'j pa'lhxtum na ixlakastapun mintā'tin palh tanūmā'lh hua'chi a'ktin qui'hui' na milakastapun? ");
INSERT INTO tkuNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Palh jā pūla namāxtuya' qui'hui' na milakastapun, jāla catima'xtuni' pa'lhxtum na ixlakastapun mintā'tin. ");
INSERT INTO tkuNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡A'kskāhuī'nīnā'tit! Palh hui'x tlahua'ya' tū jā tze, jāla cati'a'ksa'nti ā'chā'tin tī tlahua tū jā tze. Ixlacasqui'nca cuenta natlahua'ya' pūla chī latā'kchokoya' hui'x ē chuntza' tzē namaktāya'ya' ā'chā'tin tzej nalatā'kchoko. ");
INSERT INTO tkuNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’A'nan tachi'xcuhuī't tī ixtāyatca'n jā tze ixtalacapāstacni'ca'n. Palh xlaca'n jā tunca takexmatcu'tun ixtachihuīn Dios, jā caticāmāsu'yuni'tit. Xmān natasītzī' ē nacātatucscu'tunān hua'chi chichi' tū xcana'n. Xatasicua'lanātlahua ixtachihuīn Dios. Palh tachi'xcuhuī't jā takexmatcu'tun, jā caticāmāsu'yuni'tit xlaca'n. Jā catitalakachi'xcuhuī'lh ixtachihuīn Dios. Xlaca'n hua'chi lakatin pa'xni' tū nalacchi'nta tū tapalaxla'. ");
INSERT INTO tkuNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jesús cāhuanipālh: ―Casqui'ni'tit Dios ē xla' nacāmaxquī'yān. Caputzatit tū Dios cāmaxquī'cu'tunān ē namacla'yā'tit. Camacasā'na'ntit nac mākelhcha ē nacātamālaquī'ni'yān. ");
INSERT INTO tkuNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Chuntza' tī nasqui'ni' Dios, ū'tza' namaktīni'n ē tī naputza tū Dios namaxquī', xla' namacla. Tī namacasā'na'n nac mākelhcha, namālaquī'ni'can. ");
INSERT INTO tkuNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Hui'xina'n ka'lhī'yā'tit mincamana'ca'n. Palh chā'tin minka'hua'cha nasqui'ni'yān pāntzīn, ¿ē namaxquī'ya' a'ktin chihuix? ");
INSERT INTO tkuNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Palh nasqui'ni'yān squī'ti', ¿ē namaxquī'ya' lūhua'? ");
INSERT INTO tkuNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Hui'xina'n masqui jā tzej ca'tzīyā'tit, tzē nacāmaxquī'yā'tit talakalhu'mān milacstīnca'n. Ā'chulā' minTātaca'n tī hui'lacha' nac a'kapūn nacāmaxquī' tū xatze tī tasqui'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Chuntza' cacātlahua'ni'tit ā'makapitzīn chuntza' chī lacasqui'nā'tit xlaca'n nacātatlahuani'yān. Ū'tza' huā'mā' tū huanicu'tun ixlīmāpa'ksīn Moisés ē ū'tza' ixtamāsu'yunca'n a'kchihuīna'nī'n chī tatzo'kni' na ixtachihuīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Jesús cāhuanipālh: ―A'nan a'ktu' mākelhcha ē kentu' tej. Natanū'yā'tit nac xapītzuna'j mākelhcha jā mā'lh pītzuna'j tej. Pīka'tla' mā'lh tej tū a'n nac pūpātīn ē pīka'tla' xamākelhcha. Līlhūhua' tī natatanūyācha'. ");
INSERT INTO tkuNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pītzuna'j tej a'n nac a'kapūn jā natahui'layāuj pō'ktu quilhtamacuj. Jicslīhua' a'ncan. Nā pītzuna'j xamākelhcha. Jā a'nan lhūhua' tī natamacla ē natatanūyācha'. ");
INSERT INTO tkuNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jesús cāhuanipālh: ―Cuenta catlahua'tit tī tahuan palh ixa'kchihuīna'nī'n Dios ē xmān ta'a'kskāhuī'nin. Xlaca'n hua'chi lobo tū taputzamā'nalh ixlīhua'tca'n ē talhakā'nanī't hua'chi purecu'. ");
INSERT INTO tkuNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Tzē nacālīlakapasā'tit chī natalatā'kchoko. Jāla cāpu'xcan uvas nac cā'lhtucū'n ē jā tī cāpu'xa higos nac lhtucū' qui'hui'. ");
INSERT INTO tkuNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Chuntza' xatze qui'hui' namāstā' xatze ixtahua'ca't ē tzēhuanī't. Tū jā tze qui'hui' jā tze ixtahua'ca't. ");
INSERT INTO tkuNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Xatze qui'hui' jā catimāstā'lh ixtahua'ca't tū jā tze. Ē tū jā tze qui'hui' jāla catimāstā'lh xatze ixtahua'ca't. ");
INSERT INTO tkuNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Palh qui'hui' jā namāstā' xatze ixtahua'ca't, nacā'can ē nalhcuyucan. ");
INSERT INTO tkuNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Chuntza' hui'xina'n nacālīlakapasā'tit a'kchihuīna'nī'n tī ta'a'kskāhuī'nin. Xlaca'n jā tzej talatā'kchoko. ");
INSERT INTO tkuNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Jesús cāhuanipālh: ―Lhūhua' a'nan tī naquintamāpācuhuī: “QuiMāpa'ksīni'.” Ū'tza' jā huanicu'tun natatanū jā Dios māpa'ksīni'nkō'. Xmān tzē natatanūyācha' xlaca'n tī tatlahua ixtalacasqui'nīn quinTāta'ca'n xala' nac a'kapūn. ");
INSERT INTO tkuNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","A'cxni' namin ā'xmān quilhtamacuj, līlhūhua' naquintahuani: “QuiMāpa'ksīni'ca'n, quina'n iclīmāsu'yūj ixtachihuīn Dios milītli'hui'qui. Nā milītli'hui'qui iccālīmāxtūj jā tzeya ū'nī'n. Nā lhūhua' lī'a'cnīn iccālītlahuáuj milītli'hui'qui”, natahuan. ");
INSERT INTO tkuNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Palaj tunca na'iccāhuan: “Jā iccālakapasān. Caquilātapānūni'uj. Hui'xina'n tlahua'yā'tit tū jā tze.” ");
INSERT INTO tkuNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jesús cāhuanipālh: ―Chuntza' tī quinkexmata ē natlahua tū icmāsu'yu, xla' tzej tlā'huan na ixtej Dios ē natāyani' masqui napātīni'n. Chuntza' nala hua'chi chā'tin chi'xcu' tī pūlhmā'n yāhualh xatantūn ixchic. ");
INSERT INTO tkuNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Masqui milh lhūhua' xcān ē palha' ū'ni' sno'kli chic, tāyani'lh ē jā maka'a'nīlh. ");
INSERT INTO tkuNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Tī quinkexmata ē jā natlahua tū icmāsu'yu, xla' jāla catitāyani'lh. Chuntza' nala hua'chi chā'tin chi'xcu' tī xalhkēnti ixuanī't ē jā pūlhmā'n yāhualh xatantūn. ");
INSERT INTO tkuNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","A'cxni' lalh xcān ē milh palha' ū'ni' tū sno'kli chic, jā tāyani'lh. Maka'a'nīlh ē laclakō'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","A'cxni' Jesús cāhuanikō'lh tzamā', tachi'xcuhuī't talī'a'cnīlh tzamā' tamāsu'yun. ");
INSERT INTO tkuNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Xla' cāmāsu'yuni'lh hua'chi tī ka'lhī līmāpa'ksīn, ē jā hua'chi xamākelhtahua'kē'ni'nī'n līmāpa'ksīn. Xlaca'n xmān ixtamāsu'yu tū tamaksca'tli. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","A'cxni' Jesús lacyujli nac sipej, lhūhua' tachi'xcuhuī't tastālani'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Laktalacatzuna'jīlh chā'tin ta'jatatlani'. Ixka'lhī ta'jatat tū huanican lepra ē ū'tza' tū māmasī quinquinītca'n. Ta'jatatlani' tatzokostani'lh Jesús ē huanilh: ―Māpa'ksīni', palh hui'x lacasqui'na', tzē naquimātzeyī'ya'. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Palaj tunca Jesús xa'malh ē huanilh: ―Chuntza' quit iclacasqui'n. Catzeya'nti. A'cxni' huanli huā'mā', tapānūni'lh ixta'jatat. Tzetza' ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesús huanilh: ―Catamaktaka'lhti ē jā tī chā'tin tihua'ni'ya'. Xmān calakpi ixpālejca'n israelitas ē camā'su'yuni' mimacni'. Xla' nalaktzī'n palh tzeyanī'ta'tza'. Nalīlakatāyana'na' chuntza' chī māpa'ksīni'lh Moisés. Chuntza' nataca'tzī tachi'xcuhuī't tzeyanī'ta'tza'. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","A'cxni' Jesús tanūlh nac cā'lacchicni' Capernaum, laktalacatzuna'jīlh chā'tin ixcapitanca'n soldados romanos. Squi'ni'lh camaktāyalh ");
INSERT INTO tkuNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ē huanilh: ―Māpa'ksīni', ta'jatatla quintasācua' ē mā'lh na quinchic. Xcāhuī'huananī't ē pātīni'mā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús huanilh: ―Na'ica'n na'icmātzeyī. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Capitán kelhtīlh: ―Māpa'ksīni', hui'x ka'lhī'ya' līmāpa'ksīn ē jā minī'ni' natanū'ya' na quinchic. Xmān namāpa'ksī'ya' ē natzeyan quintasācua'. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ā'nā quit quintamāpa'ksī xanapuxcu'nu' ē nā quit iccāmāpa'ksī quisoldados. A'cxni' na'icuani chā'tin soldado ca'a'lh, xla' na'a'n. A'cxni' na'icuani ā'chā'tin camilh, xla' namin. A'cxni' na'icuani quintasācua' catlahualh catūhuālh, xla' natlahua tū icuani. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","A'cxni' Jesús kexmatli huā'mā' tachihuīn, lī'a'cnīlh. Cāhuanilh tī ixtastālani'tēlha: ―Ixlīcāna' tū iccāhuaniyān. Jā iclakapasa jā tī chā'tin israelita tī quina'ka'ī'ni' chī huā'mā' chi'xcu'. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nā iccāhuaniyān natamin lhūhua' xalanī'n ixtankēn ē nā lhūhua' xalanī'n na ixlītā'cnun. Xlaca'n, masqui jā israelitas, xlaca'n nacātā'huā'yan Abraham ē Isaac ē Jacob jā Dios māpa'ksīni'nkō'. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ā'makapitzīn masqui israelitas, xlaca'n nacāmacā'ncan nac kēpūn a'ntza' jā cā'pucsua'. A'ntza' natacalhuan ē natalāxca ixtatzanca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Palaj tunca Jesús huanilh capitán: ―Capit na minchic. Chuntza' chī a'ka'ī'nī'ta', chuntza' natlahuani'ca'na'. Tzamā' puntzuna' mātzeyīlh ixtasācua'. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesús a'lh na ixchic Pedro ē a'ntza' laktzī'lh ixpuhuiti'. Ixmacscutlamā'lh ē ixmā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesús xa'mani'lh ixmacan ē tapānūni'lh macscut. Tā'kaquī'lh tzamā' puscāt ē tzuculh cāmāhuī'. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","A'cxni' ī'smalanka'namā'lhtza', cālīmini'ca Jesús lhūhua' tī ixtaka'lhī jā tzeya ū'nī'n. Xla' xmān māpa'ksīlh ē chuntza' cāmāxtulh jā tzeya ū'nī'n. Nā cāmātzeyīlh lhūhua' ta'jatatlanī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ū'tza' huā'mā' a'kspulalh ē mākentaxtūlh chī a'kchihuīna'nli profeta Isaías a'cxni' huanli huā'mā': “Xla' māpānūlh quinta'jatatca'n quina'n ē nā chī ī'xlajua'nanāuj.” ");
INSERT INTO tkuNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","A'cxni' Jesús cālaktzī'lh lhūhua' tachi'xcuhuī't tī ixtalītamacsti'li'mā'nalh, māpa'ksīlh ē lē'nca ixtuntacut ka'tla' xcān nac barco. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Chā'tin xamākelhtahua'kē'ni' līmāpa'ksīn laktalacatzuna'jīlh Jesús ē huanilh: ―Mākelhtahua'kē'ni', ictā'a'ncu'tunān calhāxcuhuālh jā napina'. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús kelhtīlh: ―Tanquihui' taka'lhī ixlhu'cu'ca'n ē spūnī'n taka'lhī ixmāsekca'n. Quit Chi'xcu' xala' Tālhmā'n ē quit jā icka'lhī quinchic jā na'iclhtata. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ā'chā'tin tī ī'scujni' ixuanī't, xla' huanilh: ―Māpa'ksīni', caquimakxtekti na'ictahui'la na quinchic hasta a'cxni' namā'cnūcan quintāta'. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús kelhtīlh: ―Caquistāla'ni'. Xlaca'n tī jā ta'a'ka'ī' tzē natamā'cnū mintāta'. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Palaj tunca Jesús tojōlh a'ktin nac barco ē tatā'tojōlh ī'scujnu'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","A'cxni' ixtatacutmā'nalh, xamaktin tzuculh palha' ū'nun ē ixlītatzumamā'lhtza' xcān barco. Jesús ī'lhtatamā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Palaj tunca ta'a'lh tamālakahuānīlh ē tahuanilh: ―¡Māpa'ksīni', caquilāmakapūtaxtūj! ¡Tā'ktzīmā'naujtza'! ");
INSERT INTO tkuNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesús cākelhtīlh: ―¿Tū ixpālacata jicua'nā'tit? ¡Jā tzej a'ka'ī'yā'tit! Palaj tunca tā'kaquī'lh ē cālacaquilhnīlh ū'ni' ē mar. Chuntza' ca'cslalh. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Chi'xcuhuī'n talī'a'cnīlh ē tahuanli: ―¿Tichūyā chi'xcu' xla'? ¡Hasta tzē cāmāpa'ksī ū'ni' ē mar ē takexmatni'! ");
INSERT INTO tkuNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ixtuntacut nac xcān ixuī'lh a'ktin ti'ya't jā huanican Gadara. A'cxni' Jesús chā'lh a'ntza', tatalacatzuna'jīlh chā'tu' chi'xcuhuī'n tī ixtahui'lāna'ncha' nac lhu'cu'. Ixchā'tu'ca'n ixtaka'lhī jā tzeya ū'nī'n ē ixtachuyā ē ixtamekē'klhana'n. Jā tī chā'tin ixtatētaxtucu'tun a'ntza' ixpālacataca'n tzamā' chā'tu'. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tatzuculh tata'sa ē tahuanli: ―Icca'tzīyāuj hui'x ī'Ska'ta' Dios. ¿Ē mincuenta tū ictlahuamā'nāuj? ¿Ē ta't naquilāmakapātīnīnāuj a'cxni' jāna'j lakchā'n quilhtamacuj tū līlhcānancanī't? ");
INSERT INTO tkuNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Jā makat a'ntza' ixtahuā'yamā'nalh lhūhua' pa'xnī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Jā tzeya ū'nī'n tasqui'ni'lh Jesús: ―Palh naquilāmāxtuyāuj na ixpūlacni'ca'n chi'xcuhuī'n, caquilāmakxtekui na'ictanūyāuj na ixpūlacni'ca'n tzamā' pa'xnī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Palaj tunca Jesús cāhuanilh: ―Capintittza'. Jā tzeya ū'nī'n cāpūlactaxtulh chi'xcuhuī'n ē tapūlactajōlh na ixpūlacni'ca'n lhūhua' pa'xnī'n. Palaj tunca lhūhua' pa'xnī'n tatu'jnuntēlha ta'a'lh nac cā'lacatampān ē tatojōcha' nac xcān ē a'ntza' tajicsua'kō'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Chi'xcuhuī'n tī ixtamaktaka'lhmā'nalh lhūhua' pa'xnī'n, xlaca'n tajicua'nli ē tatu'jnulh nac cā'lacchicni'. A'cxni' tachā'lh, tahuankō'lh ixlīpō'ktu tū cā'a'kspulalh chi'xcuhuī'n tī ixtaka'lhī jā tzeya ū'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Palaj tunca ixlīpō'ktuca'n xalanī'n tzamā' cā'lacchicni' talaka'lh Jesús jā ixuī'lh. A'cxni' tachā'lh a'ntza', tasqui'ni'lh Jesús cataxtulh na ixti'ya'tca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Palaj tunca Jesús tojōlh a'ktin nac barco ē a'lh ixtuntacut nac xcān ē chā'lh nac Capernaum jā nā ixcā'lacchicni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Līmini'cancha' chā'tin chi'xcu' tī ī'xcāhuī'huananī't ē tī ixmā'lh na ixtalajni'. A'cxni' Jesús laktzī'lh chī ixta'a'ka'ī'ni' ixlītli'hui'qui, xla' huanilh ta'jatatlani': ―Catahui'xcāni', quinka'hua'cha. Quit icmātza'nkēna'ni'kō'yān mincuenta. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Palaj tunca makapitzīn xamākelhtahua'kē'ni'nī'n līmāpa'ksīn tapuhuanli: “Huā'mā' chi'xcu' mālakchā'nīmā'lh Dios. Nūn tī chā'tin chi'xcu' tzē naquincāmātza'nkēna'ni'yān quincuentaca'n, xmān Dios.” ");
INSERT INTO tkuNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesús ixca'tzī chī ixtapuhuamā'nalh ē ū'tza' cālīhuanilh: ―¿Tū ixpālacata puhua'nā'tit chuntza' na milīstacna'ca'n? ");
INSERT INTO tkuNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Icuanilhtza' ta'jatatlani': “Icmātza'nkēna'ni'kō'yān mincuenta.” Jā tū tasu'yu masqui mātza'nkēna'ni'catza'. Palh xa'icuanilh: “Catā'kaqui' ē casmi'li' mipūtama' ē catlā'hua'nti”, chuntza' ixlītasu'yulh palh ixlīcāna' tzeyanli. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Quit Chi'xcu' xala' Tālhmā'n. Chuhua'j na'iccālīmāsu'yuni'yān chī icka'lhī līmāpa'ksīn huā'tzā' nac cā'quilhtamacuj ē tzē na'iccāmātza'nkēna'ni' ixcuentaca'n tachi'xcuhuī't. Palaj tunca Jesús huanilh chi'xcu' tī ī'xcāhuī'huananī't: ―Catā'kaqui' ē casmi'li' mipūtama' ē capit na minchic. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Palaj tunca chi'xcu' tā'kaquī'lh ē lē'lh ixpūtama' ē a'lh na ixchic. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tachi'xcuhuī't, a'cxni' talaktzī'lh huā'mā', tajicua'nli. Tamakapāxuīlh Dios tī ixcāmaxquī'nī't huā'mā' līmāpa'ksīn chi'xcuhuī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","A'cxni' Jesús ixtaxtumā'lh a'ntza', laktzī'lh chā'tin chi'xcu' tī ixuanican Mateo. Xla' ixuī'lh jā ixmātā'jīni'ncan līxokot ē huanica: ―Caquistāla'ni'. Palaj tunca Mateo tāyalh ē stālani'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","A'cxni' Jesús ixuā'yamā'lh na ixchic Mateo, tachā'lh lhūhua' mātā'jīni'nī'n ē ā'makapitzīn tī jā tzeya chi'xcuhuī'n. Ixlīpō'ktuca'n ixcātā'huā'yamā'lh Jesús ē ī'scujnu'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","A'cxni' makapitzīn fariseos talaktzī'lh huā'mā', xlaca'n takelhasqui'nīlh ī'scujnu'nī'n Jesús: ―¿Tū ixpālacata mimākelhtahua'kē'ni'ca'n cātā'huā'yan mātā'jīni'nī'n ē ā'makapitzīn tī jā tzeya chi'xcuhuī'n? ");
INSERT INTO tkuNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús kexmatli huā'mā' tachihuīn ē cāhuanilh: ―Xlaca'n tī jā tata'jatatla jā tamaclacasqui'n doctor. Xmān ta'jatatlani' tamaclacasqui'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Capintit ē casca'ttit tū huanicu'tun huā'mā' tū tzo'kcanī't na ixtachihuīn Dios: “Quit ā'chulā' iclacasqui'n nacālakalhu'ma'nā'tit ā'makapitzīn. Jā iclacasqui'n naquilālakahui'līyāuj animalh.” Chuntza' tzo'kcanī't. Quit jā icmilh iccāputza tī tapuhuan xlaca'n lactze. Icmilh iccāputza tachi'xcuhuī't tī taca'tzī jā lactze xlaca'n ē chuntza' natalakpalī ixtalacapāstacni'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ā'līstān tī ixtastālani' Juan Mā'kpaxīni', xlaca'n talakmilh Jesús. Takelhasqui'nīlh: ―Quina'n ē fariseos maklhūhua' jā icuā'yanāuj pō'ktu quilhtamacuj ixpālacata Dios. ¿Tū ixpālacata miscujnu'nī'n pō'ktu quilhtamacuj tahuā'yan? ");
INSERT INTO tkuNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús cākelhtīlh: ―¿Ē natalīpuhuan tī cā'invitarlīcan jā tamakaxtokmā'ca? Līhuan cātā'lahuī'lhcus squi'nīni', jā talīpuhuan. Namin a'ktin quilhtamacuj a'cxni' nalē'ncan squi'nīni' ē a'cxni' natalīpuhuan ē jā catitahuā'yalh ixamigos. (A'cxni' Jesús cāhuanilh huā'mā', ixa'cstu ixlīchihuīna'mā'ca.) ");
INSERT INTO tkuNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Jesús cāhuanipālh: ―Jā tī nasita xasāsti' lu'xu' nalīlactza'pa' tū xamasni'tza'. Xasāsti' lu'xu' natā'timī ē ā'chulā' naxtī'ta xamasni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Xaxcān uva tū jā xaxcu'ta jā tī chā'tin catipūmojōlh xamasni' ixko'xka' purecu'. Namojōcan xasāsti' nac ko'xka' ē a'cxni' naxcu'tan, jā catipankli ko'xka'. Chuntza' jā pāxcat catihuanli ko'xka' ē jā catitaxtuni'lh xaxcān uva ―cāhuanilh Jesús. (Ū'tza' huā'mā' līchihuīna'mā'lh ixtamāsu'yunca'n israelitas ē ixtamāsu'yun Jesús tū xasāsti'.) ");
INSERT INTO tkuNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Līhuan Jesús ixcāhuanimā'lh huā'mā', chā'lh chā'tin xapuxcu' israelitas. Xla' tatzokostani'lh na ixlacatīn Jesús ē huanilh: ―Nīlhcus quintzu'ma'jāt. Masqui nīlhtza', palh hui'x napina' ē namacaxa'ma'ya', xla' nalacastālancuana'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesús tāyalh ē tā'a'lh chi'xcu'. Nā ī'scujnu'nī'n nā tatā'a'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Palaj tunca milh chā'tin puscāt tī ixta'jatatla. Ixka'lhītza' a'kcāujtu' cā'ta jāla ixcāsni' ixka'lhni'. Laktalacatzuna'jīlh ixchakēn Jesús ē xa'mani'lh ixquilhtūn ixlu'xu'. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Puhuanli chuntza': “Xmān ca'icxa'mani'lh ixlu'xu' ē na'ictzeyan”, puhuanli. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesús talakspi'tli ē laktzī'lh puscāt ē huanilh: ―Catahui'xcāni', quintzu'ma'jāt. Tzeyanī'ta'tza' ixpālacata a'ka'ī'nī'ta'. Xlītza'la tzeyanli tunca. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","A'cxni' Jesús chā'lh na ixchic xapuxcu' israelitas, cālaktzī'lh músicos tī natatā'a'n a'cxni' namā'cnūcan. Tachi'xcuhuī't ixtata'samā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesús cāhuanilh: ―Catapānū'tit huā'tzā'. Tzu'ma'jāt jā nīnī't. Xmān lhtatamā'lh. Xlaca'n talīlītzī'nli. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","A'cxni' Jesús cāmāxtukō'lh tachi'xcuhuī't, xla' tanūlh jā ixmā'lh tzu'ma'jāt ē macachi'palh. Tzu'ma'jāt tā'kaquī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Calhāxcuhuālh ixā'tun tamacni' a'kahuanli tū a'kspulalh tzu'ma'jāt. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","A'cxni' Jesús ixtaxtumā'lh a'ntza', tatzuculh tastālani' chā'tu' lakatzī'nī'n. Palha' tahuanilh: ―¡Caquilālakalhu'manui, hui'x tī ixtā'nat David! ");
INSERT INTO tkuNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","A'cxni' Jesús tanūlh nac chic, lakatzī'nī'n tatalacatzuna'jīlh. Xla' cākelhasqui'nīlh: ―¿Ē a'ka'ī'yā'tit tzē na'iccāmālacahuānīyān? Takelhtīlh: ―Chuntza' ica'ka'ī'yāuj, Māpa'ksīni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Palaj tunca Jesús cāxa'mani'lh ixlakastapunca'n ē cāhuanilh: ―Calalh chuntza' chī a'ka'ī'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tatzeyalh ixlakastapunca'n ē talacahuāna'lh. Palaj tunca Jesús cāmāpa'ksīlh: ―Tzē'k caca'tzītit ē jā tī chā'tin namāca'tzīnī'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Masqui chuntza' cāhuanica, a'cxni' tataxtulh xlaca'n tatzuculh tahuani chā'tin chā'tin tū cātlahuani'lh Jesús. Ū'tza' talīca'tzīkō'lh calhāxcuhuālh nac huā'mā' ti'ya't. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","A'cxni' jāna'j ixtataxtu tī lakatzī'nī'n ixtahuanī't, a'cxni' līmini'ca Jesús chā'tin kō'ko'. Kō'ko' ixka'lhī jā tzeya ū'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","A'cxni' Jesús māxtulh jā tzeya ū'ni', palaj tunca tzuculh chihuīna'n kō'ko'. Tachi'xcuhuī't talī'a'cnīlh ē tahuanli: ―Jā maktin iclaktzī'nī'tauj ixtā'chuntza' huā'mā' na quinti'ya'tca'n israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseos, xlaca'n ixtahuan: ―Huā'mā' chi'xcu' ka'lhī ixlīmāpa'ksīn tī xapuxcu' jā tzeya ū'nī'n. Ū'tza' cālīmāxtulh jā tzeya ū'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús ixtētaxtutēlha a'katunu' nac cā'lacchicni' ē ranchujnu'. Ixtētanūtēlha a'katunu' na ixtemploca'n israelitas ē ixmāsu'yu. Ixcā'a'kchihuīna'ni' chī nala jā Dios māpa'ksīni'nkō'. Nā ixcāmātzeyī catūhuālh ta'jatat ē taca'tzanajuāt. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","A'cxni' cālaktzī'lh tachi'xcuhuī't, cālakalhu'manli ixpālacata ixcālī'a'ktuyumā'lh ē ixtaxlajuanani'. Cālaktzī'lh hua'chi purecu' tī jā ixtaka'lhī ixmaktaka'lhna'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jesús cāhuanilh ī'scujnu'nī'n: ―Ixlīcāna' lhūhua' a'nan tī ta'a'ka'ī'cu'tun. Xlaca'n ixtā'chuntza' jā sputacus tasācua'n tī nata'ī'nin ē lhūhua' lanānī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ū'tza' nalīsqui'ni'yā'tit Dios cacāmacamilh chi'xcuhuī'n tī nacāmāsu'yuni' xatze tachihuīn tī a'ka'ī'cu'tun ―cāhuanilh. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Xlītza'la Jesús cāmāta'satīnīni'lh kelhacāujtu' ī'scujnu'nī'n. Cāmaxquī'lh līmāpa'ksīn natamāxtu jā tzeya ū'nī'n ē nacāmātzeyī catūhuālh ta'jatat ē taca'tzanajuāt. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Tzamā' kelhacāujtu' ī'scujnu'nī'n ē xlaca'n tī cāmāpacuhuīcan apóstoles. Xapūla, xla' Simón tī ixlī'a'ktu' ixtacuhuīni' Pedro, ē ī'stancu Andrés; ē nā Jacobo ē Juan tī ixka'hua'chan Zebedeo; ");
INSERT INTO tkuNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ē nā Felipe ē Bartolomé ē Tomás ē Mateo tī mātā'jīni' ixuanī't; ē nā Jacobo tī ixka'hua'cha Alfeo; ē Lebeo tī ixmāpācuhuīcan Tadeo; ");
INSERT INTO tkuNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ē nā Simón tī ixtapa'ksīni' partido cananista; ē nā Judas Iscariote tī ā'līstān macamāstā'lh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","A'cxni' Jesús cāmacā'lh tzamā' kelhacāujtu', xla' chuntza' cāmāpa'ksīlh ē cāhuanilh: ―Jā catipintit timāsu'yu'yā'tit jā tahui'lāna'ncha' xlaca'n tī jā israelitas ē jā titanū'yā'tit na ixcā'lacchicni'ca'n samaritanos. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Napinā'tit nacāmāsu'yuni'yā'tit xalanī'n nac Israel. Xlaca'n hua'chi purecu' tī tatza'nkānī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Capintit ē na'a'kchihuīna'nā'tit chuntza': “Talacatzuna'jīmā'lhtza' a'cxni' natasu'yu chī Dios nacāmāpa'ksīni'nkō'.” ");
INSERT INTO tkuNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Cacāmātzeyī'tit ta'jatatlanī'n ē cacāmālacastālancuanī'tit nīnī'n. Cacāmātzeyī'tit leprosos tī cāmasni'mā'nalh ixquinītca'n ē cacāmāxtutit jā tzeya ū'nī'n. Hui'xina'n jā xokonī'ta'ntit huā'mā' lītli'hui'qui tū iccāmaxquī'yān ē chuntza' jā caticāmātā'jī'tit a'cxni' nacālīmātzeyī'yā'tit quilītli'hui'qui. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Jā camojō'tit tumīn ixla' oro nūn ixla' plata nūn ixla' cobre na mimbolsaca'n a'cxni' napinā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Jā calī'pintit mimorralhca'n nūn pūtu' milu'xu'ca'n. Xmān nalī'pinā'tit milu'xu'ca'n tū lhakā'nī'ta'ntit. Jā nalī'pinā'tit nūn caclhi' nūn mimpāla'cca'n. Tī māsu'yumā'lh ixtachihuīn Dios maclacasqui'n namāhuī'can jā māsu'yumā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’A'cxni' nachipinā'tit a'ktin nac cā'lacchicni' o a'ktin nac rancho, naputzayā'tit chā'tin tzeya chi'xcu' tī nacāmānūyān na ixchic. Natachokoyā'chipitit hasta a'cxni' nataxtuyā'tit tzamā' nac cā'lacchicni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","A'cxni' natanū'yā'tit nac chic, nacāhuaniyā'tit: “Dios cacāsicua'lanātlahualh tī tahui'lāna'lh huā'tzā' nac chic.” ");
INSERT INTO tkuNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Palh cā'tapāxuhuān cātamānūyān na ixchicca'n, Dios nacāsicua'lanātlahua ē nā hui'xina'n. Palh jā cātamānūcu'tunān na ixchicca'n, xlaca'n jā caticāsicua'lanātlahuaca. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Palh jā cātamānūyān a'ktin nac chic o a'ktin nac cā'lacchicni', ē palh jā cātakexmatni'yān, palaj tunca cataxtutit. A'cxni' nataxtuyā'tit, catincxtit mintujanca'n ē nayuja po'kxni'. Chuntza' nalīmāsu'yu'yā'tit xlaca'n natalē'n cuenta ixpālacata jā takexmatcu'tunli. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ixlīcāna' tū iccāhuaniyān. A'cxni' namin quilhtamacuj ē Dios nacāputzāna'nīkō', xlaca'n natapātīni'n. Dios ā'chulā' nacālakalhu'man xlaca'n xalanī'n nac Sodoma ē Gomorra ē jā xalanī'n tzamā' cā'lacchicni' tī jā takexmatcu'tun ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jesús cāhuanipālh: ―¡Cuenta catlahua'tit! Quit iccāmacā'nān ē nalītaxtuyā'tit hua'chi purecu' na ixpu'nanca'n lobos. Skalalh cahuantit hua'chi lūhua'. Cala'tit hua'chi tantzasnān tū ca'csua'. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Catamaktaka'lhtit. Chi'xcuhuī'n nacātamacamaxquī'cu'tunān māpa'ksīni'nī'n ē nacātatucsān na ixtemploca'n israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nacātamālacapū'yān na ixlacatīnca'n gobernadores ē reyes xmān quimpālacata. Chuntza' tzē nacāhuani'yā'tit xatze tachihuīn ē nā nacāhuani'yā'tit tī jā israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Jā catilī'a'ktuyuntit chī nalītamaktāyayā'tit ē chī nacākelhtīyā'tit a'cxni' nacāmacamaxquī'yān māpa'ksīni'nī'n. A'cxni' nachipinā'tit a'ntza', Dios nacāmāca'tzīnīyān tū nacāhuani'yā'tit xlaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Jā xmān mintachihuīnca'n tū nachihuīna'nā'tit. Espíritu Santo, ū'tza' tī nacāmāchihuīnīyān. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Chi'xcuhuī'n natamacamāstā' ixtā'timīnca'n nacāmaknīcan ē xanatātana' natamacamāstā' ixcamana'ca'n. Ka'hua'chan natatā'lāquiclhlaktzī'n ixnatātana'ca'n ē natamāmaknīnīni'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ixlīpō'ktuca'n tachi'xcuhuī't nacātaquiclhlaktzī'nān ixpālacata quilātapa'ksīni'yāuj quit. Tī tzancs natatāya ē jā natataxtutāya na quintej masqui tapātīni'mā'nalh, ū'tunu'n nacāmakapūtaxtūcan. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","’A'cxni' nacātaputzastālani'yān a'ktin nac cā'lacchicni', cataxtutit ē capintit ā'lacatin. Ixlīcāna' tū iccāhuaniyān. Jā catitētaxtukō'tit ixlīpō'ktuca'n ixcā'lacchicni'ca'n israelitas namāsu'yuyā'tit quintachihuīn a'cxni' namimpala Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Ā'chulā' ixlacasqui'nca xamākelhtahua'kē'ni' ē jā tī sca'tmā'lh. Ā'chulā' ixlacasqui'nca patrón ē jā tasācua'. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Līpāxuhua tī sca'tmā'lh ē tzē namālakchā'nī ixmākelhtahua'kē'ni' ē nā tasācua' tī tzē namālakchā'nī ixpatrón. Palh lakapalacanī'ttza' tī māpa'ksīni'n nac chic ē māpācuhuīcanī'ttza' Beelzebú, ā'chulā' nacālakapalacan ā'makapitzīn xalanī'n nac huā'mā' chic ―cāhuanilh Jesús. (Tū huanli Jesús ixlīchihuīna'mā'lh xla' ē nā ī'scujnu'nī'n.) ");
INSERT INTO tkuNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jesús cāhuanipālh: ―Chuntza' jā caticājicua'ni'tit tachi'xcuhuī't. Ixlīpō'ktu tū tatzē'knī't, ū'tza' nalaktzī'ncan. Tū tatzē'kni'cus, naca'tzīkō'can. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tū quit iccāhuaniyān xmān hui'xina'n, ū'tza' nacāhuaniyā'tit cā'lhūhua'lacatīn. Tū quit tzē'k iccāhuaniyān, ū'tza' palha' nahuanā'tit calhāxcuhuālh. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Jā caticājicua'ni'tit chi'xcuhuī'n tī tzē natamaknī mimacni'ca'n ē jāla tamāpa'ksī milīstacna'ca'n. Najicua'ni'yā'tit Dios tī tzē nacāmālaksputū mimacni'ca'n ē milīstacna'ca'n nac pūpātīn. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","¿Chī nalīstā'can xalacstīn spūnī'n? Stā'can tantu' ē jā tapalaxla'. QuinTāta'ca'n nac a'kapūn cuenta natlahua a'cxni' minācha' a'ktin xalacstīn spūnī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hui'xina'n hasta miya'jca'n cātapūlhekeni'nī'ta'n kenatunu'. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ū'tza' jā tilījicua'nā'tit. Hui'xina'n ā'chulā' tapalaxla' ē jā xalacstīn spūnī'n ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jesús cāhuanipālh: ―Catīxcuhuālh tī nahuan na ixlacatīn tachi'xcuhuī't: “Quit ictapa'ksīni' Cristo”, ē chuntza' nā quit na'icuan na ixlacatīn quinTāta'ca'n nac a'kapūn: “Xla' quintapa'ksīni' quit.” ");
INSERT INTO tkuNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Tī naquinkelhtatzē'ka cā'lhūhua'lacatīn, xlaca'n quit na'iccākelhtatzē'ka a'cxni' natatāya na ixlacatīn quinTāta'ca'n xala' nac a'kapūn. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jesús cāhuanipālh: ―Jā tipuhua'nā'tit palh quit icmilh ixpālacata a'ktin nala ixtalacapāstacni'ca'n tachi'xcuhuī't ē chuntza' jā talālīsītzī'ni'lh nac cā'quilhtamacuj. Jā ū'tza' quintascujūt. Na'iccāmāpāpitziyān. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Chī'xcu' natā'lāquiclhlaktzī'n ixka'hua'cha. Ē tzu'ma'jāt natā'lāquiclhlaktzī'n ixtzī'. Ē nā puscāt natā'lāquiclhlaktzī'n ixpuhuiti'. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Chā'tin chi'xcu' tā'lāquiclhlaktzi' nahuan xalanī'n na ixchic. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Tī ā'chulā' natapāxquī' ixtzī'ca'n o ixtāta'ca'n ē jā quit, xlaca'n jā minī'ni' naquintatapa'ksīni' quit. Nā tī ā'chulā' natapāxquī' ixka'hua'chaca'n o ixtzu'ma'jātca'n ē jā quit, xlaca'n jā minī'ni' naquintatapa'ksīni' quit. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tī jāla tatāyani' tū nacā'a'kspula quimpālacata, xlaca'n jā minī'ni' naquintatapa'ksīni' quit. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tī natataxtutāya na quintej ē jā tapātīni'ncu'tun quimpālacata, xlaca'n jā catitaka'lhīlh ixlatamatca'n nac a'kapūn. Tī natapātīni'n masqui ixtalīnīlh quimpālacata, xlaca'n nacāmakapūtaxtūcan. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jesús cāhuanipālh: ―Palh catīhuālh nata'a'ka'ī'ni' tū hui'xina'n nacāhuani'yā'tit, nā chuntza' nata'a'ka'ī'ni' tū quit icuan. Palh catīhuālh nata'a'ka'ī'ni' tū icuan, nā chuntza' nata'a'ka'ī'ni' tī quimacamilh. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Palh catīhuālh natalakachi'xcuhuī' chā'tin a'kchihuīna' ixpālacata taca'tzī Dios macaminī't, chuntza' ū'tunu'n natatlaja lacxtim hua'chi a'kchihuīna'. Palh catīhuālh natalakachi'xcuhuī' chā'tin tzeya chi'xcu' xmān ixpālacata tze xla', chuntza' ū'tunu'n lacxtim natatlaja hua'chi tzeya chi'xcu'. ");
INSERT INTO tkuNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Palh chā'tin natā'hua' macsti'na'j xcān xmān ixpālacata quintapa'ksīni' quit ē palh natā'hua' masqui catīhuālh chi'xcu', Dios naxokoni' xla' ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","A'cxni' Jesús cāmāsu'yuni'kō'lh ī'scujnu'nī'n, taxtulh a'ntza' ē a'lh. Ixtētaxtutēlha ā'makapitzīn cā'lacchicni' lacatzuna'jatna' namāsu'yu ē na'a'kchihuīna'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan Mā'kpaxīni' ixtanūmā'lh nac pūlāchī'n. A'cxni' māca'tzīnīca tū ixtlahuamā'lh Jesús, palaj tunca cāmacā'lh chā'tu' ī'scujnu'nī'n natalaka'n Jesús ");
INSERT INTO tkuNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ē natakelhasqui'nī: ―¿Ē hui'x Cristo tī namin o ixlacasqui'nca na'icka'lhīyāujcus ā'chā'tin? ");
INSERT INTO tkuNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús cākelhtīlh: ―Cataspi'ttit ē nahuaniyā'tit Juan tū laktzī'nī'ta'ntit ē tū kexpa'tnī'ta'ntit. ");
INSERT INTO tkuNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nahuaniyā'tit chī lakatzī'nī'n talacahuāna'n ē lū'ntū'nunī'n tatāya ē tatlā'huan. Nā tī ixcāmasni'mā'lh ixquinītca'n, xlaca'n tatzeyan. Tī jā ixtakexmata, chuhua'j takexmatatza'. Nā cāmālacastālancuanīcanī't tī ixtanīnī'ttza'. Cāmāsu'yuni'can chī nacālīmakapūtaxtūcan tī talīpuhuahuī'lāna'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Līpāxuhua tī pō'ktu quilhtamacuj quintalīpāhuamā'nalh ―cāhuanilh. ");
INSERT INTO tkuNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","A'cxni' xlaca'n ixta'a'nī't, Jesús tzuculh cālītā'chihuīna'n tachi'xcuhuī't ixpālacata Juan. Cākelhasqui'nīlh: ―A'cxni' quīla'tit nac cā'tzaya'nca ti'ya't, ¿tīchu ixlaktzī'ncu'tunā'tit? ¿Ē ixlaktzī'ncu'tunā'tit chā'tin chi'xcu' tī hua'chi pūlactin pa'lhma' tū lacachiquilh ū'ni'? ");
INSERT INTO tkuNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Tū ixpālacata quīla'tit? Jā quīla'tit nalaktzī'nā'tit chā'tin chi'xcu' tī tzēhuanī't lhakā'nanī't. Hui'xina'n ca'tzīyā'tit tī pō'ktu quilhtamacuj tzēhuanī't talhakā'nanī't, xlaca'n tahui'lāna'lh na ixchicca'n reyes. ");
INSERT INTO tkuNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Tū ixpālacata quīla'tit nac cā'tzaya'nca ti'ya't? ¿Ē jā quīla'tit nalaktzī'nā'tit chā'tin a'kchihuīna'? Ixlīcāna', ixlaktzī'ncu'tunā'tit chā'tin a'kchihuīna'. ");
INSERT INTO tkuNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Huā'mā' a'kchihuīna' ixtacuhuīni' Juan. Chuntza' lītatzo'knī't huā'mā' Juan na ixtachihuīn Dios: Na'icmacā'n quina'kchihuīna' tī napūlani'yān nacāxmāpī' mintej. ");
INSERT INTO tkuNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ixlīcāna' huā'mā' tū iccāhuaniyān. Na ixlacpu'na'i'tātca'n tachi'xcuhuī't jā tī chā'tin a'kchihuīna' ā'chulā' xaka'tla' chī Juan. Masqui xla' ka'tla' a'kchihuīna' ixuanī't, tī ā'chulā' xastancu jā Dios māpa'ksīni'nkō', ā'chulā' ka'tla' xla' ē jā Juan. ");
INSERT INTO tkuNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Hasta a'cxni' tzuculh a'kchihuīna'n Juan Mā'kpaxīni', maklhūhua' titanūcu'tunli jā Dios māpa'ksīni'nkō'. Hua'chi tataquitzimā'nalh natasātanū. ");
INSERT INTO tkuNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ixlīpō'ktuca'n a'kchihuīna'nī'n ixtalīchihuīna'mā'nalh chī namin a'ktin quilhtamacuj a'cxni' Dios namāpa'ksīni'n huā'tzā' nac cā'ti'ya'tna'. Nā chuntza' tatzo'kni' na ixlīmāpa'ksīn Moisés. Talīchihuīna'nli hasta a'cxni' milh Juan. ");
INSERT INTO tkuNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Masqui jā cati'a'ka'ī'ni'cu'tuntit tū huanli makāstza', huā'mā' Juan ū'tza' a'kchihuīna' Elías tī ixka'lhīpā'na'ntit. ");
INSERT INTO tkuNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Cuenta catlahua'tit tū kexpa'tā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Chī na'iccālīmālakchā'nīyāuj chi'xcuhuī'n tī tahui'lāna'lh chuhua'j? Hua'chi lacstīn tatasu'yu tī takamāna'mā'nalh nac lītamāuj. Cātā'ta'sa ixtā'lacstīn ē tahuani: ");
INSERT INTO tkuNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“A'cxni' quina'n icmakata'sauj līskoli', hui'xina'n jā lakatītit ē jā tlītit. A'cxni' icpixtlī'uj chī iclīlīpuhuanui', hui'xina'n jā lakatītit ē jā calhua'ntit. ¿Tūchu lacasqui'nā'tit?” tahuan. ");
INSERT INTO tkuNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Milh Juan ē jā ko'tli ē makatunu' jā huā'yalh pō'ktu quilhtamacuj. Hui'xina'n lē'ksa'nā'tit ē hua'nā'tit palh xla' ka'lhī jā tzeya ū'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ā'līstān quit icmilh. Quit Chi'xcu' xala' Tālhmā'n ē icua' xcān ē catūxcuhuālh quimālacnūni'can ē pō'ktu quilhtamacuj icuā'yan. Nā quilālē'ksa'nāuj ē hua'nā'tit palh quit laktza' iclīhuā'yan ē laktza' iclīkō'tnun. Hua'nā'tit quit ixamigoca'n mātā'jīni'nī'n ē tī tatlahua tū jā tze. Tī ta'a'ka'ī', xlaca'n taca'tzī Dios macamilh Juan ē nā quit ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Xlītza'la Jesús tzuculh cālacaquilhnī xalanī'n tzamā' cā'lacchicni' jā tlahualh lhūhua' lī'a'cnīn. Cālacaquilhnīlh tachi'xcuhuī't ixpālacata jā ixtalakpalīcu'tun ixtalacapāstacni'ca'n. Cāhuanilh: ");
INSERT INTO tkuNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―Koxa tila'yā'tit hui'xina'n xalanī'n nac Corazín ē xalanī'n nac Betsaida. Nalīlīpuhuanā'tit ixpālacata jā a'ka'ī'tit. Tlahuacanī't lī'a'cnīn na milacpu'na'i'tātca'n. Palh ixcātlahuaca tzamā' lī'a'cnīn nac cā'lacchicni' Tiro ē nac Sidón, makāstza' ixtalakpalīlh ixtalacapāstacni'ca'n. Xlaca'n ixtalhakā'lh xapūtze'nke ixlu'xu'ca'n ē ixcā'a'cpūmāhua'ca'ca lhca'ca'n ē chuntza' ixtatasu'yulh ixtalīpuhuan ixpālacata ixcuentaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Iccāhuaniyān a'cxni' Dios nacāputzāna'nīkō', hui'xina'n ā'chulā' nacātamakapātīnīnān ē jā xalanī'n nac Tiro ē Sidón. ");
INSERT INTO tkuNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Hui'xina'n xalanī'n nac Capernaum, ¿ē puhua'nā'tit palh napinā'tit nac a'kapūn ixpālacata tze hui'xina'n? Napinā'tit hasta nac pūpātīn. Palh ixcātlahuacancha' cahuālh lī'a'cnīn nac cā'lacchicni' Sodoma tū cātlahuacanī't na milacpu'na'i'tātca'n, ixtalakpalīlh ixtalacapāstacni'ca'n. Chuntza' Dios jā ixmālaksputūlh cā'lacchicni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Iccāhuaniyān a'cxni' Dios nacāputzāna'nīkō', ā'chulā' nacātamakapātīnīnān hui'xina'n ē jā xlaca'n xalanī'n nac Sodoma ē ā'makapitzīn cā'lacchicni' lacatzuna'j nac Sodoma ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Xlītza'la Jesús orarlīlh ē huanli: ―QuinTāta', hui'x māpa'ksīni'na' nac a'kapūn ē nac cā'ti'ya'tna'. Icmaxquī'yān tapāxcatca'tzīn ixpālacata cāmāsu'yuni'nī'ta' tī tasca'tcu'tun ū'tza' tū ixcāmātzē'kni'nī'ta' tī lakskalalhna'. ");
INSERT INTO tkuNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ū'tza' chuntza' chī mintalacapāstacni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Cāhuanilh tachi'xcuhuī't: ―QuinTāta' quimacamaxquī'kō'lh ixlīpō'ktu tū a'nan. Jā tī chā'tin ca'tzī chī huī'lh ī'Ska'ta' Dios, xmān Dios xaTāta'. Jā tī chā'tin ca'tzī chī ixlīDios quinTāta', xmān quit ī'Ska'ta'. Nā nataca'tzī xlaca'n tī na'iccāmāsu'yuni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Cata'ntit milīpō'ktuca'n hui'xina'n tī makca'tzīyā'tit tzi'nca tū tlahuanī'ta'ntit tū jā tze ē palha' scujpā'na'ntit namakapāxuī'yā'tit Dios. Cata'ntit ē quit na'iccāmājaxīyān. ");
INSERT INTO tkuNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Caquilākexmatni'uj ē caquilāmaksca'tui. Līlacatzucu na'iccāhuanilē'nān ē quit jā ka'tla' icmakca'tzī. Chuntza' jā nacātamāmakchuyīyān. ");
INSERT INTO tkuNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Jā jicslīhua' quintamāsu'yun ē tzē namākentaxtūyā'tit ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ā'līstān Jesús ixtētaxtumā'lh nac cā'tacuxtu. Quilhtamacuj tū ixpūjaxcan. Ī'scujnu'nī'n ixtatzi'ncsatza' ē tatzuculh ta'ī' pātin pātu' tza'ktza' ē tahua'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","A'cxni' fariseos talaktzī'lh, tahuanilh Jesús: ―Cala'ktzi'. Tascujmā'nalh miscujnu'nī'n ē chuhua'j quilhtamacuj tū pūjaxcan. Chuntza' jā takexmatni' ixlīmāpa'ksīn Moisés. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesús cākelhtīlh ē cāhuanilh: ―¿Ē jā līkelhtahua'kanī'ta'ntit tū tlahualh David a'ktin quilhtamacuj? Ixtzi'ncsatza' xla' ē tī ixtatā'a'mā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tatanūlh na ixchic Dios ē tahua'lh pāntzīn tū ixmālacnūni'canī't Dios. Jā minī'ni' ixtahua'lh huā'mā' pāntzīn. Xmān pālejni' tzē natahua'. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Ē chā jā līkelhtahua'kanī'ta'ntit nac līmāpa'ksīn tū tzo'kli Moisés? Pālejni' tī tascuja xaka'tla' nac templo pō'ktu quilhtamacuj tamākentaxtū ixtascujūtca'n. Masqui tatlahua tū jā minī'ni' tlahuacan quilhtamacuj tū pūjaxcan, jā tī chā'tin puhuan xlaca'n tatlahua tū jā tze. Jā puhuancan xlaca'n jā takexmatni' līmāpa'ksīn. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Iccāhuaniyān huā'tzā' huī'lh catīhuālh tī ā'chulā' ixlacasqui'nca ē jā xaka'tla' templo. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Hui'xina'n jā ca'tzīnī'ta'ntit tū huanicu'tun jā tatzo'kni' na ixtachihuīn Dios: “Quit iclacasqui'n nacālakalhu'manā'tit ā'makapitzīn ē jā iclacasqui'n naquilālakahui'līyāuj animalh.” Palh ixca'tzī'tit cahuālh huā'mā' tachihuīn ixpālacata cālakalhu'mancan, jā ixcālīmālacsu'yutit quiscujnu'nī'n tī jā tatlahuamā'nalh tū jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Quit Chi'xcu' xala' Tālhmā'n ē tzē na'icmāpa'ksīni'n tū natlahuacan a'cxni' quilhtamacuj tū pūjaxcan. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Xlītza'la Jesús taxtulh a'ntza' ē tanūlh a'ktin na ixtemploca'n israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ixuī'lh a'ntza' chā'tin chi'xcu' tī ixmacascācni'. Ixputzamā'ca chī nalīmālacsu'yucan Jesús, ē kelhasqui'nīca: ―¿Ē tzē mātzeyīcan ta'jatatlani' quilhtamacuj tū pūjaxcan? ");
INSERT INTO tkuNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús cākelhtīlh: ―Palh hui'xina'n ixka'lhī'tit mimpurecu'ca'n tū ixtojōlh nac pūlhmā'n pūlhu'cu', ¿ē jā ixtimācu'tutit masqui quilhtamacuj tū pūjaxcan? ");
INSERT INTO tkuNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ā'chulā' ixtapalh chā'tin chi'xcu' ē jā lakatin purecu'. Chuntza' tzē tlahuani'can ā'chā'tin tū xatze ē maktāyacan ā'chā'tin masqui quilhtamacuj tū pūjaxcan. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Palaj tunca huanilh chi'xcu': ―Castu'ncti mimacan. A'cxni' stu'ncli ixmacan, ixtzeyanī'ttza' ē ixtā'chuntza' huanli kentin ixmacan. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Palaj tunca tataxtulh fariseos ē talacapāstacli chī natalīmāmaknīnīni'n Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","A'cxni' Jesús ixca'tzī tū ixtapuhuamā'nalh, ē a'lh ā'lacatin ē līlhūhua' tastālani'lh. Jesús cāmātzeyīkō'lh ta'jatatlanī'n ");
INSERT INTO tkuNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ē cāmāpa'ksīlh jā catahuanli tīchu xla'. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Chuntza' tlahualh namākentaxtū chī a'kchihuīna'nli profeta Isaías a'cxni' tzo'kli tū huanli Dios: ");
INSERT INTO tkuNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Huā'mā' quintasācua' tī iclacsacli ē laktza' icpāxquī' ē xla' quimakapāxuī. QuinEspíritu natā'a'n ē nacāmāsu'yuni' tī jā israelitas chī tzej na'icputzāna'nīkō'. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Xla' jā nalacaquilhnīni'n ē jā nata'sa. Jā palha' nachihuīna'n nac cā'tejen ixpālacata cuenta natlahuacan xla'. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Xla' nacāmaktāya tī jā lactli'hui'quin tī hua'chi cha'ncat tū xaxmū'hua. Jā nacālakmaka'n tī jāna'j tzej ta'a'ka'ī'. Xlaca'n hua'chi pūcās tū jā tzej māxkakēni'n ē slam slam la. Nacāmaktāya hasta a'cxni' xla' nacāmāpa'ksīkō' ixlīpō'ktuca'n tachi'xcuhuī't nac cā'ti'ya'tna'. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tachi'xcuhuī't nata'a'ka'ī'. Chuntza' tzo'kli profeta Isaías. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Xlītza'la lē'ni'ca Jesús chā'tin chi'xcu' tī lakatzī'n ē kō'ko' ixuanī't ixpālacata ixka'lhī jā tzeya ū'ni'. Jesús mātzeyīlh ē tzej ixlaktzī'n ē tzuculh chihuīna'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ixlīpō'ktuca'n tachi'xcuhuī't talī'a'cnīlh ē tahuanli: ―¿Ē ū'tza' huā'mā' ī'xū'nātā'nat David tī xa'icka'lhīmā'nauj? ");
INSERT INTO tkuNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","A'cxni' fariseos takexmatli huā'mā' tachihuīn, tahuanli: ―Huā'mā' chi'xcu' ka'lhī ixlītli'hui'qui Beelzebú tī xapuxcu' jā tzeya ū'nī'n. Ū'tza' cālīmāxtulh jā tzeya ū'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús ixca'tzī tū ixtapuhuamā'nalh ē cāhuanilh: ―Palh māpa'ksīni'nī'n tatapāpitzi ē talātucsa, jāla tamāpa'ksīni'n lakmaj. Natalāmālaksputūkō'. Palh xalanī'n a'ktin cā'lacchicni' o a'ktin familia tatapāpitzi ē talātucsa, jā catitatāyani'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Palh ixlītli'hui'qui xapuxcu' jā tzeya ū'nī'n tū iclīmāxtu ā'a'ktin jā tzeya ū'ni', chuntza' talītapāpitzi lītli'hui'qui. Jā catitāyani'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Hui'xina'n hua'nā'tit quit iccālīmāxtu jā tzeya ū'nī'n ixlītli'hui'qui Beelzebú. ¿Tīchu ixlītli'hui'qui tū talīmāxtu jā tzeya ū'nī'n xlaca'n tī cātatapa'ksīni'yān hui'xina'n? Chuntza' xlaca'n tamāsu'yu jā ixlīcāna' tū quilālīmālacsu'yuyāuj. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tū quit iccālīmāxtu jā tzeya ū'nī'n, ū'tza' ixlītli'hui'qui Espíritu Santo. Ū'tza' huanicu'tun Dios cāmāsu'yuni'yān chī tzuculhtza' māpa'ksīni'nkō' huā'tzā' nac cā'ti'ya'tna'. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Jāla tanūcan namakka'lhāncan catūhuālh na ixchic tli'hui'qui chi'xcu' palh jā pūla nachī'can tzamā' chi'xcu'. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Tī jā quintapa'ksīni'cu'tun ū'tza' quiclh quilaktzī'n. Tī jā quintā'scuja, ū'tza' lactlahuana'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Ū'tza' iccālīhuaniyān masqui tzē nacāmātza'nkēna'ni'can ixlīpō'ktuca'n ixcuentaca'n tachi'xcuhuī't ē catūxcuhuālh jā tze tū tahuan, palh catīhuālh nahuan jā tze tū tlahua Espíritu Santo, xla' jāla catimātza'nkēna'ni'ca. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Palh catīhuālh cachīhuālh huani Chi'xcu' xala' Tālhmā'n, namātza'nkēna'ni'can. Palh catīhuālh nahuan jā tze tū tlahua Espíritu Santo, xla' jā catimātza'nkēna'ni'ca nūn huā'tzā' nac cā'quilhtamacuj ē nūn nac ā'a'ktin cā'quilhtamacuj tū namin ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jesús cāhuanipālh: ―Palh tze qui'hui', namāstā' xatze ixtahua'ca't. Palh jā tze qui'hui', jā catimāstā'lh xatze ixtahua'ca't. Chī māstā' ixtahua'ca't, chuntza' līlakapascan qui'hui'. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Hui'xina'n hua'chi lūhua' tū ka'lhī tū laknīcan masqui tzēhuanī't tasu'yu. ¿Chī nacālīquilhtaxtuyān tachihuīn tū tze a'cxni' jā tze mintalacapāstacni'ca'n? Chuntza' chī lacapāstacā'tit, chuntza' nachihuīna'nā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tze ixtachihuīn chā'tin tzeya chi'xcu' ixpālacata tze ixtalacapāstacni'. Jā tze ixtachihuīn chā'tin jā tzeya chi'xcu' ixpālacata jā tze ixtalacapāstacni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Iccāhuaniyān namin a'ktin quilhtamacuj a'cxni' Dios nacāputzāna'nīkō'. A'cxni' nala, ixlacasqui'nca ixlīpō'ktuca'n tachi'xcuhuī't natahuani Dios tūchu ixpālacata catūhuālh tachihuīn tū tlakaj tahuanli. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Chuntza' chī chihuīna'nī'ta'ntit, chuntza' nacātalīputzāna'ni'yān palh lactze o jā lactze hui'xina'n ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Xlītza'la makapitzīn fariseos ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn tahuanilh Jesús: ―Mākelhtahua'kē'ni', quina'n iclaktzī'ncu'tunāuj a'ktin ka'tla' lī'a'cnīn naquilālīmāsu'yuni'yāuj palh ixlīcāna' Dios macaminī'ta'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús cākelhtīlh: ―Tachi'xcuhuī't tī jā tze ē tī jā ta'a'ka'ī'cu'tun, xlaca'n tasqui'n a'ktin ka'tla' lī'a'cnīn. Xmān nacāmāsu'yuni'can lī'a'cnīn chī tū a'kspulalh Jonás. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","A'ktu'tun quilhtamacuj ē a'ktu'tun tzī'sni' Jonás ixtojōmā'lh na ixpūlacni' ka'tla' squī'ti' ē xalakahuan taxtulh. Nā chuntza' quit Chi'xcu' xala' Tālhmā'n nā na'ictojō a'ktu'tun quilhtamacuj ē a'ktu'tun tzī'sni' na ixpūlacni' ti'ya't. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Namin a'ktin quilhtamacuj a'cxni' naputzāna'nīkō'can. A'cxni' nala huā'mā', xlaca'n tī ixtahui'lāna'lh nac cā'lacchicni' jā huanican Nínive natatāya ē nacātamālacsu'yuyān hui'xina'n tī hui'lāna'ntit chuhua'j. Nacātalīmālacsu'yuyān ixpālacata xlaca'n talakpalīlh ixtalacapāstacni'ca'n a'cxni' milh Jonás ē lī'a'kchihuīna'nli ixtachihuīn Dios. Hui'xina'n jā lakpalī'tit mintalacapāstacni'ca'n a'cxni' quit ica'kchihuīna'nli. Quit ā'chulā' ixlacasqui'nca ē jā Jonás. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nā reina tī ixmāpa'ksīni'n nac Sabá natāya ē nacāmālacsu'yuyān a'cxni' namin quilhtamacuj tū naputzāna'nīkō'can. Nacālīmālacsu'yuyān ixpālacata xla' kexmatli tū huanli Salomón. Makat ixuanī't ixchic reina ē milh kexmata Salomón. Quit ā'chulā' ixlacasqui'nca ē jā Salomón ē hui'xina'n jā quilākexmatni'cu'tunāuj ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jesús cāhuanipālh: ―A'cxni' a'ktin jā tzeya ū'ni' nataxtuni' chi'xcu', nalatā'kchoko jā cā'scahuahua ē naputza jā najaxa. A'cxni' jā namacla jā najaxa, napuhuan: ");
INSERT INTO tkuNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Na'ictaspi'tpala jā ictaxtukēni'.” A'cxni' naquītaspi'ta, namacla chi'xcu' hua'chi a'ktin chic jā cā'huan ē tzej pa'lhnancanī't, ē jā tī chā'tin huī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Palaj tunca na'a'n nacātaya ā'kelhatojon jā tzeya ū'nī'n tī ā'chulā' xalīhua'ca'lhtza'. Ixlīpō'ktuca'n natatanū natalatahui'la na ixpūlacni' chi'xcu'. Chuntza' ā'chulā' jā tze tzamā' chi'xcu' ē jā a'cxni' ixka'lhī xmān chā'tin jā tzeya ū'ni'. Nā chuntza' nacā'a'kspula xlaca'n tī jā tze ē tahui'lāna'lh chuhua'j. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús ixcātā'chihuīna'mā'lhcus tachi'xcuhuī't a'cxni' tachā'lh ixtzī' ē ixtā'timīn. Ixtalayāna'lh nac kēpūn ē ixtatā'chihuīna'ncu'tun Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Huanica Jesús: ―Talayāna'lh mintzī' nac kēpūn ē mintā'timīn ē mat tatā'chihuīna'ncu'tunān. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesús kelhtīlh tī ixmāca'tzīnīnī't: ―¿Ē ca'tzīyā'tit tīchu iccālaktzī'n hua'chi quintzī' ē quintā'timīn? ");
INSERT INTO tkuNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Palaj tunca Jesús cāmacahuanilh ī'scujnu'nī'n ē huanli: ―Tzamā' ū'tunu'n quintzī' ē quintā'timīn. ");
INSERT INTO tkuNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ixlīpō'ktuca'n tī natatlahua tū lacasqui'n quinTāta' xala' nac a'kapūn, ū'tunu'n quintā'timīn ē quintzī'. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Huā'mā' quilhtamacuj Jesús taxtulh nac chic ē a'lh na ixquilhtūn ka'tla' xcān. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Lhūhua' tachi'xcuhuī't tatakēstokli jā ixuī'lh ē Jesús tojōlh a'ktin nac barco ē tahuī'lh. Ixlīpō'ktuca'n tachi'xcuhuī't tatachokolh na ixquilhtūn xcān. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Palaj tunca cāhuanilh tū lītaca'tzīni'can nacāmāsu'yuni'. Chuntza' cāhuanilh: ―Ixuī'lh chā'tin cha'nāna' ē taxtulh nacha'nāna'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","A'cxni' ixmā'ka'huani'mā'lh ixlīcha'nat, makapitzīn tayujli nac tej. Tamilh spūnī'n ē tasacua'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ā'makapitzīn tayujli nac cā'chihuixni' jā jā pūlhmā'n ti'ya't. Palaj pu'nli huā'mā' līcha'nat ixpālacata jā pūlhmā'n ti'ya't. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","A'cxni' chi'chini'lh, xapa'lhma' scācli ē jāla tā'cnūlh ixtankēxē'k ē xnekli. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ā'makapitzīn līcha'nat huampala tayujli nac cā'lhtucū'n. Lhtucu' tastacli ē tamā'ktzī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ā'makapitzīn līcha'nat tayujli jā tze nac ti'ya't ē māstā'lh ixtahua'ca't. Makapitzīn līcha'nat tamāstā'lh a'ktin ciento ē ā'makapitzīn tamāstā'lh tu'tumpu'xam ē ā'makapitzīn tamāstā'lh pu'xamacāuj. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Palh kexpa'tnī'ta'ntit, cuenta catlahua'tit ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Palaj tunca ī'scujnu'nī'n talaktalacatzuna'jīlh Jesús ē takelhasqui'nīlh: ―¿Tū ixpālacata pō'ktu quilhtamacuj cālīmāsu'yuni'ya' tachi'xcuhuī't tū lītaca'tzīni'can? ");
INSERT INTO tkuNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús cākelhtīlh: ―Dios cāmāsu'yuni'nī'ta'n hui'xina'n tū tatzē'knī't ixpālacata chī nala ixlīmāpa'ksīn Dios. Xlaca'n jāla catitaca'tzīlh. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tī nata'a'ka'ī', xlaca'n natasca'ta ē chuntza' natakexmata ē ā'chulā' nata'a'ka'ī'. Tī jā ta'a'ka'ī'cu'tun, xlaca'n jā catitasca'tli ē natapātza'nkā tū ixtaca'tzī. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ū'tza' iccālīmāsu'yuni' tū lītaca'tzīni'can. Masqui xlaca'n talaktzī'n, jā taca'tzī tū huanicu'tun tū talaktzī'n. Ē masqui takexmata, jā taca'tzī tū huanicu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Chuntza' xlaca'n tamākentaxtū chuntza' chī huanli profeta Isaías jā tzo'kli chuntza': Ixlīcāna' masqui nakexpa'tā'tit, jā catica'tzī'tit. Masqui nalaktzī'nā'tit, jā cuenta catitlahua'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tachi'xcuhuī't hua'chi jā taka'lhī ixtalacapāstacni'ca'n ē cā'a'kachi'pacan ē cālakachi'pacan. Chuntza' jā catitalacahuāna'lh ē jā catitakexmatli ē jāla catitalakpalīlh ixtalacapāstacni'ca'n. Quit xa'iccāmātza'nkēna'ni'lh ē xa'iccāmātzeyīlh. Chuntza' tzo'kli Isaías chī Dios huanli. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Jesús chihuīna'mpālh: ―Līpāxuhua'yā'tit ixpālacata tzē lacahuāna'nā'tit ē tzē kexpa'tā'tit ē nā tzē naca'tzīyā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ixlīcāna' tū iccāhuaniyān. Tzamā' tū laktzī'mpā'na'ntit, ū'tza' ixtalaktzī'ncu'tun lhūhua' a'kchihuīna'nī'n ē lhūhua' tzeya chi'xcuhuī'n ē jā talaktzī'lh. Nā chuntza' tzamā' tū hui'xina'n kexpa'tā'tit, ū'tza' xlaca'n ixtakexmatcu'tun ē jā takexmatli. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Jesús cāhuanipālh: ―Chuhua'j cakexpa'ttit tū huanicu'tun tū līca'tzīni'can ixpālacata cha'nāna'. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tī takexmata chī nala a'cxni' Dios namāpa'ksīni'n ē jā cuenta tatlahua, xlaca'n hua'chi līcha'nat tū yujli nac tej. Namin skāhuī'ni' ē nacāmāpātza'nkēnī tū tasca'tli. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Līcha'nat tū yujli nac cā'chihuixni', ū'tza' hua'chi tī takexmata ixtachihuīn Dios ē talakatī. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Huā'mā' līcha'nat jā ixka'lhī pūlhmā'n ixtankēxē'k ē jā tāyani'lh. Nā chuntza' tachi'xcuhuī't tī jā tzej takexmata, xlaca'n jā makās tatāyani'. A'cxni' tapātī catūhuālh o cāputzastālani'can ixpālacata tū ta'a'ka'ī'lh, jātza' talakatī ē tamakxteka. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Līcha'nat tū yujli nac cā'lhtucū'n, ū'tza' tasu'yu hua'chi tī takexmata ē tasca'ta. Masqui takexmata, pō'ktu talacapāstaca chī natalīhuā'yan ē chī lacricujnu' natalīhuan. Ixlīpō'ktu huā'mā' cāmāmakchuyī ē jā cāmakxteka natalacapāstaca tū takexmatli. Jātza' tatasu'yu palh ta'a'ka'ī' ē ū'tza' huā'mā' hua'chi lhtucu' tū cāmā'ktzī'lh līcha'nat. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Līcha'nat tū yujli jā xatze ti'ya't, ū'tza' hua'chi tī takexmata xatze tachihuīn ē tzej tasca'tli. Tzej tatasu'yu palh ta'a'ka'ī'. Ixlīpō'ktuca'n taka'lhī tū natalīmakapāxuī Dios ē makapitzīn tzej taca'tzī. Xlaca'n hua'chi līcha'nat tū māstā'lh a'ktin ciento o tu'tumpu'xam o pu'xamācauj ixtahua'ca't ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús cāhuanipālh tū līca'tzīni'can: ―Chī Dios māpa'ksīni'nkō' nala hua'chi a'cxni' chā'tin chi'xcu' cha'nli līcha'nat na ixcā'tacuxtu. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","A'ktin cā'tzī'sni' līhuan ī'lhtatamā'lh chi'xcu', ixtā'lāquiclhlaktzi' quīmā'ka'huani'lh tū jā tze līcha'nat. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","A'cxni' ī'stacmā'lhtza' tacha'nān a'cxni' tasu'yulh tū jā tzeya tacha'nān. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Palaj tunca talakmilh ī'scujnu'nī'n chi'xcu' ē takelhasqui'nīlh ixpatronca'n: “¿Ē jā pō'ktu xatze līcha'nat cha'nti na mincā'tacuxtu? ¿Chī līpu'nli huā'mā' tū jā tzeya tacha'nān?” ");
INSERT INTO tkuNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ixtēcu' cākelhtīlh: “Chā'tin quintā'lāquiclhlaktzi' quintlahuani'lh huā'mā'.” Palaj tunca tasācua'n takelhasqui'nīlh: “¿Ē lacasqui'na' na'ica'nāuj na'iccātampu'lhuyāuj tū jā tze pa'lhma'?” ");
INSERT INTO tkuNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Xla' cākelhtīlh: “E'ē. Palhāsā' nacātampu'lhu'yā'tit nā xatze tacha'nān. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Xatze nacāmakxtekāuj lacxtim catastacli hasta a'cxni' na'ī'can. Na'iccāhuani tasācua'n tī nata'ī' palh pūla natataya tū jā tze pa'lhma' ē natapāchī' pixatunu' nalhcuyucan. Ā'līstān nata'ī' xatze tacha'nān ē natamāquī' na quimbodega.” ");
INSERT INTO tkuNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús cāhuanipālh tū līca'tzīni'can: ―Chī natalīlhūhua'n tī nata'a'ka'ī'ni' Dios, ū'tza' nala hua'chi a'ktin xalīcha'nat mostaza tū cha'nli chā'tin chi'xcu' na ixti'ya't. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Huā'mā' līcha'nat ixlīcāna' ā'chulā' xamacsti'na'j ē jā ixlīpō'ktuca'n ā'makapitzīn līcha'nat. A'cxni' nastackō', ka'tla' nahuan hasta ixtā'chuntza' a'katin qui'hui'. Spūnī'n natatlahua ixmāsekca'n na ixpekenī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesús līmāsu'yupālh: ―Chī Dios nalīmāpa'ksīni'n nala hua'chi levadura tū nalītlahua puscāt maktu'tun xatapūlhcān harina ē namakxteka hasta nalaklhtāyakō' ixtasquit. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Pō'ktu huā'mā' Jesús cāhuanilh tachi'xcuhuī't ē cālītā'chihuīna'nli tū līca'tzīni'can. Xmān chuntza' ixcā'tā'chihuīna'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Chuntza' tlahualh ē ū'tza' līmākentaxtūlh tū huanli profeta a'cxni' tzo'kli huā'mā': Na'iccālītā'chihuīna'nān tū līca'tzīni'can; na'icuan catūhuālh tū tatzē'knī't hasta a'cxni' tzuculh tzamā' cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Xlītza'la Jesús cāmakxtekli tachi'xcuhuī't ē xla' tanūlh nac chic. Ī'scujnu'nī'n talaktalacatzuna'jīlh ē tahuanilh: ―Caquilāhuaniuj tū huanicu'tun tū līca'tzīni'can ixpālacata jā tzeya līcha'nat. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Palaj tunca Jesús cāhuanilh: ―Tī cha'nli xatze līcha'nat, ū'tza' Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ixcā'tacuxtu, ū'tza' tzamā' cā'quilhtamacuj. Xatze līcha'nat hua'chi xlaca'n tī tā'tapa'ksī Dios. Tū jā tze līcha'nat hua'chi xlaca'n tī tā'tapa'ksī skāhuī'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ixtā'lāquiclhlaktzi' patrón tī mā'kahuanīlh jā xatze līcha'nat, ū'tza' skāhuī'ni'. A'cxni' ī'can, ū'tza' huanicu'tun a'cxni' nasputa tzamā' cā'quilhtamacuj. Tasācua'n tī nata'ī' pa'lhma', ū'tunu'n ángeles. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Chuntza' chī nacātayacan jā tzeya pa'lhma' ē nacālhcuyucan, chu lacxtim na'a'kspula a'cxni' nasputa tzamā' cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Chi'xcu' xala' Tālhmā'n nacāmāpa'ksī ixángeles nacātaya ixlīpō'ktuca'n tī tatlahua tū jā tze ē ixlīpō'ktuca'n tī tamāsu'yuni' ā'makapitzīn natatlahua tū jā tze. Nacāmāxtukō' jā xla' māpa'ksīni'n ");
INSERT INTO tkuNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ē nacāmānū jā nacālhcuyucan. A'ntza' natacalhuan ē natalāxca ixtatzanca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Xlaca'n tī tatlahua ixlīmāpa'ksīn Dios, xlaca'n natatasu'yu jā Dios māpa'ksīni'nkō'. Tzēhuanī't natatasu'yu hua'chi a'cxni' xkaka chi'chini'. Palh kexpa'tā'tit, cuenta catlahua'tit ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesús cāhuanipālh: ―Tachihuīn ixpālacata chī Dios māpa'ksīni'nkō' tzē nalīmālakchā'nīcan lhūhua' tumīn tū mā'cnūcanī't nac ti'ya't. Namin chā'tin chi'xcu' ē namacla huā'mā' tumīn. Xla' namā'cnūpala jā ixuī'lh. Līpāxuhua na'a'n nastā'kō' ixlīpō'ktu tū ka'lhī ē natamāhua huā'mā' ti'ya't jā mā'cnūca tumīn. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jesús cāhuanipālh: ―Nā tachihuīn ixpālacata chī Dios māpa'ksīni'nkō', ū'tza' hua'chi chā'tin tamāhuana' tī cāputzatēlha chihuix xalactze tū huanican perlas. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","A'cxni' namacla a'ktin tū xatze ē tapalaxla', ē nastā'kō' ixlīpō'ktu tū ka'lhī ē na'a'n natamāhua tzamā' perla. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jesús cāhuanipālh: ―Nā chī Dios māpa'ksīni'nkō' ū'tza' hua'chi a'ktin pūtayan tū pūchi'pacan squī'ti' ē tū mojōcan nac mar ē nacāmācutū kempālhūhua' squī'ti'. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","A'cxni' tzuma pūtayan, chi'pana'nī'n squī'ti' natalē'n na ixquilhtūn mar ē a'ntza' natatahui'la natalacsaca squī'ti'. Xatze squī'ti' nacāmojōcan nac morralh ē tū jā xatze, nacāmaka'ncan. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Chuntza' nala a'cxni' nasputa tzamā' cā'quilhtamacuj. Natataxtu ángeles ē nacālacmāxtu tī jā tze tachi'xcuhuī't na ixlacpu'na'i'tātca'n xalactze. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Jā tze tachi'xcuhuī't nacāmānūcan jā nacālhcuyucan ē a'ntza' natacalhuan ē natalāxca ixtatzanca'n ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Xlītza'la Jesús cākelhasqui'nīlh: ―¿Ē kexpa'tā'tit ixlīpō'ktu huā'mā' tū iccāhuanin? Xlaca'n takelhtīlh: ―Jē, Māpa'ksīni', iccākexmatāuj. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Palaj tunca cāhuanilh: ―A'cxni' chā'tin xamākelhtahua'kē'ni' līmāpa'ksīn quiscujni' nahuan, xla' nala hua'chi chā'tin ixtēcu' chic. Ē huā'mā' chi'xcu' ka'lhī lhūhua' tū tapalaxla' ē a'cxni' minī'ni' namāxtu catūhuālh xala' makāstza' ē a'cxni' minī'ni' namāxtu catūhuālh tū sāsti'cus. Chuntza' natlahua xamākelhtahua'kē'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","A'cxni' Jesús cāhuanikō'lh ixlīpō'ktuca'n tū līca'tzīni'can, a'lh ā'lacatin ");
INSERT INTO tkuNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ē chā'lh nac Nazaret jā stacli. A'ntza' ixmāsu'yu na ixtemploca'n israelitas. Tī takexmatli talī'a'cnīlh ē talāhuanilh: ―Huā'mā' chi'xcu', ¿jāchu sca'tli huā'mā' talacapāstacni'? ¿Chī tzē cālītlahua tzamā' lī'a'cnīn? ");
INSERT INTO tkuNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ū'tza' huā'mā' ixka'hua'cha xuacna' ē nā María ixtzī'. Ixtā'timīn cāhuanican Jacobo ē José ē Simón ē Judas. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ixlīpō'ktuca'n ixtā'timīn xapuscan nā huā'tzā' tahui'lāna'lh na quincā'lacchicni'ca'n. ¿Jāchu sca'tli ixlīpō'ktu huā'mā'? ");
INSERT INTO tkuNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ū'tza' talīsītzī'lh ē talakmaka'lh Jesús. Xla' cāhuanilh: ―Chā'tin a'kchihuīna' nalakachi'xcuhuī'can calhāxcuhuālh jā na'a'n. Xmān xalanī'n na ixchic ē xalanī'n na ixcā'lacchicni' jā talakachi'xcuhuī'cu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","A'ntza' na ixcā'lacchicni' jā ta'a'ka'ī'lh ē ū'tza' Jesús jā lhūhua' lītlahualh lī'a'cnīn. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tzamā' quilhtamacuj Herodes gobernador ixuanī't nac estado Galilea. Māca'tzīnīca ixpālacata Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Herodes cāhuanilh ixtā'scujnu'nī'n: ―Ū'tza' huā'mā' Juan Mā'kpaxīni'. Lacastālancuana'nī't ixlacpu'na'i'tātca'n nīnī'n. Ū'tza' līka'lhī lītli'hui'qui tū lītlahua lī'a'cnīn. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodes ixmāstā'nī't līmāpa'ksīn cachi'paca Juan ē calē'nca nac pūlāchī'n nachī'can. Māchi'nīni'lh ixpālacata Herodías tī ixpuscāt ixtā'tin Felipe ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Juan ixuanimā'lh Herodes: ―Jā minī'ni' chī lī'pina' Herodías hua'chi mimpuscāt. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Masqui Herodes ixmaknīcu'tun Juan, cājicua'ni'lh tachi'xcuhuī't. Xlaca'n tapuhuanli Juan ixa'kchihuīna' Dios ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","A'cxni' Herodes lakchā'lh ixcā'ta, tlahualh cā'tani'. Ixtzu'ma'jāt Herodías tlīlh na ixlacatīnca'n tī ixcā'invitarlīcanī't. Līmakapāxuīlh Herodes ");
INSERT INTO tkuNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ē xla' huanilh ixmaxquī'lh tzu'ma'jāt catūxcuhuālh tū nasqui'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Palaj tunca xatzī' maxquī'lh talacapāstacni' ē tzu'ma'jāt squi'ni'lh Herodes chuntza': ―Caquima'xqui' chuhua'j ixa'kxāk Juan Mā'kpaxīni'. Calī'ta' a'ktin nac pulātu. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ū'tza' līlīpuhuanli Herodes chī ixmālacnūni'nī't tzu'ma'jāt. Tī ixcā'invitarlīcanī't takexmatli tū ixuanicanī't, ē ū'tza' jātza' la lakpalīlh ixtachihuīn. Herodes māpa'ksīni'lh camaxquī'ca. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Chuntza' macā'lh līmāpa'ksīn nac pūlāchī'n ē māmāyujūnīni'lh ixa'kxāk Juan. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Palaj tunca līminca a'kxāk a'ktin nac pulātu ē maxquī'ca tzu'ma'jāt ē xla' maxquī'lh ixtzī'. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Palaj tunca tamilh ī'scujnu'nī'n Juan ē talē'lh ixmacni' ē tamā'cnūlh. Ā'līstān ta'a'lh tamāca'tzīnī Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","A'cxni' māca'tzīnīca Jesús, xla' tojōlh a'ktin nac barco ē a'lh ixtuntacut nac xcān jā jā tī ixa'nan. A'cxni' ca'tzīca jā ixa'mā'lh, lhūhua' tachi'xcuhuī't tataxtulh na ixcā'lacchicni' ē tastālani'lh catujan na ixquilhtūn xcān. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","A'cxni' Jesús taxtulh nac barco, cālaktzī'lh lhūhua' tachi'xcuhuī't ē cālakalhu'manli. Cāmātzeyīlh ta'jatatlanī'n tī ixcālīmini'canī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","A'cxni' ī'smalanka'namā'lhtza', ī'scujnu'nī'n Jesús talakmilh ē tahuanilh: ―Kōtanūtza' ē huā'tzā' jā nac cā'lacchicni'. Cacāmacapi tachi'xcuhuī't nata'a'n natatamāhua ixlīhua'ca'n nac cā'lacchicni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesús cākelhtīlh: ―Jā ixlacasqui'nca nata'a'n; cacāmāhuī'tit hui'xina'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Xlaca'n tahuanilh: ―Quina'n jā tū icka'lhīyāuj xmān macquitzis pāntzīn ē tantu' squī'ti'. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesús cāhuanilh: ―Cacālī'ta'ntit. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Palaj tunca cāmāpa'ksīlh catatahui'lalh tachi'xcuhuī't nac cā'seketni'. Palaj tunca Jesús cātayalh macquitzis pāntzīn ē tantu' squī'ti' ē talacayāhualh nac a'kapūn ē maxquī'lh tapāxcatca'tzīn Dios. Cāche'keni'lh pāntzīn ē squī'ti' ē cāmaxquī'lh ī'scujnu'nī'n. Xlaca'n tamāpitzilh na ixpu'nanca'n tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ixlīpō'ktuca'n tachi'xcuhuī't tahuā'yalh ē taka'sli. A'cxni' tahuā'yankō'lh, scujnu'nī'n tamākēstokli lhūhua' xalacpītzun hasta tatzumalh pācāujtu' chā'xta tū quītāxtūlh. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Chi'xcuhuī'n tī tahuā'yalh xlaca'n a'kquitzis mil ē nā tahuā'yalh puscan ē lacstīn. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Xlītza'la Jesús cāhuanilh ī'scujnu'nī'n catatojōlh nac barco ē catapūlani'lh ixtuntacut nac mar. Xla' ixcāmacā'mā'lh tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","A'cxni' ixcāmacā'nkō'nī't, Jesús ixlīmān tā'cxtunu'lh nac sipej na'orarlīni' Dios. A'cxni' tzī'suanli, ixlīmān ixuī'lh a'ntza' ");
INSERT INTO tkuNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","līhuan ī'scujnu'nī'n ixtatētaxtumā'nalh nac xcān nac barco. Ū'nulh ē ixpuput mar ixtatā'kayāhuamā'nalh ē tasno'kli barco. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","A'cxni' xkakalh, Jesús ixcālaktalacatzuna'jītēlha xlaca'n. Ixkelhtlā'huantēlha xcān. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","A'cxni' scujnu'nī'n talaktzī'lh chā'tin tī ixkelhtlā'huantēlha xcān, cāmekē'klhalh ē tajicua'ni'lh ē palha' tahuanli: ―¡Lakachuyayāuj! ");
INSERT INTO tkuNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jesús cāhuanilh: ―Catahuixcāni'tit ē jā cajicua'ntit. Quit tī icmimā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Palaj tunca Pedro huanilh: ―Māpa'ksīni', palh ixlīcāna' hui'x, caquihua'ni' ē na'ickelhtlā'huan xcān na'iclakapāxtokān. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesús huanilh: ―Cata't. Palaj tunca Pedro tacutli nac barco ē tzuculh kelhtlā'huan xcān nalakapāxtoka Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","A'cxni' makca'tzīlh palha' ū'ni', jicua'nli ē tzuculh tā'cnū ē palha' huanli: ―¡Caquimakapūtaxtu, Māpa'ksīni'! ");
INSERT INTO tkuNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Palaj tunca Jesús macachi'palh ē huanilh: ―Xmān macsti'na'j a'ka'ī'ya'. ¿Tū ixpālacata jā quilīpāhua'na'? ");
INSERT INTO tkuNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","A'cxni' xlaca'n tatojōlh nac barco, ca'cs lalh ū'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Palaj tunca xlaca'n tī ixtahui'lāna'lh nac barco talaktaquilhpūtalh Jesús ē tahuanilh: ―Ixlīcāna' hui'x ī'Ska'ta' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ta'a'lh ixtuntacut nac xcān ē tachā'lh nac ti'ya't jā huanican Genesaret. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","A'cxni' tachi'xcuhuī't xalanī'n a'ntza' talakapasli Jesús, tamāca'tzīnīni'lh calhāxcuhuālh nac tzamā' ti'ya't. Cālīmini'ca lhūhua' ta'jatatlanī'n jā ixuī'lh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Tasqui'ni'lh cāmakxtekli xmān ixtaxa'malh ixtampān ixlu'xu'. Tatzeyalh ixlīpō'ktuca'n tī taxa'malh. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Palaj tunca makapitzīn fariseos ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn talaktalacatzuna'jīlh Jesús. Ixtaminī'ta'ncha' cā'lacchicni' Jerusalén ē takelhasqui'nīlh: ");
INSERT INTO tkuNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―Miscujnu'nī'n, ¿tū ixpālacata jā takexmatni' ixtahui'latca'n quinapapana'ca'n? Jā tamakacha'ka'n chī ixlacasqui'nca a'cxni' natahuā'yan. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesús cākelhasqui'nīlh: ―Nā hui'xina'n, ¿tū ixpālacata mākēnū'yā'tit ixlīmāpa'ksīn Dios nacāmākentaxtūyā'tit mintahui'latca'n? ");
INSERT INTO tkuNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Dios huanli: “Cacālakachi'xcuhui' mintāta' ē mintzī'.” Nā huanli: “Camaknīca tī cachīhuālh huani ixtāta' o ixtzī'.” ");
INSERT INTO tkuNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Hui'xina'n xtum hua'nā'tit. Hui'xina'n māsu'yu'yā'tit palh chā'tin chi'xcu' tzē nahuani ixtāta' o ixtzī': “Jāla icmaktāyayān. Ixlīpō'ktu tū icka'lhī icmālacnūni'nī'ttza' Dios.” ");
INSERT INTO tkuNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Hui'xina'n māsu'yu'yā'tit palh chā'tin chuntza' nahuan, jātza' ixlacasqui'nca xla' namaktāya ixtāta' o ixtzī'. Chuntza' hui'xina'n mākēnu'yā'tit ixlīmāpa'ksīn Dios ē māsu'yuyā'tit ixlacasqui'nca namākentaxtūcan mintahui'latca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Tlahua'pā'na'ntit a'ktu' milacanca'n! Ixlīcāna' chī cālīchihuīna'ni' hui'xina'n profeta Isaías a'cxni' tzo'kli huā'mā': ");
INSERT INTO tkuNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Tzamā' tachi'xcuhuī't xmān tahuan quintalakachi'xcuhuī'. Jā talacapāstaca tū iccālīmāpa'ksīlh. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Jā tū līmacuan chī quilaktaquilhpūta. Tū tamāsu'yu, ū'tza' xmān ixtalacapāstacni'ca'n chi'xcuhuī'n. Chuntza' tzo'kli Isaías chī huanli Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Palaj tunca Jesús cāta'satīnīlh tachi'xcuhuī't ē cāhuanilh: ―Caquilākexmatni'uj ē caca'tzītit: ");
INSERT INTO tkuNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Jā ū'tza' tū naquilhtanū chi'xcu' ē chuntza' nalīka'lhī ixcuenta. Tū jā tze tachihuīn tū naquilhtaxtu chi'xcu', ū'tza' nalīka'lhī ixcuenta. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Palaj tunca ī'scujnu'nī'n talaktalacatzuna'jīlh ē tahuanilh Jesús: ―¿Ē ca'tzīya' palh cālīmakasītzī'ya' fariseos chī hua'na'? ");
INSERT INTO tkuNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Xla' cākelhtīlh: ―Catūxcuhuālh līcha'nat tū jā cha'nli quinTāta' xala' nac a'kapūn, ū'tza' natampu'lhucan pō'ktu ixtankēxē'k. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Cacāmakxtektit fariseos. Xlaca'n hua'chi lakatzī'nī'n tī talē'n ā'makapitzīn lakatzī'nī'n. Palh chā'tin lakatzī'n napekechi'palē'n ixtā'lakatzī'n, ixchā'tu'ca'n natatamakahuasa jā pulhucunu'ncanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Palaj tunca Pedro huanilh Jesús: ―Caquilāhuaniuj tū huanicu'tun huā'mā' tū huanti. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús huanilh: ―¿Ē jā kexpa'tā'tit nūn hui'xina'n? ");
INSERT INTO tkuNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ca'tzīyā'tit catūxcuhuālh tū naquincāquilhtanūyān, ū'tza' natojō na quimpūlacni'ca'n ē ā'līstān nataxtu. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tachihuīn tū naquincāquilhtaxtuyān, ū'tza' tū lacapāstacnī'tauj pūla. Ū'tza' nalītasu'yu palh tze quina'n o jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Chuntza' chī lacapāstacna'n chi'xcu', chuntza' natlahua: namaknīni'n, o naka'lhī ixtā'lāpāxquī'n, o naka'lhāna'n, o na'a'kskāhuī'nin, o na'a'ksa'nīni'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Pō'ktu tzamā' tū jā tze tū tlahua, ū'tza' nalactlahua chi'xcu'. Palh nahuā'yan a'cxni' jā macacha'ka'nī't chuntza' chī ixtahui'latca'n Fariseos, ū'tza' jātū huanicu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús taxtulh a'ntza' ē a'lh ā'lacatin jā tahui'lāna'lh a'ktu' cā'lacchicni' tū huanican Tiro ē Sidón. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ixui'lacha' chā'tin puscāt xala' nac tzamā' ti'ya't jā huanican Canaán. Xla' jā israelita ixuanī't. Lakmilh Jesús ē huanilh: ―Māpa'ksīni', hui'x ī'xū'nātā'nat David tī xa'icka'lhīmā'nauj; caquilakalhu'ma'nti. Quintzu'ma'jāt ka'lhī jā tzeya ū'ni' ē palha' pātīni'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesús jā tū līkelhtīlh. Palaj tunca tamilh ī'scujnu'nī'n ē tahuanilh: ―Tzamā' puscāt quincāstālani'yān ē ta'satēlha. Cama'capi a'jnanu'. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Palaj tunca Jesús huanli: ―Dios quimacaminī't na'iccāmakapūtaxtū xmān tī israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Puscāt laktalacatzuna'jīlh ē tatzokostani'lh Jesús ē huanilh: ―¡Māpa'ksīni', caquimaktāya'! ");
INSERT INTO tkuNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesús kelhtīlh: ―Jā minī'ni' maktīcan ixpāntzīnca'n lacstīn ē nacāmaxquī'can līchichīn. (Chuntza' huanilh ixpālacata israelitas jā ixtalakachi'xcuhuī' tī jā israelitas ē ixcāmāpācuhuī chichīn.) ");
INSERT INTO tkuNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Xla' huanilh: ―Jē, ixlīcāna', Māpa'ksīni'. Masqui icca'tzītza', chichīn tzē natasacua' tū nayuja na ixmesa ixtēcu'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Palaj tunca Jesús kelhtīlh: ―Tzej a'ka'ī'ya', puscāt. Calalh chī quisqui'ni'ya'. Tzamā' puntzuna' palaj tunca tzeyanli ixtzu'ma'jāt. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús taxtulh a'ntza' ē tētaxtulh ixquilhtūn lago Galilea. Ā'līstān tā'cxtunu'lh nac sipej ē a'ntza' tahuī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Līlhūhua' tachā'lh jā ixuī'lh ē talīmini'lh lū'ntū'nunī'n ē lakatzī'nī'n ē tī kō'ko'n ixtahuanī't ē tī macastuntu'lu'n ixtahuanī't ē lhūhua' ā'makapitzīn ta'jatatlanī'n. Cāmāpī'ca nac ti'ya't lacatzuna'j ixtujan Jesús ē xla' cāmātzeyīlh ixlīpō'ktuca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tachi'xcuhuī't talī'a'cnīlh chī tachihuīna'nli tī kō'ko' ixtahuanī't ē chī tze tahuanli ixmacanca'n macastuntu'. Ē tī ixtalū'ntū'nunī't tzej tatlā'huanli ē lakatzī'nī'n talacahuāna'lh. Ū'tza' talī'a'cnīlh tachi'xcuhuī't. Tatzuculh tamakapāxuī Dios tī ixDiosca'n israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Palaj tunca Jesús cāta'sani'lh ī'scujnu'nī'n ē cāhuanilh: ―Iccālakalhu'man tachi'xcuhuī't. Tu'tuma'jtza' quintatā'lahui'lāna'lh huā'tzā' ē jātza' taka'lhī tū tahua'. Palh na'iccāmacā'n na ixchicca'n ē jā tahuā'yanī't, palhāsā' nataxlajua'nan nac tej. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Palaj tunca ī'scujnu'nī'n tahuanilh: ―¿Chī nalīka'lhīyāuj līhua't tū natalīka'sa? Lhūhua' tachi'xcuhuī't ē jā tī huī'lh huā'tzā'. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús cākelhasqui'nīlh: ―¿Chī maclā't pāntzīn ka'lhī'yā'tit? Xlaca'n takelhtīlh: ―Mactojon ē makapitzīn xalacstīn squī'ti'. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Palaj tunca Jesús cāmāpa'ksīlh catatahui'lalh tachi'xcuhuī't nac ti'ya't. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Xla' cātayalh mactojon pāntzīn ē squī'ti' ē maxquī'lh tapāxcatca'tzīn Dios. Palaj tunca cāmāpitzini'lh ē cāmaxquī'lh ī'scujnu'nī'n ē xlaca'n cāmaxquī'lh tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ixlīpō'ktuca'n tahuā'yalh ē talīka'sli. Ā'līstān xalacpītzun tū taquītāxtūlh cāmātzumalh pātojon chā'xta. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tī tahuā'yalh, xlaca'n a'ktā'ti' mil chi'xcuhuī'n. Nā tahuā'yalh puscan ē lacstīn. ");
INSERT INTO tkuNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ā'līstān Jesús cāmacā'lh tachi'xcuhuī't ē tojōlh nac barco ē a'lh nac a'ktin ti'ya't jā huanican Magdala. ");
INSERT INTO tkuNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseos ē saduceos talaka'lh Jesús. Ixtalīlaktzī'ncu'tun, ē tasqui'nli a'ktin lī'a'cnīn tū nalītasu'yu Jesús xala' nac a'kapūn. ");
INSERT INTO tkuNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Xla' cākelhtīlh: ―A'cxni' tā'cnūmā'lh chi'chini' hui'xina'n hua'nā'tit: “Jā catimilh xcān ixpālacata tzu'tzo'ko a'kapūn.” ");
INSERT INTO tkuNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Palh tzi'saj, hua'nā'tit: “Chuhua'j namin xcān ixpālacata tzu'tzo'ko a'kapūn ē pucsuī'lh.” ¡Hui'xina'n tlahua'yā'tit a'ktu' milacanca'n! Tzē namālakchipini'yā'tit palh namin xcān a'cxni' laktzī'nā'tit a'kapūn. Masqui laktzī'nā'tit lī'a'cnīn tū ictlahua, jā a'ka'ī'ni'yā'tit Dios quimacamilh. ");
INSERT INTO tkuNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tachi'xcuhuī't tī tahui'lāna'lh chuhua'j jā tze ē jā ta'a'ka'ī' ē xlaca'n tasqui'n lī'a'cnīn. Jā nacāmāsu'yuni'can lī'a'cnīn; xmān naquina'kspula chuntza' chī a'kspulalh Jonás ―huanli Jesús. Cāmakxtekli ē a'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","A'cxni' scujnu'nī'n ta'a'lh ixtuntacut nac xcān, jā talē'lh pāntzīn. Ixtapātza'nkānī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Palaj tunca Jesús cāhuanilh: ―Cuenta catlahua'tit ixlevaduraca'n fariseos ē saduceos. ");
INSERT INTO tkuNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Scujnu'nī'n talātā'chihuīna'lh ē talāhuanilh: ―Chuntza' huanli ixpālacata jā līmiuj pāntzīn. ");
INSERT INTO tkuNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús ixca'tzī tū ixtalāhuanimā'nalh ē chī xlaca'n jā ixtaca'tzī ixlīchihuīna'mā'lh tū ixtamāsu'yu fariseos. Ū'tza' cālīhuanilh: ―¿Tū ixpālacata lī'a'ktuyunā'tit pāntzīn tū jā līta'ntit? ¡Xmān macsti'na'j a'ka'ī'yā'tit! ");
INSERT INTO tkuNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ē jāna'j ca'tzīyā'tit? ¿Ē jātza' lacapāstacā'tit macquitzis pāntzīn tū iccāmāpitzini'lh a'kquitzis mil chi'xcuhuī'n? ¿Chī pālā't chā'xta cālīmātzumatit xalacpītzun? ");
INSERT INTO tkuNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Calacapāstactit mactojon pāntzīn tū iccāmāpitzini'lh a'ktā'ti' mil chi'xcuhuī'n. ¿Chī pālā't chā'xta cālīmātzumatit xalacpītzun? ");
INSERT INTO tkuNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Tū ixpālacata jā ca'tzīyā'tit palh jā pāntzīn xa'iclīchihuīna'mā'lh a'cxni' iccāhuanin cuenta ixtlahua'tit ixlevaduraca'n fariseos ē saduceos? ");
INSERT INTO tkuNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Palaj tunca taca'tzīlh Jesús jā ixcāhuaninī't cuenta ixtatlahualh ixlevadura pāntzīn. Ixcāhuanicu'tun palh cuenta ixtatlahualh ixtamāsu'yunca'n fariseos ē saduceos. ");
INSERT INTO tkuNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","A'cxni' Jesús chā'lh jā huanican Cesarea Filipo, cākelhasqui'nīlh ī'scujnu'nī'n: ―Tachi'xcuhuī't, ¿chī tahuan quimpālacata quit tī Chi'xcu' xala' Tālhmā'n? ");
INSERT INTO tkuNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Xlaca'n takelhtīlh: ―Makapitzīn tahuan mat hui'x Juan Mā'kpaxīni'. Ā'makapitzīn tahuan mat hui'x Elías. Ā'makapitzīn tahuampala mat hui'x Jeremías o ā'chā'tin a'kchihuīna'. ");
INSERT INTO tkuNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Palaj tunca cākelhasqui'nīlh: ―Ē hui'xina'n ¿chī hua'nā'tit tīchu quit? ");
INSERT INTO tkuNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Palaj tunca Simón Pedro huanilh: ―Hui'x Cristo tī xa'icka'lhīmā'nauj ē ī'Ska'ta' Dios xaxlīcāna'. ");
INSERT INTO tkuNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesús kelhtīlh: ―Līpāxuhua hui'x, Simón ixka'hua'cha Jonás. Huā'mā' talacapāstacni' jā tamāsu'yuni'n chi'xcuhuī'n. Xmān Dios māca'tzīnīn. ");
INSERT INTO tkuNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Quit icuaniyān hui'x Pedro ē ū'tza' mintacuhuīni' huanicu'tun “chihuix.” Hui'x nalaya' hua'chi chihuix tū nalīmātzucucan quintemplo. Ixlīpō'ktuca'n tī ta'a'ka'ī', jāla caticāskāhuī'ca; nūn līnīn jāla caticāskāhuī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Quit na'icmaxquī'yān lītli'hui'qui ē nacāmāpa'ksī'ya' xlaca'n tī tatapa'ksīni' Dios. Tū hui'x makxteka tatlahua tī ta'a'ka'ī' huā'tzā' nac cā'quilhtamacuj, nā nala chuntza' nac a'kapūn. Tū hui'x jā makxteka tatlahua tī ta'aka'ī' huā'tzā' nac cā'quilhtamacuj, nā chuntza' calalh nac a'kapūn. ");
INSERT INTO tkuNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Palaj tunca Jesús cāmāpa'ksīlh ī'scujnu'nī'n jā catitahuanilh jā tī chā'tin palh ū'tza' Cristo tī ixka'lhīmā'ca. ");
INSERT INTO tkuNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Palaj tunca Jesús tzuculh cāmāsu'yuni' ī'scujnu'nī'n chuntza': ―Ixlacasqui'nca na'ica'n nac Jerusalén. A'ntza' naquintamakapātīnīn xanapuxcu'nu' xala' nac templo ē xanapuxcu'nu' pālejni' ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn. Naquintamaknī. Ixlī'a'ktu'tun quilhtamacuj na'iclacastālancuana'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Palaj tunca Pedro lē'lh lacapunchuna'j ē tzuculh tā'lāhuan ē tzē'k huanilh: ―¡Māpa'ksīni', jā camakxtekli Dios! ¡Jā cati'a'kspulan chuntza'! ");
INSERT INTO tkuNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesús talakspi'tli ē huanilh Pedro: ―¡Catakēnu'! Hui'x lacapāstacna'na' chuntza' chī skāhuī'ni'. Hui'x quimāmakchu'yī'ya'. Hui'x jā ka'lhī'ya' ixtalacapāstacni' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Palaj tunca Jesús cāhuanilh ī'scujnu'nī'n: ―Palh catīxcuhuālh quintā'tapa'ksīcu'tun quit, jātza'la catilacapāstaclī xmān tū ū'tza' lacasqui'n. Calīhui'līlh natlahua quintalacapāstacni' masqui capātīni'lh chuntza' chī quit na'icpātīni'n ē caquistālani'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tī ta'a'kapūtaxtucu'tun tū natalīpātīni'n quimpālacata, jā catitaka'lhīlh ixlatamatca'n tū jā catilaksputli. Tī natapātīni'n masqui catalīnīlh quimpālacata, xlaca'n nataka'lhī ixlatamatca'n tū jā catilaksputli. ");
INSERT INTO tkuNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Palh chā'tin chi'xcu' ixtlajakō'lh ixlīpō'ktu xala' nac cā'quilhtamacuj, jā tū līmacuan palh jā ka'lhī ixlatamat tū jā catilaksputli. Jā tū a'nan tū xla' tzē namāstā' ē naka'lhī ixlatamat tū jā catilaksputli. ");
INSERT INTO tkuNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Quit Chi'xcu' xala' Tālhmā'n ē na'icmimpala ē na'icka'lhī ixlītli'hui'qui xaTāta' ē na'icxkaka chī xkaka quinTāta' nac a'kapūn. Naquintatā'min quinángeles. A'cxni' na'icmin, chā'tunu' naxoko chuntza' chī tlahuanī't palh tze o jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ixlīcāna' tū iccāhuaniyān. Makapitzīn tī tahui'lāna'lh huā'tzā' chuhua'j ē xlaca'n jā catitanīlh a'cxni' jāna'j naquilaktzī'ncan quit Chi'xcu' xala' Tālhmā'n a'cxni' na'icmimpala na'icmāpa'ksīni'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ixlīlakachāxan quilhtamacuj Jesús cālē'lh Pedro ē Jacobo ē Juan tī ixtā'tin Jacobo ē tatā'a'lh. Xmān ixkelhatā'ti'ca'n ta'a'lh a'ktin nac sipej tālhmā'n ē tatā'cxtulh. ");
INSERT INTO tkuNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","A'ntza' talakpalīlh Jesús ē xtum ixtasu'yu na ixlacatīnca'n. Ixlacan Jesús xkakalh hua'chi chī xkaka chi'chini' ē ixlu'xu' stala'nka' huanli hasta xkakalh. ");
INSERT INTO tkuNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Palaj tunca cātasu'yuni'lh Moisés ē Elías tī ixtatā'chihuīna'mā'nalh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Palaj tunca Pedro huanilh Jesús: ―Māpa'ksīni', xalītze hui'lāna'uj huā'tzā'. Palh lacasqui'na', quina'n na'icyāhuayāuj a'ktu'tun mū'xta'ka'. A'ktin mila' nahuan ē a'ktin ixla' Moisés ē a'ktin ixla' Elías. ");
INSERT INTO tkuNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ixchihuīna'mā'lhcus Pedro ē milh a'ktin poklhnu' snapapa ē cālītamacsti'li'lh. Takexmatli a'ktin tachihuīn nac poklhnu' ē huanli: ―Ū'tza' huā'mā' quiSka'ta' ē laktza' icpāxquī'. Xla' quimakapāxuī. Cakexpa'ttit tū huan. ");
INSERT INTO tkuNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","A'cxni' scujnu'nī'n takexmatli huā'mā' tachihuīn, lacataj tatamā'lh ē tajicua'nli. ");
INSERT INTO tkuNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Palaj tunca Jesús cālaktalacatzuna'jīlh ē cāxa'malh ē cāhuanilh: ―Catāquī'tit ē jā cajicua'ntit. ");
INSERT INTO tkuNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","A'cxni' tatāquī'lh ē talaktzī'lh, jā tī chā'tin ixa'nan, xmān Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","A'cxni' ixtatayujmā'nalh nac sipej, Jesús cāmāpa'ksīlh: ―Jā tī chā'tin catihua'ni'tit tū laktzī'ntitcus. Jā catihua'ntit hasta a'cxni' Chi'xcu' xala' Tālhmā'n nalacastālancuana'n na ixlacpu'na'i'tātca'n nīnī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Palaj tunca scujnu'nī'n takelhasqui'nīlh Jesús: ―¿Tū ixpālacata tahuan xamākelhtahua'kē'ni'nī'n līmāpa'ksīn palh xapūla namin Elías ē ā'līstān namin Cristo tī Dios namacamin? ");
INSERT INTO tkuNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús cākelhtīlh: ―Ixlīcāna' huā'mā'. Pūla namin Elías ē nalaccāxtlahuakō' ixlīpō'ktu. ");
INSERT INTO tkuNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Iccāhuaniyān milhtza' tī huanican Elías ē jā tī lakapasli. Chi'xcuhuī'n tatlahuani'lh chuntza' chī ixtalacasqui'n. Nā chu chuntza' Chi'xcu' xala' Tālhmā'n namakapātīnīncan ―cāhuanilh. ");
INSERT INTO tkuNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Palaj tunca scujnu'nī'n taca'tzīlh a'cxni' Jesús huanli ixminī'ttza' Elías, ixlīchihuīna'mā'lh Juan Mā'kpaxīni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","A'cxni' tachā'lh jā ixtahui'lāna'lh tachi'xcuhuī't, chā'tin chi'xcu' laktalacatzuna'jīlh ē tatzokostani'lh Jesús ē huanilh: ");
INSERT INTO tkuNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Māpa'ksīni', calakalhu'ma'nti quinka'hua'cha. Paxnīni'n ē palha' pātīni'n. Maklhūhua'tza' chi'chinli nac macscut ē tojōlh nac xcān. ");
INSERT INTO tkuNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Iccālīmini'lh miscujnu'nī'n ē jāla tamātzeyīlh. ");
INSERT INTO tkuNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús cāhuanilh: ―¡Hui'xina'n tachi'xcuhuī't tī jā tzej lacapāstacna'nā'tit ē jā a'ka'ī'yā'tit! ¿Hasta jā'cxni' na'iccātā'tahui'layān hui'xina'n ē jā nakexpa'tā'tit? ¿Hasta jā'cxni' na'iccātāyani'yān hui'xina'n? Caquilī'ta'ni' ka'hua'cha. ");
INSERT INTO tkuNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Palaj tunca Jesús lacaquilhnīlh jā tzeya ū'ni' ē palaj tunca taxtuni'lh ka'hua'cha. Xamaktin tzeyanli. ");
INSERT INTO tkuNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ā'līstān scujnu'nī'n ixlīmānca'n ixtatā'chihuīna'mā'nalh Jesús ē takelhasqui'nīlh: ―¿Tū ixpālacata quina'n jāla icmāxtuni'uj ka'hua'cha jā tzeya ū'ni'? ");
INSERT INTO tkuNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús cākelhtīlh: ―Hui'xina'n jā a'ka'ī'yā'tit. Ū'tza' jāla līmaxtutit. Ixlīcāna' tū iccāhuaniyān. Palh lī'a'ka'ī'yā'tit ixlīpō'ktu milīstacna'ca'n masqui tzucupā'na'ntitcus a'ka'ī'yā'tit, tzē ixua'ni'tit huā'mā' sipej: “Catapānu' huā'tzā' ē capit ā'lacatin”, ē sipej natapānū. Jā tū a'nan tū jāla catitlahua'tit palh ixlīcāna' a'ka'ī'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Huā'mā' jā tzeya ū'ni' hua'chi jāla māxtucan. Xmān tzē namāxtucan palh nalīhui'līyā'tit jā catihuā'ya'ntit ē natlahua'yā'tit oración. ");
INSERT INTO tkuNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","A'cxni' ixtatētaxtumā'nalh nac estado Galilea, Jesús cāhuanilh ī'scujnu'nī'n: ―Quit Chi'xcu' xala' Tālhmā'n ē naquimacamāstā'can na ixmacanca'n chi'xcuhuī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Xlaca'n naquintamaknī ē ixlī'a'ktu'tun quilhtamacuj na'iclacastālancuana'n ―cāhuanilh. Huā'mā' tachihuīn cālīmakalīpuhuanli. ");
INSERT INTO tkuNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","A'cxni' Jesús ē ī'scujnu'nī'n tachā'lh nac cālacchicni' Capernaum, talakmilh Pedro tī ixtamātā'jīni'n nac templo. Takelhasqui'nīlh: ―¿Ē jā xoko tū ixla' templo mimākelhtahua'kē'ni'? ");
INSERT INTO tkuNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro cākelhtīlh: ―Xoko. Palaj tunca a'cxni' Pedro tanūlh nac chic, Jesús pūla chihuīna'nli ē huanilh: ―¿Chī puhua'na', Simón? Reyes xalanī'n huā'mā' cā'quilhtamacuj, ¿tīchu mātā'jīni'n līxokot? ¿Ē cāmātā'jī tī māpa'ksīni'n o tī māpa'ksīcan? ");
INSERT INTO tkuNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro kelhtīlh: ―Mātā'jīcan tī māpa'ksīcan. Jesús huanilh: ―Ē jā taxoko xlaca'n tī tatapa'ksīni' rey. QuinTāta' nac a'kapūn hua'chi rey ē quina'n tapa'ksīni'yāuj xla'. ");
INSERT INTO tkuNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Masqui chuntza', jā cāmakasītzī'ncu'tunāuj tī tamātā'jīni'n. Ē capit nac lago ē camojo' minanzuelo. Squī'ti' tū pūla namācutūya', namākelhpitziya' ē namacla'ya a'ktin tumīn. Ū'tza' na'a'cchā'n tū nalīxokocan. Calī'pi ē nalīxoko'ya' chī quinchā'tu'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Palaj tunca scujnu'nī'n talaktalacatzuna'jīlh Jesús ē takelhasqui'nīlh: ―¿Tīchu ā'chulā' ixlacasqui'nca jā Dios māpa'ksīni'nkō'? ");
INSERT INTO tkuNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Palaj tunca Jesús māta'satīnīni'lh chā'tin a'ctzuna'j ka'hua'cha ē yāhualh na ixlacpu'na'i'tātca'n ");
INSERT INTO tkuNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ē cāhuanilh: ―Ixlīcāna' tū iccāhuaniyān. Palh hui'xina'n jā talakpalī'yā'tit ē nalītaxtuyā'tit hua'chi chā'tin a'ctzuna'j ka'hua'cha, jā catitanū'tit jā Dios māpa'ksīni'nkō'. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Chuntza' catīxcuhuālh tī ā'chulā' ixlacasqui'nca jā Dios māpa'ksīni'nkō', ū'tza' huā'mā' tī jā ka'tla' makca'tzī ē na'a'ka'ī' chī lacstīn ta'a'ka'ī'. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Catīxcuhuālh tī quintapa'ksīni' quit ē ū'tza' nalīpāxquī' chā'tin a'ctzuna'j ka'hua'cha hua'chi huā'yālh, ū'tza' hua'chi quit quimpāxquī'. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jesús cāhuanipālh: ―Palh catīhuālh chihuīna'makasītzī' chā'tin a'ctzuna'j ka'hua'cha tī quina'ka'ī'ni' ē chuntza' ka'hua'cha nalītlahua tū jā tze, huā'mā' chi'xcu' jā tze. Xatze ixpixchī'hua'ca'ca a'ktin ka'tla' chihuix ē ixmojōca nac mar jā pūlhmā'n ē najicsua'. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Koxa tila tachi'xcuhuī't xalanī'n cā'quilhtamacuj ixpālacata jā tze tū huī'lh! Pō'ktu huī'lh tū nacāmāmakahuasī tachi'xcuhuī't. ¡Koxa titala xlaca'n tī tamāmakahuasī ā'makapitzīn ē tamātlahuī tū jā tze! ");
INSERT INTO tkuNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Chuntza' palh mimacan o mintujan nalītlahua'ya tū jā tze, xatze ixmacacā'yuju'ca' o ixtantucā'yuju'ca' ē jā catilītlahua' tū jā tze ixpālacata mimacan o mintujan. Ā'chulā' tze palh naka'lhī'ya' milatamat tū jā catilaksputli masqui macastuntu'lu' hui'x; ē jā tze palh namacapinca'na' nac macscut pō'ktu quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Jā tze palh milakastapun nalaktzī'n catūhuālh ē ū'tza' nalītlahuacu'tuna' tū jā tze. Xatze ixmāxtu ē ixmaka' ē jā ixtlahua' tū jā tze ixpālacata milakastapun. Ā'chulā' tze palh naka'lhī'ya' milatamat tū jā catilaksputli masqui lakakentin hui'x; ē jā tze palh namacapinca'na' nac macscut pō'ktu quilhtamacuj ixpālacata a'ktu' milakastapun ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jesús cāhuanipālh: ―Jā catilakmaka' jā tī chā'tin a'ctzuna'j ka'hua'cha. Iccāhuaniyān nac a'kapūn ixángelesca'n lacstīn pō'ktu quilhtamacuj tatāya na ixlacatīn quinTāta' xala' nac a'kapūn. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Quit Chi'xcu' xala' Tālhmā'n ē icmilh iccāmakapūtaxtū tī jā ixtaka'lhī ixlatamatca'n tū jā catilaksputli. Xlaca'n hua'chi purecu' tū xatza'nkān ixtahuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Chī puhua'nā'tit? Palh chā'tin chi'xcu' cāka'lhī a'ktin ciento purecu' ē palh lakatin namakatza'nkā, ¿tū natlahua? Nacāmakxteka ā'makapitzīn noventa y nueve jā tahuā'yamā'nalh nac cā'seketni'. Na'a'n naputza purecu' tū makatza'nkānī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","A'cxni' namacla, ixlīcāna' ā'chulā' nalīpāxuhua ixpālacata huā'mā' purecu' tū maclalh ē jā ā'makapitzīn noventa y nueve tū jā tatza'nkālh. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","MinTāta'ca'n xala' nac a'kapūn nā chuntza' jā lacasqui'n natza'nkā jā tī chā'tin a'ctzuna'j ka'hua'cha. Lacasqui'n nataka'lhī ixlatamat tū jā catilaksputli ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jesús cāhuanipālh: ―Palh mintā'tin tlahuani'yān tū jā tze, catā'chihuīna' ixlīmān ē namāca'tzīnī'ya'. Palh xla' cuenta tlahua, chuntza' hui'x maktāyanī'ta' ē jātza' natlahuapala tū jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Palh mintā'tin jā cuenta tlahua a'cxni' tā'chihuīna'na', cacāmāta'satīni' ā'chā'tin o chā'tu' tī nacātā'lakpina' ē natakexmata tūchu ixpālacata lītā'chihuīna'na' mintā'tin. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Palh jāna'j cuenta tlahua, nacāhuani'ya' tī ta'a'ka'ī' a'cxni' natatakēstoka. Palh chuntza' jā cuenta tlahua, ixlacasqui'nca nalaktzī'na' hua'chi chā'tin tī jā a'ka'ī'ni' Dios o hua'chi chā'tin mātā'jīni' tī a'kskāhuī'nin. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Ixlīcana' tū iccāhuaniyān. Tū hui'xina'n jā namakxtekā'tit tū tlahuacan huā'tzā' nac cā'quilhtamacuj, nā chuntza' nahuancan nac a'kapūn. Tū hui'xina'n namakxtekā'tit natlahuacan huā'tzā' nac cā'quilhtamacuj, nā chuntza' nahuancan nac a'kapūn. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Nā iccāhuanipalayān palh chā'tu' hui'xina'n huā'tzā' nac ti'ya't ē lacxtim puhua'nā'tit tū nasqui'ni'yā'tit Dios a'cxni' na'orarlīyā'tit, quinTāta'ca'n Dios xala' nac a'kapūn nacāmaxquī'yān tū squi'ni'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Chuntza' a'ntza' jā natatakēstoka chā'tu' o kelhatu'tun quimpālacata, a'ntza' quit na'ictahui'la na ixlacpu'na'i'tātca'n ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Palaj tunca Pedro laktalacatzuna'jīlh Jesús ē kelhasqui'nīlh: ―Māpa'ksīni', ¿chī maklā't na'icmātza'nkēna'ni' quintā'tin a'cxni' naquintlahuani' tū jā tze? ¿Ē maktojon na'icmātza'nkēna'ni'? ");
INSERT INTO tkuNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús kelhtīlh: ―Quit jā icuaniyān xmān maktojon; quit icuaniyān ā'maklhūhua' maktojon namātza'nkēna'ni'ya'. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Jesús cāhuanipālh: ―Chuntza' chī Dios nalīmāpa'ksīni'n tzē nalīmālakchā'nī hua'chi chā'tin rey tī cāmātā'jīlh ī'scujnu'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ixtzucumā'lhcus a'cxni' līmini'ca chā'tin tī ixmaklaclē'n lhūhua' tumīn. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ī'scujni' jā ixka'lhī tū nalīxoko, ē ū'tza' rey līmāpa'ksīlh cacāstā'maxquī'ca ā'chā'tin ixtēcu' tasācua'. Ē ā'nā cāstā'maxquī'lh ixpuscāt ē ixlacstīn ē ixlīpō'ktu tū ixka'lhī. Chuntza' tzē nalīxoko tū ixlaclē'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Palaj tunca ī'scujni' tatzokostani'lh ixpatrón ē squi'ni'lh: “Caquilakalhu'ma'nti, quimpatrón, ē na'icxokonu'ni'kō'yān.” ");
INSERT INTO tkuNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ixpatrón lakalhu'manli ē mātza'nkēna'ni'lh tū ixlaclē'n ē makxtekli ca'a'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Xmān taxtulh tzamā' tasācua' ē tā'lāpāxtokli ā'chā'tin ixtā'tasācua' tī ixmaklaclē'n xmān macsti'na'j tumīn. Tzuculh pixpi'ta ē huanilh: “¡Caquixokonu'ni' tū quilaclī'pini'ya'!” ");
INSERT INTO tkuNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Palaj tunca tī ixtā'tasācua' tatzokostani'lh ē squi'ni'lh: “Caquilakalhu'ma'nti ē na'icxokonu'ni'kō'yān.” ");
INSERT INTO tkuNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ā'chā'tin jā lacasqui'nli ē mālacapū'lh ē māmānūnīni'lh nac pūlāchī'n hasta naxokokō' tū laclē'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ā'makapitzīn scujnu'nī'n talīmāmakchuyīlh chī tlahualh ixtā'tasācua'ca'n. Ta'a'lh tamāca'tzīnīkō' ixpatronca'n chī a'kspulalh. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Palaj tunca ixpatronca'n māta'satīnīni'lh ixtasācua' ē huanilh: “¡Hui'x quiclhlaktzī'na' tasācua'! Quit icmātza'nkēna'ni'kō'n ixlīpō'ktu tzamā' mincuenta ixpālacata quisqui'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nā hui'x ixlakalhu'ma'nti mintā'tasācua' chuntza' chī quit iclakalhu'mani'.” ");
INSERT INTO tkuNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Laktza' sītzī'lh ixpatrón ē māpa'ksīni'lh namakapātīnīncan nac pūlāchī'n hasta a'cxni' naxokokō' ixlīpō'ktu tū ixmaklaclē'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesús ā'xmān huanli: ―Nā chuntza' nacātlahuani'yān quinTāta' xala' nac a'kapūn palh hui'xina'n jā cāmātza'nkēna'ni'yā'tit mintā'tinca'n cā'tapāxuhuān. ");
INSERT INTO tkuNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","A'cxni' Jesús chihuīna'nkō'lh, taxtulh nac Galilea ē a'lh nac ti'ya't jā huanican Judea. Ū'tza' tū hui'lacha' ixtuntacut nac xcān Jordán, a'ntza' na ixquilhtūn jā tā'cxtuyachi' chi'chini'. ");
INSERT INTO tkuNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Līlhūhua' tastālani'lh ē xla' cāmātzeyīlh ixlīpō'ktuca'n a'ntza'. ");
INSERT INTO tkuNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Palaj tunca makapitzīn fariseos talaktalacatzuna'jīlh Jesús. Ixtalīlaktzī'ncu'tun ē ū'tza' talīkelhasqui'nīlh: ―¿Ē tzē makxtekcan quimpuscātca'n ē xapacan ixtacuhuīni'ca'n ixpālacata catūxcuhuālh? ");
INSERT INTO tkuNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús cākelhtīlh: ―¿Ē jā kelhtahua'kanī'ta'ntit na ixtachihuīn Dios? Chuntza' huan: “Dios cātlahualh chi'xcu' ē puscāt.” Chuntza' tlahualh a'cxni' tzuculh tzamā' cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nā huan: “Ū'tza' nacālīmakxteka ixtāta' ē ixtzī' chā'tin chi'xcu' ē natā'talacxtimī ixpuscāt. Ixchā'tu'ca'n hua'chi xmān chā'tin natalītaxtu.” ");
INSERT INTO tkuNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Chuntza' jātza' chā'tu' xlaca'n; xmān chā'tin. Chuntza' jā minī'ni' chi'xcuhuī'n nalāmāmakxtekē tū Dios cātlahualh tzaj chā'tin. ");
INSERT INTO tkuNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Palaj tunca takelhasqui'nīlh: ―¿Tū ixpālacata māpa'ksīlh Moisés catzo'kca ca'psnap ē chuntza' tzē namakxtekāuj quimpuscātca'n? ");
INSERT INTO tkuNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús cāhuanilh: ―Chuntza' tlahualh Moisés ixpālacata jā tze mintalacapāstacni'ca'n. Jā chuntza' ixuanī't a'cxni' tzuculh cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Quit iccāhuaniyān palh chā'tin chi'xcu' namakxteka ixpuscāt tī jā ka'lhī ixtā'lāpāxquī'n, ē palh natā'tamakaxtoka ā'chā'tin puscāt, huā'mā' chi'xcu' ka'lhī ixtā'lāpāxquī'n. Tī natā'tamakaxtoka chā'tin puscāt tī makxtekcanī't, nā xla' ka'lhī ixtā'lāpāxquī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Palaj tunca ī'scujnu'nī'n tahuanilh: ―Palh jicslīhua' makxtekcan, jā quincāminī'ni'yān natamakaxtokāuj. ");
INSERT INTO tkuNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús cākelhtīlh: ―Ixlīpō'ktuca'n jāla catitakexmatli huā'mā'. Xmān takexmata xlaca'n tī Dios nacāmāsu'yuni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tī jā tamakaxtoka ca'tzī tū ixpālacata jā catilītamakaxtokli. Huī'lh tī ixtamī'ni'ca'n jā catitatamakaxtokli. Tū cātlahuani'ca ixmacni'ca'n, ū'tza' jā catitatamakaxtokli ā'makapitzīn, ē ā'makapitzīn tatā'scujcu'tun Dios ē ū'tza' jā catitalītamakaxtokli. Tī tzē nakexmata huā'mā', cakexmatli. ");
INSERT INTO tkuNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Palaj tunca cālīmini'ca Jesús makapitzīn lacstīn nacā'a'cpūhui'lī ixmacan ē natlahua oración. Scujnu'nī'n tatzuculh talacaquilhnī tī ixtalīmin. ");
INSERT INTO tkuNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesús huanli: ―Cacāmakxtektit caquintalakmilh lacstīn ē jā cacāmāmakchuyī'tit. Tī natā'tapa'ksī Dios jā māpa'ksīni'nkō', xlaca'n tī naquintalīpāhuan chuntza' chī tzamā' lacstīn. ");
INSERT INTO tkuNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jesús cā'a'cpūhui'līlh ixmacan lacstīn ē ā'līstān a'lh ā'lacatin. ");
INSERT INTO tkuNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Chā'tin chi'xcu' laka'lh Jesús ē kelhasqui'nīlh: ―Hui'x tzeya Mākelhtahua'kē'ni'. ¿Tūchu xa'ictlahualh tū tze ē ū'tza' na'iclīka'lhī quilatamat tū jā catilaksputli? ");
INSERT INTO tkuNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús huanilh: ―¿Tū ixpālacata quihuani'ya' tze quit? Xmān chā'tin tī xatze ē ū'tza' Dios. Palh ka'lhīcu'tuna' milatamat tū jā catilaksputli, nacākexpa'tni'ya' ixlīmāpa'ksīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Chi'xcu' kelhasqui'nīlh: ―¿Tuchūyā līmāpa'ksīn? Jesús kelhtīlh: ―Jā timaknī'ni'na'; jā tika'lhī'ya' mintā'lāpāxquī'n; jā tika'lhāna'na'; jā tilīchihuīna'na' ā'chā'tin tū jā ixlīcāna'; ");
INSERT INTO tkuNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","cacālakachi'xcuhui' mintāta' ē mintzī'; ē cacāpāxqui' ā'makapitzīn chuntza' chī pāxquī'ca'na' mina'cstu. ");
INSERT INTO tkuNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Chi'xcu' kelhtīni'lh: ―Pō'ktu tzamā' icmākentaxtūkō'nī'ttza' hasta quilīska'ta'. ¿Tūchu quisputni'cus? ");
INSERT INTO tkuNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús huanilh: ―Palh tze huancu'tuna', caquīstā'kō'j ixlīpō'ktu tū ka'lhī'ya' ē nacāmāpitzini'ya' tumīn xcamanīnī'n ē chuntza' naka'lhī'ya' chī rico nalīhua'na' nac a'kapūn. Ā'līstān naquintā'pina'. ");
INSERT INTO tkuNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","A'cxni' chi'xcu' kexmatli huā'mā' tachihuīn, līlīpuhuanli ē a'lh ixpālacata rico ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Palaj tunca Jesús cāhuanilh ī'scujnu'nī'n: ―Ixlīcāna' tū iccāhuaniyān. Jicslīhua' natatā'tapa'ksī Dios xlaca'n tī lacricujnu'. ");
INSERT INTO tkuNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Iccāhuanipalayān jicslīhua' nalīpātlekecu'tun lakatin camello na ixtani' līxtokon. Ā'līhua'ca' jicslīhua' natanū chā'tin rico jā māpa'ksīni'nkō' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","A'cxni' takexmatli huā'mā' tachihuīn, ī'scujnu'nī'n talī'a'cnīlh ē talākelhasqui'nīlh ixlī'ū'tununca'n: ―¿Tīchu tzē na'a'kapūtaxtu? ");
INSERT INTO tkuNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús cālakalaktzī'lh ē cākelhtīlh: ―Chi'xcuhuī'n jāla tū catitatlahualh tū lī'a'kapūtaxtucan; xmān Dios tzē nacāmakapūtaxtū. ");
INSERT INTO tkuNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Palaj tunca Pedro huanilh: ―Māpa'ksīni', quina'n ica'kxtekui'līkō'uj ixlīpō'ktu tū xa'icka'lhīyāuj ē iccāstālani'mā'n. ¿Tūchu na'icka'lhīyāuj? ");
INSERT INTO tkuNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús cākelhtīlh: ―Ixlīcāna' tū iccāhuaniyān. Namin a'ktin quilhtamacuj a'cxni' xasāsti' nahuan cā'quilhtamacuj ē a'cxni' quit Chi'xcu' xala' Tālhmā'n na'ictahui'la jā māpa'ksīni'ncan. Quit na'icmāpa'ksīni'n ē hui'xina'n tī quilāstālani'nī'taujtza' nā naquilātā'māpa'ksīni'nāuj. Chā'tunu' natahui'layā'tit jā namāpa'ksīni'nā'tit. Nacātaputzāna'ni'yān xalanī'n kelhacāujtu' tribu tī israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ixlīpō'ktuca'n tī ta'a'kxtekui'līlh ixchicca'n o ixtā'timīnca'n o ixtāta'ca'n o ixtzī'ca'n o ixpuscātca'n o ixcamana'ca'n o ixti'ya'tca'n, ē palh ta'a'kxtekui'līlh quilīpālacata, ā'līhua'ca'lh nataka'lhī. Catūxcuhuālh tū ta'a'kxtekui'līlh quilīpālacata, ā'chulā' nataka'lhī. Hua'chi a'ktin ciento ixlacata ā'chulā' nataka'lhī ē nataka'lhī xasāsti' ixlatamatca'n tū jā catilaksputli. ");
INSERT INTO tkuNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Lhūhua' a'nan tī cālakachi'xcuhuī'can huā'tzā'; a'ntza' jā Dios māpa'ksīni'nkō', jā caticālakachi'xcuhuī'ca. Lhūhua' a'nan tī jā cālakachi'xcuhuī'can huā'tzā'; a'ntza' jā Dios māpa'ksīni'nkō', nacālakachi'xcuhuī'can ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesús cāhuanipālh: ―Chī Dios līmāpa'ksīni'n tzē nalīmālakchā'nīcan hua'chi chā'tin ixtēcu' pū'uva. Cā'cuhuīni' taxtulh cāputza tasācua'n tī natapu'xa uvas. ");
INSERT INTO tkuNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Cāhuanilh natatlaja ixquilhtamacujca'n ē cāmacā'lh natascuja na ixpū'uva. ");
INSERT INTO tkuNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ā'līstān taxtupālh hua'chi makna'jāstza' quilhtamacuj. Cālaktzī'lh ā'makapitzīn nac lītamāuj tī jā ixtamaclanī't ixtascujūtca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Cāhuanilh: “Nā capintit nascujā'tit na quimpū'uva ē na'iccāxokoyān chuntza' chī tlajayā'tit.” Xlaca'n ta'a'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Taxtupālh hua'chi tastu'nūt ē nā hua'chi maktu'tun kōtanū huampala ē cāmacā'lh tasācua'n nac pū'uva natascuja. ");
INSERT INTO tkuNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Chī makquitzis kōtanū a'mpālh nac lītamāuj ē cāmaclalh ā'makapitzīn tī jā ixtascujmā'nalh. Cāhuanilh: “¿Tū ixpālacata xmān tāya'yā'tit pō'ktu quilhtamacuj ē jā scujpā'na'ntit?” ");
INSERT INTO tkuNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Takelhtīni'lh: “Jā icka'lhīyāuj quimpatronca'n.” Palaj tunca cāhuanilh: “Capintit nā hui'xina'n ē nascujā'tit na quimpū'uva ē quit na'iccāxokoyān chuntza' chī tlajacan.” ");
INSERT INTO tkuNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","A'cxni' tā'cnūlh chi'chini', ixtēcu' huanilh xapuxcu' tasācua'n: “Cacāmāta'satīnīni' tasācua'n ē cacāxoko'. Pūla nacāxoko'ya' tī ā'xmān tatanūlh ē ā'līstān nacāxoko'ya' tī pūla tatanūlh.” ");
INSERT INTO tkuNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Palaj tunca tatakextimīlh xlaca'n tī tatzuculh tascuja hua'chi makquitzis ē tatlajalh ixquilhtamacujca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ā'līstān a'cxni' tatakextimīlh xlaca'n tī tatzuculh tascuja tzi'saj, tapuhuanli palh ā'chulā' ixtatlajca'n. Xmān tatlajalh ixquilhtamacujca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ē a'cxni' tamaktīni'lh ixtumīnca'n, tatzuculh ta'a'ksa'n ixpatronca'n ");
INSERT INTO tkuNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ē tahuanli: “Tzamā' kōtanūtza' tamilh; xmān tascujli a'ktin hora. Lacxtim cāxokoca chī quina'n. Quina'n icscujui pō'ktu quilhtamacuj nac chi'chini'.” ");
INSERT INTO tkuNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Patrón kelhtīlh chā'tin xlaca'n ē huanilh: “Quinamigo, quit jā ictlahuani'n tū jā tze. ¿Ē jā icuanin palh natlajaya' minquilhtamacuj? ");
INSERT INTO tkuNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Calī'pi mintumīn ē capit. Quit icxokocu'tun huā'mā' chi'xcu' tī chū'cus scujli chu lacxtim chī icxokoyān hui'x. ");
INSERT INTO tkuNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Ē jā quila' tumīn? Tzē na'icxoko chuntza' chī quintapāxuhuān. ¿Ē hui'x sītzī'ya' ixpālacata quit jā tampi'lh?” ");
INSERT INTO tkuNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","’Chuntza' tī ā'xmān ixtahuanī't, xlaca'n xapūla natahuan. Tī xapūla ixtahuanī't, xlaca'n ā'xmān natahuan ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","A'cxni' Jesús ixtā'cxtunu'mā'lh nac Jerusalén, cālē'lh ī'scujnu'nī'n lacatzuna'j ē ixlīmānca'n cāhuanilh: ");
INSERT INTO tkuNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Ca'tzīyā'tit a'mā'nauj nac Jerusalén. A'ntza' quit Chi'xcu' xala' Tālhmā'n naquintamacamāstā' na ixmacanca'n xanapuxcu'nu' pālejni' ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn. Xlaca'n natahuan caquimaknīca. ");
INSERT INTO tkuNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nā xlaca'n naquintamacamaxquī' makatiyātīn. Naquintalakapala, ē naquintakēsnoka ē naquintaxtokohua'ca'. Ixlī'a'ktu'tun quilhtamacuj na'iclacastālancuana'n na ixlacpu'na'i'tātca'n nīnī'n ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Palaj tunca laktalacatzuna'jīlh Jesús ixtzī'ca'n Jacobo ē Juan, ixka'hua'chan Zebedeo. Puscāt cālīmilh ixcamana' na ixlacatīn Jesús ē tatzokostani'lh ē squi'nli a'ktin talakalhu'mān. ");
INSERT INTO tkuNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesús kelhasqui'nīlh: ―¿Tūchu lacasqui'na'? Puscāt huanilh: ―Camāpa'ksi' tzamā' chā'tu' quincamana' natapāxtūtahui'layān jā namāpa'ksī'ni'nkōyā', chā'tin na mimpekxtūcāna'j ē ā'chā'tin na mimpekxtūxuqui. ");
INSERT INTO tkuNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesús cākelhtīlh: ―Hui'xina'n jā ca'tzīyā'tit tū quilāsqui'ni'mā'nauj. ¿Ē tzē natāyani'yā'tit palh napātīni'nā'tit chī quit na'icpātīni'n? Hua'chi chuntza' chī tzē napūko'tnunā'tit quinvaso. Xlaca'n tahuanli: ―Tzē na'ictāyani'yāuj. ");
INSERT INTO tkuNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús cāhuanilh: ―Masqui napātīni'nā'tit chuntza' chī quit, ū'tza' naquilāpāxtūtahui'layāuj, quit jāla icmāpa'ksīni'n. Xmān quinTāta' ca'tzī tīchu naquimpāxtūtahui'la. Huā'mā' pūtahuī'lh cāxui'līca xmān ixpālacataca'n tī Dios cālacsacli. ");
INSERT INTO tkuNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","A'cxni' kelhacāuj scujnu'nī'n taca'tzīlh tū kelhasqui'nīca Jesús, xlaca'n talīsītzī'ni'lh chā'tu' lītā'timīn ixpālacata pūtahuī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesús cāta'sani'lh ixlīpō'ktuca'n ē cāhuanilh: ―Hui'xina'n ca'tzīyā'tit chī ixtāyatca'n tī tamāpa'ksīnī'n nac cā'ti'ya'tna'. Palha' tamāpa'ksīni'n. Nā huī'lh tī cāmāpa'ksī xlaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Jā chuntza' catilalh na milacpu'na'i'tātca'n. Catīxcuhuālh tī ka'tla' huancu'tun na milacpu'na'i'tātca'n, ixlacasqui'nca xla' nala chī ixlacscujnī'ca'n ā'makapitzīn. ");
INSERT INTO tkuNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Catīxcuhuālh tī xapuxcu' huancu'tun na milacpu'na'i'tātca'n, ixlacasqui'nca xla' nalītaxtu hua'chi ixtasācua'ca'n ā'makapitzīn. ");
INSERT INTO tkuNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ē nacāmaktāya ā'makapitzīn chuntza' chī quit Chi'xcu' xala' Tālhmā'n. Quit jā icmilh hua'chi xatēcu'; quit icmilh na'icscuja ē na'iccāmaktāya ā'makapitzīn. Na'icmacamāstā' quilatamat ē na'iccāmakapūtaxtū līlhūhua' ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesús ē ī'scujnu'nī'n ixtataxtumā'nalh nac Jericó. Lhūhua' tachi'xcuhuī't ixtastālani'mā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ixtahui'lāna'lh lacatzuna'j nac tej chā'tu' lakatzī'nī'n. A'cxni' takexmatli ixtētaxtumā'lh Jesús, xlaca'n tatzuculh tata'sa ē tahuanli: ―Māpa'ksīni', hui'x ī'xū'nātā'nat David tī xa'icka'lhīmā'nauj. ¡Caquilālakalhu'manui! ");
INSERT INTO tkuNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tachi'xcuhuī't talacaquilhnīlh ē tahuanilh cataquilhca'cslalh. Xlaca'n ā'chulā' tata'salh ē tahuampālh: ―Māpa'ksīni', hui'x ī'xū'nātā'nat David tī xa'icka'lhīmā'nauj. ¡Caquilālakalhu'manui! ");
INSERT INTO tkuNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Palaj tunca Jesús tāyalh ē cāmāta'satīnīni'lh lakatzī'nī'n ē cākelhasqui'nīlh: ¿Tūchu lacasqui'nā'tit na'iccātlahuani'yān? ");
INSERT INTO tkuNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Xlaca'n takelhtīni'lh: ―Māpa'ksīni', iclacahuāna'ncu'tunāuj. ");
INSERT INTO tkuNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Palaj tunca Jesús cālakalhu'manli ē cāxa'mani'lh ixlakastapunca'n. Palaj tunca lakatzī'nī'n talacahuāna'lh ē tastālani'lh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","A'cxni' ixtatalacatzuna'jīmā'nalhtza' nac Jerusalén, tachā'lh nac cā'lacchicni' jā ixuanican Betfagé. A'ntza' ixlacatzuna'j sipej jā huanican Olivos. Jesús cāmāpūlīlh chā'tu' ī'scujnu'nī'n ");
INSERT INTO tkuNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ē cāhuanilh: ―Capintit nac cā'lacchicni' tū tasu'yu na milaclhtza'jca'n. A'ntza' nalaktzī'nā'tit a'ktin burro xatzī' tū chī'yāhuacanī't ē nā yālh ī'ska'ta'. Cacāxcuttit ē caquilālīmini'uj huā'tzā'. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Palh catīhuālh nacākelhasqui'nīyān: “¿Tū ixpālacata cāxcutpā'na'ntit?”, nahuaniyā'tit: “Māpa'ksīni' nacāmaclacasqui'n.” Chuntza' nacāmakxtekni'yān. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Chuntza' a'kspulalh namākentaxtū ixtachihuīn a'kchihuīna' jā tzo'kcanī't chuntza': ");
INSERT INTO tkuNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Cacāhua'ni' xalanī'n nac cā'lacchicni' jā huanican Sión: “Calaktzī'ntit. Mimā'lh mimPuxcu'ca'n. Xla' jā ka'tla' makca'tzī. Kēhuī'lh burro mimā'lh. Kēhuī'lh xaska'ta' animalh tū mācu'quī'can.” ");
INSERT INTO tkuNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Palaj tunca scujnu'nī'n ta'a'lh ē tatlahualh tū Jesús cālīmāpa'ksīlh. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Talīmini'lh xatzī' burro ē ī'ska'ta' ē talīkētlapalh ixlu'xu'ca'n ē Jesús kētahuī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Lhūhua' tachi'xcuhuī't ixa'nan. Xlaca'n tamāpī'lh ixlu'xu'ca'n nac tej. Makapitzīn tacā'lh xalacstīn ixpeken qui'hui' ē tayalh tamāpī'lh nac tej. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tī ixtapūlatēlha ē tī ixtastālatēlha tatzuculh tata'sa ē tahuanli: ―¡Camakapāxuīca ixtā'nat rey David tī ixka'lhīmā'nauj! ¡Dios casicua'lanātlahualh tī līmimā'lh ixlīmāpa'ksīn Māpa'ksīni' quinDiosca'n! ¡Calakachi'xcuhuī'ca Dios! ");
INSERT INTO tkuNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","A'cxni' Jesús tanūlh nac Jerusalén, ixlīpō'ktuca'n tī ixtahui'lāna'ncha' tatamakchuyīkō'lh ē takelhasqui'nīni'lh: ―¿Tīchu huā'mā'? ");
INSERT INTO tkuNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tachi'xcuhuī't cākelhtīlh: ―Huā'mā' ū'tza' a'kchihuīna' Jesús tī xala' nac Nazaret nac estado Galilea. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ā'līstān Jesús a'lh xaka'tla' nac templo ē tanūlh ē cātantlakaxtukō'lh ixlīpō'ktuca'n tī ixtastā'namā'nalh ē tī ixtatamāhuana'mā'nalh na ixtanquilhtīn templo. Cāmakpūspi'tni'kō'lh ixmesaca'n tī ixtapakxtumā'nalh ixtumīnca'n tachi'xcuhuī't. Nā cāmakpūspi'tni'lh ixpūtahuī'lhca'n tī ixtastā'mā'nalh pālumax. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Cāhuanilh: ―Tatzo'kni' na ixtachihuīn Dios: “Quinchic namāpācuhuīcan Chic jā Tlahuacan Oración.” Chī tlahuapā'na'ntit, līmaxtunī'ta'ntit hua'chi ixpūtatzē'kni'ca'n ka'lhāna'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","A'ntza' nac templo talaktalacatzuna'jīlh Jesús makapitzīn lakatzī'nī'n ē lū'ntū'nunī'n. Xla' cāmātzeyīlh. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Xanapuxcu'nu' pālejni' ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn a'cxni' talaktzī'lh lī'a'cnīn tū Jesús cātlahualh, xlaca'n tasītzī'lh. Nā talīsītzī'lh chī lacstīn na ixpūchakān templo tata'salh ē tahuanli: “¡Camakapāxuīca ī'xū'nātā'nat rey David tī ixka'lhīmā'nauj!” ");
INSERT INTO tkuNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Xlaca'n tahuanilh Jesús: ―¿Tū ixpālacata jā cālacaquilhni'ya' tzamā' lacstīn? ¿Ē jā kexpa'ta' tū tahuanimā'nān? Jesús cākelhtīlh: ―Jē, ickexmata. ¿Ē hui'xina'n jā kelhtahua'kanī'ta'ntit na ixtachihuīn Dios ixpālacata huā'mā'? Chuntza' tatzo'kni': Hui'x cāmāsu'yuni'nī'ta' lacstīn ē tī tatzi'quī'cus chī tzej natamakapāxuīyān. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Palaj tunca Jesús cā'a'kxtekui'līlh ē taxtulh nac cā'lacchicni' ē a'lh nac Betania jā tachokolh tzamā' tzī'sa. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ixlīlakalī a'cxni' quītaspi'tpālh nac Jerusalén, Jesús ixtzi'ncsa. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Laktzī'lh a'katin xaqui'hui' higo na ixpaxtūn tej ē talacatzuna'jīlh nac qui'hui'. Qui'hui' jā ixka'lhī ixtahua'ca't; xmān ixka'lhī xapa'lhma'. Palaj tunca Jesús huanilh xaqui'hui' higo: ―¡Jātza' ā'maktin catitahua'ca'! Xamaktin scācli xaqui'hui' higo. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","A'cxni' ī'scujnu'nī'n talaktzī'lh huā'mā', talī'a'cnīlh ē takelhasqui'nīlh Jesús: ―¿Tū ixpālacata palaj scācli qui'hui'? ");
INSERT INTO tkuNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús cākelhtīlh: ―Ixlīcāna' tū iccāhuaniyān. Palh tzej na'a'ka'ī'yā'tit ē palh jā napuhua'nā'tit Dios jāla natlahua, nā tzē natlahua'yā'tit lacxtim chī ictlahuani'lh quit qui'hui'. Nā tzē nahuaniyā'tit huā'huī'lh sipej: “Catapānu' huā'tzā' ē catojo' nac xcān”; ē nā chuntza' nala. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ixlīpō'ktu tū nasqui'ni'yā'tit a'cxni' orarlīni'yā'tit Dios, ixlīpō'ktu namaktīni'nā'tit, xmān calīpāhua'ntit Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Palaj tunca Jesús tanūlh xaka'tla' nac templo. Līhuan ixmāsu'yumā'lh, talaktalacatzuna'jīlh xanapuxcu'nu' pālejni' ē xanapuxcu'nu' israelitas. Xlaca'n takelhasqui'nīlh: ―¿Tīchu ixlīmāpa'ksīn cālītlahua'pā't tzamā'? ¿Tī maxquī'n līmāpa'ksīn? ");
INSERT INTO tkuNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús cākelhtīlh: ―Nā quit na'iccākelhasqui'nīyān catūhuālh. Palh naquilākelhtīyāuj, nā quit na'iccāhuaniyān tīchu ixlīmāpa'ksīn iccālītlahuamā'lh tzamā'. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Tīchu ixlīmāpa'ksīn ixlīmā'kpaxīni'n Juan? ¿Ixlīmāpa'ksīn Dios o ixlīmāpa'ksīnca'n chi'xcuhuī'n? Caquilākelhtīuj. Xlaca'n tatzuculh talālītā'chihuīna'n ixlīmānca'n ē talāhuanilh: ―¿Chī nahuaniyāuj? Palh nahuaniyāuj ixlīmāpa'ksīn Dios, naquincākelhasqui'nīyān: “¿Tū ixpālacata jā a'ka'ī'nī'ta'ntit?” ");
INSERT INTO tkuNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Jāla nahuaniyāuj ixlīmāpa'ksīnca'n chi'xcuhuī'n. Cājicua'ni'yāuj tachi'xcuhuī't. Ixlīpō'ktuca'n ta'a'ka'ī' Juan ixlīcāna' ixa'kchihuīna' Dios ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ū'tza' talīkelhtīlh Jesús: ―Jā icca'tzīyāuj tīchu ixlīmāpa'ksīn. Palaj tunca Jesús cāhuanilh: ―Nā chuntza' quit jā icticāhuanin tīchu ixlīmāpa'ksīn iccālītlahuamā'lh huā'mā'. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús cāhuanilh: ―¿Tū puhua'nā'tit? Ixuī'lh chā'tin chi'xcu' ē ixka'lhī chā'tu' ixka'hua'chan. Huanilh xapuxcu': “Quinka'hua'cha, capit scu'ja' na quimpū'uva chuhua'j.” ");
INSERT INTO tkuNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ixka'hua'cha kelhtīlh: “Jā ica'ncu'tun.” Ā'līstān līlīpuhuanli chī ixkelhtīnī't ixtāta' ē a'lh scuja. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ā'līstān xatāta' laka'lh xastancu ixka'hua'cha ē chuntza' huanipālh. Huā'mā' kelhtīlh: “Tze, tāta', na'ica'n”, ē jā a'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Chī puhua'nā'tit hui'xina'n? ¿Tichūyā ka'hua'cha tlahualh ixtalacasqui'nīn ixtāta'? Xlaca'n tahuanli: ―Tī pūla chihuīna'nli. Palaj tunca Jesús cāhuanilh: ―Quit iccāhuaniyān huā'mā'. Mātā'jīni'nī'n ē puscan xalanī'n nac cā'tejen, xlaca'n pūla natatanū jā Dios māpa'ksīni'nkō' ē jā hui'xina'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan Mā'kpaxīni' milh ē cāmāsu'yuni'n chī ixlacasqui'nca nalatā'kchokoyā'tit ē hui'xina'n jā a'ka'ī'nī'ta'ntit. Mātā'jīni'nī'n ē puscan xalanī'n nac cā'tejen ta'a'ka'ī'nī't. Masqui laktzī'nī'ta'ntit chī ta'a'ka'ī'lh xlaca'n, hui'xina'n jā lakpalīnī'ta'ntit mintalacapāstacni'ca'n ē jā a'ka'ī'nī'ta'ntit ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesús cāhuanilh: ―Cakexpa'ttit tzamā' ā'a'ktin tū līca'tzīni'can. Ixuī'lh chā'tin ixtēcu' ka'tla' ti'ya't ē cācha'nli mayāc tū māstā' uvas na ixti'ya't. Līculālhui'līlh chihuix ixti'ya't ē cāxtlahualh ixpūlakchi'tcan uvas ē yāhualh a'ktin torre tū napūmaktaka'lha ixpū'uva. ’Ā'līstān cāmāsācua'nīlh ti'ya't tasācua'n natascuja i'tātna'. Xla' a'lh latā'kchoko makat. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","A'cxni' chilhtza' ixpūlanan uvas, cāmacā'lh ā'makapitzīn ixlacscujnu'nī'n na ixpū'uva. Ta'a'lh tasqui'ni' tasācua'n catamaxquī'lh tū tamakalanī't tū ixla' ixtēcu' ti'ya't. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Cāchi'paca ē tucsca chā'tin ē maknīca chā'tin ē ā'chā'tin līcucta'laca chihuix. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ixtēcu' ti'ya't cāmacā'mpālh ā'makapitzīn ixlacscujnu'nī'n ē ā'chulā' lhūhua' cāmacā'lh. Chu lacxtim chī cātlahuaca. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Ā'xmān macā'lh ixka'hua'cha. Puhuanli: “Natalakachī'xcuhuī' quinka'hua'cha.” ");
INSERT INTO tkuNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","A'cxni' chā'lh nac pū'uva ka'hua'cha, tasācua'n talāhuanilh ixlīmānca'n: “Ū'tza' tī ixla' nahuankō' tū ka'lhī ixtāta'. Camaknīuj ē chuntza' quilaca'n nahuan pū'uva.” ");
INSERT INTO tkuNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Chuntza' chi'paca ē māxtuca nac pū'uva ē maknīca. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jesús cākelhasqui'nīlh: ―A'cxni' na'a'nācha' ixtēcu' ti'ya't, ¿tū nacātlahuani' tzamā' tī ixcāmāsācua'nīcanī't? ¿Chī puhua'nā'tit? ");
INSERT INTO tkuNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tahuanilh: ―Ixlīcāna' nacāmālaksputūkō' tzamā' tī jā tzeya tasācua'n. Nacāmāsācua'nī pū'uva ā'makapitzīn xtum tasācua'n. Xlaca'n a'cxni' natapu'xa uva, natamaxquī' tū ixla' nahuan ixtēcu'. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Palaj tunca Jesús cāhuanilh: ―¿Ē jā maktin līkelhtahua'kanī'ta'ntit na ixtachihuīn Dios ixpālacata ī'Ska'ta'? Xla' hua'chi chihuix tū lītzo'kcanī't ē chuntza' huan: Tapācna'nī'n talakmaka'lh chihuix ē tzamā' chihuix tū ā'chulā' ixlacasqui'nca. Chuntza' tlahualh Māpa'ksīni' ē quina'n iclī'a'cnīyāuj. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Chuntza' iccāhuaniyān tū Dios ixcāmaxquī'cu'tunān, ū'tza' nacāmaxquī'can ā'makapitzīn tī natatlahua ixtalacasqui'nīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Tī jā tzej takexmata quintachihuīn, xlaca'n chuntza' chī tī talī'a'kchekxlalh chihuix ē chuntza' tatakāhuī'lh. Tī jā ta'a'ka'ī' quintachihuīn, xlaca'n chuntza' chī tī cā'a'klhta'lalh ka'tla' chihuix ē cālakka'nkxli ē tanīlh ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","A'cxni' xanapuxcu'nu' pālejni' ē fariseos takexmatli tū līmāsu'yulh Jesús, taca'tzīlh Jesús ixcālīchihuīna'mā'lh xlaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Chuntza' masqui titachi'pacu'tunli Jesús, tajicua'ni'lh tachi'xcuhuī't. Tzamā' tachi'xcuhuī't tapuhuanli Jesús ixa'kchihuīna' Dios ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús tzucupālh cātā'chihuīna'n tū līca'tzīni'can ē cāhuanilh: ");
INSERT INTO tkuNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―A'cxni' Dios nacāmāpa'ksīni'nkō', ū'tza' nala hua'chi a'cxni' chā'tin rey tlahualh cā'tani' a'cxni' tamakaxtokli ixka'hua'cha. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Cāmacā'lh ī'scujnu'nī'n ē ta'a'lh cāmāta'satīnīni'lh tī ixcā'invitarlīcanī't; xlaca'n jā ixtamincu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Cāmacā'mpālh ā'makapitzīn scujnu'nī'n ē cāhuanilh: “Cacāhua'ni'tit tī iccā'invitarlīnī't tacāxni'jtza' huī'lh līhua'. Iccāmaknīlhtza' huācax ē xako'ntin xaska'ta' huācax ē iccāxui'līkō'lhtza' natamakaxtokcan. Catamilh quinamigos.” ");
INSERT INTO tkuNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tī ixcā'invitarlīcanī't jā cuenta tatlahualh. Chā'tin a'lh na ixcā'tacuxtu ē ā'chā'tin a'lh stā'nan. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ā'makapitzīn tachi'palh ī'scujnu'nī'n rey. Tatucsli ē tamaknīlh. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Palaj tunca sītzī'lh rey ē cāmacā'lh soldados nacāmaknī maknīni'nī'n ē mālhcuyunīni'lh ixcā'lacchicni'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Palaj tunca cāhuanilh ixtasācua'n: “Ixlīpō'ktu tzejtza' huī'lh natamakaxtoka quinka'hua'cha; tasu'yu xlaca'n tī iccā'invitarlīnī't jā lactze ē jā minī'ni' iccā'invitarlīnī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Capintit chuhua'j nac cā'tejen ē cacā'invitarlītit ixlīpō'ktuca'n tī natā'lāpāxtokā'tit. Catamilh nac cā'tani'; natamakaxtoka quinka'hua'cha.” ");
INSERT INTO tkuNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Scujnu'nī'n tataxtulh ē ta'a'lh nac cā'tejen. Ixlīpō'ktuca'n tī tatā'lāpāxtokli tatakēstokli ē tī tze ē tī jā tze. Chuntza' lītatzumalh chic. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Palaj tunca tanūlh rey ē cālaktzī'lh tī tamilh. Laktzī'lh chā'tin chi'xcu' tī huī'lh ē jā ixlhakā'na'nī't chī minī'ni' jā tamakaxtokmā'ca. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Huanilh: “Quinamigo, ¿tū ixpālacata tanū'nī'ta' huā'tzā' ē jā lhakā'nī'ta' milu'xu' tū minī'ni'?” Xla' jā tū huanilh; xmān ca'cs tāyalh. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Palaj tunca rey cāhuanilh tī ixtamaktāyamā'nalh: “Camacachī'tit ē catantūchī'tit ē camāxtutit nac kēpūn jā cā'pucsua'. A'ntza' nacalhuan ē nalāxca ixtatzan.” ");
INSERT INTO tkuNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jesús chihuīna'mpālh: ―Līlhūhua' tī cāmāta'satīnīni'nca ē jā lhūhua' tī cālacsacca. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Palaj tunca fariseos ta'a'lh ē tachihuīna'nli chī tzē ixtalīmālacsu'yulh Jesús ixpālacata tū huanli. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Chuntza' cāmacā'lh makapitzīn ixchi'xcuhuī'n ē tatā'a'lh ixchi'xcuhuī'n Herodes tī rey ixuanī't. Talaka'lh Jesús ē tahuanilh: ―Mākelhtahua'kē'ni', icca'tzīyāuj hui'x hua'na' tū ixlīcāna' ē nā tzej māsu'yu'ya' chī Dios lacasqui'n. Hui'x jā cātlahua'ni'ya' cuenta chī talīchihuīna'nān tachi'xcuhuī't. Lacxtim cālaktzī'na' ixlīpō'ktuca'n tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","¿Chī puhua'na' ixpālacata tū mātā'jīni'n emperador romano? ¿Inchā tze na'icxokoyāuj o jā ixlacasqui'nca? ");
INSERT INTO tkuNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesús ixca'tzī xmān ixtalīlaktzī'ncu'tun ē cāhuanilh: ―Hui'xina'n tlahua'pā'na'ntit a'ktu' milacanca'n. ¿Tū ixpālacata quilālīlaktzī'ncu'tunāuj? ");
INSERT INTO tkuNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Caquilāmāsu'yuni'uj tumīn tū līxokocan tū mātā'jīni'ncan. Līmini'ca a'ktin denario tū ixtumīnca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","A'cxni' Jesús laktzī'lh tumīn, cākelhasqui'nīlh: ―¿Tīchu ixlacan tasu'yu huā'tzā' nac tumīn ē tīchu ixtacuhuīni' tatzo'kni'? ");
INSERT INTO tkuNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Takelhtīlh: ―Ixla' emperador. Palaj tunca Jesús cāhuanilh: ―Camaxquī'tit emperador tū ixla' ē camaxquī'tit Dios tū ixla'. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","A'cxni' takexmatli huā'mā' tachihuīn, talī'a'cnīlh. Tamakxtekli ē ta'a'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Huā'mā' quilhtamacuj makapitzīn saduceos talakmilh Jesús. Saduceos ixtahuan jā catilacastālancuana'nca. Ū'tza' talīhuanilh chuntza': ");
INSERT INTO tkuNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Mākelhtahua'kē'ni', Moisés māsu'yulh palh nanī chā'tin chi'xcu' tī tamakaxtoknī'ttza' ē palh jā ka'lhī ī'ska'ta', ixlacasqui'nca ī'stancu natā'tamakaxtoka tī nīmaka'ncanī'ttza'. Xapūla ska'ta' tī nalacatuncuhuī' ixla' nahuan xapuxcu' tī nīnī'ttza'. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ixuī'lh na quilacpu'na'i'tātca'n kelhatojon lītā'timīn. Xapuxcu' tamakaxtokli ē ā'līstān nīlh. Jā tī a'nalh ī'ska'ta'; tamakxtekni'lh tī nīmaka'ncanī't ī'stancu. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nā xla' nīlh ē jā tī a'nalh ī'ska'ta'. Chuntza' a'kspulapālh ā'chā'tin xastancu ē nā ā'chā'tin hasta ā'xmān xastancu. Nā xla' nīlh ē jā tī a'nalh ī'ska'ta'. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","A'cxni' ixtanīkō'nī'ttza' lītā'timīn, ā'xmān nīlh puscāt. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","A'cxni' nalacastālancuana'ncan, ¿tīchu ixla' nahuan tzamā' puscāt? Ixkelhatojonca'n ixtatā'tamakaxtoknī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús cākelhtīlh: ―Hui'xina'n tā'kskāhuī'nī'ta'ntit mina'cstuca'n. Jā ca'tzīyā'tit tū tatzo'kni' na ixtachihuīn Dios ē jā ca'tzīyā'tit chī ixlītli'hui'qui. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","A'cxni' nīnī'n natalacastālancuana'n, jā catitamakaxtokca ē jā catitamāstā'lh ixtzu'ma'janca'n natatamakaxtoka. Xlaca'n natala hua'chi ixángeles Dios xalanī'n nac a'kapūn. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿Ē jā kelhtahua'kanī'ta'ntit tū Dios cāhuanin ixpālacata tī natalacastālancuana'n? Chuntza' huanli: ");
INSERT INTO tkuNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Quit ixDiosca'n Abraham ē Isaac ē Jacob”, huanli. Dios ū'tza' ixDiosca'n xalakahuan ē jā ixDiosca'n xanīn. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","A'cxni' tachi'xcuhuī't takexmatli huā'mā' tachihuīn, ixlīpō'ktuca'n talī'a'cnīlh huā'mā' ixtamāsu'yun Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Fariseos tatalacxtimīlh a'cxni' takexmatli chī Jesús cāmāca'cslīlh saduceos. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Chā'tin chī xlaca'n xamākelhtahua'kē'ni' līmāpa'ksīn ixuanī't. Xla' ixca'tzīcu'tun palh Jesús ixca'tzī ixlīmāpa'ksīn Moisés ē kelhasqui'nīlh: ");
INSERT INTO tkuNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Mākelhtahua'kē'ni', ¿tuchūyā līmāpa'ksīn ā'chulā' ixlacasqui'nca tū māsu'yulh Moisés? ");
INSERT INTO tkuNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús huanilh: ―“Calīpāxqui' Māpa'ksīni' tī minDios ixlīpō'ktu milīstacna' ē ixlīpō'ktu mintalacapāstacni'.” ");
INSERT INTO tkuNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ū'tza' huā'mā' līmāpa'ksīn tū ā'chulā' xaka'tla' ē tū ā'chulā' ixlacasqui'nca. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ixlī'a'ktu' līmāpa'ksīn chu lacxtim chī ixlacasqui'nca ē huan: “Cacāpāxqui' ā'makapitzīn chuntza' chī pāxquī'ca'na' mina'cstu.” ");
INSERT INTO tkuNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Chī a'ktu' līmāpa'ksīn hua'chi ixlītzucuni' ixlīmāpa'ksīn Moisés ē ixtamāsu'yunca'n a'kchihuīna'nī'n xalanī'n makāstza'. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseos jāna'j ixta'a'n ");
INSERT INTO tkuNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ē Jesús cākelhasqui'nīlh: ―¿Tūchu līlacapāstacā'tit ixpālacata Cristo tī ka'lhīpā'na'ntit? ¿Tīchu ī'xū'nāpapna'? Tahuanilh: ―Xla' ī'xū'nātā'nat David. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Palaj tunca Jesús cāhuanilh: ―¿Tū ixpālacata David māpācuhuīlh Māpa'ksīni' chuntza' chī māsu'yuni'lh Espíritu Santo? David huanli: ");
INSERT INTO tkuNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Māpa'ksīni' Dios huanilh quiMāpa'ksīni': “Catahui'la' na quimpekxtūcāna'j hasta a'cxni' na'iccāskāhuī' mintā'lāquiclhlaktzi'.” ");
INSERT INTO tkuNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Palh David līchihuīna'lh ī'xū'nātā'nat ē māpācuhuīlh ixMāpa'ksīni', ū'tza' huanicu'tun xla' ā'chulā' xaka'tla' nalītaxtu ē jā David ―Jesús cāhuanilh. ");
INSERT INTO tkuNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jā tī chā'tin tzē kelhtīlh nūn kelhtin tachihuīn. Huā'mā' quilhtamacuj jā tī chā'tin tzē kelhasqui'nīlh. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Palaj tunca Jesús cāhuanilh ī'scujnu'nī'n ē tachi'xcuhuī't: ");
INSERT INTO tkuNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Mākelhtahua'kē'ni'nī'n līmāpa'ksīn ē fariseos taka'lhī līmāpa'ksīn natahuan tū huanicu'tun ixlīmāpa'ksīn Moisés. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Chuntza' ixlacasqui'nca natlahua'yā'tit tū tahuan ē nacākexpa'tni'yā'tit. Masqui nacākexpa'tni'yā'tit, hui'xina'n jā catitlahua'tit chī xlaca'n tatlahua ixpālacata tahuan catūhuālh ē xtum tatlahua. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Xlaca'n hua'chi tī tacāxtlahualh xatzi'nca tacu'ca' ē jā tī tī tzē natāyani'. Xlaca'n jā tamaktāyana'ncu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Talacasqui'n tachi'xcuhuī't natalaktzī'n ixlīpō'ktu tū tatlahua. Cāmūhui'lī'canī't ē cāpekemāhua'ca'canī't xalakpīka'tla' cintaj jā tatzo'knī't macsti'na'j ixtachihuīn Dios. Nā ā'chulā' pūlhmā'n taka'lhī ixlu'xu'ca'n ē jā ā'makapitzīn. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Talacasqui'n cacālakachi'xcuhuī'ca xlaca'n jā tlahuamā'ca cā'tani'. Na ixtemploca'n israelitas, xlaca'n taquilhpūlatahui'lacu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Talacasqui'n nacātā'chihuīna'ncan ē nacālakachi'xcuhuī'can nac cā'tejen ē nacāmāpācuhuīcan mākelhtahua'kē'ni'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Hui'xina'n jā calacasqui'ntit nacātamāpācuhuīyān mākelhtahua'kē'ni'nī'n. Lacxtim milīpō'ktuca'n ē lītā'timīn lanī'ta'ntit ē xmān chā'tin miMākelhtahua'kē'ni'ca'n ē ū'tza' ixlīmān Cristo. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Huā'tzā' nac cā'ti'ya'tna', jā catihua'ni'tit mintā'chi'xcu'ca'n: “Quintāta'.” Tzaj xmān chā'tin minTāta'ca'n ē ū'tza' tī hui'lacha' nac a'kapūn. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Jā catimakxtektit nacātamāpācuhuīyān māpa'ksīni'nī'n ixpālacata xmān Cristo ixlīmān miMāpa'ksīni'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Tī cāmaktāya ixlīpō'ktuca'n na milacpu'na'i'tātca'n, ū'tza' ā'chulā' xaka'tla'. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Catīxcuhuālh tī ixlīmān putza chī ā'chulā' ka'tla' nahuan, xla' namāmāxanī'can. Tī jā ka'tla' makca'tzī, ū'tza' nalakachi'xcuhuī'can. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Nalīpuhuanā'tit hui'xina'n fariseos ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn. ¡Hui'xina'n tlahua'yā'tit a'ktu' milacanca'n! Hua'chi mālacchahuanī'ta'ntit jā lactanūcan jā Dios māpa'ksīni'nkō'. Hui'xina'n jā tanū'yā'tit ē nūn cāmakxtekā'tit natatanū ā'makapitzīn. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Nalīpuhuanā'tit hui'xina'n fariseos ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn. ¡Hui'xina'n tlahua'yā'tit a'ktu' milacanca'n! Hui'xina'n cā'a'kskāhuī'maktīyā'tit ixchicca'n tī cānīmaka'ncanī't ē ā'līstān na'j tunca orarlīyā'tit a'ntza' jā tzē cātalaktzī'nān ē chuntza' lī'a'kskāhuī'ninā'tit. Ū'tza' palha' nacātalīmakapātīnīnān. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Nalīpuhuanā'tit hui'xina'n fariseos ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn. ¡Hui'xina'n tlahua'yā'tit a'ktu' milacanca'n! Hui'xina'n tlahua'yā'tit catūxcuhuālh namā'a'ka'ī'nī'yā'tit ā'chā'tin mintamāsu'yunca'n. Nā pinā'tit ixtuntacut nac mar ē lacatin nac ti'ya't. A'cxni' tastālani' tū māsu'yuyā'tit ā'chulā' jā tze natalītaxtu. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Nalīpuhuanā'tit hui'xina'n tī hua'chi lakatzī'nī'n ē cāhuanilīpincu'tunā'tit ā'makapitzīn. Hua'nā'tit: “Palh catīhuālh natlahua ixpromesa ixpālacata xaka'tla' templo, jā tū catilani'lh masqui jā mākentaxtū. Palh natlahua ixpromesa ixpālacata ixoro templo, xla' līcuesa namākentaxtū.” ");
INSERT INTO tkuNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Xalacxumpin hui'xina'n ē jā kexpa'tā'tit. Ā'chulā' ixlacasqui'nca templo. Ū'tza' līsicua'lanātlahuacanī't oro. Chuntza' ixlacasqui'nca līcuesa namākentaxtū promesa tū tlahualh ixpālacata xaka'tla' templo. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nā hua'nā'tit: “Palh catīhuālh natlahua ixpromesa ixpālacata pūmacamāstā'n, jā tū catilani'lh masqui jā mākentaxtū. Palh natlahua ixpromesa ixpālacata tū hui'līlh nac pūmacamāstā'n, xla' līcuesa namākentaxtū.” ");
INSERT INTO tkuNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Hui'xina'n jā kexpa'tā'tit. Ā'chulā' ixlacasqui'nca pūmacamāstā'n. Ū'tza' līsicua'lanātlahuacanī't tū huī'lh a'ntza'. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Chuntza' tī natlahua ixpromesa ixpālacata pūmacamāstā'n nā natlahua ixpālacata ixlīpō'ktu tū huī'lh nac pūmacamāstā'n ē ixlacasqui'nca līcuesa namākentaxtū. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Chā'tin tī nahuan ixlīcāna' ixpromesa tū huanli ixpālacata templo, xla' jā xmān līchihuīna'n templo. Nā līchihuīna'n Dios tī huī'lh nac templo. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nā chā'tin tī nahuan ixpromesa ixpālacata a'kapūn, xla' jā xmān līchihuīna'n a'kapūn. Nā līchihuīna'n ixpūtahuī'lh Dios jā māpa'ksīni'n ē nā ixpālacata Dios tī tahui'la nac pūtahuī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Nalīpuhuanā'tit hui'xina'n fariseos ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn. ¡Hui'xina'n tlahua'yā'tit a'ktu' milacanca'n! Cuenta tlahua'yā'tit ē maxquī'yā'tit Dios macsti'na'j milīhua'tca'n hua'chi ā'tuchiyē'lh ē anís ē cominos. Masqui chuntza' ixlacasqui'nca, ā'chulā' ixlacasqui'nca cuenta tlahua'yā'tit ixtamāsu'yun līmāpa'ksīn. Līmāpa'ksīn māsu'yu līlacatejtin nalatā'kchokoyā'tit, ē jā na'a'kskāhuī'ninā'tit. Nā līmāpa'ksīn māsu'yu nacālakalhu'ma'nā'tit ā'makapitzīn. Ixlacasqui'nca tzē na'a'ka'ī'ni'yā'tit Dios. Ixlacasqui'nca namāstā'yā'tit macsti'na'j līhua't ē nā ixlacasqui'nca namākentaxtūyā'tit tamāsu'yun. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Hui'xina'n hua'chi lakatzī'nī'n tī cāhuanilē'ncu'tun ā'makapitzīn. Hua'chi chuntza' chī mācutuyā'tit na milīhua'ca'n macsti'na'j kosnu' ē jā cuenta tlahua'yā'tit ka'tla' xumpepe. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Nalīpuhuanā'tit hui'xina'n fariseos ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn. ¡Hui'xina'n tlahua'yā'tit a'ktu' milacanca'n! Hui'xina'n hua'chi tī xmān makche'kē' vaso ē pulātu. Masqui tasu'yu tzeya chi'xcuhuī'n hui'xina'n, jā tze mintalacapāstacni'ca'n. Hui'xina'n tampi'lhīni'nā'tit ē ka'lhāna'nā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Hui'xina'n fariseos lakatzī'nī'n, pūla napūche'kē'yā'tit pulātu ē chuntza' nā namakche'kē'yā'tit ixmacni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Nalīpuhuanā'tit hui'xina'n fariseos ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn. ¡Hui'xina'n tlahua'yā'tit a'ktu' milacanca'n! Hui'xina'n hua'chi pūtā'cnūn tū cālītzo'kcanī't kextaj. Stala'nka' ē tzēhuanī't tatasu'yu ē na ixpūchakānca'n pō'ktu ixlucutca'n nīnī'n ē tū jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nā chuntza' hui'xina'n. Na ixlacatīnca'n tachi'xcuhuī't tasu'yu'yā'tit palh tze hui'xina'n masqui jā tze mintalacapāstacni'ca'n. Chuntza' hui'xina'n pō'ktu quilhtamacuj a'kskāhuī'ninā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Nalīpuhuanā'tit hui'xina'n fariseos ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn. ¡Hui'xina'n tlahua'yā'tit a'ktu' milacanca'n! Hui'xina'n cācāxtlahua'yā'tit ixa'cchicca'n a'kchihuīna'nī'n ē cācāxuilī'yā'tit ixpūta'cnūnca'n nīnī'n tī tzeya chi'xcuhuī'n ixtahuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Hua'nā'tit: “Palh quina'n xa'ictahui'lauj cahuālh a'cxni' ixtahui'lāna'lh quixū'nāpapna'ca'n, quina'n jā xa'icticāmaktāyauj a'cxni' tamaknīlh a'kchihuīna'nī'n.” ");
INSERT INTO tkuNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ū'tza' lītasu'yuyā'tit hui'xina'n ixnatā'natna'ca'n tī tamaknīlh a'kchihuīna'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Catlahua'tit huā'mā' tū xlaca'n talītzuculh ē jāla tatlahuakō'lh. Ū'tza' nalītasu'yu tū hui'xina'n tlahuacu'tunā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Hui'xina'n hua'chi lūhua' tū tzēhuanī't tasu'yu ē ka'lhī tū laknīcan. ¿Chī nalī'a'kapūtaxtuyā'tit nac pūpātīn? ");
INSERT INTO tkuNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Chuntza' na'iccāmacamini'yān a'kchihuīna'nī'n ē chi'xcuhuī'n tī taca'tzī ē mākelhtahua'kē'ni'nī'n. Makapitzīn nacāmaknī'yā'tit ē nacāxtokohua'ca'yā'tit. Ā'makapitzīn nacākēsnokā'tit na mintemploca'n ē nacāputzastālani'yā'tit a'katunu' cā'lacchicni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nalī'pinā'tit cuenta ixpālacata xlaca'n. Maknīcanī't Zacarías tī ixka'hua'cha Berequías ixuanī't. Maknīcanī't na ixtanquilhtīn nac templo ē na ixlacatzuna'j pūmacamāstā'n. Hui'xina'n nalī'pinā'tit cuenta ixpālacata ixlīpō'ktuca'n xatze chi'xcuhuī'n tī cāmaknīca. Tī pūla maknīca ū'tza' Abel tī jā tlahualh tū jā tze ē hui'xina'n lī'pinā'tit cuenta hasta a'cxni' maknīcanī't Zacarías. Nalī'pinā'tit cuenta ixpālacata hui'xina'n tlahua'yā'tit hua'chi chī tatlahualh xlaca'n tī tamaknīlh. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ixlīcāna' tū iccāhuaniyān. Hui'xina'n tī hui'lā'na'ntit chuhua'j nalī'pinā'tit cuenta ixpālacata ixlīpō'ktuca'n xlaca'n tī cāmaknīcanī't ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jesús cāhuanipālh: ―¡Iccālakalhu'manān hui'xina'n xalanī'n nac Jerusalén! Hui'xina'n cāmaknī'yā'tit a'kchihuīna'nī'n ē cācucta'la'yā'tit ixlacscujnī'n Dios tī cāmacamini'yān. Maklhūhua' xa'iccāmākēstokcu'tunān na'iccāmaktaka'lhān hua'chi xatzī' caxli cālīmātzē'ka ixpeken ixlacstīn. Hui'xina'n jā lacasqui'ntit. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Calaktzī'ntit hui'xina'n chī Dios makxteklitza' minchicca'n ē ixa'cstuca'n natatāya. ");
INSERT INTO tkuNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nā iccāhuaniyān jātza' quintilālaktzī'uj hasta a'cxni' namin quilhtamacuj a'cxni' nahua'nā'tit: “Sicua'lanātlahuacanī't tī mimā'lh ē ka'lhī ixlītli'hui'qui ē ixlīmāpa'ksīn Dios” ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús taxtulh nac templo. Ixa'mā'lh ā'lacatin a'cxni' talaktalacatzuna'jīlh ī'scujnu'nī'n. Xlaca'n tatzuculh tahuani cuenta ixtlahualh chī ixyāhuacanī't templo. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesús cāhuanilh: ―Calaktzī'ntit ixlīpō'ktu huā'mā' tū ixla' templo. Ixlīcāna' tū iccāhuaniyān. Namin a'ktin quilhtamacuj a'cxni' nūn a'ktin chihuix catilākēlhtahuī'lh. Ixlīpō'ktu nalaclakō'. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesús ē ī'scujnu'nī'n ta'a'lh nac sipej jā huanican Olivos. A'cxni' Jesús ixui'lacha', talaka'lh ī'scujnu'nī'n ē tzē'k tahuanilh: ―Quina'n iclacasqui'nāuj naquilāhuaniyāuj jā'cxni' na'a'kspula tzamā'. ¿Chī na'iclīca'tzīyāuj palh hui'x palaj nata'mpala'ya' ē nalaksputa cā'quilhtamacuj? ");
INSERT INTO tkuNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús cākelhtīlh: ―Cuenta catlahua'tit jā tī chā'tin nacā'a'kskāhuī'yān. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Lhūhua' chi'xcuhuī'n natahuan taka'lhī quilīmāpa'ksīn. Chā'tunu' natahuan: “Quit Cristo tī Dios lacsacnī't”, ē chuntza' līlhūhua' nacā'a'kskāhuī'can. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nakexpa'tā'tit chī sā'nan jā lacatzuna'j lamā'lh guerra ē nacātamāca'tzīnīyān chī lamā'cha' guerra makat. Jā catijicua'ntit; chuntza' pūla na'a'kspula. Jāna'j ixlī'a'ksputni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Chā'tin puxcu' ixtā'lāquiclhlaktzi' nahuan ā'chā'tin ē chā'tin māpa'ksīni' naskāhuī'cu'tun ā'chā'tin. Na'a'nan tatzi'ncstat ē ta'jatat ē natachiqui ti'ya't. Nā calhāxcuhuālh nala nac cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ixlīpō'ktu huā'mā' xmān ixlītzucuni'cus chī napātīni'ncan. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Nacātamacamaxquī'yān nacātamakapātīnīnān. Nacātamaknīyān ē ixlīpō'ktuca'n tachi'xcuhuī't calhāxcuhuālh nac cā'quilhtamacuj nacātaquiclhlaktzī'nān ē xmān quimpālacata. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","A'cxni' namin tzamā' cā'quilhtamacuj, lhūhua' natataxtutāya na ixtej Dios ē natalāquiclhlaktzī'n ē natalāmacamāstā'. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Lhūhua' a'kchihuīna'nī'n natatahui'la tī nata'a'kskāhuī'nin. Natahuan talīchihuīna'n tū ixla' Dios ē nata'a'kskāhuī' lhūhua' tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tū jā tze nata'a'kahuani calhāxcuhuālh ē ū'tza' jātza' catitalālīpāxquī'lh lhūhua' tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tī jā catitataxtutāyalh na ixtej Dios ē chuntza' natatachoko hasta a'cxni' nalaksputa, xlaca'n nacāmakapūtaxtūcan. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Xatze tachihuīn ixpālacata chī nala jā Dios namāpa'ksīni'nkō', ū'tza' huā'mā' nalī'a'kchihuīna'ncan calhāxcuhuālh nac cā'quilhtamacuj ē ixlīpō'ktuca'n xalanī'n nac cā'quilhtamacuj natakexmata. Ā'līstān a'cxni' nalaksputa. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’A'kchihuīna' Daniel tzo'kli ixpālacata chī nalactlahuacan jā sicua'lanātlahuacanī't ē chī nayāhuacan a'ntza' tū jā tze. (Quit tī ictzo'kmā'lh huā'mā', quit iccāhuaniyān hui'xina'n tī kelhtahua'kapā'na'ntit cuenta catlahua'tit.) ");
INSERT INTO tkuNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","A'cxni' nalaktzī'nā'tit tzamā', a'cxni' ixlacasqui'nca natatzā'la nata'a'n hasta nac sipej xlaca'n tī tahui'lāna'lh nac estado Judea. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Huā'mā' quilhtamacuj a'cxni' natayuja tī tahui'lāna'lh na ixa'kstīn ixchicca'n, jā catitatanūlh nac chic natamāxtu catūhuālh tū ixlaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tī tascujmā'nalh na ixcā'tacuxtuca'n, jā catitataspi'tli na ixchicca'n natalē'n ixlu'xu'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Tzamā' quilhtamacuj koxa titala puscan tī taka'lhīni'n o tī tamātzi'quī'nincus. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Casqui'ni'tit Dios jā ixlacasqui'nca natzā'la'yā'tit a'cxni' lonknu'n ē nūn quilhtamacuj tū pūjaxcan. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Napātīni'ncan a'cxni' nala huā'mā'. Hasta a'cxni' tzuculh cā'quilhtamacuj, jā maktin pātīni'ncanī't chī napātīni'ncan tzamā' quilhtamacuj. Jā maktin catilalh ixtā'chuntza' ā'līstān. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Dios cālakalhu'man xlaca'n tī cālacsacnī't ē namāmacsti'na'jī tzamā' quilhtamacuj. Palh Dios jā ixtimāmacsti'na'jīlh, jā ixta'a'kapūtaxtulh nūn chā'tin. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’A'cxni' namin tzamā' tapātīn ē palh catīhuālh ixcāhuanin: “Chā cala'ktzī'ntit. Huā'tzā' huī'lh Cristo tī Dios macaminī't”, jā cati'a'ka'ī'tit. Palh catīhuālh ixcāhuanin: “Chā cala'ktzī'ntit. A'ntza' hui'lacha'”, jā cati'a'ka'ī'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Natamin lhūhua' tī nata'a'kskāhuī'nin ē makapitzīn natahuan: “Quit Cristo.” Ā'makapitzīn natahuan: “Quina'n ixa'kchihuīna'nī'n Dios.” Xlaca'n nā natatlahua lī'a'cnīn nata'a'kskāhuī'cu'tun xlaca'n tī Dios cālacsacli. Jāla catita'a'kskāhuī'lh tī Dios cālacsacli masqui nacā'a'kskāhuī'can ā'makapitzīn. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Iccāhuanintza' huā'mā' ixpālacata jā nacāta'a'kskāhuī'yān. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Chuntza' palh nacātahuaniyān: “Cala'ktzī'ntit. A'ntza' huī'lh Cristo nac cā'tzaya'nca ti'ya't”, jā capintit. Palh nacātahuaniyān: “Cala'ktzī'ntit. Ā'tzā' huī'lh nac cuarto”, jā ca'a'ka'ī'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","A'cxni' quit na'icmimpala, nala hua'chi makli'pit tū māxkakēkō' nac a'kapūn hasta jā tā'cxtu ē hasta jā tā'cnū chi'chini'. Quit Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Calhāxcuhuālh naca'tzīcan a'cxni' na'icmin chuntza' chī chū'ni' taca'tzī jā mā'lh catūhuālh tū nīnī't ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jesús cāhuanipālh: ―Xmān ca'a'kspulakō'lh huā'mā' tapātīn, ē chi'chini' ē mālhcuyu' jā catitamāxkakēni'lh. Sta'cu nataminācha' nac a'kapūn ē hasta a'kapūn natachiqui. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nalaktzī'ncan nac a'kapūn a'ktin līmāsu'yun tū quila' quit Chi'xcu' xala' Tālhmā'n. Xalanī'n ixlīpō'ktuca'n tzamā' cā'lacchicni' huā'tzā' nac cā'quilhtamacuj, xlaca'n natacalhuan. Ē naquintalaktzī'n quit Chi'xcu' xala' Tālhmā'n chī na'ictaxtu nac a'kapūn ē na'icpūmin poklhnu'. Na'icka'lhī lhūhua' lītli'hui'qui ē tzēhuanī't na'icxkaka. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","A'cxni' namacasā'nan līskoli', na'iccāmacamin quinángeles ē natamākēstoka tī cālacsaccanī't. Natamin tī cālacsaccanī't xalanī'n calhāxcuhuālh nac cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Camaksca'ttit xaqui'hui' higo: A'cxni' tza'la'nka' ixpeken ē a'kapumā'lh xapa'lhma', hui'xina'n ca'tzīyā'tit talacatzuna'jīmā'lhtza' a'cxni' nalhcācnan. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Chuntza' a'cxni' na'a'kspula ixlīpō'ktu huā'mā' tū iccāhuaniyān, naca'tzīyā'tit talacatzuna'jīmā'lhtza' a'cxni' nasputa cā'quilhtamacuj. Talacatzuna'jīmā'lhtza' hua'chi a'cxni' chā'tin tī ka'lhīmā'ca ē yālhtza' na ixtanquilhtīn mākelhcha. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ixlīcāna' tū iccāhuaniyān. Xlaca'n tī tahui'lāna'lhcus jā catitanīlh hasta a'cxni' na'a'kspula ixlīpō'ktu huā'mā' tū iccāhuanin. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Masqui nasputa a'kapūn ē nasputa ti'ya't, jā maktin catisputli quintachihuīn; nakentaxtukō'. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Nūn tī ca'tzī jā'cxni' namin huā'mā' quilhtamacuj ē huā'mā' hora; nūn ángeles xalanī'n nac a'kapūn jā taca'tzī. Nā ī'Ska'ta' Dios jā ca'tzī. Xmān Dios xaTāta' ca'tzī jā'cxni' ixlīcāna' na'a'kspula. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Chuntza' chī a'kspulalh a'cxni' ixuī'lh Noé, nā chuntza' na'a'kspula a'cxni' namin Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","A'cxni' jāna'j ixā'min lakua xcān, tachi'xcuhuī't ixtahuā'yamā'nalh ē ixtako'tnumā'nalh. Ixtatamakaxtoka ē ixtamāstā' ixtzu'ma'janca'n natatamakaxtoka hasta a'cxni' Noé tanūlh nac arca. Jā ixtapuhuan palh namin lakua xcān, ");
INSERT INTO tkuNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ē jā cuenta tatlahualh hasta a'cxni' milh xcān ē tamuxtukō'lh. Chuntza' nala a'cxni' namin Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","A'cxni' namin tzamā' quilhtamacuj, palh talamā'nalh chā'tu' chi'xcuhuī'n nac cā'tacuxtu, nalē'ncan chā'tin ē namakxtekcan ā'chā'tin. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Palh tatanūmā'nalh chā'tu' puscan tī tasquitimā'nalh, nalē'ncan chā'tin ē namakxtekcan ā'chā'tin. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Skalalh catahui'la'tit; jā ca'tzīyā'tit jā'cxni' namin miMāpa'ksīni'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Caca'tzītit huā'mā': Palh ixtēcu' chic ixca'tzīlh cahuālh tūyā hora cā'tzī'sni' ixchā'lh ka'lhāna', ixka'lhītīlh ē jā ixtilhtatalh ē jā ixmakxtekli natanū naka'lhāna'n na ixchic. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nā chuntza' hui'xina'n tacāxni'j catahui'la'tit ixpālacata namin Chi'xcu' xala' Tālhmā'n a'cxni' jā puhua'nā'tit ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jesús cāhuanipālh: ―¿Chī huī'lh xatze tasācua' tī tzej kexmata? Xla' ū'tza' tī xatēcu' chic namacamaxquī'tāquī' ē xla' nacāmāhuī' ixtā'tasācua'n a'cxni' nalacchā'n hora. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Līpāxuhua tasācua' palh mākentaxtūmā'lh ixtascujūt a'cxni' nataspi'ta ixpatrón. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ixlīcāna' tū iccāhuaniyān. Ixtēcu' chic namacamaxquī' huā'mā' tasācua' ixlīpō'ktu tū ka'lhī. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Palh jā tze huā'mā' tasācua', xla' napuhuan natamakapalī ixpatrón. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Chuntza' natzucu cālactucsa ā'makapitzīn tasācua'n ē nacātā'huā'yan ka'chīnī'n ē nacātā'ko'ta. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Xamaktin nataspi'ta ixtēcu' chic. Namin a'ktin quilhtamacuj a'cxni' jā tzeya tasācua' jā ka'lhīmā'lh ē jā ca'tzī. ");
INSERT INTO tkuNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ixtēcu' chic palha' nacastigarlī tasācua' ē nacātā'pātīni'n xlaca'n tī jā ta'a'ka'ī'. Ē tasācua' nacalhuan ē nalāxca ixtatzan ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesús cāhuanipālh: ―A'cxni' na'icmimpala a'cxni' Dios natzucu namāpa'ksīkō' ixlīpō'ktu huā'tzā' nac cā'ti'ya'tna'. Chuntza' nala hua'chi a'cxni' kelhacāuj tzu'ma'jan ixta'a'mā'nalh jā natamakaxtokcan. Ixtalē'mā'nalh ixpūmāxkakēnca'n ē ta'a'lh taka'lhī squi'nīni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Kelhaquitzis lakskalalhna' ixtahui'lāna'lh ē ā'kelhaquitzis jā chuntza' ixtahui'lāna'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Tī jā lakskalalhna' xmān talē'lh ixpūmāxkakēnca'n ē jā talacapāstacli natalē'n macsti'na'j cās natamojō na ixpūmāxkakēnca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Tī lakskalalhna', xlaca'n talē'lh ixpūmāxkakēnca'n ē nā talē'lh ā'macsti'na'j cās. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tanajīlh squi'nīni' ē ixlīpō'ktuca'n ixtalakalhtatahui'lāna'lh ē ā'līstān talhtatalh. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Chī i'tāt tzī'sa takexmatli chī chā'tin ta'salh ē huanli: “¡Mimā'lh squi'nīni'; capintit lakapāxtokā'tit!” ");
INSERT INTO tkuNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ixlīpō'ktuca'n tzu'ma'jan talakahuanli. Tatā'kaquī'lh ē tacāxtlahualh ixpūmāxkakēnca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Palaj tunca kelhaquitzis tī jā talīmilh cās tahuanilh ā'kelhaquitzis: “Caquilāmaxquī'uj macsti'na'j mincāsca'n. Tamixcu'tumā'nalh tzamā' quimpūmāxkakēnca'n.” ");
INSERT INTO tkuNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Tī lakskalalhna' takelhtīlh: “E'ē, jā icticāmaxquī'n. Chuntza' jā quinticā'a'cchā'ni'n quina'n ē nūn hui'xina'n. Xatze capintit tamāhua'yā'tit jā stā'can.” ");
INSERT INTO tkuNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Līhuan kelhaquitzis ixta'a'nī't tatamāhua cās, chilh squi'nīni'. Tzu'ma'jan tī tacāxni'j ixtahui'lāna'lh tatā'tanūlh squi'nīni' nac chic ē mālacchahuaca. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ā'līstān tachā'lh ā'kelhaquitzis tzu'ma'jan ē tahuanli: “Māpa'ksīni', caquilāmālaquī'ni'uj.” ");
INSERT INTO tkuNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Xla' cākelhtīlh: “Quit jā iccālakapasān.” ");
INSERT INTO tkuNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jesús cāhuanilh: ―Skalalh catahui'la'tit ixpālacata jā ca'tzīyā'tit tūyā hora ē tūyā quilhtamacuj na'icmimpala quit Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jesús cāhuanipālh: ―Chī nala jā Dios namāpa'ksīni'nkō', ū'tza' hua'chi chā'tin chi'xcu' tī ixa'mā'lh ā'lacatin. Cāmāta'satīnīni'lh ī'scujnu'nī'n ē cāmaxquī'lh ixtumīnca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Chuntza' chī ixlīskalalhca'n chā'tunu', chuntza' maxquī'ca. A'kquitzis mil maxquī'ca chā'tin ē a'ktu' mil maxquī'ca ā'chā'tin ē ā'chā'tin a'ktin mil. Palaj tunca a'lh makat. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tasācua' tī ixmaxquī'canī't a'kquitzis mil, xla' ixtamāhuana'mā'lh ē ī'stā'namā'lh ē chuntza' tlajalh ā'a'kquitzis mil huampala. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Tī maktīni'lh a'ktu' mil, nā tlajapālh ā'a'ktu' mil. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tī maktīni'lh a'ktin mil, xla' a'lh ē ponknu'lh ē mātzē'kli ixtumīn ixpatrón. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Makās tamakapalīlh ixtēcu'ca'n. A'cxni' taspi'tli, ixtlahuacu'tun ixcuenta. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Pūla lakmilh tī ixmaktīni'nī't a'kquitzis mil ē nā maxquī'lh ixpatrón ā'lakaquitzis mil tū ixtlajanī't. Huanilh: “Quimpatrón, hui'x quimaxqui' a'kquitzis mil ē ā' iclīmimpala ā'a'kquitzis mil tū ictlajalh.” ");
INSERT INTO tkuNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ixtēcu' huanilh: “Tze. Tzeya tasācua' hui'x. Tzej tla'hua' mintascujūt. Tzej līscujti huā'mā' tumīn, chuhua'j nalītahua'ca'ya' ē ā'chulā' na'icmaxquī'yān. Cata't ē naquintā'pāxuhua'ya'.” ");
INSERT INTO tkuNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","’Ā'līstān lakmilh tasācua' tī ixmaktīni'nī't a'ktu' mil ē huanilh: “Quimpatrón, hui'x quimaxqui' a'ktu' mil ē ā' iclīmimpala ā'a'ktu' mil tū ictlajalh.” ");
INSERT INTO tkuNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ixtēcu' huanilh: “Tze. Tzeya tasācua' hui'x. Tzej tla'hua' mintascujūt. Tzej līscujti huā'mā' tumīn, chuhua'j nalītahua'ca'ya' ē ā'chulā' na'icmaxquī'yān. Cata't ē naquintā'pāxuhua'ya'.” ");
INSERT INTO tkuNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Ā'līstān lakmilh tasācua' tī ixmaktīni'nī't a'ktin mil. Xla' huanilh ixpatrón: “Quimpatrón, xa'icca'tzī hui'x scālājua. Hui'x ī'ya' jā jā hui'x cha'nī'ta ē cā'ya jā jā hui'x mā'kahuanī'nī'ta'. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ū'tza' iclījicua'ni'n ē quit icponknu'lh nac ti'ya't ē icmā'cnūlh mintumīn. Ā' iclīmin tū mila' ixuanī't.” ");
INSERT INTO tkuNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ixtēcu' kelhtīlh: “Jā tzeya tasācua' hui'x. Lhquitit hui'x. Hui'x puhua'na' palh quit ic'ī' jā jā iccha'nli ē iccā' jā jā quit icmā'kahuanīlh. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ū'tza' ixlīmā'nu' quintumīn nac banco ē a'cxni' xa'ictaspi'tli xa'icmaktīni'lh quintumīn ē ī'ska'ta'.” ");
INSERT INTO tkuNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Cāhuanilh tī ixtayāna'ncha': “Camaktītit a'ktin mil tū ka'lhī ē camaxquī'tit tī ka'lhī a'kcāuj mil.” ");
INSERT INTO tkuNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Jesús cāhuanipālh: ―Ā'chulā' namaxquī'can tī ka'lhī ē naquītāxtūni'. Tī jā ka'lhī, namaktīcan macsti'na'j tū ixka'lhī. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Huā'mā' tasācua' tī jā tze, catamaxtutit ē camacapintit jā cā'pucsua'. A'ntza' nacalhuan ē nalāxca ixtatzan. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesús chihuīna'mpālh: ―Quit Chi'xcu' xala' Tālhmā'n. A'cxni' na'ictanū quilīPuxcu', quinángeles naquintalītamacsti'li'. Quit na'ictahui'la na quimpūtahuī'lh jā na'iccāputzāna'nī ē na'icmāpa'ksīni'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tachi'xcuhuī't xalanī'n calhāxcuhuālh nac cā'quilhtamacuj natatalacxtimī na quilacatīn. Quit na'iccāmāpitzi chī pastor cāmāpitzi purecu' ē chivu. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Na'iccāhui'lī purecu' na quimpekxtūcāna'j ē na'iccāhui'lī chivu na quimpekxtūxuqui. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Quit Puxcu' na'iccāhuani tī tahui'lāna'lh na quimpekxtūcāna'j: “Cata'ntit hui'xina'n. QuinTāta' Dios cāsicua'lanātlahuanī'ta'n. Camaktītit līmāpa'ksīn tū milaca'n nahuan. Cāxtlahuacanī'ttza' mimpālacataca'n a'cxni' Dios tlahualh cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Dios cāsicua'lanātlahuanī'ta'n. Hui'xina'n quilāmāhuī'uj a'cxni' quit xa'ictzi'ncsa. Hui'xina'n quilātā'hua'uj mixcānca'n a'cxni' quit xa'ickelhpūtīmā'lh. Chuntza' chī xamini' quit ē quilāmānūj na minchicca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Jātza' tze ixuanī't quilu'xu' ē hui'xina'n quilāmaxquī'uj xasāsti'. Xa'icta'jatatla ē quilāmaktāyauj. Tachī'n xa'icuanī't ē quilālakpaxialhna'uj.” Chuntza' na'iccāhuani. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tī lactze natahuan: “Māpa'ksīni', ¿jā'cxni' iccālaktzī'n a'cxni' ixtzi'ncsa' ē iccāmāhuī'n? ¿Jā'cxni' iccātā'hua'n xcān a'cxni' ixkelhpūtīya'? ");
INSERT INTO tkuNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Jā'cxni' iccāmānūn na quinchicca'n a'cxni' ixlatlā'hua'na' hua'chi xamini'? ¿Jā'cxni' iccāmaxquī'n milu'xu'? ");
INSERT INTO tkuNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Jā'cxni' iccāmaktāyan a'cxni' ixta'jatatlaya' o tachī'n ixua'nī'ta'?” ");
INSERT INTO tkuNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","’Quit tzamā' Puxcu' na'iccākelhtī: “Ixlīcāna' tū iccāhuaniyān. Catūhuālh tū tlahua'ni'tit chā'tin quintā'timīn, masqui ā'chulā' xastancu xla', ū'tza' hua'chi quit quilātlahuani'uj.” ");
INSERT INTO tkuNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Quit tzamā' Puxcu' na'iccāhuani tī tahui'lāna'lh na quimpekxtūxuqui: “Catapānū'tit. Hui'xina'n nacātamakapātīnīnān. Capintit jā jā mixa macscut. Capintit jā cāxtlahuacanī't ixpālacata skāhuī'ni' ē ixmaktāyana'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Hui'xina'n jā quilāmāhuī'uj a'cxni' quit xa'ictzi'ncsa. Ē jā quilātā'hua'uj mixcānca'n a'cxni' xa'ickelhpūtī. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Quit hua'chi xamini' xa'iclatlā'huan ē hui'xina'n jā quilāmānūj na minchicca'n. Jātza' tze ixuanī't quilu'xu' ē jā quilāmaxquī'uj xasāsti'. Xa'icta'jatatla ē tachī'n xa'icuanī't. Hui'xina'n jā quilālakpaxialhna'uj. Ū'tza' nacātalīmakapātīnīnān.” Chuntza' na'iccāhuani. ");
INSERT INTO tkuNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Xlaca'n natahuan: “Māpa'ksīni', ¿jā'cxni' iccālaktzī'n a'cxni' ixtzi'ncsa', o ixkelhpūtīya', o hua'chi xamini' ē quina'n jā iccāmaktāyan? ¿Jā'cxni' iccālaktzī'n a'cxni' jātza' tze ixuanī't milu'xu' o ixta'jatatlaya' o tachī'n ixua'nī'ta' ē quina'n jā iccāmaktāyan?” ");
INSERT INTO tkuNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","’Quit tzamā' Puxcu' na'iccākelhtī: “Ixlīcāna' tū iccāhuaniyān. Catūhuālh tū jā tlahua'ni'tit chā'tin quintā'timīn, masqui ā'chulā' xastancu xla', chuntza' hua'chi jā quit quilātlahuani'uj.” ");
INSERT INTO tkuNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jesús cāhuanipālh: ―Palaj tunca tzamā' tī jā lactze nata'a'n nac pūpātīn pō'ktu quilhtamacuj ē tī lactze nataka'lhī ixlatamatca'n tū jā catilaksputli. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","A'cxni' Jesús cāhuanikō'lh huā'mā', cāhuanilh ī'scujnu'nī'n: ");
INSERT INTO tkuNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Hui'xina'n ca'tzīyā'tittza' sputacus a'ktu' quilhtamacuj a'cxni' nala cā'tani' tū huanican pascua. Quit Chi'xcu' xala' Tālhmā'n. Iccāhuaniyān naquimacamāstā'can naquixtokohua'ca'can ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Xanapuxcu'nu' pālejni' ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn ē xanapuxcu'nu' israelitas, xlaca'n tatakēstokli na ixtanquilhtīn ixpalacio Caifás. Xla' ixlīcāna' tī xapuxcu' pālej ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","A'ntza' tachihuīna'nli chī natalī'a'kskāhuī'nin ē natachi'pa Jesús ē chuntza' natalīmaknī. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ixtalāhuani: ―Palh natlahuayāuj catūhuālh līhuan lamā'lh cā'tani', tachi'xcuhuī't natatā'kaquī'. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús ixuī'lh nac Betania na ixchic Simón. Huā'mā' Simón ixmasni'mā'lh ixquinīt ē ixtzeyanī'ttza'. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Chā'tin puscāt laktalacatzuna'jīlh Jesús. Ixlē'mā'lh pātin lameti tū ixlītzuma aceite tū tapalaxla' ē mu'csu ixuanī't. Līhuan Jesús ixuā'yamā'lh, puscāt līcuctlahualh aceite. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","A'cxni' scujnu'nī'n talaktzī'lh tū tlahualh, tasītzī'lh ē tatzuculh talāhuani: ―¿Tū ixpālacata pāxcat līlalh huā'mā' aceite? ");
INSERT INTO tkuNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tzē ī'stā'ca ixpālacata tapalaxla' ē tumīn tzē ixcāmaxquī'ca xcamanīnī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús ixca'tzī tū ixtalīchihuīna'mā'nalh ē cāhuanilh: ―¿Tū ixpālacata jicsmāhuī'yā'tit huā'mā' puscāt? Quintlahuani'lh tū tze. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Pō'ktu quilhtamacuj na'a'nan xcamanīnī'n na milacpu'na'i'tātca'n; quit jā pō'ktu quilhtamacuj na'iccātā'tahui'layān. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Chuntza' chī huā'yālh puscāt quilīcuctlahualh huā'mā' aceite, ū'tza' hua'chi ixquincāxuī'līlh naquimā'cnūcan. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ixlīcāna' tū iccāhuaniyān. Calhāxcuhuālh nac cā'quilhtamacuj jā namāca'tzīnīni'ncan xatze tachihuīn ixla' Cristo, a'ntza' nahuancan tū tlahualh huā'mā' puscāt. Ū'tza' ixlīpō'ktuca'n natalīlacapāstaca xla'. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Chā'tin chī ixlīkelhacāujtu' scujnu'nī'n xla' ixuanican Judas Iscariote. Xla' a'lh cātā'chihuīna'n xanapuxcu'nu' pālejni' ");
INSERT INTO tkuNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ē cāhuanilh: ―¿Chī huanī't naquilāxokoyāuj palh na'iccāmacamaxquī'yān Jesús? Xlaca'n talīxokolh pu'xamacāuj xaplata tumīn ");
INSERT INTO tkuNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ē a'cxni' Judas tzuculh putza chī tzē nacālīmacamaxquī' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Milh quilhtamacuj tū ixlītzucuni' cā'tani' tū huanican pascua a'cxni' hua'can pāntzīn tū jā lītlahuacanī't levadura. Huā'mā' quilhtamacuj scujnu'nī'n talaktalacatzuna'jīlh Jesús ē takelhasqui'nīlh: ―¿Jāchu lacasqui'na' na'iccāxtlahuayāuj tū nahua'can cā'tani'? ");
INSERT INTO tkuNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Xla' cāhuanilh: ―Capintit nac cā'lacchicni' ē natanū'yā'tit na ixchic chā'tin chi'xcu' ē nahuaniyā'tit: “Mākelhtahua'kē'ni' huaniyān: Talacatzuna'jītza' tū na'icpūnī ē icua'cu'tun tū hua'can cā'tani' pascua na minchic. Na'iccātā'huā'yan quiscujnu'nī'n.” ");
INSERT INTO tkuNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Scujnu'nī'n ta'a'lh ē tatlahualh chī Jesús cāmāpa'ksīlh ē tacāxtlahualh līhua' xala' cā'tani'. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","A'cxni' ixtā'cnūmā'lhtza' chi'chini', Jesús ē kelhacāujtu' ī'scujnu'nī'n ixtahuā'yahui'lāna'lh nac mesa. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Līhuan ixtahuā'yamā'nalh, Jesús cāhuanilh: ―Ixlīcāna' iccāhuaniyān, chā'tin chī hui'xina'n naquimacamāstā'. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Xlaca'n talīpuhuanli ē tatzuculh takelhasqui'nī chā'tunu': ―¿Ē quit, quiMāpa'ksīni'? ");
INSERT INTO tkuNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesús cākelhtīlh: ―Ū'tza' tī quintā'pūhuā'yan pulātu, ū'tza' naquimacamāstā'. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Quit Chi'xcu' xala' Tālhmā'n ē naquina'kspula chuntza' chī tatzo'kni' quimpālacata na ixtachihuīn Dios. Līlakalhu'mānat chi'xcu' tī naquimacamāstā'; nalīlīpuhuan. Ā'chulā' tze ixpālacata xla' palh jā ixtilacatuncuhuī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas, ū'tza' tī namacamāstā', ē xla' huanilh: ―Mākelhtahua'kē'ni', ¿palhāsā' quit? Jesús kelhtīlh: ―Chuntza' chī hua'nti. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Līhuan ixtahuā'yamā'nalh, Jesús tayalh pāntzīn ē maxquī'lh tapāxcatca'tzīn Dios. A'cxni' che'kelh, cāmaxquī'lh ī'scujnu'nī'n ē cāhuanilh: ―Cahua'tit. Ū'tza' huā'mā' quimacni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Palaj tunca tayalh vaso ē maxquī'lh tapāxcatca'tzīn Dios. Macasti'n cāmaxquī'lh xlaca'n ē cāhuanilh: ―Chā'tunu' hui'xina'n cahua'tit macasti'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ū'tza' huā'mā' quinka'lhni'. Ū'tza' tū līcāxtlahuaca xasāsti' talacāxtlahuan chī Dios nacālīmakapūtaxtū tachi'xcuhuī't. Quinka'lhni' tū na'icmaka'n ū'tza' nacālīmātza'nkēna'ni'can ixcuentaca'n lhūhua' tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Iccāhuaniyān jā ictihua'lh xaxcān uva hasta a'cxni' na'iccātā'hua'yān xtumtza' xaxcān uva xasāsti'tza'. Na'iccātā'hua'yān a'ntza' jā namāpa'ksīni'nkō' quinTāta' Dios ē ixlīpō'ktu catūhuālh xasāsti'. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","A'cxni' ixtapixtlī'nī't a'ktin himno, tataxtulh ē ta'a'lh nac sipej jā huanican Olivos. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesús cāhuanilh: ―Huā'mā' tzī'sni' milīpō'ktuca'n naquilā'a'kxtekmaka'nāuj ixpālacata tū naquina'kspula. Chuntza' tatzo'kni' na ixtachihuīn Dios: “Na'icmaknī pastor ē nata'a'kahuanikō' purecu'”, tatzo'kni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","A'cxni' naquimālacastālancuanīcan, xapūla na'ica'n quit nac estado Galilea. A'ntza' nalāpāxtokāuj. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedro huanilh: ―Masqui ixlīpō'ktuca'n ā'makapitzīn nata'a'kxtekmaka'nān, quit jā maktin ictimakxtekni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús huanilh: ―Ixlīcāna' tū icuaniyān. Huā'mā' tzī'sni' a'cxni' jāna'j ta'sa puyux, hui'x naquinkelhtatzē'ka maktu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro huanilh: ―Masqui naquintā'maknīca'na', quit jā ictikelhtatzē'kni'. Ixlīpō'ktuca'n ā'makapitzīn chuntza' tahuanli. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jesús ē ī'scujnu'nī'n tachā'lh jā huanican Getsemaní. Xla' cāhuanilh: ―Catahui'la'tit hui'xina'n huā'tzā' līhuan quit na'ica'n na'icorarlīni' Dios a'jnanu'. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Cālē'lh lacapunchuna'j Pedro ē chā'tu' ixka'hua'chan Zebedeo ē tzuculh līpuhuan ē ixa'ktuyumā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Cāhuanilh: ―Iclīpuhuan hasta tzē na'iclaknī quintalīpuhuāt. Catachokotit huā'tzā' ē calātā'līpuhuanui. Jā calhtatatit. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jesús a'lh lacapunchuna'j ē tatzokostalh nac ti'ya't ē squi'ni'lh Dios ē huanilh: ―QuinTāta', palh tzē na'ica'kapūtaxtu tzamā' tū na'icpātīni'n, camakxtekti chuntza' nala. Masqui na'icpātīni'n, calalh tū hui'x lacasqui'na' ē jā calalh tū quit iclacasqui'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Mimpālh jā ixcāmakxteknī't ī'scujnu'nī'n ē cālakchilh xlaca'n ixtalhtatahui'lāna'lh. Huanilh Pedro: ―¿Ē minkelhatu'tunca'n jāla tāyani'tit mintalhtataca'n nūn a'ktin hora? ");
INSERT INTO tkuNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Calakahuantahui'la'tit ē casqui'ni'tit Dios jā nacāta'a'kskāhuī'yān a'cxni' nacātalīlaktzī'ncu'tunān. Ixlīcāna' milīstacna'ca'n tatlahuacu'tun xatze ē mimacni'ca'n jā taka'lhī lītli'hui'qui ―cāhuanilh. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ixlīmaktu' Jesús a'lh ē squi'ni'lh Dios chuntza': ―QuinTāta', palh ixlacasqui'nca na'icpātīni'n ē nakentaxtu chī mintalacasqui'nīn, chuntza' calalh. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Palaj tunca taspi'tpālh jā ixcāmakxteknī't ī'scujnu'nī'n ē cālakchimpālh ē ixtalhtatamā'nampālh. Jāla tatāyani'lh ixtalhtataca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Cāmakxtekpālh ē ixlīmaktu'tun a'lh ē squi'ni'lh Dios. Chu chuntza' huanipālh chī ixuanī't xapūla. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Taspi'tpālh jā cāmakxtekli scujnu'nī'n ē cāhuanilh: ―¿Ē lhtatapā'na'ntitcus ē jaxpā'na'ntitcus? Chilhtza' hora tū līlhcānancanī't. Quit Chi'xcu' xala' Tālhmā'n ē naquimacamāstā'can na ixmacanca'n tī jā tzeya chi'xcuhuī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Catāya'tit ē ca'a'ujtza; mimā'lhtza' tī naquimacamāstā'. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ixcātā'chihuīna'mā'lhcus Jesús a'cxni' chā'lh Judas. Xla' chā'tin ixlīkelhacāujtu' ī'scujnu'nī'n ixuanī't. Tatā'chā'lh lhūhua' tachi'xcuhuī't ē ixtalē'n ixmachītaca'n ē qui'hui'. Tamacaminini'lh xanapuxcu'nu' pālejni' ē xanapuxcu'nu' israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas ū'tza' tī ixmacamāstā'lh ē xla' ixcāhuaninī'ttza' chī natalīlakapasa tīchu Jesús. Ixcāhuaninī't: ―Na'iclacamu'su chā'tin; ē xla' ū'tza' Jesús. Nachi'payā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","A'cxni' chilh Judas, laktalacatzuna'jīlh Jesús ē huanilh: ―Lakatzī'suanti', Mākelhtahua'kē'ni'. Lacamu'sulh. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús kelhtīlh: ―Amigo, ¿ē tū ixpālacata ta'mpā't? Tachi'xcuhuī't tī tatā'milh Judas talaktalacatzuna'jīlh Jesús ē tachi'palh natalē'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Palaj tunca chā'tin tī ixtā'minī't Jesús, māxtulh ixmachīta ē mātakāhuī'lh ixtasācua' xapuxcu' pālej ē a'kacā'yujulh ixa'ka'xko'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesús huanilh: ―Camānū'pala mimachīta na ixpūtanū. Tī nalālītucsa ixmachīta, nā ū'tza' nalīmaknīcan xla'. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Ē jā ca'tzīya' quit tzē na'icsqui'ni' quinTāta' Dios caquimaktāyalh ē xla' xamaktin naquimacamini' a'kcāujtu' mil ángeles? ");
INSERT INTO tkuNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Palh xa'ictlahualh cahuālh chuntza', ¿chī nalīmākentaxtūcan tū huan na ixtachihuīn Dios jā tatzo'kni' ixlacasqui'nca na'a'kspula chuntza' chī a'kspulamā'lh? ");
INSERT INTO tkuNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jesús cāhuanilh tachi'xcuhuī't: ―¿Tū ixpālacata līta'ntit mimachītaca'n ē minqui'hui'ca'n? Hua'chi chi'pacu'tunā'tit chā'tin ka'lhāna'. A'cxni' xa'iccātā'latlā'huanān lakalīyān nac templo, ¿tū ixpālacata jāla quilāchi'pauj a'cxni'? ");
INSERT INTO tkuNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ixlīpō'ktu huā'mā' tū a'kspulalh namākentaxtū tū tatzo'kli a'kchihuīna'nī'n na ixtachihuīn Dios ―cāhuanilh. Ixlīpō'ktuca'n ī'scujnu'nī'n tatzā'lalh ē chuntza' talī'a'kxtekmaka'lh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Xlaca'n tī tachi'palh Jesús talē'lh na ixchic Caifás tī xapuxcu' pālej ixuanī't. A'ntza' ixtalaktakēstoknī't xamākelhtahua'kē'ni'nī'n līmāpa'ksīn ē xanapuxcu'nu' israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro lakamakat stālani'lh ē chā'lh hasta ixtanquilhtīn ixchic xapuxcu' pālej. Tanūlh na ixtanquilhtīn chic ē cātā'tahuī'lh policías nalaktzī'n chī nalīputzāna'nīcan. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Xanapuxcu'nu' pālejni' ē ixlīpō'ktuca'n xalaka'tla' māpa'ksīni'nī'n ixtaputzamā'nalh chī natalīmālacsu'yu Jesús ē natalīmāmaknīnīni'n. Ixtaputzamā'nalh catūhuālh masqui jā ixlīcāna' tū nalīmālacsu'yucan. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Masqui lhūhua' chi'xcuhuī'n ixtalaka'n ē talīchihuīna'nli tū jā ixlīcāna' ixpālacata Jesús, jāla ixtamaclani' tū natalīmālacsu'yu. Ā'līstān tamilh chā'tu' tī chu lacxtim chī tachihuīna'nli. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Xlaca'n tahuanli: ―Huā'mā' chi'xcu' huanli: “Quit tzē na'icmālaksputūkō' xaka'tla' ixtemplo Dios ē ixlī'a'ktu'tun quilhtamacuj na'icyāhuapala.” ");
INSERT INTO tkuNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Xapuxcu' pālej tāyalh ē huanilh Jesús: ―Huā' tayāna'lh chā'tu' chi'xcuhuī'n tamālacsu'yumā'nān. ¿Ē jā tū caticākelhti'? ");
INSERT INTO tkuNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesús ca'cs tāyalh. Xapuxcu' pālej chihuīna'mpālh ē huanilh: ―Dios tī lakahuan, ū'tza' kexmatān. Chuhua'j naquihuani'ya' tū ixlīcāna'. Caquilāhuaniuj palh hui'x Cristo tī ī'Ska'ta' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús kelhtīlh: ―Jē, quit ū'tza' chuntza' chī hua'na'. Nā iccāhuaniyān huā'mā'. Chuhua'j hui'xina'n naquilālaktzī'nāuj quit Chi'xcu' xala' Tālhmā'n na'ictahui'la na ixpekxtūcāna'j Dios tī māpa'ksīni'mā'lh. Nā na'icminācha' nac a'kapūn ixpu'nan poklhnu'. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Xapuxcu' pālej ū'tza' lacxtī'tli ixlu'xu' tū ixlhakā'nī't ē chuntza' līmāsu'yulh xla' ixsītzī' ē huanli: ―Huā'mā' chi'xcu' līmālakchā'ni'cu'tun Dios. Jātza' iclacasqui'nāuj ā'chā'tin naquincāhuanipalayān palh jā tze xla'. Hui'xina'n kexpa'tnī'ta'ntit chī mālakchā'ni'cu'tun Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Chī puhua'nā'tit? Tahualh: ―Ixlacasqui'nca nanī. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Palaj tunca talakachojmanīlh Jesús ē tatucsli. Ā'makapitzīn talacala'sli ");
INSERT INTO tkuNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ē tahuanilh: ―Hui'x tī Cristo, calakapasti tīchu lacala'sni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Līhuan Pedro ixuī'lh nac tanquilhtīn ē chā'tin tzu'ma'jāt laktalacatzuna'jīlh ē huanilh: ―Nā hui'x ixtā'latlā'hua'na' Jesús xala' nac Galilea. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedro kelhtatzē'kli na ixlacatīnca'n ixlīpō'ktuca'n ē huanli: ―Jā icca'tzī tū huanicu'tuna'. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pedro tatampūxtulh macsti'na'j ē ā'chā'tin huampala tzu'ma'jāt laktzī'lh. Xla' cāhuanilh tī ixtayāna'ncha': ―Huā'mā' chi'xcu' nā ixtā'latlā'huan Jesús xala' nac Nazaret. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedro kelhtatzē'kpālh ē lacatancs huanli: ―Quit jā iclakapasa huā'mā' chi'xcu'. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ixlīka'tlā'tus xlaca'n tī ixtatā'layāna'lh talaktalacatzuna'jīlh Pedro ē tahuanilh: ―Ixlīcāna' hui'x chā'tin chī xlaca'n. Mintachihuīn ixtā'chuntza' tī xala' nac Galilea. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pedro tzucuca lakapalaca ixa'cstu ē palha' huanli: ―Dios naquimakapātīnīn palh jā ixlīcāna' tū iccāhuanimā'n. Jā iclakapasa huā'mā' chi'xcu'. Palaj tunca ta'salh puyux. ");
INSERT INTO tkuNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ū'tza' līmāpāstaquīlh Pedro chī Jesús ixuaninī't: “A'cxni' jāna'j ta'sa puyux, hui'x naquinkelhtatzē'ka maktu'tun.” Pedro taxtulh a'ntza' ē ixtalīpuhuāt tzuculh calhuan. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","A'cxni' xkakalh, ixlīpō'ktuca'n xanapuxcu'nu' pālejni' ē xanapuxcu'nu' israelitas talālītā'chihuīna'nli chī natalīmaknī Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tapekechī'lh ē talē'lh ē tamacamaxquī'lh Poncio Pilato tī gobernador ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas ū'tza' tī macamāstā'lh Jesús. A'cxni' Judas laktzī'lh chī māpa'ksīca namāmaknīnīni'ncan Jesús, līpuhuanli ē xtum lacapāstacli ē cāmāspi'tni'lh pu'xamacāuj xaplata tumīn xanapuxcu'nu' pālejni' ē xanapuxcu'nu' israelitas, ");
INSERT INTO tkuNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ē cāhuanilh: ―Quit ictlahualh tū jā tze ixpālacata icmacamāstā'lh chi'xcu' tī jā tū ixlaclē'n. Xlaca'n takelhtīni'lh: ―Huā'mā' jā quincuentaca'n. Cuenta catlahua' hui'x. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas a'lh nac templo ē tilhquītamacnūlh na ixpūchakān templo tumīn ē a'lh tā'kpixchī' a'katin nac qui'hui'. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Xanapuxcu'nu' pālejni' tasacli tumīn ē talāhuanilh: ―Jāla namojōyāuj jā mojōcan tumīn tū mālacnūni'can Dios. Huā'mā' tumīn līxokocanī't namāmaknīnīni'ncan chā'tin chi'xcu'. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tachihuīna'nli ē taputzalh chī natalītamāhua pītzuna'j ti'ya't. Huā'mā' ti'ya't ixmāpācuhuīcan Ixti'ya't Alfarero ē a'ntza' ixcāmā'cnūcan makatiyātī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Chuhua'j māpācuhuīcan Ti'ya't tū Ixtapalh Ka'lhni' ixpālacata lītamāhuaca tumīn tū ixlīxokocanī't namāmaknīnīni'ncan chā'tin chi'xcu'. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Chuntza' mākentaxtūca huā'mā' tū huanli a'kchihuīna' Jeremías jā tzo'kli na ixtachihuīn Dios: “Cātayaca pu'xamacāuj tumīn ixla' plata (ū'tza' ixtapalh chā'tin chi'xcu' chuntza' chī tahualh makapitzīn israelitas). ");
INSERT INTO tkuNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Huā'mā' tumīn lītamāhuaca ixti'ya't Alfarero chuntza' chī quimāpa'ksīlh Māpa'ksīni' Dios.” ");
INSERT INTO tkuNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","A'cxni' Jesús ixyālh na ixlacatīn gobernador Pilato, ē ū'tza' kelhasqui'nīlh Jesús: ―¿Ē hui'x ixPuxcu'ca'n israelitas? Jesús huanilh: ―Chuntza' chī hua'nī'ta'. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","A'cxni' xanapuxcu'nu' pālejni' ē xanapuxcu'nu' israelitas ixtalīmālacsu'yu, Jesús jā tū kelhtīni'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilato kelhasqui'nīpālh Jesús: ―¿Ē jā kexpa'ta' tū talīmālacsu'yuyān tachi'xcuhuī't? ");
INSERT INTO tkuNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesús jā tū kelhtīlh. Ū'tza' līlī'a'cnīlh gobernador. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ixa'nan a'ktin tahui'lat ē a'cxni' ixlamā'lh cā'tani', gobernador ixmakxteka chā'tin tachī'n. Tachi'xcuhuī't ixtalacsaca tachī'n tī namakxtekcan. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ixtanūmā'lh chā'tin tachī'n tī ixuanican Barrabás. Calhāxcuhuālh ixlakapascan huā'mā' Barrabás. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","A'cxni' ixtatalacxtimīnī't tachi'xcuhuī't, Pilato cākelhasqui'nīlh: ―¿Tichūyā tachī'n lacasqui'nā'tit na'icmakxteka? ¿Ē na'icmakxteka Barrabás o na'icmakxteka Jesús tī māpācuhuīcan Cristo? ");
INSERT INTO tkuNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Chuntza' huanli Pilato ixpālacata xla' ca'tzīlh chī xanapuxcu'nu' pālejni' quiclh ixtalaktzi'n Jesús ē ū'tza' talīmacamāstā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Līhuan ixuī'lh Pilato jā ixtlahuacan justicia, ixpuscāt macā'ni'lh tachihuīn ē huanilh: “Jā timaktanū'ya' ixpālacata huā'mā' tzeya chi'xcu'. Jā tze chī iclakahuālaktzī'lh tzamā' chi'xcu' huā' kōtan tzī'sa.” ");
INSERT INTO tkuNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Xanapuxcu'nu' pālejni' ē xanapuxcu'nu' israelitas ixtā'chihuīna'makasītzī'nī't tachi'xcuhuī't ē ū'tza' talīsqui'nli camakxtekca Barrabás ē tahuanli camaknīca Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ā'maktin cātā'chihuīna'nli gobernador ē cākelhasqui'nīlh: ―¿Tichūyā tachī'n lacasqui'nā'tit na'icmakxteka? ¿Jesús o Barrabás? Xlaca'n tahuanli: ―Iclacasqui'nāuj Barrabás. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato cākelhasqui'nīlh: ―¿Tūchu lacasqui'nā'tit na'ictlahuani' Jesús tī māpācuhuīcan Cristo? Ixlīpō'ktuca'n takelhtīlh: ―¡Caxtokohua'ca'ca! ");
INSERT INTO tkuNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato cāhuanilh: ―¿Tū ixpālacata? ¿Tūchu tlahuanī't xla' tū jā tze? Xlaca'n ā'chulā' tata'salh ē palha' tahuanilh: ―¡Caxtokohua'ca'ca! ");
INSERT INTO tkuNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","A'cxni' Pilato cuenta tlahualh jāla ixcāmāko'xamixī ē ā'chulā' ixtatā'kaquī'mā'nalh ē jāla cāskāhuī'lh, xla' squi'nli xcān. Na ixlacatīnca'n tachi'xcuhuī't Pilato makacha'ka'lh ē cāhuanilh: ―Quit jā iclē'n cuenta ixpālacata huā'mā' chi'xcu' ē chī nanī. Jā tū tlahuanī't tū jā tze. Hui'xina'n nalī'pinā'tit cuenta. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ixlīpō'ktuca'n tachi'xcuhuī't takelhtīlh: ―¡Quina'n ē quincamana'ca'n na'iclē'nāuj cuenta ixpālacata huā'mā' chi'xcu' ē chī nanī! ");
INSERT INTO tkuNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Chuntza' Pilato māxtulh Barrabás ē makxtekli. Palaj tunca māpa'ksīlh camaksno'kca Jesús ē macamāstā'lh naxtokohua'ca'can. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ā'līstān ī'soldados gobernador Pilato talē'lh Jesús nac pūchihuīn ē tamākēstokli lhūhua' soldados ē talītamacsti'li'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Palaj tunca tamāmakxtulh ixlu'xu' ē tamālhekē'lh xasmanta'jua' lu'xu'. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tatlahualh a'ktin corona ixla' lhtucu' ē tamā'knūlh. Tamaxquī'lh qui'hui' tū chi'palh na ixmacapekcāna'j. Tatatzokostani'lh ē talīlītzī'nli ē tahuanilh: ―¡Calakachi'xcuhuī'ca ixPuxcu'ca'n israelitas! ");
INSERT INTO tkuNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nā talakachojmanīlh ē tachi'palh ixqui'hui' ē talīcucni'cli. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","A'cxni' talīlītzī'nkō'lh chuntza', tamāmakxtulh ixlu'xu' xasmanta'jua' ē tamālhekē'pālh ixlu'xu' tū ixla' ixuanī't. Palaj tunca talē'lh naxtokohua'ca'can. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Līhuan ixta'a'mā'nalh, tapāxtokli chā'tin chi'xcu' xala' nac Cirene ē ixtacuhuīni' Simón. Sāmācu'quī'ca ixcruz Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Chuntza' ta'a'lh ē tachā'lh jā huanican Gólgota tū huanicu'tun Ixa'kxāk Nīn. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","A'ntza' maxquī'ca Jesús xaxcān vinagre tū ixmojōni'canī't catūhuālh tū xū'ni' hua'chi xī'cxi'. Palh ixua'lh, jā ixtimakca'tzī'lh chī napātīni'n. A'cxni' xla' kelhuanalh, jā hua'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","A'cxni' ixtaxtokohua'ca'nī'ttza', soldados tamāpitzilh ixlu'xu' Jesús na ixpu'na'i'tātca'n ē talīmāxtulh suerte nataca'tzī tūchu nacālakchā'n chā'tunu' xlaca'n. Chuntza' mākentaxtūca tū huanli a'kchihuīna' jā tzo'kli: “Tamāpitzilh quilu'xu' na ixpu'na'i'tātca'n; tatlahualh suerte tū talīmāxtulh.” ");
INSERT INTO tkuNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Palaj tunca tatahui'lalh natamaktaka'lha. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Hui'līca nac cruz a'ktin letrero na ixa'cpūn Jesús. A'ntza' ixtzo'kcanī't tū ixpālacata līxtokohua'ca'ca. Ixtzo'kcanī't: Ū'tza' huā'mā' ixPuxcu'ca'n israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nā cātā'xtokohua'ca'ca chā'tu' ka'lhāna'nī'n; chā'tin na ixpekxtūcāna'j ē ā'chā'tin na ixpekxtūxuqui. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Tī ixtatētaxtumā'nalh tasakā'līlh ixa'kxākca'n ē talakapalalh ");
INSERT INTO tkuNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ē tahuanilh: ―Hui'x ixlactlahuacu'tuna' xaka'tla' templo ē ixyāhuapala'cu'tuna' ixlī'a'ktu'tun quilhtamacuj. Chuhua'j ca'a'kapūtaxtu hui'x milīmān. Palh hui'x ī'Ska'ta' Dios, cayujti nac cruz. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nā chuntza' ixtalīlītzī'n xanapuxcu'nu' pālejni' ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn. Fariseos ē xanapuxcu'nu' israelitas lacxtim ixtalīlītzī'mā'nalh ē ixtalāhuanimā'nalh: ");
INSERT INTO tkuNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Xla' cāmakapūtaxtūlh ā'makapitzīn ē jāla a'kapūtaxtu ixlīmān. Palh ixlīcāna' xla' ixPuxcu'ca'n israelitas, cayujli nac cruz chuhua'j ē chuntza' na'a'ka'ī'ni'yāuj xla'. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Xla' līpāhuan Dios; chuhua'j Dios camakapūtaxtūlh palh ixlīcāna' pāxquī'. Quincāhuanin xla' ī'Ska'ta' Dios ―tahualh. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nā ka'lhāna'nī'n tī ixcātā'xtokohua'ca'canī't, nā xlaca'n talakapalalh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Xlītza'la cā'pucsua' huanli calhāxcuhuālh nac cā'ti'ya'tna'. Tzuculh hua'chi tastu'nūt ē tanajīlh a'ktu'tun hora. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Chī maktu'tun kōtanū, Jesús palha' ta'salh ē huanli: ―Elí, Elí, ¿lama sabactani? (Ē ū'tza' huanicu'tun: QuinDios, quinDios, ¿tū ixpālacata quina'kxtekui'līnī'ta' quina'cstu?) ");
INSERT INTO tkuNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Takexmatli huā'mā' makapitzīn tī ixtayāna'ncha' ē xlaca'n talāhuanilh: ―Huā'mā' chi'xcu' ta'sani'mā'lh a'kchihuīna' Elías. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Xamaktin chā'tin tatu'jnu quītayalh catūhuālh hua'chi panamāc. Līmāchū'huī'lh xaxcān vinagre ē cucchi'hua'ca'lh a'ktin qui'hui' ē quilhyāhualh Jesús nahua'. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ā'makapitzīn tahuanli: ―Camakxtekti. Nalaktzī'nāuj palh Elías namin namakapūtaxtū. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ā'maktin Jesús ta'salh palha' ē palaj tunca nīlh. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Huā'mā' puntzuna' taxtī'tpitzilh ka'tla' līlakamilīn xaka'tla' nac templo. Ū'tza' huā'mā' līlakamilīn tū ixmāpitzi templo. Tzuculh na ixquilhtūn xala' tālhmā'n ē tapūpitzilh hasta na ixtampān. Ti'ya't tachiquilh ē chihuix tatapūpitzilh. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Tatalaquī'lh pūtā'cnūn ē talacastālancuana'nli lhūhua' tī ixta'a'ka'ī'ni'nī't Dios ē ixtanīnī'ttza'. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Xlaca'n tataxtulh nac pūtā'cnūn ē a'cxni' ixlacastālancuana'nī'ttza' Jesús, tatanūlh nac cā'lacchicni' xatasicua'lanātlahuanī't jā huanican Jerusalén. A'ntza' cātasu'yuni'lh lhūhua' tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Capitán romano ē soldados tī ixtamaktaka'lhmā'nalh Jesús tajicua'nli a'cxni' tachiquilh ti'ya't ē a'cxni' talaktzī'lh tū a'kspulalh. Xlaca'n tahuanli: ―Ixlīcāna' huā'mā' chi'xcu' ī'Ska'ta' Dios ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Lhūhua' puscan ixtalaktzī'mā'nalh makat. Ixtastālani'tlā'huan Jesús a'cxni' taxtulh nac estado Galilea ē ixtamaktāya. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Na ixpu'na'i'tātca'n puscan nā ixtayāna'lh María Magdalena ē María tī ixtzī'ca'n Jacobo ē José ē nā ixuī'lh ixtzī'ca'n ixka'hua'chan Zebedeo. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","A'cxni' ī'smalanka'namā'lhtza', milh chā'tin chi'xcu' tī ixuanican José ē xala' nac cā'lacchicni' Arimatea. Rico ixuanī't ē nā ixa'ka'ī'ni' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Xla' laka'lh Pilato ē squi'ni'lh ixmacni' Jesús. Pilato māpa'ksīni'lh camaxquī'ca. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","José lē'lh ixmacni' Jesús ē līmaksuitli xatache'ke'n lu'xu'. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Mā'cnūca a'ktin nac xasāsti' lhu'cu' tū ixcāxtlahuacanī'ttza' nac ka'tla' chihuix. Lhu'cu' ixla' José ixuanī't. A'cxni' līmālacchahualh a'ktin ka'tla' chihuix nac lhu'cu', xla' a'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Na ixlacapūn lhu'cu' ixtahui'lāna'lh María Magdalena ē ā'chā'tin María. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","A'cxni' ixa'kspulanī'ttza' quilhtamacuj tū pūcāxui'līkō'can tū maclacasqui'ncan quilhtamacuj tū pūjaxcan, xanapuxcu'nu' pālejni' ē fariseos talaka'lh Pilato. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Tahuanilh: ―Señor gobernador, quina'n iclacapāstacāuj tū huanli tzamā' chi'xcu' tī a'kskāhuī'nilh a'cxni' lakahuancus ixuanī't. Chuntza' huanli: “Ixlī'a'ktu'tun quilhtamacuj na'iclacastālancuana'n na ixpu'na'i'tātca'n nīnī'n”, huanli. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Chuntza' camāpa'ksi'ni' tzej camaktaka'lhca pūtā'cnūn hasta nati'a'cchā'n a'ktu'tun quilhtamacuj. Palhāsā' ī'scujnu'nī'n natamin nataka'lhan ixmacni'. Tzē nacāhuanican tachi'xcuhuī't palh lacastālancuana'nī't na ixpu'na'i'tātca'n nīnī'n. Chuntza' ā'chulā' nacālī'a'kskāhuī'can tachi'xcuhuī't ē jā xapūla. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato cāhuanilh: ―Ā' tayāna'lh soldados. Cacālī'pintit ē calaktzī'ntit hui'xina'n chuntza' chī natamaktaka'lha. ");
INSERT INTO tkuNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Xlaca'n ta'a'lh ē tzej tacāxtlahualh pūtā'cnūn ē hui'līca sello nac chihuix tū kelhui'līca. Cāmakxtekcancha' soldados tī natamaktaka'lha. ");
INSERT INTO tkuNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ī'sputnī'ttza' quilhtamacuj tū pūjaxcan ē ī'xkakamā'lhtza' domingo a'cxni' María Magdalena ē ā'chā'tin María ta'a'lh nac pūtā'cnūn. ");
INSERT INTO tkuNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Xamaktin palha' tachiquilh ti'ya't. Chā'tin ixángel Māpa'ksīni' Dios ixyujnī'ta'nchi nac a'kapūn. A'cxni' chilh nac pūtā'cnūn, māpānūlh chihuix tū ixkelhui'līcanī't ē pūtahuī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ángel xkakalh hua'chi makli'pit ē ixlu'xu' stala'nka' ixuanī't hua'chi panamāc. ");
INSERT INTO tkuNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","A'cxni' soldados talaktzī'lh, taxpipilh ē tajicua'xnīlh. ");
INSERT INTO tkuNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ángel cāhuanilh puscan: ―Jā cajicua'ntit. Quit icca'tzī hui'xina'n putzapā'na'ntit Jesús tī xtokohua'ca'ca. ");
INSERT INTO tkuNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Xla' jātza' tihuī'lh huā'tzā'. Lacastālancuana'nī'ttza' chuntza' chī huanli. Catanū'tit ē calaktzī'ntit jā ixmāpī'canī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Palaj capintit ē cacāhua'ni'tit ī'scujnu'nī'n lacastālancuana'nī'ttza' na ixpu'na'i'tātca'n nīnī'n. Chuhua'j xla' nacāpūlani'yān nac estado Galilea. A'ntza' natā'lāpāxtokā'tit. Cuenta catlahua'tit tū iccāhuaniyān. ");
INSERT INTO tkuNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Palaj tunca puscan tatapānūlh nac pūtā'cnūn. Ixtajicua'n ē nā tapāxuhualh. Tatu'jnu'n ta'a'lh cāhuani scujnu'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Xamaktin Jesús cātasu'yuni'lh ē cātā'chihuīna'lh. Xlaca'n talaktalacatzuna'jīlh Jesús. Tachi'palh ixtujan ē talaktaquilhpūtalh ē tamakapāxuīlh. ");
INSERT INTO tkuNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Xla' cāhuanilh: ―Jā cajicua'ntit. Capintit cacāmāca'tzīnī'tit quintā'timīn ixlacasqui'nca cata'a'lh nac estado Galilea ē a'ntza' naquintalakchā'n ē naquintalaktzī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Līhuan ixta'a'mā'nalh puscan, makapitzīn soldados tī ixtamaktaka'lhmā'nalh pūtā'cnūn ē xlaca'n ta'a'lh nac cā'lacchicni' jā huanican Jerusalén. Tahuanilh xanapuxcu'nu' pālejni' ixlīpō'ktu tū ixa'kspulanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tzamā' pālejni' talaka'lh xanapuxcu'nu' israelitas ē talīchihuīna'lh. Lhūhua' tumīn cāmaxquī'ca soldados ");
INSERT INTO tkuNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ē cāhuanica: ―Hui'xina'n nahua'nā'tit palh cā'tzī'sni' tamilh ī'scujnu'nī'n Jesús līhuan ī'lhtatapā'na'ntit ē xlaca'n taka'lhanli ixmacni'. ");
INSERT INTO tkuNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Palh namāca'tzīnīcan gobernador ī'lhtatapā'na'ntit, quina'n na'iclacāxlayāuj chī jā caticātalīmaknīn. ");
INSERT INTO tkuNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Soldados tamaktīni'lh tumīn ē ta'a'lh ē tahuanli chuntza' chī ixcāhuanicanī't. Chuntza' israelitas tahuan hasta chuhua'j. ");
INSERT INTO tkuNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kelhacāujtin ī'scujnu'nī'n ta'a'lh nac estado Galilea a'ktin nac sipej tū Jesús lacsacli. ");
INSERT INTO tkuNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","A'cxni' talaktzī'lh Jesús, talaktaquilhpūtalh masqui makapitzīn jā ixta'a'ka'ī'cu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús cālaktalacatzuna'jīlh xlaca'n ē cāhuanilh: ―Quit quimaxquī'canī't ixlīpō'ktu līmāpa'ksīn ē na'iccāmāpa'ksī ixlīpō'ktuca'n tī tahui'lāna'lh nac cā'ti'ya'tna' ē nac a'kapūn. ");
INSERT INTO tkuNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Chuntza' capintit calhāxcuhuālh nac cā'quilhtamacuj ē cacāmāsu'yuni'tit ixlīpō'ktuca'n tachi'xcuhuī't chī tzē quiscujnu'nī'n natahuan. Nacālīmā'kpaxī'yā'tit ixlītli'hui'qui xaTāta' Dios ē ī'Ska'ta' ē Espíritu Santo. ");
INSERT INTO tkuNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nacāmāsu'yuni'yā'tit chī natalatā'kchoko ē chī natakexmatni' ixlīpō'ktu tū quit iccālīmāpa'ksīni'nī'ta'n hui'xina'n. Caca'tzītit quit pō'ktu quilhtamacuj iccātā'lamā'n hasta a'cxni' nasputa cā'quilhtamacuj. Amén.");
INSERT INTO tkuNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Huā'mā' xatze tachihuīn tū māsu'yucan ixpālacata Jesucristo tī ī'Ska'ta' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Chā'tin profeta tzo'knulh chī Dios huanilh ī'Ska'ta'. Chuntza' huanli: Cakexpa'tti. Quit na'icmaca'n quilacscujni' milacatīn tī napūlani'yān hui'x ē tī nacāxtlahua mintej. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nā profeta Isaías tzo'knulh chuntza': A'ntza' jā cā'tzaya'nca ti'ya't, nakexmatcan chā'tin tī palha' chihuīna'n ē nahuan: “Cacāxtlahua'tit tej ixpālacata mimā'lh Māpa'ksīni'. Camālakstu'nctit tej.” Chuntza' tzo'knulh Isaías. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Tzamā' mākentaxtūca a'cxni' Juan tī ixmā'kpaxīni'n ixtasu'yu nac cā'tzaya'nca ti'ya't. Ixa'kchihuīna'n ē ixcāhuani tachi'xcuhuī't: ―Calīlīpuhuantit ixpālacata mincuentaca'n. Cacāmakxtektit ē nacātamātza'nkēna'ni'yān ē ca'a'kpaxtit. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tachi'xcuhuī't xalanī'n calhāxcuhuālh nac estado Judea ē xalanī'n nac cā'lacchicni' Jerusalén, ixlīpō'ktuca'n tamilh takexmata tū huanli Juan. A'cxni' takelhtasu'yuni'lh Dios ixcuentaca'n, Juan cāmā'kpaxīlh chā'tunu' nac ka'tla' xcān jā huanican Jordán. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan ixlhakā'nī't lu'xu' tū ixlīcāxtlahuacanī't ixchi'xit camello ē ixlīchī'can ko'xka' ixuanī't. Ixua' xtu'qui' ē xaxcān ta'xcāt xala' nac cā'qui'huī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ixa'kchihuīna'n ē ixcāhuani tachi'xcuhuī't: ―Ā'līstān namin ā'chā'tin tī ā'chulā' xaka'tla' ē jā quit. Quit jāla icmālakchā'nī chī xla'. Quit jā minī'ni' nūn na'icxcutni' ixlīkechī'can ixcaclhi'. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Quit iccālīmā'kpaxīnī'ta'n xcān; xla' nacāmacamini'yān Espíritu Santo. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tzamā' quilhtamacuj Jesús taxtulh nac cā'lacchicni' Nazaret xala' estado Galilea ē lakmilh Juan jā ixmā'kpaxīni'mā'lh. Juan mā'kpaxīlh Jesús nac ka'tla' xcān jā huanican Jordán. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","A'cxni' Jesús tacutli nac xcān, xamaktin laktzī'lh chī talaquī'lh nac a'kapūn ē mincha' Espíritu Santo ē ixtasu'yu hua'chi tantzasnān a'cxni' ixyujmā'chi. Chilh na ixa'kpūn Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kexmatca a'ktin tachihuīn nac a'kapūn ē huanli: ―Hui'x quiSka'ta' ē icpāxquī'yān. Hui'x quimaxquī'ya' tapāxuhuān ―huanli. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Palaj tunca Espíritu Santo macā'lh Jesús nac cā'tzaya'nca ti'ya't. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ixuī'lh a'ntza' nac cā'tzaya'nca ti'ya't tu'pu'xam quilhtamacuj. A'ntza' skāhuī'ni' tī huanican Satanás, xla' ixputza chī Jesús jā ixkexmatni'lh Dios. Nā a'ntza' ixa'nan animalh tū ixtahua'nan. Ixángeles Dios ixtamaktaka'lhmā'nalh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","A'cxni' ixchī'canī't Juan, Jesús a'lh nac Galilea ē ixlī'a'kchihuīna'n xatze tachihuīn tū ixla' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ixuan: ―Chilhtza' quilhtamacuj tū līlhcāna'ncanī't ē talacatzuna'jīmā'lhtza' a'cxni' nalaktzī'ncan ixlīcāna' Dios māpa'ksīni'n. Calīlīpuhuantit ixpālacata tū jā tze tū tlahuanī'ta'ntit ē calakpalī'tit mintalacapāstacni'ca'n. Ca'a'ka'ī'tit xatze tachihuīn tū Dios māca'tzīnīni'nī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","A'cxni' Jesús ixlatlā'huan na ixquilhtūn xaka'tla' xcān tū huanican Lago Galilea, xla' cālaktzī'lh Simón ē ixtā'tin Andrés. Ixtamojōmā'nalh nac xcān ixpūtayanca'n tū pūchi'pacan squī'ti'. Xlaca'n chi'pananī'n squī'ti' ixtahuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesús cāhuanilh: ―Caquilātā'a'uj ē na'iccāmāsu'yuni'yān chī nacālīmā'a'ka'ī'nī'yā'tit tachi'xcuhuī't ixtachihuīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Palaj tunca tamakxtekli ixpūtayanca'n ē tatā'a'lh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","A'cxni' Jesús a'lh lacapunchuna'j, cālaktzī'lh Jacobo ē Juan ixcamana' Zebedeo. Xlaca'n ixtahui'lāna'lh nac pūtacutnu' ē ixtalacachī'mā'nalh ixpūtayanca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Palaj tunca Jesús cāmāta'satīnīni'lh ē xlaca'n ta'a'kxtekui'līlh ixtāta'ca'n Zebedeo ē ī'scujnu'nī'n nac pūtacutnu' ē ta'a'lh tastālani'lh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ta'a'lh nac cā'lacchicni' Capernaum. A'cxni' a'cchā'lh quilhtamacuj tū pūjaxcan, palaj tunca Jesús tanūlh na ixtemploca'n israelitas ē cāmāsu'yuni'lh tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ixtalī'a'cnī chī ixcāmāsu'yuni'mā'lh ixpālacata ixcāmāsu'yuni'mā'lh hua'chi chā'tin tī ka'lhī līmāpa'ksīn ē jā chuntza' chī tamāsu'yu xamākelhtahua'kē'ni'nī'n līmāpa'ksīn. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Palaj tunca tanūlh nac templo chā'tin chi'xcu' tī ixka'lhī jā tzeya ū'ni'. Xla' ta'salh ē huanli: ");
INSERT INTO tkuNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―Jesús xala' nac Nazaret, ¿tū ixpālacata quilālakmiuj quina'n? ¿Ē ta'nī'ta' naquilāmālaksputūyāuj? Quit iclakapasān. Hui'x ixla' Dios ē Xatasicua'lanātlahua hui'x. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús lacaquilhnīlh jā tzeya ū'ni' ē huanilh: ―¡Caquilhca'csla'! ¡Camakxtekti huā'mā' chi'xcu'! ");
INSERT INTO tkuNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Chi'xcu' taxla'juani'lh ē jā tzeya ū'ni' palha' ta'salh ē taxtuni'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ixlīpō'ktuca'n talī'a'cnīlh ē talākelhasqui'nīlh: ―¿Tūchu huā'mā' tū quincāmāsu'yuni'mā'n quina'n? Xasāsti' huā'mā'. Huā'mā' chi'xcu' līchihuīna'n līmāpa'ksīn. Hasta jā tzeya ū'nī'n takexmatni' a'cxni' xla' cāmāpa'ksī. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Palaj tunca ta'a'kahuankō'lh calhāxcuhuālh nac estado Galilea ixpālacata tū tlahualh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","A'cxni' Jesús taxtulh na ixtemploca'n israelitas, palaj tunca a'lh ē tanūlh na ixchicca'n Simón ē Andrés. Tatā'a'lh Jacobo ē Juan. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ixpuhuiti' Simón ixmacscutlamā'lh ē ixmā'lh. Palaj māca'tzīnīca Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Xla' a'lh ē macachi'palh ē mā'kaquī'lh ē palaj tunca tapānūni'lh chī ixmacscutla. Palaj tunca puscāt cāmāhuī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kōtanūtza' a'cxni' ixtā'cnūmā'lhtza' chi'chini', cālīmini'ca Jesús ixlīpō'ktuca'n tī ixtata'jatatla ē tī ixtaka'lhī jā tzeya ū'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ixlīpō'ktuca'n xalanī'n cā'lacchicni' tatakēstokli na ixtanquilhtīn chic. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Cāmātzeyīlh lhūhua' tī ixtata'jatatla chu catūxcuhuālh ta'jatat ixtaka'lhī chā'tunu'. Cāmāxtuni'lh lhūhua' jā tzeya ū'nī'n. Jā cāmakxtekli natachihuīna'n jā tzeya ū'nī'n ixpālacata jā ixlacasqui'n xlaca'n ixtahualh tīchu xla'. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ixlīlakalī tzi'saj Jesús tāquī'lh ē taxtulh ē a'lh lacatīn jā jā tī ixuī'lh. A'ntza' orarlīlh. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón a'lh putza ē ā'makapitzīn tatā'a'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","A'cxni' tamaclalh Jesús, tahuanilh: ―Ixlīpō'ktuca'n tachi'xcuhuī't taputzayān. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Xla' cāhuanilh: ―Ca'a'uj nac ā'makapitzīn cā'lacchicni' tū tahui'lāna'lh lacatzuna'j ē quit a'ntza' na'icmāsu'yu ixtachihuīn Dios. Ū'tza' iclīminī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Calhāxcuhuālh nac estado Galilea ixmāsu'yu na ixtemploca'n israelitas ē cāmāxtulh jā tzeya ū'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Lakchā'lh Jesús chā'tin chi'xcu' tī ixka'lhī ta'jatat tū māmasī quinquinītca'n tū huanican lepra. Xla' tatzokostani'lh Jesús ē squi'ni'lh: ―Palh hui'x lacasqui'na', tzē naquimātzeyī'ya'. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús lakalhu'manli ē stu'ncli ixmacan ē xa'malh ē huanilh: ―Chuntza' quit iclacasqui'n. Catzeya'nti. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","A'cxni' huanilh huā'mā', tapānūni'lh ixta'jatat ē tzeyanli. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","A'cxni' Jesús macā'lh, lacatejtin huanilh: ");
INSERT INTO tkuNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Catamaktaka'lhti ē jā tihua'ni'ya' nūn chā'tin. Xmān calakpi pālej ē camāsu'yuni' mimacni'. Xla' nalaktzī'n palh tzeyanī'ta'tza'. Namālacnūni'ya' chuntza' chī māpa'ksīni'lh Moisés ixpālacata tī ixmakxteknī'ttza' tzamā' ta'jatat. Chuntza' nataca'tzī tachi'xcuhuī't tzeyanī'ta'tza'. ");
INSERT INTO tkuNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Xla' palaj tunca taxtulh ē tzuculh cāhuanitā'kchoko līlhūhua' ē cāhuanilh tū ixa'kspulanī't. Chuntza' Jesús jātza' la ixtanū nac cā'lacchicni' na ixlacatīnca'n tachi'xcuhuī't ixpālacata jā ixlacasqui'n ixtatakēstokli. Chuntza' xmān tachokolh na ixquilhtūn cā'lacchicni'. Tachi'xcuhuī't xalanī'n calhāxcuhuālh ixtalaka'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ixlīlātma'j Jesús taspi'tli ē tanūpālh nac Capernaum. Tachi'xcuhuī't takexmatli ixuī'lh nac chic. ");
INSERT INTO tkuNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Palaj tunca līlhūhua' talaktakēstokli hasta jātza' ixtatanūkō' ixpūchakān chic. Nā tatzumalh tanquilhtīn. Ixcāmāsu'yuni' ixtachihuīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Talakmilh ā'makapitzīn ē na ixlacpu'na'i'tātca'n kelhatā'ti' chi'xcuhuī'n ixtapūlīmimā'nalh talajni'. Nac talajni' ixmā'lh chā'tin ta'jatatlani' tī ī'xcahuī'huananī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Jāla talakchā'lh Jesús ixpālacata lhūhua' tachi'xcuhuī't ixlītzuma chic. Tapūtahua'ca'lh escalera ixa'kstīn chic ē ta'a'kstīxuakli chic ixlaktza Jesús. A'cxni' tzej tamālaquī'lh, talīchī'lh lasu talajni' ē tapūmānūlh ta'jatatlani'. ");
INSERT INTO tkuNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","A'cxni' Jesús laktzī'lh chī ixta'a'ka'ī'ni' ixlītli'hui'qui, xla' huanilh ta'jatatlani': ―Quinka'hua'cha, icmātza'nkēna'ni'kō'yān mincuenta. ");
INSERT INTO tkuNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ixtakexmatui'lāna'lh ā'makapitzīn xamākelhtahua'kē'ni'nī'n līmāpa'ksīn ē tapuhuanli ixa'cstuca'n: ");
INSERT INTO tkuNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Tū ixpālacata chihuīna'n chuntza' huā'mā' chi'xcu'? Xla' mālakchā'nī'mā'lh Dios chī chihuīna'nli. Nūn chā'tin tzē naquincāmātza'nkēna'ni'yān quincuentaca'n, xmān Dios.” ");
INSERT INTO tkuNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Palaj tunca Jesús ixlīmān ca'tzīlh chī xlaca'n ixtapuhuamā'nalh ē cāhuanilh: ―¿Tū ixpālacata puhua'nā'tit chuntza' na milīstacna'ca'n? ");
INSERT INTO tkuNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Icuanilhtza' ta'jatatlani': “Icmātza'nkēna'ni'kō'yān mincuenta.” Jā tū tasu'yu masqui mātza'nkēna'ni'catza'. Palh xa'icuanilh: “Catā'kaqui' ē casmi'li' mimpūtama' ē catlā'hua'nti”, chuntza' ixlītasu'yulh palh ixlīcāna' tzeyanli. ");
INSERT INTO tkuNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Quit Chi'xcu' xala' Tālhmā'n. Chuhua'j na'iccālīmāsu'yuni'yān chī icka'lhī līmāpa'ksīn huā'tzā' nac cā'quilhtamacuj ē tzē na'iccāmātza'nkēna'ni' ixcuentaca'n tachi'xcuhuī't. Palaj tunca Jesús huanilh chi'xcu' tī ī'xcahuī'huananī't: ");
INSERT INTO tkuNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Icuaniyān, catā'kaqui' ē casmi'li' mimpūtama' ē capit na minchic. ");
INSERT INTO tkuNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Xamaktin tā'kaquī'lh na ixlacatīnca'n ixlīpō'ktuca'n tī ixtahui'lāna'lh ē sacli ixpūtama' ē taxtulh. Ū'tza' talīlī'a'cnīlh ixlīpō'ktuca'n ē tamakapāxuīlh Dios ē tahuanli: ―Jā maktin laktzī'nī'tauj tū laktzī'uj chuhua'j. ");
INSERT INTO tkuNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Palaj tunca Jesús a'mpālh na ixquilhtūn mar. Ixlīpō'ktuca'n tachi'xcuhuī't talaka'lh ē ixcāmāsu'yuni'. ");
INSERT INTO tkuNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","A'cxni' Jesús ixa'mā'lh, tētaxtulh jā ixmātā'jīni'ncan līxokot ē laktzī'lh Leví ixka'hua'cha Alfeo. Jesús huanilh: ―Caquistā'la'ni'. Xla' tāyalh ē stālani'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Milh a'ktin quilhtamacuj a'cxni' Jesús ixuā'yamā'lh na ixchic Leví. Tachā'lh lhūhua' mātā'jīni'nī'n līxokot ē ā'makapitzīn tī ixcālakmaka'ncan. Xlaca'n ixcātā'huā'yamā'lh Jesús ē ī'scujnu'nī'n. Lhūhua' tī ixtastālani'. ");
INSERT INTO tkuNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","A'cxni' xamākelhtahua'kē'ni'nī'n līmāpa'ksīn ē fariseos talaktzī'lh ixcātā'huā'yan mātā'jīni'nī'n ē ā'makapitzīn tī ixcālakmaka'ncan, tahuanilh ī'scujnu'nī'n Jesús: ―¿Tū ixpālacata cātā'huā'yan Jesús mātā'jīni'nī'n ē tī jā tzeya chi'xcuhuī'n? ");
INSERT INTO tkuNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","A'cxni' Jesús kexmatli huā'mā' tachihuīn, cāhuanilh: ―Xlaca'n tī jā tata'jatatla jā tamaclacasqui'n doctor. Xmān tī tata'jatatla tamaclacasqui'n. Quit jā icmilh iccāputza tī tapuhuan xlaca'n lactze. Icmilh iccāputza tachi'xcuhuī't tī taca'tzī jā tze xlaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ī'scujnu'nī'n Juan ē fariseos makatunu' ixtalīhui'lī jā ixtahuā'yan. Makapitzīn chi'xcuhuī'n talakmilh Jesús ē tahuanilh: ―Ī'scujnu'nī'n Juan ē nā ī'scujnu'nī'n fariseos makatunu' talīhui'lī jā tahuā'yan. ¿Tū ixpālacata miscujnu'nī'n pō'ktu quilhtamacuj tahuā'yan? ");
INSERT INTO tkuNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús cāhuanilh: ―Xlaca'n tī cā'invitarlīcanī't jā tamakaxtokmā'ca, ¿ē natalīhui'lī jā catitahuā'yan? Līhuan cātā'lahuī'lhcus squi'nīni', natahuā'yan ixamigos. ");
INSERT INTO tkuNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Namin a'ktin quilhtamacuj a'cxni' nalē'ncan squi'nīni'. A'cxni' namin tzamā' quilhtamacuj, jā catitahuā'yalh ixamigos ixpālacata natalīpuhuan. (A'cxni' Jesús cāhuanilh huā'mā', ixlīchihuīna'mā'ca ixlē'cstu.) Jesús cāhuanipālh: ");
INSERT INTO tkuNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","―Huā'mā' tū quit icmāsu'yu, ū'tza' xasāsti'. Palh catīhuālh namākentaxtū ē nā mākentaxtūcu'tun ixtahui'latca'n mixū'nāpapna'ca'n, xla' nala hua'chi chā'tin tī nasita xasāsti' lu'xu' nalīlactza'pa' xamasni'. Xasāsti' lu'xu' nata'a'ktimī ē nastanca xamasni' ē a'ntza' jā taxtī'tli ā'chulā' ka'tla' nala. ");
INSERT INTO tkuNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Xaxcān uva tū jāna'j xcu'ta, jā tī chā'tin catipūmojōlh xamasni' ixko'xka' purecu'. Palh chuntza' ixtlahuaca, napanka ko'xka' a'cxni' naxcu'tan xaxcān uva. Namojōcan xasāsti' nac ko'xka'. A'cxni' naxcu'tan, jā catipankli. Chuntza' jā pāxcat catilalh ko'xka' ē jā catitaxtuni'lh xaxcān uva ―cāhuanilh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","A'ktin quilhtamacuj tū ixpūjaxcan, Jesús ixcātā'tētaxtumā'lh ī'scujnu'nī'n nac a'ktin cā'tacuxtu. Xlaca'n tatzuculh ta'ī' pātin pātu' tza'ktza'. ");
INSERT INTO tkuNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Palaj tunca tahuanilh Jesús fariseos: ―Cala'ktzi'. Miscujnu'nī'n tascujmā'nalh ē chuhua'j quilhtamacuj tū pūjaxcan. Chuntza' jā mākentaxtū ixlīmāpa'ksīn Moisés. ");
INSERT INTO tkuNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesús cākelhtīlh: ―¿Ē jā līkelhtahua'kanī'ta'ntit tū tlahualh David a'ktin quilhtamacuj? Xla' ē tī ixtatā'a'mā'nalh ixtatzi'ncsa ē cāsputni'lh līhua'. ");
INSERT INTO tkuNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tanūlh na ixchic Dios a'cxni' Abiatar xapuxcu' pālej ixuanī't ē hua'lh pāntzīn tū ixmālacnūcanī't Dios. Jā minī'ni' ixua'lh huā'mā' pāntzīn ixpālacata xmān pālejni' tzē natahua'. Nā David cāmaxquī'lh chi'xcuhuī'n tī ixtatā'a'mā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nā Jesús cāhuanilh: ―Dios tlahualh quilhtamacuj tū pūjaxcan ixpālacataca'n tachi'xcuhuī't ē jā tlahualh tachi'xcuhuī't ixpālacata quilhtamacuj tū pūjaxcan. ");
INSERT INTO tkuNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Chuntza' quit Chi'xcu' xala' Tālhmā'n ē tzē na'icmāpa'ksī tū natlahuacan a'cxni' quilhtamacuj tū pūjaxcan. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesús tanūpālh na ixtemploca'n israelitas. Ixuī'lh a'ntza' chā'tin chi'xcu' tī ixmacascācnī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tachi'xcuhuī't ixtamaktaka'lhmā'nalh Jesús palh namātzeyīni'n tzamā' quilhtamacuj tū pūjaxcan ixpālacata ixtalīmālacsu'yucu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesús huanilh chi'xcu' tī ixmacascācnī't: ―Cata't ē catāya' na quilacpu'na'i'tātca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Cāhuanilh tachi'xcuhuī't: ―¿Tū ā'chulā' minī'ni' tlahuacan quilhtamacuj tū pūjaxcan? ¿Ē na'ictlahua tū tze o tū jā tze? ¿Ē minī'ni' na'icmakapūtaxtū chi'xcu' o na'icmaknī? Xlaca'n ca'cs ixtahui'lāna'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesús cālaktzī'lh ixlīpō'ktuca'n tī ixtalītamacsti'li'nī't. Ixsītzī'yālh ē nā ixlīlīpuhuayālh chī jā ixtalakalhu'man ta'jatatlani' ē huanilh chi'xcu': ―Castu'ncti mimacan. A'cxni' stu'ncli ixmacan, tzetza' ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Palaj tunca fariseos tataxtulh ē tatā'chihuīna'nli ixchi'xcuhuī'n Herodes chī natalīmaknī Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesús a'lh na ixquilhtūn lago ē ī'scujnu'nī'n tatā'a'lh. Lhūhua' tachi'xcuhuī't xalanī'n nac estado Galilea tastālani'lh Jesús. A'cxni' takexmatli pō'ktu tū tlahualh Jesús, talakmilh nā xlaca'n xalanī'n nac estado Judea. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Xalanī'n nac Jerusalén ē xalanī'n nac Idumea talakmilh Jesús. Xlaca'n xalanī'n ixtuntacut nac xcān Jordán ē xalanī'n lacatzuna'j cā'lacchicni' Tiro ē Sidón nā talakmilh. Lhūhua' tachi'xcuhuī't talakmilh Jesús a'cxni' takexmatli tū tlahualh. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Cāhuanilh ī'scujnu'nī'n catacāxui'līlh a'ktin barco jā natojō ē chuntza' lhūhua' tachi'xcuhuī't jāla catitatancsli. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Lhūhua' ixcāmātzeyīnī't ē pō'ktu tī ixtata'jatatla ixtalaktalacatzuna'jī ē ixtalālacxquitimā'nalh. Ixtaxa'macu'tun Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","A'cxni' xlaca'n tī ixtaka'lhī jā tzeya ū'nī' talaktzī'lh Jesús, xlaca'n tatatzokostani'lh ē palha' tahuanli: ―Hui'x ī'Ska'ta' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Xla' cāmāpa'ksīlh ē cāhuanilh jā ixtahuanli tīchu xla'. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesús a'lh nac sipej ē cāta'sani'lh tī cālacasqui'nli ē talakmilh. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Cālacsacli kelhacāujtu' tī natatā'latā'kchoko ē nacāmacā'n natamāsu'yu ixtachihuīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nā xlaca'n cāmaxquī'ca līmāpa'ksīn natamātzeyī ta'jatatlanī'n ē natamāxtu jā tzeya ū'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Tzamā' kelhacāujtu': Simón tī hui'līni'ca ixtacuhuīni' Pedro, ");
INSERT INTO tkuNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ē nā Jacobo ē Juan ixtā'tin tī ixka'hua'chan Zebedeo ixtahuanī't ē xlaca'n cāhui'līni'ca ixtacuhuīni' Boanerges tū huanicu'tun hua'chi jilini'. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Nā Andrés ē Felipe ē Bartolomé ē Mateo ē Tomás ē Jacobo ixka'hua'cha Alfeo ē Tadeo ē Simón. Huā'mā' Simón ixtapa'ksīni' partido cananistas. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ē Judas Iscariote, xla' tī ā'līstān macamāstā'lh Jesús. Jesús a'lh na ixchic. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tatakēstokpālh lhūhua' tachi'xcuhuī't hasta jāla ixtahuā'yan Jesús ē ī'scujnu'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","A'cxni' ixtalakapasnī'n taca'tzīlh huā'mā', xlaca'n talakmilh natachi'pa ixpālacata ixtahuan xla' hua'chi chuyani' ixlīla. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Xamākelhtahua'kē'ni'nī'n līmāpa'ksīn tī ixtaminī'ta'ncha' nac Jerusalén ixtahuan: ―Beelzebú, tī xapuxcu' jā tzeya ū'nī'n, xla' tanūni'nī't Jesús. Ū'tza' cālīmāxtu jā tzeya ū'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesús cāta'sani'lh ē cāhuanilh tū līca'tzīni'can: ―¿Chī nalīmāxtucan Skāhuī'ni' palh ū'tza' tī tanūma'lh? ");
INSERT INTO tkuNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Palh māpa'ksīni'nī'n tatapitzi ē talātucsa, jā catitatāyani'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Palh tampūtin familia tatapitzi ē natalātucsa, jā catitatāyani'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","¿Chī Skāhuī'ni' nalīmāxtu ixtā'skāhuī'ni' palh chu ū'tza' tī māpa'ksīmā'lh? Palh Skāhuī'ni' natapitzi, jāla catitāyani'lh; tzē nalaksputa. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Jā tī chā'tin catitanūlh naka'lhāna'n na ixchic chā'tin tī tli'hui'qui palh jā pūla nachī'can ixtēcu' chic. A'cxni' chī'hui'līcanī'ttza', a'cxni' tzētza' namakka'lhāna'ncan. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Ixlīcāna' tū iccāhuaniyān: Tzē namātza'nkēna'ni'can ixlīpō'ktu ixcuentaca'n tachi'xcuhuī't ē catūxcuhuālh jā tze tū tahuan. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Palh catīhuālh ixuanlī jā tze tū tlahua Espíritu Santo, xla' jāla catimātza'nkēna'ni'ca. Xla' naka'lhī ixcuenta pō'ktu quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesús huanli huā'mā' ixpālacata ixtahuan: “Xla' ka'lhī jā tzeya ū'ni'.” ");
INSERT INTO tkuNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ā'līstān tachā'lh ixtzī' ē ixtā'timīn Jesús. Tatāyalh nac kēpūn ē māta'satīnīni'nca xla'. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tachi'xcuhuī't ixtalītasti'li'nī't ē tahuanilh: ―Tayāna'lh mintzī' nac kēpūn ē mintā'timīn ē tatā'chihuīna'ncu'tunān. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Xla' cākelhtīlh: ―¿Ē ca'tzīyā'tit tīchu iccālaktzī'n hua'chi quintzī' ē quintā'timīn? ");
INSERT INTO tkuNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ixcālaktzī'nkō' ixlīpō'ktuca'n tī ixtahui'lāna'lh ē ixtalītasti'li'nī't ē cāhuanilh: ―Tzamā' ū'tunu'n quintzī' ē quintā'timīn. ");
INSERT INTO tkuNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ixlīpō'ktuca'n tī natatlahua tū lacasqui'n Dios, ū'tunu'n quintzī' ē quintā'timīn. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Palaj tunca Jesús tzucupālh māsu'yu na ixquilhtūn mar. Talaktakēstokli lhūhua' tachi'xcuhuī't ē ū'tza' lītojōlh a'ktin nac barco. Tahuī'lh nac barco tū ixuī'lh na ixkelhni' xcān. Ixlīpō'ktuca'n tachi'xcuhuī't tatachokolh na ixquilhtūn xcān. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Lhūhua' ixcālīmāsu'yuni'mā'lh tū līca'tzīni'can. A'cxni' ixcāmāsu'yuni'mā'lh, cāhuanilh: ");
INSERT INTO tkuNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Cakexpa'ttit. Ixuī'lh chā'tin cha'nāna' ē taxtulh nacha'n ixlīcha'nat. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","A'cxni' ixmakahuanīmā'lh līcha'nat, makapitzīn tayujli nac tej. Tamilh spūnī'n ē tasacua'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ā'makapitzīn tayujli nac cā'chihuixni' jā jā pūlhmā'n ti'ya't. Palaj pu'nli huā'mā' līcha'nat ixpālacata jā pūlhmā'n ti'ya't. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","A'cxni' chi'chini'lh, scācli xapa'lhma' ixpālacata jāla tā'cnūlh ixtankēxē'k ē xnekli. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ā'makapitzīn līcha'nat huampala tayujli nac cā'lhtucū'n ē lhtucu' tastacli ē tamā'ktzī'lh ē jā tū tahua'ca'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ā'makapitzīn līcha'nat tayujli jā tze ti'ya't ē pu'nli ē stacli ē māstā'lh ixtahua'ca't. Makapitzīn līcha'nat tamāstā'lh pu'xamacāuj ē ā'makapitzīn tamāstā'lh tu'tumpu'xam ē ā'makapitzīn tamāstā'lh a'ktin cientu. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jesús cāhuanilh: ―Palh kexpa'tnī'ta'ntit, cuenta catlahua'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","A'cxni' ixta'a'nī'ttza' lhūhua' tachi'xcuhuī't, xmān tatachokolh Jesús ē kelhacāujtu' ē ā'makapitzīn huampala. Kelhacāujtu' takelhasqui'nīlh ixpālacata tū līca'tzīni'can. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesús cāhuanilh: ―Dios cāmāsu'yunī'ta'n hui'xina'n tū tatzē'knī't ixpālacata chī nala ixlīmāpa'ksīn Dios. Ā'makapitzīn iccālītachihuīna'n xmān chī natalīca'tzīni'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Chuntza' masqui takexmatli, jā catitaca'tzīlh ē masqui talaktzī'n, tasu'yu hua'chi jā talacahuāna'n. Ū'tza' jā catitalīlakpalīlh ixtalacapāstacni'ca'n ē jā caticāmātza'nkēna'ni'ca ixcuentaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesús cāhuanilh: ―Palh jā kexpa'tā'tit huā'mā' tū līca'tzīni'can, jā catica'tzī'tit ixlīpō'ktu ā'makapitzīn. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Cha'nāna' cha'nli ixtachihuīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","A'ntza' jā yujli līcha'nat nac tej, ū'tza' hua'chi tachi'xcuhuī't tī takexmatli ē palaj milh skāhuī'ni' ē cāmāpātza'nkēnīlh tū ixtasca'tnī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","’Nā chuntza' jā yujli līcha'nat nac cā'chihuixni', ū'tza' hua'chi tī takexmata ixtachihuīn Dios ē talakatī. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Hua'chi līcha'nat tū jā ixka'lhī pūlhmā'n ixtankēxē'kca'n jā tāyani'lh, chuntza' xlaca'n jā makās tatāyani'. A'cxni' tapātī catūhuālh o a'cxni' cāputzastālani'can ixpālacata tū ta'a'ka'ī'lh, jātza' talakatī ē tamakxtekcu'tun ixtachihuīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","’Jā yujli līcha'nat nac cā'lhtucū'n, ū'tza' hua'chi xlaca'n tī takexmata tachihuīn ē sca'ta. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Masqui tasca'tli, talacapāstaca chī natalīhuā'yan ē chī lacricujnu' natalīhuan. Nā talacasqui'n lhūhua' catūhuālh. Ixlīpō'ktu huā'mā' cāmāmakchuyī ē jā cāmakxteka natalacapāstaca tū takexmatli. Jātza' tatasu'yu palh ta'a'ka'ī'. Chuntza' tzamā' hua'chi lhtucu' tū tamā'ktzī'lh līcha'nat. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","’Jā yujli līcha'nat nac tze ti'ya't, ū'tza' hua'chi xlaca'n tī takexmata tachihuīn ē tasca'ta ē tzej tatasu'yu palh ta'a'ka'ī'. Ixlīpō'ktuca'n taka'lhī tū natalīmakapāxuī Dios. Xlaca'n hua'chi līcha'nat tū māstā'lh pu'xamacāuj ē makapitzīn ā'chulā' taca'tzī tamakapāxuī Dios. Xlaca'n hua'chi līcha'nat tū māstā'lh tu'tumpu'xam o a'ktin cientu ixtahua'ca't. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesús cāhuanilh: ―Jā tī chā'tin līmin pūcās ē nalīmakchahua catūhuālh o nahui'lī na ixtampīn tama'. Hui'līcan a'ktin nac mesa o a'ktin nac cajón. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Pō'ktu tū tatzē'knī't chuhua'j, pō'ktu namāsu'yukō'can. Tū tatzē'knī'tcus, ū'tza' naca'tzīkō'can. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Palh kexpa'tnī'ta'ntit, cuenta catlahua'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Chuntza' cāhuanilh Jesús: ―Cuenta catlahua'tit tū kexpa'tā'tit. Palh nalīhui'lī'yā'tit nasca'tā'tit, Dios nacāmaktāyayān ē ā'chulā' nasca'tā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tī cuenta tlahua ixtachihuīn Dios, ā'chulā' nasca'ta. Tī jā cuenta tlahua, napātza'nkākō' tū kexmatnī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesús huanli: ―Chī Dios māpa'ksīni'nkō', ū'tza' hua'chi a'cxni' chā'tin chi'xcu' nacha'n līcha'nat nac ti'ya't. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Xla' nalhtata tzī'sa ē natā'kaquī' tzi'saj. Līcha'nat napu'n ē nastaca ē xla' jā ca'tzī chī līpu'nli ē chī līstacli. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ti'ya't ixlīmān makapu'nli; pūla tasu'yu xapa'lhma' ē palaj tunca xaxihuī't ē ā'līstān tza'ktza'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","A'cxni' scāclitza' ē cuxi'tza' nahuan, palaj tunca ī'can ixpālacata chilhtza' quilhtamacuj tū napū'ī'can. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesús huanli: ―¿Chī huan ixlīmāpa'ksīn Dios? ¿Chī nalīmāsu'yuyāuj chī natalhūhua'n xlaca'n tī Dios cāmāpa'ksī? ");
INSERT INTO tkuNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Natalhūhua'n hua'chi a'ktin xalīcha'nat tū huanican mostaza. Huā'mā' xalīcha'nat ā'chulā' xamactzina'j ē jā ixlīpō'ktuca'n ā'makapitzīn līcha'nat tū cha'ncan. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","A'cxni' cha'ncanī'ttza', ē nastaca, ka'tla' nahuan ē lhūhua' ixpekenī'n naka'lhī. Chuntza' spūnī'n tzē natatlahua ixmāsekca'n jā skē'knin. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Chuntza' lhūhua' ixcālīmāsu'yuni' tū līca'tzīni'can ē līlacatzucu cāmāsu'yuni'lh chuntza' chī tzē natalīsca'ta. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Xmān tū līca'tzīni'can ixcālītā'chihuīna'n tachi'xcuhuī't. A'cxni' ixlīmānca'n xla' ē ī'scujnu'nī'n, tzej ixcālīmāsu'yuni' ixlīpō'ktu. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kōtanūtza' ixuanī't tzamā' quilhtamacuj ē Jesús cāhuanilh ī'scujnu'nī'n: ―Ca'a'uj ixtuntacut nac xcān. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jesús ixuī'lhcus nac barco, ē chuntza' talīlē'lh nac barco ē cāmakxtekli lhūhua' tachi'xcuhuī't. Ā'makapitzīn barco nā tatā'a'lh ixtuntacut nac xcān. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","A'cxni' ixtatacutmā'nalh, palha' tzuculh ū'nun. Mar sno'kli barco ē ixlītatzumamā'lh xcān. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesús xtum ixmā'lh nac barco ē ī'lhtatamā'lh ē ixa'ktzi'mā'lh a'ktin ixa'ktzi'. Tamālakahuanīlh ē tahuanilh: ―Mākelhtahua'kē'ni', tā'cnūmā'nauj ē hui'x jā cuenta tlahua'ya'. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesús tā'kaquī'lh ē lacaquilhnīlh ū'ni' ē huanilh mar: ―Caca'csla'. Ca'cslalh ū'ni' ē ca'cs tahuī'lh mar. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesús cāhuanilh ī'scujnu'nī'n: ―¿Tū ixpālacata jicua'nā'tit? Jā quilālīpāhuanāuj. ");
INSERT INTO tkuNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Talī'a'cnīlh ē talāhuanilh chā'tunu' xlaca'n: ―¿Tichūyā chi'xcu' huā'mā'? Hasta tzē cāmāpa'ksī ū'ni' ē mar ē takexmatni'. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tachā'lh xlaca'n ixtuntacut mar nac a'ktin ti'ya't jā huanican Gadara. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","A'cxni' Jesús tacutli nac barco, palaj tunca laktalacatzuna'jīlh chā'tin chi'xcu' tī taxtulh na ixpu'nan pūtā'cnūn. Ixka'lhī jā tzeya ū'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Xla' ixlahuī'lh nac lhu'cu' jā ixcāmā'cnūcanī't nīnī'n. Jā tī chā'tin tzē ixchī' ē masqui ixlīchī'can cadenas. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Maklhūhua' ixtūpixchī'canī't ē ixmacatūpixchī'canī't līcā'n ē cadenas ē xla' lacpu'xli cadenas ē lacstīn tlahualh līcā'n ē jā tī chā'tin tzē ī'skāhuī'. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Cā'tzī'sni' ē cā'cuhuīni' jā ixuī'lh lhu'cu' ē na ixlacapūn sipej pō'ktu quilhtamacuj ixta'satā'kchoko ē ixlītakāhuī'can chihuix. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Makatcus ixmimā'cha' Jesús a'cxni' chi'xcu' laktzī'lh ē laktu'jnulh ē lakachi'xcuhuī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Tā'chihuīna'nli palha' ē huanli: ―¿Tū ixpālacata ta'na' hui'x jā icuī'lh, Jesús? Hui'x ī'Ska'ta' Dios xaka'tla'. ¿Ē mimaca'tzi tū ictlahuamā'lh? Icsqui'ni'yān jā naquintimakapātīnīna'. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Chuntza' ī'squi'ni'mā'ca Jesús ixpālacata xla' ixuaninī't jā tzeya ū'ni': ―Cataxtuni' tzamā' chi'xcu'. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesús kelhasqui'nīlh: ―¿Chī huanica'na'? Xla' kelhtīlh: ―Quihuanican Legión ixpālacata quina'n lhūhua'. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ixtasqui'ni'mā'nalh Jesús jā cacāmacā'lh makat. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Lhūhua' pa'xnī'n ixtahuā'yamā'nalh lacatzuna'j a'ntza' na ixlacapūn sipej. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Jā tzeya ū'nī'n tasqui'ni'lh Jesús: ―Caquilāmacamini'uj lhūhua' pa'xnī'n ē tzē na'ictanūpalayāuj na ixpūlacni'ca'n tzamā' pa'xnī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Palaj tunca cāmakxtekli natatanū. Jā tzeya ū'nī'n tataxtuni'kō'lh chi'xcu' ē tapūlactojōlh ixpūlacni'ca'n pa'xnī'n. Xlaca'n tatu'jnulh ta'a'lh lacatampān ē tatojōcha' nac xcān ē tajicsua'kō'lh. Chī a'ktu' mil pa'xnī'n ixtahuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Chi'xcuhuī'n tī ixtamaktaka'lhmā'nalh pa'xnī'n ē tatzā'lalh ē tamāca'tzīnīni'lh nac cā'lacchicni' ē ixquilhtūn cā'lacchicni'. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","A'cxni' ā'makapitzīn tachā'lh jā ixuī'lh Jesús, xlaca'n talaktzī'lh chi'xcu' tī jātza' ixcāka'lhī jā tzeya ū'nī'n. Xla' ca'cs ixuī'lh ē ixmālhekē'canī'ttza'. Xlaca'n tajicua'nli. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tī ixtalaktzī'nī't tahuanilh tū ixa'kspulanī't chi'xcu' tī ixcāka'lhīnī't jā tzeya ū'nī'n ē nā tū ixcā'a'kspulanī't pa'xnī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Palaj tunca tatzuculh tasqui'ni' Jesús nataxtu a'ntza'. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","A'cxni' Jesús ixtojōmā'lh nac barco, milh chi'xcu' tī ixcāka'lhīnī't jā tzeya ū'nī'n ē squi'ni'lh camakxtekli natā'a'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesús jā makxtekli natā'a'n ē huanilh: ―Cataspi'tti na minchic ē nacāhua'ni'kō'ya' mintalakapasni' ē minamigos lhūhua' tū Māpa'ksīni' tlahuani'nī'ta'n ē chī lakalhu'manī'ta'n hui'x. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Chi'xcu' a'lh ē calhāxcuhuālh jā huanican Decápolis xla' tzuculh līchihuīna'n tū Jesús tlahuani'lh. Ixlīpō'ktuca'n tachi'xcuhuī't talī'a'cnīlh. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","A'cxni' Jesús pūtacutpālh barco ixtuntacut nac xcān, talaktakēstokli lhūhua' tachi'xcuhuī't jā xla' ixuī'lh lacatzuna'j nac mar. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Milh chā'tin xapuxcu' ixtemploca'n israelitas ē ixtacuhuīni' Jairo. A'cxni' laktzī'lh Jesús, tatzokostani'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Squi'ni'lh ē huanilh: ―Quintzu'ma'jāt nīmā'lhtza'. Cata't ē namacaxa'ma'ya'. Natzeyan ē nalatahui'lapala. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesús tā'a'lh. Ixtastālani' lhūhua' tachi'xcuhuī't ē ixtalālacxquititēlha. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na ixpu'nanca'n ixa'mā'lh chā'tin puscāt tī ixta'jatatla. Ixka'lhītza' a'kcāujtu' cā'ta jāla ixcāsni' ixka'lhni'. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Lhūhua' doctornu' ixtamakapātīnīnī't ē ixmakasputkō'nī'ttza' ixtumīn ē jā tū tū ixmacuani'. Ā'chulā' ixlamā'. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ixkexmatnī't chī ixtlahua Jesús ē laktalacatzuna'jīlh na ixchakēn na ixpu'nanca'n lhūhua' tachi'xcuhuī't ē xa'malh ixlu'xu'. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Chuntza' tlahualh ixpālacata puhuanli: “Xmān ca'icxa'malh ixlu'xu' ē na'ictzeyan.” ");
INSERT INTO tkuNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Chuntza' palaj tunca tzeyanli. Makca'tzīlh na ixmacni' ixtzeyanī'ttza' ixta'jatat. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Palaj tunca Jesús u'cxca'tzīlh chī ixlīmātzeyīnī't ixlītli'hui'qui. Cālaktalakspi'tli tachi'xcuhuī't ē cāhuanilh: ―¿Tīchu xa'malh quilu'xu'? ");
INSERT INTO tkuNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tahuanilh ī'scujnu'nī'n: ―Laktzī'na' chī lhūhua' tachi'xcuhuī't talālacxquitiyān. Ē hui'x kelhasqui'nīni'na': “¿Tīchu quixa'malh?” ");
INSERT INTO tkuNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Xla' calhāxcuhuālh ixlacaputzamā'lh nalaktzī'n tī ī'xa'manī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Puscāt ixca'tzī tū ixa'kspulanī't ē chī ixtzeyanī'ttza' ē xla' ixjicua'n. Ī'xpipitēlha laka'lh ē tatzokostani'lh Jesús ē huanikō'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Xla' huanilh: ―Quintzu'ma'jāt, tzeyanī'ta' ixpālacata a'ka'ī'nī'ta'. Līpāxuhua capit. Tzeyanī'ta' minta'jatat. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ixchihuīna'mā'lhcus Jesús a'cxni' tamilh makapitzīn xalanī'n na ixchic Jairo. Tahuanilh Jairo: ―Mintzu'ma'jāt nīlhtza'. ¿Tū ixpālacata māmakchu'yī'ya'cus Mākelhtahua'kē'ni'? ");
INSERT INTO tkuNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesús jā cuenta cātlahuani'lh tū ixtahuan. Huanilh xapuxcu' xala' nac templo: ―Jā cajicua'nti, xmān ca'a'ka'i'. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesús jā makxtekli jā tī chā'tin nastālani', xmān Pedro ē Jacobo ē Juan ixtā'tin Jacobo. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ta'a'lh na ixchic xapuxcu' ixtemploca'n israelitas. A'cxni' tachā'lh, Jesús laktzī'lh lhūhua' tachi'xcuhuī't. Ixtacalhuamā'nalh ē ixtata'samā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesús a'cxni' tanūlh, cāhuanilh: ―¿Tū ixpālacata ta'sayā'tit ē calhua'nā'tit? Tzu'ma'jāt jā nīnī't, xmān lhtatamā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Xmān talīlītzī'nli. A'cxni' Jesús cāmāxtukō'lh ixlīpō'ktuca'n, cālē'lh ixtāta' tzu'ma'jāt ē ixtzī' ē tī ixtatā'minī't. Tatanūlh jā ixmā'lh tzu'ma'jāt. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Macachi'palh tzu'ma'jāt ē huanilh: ―Talita cumi. (Huā'mā' tachihuīn huanicu'tun: Tzu'ma'jāt, icuaniyān catā'kaqui'.) ");
INSERT INTO tkuNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Palaj tunca tā'kaquī'lh tzu'ma'jāt ē xla' ixlatlā'huan. Xla' ixka'lhī a'kcāujtu' cā'ta. Tachi'xcuhuī't talī'a'cnīlh ē tajicua'nli. ");
INSERT INTO tkuNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesús māpa'ksīlh jā tī chā'tin ixtamāca'tzīnīlh ē cāhuanilh: ―Camāhuī'tit tzu'ma'jāt. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús taxtulh a'ntza' ē taspi'tli na ixcā'lacchicni' jā ī'stacnī't ē tastālani'lh ī'scujnu'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","A'cxni' chilh quilhtamacuj tū pūjaxcan, tanūlh na ixtemploca'n israelitas ē tzuculh māsu'yu. Lhūhua' tachi'xcuhuī't takexmatli ē talī'a'cnīlh ē tahuanli: ―¿Jāchu sca'tli huā'mā' chi'xcu' tū ca'tzī? ¿Tuchūyā talacapāstacni' maxquī'canī't? ¿Chī tzē nacālītlahua tzamā' lī'a'cnīn? ");
INSERT INTO tkuNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ū'tza' huā'mā' xuacna' ē María ixtzī'. Nā xla' ixpuxcu'ca'n Jacobo ē José ē Judas ē Simón. Tahui'lāna'lh huā'tzā' xanastancunu' puscan. Ū'tza' talīsītzī'lh ē talakmaka'lh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Xla' cāhuanilh: ―Chā'tin a'kchihuīna' nalakachi'xcuhuī'can calhāxcuhuālh na'a'n. Xmān xalanī'n na ixcā'lacchicni' ē ixtalakapasnī'n jā talakachi'xcuhuī'cu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","A'ntza' na ixcā'lacchicni' Jesús jāla tlahualh lī'a'cnīn. Xmān cāxa'malh makapitzīn ta'jatatlanī'n ē cāmātzeyīlh. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesús lī'a'cnīlh ixpālacata jā ta'a'ka'ī'lh. Ixmāsu'yutēlha nac a'katunu' lacsti'na'j cā'lacchicni'. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesús cātā'talacxtimīlh kelhacāujtu' ī'scujnu'nī'n ē tzuculh cāmacā'n chā'tu'yūn ē cāmaxquī'lh līmāpa'ksīn natamāxtu jā tzeya ū'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Cāhuanilh: ―Jā tū tilī'pinā'tit nac tej, nūn morralh, nūn pāntzīn, nūn tumīn na mimbolsaca'n. Xmān nalī'pinā'tit mimpāla'cca'n ē ");
INSERT INTO tkuNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","natatūnū'yā'tit mincaclhi'ca'n. Jā tilī'pinā'tit pūtu' milu'xu'ca'n, xmān pūtin. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jesús cāhuanipālh: ―Calhāxcuhuālh nac chic jā nachipinā'tit, a'ntza' natachokoyā'tit hasta a'cxni' nataxtuyā'tit nac tzamā' cā'lacchicni'. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Palh catīxcuhuālh jā cātamānūyān na ixchic ē palh jā takexmatcu'tun tū hua'nā'tit, cataxtutit tzamā' cā'lacchicni'. A'cxni' nataxtuyā'tit, catincxtit mintujanca'n ē nayuja pokxni' na ixlacatampūn mintujanca'n. Chuntza' nalīmāsu'yu'yā'tit xlaca'n natalē'n cuenta ixpālacata jā takexmatcu'tunli. Ixlīcāna' tū iccāhuaniyān. A'cxni' namin quilhtamacuj a'cxni' Dios nacāputzāna'nīkō', xlaca'n natapātīni'n ixpālacata jā takexmatcu'tunli. Ā'chulā' natapātīni'n xlaca'n ē jā xalanī'n nac Sodoma ē Gomorra ―cāhuanilh. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ta'a'lh scujnu'nī'n ē ixtamāsu'yuni' tachi'xcuhuī't ixlacasqui'nca natalakpalī ixtalacapāstacni'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Tamāxtulh lhūhua' jā tzeya ū'nī'n. Ixcālīmūtlahua aceite lhūhua' ta'jatatlanī'n ē cāmātzeyīlh. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Rey Herodes kexmatli tū ixtlahuamā'lh Jesús ixpālacata lhūhua' tī ixtalīchihuīna'mā'nalh. Herodes huanli: ―Juan tī ixmā'kpaxīni'n lacastālancuana'nī't ixlacpu'na'i'tātcan nīnī'n. Ū'tza' līka'lhī lītli'hui'qui tū lītlahua lī'a'cnīn. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Makapitzīn ixtahuan: ―Ū'tza' Elías tī ixa'kchihuīna' Dios xalanī'n makāstza'. Ā'makapitzīn ixtahuampala: ―Ū'tza' a'kchihuīna' chī xalanī'n makāstza'. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","A'cxni' huanica Herodes tū tlahualh Jesús, xla' huanli: ―Ū'tza' Juan tī icmā'a'cchu'cunīni'lh. Xla' lacastālancuana'nī't ē taxtulh na ixpu'nan nīnī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodes ū'tza' ixmāpa'ksīnī't ē ixmāchi'panīni'nī't Juan ē ixmāchī'nīni'nī't nac pūlāchī'n ixpālacata Herodías tī ixpuscāt Felipe ixuanī't. Huā'mā' Felipe ixtā'tin Herodes. Herodes ixtā'tahui'la tzamā' puscāt. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Juan ixuaninī't Herodes: ―Jā minī'ni' chī tā'tahui'la'ya' ixpuscāt mintā'tin. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ū'tza' Herodías līlalh ixtā'lāquiclhlaktzi' Juan ē ixmaknīcu'tun. Jāla ixmaknī ");
INSERT INTO tkuNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ixpālacata Herodes ixjicua'ni' Juan. Ixca'tzī tzeya chi'xcu' ixuanī't Juan ē līlacatejtin ixlatlā'huan. Ū'tza' Herodes jā līmakxtekli Herodías natlahuani' Juan tū ixtlahuacu'tun. Masqui Herodes tamakchuyīlh ixpālacata tū māsu'yulh Juan, ixkexmatcu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Milh a'ktin quilhtamacuj a'cxni' Herodías tzē tlahualh ixtapāxuhuān. Herodes tlahualh ixcā'tani' a'cxni' chā'lh ixcā'ta. Cā'invitarlīlh nacātā'huā'yan na ixchic xanapuxcu'nu' ē xamāpa'ksīni'nī'n ē generales tī ixtatā'scuja nac estado Galilea. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ixtzu'ma'jāt Herodías tanūlh ē tlīlh ē cāmakapāxuīlh Herodes ē tī ixcātā'huā'yamā'lh. Rey Herodes huanilh tzu'ma'jāt: ―Caquisqui'ni' tū lacasqui'na' ē quit na'icmaxquī'yān. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Lacatejtin huanilh: ―Ixlīcāna' tū icuanin. Na'icmaxquī'yān tū naquisqui'ni'ya' masqui i'tāt jā quit icmāpa'ksī. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tzu'ma'jāt taxtulh ē kelhasqui'nīlh ixtzī': ―¿Tū na'icsqui'ni'? Xla' huanilh: ―Nasqui'na' ixa'kxāk Juan Mā'kpaxīni'. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tzu'ma'jāt palaj tunca tanūlh jā ixuī'lh rey ē huanli: ―Iclacasqui'n ixa'kxāk Juan Mā'kpaxīni'. Chuhua'j palaj tunca naquimaxquī'ya' a'ktin nac pulātu. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ū'tza' līlīpuhuanli rey Herodes ixpālacata tū ixmālacnūni'nī't tzu'ma'jāt. Masqui līlīpuhuanli, jātza' la lakpalīlh ixtachihuīn ixpālacata ixtakexmatnī'ttza' tī ixcā'invitarlīcanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Palaj tunca rey māpa'ksīlh chā'tin mayūlh nalīmin ixa'kxāk Juan. Xla' a'lh nac pūlāchī'n ē a'cchu'culh. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Līminca ixa'kxāk a'ktin nac pulātu ē maxquī'ca tzu'ma'jāt. Tzu'ma'jāt maxquī'lh ixtzī'. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","A'cxni' cāmāca'tzīnīca ī'scujnu'nī'n Juan, xlaca'n tamilh ē tasacli ixmacni' ē tamā'cnūlh nac a'ktin pūtā'cnūn. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","A'cxni' apóstoles talaktaspi'tli Jesús, tahuanikō'lh pō'ktu tū ixtatlahuanī't ē tū ixtamāsu'yunī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesús cāhuanilh: ―Cata'ntit xmān hui'xina'n ē caquilātā'miuj jā nūn chā'tin lahuī'lh ē najaxāuj macsti'na'j. Lhūhua' tachi'xcuhuī't ixtaquīlakla Jesús ē chuntza' ī'scujnu'nī'n jāla ixtahuā'yan. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tatojōlh a'ktin nac barco xmān xlaca'n ē ixta'a'mā'nalh jā jā tī ixa'nancan. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Lhūhua' tachi'xcuhuī't talaktzī'lh a'cxni' ixta'a'mā'nalh ē talakapasli. Xalanī'n ā'lacatunu' cā'lacchicni' catujan tatu'jnulh a'ntza' ē tachā'lh pūla. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","A'cxni' Jesús taxtulh nac barco, cālaktzī'lh lhūhua' tachi'xcuhuī't ē cālakalhu'manli ixpālacata tatasu'yulh hua'chi purecu' tū jā taka'lhī tī nacāmaktaka'lha. Tzuculh cāmāsu'yuni' lhūhua' catūhuālh. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","A'cxni' ī'smalanka'namā'lhtza', scujnu'nī'n talakmilh Jesús ē tahuanilh: ―Kōtanūtza' ē huā'tzā' jā nac cā'lacchicni'. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Cacāmacapi tachi'xcuhuī't nata'a'n natatamāhua ixlīhua'ca'n calhāhuālh jā yākō'lh chic ixpālacata jā taka'lhī tū natahua'. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesús cākelhtīlh: ―Hui'xina'n cacāmāhuī'tit. Tahuanilh: ―Lhūhua' tachi'xcuhuī't. Ixlacasqui'nca makās namakscujcan ē chuntza' tzē nalītamāhuacan pāntzīn tū na'iccāmāhuī'yāuj xlaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús cāhuanilh: ―¿Chī maclā't pāntzīn ka'lhī'yā'tit? Caquīlaktzī'ntit. Taquīlaktzī'lh ē a'cxni' taca'tzīlh, tahuanilh: ―Macquitzis pāntzīn ē tantu' squī'ti'. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Xla' cāmāpa'ksīlh ī'scujnu'nī'n: ―Cacāmāpitzitit ē xtum catatahuī'lh pūlacatunu' nac cā'seketni'. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ixuī'lh pūlacatunu' jā tatahuī'lh a'ktin cientu. Nā ixuī'lh ā'makapitzīn pūlacatunu' jā tatahuī'lh tu'pu'xamacāuj. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesús cātayalh macquitzis pāntzīn ē tantu' squī'ti' ē talacayāhualh nac a'kapūn ē maxquī'lh tapāxcatca'tzīn Dios. Cāche'keni'lh pāntzīn ē cāmaxquī'lh ī'scujnu'nī'n. Xlaca'n tamāpitzilh na ixpu'nanca'n tachi'xcuhuī't. Nā cāmāpitzini'lh tantu' squī'ti' ixlīpō'ktuca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tahua'lh ixlīpō'ktuca'n ē taka'sli. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","A'cxni' tahuā'yankō'lh, scujnu'nī'n tasacli xalacpītzun pāntzīn ē squī'ti'. Lītatzumalh pācāujtu' chā'xta tū quītāxtūni'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tī tahuā'yalh a'kquitzis mil chi'xcuhuī'n ixtahuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Palaj tunca Jesús cāhuanilh ī'scujnu'nī'n: ―Catojō'tit nac barco ē capūla'tit ixtuntacut nac mar nac Betsaida līhuan quit na'iccāmacā'n tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","A'cxni' ixcāmacā'nkō'nī'ttza', xla' tā'cxtunu'lh nac sipej na'orarlī. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","A'cxni' tā'cnūlh chi'chini', Jesús ixlīmān ixuī'lh nac ti'ya't līhuan ī'scujnu'nī'n ixta'a'mā'nalh nac barco ixpu'nan mar. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jesús laktzī'lh chī jāla ixa'n barco ixpālacata ixū'numā'lh. A'cxni' ī'xkakamā'lhtza', Jesús cālakmilh. Ixkelhtlā'huantēlha xcān ē ixcālaktalacatzuna'jīlh. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Xlaca'n talaktzī'lh ē tajicua'nli ē tata'salh. Ixlīpō'ktuca'n talaktzī'lh catīhuālh ixkelhtlā'huantēlha xcān ē tapuhuanli ixtalakachuyamā'nalh ē ū'tza' talījicua'nli. Palaj tunca Jesús cātā'chihuīna'nli xlaca'n ē cāhuanilh: ―Catahuixcānī'tit ē jā cajicua'ntit. Quit tī icmimā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tojōlh nac barco jā ixtahui'lāna'lh xlaca'n ē ca'cslalh ū'ni'. Xlaca'n talī'a'cnīlh. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Masqui ixtalaktzī'nī't chī Jesús mālhuhuīlh pāntzīn, jā ixta'a'ka'ī'ni'lh ixlītli'hui'qui Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","A'cxni' Jesús ē ī'scujnu'nī'n ta'a'lh ixtuntacut nac xcān, ē tachā'lh nac ti'ya't jā huanican Genesaret ē tachī'jūlh ixbarcoca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","A'cxni' tataxtulh nac barco, tachi'xcuhuī't talakapasli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Palaj ta'a'lh calhāxcuhuālh ē tzucuca cālīmincan ta'jatatlanī'n nac talajni'. Cālē'nca jā ixuī'lh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Calhāxcuhuālh Jesús tanūlh nac lacsti'na'j cā'lacchicni' ē nac xaka'tla' cā'lacchicni' ē masqui nac ranchuj, ixcāmāpī'can ta'jatatlanī'n nac talajni' ē ī'squi'ni'can xmān cacāmakxtekli nataxa'ma ixtampān ixlu'xu'. Ixlīpō'ktuca'n tī taxa'malh ixlu'xu' tatzeyankō'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Talaktalacatzuna'jīlh Jesús fariseos ē makapitzīn xamākelhtahua'kē'ni'nī'n līmāpa'ksīn xalanī'n nac Jerusalén tī ixtalakminī't Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ixtalaktzī'nī't makapitzīn ī'scujnu'nī'n Jesús tī ixtahuā'yamā'nalh ē jā pūla ixtamakacha'ka'nī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Jā chuntza' ixtatlahua fariseos ē ixlīpō'ktuca'n ā'makapitzīn israelitas. Palh xlaca'n jā pūla ixtamakacha'ka'n chuntza' chī ixlacasqui'nca, jā ixtahuā'yan ixpālacata ixtalakachi'xcuhuī' ixtahui'latca'n ī'xū'nāpapca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","A'cxni' ixtaquītaspi'ta nac lītamāuj, jā ixtahuā'yan palh jā tzej ixtamakacha'ka'n pūla. Ixtamākentaxtū lhūhua' ixtahui'latca'n ī'xū'nāpapca'n hua'chi chī talīpūche'kē' vasos ē tla'ma'nc ē tamacatzucun līcā'n ē ixpūtama'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Takelhasqui'nīlh Jesús fariseos ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn: ―¿Tū ixpālacata miscujnu'nī'n jā tamākentaxtū tū quixū'nāpapca'n quincātamāsu'yuni'n? Tahuā'yan ē jā pūla tamakacha'ka'n chī ixlacasqui'nca. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús cākelhtīlh: ―Hui'xina'n tlahua'yā'tit a'ktu' milacanca'n. Mimpālacataca'n lītzo'kli profeta Isaías jā tatzo'kni': Tzamā' tachi'xcuhuī't xmān tahuan quintalakachi'xcuhuī'. Jā talacapāstaca tū iccālīmāpa'ksīlh. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Jā tū līmacuan chī quintalaktaquilhpūta. Tū tamāsu'yu, ū'tza' xmān ixtalacapāstacni'ca'n chi'xcuhuī'n. Chuntza' tzo'kli Isaías. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jesús cāhuanipālh: ―Hui'xina'n mākēnū'yā'tit ixlīmāpa'ksīn Dios ē mākentaxtūyā'tit ixtahui'latca'n mixū'nāpapca'n. Hui'xina'n pūche'kē'yā'tit tla'ma'nc ē vasos chī ixlacasqui'nca ē tlahua'yā'tit lhūhua' ā'makapitzīn tahui'lat. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nā cāhuanilh: ―Puhua'nā'tit tze chī mākēnū'yā'tit ixlīmāpa'ksīn Dios ē mākentaxtūyā'tit mintahui'latca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","A'ntza' jā tzo'kli Moisés, chuntza' huanli: Cacālakachi'xcuhuī' mintāta' ē mintzī'. Moisés nā huanli: Camāmaknīnīnca tī cachīhuālh huani ixtāta' o ixtzī'. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Hui'xina'n xtum hua'nā'tit. Māsu'yu'yā'tit palh chā'tin chi'xcu' tzē nahuani ixtāta' o ixtzī': “Jāla icmaktāyayān ixpālacata ixlīpō'ktu tū icka'lhī, ū'tza' Corbán.” (Huā'mā' tachihuīn huanicu'tun: icmālacnūni'nī'ttza' Dios.) ");
INSERT INTO tkuNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Chuntza' jā makxtekā'tit nacāmaktāya ixtāta' ē ixtzī'. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Hui'xina'n mākēnū'yā'tit ixlīmāpa'ksīn Dios ixpālacata māsu'yu'yā'tit ixlacasqui'nca namākentaxtūcan ixtahui'latca'n mixū'nāpapca'n. Lhūhua' tū tlahua'yā'tit hua'chi tzamā' ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesús cāmāta'satīnīni'lh tachi'xcuhuī't ē cāhuanilh: ―Caquilākexmatni'uj milīpō'ktuca'n ē caca'tzītit. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Jā tū a'nan tū naquilhtanū chi'xcu' hua'chi līhua' ē chuntza' nalīka'lhī ixcuenta. Tū naquilhtaxtu chā'tin chi'xcu' tū jā tze tachihuīn, ū'tza' nalīka'lhī ixcuenta. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Cuenta catlahua'tit tū kexpa'tā'tit ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","A'cxni' Jesús ixtanūnī't nac chic, jātza' ixa'nan lhūhua' tachi'xcuhuī't. Ī'scujnu'nī'n takelhasqui'nīlh tūchu ixuanicu'tun tū līca'tzīni'can. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesús cāhuanilh: ―Nā hui'xina'n ¿ē jā kexpa'tā'tit? Ca'tzīyā'tit catūxcuhuālh tū naquilhtanū chā'tin chi'xcu', ū'tza' jā catilactlahualh. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ū'tza' xmān tajō na ixpān ē chuntza' taxtu. Jā catitanūlh na ixtalacapāstacni'. Chuntza' līmāsu'yulh pō'ktu tze tū hua'yāuj. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jesús chihuīna'mpālh: ―Tū quilhtaxtu chā'tin chi'xcu', ū'tza' nalactlahua. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Palh jā tze ixtalacapāstacni' chā'tin chi'xcu', xla' napuhuan tū jā tze. Ū'tza' nalīka'lhīcu'tun ixtā'lāpāxquī'n ē nalītlahua tū jā tze ē nalīmaknīni'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Naka'lhāna'n ē naka'lhīcu'tun tū ixla' ā'chā'tin ē natlahua tū jā tze. Natampi'lhīni'n ē na'a'kskāhuī'nin ē natlahua tū jā tze ē nalakca'tzāna'n ē na'a'ksa'nini'n ē ka'tla' namakca'tzī ē jā tze ixtalacapāstacni' naka'lhī. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Pō'ktu tzamā' tū jā tze ē tamātlahuī jā tze chā'tin chi'xcu'. Nā tzamā' tataxtu na ixpūlacni' chā'tin chi'xcu' ixpālacata jā tze ixtalacapāstacni' ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","A'cxni' Jesús huankō'lh, xla' taxtulh ē a'lh ā'lacatin jā tahui'lāna'lh a'ktu' cā'lacchicni' tū huanican Tiro ē Sidón. Tanūlh a'ktin nac chic. Masqui ixlacasqui'n jā tī chā'tin ixca'tzīlh ixuī'lh a'ntza', jāla tatzē'kli. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Palaj tunca milh chā'tin puscāt. Ixtzu'ma'jāt puscāt ixka'lhī jā tzeya ū'ni'. Māca'tzīnīca a'cxni' chilh Jesús ē lakmilh ē tatzokostani'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Puscāt jā israelita ixuanī't; xla' sirofenicia ixuanī't. Ī'squi'ni' talakalhu'mān camāxtuni'lh ixtzu'ma'jāt jā tzeya ū'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesús huanilh: ―Pūla cataka'sli lacstīn. Jā minī'ni' maktīcan ixpāntzīnca'n lacstīn ē nacāmaxquī'can chichī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Puscāt kelhtīlh: ―Ixlīcāna', Māpa'ksīni'. Masqui icca'tzītza', chichī'n tzē tasacua' tū tamakā'n lacstīn na ixtampīn mesa. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Palaj tunca Jesús huanilh: ―Tze chī hua'na'. Tzētza' napina' na minchic. Jā tzeya ū'ni' taxtuni'nī'ttza' mintzu'ma'jāt. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Puscāt a'lh na ixchic. Ixtzu'ma'jāt ixmā'lh nac tama' ē ixtasu'yu ixtaxtuni'nī'ttza' jā tzeya ū'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús taxtulh nac cā'lacchicni' tū huanican Tiro ē tētaxtulh nac Sidón ē jā ixmāpa'ksī Decápolis. Taspi'tli nac mar tū huanican Galilea. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Līmini'ca chā'tin chi'xcu' tī jā ixa'kahuāna'n ē kō'ko' ixuanī't. Squi'ni'ca caxa'malh. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesús lē'lh chi'xcu' lacapunchuna'j jā jā ixtatakēstoka tachi'xcuhuī't ē mānūni'lh ixmakaspulh na ixa'ka'xko'lh. Chojmanīlh ixmacan ē nā xa'malh na ī'sī'makā't chi'xcu'. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jesús talacayāhualh nac a'kapūn. Jaxapānīlh ē huanli: ―¡Efata! (Huā'mā' tachihuīn huanicu'tun: ¡Catalaquī'lh!) ");
INSERT INTO tkuNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Palaj tunca tatzeyalh ixa'ka'chakān chi'xcu' ē kexmatli. Tzeyanli ī'sī'makā't ē tzētza' ixchihuīna'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesús lacatejtin cāhuanilh tachi'xcuhuī't: ―Jā tī chā'tin tihua'ni'yā'tit. Jā takexmatni'lh, ē ā'chulā' tamāca'tzīnīni'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Xlaca'n tī cāmāca'tzīnīca ixtalī'a'cnī ē tahuanli: ―Pō'ktu tū tlahuanī't, pō'ktu tze. Ū'tza' cāmā'a'kahuanī tī a'katāp ē cāmāchihuīnī tī kō'ko'. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tzamā' quilhtamacuj ixtatakēstoknī't tachi'xcuhuī't ē jā tū ixa'nan tū natahua'. Jesús cāta'sani'lh ī'scujnu'nī'n ē cāhuanilh: ");
INSERT INTO tkuNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Iccālakalhu'man tachi'xcuhuī't. Tu'tuma'jtza' quintatā'lahui'lāna'lh huā'tzā' ē jātza' taka'lhī tū tahua'. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Palh xa'iccāmacā'lh na ixchicca'n ē jā tahuā'yanī't, ixtaxlajua'nalh nac tej ē jā ixtatāyani'lh. Makapitzīn xlaca'n taminī'ta'ncha' makat. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ī'scujnu'nī'n takelhtīlh: ―¿Chī nacālīmāhuī'yāuj tachi'xcuhuī't huā'tzā' jā jā tī huī'lh? ");
INSERT INTO tkuNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Xla' cākelhasqui'nīlh: ―¿Chī maclā't pāntzīn ka'lhī'yā'tit? Xlaca'n takelhtīlh: ―Mactojon. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Palaj tunca Jesús māpa'ksīlh catatahui'lalh tachi'xcuhuī't nac ti'ya't. Cātayalh mactojon pāntzīn ē maxquī'lh tapāxcatca'tzīn Dios. Cāmāpitzini'lh ē cāmaxquī'lh ī'scujnu'nī'n natamāpitzi tachi'xcuhuī't. Chuntza' tatlahualh. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nā ixtaka'lhī makapitzīn xalacstīn squī'ti' ē Jesús maxquī'lh tapāxcatca'tzīn Dios ixpālacata squī'ti'. Cāhuanilh ī'scujnu'nī'n: ―Cacāmāpitzini'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ixlīpō'ktuca'n tahuā'yalh ē talīka'sli. Tamākēstokli xalacpītzun tū quītāxtūlh ē tamātzumalh pātojon chā'xta. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tī tahuā'yalh hua'chi a'ktā'ti' mil ixtahuanī't. Jesús cāmacā'lh tachi'xcuhuī't na ixchicca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Palaj tunca xla' ē ī'scujnu'nī'n tatojōlh nac barco ē tachā'lh jā ixmāpa'ksī cā'lacchicni' Dalmanuta. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fariseos talakmilh ē tatzuculh tatā'lāhuani Jesús. Tasqui'nli a'ktin lī'a'cnīn tū nalītasu'yu xla' xala' nac a'kapūn. Tasqui'nli ixpālacata xmān ixtalīlaktzī'ncu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús cājiclhuanini'lh ē huanli: ―¿Tū ixpālacata tachi'xcuhuī't tasqui'n lī'a'cnīn? Ixlīcāna' tū iccāhuaniyān. Hui'xina'n tī hui'lāna'ntit chuhua'j jā caticātamāsu'yuni'n lī'a'cnīn. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Cāmakxtekli ē tojōpālh nac barco ē a'lh ixtuntacut nac xcān. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Xmān mactin ixuī'lh pāntzīn nac barco ixpālacata ixtapātza'nkānī't ē jā talē'lh pāntzīn. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesús cāmaxquī'lh talacapāstacni' ē cāhuanilh: ―Cuenta catlahua'tit ē camaktaka'lhtit ixlevaduraca'n fariseos ē Herodes. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Scujnu'nī'n talātā'chihuīna'nli ē talāhuanilh: ―Chuntza' huanli ixpālacata jā līmiuj pāntzīn. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús ixca'tzī tū ixtalāhuanimā'nalh. Ū'tza' līca'tzīlh jā ixtakexmata xla' ixlīchihuīna'mā'lh ixtamāsu'yun fariseos. Ū'tza' cālīhuanilh ī'scujnu'nī'n: ―¿Tū ixpālacata lī'a'ktuyunā'tit pāntzīn tū jā līta'ntit? ¿Jā cuenta tlahua'yā'tit nūn kexpa'tā'tit? ¿Jā ka'lhī'yā'tit milīstacna'ca'n nalīlacapāstacna'nā'tit? ");
INSERT INTO tkuNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ka'lhī'yā'tit milakastapunca'n. ¿Ē jā laktzī'nā'tit? Ka'lhī'yā'tit mina'ka'xko'lhca'n. ¿Ē jā a'kahuā'na'nā'tit? ¿Ē jāla lacapāstacna'nā'tit? ");
INSERT INTO tkuNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","A'cxni' iccāche'kelh macquitzis pāntzīn ē ū'tza' iccālīmāhuī'lh a'kquitzis mil chi'xcuhuī'n, ¿chī pālā't chā'xta mātzuma'tit xalacpītzun tū mākēstoktit? Xlaca'n takelhtīlh: ―Pācāujtu'. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Xla' huanli: ―A'cxni' iccāche'kelh mactojon pāntzīn ē ū'tza' iccālīmāhuī'lh a'ktā'ti' mil, ¿chī pālā't chā'xta mātzuma'tit xalacpītzun tū mākēstoktit? Xlaca'n takelhtīlh: ―Pātojon. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Cāhuanilh: ―¿Ē jāna'j kexpa'tā'tit? ");
INSERT INTO tkuNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesús ē ī'scujnu'nī'n tachā'lh nac cā'lacchicni' tū huanican Betsaida ē līmini'ca Jesús chā'tin lakatzī'n ē squi'ni'ca caxa'malh. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Makachi'palh ē pekechi'palē'lh lakatzī'n na ixquilhtūn cā'lacchicni'. Chojmanīlh ixlakastapun ē xa'mani'lh na ixlakastapun ē kelhasqui'nīlh: ―¿Tū la'ktzī'na'? ");
INSERT INTO tkuNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Xla' lacahuāna'nli ē huanli: ―Iccālaktzī'n chi'xcuhuī'n tī talatlā'huan. Tatasu'yu hua'chi xalaka'tla' qui'hui'. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Palaj tunca xa'mani'pālh na ixlakastapun. Chi'xcu' lacahuāna'mpālh ē tzeyanli ē lacahuāna'nkō'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesús huanilh: ―Lacatzaj capit na minchic ē jā titētanū'ya' nac cā'lacchicni'. Jā tī chā'tin tihuani'ya' xalanī'n nac cā'lacchicni' chī lītzeya'nti. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesús ē ī'scujnu'nī'n ta'a'lh nac ā'makapitzīn cā'lacchicni' a'ntza' jā huanican Cesarea Filipo. Līhuan ixta'a'mā'nalh, xla' cākelhasqui'nīlh ī'scujnu'nī'n: ―Tachi'xcuhuī't, ¿chī tahuan quimpālacata? ");
INSERT INTO tkuNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Xlaca'n takelhtīni'lh: ―Makapitzīn tahuan palh hui'x Juan Mā'kpaxīni' ē ā'makapitzīn tahuan palh hui'x Elías ē ā'makapitzīn huampala tahuan palh hui'x palhāsā' chā'tin a'kchihuīna'. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Palaj tunca cāhuanilh: ―Ē hui'xina'n, ¿chī hua'nā'tit tīchu quit? Pedro kelhtīni'lh: ―Hui'x Cristo tī xa'icka'lhīmā'nauj. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Cāmāpa'ksīlh jā catitahuanilh nūn tī chā'tin palh ū'tza' Cristo tī ixka'lhīmā'ca. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesús tzuculh cāmāsu'yuni' chuntza': ―Quit Chi'xcu' xala' Tālhmā'n ē ixlacasqui'nca naquimakapātīnīncan. Xanapuxcu'nu' israelitas ē xanapuxcu'nu' pālejni' ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn, xlaca'n naquintalakmaka'n ē naquintamaknī. Ixlī'a'ktu'tun quilhtamacuj na'iclacastālancuana'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Lacatejtin huanli huā'mā' tachihuīn. Palaj tunca Pedro lē'lh lacapunchuna'j ē tzē'k huanilh jā cahualh chuntza'. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesús cālaktalakspi'tli ē cālaktzī'lh ī'scujnu'nī'n ē lacaquilhnīlh Pedro ē huanilh: ―Catakēnu'. Hui'x lacapāstacna'na' chuntza' chī skāhuī'ni'. Jā ka'lhī'ya' ixtalacapāstacni' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jesús cāta'sani'lh tachi'xcuhuī't ē ī'scujnu'nī'n ē cāhuanilh: ―Palh catīxcuhuālh quintā'tapa'ksīcu'tun quit, jātza' la catilacapāstacli xmān tū ū'tza' lacasqui'n. Calīhui'līlh natlahua quintalacasqui'nīn masqui capātīni'lh chuntza' chī quit na'icpātīni'n ē caquistālani'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tī ta'a'kapūtaxtucu'tun tū natalīpātīni'n quimpālacata, jā catitaka'lhīlh ixlatamatca'n tū jā catilaksputli. Tī natapātīni'n masqui natanī quimpālacata ē ixpālacata xatze tachihuīn, xlaca'n nataka'lhī ixlatamatca'n tū jā catilaksputli. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Palh chā'tin chi'xcu' ixtlajakō'lh ixlīpō'ktu xala' nac cā'quilhtamacuj, jā tū līmacuan palh jā ka'lhī ixlatamat tū jā catilaksputli. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Jā tū a'nan tū xla' tzē namāstā' ē chuntza' nalīka'lhī ixlatamat tū jā catilaksputli. ");
INSERT INTO tkuNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tachi'xcuhuī't tī tahui'lāna'lh chuhua'j taputza ā'xtum dios. Palh catīxcuhuālh hui'xina'n nalīmāxana'nā'tit na ixlacatīnca'n tachi'xcuhuī't ē nalīmāxana'nā'tit quimpālacata ē ixpālacata tū icmāsu'yu, ū'tza' na'iclīmāxana'n a'cxni' na'icmimpala. Quit Chi'xcu' xala' Tālhmā'n ē na'icka'lhī ixlītli'hui'qui quinTāta' Dios ē naquintatā'min ixángeles tī xalactze. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús cāhuanipālh: ―Ixlīcāna' tū iccāhuaniyān. Makapitzīn tī tahui'lāna'lh huā'tzā' chuhua'j ē xlaca'n jā catitanīlh a'cxni' jāna'j natalaktzī'n ixlīmāpa'ksīn Dios ē chī namāpa'ksīni'nkō'. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ixlīlakachāxan quilhtamacuj Jesús cālē'lh Pedro ē Jacobo ē Juan ē tatā'a'lh. Xmān ixkelhatā'ti'ca'n ta'a'lh nac a'ktin sipej tālhmā'n ē tatā'cxtulh. A'ntza' talakpalīlh Jesús ē xtum ixtasu'yu na ixlacatīnca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ixlu'xu' xkakalh ē stala'nka' huanli hasta ixlīlakachi'xua'nancan. Jā tū a'nan nac cā'ti'ya'tna' tū mālakchā'nī chī ixlīstala'nka'. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Cātasu'yuni'lh Elías ē Moisés ē ixtatā'chihuīna'mā'nalh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedro huanilh Jesús: ―Mākelhtahua'kē'ni', xalītze hui'lāna'uj huā'tzā'. Na'icyāhuayāuj huā'tzā' a'ktu'tun mū'xta'ka'; a'ktin mila' nahuan ē a'ktin ixla' Moisés ē a'ktin ixla' Elías. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Chuntza' huanli Pedro ixpālacata jā ixca'tzī chī nahuan ē ixkelhatu'tunca'n tajicua'nli. Ū'tza' līhuanli chuntza'. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Palaj tunca milh a'ktin poklhnu' ē cālītamacsti'li'lh. Takexmatli a'ktin tachihuīn nac poklhnu' ē huanli: ―Ū'tza' huā'mā' quiSka'ta' ē icpāxquī'. Cakexpa'ttit tū huan. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Palaj tunca talacaputzalh ē nūn chā'tin ixa'nan; xmān Jesús ixlīmān talaktzī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","A'cxni' ixtayujmā'nalh nac sipej, Jesús cāmāpa'ksīlh ē cāhuanilh: ―Jā tī chā'tin tihua'ni'yā'tit tū laktzī'nī'ta'ntit. Jā catihua'ntit hasta a'cxni' Chi'xcu' xala' Tālhmā'n nalacastālancuana'n na ixlacpu'na'i'tātca'n nīnī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tzē'k taca'tzīlh huā'mā' tachihuīn ē ixtalākelhasqui'nīmā'nalh: ―¿Tū huanicu'tun tzamā' lacastālancuana'ncan na ixlacpu'na'i'tātca'n nīnī'n? ");
INSERT INTO tkuNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Takelhasqui'nīlh Jesús: ―¿Tū ixpālacata tahuan xamākelhtahua'kē'ni'nī'n līmāpa'ksīn palh ixlacasqui'nca xapūla namin Elías ē ā'līstān namin Cristo tī Dios lacsacnī't? ");
INSERT INTO tkuNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesús cākelhtīlh: ―Ixlīcāna' huā'mā'. Pūla namin Elías ē nacāxtlahuakō' ixlīpō'ktu. ¿Ē jā tatzo'kni' ixpālacata Chi'xcu' xala' Tālhmā'n napātīni'n lhūhua' ē nalakmaka'ncan? ");
INSERT INTO tkuNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Quit iccāhuaniyān milhtza' tī huanican Elías ē makapitzīn chi'xcuhuī'n tatlahuani'lh chuntza' chī ixtalacasqui'n. A'kspulalh chuntza' chī tatzo'kni' ixpālacata xla'. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","A'cxni' ixkelhatā'ti'ca'n tachā'lh jā ixtahui'lāna'lh ā'makapitzīn scujnu'nī'n, talaktzī'lh chī lhūhua' tachi'xcuhuī't ixtalītamacsti'li'nī't. Xamākelhtahua'kē'ni'nī'n līmāpa'ksīn ixtatā'lāhuanimā'nalh scujnu'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","A'cxni' tachi'xcuhuī't talaktzī'lh Jesús, talī'a'cnīlh ē palaj tunca talaktu'jnulh ē tatā'chihuīna'nli. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesús cākelhasqui'nīlh: ―¿Tū līchihuīna'mpā'na'ntit? ");
INSERT INTO tkuNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kelhtīlh chā'tin na ixlacpu'na'i'tātca'n ē huanli: ―Mākelhtahua'kē'ni', iclīmini'n quinka'hua'cha. Ka'lhī jā tzeya ū'ni' tū makakō'ko'nī. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Calhāxcuhuālh chi'pa ē a'ntza' māmakahuasī nac ti'ya't ē tzucu kelhpupu ē lāxcakō' ixtatzan ē lhtuncu lakō'. Iccāsqui'ni'lhtza' miscujnu'nī'n catamāxtuni'lh. Xlaca'n jāla tamāxtuni'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús cāhuanilh: ―Hui'xina'n jā tzej a'ka'ī'yā'tit. ¿Hasta jā'cxni' na'iccātā'tahui'layān hui'xina'n ē jā nakexpa'tā'tit? ¿Hasta jā'cxni' na'iccātāyani'yān hui'xina'n chī hui'lāna'ntit? Caquilī'ta'ni' ka'hua'cha. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Talīmini'lh ē a'cxni' laktzī'lh Jesús, jā tzeya ū'ni' makapaxnīni'n ka'hua'cha ē a'kā'lh nac ti'ya't ē tapi'li'lh ē kelhpupulh. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús kelhasqui'nīlh ixtāta' ka'hua'cha: ―¿Chī a'klā't cā'ta ka'lhī huā'mā' ta'jatat? Ixtāta' kelhtīni'lh: ―Hasta ixlīska'ta tzucunī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Maklhūhua' a'cchichintapūlh nac macscut ē nac xcān. Ixmaknīcu'tun. Palh tzē natlahua'ya' catūhuālh, caquilālakalhu'mauj quina'n ē caquilāmaktāyauj. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús huanilh: ―¿Tū ixpālacata quihua'ni': “Palh tzē natlahua'ya' catūhuālh?” Palh hui'x a'ka'ī'ni'ya' Dios ē līpāhua'na' Dios, chuntza' tzē na'iclītlahuani'yān catūxcuhuālh. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Palaj tunca ixtāta' ka'hua'cha ta'salh ē huanli: ―Quit ica'ka'ī'. Caquimaktāya' ixpālacata quisputni'cus chī tzej na'ica'ka'ī'. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","A'cxni' Jesús cuenta tlahualh chī ixtatu'jnun talakmilh ixtalaktakēstokmā'nalh, xla' lacaquilhnīlh jā tzeya ū'ni' ē huanilh: ―Icmāpa'ksīyān hui'x tī makā'katāpanī'ta' ē makakō'ko'nī'ta' ka'hua'cha. Icmāpa'ksīyān cataxtu xla' ē jā makstin titanūpala'ya' na ixpūlacni'. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jā tzeya ū'ni' ta'salh ē makapaxnīni'lh ka'hua'cha ē taxtulh. Ka'hua'cha ixtasu'yu hua'chi xanīn ixuanī't. Ū'tza' lhūhua' talīhualh ixpālacata ka'hua'cha: ―Nīlhtza'. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesús makachi'palh ē maktāyalh ē ka'hua'cha tā'kaquī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","A'cxni' Jesús ē ī'scujnu'nī'n tatanūlh nac chic, ē ixlīmānca'n ixtahui'lāna'lh ē takelhasqui'nīlh: ―¿Tū ixpālacata quina'n jāla icmāxtuni'uj ka'hua'cha jā tzeya ū'ni'? ");
INSERT INTO tkuNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Cāhuanilh: ―Jā tzeya ū'ni' hua'chi huā'mā' xmān tzē māxtucan palh natlahua'yā'tit oración ē palh nalīhui'lī'yā'tit jā nahuā'ya'nā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Tataxtulh a'ntza' ē ta'a'lh ē ixtalatlā'huan nac estado Galilea. Jesús jā ixlacasqui'n naca'tzīcan ixuī'lh a'ntza' ");
INSERT INTO tkuNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ixpālacata ixcāmāsu'yuni'mā'lh ī'scujnu'nī'n. Ixcāhuani: ―Quit Chi'xcu' xala' Tālhmā'n, ē naquilīmacamāstā'can na ixmacanca'n chi'xcuhuī'n. Xlaca'n naquintamaknī ē ixlī'a'ktu'tun quilhtamacuj na'iclacastālancuana'n ―cāhuanilh. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Xlaca'n jā taca'tzīlh tū huanicu'tun ē jā ixtakelhasqui'nīcu'tun ixpālacata ixtajicua'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tachā'lh nac cā'lacchicni' jā huanican Capernaum. A'cxni' tatanūlhtza' nac chic, Jesús cākelhasqui'nīlh: ―¿Tū ixlālīquilhnīpā'nantit a'cxni' ixta'mpā'na'ntit nac tej? ");
INSERT INTO tkuNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Xlaca'n taquilhca'cslalh ixpālacata līhuan ixtatlā'huamā'nalh nac tej, ixtalālīquilhnīmā'nalh ixpālacata tīchu xlaca'n ā'chulā' ixlacasqui'nca na ixlacpu'na'i'tātca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesús tahuī'lh ē cāta'sani'lh ixkelhacāujtu'ca'n ē cāhuanilh: ―Palh catīhuālh lacu'tun xapuxcu' hui'xina'n, calalh hua'chi ixtasācua'ca'n ā'makapitzīn ē calalh hua'chi xastancu. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Makachi'palh chā'tin macsti'na'j ka'hua'cha ē yāhualh na ixlacpu'na'i'tātca'n. Cha'xli ē cāhuanilh: ");
INSERT INTO tkuNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Catīxcuhuālh tī quintā'tapa'ksī quit ē ū'tza' nalīpāxquī' chā'tin macsti'na'j ka'hua'cha hua'chi huā'yālh, ū'tza' lacxtim hua'chi quit quimpāxquī'. Catīxcuhuālh tī quimpāxquī' quit, nā pāxquī' tī quimacamilh ē jā xmān quit. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juan huanilh: ―Mākelhtahua'kē'ni', iclaktzī'nī'tauj chā'tin chi'xcu' tī ixmāpācuhuī mintacuhuīni' ē ū'tza' ixcālīmaxtumā'lh jā tzeya ū'nī'n. Icuaninī'tauj jātza' catlahualh chuntza' ixpālacata xla' jā quincātā'latlā'huanān quina'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesús huanli: ―Camakxtektit ē jā timāmakchuyīyā'tit. Jā tī chā'tin tī natlahua lī'a'cnīn a'cxni' namāpācuhuī quintacuhuīni' ē palaj tunca tzē naquilakapala. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tī jā quinquiclhlaktzi'n, ū'tza' quincāmaktāyayān. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ixlīcāna' tū iccāhuaniyān: catīxcuhuālh tī nacātā'hua'yān xcān ixpālacata hui'xina'n tapa'ksīni'yā'tit Cristo, ū'tza' naxokonu'ni'can. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jesús chihuīna'mpālh: ―Palh catīhuālh chihuīna'makasītzī' chā'tin macsti'na'j ka'hua'cha tī quina'ka'ī'ni' ē chuntza' ka'hua'cha nalītlahua tū jā tze, huā'mā' chi'xcu' jā tze. Ā'chulā' xatze ixpixchī'hua'ca'ca a'ktin ka'tla' chihuix ē ixmojōca nac mar najicsua' ē jā ixa'kskāhuī'lh ka'hua'cha. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","’Jā tze palh mimacan nalītlahua'yā'tit tū jā tze. Xalītze macastuntu'lu' ixuantit ē ixka'lhī'tit milatamatca'n tū jā catilaksputli. Jā tze palh ka'lhī'yā'tit kentu' mimacanca'n tū lītlahua'yā'tit tū jā tze ē ū'tza' nacātalīmacā'nān hui'xina'n nac pūpātīn. A'ntza' macscut jā makstin catimixli. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","A'ntza' xtokonu'lūhua' jā maktin catihua'kō'lh xamasni' ixquinītca'n tī natapātīni'n ē jā catimixli macscut. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","’Jā tze palh mintujanca'n nalītlahua'yā'tit tū jā tze. Xatze palh tantustuntu'lu' ixuantit ē ixka'lhī'tit milatamatca'n tū jā catilaksputli. Jā tze palh ka'lhī'yā'tit kentu' mintujanca'n tū lītlahua'yā'tit tū jā tze ē ū'tza' nacātalīmacā'nān hui'xina'n nac pūpātīn. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","A'ntza' xtokonu'lūhua' jā maktin catihua'kō'lh xamasni' ixquinītca'n tī natapātīni'n ē jā catimixli macscut. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","’Jā tze palh tlahua'cu'tunā'tit tū jā tze ixpālacata catūhuālh tū talaktzī'n milakastapunca'n. Xatze lakakentin ixuantit ē ixka'lhī'tit milatamatca'n tū jā catilaksputli. Jā tze palh ka'lhī'yā'tit a'ktu' milakastapunca'n tū nacāmātlahuīyān tū jā tze ē ū'tza' nacātalīmacā'nān hui'xina'n nac pūpātīn. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","A'ntza' xtokonu'lūhua' jā maktin catitahua'kō'lh xamasni' ixquinītca'n tī natapātīni'n ē jā catimixli macscut. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Ixlacasqui'nca ixlīpō'ktuca'n natapātīni'n ixpālacata ā'chulā' tze natala. Ū'tza' hua'chi macscut ē ixlacasqui'nca chuntza' chī līhua' maclacasqui'n matzat. Tū lakahui'līcan Dios, pō'ktu nalīmāsko'kō'can matzat. ");
INSERT INTO tkuNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Masqui matzat tze, palh matzat jātza' sko'ko'xnin, ¿chī nalīmāsko'kō'nuncan? Caka'lhī'tit hua'chi matzat na milatamatca'n. Tzej nalatahui'la'yā'tit ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús taxtulh nac Capernaum ē a'lh nac ti'ya't jā huanican Judea. Ē nā a'lh nac ti'ya't tū hui'lacha' ixtuntacut nac xcān Jordán. Tatzucupālh tatakēstoka tachi'xcuhuī't. Jesús tzucupālh cāmāsu'yuni' chuntza' chī ixlīsmanīnī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Talaktalacatzuna'jīlh Jesús makapitzīn fariseos. Ixtalīlaktzī'ncu'tun ē ū'tza' talīkelhasqui'nīlh: ―¿Ē tzē namakxtekcan quimpuscātca'n ē xapacan ixtacuhuīni'? ");
INSERT INTO tkuNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesús cākelhtīlh: ―¿Chī cāmāpa'ksīn Moisés jā tatzo'kni' nac līmāpa'ksīn? ");
INSERT INTO tkuNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Xlaca'n tahuanilh: ―Moisés huanli: “Tzē tzo'kcan a'ktin ca'psnap ē chuntza' tzē namakxteka' mimpuscāt.” ");
INSERT INTO tkuNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesús cāhuanilh: ―Xalīlacxumpīn hui'xina'n ē jā tze mintalacapāstacni'ca'n. Ū'tza' lītzo'kli Moisés huā'mā' līmāpa'ksīn. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","A'cxni' ixlītzucuni' cā'quilhtamacuj, tatzo'kni' chuntza': Dios tlahualh chi'xcu' ē puscāt. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ū'tza' nacālīmakxteka ixtāta' ē ixtzī' chā'tin chi'xcu' ē natā'talacxtimī ixpuscāt. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ixchā'tu'ca'n hua'chi xmān chā'tin natalītaxtu. Chuntza' tatzo'kni'. Chuntza' jātza' chā'tu' xlaca'n; xmān chā'tin. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Chuntza' jā minī'ni' chi'xcuhuī'n nalāmāmakxtekē tū Dios cātlahuanī't tzaj chā'tin. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","A'cxni' tatanūpālh nac chic, takelhasqui'nīlh ī'scujnu'nī'n ixpālacata tū huanli. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús cāhuanilh: ―Catīxcuhuālh tī namakxteka ixpuscāt ē palh natā'tamakaxtoka ā'chā'tin puscāt, huā'mā' chi'xcu' ka'lhī ixtā'lāpāxquī'n. Chuntza' tlahua tū jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Palh chā'tin puscāt namakxteka ixkōlu' ē natā'tamakaxtoka ā'chā'tin chi'xcu', chuntza' huā'mā' puscāt naka'lhī ixtā'lāpāxquī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Cālīmini'ca Jesús lacstīn nacā'li'ā'cpūxa'ma ixmacan. Ī'scujnu'nī'n tatzuculh talacaquilhnī tī ixtalīmin. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","A'cxni' Jesús ca'tzīlh tū ixtatlahuamā'nalh, xacā'lh ē cāhuanilh ī'scujnu'nī'n: ―Cacāmakxtektit caquintalakmilh lacstīn ē jā cacāmāmakchuyī'tit. Tī natā'tapa'ksī Dios a'ntza' jā māpa'ksīni'nkō', xlaca'n tī naquintalīpāhuan chuntza' chī tzamā' lacstīn. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ixlīcāna' iccāhuaniyān tī jā ta'a'ka'ī' chuntza' chī lacstīn ta'a'ka'ī', jā maktin catitatanūlh jā māpa'ksīni'nkō' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jesús cācha'xli lacstīn ē cālīcucslutli ixmacan ē cāsicua'lanātlahualh. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesús a'mpālh, ē ixtlā'huamā'lh nac tej. Laktu'jnulh chā'tin chi'xcu' ē tatzokostani'lh Jesús ē kelhasqui'nīlh: ―Tzeya Mākelhtahua'kē'ni' hui'x. ¿Tūchu na'ictlahua na'iclīka'lhī quilatamat tū jā catilaksputli? ");
INSERT INTO tkuNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús huanilh: ―¿Tū ixpālacata quihua'ni'ya' tze quit? Xmān chā'tin tī tze ē ū'tza' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Hui'x ca'tzīya' ixlīmāpa'ksīn Dios chuntza' huan: Jā tika'lhī'ya' mintā'lāpāxquī'n. Jā timaknīni'na'. Jā tika'lhāna'na'. Jā tilīchihuīna'na' ā'chā'tin tū jā ixlīcāna'. Jā ti'a'kskāhuī'maktīya' catūhuālh. Cacālakachi'xcuhui' mintāta' ē mintzī'. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Xla' kelhtīlh: ―Mākelhtahua'kē'ni', pō'ktu tzamā' icmākentaxtūkō'nī'ttza' hasta quilīska'ta'. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Palaj tunca Jesús laktzī'lh ē pāxquī'lh ē huanilh: ―Ā'xmān a'ktin tisputni'yān tū natlahua'ya'. Caquīstā'kō'j pō'ktu tū ka'lhī'ya' ē nacāmāpitzi'ni'ya' tumīn xcamanīnī'n ē naka'lhī'ya' chī rico nalīhua'na' nac a'kapūn. Ā'līstān naquintā'pina', masqui napātīni'na'. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","A'cxni' chi'xcu' kexmatli huā'mā' tachihuīn, līlīpuhuanli ē a'lh ixpālacata rico ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesús calhāxcuhuālh cālaktzī'lh tachi'xcuhuī't ē cāhuanilh ī'scujnu'nī'n: ―Xlaca'n tī lacricujnu' jicslīhua' natatamakxteka Dios nacāmāpa'ksī. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ī'scujnu'nī'n talī'a'cnīlh ixtachihuīn. Jesús cāhuanipālh: ―Quinamigos, iccāhuaniyān xlaca'n tī talīpāhuan ixtumīnca'n, jicslīhua' natatā'tapa'ksī Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Jicslīhua' nalīpātle'kecu'tun a'ktin camello na ixtani' līxtokon. Ā'chulā' jicslīhua' natanū chā'tin rico jā namāpa'ksīni'nkō' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Xlaca'n lhūhua' talī'a'cnīlh ē talāhuanilh: ―¿Tīchu tzē namakapūtaxtūcan? ");
INSERT INTO tkuNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús cālaktzī'lh ē cāhuanilh: ―Chi'xcuhuī'n jāla catitatlahualh tū natalī'a'kapūtaxtu, xmān Dios tzē nacāmakapūtaxtū ixpālacata Dios tzē tlahua pō'ktu. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pedro tzuculh chihuīna'n ē huanilh Jesús: ―Ica'kxtekui'līkō'uj ixlīpō'ktu tū xa'icka'lhīyāuj ē iccāstālani'mā'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús kelhtīni'lh: ―Ixlīcāna' tū iccāhuaniyān. Huī'lh tī nata'a'kxtekui'lī ixchicca'n natakexmatni' Dios. Ā'chulā' nataka'lhī nac cā'quilhtamacuj. Ē palh nata'a'kxtekui'lī ixcā'lacchicni'ca'n, o ixtā'timīnca'n, o ixtzī'ca'n, o ixtāta'ca'n, o ixcamana'ca'n, o ixpūcuxtuca'n, ");
INSERT INTO tkuNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ā'chulā' nataka'lhī nac tzamā' cā'quilhtamacuj. Hua'chi a'ktin cientu ixlacata ā'chulā' nataka'lhī ixcā'lacchicni'ca'n ē nā lhūhua' ixtā'timīnca'n ē ixtzī'ca'n ē ixtāta'ca'n ē ixcamana'ca'n ē ixpūcuxtuca'n. Nā nacāmakapātīnīncan. Nataka'lhī ixlatamatca'n tū jā catilaksputli jā Dios māpa'ksīni'nkō'. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Lhūhua' a'nan tī ixlacasqui'nca huā'tzā'; jā Dios māpa'ksīni'nkō', jā ixtā'chuntza' catihuanli. Lhūhua' a'nan tī jā ixlacasqui'nca huā'tzā'; jā Dios māpa'ksīni'nkō', ā'chulā' nalacasqui'nca. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesús ē ī'scujnu'nī'n ixtatā'cxtunu'mā'nalh nac Jerusalén ē Jesús ixcāpūlani'tēlha. Xlaca'n talī'a'cnīlh ē tī ixtastālani' ixtajicua'n. Cālē'mpālh lacapunchuna'j kelhacāujtu' ī'scujnu'nī'n ē tzucupālh cāhuani tū na'a'kspula. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jesús cāhuanilh: ―Ca'tzīyā'tit a'mā'nauj nac Jerusalén. A'ntza' naquimacamāstā'can ixpālacata quit Chi'xcu' xala' Tālhmā'n. Naquimacamāstā'can na ixmacanca'n xanapuxcu'nu' pālejni' ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn. Xlaca'n natahuan caquimaknīca. Xlaca'n naquintamacamāstā' na ixmacanca'n xalanī'n makat. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Naquintalakapala ē naquintakēsnoka ē naquintalakachojmanī ē naquintamaknī. Ixlī'a'ktu'tun quilhtamacuj na'iclacastālancuana'n na ixlacpu'na'i'tātca'n nīnī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jacobo ē Juan, ixka'hua'chan Zebedeo, talaktalacatzuna'jīlh Jesús ē tahuanilh: ―Mākelhtahua'kē'ni', iclacasqui'nāuj naquilātlahua'ni'yāuj tū na'iccāsqui'ni'yān. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Xla' cākelhasqui'nīlh: ―¿Tūchu lacasqui'nā'tit na'iccātlahua'ni'yān? ");
INSERT INTO tkuNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Xlaca'n tahuanilh: ―A'cxni' hui'x namāpa'ksīni'nkō'ya', quina'n iclacasqui'nāuj na'iccāpāxtūtahui'layān, chā'tin na mimpekxtūcāna'j ē ā'chā'tin na mimpekxtūxuqui. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesús cāhuanilh: ―Hui'xina'n jā ca'tzīyā'tit tū quilāsqui'ni'mā'nauj. ¿Ē tzē natāyani'yā'tit palh napātīni'nā'tit hua'chi quit na'icpātīni'n? Ū'tza' hua'chi pūkō'tnu'nā'tit quivaso ē hua'chi quintā'a'kpaxā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Xlaca'n tahuanli: ―Tzē na'ictlahuayāuj; tzē na'ictāyani'yāuj. Jesús cāhuanilh: ―Masqui napātīni'nā'tit chī quit, ");
INSERT INTO tkuNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ū'tza' naquilāpāxtūtahui'layāuj, quit jāla icmāpa'ksī. Huā'mā' pūtahuī'lh cāxui'līca xmān ixpālacata tī Dios lacsacli. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","A'cxni' kelhacāuj scujnu'nī'n taca'tzīlh tū kelhasqui'nīca Jesús, tatzuculh talīsītzī'ni' Jacobo ē Juan. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesús cāta'sani'lh ixlīpō'ktuca'n ē cāhuanilh: ―Hui'xina'n ca'tzīyā'tit chī ixtāyatca'n tī tamāpa'ksīni'n nac cā'ti'ya'tna'. Xlaca'n hua'chi ixtēcu'nī'n tī tā'tapa'ksī xlaca'n. Palha' tamāpa'ksīni'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Jā chuntza' catilalh na milacpu'na'i'tātca'n. Catīxcuhuālh tī ka'tla' huancu'tun na milacpu'na'i'tātca'n, ixlacasqui'nca xla' nala hua'chi ixlacscujni'ca'n ā'makapitzīn. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Catīxcuhuālh tī xapuxcu' huancu'tun na milacpu'na'i'tātca'n, ixlacasqui'nca xla' nala hua'chi ixtasācua'ca'n ā'makapitzīn hui'xina'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Quit Chi'xcu' xala' Tālhmā'n. Quit jā icmilh na'icla hua'chi xatēcu'; quit icmilh na'icscuja ē na'iccāmaktāya ā'makapitzīn. Na'icmacamāstā' quilatamat na'iccāmakapūtaxtū līlhūhua' ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tachā'lh nac cā'lacchicni' jā huanican Jericó. A'cxni' Jesús ixtaxtumā'lh nac Jericó, tatā'a'lh ī'scujnu'nī'n ē lhūhua' tachi'xcuhuī't. Na ixpāxtūn tej ī'squi'ni'huā'yahuī'lh lakatzī'n tī ixuanican Bartimeo ixka'hua'cha Timeo. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","A'cxni' ca'tzīlh ixtētaxtumā'lh Jesús xala' nac Nazaret, tzuculh ta'sa ē huanli: ―¡Jesús, hui'x ixtā'nat David tī xa'icka'lhīmā'nauj! ¡Caquilakalhu'ma'nti quit! ");
INSERT INTO tkuNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Lhūhua' chi'xcuhuī'n talacaquilhnīlh ē tahuanilh: ―Caquilhca'csla'. Bartimeo ā'chulā' ixta'sa ē huanli: ―¡Hui'x ixtā'nat David tī xa'icka'lhīmā'nauj, caquilakalhu'ma'nti! ");
INSERT INTO tkuNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesús tāyalh ē cāhuanilh ī'scujnu'nī'n: ―Cata'sa'ni'tit. Tata'sani'lh lakatzī'n ē tahuanilh: ―Capāxuhua' ē catāya'. Jesús ta'sani'yān. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Xla' tamakxtulh a'ktin ixlu'xu' ē tāyalh ē lakmilh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús kelhasqui'nīlh: ―¿Tūchu lacasqui'na' na'ictlahuani'yān? Lakatzī'n huanilh: ―Mākelhtahua'kē'ni', caquimālacahuā'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús huanilh: ―Tzētza' napina'. Hui'x a'ka'ī'nī'ta' quit tzē na'icmālacahuānīyān ē ū'tza' lītzeya'ntitza'. Xamaktin lacahuāna'lh ē stālani'lh Jesús nac tej. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","A'cxni' ixtalacatzuna'jīmā'nalhtza' nac Jerusalén, tachā'lh nac sipej jā huanican Olivos, ē ū'tza' lacatzuna'j cā'lacchicni' jā huanican Betfagé ē jā huanican Betania. Jesús cāmāpūlīlh chā'tu' ī'scujnu'nī'n ");
INSERT INTO tkuNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ē cāhuanilh: ―Capintit nac cā'lacchicni' tū tasu'yu na milacatza'jca'n. A'cxni' nachipinā'tit nalaktzī'nā'tit a'ktin xaska'ta' burro tū chī'yāhuacanī't. Jā tī chā'tin tī kētahui'lanī't. Caxcuttit ē caquilālīmini'uj huā'tzā'. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Palh catīhuālh nacākelhasqui'ni'yān: “¿Tū ixpālacata xcutpā'na'ntit burrito?”, hui'xina'n nakelhtīni'nā'tit: “Māpa'ksīni' namaclacasqui'n ē palaj tunca namacamimpala huā'tzā'.” ");
INSERT INTO tkuNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ta'a'lh ē tamaclalh lakatin xasāsti'cus burro tū ixchī'yāhuacanī't. Ixyālh nac tej lacatzuna'j xamākelhcha a'ktin chic. Tatzuculh taxcuta. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Makapitzīn chi'xcuhuī'n tī ixtayāna'lh takelhasqui'nīlh: ―¿Tū tlahua'pā'na'ntit? ¿Tū ixpālacata xcutpā'na'ntit burro? ");
INSERT INTO tkuNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Scujnu'nī'n takelhtīni'lh chuntza' chī Jesús ixcāhuaninī't. Chi'xcuhuī'n tamakxtekli ē talē'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Talīmini'lh Jesús xasāsti'cus burro ē talīkētlapalh ixlu'xu'ca'n ē xla' kētahui'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Lhūhua' tachi'xcuhuī't tamāpī'ni'lh ixlu'xu'ca'n nac tej. Ā'makapitzīn ixtacā' xalacstīn ixpeken qui'hui' natamāpī'ni' nac tej. Chuntza' talīmāsu'yulh palh ixtalakachi'xcuhuī'mā'nalh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tī ixtapūlani'tēlha ē tī ixtastālani'tēlha tatzuculh tata'sa ē tahuanli: ―¡Camakapāxuīca Dios! Dios casicua'lanātlahualh tī līmimā'lh ixlīmāpa'ksīn Māpa'ksīni' quinDiosca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Dios casicua'lanātlahualh līmāpa'ksīn tū nala, ē ū'tza' hua'chi ixlīmāpa'ksīn quixū'nāpapca'n David. ¡Calakachi'xcuhuī'ca Dios! ");
INSERT INTO tkuNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","A'cxni' Jesús chā'lh nac Jerusalén, tanūlh xaka'tla' nac templo. Kōtanūtza' ixuanī't, ē a'cxni' calhāxcuhuālh laktzī'nkō'lh na ixchakān templo, taxtulh ē cātā'a'lh kelhacāujtu' scujnu'nī'n nac Betania. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ixlīlakalī a'cxni' tataxtulh nac Betania, Jesús ixtzi'ncsa. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Makat laktzī'lh a'katin xaqui'hui' higo ē ixtaxtuni'nī'ttza' xapa'lhma' qui'hui'. Jesús talacatzuna'jīlh nalaktzī'n palh ixua'ca'lhtza' xatahua'ca't. A'cxni' chā'lh jā ixyālh qui'hui', jā ixka'lhī ixtahua'ca't. Xmān xapa'lhma' ixka'lhī ixpālacata jāna'j ixchā'n ixpūlanān higo. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesús huanilh qui'hui': ―Jā makstin catihua'ca' mintahua'ca't. Ī'scujnu'nī'n takexmatli tū huanilh qui'hui'. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","A'cxni' tachā'lh nac Jerusalén, Jesús tanūlh xaka'tla' nac templo ē tzuculh cātantlakaxtu tī ixtastā'namā'nalh ē tī ixtatamāhuana'mā'nalh na ixtanquilhtīn templo. Cāmakpūspi'tni'kō'lh ixmesaca'n tī ixtapakxtumā'nalh ixtumīnca'n tachi'xcuhuī't ē nā ixpūtahui'lhca'n tī ixtastā'mā'nalh pālūmax. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jā makxtekli nūn chā'tin natētaxtu na ixtanquilhtīn templo palh ixlē'mā'lh catūhuālh. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ixcāmāsu'yuni' tachi'xcuhuī't ē huanli: ―¿Ē jā tatzo'kni' chuntza'?: “Quinchic namāpācuhuīcan chic jā tlahuacan oración. Tachi'xcuhuī't xalanī'n calhāxcuhuālh natamin natatlahua oración.” Chī tlahuapā'na'ntit, līmāxtunī'tantīt hua'chi ixpūtatzē'kni'ca'n ka'lhāna'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Cāmāca'tzīnīca xanapuxcu'nu' pālejni' ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn. Xlaca'n ixtaputzamā'nalh chī natalīmaknī Jesús. Ixtajicua'ni' Jesús ixpālacata ixlīpō'ktuca'n tachi'xcuhuī't ixtalī'a'cnī chī ixmāsu'yu. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","A'cxni' ixtā'cnūnī'ttza' chi'chini', Jesús ē ī'scujnu'nī'n tataxtulh nac Jerusalén. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ixlīlakalī tzi'saj tatētaxtulh jā ixyālh xaqui'hui' higo ē talaktzī'lh hua'chi ī'scāckō'nī'ttza' pō'ktu ixtankēxē'k. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedro lacapāstacli tū ixuaninī't Jesús ē huanilh: ―Mākelhtahua'kē'ni', cala'ktzi'. Qui'hui' scāctāyakō'lhtza'; ū'tza' tū lacaquilhni'. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús cākelhtīlh: ―Ca'a'ka'ī'ni'tit Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ixlīcāna' tū iccāhuaniyān. Catīxcuhuālh tī tzej na'a'ka'ī' ē jā naka'lhī a'ktu' ixtalacapāstacni', natlahuani'can tū xla' nasqui'n. Palh nahuani sipej: “Catapānu' ā'tzā' ē catojo' nac xcān”, chuntza' nala, xmān jā caka'lhīlh a'ktu' ixtalacapāstacni'. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ū'tza' iccālīhuaniyān ixlīpō'ktu tū nasqui'ni'yā'tit a'cxni' orarlīyā'tit Dios, ca'a'ka'ī'tit ka'lhī'yā'tittza' ē namaktīni'nā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","A'cxni' natāya'yā'tit ē tlahua'pā'na'ntit oración, namātza'nkēna'ni'yā'tit catīhuālh palh cātlahuani'nī'ta'n tū jā tze. Chuntza' minTāta'ca'n tī huī'lh nac a'kapūn tzē nacāmātza'nkēna'ni'yān mincuentaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Palh hui'xina'n jā cāmātza'nkēna'ni'yā'tit ā'makapitzīn, minTāta'ca'n tī huī'lh nac a'kapūn jā caticāmātza'nkēna'ni'n tū jā tze tū tlahua'nī'ta'ntit. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tachā'lh nac Jerusalén. A'cxni' Jesús ixlatlā'huan xaka'tla' nac templo, talaktalacatzuna'jīlh xanapuxcu'nu' pālejni' ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn ē xalakōlu'n israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Takelhasqui'nīlh: ―¿Tī ixlīmāpa'ksīn cālītlahua'pā't tzamā'? ¿Tīchu maxquī'n huā'mā' līmāpa'ksīn? ");
INSERT INTO tkuNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús cākelhtīlh: ―Nā quit na'iccākelhasqui'nīyān catūhuālh. Palh naquilākelhtīyāuj, nā quit na'iccāhuaniyān tīchu ixlīmāpa'ksīn iccālītlahuamā'lh huā'mā'. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Tīchu ixlīmāpa'ksīn ixlīmā'kpaxīni'n Juan? ¿Ixlīmāpa'ksīn Dios o ixlīmāpa'ksīnca'n chi'xcuhuī'n? Caquilākelhtīuj. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Xlaca'n tatzuculh talālītā'chihuīna'n ixlīmānca'n ē talāhuanilh: ―¿Chī nahuaniyāuj? Palh nahuaniyāuj ixlīmā'kpaxīni'n ixlīmāpa'ksīn Dios, naquincākelhasqui'nīyān: “¿Tū ixpālacata jā a'ka'ī'nī'ta'ntit?” ");
INSERT INTO tkuNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Jāla catihuaniuj ixlīmāpa'ksīnca'n chi'xcuhuī'n ixpālacata cājicua'ni'yāuj tachi'xcuhuī't ―talāhuanilh. Ixtajicua'n tachi'xcuhuī't natasītzī' ixpālacata ixlīpō'ktuca'n ixta'a'ka'ī'ni' Juan ixlīcāna' ixa'kchihuīna' Dios ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ū'tza' talīkelhtīlh Jesús: ―Jā iccā'tzīyāuj tīchu ixlīmāpa'ksīn. Jesús cāhuanilh: ―Nā chuntza' quit jā icticāhuanin tīchu ixlīmāpa'ksīn iccālītlahuamā'lh huā'mā'. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesús tzuculh cālītā'chihuīna'n tachi'xcuhuī't tū līca'tzīni'can ē cāhuanilh: ―Ixuī'lh chā'tin chi'xcu' tī cha'nli mayāc tū māstā' uvas. Līculālhui'līlh chihuix ixti'ya't ē cāxtlahualh ixpūlacchī'can ē yāhualh a'ktin torre tū napūmaktaka'lha ixpū'uva. ’Ā'līstān cāmāsācua'nīlh ixti'ya't makapitzīn tasācua'n natascuja i'tātna'. Xla' a'lh latā'kchoko makat. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","A'cxni' chilhtza' ixpūlanān uvas, macā'lh ī'scujni' na ixpū'uva. A'lh cāsqui'ni' tasācua'n catamaxquī'lh tū tamakalanī't tū ixla' ixtēcu' ti'ya't. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tasācua'n tachi'palh scujni' ē tatucsli ē chuntza' tamāspi'tli. Jā tū tū maxquī'ca. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ixtēcu' pū'uva macā'mpālh ā'chā'tin ī'scujni'. Tasācua'n tacucta'lalh ē talakapalalh ē chuntza' tamacā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ixtēcu' macā'mpālh ā'chā'tin ē tamaknīlh xla'. Ixtēcu' cāmacā'mpālh lhūhua' ā'makapitzīn. Tasācua'n cālacni'cui'līlh makapitzīn ē tamaknīlh ā'makapitzīn. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Ā'xmān chā'tin ixuī'lhcus tī tzē namacā'ncan, ē ū'tza' ixka'hua'cha tī ixpāxquī'. Xla' ā'xmān macā'lh ē huanli: “Natalakachi'xcuhuī' quinka'hua'cha.” ");
INSERT INTO tkuNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Chuntza' jā ixlīcāna'. Tasācua'n talāhuanilh: “Ū'tza' tī ixla' nahuankō' ixlīpō'ktu tū ka'lhī ixtāta'. Camaknīuj ē chuntza' quilaca'n nahuan pū'uva.” ");
INSERT INTO tkuNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tachi'palh ē tamaknīlh ē taquīmacā'lh ixquilhtūn pū'uva. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jesús cākelhasqui'nīlh: ―¿Chī puhua'nā'tit? ¿Tūchu nacātlahuani' ixtēcu' pū'uva tī ixcāmāsācua'nīcanī't? Na'a'n ē nacāmālaksputūkō' tzamā' tasācua'n ē nacāmāsācua'nī pū'uva ā'makapitzīn xtum tasācua'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Ē jā maktin līkelhtahua'kanī'ta'ntit na ixtachihuīn Dios ixpālacata ī'Ska'ta'? Xla' hua'chi chihuix tū lītzo'kcanī't ē chuntza' huan: Tapācna'nī'n talakmaka'lh chihuix ē tzamā' chihuix tū ā'chulā' ixlacasqui'nca. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Chuntza' tlahualh Māpa'ksīni' ē quina'n iclī'a'cnīyāuj. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tī ixtaquiclhlaktzi'n Jesús titachi'pacu'tunli ixpālacata ta'u'cxca'tzīlh xlaca'n hua'chi tasācua'n nac pū'uva. Ixtajicua'ni' tachi'xcuhuī't ē ū'tza' talīmakxtekli ē ta'a'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Cālakmacā'nca Jesús ā'makapitzīn fariseos ē ixchi'xcuhuī'n Herodes. Cālakmacā'nca natakexmatxtu catūhuālh tū tzē natalīmālacsu'yu. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","A'cxni' talakchā'lh, tahuanilh: ―Mākelhtahua'kē'ni', icca'tzīyāuj hui'x hua'na' tū ixlīcāna'. Hui'x jā cātlahua'ni'ya' cuenta chī talīchihuīna'nān tachi'xcuhuī't. Lacxtim cālaktzī'na' ixlīpō'ktuca'n tachi'xcuhuī't. Hui'x tzej māsu'yu'ya' chī Dios lacasqui'n. ¿Inchā tze na'icxokoyāuj tū māta'jīni'n emperador romano o jā ixlacasqui'nca? ");
INSERT INTO tkuNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesús ixca'tzī xmān ixtalīlaktzī'ncu'tun ē cākelhasqui'nīlh: ―¿Tū ixpālacata quilālīlaktzī'ncu'tunāuj? Caquilālīmini'uj a'ktin tumīn na'iclaktzī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Talīmini'lh a'ktin denario tū ixtumīnca'n ē Jesús cākelhasqui'nīlh: ―¿Tīchu ixlacan tasu'yu nac huā'mā' tumīn ē tīchu ixtacuhuīni' tatzo'kni'? Xlaca'n tahuanilh: ―Ixla' emperador. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Palaj tunca Jesús cāhuanilh: ―Camaxquī'tit emperador tū ixla' ē camaxquī'tit Dios tū ixla'. Xlaca'n talī'a'cnīlh chī cākelhtīlh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ā'līstān talakmilh Jesús makapitzīn saduceos. Xlaca'n tamāsu'yu jā catilacastālancuana'nca. Ū'tza' talīhuanilh Jesús: ");
INSERT INTO tkuNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Mākelhtahua'kē'ni', Moisés quincāmakxtekni'nī'tan huā'mā' tatzo'kni': Palh nanī chā'tin chi'xcu' tī tamakaxtoknī'ttza', ē palh nīmakxteka ixpuscāt ē jā tī ī'ska'ta', ixlacasqui'nca ī'stancu natā'tamakaxtoka tī nīmaka'ncanī't. Xapūla ka'hua'cha tī nalacatuncuhuī' ī'ska'ta' nahuan xapuxcu' tī nīnī'ttza'. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ixtahui'lānalh kelhatojon lītā'timīn. Xapuxcu' tamakaxtokli ē jā ixka'lhī ī'ska'ta' a'cxni' nīlh. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ixlīchā'tu' tā'tamakaxtokli tī nīmaka'ncanī'ttza' ē nā xla' nīlh ē jā ka'lhīlh ī'ska'ta'. Chuntza' a'kspulapālh ā'chā'tin ī'stancu a'cxni' tā'tamakaxtokli tī nīmaka'ncanī'ttza'. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Chuntza' chā'tunu' ixkelhatojonca'n tatā'tamakaxtokli puscāt ē ixlīpō'ktuca'n tanīlh. Jā tī chā'tin ī'ska'ta'ca'n tamakxtekli. Ā'xmān nīlh puscāt. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","A'cxni' nalacastālancuana'ncan, ¿tīchu ixla' nahuan tzamā' puscāt? Ixkelhatojonca'n ixtatā'tamakaxtoknī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesús cākelhtīlh: ―Ū'tza' līta'a'kskāhuī'nī'ta'ntit mina'cstuca'n. Jā ca'tzīyā'tit tū tatzo'kni' na ixtachihuīn Dios ē jā ca'tzīyā'tit chī huanī't ixlītli'hui'qui. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","A'cxni' nīnī'n natalacastālancuana'n, jā catitamakaxtokca ē jā catitamāstā'lh ixtzu'ma'janca'n natatamakaxtoka. Xlaca'n natala hua'chi ixángeles Dios xalanī'n nac a'kapūn. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Moisés tzo'kli ixpālacata tī natalacastālancuana'n a'cxni' lītzo'kli a'ctzuna'j qui'hui' tū ixlamamā'lh. ¿Ē jā līkelhtahua'kanī'ta'ntit tū Dios huanilh Moisés? Chuntza' huanli: “Quit ixDiosca'n Abraham ē Isaac ē Jacob.” ");
INSERT INTO tkuNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Dios ū'tza' ixDiosca'n xalakahuan ē jā xanīnī'n. Hui'xina'n ta'a'kskāhuī'yā'tit mina'cstuca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Cālakmilh Jesús chā'tin xamākelhtahua'kē'ni' līmāpa'ksīn ē cākexmatli chī saduceos talālīhuanimā'nalh. Xla' ca'tzīlh chī tzej cākelhtīlh Jesús. Palaj tunca kelhasqui'nīlh: ―¿Tuchūyā līmāpa'ksīn ā'chulā' ixlacasqui'nca? ");
INSERT INTO tkuNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús kelhtīlh: ―Līmāpa'ksīn tū ā'chulā' ixlacasqui'nca, ū'tza' huā'mā': “Cakexpa'ttit hui'xina'n israelitas. Māpa'ksīni' quinDiosca'n xmān ū'tza' Māpa'ksīni'. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Calīpāxqui' Māpa'ksīni' tī minDios ixlīpō'ktu milīstacna' ē ixlīpō'ktu mintalacapāstacni' ē milītli'hui'qui.” ");
INSERT INTO tkuNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ixlī'a'ktu' līmāpa'ksīn ū'tza' huā'mā': “Capāxqui' ā'makapitzīn chuntza' chī pāxquī'ca'na' mina'cstu.” Jā tū a'nan ā'a'ktin līmāpa'ksīn tū ā'chulā' ixlacasqui'nca. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Palaj tunca xamākelhtahua'kē'ni' līmāpa'ksīn huanilh: ―Ixlīcāna' tū hua'na', Mākelhtahua'kē'ni'. Huī'lh chā'tin Dios ē xla' xmān ixlīmān Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ixlacasqui'nca nalīpāxquī'yāuj ixlīpō'ktu quilīstacna'ca'n ē ixlīpō'ktu quintalacapāstacni'ca'n ē quilītli'hui'quica'n. Nā ixlacasqui'nca napāxquī'yāuj ā'chā'tin chuntza' chī quina'cstuca'n quincātapāxquī'yān. Palh chuntza' natlahuayāuj, ū'tza' ā'chulā' xatze ē jā namālacnūnīyāuj Dios tū maknīcan ē tū lhcuyucan. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesús cuenta tlahualh chī tzej lacapāstacli ē kelhtīlh xamākelhtahua'kē'ni' līmāpa'ksīn. Jesús huanilh: ―Tisputni'yān xmān macsti'na'j natapa'ksīni'ya' Dios. Jātza' tī chā'tin ixkelhasqui'nīcu'tun ixpālacata ixtajicua'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús ixcāmāsu'yuni'mā'lh tachi'xcuhuī't xaka'tla' nac templo ē cāhuanilh: ―Xamākelhtahua'kē'ni'nī'n līmāpa'ksīn, ¿chī talīhuancan Cristo tī Dios hui'līlh ixlīmakapūtaxtūnu' ū'tza' ī'xū'nātā'nat David? ");
INSERT INTO tkuNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tzamā' David huanli chuntza' chī māsu'yuni'lh Espíritu Santo ē chuntza' tzo'kli: Māpa'ksīni' Dios huanilh quiMāpa'ksīni': “Catahui'la' na quimpekxtūcāna'j hasta a'cxni' quit na'iccāskāhuī'kō' mintā'lāquiclhlaktzi'.” ");
INSERT INTO tkuNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Palh David līchihuīna'nli ī'xū'nātā'nat ē māpācuhuīlh ixMāpa'ksīni', ū'tza' huanicu'tun xla' ā'chulā' xaka'tla' nalītaxtu ―huanli Jesús. Lhūhua' tachi'xcuhuī't līpāxuhua takexmatli. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","A'cxni' Jesús ixcāmāsu'yuni'mā'lh tachi'xcuhuī't, ixcāhuani: ―Catamaktaka'lhtit ē jā ticālī'a'kskāhuī'yān xamākelhtahua'kē'ni'nī'n līmāpa'ksīn tī tapūlatā'kchokocu'tun xapūlhmā'n ixlu'xu'ca'n. Nā talacasqui'n cacātā'chihuīna'nca ē cacālakachi'xcuhuī'ca nac cā'tejen. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Na ixtemploca'n israelitas xlaca'n taquilhpūlatahui'lacu'tun ē talacasqui'n cacālakachi'xcuhuī'ca jā tlahuacan cā'tani'. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Xlaca'n ta'a'kskāhuī'maktī ixchicca'n tī ixtacānīmaka'ncanī't ē ā'līstān na'j tunca ta'orarlī jā nacālaktzī'ncan ē chuntza' talī'a'kskāhuī'nin. Ā'chulā' natapātīni'n xlaca'n ē jā ā'makapitzīn. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesús tahuī'lh na ixlacatīn jā ixmojōcan tumīn tū maxquī'can Dios. Ixcālaktzī'mā'lh tachi'xcuhuī't a'cxni' ixtamojō ixtumīnca'n. Kelhalhūhua' lacricujnu' tamojōlh lhūhua' ixtumīnca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Milh chā'tin tī nīmaka'ncanī't; xcamanīn ixuanī't. Xla' cāmojōlh pektu' ixtumīn cobre; xmān macsti'na'j ixtatlaj. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesús cāta'sani'lh ī'scujnu'nī'n ē cāhuanilh: ―Ixlīcāna' iccāhuaniyān: tū mojōlh huā'mā' xcamanīn tī nīmaka'ncanī't ā'chulā' ixtatlaj na ixlacatīn Dios ē jā tū tamojōlh ā'makapitzīn. ");
INSERT INTO tkuNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Xlaca'n tamojōlh xmān tū ixcāquītāxtūni'nī'ttza' ixpālacata xlaca'n lacricujnu'. Puscāt, xla' masqui jā lhūhua' ixka'lhī, māstā'kō'lh ixlīpō'ktu tū ixlīhuā'yan. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","A'cxni' Jesús ixtaxtumā'lh xaka'tla' nac templo, chā'tin ī'scujnu'nī'n huanilh: ―Mākelhtahua'kē'ni', cala'ktzi'. Tzēhuanī't chihuix tū lītlahuacanī't huā'mā' xaka'tla' templo ē tzej taxtulh. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús kelhtīlh: ―Calaktzī'ntit ixlīpō'ktu huā'mā' tū ixla' templo. Namin a'ktin quilhtamacuj a'cxni' nūn a'ktin chihuix catilākētahuī'lh. Ixlīpō'ktuca'n nataponckō' ē talhta'm nalacla. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesús tahuī'lh na ixtūtzā'n sipej jā huanican Olivos ē na ixlaktzaj xaka'tla' templo. Pedro ē Jacobo ē Juan ē Andrés tzē'k takelhasqui'nīlh: ");
INSERT INTO tkuNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Iclacasqui'nāuj naquilāhuaniyāuj jā'cxni' na'a'kspula tzamā'. ¿Chī na'iclīca'tzīyāuj palh palaj na'a'kspula tū hua'nti? ");
INSERT INTO tkuNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús cāhuanilh: ―Catamaktaka'lhtit jā tī chā'tin nacā'a'kskāhuī'yān. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Lhūhua' chi'xcuhuī'n natahuan taka'lhī quilīmāpa'ksīn. Chā'tunu' natahuan: “Quit Cristo tī Dios lacsacnī't.” Chuntza' lhūhua' tī nacā'a'kskāhuī'can. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Nakexpa'tā'tit chī macasā'nan jā lacatzuna'j lāta'lamā'ca ē nacātamāca'tzīnīyān chī lāta'lamā'ca makat. Jā tijicua'nā'tit. Chuntza' pūla na'a'kspula. Jāna'j ixlī'a'ksputni'. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Chā'tin puxcu' ixtā'lāquiclhlaktzi' nahuan ā'chā'tin. Chā'tin māpa'ksīni' naskāhuī'cu'tun ā'chā'tin. Calhāxcuhuālh natachiqui ti'ya't ē na'a'nan tatzi'ncstat. Ixlīpō'ktu huā'mā' xmān ixlītzucuni' chī napātīni'ncan. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Cuenta catlahua'tit ixpālacata nacātamacamāstā'yān jā tahui'lāna'n māpa'ksīni'nī'n ē nacātamaksno'kān nac templo. Quilā'a'ka'ī'ni'yāuj ē ū'tza' nacātalīlē'nān na ixlacatīnca'n gobernadores ē na ixlacatīnca'n māpa'ksīni'nī'n. Chuntza' nachihuīna'nā'tit quimpālacata. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","’A'cxni' jāna'j ā'sputa tzamā' cā'quilhtamacuj, ixlacasqui'nca nacāmāsu'yuni'can xatze tachihuīn tachi'xcuhuī't calhāxcuhuālh nac cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","A'cxni' nacātachi'payān ē nacātamacamāstā'yān a'ntza' jā tahui'lāna'lh māpa'ksīni'nī'n, jā catilī'a'ktayuntit pūla chī nalītamaktāyayā'tit. Nahua'nā'tit tū puhua'nā'tit a'cxni' nachā'n tzamā' hora. Jā hui'xina'n catichihuīna'ntit. Espíritu Santo nacāmāchihuīnīyān. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","’Tī quinta'a'ka'ī'ni' nacāmacamāstā'can jā tahui'lāna'lh māpa'ksīni'nī'n. Masqui ixtā'tinca'n natamacamāstā' nacāmaknīcan. Xanatātana' natamacamāstā' nacāmaknīcan ixcamana'ca'n tī ta'a'ka'ī'. Lacstīn natasītzī'ni' ixtāta'ca'n ē ixtzī'ca'n tī ta'a'ka'ī' ē natamāmaknīnīni'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ixlīpō'ktuca'n tachi'xcuhuī't nacātaquiclhlaktzī'nān ē xmān tū quilīpālacata. Tī natatāyani' hasta a'cxni' natanī, xlaca'n nacāmakapūtaxtūcan. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Nalaktzī'nā'tit tzamā' jā tze tū nalactlahuakō' ē natāya jā jā minī'ni' chuntza' chī tzo'knulh profeta Daniel. Quit tī ictzo'kmā'lh huā'mā', iccāhuaniyān hui'xina'n tī kelhtahua'kapā'na'ntit cuenta catlahua'tit. A'cxni' nalaktzī'nā'tit tzamā', a'cxni' ixlacasqui'nca natatzā'la hasta nac sipej xlaca'n tī tahui'lāna'lh nac Judea. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tzamā' quilhtamacuj a'cxni' natayuja tī tahui'lāna'lh na ixa'kstīn ixchicca'n, jā catitatanūlh na ixchicca'n natamāxtu catūhuālh tū ixla'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tī tascujmā'nalh nac pūcuxtu jā catitataspi'tli na ixchicca'n natataya ixlu'xu'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Tzamā' quilhtamacuj koxa titala puscan tī taka'lhīnī't o tī tamātzi'quī'ni'ncus. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","’Casqui'ni'tit Dios jā ixlacasqui'nca natzā'la'yā'tit a'cxni' lonknu'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Napātīni'ncan a'cxni' nala huā'mā'. Hasta a'cxni' Dios mālacatzuculh tzamā' cā'quilhtamacuj, jā maktin pātīni'ncanī't chī napātīni'ncan tzamā' quilhtamacuj. Jātza' maktin catilalh ixtā'chuntza' ā'līstān. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Palh Dios jā ixtimāmacsti'na'jīlh huā'mā' quilhtamacuj, jā ixta'a'kapūtaxtulh jā tī chā'tin. Dios namāmacsti'na'jī ixpālacata cālakalhu'man xlaca'n tī cālacsacnī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’A'cxni' namin tzamā' tapātīn ē palh catīhuālh ixcāhuanin: “Chā calaktzī'ntit. Ā' huī'lh Cristo tī Dios lacsacui'līlh”, jā cati'a'ka'ī'tit. Palh catīhuālh ixcāhuanin: “Chā calaktzī'ntit. Ā'jnanu' yālh”, jā cati'a'ka'ī'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Natamin lhūhua' a'kskāhuī'ni'nī'n ē makapitzīn natahuan māni' xlaca'n Cristo ē ā'makapitzīn natahuan māni' xlaca'n ixa'kchihuīna'nī'n Dios. Nā natatlahua lī'a'cnīn nata'a'kskāhuī'cu'tun xlaca'n tī Dios cālacsacli. Jāla catita'a'kskāhuī'lh tī Dios cālacsacli masqui nacā'a'kskāhuī'can ā'makapitzīn. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Skalalh catahui'la'tit. Iccāhuanintza' ixlīpō'ktu huā'mā' ē chuntza' jā nacātita'a'kskāhuī'yān. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jesús cāhuanipālh: ―Tzamā' quilhtamacuj a'cxni' na'a'kspulatza' huā'mā' tapātīn, chi'chini' ē mālhcuyu' jā catitamāxkakēni'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Sta'cu nataminācha' nac a'kapūn ē hasta a'kapūn natachiqui. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","A'cxni' naquintalaktzī'n quit Chi'xcu' xala' Tālhmā'n chī na'icpūmin nac poklhnu'. Na'icka'lhī lhūhua' lītli'hui'qui ē tzēhuanī't na'icxkaka. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Palaj tunca na'iccāmacamin quinángeles ē natamākēstoka tī cālacsaccanī't. Natamin tī cālacsaccanī't xalanī'n calhāxcuhuālh nac cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Calīmaksca'ttit xaqui'hui' higo. A'cxni' tza'la'nka' ixpeken ē tzucumā'lh tapu'n xapa'lhma', hui'xina'n ca'tzīyā'tit talacatzuna'jīmā'lhtza' a'cxni' nalhcācnan. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Chuntza' a'cxni' na'a'kspula ixlīpō'ktu huā'mā' tū iccāhuaniyān, naca'tzīyā'tit talacatzuna'jīmā'lhtza' a'cxni' nasputa cā'quilhtamacuj. Talacatzuna'jīmā'lhtza' hua'chi chā'tin tī ka'lhīmā'ca ē yālhtza' na ixlacapūn mākelhcha. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ixlīcāna' tū iccāhuaniyān. Xlaca'n tī tahui'lāna'lhcus jā catitanīkō'lh hasta a'cxni' na'a'kspula ixlīpō'ktu huā'mā' tū iccāhuanin. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Masqui nasputa a'kapūn ē nasputa ti'ya't, jā maktin catisputli quintachihuīn; pō'ktu nakentaxtukō'. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Jā tī chā'tin ca'tzī jā'cxni' namin huā'mā' quilhtamacuj o huā'mā' hora; nūn ángeles xalanī'n nac a'kapūn jā taca'tzī. Nūn ī'Ska'ta' Dios jā ca'tzī. Xmān Dios xaTāta' ca'tzī jā'cxni' ixlīcāna' na'a'kspula. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Skalalh catahui'la'tit ixpālacata jā ca'tzīyā'tit jā'cxni' na'a'kspula huā'mā'. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ū'tza' hua'chi chā'tin chi'xcu' tī na'a'n latā'kchoko makat. Nacāmacamaxquī'tā'quī' ixchic ī'scujnu'nī'n ē nacāmaxquī' ixtascujūtca'n chā'tunu'. Nayāhua chā'tin maktaka'lhna' nac tanquilhtīn ē namāpa'ksī skalalh natāya. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Chuntza' hui'xina'n skalalh catahui'la'tit ixpālacata jā ca'tzīyā'tit jā'cxni' namin ixtēcu' chic. Palhāsā' namin smalanka'n, o a'cxni' chū'cus nata'sa puyux, o i'tāt tzī'sa, o a'cxni' xkakatza'. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ū'tza' skalalh calītahui'la'tit ixpālacata jā lhtatapā'na'ntit a'cxni' xamaktin namin. ");
INSERT INTO tkuNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Iccāhuaniyān hui'xina'n: Skalalh catahui'la'tit. Nā skalalh catatahuī'lh ixlīpō'ktuca'n tachi'xcuhuī't ―cāhuanilh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ā'a'ktu' quilhtamacuj ī'sputacus ixcā'tani'ca'n israelitas tū huanican pascua a'cxni' hua'can pāntzīn tū jā ka'lhī levadura. Xanapuxcu'nu' pālejni' ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn ixtaputzamā'nalh chī natalī'a'kskāhuī' Jesús natachi'pa ē natamāmaknīnīni'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Talāhuanilh: ―Palh natlahuayāuj catūhuālh līhuan lamā'lh cā'tani', tachi'xcuhuī't natatā'kaquī'. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús ixuī'lh nac Betania na ixchic Simón. Ū'tza' huā'mā' Simón tī ixmasni'mā'lh ixquinīt ē ixtzeyanī'ttza'. A'cxni' Jesús ixuā'yamā'lh a'ntza', chā'tin puscāt laktalacatzuna'jīlh. Ixlē'mā'lh pātin lameti tū ixlītzuma aceite tū xatapalaxla' ē mu'csu ixuanī't. Ū'tza' tū huanican nardo. Puscāt pa'klhli lameti ē līcuctlahualh Jesús aceite. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Makapitzīn tī ixtahui'lāna'lh talīsītzī'lh ē talāhuanilh: ―¿Tū ixpālacata pāxcat līlalh huā'mā' aceite? ");
INSERT INTO tkuNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ixtatlaj hua'chi ixtatlaj chā'tin chi'xcu' chī a'ktin cā'ta. Tzē ī'stā'ca ē tumīn tzē ixcāmaxquī'ca xcamanīnī'n. Taquilhnīlh puscāt. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesús cāhuanilh: ―Camakxtektit. ¿Tū ixpālacata jicsmāhuī'yā'tit huā'mā' puscāt? Quintlahuani'lh tū tze. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Pō'ktu quilhtamacuj na'a'nan xcamanīnī'n na milacpu'na'i'tātca'n. A'cxni' lacasqui'nā'tit, tzē nacātlahuani'yā'tit tū tze. Quit jā pō'ktu quilhtamacuj na'iccātā'tahui'layān. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Puscāt tlahualh tū tzē ixlacpuhuan. Quilīcuctlahualh aceite ē chuntza' quincāxui'līlhtza' chī naquimā'cnūcan. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ixlīcāna' tū iccāhuaniyān. Calhāxcuhuālh nac cā'quilhtamacuj jā namāca'tzīnīni'ncan xatze tachihuīn ixla' Cristo, a'ntza' nahuancan tū tlahualh huā'mā' puscāt. Ū'tza' ixlīpō'ktuca'n natalīlacapāstaca xla' ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariote chā'tin ixlīkelhacāujtu' scujnu'nī'n ixuanī't. Xla' cālaka'lh xanapuxcu'nu' pālejni' nacāhuani ixcāmacamaxquī'lh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","A'cxni' takexmatli tū cāhuanica, tapāxuhualh ē tahuanilh natamaxquī' tumīn. Ē Judas tzuculh putza chī ixlīmacamāstā'lh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Milh quilhtamacuj tū ixlītzucuni' cā'tani' a'cxni' hua'can pāntzīn tū jā lītlahuacanī't levadura. Huā'mā' quilhtamacuj a'cxni' maknīcan xaska'ta' purecu' tū nahua'can ixpālacata huā'mā' cā'tani' tū huanican pascua. Ī'scujnu'nī'n takelhasqui'nīlh Jesús: ―¿Jāchu lacasqui'na' na'ica'nāuj na'iccāxtlahuayāuj tū nahua'can cā'tani'? ");
INSERT INTO tkuNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Cāmacā'lh chā'tu' ī'scujnu'nī'n ē cāhuanilh: ―Capintit nac cā'lacchicni' ē namacla'yā'tit chā'tin chi'xcu' tī lē'mā'lh ixtlāmam. Nastālani'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Jā xla' natanū, nā natanū'yā'tit ē nahuaniyā'tit ixtēcu' chic: “Mākelhtahua'kē'ni' huaniyān: ¿Jā yālh cuarto jā tzē na'iccātā'hua'yān quiscujnu'nī'n tū hua'can cā'tani' pascua?” ");
INSERT INTO tkuNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Xla' nacāmāsu'yuni'yān a'ktin cuarto ixlīquilha'ktu chic. Ka'tla' cuarto ē cāxni'jtza' huī'lh. A'ntza' nacāxtlahua'yā'tit quilīhua'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ta'a'lh ī'scujnu'nī'n ē tatanūlh nac cā'lacchicni'. Kentaxtulh chuntza' chī Jesús ixcāhuaninī't ē tacāxtlahualh līhua'. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","A'cxni' ixtā'cnūmā'lhtza' chi'chini', Jesús cātā'chā'lh ī'scujnu'nī'n a'ntza'. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ixtahuā'yamā'nalhcus a'cxni' Jesús cāhuanilh: ―Ixlīcāna' iccāhuaniyān. Chā'tin chī hui'xina'n tī quilātā'huā'yamā'nauj, ū'tza' naquimacamāstā'. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Xlaca'n tatzuculh talīpuhuan ē chā'tunu' xlaca'n takelhasqui'nīlh: ―¿Ē quit? ");
INSERT INTO tkuNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús cākelhtīlh: ―Chā'tin chī hui'xina'n milīkelhacāujtu'ca'n ē ū'tza' tī quintā'pūhuā'yan tzamā' pulātu. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Quit Chi'xcu' xala' Tālhmā'n ē naquina'kspula chuntza' chī tatzo'kni' quimpālacata na ixtachihuīn Dios. Līlakalhu'mānat chi'xcu' tī naquimacamāstā'; nalīlīpuhuan. Ā'chulā' tze ixpālacata xla' palh jā ixtilacatuncuhuī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Līhuan ixtahuā'yamā'nalh, Jesús tayalh pāntzīn ē maxquī'lh tapāxcatca'tzīn Dios. A'cxni' che'kelh, cāmaxquī'lh ī'scujnu'nī'n ē cāhuanilh: ―Cahua'tit. Ū'tza' huā'mā' quimacni'. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tayalh vaso ē maxquī'lh tapāxcatca'tzīn Dios. Cāmaxquī'lh ī'scujnu'nī'n ē ixlīpō'ktuca'n tahua'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Cāhuanilh: ―Ū'tza' huā'mā' quinka'lhni'. Ū'tza' tū līcāxtlahuacan xasāsti' talacāxtlahuan chī Dios nacālīmakapūtaxtū tachi'xcuhuī't. Quinka'lhni' ū'tza' tū na'icmaka'n nacāmātza'nkēna'ni' tū jā tze tū tatlahualh tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ixlīcāna' tū iccāhuaniyān. Jātza' ā'maktin ictihua'lh xaxcān uva hasta a'cxni' na'icua' xtum xaxcān uva xasāsti' jā Dios māpa'ksīni'nkō'. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","A'cxni' ixtapixtlī'nī't a'ktin himno, tataxtulh ē ta'a'lh nac sipej jā huanican Olivos. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesús cāhuanilh: ―Milīpō'ktuca'n naquilā'a'kxtekmaka'nāuj ixpālacata tū naquina'kspula. Chuntza' tatzo'kni' na ixtachihuīn Dios: “Na'icmaknī pastor ē nata'a'kahuankō' purecu'.” ");
INSERT INTO tkuNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","A'cxni' naquimālacastālancuanīcan, xapūla na'ica'n quit nac estado Galilea. A'ntza' nalāpāxtokāuj. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro huanilh: ―Masqui ixlīpō'ktuca'n ā'makapitzīn nata'a'kxtekmaka'nān, quit jā ictimakxtekni'. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús huanilh: ―Ixlīcāna' tū icuaniyān. Chuhua'j huā'mā' tzī'sa a'cxni' jāna'j ā'ta'sa ixlīmaktu' puyux, hui'x naquinkelhtatzē'ka maktu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedro ā'chulā' lacatejtin huanli: ―Masqui naquintā'maknīca'na', quit jā ictikelhtatzē'kni'. Ixlīpō'ktuca'n ā'makapitzīn lacxtim tahuanli. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jesús ē ī'scujnu'nī'n ta'chā'lh jā huanican Getsemaní. Cāhuanilh: ―Catahui'la'tit hui'xina'n huā'tzā' līhuan quit na'icorarlī. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Cālē'lh lacapunchuna'j Pedro ē Jacobo ē Juan. Tzuculh tamakchuyī ē a'katuyunli. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Cāhuanilh: ―Iclīpuhuan hasta tzē na'iclaknī quintalīpuhuat. Catachokotit huā'tzā' ē skalalh catahui'la'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jesús a'lh lacapunchuna'j ē tatzokostalh nac ti'ya't ē squi'ni'lh Dios palh tzē ixa'kapūtaxtulh tū na'a'kspula ");
INSERT INTO tkuNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ē huanli: ―QuinTāta', palh tzē na'ica'kapūtaxtu tzamā' tū na'icpātī, camakxtekti chuntza' nala. Masqui na'icpātīni'n, calalh tū hui'x lacasqui'na' ē jā calalh tū quit iclacasqui'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Mimpālh jā ixcāmakxteknī't ī'scujnu'nī'n ē cālaktzī'lh ē ixtalhtatahui'lāna'lh. Huanilh Pedro: ―¿Ē lhtatahui'la', Simón? ¿Ē jāla tāyani'tit mintalhtataca'n nūn a'ktin hora? ");
INSERT INTO tkuNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Lakahuan catahui'la'tit ē casqui'ni'tit Dios jā nacāta'a'kskāhuī'yān a'cxni' nacātalīlaktzī'ncu'tunān. Ixlīcāna' masqui milīstacna'ca'n tatlahuacu'tun tū xatze, mimacni'ca'n jā taka'lhī lītli'hui'qui. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ixlīmaktu' a'lh lacapunchuna'j ē chu ū'tza' lacxtim squi'ni'lh Dios. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Taspi'tpālh jā ixcāmakxteknī't ī'scujnu'nī'n ē cālaktzī'lh ē ixtalhtatahui'lāna'lh. Jāla tatāyani'lh ixtalhtataca'n ē jā ixtaca'tzī chī natakelhtī. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","A'cxni' ixlīmaktu'tun taspi'tli a'ntza' jā ixcāmakxteknī't, cāhuanilh: ―¿Ē lhtatapā'na'ntitcus ē jaxpā'na'ntitcus? Tzetza'. Chuhua'j chilhtza' hora tū līlhcānancanī't. Quit Chi'xcu' xala' Tālhmā'n ē naquimacamāstā'can na ixmacanca'n tī jā tzeya chi'xcuhuī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Catāya'tit ē cāhuetza'; mimā'lhtza' tī naquimacamāstā'. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Palaj tunca a'cxni' Jesús ixcātā'chihuīna'mā'lhcus, chā'lh Judas. Xla' chā'tin ixlīkelhacāujtu' scujnu'nī'n ixuanī't. Tatā'chā'lh lhūhua' tachi'xcuhuī't ē ixtalē'n ixmachītaca'n ē qui'hui'. Talīchā'lh ixlīmāpa'ksīnca'n xanapuxcu'nu' pālejni' ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn ē xanapuxcu'nu' israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas ū'tza' tī ixmacamāstā'mā'lh ē xla' ixcāhuaninī'ttza' chī natalīlakapasa tīchu Jesús. Ixcāhuaninī't: ―Na'iclacamu'su chā'tin; ū'tza' Jesús. Nachi'payā'tit ē nalīpinā'tit ē namaktaka'lhā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","A'cxni' chā'lh Judas, palaj tunca laktalacatzuna'jīlh Jesús ē huanilh: ―Mākelhtahua'kē'ni'. Lacamu'sulh. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tachi'xcuhuī't tī tatā'milh talaktalacatzuna'jīlh Jesús ē tachi'palh natalē'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ixyālh chā'tin tī ixtā'minī't Jesús. Xla' māxtulh ixmachīta ē mātakāhuī'lh ixtasācua' xapuxcu' pālej ē a'kacā'yujulh ixa'ka'xko'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesús cākelhasqui'nīlh: ―¿Tū ixpālacata līta'ntit mimachītaca'n ē minqui'hui'ca'n? Hua'chi chi'pacu'tunā'tit chā'tin ka'lhāna'. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","A'cxni' xa'iccātā'latlā'huanān lakalīyān nac templo, ¿tū ixpālacata jāla quilāchi'pauj a'cxni'? Chuhua'j naquina'kspula ē namākentaxtū tū tzo'kcanī't na ixtachihuīn Dios ―cāhuanilh. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ixlīpō'ktuca'n scujnu'nī'n tatzā'lalh ē chuntza' talī'a'kxtekmaka'lh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Chā'tin ka'hua'cha stālani'lh. Jā ixlhakā'nī't ixlu'xu'; xmān ixlītapāchī'nī't a'ktin sábana. A'cxni' tachi'xcuhuī't tachi'palh, ");
INSERT INTO tkuNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","makalhalha tzā'lalh ē maka'lh sábana. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Xlaca'n tī tachi'palh Jesús, talē'lh jā ixuī'lh xapuxcu' pālej. Talaktakēstokli ixlīpō'ktuca'n xanapuxcu'nu' pālejni' ē xanapuxcu'nu' israelitas ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro laka makat stālani'lh ē chā'lh hasta ixtanquilhtīn ixchic xapuxcu' pālej. Tanūlh na ixcorralh chic ē cātā'tahuī'lh policías. Ixcātā'sko'huī'lh nac macscut. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Xanapuxcu'nu' pālejni' ē ixlīpō'ktuca'n xalaka'tla' māpa'ksīni'nī'n tī ixtaputzāna'nī, xlaca'n ixtaputzamā'nalh chī natalīmālacsu'yu Jesús natalīmāmaknīnīni'n. Jā ixtamacla tū tzē natalīmālacsu'yu. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Masqui līlhūhua' talīchihuīna'nli tū jā ixlīcāna' ixpālacata Jesús, jā lacxtim tahuanli. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Makapitzīn tatāyalh ē ta'a'ksa'nīni'lh ē tahuanli tū jā ixlīcāna'. Chuntza' tahuanli: ");
INSERT INTO tkuNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Quina'n ickexmatui chī huanli: “Quit na'icmālaksputūkō' ixlīpō'ktu huā'mā' xaka'tla' templo tū ixtatlaujca'n chi'xcuhuī'n. Ixlī'a'ktu'tun quilhtamacuj xtum na'ictlahua ā'a'ktin tū jā ixtatlaujca'n chi'xcuhuī'n.” ");
INSERT INTO tkuNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nūn xlaca'n jā lacxtim tahuanli. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Xapuxcu' pālej tāyalh na ixlacpu'na'i'tātca'n ē kelhasqui'nīlh Jesús: ―Huā' tayāna'lh chi'xcuhuī'n tamālacsu'yumā'na'n. ¿Ē jā nakelhtīni'na'? ");
INSERT INTO tkuNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús ca'cs tāyalh ē jā tū kelhtīni'lh. Xapuxcu' pālej kelhasqui'nīpālh: ―¿Ē hui'x Cristo tī Dios lacsacnī't? ¿Ē hui'x ī'Ska'ta' Dios tī quina'n iclakachi'xcuhuī'yāuj? ");
INSERT INTO tkuNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús kelhtīlh: ―Quit Cristo. Hui'xina'n naquilālaktzī'nāuj quit Chi'xcu' xala' Tālhmā'n na'ictahui'la na ixpekxtūcāna'j Dios tī māpa'ksīni'mā'lh. Na'icminācha' nac a'kapūn ixpu'nan poklhnu'. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Xapuxcu' pālej, xla' xtī'tli ixlu'xu' ē chuntza' līmāsu'yulh ixtasītzi' ē huanli: ―Jātza' iclacasqui'nāuj ā'chā'tin naquincāhuanipalayān jā tze xla'. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Hui'xina'n kexpa'tnī'ta'ntit chī mālakchā'ni'cu'tun Dios. ¿Chī puhua'nā'tit? Ixlīpō'ktuca'n tahuanli camaknīca. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Makapitzīn tatzuculh talakachojmanī. Xlaca'n talacatlapalh ē tatucsli ē tahuanilh: ―¡Calakapasti tīchu lacala'sni'! Soldados tī ixtamaktaka'lhmā'nalh nā xlaca'n tatucsli. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro ixyālh na ixtanquilhtīn chic ē milh chā'tin tzu'ma'jāt tī ī'scujmā'lh na ixchic xapuxcu' pālej. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","A'cxni' laktzī'lh Pedro jā ī'sko'huī'lh, tzu'ma'jāt lakalaktzī'lh ē huanilh: ―Nā hui'x ixtā'latlā'hua'na' Jesús xala' nac Nazaret. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Xla' kelhtatzē'kli ē huanilh: ―Jā iclakapasa ē jā icca'tzī tū huanicu'tuna'. A'lh lacapunchuna'j ē ta'salh puyux. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tzu'ma'jāt laktzī'mpālh ē tzuculh cāhuani tī ixtatā'yāna'ncha': ―Ū'tza' huā'mā' chā'tin chī xlaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedro kelhtatzē'kpālh. Ixlīka'tlā'tus tī ixtatā'yāna'ncha' tahuanilh Pedro: ―Ixlīcāna' hui'x chā'tin chī xlaca'n ixpālacata hui'x xala' nac estado Galilea. Mintachihuīn ixtā'chuntza' tī xala' nac Galilea. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pedro tzuculh lakapalacan ixa'cstu ē palha' huanli: ―Dios naquimakapātīnīn palh jā ixlīcāna' tū icuanimā'n. Jā iclakapasa huā'mā' chi'xcu' tī līchihuīna'mpā'na'ntit. ");
INSERT INTO tkuNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Puyux ta'sapālh ixlīmaktu'. Ū'tza' līmāpāstaquīlh Pedro chī Jesús ixuaninī't: “A'cxni' jā ā'ta'sa ixlīmaktu' puyux, hui'x naquinkelhtatzē'ka maktu'tun.” A'cxni' Pedro lacapāstacli chuntza', tzuculh calhuan. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","A'cxni' xkakalh, xanapuxcu'nu' pālejni' ē xanapuxcu'nu' israelitas ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn ē ā'makapitzīn māpa'ksīni'nī'n tatakēstokli ē tachihuīna'nli. Tapekechī'lh Jesús ē talē'lh ē tamacamaxquī'lh Pilato tī gobernador ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato kelhasqui'nīlh: ―¿Ē hui'x ixPuxcu'ca'n israelitas? Xla' kelhtīlh: ―Chuntza' chī hua'nī'ta'. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Xanapuxcu'nu' pālejni' ixtalīmālacsu'yu lhūhua' catūhuālh. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato kelhasqui'nīpālh: ―¿Tū ixpālacata jā tū tū kelhtīni'na'? Kexpa'tti ixlīpō'ktu tū talīmālacsu'yun. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesús jātza' kelhtīlh. Ū'tza' lī'a'cnīlh Pilato. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ixa'nan a'ktin tahui'lat a'cxni' ixlamā'lh cā'tani'. Pilato ixmakxteka chā'tin tachī'n. Tachi'xcuhuī't ixtalacsaca tachī'n tī namakxtekcan. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ixtatanūmā'nalh nac pūlāchī'n makapitzīn tī ixtamaknīni'nī't a'cxni' tatā'kaquī'lh. Chā'tin tachī'n ixuanican Barrabás. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Lhūhua' tachi'xcuhuī't talaktalacatzuna'jīlh Pilato ē tatzuculh tasqui'ni' catlahualh chuntza' chī ixuī'lh ixtahui'latca'n līhuan ixlamā'lh cā'tani'. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato cākelhtīlh: ―¿Ē lacasqui'nā'tit na'iccāmakxtekni'yān ixPuxcu'ca'n israelitas? ");
INSERT INTO tkuNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato ca'tzīlh chī xanapuxcu'nu' pālejni' quiclh ixtalaktzī'n Jesús ē ū'tza' talīmacamāstā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Xanapuxcu'nu' pālejni' ixtachihuīna'makasītzī'nī't tachi'xcuhuī't ē ū'tza' talīsqui'nli Barrabás. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato cākelhtīpālh ē cākelhasqui'nīlh: ―¿Tū lacasqui'nā'tit na'ictlahuani' tī māpācuhuī'yā'tit ixPuxcu'ca'n israelitas? ");
INSERT INTO tkuNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Xlaca'n tata'salh ē palha' tahuanilh: ―¡Caxtokohua'ca'ca nac cruz! ");
INSERT INTO tkuNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato cākelhasqui'nīlh: ―¿Tū ixpālacata? ¿Tūchu tlahuanī't xla' tū jā tze? Xlaca'n ā'chulā' tata'salh ē palha' tahuanilh: ―¡Caxtokohua'ca'ca nac cruz! ");
INSERT INTO tkuNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato ixcāmāko'xamixīcu'tun lhūhua' tachi'xcuhuī't, ē cāmakxtekni'lh Barrabás. Māpa'ksīni'lh camaksno'kca Jesús ē macamāstā'lh naxtokohua'ca'can. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Palaj tunca ī'soldados gobernador talē'lh Jesús nac pūchihuīn jā huanican pretorio. Cāmākēstokca ā'makapitzīn soldados. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Tamālhekē'lh a'ktin ixlu'xu' xasmanta'jua' ē talītlahualh lhtucu' a'ktin corona ē tamā'knūlh. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tatzuculh tahuani: ―¡Calakachi'xcuhuī'ca ixPuxcu'ca'n israelitas! ");
INSERT INTO tkuNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Talīcucni'cli qui'hui' ē talakachojmanīlh. Tatatzokostani'lh hua'chi ixtalakachi'xcuhuī'mā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","A'cxni' talīlītzī'nkō'lh chuntza', tamāmakxtulh ixlu'xu' xasmanta'jua' ē tamālhekē'pālh ixlu'xu' tū ixla' ixuanī't. Talē'lh naxtokohua'ca'can. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","A'cxni' ixta'a'mā'nalh, ixtētaxtumā'lh chā'tin chi'xcu' xala' nac Cirene tī ixuanican Simón. Xla' ixtāta'ca'n Alejandro ē Rufo ē ixmimā'cha' nac rancho. Soldados tasāmācu'quī'lh ixcruz Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ta'a'lh ē tachā'lh jā huanican Gólgota tū huanicu'tun Ixa'kxāk Nīn. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Jesús maxquī'ca vino nahua'. Ixtā'tlahuapāspi'tcanī't līcu'chu' tū huanican mirra. Ū'tza' ixlīmālhtatīcu'tuncan. Jesús jā maktīni'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","A'cxni' ī'xtokohua'ca'canī'ttza', soldados tamāpitzilh ixlu'xu' Jesús ē talīmāxtulh ī'suerteca'n nataca'tzī tūchu nacālakchā'n chā'tunu' xlaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Hua'chi makna'jāstza' tzi'saj ixuanī't a'cxni' xtokohua'ca'ca. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ixtzo'kcanī't tū ixpālacata līxtokohua'ca'ca ē ixuan chuntza': IxPuxcu'ca'n israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Nā cātā'xtokohua'ca'ca chā'tu' ka'lhāna'nī'n; chā'tunu' na ixcruzca'n, chā'tin na ixpekxtūcāna'j Jesús ē ā'chā'tin na ixpekxtūxuqui. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Chuntza' mākentaxtūca tū tzo'kcanī't na ixtachihuīn Dios jā huan: “Xla' cātā'pūtle'keca tī tatlahua tū jā tze.” ");
INSERT INTO tkuNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Xlaca'n tī ixtatētaxtumā'nalh talakapalalh ē tasakā'līlh ixa'kxākca'n ē tahuanilh: ―¡A! Hui'x ixlactlahua'cu'tuna' xaka'tla' templo ē ixyāhuapala' ixlī'a'ktu'tun quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Chuhua'j ca'a'kapūtaxtu milīmān ē cayujti nac cruz. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nā chuntza' xanapuxcu'nu' pālejni' ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn ixtalīlītzī'n Jesús ē ixtalāhuanimā'nalh: ―Xla' cāmakapūtaxtūlh ā'makapitzīn ē jāla a'kapūtaxtu ixlīmān. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Cayujli chuhua'j nac cruz Cristo tī ixPuxcu'ca'n israelitas. Nalaktzī'nāuj nayuja nac cruz ē chuntza' nalī'a'ka'ī'ni'yāuj. Xlaca'n tī ixcātā'xtokohua'ca'canī't nā talakapalalh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","A'cxni' tastu'nūttza' ixuanī't, cā'pucsua' huanli calhāxcuhuālh nac cā'ti'ya'tna' hasta maktu'tun kōtanū. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Hua'chi maktu'tun kōtanū Jesús palha' ta'salh ē huanli: ―Eloi, Eloi, ¿lama sabactani? (Ū'tza' huanicu'tun: QuinDios, quinDios, ¿tū ixpālacata quina'kxtekui'līnī'ta' quina'cstu?) ");
INSERT INTO tkuNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Takexmatli huā'mā' makapitzīn tī ixtayāna'ncha'. Xlaca'n talāhuanilh: ―Cakexpa'ttit. Xla' ta'sani'mā'lh a'kchihuīna' Elías. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tu'jnulh chā'tin ē līmāchū'huī'lh xaxcān vinagre nac a'ktin catūhuālh hua'chi panamāc. Cucchi'hui'līlh a'ktin qui'hui' ē quilhyāhualh Jesús nahua' ē huanli: ―Camakxtekui; nalaktzī'nāuj palh Elías namin namāyujū nac cruz. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesús palha' ta'salh ē palaj tunca nīlh. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Huā'mā' puntzuna' ka'tla' līlakamilīn xaka'tla' nac templo taxtī'tpūpitzilh ixquilhtūn xala' tālhmā'n hasta na ixtampān. Ū'tza' huā'mā' līlakamilīn tū ixmāpitzi templo. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Capitán romano ixyālh na ixlacatīn Jesús. A'cxni' laktzī'lh chī Jesús ta'salh ē nīlh, ē capitán huanli: ―Ixlīcāna' huā'mā' chi'xcu' ī'Ska'ta' Dios ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nā puscan ixtalaktzī'mā'nalh makat; na ixpu'nanca'n ixtayāna'lh María Magdalena ē Salomé ē María ixtzī'ca'n Jacobo xastancu ē José. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Xlaca'n ixtastālani'tlā'huan Jesús a'cxni' ixuī'lh nac estado Galilea ē ixtamaktāya. Nā ixtahui'lāna'lh ā'makapitzīn lhūhua' puscan tī ixcātā'minī't a'ntza' nac Jerusalén. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kōtanūtza' ixuanī't tzamā' quilhtamacuj tū ixpūcāxtlahuakō'can quilhtamacuj tū pūjaxcan. Ū'tza' ixlīlakalī ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Laka'lh Pilato chā'tin chi'xcu' xala' nac cā'lacchicni' Arimatea. Tzamā' chi'xcu' ixtacuhuīni' José ē ixka'lhīmā'lh hasta a'cxni' Dios namāpa'ksīni'nkō'. Xla' chā'tin ixmāpa'ksīni'nī'n israelitas tī ā'chulā' ixtamāpa'ksīni'n. Huā'mā' chi'xcu' ixlakachi'xcuhuī'can. Xla' ixlīmān tahuixcānīlh ē squi'ni'lh Pilato camaxquī'lh ixmacni' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato lī'a'cnīlh ixpālacata puhuanli jāna'j ixnī. Māta'satīnīni'lh capitán ē kelhasqui'nīlh palh ixlīcāna' ixnīnī'ttza' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","A'cxni' capitán māca'tzīnīlh ixnīnī'ttza', Pilato makxtekli José nalē'n ixmacni' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","José tamāhualh a'ktin xatze lu'xu'. A'cxni' ixmāyujūnī'ttza' ixmacni' Jesús, līmaksui'tli lu'xu' ē mānūlh a'ktin nac lhu'cu' tū ixcāxtlahuacanī'ttza' nac ka'tla' chihuix. Līmālacchahuani'ca a'ktin ka'tla' chihuix. ");
INSERT INTO tkuNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena ē María ixtzī' José talaktzī'lh jā ixmāpī'canī't ixmacni' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","A'cxni' ixa'kspulanī'ttza' quilhtamacuj tū pūjaxcan, María Magdalena ē María ixtzī' Jacobo ē Salomé tatamāhualh pomada tū xamu'csu natalīmactlahua ixmacni' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tzi'saj domingo a'cxni' tā'cxtulhcus chi'chini', ta'a'lh nac pūtā'cnūn ");
INSERT INTO tkuNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ē ixtalāhuani: ―¿Tīchu naquincāmāpānūni'yān chihuix tū līmālacchahuacanī't lhu'cu'? ");
INSERT INTO tkuNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","A'cxni' talaca'a'lh, talaktzī'lh ixmāpānūcanī'ttza' chihuix ē ka'tla' ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tatanūlh nac pūtā'cnūn ē talaktzī'lh chā'tin ángel tī ixtasu'yu hua'chi chi'xcu'. Ixuī'lh na ixa'cpucāna'j lhu'cu' ē stala'nka' ixlu'xu' ē pūlhmā'n ixuanī't. Xlaca'n tajicua'nli. ");
INSERT INTO tkuNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ángel cāhuanilh: ―Jā cajicua'ntit. Hui'xina'n putzapā'na'ntit Jesús xala' nac Nazaret tī ī'xtokohua'ca'canī't. Xla' jātza' huī'lh huā'tzā'; xla' lacastālancuana'nlitza'. Chā calaktzī'ntit jā ixmāpī'canī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Capintit ē cacāhua'ni'tit Pedro ē ā'makapitzīn ī'scujnu'nī'n Jesús. Nahua'ni'yā'tit xla' nacāpūlani'yān nac Galilea. A'ntza' natā'lāpāxtokā'tit chuntza' chī cāhuanin. ");
INSERT INTO tkuNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Puscan tataxtulh nac lhu'cu' ē tatzā'lalh. Ixtaxpipitēlha ē ixtalī'a'cnītēlha. Ixtajicua'n, ē jā tī chā'tin ixtahuani. ");
INSERT INTO tkuNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tzamā' domingo tzi'saj Jesús lacastālancuana'nli. Pūla tasu'yuni'lh María Magdalena tī ixmāxtuni'nī't kelhatojon jā tzeya ū'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","María cālakchā'lh xlaca'n tī ixcātā'latlā'huan Jesús. Ixtalīpuhuahui'lāna'lh ē ixtacalhuahui'lāna'lh. Cāmāca'tzīnīlh tū ixa'kspulanī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Masqui xlaca'n takexmatli chī ixlacastālancuana'nī't Jesús, ē chī María Magdalena ixlaktzī'nī't, xlaca'n jā ta'a'ka'ī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ā'līstān Jesús xtum cātasu'yuni'lh chā'tu' ī'scujnu'nī'n a'cxni' ixta'a'mā'nalh lacapunchuna'j nac tej. ");
INSERT INTO tkuNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Xlaca'n tataspi'tli ē tamāca'tzīnīlh ā'makapitzīn scujnu'nī'n, ē xlaca'n jā ta'a'ka'ī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ā'līstān huampala Jesús cātasu'yuni'lh kelhacāujtin scujnu'nī'n a'cxni' ixtahuā'yamā'nalh. Cālacaquilhnīlh ixpālacata jā ixta'a'ka'ī'cu'tun. Jā ta'a'ka'ī'lh chī tahuanli ixtalaktzī'nī't Jesús a'cxni' ixlacastālancuana'nī'ttza'. ");
INSERT INTO tkuNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jesús cāhuanilh: ―Capintit calhāxcuhuālh ē nacāmāsu'yuni'yā'tit xatze tachihuīn ixlīpō'ktuca'n tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Catīxcuhuālh tī na'a'ka'ī' xatze tachihuīn ixpālacata Jesucristo ē na'a'kpaxa, xla' namakapūtaxtūcan. Catīxcuhuālh tī jā na'a'ka'ī' xatze tachihuīn, xla' naka'lhīcus ixcuenta. ");
INSERT INTO tkuNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nalīlakapascan tī ta'a'ka'ī' xatze tachihuīn chuntza'. Natalīmāxtu jā tzeya ū'nī'n quilītli'hui'qui. Tzē natachihuīna'n xasāsti' tachihuīn. ");
INSERT INTO tkuNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Masqui catachi'palh lūhua' ē masqui catalīhua'lh catūhuālh tū ka'lhī tū laknīcan, jā catitalaknīn. Xmān nataxa'ma ta'jatatlanī'n ē xlaca'n natatzeyan. ");
INSERT INTO tkuNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","A'cxni' Māpa'ksīni' Jesús chuntza' ixcāhuaninī't ī'scujnu'nī'n, xla' tā'kayāhualh ē a'lh nac a'kapūn. Tahuī'lh na ixpāxtucāna'j Dios jā lakachi'xcuhuī'can. ");
INSERT INTO tkuNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Scujnu'nī'n ta'a'lh ē calhāxcuhuālh ixta'a'kchihuīna'n. Māpa'ksīni' ixcāmaktāya. Chuntza' tzē ixtalītlahua lī'a'cnīn. Ū'tza' ixlīca'tzīcan ixlīcāna' tū ixtamāsu'yumā'nalh. Amén.");
INSERT INTO tkuNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Lhūhua' tī tatzo'kli tū a'kspulalh na quilacpu'na'i'tātca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Tū quincātahuanin ixpālacata Cristo ē tū laktzī'nca xalītzucuni' hasta chuhua'j, ū'tza' tatzo'kli. Nā tī talaktzī'lh xalītzucuni' nā tamāsu'yulh. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nā chuntza' quiminī'ni'lh ictzo'knun. Makās līlacatejtin xa'iclīcāxtlahuamā'lh chī na'ictzo'knuni'yān, Teófilo, ");
INSERT INTO tkuNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ē chuntza' naca'tzīya' ixlīcāna' tū māsu'yunīcanī'ta'. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","A'cxni' Herodes rey ixuanī't nac Judea, ixuī'lh chā'tin pālej; ixtacuhuīni' Zacarías. Cātā'tapa'ksīlh pālejni' tī cāmāpācuhuīca Abías. Nā ixpuscāt Zacarías ixuanican Elisabet ē xla' ī'xū'nātā'nat Aarón. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ixchā'tu'ca'n tamākentaxtūlh ixlīmāpa'ksīn Dios ē jā tatlahualh tū jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Jā ixtaka'lhī ixlacstīnca'n ixpālacata Elisabet jāla ka'lhīlh ē nā lakkōlu'ntza' ixtahuanī't ixchā'tu'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Milh a'ktin quilhtamacuj a'cxni' Zacarías ē ixtā'pālejni' ixtatlahuamā'nalh ixtascujūtca'n na ixlacatīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ixtahui'latca'n ixtamāxtu suerte natalacsaca tī natanū nac templo nalhcuyu siyentzu ē ū'tza' līlacsaca Zacarías. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","A'cxni' ī'lhcuyumā'ca nac pūmacamāstā'n, ixlīpō'ktuca'n tī ixtatalacxtimīnī't tatachokolh nac tanquilhtīn ē ixta'orarlīmā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Palaj tunca tasu'yuni'lh Zacarías chā'tin ixángel Dios. Ixyālh ixpekcāna'j pūmacamāstā'n jā ī'lhcuyucan siyentzu. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","A'cxni' Zacarías laktzī'lh, tamakchuyīlh ē jicua'nli. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ángel huanilh: ―Zacarías, jā cajicua'nti. Dios kexmatli tū squi'nīnī'ta'. Mimpuscāt Elisabet naka'lhī ī'ska'ta' ē namāpācuhuī'ya' Juan. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nalīpāxuhua'ya' hui'x ē lhūhua' tachi'xcuhuī't natalīpāxuhua tzamā' ska'ta' ");
INSERT INTO tkuNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ixpālacata ka'tla' nalītaxtu na ixlacatīn Dios. Jā makstin catihua'lh cu'chu' nūn cerveza ē nūn pulhqui tū līka'chīcan. Nalītatzuma ixlīstacna' Espíritu Santo a'cxni' jā ixā'tahui'la. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nacālakpalīni' ixtalacapāstacni'ca'n lhūhua' israelitas ē chuntza' natatzucupala natakexmatni' Dios ixMāpa'ksīni'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Tzamā' chi'xcu' napūlani' Māpa'ksīni'. Naka'lhī ixespíritu ē ixlītli'hui'qui Elías. Nacāmālakpalīni' ixlīstacna'ca'n tachi'xcuhuī't ē chuntza' natapāxquī' ixlacstīnca'n. Xla' nacāmaxquī' xatze talacapāstacni' tī jā takexmata. Chuntza' natacāxtahui'la tachi'xcuhuī't a'cxni' namin Māpa'ksīni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías kelhasqui'nīlh ángel: ―¿Chī na'iclīca'tzī palh ixlīcāna' huā'mā'? Quit kōlu'tza' ē nā quimpuscāt lē'ntza' quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ángel kelhtīni'lh: ―Quit Gabriel ē icyālh na ixlacatīn Dios. Quimacamilh na'ictā'chihuīna'nān ē na'icmaxquī'yān huā'mā' xatze tachihuīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Chuhua'j hui'x nakō'ko'na'. Jāla catichihuī'na' hasta a'cxni' na'a'cchā'n ixmālhcuyu' miska'ta' ixpālacata jā quina'ka'ī'ni' quintachihuīn tū nakentaxtu a'cxni' nachā'n mālhcuyu'. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","A'cxni' tamakapalīlh Zacarías, tī ixtaka'lhīmā'nalh na ixtanquilhtīn templo talītamakchuyīlh jā palaj taxtulh. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","A'cxni' taxtulh, Zacarías jātza' la ixcātā'chihuīna'n. Ē ū'tza' talīca'tzīlh ixlakachuyanī't na ixpūchakān templo. Xmān ixcāmacahuani' ixpālacata jāla cātā'chihuīna'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","A'cxni' sputkō'lh ixtascujūt nac templo, Zacarías taspi'tli na ixchic. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ā'līstān ka'lhīni'lh Elisabet tī ixpuscāt ixuanī't. Jā taxtulh nac chic hasta ixlīlakaquitzis mālhcuyu'. Puhuanli: ");
INSERT INTO tkuNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Māpa'ksīni' chuntza' quintlahuani'nī't ixpālacata jātza' naquintalakmaka'n.” ");
INSERT INTO tkuNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ixka'lhītza' a'kchāxan mālhcuyu' a'cxni' Zacarías ixlakachuyanī't, ē Dios macamilh ángel Gabriel lacatin nac cā'lacchicni' jā huanican Nazaret. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Lakmilh chā'tin tzu'ma'jāt tī ixuanican María ē ixtā'lacāxlanī'ttza' natā'tamakaxtoka chā'tin chi'xcu' tī ixuanican José ē ī'xū'nātā'nat David. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ángel tanūlh jā ixuī'lh María ē huanilh: ―¡Iclakminān hui'x tī sicua'lanātlahuacanī'ta'! Māpa'ksīni' maktaka'lhāni'; Dios ā'chulā' sicua'lanātlahuanī'ta'n ē jā ixlīpō'ktuca'n puscan. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","A'cxni' María laktzī'lh ángel, lī'a'cnīlh huā'mā' tachihuīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ángel kelhtīlh: ―María, jā cajicua'nti; Dios pāxquī'yān. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Chuhua'j naka'lhīni'na' ē naka'lhī'ya' chā'tin ska'ta' ka'hua'cha. Namāpācuhuīya' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ka'tla' ixlacatzucut ē namāpācuhuīcan ī'Ska'ta' Dios tī ā'chulā' xaka'tla'. Māpa'ksīni' Dios nahui'lī ixlīpuxcu' chuntza' chī ixpap David ");
INSERT INTO tkuNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ē pō'ktu quilhtamacuj nacāmāpa'ksī israelitas. Ixlītli'hui'qui jā makstin catisputli. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Palaj tunca María kelhasqui'nīlh ángel: ―¿Chī līla quit? Jāna'j icā'tamakaxtoka. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ángel kelhtīlh: ―Espíritu Santo nalakminān ē ixlītli'hui'qui quinDiosca'n Xaka'tla' nalītamacsti'li'yān hua'chi poklhnu'. Ū'tza' nalī'a'nan tzamā' ska'ta' tī natahui'la xmān ixla' Dios nahuan ē namāpācuhuīcan ī'Ska'ta' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nā mintalakapasni' Elisabet nā naka'lhī ī'ska'ta' ka'hua'cha masqui lē'ntza' quilhtamacuj ē huancan jātza' catika'lhīlh ī'ska'ta'. Ka'lhītza' a'kchāxan mālhcuyu' chī ka'lhīni'n ");
INSERT INTO tkuNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ixpālacata Dios tzē natlahua ixlīpō'ktu catūxcuhuālh. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","A'cxni' María kelhtīlh ē huanilh: ―Quit ixla' Dios. Camākentaxtūlh ixtalacasqui'nīn. Calalh chuntza' chī quihua'ni'nī'ta'. Ángel a'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Milh a'ktin quilhtamacuj a'cxni' María taxtulh ē palaj tunca a'lh lacatin nac cā'lacchicni' xala' nac Judea. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tanūlh na ixchic Zacarías ē tā'chihuīna'lh Elisabet. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","A'cxni' Elisabet kexmatni'lh ixtachihuīn María, ska'ta' tasakā'līlh na ixpūlacni' Elisabet ē lītatzumalh Espíritu Santo ixlīstacna'. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","A'cxni' Elisabet chihuīna'nli palha' ē huanli: ―Dios ā'chulā' sicua'lanātlahuanī'ta'n hui'x ē jā ā'makapitzīn puscan ē nā sicua'lanātlahuanī't miska'ta'. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Tīchu quit naquilīlakmin ixtzī' quiMāpa'ksīni'? Quit jā tū quilacatzucut. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Xmān ickexmatli mintachihuīn ē quiska'ta' līpāxuhualh ē tasakā'līlh na quimpūlacni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Hui'x līpāxuhua'ya' ixpālacata a'ka'ī'nī'ta' ē namākentaxtū tū huaninī'ta'n Māpa'ksīni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Palaj tunca María huanli: Quilīstacna' makapāxuīmā'lh Māpa'ksīni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Quilīstacna' līpāxuhua ixpālacata quiMakapūtaxtūnu' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Dios cuenta quintlahuani'nī't quit tī ixtasācua' xcamanīn. Chuhua'j ē nā pō'ktu quilhtamacuj tachi'xcuhuī't natahuan iclīpāxuhua quit. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Dios tī ka'lhī lītli'hui'qui ka'tla' tū quintlahuani'nī't. Xla' xatasicua'lanātlahua. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Pō'ktu quilhtamacuj nacālakalhu'man tī talakachi'xcuhuī'. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ixlītli'hui'qui lītlahuanī't lhūhua' catūhuālh. Cāskāhuī'lh tī ka'tla' ixtamakca'tzī. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Cāmāpānūni'lh ixlītli'hui'quica'n tī ka'tla' ixtahuanī't ē tī tapuhuan ā'chulā' ixlacasqui'nca. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tī ixtatzi'ncsmā'nalh cālīmāka'sīlh xatze līhua' ē jā tū cāmacā'ni'lh lacricujnu'. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Cāmaktāyanī't xala' nac Israel tī tamākentaxtū ixtalacasqui'nīn Dios ē jā makstin makxtekli ixtalakalhu'man. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Chuntza' tlahualh chī cāhuaninī't quimpapca'n Abraham ē ixnatā'natna'. Pō'ktu quilhtamacuj nacāmaktāya. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María tahuī'lh na ixchic Elisabet a'ktu'tun mālhcuyu' ē ā'līstān taspi'tli na ixchic. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","A'cxni' a'cchā'lh ixmālhcuyu', tahuī'lh ī'ska'ta' Elisabet. Ka'hua'cha huanli. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ixamicujnu' ē ixtalakapasnī'n tamilh natatā'pāxuhua a'cxni' taca'tzīlh tze tū Dios tlahuani'lh Elisabet. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ixlīlakatzayan quilhtamacuj ta'a'lh tatlahua ixtahui'latca'n nachu'cucan ska'ta' ē ixui'līni'cu'tuncan ixtacuhuīni' Zacarías chī ixtāta'. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ixtzī' cāhuanilh: ―Jā chuntza' catihui'līca. Ixtacuhuīni' Juan nahuanican. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kelhasqui'nīca: ―¿Tū ixpālacata? Jā tī a'nan mintalakapasni' tī huanican Juan. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Palaj tunca tamacahuani'lh ixtāta' ska'ta' nataca'tzī tūyā tacuhuīni' nahui'līni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Xatāta' squi'nli a'ktin ca'psnap ē tzo'kli: “Ixtacuhuīni' Juan.” Ixlīpō'ktuca'n talī'a'cnīlh. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Palaj tunca Zacarías tzucupālh chihuīna'n ē laktaquilhpūtalh Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ū'tza' talī'a'cnīlh ixamicujnu' ē tahuankō'lh huā'mā' calhāxcuhuālh nac cā'lacchicni' xala' lakakēstīn nac Judea. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ixlīpō'ktuca'n tī takexmatli talacapāstacli ē talākelhasqui'nīlh: ―Huā'mā' ska'ta' ¿tīyā chi'xcu' nahuan? Ixtasu'yu ī'sicua'lanātlahuanī't Māpa'ksīni' ē ū'tza' talīhuanli. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Espíritu Santo lītatzumalh ixlīstacna' Zacarías ē chihuīna'nli chī Dios māsu'yuni'lh ē huanli: ");
INSERT INTO tkuNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Camakapāxuīca Māpa'ksīni' tī ixDiosca'n israelitas ixpālacata quincālakalhu'mani' quina'n tī ixraza ē quincāmakapūtaxtūn. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Quincāmaxquī'nī'ta'n chā'tin Makapūtaxtūnu'; ka'lhī ixlītli'hui'qui ē ū'tza' xla' chā'tin chī ixnatā'natna' David tī mākentaxtūlh ixtalacasqui'nīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Chuntza' chī huanli a'kchihuīna'nī'n xamakās, chuntza' līhui'līlh Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Huanli naquincālīmakapūtaxtūyān ixlītli'hui'qui quintā'lāquiclhlaktzi'ca'n ē ixlīpō'ktuca'n tī jā quincātalaktzī'ncu'tunān. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Huampālh nacālakalhu'mani' quimpapca'n ē jā napātza'nkā chī talācāxlanīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tzamā' talācāxlan tū Dios ixtlahuani'nī't quimpapca'n Abraham, ");
INSERT INTO tkuNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ū'tza' ixquincālīmāpānūni'n quintā'lāquiclhlaktzi'ca'n ē chuntza' ixtlahuáuj ixtalacasqui'nīn Dios ē jā ixjicua'nui. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Chuntza' pō'ktu quilhtamacuj lactze nahuanāuj nac cā'quilhtamacuj, hua'chi jā ixtitlahuáuj tū jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ē hui'x, quiska'ta', namāpācuhuīca'na' ixa'kchihuīna' Dios tī ā'chulā' xaka'tla' ē napūlani'ya' Māpa'ksīni' ē namālaclhtzaja jā na'a'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nacāmāsu'yuni'ya' tachi'xcuhuī't ē chuntza' natalīca'tzī namin Makapūtaxtūnu' ē nacāmātza'nkēna'ni' ixcuentaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Dios quincāpāxquī'yān ē quincālakalhu'manān. Ū'tza' quincālīmacamini'yān chā'tin tī naquincāmakapūtaxtūyān. Xla' namāxkakē quintejca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Quina'n hua'chi cā'pucsua' hui'lānauj ē hua'chi palajtza' nanīyāuj. Naquincāmāsu'yuni'yān chī ixtej Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Tzamā' ska'ta' stacli ē ixca'tzī ixlīpō'ktu catūxcuhuālh tū ixla' Dios. A'cxni' ka'tla'tza' huanli, ixuī'lh nac cā'tzaya'nca ti'ya't hasta a'cxni' tzuculh cāmāsu'yuni' israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","A'cxni' jāna'j ixtahui'la Jesús, emperador Augusto māpa'ksīlh a'ktin censo calhāxcuhuālh nac cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","A'cxni' Cirenio gobernador ixuanī't nac Siria a'cxni' pūla tlahualh censo. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ixlacasqui'nca chā'tunu' cata'a'lh na ixcā'lacchicni'ca'n jā ixtatahui'lanī't ixpapca'n ē a'ntza' nacātzo'kni'can ixtacuhuīni'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ū'tza' lītaxtulh José nac cā'lacchicni' Nazaret xala' nac estado Galilea ē a'lh a'ktin nac cā'lacchicni' Belén xala' nac estado Judea. A'ntza' xatahui'lani' David ē ixpālacata José ī'xū'nātā'nat ixuanī't, ixlacasqui'nca a'ntza' natzo'kcan ixtacuhuīni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","A'lh nac Belén natzo'kcan ixtacuhuīni'. Tā'a'lh María tī ixtā'lacāxlanī'ttza' natā'tamakaxtoka xla' ē xla' ixka'lhīni'ntza'. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Tū a'kspulalh a'cxni' ixuī'lh nac Belén, a'cchā'lh ixmālhcuyu' ska'ta'. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tahuī'lh ixka'hua'cha ixlīmaksāsti' María. Līpāchī'lh ixtanchut ē māpī'lh jā mojōcan paja tū tahua' cahuāyuj. A'ntza' ixtahuī'lh ixpālacata jā tamaclalh chic jā natamaklhtata. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ixtahui'lāna'lh pastores lacatzuna'j nac Belén. Pō'ktu tzī'sa ixtamaktaka'lhmā'nalh nac potrero ixpurecuca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Xamaktin tasu'yulh chā'tin ixángel Dios ē cālītamacsti'li'lh ixtaxkaket Māpa'ksīni'. Tajicua'nli. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ángel cāhuanilh: ―Jā cajicua'ntit. Iccālīmini'yān xatze tamāca'tzīni'n ē ū'tza' natalīka'lhī tapāxuhuān ixlīpō'ktuca'n tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Chuhua'j huā'mā' tzī'sa tahui'la'cha' chā'tin ska'ta' nac cā'lacchicni' jā ixtahui'lanī't David. Xla' ū'tza' Makapūtaxtūnu' ē tī huanican Cristo Māpa'ksīni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Namaclayā'tit chā'tin ska'ta' lītapāchī'nī't ixtanchut ē māpī'canī't jā mojōcan paja tū tahua' cahuāyuj. Ē ū'tza' nalīlakapasā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Xamaktin tatasu'yulh lhūhua' ángeles xalanī'n nac a'kapūn tī ixtamakapāxuīmā'nalh Dios. Tahualh: ");
INSERT INTO tkuNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","―¡Calaktaquilhpūtaca Dios tī huī'lh nac a'kapūn ē tzej calatapā'tit nac cā'quilhtamacuj milīpō'ktuca'n tī Dios cālakalhu'manī'ta'n! ");
INSERT INTO tkuNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Palaj tunca a'cxni' ángeles tataspi'tli nac a'kapūn, pastores tatzuculh talāhuani: ―Ca'auj chuhua'j nac Belén ē nalaktzī'nāuj tū a'kspulalh ē tū Māpa'ksīni' Dios quincātamāca'tzīnīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Palaj ta'a'lh ē cāmaclaca María ē José ē ska'ta' jā ixmāpī'canī't ē jā chī'yāhuacan cahuāyuj. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","A'cxni' talaktzī'lh, tahuanli tū ixtahuanī't ángeles ixpālacata ska'ta'. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ixlīpō'ktuca'n tī takexmatli talī'a'cnīlh ixtachihuīnca'n pastores. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","María ixlacapāstacmā'lh ixlīpō'ktu tū a'kspulanī't ē tū ixuanicanī't ē ixpuhuan. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Pastores tataspi'tli ē ixtalakachi'xcuhuī'mā'nalh Dios ē ixtamakapāxuīmā'nalh ixpālacata a'kspulalh chī cāhuanica. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ixlīlakatzayan quilhtamacuj tlahuani'ca circuncisión ska'ta' ē hui'līni'ca ixtacuhuīni' Jesús. Ū'tza' huā'mā' tacuhuīni' tū ángel huanilh María a'cxni' jāna'j ixka'lhīni'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ixlītu'pu'xam quilhtamacuj tamākentaxtūlh ixtahui'latca'n puscan chī Moisés ixui'līnī't līmāpa'ksīn natache'kē' ixlīka'hua'jua' puscāt. Talē'lh ska'ta' nac Jerusalén namāsu'yuni'can Māpa'ksīni' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Chuntza' tatlahualh ixpālacata tatzo'kni' na ixlīmāpa'ksīn Dios: Chā'tunu' ska'ta' xaka'hua'cha tī līmaksāsti', ū'tza' ixla' Māpa'ksīni' Dios nahuan. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Chuntza' María ē José ta'a'lh natalakatāyana'n. Chuntza' chī huan na ixlīmāpa'ksīn Dios ixlacasqui'nca namaxquī'can xaka'hua'cha ē xatzu'ma'jāt tórtola o tantu' tantzasnān. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ixuī'lh nac Jerusalén tzamā' quilhtamacuj chā'tin chi'xcu' tī ixuanican Simeón. Tzeya chi'xcu' ixuanī't ē ixlakachi'xcuhuī' Dios ē ixka'lhīmā'lh ixMakapūtaxtūnu'ca'n israelitas. Espíritu Santo ixtā'huī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ixmāsu'yuni'nī'ttza' jā ixtinīlh palh jā pūla ixlaktzī'lh Cristo tī Māpa'ksīni' Dios namacamin. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Espíritu Santo mālacpuhuanilh na'a'n nac templo a'cxni' līminca ska'ta' Jesús nac templo namākentaxtū ixtahui'latca'n ē tū māpa'ksīlh līmāpa'ksīn tū tzo'kli Moisés. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón cha'xli ska'ta' ē lakachi'xcuhuī'lh Dios ē huanli: ");
INSERT INTO tkuNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","QuiMāpa'ksīni', chuhua'j līpāxuhua na'icnī ixpālacata mākentaxtū'nī'ta' tū quihua'ni'nī'ta' quit tī mintasācua'. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Iclīlaktzī'nī'ttza' quilakastapun tzamā' Makapūtaxtūnu' ");
INSERT INTO tkuNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","tī hui'x māstā'nī'ta' ixpālacata ixlīpō'ktuca'n tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ū'tza' nacāmāsu'yuni' tī jā israelitas chī tzē natatlā'huan nac cā'quilhtamacuj chuntza' chī pūcās nacāmāxkakēni' tī talatlā'huan jā cā'pucsua'. Israelitas tī mintachi'xcuhuī't nacālakachi'xcuhuī'can ixpālacata xla'. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José ē ixtzī' Jesús talī'a'cnīlh tū huanli Simeón ixpālacata ska'ta'. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeón squi'ni'lh Dios cacāsicua'lanātlahualh ē huanilh María tī ixtzī' Jesús: ―Cala'ktzi'. Dios lacsacnī't huā'mā' ska'ta'. A'cxni' chi'xcu'tza' nahuan, lhūhua' israelitas nata'a'ka'ī' ē xla' nacāmaktāya. Tī jā nata'a'ka'ī', xlaca'n natalālīhuani. Xla' namāsu'yu ixtalacasqui'nīn Dios ē tachi'xcuhuī't natalakmaka'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Chuntza' naca'tzīkō'can chī lacapāstaca chā'tunu' na ixlīstacna'ca'n. Hui'x nalīpuhuana' chuntza' chī kentin machīta nalakpusa na milīstacna' ―huanli Simeón. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nā ixuī'lh a'ntza' chā'tin puscāt tī ixa'kchihuīna' Dios ē ixtacuhuīni' Ana. Xla' ixtzu'ma'jāt Fanuel xala' ixraza Aser. Ixlē'ntza' quilhtamacuj. Tzu'ma'jātcus ixuanī't a'cxni' tamakaxtokli ē tā'tahuī'lh ixkōlu' a'ktojon cā'ta. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Chuhua'j ixlītā'ti'pu'xamatā'ti' cā'ta tī nīmaka'ncanī't. Jā ixtaxtu xaka'tla' nac templo. Pō'ktu quilhtamacuj ixlaktaquilhpūtamā'lh Māpa'ksīni' Dios. Makatunu' jā ixuā'yan ixpālacata ixtlahua oración. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","A'cxni' José ē María tatanūlh xaka'tla' nac templo, huā'mā' puntzuna' Ana cālaktalacatzuna'jīlh. A'cxni' maxquī'kō'lh tapāxcatca'tzīn Dios, tzuculh līchihuīna'n ska'ta' tī huanican Jesús. Cālītā'chihuīna'nkō'lh tī ixtaka'lhīmā'nalh ixmakapūtaxtūnu'ca'n ē tī xalanī'n nac Jerusalén. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","A'cxni' José ē María tamākentaxtūlh ixlīpō'ktu tū māpa'ksīlh Moisés tū tzo'kli na ixlīmāpa'ksīn Dios, talē'mpālh ska'ta' nac Nazaret xala' nac Galilea ixcā'lacchicni'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ska'ta' ī'stacmā'lh ē ixtatli'hui'clhtēlha ē skalalh ixuantēlha ē Dios ā'chulā' ī'sicua'lanātlahua. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Cā'ta cā'ta José ē María ixta'a'n nac Jerusalén ixpālacata ixcā'tani'ca'n israelitas tū huanican pascua. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","A'cxni' Jesús ixka'lhī a'kcāujtu' cā'ta, ixlīpō'ktuca'n ta'a'lh nac Jerusalén ixpālacata cā'tani' chuntza' chī ixtalīsmanīnī'ttza'. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","A'cxni' a'ksputlitza' cā'tani' ē ixtaquītaspi'tmā'nalh ē Jesús tachokolh nac Jerusalén. Ixtzī' ē José jā cuenta tatlahualh. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ixtapuhuan Jesús cātā'mimā'lhtza' ā'makapitzīn ē chuntza' ta'a'lh nac tej a'ktin quilhtamacuj. A'cxni' taputzalh ixpu'nanca'n ixtalakapasnī'nca'n ē ixamicujca'n, ");
INSERT INTO tkuNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","jā tamaclalh. Palaj tunca tataspi'tli nac Jerusalén; ta'a'lh taputza. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ixlī'a'ktu'tun quilhtamacuj tamaclalh Jesús xaka'tla' nac templo. Ixcālaclhpu'nahuī'lh ixmākelhtahua'kē'ni'nī'n līmāpa'ksīn ē ixcākexmatmā'lh ē ixcākelhasqui'nīmā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ixlīpō'ktuca'n tī takexmatli talī'a'cnīlh ixtalacapāstacni' ē chī ixcākelhtīmā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","A'cxni' talaktzī'lh María ē José, talī'a'cnīlh ē ixtzī' huanilh: ―Quinka'hua'cha, ¿tū ixpālacata quilātlahuani'nī'ta'uj chuntza'? Quit ē mintāta' iclīpuhuamā'na'uj ē icmiuj iccāputzayān. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesús cāhuanilh: ―¿Tū ixpālacata quilāputzayāuj? ¿Ē jā ca'tzīyā'tit ixlacasqui'nca na'ictahui'la na ixchic quinTāta' Dios? ");
INSERT INTO tkuNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Xlaca'n jā taca'tzīlh tū huanicu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Palaj tunca xla' cātā'taspi'tli nac Nazaret ē cākexmatni'lh. Ixtzī' lhūhua' ixlacapāstaca ixlīpō'ktu huā'mā' ē māquī'kō'lh na ixlīstacna'. ");
INSERT INTO tkuNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús ī'stacmā'lh ē ā'chulā' ixka'lhīmā'lh talacapāstacni'. Nā tze ixuanī't na ixlacatīn Dios ē na ixlacatīnca'n tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ixlīlakacāujquitzis cā'ta ixuī'lh līgobernador Tiberio ē Poncio Pilato gobernador ixuanī't nac Judea. Herodes gobernador ixuanī't nac Galilea, ē ixtā'tin Felipe gobernador ixuanī't nac Iturea ē nac Traconite, ē Lisanias gobernador ixuanī't nac Abilinia. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás ē Caifás xamāpa'ksīni'nī'n pālejni' ixtahuanī't. A'cxni' ixlīpō'ktuca'n ixtamāpa'ksīni'mā'nalh, a'cxni' Dios tā'chihuīna'lh Juan ixka'hua'cha Zacarías tī ixuī'lh nac cā'tzaya'nca ti'ya't. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Juan a'lh na ixquilhtūn ka'tla' xcān Jordán. Cāhuanilh tachi'xcuhuī't ixtalakpalīlh ixtalacapāstacni'ca'n ē ixta'a'kpaxli nacāmātza'nkēna'ni'can ixcuentaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Huā'mā' a'kspulalh chī ixtzo'knunī't tzamā' ixa'kchihuīna' Dios tī ixuanican Isaías. Chuntza' tzo'kli: A'ntza' jā cā'tzaya'nca ti'ya't, nakexmatcan catīhuālh tī palha' nachihuīna'n ē nahuan: “Cacāxtlahua'tit tej ixpālacata mimā'lh Māpa'ksīni'. Camālakstu'nctit tej. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ixlīpō'ktu jā jā cāxtim natatzumana'n ē pūsca'nan nahuankō'. Jā lhka'hui'li' tej lacatza'j nala. Jā jā lakaxtim, lakaxtim nahuan. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ixlīpō'ktuca'n tachi'xcuhuī't natalaktzī'n tī Dios macamilh Makapūtaxtūnu'.” ");
INSERT INTO tkuNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","A'cxni' lhūhua' tachi'xcuhuī't tataxtulh ixpālacata Juan nacāmā'kpaxī, xla' cālacaquilhnīlh ē cāhuanilh: ―¡Hui'xina'n tlahua'pā'na'ntit a'ktu' milacanca'n! ¿Tīchu cāhuanin natzā'la'ni'yā'tit ixtasītzi' Dios tū mimā'lh? ");
INSERT INTO tkuNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Catlahua'tit tū tze; nalītasu'yu palh ixlīcāna' lakpalīnī'ta'ntit mintalacapāstacni'ca'n. Jā catihuantit mē'cstuca'n: “Quina'n ī'xū'nātā'natna' Abraham. Ū'tza' iclīpāhuanāuj ē jā icjicuani'yāuj ixtasītzi' Dios.” Jā chuntza' ixua'ntit. Quit iccāhuaniyān Dios tzē nacālakpalī huā'mā' chihuixni' ē natahuan ī'xū'nātā'natna' Abraham. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Hua'chi xacacanī'ttza' ā'chaj ē natzucucan natancā'can qui'hui'. Catūhuālh qui'hui' tū jā māstā' ixtahua'ca't xatze, ū'tza' natancā'can ē nalhcuyucan. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tachi'xcuhuī't takelhasqui'nīlh: ¿Tū na'ictlahuayāuj? ");
INSERT INTO tkuNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan cākelhtīlh: ―Tī ka'lhī a'ktu' ixcamisa camaxquī'lh a'ktin tī jā tū ka'lhī. Tī ka'lhī ixlīhua' catā'hua'lh tī jā tū ka'lhī. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nā tamilh mātā'jīni'nī'n nata'a'kpaxa ē takelhasqui'nīlh: ―Mākelhtahua'kē'ni', ¿tū na'ictlahuáuj quina'n? ");
INSERT INTO tkuNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan cākelhtīlh: ―Nasqui'nā'tit xmān tū ixtapalh līxokot. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Soldados nā takelhasqui'nīlh: ―Ē quina'n ¿tū ixlacasqui'nca na'ictlahuayāuj? Cākelhtīlh: ―Jā tilīmālacsu'yu'yā'tit tū jā ixlīcāna' ē jā tilītucsnu'nā'tit naka'lhā'na'nā'tit. Calīpāxuhua'tit mintatlajca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tachi'xcuhuī't ixtaca'tzīcu'tun ixpālacata Juan. Xlaca'n ixtapuhuamā'nalh palhāsā' Juan, ū'tza' Cristo tī Dios lacsacnī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Juan cāhuanilh: ―Ixlīcāna' quit iccālīmā'kpaxīyān xcān. Tī namin, xla' makapitzīn hui'xina'n nacātalīmā'kpaxīyān Espíritu Santo ē ā'makapitzīn macscut. Xla' ā'chulā' xaka'tla' ē jā quit. Quit jāla icmālakchā'nī chī xla'. Quit jā minī'ni' na'icxcutni' ixlīkechī'can ixcaclhi'. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Xla' chuntza' chī tī ka'lhī ixpūmālakosūn na ixmacan nalacsu'nu trigo tū tlahuacan harina. Nasaca trigo ē namāquī' nahua' ē paja nalhcuyu nac macscut tū jā mixa. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Chuntza' cāhuanilh Juan xatze tachihuīn ē nā cāmālacpuhuanīlh tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nā lacaquilhnīlh gobernador Herodes ixpālacata Herodías tī ixpuscāt ixuanī't ixtā'tin Felipe. Herodes ixka'lhī hua'chi ixpuscāt. Nā lacaquilhnīlh ixpālacata lhūhua' tū tlahualh tū jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ū'tza' Herodes līsītzī'lh ē ā'chulā' tlahualh ē Juan mānūca nac pūlāchī'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","A'cxni' Juan ixmā'kpaxīni'n, nā Jesús milh na'a'kpaxa. Līhuan ixorarlīmā'lh, a'kapūn talaquī'lh ");
INSERT INTO tkuNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ē mincha' Espíritu Santo. Tasu'yulh hua'chi lakatin tantzasnān ixyujmā'lh na ixlactza'j Jesús ē kexmatca a'ktin tachihuīn tū huanli: ―Hui'x quiSka'ta' ē icpāxquī'yān. Hui'x quimaxquī'ya' tapāxuhuān. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","A'cxni' Jesús tzuculh tlahua ixtascujūt, ixka'lhī chī pu'xamacāuj cā'ta. Huā'tzā' tatzo'kni' ixnapapana' Jesús. Ixpuhuancan Jesús ixka'hua'cha José. José ixka'hua'cha ixuanī't Elí ");
INSERT INTO tkuNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","tī ixka'hua'cha Matat tī ixka'hua'cha Leví. Leví ixka'hua'cha ixuanī't Melqui tī ixka'hua'cha Jana tī ixka'hua'cha José. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José ixka'hua'cha ixuanī't Matatías tī ixka'hua'cha Amós tī ixka'hua'cha Nahum tī ixka'hua'cha Esli tī ixka'hua'cha Nagai. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai ixka'hua'cha ixuanī't Maat tī ixka'hua'cha Matatías tī ixka'hua'cha Semei tī ixka'hua'cha José tī ixka'hua'cha Judá. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá ixka'hua'cha ixuanī't Joana tī ixka'hua'cha Resa tī ixka'hua'cha Zorobabel tī ixka'hua'cha Salatiel tī ixka'hua'cha Neri. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ixka'hua'cha ixuanī't Melqui tī ixka'hua'cha Adi tī ixka'hua'cha Cosam tī ixka'hua'cha Elmodam tī ixka'hua'cha Er. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er ixka'hua'cha ixuanī't Josué tī ixka'hua'cha Eliezer tī ixka'hua'cha Jorim tī ixka'hua'cha Matat. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat ixka'hua'cha ixuanī't Leví tī ixka'hua'cha Simeón tī ixka'hua'cha Judá tī ixka'hua'cha José tī ixka'hua'cha Jonán tī ixka'hua'cha Eliaquim. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim ixka'hua'cha ixuanī't Melea tī ixka'hua'cha Mainán tī ixka'hua'cha Matata tī ixka'hua'cha Natán. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán ixka'hua'cha ixuanī't David tī ixka'hua'cha Isaí tī ixka'hua'cha Obed tī ixka'hua'cha Booz tī ixka'hua'cha Salmón tī ixka'hua'cha Naasón. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón ixka'hua'cha ixuanī't Aminadab tī ixka'hua'cha Aram tī ixka'hua'cha Esrom tī ixka'hua'cha Fares tī ixka'hua'cha Judá. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá ixka'hua'cha ixuanī't Jacob tī ixka'hua'cha Isaac tī ixka'hua'cha Abraham tī ixka'hua'cha Taré tī ixka'hua'cha Nacor. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor ixka'hua'cha ixuanī't Serug tī ixka'hua'cha Ragau tī ixka'hua'cha Peleg tī ixka'hua'cha Heber tī ixka'hua'cha Sala. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala ixka'hua'cha ixuanī't Cainán tī ixka'hua'cha Arfaxad tī ixka'hua'cha Sem tī ixka'hua'cha Noé tī ixka'hua'cha Lamec. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec ixka'hua'cha ixuanī't Matusalén tī ixka'hua'cha Enoc tī ixka'hua'cha Jared tī ixka'hua'cha Mahalaleel tī ixka'hua'cha Cainán. ");
INSERT INTO tkuNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán ixka'hua'cha ixuanī't Enós tī ixka'hua'cha Set tī ixka'hua'cha Adán tī ixka'hua'cha Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ixlīstacna' Jesús ixlītzuma Espíritu Santo ē taspi'tli na ixquilhtūn nac xcān Jordán. Espíritu Santo lē'lh nac cā'tzaya'nca ti'ya't. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","A'ntza' ixuī'lh tu'pu'xam quilhtamacuj. Milh skāhuī'ni' nalīlaktzī'n palh tzē ixa'kskāhuī'lh Jesús. Jesús jā huā'yalh a'klhūhua' quilhtamacuj ē ixtzi'ncsmā'lhtza'. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Palaj tunca huanilh skāhuī'ni': ―Palh hui'x ī'Ska'ta' Dios, camāpa'ksi' tzamā' chihuix pāntzīn cahuanli. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús kelhtīlh: ―Tatzo'kni' na ixtachihuīn Dios: Jā xmān pāntzīn catilīlatamā'lh chā'tin chi'xcu' huā'tzā' nac cā'quilhtamacuj. Ā'chulā' cuenta natlahuacan ixtachihuīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Palaj tunca skāhuī'ni' lē'lh Jesús a'ktin nac sipej tālhmā'n. A'ntza' xamaktin māsu'yuni'kō'lh ixlīpō'ktu cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Huanilh: ―Na'icmaxquī'yān ixlīpō'ktu huā'mā' ē namāpa'ksīya'. Pō'ktu quila' ē nā tzē na'icmaxquī' catīxcuhuālh. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Palh hui'x naquintatzokostani'ya' ē naquilaktaquilhpūtaya', na'icmaxquī'kō'yān ixlīpō'ktu huā'mā' ē mila' nahuan. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesús kelhtīlh: ―Catapānu', Skāhuī'ni'. Tatzo'kni' na ixtachihuīn Dios: Natatzokostani'ya' ē nalaktaquilhpūtaya' miMāpa'ksīni' Dios ē natlahua'ya' xmān tū xla' lacasqui'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ā'līstān skāhuī'ni' lē'lh nac cā'lacchicni' Jerusalén ē yāhualh na ixa'kspūn xaka'tla' templo. Huanilh: ―Palh hui'x ī'Ska'ta' Dios, catamakahuasyujti nac ti'ya't. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tatzo'kni' na ixtachihuīn Dios: Dios nacāmāpa'ksī ixángeles natamaktaka'lhān. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Natamā'kaquī'yān ē chuntza' nūn kentin mintujan catitakāhuī'lh nac chihuix. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús kelhtīlh: ―Nā chuntza' tatzo'kni' na ixtachihuīn Dios: Jā tilīlaktzī'na' miMāpa'ksīni' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Skāhuī'ni' jātza' maclani'lh chī nalīlaktzī'n Jesús ē tapānūlh puntzuna'. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús taspi'tli nac Galilea ē ixka'lhī ixlītli'hui'qui Espíritu Santo. Calhāxcuhuālh nac estado Galilea ixlīchihuīna'mā'ca ixpālacata tū tlahualh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ixcāmāsu'yuni'mā'lh na ixtemploca'n israelitas ē ixlīpō'ktuca'n ixtalakachi'xcuhuī'mā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Palaj tunca Jesús taspi'tli nac cā'lacchicni' tū huanican Nazaret jā ī'stacnī't. Tanūlh nac templo a'ktin quilhtamacuj tū pūjaxcan chī ixlīsmanīcanī't. Tāyalh nalīkelhtahua'ka ixtachihuīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Maxquī'ca tū tzo'kli profeta Isaías. A'cxni' mālakapitzilh, maclalh jā ixtatzo'kni': ");
INSERT INTO tkuNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","IxEspíritu Māpa'ksīni' quintā'huī'lh ixpālacata quilacsacnī't na'iccāmāca'tzīnī xatze tachihuīn lacxcamanīnī'n. Nā quimacamilh na'iccāmāko'xamāka'tlī' tī talīpuhuan ē na'iccāmāxtu tī cāchī'canī't. Icmilh na'iccāmālacahuānī lakatzī'nī'n ē na'iccāmaktāya tī tapātīni'mā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nā quimacamilh na'iccāmāsu'yuni'yān ixquilhtamacuj Māpa'ksīni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","A'cxni' Jesús mālakachahualh libro, maxquī'lh chā'tin tī ixmaktaka'lhmā'lh templo ē tahuī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ixlīpō'ktuca'n nac templo ixtalaktzī'mā'nalh, ē xla' tzuculh chihuīna'n ē huanli: ―Chuhua'j huā'mā' quilhtamacuj mākentaxtūcanī't na milacatīnca'n tzamā' tū kexpa'ttitcus. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ixlīpō'ktuca'n tahuanli tze Jesús ē talī'a'cnīlh ixtachihuīn tzēhuanī't tū cāhuanilh. Ixtalāhuanimā'nalh: ―¿Ē jā ū'tza' ixka'hua'cha José? ");
INSERT INTO tkuNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús cāhuanilh: ―Ixlīcāna' naquilāhuaniyāuj huā'mā' tachihuīn: “Hui'x doctor ē pūla namā'tzeyīca'na' milīmān.” Nā naquilāhuaniyāuj: “Chuhua'j catlahua' huā'tzā' na minti'ya't chuntza' chī quincātahuanin tlahuanī'ta' nac Capernaum.” ");
INSERT INTO tkuNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Chihuīna'mpālh ē cāhuanilh: ―Ixlīcāna' iccāhuaniyān nūn tī chā'tin a'kchihuīna' tī nalaktzī'ncu'tuncan na ixcā'lacchicni' jā stacli. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ixlīcāna' tū iccāhuaniyān. Lhūhua' ixtahui'lāna'lh tī nīmaka'ncanī't nac país Israel a'cxni' ixlatlā'huan Elías ē a'cxni' a'ktu'tun cā'ta ā'i'tāt jā lalh xcān. Calhāxcuhuālh ixtzi'ncsnīmā'ca. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Dios jā cālakmacā'lh Elías jā tī chā'tin tī nīmaka'ncanī't xalanī'n nac Israel. Lakmacā'nca chā'tin xamini' nac Sarepta tū ixlacatzuna'j cā'lacchicni' Sidón. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nā chuntza' ixa'nan nac Israel lhūhua' tī ixtapātīnīmā'nalh ta'jatat tū makamasa quinquinītca'n ē a'cxni' ixui'lacha' a'kchihuīna' Eliseo. Jā tī chā'tin xlaca'n mātzeyīca, xmān Naamán tī chā'tin xamini' nac Siria. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","A'cxni' takexmatli huā'mā' tachihuīn, ixlīpō'ktuca'n tī ixtatanūmā'nalh nac templo tasītzī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tatā'kaquī'lh ē tatamacxtulh Jesús nac cā'lacchicni'. Talē'lh hasta na ixa'cpūn sipej nac cā'lacchicni' natamacā'n makjū. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jesús tētaxtulh ixpu'nanca'n ē a'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Palaj tunca Jesús a'lh nac Capernaum xala' nac estado Galilea. Ixcāmāsu'yuni'mā'lh tachi'xcuhuī't a'ktin quilhtamacuj tū pūjaxcan. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Talī'a'cnīlh chī ixcāmāsu'yuni'mā'lh ixpālacata ixlīchihuīna'mā'lh līmāpa'ksīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ixuī'lh nac templo chā'tin chi'xcu' tī ixchi'panī't jā tzeya ū'ni'. Ta'salh ē huanli: ");
INSERT INTO tkuNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Jesús xala' nac Nazaret, ¿tū ixpālacata quilālakmiuj? ¿Ē ū'tza' līta't naquilāmālacsputūyāuj? Quit iclakapasān. Hui'x ixla' Dios ē xatasicua'lanātlahua hui'x. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús lacaquilhnīlh jā tzeya ū'ni' ē huanilh: ―¡Caquilhca'csla! ¡Camakxtekti huā'mā' chi'xcu'! Jā tzeya ū'ni' māyujūlh chi'xcu' na ixlacatīnca'n tachi'xcuhuī't ē makxtekli chi'xcu'. Jā tū lani'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ixlīpō'ktuca'n talī'a'cnīlh ē talāhuanilh: ―¿Tuchūyā tachihuīn tzamā'? ¡Huā'mā' chi'xcu' līchihuīna'n līmāpa'ksīn ē cātamāxtulh jā tzeya ū'nī'n! ");
INSERT INTO tkuNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Calhāxcuhuālh na ixlacatzuna'j nac Capernaum talīchihuīna'nli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","A'cxni' Jesús taxtulh nac templo, a'lh ē tanūlh na ixchic Simón. Ixpuhuiti' Simón ixmacscutlamā'lh ē huanica Jesús camātzeyīlh. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesús taquilhpūtalh jā ixmā'lh ē lacaquilhnīlh ta'jatat ē tapānūni'lh chī ixmacscutla. Xamaktin tā'kaquī'lh puscāt ē tzuculh cāmāhuī'. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","A'cxni' ixtā'cnūmā'lhtza' chi'chini', ixlīpō'ktuca'n tī ixtata'jatatla kempālhūhua' ta'jatat cālīmini'ca Jesús. Cāmacaxa'malh ē cāmātzeyīlh. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Lhūhua' tī ixtaka'lhī jā tzeya ū'nī'n ē cāmātzeyīlh. A'cxni' jā tzeya ū'nī'n cāmāxtuni'lh na ixlīstacna'ca'n, tahuanilh: ―Hui'x ī'Ska'ta' Dios. Jesús cālacaquilhnīlh jā tzeya ū'nī'n ē jā cāmakxtekli natachihuīna'n ixpālacata xlaca'n taca'tzīlh ū'tza' Cristo tī Dios lacsacnī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","A'cxni' xkakalh, Jesús taxtulh nac cā'lacchicni' ē a'lh jā jā tī ixa'nan. Tachi'xcuhuī't ixtaputzamā'nalh ē tamaclalh jā ixuī'lh. Jā ixtamakxtekcu'tun ca'a'lh makat. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesús cāhuanilh: ―Ixlacasqui'nca na'iccāmāsu'yuni' xatze tachihuīn ā'makapitzīn xalanī'n ā'lacatin cā'lacchicni'. Na'iccāmāsu'yuni' chī Dios māpa'ksī. Ū'tza' quilīmacamilh. ");
INSERT INTO tkuNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Chuntza' ixcāmāsu'yuni'tēlha Jesús nac templos xalanī'n nac Galilea. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Milh a'ktin quilhtamacuj a'cxni' Jesús ixuī'lh na ixquilhtūn lago ixtacuhuīni' Genesaret. Lhūhua' tachi'xcuhuī't tamilh ē ixtalālacxquitimā'nalhtza' ixpālacata natalaktalacatzuna'jī Jesús. Ixtakexmatcu'tun ixtachihuīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesús cālaktzī'lh a'ktu' barcos na ixquilhtūn lago ē jā tī chā'tin ixpūtojōma'lh. Ixtēcu'ca'n ixta'a'nī't ixtache'kē' xaka'tla' ixpūtayanca'n tū pūchi'pacan squī'ti'. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Palaj tunca Jesús tahua'ca'lh a'ktin nac barco tū ixla' Simón ē huanli camātampūxtuca macsti'na'j na ixquilhtūn. Palaj tunca Jesús tahuī'lh nac barco ē a'ntza' tzuculh cāmāsu'yuni' tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","A'cxni' cāmāsu'yuni'kō'lh, huanilh Simón: ―Calī'pi huā'mā' barco jā pūlhmā'n ē camojō'tit mimpūtayanca'n napūchi'payā'tit squī'ti'. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón kelhtīlh: ―Mākelhtahua'kē'ni', tintascactza' icmojōmā'nauj ē jā tū icchi'panī'tauj. Masqui chuntza', palh hui'x quilāhuaniyāuj na'icmojōpalayāuj quimpūtayanca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","A'cxni' tatlahualh chuntza', lhūhua' squī'ti' talaknūcha' nac pūtayan ē ixtaxtī'tmā'lhtza'. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Palaj tunca tamacahuani'lh ixtā'chi'pananī'n squī'ti' a'ktin nac barco natamin natamaktāyana'n. Squī'ti' lītatzumalh a'ktu' barco hasta ixtatā'ctzicu'tuntza'. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","A'cxni' Simón Pedro laktzī'lh, tatzokostani'lh Jesús ē huanilh: ―Māpa'ksīni', caquintapānū'ni' ixpālacata quit jā tzeya chi'xcu'. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Chuntza' huanilh ixpālacata Simón ē ixlīpō'ktuca'n tī ixtatā'chi'pamā'nalh squī'ti' talī'a'cnīlh ixpālacata lhūhua' squī'ti' tū tachi'palh. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nā Jacobo ē Juan tī ixka'hua'chan Zebedeo ē tī ixtā'chi'pananī'n squī'ti' Simón nā xlaca'n tajicua'nli. Jesús huanilh Simón: ―Jā cajicua'nti. Chī mintascujūt ixuanī't milīchi'pana' squī'ti', chuhua'j mintascujūt nahuan nacāmā'a'ka'ī'nī'ya' tachi'xcuhuī't ixtachihuīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","A'cxni' tachā'lh barcos nac ti'ya't, palaj tunca ta'a'kxtekmaka'lh ixbarcoca'n ē tastālani'lh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","A'cxni' Jesús ixuī'lh nac cā'lacchicni', lakchā'lh chā'tin chi'xcu' tī ixka'lhī ta'jatat tū māmasī quinquinītca'n ē tū huanican lepra. A'cxni' ta'jatatlani' laktzī'lh Jesús, tatzokostani'lh ē huanilh: ―Māpa'ksīni', palh hui'x lacasqui'na', tzē naquimātzeyī'ya'. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Palaj tunca Jesús xa'malh ē huanilh: ―Chuntza' quit iclacasqui'n. Catzeya'nti. A'cxni' huanli huā'mā', tapānūni'lh ixta'jatat tzamā' chi'xcu'. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Palaj tunca Jesús māpa'ksīlh jā tī chā'tin catihuanilh. Huanilh: ―Xmān calakpi ixpālejca'n israelitas ē camāsu'yu'ni' mimacni'. Xla' nalaktzī'n palh tzeyanī'ta'tza'. Nalīlakatāyana'n chuntza' chī māpa'ksīni'lh Moisés. Chuntza' nataca'tzī tachi'xcuhuī't tzeyanī'ta'tza'. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Masqui Jesús huanilh jā tī chā'tin ixuanilh, ā'chulā' calhāxcuhuālh tachi'xcuhuī't takexmatli ixpālacata Jesús. Līlhūhua' ixtatakēstoka natakexmata ē ixpālacata ixcāmātzeyīni'ca ixta'jatatca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jesús tamakatīlh ē a'lh ā'lacatin jā jā tī ixa'nan ē a'ntza' tlahualh ixoración. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Milh a'ktin quilhtamacuj a'cxni' Jesús ixmāsu'yumā'lh ē ixtakexmatui'lāna'lh ā'makapitzīn fariseos ē tī xamākelhtahua'kē'ni'nī'n līmāpa'ksīn. Ixtaminī'ta'ncha' xalanī'n nac Jerusalén ē lhūhua' cā'lacchicni' xalanī'n nac Galilea ē Judea. Ixtasu'yu ixlītli'hui'qui Dios ixpālacata Jesús ixcāmātzeyīmā'lh ta'jatatlanī'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Palaj tunca a'cxni' tachā'lh tachi'xcuhuī't ē talīmilh nac talajni' chā'tin ta'jatatlani' tī ī'xcahuī'huananī't. Ixtamānūcu'tun ixpūchakān chic natamāpī' na ixlacatīn Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Lhūhua' ixtahuanī't tachi'xcuhuī't ē jāla ixtatanū nac chic. Ū'tza' talītahua'ca'lh ixa'kstīn nac chic ē ta'a'kstīxua'kli chic. A'ntza' talacmānūlh ixtalajni' ta'jatatlani' na ixpu'nanca'n tachi'xcuhuī't hasta na ixlacapūn Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","A'cxni' Jesús laktzī'lh chī ixta'a'ka'ī', xla' huanilh ta'jatatlani': ―Iccāmātza'nkēna'ni'yān ixlīpō'ktu mincuenta. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Palaj tunca fariseos ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn xlaca'n tatzuculh tapuhuan: “¿Tichūyā chi'xcu' tī mālakchā'nimā'lh Dios? Nūn chā'tin tzē naquincāmātza'nkēna'ni'yān quincuentaca'n, xmān Dios.” ");
INSERT INTO tkuNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesús ixca'tzī chī ixtapuhuamā'nalh ē cāhuanilh: ―¿Tū ixpālacata puhua'nā'tit chuntza' na milīstacna'ca'n? ");
INSERT INTO tkuNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Icuanilhtza' ta'jatatlani': “Iccāmātza'nkēna'ni'yān ixlīpō'ktu mincuenta.” Jā tū tasu'yu masqui mātza'nkēna'ni'catza'. Palh xa'icuanilh: “Catā'kaqui' ē casmi'li' mintalajni' ē catlā'hua'nti”, chuntza' nalītasu'yu palh ixlīcāna' tzeyanli. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Quit Chi'xcu' xala' Tālhmā'n. Chuhua'j na'iccālīmāsu'yuni'yān chī icka'lhī līmāpa'ksīn huā'tzā' nac cā'quilhtamacuj ē tzē na'iccāmātza'nkēna'ni' ixcuentaca'n tachi'xcuhuī't. Palaj tunca huanilh chi'xcu' tī ī'xcahuī'huananī't: ―Icuaniyān, catā'kaqui' ē casmi'li' mintalajni' ē capit na minchic. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Xamaktin tā'kaquī'lh ta'jatatlani' na ixlacatīnca'n ē sacli ixtalajni' ē a'lh na ixchic. Makapāxuītēlha Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ixlīpō'ktuca'n talī'a'cnīlh ē tamakapāxuīlh Dios. Nā tajicua'nli ē tahuanli: ―Huā'mā' quilhtamacuj laktzī'nī'tauj ka'tla' lī'a'cnīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ā'līstān Jesús taxtulh ē laktzī'lh chā'tin mātā'jīni'. Ixtacuhuīni' Leví ē ixuī'lh jā ixmātā'jīni'ncan. Huanica: ―Caquistāla'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Palaj tunca tāyalh ē makxtekkō'lh ē stālani'lh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ā'līstān Leví tlahualh a'ktin ka'tla' cā'tani' na ixchic nalakachi'xcuhuī' Jesús. Lhūhua' mātā'jīni'nī'n ē ā'makapitzīn chi'xcuhuī'n ixtatā'huā'yamā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Palaj tunca fariseos ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn tapuhuanli jā tze tū tlahualh Jesús. Tatzuculh tatā'chihuīna'n ī'scujnu'nī'n Jesús ē tahuanilh: ―¿Tū ixpālacata tā'huā'yanā'tit mātā'jīni'nī'n ē tī jā tzeya chi'xcuhuī'n? ");
INSERT INTO tkuNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús cākelhtīlh: ―Xlaca'n tī jā tata'jatatla, jā tamaclacasqui'n doctor. Xmān tī tata'jatatla tamaclacasqui'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Quit jā icmilh iccāputza tī tapuhuan xlaca'n lactze. Icmilh iccāputza tachi'xcuhuī't tī taca'tzī jā lactze xlaca'n ē chuntza' natalakpalī ixtalacapāstacni'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Palaj tunca xlaca'n takelhasqui'nīlh Jesús: ―Tī tastālani'lh Juan, jā tahuā'yan a'cxni' tatlahua ixoracionca'n. Nā chuntza' fariseos. Miscujnu'nī'n pō'ktu quilhtamacuj tahuā'yan ē tako'tnūn. ¿Tū ixpālacata? ");
INSERT INTO tkuNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús cākelhtīlh: ―¿Ē chā jā catitahuā'yalh tī cā'invitarlīca jā tamakaxtokmā'ca? Līhuan cātā'lahuī'lhcus squi'nīni', natahuā'yan. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Namin a'ktin quilhtamacuj a'cxni' nalē'ncan squi'nīni' ē a'cxni' jātza' catitahuā'yancu'tunli ixamigos. (A'cxni' Jesús cāhuanilh huā'mā', ixa'cstu ixlīchihuīna'mā'ca.) ");
INSERT INTO tkuNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nā chuntza' cāhuanilh tū līca'tzīni'can: ―Jā tī chā'tin nasita xasāsti' lu'xu' nalīlactza'pa' tū xamasni'. Palh chuntza' ixtlahuaca jātza' tze catihuanli xasāsti' lu'xu' ē xamasni' ā'chulā' nataxtī'ta. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Xaxcān uva tū jāna'j xcu'ta jā tī chā'tin catipūmojōlh xamasni' ixko'xka' purecu'. Namojōcan nac xasāsti' ko'xka' ē chuntza' a'cxni' naxcu'tan, jā catipankli ko'xka'. Chuntza' jā pāxcat catilalh ko'xka' ē jā catitaxtuni'lh xaxcān uva. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ū'tza' nalīmojōcan xasāsti' xaxcān uva nac xasāsti' ko'xka' ē a'cxni' naxcu'tan xaxcān uva, ko'xka' nataxta'nca ē jā catitaxtī'tli. ");
INSERT INTO tkuNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nā chuntza' xaxcān uva tū makāstza' xcu'tanī't, ā'chulā' cani ē jā xasāsti'. Tī nahua' xaxcu'ta jātza' catihua'cu'tunli xasāsti'. Nahuan: “Ā'chulā' tze xaxcu'ta.” ");
INSERT INTO tkuNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","A'ktin quilhtamacuj tū ixpūjaxcan a'cxni' Jesús ixtalatlā'huan nac cā'tacuxtu ē ī'scujnu'nī'n tatē'ī'lh pātu'yūn tza'ktza'. Palaj tunca tapa'sli ē tahua'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Makapitzīn fariseos cākelhasqui'nīlh: ―¿Tū ixpālacata scujpā'na'ntit huā'mā' quilhtamacuj tū pūjaxcan? Jā minī'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús cākelhtīlh: ―¿Ē jā līkelhtahua'kanī'ta'ntit tū tlahualh David a'ktin quilhtamacuj? Xla' ē tī ixtatā'a'mā'nalh ixtatzi'ncsmā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tanūlh na ixchic Dios ē tayalh pāntzīn tū ixlīlakatāyacanī't Dios. Hua'lh ē cātā'hua'lh tī ixtatā'a'mā'nalh, masqui jā minī'ni' nahua' catīhuālh chi'xcu', xmān pālej. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nā cāhuanilh: ―Quit Chi'xcu' xala' Tālhmā'n ē tzē na'icmāpa'ksīni' tū natlahuacan a'cxni' tzamā' quilhtamacuj tū pūjaxcan. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","A'ktin quilhtamacuj huampala tū pūjaxcan a'cxni' Jesús tanūlh na ixtemploca'n israelitas ē tzuculh māsu'yu. Ixuī'lh a'ntza' chā'tin chi'xcu' tī ixmacascācnī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Xamākelhtahua'kē'ni'nī'n līmāpa'ksīn ixtamaktaka'lhmā'nalh Jesús palh ixmātzeyīni'lh huā'mā' quilhtamacuj tū pūjaxcan. Chuntza' tzē ixtalīmālacsu'yulh. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Xla' ca'tzīlh tū ixtapuhuan ē huanilh chi'xcu' tī ixmacascācnī't: ―Catāqui' ē catāya' na quilacpu'na'i'tātca'n. Chi'xcu' tāquī'lh ē tāyalh a'ntza'. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Palaj tunca Jesús cāhuanilh: ―Na'iccākelhasqui'nīyān catūhuālh. ¿Tū ā'chulā' minī'ni' na'ictlahua tzamā' quilhtamacuj tū pūjaxcan? ¿Ē na'ictlahua tū tze o tū jā tze? ¿Ē na'icmakapūtaxtū chi'xcu' o na'icmaktī ixlīstacna'? ");
INSERT INTO tkuNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Palaj tunca Jesús cālaktzī'lh ixlīpō'ktuca'n tī ixtalītamacsti'li'nī't ē huanilh chi'xcu': ―Castu'ncti mimacan. Chi'xcu' stu'ncli ixmacan ē tzetza' ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Xlaca'n tasītzī'lh ē tatzuculh talālītā'chihuīna'n tū natatlahuani' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tzamā' quilhtamacuj Jesús a'lh a'ktin nac sipej na'orarlī. Pō'ktu tzī'sa ixorarlīmā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ixlīlakalī cāta'sani'lh ī'scujnu'nī'n ē cālacsacli kelhacāujtu' ē cāmāpācuhuīlh apóstoles. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Xlaca'n cāhuanican Simón tī ixlī'a'ktu' ixtacuhuīni' Pedro ē Andrés ī'stancu Simón ē Jacobo ē Juan ē Felipe ē Bartolomé ");
INSERT INTO tkuNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ē Mateo ē Tomás ē Jacobo ixka'hua'cha Alfeo ē Simón. Huā'mā' Simón ixtapa'ksīni' partido cananistas. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ē Judas ixtā'tin Jacobo ē Judas Iscariote tī ā'līstān macamāstā'lh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús cātā'yujli xlaca'n nac sipej ē tā'tachokolh ī'scujnu'nī'n jā pūsca'nan. Ixuī'lh lhūhua' tachi'xcuhuī't calhāxcuhuālh nac Judea ē xalanī'n nac Jerusalén ē xalanī'n ixquilhtūn mar lacatzuna'j jā ixuanican Tiro ē Sidón. Xlaca'n ixtachā'nī't natakexmata Jesús ixpālacata ixcāmātzeyīni'ca ixta'jatatca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Tī ixtaka'lhī jā tzeya ū'ni' nā cāmātzeyīca xlaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ixlīpō'ktuca'n tachi'xcuhuī't ixtaxa'macu'tun Jesús ixpālacata xla' cālīcu'chū'kō'lh ixlītli'hui'qui. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Palaj tunca Jesús cālaktzī'lh ī'scujnu'nī'n ē cāhuanilh: ―Pāxuhua'yā'tit tī jā ka'tla' makca'tzīyā'tit. Dios nacāmāpa'ksīyān. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Pāxuhua'yā'tit tī putzapā'na'ntit ixtalacasqui'nīn Dios. Xla' nacāmaktāyayān. ’Pāxuhua'yā'tit tī calhua'mpā'na'ntit chuhua'j. Ā'līstān napāxuhua'yā'tit jā Dios māpa'ksīni'nkō'. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Napāxuhua'yā'tit a'cxni' tachi'xcuhuī't jā cātalaktzī'ncu'tunān ē a'cxni' nacātamāxtumlī'yān quimpālacata quit Chi'xcu' xala' Tālhmā'n. Napāxuhua'yā'tit a'cxni' cātalakapalayān ē a'cxni' nacātalakmaka'nān ixpālacata natapuhuan jā tze hui'xina'n, ē ixlīpō'ktu quimpālacata quit Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Capāxuhua'tit ē caka'lhī'tit tapāxuhuān a'cxni' chuntza' napātīni'nā'tit. Nac a'kapūn naka'lhī'yā'tit pō'ktu tū tze. Tī cātamakapātīnīmā'n hui'xina'n, nā chuntza' ixnapapana'ca'n tamakapātīnīlh ixa'kchihuīna'nī'n Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Nalīpuhuanā'tit hui'xina'n lacricujnu' ixpālacata tlahua'tittza' mintapāxuhuānca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Nalīpuhuanā'tit hui'xina'n tī lhūhua' ka'lhī'yā'tit chuhua'j ixpālacata nacāmakasputāni'. ’Nalīpuhuanā'tit hui'xina'n tī lītzī'mpā'na'ntit chuhua'j. Ā'līstān mintalīpuhuātca'n nacāmakacalhuanān. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Nalīpuhuanā'tit hui'xina'n palh ixlīpō'ktu talakachi'xcuhuī'yān. Makāstza' chuntza' ixnapapana'ca'n ixtatlahuani' a'kchihuīna'nī'n tī tahuanli tū jā ixlīcāna'. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jesús cāhuanipālh: ―Iccāhuaniyān hui'xina'n tī quilākexmatāuj: Cacāpāxquī'tit mintā'lāquiclhlaktzi'ca'n ē nacāmaktāyayā'tit tī jā cālaktzī'ncu'tunān. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Casqui'ni'tit Dios cacāsicua'lanātlahualh tī cachīhuālh cātalīchihuīna'nān ē nacālī'orarlīyā'tit ixpālacataca'n tī cātalakapalayān. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Palh catīhuālh nalacala'sāni' na milacapīn, natamakxteka' ā'lacapī kentin nalacala'sāni'. Palh catīhuālh namāmakxtuyān minchamarra, camaxqui' masqui milu'xu'. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Camaxqui' catīxcuhuālh tī squi'ni'yān ē palh catīhuālh namāmakxtuyān tū mila', jātza' tisqui'ni'ya'. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Chuntza' natlahua'ni'ya' ā'chā'tin chuntza' chī lacasqui'na' xla' natlahua'ni'yān hui'x. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Palh hui'xina'n xmān cāpāxquī'yā'tit tī tapāxquī'yān, ¿ē tzeya chi'xcuhuī'n hui'xina'n na ixlacatīn Dios? Tī jā tze nā chuntza' talāpāxquī'. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Palh xmān cāmaktāyayā'tit tī tamaktāyayān hui'xina'n, ¿ē tzeya chi'xcuhuī'n hui'xina'n na ixlacatīn Dios? Lacxtim talāmaktāya tī jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Palh xmān namāsācua'nī'yā'tit tī tzē nacāmāsācua'nī'palayān, ¿ē tzeya chi'xcuhuī'n hui'xina'n na ixlacatīn Dios? Tī jā tze nā tamāsācua'nī tī ixtā'chuntza'ca'n ixpālacata taca'tzī namāstā'pala. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Hui'xina'n nacāpāxquī'yā'tit mintā'lāquiclhlaktzi'ca'n ē nacāmaktāyayā'tit ē nacāmāsācua'nī'yā'tit ē jā catiputzalh tū nacātalīxokonu'ni'yān. Chuntza' naka'lhī'yā'tit ka'tla' mintatlajca'n nac a'kapūn ē nalītaxtuyā'tit ixlacstīn tī xala' tālhmā'n ē tī ka'tla'. Nā xla' cālakalhu'man tampi'lhīni'nī'n ē tī jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Cacālakalhu'mantit tachi'xcuhuī't chuntza' chī minTāta'ca'n Dios nā cālakalhu'manān. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jesús cāhuanipālh: ―Jā ticāputzāna'ni'yā'tit ā'makapitzīn ē Dios jā nacāputzāna'ni'yān. Jā timakapātīnīni'nā'tit ē Dios jā caticāmakapātīnīn hui'xina'n. Nalāmātza'nkēna'ni'yā'tit ē Dios nacāmātza'nkēna'ni'yān. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Cacāmaxquī'tit ā'makapitzīn ē nā Dios nacāmaxquī'yān hui'xina'n. Xla' nacāmaxquī'yān chī tī tzej pūlhcāna'n ē nalacchiqui pūculhtila ē namātzuma hasta natakelhmaka'n ē namojō na mimurralhca'n. Lacxtim chī hui'xina'n namaxquī'yā'tit ā'chā'tin, chuntza' Dios nacāmaxquī'yān. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús cāhuanilh huā'mā' tū līca'tzīni'can: ―Chā'tin lakatzī'n ¿ē tzē napūlani' ixtā'lakatzī'n? ¿Ē jā catikostajōlh a'ktin nac lhu'cu'? ");
INSERT INTO tkuNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Chā'tin tī kelhtahua'kamā'lhcus jāla mālakchā'nī ixmākelhtahua'kē'ni'. A'cxni' nasca'tkō', tzē namālakchā'nī. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Chī tzē nalīlaktzī'na' macsti'na'j pa'lhxtum na ixlakastapun mintā'tin palh tanūmā'lh hua'chi a'ktin qui'hui' na milakastapun? ");
INSERT INTO tkuNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Palh jā pūla namāxtuya' qui'hui' na milakastapun, jāla catimaxtuni' pa'lhxtum na ixlakastapun mintā'tin. ¡A'kskāhuī'ni'na'! Pūla camāxtu' xaka'tla' pa'lhxtum na milakastapun ē chuntza' tzej nalaktzī'na' namāxtuya' macsti'na'j pa'lhxtum tū tanūmā'lh na ixlakastapun mintā'tin. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jesús cāhuanipālh: ―Jā tū xatze qui'hui' tū namāstā' ixtahua'ca't tū jā tze. Pūlactin qui'hui' tū jā tze jāla namāstā' xatze ixtahua'ca't. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Pūlactin qui'hui' līlakapascan ixtahua'ca't. Jāla pu'xcan higo nac lhtucu' qui'hui' ē jāla cāpu'xcan uvas cā'lhtucu'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tze nala tū nahuan tī tzeya chi'xcu' ixpālacata tze ixtalacapāstacni'. Jā tze tū nahuan tī jā tzeya chi'xcu' ixpālacata jā tze ixtalacapāstacni'. Chuntza' chī pō'ktu quilhtamacuj lacapāstaca, chuntza' nachihuīna'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jesús cāhuanipālh: ―Palh quilāmāpācuhuīyāuj: “Māpa'ksīni'”, ¿tū ixpālacata jā tlahua'yā'tit tū quit iccālīmāpa'ksīyān? ");
INSERT INTO tkuNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Tī namin naquinkexmatni' ē natlahua tū quilīmāpa'ksīn, na'iccāhuaniyān chī tasu'yu. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Xla' lītasu'yu hua'chi chā'tin chi'xcu' tī yāhualh ixchic. Pūla ponknu'lh pūlhmā'n ē tzej yāhualh ixtantūn. A'cxni' stacli ka'tla' xcān, snū'n tahui'lani'lh chic. Ē jā lacachiquilh ixpālacata tzej ixyāhuacanī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Tī quinkexmatni' ē jā natlahua tū quilīmāpa'ksīn, ū'tza' lītasu'yu hua'chi chā'tin chi'xcu' tī yāhualh ixchic ē jā pūlhmā'n ponknu'lh. A'cxni' stacli ka'tla' xcān ē snū'n tahui'lani'lh chic, a'kā'lh ē mū'xtulh ē laclakō'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","A'cxni' Jesús cāmāsu'yuni'kō'lh tachi'xcuhuī't, a'lh nac Capernaum. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","A'ntza' ixuī'lh chā'tin capitán xala' nac Roma. Ixka'lhī chā'tin ixtasācua' tī laktza' ixpāxquī'. Ū'tza' ta'jatatlalh hasta ixnīcu'tumā'lhtza'. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","A'cxni' capitán kexmatli līchihuīna'mā'ca Jesús, cāmacā'lh ā'makapitzīn māpa'ksīni'nī'n israelitas natahuani camilh ē camātzeyīlh ixtasācua'. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Xlaca'n talaktalacatzuna'jīlh Jesús ē tatzuculh tahuani: ―Minī'ni' ixmaktāya' huā'mā' capitán ");
INSERT INTO tkuNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ixpālacata quincālakachi'xcuhuī'yān quina'n israelitas. Ū'tza' mātlahuīni'lh quintemploca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Palaj tunca Jesús cātā'a'lh. A'cxni' lacatzuna'jtza' ixta'a'mā'nancha' ixchic capitán, cāmacā'lh ā'makapitzīn amigos natahuani Jesús: ―Māpa'ksīni', jā catamakchuyi'. Hui'x ka'lhī'ya' līmāpa'ksīn ē jā minī'ni' natanū'ya' nac quinchic. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ū'tza' iclīpuhuan palhāsā' jā minī'ni' chī icquīputzān. Xmān namāpa'ksī'ya' ē natzeyan quintasācua'. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nā quit quintamāpa'ksī xalaka'tla' ē quit iccāmāpa'ksī quisoldados. A'cxni' na'icuani chā'tin soldado ca'a'lh, xla' na'a'n. A'cxni' na'icuani ā'chā'tin camilh, xla' namin. A'cxni' na'icuani quintasācua' catlahualh catūhuālh, xla' natlahua tū icuani. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","A'cxni' Jesús kexmatli huā'mā' tachihuīn, lī'a'cnīlh ē cālaktalakspi'tli tī ixtastālani'tēlha ē cāhuanilh: ―Ixlīcāna' tū iccāhuaniyān. Jā iclakapasa nūn chā'tin israelita tī quina'ka'ī'ni' chī huā'mā' chi'xcu'. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","A'cxni' lacscujnī'n tataspi'tli nac chic, talaktzī'lh ixtzeyanī'ttza' tasācua'. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ā'līstān Jesús a'lh a'ktin nac cā'lacchicni' ixtacuhuīni' Naín ē cātā'a'lh ī'scujnu'nī'n ē līlhūhua'. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","A'cxni' lacatzuna'jtza' ixta'a'mā'nalh nac cā'lacchicni' ē laktzī'lh ixlīmimā'ca nīn namā'cnūcan. Ixtzī' ka'hua'cha tī ixnīnī't tanīmaka'tza' ixuanī't. Xmān chā'tin ixuanī't ixka'hua'cha. Līlhūhua' xalanī'n tzamā' cā'lacchicni' ixtatā'a'mā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","A'cxni' laktzī'lh tī tanīmaka'tza', Māpa'ksīni' lakalhu'manli ē huanilh: ―Jā cacalhua'nti. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Palaj tunca Jesús laktalacatzuna'jīlh ē xa'malh tū ixpūmā'lh. Tī ixtalē'mā'nalh tatāyalh. Jesús huanilh nīn: ―Ka'hua'cha, quit icuaniyān: ¡Catā'kaqui'! ");
INSERT INTO tkuNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Palaj tunca tā'kxpāquī'lh ē tahuī'lh tī ixnīnī'ttza' ē tzuculh chihuīna'n. Jesús macamaxquī'lh ixtzī'. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","A'cxni' talaktzī'lh huā'mā', tachi'xcuhuī't tajicua'nkō'lh ē tatzuculh talakachi'xcuhuī' Dios ē tahuanli: ―Tasu'yulh chā'tin ka'tla' a'kchihuīna' na quimpu'na'i'tātca'n. Nā tahuanli: ―Dios quincālakalhu'manān. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Calhāxcuhuālh nac Judea ē ixlacatzuna'jātna', ixlīpō'ktu taca'tzīlh tū tlahualh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ī'scujnu'nī'n Juan tamāca'tzīnīlh tū ixtlahuamā'lh Jesús. Palaj tunca cāta'sani'lh chā'tu' ī'scujnu'nī'n ");
INSERT INTO tkuNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ē cāmacā'lh natakelhasqui'nī Jesús palh ixlīcāna' xla' Cristo tī namin o palh nataka'lhī ā'chā'tin. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tzamā' chā'tu' ixlacscujnī'n Juan talakmilh Jesús ē tahuanilh: ―Juan Mā'kpaxīni' quincātalakmacamin ē ū'tza' ca'tzīcu'tun palh ixlīcāna' hui'x Cristo tī namin o palh na'icka'lhī'yāujcus ā'chā'tin. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Chū'tza' tzamā' puntzuna' Jesús cāmātzeyīlh lhūhua' ta'jatatlanī'n ē cāmāxtuni'lh lhūhua' jā tzeya ū'ni'. Nā lhūhua' lakatzī'nī'n cāmālacahuānīlh. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Chuntza' cākelhtīlh Jesús: ―Cataspi'ttit ē nahuaniyā'tit Juan tū laktzī'nī'ta'ntit ē tū kexpa'tnī'ta'ntit. Nahuaniyā'tit chī lakatzī'nī'n talacahuāna'n ē nā lū'ntu'nunī'n tatāya ē tatlā'huan. Nā tī ixcāmasni'mā'lh ixquinītca'n, xlaca'n tatzeyanli. Tī jā ixtakexmata chuhua'j takexmata ē nā cāmālacastālancuanīcanī't tī ixtanīnī'ttza'. Cāmāsu'yuni'can chī nacālīmakapūtaxtūcan tī talīpuhuamā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Līpāxuhua tī ta'a'ka'ī' chī Dios quimacamilh. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","A'cxni' ixta'a'nī't ixlacscujnī'n Juan, Jesús tzuculh cātā'chihuīna'n tachi'xcuhuī't ixpālacata Juan ē cāhuanilh: ―A'cxni' quīla'tit nac cā'tzaya'nca ti'ya't, ¿tīchu ixlaktzī'ncu'tunā'tit? ¿Ē ixlaktzī'ncu'tunā'tit chā'tin chi'xcu' tī hua'chi pūlactin pa'lhma' tū lacachiquilh ū'ni'? ");
INSERT INTO tkuNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Tū ixpālacata quīla'tit? Jā quīla'tit nalaktzī'nā'tit chā'tin chi'xcu' tī tzēhuanī't lhakā'nanī't. Hui'xina'n ca'tzīyā'tit tī pō'ktu quilhtamacuj tzēhuanī't talhakā'nanī't ē pō'ktu quilhtamacuj tapaxialhna'n, xlaca'n tahui'lāna'lh na ixchicca'n lacricujnu'. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Tū ixpālacata quīla'tit nac cā'tzaya'nca ti'ya't? ¿Ē jā quīla'tit nalaktzī'nā'tit chā'tin a'kchihuīna'? Ixlīcāna'. Ixlaktzī'ncu'tunā'tit chā'tin a'kchihuīna'. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Huā'mā' a'kchihuīna' ixtacuhuīni' Juan. Chuntza' tatzo'kni' na ixtachihuīn Dios ixpālacata Juan: Na'icmacā'n quina'kchihuīna' tī napūlani'yān nacāxmāpī' mintej. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Iccāhuaniyān na ixlacpu'na'i'tātca'n tachi'xcuhuī't jā tī chā'tin a'kchihuīna' ā'chulā' xaka'tla' chī Juan Mā'kpaxīni'. Tī ā'chulā' xastancu jā Dios māpa'ksīni'nkō', xla' ā'chulā' xaka'tla' ē jā Juan. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","A'cxni' takexmatli huā'mā' tachihuīn, ixlīpō'ktuca'n tachi'xcuhuī't ē mātā'jīni'nī'n tī Juan ixcāmā'kpaxīnī't, xlaca'n ixtalāhuani tze Dios ixpālacata tū ixcāhuaninī't Juan. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fariseos ē mākelhtahua'kē'ni'nī'n līmāpa'ksīn tī jā ixcāmā'kpaxīnī't Juan, xlaca'n talakmaka'lh tū Dios ixcātlahuani'cu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Māpa'ksīni' huanli: ―¿Chī na'iccālīmālakchā'nīyāuj chi'xcuhuī'n tī tahui'lāna'lh chuhua'j? ¿Chī tatasu'yu? ");
INSERT INTO tkuNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Tatasu'yu hua'chi lacstīn tī takamāna'mā'nalh nac lītamāuj. Ta'ta'sa ē tahuani ixtā'lacstīn: “A'cxni' quina'n icmakata'sauj līskoli', hui'xina'n jā lakatītit ē jā tlītit. A'cxni' icpixtlī'uj chī iclīlīpuhuanui, hui'xina'n jā lakatītit ē jā calhua'ntit. ¿Tūchu lacasqui'nā'tit?” tahuan. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","’Chuntza' līla'yā'tit hui'xina'n. Hua'nā'tit Juan Mā'kpaxīni' ka'lhī jā tzeya ū'ni' ixpālacata jā hua' pāntzīn ē jā ko'ta. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ā'līstān quit icmilh ē quit Chi'xcu' xala' Tālhmā'n. Quit icuā'yalh ē icua'lh xcān ē catūxcuhuālh quimālacnūni'ca. Hua'nā'tit quit laka iclihuā'yan ē laka iclīko'tnūn, quit ixamigoca'n mātā'jīni'nī'n ē tī jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tī ta'a'ka'ī', xlaca'n taca'tzī Dios macamilh Juan ē nā quit ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Chā'tin fariseo ixtā'huā'yancu'tun Jesús. Jesús a'lh na ixchic ē tahuī'lh nac mesa. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tzamā' nac cā'lacchicni' ixuī'lh chā'tin puscāt tī jā lacatejtin. A'cxni' ca'tzīlh Jesús ixa'nī't huā'yan na ixchic chā'tin fariseo, puscāt lē'lh a'ktin frasco aceite tū xamu'csu. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ixcalhuamā'lh ē a'cxni' tahuī'lh lacatzuna'j ixtujan Jesús ē yujli ixlakaxta'jat na ixtujan. Ū'tza' līche'kē'lh ixtujan Jesús. Palaj tunca līmāscāquīlh ixya'j ē tantūmu'sulh ē lītlahualh aceite tū mu'csun. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","A'cxni' laktzī'lh huā'mā', fariseo tī ixtā'huā'yamā'lh Jesús, puhuanli: “Palh ixlīcāna' cahuālh huā'mā' chi'xcu' ixa'kchihuīna' Dios ixuanī't, ixca'tzīlh tīchu xla' ē tichūyā puscāt xa'malh. Ixca'tzīlh palh jā tzeya puscāt.” ");
INSERT INTO tkuNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Palaj tunca Jesús huanilh fariseo: ―Simón, icuanicu'tunān a'ktin tachihuīn. Fariseo kelhtīlh: ―Mākelhtahua'kē'ni', caquihua'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús huanilh: ―Ixtahui'lāna'lh chā'tu' chi'xcuhuī'n. Ixchā'tu'ca'n ixtamaklaclē'n chā'tin māsācua'nīni'. Chā'tin maklaclē'lh quinientos denarios (tū tumīn xala' makāstza'). Ā'chā'tin maklaclē'lh tu'pu'xamacāuj. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Xlaca'n jāla taxokolh, ē māsācua'nīni' cāmāsputūnu'ni'lh ixchā'tu'ca'n. Chuhua'j caquihua'ni', ¿tīchu ā'chulā' napāxquī' chī ixchā'tu'ca'n? ");
INSERT INTO tkuNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón kelhtīni'lh: ―Icpuhuan chi'xcu' tī ā'chulā' ixmaklaclē'nī't. Jesús huanilh: ―Ixlīcāna'. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Palaj tunca Jesús laktalakspi'tli puscāt ē huanilh Simón: ―¿Ē laktzī'na' huā'mā' puscāt? Ictanūlh na minchic ē jā quimaxquī'nī'ta' xcān na'iclīlakche'kē' quintujan. Huā'mā' puscāt quilīlacmu'nulh ixlakaxta'jat na quintujan ē cālīmāscāquīlh ixya'j. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Hui'x jā quimacamu'sunī'ta' a'cxni' ictanūlh. Xla' jā jaxnī't chī quintantūmu'sumā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Hui'x jā quilītlahua' aceite na quina'kxāk; xla' quilītantūtlahualh ixperfume. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ū'tza' iclīhuaniyān lhūhua' ixtapāxquī'n puscāt ē ū'tza' līmāsu'yu chī Dios mātza'nkēna'ni'nī'ttza' ixcuenta masqui lhūhua'. Tī laka pāxquī'nin māsu'yu lhūhua' ixcuenta cāmātza'nkēna'ni'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Palaj tunca Jesús huanilh puscāt: ―Icmātza'nkēna'ni'yān mincuenta. ");
INSERT INTO tkuNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tī ixcā'invitarlīcanī't tatzuculh talāhuani: ―¿Tīchu huā'mā' chi'xcu' tī tzē cāmātza'nkēna'ni' quincuentaca'n? ");
INSERT INTO tkuNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesús huanilh puscāt: ―Makapūtaxtūcanī'ta'tza' ixpālacata a'ka'ī'nī'ta'. Capit cā'tapāxuhuān. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ā'līstān Jesús ixtētaxtumā'lh lacalhūhua' nac cā'lacchicni' ē nac ranchos. Ixmāsu'yutēlha ē ixcālītā'chihuīna'ntēlha chī Dios māpa'ksīni'nkō'. Kelhacāujtu' ī'scujnu'nī'n ixtatā'a'mā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nā ixtatā'a'mā'nalh ā'makapitzīn puscan tī ixcāmāxtuni'canī't jā tzeya ū'ni' ē tī ixcāmātzeyīcanī't ixta'jatatca'n. Na ixpu'na'i'tātca'n ixa'mā'lh María tī ixlīkempātu' ixtacuhuīni' Magdalena. Ū'tza' tī cāmāxtuni'ca kelhatojon jā tzeya ū'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nā ixtā'a'n Juana, ixpuscāt Chuza tī xapuxcu' ixtasācua' Herodes. Nā ixtatā'a'mā'nalh Susana ē lhūhua' ā'makapitzīn puscan tī ixtalīmaktāyanī't ixtumīnca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Xalanī'n lacalhūhua' cā'lacchicni' tataxtulh natakexmata Jesús. A'cxni' tatalacxtimīlh lhūhua' tachi'xcuhuī't, cāhuanilh tū līca'tzīni'can. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Cāhuanilh: ―Chā'tin cha'nāna' taxtulh nacha'nan ixlīcha'nat. Līhuan ixmakahuanimā'lh ixlīcha'nat makapitzīn tayujli nac tej ē cālacchi'ntaca ē tasacua'lh spūnī'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ā'makapitzīn tayujli na ixkelhni' chihuix jā xmān macsti'na'j ixka'lhī ti'ya't. A'cxni' pu'nli tzamā' līcha'nat jā maclalh xcān ē scācli ixpālacata jā pūlhmā'n ixka'lhī ti'ya't. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ā'makapitzīn huampala tayujpālh nac cā'lhtucu'n ē jāla stacli ixpālacata tamā'ktzī'lh lhtucu'. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ā'makapitzīn līcha'nat tayujli nac tze ti'ya't ē pu'nli. A'cxni' stacli, tahua'ca'lh. A'cxni' ī'ca, lhūhua' taxtulh xmān pūlactin līcha'nat tū ixmakahuanicanī't hasta a'ktin ciento tahua'ca'lh. A'cxni' huankō'lh huā'mā' Jesús cāhuanilh palha': ―Palh kexpa'tā'tit, cuenta catlahua'tit. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Palaj tunca ī'scujnu'nī'n takelhasqui'nīlh tūchu huanicu'tun huā'mā' tamāsu'yun. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Cāhuanilh: ―Dios cāmāsu'yuni'nī'ta'n hui'xina'n tū tatzē'knī't ixpālacata chī nala jā Dios māpa'ksīni'nkō'. Ā'makapitzīn iccālīchihuīna'n xmān tū līca'tzīni'can. Chuntza' masqui takexmatli jā catitaca'tzīlh tū huanicu'tun, ē masqui talaktzī'n ē hua'chi jā talacahuāna'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jesús cāhuanipālh: ―Huā'mā' tamāsu'yun huanicu'tun chuntza': līcha'nat, ū'tza' ixtachihuīn Dios; ");
INSERT INTO tkuNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ē tej, ū'tza' hua'chi tachi'xcuhuī't tī takexmata tachihuīn. Namin skāhuī'ni' ē nacāmāpātza'nkēnī ē jā catita'a'ka'ī'lh ē jāla catita'a'kapūtaxtulh. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ti'ya't nac cā'chihuixni', ū'tza' hua'chi ā'makapitzīn tachi'xcuhuī't. Xlaca'n takexmata ē tapuhuan tze, ē talakatī. Jā makās ta'a'ka'ī'. A'cxni' jā cālaktzī'ncu'tuncan ixpālacata ixtachihuīn Dios, palaj natamakxteka. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","’Huā'mā' lhtucu', ū'tza' hua'chi ā'makapitzīn huampala tachi'xcuhuī't. Masqui takexmata tachihuīn, jā talakpalīcu'tun ixtalacapāstacni'ca'n. Pō'ktu quilhtamacuj talacapāstacmā'nalh ixtascujūtca'n ē ixtumīnca'n ē chī natalakastāna'n. Chuntza' jāla tzej tasca'ta. Ū'tza' hua'chi līcha'nat tū tamā'ktzī'lh lhtucu'. Jāla staca. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","’Tū yujli nac xatze ti'ya't, ū'tza' hua'chi tachi'xcuhuī't tī tzej takexmatli tachihuīn. Ta'a'ka'ī' ē takexmatni' ē tzeya chi'xcuhuī'n natahuan. Jā tamakxteka ixtachihuīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesús cāhuanipālh: ―Jā tī māpasī pūcās ē nahui'lī ixtampīn chā'xta. Ē nūn catihui'līca ixtampīn tama'. Namāhua'ca'can tālhmā'n ixpālacata tī tatanūmā'nalh natalaktzī'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ixlīpō'ktu tū iccāmāsu'yuni'yān mina'cstuca'n, ā'līstān ixlacasqui'nca nacāmāsu'yuni'yā'tit ā'makapitzīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Chuntza' tzej cakexpa'ttit ixpālacata tī tzej a'ka'ī'ni' ixtachihuīn Dios, ū'tza' ā'chulā' naca'tzī; ē tī jā tzej a'ka'ī'ni' ixtachihuīn Dios, xla' namāpātza'nkēnīcan tū kexmatli. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Palaj tunca tamilh ixtzī' ē ixtā'timīn jā ixuī'lh Jesús ē jāla talaktalacatzuna'jīlh ixpālacata līlhūhua' tachi'xcuhuī't ixuī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Huanica Jesús: ―Talayāna'lh mintzī' nac kēpūn ē mintā'timīn. Tatā'chihuīna'ncu'tunān. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Xla' cāhuanilh: ―Tī kexmata ixtachihuīn Dios ē mākentaxtū, ū'tza' quintzī' ē quintā'timīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Milh a'ktin quilhtamacuj a'cxni' Jesús cātā'tojōlh ī'scujnu'nī'n a'ktin nac barco. Cāhuanilh: ―Ca'auj tuntacut nac xcān. Ta'a'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Līhuan ixtatacutmā'nalh, lhtatalh Jesús. Palaj tunca tzuculh ū'nun ē ixlītatzumamā'lhtza' xcān barco hasta ixtā'cnūmā'lhtza'. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Palaj tunca ta'a'lh tamālakahuānīlh Jesús ē tahuanilh: ―¡Mākelhtahua'kē'ni'! ¡Icjicsua'mā'nauj! Palaj tunca Jesús tā'kaquī'lh ē cālacaquilhnīlh ū'ni' ē ixpupunu' xcān, ē taca'csnankō'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Palaj tunca cāhuanilh ī'scujnu'nī'n: ―¿Chī līla'tit? ¿Ē jā a'ka'ī'yā'tit? Xlaca'n tajicua'nli ē talī'a'cnīlh ē talākelhasqui'nīlh: ―¿Tichūyā chi'xcu' huā'mā'? Hasta tzē cāmāpa'ksī ū'ni' ē xcān ē takexmatni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ā'līstān tachā'lh nac ti'ya't jā huanican Gadara. A'ntza' ixtuntacut nac xcān ē na ixlaktza'j Galilea. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","A'cxni' Jesús tacutli nac barco, chā'tin chi'xcu' xala' a'ntza' laktalacatzuna'jīlh. Makās xla' ixcāka'lhī tū jā tzeya ū'nī'n. Jā maktin lhakā'lh ixlu'xu' ē jā tahuī'lh nac chic. Xmān nac lhu'cu' ixtahui'la. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","A'cxni' chi'xcu' laktzī'lh Jesús, tatzokostani'lh na ixlacatīn ē ta'salh ē huanli: ―¿Tū ixpālacata ta'na' hui'x jā icuī'lh? Hui'x Jesús ī'Ska'ta' Dios xaka'tla'. ¿Ē mincuenta tū ictlahuamā'lh? Icsqui'ni'yān jā naquintimakapātīnīna'. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Chuntza' huanilh ixpālacata Jesús ixmāpa'ksīmā'lh jā tzeya ū'ni' cataxtuni'lh. Maklhūhua' chi'palh jā tzeya ū'ni'. Ixlīmacachī'can cadenas ē nā ixlītantūchī'can cadenas ē xla' ixcālacpu'xa. Jā tzeya ū'ni' makatzā'lalh nac cā'tzaya'nca ti'ya't. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús kelhasqui'nīlh: ―¿Chī hua'ni'ca'na'? Xla' kelhtīlh: ―Quihuanican Legión. Chuntza' huanilh ixpālacata Legión huanicu'tun lhūhua', ē lhūhua' jā tzeya ū'nī'n ixtatanūni'nī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Huā'mā' jā tzeya ū'nī'n tasqui'ni'lh Jesús jā cacāmacā'lh nac pūpātīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Lhūhua' pa'xnī'n ixtahuā'yamā'nalh na ixlacapūn sipej. Jā tzeya ū'nī'n tasqui'nli cacāmakxtekca natatanū na ixpūlacni'ca'n pa'xnī'n ē Jesús cāmakxtekli. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Palaj tunca jā tzeya ū'nī'n tataxtunikō'lh chi'xcu' ē tapūlactojōlh na ixpūlacni'ca'n pa'xnī'n. Xlaca'n tatamakjūlh nac cā'lacatampān ē tatamakahuasli ē tatojōcha' nac xcān ē tajicsua'kō'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","A'cxni' maktaka'lhna'nī'n pa'xni' talaktzī'lh tū ixa'kspulanī't, tajicua'nli ē tatu'jnulh ē tamāca'tzīnīni'lh nac cā'lacchicni' ē ixlacatzuna'j huā'mā' cā'lacchicni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tachi'xcuhuī't tataxtulh nac cā'lacchicni' natalaktzī'n tū ixa'kspulanī't. A'cxni' tachā'lh jā ixuī'lh Jesús, talaktzī'lh chi'xcu' tī jātza' ixka'lhī jā tzeya ū'ni'. Ixcāmāxtuni'nī'ttza' jā tzeya ū'nī'n ē chi'xcu' ixmālhekē'canī'ttza' ē ca'cs ixuī'lh lacatzuna'j ixtujan Jesús. Xlaca'n tajicua'nli. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tī ixtalaktzī'nī't tahuanilh chī ixlītzeyanī't chi'xcu' tī ixka'lhī jā tzeya ū'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Chuntza' ixlīpō'ktuca'n xalanī'n nac Gadara tatzuculh tasqui'ni' Jesús nataxtu a'ntza' ixpālacata tajicua'nli. Chuntza' Jesús tojōlh nac barco ē a'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Masqui chi'xcu' tī ixtzeyanī'ttza' squi'ni'lh Jesús camakxtekli natā'a'n, Jesús māpa'ksīlh catahuī'lh ē huanilh: ");
INSERT INTO tkuNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Cataspi'tti na minchic. Nacāhua'ni'kō'ya' ka'tla' tū tlahuani'nī'ta'n Dios ē chī a'kspulanī'ta'n. Chi'xcu' a'lh ē tzuculh līchihuīna'n tū ixtlahuani'nī't Jesús calhāxcuhuālh nac cā'lacchicni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","A'cxni' Jesús taspi'tpālh, tachi'xcuhuī't talaktzī'lh ē tapāxuhualh ixpālacata ixlīpō'ktuca'n ixtaka'lhīmā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Palaj tunca milh chā'tin chi'xcu', ixtacuhuīni' Jairo ē xapuxcu' ixuanī't na ixtemploca'n israelitas. Xla' tatzokostani'lh Jesús. Huanilh ca'a'lh na ixchic ");
INSERT INTO tkuNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ixpālacata xmān chā'tin ixtzu'ma'jāt ē ixnīmā'lhtza'. Ixka'lhī chī a'kcāujtu' cā'ta. A'cxni' ixa'mā'lh Jesús na ixchic Jairo, līlhūhua' ixtastālani'mā'nalh hasta ixtalālacxquititēlha. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na ixpu'nanca'n ixa'mā'lh chā'tin puscāt tī ixta'jatatla. Ixka'lhītza' a'kcāujtu' cā'ta jāla ixcāsni' ixka'lhni'. Ī'sputni'kō'nī'ttza' ixtumīn tū ixlīxokolh doctornu'. Jā tī chā'tin mātzeyīlh. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Xla' talacatzuna'jīlh na ixchakēn Jesús ē xa'malh ixquilhtūn ixlu'xu'. Palaj tunca cāsni'lh ixka'lhni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesús kelhasqui'nīni'lh: ―¿Tīchu quixa'manī't? Ixlīpō'ktuca'n tahuanli jā tī chā'tin. Pedro ē ā'makapitzīn tahuanilh: ―Mākelhtahua'kē'ni', līlhūhua' lītamacsti'li'ca'nī'ta' ē lālacxquitimā'ca ē hui'x kelhasqui'nīni'na': “¿Tī quixa'malh?” ");
INSERT INTO tkuNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesús cāhuanilh: ―Icmakca'tzī catīhuā quixa'manī't ē iclīmātzeyīnī't quilītli'hui'qui. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","A'cxni' puscāt ca'tzīlh Jesús cuenta tlahualh xa'maca, ī'xpipitēlha lakmilh ē tatzokostalh na ixtujan Jesús. Huanilh na ixlacatīn ixlīpō'ktuca'n tachi'xcuhuī't chī līxa'malh Jesús ē chuntza' palaj tunca ixtzeyanī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Palaj tunca Jesús huanilh: ―Quintzu'ma'jāt, tzeyanī'ta' hui'x ixpālacata a'ka'ī'nī'ta'. Līpāxuhua capit. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ixchihuīna'mā'lhcus Jesús a'cxni' chilh chā'tin xala' na ixchic Jairo xapuxcu' ixtemploca'n israelitas. Huanica Jairo: ―Mintzu'ma'jāt nīlhtza'. Jātza' camāmakchu'yi' Mākelhtahua'kē'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","A'cxni' Jesús kexmatli huā'mā', huanilh: ―Jā caji'cua'nti. Mintzu'ma'jāt natzeyan, xmān ca'a'ka'i'. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","A'cxni' chā'lh nac chic, Jesús jā makxtekli natā'tanū jā tī chā'tin, xmān Pedro ē Jacobo ē Juan ē ixtāta' ē ixtzī' tzu'ma'jāt. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ixlīpō'ktuca'n ixtacalhuamā'nalh ē ixtata'samā'nalh ixpālacata tzu'ma'jāt. Jesús cāhuanilh: ―Jā cacalhua'ntit. Tzu'ma'jāt jā xanīn, xmān lhtatamā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Xlaca'n talīlītzī'nli ixpālacata ixtaca'tzī ixnīnī'ttza'. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Palaj tunca Jesús macachi'palh tzu'ma'jāt ē palha' huanilh: ―Tzu'ma'jāt, icuaniyān catā'kaqui'. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Taspi'tli ixlīstacna' ē palaj tunca tā'kaquī'lh. Jesús māpa'ksīni'lh camāhuī'ca. ");
INSERT INTO tkuNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ixtāta' ē ixtzī' talī'a'cnīlh ē Jesús cāmāpa'ksīlh jā tī chā'tin ixuanli tū ixa'kspulanī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús cātā'talacxtimīlh kelhacāujtu' ī'scujnu'nī'n ē cāmaxquī'lh lītli'hui'qui ē līmāpa'ksīn natamāxtu catūxcuhuālh jā tzeya ū'ni'. Nā cāmaxquī'lh lītli'hui'qui natamātzeyī ta'jatatlanī'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Cāmacā'lh natahuan chī māpa'ksīni'n Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Cāhuanilh: ―Jā tū tilī'pinā'tit na mintejca'n, nūn mimpāla'cca'n nūn tumīn nūn mimpūtumīnca'n nūn pāntzīn. Jā catilī'pintit pūtu' mincamisaca'n, xmān pūtin. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Calhāhuālh nac chic jā nachipinā'tit a'ntza' natachokoyā'tit hasta a'cxni' nataxtuyā'tit tzamā' nac cā'lacchicni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Palh jā cātamānūyān na ixchicca'n, cataxtutit tzamā' nac cā'lacchicni'. A'cxni' nataxtuyā'tit, catincxtit mintujanca'n ē nayuja pokxni' ixlacatampūn mintujanca'n. Chuntza' nalīmāsu'yu'yā'tit xlaca'n natalē'n cuenta ixpālacata jā takexmatcu'tunli. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Palaj tunca tataxtulh scujnu'nī'n ē ta'a'lh calhāxcuhuālh nac cā'lacchicni'. Tatā'chihuīna'nli ē tahuanilh chī nacālīmakapūtaxtūcan ē tamātzeyīlh ta'jatatlanī'n calhāxcuhuālh. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Gobernador Herodes māca'tzīnīca ixlīpō'ktu tū Jesús ixtlahuamā'lh. Jā ixca'tzī chī nalacpuhuan ixpālacata ā'makapitzīn ixtalāhuanimā'nalh Juan Mā'kpaxīni' ixlacastālancuana'nī't ixlacpu'na'i'tātca'n nīnī'n ē ixtahuan palhāsā' ū'tza' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ā'makapitzīn ixtalāhuanimā'nampālh Jesús ū'tza' Elías tī tasu'yulh. Ā'makapitzīn huampala ixtalāhuanimā'nalh chā'tin a'kchihuīna' xala' makāstza' lacastālancuana'nli. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes huanli: ―Quit icmā'a'cchu'cunīni'lh Juan. ¿Tīchu huā'mā' tī ixpālacata ickexmata lhūhua' catūhuālh? Herodes ixlaktzī'ncu'tun Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","A'cxni' tataspi'tli apóstoles, tahuanilh Jesús tū ixtatlahuanī't. Palaj tunca Jesús cālē'lh ixlīmānca'n ē tatā'a'lh nac ā'lacatin cā'lacchicni' jā huanican Betsaida. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","A'cxni' tachi'xcuhuī't taca'tzīlh, tastālani'lh. Jesús cāhuanilh catatahuī'lh ē tzuculh cālītā'chihuīna'n ixpālacata ixlīmāpa'ksīn Dios. Cāmātzeyīlh ta'jatatlanī'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","A'cxni' ixkōtanūmā'lhtza', talaktalacatzuna'jīlh Jesús kelhacāujtu' scujnu'nī'n ē tahuanilh: ―Cacāmacapi tachi'xcuhuī't nata'a'n natatamāhua ixlīhua'ca'n nac cā'lacchicni' jā lacatzuna'j. Huā'tzā' jā hui'lāna'uj jā tū a'nan tū hua'can. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesús cāhuanilh: ―Hui'xina'n cacāmāhuī'tit. Xlaca'n takelhtīni'lh: ―Quina'n jā tū icka'lhīyāuj xmān macquitzis pāntzīn ē tantu' squī'ti' palh jā na'ica'nāuj na'ictamāhuayāuj. Ē lhūhua' xlaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ixtahui'lāna'lh hua'chi a'kquitzis mil chi'xcuhuī'n. Jesús cāhuanilh ī'scujnu'nī'n: ―Catatahuī'lh i'tātna' ciento. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Chuntza' tatlahualh ē tatahui'lakō'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Palaj tunca Jesús cātayalh makquitzis pāntzīn ē tantu' squī'ti'. Talacayāhualh nac a'kapūn ē maxquī'lh tapāxcatca'tzīn Dios ē cāmāpitzini'lh ē cāmaxquī'lh ī'scujnu'nī'n natamāpitzini' na ixpu'nanca'n tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ixlīpō'ktuca'n tahuā'yalh ē taka'sli. A'cxni' tahuā'yankō'lh, apóstoles tasacli lhūhua' xalacpītzun. Tatzumalh pācāujtu' chā'xta tū quītāxtūlh. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Milh a'ktin quilhtamacuj a'cxni' ixlīmān ixorarlīmā'lh Jesús. Ī'scujnu'nī'n lacatzuna'j tatahuī'lh. Jesús cākelhasqui'nīlh: ―Tachi'xcuhuī't, ¿chī tahuan quimpālacata? ");
INSERT INTO tkuNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Takelhtīlh: ―Makapitzīn tahuan palh hui'x Juan Mā'kpaxīni'. Ā'makapitzīn tahuan palh hui'x Elías. Ā'makapitzīn huampala tahuan hui'x chā'tin a'kchihuīna' xala' makāstza' tī lacastālancuana'nī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Palaj tunca cākelhasqui'nīlh: ―Ē hui'xina'n ¿chī hua'nā'tit tīchu quit? Pedro kelhtīlh: ―Hui'x Cristo tī Dios macamilh. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesús cāmāpa'ksīlh jā catitahuanilh jā tī chā'tin palh ū'tza' Cristo tī ixka'lhīmā'ca. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Cāhuanilh: ―Quit Chi'xcu' xala' Tālhmā'n ē ixlacasqui'nca naquimakapātīnīncan. Xanapuxcu'nu' israelitas ē xanapuxcu'nu' pālejni' ē mākelhtahua'kē'ni'nī'n līmāpa'ksīn, xlaca'n naquintalakmaka'n ē naquintamaknī. Masqui naquimaknīcan, ixlī'a'ktu'tun quilhtamacuj na'iclacastālancuana'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ā'līstān cāhuanilh ixlīpō'ktuca'n: ―Palh catīxcuhuālh quintā'tapa'ksīcu'tun quit, jātza' la catilacapāstacli xmān tū ū'tza' lacasqui'n. Calīhui'līlh natlahua quilīmāpa'ksīn lakalī lakalī masqui capātīni'lh chuntza' chī quit na'icpātīni'n ē caquistālani'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tī ta'a'kapūtaxtucu'tun tū natalīpātīni'n quimpālacata, jā catitaka'lhīlh ixlatamatca'n tū jā catilaksputli. Tī natalīpātīni'n masqui natanī quimpālacata, xlaca'n nataka'lhī ixlatamatca'n tū jā catilaksputli. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Palh chā'tin chi'xcu' ixtlajakō'lh ixlīpō'ktu xala' nac cā'quilhtamacuj, jā tū līmacuan huā'mā' palh jā ka'lhī ixlatamat tū jā catilaksputli. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Palh chā'tin naquilīmāxana'n ē nalīmāxana'n quintachihuīn, ū'tza' na'iclīmāxana'n a'cxni' na'icmin hua'chi Puxcu' ē na'icka'lhī ixlītli'hui'qui quinTāta' Dios ē naquintatā'min ángeles tī tze. Quit Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Iccāhuaniyān tū ixlīcāna'. Tahui'lāna'lh huā'tzā' chuhua'j makapitzīn tī jā catitanīlh a'cxni' jāna'j natalaktzī'n ixlītli'hui'qui Dios ē chī namāpa'ksīni'nkō'. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ixlī'a'ktzayan quilhtamacuj Jesús tahua'ca'lh a'ktin nac sipej natlahua oración. Tatā'a'lh Pedro ē Jacobo ē Juan. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Līhuan ixtlahuamā'lh oración Jesús, xla' talakpalīlh ē xtum ixtasu'yu ixlacan. Stala'nka' huanli ixlu'xu' hasta xkakalh. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Palaj tunca tatasu'yulh chā'tu' chi'xcuhuī'n ē ixtatā'chihuīna'mā'nalh Jesús. Xlaca'n Moisés ē Elías tī makāstza' ixtanīnī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Cālītamacsti'li'lh taxkaket. Ixtatā'chihuīna'mā'nalh chī Jesús napātīni'n ē nanī nac Jerusalén. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro ē tī cātā'a'lh masqui ixtalhtatacu'tun ixtalakahuahui'lāna'lh ē talaktzī'lh chī xkakalh Jesús ē chā'tu' chi'xcuhuī'n ixtatā'yāna'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","A'cxni' huā'mā' chi'xcuhuī'n ixtamakxtekmā'nalhtza' Jesús, Pedro huanilh: ―Mākelhtahua'kē'ni', ¡xalītze hui'lāna'uj huā'tzā'! Na'ictlahuayāuj a'ktu'tun mū'xta'ka'; a'ktin mila' nahuan ē a'ktin ixla' Moisés ē a'ktin ixla' Elías. Chuntza' huanli Pedro ixpālacata jā ixca'tzī tū ixuan. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Līhuan ixchihuīna'mā'lh, milh a'ktin poklhnu' ē cālītamacsti'li'lh. Tajicua'nli a'cxni' tamakca'tzīlh na ixpūlacni' poklhnu'. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Palaj tunca takexmatli a'ktin tachihuīn nac poklhnu' ē huanli: ―Ū'tza' huā'mā' quiSka'ta' ē icpāxquī'. Cakexpa'tni'tit tū huan. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","A'cxni' huankō'lh tachihuīn, talaktzī'lh ixlīmān ixuī'lh Jesús. Ca'cs tatāyalh ē jā tī chā'tin tahuanilh tū ixtalaktzī'nī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ixlīlakalī huampala, a'cxni' tayujli nac sipej, līlhūhua' tachi'xcuhuī't talakapāxtokli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Palaj tunca chā'tin chi'xcu' na ixpu'na'i'tātca'n palha' huanilh: ―Mākelhtahua'kē'ni', icsqui'ni'yān a'ktin talakalhu'mān. Capit laktzī'na' quinka'hua'cha, tzaj chā'tin icka'lhī. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Chi'pa jā tzeya ū'ni' ē makata'sa ē palha' xpipi ē kelhpupu. Māmakahuasī ē jāla makxteka. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Iccāsqui'ni'lhtza' miscujnu'nī'n catamāxtuni'lh jā tzeya ū'ni' ē jāla tamāxtuni'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús kelhtīlh: ―¡Hui'xina'n tachi'xcuhuī't jā tzej lacapāstacna'nā'tit ē jā a'ka'ī'yā'tit! ¿Hasta jā'cxni' na'iccātā'tahui'layān ē jā nakexpatā'tit hui'xina'n? ¿Hasta jā'cxni' na'iccātāyani'yān? Calī'ta' huā'tzā' minka'hua'cha. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","A'cxni' ka'hua'cha ixlaktalacatzuna'jīmā'lhtza', tzuculh xpipi ē paxnīni'n ē jā tzeya ū'ni' māmakahuasīlh nac ti'ya't. Jesús lacaquilhnīlh jā tzeya ū'ni'. Mātzeyīlh ka'hua'cha ē maxquī'pālh ixtāta'. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ixlīpō'ktuca'n talī'a'cnīlh ixlīka'tla' Dios. Līhuan ixlīpō'ktuca'n talī'a'cnīlh tū Jesús tlahualh, xla' cāhuanilh ī'scujnu'nī'n: ");
INSERT INTO tkuNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Tzej cakexpa'ttit ē jā tipātza'nkāyā'tit; quit Chi'xcu' xala' Tālhmā'n ē naquimacamāstā'can na ixmacanca'n tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Scujnu'nī'n jā takexmatli tū cāhuanilh ixpālacata xtum ixtalacapāstacmā'nalh. Jā ixtakelhasqui'nīcu'tun tū ixuanicu'tun ixpālacata ixtajicua'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Palaj tunca ī'scujnu'nī'n tatzuculh talālītā'chihuīna'n ixpālacata tīchu xlaca'n ā'chulā' ixlacasqui'nca. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús ca'tzīlh chī ixtalacapāstacmā'nalh. Palaj tunca macachi'palh chā'tin ska'ta' ē yāhualh na ixpāxtūn ");
INSERT INTO tkuNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ē cāhuanilh: ―Catīxcuhuālh tī quintā'tapa'ksī quit ē ū'tza' natalīpāxquī' chā'tin ska'ta' chī huā'mā' ka'hua'cha, ū'tza' lacxtim hua'chi quit quintapāxquī'lh. Catīxcuhuālh tī quintapāxquī', nā tapāxquī' tī quimacamilh ē jā xmān quit. Ū'tza' tī jā ka'tla' makca'tzī na mimpu'na'i'tātca'n, ū'tza' tī ka'tla' nalītaxtu na ixlacatīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Palaj tunca Juan huanilh: ―Mākelhtahua'kē'ni', iclaktzī'nī'tauj chā'tin tī ixcālītamakxtumā'lh jā tzeya ū'nī'n milītli'hui'qui. Icuaninī'tauj jātza' catlahualh chuntza' ixpālacata jā quincātā'latlā'huanān quina'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús cāhuanilh: ―Jā tihua'nā'tit chuntza' ixpālacata tī jā quinquiclhlaktzi'ca'n xla' quincāmaktāyayān. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","A'cxni' ixmimā'lh quilhtamacuj a'cxni' Jesús ixa'lh nac a'kapūn, līhui'līlh na'a'n nac Jerusalén. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Cāmāpūlīlh ā'makapitzīn ī'scujnu'nī'n ē ta'a'lh ā'lacatin nac cā'lacchicni'. Ta'a'lh taputza jā natamaklhtata. Cā'lacchicni' xala' nac Samaria, ");
INSERT INTO tkuNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ē xalanī'n a'ntza' jā tamānūcu'tunli na ixchicca'n ixpālacata ixtasu'yu Jesús ixa'mā'lh nac Jerusalén. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","A'cxni' scujnu'nī'n Jacobo ē Juan talaktzī'lh huā'mā', tahuanilh: ―Māpa'ksīni', ¿ē lacasqui'na' na'icmāyujūyāuj macscut xala' nac a'kapūn natalīsputa xlaca'n chuntza' chī tlahualh a'kchihuīna' Elías? ");
INSERT INTO tkuNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Palaj tunca Jesús cālaktalakspi'tli ē cālacaquilhnīlh. Huanli: ―Hui'xina'n jā ca'tzīyā'tit jā tze chī lacapāstacna'nā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Quit Chi'xcu' xala' Tālhmā'n ē quit jā ictimilh na'iccāmālaksputūkō' ixlatamatca'n tachi'xcuhuī't. Icmilh na'iccāmakapūtaxtū. Palaj tunca ta'a'lh ā'lacatin nac cā'lacchicni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","A'cxni' ixta'a'mā'nalh nac tej, chā'tin chi'xcu' huanilh Jesús: ―Quit na'icstālani'yān calhāxcuhuālh jā napina'. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús kelhtīlh: ―Tanqui'hui' taka'lhī ixlhu'cu'ca'n ē spūnī'n taka'lhī ixmāsekca'n. Quit Chi'xcu' xala' Tālhmā'n ē quit jā icka'lhī quinchic jā na'iclhtata. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús huanilh ā'chā'tin: ―Caquistāla'ni'. Xla' kelhtīlh: ―Māpa'ksīni', caquimakxtekti na'ictahui'la na quinchic hasta a'cxni' namā'cnūcan quintāta'. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús kelhtīlh: ―Xlaca'n tī jā ta'a'ka'ī' tzē natamā'cnū mintāta'. Hui'x capit ē cacāmāsu'yu'ni' tachi'xcuhuī't chī natalī'a'kapūtaxtu. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Palaj tunca huanipālh ā'chā'tin: ―Māpa'ksīni', icstālani'cu'tunān, xmān pūla ica'ncu'tun na'iccāmāca'tzīnī na quinchic. ");
INSERT INTO tkuNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús huanilh: ―Tī natzucu nalīscuja arado ē palh palaj natalakaspi'ta na ixchakēn, jā tze chī līscuja. Nā chuntza' jā minī'ni' palh hui'x natā'scuja Dios ixpālacata taspi'tcu'tuna' na minchic. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ā'līstān Māpa'ksīni' cālacsacli tu'tumpu'xamacāuj chi'xcuhuī'n xtum huampala ē cāmacā'lh chā'tu'yūn. Ixtapūlani' nac cā'lacchicni' ē calhāxcuhuālh ixa'mā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jesús cāhuanilh: ―Ixlīcāna' tū iccāhuaniyān. Lhūhua' a'nan tī jāna'j ta'a'ka'ī' ē jā lhūhua' tī nacāmāsu'yuni' xlaca'n. Chuntza' chī a'cxni' lhūhua' la cuxi' ē jā tī tī ī'nin. Dios hua'chi ixtēcu' cuxi'. Ū'tza' nalīkelhasqui'nīyā'tit Dios cacāmacamilh chi'xcuhuī'n nacāmāsu'yuni'can tī jāna'j ta'a'ka'ī'. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Capintit ē cuenta catlahua'tit. Iccāmacā'nān hua'chi xalacstīn purecu' na ixlacpu'na'i'tātca'n misinī'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Jā tilīpinā'tit nūn murralh, nūn pūtumīn, nūn caclhi'. Jā titamakapalīyā'tit natā'chihuīna'nā'tit ā'chā'tin nac tej. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","’A'cxni' natanū'yā'tit a'ktin nac chic jā chipinā'tit, pūla nacāhuani'yā'tit: “Dios cacāsicua'lanātlahuan tī hui'lā'na'ntit huā'tzā' nac chic.” ");
INSERT INTO tkuNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Palh a'nan tī ta'a'ka'ī', Dios nasicua'lanātlahua; ē palh jā a'nan tī ta'a'ka'ī', Dios jā caticāsicua'lanātlahualh. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Catahui'la'tit a'ktin nac chic ē tū nacātalakahui'līyān, nahua'yā'tit ē nako'tnu'nā'tit ixpālacata tī scuja xla' nahuā'yan. Jā tilactā'kchokoyā'tit a'katunu' nac chic. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","’A'cxni' nachipinā'tit a'ktin nac cā'lacchicni' jā nacātamānūyān nac chic, tū nacātalakahui'līyān nahua'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nacāmātzeyīyā'tit tī tata'jatatla a'ntza' ē nacāhuani'yā'tit tachi'xcuhuī't: “Laktzī'mpā'na'ntit ixlītli'hui'qui Dios.” ");
INSERT INTO tkuNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Palh nachipinā'tit a'ktin nac cā'lacchicni' ē palh jā tī lacasqui'n natachokoyā'tit, napimpalayā'tit nac tej ē nacāhuani'yā'tit: ");
INSERT INTO tkuNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Pokxni' xala' ā'tzā' tū quincātantūpasanī'ta'n na'ictincxmaka'nāuj ē ū'tza' huanicu'tun hui'xina'n līpinā'tit cuenta. Caca'tzītit huā'mā', hui'xina'n laktzī'nī'ta'ntittza' chī Dios māpa'ksīni'n.” ");
INSERT INTO tkuNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","’Iccāhuaniyān a'cxni' Dios nalaccāxtlahuakō', ā'chulā' nacāmakapātīnīn xalanī'n tzamā' cā'lacchicni' ē jā xalanī'n nac Sodoma. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jesús cāhuanipālh: ―¡Koxa tila'yā'tit hui'xina'n xalanī'n nac Corazín! ¡Koxa tila'yā'tit xalanī'n nac Betsaida! Nalīpuhuanā'tit ixpālacata jā a'ka'ī'tit. Tlahuacanī't lī'a'cnīn na milacpu'na'i'tātca'n. Palh ixcātlahuaca tzamā' lī'a'cnīn nac cā'lacchicni' Tiro ē nac Sidón, makāstza' ixtalakpalīlh ixtalacapāstacni'ca'n. Xlaca'n ixtalhakā'lh xapūtze'nke ixlu'xu'ca'n ē ixcā'a'cpūmāhua'ca'ca lhca'ca'n ē chuntza' ixlītasu'yulh ixtalīpuhuātca'n ixpālacata tū jā tze tū tlahualh. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","’A'cxni' Dios naputzāna'nīkō', ā'chulā' nacātamakapātīnīnān hui'xina'n ē jā xalanī'n nac Tiro ē nac Sidón. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Hui'xina'n xalanī'n nac Capernaum, ¿ē puhua'nā'tit palh napinā'tit nac a'kapūn ixpālacata tze hui'xina'n? Napinā'tit nac pūpātīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesús cāhuanilh ī'scujnu'nī'n: ―Tī cākexmatni'yān hui'xina'n, xla' naquinkexmatni'. Tī nacālakmaka'nān hui'xina'n, chuntza' naquilakmaka'n nā quit. Tī naquilakmaka'n quit chuntza' nalakmaka'n Dios ixpālacata ū'tza' tī quimacamilh. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tu'tumpu'xamacāuj taquītaspi'tli cā'tapāxuhuān. Tahuanilh: ―Māpa'ksīni', hasta jā tzeya ū'nī'n quincātalakachi'xcuhuī'n ixpālacata milīmāpa'ksīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús cāhuanilh: ―Nā quit iclaktzī'lh a'cxni' skāhuī'ca skāhuī'ni'. Tasu'yulh hua'chi a'ktin makli'pit. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Iccāmaktaka'lhān ē chuntza' mintā'lāquiclhlaktzi'ca'n jāla caticāskāhuī'n. Iccāmaxquī'kō'nī'ta'ntza' lītli'hui'qui tū nalīskāhuī'yā'tit ixlīmāpa'ksīn skāhuī'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Jā calīpāxuhua'tit xmān ixpālacata jā tzeya ū'nī'n cātalakachi'xcuhuī'yān. Calīpāxuhua'tit ixpālacata a'ka'ī'tit ē Dios cālakapasān chī ixlacstīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Palaj tunca Jesús ka'lhīlh tapāxuhuān ixpālacata Espíritu Santo ē Jesús orarlīlh: ―QuinTāta', hui'x māpa'ksīni'na' nac a'kapūn ē nac cāti'ya'tna'. Icmaxquī'yān tapāxcatca'tzīn ixpālacata cāmāsu'yuni'nī'ta' tī tasca'tcu'tun ū'tza' tū ixcāmātzē'kni'nī'ta' tī lakskalalhna'. Ū'tza' tla'hua' chuntza' chī mintalacasqui'nīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nā Jesús huanli: ―QuinTāta' quimacamaxquī'kō'lh ixlīpō'ktu tū a'nan. Jā tī chā'tin ca'tzī chī ī'Ska'ta' Dios, xmān Dios xaTāta'. Jā tī chā'tin lakapasa Dios xaTāta' chī ī'Ska'ta'. Nā natalakapasa xlaca'n tī na'iccāmāsu'yuni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Palaj tunca talakspi'tli ē cāhuanilh ī'scujnu'nī'n xmān ixlīmānca'n: ―Līpāxuhua tī talaktzī'n tū hui'xina'n laktzī'nā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Iccāhuaniyān lhūhua' a'kchihuīna'nī'n ē ka'tla' xapuxcu' ixtalaktzī'ncu'tun huā'mā' tū hui'xina'n laktzī'nā'tit, ē jā talaktzī'lh. Ixtakexmatcu'tun tū kexpa'tā'tit, ē jā takexmatli. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Palaj tunca chā'tin xamākelhtahua'kē'ni' līmāpa'ksīn tāyalh ē tā'chihuīna'nli Jesús nalīlaktzī'n. Kelhasqui'nīlh: ―Mākelhtahua'kē'ni', ¿tū na'ictlahua na'icka'lhī quilatamat tū jā catilaksputli? ");
INSERT INTO tkuNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús kelhtīlh: ―¿Tū tatzo'kni' na ixlīmāpa'ksīn Moisés? ¿Chī līkēlhtahua'kaya'? ");
INSERT INTO tkuNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Xamākelhtahua'kē'ni' līmāpa'ksīn kelhtīni'lh: ―“Calīpāxqui' Māpa'ksīni' tī minDios ixlīpō'ktu milīstacna' ē ixlīpō'ktu milītli'hui'qui ē ixlīpō'ktu mintalacapāstacni'. Cacāpāxqui' ā'makapitzīn chuntza' chī pāxquī'ca'na' mina'cstu.” ");
INSERT INTO tkuNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Palaj tunca Jesús huanilh: ―Tze chī kelhtīni'nī'ta'. Palh chuntza' natlahua'ya', naka'lhī'ya' milatamat tū jā catilaksputli. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Xamākelhtahua'kē'ni' līmāpa'ksīn ixlī'a'kapūtaxtūcu'tun tū kelhasqui'nīlh ē huanilh Jesús: ―¿Tīchu ā'makapitzīn tī na'iccāpāxquī'? ");
INSERT INTO tkuNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Kelhtīlh Jesús: ―Ixuī'lh chā'tin chi'xcu'; taxtulh nac Jerusalén ē ixa'mā'lh nac Jericó. Ka'lhāna'nī'n tachi'palh ē tamakka'lhankō'lh hasta ixlu'xu' tū ī'lhakā'nī't. Tatucsli ē ta'a'lh. Xala'ca'lhtzincsni' tamakxtekli. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Chuntza' a'kspulalh ixa'mā'lh nac tej chā'tin pālej. A'cxni' laktzī'lh chi'xcu', xmān makskāhuī'maka'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nā tētaxtulh chā'tin ixmaktaka'lhna' xaka'tla' templo. A'cxni' laktzī'lh chi'xcu', nā xla' sti'li'maka'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","’A'cxni' milh chā'tin samaritano, xla' laktzī'lh ē lakalhu'manli. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Palaj tunca talacatzuna'jīlh chi'xcu' ē līcu'chū'lh aceite jā ixtakāhuī'nī't. Hui'līni'lh venda. Palaj tunca kēhui'līlh ixburro tī ixtakāhuī'nī't ē lē'lh nac mesón ē a'ntza' maktaka'lhli. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ixlīlakalī xkakalh a'cxni' samaritano ixtaxtumā'lh, maxquī'lh tumīn ixtēcu' mesón ē huanilh: “Camaktaka'lhti huā'mā' takāhuī'n. Palh jā a'cchā'n tzamā' tumīn, na'icmaxquī'yān ixlakxoko a'cxni' na'icchimpala.” ");
INSERT INTO tkuNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jesús huanilh xamākelhtahua'kē'ni' līmāpa'ksīn: ―Chuhua'j caquihua'ni', ¿tichūyā chi'xcu' chī kelhatu'tun tī ā'chulā' pāxquī'lh takāhuī'n? ");
INSERT INTO tkuNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Xamākelhtahua'kē'ni' līmāpa'ksīn huanli: ―Tī lakalhu'manli. Jesús huanilh: ―Capit ē chuntza' catlahua'. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús tēlh ixtej ē chā'lh a'ktin nac cā'lacchicni'. A'ntza' chā'tin puscāt tī ixuanican Marta mānūlh na ixchic. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta ixka'lhī ixtā'tin tī ixuanican María. Xla' tahuī'lh na ixtujan Jesús nakexmata tū xla' ixmāsu'yumā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta ixlītamakchuyīmā'lh ixpālacata ixka'lhī ixlītlahuat ē laktalacatzuna'jīlh Jesús ē huanilh: ―Māpa'ksīni', ¿ē jā laktzī'na' quintā'tin quimakxtekni'kō' lītlahuat? Cahua'ni' caquimaktāyalh. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesús kelhtīlh: ―Marta, hui'x māmakchuyīnīna' ē lī'a'ktuyuna' lhūhua'. ");
INSERT INTO tkuNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Huī'lh tū ā'chulā' ixlacasqui'nca. María lacsacnī't tū ā'chulā' xatze ē jā tī chā'tin catimaktīlh. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","A'ktin quilhtamacuj Jesús ixorarlīmā'lh. A'cxni' orarlīkō'lh, chā'tin ī'scujni' huanilh: ―Māpa'ksīni', caquilāmāsca'tīuj chī orarlīcan chuntza' chī cāmāsca'tīlh ī'scujnu'nī'n Juan Mā'kpaxīni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús cāhuanilh: ―A'cxni' orarlīyā'tit, chuntza' nahua'nā'tit: QuinTāta'ca'n tī hui'lachi nac a'kapūn, calakachi'xcuhuī'ca'. Camilh a'cxni' natzucuya' namāpa'ksīni'nkō'ya'. Catlahuaca mintalacasqui'nīn huā'tzā' nac cā'ti'ya'tna' chuntza' chī nac a'kapūn. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Caquilāmaxquī'uj quilīhua'tca'n tū na'icua'yāuj lakalī lakalī. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Caquilāmātza'nkēna'ni'uj quincuentaca'n ixpālacata nā quina'n iccāmātza'nkēna'ni'yāuj tī quincāquiclhlaktzī'nān. Jā camakxtekti tū naquincā'a'kspulayān naquincāmātlahuīyān tū jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nā Jesús cāhuanilh: ―Nalīhui'līyāuj chā'tin chī hui'xina'n ka'lhī'yā'tit chā'tin minamigoca'n. I'tāt tzī'sa napina' na ixchic ē nahuani'ya': “Amigo, caquimpāhua'maxqui' mactu'tun pāntzīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Na'jtza' quilakchilh chā'tin quinamigo na quinchic ē jā tū icka'lhī tū na'ictā'hua'.” ");
INSERT INTO tkuNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ē xla' na ixpūchakān chic nakelhtīyān: “Jā caquijicsmāhui'. Lacchahuayālhtza' mākelhcha ē quilīpō'ktuca'n iclhtatamā'naujtza'. Jāla ictāquī' na'icmaxquī'yān tū quisqui'ni'ya'”, nahuaniyān minamigo. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","’Iccāhuaniyān masqui minamigo jā tāquī'cu'tunli namaxquī'yān catūhuālh, ixpālacata lī'amigo hui'xina'n, xla' namaxquī'yān ixlīpō'ktu tū maclacasqui'na'. Chuntza' jātza' jics catimāhui'. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","’Chuntza' iccāhuaniyān: Casqui'ni'tit Dios ē xla' nacāmaxquī'yān. Caputzatit tū Dios cāmaxquī'cu'tunān ē namaclayā'tit. Camacasā'na'ntit nac mākelhcha ē nacātamālaquī'ni'yān. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Chuntza' tī nasqui'n, xla' namaktīni'n; ē tī naputza tū Dios namaxquī', xla' namacla; ē tī namacasā'nan nac mākelhcha, namālaquī'ni'can. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Hui'xina'n ka'lhīyā'tit milacstīnca'n. ¿Ē namaxquī'ya' chihuix minka'hua'cha a'cxni' squi'ni'yān pāntzīn? ¿Ē tzē namaxquī'ya' a'ktin lūhua' palh squi'ni'yān squī'ti'? ");
INSERT INTO tkuNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Ē namaxquī'ya' a'ktin a'ca'cūlūtl palh squi'ni'yān ka'lhuā'? ");
INSERT INTO tkuNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Hui'xina'n masqui jā tze ca'tzīyā'tit, tzē namaxquī'yā'tit talakalhu'mān milacstīnca'n. Ā'chulā' minTāta'ca'n tī hui'lacha' nac a'kapūn nacāmaxquī' Espíritu Santo tī tasqui'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesús ixmāxtuni'mā'lh chi'xcu' jā tzeya ū'ni' tū ixmakakō'ko'nī't. A'cxni' taxtulh jā tzeya ū'ni', tzētza' tzuculh chihuīna'n tī kō'ko' ixuanī't. Masqui tachi'xcuhuī't talī'a'cnīlh huā'mā', ");
INSERT INTO tkuNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","makapitzīn tahuanli: ―Huā'mā' chi'xcu' cālīmāxtu jā tzeya ū'nī'n ixlītli'hui'qui Beelzebú tī xapuxcu' jā tzeya ū'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ā'makapitzīn ixtalīlaktzī'ncu'tun Jesús ē ixtasqui'ni' a'ktin lī'a'cnīn xala' nac a'kapūn. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Xla' ixca'tzītza' tū xlaca'n ixtalacpuhuan ē cāhuanilh: ―Palh māpa'ksīni'nī'n tatapitzi ē talātucsa, jāla tamāpa'ksīni'n makās. Natalāmālaksputūkō'. Palh tamputin familia tatapitzi ē natalātucsa lītā'timīn, jā catitatāyani'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Chuntza' palh tatapitzi xlaca'n tī tatapa'ksīni' skāhuī'ni' ē ixtā'lāquiclhlaktzi' nahuan, ¿chī nalīka'lhī ixlītli'hui'qui skāhuī'ni'? Iccāhuaniyān huā'mā' ixpālacata hui'xina'n quilāhuaniyāuj quit iclīmāxtulh jā tzeya ū'ni' ixlītli'hui'qui Beelzebú. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Palh quit iccālīmāxtu jā tzeya ū'nī'n ixlītli'hui'qui Beelzebú, ¿tīchu ixlītli'hui'qui taka'lhī xlaca'n tī tatapa'ksīni' hui'xina'n ē talīmāxtu jā tzeya ū'ni'? Chuntza' xlaca'n talīmāsu'yu jā ixlīcāna' tū quilālīmālacsu'yuyāuj. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Quit iccālīmāxtu jā tzeya ū'nī'n ixlītli'hui'qui Dios. Huā'mā' ū'tza' huanicu'tun Dios cāmāsu'yuni'yān chī tzuculhtza' māpa'ksīni'n huā'tzā' nac cā'ti'ya'tna'. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’A'cxni' maktaka'lhmā'lh ixchic chā'tin chi'xcu' tī tli'hui'qui ē tī ka'lhī līcā'n tū nalīmaktāyacan, jā tū cati'a'kspulalh catūhuālh. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Palh namin ā'chā'tin ā'chulā' xatli'hui'qui, ū'tza' naskāhuī' ē namaktī ixlīcā'n tū līpāhuan ē namāpitzi tū namaktī. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Tī jā quintapa'ksīni'cu'tun quit, ū'tza' quintā'lāquiclhlaktzi'. Tī jā quintā'scuja, ū'tza' lactlahuana'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jesús cāhuanipālh: ―A'cxni' chā'tin jā tzeya ū'ni' nataxtuni' chi'xcu', nalatā'kchoko jā cā'scahuahua ē naputza jā najaxa. A'cxni' jā namacla jā najaxa, napuhuan: “Na'ictaspi'tpala jā ictaxtukēnī'tancha'.” ");
INSERT INTO tkuNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","’A'cxni' naquītaspi'ta, namacla chi'xcu' hua'chi a'ktin chic jā cā'huan ē tzej pa'lhnancanī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Palaj tunca na'a'n nacātaya ā'kelhatojon jā tzeya ū'nī'n ā'chulā' xalīhua'ca'lhtza'. Ixlīpō'ktuca'n natatanū natatahui'la na ixpūlacni' chi'xcu'. Chuntza' ā'chulā' nalītahua'ca'ni' chi'xcu' ē jā a'cxni' ixka'lhī xmān chā'tin jā tzeya ū'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","A'cxni' Jesús ixcāhuanimā'lh huā'mā', chā'tin puscāt na ixlacpu'na'i'tātca'n tachi'xcuhuī't ta'salh ē huanli: ―¡Līpāxuhua puscāt tī mālacatuncuhuī'n ē tī mātzi'quī'n! ");
INSERT INTO tkuNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesús huanli: ―¡Ā'chulā' natalīpāxuhua tī takexmata tū Dios huan ē tatlahua! ");
INSERT INTO tkuNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tachi'xcuhuī't ā'chulā' talaktakēstokli Jesús ē xla' tzuculh chihuīna'n ē huanli: ―Hui'xina'n jā tze. Ū'tza' līsqui'nā'tit a'ktin lī'a'cnīn. Xmān nacātamāsu'yuni'yān lī'a'cnīn chī a'kspulalh Jonás. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tū a'kspulalh Jonás cāmāsu'yuni'lh ixlītli'hui'qui Dios xalanī'n nac Nínive. Nā chuntza' tū na'a'kspula Chi'xcu' xala' Tālhmā'n nacāmāsu'yuni'yān ixlītli'hui'qui Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Namin quilhtamacuj a'cxni' nacāputzāna'nīkō'can ixlīpō'ktuca'n tachi'xcuhuī't xalanī'n nac cā'quilhtamacuj. Ē reina tī ixmāpa'ksīni'n nac Sabá natāya ē nacālīmālacsu'yuyān. Nacālīmālacsu'yuyān ixpālacata xla' kexmatli tū huanli Salomón. Makat ixuanī't ixchic reina ē milh kexmata Salomón. Quit ā'chulā' ixlacasqui'nca ē jā Salomón ē hui'xina'n jā quilākexmatni'cu'tunāuj. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","’Nā a'cxni' naputzāna'nīkō'can, xlaca'n tī ixtahui'lāna'lh nac cā'lacchicni' jā huanican Nínive natatāya ē nacātalīmālacsu'yuyān hui'xina'n tī hui'lāna'ntit chuhua'j. Nacātalīmālacsu'yuyān ixpālacata xlaca'n talakpalīlh ixtalacapāstacni'ca'n a'cxni' milh Jonás ē lī'a'kchihuīna'nli ixtachihuīn Dios. Hui'xina'n jā lakpalī'tit mintalacapāstacni'ca'n a'cxni' quit ica'kchihuīna'nli. Quit ā'chulā' ixlacasqui'nca ē jā Jonás. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesús cāhuanipālh: ―Jā tī chā'tin namāpasī ixpūcās ē namātze'ka o nahui'lī ixtampīn cajón. Namāhua'ca' tālhmā'n ē chuntza' tī natatanū tzē natalaktzī'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Palh tzej a'ka'ī'ya' ē latlā'hua'na na ixtej Dios nalītaxtuya' hua'chi taxkaket tū cāmāxkakē ā'makapitzīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Cuenta catlahua'tit ē jā natzucuya'tit lacapāstacā'tit tū jā tze, ixpālacata chuntza' jāla catitlahua'tit tū tze. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Palh hui'x lacapāstaca' tū tze ē palh tlahua'ya' tū tze, chuntza' nala chī a'ktin pūcās tū tzej māxkakē mintej. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","A'cxni' Jesús chihuīna'nkō'lh, chā'tin fariseo huanilh catā'a'lh tā'huā'yan na ixchic. Jesús tanūlh ē tahuī'lh huā'yan. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Fariseo lī'a'cnīlh chī Jesús jā makacha'ka'lh chī xlaca'n ixtalīsmanīnī't a'cxni' natahuā'yan. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Māpa'ksīni' huanilh: ―Hui'xina'n fariseos hua'chi tī namakche'kē' vaso ē pulātu ē jā catipūche'kē'lh. Masqui tasu'yu'yā'tit tzeya chi'xcuhuī'n hui'xina'n, jā tze mintalacapāstacni'ca'n ixpālacata tampi'lhīni'nā'tit ē tlahua'cu'tunā'tit tū jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Jā kexpatcu'tunā'tit! ¿Ē jā ca'tzīyā'tit Dios cātlahuanī'ta'n hui'xina'n nalakachi'xcuhuī'yā'tit Dios? A'cxni' jā tze mintalacapāstacni'ca'n, jāla catilakachi'xcuhuī'tit. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Palh ixlīcāna' lakachi'xcuhuī'cu'tunā'tit Dios, ixlacasqui'nca xatze mintalacapāstacni'ca'n. Palh tze mintalacapāstacni'ca'n, ixlīpō'ktuca'n nacātalaktzī'nān lactze. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Hui'xina'n fariseos nalīpuhuanā'tit! Māstā'yā'tit macsti'na'j līhua't chī culāntu' ē chī ā'cunculim ē ā'makapitzīn līhua't tū ixla' Dios nahuan. Chuntza' tze. Masqui chuntza' tlahua'yā'tit, jātza' tasu'yu palh pāxquī'yā'tit Dios ē palh natlahua'yā'tit tū lactze. Ixlacasqui'nca namakataxtūyā'tit tū ixla' Dios. Ā'chulā' ixlacasqui'nca natlahua'yā'tit tū xatze ē napāxquī'yā'tit Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Nalīpuhuanā'tit hui'xina'n fariseos! Lacasqui'nā'tit natahui'la'yā'tit jā cātalaktzī'nān nac templo. Lacasqui'nā'tit cacātalakachi'xcuhuī'n a'cxni' pimpā'na'ntit nac tej. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Nalīpuhuanā'tit hui'xina'n xamākelhtahua'kē'ni'nī'n līmāpa'ksīn ē fariseos tī laktza' lī'a'kskāhuī'ni'nā'tit! Hui'xina'n hua'chi pūtā'cnūn tū jā tatasu'yu. Tachi'xcuhuī't tachi'nta ē jā taca'tzī. Chuntza' tatlahua tū jā tze chuntza' chī tatzo'kni' na ixlīmāpa'ksīn Moisés. Nā chuntza' hui'xina'n cāmātlahuanīyā'tit ā'makapitzīn chī cāmāsu'yuni'yā'tit. Xlaca'n jā taca'tzī palh talaclē'n ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Palaj tunca kelhtīlh chā'tin xamākelhtahua'kē'ni' līmāpa'ksīn ē huanilh: ―Mākelhtahua'kē'ni', a'cxni' chuntza' hua'na' huā'mā' quilālacaquilhnīyāuj. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús huanli: ―¡Nalīpuhuanā'tit nā hui'xina'n xamākelhtahua'kē'ni'nī'n līmāpa'ksīn! Lhūhua' tahui'lat mātlahuīni'nā'tit ē jātza' la mākentaxtūkō'can. Ū'tza' hua'chi ixcāmācu'quī'tit tū tzinca. Jā tī chā'tin tzē natāyani' ē hui'xina'n jā maktāyayā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Nalīpuhuanā'tit hui'xina'n! Jā tze chī tlahua'yā'tit. Xmān cālakachi'xcuhuī'cu'tunā'tit tī tanīnī'ntza' a'kchihuīna'nī'n. Minapapana'ca'n tamaknīlh a'kchihuīna'nī'n ē ");
INSERT INTO tkuNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","hui'xina'n tlahua'yā'tit ixpanteonca'n a'kchihuīna'nī'n tī cāmaknīcanī't. Nā chuntza' hui'xina'n chī minapapana'ca'n, ē puhua'nā'tit tze tū tatlahualh xlaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Ū'tza' līchihuīna'nli Dios tī ixlīcāna' ka'lhī talacapāstacni'. Huanli: “Na'iccāmacamini' a'kchihuīna'nī'n ē apóstoles. Nacāmaknīcan ā'makapitzīn ē nacāmakapātīnīncan ā'makapitzīn huampala.” ");
INSERT INTO tkuNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Chuntza' tachi'xcuhuī't tī tahui'lāna'lh chuhua'j, ū'tunu'n natalē'n cuenta ixpālacata ixlīpō'ktuca'n a'kchihuīna'nī'n tī cāmaknīcanī't hasta a'cxni' ixlītzucuni' cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Natzucucan nacākelhasqui'nīcan ixpālacata Abel ē ixlīpō'ktuca'n a'kchihuīna'nī'n hasta Zacarías tī maknīca na ixlacatzuna'j templo ē pūmacamāstā'n. Ū'tza' iccāhuaniyān Dios nacākelhasqui'nīyān hui'xina'n huā'tzā' ixpālacata a'kchihuīna'nī'n tī cāmaknīcanī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Nalīpuhuanā'tit hui'xina'n, mākelhtahua'kē'ni'nī'n līmāpa'ksīn! Ixtachihuīn Dios hua'chi tanūmā'lh a'ktin nac chic. Hui'xina'n ka'lhī'yā'tit xallave chic. Jā tanūyā'tit ē jā cāmakxtekā'tit natatanū ā'makapitzīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","A'cxni' Jesús cāhuanilh tzamā', mākelhtahua'kē'ni'nī'n līmāpa'ksīn ē fariseos tasītzī'ni'lh Jesús. Tatzuculh takelhasqui'nī lhūhua' catūhuālh. ");
INSERT INTO tkuNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ixtamaktaka'lhmā'nalh palh tzē ixtamaclani'lh tū ixtalīmālacsu'yulh. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Līhuan ixtatakēstokmā'nalh lhūhua' tachi'xcuhuī't hasta ixtalālacxquititza'. Jesús tzuculh cāhuani pūla ī'scujnu'nī'n: ―Cuenta natlahua'yā'tit fariseos ixpālacata xlaca'n a'ktu' tatlahua ixlacanca'n. Jā titlahua'yā'tit chī xlaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Catūhuālh tū tzē'kcanī't, ū'tza' nalaktzī'ncan. Tū tzē'kcanī'tcus, naca'tzīkō'can. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Chuntza' tū hui'xina'n huaninī'ta'ntit xmān chā'tin, ū'tza' nakexmatcan calhāxcuhuālh. Tū tzē'k huanī'ta'ntit ixchakān nac chic, ū'tza' palha' nahuancan calhāxcuhuālh nac kēpūn. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jesús cāhuanipālh: ―Quinamigos, iccāhuaniyān jā tijicua'ni'yā'tit tī tamaknīni'n ē ā'līstān jāla tū ā'chulā' tatlahua. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Na'iccāhuaniyān tī najicua'ni'yā'tit: Cajicua'ni'tit Dios tī tzē nacāmālaksputūkō'yān ē ā'līstān nacāmacā'nān nac pūpātīn. Ū'tza' calījicua'ni'tit Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Jā tapalaxla' lakatin tantzicni'. Stā'can tanquitzis xmān a'ktu' tumīn. Dios jā cāpātza'nkā nūn lakatin xlaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hui'xina'n hasta miya'jca'n cātapūlhekeni'nī'tan kenatunu'. Ū'tza' jā tilījicua'nā'tit; hui'xina'n ā'chulā' tapalaxla' ē jā tantzicni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jesús cāhuanipālh: ―Iccāhuaniyān catīxcuhuālh tī nahuan na ixlacatīnca'n tachi'xcuhuī't: “Quit ictapa'ksīni' Cristo”, ē chuntza' nā quit na'icuan na ixlacatīnca'n ixángeles Dios: “Xla' quintapa'ksīni'.” Quit Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Palh catīxcuhuālh naquinkelhtatzē'ka na ixlacatīnca'n tachi'xcuhuī't, nā quit na'ickelhtatzē'ka na ixlacatīnca'n ixángeles Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Tī cachīhuālh talīchihuīna'n Chi'xcu' xala' Tālhmā'n, tzē namātza'nkēna'ni'can. Tī tahuan jā tze tū tlahua Espíritu Santo, xlaca'n jāla caticāmātza'nkēna'ni'ca. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’A'cxni' nacātalē'nān na ixlacatīnca'n māpa'ksīni'nī'n ē xanapuxcu'nu', jā catilī'a'ktuyuntit chī nakelhtīni'nā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","A'cxni' nachihuīna'nā'tit, Espíritu Santo nacāmāsu'yuni'yān chī nakelhtīni'nā'tit ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Chā'tin ixpu'na'i'tātca'n tachi'xcuhuī't huanilh Jesús: ―Mākelhtahua'kē'ni', cahua'ni' quintā'tin caquimaxquī'lh tū quila' nahuan. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús kelhtīlh: ―¿Tīchu quihui'līnī't quit hua'chi juez o tī māpitzi ti'ya't? ");
INSERT INTO tkuNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nā huanli: ―Cuenta catlahua'tit. Jā tilakca'tzana'ntit catūhuālh xala' nac cā'quilhtamacuj tū jāla caticāmaxquī'n milatamatca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Palaj tunca Jesús cālīmāsu'yuni'lh a'ktin tachihuīn ē cāhuanilh: ―Ixuī'lh chā'tin chi'xcu'; rico ixuanī't. Ixmakalanāna'n na ixti'ya't. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Xla' palaj tunca lacpuhuanli: “¿Tūchu na'ictlahua? Jā icka'lhī jā na'icmāquī' lhūhua' quincuxi'. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Pūla na'iccālactlahua xalacsti'na'j ixpūtahuīlh quincuxi' ē na'ictlahua ā'chulā' xaka'tla' ē a'ntza' na'icmāquī'kō' quincuxi' ē ixlīpō'ktu tū icmakalalh. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","A'cxni' na'icpuhuan quina'cstu: Chuhua'j icka'lhī lhūhua' tū icmakalalh tū naquilīmacuani' ā'lhūhua' cā'ta. Chuhua'j na'icjaxa ē na'icuā'yan ē na'icko'tnu'n ē na'icpāxuhua.” ");
INSERT INTO tkuNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Dios huanilh: “Hui'x jā tze lacapāstacna'na'. Chuhua'j huā'mā' tzī'sa nanī'ya'. Tū māquī'nī'ta', ¿tīchu ixla' nahuan?” ");
INSERT INTO tkuNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Chuntza' na'a'kspula chā'tin chi'xcu' tī mākēstoka lhūhua' catūhuālh tū ixla'. Ixlīpō'ktu tū ka'lhī, jā tū ixtapalh na ixlacatīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ā'līstān Jesús cāhuanilh ī'scujnu'nī'n: ―Iccāhuaniyān. Jā tilī'a'ktuyunā'tit tū nahua'yā'tit ē tū nalhakā'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Dios cāmaxquī'yān milatamatca'n ē mimacni'ca'n tū tzē nalīscujā'tit ē ā'chulā' nacāmaxquī'yān milīhua'tca'n ē milu'xu'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Cuenta cacātlahua'tit cha'kni'. Xlaca'n jā tacha'nāna'n ē nūn tamakalanāna'n. Jā taka'lhī ixpūcuxi'ca'n ē Dios cāmāhuī'. Ā'chulā' tapalaxla' hui'xina'n ē jā tzamā' spūnī'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Jā tī chā'tin chī hui'xina'n tzē ā'chulā' makās natahui'la masqui calī'a'ktuyunti. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Palh chuntza' jāla natlahua'yā'tit, ¿tū ixpālacata lhūhua' tū lī'a'ktuyunā'tit? ");
INSERT INTO tkuNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Cuenta cacātlahua'tit xanatna' chī natalīstaca. Jā tascuja ē jā tatza'pa' ixlu'xu'ca'n. Tzēhuanī't tastaca masqui jā tū tatlahua. Iccāhuaniyān rey Salomón jāla cāmālakchā'nī ixlītzēhuanī't xanat ē xla' rico ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","A'nan pa'lhma' nac cā'tacuxtu tū tzēhuanī't ē lakalī tū'xama'n nacā'ī'can ē nacālhcuyucan. Dios cāmaktaka'lha ē cāmakastaca pa'lhma' tū palaj nascāca ē ā'chulā' nacāmaktaka'lhān hui'xina'n. ¿Tū ixpālacata jā a'ka'ī'yā'tit huā'mā'? ");
INSERT INTO tkuNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Chuntza' jā tilī'a'ktuyunā'tit ixpālacata tū nahua'yā'tit ē tū nalīko'tnu'nā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tachi'xcuhuī't xalanī'n nac cā'quilhtamacuj xmān ū'tza' taputzatlā'huan. Hui'xina'n ka'lhī'yā'tit chā'tin minTāta'ca'n nac a'kapūn ē xla' ca'tzī tū maclacasqui'nā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Xatze pūla caputzatit chī nalīkexpatni'yā'tit Dios xala' tālhmā'n ē nā namaktīni'nā'tit tū maclacasqui'nā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jesús cāhuanipālh: ―Quilacstīn, jā cajicua'ntit. Masqui jā lhūhua' hui'xina'n, minTāta'ca'n nac a'kapūn lacasqui'n natapa'ksīni'yā'tit xla'. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Castā'tit tū ka'lhī'yā'tit ē cacāmaxquī'tit tī tamaclacasqui'n. Chuntza' naka'lhī'yā'tit mimpūtumīnca'n tū jā maktin catimasli ē milīricujca'n nac a'kapūn ē jā maktin catisputli. A'ntza' jā catitanūlh ka'lhāna' ē nūn tū catilacua'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Jā huī'lh milīricujca'n, a'ntza' huī'lh mintalacapāstacni'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jesús cāhuanipālh: ―Cacāxtahui'la'tit. Camāpasītittza' mimpūcāsca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Hua'chi tasācua' cahuantit tī taka'lhīmā'nalh ixpatronca'n tī a'nī't jā tamakaxtokmā'ca. A'cxni' nataspi'ta ē nalīmacasā'nan mākelhcha, lacasqui'n palaj camālaquī'ni'ca. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Līpāxuhua tasācua' tī talakahuahui'lāna'lh a'cxni' nachin ixpatronca'n. Ixlīcāna' tū iccāhuaniyān. Ixpatronca'n nacāhuani catahuī'lh ē nacāmāhuī'can. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Masqui cachilh i'tāt tzī'sa o xkakanī'ttza', līpāxuhua tasācua' palh talakahuahui'lāna'lh a'cxni' nachin ixpatronca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","’Caca'tzītit huā'mā'. Palh ixtēcu' chic ixca'tzīlh tūyā hora nachin ka'lhāna', ixlakahuantahuī'lh ē jā ixtimakxtekli natanū ka'lhāna'. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nā hui'xina'n caskalalhtahui'la'tit. Namin Chi'xcu' xala' Tālhmā'n a'cxni' jā ca'tzīyā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Palaj tunca Pedro kelhasqui'nīlh: ―¿Ē quilālīmāsu'yuni'uj xmān quimpālacataca'n o ixlīpō'ktuca'n? ");
INSERT INTO tkuNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesús huanli: ―¿Chī huī'lh xatze tasācua' tī tzej kexmata? Xla' ū'tza' tī ixtēcu' chic namacamaxquī'tāquī' ixtasācua' ē xla' nacāmāhuī' ixtā'tasācua'n a'cxni' nalacchā'n hora. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Līpāxuhua tasācua' palh mākentaxtūmā'lh ixtascujūt a'cxni' nataspi'ta ixpatrón. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ixlīcāna' tū iccāhuaniyān. Ixtēcu' chic namacamaxquī' huā'mā' tasācua' ixlīpō'ktu tū ka'lhī. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Palh jā tze huā'mā' tasācua', xla' napuhuan natamakapalī ixpatrón. Chuntza' natzucu cālactucsa ā'makapitzīn tasācua'n ē natzucu nahuā'yan ē nako'ta ē naka'chī. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Xamaktin nataspi'ta ixtēcu' chic. Namin a'ktin quilhtamacuj a'cxni' jā tzeya tasācua' jā ka'lhīmā'lh ē jā ca'tzī. Ixtēcu' chic palha' namakapātīnīn tasācua' ē nacātā'pātīni'n xlaca'n tī jā ta'a'ka'ī'. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Tasācua' tī ca'tzī tū lacasqui'n ixpatrón ē jā mākentaxtū ē jā lakachi'xcuhuī', xla' maklhūhua' natucscan. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Tī jā ca'tzī tū lacasqui'n ixpatrón ē masqui natlahua tū maclacasqui'n castigo, xla' jā maklhūhua' catihui'līni'ca. Palh jā lhūhua' macamaxquī'can, xla' jā lhūhua' catisqui'ni'can. Tī lhūhua' macamaxquī'can, ā'chulā' lhūhua' nasqui'ni'can. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jesús cāhuanipālh: ―Quimpālacata quit jā lacxtim catihuantit. Makapitzīn natakexmatni' quintachihuīn ē ā'makapitzīn natalakmaka'n. Makapitzīn lacatancs natahuan ixlīcāna' quintachihuīn ē ā'makapitzīn lacatancs natahuan jā ixlīcāna'. Chuntza' calalh chuhua'j. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ixlacasqui'nca na'icpātīni'n. ¿Chī na'iclītāyani' hasta a'cxni' na'icmākentaxtū? ");
INSERT INTO tkuNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Ē puhua'nā'tit icmilh ixpālacata lacxtim natahuan tachi'xcuhuī't? Iccāhuaniyān jā chuntza'. Na'iccāmāpitziyān. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Chuhua'j hasta kelhaquitzis xalanī'n a'ktin nac chic natatapāpitzi. Chā'tu'tun ixtā'lāquiclhlaktzi'ca'n natahuan chā'tu', ē chā'tu' ixtā'lāquiclhlaktzi'ca'n natahuan chā'tu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Xatāta' ixtā'lāquiclhlaktzi' nahuan ixka'hua'cha ē ka'hua'cha ixtā'lāquiclhlaktzi' nahuan ixtāta'. Ixtzī' ixtā'lāquiclhlaktzi' nahuan ixtzu'ma'jāt ē tzu'ma'jāt ixtā'lāquiclhlaktzi' nahuan ixtzī'. Puscāt ē ixpuhuiti' natalāquiclhlaktzī'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nā Jesús cāhuanilh tachi'xcuhuī't: ―A'cxni' hui'xina'n laktzī'nā'tit tā'kaquī'mā'cha' poklhnu' jā tā'cnū chi'chini', palaj tunca hua'nā'tit namin xcān. Ē chuntza' a'kspula. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","A'cxni' minācha' ū'ni' xala' nac sur, huancan nalhcācna'n. Ē chuntza' la. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Hui'xina'n tlahua'yā'tit a'ktu' milacanca'n! Tzē nahuanā'tit palh namin xcān o jā namin, xmān ixpālacata laktzī'nā'tit a'kapūn. ¿Tū ixpālacata jā cuenta tlahua'yā'tit tū a'kspulamā'lh nac cā'quilhtamacuj a'cxni' laktzī'nā'tit lī'a'cnīn? ");
INSERT INTO tkuNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Jesús cāhuanipālh: ―¿Tū ixpālacata jāla puhua'nā'tit palh catūhuālh tze o jā tze? ");
INSERT INTO tkuNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Palh catīhuālh mālacapū'yān, calacapāstacti chī palaj nalītā'lācāxla'ya' līhuan jāna'j pinā'tit nac pūchihuīn ē chuntza' jā catilē'n na ixlacatīn juez. Palh nalē'nān na ixlacatīn juez, xla' namacamāstā'yān na ixmacan policía ē xlaca'n natamānūyān nac pūlāchī'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Palh chuntza' na'a'kspulayān icuaniyān jā catitaxtu hasta jā naxokokō'ya' ixlīpō'ktu. ");
INSERT INTO tkuNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tzamā' quilhtamacuj tamilh chi'xcuhuī'n. Ixtahuanimā'nalh Jesús chī Pilato cāmāmaknīnīni'lh makapitzīn chi'xcuhuī'n xalanī'n nac Galilea. Cāmaknīca a'cxni' ixtalīlakatāyamā'nalh Dios animalhna'. ");
INSERT INTO tkuNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús cāhuanilh: ―¿Ē puhua'nā'tit chuntza' cā'a'kspulanī't tzamā' chi'xcuhuī'n ixpālacata ā'chulā' ixtalaclē'n ē jā ā'makapitzīn xalanī'n nac Galilea? ");
INSERT INTO tkuNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Iccāhuaniyān jā chuntza'. Palh hui'xina'n jā nalakpalī'yā'tit mintalacapāstacni'ca'n, nā milīpō'ktuca'n nanīkō'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kelhacāujtzayan tī tanīlh a'cxni' torre Siloé a'kā'lh ē cā'a'klhta'lalh, ¿ē puhua'nā'tit ā'chulā' ixtalaclē'n ē jā ā'makapitzīn xalanī'n nac Jerusalén? ");
INSERT INTO tkuNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Iccāhuani'yān jā chuntza'. Palh hui'xina'n jā nalakpalī'yā'tit mintalacapāstacni'ca'n, nā nanī'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Palaj tunca Jesús cāhui'līni'lh tzamā' tū talīca'tzīni'lh ē cāhuanilh: ―Chā'tin chi'xcu' ixcha'nī't pūlactin xaqui'hui' higo na ixti'ya't. A'cxni' a'lh laktzī'n palh ixua'ca'lhtza', jā maclani'lh ixtahua'ca't. ");
INSERT INTO tkuNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Palaj tunca huanilh ixtasācua': “A'ktu'tuntza' cā'ta icmakputza ixtahua'ca't huā'mā' qui'hui' ē jā tū icmaclanī't. Catanca'; xmān yālh. Jā tū līmacuan iccha'nli.” ");
INSERT INTO tkuNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tī ixmaktaka'lha ti'ya't kelhtīlh: “Camakxtekti xmān huā'mā' cā'ta. Na'iclakponkni' ti'ya't ē na'icmaka'ni' abono. ");
INSERT INTO tkuNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Palhāsā' natahua'ca' huā'mā' cā'ta. Palh jā tahua'ca'lh nahuan a'cxni' natancā'ya'.” ");
INSERT INTO tkuNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","A'ktin quilhtamacuj tū ixpūjaxcan, Jesús ixcāmāsu'yuni'mā'lh nac templo. ");
INSERT INTO tkuNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ixuī'lh a'ntza' chā'tin puscāt tī ixta'jatatla a'kcāujtzayan cā'ta. Ixchi'panī't a'ktin jā tzeya ū'ni' ē ixmakata'jatatla ē ixtacupucsnī'ttza' ē jātza' la ixtā'klhsaja nūn macsti'na'j. ");
INSERT INTO tkuNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesús, a'cxni' laktzī'lh puscāt, ta'sani'lh ē huanilh: ―Puscāt, tzeyanī'ta'tza'. Jātza' ka'lhī'ya' minta'jatat. ");
INSERT INTO tkuNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Palaj tunca Jesús a'cpūhui'līlh ixmacan ē palaj tunca puscāt tastu'ncli ē tzuculh laktaquilhpūta Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Xapuxcu' xala' nac templo sītzī'lh ixpālacata Jesús mātzeyīlh tzamā' quilhtamacuj tū pūjaxcan, ē cāhuanilh tachi'xcuhuī't: ―Xmān a'kchāxan quilhtamacuj nascujā'tit. Ē tzamā' quilhtamacuj a'cxni' cata'ntit tacu'chu'yā'tit ē jā a'cxni' jaxcan. ");
INSERT INTO tkuNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Palaj tunca Jesús kelhtīlh: ―¡Tlahua'yā'tit a'ktu' milacanca'n! ¿Ē jā catixcuttit mihuācaxca'n o mimburroca'n tzamā' quilhtamacuj tū pūjaxcan ē namāko'tnīyā'tit? ");
INSERT INTO tkuNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Huā'mā' puscāt ī'xū'nātā'nat Abraham ē hua'chi līchī'hui'līlh skāhuī'ni' huā'mā' ta'jatat. Chuhua'j a'kcāujtzayantza' cā'ta. ¿Ē jā tze ixmaktīca ixta'jatat tzamā' quilhtamacuj tū pūjaxcan? ");
INSERT INTO tkuNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","A'cxni' Jesús huanli huā'mā', cāmāmāxanī'lh tī ixtaquiclhlaktzī'n. Ixlīpō'ktuca'n tachi'xcuhuī't ixtalīpāxuhua lī'a'cnīn tū tlahualh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Palaj tunca Jesús huanli: ―¿Chī huī'lh ixlīmāpa'ksīn Dios? ¿Chī na'iclīmāsu'yu chī natalīlhūhua'n xlaca'n tī Dios cāmāpa'ksī? ");
INSERT INTO tkuNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Natalhūhua'n chuntza' chī staca a'ktin xalīcha'nat mostaza tū cha'nli chā'tin chi'xcu' nac ti'ya't. Lacsti'na'j tzamā' xalīcha'nat ē a'cxni' nastackō', hua'chi a'katin qui'hui' nahuan. A'cxni' ka'tla'tza' ē a'ntza' spūnī'n natatlahua ixmāsekca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Nā Jesús cāhuanilh: ―¿Chī na'iclīmāsu'yu chī nalīstaca ixlīmāpa'ksīn Dios? ");
INSERT INTO tkuNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ū'tza' hua'chi a'ktin levadura tū chā'tin puscāt nalītlahua maktu'tun xatapūlhcān harina ē namakxteka hasta nalaklhtāyakō' ixtasquit. ");
INSERT INTO tkuNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesús tayapālh ixtej nac Jerusalén. Ixtētaxtu nac cā'lacchicni' jā macsti'na'j ē jā laka'tla' ē ixmāsu'yu. ");
INSERT INTO tkuNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Chā'tin kelhasqui'nīlh: ―¿Ē xmān makapitzīn nata'a'kapūtaxtu? Jesús kelhtīlh: ");
INSERT INTO tkuNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Calīhui'lī'tit natanū'yā'tit xapītzuna'j xamākelhcha nac a'kapūn. Iccāhuaniyān lhūhua' nataputza chī natalītanūcu'tun ē jāla catitatanūlh. ");
INSERT INTO tkuNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","A'cxni' ixtēcu' chic namālacchahua, hui'xina'n tī yā'na'ntit nac kēpūn nalīmacasā'na'nā'tit mākelhcha. Nahua'nā'tit: “Caquilāmālaquīni'uj.” Xla' nacākelhtīyān: “Jā icca'tzī jā xalanī'n hui'xina'n.” ");
INSERT INTO tkuNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Hui'xina'n naquilhtzucuyā'tit nahua'nā'tit: “Iccātā'huā'yanī'ta'n ē hui'x māsu'yu'nī'ta' na quincā'lacchicni'ca'n.” ");
INSERT INTO tkuNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Xla' nacākelhtīyān: “Iccāhuaninī'ta'ntza' jā icca'tzī jā xalanī'n hui'xina'n. ¡Caquilātapānūni'uj! Hui'xina'n tlahua'yā'tit tū jā tze.” ");
INSERT INTO tkuNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Chuntza' hui'xina'n nacalhua'nā'tit a'ntza' ē nalāmāxcani'yā'tit mintatzanca'n a'cxni' nalaktzī'nā'tit Abraham ē Isaac ē Jacob ē ixlīpō'ktuca'n a'kchihuīna'nī'n tahui'lāna'ncha' jā Dios māpa'ksīni'nkō' ē hui'xina'n jā caticātamakxtekni' natanū'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","’Nataminācha' tachi'xcuhuī't xalanī'n calhāxcuhuālh ē natahuā'yan jā Dios māpa'ksīni'nkō'. ");
INSERT INTO tkuNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tzamā' quilhtamacuj nacālakachi'xcuhuī'can xlaca'n tī jā ixlacasqui'nca chuhua'j; ē tī cālakachi'xcuhuī'cantza' chuhua'j ē ā'līstān jātza' caticālakachi'xcuhuī'ca ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Chū ū'tza' tzamā' quilhtamacuj ā'makapitzīn fariseos talakchilh Jesús ē tahuanilh: ―Cataxtu huā'tzā' ixpālacata Herodes maknīcu'tunān. ");
INSERT INTO tkuNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesús cākelhtīlh: ―Calakpintit tzamā' chi'xcu' tī a'kskāhuī'nin ē nahuani'yā'tit: “Chuhua'j ē lakalī na'iccāmāxtukō' jā tzeya ū'ni'. Ē ā'nā na'iccāmātzeyī ta'jatatlanī'n. Tū'xama'n na'ictlahuakō'.” ");
INSERT INTO tkuNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ixlacasqui'nca na'ica'n na quintej chuhua'j ē lakalī ē tū'xama'n ixpālacata jā minī'ni' calhāxcuhuālh nanī chā'tin a'kchihuīna', xmān jā huanican nac Jerusalén. ");
INSERT INTO tkuNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","¡Iccālakalhu'manān hui'xina'n xalanī'n nac Jerusalén! Hui'xina'n cāmaknīyā'tit a'kchihuīna'nī'n ē cācucta'layā'tit lacscujnī'n tī Dios cāmacamini'yan. Maklhūhua' xa'iccāmākēstokcu'tunān na'iccāmaktaka'lhān hua'chi xatzī' caxli cālīmātzē'ka ixpeken ixlacstīn ē jā lacasqui'ntit. ");
INSERT INTO tkuNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Calaktzī'ntit hui'xina'n chī Dios makxteklitza' mincā'lacchicni'ca'n. Iccāhuaniyān jātza' quintilālaktzī'mpalayāuj hasta a'cxni' tzamā' quilhtamacuj a'cxni' nahuancan: “Sicua'lanātlahuanī't tī min ē ka'lhī ixlītli'hui'qui ē ixlīmāpa'ksīn Dios.” ");
INSERT INTO tkuNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Milh a'ktin quilhtamacuj tū pūjaxcan ē a'cxni' Jesús quīmakuā'yalh na ixchic chā'tin xapuxcu' fariseos. Ā'makapitzīn fariseos ixtamaktaka'lhmā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nā ixuī'lh chā'tin chi'xcu' na ixlacatīn tī ixcu'nī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Palaj tunca Jesús cākelhasqui'nīlh xamākelhtahua'kē'ni'nī'n līmāpa'ksīn ē fariseos: ―Ixlīmāpa'ksīn Moisés ¿ē makxteka namātzeyīcan chā'tin ta'jatatlani' tzamā' quilhtamacuj tū pūjaxcan? ");
INSERT INTO tkuNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Xlaca'n ca'cs tatāyalh. Palaj tunca Jesús macachi'palh ta'jatatlani' ē mātzeyīlh ē huanilh ca'a'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Cāhuanilh fariseos: ―Palh mimburroca'n o mihuācaxca'n nakōstojō xapūlhmā'n nac xcān, ¿ē jā palaj namācutuyā'tit masqui quilhtamacuj tū pūjaxcan? ");
INSERT INTO tkuNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Jā tū takelhtīni'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","A'cxni' Jesús laktzī'lh tī cā'invitarlīcanī't ē chī ixtaputzamā'nalh pūtahuī'lh tū ā'chulā' xatze, cāmaxquī'lh huā'mā' talacapāstacni': ");
INSERT INTO tkuNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―A'cxni' na'invitarlīca'na' jā tamakaxtokcan, jā titahui'la'ya' jā xatze pūtahuī'lh. Palhāsā' nachin ā'chā'tin tī ā'chulā' ixlacasqui'nca ē jā hui'x. ");
INSERT INTO tkuNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Tī invitarlīyān nalaka'nān nahuaniyān: “Cama'xqui' mimpūtahuī'lh huā'mā' chā'tin tī ā'līstān chilh.” Chuntza' līmāxana'tza' napina' natahui'la'ya' nac cā'chakēn. ");
INSERT INTO tkuNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","A'cxni' na'invitarlīca'na', natahui'la'ya' nac cā'chakēn. A'cxni' namin tī invitarlīnī'ta'n nahuaniyān: “Cata't, catahui'la' nac mesa.” Chuntza' nalakachi'xcuhuī'ca'na' na ixlacatīnca'n ā'makapitzīn jā tamakaxtokcan. ");
INSERT INTO tkuNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tī ixa'cstu ka'tla' makca'tzī, ū'tza' namāmāxanī'can. Tī jā ixa'cstu putza ixlīka'tla', ū'tza' nalakachi'xcuhuī'can. ");
INSERT INTO tkuNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nā Jesús huanilh chi'xcu' tī ixinvitarlīnī't: ―A'cxni' natlahua'ya' mincā'tani' o mintahua', jā nacā'invitarlīya' xmān minamigos ē mintā'timīn ē mintalakapasnī'n ē lacricujnu'. Xlaca'n a'cxni' natatlahua ixcā'tani'ca'n, nā tzē nata'invitarlīyān ē chuntza' naka'lhī'ya' ixlakxoko mincā'tani'. ");
INSERT INTO tkuNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","A'cxni' natlahua'ya' mincā'tani', nacā'invitarlīya' tī lacxcamanīnī'n ē ta'jatatlanī'n ē lū'ntu'nunī'n ē lakatzī'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Chuntza' nalīpāxuhua'ya' ixpālacata xlaca'n jā tū catitamaxquī'n. Chuntza' naka'lhī'ya' mintatlaj a'cxni' natalacastālancuana'n ixlīpō'ktuca'n tī ta'a'ka'ī'ni' ixtachihuīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","A'cxni' takexmatli huā'mā', chā'tin tī ixuī'lh nac mesa huanilh Jesús: ―Līpāxuhua tī nahuā'yan jā Dios māpa'ksīni'nkō'. ");
INSERT INTO tkuNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Palaj tunca Jesús kelhtīlh: ―Chā'tin chi'xcu' hui'līlh a'ktin ka'tla' tahua' ē cā'invitarlīkō'lh lhūhua' tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","A'cxni' chā'lh hora tū pūhuā'yancan, cāmacā'lh ixtasācua' natamāca'tzīnīni'n ē cāhuanilh tī ixcā'invitarlīnī't: “Cata'ntit. Cāxuī'lakō'tza' ixlīpō'ktu.” ");
INSERT INTO tkuNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ixlīpō'ktuca'n tamacā'lh tachihuīn ixpālacata jāla ta'a'n. Chā'tin huanli: “Ā'cus ictamāhualh a'ktin ti'ya't ē ixlacasqui'nca na'ica'n na'iclaktzī'n. Icsqui'ni'yān naquimātza'nkēna'ni'ya' ixpālacata jāla icti'a'ncha'.” ");
INSERT INTO tkuNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Chā'tin chihuīna'mpālh: “Ictamāhualh tanquitzis par huācax ē ica'nā iccālaktzī'n palh tze tascuja. Icsqui'ni'yān a'ktin lītze caquimātza'nkēna'ni' ixpālacata jāla icti'a'ncha'.” ");
INSERT INTO tkuNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Chā'tin chihuīna'mpālh: “Ictamakaxtoklicus ē chuntza' jāla icti'a'ncha'.” ");
INSERT INTO tkuNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","’A'cxni' taspi'tli tasācua', huanikō'lh ixpatrón chī a'kspulalh. Ixpatrón sītzī'lh ē huanilh ixtasācua': “Palaj capit xatej nac cā'lacchicni' ē cacālī'ta' tī lacxcamanīnī'n ē ta'jatatlanī'n ē lū'ntu'nunī'n ē lakatzī'nī'n.” ");
INSERT INTO tkuNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","A'mpālh ē ā'līstān taspi'tpālh tasācua' ē huanli: “Ictlahualhtza' chuntza' chī quihua'ni' ē huī'lhcus jā tahui'lacan.” ");
INSERT INTO tkuNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ixtēcu' huanilh ixtasācua': “Capit nac tej jā ā'chulā' makat ē cuesa nacālī'ta'na' ē natatzuma quinchic. ");
INSERT INTO tkuNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Iccāhuaniyān jā tī chā'tin xlaca'n tī iccā'invitarlīlh pūla natahua' quilīhua't.” ");
INSERT INTO tkuNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Lhūhua' tachi'xcuhuī't ixtastālani' Jesús, ē xla' cālaktalakspi'tli ē cāhuanilh: ");
INSERT INTO tkuNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Palh catīhuālh quintapa'ksīni'cu'tun quit ixlacasqui'nca ā'chulā' napāxquī' Dios ē jā ixtāta' ē ixtzī' ē ixpuscāt ē ixlacstīn ē ixtā'timīn ē hasta ixa'cstu. Palh jā chuntza', jāla quintitā'scujli. ");
INSERT INTO tkuNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tī jā pātīni'ncu'tun quimpālacata ē jā latahui'lacu'tun chī icuī'lh quit, jāla quintitā'scujli. ");
INSERT INTO tkuNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","’Palh chā'tin chi'xcu' tlahuacu'tun a'ktin chic, pūla natlahua ixcuenta chī huanī't nalē'n tumīn. Chuntza' naca'tzī palh na'a'cchā'ni' tumīn tū nalītlahuakō'. ");
INSERT INTO tkuNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Palh jā chuntza' natlahua, nasputa ixtumīn a'cxni' xmāncus xatantūn yālh. ");
INSERT INTO tkuNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ixlīpō'ktu tī natalaktzī'n, natalīlītzī'n. Natahuan: “Huā'mā' chi'xcu' timātzuculh ixchic ē jā mā'ksputukō'lh.” ");
INSERT INTO tkuNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","’Jā tī chā'tin rey tī jā pūla nalacapāstaca palh tzē nalīskāhuī'lh a'kcāuj mil soldados ā'chā'tin rey ixtā'lāquiclhlaktzi' tī ka'lhī a'kpu'xam mil. ");
INSERT INTO tkuNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Palh ca'tzī jāla catiskāhuī'lh ixtā'lāquiclhlaktzi', namacā'n chā'tin lacscujni' natā'lācāxla a'cxni' makatcus mimā'cha'. ");
INSERT INTO tkuNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Chuntza' palh hui'xina'n jā makxtekcu'tunā'tit ixlīpō'ktu tū milaca'n, jāla quiscujnu'nī'n catihuantit. ");
INSERT INTO tkuNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Jesús cāhuanipālh: ―Masqui tze matzat, palh jātza' sko'ko'xnin, ¿chī nalīmāsko'kō'nuncan? ");
INSERT INTO tkuNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Jātza' tze. Xmāntza' namaka'ncan. Tī kexmata cuenta catlahualh. ");
INSERT INTO tkuNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ixlīpō'ktuca'n tī mātā'jīni'nī'n līxokot ē tī jā lactze, xlaca'n talaktalacatzuna'jīlh Jesús natakexmata. ");
INSERT INTO tkuNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Fariseos ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn ixtalīchihuīna'n Jesús. Talāhuanilh: ―Huā'mā' chi'xcu' cātā'huā'yan tachi'xcuhuī't tī jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Palaj tunca Jesús cāhui'līni'lh huā'mā' tū līca'tzīni'can: ");
INSERT INTO tkuNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Palh chā'tin chi'xcu' cāka'lhī a'ktin ciento purecu' ē palh namakatza'nkā lakatin, ¿tū natlahua? Nacāmakxteka ā'makapitzīn noventa y nueve jā tahuā'yamā'nalh nac cā'seketni'. Na'a'n naputza purecu' tū makatza'nkānī't. Naputza hasta jā namacla. ");
INSERT INTO tkuNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","A'cxni' namacla, napekxtūtahua'ca'līmin. ");
INSERT INTO tkuNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","A'cxni' nachā'mpala na ixchic, nacāmākēstoka ixamigos ē tī lacatzuna'j tahui'lāna'lh na ixchic. Nacāhuani: “Caquilātā'pāxuhuáuj chuhua'j ixpālacata icmaclalh quimpurecu' tū ixtza'nkānī't.” ");
INSERT INTO tkuNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Iccāhuaniyān ā'chulā' naka'lhī tapāxuhuān nac a'kapūn ixpālacata chā'tin tī lakpalī ixtalacapāstacni' ē jā chī xanoventa y nueve tī tapuhuan lactzeya chi'xcuhuī'n. Xlaca'n jā tamakca'tzī palh ixlacasqui'nca natalakpalī ixtalacapāstacni'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jesús cāhuanipālh: ―Palh chā'tin puscāt ka'lhī pekcāuj moneda ē palh namakatza'nkā pektin, namāpasī ixpūcās ē napa'lhna'n ē tzej naputza hasta jā namacla. ");
INSERT INTO tkuNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","A'cxni' namacla, nacāmākēstoka ixamigas ē tī lacatzuna'j tahui'lāna'lh na ixchic, ē nacāhuani: “Caquilātā'pāxuhuáuj ixpālacata icmaclalhtza' moneda tū xa'icmakatza'nkānī't.” ");
INSERT INTO tkuNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Iccāhuaniyān lacxtim natapāxuhua ángeles a'cxni' nalakpalī ixtalacapāstacni' chā'tin tī jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Nā Jesús huanli: ―Chā'tin chi'xcu' ixka'lhī chā'tu' ixcamana'. ");
INSERT INTO tkuNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Xastancu huanilh ixtāta': “Tāta', caquima'xqui' chuhua'j tū quila' nahuan.” Xatāta' cāmāpitzini'lh ixherenciaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Jā makās xastancu mākēstokkō'lh ixtamacatzucun ē a'lh makat ā'lacatin cā'lacchicni'. A'ntza' pāxcat līlakō'lh ixtumīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","’A'cxni' ixmakasputkō'nī'ttza' ixtumīn, lakmilh a'ktin tatzi'ncstat tzamā' nac cā'lacchicni' ē xla' tzuculh tzi'ncsa. ");
INSERT INTO tkuNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Palaj tunca a'lh putza jā namakscuja. Chā'tin chi'xcu' xala' nac cā'lacchicni' macā'lh nacāmaktaka'lha pa'xnī'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tihua'cu'tunli tū ixcāmāhuī'mā'lh pa'xni', ē jā tī chā'tin ixmaxquī' tū nahua'. ");
INSERT INTO tkuNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","’Palaj tunca tzuculh lacapāstaca: “Chī kelhalā't tasācua' na ixchic quintāta' jā tahuā'yamā'nalh ē cāquītāxtūni' ē quit ictzi'ncsnīmā'lh huā'tzā'. ");
INSERT INTO tkuNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Na'iclaka'mpala quintāta' ē na'icuani: Tāta', ictlahuani'nī'ta'n tū jā tze ē nā ictlahuanī't tū jā tze na ixlacatīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Jātza' minī'ni' naquihuani'ya' palh quit minka'hua'cha. Caquilīmāxtu hua'chi chā'tin mintasācua'.” ");
INSERT INTO tkuNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Palaj tunca tayalh ixtej nalaka'n ixtāta'. ’A'cxni' makatcus ixa'mā'cha' na ixchic, ixtāta' laktzī'lh ē lakapasli ē lakalhu'manli. Tu'jnun a'lh lakapāxtoka ixka'hua'cha ē skōkalh ē mu'sulh. ");
INSERT INTO tkuNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Palaj tunca ixka'hua'cha huanilh: “Tāta', ictlahuanī't tū jā tze na ixlacatīn Dios ē na milacatīn. Jātza' minī'ni' naquihuani'ya' palh quit minka'hua'cha.” ");
INSERT INTO tkuNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","’Masqui chuntza' huanilh ka'hua'cha, xatāta' cāhuanilh ixtasācua'n: “Calīta'ntit pūtin xasāsti' lu'xu' ē camālhekē'tit huā'mā' quinka'hua'cha. Camāmakanū'tit tū nalītasu'yu quinka'hua'cha ē camātūnū'tit ixcaclhi'. ");
INSERT INTO tkuNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Calīta'ntit huācax tū xako'ntīntza' ē camaknī'tit. Natlahuayāuj a'ktin cā'tani' ē nahuā'yanāuj. ");
INSERT INTO tkuNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Hua'chi xanīntza' ixuanī't huā'mā' quinka'hua'cha ē lacastālancuana'nī't. Ixtza'nkānī'ttza' ē icmaclapālh.” Ū'tza' lī'a'nalh tapāxuhuān. ");
INSERT INTO tkuNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Tzamā' quilhtamacuj xapuxcu' ixka'hua'cha ixa'nī't scuja. A'cxni' ixmimā'lh na ixchic, kexmatli chī ī'sla'knamā'ca ē ixtlī'mā'ca. ");
INSERT INTO tkuNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Palaj tunca ta'sani'lh chā'tin tasācua' ē kelhasqui'nīlh tūchu lamā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Xla' kelhtīlh: “Mat milh mistancu. Mintāta' māmaknīnīni'lh xako'ntīn huācax ixpālacata tze chilh ē jā ta'jatatla.” ");
INSERT INTO tkuNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","’Xapuxcu' sītzī'lh ē jā ixtanūcu'tun. Ixtāta' taxtulh ē huanilh catanūlh. ");
INSERT INTO tkuNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Xla' huanilh ixtāta': “Hui'x ca'tzīya' lhūhua'tza' cā'ta ictā'scujnī'ta'n ē pō'ktu quilhtamacuj ickexmatni'nī'ta'n. Jā maktin quimaxquī'nī'ta' nūn lakatin xaska'ta' chivo na'iccālītā'pāxuhua quinamigos. ");
INSERT INTO tkuNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Chuhua'j ixpālacata chilh huā'mā' minka'hua'cha tī pāxcat cātā'līlakō'lh mintumīn tī jā tzeya puscan ē hui'x māmaknīnīni'nī'ta' xako'ntīn huācax.” ");
INSERT INTO tkuNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","’Palaj tunca xatāta' huanilh: “Hui'x quinka'hua'cha ē hui'x pō'ktu quilhtamacuj quintā'hui'la', ē ixlīpō'ktu tū icka'lhī pō'ktu mila'. ");
INSERT INTO tkuNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Chuhua'j ixlacasqui'nca natlahuayāuj cā'tani' napāxuhuayāuj ixpālacata mistancu hua'chi xanīntza' ixuanī't ē lacastālancuana'mpālh. Hua'chi ixtza'nkānī'ttza' ē chuhua'j icmaclapālh.” ");
INSERT INTO tkuNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nā Jesús cāhuanilh ī'scujnu'nī'n: ―Ixuī'lh chā'tin patrón; rico ixuanī't. Ixka'lhī chā'tin xapuxcu' ixtasācua'. Mālacsu'yuca tzamā' xapuxcu' tasācua' chī pāxcat ixlīlani'mā'lh ixtumīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Palaj tunca ixpatrón māta'satīnīni'lh ē huanilh: “¿Chī quilīhuanimā'ca tzamā' tachihuīn tū mimpālacata? Caquimāsu'yuni' tū icmacamaxquī'nī'ta'n. Jātza' quintitā'scujti chī xapuxcu' tasācua'.” ");
INSERT INTO tkuNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","’Xapuxcu' tasācua' tahuī'lh ē tzuculh lacapāstaca: “¿Tūchu na'ictlahua chuhua'j ixpālacata quimpatrón quimaktīlh quintascujūt? Jā tli'hui'qui quit ē jāla ca'ictiscujli nac cā'tacuxtu, ē icmāxana'n na'icsqui'nīhuā'yan. ");
INSERT INTO tkuNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Quit icka'lhī quintalacapāstacni' ē chuntza' tzē na'icchā'n a'ktin nac chic na'icuā'yan a'cxni' jā tū icka'lhī quintascujūt.” ");
INSERT INTO tkuNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","’Chuntza' chā'tunu' cāmāta'satīnīni'lh tī ixtamaklaclē'n ixpatrón. Tī chā'lh pūla kelhasqui'nīlh: “¿Chī huanī't laclīpini'ya' quimpatrón?” ");
INSERT INTO tkuNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Xla' kelhtīlh: “Icmaklaclē'n a'ktin ciento barriles aceite.” Palaj tunca xapuxcu' tasācua' huanilh: “Ā' huī'lh minca'psnap. Palaj tunca catahui'la' ē catlahua'pala' ā'a'ktin xmān cincuenta.” ");
INSERT INTO tkuNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ā'līstān kelhasqui'nīlh ā'chā'tin: “¿Ē hui'x, chī huanī't laclīpini'ya'?” Huanilh: “A'ktin ciento cuartillo trigo.” Palaj tunca huanilh: “Ā' huī'lh minca'psnap. Catlahua'pala' ā'a'ktin xmān ochenta.” ");
INSERT INTO tkuNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","’Ixpatrón puhuanli xapuxcu' tasācua' skalalh huanli chī tlahualh. Chuntza' tī xalanī'n nac cā'quilhtamacuj lakskalalhna' chī natatlahua ixnegocioca'n. Ā'chulā' skalalhna' xlaca'n ē jā tī ta'a'ka'ī'ni' ixtachihuīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Quit iccāhuaniyān: Nacālīmaktāyayā'tit mintumīnca'n tī jā tū taka'lhī. Chuntza' a'cxni' nanī'yā'tit ē jāla catilī'pintit mintumīnca'n, nacātamānūyān jā pō'ktu natahui'la'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Tī tzej namaktaka'lha macsti'na'j tū macamaxquī'can, nā tzej namaktaka'lha lhūhua' palh namacamaxquī'can. Tī jā tzej namākentaxtū ixtascujūt tū jā ixlacasqui'nca, xla' jāla catimākentaxtūlh tū ā'chulā' ixlacasqui'nca. ");
INSERT INTO tkuNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Palh jāla cātamacamaxquī'yān tū xala' nac cā'quilhtamacuj, ¿chī nacātalīmacamaxquī'yān tū ixla' Dios? ");
INSERT INTO tkuNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Palh jā maktaka'lhā'tit tū cātamacamaxquī'yān hui'xina'n, jā caticātamaxquī'n tū milaca'n nahuan. ");
INSERT INTO tkuNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Jā tī chā'tin tasācua' tzē nacātā'scuja chā'tu' ixpatrón. Chā'tin napāxquī' ē ā'chā'tin jā catilaktzī'ncu'tunli. Nakexmatni' chā'tin ē nalakmaka'n ā'chā'tin. Nā chuntza' hui'xina'n jāla nalīpāhua'nā'tit Dios palh nalīpāhua'nā'tit mintumīnca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseos tī ixtapāxquī' ixtumīnca'n ixtakexmatmā'nalh ixlīpō'ktu huā'mā' ē ixtalīlītzī'mā'nalh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Palaj tunca Jesús cāhuanilh: ―Masqui hui'xina'n lacasqui'nā'tit tachi'xcuhuī't natapuhuan lactze hui'xina'n, Dios cālakapasni'yān milīstacna'ca'n. Masqui cā'a'kskāhuī'yā'tit chi'xcuhuī'n ē chuntza' xlaca'n cātalakachi'xcuhuī'yān, Dios lakmaka'n tū tachi'xcuhuī't tapuhuan ā'chulā' ka'lhī ixtapalh. ");
INSERT INTO tkuNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jesús cāhuanipālh: ―Ixuī'lh ixlīmāpa'ksīn Moisés hasta a'cxni' ixlatlā'huan Juan Mā'kpaxīni', ē ū'tza' lacxtim chī tamāsu'yulh a'kchihuīna'nī'n. Chuhua'j talīchihuīna'n xatze tachihuīn ixpālacata chī Dios māpa'ksīni'nkō' ē ixlīpō'ktu tatanūcu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Jicslīhua' namālaksputūcan a'kapūn ē ti'ya't, ē ā'chulā' jicslīhua' nalakpalīcan ixtachihuīn Dios. Jā catilakpalīca nūn macsti'na'j. ");
INSERT INTO tkuNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Jesús cāhuanipālh: ―Palh chā'tin chi'xcu' namakxteka ixpuscāt ē natā'tamakaxtoka ā'chā'tin, xla' ka'lhī ixtā'lāpāxquī'n na ixlacatīn Dios. Tī tā'tamakaxtoka chā'tin puscāt tī makxtekcanī'ttza', nā xla' ka'lhī ixtā'lāpāxquī'n na ixlacatīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesús cāhuanipālh: ―Ixuī'lh chā'tin chi'xcu'; rico ixuanī't. Ixlhakā' ixlu'xu' xalactze. Lakalīyān ixtlahua cā'tani'. ");
INSERT INTO tkuNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nā ixuī'lh ā'chā'tin chi'xcu'; ixtacuhuīni' Lázaro. Lhūhua' ixka'lhī ixmactzi'tzi'. Ixtahui'la ī'squi'nīhuā'yan na ixtanquilhtīn rico. ");
INSERT INTO tkuNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Xla' ixlīka'scu'tun xalacpītzun pāntzīn tū ixyuja na ixmesa rico. Chichi'n ixtasnakani' ixtzi'tzi'. ");
INSERT INTO tkuNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","’Milh a'ktin quilhtamacuj ē Lázaro nīlh, ē ángeles talē'lh nac a'kapūn. Nā a'ntza' ixuī'lh Abraham. Nā rico nīlh ē mā'cnūca. ");
INSERT INTO tkuNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","’A'cxni' ixpātīni'mā'lh rico nac pūpātīn, talacayāhualh ē cālaktzī'lh Abraham ē Lázaro ixchā'tu'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Palaj tunca ta'salh ē huanli: “Quintāta' Abraham, caquilakalhu'ma'nti ē cama'cata' Lázaro camojōlh nac xcān kentin ixmakaspulh ē camāske'hui'huī'lh quisī'ma'kā' ixpālacata icpātīni'mā'lh na ixpu'nan lamana'.” ");
INSERT INTO tkuNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","’Abraham huanilh: “Quinka'hua'cha, calacapāstacti chī tzej ixlapā't na milatamat ē Lázaro jā tze ixlamā'lh. Chuhua'j xla' pāxuhuamā'lh huā'tzā' ē hui'x pātīni'mpā't a'ntza'. ");
INSERT INTO tkuNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nā huī'lh a'ktin ka'tla' pūlhu'cu' tū quincāmāpāpitziyān. Chuntza' tī ta'a'ncu'tun a'ntza' jāla catita'a'lh ē nūn xalanī'n a'ntza' jāla catitamilh huā'tzā'.” ");
INSERT INTO tkuNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","’Palaj tunca rico huanli: “Quintāta' Abraham, icsqui'ni'yān cama'capi Lázaro na ixchic quintāta' ");
INSERT INTO tkuNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","nacāhuani kelhaquitzis quintā'timīn tī tahui'lāna'ncha'cus. Chuntza' xlaca'n jā catitamilh huā'tzā' nac pūpātīn.” ");
INSERT INTO tkuNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","’Abraham huanilh: “Xlaca'n taka'lhītza' tū tzo'kli Moisés ē profetas. Cuenta catatlahualh ū'tza'.” ");
INSERT INTO tkuNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Rico kelhtīni'lh: “Ixlīcāna'. Ū'tza' icca'tzītza'. Masqui chuntza' icca'tzī, icpuhuan palh ixcālaka'lh chā'tin tī nīnī'ttza', ixtalakpalīlh ixtalacapāstacni'ca'n.” ");
INSERT INTO tkuNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham huanilh: “Palh jā cuenta tatlahua tū tzo'kli Moisés ē profetas, jā catita'a'ka'ī'lh masqui ixcālaka'lh chā'tin tī lacastālancuana'nī'ttza' na cā'līnī'n.” ");
INSERT INTO tkuNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús cāhuanilh ī'scujnu'nī'n: ―Masqui pō'ktu huī'lh tū nacāmāmakahuasī tachi'xcuhuī't, koxa titala xlaca'n tī tamāmakahuasī ā'makapitzīn ē tamātlahuī tū jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Xatze ixpixchī'hua'ca'ca a'ktin chihuix ē ixmacā'nca nac mar, ē jā ixmāmakahuasīlh jā tī chā'tin tī tzucumā'lhcus a'ka'ī'. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Cuenta catlahua'tit. ’Palh mintā'tin tlahuani'nī'ta'n tū jā tze, nalacaquilhnī'ya'. Palh xla' lacpuhuan jā tze tū tlahualh, namātza'nkēna'ni'ya'. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Namātza'nkēna'ni'ya' masqui a'ktin quilhtamacuj maktojon catlahualh tū jā tze ē maktojon nalakminān nahuaniyān: “Jā tze quit tū ictlahuani', ē jātza' ā'maktin ictitlahualh.” ");
INSERT INTO tkuNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ixapóstoles tahuanilh Jesús: ―Caquilāmaktāyauj ē ā'chulā' na'ica'ka'ī'yāuj. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Māpa'ksīni' cāhuanilh: ―Palh ixa'ka'ī'tit, masqui macsti'na'j, ixua'ni'tit huā'yālh qui'hui': “Catapu'lhu' ē capit catacha'nti nac mar.” Chuntza' qui'hui' ixtlahualh. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jesús cāhuanipālh: ―Palh hui'x ixka'lhīya' chā'tin mintasācua' tī scujnī'ttza' pō'ktu quilhtamacuj ē ixtaspi'tli na minchic, jā catihua'ni': “Catanu', cahuā'ya'.” ");
INSERT INTO tkuNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Palhāsā' nahuani'ya': “Cacāxtlahua' quilīhua't ē pūla naquimā'huī'ya' quit. Ā'līstān nahuā'ya'na' hui'x.” ");
INSERT INTO tkuNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","’A'cxni' mintasācua' natlahuakō' ixtascujūt, jā catimaxqui' tapāxcatca'tzīn ixpālacata xla' sa'j tasācua'. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Chuntza' hui'xina'n, a'cxni' tlahuakō'yā'tit ixlīpō'ktu ixtalacasqui'nīn Dios, nahuanā'tit: “Jā ixlacasqui'nca naquincāhuaniyān pāxcatca'tzīlh ixpālacata xmān ictlahuáuj quintascujūtca'n.” ");
INSERT INTO tkuNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","A'cxni' ixa'mā'lhcus nac Jerusalén, Jesús tētaxtulh lacalhūhua' cā'lacchicni' nac Samaria ē Galilea. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","A'cxni' ixtalacatzuna'jītēlhatza' a'ktin cā'lacchicni', kelhacāuj chi'xcuhuī'n tī ixcāmasni'mā'lh ixquinītca'n tataxtulh ē talakapāxtokli. Makat tatāyalh xlaca'n ");
INSERT INTO tkuNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ē palha' tahuanilh: ―¡Jesús, Mākelhtahua'kē'ni', caquilālakalhu'manui! ");
INSERT INTO tkuNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","A'cxni' Jesús cālaktzī'lh, cāhuanilh: ―Capintit cāmāsu'yuni'tit mimacni'ca'n pālejni'. A'cxni' xlaca'n ixta'a'mā'nalhcus nac tej, talaktzī'lh ixmacni'ca'n tzetza' ixtahuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Chā'tin xlaca'n, a'cxni' laktzī'lh ixtzeyanī'ttza', taspi'tli makapāxuītēlha Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Laktatzokostalh Jesús namaxquī' tapāxcatca'tzīn. Huā'mā' chi'xcu' xala' nac Samaria ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Palaj tunca Jesús huanli: ―¿Ē jā kelhacāuj tī tatzeyanli? ¿Tū ixpālacata jā tamilh makapitzīn kelhana'jāstza'? ");
INSERT INTO tkuNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Ē xmān huā'mā' samaritano taspi'tli naquimaxquī' tapāxcatca'tzīn? ");
INSERT INTO tkuNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Palaj tunca huanilh chi'xcu': ―Catāqui' ē catlā'hua'nti. Tzeyanī'ta' ixpālacata a'ka'ī'nī'ta'. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fariseos takelhasqui'nīlh Jesús: ―¿Jā'cxni' nalacchā'n a'cxni' namāpa'ksīni'nkō' Dios? Xla' cākelhtīlh: ―Chī Dios namāpa'ksīni'nkō', jā tasu'yu. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Jāla catihuanca: “Ā' huī'lh”, o “Ā' hui'lacha'.” Ixlīmāpa'ksīn Dios huī'lhtza' na ixlīstacna'ca'n tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Palaj tunca cāhuanilh ī'scujnu'nī'n: ―Namin a'ktin quilhtamacuj a'cxni' hui'xina'n nalaktzī'ncu'tunā'tit chī namāpa'ksīni'n Chi'xcu' xala' Tālhmā'n. Nalaktzī'ncu'tunā'tit masqui xmān a'ktin quilhtamacuj. Jā catilaktzī'ntit. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nacātahuaniyān: “Ā' huī'lh”, o “Ā' hui'lacha'.” Jā tipinā'tit ē jā tistālani'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Chuntza' chī tasu'yu a'ktin makli'pit tū palaj xkaka nac a'kapūn, chuntza' nala a'cxni' namin quinquilhtamacuj quit Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pūla na'icpātīni'n ē naquintalakmaka'n xalanī'n huā'tzā' nac cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","’Chuntza' chī a'kspulalh a'cxni' ixuī'lhcus Noé, nā chuntza' nala a'cxni' namin quinquilhtamacuj quit Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ixtahuā'yan ē ixtatamakaxtoka ē ixtamāstā'mā'nalh ixtzu'ma'jātca'n natā'tamakaxtokcan hasta a'cxni' quilhtamacuj tū pūtanūlh Noé nac arca. Lakuat milh ē tanīkō'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nā chuntza' a'kspulalh a'cxni' ixuī'lhcus Lot; ixtahuā'yamā'nalh ē ixtako'tnumā'nalh; ixtatamāhuana'mā'nalh ē ixtastā'namā'nalh; ixtacha'nāna'n ē ixtatlahua ixchicca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","A'cxni' Lot taxtulh nac cā'lacchicni' Sodoma, yujli macscut ē azufre nac a'kapūn ē cāmaknīkō'lh ixlīpō'ktuca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","’Chuntza' chī a'kspulalh a'cxni' ixtahui'lāna'lhcus Lot ē Noé, chuntza' nala a'cxni' na'iccātasu'yuni'yān quit Chi'xcu' xala' Tālhmā'n. Tachi'xcuhuī't jā tapuhuan palh palaj na'icmimpala. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’A'cxni' namin huā'mā' quilhtamacuj, tī huī'lh nac kēpūn ē ixtamacatzucun tanūmā'lh na ixchic, jā catitanūlh nacāmāxtu. Tī scujmā'cha' na ixā'tacuxtu, jā catitaspi'tli na ixchic nataya catūhuālh. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Calacapāstactit tū a'kspulalh ixpuscāt Lot. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tī makapūtaxtūcu'tun ixlīstacna', jā catilacapāstacli tū huī'lh nac cā'quilhtamacuj. Tī xmān lacapāstaca tū a'nan nac cā'quilhtamacuj, xla' jā cati'a'kapūtaxtulh. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Iccāhuaniyān tzamā' cā'tzī'sni' chā'tu' natalhtata a'ktin nac pūtama', ē Dios nalē'n chā'tin ē namakxteka chā'tin. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Chā'tu' puscan lacxtim natasquiti, ē Dios nalē'n chā'tin ē namakxteka chā'tin. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Chā'tu' chi'xcuhuī'n natascuja ixchā'tu'ca'n nac cā'tacuxtu, ē Dios nalē'n chā'tin ē namakxteka chā'tin. ");
INSERT INTO tkuNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","A'cxni' takexmatli huā'mā' tachihuīn, ī'scujnu'nī'n takelhasqui'nīlh: ―Māpa'ksīni', ¿ē jā'cxni' na'a'kspula huā'mā'? Xla' cākelhtīlh: ―Na'a'kspula chuntza' chī chū'ni' tatakēstoka calhāxcuhuālh jā mā'lh tū xanīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús cāmāsu'yuni'lh chī ixlakalīyān nata'orarlī ē jā maktin catitaxlajuani'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Cāhuanilh: ―Ixuī'lh a'ktin nac cā'lacchicni' chā'tin juez. Jā ixlakachi'xcuhuī' Dios ē jā cuenta ixcātlahua tī ixtaputza justicia. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nā a'ntza' tzamā' cā'lacchicni' ixuī'lh chā'tin tī nīmaka'ncanī't. Ixlakalīyān ixa'n laktzī'n juez natlahuani'can a'ktin justicia ixpālacata ixtā'lāquiclhlaktzi'. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ixlīmaklhūhua'tza' ixuani juez ē jā ixtlahuani' justicia. Ā'līstān puhuanli: “Masqui jā iclakachi'xcuhuī' Dios ē jā quincuenta tī taputza justicia, ");
INSERT INTO tkuNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","huā'mā' tī nīmaka'ncanī't jicstza' quimāhuī'lh. Ū'tza' na'iclītlahuani' justicia. Chuntza' jātza' catimilh jics quimāhuī'.” ");
INSERT INTO tkuNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Māpa'ksīni' Jesús huanli: ―Cuenta catlahua'tit tū tlahualh juez masqui jā tze ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ā'chulā' nacālīmaktāya Dios xlaca'n tī cālacsacnī't ē tī ixlakalīyān ē pō'ktu tzī'sa tasqui'ni'. ¿Ē natamakapalī nacāmaktāya? ");
INSERT INTO tkuNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Iccāhuaniyān palaj nacālīmaktāyayān. Quit Chi'xcu' xala' Tālhmā'n. A'cxni' na'icmimpala, ¿ē na'icmacla tī ta'a'ka'ī' nac cā'quilhtamacuj tī tasqui'ni'mā'nalh Dios ixlakalīyān? ");
INSERT INTO tkuNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesús cāhuanipālh tamāsu'yun ixpālacata tī tapuhuan xlaca'n xalactze ē talakmaka'n ā'makapitzīn. Huanli: ");
INSERT INTO tkuNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Chā'tu' chi'xcuhuī'n ta'a'lh nac templo nata'orarlī. Chā'tin xlaca'n fariseo ixuanī't, ē ā'chā'tin mātā'jīni' līxokot ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseo tāyalh orarlī chuntza': “Dios, icmaxquī'yān tapāxcatca'tzīn quit jā hua'chi ā'makapitzīn. Jā icka'lhāna'nī't. Jā ictampi'lhīni'nī't. Quit jā icka'lhī quintā'lāpāxquī'n. Ē quit jā chuntza' chī huā'mā' mātā'jīni' līxokot. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","A'ktu' quilhtamacuj chī a'ktin semana quit jā icuā'yan, ē icmāstā' quindiezmo chuntza' chī ixlacasqui'nca.” ");
INSERT INTO tkuNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","’Xtum huanli mātā'jīni'. Xla' makat tāyalh. Jā ixtalacayāhuacu'tun. Ixcu'xatucsmā'ca ixa'cstu ē ixuan: “¡Dios, caquilakalhu'ma'nti ixpālacata quit jā tze!” ");
INSERT INTO tkuNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","’Iccāhuaniyān huā'mā' mātā'jīni' ā'chulā' tze tasu'yu na ixlacatīn Dios ē jā fariseo. Chuntza' tī ka'tla' makca'tzī, xla' namāmāxanī'can. Tī jā ka'tla' makca'tzī, ū'tza' nalakachi'xcuhuī'can. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nā Jesús cālīmini'ca lacstīn nacā'a'cpūhui'lī ixmacan. A'cxni' talaktzī'lh ī'scujnu'nī'n, talacaquilhnīlh tī ixtalīmin. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesús cāmāta'satīnīni'lh lacstīn ē cāhuanilh ī'scujnu'nī'n: ―Cacāmakxtektit lacstīn caquintalakmilh ē jā cacāmāmakchuyī'tit ixpālacata tī natā'tapa'ksī Dios a'ntza' jā māpa'ksīni'nkō', xlaca'n tī naquintalīpāhuan chuntza' chī tzamā' lacstīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ixlīcāna' iccāhuaniyān. Tī jā ta'a'ka'ī'ni' ixtachihuīn Dios chuntza' chī lacstīn ta'a'ka'ī', jā maktin catitatanūlh jā Dios māpa'ksīni'nkō'. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Chā'tin xapuxcu' kelhasqui'nīlh Jesús: ―Tzeya Mākelhtahua'kē'ni' hui'x. ¿Tūchu na'ictlahua na'icka'lhī quilatamat tū jā catilaksputli? ");
INSERT INTO tkuNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús huanilh: ―¿Tū ixpālacata quihuani'ya' tze quit? Xmān chā'tin tī xatze ē ū'tza' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Hui'x ca'tzīya' ixlīmāpa'ksīn Dios tū chuntza' huan: Jā tika'lhīya' mintā'lāpāxquī'n. Jā timaknīni'na'. Jā tika'lhāna'na'. Jā tilīchi'huīna'na' ā'chā'tin tū jā ixlīcāna'. Cacālakachi'xcuhuī' mintāta' ē mintzī'. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Chi'xcu' kelhtīlh: ―Pō'ktu tzamā' icmākentaxtūkō'nī'ttza' hasta quilīska'ta'. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","A'cxni' kexmatli huā'mā', Jesús huanilh: ―Ā'xmān a'ktin sputni'yān tū natlahua'ya'. Caquīstā'kō'j pō'ktu tū ka'lhī'ya' ē nacāmāpitzini'ya' tumīn xcamanīnī'n ē chuntza' naka'lhī'ya' tū rico nalīhua'na' nac a'kapūn. Ā'līstān naquintā'pina'. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","A'cxni' chi'xcu' kexmatli huā'mā' tachihuīn, līlīpuhuanli ixpālacata rico ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","A'cxni' Jesús laktzī'lh chī ixlīpuhuan, huanilh: ―Jicslīhua' natatā'tapa'ksī Dios xlaca'n tī lacricujnu'. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Jicslīhua' nalīpātle'kecu'tun lakatin camello na ixtani' līxtokon. Ā'līhua'ca' jicslīhua' natanū chā'tin rico jā Dios māpa'ksīni'nkō'. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tī takexmatli huā'mā' tahuanli: ―¿Tīchu tzē na'a'kapūtaxtū? ");
INSERT INTO tkuNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús cāhuanilh: ―Chi'xcuhuī'n jāla catitatlahualh tū natalī'a'kapūtaxtu; xmān Dios tzē nacāmakapūtaxtū. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedro huanilh: ―Quina'n ica'kxtekui'līkō'uj ixlīpō'ktu tū xa'icka'lhīyāuj ē iccāstālani'mā'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Palaj tunca Jesús cākelhtīlh: ―Ixlīcāna' tū iccāhuaniyān. Huī'lh tī nata'a'kxtekui'lī ixchicca'n natakexmatni' Dios. Ā'chulā' nataka'lhī nac cā'quilhtamacuj. Ē palh nata'a'kxtekui'lī ixtā'taca'n o ixtzī'ca'n o ixta'timinca'n o ixpuscātca'n o ixcamanaca'n, ");
INSERT INTO tkuNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ā'chulā' nataka'lhī nac cā'quilhtamacuj, ē nataka'lhī ixlatamatca'n tū jā catilaksputli jā Dios māpa'ksīni'nkō'. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús cāmāta'satīnīni'lh ī'scujnu'nī'n ē cāhuanilh: ―A'mā'nauj nac Jerusalén jā namākentaxtūkō'can ixlīpō'ktu tū tatzo'kli profetas quimpālacata quit Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Naquintamacamāstā' na ixmacanca'n tī jā israelitas ē naquintalakapala ē naquintalakmaka'n ē naquintalakachojmanī. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Naquintakēsnoka ē ā'līstān naquintamaknī. Ixlī'a'ktu'tun quilhtamacuj na'iclacastālancuana'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ī'scujnu'nī'n jā ixtakexmatni' tū huanicu'tun huā'mā', nūn ixtaca'tzī tū ixlīchihuīna'mā'lh ixpālacata hua'chi xatatzē'kni' tū ixcāhuanimā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","A'cxni' Jesús ixchā'mā'lhtza' nac cā'lacchicni' Jericó, ixuī'lh chā'tin lakatzī'n na ixpāxtūn tej. Ī'squi'nīhuā'yan. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","A'cxni' ixkexmata tētaxtumā'ca, ixkelhasqui'nīni'n tīchu ixtētaxtumā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Huanica Jesús xala' nac Nazaret ixtētaxtumā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Palaj tunca ta'salh ē huanli: ―¡Jesús! ¡Hui'x ixtā'nat David tī xa'icka'lhīmā'nauj! ¡Caquilakalhu'ma'nti! ");
INSERT INTO tkuNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tī ixtapūlani' Jesús talacaquilhnīlh lakatzī'n ē tahuanli caquilhca'cslalh, ē xla' ā'chulā' ta'salh ē huanli: ―¡Hui'x ixtā'nat David tī xa'icka'lhīmā'nauj! ¡Caquilakalhu'ma'nti! ");
INSERT INTO tkuNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Palaj tunca Jesús tāyalh ē huanli calīmini'ca. A'cxni' lacatzuna'j ixlakayālhtza', kelhasqui'nīlh: ");
INSERT INTO tkuNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Tūchu lacasqui'na' na'ictlahuani'yān? Lakatzī'n kelhtīlh: ―Māpa'ksīni', caquimālacahuā'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús huanilh: ―¡Calacahuā'na'! Hui'x a'ka'ī'nī'ta' quit tzē na'icmālacahuānīyān ē ū'tza' lītzeya'ntitza'. ");
INSERT INTO tkuNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Xamaktin lacahuāna'lh lakatzī'n. Stālani'lh Jesús, ē makapāxuītēlha Dios. Ixlīpō'ktuca'n tachi'xcuhuī't talaktzī'lh huā'mā' ē nā xlaca'n tamakapāxuīlh Dios ixlīpō'ktuca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","2","Ixuī'lh chā'tin rico; ixtacuhuīni' Zaqueo. Xapuxcu' mātā'jīni'nī'n līxokot ixuanī't. A'cxni' Jesús ixtētaxtumā'lh nac Jericó, a'ntza' ixuī'lh Zaqueo. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Huā'mā' Zaqueo ixlaktzī'ncu'tun Jesús ē ixlakapascu'tun. Jāla ixlaktzī'n Jesús ixpālacata a'ctzuna'j chi'xcu' ixuanī't ē lhūhua' tachi'xcuhuī't ixtokokecan. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Palaj tunca tu'jnumpūlalh jā natētaxtu Jesús ē tahua'ca'lh nac a'katin ka'tla' qui'hui' tū huanican sicómoro. Chuntza' tzē nalaktzī'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","A'cxni' Jesús ixtētaxtumā'lh a'ntza', talacayāhualh ē huanilh Zaqueo: ―Palaj cayujti. Chuhua'j na'ictētachoko na minchic. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zaqueo palaj tunca yujli ē līpāxuhua lē'lh Jesús na ixchic. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","A'cxni' talaktzī'lh huā'mā', ixlīpō'ktuca'n tatzuculh talīchihuīna'n ē talāhuanilh Jesús tachokolh na ixchic tī jā tzeya chi'xcu'. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ā'līstān Zaqueo tāyalh ē huanilh Jesús: ―Chuhua'j, na'iccāmaxquī' i'tāt tū icka'lhī xcamanīnī'n. Palh xa'iccā'a'kskāhuī'maktīnī't ā'makapitzīn, na'iccāmaxquī' maktā'ti' ixlakxoko. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús huanilh: ―Chuhua'j a'kapūtaxtunī'ta' ixpālacata a'ka'ī'nī'ta' chuntza' chī Abraham a'ka'ī'lh. Nā xalanī'n na minchic nata'a'kapūtaxtu. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Quit Chi'xcu' xala' Tālhmā'n icmilh iccāputza tī jā ta'a'ka'ī' ē na'iccāmāsu'yuni' chī nacālīmakapūtaxtūcan. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","A'cxni' ixtakexmatmā'nalh tachi'xcuhuī't tū ixcāhuanimā'lh Jesús, xla' cāhuanilh tū lītamāsu'yu. Ixtatalacatzuna'jīmā'nalh nac Jerusalén, ē xlaca'n tapuhuanli palaj natasu'yu chī Dios namāpa'ksīni'nkō' nac cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Palaj tunca Jesús cāhuanilh: ―Ixuī'lh chā'tin chi'xcu' ē xla' jā catīhuālh chi'xcu'. Ixa'mā'lh makat a'ktin nac ti'ya't jā nalīhui'līcan ixlīrey ē ā'līstān nataspi'tpala. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","A'cxni' ixtaxtumā'lhtza', cāmākextimīlh kelhacāuj ixtasācua' ē lacxtim cāmaxquī'lh lhūhua' tumīn chā'tunu' ē cāhuanilh: “Camāscujū'tit tzamā' tumīn hasta a'cxni' na'icmimpala.” ");
INSERT INTO tkuNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","’Tachi'xcuhuī't xalanī'n ixcā'lacchicni' jā ixtalaktzī'ncu'tun ē cāmāstālīca lacscujnī'n natahuan: “Jā iclacasqui'nāuj huā'mā' chi'xcu' rey nahuan.” ");
INSERT INTO tkuNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Masqui jā ixtalacasqui'n, līhui'līca ixlīrey ē chuntza' taspi'tli na ixti'ya't. ’A'cxni' chilh, cāmāta'satīnīni'lh tasācua' tī ixcāmaxquī'nī't tumīn. Ixca'tzīcu'tun chī ixtatlajanī'ttza'. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tī xapūla lakmilh ē huanli: “Mintumīn tlajanī't makcāuj.” ");
INSERT INTO tkuNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Rey kelhtīlh: “Tzeya tasācua' hui'x, ixpālacata tzej māscuju'nī'ta' masqui macsti'na'j tumīn. Na'icui'līyān milīgobernador lakacāuj cā'lacchicni'.” ");
INSERT INTO tkuNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","’Chā'mpālh chā'tin ē huanli: “Mintumīn tlajanī't makquitzis.” ");
INSERT INTO tkuNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nā kelhtīlh: “Hui'x nalītahui'la'ya' milīgobernador lakaquitzis cā'lacchicni'.” ");
INSERT INTO tkuNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","’Palaj tunca chā'mpālh chā'tin ē huanli: “Ā' huī'lh mintumīn. Icmāquī'lh a'ktin nac pixtahua'ca' ");
INSERT INTO tkuNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ixpālacata icjicua'ni'yān. Hui'x palha' milīmāpa'ksīn. Hui'x taya'ya' tū jā hui'līnī'ta' ē makalana'na' jā jā cha'nāna'nī'ta'.” ");
INSERT INTO tkuNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Palaj tunca rey huanilh: “Hui'x jā tzeya tasācua'. Mintachihuīn līmālacsu'yuyān. Hui'x puhua'na' palh quit palha' icmāpa'ksīni'n ē ictaya tū jā quit icui'līnī't, ē icmakalana'n jā jā quit iccha'nāna'nī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Tū ixpālacata jā hui'li' nac banco quintumīn? Chuntza' xa'icmaktīni'lh quintumīn ē ī'ska'ta' a'cxni' xa'ictaspi'tpālh na quinchic.” ");
INSERT INTO tkuNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","’Cāhuanilh tī ixtayāna'lh: “Camaktītit ixtumīn ē camaxquī'tit tī tlajanī't makcāuj.” ");
INSERT INTO tkuNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Tahuanilh: “Xla' ka'lhītza' makcāuj.” ");
INSERT INTO tkuNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Rey kelhtīni'lh: “Iccāhuaniyān ā'chulā' namaxquī'can tī ka'lhī, ē tī jā lhūhua' ka'lhī namaktīkō'can tū ka'lhī. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Quintā'lāquiclhlaktzi'nī'n tī jā talacasqui'n na'ictahui'la hua'chi rey, caquilī'ta'ni'tit ē cacāmaknī'tit na quilacatīn.” ");
INSERT INTO tkuNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","A'cxni' huankō'lh huā'mā', Jesús tayalh ixtej nac Jerusalén. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ixtalacatzuna'jīmā'lhtza' nac cā'lacchicni' jā huanican Betfagé ē jā huanican Betania. A'ntza' lacatzuna'j sipej jā huanican Olivos. Jesús cāmāpūlīlh chā'tu' ī'scujnu'nī'n ");
INSERT INTO tkuNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ē cāhuanilh: ―Capintit nac cā'lacchicni' tū tasu'yu milacatzuna'jca'n. A'cxni' nachipinā'tit, nalaktzī'nā'tit a'ktin xaska'ta' burro tū chī'yāhuacanī't. Jāna'j tī chā'tin ixkētahui'lanī't. Caxcuttit ē caquilālīmini'uj huā'tzā'. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Palh catīhuālh nacākelhasqui'nīyān: “¿Tū ixpālacata xcutpā'na'ntit burrito?” hui'xina'n nakelhtīni'nā'tit: “Māpa'ksīni' namaclacasqui'n.” ");
INSERT INTO tkuNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Scujnu'nī'n ta'a'lh ē tamaclalh chuntza' chī Māpa'ksīni' ixcāhuaninī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","A'cxni' ixtaxcutmā'nalh burro, ixtēcu' cāhuanilh: ―¿Tū ixpālacata xcutpā'na'ntit burro? ");
INSERT INTO tkuNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Xlaca'n takelhtīni'lh: ―Māpa'ksīni' namaclacasqui'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Lē'ni'ca Jesús palaj tunca ē talīkētlapalh ixlu'xu'ca'n ē Jesús kētahuī'lh burro. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","A'cxni' Jesús ixa'mā'lhtza' punchuna'j, ixmāpī'ni'tēlhacan lu'xu' nac tej. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","A'cxni' ixtatalacatzuna'jītēlhatza' ē ixta'a'kapūmācha'tza' nac sipej Olivos, tatzuculh tapāxuhua ixlīpō'ktuca'n tī ta'a'ka'ī'lh ē ixtastālani'tēlha. Tata'salh ē tamakapāxuīlh Dios ixpālacata ixlīpō'ktu lī'a'cnīn tū talaktzī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ixtahuan: ―¡Sicua'lanālanī't Puxcu' tī mimā'lh ixpālacata ixlīmāpa'ksīn quinDiosca'n! ¡Līpāxuhua nac a'kapūn! ¡Calakachi'xcuhuī'ca Dios! ");
INSERT INTO tkuNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Palaj tunca ā'makapitzīn fariseos tī ixtayāna'lh na ixpu'nanca'n tachi'xcuhuī't, tahuanli: ―Mākelhtahua'kē'ni', cacāquilhni' tī tastālani'yān. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesús cākelhtīlh: ―Iccāhuaniyān palh tzamā' nataquilhca'csla, chihuixni' natata'sa. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","A'cxni' lacatzuna'jtza' ixa'mā'cha', Jesús laktzī'lh cā'lacchicni' Jerusalén ē calhuanli ");
INSERT INTO tkuNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ē huanli: ―¡Tze ixuanli mimpālacataca'n xalanī'n nac Jerusalén palh ixkexpa'ttit cahuālh chī nalī'a'kapūtaxtuyā'tit, masqui huā'mā' quilhtamacuj! Chuhua'j tatzē'knī't ē jāla cati'a'kapūtaxtutit. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Namin a'ktin quilhtamacuj tū jā tze. Mintā'lāquiclhlaktzi'ca'n natamin natayāhua a'ktin culalh ixmacni' mincā'lacchicni'ca'n ē nacātalītamacsti'li'yān calhāxcuhuālh. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nacātalīsno'ktamacatāyān nac ti'ya't. Nacātamaknīkō'yān milīpō'ktuca'n ē natalakpaklhkō' ē jā catimakxtekli nūn a'ktin chihuix ixa'cpūn talhta'm. Chuntza' nacā'a'kspulayān ixpālacata jā lakapastit Dios a'cxni' ticālakmin ixcāmakapūtaxtūcu'tunān. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Palaj tunca Jesús tanūlh xaka'tla' nac templo ē tzuculh cātamacxtu tī ixtastā'namā'nalh ē ixtatamāhuana'mā'nalh na ixtanquilhtīn templo. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Cāhuanilh: ―Tatzo'kni' na ixtachihuīn Dios: “Quinchic xmān ixpūtlahuacan oración.” Chī tlahua'pā'na'ntit līmāxtunī'tantit hua'chi ixpūtatzē'kni'ca'n ka'lhāna'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ixlakalīyān Jesús ixmāsu'yumā'lh nac templo. Ixtaputzani'mā'nalh chī natalīmaknī xanapuxcu'nu' pālejni' ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn ē nā māpa'ksīni'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Jā ixtamaclani' chī natalīmaknī ixpālacata ixlīpō'ktuca'n tachi'xcuhuī't ca'cs ixtakexmatmā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","A'ktin quilhtamacuj Jesús ixcāmāsca'tīmā'lh tachi'xcuhuī't nac templo ē ixcāmāsu'yuni'mā'lh chī tzē nalī'a'kapūtaxtucan. Tachilh xanapuxcu'nu' pālejni' ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn ē nā xanapuxcu'nu' israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Tahuanilh: ―Caquilāhuaniuj: ¿Tī ixlīmāpa'ksīn cālītlahua'pā't tzamā'? ¿Tīchu maxquī'n huā'mā' līmāpa'ksīn? ");
INSERT INTO tkuNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Palaj tunca cāhuanilh Jesús: ―Nā quit na'iccākelhasqui'nīyān catūhuālh. Caquilākelhtīuj: ");
INSERT INTO tkuNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Tī ixlīmāpa'ksīn ixlīmā'kpaxīni'n Juan? ¿Ixlīmāpa'ksīn Dios o ixlīmāpa'ksī'nca'n chi'xcuhuī'n? Caquilākelhtīuj. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Xlaca'n tatzuculh talālītā'chihuīna'n ixlīmānca'n ē talāhuanilh: ―¿Chī nahuaniyāuj? Palh nahuaniyāuj Dios māpa'ksīlh Juan, naquincākelhasqui'nīyān: “¿Tū ixpālacata jā a'ka'ī'nī'ta'ntit?” ");
INSERT INTO tkuNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Palh nahuaniyāuj chi'xcuhuī'n tamāpa'ksīlh, ixlīpō'ktuca'n tachi'xcuhuī't naquincātacucta'lamaknīyān ixpālacata xlaca'n tahuan Juan ixlīcāna' ixa'kchihuīna' Dios ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Chuntza' takelhtīlh jā ixtaca'tzī tīchu ixlīmāpa'ksīn ixlīmā'kpaxīni'n Juan. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Palaj tunca Jesús cāhuanilh: ―Nā chuntza' quit jā icticāhuanin tīchu ixlīmāpa'ksīn iccālītlahua huā'mā'. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Palaj tunca Jesús tzuculh cātā'chihuīna'n tachi'xcuhuī't. Cāhuanilh tū līca'tzīni'can: ―Ixuī'lh chā'tin chi'xcu' tī cha'nli mayāc tū māstā' uva. Ā'līstān māsācua'nīlh ixti'ya't makapitzīn tasācua'n natascuja i'tātna' ē makās a'lh ā'lacatin. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","’A'cxni' chilhtza' ixpūlan uvas, macā'lh ī'scujni' na ixpū'uva. A'lh cāsqui'ni' tasācua'n catamaxquī'lh tū tamakalanī't tū ixla' ixtēcu' ti'ya't. Xlaca'n talacni'cui'līlh lacscujni' ē tzaj chuntza' māspi'tca. Jā tū tū maxquī'ca. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","’Palaj tunca ixtēcu' pū'uva macā'mpālh ā'chā'tin ixlacscujni'. Nā chuntza' tlahuaca chī xapūla; lacni'cui'līca ē talakapalalh ē chuntza' māspi'tca. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ixlīmaktu'tun macā'mpālh ā'chā'tin. Nā xla' mātakāhuī'ca ē makatzā'laca. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Ā'līstān ixtēcu' ti'ya't huanli: “¿Tūchu na'ictlahua? Na'icmacā'n quinka'hua'cha tī icpāxquī'. A'cxni' nalaktzī'ncan palhāsā' nalakachi'xcuhuī'can.” ");
INSERT INTO tkuNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","A'cxni' talaktzī'lh ka'hua'cha, tasācua'n talāhuanilh: “Ū'tza' tī ixla' nahuankō' tū ka'lhī ixtāta'. Camaknīuj ē chuntza' quilaca'n nahuan pū'uva.” ");
INSERT INTO tkuNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tamāxtulh nac pū'uva ē tamaknīlh. Jesús cākelhasqui'nīlh: ―Ixtēcu' pū'uva, ¿tū puhua'nā'tit nacātlahuani' tī ixtamakscujmā'nalh? ");
INSERT INTO tkuNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Na'a'n ē nacāmālaksputūkō' tzamā' tasācua'n ē nacāmāsācua'nī pū'uva ā'makapitzīn xtum tasācua'n. A'cxni' tachi'xcuhuī't takexmatli huā'mā' tachihuīn, tahuanli: ―¡Nūn calacasqui'nli Dios! ");
INSERT INTO tkuNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesús cālaktzī'lh ē huanli: ―¿Tū huanicu'tun tū tatzo'kni' na ixtachihuīn Dios? Chuntza' huan: Tapācna'nī'n talakmaka'lh chihuix ē tzamā' chihuix tū ā'chulā' ixlacasqui'nca. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Jesús chihuīna'mpālh: ―Tī jā tzej takexmata quintachihuīn, xlaca'n hua'chi tī talī'a'kchekxlalh chihuix ē tatakāhuī'lh. Tī jā ta'a'ka'ī' quintachihuīn, xlaca'n hua'chi tī cā'a'klhta'lalh ka'tla' chihuix ē cālakka'nkxli ē tanīlh. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Xanapuxcu'nu' pālejni' ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn titachi'pacu'tunli Jesús palaj tunca huā'mā' quilhtamacuj ixpālacata taca'tzīlh xlaca'n hua'chi scujnu'nī'n nac pū'uva. Jā tachi'palh ixpālacata ixtajicua'ni' tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Palaj tunca cālakmacā'nca maktaka'lhna'nī'n tī ixtatasu'yu lactzeya chi'xcuhuī'n. Cālakmacā'nca natakexmatxtu catūhuālh tū tzē natalīmālacsu'yun. Chuntza' tzē ixtalīmālacapū'lh na ixlacatīn gobernador. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ū'tza' talīkelhasqui'nīlh huā'mā': ―Mākelhtahua'kē'ni', icca'tzīyāuj tū hua'na' ē tū māsu'yu'ya' ū'tza' ixlīcāna'. Icca'tzīyāuj hui'x jā catlahua'ni'ya' cuenta chī talīchihuīna'nān tachi'xcuhuī't. Hui'x lacxtim cālaktzī'na' ixlīpō'ktuca'n tachi'xcuhuī't. Hui'x tzej māsu'yu'ya' chī Dios lacasqui'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Ē tze na'icxokoyāuj tū māta'jīni'n emperador romano o jā ixlacasqui'nca? ");
INSERT INTO tkuNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesús ixca'tzī xmān ixtalīlaktzī'ncu'tun ē cākelhasqui'nīlh: ―¿Tū ixpālacata quilālīlaktzī'ncu'tunāuj? ");
INSERT INTO tkuNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Caquilāmāsu'yuni'uj tumīn tū līxokocan. ¿Tīchu ixlacan tasu'yu nac huā'mā' tumīn ē tīchu ixtacuhuīni' tatzo'kni'? Takelhtīlh: ―Ixla' emperador. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Palaj tunca cāhuanilh: ―Camaxquī'tit emperador tū ixla' ē camaxquī'tit Dios tū ixla'. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jā tū tamaclalh tū tzē ixtalīmālacsu'yu tū ixuan ixlacatīnca'n tachi'xcuhuī't. Talī'a'cnīlh chī kelhtīni'lh ē chuntza' taquilhca'cslalh. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ā'līstān makapitzīn saduceos talaka'lh Jesús. Xlaca'n tamāsu'yu jā catilacastālancuana'nca. Ū'tza' talīhuanilh Jesús: ");
INSERT INTO tkuNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Mākelhtahua'kē'ni', Moisés quincāmakxtekni'nī'tan huā'mā' tatzo'kni': Palh nanī chā'tin chi'xcu' tī tamakaxtoknī'ttza' ē palh nīmakxtekli ixpuscāt ē jā tī ixka'hua'cha, ixlacasqui'nca ī'stancu natā'tamakaxtoka tī nīmaka'ncanī't. Xapūla ka'hua'cha tī nalacatuncuhuī' ixka'hua'cha nahuan xapuxcu' tī nīnī'ttza'. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","’Ixtahui'lāna'lh kelhatojon lītā'timīn. Xapuxcu' tamakaxtokli ē jā ka'lhīlh ī'ska'ta' a'cxni' nīlh. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ixlīchā'tu' tā'tamakaxtokli tī nīmaka'ncanī'ttza' ē chuntza' nīpālh chi'xcu'; jā tī chā'tin ī'ska'ta' makxtekli. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ixlīchā'tu'tun tā'tamakaxtokpālh tī nīmaka'ncanī'ttza' ē nā chuntza' ixlīkelhatojon ē ixlīpō'ktuca'n tanīlh; jā tī chā'tin ī'ska'ta'ca'n tamakxtekli. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ā'līstān nā puscāt nīlh. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","A'cxni' nalacastālancuana'ncan, ¿tīchu ixla' nahuan tzamā' puscāt? Ixkelhatojonca'n tatā'tamakaxtoknī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","A'cxni' Jesús cākelhtīlh: ―Huā'tzā' nac cā'quilhtamacuj tamakaxtokcan ē tamāmakaxtoka ixtzu'ma'janca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Tī natalacastālancuana'mpala ē natachā'n nac a'kapūn jātza' catitatamakaxtokli ē jātza' catitalāmāmakaxtokli, ");
INSERT INTO tkuNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ē jātza' maktin catitanīlh. Chuntza' natala hua'chi ixángeles Dios. Ixlacstīn Dios natahuan ixpālacata talacastālancuana'nī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nā Moisés quincāmāca'tzīnīyān chī nīnī'n natalacastālancuana'mpala, a'cxni' tzo'kli ixpālacata pūtzuna'j qui'hui' tū ixlamamā'lh. Tzo'kli chī Māpa'ksīni' ū'tza' ixDios Abraham ē ixla' Isaac ē ixla' Jacob. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Dios ū'tza' ixDiosca'n xalakahuan ē jā ixlaca'n xanīn. Dios cālaktzī'n ixlīpō'ktuca'n talakahuan. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Palaj tunca ā'makapitzīn xamākelhtahua'kē'ni'nī'n līmāpa'ksīn tahuanilh Jesús: ―Tzej kelhtīni'nī'ta'. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ē jātza' talīhui'līlh natakelhasqui'nī catūhuālh. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús cāhuanilh: ―¿Chī līhuancan Cristo tī Dios hui'līlh ixlīmakapūtaxtūnu' ū'tza' ī'xū'nātā'nat David? ");
INSERT INTO tkuNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David tzo'kli nac libro tū huanican Salmos: Māpa'ksīni' Dios huanilh quiMāpa'ksīni': “Catahui'la' na quimpekxtūcāna'j, ");
INSERT INTO tkuNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hasta a'cxni' na'iccāskāhuī'kō' mintā'lāquiclhlaktzi'.” ");
INSERT INTO tkuNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Palh David līchihuīna'nli ī'xū'nātā'nat ē māpācuhuīlh ixMāpa'ksīni', ū'tza' huanicu'tun xla' ā'chulā' xaka'tla' nalītaxtu ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ixlīpō'ktuca'n tachi'xcuhuī't ixtakexmatmā'nalh ē Jesús cāhuanilh ī'scujnu'nī'n: ");
INSERT INTO tkuNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Catamaktaka'lhtit ē jā ticāta'a'kskāhuī'yān xamākelhtahua'kē'ni'nī'n līmāpa'ksīn tī tapūlatā'kchokocu'tun xapūlhmā'n ixlu'xu'ca'n. Nā talacasqui'n cacātā'chihuīna'nca ē cacālakachi'xcuhuī'ca nac cā'tejen. Na ixtemploca'n israelitas xlaca'n taquilhpūlatahui'lacu'tun ē talacasqui'n cacālakachi'xcuhuī'ca jā tlahuacan cā'tani'. ");
INSERT INTO tkuNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Xlaca'n ta'a'kskāhuī'maktī ixchicca'n tī ixcānīmaka'ncanī'ttza' ē ā'līstān naj tunca ta'orarlī jā nacālaktzī'ncan ē chuntza' talī'a'kskāhuī'ni'n. Ā'chulā' natapātīni'n xlaca'n ē jā ā'makapitzīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús ixuī'lhcus nac templo ē cālaktzī'lh chī lacricujnu' ixtamojō lhūhua' tumīn jā māquī'can tumīn tū lakalhu'mancanī't Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nā laktzī'lh chā'tin tī nīmaka'ncanī't ē xcamanīn. Mojōlh pektu' ixtumīn ixla' cobre tū jā tapalaxla'. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesús huanli: ―Ixlīcāna' iccāhuaniyān. Huā'mā' xcamanīn tī nīmaka'ncanī't māstā'nī't tū ā'chulā' ixtapalh na ixlacatīn Dios ē jā ā'makapitzīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Xlaca'n tamāstā' tū cāquītāxtūni'nī'ttza'. Xla' masqui jā lhūhua' ixka'lhī, māstā'kō'lh tū ixlīhuā'yan. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ā'makapitzīn ixtalīchihuīna'mā'nalh chī ixlītzēhuanī't templo ē ixlītzēhuanī't chihuix ē ixlīpō'ktu tū chi'xcuhuī'n ixtalīmini'nī't Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Palaj tunca Jesús cāhuanilh: ―Namin a'ktin quilhtamacuj a'cxni' nūn a'ktin chihuix catilākēlhtahuī'lh. Ixlīpō'ktuca'n natapaclhkō' ē talhta'm nalacla. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Palaj tunca takelhasqui'nīlh: ―Mākelhtahua'kē'ni', ¿jā'cxni' na'a'kspula tzamā'? ¿Chī na'iclīca'tzīyāuj palh palaj na'a'kspula tū hua'nti? ");
INSERT INTO tkuNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús cāhuanilh: ―Catamaktaka'lhtit ē jā nacāta'a'kskāhuī'yān ixpālacata lhūhua' chi'xcuhuī'n natahuan taka'lhī quilīmāpa'ksīn. Chā'tunu' natahuan: “Quit Cristo tī Dios lacsacnī't.” Natahuampala: “Chuhua'j chilhtza' ixquilhtamacuj Cristo.” Jā tistālani'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nakexmatcan chī sā'nan jā lacatzuna'j lamā'lh guerra ē nacātamāca'tzīnīyān chī tatā'kaquī' tachi'xcuhuī't. Jā tijicua'nā'tit ixpālacata huā'mā' pūla na'a'kspula ē ā'līstān na'a'ksputa cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Cāhuanipālh: ―Chā'tin puxcu' ixtā'lāquiclhlaktzi' nahuan ā'chā'tin. Chā'tin māpa'ksīni' naskāhuī'cu'tun ā'chā'tin. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Palha' natachiqui ti'ya't ē calhāxcuhuālh na'a'nan tatzi'ncstat ē lhūhua' ta'jatat. Lījicua' tū natatasu'yu nac a'kapūn ē laka'tla'n lī'a'cnīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Pūla nacātachi'payān hui'xina'n ē nacātamakapātīnīnān. Nacātalē'nān nac templo natlahuacan justicia, ē nacātamānūyān nac pūlāchī'n ē nacātalē'nān ixlacatīnca'n reyes ē gobernadores ixpālacata quilā'a'ka'ī'ni'yāuj. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Chuntza' tzē naquilālīchihuīna'nāuj. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Calīhui'lī'tit jā nalī'a'ktuyunā'tit chī nalītamaktāyayā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Quit na'iccāmāsu'yuni'yān tachihuīn ē na'iccāmaxquī'yān talacapāstacni' ē chuntza' mintā'lāquiclhlaktzi'ca'n jā caticāskāhuī'n ē jā catitā'lāhua'nitit. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","’Hui'xina'n nacāmacamāstā'yān mintāta'ca'n ē mintzī'ca'n ē mintā'timīnca'n ē mintalakapasni'ca'n ē minamigoca'n. Ā'makapitzīn hui'xina'n nacātamaknīyān. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ixlīpō'ktuca'n tachi'xcuhuī't nacātaquiclhlaktzī'nān ē xmān quimpālacata. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Jā caticāyujni'n nūn kentin miya'jca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Calīhui'lī'tit natāyani'yā'tit ē a'cxni' na'a'kspulakō', naka'lhī'yā'tit milatamatca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’A'cxni' nalaktzī'nā'tit Jerusalén lītamacsti'li'nī't soldados, naca'tzīyā'tit palaj nalactlahuacan cā'lacchicni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Palaj tunca ixlacasqui'nca natatzā'la hasta nac sipej xlaca'n tī tahui'lāna'lh nac estado Judea. Tī tahui'lāna'lh nac Jerusalén ixlacasqui'nca natataxtuyācha'. Tī ta'a'nī't nac cā'tacuxtu jā catitataspi'tli nac cā'lacchicni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ē tzamā' quilhtamacuj ū'tza' napūpātīni'ncan. Namākentaxtūcan ixlīpō'ktu tū tatzo'kni' na ixtachihuīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","’Tzamā' quilhtamacuj koxa titala puscan tī taka'lhīni'n ē tī tamātzi'quī'ni'ncus ixpālacata lhūhua' tapātīn na'a'nan. Ixtasītzi' Dios nacāmakapātīnīn tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","’Makapitzīn natanī nac guerra ē ā'makapitzīn xatachī'n nacālē'ncan lacatin nac cā'lacchicni'. Tī xalanī'n makat natalactlahua ixlīka'tla' nac Jerusalén ē natamaknī xalanī'n a'ntza' hasta a'cxni' Dios nahuan jātza' catatlahualh. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jesús cāhuanipālh: ―Palaj tunca na'a'nan lī'a'cnīn nac cā'quilhtamacuj ē nac mālhcuyu' ē nac sta'cu. Xalanī'n huā'tzā' nac cā'quilhtamacuj natatamakchuyīkō' ē nūn catitaca'tzīlh tū natatlahua. Najicua'xnīncan chī namacasā'nan mar. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tachi'xcuhuī't natajicua'xnīkō' a'cxni' natalacapāstaca tū nacā'a'kspula huā'tzā' nac cā'quilhtamacuj. Hasta nac a'kapūn natachiqui. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","A'cxni' naquilaktzī'ncan quit Chi'xcu' xala' Tālhmā'n chī na'icpūmin nac poklhnu'. Na'icka'lhī lhūhua' lītli'hui'qui ē tzēhuanī't na'icxkaka. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","A'cxni' natzucu a'kspula huā'mā', calīpāxuhua'tit ē catalacayāhua'tit ixpālacata palaj na'a'kapūtaxtuyā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Nā cāhui'līni'lh huā'mā' tamāsu'yun: ―Calaktzī'ntit xaqui'hui' higo ē catūhuālh qui'hui'. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","A'cxni' tasu'yutza' a'kapu'mā'lh qui'hui' a'cxni' naca'tzīyā'tit talacatzuna'jīmā'lhtza' a'cxni' lhcācnan. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Chuntza' a'cxni' na'a'kspula ixlīpō'ktu huā'mā' tū iccāhuaniyān, naca'tzīyā'tit talacatzuna'jīmā'lhtza' a'cxni' Dios namāpa'ksīni'nkō'. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Ixlīcāna' tū iccāhuaniyān. Xlaca'n tī tahui'lāna'lhcus jā catitanīkō'lh hasta a'cxni' jāna'j cati'a'nalh ixlīpō'ktu huā'mā' tū iccāhuanin. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Masqui nasputa a'kapūn ē nasputa ti'ya't, jā maktin catisputli quintachihuīn; namākentaxtūkō'can. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Cuenta catlahua'tit ē jā camakxtektit palha' nala milīstacna'ca'n ixpālacata vicio ē taka'chīn ē nūn ixpālacata catūhuālh tū xala' nac cā'quilhtamacuj. Caskalalhtahui'la'tit; xamaktin namin huā'mā' quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Namin hua'chi a'ktin a'ktā'lh tū xamaktin yuja. Lacxtim chuntza' nacā'a'kspula ixlīpō'ktuca'n tachi'xcuhuī't xalanī'n nac cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Tacāxni'j catahui'la'tit ē pō'ktu quilhtamacuj nasqui'ni'yā'tit Dios ē chuntza' tzē nalītāyani'yā'tit ixlīpō'ktu tzamā' tū na'a'nan. Na'orarlī'yā'tit ē chuntza' tzē natāyayā'tit na quilacatīn quit Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Cā'cuhuīni' Jesús ixmāsu'yu nac templo ē cā'tzī'sni' ixa'n tahui'la nac sipej jā huanican Olivos. ");
INSERT INTO tkuNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tachi'xcuhuī't tzī'saj ixta'a'n nac templo natakexmata tū Jesús ixcāhuani. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Lacatzuna'jtza' ixmimā'lh ixcā'tani'ca'n israelitas tū huanican pascua a'cxni' hua'can pāntzīn tū jā ka'lhī levadura. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Xanapuxcu'nu' pālejni' ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn ixtaputzamā'nalh chī natalīmāmaknīnīni'n Jesús. Ixtajicua'n tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Palaj tunca skāhuī'ni' tanūni'lh Judas tī ixlī'a'ktu' ixtacuhuīni' Iscariote. Xla' chā'tin ixlīkelhacāujtu' scujnu'nī'n ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Xla' ū'tza' cālaka'lh xanapuxcu'nu' pālejni' ē xanapuxcu'nu' policía tī ixtamaktaka'lha templo. Ū'tza' cātā'chihuīna'nli chī nacālīmacamaxquī' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Xlaca'n tapāxuhuakō'lh ē tahuanilh natamaxquī' tumīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas cākelhtilh ē tzuculh putzani' chī tzē nalīmacamāstā' Jesús a'cxni' jā lhūhua' ixtahui'lāna'lh tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ixtzucumā'lhtza' cā'tani' a'cxni' ixua'can pāntzīn tū jā lītlahuacanī't levadura. Huā'mā' quilhtamacuj ixlacasqui'nca namaknīcan a'ktin xaska'ta' purecu' tū nalakahui'līcan Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesús cāmacā'lh Pedro ē Juan ē cāhuanilh: ―Capintit nacāxtlahua'ya'tit jā nahua'yāuj purecu'. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Xlaca'n takelhasqui'nīlh: ―¿Jāchu lacasqui'na' na'iccāxtlahuayāuj? ");
INSERT INTO tkuNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús cākelhtīlh: ―A'cxni' natanū'yā'tit nac cā'lacchicni', napāxtokā'tit chā'tin chi'xcu' tī lē'mā'lh ixtlāmam. Nastālani'yā'tit hasta jā natanūyācha' nac chic ");
INSERT INTO tkuNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ē nahuaniyā'tit ixtēcu' chic: “Mākelhtahua'kē'ni' huaniyān: ¿Jā huī'lh cuarto jā tzē na'iccātā'hua' quiscujnu'nī'n tū hua'can cā'tani' pascua?” ");
INSERT INTO tkuNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Palaj tunca nacāmāsu'yuni'yān a'ktin ka'tla' cuarto cāxyālhtza' ixlē'ktu' piso. A'ntza' nacāxtlahua'yā'tit quilīhua'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ta'a'lh ē chuntza' tamākentaxtūlh chī Jesús cāhuanilh, ē tacāxtlahualh līhua'. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","A'cxni' lacchā'lh hora, Jesús ē ixapóstoles tatahuī'lh tahuā'yan. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Palaj tunca Jesús cāhuanilh: ―Xa'iccātā'huā'yancu'tunān huā'mā' smalanka'n ixpālacata quit palaj na'icnī. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Chuhua'j ā'xmān na'iccātā'huā'yanān hasta a'cxni' namākentaxtūkō'can ixlīpō'ktu tū Dios māpa'ksīni'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Palaj tunca tayalh vaso tū ixlītzumā'lh xaxcān uva ē maxquī'lh tapāxcatca'tzīn Dios. Cāhuanilh ī'scujnu'nī'n: ―Camaktīni'ntit ē cahua'tit milīpō'ktuca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Quit jātza' ā'maktin ictihua'lh xaxcān uva hasta a'cxni' nalaktzī'nā'tit chī Dios māpa'ksīni'nkō'. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ixlītza'la tayalh pāntzīn ē maxquī'lh tapāxcatca'tzīn Dios ē māpitzilh. Cāmaxquī'lh xlaca'n ē cāhuanilh: ―Ū'tza' huā'mā' quimacni' tū macamāstā'mā'ca mimpālacataca'n. Chuntza' natlahua'yā'tit naquilālīlacapāstacāuj. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nā chuntza' tlahuapālh vaso a'cxni' tahuā'yankō'lh ē cāhuanilh: ―Xaxcān uva tū pūhuī'lh huā'mā' vaso, ū'tza' quinka'lhni'. Ū'tza' tū līcāxtlahuaca xasāsti' talacāxtlahuan ixpālacata chī Dios nacālīmakapūtaxtū tachi'xcuhuī't. Quinka'lhni' ū'tza' tū na'icmaka'n mimpālacataca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Chuhua'j chī huī'lh quimacan nac mesa, nā chuntza' huī'lh ixmacan chi'xcu' tī naquimacamāstā'. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Quit Chi'xcu' xala' Tālhmā'n ē naquina'kspula chuntza' chī tatzo'kni' quimpālacata na ixtachihuīn Dios. Līlakalhu'mānat chi'xcu' tī naquimacamāstā'; nalīpuhuan ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Palaj tunca tatzuculh talākelhasqui'nī chā'tunu' xlaca'n tī ixmacamāstā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Palaj tunca tatzuculh talālītā'chihuīna'n tīchu chī xlaca'n ā'chulā' ixlacasqui'nca. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesús cāhuanilh: ―Reyes tamāpa'ksī hua'chi ixtēcu'ca'n tachi'xcuhuī't ē tachi'xcuhuī't tahuan lactze reyes. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Jā chuntza' tila'yā'tit hui'xina'n. Tī ā'chulā' ixlacasqui'nca chī hui'xina'n xla' nala chuntza' chī xastancu. Tī namāpa'ksīni'ncu'tun ixlacasqui'nca nala chuntza' chī chā'tin tasācua'. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Tīchu puhua'na' ā'chulā' ixlacasqui'nca, tī huā'yamā'lh o tī mojōmā'lh pulātu? ¿Ē jā ixlīcāna' ā'chulā' ixlacasqui'nca tī huā'yamā'lh? Quit iclītaxtulh chuntza' chī tī mojōmā'lh mimpulātuca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Hui'xina'n pō'ktu quilhtamacuj quilātā'latlā'huanāuj masqui lhūhua' tū ixquina'kspula. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","QuinTāta' quimaxquī'lh quilīmāpa'ksīn, ē nā quit na'iccāmaxquī'yān milīmāpa'ksīnca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Chuntza' na'iccātā'huā'yanān jā na'icmāpa'ksīni'n. A'ntza' natahui'la'yā'tit ē nacāputzāna'nīyā'tit kelhacāujtu' tribus tī israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nā Māpa'ksīni' cāhuanilh: ―Cuenta catlahua'tit ixpālacata skāhuī'ni' cālīlaktzī'ncu'tunān palh tzē nacā'a'kskāhuī'yān. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Quit icsqui'ni'lh Dios mimpālacata, Simón. Icsqui'ni'lh jā catipātza'nkākō'j ixlīpō'ktu tū a'ka'ī'nī'ta'. Hui'x a'cxni' naquintalakspitni'palaya', cacāmaktāya' mintā'timīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simón Pedro huanilh: ―Mākelhtahua'kē'ni', iclīhui'lī na'ictā'a'nān hasta nac pūlāchī'n ē na'ictā'nīyān. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús huanilh: ―Pedro, icuaniyān huā'mā' quilhtamacuj, a'cxni' jāna'j ta'sa puyux, maktu'tun naquinquilhtatzē'ka ē nahua'na' jā quilakapasa'. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Palaj tunca Jesús cākelhasqui'nīlh: ―A'cxni' iccāmacā'n ē jā lī'pintit mimpūtumīnca'n nūn mimurralhca'n nūn mincaclhi'ca'n, ¿ē cāsputni'n tū ixmaclacasqui'nā'tit? Xlaca'n tahuanli: ―Jā tū. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Palaj tunca cāhuanilh: ―Chuhua'j xtum iccāhuaniyān. Tī ka'lhī ixmurralh, calē'lh ē calē'lh ixpūtumīn. Palh jā ka'lhī ixmachīta, castā'lh ixchamarra nalītamāhua. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ū'tza' iccāhuaniyān ixpālacata quit na'icmākentaxtū ixlīpō'ktu tū tatzo'kni' quimpālacata. Chuntza' tatzo'kni': Laktzī'ncan hua'chi chā'tin tī jā tze. Chuhua'j ixlīpō'ktu tū tatzo'kni' quimpālacata, ixlacasqui'nca nakentaxtu. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Palaj tunca ī'scujnu'nī'n tahuanli: ―Mākelhtahua'kē'ni', ā' huī'lh kentu' machīta. Jesús kelhtīni'lh: ―Tzetza'. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Palaj tunca Jesús taxtulh nac cuarto ē chī ixlīsmanīnī'ttza', a'lh nac sipej jā huanican Olivos. Tastālani'lh ī'scujnu'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","A'cxni' tachā'lh, cāhuanilh: ―Na'orarlīyā'tit jā nacāta'a'kskāhuī'yān a'cxni' nacātalīlaktzī'ncu'tunān. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Palaj tunca Jesús a'lh lacapunchuna'j ē tatzokostalh na'orarlī. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Huanli: ―QuinTāta' Dios, palh hui'x lacasqui'na', caquimā'a'kapūtaxtu huā'mā' tapātīn. Masqui na'icpātīni'n, calalh tū hui'x lacasqui'na' ē jā calalh tū quit iclacasqui'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Palaj tunca tasu'yuni'lh chā'tin ángel xala' nac a'kapūn. Tā'chihuīna'nli Jesús namaxquī' tatli'hui'clhtat. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Lhūhua' ixpātīni'mā'lh, ē Jesús ā'chulā' squi'ni'lh Dios. Ī'skakana'mā'lh ixpālacata lhūhua' ixpātīni'mā'lh. Tasu'yulh hua'chi ī'sta'jmā'lh ixka'lhni' chī skakana'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","A'cxni' orarlīkō'lh, tāyalh ē taspi'tli jā ixcāmakxteknī't ī'scujnu'nī'n. Ixtalhtatamā'nalh cāmaclalh ixpālacata ixcāskāhuī'mā'lh talhtata ē ixtalīpuhuamā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Palaj tunca cāhuanilh: ―¿Tū ixpālacata lhtatapā'na'ntit? Catā'kaquī'tit ē casqui'ni'tit Dios jā nacātaskāhuī'yān a'cxni' nacātalīlaktzī'ncu'tunān. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ixcātā'chihuīna'mā'lhcus Jesús a'cxni' tachā'lh lhūhua' tachi'xcuhuī't. Chā'tin ixlīkelhacāujtu' scujnu'nī'n tī ixuanican Judas, ū'tza' ixcāpūlani'tēlha. Laktalacatzuna'jīlh Jesús ē mu'sulh. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Palaj tunca Jesús huanilh: ―Judas, hui'x quilacamu'su'ya' ē chuntza' quilīmacamāstā'ya' quit, Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","A'cxni' talaktzī'lh tū ixa'kspulamā'lh Jesús, tī ixtatā'hui'lāna'lh takelhasqui'nīlh: ―¿Ē na'icmāxtuyāuj machīta na'iccālīhui'līni'yāuj? ");
INSERT INTO tkuNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Chā'tin ī'scujni' mātakāhuī'lh ixtasācua' xapuxcu' pālej ē a'kacā'yujulh ixa'ka'xko'lh na ixa'kapekcāna'j. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesús huanilh: ―Camakxtektit; jātza' catlahua'tit. Palaj tunca Jesús xa'malh ixa'ka'xko'lh tasācua' ē tzej cāxlapālh. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Palaj tunca cāhuanilh xanapuxcu'nu' pālejni' ē xanapuxcu'nu' policía tī ixtamaktaka'lha templo ē xanapuxcu'nu' israelitas, ixlīpō'ktuca'n tī ixtaminī't tachi'pa, cāhuanilh: ―¿Tū ixpālacata līta'nā'tit mimachītaca'n ē minqui'hui'ca'n? Hua'chi chi'pacu'tunā'tit chā'tin ka'lhāna'. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","A'cxni' xa'iccātā'latlā'huanān lakalī lakalī nac templo, ¿tū ixpālacata jā quilāchi'pauj a'cxni'? Ā'cus milh minquilhtamacujca'n ē namāpa'ksīni'n tī jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Palaj tunca chi'paca Jesús ē lē'nca na ixchic xapuxcu' pālej. Pedro lacapunchuna'j ī'stālani'tēlha. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","A'ntza' tahui'līlh macscut nac tanquilhtīn ē tatzuculh tasko'n. Nā Pedro tahuī'lh pu'nan. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","A'cxni' laktzī'lh chā'tin tzu'ma'jāt jā ī'sko'huī'lh, lakalaktzī'hui'līlh ē huanli: ―Nā huā'mā' chi'xcu' ū'tza' ixtā'latlā'huan Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedro kelhtatzē'kli ē huanli: ―Puscāt, jā iclakapasa. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ā'līstān ā'chā'tin laktzī'mpālh ē nā huanilh: ―Nā hui'x ixcātā'lātlā'hua'na' xlaca'n. Pedro huanilh: ―Chi'xcu', jā quit. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ixlī'a'ktin hora ā'chā'tin lacatancs huanilh: ―Ixlīcāna' huā'mā' chi'xcu' ixtā'latlā'huan ē xala' nac Galilea. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Palaj tunca Pedro huanilh: ―Chi'xcu', jā icca'tzī tū hua'na'. Huā'mā' puntzuna' a'cxni' ixchihuīna'mā'lhcus Pedro, palaj tunca puyux ta'salh. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Māpa'ksīni' Jesús talakspi'tli ē laktzī'lh Pedro, ē Pedro lacapāstacli chī ixuaninī't Māpa'ksīni': “A'cxni' jā ā'ta'sa puyux, maktu'tun naquinkelhtatzē'ka ē nahua'na' jā quilakapasa'.” ");
INSERT INTO tkuNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Palaj tunca Pedro taxtulh ē ixtalīpuhuāt līcalhuanli. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Chi'xcuhuī'n tī ixtamaktaka'lhmā'nalh Jesús talakapalalh ē tatucsli. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Talakachī'lh ē talacala'sli ē tahuanilh: ―¡Calakapasti tīchu lacala'sni'! ");
INSERT INTO tkuNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Lhūhua' ixtahuani catūhuālh ixpālacata ixtamāmāxanī'cu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","A'cxni' xkakalh, tatakēstokli xanapuxcu'nu' israelitas ē xanapuxcu'nu' pālejni' ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn, ē talē'lh Jesús na ixlacatīnca'n māpa'ksīni'nī'n tī ā'chulā' ixtamāpa'ksīni'n. A'ntza' kelhasqui'nīca: ");
INSERT INTO tkuNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Caquilāhuaniuj: ¿Ē hui'x Cristo tī Dios hui'līnī't ixlīmakapūtaxtūnu'? Xla' cākelhtīlh: ―Masqui xa'iccāhuanin palh ixlīcāna', jā ixquintilā'a'ka'ī'uj. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Palh quit na'iccākelhasqui'nīyān catūhuālh, jā quintilākelhtīuj nūn quintilāmakxtekui. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Quit Chi'xcu' xala' Tālhmā'n ē chuhua'j quit na'ictahui'la na ixpekxtūcāna'j Dios tī ā'chulā' tunca māpa'ksīni'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Palaj tunca ixlīpō'ktuca'n takelhasqui'nīlh: ―¿Ē hui'x ī'Ska'ta' Dios? Jesús cākelhtīlh: ―Ixlīcāna'. Chuntza' chī huanā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Palaj tunca talāhuanilh: ―Jātza' maclacasqui'nāuj ā'chā'tin naquincāhuanipalayān jā tze xla'. Quina'n kexmatnī'tauj tū līhuanli ixquilhni'. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Xlītza'la ixlīpō'ktuca'n tatāyakō'lh ē talē'lh Jesús na ixlacatīn Pilato tī gobernador ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","A'ntza' tatzuculh talīmālacsu'yu ē tahuanli: ―Iclaktzī'nī'tauj chī huā'mā' chi'xcu' cāmāmakchuyī tachi'xcuhuī't. Huanli jā ixlacasqui'nca naxokoyāuj ixlīxokot emperador, ē nā huanli ū'tza' Cristo tī Dios hui'līni't ixlīmakapūtaxtūnu', ē huā'mā' tachihuīn huanicu'tun xla' xapuxcu'. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Palaj tunca Pilato kelhasqui'nīlh: ―¿Ē hui'x ixpuxcu'ca'n israelitas? Jesús kelhtīlh: ―Chuntza' chī huanī'ta'. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Palaj tunca Pilato cāhuanilh xanapuxcu'nu' pālejni' ē tachi'xcuhuī't: ―Jā tū icmaclanī't tū ixpālacata. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Xlaca'n palha' tahuanli: ―Cāmāmakchuyīmā'lh ixlīpō'ktuca'n xalanī'n nac Judea chī māsu'yumā'lh. Tzuculh māsu'yu nac Galilea ē ixmāsu'yutēlha hasta chilh huā'tzā'. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","A'cxni' Pilato kexmatli huā'mā', kelhasqui'nīni'lh palh xala' nac Galilea Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","A'cxni' huanica ixlīcāna' xala' nac Galilea, macā'ni'ca Herodes tī gobernador xala' nac Galilea ixuanī't. Nā xla' ixminī't nac Jerusalén tzamā' quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","A'cxni' Herodes laktzī'lh Jesús, līpāxuhualh ixpālacata makāstza' ixlaktzī'ncu'tun. Ixkexmatnī't chī ixlīchihuīna'ncan ē puhuanli nalaktzī'n a'ktin lī'a'cnīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Lhūhua' catūhuālh kelhasqui'nīlh Jesús ē xla' jā tū kelhtīlh. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nā a'ntza' ixtahui'lāna'nkō'lh xanapuxcu'nu' pālejni' ē xamākelhtahua'kē'ni'nī'n līmāpa'ksīn ē xlaca'n palha' ixtalīmālacsu'yumā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes ē ī'soldados talakmaka'lh Jesús ē tamālhekē'lh tzēhuanī't lu'xu' hua'chi ixla' rey natalīlītzī'n. Ā'līstān Herodes macā'ni'pālh Pilato. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Chuntza' huā'mā' quilhtamacuj Pilato ixamigo tlahualh Herodes. Xapūla ixtā'lāquiclhlaktzi' ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato cāmākēstokpālh xanapuxcu'nu' pālejni' ē māpa'ksīni'nī'n ē tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Cāhuanilh: ―Hui'xina'n quilālīmini'uj huā'mā' chi'xcu' ē quilāhuaniuj cāmāmakchuyī tachi'xcuhuī't. Quit ickelhasqui'nīnī'ttza' na milacatīnca'n ē ca'tzīyā'tittza' jā tū icmaclani'lh tū līmālacsu'yuyā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nā chuntza' Herodes jā tū maclani'lh. Ū'tza' līmacamimpalacha'. Laktzī'nā'tittza' chī jā tū tlahuanī't nachī'can ē nanī. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Na'iclīmāmaksno'knīni'n ko'xka' ē ā'līstān na'icmakxteka. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ixa'nan tahui'lat ē ū'tza' Pilato ixlīmakxteka chā'tin tachī'n a'cxni' ixlamā'lh cā'tani'. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ixlīpō'ktuca'n tatzuculh tata'sa ē tahuanli: ―¡Camāmaknīnī'ni' huā'mā' ē camakxtekti Barrabás! ");
INSERT INTO tkuNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás ixlīchī'canī't ixpālacata xla' ē ixchi'xcuhuī'n tatā'kaquī'lh ixpālacata tatā'lāquiclhlaktzī'n māpa'ksīni'nī'n romanos ē hasta tamaknīni'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato ixmakxtekcu'tun Jesús ē cātā'chihuīna'mpālh. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ā'chulā' tata'salh ē tahuanli: ―¡Caxtokohua'ca'ca! ¡Caxtokohua'ca'ca! ");
INSERT INTO tkuNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ixlīmaktu'tun Pilato cāhuanilh: ―¿Tū ixpālacata? ¿Tūchu tlahuanī't? Quit jā tū icmaclanī't tū ixpālacata nalīmaknīcan. Xmān na'iclīmāmaksno'knīni'n ko'xka' ē ā'līstān na'icmakxteka. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Xlaca'n ā'chulā' palha' tahuanli caxtokohua'ca'ca. Palha' tahuanli xlaca'n ē xanapuxcu'nu' pālejni', ē chuntza' talīskāhuī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Chuntza' Pilato tlahualh tū ixtalacasqui'n xlaca'n, ");
INSERT INTO tkuNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ē makxtekli chi'xcu' tī ixtalacsacnī't. Ū'tza' Barrabás tī ixmānūcanī't ixpālacata tā'kaquī'lh ē maknīni'lh. Macamāstā'lh Pilato Jesús natatlahuani' tū ixtalacasqui'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","A'cxni' ixtalē'mā'nalh Jesús nataxtokohua'ca', tachi'palh chā'tin chi'xcu' tī ixuanican Simón ē xala' nac Cirene. Xla' ixtanūtēlha nac cā'lacchicni' Jerusalén ē sāmācu'quī'ca cruz ē māstālīca Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Lhūhua' tachi'xcuhuī't ixtastālani'tēlha, nā lhūhua' puscan tī ixtacalhuantēlha ē talīpuhuanli ixpālacata Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesús cālakalaktzī'lh ē cāhuanilh: ―Puscan xalanī'n nac Jerusalén, jā cacalhua'ntit quimpālacata. Xatze nacalhua'nā'tit tū mimpālacataca'n ē ixpālacataca'n mincamana'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Namin a'ktin quilhtamacuj a'cxni' nahuancan: “Līpāxuhua tī jāla ka'lhī ī'ska'ta'. Līpāxuhua tī jā maktin lacatuncuhuī'lh ī'ska'ta' ē jā maktin mātzi'quī'nilh.” ");
INSERT INTO tkuNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","A'cxni' tachi'xcuhuī't natahuani sipej: “Caquilā'a'kta'pū'j”; ē natahuani ixmacni' sipej: “Caquilāmātzē'kui.” ");
INSERT INTO tkuNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Palh chuntza' tlahuani'can xastaka qui'hui', ā'chulā' natlahuani'can xascahuahua. Palh chuntza' quintlahuani'can ē quit jā tū ictlahuanī't tū jā tze, ā'chulā' nacātlahuani'can tī tatlahualh tū jā tze ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nā ixcālē'mā'ca chā'tu' maknīni'nī'n nacātā'maknīcan Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","A'cxni' tachā'lh jā huanican La Calavera (ū'tza' huanicu'tun Ixa'kxāk Nīn), a'ntza' xtokohua'ca'ca Jesús ē nā chuntza' chā'tu' maknīni'nī'n ē chā'tin na ixpekxtūcāna'j ē chā'tin na ixpekxtūxuqui. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","A'cxni' ixtaxtokohua'ca'mā'nalh, Jesús huanli: ―QuinTāta', cacāmātza'nkēna'ni' ixpālacata jā taca'tzī tū tatlahuamā'nalh. Soldados talītlahualh suerte ixlu'xu' Jesús natatapitzi chā'tunu' xlaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tachi'xcuhuī't ixtayāna'lh ē ixtalaktzī'mā'nalh ē hasta māpa'ksīni'nī'n talīlītzī'nli ē tahuanli: ―Ā'makapitzīn cāmakapūtaxtūlh. Chuhua'j ca'a'kapūtaxtulh ixlīmān palh ixlīcāna' Dios lacsacnī't ē hui'līlh ixlīmakapūtaxtūnu'. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nā soldados ixtalīlītzī'mā'nalh. Talaktalacatzuna'jīlh ē tamāhuī'lh xaxcān vinagre. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Tahuanilh: ―Palh hui'x ixpuxcu'ca'n israelitas, ca'a'kapūtaxtu milīmān. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ixua'ca'lh a'ktin letrero ixa'cpūn ē ixtatzo'kni' nac griego ē latino ē hebreo. Letrero ixuan: Ū'tza' huā'mā' ixPuxcu'ca'n israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Chā'tin maknīni' tī ixtā'hua'ca'lh līlītzī'nli ē huanilh: ―Palh ixlīcāna' hui'x tī Dios hui'līlh ixlīmakapūtaxtūnu', ca'a'kapūtaxtu milīmān ē nā caquilāmakapūtaxtūj quina'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ā'chā'tin quilhnīlh ixtā'maknīni' ē huanilh: ―¿Ē jā jicua'ni'ya' Dios? Nā hui'x lacxtim pātīni'mpā't. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Quina'n quincāminī'ni'yān pātīni'mā'nauj ixpālacata xokomā'nauj tū laclē'nāuj. Huā'mā' chi'xcu' jā tū laclē'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Palaj tunca huanilh Jesús: ―Naquilacapāstaca a'cxni' namāpa'ksīni'na'. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús kelhtīlh: ―Ixlīcāna' icuaniyān. Chuhua'j, huā'mā' quilhtamacuj naquintā'tahui'la'yā'chi nac a'kapūn. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Hua'chi tastu'nūttza' ixuanī't a'cxni' cā'pucsua' lakō'lh calhāxcuhuālh nac cā'ti'ya'tna'. Chuntza' lalh hasta hua'chi maktu'tun kōtanū. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Chi'chini' jā māxkakēni'lh. Līlakamilīn nac templo ixlīmān taxtī'tli ē tapūpitzilh. Ū'tza' huā'mā' līlakamilīn tū ixmāpitzi templo. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Palaj tunca Jesús palha' ta'salh ē huanli: ―QuinTāta', icmacamaxquī'yān quilīstacna'. A'cxni' huankō'lh, nīlh. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","A'cxni' capitán romano laktzī'lh tū a'kspulalh, laktaquilhpūtalh Dios ē huanli: ―Ixlīcāna' huā'mā' chi'xcu' tzeya chi'xcu' ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ixlīpō'ktuca'n tachi'xcuhuī't tī tamilh ē talaktzī'lh tū a'kspulalh, tatapānūlh ā'tzā' ē cācu'xatucstēlhacan ixpālacata ixtalīpuhuātca'n. Ta'a'lh na ixchicca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ixtalakapasnī'n Jesús ē nā puscan tī ixtastālani'nī't nac estado Galilea makat tatāyalh ē ixtalaktzī'mā'nalh huā'mā'. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ixuī'lh chā'tin chi'xcu' ixtacuhuīni' José ē ū'tza' xala' nac Arimatea nac estado Judea. Ixcātā'tapa'ksī māpa'ksīni'nī'n tī ā'chulā' ixtamāpa'ksīni'n israelitas. Tzeya chi'xcu' ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ixka'lhīmā'lh hasta a'cxni' Dios namāpa'ksīni'nkō'. Jā lakatīlh tū ixtatlahuanī't māpa'ksīni'nī'n ixpālacata Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nā huā'mā' chi'xcu' laka'lh Pilato ē squi'ni'lh ixmacni' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","A'cxni' ixmāyujūnī'ttza' nac cruz, līmaksui'tli a'ktin lu'xu' ē mānūlh a'ktin nac lhu'cu' tū ixcāxtlahuacanī'ttza' nac ka'tla' chihuix. A'ntza' jāna'j tī chā'tin ixmā'cnūcanī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tzamā' quilhtamacuj ū'tza' tū ixpūcāxtlahuakō'can ixpālacata ixlīlakalī quilhtamacuj tū pūjaxcan ē ixtzucumā'lhtza'. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Puscan tī ixtatā'minī't Jesús nac estado Galilea ta'a'lh talaktzī'n lhu'cu' ē cuenta tatlahualh jā ixmāpī'canī't ixmacni' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tataspi'tli na ixchicca'n ē tacāxtlahualh perfume ē pomada ixla' tī nīnī't. Tapūjaxli quilhtamacuj tū pūjaxcan chuntza' chī māpa'ksīlh Moisés. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tzī'saj domingo tzamā' puscan ta'a'mpālh nac pūtā'cnūn ē ixtalē'mā'nalh perfume tū ixtacāxtlahuanī'ttza'. Ā'makapitzīn puscan tatā'a'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","A'cxni' tachā'lh, talaktzī'lh ixmāpānūcanī'ttza' chihuix tū ixlīmālacchahuacanī't pūtā'cnūn. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tatanūlh ē jā tamaclalh ixmacni' Māpa'ksīni' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tajicua'nli ē jā ixtaca'tzī tū natatlahua ē a'cxni' talaktzī'lh chā'tu' ángeles tī ixtatasu'yu hua'chi chi'xcuhuī'n. Snapapa ixlu'xu'ca'n ixtahuanī't ē ixtayāna'lh ixlacatzuna'jca'n puscan. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Xlaca'n tajicua'nli, ē tataquilhpūtalh ē ángeles cāhuanilh: ―¿Tū ixpālacata putzayā'tit na ixpu'nanca'n nīnī'n chā'tin tī lakahuanlitza'? ");
INSERT INTO tkuNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Huā'tzā' jātza' tihuī'lh. Xla' lacastālancuana'nī'ttza'. Calacapāstactit chī cāhuanin a'cxni' ixuī'lhcus nac Galilea. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Huanli chī ixlacasqui'nca Chi'xcu' xala' Tālhmā'n nacāmacamaxquī'can tī jā tzeya chi'xcuhuī'n ē nataxtokohua'ca' ē ixlī'a'ktu'tun quilhtamacuj nalacastālancuana'mpala. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Palaj tunca puscan talacapāstacli ixtachihuīn Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","A'cxni' tataspi'tli nac pūtā'cnūn, tahuanikō'lh kelhacāujtin apóstoles ē ixlīpō'ktuca'n ā'makapitzīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Puscan, xlaca'n cāhuanican María Magdalena ē Juana ē María tī ixtzī' Jacobo ē ā'makapitzīn puscan huampala. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Apóstoles takexmatli hua'chi takelhkamān tū ixcāhuanimā'ca ē jā ta'a'ka'ī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Masqui jā ta'a'ka'ī'lh, Pedro taxtulh ē tu'jnulh nac pūtā'cnūn. Taquilhpūtalh ē talacanūlh ē laktzī'lh xmān lu'xu' jā ixmā'lh. A'lh na ixchic ē ixlī'a'cnīmā'lh ē ixlacapāstacmā'lh tū a'kspulanī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ū'tza' huā'mā' quilhtamacuj chā'tu' tī ixtastālani'nī't Jesús, ixta'a'mā'nalh a'ktin nac cā'lacchicni' jā huanican Emaús. Ū'tza' hua'chi a'kcāujtin kilómetros ixlīmakat Jerusalén. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ixtalītā'chihuīna'ntēlha ixlīpō'ktu tū ixa'kspulanī't. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Līhuan ixtalītā'chihuīna'mā'nalh ē ixtalālīhuani'mā'nalh, Jesús cālaktalacatzuna'jīlh ē tzuculh cātā'tlā'huan. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Masqui talaktzī'lh, jāla talakapasli ixpālacata catūhuālh talītamakchuyīlh. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Palaj tunca Jesús cākelhasqui'nīlh: ―¿Tū līchihuīna'ntēlhayā'tit? ¿Tūchu līlīpuhua'nā'tit? ");
INSERT INTO tkuNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Chā'tin tī huanican Cleofas kelhtīni'lh: ―Ixlīpō'ktu tachi'xcuhuī't taca'tzīkō' tū a'kspulalh nac Jerusalén tzamā' quilhtamacuj. ¿Hui'x tī ixui'la'chi a'ntza' ē jā ca'tzīya'? ");
INSERT INTO tkuNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Palaj tunca Jesús cāhuanilh: ―¿Tū lalh? Tahuanilh: ―Lhūhua' tū a'kspulalh ixpālacata Jesús xala' nac Nazaret tī a'kchihuīna' ē ixka'lhī lītli'hui'qui na ixlacatīn Dios ē na ixpu'na'i'tātca'n tachi'xcuhuī't. Ū'tza' lītasu'yulh tū tlahualh ē tū huanli. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Xanapuxcu'nu' pālejni' ē māpa'ksīni'nī'n tamacamāstā'lh namaknīcan ē naxtokohua'ca'can nac cruz. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","’Quina'n xa'icka'lhīmā'nauj ū'tza' xla' tī nacāmakapūtaxtū israelitas. Ixlīlakatu'tuntza' quilhtamacuj chuhua'j a'cxni' a'kspulalh. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ā'makapitzīn puscan na quilacpu'na'i'tātca'n quincātalīmekē'klhanī'tan. Tzī'saj taquīlalh nac pūtā'cnūn, ");
INSERT INTO tkuNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ē jā talaktzī'lh ixmacni' Jesús ē tataspi'tli. Quincātahuanin talīlakachuyalh ángeles tī cāhuanilh lakahuan Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Palaj tunca ā'makapitzīn quincompañerosnu'ca'n taquīlalh nac pūtā'cnūn ē chuntza' chī tahuanilh puscan, chuntza' tamaclalh. Jā talaktzī'lh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Palaj tunca Jesús cāhuanilh: ―Jā lacaca'tzīyā'tit. ¿Jā'cxni' na'a'ka'ī'yā'tit ixlīpō'ktu tū tahuanli a'kchihuīna'nī'n? ");
INSERT INTO tkuNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Cristo tī Dios hui'līnī't ixlīmakapūtaxtūnu', ¿ē jā ixlacasqui'nca pūla napātīni'n chuntza' ē ā'līstān natanū jā xkaka? ");
INSERT INTO tkuNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Palaj tunca Jesús tzuculh cāmāsu'yuni'kō' ixlīpō'ktu tū tzo'kcanī't na ixtachihuīn Dios ē tū līchihuīna'n xla'. Tzuculh tū tzo'knunī't Moisés ē cāmāsu'yuni'lh tū ixtatzo'knunī't ixlīpō'ktuca'n profetas. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","A'cxni' tachā'lh nac cā'lacchicni' jā ixta'a'mā'nalh, tasu'yulh hua'chi Jesús ixa'mā'lh ā'chulā' pekanācha'. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Xlaca'n cuesa tahuanilh natachoko ē tahuanilh: ―Xatze catachoko. Licua' tzī'suamā'lhtza'. Cā'pucsua'tza'. Palaj tunca Jesús cātā'tanūlh nac chic. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","A'cxni' tatahuī'lh tahuā'yan, xla' tayalh pāntzīn ē māstā'lh tapāxcatca'tzīn ē māpitzilh ē cāmaxquī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Palaj tunca huā'mā' tza'la hua'chi tzej talacahuāna'nli ē talakapasli ē xla' cālaksputni'lh. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Xlaca'n talāhuanilh: ―¿Ē chā jā ixlīcāna' quina'n līpāxuhuauj a'cxni' ixquincāmāsu'yuni'tēlhayān ixtachihuīn Dios? ");
INSERT INTO tkuNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Xamaktin tachi'papālh ixtejca'n. Jā tatamakapalīlh nūn macsti'na'j. Tataspi'tpālh nac Jerusalén ē cātā'lāpāxtokli kelhacāujtin apóstoles jā ixtatakēstoknī't ē ā'makapitzīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Cāhuanica huā'mā' chā'tu': ―Ixlīcāna' lacastālancuana'nli Māpa'ksīni'. Tasu'yuni'lh Simón. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Palaj tunca xlaca'n cāhuanilh chī cā'a'kspulalh nac tej ē chī talakapasli Jesús a'cxni' māpitzilh pāntzīn. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","A'cxni' ixtalīchihuīna'mā'nalhcus tzamā', a'cxni' Jesús tāyalh na ixpu'na'i'tātca'n. Cāhuanilh: ―Tzej calatapā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Cāmekē'klhaca ē tajicua'nli ē ixtapuhuan ixtalaktzī'mā'nalh espíritu. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesús cāhuanilh: ―¿Tū ixpālacata jicua'nā'tit? ¿Tū ixpālacata xtum puhua'nā'tit mina'cstuca'n? ");
INSERT INTO tkuNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Calaktzī'ntit quimacanī'n ē quintujanī'n. Naquilālakapasāuj. Caquilāxa'mauj ē caquilālaktzī'uj. Espíritu jā ka'lhī quinīt ē lucut chuntza' chī quit. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","A'cxni' chuntza' cāhuanilh, cāmāsu'yuni'lh ixmacanī'n ē ixtujanī'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Masqui līpāxuhua talaktzī'lh, jāla ta'a'ka'ī'lh. Jesús cākelhasqui'nīlh: ―¿Ē huī'lh līhua't? ");
INSERT INTO tkuNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Palaj tunca maxquī'ca pītzuna'j xatatzi'li' squī'ti' ē pītzuna'j xatachu'cu cera tū ka'lhī xaxcān. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Xla' maktīni'lh ē hua'kō'lh na ixlacatīnca'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ā'līstān cāhuanilh: ―Tū quina'kspulalh ū'tza' tū iccāhuanin a'cxni' xa'iccātā'latlā'huanān. Ixlacasqui'nca na'icmākentaxtū ixlīpō'ktu tū tatzo'kni' na ixtachihuīn Dios quimpālacata, jā tzo'knulh Moisés ē profetas ē jā huanican Salmos. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Palaj tunca cāmāsca'tīlh ixtachihuīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Cāhuanilh: ―Chuntza' tatzo'kni'. Ixlacasqui'nca nanī Cristo tī Dios hui'līnī't ixlīmakapūtaxtūnu'. Ixlacasqui'nca ixlī'a'ktu'tun quilhtamacuj nalacastālancuana'n jā tahui'lāna'ncha' nīnī'n. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ixlacasqui'nca nacāmāsu'yuni'kō'can ixlīpō'ktuca'n tachi'xcuhuī't xalanī'n nac cā'quilhtamacuj ixpālacata Cristo. Natzucucan nac Jerusalén ē nacāhuanikō'can ixlacasqui'nca natalakpalī ixtalacapāstacni'ca'n ē nacāmātza'nkēna'ni'can. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Hui'xina'n nacāmāsu'yuni'yā'tit tzamā' catūhuālh ixpālacata laktzī'nkō'tit. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Chuhua'j calaktzī'ntit. Na'iccāmacamini'yān tū huanli quinTāta'. Natachokoyā'tit huā'tzā' nac Jerusalén hasta a'cxni' namaktīni'nā'tit lītli'hui'qui tū xala' nac a'kapūn. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Palaj tunca Jesús cālē'lh ī'scujnu'nī'n nac tej hasta nac Betania ē makayāhualh ixmacanī'n ē cāsicua'lanātlahualh. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Līhuan ixcāsicua'lanātlahuamā'lh, tzuculh tā'kayāhua na ixlacatīnca'n ē lē'nca nac a'kapūn. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Xlaca'n talaktaquilhpūtalh ē ā'līstān līpāxuhua tataspi'tli nac Jerusalén. ");
INSERT INTO tkuNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Pō'ktu quilhtamacuj ixtahui'lāna'lh xaka'tla' nac templo natamāka'tlī Dios. Amén.");
INSERT INTO tkuNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","A'cxni' jāna'j ixcāxui'līcan cā'quilhtamacuj, ixuī'lhtza' chā'tin tī tzamā' Tachihuīn. Chuntza' huanican ixpālacata ū'tza' quincāmāsu'yuni'yān Dios. Xla' ixtā'huī'lacha' Dios. Xla' ū'tza' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Xapūla ixtā'huī'lh Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tzamā' Tachihuīn cāxui'līlh ixlīpō'ktu tū a'nan; jā tū ixa'nalh palh jā cahuālh ū'tza'. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ū'tza' māstā' latamat ē chuntza' lītaxtulh a'ktin taxkaket ixpālacataca'n tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ū'tza' chī a'ktin taxkaket tū māxkakēni'n a'ntza' jā nac cā'pucsua'. Skāhuī'ni' xala' nac cā'pucsua' ē jāla skāhuī' taxkaket. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ixuī'lh chā'tin chi'xcu' tī ixuanican Juan, tī Dios macamilh. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Xla' milh nalīchihuīna'n tī huanican taxkaket ē milh nacālīmaxquī' talacapāstacni' tachi'xcuhuī't nata'a'ka'ī'ni' tī huanican taxkaket. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan jā ū'tza' taxkaket. Xla' xmān quīmāsu'yuchi huā'mā' tī ixlīcāna' taxkaket. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tī ixlīcāna' taxkaket ixmimā'lhcus nac cā'quilhtamacuj. Xla' cāmāxkakēni'kō' ixlīpō'ktuca'n tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Xla' milh nac cā'quilhtamacuj. Masqui ū'tza' cāxui'līlh cā'quilhtamacuj, tachi'xcuhuī't jā talakapasli. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tī ixla' ticālakmilh ē jā tamaktīni'nli. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Makapitzīn ta'a'ka'ī'lh. Ixlīpō'ktuca'n tī ta'a'ka'ī'lh, xla' cāmaxquī'lh lītli'hui'qui natalītaxtu ixlacstīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Chī talīlacatuncuhuī' ixlacstīn Dios, jā chī talīlacatuncuhuī' ixcamana'ca'n tachi'xcuhuī't. Ixlacstīn Dios jā chī a'ktin ska'ta' tī lacatuncuhuī'lh ixpālacata ixtapāxuānca'n ē ixtalacapāstacni'ca'n tachi'xcuhuī't. Dios ū'tza' tī cāmaxquī ixlatamatca'n ixlacstīn. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Tī huanican Tachihuīn, xla' quītachi'xcuhuī'lichi nac cā'quilhtamacuj. Xla' ixquincātā'hui'lan. Iclaktzī'uj chī ka'lhī lītli'hui'qui. Huā'mā' lītli'hui'qui ū'tza' ixla' tī ixlīmān ī'Ska'ta' Dios. Xla' lakalhu'manīni'n ē pō'ktu tū huanli ū'tza' ixlīcāna'. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan līchihuīna'nli ē huanli: ―Ū'tza' huā'mā' tī iclīchihuīna'nli a'cxni' icuanli tī icpūlani'nī't, ū'tza' ā'chulā' xaka'tla' ē jā quit. Xla' ixuī'lhtza' a'cxni' quit iclacatuncuhuī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Quincātlahuani'nī'ta'n lhūhua' talakalhu'mān, ixpālacata xla' lakalhu'manīni'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisés quincāmāsu'yuni'n ixlīmāpa'ksīn Dios. Jesucristo quincāmāca'tzīnīyān tū ixlīcāna' ē chī quincālakalhu'manān Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Jā tī laktzī'nī't Dios nūn maktin. Tī ixlīmān ī'Ska'ta' tī Dios pāxquī', ū'tza' quincāmāsu'yuni'nī'ta'n Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Israelitas xalanī'n nac Jerusalén talakmacamilh Juan makapitzīn pālejni' ē levitas. Xlaca'n takelhasqui'nīlh Juan tīchu xla'. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juan cālīmāsu'yulh ē cāhuanilh: ―Jā quit Cristo. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Takelhasqui'nīpālh: ―¿Tīchu hui'x? ¿Ē hui'x ixa'kchihuīna' Dios tī huanican Elías? Juan huanli: ―Jā quit. Takelhasqui'nīpālh: ―¿Ē hui'x ixa'kchihuīna' Dios tī icka'lhīmā'nauj? Xla' kelhtīni'lh: ―Jā quit. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Takelhasqui'nīpālh: ―¿Tīchu hui'x? Caquilāhuaniuj ē chuntza' na'iccāhuaniyāuj tī quincātamacaminī'ta'n. ¿Tīchu hui'x? ");
INSERT INTO tkuNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan cākelhtīlh: ―Quit hua'chi tī palha' na'icuan nac cā'tzaya'nca ti'ya't: “Cacāxtlahua'tit mintalacapāstacni'ca'n ē nakexpa'tā'tit Māpa'ksīni' a'cxni' namin.” Chuntza' huanli ixa'kchihuīna' Dios tī huanican Isaías, a'cxni' huanli: Camālaksajtit ixtej Māpa'ksīni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nā ixtahui'lāna'lh makapitzīn fariseos tī ixcālakmacamincanī't Juan. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Xlaca'n takelhasqui'nīlh: ―¿Tū ixpālacata mā'kpaxīni'mpā't palh jā Cristo hui'x, nūn Elías, nūn ixa'kchihuīna' Dios tī icka'lhīmā'nauj? ");
INSERT INTO tkuNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan cāhuanilh: ―Quit iclīmā'kpaxīni'n xcān. Huā'tzā' huī'lh chā'tin tī jā lakapasā'tit. Nā xla' namā'kpaxīni'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Xla' ā'chulā' xaka'tla' ē jā quit. Quit jā minī'ni' nūn na'icxcutni' ixlīchī'can ixcaclhi'. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Pō'ktu huā'mā' a'kspulalh nac Betábara tuntacut nac Jordán, jā ixmā'kpaxīni'n Juan. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ixlīlakalī Juan laktzī'lh Jesús ixlaktalacatzuna'jītēlha ē cāhuanilh tachi'xcuhuī't: ―Calaktzī'ntit tī mimā'lh. Ū'tza' tī macaminī't Dios ē ū'tza' huanican ixTamālacnūn Dios. Ū'tza' namāpānū quincuentaca'n xalanī'n nac cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ū'tza' iclīchihuīna'nli a'cxni' iccāhuanin: “Tī icpūlani'nī't, ū'tza' ā'chulā' xaka'tla' ē jā quit ixpālacata xla' ixuī'lhtza' a'cxni' quit iclacatuncuhuī'lh.” ");
INSERT INTO tkuNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Masqui quit jāna'j xa'iclakapasa, quit icminī't iclīmā'kpaxīni'n xcān ixpālacata tachi'xcuhuī't nataca'tzī Dios macamilh tī icpūlani'nī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nā cāhuanilh Juan: ―Quit iclaktzī'lh Espíritu Santo tī yujchi ē chilh na ixa'cpūn Jesús. Espíritu Santo tasu'yulh hua'chi a'ktin tantzasnān. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Xapūla quit jā xa'icca'tzī tīchu xla'. Quihuanilh Dios tī quimacā'lh na'iclīmā'kpaxīni'n xcān. Dios quihuanilh: “Nalaktzī'na' nayujāchi Espíritu Santo ē nachin na ixa'cpūn chā'tin. Huā'mā' chi'xcu' ū'tza' tī līmā'kpaxīni'n Espíritu Santo.” ");
INSERT INTO tkuNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Iclaktzī'nī'ttza' chī quihuanicanī't. Ū'tza' iclīmāsu'yu quit ū'tza' huā'mā' ī'Ska'ta' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ixlīlakalī huampala Juan ixcātā'layālh chā'tu' ī'scujnu'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Laktzī'lh ixtētaxtumā'lh Jesús. Juan laktzī'lh Jesús ē huanli: ―Ū'tza' huā'mā' tī macamilh Dios ē tī huanican ixTamālacnūn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Chā'tu' ī'scujnu'nī'n Juan takexmatli ē tastālani'lh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesús talakspi'tli ē cālaktzī'lh ixtastālani'tēlha ē cāhuanilh: ―¿Tū putzayā'tit? Xlaca'n tahuanilh: ―Mākelhtahua'kē'ni', ¿jā hui'la'? ");
INSERT INTO tkuNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesús cākelhtīlh: ―Cata'ntit ē calaktzī'ntit. Tatā'a'lh ē talaktzī'lh jā ixuī'lh. Kōtanūtza' hua'chi maktā'ti'tza' ixuanī't, ē chuntza' a'ntza' tatachokolh tzamā' quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tzamā' chā'tu' tī tastālani'lh Jesús ixpālacata tū ixcāhuaninī't Juan, chā'tin ixuanican Andrés, ixtā'tin Simón Pedro. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Palaj tunca Andrés putzalh ixtā'tin tī ixuanican Simón ē huanilh: ―Ictā'lāpāxtokuitza' Mesías. (Ū'tza' huanicu'tun: Cristo tī lacsacnī't Dios.) ");
INSERT INTO tkuNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andrés tā'a'lh Simón talaktzī'n Jesús. A'cxni' Jesús laktzī'lh Simón ē huanilh: ―Hui'x Simón, ixka'hua'cha Jonás. Hui'x nahuanica'na' Cefas. (Huā'mā' ū'tza' huanicu'tun: Pedro ē nā chihuix.) ");
INSERT INTO tkuNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ixlīlakalī huampala Jesús ixa'ncu'tun jā huanican Galilea. Tā'lāpāxtokli Felipe ē huanilh: ―Caquistāla'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Huā'mā' Felipe xala' nac Betsaida ixuanī't ē nā xala' a'ntza' Andrés ē Pedro. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe laka'lh Natanael ē huanilh: ―Iclaktzī'nī'tauj chā'tin tī tatzo'kni' na ixtachihuīn Dios jā Moisés tzo'kli līmāpa'ksīn ē jā tatzo'knulh profetas. Xla' ū'tza' Jesús, ixka'hua'cha José xala' nac Nazaret. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael huanli: ―¿Ē tzē nataxtu tū xatze nac Nazaret? Felipe kelhtīlh: ―Cata't ē calaktzi'. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesús laktzī'lh Natanael lakmimā'lh ē līhuanli: ―Tī mimā'lh ū'tza' tzeya israelita. Xla' jā a'kskāhuī'nin. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael kelhasqui'nīlh: ―¿Chī quilīlakapasti? Jesús huanilh: ―Quit iclaktzī'nī'ta'ntza' xapūla na ixtampīn nac ka'tla' qui'hui' a'cxni' jāna'j ixā'ta'sani'yān Felipe. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael kelhtīlh: ―Mākelhtahua'kē'ni', hui'x ī'Ska'ta' Dios; hui'x puxcu' nalītahui'la'ya' nac Israel. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús kelhtīlh: ―Quina'ka'ī'ni'ya' xmān ixpālacata icuanin iclaktzī'nī'ta'n na ixtampīn nac qui'hui'. Nalaktzī'na'cus ā'chulā' xalaka'tla' tū na'ictlahua. ");
INSERT INTO tkuNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nā huanli Jesús: ―Ixlīcāna' tū icuaniyān. Hui'xina'n nalaktzī'nā'tit a'kapūn laquī'yālh, ē ángeles tī nacāmacamin Dios. Xlaca'n natatahua'ca' ē natayujāchi na ixa'cpūn Chi'xcu' xala' Tālhmā'n. Quit Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ixlī'a'ktu'tun quilhtamacuj tamakaxtokca nac a'ktin cā'lacchicni' jā huanican Caná, nac Galilea. Ixtzī' Jesús a'ntza' ixuī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Nā ixuanicanī't na'a'n Jesús ē ī'scujnu'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Sputli xaxcān uva, ē ixtzī' Jesús huanilh: ―Jātza' tū xaxcān uva. ");
INSERT INTO tkuNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesús kelhtīlh: ―¿Tū ixpālacata quihuani'ya' huā'mā', Nā'? Jāna'j tzucu tū quilītlahuat nahuan. ");
INSERT INTO tkuNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ixtzī' cāhuanilh tī ixtamacascujmā'nalh: ―Catlahua'tit ixlīpō'ktu tū xla' nacāhuaniyān. ");
INSERT INTO tkuNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ixuī'lh pāchāxan tlāmam ixla' chihuix tū ixtamaclacasqui'n israelitas a'cxni' ixtamakacha'ka'n chuntza' chī ixtahui'latca'n. (Ixta'a'ka'ī' palh maklhūhua' ixtamakacha'ka'n, chuntza' natalītaxtu lactze na ixlacatīn Dios.) Pātunu' tlāmam ixtalītatzumā'lh pātu' o pātu'tun pūxka'tni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús cāhuanilh tī ixtamacascujmā'nalh: ―Cacālīmātzuma'tit xcān tzamā' tlāmam. Chuntza' xlaca'n tamātzumalh. ");
INSERT INTO tkuNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jesús cāhuanilh: ―Camācututit macsti'na'j ē calīpini'tit tī cuenta lani' ixla' cā'tani'. ");
INSERT INTO tkuNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Xla' kelhuāna'lh. Xaxcāntza' uva ixuanī't. Xla' jā ixca'tzī palh xcān ixuanī't ē ixtalakpalīnī'ttza'. Ixtaca'tzī xmān tī ixtamacascujmā'nalh, ixpālacata ū'tunu'n ixtamojōnī't xcān. Chi'xcu' tī cuenta lani' cā'tani' ta'sani'lh tī ixtamāxtokmā'lh ");
INSERT INTO tkuNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ē huanilh: ―Tahui'lat xapūla cāmaxquī'can tī cāta'sani'canī't xatze xaxcān uva. Ā'līstān, a'cxni' tzejtza' tako'tnī't tī cāta'sani'canī't, cāmaxquī'can tū jā xatze. Ē hui'x ā'xmān māstā'pā't tū xatze. ");
INSERT INTO tkuNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ū'tza' huā'mā' tū tlahualh Jesús nac Caná nac Galilea, ū'tza' xapūla lī'a'cnīn. Chuntza' līmāsu'yulh ixlītli'hui'qui. Ī'scujnu'nī'n talī'a'ka'ī'ni'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ā'līstān Jesús a'lh nac Capernaum. Tatā'a'lh ixtzī' ē ixtā'timīn ē ī'scujnu'nī'n. A'ntza' jā lakma'j tatahuī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ixtalacatzuna'jīmā'lh ixcā'tani'ca'n lī'israelitas tū huanican pascua. Jesús a'lh nac cā'lacchicni' jā huanican Jerusalén. ");
INSERT INTO tkuNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tanūlh xaka'tla' nac templo. A'ntza' cālaktzī'lh tī ixtastā'mā'nalh huācax ē borregos ē tantzasnān, ē ā'makapitzīn tī ixtahui'lāna'lh na ixmesaca'n jā ixpūpakxtucan tumīn. ");
INSERT INTO tkuNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesús tlahualh a'ktin lītasno'knu' ixla' ko'xka', ē cālītansno'kxtukō'lh ixlīpō'ktuca'n nā borregos nā huācax. Cāmakpūspi'tni'lh ixmesaca'n tī ixtapakxtumā'nalh tumīn, ē cāmaka'ni'kō'lh ixtumīnca'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Cāhuanilh stā'na'nī'n tantzasnān: ―Camāxtutit tzamā' huā'tzā'. Jā calīmāxtutit lītamāuj na ixchic quinTāta'. ");
INSERT INTO tkuNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ī'scujnu'nī'n talīlacapāstacli chuntza' chī ixtatzo'kni' na ixtachihuīn Dios: Iclacasqui'n calakachi'xcuhuī'ca ixchic Dios. Ū'tza' iclacasqui'n quit. ");
INSERT INTO tkuNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Israelitas tahuanilh: ―¿Ē ka'lhī'ya' līmāpa'ksīn natlahua'ya' huā'mā'? Caquilātlahuani'uj a'ktin lī'a'cnīn ē chuntza' na'icca'tzīyāuj palh hui'x ka'lhī'ya' līmāpa'ksīn nacāmāxtuya' animalh xaka'tla' nac templo. ");
INSERT INTO tkuNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús cāhuanilh: ―Calactlahua'tit tzamā' chic ē ixlītu'tuma'j na'iclīcāxtlahuapalakō'. ");
INSERT INTO tkuNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Israelitas takelhtīlh: ―Tu'pu'xamachāxan cā'ta līcāxtlahuakō'ca huā'mā' templo. ¿Ē hui'x tzē nalīcāxtlahuakō'ya' a'ktu'tun quilhtamacuj? ");
INSERT INTO tkuNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","A'cxni' huanli huā'mā' Jesús ixlīchihuīna'mā'lh ixmacni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ī'scujnu'nī'n talacapāstacli ixtachihuīn Jesús a'cxni' lacastālancuana'nli. Ta'a'ka'ī'lh tū ixtatzo'kni' na ixtachihuīn Dios ā'nā tū huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nac Jerusalén ixlamā'lh cā'tani' tū huanican pascua. Jesús ixui'lacha' ē a'ntza' tlahualh lhūhua' lī'a'cnīn. Ū'tza' lhūhua' talī'a'ka'ī'ni'lh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jesús ixcālakapaskō' ixlīpō'ktuca'n, ē xla' ixca'tzī makapitzīn ixta'a'ka'ī' ē ā'makapitzīn jā ixta'a'ka'ī'. ");
INSERT INTO tkuNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jā ixlacasqui'nca nahuanican ixtalacapāstacni'ca'n. Xla' cālakapasni'kō' ixtalacapāstacni'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ixuī'lh chā'tin fariseo ixtacuhuīni' Nicodemo. Xapuxcu' israelitas ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","A'ktin tzī'sni' xla' lakmilh Jesús ē huanilh: ―Mākelhtahua'kē'ni', ca'tzīyāuj Dios macaminī'ta'n namāsu'yu'ya'. Jā tī tī tzē tlahua lī'a'cnīn tū hui'x tlahua'ya' palh jā Dios macaminī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús huanilh: ―Ixlīcāna' tū icuaniyān. Tī jā catilacatuncuhuī'pālh jāla catitā'tapa'ksīlh Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo kelhasqui'nīlh: ―¿Chī nalīlacatuncuhuī'pala chā'tin tī kōlu'tza'? Jāla natanūpala na ixpūlacni' ixtzī' ē nalīlacatuncuhuī'pala. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús huanli: ―Ixlīcāna' tū icuaniyān. Palh tī jā līlacatuncuhuī' xcān ē ixlītli'hui'qui Espíritu Santo, jāla catitā'tapa'ksīlh Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Tī ixlacstīn tachi'xcuhuī't, ū'tza' ka'lhī ixquinīt ē ixlucut. Tī ka'lhī xasāsti' ixlatamat ixpālacata ixlīmāpa'ksīn Espíritu Santo, ū'tza' ka'lhī ixEspíritu Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Jā calī'a'cni' tū icuaniyān: “Ixlacasqui'nca nalacatuncuhuī'pala'yā'tit ē chuntza' naka'lhī'yā'tit xasāsti' milatamatca'n milīpō'ktuca'n.” ");
INSERT INTO tkuNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ū'ni' a'n calhāxcuhuālh. Xmān kexpa'ta' chī macasā'nan ē hui'x jā ca'tzīya' jāchu mincha' ē jāchu a'mā'lh. Nā chuntza' jā ca'tzīya' chī nalīlīlacatuncuhuī'pala chā'tin chi'xcu' ixlītli'hui'qui Espíritu Santo ē naka'lhī xasāsti' ixlatamat. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo kelhasqui'nīpālh: ―¿Chī līla huā'mā'? ");
INSERT INTO tkuNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús huanli: ―¿Ē jā ca'tzīya' hui'x huā'mā'? Hui'x chā'tin mākelhtahua'kē'ni' nac Israel. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ixlīcāna' tū icuaniyān. Iclīchihuīna'nāuj tū icca'tzīyāuj ē icuanāuj tū iclaktzī'nī'tauj. Hui'xina'n jā a'ka'ī'yā'tit tū icuanāuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Hui'xina'n jā quilā'a'ka'ī'ni'yāuj a'cxni' quit iccālītā'chihuīna'nān tū xala' nac cā'quilhtamacuj. Jā quintilā'a'ka'ī'ni'uj palh na'iccālītā'chihuīna'nān tū xala' nac a'kapūn. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Nūn chā'tin lakapasna'n nac a'kapūn, xmān quit. Xa'icui'lacha' a'cxni' jāna'j xa'icā'yujāchi ē ū'tza' iclīlakapasna'n. Quit Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Chuntza' chī Moisés līmā'kayāhualh qui'hui' lūhua' nac cā'tzaya'nca ti'ya't, nā chuntza' ixlacasqui'nca naquimā'kayāhuacan quit nac cruz. Quit Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Chuntza', ixlīpō'ktuca'n tī quintalīpāhuan nataka'lhī xasāsti' ixlatamatca'n tū jā catilaksputli. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Jesús cāhuanipālh: ―Dios cāpāxquī' ixlīpō'ktuca'n tachi'xcuhuī't xalanī'n nac cā'quilhtamacuj. Ū'tza' līmāstā'lh tī ixlīmān ī'Ska'ta' ē chuntza' tī natalīpāhuan xla', xlaca'n jā makstin catitasputli. Nataka'lhī xasāsti' ixlatamatca'n tū jā ka'lhī ixlīsputni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dios macamilh ī'Ska'ta' nac cā'quilhtamacuj. Jā macamilh nacāmakapātīnīn. Macamilh nacālīmakapūtaxtū. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Tī talīpāhuan ī'Ska'ta' Dios, xlaca'n jā caticāmakapātīnīnca. Tī jā talīpāhuan, nacāmakapātīnīncan ixpālacata jā talīpāhuanli tī ixlīmān ī'Ska'ta' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Milh nac cā'quilhtamacuj tī taxkaket ixpālacata namāsu'yu tū ixlīcāna'. Makapitzīn jā ixtalakatī taxkaket. Ā'chulā' talakatīlh jā cā'pucsua' ixpālacata ixtatlahuacu'tun tū jā tze. Ū'tza' nacālīmakapātīnīncan. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Pō'ktu tī tatlahua tū jā tze jā talakatī taxkaket ē jā tatalacatzuna'jīcu'tun nac taxkaket ixpālacata jā talacasqui'n nacālaktzī'ncan chī tatlahuamā'nalh tū jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tī tatlahua tū tze, xlaca'n tatalacatzuna'jī nac taxkaket ixpālacata nacālaktzī'ncan tatlahuamā'nalh tū Dios lacasqui'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ā'līstān Jesús a'lh nac Judea ē tatā'a'lh ī'scujnu'nī'n. A'ntza' tachokolh a'klhūhua' quilhtamacuj ē ixmā'kpaxīni'mā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Nā Juan nā ixmā'kpaxīni'n nac Enón na ixlacatzuna'j Salim ixpālacata a'ntza' ixmā'lh ka'tla' xcān. Tachi'xcuhuī't ixtalakchin ē ixta'a'kpaxa. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Jāna'j ixmānūcan Juan nac pūlāchī'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Makapitzīn ixchi'xcuhuī'n Juan tatzuculh tatā'lāhuanī ā'makapitzīn israelitas ixpālacata chī mā'kpaxīni'ncan ē palh Dios laktzī'n ā'chulā' xatze catīhuālh a'cxni' a'kpaxa. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Talaka'lh Juan ē tahuanilh: ―Mākelhtahua'kē'ni', ¿pāstaca' chi'xcu' tī ixtā'hui'lāchi ixtuntacut nac Jordán ē tī līchihuī'na'? Chuhua'j nā xla' mā'kpaxīni'mā'lh ē ū'tza' lhūhua' talakminkō'. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juan cākelhtīlh: ―Chā'tin chi'xcu' ka'lhī xmān tū Dios maxquī'. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Hui'xina'n kexpa'ttit chī icuanli: “Jā quit Cristo. Xmān quimacamincanī't na'icpūlani'.” ");
INSERT INTO tkuNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","A'cxni' chā'tin chi'xcu' tamakaxtoka, ixla'tza' tlahua tasqui'ni'. Ixamigo pāxtūtāya ē kexmata ē līpāxuhua tū līchihuīna'n. Nā chuntza' quit iclīpāxuhua chī talakmin Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ixlacasqui'nca ā'chulā' natastālani'kō' Jesús ē jā quit. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Tī minī'ta'ncha' nac a'kapūn, ū'tza' ā'chulā' xaka'tla' ē jā tī xala' nac cā'ti'ya'tna'. Tī talacatuncuhuī' nac cā'quilhtamacuj, ū'tunu'n xala' nac cā'quilhtamacuj ē xmān talīchihuīna'n tū xala' nac cā'quilhtamacuj. Tī mincha' nac a'kapūn, ū'tza' ā'chulā' xaka'tla' ē jā tī xala' nac cā'ti'ya'tna'. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Masqui xla' līchihuīna'n tū laktzī'nī't ē tū kexmatnī't, jā tī chā'tin a'ka'ī' tū huan. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Palh tī a'ka'ī' ixtachihuīn tī mincha' nac a'kapūn, ū'tza' lītasu'yu ixlīcāna' tū huan Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tī Dios macamilh, xla' līchihuīna'n ixtachihuīn ixpālacata Dios līpāxuhua māstā' Espíritu Santo. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","XaTāta' pāxquī' ī'Ska'ta' ē macamaxquī'kō'lh pō'ktu ē ū'tza' namāpa'ksīkō'. ");
INSERT INTO tkuNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Tī talīpāhuan ī'Ska'ta' Dios, xlaca'n taka'lhī xasāsti' ixlatamatca'n tū jā catilaksputli. Tī jā talīpāhuan, xlaca'n jā catitaka'lhīlh xasāsti' ixlatamatca'n. Dios nacāmakapātīnīn. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Fariseos ixcāmāca'tzīnīcanī'ttza' Jesús ā'chulā' lhūhua' ixtastālani' ē ixcāmā'kpaxīmā'lh, ē jā Juan. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Jesús jā ixmā'kpaxīni'n; xmān ī'scujnu'nī'n ū'tunu'n ixtamā'kpaxīni'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","A'cxni' Jesús ca'tzīlh fariseos ixcāmāca'tzīnīcanī'ttza', Jesús taxtulh nac Judea ē a'lh nac Galilea. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ixtej Galilea tētaxtu nac Samaria. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","A'cxni' Jesús ixtētaxtumā'lh jā ixtapa'ksīni' nac Samaria, chā'lh nac Sicar a'ktin cā'lacchicni' na ixlacatzuna'j ti'ya't tū Jacob ixmaxquī'nī't ixka'hua'cha tī ixuanican José. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","A'ntza' ixuī'lh a'ktin mu'sni' tū makāstza' ixla' ixuanī't Jacob. A'cxni' tastu'nūt ixuanī't, Jesús chā'lh nac mu'sni'. Makat ixminī'ta'ncha', ē ū'tza' ixlītlakua'nī't. A'ntza' tahuī'lh na ixquilhtūn mu'sni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Jā ixlīna'j lakchilh chā'tin puscāt xala' nac Samaria namācutu xcān. Jesús huanilh: ―Quintā'hua' mixcān. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ī'scujnu'nī'n ixta'a'nī't nac cā'lacchicni' natatamāhua ixlīhua'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tzamā' puscāt samaritana huanilh Jesús: ―Hui'x israelita ē quit samaritana. ¿Chī quilīsqui'ni'ya' xcān? (Chuntza' huanilh ixpālacata israelitas ē samaritanos jā ixtalālaktzī'ncu'tun.) ");
INSERT INTO tkuNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesús kelhtīlh: ―Ca'tzīya' cahuālh tū Dios māstā' ē tī squi'ni'mā'n xcān, hui'x ixquisqui'ni' xatze xcān ē quit xa'icmaxquī'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Puscāt huanilh: ―Hui'x jā ka'lhī'ya' tū napūmācutuya' ē xcān pūlhmā'n tojōmā'cha'. ¿Jāchu nataya'ya' xatze xcān? ");
INSERT INTO tkuNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tī quimpapca'n Jacob quincāmakxtekni'n huā'mā' mu'sni'. Ā'tzā' ixtako'tnun Jacob ē ixlacstīn ē ixanimalh. ¿Ē hui'x ā'chulā' ka'tla' ē jā Jacob? ");
INSERT INTO tkuNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús huanilh: ―Ixlīpō'ktu tī natahua' huā'mā' xcān, natakelhpūtīpala. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Tī natahua' xcān tū na'iccāmaxquī', xlaca'n jātza' maktin catitakelhpūtīpālh. Tzamā' xcān tū na'iccāmaxquī' nala hua'chi mu'sni' na ixpūlacni'ca'n, ē nacāmaxquī' xasāsti' ixlatamatca'n tū jā catilaksputli. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Puscāt huanilh: ―Caquima'xqui' huā'mā' xcān ē chuntza' jātza' maktin ictikelhpūtīlh ē jātza' ictimilh na'ictaya xcān huā'tzā'. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús huanilh: ―Caquīta'sa'ni' minkōlu' ē cata'ntit. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Puscāt kelhtīlh: ―Jā icka'lhī quinkōlu'. Jesús huanilh: ―Ixlīcāna' tū hua'na' jā ka'lhī'ya' minkōlu'. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Hui'x cāka'lhī'nī'ta' kelhaquitzis chi'xcuhuī'n. Tī tā'hui'la' chuhua'j jā minkōlu'. Ixlīcāna' tū huanī'ta'. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Puscāt huanilh: ―Hui'x ixa'kchihuīna' Dios. Chuntza' tasu'yu. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Quinapapana'ca'n samaritanos ixtamakapāxuī Dios huā'tzā' nac sipej. Hui'xina'n israelitas hua'nā'tit xmān nac Jerusalén tzē namakapāxuīcan Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús kelhtīlh: ―Ca'a'ka'i' tū na'icuaniyān. Namin a'ktin quilhtamacuj a'cxni' jātza' catimaclacasqui'nca na'a'ncan namakapāxuīcan Dios nac sipej ē jā nac Jerusalén. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Hui'xina'n samaritanos jā lakapasā'tit tī makapāxuī'yā'tit. Quina'n iclakapasāuj tī icmakapāxuīyāuj. Tī namakapūtaxtūnu'n, xla' ū'tza' chā'tin israelita. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Chilhtza' quilhtamacuj a'cxni' tī tzej tamakapāxuī Dios natalīmakapāxuī ixlīpō'ktu ixlīstacna'ca'n ē nata'a'ka'ī' ixtachihuīn Dios. Dios lacasqui'n chuntza' nalīmakapāxuīcan. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios lakahuan masqui jā tasu'yu. Ixlacasqui'nca tachi'xcuhuī't natalīmakapāxuī pō'ktu ixlīstacna'ca'n; ē ixlacasqui'nca nata'a'ka'ī' ixtachihuīn. Chuntza' tzej natalīmakapāxuī Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Puscāt huanilh: ―Quit icca'tzī namin Mesías tī huanican Cristo tī Dios lacsacnī't ē līhui'līlh ixlīmakapūtaxtūnu'. Xla' naquincāhuanikō'yān ixlīpō'ktu a'cxni' namin. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús huanilh: ―Ū'tza' quit tī tā'chihuīna'mā'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Palaj tunca tachilh ī'scujnu'nī'n. Talī'a'cnīni'lh ixtā'chihuīna'mā'lh Jesús chā'tin puscāt. Nūn chā'tin kelhasqui'nīlh: “¿Tū lacasqui'na'?” Jā kelhasqui'nīca: “¿Tū lītā'chihuīna'mpā't tzamā' puscāt?” ");
INSERT INTO tkuNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Puscāt hui'līlh ixtlāmam ē a'lh nac cā'lacchicni' ē cāhuanilh tachi'xcuhuī't: ");
INSERT INTO tkuNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Capintit laktzī'nā'tit chā'tin chi'xcu' tī quihuanikō'lh ixlīpō'ktu tū ictlahuanī't. Palhāsā' ū'tza' tī Cristo. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tataxtulh nac cā'lacchicni' natalaka'n Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","A'cxni' ixtamimā'nalh tachi'xcuhuī't, ī'scujnu'nī'n Jesús tahuanilh: ―Māpa'ksīni', catihua'ya' macsti'na'j. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Xla' cāhuanilh: ―Quit icka'lhī quilīhua' tū jā lakapasā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Scujnu'nī'n talākelhasqui'nīlh: ―¿Ē huī'lh tī quīxtekni'chitza' ixlīhua'? ");
INSERT INTO tkuNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesús cāhuanilh: ―Quit ictlahuacu'tun ixlīmāpa'ksīn quinTāta' tī quimacaminī't, ē ictlahuakō'cu'tun tū quilīmacaminī't. Ū'tza' huā'mā' quit quilīhua'. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Hui'xina'n hua'nā'tit: “Sputacus a'ktā'ti' mālhcuyu' nalanāna'n.” Quit iccāhuaniyān: Calaktzī'ntit tachi'xcuhuī't. Talacapalatēlha nata'a'ka'ī' quintachihuīn. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Tī scuja maxquī'can ixtatlaj. Nā chuntza' tī quintatā'scuja. Makapitzīn ta'a'ka'ī' ē ū'tza' ixtatlajca'n tī quintatā'scuja. Tī ta'a'ka'ī'nī't quintachihuīn, xlaca'n taka'lhī xasāsti' ixlatamatca'n tū jā catilaksputli. Ū'tza' natalīpāxuhua tī tamāsu'yulh quintachihuīn xapūla ē tī tamāsu'yulh ā'līstān. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ixlīcāna' chī tahuan: “Chā'tin cha'n ē ā'chā'tin ī'nin.” ");
INSERT INTO tkuNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Quit iccāmacā'nī'ta'n na'ī'ninā'tit hui'xina'n jā jā cha'nī'ta'ntit hui'xina'n. Na'ī'ninā'tit jā tascujli ā'makapitzīn. Ū'tza' huanicu'tun hui'xina'n nacāmāsu'yuni'yā'tit tī cāmāca'tzīnīcanī'ttza' macsti'na'j quintachihuīn. Xlaca'n nata'a'ka'ī' ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Lhūhua' samaritanos xalanī'n tzamā' cā'lacchicni' ta'a'ka'ī'ni'lh Jesús ixpālacata tū ixuanī't tzamā' puscāt: “Quihuanikō'lh ixlīpō'ktu tū ictlahuanī't quit.” ");
INSERT INTO tkuNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Chuntza' samaritanos, a'cxni' talakchilh Jesús, tahuanilh cacātā'tamakxtekli ū'tunu'n. Xla' tachokolh a'ktu' quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Lhūhua' ta'a'ka'ī'lh a'cxni' takexmatli tū huanli xla'. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Xlaca'n tahuanilh tzamā' puscāt: ―Chuhua'j jā xmān ixpālacata mintachihuīn ica'ka'ī'yāuj. Quina'n iclīlaktzī'uj quilakastapunca'n ē ickexmatnī'tauj tū huan xla'. Ixlīcāna' palh ū'tza' Cristo tī nacāmakapūtaxtū xalanī'n nac cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ixlī'a'ktu' quilhtamacuj Jesús taxtulh nac Samaria ē a'lh nac Galilea. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesús huanli chā'tin a'kchihuīna' jā lakachi'xcuhuī'can na ixtā'chicni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","A'cxni' Jesús chilh nac Galilea, līpāxuhua talaktzī'lh xalanī'n nac Galilea. Xlaca'n ixtaquīlanī't nac Jerusalén jā ixlamā'lh cā'tani' tū huanican pascua, ē ixtalaktzī'nkō'nī'ttza' lhūhua' tū quītlahualh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesús mimpālh nac Caná, nac Galilea, a'ntza' jā līmāxtulh xaxcān uva. Ixlacatzuna'j Caná, nac a'ktin cā'lacchicni' tū huanican Capernaum, ixuī'lh chā'tin chi'xcu' tī ixtā'scujmā'lh puxcu'. Ixka'hua'cha ixta'jatatla. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","A'cxni' ca'tzīlh ixtaxtunī'ttza' Jesús nac Judea ē ixui'lacha'tza' nac Galilea, palaj tunca xatāta' a'lh laktzī'n Jesús ē huanilh ca'a'lh na ixchic namātzeyī ixka'hua'cha tī ixnīmā'lhtza'. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesús huanilh: ―Hui'xina'n jā a'ka'ī'yā'tit palh jā nalaktzī'nā'tit lī'a'cnīn. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Tzamā' chi'xcu' huanilh: ―Capit na quinchic līhuan jā nanī quinka'hua'cha. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesús huanilh: ―Capinchitza' na minchic. Minka'hua'cha tzeyanlitza'. Tzamā' chi'xcu' a'ka'ī'lh tū huanilh Jesús ē a'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","A'cxni' ixchintēlha na ixchic, ixtasācua'n palaj tunca tataxtulh ta'a'lh talāpāxtoka ē tahuanilh: ―Minka'hua'cha tzeyanlitza'. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Cākelhasqui'nīlh tuchūyā hora tzuculh tzeyan. Tahuanilh: ―Huā' kōtan maktin hora kōtanū tapānūni'lh macscut. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Xatāta' palaj tunca ca'tzīlh chu ū'tza' tzamā' hora a'cxni' huanilh Jesús: “Minka'hua'cha tzeyanlitza'.” Ū'tza' lī'a'ka'ī'ni'lh Jesús tzamā' chi'xcu' ē nā ixlīpō'ktuca'n xalanī'n na ixchic. ");
INSERT INTO tkuNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ū'tza' huā'mā' ixlī'a'ktu' lī'a'cnīn tū tlahualh Jesús a'cxni' mincha' nac Judea ē chā'lh nac Galilea. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Jā makās ā'līstān israelitas talītzuculh cā'tani'. Jesús a'lh nac cā'lacchicni' Jerusalén jā ixlamā'lh cā'tani'. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nac Jerusalén, ixuī'lh a'ktin mu'sni' na ixlacatzuna'j jā ixtalactanū borregos. Tzamā' mu'sni' ixuanican Betesda. Ū'tza' ixtachihuīn hebreo. Ixyāhuacanī'ttza' ixa'cchic tū ixka'lhī a'kquitzis ixtanquilhtīn. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","A'ntza' ixtamā'nalh lhūhua' ta'jatatlanī'n ē tī lakatzī'nī'n ē tī jā tze ixtujanca'n ē tī ixtalū'ntū'lanī't. Xlaca'n ixtaka'lhīmā'nalh a'cxni' ixtasakā'līlh xcān. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Makatunu' ixquīyujāchi chā'tin ángel. Ū'tza' ixsakā'lī xcān. Tī pūla ixtojō nac xcān, a'cxni' ixtasakā'lī, xla' palaj tunca ixtzeyan catūhuālh ta'jatat. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","A'ntza' ixuī'lh chā'tin chi'xcu' tī ixta'jatatla pu'xamacāujtzeyan cā'ta. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesús laktzī'lh tzamā' chi'xcu' jā ixmā'lh. Ixca'tzītza' makāstza' ixta'jatatla ē kelhasqui'nīlh: ―¿Ē tzeyancu'tuna'? ");
INSERT INTO tkuNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tzamā' chi'xcu' kelhtīni'lh: ―Jā tī tī naquimojō nac xcān a'cxni' tasakā'lī. A'cxni' quit ictojōcu'tun palaj tunca tojō ā'chā'tin ē chuntza' quilīskāhuī'can. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús huanilh: ―Catā'kaqui' ē casacti mimpūtama' ē catlā'hua'nti. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Palaj tunca tzamā' chi'xcu' tzeyanli ē sacli ixpūtama' ē tzuculh tlā'huan. Tzamā' quilhtamacuj ū'tza' ixpūjaxcan. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Israelitas tahuanilh chi'xcu' tī mātzeyīca: ―Chuhua'j huā'mā' quilhtamacuj ū'tza' tū pūjaxcan. Hui'x jā minī'ni' līpimpā't mimpūtama'. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Tzamā' chi'xcu' cākelhtīlh: ―Tī quimātzeyīlh, ū'tza' quihuanilh: “Casacti mimpūtama' ē catlā'hua'nti.” ");
INSERT INTO tkuNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Takelhasqui'nīlh: ―¿Tīyā chi'xcu' tī huanin: “Casacti mimpūtama' ē catlā'hua'nti?” ");
INSERT INTO tkuNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tzamā' chi'xcu' jā ixca'tzī tī mātzeyīlh ixpālacata lhūhua' tachi'xcuhuī't ixtahui'lāna'lh ē Jesús ixcātēlacataxtunī'ttza'. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ā'līstān Jesús tā'lāmaclalh xaka'tla' nac templo ē huanilh: ―Chuhua'j hui'x tzeya'nī'ta'tza'. Jātza' catla'hua' tū jā tze. Palh hui'x natlahua'pala'ya' tū jā tze, ā'chulā' napātīpala'ya'. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tzamā' chi'xcu' a'lh ē cāmāca'tzīnīlh israelitas Jesús tī ixmātzeyīnī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Tzamā' quilhtamacuj ū'tza' tū ixpūjaxcan a'cxni' Jesús tlahualh tzamā' lī'a'cnīn. Ū'tza' tatzuculh talīputzastālani' israelitas ē ixtamaknīcu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesús cāhuanilh: ―QuinTāta' pō'ktu quilhtamacuj scujmā'lh ē nā ū'tza' quit iclīscuja. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ū'tza' ā'chulā' talīsītzī'lh israelitas ē ixtalīmaknīcu'tun. Ū'tza' talīsītzī'lh tū tlahualh Jesús tzamā' quilhtamacuj tū pūjaxcan ē ū'tza' ā'chulā' talīsītzī'lh hua'chi Dios lītaxtulh a'cxni' huanli: Dios quinTāta'. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesús cāhuanilh: ―Ixlīcāna' tū iccāhuaniyān. Quit quina'cstu jāla tū ictlahua. Xmān ictlahua ixtalacasqui'nīn quinTāta' Dios. Iclaktzī'n tū tlahua quinTāta' ē xmān ū'tza' ictlahua. Tū tlahua quinTāta', nā ū'tza' ictlahua. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","QuinTāta' quimpāxquī' quit ē quimāsu'yuni' ixlīpō'ktu tū tlahuamā'lh. Naquimāsu'yuni'cus tū ā'chulā' xalaka'tla'. Ū'tza' na'ictlahua ē nalī'a'cnī'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","QuinTāta' mālacastālancuanīni'n. Nā chuntza' quit iccāmaxquī' ixlatamatca'n tī quit iclacasqui'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","QuinTāta' jā tī putzāna'nī. Xla' quimacamaxquī'nī't līmāpa'ksīn quit na'iccāputzāna'nī. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Chuntza' ixlīpō'ktuca'n naquintalīlakachi'xcuhuī' quit lacxtim chī talakachi'xcuhuī' quinTāta' Dios. Tī jā quilakachi'xcuhuī' jā lakachi'xcuhuī' quinTāta' tī quimacaminī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Ixlīcāna' tū iccāhuaniyān. Tī takexmata tū icuan ē talīpāhuan tī quimacaminī't, xlaca'n taka'lhī xasāsti' ixlatamatca'n tū jā catilaksputli. Xlaca'n jā caticāmāpātīnīca; taka'lhītza' ixlatamatca'n xasāsti' tū jā makstin catisputli. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ixlīcāna' tū iccāhuaniyān. Mimā'lhtza' quilhtamacuj ē chuhua'jtza' huā'mā' quilhtamacuj a'cxni' tī jā taka'lhī xasāsti' ixlatamatca'n, xlaca'n natakexmata quintachihuīn quit, ī'Ska'ta' Dios. Tī natakexmata quintachihuīn, xlaca'n nacāmaxquī'can xasāsti' ixlatamatca'n tū jā catilaksputli. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Chuntza' chī quinTāta' Dios māstā' latamat, nā ī'Ska'ta' tzē namāstā' latamat. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Quimaxquī'nī't līmāpa'ksīn na'icputzāna'nī, ixpālacata quit Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Jā calī'a'cnī'tit tū iccāhuanimā'n. Mimā'lh quilhtamacuj a'cxni' nīnī'n natakexmata quintachihuīn. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Natatā'cxtuyāchi xlaca'n nac pūtā'cnūn. Tī tatlahualh tū tze, xlaca'n natalacastālancuana'n ē nataka'lhī xasāsti' ixlatamatca'n. Tī tatlahualh tū jā tze, xlaca'n natalacastālancuana'n ē nacāmakapātīnīncan. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jesús cāhuanipālh: ―Quit jā ictlahua tū xmān quintapāxuān. Quit icputzāna'nī chuntza' chī quilīmāpa'ksī Dios. Ū'tza' tzej iclīputzāna'nī. Quit jā ictlahua tū quintapāxuān. Ictlahua ixtapāxuān quinTāta' tī quimacaminī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Palh xmān quit quilīmān naquilīchihuīna'ncan ē jā tī ā'chā'tin tī naquilīchihuīna'n, chuntza' jā cati'a'ka'ī'ca tū icuan. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Hui'lapālh ā'chā'tin tī naquilīchihuīna'n. Quit icca'tzī tū nahuan xla' quimpālacata, ū'tza' ixlīcāna'. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Hui'xina'n mākelhasqui'nīnīni'ntit Juan. Juan kelhtīni'lh tū ixlīcāna'. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Quit jā icmaclacasqui'n nūn chā'tin chi'xcu' tī nalīchihuīna'n quimpālacata. Xmān iccāhuanimā'n tzamā' ixpālacata hui'xina'n na'a'kapūtaxtuyā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan xla' hua'chi a'ktin pūmaksko tū ixlama ē ixmāxkakēni'n. Hui'xina'n jā makās lakatītit chī ixcāmāxkakēni'yān. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Juan huanli Dios quimacaminī't. Ē quit ictlahua tū quimacamaxquī'nī't. Ū'tza' ā'chulā' māsu'yu Dios quimacaminī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nā Dios quimacamilh ē līchihuīna'n quimpālacata. Hui'xina'n jā makstin kexpa'tnī'ta'ntit ixtachihuīn ē jā makstin laktzī'nī'ta'ntit Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Jā makstin cātanūni'nī'ta'n ixtachihuīn na milīstacna'ca'n. A'ntza' lītasu'yu hui'xina'n jā a'ka'ī'yā'tit palh quit Dios quimacaminī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Hui'xina'n tzej līkelhtahua'ka'yā'tit ixtachihuīn Dios. Puhua'nā'tit chuntza' naka'lhī'yā'tit xasāsti' milatamatca'n tū jā catilaksputli. Masqui ixtachihuīn Dios līchihuīna'n quimpālacata, ");
INSERT INTO tkuNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","hui'xina'n jā quilā'a'ka'ī'ni'cu'tunāuj ē chuntza' jā naka'lhī'yā'tit xasāsti' milatamatca'n tū jā catilaksputli. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Quit jā icputza ixtapāxquī'n chi'xcuhuī'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Quit icca'tzī tzej hui'xina'n jā pāxquī'yā'tit Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Dios quimaxquī'nī't līmāpa'ksīn. Ū'tza' iclīminī't. Hui'xina'n jā quilā'a'ka'ī'ni'yāuj. Palh ixa'cstu ixmilh ā'chā'tin, ū'tza' ixa'ka'ī'tit. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Hui'xina'n lacasqui'nā'tit cacātapāxquī'n tachi'xcuhuī't ē jā lacapāstacā'tit natlahua'yā'tit tū ixtalacasqui'nīn Dios. Ū'tza' jā lī'a'ka'ī'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Jā capuhua'ntit na'iccālīmālacsu'yuyān na ixlacatīn quinTāta'. Tī nacālīmālacsu'yuyān ū'tza' Moisés tī lī'a'ka'ī'ni'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Palh hui'xina'n a'ka'ī'ni'yā'tit cahuālh tū tzo'kli Moisés, nā quit ixquilā'a'ka'ī'ni'uj. Moisés lītzo'knunī't quimpālacata. ");
INSERT INTO tkuNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Palh hui'xina'n jā a'ka'ī'ni'yā'tit tū tzo'kli Moisés, ¿chī naquilālī'a'ka'ī'ni'yāuj tū iccāhuanimā'n? ");
INSERT INTO tkuNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ā'līstān Jesús a'lh ixtuntacut nac mar jā huanican Galilea ē nā huanican Tiberias. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Lhūhua' tachi'xcuhuī't ixtastālani'nī't ixpālacata ixtalaktzī'nī't lhūhua' lī'a'cnīn tū ixtlahuanī't, a'cxni' ixcāmātzeyīnī't ta'jatatlanī'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesús tahua'ca'lh nac sipej ē a'ntza' cātā'tahuī'lh ī'scujnu'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ixtalacatzuna'jītēlha ixcā'tani'ca'n israelitas tū huanican pascua. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesús laca'a'lh ē cālaktzī'lh lhūhua' tachi'xcuhuī't ixtalakmimā'nalh. Huanilh Felipe: ―Chuhua'j ¿jāchu natamāhuayāuj līhua' tū nacāmāhuī'yāuj huā'mā' tachi'xcuhuī't? ");
INSERT INTO tkuNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesús ixlītzā'samā'lh Felipe. Jesús, ixca'tzītza' tū natlahua. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe kelhtīni'lh: ―A'ktu' ciento tumīn jā cati'a'cchā'lh natalīhuā'yankō' macasti'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ā'chātin ī'scujni' ixtacuhuīni' Andrés, ixtā'tin Simón Pedro, huanilh: ");
INSERT INTO tkuNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Ā'tzā' huī'lh chā'tin ka'hua'cha. Līmin macquitzis pāntzīn ixla' cebada ē tantu' squī'ti'. ¿Chī nalī'a'cchā'n natalīhuā'yankō' tachi'xcuhuī't? ");
INSERT INTO tkuNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesús huanli: ―Cacāhuani'tit tachi'xcuhuī't catatahuī'lh. A'ntza' nac cā'seketni' tatahui'lakō'lh hua'chi a'kquitzis mil chi'xcuhuī'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesús maktīni'lh pāntzīn ē maxquī'lh tapāxcatca'tzīn Dios ē cāmaxquī'lh ī'scujnu'nī'n. Xlaca'n tamaxquī'lh tī ixtahui'lāna'lh. Nā chuntza' cāmaxquī'ca squī'ti'. Cāmaxquī'ca chī xlaca'n ixtalacasqui'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","A'cxni' taka'sli, Jesús cāhuanilh ī'scujnu'nī'n: ―Cacāmākēstokkō'tit xalacpītzun. Jā capāxcatlīla'tit. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Tamākēstokli ē a'cchā'lh pācāujtu' chā'xta lītatzumalh xalacpītzun macquitzis pāntzīn ixla' cebada. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tachi'xcuhuī't a'cxni' talaktzī'lh tzamā' lī'a'cnīn tū tlahualh Jesús, xlaca'n tahuanli: ―Ixlīcāna' ū'tza' tzamā' ixa'kchihuīna' Dios tī ixmilh nac cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesús ca'tzīlh ixtalē'ncu'tun ē ixtasāhui'līcu'tun chī ixpuxcu'ca'n. Ū'tza' lītapānūlh ē ixlīmān a'lh nac sipej. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","A'cxni' tzī'satza' ixuanī't, ī'scujnu'nī'n tamincha' na ixquilhtūn mar. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Tatojōlh a'ktin nac barco ē ixtapūtacutnu'mā'nalh nac mar. Ixtachā'ncu'tun nac Capernaum. Cā'pucsua'tza' ixuanī't ē Jesús jāna'j ixtaspi'ta. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Palha' tzuculh ū'nun. Ixpuput xcān tzuculh tā'kayāhua. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","A'cxni' ixtatlā'huanī'ttza' hua'chi a'kquitzis kilómetro ixlīmakat, ī'scujnu'nī'n talaktzī'lh Jesús. Ixtalacatzuna'jītēlha nac barco, ē ixkelhtlā'huantēlha xcān. Xlaca'n tajicua'nli. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jesús cāhuanilh: ―Quit Jesús. Jā cajicua'ntit. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Xlaca'n cā'tapāxuān tamojōlh nac barco. Palaj tunca tachā'lh na ixquilhtūn mar, ixlacatzuna'j Capernaum. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ixlīlakalī tachi'xcuhuī't ixtalahui'lāna'ncha' na ixtuntacut mar. Xlaca'n taca'tzīlh xmān a'ktin barco ixuī'lh ē ū'tza' ixtapūtacutnī't ī'scujnu'nī'n Jesús, ē Jesús jā ixcātā'a'nī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Makapitzīn barcos xalacstīn ixtaminī'ta'ncha' nac Tiberias ē tachilh ixlacatzuna'j jā ixua'canī't pāntzīn a'cxni' māstā'lh tapāxcatca'tzīn Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","A'cxni' tachi'xcuhuī't taca'tzīlh Jesús jātza' ixuī'lh a'ntza' ē nūn ī'scujnu'nī'n, xlaca'n tatojōlh nac barcos ē ta'a'lh taputza nac Capernaum. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","A'cxni' tachi'xcuhuī't tatacutcha', tamaclalh Jesús ē takelhasqui'nīlh: ―Mākelhtahua'kē'ni', ¿jā'cxni' chita' huā'tzā'? ");
INSERT INTO tkuNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús cāhuanilh: ―Ixlīcāna' tū iccāhuaniyān. Hui'xina'n laktzī'ntit lhūhua' lī'a'cnīn tū ictlahualh. Jā ixpālacata lī'a'cnīn quilālīputzayāuj. Hui'xina'n huā'yantit ē kelhka'stit. Ū'tza' quilālīputzayāuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Jā calīscujtit milīhua'tca'n tū nasputa. Ā'chulā' caputzatit līhua't tū jā makstin catisputli. Quit icmāstā' huā'mā' līhua't ixpālacata quit Chi'xcu' xala' Tālhmā'n ē quinTāta' Dios quimāsu'yuchi. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Xlaca'n takelhasqui'nīlh: ―¿Chī na'iclītlahuayāuj tū Dios lacasqui'n? ");
INSERT INTO tkuNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús cākelhtīlh: ―Tū Dios lacasqui'n natlahua'yā'tit, ū'tza' huā'mā': Naquilā'a'ka'ī'ni'yāuj, ixpālacata quit quimacaminī't Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Takelhasqui'nīlh: ―¿Tūyā lī'a'cnīn tzē naquilāmāsu'yuni'yāuj ē chuntza' na'iccālī'a'ka'ī'ni'yān? ¿Tūchu natlahua'ya'? ");
INSERT INTO tkuNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Quinapapana'ca'n tahua'lh tū ixuanican maná nac cā'tzaya'nca ti'ya't. Chuntza' tatzo'kni' na ixtachihuīn Dios: Xla' cāmaxquī'lh ixlīhua'tca'n xala' nac a'kapūn. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús cākelhtīlh: ―Ixlīcāna' tū iccāhuaniyān. Moisés jā cāmaxquī'lh līhua't tū xala' nac a'kapūn. QuinTāta' cāmaxquī'yān tū ixlīcāna' līhua't xala' nac a'kapūn. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Minī'ta'ncha' nac a'kapūn chā'tin tī cāmaxquī' xasāsti' ixlatamatca'n tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tahuanilh: ―Caquilāmaxquī'uj pō'ktu quilhtamacuj tzamā' līhua't. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús cāhuanilh: ―Quit huā'mā' līhua't. Quit iccāmaxquī' xasāsti' ixlatamatca'n tachi'xcuhuī't. Masqui hui'xina'n huā'yanā'tit, natzi'ncspalayā'tit ē nakelhpūtīpalayā'tit. Palh naquilā'a'ka'ī'ni'yāuj, jā caticāsputni'n tapāxuān. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Iccāhuanintza' laktzī'nī'ta'ntittza' lhūhua' lī'a'cnīn tū ictlahualh. Jā a'ka'ī'yā'tit masqui laktzī'nī'ta'ntit. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ixlīpō'ktuca'n tī nacāmālacpuhuanī quinTāta', naquintalakmin. Ē tī naquintalakmin jā icticāmālakaspi'tli. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Quit icminī'ta'ncha' nac a'kapūn na'ictlahua ixtalacasqui'nīn tī quimacamilh. Jā ictlahua xmān quintapāxuān. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","QuinTāta' tī quimacaminī't lacasqui'n na'iccāmaktaka'lha ixlīpō'ktuca'n tī cāmālacpuhuanī naquintalakmin. Xla' lacasqui'n na'iccāmālacastālancuanī a'cxni' nachin tū ā'xmān quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ixtalacasqui'nīn quinTāta' ū'tza' huā'mā': Ixlīpō'ktuca'n tī natahuan quit ī'Ska'ta' Dios ē naquintalīpāhuan, nataka'lhī xasāsti' ixlatamatca'n tū jā catilaksputli; ē quit na'iccāmālacastālancuanī a'cxni' nachin tū ā'xmān quilhtamacuj ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Israelitas tatzuculh talīchihuīna'n Jesús. Jā cāminī'ni'lh chī huanli Jesús: “Quit līhua't. Quit icmincha' nac a'kapūn.” ");
INSERT INTO tkuNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Talāhuanilh: ―¿Ē jā ū'tza' ixka'hua'cha José huā'mā' Jesús? Quina'n cālakapasāuj ixtāta' ē ixtzī'. ¿Tū ixpālacata quincāhuaniyān chuhua'j palh nac a'kapūn minī'ta'ncha'? ");
INSERT INTO tkuNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesús cāhuanilh: ―Jā chuntza' calālīchihuī'na'ntit. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Xmān Dios tzē cāmālacpuhuanī tachi'xcuhuī't naquintastālani'. Ē tī naquinta'a'ka'ī'ni' quit na'iccāmālacastālancuanī a'cxni' nachin tū ā'xmān quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Chuntza' huan jā tatzo'knunī't ixa'kchihuīna'nī'n Dios: Dios nacāmāsu'yuni' ixlīpō'ktuca'n tachi'xcuhuī't. Ixlīpō'ktuca'n tī natakexmata ixtachihuīn quinTāta' ē chuntza' natalīsca'ta, ē naquintastālani'. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Nūn chā'tin laktzī'nī't quinTāta'. Xmān quit iclaktzī'nī't, ixpālacata icminī'ta'ncha' jā hui'lacha' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ixlīcāna' tū iccāhuaniyān. Tī quintalīpāhuan, xlaca'n taka'lhī xasāsti' ixlatamatca'n tū jā catilaksputli. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Quit līhua't tū ka'lhī latamat. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Minapapana'ca'n ixtahua' maná a'cxni' ixtalatlā'huan nac cā'tzaya'nca ti'ya't. Masqui ixtahua' maná, tanīlh. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Quit iccālītā'chihuīna'mā'n līhua't tū minī'ta'ncha' nac a'kapūn. Quit huā'mā' līhua't. Tī quinta'a'ka'ī'ni' jā makstin catitanīlh. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Quit xalakahuan līhua't tū minī'ta'ncha' nac a'kapūn. Tī natahua' huā'mā' līhua't jā makstin catitasputli. Līhua't tū na'iccāmaxquī', ū'tza' quimacni' ē chuntza' natalīka'lhī xasāsti' ixlatamatca'n ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Israelitas tatzuculh talālītā'chihuīna'n ē talāhuanilh: ―¿Chī līlalh huā'mā' chi'xcu' naquincāmaxquī'yān ixmacni' nahua'yāuj? ");
INSERT INTO tkuNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús cāhuanilh: ―Ixlīcāna' tū iccāhuaniyān. Quit Chi'xcu' xala' Tālhmā'n. Palh hui'xina'n jā nahua'yā'tit quimacni' ē quinka'lhni', jā catika'lhī'tit xasāsti' milatamatca'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Tī natahua' quimacni' ē quinka'lhni', xlaca'n nataka'lhī xasāsti' ixlatamatca'n tū jā catisputli. Quit na'iccāmālacastālancuanī a'cxni' nachin ā'xmān quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Quimacni' xatze līhua't ē quinka'lhni' xatze līko'tnuncan. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Xlaca'n tī natahua' quimacni' ē quinka'lhni', lacxtim naquintatā'tahui'la. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Quimacaminī't quinTāta'. Quit xalakahuan ixpālacata quinTāta' xalakahuan. Nā chuntza' na'iccāmālakahuanī tī natahua' quimacni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Quit huā'mā' līhua't tū mincha' nac a'kapūn. Jā chuntza' chī maná tū tahua'lh minapapana'ca'n. Masqui minapapana'ca'n tahua'lh maná, tanīlh. Tī natahua' huā'mā' līhua't tū iccālītā'chihuīna'mā'n, nataka'lhī xasāsti' ixlatamatca'n tū jā catilaksputli. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús huanli huā'mā' a'cxni' ixcāmāsu'yuni'mā'lh nac templo nac Capernaum. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","A'cxni' takexmatli huā'mā', lhūhua' tī ixtastālani'mā'nalh Jesús talāhuanilh: ―Palha' huā'mā' tachihuīn ē jātza' kexmatcu'tunāuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesús ixca'tzī ī'scujnu'nī'n ixtalīchihuīna'mā'nalh ē jā ixcāminī'ni' ixtachihuīn. Ē xla' cākelhasqui'nīlh: ―¿Ē jā cāminī'ni'yān tū iccāhuaniyān? ");
INSERT INTO tkuNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Tūchu ixpuhuantit palh ixlaktzī'ntit Chi'xcu' xala' Tālhmā'n tā'kayāhuamā'lh jā pūla ixui'lacha'? ");
INSERT INTO tkuNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tū iccāhuaniyān, ū'tza' jā huanicu'tun ixlīcāna' nahua'yā'tit quinquinīt. Quinquinīt jā caticāmaxquī'n milatamatca'n. Ū'tza' Espíritu Santo tī nacāmaxquī'yān xasāsti' milatamatca'n. Tū iccāhuanincus, ū'tza' māsu'yu chī tzē nalīka'lhī'yā'tit xasāsti' milatamatca'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Huī'lh makapitzīn hui'xina'n tī jā a'ka'ī'yā'tit. Jesús ixca'tzītza' tī jā ixta'a'ka'ī' ē tī namacamāstā'. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Huanli: ―Ū'tza' iccālīhuaninī'ta'ntza' nūn chā'tin tzē naquintapa'ksīni' palh quinTāta' jā namālacpuhuanī naquistālani'. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ū'tza' lhūhua' talītaspi'tli ē jātza' tastālani'lh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesús cākelhasqui'nīlh ixlīkelhacāujtu' ī'scujnu'nī'n: ―¿Ē hui'xina'n quilāmakxtekcu'tunāuj? ");
INSERT INTO tkuNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedro kelhtīlh: ―Māpa'ksīni', ¿tīchu tzē na'ictā'a'nāuj? Mintachihuīn māsu'yu chī na'iclīka'lhīyāuj quilatamatca'n tū jā catisputli. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Quina'n iccā'a'ka'ī'ni'nī'ta'n hui'x Cristo, ī'Ska'ta' Dios tī xalakahuan. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús cākelhtīlh: ―Quit iccālacsacnī'ta'n minkelhacāujtu'ca'n. Chā'tin tā'scujatza' skāhuī'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesús ixlīchihuīna'mā'lh Judas Iscariote, ixka'hua'cha Simón tī namacamāstā' Jesús, masqui ū'tza' chā'tin ixlīkelhacāujtu' ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","A'cxni' tētaxtukō'lh, Jesús a'lh tā'kchoko nac Galilea. Jātza' ixlatā'kchokocu'tun nac Judea ixpālacata israelitas ixtamaknīcu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ixtalacatzuna'jītēlhatza' cā'tani' tū huanican ixla' mū'xta'ka' tū ixtatlahua israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ē ixtā'timīn Jesús tahuanilh: ―Jā catamakxtekti huā'tzā'. Capittza' nac Judea ē chuntza' mintachi'xcuhuī't natalaktzī'n tū tlahua'pā't. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tī lacasqui'n nalakapascan jā tū catitlahualh cā'lakatzē'k. Palh ixlīcāna' tū tla'hua'ya' hui'x, catla'hua' na ixlacatīnca'n tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nūn chu ixtā'timīn jā ixta'a'ka'ī'ni' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesús cāhuanilh: ―Jāna'j chin quilhtamacuj a'cxni' na'ica'n nac Judea. Hui'xina'n tzē napinā'tit a'cxni' napincu'tunā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Hui'xina'n jāla caticātaquiclhlaktzī'n. Quit quintalīquiclhlaktzī'n iccāhuanimā'lh jā tze tū tatlahuamā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Capintit hui'xina'n jā lamā'lh cā'tani'. Quit jāna'j icti'a'lh ixpālacata jāna'j chin quilhtamacuj tū na'icpū'a'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","A'cxni' cāhuanikō'lh ixtā'timīn, Jesús tachokolh nac Galilea. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","A'cxni' ixta'a'nī'ttza' ixtā'timīn Jesús, nā xla' hua'chi tzē'k a'lh jā ixlamā'lh cā'tani'. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Israelitas ixtaputza Jesús jā ixlamā'lh cā'tani' ē ixtalīkelhasqui'nīni'n: ―¿Jāchu huī'lh tzamā' chi'xcu'? ");
INSERT INTO tkuNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Lhūhua' tī tzē'k ixtalīchihuīna'mā'nalh. Makapitzīn ixtahuan: “Tzeya chi'xcu'.” Ē makapitzīn ixtahuan: “Jā tzeya chi'xcu'; a'kskāhuī'nin.” ");
INSERT INTO tkuNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ē lītzē'k ixtalīchihuīna'n ixpālacata ixtajicua'ni' lī'israelita. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","A'cxni' i'tāttza' ixlamā'lh cā'tani', Jesús tanūlh xaka'tla' nac templo ē tzuculh cāmāsu'yuni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Israelitas talī'a'cnīlh ē talāhuanilh: ―¿Chī tzej līca'tzī huā'mā' chi'xcu'? Jā maktin kelhtahua'ka'nī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús cākelhtīlh: ―Tū icmāsu'yu quit jā quintalacapāstacni'. Ixtalacapāstacni' tī quimacaminī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Palh tī tlahuacu'tun tū Dios lacasqui'n, naca'tzī palh icmāsu'yumā'lh ixtalacapāstacni' Dios, ē jā xmān quintalacapāstacni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tī chihuīna'n xmān ixtalacapāstacni', lacasqui'n calakachi'xcuhuī'ca. Tī lacasqui'n nalakachi'xcuhuī'can tī macaminī't, nahuan tū ixlīcāna'. Jā cati'a'kskāhuī'nilh. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Moisés cāmaxquī'n līmāpa'ksīn ē jā mākentaxtūyā'tit tzamā' līmāpa'ksīn. ¿Ē tū ixpālacata quilālīmaknīcu'tunāuj? ");
INSERT INTO tkuNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Tachi'xcuhuī't takelhtīlh: ―Hui'x chuya'ya'. ¿Tīchu maknīcu'tunān? ");
INSERT INTO tkuNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús cāhuanilh: ―Milīpō'ktuca'n lī'a'cnī'yā'tit tū ictlahualh tzamā' quilhtamacuj tū pūjaxcan. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés cāmāsu'yuni'n tahuilat tū huanican circuncisión (masqui xapūla quinapapana'ca'n chuntza' ixtatlahua). Ū'tza' hui'xina'n līchu'cuyā'tit chā'tin ska'ta' tī xaka'hua'cha, masqui ū'tza' quilhtamacuj tū pūjaxcan. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Chuntza' mākentaxtūyā'tit tū huanli Moisés ē chu'cuyā'tit chā'tin ska'ta' tī xaka'hua'cha, masqui ū'tza' quilhtamacuj tū pūjaxcan. Palh hui'xina'n chuntza' tlahua'yā'tit', ¿tū ixpālacata līsītzī'yā'tit icmātzeyīlh chā'tin ta'jatatlani' tzamā' quilhtamacuj tū pūjaxcan? ");
INSERT INTO tkuNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Hui'xina'n quilāputzāna'nīyāuj ixpālacata puhua'nā'tit jā tze tū ictlahualh. A'cxni' naputzāna'nī'yā'tit ā'chā'tin, ixlacasqui'nca naputzāna'nī'yā'tit chuntza' chī Dios lacasqui'n ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tatzuculh talākelhasqui'nīn xalanī'n nac Jerusalén: ―¿Ē jā ū'tza' tī putzacan maknīcu'tuncan? ");
INSERT INTO tkuNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Calaktzī'ntit chī chihuīna'mā'lh nac cā'lhūhua'lacatīn ē jā tū tahuanī xanapuxcu'nu'. ¿Ē talacpuhuan huā'mā' Cristo tī Dios lacsacnī't? ");
INSERT INTO tkuNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","A'cxni' namin Cristo nūn chā'tin catica'tzīlh jā naminācha'. Quina'n ca'tzīyāuj jā xala' huā'mā' chi'xcu'. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesús kexmatli huā'mā' tachihuīn jā ixcāmāsu'yuni'mā'lh xaka'tla' nac templo. Palha' cāhuanilh: ―Hui'xina'n quilālakapasāuj ē nā ca'tzīyā'tit jā icminī'ta'ncha'. Quit jā icminī't quina'cstu. Tī quimacaminī't xla' ixlīcāna' ē jā lakapasā'tit hui'xina'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Quit iclakapasa ixpālacata a'ntza' icmincha' ē ū'tza' quimacamilh. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Palaj tunca ixtachī'lē'ncu'tun. Nūn chā'tin tī chi'palh ixpālacata jāna'j ixchā'n ixquilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ē līlhūhua' ta'a'ka'ī'ni'lh ē tahuanli: ―Palhāsā' huā'mā' Cristo. ¿Ē Cristo a'cxni' namin ē ā'chulā' natlahua lī'a'cnīn ē jā huā'mā'? ");
INSERT INTO tkuNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseos takexmatli chī tzē'k ixtalīchihuīna'n Jesús tachi'xcuhuī't. Fariseos ē xanapuxcu'nu' pālejni' tamacā'lh ixpolicíaca'n natachī'lē'n Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesús cāhuanilh tachi'xcuhuī't: ―Jātza' lakma'j icticātā'latamān. Palajtza' na'iclaka'n tī quimacaminī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Hui'xina'n naquilāputzayāuj ē jā quintilāmaclauj. Jāla catichipintit jā quit na'ica'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Israelitas talākelhasqui'nīlh: ―¿Jāchu na'a'n palh jāla catimaclauj? Palhāsā' nacālaka'n israelitas tī tatā'hui'lāna'ncha' griegos ē nacāmāsu'yuni' griegos. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Quincāhuanin: “Naquilāputzayāuj ē jā quintilāmaclauj, ixpālacata jāla catichipintit jā na'ica'n quit.” ¿Tūchu huanicu'tun huā'mā' tachihuīn? ");
INSERT INTO tkuNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Tū ā'xmān quilhtamacuj ixla' cā'tani' tū ā'chulā' ixlacasqui'nca, tzamā' quilhtamacuj Jesús tāyalh ē palha' chihuīna'lh: ―Tī takelhpūtī, caquintalakmilh ē catahua'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tī quinta'a'ka'ī'ni' nataka'lhī hua'chi mu'sni' na ixlīstacna'ca'n ē natā'cxtuni'yāchi lhūhua' xcān tū māstā' latamat. Chuntza' tatzo'kni' na ixtachihuīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesús ixuanicu'tun tī nata'a'ka'ī' natamaktīni'n Espíritu Santo. Jāna'j ixmin Espíritu Santo ixpālacata Jesús jāna'j ixa'n nac a'kapūn. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","A'cxni' tachi'xcuhuī't takexmatli huā'mā' tachihuīn, makapitzīn tahuanli: ―Ixlīcāna' huā'mā' Jesús ixa'kchihuīna' Dios tī naquincālakminān. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ā'makapitzīn tahuampālh: ―Ū'tza' huā'mā' Cristo. Ā'makapitzīn tahuampālh: ―Cristo jā catimincha' nac Galilea. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Cristo ī'xū'nātā'nat David. Ē natahui'la nac Belén jā xala' ixuanī't David. Chuntza' tatzo'kni' na ixtachihuīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ū'tza' jā lacxtim ixtalīlacapāstaca ixpālacata Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Makapitzīn ixtachī'lē'ncu'tun ē nūn chā'tin chi'palh. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Policías talaka'mpālh fariseos ē xanapuxcu'nu' pālejni'. Cākelhasqui'nīca: ―¿Tū ixpālacata jā līlī'ta'ntit? ");
INSERT INTO tkuNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Policías takelhtīni'lh: ―Jā maktin ickexmatnī'tauj nūn chā'tin chi'xcu' tī chihuīna'n chī huā'mā' chi'xcu'. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Fariseos takelhtīni'lh: ―Palhāsā' nā hui'xina'n cāta'a'kskāhuī'nī'ta'ntza'. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Jā a'ka'ī'ni'nī't Jesús nūn chā'tin xapuxcu' ē nūn chā'tin fariseo. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Catīhuālh tachi'xcuhuī't tī jā talakapasa ixlīmāpa'ksīn Dios nacāmālaksputūcan. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo tī ixlakminī't Jesús cā'tzī'sni', xla' nā fariseo ixuanī't. Xla' cāhuanilh: ");
INSERT INTO tkuNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Jāla catimakapātīnīuj chā'tin chi'xcu' palh jā pūla naca'tzīyāuj tū laclē'n ē palh jā pūla namakxtekāuj nachihuīna'n. Chuntza' tatzo'kni' nac līmāpa'ksīn. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ā'makapitzīn fariseos tahuanilh Nicodemo: ―¿Ē nā hui'x xala' nac Galilea? Hui'x cakelhtahua'ka' ixtachihuīn Dios ē naca'tzīya' jā makstin minī'ta'ncha' nac Galilea chā'tin ixa'kchihuīna' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Palaj tunca ta'a'lh na ixchicca'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesús a'lh nac sipej jā ixuanican Olivos. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ixlīlakalī tzi'saj Jesús a'lh xaka'tla' nac templo. Ixlīpō'ktu tachi'xcuhuī't talakminkō'lh. Xla' tahuī'lh ē tzuculh cāmāsu'yuni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Fariseos ē mākelhtahua'kē'ni'nī'n līmāpa'ksīn talīmini'lh Jesús chā'tin puscāt. Tzamā' puscāt quītā'maclaca chā'tin chi'xcu' ē chi'paca. Yāhuaca a'ntza' na ixlacpu'i'tātca'n tī ixtahui'lāna'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Tahuanilh Jesús: ―Mākelhtahua'kē'ni', huā'mā' puscāt tā'maclaca chā'tin chi'xcu'. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Līmāpa'ksīn tū quincāmaxquī'nī'ta'n Moisés, ū'tza' quincāmāsu'yuni'yān nacucta'lamaknīyāuj chā'tin puscāt tī chuntza' la. Hui'x, ¿chī hua'na'? ");
INSERT INTO tkuNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Xlaca'n tahuanilh Jesús huā'mā' xmān talīputzāna'nīcu'tun ē chuntza' tzē natalīmālacapū'. Jesús taquilhpūtalh ē tzuculh lītzo'knun ixmacan nac ti'ya't. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ā'chulā' ixtakelhasqui'nī ē xla' tā'clhsajli ē cāhuanilh: ―Chā'tin chī hui'xina'n tī jā tū laclē'n ū'tza' pūla cacucta'lalh tzamā' puscāt. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jesús taquilhpūtapālh ē lītzo'knumpālh ixmacan nac ti'ya't. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","A'cxni' takexmatli huā'mā', nā xlaca'n tamakca'tzīlh ixtalaclē'n. Tatzuculh ta'a'n tī ā'chulā' kōlu'ntza' ē makapitzīn chā'tunu' chā'tunu' ta'a'nkō'lh. Xlīmān tamakxtekli Jesús ē tzamā' puscāt. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesús tā'clhsajli ē kelhasqui'nīlh: ―¿Jāchu tayāna'lh tī ixtamālacsu'yumā'na'n? ¿Nūn tī chā'tin tī makapātīnīnī'ta'n? ");
INSERT INTO tkuNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Xla' huanli: ―Nūn chā'tin, Māpa'ksīni'. Jesús huanilh: ―Nūn quit icmakapātīnīnān. Capit ē jātza' ā'makstin titlahua'ya' tū jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús cātā'chihuīna'mpālh tachi'xcuhuī't ē cāhuanilh: ―Quit iccāmāsu'yuni' tachi'xcuhuī't. Chuntza' quit taxkaket. Tī naquintastālani' jā catitalatā'kchokolh nac cā'pucsua'. Quit na'iccāmāxkakēni'ni' ixlatamatca'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Fariseos tahuanilh: ―Hui'x mintalacapāstacni' līchihuīna'na'. Chuntza' jā tū līmacuan mintachihuīn. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús cākelhtīlh: ―Quit tū icuan, ū'tza' ixlīcāna' masqui quit quina'cstu quilīchihuīna'ncan. Quit icca'tzī jā icminī'ta'ncha' ē jā na'ica'mpala. Hui'xina'n jā ca'tzīyā'tit jā icminī'ta'ncha' ē jā na'ica'mpala. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Hui'xina'n līputzāna'nā'tit xmān tū laktzī'nā'tit. Quit jā tī tī icputzāna'nī. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Palh quit xa'icputzāna'nīlh, na'icputzāna'nī chuntza' chī ixlīcāna'. Quit jā quilīmān icputzāna'nī. QuinTāta' tī quimacaminī't ū'tza' quintā'putzāna'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Chuntza' tatzo'kni' na milīmāpa'ksīnca'n: A'cxni' chā'tu' chi'xcuhuī'n līlacxtim tamālactzeyī, ū'tza' huā'mā' tū ixlīcāna'. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Quit iclīmāsu'yu quimpālacata. Hui'lapālh ā'chā'tin tī līmāsu'yu quimpālacata. Ū'tza' quinTāta' ē ū'tza' quimacaminī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Takelhasqui'nīlh: ―¿Jāchu hui'lacha' mintāta'? Jesús cākelhtīlh: ―Hui'xina'n jā quilālakapasāuj ē nā jā lakapasā'tit quinTāta'. Palh ixquilālakapasui, nā quinTāta' ixlakapastit hui'xina'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús huanli huā'mā' a'cxni' ixmāsu'yumā'lh xaka'tla' nac templo jā ixmāquī'can tumīn. Nūn chā'tin puhuanli nachī'lē'n ixpālacata jāna'j ixchā'ni' ixquilhtamacuj tū napūchī'lē'ncan. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús ā'maktin cāhuanipālh: ―Quit na'ica'n. Hui'xina'n naquilāputzayāuj. A'cxni' nanīyā'tit hui'xina'n naka'lhī'yā'titcus mincuentaca'n. Jāla catipintit jā na'ica'n quit. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Israelitas tahuanli: ―Palhāsā' ixa'cstu namaknīcan ē ū'tza' līhualh jāla cati'a'uj jā na'a'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesús cāhuanilh: ―Hui'xina'n xala' nac cā'ti'ya'tna', ē quit xala' nac tālhmā'n. Hui'xina'n xala' nac cā'quilhtamacuj ē quit jā xala' nac cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ū'tza' iccālīhuanin a'cxni' nanīyā'tit naka'lhī'yā'titcus mincuentaca'n. Hui'xina'n jā quilā'a'ka'ī'ni'yāuj a'cxni' iccāhuaniyān tī quit. Chuntza' nalīka'lhī'yā'titcus mincuentaca'n a'cxni' nanīyā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Palaj tunca takelhasqui'nīlh: ―¿Tīchu hui'x? Jesús cākelhtīlh: ―Iccāhuaninī'ta'ntza' xapūla. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Quit tzē na'icuan lhūhua' mimpālacataca'n ē tzē na'iccāputzāna'nīyān lhūhua' tū tlahuapā'na'ntit tū jā tze. Tī quimacaminī't, xla' huan tū ixlīcāna'. Tū quihuanī, xmān ū'tza' iccāhuanī tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Xlaca'n jā ixtaca'tzī Jesús ixlīchihuīna'mā'lh Dios, xaTāta'. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ū'tza' cālīhuanilh Jesús: ―A'cxni' hui'xina'n naquilāmā'ka'yāhuayāuj tālhmā'n, hasta a'cxni' naca'tzīyā'tit tīchu quit. Quit Chi'xcu' xala' Tālhmā'n. Naca'tzīyā'tit quit jā tū ictlahua quina'cstu. Xmān icuan tū quimāsu'yuni'nī't quinTāta'. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tī quimacamilh, xla' quintā'huī'lh. Jā quimakxteknī't quina'cstu, ixpālacata quit pō'ktu quilhtamacuj ictlahuamā'lh tū ixtalacasqui'nīn. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","A'cxni' Jesús huanli huā'mā', lhūhua' ta'a'ka'ī'ni'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesús cāhuanilh israelitas tī ixta'a'ka'ī'ni'mā'nalhcus: ―Hui'xina'n palh naquilākexpa'tni'yāuj quintachihuīn, chuntza' hui'xina'n ixlīcāna' quiscujnu'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nalakapasā'tit tū ixlīcāna'. Tū ixlīcāna' nalīlaktaxtuyā'tit hui'xina'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Xlaca'n takelhtīlh: ―Quina'n ī'xū'nātā'natna' Abraham. Nūn makstin quincātatamāhuanī'ta'n. ¿Tū ixpālacata hua'na' hui'x na'iclaktaxtuyāuj? ");
INSERT INTO tkuNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús cāhuanilh: ―Ixlīcāna' tū iccāhuaniyān. Tī tlahua tū jā tze, chuntza' chī chā'tin tasācua' tī tamāhuacanī't, ixpālacata jāla makxteka tū jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Xatatamāuj tasācua' jā chuntza' chī tī ixlīcāna' ka'hua'cha. Xatatamāuj jā pō'ktu quilhtamacuj catitahui'lalh na ixchic ixtēcu' ixpālacata nastā'palacan. Tī ixlīcāna' ixka'hua'cha chā'tin chi'xcu', xla' pō'ktu quilhtamacuj ixka'hua'cha. Jāla catistā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Hui'xina'n hua'chi tī xatatamāuj ixpālacata jāla makxtekā'tit tū jā tze. Ī'Ska'ta' Dios tzē nacāmaktāyayān hui'xina'n ē chuntza' tzē nalīmakxtekā'tit tū jā tze. Chuntza' jātza' catitahui'la'tit hua'chi xatatamāuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Masqui hui'xina'n ī'xū'nātā'natna' Abraham, quilāmaknīcu'tunāuj ixpālacata jā a'ka'ī'yā'tit tū iccāhuaniyān. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Quit iclīchihuīna'n tū quimāsu'yuni'nī't quinTāta'. Hui'xina'n tlahua'yā'tit tū cāhuaninī'ta'n mintāta'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Xlaca'n takelhtīlh: ―Quintāta'ca'n, ū'tza' Abraham. Jesús cāhuanilh: ―Palh ixlīcāna' cahuālh hui'xina'n ixlacstīn Abraham, chuntza' ixtlahua'tit chī ixtlahua Abraham. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Hui'xina'n quilāmaknīcu'tunāuj masqui quit iccāhuaniyān tū ixlīcāna' tū Dios quimāsu'yuni'nī't. Abraham jā chuntza' ixtlahua chī hui'xina'n tlahua'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Hui'xina'n tlahua'pā'na'ntit tū tlahua mintāta'ca'n. Xlaca'n tahuanilh: ―Quina'n jā xtūka'hua'chan. Icka'lhīyāuj xmān chā'tin quintāta'ca'n ē ū'tza' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús cāhuanilh: ―Palh mintāta'ca'n cahuālh Dios, hui'xina'n ixquilāpāxquī'uj ixpālacata quit icminī'ta'ncha' jā hui'lacha' Dios ē chuhua'j ā'tzā' icuī'lh. Quit jā icmilh quina'cstu talacapāstacni'. Dios ū'tza' tī quimacaminī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Hui'xina'n jā kexpa'tcu'tunā'tit tū icuan. Ū'tza' jā līca'tzīyā'tit tū iccāhuanimā'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","’Mintāta'ca'n hui'xina'n ū'tza' skāhuī'ni'. Hui'xina'n tlahuacu'tunā'tit ixtalacasqui'nīn. Skāhuī'ni' xla' ū'tza' xamaknīni' hasta ixquilhtzucut. Xla' jā makstin lacapāstaca tū ixlīcāna' ixpālacata jā lakatī tū ixlīcāna'. Xla' huāk tā'ksa'nīn līchihuīna'n ixpālacata xla' chuntza' ixtāyat. Xla' a'ksa'nīni' ē xla' ū'tza' mālacatzuculh tā'ksa'nīn. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Quit iccāhuaniyān tū ixlīcāna' ē hui'xina'n jā quilā'a'ka'ī'ni'yāuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Tīchu chī hui'xina'n nahuanā'tit palh quit ictlahuanī't tū jā tze? Palh quit iccāhuaniyān tū ixlīcāna', ¿tū ixpālacata jā quilā'a'ka'ī'ni'yāuj? ");
INSERT INTO tkuNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tī ixla' Dios kexmata ixtachihuīn. Hui'xina'n jā ixla' Dios. Ū'tza' jā līkexpa'tcu'tunā'tit ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Israelitas tahuanilh Jesús: ―Ixlīcāna' chī icuanāuj hui'x samaritano ē ka'lhī'ya' jā tzeya ū'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús cākelhtīlh: ―Jā icka'lhī jā tzeya ū'ni'. Quit iclakachi'xcuhuī' quinTāta' ē hui'xina'n jā quilālakachi'xcuhuī'yāuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Quit jā quincuenta palh jā quilālakachi'xcuhuī'yāuj. Huī'lh chā'tin tī lacasqui'n caquilakachi'xcuhuī'ca, ū'tza' tī naputzāna'nīkō'. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ixlīcāna' tū iccāhuaniyān: Tī natamākentaxtū quintachihuīn xlaca'n nataka'lhī xasāsti' ixlatamatca'n tū jā makstin catisputli. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Israelitas takelhtīni'lh: ―Quina'n icca'tzīyāujtza' hui'x ka'lhī'ya' tū jā tzeya ū'ni'. Abraham nīlhtza' ē nā tanīlhtza' ixa'kchihuīna'nī'n Dios. Hui'x hua'na' tī natamākentaxtū mintachihuīn jā makstin catitasputli. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Ē hui'x ā'chulā' xaka'tla' ē jā quintāta'ca'n Abraham? Xla' nīlh ē a'kchihuīna'nī'n nā tanīlh. ¿Tīchu hui'x palh jā catinīt? ");
INSERT INTO tkuNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús cākelhtīlh: ―Palh quina'cstu naquilakachi'xcuhuī'can, jā tū ixtapalh. Tī quilakachi'xcuhuī' quit, xla' ū'tza' quinTāta' ē ū'tza' tī hui'xina'n huani'yā'tit minDiosca'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ū'tza', tī hua'nā'tit minDiosca'n, jā lakapasā'tit. Ē quit iclakapasa. Palh quit xa'icualh jā iclakapasa, quit xa'iclītaxtulh chā'tin a'ksa'nīni' chuntza' chī hui'xina'n. Quit ixlīcāna' iclakapasa ē quit icmāquī' ixtachihuīn. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham tī mimpapca'n ka'lhīlh tapāxuhuān ixpālacata ixca'tzī nalaktzī'n a'cxni' xa'icmilh nac cā'quilhtamacuj. Xla' laktzī'lh ē līpāxualh. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Israelitas tahuanilh Jesús: ―Hui'x jāna'j ka'lhī'ya' nūn i'tāt ciento cā'ta, ¿ē chī līhua'na' palh laktzī'nī'ta'tza' Abraham? ");
INSERT INTO tkuNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús cākelhtīlh: ―Ixlīcāna' tū iccāhuaniyān. Quit xa'icuī'lhtza' a'cxni' jāna'j ixlacatuncuhuī' Abraham. ");
INSERT INTO tkuNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Palaj tunca tasacli chihuix ē ixtalīcucta'lacu'tun. Jesús cātatzē'kni'lh ē chuntza' lītaxtulh xaka'tla' nac templo. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","A'cxni' Jesús ixlatlā'huan, laktzī'lh chā'tin chi'xcu' tī ixlīlacatuncuhuī'nī't xalakatzī'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ī'scujnu'nī'n takelhasqui'nīlh: ―Māpa'ksīni', ¿tū ixpālacata līlacatuncuhuī'lh lakatzī'n huā'mā' chi'xcu'? ¿Ē ixpālacata ixcuentaca'n ixtāta' ē ixtzī', o ixpālacata ixcuenta līlakatzī'? ");
INSERT INTO tkuNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús cāhuanilh: ―Jā ixpālacata ixcuenta līlakatzī' nūn ixcuentaca'n ixtāta' ē ixtzī'. Xla' līlacatuncuhuī'lh lakatzī'n ixpālacata chuntza' tzē nalīmāsu'yu ixlītli'hui'qui Dios a'cxni' namātzeyī. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","A'cxni' xkakacus, tzē scujcan; a'cxni' tzī'suamā'lhtza', jātza' la catiscujca. Nā chuntza' quit ixlacasqui'nca na'ictlahua chuhua'j ixtascujūt tī quimacaminī't. Namin a'ktin quilhtamacuj a'cxni' na'ica'n ē jātza' la ca'ictiscujli. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Quit iccāmāxkakēni'ni' tachi'xcuhuī't līhuan icuī'lh nac cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","A'cxni' huanli huā'mā' Jesús chojli nac cā'ti'ya'tna'. Tlahualh macsti'na'j pūtlū'n ē līlacatlahualh na ixlakastapun lakatzī'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Huanilh: ―Capinchi nac xcān jā huanican Siloé ē nalakacha'ka'na'. (Siloé huanicu'tun: Macamincanī't.) Tzamā' lakatzī'n a'lh ē a'ntza' lakacha'ka'nli. A'cxni' chimpālh, tzētza' ixlacahuāna'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ixtā'līmacchicni' ē tī ixtalaktzī'nī't xapūla a'cxni' lakatzī'n ixuanī't, xlaca'n talāhuanilh: ―¿Ē jā ū'tza' huā'mā' chi'xcu' tī ī'squi'nīhuā'yan? ");
INSERT INTO tkuNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Makapitzīn ixtahuan: ―Ū'tza'. Ā'makapitzīn ixtahuan: ―Jā ū'tza'. Hua'chi ū'tza' tasu'yu. Ē ū'tza' huanli: ―Quit tzamā' chi'xcu'. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Takelhasqui'nīlh: ―¿Chī līlalh tzētza' lacahuāna'na' hui'x? ");
INSERT INTO tkuNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Xla' cākelhtīlh: ―Ū'tza' tzamā' chi'xcu' tī huanican Jesús tlahualh pūtlū'n ē quilīlacatlahualh na quilakastapun. Quihuanilh: “Capinchi nac xcān jā huanican Siloé ē calakacha'ka'.” Ica'lh ē a'cxni' iclakacha'ka'nkō'lh, tzētza' iclacahuāna'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Takelhasqui'nīlh: ―¿Jāchu huī'lh tzamā' chi'xcu'? Xla' cāhuanilh: ―Jā icca'tzī. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Cālīmini'ca fariseos tzamā' chi'xcu' tī ixlakatzī'. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Tzamā' quilhtamacuj tū pūtlahualh pūtlū'n Jesús ē mātzeyīlh lakatzī'n, ū'tza' quilhtamacuj tū pūjaxcan. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Fariseos ā'maktin takelhasqui'nīpālh: ―¿Chī līlacahuā'na'? Xla' cākelhtīlh: ―Quilīlacatlahualh pūtlū'n na quilakastapun ē iclakacha'ka'nli ē chuhua'j quit tzē iclacahuāna'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Makapitzīn fariseos tahuanli: ―Huā'mā' chi'xcu' jā ixla' Dios ixpālacata jā lakachi'xcuhuī' quilhtamacuj tū pūjaxcan. Ā'makapitzīn tahuampālh: ―Tī tlahua tū jā tze, xla' jā catitlahualh lī'a'cnīn chī tlahua huā'mā' chi'xcu'. Jā lacxtim ixtaka'lhī ixtalacapāstacni'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Takelhasqui'nīpālh tzamā' chi'xcu' tī lakatzī'n ixuanī't: ―¿Chī hua'na' hui'x ixpālacata tzamā' chi'xcu' tī mālacahuānīn? Xla' huanli: ―Xla' ixa'kchihuīna' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Israelitas, xlaca'n jā ta'a'ka'ī'ni'lh palh lakatzī'n ixuanī't ē mālacahuānīca. Cāta'sani'ca ixtāta' ē ixtzī'. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ē cākelhasqui'nīca: ―¿Ē ū'tza' huā'mā' chi'xcu' minka'hua'chaca'n tī lacatuncuhuī'lh xalakatzī'n? ¿Chī tzētza' līlacahuāna'n chuhua'j? ");
INSERT INTO tkuNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ixtāta' ē ixtzī' takelhtīni'lh: ―Quina'n icca'tzīyāuj ū'tza' quinka'hua'chaca'n. Icca'tzīyāuj līlacatuncuhuī'lh lakatzī'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Jā icca'tzīyāuj chī tzētza' līlacahuāna'n chuhua'j. Jā icca'tzīyāuj tī mālacahuānīlh. Cakelhasqui'nī'tit ū'tza'; xla' chi'xcu'tza'. Māni' ū'tza' tzē nacāhuaniyān. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ixtāta' ē ixtzī' tahuanli chuntza' ixpālacata xlaca'n ixtajicua'ni' israelitas. Israelitas ixtalīchihuīna'nī'ttza' natamacxtucan xaka'tla' nac templo tī natahuan Jesús ū'tza' Cristo. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ū'tza' talīhuanli ixtāta' ē ixtzī': “Cakelhasqui'nī'tit ū'tza'; xla' chi'xcu'tza'.” ");
INSERT INTO tkuNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Israelitas tata'sani'pālh ixlīmaktu' chi'xcu' tī lakatzī'n ixuanī't ē tahuanilh: ―Caquilāhuaniuj ixlīcāna' na ixlacatīn Dios. Quina'n icca'tzīyāuj huā'mā' chi'xcu' tlahua tū jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Xla' cākelhtīlh: ―Quit jā icca'tzī palh tlahua tū jā tze. Xmān icca'tzī xapūla lakatzī'n xa'icuanī't ē chuhua'j iclacahuāna'ntza'. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Kelhasqui'nīpalaca: ―¿Tū tlahuani'n? ¿Chī līmālacahuānīn? ");
INSERT INTO tkuNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Xla' cākelhtīlh: ―Iccāhuani'ntza'. Hui'xina'n jā ixkexpa'tcu'tunā'tit. ¿Tū ixpālacata lacasqui'nā'tit na'iccāhuanipalayān? ¿Ē nā stālani'cu'tunā'tit nā hui'xina'n? ");
INSERT INTO tkuNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Talakapalalh ē tahuanilh: ―Hui'x stālani'ya' tzamā' chi'xcu'. Quina'n icstālani'yāuj Moisés. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Icca'tzīyāuj Dios tā'chihuīna'nli Moisés. Huā'mā' Jesús jā icca'tzīyāuj jā minī'ta'ncha'. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Chi'xcu' cākelhtīlh: ―¿Chī līlalh jā ca'tzīyā'tit jā mincha' tzamā' chi'xcu'? Ū'tza' tī quimālacahuānīlh. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Quina'n ca'tzīyāuj Dios jā cākexmata tī tatlahua tū jā tze. Dios cākexmata tī talakachi'xcuhuī' ē tī tatlahua tū ixtalacasqui'nīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","A'cxni' ixlītzucuni' quilhtamacuj, jā makstin kexmatca chā'tin chi'xcu' mālacahuānī tī lakatzī'n lacatuncuhuī'nī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Palh jā Dios ixmacamilh, jāla tū ixtitlahualh. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tahuanilh: ―Hui'x līlacatuncuhuī'nī'ta' ixlītzumayān tū jā tze. ¿Tū naquilāmāsu'yuni'yāuj quina'n? Tamacxtuca nac kēpūn. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús huanica ixtamacxtucanī't tzamā' chi'xcu' tī lakatzī'n ixuanī't. A'cxni' tā'lāpāxtokli, huanilh: ―¿Ē a'ka'ī'ni'ya' hui'x ī'Ska'ta' Dios? ");
INSERT INTO tkuNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Chi'xcu' huanilh: ―¿Tīchu xla'? Caquihua'ni' ē chuntza' tzē na'iclī'a'ka'ī'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús kelhtīlh: ―Hui'x laktzī'nī'ta'tza'. Ū'tza' tī tā'chihuīna'mā'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tzamā' chi'xcu' taquilhpūtani'lh ē huanilh: ―Māpa'ksīni', ica'ka'ī'ni'yān. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesús huanli: ―Quit icmilh nac cā'quilhtamacuj nalītasu'yu tī ta'a'ka'ī' ē tī jā ta'a'ka'ī'. Quit icmilh nac cā'quilhtamacuj na'iccāmālacahuānī tī xalakatzī'nī'n ē icmilh na'iccāmālakatzī' tī talacahuāna'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Makapitzīn fariseos ixtayāna'lh ixlacatzuna'j. A'cxni' takexmatli huā'mā' tachihuīn, tahuanli: ―¿Ē iclakatzī'yāuj quina'n? ");
INSERT INTO tkuNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús cāhuanilh: ―Palh lakatzī'n cahuālh hui'xina'n, jā ixlīpintit cuenta. Hua'nā'tit hui'xina'n lacahuāna'nā'tit, ē ū'tza' hui'xina'n līlīpinā'tit cuenta. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesús cāhuanipālh: ―Ixlīcāna' tū iccāhuaniyān: Tī lacatin lactanū na ixchicca'n borregos ē jā lactanū jā yālh xamākelhcha ū'tza' ka'lhāna'. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Tī lactanū jā yālh xamākelhcha, ū'tza' ixmaktaka'lhna' borregos. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Tī maktaka'lha mākelhcha mālaquī'ni' tī cāmaktaka'lha borregos ē takexmata ixtachihuīn. Cāmāpācuhuī chī tanatunu' ixborrego. Cāmāxtu na ixchicca'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","A'cxni' cāmāxtukō' xla' cāpūlani' ē ixlīborregos tastālani' ixpālacata xlaca'n takelhlakapasatza' ixtēcu'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Jā catitastālani'lh tī ā'chā'tin ixpālacata jā takelhlakapasa. Natatzā'lani'. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús cāhuanilh huā'mā' tachihuīn chī cālīmāsu'yuni'can. Xlaca'n jā taca'tzīlh tū ixcāhuanicu'tuncan. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesús cāhuanipālh: ―Ixlīcāna' tū iccāhuaniyān. Quit chī xamākelhcha jā talactanū borregos. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ixlīpō'ktuca'n tī quintapūlani'lh, xlaca'n ka'lhāna'nī'n. Ē borregos jā takexmatni'lh līka'lhāna'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Quit chī mākelhcha. Tī naquinta'a'ka'ī'ni', xlaca'n natapūtaxtu. Na'iccāmaktaka'lha chī cāmaktaka'lhcan borregos tū natataxtu ē nataputza ixlīhua'tca'n ē natatanūpala. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Ka'lhāna' xmān min ka'lhāna'n ē maknīni'n ē mālaksputūnu'n. Quit icminī't na'iccāmaxquī' xasāsti' ixlatamatca'n tū ā'chulā' xatze. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Quit ā'chulā' xatze ixmaktaka'lhna' borregos. Tī xatze ixmaktaka'lhna' tzej cāmaktaka'lha ixborregos ē masqui cacālīnīlh. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Tī xmān tasācua', a'cxni' laktzī'n mimā'lh misin, cāmakxteka borregos ē tzā'latāquī' ixpālacata jā tzamā' maktaka'lhna' jā ixla' borregos. Palaj tunca misin cāchi'pa borregos ē cāmakatzā'lakō'. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Tasācua' tzā'la ixpālacata xmān tasācua' ē jā ixla' borregos, ē xla' jā ixcuenta. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Quit hua'chi xatze maktaka'lhna' borregos. Xatze maktaka'lhna' cālakapasa ixborregos, ē nā quit iccālakapasa quintachi'xcuhuī't, ē nā xlaca'n quintalakapasa. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Nā chuntza' quinTāta' quilakapasa ē nā quit iclakapasa. Quit na'iccālīnī quintachi'xcuhuī't chuntza' chī maktaka'lhna' borregos cālīnī ixborregos. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Hui'lapālh ā'makapitzīn tachi'xcuhuī't tī jāna'j quintalakapasa. Nā ixlacasqui'nca nā xlaca'n na'iccālīmin. Xlaca'n naquintakexmatni'. Chuntza' xlaca'n kēxtim natala quintachi'xcuhuī't. Xmān chā'tin ixmaktaka'lhna' nahuan. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’QuinTāta' quimpāxquī' ixpālacata icmāstā' quilatamat ē quit na'iclakahuampala. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nūn chā'tin quintimaktīlh quilatamat. Quit icmāstā' ixpālacata icmāstā'cu'tun. Quit icka'lhī talacasqui'nīn ē chuntza' tzē na'icmāstā', ē tzē na'ictayapala. Chuntza' quilīmāpa'ksīlh quinTāta' ―huanli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","A'cxni' israelitas takexmatli huā'mā' tachihuīn, tatapāpitzini'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Makapitzīn ixtahuan: ―¿Tū ixpālacata kexpa'tni'yā'tit huā'mā' chi'xcu' palh ka'lhī jā tzeya ū'ni', ē xla' chuya? ");
INSERT INTO tkuNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ā'makapitzīn huampala tahuanli: ―Tī ka'lhī jā tzeya ū'ni', xla' jā chuntza' catichihuīna'nli. ¿Ē tzē namālacahuānī chā'tin lakatzī'n jā tzeya ū'ni'? ");
INSERT INTO tkuNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nac Jerusalén ixtlahuamā'ca cā'tani'. Tzamā' cā'tani' ū'tza' tū ixlīlacapāstaccan a'cxni' ixcāxtlahuakō'canī't xaka'tla' templo makāstza'. Cā'lonkni' ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús ixlatlā'huan na ixtanquilhtīn xaka'tla' templo jā ixuanican Ixtanquilhtīn Salomón. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Israelitas tasti'li'hui'līlh ē tahuanilh: ―¿Hasta jā'cxni' naquilāhuaniyāuj tīchu hui'x? Palh hui'x Cristo xamaktin caquilāhuaniuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús cākelhtīlh: ―Quit iccāhuanintza' ē hui'xina'n jā a'ka'ī'yā'tit. Pō'ktu tū ictlahua quit iclītlahua ixlītli'hui'qui quinTāta'. Ū'tza' lītasu'yu tīchu quit. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Hui'xina'n jā a'ka'ī'yā'tit ixpālacata hui'xina'n jā quintachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Quintachi'xcuhuī't takexmata quintachihuīn chuntza' chī borregos takexmata ixtachihuīn ixtēcu'ca'n. Quit iccālakapasa quintachi'xcuhuī't, ē xlaca'n quintastālani'. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Quit iccāmaxquī' xasāsti' ixlatamatca'n tū jā makstin catilaksputli. Jā tī chā'tin tzē naquimaktī tī quinta'a'ka'ī'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Quimacamaxquī'nī't quinTāta' ē xla' ū'tza' ā'chulā' xaka'tla' māpa'ksīni'. Ē nūn tī chā'tin tī tzē quintimaktīlh tī quinta'a'ka'ī'ni'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Quit ē quinTāta' chu chā'tin quina'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Palaj tunca israelitas tasacpālh chihuix ixtalīcucta'lacu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesús cāhuanilh: ―Ixlītli'hui'qui quinTāta' quit iclītlahuanī't lhūhua' tū xatze na milacatīnca'n. ¿Ē ū'tza' naquilālīcucta'layāuj? ");
INSERT INTO tkuNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Israelitas tahuanilh: ―Jā ū'tza' icticālīcucta'lan ixpālacata tū lactze tlahuanī'ta'. Na'iccālīcucta'layān ixpālacata hui'x lakmaka'na' Dios ē mālakchipini'cu'tuna'. Hui'x xmān chi'xcu'. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesús cāhuanilh: ―Chuntza' tatzo'kni' na ixlīmāpa'ksīn Dios: “Hui'xina'n milīpō'ktuca'n diosnu'.” ");
INSERT INTO tkuNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Dios cāmāpācuhuīlh diosnu' tī cāmacamaxquī'lh ixtachihuīn Dios ē huā'mā' tatzo'kni' jā makstin catilactlahuaca. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Dios quilacsacli ē quimacamilh nac cā'quilhtamacuj. ¿Tū ixpālacata quilālīmālacsu'yuyāuj iclakmaka'lh Dios a'cxni' iccāhuanin quit ī'Ska'ta' Dios? ");
INSERT INTO tkuNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Palh quit jā ictlahua chuntza' chī tlahua quinTāta', jā caquilā'a'ka'ī'ni'uj. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Palh hui'xina'n jā quilā'a'ka'ī'ni'cu'tunāuj, masqui quit ictlahua chuntza' chī tlahua quinTāta', ca'a'ka'ī'tit tū ictlahua ū'tza' ixla' Dios. Chuntza' naca'tzīyā'tit hui'xina'n ē na'a'ka'ī'yā'tit xaTāta' ē quit chu chā'tin quina'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ē ā'maktin ixtachī'lē'mpalacu'tun ē Jesús cātzā'lani'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Palaj tunca Jesús a'lh na ixtuntacut nac Jordán. Chā'lh jā Juan ixmā'kpaxīni'mā'lh xapūla. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Lhūhua' tachi'xcuhuī't talakchilh Jesús ē xlaca'n talāhuanilh: ―Masqui Juan jā tlahualh lī'a'cnīn, pō'ktu tū ixlīchihuīna'n Jesús, ū'tza' tū ixlīcāna'. ");
INSERT INTO tkuNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","A'ntza' lhūhua' ta'a'ka'ī'ni'lh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ixuī'lh chā'tin chi'xcu' ixtacuhuīni' Lázaro. Xla' ixta'jatatla. Xla' ixlahuī'lh a'ktin nac cā'lacchicni' tū huanican Betania. Nā ixtatā'lahui'lāna'lh María ē Marta ixtā'timīn. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Huā'mā' María ū'tza' tī lītantūtlahualh Jesús xaxcān xa'nat ē lītantūxacalh ixya'j. Lázaro, ixtā'tin María ixta'jatatla. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","María ē Marta tamāca'tzīnīlh Jesús ē tahuanilh: ―Māpa'ksīni', ta'jatatla tī pāxquī'ya'. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","A'cxni' huanica huā'mā' Jesús huanli: ―Huā'mā' ta'jatat jā catilaknīlh. Ixpālacata tzamā' ta'jatat nalaktzī'ncan chī ixlīka'tla' Dios, ē nā nalīmāsu'yu chī ixlīka'tla' ī'Ska'ta'. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús ixcāpāxquī' Marta ē María ē nā Lázaro. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","A'cxni' huanica Lázaro ixta'jatatla, Jesús tachokopālh jā ixuī'lh ā'a'ktu' quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ā'līstān cāhuanilh ī'scujnu'nī'n: ―Ca'a'uj nac Judea. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ī'scujnu'nī'n tahuanilh: ―Māpa'ksīni', israelitas xalanī'n nac Judea jāna'j makās ixtacucta'lamaknīcu'tunān. Ē hui'x pimpalacu'tuna'tza'. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesús cāhuanilh: ―A'ktin quilhtamacuj ka'lhī a'kcāujtu' hora. Palh chā'tin latlā'huan cā'cuhuīni', jā cati'a'kche'kxlalh ixpālacata xkakana'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Palh chā'tin latlā'huan cā'tzī'sni', xla' a'kche'kxla ixpālacata jā ka'lhī taxkaket. Ixlacasqui'nca na'ica'n chuhua'j. Jā tū quinti'a'nani'lh hasta na'ictitlahuakō' quintascujūt. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ā'līstān Jesús cāhuanilh: ―Lázaro, quinamigoca'n lhtatamā'lh ē quit na'ica'n na'icmālakahuanī. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ī'scujnu'nī'n tahuanilh: ―Māpa'ksīni', palh lhtatamā'lh, natzeyan. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesús ixcāhuanicu'tun Lázaro ixnīnī'ttza'. Ī'scujnu'nī'n ixtapuhuan Jesús ixcāhuanimā'lh xmān ī'lhtatamā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ū'tza' tzej cālīhuanikō'lh: ―Lázaro nīnī'ttza'. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Xalītze jā xa'icuī'lh a'ntza' quit. Chuntza' xatze mimpālacataca'n. Chuntza' nalī'a'ka'ī'yā'tit. Chuhua'j ca'a'uj jā mā'cha' Lázaro. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomás, tī ixuanican Līstu', cāhuanilh ā'makapitzīn scujnu'nī'n: ―Nā catā'a'uj Jesús. Nanīyāuj lacxtim. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","A'cxni' chā'lh Jesús, māca'tzīnīca tā'ti'ma'jtza' ixa'cnū Lázaro. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania hua'chi a'ktu'tun kilómetro ixuanī't ixlīmakat nac Jerusalén. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Lhūhua' israelitas ixtalakminī't Marta ē María. Tatastokli ixpālacata ixnīnī't ixtā'tinca'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta, a'cxni' ca'tzīlh ixchā'ntēlhatza' Jesús, palaj tunca milh lakapāxtoka. María tachokolh nac chic. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta huanilh Jesús: ―Māpa'ksīni', palh ixtahui'la' huā'tzā', jā ixtinīlh quintā'tin. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Quit icca'tzī, masqui chuhua'j, Dios namaxquī'yān pō'ktu tū nasqui'ni'ya'. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús huanilh: ―Mintā'tin nalacastālancuana'mpala. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta huanilh: ―Quit icca'tzī nalacastālancuana'mpala a'cxni' ā'xmān quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesús huanilh: ―Quit tī na'iccāmālacastālancuanī tachi'xcuhuī't ē quit na'iccāmaxquī' xasāsti' ixlatamatca'n. Tī quintalīpāhuan, masqui catanīlh, xlaca'n nataka'lhī xasāsti' ixlatamatca'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tī taka'lhī xasāsti' ixlatamatca'n ē quintalīpāhuan, jā makstin catitasputli. ¿Ē hui'x jā a'ka'ī'ya' huā'mā'? ");
INSERT INTO tkuNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta huanilh: ―Jē, Māpa'ksīni'. Quit ica'ka'ī' hui'x ī'Ska'ta' Dios, ē hui'x Cristo tī xa'icka'lhīmā'nāuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta, a'cxni' huanli huā'mā', a'lh ta'sani' María ixtā'tin. Lakatzē'k huanilh: ―Chuhua'j chilhtza' Māpa'ksīni' ē ta'sani'yān. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","A'cxni' kexmatli huā'mā', María palaj tunca tāyalh ē laka'lh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús jāna'j ixtanū nac cā'lacchicni'. Ixlayālhcus jā quīpāxtokli Marta. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Israelitas ixtatā'lahui'lāna'lh María nac chic ē ixtamāmakxtokmā'nalh. A'cxni' talaktzī'lh María chī tāyalh ē palaj tunca a'ntāquī'lh, xlaca'n tastālani'lh. Ixtapuhuan a'mā'lh calhuan nac pūtā'cnūn. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","María a'cxni' lakchā'lh Jesús, tatzokostani'lh ē huanilh: ―Māpa'ksīni', palh ixtahui'la' huā'tzā', jā ixtinīlh quintā'tin. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesús laktzī'lh tzuculh calhuan María ē israelitas tī ixtatā'mimā'nalh. Lhpipeklalh ē līpuhuanli. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Cākelhasqui'nīlh: ―¿Jāchu mā'cnū'tit? Tahuanilh: ―Māpa'ksīni', cata't laktzī'na'. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesús calhuanli. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Israelitas talāhuanilh: ―Calaktzī'ntit chī ixpāxquī'. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ā'makapitzīn tahuanli: ―Ū'tza' huā'mā' tī mālacahuānīlh lakatzī'n. ¿Ē jāla ixtlahualh Lázaro jā ixtinīlh? ");
INSERT INTO tkuNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús līpuhuampālh ā'maktin. Chā'lh nac pūtā'cnūn. A'ktin lhu'cu' ixtlahuacanī't ē ixlīlakatalacanī't a'ktin chihuix. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesús huanli: ―Camāpānū'tit chihuix. Marta, ixtā'tin nīn, huanilh: ―Māpa'ksīni', ka'lhī a'ktā'ti' quilhtamacuj nīnī't ē chuhua'j pu'csantza'. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús huanilh: ―¿Ē jā icuanin palh na'a'ka'ī'ya', nalaktzī'na' ixlītli'hui'qui Dios tū natlahua? ");
INSERT INTO tkuNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Palaj tunca māpānūca chihuix. Jesús talacayāhualh nac tālhmā'n ē huanli: ―Tāta', icmaxquī'yān tapāxcatca'tzīn ixpālacata hui'x quinkexpa'tni'nī'ta'. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Quit icca'tzī tihua'na' quinkexpa'tni'ya'. Quit icuaniyāntza' ixpālacataca'n tachi'xcuhuī't tī tahui'lāna'lh huā'tzā' xlaca'n chuntza' nata'a'ka'ī' hui'x quimacata'nī'ta'. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","A'cxni' huankō'lh huā'mā', Jesús palha' huanli: ―¡Lázaro, cataxtu! ");
INSERT INTO tkuNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ta'a'cxtulh tī xanīntza' ixuanī't. Ixlīmakchī'canī't ē ixlīlacchī'canī't ē ixlīlakatlapacanī't lu'xu'. Jesús cāhuanilh: ―Calacxcutit ē camacaxcutit ē chuntza' camakxtektit. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","A'cxni' talaktzī'lh Jesús tū tlahualh, ta'a'ka'ī'lh lhūhua' israelitas tī ixtamāmakxtokmā'nalh María. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Makapitzīn talaka'lh līfariseos ē cāhuanica tū ixtlahuanī't Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Fariseos ē xanapuxcu'nu' pālejni' ē māpa'ksīni'nī'n talāmāstokli ē talāhuanilh: ―¿Tū natlahuayāuj chuhua'j? Huā'mā' chi'xcu' tlahuamā'lh lhūhua' lī'a'cnīn. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Palh jā tū natlahuani'yāuj, nata'a'ka'ī'ni'kō' ū'tza', ē xanapuxcu'nu' romanos natamin ē natalactlahua xaka'tla' templo ē quincā'lacchicni'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Chā'tin chī ū'tunu'n ixuanican Caifás. Xla' ū'tza' xapuxcu' pālej ixuanī't tzamā' cā'ta. Cāhuanilh: ―Hui'xina'n jā ca'tzīyā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Hui'xina'n jā kexpa'tā'tit. Ā'chulā' tze palh chā'tin chi'xcu' nanī quimpālacataca'n. Chuntza' ixlīpō'ktu cā'lacchicni' jā catilaksputli. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Tū huanli Caifás, jā ixa'cstu ixtalacapāstacni'. Caifás xapuxcu' pālej ixuanī't tzamā' cā'ta, ē Dios māhuanīlh chī Jesús nalīnī ixpālacataca'n tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jā xmān israelitas ixticālīnīlh; nā ixlīpō'ktuca'n xala' makat, ē ū'tza' tzē nacālīmākēxtimī ē kēxtim natala. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tzamā' quilhtamacuj xanapuxcu'nu' israelitas tatzuculh talīchihuīna'n chī tzē natalīmaknī Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ū'tza' Jesús jātza' ixcālītasu'yuni' israelitas. Taxtulh nac Judea ē a'lh ā'lacatin cā'lacchicni' tū ixuanican Efraín, na ixlacatzuna'j nac cā'tzaya'nca ti'ya't. A'ntza' cātā'tahuī'lh ī'scujnu'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ixtalacatzuna'jītēlhatza' ixcā'tani'ca'n israelitas tū huanican pascua. A'cxni' jāna'j ixtzucu cā'tani', lhūhua' tachi'xcuhuī't ta'a'lh nac Jerusalén natatalacpa'lha chuntza' chī ixtahui'latca'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Xlaca'n ixtaputza Jesús. A'cxni' ixtatanūmā'nalhtza' xaka'tla' nac templo, ixtalākelhasqui'nī: ―¿Chī puhua'nā'tit hui'xina'n? ¿Namin Jesús o jā catimilh? ");
INSERT INTO tkuNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Fariseos ē xanapuxcu'nu' pālejni' ixtamāstā'nī't līmāpa'ksīn palh ixuī'lh tī ixca'tzī jā ixuī'lh Jesús, cacāmāca'tzīnīca ē chuntza' tzē nalīchi'pacan. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ixtalacatzuna'jītēlhatza' cā'tani' tū ixuanican pascua. Xmān a'kchāxan quilhtamacuj ī'sputa. Jesús a'lh nac Betania jā ixui'lacha' Lázaro tī ixmālacastālancuanīnī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","A'ntza' cāxtlahuaca ixlīhua' Jesús. Marta ixcāmaxquī' ixpulātuca'n. Lázaro ē makapitzīn lacxtim ixtatā'hui'lāna'lh Jesús jā ixtahuā'yamā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","María līmilh i'tāt litro xaxcān xa'nat nardo tū mu'csun ē lhūhua' ixtapalh. Lītantūtlahualh Jesús ē palaj tunca lītantūxacalh ixya'j. Ixlīpūchakānmu'csun chic. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Judas Iscariote, ixka'hua'cha Simón, tī nā ī'scujni' ixuanī't ē tī namacamāstā' Jesús, huanli: ");
INSERT INTO tkuNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Tū ixpālacata jā līstā'ca huā'mā' xaxcān xa'nat? Hua'chi a'ktu'tun ciento tumīn ixtapalh. Huā'mā' tumīn tzē ixcāmaxquī'ca xcamanīnī'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas jā ixcālakalhu'man xcamanīnī'n. Huanli huā'mā' chū'nu xla' ka'lhāna' ixuanī't. Xla' ixmāmāquī'nīcanī't tumīn ē a'ntza' ixka'lhantēlha. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesús huanilh: ―Jā camāmakchu'yi' huā'mā' puscāt. Xla' māquī'nī't huā'mā' xaxcān xa'nat hasta naquilītlahua ixpālacata a'cxni' na'icnī ē naquimā'cnūcan. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Pō'ktu quilhtamacuj na'a'nan xcamanīnī'n. Quit jā pō'ktu quilhtamacuj icticātā'latamān. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","A'cxni' taca'tzīlh Jesús ixui'lacha' nac Betania, lhūhua' israelitas ta'a'lh talaktzī'n. Jā xmān Jesús ixtalaktzī'ncu'tun. Nā ixtalaktzī'ncu'tun Lázaro tī ixmālacastālancuanīnī't Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Chuntza' xanapuxcu'nu' pālejni' nā xlaca'n talīchihuīna'mpālh nā natamaknī Lázaro. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ixpālacata Lázaro, lhūhua' israelitas ixtatalakaspi'tnī'ttza' pālejni' ē ixta'a'ka'ī'ni'nī'ttza' Jesús. Ū'tza' ixtalīmaknīcu'tun Lázaro. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ixlīlakalī lhūhua' tachi'xcuhuī't tī ixtachinī't nac Jerusalén jā ixlamā'lh cā'tani', xlaca'n taca'tzīlh Jesús ixmimā'lh nac Jerusalén. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Talē'lh ixpeken palhma ē ta'a'lh talāpāxtoka Jesús ē ixtamāta'sīmā'nalh: ―¡Camakapāxuī'tit Dios! ¡Dios casicua'lanātlahualh tī līmimā'lh ixlītli'hui'qui Māpa'ksīni'! Ū'tza' quimPuxcu'ca'n quina'n israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús ixmaclanī't lakatin burro ē ixkēhuī'lh. Chuntza' tatzo'kni' na ixtachihuīn Dios: ");
INSERT INTO tkuNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Jā cajicua'ntit hui'xina'n xalanī'n nac Sión; chuhua'j mimPuxcu'ca'n mimā'lh ē kēhuī'lh lakatin xaska'ta' burro. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Xapūla ī'scujnu'nī'n jā ixtaca'tzī tū ixuanicu'tun huā'mā'. A'cxni' Jesús lacastālancuana'nli, a'cxni' talacapāstacli chī ixtatzo'kni' ē chuntza' mākentaxtūlh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Tachi'xcuhuī't tī ixtatā'hui'lāna'lh Jesús a'cxni' xla' ta'sani'lh Lázaro nac pūtā'cnūn jā ixmā'cnūcanī't ē mālacastālancuanīlh, ē xlaca'n ixtalīchihuīna'mā'nalh tū ixtalaktzī'nī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ū'tza' talī'a'lh talīpāxtoka Jesús lhūhua' tachi'xcuhuī't ixpālacata xlaca'n ixtaca'tzī ixtlahuanī't huā'mā' lī'a'cnīn. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Fariseos talāhuanilh: ―Calaktzī'ntit chī tastālani'kō'. Jāla tū tlahuani'yāuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Makapitzīn griegos nā xlaca'n ixta'a'nī't nac Jerusalén natalaktaquilhpūta Dios a'cxni' ixlamā'lh cā'tani'. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Xlaca'n talaka'lh Felipe xala' nac Betsaida nac Galilea. Tahuanilh: ―Señor, quina'n ictā'chihuīna'ncu'tunāuj Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipe laka'lh Andrés ē huanilh tū tahuanli. Ixchā'tu'ca'n ta'a'lh tahuanī Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesús cāhuanilh: ―Quit Chi'xcu' xala' Tālhmā'n. Chilhtza' quilhtamacuj tū naquimpūlakachi'xcuhuī'can ixpālacata palaj na'icnī. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ū'tza' ixlīcāna'. Palh a'ktin līcha'nat namāstā' ixtahua'ca't, ixlacasqui'nca namā'cnūcan nac ti'ya't. A'cxni' namā'cnūcan, pūla tasu'yu hua'chi ixnīnī't. Ā'līstān namāstā' ixtahua'ca't. Nā chuntza' naquina'kspula a'cxni' naquimā'cnūcan. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nā chuntza' tachi'xcuhuī't. Tī tatlahua tū ixtalacasqui'nīnca'n, xlaca'n nacāsputni' ixlatamatca'n. Tī tatlahua ixtalacasqui'nīn Dios, taka'lhī xasāsti' ixlatamatca'n tū jā makstin caticāsputni'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tī quintatā'scujcu'tun, caquintastālani'lh. Jā na'ictahui'la quit nac a'kapūn, nā a'ntza' naquintatā'tahui'la tī quintatā'scuja. QuinTāta' nacālakachi'xcuhuī' ixlīpō'ktuca'n tī quintatā'scuja. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Chuhua'j quit ictamakchuyīnī't. ¿Chī na'icuan? Jā ictihuanilh quinTāta': “Tāta', caquimakapūtaxtū tū na'icpātī.” Jāla icuan chuntza'. Ixlacasqui'nca na'icpātīni'n. Ū'tza' iclīminī't nac cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tāta', calakachi'xcuhuī'ca' hui'x. Palaj tunca kexmatca a'ktin tachihuīn nac a'kapūn tū huanli: ―Quilakachi'xcuhuī'canī'ttza' ē naquilakachi'xcuhuī'palacan. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Tachi'xcuhuī't, a'cxni' takexmatli huā'mā', tahuanli: ―Jililh. Ā'makapitzīn tahuampālh: ―Chā'tin ángel tā'chihuīna'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesús cāhuanilh: ―Huā'mā' tachihuīn chihuīna'nli mimpālacataca'n ē jā quimpālacata. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Chuhua'j natzucucan cāputzāna'nīcan xalanī'n nac cā'quilhtamacuj. Namaktīcan ixlītli'hui'qui tī māpa'ksī huā'mā' cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Quit a'cxni' naquimā'kayāhuacan nac cruz, na'iccāmāpāstaquī ixlīpō'ktuca'n tachi'xcuhuī't palh naquintakexmatni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jesús huanli huā'mā' ixpālacata chuntza' naca'tzīcan chī nalīnī. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tachi'xcuhuī't takelhtīlh: ―Quilīmāpa'ksīnca'n quincāmāsu'yuni'yān Cristo natahui'la ixlīpō'ktu quilhtamacuj. ¿Chī līhua'na' hui'x Chi'xcu' xala' Tālhmā'n namā'kayāhuaca'na' nac cruz? ¿Ē tīchu huā'mā' Chi'xcu' xala' Tālhmā'n? ");
INSERT INTO tkuNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesús cāhuanilh: ―Jātza' makās catika'lhī'tit taxkaket. Catlā'hua'ntit hui'xina'n līhuancus ka'lhī'yā'tit taxkaket ē jāna'j lakatzī'suanā'tit. Tī talatlā'huan cā'pucsua' jā taca'tzī jā ta'a'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Quit taxkaket ixpālacata icmāsu'yu tū ixlīcāna'. Caquilā'a'ka'ī'ni'uj ē chuntza' naca'tzīyā'tit tū ixlīcāna'. A'cxni' ixuanī'ttza' huā'mā', Jesús a'lh ē cātatzē'kni'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Israelitas jā ixta'a'ka'ī'ni' Jesús masqui ixtlahuanī'ttza' lhūhua' lī'a'cnīn ixlacatīnca'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Chuntza' mākentaxtūlh tū ixtzo'knī't a'kchihuīna' Isaías: Māpa'ksīni', jā tī a'ka'ī'nī't tū icmāsu'yūj. Jā tī a'ka'ī'lh masqui laktzī'nca chī Dios ka'lhī lītli'hui'qui. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Isaías līchihuīna'nli chī jāla ixta'a'ka'ī'. Ē ū'tza' līhuampālh: ");
INSERT INTO tkuNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dios cāmālakatzī'lh ē cālactlahuani'lh ixtalacapāstacni'ca'n. Chuntza' jāla natalacahuāna'n ē jā natalīlacapāstaca ixlīstacna'ca'n ē jā quintalakmin na'iccālīmātzeyī. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías huanli huā'mā' ixpālacata ixlaktzī'nī'ttza' chī ixlītli'hui'qui Jesús. Chuntza' līchihuīna'nli Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Lhūhua' xanapuxcu'nu' ta'a'ka'ī'ni'lh Jesús. Xlaca'n xmān tzē'k ta'a'ka'ī'lh ixpālacata ixtajicua'ni' līfariseo. Ixtajicua'n nacātamacxtucan nac templo. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Xlaca'n ā'chulā' ixtalakatī catalakachi'xcuhuī'lh tachi'xcuhuī't; ē jā ixtatlahuacu'tun tū Dios lacasqui'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesús palha' chihuīna'nli ē huanli: ―Tī quinta'a'ka'ī'ni'nī't jā xmān quina'cstu quinta'a'ka'ī'ni'nī't. Xlaca'n ta'a'ka'ī'ni'nī't nā quinTāta' tī quimacaminī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tī quintalaktzī'n hua'chi talaktzī'mā'nalh nā quinTāta' tī quimacaminī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Quit taxkaket. Icminī't nac cā'quilhtamacuj nacāmāxkakēni'ni' tachi'xcuhuī't. Chuntza' tī naquinta'a'ka'ī'ni' jātza' catitatahuī'lh nac cā'pucsua', ixpālacata nata'a'ka'ī' tū ixlīcāna'. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Tī takexmata quintachihuīn ē jā ta'a'ka'ī', jā quit icticāputzāna'nīlh. Quit icminī't na'iccāmakapūtaxtū xalanī'n nac cā'quilhtamacuj, ē jā icminī't na'iccāputzāna'nī. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Tī quintalakmaka'n ē jā ta'a'ka'ī' quintachihuīn, xlaca'n nacāputzāna'nīcan. A'cxni' ā'xmān quilhtamacuj, nacālīputzāna'nīcan tū icuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Quit jā xmān icchihuīna'n tū quintalacapāstacni'. QuinTāta' tī quimacamilh xla' quimāpa'ksīlh tū icuan ē tū icmāsu'yu. ");
INSERT INTO tkuNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Quit icca'tzī quinTāta' quimāpa'ksīlh tū iccāmāsu'yuni' tachi'xcuhuī't chī natalīka'lhī xasāsti' ixlatamatca'n tū jā catilaksputli. Tū quihuaninī't quinTāta', ū'tza' iclīchihuīna'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","A'cxni' jāna'j ixtzucu cā'tani', Jesús ca'tzīlh ā'macsti'na'j ī'sputni' nalatama ē nalaka'mpala ixTāta'. Xla' pō'ktu quilhtamacuj ixcāpāxquī'nī't tī ixla' xala' nac cā'quilhtamacuj. Jātza' lātma'j namāsu'yu chī lhūhua' ixcāpāxquī'. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesús ixcātā'huā'yamā'lh ī'scujnu'nī'n. Skāhuī'ni' ixmālacpuhuanīnī'ttza' Judas Iscariote, ixka'hua'cha Simón, namacamāstā' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús ixca'tzī ixTāta' ixmaxquī'kō'nī't līmāpa'ksīn. Nā ixca'tzī ixminī'ta'ncha' jā huī'lh Dios ē nalaka'mpala. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ā'līstān tāyalh jā ixuā'yamā'lh ē tamakxtulh ixlu'xu' tū ixmākelhalīnī't ē tampātahuī'lh a'ktin ixlīmacaxaca. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Palaj tunca mojōlh xcān nac a'ktin pūmakacha'ka'. Tzuculh cātantūche'kē' ī'scujnu'nī'n ē cālītantūxacalh ixlīmacaxaca tū ixtampāhuī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","A'cxni' ixtantūche'kē'cu'tumā'lhtza' Simón Pedro huanli: ―Māpa'ksīni', ¿hui'x naquintantūche'kē'ya'? ");
INSERT INTO tkuNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús kelhtīlh: ―Chuhua'j hui'x jā ca'tzīya' tū ictlahuamā'lh. Ā'līstān nalacapāstaca. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro huanilh: ―Quit jā makstin quintitantūche'ke'. Jesús huanilh: ―Palh jā ictitantūche'kē'n, hui'x jātza' quintitā'scujti. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simón Pedro huanilh: ―Jā xmān quintujan, nā quimacan caquimakache'ke', ē nā quina'kxāk caquina'kche'ke'. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesús huanilh: ―Tī paxni'cus, xmān ixlacasqui'nca natantūche'kē'can ixpālacata pō'ktu ixmacni' xatache'kē'n. Hui'xina'n lactze. Xmān chā'tin jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesús ixca'tzītza' tī namacamāstā'. Ū'tza' līhuanli: “Hui'xina'n lactze. Xmān chā'tin jā tze.” ");
INSERT INTO tkuNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jesús a'cxni' cātantūche'kē'kō'lh ī'scujnu'nī'n, lhakā'pālh ixlu'xu' ē tahui'lapālh ē cāhuanilh: ―¿Ē lacaca'tzīyā'tit tū iccātlahuani'nī'ta'n? ");
INSERT INTO tkuNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Hui'xina'n quilāmāpācuhuīyāuj Mākelhtahua'kē'ni' ē Māpa'ksīni'. Tze chī hua'nā'tit. Ū'tza' quit. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Quit Mākelhtahua'kē'ni' ē Māpa'ksīni', ē iccātantūche'kē'nī'ta'n. Nā chuntza' ixlacasqui'nca hui'xina'n nalātantūche'kē'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Quit iccātlahuani'n huā'mā' hua'chi xalīlaktzī'ntēn. Nā chuntza' natlahua'yā'tit hui'xina'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ixlīcāna' tū iccāhuaniyān. Hui'xina'n jā ā'chulā' xaka'tla' chī quit. Hui'xina'n hua'chi quintasācua'n ē quit mintēcu'ca'n. Hui'xina'n quilacscujnī'n ē quit iccāmālacscujūyān. Chuntza' ixlacasqui'nca natlahua'yā'tit tū ictlahua. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Hui'xina'n ca'tzīyā'tit tū iccāhuaninī'ta'ncus. Palh natlahua'yā'tit, līpāxuhua nalatapāyā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Jā milīpō'ktuca'n iccālīchihuīna'nān. Quit icca'tzī tī iccālacsacnī't. Namākentaxtū chuntza' chī tatzo'kni' na ixtachihuīn Dios: Ū'tza' tī quintā'huā'yan ū'tza' jā quilaktzī'ncu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Quit iccāhuanimā'n tū na'a'kspula. A'cxni' nala huā'mā', hui'xina'n naca'tzīyā'tit tīchu quit. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Quit ixlīcāna' iccāhuaniyān. Tī takexmatni' tī icmacā'n, quit quintakexmatni' ē nā takexmatni' tī quimacaminī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","A'cxni' huankō'lh huā'mā', Jesús līpuhuanli ē lacatancs huanli: ―Ixlīcāna' iccāhuaniyān, chā'tin chī hui'xina'n naquimacamāstā'. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ē tatzuculh talālakalaktzī'n ī'scujnu'nī'n ixpālacata jā ixtaca'tzī tī ixlīchihuīna'mā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Chā'tin ī'scujni' ixuā'yamā'lh na ixpāxtūn. Ū'tza' tī ā'chulā' ixpāxquī' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simón Pedro macahuanilh tzamā' scujni': ―Cakelhasqui'ni' tīchu līchihuīna'mā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Xla' ā'chulā' laktalacatzuna'jīlh Jesús ē kelhasqui'nīlh: ―Māpa'ksīni', ¿tīchu līchihuīna'mpā't? ");
INSERT INTO tkuNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús kelhtīlh: ―Na'icmāchū'huī' līhua' pītzuna'j pāntzīn. Ē tī na'icmaxquī' ū'tza' iclīchihuīna'mā'lh. Māchū'huī'lh pītzuna'j pāntzīn ē maxquī'lh Judas Iscariote, ixka'hua'cha Simón. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","A'cxni' Judas maktīni'lh pāntzīn, tanūni'lh skāhuī'ni' na ixlīstacna'. Palaj tunca Jesús huanilh: ―Tū tla'hua'cu'tuna', palaj tunca catla'hua'. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Makapitzīn tī ixtahuā'yamā'nalh jā ixtalacaca'tzī tū chuntza' ixlīhuanimā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas ū'tza' ixmāmāquī'nīcanī't tumīn, ē makapitzīn tapuhuanli Jesús ixuaninī't natamāhua tū ixtamaclacasqui'n ixpālacata cā'tani', o ixuaninī't nacāmaxquī' macasti'n xcamanīnī'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","A'cxni' ixua'nī'ttza' pāntzīn, Judas taxtulh. Tzī'satza' ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","A'cxni' Judas ixtaxtunī'ttza', Jesús huanli: ―Chuhua'j Dios quimāka'tlī'nī't quit, Chi'xcu' xala' Tālhmā'n. Ē xla' quilītaka'tlī'nī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Namāka'tlī'can Dios ixpālacata tū ictlahua, ē chuntza' Dios naquilīmāka'tlī'. Palaj tunca nakentaxtu. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Quilacstīn, jātza' makās icticātā'tahui'lan. Hui'xina'n naquilāputzayāuj. Chuntza' chī iccāhuanilh israelitas, nā hui'xina'n chu chuntza' chuhua'j na'iccāhuaniyān: Jā na'ica'n, hui'xina'n jāla catipintit. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Iccāmaxquī'yān xasāsti' līmāpa'ksīn: Calāpāxquī'tit hui'xina'n. Chuntza' chī iccāpāxquī'yān quit, nā chuntza' nalāpāxquī'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Palh hui'xina'n nalāpāxquī'yā'tit, chuntza' natalīca'tzī ixlīpō'ktuca'n tachi'xcuhuī't hui'xina'n quiscujnu'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro kelhasqui'nīlh Jesús: ―Māpa'ksīni', ¿jāchu pimpā't? Jesús kelhtīlh: ―Jā na'ica'n, jāla quintitā'pi chuhua'j. Ā'līstān naquistālani'ya'. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro huanilh: ―Māpa'ksīni', ¿tū ixpālacata jāla ictitā'a'n chuhua'j? Iclīnīcu'tun mimpālacata. ");
INSERT INTO tkuNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús kelhtīlh: ―¿Ē ixlīcāna' quilīnīcu'tuna'? Ixlīcāna' tū icuaniyān. A'cxni' jāna'j ta'sa puyux, hui'x nakelhtatzē'ka' maktu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesús cāhuanipālh: ―Hui'xina'n jātza' catamakchuyī'tit. Calīpāhua'ntit Dios ē nā chuntza' quit caquilālīpāhuanui. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Jā hui'lacha' quinTāta', a'ntza' a'nan lhūhua' pūtahuī'lh. Palh jā cahuālh chuntza', xa'iccāhuanin. Ica'nā iccāxui'lī pūtahuī'lh jā natahui'la'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","A'cxni' na'ica'n ē na'iccāxui'līkō'yācha', na'icmimpala ē na'iccālē'nān. Chuntza' jā na'ictahui'la, nā hui'xina'n a'ntza' natahui'la'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Hui'xina'n ca'tzīyā'tit jā ica'mā'lh ē ca'tzīyā'tit chī tzē līchā'ncan. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás huanilh: ―Māpa'ksīni', quina'n jā icca'tzīyāuj jā pimpā't. ¿Chī na'iclīca'tzīyāuj chī līchā'ncan? ");
INSERT INTO tkuNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús kelhtīlh: ―Quit xatze tej, ē quit tū ixlīcāna', ē quit latamat. Xmān tī quinta'a'ka'ī'ni' tzē natalakchā'n quinTāta'. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Palh hui'xina'n ixca'tzītit tīchu quit, ixlakapastit quinTāta'. Chuhua'j lakapasā'tittza' quinTāta' ē laktzī'nī'ta'ntit. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Felipe huanilh: ―Māpa'ksīni', caquilāmāsu'yuni'uj minTāta'. Xmān ū'tza' iccāsqui'ni'yān. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús kelhtīlh: ―Felipe, makās iccātā'hui'lan. ¿Tū ixpālacata jāna'j quilakapasa'? Tī quintalaktzī'nī't, nā talaktzī'nī't quinTāta'. ¿Tū ixpālacata līhua'na': “Caquilāmāsu'yuni'uj minTāta'?” ");
INSERT INTO tkuNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Ē jā a'ka'ī'ya' quinTāta' ē quit chu chā'tin? Tū iccāhuaniyān, jā quintalacapāstacni'. QuinTāta' quintā'lahuī'lh, ē māni' ū'tza' quintā'tlahua tū ixtascujūt. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ca'a'ka'ī'tit chu chā'tin quina'n, quit ē quinTāta'. Palh jāla na'a'ka'ī'yā'tit huā'mā', calī'a'ka'ī'tit lī'a'cnīn tū ictlahua. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ixlīcāna' tū iccāhuaniyān. Tī quinta'a'ka'ī'ni', nā xlaca'n natatlahua tū ictlahua quit. Ā'chulā' xalaka'tla' natatlahua ixpālacata quit na'iclaka'n quinTāta'. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Tū nasqui'nā'tit hui'xina'n na quintacuhuīni' quit na'ictlahua ixpālacata quit ī'Ska'ta' Dios. Chuntza' tzē na'iclīmāsu'yukō' chī ixlīka'tla' ixlītli'hui'qui quinTāta'. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Quit na'ictlahua pō'ktu tū nasqui'nā'tit na quintacuhuīni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jesús cāhuanipālh: ―Palh hui'xina'n quilāpāxquī'yāuj, cakexpa'ttit quilīmāpa'ksīn. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Quit na'icsqui'ni' quinTāta' ē xla' nacālakmacamimpalayān ā'chā'tin tī nacāmaktāyayān. Xla' ū'tza' nacātā'tahui'layān chī ixlīpō'ktu quilhtamacuj. Ū'tza' Espíritu Santo tī māsu'yu tū ixlīcāna'. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Xalanī'n nac cā'quilhtamacuj jāla catitamaktīni'lh Espíritu Santo ixpālacata xlaca'n jā catitalaktzī'lh ē jā catitalakapasli. Hui'xina'n lakapasā'tit ixpālacata xla' cātā'hui'lan. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Jā icticāmakxtekni' mina'cstuca'n. Na'iccālakmimpalayān. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Jātza' makās quintitalaktzī'lh xalanī'n nac cā'quilhtamacuj. Hui'xina'n naquilālaktzī'nāuj. Nalatahui'la'yā'tit ixpālacata quit iclahuī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","A'cxni' namin Espíritu Santo, hui'xina'n naca'tzīyā'tit quinTāta' quintā'huī'lh ē nā iccātā'hui'lan. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Tī taca'tzī quilīmāpa'ksīn ē tamākentaxtū, ū'tza' lītasu'yu quintapāxquī'. QuinTāta' nā nacāpāxquī' tī quintapāxquī'. Nā quit na'iccāpāxquī' ē na'iccātasu'yuni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas (ā'chā'tin Judas ē jā Iscariote) huanilh: ―Māpa'ksīni', ¿tū ixpālacata naquilātasu'yuni'yāuj quina'n ē jā ā'makapitzīn? ");
INSERT INTO tkuNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús kelhtīlh: ―Tī quintapāxquī', xlaca'n natakexmata tū iccāhuani. QuinTāta' nacāpāxquī'. QuinTāta' ē quit na'iccālakmināuj ē na'iccātā'tahui'layāuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Tī jā quintapāxquī' jā takexmata tū icuan. Quintachihuīn tū kexpa'tpā'na'ntit, xla' jā quila'; ixla' quinTāta' tī quimacaminī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Pō'ktu huā'mā' iccāhuani'kō'nī'ta'n līhuan iccātā'hui'lan. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","QuinTāta' namacamin Espíritu Santo ē xla' namāsu'yu quimpālacata. Ū'tza' nacāmaktāyayān ē nacāmāsu'yuni'kō'yān ē nacāmālacapāstaquīyān ixlīpō'ktu tū iccāhuaninī'ta'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Iccāmakxtekni'yān quintapāxuān. Iccāmaxquī'yān quintapāxuān ē jā chuntza' chī xalanī'n nac cā'quilhtamacuj. Jā catamakchuyī'tit ē jā cajicua'ntit. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Hui'xina'n kexpa'ttit chī iccāhuanin: “Quit ica'nā ē na'iccālakmimpalayān.” Palh ixlīcāna' ixquilāpāxquī'uj, ixlīpāxua'tit ixpālacata quit iclaka'mā'lh quinTāta'. Xla' ū'tza' ā'chulā' xaka'tla' ē jā quit. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Iccāhuanimā'n tū na'a'kspula. A'cxni' na'a'kspula huā'mā', hui'xina'n na'a'ka'ī'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Jātza' icticātā'chihuīna'n ixpālacata mimā'lhtza' tī māpa'ksīni'n cā'quilhtamacuj. Xla' jāla quintimāpa'ksīlh quit. ");
INSERT INTO tkuNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Quit ictlahua tū quihuani quinTāta'. Chuntza' xalanī'n nac cā'quilhtamacuj tzē nataca'tzī palh quit icpāxquī' quinTāta'. A'cxni' Jesús cāhuanikō'lh huā'mā', cāhuanipālh: ―Chuhua'j catāya'tit ē ca'a'uj ");
INSERT INTO tkuNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesús cāhuanipālh: ―Quit hua'chi xatze mayāc ē quinTāta' hua'chi xamaktaka'lhna'. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ixlīpō'ktu ixpekenī'n tū jā māstā' ixtahua'ca't, xla' cāpekesitmaka'n. Ixlīpō'ktu ixpekenī'n tū māstā' ixtahua'ca't, xla' nacāmaktaka'lha. Chuntza' ā'chulā' namāstā' ixtahua'ca't. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nā chuntza' Dios cāmāpānūni'nī'ta'n tū jā tze ixpālacata hui'xina'n a'ka'ī'nī'ta'ntit quintachihuīn. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Caquilātā'lātahui'lauj ē chuntza' quit na'iccātā'lātahui'layān. Kentin ixpeken xamayāc palh jā tzej chi'pāxna'n jā catimāstā'lh ixtahua'ca't ixa'cstu. Nā chuntza' nalītaxtuyā'tit hui'xina'n. Palh jā a'cxtim quilātā'hui'lanāuj, jāla catimāstā'tit mintahua'ca'tca'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Quit hua'chi xamayāc ē hui'xina'n hua'chi ixpekenī'n. Tī pō'ktu quintatā'lātahui'la, xlaca'n natamāstā' ixtahua'ca'tca'n. Hui'xina'n mina'cstuca'n jāla tū catitlahua'tit palh quit jā na'iccāmaktāyayān. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tī jā quintatā'lātahui'la nacālakmaka'ncan hua'chi ixpekenī'n tū cāpekesitmaka'ncanī't ē natascāca ē namākēxtimīcan ē nalhcuyucan. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Palh hui'xina'n lacxtim naquilātā'tahui'layāuj, ē palh jā napātza'nkāyā'tit quintachihuīn, casqui'ntit tū hui'xina'n lacasqui'nā'tit ē nacātamaxquī'yān. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Palh hui'xina'n māstā'yā'tit mintahua'ca'tca'n, chuntza' nalīmāka'tlī'yā'tit quinTāta'. Chuntza' lītasu'yu ixlīcāna' quiscujnu'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Quit iccāpāxquī'yān chuntza' chī quinTāta' quimpāxquī'. Hui'xina'n caquilāpāxquī'tēlhauj. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","QuinTāta' quimpāxquī' ixpālacata ickexmatni' ixtachihuīn. Nā hui'xina'n palh naquinkexpa'tni'yā'tit quintachihuīn, nā chuntza' na'iccāpāxquī'yān. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Quit iccāhuaninī'ta'n huā'mā' ixpālacata naka'lhī'yā'tit quintapāxuhuān. Chuntza' nalīka'lhī'yā'tit lhūhua' tapāxuhuān. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Quilīmāpa'ksīn ū'tza' huā'mā': calāpāxquī'tit hui'xina'n chuntza' chī quit iccāpāxquī'yān. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Palh huī'lh chā'tin tī līnīlh ixamigo, ixlīcāna' pāxquī'. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Hui'xina'n quinamigos palh natlahua'yā'tit tū iccālīmāpa'ksīyān. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Jātza' icticāmāpācuhuīn quintasācua'n ixpālacata tasācua' jā ca'tzī tū tlahuacu'tumā'lh ixtēcu'. Hui'xina'n iccāhuaniyān quinamigos ixpālacata quit iccāmāca'tzīnīyān pō'ktu tū quihuanī quinTāta'. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Jā hui'xina'n quilālacsacui. Quit iccālacsacnī'ta'n. Iccāmacamaxquī'yān napinā'tit ē namāstā'yā'tit mintahua'ca'tca'n tū natāyani' pō'ktu quilhtamacuj. Nā chuntza' quinTāta' nacāmaxquī'yān pō'ktu tū nasqui'ni'yā'tit na quintacuhuīni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ū'tza' huā'mā' iccālīmāpa'ksīyān: calāpāxquī'tit milīpō'ktuca'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jesús cāhuanipālh: ―Palh xalanī'n nac cā'quilhtamacuj cātaquiclhlaktzī'nān, jā natamakchuyī'yā'tit. Ca'tzīyā'tit nā quit xapūla quintaquiclhlaktzī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Palh cahuālh hui'xina'n xalanī'n nac cā'quilhtamacuj, ixcātapāxquī'n xalanī'n nac cā'quilhtamacuj, chī talāpāxquī' xlaca'n. Quit iccālacsacnī'ta'n ē chuntza' hui'xina'n jātza' xalanī'n nac cā'quilhtamacuj. Ū'tza' cātalīquiclhlaktzī'nān. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Calacapāstactit chī iccāhuanin hui'xina'n jā ā'chulā' xaka'tla' chī quit. Hui'xina'n hua'chi quintasācua'n ē quit hua'chi mintēcu'ca'n. Makapitzīn quintaputzastālani'nī't. Nā hui'xina'n chuntza' nacātaputzastālani'yān. Ā'makapitzīn takexmatnī't quintachihuīn, ē nā hui'xina'n nacātakexmatni'yān. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Pō'ktu huā'mā' nacātatlahuani'yān quimpālacata, ixpālacata xlaca'n jā talakapasa tī quimacaminī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Palh quit jā xa'icmilh iccāhuanī quintachihuīn, xlaca'n jā ixtitalē'lh cuenta. Chuhua'j jāla catitahualh palh jā talē'n cuenta, ixpālacata iccāhuaninī'ttza'. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Tī quintaquiclhlaktzī'n, nā chuntza' quinTāta' taquiclhlaktzī'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Xlaca'n jā tū ixtalē'lh cuenta, palh quit jā xa'ictlahualh na ixlacatīnca'n tū jāla tlahua ā'chā'tin. Masqui talaktzī'nī't huā'mā', quintaquiclhlaktzī'lh ē nā quinTāta' taquiclhlaktzī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Chuntza' nalīkentaxtu chī tatzo'kni' nac līmāpa'ksīn tū cāmaxquī'ca: Quintaquiclhlaktzī'lh ē jā tū ixpālacata. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Namin Maktāyana'. Ū'tza' Espíritu Santo tī nahuan tū ixlīcāna'. Xla' naminācha' jā hui'lacha' xaTāta'. Quit na'iccāmacamini'yāchā'n jā hui'lacha' quinTāta'. Namāsu'yu quimpālacata. ");
INSERT INTO tkuNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nā hui'xina'n nalīchihuīna'nā'tit ixpālacata ixquilātā'hui'lāna'uj a'cxni' iclītzuculh quintascujūt huā'tzā' nac cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Quit iccāhuanimā'n huā'mā' ē chuntza' jā titamakahuasā'tit a'cxni' napātīni'nā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Hui'xina'n nacātatamacxtuyān nac templos. Namin a'ktin quilhtamacuj tū nacātapūmaknīyān. Tī nacātamaknīyān, xlaca'n natapuhuan tatlahuamā'nalh tū ixtalacasqui'nīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Huā'mā' natatlahua ixpālacata jā makstin talakapasnī't quinTāta' ē nā quit jā quintalakapasnī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Iccāhuaniyān huā'mā' ē chuntza' a'cxni' nacātaputzastālani'yān, nalīlacapāstacā'tit chī iccāhuanin xapūla. Jesús cāhuanipālh: ―Quit jā iccāhuanin huā'mā' xapūla ixpālacata quit xa'iccātā'hui'lan. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Chuhua'j na'iclaka'mpala tī quimacaminī't. Hui'xina'n nūn tī tī quinkelhasqui'nīn: “¿Jā pimpā't?” ");
INSERT INTO tkuNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Chuhua'j hui'xina'n līlīpuhuanā'tit ixpālacata tū iccāhuanimā'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Quit iccāhuaniyān tū ixlīcāna'. Xatze mimpālacataca'n palh quit na'ica'n. Palh quit jā icti'a'lh, jā caticālakmin tī nacāmaktāyayān. Ē palh na'ica'n quit na'iccālakmacaminān tī nacāmaktāyayān. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Xla', a'cxni' namin, nacāmāca'tzīnī tachi'xcuhuī't chī talaclē'n chā'tunu' xlaca'n. Nacāmāca'tzīnī tū xatze na ixlacatīn Dios. Nacāmāca'tzīnī chī Dios nacāputzāna'nī. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nacāmāca'tzīnī xlaca'n talaclē'n ixpālacata jā quinta'a'ka'ī'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nacāmāca'tzīnī tū xatze, ixpālacata quit iclaka'mā'lh quinTāta' ē hui'xina'n jātza' quintilālaktzī'uj. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Nacāmāca'tzīnī chī Dios nacāputzāna'nī ixpālacata chuhua'j putzāna'nīcanī'ttza' tī māpa'ksī huā'mā' cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Lhūhua' sputa tū iccāhuanicu'tunān. Jāna'j la catikexpa'tkō'tit chuhua'j. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","A'cxni' namin Espíritu Santo, tī nahuan tū ixlīcāna', ū'tza' nacāmāsu'yuni'kō'yān pō'ktu. Xla' jā catichihuīna'nli xmān ixtalacapāstacni'. Xla' nacāhuaniyān xmān tū xaTāta' nahuanī. Nā nacāmāca'tzīnīyān hui'xina'n tū na'a'kspulana'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Xla' naquimāka'tlī' ixpālacata nacāmāca'tzīnīyān tū iclacasqui'n naca'tzīyā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Pō'ktu tū ka'lhī quinTāta' nā quila'. Ū'tza' iclīhualh Espíritu Santo nacāmāca'tzīnīyān hui'xina'n tū iclacasqui'n naca'tzīyā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jesús cāhuanipālh: ―Ā'macsti'na'j hui'xina'n jā quintilālaktzī'uj. Ā'macsti'na'j huampala naquilālaktzī'mpalayāuj ixpālacata quit iclaka'mā'lh quinTāta'. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Makapitzīn ī'scujnu'nī'n talākelhasqui'nīlh: ―¿Tū huanicu'tun huā'mā'? Xla' quincāhuaniyān ā'macsti'na'j jā catilaktzī'uj ē ā'macsti'na'j huampala nalaktzī'mpalayāuj, ixpālacata nalaka'n ixTāta'. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Tūchu huanicu'tun ā'macsti'na'j? Jā ca'tzīyāuj tū quincāhuanimā'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús ca'tzīlh tū ixtakelhasqui'nīcu'tun ē ū'tza' cālīhuanilh: ―Quit iccāhuanin ā'macsti'na'j jā quintilālaktzī'uj ē ā'macsti'na'j huampala naquilālaktzī'mpalayāuj. ¿Jā ū'tza' huā'mā' tū lākelhasqui'nī'pā'na'ntit? ");
INSERT INTO tkuNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ixlīcāna' tū iccāhuaniyān. Hui'xina'n nacalhua'nā'tit ē nalīpuhuanā'tit. Tachi'xcuhuī't natalīpāxuhua. Masqui pūla nalīpuhuanā'tit, ā'līstān līpāxūj natahui'la'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","A'cxni' chā'tin puscāt nacamala, xla' līpuhuan ixpālacata pātīni'n. A'cxni' lacatuncuhuī'nī'ttza' ī'ska'ta', xla' jātza' pāstaca chī pātīni'lh ixpālacata chilhtza' nac cā'quilhtamacuj chā'tin ska'ta'. Ū'tza' līpāxuhua. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nā chuntza' hui'xina'n chuhua'j līpuhuanā'tit. A'cxni' quit na'iccālakmimpalayān hui'xina'n napāxua'yā'tit. Nūn chā'tin caticāmaktīn huā'mā' tapāxuhuān. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’A'cxni' namin tzamā' quilhtamacuj, hui'xina'n jā tū quintilākelhasqui'nīuj. Ixlīcāna' tū iccāhuaniyān, quinTāta' nacāmaxquī'yān ixlīpō'ktu tū nasqui'ni'yā'tit na quintacuhuīni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Jāna'j tū squi'nī'ta'ntit na quintacuhuīni'. Casqui'ntit ē nacātamaxquī'yān. Ē ū'tza' nalīpāxua'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Jesús cāhuanipālh: ―Iccāhuaninī'ta'n huā'mā' tū līmāsu'yun. Namin quilhtamacuj a'cxni' jātza' icticātā'chihuīna'n chuntza'. Tzej na'iccātā'līchihuīna'nān quinTāta'. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Tzamā' quilhtamacuj hui'xina'n nasqui'ni'yā'tit quinTāta' na quintacuhuīni'. Jātza' ixlacasqui'nca quit na'icsqui'ni' quinTāta' mimpālacataca'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","QuinTāta' cāpāxquī'yān hui'xina'n ē ū'tza' nalīsqui'ni'yā'tit na quintacuhuīni'. Hui'xina'n quilāpāxquī'yāuj quit ē a'ka'ī'nī'ta'ntit quit icminī'ta'ncha' jā huī'lh Dios. Ū'tza' xla' cālīpāxquī'yān hui'xina'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Quit icmincha' na ixpāxtūn quinTāta' ē icmilh huā'tzā' nac cā'quilhtamacuj. Chuhua'j na'icmakxteka cā'quilhtamacuj ē na'iclaka'mpala quinTāta'. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ī'scujnu'nī'n tahuanilh: ―Chuhua'j tzej icca'tzīyāuj tū līchihuīna'mpā't ixpālacata jātza' chihuīna'mpā't tū līmāsu'yun. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Chuhua'j icca'tzīyāuj hui'x ca'tzīkō'ya' ixlīpō'ktu. Jātza' ixlacasqui'nca nakelhasqui'nīca'na'. Icca'tzīyāuj hui'x ta'nī'ta'nchi jā hui'lacha' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús cākelhtīlh: ―¿Chuhua'j a'ka'ī'yā'tittza'? ");
INSERT INTO tkuNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mimā'lhtza' quilhtamacuj, ē chuhua'j huā'mā' quilhtamacuj a'cxni' hui'xina'n nata'a'kahuani'yā'tit. Milīpō'ktuca'n hui'xina'n ē chā'tunu' napinā'tit na minchicca'n ē quit naquilāmakxtekāuj quina'cstu. Masqui quilāmakxtekui, jā quilīmān ictitahuī'lh ixpālacata quinTāta', xla' quintā'huī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Iccāhuaniyān huā'mā' ē chuntza' jā najicua'nā'tit ixpālacata hui'xina'n quilālīpāhuanāuj xmān quit. Līhuan hui'lā'na'ntitcus nac cā'quilhtamacuj, napātīni'nā'tit. Jā cajicua'ntit. Quit icskāhuī'lhtza' tī māpa'ksī cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","A'cxni' huankō'lh huā'mā', Jesús talacayāhualh nac a'kapūn ē huanli: ―Tāta', chilhtza' quilhtamacuj. Caquilakachi'xcuhui' quit, miSka'ta', ē nā chuntza' quit nā na'iclakachi'xcuhuī'yān. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Quimaxquī'nī'ta' līmāpa'ksīn na'iccāmāpa'ksī ixlīpō'ktuca'n tachi'xcuhuī't. Chuntza' quit tzē na'iccāmaxquī' xasāsti' ixlatamatca'n tū jā catilaksputli. Tzē na'iccāmaxquī' xasāsti' ixlatamatca'n tī quimacamaxquī'nī'ta'. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Xlaca'n talakapasān hui'x ē quintalakapasa quit, Jesucristo. Taca'tzī hui'x ixlīcāna' Dios ē hui'x quimacata'nī'ta'. Chuntza' tasu'yu xlaca'n taka'lhī xasāsti' ixlatamatca'n tū jā catilaksputli. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Quit iclakachi'xcuhuī'nī'ta'n huā'tzā' nac cā'quilhtamacuj. Ictlahuakō'lhtza' tū quimāpa'ksīnī'ta' na'ictlahua. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Chuhua'j Tāta', caquilakachi'xcuhui' na milacatīn chuntza' chī ixquilakachi'xcuhuī'ya' a'cxni' xa'ictā'hui'lachā'n hui'x a'cxni' jāna'j ixa'nan cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Xalanī'n nac cā'quilhtamacuj tī hui'x quimacamaxquī'nī'ta', xlaca'n iccāmāca'tzīnīnī'ttza' tī hui'x. Xlaca'n mila' ixtahuanī't ē hui'x quimacamaxquī'nī'ta' ē xlaca'n takexmatni'nī't milīmāpa'ksīn. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Chuhua'j xlaca'n taca'tzī milīmāpa'ksīn ū'tza' tū iclītlahua ixlīpō'ktu. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Quit iccāmāsu'yuni'nī't mintachihuīn tū quihua'ni'. Xlaca'n quinta'a'ka'ī'ni'lh. Chuhua'j taca'tzītza' ixlīcāna' icminī'ta'ncha' jā hui'la'chi hui'x. Ta'a'ka'ī'nī'ttza' hui'x quimacata'nī'ta'. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Quit icsqui'ni'yān ixpālacataca'n. Jā icsqui'ni'yān ixpālacataca'n xalanī'n nac cā'quilhtamacuj. Icsqui'ni'yān xmān ixpālacataca'n tī quimacamaxquī'nī'ta' ixpālacata xlaca'n pō'ktu mila'. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Pō'ktu tī quila' ē nā mila'. Pō'ktu tī mila' ē nā quila'. Quit quintalakachi'xcuhuī'nī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Chuhua'j quit na'iclakmimpalayān. Ē jātza' ictitachokolh nac cā'quilhtamacuj. Xlaca'n natatachoko nac cā'quilhtamacuj. Tāta' xatasicua'lanālani' hui'x, cacālīmaktāya' milītli'hui'qui xlaca'n tī quimacamaxquī'nī'ta' ē kēxtim catalalh, chī hui'x ē quit lacxtim. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","A'cxni' xa'iccātā'huī'lh ū'tunu'n, xa'iccālīmaktaka'lha milītli'hui'qui tī quimacamaxqui'. Xa'iccāmaktaka'lha xlaca'n. Chuntza' jā tī chā'tin tza'nkālh, xmān ū'tza' tī jā ixa'ka'ī'cu'tun ū'tza' tza'nkālh. Chuntza' mākentaxtūlh mintachihuīn chī tatzo'kni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Chuhua'j quit iclaka'mā'chā'n. Līhuan icuī'lhcus huā'tzā' nac cā'quilhtamacuj, quit icuan huā'mā' ē chuntza' xlaca'n natalīka'lhī tapāxuhuān chī quit. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Iccāmaxquī'nī't mintachihuīn. Ē xalanī'n nac cā'quilhtamacuj taquiclhlaktzī'n xlaca'n. Cāquiclhlaktzī'ncan quinchi'xcuhuī'n ixpālacata xlaca'n jātza' xalanī'n nac cā'quilhtamacuj, chuntza' chī quit jā xala' nac cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Jā icsqui'ni'yān nacāmāxtuya' nac cā'quilhtamacuj. Quit icsqui'ni'yān cacāmaktāya'. Chuntza' skāhuī'ni' jā nacā'a'kskāhuī'. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Xlaca'n jā xalanī'n nac cā'quilhtamacuj, chuntza' chī quit jā xala' nac cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Xalactze cacālīmāxtu mintachihuīn. Mintachihuīn ū'tza' tū ixlīcāna'. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Chuntza' chī quimacata'nī'ta' nac cā'quilhtamacuj, nā chuntza' xlaca'n nā quit na'iccāmacā'n nac cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ixpālacataca'n quit na'iclītamacamāstā' quina'cstu hua'chi a'ktin talakalhu'mān ē chuntza' ā'chulā' xlaca'n mila' natalītaxtu. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Icsqui'ni'mā'n ixpālacataca'n xlaca'n ē ixpālacataca'n ixlīpō'ktuca'n tī nā nata'a'ka'ī' ā'līstān ixpālacata ixtamāsu'yunca'n xlaca'n tī quila'. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Icsqui'ni'yān quina'n ē xlaca'n kēxtim nalayāuj, Tāta', chuntza' chī hui'x ē quit. Catalalh chī chā'tin ē chuntza' xalanī'n nac cā'quilhtamacuj nā nata'a'ka'ī' hui'x tī quimacata'nī'ta'. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Chī hui'x quilakachi'xcuhuī'nī'ta', nā chuntza' quit iccālakachi'xcuhuī'nī't xlaca'n ē chuntza' chā'tin natahuan chī quit ē hui'x chu chā'tin quina'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Quit iccātā'lahuī'lh xlaca'n chuntza' chī hui'x quintā'hui'la', ē xlaca'n natalītaxtu chu chā'tin. Chuntza' xalanī'n nac cā'quilhtamacuj tzē natalīca'tzī hui'x quimacata'nī'ta' ē hui'x nā cāpāxquī'ya' xlaca'n chī quimpāxquī'ya' quit. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’QuinTāta', hui'x quimacamaxquī'nī'ta' xlaca'n. Quit iclacasqui'n nā xlaca'n catachā'lh jā quit na'icchā'n, ē chuntza' xlaca'n natalaktzī'n chī quilakachi'xcuhuī'ya'. Hui'x quilakachi'xcuhuī'ya' ixpālacata ixquimpāxquī'ya' xapūla a'cxni' jāna'j ixa'nan cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tāta', hui'x xatze. Masqui jā talakapasān tachi'xcuhuī't xalanī'n nac cā'quilhtamacuj, quit iclakapasān. Quinchi'xcuhuī'n, xlaca'n taca'tzī hui'x quimacata'nī'ta'. ");
INSERT INTO tkuNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Quit iccāmāca'tzīnīnī'ttza' tī hui'x. Na'iccāmāca'tzīnīcus ē xlaca'n natapāxquī'nin chuntza' chī hui'x quimpāxquī'ya'. Nā xlaca'n pō'ktu quilhtamacuj na'iccātā'tahui'la. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesús a'cxni' tlahuakō'lh oración, cātā'taxtulh ī'scujnu'nī'n ē tatacutli nac Cedrón. A'ntza' ixuī'lh a'ktin pū'olivar. Jesús a'ntza' cātā'tanūlh ī'scujnu'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Nā Judas tī namacamāstā' Jesús, xla' ixlakapasna'n a'ntza' ixpālacata maklhūhua' Jesús ixcātā'takēstoknī't a'ntza' ī'scujnu'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","A'ntza' nac pū'olivar Judas cālē'lh soldados ē policías tī ixcāmacā'nī't xanapuxcu'nu' pālejni' ē fariseos. Ixtalē'nācha' ixespadaca'n ē ixpūmakskoca'n ē ixlamparaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesús ixca'tzīkō'tza' ixlīpō'ktu tū na'a'kspula ē cālaktalacatzuna'jīlh ē cākelhasqui'nīlh: ―¿Tī putzayā'tit? ");
INSERT INTO tkuNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Xlaca'n takelhtīlh: ―Jesús xala' nac Nazaret. Jesús cākelhtīlh: ―Quit Jesús tī putzayā'tit. A'ntza' ixcātā'yālh Judas tī namacamāstā' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","A'cxni' Jesús cāhuanilh: “Quit Jesús tī putzayā'tit”, xlaca'n chā'kēni'yaj tatamakahuasli ē ta'a'kā'lh nac ti'ya't. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesús cākelhasqui'nīpālh: ―¿Tī putzayā'tit? Xlaca'n tahuampālh: ―Jesús xala' nac Nazaret. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesús cāhuanilh: ―Iccāhuanintza' quit. Palh quit quilāputzayāuj, cacāmakxtektit cata'a'lh tzamā' makapitzīn. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Huanli huā'mā' ixpālacata namākentaxtū tū Jesús ixuanī't: “Jā tī chā'tin tza'nkālh tī quimacamaxquī'lh xaTāta'.” ");
INSERT INTO tkuNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simón Pedro ixlē'mā'lh ixmachīta, ē māxtulh ē a'kacā'yujulh ixa'ka'xko'lh na ixa'kacāna'j tī ixuanican Malco. Xla' ū'tza' ixtasācua' ixuanī't xapuxcu' pālej. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesús huanilh Pedro: ―Camānū'pala' mimachīta na mimpūmachīta. Quit iclīhui'līnī't na'icpātī tū ixtalacasqui'nīn quinTāta'. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tachi'palh Jesús soldados ē ixcomandanteca'n ē policías tī ixlaca'n israelitas. Macachī'ca. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Lē'nca pūla na ixchic Anás. Kōlu' Anás ixpuhuiti' ixuanī't Caifás tī xapuxcu' pālej tzamā' cā'ta. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Tzamā' Caifás ū'tza' tī ixcāhuaninī't israelitas ā'chulā' tze palh chā'tin chi'xcu' nalīnī ixpālacata ixlīpō'ktuca'n tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ixtastālani'tēlha Jesús Simón Pedro ē ā'chā'tin ī'scujni'. Tzamā' ī'scujni' xla' ixlakapasa xapuxcu' pālej. Ū'tza' lītā'tanūlh Jesús na ixtanquilhtīn ixchic xapuxcu' pālej. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedro tachokolh nac kēpūn, ixlacatzuna'j nac mākelhcha. Taxtulh tzamā' ī'scujni' tī ixlakapasa xapuxcu' pālej. Tā'chihuīna'nli tzu'ma'jāt tī ixmaktaka'lhmā'lh mākelhcha. Chuntza' tzamā' ī'scujni' tzē mānūlh Pedro nac tanquilhtīn. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tzu'ma'jāt tī ixmaktaka'lha mākelhcha, xla' kelhasqui'nīlh Pedro: ―¿Ē jā hui'x ī'scujni' huā'mā' chi'xcu'? Pedro kelhtīni'lh: ―Jā quit. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tasācua'n ē policías ixtahui'līnī't macscut ixpālacata ixlonknu'n. Ixtayāna'lh ē ixtasko'mā'nalh. Nā a'ntza' ixmaklayālh Pedro ixmaksko'mā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Anás tī xapuxcu' pālej, xla' līkelhasqui'nīlh Jesús ixpālacata ī'scujnu'nī'n ē ixtamāsu'yun. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús huanilh: ―Quit icchihuīna'nī't cā'lacan na ixlacatīnca'n tachi'xcuhuī't. Pō'ktu quilhtamacuj xa'icmāsu'yu quit nac templos ē nac xaka'tla' templo jā ixtatakēstoka israelitas. Jā tū icuanī't nac cā'tzē'k. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Tū ixpālacata quilīkelhasqui'nī'ya' quit? Cacākelhasqui'ni' tachi'xcuhuī't tī quintakexmatnī't. Ū'tunu'n catahualh tū iccāhuanilh. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","A'cxni' Jesús huanli huā'mā', chā'tin policía tī ixlayālh a'ntza', lacala'syāhualh ē huanilh: ―¿Ē chuntza' kelhtīcan tzamā' xapuxcu' pālej? ");
INSERT INTO tkuNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús kelhtīlh: ―Palh jā tze tū icuanli, cacāhua'ni' ixlīpō'ktuca'n huā'tzā' tū icuanli. Palh tze tū icuanli, ¿tū ixpālacata quilītucsa'? ");
INSERT INTO tkuNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anás lakmacā'lh Jesús xatachī'n Caifás tī xapuxcu' pālej. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simón Pedro ixyālh ī'sko'mā'lh. Huanica: ―¿Ē hui'x jā ī'scujni' huā'mā' chi'xcu'? Pedro kelhtatzē'kpālh ē huanli: ―Jā quit. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nā a'ntza' ixuī'lh chā'tin ixtasācua' xapuxcu' pālej. Xla' ixtalakapasni' ixuanī't tī a'kacā'yujulh Pedro. Tzamā' tasācua', xla' kelhasqui'nīlh Pedro: ―¿Ē jā hui'x ictā'laktzī'n Jesús nac pū'olivar? ");
INSERT INTO tkuNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro kelhtatzē'kpālh ē palaj tunca ta'salh lakatin puyux. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tzi'sajcus ixuanī't a'cxni' māxtuca Jesús na ixchic Caifás ē lē'nca na ixchic gobernador. Israelitas, xlaca'n jā tatanūlh nac chic. Palh ixtatanūlh, chuntza' jā tze ixtalītaxtulh na ixtahui'latca'n. Palh ixtatanūlh jāla ixtahua'lh līhua' ixla' cā'tani' tū huanican pascua. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ū'tza' lītaxtulh Pilato nacātā'chihuīna'n. Cāhuanilh: ―¿Tū ixpālacata līmālacsu'yuyā'tit huā'mā' chi'xcu'? ");
INSERT INTO tkuNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Xlaca'n takelhtīni'lh: ―Palh jā cahuālh xla' laclē'n, jā xa'icticāmacamaxquī'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato cāhuanilh: ―Calī'pintit hui'xina'n ē calacāxtlahua'tit chī ka'lhī'yā'tit milīmāpa'ksīnca'n hui'xina'n. Israelitas takelhtīlh: ―Quina'n israelitas jā icka'lhīyāuj līmāpa'ksīn na'icmaknīyāuj catīhuālh. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Chuntza' a'kspulalh ixpālacata namākentaxtū tū ixuanī't Jesús ixpālacata chī nalīnī. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato tanūpālh na ixpūchihuīn ē ta'sani'lh Jesús ē kelhasqui'nīlh: ―¿Ē hui'x ixpuxcu'ca'n israelitas? ");
INSERT INTO tkuNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús huanilh: ―¿Ē mintalacapāstacni' quilīkelhasqui'nī'ya' huā'mā' o talīchihuīna'nī'ta'n ā'makapitzīn quimpālacata? ");
INSERT INTO tkuNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato kelhtīlh: ―¿Ē quit israelita? Quintamacamaxquī'n hui'x mintā'israelitas ē xanapuxcu'nu' pālejni'. ¿Tūchu tlahua'nī'ta'? ");
INSERT INTO tkuNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesús kelhtīlh: ―Quit jā icmāpa'ksīni'n nac huā'mā' cā'quilhtamacuj. Palh chuntza' cahuālh, quinchi'xcuhuī'n ixquintamaktāyalh a'cxni' quintachi'palh israelitas. Jā icmāpa'ksīni'n huā'tzā'. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato kelhasqui'nīlh: ―¿Ē hui'x xapuxcu'? Jesús kelhtīlh: ―Ixlīcāna' tū huanī'ta'. Ū'tza' iclīlacatuncuhuī'lh ē ū'tza' iclīmilh nac cā'quilhtamacuj ixpālacata na'icuan tū ixlīcāna'. Ixlīpō'ktuca'n tī taca'tzīcu'tun tū ixlīcāna', xlaca'n quintakexmatni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato huanilh: ―¿Chī līca'tzīcan tū ixlīcāna'? A'cxni' Pilato ixuanī'ttza' huā'mā', xla' cālaktaxtupālh israelitas ē cāhuanilh: ―Quit jā icmaclani' nūn tū jā tze tū tlahuanī't huā'mā' chi'xcu'. ");
INSERT INTO tkuNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Hui'xina'n ka'lhī'yā'tit mintahui'latca'n cā'ta cā'ta quit icmakxteka chā'tin tachī'n a'cxni' lamā'lh cā'tani' tū huanican pascua. ¿Ē lacasqui'nā'tit na'iccāmakxtekni'yān ixPuxcu'ca'n israelitas? ");
INSERT INTO tkuNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ixlīpō'ktuca'n tata'sapālh ē tahuanli: ―¡Jā ū'tza'! ¡Camakxtekti Barrabás! Tzamā' Barrabás xla' ka'lhāna' ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilato māmaksno'knīni'lh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soldados tatlahualh a'ktin corona ixla' tzu'pīn ē tamaknūlh na ixa'kxāk Jesús ē tamālhakē'lh a'ktin ixlu'xu' xasmataka chī ixtalhakā'nan reyes. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ixtalaktalacatzuna'jī ē ixtahuanī: ―¡Tzehuanī't ixPuxcu'ca'n israelitas! Ixtalacala'syāhuamā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato cālaktaxtupālh tachi'xcuhuī't ē cāhuanilh: ―Calaktzī'ntit. Iccāmāxtuni'yān hui'xina'n. Ē naca'tzīyā'tit quit jā icmaclani' nūn a'ktin tū jā tze ixtatlauj. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Taxtulh Jesús. Ixa'knū a'ktin corona ixla' tzu'pīn. Ixmālhakē'canī't lu'xu' xasmataka. Pilato cāhuanilh: ―¡Huā'yālh tzamā' chi'xcu'! ");
INSERT INTO tkuNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","A'cxni' talaktzī'lh xanapuxcu'nu' pālejni' ē policías, xlaca'n tatzuculh tata'sa ē tahuanli: ―¡Caxtokohua'ca'ca! ¡Caxtokohua'ca'ca! Pilato cāhuanilh: ―Calīpintit ē caxtokohua'ca'tit hui'xina'n. Quit jā icmaclani' nūn a'ktin tū jā tze ixtatlauj. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Israelitas takelhtīlh: ―Quina'n icka'lhīyāuj a'ktin līmāpa'ksīn. Chuntza' chī huan nac līmāpa'ksīn, ixlacasqui'nca nanī huā'mā' chi'xcu' ixpālacata xla' huan ū'tza' ī'Ska'ta' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato, a'cxni' kexmatli huā'mā' tachihuīn, xla' ā'chulā' jicua'nli. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Tanūpālh na ixpūchihuīn ē kelhasqui'nīpālh Jesús: ―¿Jāchu xala' hui'x? Jesús jā kelhtīlh. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato huanilh: ―¿Chī jā quilīkelhtīya'? ¿Ē jā ca'tzīya' palh quit icka'lhī līmāpa'ksīn tzē na'icmakxtekān ē nā tzē na'icxtokohua'ca'yān? ");
INSERT INTO tkuNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesús kelhtīlh: ―Palh jā Dios ixmaxquī'n līmāpa'ksīn, hui'x jā ixtika'lhi' nūn a'ktin līmāpa'ksīn naquintlahua'ni'ya' catūhuālh. Chi'xcu' tī quimacamāstā'lh na milacatīn, xla' ā'chulā' ka'tla' ka'lhī ixcuenta ē jā hui'x. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","A'cxni' kexmatli huā'mā', Pilato ā'chulā' makxtekcu'tunli Jesús. Israelitas tata'salh ē tahuanilh: ―¡Palh hui'x namakxteka', hui'x jā ixamigo César, ixpuxcu'ca'n romanos! ¡Tī lītanūcu'tun ixlīpuxcu', xla' ū'tza' ixtā'lāquiclhlaktzi' César! ");
INSERT INTO tkuNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","A'cxni' kexmatli Pilato huā'mā', māmāxtunīni'lh Jesús. Tahuī'lh na ixpūmāpa'ksīn jā huanican Empedrado ē nā hebreo ixtacuhuīni' Gabata. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Xmān a'ktin quilhtamacuj ī'sputni' natzucu cā'tani' tū huanican pascua. Hua'chi i'tāt quilhtamacuj Pilato cāhuanilh israelitas: ―¡Huā'yālh mimPuxcu'ca'n! ");
INSERT INTO tkuNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Xlaca'n tata'salh ē tahuanli: ―¡Camaknīca! ¡Camaknīca! ¡Caxtokohua'ca'ca! Pilato cāhuanilh: ―¿Ē lacasqui'nā'tit naxtokohua'ca'can mimPuxcu'ca'n? Xanapuxcu'nu' pālejni' takelhtīni'lh: ―Quina'n icka'lhīyāuj xmān chā'tin quimpuxcu'ca'n. Ū'tza' César. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Palaj tunca Pilato cāmacamaxquī'lh xlaca'n naxtokohua'ca'can. Ē xlaca'n talē'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesús taxtulh ē ixcu'ca'lē'mā'lh ixcruz. Chā'lh jā huanican Calavera ē nā hebreo ixtacuhuīni' Gólgota. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","A'ntza' xtokohua'ca'ca ē nā cāxtokohua'ca'ca ā'chā'tu' na ixpāxtūtunī'n Jesús. Jesús pū'i'tāt ixua'ca'lh. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato māhui'līnīni'lh a'ktin letrero nac cruz tū ixuan: Jesus xala' nac Nazaret, ixPuxcu'ca'n israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","A'ntza' jā xtokohua'ca'ca Jesús ixlacatzuna'j nac cā'lacchicni' ē lhūhua' israelitas talaktzī'lh letrero. Tzamā' letrero kempātu'tun tachihuīn ixtzo'kcanī't: hebreo ē griego ē latín. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Xanapuxcu'nu' pālejni' tahuanilh Pilato: ―Jā ixtzo'kti “IxPuxcu'ca'n israelitas.” Chuhua'j catzo'kti: “Ū'tza' huanli: Quit ixPuxcu'ca'n israelitas.” ");
INSERT INTO tkuNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato cākelhtīlh: ―Ū'tza' tū ictzo'knī't, ū'tza' natahui'la. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","A'cxni' soldados ixtaxtokohua'ca'nī'ttza' Jesús, tasacli ixlu'xu' kelhatā'ti' soldados ē talātapitzīlh. Ixkelhni' lu'xu' xla' jā xatatza'pa' ixuanī't; chu a'ktin ixtacāxtlahuanī't chī ixa'cpūn ē chī ixquilhtūn. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Soldados talāhuanilh: ―Jā calacxtitui. Xatze calālīlaktzī'uj ē nalaktzī'nāuj tī napāxtoka. Chuntza' mākentaxtūlh ixtachihuīn Dios jā tatzo'kni': Tamālacpitzīlh quilu'xu' ē talālīlaktzī'lh chī napāxtoka. Chuntza' tatlahualh soldados. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ixlacatzuna'j cruz jā ixmāhua'ca'canī't Jesús, ixtayāna'lh ixtzī' Jesús ē xapuscāt ixtā'tin ixtzī' ē María ixpuscāt Cleofas, ē María Magdalena. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesús cālaktzī'lh ixtzī' ē ī'scujni' tī ixmakyālh. Tzamā' ī'scujni' ū'tza' tī tzej ixpāxquī'. Jesús huanilh ixtzī': ―Nā', ā'tzā' huī'lh minka'hua'cha. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ē huanilh ī'scujni': ―Ū'tza' huā'yā puscāt mintzī'. Tzamā' ī'scujni' mānūlh na ixchic. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesús ixca'tzītza' ixmākentaxtūkō'canī'ttza' ixlīpō'ktu. Chuntza' chī tatzo'kni' na ixtachihuīn Dios, xla' huanli: ―Ickelhpūtī. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","A'ntza' ixyālh a'ktin tla'ma'nc ixlītzuma xaxcān vinagre. Līmāchū'huī'ca esponja xaxcān vinagre. Cucchi'hui'lica a'ktin qui'hui' tū huanican hisopo ē līlakmacā'nca ē māhuī'ca. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesús hua'lh xaxcān vinagre. Palaj tunca huanli: ―Ixlīpō'ktu icmākentaxtūkō'nī'ttza'. Jesús māquilhpūtīlh ixa'kxāk ē ixa'cstu tamacamāstā'ni'lh Dios ē chuntza' nīlh. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Xmāntza' ā'a'ktin quilhtamacuj ī'sputa natzucutza' cā'tani' tū huanican pascua. Israelitas jā ixtalacasqui'n ixmacni'ca'n nīnī'n natatahua'ca' nac cruz quilhtamacuj tū pūjaxcan, ixpālacata tzamā' quilhtamacuj xla' ū'tza' ixlakachi'xcuhuī'can. Ū'tza' līsqui'ni'ca Pilato nacāmāchēkētu'cxnīni'n tī ixcāxtokohua'ca'canī't ē nacāmāyujūnīni'n ixmacni'ca'n nīnī'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Soldados ta'a'lh ē tachēkētu'cxli chā'tu' chi'xcuhuī'n tī ixcātā'xtokohua'ca'canī't Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","A'cxni' talaktalacatzuna'jīlh Jesús, talaktzī'lh ixnīnī'ttza'. Ū'tza' jā līchēkētu'cxca xla'. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Chā'tin soldado lītāpālhtuculh Jesús ixlanza ē palaj tunca taxtulh ka'lhni' ē xcān. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Quit Juan ē iclaktzī'lh huā'mā'. Tū icuan ū'tza' tū ixlīcāna'. Iccāhuaniyān huā'mā' ixpālacata chuntza' nā hui'xina'n na'a'ka'ī'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Huā'mā' a'kspulalh ixpālacata namākentaxtū ixtachihuīn Dios chī tatzo'kni': Jā catitu'cxni'ca nūn kentin ixlucut. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nā chuntza' tatzo'kni': Xlaca'n natalaktzī'n tī tāpālhtucucanī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","A'cxni' ixa'kspulanī't huā'mā', José xala' nac Arimatea squi'ni'lh Pilato namakxteka nalē'n ixmacni' Jesús. Huā'mā' José tī tatzē'kli ixa'ka'ī'ni' Jesús ixpālacata xla' ixcājicua'ni' israelitas. Pilato makxtekni'lh José ē xla' a'lh ē lē'lh ixmacni' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nā tā'a'lh Nicodemo tī pūla ixlakminī't cā'tzī'sa Jesús. Xla' līmilh mirra ē áloes. Chī pu'xamacāuj kilos līmilh Nicodemo. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Chuntza' José ē Nicodemo talē'lh ixmacni' Jesús ē talīpāsna'tli lu'xu' ē nā tatā'mānūlh mirra ē áloes tū ixtalīminī't. Chuntza' ixtahui'latca'n israelitas a'cxni' ixtamā'cnūnu'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","A'ntza' jā xtokohua'ca'ca Jesús, ixlacatzuna'j a'ktin pū'olivar ē a'ntza' ixuī'lh a'ktin lhu'cu' tū ixtlahuacanī't namā'cnūcan catīhuālh. A'ntza' jāna'j tī ixmā'cnūcanī't, nūn chā'tin. ");
INSERT INTO tkuNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Tzamā' lhu'cu' ixlacatzuna'j ixuī'lh ē a'ntza' mānūca ixmacni' Jesús ixpālacata ixtzucumā'lhtza' quilhtamacuj tū ixtapūjaxa israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ixlītzucuni' semana tzi'saj a'cxni' cā'pucsua'cus ixuanī't, María Magdalena a'lh nac lhu'cu' jā ixmānūcanī't Jesús. Xla' laktzī'lh jātza' ixuī'lh chihuix tū ixkelhui'līcanī't nac lhu'cu'. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tu'jnuntēlha cālaka'lh Simón Pedro ē ā'chā'tin ī'scujni' tī tzej ixpāxquī' Jesús. Ē cāhuanilh: ―Māxtucanī't nac lhu'cu' Māpa'ksīni' ē jā icca'tzīyāuj jā mā'cnūca. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pedro ē ā'chā'tin ī'scujni' tataxtulh ē ixta'a'mā'nalh nac lhu'cu'. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ixchā'tu'ca'n ixtatu'jnuntēlha lacxtim. Ā'līstān chā'tin ā'chulā' tu'jnulh. Pedro a'kapūlaca. Xapūla chā'lh nac lhu'cu' ā'chā'tin ī'scujni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Taquilhpūtalh ē talacanūlh ē laktzī'lh a'ntza' ixuī'lh lu'xu' tū ixlīpāsna'tcanī't Jesús. Tzamā' ī'scujni' jā tanūlh. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simón Pedro ī'stālatēlha. Ā'līstān xla' chā'lh ē tanūlh nac lhu'cu' ē a'ntza' laktzī'lh lu'xu' tū ixlīpāsna'tcanī't Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Nā laktzī'lh tū ixlītacucsna'tnī't. Xtum ixuī'lh tzamā' lu'xu'; ē ixpāsui'tui'līcanī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nā tanūlh ī'scujni' tī xapūla ixchinī't nac lhu'cu' ē laktzī'lh ē a'ka'ī'lh Jesús ixlacastālancuana'nī'ttza'. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Jāna'j ixtakexmatnī't ixtachihuīn Dios jā ixtatzo'kni' ixlacasqui'nca nalacastālancuana'n Jesús ā'maktin. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tzamā' scujnu'nī'n ta'a'mpālh na ixchicca'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","María tāyalh ixtanquilhtīn nac lhu'cu' jā ixmānūcanī't Jesús. Ixcalhuamā'lh. Līhuan ixcalhuayālh, taquilhpūtalh ē talacanūlh nac lhu'cu'. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Cālaktzī'lh chā'tu' ángeles ē lakstala'nka'n ixtaka'lhī ixlu'xu'ca'n. Xlaca'n ixtahui'lāna'lh jā ixmāpī'canī't ixmacni' Jesús. Chā'tin ixuī'lh na ixa'cpūn ē chā'tin nā ixuī'lh na ixtujan jā ixmāpī'canī't Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ángeles takelhasqui'nīlh: ―Puscāt, ¿tū ixpālacata calhua'na'? Xla' cāhuanilh: ―Lē'nca ixmacni' quiMāpa'ksīni'. Jā icca'tzī jā mānūcanī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","A'cxni' ixuanī'ttza' huā'mā', palaj tunca xla' talakspi'tli ē laktzī'lh Jesús a'ntza' ixyālh. Xla' jā ixlakapasa palh ū'tza' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesús huanilh: ―Puscāt, ¿tū ixpālacata calhua'na'? ¿Tī putzaya'? Tzamā' puscāt xla' ixlacpuhuan ū'tza' ixmaktaka'lhna' pū'olivar ē huanilh: ―Chi'xcu', palh hui'x lī'pi, caquihua'ni' jā lī'pi, ē chuntza' quit na'ica'n ictaya. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesús huanilh: ―¡María! Xla' talakspi'tpālh ē huanilh: ―¡Raboni! (Ū'tza' a'ktin tachihuīn hebreo tū huanicu'tun: Mākelhtahua'kē'ni'.) ");
INSERT INTO tkuNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús huanilh: ―Jā caquixa'ma' ixpālacata quit jāna'j ictā'kayāhua jā hui'lacha' quinTāta'. Capinchi ē cacāhua'ni' quintā'timīn quit na'ictā'kayāhua jā hui'lacha' quinTāta'. Ū'tza' nā minTāta'ca'n ē quinDios ē minDiosca'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Palaj tunca María Magdalena a'lh cāmāca'tzīnī ī'scujnu'nī'n xla' ixlaktzī'nī'ttza' Māpa'ksīni' ē cāhuanilh tū ixuaninī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","A'cxni' ixtzī'suamā'lhtza' ixlītzucuni' semana ī'scujnu'nī'n ixtatakēstokkō'nī't a'ktin nac chic. Lacchahuaj ixtatanūmā'nalh ixpālacata xlaca'n ixtajicua'ni' israelitas. Jesús tanūlh ē tāyalh na ixlacpu'na'i'tātca'n ē cāhuanilh: ―Tzej calatapā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","A'cxni' ixcāhuaninī'ttza' huā'mā', cāmāsu'yuni'lh ixmacan ē ixtāpān. Ī'scujnu'nī'n tapāxualh ixpālacata talaktzī'mpālh ixMāpa'ksīni'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesús cāhuanipālh: ―Tzej calatapā'tit. Chuntza' chī quimacamilh quinTāta' ē nā chuntza' hui'xina'n na'iccāmacā'nān. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","A'cxni' huankō'lh huā'mā', Jesús cāsu'nulh xlaca'n ē cāhuanilh: ―Chuhua'j, caquilāmaktīuj Espíritu Santo. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Palh hui'xina'n namātza'nkēna'ni'yā'tit ixcuenta ā'chā'tin, xla' jātza' laclē'n. Palh hui'xina'n jā catimātza'nkēna'ni'tit ixcuenta ā'chā'tin, xla' ū'tza' laclē'ncus. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Chā'tin ī'scujni' ixtacuhuīni' Tomás nā ixuanican Līstu'. Jā ixmakuī'lh xla' a'cxni' cātasu'yuni'lh Jesús ā'makapitzīn scujnu'nī'n. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Xlaca'n tahuanilh: ―Iclaktzī'ujtza' Māpa'ksīni'. Tomás cāhuanilh: ―Palh jā na'iclaktzī'n jā ixtakāhuī'nī't na ixmakxtampūn ē palh jā na'icxa'mani' jā ixtanūni'nī't clavos, ē palh jā na'icxa'ma ixtāpān jā ixtakāhuī'nī't, jā icti'a'ka'ī'lh palh lacastālancuana'nī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ixlītzeyama'j huampala ixtatakēstokpalanī't ī'scujnu'nī'n ē nā Tomás a'ntza' ixmakuī'lh. Masqui ixlacchahuayālh chic, Jesús tanūlh ē tāyalh na ixlacpu'i'tātca'n ē cāhuanilh: ―Tzej calatapā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Palaj tunca huanica Tomás: ―Camānu' mimacan na quimakxtampūn jā quimakxtampūlhu'cu'canī't ē cālaktzi' quimacan ē calī'ta' mimacan ē catamacnu' na quintāpān. Jātza' capuhua' palh jā ixlīcāna' iclacastālancuana'nī't. Ca'a'ka'i'. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomás kelhtīni'lh: ―¡QuiMāpa'ksīni' ē quinDios! ");
INSERT INTO tkuNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús huanilh: ―Tomás, chuhua'j hui'x a'ka'ī'ya' ixpālacata quilaktzī'nī'ta'. Līpāxuhua tī ta'a'ka'ī' ē masqui xlaca'n jā quintalaktzī'nī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesús tlahuapālh lhūhua' lī'a'cnīn na ixlacatīnca'n ī'scujnu'nī'n. Tzamā' lī'a'cnīn jā tatzo'kni' tzamā' nac libro. ");
INSERT INTO tkuNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Makapitzīn lī'a'cnīn tatzo'knī't ē chuntza' hui'xina'n tzē na'a'ka'ī'yā'tit Jesús xla' ū'tza' ī'Ska'ta' Dios tī Dios līhui'līlh ixlīmakapūtaxtūnu', ē hui'xina'n tzē naka'lhī'yā'tit xasāsti' milatamatca'n palh nalīpāhua'nā'tit Jesucristo. ");
INSERT INTO tkuNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ā'līstān Jesús cātasu'yuni'pālh ī'scujnu'nī'n na ixquilhtūn xcān tū ixuanican Galilea, ē nā ixuanican Tiberias. A'cxni' talacsu'yulh chuntza' lī'a'kspulalh: ");
INSERT INTO tkuNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","A'ntza' ixtahui'lāna'lh lacxtim Simón Pedro ē Tomás, tī ixuanican Līstu', ē Natanael xala' nac Caná, Galilea, ē ixka'hua'chan Zebedeo ē ā'chā'tu' ī'scujnu'nī'n Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedro cāhuanilh: ―Ica'nā icchi'pāna'n. Xlaca'n tahuanli: ―Nā quina'n na'iccātā'a'nān. Ta'a'lh ē tatojōlh nac barco. Jā tū tachi'palh ixlīpō'ktu tzamā' tzī'sni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","A'cxni' tzuculh xkaka, Jesús cātasu'yuni'lh ixquilhtūn nac xcān. Ē ī'scujnu'nī'n jā ixtalakapasa. ");
INSERT INTO tkuNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesús cāhuanilh: ―Chi'xcuhuī'n, ¿ē chi'patittza' squī'ti'? Xlaca'n takelhtīlh: ―Jā tū icchi'panī'tauj. ");
INSERT INTO tkuNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesús cāhuanilh: ―Camacapintit pūtayan na ixpekxtūcāna'j barco. A'ntza' nachi'payā'tit. Chuntza' tatlahualh xlaca'n. Palaj tunca jātza' la ixtamācutu ixpūtayanca'n ixpālacata lhūhua' squī'ti' ixtalaknūnī't. ");
INSERT INTO tkuNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ī'scujni' tī tzej ixpāxquī' Jesús, xla' huanilh Pedro: ―¡Ū'tza' Māpa'ksīni'! A'cxni' huanica huā'mā', Simón Pedro palaj tunca lhakā'lh ixlu'xu' tū ixtamakxtunī't ē palaj tunca tojōlh nac xcān ē laka'lh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Tzamā' barco lacatzuna'j ixquilhtūn nac xcān ixuī'lh hua'chi a'ktin ciento metros ixlīmakat. Makapitzīn ixtapūmimā'nalh barco ē ixtasakalīmimā'nalh ixpūtayanca'n tū ixpūtalaknūnī'ta'ncha' lhūhua' squī'ti'. ");
INSERT INTO tkuNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","A'cxni' tatacutchi xlaca'n talaktzī'lh pūlactin macscut ē ixa'ctzi'li'pūmā'ca lakatin squī'ti' ē pāntzīn. ");
INSERT INTO tkuNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús cāhuanilh: ―Calīta'ntit squī'ti' tū chi'patittza'. ");
INSERT INTO tkuNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simón Pedro palaj tunca tojōlh nac barco ē sakalīmilh pūtayan na ixquilhtūn nac xcān. Pūtayan ixpūtalaknūnī'ta'ncha' a'ktin ciento tu'pu'xamacāujtu'tun laka'tla' squī'ti'. Masqui lhūhua' squī'ti' ixtalaknūnī't, pūtayan jā taxtī'tli. ");
INSERT INTO tkuNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesús cāhuanilh: ―Cata'ntit, cahuā'ya'ntit. Nūn chā'tin ī'scujni' līhui'līlh nakelhasqui'nī tīchu, ixpālacata ixtaca'tzī palh ū'tza' Māpa'ksīni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesús quītayalh pāntzīn ē cāmaxquī'lh. Ē chuntza' tlahuapālh squī'ti'. ");
INSERT INTO tkuNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Tzamā' ixlīmaktu'tun cātasu'yuni'lh ī'scujnu'nī'n a'cxni' ixlacastālancuana'nkō'nī'ttza'. ");
INSERT INTO tkuNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","A'cxni' tahuā'yankō'lh, Jesús kelhasqui'nīlh Simón Pedro: ―Simón, ixka'hua'cha Jonás, ¿ē ā'chulā' quimpāxquī'ya' quit ē jā ā'makapitzīn? Pedro kelhtīlh: ―Jē, Māpa'ksīni'. Hui'x ca'tzīya' icpāxquī'yān. Jesús huanilh: ―Cacāmaktāya' tī quilacstīn. ");
INSERT INTO tkuNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kelhasqui'nīpālh ixlīmaktu': ―Simón, ixka'hua'cha Jonás, ¿ē quimpāxquī'ya'? Pedro kelhtīlh: ―Jē, Māpa'ksīni'. Hui'x ca'tzīya' icpāxquī'yān. Jesús huanilh: ―Cacāmaktaka'lhti tī quilacstīn. ");
INSERT INTO tkuNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ixlīmaktu'tun kelhasqui'nīpālh: ―Simón, ixka'hua'cha Jonás, ¿ē quimpāxquī'ya'? Pedro līlīpuhuanli ixpālacata xla' kelhasqui'nīca ixlīmaktu'tun palh ixpāxquī' Jesús. Huanilh: ―Māpa'ksīni' hui'x ca'tzīya' ixlīpō'ktu. Hui'x ca'tzīya' icpāxquī'yān. Jesús huanilh: ―Cacāmaktāya' tī quilacstīn. ");
INSERT INTO tkuNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Icuaniyān quit tū ixlīcāna'. A'cxni' ka'hua'chacus ixuanī'ta', hui'x ixlhakā'na'na' ē ixpina' jā ixpincu'tuna'. A'cxni' nakōlu'ya' hui'x, nalacstū'nca' mimpekenī'n ē ā'chā'tin natāpāchī'yān ē xla' nalē'nān jā jā pincu'tuna'. ");
INSERT INTO tkuNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Chuntza' Jesús ixlīhuanimā'lh Pedro chī xla' nalīnī ē chuntza' nalīlakachi'xcuhuī' Dios. Ā'līstān huanilh: ―Caquistāla'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedro talakspi'tli ē laktzī'lh chā'tin ī'scujni' ī'stālani'tēlha. Ū'tza' huā'mā' Jesús tzej ixpāxquī'. Nā huā'mā' ū'tza' tī ixpāxtūhuī'lh Jesús a'cxni' ixtahuā'yamā'nalh ē kelhasqui'nīlh: “Māpa'ksīni', ¿tīchu namacamāstā'yān?” ");
INSERT INTO tkuNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","A'cxni' laktzī'lh Pedro kelhasqui'nīlh Jesús: ―Māpa'ksīni', ē huā'mā' chi'xcu' ¿tū na'a'kspula? ");
INSERT INTO tkuNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús kelhtīlh: ―Palh quit na'iclacasqui'n xla' natahui'la hasta a'cxni' na'icmimpala ā'maktin, ¿ē mincuenta hui'x? Hui'x caquistāla'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ū'tza' ixtalīhuan tā'timīn tzamā' ī'scujni' jā catinīlh. Jesús jā huanli xla' jā catinīlh. Tū huanli xla' ū'tza': “Palh quit na'iclacasqui'n xla' natahui'la hasta a'cxni' na'icmimpala, ¿ē mincuenta hui'x?” ");
INSERT INTO tkuNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Huā'mā' ī'scujni' ū'tza' quit. Iclīmāsu'yunī't ē ictzo'knī't huā'mā' tachihuīn. Icca'tzīyāuj ixlīcāna' tū icuan. ");
INSERT INTO tkuNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","A'nampala lhūhua' catūhuālh tū tlahualh Jesús. Palh ixtzo'kui'līca cahuālh ixlīpō'ktu tū tlahualh xla', quit icpuhuan jāla ixlītahui'lakō'lh ixlīka'tla' cā'quilhtamacuj ixlīlhūhua' libros jā ixtzo'kui'līca. Amén.");
INSERT INTO tkuNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Icuaniyān, Teófilo, a'cxni' ictzo'kli pūla a'ktin ca'psnap, ictzo'kli ixlīpō'ktu tū Jesús lītzuculh tlahua ē māsu'yu. ");
INSERT INTO tkuNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Ictzo'kli tū tlahualh hasta a'cxni' a'lh nac a'kapūn. A'cxni' jāna'j ixa'n nac a'kapūn, Jesús cāmaxquī'lh a'ktin līmāpa'ksīn ixapóstoles tī ixcālacsacnī't. Cāmaxquī'lh līmāpa'ksīn ixpālacata Espíritu Santo chī tzē natascuja. ");
INSERT INTO tkuNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","A'cxni' Jesús ixpātīni'nī'ttza', xla' xalakahuan cātasu'yuni'lh ixapóstoles. Xla' tlahualh lhūhua' tū māsu'yulh ixlīcāna' xalakahuan ixuanī't Jesús. Cātasu'yuni'lh hasta jā chā'lh tu'pu'xam quilhtamacuj. Ixcālītā'chihuīna'mā'lh chī māpa'ksīni'n Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","A'cxni' ixcātā'takēstoknī't Jesús cāhuanilh: ―Jāna'j cataxtutit nac Jerusalén. Caka'lhī'tit tū nacāmaxquī'yān quinTāta'. Huā'mā' quit iccāhuaninī'ta'ntza' hui'xina'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ixlīcāna', Juan ixlīmā'kpaxīni'n xcān. Xtum chī nalī'a'kpaxā'tit. Hui'xina'n nacātamaxquī'yān Espíritu Santo. Palaj nacātamaxquī'yān ―cāhuanilh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Tī ixtatakēstoknī't takelhasqui'nīlh: ―Māpa'ksīni', ¿ē chuhua'j nahui'lī'ya' a'ktin līmāpa'ksīn nac Israel? ");
INSERT INTO tkuNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesús cāhuanilh: ―Hui'xina'n jāla catica'tzītit tzamā' quilhtamacuj a'cxni' nala huā'mā'. Xmān Dios ca'tzī a'cxni' namacamin huā'mā' tū nala. Ū'tza' tī māpa'ksīni'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Hui'xina'n namaktīni'nā'tit lītli'hui'qui a'cxni' Espíritu Santo nacālakminān. Hui'xina'n nachihuīna'nā'tit quimpālacata nac Jerusalén ē na ixlīpō'ktu Judea ē Samaria ē ixlīpō'ktu cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","A'cxni' Jesús cāhuanikō'lh huā'mā' xla' palaj tunca tzuculh tā'kayāhua na ixlacatīnca'n. Tanūlh nac a'ktin poklhnu' tū lītatzē'kli. ");
INSERT INTO tkuNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Xlaca'n ixtatalacayāhuayāna'lh a'cxni' Jesús ixa'mā'lh tālhmā'n. Xamaktin tatāyachi chā'tu' chi'xcuhuī'n ixlacatzuna'jca'n. Ixtaka'lhī ixlu'xu'ca'n xastala'nka'. ");
INSERT INTO tkuNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Xlaca'n tachihuīna'nli: ―Hui'xina'n chi'xcuhuī'n xalanī'n nac Galilea, ¿tū ixpālacata talacayāhuapāna'ntit nac a'kapūn? Ū'tza' huā'mā' Jesús, tī tā'kayāhuamā'lh nac a'kapūn na milacatīnca'n, chuntza' nataspi'tpala ā'maktin ―cāhuanica. ");
INSERT INTO tkuNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Apóstoles tayujchi nac sipej jā huanican Olivos. Huā'mā' sipej ixlacatzuna'j nac Jerusalén ixlīmakat a'cxtim chī tzē natlā'huancan a'ktin quilhtamacuj tū pūjaxcan chuntza' chī tatzo'kni' nac līmāpa'ksīn. Xlaca'n tataspi'tpālh nac Jerusalén. ");
INSERT INTO tkuNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","A'cxni' tachā'lh xlaca'n tatahua'ca'lh tālhmā'n. A'ntza' ixtahui'lāna'ncha' Pedro ē Jacobo ē Juan ē Andrés ē Felipe ē Tomás ē Bartolomé ē Mateo ē Jacobo ixka'hua'cha Alfeo ē Simón Zelote ē Judas ixtā'tin Jacobo. ");
INSERT INTO tkuNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ixlīpō'ktuca'n lacxtim ixta'orarlamā'nalh. Nā puscan ixta'orarlamā'nalh ē María tī ixtzī' Jesús ē nā ixtā'timīn Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tī ixtahui'lāna'lh a'ktin ciento ē ā'kelhapu'xam. Huā'mā' quilhtamacuj Pedro tāyalh ixlacpu'na'nca'n tā'timīn. Cāhuanilh: ");
INSERT INTO tkuNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Tā'timīn, chuntza' ixlacasqui'nca na'a'kspula tū huan ixtachihuīn Dios jā David līhuanli pūla ixlītli'hui'qui Espíritu Santo. David līchihuīna'nli Judas. Ū'tza' huā'mā' Judas tī cāpūlani'lh xlaca'n tī tachi'palh Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ū'tza' huā'mā' Judas tī ixquincātā'latlā'huanān. Nā ū'tza' ixtā'scuja Dios chuntza' chī quina'n tā'scujāuj Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Huā'mā' tumīn tū tlajalh ixpālacata tū tlahualh tū jā tze lītamāhuaca ti'ya't. Judas tālhmā'n mincha' ē taxtuni'kō'lh ixpālūhua'. ");
INSERT INTO tkuNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ixlīpō'ktuca'n xalanī'n nac Jerusalén taca'tzīkō'lh huā'mā'. Ū'tza' līmāpācuhuīca ti'ya't Acéldama. Nā ixtachihuīnca'n Acéldama huanicu'tun ti'ya't ixtapalh ka'lhni'. ");
INSERT INTO tkuNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Chuntza' tatzo'kni' na ixtachihuīn Dios nac libro ixtacuhuīni' Salmos: Calakmaka'nca ixchic. A'ntza' jā tī chā'tin catitahui'lalh. Nā tatzo'kni' chuntza': Ā'chā'tin catahui'lapālh na ixtascujūt. ");
INSERT INTO tkuNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Pedro chihuīna'mpālh: ―Catanūlh chā'tin ixlakxoko Judas tī ixquincātā'latlā'huanān a'cxni' Jesús ixquincātā'latlā'huanān. ");
INSERT INTO tkuNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Catahuī'lh chā'tin tī ixquincātā'latlā'huanān a'cxni' Juan mā'kpaxīlh Jesús hasta a'cxni' Jesús a'lh nac a'kapūn. Ū'tza' nala hua'chi quina'n ē nalīchihuīna'n chī Jesús lacastālancuana'nli. ");
INSERT INTO tkuNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Cālacsacca chā'tu' chi'xcuhuī'n. Ixtacuīni' chā'tin José tī ixuanican Barsabás ē Justo. Ē ā'chā'tin huampala ixtacuhuīni' Matías. ");
INSERT INTO tkuNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ē tatlahualh oración ē tahuanli chuntza': ―QuinDiosca'n, hui'x cālakapasni'ya' ixlīstacna'ca'n ixlīpō'ktuca'n chi'xcuhuī'n. Hui'x caquilāmāsu'yuni'uj tī hui'x lacsacnī'ta' huā'mā' chā'tu'. ");
INSERT INTO tkuNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Ū'tza' natā'scujān chī apóstol. Natahui'la ixlakxoko Judas tī makxtekli ixtascujūt ē tlahualh tū jā tze. Ū'tza' lī'a'lh nac pūpātīn. ");
INSERT INTO tkuNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tlahuaca a'ktin talacsacni' tī napāxtoka. A'cxni' laktzī'nca ū'tza' Matías pāxtokli. Ē ū'tza' līchi'palh tzamā' tascujūt. Ū'tza' lacchā'lh ixlīkelhacāujtu' apóstoles. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","A'cxni' chilh ixquilhtamacuj Pentecostés, ixlīpō'ktuca'n ixtatakēstokkō'nī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Xamaktin macasā'nalh tū ixmimā'cha' nac a'kapūn. Kexmatca hua'chi palha' ū'ni' ixmimā'lh pō'ktu nac chic jā ixtahui'lāna'lh. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Cātasu'yuni'lh hua'chi sī'ma'kā't tū tasu'yulh hua'chi macscut. Cālakchā'lh chā'tunu' xlaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ixlīstacna'ca'n talītatzumakō'lh Espíritu Santo. Tatzuculh tachihuīna'n a'katunu' tachihuīn tū cāmaxquī'lh Espíritu Santo natachihuīna'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ixtahui'lāna'lh nac Jerusalén israelitas, chi'xcuhuī'n tī ixtalakachi'xcuhuī' Dios. Xlaca'n ixtaminkō'nī't xala' calhāxcuhuālh. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","A'cxni' takexmatli tū macasā'nanli, tatakēstokkō'lh ixlīpō'ktuca'n. Jā ixtaca'tzī chā'tunu' chī ixtakexmatmā'nalh chī ixtachihuīnca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ixtalītamakchuyīmā'nalh ē talāhuanilh: ―Hua'chi jā xala' nac Galilea tī tachihuīna'mā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Chī kexmatāuj huā'mā' tachihuīn tū chihuīna'nāuj līchā'tunu' quina'n? ");
INSERT INTO tkuNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Makapitzīn quina'n xala' nac Partia ē Media ē Elam ē Mesopotamia ē Judea ē Capadocia ē Ponto ē Asia. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ā'makapitzīn quina'n xala' nac Frigia ē Panfilia ē Egipto ē xala' nac África ā'chulā' pekanācha' Cirene. Ā'makapitzīn xala' nac Roma tī taminī'ta'ncha' nac Jerusalén. Makapitzīn xlaca'n talīlacastacni' israelitas ē ā'makapitzīn tamaktanūkō'lh na ixtamāsu'yunca'n israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ā'makapitzīn quina'n xala' nac Creta ē Arabia. Quina'n cākexmatni'yāuj tzamā' chi'xcuhuī'n, xala' nac Galilea, chī tachihuīna'mā'nalh tū quintachihuīnca'n. Quincātalīchihuīna'mā'n tū lītlahuamā'lh Dios ixlītli'hui'qui ―talāhuanilh. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ixlīpō'ktuca'n talī'a'cnīkō'lh ē jā ixtaca'tzī chī līlamā'lh. Talākelhasqui'nīlh: ―¿Tū huanicu'tun huā'mā'? ");
INSERT INTO tkuNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Makapitzīn ixtalīkelhkamāna'mā'nalh ē ixtaquilhuamā'nalh: ―Huā'mā' chi'xcuhuī'n taka'chī. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pedro tāyalh ē ā'makapitzīn apóstoles ē palha' chihuīna'lh: ―Iccāhuaniyān chi'xcuhuī'n israelitas ē milīpō'ktuca'n hui'xina'n tī hui'lā'na'ntit nac Jerusalén. Caca'tzītit hui'xina'n huā'mā' ē cakexpa'ttit quintachihuīn. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Tzamā' chi'xcuhuī'n jā taka'chī chī puhua'nā'tit hui'xina'n. Jā taka'chī ixpālacata xmān makna'jāstza' tzi'saj. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Huā'mā', tū hui'xina'n laktzī'mpā'na'ntit ē kexpa'tpā'na'ntit, ū'tza' līchihuīna'nli profeta Joel makāstza'. Joel huanli: ");
INSERT INTO tkuNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Chuntza' Dios huanli: A'cxni' ā'xmān quilhtamacuj na'iccāmacamini' quinEspíritu ixlīpō'ktuca'n tachi'xcuhuī't. Minka'hua'chanca'n ē mintzu'ma'janca'n natalīchihuīna'n quintachihuīn. Minka'hua'chanca'n natalakachuya ē lakkōlu'n natalakahuāna'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ixlīcāna' na'iccāmacamini' xlaca'n quinEspíritu huā'mā' quilhtamacuj tī quintatā'scuja, chi'xcuhuī'n ē puscan. Xlaca'n natalīchihuīna'n quintachihuīn. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Na'icmāsu'yu lī'a'cnīn tālhmā'n nac a'kapūn ē natasu'yu tū talī'a'cnīn chi'xcuhuī'n nac cā'ti'ya'tna'. Natatasu'yu ka'lhni' ē lamana' ē mixini' tū hua'chi jini'. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Chi'chini' jā naxkaka ē mālhcuyu' natasu'yu chī ka'lhni'. Ā'līstān namin ixquilhtamacuj Māpa'ksīni' Jesucristo a'cxni' namimpala. Nala a'ktin quilhtamacuj xaka'tla'. Nalaktzī'ncan tū na'a'nan. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nala chuntza': Catīxcuhuālh tī nata'sani' Māpa'ksīni' namaktāya, ū'tza' na'a'kapūtaxtu. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pedro chihuīna'mpālh: ―Chi'xcuhuī'n israelitas, cakexpa'ttit huā'mā' tachihuīn. Dios cāmāsu'yuni'n hui'xina'n ū'tza' macamilh Jesús xala' nac Nazaret. Cāmāsu'yuni'n huā'mā' ixpālacata lī'a'cnīn tū lītlahualh Jesús ixlītli'hui'qui Dios na milacatīnca'n. Huā'mā' hui'xina'n ca'tzīyā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","A'cxni' macamāstā'ca Jesús, ē hui'xina'n hua'ntit caxtokohua'ca'ca ē camāmaknīnīca. Tī tamaknīlh Jesús, xlaca'n jā tzeya chi'xcuhuī'n. Huā'mā' kentaxtūlh chuntza' chī ixtalacasqui'nīn Dios tū jāla talakpalī ē chuntza' chī ixca'tzī Dios makāstza'. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Dios mālacastālancuanīlh Jesús ē līmāxtulh ixlītli'hui'qui līnīn ixpālacata Jesús jāla tamakxteka nac cā'līnīn. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","David līchihuīna'nli Jesús ē huanli: Pō'ktu quilhtamacuj xa'iclaktzī'n Māpa'ksīni' na quilacatīn. Huī'lh na quimpekxtūcāna'j. Chuntza' jā ictitamakchuyīlh. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ū'tza' līpāxuhualh quilīstacna' ē icchihuīna'nli catūhuālh tū līpāxuhualh ixpālacata jā catimakxtekca quimacni'. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Hui'x jā catimakxtekti quilīstacna' nac cā'līnīn, ē jā catimakxtekti namasa quimacni'. Quit miSka'ta' xatasicua'lanālani'. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Quimāsu'yuni'nī'ta' chī na'iclīlatā'kchoko. Na'icka'lhī tapāxuhuān na milacatīn. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pedro chihuīna'mpālh: ―Chi'xcuhuī'n, israelitas chī quit, na'iccāhuaniyān tū ixlīcāna' ixpālacata quimpapca'n David tī ixpuxcu'ca'n israelitas ixuanī't. Xla' nīlh ē mā'cnūca. Huī'lhcus jā mā'cnūca. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Xla' ixa'kchihuīna' Dios ixuanī't. Ixca'tzī chī Dios ixuanī't ixlīcāna' nahui'lī chī ixlīpuxcu' tī ī'xū'nātā'nat David. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David ixca'tzī Cristo nalacastālancuana'n ē jā catitahui'lacha' nac cā'līnīn ē jā catimasli ixmacni' Cristo. Ū'tza' chuntza' lītzo'knulh David. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Dios mālacastālancuanīnī't huā'mā' Jesús. Quilīpō'ktuca'n iclaktzī'nī'ta'uj huā'mā'. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Dios līmāhua'ca'lh Jesús ē līhui'līlh na ixpekxtūcāna'j. XaTāta' Dios maxquī'lh Jesús Espíritu Santo chuntza' chī huanli pūla. Nā Jesús macamilh Espíritu Santo huā'tzā'. Huā'mā' ū'tza' tū hui'xina'n laktzī'mpā'na'ntit ē kexpa'tpā'na'ntit chuhua'j. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","David jā a'lh nac a'kapūn. Xla' huanli: Māpa'ksīni' Dios huanilh quiMāpa'ksīni': “Catahui'la'na quimpekxtūcāna'j ");
INSERT INTO tkuNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hasta a'cxni' quit na'iccāskāhuī' mintā'lāquiclhlaktzi'.” ");
INSERT INTO tkuNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Pedro chihuīna'mpālh: ―Cataca'tzīkō'lh ixlīpō'ktuca'n xalanī'n nac Israel huā'mā': Dios hui'līlh Jesús ixlīMāpa'ksīni' ē ixlīCristo. Ū'tza' huā'mā' Jesús tī hui'xina'n māxtokohua'ca'nīni'ntit. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","A'cxni' takexmatli huā'mā', tatamakchuyīlh. Kelhasqui'nīca Pedro ē ā'makapitzīn apóstoles: ―Chi'xcuhuī'n, ¿tū na'ictlahuayāuj? ");
INSERT INTO tkuNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedro cāhuanilh: ―Calakpalī'tit mintalacapāstacni'ca'n ē ca'a'kpaxtit milīpō'ktuca'n hui'xina'n na ixtacuhuīni' Jesucristo. Chuntza' nacātamātza'nkēna'ni'yān mincuentaca'n ē Dios nacāmaxquī'yān Espíritu Santo. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ū'tza' tū Dios huanī't namāstā'. Huā'mā' tzē namaktīni'nā'tit hui'xina'n. Nā tzē natamaktīni'n nā mincamana'ca'n ē nā ixlīpō'ktuca'n tachi'xcuhuī't xalanī'n ā'lacatunu' cā'lacchicni' ē ixlīpō'ktu tī nacāta'sani' Māpa'ksīni' quinDiosca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pedro cāhuanilh ē cāmaxquī'lh talacapāstacni' ē huanli: ―Ca'a'kapūtaxtutit ē chuntza' jā tila'yā'tit chī huā'mā' tachi'xcuhuī't jā tze tī tahui'lāna'lh chuhua'j ―cāhuanica. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tī ta'a'ka'ī'ni'lh ixtachihuīn Pedro, xlaca'n ta'a'kpaxli. Tī ta'a'ka'ī'lhcus huā'mā' quilhtamacuj a'ktu'tun mil tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Xlaca'n jā ixtamakxteka ixtamāsu'yunca'n apóstoles. Jā ixtamakxteka chī ixtatakēstoka ē chī ixtamālacpitzī pāntzīn ē chī ixta'orarla. Ixtaka'lhī a'ktin ixtalacapāstacni'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ixlīpō'ktuca'n ixtajicua'n. Apóstoles tatlahualh lhūhua' laka'tla' lī'a'cnīn tū talīmāsu'yulh ixlītli'hui'qui Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ixlīpō'ktuca'n tī ixta'a'ka'ī', ixtahui'lāna'lh kēxtim ē a'ktin ixtamālacpitzī ixlīpō'ktu tū ixtaka'lhī. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Tastā'lh ixti'ya'tca'n ē tū ixtaka'lhī ē ixtalāmāpitzīni' tumīn ixlīpō'ktuca'n chā'tunu' chī ixtamaclacasqui'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Lakalīyān ixtatakēstoka xaka'tla' nac templo. Ixtamāpitzi pāntzīn na ixchicca'n ē cā'tapāxuhuān ixtahuā'yan. Ixtapāxuhua ixlīstacna'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ixtamakapāxuī Dios. Ixcālaktzī'ncan tzeya chi'xcuhuī'n. Māpa'ksīni' Dios ixmālhūhuī'pala lakalīyān. Lakalī lakalī ixtalhūhua'ntēlha tī ixta'a'kapūtaxtu. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","A'ktin quilhtamacuj Pedro ē Juan lacxtim ixtatahua'ca'mā'nalh xaka'tla' nac templo. Ixlacchā'ni' hora tū ixpūtlahuacan oración, chī maktu'tun hora kōtanū. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Lakalī lakalī ixtahui'la a'ntza' chā'tin chi'xcu' lū'ntu' chu tunca ixlīlacatuncuhuī'nī't. Lakalī lakalī ixui'līcan na ixtanquilhtīn nac templo xalacatzuna'j nac xamākelhcha jā ixuanican Tzēhuanī't. A'ntza' ī'squi'n tumīn tū ixlīhuā'yan. Ixcāsqui'ni' tī ixtatanū nac templo. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","A'cxni' lū'ntu' cālaktzī'lh Pedro ē Juan ixtatanūmā'nalh nac templo ē xla' cāsqui'ni'lh tumīn. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pedro ē Juan talakalaktzī'lh ē Pedro huanilh: ―Caquilālakalaktzī'uj. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Xla' cālakalaktzī'lh ē xla' puhuanli huī'lh tū namaxquī'can. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pedro huanilh: ―Jā tū icka'lhī plata ē nūn oro. Na'icmaxquī'yān tū icka'lhī. Na ixtacuhuīni' Jesucristo xala' nac Nazaret, catāya' ē catlā'hua'nti. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Macachi'palh ixpekcāna'j ē yāhualh. Palaj tunca ixtujan ē ixtūpixni' tatli'hui'clhli. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Palaj tunca tāyalh ē tlā'huanli ē cātā'tanūlh Pedro ē Juan nac templo. Ixtlā'huantēlha tanūlh ē ixtachāyāhuatēlha ē ixmakapāxuīmā'lh Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ixlīpō'ktuca'n tachi'xcuhuī't talaktzī'lh chī ixlatlā'huan ē ixmakapāxuīmā'lh Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Talakapasli ū'tza' tī ī'squi'ntahui'la tumīn na ixtanquilhtīn xaka'tla' templo, xalacatzuna'j jā huanican xamākelhcha Tzēhuanī't. Talī'a'cnīlh tū ixa'kspulanī't. Jā ixtaca'tzī. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tzamā' lū'ntu' tī ixtzeyanī'tcus, ixcātā'lāmacachi'patlā'huan Pedro ē Juan. Ixlīpō'ktu tachi'xcuhuī't tu'jnun ta'a'lh ē cālaktastokca nac tanquilhtīn jā huanican ixtanquilhtīn Salomón ē talī'a'cnīlh. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pedro, a'cxni' laktzī'lh huā'mā', cāhuanilh tachi'xcuhuī't: ―Chi'xcuhuī'n israelitas, ¿tū ixpālacata lī'a'cnī'yā'tit huā'mā'? ¿Tū ixpālacata quilālakalaktzī'nāuj? Jā quilītli'hui'quica'n tū iclīmātzeyīnī'ta'uj ē jā ixpālacata quina'n tzeya chi'xcuhuī'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Tlahualh huā'mā' ixDiosca'n Abraham ē Isaac ē Jacob ē quinatāta'na'ca'n. Ū'tza' Dios māsu'yunī't ka'lhī līmāpa'ksīn Jesús tī ī'Ska'ta' Dios. Huā'mā' Jesús ū'tza' tī macamāstā'tit hui'xina'n ē kelhtatzē'ktit na ixlacatīn Pilato. Pilato ixmakxtekcu'tun ē hui'xina'n jā lacasqui'ntit. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Hui'xina'n kelhtatzē'ktit tī tze ē tlahuanī't xmān tū tze. Hui'xina'n hua'ntit camakxtekca chā'tin maknīni'. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Māmaknīnīni'ntit Jesús tī māstā' latamat ē tī Dios mālacastālancuanīlh. Huā'mā' quina'n icmāsu'yuyāuj chī lacastālancuana'nli. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ica'ka'ī'ni'yāuj Jesucristo. Ū'tza' līmātzeyīca huā'mā' chi'xcu' tī hui'xina'n laktzī'nā'tit ē lakapasā'tit. Jesús quincāmā'a'ka'ī'nīn. Ū'tza' līmātzeyīca na milacatīnca'n milīpō'ktuca'n hui'xina'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Chuhua'j chi'xcuhuī'n, quit icca'tzī hui'xina'n jā ixca'tzīyā'tit tū tlahua'tit a'cxni' māmaknīnīni'ntit Jesús. Nā jā ixtaca'tzī mimāpa'ksīni'nī'nca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Dios māca'tzīnīni'lh xapūla Cristo napātīni'n. Chuntza' tahuanli ixa'kchihuīna'nī'n Dios xala' makāstza'. Huā'mā' mākentaxtūlh Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Chuhua'j hui'xina'n calakpalī'tit mintalacapāstacni'ca'n ē calakpalī'tit milīstacna'ca'n ē chuntza' naxapacan mincuentaca'n. Chuntza' namin quilhtamacuj a'cxni' Dios nacāsicua'lanātlahuani'yān milīstacna'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Namacamin Jesucristo tī xapūla līhui'līlh Dios nacāmacamini'yān hui'xina'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jesucristo natahui'la nac a'kapūn hasta a'cxni' Dios nacāxtlahuapalakō' ixlīpō'ktu chī Dios makāstza' cāmāchihuīnīlh ixa'kchihuīna'nī'n tī lactze. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisés cāhuanilh quinapapana'ca'n: Māpa'ksīni' quinDiosca'n nacāmacamini'yān hui'xina'n chā'tin a'kchihuīna', chuntza' chī quimacamilh quit. Dios nalacsaca chā'tin chī hui'xina'n. Hui'xina'n nakexpa'tā'tit ixlīpō'ktu tū nacāhuaniyān. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tī jā nata'a'ka'ī' tū nahuan tzamā' chi'xcu', ū'tunu'n nacāmālaksputūcan ē nacātamacxtucan ixlacatīnca'n tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Chuntza' tahuanli ixlīpō'ktuca'n ixa'kchihuīna'nī'n Dios xamakāstza', Samuel ē nā chuntza' tī tamilh ā'līstān. Xlaca'n tahuanli na'a'kspula huā'mā'. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Hui'xina'n ixcamana'ca'n ixa'kchihuīna'nī'n Dios. Nā milaca'n talacāxtlahuan tū tlahualh quinDiosca'n ē quinapapana'ca'n. Tlahuaca talacāxtlahuan a'cxni' Dios huanilh Abraham: Ixpālacata minatā'natna' nacāsicua'lanātlahuacan ixlīpō'ktuca'n tachi'xcuhuī't xalanī'n nac cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","A'cxni' Dios macamilh ī'Ska'ta', cālakmacamin hui'xina'n pūla ixpālacata milīpō'ktuca'n namakxtekā'tit tū jā tze ē chuntza' nacātasicua'lanātlahuayān ―huanli Pedro. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","A'cxni' Pedro ē Juan ixtatā'chihuīna'mā'nalh tachi'xcuhuī't, talakmilh pālejni' ē ixcapitán tropas xalanī'n nac templo ē nā saduceos. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Xlaca'n tatamakchuyīlh ixpālacata tū ixcāmāsu'yuni'can tachi'xcuhuī't ē chī ixtalīchihuīna'n Jesús lacastālancuana'nli, ē chuntza' nalīlacastālancuana'ncan. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Cāchi'paca Pedro ē Juan ē cāmānūca nac pūlāchī'n. Kōtanūtza' ixuanī't, ē ū'tza' cālīmakxtekca a'ntza' hasta ixlīlakalī. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ta'a'ka'ī'lh lhūhua' tī takexmatli tachihuīn. Ixlīlhūhua'ca'n chī a'kquitzis mil chi'xcuhuī'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ixlīlakalī tatakēstokli nac Jerusalén māpa'ksīni'nī'n ē xanapuxcu'nu' israelitas ē mākelhtahua'kē'ni'nī'n līmāpa'ksīn. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Milh Anás, tī xapuxcu' pālej, ē Caifás ē Juan ē Alejandro ē ixlīpō'ktuca'n ixtalakapasnī'n xapuxcu' pālej. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","A'cxni' ixcāhui'līcanī'ttza' Pedro ē Juan na ixlacatīnca'n, cākelhasqui'nīca: ―¿Tīchu ixlīmāpa'ksīn tū lītlahua'tit huā'mā'? ¿Tīchu cāmacaminān lītlahua'tit huā'mā'? ");
INSERT INTO tkuNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ixlīstacna' Pedro ixlītzuma Espíritu Santo ē cāhuanilh: ―Chi'xcuhuī'n, māpa'ksīni'nī'n ē xanapuxcu'nu' israelitas: ");
INSERT INTO tkuNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Chuhua'j quina'n quilāmālacapū'nī'ta'uj ixpālacata a'ktin tū tze ictlahuani'uj huā'mā' chi'xcu' ta'jatatlani' ē ixpālacata chī lītatzeyīlh. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Caca'tzītit milīpō'ktuca'n hui'xina'n ē cataca'tzīlh ixlīpō'ktuca'n tachi'xcuhuī't israelitas huā'mā' tū a'kspulalh. Huā'mā' chi'xcu' tī yālh na milacatīnca'n ū'tza' līmātzeyīlh ixlītli'hui'qui Jesucristo xala' nac Nazaret. Ū'tza' Jesucristo tī hui'xina'n māxtokohua'ca'nīni'ntit ē Dios mālacastālancuanīlh. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Huā'mā' Jesucristo ū'tza' tī lakmaka'ntit hui'xina'n hua'chi tapācna'nī'n talakmaka'n a'ktin chihuix. Chuhua'j huā'mā' Jesucristo hua'chi chihuix tū pūla hui'līca ixtzā'stūn. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Jesucristo xmān ū'tza' makapūtaxtūnu'. Jā a'nampala ā'chā'tin chi'xcu' nac cā'quilhtamacuj tī tzē quincāmakapūtaxtūyān ―huanli Pedro. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","A'cxni' talaktzī'lh māpa'ksīni'nī'n chī Pedro ē Juan jā ixtajicua'n, xlaca'n talī'a'cnīlh ixpālacata ixtaca'tzī Pedro ē Juan xlaca'n catīhuālh chi'xcuhuī'n ē jā tū ixtaca'tzī. Ū'tza' talīca'tzīlh xlaca'n ixtatā'latlā'huan Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Talaktzī'lh chi'xcu' tī mātzeyīca ē ixyālh ixlacatīnca'n. Jāla tahuanli jā tze tū tatlahualh Pedro ē Juan. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Cāmaxquī'ca līmāpa'ksīn catataxtulh macsti'na'j Pedro ē Juan jā ixtatakēstoknī't tī ixtatlahua justicia. Talīkelhachihuīna'nli xlaca'n ");
INSERT INTO tkuNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ē talāhuanilh: ―¿Tū nacātlahuani'yāuj tzamā' chi'xcuhuī'n? Ū'tunu'n tatlahuanī't a'ktin ka'tla' lī'a'cnīn. Huā'mā' taca'tzī ixlīpō'ktuca'n tī tahui'lāna'lh nac Jerusalén. Jāla cati'a'kskāhuī'uj. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Cacāmekē'klhauj ē cacāhuaniuj jātza' catamāsu'yulh na ixtacuhuīni' Jesús. Chuntza' jātza' catitalhūhua'nli tī ta'a'ka'ī' ixtachihuīnca'n ―talāhuanilh. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Cāmāta'satīnīni'nca Pedro ē Juan ē cāmāpa'ksīca jātza' catalīchihuīna'nli ē jātza' catamāsu'yulh nūn ā'maktin na ixtacuhuīni' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pedro ē Juan takelhtīni'lh ē tahuanli: ―¿Ē chā tze na ixlacatīn Dios na'iccākexmatni'yān hui'xina'n ē jā na'ickexmatni'yāuj Dios? ¿Chī puhua'nā'tit? Caquilāhuaniuj. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Quina'n jāla ictimakxtekui na'icuanāuj tū iclaktzī'nī'ta'uj ē tū ickexmatnī'ta'uj ―tahuanli. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","A'cxni' ixcāmekē'klhacanī't huampala, cāmakxtekca. Jāla ixtamaclani' chī nacālīmakapātīnīncan ixpālacata ixtajicua'ni' tachi'xcuhuī't. Ixlīpō'ktuca'n tachi'xcuhuī't ixtachihuīna'n chī ixlīka'tla' Dios chī lītzeyanli lū'ntu'. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ē huā'mā' chi'xcu' ixka'lhītza' līhua'ca'lh tu'pu'xam cā'ta. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","A'cxni' Pedro ē Juan ixcāmakxtekcanī'ttza', talaka'lh ixtā'timīnca'n. Cāhuanica ixlīpō'ktu tū ixtahuanī't xanapuxcu'nu' pālejni' ē xanapuxcu'nu' israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","A'cxni' takexmatli huā'mā', ixlīpō'ktuca'n kēxtim ta'orarlīlh ē tahuanilh Dios: ―Māpa'ksīni', hui'x Dios ē hui'x tla'hua' a'kapūn ē ti'ya't ē mar ē ixlīpō'ktu tū a'nan. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ixlītli'hui'qui Espíritu Santo hui'x māchihuī'ni' David tī ixtā'scujān. David huanli chuntza': ¿Tū ixpālacata tata'sa ē tasītzī' tzamā' tachi'xcuhuī't tī jā israelitas? ¿Tū ixpālacata talacapāstaca tachi'xcuhuī't tū jā ixtapalh? ");
INSERT INTO tkuNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Napuxcu'nu' xalanī'n nac cā'ti'ya'tna' tatā'lāquiclhlaktzī'lh Dios. Māpa'ksīni'nī'n tatakēstokli, ē talītalakaspi'tni'ni'lh Māpa'ksīni' Dios ē nā Cristo tī Dios lacsacnī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Ū'tza' ixlīcāna'. Nac huā'mā' cā'lacchicni' tatakēstokli Herodes ē Poncio Pilato ē israelitas ē tī jā israelitas. Talītalakaspi'tni'ni'lh Jesús miSka'ta' tī lacsacnī'ta' hui'x, quinDiosca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Xlaca'n tatakēstokli natatlahua xmān tū hui'x līhui'li' xapūla tū nala ē xmān tū milīmāpa'ksīn ē mintalacapāstacni'. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Chuhua'j, Māpa'ksīni' Dios, cala'ktzi' chī quincātamekē'klhacu'tunān. Caquilāmaktāyauj quina'n tī iccātā'scujān. Chuntza' na'iclīchihuīna'nāuj mintachihuīn ē jā na'icjicua'nāuj. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Camāsu'yu' milītli'hui'qui ē cacāmātzeyi' ē calītla'hua' lī'a'cnīn ixlītli'hui'qui Jesús miSka'ta' tī tze. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","A'cxni' ixta'orarlīnī'ttza', tachiquilh jā ixtatakēstoknī't. Ixlīpō'ktuca'n ixlīstacna'ca'n talītatzumalh Espíritu Santo. Talīchihuīna'nli ixtachihuīn Dios ē jā ixtajicua'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ixlīlhūhua' tī ixta'a'ka'ī'nī't ixtaka'lhī a'ktin talacapāstacni' ē a'ktin tapuhuāt. Nūn chā'tin puhuanli jāla namāstā' tū ixka'lhī. Maktin ixtamākēxtimīnī't ixlīpō'ktu tū ixtaka'lhī. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Apóstoles ixtaka'lhī lhūhua' lītli'hui'qui. Ixtalīmāsu'yu chī Māpa'ksīni' Jesús ixlacastālancuana'nī't. Ē Dios ixcāsicua'lanātlahua. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nūn chā'tin ī'sputni' catūhuālh ixpālacata ixlīpō'ktuca'n tī ixtaka'lhī ixti'ya'tca'n ē ixchicca'n, ixtastā' ē ixtalīmin ixtapalh tū ixtastā'. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ixtamaxquī' apóstoles. Tamāpitzīlh chā'tunu' chī ixtamaclacasqui'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ixuī'lh chā'tin chi'xcu' ixtacuhuīni' José. Apóstoles tamāpācuhuīlh ixlī'a'ktu' ixtacuhuīni' Bernabé (huā'mā' huanicu'tun māko'xamixīni'). Ū'tza' levita ixuanī't xala' nac Chipre. ");
INSERT INTO tkuNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Xla' ixka'lhī ixti'ya't. Stā'lh ē cālīmini'lh ixtapalh ē cāmaxquī'lh apóstoles. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nā ixuī'lh chā'tin chi'xcu' ixtacuhuīni' Ananías. Ixka'lhī ixpuscāt tī ixuanican Safira. Xlaca'n tastā'lh pītzuna'j ixti'ya'tca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananías māquī'lh macsti'na'j ixtapalh. Nā ixpuscāt nā ixtā'līca'tzī. Ananías līmilh tū quītāxtūlh ē cāmaxquī'lh apóstoles. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pedro huanilh: ―Ananías, ¿tū ixpālacata lītanūlh skāhuī'ni' na milīstacna' ē lakpalīlh mintalacapāstacni' lī'a'kskāhuī'cu'tuna' Espíritu Santo ē namāquī'ya' macsti'na'j tumīn ixtapalh ti'ya't? ");
INSERT INTO tkuNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mila' ixuanī't ti'ya't a'cxni' jāna'j ī'stā'ya'. Mila' ixuanī't ixtapalh a'cxni' stā't ti'ya't. ¿Tū ixpālacata līlacapāstacti natlahua'ya' huā'mā'? Hui'x a'ksa'nī'ni' jā xmān na ixlacatīnca'n chi'xcuhuī'n. Hui'x nā a'ksa'nī'ni'nī'ta' na ixlacatīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","A'cxni' Ananías kexmatli huā'mā' tachihuīn, a'kā'lh xanīn. Tajicua'nli ixlīpō'ktuca'n tī takexmatli tū a'kspulalh. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ka'hua'chan tamā'kaquī'lh Ananías ē tapāsui'tli ē tamāxtulh ē tamā'cnūlh. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Chī ixlī'a'ktu'tun hora ixpuscāt Ananías tanūlh. Xla' jā ixca'tzī tū ixa'kspulanī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedro kelhasqui'nīlh: ―Caquihua'ni', ¿chī līstā'tit ti'ya't? Puscāt huanilh chuntza' chī ixuaninī't ixkōlu'. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedro huanilh: ―¿Tū ixpālacata lālīca'tzīyā'tit a'kskāhuī'cu'tunā'tit ixEspíritu Dios? Cakexpa'tti chī tatantūsa'nan kēpūn tī tamā'cnūlh minkōlu'. Nā hui'x natamāxtuyān. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Lacapala puscāt a'kā'lh xanīn na ixlacatīn Pedro. Ka'hua'chan tatanūchi ē talaktzī'lh mā'lh xanīn. Tamāxtulh ē tamā'cnūlh ixpāxtūn ixkōlu'. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ixtajicua'n ixlīpō'ktuca'n tā'timīn tī takexmatli huā'mā'. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Apóstoles tatlahualh lhūhua' lī'a'cnīn ixlacpu'na'i'tātca'n tachi'xcuhuī't. Ixtatakēstoknī't ixlīpō'ktuca'n na ixtanquilhtīn Salomón. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nūn chā'tin chī ixlīlhūhua'ca'n jā tā'takēxtimīcu'tunli ū'tunu'n ixpālacata ixtajicua'n. Tachi'xcuhuī't ixtalaktzī'n apóstoles chī tzeya chi'xcuhuī'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tī ixta'a'ka'ī'ni' Māpa'ksīni' ā'chulā' ixtalhūhua'n, chi'xcuhuī'n ē puscan. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ixcālīmincan ta'jatatlanī'n nac cā'tejen jā ixtētaxtu Pedro. Ixcāhui'līcan nac talajni' ē na ixpūtama'ca'n, palh tzē cahuālh masqui xmān ixmāstilē'k Pedro ixcālīmātzeyīlh. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nā ixtamimā'nalh nac Jerusalén lhūhua' tachi'xcuhuī't xalanī'n cā'lacchicni' na ixlacatzuna'j Jerusalén. Ixtalīmin ta'jatatlanī'n ē tī ixtaka'lhī jā tzeya ū'ni'. Ixlīpō'ktuca'n cāmātzeyīca. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tā'kaquī'lh xapuxcu' pālej ē ixchi'xcuhuī'n tī ixta'a'ka'ī'ni' ixtamāsu'yunca'n saduceos. Tasītzī'lh xlaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Cāchi'paca apóstoles ē cāmānūca nac pūlāchī'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Dios macamilh chā'tin ángel. Ē cāmālaquī'ni'lh pūlāchī'n tzī'sa ē cāmāxtulh ē cāhuanilh: ");
INSERT INTO tkuNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Capintit ē catāya'tit xaka'tla' nac templo ē cacātā'chihuīna'ntit tachi'xcuhuī't ixlīpō'ktu chī tzē natalīka'lhī xasāsti' ixlatamatca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","A'cxni' ixtakexmatnī't huā'mā', tatanūlh xaka'tla' nac templo a'cxni' ī'xkakamā'lhtza' ē tamāsu'yulh. Xapuxcu' pālej ē nā ixchi'xcuhuī'n tatakēstokli. Cāmākēstokca ū'tunu'n tī ixtatlahua justicia ē ixlīpō'ktu xanapuxcu'nu' xalanī'n nac Israel. Cāmacā'nca policías natamāxtu tachī'nī'n nac pūlāchī'n ē natalīmin. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","A'cxni' policías tachā'lh, jā cāmaclaca nac pūlāchī'n. Taquītaspi'tli ē tamāca'tzīnīni'lh. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Tahualh: ―Icchā'uj nac pūlāchī'n ē iclaktzī'uj ē tzej ixlacchahua. Maktaka'lhna'nī'n ixtayāna'lh ixtanquilhtīn nac pūlāchī'n. A'cxni' icmālaquī'uj, jā tī chā'tin icmaclauj na ixpūchakān pūlāchī'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","A'cxni' takexmatli huā'mā', xacapitán xaka'tla' templo ē xanapuxcu'nu' pālejni' lhūhua' talacapāstacni'lh tūchu nala. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Palaj tunca milh chā'tin ē cāhuanilh: ―Chi'xcuhuī'n tī cāmānū'tit nac pūlāchī'n tayāna'ncha' xaka'tla' nac templo ē tamāsu'yuni'mā'nalh tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Palaj tunca ta'a'lh capitán ē policías ē cāquītēpalaca Pedro ē Juan. Cālīminca līlacatzucu ixpālacata ixtajicua'ni' tachi'xcuhuī't palh ixcācucta'laca. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","A'cxni' ixcālīmincanī'ttza', cāhui'līca ixlacatīnca'n māpa'ksīni'nī'n. Xapuxcu' pālej cākelhasqui'nīlh: ");
INSERT INTO tkuNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―¿Ē jā iccāmāpa'ksīn hui'xina'n jātza' camāsu'yu'tit na ixtacuhuīni' Jesús? Hui'xina'n cāmāsca'tīkō'tittza' xalanī'n nac Jerusalén tzamā' mintamāsu'yunca'n. Hui'xina'n hua'nā'tit quina'n iclē'nāuj cuenta ixpālacata maknīca Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Takelhtīni'lh Pedro ē ā'makapitzīn apóstoles ē tahuanli: ―¿Ē chā tze palh na'iccākexmatni'yāuj chi'xcuhuī'n ē jā Dios? ");
INSERT INTO tkuNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","IxDiosca'n quinatāta'na'ca'n mālacastālancuanīlh Jesús tī hui'xina'n māmaknīnīni'ntit a'cxni' xtokohua'ca'ca nac cruz. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Dios līmāhua'ca'lh Jesús ē hui'līlh na ixpekxtūcāna'j ē līhui'līlh xapuxcu' ē makapūtaxtūnu'. Ū'tza' tlahualh ixpālacata xalanī'n nac Israel natalakpalī ixtalacapāstacni'ca'n ē nacāmātza'nkēna'ni'can ixcuentaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Quina'n iclīmāsu'yuyāuj huā'mā'. Ē chuntza' līmāsu'yu Espíritu Santo tī Dios cāmaxquī'nī't tī takexmatni'. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","A'cxni' takexmatli huā'mā', tasītzī'lh ē ixcāmaknīcu'tuncan. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Chā'tin scujni', tī fariseo ixuanī't, ixuanican Gamaliel. Xla' ū'tza' chā'tin xamākelhtahua'kē'ni' līmapa'ksīn ē ixlakachi'xcuhuī'can. Xla' tāyalh ē huanli cacāmāxtuca Pedro ē Juan tzāla'j. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Gamaliel cāhuanilh ā'makapitzīn scujnī'n: ―Chi'xcuhuī'n xalanī'n nac Israel, calacapāstacna'ntit tū nacātlahuani'yā'tit tzamā' chi'xcuhuī'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ca'tzīyā'tit makāstza' ixuī'lh chā'tin chi'xcu' ixtacuhuīni' Teudas, tī ka'tla' ixmakca'tzī. Makapitzīn chi'xcuhuī'n, hua'chi a'ktā'ti' ciento, ixtastālani'. Xla' maknīca. Tata'a'kahuanīkō'lh tī ixtastālani'nī't. Chuntza' līsputli tū ixmātzucunī't Teudas. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ā'līstān ixui'lapālh Judas xala' nac Galilea a'cxni' lālaktzo'kca. Xla' cāmā'kaquī'lh makapitzīn tī ixtastālani'. Nā Judas sputli. Tata'a'kahuanīkō'lh tī ixtastālani'nī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Chuhua'j iccāhuaniyān hui'xina'n, jā tū cacātlahuani'tit tzamā' chi'xcuhuī'n ē cacāmakxtektit. Palh huā'mā' talacapāstacni' ē huā'mā' tamāsu'yun xmān ixlaca'n chi'xcuhuī'n, ixlīmān nalaksputa. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Palh ixla' Dios, jā maktin catimāpānū'tit. Jā catā'lākelhtaxtoktītit Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ta'a'ka'ī'lh ixtachihuīn Gamaliel. Cāmāta'satīnīni'nca apóstoles ē cāsno'kca. Cāhuanica jātza' catachihuīna'lh na ixtacuhuīni' Jesús. Cāmakxtekca. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Pedro ē Juan tataxtulh ixlacatīnca'n scujnī'n. Tapāxuhualh ixpālacata cālaktzī'nca xlaca'n tze natapātī tū līmāxana' ixpālacata Jesucristo. ");
INSERT INTO tkuNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Lakalī lakalī xaka'tla' nac templo ē na ixchicca'n, jā ixtamakxteka tamāsu'yu ē talīchihuīna'n Jesucristo. ");
INSERT INTO tkuNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Huā'mā' quilhtamacuj ixtatachā'lhūhuī'tēlha tī ixta'a'ka'ī'. Chi'xcuhuī'n griegos talāhuanilh hebreos jā tze chī ixcāmāpitzini'can līhua' lakalī lakalī tī ixcānīmaka'ncanī'ttza' ē jā lacxtim ixcāmaxquī'can. ");
INSERT INTO tkuNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kelhacāujtu' apóstoles tamākēstokli ixlīpō'ktuca'n tī ixta'a'ka'ī' ē cāhuanica: ―Jā minī'ni' na'icmakxtekāuj na'icmāsu'yuyāuj ixtachihuīn Dios ē na'icmāstā'yāuj līhua'. ");
INSERT INTO tkuNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Chuhua'j, tā'timīn, cacālacsactit kelhatojon chi'xcuhuī'n chī hui'xina'n tī cālakapasā'tit lactze ē tī talītzuma Espíritu Santo ē tī tzej talacapāstacna'n. Nacāmacamaxquī'yāuj huā'mā' tascujūt. ");
INSERT INTO tkuNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Quina'n ū'tza'tza' quintascujūtca'n: na'icorarlīyāuj ē na'icmāsu'yuyāuj ixtachihuīn Dios ―cāhuanica. ");
INSERT INTO tkuNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Huā'mā' cāminī'ni'lh ixlīpō'ktuca'n. Lacsacca Esteban, chā'tin chi'xcu' tī ixlītzuma Espíritu Santo ē tī tzej ixa'ka'ī'ni' Dios. Cālacsacca Felipe ē Prócoro ē Nicanor ē Timón ē Parmenas ē Nicolás xala' nac Antioquía tī ixcātā'a'ka'ī' israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Cālīminca ixlacatīnca'n apóstoles ē cā'orarlīca ē cā'a'cpūhui'līca ixmacanca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","A'kahuanli ixtachihuīn Dios. Tī ixta'a'ka'ī' ixtatachā'lhūhuītēlha nac Jerusalén. Lhūhua' pālejni' ta'a'ka'ī'lh ē takexmatni'lh ixtachihuīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban ixa'ka'ī ē ixka'lhī ixlītli'hui'qui Dios. Ixtlahua lī'a'cnīn ixlacpu'na'i'tātca'n tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Tatā'kaquī'lh makapitzīn xalanī'n na ixtemploca'n israelitas tī ixcāmāpācuhuīcan Libertos, ē nā xalanī'n nac Cirene ē Alejandría ē Cilicia ē Asia. Ē tatā'lālīhuanilh Esteban. ");
INSERT INTO tkuNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Xlaca'n jāla ixtatā'lāskāhuī' ixpālacata ixtalacapāstacni' Esteban ē ixpālacata Espíritu Santo tī ixmāchihuīnī. ");
INSERT INTO tkuNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Xlaca'n taxokolh ā'makapitzīn nata'a'ksa'nīni'n ixtakexmatnī't chī Esteban a'ksa'nli Moisés ē Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Cāchihuīna'makasītzī'ca tachi'xcuhuī't ē xanapuxcu'nu' israelitas ē mākelhtahua'kē'ni'nī'n līmāpa'ksīn. Xamaktin laktalacatzuna'jīca Esteban ē chi'paca ē līminca ixlacatīnca'n scujnī'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Cāhui'līca tī natahuan tū jā ixlīcāna' ē tahuanli: ―Huā'mā chi'xcu' jā makxteka a'ksa'n līmāpa'ksīn ē tzamā' xaka'tla' templo tū xatasicua'lanālan. ");
INSERT INTO tkuNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ickexmatui a'cxni' huanli Jesús xala' nac Nazaret namālaksputū xaka'tla' templo ē natalakpalī tahuilat tū māsu'yulh Moisés. ");
INSERT INTO tkuNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ixlīpō'ktuca'n tī ixtahui'lāna'ncha' jā ixtlahuacan justicia, talakalaktzī'lh Esteban. Ixlacan ixtasu'yu hua'chi ángel. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Xapuxcu' pālej kelhasqui'nīlh Esteban: ―¿Ē ixlīcāna' huā'mā'? ");
INSERT INTO tkuNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Esteban huanli: ―Chi'xcuhuī'n, israelitas hua'chi chī quit, cakexpa'ttit. Dios, tī ka'tla', tasu'yuni'lh quimpapca'n Abraham a'cxni' xla' ixuī'lhcus nac cā'lacchicni' nac Mesopotamia. Jāna'j ixa'n tahui'la nac Harán. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Dios huanilh: Cataxtu na mincā'lacchicni' ē cacāmakxtekti mintalakapasnī'n ē capit nac cā'lacchicni' tū na'icmāsu'yuni'yān. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Abraham taxtulh na ixcā'lacchicni'ca'n caldeos ē a'lh tahui'la nac Harán. A'cxni' ixnīnī'ttza' ixtāta' Abraham, Dios līmilh Abraham nac cā'lacchicni' jā hui'xina'n hui'lā'na'ntit chuhua'j. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Dios jā maxquī'lh ti'ya't huā'tzā', nūn pītzuna'j jā nayāhua ixtujan. Xmān huanilh ixtēcu' ti'ya't nahuan xla' ē ixnatā'natna', masqui jāna'j ixka'lhī ixka'hua'cha. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Dios tā'chihuīna'nli chuntza': Minatā'natna' natatahui'la chī xamini' nac ā'lacatin cā'lacchicni'. A'ntza' nacāmāscujūcan ē nacāmakapātīnīncan a'ktā'ti' ciento cā'ta. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Quit na'iccāmakapātīnīn tachi'xcuhuī't tī nacāmāscujū minatā'natna'. Ā'līstān natataxtu minatā'natna' ē naquintamakapāxuī huā'tzā'. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Dios hui'līlh a'ktin talacāxtlahuan tū ixpālacata ixcāchu'cucan chi'xcuhuī'n israelitas ixpālacata nacālīlakapascan. Tahuī'lh chā'tin ixka'hua'cha Abraham, ixtacuhuīni' Isaac. Ixlī'a'ktzayan quilhtamacuj Abraham chu'culh ixka'hua'cha. Ā'līstān tahuī'lh chā'tin ixka'hua'cha Isaac, ixtacuhuīni' Jacob. Ā'līstān Jacob ka'lhīlh kelhacāujtu' ixcamana' tī quinapapana'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Quinapapana'ca'n ixtaquiclhlaktzī'n ixtā'tinca'n José. Xlaca'n tastā'lh José. Lē'nca nac Egipto. Dios ixmaktaka'lha. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Dios makapūtaxtūlh ixlīpō'ktu tū pātīlh. Dios maxquī'lh José talacapāstacni' na ixlacatīn Faraón tī puxcu' xala' nac Egipto. Faraón ixlakachi'xcuhuī' José. Līhui'līlh chī gobernador nac Egipto. Hui'līlh namāpa'ksīkō' pō'ktu ixchic Faraón. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Milh a'ktin tatzi'ncstat ixlīpō'ktu tzamā' ti'ya't Egipto ē nac Canaán. Tapātīni'lh. Quinapapana'ca'n jā ixtamacla tū natahua'. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","A'cxni' kexmatli Jacob ixa'nan trigo nac Egipto, pūla cāmacā'lh a'ntza' ixka'hua'chan tī quinapapana'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","A'cxni' ta'a'mpālh ixlīmaktu', José cāhuanilh ixnapuxcu'nu': “Quit mistancuca'n.” Faraón māca'tzīnīca ixtā'timīn José ixtahuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","José māta'satīnīni'lh Jacob tī ixtāta' ē ixlīpō'ktuca'n ixtā'timīn ē ixcamana'ca'n, i'tāt ciento ā'pu'xamaquitzis tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jacob a'lh tahui'la nac Egipto. A'ntza' nīlh xla' ē nā tanīkō'lh ixka'hua'chan tī quinapapana'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ā'maktin cālē'mpalaca nac Siquem ē a'ntza' cāmā'cnūca nac lhu'cu' tū cāmaktamāhualh Abraham ixcamana' Hamor xalanī'n nac Siquem. Lītamāhualh tumīn. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Ixtalacatzuna'jītēlha quilhtamacuj a'cxni' ixmākentaxtūlh Dios tū ixuaninī't Abraham. Tachi'xcuhuī't israelitas lhūhua'ntēlhalh nac Egipto. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Hui'līpalaca chā'tin puxcu' nac Egipto tī jā lakapasli José. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Xla' cā'a'kskāhuī'lh quinapapana'ca'n ē chuntza' cālītlajalh. Xla' cāmakapātīnīnli quinapapana'ca'n ē cāmāmaka'nīlh xanatāta'na' ixlacstīnca'n natanī. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Milh a'ktin quilhtamacuj lacatuncuhuī'lh Moisés ē tzēhuanī't ixuanī't na ixlacatīn Dios. Ixmaktaka'lhmā'ca a'ktu'tun mālhcuyu' na ixchic ixtāta'. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","A'cxni' quīhui'līca Moisés nac xcān, ixtzu'ma'jāt Faraón sacli ē makastacli hua'chi ixlīcāna' ixka'hua'cha. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moisés māsca'tīca ixlīpō'ktu talacapāstacni' xala' nac Egipto. Tzej ixchihuīna'n ē pō'ktu tzē ixtlahua. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’A'cxni' ixka'lhītza' tu'pu'xam cā'ta, puhuanlitza' palh nacālaka'n ixtalakapasni' tī israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Laktzī'lh chī chā'tin egipcio ixmakapātīnīmā'lh chā'tin israelita. Moisés līmaktāyalh ē maknīlh tzamā' egipcio. Chuntza' tapānūni'lh tū ixmakca'tzī. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisés ixpuhuan israelitas ixtakexmata chī Dios ixlacsacnī't nacāmaktāya nata'a'kapūtaxtu. Ē xlaca'n jā ixtakexmata. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ixlīlakalī huampala cālakchilh Moisés chā'tu' israelitas ixtalātucsmā'nalh ē ixlāmakxtekecu'tun ē cāhuanilh: “Chi'xcuhuī'n, hui'xina'n lītalakapasnī'n. ¿Tū ixpālacata lālītucspā'na'ntit?” ");
INSERT INTO tkuNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Tī ixlacatāquī'mā'lh ixtā'chic palaj tunca tancsli Moisés ē huanilh: “¿Tīchu hui'līnī'ta'n hua'chi quimpuxcu'ca'n ē quijuezca'n? ");
INSERT INTO tkuNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Ē naquimaknīcu'tuna' quit chī ma'kni' huā' kōtan egipcio?” ");
INSERT INTO tkuNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","A'cxni' kexmatli huā'mā', Moisés tzā'lalh. Chā'lh cā'lacchicni' nac Madián ē a'ntza' tachokolh chī xamini'. A'ntza' tatahuī'lh chā'tu' ixcamana'. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’A'cxni' ixtētaxtunī'ttza' tu'pu'xam cā'ta, chā'tin ángel tasu'yuni'lh nac cā'tzaya'nca ti'ya't ixlacatzuna'j nac sipej ixtacuhuīni' Sinaí. A'ntza' tasu'yulh nac a'katin putzuna'j qui'hui' tū ī'lhcumā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","A'cxni' laktzī'lh Moisés jā ixca'tzī tū ī'lhcumā'lh. Ē talacatzuna'jīlh nalaktzī'n. Ixtachihuīn Dios huanilh: ");
INSERT INTO tkuNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Quit ixDiosca'n minatāta'na' ē ixDiosca'n Abraham ē Isaac ē Jacob. Moisés xpipilh ē jicua'nli ē jā ixlaktzī'ncu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Māpa'ksīni' huanilh: Catatūxtu mincaclhi' ixpālacata jā yā't, ixlacatīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Quit ixlīcāna' iclaktzī'nī't chī cāmakapātīnīmā'ca quintachi'xcuhuī't tī tahui'lāna'lh nac Egipto. Ickexmatnī't chī tata'samā'nalh xlaca'n, ē icyujnī'ta'nchi na'iccāmakapūtaxtū. Chuhua'j cata't. Na'icmacā'nān nac Egipto. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Huā'mā' ū'tza' Moisés tī talakmaka'lh a'cxni' tahuanli: “¿Tīchu hui'līnī'ta'n hua'chi quimpuxcu'ca'n ē quijuezca'n?” Dios macamilh huā'mā' Moisés chī xapuxcu' ē makapūtaxtūnu'. Ixmaktāya ángel tī tasu'yuni'lh nac a'katin putzuna'j qui'hui'. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moisés cāmāxtulh quinapapana'ca'n. Xla' tlahualh laka'tla' lī'a'cnīn nac Egipto ē nac Xatzu'tzo'ko Mar ē nac cā'tzaya'nca ti'ya't tu'pu'xam cā'ta. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Huā'mā' ū'tza' Moisés tī cāhuanilh israelitas: Māpa'ksīni' quinDiosca'n nalacsaca chā'tin mintalakapasni'ca'n chuntza' chī quilacsacli quit. Ū'tza' ixa'kchihuīna' Dios nahuan. Nakexpa'tā'tit hui'xina'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Huā'mā' Moisés ū'tza' ixuī'lh a'cxni' ixtatakēstoknī't nac cā'tzaya'nca ti'ya't. Ángel tā'chihuīna'nli nac sipej Sinaí. Moisés cāhuanilh quinapapana'ca'n tū huanli ángel. Moisés maktīni'lh tachihuīn tū jā maktin catisputli ē ū'tza' quincāmaxquī'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Huā'mā' quinapapana'ca'n jā takexmatni'cu'tunli Moisés ē talakmaka'lh. Ixtataspi'tcu'tun nac Egipto. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Tahuanilh Aarón: Caquilātlahuani'uj ídolos tū naquincāpūlani'yān. Jā icca'tzīyāuj tū a'kspulalh Moisés tī quincāmāxtun nac ti'ya't Egipto. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Xlaca'n tatlahualh a'ktin ídolo tū ixtasu'yu hua'chi xaska'ta' huācax ē maknīca animalh ē maxquī'ca talakalhu'mān ídolo. Talīpāxuhualh tū ixtalītlahuanī't ixmacanca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Dios cātamakatīni'lh xlaca'n ē cāmakxtekli natalaktaquilhpūta sta'cu. Nā chuntza' tatzo'kni' nac libro tū tatzo'kli ixa'kchihuīna'nī'n Dios. Huanli: ¿Ē quilāmālacnūni'uj talakalhu'mān ē animalh tū xatamaknīn tu'pu'xam cā'ta nac cā'tzaya'nca ti'ya't? ");
INSERT INTO tkuNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Hui'xina'n līta'ntit ixa'cchic ídolo Moloc jā ixlaktaquilhpūtacan, ē ídolo Renfán tū ixtasu'yu hua'chi sta'cu. Hui'xina'n tlahua'tit ídolos nacālaktaquilhpūtayā'tit. Chuhua'j quit na'iccālē'nān ā'chulā' ixlakamakat Babilonia. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Esteban chihuīna'mpālh: ―Nac cā'tzaya'nca ti'ya't, quinapapana'ca'n ixtaka'lhī xaka'tla' a'cchic tū ixmāsu'yu Dios ixcāmāmakxtoklē'mā'lh. A'cchic ū'tza' ixtlahuacanī't chuntza' chī Dios ixmāsu'yuni'nī't Moisés. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Quinapapana'ca'n tamaktīni'lh ixa'cchic. Talīmilh a'cxni' tatā'tanūchi Josué na ixti'ya'tca'n ā'makapitzīn chi'xcuhuī'n tī Dios cāmāxtulh ixlacatīnca'n quinapapana'ca'n. A'ntza' tamakxtekli a'cchic hasta a'cxni' ixquilhtamacuj David. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dios līpāxuhualh David chun ixtlahuani'cu'tun a'ktin ixchic Dios tī nā ixDios Jacob. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Tī tlahualh ixchic Dios, ū'tza' Salomón. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Dios xaka'tla' jā tahui'la nac a'ktin chic tū tatlahuanī't chi'xcuhuī'n. Nā chuntza' huanli ixa'kchihuīna' Dios: ");
INSERT INTO tkuNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Quit, Dios, icmāpa'ksī nac a'kapūn ē nac cā'quilhtamacuj. ¿Tuyā chic naquilātlahuani'yāuj? huanli Māpa'ksīni'. ¿Jāchu na'icjaxa quit? ");
INSERT INTO tkuNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Ē jā quit iclītlahualh quimacan ixlīpō'ktu tū a'nan? ");
INSERT INTO tkuNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Esteban cāhuanipālh: ―Hui'xina'n lacxumpin. Jā ka'lhī'yā'tit milīstacna'ca'n nalīlacapāstacna'nā'tit. Jā kexpa'tcu'tunā'tit. Tihua'na' tā'lāhuaniyā'tit Espíritu Santo. Chuntza' chī ixtala minapapana'ca'n nā chuntza' la'yā'tit hui'xina'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Minapapana'ca'n tamakapātīnīnli ixa'kchihuīna'nī'n Dios. Tamaknīlh tī tahuanli xapūla namin tī xatze. Ū'tza' milh ē hui'xina'n macamāstā'tit ē maknī'tit. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Hui'xina'n maktīni'ntit līmāpa'ksīn tū tamacamāstā'lh ángeles ē jā kexpa'tni'tit ―cāhuanilh Esteban. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","A'cxni' takexmatli huā'mā', tasītzī'lh ē talāxcakō'lh ixtatzanca'n ixpālacata chī tasītzī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ixlīstacna' Esteban ixlītzuma Espíritu Santo. Xla' ixtalacayāhuamā'lh nac a'kapūn. Laktzī'lh taxkaket jā huī'lh Dios. Laktzī'lh Jesús ixyālh na ixpekxtūcāna'j Dios ");
INSERT INTO tkuNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ē huanli: ―Calaktzī'ntit. Quit iclaktzī'n a'kapūn laquī'yālh, ē Chi'xcu' xala' Tālhmā'n na ixpekxtūcāna'j Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ē tī ixtakexmatmā'nalh tata'salh palha' ē cā'a'kachi'paca. Ixlīpō'ktuca'n palaj tunca talakminkō'lh. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Māxtuca Esteban nac cā'lacchicni' ē cucta'laca. Testigos tahui'līlh ixlu'xu'ca'n na ixlacatīn chā'tin ka'hua'cha tī ixuanican Saulo. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","A'cxni' cucta'laca Esteban huanilh Dios: ―Māpa'ksīni' Jesús, icmacamaxquī'yān quilīstacna'. ");
INSERT INTO tkuNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tatzokostalh ē huanli palha': ―Māpa'ksīni', cacāmātza'nkēna'ni' tū quintatlahuani'mā'nalh. A'cxni' huanli huā'mā' Esteban nīlh. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo ixcātā'līca'tzī chī līmaknīca Esteban. Tzamā' quilhtamacuj tzucuca cāputzatokokecan tī ixta'a'ka'ī' nac Jerusalén. Ixlīpō'ktuca'n ta'a'kahuankō'lh hasta nac ti'ya't Judea ē Samaria. Tatachokolh xmān apóstoles. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Makapitzīn chi'xcuhuī'n, tī ixtalakachi'xcuhuī' Dios, talē'lh Esteban ē tamā'cnūlh ē talakcalhuanli. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulo ixcāmālaksputūcu'tunkō' tī ixta'a'ka'ī'. Tzuculh tanū a'katunu' nac chic ē ixcāsakalē'n chi'xcuhuī'n ē puscan ē ixcāmānū nac pūlāchī'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Tī ta'a'kahuankō'lh ixta'a'n calhāxcuhuālh ē ixtalīchihuīna'n xatze tachihuīn. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe a'lh tancā'n nac cā'lacchicni' nac Samaria. Ixcāmāsu'yuni' ixpālacata Cristo. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Lhūhua' tachi'xcuhuī't ixtakexmata kēxtim tū ixcāhuani Felipe. Takexmatli ē talaktzī'lh lī'a'cnīn tū ixtlahua. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tū jā tzeya ū'ni' ixtata'sa palha' ē ixcātaxtuni' tī ixtaka'lhī. Lhūhua' ixtalū'ntū'nun ē tī ī'xcāhui'huananī't ixcāmātzeyīmā'ca. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Lhūhua' ixa'nan tapāxuhuān tzamā' nac cā'lacchicni'. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ixuī'lh chā'tin chi'xcu' ixtacuhuīni' Simón. Xla' xapūla ixuanī't xantilh nac tzamā' cā'lacchicni'. Ixcā'a'kskāhuī'mā'lh xalanī'n nac Samaria. Huanli ū'tza' xaka'tla'. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Tzej ixtakexmatni' Simón ixlīpō'ktuca'n tī xalacstīn ē tī xalaka'tla'tza'. Ixtahuan: ―Huā'mā chi'xcu' ka'lhī ixlītli'hui'qui Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tzej ixtakexmatni' Simón ixpālacata makāstza' ixcālī'a'kskāhuī'nī't ixlīxantilh. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Felipe cālītā'chihuīna'lh xatze tachihuīn chī Dios māpa'ksīni'n ē ixpālacata Jesucristo. Xlaca'n ta'a'ka'ī'lh ē ta'a'kpaxli chi'xcuhuī'n ē puscan. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Nā Simón nā a'ka'ī'lh ē a'kpaxli ē stālani'lh Felipe. A'cxni' Simón laktzī'lh lhūhua' lī'a'cnīn tū tlahualh Felipe, lhūhua' ixlacapāstaca. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","A'cxni' taca'tzīlh xalanī'n nac Samaria ixtamaktīni'nī'ttza' ixtachihuīn Dios, apóstoles nac Jerusalén tamacā'lh Pedro ē Juan nac Samaria. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Xlaca'n tamilh ē ta'orarlīlh ixpālacata natamaktīni'n Espíritu Santo xalanī'n nac Samaria. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Jāna'j ixcālakyujachi Espíritu Santo. Xmān ixtalī'a'kpaxnī't na ixtacuhuīni' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Cā'a'cpūhui'līca ixmacanca'n ē tamaktīni'lh Espíritu Santo. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simón laktzī'lh chī Ēspíritu Santo maktīni'nca a'cxni' apóstoles ta'a'cpūhui'līlh ixmacanca'n ē cāmālacnūni'lh tumīn. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Huanli Simón: ―Nā quit caquilāmaxquī'uj huā'mā' lītli'hui'qui ē chuntza' chī catīhuālh na'ica'cpūhui'lī quimacan nā namaktīni'n Espíritu Santo. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pedro huanilh: ―Calaksputli mintumīn ē nā hui'x casputti ixpālacata puhuanti nalītamāhua'ya' tumīn tū Dios māstā'. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Hui'x jāla catimaktīni' tzamā' talakalhu'mān ixpālacata jā tze milīstacna' na ixlacatīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Camakxtekti tzamā' tū jā tze talacapāstacni' ē casqui'ni' Dios namātza'nkēna'ni'yān tzamā' talacapāstacni' tū ka'lhī'ya' na milīstacna'. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Iclaktzī'nān hui'x jā tzeya chi'xcu'. Hui'x jāla makxteka tū jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Kelhtīni'lh Simón ē huanli: ―Casqui'ni'tit Māpa'ksīni' Dios jā quinti'a'kspula tū hui'xina'n quilāhuaniuj. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","A'cxni' xlaca'n ixtalīmāsu'yunī'ttza' ē ixtalīchihuīna'nī'ttza' ixtachihuīn Dios, tataspi'tpālh nac Jerusalén. Talīchihuīna'nli xatze tachihuīn ixla' Jesucristo na ixcā'lacchicni'ca'n samaritanos. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Tā'chihuīna'nli Felipe chā'tin ángel tī Dios macamilh ē huanilh: ―Catā'kaqui' ē capit nac sur. Nalacpina' xatej Jerusalén tū a'mā'lh nac Gaza. A'ntza' cā'tzaya'nca ti'ya't. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Felipe tā'kaquī'lh ē a'lh. Tā'lāpāxtokli chā'tin chi'xcu' eunuco xala' nac Etiopía. Xla' chā'tin scujni' ixuanī't nac Etiopía jā ixmāpa'ksīni'n reina ixtacuhuīni' Candace. Huā'mā' chi'xcu', xla' ū'tza' xamaktaka'lhna' ixtumīn reina. Quīlachi nac Jerusalén namakapāxuīchi Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ixtaspi'tmā'lhtza' ē ixpūmimā'lh a'ktin carreta. Ixlīkelhtahua'ka'tēlha tū tzo'kli Isaías, tī ixa'kchihuīna' Dios ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Espíritu Santo huanilh Felipe: ―Catalacatzuna'ji' nac tej jā lē'mā'ca carreta ē catā'pi. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Felipe tu'jnulh ē laktalacatzuna'jīlh ē kexmatli tū ixlīkelhtahua'ka'tēlha tū ixtzo'knī't Isaías. Felipe kelhasqui'nīlh: ―¿Ē chā kexpatni'ya' tū līkelhtahua'ka'tēlha'ya'? ");
INSERT INTO tkuNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Kelhtīlh: ―¿Ē chī na'iclīkexmatni' palh jā tī tī quimāsu'yuni'? Huanica Felipe: ―Catahua'ca' ē caquimpāxtūtahui'la'. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Xla' ixlīkelhtahua'ka'huī'lh ixtachihuīn Dios jā huan chuntza': Hua'chi chī lē'ncan lakatin oveja tū namaknīcan, chuntza' lē'nca; ē chī lakatin oveja xakō'ko' na ixlacatīn tī macsi'ta, chuntza' tzamā' chi'xcu' jā tū huanli. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Māmāxanī'ca ē jā tlahuani'ca justicia. ¿Tīchu cahuālh nahuan hasta makās tilatamalh? ¿Ē jā naminācha' ixlītalakapasni' palh maktin maknīca ē mālaksputūni'ca ixlatamat nac cā'quilhtamacuj? ");
INSERT INTO tkuNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Eunuco huanilh Felipe: ―Ickelhasqui'nīyān, ¿tīchu līchihuīna'mā'lh huā'mā' Isaías? ¿Ixlīmān līchihuīna'ncan, o līchihuīna'mpala ā'chā'tin? ");
INSERT INTO tkuNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Felipe tzuculh chihuīna'n. Tzuculh huani tū ixlīkelhtahua'ka'nī't ixtachihuīn Dios ē māsu'yuni'lh ixpālacata Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","A'cxni' ixta'a'mā'nalh nac tej, tachā'lh jā mā'lh xcān. Huanli eunuco: ―Cala'ktzi'. Huā'tzā' mā'lh xcān. ¿Tū naquimāmakchuyī palh na'ica'kpaxa? ");
INSERT INTO tkuNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Felipe huanilh: ―Palh hui'x lī'a'ka'ī'ya' pō'ktu milīstacna', tzē na'a'kpaxa'. Xla' kelhtīni'lh: ―Quit ica'ka'ī'ni' Jesucristo ū'tza' ī'Ska'ta' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Palaj tunca māchokolh ixcarreta. Tatojōlh nac xcān ixchā'tu'ca'n, Felipe ē eunuco. Felipe mā'kpaxīlh. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","A'cxni' tatacutli, ixEspíritu Dios mā'kayāhualh Felipe. Eunuco jātza' laktzī'lh. A'mpālh ē pāxuhualh. ");
INSERT INTO tkuNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipe chā'lh nac cā'lacchicni' Azoto. Ixcālītā'chihuīna'ntēlha xatze tachihuīn ixla' Jesucristo na ixlīpō'ktu cā'lacchicni' hasta chā'lh nac Cesarea. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo ixcāmekē'klha tī ixta'a'ka'ī'ni' Māpa'ksīni' ē ixcāmaknīcu'tun. Laka'lh xapuxcu' pālej ");
INSERT INTO tkuNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ē squi'nli a'ktin tatzo'knu' tū nalē'n na ixtemploca'n israelitas nac Damasco. Chuntza' tzē nacāputza chi'xcuhuī'n ē puscan tī ixtastālani' Jesús ē tzē nacālīmin xatachī'nī'n nac Jerusalén. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Saulo ixtlā'huantēlha ē ixtalacatzuna'jītēlhatza' nac Damasco. Xamaktin a'ktin taxkaket xala' nac a'kapūn lītamacsti'li'lh. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","A'kā'lh nac ti'ya't. Kexmatli a'ktin tachihuīn tū huanica: ―Saulo, Saulo, ¿tū ixpālacata quimputzatokokeya'? ");
INSERT INTO tkuNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulo kelhasqui'nīlh: ―¿Tīchu hui'x, Chi'xcu'? Xla' huanli: ―Quit Jesús, ū'tza' tī hui'x putzatokokeya'. Chu tlakaj quintā'lātlahuacu'tuna'. Hui'x hua'chi lakatin cahuāyuj a'cxni' chi'nta qui'hui' tū lītlakalē'ncan. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Saulo xpipilh ē jicua'nli ē huanli: ―Māpa'ksīni', ¿tū lacasqui'na' na'ictlahua? Māpa'ksīni' huanilh: ―Catā'kaqui' ē catanu' nac cā'lacchicni'. A'ntza' nahuanica'na' tū milītlahuat nahuan. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Chi'xcuhuī'n tī ixtatā'a'mā'nalh Saulo takexmatli tachihuīn ē jā tū talaktzī'lh ē tajicua'nli. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo tā'kaquī'lh nac ti'ya't. A'cxni' tilacahuāna'ncu'tunli, jātza' lacahuāna'nli. Pekechi'palē'nca ē līminca nac Damasco. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","A'ntza' tamakxtekli a'ktu'tun quilhtamacuj ē jāla lacahuāna'nli. Jā huā'yalh ē jā ko'tnūlh. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ixuī'lh nac Damasco chā'tin chi'xcu' tī ixa'ka'ī'ni' Jesucristo ē ixtacuhuīni' Ananías. Xla' lakachuyalh ē Māpa'ksīni' huanilh: ―Ananías. Xla' kelhtīni'lh: ―Ā'tzā' icuī'lh, Māpa'ksīni'. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Māpa'ksīni' huanilh: ―Capit nac tej tū huanican Lacasaj. Caputza na ixchic Judas chā'tin tī huanican Saulo xala' nac Tarso. A'ntza' orarlīmā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ū'tza' līlakachuyanī't ē laktzī'nī't chā'tin chi'xcu' ixtacuhuīni' Ananías tī tanūlh ē a'cpūhui'līlh ixmacan ē chuntza' nalīlacahuāna'mpala. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananías kelhtīni'lh: ―Māpa'ksīni', lhūhua' quintahuaninī't huā'mā' chi'xcu' tū jā tze cātlahuani'nī'ttza' xalanī'n nac Jerusalén tī ta'a'ka'ī'ni' mintachihuīn. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Xanapuxcu'nu' pālejni' tamaxquī'nī't līmāpa'ksīn naquincāchi'payān quilīpō'ktuca'n tī iclīchihuīna'nāuj milīmāpa'ksīn. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Māpa'ksīni' huanilh: ―Capit. Quit iclacsacnī't Saulo. Xla' nacālītā'chihuīna'n quimpālacata ā'makapitzīn ē na ixlacatīnca'n reyes ē israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Quit na'icmāsu'yuni' lhūhua' tū napātīni'n quimpālacata. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananías a'lh ē tanūlh nac chic jā ixuī'lh Saulo. A'cpūhui'līlh ixmacan ē huanilh: ―Tā'tin Saulo, quimacaminī't Māpa'ksīni' Jesús tī tasu'yuni'n nac tej jā ixta'mpā't. Ū'tza' quimacaminī't nalacahuāna'mpala'ya' ē nalītatzumakō'ya' Espíritu Santo na milīstacna'. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Palaj tunca yujni'lh na ixlakastapun tū ixua'ca'ni'lh chī kepēksma' ē lacahuāna'mpālh. Tā'kaquī'lh ē palaj tunca a'kpaxli. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Huā'yalh ē tatli'hui'clhli. A'klhūhua' quilhtamacuj ixcātā'lahuī'lh tā'timīn nac Damasco. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Palaj tunca na ixtemploca'n israelitas, Saulo tzuculh līchihuīna'n Jesús. Ixuan ū'tza' huā'mā' ī'Ska'ta' quinDiosca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Talī'a'cnīlh ixlīpō'ktuca'n tī takexmatli ē talāhuanilh: ―¿Ē jā ū'tza' huā'mā' tī ixcāmālaksputūcu'tun nac Jerusalén tī ixtatapa'ksīni' Jesús? Minī't huā'tzā' ē quincāchī'lē'ncu'tunān ē quincāmacamāstā'cu'tunān na ixmacanca'n xanapuxcu'nu' pālejni'. Ū'tza' līmilh huā'tzā'. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saulo ā'chulā' ixlītatli'hui'clhmā'lh ē ixmāsu'yumā'lh Jesús ū'tza' huā'mā' Cristo tī Dios ixlacsacnī't. Ū'tza' talīlī'a'cnīlh israelitas tī ixtahui'lāna'lh nac Damasco. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","A'cxni' ixpātle'kēnī'ttza' lakma'jtza' quilhtamacuj, israelitas tachihuīna'nli natamaknī Saulo. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Māca'tzīnīca Saulo ixmaktaka'lhmā'ca. Pō'ktu quilhtamacuj ē pō'ktu tzī'sa ixtaka'lhītīmā'nalh jā ixlactanūcan nac cā'lacchicni' ixpālacata ixtamaknīcu'tun. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Cā'tzī'sa tā'timīn talē'lh Saulo ē tamāyujūlh a'ktin nac canasta nac lhu'cu' nac xatalhta'm cā'lacchicni'. Chuntza' līpūtaxtulh. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulo chā'lh nac Jerusalén ē ixcātā'tanūcu'tun tā'timīn a'ntza'. Xlaca'n ixtajicua'ni'. Jā ixta'a'ka'ī'ni' palh xla' ixa'ka'ī'nī'ttza'. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Bernabé cālīmini'lh Saulo lī'apóstoles. Cāhuanilh chī Saulo ixlaktzī'nī't nac tej Māpa'ksīni' Jesucristo tī tā'chihuīna'nli. Cāhuani'lh chī Saulo ixlīchihuīna'nī't nac Damasco ixlīmāpa'ksīn Jesús, ē jā ixjicua'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Saulo ixcātā'latlā'huan nac Jerusalén. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ixlīchihuīna'n ixlīmāpa'ksīn Dios ē jā ixjicua'n. Ixcātā'lāhuani israelitas tī ixtachihuīna'n griego. Ixtamaknīcu'tun Saulo. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","A'cxni' tā'timīn taca'tzīlh huā'mā', talē'lh Saulo nac Cesarea ē tamacā'lh nac Tarso. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Cā'līpāxuhuatza' ixtahui'lāna'lh tī ixtatalacxtimī na ixlīpō'ktu ixlīka'tla' Judea ē Galilea ē Samaria. Ā'chulā' ixta'a'ka'ī'ni' ē ixtajicua'ni'tēlha Māpa'ksīni'. Espíritu Santo ixcāmāko'xamāka'tlī ē ixtatalhūhua'ntēlha. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pedro calhāxcuhuālh ixlatlā'huan ē cālakmilh tī ixta'a'ka'ī' xalanī'n nac Lida. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","A'ntza' maclalh chā'tin chi'xcu' tī ixuanican Eneas. Xla' ixmā'lh na ixpūtama' a'ktzayan cā'ta. Ixchēkēnī'n ixlū'ntū'nunī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedro huanilh: ―Eneas, Jesucristo mātzeyīyān. Catā'kaqui' ē camā'kaqui' mimpūtama'. Palaj tunca tā'kaquī'lh Eneas. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ixlīpō'ktuca'n tī ixtahui'lāna'lh nac Lida ē Sarón talaktzī'lh Eneas ixtzeyanī'ttza'. Xlaca'n tatamacamāstā'ni'lh Jesucristo. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ixuī'lh nac Jope chā'tin puscāt tī ixa'ka'ī'. Ixtacuhuīni' Tabita ē nā Dorcas ixtacuhuīni' griego. Huā'mā' puscāt ixtlahua lhūhua' tū tze. Ixmāstā' lhūhua' talakalhu'mān. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Huā'mā' quilhtamacuj ta'jatatlalh ē nīlh. Ixmāpaxīcanī'ttza' ē ixcāxmāpī'canī'ttza' na ixlī'a'ktu' piso. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Tā'timīn nac Jope takexmatli Pedro ixuī'lh nac Lida, ixlacatzuna'j nac Jope. Cālakmacā'nca chā'tu' chi'xcuhuī'n. Xlaca'n tahuanilh Pedro: ―Palaj capit a'ntza' jā icui'lāna'uj. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Palaj tunca Pedro cātā'a'lh. A'cxni' cālakchā'lh, lē'nca na ixlī'a'ktu' piso. Ixlīpō'ktuca'n tī ixcānīmaka'ncanī'ttza' talītalacxtimīlh jā ixmā'lh Dorcas ē tacalhuanli. Tamāsu'yuni'lh lu'xu' tū ixtlahua Dorcas a'cxni' ixuī'lhcus. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pedro cāmāxtulh ixlīpō'ktuca'n ē tatzokostalh ē orarlīlh. Laktalakspi'tli tzamā' nīn ē huanilh: ―Tabita, catā'kaqui'. Lacahuāna'nli ē laktzī'lh Pedro ē tā'kaquī'lh ē tahuī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedro makachi'palh ē yāhualh. Pedro cāta'sani'lh tī ixta'a'ka'ī' ē tī ixcānīmaka'ncanī't ē cāmāsu'yuni'lh Dorcas xalakahuan. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Huā'mā' ca'tzīkō'ca na ixlīpō'ktu Jope. Lhūhua' ta'a'ka'ī'ni'lh Māpa'ksīni' Jesucristo. ");
INSERT INTO tkuNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pedro tachokolh a'klhūhua' quilhtamacuj nac Jope na ixchic chā'tin chi'xcu' tī ixuanican Simón tī ixcāxtlahua ko'xka'. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ixuī'lh nac Cesarea chā'tin chi'xcu' tī ixuanican Cornelio. Xla' capitán ixuanī't a'ktin nac batallón tū ixuanican Italiano. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Cornelio ixlakachi'xcuhuī' ē ixtajicua'ni' Dios, ē nā chuntza' ixlīpō'ktuca'n xalanī'n na ixchic. Ixmāstā' talakalhu'mān ē pō'ktu quilhtamacuj ixorarlīni' Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","A'ktin quilhtamacuj chī maktu'tun kōtanū, Cornelio lakachuyalh. Laktzī'lh chā'tin ángel tī Dios macamilh. Ángel tanūlh ē huanilh: ―¡Cornelio! ");
INSERT INTO tkuNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelio laktzī'lh ē jicua'nli ē kelhasqui'nīlh: ―¿Tūchu, Māpa'ksīni'? Ángel huanilh: ―Dios kexmatni'cha'n minoración ē chī māstā'ya' talakalhu'mān. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Chuhua'j cacāmacapi chi'xcuhuī'n nac Jope ē camāta'satīnī'ni' Simón tī ka'lhī ixlī'a'ktu' ixtacuhuīni' Pedro. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Xla' tētachokonī't na ixchic Simón tī cāxtlahua ko'xka' tī ka'lhī ixchic na ixquilhtūn mar. Ū'tza' nahuaniyān tū natlahua'ya'. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","A'cxni' huanikō'lh ángel palaj tunca a'lh. Cornelio cāta'sani'lh chā'tu' ixtasācua'n ē chā'tin tropa tī ixlakachi'xcuhuī' Dios ē tī ixtā'scuja na ixchic. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","A'cxni' cāhuanikō'lh tū ixuaninī't ángel, cāmacā'lh nac Jope. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ixlīlakalī xlaca'n ixtatlā'huamā'nalh ē ixtatalacatzuna'jītēlha nac cā'lacchicni'. Chī tastu'nūt Pedro tahua'ca'lh na ixa'kstīn chic na'orarlī. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ē tzi'ncstāyalh ē ixuā'yancu'tun. Līhuan ixcāxtlahuamā'ca līhua', Pedro lakachuyalh. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Laktzī'lh a'kapūn laquī'yālh ē hua'chi a'ktin ka'tla' sábana chī'canī't ixa'katzā'stūtā'ti'. Yujli na ixlacatīn. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","A'ntza' ixtatojōmā'nalh ixlīpō'ktu animalh tū makakentā'ti' ē lūhua' ē spūnī'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kexmatli chī tā'chihuīna'nca ē huanica: ―Catā'kaqui', Pedro, cama'kni' ē cahua't. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pedro huanli: ―E'ē, Māpa'ksīni'; jā maktin icua'nī't tū jā tzē hua'can. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Kexmatpālh ixlīmaktu' tā'chihuīna'nca ē huanica: ―Jā cahua'nti jā tze tū Dios tlahuanī't tze. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Huā'mā' a'kspulalh maktu'tun ē sábana tayapalacancha' nac a'kapūn. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedro ixlacapāstacuī'lh ixpālacata jā ixca'tzī tū ixuanicu'tun tū lakachuyalh. Tzamā' chi'xcuhuī'n, tī ixcāmacaminī't Cornelio, takelhasqui'nīni'lh jā yālh ixchic Simón. Palaj tunca tachilh na ixlacapūn mākelhcha. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Palha' tachihuīna'lh ē takelhasqui'nīni'lh palh jā lahuī'lh chā'tin chi'xcu' tī ixuanican Simón tī ixka'lhī ixlī'a'ktu' ixtacuhuīni' Pedro. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","A'cxni' Pedro ixlacapāstacuī'lh chī lakachuyanī't, Espíritu Santo huanilh: ―Chā'tu'tun chi'xcuhuī'n taputzayān. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Catāya' ē cayujti ē cacātā'pi. Jā tipuhua'na': “Jā icti'a'lh.” Quit iccāmacaminī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pedro cālakyujli chi'xcuhuī'n ē huanli: ―Quit tī putzayā'tit. ¿Tūchu lakta'nī'ta'ntit? ");
INSERT INTO tkuNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Xlaca'n takelhtīlh: ―Ixpālacata capitán Cornelio. Xla' tzeya chi'xcu' ē jicua'ni' Dios. Talaktzī'n israelitas tzeya chi'xcu'. Chā'tin ángel tī Dios macamilh huanilh Cornelio namāta'satīnīni'nān ē xla' nakexmata tū nahua'na'. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pedro cāmānūlh nac chic ē cāhuanilh catatachokokelh huā'mā' tzī'sni'. Ixlīlakalī cātā'a'lh ē nā ta'a'lh makapitzīn tā'timīn xalanī'n nac Jope. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ixlīlakalī huampala tachā'lh nac Cesarea. Cornelio ixcāka'lhīmā'lh ē ixcāmākēstokkō'nī't ixtalakapasnī'n ē ixamigo tī ā'chulā' ixcālakapasa. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","A'cxni' Pedro ixtanūmā'lh, Cornelio lakchilh. Palaj tunca tatzokostani'lh ē laktaquilhpūtalh. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pedro mā'kaquī'lh ē huanilh: ―Catā'kaqui'. Nā quit chi'xcu' chī hui'x. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","A'cxni' Pedro ixtanūtēlha ē ixtā'chihuīna'ntēlha ē lhūhua' cāmaclalh tī ixtatakēstoknī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pedro cāhuanilh: ―Hui'xina'n ca'tzīyā'tit chā'tin israelita jāla catitā'talacxtimīlh tī jā israelita. Jāla catitanūlh na ixchic. Dios quimāsu'yuni'nī't jāla ictihualh jā tze ā'chā'tin chi'xcu' ē xmān catīhuālh. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ū'tza' iclīmilh a'cxni' quimāta'satīnīni'nca ē jātū tū icpuhuanli. Iccākelhasqui'nīyān: ¿Tūchu ixpālacata quilālīmāta'satīnīni'uj? ");
INSERT INTO tkuNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Palaj tunca Cornelio huanli: ―Tā'ti'majatza' quit jā xa'icuā'yamā'lh. Hua'chi maktu'tun kōtanū quit xa'icorarlamā'lh na quinchic. Chā'tin chi'xcu' tāyalh na quilacatīn ē ixka'lhī ixlu'xu' tū ī'xkaka. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Quihuanilh: “Cornelio, Dios kexmatnī't minoración ē lacapāstacmā'lh chī māstā'ya' talakalhu'mān. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Cacāmacapi chi'xcuhuī'n nac Jope ē camāta'satīnī'ni' Simón tī ka'lhī ixlī'a'ktu' ixtacuhuīni' Pedro. Xla' tētachokomā'lh na ixchic Simón tī cāxtlahua ko'xka' na ixquilhtūn mar. Xla' namin ē natā'chihuīna'nān.” Chuntza' quihuanilh. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ū'tza' iclīmāta'satīnīni'n palaj tunca. Hui'x quintlahua'ni' talakalhu'mān quilakta. Chuhua'j quilīpō'ktuca'n icui'lāna'uj huā'tzā' na ixlacatīn Dios. Ickexmatcu'tunāuj tū Dios māpa'ksīnī'ta'n nahua'na' ―huanica Pedro. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pedro tzuculh a'kchihuīna'n ē cāhuanilh: ―Chuhua'j quit icca'tzī ixlīcāna' Dios lacpuhuan lacxtim ixlīpō'ktuca'n chi'xcuhuī'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Xalanī'n calhāxcuhuālh nac cā'lacchicni' tī tajicua'ni' Dios ē tatlahua tū tze, ū'tunu'n tamakapāxuī Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Dios cāmacamini'lh israelitas ixtachihuīn. Cāmāsu'yuni'lh tzē ixamigo natahuan Dios ixpālacata Jesucristo tī cāmāpa'ksīkō'. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Hui'xina'n ca'tzīyā'tit chī māsu'yucanī't xatze tachihuīn pūla nac Galilea ē ā'līstān nac Judea a'cxni' Juan ixmāsu'yunī'ttza' ē ixmā'kpaxīni'nī'ttza'. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Dios maxquī'lh Jesús, xala' nac Nazaret, ixlītli'hui'qui Espíritu Santo. Jesús ixtlahuatlā'huan tū tze ē ixcāmātzeyītlā'huan tī ixtapātīni'n ixpālacata tū māstā' skāhuī'ni'. Huā'mā' tzē tlahualh Jesús ixpālacata Dios ixmaktāyamā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Quina'n icmāsu'yuyāuj tū tlahualh Jesús na ixcā'lacchicni'ca'n israelitas ē nac Jerusalén. Ū'tza' tī xtokohua'ca'ca nac cruz ē chuntza' maknīca. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Dios mālacastālancuanīlh ixlī'a'ktu'tun quilhtamacuj ē Dios quincāmāsu'yuni'n Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Jā cāmāsu'yuni'lh ixlīpō'ktuca'n tachi'xcuhuī't. Dios quincāmāsu'yuni'n Jesús xmān quina'n tī quincālacsacnī'ta'n na'icmāsu'yuyāuj ixtachihuīn. Quina'n ictā'huā'yauj Jesús ē ictā'ko'tnūj a'cxni' ixlacastālancuana'nī'ttza'. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Dios quincāhuanin na'iccāmāsu'yuni'yāuj tachi'xcuhuī't ē na'icuanāuj Jesús ū'tza' tī Dios hui'līlh chī ixJuezca'n xalakahuan ē xanīnī'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ixlīpō'ktuca'n ixa'kchihuīna'nī'n Dios, xamakāstza', ixtamāsu'yu ixlīpō'ktu tī talīpāhuan Jesús, xlaca'n nacāmātza'nkēna'ni'can ixcuentaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedro ixa'kchihuīna'mā'lhcus ē Espíritu Santo cālakyujchi ixlīpō'ktuca'n tī ixtakexmatni'mā'nalh Pedro. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Talī'a'cnīni'lh israelitas tī ixta'a'ka'ī ē ixtatā'minī't Pedro. Talī'a'cnīlh ixpālacata ixcāmaxquī'mā'ca Espíritu Santo tī jā israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Cālī'a'cnīca ixpālacata ixcākexmatcanī't chī ixtachihuīna'n xtum tachihuīn ē ixtamāka'tlī'mā'nalh Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Pedro cāhuanipālh: ―¿Ē huī'lh chā'tin tī nacāmāmakchuyī nata'a'kpaxa huā'mā' chi'xcuhuī'n? Ā'nā xlaca'n cāmaxquī'ca chuntza' chī quina'n quincātamaxquī'n Espíritu Santo. ");
INSERT INTO tkuNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Pedro cāhuanilh cata'a'kpaxli na ixtacuhuīni' Jesucristo. Huanica Pedro cacātā'lātahuī'lh a'klhūhua' quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Apóstoles ē tā'timīn tī ixtahui'lāna'lh nac Judea cāmāca'tzīnīca chi ixta'a'ka'ī' ixtachihuīn Dios nā xlaca'n tī jā israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","A'cxni' Pedro chā'lh nac Jerusalén, tatā'lāquilhnīlh israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Takelhasqui'nīlh Pedro: ―¿Tū ixpālacata maktanūnī'ta' jā tahui'lāna'lh chi'xcuhuī'n tī jā israelitas? ¿Tū ixpālacata cātā'huā'ya'nī'ta'? ");
INSERT INTO tkuNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pedro tzuculh chihuīna'n ē cāhuanilh: ");
INSERT INTO tkuNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Xa'icui'lācha' quit nac Jope ē xa'icorarlamā'lh e iclakachuyalh. Iclaktzī'lh hua'chi ka'tla' sábana tū yujchi nac a'kapūn. Chī'canī't ixa'katzā'stūtā'ti' ē quilakchilh. ");
INSERT INTO tkuNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Iclaktzī'lh animalh tū xamakakentā'ti' ē animalh tū tahua'nan ē lūhua' ē spūnī'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ickexmatli a'ktin tachihuīn tū quihuanilh: “Pedro, catā'kaqui' ē cama'kni' ē cahua't.” ");
INSERT INTO tkuNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Icuanilh: “E'ē, Māpa'ksīni'. Jā maktin icua'nī't tū catūhuālh ē tū jā tze.” ");
INSERT INTO tkuNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Quintā'chihuīna'mpālh ixlīmaktu' nac a'kapūn. Quihuanilh: “Jā cahua'nti jā tze tū Dios tlahuanī't tze.” ");
INSERT INTO tkuNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Huā'mā' a'kspulalh maktu'tun ē tayapalacancha' tālhmā'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Palaj tunca tachilh nac chic jā xa'icui'lāna'uj chā'tu'tun chi'xcuhuī'n tī ixquilakmacamincanī't nac Cesarea. ");
INSERT INTO tkuNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Espíritu Santo quihuanilh: “Cacātā'pi ē jā tipuhua'na': Jā icti'a'lh.” Ē quintatā'a'lh kelhachāxan tā'timīn. Ictanūj na ixchic Cornelio. ");
INSERT INTO tkuNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Xla' quincāhuanin chī laktzī'lh na ixchic chā'tin ángel tī tasu'yuni'lh ē huanilh: “Cacāmacapi chi'xcuhuī'n nac Jope ē calīminca Simón tī ka'lhī ixlī'a'ktu' ixtacuhuīni' Pedro. ");
INSERT INTO tkuNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Xla' nahuaniyān chī tzē nalī'a'kapūtaxtuya' hui'x ē ixlīpō'ktuca'n xalanī'n na minchic.” ");
INSERT INTO tkuNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Pedro cāhuanipālh: ―A'cxni' ictzuculh iclīchihuīna'n, Espíritu Santo cālakmilh chuntza' chī quincālakmin pūla. ");
INSERT INTO tkuNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Quit iclacapāstacli chī huanli Māpa'ksīni' Jesús: “Ixlīcāna' Juan ixlīmā'kpaxīni'n xcān. Hui'xina'n nalī'a'kpaxā'tit Espíritu Santo.” ");
INSERT INTO tkuNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Dios cāmaxquī'lh Espíritu Santo nā chuntza' chī quincāmaxquī'n quina'n tī a'ka'ī'ni'nī'ta'uj Jesucristo. ¿Ē tīchu quit na'iclīmāmakchuyī Dios? ―huanli Pedro. ");
INSERT INTO tkuNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","A'cxni' takexmatli huā'mā', ca'cs taquilhuanli. Palaj tunca tatzuculh tachihuīna'n chī ixlīka'tla' Dios ē tahuanli: ―Dios lacasqui'n natalakpalī ixtalacapāstacni'ca'n nā xlaca'n tī jā israelitas ē nā chuntza' nataka'lhī ixlatamatca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","A'cxni' maknīca Esteban, tzucuca cāputzatokokecan tī ixta'a'ka'ī'nī't. Xlaca'n tatzā'lalh ē ixta'a'kahuankō'nī't. Ixtalatlā'huanācha' nac Fenicia ē nac Chipre ē nac Antioquía. Cāhuanica xatze tachihuīn xmān israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Makapitzīn xlaca'n xalanī'n nac Chipre ē nac Cirene tachā'lh nac Antioquía. Cātā'chihuīna'nca tī jā israelitas. Ē cāmāsu'yuni'ca xatze tachihuīn ixla' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Jesucristo cāmaxquī'lh lītli'hui'qui ē chuntza' lhūhua' ta'a'ka'ī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Cāmāca'tzīnīca tī ixta'a'ka'ī'nī't xalanī'n nac Jerusalén tū ixlamā'lh nac Antioquía. Macā'nca Bernabé a'ntza'. ");
INSERT INTO tkuNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","A'cxni' chā'lh, laktzī'lh chī Dios ixcāsicua'lanātlahuanī't, ē pāxuhualh. Bernabé cāmaxquī'lh talacapāstacni' ē cāhuanilh: ―Calīhui'lī'tit nastālani'yā'tit Jesucristo. ");
INSERT INTO tkuNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabé tzeya chi'xcu' ixuanī't ē ixlīstacna' ixlītzuma Espíritu Santo ē ixa'ka'ī'. Lhūhua' tachi'xcuhuī't tatzuculh tatapa'ksīni' Jesucristo. ");
INSERT INTO tkuNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ā'līstān Bernabé a'lh putza Saulo nac Tarso. ");
INSERT INTO tkuNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","A'cxni' maclalh, līmilh nac Antioquía. A'ktin cā'ta Bernabé ē Saulo ixtatā'takēstoka tī ixta'a'ka'ī'nī't. Ixcāmāsu'yuni'can lhūhua' tachi'xcuhuī't. A'ntza' nac Antioquía tzucuca pūla cāmāpācuhuīcan cristianos tī ixta'a'ka'ī'tēlha. ");
INSERT INTO tkuNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tzamā' quilhtamacuj tataxtulh nac Jerusalén makapitzīn ixa'kchihuīna'nī'n Dios. Tachā'lh nac Antioquía. ");
INSERT INTO tkuNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Chā'tin, tī ixuanican Agabo, tāyalh na ixlacatīnca'n ē cāhuanilh tū ixmāca'tzīnīlh Espíritu Santo. Huanli calhāxcuhuālh na'a'nan a'ktin ka'tla' tatzi'ncstat. Chuntza' lalh a'cxni' Claudio ixmāpa'ksīni'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Tī ixta'a'ka'ī'nī't talīhui'līlh tamacā'ni' a'ktin tamaktay tā'timīn xalanī'n nac Judea. Tapuhuanli natamāstā' chuntza' chī ixtaka'lhī chā'tunu'. ");
INSERT INTO tkuNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Chuntza' tatlahualh. Bernabé ē Saulo talē'ni'lh tamaktay xanapuxcu'nu' xalanī'n nac templo. ");
INSERT INTO tkuNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Tzamā' quilhtamacuj rey, tī ixuanican Herodes, tzuculh cāchi'pa ē cāmāpātīnīn tī ixta'a'ka'ī'nī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Līmāmaknīnīni'nli cuchilu Jacobo ixtā'tin Juan. ");
INSERT INTO tkuNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","A'cxni' laktzī'lh Herodes israelitas talīpāxuhualh tū tlahualh, ā'chulā' cātlahuasti'lh. Nā Pedro māchi'panīni'nli. Huā'mā' lalh a'cxni' ixlamā'lh cā'tani' a'cxni' tahua'lh pāntzīn tū jā ixka'lhī levadura. ");
INSERT INTO tkuNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","A'cxni' Herodes ixmāchi'panīni'nī't Pedro ē māmānūnīni'lh nac pūlāchī'n. Cāmacamaxquī'ca kelhacāujchāxan tropas tī natamaktaka'lha ē ixtalālīlakpalītēlha līkelhatā'ti'n. Herodes ixpuhuan ixlīminca ixlacatīnca'n tachi'xcuhuī't a'cxni' na'a'ksputa cā'tani' tū huanican pascua. ");
INSERT INTO tkuNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Chuntza' Pedro ixmānūcanī't nac pūlāchī'n ē ixtamaktaka'lhmā'nalh. Tī ixta'a'ka'ī'nī't jā tajaxli talī'orarla ē tasqui'ni'lh Dios ixpālacata Pedro. ");
INSERT INTO tkuNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","A'ktin tzī'sni' Pedro ī'lhtatamā'lh nac pūlāchī'n. Herodes ixmāxtucu'tun ixlīlakalī. Ī'lhtatamā'lh Pedro na ixpāxtūnca'n chā'tu' tropas ē ixcātā'lāmacachī'maxquī'canī't chā'tunu' tropa. Ē a'chā'tu' tropa ixtayāna'lh ixlacapūn mākelhcha ē ixtamaktaka'lha pūlāchī'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Xamaktin tasu'yuni'lh chā'tin ángel tī Dios macamilh. A'ktin taxkaket māxkakēlh pūlāchī'n. Ángel tāpātoklhli Pedro ē mālakahuanīlh ē huanilh: ―Palaj catā'kaqui'. Taxcutli na ixmacan Pedro. ");
INSERT INTO tkuNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ángel huanilh: ―Calha'kā'na' ē catatūnu' mincaclhi'. Chuntza' tlahualh Pedro. Huanipālh ángel: ―Calha'ka' milu'xu' ē caquistāla'ni'. ");
INSERT INTO tkuNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pedro taxtulh ē ī'stālani'tēlha. Jā ixca'tzī palh ixlīcāna' tū ixtlahuamā'lh ángel. Ixpuhuan ixlakachuya. ");
INSERT INTO tkuNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Tatēlakataxtulh xapūla tropa tī ixmaktaka'lhmā'lh ē ā'līstān tatētaxtupālh ā'chā'tin. Tachilh nac mākelhcha xalīcā'n jā lactanūcan nac cā'lacchicni'. Ixa'cstu talaquī'lh. Xlaca'n tatētaxtulh nac kentin tej. Palaj ángel makxtekli Pedro. ");
INSERT INTO tkuNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","A'cxni' Pedro tzeya ca'tzīlh ē huanli: ―Chuhua'j icca'tzī Jesucristo macamilh ixángel ē quimakapūtaxtūnī't na ixlīmāpa'ksīn rey Herodes. Quimakapūtaxtūnī't tū ixquintatlahuani'cu'tun israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","A'cxni' ixlacapāstacnī'ttza' huā'mā', Pedro chā'lh na ixchic María tī ixtzī' Juan tī ixka'lhī ixlī'a'ktu' ixtacuhuīni' Marcos. A'ntza' līlhūhua' ixtastokcanī't ē ixta'orarlamā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pedro toklhli nac mākelhcha jā lactanūcan na ixtanquilhtīn chic. Chā'tin tzu'ma'jāt, tī ixuanican Rode, milh kelhasqui'nī tīchu xla'. ");
INSERT INTO tkuNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Kelhlakapasli Pedro ē pāxuhualh. Ū'tza' jā līmālaquī'ni'lh ē palaj tu'jnuntēlha tanūpālh nac chic. Cāhuanilh tī ixtatakēstoknī't: ―Layālh Pedro nac kēpūn. ");
INSERT INTO tkuNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Xlaca'n tahuanilh: ―Chuya'ya'. Rode ā'chulā' cāhuanilh ixlīcāna' ū'tza'. Palaj tunca tahuanli: ―Jā ū'tza'. Ixmāstilē'k ángel tī maktaka'lha Pedro. ");
INSERT INTO tkuNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pedro ā'chulā' palha' toklhli nac mākelhcha. A'cxni' tamālaquī'lh, talaktzī'lh Pedro ē talī'a'cnīlh. ");
INSERT INTO tkuNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pedro cāmacahuani'lh cataquilhca'cslalh. Cāhuanilh chī Dios līmāxtulh nac pūlāchī'n. Cāhuanilh: ―Camāca'tzīnī'tit Jacobo ē tā'timīn huā'mā' tū quina'kspulalh. Pedro taxtulh ē a'lh ā'lacatin. ");
INSERT INTO tkuNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Palaj a'cxni' xkakalh, tropas tatamakchuyīlh ixpālacata chī lītzā'lalh Pedro. ");
INSERT INTO tkuNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","A'cxni' Herodes māputzīni'lh Pedro ē jā maclaca ē cākelhasqui'nīlh tropas tī ixcāyāhuacanī't natamaktaka'lha ē cāmāmaknīnīni'lh. Herodes taxtulh nac Judea ē a'lh tancā'n nac Cesarea ē a'ntza' tachokolh. ");
INSERT INTO tkuNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes ixcātā'lāsītzī'nī't xalanī'n nac Tiro ē Sidón. Makapitzīn talālītā'chihuīna'nli palh tzē natalaka'n. Lī'amigos talalh Blasto tī ixmaktaka'lha jā ī'lhtata rey. Xlaca'n ixtalīmāko'xamixīcu'tun ixpālacata ixlīhua'tca'n tū līmincancha' na ixcā'lacchicni' rey. ");
INSERT INTO tkuNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Lakchā'lh quilhtamacuj tū ixcālhcāni'nī't Herodes. Ixlhakā'nī't ixlu'xu' tū ixtasu'yu chī rey ixuanī't. Tahuī'lh nac trono ē a'kchihuīna'nli. ");
INSERT INTO tkuNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Tachi'xcuhuī't tamāta'sīlh: ―Jā chi'xcu' tī chihuīna'mā'lh. Hua'chi chā'tin dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Xamaktin chā'tin ixángel Dios makata'jatatlalh Herodes ixpālacata cāmakxtekli talaktaquilhpūtalh hua'chi Dios. Lūhua' tahua'lh ē nīlh. ");
INSERT INTO tkuNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ixtachihuīn Māpa'ksīni' ta'a'kahuani'lh ē cālakchā'lh ā'makapitzīn chi'xcuhuī'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","A'cxni' Bernabé ē Saulo ixtatlahuakō'nī't ixlītlahuatca'n nac Jerusalén, xlaca'n tataspi'tli nac Antioquía. Cātā'a'lh Juan tī ixka'lhī ixlī'a'ktu' ixtacuhuīni' Marcos. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Chī ū'tunu'n tī ixtatakēstoka nac Antioquía, ixtahui'lāna'lh a'kchihuīna'nī'n ē mākelhtahua'kē'ni'nī'n. Makapitzīn ixtacuhuīni'ca'n Bernabé ē Simón (tī ixuanican Negro) ē Lucio xala' nac Cirene ē Manaén (tī tā'stacli rey Herodes) ē Saulo. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Xlaca'n ixtalaktaquilhpūtamā'nalh Dios ē ixtalīhui'līnī't jā tū natahua'. Espíritu Santo huanli: ―Iclacasqui'n Bernabé ē Saulo natatlahua xtum ixtascujūtca'n tū na'iccāmaxquī'. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Xlaca'n jāna'j tū ixtahua', ē ta'orarlīlh ē ta'a'cpūhui'līlh ixmacanca'n ē cāmacā'nca. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Espíritu Santo cāmacā'lh Bernabé ē Saulo. Xlaca'n ta'a'lh tancā'n nac Seleucia. A'ntza' tapū'a'lh barco nac Chipre, a'ntza' jā pu'nahuī'lh macsti'na'j ti'ya't. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","A'cxni' tachilh nac Salamina, talī'a'kchihuīna'nli ixtachihuīn Dios na ixtemploca'n israelitas. Talē'lh Juan ixmaktāyana'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","A'cxni' tatētaxtulh ixlīpō'ktu nac Chipre, tachilh nac cā'lacchicni' ixtacuhuīni' Pafos. Tamaclalh chā'tin chi'xcu' israelita ixtacuhuīni' Barjesús. Xla' xantilh ixuanī't ē a'kchihuīna' tū jā ixla' Dios. Xmān ixcālī'a'kskāhuī'mā'lh. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Xantilh ixmaktāya gobernador Sergio Paulo tī skalalh ixuanī't. Gobernador cāmāta'satīnīni'lh Bernabé ē Saulo ē ixkexmatcu'tun ixtachihuīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Cātā'lāhuanilh xantilh tī ixuanican Barjesús ē Elimas. Xla' jā ixlacasqui'n na'a'ka'ī' gobernador. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Saulo, tī nā ixuanican Pablo, ixlītzuma Espíritu Santo na ixlīstacna'. Xla' lakalaktzī'lh Elimas. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Huanilh: ―Hui'x a'kskāhuī'ni'na' ē jā tzeya chi'xcu'. Hui'x ixka'hua'cha skāhuī'ni' ē hui'x jā lakatīya' tū tze. ¿Chī jā līmakxteka' lactlahua'ya' tū ixla' Dios? ");
INSERT INTO tkuNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Chuhua'j Dios namakapātīnīnān. Lakatzī'n nahua'na' ē lakma'j jāla catilacahuā'na'. Xamaktin lakapoklhuana'lh ē jāla lacahuāna'lh ē ixputzatlā'huan tī ixpekechi'palē'lh. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","A'cxni' gobernador laktzī'lh tū a'kspulalh, xla' a'ka'ī'lh ē lī'a'cnīlh tū ixmāsu'yucan ixpālacata Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pablo ē tī ixtatā'a'n tataxtulh nac Pafos ē tapū'a'lh barco ē tachā'lh nac Perge ixlīka'tla' nac Panfilia. A'ntza' Juan cāmakxtekli ē taspi'tli nac Jerusalén. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pablo ē Bernabé tataxtulh nac Perge ē tachā'lh nac Antioquía ixlīka'tla' nac Pisidia. Quilhtamacuj tū pūjaxcan, xlaca'n tatanūlh na ixtemploca'n israelitas ē tatahuī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Līkelhtahua'ka'ca ixtachihuīn Dios jā tatzo'kni' līmāpa'ksīn ē jā huanican profetas. Xanapuxcu'nu' xalanī'n nac templo tamacamilh chā'tin tī cāhuanilh Pablo ē Bernabé: ―Chi'xcuhuī'n, palh cāmaxquī'cu'tunā'tit talacapāstacni' tachi'xcuhuī't, cacāhuani'tit. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pablo tāyalh ē cāmacahuani'lh cataquilhca'cslalh ē huanli: ―Cakexpa'ttit chi'xcuhuī'n israelitas ē hui'xina'n tī jicua'ni'yā'tit Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","QuinDiosca'n quina'n israelitas cālacsacli quinapapana'ca'n. Dios cāmālhūhuī'lh a'cxni' xlaca'n xamini' ixtahuanī't nac ti'ya't Egipto. Dios ka'lhī lhūhua' lītli'hui'qui ē ū'tza' tzē cālīmāxtulh nac huā'mā' ti'ya't. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Dios cālīpātīlh tu'pu'xam cā'ta a'cxni' ixtalatlā'huan nac cā'tzaya'nca ti'ya't. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Dios cāmālaksputūlh tachi'xcuhuī't xalanī'n a'ktojon cā'lacchicni' nac ti'ya't jā ixuanican Canaán. Cāmāpitzīni'lh ti'ya't quinapapana'ca'n jā natatahui'la. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Dios cāhui'līni'lh ixjuezca'n tī nacāmāpa'ksī a'ktā'ti' ciento ā'i'tāt cā'ta. A'kchihuīna' Samuel ū'tza' ā'xmān ixlīhuī'lh ixlījuez. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ā'līstān quinapapana'ca'n israelitas tasqui'nli chā'tin ixreyca'n. Dios hui'līlh ixlīrey Saúl, ixka'hua'cha Cis. Ixtalakapasni' Benjamín ixuanī't. Xla' ixmāpa'ksīni'n tu'pu'xam cā'ta. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","A'cxni' Dios māpānūlh Saúl, ē hui'līpālh David ixlīrey. Dios līchihuīna'nli David ē huanli: “Quit iclakapasa David, ixka'hua'cha Isaí. Iclaktzī'n ū'tza' chā'tin chi'xcu' tī lacapāstacna'n chī iclacapāstacna'n quit. Xla' natlahua pō'ktu tū iclacasqui'n.” Chuntza' huanli Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Dios cāmaxquī'lh israelitas chā'tin makapūtaxtūnu' chuntza' chī huanli Dios xapūla. Makapūtaxtūnu' ū'tza' Jesús, ī'xū'nātā'nat David. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","A'cxni' Jesús jāna'j ixā'min, Juan ixcāhuani ixlīpō'ktuca'n tachi'xcuhuī't israelitas: “Calakpalī'tit mintalacapāstacni'ca'n ē ca'a'kpaxtit.” ");
INSERT INTO tkuNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","A'cxni' ī'sputmā'lhtza' quilhtamacuj tū ixlīmā'kpaxīni'n Juan, xla' ixuan: “Jā quit tī puhua'ni'yā'tit. Ā'līstān namimpala ā'chā'tin tī ka'lhī lītli'hui'qui. Ū'tza' jā minī'ni' na'icxcutni' ixcaclhi'.” ");
INSERT INTO tkuNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Pablo chihuīna'mpālh: ―Iccāhuaniyān hui'xina'n tī ī'xū'nātā'natna' Abraham, chī quit, ē hui'xina'n tī jicua'ni'yā'tit Dios. Chuhua'j cātamacamini'nī'ta'n tachihuīn tū nalī'a'kapūtaxtucan. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Xalanī'n nac Jerusalén ē nā ī'scujni'ca'n jā ixtaca'tzī tī Jesús. Jā takexmatli ixtachihuīnca'n ixa'kchihuīna'nī'n Dios tū līkelhtahua'ka'can pō'ktu quilhtamacuj tū pūjaxcan. Ū'tza' līmāmaknīnīni'nca Jesús. Chuntza' tamākentaxtūlh chuntza' chī tahuanli a'kchihuīna'nī'n xamakāstza'. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Masqui jāla tamaclani'lh chī natalīmaknī Jesús, xlaca'n tasqui'ni'lh Pilato camaknīca. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","A'cxni' xlaca'n ixtamākentaxtūnī'ttza' ixlīpō'ktu tū ixtatzo'kni' natatlahuani' Jesús, māyujūca Jesús xanīn nac cruz ē mānūca nac lhu'cu'. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Dios mālacastālancuanīlh. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","A'klhūhua' quilhtamacuj ixcātasu'yuni' tī ixcātā'taxtunī't nac Galilea ē ixcātā'a'nī't nac Jerusalén. Huā'mā' chi'xcuhuī'n ū'tunu'n tī tamāsu'yuni'mā'nalh chuhua'j tachi'xcuhuī't ixpālacata Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Chuhua'j quina'n iccāhuaniyān hui'xina'n xatze tachihuīn ixpālacata tū cāhuanilh Dios quinapapana'ca'n namāstā'. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ū'tza' Dios quincāmākentaxtūni'n quina'n, tī ī'xū'nātā'natna'ca'n, a'cxni' mālacastālancuanīlh Jesús. Chuntza' tatzo'kni' nac libro Salmos ixlī'a'ktu' capítulo: Hui'x quinKa'hua'cha. Chuhua'j icmaxquī'nī'ta'n latamat. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Dios mālacastālancuanīlh Jesús nac cā'līnīn. Jā ā'maktin cati'a'lh nac cā'līnīn. Dios chuntza' huanli: Na'iccāsicua'lanātlahuayān chuntza' chī huanica David. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Tatzo'kni' nac libro Salmos ā'a'ktin capítulo: Hui'x jā catimakxtekti namasa ixmacni' minKa'hua'cha tī tze. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","David ixtlahuanī'ttza' ixtalacasqui'nīn Dios ixlacatīnca'n xlaca'n tī ixtahui'lāna'lh a'cxni' xla' ixlatlā'huan nac cā'quilhtamacuj. Xla' nīlh ē mā'cnūca jā ixcāmā'cnūcanī't ixnatāta'na'. Ixmacni' David masli. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Jā masli ixmacni' Jesús tī Dios mālacastālancuanīlh. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Caca'tzītit hui'xina'n tī israelitas chī quit. Ixpālacata huā'mā' chi'xcu', cātamāca'tzīnīyān hui'xina'n mincuentaca'n tzē nacātamātza'nkēna'ni'yān. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Jesús cāmātza'nkēna'ni' ixlīpō'ktu ixcuentaca'n tī talīpāhuan Jesús. Līmāpa'ksīn tū maxquī'ca Moisés, ū'tza' jāla catimālaksputūlh tū jā tze. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Caskalalhuantit jā nacā'a'kspulayān tū tahuanli a'kchihuīna'nī'n. Tahuanli: ");
INSERT INTO tkuNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Cakexpa'ttit hui'xina'n tī lakmaka'nā'tit. Ca'a'cnī'tit ē calaksputtit; ixpālacata quit, Dios, na'ictlahua a'ktin lī'a'cnīn a'cxni' hui'xina'n hui'lā'na'ntit. Palh ixcātahuani'n tū quit na'ictlahua, hui'xina'n jā cati'a'ka'ī'tit. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pablo ē Bernabé tataxtulh na ixtemploca'n israelitas. Tachi'xcuhuī't, tī jā israelitas, tasqui'ni'lh natahuanipala huā'mā' tachihuīn ixlītzayama'j. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Tataxtulh tī ixtatakēstoknī't nac templo. Tastālani'lh Pablo ē Bernabé lhūhua' israelitas ē ā'makapitzīn tī ixta'a'ka'ī'nī't chī israelitas. Pablo cāmaxquī'lh talacapāstacni' ē cāhuanilh jā catamakxtekli xatze tachihuīn tū māsu'yu ixtalakalhu'mān Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ixlītzayama'j, a'cxni' ixchā'n quilhtamacuj tū ixpūjaxcan, ixlīpō'ktuca'n xalanī'n nac cā'lacchicni' tatakēstokli natakexmata ixtachihuīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","A'cxni' israelitas talaktzī'lh ixlīlhūhua'ca'n tachi'xcuhuī't, xlaca'n talaksītzī'lh ē tatā'lāhuanilh Pablo ē talakapalalh. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pablo ē Bernabé tachihuīna'nli ē jā tajicua'nli ē cāhuanica: ―Ixlacasqui'nca cacātahuanin xapūla hui'xina'n, israelitas, ixtachihuīn Dios. Hui'xina'n lakmaka'ntit, ē chuntza' lītasu'yu jā ka'lhīcu'tunā'tit xasāsti' milatamatca'n tū jā catilaksputli. Chuhua'j quina'n na'iccālaka'nāuj tī jā israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Chuntza' quinDiosca'n quincāmāpa'ksīn ē huanli: Quit iclacsacnī'ta'n nacāmāca'tzīnī'ya' chī natalī'a'kapūtaxtu xalanī'n nac ā'lacatunu' cā'lacchicni' na ixlīka'tla' cā'quilhtamacuj. Chuntza' hui'x chī a'ktin pūcās chī namāxkakēni'na' ixlīpō'ktu. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","A'cxni' takexmatli huā'mā', tapāxuhualh tī jā israelitas. Tahuanli tze ixtachihuīn Dios. Ta'a'ka'ī'lh ixlīpō'ktuca'n tī ixcāhui'līcanī't natamaktīni'n xasāsti' ixlatamatca'n tū jā catilaksputli. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Māca'tzīnīni'nca ixtachihuīn Māpa'ksīni' calhāxcuhuālh jā ixmāpa'ksī Antioquía. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Israelitas tachihuīna'makasītzī'lh xalaka'tla' puscan tī ixtalakachi'xcuhuī' Dios ē nā xanapuxcu'nu' cā'lacchicni'. Tachihuīna'makasītzī'lh cacāputzatokokeca Pablo ē Bernabé ē cāmakatzā'laca na ixcā'lacchicni'ca'n ē nā a'ntza' jā ixtamāpa'ksī. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pablo ē Bernabé tatincxli pokxni' ixtujanca'n ē chuntza' cāmāca'tzīnīca xalanī'n cā'lacchicni' ixtalē'n cuenta. Ta'a'lh nac Iconio. ");
INSERT INTO tkuNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Tā'timīn tapāxuhualh. Ixlīstacna'ca'n ixlītzuma Espíritu Santo. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pablo ē Bernabé lacxtim tatanūlh na ixtemploca'n israelitas nac Iconio ē ta'a'kchihuīna'nli. Ta'a'ka'ī'lh lhūhua' israelitas ē nā tī jā israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Israelitas tī jā ixta'a'ka'ī' tachihuīna'makasītzī'lh tī jā israelitas. Cāmālacapāstaquīca tā'timīn jā tze ixtahuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pablo ē Bernabé tatahuī'lh a'klhūhua' quilhtamacuj nac Iconio ē ixta'a'kchihuīna'n ē jā tajicua'nli ixpālacata ixtalīpāhuan Jesucristo. Ixlītli'hui'qui Dios lhūhua' ixtalītlahua tū laka'tla' lī'a'cnīn. Ū'tza' līmāsu'yulh Dios ixlīcāna' tū ixtalīchihuīna'n Pablo ē Bernabé ixpālacata Jesucristo. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Tachi'xcuhuī't xalanī'n nac Iconio jā lacxtim ixtalacapāstaca. Makapitzīn ixtalacapāstaca chī israelitas ē ā'makapitzīn ixtalacapāstaca chī apóstoles. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Israelitas ē nā tī jā israelitas ē nā xanapuxcu'nu' tachihuīna'nli natalacatā'quī'nin ē natacucta'lana'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","A'cxni' taca'tzīlh huā'mā', Pablo ē Bernabé tatzā'lalh. Ta'a'lh nac estado Licaonia nac cā'lacchicni' Listra ē Derbe ē ā'lacatunu' cā'lacchicni'. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","A'ntza' ixtalī'a'kchihuīna'n xatze tachihuīn ixla' Jesucristo. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ixuī'lh chā'tin chi'xcu' nac Listra. Jā tze ixuanī't ixtujan. Ixlū'ntū'nunī't chu tunca ixlīlacatuncuhuī'ni'. Jā maktin ixtlā'huan. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ixkexmatmā'lh Pablo. Pablo lakalaktzī'lh ē ca'tzīlh ixa'ka'ī' tzē namātzeyīcan. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Pablo palha' huanli: ―Laclhtzaj catāya'. Chi'xcu' tāyalh ē tzuculh tlā'huan. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","A'cxni' ixlīlhūhua'ca'n talaktzī'lh tū tlahualh Pablo, xlaca'n tata'salh ē tahuanli chī ixtachihuīnca'n xalanī'n nac Licaonia. Tahualh: ―¡Tayujnī'ta'nchi dioses tī tatasu'yu chī chi'xcuhuī'n! ");
INSERT INTO tkuNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ixtahuan Bernabé ixuanī't ū'tza' dios Júpiter. Ē ixtahuan Pablo ixuanī't ū'tza' dios Mercurio ixpālacata ū'tza' tī ixa'kchihuīna'nī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Templo jā ixlaktaquilhpūtacan dios Júpiter, ixyālh jā lactanūcanācha' nac cā'lacchicni'. Ixcura Júpiter līmilh huācax ē xa'nat nac tanquilhtīn. Pālej ē tachi'xcuhuī't ixtalakachi'xcuhuī'cu'tun apóstoles. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","A'cxni' apóstoles, Bernabé ē Pablo, taca'tzīlh tū ixcātlahuani'cu'tuncan, xlaca'n talacxtī'tli ixlīmānca'n ixlu'xu'ca'n ixpālacata tatamakchuyīlh. Tatu'jnulh ixlacpu'na'i'tātca'n tachi'xcuhuī't ē tata'salh ē tahuanli: ");
INSERT INTO tkuNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―¡Tachi'xcuhuī't! ¿Tū ixpālacata tlahua'yā'tit huā'mā'? Quina'n nā chi'xcuhuī'n chuntza' chī hui'xina'n. Iccālīmini'yān xatze tachihuīn ixpālacata nalītalakaspi'tni'yā'tit ixlīpō'ktu huā'mā' tū jā tū ixtapalh tū tlahua'yā'tit. Ē chuntza' naputzayā'tit Dios tī lakahuan. Ū'tza' tī tlahuanī't a'kapūn ē cā'ti'ya't ē mar ē ixlīpō'ktu tū a'nan. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Lakma'jtza' Dios cāmakxteknī't ixlīpō'ktuca'n tachi'xcuhuī't natatlahua tū talacasqui'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pō'ktu quilhtamacuj Dios ixcāmacā'ni' tū ixmāsu'yu palh a'nan Dios. Dios tlahua tū tze. Ū'tza' līla xcān ē līla tū tzē hua'can. Quincāmaxquī'yān quina'n tapāxuhuān ē tū hua'yāuj hasta līpāxuhua hui'lāna'uj ―huanli Pablo. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Masqui Pablo cāhuanilh huā'mā', ē jicslīhua' cālīmāpānūni'ca ixtalacapāstacni'ca'n tachi'xcuhuī't jā catalakachi'xcuhuī'lh Pablo ē Bernabé. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Tachilh makapitzīn israelitas xalanī'n nac Antioquía ē Iconio. Tachihuīna'makasītzī'lh tachi'xcuhuī't. Ū'tza' līcucta'laca Pablo ē sakalē'nca ē māxtuca nac cā'lacchicni' ē makxtekca. Tapuhuanli xanīntza' ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Tā'timīn talītamacsti'li'lh ē Pablo tā'kaquī'lh ē tanūlh nac cā'lacchicni'. Ixlīlakalī ta'a'lh Pablo ē Bernabé nac Derbe. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ixta'a'kchihuīna'n xatze tachihuīn ixla' Jesucristo nac tzamā' cā'lacchicni' ē lhūhua' ta'a'ka'ī'lh. Palaj tunca xlaca'n tataspi'tli nac Listra ē nac Iconio ē nac Antioquía. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","A'ntza' ixcāmaxquī'ca tā'kpuhuantīn tī ixta'a'ka'ī'. Ixcāmaxquī' talacapāstacni' nata'a'ka'ī' pō'ktu quilhtamacuj. Cāhuanica: ―Ixlacasqui'nca napātīni'nāuj a'cxni' jāna'j tanūyāuj jā Dios māpa'ksīni'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Cālacsacca xanapuxcu'nu' a'katunu' nac templo. Pūla ta'orarlīlh ē jā tahuā'yalh. Tasqui'ni'lh Māpa'ksīni' Jesucristo tī ixta'a'ka'ī'nī't. Tasqui'ni'lh cacāmaktaka'lhli xanapuxcu'nu'. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Palaj tunca Pablo ē Bernabé tatētaxtulh nac Pisidia ē tamilh nac Panfilia. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","A'cxni' ixtalī'a'kchihuīna'nī't xatze tachihuīn nac Perge, ē ta'a'lh tancā'n nac Atalia. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","A'ntza' tapū'a'lh barco nac Antioquía. Chu ū'tza' cā'lacchicni' ixuanī't jā xapūla ī'squi'ni'canī't Dios cacāmaktāyalh Bernabé ē Pablo ixtascujūtca'n tū chū'cus ixtatlahuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","A'cxni' tachā'lh Pablo ē Bernabé nac Antioquía, tamākēstokli ixlīpō'ktuca'n tī ixta'a'ka'ī'. Cāhuanica ixlīpō'ktu tū Dios ixcāmaktāyanī't natatlahua. Cāhuanica chī Dios ixcāmāsu'yuni'nī't ixlacasqui'nca nā nata'a'ka'ī' nā xlaca'n tī jā israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","A'ntza' Pablo ē Bernabé tatā'tachokokō'lh tā'timīn makās. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tamilh nac Antioquía makapitzīn chi'xcuhuī'n xalanī'n nac Judea. Tatzuculh tamāsu'yuni' tā'timīn. Tahuanli: ―Ixlacasqui'nca natachu'cuyā'tit chuntza' chī ixmāsu'yu Moisés. Palh jā tachu'cunī'ta'ntit, jāla cati'a'kapūtaxtutit. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pablo ē Bernabé talālīhuanilh xlaca'n ē talālīquilhnīlh. Ā'līstān cālacsacca Pablo ē Bernabé ē ā'makapitzīn huampala tī natalaka'n apóstoles ē xanapuxcu'nu' xala' nac templo nac Jerusalén ē natakelhasqui'nīni'n chī nalīlacāxtlahuacan. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Chuntza' tā'timīn xalanī'n nac templo nac Antioquía tamacā'lh Pablo ē Bernabé. Xlaca'n ta'a'lh ē ixtatētaxtumā'nalh ixā'tuntamacni' estado Fenicia ē Samaria. Ixcāhuani chī ixta'a'ka'ī'nī't tī jā israelitas. Ū'tza' talīpāxuhualh tā'timīn. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","A'cxni' Pablo ē Bernabé tachā'lh nac Jerusalén ē talālakchā'lh tā'timīn ē apóstoles ē xanapuxcu'nu' xala' nac templo. Pablo ē Bernabé tahuanilh ixlīpō'ktu tū Dios cāmaktāyalh tzē natatlahua. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Tatāyalh makapitzīn tī ī'stālani' ixtamāsu'yunca'n fariseos ē ixta'a'ka'ī'. Tahuanli: ―Ixlacasqui'nca nacāchu'cucan israelitas nā xlaca'n tī jā israelitas. Nā ixlacasqui'nca catakexmatni'lh līmāpa'ksīn tū maxquī'ca Moisés. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Apóstoles ē xanapuxcu'nu' tatakēstokli nataputzāna'nī huā'mā'. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ixtachihuīna'mā'nalhcus ē tāyalh Pedro ē cāhuanilh: ―Tā'timīn, hui'xina'n ca'tzīyā'tit makāstza' Dios lacsacli chā'tin chī quina'n. Quit quilacsacli na'iccāhuani xatze tachihuīn tī jā israelitas ē chuntza' tzē nata'a'ka'ī' xlaca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Dios, tī lakapasa ixlīstacna'ca'n tachi'xcuhuī't, ū'tza' cāmaxquī'lh xlaca'n Espíritu Santo chuntza' chī quincāmaxquī'nī'ta'n. Chuntza' māsu'yulh Dios chī lacasqui'n nata'a'ka'ī' nā xlaca'n tī jā israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Chuntza' Dios nā līche'kē'lh ixlīstacna'ca'n xlaca'n chī quina'n ixpālacata līpāhuanāuj Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","¿Chī puhua'nā'tit hui'xina'n jā tze chī Dios lacasqui'n nata'a'ka'ī' nā xlaca'n tī jā israelitas? ¿Tū ixpālacata lacasqui'nā'tit hui'xina'n xlaca'n natamākentaxtū līmāpa'ksīn tū maxquī'ca Moisés? Ū'tza' quinatāta'na'ca'n jāla tamākentaxtūlh. Nā quina'n jāla catimākentaxtūj. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ica'ka'ī'yāuj ta'a'kapūtaxtuyāuj quina'n chuntza' chī xlaca'n ixpālacata quincāmakapūtaxtūcu'tunni' quiMāpa'ksīni'ca'n Jesús ―huanli Pedro. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Palaj tunca ixlīpō'ktuca'n ixlīlhūhua'ca'n tachi'xcuhuī't taquilhca'cslalh. Xlaca'n takexmatli a'cxni' Bernabé ē Pablo tachihuīna'nli ē tahuanli laka'tla' lī'a'cnīn tū Dios cāmaktāyalh tzē tatlahua na ixlacpu'na'i'tātca'n tī jā israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","A'cxni' xlaca'n tachihuīna'nkō'lh, Jacobo kelhtīni'lh: ―Tā'timīn, caquilākexmatui. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Chihuīna'nī'ttza' Simón Pedro chī Dios xapūla cālacsacli makapitzīn chi'xcuhuī'n tī jā israelitas. Dios cālacsacli ixpālacata ixlacstīn natahuan. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Chuntza' tahuanli a'kchihuīna'nī'n xalanī'n makāstza'. Ē chuntza' tatzo'kni': ");
INSERT INTO tkuNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Ā'līstān na'ictaspi'ta ē na'ictlahuapala ixchic David tū laclalh. Na'iccāxtlahuapala jā laclanī't, ē na'icyāhuapala. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Chuntza' ā'makapitzīn chi'xcuhuī'n nataputza Māpa'ksīni', ē nā ixlīpō'ktuca'n xalanī'n nac ā'lacatunu' cā'lacchicni' tī cālakapascan ū'tunu'n quintachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Huā'mā' huanli Māpa'ksīni' tī māsu'yulh huā'mā' a'cxni' tzuculh quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jacobo chihuīna'mpālh: ―Ū'tza' quit quintalacapāstacni': jā cacāmāmakchuyīuj tī tatā'a'n Dios tī jā israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Icpuhuan natzo'kāuj ē nacāhuaniyāuj jā catahua'lh tū cālakahui'līcanī't ídolos ē nā jā cataputzalh ixtā'lāpāxquī'nca'n ē nā jā catahua'lh xaquinīt animalh tū a'kpixchī'canī't ē nā jā catahua'lh ka'lhni'. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Chuntza' icpuhuan ixpālacata makās na ixlīpō'ktu cā'lacchicni', pō'ktu quilhtamacuj tū pūjaxcan, a'kchihuīna'ncan ē kelhtahua'ka'can tū huanli Moisés ―cāhuanilh Jacobo. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Apóstoles ē xanapuxcu'nu' ē ixlīpō'ktuca'n talīhui'līlh talacsaca makapitzīn chi'xcuhuī'n ixlī'ū'tunu'nca'n ē nacātā'macā'ncan Pablo ē Bernabé nac Antioquía. Macā'nca Judas, tī ixka'lhī ixlī'a'ktu' ixtacuhuīni' Barsabás, ē ā'chā'tin ixtacuhuīni' Silas. Tzamā' chā'tu' chi'xcuhuī'n xalaka'tla' lītā'timīn ixtahuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Tzo'kca a'ktin carta tū talē'lh Judas ē Silas. Ē a'ntza' nac carta tahuanli: “Quina'n apóstoles ē xanapuxcu'nu' ē tā'timīn iccāmacā'ni'yāchā'n saludos hui'xina'n tā'timīn tī jā israelitas xalanī'n nac Antioquía ē nac estado Siria ē Cilicia. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ickexmatnī'ta'uj makapitzīn tataxtunī't huā'tzā' masqui quina'n jā iccāmaxquī'uj līmāpa'ksīn. Xlaca'n cātalīmāmakchuyīnī'ta'n tū ixtamāsu'yunca'n. Ē cātalīlakpalīcu'tunān a'cxni tahuanli ixlacasqui'nca hui'xina'n natlahuayā'tit ixtahui'latca'n israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","A'cxni' quina'n ictakēstokui, iclīhui'līuj iclacsacāuj chi'xcuhuī'n tī na'iccālakmacā'nāchā'n hui'xina'n ē natatā'a'n Bernabé ē Pablo tī cāpāxquī'yāuj. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Huā'mā' chā'tu' chi'xcuhuī'n tatanūnī't jā cā'lījicua' ixpālacata quiMāpa'ksīni'ca'n Jesucristo. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Iccāmacā'nī'ta'nchāuj Judas ē Silas. Xlaca'n nacāhuaniyān ū'tza' tū iccātzo'knuni'mā'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Na'iccāmaxquī'yān hui'xina'n a'ktin līmāpa'ksīn chuntza' chī ixtalacasqui'nīn Espíritu Santo ē nā chuntza' quintalacapāstacni'ca'n. Chu xmān huā'mā' ixlacasqui'nca: ");
INSERT INTO tkuNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","hui'xina'n jā catihua'tit quinīt tū cālakahui'līcanī't ídolos, ē jā cahua'tit ka'lhni', ē jā cahua'tit ixquinīt animalh tū a'kpixchī'canī't, ē jā caputzatit mintā'lāpāxquī'nca'n. Palh hui'xina'n namākentaxtūyā'tit huā'mā', natlahuayā'tit tū tze. Xmān huā'mā' iccāhuaniyān.” ");
INSERT INTO tkuNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Cāmacā'nca Bernabé ē Pablo ē ā'makapitzīn. Xlaca'n ta'a'lh tancā'n nac Antioquía. A'ntza' cāmākēstokca tachi'xcuhuī't tī ixta'a'ka'ī' ē cāmaxquī'ca carta. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Xlaca'n talīkelhtahua'ka'lh ē tapāxuhualh ixpālacata cāmāko'xamāka'tlī'ca. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas ē Silas nā xlaca'n a'kchihuīna'nī'n ixtahuanī't. Xlaca'n tamāstā'lh talacapāstacni' ixpālacata lītā'timīn ē nā tamāstā'lh lītli'hui'qui. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","A'cxni' ixtahui'lāna'lhtza' makās a'ntza', cāmakxtekca tā'timīn ē cāhuanica: “Dios cacālē'ncha'n.” Ē talaktaspi'tpālh tī ixcāmacā'nī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Silas puhuanli natachoko a'ntza'. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pablo ē Bernabé tatachokolh nac Antioquía. Ē lhūhua' ā'makapitzīn huampala ixtamāsu'yu ē ixtalīchihuīna'n ixtachihuīn Māpa'ksīni'. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","A'cxni' ixa'kspulanī'ttza' lakma'j quilhtamacuj, Pablo huanilh Bernabé: ―Cacālaka'mpalauj quintā'timīnca'n na ixlīpō'ktu cā'lacchicni' jā māsu'yunī'ta'uj ixtachihuīn Māpa'ksīni'. Ca'a'uj cālaktzī'nāuj chī tataxtukō'. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabé ixlē'ncu'tun Juan, tī ixka'lhī ixlī'a'ktu' ixtacuhuīni' Marcos. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pablo jā ixlē'ncu'tun ixpālacata Marcos ixcāmakxteknī't a'cxni' ixtahui'lāna'lh nac Panfilia. Jā a'lh cātā'scuja. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Talālītā'chihuīna'lh Bernabé ē Pablo. Ū'tza' talītaxtumlīlh. Bernabé lē'lh Marcos ē tapū'a'lh barco nac Chipre. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pablo lacsacli Silas ē tataxtulh. Tā'timīn ixtasqui'ni'nī't Dios cacāmaktaka'lhli. ");
INSERT INTO tkuNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pablo ē Silas ixtatētaxtu nac estado Siria ē Cilicia ē ixcāmaxquī' tā'kpuhuantīn tā'timīn tī a'ntza' ixtatakēstoka nac a'katunu' cā'lacchicni'. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pablo ē Silas tachā'lh nac Derbe ē Listra. Talāpāxtokli chā'tin ixta'tinca'n ixtacuhuīni' Timoteo, ixka'hua'cha chā'tin puscāt israelita tī ixa'ka'ī'. Ixtāta' Timoteo griego ixuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Tā'timīn nac Listra ē nac Iconio tzeya chi'xcu' ixtalaktzī'n Timoteo. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablo ixlē'ncu'tun Timoteo. Israelitas ixtaca'tzī ixtāta' Timoteo jā israelita ixuanī't. Ū'tza' Pablo līmāchu'cunīni'lh Timoteo ixpālacata naka'lhī ixlīlakapascan chī israelita. Pablo tlahualh huā'mā' ixpālacata jā cāmāsītzī'cu'tunli israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Xlaca'n ixtatētaxtumā'nalh a'katunu' cā'lacchicni'. Ixcāmāca'tzīnīcan līmāpa'ksīn tū ixtahuanī't apóstoles ē xanapuxcu'nu' nac Jerusalén. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Chuntza' tī ixtatakēstoka nac a'katunu' cā'lacchicni' tatahuixcānīlh ē ā'chulā' ta'a'ka'ī'lh. Lakalī lakalī talhūhua'ntēlhalh. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Espíritu Santo jā cāmakxtekli natalīchihuīna'n xatze tachihuīn nac Asia. Pablo ē tī ixtatā'a'n tatētaxtulh na ixlīka'tla' Frigia ē Galacia. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","A'cxni' tachā'lh na ixlītapitzi jā ixmāpa'ksī Misia, ē tita'a'ncu'tunli nac Bitinia. IxEspíritu Jesús jā cāmakxtekli nata'a'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Tatētaxtulh nac Misia ē ta'a'lh tancā'n nac cā'lacchicni' Troas. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","A'ntza' tzī'sa Pablo lakachuyalh ē laktzī'lh chā'tin chi'xcu' xala' nac Macedonia tī tāyalh ixlacatīn. Chi'xcu' ī'squi'ni'mā'lh ē huanilh: “Caquilālaka'uj nac Macedonia ē caquilāmaktāyauj.” ");
INSERT INTO tkuNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","A'cxni' lakachuyakō'lh, palaj tunca quina'n ictacāxui na'ica'nāuj nac estado Macedonia. Palaj tunca iclacapāstacui ixlīcāna' Dios quincālacsacnī'ta'n na'iccālītā'chihuīna'nāuj xalanī'n nac Macedonia xatze tachihuīn ixla' Jesucristo. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ictaxtūj nac Troas ē icpū'a'uj barco ē lacatza'j icmiuj nac Samotracia. Ixlīlakalī huampala ica'uj nac Neápolis. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ictaxtūj a'ntza' ē icchā'uj nac Filipos tū tapa'ksī' nac Roma. Ū'tza' ā'chulā' xaka'tla' cā'lacchicni' ixlīpō'ktu estado Macedonia. Ictachokouj nac huā'mā' cā'lacchicni' a'klhūhua' quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","A'ktin quilhtamacuj tū tapūjaxa israelitas, ictaxtūj nac cā'lacchicni'. Icchā'uj na ixquilhtūn ka'tla' xcān jā icpuhuanui palhāsā' a'ntza' jā ixtakēstokcan ixtlahuacan oración. Ictahui'lauj ē iccātā'chihuīna'uj puscan tī ixtatakēstoknī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Chā'tin chī xlaca'n, tī ixquincākexmatni'yān, chā'tin puscāt ixtacuhuīni' Lidia. Xla' xala' nac Tiatira ē ī'stā' lu'xu' xasmataka. Ixlakachi'xcuhuī' Dios. Māpa'ksīni' mākexmatīcu'tunli tū huanli Pablo. Kexmatni'lh. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Xla' a'kpaxli ē ixlīpō'ktu tī xalanī'n na ixchic. Lidia quincāsqui'ni'n ē quincāhuanin: ―Palh puhua'nā'tit hui'xina'n quit ixlīcāna' ica'ka'ī'ni' Jesucristo, capintit na quinchic ē natachokoyā'tit a'ntza'. Chuntza' ixquincāhuaniyan. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","A'ktin quilhtamacuj a'cxni' xa'ica'mā'nauj jā ixtlahuacan oración, ictā'lāpāxtokui chā'tin tzu'ma'jāt tī ixka'lhī tū jā tzeya ū'ni' tū ixmāhuanī tū na'a'kspula. Chi'xcuhuī'n, tī ixtēcu'nī'n tzu'ma'jāt, lhūhua' ixtalītlaja ixpālacata ixca'tzī tū na'a'kspula. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Tzu'ma'jāt ixquincāstālani'yān a'cxni' xa'ictā'latlā'huanāuj Pablo. Palha' ixta'sa ē ixuan: ―Tzamā' chi'xcuhuī'n tatā'scuja Dios tī ka'tla'. Xlaca'n cātahuaniyān chī tzē nalī'a'kapūtaxtucan. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Chuntza' ixuan a'klhūhua' quilhtamacuj. Pablo jiclhualh ē talakspi'tli ē huanilh tū jā tzeya ū'ni': ―Na ixtacuhuīni' Jesucristo iclīhuaniyān cataxtu na ixlīstacna' tzu'ma'jāt. Palaj tunca taxtulh. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","A'cxni' taca'tzīlh ixtēcu'nī'n jātza' la ixtalītlaja, cāchi'paca Pablo ē Silas ē cālīminca nac pūchihuīn. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","A'cxni' ixcālīmincanī't ixlacatīnca'n scujnī'n cāhuanica: ―Tzamā' chi'xcuhuī'n israelitas cāmāmakchuyīlh xalanī'n na quincā'lacchicni'ca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Tamāsu'yu ā'xtum tahuilat tū quina'n jāla a'ka'ī'yāuj ixpālacata quina'n romanos. Jāla catitlahuáuj ixpālacata jā chuntza' quilīmāpa'ksīnca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Chuntza' tachi'xcuhuī't tatā'kaquī'lh ē cāquiclhlaktzī'nca Pablo ē Silas. Scujnī'n tamāpa'ksīni'lh cacāxtī'tpūxtuca ixlu'xu'ca'n ē cacālīmacni'cca qui'hui'. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","A'cxni' cāhui'līni'kō'ca ē cāmānūca nac pūlāchī'n. Nā māpa'ksīca tī maktaka'lhnan tzej cacāmaktaka'lhca. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Chuntza' māpa'ksīca, ē ū'tza' cālīmānūlh ā'xmāntza' ē cāmānūni'ca ixtujanca'n jā ixlaclhu'cu'canī't kentu' qui'hui' ē ixmāpekstokcanī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","I'tāt tzī'sa, Pablo ē Silas ixta'orarlītanūmā'nalh ē ixtapixtlī'tanūmā'nalh ē nā ixtamakapāxuīmā'nalh Dios. Tachī'nī'n ixtakexmattanūmā'nalh. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Xamaktin tzuculh tachiqui ti'ya't. Ixtūtzā'n talhta'm pūlāchī'n tasakā'līlh. Palaj tunca pūlāchī'n talaquī'lh. Qui'hui' jā ixcāmānūcanī't ixtujanca'n ixlīpō'ktuca'n tachī'nī'n palaj tunca talakxtulh. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Palaj tunca lakahuanli tī maktaka'lhnan ē laktzī'lh laquī'yālh pūlāchī'n. Māxtulh ixcuchilu ē ixlīmān ixmaknīcu'tuncan ixpālacata xla' puhuanli tachī'nī'n ixtatzā'lanī'ttza'. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pablo ta'salh palha' ē huanilh: ―Jā tū catlahua'ni'ca milīmān. Quilīpō'ktuca'n ictanūmā'nauj huā'tzā'. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Maktaka'lhna' squi'nli a'ktin pūcās ē tanūlh palaj ē ī'xpipitēlha cātatzokostani'lh Pablo ē Silas. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Cāmāxtulh ē cākelhasqui'nīlh: ―Chi'xcuhuī'n, ¿tū ixlacasqui'nca na'ictlahua quit na'ica'kapūtaxtu? ");
INSERT INTO tkuNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Xlaca'n takelhtīlh: ―Ca'a'ka'i' Māpa'ksīni' Jesucristo ē na'a'kapūtaxtuya' hui'x ē nā chuntza' xalanī'n na minchic. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Lītā'chihuīna'nca ixtachihuīn Dios tī maktaka'lhnan ē ixlīpō'ktuca'n xalanī'n na ixchic. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Tzamā' tzī'sa, tī maktaka'lhnan cālē'lh Pablo ē Silas ē cāche'kē'ni'lh jā ixcāmātakāhuī'canī't. Ixlīpō'ktuca'n tī ixtahui'lāna'lh na ixchic ta'a'kpaxkō'lh palaj tunca. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tī maktaka'lhnan cālē'lh na ixchic ē cāmāhuī'lh. Pāxuhualh xla' ē ixlīpō'ktuca'n xalanī'n na ixchic ixpālacata ta'a'ka'ī'ni'lh Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","A'cxni' xkakalh, scujnī'n tamacā'lh mayūlhnu' natahuani tī maktaka'lhnan: ―Cacāmakxtekti tzamā' chi'xcuhuī'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Tī maktaka'lhnan māca'tzīnīlh Pablo ē huanli: ―Scujnī'n tamāpa'ksīni'lh na'iccāmakxtekān. Chuhua'j cataxtutit ē capintit ē Dios cacālē'ncha'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pablo cāhuanilh mayūlhnu': ―Quincātamacni'cnī'ta'n na ixlacatīnca'n tachi'xcuhuī't ē quincātamānūn nac pūlāchī'n ē jā quincātatlahuani'n justicia, masqui quina'n ictapa'ksīyāuj nac Roma ē ū'tza' iclīka'lhīyāuj quintachihuīnca'n. Chuhua'j tzē'k quincātamakatzā'lacu'tunān. Chuhua'j catamilh ū'tunu'n ē caquincātamāxtun. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Mayūlhnu' tamāca'tzīnīpālh scujnī'n. Xlaca'n tajicua'nli a'cxni' takexmatli tachī'nī'n ixtatapa'ksī nac Roma ē jā catīhuālh chi'xcuhuī'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Cālakminca Pablo ē Silas ē cāsqui'ni'ca tamātza'nkēn. Cāmāxtuca ē cāsqui'ni'ca catataxtulh nac cā'lacchicni'. ");
INSERT INTO tkuNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pablo ē Silas, a'cxni' ixtataxtunī'ttza' nac pūlāchī'n, tatanūlh na ixchic Lidia. Cālaktzī'nca tā'timīn. Pablo ē Silas tamāstā'lh talacapāstacni' ē ta'a'lh. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pablo ē Silas tatētaxtulh nac Anfípolis ē Apolonia. Tachā'lh nac Tesalónica jā ixyālh a'ktin ixtemploca'n israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pablo ixlīsmanīnī't tanū nac templo ē chuntza' cātā'tanūlh. A'ktin quilhtamacuj tū pūjaxcan, Pablo cālītā'chihuīna'lh ixtachihuīn Dios. Chuntza' tlahuapālh ixlītzayama'j ē ixlīcāujquitzisma'j. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Pablo cāmāsu'yuni'lh ē cāmāca'tzīnīlh ixlacasqui'nca napātīni'n ē nalacastālancuana'n Cristo tī Dios lacsacnī't. Cāhuanilh: ―Huā'mā Jesús, tī iccālītā'chihuīna'nān, xla' ū'tza' Cristo. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ā'makapitzīn ta'a'ka'ī'lh tū huanli Pablo. Talītastokli Pablo ē Silas. Nā chuntza' cāmākēxtimīlh lhūhua' tī jā israelitas ē ixtalakachi'xcuhuī' Dios. Makapitzīn puscan xalaka'tla' nā xlaca'n cāmākēxtimīlh Pablo ē Silas. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Israelitas tī jā ixta'a'ka'ī', xlaca'n taquiclhlaktzī'lh ē talē'lh ā'makapitzīn tī jā tzeya chi'xcuhuī'n ē tī xmān ixtalatlā'huan. Tamākēstokli lhūhua' tachi'xcuhuī't ē tatā'kaquī'lh nac cā'lacchicni'. Līcuesa ixtatanūcu'tun na ixchic Jasón. Ixtamāxtucu'tun Pablo ē Silas ē ixcālīmincu'tuncan na ixlacatīnca'n tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Jā cāmaclaca ē sakalē'nca Jasón ē makapitzīn huampala tā'timīn. Talē'ni'lh scujnī'n ē palha' cāhuanica: ―Tzamā' chi'xcuhuī'n tamāmakchuyīnī't ixlīpō'ktu tachi'xcuhuī't nac cā'quilhtamacuj. Nā taminī't huā'tzā'. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jasón cāmānūlh na ixchic. Xlaca'n jā talakachi'xcuhuī' ixlīmāpa'ksīn César. Xlaca'n tahuan a'nampala chā'tin rey ixtacuhuīni' Jesús. Xlaca'n talacasqui'n ū'tza' huā'mā' nalakachi'xcuhuī'can. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","A'cxni' takexmatli huā'mā', tatamakchuyīlh tachi'xcuhuī't ē scujnī'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","A'cxni' cālacāxtlahuaca, taxokolh macsti'na'j ē makxtekca Jasón ē ā'makapitzīn. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Palaj tunca tzamā' tzī'sa tā'timīn tamacā'lh Pablo ē Silas nac Berea. A'cxni' tachā'lh, tatanūlh na ixtemploca'n israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Tzamā' israelitas xalanī'n nac Berea tzej ixtalacapāstacna'n ē jā chī xalanī'n nac Tesalónica. Ixtakexmatcu'tun xatze tachihuīn ē lakalī lakalī ixtaputzana'ni' na ixtachihuīn Dios palh ixlīcāna' tū huanli Pablo. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Chuntza' ta'a'ka'ī'lh lhūhua' tī israelitas ē nā tī jā israelitas. Ixlīlhūhua'ca'n tī jā israelitas, lhūhua' puscan xalaka'tla' ē lhūhua' chi'xcuhuī'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","A'cxni' israelitas xalanī'n nac Tesalónica taca'tzīlh Pablo ixcālītā'chihuīna'mā'lh nac Berea ixtachihuīn Dios, ē xlaca'n ta'a'lh a'ntza'. Cāchihuīna'makasītzī'ca tachi'xcuhuī't xalanī'n nac Berea tī jā ixta'a'ka'ī'. Xlaca'n tatā'kaquī'lh. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Palaj tunca tā'timīn tamacā'lh Pablo na ixquilhtūn mar. Silas ē Timoteo tatachokolh nac Berea. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Tī tatā'a'lh Pablo talē'lh nac cā'lacchicni' Atenas ē tataspi'tli nacāmāca'tzīnīcan Silas ē Timoteo catalaka'lh Pablo palaj tunca. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pablo ixcāka'lhīmā'lh Silas ē Timoteo nac Atenas. Tamakchuyīlh ixpālacata laktzī'lh tzamā' cā'lacchicni' ixlītzumakō' ídolos. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Lakalī lakalī ixcātā'lāhuanimā'lh nac templo israelitas ē tī ixtalakachi'xcuhuī' Dios. Lakalī lakalī ixcātā'lāhuani nac lītamāuj tī ixtachā'n a'ntza'. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Tatā'chihuīna'nli ā'makapitzīn tī lakskalalhna' chi'xcuhuī'n. Makapitzīn ū'tunu'n ixtastālani' ixtamāsu'yunca'n tī ixcāhuanican epicúreos. Ā'makapitzīn ixtastālani' ixtamāsu'yunca'n estoicos. Makapitzīn tahuanli: ―¿Tū māsu'yumā'lh tzamā' chi'xcu' tī chihuīna'n? Ā'makapitzīn tahuanli: ―Huā'mā māsu'yumā'lh ixdiosesca'n makatiyātī'n. Tahuanli huā'mā' ixpālacata Pablo ixcālīmāsu'yuni' Jesús ē chī nalīlacastālancuana'ncan. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Chi'paca Pablo ē lē'nca nac Areópago jā ixtatalacxtimī makapitzīn scujnī'n ē tahuanilh: ―Quina'n icca'tzīcu'tunāuj huā'mā' xasāsti' tachihuīn tū māsu'yu'ya'. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Hui'x ta'nī'ta' ē quilāmāsu'yuni'yāuj tū jā maktin ickexmatnī'tauj. Icca'tzīcu'tunāuj tūchu huanicu'tun huā'mā'. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ixlīpō'ktuca'n xalanī'n nac Atenas ē xamini' tī ixtahui'lāna'lh a'ntza', xlaca'n jā tū ixtatlahuacu'tun xmān ixtahuancu'tun ē ixtakexmatcu'tun tū xalacsāsti'. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pablo ixyālh na ixlacatīnca'n tī ixtatakēstoknī't nac Areópago ē cāhuanilh: ―Chi'xcuhuī'n xalanī'n nac Atenas, hui'xina'n lakachi'xcuhuī'yā'tit mindiosesca'n. Chuntza' tasu'yu. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","A'cxni' ictētaxtulh, iclaktzī'lh tū laktaquilhpūtayā'tit hui'xina'n. A'ntza' icmaclalh a'ktin pūmacamāstā'n jā tatzo'kni' tzamā' tachihuīn: “Ixla' quindiosca'n tī jāna'j iclakapasāuj.” Quit iccātā'chihuīna'mā'n hui'xina'n ixpālacata huā'mā' Dios tī laktaquilhpūtayā'tit masqui jāna'j lakapasā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Dios tlahualh cā'quilhtamacuj ē ixlīpō'ktu tū a'nan. Xla' māpa'ksīkō' a'kapūn ē cā'quilhtamacuj. Xla' jā huī'lh nac templo jā xamacanī'tlahua. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Xla' jā maclacasqui'n tachi'xcuhuī't catamaktāyalh. Xla' jā tū sputni'. Ixlīmāpa'ksīn līhui'lāna'uj ē lījaxāna'nāuj ē pō'ktu līka'lhīyāuj. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’Dios līmātzumalh tachi'xcuhuī't ixlīpō'ktu cā'quilhtamacuj ixpālacata chā'tin chi'xcu' tī ixpapca'n ixlīpō'ktuca'n tachi'xcuhuī't. Dios cāmāsu'yuni'lh ixquilhtamacujca'n chī natalīlatama ē jāchu natatahui'la. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Xla' lacasqui'n naputzayāuj ē hua'chi namacaputzayāuj palh namaclayāuj Dios masqui huī'lh na quilacatzuna'jca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ixlīmāpa'ksīn līhui'lāna'uj quina'n ē līlatlā'huanāuj ē līlatā'kchokoyāuj. Chā'tin chī hui'xina'n tī lactzēhuanī't ixtachihuīn, ū'tza' huanli chuntza': “Nā quina'n ixlacstīn.” ");
INSERT INTO tkuNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Palh quina'n ixlacstīn Dios, jā capuhuanui Dios hua'chi oro ē plata ē chihuix tū cāxtlahualh chā'tin chi'xcu' xmān chī ixtalacapāstacni' xla'. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","A'cxni' jāna'j ixtaca'tzī tachi'xcuhuī't jā tū, Dios xmān cālaktzī'lh ē jā tū cātlahuani'lh. Chuhua'j cāmāpa'ksī Dios catalakpalīlh ixtalacapāstacni'ca'n ixlīpō'ktuca'n tachi'xcuhuī't calhāxcuhuālh nac cā'quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Dios līlacsacli' a'ktin quilhtamacuj a'cxni' nacāputzāna'nī ixlīpō'ktuca'n tachi'xcuhuī't xalanī'n nac cā'quilhtamacuj. Nacāputzāna'nī chuntza' chī ixlacasqui'nca. Dios lacsacnī't chā'tin chi'xcu', Jesucristo, tī nacāputzāna'nī tachi'xcuhuī't xalanī'n nac cā'quilhtamacuj. Huā'mā' tzej ca'tzīcan ixpālacata Dios mālacastālancuanīlh Jesucristo ―cāhuanilh Pablo. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","A'cxni' tachi'xcuhuī't takexmatli chī nalacastālancuana'ncan, makapitzīn tatzuculh talakapala. Ā'makapitzīn tahuanli: ―Na'iccākexmatni'yān ā'maktin ixpālacata huā'mā'. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Pablo cāmakxtekli. ");
INSERT INTO tkuNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ā'makapitzīn tatalacxtimīlh ē ta'a'ka'ī'lh. Nā a'ka'ī'lh Dionisio, chā'tin scujni' tī ixtatalacxtimī nac Areópago. Nā a'ka'ī'lh chā'tin puscāt tī ixuanican Dámaris ē ā'makapitzīn huampala. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ā'līstān Pablo taxtulh nac Atenas ē a'lh nac Corinto. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Tā'lāpāxtokli chā'tin israelita tī ixtacuhuīni' Aquila xala' nac Ponto. Xla' ē ixpuscāt, tī ixuanican Priscila, ixtataxtunī'tcus nac Italia. Xapuxcu' Claudio ixcāmāpa'ksīnī't ixlīpō'ktuca'n israelitas catataxtukō'lh nac Roma. Ū'tza' talītaxtulh Aquila ē Priscila. Pablo cālaka'lh. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","A'ntza' cātā'tachokolh ixpālacata ixtā'chuntza' ixtascujūtca'n ixuanī't. Ixtascuja ē ixtatlahua a'cchic. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Pablo ixcāmāsu'yuni' nac templo ixtzayama'jān ixlīpō'ktu quilhtamacuj tū ixpūjaxcan. Ixcāmā'a'ka'ī'nīcu'tun israelitas ē nā tī jā israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas ē Timoteo tataxtulh nac Macedonia ē tachā'lh nac Corinto. A'cxni' xlaca'n tachā'lh, Pablo ixmāsu'yumā'lh ixtachihuīn Dios. Ixcāhuanimā'lh tachi'xcuhuī't israelitas Jesús ū'tza' Cristo tī Dios ixlacsacnī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Xlaca'n tatā'lāhuanilh ē talakapalalh. Pablo tincxli ixlu'xu' na ixlacatīnca'n ē cāhuanilh: ―Hui'xina'n līpinā'tit cuenta tū nacā'a'kspulayān. Quit jātza' quincuenta. Chuhua'j na'iccālaka'n tī jā israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","A'lh ē chā'lh na ixchic tī ixuanican Justo. Xla' ixlakachi'xcuhuī' Dios. Ixka'lhī ixchic ixlacatzuna'j ixtemploca'n israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","A'ka'ī'lh Crispo, tī xapuxcu' xala' nac templo. Nā ta'a'ka'ī'kō'lh ixlīpō'ktuca'n xalanī'n na ixchic. Chuntza' chā'lhūhua' xalanī'n nac Corinto takexmatli tū huanli Pablo ē ta'a'ka'ī'lh ē ta'a'kpaxli. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Pablo lakachuyalh tzamā' tzī'sa. Māpa'ksīni' huanilh: ―Jā caji'cua'nti. Jā camakxtekti chihuīna'na'. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Quit icmaktaka'lhān. Jā tū catitlahuani'ca. A'nan lhūhua' tachi'xcuhuī't nac huā'mā' cā'lacchicni' tī naquintastālani'. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pablo tachokolh a'ktin cā'ta ā'i'tāt. Ixcāmāsu'yuni' ixtachihuīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","A'cxni' Galión ixlīgobernador ixuanī't nac Acaya, ē israelitas ixlīpō'ktuca'n ixtatā'lāquiclhlaktzī'n Pablo. Talē'lh jā ixtlahuacan justicia. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Tahuanilh gobernador: ―Huā'mā' chi'xcu' chihuīna'makasītzī' tachi'xcuhuī't. Xtum chī cāhuanī catalaktaquilhpūtalh Dios, ē jā chī tatzo'kni' na quilīmāpa'ksīnca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","A'cxni' Pablo ixchihuīna'ncu'tun, Galión cāhuanilh israelitas: ―Palh tlahuanī't cahuālh a'ktin tū jā tze, o palh maknīni'nī't cahuālh, quit xa'iccākexmatni'n līlacatzucu hui'xina'n, israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Hui'xina'n līmālacapū'yā'tit xmān tū māsu'yu ē a'ktin tacuhuīni' tū māpācuhuī ē tū milīmāpa'ksīnca'n. Hui'xina'n caputzāna'nī'tit. Quit jā icputzāna'nīcu'tun huā'mā'. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Cāmāxtulh jā ixtlahuacan justicia. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ixlīpō'ktuca'n talhūhua'chi'palh Sóstenes, tī xapuxcu' xala' nac templo, ē tatucsli na ixlacatīn gobernador. Galión jā tū cāhuanilh. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pablo tahui'lapālh ā'a'klhūhua' quilhtamacuj. Ā'līstān cāmakxtekli tā'timīn ē pū'a'lh barco nac Siria. Nā Priscila ē Aquila tatā'a'lh. Tā'ksitpūxtulh ē ū'tza' līmākentaxtūlh ixpromesa nac Cencrea. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","A'cxni' tachā'lh nac Efeso, Pablo a'ntza' cāmakxtekli. Tanūlh nac templo ē ixcātā'chihuīna'mā'lh israelitas tī ixtatakēstoknī't a'ntza'. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Tahuanilh Pablo ixtachokolh ā'chulā' a'ntza'. Pablo jātza' lacasqui'nli. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","A'cxni' cātā'lāmakxtekli Pablo cāhuanilh: ―Ixlacasqui'nca quit tunca na'ica'n nac Jerusalén jā nala cā'tani'. Na'ictaspi'tpala palh Dios lacasqui'n. Pablo taxtulh nac Efeso ē pū'a'lh barco. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Pablo chā'lh nac Cesarea ē a'lh nac Jerusalén ē cātā'chihuīna'nli tī ixta'a'ka'ī'nī't, ē a'lh tancā'n nac Antioquía. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Tachokolh a'klhūhua' quilhtamacuj ē taxtulh ē a'lh ē tētaxtutēlhalh nac a'katunu' cā'lacchicni' xala' nac Galacia ē Frigia. Ixcāmāhuixcānītēlha ixlīpō'ktuca'n tī ixta'a'ka'ī'nī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ixuī'lh chā'tin chi'xcu' israelita xala' nac Alejandría tī ixuanican Apolos. Xla' chā'lh nac Efeso. Huā'mā' chi'xcu' tzej ixchihuīna'n hua'chi tī ī'sca'tnī't. Tzej ixca'tzī ixtachihuīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Xla' ī'sca'tnī't ixlīmāpa'ksīn Dios. Līchihuīna'lh ixlītli'hui'qui. Tzej ixmāsu'yu ixpālacata Jesús, masqui ixca'tzī xmān ixlīmā'kpaxīn Juan. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolos tzuculh chihuīna'n na ixtemploca'n israelitas ē jā ixjicua'n. Priscila ē Aquila takexmatli ē talē'lh ā'lacatin ē ā'chulā' tzej tamāsu'yuni'lh ixpālacata Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolos ixa'ncu'tun nac Acaya. Tā'timīn tahuanilh tzē na'a'n. Cāmacā'ni'ca a'ktin carta tā'timīn xalanī'n nac Acaya ē cāhuanica catamānūlh Apolos na ixchicca'n. A'cxni' chā'lh Apolos, lhūhua' cāmaktāyalh tī ixta'a'ka'ī'nī't ixpālacata ixtalakalhu'mān Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Lhūhua' līmāpa'ksīn Apolos ixcālītā'lāhuani israelitas ixlacatīnca'n ixlīpō'ktuca'n. Ē ixcāskāhuī'kō'. Ixmāsu'yu ixtachihuīn Dios chī Jesús chu ū'tza' Cristo tī Dios ixlacsacnī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","A'cxni' Apolos ixuī'lh nac Corinto, Pablo ixtētaxtunī'ttza' nac lacsti'na'j cā'lacchicni' nac cā'sipejni' ē chā'lh nac Efeso. A'ntza' cātā'lāpāxtokli ā'makapitzīn tī ixta'a'ka'īnī't ");
INSERT INTO tkuNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ē cākelhasqui'nīlh: ―¿Chā maktīni'ntit Espíritu Santo a'cxni' a'ka'ī'tit? Xlaca'n tahuanli: ―Jā maktin ickexmatnī'ta'uj palh māstā'can Espíritu Santo. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pablo cākelhasqui'nīlh: ―¿Tīchu cāmāsu'yuni'n na'a'kpaxā'tit? Xlaca'n takelhtīni'lh: ―Quina'n ica'kpaxui chuntza' chī ixquincāmāsu'yuni'yān Juan. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pablo cāhuanilh: ―A'cxni' ixmā'kpaxīni'n Juan ixcāhuani tachi'xcuhuī't: “Calakpalī'tit mintalacapāstacni'ca'n ē ca'a'ka'ī'tit tī namin ā'līstān.” Ū'tza' huanicu'tun Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","A'cxni' takexmatli huā'mā', talī'a'kpaxli na ixtacuhuīni' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","A'cxni' Pablo cā'a'cpūhui'līlh ixmacan, Espíritu Santo tanūlh na ixlīstacna'ca'n. Xlaca'n tachihuīna'nli xtum tachihuīn tū jā ixtaca'tzī, ē talīchihuīna'nli ixtachihuīn Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ixlīpō'ktuca'n xlaca'n hua'chi kelhacāujtu' chi'xcuhuī'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","A'ktu'tun mālhcuyu' Pablo ixtanū na ixtemploca'n israelitas ē ixmāsu'yu ē jā ixjicua'n. Ixcālītā'chihuīna'n ē ixcāmā'a'ka'ī'nīcu'tun chī māpa'ksīni'n Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Makapitzīn lacxumpin ixtahuanī't ē jā ixta'a'ka'ī'. Ixtalakapala xasāsti' tamāsu'yun na ixlacatīnca'n tachi'xcuhuī't. Pablo cā'a'kxtekmaka'lh ē cālē'lh tī ixta'a'ka'ī'. Ixchihuīna'n pō'ktu quilhtamacuj na ixpūscuela Tiranno. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Chuntza' hasta tlahualh a'ktu' cā'ta. Chuntza' takexmatli ixtachihuīn Māpa'ksīni' ixlīpō'ktuca'n xalanī'n nac Asia, tī israelitas ē nā tī jā israelitas. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Dios mātlahuīlh Pablo laka'tla' lī'a'cnīn. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Pixtahua'ca' ē lu'xu' tū talītoklhli Pablo, ē a'cxni' talē'ni'lh ta'jatatlanī'n, cātapānūni'lh ixta'jatatca'n. Cāmāxtuni'ca tū jā tzeya ū'ni' tū ixtaka'lhī. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ixtahui'lāna'lh makapitzīn xantilhni' israelitas tī ixtalatlā'huan a'katunu' cā'lacchicni'. Xlaca'n, na ixtacuhuīni' Jesús, talīmāxtucu'tunli tū jā tzeya ū'ni'. Cāhuanica tū jā tzeya ū'ni': ―Iccālīmāpa'ksīyān hui'xina'n na ixtacuhuīni' Jesús, tū māsu'yumā'lh Pablo, cataxtutit. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Tī ixtatlahua huā'mā', xlaca'n kelhatojon ixka'hua'chan chā'tin israelita tī ixuanican Esceva tī xapuxcu' pālej. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","A'cxni' huanica chuntza', jā tzeya ū'ni' cākelhtīlh: ―Iclakapasa Jesús ē icca'tzī tīchu Pablo. Hui'xina'n jā iccālakapasān. ¿Tīchu hui'xina'n? ");
INSERT INTO tkuNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Chi'xcu' tī ixka'lhī jā tzeya ū'ni' cālaktu'jnunli ē ixka'lhī lītli'hui'qui ē cāskāhuī'lh xantilhni'. Xlaca'n tataxtulh nac chic ē tatzā'lalh maklhpi'mpi'lī'n ē tatakāhuī'nī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Taca'tzīkō'lh huā'mā' ixlīpō'ktuca'n xalanī'n nac Efeso, tī israelitas ē nā tī jā israelitas. Tajicua'nkō'lh. Chuntza' ā'chulā' tamāka'tlī'lh Māpa'ksīni' Jesús. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Lhūhua' tī ixta'a'ka'ī'nī'tcus tamilh ē tahuanilh Dios tū jā tze ixtatlahuanī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Lhūhua' ū'tunu'n, tī xantilhni' ixtahuanī't, tamākēstokli ixlibroca'n ē talhcuyulh na ixlacatīnca'n ixlīlhūhua'. Tatlahualh ixcuentaca'n ē ixtaxokonī't i'tāt ciento mil tumīn xaplata. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ā'chulā' a'kahuanli ixtachihuīn Māpa'ksīni' ē ā'chulā' ixtasu'yutēlha ixlītli'hui'qui Dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","A'cxni' ixa'kspulanī'ttza' huā'mā', Pablo puhuanli natētaxtu nac estado Macedonia ē nac Acaya ē na'a'n nac Jerusalén. Pablo huanli: ―Pūla na'ica'n nac Jerusalén ē ā'līstān ixlacasqui'nca na'ica'n nac Roma. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Cāmacā'lh nac Macedonia chā'tu' ixmaktāyana', Timoteo ē Erasto. Pablo tachokolh a'klhūhua' quilhtamacuj nac Asia. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Tzamā' quilhtamacuj taka'lhīlh a'ktin tā'kslokon ixpālacata xatze tachihuīn. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ixuī'lh chā'tin chi'xcu' tī ixtacuhuīni' Demetrio. Xla' platero ixuanī't. Plata ixcālītlahua lacsti'na'j tū ixtemplo dios Diana. Demetrio ē tī ixtatā'scuja lhūhua' ixtalītlaja. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetrio cāmākēstokkō'lh ixlīpō'ktuca'n tī nā ū'tza' ixtalīscuja. Cāhuanilh: ―Chi'xcuhuī'n, hui'xina'n ca'tzīyā'tit huā'mā' tascujūt ū'tza' lītlajayāuj. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","¿Ē jā ca'tzīyā'tit o jā kexpa'tā'tit tū a'kspulamā'lh nac Efeso ē na ixlīpō'ktu nac Asia? Huā'mā' Pablo cāmā'a'ka'ī'nīnī't lhūhua' tachi'xcuhuī't. Cālakpalīni'lh ixtalacapāstacni'ca'n. Cāhuanī tū ixtamacanī'tlaujca'n chi'xcuhuī'n jā ū'tza' dios. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Quit icjicua'n tzamā' quintascujūtca'n nasputa ē jātza' cati'a'ka'ī'ca ixtemplo xaka'tla' quimpāxca'ttzī'ca'n Diana. Jātza' catihuanca palh ka'tla' Diana tū talaktaquilhpūta chuhua'j xalanī'n nac Asia ē ixlīpō'ktu cā'quilhtamacuj ―cāhuanilh Demetrio. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","A'cxni' takexmatli huā'mā', tasītzī'lh ē tata'salh ē tahuanli: ―¡Ka'tla' Diana, quimpāxca'ttzī'ca'n quina'n tī xalanī'n nac Efeso! ");
INSERT INTO tkuNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Palaj tunca tasītzī'lh ixlīpō'ktuca'n xalanī'n nac Efeso. Cāchi'paca Gayo ē Aristarco ē cāsakalē'nca jā ixtatakēstokmā'nalh. Tzamā' chā'tu' chi'xcuhuī'n xalanī'n nac Macedonia ixtatā'scuja Pablo. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pablo ixtanūcu'tun na ixlacpu'na'i'tātca'n tachi'xcuhuī't. Tā'timīn jā tamakxtekli. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Makapitzīn scujnī'n xalanī'n nac estado Asia, xlaca'n ixamigo Pablo ixtahuanī't. Tahuanilh jā ca'a'lh nac pūtastokni'. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Makapitzīn a'ntza' jā ixtatakēstoknī't tata'salh palha' ē tahuanli catūhuālh. Ā'makapitzīn huampala tahuampālh xtum. Chuntza' tatamakchuyīkō'lh ixlīpō'ktuca'n jā ixtatakēstoknī't. Jā ixtaca'tzī ixlīlhūhua' tūchu ixpālacata ixtalītakēstoknī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Māxtuca Alejandro ixlacpu'na'i'tātca'n ixlīlhūhua'. Israelitas ta'a'clhta'ncslē'lh na ixlacatīnca'n. Alejandro cāmacahuani'lh cataquilhca'cslalh. Xla' ixtamaktāyacu'tun na ixlacatīnca'n tachi'xcuhuī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","A'cxni' ca'tzīca palh xla' israelita ixuanī't, tata'salh lacxtim chī a'ktu' hora ē tahuanli: ―¡Ka'tla' Diana, quimpāxca'ttzī'ca'n quina'n tī xalanī'n nac Efeso! ");
INSERT INTO tkuNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","A'cxni' secretario ixcāmāquilhca'cslīnī'ttza' ixlīlhūhua', xla' huanli: ―Iccāhuaniyān chi'xcuhuī'n xalanī'n nac Efeso. Tzamā' quincā'lacchicni'ca'n ū'tza' xamaktaka'lhna' ixtemplo xaka'tla' Diana, quimpāxca'ttzī'ca'n, ē nā ixídolo tū mincha' nac a'kapūn. ¿Ē huī'lh tī jā ca'tzī huā'mā'? ");
INSERT INTO tkuNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Jāla catihuanca jā ixlīcāna' huā'mā'. Chuntza' hui'xina'n caquilhca'csla'tit ē tzej calacapāstactit tū tlahua'yā'tit. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Hui'xina'n cālīta'nī'ta'ntit huā'tzā' tzamā' chi'xcuhuī'n. Xlaca'n jā tū tatlahuani'nī't tzamā' quimpāxca'ttzī'ca'n ē jā talīchihuīna'nī't. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Palh Demetrio ē tī tatā'scuja talāmakasītzī'lh ā'makapitzīn, ū'tza' lī'a'nan pūchihuīn ē juez. Catamālacapū'lh. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Palh catūhuālh talacasqui'n xlaca'n, cataputzāna'nīlh a'cxni' tatakēstokkō' scujnī'n natlahuacan justicia. ");
INSERT INTO tkuNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Quit icjicua'n naquincātalīmālacsu'yuyān tā'kaquī'lh ixpālacata tū a'kspulalhcus. ¿Chī nakelhtīni'nāuj quina'n palh naquincātakelhasqui'nīyān tū ixpālacata takēstoknī'ta'ntit ē ta'sapā'na'ntit? ");
INSERT INTO tkuNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Chuntza' lī'a'ksputli chihuīna'n secretario ē cāmacā'lh na ixchicca'n. ");
INSERT INTO tkuNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","A'cxni' taquilhca'cslakō'lhtza', Pablo cāmāta'satīnīni'lh tā'timīn. A'cxni' ixcāmaxquī'nī'ttza' talacapāstacni', cāmakxtekli ē taxtulh ē a'lh nac Macedonia. ");
INSERT INTO tkuNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","A'cxni' ixlatlā'huan nac Macedonia, ixcāmaxquī' talacapāstacni' tā'timīn. Ā'līstān chā'lh jā ixmāpa'ksīni'ntza' Grecia. ");
INSERT INTO tkuNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","A'ntza' ixuī'lh a'ktu'tun mālhcuyu'. Ixlacapāstacmā'lh na'a'n nac barco nac Siria. Israelitas ixtalīchihuīna'nī'ttza' natamaknī Pablo. Ū'tza' Pablo līlacpuhuampālh natētaxtu nac Macedonia. ");
INSERT INTO tkuNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Tatā'a'lh nac Asia, Sópater xala' nac Berea, ē Aristarco ē Segundo xalanī'n nac Tesalónica, ē Gayo xala' nac Derbe ē nā Timoteo. Nā tatā'a'lh Tíquico ē Trófimo xalanī'n nac Asia. ");
INSERT INTO tkuNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Tzamā' chi'xcuhuī'n xapūla tachā'lh nac cā'lacchicni' Troas ē a'ntza' quincātaka'lhīn. ");
INSERT INTO tkuNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Quina'n ictaxtūj nac Filipos a'cxni' a'ksputli cā'tani' a'cxni' ixua'can pāntzīn tū jā ixka'lhī levadura. Icpū'a'uj barco ē ixlī'a'kquitzis quilhtamacuj iccālakchā'uj nac Troas. A'ntza' ictahui'lauj a'ktojon quilhtamacuj. ");
INSERT INTO tkuNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Xapūla quilhtamacuj a'cxni' tanūlh semana, tatakēstokli tī ixta'a'ka'ī' natamāpitzī pāntzīn. Pablo cātā'chihuīna'nli. Xla' ixpuhuamā'lh palh na'a'n ixlīlakalī. Mālhmā'nīlh ixtachihuīn hasta i'tāt tzī'sa. ");
INSERT INTO tkuNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","A'ntza' jā xa'ictakēstoknī'ta'uj tālhmā'n na ixlī'a'ktu'tun piso nac chic. Lhūhua' pūcās ixua'ca'lh. ");
INSERT INTO tkuNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Chā'tin ka'hua'cha tī ixua